﻿USE sofia;
DROP TABLE IF EXISTS sofia.etr_vpl;
CREATE TABLE etr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES etr_vpl WRITE;
INSERT INTO etr_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Isilale udia dolö beaha aligilo gini maadeia, gudi mogelo amoliamu beaha nebegi, Yuda segea ami sege eso edefademalä maala sïdë i edefade gelola misi. Amala hamosebegi dolö Yuda fii afädë Bedeleheme ami sulo amo gäheo i odoa sege näiadodi Moaba namolö bobala asi. Dolö asi amoïe udiala ïe dolö malö äudä amola ili biyidia asi. ");
INSERT INTO etr_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Dolö amoïe ëida Elimelege, ïe udiada Naëomi, malö äudä amolele ëida Malonole Gilionole. Ili sosogoda Efalada, Yuda fiiïe gaamu edefade Bedeleheme dibea amilahilä Moaba namolö bobala asi. ");
INSERT INTO etr_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","5","Ili gäheo i nabülasi afädë gadoi ami nelo. Ami nea Elimelege baagoi. Baagosebegi Naëomila, ïe malö äudä amolali, hilido nelo. Hilido nea efegele äudä amolea Moaba udia amogi nii. Dolïsä äudä amolele ëida Obale Uludile. Ele neala ami salea Gilionole Malonole helegela ami baagoi. Egoage efegele äudä amolege baagoibua Naëomi hïdo ami sulo. ");
INSERT INTO etr_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naëomi e ami salea nabelebe Dafidilo Geloia ïe udia dolö neala obeägïlasila dafidi esoi dilo amo fisila molö naha dialeala säi amo nabi. Amo nabalahilä efege idia didalo äudä amola ili Moaba dïgïla moholöla daiai. ");
INSERT INTO etr_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Naëomila efege idia didalo äudä amolali segea ami sulo amo dïgïla, Yuda segea moholö afiai. ");
INSERT INTO etr_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Afiai amo afiahalea gaso, idiafa amila Naëomia efege idia äudä amolema sähalea, Alida hali segea diemebalä samolö obëgëmalo. Alia nemage baagoi amolimage mala hedabi hamosa nelo amo gadola Dafidilo Geloiage alima hedabi hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","10","Dafidilo Geloia ali ugila negemäia. Dolö elöma fimolö mosalo. Amala hamoseda, Dafidilo Geloia ali hedabola ugila negemolömelëla säla ïahagola säla ï. Amala säla ïaha nelolahilä, Naëomia udia äudä amole helegela neala mimilahilä, ali hä samialola säla ï. Amala säi amole udia äudä amolea dïisa nea Naëomima gelolafalï sähalea, Alïda made obëgëmolö. Dïe sosogo neebea di awäsego gadola nihïlïgïla moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Amala säsebegi, Naëomia säla obëgësalea, Nïe nidiwi ali-e, alida wila dofä hali mosöa obëgëmäiala helësësamelë. Nebaläda alida edo nea moholö. Ali nimäia na dolö malö elö sogobamolöi gabule. Alida mosöa bahïla obëgëmalo. ");
INSERT INTO etr_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Na walio gasigi dolö fila awäla malö äudä sogobalahilä amea ali nimäiale. Neda sesalebe made gabule. Ali hali segea bahïla obëgëmalo. Malö äudä amea ali nimäialahilä beaha samolöle. Elea ali nimäiala helësëla samolöle. Nïe nidiwi ali-e, Dafidilo Geloia nema edefade baagi ï amo gadola alimage amai amogi bobasësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Amala säi amo nabalahilä elea bu elö dïi. Dïisa nelolahilä Obaea egoame sali Naëomi gaula mimilahilä, mosalo, hawiola sälahilä hï segea obëgëi. Uludia egoame sali gaula nea, neda dofä obëgëmolö mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Amala säsebegi, Naëomia ema säla obëgësalea, Dïe disama amoda hä hïle sosogo neebeage hïle gode neebeage obëgëi amo gadola dige obëgëmalola säi. ");
INSERT INTO etr_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Amala säsebegi, Uludia säla obëgësalea, Dia ne bahïla obëgëmalola sämabu. Di awäsego gadola ne moholömelë. Di fisebea amige ne samolömelë. Di sosogo neebe amoge ne sosogo namolömelë. Dïe Gode neebe amoge nïe Gode namolömelë. ");
INSERT INTO etr_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Di baagosebea amige ne baagomolömelë. Baagosebea amida baumäiamelë. Baagoeamu alï neala hïdo hïdo hïdolasimäia. Na ado walio säi amo gadola made bëgëla hamoseda, Dafidilo Geloi edefade neebe amea nema yöi ïmäiamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Amala säsebegi, Naëomia beahamelebe, Uludia ebalä moholöla gelosebegi, ea ado säla made, ");
INSERT INTO etr_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","amilasilahilä udia äudä amole awäla Bedeleheme besela galai. Besela galasebegi, Bedeleheme udia dolö nefolalo amolia fudugilahilä udiafalï amolia sähalea, E! Goda Naëomi gabule ma, nowëla säi. ");
INSERT INTO etr_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Amala säsebegi, Naëomia säla obëgësalea, Nema Naëomila sämabu. Nema Malala sämo. Gode Edefade Sulubadelaïe Geloi neebe amea nema gamogai yafie hamola, nihïnege neala gamogalasimelë. ");
INSERT INTO etr_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Amo gala ne wila awähaleada, neda nelebo yafie nobai asi gaso, walio Dafidilo Geloia sigi obëgësaleada, memalä ne badumu misimelë. Gode Dafidilo Sulubadelaïe Geloi neebe amea yöi amo gadoi ï ameada edoïe nïe ëi Naëomila sämolö gabula säla ï. ");
INSERT INTO etr_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Goweda Naëomi efege idia Uludile Moaba sege dïgïla obëgëla misi amoïe ado dialea. Ele Bedeleheme ami besela galasolo amo gala eladi gadoi ëida bali dafidi sagai dilo amo mi gäwila damusa nebegi besela galai. ");
INSERT INTO etr_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Dolö dafidilo ëi sälo afädë amoïe ëida Boasa. Eda Naëomiïe egoa Elimelege baagoi amoïe sosogo fii afädëfalï nelo. ");
INSERT INTO etr_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Segeyo afädëgi Uludia Naëomima nabahalea, Na eladi gadoi ëi bali sagaia damulo neebe amolia damula hamoi hamosa neebea ami damui didigafui dibe amo misila audulela nabi. Afädëa ïe baagido hobeala misila aligi misialola sämolöla helësësamelëla säi. Amala säsebegi, Naëomia säla obëgësalea, Nïe nidiwi-e, dia amamalola säla ï. ");
INSERT INTO etr_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Amo nabalahilä Uludi e awäla hamoi hamolo amoli baagido hobeala eladi gadoi bali gägä neala gagaula awäha nelo. Eladi gadoi bali sagai dilo amoda Elimelege sosogo Boasaïe sagai dilo. ");
INSERT INTO etr_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Boasa hï e Bedeleheme nelolahilä maala besela galai. E besela galahalea ïe hamoi hamosa nefolalo amolima sähalea, Dafidilo Geloi e dilibalä namiäiamelëla säi. Amala säsebegi, ïe hamoi hamolo nefolalo amolia emage, dige Dafidilo Geloia ugila negemäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boasaea ïe hamoi sigi aligilo nelo amoma nabahalea, Udia dolïsä neebe gagoweda nowëla nabi. ");
INSERT INTO etr_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Amala nabasebegi, hamoi sigi aligilo amea säla obëgësalea, Udia dolïsä goda Moaba segeala Naëomibalä wi misi amo gabio. ");
INSERT INTO etr_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ea nema nabahalea, Hamoi hamolo dolö nefolalebego baagido eladi gadoi bali gägä didigafui difolalebe amo misila aligi hobeala mudulela nabasio. E yosefalï maala hamoi hamosamu nelo gaso, holöfalï hele fila awälahilä bu hamosa neagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Amala säsebegi, Boasaea ema sähalea, Udia dolïsä-o, sagai odoagi nofe dabiala auloeo. Gui udia hamoi hamolo nefolalebe go ilibalä eladi gadoi bali gägä gomu misisa namialo. ");
INSERT INTO etr_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Dolö hamoi hamose golia hamosego abidi hamosebelela fädäla bealahilä udiafalï golibalä gedola hamoi hahamola awäha namialo. Na dolö wi nefolalebe golima, dima nafade hamoloeola säimelë. Di ödä haläseda, ilia ödä iigi usi dië bimolömelë amogi mualola säi. ");
INSERT INTO etr_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Boasaea amala säsebegi, Uludia nagadaia gumusula dia idogolahilä ema sähalea, Dia nema mala hedabi go hamosegoda mi edoïe amaha. Neda sege wagadi made fii udia misi saleawela säi. ");
INSERT INTO etr_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Amala säsebegi, Boasaea säla obëgësalea, Dïe digua baagolahilä salea mala hedabi, diguamema hamoila säi amo nabimelë. Dia dïe dieme diadoge dïe segege dïgïla udia dolö dia dawa made beahage melëlo madebalä namolö misila säi amo nabimelë. ");
INSERT INTO etr_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Dia mala hedabi hamoi amoïe Godea dimage amo gadola hamomäia. Isilaleïe Dafidilo Geloi Godea dige amo gadola sigi neëgi, ïe augia hawa musügä namolö misi goïege bidi edefade nimäiamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Uludia säla obëgësalea, Dolö edefade-e, neda dïe hamoi hamolo udia sefolalebe amolibalä afädëdi made sulo amo, dia oböla, ado hedabi nebalä säse goeada, ne neala gelolasimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Molö molö fu besela galasebegi Boasaea Uludima bu sähalea, di guwi maala salea beledi wahalo gadoi difolalebe gowegi gelebi ödägi gela molö misiëla säi. Amala säsebegi, Uludi e hamoi hamolo amolibalä maala sebegi, Boasaea eladi gadoi bali gobei odoa amogi Uludi muäia neala ï. Ï amo naala bolesalea odoa fea digai. ");
INSERT INTO etr_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Uludi e molö naha maadelahilä awäla eladi gadoi bali amo bu misila aligi awäha nelo. Uludi e awäse amo gaalu, Boasaea ïe hamoi hamolo dolö amolima sähalea, Uludia eladi gadoi bali doboi dibeadi gogi nelea maaseda, ema nemomabio. ");
INSERT INTO etr_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Doboi dibea ami eladi gadoi bali gogi damusaleada odoa e neala gaumäia damula gui guila aligi mosalo. Amo neala gausegida dilia ema nimabula säloeola säi. ");
INSERT INTO etr_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Uludia eladi gadoi bali amo misisa nebegimu eso digala deadi. Ea misisa maadelahilä, e molöïe eladi gadoi bali amo dobila hedefala mogela negei. Amoïe yöida gilo nabülasi gadoi. ");
INSERT INTO etr_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Uludia eladi gadoi bali amo ägüla awäla mosöa egoamema olei. Esoa helesalea molö nahalea fea digai ägüi amoge egoamegali muäia neala ï. ");
INSERT INTO etr_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Amo gadola hamoi amo bealahilä, Naëomia Uludima nabahalea, Dia walio eladi gadoi bali misila hamoi hahamola awäha nelogoda, dolö nowëa sagaia hamosa nelola nabi. Dolö dima hedabi hamolo gomada, Godeïe obeägïlasiloea eege obeägïlasimäiamelëla säi. Amala sälebe, Uludia säla obëgësalea, na eladi gadoi bali sagaia hamoi hamosa nelo amoda, dolö afädë Boasaea sagaia hamosolomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ea amala säla ïasebegi, Naëomia sähalea, Dafidilo Geloi neebe ameada baagoi amolibaläge sebe welibaläge hamomolömelëla säla negei amoda asialo made neebe ameada Boasa eege obeägïlasimäiala sähawela säi. Naëomia bu sähalea, Boasa goda dofä nilï sosogofalï fii afädë neamelë. Alï fidila negemolöge beaha namolöge mala dibe amo gadolada dolö goea hamomolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Amala säsebegi, Uludia sähalea, Eage nema ado afädë gomalä säsio. Neda ïe hamoi hamolo udia amolibalä hamoi hahamola awäha nea, eladi gadoi bali ilia hamola wagasolo amo misila wagamalola säimelë. ");
INSERT INTO etr_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Amala sälebe, Naëomia Uludima sähalea, Nidiwi-e, säi go gadola wäla Boasaïe hamoi hamolo udia nefolalebegobalä gedola eladi gadoi bali, ïe sagaia guimu hamosa namialo. Dolö elöïe eladi gadoi bali sagaido nofe dabiala awäseda, di neala nafadelasimolö dië bimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Uludia Boasaïe hamoi hamolo nefolalo amolibalä eladi gadoi bali gägäge widi gägäge modoala dobola nelelegela awäha nelo amolia hamola wagala afiase amo gadola eage misila wagala asi. Uludi eda egoame sali amobalämu nelo. ");
INSERT INTO etr_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Segeyo afädëgi Naëomia Uludima sähalea, Naye, na dima ado afädë sähago. Dolöbalä hedabola fodögïla filo amo gadola fimäia, na dïe dolö afädë hogosamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Dia helësësebele. Eladi gadoi bali sagaia ïe hamoi hamolo udiafalï golibalä dilia hamoi hamolasisa nelo dolö amoda Boasamelë. Eda dofä nilï sosogofalï nea. E walio gasigi awäla eladi gadoi bali gägä amo dobisa namolömelë. ");
INSERT INTO etr_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Di nigime hëmalo. Amalahilä weli gafisigäi negelahilä fagulo hedabifalï salugamalo. Amalahilä eladi gadoi bali gägä dobisa neebea ami awäla Boasaea di melëloea musügä namialo. Ea hamoi hamosa maadela e molö ödäle muäia fu ïala namialo. ");
INSERT INTO etr_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Naha maadelahilä e diasebe amo abododi diasebelela fädäla bealahilä, ïe fagulo fïgï geleä gauia adala emo sëgëa ami midialo. Amala hamoseda gomalä hamomalola hï fädäla säla ïmolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Amala säsebegi, Uludia säla obëgësalea, Dia säsego gadola na hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Amala sälahilä, Uludia egoame salia hamomalola säi amo gadola hamosa maadelahilä, eladi gadoi bali gägä dobisa neebea ami asi. ");
INSERT INTO etr_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boasa e hamoi hamosa nelolahilä molö ödä mai. Naala asigi dusugala awäla salea hä süwiasebegi, eladi gadoi bali hedefala dobi nelegela fedai dilo amo agesugi ami adi. Amala adi dibegi, Uludi e geleä geleäla awäla Boasaïe fagulo fïgï dibe amo bidigi geleä gauia adala ïe emo sëgëa ami adi. ");
INSERT INTO etr_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Gasi mogogi Boasa e adi besusalea fudugila beahamelebe, udia afädë ïe emo sëgëa ami maala adi dibe melï. ");
INSERT INTO etr_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bealahilä ea nabahalea, Di nowë! A, Neda Uludi, dïe hamoi hamolo udia amomelë. Dïe fagulo bidia ne gesumäiamelëla säi. Amoïe mida, dida Elimelegeïe sosogofalï gabugi, dia ne sigi aligila ugila negemäiamelëla sähalea säi. ");
INSERT INTO etr_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boasaea amo nabalahilä Uludima sähalea, Nidiwi, Dafidilo Geloia dima hedabi hamomäia. Dia walio hamoi ameada dafidi hamosa nelo amo baagila awäla hedabi hïdo elöi hamoimelë. Malïsä yafie nefolalea. Odoa nelegei yafie negelo, odoa busadäoi, amoligi afädëa di nimäiala made helësëi gabu. ");
INSERT INTO etr_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Nidiwi-e, asigi säosäomabu. Udia dolö wi nefolalebe sulubadelaeada, dida udia hedabifalï saleala säha. Dia nema hamomäiala säsebe amoda, na hamosa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Dia säi amoda dofä. Neda digua baagoi amoïe sosogo. Na di beaha namolö gasoda, dolö di beaha namolöi afädë neamelë. Amomadale dafidi fädäla nabulö. ");
INSERT INTO etr_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Walioda gui wäla midialo. Diala aiyo yosefalï ne awäla dolö amea abilia säsebelela fädäla nabulömelë. Ea di sigi namolöla säseda, amo dofea. Ea haboimelëla säseda, Dafidilo Geloiïe ëigi nea sähawe. Sosogoea beaha aligilo mala dibe amo gadola hamomolöda nïe dibe amo gadola hamomolömelë. Walioda sege yomäia beahalea gui midialola säla ï. ");
INSERT INTO etr_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Uludi e Boasa dibea ami adi amo udia dolöea melëloeala helësëla Boasaea fodolofalï nowela yosefalï musügä mosalola säi amo gadola aabela nowei. Mida, e udia dolöea made bimäia. ");
INSERT INTO etr_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Nowesebegi, Boasaea ema sähalea, Dia fagulo go idogoi fösimola säi. Amo gadola Uludia fösisebegi, Boasaea eladi gadoi bali gägä amogi adu äudä ï, amoïe yöida gilo nabülasi äudä gadoi amo ägümalai. Uludia bali gägä amo ägümäia Boasaea nigila ägüsi. Uludi e amo ägüla asi baagido Boasa e Bedeleheme gaamugi asi. ");
INSERT INTO etr_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Obëgëla awäla egoame sali mosöa sebea ami besela galasebegi, egoame sali amea nabahalea, Nidiwi, gelola abilia hamoila nabi. Amala nabasebegi, Uludia Boasaea säi amoge hamoi amoge hulu sulubadela säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ea säla wagahalea sähalea, Boasaea di sebea obëgësalea memalä ne badumu obëgëmäiala made beasila, eladi gadoi bali gägä adu äudä ï ägüi amo gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Amala säsebegi, Naëomia Uludima sähalea, Nafege udia, di holöfalï beaha samialo. Walio Boasaea hamosebego abilia hamola dafogäsebelela bimolömelë. Boasaea abilia hamogimolöi walebelela bimolöïe idi hogosamu nea. Beagolese amo gadolada e hele samolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boasa e awäla udia dolö gedolo segea nogila digalo idiafa ami sulo. E fii heleia made Elimelegeïe sosogo elö säi amo maaha neebe melï. Boasaea dolö amoma sähalea, Ae, nedoo, na dima ado holöfalï afädë sädeläla di gui samolö misië säi. Dolö amo maala sebegi ");
INSERT INTO etr_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boasaea segea ami dolö beaha aligilo nabülasi nefolalo amoli maala fifigimalola säi. Amala säsebegi, ili maala sefolalo. ");
INSERT INTO etr_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ea ïe sosogo amoma sähalea, Naëomi Moaba asi nelo amo bahïla misi saleamelë. Eada alïle sosogo Elimelegeïe sege nalä amo dolö afädëa nimäiala helësësaleamelë. ");
INSERT INTO etr_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Amaimo, dia helësëmäia säla ïahago. Sege amo dia nimolö helësëseda, beaha aligilo nabülasi sefolalebe gowe ilile siigi sämo. Neda di baagia gabugi sege amo dia nimäia. Made nimolö galëda, haboila sämola säi. Amala säla ïasebegi, dolö amea säla obëgësalea, Sege amo na nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Amalebe Boasaea ema sähalea, Dia Naëomiïe sege nimolö galëda, Moaba udia Malonoïe udia didalo Uludige digali nimalo. Amalahilä sege amoda baagoi amoïe sosogoïe ëigi diamiäiala säi. ");
INSERT INTO etr_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ea ado amala sälebe dolö amea sähalea, Dofä, sege amoda nïe. Gaso, na neaseda, sege amo nïe malöïe made diamolö gabugi, na made nimolö ne haboimelë. Dihï helësëse amo gadola hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Siiba Isilale ilile malada gowe gadola hamolo negei. Udia didaloïe ado sähaleage, amase, sege nalä nimolöïe ado sähaleage, amogi bidigi bu made sämolö wagahagola säla ulufahalea, emo usililo giila bidi nelo dolö amogali ïlo negei.) ");
INSERT INTO etr_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Dolö amea Boasama, dia bidia nimalola säla, ïe emo usililo amo giila egali ï. ");
INSERT INTO etr_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Amala ïasebegi, Boasaea beaha aligilo nabülasi sefolalo amolimage, udia dolö odoa maala sefolalo amolimage sähalea, Dili sulubadela sefolalebeweïe sidaia sähago. Elimelegeïe segege nelegei dafidi dilo amoge, amase, malö äudä Malonole Gilionolele segege nelegei dilo amoge Naëomia beaha nelo nelebo amoda na neahawe. ");
INSERT INTO etr_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Amase, Moaba udia Uludida Malono baagoi amoïe udia didalo sulo amoge na neahawe. Amala hamosebeweada baagosalea sege nalä dibe amoda Malono hïle ëigimu ïe sosogoïe diamiäia. Baagoi amoïe sosogo afädë sebe amoliada ïe ëi amo helësësa namiäiamelë. Na walio säi amoda diliage nabala siiage beala helësësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Amala säsebegi, dolö nabülasi sefolalo amoliage, udia dolö bea misi sefolalo amoli sulubadelaea sähalea, Ä, nilï sulubadelaea beala helësësamelë. Udia go dïe mosöa awäseda, Dafidilo Geloia ugila negesegi nilïle Isilaleïe naye mäu Eleselole Eleale gadoi samiäiamelë. Elea malö malei sogobai amo gadola udia goeage malö malei sogobamolömelë. Amase, dihïdida Efalada sosogo amoïe ëi sälo nea, Bedeleheme udia dolö beaha aligilo dafidilo namolömelë. ");
INSERT INTO etr_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Dafidilo Geloia dolïsä go alima aligila malö ägüsebe ameada Yuda Damalalea malö sogobai nilïle mäu Felese sosogo gadoi di sosogo namiäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Segeyo amo gala Uludi nealahilä Boasaïe udia salea. Dafidilo Geloia ele neala obeägïlasila Uludi e fagulo hagui sebe melï. Amalahilä ea dolö malö afädë neegela ägüi. ");
INSERT INTO etr_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Udia sefolalo amolia Naëomima säla ïahalea, Dafidilo Geloiïe ëi gauia adadi. Ea di dihïdo samiäiala fisigisila made. Dïe diaye afädë di beaha namiäia ï gabumelë. Malö goeada Isilale udia dolö beaha aligilo dafidilo namolömelë. ");
INSERT INTO etr_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Diefege udiaea dima boba hamosebegoeada dia dolö malö gifalädalïa gadoi sogobai amai galebeda, amolima boba hamolabio amoda gidogolahilä, dïe diefege idiaea dima boba hamoi gabugo. Amaimo, ea malö walio ägüi goeada di gelolasila, sigi aligila beaha aliligi awäha nea, di udia sali hamomolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naëomia malö dubo amo sogobala fufuia alogola nea obëbësa nelo. Amalahilä malö amoda Naëomia beaha nelo. ");
INSERT INTO etr_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Udia ga made sefolalo amolia säla sogosalea, Naëomigali dolö malö afädë sogobala ï gabuwela säi. Amala sälahilä malö amoïe ëi Obedi negei. Hobeala Obediïe malöda, Yesi, Yesiïe malöda Debidi. ");
INSERT INTO etr_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Goweda Felese sosogo awäha nea Debidi besela galai amo dialea. Feleseïe malöda Hesolono. Hesolonoïe malöda Alama. Alamaïe malöda Aminadaba. Aminadabaïe malöda Nasono. Nasonoïe malöda Salomono. Salomonoïe malöda Boasa. Boasaïe malöda Obedi. Obediïe malöda Yesi. Yesiïe malöda Debidi. Amala fifi misi dialea. Hä amo. ");
INSERT INTO etr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dëdëla negei difolalebe golida, Yesu Gelesoïe yaua mäu aliligi misi amolile ëi dialea. Yesu Gelesoïe yaua mäuda Abalahamale Debidile nelo. ");
INSERT INTO etr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahamaïe malöda Aisaga. Aisagaïe malöda Yeigaba. Yeigabaïe malöda Yuda, ïe edoolali nefolalo amoli. ");
INSERT INTO etr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaïe malöda Felesele Selale. Elele emeda Damala. Amase, Feleseïe malöda Hesolono. Hesolonoïe malöda Alama. ");
INSERT INTO etr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamaïe malöda Aminadaba. Aminadabaïe malöda Nasono. Nasonoïe malöda Salomono. Amase, ");
INSERT INTO etr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomonoïe malöda Boasa. Boasaïe emeda Eleihaba. Boasaïe malöda Obedi. Obediïe emeda Uludi. Obediïe malöda Yesi. Amase, ");
INSERT INTO etr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesiïe malöda beaha aligilo Gini Debidi. Debidiïe malöda Solomono. Dafidi Solomonoïe emeda Uliaïe udia sulo. ");
INSERT INTO etr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonoïe malöda Elehoboama. Elehoboamaïe malöda Abia. Abiaïe malöda Asa. ");
INSERT INTO etr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaïe malöda Yehosafada. Yehosafadaïe malöda Yeholama. Yeholamaïe malöda Usia. ");
INSERT INTO etr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiaïe malöda Yodama. Yodamaïe malöda Ahasa. Ahasaïe malöda Hesegia. ");
INSERT INTO etr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesegiaïe malöda Manasa. Manasaïe malöda Amono. Amonoïe malöda Yosaea. ");
INSERT INTO etr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaeaïe malöda Yehoiagini, ïe edoolali nefolalo amoli. Amo gaaluda, Isilale ili sigi awäla Babilonomu gala digi nefolalo amo. ");
INSERT INTO etr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ili Babilonomu gala digi nefolaloa amilada, Yehoiaginiïe malöda Sealadiele. Sealadieleïe malöda Selubabele. ");
INSERT INTO etr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabeleïe malöda Abiuda. Abiudaïe malöda Eliagimi. Eliagimiïe malöda Asolo. ");
INSERT INTO etr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoloïe malöda Sadogo. Sadogoïe malöda Agima. Agimaïe malöda Eliudi. ");
INSERT INTO etr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudiïe malöda Eleasala. Eleasalaïe malöda Madani. Madaniïe malöda Yeigaba. ");
INSERT INTO etr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yeigabaïe malöda Yosebe. Yosebeda Meliïe egoa. Meliada Yesu neegela ägüi. Yesumada Gelesola sälo amo. Amala aliligi misi. ");
INSERT INTO etr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ëi amolida Abalahama neloa amila maala Debidi neloa amilada damo silasi nelo. Debidilahilä Isilale udia dolö ili Babilonomu gala digia amilage damo silasi nelo. Oböla Babilono gala digia amila Afädë Memelei e misia amilage damo silasimu nelo. ");
INSERT INTO etr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Geleso ägüla maasolo amo galada, gomalä hamoi. Ïe eme Meli eda Yosebegali olei sulo. Yosebea, aso, made neala sebegi, Eleloi Gesamia malö dubo ï amo, ili sefolalo amolia beagolei. ");
INSERT INTO etr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Egoa Yosebe eda dolö mogoi ameada, udia dolö nefolalebe amolia Meli e hewalasiloea, eada Meli geleä musügä fisimolöla helësësa nelo. ");
INSERT INTO etr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amala helësëla, e adi simasia beahaleamelebe, Dafidilo Geloiïe selesaia fii afädë ulufadigilahilä, Yosebema ado säla ïahalea, Debidiïe malö Yosebe-e, Meli dïe udia samiäia nimolö amoda bedämabio. E fagulo hagui sebe amoda Eleloi Gesamia negesimelë. ");
INSERT INTO etr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eada dolö malö afädë neegela ägümolömelë. Neegela ägülahilä, ïe ëi Yesu negemalo. Mida, ea ïe udia dolö nafade hamoi amoli hëla fisila damula moholömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dafidi, Dafidilo Geloia ïe bea säloma aligila bea säla negei amo gadola gausiala digamolöïe, nelebo sulubadela amala hamoi. ");
INSERT INTO etr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Bea säla negei amoda gowe. Dolïsä dolöbalä made nawelo afädëa fagulo hagui sulolahilä, dolö malö neegela ägümolömelë. Malö amoïe ëi Emanuale negemolömelëla säla dëdëla negei dialea. Ëi amoïe mida gomalä, Gode nilïbalä nea. ");
INSERT INTO etr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosebe adi nowela awälahilä, Dafidilo Geloiïe selesaia fiia ema ado säi amo gadola bëgëla, ea Meli nii. ");
INSERT INTO etr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Neasebegi, Melia malö made ägüla maala saleada, Yosebebalä made nawela sulo. Giso ägüla maasebegida, Yosebea malö amoïe ëi Yesu negei. ");
INSERT INTO etr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heledo eda beaha aligilo gini nelo amo gaalu, Yudia segea gaamu afädë ëi Bedeleheme ami Melia Yesu neegela ägüi. Ägüsebegi, dolö odoa gasumilï melëlo mala dawadigi nefolalo amoli sege wagadi made eso maasidola maala Yalusaleme besela galai. ");
INSERT INTO etr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Besela galalahilä, ilia sähalea, Yu udia dolöïe beaha aligilo gini namolöïe malö dubo neegela ägüi amoda, abidi dialea. Ïe gasumilï eso maasido neebe amo bealahilä, nilïa ïe ëi gauia adamolö mofiaimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ado amala säi amo nabalahilä, beaha aligilo Gini Heledo e asigi säosäosa nelo. Amase, Yalusaleme ami nefolalo amoli sulubadelaeage, amalamu helësësa nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Säosäolahilä, Heledoea Yu udia dolöïe gobela ïlo busa nefolalo amolige, amase, mala dawadigi nefolalo amolige gegedomalolahilä, ilima nabahalea, Afädë Memelei amoda sege abidi neegela ägümolöla nabi. ");
INSERT INTO etr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Amala nabasebegi, ilia säla obëgësalea, Yudia segeamadi gaamu afädë ëi Bedelehememelëla säi. Amala säsebe amoïe mida, bea sälo nelo amea säla dëdëla negei dibe amoda gowe. ");
INSERT INTO etr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Bedelehemee, Yuda sege dibe amogida, dida Yuda segeïe gaamu ilibia edefade difolalebe amoli hawa made. Dige sege edefademelë. Amoïe mida, dima aligila beaha aligilo afädë besela galamolömelë. Eada sugua sibi sigi aligilo amo gadola, nïe Isilale udia dolö sigi namolömelëla säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Amala säi amo nabalahilä, Heledoea geleä musügä dolö dawadigi eso maasidola mofiai amoli welahilä, ea ilima fädäla nabahalea, dilia gasumilï amoda abola melïla nabi. ");
INSERT INTO etr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nabala, ili Bedeleheme mosalolahilä, ea ilima sähalea, Dilia malö amo hedabolafalï hogolahilä beagoleseda, nage ïe ëi gauia adamolö moholöïe nema säla ïïa wegi obëgëmalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Gini amea amala säi amo nabala, ili afiaha dibegi, gasumilï dafidi eso maasido melï amo dafidi awäla, malö dibea ami aumala aligisi. ");
INSERT INTO etr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ilia gasumilï amo bealahilä, ilile iso asigigila edefademalä obeägïmolö besela galai. ");
INSERT INTO etr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aumala aligisi neebe amo bealahilä, dolö amoli mosö afädë neebe amoïe mumusogi nogila digai. Digalahilä, ilia malöge ïe eme Melige bealahilä, gumusula dia digala sefolalea, malö amoïe ëi gauia adaha sefolalo. Amalahilä, ilia igi gologe, i heale gobesegi höba gafisigä hedabi baëla aligilo amoge, amase, i afädëïe heale sïgä gäha made misiäia hëlo ëi muwege, galu amoli ägüi amo somodala Yesugali ï. ");
INSERT INTO etr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Amo somodala ïalahilä, ili hili segea obëgësaleada, ili misi idigi made, idi elögi obëgëi. Amoïe mida, ilia simasia beahaleamelebe, Godea ilima sähalea, Heledo neebeamadida obëgëmabiola säi amo nabala. ");
INSERT INTO etr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dawadigi dolö amoli afiaibua, Yosebea simasia beahaleamelebe, Dafidilo Geloiïe selesaia fii afädë maala ulufadigilahilä sähalea, Di nowela malöle emele sigi, dili fisäla Isibi mosalo. Awäla neëgi, na dima bu elö säla ïmolöïe ami beaha namialo. Mida, Heledoea malö go nufudadigimolöïe hogomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Amala säsebegi, Yosebe nowela malöle emele sigi, gasigi fisäla Isibi asi. ");
INSERT INTO etr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Isibi awälahilä, eda Heledo baagomäialahilä Isibimu nelo. Amoda dafidi Dafidilo Geloia ïe bea säloma aligila bea säla negei amo gausiala digamolöïe, amala hamoi. Bea säla negei amoda gowe. Nïe nafege Isibi segeala na weimelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heledoeada dolö dawadigi amolia e gadiaboi gabula helësëlahilä, e edefademalä mihaläi. Edefademalä mihalälahilä, Bedeleheme amige, amase, sege Bedeleheme ga madela sebea amige, dolö malësä gäheo i äudä sulo amolige, gäheo i äudä, aso, made baagi sulo amolige, sulubadela ea nufudaha maademalola säi. Dolö dawadigi amolia gasumilï mi gäwila neia idogoimelëla säla ï amo helësëla, amala nufualai. ");
INSERT INTO etr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Amo hamoi amoda bea sälo Yelemaeaea dafidi bea säla negei amo gausiala digai. Amoïe säla negei dibe amoda gowe. ");
INSERT INTO etr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Alama gaamugi ado afädë säsebe, ado amoda edefade didigaola dïisa neebe amoda nabaha nea. Eleseloea ïe malölaligi dïisebe amo. Ili hä maade amea, afädëa e neala adoea aeasisila made sämäiala helësësa saleala säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heledo baagoibua, Yosebe Isibi ami nea simasia beahaleamelebe, Dafidilo Geloiïe selesaia fii afädë maala ulufadigilahilä ");
INSERT INTO etr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ema sähalea, Di nowela malöle emele sigi Isilale segea mosalo. Mida, malö amo nufulöla helësësa nefolalo amolida, hä, baagosa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Amala säsebegi, Yosebe e nowela malöle emele sigi, Isilale segea obëgëi. ");
INSERT INTO etr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ili obëgësalea, Yosebea Agelausada ïe eedo bedefala Yudiaïe beaha aligilo gini neamelëla säi amo nabalahilä, eda ami obëgëmolö bedäi. Bedäla nebegi, ea simasia beahaleamelebe, Godea ema mosabiosebegi, e Galili awälahilä, ");
INSERT INTO etr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasalese gaamugi ami awäla sulo. Amala hamoi amoda bea sälo nefolalo amolia bea säla negesalea, Eda Nasalese fii neala sämolömelëla dafidi säla negei amo gausiala digai. ");
INSERT INTO etr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gäheo i odoa nelolahilä, ödägi gelo Yone e Yudiamadi sege nafade udia dolö aligisia made ami maala ulufalahilä, ado mala säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ea säla ïahalea, Hebeni Beaha Maadela Sigi Neebe amo ga made dibe amea, dili asigi besumalola säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Godea bea sälo Aisaeama aligila Yoneïe dafidi bea säla negesalea sähalea, Sege nafade udia dolö aligisia made ami nea, afädëa uuala wesalea, Dafidilo Geloi misiäia idi daiala hamogilasimalo. Ïe idida mogola fodolasimalola säha neamelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yone eda sugua gamele hilïa fagulo hamoi amo salugalahilä, sugua gafodo gadoia malibu negela nelo. Eada galiawage, äwi ödäge naha nelo. ");
INSERT INTO etr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Udia dolö Yalusalemelage, Yudia sege dibe amo sulubadelagilage, sege ödä Yodona ga made dibea amilage, Yone neebea maahamu nelo. ");
INSERT INTO etr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ilia nafade hamoi amo säla sisiasebegi, ea ili ödä Yodonagi gesa nelo. ");
INSERT INTO etr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Felesi dolö amolige, Sadiusi dolö amolige yafie Yonea ili ödägi gemäia maaha neebe amo bealahilä, ea ilima sähalea, Dilida säiabëïe malö gadoi nebego, Godea mihaläla së ïmolö amogi, fisäla doadigila moholömelëla dilima nowëa säla ïasio. ");
INSERT INTO etr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dili dofä asigi besuimelëla dilile mala olela, gägä ulufala negemalo. ");
INSERT INTO etr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dilia dihilidomu sähalea, Abalahamada nilïle mäu nelola sämolö dialeala helësëmabio. Na ado afädë säla ïahago. Nabuö! Godea igi difolalebe gowegi neala gaulahilä, Abalahamaïe yaua mäu hamolasimolöi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","I nefolalebe mia ami gabi negesisi dialea. I gägä hedabi made negelo nefolalebe amolida, sulubadela abalahilä, nulogi gobesa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nada dilia asigi besui amoïe ödäea ulufala gelasilomelë. Hobea ne baagia afädë moholö amoda, ne holöfalïmelë neebewe gadoi made, eda ilibia edefade neamelë. Na ïe emo usililo gaumolö dofea made neawe. Eada Eleloi Gesamiage, nulo söaeage dili gelasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Eada eladi gadoi ëi widiïe gägä dobilahilä, isole düle mogemäia nelebo gasala sadia adogolo nama gadoi afädë gaula nea. Mogesa maadelahilä, ea widi gägä amo negelo mosöa ami negesilahilä, ïe widi dobilo sege amo gëgelë doala digilahilä, dü fisi amoli nulo usilo made, wisamu neebea ami gobemolömelëla Yonea säi. ");
INSERT INTO etr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Segeyo amo gaalu, Yesu e Galilila ödä Yodona dibea ami maala, e Yonea ödägi gelasimäia misi. ");
INSERT INTO etr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Maasebegi, Yonea Yesuea oböla asigi bedefala ödägi made gemolöla sämäia, ea nabahalea, Dia ne ödägi gemolöi dialea gaso, na di ödägi gemäia, ne neebea misilela nabi. ");
INSERT INTO etr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Amala nabasebegi, Yesuea säla obëgësalea, Walio amala hamomäiamelë. Mala go hamosaleada, Godea hamesebe amoda hamosa maademolö dialeala säi. Amala säsebegi, Yonea ema üi. ");
INSERT INTO etr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yonea Yesu ödägi gei. Yesu ödägila agesua fodolo aliga adogoi amole, mu doga negelahilä, haea maliabu hagila digalo amo gadola, Godeïe Gesami digala edaia fisebe amo melï. ");
INSERT INTO etr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Amo gaalu, selesaia mosöala ado afädë säia idogosalea, Egoweda nïe malö, na boba hamosa neawe. Ema edefademalä obeägïsa neawela säi. ");
INSERT INTO etr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Amala hamosebegi, Godeïe Gesamia Yesu e sege nafade udia dolö aligisia made ami sigi fedala ifosi. Ifosi nebegi mugabe busaea Yesuea nafade hamomabelela fedogola bimolö misi. ");
INSERT INTO etr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu e segeyo nabülasi biyidia, gasi nabülasi biyidiala, molö made naala neamu, sïdëa baagoi nelo. ");
INSERT INTO etr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","E amala sïdëa baagoi nebegi, nafade hamomäia fedogola melëlo busa amo maalahilä sähalea, Di dofä Godeïe malö nea galëda, igi difolalebe gowema beledi hamomalamola säi. ");
INSERT INTO etr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amala säsebegi, Yesuea säla obëgësalea, Ado säla dëdëla negei dibe amea sähaleada, namolö ilo amoda molö nase amea udia dolögali namolö ïlo mademelë. Ado sulubadela Godeïe nafiala maase ameamu namolö nelola säi dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Amala säla obëgësebegi, mugabe busaea, Yesu sigi gaula Gode hïle nafolai gaamu Yalusaleme ami awäla, Godeïe mosöa ilibiafalï gadogo ifosilahilä, ");
INSERT INTO etr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ema sähalea, Di dofä Godeïe malö nea galëda, dia hä, wila nila sadia idogomo. Amoïe ado afädë säla dëdëla negei dibe amea sähaleada, igia dïe emo daualoea, Godea ïe selesaia fii amolima dïe säsisegi, ilile naaboea di sogobala gauia adogomalamolömelëla säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Amala säsebegi, Yesuea säla obëgësalea, Ado elö säi dibe ameada, gomalä säla dëdëla negei dialea. Dafidilo Geloi, dïe Gode neebe amo, fedogola bimabiola säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Amala säsebegi, mugabe busaea Yesu e segebi daia ga gadogo sigi fedalahilä, gädili dibe amo sulubadelage, ilile nelebo hedabi difolalebe amoge olesa maadei. ");
INSERT INTO etr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Olesa maadelahilä, ea Yesuma sähalea, Dia ne mia gumusula dia digalahilä, nïe ëi gauia adaseda, nelebo sulubadela beasebe egowelida, dia beaha namiäia ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Amala säsebegi, Yesuea säla obëgësalea, Saidani! Di moholöi mosö. Godeïe bebagi ado säi dibe amea sähaleada, Dafidilo Geloi, dïe Gode neebe amo, dia ïemu ëi gauia adogola ïemu hamoi hamomalola säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amala säla obëgësebegi, mugabe busaea Yesu dïgïla asi. Asibua, selesaia fii Yesu neebea maala, ilia e ugila negei. ");
INSERT INTO etr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yone e galabaia mosöa neala säi amo nabalahilä, Yesu e Galili segea obëgëi. ");
INSERT INTO etr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Obëgëla awälahilä, e Nasalese gaamugi ami made aligila, Gabaniama gaamugi namolö asi. Amoda, Galili oeabo edefade dibe amoïe agesua Gabaniama gaamugi ami namolö asi. Sege amoda Sebulunilele Nafadalilele sege dilo. ");
INSERT INTO etr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Amo hamoi amoïe Godea ïe bea sälo Aisaeama aligila, bea säla negei amo gausiala digai. ");
INSERT INTO etr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebuluni segege, Nafadali segege, ëi odoa, idi oeabo edefade dibeamadi amogi aulo sege dibe amoge, ödä Yodona dëgëla alomodi sege dibe amoge, amase, Disiligi Galili ami udia dolö fii odoa yafie maala sefolalebe sege amoge, Sebulunilele Nafadalilele segemu. ");
INSERT INTO etr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Segea ami, udia dolö gasimi sagai edefadegi nefolalo amoliada, yo digalo edefademalä melïmelë. Baagoloïe sege augi hawa nefolalo amolimada yo digala besela galaimelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Segeyo amo gaalu, Yesuea mi gäwila säla ïahalea, Hebeni Beaha Maadela Sigi Neebe amo ga made dibe ameada, dilia asigi besumalola säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu e Galili oeabo edefade dibe amoïe agesudilä awäha nea, ea seme digilo dolö äudä elowole ëole melï. Elöda Saimono, ïe ëi elöda Fida, ïe edoo Ädulule melï. Eleada oeabo edefade amogi seme digisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ele beala, Yesuea elema sähalea, Alia seme nelo amo gadola, udia dolö nimäia, na alima neala oleledelä. Ne bëgëla misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Amala säsebegi, elea elele selëgë amoli dïgïla, fodolofalï e bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Amila awähalea, ea edoole edoole elö neebe melï. Eleda Sebediïe malö Yamesele, ïe edoo Yonele, elele eedobalä ödä dudaia selëgë hamogisa neebe melï. Bealahilä, Yesuea ele wesebegi, ");
INSERT INTO etr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","elea ödä duge, eedoge dïgïla, fodolofalï Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuea Galili sege sulubadelagi nawesa neada, ilile gedolo mosöa säla olelesalea, Godea Beaha Maadela Sigi Neebe amoïe Ado Mala Hedabi säla olelela digi, udia dolö amoligi olo elö elöla oloi wahila digi, amase, domalo nalafadela nawei amoli sulubadela wahila didigisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Amala hamosa nelo amo, udia dolö Siliamadi nefolalo amoli sulubadelaea nabaha maadei. Nabalahilä, ilia udia dolö olo elö elöla oloi amolige, edefade sësa difolalo amolige, amase, mugabe fedai difolalo amolige, amulämei difolalo amolige, fii si sefolalo amolige, sulubadela neala gaula e neebea maasebegi, ea amoli wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Udia dolö yafie Galili amilage, Gaamu Nabülasimadilage, Yalusalemelage, Yudiamadilage, ödä Yodona näiado alömodilage, ilia e bëgëla afiai. ");
INSERT INTO etr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuea udia dolö yafie negegila nefolalebe amo bealahilä, e gau afädëgi fedala, segebidaia ami sulo. Amala sebegi, ïe bëgëla aulo amoli e sebea ami mafusebegi, ");
INSERT INTO etr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ea mi gäwila nafi dagala ilima säla olelesalea sähalea, ");
INSERT INTO etr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Odoaea asigigi helësësalea, nïe iso asigi dofea made gabula helësësa nefolalebe amolida, obeägïsa nea. Mida, Hebeni Beaha Maadela Sigi Neebe amoda ilile dialeamelë. ");
INSERT INTO etr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dïisa nefolalebe amolida, obeägïsa nea. Mida, Godea ili bobasëla aealasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hili nagadaiala aligilo nefolalebe amolida, obeägïsa nea. Mida, sege dibe amo sulubadela Godea iligali ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sïdëa baagosa neebe amolia molöle ödäle gelola hamese amo gadola, mala mogoi hamomolö gelola hamesebe amolida, obeägïsa nea. Mida, Godea ili neala nobalasisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Odoa bobasëla ugila negelo nefolalebe amolida, obeägïsa nea. Mida, Godea ili bobasëla ugila negemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Asigi gagadelai amolida, obeägïsa nea. Mida, ilia Gode bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Daluloïe hamoi hamosa nefolalebe amolida, obeägïsa nea. Mida, ilima Godeïe malö neala sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mala mogoi hamolo amoïe së naha nefolalebe amolida, obeägïsa nea. Mida, Hebeni Beaha Maadela Sigi Neebe amoda ilile dialeamelë. ");
INSERT INTO etr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dilia ne bëgëla mofiasebegoïe, dolö odoaea dili gagadesege, sëlasisege, ado nafade elö elöla wäfalï säsäla dili hololösege, mala amoli gadoi dilima hamoseda, dili obeägïsa nea. ");
INSERT INTO etr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dilia edefademalä obeägïsa namialo. Mida, selesaia mosöa dilile bidi edefade negei dialea. Dili maadeia, bea sälo dafidi nefolalo amoliage së amo gadola wäla naha nefolalomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesuea ado aso, sähamu neamu sähalea, Udia dolö sulubadelaïe ëbï gadoida, dili nebegomelë. Ëbïïe hëdälo amo hogosa heleseda, edoea bu hëdälasimolöi gabu. Ëbï nafade amo gadoida, iso gäwi madela, nagadaia sadia gasegi, udia dolöïe emoea daiasalomelë. ");
INSERT INTO etr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Udia dolö sege sulubadelagi nefolalebe amolile yo digalo gadoida, dili nebegomelë. Gaamu afädë segebidaia dibe amoda, hagumolöi made dialea. ");
INSERT INTO etr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Amase, afädëa gamali yola sagasilahilä, falo hawa negelo mademelë. Amala negelo made, aulidaia negesegi, mosö amogi difolalebe amoli yo digaha maadelo. ");
INSERT INTO etr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Amo gadola, dilile yo digalo udia dolöea bimäia, yo digalasimolö dialea. Dilia mala hedabi hamose amo beala, ilia, dilile Diado selesaia mosöa neebe amoïe ëi gauia adamäiala säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesuea ado aso, sähamu neamu sähalea, Mosese nebegi Ado säla negei amoge, bea sälo nefolalo amolia mala olelesa nelo amoge, na haila digimolöïe misi gabula helësëmabio. Na haila digimolöïe misi made. Ilia Ado säla negei amo gausiala digamolöïe ne misi neawe. ");
INSERT INTO etr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na dilima dofä sähago. Naga föige, mu giwige dibe amo gaalu, Mosese nebegi Ado säla negei dibe amogi ado damui afädëge, dudumu afädëge, dofä made hogosa helei. Ado dëdëla negei dibe amo gausiala digamäia, mala amo diamolöi diamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Amaimo, afädëa mala säla negei amogi, mala holöfalï afädë memalä gabula, damula, amase, odoaeage damumäia olelelo neebe amoda, Hebeni Beaha Maadela Sigi Neebea ami, emada dofä gidogofalï neala sämolömelë. Amo gadola made, afädëa mala säla negei amo gadola hamola, odoaeage hamomäia olelelo neebe amoda, Hebeni Beaha Maadela Sigi Neebea ami, emada ilibia edefadela sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Amai gabugi, na dilima ado afädë säla ïahago. Dilia mala mogoi hamomolö amoda, mala dawadigi nefolalebe amoliage, Felesi dolö nefolalebe amoliage hamolo amo gadola made, dilia ili baagila awäla made hamoseda, Hebeni Beaha Maadela Sigi Neebea ami dili dofä made nogila digamolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesuea ado aso, sähamu neamu sähalea, Siibafalï udia dolö nefolalo amolima ado sälo dilia nabelo amea sähaleada, Udia dolö baagomäia nufuabio. Afädëa amala hamoseda, gudimolö dië bimolömelëla sälo. ");
INSERT INTO etr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amai gaso, na dilima säla ïahago. Afädëa ïe edoobalä mihaläseda, gudimolö dië bimolömelë. Amase, afädëa ïe edooma dida dofea madela nolealeseda, Galïsolö dolö neebea ami sigi awäla gudimolömelë. Gasoda, afädëa ïe edooma dida nafadefalï asigi maade nebegola säseda, heli segea nulo gobei dibea ami moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Amaimo, dia nelebo ïmolöïe gobela ïlo aulidaia negemolö nea, dïe didooea dima nelebo afädëgi habobai neala helësëla obëgëseda, ");
INSERT INTO etr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hä, nelebo ïmolö gaui amoda, gobela ïlo auli ga made ami negesia, dafidi dïe didoo neebea dalumolö mosalo. Dalula asi obëgëlahilä, nelebo ïmolö negei amo ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ado nii dolö afädëa dibalä gudimolöïe awähala säseda, aso, gudimolö segea ami made besela galala, idiafa ebalädale fodolofalï hamogimalo. Gudimolöïe sigi awäseda, gudi mogelo dolö neebe amoma di gaula ïalahilä, mogelo dolö ameada di dadi gaui amolima ïalahilä, di galabaia mosöa ami ifosiloea. ");
INSERT INTO etr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na dima dofä sähago. Amala hamoseda, dia nafade hamoi amoïe bidi nelo amo gadola neaha maademäia, galabaia mosöa ifosi neamu, made moholömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesuea ado aso, sähamu nea sähalea, Ado säi dilia nabelo amea sähaleada, Udia dolö fa nimabiola sälo. ");
INSERT INTO etr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amai gaso, na dilima gomalä säla ïahago. Dolö afädëa udia siia beala gesami awäseda, udia amo hä asigia fa niimelë. ");
INSERT INTO etr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dïe si dafädi goea di neala digalasiseda, beselala sadia gamalo. Dïe domaloïe sosogo gogi afädë maade nea, namolöda dofea galea. Dïe domalo sulubadela aligisa maadei neëgida, heli segea sadia idogomolö amoda, nafade gabugi. ");
INSERT INTO etr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Amase, dïe naabo dafädi goea di neala digalasiseda, naabo amo damula sadia gamalo. Dïe domaloïe sosogo gogi afädë maade nea, namolöda dofea galea. Dïe domalo sulubadela aligisa maadei neëgida, heli segea moholö amoda, nafade gabugila säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesuea ado aso, sähamu nea sähalea, Ado elö sälo amoda gowe. Dolö afädëa ïe udia fisiseda, ea beba dëdëla, ïe udiama ïmolö dialeala säi gabio. ");
INSERT INTO etr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amai gaso, na dilima säla ïahago. Dolö afädëïe udiaea dolö elöbalä mala nafade hamoigi made, ïe udia amo fisiseda, ïe udia amea dolö fa nimäia fa nimalalasimelë. Dolö afädëa dolö elöïe udia memalä fisi amo neaseda, ameage udia amo fa nimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesuea ado aso, sähamu neamu sähalea, Siibafalï udia dolö nefolalo amolima ado sälo dilia nabelo amea sähaleada, Migalïa diigila ado gelola säla negei amoda, made fisila, Dafidilo Geloima migalïa diigila ado gelola säla negei amoda, hamomalola sälo. ");
INSERT INTO etr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amai gaso, na dilima säla ïahago. Migalïa diigila ado gelola säla negemabio. Mudaiala säla diigimabio. Mida, mudaiada Godeïe beaha aligilo filo dialeamelë. ");
INSERT INTO etr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Naga föigige säla diigimabio. Mida, naga föida Godeïe emoea emesaia idala filo dialeamelë. Amase, Yalusalemege säla diigimabio. Mida, Yalusalemeda beaha aligilo Gini Edefade neebe amoïe gaamumelë. ");
INSERT INTO etr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dihïle busa säla, migalïa diigila ado gelola säla negemabio. Mida, dia busa hilï afädë neala dihï falemolöige, yabumolöige ulïmelë. ");
INSERT INTO etr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Afädë hamomolö galëda, ü, ailemu sämalo. Ado odoage baala säseda, ado amo baala sälo amolida, mugabe busa nafadefalïmadila maasebe amo sähamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesuea ado aso, sähamu neamu sähalea, Ado säi dilia nabelo amea sähaleada, Afädëa elöïe si besela digiseda, ïe siige besela digilomelë. Amase, afädëa elöïe bese besela digiseda, ïe besege besela digilomelëla sälo. ");
INSERT INTO etr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amai gaso, na dilima säla ïahago. Afädëa dilima nafade hamoseda, dilia bu dabemabio. Afädëa dïe ba dafädimadi nufudaseda, ba näiadogoge olemalo. ");
INSERT INTO etr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Afädëa dibalä gudimolöïe di sigi awähalea, dïe fagulo sedi ïmola säseda, dïe gögï fagulo daia salugalo amo bu baala ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dolö afädëa dima gelola egedidigila ïe nelegei ägüla, di gilomida afädëgi mosalaseda, diada, oböla, gilomida äudägi mosalo. ");
INSERT INTO etr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Afädëa nelebo afädë ïmola säseda, hä egali ïmalo. Amase, afädëa hobea ïduläïe bidi negesagola säseda, auaula baagi ïmabiola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesuea ado aso, sähamu nea sähalea, Siiba ado sälo dilia nabelo amea sähaleada, Odoa dibalä nefolalebe amoli boba hamosaleada, dibalä ado nii nefolalebe amolibalä habobala namialola sälo. ");
INSERT INTO etr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amai gaso, na dilima gomalä säla ïahago. Dilibalä ado nii nefolalebe amolibalä boba hamolahilä, dili neala sëlasisa nefolalebe amoli hedabomäia, Godema adolasisa namialo. ");
INSERT INTO etr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ameada, dilile Diado selesaia mosöa neebe amoïe malö neala olemolömelë. Mida, eada nafade hamolomage, hedabi hamolomage, ïe eso neëlasilo neada, mala mogoi hamolomage, mala mogoi made hamolomage, sege digalasilo nea. ");
INSERT INTO etr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dili boba hamolo amolimu boba hamoseda, dilia bidi edo nimolö. Dagisi muni nelo nefolalebe amoliage amo gadola hamolo nea madele. ");
INSERT INTO etr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dilia dilile didoo amolimamu haeafula aeahaleada, odoada baagila aulole. Udia dolö Gode helësëlo made nefolalebe amoliage amo gadola hamolo nea madele. ");
INSERT INTO etr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amai galëda, dilile Diado selesaia mosöa mogoi hedabi neebe amo gadola, dilige mogoi hedabi namialola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesuea ado aso, sähamu nea sähalea, Dili hedabola. Gode helësëla mala hedabi hamosaleada, udia dolö nefolalebe amolile sidaia dili bimäiala, made hamomalo. Amala hamoseda, dilile Diado selesaia mosöa neebe amea diligali bidi ïmolö dibe amo ïmolöi made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Amaloea, gumusui nefolalebe amoligali nelebo afädë ïaseda, odoa ilile sidaia gugusämäiala gelola uuala säla ïmabio. Asigi fea negelo nefolalebe amolia ili bimäialahilä, gedolo mosöage, idiafage, odoaea ilile ëi gauia adamäia, amala hamolo nea. Na dilima dofä sähago. Amoïe bidida hä nii aguimelë. ");
INSERT INTO etr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amaimo, dilia afädë gumusui neebe amogali afädë ïahaleada, naabo dafädia hamosebe amo naabo fefeädia made bimäia, ");
INSERT INTO etr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","musügä ïmalo. Amala ïaseda, dilile Diadoea dili hïdo hïdolaea musügä hamose beaha neebe amea, diligali bidi ïmolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesuea ado aso, sähamu nea sähalea, Dili nefolalebegoea Godema adosaleada, udia dolö asigi fea negelo nefolalebe amolia hamolo amo gadola hamomabio. Ilile asigiada, udia dolö odoa nefolalebe amolia bimäialahilä, gedolo mosöage, idi edefade osogoloage, nowela nea Godema adomolömu hamelo nea. Na dilima dofä sähago. Amoïe bidida hä nii aguimelë. ");
INSERT INTO etr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amala hamolo amo gadola made, dilia Godema adomolö neada, dihilile mosö hogoli afädëgi nogila digala idi gala digilahilä, dilile Diado siia bimolöi made neebe amoma adomalo. Amala adoseda, dilile Diadoea dili hïdo hïdolaea musügä hamose beaha neebe amea, diligali bidi ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Dilia Godema adosaleada, udia dolö odoa Gode helësëlo made nefolalebe amolia memalä säla dabolo amo gadola sämabio. Amolia sedade olögöla adose ameada, Godea nabulöla helësëlo. ");
INSERT INTO etr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dilida ili gadoi namiabio. Dili nefolalebegoea nelebo sulubadela nimolöi amolida dilile Diadoma aso, adola made neëgi, dafidi eadale dawadigisa maadei neamelë. ");
INSERT INTO etr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dilia Godema gomalä adomalo. Nilïle Naado selesaia mosöa nebego, dïe ëi amo eleloi hïdo elöi namiäia hamesa. ");
INSERT INTO etr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dïe Beaha Maadela Sigi Neebe amoge misiäia hamesa neawe. Dia hamese amo, selesaia mosöa nefolalebe amolia hamolo amo gadola, nagadaia nefolalebe nilïage hamodelä hamesa neawe. ");
INSERT INTO etr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Segeyo walioïe molö molö amo, dia walio ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Odoa ilia nilïma asiala hamosegi fisilo amo gadola, diage nilïa nafade hamoi amoli hëla fisimalo. ");
INSERT INTO etr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nilï neebeawi fedogola bimolö made negesimalo. Mugabe busa nafadefalï neebe amoda, dia neala yolasimalo. ");
INSERT INTO etr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Amaimo, udia dolö odoaea dilima asiala hamoi amo hëla fisiseda, dilile Diado selesaia mosöa neebe amea dilia asiala hamoi amoge hëla fisimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gasoda, udia dolö odoaea dilima asiala hamoi amo made hëla fisiseda, dilile Diadoea dilia asiala hamoi amoge made hëla fisimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesuea ado aso, sähamu nea sähalea, Dilia Gode helësëla molö made naala neada, udia dolö odoa asigi fea negelo nefolalebe amolia odagi augia idala aligilo amo gadola namiabio. Udia dolö amolia ili molö made naala aialo gabula helësëmäia, ilia ilile odagi nigime hëla made aligilo nea. Na dilima dofä sähago. Amoïe bidida hä nii aguimelë. ");
INSERT INTO etr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amai gaso, dilia molö naala made aiala, dilile odagi nigime hëlahilä, busagia weli negemalo. ");
INSERT INTO etr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Amala hamomolö amoïe mida, udia dolö odoa ilia, dili beala molö made naala aialo gabula made helësëmäiaïe. Dilile Diado siia bimolöi made neebe ameamu aialo gabula helësëmäiamelë. Amala hamoseda, dilile Diadoea, dili hïdo hïdolaea musügä hamose beaha neebe amea, diligali bidi ïmolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesuea ado aso, sähamu nea sähalea, Nagadaiawi gasiämoea nülo dibea wige, asömalö gaisa baasia wige, fa nelo amolia mosö dagabola fa nelo neebea wige, dilile nelegei hedabi gafedela negesa namiabio. ");
INSERT INTO etr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amala hamolo dibea wi made, selesaia mosöa gasiämoea made nülo dibea amige, asömalö gaisa made baasia amige, fa neloea mosö dagabola made fa neasia amige, dilile nelegei hedabi gafedela negesa namialo. ");
INSERT INTO etr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mida, dïe nelegei hedabi negei sege dibea amida, dïe bobahëla helësëlo amoda segea amimu diamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Siida domaloïe yo digalo gamali gadoi nea. Dilile si hedabi neëda, dilile domalo sulubadelagi yo digaha maadei namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amase, dilile domalogi yo digalo neebe amo gasimi sagai diëda, gasimi sagai amo, edela gasimi sagalomelë. ");
INSERT INTO etr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Afädëa dafidilo äudäïe galabaia hamoi gadoi hamolasimolö ulïmelë. Ea elö amoma bimolö habobahalea, elö amo boba hamomolömelë. Elö amo hedabola ugila negesalea, oböla, elö amo memalä gabula helësëmolömelë. Dilia Godeïege, muniïege, helegelaïe galabaia hamoi gadoi hamolasimolö ulïmelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesuea ado aso, sähamu nea sähalea, Amoïeda na dilima säla ïahago. Molöle ödäle edo molödula säla, dili namolö goïe asigia säosäola helësëmabio. Amase, fagulo edo salugamolödulage , dilile namolö amoïege domaloïege asigia säosäola helësëmabio. Molö aso, nigia galahilä, udia dolö namolö amoda dafidilo madele. Amase, faguloge aso, nigia galahilä, domaloda dafidilo madele. ");
INSERT INTO etr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Haea hagila nawiaha dibe amo bimo. Haea amolida molö hawage sagalo made, molö faige gegedola negelo made, amase, negelo mosöage negelo made. Amalo gasoda, dilile Diado selesaia mosöa neebe amea hilima molö ïaha neamelë. Haea amoli holöbö gidogola, udia dolö dili dafidilo nebego madele. ");
INSERT INTO etr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Dili neebe gogi afädëa hïle namolö amoïemu asigia säosäola helësëseda, säosäola helësëse amea, ïe namolö amo fu holöfalï baala sedadelasimolöledu. Amamolö ulïmelë. ");
INSERT INTO etr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Faguloïe asigia säosäola namolö amoda edoïe. Mama amoli memalä bäulahilä, gägä negelo amo abeahäla fedaha aligilodula helësëmo. Ilia hamoige made hamolo, amase, ëfëge made nolo neamelë. ");
INSERT INTO etr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amai gaso, na dilima säla ïahago. Nelebo yafie negelo Solomonoda, ïe fagulo hedabifalï salugalo amoda, ilile momadoi hïdo elöi amo gadoi made nelo. ");
INSERT INTO etr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Giisige, mamage, memalä bäui walio nefolalebe amolida, aiyo dolöea damula nulogi gobelo neamelë. Asigi afädë holöfalï negei nefolalebela dili-e, Godea giisi mama nefolalebe amolida memalä momadolasilo. Amo gadola made, dofä baagila awäla, dili nefolalebegoge fagulo gämäia ïmolö madele. ");
INSERT INTO etr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amaimo, nilïa molöle ödäle edo molödulage, fagulo edo salugamolödulage säla, dilia asigia säosäola namiabio. ");
INSERT INTO etr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Amo gadolada, udia dolö Gode helësëlo made amolia, nelebo amoli gadoi helësësamu aligilo nea. Amalo gaso, dilile Diado selesaia mosöa neebe ameada, dili nefolalebegoea nelebo amoli nimolöi dibe amoda dawadigi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amaimo, ïe Beaha Maadela Sigi Neebe amole, ea dilia hamomäia hamesa neebe amoledale hogosa namialo. Amala hogosa aligiseda, ea nelebo amoli dibe amo sulubadela dilima baala ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Amai galë, walio neada dilia aiyoïe asigia säosäola namiabio. Aiyoïeda, segeyo aiyo hï asigia säosäosa namolö. Segeyo afädëïe yöi dibe amoda amoïemu dialeamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesuea ado aso, sähamu nea sähalea, Godea dilia hamosebego mogeloea, odoaea hamosebe amo dilia made mogemalo. ");
INSERT INTO etr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mida, dilia odoaea hamose amo beala memelelo amo gadola, Godeage dilia hamose amo beala memelemolömelë. Amase, dilia odoa beala mogelo amo gadola, dili bealage amo gadola wäla mogemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Amaimo, dihïle sihidoa i gäi gadoi dibe amo helësëla made, dia oböla didooïe sihidoa gëgelë holöbö diëgi beasegoda edoïe. ");
INSERT INTO etr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Dilia dihilile sihidoa i gäi gadoi dialea wäla, oböla dilile didooma sähalea, Dïe sihidoa gëgelë holöbö dibe alogo neahagola abeahäla sämolö gabu. ");
INSERT INTO etr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Asigi fea negelo nefolalebela dilia, dihilile sihidoa i gäi gadoi dibe amodale neadigilahilä, hobeala dilile didooïe sihidoa gëgelë holöbö dibe amo hedabola beala nimolöi bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nelebo Godema odala ïlo dibe amogi, dilia ügülogali ïmabio. Amase, bageïe isogi momado hedabi helebe näia difolalebe amoli suguagali sadia gala ïmabio. Amala hamoseda, ilia nelebo hedabi amo emoea daiasala nolealelahilä, dili mihimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesuea ado aso, sähamu nea sähalea, Ïmola ëdëgësa namialo. Ïmola ëdëgëseda, diligali ïmolömelë. Hogosa namialo. Hogosa aligiseda, dilia beagolemolömelë. Idi gai dugimola säha namialo. Idi gai dugimola säha aligiseda, dili digamäia idi gai dogasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mida, udia dolö sulubadelaea ïmosa neebe amolia nimolömelë. Hogosa neebe amea beagolemolömelë. Amase, idi gai dugimola säha neebe amoma idi gai doga negesimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Malö eedo nefolalebe dilile malöea, wahalo ïmola säseda, dili afädëa igi neala ïmolöle. ");
INSERT INTO etr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Amase, malöea seme ïmola säseda, dili afädëa waadima neala ïmolöle. ");
INSERT INTO etr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Amai dihili dili nafade hamolo nea gaso, dilile malöma nelebo hedabi ïmolö asigilo. Amo gadola made, dilile Diado selesaia mosöa neebe amea, ïmola säsebe amoma nelebo hedabi dofä baagila awäla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mala sulubadela odoaea dilima hamomäiala hamelo amo gadola, amase, diliage odoa ilima amo gadola wäla hamomalo. Mida, Mosese nebegi ado säla negei dibe amoïege, bea sälo nefolalo amolia ado säla negei dibe amoïege, amoligi ado säi dibe amoïe iso gäwida gomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesuea ado aso, sähamu nea sähalea, Idi doga negei dedelei holöfalïgi nogila digamalo. Mida, nafadelo segea aulo idi doga negeida edefade dialea, amase, idi amoge uahabai dialea. Udia dolö yafieda amogimu awäha nea. ");
INSERT INTO etr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amai gaso, namolöi namolö segea aulo idi doga negeida dedelei holöfalï dialea, amase, idige nelebolei dialea. Udia dolö afädë afädëlaeamu amo beagolelo neala säla ï. ");
INSERT INTO etr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesuea ado aso, sähamu nea sähalea, Wäfalï bea sälo nefolalebe amoli helësëla, idihë namialo. Ili sugua sibi aeai gadoi, dili neebea mulo nea gaso, iso asigida nufudaha maadelo ilua ügülo gadoi nea. ");
INSERT INTO etr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ilile gägä negesebe amo dilia bealahilä, wäfalï bea sälo gabula helësëmolömelë. Gufaeo gadoi neebe amomada, gägä hedabi ëi gelebi negesegi failole. Amase, buudi äyo ëfë gadoi amomada äfäeo gägä negesegi failole. ");
INSERT INTO etr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","I hedabi nefolalebe amoli sulubadelaeada gägä hedabi negelo nea. Gaso, i nafade nefolalebe amoliada gägä nafade negelo nea. ");
INSERT INTO etr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I hedabi nefolalebe amoliada, gägä nafade negemolö ulï nea, amase, i nafade nefolalebe amolia gägä hedabi negemolö ulï nea. ");
INSERT INTO etr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","I gägä hedabi negelo made nefolalebe amoli sulubadela sagai eedoea abalahilä, nulogi sadia galo. ");
INSERT INTO etr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Amaimo, dilia ilile gägä negesebe amo bealahilä, golida wäfalï bea sälo gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sulubadelaea ne wesalea, Dafidilo Geloi-e, Dafidilo Geloi-ela säha nefolalebe amolida, Hebeni Beaha Maadela Sigi Neebea ami made nogila digamolö. Nïe Naado selesaia mosöa neebe amea hamesebe amo gadola hamosa nefolalebe amolimu nogila digamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Godea gudimolö segeyo amo gala, udia dolö yafiea nema sähalea, Dafidilo Geloi-e, Dafidilo Geloi-e, dïe ëigila nilïa ado mala säla ïmelë. Amase, nilïa dïe ëi säla mugabe fedai nesila digisa aligilo. amase, geloi melëlo made gadoi yafiege dïe ëigila hamosa nelo amodala sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amala säseda, na ilima sähalea, Dilida na dofä dawa made. Mala nafade hamolo dili, ne neebeawi made, bahïla afiamola sämolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesuea ado aso, sähamu nea sähalea, Amaimo, sulubadelaea na ado säsewe nabala bëgëla hamose amolida, dolö afädë asigi gäwia igidaia mosö uli amo gadoi nefolalea. ");
INSERT INTO etr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Amala uli nebegi, sege edefade digala, ödä bëi nedala, fo guula maala, mosö amoma gelola nidäla asi gaso, made dagaboi. Mida, igi boboga salala igau sagai nelo amea. ");
INSERT INTO etr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amaimo, sulubadelaea na ado säsewe nabala, made bëgëla hamose amolida, dolö asigi made gäwi afädëa ödä bosedaia mosö uli amo gadoi nefolalea. ");
INSERT INTO etr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Amala uli nebegi, sege edefade digala, ödä bëi nedala, fo guula maala, mosö amoma gelola nidäla awäsebegi, mosö dagabola digala nafademolöi nafadeimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuea ado amoli sulubadela säha maadesebegi, udia dolö yafie negegila nefolalo amolia ea olelei amo nabala, asigigi fudugisa sefolalo. ");
INSERT INTO etr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mida, ado säla negei olelo nefolalo amolia säla olelelo amo gadola made, eada geloi gaulahilä, geloi hïdo elöi säla olelei amogi. ");
INSERT INTO etr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu e segebidaia amila digasebegi, udia dolö yafie nefolalo amoli e bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Awäha nebegi, dolö afädë gudubu hamoi nelo amo Yesu neebea maala, emo gumu sasagaia idogola salea sähalea, Dafidilo Geloi-e, dia ne wahimäiala helësëseda, hä dia ne wahilasimolöi nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Amala säsebegi, ïe naabo mogodigia gala, dolö amo diigisa nea sähalea, Na amala helësësa, wahimola säi. Amala säsebegi, dolö gudubu hamoi amo hä fodolofalï wahisa madei. ");
INSERT INTO etr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Amalahilä, Yesuea ema sähalea, Dofä elöma säloeo. Gobela ïlo dolö neebea ami di siia bimäia olemolö mosalo. Amalahilä, di wahi go udia dolöma olemolöïe, Mosesea nelebo odala ïmalola säla negei dibe amo gadola, nelebo afädë odala ïmalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu e amila awäla, Gabaniama gaamugi besela galasebegi, Olomo ilile ami hädali afädë beaha aligilo afädë Yesu neebea maalahilä, ema hähäfilïla sähalea, ");
INSERT INTO etr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Dafidilo-o, nïe hamoi hamolasilo e nïe mosöa oloi dialea. Ïe naabo emo baagola së edefademalä sëlahilä, fologomolö ulï dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Amala säsebegi, Yesuea ema sähalea, Na e wahilasimolö awähamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amala säsebegi, ami beaha aligilo amea säla obëgësalea, Ai. Dafidilo-o, neda dofea made ameada. Di ne gadoiïe mosöa nogila digamolö holöbö dofea made gabugi, dia adoeamu säsimäia. Amaseda, nïe hamoi hamolasilo amo wahimolö. ");
INSERT INTO etr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nage ne beaha aligilo ami geloi nefolalebe amoli hawala aligilomelë. Amase, ami dolö odoa nefolalebe amoliage ne hawala aligilomelë. Na afädëma mosöla säseda, e aulomelë. Elöma misiëla säseda, e mulomelë. Na nïe galabaia hamoi gadoi hamolasiloma gowe hamomola säse amo gadola hamolomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Amala säi amo nabala, Yesu e edefademalä fudugilahilä, udia dolö e bëgëla maaha difolalo amolima sähalea, Na dilima dofä gelola sähago. Isilale segea afädëa asigi afädë egowe gadola negei neebe na made melïmelë. ");
INSERT INTO etr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na dilima gowe sähago. Udia dolö yafie eso maasidolage, eso digasidolage maala, ilia Hebeni Beaha Maadela Sigi Neebea ami Abalahamala Aisagala Yeigabala ilibalä molö gegedola naha sefolamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amai gaso, Hebeni Beaha Maadela Sigi Neebea ami namiäia, Godea udia dolö dafidi memelei nefolalebe amolida, Godea hailahilä, gasimi sagai dibea ami, sogobala sadia idogomolömelë. Amida, ili dïisalea, bese ali nalëgësa namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Amala sälahilä, Yesuea ami beaha aligilo amoma sähalea, Hä, mosalo. Dia asigi afädë negei neebe go gadola hamomolömelëla säi. Amala säia gai amole, ami beaha aligilo amoïe hamoi hamolasilo amo hä, wahi. ");
INSERT INTO etr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu e Fidaïe mosöa awälahilä, Fidaïe esöa udia hëgï olo oloi dibe melï. ");
INSERT INTO etr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bealahilä, ea udia amoïe naabogi diigisebegi, dafidi olo hëgï dilo amo damulebe, udia amea nowelahilä, Yesu e molö muäia daiai. ");
INSERT INTO etr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Deadi eso digase gaalu, udia dolö nefolalo amolia mugabe fedai nefolalo amoli Yesu neebea sigi mofiai. Sigi mofiasebegi, Yesuea ado säi ameamu mugabe yafie nesila didigila digi. Amase, udia dolö oloi difolalo amoli sulubadela wahisa maadela digisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ea amala hamoi amoda, Godea ïe bea sälo Aisaeama aligila, bea säla negei amo gausiala digai. Nilïle oloi amo hï neala gaui. Olo elö elöla nilïma baai amoli ea neala gaula asila säi amo dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Udia dolö yafiea e amalela nefolalebe amo bealahilä, Yesuea sähalea, Ödä edefade dibe gowe dëgëla alogodigogi afiadila säi. ");
INSERT INTO etr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Amala säsebegi, mala dawadigi afädë Yesu neebea maalahilä, ema sähalea, Säla Olelelo-o, di awäsebe go gadola, ne di bëgëla maahagola säi. ");
INSERT INTO etr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Amala säsebegi, Yesuea ema säla obëgësalea, Ilua ügülo sefolalebe amoli dilo mosöda, naga hagali galea. Amase, haea sefolalebe amolile dilo mosö galea. Amai gaso. Dolöïe Malö eda busa fugulo negela dilo mosö fu maademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Amala säsebegi, bëgëla aulo elöea ema nabahalea, Dafidilo-o, na nïe naado dafidi baumolö obëgëmalamolö dofealela nabi. ");
INSERT INTO etr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amala nabasebegi, Yesuea ema säla obëgësalea, Baagoi difolalebe amolia hilile baagoi baumäia. Dida ne bëgëla misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu e ödä duugi fila awäsebegi, ïe bëgëla aulo amolige ebalä asi. ");
INSERT INTO etr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ili asi oeabo mogogi nebegi fo edefade gelola maase amea ödä aidagula du dabedelä hamose melï. Amala hamosebegi gaso, Yesu eda adi elaboi dilo. ");
INSERT INTO etr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Adi elaboi dibegi, ïe bëgëla aulo amolia awälahilä Yesu e didiigisalea, Dafidilo Geloi-e! Nilï hä ödäea nalä baagomolö gabu! Dia ugila negemolöïe di hä nowemola säi. ");
INSERT INTO etr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Amala säsebegi, ea säla obëgësalea, Asigi holöfalï negei nefolalebela dili-e, edogi bedäha dialeala säi. Amala sälahilä e nowelahilä, fole ödälema nemosebegi, fo bogelela ödä hä, aumalasi. ");
INSERT INTO etr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dolö amolia fudugilahilä sähalea, Dolö goweda nowë gadoidu. Folea ödäleada ïe ado nabelo gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu e Galili oeabo amo dëgëla näiadodi alomodi awäla,Gadala segea besela galai. Besela galaha nebegi, baagoi baulo igi äbä difolalebeamadila, dolö äudä mugabe fedai maaha nebegi, Yesuea ele gausiala digai. Dolö äudä amolea udia dolö nufudala ïalalemolöi gabugi, idi amogida udia dolö aulo made. ");
INSERT INTO etr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Elea Yesu gausiala digalahilä, gelola üalala sähalea, Godeïe malö, dia alïma abilia hamomolö misi. Së ïmolö segeyo fu aso, made besela galaia, alïdale dafidi së ïmolö misilela säi. ");
INSERT INTO etr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Amo gaalu, holöbö ga madela amida, sugua yafie moosa nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hä, dolö äudä amolema mugabe fedai amolia Yesuma sähalea, Dia nilï nesila digimolö galëda, nilï sugua nefolalebe gagowelima nogila fedamolö mosöla sämola säi. ");
INSERT INTO etr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Amala säsebegi, ea mugabe amolima dili mosöla säi. Amala säsebegi, mugabe amolia dolö äudä amole amilahilä, sugua amolima fedai. Fedasebegi, sugua nefolalo amoli sulubadela gau domaladi gelola baluluia digafula, oeabogi nogisebegi, ödäea naha maadei. ");
INSERT INTO etr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Amo bealahilä, sugua sigi aligilo nefolalo amoli fisäla baluluia afufulahilä, gaamugi besela galala hamoi amo sulubadela säla ïalahilä, dolö äudä dafidi mugabe fedai nelo amolege, säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Säla ï amo nabala, udia dolö gaamugi ami nefolalo amoli sulubadela Yesu neebea afialahilä, ilia e beala, ema sähalea, Dida nilïle segeawi namolö mademelë. Bahïla mosöla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu e dudaia fila, oeabo amo dëgëla obëgë obëgëla maalahilä, gaamu hï aligisia ami besela galai. ");
INSERT INTO etr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Besela galasebegi, dolö odoaea dolö afädë fii si sulo amo dafudaia gaula misi. Maasebegi, ilile asigi afädë negei amo bealahilä, Yesuea dolö fii si amoma sähalea, Nïe malö, asigi gelomalo. Dia nafade hamoi amolida na hësa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Amala säsebegi, mala dawadigi dolö odoa nefolalo amolia asigiamu helësësalea, dolö goweada Gode gagadesa neala helësësa nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ilia amala helësësa nefolalebe amo bealahilä, Yesuea ilima sähalea, Dilile iso asigigi nafade helësësa dibegoda mi edoïe! ");
INSERT INTO etr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aabei sämolöda abodo! Dia nafade hamoi amoli hësa maadeila sämolö amole, ma, nowela nawesa namiëla sämolö amole. ");
INSERT INTO etr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amai gaso, Dolöïe Malö Namolö Misi amea nagadaiawi nea, udia dolöea nafade hamoi amo hëla digimolöïe geloi gaula neebe amo dilia helësëmäia olesagomelëla säi. Amala sälahilä, ea dolö fii si amoma sähalea, Nowela, dïe dafu neala gaula dihï mosöa mosöla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Amala säsebegi, e hä hï mosöa asi. ");
INSERT INTO etr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Amala hamose amo beala, udia dolö yafie nefolalo amoli bedäi. Bedälahilä ilia sähalea, geloi hïdo elöi we gadoi dolöma ïlo gabula säla, Godeïe ëi gauia adogo. ");
INSERT INTO etr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu e amila awähalea, dolö afädë, ëida Madiu, eda dagisi muni nelo mosöa ami sebe melï. Bealahilä, Yesuea ema sähalea, Ne bëgëla misiëla säi. Amala säsebegi, Madiu e nowela, Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu e awäla Madiuea mosöa molö naha sebegi, dagisi muni nelo amolige, dolö yafie mala nafade hamolo amolige maala, Yesula, ïe bëgëla aulo amolalibalä, molö naha sefolalo. ");
INSERT INTO etr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Amala naha sefolalebegi, Felesi dolö amolia bealahilä, ïe bëgëla aulo amolima nabahalea, Dilile säla olelelo goea, dagisi muni neloge, mala nafade hamologe, golibalä molö naha sebegoda edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Amala säi amo nabala Yesuea sähalea, Udia dolö oloi made nefolalebe amolida alögoda neebea aulo made. Oloi sefolalebe amolimu alögoda neebea aulomelë. ");
INSERT INTO etr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dili afialahilä, Dafidilo Geloiïe bebagi ado dëdëi dibe gowe helësëmalo. Amoda gomalä, Na nelebo elö elöla nufudala ïmolö amo hamela made, bobasëla ugila negemolö amo hamesala säla dëdëla negei dialea. Ne misiweda, udia dolö mala mogoi hamolo nefolalebe amoli wemolö misi made. Udia dolö mala nafade hamolo nefolalebe amoli wemolö misimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Segeyo amo gaalu, Yoneïe bëgëla aulo nefolalo amoli Yesu neebea maalahilä, ema nabahalea, Nilïage, Felesi dolö nefolalebe amoliage, molö made nalä aligilo amogi, dïe bëgëla aulo nefolalebe golia molö made naala, made aligilo goda mida edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Amala nabasebegi, Yesuea ilima säla obëgësalea, Dilia dolö afädëa udia neahalea, dolö udia nelo amoïe damelë hï ebalä gedola nea, asigia yöi gadoi neada ifolole. Amalo made gaso, ili neebea amila odoaea e sigi moholö segeyo fu besela galaseda, segeyo amogi ili molö made naala namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Afädëa fagulo goofo nuli amogi fagulo gähea baala asogelo made. Amala baala asogeseda, fagulo gähea goofogi baala asogei amo edela nulilo. ");
INSERT INTO etr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Amase, afädëa wani ödä gähe dibe amo, i sugua meme gafodoea hamoi goofogi söga salelo mademelë. Amala hamoseda, wani ödä gähe amea sugua meme gafodoea hamoi goofo amo dusulahilä, wani ödä amo awäha maadela, meme gafodoea hamoi i amoge nafademolöi nafademolömelë. Amala hamoloea, wani ödä gähe dibe amoda, meme gafodoea hamoi i gähe amohï gadoigi söga salaseda, helegela hedabi dië melëlola säi. ");
INSERT INTO etr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuea aso, Yoneïe bëgëla aulo amolibalä adosa nebegi, beaha aligilo dolö afädë maalahilä, Yesuïe emo mia emo gumu sasagala fia idogolahilä sähalea, Nïe nidiwi hädamadefalï hame doala asi dialea. Di maala, dïe naaboea e diigiseda, e wahila galamolöla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Amala säsebegi, Yesu e nowela e awäse amo gadola awäsebegi, ïe bëgëla aulo amolige e awäse amo gadola asi. ");
INSERT INTO etr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Awäha nebegi, udia afädë gäheo i giwilasi heale olo olosamu aligilo amea Yesuïe baagido awälahilä, ïe fagulo sedade gäi amoïe bidigifalï diigi. ");
INSERT INTO etr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ea hïdo sähalea, Na ïe fagulogimu diigiseda, ne wahimolö gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Amala hamosebegi, Yesuea besuia imogola, e bealahilä sähalea, Nïe nidiwi-e, asigi gelomalo. Dihï asigi afädë negei amea, di hä wahigomelëla säi. Amala säi amole, udia amo aabela wahi melï. ");
INSERT INTO etr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Amila awäla, Yesu e beaha aligilo dolö amea mosöa nogila digai. Nogila digalahilä beahaleamelebe, fëla gälo dolö odoage, udia dolö yafie gegedola didigaosalea goba fedaha dibe amoge beala, ");
INSERT INTO etr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ea sähalea, Dili afiaha maademo. Udia malö holöbö goda baagoi made. Süwia adi dialeamelëla säi. Amala säsebegi, ilia Yesubalä ösa dilo. ");
INSERT INTO etr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amasebegi, udia dolö nefolalo amoli segea nesila digilahilä, Yesu e ïe dilo hogoligi ami nogila digalahilä, udia malö holöbö amoïe naabogi gaula nabeleia wesebegi, nowela galai. ");
INSERT INTO etr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yesuea hamoi amo sege amomadi nefolalo amoli sulubadelaea nabala daidoi. ");
INSERT INTO etr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu e amila awäha nebegi, dolö äudä si golai nelo amolea e baagiala bëgëla maaha nea, gelola uuala sähalea, Debidiïe malö-o, dia alï bobasëmola säi. ");
INSERT INTO etr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu e awäla mosöa nogila digasebegi, dolö äudä amole e sebea ami maasebegi, Yesuea dolö äudä amolema nabahalea, Alile si na wahimäiala helësëla, ali asigi afädë negei nealela nabi. Amala nabasebegi, elea säla obëgësalea, Ä, Dafidilo-o. Alïa asigi afädë negeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Amala säsebegi, Yesuea elele siigi diigisalea sähalea, Hali asigi afädë negei neebe gohï gadola hamomolöla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Amala sälahilä, elele si amo hedabola fisigäsebegi, Yesuea elema gelolafalï sähalea, Go hamoi goda, dofä elöma säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amala säla ï gaso, ele awähalea, Yesuea elema hamoi amo, sege amomadi nefolalo amolia nabaha maademäia säla ïïa awäha nelo. ");
INSERT INTO etr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dolö äudä amole doadigila awäse amo gaalu, udia dolö odoaea dolö afädëma mugabe fedalahilä, ado adomolö ulï nelo amo, sigi misi. ");
INSERT INTO etr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mugabe fedai amo nesila digisebegi, dolö adomolö ulï amea ado adoi. Amala hamosebegi, udia dolö yafie gegedoi nefolalo amolia fudugilahilä sähalea, Isilale segeawi dofä go gadola hamose afädë melëlo made nelo amo neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amala säsebegi, Felesi dolö nefolalo amolia sähalea, Mugabe amoli sulubadelaïe dafidiloea geloi ïasebegi, ea mugabe nesila digisa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu e gaamu sulubadelagige, sege sulubadelagige, nawesa neada. Ilile gedolo mosöa ami säla olelesalea, Beaha Maadela Sigi Neebe amoïe Ado Mala Hedabi amo säla olelela digi, olo elö elöla oloi difolalo amoli wahila digi, amase, domalo nalafadela nawei amoli sulubadela wahisa maadela aligi nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ea udia dolö yafie gegedoi nefolalebe amoli beala bobasëi. Mida, ili sugua sibi sigi aligilo maadeia, hilido aligilo amo gadola nea, asigia säosäola, nalahoi nefolalebe amo beala. ");
INSERT INTO etr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Amo bealahilä, ea ïe bëgëla aulo amolima sähalea, sagaia molö bëi yafie dialea gaso, molö bëi amoïe hamoi hamola gegedolasimolö dolöda ede made gabumelë. ");
INSERT INTO etr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Amai gabugi, sagai eedo hï ïe sagaia hamoi hamomolö fisiga gamäia, dilia ema adosa namialola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuea ïe bëgëla aulo giwilasi amoli wela misialolahilä, Mugabe fedai nefolalebe amoli nesila digimäiage, olo elö elöla oloi difolalebe amoli wahimäiage, domalo nalafadela nawei sefolalebe amolige, sulubadela wahisa maademäia, ea ilima geloi ï. ");
INSERT INTO etr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Abosolo giwilasi amolile ëida gowe ili. Dafidida Saimono, ïe ëi elö Fidala sälo amoge, ïe edoo Äduluge, Sebediïe malö Yamesege, ïe edoo Yonege. ");
INSERT INTO etr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibige, Badolomiuge, amase, Domasage, dagisi muni nelo Madiuge, Alibiasaïe malö Yamesege, Dadiusige. ");
INSERT INTO etr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Selodo sosogo Saimonoge, Yudasa Isagaliada, ea Yesu hololölo amoge, ea amoli memelei. ");
INSERT INTO etr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuea dolö giwilasi amoli hä, afiamalolahilä, ea ilima gomalä säla ï. Dili awähalea, udia dolö fii odoa sebea aulo idigi mosabio. Samelia gaamu difolalebeamadi amogige digamabio. ");
INSERT INTO etr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ami made awäla, dilida Isilale udia dolö ili sugua sibi dabadigi gadoi nefolalebea amimu mosalo. ");
INSERT INTO etr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Awälahilä, ado mala säla ïahalea, Hebeni Beaha Maadela Sigi Neebe amo ga made dialeamelëla säla ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Amase, oloi difolalebe amoli wahila digi, hame doala asi difolalebe amoli wahila digi, gudubu hamola nawei sefolalebe amoli wahila digi, mugabe fedai sefolalebe amoli nesila digila digisa namialo. Walio dilia nelebo nii gaula neebe goda, bidia made, memalä nii amo gadola, memalä ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dilia afiahalea, muni gologe, silibage, benige afädë muni salelogi salala, made gaula mosalo. ");
INSERT INTO etr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dili afiahalea aduge, fagulo elö baalage, emo usililoge, galiamoge, made gaula mosalo. Mida, hamoi hamolo neebe amogalida, molö ïmolö dialea. ");
INSERT INTO etr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Dili afiala gaamu afädëgige, sege afädëgige besela galasegi, afädëa dili nihïlïgïla diahala säsebelela bimolö mosalo. Besela galasegi, diahala säse dolö amobalämu diaha nelolahilä, moholö fu besela galasolo amo gala, giso sege amo dïgïla mosalo. ");
INSERT INTO etr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dili mosö amogi nogila digahalea, udia dolö amolima, dalulo dilibalä diamiäiamelëla säla ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Udia dolö mosö amogi sefolalo amolia obeägïla dili gauia idaseda, dalulola säla ï amo ilibalä diamialamalo. Ilia amala made hamoseda, dalulo säla ï amo dihilima obëgëmäia nea nimalo. ");
INSERT INTO etr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mosö afädëgi sefolalebe amoliage, gaamu afädëgi nefolalebe amoliage, dili midilö mofiamola made säla, dilia ado säsebe amoge made nabaseda, dilile emogi dao baai amo fëfëla salalahilä, mosalo. ");
INSERT INTO etr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na dilima dofä sähago. Memelela gudimolö segeyo besela galasolo amo gala, Sodomo ilibaläge, Gomola ilibaläge memelela gudimolö amo gadola made, dofä baagila awäla, gaamu amogi nefolalebe amolibalä, gelolafalï memelela gudimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesuea ado aso, sähamu nea sähalea, Nabuö! Na dili Sugua sibifalï gadoi, ilua ügülo nefolalebea ami mosalahagomelë. dilia hamosego hamosaleada, amo helësëla hedabola hamomalo. Dilia sigo sigosa neada, asigige gagadelai namialo. ");
INSERT INTO etr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dolö odoa nefolalebe amoli helësëla, idihë namialo. Ilia dili, ilile galïsolö dolö amolile naabogi gausimolömelë. Amase, ilile gedolo mosöa amige, ilia dili fëgämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dilia ne bëgëla mofiasebe goïe, beaha aligilo gini nefolalebea amige, gamane beaha aligilo nefolalebea amige, sigi awäseda. Dilia melï amoge nabi amoge, ilimage, fii odoa nefolalebe amolimage säla ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ilia dilibalä gudimolöïe sigi awäseda, nilïa ado abodo sämolödu, nilïa ado abeahäla säla obëgëmolödula asigia säosäola helësëmabio. Segeyo sämolö fu amogida dilia sämäia Godea olese amo sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mida, dihili ado sämolö mademelë. Dilile Diadoïe Gesamia dihilima aligila sälasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dolöea ïe edoo nufudala baagomäia gaula ïmolömelë. Malö eedoeage hïle malö amo gadola wäla hamomolömelë. Amase, malöeage ïe eedo emelebalä habobala nufudala baagomäia gaula ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nïe ëi dilima dibego beala, sulubadelaea dilima bimolö habobamolömelë. Amai gaso, afädëa aso maadela, wagamäialahilä gelolamu aligiseda, e damula moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dili gaamu afädëgi neëgi neala sëlasiseda, fisäla gaamu elögi afiamalo. Na dilima dofä sähago. Dilia Isilaleïe gaamu dibe sulubadelagi, hamoi hamomolö difolalebe amo, dofä made hamosa maadeia, Dolöïe Malö amo moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Bëgëla aulo neebe ameada, ïe olelelo neebe amo dabiala aulo made. Amase, galabaia hamoi gadoi hamolasilo neebe ameada, ïe dafidilo neebe amo dabiala aulo mademelë. ");
INSERT INTO etr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amaimo, bëgëla aulo neebe ameada, ïe olelelo neebe amo gadoi namolöda dofea. Amase, galabaia hamoi gadoi hamolasilo neebe ameage, ïe dafidilo neebe amo gadoi namolöda dofeamelë. Ilia mosö eedo neebe amoma ëi Belesabulula sälo nea galëda, ïe malö nefolalebe amolimage, dilile ëi nafadefalï nafadela sämolö gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesuea ado aso, sähamu nea sähalea, Dilia dolö amolibalä bedämabio. Nelebo sulubadela walio dabela negei difolalebe amolida, hobeala ulufadigisa maademolömelë. Amase, nelebo sulubadela walio musügä negei difolalebe amolige, hobeala dawadigisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na walio gasimi sagaia nea ado säla ïase weda, dilia eso neë dibea ami nea, säsewe gadola bu eegela säha namialo. Geleä sëdäwala säse nabasegoda, dilia mosö daiowa nea, udia dolöma uuala säla ïaha namialo. ");
INSERT INTO etr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gesamila made, domalomu baagomäia nufidelo nefolalebe amolibalä bedämabio. Gasoda, domalo gesamile helegela heli segea nafademolö neebe Gode amobalämu bedämalo. ");
INSERT INTO etr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Haea nelësa gigiso gadoi äudäda, bidi holöfalï muni giwi afädë gadoia nelo. Amai gaso, dilile Diadoea haea holöfalï amoda hedabola sigi aligilo nea. Haea amoligi afädë nagadaia baagoseda Godea asigisa nea. ");
INSERT INTO etr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amase, dilile busagia busa hilï nebegoge, sulubadela nidesa maadei neamelë. ");
INSERT INTO etr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Amaimo, dilia bedämabio. Haea gigiso gadoi sefolalebe amolida holöbö gidogolahilä, dilida abulümi hamoi nebego madele. ");
INSERT INTO etr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesuea ado aso, sähamu nea sähalea, Afädëa udia dolö sefolalebe amolile siigi nea, neda Gelesoïe neawela säla ulufaseda, amase, nage nïe Naado selesaia mosöa neebe amoïe siigi, amo gadola wäla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amaimo, afädëa udia dolö sefolalebe amolile sidaia, neda e sosogo mademelëla säseda, nage nïe Naado selesaia mosöa neebe amoïe sidaia, dolö amoge ne sosogo mademelëla sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesuea ado aso, sähamu nea sähalea, Diliada na sege sulubadelagi dalulo ïmolöïe gaula misi gabula helësëmabio. Dalulo ïmolöïe gaula misi made, nada nudulo helebe gaula misimelë. ");
INSERT INTO etr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na mogemolö misi amoda gomalä, malöea ïe eedobaläge, idiwia ïe emebaläge, amase, malö udiaea egoamebaläge. ");
INSERT INTO etr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dolöïe ado niida, hïle mosöa aligilo amoli namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Afädëa ne boba hamoi amo holöbö gidogolahilä, ïe eedole emele boba edefade hamoseda, eda ne sosogo namolö dofea mademelë. Amase, afädëa ne boba hamoi amo holöbö gidogolahilä, ïe malö boba edefade hamoseda, eege ne sosogo namolö dofea mademelë. ");
INSERT INTO etr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Amase, afädëa hïle i fügäi neala gaula, ne bëgëla made maaseda, amoge ne sosogo namolöda dofea mademelë. ");
INSERT INTO etr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Afädëa hïle namolö amo gaula fëdöla aligimolö amomu helësëseda, ïe namolö amo hogosa helemolömelë. Gaso, afädëa hïle namolö amo ne helësëla fisiseda, ea ïe namolö amo gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesuea ado aso, sähamu nea sähalea, Afädëa dilima, nihïlïgïla namolö mofiamola säseda, nege ebalä namolö misiëla sähagomelë. Amase, afädëa nema, halïgïla namolö misiëla säseda, ne fisiga welo amoge ebalä namolö misiëla sähagomelë. ");
INSERT INTO etr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amaimo, afädëa goweda bea sälo gabula helësëlahilä, ea mosöa sigi aligiseda, eege, bea säloea bidi nease amo gadoimu nimolömelë. Amase, afädëa dolö goweda mala mogoi hamolo neebela bealahilä, ea mosöa sigi aligiseda, eege, dolö mala mogoi hamolo amea, bidi nease amo gadoimu nimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dolö afädëa nïe bëgëla aulo holöbö gidogo neebe amo, nïe bëgëla aulo gabula helësëla, amogali gögï ödä osala ïaseda, na dilima dofä sähago, dolö amoda dofä bidi nimolömelëla sähagola säi. ");
INSERT INTO etr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuea ïe bëgëla aulo giwilasi amolima amala hamomolömelëla säla ïalahilä, e amila awäla, ilile gaamu difolalebe amoligi nawesa nea, udia dolö ilima ado mala säla ïadigi, säla olelela digisa namolö asi. ");
INSERT INTO etr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ödägi gelo Yone e galabaia mosöa nea, Gelesoea hamoi hamosa neamelëla säi amo nabalahilä, Yonea ïe bëgëla aulo amolima sähalea, Yesuma ado gomalä nabulö mosalola säi. Amala säsebegi, ili Yesu neebea awälahilä, ");
INSERT INTO etr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ema nabahalea, Afädë moholömelëla säi amoda dile, ma, nilïa elö beaha namolöledula nabi. ");
INSERT INTO etr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Amala nabasebegi, Yesuea säla obëgësalea, Dili obëgëlahilä, ado nabi amoge, siia melï amoge, Yonema säla ïmalo. Säla ïahaleada, ");
INSERT INTO etr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Si golai nefolalo amolige, siia beaha maadela, emo nafadei sefolalo amolige, emesala nawela, amase, gudubu hamoi sefolalo amolige, wahisa maadela, gëhe gai sefolalo amolige, hä, nabaha maadela, baagoi difolalo amolige, nowelasisa maadela, amalahilä, udia dolö busadäoi nefolalebe amolima Ado Mala Hedabi säla ïaha neebeola sämalo. ");
INSERT INTO etr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Udia dolöea ne beala, ilile asigi afädë negei amo made digase amoliada, obeägïsa neamelë säi. ");
INSERT INTO etr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Amala säsebegi, dolö misi amoli awäse amo gaalu, Yesuea udia dolö gegedola nefolalo amolima Yoneïe helësëla sähalea, Sege nafadeia udia dolö aligilo made dibea ami afiai amoda, dilia edo bimolö afiai. Dili afiai amoda, foea giisi sedade fologosebe amo bimolö afiaile. ");
INSERT INTO etr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Amai made galëda, dilia edo bimolö afiai. Dolöea fagulo hedabifalïmu salugai neebe amo bimolö afiaile. Nabuö. Fagulo hedabifalï amo gadoi salugalo neebe amolida beaha aligilo ginia mosöa dilo neamelë. ");
INSERT INTO etr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dili afiai amoda edo bimolö afiai. Bea sälo afädë neebe amo bimolö afiaile. Ä, amomelë. Amai galëda, na hä dilima sähago. Bea sälo weada, bea sälo odoa baagila asi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ïe helësëla, gomalä dëdëla negei dialea. Nabuö. Nïe ado säla ïlo eda, dïe dafidila mosalamolömelë. Dida e baagia emesala nawesa namolöïe, ea dïe idi fodolasimolömelëla säi dialea. ");
INSERT INTO etr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na dilima dofä sähago. Udiaea neegela ägüi amoli sulubadelada, ödägi gelo Yone neebe amo gadoi maade, ilida holöbö gidogofalï. Amai gaso, dolö afädë Hebeni Beaha Maadela Sigi Neebea ami holöbö gidogofalï neebe ameada, Yone baagila asi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ödägi gelo Yonea, ado mala mi gäwila säla ïaha neloa amila maala, hä, walio wegida, Hebeni Beaha Maadela Sigi Neebea ami neala sëlasila, dolö nafade nefolalebe amolile geloia neala gaumolöïe nudusa nea. ");
INSERT INTO etr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amaimo, bea sälo sulubadela nefolalo amoliage, amase, Mosesea Ado säla negei ameage, bea säsäla maaha nelolahilä, giso Yone neebea ami besela galai. ");
INSERT INTO etr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Amaimo, dilia ilile ado nabala asigi afädë negemolö galëda, Elaia moholömelëla säla dëdëla negei amoda, Yone emelë. ");
INSERT INTO etr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Afädë gëhe galea galëda, nabualo. ");
INSERT INTO etr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Udia dolö walio neebe weli ado abodo gadoima oodo beala sämolödu. Ilida malësäea magaia gaamugi salea, malësä odoama uuala säia gala sähalea, ");
INSERT INTO etr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nilïa dilile bäidama dülasilebeda, dilia amogi made gosasio. Nilïa oböla dilile bobasëi gë udälasilebege, dilia amogi bobasëla dïila made nelomelëla sälo amo gadoida ili nea. ");
INSERT INTO etr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Amaimo, Yone e maala neada, molö made naala, wani ödäge made naala nebegi, ilia eda mugabe fedai neala sälomelë. ");
INSERT INTO etr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amalahilä, Dolöïe Malö amo maala neada, ea molöge wani ödäge naha nebegi, ilia sähalea, Dolö neebe goweada molö badoia nalä, wani ödäge edefade nülo nea. Amase, ea dagisi muni nelobaläge, mala nafade hamolo amolibaläge damelë hamola aligilo neebe gowe bimola sälomelë. Amalo gaso, Godeïe asigi falagasei ulufadigisebe ameada, dofä dibe amo ulufadigimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gaamu odoagi, Yesuea melëlo made gadoi yafie hamoi gaso, udia dolö ami nefolalo amolia asigi besula made nefolalo. Amala hamosebegi, Yesuea ilima nemola sähalea, ");
INSERT INTO etr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Golasini Gaamugi neebe udia dolö dili asigii gabu. Amase, Bedesaida udia dolö neebe dilige, asigii gabu. Mida, dili neebea ami geloi melëlo made gadoi hamoi amo gadola, gaamu Daia Saidonolemadi dafidi hamoi galebeda, ilia asigi besula, nafade edefade hamoi amoïe ulufala, hewai fagulo salugalahilä, nisibu uula filabio. ");
INSERT INTO etr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amaimo, na dilima säla ïahago. Memelela gudimolö segeyo besela galasolo amo gala, Daia ilibaläge Saidono ilibaläge memelela gudimolö amo gadola made, dilibalä dofä baagila awäla, gelola gudimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amase, Gabaniama dilige, Godea dili gauia adogosegi selesaia mosöa fedamolö gabula helësësale. Ai, dilida heli segea gidogofalï digamolömelë. Geloi melëlo made gadoi dili neebea hamoi amo gadola, Sodomo ami dafidi hamoi galebeda, Sodomo gaamu amoda aso, walio diëgi amalabio. ");
INSERT INTO etr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gaso, na dilima säla ïahago. Gudimolö segeyo besela galasolo amo gala, Sodomo ilibalä gudimolö amo gadola made, dofä baagila awäla, dilibalä gelola gudimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Segeyo amo gala, Yesuea sähalea, Mudaiaïege, nagadaiaïege Dafidilo Geloi di nebego. Naado-o, na dïe ëi gauia adaha. Mida, asigi falagasei nefolalebe amolimage, nagadaia mala dawadigi nefolalebe amolimage, dia amolima musügä negelahilä, oböla, malësä gadoi nefolalebe amolima nelebo amoli ulufala olei amogi. ");
INSERT INTO etr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ae, Naado. Dihï amala hamomolö helësëi amo gadola, hamoi gabumelë. ");
INSERT INTO etr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesuea aso sähamu nea sähalea, Nïe Naadoea nelebo sulubadela nema gausisa maadeimelë. Afädëa Malö eda gowe neala dawadigi mademelë. Naadoea hïdomu dawadigi nea. Afädëa Naado eda gowe neala dawadigi made neamelë. Malö eamu hïdo dawadigi nea. Amase, Malöea ïe Eedo olemolö helësësebe amolima olesegi, iliage e gowe gabula dawadigisa neamelë. ");
INSERT INTO etr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dili sulubadelaea nelebo yöi dibe amoli, baagi sëla gaula nefolalebela dili, ne neebea mofiamo. Mofiaseda, na diligali hele fimolö amo ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nelebo gaula dusugamolöïe sugua gao daia i damui muugia begelo amo gadola, dilia nïe ado hawala nea, nema dawa nimalo. Mida, na dolö odoama hame negela aligiloge, nihï nagadaiala nea mala hamologe neawe. Ameada, dili hele fimolö beagolemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Amala hamomolö amoïe mida, nïe i damui dilile mugia negemolö amoda häuai made, aabei gaumolömelë. Nelebo dihili gaumäia na ïmolö amoda yöi made, hageai dialeala säla ï. ");
INSERT INTO etr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Holöbö ede made nelolahilä, segeyo Sabada gafegi, Yesu e eladi gadoi ëi widi sagai mogogi awäha nelo. Awäha nea, ïe bëgëla aulo amoli sïdëa baagosebegi, widi amoïe gägä amo faila nana awäha nelo. ");
INSERT INTO etr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Amala nasebe amo, Felesi dolö nefolalo amolia bealahilä ema sähalea, Segeyo Sabada gafegi made hamomalai amoda, dïe bëgëla aulo golia hamosa neebe gowe bimola säi. ");
INSERT INTO etr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Amala säsebegi, ea ilima säla obëgësalea, Debidige, ïe dolö odoa amolige, sïdëa baagosalea, Debidia hamoi dëdëla negei dibe amo dilia made melï neale. ");
INSERT INTO etr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Debidi e Godeïe balai mosöa nogila digalahilä, beledi Godegali odala ï dibe amo nealahilä, hïge, ïe dolö odoa amoliage mai. Ado säla negei ameada, Beledi amoda odoaea nülo made, gobela ïlo nefolalebe amoliamu nülo negei. ");
INSERT INTO etr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ado säla negei dibe amogi dëdëla negei dibe amo dilia made melïle. Gobela ïlo nefolalo amolia Segeyo Sabadagi Godeïe mosöa ami nea, Sabada segeyo damusa aligilo. Gaso, iliada asiala made hamoi. ");
INSERT INTO etr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na dilima säla ïahago. Neebe egoweada, Godeïe mosö baagi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bebagi dëdëla negei dibe amogi afädëda gowe. Na nelebo nufudala ïmolö hamela made, bobasëla ugila negemolö amo hamesala säla dëdëla negei dialea. Amaimo, ado amoïe mi gowe gadoila helësëi galebeda, dilia udia dolöea asiala made hamoi nefolalebe amolima, dilia asiala hamoi gabumelëla sälo made aligilabiomelë. ");
INSERT INTO etr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Amoïeda Dolöïe Malö amo hï eda segeyo Sabada gafeïe Dafidilo neala säla ï. ");
INSERT INTO etr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu e amila awäla, ilile gedolo mosö afädë neebea ami nogila digai. ");
INSERT INTO etr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mosö isogi ami dolö naabo nafadei afädë maala sulo. Dolö odoa nefolalo amolia Yesuma dia nafade hamoila sädelälahilä, ilia ema nabahalea, Segeyo Sabada gafegi wahilasimolöda dofeale, ma, dofea madelela nabi. ");
INSERT INTO etr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Amala nabasebegi, Yesuea säla obëgësalea, Dili neebe gogi afädëïe sugua sibi afädë Sabada segeyo gafegi dögöigi digai diëda, sugua sibi eedoea sogobala made fisiga adamolöle. ");
INSERT INTO etr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sugua sibida holöbö gidogolahilä, dolöda dafidilo edefade neebe amo beahale. Amai ameada, segeyo Sabadagi hedabi hamomolö amo dofeala säi. ");
INSERT INTO etr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Amala sälahilä, ea dolö amoma sähalea, Dïe naabo mogodigimola säi. Dolö amea ïe naabo mogodigia gasebegi, bu hedabola obëgëlahilä, naabo näiado hedabi amo hï gadoi wäla hedaboi melï. ");
INSERT INTO etr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amala hamosebegi, Felesi dolö amoli segea doadigila awälahilä, Yesu nufulö abilia hamomolödula säla didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuea ilia e nufulö didiäha dibe amo helësëlahilä, sege amo dïgïla asi. Dïgïla awäsebegi, udia dolö yafie nefolalo amolige e awäse amo gadola mofiasebegi, ea udia dolö oloi amoli sulubadela wahisa maadela aligi awäha nea, ");
INSERT INTO etr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ea ilima sähalea, Eda gowe gabiola odoama säla ïmabiola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ea amala hamoi amoda, bea sälo Aisaeaea bea säla negei amo gausiala digai. Ea bea säla negei amoda gowe. ");
INSERT INTO etr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nïe hamoi hamolasilo na memelei amoda neebe gowemelë. Na ema boba hamolahilä, obeägïsa neawe. Na nïe Gesami ema namolö mosöla sämolömelë. Ea, na memelemolö amo gowe gadoi galeamelëla säla, udia dolö sege elö elölagi sefolalebe amoli sulubadelama säla ïaha namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eada gëgësadialage, uualage made sämolö. Amase, idiafage ea ado säse made nabulömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eada fise dagabomolöïe wäbëala digase amoge, ea made dagabomolömelë. Eada gele wai uliligi neebe amoda made usila digimolömelë. Hamoi mogola hamomolö amo baagila mosäia, eada mogola hahamogisamu namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Udia dolö fii elö elöla nefolalebe amolia ïe ëi helësëla, sisiläfüla beaha nefolamolömelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Segeyo amo gala odoaea dolö afädëma mugabe fedalahilä, si nafadela ado adomolö ulï nelo amo, Yesu neebea ami sigi misi. Sigi maasebegi, Yesuea dolö amo wahilasilahilä, ado maade amea ado adola, siia fädäla melï. ");
INSERT INTO etr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Amasebegi, udia dolö yafie gegedoi nefolalo amoli fudugilahilä sähalea, Wae! Egoweda Debidiïe malöledula säi. ");
INSERT INTO etr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amala säi amo nabalahilä, Felesi dolö nefolalo amolia sähalea, Dolö goea mugabe fedai nesila digisebegoda, mugabeïe dafidilo neada, Belesabuluea geloi ï amo gaula nea, nesisa nemelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amala helësëla säha dibe amo Yesuea helësëlahilä ilima sähalea, Gädili afädëa hilimu moge mogela nuduseda, amo nafademolömelë. Amo gadolamu, gaamu afädëge mosö afädëge hilimu moge mogela nuduseda, amolege geloi made namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Amaimo, Saidania Saidani nesila digilo galebeda, hï ebalä moge mogela aligilabio. Amala aligiseda, ea beaha maadela sigi neebe amo abeahäla namolödu. ");
INSERT INTO etr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na Belesabuluïe geloigi nea mugabe fedai nesila digilo amo dofä galëda, dilibalä aligilo amolia, mugabe fedai nesila digisa nelo amoda nowëa ugila negesa nelo. Dilibalä aligilo amolia, dilia asiala helësëi amo ulufala olelo nea. ");
INSERT INTO etr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amaimo, na Godeïe Gesamia geloi ïase amea mugabe fedai nesila digisa nea galëda, Godea Beaha Maadela Sigi Neebe amo dili neebea hä besela galai dialea gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Amase elöda, afädëa dolö geloi neebe amoïe nelegei fa nimolö helësëseda, dolö geloi neebe amodale dafidi made nafodola negesiseda, dolö amoïe mosöa digala, ïe nelegei dibe amoligi abeahäla fa nimolödu. Dafidi e nafodola negesilahilä, hobeala ïe mosöa nelegei difolalebe amo fa neaha maademolöi bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Afädë e nebalä made nea galëda, hï nebalä ado nii nea. Amase, afädëa nebalä made gedolasiseda, ea dusula afiaha maademäia nesila digisamelë. ");
INSERT INTO etr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Amaimo, na dilima säla ïahago. Udia dolöea nafade hamoi amoge, gagadei amoge, sulubadela hëla fisimolömelë. Amai gasoda, afädëa Gesami gagadeseda, amoda made hëla fisimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Afädëa Dolöïe Malö e gagadela ado nafadela säseda, amo hëla fisimolömelë. Gasoda, afädëa Eleloi Gesami e gagadela säseda, amo walioge, hobealage made hëla fisimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Aso, Yesuea säi amo, uda negela made, sähamu nea sähalea, Dilia i afädë hedabi neebela helësëseda, ïe gägäge hedabila helësëmalo. Be, dilia i afädë nafade neebela helësëseda, ïe gägäge nafadela helësëmalo. I afädëa gägä negesebe amo bealahilä, i gowe gadoi neebela helësëlomelë. ");
INSERT INTO etr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Dilida baagolo nubaïe malö nebego. Dihili dili nafade nea, ado hedabida abilia sämolö gabu. Iso asigigi nobala adugasebe amo gadoi nafi idigila säla ulufadigilo. ");
INSERT INTO etr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Afädë hedabi neebe ameada hïle iso asigigila hedabi dibe amo gadoi ulufadigilo nea. Amase, afädë nafade neebe ameage hïle iso asigigila nafade dibe amo gadoi ulufadigilo nea. ");
INSERT INTO etr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na dilima sähago. Memelela gudimolö segeyo besela galasolo amo gala, udia dolöea ado galone made memalä säi amoda, mi edoïe säila säla obëgëmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mida, dihï ado säi ameamu, dihïdi mogoi neala sämolömelë. Amase, dihï ado säi ameamu, dihï asiala hamoila sämolömelëla Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Amala säsebegi, mala dawadigi odoa nefolalo amoliage, Felesi dolö odoa nefolalo amoliage Yesuma sähalea, Säla Olelelo-o, dia dolöea hamomolöi made gadoi afädë nilïa melëdelä hamomola säi. ");
INSERT INTO etr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Amala säsebegi, Yesuea säla obëgësalea, Udia dolö walio nefolalebe welia nafademu hamosa nea, udiaea dolö fisilo amo gadola Godeïe mala fisilo amolia, dolöea hamomolöi made gadoi afädë hamomola sälo. Amalo gaso, dolöea hamomolöi made gadoi afädë bea sälo Yonama hamoi amomu ilima olemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona e seme edefade afädëïe isogi segeyo ohodoa gasi ohodoala dilo amo gadola, amase, Dolöïe Malö amoge segeyo ohodoa gasi ohodoala naga hawa diamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Gudimolö segeyo besela galasolo amo gala, Niniba udia dolöea walio udia dolö nefolalebe welibalä nowela aligilahilä, ilima dofea made hamoimelëla sämolömelë. Mida, ilia Yonaea Godeïe ado mala säla ï amo nabalahilä, asigi besusa maadei amea. Amaimo, walio gui nebego eda Yona nelo amo gadoi made, baagila asi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gudisolo amo gala, gädili Siba udia dolö beaha aligilo gini udia amea nowela aligilahilä, walio nefolalebe welibalä, dofea made hamoimelëla sämolömelë. Mida, udia amea Solomono asigi falagasei neebe amoïe ado nabulöïe, wagadi made hïle segeala naba misimelë. Nabuö. Afädë walio gui nebego eda, Solomono nelo amo gadoi made, baagila asi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesuea aso, sähamu nea sähalea, Dolö afädëma mugabe fedai amo doadigila awäseda, mugabe amo sege falaia awälahilä, e hele fimolöïe sege hogosa nea, afädë made beagolelomelë. ");
INSERT INTO etr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Made beagolesegi, hïdomu sähalea, Mosö dïgïla misia ami obëgëmolöla sälomelë. Awäla mosöa besela galala beahamelële, mosö badumu, gëgelë doala, nelebo sulubadela hedabola negesi diëgi beagolelomelë. ");
INSERT INTO etr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bea negesiä, bu doadigila awälahilä, hï eda holöbö hedabilahilä, mugabe gifalädalïa nafadefalï nafade nefolalo amoli ea sigi obëgëla ebalä awäla nogila digalahilä, mosö amogi aligilo. Amaimo, dolö amo dafidi nafade nelo amo baagila, hobeala nafadeifalï nafade aligilomelë. Walio udia dolö nafademu hamosa nefolalebe gowe ilimage amo gadoi wäla hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuea udia dolö gegedoi nefolalo amolima adosa nebegimu, ïe eme edoolali ebalä ado adomolöïe segea maala nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Amala nefolalebegi, afädëa ema sähalea, Dïe dieme didoola ilia dibalä ado adomolöïe segea godogoi misi nefolalebela säi. ");
INSERT INTO etr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Amala säsebegi, Yesuea dolö amoma säla obëgësalea, Nïe nemeda abodo, nïe nedoolalida nowë gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Amala sälahilä, ea ïe bëgëla aulo amolima naabo sögödigila sähalea, Nïe neme nedoolalida nefolalebe gowe ilimelë. ");
INSERT INTO etr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mida, udia dolöea nïe Naado selesaia mosöa neebe amea hamese amo gadola hamosa nefolalebe amolida nïe nedooge, nïe nalifige, nïe nemege, amoli nefolaleamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Segeyo amo galamu, Yesu e mumusogila segea doadigila fedalahilä, oeabo edefade dibe amoïe agesua ami sulo. ");
INSERT INTO etr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sebegi, udia dolö yafie mafula gegedolahilä, e sebe amo nogöla amalei. Nogöla amalesebegi eda ödä dudaia fila fedala sulo. Sebegi, udia dolö gegedoi amolida oeabo agesua ami nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu e amala salea, ea ado besula mala yafie säla ïahalea, Dolö afädëa sagaido gägä fëfëla aliligi asimelë. ");
INSERT INTO etr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fëfëla aliligi awäha nebegi, gägä odoa idiafa daala negei dibegi, haea maalahilä neala naha maadei. ");
INSERT INTO etr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gägä odoa igi naga abelëidaia daala negelahilä, fodolofalï duulu fedala bäui ");
INSERT INTO etr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","gaso, eso neëla galasebegi, difi moholö ulïsalea, bausosa maadei. ");
INSERT INTO etr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amase, gägä odoa ëfë äyo gägäi neebea ami daala negesebegi, ëfë äyo gägäi amo bäulahilä, widi duulu fedasebe amo dabiala yau hai nelo. ");
INSERT INTO etr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gägä odoa naga hedabi dibea ami daala negei amo bäulahilä gägä negeimelë. Odoaea hädali afädë negei. Odoaea nabülasi gafeia negei. Amase, odoaea nabülasi ohodoa negeimelë. ");
INSERT INTO etr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Afädë gëhe galea galëda, hä nabualola säi. ");
INSERT INTO etr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Amala säsebegi, Yesuïe bëgëla aulo amolia e sebea ami maalahilä nabahalea, Dia udia dolöma ado besulamu säla ïaha nebegoda, edoïe amahala nabi. ");
INSERT INTO etr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Amala nabasebegi, Yesuea säla obëgësalea, Mida, Hebeni Beaha Maadela Sigi Neebe amoïe helësëmolöda, dafidi odoa ulufadigi made, musügä negei dilo amo, odoa ilima made ï. Dilima ïmelë. ");
INSERT INTO etr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Amoïeda, afädëa nelebo afädë gaula neebe amomada, odoa baala ïasegi, yafie gaula namolömelë. Amase, afädëa nelebo afädë made gaula holöfalïmelë gaula neebe amoda haila nimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na odoa ilima ado besula säla ïlo amoïe mida, ilia beaha gaso, made bease amoïege, nabaha gaso, made nabala helësëse amoïege amala sälomelë. ");
INSERT INTO etr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Amaimo, Aisaeaea bea säla negei ilima gausiala digasebe amoda gowe. Dilia nabahamu nea gasoda, fädäla made helësëmolömelë. Dilia beahamu nea gasoda, galone gowe gabula made beagolemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Amoïe mida, udia dolö amolile asigi dofogai nea. Ili gëhe gai gadoia hedabola made nabelo nea. Ilile siige dofogai nea. Ilia siia beala, gëhea nabala, asigia helësëla besusa galebeda, amoda na ili wahilasilabiola säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amai gaso, dilia obeägïsa nea. Mida, dilile siia beala, amase, gëheage hä nabahagomelë. ");
INSERT INTO etr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Amai na dilima dofä sähago. Siiba bea sälo yafieage, amase, asigi mogoi nefolalo yafieage, dilia beasego gadola wäla edefademalä bimolö helësëlahilä gaso, made melï nefolalo. Dilia nabasego gadola wäla edefademalä nabulö helësëlahilä gaso, made nabi nefolalola säi. ");
INSERT INTO etr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuea amo sälahilä sähalea, Amai galëda, gägä fëfëlo amoïe ado besula säi amo nabuö. ");
INSERT INTO etr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Beaha Maadela Sigi Neebe amoïe ado mala afädëa nabala fädäla made helësëseda, mugabe busa nafadefalï maalahilä, ado mala ïe asigigi fëfëi amo fedela neala gaula aulomelë. Eda molö gägä idiafa daala negei amo gadoi nea. ");
INSERT INTO etr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Molö gägä igi naga abelëi dibea daala negei amo gadoida, afädëa ado mala nabala obeägïla aabela neala gaulomelë. ");
INSERT INTO etr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amalahilä gaso, e difi moholö ulïla sedade made aligilomelë. Ea ado mala neala gaui amoïe yöi beasege, amase, odoaea e neala sëlasisege, ea fodolofalï dïgïla aulo nea. ");
INSERT INTO etr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Molö gägä äyo gägäi ëfë neebea daala negei amo gadoida, afädëa ado nabaha nea gaso, nagadaia namolö amo säosäola helësëmolöge, nelegei yafie dibe amo asigia negesa maademolöge, amea ea ado mala nabi amo dabiala yau hahalea, gägä made negelo nea. ");
INSERT INTO etr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Molö gägä naga hedabi dibea daala negei amo gadoida, afädëa ado mala nabala helësëlo amole. Ea gägä hedabola negelo amoleda, hädali afädëge, nabülasi gafeiage, nabülasi ohodoage negela digisa aligilo neala säi. ");
INSERT INTO etr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuea ado besula udia dolöma aso, elö sähalea, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Dolö afädëa hïle sagaia eladi gadoi ëi widiïe gägä hedabi amo fëfëla sadia gogoi. ");
INSERT INTO etr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amala hamoi gaso, ili sulubadela adi elaboi difolalebegi, ïe ado nii dolö maalahilä, widi gägä sadia gogoi dibea ami gägä nafade widi gadoi sadia gogola negesia moholöi asi. ");
INSERT INTO etr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Widi bäula, gägä negese amo gaalu, giisi nafade widi gadoi amoge gedola bäui neebe melï. ");
INSERT INTO etr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sagai eedoïe hamoi hamolasilo amolia e neebea awälahilä, ema säla ïahalea, Dafidilo, dia sagaia widi gägä hedabimu hadia gogoi walebelei gaso, giisi nafade bäui neebe amoda abododila maala bäui neadula säi. ");
INSERT INTO etr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Amala säsebegi, ea säla obëgësalea, Goda ado nii afädëa sagai gabugola säi. Amala säsebegi, hamoi hamolasilo amolia ema nabahalea, Nilïa awälahilä giisi nafade amoli besela digidulela nabi. ");
INSERT INTO etr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amala nabasebegi, ea säla obëgësalea, Ai. Giisi nafade amo walio besela digisegi, widi hï ela beselaloea. ");
INSERT INTO etr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Faimolö fu besela galamäia, helegela amala gegedola fedamäia amilasimalo. Amala fisigisilahilä, hobeala faimolö dolö amolima sähalea, Giisi nafade amoli dafidi beselala, gobemolöïe dobosa maadelahilä, hobeala widi hï e damula gegedola negelahilä, nïe molö negelo mosöa ami negemalola sämolömelëla säila säi. ");
INSERT INTO etr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuea udia dolöma ado besula elö sähalea, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Dolö afädëa masada gägä gaula awälahilä, hï sagaia sagai. ");
INSERT INTO etr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gägä amoda holöfalïfalïmelë. Bäuseda, hawa hëhela odoa dägöala sagai dibe amo gadoi made, amoda i gadoi bäulomelë. Bäula fedaha nelolahilä, edefade neëda, haea sefolalebe amoli mafula adomo amogi gilifa hamola dilomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuea ilima aso, ado besula elö sähalea, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Udiaea balawa edefade falodaia besigala salala, amo edelasilo ëi yidi amo gegoala naaboseda, balawa sulubadela edela bolela fedalola säi. ");
INSERT INTO etr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuea udia dolö gegedoi nefolalo amolima ado säi amo sulubadela, memalä made säla, ado besulamu säla ï. ");
INSERT INTO etr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ea amala hamoi amoda, dafidi bea sälo afädëa bea säla negei amo gausiala digai. Na nafi dagala ado besula säla ïmolömelë. Sege föi dibe sulubadela mi gäwila hamoia amila musügä negei difolalo amoligi säla ïmolömelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuea ado mala säla ïala, udia dolö gegedoi amoli amilahilä, e mosöa awäla sebegi, ïe bëgëla aulo amoli maalahilä ema sähalea, ado besula sagaia giisi nafade bäui säi amoïe mi fädäla säla ïmola säi. ");
INSERT INTO etr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Amala säsebegi, Yesuea säla obëgësalea, Dolöea gägä hedabi fëfëla sadia gogola aliligi asi amoda, Dolöïe Malö amo neamelë. ");
INSERT INTO etr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sagai amoda, naga föi dibe wemelë. Gägä hedabi amoda, Hebeni Beaha Maadela Sigi Neebe amoïe malö nefolalebe amomelë. Amase, gägä nafade amoda, mugabe busa nafadefalïïe udia dolö nefolalebe amomelë. ");
INSERT INTO etr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ado niia gägä nafade fëfëla sadia gogoi amoda, mugabe busa neamelë. Molö amo faimolö fuda, segeyo aligila wagamolö amomelë. Molö amo faila negemolöïe hamoi hamolo amolida, selesaia fiimelë. ");
INSERT INTO etr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Giisi nafade amo beselala dobola nulogi gobelo amo gadola, segeyo aligila wagasolo amo galada, amo gadola wäla hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Amala hamomolö amoda, Dolöïe Malö amea, Beaha Maadela Sigi neebea ami nelebo digalasilo sulubadelaea, udia dolö asigi afädë negei amolia nafade hamomäia digalasilo amolige, nafade hamolo nefolalebe amoli sulubadelage, haila fisimäia, ïe selesaia fii amoli fisiga gamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Amala hamolahilä, ilia udia dolö amoli nulo edefade wisebea ami sogobala sadia idogoseda, Ami ili dïisalea bese ali nalëgësa namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amala hamosegi, Udia dolö asigi mogoi amolida, Eedoea Beaha Maadela Sigi Neebea ami nea, ilida eso neë yo gadoi nefolamolömelë. Afädë gëhe galea galëda, hä nabulö galeala säi. ");
INSERT INTO etr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesuea aso sähamu nea sähalea, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Muni musügä negelo amo gadola sagai afädëgi musügä negei dilo. Amala dibegi, dolö afädëa beagolei. Beagolelahilä, bu gesusilahilä awäla, e hïdo elöla obeägïla, nelebo hï gaui amoli sulubadela bidi nelea awäha nelolahilä, sagai amo bidia niimelë. ");
INSERT INTO etr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Amase elöda, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Bidi nelo dolö afädëa bageïe isogi momado hedabi amo gadoi helebe näia dibe amo nimolöïe hogosamu aligilomelë. ");
INSERT INTO etr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Amala hogosolo amo gala, ea helebe näia afädë hedabi hïdo elöi aye negei amo beagolelahilä, ea nelebo hï gaui amoli sulubadela bidi nelea awäha nelolahilä, helebe näia amo bidia niimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesuea ado aso, sähamu nea sähalea, Amase elöda, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Dolö odoaea selëgë oeabo dibea ami digisebegi, seme yafie elö elöla digai. ");
INSERT INTO etr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Selëgë digi amogi nobasebegi, selëgë digilo dolö amolia agesua deala gaula fedala negesila salea, seme hedabi amolida falodaia negesalea, nafade amolida sadia gaimelë. ");
INSERT INTO etr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Segeyo aligila wagasolo amo gala, amo gadola wäla hamomolömelë. Selesaia fii nefolalebe amoli maala, Asigi mogoi udia dolö amoli amilasilahilä, nafade hamolo amoli neala nafolala gegedolasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Amala hamolahilä, udia dolö nafade hamolo amoli nulo edefade wisebea ami sogobala sadia idogomolömelë. Amida, ili dïisalea bese ali nalëgësa namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuea ïe bëgëla aulo amolima nabahalea, Na ado säi amoli sulubadela dilia helësëi nefolalealela nabi. Amala nabasebegi, ilia ema, Äla säi. ");
INSERT INTO etr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Amala säsebegi, Yesuea ilima sähalea, Amai galëda, mala dawadigi sulubadela Hebeni Beaha Maadela Sigi Neebe amoïe dawadigila bëgëlo nefolalebe amolida, mosö eedoea hï nelegei musügä negelo mosöala nelebo gähe hädamade negeile, siiba negeile helegela gaula segea doadigila aulo amo gadoida amoli neala säi. ");
INSERT INTO etr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuea ado amoli besula säha maadelahilä, amila dïgïla awäla ");
INSERT INTO etr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hï e ëdëia gaamugi ami obëgëi. Amala obëgëlahilä, ea ilile gedolo mosöa ami ilima mala säla olelesebegi, ilia asigigi fudugisa sefolalo. Ilia sähalea, Dolö gowea dawa weda, abidi niidu. Geloi melëlo made gadoi hamola nowesebeweda, abidi galudu. ");
INSERT INTO etr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eda mosö olelo amoïe malö madele. Emeïe ëida Meli, amase, ïe edooda Yamese, Yosebe, Saimono, Yudasafulo madele. ");
INSERT INTO etr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amase, ïe elefila ili sulubadelada, nilïbalä sefolalebe gowe madele. Ea nelebo amolida gelola abidi dibegi niidula säi. ");
INSERT INTO etr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ilia amala säla, ema bimolö habobalahilä, hamei made nelo. Amasebegi gaso, Yesuea ilima sähalea, Bea sälo neebe amoda hïle segeafalïge, hïle sosogofalïgige, ëi maade neala säi. ");
INSERT INTO etr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sege amogi fii amolia asigi afädë made negesebegi, ea ami geloi melëlo made gadoi yafie made hamola nelo. ");
INSERT INTO etr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Amo galada, Galili udia dolö beaha aligilo Heledo eada nelebo Yesuea hamosa neala säi amo nabi. ");
INSERT INTO etr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nabalahilä, ea ïe hamoi hamolasilo nefolalo amolima sähalea, Goda ödägi gelo Yone gabugo. E bauia amila nowela galai ameada, ea geloi melëlo made gadoi hamomolöïe geloi gaula nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Dafidi Heledoea edoo Filibiïe udia Helodiasa fedela nii. Amala fedela nii amogi, ödägi gelo Yonea Heledoma dia didooïe udia asiala fedela niimelëla säha nelo. Amala säha nelo amogi, Heledoea Yone galabaia mosöa nafodola negei. ");
INSERT INTO etr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Amala säha nelo amogi, Heledoea Yone nufulö helësëi gaso, udia dolöbalä bedäi. Mida, ilia Yone eda bea sälo neala helësëlo amogi. ");
INSERT INTO etr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Amala hamolahilä, Heledo e ägüla misi segeyo amo besela galasebegi, Helodiasaïe idiwi amea udia dolö gegedoi sefolalebe mogogi ami nea sigoi. Sigosebe amo beala Heledoea edefademalä obeägïlahilä, ");
INSERT INTO etr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","udia malö amoma migalïa diigila ado gelola sähalea, Dia ïmola säse amo gadoida ïmolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Amala sälebe, ïe eme amea gomalä sämalola säsebegi, idiwi amea sähalea, Walio gogi wäla ödägi gelo Yoneïe busa damula falodaia negela ïmola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amala säla ïasebegi, gini e asigia yöia idogolahilä gaso, ea migalïa diigila ado gelola säla ï amoge, udia dolö ebalä gegedola molö naha sefolalebe amolige helësëla, ea udia malö amea säi amo gadola odoama hamomalai. ");
INSERT INTO etr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Amala hamomalalahilä, odoa ili galabaia mosöa fisiga gasebegi, ilia Yoneïe muugi damui. ");
INSERT INTO etr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Damula falodaia gaula maalahilä, udia malö amo hïma ïasebegi, ea emema ïmolö gaula asi. ");
INSERT INTO etr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Amala hamosebegi, Yoneïe bëgëla aulo nefolalo amolia maala, ïe domalo gaula awäla bausilahilä, ilia Yesuma sämolö asi. ");
INSERT INTO etr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ilia Yone nufimelëla säi amo Yesuea nabalahilä, sege e neloa amo dïgïla, e hïdo dudaia fila sege dolö afädë maadeia ami asi. Amala asibua, udia dolö nefolalo amolia Yesu hä asimelëla säi amo nabalahilä, ilile gaamu amoli dïgïla, Yesu asi amo bëbëgëla nagadabodo afiai. ");
INSERT INTO etr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu e ödä dudaiala agesua daala aligilahilä beahamelebe, udia dolö yafie nefolalebe amo beala, ili bobasëlahilä, ilile oloi difolalo amoli wahilasisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Segeyo amo gala deadisebegi, ïe bëgëla aulo amoli Yesu neebea maalahilä ema sähalea, Hä deadifalï gabu. Nilïda sege molö maadeia neebe amo, udia dolö nefolalebe gowe ili dusula awälahilä, molö bidia nimolöïe sege holöfalï ga made dibea ami hogola aliligi afiamalamola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Amala säsebegi, Yesuea ilima säla obëgësalea, Ai. Ilida moholöi made gabu. Ili molö muäia dihili ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Amala säsebegi, ilia ema säla obëgësalea, Nilïada beledi bia, seme äudä amomu wi galeala säi. ");
INSERT INTO etr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Amala säsebegi, Yesuea sähalea, Amo ne neebeawi gaula misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Gaula maasebegi, ea udia dolö nefolalo amoli giisidaia fifigimalolahilä, beledi bia amola seme äudä amola gaula mudaia sida adogola nea, Godema nesegei. Nesegelahilä, ea beledi dagabodasila, ïe bëgëla aulo amolima ïasebegi, ilia udia dolö sefolalo amoligali sogoi. ");
INSERT INTO etr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Amala sogoi amo, ili sefolalo amoli sulubadela naala bolesalea, odoa fea digai amo ïe bëgëla aulo amolia gegedola, adu giwilasi salala nobala negei. ");
INSERT INTO etr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Molö mai amoli, udia malöla nidela made, dolömuda dausini bia gadoia mai. ");
INSERT INTO etr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Amalahilä, fodolofalï Yesuea udia dolö nefolalo amoli dusula afiamalola sämolölahilä, ïe bëgëla aulo amolima sähalea, Dilidale dudaia fila, ödä dëgëla alogodi afiamalola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Amalahilä, ea udia dolö amolima dusula hä afiamalolahilä, e Godema adomolöïe hïdo segebidaia ami fedai. Hä, gagasila digase amo gaalu, Yesu e hïdofalï nelo. ");
INSERT INTO etr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amala neebe amo gaalu, du amo asi mia made awäha nebegi, du awäse amoïe busamadila fo gelola guula maalahilä, ödä aidagusebe amea du amo besu besui. ");
INSERT INTO etr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Amala hamosebegi, sege yomolö amo gaalu, Yesu e ïe bëgëla aulo awäha dibea ami ödädabodo misi. ");
INSERT INTO etr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ilia e ödädabodo maasebe amo bealahilä, edefademalä fudugila emo gigisëla bedäi. Ilia fudugila sähalea, Wae! Gosogoda mugabe gabula sälahilä, ili bedäla üala dodogöi. ");
INSERT INTO etr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amala üala dodogösebegi, Yesuea fodolofalï ilima sähalea, Bedämabio. Asigi hä gelomalo. Weda nemelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Amala säsebegi, Fidaea sähalea, Dafidilo-o, di galëda, di neebea gui ne ödädabodo misiëla sämola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Amala säsebegi, ea misiëla säi. Misiëla säsebegi, Fida e dudaia amila ödädabodo Yesu neebea ami moholö asi. ");
INSERT INTO etr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amala asi gaso, fo gelola guula maase amo beala fudugila bedälebe, ödägi besela digala usabodelä hamosebegi, Fida hï uuahalea, Dafidilo Geloi-e, ne nabelela nimola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Amala säsebegi, Yesuea fodolofalï naabo mogodigia gala gaula nea sähalea, Asigi afädë holöfalï negei-e, abilideläïe asigi äudä negeila nabi. ");
INSERT INTO etr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Amalahilä, ele dudaia fia adogoi amole fo guula maaha nelo amo boogelei. ");
INSERT INTO etr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Amasebegi, ïe bëgëla aulo dudaia sefolalo amolia Yesuïe ëi gauia adalahilä sähalea, Dida dofä Godeïe malö nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Amala hamolahilä, ili oeabo edefade amo dëgëla agesua amila awäla, sege ëi Genesaledi ami besela galai. ");
INSERT INTO etr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Besela galasebegi, udia dolö nefolalo amolia e beala Yesu gabula helësëlahilä, ilia sege ga made difolalo amoli sulubadelama säla sogosebegi, oloi difolalo amoli sulubadela Yesu neebea ami sigi maaha maadei. ");
INSERT INTO etr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sigi maalahilä, ilia ema gelola sähalea, Oloi difolalebe gowe ilia dïe fagulo bidigimu diigimäiamelëla säi. Amo gadola, Yesuïe fagulogi diigi amoli sulubadela hä, wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Amala hamosebegi, Felesi dolö odoa nefolalo amolige, mala dawadigi odoa nefolalo amolige, Yalusalemela Yesu neebea ami maala, ilia ema nabahalea, ");
INSERT INTO etr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Dïe bëgëla aulo amoliada nilïle mäu ilia siiba aialo mala negei amo damula, naabo nigime hëla made molö nülo amoda mi edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Amala nabasebegi, Yesuea ilima säla obëgësalea, Dilia dilile aialo mala siiba negei gomu helësëlahilä, Godea hamomalai amo damulo amoda mi edoïe. ");
INSERT INTO etr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Godea sähalea, Dïe diado diemele hedabola helësëla, elele ado nabala hamomalola säi dialea. Amase elöda, afädëa eedole emele gadiaboseda, baagomäia nufulö dialeala säla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amai gaso, Afädëa hïle nelegei amogi, eedole emele ugila negemolö nea, dilia gomalä sälo, Nelebo goweda Godegali odala ï dialeala säseda, ");
INSERT INTO etr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ea eedo helësëla hedabola ugila negemolöïe, made sälo. Dilia mala amala hamolo goeada, dilile siiba aialo mala negei amo hamosalea, Godeïe mala säla negei amo neadigila fisilo gabu. ");
INSERT INTO etr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Asigi fea negelo dili, bea sälo Aisaeaea dilile hedabola bea sähalea, ");
INSERT INTO etr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Udia dolö amolia nema asigi wagadi made ga negesilahilä, adoeamu nïe ëi gauia adalo nea. ");
INSERT INTO etr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ilia olelesaleada, dolöfäea mala säla negei amomu olelelo nea. Amaimo, ilia nïe ëi memalä gauia adalo nebegola bea säla dëdëla negei dialeala Yesuea säla ï. ");
INSERT INTO etr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuea udia dolö mofiamalolahilä, ea ilima sähalea, Dilia nabala hedabola helësëmalo. ");
INSERT INTO etr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nelebo nafiadi digasebe ameada, udia dolö Godeïe siigi nigime baalo made. Nelebo isogi dilo nafiadila segea doadigila awäse ameada, udia dolö Godeïe siigi nigime baalomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hobeala ïe bëgëla aulo amolia Yesu neebea maalahilä sähalea, Dia ado säi amo nabala, Felesi dolö nefolalo amolile iso asigigi gäwisalea sësebe amoda dihï melïlela säi. ");
INSERT INTO etr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Amala säsebegi, Yesuea säla obëgësalea, Nelebo sulubadela nïe Naado selesaia mosöa neebe amea, made sagai amoda, soomo aala digisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Felesi dolö ilida gamelä, helësëmabu. Hili ili si golai nea, dolö odoa nefolalebe amoli naabogi gaula sigi aulo nebego. Si golai elöea si golai elö naabogi gaula sigi awäha neëgi, helegela balagula dögöigi digalomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Amala säsebegi, Fidaea säla obëgësalea, Ado besula säi amoïe, mi, dia nilïma awala säla ïmola säi. ");
INSERT INTO etr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Amala säsebegi, Yesuea säla obëgësalea, Dilige asigi made gäwi nelo amo gadoi wäla neale. ");
INSERT INTO etr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nelebo nafia digase amoda isogi digalahilä, segea doadigila aulo amo dilia dawa made neale. ");
INSERT INTO etr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amai gaso, nafiadila segea doadigila awäse amoda, iso asigigila besela galasebe amea, udia dolö Godeïe siigi nigime baalomelë. ");
INSERT INTO etr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mida, iso asigigila besela galalo amoda asigi nafadege, udia dolö baagomäia nufulöge, udia dolö fa nimolöge, hilimu nafade odoa hamomolöge, nelegei fa nimolöge, wäfalï sämolöge, odoama ado nafadela sämolöge. ");
INSERT INTO etr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mala nafade amolia udia dolö Godeïe siigi nigime baalomelë. Amalo gaso, naabo nigime hëla made, molö nülo ameada, udia dolö Godeïe siigi nigime baalo mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sege amo dïgïla, Yesu e Daiamadige Saidonomadige asi. ");
INSERT INTO etr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ami awäsebegi, Gainana udia afädë segea ami sulo amo Yesu neebea maalahilä, ema uuala sähalea, Debidiïe malö-o, ne bobasëla ugila negemo. Nïe nidiwima mugabe fedalahilä, e neala nafadesaleamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amala säsebegi, Yesuea ema ado afädë säla obëgëla made nebegi, ïe bëgëla aulo amoli Yesu neebea maalahilä ema sähalea, Udia gowea nilï baagia aligila uuala aligi maasebego mosalamola säi. ");
INSERT INTO etr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Amala säsebegi, Yesuea säla obëgësalea, Isilale udia dolö sugua sibi dabadigi gadoi nefolalebe amolilemu ne fisiga wei neawela säi. ");
INSERT INTO etr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amala säsebegi, udia amea Yesu neebea maalahilä, e mia emo gumu sasagala salea, ema sähalea, Dafidilo-o, ne ugila negemola säi. ");
INSERT INTO etr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Amala säsebegi, Yesuea säla obëgësalea, Malö ilile molö negeiwegida ügülogali sadia gala ïmolöda dofea madela säi. ");
INSERT INTO etr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Amala sälebegi, udia amea sähalea, Dafidilo, amo dofä. Gasoda, ügüloïe eedoea molö nahalea dusula digase amoda, ügüloea nülola säi. ");
INSERT INTO etr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Amala säsebegi, Yesuea ema säla obëgësalea, Udia-o, dia asigi afädë negei goda edefade. Dihï hamesebego gadola hamomolömelëla säi. Yesuea ado säia gai fu amogi wäla udia amoïe idiwi amo hä wahi. ");
INSERT INTO etr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu e sege amo dïgïla, Galili oeabo dibe amoïe agesuadi awäha nelolahilä, gau fedala deadigia adogolahilä e ami sulo. ");
INSERT INTO etr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ami sebegi, udia dolö yafie e neebea ami gegedolahilä, ilia emo nafadeige, si golaige, domalo nafadeige, nafi dofogaige, amase, olo elö elöla oloige, sulubadela ïe emo mia gaula mafula negesebegi, ea ili wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Amala hamosebegi, udia dolö gegedoi amolia beahamelebe, nafi dofogai odoa amoli ado adola digi, domalo nafadei amoli wahila digi, emo nafadei amoli nawela digi, si golai nefolalo amolia beasebe amo bealahilä, ili fudugilahilä, ilia Isilaleïe Gode neebe amoïe ëi gauia adaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuea ïe bëgëla aulo amoli wela mofiamolahilä ilima sähalea, Udia dolö nefolalebe gowe ili asigii gabumelë. Mida, nebalä hä segeyo ohodoa nelo amea, ili molö maade gabu. Sïdëa baagoi amola wäla mosöla sämolöda, na made hamesa. Idiafa ili si dädäbëlela digaloeala säi. ");
INSERT INTO etr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Amala säsebegi, ïe bëgëla aulo amolia ema nabahalea, sege nafade udia dolö aligisia made wi, udia dolö yafie gegedoi nefolalebe weli, molö molö amo abidi nimolödula nabi. ");
INSERT INTO etr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Amala nabasebegi, Yesuea ilima nabahalea, Beledi aboläia galebela nabi. Amala nabasebegi, ilia säla obëgësalea, Beledi gifalädalïa, seme nelësa naabo safo gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Amala gabula säsebegi, Yesuea udia dolö amoli nagadaia fifigimalai. ");
INSERT INTO etr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Amala sälahilä, ea beledi gifalädalïa amoge seme amoge gaula nea, Godema nesegei. Nesegelahilä, dagabodasila ïe bëgëla aulo amolima ïasebegi, ilia udia dolö sefolalo amoligali sogoi. ");
INSERT INTO etr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Udia dolö sulubadela sefolalo amolia molö dofea naha maadelahilä, fea digai amo adu gifalädalïagi salala nobala negei. ");
INSERT INTO etr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Udia malöla nidela made, molö mai amolida dausini biyidia sefolalo. ");
INSERT INTO etr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Amalahilä, Yesuea udia dolö gegedoi amoli afiaha maademalolahilä, e ödä duugi fila sege ëi Magadani asi. ");
INSERT INTO etr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Felesi dolö nefolalo amolige, Sadiusi dolö nefolalo amolige, Yesu neebea ami maalahilä, ilia Yesu fedogola ema sähalea, Nilïa di Godeïe hamoi hamolo gabula melëdelä, dia dolöea hamomolöi made gadoi afädë selesaia mosöala misi dia nilïma olela hamomola säi. ");
INSERT INTO etr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Amala säsebegi, ea säla obëgësalea, Deadi eso fidila digahalea, mu bëla obëgëseda, dilia hä, esomolö gabula sälo. ");
INSERT INTO etr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Amase elöda, sege yose gaalu, gelë muugi baala bëla gasimi sagaseda, diliada walio hä fo maala, sege digamolö gabula sälomelë. Amaimo, dilia mu giwigi bealahilä, amo gadola hamomolö gabulada helësëlo gaso, walio hamosebe amo beala, mi goweïe hamosebela dilia dawa made nefolalebegola säi.  ");
INSERT INTO etr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Udia dolö walio nefolalebe welia nafademu hamosa neebe ameada, udiaea dolö fisilo amo gadola Godeïe mala fisilo neebe amoliada, dolöea hamomolöi made gadoi afädë hamomola sälo. Amalo gaso, dolöea hamomolöi made gadoi afädë Yonama hamoi amomu ilima olemolömelëla säi. Amala sälahilä, ili dïgïla e bahïla moholöi asi. ");
INSERT INTO etr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bëgëla aulo amoli oeabo edefade dibe amo dëgëla näiado alömodi besela galahamelebe, beledi afädë made ägüla elabola misi melï. ");
INSERT INTO etr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Amaimo, Yesuea ilima sähalea, Felesi dolölele Sadiusi dolölele beledi edelo yidi amo helësëla, idihë nea hedabola beaha namialola säi. ");
INSERT INTO etr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Amala säsebegi, ilia hilidomu didiähalea, Nilïa beledi made ägüi amoïe säsebela didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Hilidomu didiäha dibe amo Yesuea dawadigi nea, ilima sähalea, Asigi afädë holöfalï negeila dili, dilia beledi maade gabula didiäsebegoda edoïe. ");
INSERT INTO etr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Dilia dawadigi made nelo amo, Aso, amo wälasimu nelo amo neagole. Beledi bia amea dausini biaea nalahilä, fea digai amo dilia adu aboläiagi salala nobala negei. Amoda dilia elaboi neale. ");
INSERT INTO etr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amase elöda, beledi gifalädalïa amea dausini biyidiaea nalahilä, fea digai amoda dilia adu aboläiagi salala nobala negei. Amoge dila elaboi neale. ");
INSERT INTO etr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na dilima belediïe säi made amo, dilia dawadigi made nebegoda edoea. Felesi Sadiusilele beledi edelo yidi dibe amoïe hedabola idihë namialola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Amala säsebegi, ilia helësësaleamelebe, ea hedabola idihë namialola säi amoda beledi neala edelo yidiïe made säi gabu. Felesi dolöle Sadiusi dolölea mala säla olelesebe amoïe säi gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu e Sisalia Filibai gaamumadi awäla besela galalahilä, ea ïe bëgëla aulo amolima nabahalea, Udia dolö nefolalebe amolia Dolöïe Malö amoda nowë neala säha difolalebela nabi. ");
INSERT INTO etr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Amala nabasebegi, ilia säla obëgësalea, Odoaeada ödägi gelo Yone neala säla digi, odoaeada Elaia neala säla digi, amase, odoaeada Yelemaea galë, bea sälo elö galë neala säla digisa difolaleamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Amala säla obëgësebegi, ea ilima nabahalea, Amai, diliada ne nowë neala säha dialeala nabi. ");
INSERT INTO etr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Amala nabasebegi, Saimono Fidaea säla obëgësalea, Afädë Memelei amoda dimelë. Dida Gode namolöi neebe amoïe malö nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Amala säsebegi, Yesuea säla obëgësalea, Yonaïe malö Saimono-o, dida obeägïsa nea. Mida, dia walio säi amoda nagadaia dolöea dima olei made. Nïe Naado selesaia mosöa neebe amea oleimelë. ");
INSERT INTO etr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amaimo, na dima sähago. Dïe ëida Fida. Igi amodaia nïe udia dolö Godea wela ifosisi nefolalebe amoli na ulimolömelë. Olasegi, baagomolö amoïe geloi ameada made nufuda salala salolemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hebeni Beaha Maadela Sigi Neebe amoïe idi gai dogelo gii amo na dima ïmolömelë. Dia naga föidaia wi hamomolö madela säla negese amoda, Hebenige made hamomolömu dialea. Amase, dia naga föidaia hamomolö dialeala säsebe amoda, Hebenige hamomolömu dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Amala sälahilä, ea ïe bëgëla aulo amolima gelola sähalea, Afädë Memelei moholömelëla säla negei amoda ne neawemelë, odoama säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Segeyo amila nofela, Yesuea mi gäwilafalï, ïe bëgëla aulo amolima fädäla säla ïahalea, Ne Yalusaleme moholö neamelë. Ami awäseda, dolö dafidilo asigi gäwi nefolalebe amoliage, gobela ïlo busa nefolalebe amoliage, amase, mala dawadigi nefolalebe amoliage, ne edefademalä sëlasimolömelë. Amala hamolahilä, ilia ne baagomäia nufudasegi, segeyo äudä nelolahilä osodagi ne nowemolömelë. Amala hamomolö galeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Amala säsebegi, Fidaea Yesu e sigi aliga galahilä nemola sähalea, Dafidilo Geloi-e, amala sämabu. Dima dofä amala made hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amala säsebegi, Yesu e besuia imogola Fidama sähalea, Ae. Saidani, ne neebeawi namolö made. Mosö. Dia nïe idiafa dofogasebego. Diada Godea helësëlo amo gadola made, dolöfäea helësëlo wäla helësësebela säi. ");
INSERT INTO etr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Amala sälahilä, Yesuea ïe bëgëla aulo amolima sähalea, Afädëa ne awäsewe gadola moholö helësëseda, hï hamea hamela helësëlo amo fisila, hïle i fügäi gaula, ne bëgëla moholö dialea. ");
INSERT INTO etr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mida, afädëa hïle namolö amo gaula fëdöla aligimolö helësëseda, ïe namolö amo hogosa helemolömelë. Amai gaso, afädëa hïle namolö amo ne helësëla fisiseda, ea ïe namolö amo hï gaula namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Afädëa nagadaia nelegei sulubadela neala gaula nea hï e baagoseda, nagadaia nelegei amea e abeahäla ugila negemolödu. Amase, afädëa bidi edo ïalahilä, hïle namolö amo hï bu nea obëgëmolödu. ");
INSERT INTO etr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Amala säsebe amoïe mida, Dolöïe Malö amea ïe Eedoïe yo digalo hïdo elöi amo salugalahilä, ïe selesaia fiibalä moholömelë. Maasegi, ea udia dolö sulubadela gali hili hamoi amo gadola bidi ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na dilima dofä sähago. Dolö odoa walio gui nefolalebe gowe ili baagola made, aso, neëgi wäla Dolöïe Malö amo, ïe Beaha Maadela Sigi Neebe amobalä maase amo bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Segeyo gafeia nelolahilä, Yesuea Fidage, Yamesege, Yameseïe edoo Yonege, ili sigi awäla segebi edefadedaia gadogofalï fedala hilidofalï nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ami nefolalea beahaleamelebe, ilile sidaia Yesuïe domalo bedefala hïdo elöi neebe melï. Ïe odagi eso si gadoi neëla, ïe fagulo gäi amoge falela yo digai hïdo elöi neebe melï. ");
INSERT INTO etr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Amo bealahilä, ilia beahaleamelebe, Mosesele Elaiale maala ulufadigilahilä, Yesubalä adosa neebe melï. ");
INSERT INTO etr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Amo bealahilä, Fidaea Yesuma sähalea, Dafidilo Geloi-e, nilï wi neebewe hedabi gabu. Na sege mosö ohodoa oledule. Elöda dïe, elöda Moseseïe, elöda Elaiaïela nabi. ");
INSERT INTO etr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ea ado amo, aso, säha nebegi wäla, gelë häu faleifalï hïdo elöia ili neebeadi maala dabelahilä, gelë amoïe isogila ado afädë sähalea, Egoweda nïe malö, na boba hamosa neawe. Ema edefademalä obeägïsamelë. Dilia ïe ado nabualola säi. ");
INSERT INTO etr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ado säi amo nabala, bëgëla aulo amoli edefademalä fudugila bedälahilä, nagadaia gumusula dia didigafui. ");
INSERT INTO etr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amala difolalebegi, Yesu e ili difolalebea ami maala didiigisalea, Bedämabu. Nowemola säi. ");
INSERT INTO etr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Amala didiigisebegi, sida adogola beahaleamelebe, dolö elö maade, Yesu e hïdomu neebe melï. ");
INSERT INTO etr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ili segebidaia amila digafiaha dialea, Yesuea ilima gelola sähalea, Dolöïe Malö amo bauia amila, aso, made nowela neëgida, dilia melï amo odoama säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Amala säsebegi, bëgëla aulo amolia Yesuma nabahalea, Mala dawadigi nefolalebe amolia Elaiadale dafidi moholöla sälo amoda mi edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Amala nabasebegi, ea säla obëgësalea, Elaia eda dofä moholö. Eada nelebo sulubadela hahamogisa namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gaso, na dilima sähago. Elaia eda misi. Misi gaso, udia dolö nefolalo amolia e gabula helësëla made, ilia hamomolö helësëi amo gadola hamosa nelomelë. Amo hamosa nelo amo gadola wäla, Dolöïe Malö eege neala sëlasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Amala säsebegi, bëgëla aulo amolia helësësalea, ado ilima säsebe amoda ödägi gelo Yoneïe säsebela helësëi. ");
INSERT INTO etr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ili afiala, udia dolö gegedoi dibea ami besela galasebegi, dolö afädë maala Yesu mia emo gumu sasagala salea ");
INSERT INTO etr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","sähalea, Dafidilo Geloi-e, nïe malö bobasëmo. E amulämelahilä, së yafie nülomelë. E amulämesalea nulo gobeiage, ödägige digalasisamu aligilo. ");
INSERT INTO etr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amaimo, dïe bëgëla aulo amoli nefolalebea e sigi misi gaso, ilia e wahilasimolöi made gabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Amala säsebegi, Yesuea säla obëgësalea, Udia dolö asigi afädë made negela asiala hamolo walio nefolalebela dili, ne dilibalä segeyo aboläia namolödu. Segeyo aboläiagi na dilile yöi gaula namolödu. E ne neebea sigi misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sigi maasebegi, Yesuea mugabe amoma nemosebegi, mugabe amo doadigila asi. Amala asi amole, malö maalïbu amo hä fodolofalï wahi. ");
INSERT INTO etr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hobeala, bëgëla aulo amoli Yesu e hïdomu neebea ami maalahilä, ema nabahalea, Amai nilïa mugabe nesila digilibe ïliawai amoda edoeadula nabi. ");
INSERT INTO etr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Amala nabasebegi, ea ilima sähalea, Dilia asigi afädë negei nebegoda, holöfalï negei nebegoea amaimelë. Na dilima dofä sähago. I masada gägä holöfalï dibe amo gadoi asigi afädë negela nea, segebi gowema sähalea, Guilahilä gagowedi gasi gamola säseda, gasi gamolömelë. Amase, dilia afädë hamomolö asusugai ïliawaida maade bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesula ïe bëgëla aulolali Galili ami gegedolahilä, Yesuea ilima sähalea, ilia Dolöïe Malö e dolögali gaula ïmolö segeyo hä besela galasebemelë. ");
INSERT INTO etr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Gaula ïaseda, ilia e nufudala baagomolö, gasoda, segeyo äudä nelolahilä, osodagi e nowela moholömelëla säi. Amala säsebegi, ili asigia yöia idodogoi. ");
INSERT INTO etr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesula, ïe bëgëla aulo amolali awäla, Gabaniama gaamugi besela galala, ili ami nebegi, gobela ïlo mosö amoïe dagisi muni nelo nefolalo amolia, Fida neebea maalahilä ema nabahalea, Dïe säla olelelo neebe ameada dagisi muni negelolela nabi. ");
INSERT INTO etr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Amala nabasebegi, Fidaea säla obëgësalea, Ä, negelomelëla säi. Amala sälahilä, Fida e mosö amoïe mumusogi nogila digala adola made nebegi, Yesu, eadale Fidama nabahalea, Saimono, dia abilia helësësebe. Nagadaiaïe gini nefolalebe amolia, dagisi munige, nelebo elö elöla ïmolö dibe amolige neasebe amo, nowëa nea negelo. Ilile malöealedu, ma, odoaealedula nabi. ");
INSERT INTO etr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Amala nabasebegi, ea säla obëgësalea, Odoaea gabiola säi. Amala sälebegi, Yesuea ema sähalea, Amai galëda, hilile malöeada dagisi muni made ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amai gaso, alïa ili neala habobalasiloea, dia oeabo dibea ami seme däamolö mosalo. Amaimo, seme dafidi dease amoïe nafigida, muni giwi afädë dië bimolömelë. Ameada gobela ïlo mosö amoïe dagisi muni dïege nïege negemolö dofea bimolömelë. Amo neala gaulahilä, alïle dagisi muni ilima ïa mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Segeyo amo gala, bëgëla aulo amoli Yesu neebea maalahilä, ema nabahalea, Hebeni Beaha Maadela Sigi Neebea ami baagila awäla neebe amo nowëdula nabi. ");
INSERT INTO etr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Amala nabasebegi, Yesuea malö holöbö wela, ilile sidaia ifosilahilä ");
INSERT INTO etr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","sähalea, Na dilima dofä sähago. Dilile asigi bedefala, malësä gowe gadoi made aligiseda, Hebeni Beaha Maadela Sigi Neebea ami made nogila digamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hï e nagadaiala, malö holöbö gowe gadoi neebe ameada, Hebeni Beaha Maadela Sigi Neebea ami baagila asi nea. ");
INSERT INTO etr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Amase elöda, afädëa nïe ëigi malö holöbö gowe gadoi neebe amoma, halïgïla namolö misiëla säseda, nemage halïgïla namolö misiëla sähagomelë. ");
INSERT INTO etr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Afädëa malö holöbö nema asigi afädë negei goweligi afädë neala digalasiseda, ëfëa igi edefademalägi begela, bidi näiadoea ïe muugia begelalahilä, ödäea muäia duhulugi hadia idogoseda, ïe hedabida amomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yesuea ado aso, sähamu nea sähalea, odoaea asiala hamomäia, nagadaia dolö nefolalebe amolia digalasilo amoïe, ili asigii gabu. Digalasilo amolida dofä moholöi galea gaso, nelebo amoli hamomäia, doga negelo dolö amo asigii gabu. ");
INSERT INTO etr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dïe naaboea galëge, emoea galëge, di neala digalasiseda, damula sadia gamalo. Naabo elö amo mauäi, emo elö amo mauäi neebe amoda, namolöi namolö dibea ami nogila digamolöda, dofea galea. Naabo äudä galëge, emo äudä galëge, nulo usilo made dibea sadia idogomolö amo nafade gabugi. ");
INSERT INTO etr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Amase, dïe siia di neala digalasiseda, beselala sadia gamalo. Si afädëfalï galëda, namolöi namolö dibea ami nogila digamolö amoda, dofea galea. Si helegela galëda, heli segea nulo gobei dibea ami sadia idogomolö amo nafade gabugila säi. ");
INSERT INTO etr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Yesuea ado aso, sähamu nea sähalea, Dilia malësä goweligi afädë memalä gadoi gabula helësëmabio. Na dilima sähago. Malësä go ilile selesaia fii nefolalebe amolida, nïe Naado selesaia mosöa neebe amoïe odagia amimu aligilo nea. ");
INSERT INTO etr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Dilia abilia helësësebe. Dolö afädëa ïe sugua sibi hädali afädë foi nelo amoligi, afädë nafolala asi galëda, eedo amea, nabülasi sëgëlasiïe odoai sëgëlasi amoli, felea ifosilahilä, afädë nafolala asi amo hogola aulo madele. ");
INSERT INTO etr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na dilima dofä sähago. Hogola asi amo beagoleseda, sugua sibi odoa made nafolala asi amoligi obeägï amo gidogolahilä, sugua sibi afädë beagolei amogi, edefademalä obeägïlo. ");
INSERT INTO etr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Amo gadola wäla, dilile Diado selesaia mosöa neebe amea malësä goweligi afädë dabadigimäia made hamesa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesuea ado aso, sähamu nea sähalea, Dïe didooea dima nafade afädë hamoseda, hïdo neebea ami awälahilä, halidomu nea, ea asiala hamoi amo olemalo. Dia ado säsebe amo ea nabaseda, dia didoo hä sigi obëgëigomelë. ");
INSERT INTO etr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ea dia ado säsebe amo made nabaseda, dolö afädë galë, äudä galë dibalä awähaeamalo. Amoïe mida, äudäea galë, ohodoaea galë ea asiala gowe hamoila sämäia ado säi dibe amo gadola mogomalo. ");
INSERT INTO etr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amala hamosegi, dolö amea ilia säse amo made nabala auauseda, udia dolö Godea wela ifosisi nefolalebe amolima sämalo. Amala hamosegige, dolö amea ilia säse amoge hä, made nabala auauseda, dilia Gode helësëlo made amolimage, amase, dagisi muni nelo amolimage mala hamolo amo gadola, dolö amoma hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Amaimo, na dilima dofä sähago. Dilia nagadaia nea hamomolö madela säsebe amoda, Hebenige hamomolö mademu dialea. Amase, dilia nagadaia hamomolö dialeala säsebe amoda, Hebenige hamomolömu dialea. ");
INSERT INTO etr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Amaimo, na dilima ado elöge sähago. Nagadaia wi nea, diligi äudäea ado afädë negela Godea afädë gowe hamomäiala säla, ema adoseda. Nïe Naado selesaia mosöa neebe amea, hamomalola säse amo gadola hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Amaimo, äudäea galëge, ohodoa galëge, nïe ëigi gedola neëda, ne ili mogogi ami namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amala säsebegi, Fida e Yesu neebea maalahilä, ema nabahalea, Dafidilo Geloi-e, nedoo afädëa nema nafade hamoseda, na aboläiagi hëmolödu. Ma, Gifalädalïalaledula nabi. ");
INSERT INTO etr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Amala nabasebegi, Yesuea ema säla obëgësalea, Nada gifalädalïamula made säha. Nada nabülasi gifalädalïaïe odoai gifalädalïamelëla sähago. ");
INSERT INTO etr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Amoïe mida, Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Beaha aligilo gini afädëa ïe hamoi hamolasilobalä bidi negei dilo amoda, hä mogomolöila helësëimelë. ");
INSERT INTO etr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ea mogodelä hamosebegi, ïe hamoi hamolasilo afädëbalä muni edefade nidemolö asusugai bidi negelo amo, e neebea sigi misimelë. ");
INSERT INTO etr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hamoi hamolasilo amea bidi negei amo beselala ïmolöi made ameada, ïe dafidiloea dolö odoama sähalea, Muni bidi negei amo beselala ïmolöïe, hï eege, ïe udiage, ïe malöge, amase, ïe nelegei dibe amo sulubadelage, muni neaha maademalola säi. ");
INSERT INTO etr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Amala säi amo nabalahilä, hamoi hamolasilo amea e mia emo gumu sasagala salea, fudugila sähalea, Made habobala, aso, beaha namialo. Na dihïma sulubadela beselala ïaha maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Amala säla obëgësebegi, hamoi hamolasilo amoïe dafidilo amea bobasësalea, e mosalolahilä, bidi negei amo hëi. ");
INSERT INTO etr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amala hamosebegi, dolö amo doadigila fedahamelebe, dolö afädë ebalä hamoi gaalu hamolasilo amo gausiala digai. Dolö amea ebalä ïe bidi holöfalï negei dilo. Ea dolö amoïe muugia fëdöla gaula nea sähalea, Nïe muni bidi negei amo hä beselala ïmola säi. ");
INSERT INTO etr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Amala säsebegi, ebalä bidi negelo amea, gumusula dialea fudugila sähalea, Made habobala, beaha namialo. Na dïe go beselala ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amala säsebegi gaso, bidi negelo dolö amea beaha namolö made helësëla, elö amea bidi negei amo beselala ïmäia, e galabaia mosöa ifosi. ");
INSERT INTO etr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Amala hamosebegi, hamoi hamolasilo odoa nefolalo amolia ea hamose amo beala, ilia edefademalä habobai. Habobalahilä, ilile dafidilo neebea awäla, nelebo sulubadela hamoi amo ema awala säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dafidilo amea ïe hamoi hamolasilo amo misialolahilä, ema sähalea, Hamoi hamolasilo nafade di, dia nema fudugila säi amea, dïe bidi negei amo na hësa maadeimelë. ");
INSERT INTO etr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na di bobasëi amo gadola, diada dibalä hamoi gaalu hamolo amoge bobasëmolöi galea madelela säi. ");
INSERT INTO etr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Amala sälahilä, dafidilo amea edefade habobalahilä, ïe bidi negei amo hulu beselala ïaha maademäia, dolö amo galabaia mosöa sëlasilo dolö amoligali gaula awäla ifosi. ");
INSERT INTO etr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dili hïdo hïdolaea didooea asiala hamoi amoli iso asigigila made hëseda, nïe Naado selesaia mosöa neebe ameage, dolö dafidiloea hamoi amo gadola wäla, dilima hamomolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuea ado amo säha maadelahilä, Galili sege dïgïla ödä Yodona dëgëla alömodi Yudia segeamadi asi. ");
INSERT INTO etr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Udia dolö yafiege e awäse amo gadola bëgëla afiai. Maasebegi, ea oloi amoli wahilasisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Felesi dolö nefolalo amoli Yesu neebea maalahilä, ilia e fedogola beala sähalea, Galonegige, galone madegige, nilïle ado säla negei dibe ameada, dolö afädëa ïe udia fisimolö dialeala säi dialeale, ma, madelela nabi. ");
INSERT INTO etr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Amala nabasebegi, Yesuea säla obëgësalea, Mi gäwila hamosolo amo gala, Godea udiale dolöle äudä hamoila säla dëdëla negei dibe amo dilia made melï neale. ");
INSERT INTO etr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ea aso, elö sähalea, Amala hamoi ameada, dolöea ïe eedole emele dïgïla, ïe udiabalä gedola nea, ele domalo afädëfalï namolö madele. ");
INSERT INTO etr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Amalo amo, ele äudä nelo amo fisila, ele afädëfalï aligilomelë. Amoïe mida, Godea gedolasila ele afädëfalï namiäia dilasi amo, dolöea hïdo hïdolasimabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Amala säsebegi, Felesi ilia ema nabahalea, Amai galëda, Mosesea ado säi dibe amea sähalea, Dolö afädëa udia nii amo fisisaleada, beba dëdëla ïalahilä, fisimolö dialeala säi amoda, abilia säidula nabi. ");
INSERT INTO etr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Amala nabasebegi, ea ilima säla obëgësalea, Dilile iso asigi geloi dibe amoïe, Mosesea udia nii fisimolö dialeala säi gabio. Gaso, mi gäwila hamoia amida amo gadola hamolo negei made. ");
INSERT INTO etr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Amoïe mida na dilima sähago. Dolö afädëa ïe udia amea dolö elöbalä mala nafade hamosegi made, memalä fisila, udia elö neaseda, ea udia elö amo fa nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Amala säsebegi, ïe bëgëla aulo amolia ema säla obëgësalea, Dolöea udiama amo gadola hamomolö galëda, udia nimolöda dofea made gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuea ilima säla obëgësalea, Ado walio säseweda, sulubadelaea neala gaumolöi made dialea. Ado nimäia Godea geloi ï amoliamu nelo. ");
INSERT INTO etr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nabuö. Dolö udia made nimolö mi elö elöi salea. Odoada, emea neegela ägüsolo amo gala udia nimolöi made, neegela ägüi. Odoada, dolöea ili iso neadigi nea. Amase, odoaeada, Hebeni Beaha Maadela Sigi Neebe amomu asigisalea, udia made neala aligilo. Säla olelesewe nabala, neala gaumolöi galëda, neala gaumalola säi. ");
INSERT INTO etr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Udia dolö odoa nefolalo amolia, ilile malö Yesuïe naaboea diigila, Godema adomäia e neebea sigi maasebegi, ïe bëgëla aulo amolia ilima halala nemola dofogai. ");
INSERT INTO etr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amala nemosebegi, Yesuea ilima sähalea, Dofogamabu. Malësä ne neebea misiäia beasimo. Mida, Hebeni Beaha Maadela Sigi Neebea ami, malësä gowe ili gadoi neebe amolile dialeamelë. ");
INSERT INTO etr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Amala sälahilä, malësä amoli naaboea diigilahilä, ea sege amo dïgïla asi. ");
INSERT INTO etr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Segeyo afädëgi, dolö afädë Yesu neebea maalahilä ema nabahalea, Säla Olelelo-o, ne namolöi namolö neala gaumolöïe, hamoi hedabi abodo gadola hamomolö dialeadula nabi. ");
INSERT INTO etr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Amala nabasebegi, Yesuea ema säla obëgësalea, Mala hedabi amoïe dia nema edoïe nabaha. Afädë emu hedabi nea. Di namolöi namolö dibea ami nogila digamolöila helësëseda, nilïa hamomalai amoli hamosa namialola säi. ");
INSERT INTO etr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Amala säsebegi, dolö amea naba obëgësalea, Amoda abodowedula nabi. Amala nabasebegi, Yesuea säla obëgësalea, Baagomäia nufuabio, udia dolö fa nimabio, nelegei fa nimabio, wäfalï sämabio, ");
INSERT INTO etr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","amase, dïe diadole diemele hedabola helësëla, elele ado nabala hamomalo, dihïdi boba hamolo amo gadola, odoa dibalä nefolalebe amoli boba hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Amala säsebegi, malïsä amea säla obëgësalea, Amolida na sulubadela hamosa maadei. Gaso, Nema maadeda edodula nabi. ");
INSERT INTO etr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Amala nabasebegi, Yesuea ema sähalea, Di hedabi mogoifalï namolöila helësëseda, dïe nelegei dibe amo bidi neaha maademolö mosö. Amalahilä, bidi nease muni amoda, dolö busadäoi nefolalebe amoligali ïmalo. Amala hamoseda, di Hebeni ami bidi nimolömelë. Amalahilä, ne bëgëla misialola säi. ");
INSERT INTO etr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ado säi amo nabalahilä, malïsä amea asigigi yöia idogolahilä asi. Mida, ïe nelegei yafie dilo amogi. ");
INSERT INTO etr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Amo beala Yesuea ïe bëgëla aulo amolima sähalea, Na dilima dofä sähago. Nelegei yafie negelo dafidilo dolö nefolalebe amolida, Hebeni Beaha Maadela Sigi Neebea ami nogila digamolöda, häuai galeamelë. ");
INSERT INTO etr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na dilima bu elö sähago. Sugua gamele nusi galabagi nogila digamolö häuai amo gadoi made. Gaso, nelegei yafie negelo dafidilo dolö nefolalebe amoli, Godea Beaha Maadela Sigi Neebea ami nogila digamolöda, häuai baagila asi dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Amala säi amo nabalahilä, bëgëla aulo amoli edefademalä fudugilahilä sähalea, Amai damula aulo nowëa neala gaula namolödula säi. ");
INSERT INTO etr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuea ilima siila neamu sähalea, Udia dolöea hamomolöi made amoda. Godea sulubadela hamomolöimu neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Amala säsebegi, Fidaea ema naba obëgësalea, Amai, nilïada, nilïle nelegei sulubadela fisisa maadelahilä, di bëgëla misi amo, nilïa edo nimolödula nabi. ");
INSERT INTO etr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuea ilima sähalea, Na dilima dofä sähago. Namolö gähegi aligisolo amo gala, Dolöïe Malö amo ïe beaha aligilo filo hedabi hïdo elöidaia fiseda, ne bëgëla mulo dilige sigi aligilo filo giwilasidaia ami salea, Isilale sosogo giwilasi amoli sigi aligimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Amase, sulubadelaea nïe ëi helësëla, ilile mosöge, edooge, elefige, eedoge, emege, malöge, segege, fisila. Dïgïla misi amoliada, dïgïla misi amo gadola hädali afädë nealahilä, namolöi namolöge nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yafie dafidila nefolalebe amolida neala hobeahalea, hobeala nefolalebe amolida neala dafidimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesuea ado aso, sähamu nea sähalea, Hebeni Beaha Maadela Sigi Neebea ami gowe gadoi dialea. Segeyo afädëgi yosefalï sagai eedo afädëa, dolö odoaea gägä negelo gelebi sagaia ami ïe hamoi hamolasimäia ea bidi ïmolöïe hogola asi. ");
INSERT INTO etr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ea dolö odoa beagolelahilä, ili ado afädë negela sähalea, Segeyo walioïe bidi muni giwi siliba afädë afädëla sogodeläla sälahilä, ïe gelebi sagaia ami afiamaloi. ");
INSERT INTO etr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Amaimo, eso neëla udigise amo gaalu, magaia gaamugi awäla beahaleamelebe, dolö odoa memalä nefolalebe melï. ");
INSERT INTO etr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bealahilä, ea ilima sähalea, Na muni bidi mogola ïdulä, dilige gelebi sagaia ami afiamaloi. ");
INSERT INTO etr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Amo nabala ilige hamoi hamomolö afiai. Amase, eso mogogige, odoa nebegi ea amo gadola sälahilä, eso bëgise gaaluge, ea bu elö amo gadola wäla hamoi. ");
INSERT INTO etr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hä, deadise amo gaalu bu awähamelebege, dolö odoa, aso, memalämu nefolalebe melï. Bealahilä ea ilima nabahalea, Segeyo sedade amoda memalä aligila waeasei goda mi edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Amala nabasebegi, ilia säla obëgësalea, Afädëa nilïma hamoi hamomolö made säsebegi nefolaleawela säi. Amala säla obëgësebegi, ea ilima sähalea, Dilige gelebi sagaia ami afiamalola säi. ");
INSERT INTO etr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hä, deadi së gämolö amo gaalu, sagai eedo amea ïe hamoi sigi aligilo amoma sähalea, Hamoi hamosa nefolalo amoli mofiamalolahilä, deadi maala hamoi amolidale bidi ïïa nedala, yose maala hamoi amoli ïala wagamalola säi. ");
INSERT INTO etr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dolö odoa deadifalï misi amoli maala, ilia muni giwi siliba afädë afädëla nii. ");
INSERT INTO etr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Amala neasebegi, dafidi awäla hamolo amoli maala ilia helësësaleada, muni baagila awäla nimolö gabula helësëi. Gaso, iliage muni giwi siliba afädë afädëla nii. ");
INSERT INTO etr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Muni amo neala gaula awälahilä, ilia sagai eedo amoma habobala ");
INSERT INTO etr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","sähalea, Dolö hobeafalï deadi misi amolia aoa afädëmu hamoi hamolo amolige, dia nilïbalä dafidi misi gadoi hamola, muni afädëdila sogosio. Nilïada yosefalï awäla hamosa nea, eso neëa hëgïsebe amoma bibisa hamosa nelola säha dilo. ");
INSERT INTO etr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amala säha dibegi, sagai eedo amea iligi dolö afädëma sähalea, Nedoo, na dima asiala made hamoi. Dia muni giwi siliba afädë afädëla nimolöïe nebalä ado afädë negei madele. ");
INSERT INTO etr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Di hä, ïgo gaula mosalo. Dolö gowe hobeafalï misi amoma, digali ï amo gadola ïmolö hamesamelë. ");
INSERT INTO etr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nihïle munia nihï hamese amo gadola hamomolö dialea madele. na mala hedabi hamosa neebe wegi, Oböla, dia mudiahalela säi. ");
INSERT INTO etr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Amala sälahilä, Yesuea säla wagala sähalea, Hobeala nefolalebe amolida neala dafidisalea, dafidila nefolalebe amolida neala hobeamolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu e Yalusaleme moholöïe afiahalea, ea ïe bëgëla aulo giwilasi amolima hilidomu aliga gala nea sähalea, ");
INSERT INTO etr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nabahale. Nilï Yalusaleme afiahamelë. Ami neëgi, Dolöïe Malö amo gobela ïlo busa nefolalebe amolimage, mala dawadigi nefolalebe amolimage gaula ïmolömelë. Amala gaula ïasegi, ilia e baagomäia nufualola sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Amalahilä, fii odoaea e gadiabola, ëfë damuia fëgälahilä, e baagomäia i fügäigi baala negemäiaïe, ilia iligali gaula ïmolömelë. Amala hamoseda, segeyo äudä nelolahilä, osodagi e nowemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hobea Sebediïe udia amola ïe efegele äudä amolali Yesu neebea maalahilä, udia amea emo gumu sasagala fia idogola salea, ema afädë ëdëgëi. ");
INSERT INTO etr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Amalebe, Yesuea ema nabahalea, Dia edo hamesala nabi. Udia amea säla obëgësalea, Dïe Beaha Maadela Sigi Neebea amida, nïe malö äudä, elöda dïe naabo dafädimadi, elöda dïe naabo fefeädimadila samiäiala sämola säi. ");
INSERT INTO etr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Amala säsebegi, Yesuea sähalea, Dilia nabasegoda, dawa made nea, fuduia nabasebe. Na ödä iigi usi molö neebewe gadola, alia molöi gabulela nabi. Amala nabasebegi, elea ema säla obëgësalea, Alïada molöi neawela säi. ");
INSERT INTO etr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Molöi neawela säsebegi, ea elema sähalea, Aliada nïe ödä iigi usi dibe amo dofä molöi nea. Gaso, ali elöda nïe naabo dafädimadi, elöda nïe naabo fefeädimadila samiäiala sämolöda, nïe made. Naadoea gowe samiäiala daiai amea sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Amola säi amo nabala ïe bëgëla aulo nabülasi amolia elema habobai. ");
INSERT INTO etr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Amasebegi, Yesuea ili sulubadela mofiamolahilä sähalea, Fii odoa beaha aligilo neebe amoliada, ïe udia dolö beaha aligilo neada, gelola beaha aligilo nea. amase, ilile ëi sälo neebe amoliada, udia dolö bobasëla made, ilile ado bëgëmäia gelola sigi aligilo amoda dilia dawa. ");
INSERT INTO etr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ilia hamolo amo gadola, dilia made hamomolö. Dili neebe gogi afädëa ëi sälo namolöila helësëseda, ea dilile hamoi memalä ugila negela hamolasilo namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Amase, afädëa dafidilo namolöla helësëseda, eda dilile memalä galabaia hamoi gadoi hamolasilo namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amo gadola, udia dolöea Dolöïe Malö amoïe hamoi hamolasimäia misi made . Ea ilile hamoi hamolasila ïe namolö amo udia dolö yafiegali fisiga gala, ili sigi obëgëmolö misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesula ïe bëgëla aulolali Yaligola afiasebegi, udia dolö yafie ili bëgëla afiai. ");
INSERT INTO etr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Afiaha dialea beahamelebe, dolö si golai äudä idi agesua ami sebe melï. Elea Yesu baagila awäsebela säi amo nabalahilä, uuala sähalea, Dafidilo-o, Debidiïe malö-o, alï bobasëmola säla uuaha sulo. ");
INSERT INTO etr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Elea amala uuasebegi, udia dolö gegedoi amolia elema nemola sähalea, Adomabu. Gameläla säla nemoi. Nemosebegi gaso, elea gelola uuahalea, Dafidilo-o, Debidiïe malö-o, alï bobasëmola uuaha sulo. ");
INSERT INTO etr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Amala uuasebegi, Yesu e maala beaha nea, ele welahilä sähalea, Na alima edo hamomäia helësësebela nabi. ");
INSERT INTO etr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Amala nabasebegi, elea ema sähalea, Dafidilo-o, dia alïle si fisigälasimäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Amala säsebegi, Yesuea ele bobasëla, elele sihidoa diigi. Diigi amole fodolofalï si fisigäla fädäla bealahilä, ele Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ili Yalusaleme besela galamolö ga madela, Olibebi neebea ami sege Bedefagi besela galamolöïe yauabia nea, Yesuea bëgëla aulo äudä dafidi mosalolahilä ");
INSERT INTO etr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","elema sähalea, Gaamugi ami awäla besela galala beahamelële, sugua dögi aseme, ïe malö daiadigile begela negei neë aabela bimolömelë. Beaseda, fisigälahilä ne neebeawi sigi misialo. ");
INSERT INTO etr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Afädëa alima ado afädë säseda, gomalä sämalo. Dafidiloea welebalä hamomolö galeamelëla sämalo. Amala säseda, ea fodolo sähalea, Hä sigi mosöla sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dafidi Dafidilo Geloia bea säloma aligila bea säla negei amo gadola gausiala digamäia amala hamoi. Säla negei amoda gowe. ");
INSERT INTO etr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Saionoïe idiwima sähalea, Bimo. Dïe beaha aligilo gini amoda di neebea maasebe. Hï e nagadaiala aligilo nea, sugua dögidaia fila maasebe. Sugua dögi üdïlidaia fila maasebegola sämalola säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Amala säsebegi, ïe bëgëla aulo amole awäla, Yesuea hamomalola säi amo gadola hamoi. ");
INSERT INTO etr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Elea sugua dögi aseme üdïlile sigi maalahilä, amoledaia elele fagulo daia salugalo amo giila fösisebegi, Yesu e amoledaia fila fedai. ");
INSERT INTO etr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Amala fedala fise amo gaalu, udia dolö yafie gegedoi amolia ilile daia salugalo fagulo neala idiafa föla digi, odoaea fasela bäu gadoi dagabola gaula mafula föla digisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Udia dolö gegedoi amoli Yesu awäse amo gadola dafidila awäha nelo amoliage, hobeala maaha nelo amoliage, uuala säsäla awähalea, Agua. Nesege. Godeïe ëi gauia adadi. Debidiïe malöma sähago. Afädë Dafidilo Geloiïe ëigila maahago Godea e neala obeägïlasimäia. Hosana. E ilibia neebe amoïe ëi gauia adadila säsäla afiai. ");
INSERT INTO etr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu e Yalusaleme awäla besela galasebegi, udia dolö ami nefolalo amoli sulubadelaea fudugila bedälahilä sähalea, Dolö goweda nowëdula säha dilo. ");
INSERT INTO etr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Amala säha dibegi, udia dolö gegedoi amolia sähalea, Goda bea sälo Yesu. Eda Galili segeïe gaamu Nasalese dolömelëla säha dilo. ");
INSERT INTO etr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu e awäla Godeïe mosö yala isogi nogila digalahilä beahamelebe, bidi neadigi, bidi nimolöïe negela digisa dibe amoli sulubadela nesila digisa nelo. Muni bedefalo auli amolige, amase, haea maliabu gadoi bidi neaha aligilo amolile filo auli amolige, neala besula besigadasi. ");
INSERT INTO etr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ea ilima sähalea, Ado säla dëdëla negei dibe amea sähaleada, Nïe mosö amoda Godema adolo mosö dialeala sämolömelëla säla dëdëla negei dialea gaso, dilia fa nelo musügä aligilo igi äbä gadoi hamosebela säi. ");
INSERT INTO etr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ea amala sälahilä Godeïe mosöa ami nebegi, si golaige emo nafadeige mofiasebegi, ea ili wahisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gobela ïlo busa nefolalo amoliage, mala dawadigi nefolalo amoliage, Yesuea hedabi hamose amo bealahiläge, amase, malësä nefolalo amolia Godeïe mosöamadila dägö digala sähalea, Agua. Nesege. Godeïe ëi gauia adadi. Debidiïe malöma sähagola säsebe amo nabalahiläge, ilia habobai. ");
INSERT INTO etr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Habobalahilä, ilia Yesuma nabahalea, Ilia säsego dia nabasebelela nabi. Amala nabasebegi, Yesuea ilima säla obëgësalea, Ä. Ado afädë säla dëdëla negei dibe amoda gomalä. Malësä nelësa amolige, malö dodo naha sefolalebe amolige, ilile nafiala dia dïe ëi gauia adamäia hedabolafalï oleleimelëla säla dëdëla negei dialea. Dilia ado amala säla negei dibe amo made melï nealela nabi. ");
INSERT INTO etr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Amala nabalahilä, Yesuea ili dïgïla gaamugi amila doadigila awäla Bedani midilö asi. ");
INSERT INTO etr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Diala yosefalï nowela, gaamugi obëgësalea e sïdëa baagoi. ");
INSERT INTO etr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Awähalea beahaleamelebe, idi agesua ami äfäeo afädë neebe beala, ea i mia ami bea awähamelebe, gägä afädë maade, bäu badumu neebe melï. Gägä maade beala, ea äfäeo amoma sähalea, Dia gägä hobeala dofä made negemäiamelëla säi. Amala säi amole, fodolofalï bausoi. ");
INSERT INTO etr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bausosebegi, ïe bëgëla aulo amolia beala fudugilahilä nabahalea, Äfäeo amo fodolofalï bausoi amoda abeahäladula nabi. ");
INSERT INTO etr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Amala nabasebegi, Yesuea ilima säla obëgësalea, Na dilima dofä sähago. Asigi äudä negela made, asigi afädë negela aligiseda, äfäeoma na walio hamoi amo gadola, diliage hamomolömelë. Amoda afädë amomu made, dilia segebi neebe amoma dihï dagabola awäla, ödä duhulu daia digamola säseda, dilia säse amo gadola hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dilia Godema adosalea, asigi afädë negela, nelebo afädë ïmola ëdëgëseda, dilia ëdëgëse amo gadoi wäla nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu e Godeïe mosöa nogila digalahilä, ado mala säla olelesa nebegi, gobela ïlo busa nefolalo amoliage, udia dolöïe dafidilo asigi gäwi nefolalo amoliage, e neebea maalahilä ema nabahalea, Dia nelebo hamosebego, nowëa hamomalai hamosa. Nilïa nabedelä, dia säla ïmo. Go hamomäia, geloi go nowëa ïasiola nabi. ");
INSERT INTO etr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Amala nabasebegi, Yesuea ilima säla obëgësalea, Nage dilima ado afädë nabahago. Dilia säla obëgëseda, nelebo na hamosebeweda, gowea hamomalai hamosa neamelëla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yonea ödägi gesa nelo amoda abidila misi. Selesaia mosöala misile ma dolömadila misilela nabi. Amala nabasebegi, hilido didiähalea, Nilïa selesaia mosöalala säseda, ea nilïma nabahalea, Amai galëda, ema asigi afädë made negei goda edoïela nabulö gabu. ");
INSERT INTO etr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amase, nilïa dolömadilala sämolö gaso, nilï udia dolöbalä bedäsebe. Mida, ili sulubadelaea helësësalea, Yone eda bea sälo nelola helësësa nefolaleala didiäi. ");
INSERT INTO etr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Amala didiälahilä, ilia Yesuma säla obëgësalea, Nilïa dawa mademelëla säla obëgëi. Dawa mademelëla säla obëgësebegi, ea ilima sähalea, Amai galëda, nage nelebo na hamosebewe gowea hamomalai hamosa neala dilima made säla ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuea sähalea, Dilia edo helësësebe. Dolö afädë nelo amoïe malö äudä sulo. Dolö amea ïe malö abulümi amoma sähalea, Dia walio awäla gelebi sagaia hamoi hamosa namialola säi. ");
INSERT INTO etr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Amala säsebegi, malö amea ïe eedoma haboila sälahilä gaso, hobeala asigia degela oböla hamola asi. ");
INSERT INTO etr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Amasebegi, dolö amea ïe malö elö neebea ami awälahilä, elö amoma säi amo gadola wäla säi. Sälebe malö elö amea säla obëgësalea, Naado, hamola awähadiola sälahilä gaso, made awäla fisi. ");
INSERT INTO etr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Amai, eedo amea hamomaloi amo gadola, malö abodoea nabala hamoila nabi. Amala nabasebegi, ilia säla obëgësalea, Abulümiala säi. Amala säla obëgësebegi, Yesuea ilima säla obëgësalea, Na dilima dofä sähago. Dagisi muni nelo nefolalebe amoliage, idigi nawela susugu hamolo udia nefolalebe amoliage, dilida dïgïla, ilidale dafidila Godea Beaha Maadela Sigi Neebea ami afiahagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Amoïe mida, Yone e dili neebea maalahilä, ea idi mogoifalï amo olesebegi gaso, dilia dofä gabula helësëla made nelomelë. Dagisi muni nelo amoliage, idigi nawela susugu hamolo udia amoliage, ea ado mala säsebe amo nabalahilä, ea säse amo dofä gabula helësëimelë. Ilia amala helësësebe amo, dilia bealahilä gaso, dilia asigi besula, dofä gabula helësëla made nelomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuea sähalea, Ado besula elö säsebewe nabualo. Dolö sege eedo afädëa sagai sagala, yala amalela yalahilä yala amo dimelë. Yala isogi ami gelebi gägä emesala fësëla salimolöïe naga dögöi. Dögöla negesilahilä, sagai idihë nea beaha aligilo mosö holöbö ilibia ola fedalahilä negesi. Amala hamolahilä, ea dolö odoama sähalea, Sagai oodola beaha namialola säsilahilä, hï e sege wagadi made asimelë. ");
INSERT INTO etr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gelebi gägä hä, faimolö segeyo ga madesebegi, sagai eedo amea ïe hamoi hamolasilo amoli mosalolahilä, sagai oodola beaha aligilo amolima ïe gägä odoa faila ïmola sämolö mosaloi. ");
INSERT INTO etr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amala sämolö awäsebegi, sagai oodola beaha aligilo amolia hamoi hamolasilo amoli gaulahilä, elö amo nufudala ïalalei, elö amo nufudala baagoi, amase, elö amo igia nufi. ");
INSERT INTO etr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amala hamosebegi, sagai eedo amea ïe hamoi hamolasilo odoa, dafidi fisiga gai amoli gadoi made, hobeala yafie fisiga gasebegi afiai. Gaso, sagai oodola beaha aligilo amolia, dafidi hamoi amo gadola wäla hamoi. ");
INSERT INTO etr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hobeafalï, sagai eedo amea hïle malö amo fisiga gai. Eedo amea helësëlahilä sähalea, Iliada nïe malö we hawala nea, mogola hamomolöla helësësala säi. ");
INSERT INTO etr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hïle malöfalï maase amo bealahilä, sagai oodola beaha aligilo amolia hilido didiähalea, Goda sagai eedo amoïe malöfalï gabugo. Eedoïe nalä negei nilïa nimolöïe, e nufidedila säla didiäi. ");
INSERT INTO etr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Amala sälahilä, ilia e gaula sagai amoïe yala baagido sadia gala nufudala baagoimelë. ");
INSERT INTO etr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amoda amala hamoi amo, sagai eedo amea maalahilä, sagai oodola beaha aligilo amolima, edo hamomolö gabula nabi. ");
INSERT INTO etr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Amala nabasebegi, ilia ema säla obëgësalea, Ea dolö nafade amoli neala nafadela nufudadigimolömelë. Amalahilä, gägä faimolö fu besela galasolo amo gala, faila mogelo dolö amolia oodola beaha namiäia, sagai amo ilima ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Amala säsebegi, Yesuea ilima sähalea, Dilia ado säla dëdëla negei dibe amoda made melï neale. Mosö olelo amolia igi galone hamomolöi made gabula memelela fisi amoda, galone geloi dafidilo gelola besela galai neamelë. Dafidilo Geloia hamogilebeda, nilïa siia bealahilä fudugisa neala säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Amoïe na dilima sähago. Godea Beaha Maadela Sigi Neebe amo dili neebea guila neala gaula awälahilä, amoïe gägä negelo udia dolö amolima ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Igi amodaia afädë digase amoda, igi amea dusudasila fisimolömelë. Amase, igi gowea, udia dolö eegeseda, hä eegela fisimolöi fisimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Amala säsebegi, gobela ïlo busa nefolalo amoliage, Felesi dolö nefolalo amoliage, ea ado besula säsebe amo nabalahilä, amoda ilile säsebela helësëi. ");
INSERT INTO etr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ilia Yesu gaudeläla idi hogoi gaso, udia dolö nefolalebe amolia Yesuda bea sälo neala säha dibe amogi bedäi. ");
INSERT INTO etr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuea ado besula ilima bu elö sähalea, ");
INSERT INTO etr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hebeni Beaha Maadela Sigi Neebea amida gowe gadoi dialea. Beaha aligilo gini afädëa ïe malö udia neasebegi, molö giala daiala negei. ");
INSERT INTO etr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Daiala negesa maadelahilä, ea ïe hamoi hamolasilo amolima sähalea, Udia dolö giwi säi amoli walio misiäia bea mosaloi. Bea asi gaso, giwi säi amoli moholö haboi. ");
INSERT INTO etr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Habosebegi, ea hamoi hamolasilo odoama mosalolahilä sähalea, Na giwi säi amolima gomalä sämalo. Molö molö daiala negei dialea. Nïe sugua gao gawalige, üdïli säfei odoa hedabige giala dagabodasila negela, nelebo sulubadela daiala negei dialea. Udia neaseweïe molö molö misiäia säla ïmolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Säla ïmolö awäsebegi, giwi säi amolia nabalahilä gaso, auaula afiai. Dolö afädëda, hïle sagaia asi. Amase, elöda hïle sidua mosöa asi. ");
INSERT INTO etr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Odoa made asi amoliada, ïe hamoi hamolasilo amoli gaulahilä, nafadela nufudala baagoi. ");
INSERT INTO etr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Amala hamosebegi, beaha aligilo gini amea mihalälahilä, ïe ami dolö amoli mosalolahilä, ilia nufidelo dolö amoli nufudaha maadelahilä, ilile mosö gobesa maadei. ");
INSERT INTO etr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Amalahilä, ea ïe hamoi hamolasilo amolima sähalea, Molö giala daiala negei dialea gaso, na molö na misialola giwi säi amoli moholö amo dofea made gabu. ");
INSERT INTO etr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Idi osogoloa ami awälahilä, udia dolö gausiasebe amolima, udia neaseweïe molö molö misiäiala sämolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Amala säsebe amo nabala, hamoi hamolasilo amolia idigi awäla, udia dolö gausiai amoli sulubadela neala gegedoi. udia dolö nafadege hedabige molö molö maala, mosö amo nobai. ");
INSERT INTO etr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Udia dolö amoli maala sebegi, beaha aligilo gini amea mofiai sefolalebe amoli bimolöïe digalahilä beahamelebe, dolö afädë udia neahalea fagulo gälo amo made gäi misi sebe melï. ");
INSERT INTO etr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amo bealahilä ea ema nabahalea, Nedoo, udia neahalea fagulo gälo amo made gäi goda, abilia misi saleala nabi. Amala nabasebegi, dolö amea ado säla obëgëla made sulo. ");
INSERT INTO etr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ado made säla obëgësebegi, beaha aligilo gini amea ïe hamoi hamolasilo amolima sähalea, Ïe naabo emole helegela nafodolahilä, gasimi sagai dibea ami sadia idogomo. Amida, ili dïisalea bese ali nalëgësa namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nabuö! Yafie wei gaso, afädë afädëla memelei amomu nogila digai gabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Felesi dolö nefolalo amoli afialahilä ado afädë negemolöïe didiähalea, Yesuea ado säse amohï e gaumolöïe ado abilia säla oodomolödula didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Amala didiälahilä, ilia ilile bëgëla aulo nefolalo amolige, Heledoïe sosogo nefolalo amolige, Yesu neebea mosaloi. Ili awäla ema sähalea, Säla Olelelo-o, nilïada dia ado dofämu sälola helësësamelë. Amase, dia Godeïe mala säla olelese goge, mogolafalï säla olelesa. Dia dolö odoabalä made bedälo ameada, dia mogolamu olelelola helësësamelë. ");
INSERT INTO etr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Amalo gabugi, dia helësësebe amo nilïma säla ïmäia. Beaha aligilo Gini Sisa neebe amomada, dagisi muni ïmolö dialeale ma maadelela nabi. ");
INSERT INTO etr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amala nabasebegi, Yesuea ilile asigi nafade dibe amo helësëlahilä, ea ilima sähalea, Asigi fea negelola dilia, edoïe ne fedogola beaha. ");
INSERT INTO etr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Muni dagisi negelo giwi gogi nema olemola säi. Amala säsebegi, ilia muni giwi afädë gaula maala ema ï. ");
INSERT INTO etr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ïasebegi, ea ilima nabahalea, Muni giwi egowegi dolö busa dibe gowege, ëi dëdëi dibe gowege, nowëïe gabula nabi. ");
INSERT INTO etr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Amalebe ilia sähalea, Sisaïela säi. Amala säsebegi, Yesuea ilima sähalea, Nelebo Sisaïeda Sisa hïma ïmalo. Godeïeda Gode hïma ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amala säi amo nabala ili fudugilahilä, e dïgïla bahïla afiai. ");
INSERT INTO etr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Segeyo amo galamu, Sadiusi dolö nefolalo amolia Yesuma afädë nabulöïe e neebea ami misi. Sadiusi iliada udia dolö baagoi amoli made nowemolöla sälo. ");
INSERT INTO etr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ilia ema nabahalea, Säla Olelelo-o, Mosesea sähaleada, Dolö baagoi amea malö made sogobala baagoi galëda, baagoi amoïe edooea udia didalo amo bedefala nealahilä, edoo baagoi amoïe malö sogobamolö dialeala säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amaimo, nilïgi edoolali gifalädalïa nefolalo amoligi, abulümi amea udia nii amo malö made sogobala baagosebegi, oböla ëoea amea udia amo nii. ");
INSERT INTO etr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Neala nea, amo gadola wäla hamosebegi, edoo agedu amoge, osoda amoge baagolebe, sosogo gifalädalïa amoli sulubadela baagola mimisa maadei. ");
INSERT INTO etr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Amala baagosa maadeibua, udia amo hobealafalï baagola wagai. ");
INSERT INTO etr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Amo gadola hamoi amo, ili sulubadelaea udia afädë amomu neala salea baagosa maadei. Amai, hobea baagoi nowela galasolo amo gala, udia amoda, dolö gifalädalïa amoligi afädë abodoweïe udia samolödula nabi. ");
INSERT INTO etr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Amala nabasebegi, Yesuea ilima säla obëgësalea, Ado säla dëdëla negei dibe amoge, Godeïe geloi dibe amoge, made dawadigi neebe goeada, dilia asiala helësëla säsebego. ");
INSERT INTO etr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Amoïeda, udia dolö baagoi amoli nowela galaseda, udiage made neala, dolöge made fila, Selesaia mosöa selesaia fii nefolalebe amoli gadoi namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amaimo, baagoi amoli nowemolö amoïe, Godea dilima ado säi dëdëi dibe amoda, aso, nidela made neale. ");
INSERT INTO etr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ea sähalea, Neda Abalahama, Aisaga, Yeigabala ilile Gode neawela säi amo dëdëla negei dialea. Gode eda baagoi amolile Gode made, eda made baagoi nefolalebe amolile Gode neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Udia dolö ami gegedoi nefolalo amolia ea ado säi amo nabala, asigigi fudugisa nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuea ado säi amea, Sadiusi ilia säla obëgëla made nefolaleamelëla säi amo nabala, Felesi dolö nefolalo amoli gegedolahilä, ");
INSERT INTO etr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ili sosogo amogi dolö afädë mala säla negei amo olelelo amea, Yesuea ado asiala säsebelela bimolöïe, ea ado afädë fedogola nabi. ");
INSERT INTO etr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ea nabahalea, Säla Olelelo-o, Ado säla negei dibe amogi, nilïa hamomalai edefade dibe amoda abododula nabi. ");
INSERT INTO etr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Amala nabasebegi, Yesuea ema säla obëgësalea, Dafidilo Geloi dïe Gode neebe amo dïe bobaeage, gesamiage, asigiage, boba hamomalo. ");
INSERT INTO etr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nilïa hamomalai dibe amoligi, edefade dafidilo gelolada amomelë. ");
INSERT INTO etr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Amase, agedu gowege amo gadoimelë. Dihïdi boba hamolo amo gadola, odoa dibalä nefolalebe amoli boba hamomalo. ");
INSERT INTO etr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesea ado säla negei dibe amoge, bea sälo nefolalo amolia bea säla negei dibe amoge, amoli sulubadela ado äudä amolegimu begedidigila gosai dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Felesi dolö amoli gegedoi nefolalebegi, Yesuea ilima nabahalea, ");
INSERT INTO etr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Afädë Memelei amoïeda, dilia abilia helësësa. Eda nowëïe malö neala nabi. Amala nabasebegi, ilia säla obëgësalea, Debidiïe malöla säi. ");
INSERT INTO etr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Amala säla obëgësebegi, ea ilima nabahalea, Amai galëda, Godeïe Gesamia Debidima helësëlasisebegi, Debidia oböla e Dafidilo Geloila säi amoda abiliadu. Debidiada gomalä säi. ");
INSERT INTO etr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dafidilo Geloia nïe Dafidilo Geloima sähalea, Na dïe ado nii nefolalebe amoli di hawala namiäia, dida nïe naabo dafädimadi awäla salea, beaha samialola säi. ");
INSERT INTO etr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Debidia hï ema e Dafidilo Geloila säi galëda, eda Debidiïe malöda abeahäladula nabi. ");
INSERT INTO etr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Amala nabasebegi, afädëa ema ado säla obëgëmolöi made melï. Amasebegi, segeyo amila nofela, ili bedähalea, ema ado afädë nabala made nelo. ");
INSERT INTO etr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hobeala, Yesuea udia dolö gegedoi amolimage, ïe bëgëla aulo amolimage ");
INSERT INTO etr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","sähalea, Mala dawadigi dolö amolige, Felesi dolö amolige Moseseïe filodaia saleamelë. ");
INSERT INTO etr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Amaimo, ilia dilima ado säse amo sulubadela, dilia nabala bëgëla hamomolöi galea. Gaso, ilia mala hamose amo gadolada, dilia made hamomalo. Mida, hili made hamosalea, adoeamu sälo gabugi. ");
INSERT INTO etr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iliada nelebo yöi gaumolöi made amo neegilahilä, häuala gaulo amo, dolöïe gïdädaia negesilo amogida, hilile naaboea didigila yöi amoli gaumolö made helësëlomelë. ");
INSERT INTO etr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ilia nelebo sulubadela hamose amoda, dolöea bimäiala hamolo. Iliada nelebo salelo amogi ado damui dëdëla salalahilä, odagia baala, naabogige gälo. Ilia salelo sugua gafodo amoda bobogalamu gälo nefolalo. Ilia fagulo sedade gäi amoïe bidigi ëfë gadoi begedidigilo amoda, ilia ëfë sedadeamu begedidigilo nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iliada molö nasebea amige, gedolo mosöa amige, dafidilo filo dibea amimu fimolö hamelo. ");
INSERT INTO etr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iliada magaia gaamugi, udia dolöea ilima, di go gabiola sämäiage, säla olelelola sämäiage hamelo. ");
INSERT INTO etr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amalo gaso, dolöea dilima säla olelelola sämolöi mademelë. Mida, afädë emu dilile säla olelelo nea. Dili sulubadela didoo didoolali neamelë. ");
INSERT INTO etr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Amase, nagadaiawi neada, dolö afädëma dilile diadola sämabio. Mida, afädë emu dilile diado nea. Amoda selesaia mosöa neamelë. ");
INSERT INTO etr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Odoaea dilima dafidilo busala sämolöi mademelë. Mida, dilile Dafidilo afädë nea. Amoda Afädë Memelei neebe amo amomelë. ");
INSERT INTO etr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dilile busa edefade neebe amolida, dilile hamoi ugila negela hamolasilo namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Afädëa hï e ilibialo amoda, neala nagadaialasisalea, afädëa hï e nagadaialo amoda, ilibialasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Yesuea ado aso, sähamu neamu sähalea, Asigi fea negelo, mala dawadigi dolöla, Felesi dolöla dili, asigii gabu. Mida, dilia Hebeni Beaha Maadela Sigi Neebea ami udia dolöïe odagia gala didigilo. Dihili dilida made nogila digahalea, dilia udia dolö nogila digadelä hamose amolile idi gala didigilomelë. ");
INSERT INTO etr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Asigi fea negelo, mala dawadigi dolöla, Felesi dolöla dili, asigii gabu. Dolö afädëamu dili bëgëla aulo namiäiaïe, dilida duhulu dibeamadige, sege föi dibeamadige nawesa aligilo. Amaimo, e hä bëgëla aulo aligiseda, e heli segeïe malö dili gadoi hamolasilo. Gasoda, ïe mala nafade amea dili baagila aulomelë. ");
INSERT INTO etr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Dihili dili si golai nea, dolö odoa nefolalebe amoli idi olelo nebego. Dili asigii gabu. Mida, dilia sähalea, Afädëa gobela ïlo mosöla säla, migalïa diigila ado gelola säla negeseda, amoda memalä melëlo. Gaso, afädëa gobela ïlo mosöa golola säla, migalïa diigila ado gelola säla negeseda, amoda ea säi amo gadola hamomolö dialeala sälo. ");
INSERT INTO etr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dilida asigi maade, si golai gabu. Godeïe siigi hedabifalïda abodo. Golo amo hedabi gabule, ma gobela ïlo mosö amo hedabi gabule. Diliada dawa, goloda gobela ïlo mosöa dibe amoïe, Godeïe nafolala hamolo. ");
INSERT INTO etr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Amase, dilia elö sähalea, Afädëa gobela ïlo aulila säla, migalïa diigila ado gelola säla negeseda, amoge memalä melëlo. Gaso, afädëa auli amodaia nelebo odala ï amola säla, migalïa diigila ado gelola säla negeseda, amoda ea säi amo gadola hamomolö dialeala sälo. ");
INSERT INTO etr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Dilida si golai gabu. Godeïe siigi hedabifalïda abodo. Nelebo gobela ïlo amo hedabile ma, auli amo hedabile. Diliada dawa, nelebo gobela ïlo amo aulidaia dibe amoïe, Godeïe nafolala hamolo. ");
INSERT INTO etr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Amai gabugi, afädëa aulila säla, migalïa diigila ado gelola säla negeseda, eada auli amoge, nelebo sulubadela aulidaia dibe amoge säla, migalïa diigila ado gelola säla negelo. ");
INSERT INTO etr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Amase, afädëa gobela ïlo mosöla säla, migalïa diigila ado gelola säla negeseda, eada mosö amoge, mosö amogi aligilo amoge säla, migalïa diigila ado gelola säla negelo. ");
INSERT INTO etr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Afädëa selesaia mosöla säla, migalïa diigila ado gelola säla negeseda, eada Godeïe beaha aligilo filo amoge, filo amodaia sebe amoge säla, migalïa diigila ado gelola säla negelo. ");
INSERT INTO etr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Asigi fea negelo, mala dawadigi dolöla, Felesi dolöla dili, asigii gabu. Mida, nelebo nelësa sagaia neebe amo sulubadela amogi, nabülasi mogelahilä, nabü afädë neala Godegali ïlo. Gaso, Ado säla negei dibe amogi ado edefadeda, dilia buludola fisi gabu. Buludola fisi amolida gowe ili. Mogola hamologe, bobasëla ugila negeloge, amase, asigi afädë negeloge buludola fisigoea. Nabü afädë Godegali ïlo dafidi säi amo made fisila, dilia ado edefade amoli hahamosa nelo galebeda, dofealabio. ");
INSERT INTO etr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dihili dili si golai nea, dolö odoa nefolalebe amoli idi olelo nebego. Diliada molö gobei nahalea, eeme nelësa seëgi, amo neadigilo gaso, molö gobeigi sugua gamele seëgi, amola wäla sübä dëgïlomelë. ");
INSERT INTO etr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Asigi fea negelo, mala dawadigi dolöla, Felesi dolöla dili, asigii gabu. Diliada gaaboge faloge daia baagido gomu hëlo gabu. Gaso, isogida dilia dihilile asigi made sigi aligila, molö fa nelo amea nobai gabumelë. ");
INSERT INTO etr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Felesi si golai di, gaabo isogi dafidi nigime hëmalo. Amala hamoseda, daia baagido goge gëgelë baai made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Asigi fea negelo, mala dawadigi dolöla, Felesi dolöla dili, asigii gabu. Dilida baagoi bauia beni faleia hëi amo gadoi gabu. Baui daia amoda hedabifalï beaha gaso, isogi dolö baagoi amolile giwi amoge, nelebo sulubadela nigime baala nobai dialea. ");
INSERT INTO etr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Amo gadola wäla, dilile domalo beala udia dolöea asigisaleada, dilida dolö mogoi gabula asigilo. Gaso, dilile isogida asigi fea negeloge, mala nafademu hamologe nobai gabugo. ");
INSERT INTO etr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Asigi fea negelo, mala dawadigi dolöla, Felesi dolöla dili, asigii gabu. Diliada bea sälo amoli baulo mosö amo olalahilä, dolö mala mogoi hamolo amoli baulo mosö amoge momadolo gabio. ");
INSERT INTO etr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dilia sähalea, Nilïda nilïle mäulali nefolalo amogi nelo galebeda, nilïa ilile heale made digala, bea sälo ili ugila negelabiola sälo. ");
INSERT INTO etr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dilia amala sälo amea olesalea, dilida bea sälo nufidelo amolile malö gabula olelomelë. ");
INSERT INTO etr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ameada dilige dilile diadola ilia mala hamolo amo gadola, hamola wagamalo. ");
INSERT INTO etr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dilida baagolo nubage, nubaïe malöge nebego. Godea dilibalä gudisegi, dili heli segea moholö amoda abeahäla sisigala moholö gabu. ");
INSERT INTO etr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amai gabugi, nabuö. Na bea säloge, dolö asigi falagaseige, amase, mala dawadigi dolöge dilima fisiga gamolömelë. Odoada dilia nufudala baagola, odoada i fügäigi baala negemolömelë. Amase, odoada dilile gedolo mosöa ami fëgälahilä, ili nesila gaamu afädëgila doadigila awäla, gaamu elögi nesila fisiga gamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Amoïe mida, dolö mogoi nagadaiawi nefolalo odoaea nufi amoli sulubadelaïe heale digai amoda dilimamu diamolömelë. Mi gäwila dolö mogoi Aibeledale heale digaia amila maala, Belegaeaïe malö Segelaeage, dolö dilia gobela ïlo mosöle gobela ïlo aulile adeba ami nufi amoïe heale digaia ami, ili sulubadelaïe heale digai amoda dilimamu diamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na dilima dofä sähago. Nafade egoweli sulubadela hamoi amoïe bidi nimolö amoda, udia dolö walio nefolalebe welia nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuea ado aso, sähamu neamu sähalea, Yalusaleme-e, Yalusaleme-e, bea sälo nefolalo amoli nufudala baagologe di. Amase, dolö digali fisiga wei amoli igia nufideloge di. Haea gagalugoea ïe malö augia hawa gafedela musügä negelo amo gadola, segeyo aboläiagi, na dïe malö goli gafedela gegedolasideläi gasoda, dihili habosio. ");
INSERT INTO etr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nabuö. Godea dilile mosö dïgïla awäseda, mosö amo memalä diamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na dilima sähago. Dilia ne bu elö made beala nelolahilä, dilia sähalea, Afädë Dafidilo Geloiïe ëigila maahago, Godea e neala obeägïlasimäiala säsolo amo gala, dilia ne bimolömelëla Yesuea säla ï. ");
INSERT INTO etr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu e Godeïe mosöamadila awäha nebegi, ïe bëgëla aulo amoli e neebea ami maalahilä, ilia ema, Godeïe mosö amoli bimola säi. ");
INSERT INTO etr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amala säsebegi, ea ilima säla obëgësalea, Egoweli beahale. Na dilima dofä sähago. Igi elö daia dadagulula fedai golida, sulubadela mugulula digaha maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu e Olibebidaia sebegi, ïe bëgëla aulo amoli hilidomu maalahilä ema nabahalea, Dia nilïma säla ïmo. Dia säi amo abola besela galamolödu. Dafidi nelebo edodale besela galasegi, nilïa amo beala, di hä, ulufadigimolö amoge, aligila wagamolö amoge, ga made gabula helësëmolöla nabi. ");
INSERT INTO etr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Amala nabasebegi, Yesuea ilima säla obëgësalea, Odoaea dili dahila neloea, idihë namialo. ");
INSERT INTO etr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mida, dolö yafie maalahilä nïe ëi säla, Afädë Memelei Geleso amoda ne misi neawela sälahilä, udia dolö yafie dahila nimolö moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amase, sege ga madefalï nudusalea ado goba nabase amogige, sege wagadi made nudusalea wabula säse amo nabase amogige, dili fudugila bedäloea, asigi sigi namialo. Nelebo amala hamomolö dialea gasoda, amo aso, aligila wagamolö mademelë. ");
INSERT INTO etr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Fii elöle elöle nudula digi, gamane elöle elöle nudula digisa namolömelë. Amase, sïdë iige, fogolige sege odoagi moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nelebo amoli sulubadela hamomolö amoda, udiaea malö ägümolö salea, mi gäwila sëlo amo gadoi bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Amo gala, dili nïe ëigi nefolalebego beala, udia dolö fii odoa amoli sulubadelaea dilima bimolö habobalahilä, dili neala sëlasila nufudala baagomolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Segeyo amo gala, yafiea nema asigi afädë negei amo dïgïla awälahilä, ilia hilimu bimolö habobala, odoama gaula ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Amase, wäfalï bea sälo yafiege maalahilä, udia dolö yafie dahila nimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mala nafade edese amea, udia dolö yafiea boba hamolo amo gögïla badilimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amamolö gaso, afädëa aso maadelahilä, wagamäiala gelola aligiseda, e damula moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Fifi asi sefolalebe amoli sulubadelaea nabaha maademäia, Godea Beaha Maadela Sigi Neebe amoïe Ado Mala Hedabi amo ilia sege föi sulubadelagi nefolalebe amolia nabuäia säla daidosa maademolömelë. Amala säla daidosa maadeseda, aligila wagamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesuea ado aso, sähamu neamu sähalea, Amamolö gabugi, dilia bea sälo Danialoea nelebo yöi ayägöloi amoïe säla negei amo Godeïe mosöa ami dië bimolömelë. (Ado egowe nidese ameada hedabola helësëmalo) ");
INSERT INTO etr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yudia segea sefolalebe amolida, segebi dibea ami fisäla baluluia afufumalo. ");
INSERT INTO etr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Amo gala, afädë mosö fïgïdaia sebe amea digalahilä, mumusogi ïe nelegei nea digamabio. ");
INSERT INTO etr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Amase, afädë sagaia neebe amea, fagulo daia salugalo negei amo mosöa nea obëgëmabio. ");
INSERT INTO etr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Segeyo amo gala, udia fagulo hagui sefolalebe amolige, malö dubo dodo ïaha sefolalebe amolige, asigii gabu. ");
INSERT INTO etr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Fisäla moholö amoda i bäu giisalea gögï mulo segeyo amo gala galëge, hele filo segeyo Sabada gafegi galëge muloea, dilia Godema adosa namialo. ");
INSERT INTO etr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mida, segeyo amo gala, yöi edefade elö elöla yafie maala negei dië bimolömelë. Sege föi dibe sulubadela mi gäwila hamoia amila yöi amo gadoi made melï. Amase, hobealage amo gadoi bu elö made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Amaimo, yöi segeyo amo Godea made obobagilasi galebeda, udia dolö sulubadela baago geia awälabio. Amalabio gaso, udia dolö hï memelei amoli helësëla, segeyo amo obobagilasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Segeyo amo gala, afädëa dilima sähalea, Bimo. Afädë Memelei amo misi neala säsege, gagowei misi neamelëla säsege, dofä gabula helësëmabio. ");
INSERT INTO etr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amoïe mida, wäfalï Afädë Memelei gadoi odoage, wäfalï bea sälo odoage moholömelë. Amala maalahilä, ilia udia dolö Godea memelei nefolalebe amoli dahila neala hamomabelela bimolöïe, dolöea dofä hamomolöi made gadoige, hïdo elöige hamosa namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nabuö. Amo made hamola neebe amo gaalu, na dilima säla ïahagomelë. ");
INSERT INTO etr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Amaimo, afädëa dilima sähalea, Nabuö. Sege udia dolö aligilo made dibea ami neala säseda, ami mosabio. Amase, afädëa sähaleada, Mosö hogoli afädëgi nogila digai saleala säseda, dofä gabula helësëmabio. ");
INSERT INTO etr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mida, sege yabagelela eso maasidola maala, eso digasidoge yo digalo amo gadola, Dolöïe Malö amo ulufadigisolo amo gala, amo gadola wäla ulufadigimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Baagoi domalo dibea ami haea säsalï gadoi maala gegedomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesuea ado aso, sähamu neamu sähalea, Segeyo amogi yöi yafie elö elöla amo hamosa maadei amole, eso usila, aube made neëla, amase, gasumilï mudaiala besela didigafulahilä, muugi nelebo geloi hïdo elöi amoge neala fogolasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Amala hamosegi, Dolöïe Malö amoïe nofe elöi amo mudaia ulufadigisegi, sege dibe sulubadelagi nefolalebe amoli didigaomolömelë. Ilia beahalea, Dolöïe Malö amo geloi amole, yo digalo hïdo elöifalï amolebalä, mu baidilidaia maala neë bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Amase, fuuloea gelola fuuse amo gaalu, ea ïe selesaia fii amolima mosalolahilä, udia dolö hï memelei sege föi sulubadelagi, agesu näiado nefolalebe amolige, näiado nefolalebe amolige, neala gegedolasimalola sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesuea ado aso, sähamu neamu sähalea, Diliada äfäeoïe mala amogi helësëmalo. Äfäeo fësëgësisila, bäu gähe bobagiseda, dilia helësësalea, sege esomolöda ga made gabula helësëlomelë. ");
INSERT INTO etr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Amo gadola wäla, nelebo sulubadela säsewe gadoi hamose dilia beaseda, amoda hä, ga made, suägïsa gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na dilima dofä sähago. Udia dolö walio nefolalebego baagola made nefolalegi wäla, nelebo säi amoli sulubadela hamosa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mu giwige, naga föige hogosa helemolö gaso, nïe adoda dofä made hogosa helemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesuea ado aso, sähamu neamu sähalea, Amala hamomolö amoda segeyoge, aoage afädëa dawa mademelë. Selesaia fii iliage, Malöeage dawa mademelë. Naadoea hïdomu dawadigi neamelë. ");
INSERT INTO etr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dolöïe Malö ulufadigisolo amo gala, Noaïe segeyogi hamoi amo gadola wäla hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ödä bëi made maala nebegi, ilia molö ödäge nadigi, udia neadigi, dolö fila awäla digisa nebegi, Noa ödä sibigi fila fedamolö segeyo amo besela galaimelë. ");
INSERT INTO etr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ilia dawa made nebegi, ödä bëi maala ödäea sulubadela mai. Dolöïe Malö ulufadigisolo amo galage, udia dolöea amo gadola wäla hamosa namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Segeyo amo gala, dolö äudä sagaia neëgi, elö amo neahalea, elö amo dïgïla moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Udia äudä wahalo däilaha neëgi, elö amo neahalea, elö amo dïgïla moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Amai gabugi, dilile Dafidilo segeyo gomo gala moholö gabula, dilia dawa made ameada, dilias idihë namialo. ");
INSERT INTO etr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ado gowe helësëmalo. Mosö eedoea fa nelo dolö gasigi gowe gala moholöla helësëi galebeda, ea idihë neëgi, ïe mosö dagabola fa nea digamäia fu made ïalabiomelë. ");
INSERT INTO etr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Amai amea, Dolöïe Malö moholö amoda, dilia gowe gala moholö gabula helësëi made neëgi, e moholö ameada, diliage daiaha namolö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesuea ado aso, sähamu neamu sähalea, Hamoi hamolasilo asigi falagaseige, nulügäige neebe amea, ïe dafidiloea hïle mosöa hamoi hamolasilo odoa sigi namiäia, ilile molö segeyo hï daiala negeifalïgi mogela ïlo amoda abodowedu. ");
INSERT INTO etr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ïe dafidilo amo maalahilä beahalea, hamoi hamolasilo amea, hamoi amo gadola wäla hamosa neë beaseda, hamoi hamolasilo amo obeägïsa namolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na dilima dofä sähago. Dafidilo amea hamoi hamolasilo amoma ïe nelegei sulubadela sigi namialamolömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amaimo, hamoi hamolasilo nafadea asigiamu helësësalea, nïe dafidilo aso, deegela, fodolo made moholöledula helësëlahilä, ");
INSERT INTO etr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ea hamoi gaalu hamolasilo nefolalebe amoli nufudala, gagaolo ödä nülo dolöbalä molö ödäle naha aligilomelë. ");
INSERT INTO etr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Amai gabugi, hamoi hamolasilo amea e segeyo gowegi, aoa gowegi moholöla helësëi made neëgi, ïe dafidilo amo moholömelë. ");
INSERT INTO etr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Maalahilä, ea hamoi hamolasilo amo neala nafademolöi nafadelasila, e asigi fea negelobalä namialamolömelë. Amida, ili dïisalea bese ali nalëgësa namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuea ado aso, sähamu nea sähalea, Hebeni Beaha Maadela Sigi Neebe Segeyo amoïeda, Udia dodola nabülasia ilile elamu amoli neala gaula, udia nimolö dolö amo gausiamolöïe afiai amo gadoimelë. ");
INSERT INTO etr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Udia amoligi biada asigi maade, amase, biada asigi gäwi. ");
INSERT INTO etr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Udia asigi maade amoliada, ilile elamu gaula afiai. Gaso, amobalä weli osala nafolala, gaula made afiai. ");
INSERT INTO etr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amasebegi, udia asigi gäwi amoliada, weli ödä iigi söga salala , ilile elamubalä nafolala gaula afiai. ");
INSERT INTO etr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Udia nimolö dolö amo fodolo made maasebegi, ili süwiala waolahilä, sulubadela adidi difolalo. ");
INSERT INTO etr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gasi mogogifalï, afädëa uuahalea, Uuaa. Udia nimolö dolö amoda hä, misi gabio. E gausiamolöïe afiamalola uuai. ");
INSERT INTO etr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Amala uuasebegi, udia dodola amoli sulubadela nowelahilä, ilile elamu amoli hahamogilahilä gaui. ");
INSERT INTO etr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Amasebegi, asigi maade amolia asigi gäwi amolima sähalea, Dilia weli gogi nilï gögödëla ïmo. Nilïle elamu usidelä hamosebela säi. ");
INSERT INTO etr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Amala säsebegi, asigi gäwi udia amolia säla obëgësalea, Ai. Weli wegida dilila nilïlada dofea made. Bidi neasia ami awälahilä, dilida dihilile bidia nimolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Amala säsebegi, ili weli nea asi amo gaalu, udia nimolö dolö amo besela galai. Amasebegi, daiai udia amolida ebalä awäla, udia neahalea molö edefade nasebea ami nogila digala sebegi, idi gai. ");
INSERT INTO etr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hobeala, udia dodola odoa amoli maala, ilia sähalea, Dafidilo, dafidilo, nilï idi gai dogasimola säi. ");
INSERT INTO etr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amala säsebegi, ea säla obëgësalea, Na dilima dofä sähago. Dilida na dawa madela säi. ");
INSERT INTO etr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Amamolö gabugi, dilia segeyoge aoage dawa made neebe ameada, idihë namialola Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuea ado aso, sähamu nea sähalea, Hebeni Beaha Maadela Sigi Neebea amida, gowe gadoi diamolömelë. Dolö afädëa e sege wagadi made moholö awähalea, ïe hamoi hamolasilo amoli misialalahilä, ilia ïe nelegei sigi namiäiaïe, ilile naabogi gausisi. ");
INSERT INTO etr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ea afädëma muni giwi siliba dausini bia ï. Elömada muni giwi dausini äudä ï, amase, elömada dausini afädëfalï ï. Ilile asigi dibe amo gadola, afädë afädëlama muni sogola gausisi. Amala hamola negesilahilä, e asi. ");
INSERT INTO etr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Asi bua, dolö dausini bia nelo amea, fodolofalï awäla bisinesi hamosa nea, dausini bia elö neala baai. ");
INSERT INTO etr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Amase, dolö dausini äudä nelo ameage, amo gadola hamolahilä, dausini äudä elö neala baai. ");
INSERT INTO etr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amai gaso, dolö dausini afädë nelo ameada, e awälahilä ïe dafidiloïe muni giwi dausini amo naga dögölahilä, naga isogi musügä negesi. ");
INSERT INTO etr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Segeyo holöbö ede nelolahilä, hamoi hamolasilo amolile dafidilo amo obëgëla, ea muni ï amoïe, ilibalä ado fädäla sämolöïe misi. ");
INSERT INTO etr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dolö muni giwi dausini bia nelo amea, dausini bia elöge baala nii amo gaula maala nea sähalea, Dafidilo, dia negali dausini bia ï. Ameada, na dausini bia elö neala baai amo gowemelë. ");
INSERT INTO etr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Amala sälebegi, ïe dafidilo amea ema sähalea, Hamoi hamolasilo hedabi-e, dia hamoi hedabolafalï hamoi gabu. Dida asigi nulügäi. Dia nelegei holöfalï go hedabola madëlela sigi nelo goeada, dia nelegei edefade sigi namiäiaïe ïmolömelë. Di nebalä obeägïsa namolöïe misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Amala säsebegi, dolö dausini äudä nelo ameage maala nea sähalea, Dafidilo, dia negali dausini äudä ï. Ameada, na dausini äudä elö neala baai amo gowemelë. ");
INSERT INTO etr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Amala sälebegi, ïe dafidilo amea ema sähalea, Hamoi hamolasilo hedabi-e, dia hamoi hedabolafalï hamoi gabu. Dida asigi nulügäi. Dia nelegei holöfalï go hedabola madëlela sigi nelo goeada, dia nelegei edefade sigi namiäiaïe ïmolömelë. Di nebalä obeägïsa namolöïe misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Amala säsebegi, dolö muni giwi dausini afädë nelo ameage maala nea sähalea, Dafidilo, dida dolö aabela habobalo amo na dawa. Dia made sagaia amida, dia molö nelo. Sege dia molö gägä made fëfëia amige, diada molö gegedola negelo. ");
INSERT INTO etr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Amalo ameada, ne bedähalea. Ne awäla, dïe muni giwi amo na naga dögöla negei. Dïe muni amoda gowemelë. ");
INSERT INTO etr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amala säsebegi, ïe dafidilo amea ema säla obëgësalea, Hamoi hamolasilo nafade di, dida habobame. Dia helësësalea, sagai na made sagaia ami na molö nelo, amase, sege na molö gägä made fëfëia amige, nada molö gegedola negelola helësëile. ");
INSERT INTO etr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Amala helësëi galëda, dia bëgi dolöbalä nïe muni negesi galebeda, ne obëgëla maala, baai muni amola nealabio. ");
INSERT INTO etr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Amai amea, muni giwi dausini afädë ea gaula neebe go neala, dausini nabülasi galebe amogali ïmalo. ");
INSERT INTO etr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Amoïeda, sulubadelaea nelebo afädë gaula neebe amolimada, odoa baala ïasegi, yafie gaula namolömelë. Gaso, afädëa nelebo afädë made gaula neebe amomada, holöfalïmelë gaula neebe amo haila nimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hä, hamoi hamolasilo nafade goda sege gasimi sagai dibea ami sogobala sadia idogomalo. Amida, ili dïisalea bese ali nalëgësa namolömelëla säila säi. ");
INSERT INTO etr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuea ado aso, sähamu nea sähalea, Dolöïe Malö amo, ïe yo digalo hïdo elöi salugalahilä, selesaia fii sulubadelabalä maasolo amo gala, e ïe beaha aligilo filo hedabi hïdo elöidaia samolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fifi asi sefolalebe amoli sulubadela, ïe odagia maala gegedolasisegi, sigi aligilo ilia sugua sibile sugua memele nafolala mogelo amo gadola, eada udia dolö mogela, ");
INSERT INTO etr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sugua sibida dafädimadi negela, sugua memeda fefeädimadila negemolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Amo gala, beaha aligilo Ginia ïe dafädimadi nefolalebe amolima sähalea, Nïe Naadoea neala obeägïlasi dili-e, dili misië. Godea Beaha Maadela Sigi Neebea ami digamalo. Amoda sege föi dibe sulubadela mi gäwila hamoia amila dilile daiai dilo. ");
INSERT INTO etr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mida, ne sïdëa baagoi nebegi, dilia ne molö ï. Ne ödä haläi nebegi, dilia ne ödä ï. Amase, ne näiadodi dolö gabugi, dilia ne mosöa sigi asi. ");
INSERT INTO etr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne fagulo maade nebegi, dilia ne fagulo ï. Amase, ne oloi dibegi, dilia ne sigi nelo. Ne galabaia mosöa nebegige, dilia ne bea misila sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Amala säsegi, mogola hamolo nefolalo amolia ema säla obëgësalea, Dafidilo Geloi-e, di sïdëa baagoi nebegi, nilïa abola beala, di molö ïasio. Di ödä haläi nebegi, nilïa abola di ödä ïasio. ");
INSERT INTO etr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Amase, di näiadodi dolö nebegi, nilïa abola di mosöa sigi awäsio. Di fagulo maade nebegi, nilïa abola digali fagulo ïasio. ");
INSERT INTO etr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Amase, di oloi dibegige, galabaia mosöa nebegige, nilïa di abola bea awäsiola nabulömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Amala nabasegi, Gini amea ilima säla obëgësalea, Na dilima dofä sähago. Dilia nelebo sulubadela nïe nedoolaligi afädë holöbö gidogofalï neebe amoma hamoi amoda, dilia nema hamoila sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Amala säsegi, ea fefeädimadi nefolalebe amolima sähalea, Nemola fisi udia dolöla dili, dilida ne neebeawi made, bahïla afiala, nulo usilo made dibea ami moholö mosö. Nulo amoda mugabe busa amoïege, ïe hamoi hamolasilo amolilege daiai. ");
INSERT INTO etr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mida, ne sïdëa baagoi nebegi, dilia ne molö made ï. Ne ödä haläi nebegi, dilia ne ödä made ï. ");
INSERT INTO etr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Amase, ne näiadodi dolö gabugi, dilia ne mosöa made sigi asi. Ne fagulo maade nebegi, dilia ne fagulo made ï. Amase, ne oloi dibegige, galabaia mosöa nebegige, dilia ne made bea misila sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Amala säsegi, iliage naba obëgësalea, Dafidilo Geloi, di sïdëa baagoi nebegige, di ödä haläi nebegige, di näiadodi dolö gabugige, di fagulo maade nebegige, di oloi dibegige, amase, di galabaia nebegige, nilïa amo abola bealahilä, di made ugila negesiola nabulömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Amala nabasegi, ea ilima säla obëgësalea, Na dilima dofä sähago. Dilia nelebo sulubadela afädë holöbö gidogofalï neebe amoma made hamoi amoda, dilia nema made hamoila sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Amai gabugi, ilida së nahamu namolöia ami moholömelë. Gaso, mogoi hamolo amolida namolöi namolö dibea ami moholömelëla Yesuea säla wagai. ");
INSERT INTO etr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuea ado amoli sulubadela säha maadelahilä, ïe bëgëla aulo amolima sähalea, ");
INSERT INTO etr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Segeyo äudä nelolahilä, Baagila Asi Segeyo besela galamolö amoda dilia dawa. Hä, Dolöïe Malö amo i fügäigi baala negemäia, odoaïe naabogi gausimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Segeyo amo gala, gobela ïlo busa nefolalo amolalige, Isilale udia dolöïe dafidilo dolö asigi gäwi nefolalo amolalige, gobela ïlo busa edefade amoïe mosöa ami gegedoi. Ïe ëida Gaiafasa. ");
INSERT INTO etr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ilia Yesu e nufudala baagomolöïe abeahämola oodolahilä, e gaumolödula säla didiäha difolalo. ");
INSERT INTO etr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ilia sähalea, Segeyo Edefade amoïe gedosolo amo gala amamolö gaso, amo gala made, udia dolöea gelola üala dodogöla nilïbalä nuduloeala säi. ");
INSERT INTO etr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu e sege Bedani ami, Saimono gudubu hamoi ea dafidi wahi amea mosöa ami sebegi, ");
INSERT INTO etr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","udia afädëa weli hedabi gafisigäi hïdo elöi muni edefadea nelo amo gaula, e sebea ami misi. Yesu e ami molö naha sebegi, udia amea weli ödä i igia hamoigi osala negei dilo amo, ïe busagia söga negei. ");
INSERT INTO etr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amala hamoi amo, ïe bëgëla aulo amolia bealahilä, ilia habobala sähalea, Faeagasebegoda edoïedu. ");
INSERT INTO etr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ameada bidi edefade nealahilä, muni amo busadäoigali ïalabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuea ilia habobasebe amo dawadigi nea, ea ilima sähalea, Dilia e edoïe yölasisa. Eada nema mala hedabi hamosebemelë. ");
INSERT INTO etr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Busadäoi amolida dilibalä namolöi namolömelë. Gaso, neda dilibalä namolöi namolö mademelë. ");
INSERT INTO etr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Udia amea nïe domalogi weli söga negei amoda, ne baumolö amoïe daiala hamoimelë. ");
INSERT INTO etr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na dilima dofä sähago. Ado Mala Hedabi gowe sege föi sulubadelagi säla olelesaleada, e helësëla, ea hamoi amoge säla ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Giwilasi amoligi afädë, ïe ëida Yudasa Isagaliada, e gobela ïlo busa neebea ami awälahilä, ");
INSERT INTO etr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ea nabahalea, Na e dilile naabogi gausideläïe, diliada negali edo ïmolö gabula nabi. Amala nabasebegi, ilia muni giwi siliba nabülasi ohodoa nidelahilä, egali ï. ");
INSERT INTO etr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Segeyo amila nofela, ea Yesu e ilile naabogi gausimolöïe fu hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Segeyo Edefadegi beledi edelo yidila made gobela molö amoïe segeyo bu agesolo amo gala, bëgëla aulo amoli maalahilä, Yesuma nabahalea, Baagila Asi Segeyo amoïe molö molö amo, diada, nilïa abidi daiamäia hamesebela nabi. ");
INSERT INTO etr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Amala nabasebegi, Yesuea ilima sähalea, Gaamugi awälahilä dolö amoma gomalä sämalo. Säla Oleleloea sähalea, Nïe fuda hä, ga made gabugi, nïe bëgëla aulolali, Baagila Asi Segeyo amoïe molö molö amo ne dibalä nuduläla säila sämalola säi. ");
INSERT INTO etr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Amala säsebegi, bëgëla aulo amolia Yesuea säi amo gadola hamola, Baagila Asi Segeyo amoïe molö molö amo daiai. ");
INSERT INTO etr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Deadifalï, Yesu e giwilasi amolibalä molö naha sefolalo. ");
INSERT INTO etr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ili molö naha sefolalea, ea sähalea, Na dilima dofä sähago. Dili sebegogi afädëa ne hololöla odoaïe naabogi gausimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Amala säsebegi, ilile asigia edefade yöia idogolahilä, hïdo hïdolaea ema säla didigahalea, Dafidilo Geloi-e, nale, ma nalela säla didigai. ");
INSERT INTO etr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Amala säla didigasebegi, Yesuea säla obëgësalea, Dolö nebalä falogi naabo gaalu digai ameada, ne hololöla odoaïe naabogi gausimolömelë. ");
INSERT INTO etr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ïe säla dëdëla negei dibe amo gadola, Dolöïe Malöda baagomolö. Gaso, Dolöïe Malö e hololöla odoaïe naabogi gausise dolö amoda, asigii gabumelë. E emea made neegela ägüi galebeda, e hedabi aligilabiomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasa, e hololöla odoaïe naabogi gausimolö amea nabahalea, Säla Olelelo-o, nalela nabi. Amala nabasebegi, ea ema sähalea, Dihï säse gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ili molö naha sefolalea, Yesuea beledi afädë nealahilä, Godema nesegei. Nesegelahilä, ea beledi dagabodasila, bëgëla aulo amoligali ïahalea, Goda nïe domalomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Amala sälahilä, ea gaabogi usi amo neala gaula nea, Godema nesegelahilä, iligali ïahalea, Dili sulubadelaea go hä, gobe dadagabola mualo. ");
INSERT INTO etr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Goda nïe healemelë. Asialo made ado elöi säla negemolöïe healemelë. Nafade hamoi amoli hëmäia, udia dolö yafiegali besigahawe. ");
INSERT INTO etr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na dilima sähago. Segeyo wila nofela, ne wani ödä bu elö made naala nelolahilä, Naadoea Beaha Maadela Sigi Neebea ami nea, dilibalä bu elö molömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Amala sälahilä, ilia gë afädë udälahilä, Olibebia afiai. ");
INSERT INTO etr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olibebia afiahalea, Yesuea ilima sähalea, Walio gasigi, dili sulubadelaea, nema hamosebe amo beahalea, dilile asigi afädë negeigo digamolömelë. Mida, ado säla dëdëla negei dibe amea sähaleada, Na sugua sibi sigi aligilo nufudasegi, sugua sibida fisäla dusudasila afufumolömelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amamolö gaso, ne nowelasisegi, na dili baagila, nedale Galili moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Amala säsebegi, Fidaea ema säla obëgësalea, Dima hamosebe amo bealahilä, sulubadelaïe asigi afädë negei amo digaseda, neda dofä made amamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Amala säsebegi, Yesuea ema sähalea, Na dima dofä sähago. Walio gasigi gagalugo gawalia made gäla neëgi, dia ne dawa madela nafi bu ohodoala sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Amala säsebegi, Fidaea ema sähalea, Neda dibalä gaalu baagomolö galëda, na di dawa madela dofä made sämolömelëla säi. Ïe bëgëla aulo amoli sulubadelaeage amalamu säla didigai. ");
INSERT INTO etr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu e ilibalä sege ëi Gesemani besela galalahilä, ea bëgëla aulo amolima sähalea, Ne holöbö gasi gala Godema adose gaaluda, dili wi sefolamialola säi. ");
INSERT INTO etr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Amala sälahilä, Fidage, Sebediïe malö äudä amolege, ea ili sigi awälahilä nea, ïe iso asigia yöia idogola, säosäosa nelo. ");
INSERT INTO etr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Amala nea, ea ilima sähalea, Nïe iso asigia edefademalä yöia idogosalea, ne baagomolö gabumelë. Dili gui nea, nihïlïgïla idihë namolölamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Amala sälahilä, e holöbö gasi gala, nagadaia gumusula dia idogolahilä, Godema sähalea, Nïe Naado, asiamolö fu galëda, gaabogi usi molö amo na asiamäia. Amamäia gaso, na hamese amo gadola made, dia hamese amo gadola hamomäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Amala sälahilä, ea ïe bëgëla aulo sebea ami awäla beahaleamelebe, ili süwia adi dibe amo bealahilä, ea Fidama nabahalea, Dilia nebalä aoa afädë idihë namolö ulïsebele. ");
INSERT INTO etr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nafadea dili fedogola melëloea, idihë nea, Godema adosa namialo. Dofä. Asigiada hamomolöila helësësa neago gaso, domalo wäbëai nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Amala sälahilä, e bu agedu obëgëla, Godema adosalea, Nïe Naado, go made asiala, muäia galëge, dia hamese amo gadola hamomäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Amala sälahilä, e bu obëgëla maala beahaleamelebe, ili aso süwia adi dibe melï. Mida, ilile si gafodo gadugisalea amai. ");
INSERT INTO etr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ili ami bu elö dïgïla awälahilä, ea bu osoda Godema dafidi säi amo gadola wäla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Amala sälahilä, ïe bëgëla aulo amoli sebea ami bu obëgëla awäla, ea ilima sähalea, Dili süwiamu diala, hele saleale. Bimo. Fu hä, ga madesebego. Dolöïe Malö amoda, nafade hamolo amolile naabogi hololöla gausisebemelë. ");
INSERT INTO etr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dili hä, nowemo. Afiadi. Bimo. Dolöea ne hololöla odoaïe naabogi gausimolö amo hä, ga made misi neebemelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuea ado amo aso, säha nebegi, giwilasi amoligi Yudasa e misi. Dolö maleia nudulo helebege baialage gagaula, ebalä mofiai. Gobela ïlo busa amoliage, Isilale udia dolöïe sigi aligilo asigi gäwi dolö dafidilo amoliage, dolö amoli misialai. ");
INSERT INTO etr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","E hololöla ilile naabogi gausilo amea, ilima dafidi daiala säla ïahalea, Na dolö gaula mimise amoda emelë. E gaumalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ili maalahilä, e hä, Yesu neebea fodolofalï maala sähalea, Säla Olelelo-o, di go gabiola sälahilä, e gaula mimi. ");
INSERT INTO etr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mimisebegi, Yesuea ema sähalea, Nedoo, dia hamomolö misi amo hä, hamomalola säi. Amala säsebegi, dolö amoli maala, Yesu hä, gaulahilä, gaula fëdöi. ");
INSERT INTO etr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amalebegi, dolö afädë Yesubalä nelo amea, ïe helebe besela neawelahilä, gobela ïlo busa edefade amoïe hamoi hamolasilo amo nufudalahilä, ïe gëhe dagala salisi. ");
INSERT INTO etr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Amala hamosebegi, Yesuea ema sähalea, Dia helebego dihï negeia ami negela obëgëmo. Mida, dolö sulubadelaea helebea nudumolöïe gauseda, helebea ili nufudala baagosa maademolö gabu. ");
INSERT INTO etr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na nïe Naadoma nabaseda, ea selesaia fii yafie, ami baagila asi giwilasi amolida, nema waliomu fisiga wemolömelë. Na ema amala nabulö amo ulïla helësësebele. ");
INSERT INTO etr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gaso, na amala nabaha galebeda, ado säla dëdëla negei dibe amo gadola, amala hamomolöi dialeala säi amo made gausiala digalabiola säi. ");
INSERT INTO etr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Amo gala, Yesuea gegedoi amolima sähalea, Fa nelo gaumolöïe mulo amo gadola, nudulo helebege baialage gagaulahilä, ne gaumolö misile. Segeyo sulubadelagi, nada Godeïe mosöa säla olelesa sulo amogi, dilia ne made gaui. ");
INSERT INTO etr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gaso, bea sälo amolia ado säla dëdëla negei dibe amo gadola gausiala digamolöïe, nelebo sulubadela amala hamosamelëla säi. Amala säsebegi, bëgëla aulo amoli sulubadelaea e dïgïla fisäla awäha maadei. ");
INSERT INTO etr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesu gaui amolia e sigi gaula gobela ïlo busa edefade Gaiafasa neebea ami asi. Mala dawadigi dolö amolige, asigi gäwi dolö dafidilo amolige, ami gegedoi nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Fida e holöbö hobeala baagiala e bëgëla awäla, gobela ïlo busa edefadeïe mosö yala isogi digalahilä, hä, wagasebe amo bimolöïe, hamoi hamolasilo amolibalä beaha sulo. ");
INSERT INTO etr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Gobela ïlo busa amoliage, Galïsolö dolö amoli sulubadelaeage, e baagomäia nufulöïe, dolö odoaea wäfalï, Yesuea asiala hamose melëlo amo sämäiala hogoi. ");
INSERT INTO etr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hogosebegi, yafiea wäfalï, ea asiala hamose melëlo amo säla misi gaso, e nufulöïe mi made melï. Made beasebegi, giso hobealafalï, dolö äudä maalahilä ");
INSERT INTO etr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sähalea, Egowea sähaleada, Na Godeïe mosö go haila digilahilä, segeyo ohodoagi bu ulimolöimelëla säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amala säsebegi, gobela ïlo busa edefade amea nowela aligilahilä, Yesuma nabahalea, Dia ado afädë made säla obëgësale. Elea dima säsegoda, abeahämola sähadula nabi. ");
INSERT INTO etr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amala nabasebegi gaso, Yesuea ado afädë säla made saula sulo. Amasebegi, gobela ïlo busa edefade amea ema sähalea, Gode namolöi neebe amoïe ëigi, dia nilïma fädäla sämola säha. Afädë Memelei amoda, dile. Dida Godeïe malölela nabi. ");
INSERT INTO etr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Amala nabasebegi, Yesuea ema säla obëgësalea, Dihï säse gomelë. Gaso, na dilima sähago. Hobealada, Dolöïe Malö Geloi Edefade amoïe naabo dafädimadi filahilä, e mu baidilidaia maaha neë bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Amala säsebegi, gobela ïlo busa edefade amea, hïle fagulo gadelaha nea sähalea, Ea Gode gagadela säsebego. Odoama ea hamoi amoïe nalï made nabedelämelë. Hädamade ea Gode gagadela säsebe amo dilia hä, nabi amomelë. ");
INSERT INTO etr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dilia abilia helësësebela nabi. Amala nabasebegi, ilia säla obëgësalea, Eda hä, nufudala baagomolö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Amala sälahilä, ilia Yesu e odagia gofedela gagalala, e nufudala ïalalei. Odoaeada e naabo gafea nufudalahilä ");
INSERT INTO etr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sähalea, Afädë Memelei, dolö di nufudase egoweda nowë gabu. Dihï bea säla sämola säha nelo. ");
INSERT INTO etr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Amo gala, Fida e yala amoïe isogi nogila digasia segeamadi ami sebegi, hamoi hamolasilo dolïsä afädë maalahilä ema sähalea, Dige Galili dolö Yesubalä nawesa aligilo amo gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amala säsebegi gaso, Fidaea dolö sulubadelaïe sidaia ne madela sälahilä sähalea, Ado dia säse goda, na dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Amala sälahilä, e yala baagido idi dagaboimadi awäha nebegi, hamoi hamolasilo dolïsä elöea e bealahilä, ami nefolalebe amolima sähalea, Dolö egoweda Nasalese dolö Yesubalä nawesa aligilo amo gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Amala säsebegi, Fidaea migalïa diigila, bu elö ne madela gelola sälahilä sähalea, Dolö amoda na dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hobeala, dolö odoa ami nefolalebe amolia maalahilä, Fidama sähalea, Dida dofä amoligi gabu. Dia adosebegoea dihïdi ulufadigisebegomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Amala säsebegi, Fidaea, na we wäfalï säseda, dofä ne Godea së ïmäiala sälahilä, migalïa diigila sähalea, Dolö amo na dawa mademelëla säi. Ea säia gai amole, hä, gagalugo gawalia gäi. ");
INSERT INTO etr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Amala gäsebegi, Fidaea helësësalea, Yesuea sähalea, Gagalugo gawalia aso, made gäla neëgi, dia ohodoala ne dawa madela sämolömelëla säi amo helësëla obëgëi. Amala helësëla obëgëlahilä, e segea doadigila awäla, gäia güsäla dïisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Segeyo sagala digase amo gaalu, gobela ïlo busa nefolalo amoli sulubadelaeage, udia dolö ilile busa dolö nefolalo amoliage, Yesu baagomäia nufulöla säla ado afädë negei. ");
INSERT INTO etr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ilia Yesu e igi ëfëa nafodolahilä, sigi gaula awäla, Gabena Bailadiïe naabogi gausi. ");
INSERT INTO etr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ilia hä, Yesu nufulöïe hamosebe amo bealahilä, Yudasa, Yesu hololölo amea asigi bedefalahilä, muni giwi siliba nabülasi ohodoa amo neala gaula, gobela ïlo busa amolige, dolö asigi gäwi busa dolö amolige neebea ami obëgëlahilä ");
INSERT INTO etr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","sähalea, dolö nafade afädë made hamoi na hololöi amoda, asiala hamoi gabiola säi. Amala säsebegi, ilia säla obëgësalea, Dia hamoi goda nilïle mademelë. Goda dihïlemelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Amala säsebegi, Yudasaea muni amo Godeïe mosö isogi ami sadia idogolahilä awäla, hïmu maagö bëola baagoi. ");
INSERT INTO etr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amala hamosebegi, gobela ïlo busa amolia muni amo neala gaula nea sähalea. Goweada, dolöïe heale digamäia hamoi amea, muni goda negelo dibea ami gedola negemolöda dofea mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ilia ado afädë negelahilä, muni amea sege afädë nii. Sege amoda, nagaea sosobene hamolo dolö amoma nii. Udia dolö sege odoadila misi amoli baagosegi baumolöïe sege nii. ");
INSERT INTO etr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Amala hamoi amo helësëlahilä, sege amoda Heale Segela sälo, amase, walioge amala säha nea. ");
INSERT INTO etr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Amoda Godea bea sälo Yelemaeama aligila bea säi amo gausiala digai. Ado amoda gomalä. Ilia muni giwi siliba nabülasi ohodoa amo neala gaui. Bidi amoda Isilaleïe malö odoaea dolö goïe bidida gomalä säla negei. ");
INSERT INTO etr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dafidilo Geloia na hamomalai amo gadola, nagaea sosobene hamolo dolö amoïe sege nimolöïe, ilia bidi amo ïla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu e Gabenaïe siigi nowela nebegi, Gabenaea Yesuma nabahalea, Dida Yu udia dolöïe beaha aligilo ginilela nabi. Amala nabasebegi, Yesuea säla obëgësalea, Dihï säse gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gobela ïlo busa amoliage, dolö asigi gäwi dafidilo amoliage, ea asiala hamoimelëla säsebegi, ea ado afädë made säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Amasebegi, Bailadia ema nabahalea, Ilia dima asiala hamoila säsebego, dia made nabahalela nabi. ");
INSERT INTO etr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hä, Yesuea ado afädëge made säla obëgësebegi, Gabena amo edefademalä fudugi. ");
INSERT INTO etr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Segeyo Ede amoïe molö nasolo amo galada, Gabenaea galabaia negei afädë fisigähamu aligilo. Udia dolö gegedoi amolia dolö gowe fisigämola säse amo gadola, hilima fisigälasilo. ");
INSERT INTO etr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Segeyo Ede amoïe segeyo gala, dolö afädë, ëi Balabasa galabaia negei dilo. Udia dolö sulubadelaea ïe mala dawadigi. ");
INSERT INTO etr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Udia dolö yafie maala gegedoi nebegi, Bailadia ilima nabahalea, Na dihilima nowë fisigämäiala hamesebe. Balabasa fisigädule, ma Yesu, ema Afädë Memeleila sälo go fisigädulela nabi. ");
INSERT INTO etr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Amala nabi amoïe mida, ilia Yesuma mudialahilä, ïe naabogi gausi gabula helësëlahilä amala nabi. ");
INSERT INTO etr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Amaimo, e gudisalea filo amodaia sebegi, ïe udiaea ado afädë säsisalea, Dolö mogoi goma afädë made hamomalo. Mida, na walio simasia beala, e helësëla nïe asigi edefade yöia idogoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amai gaso, gobela ïlo busa amoliage, dolö asigi gäwi dafidilo amoliage, udia dolö gegedoi amolima Balabasa fisigähalea, Yesu nufuöla sämäia si nigilasi. ");
INSERT INTO etr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Amasebegi, hä, Gabenaea ilima nabahalea, Äudä amolegi abodo dihilima fisigämäiala nabi. Amala nabasebegi, ilia säla obëgësalea, Balabasamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Amala säsebegi, Bailadia ilima nabahalea, Amai galëda, Yesu, ema Afädë Memeleila sälo goma, na abilia hamomäiala nabi. Amala nabasebegi, ili sulubadelaea säla obëgësalea, Eda i fügäigi baala negemäiala säi. ");
INSERT INTO etr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Amalebe, ea ilima nabahalea, Mida edogi. Ea edo nafade hamoi gabiola nabi. Amai gaso, ilia gelolafalï uuala sähalea, Eda i fügäigi baala negemäiala säha nelo. ");
INSERT INTO etr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ea säse amo made nabahalea, ilia gelola üala dodogöla sämolö hamosebe amo bealahilä, Bailadia udia dolö gegedoi amolile sidaia naabo nigime hësalea sähalea, Dolö goïe heale digaseda, asialada nema maademelë. Dihilima gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Amala säsebegi, udia dolö amoli sulubadelaea säla obëgësalea, Ïe healeda nilïmage, nilïle malömage diamiäiala säi. ");
INSERT INTO etr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Amala säsebegi, ea Balabasa hilima fisigäla fisiga galahilä, odoaea Yesu fëgämaloi. Fëgälahilä, e i fügäigi baala negemolö sigi mosalai. ");
INSERT INTO etr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Amala hamosebegi, Gabena amoïe ami dolö amolia Yesu sigi awäla, Beledoliama mosöa nogila digalahilä, ami dolö odoama gegedomalolahilä, e nogömaloi. ");
INSERT INTO etr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ami nebegi, ilia ïe fagulo gäi amo giila negesilahilä, fagulo bëi sedade bedefala salugasi. ");
INSERT INTO etr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Amalahilä, ëfë äyo gägäi nasigïla amalela, giniïe busa gadoi hamola ïe busagia salugasilahilä, i dama dagaboige ïe naabo dafädimadi gausi. Ili e mia emo gumu sasagala fia idogola salea, e gadiabola sähalea, Yu udia dolöïe beaha aligilo gini-e, di go gabiola säha nelo. ");
INSERT INTO etr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Amalahilä, ilia e gofedela gagalala digi, amase, i dama dagaboi gausi amo fedela neala busagia nufudadigisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ilia ema amala gagadiabosa nelolahilä, fagulo sedade amo holola, hïle fagulofalï amo salugasi. Salugasilahilä, ilia e i fügäigi baala negemolöïe sigi asi. ");
INSERT INTO etr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ili amila doadigila afiaha dibegi, gaamu Sailini fii dolö afädë, ïe ëida Saimono gausiala digai. Amalebe, ilia ema Yesuïe i fügäi amo gaumalala eegei. ");
INSERT INTO etr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Afialahilä, sege ëi Gologoda besela galai. Gologoda amoda Busa Giwi Segela sälo. ");
INSERT INTO etr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Besela galalahilä, ilia wani ödäge gamogai ödäge gegoalahilä, egali muäia ïasebegi, ea nabibilage, molö made helësëi. ");
INSERT INTO etr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Amalebe, ilia e hä, i fügäigi baala negelahilä, ïe fagulo gii amo nowëa nimabelela, sadu dahila, ïe fagulo amo amala mogei. ");
INSERT INTO etr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Amalahilä, ilia idihë salea, sisila sefolalo. ");
INSERT INTO etr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ilia i fügäigi ïe busa daia adomoi, ema gudisalea säi amo dëdësalea, Goda Yesu, Yu udia dolöïe beaha aligilo ginila dëdëla baala negei. ");
INSERT INTO etr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Amala hamolahilä, ebalä fa nelo dolö äudä, elö naabo dafädimadi, amase, elö naabo fefeädimadila i fügäigi baala negei. ");
INSERT INTO etr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Udia dolö ili amogi baagila afu mafusalea, ema busa dugagila digila gagadiabola ");
INSERT INTO etr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","sähalea, Diada Godeïe mosö haila digilahilä, segeyo ohodoagi ulimolöeai amo, di dihïmu damula mosö. Dida Godeïe malö galëda, i fügäia adogoila digamola säla baagi baagisa nelo. ");
INSERT INTO etr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Amaimo, mala dawadigi amoliage, dolö asigi gäwi dafidilo amoliage, gobela ïlo busa amoliage, amo gadola wäla gadiabola sähalea, ");
INSERT INTO etr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Eada udia dolö odoa ugila negelo. Amai gaso, hï e ugila negemolöi made gabu. Eda Isilaleïe beaha aligilo gini nea. I fügäia adogoila e walio digaseda, nilïa ema asigi afädë negemolö. ");
INSERT INTO etr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ea Godema asigi bogia adogola nelo. Godea e hameseda, ea e ugila negemäia. Mida, ea sähaleada, Neda Godeïe Malöla sälo ameala säha dilo. ");
INSERT INTO etr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Fa nelo dolö ebalä i fügäigi baala negei amoleage, amo gadola wäla ema nemoi. ");
INSERT INTO etr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Eso mogogila awäla eso bëgise gaaluge, sege sulubadela gasilasimu dilo. ");
INSERT INTO etr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eso bëgise gaalu, Yesuea gelolafalï wela säia adahalea, Eli, Eli lama sabagadanila säi. Amoïe mida gomalä, Nïe Gode, nïe Gode, dia ne edogi fisigisisala säi. ");
INSERT INTO etr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Amo nabalahilä, odoa ami nefolalo amolia sähalea, Goeada Elaia wesebegola säi. ");
INSERT INTO etr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hä, fodolofalï amoligi afädë baluluia awäla, nelebo afädë dahudu gadoi wani ödä gamogai dibea ami gelahilä, i bidigi yaala, egali muäia ï. ");
INSERT INTO etr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amala hamosebegi, odoa amolia sähalea, Aso. Elaia maala, e damula misiabelela beaha aligidila säi. ");
INSERT INTO etr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuea bu elö gelola sälahilä, ïe namolö amo fisila, hame hä, mosaloi. ");
INSERT INTO etr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Amasebegi, fagulo edefade Godeïe mosöa gosagisi dilo amo, gadogola gadelala digalahilä, elö eamu eamula negesi. Amase, fogolige maala, igige dusula adögodasi. ");
INSERT INTO etr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amase, baui amolige doga negesebegi, Godeïe udia dolö baagoi difolalo amoligi, yafie nowelasisi. ");
INSERT INTO etr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu baagoi amo nowelasisebegi, bauiala nowelasisi amoli baui däla amo dïgïla awäla, gaamu Godea hïle nafolai Yalusaleme dibea ami ili nogila digasebe amo, udia dolö yafiea melï. ");
INSERT INTO etr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ami dolö hädali afädë beaha aligilo ameage, ebalä Yesu idihë nefolalo amoliage fogoli misi amogige, nelebo hamoi amogige beala, edefademalä fudugila bedälahilä sähalea, Wae! Goweda dofä Godeïe malö gabula säi. ");
INSERT INTO etr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Udiafalï yafiea Yesu ugila negemolöïe, Galilila e bëgëla mofiai amolige, ami holöbö mia madela sidawewela nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Magadala udia Melige, Yamesele Yosebelele eme Melige, amase, Sebediïe malö äudä amolele emege, udia amoligi ami nefolalo. ");
INSERT INTO etr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Segeyo amo gala deadifalï, gaamu Alimadia fii nelegei yafie negelo dafidilo dolö afädë misi. Dolö amoïe ëida Yosebe. Eege Yesuïe bëgëla aulo nelo. ");
INSERT INTO etr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E Bailadi neebea maalahilä, Yesuïe domalo amo ema ïmäia nabi. Nabasebegi, Bailadia ami dolöea ema neala ïmalai. ");
INSERT INTO etr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Neala ïasebegi, Yosebea Yesuïe domalo amo fagulo nigime baai made, hedabifalï amea usulala ");
INSERT INTO etr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","gaula awälahilä, hïle igi äbä gähe duwi dilo amogi bausi. Bausilahilä, igi edefade afädë bebugula maala, idi amo dofogasilahilä, e hä asi. ");
INSERT INTO etr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magadala udia Melige, amase, Meli elö amoge, ele Yesu baui gaalu alömodi sulo. ");
INSERT INTO etr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nelebo daialo segeyo amo baagia, segeyo amogi gobela ïlo busa nefolalo amolige, Felesi dolö nefolalo amolige, Bailadi neebea awäla gegedolahilä ");
INSERT INTO etr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sähalea, Dafidilo, dahila nelo goea aso, made baagola nea sähalea, Segeyo äudä nelolahilä osodagi, ne nowelasimolömelëla säi amo nilïa helësëla obëgëimelë. ");
INSERT INTO etr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Amala säi amea, segeyo ohodoa gogi, odoaea baui amoïe idi hedabola galahilä, idihë namialamalo. Bëgëla aulo amolia maala, ïe domalo amo nealahiläda, udia dolöma hä bauia amila nowelasimelëla säloea. Ilia amala hamola, dahila neala säseda, ea dafidi dahila neala sälo amo baagila moholö gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Amala säsebegi, Bailadia ilima sähalea, Ami dolö odoa idihë aligilo namiäia diligali ïahago. Dilia ili sigi awälahilä, ilia bauia ami idihë namialamalo. Dilia gomalä hamomolöila asigisebe amo gadola hamola, baui hedabola gamalola säi. ");
INSERT INTO etr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Amala säsebegi, ili awäla baui amo hedabola galahilä, odoaea idi galo igi amo bebugula auloea nofe negela, idihë aligilo amolima hedabola idihë namialai. ");
INSERT INTO etr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Segeyo Sabada baagibua, saleleïe mi gäwi segeyogi, eso mi gäwila säsälosebe amo gaalu, Magadala udia Melile, Meli elölea baui amo bea asi. ");
INSERT INTO etr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ami nebegi, fogoli edefade misi. Dafidilo Geloiïe selesaia fii afädë Hebenila digahalea amai. Digalahilä, selesaia fii amea igi amo bebugula negesilahilä, e amodaia sulo. ");
INSERT INTO etr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Selesaia fii amoïe odagida sege yabagelela yo digalo amo gadoi, amase, ïe fagulo gäige falelafalï fisi. ");
INSERT INTO etr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Amogi, idihë aligilo amoli ebalä bedähalea, ili emo gigisëla, baagoi gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amaimo, selesaia fiia udia amolema sähalea, Alia bedämabio. Alia Yesu i fügäigi baala negei amo hogola misigoda, na dawamelë. ");
INSERT INTO etr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eda wi maade. E negei diloa gowe bea misië. Mida, ea säi amo gadola, nowela asimelë. ");
INSERT INTO etr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ali hä, aabela awäla, ïe bëgëla aulo amolima gomalä sämalo. Eda baagoiala nowela asimelë. Dili baagila, edale Galili moholö awäha nea, e ami bimolömelëla sämalo. Na hä, alima säi agui amomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Amala säsebegi, ele bedälage, edefademalä obeägïlage, fodolofalï bauia amila awäla, ïe bëgëla aulo amolima sämolöïe baluluia asi. ");
INSERT INTO etr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Awäha nebegi, Yesuea ele gausiala digalahilä sähalea, Ali go gabiola säi. Amala säsebegi, ele e mia ga madela maala, ïe emogi gaula digala, elea ïe ëi gauia adai. ");
INSERT INTO etr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Amasebegi, Yesuea elema sähalea, Alia bedämabio. Aliada, nïe nedoolalima, ili Galili mosalamalo. Awäseda, ilia ne ami bimolömelëla sämolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Udia äudä amole awäha nebegi, idihë aligilo odoa awäla gaamu isogi digalahilä, ilia gobela ïlo busa amolima nelebo sulubadela hamoi amo säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Amala säsebegi, gobela ïlo busala, dolö asigi gäwi dafidilobalä gegedolahilä, ilia ado afädë daiala negei. Ilia muni malei neala, ami dolö amoligali ïahalea ");
INSERT INTO etr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sähalea, Dilia gomalä sämalo. Ïe bëgëla aulo amolia gasigi maalahilä, nilï adidi dibegi, ïe domalo amo fa niimelëla sämalo. ");
INSERT INTO etr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Amasebegi, Gabenaea ado gowe nabaseda, amoda, nilïa ebalä ado hahamogimolömelë. Dilia asiala hamoi made bimäiala säi. ");
INSERT INTO etr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Amala säsebegi, ami dolö amolia muni amo nealahilä, ilima säi amo gadola bëgëi. Amaimo, walioge Yu ilia ado amomu säla daidosa nea. ");
INSERT INTO etr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bëgëla aulo gïdälasi amoli Galili afialahilä, segebidaia Yesuea säla negeia ami afiai. ");
INSERT INTO etr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Afialahilä, ilia e beala, ïe ëi gauia adai. Amai gaso, odoaeada asigi äudä negei. ");
INSERT INTO etr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Amasebegi, Yesu e ili neebea maala nea, ilima sähalea, Hebeniïege, nagadaiaweïege, geloi sulubadela nema gausisa maadeimelë. ");
INSERT INTO etr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Amala hamoi amea, dili awälahilä, fifi asi sefolalebe amoli sulubadela nïe bëgëla aulo aligimäiaïe sämolö mosalo. Amalahilä, dilia Naadoïe ëigige, Malö amoïe ëigige, Eleloi Gesamiïe ëigige, ili ödägi gelasila, ");
INSERT INTO etr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","na dilia hamomalai amo sulubadela ilia bëgëla hamomäia olelemalo. Segeyo sulubadelagi ne dilibalä namolömelë. Amalamu awäla, aligila wagamolömelëla säi. Hä amo. ");
INSERT INTO etr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ado Mala Hedabi goda, Godeïe malö Yesu Gelesoea dafidi mi gäwi amo dialea. ");
INSERT INTO etr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bea sälo Aisaeaïe bebagi ado dafidi dëdëla negei dibe amoda gowe. Godea sähalea, Nabuö! Nïe ado säla ïmolö mosalamalo amomada, dïe idi fodolasimäia, ema dafidimola sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Udia dolö aligisia made sege falaia ami nea, afädëa uuala wesalea, Dafidilo Geloi misiäia idi fodomolö amo dadaiaha namialo. Ïe idi amoda mogolafalï fodolasimalola säha neamelëla säi amo dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Amala säla dëdëla negei dibe amo gadola, sege nafade udia dolö aligisia made ami ödägi gelo Yone e misi nelo. Ea sähalea, Dilia nafade hamoi amo Godea hëmäia, dilile iso asigi besula, ödägi gemolö dialeala säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudia sege gaamu holöfalï holöfalï dibea amilage, Yalusaleme udia dolö nefolalo amoli sulubadelage, e neebea ami mafusa nelo. Mafula ilia nafade hamoi amo sisiaha maadesebegi, Yonea ili ödä Yodonagi gesa nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yone eda sugua gamele hilïa fagulo hamoi amo salugalahilä sugua gafodo gadoia malibu negela nelo. Eada galiawage äwi ödäge naha nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ea ado mala säla ïahalea, Ne dafidi misi neawe. Hobea ne baagia afädë moholö amoda, ne holöfalï neebewe gadoi made, eda ilibia edefade neebe amo moholömelë. Ne hedabi made ameada, na ïe emo usililo ëfë gumusula dialea fisigämolö amo dofea made neawe. ");
INSERT INTO etr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na dili ödäeamu gesa neamelë, eada dili Eleloi Gesamia gemolömelëla säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Segeyo amogimu Yesu e Disiligi Galiliïe gaamu Nasalesela maasebegi, Yonea Yesu ödä Yodonagi gelasi. ");
INSERT INTO etr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu ödägi gelahilä ödägila fodolo agesua aliga adogoi amole, mu dusuia gase amo melï. Amala dusuia gasebegi, Gesami haea maliabu gadoi digalahilä ema fise amo melï. ");
INSERT INTO etr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Amo gaalu, selesaia mosöala ado afädë säia idogosalea, Dida nïe malö. Na dima edefademalä boba hamoi nea, nïe iso asigia dima obeägïsa neawela säi. ");
INSERT INTO etr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ado amo säha maadeia gai amole, Godeïe Gesamia Yesu e sege nafade udia dolö aligisia made ami mosäia fisiga gai. ");
INSERT INTO etr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E fisiga gaia ami segeyo nabülasi biyidia nebegi, mugabe Saidania Yesuea nafade hamomabelela fedogola bimolö misi. Yesu e sugua ilaba elö elöla nefolalebea ami nebegi, selesaia fii ilia e ugila negemolö misi. ");
INSERT INTO etr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yone galabaia negesebegi, Yesu e Galili awälahilä Godea Beaha Maadela Sigi Neebe amoïe Ado Mala Hedabi säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesuea sähalea, Godea segeyo daiala negei dilo amo, walio wegi gausiai ameada, Godea Beaha Maadela Sigi Neebe amoda ga madefalï dialeamelë. Ameada, dili asigi besula, Ado Mala Hedabi go gaula mogomalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu e Galili oeabo agesu nedaha nea beahamelebe, seme digilo dolö äudä, Saimono ïe edoo Ädulule seme digisa neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bealahilä Yesuea elema sähalea, Na alima udia dolö nelo mala oleledelä. Ali ne awäsewe gadola bëgëla misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Amala säsebegi, elea selëgë amo fodolofalï ami negesilahilä e bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu e holöbö sedade awälahilä beahamelebe, Sebediïe malö Yamese ïe edoo Yonele dudaia ami nea, selëgë nuli amo hamogisa neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Beala fodolofalï ele wesebegi, elele eedo Sebedige bidi nimolöïe hamoi hamosa nefolalo amolige dudaia amilahilä ele Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesula udia dolö odoali afiala Gabaniama gaamugi besela galai. Sabada gafe segeyo amo besela galasebegi, Yesu e gedolo mosöa ami nogila digalahilä, ea udia dolö amolima ado mala säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ea säla olelese amo nabala ili fudugisa sefolalo. Mida, mala dawadigi amolia olelelo amo gadola made, geloi hïdo elöi gaula nea olelese amogi. ");
INSERT INTO etr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Segeyo amo gala dolö mugabe fedai afädë gedolo mosöa ami maala sulo. Dolö amea üalala digila sähalea, ");
INSERT INTO etr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nasalese fii Yesu-o, nilï neebea wi dia edo hamomolö misi. Nilï nufudadigimolöïe misile. Nada di dawa. Dida dolö hedabi mogoifalï, Gode hï e neebea amila misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Amala säsebegi, Yesuea mugabe amoma nemosalea, Adomabu! Dolö go dïgïla di mosöla säi. ");
INSERT INTO etr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Amala säsebegi, mugabe amea dolö amo neala amulämelasilahilä üalala digila doadigila asi. ");
INSERT INTO etr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Amala hamosebegi, udia dolö sefolalo amoli sulubadela, fudugilahilä hilidomu säla didigahalea, Walio hamoi amoda edo gadoidu. Dolö goea walio ado säi amoda, ado gähe geloi hïdo elöi gelola säimelë. Ea ado säseda, mugabe ilia nabelo gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesuea hamoi amo udia dolö Galilimadi nefolalo amoli sulubadelaea fodolofalï nabala didigai. ");
INSERT INTO etr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuge Yamese Yonege ïe begela aulo odoa ilige gedolo mosöa amila Saimono Ädululea mosöa ami afiai. ");
INSERT INTO etr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonoïe udia amoïe eme domalo hëgïla oloi, imididaia adi dilo amo, ilia fodolofalï Yesuma säla ï. ");
INSERT INTO etr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Säla ïasebegi, Yesu e udia oloi dibea ami awälahilä, ea naabogi gaula nowela ifosi. Amala hamosebegi, e hëgïla oloi dilo amo hogosa helela wahisebegi ea ili molö muäia daiai. ");
INSERT INTO etr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eso digase gaalu, deadi udia dolö nefolalo amolia oloi difolalo amolige mugabe fedai nefolalo amolige sigi gagaula Yesu neebea ami gegedoi. ");
INSERT INTO etr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Udia dolö Gaamugi ami nefolalo amoli sulubadela idi galo mia hadaigi amimu gegedoi. ");
INSERT INTO etr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Amala hamosebegi, Yesuea udia dolö yafie olo elö elöla oloi difolalo amoli wahila digi, mugabe fedai yafie nefolalo amoli nesila digila digisa nelo. Amala hamosebegi, mugabe amolia Yesu eda gowe neala dawadigisa madei nefolalebegi, Yesuea mugabe amolima dilia adomabula säi. ");
INSERT INTO etr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sege yomolö amo gaalu Yesu e segea nowela awälahilä, udia dolö aligisia made ami awäla Godema adosa sulo. ");
INSERT INTO etr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimonoge ebalä nefolalo amoliage Yesu hogogola hobeala bëgëi. ");
INSERT INTO etr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Beagolelahilä ilia ema sähalea, udia dolö sulubadelaea di hogosa neamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Amala säla ïasebegi, Yesuea säla obëgësalea, Gamelä. Sege gaamu odoa ga made dibea ami, ado mala säla ïmolö afiadi. Neda hamoi amo hamomolö misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Amala sälahilä e Galili sege sulubadelamadi nawesa nea, ilile gedolo mosö nefolalebe amoligi nogila digalahilä, Yesuea ado mala säla ïadigi, mugabe fedai nefolalo amoli nesila digila digisa nelo. ");
INSERT INTO etr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Amala hamosa nebegi, dolö gudubu hamoi afädë Yesu neebea ami maalahilä, emo gumu sasagala fia idogola salea sähalea, Dia ne wahimäiala helësëseda, hä dia ne wahilasimolöi nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Amala säsebegi, Yesuea dolö amo bobasëlahilä, ïe naabo mogodigia gala, dolö amo diigisa nea sähalea, Na amala helësësa, wahimola säi. ");
INSERT INTO etr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Amala säsebegi, dolö gudubu hamoi amo fodolofalï hogosa helela wahi. ");
INSERT INTO etr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuea e fodolofalï mosalolahilä, ema gelola sähalea, ");
INSERT INTO etr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nabuö! Di wahi go oböla odoama säla ïmabio. Gobela ïlo dolö neebe amea di bimäia olemolö mosalo. Amalahilä, udia dolö ilia bimäia di wahi go olemolöïe, Mosesea säla negei dibe amo gadola, di hëmäia nelebo afädë odala ïmalo mosalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amala säla ï amo nabalahilä gaso, dolö amo awäha neada, ema hamoi amo ili sulubadelama säla ïïa awäha nelo. Amala säla ïïa awäha neala säi amo nabala, Yesu e ilile siigi gaamu difolalebea ami made awäla, udia dolö aligisia made ami gasi gala nelo. Amala gasi gala nebegi, udia dolö sege sulubadelagi nefolalo amoli Yesu neebea ami mafula gegedoi. ");
INSERT INTO etr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Segeyo odoa baagisebegi Yesu e bu Gabaniama obëgëi. Yesu obëgëla misi neala säi amo udia dolö nefolalo amoli sulubadelaea nabaha maadei. ");
INSERT INTO etr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nabalahilä udia dolö yafie Yesu neebea ami mafula gegedoi amea, mosö isogige idilibage fimolö fu maade, negegi dibegi, Yesuea ilima ado mala säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Säla ïaha nebegi, dolö afädë fii si sulo amo e neebea ami, dolö biyidiaea iwasala gaula misi. ");
INSERT INTO etr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Udia dolö yafie negegi amea, ilia dolö amo Yesu neebea gaula moholö ulï gabugi, mosö fïgïdaia gaula fedalahilä, mosö fïgï dusuia gala dolö iwasala gaula misi dafu amola mumusogi Yesu neebe amo gaalu salisi. ");
INSERT INTO etr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ilia asigi afädë negei nea hamosebe amo bealahilä, Yesuea dolö fii si amoma sähalea, Nïe malö, dia nafade hamoi amoli na hä hësa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amala säsebegi, mala dawadigi dolö odoa sefolalo amolia asigiamu helësësalea, ");
INSERT INTO etr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","dolö gowea ado egoweda abeahäla sähadu. Eada Gode gagadesa neamelë. Gode eamu udia dolöea nafade hamoi amoli hëmolöi neala helësësa sefolalo. ");
INSERT INTO etr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ilia amala helësësa sefolalebe amo, ïe asigia aabela beagolelahilä, ea ilima sähalea, Edoïe dilia go helësësa dialea. ");
INSERT INTO etr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na dolö fii si gowema ado aabei sämolöda abodo. Dia nafade hamoi amoli hësa maadeila sämolö amo aabei gabule, ma, di nowela dïe fëo gaula mosöla sämolö amo aabei gabule. ");
INSERT INTO etr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amaimo, Dolöïe Malöea nagadaiawi nea, udia dolöea nafade hamoi amoli hëla digimolöïe, geloi gaula neebe amo dilia helësëmäia olesagomelëla säi. Amala sälahilä ea dolö fii si amoma sähalea, ");
INSERT INTO etr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Na dima sähago. Di nowela dïe fëo neala gaula dihï mosöa mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Amala säsebegi, dolö amo nowelahilä, udia dolö sulubadelaïe sidaia ïe fëo amo neala gaula fodolofalï asi. Amala hamosebegi, ili sefolalo amoli sulubadelaea asigigi fudugilahilä, Godeïe ëi gauia adala sähalea, Siiba nelebo gowe gadoi hamose nilïa melëlo mademelëla säla didigai. ");
INSERT INTO etr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu e Galili oeabo agesu bu elö nedaha nebegi, udia dolö yafie e neebea ami mafula gegedoi. Gegedosebegi Yesuea ilima ado mala säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Säla ïaha nelolahilä awäha nea, Alibiasaïe malö Ilibai e dagisi muni nelo mosöa sebe amo bealahilä, Yesuea ema ne bëgëla misiëla säi. Amala säsebegi, e Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu e Ilibaia mosöa molö naha sulo. Dagisi nelo dolö yafiege, mala nafade hamolo dolö yafiege, Yesula ïe bëgëla aulo amolibalä gedola salea molö naha sefolalo. Dolö amo gadoi yafieada, Yesu awäse amo gadola bëgëla awähamu aligilo. ");
INSERT INTO etr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mala dawadigi Felesi dolö amolia beahamelebe, Yesu e dagisi muni neloge, mala nafade hamologe, nefolalo amolibalä gedola salea molö naha sebe melï. Bealahilä ilia Yesuïe bëgëla aulo amolima nabahalea, Mala nafade hamologe, dagisi muni nelo nefolalo amolige, ebalä, gedola salea molö naha sebegoda edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Amala nabasebegi Yesuea ilima säla obëgësalea, Udia dolö oloi made nefolalebe amolida, alögoda neebea aulo made. Oloi sefolalebe amolimu alögoda neebea aulo. Amo gadola wäla, ne misi weda, udia dolö hedabi nefolalebe amoli wemolö misi made, udia dolö nafade hamolo nefolalebe amoli wemolö misimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Segeyo molö naala made aligilo fu amogida, ödägi gelo Yoneïe bëgëla aulo amoliage Felesi dolö amoliage molö naala made aiala nefolalo. Udia dolö odoa maalahilä, Yesuma nabahalea, Yoneïe bëgëla aulo amoliage Felesi dolöïe bëgëla aulo amoliage molö made naala aligilo fu amogi, Dïe bëgëla aulo golia molö naha nebegoda mi edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Amala nabasebegi, Yesuea ilima säla obëgësalea, Dolö afädëa udia neahalea, udia dolö e damelë molö molö gedoi hï ebalä sefolalebe amolima, dili molö made naala aiala samialola samolöle. Udia nimolö dolö amo ilibalä seëda, ili molö made naala aiala samolöle. ");
INSERT INTO etr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gaso, hobeala dolö amo odoaea sigi gaula asibua, ili molö made naala aiala sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Amala sälahilä Yesuea ado elö sähalea, Afädëa fagulo goofogi fagulo gähea baala asogelo made. Amala hamoseda, fagulo gähe amea goofo amo nulimolömelë. Amalahilä dafidi nuli amo gadola made bu edela nulilo. ");
INSERT INTO etr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Amo gadolamu, dolö afädëa sugua meme gafodoea ödä i hamoi sibai amogida, wani ödä gähe dibe amo söga salelo mademelë. Amala hamoseda, wani ödä amea ödä i sugua meme gafodoea hamoi sibai amo dusulahilä, ödä i amoge wani ödä amoge, hä, nafademolömelë. Amala hamoloea, wani ödä gähe dibe amoda sugua meme gafodoea ödä i hamoi gähegi oselomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Segeyo Sabada gafegi Yesula ïe bëgëla aulolali, eladi gadoi ëi widi sagaido afiaha dilo. Afiaha dialea ïe bëgëla aulo amolia widi gägä amo faila nana awäha nelo. ");
INSERT INTO etr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nana awäha neebe amo Felesi dolö ilia bealahilä Yesuma sähalea, Nilïle mala säla negei dibe ameada, segeyo Sabada gafegi hamolo made amo dïe bëgëla aulo golia damula hamosa nebego bimola säi. ");
INSERT INTO etr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Amala säsebegi, Yesuea ilima säla obëgësalea, Siiba Debidia hamoi dëdëla negei dibe amo dilia made nidelo neale. Debidige, dolö odoa ebalä nefolalo amolige, molö maadela sïdëa baagosalea, ");
INSERT INTO etr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","gobela ïlo busa edefade Abiada e nebegi, Debidia Godeïe mosöa nogila digalahilä, beledi Godegali odala ï dilo amo neala mai. Beledi amoda odoaea nülo made, Gobela ïlo amoliamu nülo negei amo ea nalahilä, odoa ebalä nelo amoli muäia neala gaula awäla ïmelëla säi amo dilia made nidelo neale. ");
INSERT INTO etr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesuea ilima säla wagahalea sähalea, Godea segeyo Sabada gafe hamoi amoda, Udia dolö fifi asi sefolalebe amolia segeyo Sabada gafe amo ugila negemäia hamoi mademelë. Udia dolö fifi asi sefolalebe amoli ugila negemäia hamoimelë. ");
INSERT INTO etr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Amala hamoi ameada, Dolöïe Malö amoda, segeyo Sabada gafeïe Dafidilo neamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu e gedolo mosöa ami bu elö nogila digai. Mosöa amida dolö naabo elö amo balägädöla nafadei afädë sulo. ");
INSERT INTO etr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Udia dolö odoa sefolalo amolia Yesuma dia nafadela hamoila sämolölahilä, segeyo Sabada gafegi, Yesuea dolö amo wahisebelela bimolöïe, ilia si dadaiaha sefolalo. ");
INSERT INTO etr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Amaha sefolalebegi, Yesuea dolö naabo nafadei amoma sähalea, Di nowela mogogi namolö misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Amala sälahilä ea ilima nabahalea, Nilïa segeyo Sabada gafegi hedabi hamomolö amo dofeale ma, nafade hamomolö amo dofeale. Udia dolö hedabola namiäia damula moholö amo dofeale ma, baagomäia nufulö amo dofealela nabi. Amala nabasebegi, ilia säla obëgëla made sefolalo. ");
INSERT INTO etr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuea udia dolö sefolalo amoli sidawewela bealahilä e mihaläi. Mida. Ilile iso asigi geloi dibe amo beala. Mihalälahilä ea dolö naabo nafadei amoma sähalea, Dïe naabo mogodigia gamola säi. Dolö amea naabo mogodigia gai amole, ïe naabo amo wahimolöi wahi melï. ");
INSERT INTO etr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Amala hamosebe amo bealahilä, Felesi dolö sefolalo amoli segea fodolofalï doadigila awäla, Heledo sosogo nefolalo amolibalä gegedolahilä, Yesu baagomäia abilia hamomolödula säla didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesula ïe bëgëla aulola ili sege ili neloa amo fisila, Galili oeabo dibea ami afiai. Ili afiasebe amo gadola udia dolö yafiea ili bëgëla afiai. Sege Yudialage, gaamu Yalusalemelage, sege Idumialage, ödä Yodona dëgëla alämadilage, gaamu Daiamadilage, Saidonomadilage, sege amoligila udia dolö sämolö asusugai yafiea, Yesuea hamoi amo nabala e bëgëla afialahilä, e neebea amimu gegedoi. ");
INSERT INTO etr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Amala gegedosebegi Yesuea ïe bëgëla aulo amolima sähalea, Udia dolö yafie gegedosalea, ne dedelela fëdösebe amea, bobadëlasebegi, ne dudaia fedadelä, dilia du afädë gaula maala ne neebe gaalu, ga madela negesimola säi. ");
INSERT INTO etr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ea udia dolö yafie dafidi wahilasi amo gadola, udia dolö oloi sefolalo amoliage ili wahilasimäialahilä, ilia e digimolöïe gegedoi amea dedelei. ");
INSERT INTO etr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mugabe amolia e beala ïe emo mia gumusula dia digalahilä, üalala digila sähalea, Dida Godeïe malömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amala säsebegi, ea mugabe amolima gelola sähalea, Odoama ne Godeïe malö neala säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu e segebidaia fedalahilä, dolö odoa hï hamei amoli misiäia wesebegi, ili e neebea ami misi. ");
INSERT INTO etr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Maasebegi ea dolö giwilasi amoli ebalä namolöïe ili memelelahilä, ea ilile ëi abosolo negei. Ilia Godeïe ado mala säla ïmolö mosäiage, mugabe fedai nesila digimolö geloi iligali ïmolöïege, ea ili memelei. ");
INSERT INTO etr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Giwilasi memelei amolile ëida gowe ili. Saimono, Yesuea ïe ëi elö Fida negei amoge, ");
INSERT INTO etr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebediïe malö Yamesege, ïe edoo Yonege, Yesuea elele ëi elö Boaneyisi negei. Nilïle ado sälada sege gudusebeïe malö. ");
INSERT INTO etr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Äduluge, Filibige, Badolomiuge, Madiuge, Domasage, Alibiasaïe malö Yamesege, Dadiusige, Selodo sosogo Saimonoge, ");
INSERT INTO etr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudasa Isagaliada, Yesu hololölo amoge. Yesuea giwilasi amoli memelei. ");
INSERT INTO etr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Memelesa maadelahilä, Yesu e mosöa asi. Udia dolö yafie bu gegedoi amea, Yesula ïe bëgëla aulo amolali molö molö fu maade melï. ");
INSERT INTO etr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Amala hamoimelëla säi amo nabalahilä, Yesu sosogo nefolalo amolia e bea asi. Mida, odoa ilia e gagaosa neala säi amo nabala. ");
INSERT INTO etr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mala dawadigi dolö Yalusalemela digafui amolia sähalea, Mugabe Belesabuluda Yesuma fedai nea. Mugabe ilile busaea ema geloi ïasegi, ea mugabe nesila digisa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Amala säsebegi, Yesuea ili mofiamolahilä, ilima ado besula sähalea, Mugabe Saidani hïmuda abilia nesila digimolöi gabu. ");
INSERT INTO etr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sege afädëgi fii hilimu mogela nuduseda, fii amoda geloi made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mosö afädëgi fii hilimu mogela nuduseda, mosö amoda gelola namolö mademelë. ");
INSERT INTO etr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mugabe Saidania hïmu ado nease amea, e sosogo neebe amoli mogeseda, amoda gelola made aligila, hogosa helesa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Afädëa dolö geloi neebe amoïe mosöa ïe nelegei dibe amo fa nimolö moholöi mademelë. Ea dolö geloi amo dafidi naabo emoge, nafodola negesiä ïe mosöa nelegei dibe amo fa nimolö moholöi galea. ");
INSERT INTO etr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na dilima dofä gelola sähago. Udia dolöea nafade hamoi amoli sulubadelage, gagadela ado nafade elö elöla säi amolige, hëla fisimolöi bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Be afädëa Eleloi Gesami gagadeseda, made hëmolö. Ïe nafade hamoi amoda, walioge hobealage, hï ebalä diamolöi diamolömelëla, Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ilia Yesu e mugabe fedai neala säi amo nabala ea ado amo amala säi. ");
INSERT INTO etr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Segeyo amo gala, Yesuïe eme edoolali mafula segea ifo baagido nea, odoa ilima sähalea, Yesu e nilï neebeawi misialasebela sämola säi. ");
INSERT INTO etr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Amala säsebegi, udia dolö yafie Yesu amalela sefolalo amolia ema sähalea, Nabahale. Dïe dieme didoo dialifilali misi segea nea. Ilia di misialala säsebela säi. ");
INSERT INTO etr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Amala säsebegi, ea säla obëgësalea, Nïe neme nedoolalida nowë ili gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ea e amalela sefolalebe amoli sidawewela bealahilä ilima sähalea, Bimo. Neme nedoolalida sefolalebe gowe ilimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Udia dolö, Godea hamese amo gadola hamolo nefolalebe amolida, nedooge nalifige nemege amoli neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu e Galili oeabo agesua nea, udia dolöma ado mala bu säla olelesa nelo. Udia dolö yafie gegedoi amea negegisebegi, Yesu e ödä daia du dilo, amogi fila fedai. Udia dolö yafie gedoi amolida agesua ami nefolalo. ");
INSERT INTO etr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Amala nefolalebegi, Yesuea ilima säla olelesalea, ado besu yafie säi amoda gowe. ");
INSERT INTO etr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nabuö! Dolö afädëa sagaido gägä fëfëla aligi asi. ");
INSERT INTO etr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sadia gogola aligi awäha nebegi, gägä odoa idiafa daala negei amo haea maala, neala naha maadei. ");
INSERT INTO etr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gägä odoa igi naga abelëidaia daala negelahilä, gägä amea naga abelëi amodaia fodolofalï bäui. ");
INSERT INTO etr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bäui gaso, eso neëa hëgïsalea difi moholö asusugala ödölola bausoi. ");
INSERT INTO etr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amase, gägä odoa äyo gägäi neebea ami digai. Amoda äyo gägäi amobalä gegedola bäui amea, widi gägä amo yau hahalea gägä made negei. ");
INSERT INTO etr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gägä odoa naga hedabi dibea ami daala negei ameada, hedabola bäulahilä gägä negeimelë. Odoaeada gägä nabülasi ohodoa negei. Odoaeada nabülasi gafeia negei. Odoaeada nabülasi emu nabülasi negeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Amala sälahilä Yesuea säla wagala sähalea, Dili gëhe galea galëda nabuöla säi. ");
INSERT INTO etr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Udia dolö yafie afiaha maadeibua e bëgëla aulo giwilasi amola, udia dolö odoa Yesubalä nefolalo amola ilia, ea ado besula säi amoïe mi nabi. ");
INSERT INTO etr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Amala nabasebegi, Yesuea ilima säla obëgësalea, Godea Beaha Maadela Sigi Neebe amo helësëmolöda, dafidi ulufadigila made musügä negei dilo amo, dilia helësëmäia säla ï amomelë. Be udia dolö segea nefolalebe amolima ado besulamu säla ïaha neebeweïe ");
INSERT INTO etr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mida. Ilia siia beahamu nea gaso, dofä gowe gabula made beagolemolömelë. Ilia gëhea nabahamu nea gaso, asigia mi gowe gabula made helësëmolömelë. Ilia beagolela helësësa galebeda, ili asigi besusa maadesegi ilia nafade hamoi amo Godea hësa maadelabiomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuea ïe bëgëla aulo amolima sähalea, Ado besu säi amoïe mi fädäla made helësëi neale. Made helësëi nea galëda, ado besu odoa säse amo sulubadela abilia helësëmolö gabu. ");
INSERT INTO etr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dolö amea hawa fëfëi amo gadolada, Ado Mala fëfëlo dolö nea. ");
INSERT INTO etr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ado mala idiafa digai amo gadoida, udia dolö odoaea ado mala nabasebegi, Godea ilile isogi ado mala sagasi amo, mugabe Saidani maala fodolofalï neala gaula aulo nea. ");
INSERT INTO etr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amase, udia dolö odoa widi gägä igi naga abelëidaia digai amo gadoi neebe amoliada, ado mala obeägïla nabalahilä fodolofalï neala gaulo. ");
INSERT INTO etr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gaso, ili difi moholö ulïsalea sedade made aligilo. Amalahilä ilia ado mala neala gaui amoïe yöi beasege, odoaea ili neala sëlasisege, ilia fodolofalï dïgïla aulo nea. ");
INSERT INTO etr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Udia dolö odoa giisi äyo gägäi damui fedaha dibea daala negei amo gadoi neebe amoliada, ado mala nabalahilä gaso, ");
INSERT INTO etr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ilia nagadaia galu difolalebe amoligi säosäolahilä, muni edefade negemolöila helësëla, nelebo elö elöla gesami awäla helësëse amea, ado mala nabi amo yau hahalea gägä negelo made nea. ");
INSERT INTO etr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gaso, naga hedabia molö gägä daala negei amo gadoi udia dolö neebe amoliada, ado mala nabala asigi afädë negela neala gaulahilä, ilia gägä nabülasi ohodoa negela digi, nabülasi gafeia negela digi, nabülasi emu nabülasi negela digilo neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Amala sälahilä Yesuea ïe bëgëla aulo amolima sähalea, Afädëa gamali yola sagaseda, faloea dabelole ma, imidi hawa negelole. Ai, amala made hamolo, aulidaia negelomelë. ");
INSERT INTO etr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nelebo musügä negei dibe amoda hobeala ulufadigisa maadela, udia dolöea nelebo dabela negei difolalebe amolida hobeala yo digai dibea ami ulufadigisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Afädë di gëhe galea galëda, nabualola säi. ");
INSERT INTO etr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ea ilima aso sähamu neamu sähalea, Ado dilia nabi amoda hedabola helësëmalo. Dilia odoagali mogela ïaseda, Godeage amo gadola wäla diligali mogela ïahalea, odoage baala ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Afädëa nelebo afädë gaula neebe amomada Godea odoa baala yafie ïmolömelë. Afädëa nelebo afädë made gaula nea, holöfalï gaula neebe amo dofea gaula neala neebe amolida, Gode hï fedela nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuea ado aso sähamu nea sähalea, Godea Beaha Maadela Sigi Neebe amoda gowe gadoi dialea. Dolö afädëa sagaido hawa fëfëla aligi awäha nelolahilä, ");
INSERT INTO etr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","gasi sulubadelagi dolö amo diala, yose nowela afu mafusa neë gaalu, hawa fëfëi amo duulu besela galala bäuse amoda gomalä bäusebela dolö amo hïda dawa made aligilo. ");
INSERT INTO etr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nagaea bäulasila gägä negelo. Dafidida bäudale bäulo. Hobeala mumusu negelahilä, gägä hï e negelomelë. ");
INSERT INTO etr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Molö sagai amo nimolöi galëda, dolö amo hï helebe guagei amea damulo. Mida, molö mumului nimolö segeyo besela galai amea. ");
INSERT INTO etr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuea aso sähamu nea sähalea, Godea Beaha Maadela Sigi Neebe amo, nilïa abodo gadoila sämolödu. Ado besula nilïa abodo gadoima oodo beala sämolödu. ");
INSERT INTO etr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Amoda masada gägä gadoi. Gägä odoa gadoi made. Gägä amoda holöfalïfalï. Ilia amo sagaia sagalomelë. ");
INSERT INTO etr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ilia sagai amo fedala edefadela aligiseda, dägöala sagai odoa amo baagila awäla bäulomelë. Ïe adomo edefade bafui amogida, haea mafula bäu augi hawa ami mosö olelomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Udia dolö amolile asigia helësëmolöi galëda, helësëmäia. Yesuea ado mala säla ïahaleada, ado besula yafie säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ea udia dolöma Ado Mala säla ïahaleada, ulufala made säla ïala, ado besula säla ïaha nelo. Ïe bëgëla aulolali hilidomu neada, ea ado besu säla ïlo amoïe mi sulubadela ilima säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Segeyo amo gala deadi eso digase amo gaalu, Yesuea ïe bëgëla aulo amolima sähalea, Oeabo edefade goïe agesu alogodigogi afiadila säi. ");
INSERT INTO etr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Amala sälahilä udia dolö yafie nefolalo amoli amilahilä, ili Yesu sulo du amodaia fila fedalahilä, eege hiligila fila afiai. Du odoage ili awäse amo bëgëla hobeala afiai. ");
INSERT INTO etr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Afiaha dibegi, fo edefade gelola guula maalahilä, oeabo bubolela aidagula dudaia häila digala, du nobamolö hamose melï. ");
INSERT INTO etr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Amala hamose amo gaalu, Yesu eda du bidigi busa fugulo negela adi dilo. Amala adi dibegi ilia e didiigisalea sähalea, Säla Olelelo-o, di nowemo. Nilï baagodelä hamosebe gowegi di holöfalï fudugila made dialealela säi. ");
INSERT INTO etr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Amala säsebegi, Yesu e nowelahilä foma nemolahilä ödäma sähalea, Aeala aumamo. Fologomabula säi. Amala säi amole fo gelola guula misi amo boogelela ödä aidagula fedai amoge aumalasi. ");
INSERT INTO etr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ea ïe bëgëla aulo ilima nabahalea, Edogi bedäha dialea. Dili Godema asigi afädë negei made nealela nabi. ");
INSERT INTO etr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Amala usila aumase amo beala, ili edefademalä bedälahilä hilidomu sähalea, Folea ödäleada ïe ado nabelo gabu. Dolö weda nowëdula säha difolalo. ");
INSERT INTO etr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesula ïe bëgëla aulola ili Galili oeabo agesu näiado alömodi awäla Gelasa fii mosöa besela galai. ");
INSERT INTO etr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesuea ödä du ami negesiä awäha nebegi, dolö mugabe fedai afädë baagoi igi äbägi bausidola maaha nebegi gausiala digai. ");
INSERT INTO etr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dolö amoda baagoi bausia amimu diaha aligilo. Dolö afädëa ïe naabo emoge igi ëfëa gaula nafodomolöi made nelo. ");
INSERT INTO etr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Segeyo yafiegi ilia ïe naabo emoge igi ëfëa nafodosamu aligilo. Gaso, igi ëfë amo ea hësäla digisamu aligilo nelo. Geloi hïdo elöi amoda dolö afädëa e gaumolöi made nelo. ");
INSERT INTO etr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dolö amoda gasi esoage baagoi bausiale segebidaialemu nawesa aligilo. Ea üalala gaula nawesamu neada, hïle domalo igia dagabosamu aligilo. ");
INSERT INTO etr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Amala hamosamu aligilo amo, Yesu e aso wagadi made maaha neebe amo beala, e baluluia awälahilä Yesuïe emo mia gumusula dia digai. ");
INSERT INTO etr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gumusula dialea gelola üalala sähalea, Gode Dofä Ilibia Edefade neebe amoïe malö Yesu, dia nema abilia hamomolöïe misi. Na dima Godeïe ëi nabasewegida dia ne së ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ea amala gelola säi amoïe mida, Yesuea ema dida mugabe, dia dolö go dïgïla mosöla säsebegi amala säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesuea ema nabahalea, Dïe ëida nowëla nabi. Ea säla obëgësalea, Nïe ëida Malei. Nilïda holöfalï made, maleimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Amala sälahilä ea Yesuma gelolafalï sähalea, Segeweda dïgïla mosöla sämabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Amo gaalu amida sugua yafie gau domala ami moosa nefolalo. ");
INSERT INTO etr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mugabe amolia Yesuma gelolafalï sähalea, Nilï sugua nefolalebe gagowelima fedala namolö mosöla sämola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesuea amala hamomola säsebegi, dolö amo dïgïla mugabe amoli sugua nefolalo amolima fedai. Amala nogila fedala gau mogobogi amogi baluluia didigafula ödägi nogila digaha maadelahilä, sulubadela ödäea naha maadei. Sugua amoli gedolada dausini äudä gadoi ödäea mai. ");
INSERT INTO etr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Amala hamose amo beala sugua sigi aligilo amoli fisäla awälahilä, gaamu dibea amige mosö gägäwila asi dibea amige säsäla awäha nelo. Säi amo nabalahilä udia dolö nefolalo amolia abilia gelola hamoi walebelela fädäla bea afiai. ");
INSERT INTO etr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ili Yesu neebea afialahilä beahamelebe, dolö dafidi mugabe yafie fedai nelo amo fagulo salugalahilä, e asigi hedabi negei sebe amo beala ili bedäi. ");
INSERT INTO etr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Udia dolö Yesuea hamose melëlo amolia, udia dolö misi nefolalebe amea nabuäia dolö amoma mugabe yafie fedai nesila digi amoge, sugua ödäea mai amoge ilima säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Amala säla ïasebegi, ilia Yesuma gelola sähalea, Dida nilïle segea wi namolö mademelë. Näiadodi namolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Amala säsebegi Yesu e dudaia fimolö awäha nebegi, dolö mugabe yafie fedai dafidi nesila digi amea, Yesuma nabahalea, Di awäsebe go gadola ne mudulela nabi. ");
INSERT INTO etr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amala nabasebegi, Yesuea dolö amoma säla obëgësalea, Nebalä moholö made. Dafidilo Geloia dima hamoi amoïege bobasëi amoïege dïe sosogoma säla ïmolö dihï mosöa mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Amala säsebegi, dolö amea Gaamu nabülasi difolalebe amo sulubadelagi awälahilä, Yesuea ema hamoi amo udia dolö nefolalo amolima säla ïasebegi, ilile asigia fudugisa maadei. ");
INSERT INTO etr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu e dudaia fila Galili oeabo bu dëgëla obëgëla awäla agesua nebegi, udia dolö yafie mafula ea ado säse amo nabulö gegedoi. ");
INSERT INTO etr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Amase amo gaalu, gedolo mosö beaha aligilo afädë misi, amoïe ëida Yalusi. Ea Yesu beagolelahilä ïe emo mia gumusula dia idogolahilä ");
INSERT INTO etr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yesuma gelola sähalea, Nïe nidiwi holöböda baagomolö ga madefalï dialea. Dia dofä naaboea diigisegi made baagola wahimäia awähadula säi. ");
INSERT INTO etr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Amala säsebegi, ebalä asi. Udia dolö yafie nefolalo amoliage e bëgëla afiahalea negegila dedelela aligi afiaha dilo. ");
INSERT INTO etr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Afiase amo gadola udia afädë gäheo i nabülasi afädëïe odoai äudä heale olo olosamu aligilo amoge asi. ");
INSERT INTO etr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Udia ameada e wahimäiala alögoda yafie neebea ami awähamu aligilo. Gaso, ea së edefade melï. Ea alögoda iligali muni ïahamu aligilo. Gaso, ïe olo amo made wahila edesa aligilo. ");
INSERT INTO etr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Amala hamoi salea, ea Yesuea hamolo sedalu säi amo nabalahilä, udia dolö Yesu bëgëla afiase amolibalä awälahilä e baagido maala ïe fagulogi diigi. ");
INSERT INTO etr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ea hïdo asigiamu helësësalea, na ïe fagulogi diigiseda, neda wahimolöla helësëi. ");
INSERT INTO etr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ea Yesuïe fagulogi diigi amole, heale olo oloi amo hogosa helela, e fodolofalï wahi gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuea ïe wahilo geloi awäse amo helësëlahilä, besula nea nabahalea, Nïe fagulogi diigi amo nowëala nabi. ");
INSERT INTO etr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Amala nabasebegi, ïe bëgëla aulo amolia ema sähalea, Dibalä udia dolö yafie dedelela aligi afiaha dibewe dia beasegoda, ne nowëa diigila edoïe nabahala säi. ");
INSERT INTO etr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amala säse amo gaalu, e nowëa digisa walebelela sidawewela hogoi. ");
INSERT INTO etr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Udia amea ema hamoi amo helësëla emo gigisëla bedäla, Yesu mia ga madela gumusula dia idogolahilä, Ema hamoi amo sulubadela säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Säla ïasebegi Yesuea ema sähalea, Nïe nidiwi-e, dia nema asigi afädë negei amea di hä wahigomelë. Olo amea dima bu elö made baamolömelë, dalulo gaula mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuea säha nebegimu gedolo mosö beaha aligilo Yalusiïe mosöala dolö odoa misi. Maalahilä ilia ema sähalea, Dïe didiwi amoda hä baagoi dialea. Säla olelelo goma yöi ïase goda edoïela säi. ");
INSERT INTO etr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ilia amala säsebegi, Yesuea auaulahilä gedolo mosö beaha aligilo amoma sähalea, Dia bedämabu. Godema asigi afädë negemalola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Amala sälahilä udia dolö odoa nefolalo amolima dili misiabiola sälahilä, Fida Yamese ïe edoo Yonela ohodoa ilimu ebalä asi. ");
INSERT INTO etr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gedolo mosö beaha aligilo amoïe mosöa malïgahamelebe, udia dolö yafie gegedolahilä didigaosalea goba fedaha dibe melï. ");
INSERT INTO etr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Beala e mumusogi nogila digalahilä ea ilima sähalea, Dilia goda edogi didigaola goba fedaha dialea. Udia malö goda baagoi made, süwia adi dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amala säsebegi, ilia Yesubalä ösa sefolalo. Amasebegi, ea ili sulubadela segea nesila digilahilä, udia malö amoïe eedo emelela ïe bëgëla aulo ohodoa amolali udia malö dusugala negei hogoli amogi nogila digai. ");
INSERT INTO etr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuea udia malö amoïe naabogi gaula nabeleia wesalea, Dalida gumi. Nilïle ado adolada, Udia malö holöbö, na dima säha. Di hä nowemola säi. ");
INSERT INTO etr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Amala säi amole udia malö amo fodolofalï nowela asi. Amala hamose amo beala, udia dolö nefolalo amoli edefademalä fudugila bedäi. Udia malö amoïe gäheo ida nabülasi afädëïe odoai äudä. ");
INSERT INTO etr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuea ilima gelolafalï sähalea, Na walio hamoi amoda udia dolö odoama säla ïmabiola säi. Amala sälahilä, Ea ilima udia malö holöbö go molö muäia ïmola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuea sege amo dïgïla ïe bëgëla aulolali hï e ëdëla aligi segea ami bu obëgëi. ");
INSERT INTO etr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Segeyo Sabada gafegi Yesu e gedolo mosöa ami awälahilä, udia dolöma ado mala olelesa nelo. Udia dolö yafie ea ado mala säse nabaha sefolalo amoli asigigi fudugilahilä sähalea, Dolö goea ado goweda, abidi niidu. Ema dawa edefade dibe goweda, dawa edo gadoidu. Ea melëlo made gadoige hamomolöi made gadoige hamose weda edodu. ");
INSERT INTO etr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nilïa helësësa, dolö egoweda mosö olelo. Meliïe malö madele. Eda Yamese Yosese Yudasa Saimonola ilile edoo nea madele. Ïe elefila ilida nilïbalä wi sebe amodala säi. Ilia amala sälahilä, ema bimolö habobala hamei made nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Amasebegi, Yesuea ilima sähalea, Udia dolö fifi asi sulubadelaeada, bea säloïe ado nabaha. Gaso, hïle segea fii, hïle sosogofalï iliage, hïle mosöa fii iliage, ïe ado nabelo made gabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Segea ami dolöea hamomolöi made gadoige melëlo made gadoige ea hamomolöi made gabugi, udia dolö oloi afädë afädëlamu naaboea diigila wahisa nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Amala hamose amo beala ilia ema asigi afädë made negesebegi Yesu e fudugisa nelo. Amasebegi, ea Nasalese sege amo fisila udia dolö fii odoa ilima ado mala olelela aligi nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuea ïe bëgëla aulo giwilasi amoli wela gegedosebegi. Ea ili äudä äudäla afufumalola sälahilä, udia dolö mugabe fedai nefolalebe amoli nesila digamäia ea ilima geloi ï. ");
INSERT INTO etr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ea ilima sähalea, Dili afiahalea galiamomu gaula mosalo. Nelegei odoa gaula mosabio. Molöge aduge muni salelogi salala gaula mosabio. ");
INSERT INTO etr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Emo usililo salugamalo. Fagulo äudä salugamabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ea ilima aso sähamu nea sähalea, Dili awäla sege afädëgi besela galala mosö afädëgi nogila digaseda, mosö amogimu nelolahilä dilia sege amo dïgïla awäsolo amo gala giso mosö amo hä fisimalo. ");
INSERT INTO etr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Amase, sege odoagi besela galasegi, ami fii amolia mosö fu made ïala, dilia säse amoge made nabaseda, sege amo hä dïgïla mosalo. Dïgïla awähaleada, dilile emogi dao baai amo fëfëla salalahilä mosalo. Amala hamoseda, ilia helësësalea, nilïa asiala hamoi amea amala hamosebela helësëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amala säi amo nabala ili afialahilä, udia dolö ilima sähalea, dili asigi besumalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ilia amala säla ïalahilä, udia dolö yafie mugabe fedai nefolalo amoli nesila digila digi. Udia dolö oloi yafie difolalo amolige ilia weli söga negesebegi, wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Udia dolöea Yesuïe ëi säsäi asi ameada beaha aligilo Gini Heledoea nabi. Odoaea sähalea, Ödägi gelo Yone dafidi baagoi amo bu nowelahilä obëgëla misi nea, geloi melëlo made gadoi hamosa neamelëla säha dilo. ");
INSERT INTO etr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Odoaea sähaleada, Eda Elaia gabu. Amase, odoaea sähalea, Eda bea sälo siiba nelo amo gadoi gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heledoea ado amo nabalahilä sähalea, Yoneda na muugi damui amo bu obëgëla maala neebe gadoi gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Helodiasa eda dafidi Heledoïe edoo Filibiïe udia sulo amo hobeala Heledoea fedela nii. Amala hamosebegi, Yonea Heledoma sähalea, Dia didooïe udia fedela neala dibalä sebego dofea made hamoimelëla säi. Amala säsebegi, Heledoea ami dolö nefolalo amolima sähalea, Yone gaumolö mosalola säi. Amalebe ilia e igi ëfëa nafodolahilä galabaia mosöa negei. Heledoea ïe udia Helodiasa obeägïmäia amala hamoi. ");
INSERT INTO etr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ïe udia Helodiasaea Yonema habobalahilä, e baagomäia abilia nufulödula helësësa sulo. Gaso, nufulö fu made melï. ");
INSERT INTO etr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mida, Heledo eada Yone eda dolö hedabi, Godeïe siigi asigi mogoi neala helësëla bedälahilä, eada Yone idihë nelo. Ea Yonea ado säse nabala obeägïlo ameada e asigi säosäola helësësa nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heledo e ägüla misi segeyo besela galasebegi, gamane beaha aligilo nefolalo amolimage, ami beaha aligilo nefolalo amolimage, Galili segeïe dafidilo nefolalo amolimage ea sähalea, Molö molö gegedomalola säi. Molö giasolo amo galada Helodiasaea Yone nufulö fu beagolei. ");
INSERT INTO etr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Segeyo amo gala ili molö naha dibegi udia malö Helodiasaïe idiwi maalahilä sigoi. Heledoeage dolö odoa ebalä molö naha sefolalo amoliage, ea sigoi amogi hïdo elöla obeägï. Hïdo elöla obeägïsebegi, ginia dolïsä amoma sähalea, Sigosegoïe nelebo afädë ïmose amo gadoi ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ea naabo migalïa diigila dolïsä amoma sähalea, Nelebo afädë ïmoseda, na sege edefade beaha neebe amogi mogogi nofela ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Amala säsebegi, dolïsä amo segea doadigila awälahilä emema nabahalea, Ne edo ïmola sämolödula nabi. Amala nabasebegi, emea sähalea, Ödägi gelo Yoneïe busa damula ïmola sämalola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Amala säsebegi, dolïsä amo fodolofalï baluluia obëgëla awälahilä Ginima sähalea, Ödägi gelo Yoneïe busa damula falodaia gaula maala walio ïmäia hamesamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Amala säi amo nabalahilä ginia edefademalä bobasëi. Gaso, dolö molö naha sefolalo amoli sidaia migalïa diigila ado gelola säi ameada, fisimola sämolö ulï gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Amala helësëlahilä ea fodolofalï ami afädëma sähalea, Yoneïe busa damula gaula obëgëmolö mosöla säi. Amala säsebegi, ea galabaia mosöa awälahilä Yoneïe busa damui. ");
INSERT INTO etr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Damulahilä falodaia negela gaula maalahilä dolïsä amoma ï. Ïasebegi, dolïsä ameada emema ï. ");
INSERT INTO etr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Amala hamoimelëla säi amo nabalahilä ïe bëgëla aulo amolia ïe domalo neala gaula awäla igi äbägi bausi. ");
INSERT INTO etr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Abosolo dolö amoli Yesu neebea obëgëla maalahilä, ilia hamoi amoge mala olelei amoge sulubadela ema säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Udia dolö afu mafusalea ili molö molö fu made beasebegi, Yesuea ilima sähalea, Nilï udia dolö madeido hele fimolö afiadila säi. ");
INSERT INTO etr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Amala sälahilä ili hilido ödä dudaia fifigila udia dolö madeido afiai. ");
INSERT INTO etr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ili afiaha dibegi, udia dolö yafiea bealahilä ili hä afiaha gabula helësëi. Amala helësëlahilä ili gaamu elögi elögila nagadabodo baluluia afialahilä ili moholö afiasebea ami dafidi ilidale awäla besela galai. ");
INSERT INTO etr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ili awäla ödä agesua besela galahamelebe, udia dolö yafie nefolalebe melï. Bealahilä ea ili edefademalä bobasëi. Mida, Ili sugua sibi sigi aligilo maadesalea, hilido aligilo amo gadoi neebe amo beala. Amalebe ea ilima ado mala yafie säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Segeyo amo gala deadisebegi, ïe bëgëla aulo amolia e neebea maalahilä ema sähalea, Sege udia dolö maadeia wimu nebegi hä deadisebegi. ");
INSERT INTO etr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dia udia dolö nefolalebe gowe ili mosalala sämo. Afialahilä hili molö bidia nimolö sagai mosö dibea amige gaamu holöfalï dibea amige hogogola mosäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amala säsebegi, ea ïe bëgëla aulo amolima säla obëgësalea, Ili molö muäia dilia ïmalola säi. Amala säsebegi, ilia ema säla obëgësalea, Muni gina hädali äudäea ili beledi muäia neala ïmolö afiadulela nabi. ");
INSERT INTO etr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ea ilima nabahalea, Dilia beledi aboläia ägüi walebelela bimolö mosalola säi. Beala maalahilä ilia ema sähalea, Nilïada beledi bia seme äudä amolemu ägülubela säi. ");
INSERT INTO etr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Amala säsebegi, ea ilima sähalea, Udia dolö sulubadela gegedolahilä, giisi hedabidaia, nudulu hamola fifigimalamalola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Amala säsebe amo gadola säsebegi, odoada hädali afädë, odoada nabülasi bia gadoi nudulu hamola fifigi. ");
INSERT INTO etr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Amala fifigi dibegi ea beledi bia amoge seme äudä amoge naaboea gaula nea, Selesaia mosöa sida adogola nea, Godema nesegelahilä, ïe bëgëla aulo amolia udia dolö amoligali sogomäia beledi dagabodasila ï. Amalahilä ea seme äudä amoge dagabodasila, ili sulubadelagali sogomalai. ");
INSERT INTO etr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sogoi amo, sefolalo amoli hulu sulubadela naha maadei. ");
INSERT INTO etr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naala bolesalea, beledige semege fea digai amo bëgëla aulo amolia neala gedolahilä, adu giwilasigi salala nobai. ");
INSERT INTO etr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Beledi seme naha sefolalo amoli dolömuda dausini bia sulo. ");
INSERT INTO etr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesuea ïe bëgëla aulo amoli fodolofalï mosalolahilä sähalea, dafidi dilidale ödä dudaia fifigila oeabo go dëgëla alogodi sege ëi Bedesaida mosalola säi. Amala sälahilä udia dolö gegedoi amolima sähalea, Dilige dihili mosöa dusula afiamalola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ili sulubadela dili hawio afiamalolahilä, eda Godema adomolöïe segebidaia ami fedai. ");
INSERT INTO etr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ïe bëgëla aulo amoli dudaia fifigila asi amo oeabo mogogi gasise amo gaalu, segea amida Yesu e hïdo nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu e ami nea beahamelebe, du busamadila fo gelola maase amea, ödä adelo i amea ilia gelola adimolö ulïse melï. Haea gämolö amo gaalu, Yesu e ödädabodo ili neebea ami moholö asi. Ea ili baagila moholö awäse ");
INSERT INTO etr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","amo gaalu, ilia e ödädabodo maase amo beala, mugabeledula helësëlahilä üalai. ");
INSERT INTO etr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ili sulubadelaea beala edefademalä bedäsebe amo bealahilä, Ea ilima fodolofalï sähalea, Asigi hä gelomalo. Weda nemelë. Bedämabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E maala ilibalä dudaia fii amole fo made maala boogelei. Amala hamosebegi, ilile asigigi edefademalä fudugi. ");
INSERT INTO etr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iliada ea udia dolöea muäia beledi ï amoïe mida fädäla made helësëi nelo. Ilile iso asigi gai nelo. ");
INSERT INTO etr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesula ïe bëgëla aulola ili oeabo amo dëgëla alämadi sege ëi Genesaledi besela galalahilä ödä du amo ëfëa begela agesua ami negesi. ");
INSERT INTO etr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Du negesiä maaha neebe amo udia dolö nefolalo amolia bealahilä, hä Yesu gabula aabela helësëi. ");
INSERT INTO etr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Amala helësëlahilä ili sege dibe amo sulubadelagi fodolofalï baluluia afufulahilä udia dolö ilima säla ïaha maadei. Udia dolö Yesu misi neala säi nabi amoliada, oloi difolalo amoli iwasala gaula Yesu neebea ami misi. ");
INSERT INTO etr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sege dibe sulubadelagige gaamu dibe sulubadelagige, mosö dibe sulubadelagige Yesu e awäla besela galasebea amida, udia dolö nefolalo amolia oloi difolalo amo gaula mafula magaia gaamugi negesisi. Negesiä ilia Yesuma gelola sähalea, Oloi gowe ilia dïe fagulo bidigimu diigimäiamelëla säi. Oloi amoli sulubadelaea amala diigisebegi, wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Felesi dolöge, mala dawadigi dolö odoa Yalusalemela misi amolali gegedolahilä ili Yesu neebea ami afiai. ");
INSERT INTO etr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ilia beahamelebe ïe bëgëla aulo odoaea naabo nigime hëla made molö naha sefolalebe amo melï. ");
INSERT INTO etr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Felesi dolö iliage, Yu udia dolö sulubadelaeage, mäu ilia aialo mala negei amo helësëlahilä naabo nigime made hëla molö nülo made nelo. ");
INSERT INTO etr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ili magaia gaamugi awäla, obëgëla maalahilä, nigime made hëla molö nülo made nelo. Ödä iige faloge, gaabo iige, aiala nigime hëlo negei amo gadola aiala hamolo odoa yafie negei. ");
INSERT INTO etr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Felesi dolöla mala dawadigi dolöla ilia ema nabahalea, Dïe bëgëla aulo golia, mäu ilile aialo mala dibe amo damula, naabo nigime hëla made, buludola molö nase goda edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Amala nabasebegi, ea ilima säla obëgësalea, Siiba Aisaeaea asigi fea negelo dilile hedabola bea säla negeimelë. Ea bea säla dëdëla negei amoda gowe, Udia dolö ilile iso asigi wagadi made ga negesiä, adoeamu nïe ëi gauia adalo nea. ");
INSERT INTO etr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ilia dolöfäea mala säla negei amomu olelesaleada, Godeïe adoda amomelëla sälo nea. Amaimo, ilia nïe ëi memalä gauia adalo nebegola säla dëdëla negei dialeala Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dilia Godeïe ado säla negei dibe amo fisila, dolöïe aialo mala dibe amomu gaula gelola hamosa nebegola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesuea ilima aso sähamu nea sähalea, Dilile aiala hamolo mala amo hamosalea. Dilia Godeïe mala säla negei dibe amo fisi gabu. ");
INSERT INTO etr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Amoïe Mosesea ado säla negesalea, dïe diado diemele hawa nea, elele ado nabala, bëgëla hamomalola sälahilä sähalea, Afädëa ïe eedo emele gadiaboseda, baagomäia nufulö dialeala säla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Amai gaso, dilia gomalä sälomelë. Afädëa nelebo amoligi gobanala säseda, eada eedo emele, made ugila negemolömelëla sähalea sälo, Gobana nilïle ado sälada Godegali odala ï neawe. ");
INSERT INTO etr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Amalo ameada, dilia mäu ilia aiala hamolo mala olelei amomu hamosa neada, dilia Godeïe ado fisila, mala amo gadoi yafie hamosamu aligilomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuea udia dolö nefolalo amoli bu misialolahilä ilima sähalea, Dili sulubadelaea, na säsebewe nabala hedabola helësëmalo. ");
INSERT INTO etr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nelebo segea dilo dolö isogi digase ameada, udia dolö neala nafadelo mademelë. Nelebo isogi dilo segea doadigila awäse amea udia dolö neala nafadelomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Amala sälahilä, udia dolö amoli amilahilä, e mumuso isogi digala sebegi, ïe bëgëla aulo amolia ema nabahalea, Ado besula säi amoïe mida edodula nabi. ");
INSERT INTO etr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Amala nabasebegi, ea ilima sähalea, Dilige aso, asigi made gäwi neale. Nelebo sulubadela segea dilo isogi digase ameada, udia dolö Godeïe siigi nigime baalo made amo, dilia dawa made neale. ");
INSERT INTO etr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Molö nase amoda asigigi aulo mademelë. Gaisagi digalahilä segea doadigila aulomelë. Ado amoïeda Yesuea gomalä sähalea säi. Molö sulubadela nase ameada, Godeïe siigi nigime baalo mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ea sähamu nea sähalea, Udia dolöïe iso asigigi besela galase amea, udia dolö Godeïe siigi nigime baalomelë. ");
INSERT INTO etr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Udia dolö ilile iso asigigila besela galalo amoda gowe. Asigi nafadege, nelegei fa nimolöge, udia dolö baagomäia nufulöge, udia dolö susugu hamomolöge, hilimu nafade odoa hamomolöge, ");
INSERT INTO etr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Udia nii susugu hamomolöge, gesami moholöge, mala nafade elö elöla hamomolöge, wäfalï sämolöge, nafade memelela made sulubadela hamomolöge, mudiamolöge, wäfalï säsäla hololömolöge, gugusämäia hamomolöge, asigi maade gadoia hamolo wäla hamomolöge. ");
INSERT INTO etr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nafade amoli sulubadela asigigila besela galasebe amea udia dolö Godeïe siigi nigime baalomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu e sege amo dïgïla gaamu Daiamadi asi. Udia dolö nefolalebe amolia, e neala, made helësëmäia e mosö afädë neebe amoïe mumusogi nogila digai. Gaso, e musügä fimolöi made nelo. ");
INSERT INTO etr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Amala nebegi, udia afädëïe idiwi holöböma mugabe fedai sulo. Amoïe emea Yesu neala säi amo nabala, e fodolofalï maalahilä, Yesuïe emo mia gumusula adi. ");
INSERT INTO etr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Udia ameada Giligi ado adolo. Eda Silia Fonisia fii udia. Ea Yesuma gelola sähalea, Nïe nidiwi holöböma mugabe fedai sebe amo dia nesila digamäia helësësamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Amala säsebegi, ea udia amoma sähalea, Molö nahalea, malö ilidale dafidi ïmolö galea. Malö ilile molö dibe amogida, ügüloea muäia sadia gala ïmolöi made galeala säi. ");
INSERT INTO etr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Amala säsebegi udia amea säla obëgësalea, Dafidilo-o, dofä gaso, malësäea molö nahalea iso dusula fisia digaida ügüloea neala nülo madelela säi. ");
INSERT INTO etr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Amala säsebegi Yesuea udia amoma sähalea, Dia ado säi ameada, dïe didiwima mugabe fedai amo hä asimelë. Di hä mosöa obëgëmalola säi. ");
INSERT INTO etr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Udia amo hï mosöa obëgëlahilä beahamelebe, ïe malöma mugabe fedai amo doadigila asi, diasia dofea dibe melï. ");
INSERT INTO etr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu e Daiamadila obëgëla awäla gaamu Saidono awäla, Gaamu Nabülasimadi nawesa nelolahilä, Galili oeabo edefade dibea ami awäla besela galai. ");
INSERT INTO etr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Udia dolö nefolalo amolia dolö afädë gëhe gala ado dadabi nelo amo e neebea ami sigi maalahilä, Yesuea e naaboea diigimäiamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Amala säsebegi, ea udia dolö nefolalo amoli ami dïgïla, dolö amole heledo aliga gala, ïe naabo sögöea dolö amoïe gëhe helegelagi diigilahilä, oböla hobeala hïle naabo sögögi gofedela galala, dolö amoïe elïgi diigilahilä, ");
INSERT INTO etr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","selesaia mosöa sida adogola nea, hame hëia fedalahilä sähalea, Efadala säi. Nilïle ado adolada, Gëhe gai dugimo. ");
INSERT INTO etr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Amala hamosebegi, dolö amoïe gëhe amo doga negela, ïe elï fodolofalï hedaboi amea, ado hedabola adoi. ");
INSERT INTO etr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuea udia dolö nefolalo amolima gelola sähalea, Walio melï amo udia dolö odoama säla ïmabiola säi. Sämabiola säla ïahamu neebe amo nabalahilä gaso, ilia auaula säla ïahamu nelo. ");
INSERT INTO etr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Udia dolö amolia ado amo nabala ili asigigi edefademalä fudugilahilä sähalea, Ea hamosebego sulubadela hedabola hamosebe. Gëhe gai nelo amoli doga negela digi, adolo made nelo amoli hedabola adomäia hedabolasilo neala säha nefolalo. ");
INSERT INTO etr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Segeyo amo gala, udia dolö yafie bu gegedoi amoli molö molö maade gabugi, Yesuea ïe bëgëla aulo amoli mofiamolahilä ilima sähalea, ");
INSERT INTO etr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Udia dolö gegedoi gowe ili nebalä segeyo ohodoa nelo amea hä molö molö maade gabugi asigisebemelë. ");
INSERT INTO etr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ili sïdëa baagoi amola wäla hili mosöa mosalaseda, ili idiafa si dädäbëlela digamolö gabu, Amase, odoada sege wagadi madela mofiai gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ïe bëgëla aulo amolia ema nabahalea, Nilï sege nafadeia neebe ameada, udia dolö nefolalebewe ili muäia, nilïa molö abidi nea awäla nimolödula nabi. ");
INSERT INTO etr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Amala nabasebegi, Yesuea ilima, dilia beledi aboläia galebela nabi. Ilia ema säla obëgësalea, Nilïa gifalädalïa galebela säi. ");
INSERT INTO etr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Amala säsebegi, Yesuea udia dolö nefolalo amoli nagadaia fifigimalola säi. Amala sälahilä ea beledi gifalädalïa amo gaula nea, Godema nesegelahilä, dagabodasila ïe bëgëla aulo amolima sogomäia ïasebegi, ilia udia dolö sefolalo amo iligali sogoi. ");
INSERT INTO etr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ilia seme nelësa naabo safo ägüi amoge, ea nesegelahilä udia dolö amo iligali sogomäia ï. ");
INSERT INTO etr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Udia dolö sefolalo amoli hulu sulubadela naha madei. Ilia nahalea fea digai amo, ilia adu gifalädalïa salala nobai. ");
INSERT INTO etr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Udia dolö amolida dausini biyidia gadoi nelo. ");
INSERT INTO etr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesuea udia dolö amoli hä afiamalola sälahilä, ïe bëgëla aulola ilida fodolofalï ödä dudaia fila Dalamanuda segeamadi afiai. ");
INSERT INTO etr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Felesi dolö odoa Yesu neebea ami maalahilä ilia ebalä gëgësalea. Dolöea hamomolöi made gadoi, selesaia mosöala misi dia, nofe elöi afädë hamomola säi. Ilia, e amala fedogola beasebegi, ");
INSERT INTO etr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuïe iso asigigi yöla hame hëia fedalahilä sähalea, Udia dolö walio nefolalebe welia dolöea hamomolöi made gadoi nofe elöi hamosebe amo bimolöïe hogosa nebegoïe mida edo! Na dilima dofä gelola sähago. Udia dolö walio nefolalebe welima, dolöea hamomolöi made, nofe elöi afädë dofä made hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Amala sälahilä, ili ami dïgïla e dudaia bu filahilä, oeabo edefade amoïe agesu näiado alömodi amogi asi. ");
INSERT INTO etr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ïe bëgëla aulo amolia beledi made ägüla elabola asi. Ilile beledi afädëfalïmu dudaia ami dilo. ");
INSERT INTO etr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuea ilima gelola sähalea, Felesi dolöle Heledo elele beledi edelo yidi dibe amo helësëla, hedabola idihë namialola säi. ");
INSERT INTO etr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Amala säi amo nabalahilä ilia hilidomu sähalea, Ea säse egoweda, nilïa beledi ägüla made misi amoïe säsebemelëla säha dilo. ");
INSERT INTO etr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ilia säsebe amo ea helësëlahilä ilima sähalea, Nilïa beledi ägüi made amoïe, säsebegola säha dibegoda edoïe! Dilia fädäla helësëla made, nelo amomu nea, dawa made neale! Ma, dilile iso asigi gai, nelo amo, aso, neagole! ");
INSERT INTO etr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dilile si galea gaso, dilia made beasebele. Gëhe galea gaso, dilia made nabahale. Dilia elaboile! ");
INSERT INTO etr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Amo gala beledi bia ameamu dolö dausini biaea muäia, dagabodasi amo nalahilä, fea digai amo dilia neala, adu aboläiagi nobala salila nabi. Amala nabasebegi ilia ema säla obëgësalea, Adu Giwilasila säi. ");
INSERT INTO etr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ilia amala säsebegi ea ilima sähalea, Udia dolö dausini biyidiaea muäia beledi gifalädalïa dagabodasi amo nalahilä, fea digai amo adu aboläiagi salila nabi. Ilia ema säla obëgësalea, Gifalädalïagi säi. ");
INSERT INTO etr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Amala säsebegi, ea ilima sähalea, Dilia fädäla made helësëla nelo amomu aso neagolela säi. ");
INSERT INTO etr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesula ïe bëgëla aulolali afiala Bedesaida segea besela galai. Dolö odoaea dolö afädë si golai nelo amo e neebea ami sigi maalahilä ema sähalea, Dïe naaboea dolö gowe diigimäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Amala säsebegi, Yesuea dolö si golai amo naabogi gaula mosö dibea amila segea sigi awäla, dolö si golai amoïe sihidoa, ea gofedela galala, ïe naaboea diigilahilä, dolö amoma dia nelebo beasebelela nabi. ");
INSERT INTO etr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Amala nabasebegi, dolö amea busa fädägägïa adogola bealahilä sähalea, Dolö nawese dibe beaha gaso, i gadoi nawese beasebemelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Amala säsebegi, Yesuea dolö amoïe siigi bu elö diigisebegi, dolö amea si gadaea gala beasebegi, ïe si amo hedabolahilä nelebo sulubadela beaha maadei. ");
INSERT INTO etr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Amala hamolahilä Yesuea dolö amoma sähalea, Mosö yafie neebeadi mosabio. Dihï mosöa mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesula ïe bëgëla aulolali Sisalia Filibai gaamumadi, sege odoa dibeamadi amogi afiai. Idiafa afiaha difolalea ea ïe bëgëla aulo amolima nabahalea, Udia dolö nefolalebe amoliada neda nowë neala säha difolalebela nabi. ");
INSERT INTO etr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Amala nabasebegi, ilia ema säla obëgësalea, Udia dolö odoaeada, ödägi gelo Yone neala säla digi, odoaeada, Elaia neala säla digi, odoaeada, bea sälo dolö afädë neala säla digisa neamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Amala säla ïasebegi, ea ilima nabahalea, Dilia neda, nowë neala sähala nabi. Fidaea ema säla obëgësalea, Godea ïe udia dolö sigi obëgëmäia, Afädë Memelei amoda dofä dimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Amala säsebegi, Yesuea ilima gelola sähalea, Odoama neda amomelë, säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuea ïe bëgëla aulo amolima mi gäwila säla olelesalea, Dolöïe Malö amoda së edefade molömelë. Dolö asigi gäwi dafidilo neebe amoliage, gobela ïlo busa neebe amoliage, mala dawadigi neebe amoliage, ema habobalahilä ilia e baagomäia nufulömelë. Segeyo osodagi e bu nowemolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ea ilima ado amo mogola säla ï gaso, Fidaea Yesu sigi aliga galahilä, nemola sähalea, amala sämabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amala säsebegi, Yesu e besula, ïe bëgëla aulo amolima siila nea, Fidama nemosalea, Saidani! Ne neebeawi made namolö. Mosö! Diada Godea helësëlo amo gadola made, dolöfäea helësëlo amo gadola helësësebela säi. ");
INSERT INTO etr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Amala sälahilä, ea udia dolö nefolalo amolige, ïe bëgëla aulo amolige mofiamolahilä ilima sähalea, Afädëa ne bëgëla moholö helësëseda, hï hamela helësëlo amo fisila, hïle i fügäi gaula, ne bëgëla moholö dialea. ");
INSERT INTO etr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Afädëa hïle namolö amo gaula fëdöla aligiseda, ïe namolö amo hogosa helemolömelë. Amai gaso, afädëa nege, nïe Ado Mala Hedabige helësëla hïle namolö amo fisiseda, ïe namolö amo hedabi namolömelë. ");
INSERT INTO etr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Afädëa nagadaia nelebo dibe amoli sulubadela gaula neëgi hï e baagoseda, nagadaia nelebo amea, hï e abeahäla ugila negemolödu. ");
INSERT INTO etr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Afädëa bidi edo ïalahilä, hïle namolö amo hï bu nea obëgëmolödu. ");
INSERT INTO etr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Udia dolö ado mala made nabeloge, nafade hamologe, nefolalebe amoli bealahilä, afädëa nïe ëige nïe ado malage säla ïmolö hewaseda, Dolöïe Malö amo, Eedoïe yo digalo hïdo elöibaläge, selesaia fii hedabifalï amolibaläge, obëgësolo amo gala, eage dolö amolibalä hewamolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ea ilima sähalea, Na dilima dofä sähago. Dili walio nebego odoa baagola made neëgi, Godea Beaha Maadela Sigi Neebe amoïe, geloi edefademalä maase amo bimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Segeyo gafeia nelolahilä, Yesuea Fidage Yamesege Yonege sigi gaula hilidofalï segebi afädëgi fedala nefolalo. Ilia beahamelebe Yesuïe domalo neala bedefalahilä elöi neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ïe fagulo gäi amo yo digalahilä faleifalï, sege fifi asi dibe amea fagulo falei amo gadoi hamomolöi made, si dëdëgïla digamolöi neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ilia beahamelebe Elaia Mosesele maala ulufadigilahilä, Yesubalä adosa neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Amo bealahilä Fidaea Yesuma sähalea, Säla Olelelo. Nilï wi nefolalebewe hedabi gabugi, nilïa sege mosö ohodoa olahadio. Elöda dïe, elöda Moseseïe, elöda Elaiaïela säi. ");
INSERT INTO etr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ili edefademalä bedälahilä, ea edo sämolödula asusugahalea, ea ado amo amala säi. ");
INSERT INTO etr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Amala säse amo gaalu gelë häu afädë maala ili hagulahilä, gelëgi amila ado afädë säia idogosalea, Egoweda nïe malö, na boba hamoi neamelë. Dilia ïe ado nabualola säi. ");
INSERT INTO etr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Amo nabalahilä ilia fodolofalï sidawewela beahamelebe ilibalä dolö odoa maade, Yesu emu neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ili segebidaia amila digahalea, Yesuea ilima gelola sähalea, Dilia nelebo melï amo odoama säla ïla made nelolahilä, Dolöïe Malö bauiala nowela neëgi giso, säla ïmalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ado säi amo ilia odoama made säla ïala musügä negelahilä, hilidomu didiähalea, Bauiala nowelasisegila säi amoda edodula didiäi. ");
INSERT INTO etr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ilia ema nabahalea, Mala dawadigi neebe amolia sähalea, Elaia e dafidi moholömelëla säha neebe amoda edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesuea ilima säla obëgësalea, Dofä. Nelebo sulubadela hamogimolöïe Elaia e dafidi moholö. Gaso, Dolöïe Malö e së edefade naala, odoaea ema bimolö habobamolömelëla säla dëdëla negei dibe amoda abeahäladu. ");
INSERT INTO etr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na hä dilima säla ïahago, Elaia eda hä misi. Gaso, ado säla dëdëla negei dibe amo gadola odoa nefolalo amolia ema hamomolö helësëi amo gadoi hamoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ili awäla ïe bëgëla aulo odoa neebea ami besela galai. Ilia beahamelebe udia dolö yafie gegedoi amolia ili amalela digilahilä, mala dawadigi dolö amolia ilibalä gëgësa dibe melï. ");
INSERT INTO etr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Udia dolö yafie nefolalo amolia Yesu maasebe amo beala ili fodolofalï fudugila, e neebea baluluia afialahilä ilia e säla olela gausiai. ");
INSERT INTO etr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Amasebegi, ea ilima nabahalea, Dilia ilibalä edogi gëgësa dialeala nabi. ");
INSERT INTO etr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Udia dolö gegedoi amoligi dolö afädëa ema säla obëgësalea, Säla Olelelo-o, nïe nafegema mugabe fedai amea made ado adosebegi di neebea sigi misimelë. ");
INSERT INTO etr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mugabe ema fedalahilä, nagadaia nidala awäla ïe nafiadi dibu besigala, bese nalëgëlahilä, ïe domalo gelola sosolahamelëla säla ï. Dïe bëgëla aulo ilia mugabe fedai amo nesila digamalai gaso, nesila digimolö ulïsio. ");
INSERT INTO etr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Amala säsebegi, Yesuea udia dolö amolima sähalea, Udia dolö walio nefolalebe dilia asigi afädë negei made nebegoeada. Segeyo aboläia ne dilibalä namolödu. Na dilile yöi gaula segeyo aboläia namolödu. Malö go nema sigi misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Amala säsebegi, ilia malö amo ema sigi misi. Sigi maasebegi, mugabe amea Yesu beala malö amo fodolofalï amulämelasi, nagadaia nidala awäla fefede fefedelahilä, nafiadi dibu besigalasi. ");
INSERT INTO etr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Amala hamosebegi, Yesuea malö amoïe eedo amoma nabahalea, Gowe gadola abodo gala mi gäwila hamosiola nabi. Eedoea säla obëgësalea, E holöfalïgila besela galaimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mugabea malö go baagomäia segeyo yafiegi nulo gobeiage ödägige digalasisamu nelomelë. Dia hamomolöi galëda, nilï bobasëla ugila negemola säi. ");
INSERT INTO etr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuea ema sähalea, Dia hamomolöi galëdala säi amoda edoïe. Dolö asigi afädë negei neebe amea nelebo sulubadela hamosa maademolöi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Amala säsebegi, malö amoïe eedo amea fodolofalï üalala digila sähalea, Na asigi afädë negei gaso dofea made gabu. Bu asigi afädë negedelä dia ne ugila negemola säi. ");
INSERT INTO etr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ili neebea ami udia dolö yafie baluluia mafula gegedosebe amo bealahilä, Yesuea mugabe amoma nemosalea, gëhe galaloge made adologe, dida mugabe. Dima gelola sähago. Malö go dïgïla mosö, ema bu elö fedamabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Amala säsebegi, mugabe amea üalala malö amo amulämelasilahilä doadigila awähalea, hame doala asi gadoi negesi. Udia dolö yafiea amo bealahilä sähalea, hame doala asi gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amala hamosebegi, Yesuea malö amo naabogi nabelela nowela ifosi. ");
INSERT INTO etr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Amala hamolahilä, Yesula ïe bëgëla aulolali mosöa nogila digala hilidomu salea, ilia ema nabahalea, Nilïa mugabe nesimolö ulï amo abisalea amaidula nabi. ");
INSERT INTO etr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Amala nabasebegi, Yesuea säla obëgësalea, Godema adose ameamu mugabe nesila digimolömelë, idi elöda mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesula ïe bëgëla aulolali sege amo dïgïla Galili segeamadi awäla moholö awäha nelo. Yesueada afädëa e neala, made helësëmäiala helësëi. ");
INSERT INTO etr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mida, Ea ïe bëgëla aulo amolima säla olelemolö amo helësëla. Ea ilima sähalea, Dolöïe Malö amo dolö odoama hololöla gausiseda, ilia e baagomäia nufulömelë. Baagomäia nufudaseda, segeyo osodagi hï nowemolömelëla säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Säi amo nabalahilä ilia helësëi made nea, ema mi nabulö amo bedäi nelo. ");
INSERT INTO etr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ili awäla Gabaniama segea besela galala mosö isogi nogila digalahilä, Yesuea ïe bëgëla aulo amolima nabahalea, Idiafa maahalea dilia ado edo didiäla aligi misila nabi. ");
INSERT INTO etr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amala nabasebegi, ili maahalea nilïgi baagila asi neebe amo nowëla säla didiäla aligi misi amo helësëlahilä, ema säla obëgëla made nefolalo. ");
INSERT INTO etr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","E fia idogola salea giwilasi amoli mofiamolahilä sähalea, Afädë dafidilo namolöila helësëseda, dafidi hïdale made, udia dolö odoadale ugila negemolöi galeala säi. ");
INSERT INTO etr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Amala sälahilä ea malö holöbö afädë nabelela gaula maalahilä ili mogogi ifosilahilä, sogobala gaula nea ilima sähalea, ");
INSERT INTO etr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Afädëa ne helësëla malö holöbö gowe gadoi amoma obëbëla obeägïseda, nema obeägïsamelë. Afädëa nema obeägïseda, nema obeägïsa maademelë, ne digamalala sälo amoma obeägïsamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yonea Yesuma sähalea, Säla Olelelo-o, nilïa beahamelebe, dolö afädëa dïe ëi säla mugabe fedai nesila digisa nebegi nilïa ema dia amamabiola säimelë. Mida, dolö amoda nilïbalä nawelo made amea hamosebegi amala säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amala säsebegi, Yesuea säla obëgësalea, Amamabula sämabio. Afädëa nïe ëi säla dolöea hamomolöi made gadoi afädë hamoseda, hobea ne aabela gagademolö mademelë. ");
INSERT INTO etr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dolö nilïbalä ado nii made neebe amoda nilï damelë neamelë. ");
INSERT INTO etr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na dilima dofä gelola sähago. Dilia nïe ëi gaula neëgi, afädëa diligali ödä muäia osala ïaseda, udia dolö amolida dofä bidi nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesuea aso sähamu nea sähalea, Afädëa malö holöbö nema asigi afädë negei goweligi afädë neala digalasiseda, ëfëa igi edefademalägi begela, bidi näiadoea ïe muugia begelalahilä, ödä nudugawa sadia idogola baagomolö amoda, ïe hedabida amomelë. ");
INSERT INTO etr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Dïe naabo elö goea asiala hamola digalasiseda, naabo elö go damula fisimalo. Naabo afädëamu nea namolöi namolö dibea ami moholö hedabi dialea, naabo äudälada heli segea nulo usilo made dibea ami auloea. ");
INSERT INTO etr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Dïe emo elö goea di neala digalasiseda, emo elö go damula fisimalo. Emo afädëamu nea namolöi namolö dibea ami moholö hedabi dialea, emo äudälada heli segea sogobala sadia idogoloea. ");
INSERT INTO etr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dïe si elö goea asiala hamola digalasiseda, si elö go beselala fisimalo. Si afädëmu nea Godea Beaha Maadela Sigi Neebea ami moholö hedabi dialea, si äudälada heli segea sogobala sadia idogoloea. ");
INSERT INTO etr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amida domalo hehea nase amo baagolo madege, nulo usilo madege, dialeamelë. ");
INSERT INTO etr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nulo söaea udia dolö sulubadelama molögi ëbï baalo amo gadola baamolömelë. ");
INSERT INTO etr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ëbï hedabi dialea. Ëbïïe hëdälo amo made galëda, dilia edoea neala hëdälasimolö gabu. Dilile isogi ëbï baalahilä udia dolöbalä aeaha namialola säi. ");
INSERT INTO etr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuea amala säha nelolahilä, sege amo dïgïla, Yudia segea besela galala, ödä Yodona dëgëla agesu näiado alömodi amogi asi. Udia dolö yafie e neebea ami mafula bu gegedosebegi, hï hamolo amo gadola, ilima ado mala säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Amala olelesa nebegi, Felesi dolö odoa e neebea ami maalahilä, Yesuma fedogola nabahalea, Nilïle mala säla negei dibe ameada, dolö afädëa udia nii fisimolö dialeala säla negei dialeale, ma, maadelela nabi. ");
INSERT INTO etr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Amala nabasebegi, ea ilima säla obëgësalea, Moseseada dilima edo hamomalola säla negei dialeala nabi. ");
INSERT INTO etr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ilia säla obëgësalea, Mosesea säla negesaleada, Dolöea udia fisisaleada, beba dëdëla ïalahilä, fisimolöi galeala säla negei dialeala säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuea ilima säla obëgësalea, Moseseada dilile iso asigi geloi dibe amo beala, dilima ado go dëdëla negeimelë. ");
INSERT INTO etr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Godea siiba nelebo sulubadela mi gäwila hamosolo amo gala, udiale dolöle äudä hamoi. ");
INSERT INTO etr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Amala hamoi ameada, dolöea ïe eedole emele dïgïla, ïe udiabalä gedola nea, ");
INSERT INTO etr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","eleda domalo afädëfalï namolömelë. Ele äudä nelo amo fisila afädëfalï neamelë. ");
INSERT INTO etr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Godea ele gedolasi amo, dolöea mogemabiola säi. ");
INSERT INTO etr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hobeala ïe bëgëla aulolali mosöa obëgëla awäla sefolalea, ïe bëgëla aulo amolia ado säi amoïe ema mi fädäla nabi. ");
INSERT INTO etr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Amala nabasebegi, ea ilima säla obëgësalea, Dolö afädëa hïle udia fisila udia elö neaseda, ea udia amo fa susugu hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Udia afädëa ïe dolö fisila dolö elöma fiseda, dolö amo ea fa susugu hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Udia dolö odoa nefolalo amolia, ilile malö Yesuïe naaboea diigimäia e neebea sigi maasebegi, ïe bëgëla aulo amolia ilima halala nemola dofogai. ");
INSERT INTO etr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Amala säse amo beala, Yesuea ilima habobalahilä sähalea, Malësä ne neebea maase goli misiäia, halala nemola dofogamabu. Godea Beaha Maadela Sigi Neebea amida, malësä go gadoi nefolalebe amolile dialea. ");
INSERT INTO etr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na dilima dofä gelola sähago. Godea Beaha Maadela Sigi Neebea ami, malësä go ili gadoia moholöila helësëi neebe amo gadola, afädëa ne moholöila made helësëi neebe amoda, dofä made nogila digamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Amala sälahilä, ea malësä amoli afädë afädëla sogobala gaula nea naaboea diigisalea, Godea ugila negemäiala säla fisiga idodogosa nelo. ");
INSERT INTO etr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu e moholö awäha nebegi, dolö afädë baluluia maala, ïe emo mia gumusula dia idogolahilä sähalea, Säla Olelelo hedabi-e, ne namolöi namolö neala gaumolöïe abilia hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Amala nabasebegi, Yesuea ema säla obëgësalea, Dia nema hedabila säi amoda edoïe. Afädë hedabi maademelë, Gode emu hedabi nea. ");
INSERT INTO etr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ado säla negei dibe amolida dia dawadigi. Baagomäia nufuabio, udia fa nimabio, nelegei fa nimabio, wäfalï säsäla gudimabio, dahila neala elöïe nelegei dibe amo nimabio, dïe diado diemelele ado nabala hamomalola säla negei dialeala säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Amala säsebegi, ea Yesuma säla obëgësalea, Säla Olelelo-o, ado amolida ne malësägila hamosa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Amala säsebegi, Yesuea dolö amo boba hamolahilä, ema siila nea sähalea, Afädëmu dofea made nebego. Dïe nelegei dibe amoli bidi neaha maademolö mosö. Muni nease amoda nelegei negelo made busadäoi neebe amoligali ïmalo. Iligali ïaseda, selesaia mosöa bidi edefade nimolömelë. Amalahilä di ne bëgëla misialola säi. ");
INSERT INTO etr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dolö amea ea säi amo nabala yöla ïe odagi augia idalahilä asi. Mida, ïe nelegei yafie dilo amogi. ");
INSERT INTO etr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Amasebegi Yesuea ïe bëgëla aulo nefolalebeadi sidawewela bealahilä sähalea, Udia dolö nelegei yafie negelo nefolalebe amolida, Godea Beaha Maadela Sigi Neebea ami moholöda häuai bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ea amala säsebegi ïe bëgëla aulo amolia fudugi. Yesuea ilima aso bu elö sähalea, Nïe malöla dili-e! Godea Beaha Maadela Sigi Neebea ami moholöda häuai galeamelë. ");
INSERT INTO etr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sugua gameleda nusi galabagi nogila moholö ulï amo gadola, dolö nelegei yafie negelo dafidilo nefolalebe amolida, Godea Beaha Maadela Sigi Neebea ami moholö häuai bimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Amala säsebegi, ïe bëgëla aulo amolia edefademalä fudugilahilä hilidomu didiähalea, Amai goeada, amai, namolöi namolö nowëa neala gaumolödula säi. ");
INSERT INTO etr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Amala säsebegi, Yesuea ilima siila nea sähalea, Udia dolöea hamomolöi made amoda. Godea hamomolöi madeda maade, ea sulubadela hamosa maademolöi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Amala säsebegi, Fidaea ema säla obëgësalea, Bimo! Nilïa di bëgëla maahalea, nelebo sulubadela fisisa maadelahilä misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Amala säsebegi Yesuea ilima sähalea, Na dilima dofä gelola sähago. Afädëa neëge, Ado Mala Hedabige helësëla, mosöge, edooge, elefige, emege, eedoge, malöge, segege, fisisa maadelahilä, ");
INSERT INTO etr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hädali afädë nimolömelë. Ili nagadaiawi nebegi Godea nelebo yafie dafidi ï amo baagila awäla ïmolömelë. Mosö yafiege, edoo yafiege, elefi yafiege, eme yafiege, sagai yafiege, segege, ilia yafie nimolömelë. Amala nii neëgi odoaea ili neala sëlasimolömelë. Hobeala segeyo afädë besela galasolo amo galada, ea namolöi namolö gaula namolömelë. ");
INSERT INTO etr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Walio yafie dafidila nefolalebe amolida, neala hobeahalea, yafie hobeala nefolalebe amolida, neala dafidimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesula ïe bëgëla aulolali Yalusaleme aulo idi afiaha dialea, Yesu e, edale dafidi awäha nebegi, ïe bëgëla aulo amoli hobeala afiaha dialea fudugila aligi afiai. Udia dolö odoa ili bëgëla hobeala afiaha dilo amoliage bedäla aligi afiai. Yesuea ïe bëgëla aulo giwilasi amoli bu sigi aliga galahilä, ema hobea hamomolö amoïe ado ");
INSERT INTO etr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","säla ïahalea, Nabuö. Nilï walio Yalusaleme afiahamelë. Amai gaso, gobela ïlo busa iliage ado säla negei dawadigi iliage Dolöïe Malö amo gaumäia afädëa gaula ïmolömelë. Gaula ïaseda, ilia ebalä gudila, baagomäia nufulömelëla didiälahilä, fii odoagali gaula ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gaula ïaseda, ilia e gagadela gofedela galala, ëfë damuia nufudalahilä, baagomäia nufulömelë. Amala hamoseda, segeyo osodagi e nowela moholömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebediïe malö Yamese Yonele Yesu neebea maalahilä, elea ema sähalea, Säla Olelelo-o, alïa helësësewe gadoi dia alïma hamomäia hamesamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Amala säsebegi, ea elema säla obëgësalea, Na alima edo hamomäia helësësebela nabi. ");
INSERT INTO etr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Amala nabasebegi, elea ema säla obëgësalea, Dïe yo digalo hïdo elöibalä fisolo amo gala, alï elöda dïe naabo dafädimadi, elöda dïe naabo fefeädimadi fimalola sämäia helësësamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Amala säsebegi, Yesuea elema sähalea, Alia ado säi amoda helësëla made fuduia säimelë. Na ödä iigi usi naha neebewegi alia molöi gabule. Ma, ne ödägi gesa neebewegi ali gemolöi gabulela nabi. ");
INSERT INTO etr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Amala nabasebegi, elea ema säla obëgësalea, Alïa amala hamomolöi neawela säi. Amala säsebegi, Yesuea elema sähalea, Na ödä iigi usi nasewe gadola aliage molömelë. Ne ödägi gesewe gadola alige gemolömelë. ");
INSERT INTO etr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gaso, ali elö di nïe naabo dafädimadi, elö di nïe naabo fefeädimadila samiäia memelemolöda nïe mademelë. Godea fimäiala daiai amolilemelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bëgëla aulo nabülasi odoa amolia elea ado säi amo nabala elema habobaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Amasebegi, Yesuea ili mofiamolahilä ilima sähalea, Fii odoa beaha aligilo gadoi neebe amoliada, udia dolö gelola beaha aligilo nea. Amase, ilile ëi sälo neebe amoliada, udia dolö bobasëla made, ilia säse amo gadola hamomäia gelola sigi aligilo amoda dilia dawa. ");
INSERT INTO etr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ilia amala hamolo amo gadola, dili nebegogi afädëa amala hamomolöi mademelë. Dili nebegogi afädëa ëi sälo namolöila helësëseda, odoa neebe amo iligali hamoi hamolasilo namolö dialea. ");
INSERT INTO etr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Afädëa e dafidilo namolöila helësëseda, eda udia dolö sulubadelaïe, memalä galabaia hamoi gadoi hamolasilo namolöi galea. ");
INSERT INTO etr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mida, Udia dolöea Dolöïe Malö misi amoïe hamoi hamolasimäia made, Ea ilile hamoi hamolasila, ïe namolö amo udia dolö yafiegali fisiga gala, ili sigi obëgëmolö misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesula ïe bëgëla aulolali afiala Yaligo gaamugi besela galai. Besela galala ïe bëgëla auloge udia dolö odoa yafiege ebalä Yaligo baagila afiaha dibegi. Dimasaïe malö Badimasa eda, si golai idi agesua ami salea, muni ïmola ëdëgësa filo sulo. ");
INSERT INTO etr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","E amala salea Nasalese fii Yesu maahala säi amo nabalahilä, ea uuala sähalea, Debidiïe malö Yesu-o, ne bobasëmola säi. ");
INSERT INTO etr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Amala säsebegi, udia dolö yafiea ema nemosalea, Dia adomabula säi. Gaso, ea auaula gelola uuahalea, Debidiïe malö-o, ne bobasëmola sähamu nelo. ");
INSERT INTO etr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ea Amala säsebegi, Yesuea fologola made beaha nea sähalea, E misiäia dilia e wemolö säi. Ilia dolö si golai amoma sähalea, Asigi hä gelomalo. Ea di wesebego, di hä nowemola säi. ");
INSERT INTO etr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ea fagulo afädë salugala sulo amo giila sadia galahilä, fodolofalï nowela Yesu neebea ami misi. ");
INSERT INTO etr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Maasebegi, Yesuea ema nabahalea, Na dima edo hamomäia helësësebela nabi. Amala nabasebegi, dolö si golai amea säla obëgësalea, Säla Olelelo-o, na bimolö helësësebela säi. ");
INSERT INTO etr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Amala säsebegi, Yesuea ema sähalea, Dihï asigi afädë negei amea dïe si hä wahigomelë, Mosalola säi. Amala säsebegi, dolö amo fodolofalï wahi amea siia fädäla bealahilä, Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesula ïe bëgëla aulolali Yalusaleme besela galamolö ga madela nea, sege Bedefagige Bedanige, Olibebi neebea amige, ili awäla besela galai. Besela galala ami nea, Yesuea ïe bëgëla aulo amoligi, äudä dafidila mosalolahilä, ");
INSERT INTO etr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","elema sähalea, Segea ami awäla besela galala beahamelële, sugua dögi üdïli afädë dolöea fila aulo made, ga madefalï gui gide begela negei neë bimolömelë. Dögi amo fisigälahilä wi sigi misialo. ");
INSERT INTO etr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Afädëa alima dögi go abïdä fisigähala nabaseda, alia ema gomalä sämalo. Dafidilo Geloia webalä hamoi hamomolömelë. Amalahilä, we fodolofalï sigi obëgëmalamolömelëla sämalola säi. ");
INSERT INTO etr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Amala säi amo nabalahilä, ele awäla besela galala beahamelebe, sugua dögi üdïli afädë mosöa nogila digalo, ifo baagido idiliba ami, gide begela negei neebe amo bealahilä, fisigäi. ");
INSERT INTO etr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fisigäsebegi, udia dolö ami nefolalo amolia elema nabahalea, Alia abilia hamodelä, sugua dögi üdïli go fisigähala nabi. ");
INSERT INTO etr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Elea Yesuea sämalola säi amo gadola säsebegi, ilia hä, sigi mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Elea sugua dögi üdïli amo Yesu neebea sigi gaula awälahilä, elea sugua dögi amodaia fagulo daia salugalo amo giila fösisebegi, Yesu e amodaia fedala sulo. ");
INSERT INTO etr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Amala hamosebegi, udia dolö yafiea ilile fagulo gäi amo giilahilä idiafa föla digi, odoaea idi agesua fasela bäu gadoi dagabola gaula mafula föföla aligi awäha nelo. ");
INSERT INTO etr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Udia dolö nefolalo amoli Yesu awäse amo gadola, dafidila awäha nelo amoliage, hobeala maaha nelo amoliage, uuala säsäla awähalea, Agua. Nesege. Godeïe ëi gauia adadi. Afädë Dafidilo Geloiïe ëigila maahago, Godea ema obeägïmäia. ");
INSERT INTO etr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nilïle naado Debidia beaha maadela sigi nelo amo gadola namolö neebe amoma obeägïdi. Selesaia fiia Godeïe ëi gauia adala nesegemola uuala säsäla awäha nelo. ");
INSERT INTO etr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu e Yalusaleme besela galala, Godeïe mosö amoïe yala isogi nogila digalahilä, ami nelebo difolalebe amo sulubadela beaha maadei. Hä deadisebegi, ïe bëgëla aulo giwilasi amolibalä Bedani obëgëi. ");
INSERT INTO etr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Segeyo agedugi ili Bedani amila awähalea, Yesu e sïdëa baagoi. ");
INSERT INTO etr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sïdëa baagosebegi holöbö wagadi madela sida gala beahamelebe, äfäeo bäu yafie negei neebe melï. Bealahilä, gägä negei walebelela mia bea asi. Beahamelebe gägäda negei made, bäumu yafie negei neebe melï. Mida, äfäeo gägä negelo segeyogi made amea bäumu melï. ");
INSERT INTO etr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Amo bealahilä ea äfäeo amoma sähalea, Hobea dïe gägäda udia dolöea made molömelëla säi. Amala säse amo ïe bëgëla aulo amolia nabi. ");
INSERT INTO etr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesula ïe bëgëla aulolali awäla Yalusaleme besela galai. Yesu e Godeïe mosö yala isogi nogila digalahilä beahamelebe, bidi neadigi, bidi nimolöïe negela digisa difolalo amoli nesila digilahilä, Muni bedefalo auli amoge, haea maliabu gadoi bidi neaha aligilo amolile filo auli difolalo amoge, besigadasi. ");
INSERT INTO etr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Godeïe mosö yala isogi nogila digahaleada, dilia nelebo gaula, nogila digafu fedafumabiola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Amala sälahilä ea ilima säla olelesalea sähalea, Bebagi ado dëdëla negei dibe amoda gomalä madele. Nïe mosö goweda fifi asi sulubadelaea Godema adolo mosö neamelëla sämolömelëla dëdëla negei dialea gaso, dilia fa nelo musügä aligilo igi äbä gadoi hamoi gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Amala hamoila säi amo nabalahilä, gobela ïlo busa amoliage, ado säla negei dawadigi dolö amoliage, Yesu abeahäla nufulödula fu hogosa nelo. E nufulö helësëi amoïe mida, ebalä bedähalea. Ebalä bedäi amoïe mida, udia dolö nefolalo amoli sulubadelaea ea mala olelei amo nabala fudugisebegi. ");
INSERT INTO etr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Säha nea së gäsebegi, Yesula ïe bëgëla aulolali Yalusaleme dïgïla afiai. ");
INSERT INTO etr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ili diala yose awähalea beahamelebe, äfäeo amo bäuge difige bausosa maadei neebe melï. ");
INSERT INTO etr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bealahilä Yesuea säi amo helësëlahilä Fidaea ema sähalea, Säla Olelelo-o, bimo! Dia aiyo äfäeoma habobala säi amoda hä bausoi gabuwela säi. ");
INSERT INTO etr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Amala säsebegi, Yesuea ilima säla obëgësalea, Godema asigi afädë negemalo. ");
INSERT INTO etr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na dilima dofä gelola sähago, Dolö afädëa asigi äudä negela made, ea säse amo gadola dofä amamolöla helësëla, segebi gowema dia dihï dagabola duhuludaia digamola säseda, ea säi amo gadola dofä amala hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Amaimo, na dilima säla ïahago. Dilia Godema adosalea nelebo afädë nimolöla helësëla ema nabaseda, Dilia säi amo gadoi dofä nimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Dilia nowela nea Godema adosalea, dolö afädëa dilima asiala hamoi amo helësëseda, dolö amea asiala hamoi amo fisimalo. Amala hamoseda, dilile Diado selesaia mosöa neebe amea, dilia asiala hamoi amoge fisimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesula ïe bëgëla aulolali Yalusaleme bu obëgëlahilä, Yesu e Godeïe mosöa nogila digaha nebegi, gobela ïlo busa amolige, Ado säla negei dawadigi dolö amolige, asigi gäwi dafidilo dolö amolige, e neebea ami maalahilä, ");
INSERT INTO etr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ema nabahalea, Nelebo dia hamosa neebe goli hamomäia, nowëa hamomalai hamosa. Nilïa nabedelä, dia säla ïmo. Go hamomäia, geloi go nowëa ïasiola nabi. ");
INSERT INTO etr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Amala nabasebegi, Yesuea ilima säla obëgësalea, Nage dilima afädë nabahago, Na dilima nabase amo dilia säla obëgëseda, na nelebo hamosa neebewe hamomäia geloi ï amoda gowea ïmelëla dilima säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yonea ödägi gesa nelo amoda Godeïe galueale ma, dolöïe galueale. Dilia nema säla ïmola säi. ");
INSERT INTO etr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Amala säsebegi, ilia hilido didiähalea, Nilïa selesaia galueala säseda, dilia ema asigi afädë negela made nelo goda edoïela sämolö gabu, ");
INSERT INTO etr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amase nilïa dolöïe galueala sämolö gaso, amoge dofea made gabula säi. Ilia amala säi amoïe mida, Udia dolö sulubadelaea Yoneda Godeïe bea sälo afädë nelola helësëi neebe amo helësëla ili udia dolöbalä bedäi. ");
INSERT INTO etr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Amalahilä ilia Yesuma säla obëgësalea, Nilïada dawa mademelëla säi. Amala säsebegi, Yesuea ilima sähalea, Amai galëda, na nelebo hamosewe hamomäia geloi ï amoda gowea ï hamosa neamelëla, nage dilima made säla ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yuda ilile busa dolö nefolalo amolima, Yesuea ado besula säla ïahalea, Dolö afädëa yalala agulahilä, ëfë gägä negelo ëi gelebi sagai. Gelebi sagai amo emesala fësëla salimolöïe uli dögöi. Amalahilä sagai amo idihë namiäia mosö afädë holöbö ilibia ola negesi. Amalahilä, ea dolö odoama sähalea, Sagai amo beaha nea bisinesi hamosa namialola säsilahilä, hï eda sege wagadi made namolö asi. ");
INSERT INTO etr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hä, gelebi gägä amo faimolö segeyo besela galasebegi, sagai eedo amea ïe hamoi hamolasilo afädëma sähalea, Nïe sagai beaha aligilo nefolalebe amolima, gelebi gägä odoa faila ïmola sämolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Faila ïmola samolö asi gaso, sagai beaha aligilo nefolalo amolia e gaula nufudala ïalalelahilä, memalä e hodomu fisiga gaimelë. ");
INSERT INTO etr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Amala hamoi galebe, sagai eedo amea ïe hamoi hamolasilo elöma bu mosaloi. Awäsebegi, ilia busagia afisila nufudalahilä, e gagadela gadiaboi. ");
INSERT INTO etr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amala hamosebegi, sagai eedo amea ïe hamoi hamolasilo osoda bu mosaloi. Awäsebegi, ilia dolö amo nufudala baagoi. Amalamu hamosebegi ea dolö yafie oböla bu mosalai. Amoligi odoa nufudala ïalalelahilä, odoa baagomäia nufi. ");
INSERT INTO etr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hä dolö afädëfalïmu nelo. Dolö amoda hïle efege hï boba hamoi nelo. Hobeafalï eedoea ïe malö amoma ili neebea mosalalahilä sähalea, Iliada nïe malö amoïe ado nabala mogola hamomolöla helësësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gaso, sagai oodola beaha aligilo nefolalo amolia hilidomu säla didiähalea, Sagai eedo amoïe malö amoda hä go gabugo. Eedoïe nalä ea nimolö gabugi, nilïgali bedefala nedelä, e baagomäia nufidedila sälahilä, ");
INSERT INTO etr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ilia malö amo nufudalahilä, ïe domalo amo sagai yala baagido sadia gaimelë. ");
INSERT INTO etr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Amala hamoi amoïe sagai eedo ameada abilia hamomolödu. E maalahilä sagai beaha nefolalo amoli baagomäia nufudaha maadelahilä, sagai amo odoaea beaha namiäia ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bebagi ado säla dëdëla negei dibe amo dilia made melï neale. Mosö olelo amolia igi amo galone hamomolöi made gabula memelela fisi. Gaso, walioda galone geloi gelola dialeamelë. ");
INSERT INTO etr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Amoda Dafidilo Geloi hï hamogi amo nilïa siia bealahilä fudugisa neamelëla säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dolö busa nefolalo amolia Yesuea ilile ado besula säsebela helësëlahilä, ilia e gaudelä hamoi gaso, udia dolö yafie nefolalebe amoli beala ili bedähalea dïgïla asi. ");
INSERT INTO etr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Busa dolö amolia, Felesi dolö odoage, Heledoïe damelë odoage, Yesu neebea mosaloi. Mida, Yesuea ado asiala säseda, e gaumolöïe Yesu fedogola adomolö mosaloi. ");
INSERT INTO etr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ili Yesu neebea afialahilä, Yesuma sähalea, Säla Olelelo-o, nilïada, dia mala säla olelese amoda mogola olelesala helësësamelë. Amalahilä dolö odoa ëi sälo geloi nefolalebe amolibalä bedäla madege, odoa nefolalebe amolia di beala säse amogige dia helësëla made neada, Godea hamese amoïe mala udia dolöma säla olelelo amoda mogola säla olelelomelë. Amalo gabugi dima afädë nabaha. Nilïle mala säla negei dibe amo helësëla, Beaha Aligilo Sisa neebe amoma dagisi muni ïmolö dialeale ma, madele. ");
INSERT INTO etr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nilïa ema dagisi muni ïmäiale ma made ïmäialela nabi. Ilia e fedogola wäfalï säsebe amo dawadigilahilä, ea ilima säla obëgësalea, Edoïe ne fedogola beaha. Na melëdelä muni giwi afädë gaula misiëla säi. ");
INSERT INTO etr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ilia muni giwi afädë gaula maasebegi, ea ilima nabahalea, Muni giwi gowegi dolö busa dibe gowege, ëi dëdëi dibe gowege nowëïe gabula nabi. Amala nabasebegi, ilia ema säla obëgësalea, Beaha Aligilo Sisaïela säi. ");
INSERT INTO etr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuea ilima säla obëgësalea, Nelebo Sisaïe dibe amoda Sisa hïma ïmalo. Nelebo Godeïe dibe amoda Gode hïma ïmalola säi. Amala säse amo nabala ili fudugi. ");
INSERT INTO etr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Udia dolö baagoi amoli made nowela galamolöla sälo, Sadiusi dolö amoligi odoa Yesu neebea maalahilä sähalea, ");
INSERT INTO etr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Säla Olelelo-o, nilïa hamomäia Mosesea, ado afädë dëdëla negei dibe amoda gowe. Dolö afädëïe edoo malö maade nea baagoseda, udia didalo amo sulolahilä, dolö baagoi amo sosogo namiäia, ïe ëigila malö sogobamolöïe, edoo elö amohï udia amo nimäiala säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Amaimo, edoolali gifalädalïa salea, abulümi amea udia afädë neala nea, malö made sogobala baagoi. ");
INSERT INTO etr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Baagoibua, abulümi baagia amea udia didalo amo bedefala nealahilä, eage malö made sogobala baagoi. Amala bu baagoibua, edoo osoda ameage amala hamolahilä, ");
INSERT INTO etr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","edoolali gifalädalïa amoli malö made sogobala baagosa maadei. Amalahilä udia amo hobea wagala baagoi. ");
INSERT INTO etr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Amala hamoi amo dolö gifalädalïa amolia udia afädë amomu nii amea, hobea baagoi amoli nowela galasolo amo gala udia amo nowëïe udia samolödula nabi. ");
INSERT INTO etr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Amala nabasebegi, Yesuea ilima säla obëgësalea, Bebagi ado säla dëdëla negei dibe amoge, Godeïe geloi dibe amoge, dilia dawa made amea dilia asiala säsebego. ");
INSERT INTO etr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Udia dolö baagoi amoli nowela galasolo amo galada, dolöea udia nimolö mademelë. Amase, udiage dolö fimolö mademelë. Ilida selesaia fii nefolalebe amoli gadoi namolö madele. ");
INSERT INTO etr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Amase, udia dolö baagoi amoli nowela galamolö amoïe ado afädë sähago. I afädëgi nulo söa fedaila säla, Mosese dëdëla negei dibe amo dilia made melïle. Amila Godea Mosesema sähalea, Neda Abalahamaïege, Aisagaïege, Yeigabaïege Gode neamelëla säila säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eda udia dolö baagoi amolile Gode mademelë. Eda udia dolö sebe amolile neamelë. Dilia asiala helësëi gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ado säla negei dawadigi dolö afädë maalahilä, Sadiusi dolö amolia Yesubalä gëgësebegi, ea ilima hedabola säla obëgësebe amo nabalahilä, ea Yesuma nabahalea, Godea Ado säla negei dibe amogi geloi edefadeda abododula nabi. ");
INSERT INTO etr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Amala nabasebegi, Yesuea ema säla obëgësalea, Ado säla negei dibe amogi geloi edefadeda gowemelëla sähago. Isilale udia dolö dilia nabualo. Dafidilo Geloi eda, nilïle Gode afädëfalï neebe emu Dafidilo Geloi neamelë. ");
INSERT INTO etr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dafidilo Geloi dïe Gode neebe amo dïe bobaeage, gesamiage, asigiage, geloiage boba hamomalola säla negei. ");
INSERT INTO etr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Amo baagia elöda gowe. Dihïdi boba hamolo amo gadola, odoa dibalä nefolalebe amoli boba hamomalola säla negei. Mala geloi edefade äudä säla negei dibe amole gadoida, odoada maademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Amala säsebegi, ado säla negei dawadigi amea ema säla obëgësalea, Säla Olelelo-o, dia Gode afädëfalï emu neala säi amoda, dia dofä säi. Elöda maademelë. ");
INSERT INTO etr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ema bobaeage, dawaeage, geloiage hamelahilä, dihïdi boba hamolo amo gadola, odoa dibalä nefolalebe amoli boba hamomalo. Äudä amoleada nelebo Godegali odala ïala gobesa maadelo amoge, odala ïlo amoge sulubadela baagila asimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuea dolö amea hedabola helësëla säsebe amo bealahilä, ema sähalea, dida Godea Beaha Maadela Sigi Neebea ami ga madela nebegola säi. Amala säsebegi, udia dolö odoa ilia Yesuma nelebo odoa nabulö amo bedäi. ");
INSERT INTO etr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuea Godeïe mosöa säla olelesa nea sähalea, Ado säla negei dawadigi nefolalebe amolia, Afädë Memelei moholömelëla säi amo e Debidiïe malöla sälo amoda abeahäla sälodu. ");
INSERT INTO etr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Eleloi Gesamia Debidima helësëlasisebegi, Debidia sähalea, Dafidilo Geloia nïe Dafidilo Geloima sähalea, Na dïe ado nii nefolalebe amoli di hawa ifosimäia, dida nïe naabo dafädimadi awäla salea, beaha samialola säimelë. ");
INSERT INTO etr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Amase, Debidia hï ema Dafidilo Geloila säi amoda, Dafidilo Geloi e Debidiïe malöda abeahäladula nabi. Udia dolö yafie gegedoi amolia ea säse amogi obeägïla nabi. ");
INSERT INTO etr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuea ilima ado mala olelesalea sähalea, Dilia mala dawadigi nefolalebe amoli hedabola idihë namialo. Ilia fagulo sedademu salugala magaia gaamugi awälahilä, udia dolöea ili beala gugusäla gausiamäiala helësëlo nea. ");
INSERT INTO etr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Amase, iliada gedolo mosöa amige dolö dafidilo filo dibea amimu fimolöila helësëloge, udia dolö yafie gegedola molö nasebea ami molö gialo eedo amobalä dafila salea, ua gagaula hamomolöila helësëlo nea. ");
INSERT INTO etr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ilia udia didalo sebe amoli dahila neala, ilile mosöa nelebo dibe amo fa neala gaula aulo nea. Ilile asigi musügä negesilahilä, adoeamu Godema sedadela adolo nea. Amala hamosebe amoïe ili së edefade muäia baala ïmolö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Godeïe muni negelo dibea ami Yesu e ga madela salea, udia dolö yafie misi amolia muni negelo amogi muni negese amo siila sulo. Nelegei yafie negelo dafidilo udia dolö yafie amoliada muni yafie negei. ");
INSERT INTO etr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Udia didalo busadäoi afädë maalahilä muni giwi holöfalï äudä negei. ");
INSERT INTO etr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Amala negesebegi, Yesuea ïe bëgëla aulo amoli misiëlahilä ilima sähalea, Na dilima dofä gelola sähago. Udia didalo busadäoi gowea negei ameada udia dolö sulubadelaea Godeïe muni negelo amogi negei amo baagila asimelë. ");
INSERT INTO etr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ilia muni yafie negei dilo amogi odoa mogela hilile negesalea mogela negesio. Be, udia goweada afädë gaula made nea, ea molö nimolö gaui amoda hulu sulubadela negesa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu e Godeïe mosöa amila doadigila awäha nebegi, ïe bëgëla aulo afädëa ema sähalea, Säla Olelelo-o, igi hedabi hïdo elöi bobogamu nelegela fedala mosö made, hedabi hïdo elöi neebe gowe bimola säi. ");
INSERT INTO etr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Amala säsebegi, Yesuea ema säla obëgësalea, Dia mosö edefade igi bobogamu nelegela fedala uli nefolalebe beahago gasoda, igi nelegela fedala uli nefolalebegoda, igi afädëdaia amimu negela made, sulubadela mugulula digaha maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu e Olibe bi daia fedala Godeïe mosö sida idogola sebegi, Fida Yamese Yone Ädululali hilidomu nea ilia ema nabahalea, ");
INSERT INTO etr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Dia nilïma säla ïmo. Segeyo abodo gala dia säi amo besela galamolödu, Dafidi nelebo edodale besela galasegi, nilïa amo beala dia säi amo besela galamolö amoda, hä ga madesa gabula helësëmolömelëla nabi. ");
INSERT INTO etr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Amala nabasebegi, Yesuea ilima säla obëgësalea, Odoaea dili dahila neloea, idihë namialo. ");
INSERT INTO etr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dolö yafie maalahilä nïe ëi säla sähalea, Neda dolö amo misi neawela sälahilä, udia dolö yafie dahila nimolö moholömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ga made nudusalea ado goba nabase amogige, sege wagadi made nudusalea wabula säse amo nabalage, dilia bedäla fudugimabio. Nelebo amala hamose ameada, aligila wagamolöïe made amamolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Fii elöle elöle nudula digi, gamane elöle elöle nudula digisa namolömelë. Amase, sege föi odoagi fogolige maala, sïdë iige moholömelë. Nelebo amoli hamomolö amoda, udiaea malö ägümolö salea mi gäwila sëlo amo gadoi bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dilia hedabola idihë namialo. Ilia dili nafodola gaula galïsolö neebea sigi moholömelë. Gedolo mosöa amige dili nufudala ïalalemolömelë. Nïe ëi gaula mogoi ameada gamane dolöïe siigige, gini dolöïe siigige gaula awäla ifosimolömelë. Amala hamoseda nïe Ado Mala Hedabi nabuäia säla ïaha namialo. ");
INSERT INTO etr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amo hamola made neebewegi wäla, fifi asi sefolalebe amoli sulubadelaea, nïe Ado Mala Hedabi nabaha maademäia dafidi säla ïmalo. ");
INSERT INTO etr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ilia dili nafodolahilä gudimolöïe sigi gaula awäseda, ado abodo sämolödula asigia säosäola helësëmabio. Gudisolo amo gala Godea ado säla ïasebe amo säla ïmalo. Ado säla ïmolö amoda dihili sämolö mademelë. Eleloi Gesamia sämolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dolöea ïe edoo nufudala baagomäia gaula ïmolömelë. Malö eedoea hïle malöge amo gadola wäla hamomolömelë. Amase, malöeage ïe eedo emelebalä habobala nufudala baagomäia gaula ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nïe ëigi nefolalebego beala, sulubadelaea dilima bimolö habobamolömelë. Amai gaso, afädëa aso maadela, hamola wagamäialahilä gelola aligise amo eda damula moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesuea ilima sähalea, Yöi yafie hehealela bedälasimolö maala negemolöi made dibea ami maala negei dië bimolömelëla säla ï. (Ado gowe nidese ameada hedabola helësëmalo.) Yesuea amala sälahilä sähalea, Amo siia beaseda, Yudia segea sefolalebe amolida segebi dibea ami fisäla baluluia afufumalo. ");
INSERT INTO etr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Amo gala, afädë mosö fïgïdaia sulo amea digalahilä, ïe nelegei mumusogi nea digamabio. ");
INSERT INTO etr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dolö sagaia nelo amea hï mosöa fagulo nea obëgëmabio. ");
INSERT INTO etr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Segeyo amo gala udia fagulo hagui sefolalebe amolige, malö dubo dodo ïaha sefolalebe amolige, edefademalä asigiimolö dialea. ");
INSERT INTO etr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amo hamomolö amoda, i bäu giisalea gögï mulo amo gadola muloea, Godema adosa namialo. ");
INSERT INTO etr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mida, segeyo amo gala yöi yafie elö elöla maala negei dië bimolömelë. Godea nelebo mi gäwila hamoia amila yöi amo gadoi made melï. Amase, hobeage bu elö made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amaimo, Dafidilo Geloia segeyo amo neala obobagilasimolö made helësëi galebeda, udia dolö sulubadela namolö amo fu made bealabio. Udia dolö hï memelei amoli helësëlahilä, segeyo amo neala obobagilasimolö helësëi. ");
INSERT INTO etr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Amaimo, afädëa dilima sähalea, Afädë Memelei amo misi neebe gowe bimola säsege, e neebe gagowe bimola säsege, dofä gabula helësëmabio. ");
INSERT INTO etr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dolö odoaea wäfalï säsäla sähalea, Afädë Memelei amo ne misi neawela sämolö moholömelë. Odoaea wäfalï säsäla sähalea, Neda Godeïe bea sälo misi neawela sämolö moholömelë. Amala maalahilä, ilia udia dolö Godea memelei nefolalebe amoli dahila neala hamomolöi walebelela bimolöïe, dolöea hamomolöi made gadoige, hïdo elöi elö elöge hamosa namolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dilia idihë namialo. Nelebo amoli hamola made neebe amo gaalu, na dilima dafidi säla ïahagomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesuea aso, sähamu nea sähalea, Yöi yafie elö elöla hamosa maadeibua eso usilahilä, aube made neëla, ");
INSERT INTO etr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","gasumilï mudaiala besela didigafula, mudaia nelebo geloi hïdo elöi amea fogolasimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Amala hamose amo gaalu, Dolöïe Malö amoda geloi hïdo elöibaläge yo digalo hïdo elöibaläge mu baidilidaia maala neë bimolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bease amo gaalu, ea ïe selesaia fii amolima mosalolahilä, udia dolö hï memelei sege föi sulubadelagi, agesu näiado nefolalebe amolige, näiado nefolalebe amolige, sege afädëgi neala gedolasimolö mosalola sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesuea aso, sähamu nea sähalea, Diliada äfäeoïe mala amogi helësëmäia sähago. Äfäeo fësëgësisila, bäu gähe bobagiseda, dilia helësësalea, sege esomolöda hä ga made gabula helësëlomelë. ");
INSERT INTO etr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Amo gadola wäla, dilia nelebo säi amo gadoi hamose beaseda, Dolöïe Malö amo hä moholö suägïsa gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na dilima dofä gelola sähago. Udia dolö walio nefolalebego made baagola nefolalegi wäla, nelebo säi amoli sulubadela hamosa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mu giwige naga föige hogosa helemolö gaso, nïe ado malada dofä made hogosa helemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesuea aso, sähamu nea sähalea, Amala hamomolö amoda segeyoge, aoage afädëa dawa mademelë. Selesaia fii iliage, malöeage dawa mademelë. Naado eamu hïdo dawadigi neamelë. ");
INSERT INTO etr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nelebo amoli hamomolö amo gowe gala gabula, dawa made ameada, dilia hedabola idihë namialo. ");
INSERT INTO etr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Amoda gowe gadoimelë. Dolö afädëa, ïe mosö dïgïla, sege wagadi made aulo amo gadola awähalea, ïe hamoi hamolasiloma, ïe hamoi beaha namialola säla, hïdo hïdolama hamoi sogosa maadelahilä, idiliba beaha aligilo amoma sähalea, Hedabola beaha namialola säsila aulomelë. ");
INSERT INTO etr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Mosö eedo amoda së gäse gaalu obëgëmolöledu ma, gasi mogogi obëgëmolöledu ma, haea gäse gaalu obëgëmolöledu ma, yose obëgëmolöledula dilia dawa made neebe ameada, dili oböla adi elaboi diëgi fodolofalï muloea, idihë namialo. ");
INSERT INTO etr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na dilima ado säla ïasewe gadola, udia dolö sulubadelamage, dili idihë namialola säla ïahadiola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Segeyo äudä nelolahilä, osodagi Baagila Asi Segeyo amoïe molö molö amoda, Beledi Yidila Made Gobei Segeyo amoïe gabula helësëlahilä, gobela ïlo busa nefolalo amolaliage, mala dawadigi nefolalo amolaliage didiähalea. Yesuma wäfalï abeahäla sälahilä, e gaula nufulödula säla didiäha difolalo. ");
INSERT INTO etr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ilia sähalea, Segeyo Edefadegi gedola molö nasolo amo galada, amala made hamodelä, udia dolöea nilïbalä nuduloeala säi. ");
INSERT INTO etr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu eda sege Bedani ami Saimono dafidi gudubu hamoi nelo amea mosöa molö naha sulo. Ami sebegi, udia afädëa weli hedabi gafisigäi hïdo elöi, amoïe ëida nada. Weli amoda muni edefadea nelo ödä i igia hamoigi osala negei dilo. Amo gaula maala dusulahilä, Yesuïe busagia söga negei. ");
INSERT INTO etr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Amala hamosebegi, udia dolö odoa sefolalo amolia habobalahilä, hilidomu sähalea, Weli gafisigäi we memalä edoïe waeasesadu. ");
INSERT INTO etr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Weli gafisigäi egoweda gina hädali ohodoa gadoi nii galebeda, dolö busadäoi nefolalebe amoligali mogela ïalabio gabula säla, ilia udia amoma habobala baagido säha dilo. ");
INSERT INTO etr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amala säsebegi, Yesuea ilima sähalea, Beasimo. Edoïe ema habobala baagido säha. Udia gowea nema hamoi amoda, hedabi hïdo elöi hamoimelë. ");
INSERT INTO etr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Udia dolö busadäoi nefolalebe amolida dilibalä namolöi namolömelë. Abodo gala dilia ili ugila negemolöila helësëseda, amoda dilia ugila negemolö dofea. Gaso, neda dihilibalä namolöi namolö mademelë. ");
INSERT INTO etr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Udia goweada hamomolöi beala hamoimelë. Ea nïe domalogi nada hëi amoda, hobea nïe domalo baumolö amoïe, dafidi daiala hëimelë. ");
INSERT INTO etr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na dilima dofä gelola sähago. Ado Mala Hedabi sege föi sulubadelagi säla olelesaleada, e helësëla, ea walio nema hamoi amo säla ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Amalahilä bëgëla aulo giwilasi amoligi Yudasa Isagaliadaea gobela ïlo busa neebea ami awälahilä, ilia Yesu nufuäia hololömolö asi. ");
INSERT INTO etr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ea säi amo nabala ilia obeägïlahilä, egali muni ïmolömelëla säla negei. Amalebe ea Yesu hololöla gaula ïmolöïe fu hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Segeyo agegi Beledi Yidila Made Gobei Segeyo amo besela galaseda, Isilale iliada Baagila Asi Segeyo amoïe sugua sibi malö nufidelo. Segeyo amo gala, ïe bëgëla aulo amolia Yesuma nabahalea, Baagila Asi Segeyo amoïe molö molöda nilïa abidi daiamäia hamesebela nabi. ");
INSERT INTO etr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Amala nabasebegi, ea ïe bëgëla aulo äudä mosalalahilä, elema sähalea, Ali awäla gaamugi besela galahamelë, dolö afädëa ödä iigi usi gaui maaha neëgi, gausiamolömelë. Alige dolö amo bëgëla mosalo. ");
INSERT INTO etr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Alia beahamelë, dolö amo mosöa nogila digaseda, alia mosö eedo amoma gomalä sämalo. Säla Olelelo neebe amea dima nabahalea, nïe bëgëla aulola nilï Baagila Asi Segeyoïe molö molöïe nïe mosö hogoli abidi dialeala nabimelëla sämalo. ");
INSERT INTO etr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Amala säseda, ea hogoli edefade daia dilo amogi, filo aulige molö negelo aulige daiala negesa maadei dilo amo olemolömelë. Ami nilï molö molöïe daiamalola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Amala säi amo nabalahilä, ïe bëgëla aulo äudä amole awäla, Yalusaleme besela galalahilä beahamelebe, ea säi amo gadola sulubadela gausiala digaha maadesebegi, elea Baagila Asi Segeyo amoïe molö molö daiai. ");
INSERT INTO etr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Deadi Yesula ïe bëgëla aulo giwilasi amobalä misi. ");
INSERT INTO etr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Maalahilä ili molö naha sefolalea Yesuea sähalea, Na dilima dofä gelola sähago. Dili sebegogi afädëa ne hololömolömelë. Dolö amoda nebalä molö naha saleala säi. ");
INSERT INTO etr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Amala säsebegi, ilia asigia yölahilä, ema hïdo hïdolaea dafidi hobeala säla didigahalea, Nale ma, nalela säla didigai. ");
INSERT INTO etr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Amala säla didigasebegi, Yesuea ilima säla obëgësalea, Dili giwilasi sebegogi afädëa nebalä falo afädëdaia beledi ua negela naha sebe ameamelë. ");
INSERT INTO etr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dolöïe Malö amoda bebagi ïe dëdëla negei dibe amo gadola baagomolö. Gaso, Dolöïe Malö e hololöla, odoaïe naabogi gausise dolö amo, asigiisebemelë. E emea made neegela ägüi galebeda, e hedabi aligilabiomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ili molö naha sefolalea, Yesuea beledi afädë neala gaula nea, Godema nesegelahilä, beledi amo dagabodasila ïe bëgëla aulo amoligali ïa gogosalea sähalea, Nimo. Nïe domalo gomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Amalahilä, ea wani ödä usi amo neala gaula nea, Godema nesegelahilä iligali ïasebegi, ili sulubadelaea neala mai. ");
INSERT INTO etr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ea ilima sähalea, Goda nïe healemelë. Asialo made ado säla negei amoïe mida nïe heale gogi dialea. Amoda udia dolö ugila negela sulubadela gali sögaha. ");
INSERT INTO etr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na dilima dofä gelola sähago. Ne wani ödä bu elö made naala nelolahilä, Godea Beaha Maadela Sigi Neebea ami nea, bu gähe elö molömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ili molö naha madela gë afädë udälahilä, Olibe bi daia fedafiai. ");
INSERT INTO etr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuea ïe bëgëla aulo ilima sähalea, Dilia asigi afädë negeigo sulubadela digaha maademolömelë. Mida, bebagi ado gomalä säla dëdëla negei dialea, Godea sähalea, na sugua sibi sigi aligilo neebe amo nufudaseda, sugua sibi nefolalebe amoli dusudasila fisäla afiaha maademolömelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amai gaso, Godea ne nowelasisegi, dili baagila dafidi nedale Galili moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Amala säsebegi, Fidaea säla obëgësalea, Ili sulubadela fisäla awäseda, neda made fisäla moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Amala säsebegi, Yesuea ema säla obëgësalea, Na dima dofä gelola sähago. Walio gasigi haea gagalugo gawalia nafi bu äudä made gäla neëgi, dia ne dawa madela nafi bu ohodoala sämolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amala säsebegi, ea gelolafalï säla obëgësalea, Ne dibalä baagomolö nea galëda, na di dawa madela dofä made sämolömelëla säi. Ili sulubadelaea amo gadolamu säha maadei. ");
INSERT INTO etr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesula, ïe bëgëla aulolali sege ëi Gesemani ami afialahilä, ea ïe bëgëla aulo amolima sähalea, Ne Godema adomolö awäsewe gaalu, dili wi sefolamialola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Amala sälahilä, ea Fida Yamese Yonela ilimu sigi awälahilä, ïe iso asigigi fudugila yöla säosäomolö mi gäwila besela galasebegi, ");
INSERT INTO etr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ea ilima sähalea, Nïe iso asigigi edefademalä yösalea, ne baagomolö gabumelë. Dili gui salea idihë namialola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Amala sälahilä e holöbö aliga gala nagadaia gumusula dia idogolahilä sähalea, Asiamolö fu galëda, nema walio hamomolö amo asiamalola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ea sähalea, Aba-o, Naado-o, dia nelebo sulubadela hamosa maademolöi nebego. Nema ödä iigi usi dibe amo dia nea nimalo. Amai gaso, na helësësewe gadola made, dia helësëse amo gadola hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Amala sälahilä e obëgësamelebe, ili süwia adidi dibe amo beala, ea Fidama sähalea, Saimono-o, di adi dialeale. Fu oboba gogi dia idihë namolö ulïsebele. ");
INSERT INTO etr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nafadea dili digalasiloea, idihë nea Godema adosa namialo. Dofä, asigiada hamomolö helësëi neago gaso, domalo wäbëai nebegola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Amala säsila e bu awäla, dafidi säi amo gadola säha sulo. ");
INSERT INTO etr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Amala sälahilä e bu obëgësamelebe, ili aso adidi dibe melï. Mida, süwiaea ilile si gafodo gadugisalea amai. Ameada, ilia ema edo säla obëgëmolödula asusugai. ");
INSERT INTO etr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","E bu osoda obëgëlahilä, ea ilima sähalea, Dili hele salea adidimu dialeale. Amo dofea. Bimo! Dolöïe Malö amo nafade hamolo amolima gaula ïmolö fu hä besela galai gabuwe. ");
INSERT INTO etr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nowemo. Nilïa hä gausiala afiadila säi. Ne gaumäia hololölo amoda ga made misi nebego bimola säi. ");
INSERT INTO etr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuea amala säha nebegi, ïe bëgëla aulo giwilasi amoligi Yudasa e dolö maleibalä fodolofalï misi. Ilia helebe baialage gagaula ebalä misi. Gobela ïlo busa amoliage, mala dawadigi amoliage, asigi gäwi dafidilo amoliage ili mosalola säsebegi misi. ");
INSERT INTO etr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesu gaumäia hololölo amea ilima dafidi daiala sähalea, Na gomalä hamoseda, amo gabula helësëmalo. Na dolö amo mimila nödöseda, amo hedabola gaulahilä sigi mosalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ea säi amo gadola Yesu neebea fodolofalï maala aligilahilä sähalea, Säla Olelelola säla, Yesu mimila nödöi. ");
INSERT INTO etr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mimila nödösebegi, ilia e gaulahilä naaboea gaula fëdöi. ");
INSERT INTO etr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amala hamose amo gaalu, dolö afädë ami nelo amea helebe besela nealahilä, gobela ïlo busa edefade amoïe hamoi hamolasilo neebe amoïe gëhe dagala salisi. ");
INSERT INTO etr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuea ilima sähalea, Fa nelo gaumolöïe mulo amo gadola, helebe baialage gagaula ne gaumolö misile. ");
INSERT INTO etr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Segeyo yafiegi ne dilibalä nea, Godeïe mosöa ado mala olelesa nelo amogi ne dilia made gaui. Amai gaso, bebagi ado säla dëdëla negei dibe amo gadola hamomäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Amasebegi, ïe bëgëla aulo amoli sulubadela e dïgïla fisäla awäha maadei. ");
INSERT INTO etr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Malö malïsä afädë fagulo bulula gälahilä Yesu bëgëla awäha nebegi, dolö amolia e gaui. ");
INSERT INTO etr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Amasebegi, fagulo bulula gäi amo ilima amilahilä e dudugïmu fisäla asi. ");
INSERT INTO etr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu e gaulo amolia e sigi gaula gobela ïlo busa edefade sebea ami sigi asi. Gobela ïlo busa amolige, asigi gäwi dafidilo amolige, mala dawadigi amolige gedola ami sefolalo. ");
INSERT INTO etr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Fida e Yesu bëbëgëla asi. Gaso, eda holöbö hobea hobeala awälahilä, gobela ïlo busa edefade amoïe mosö yala isogi nogila digalahilä, idihë aligilo amolibalä nulo gobeia ami hëgï hausa sulo. ");
INSERT INTO etr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gobela ïlo busa amoliage, Galïsolö dolö amoli sulubadelaeage, dolö odoaeage Yesuea asiala hamose melëlo amoli misialolahilä, ilia säla ulufamalai. Ilia e nufuäia ea asiala hamoi walebelela hogosamelebe, afädë maade melï. ");
INSERT INTO etr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dolö yafiea ea made hamoi amo ilima wäfalï baala säla ulufai gaso, ado afädëdi made melï. ");
INSERT INTO etr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Odoaea nowela nea ea made hamoi amo baala wäfalï sähalea, ");
INSERT INTO etr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nilïada ea gomalä säse nabimelë. Godeïe mosö dolöïe naaboea hamoi amo, ea haila digila, segeyo ohodoagi ea bu ulimolö amoda, dolöïe naaboea olelo amo gadola made, ulimolö säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ilia amala säla ulufai amoge aso afädëdi made melï. ");
INSERT INTO etr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Amala säsebegi, gobela ïlo busa edefade amea dolö sefolalebe amoli mogogi nowela aligilahilä, Yesuma nabahalea, Dia ado afädë made säla obëgëmolöle. Ilia dia asiala hamoila säsegoda edo hamoila nabi. ");
INSERT INTO etr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesuea nafi dagala made säla obëgësebegi, gobela ïlo busa edefade amea ema bu elö nabahalea, Dida, Afädë Memelei Gode hedabi hïdo elöi neebe amoïe malöda dilela nabi. ");
INSERT INTO etr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Amala nabasebegi, Yesuea säla obëgësalea, Ä, neda amomelë. Dolöïe Malö e Gode Geloi Edefade Neebe amoïe naabo dafädimadi fila, mu baidilidaia maala neëda, dilile siia bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Amala säse amo nabala gobela ïlo busa edefade amea mihaläla hïle fagulo nulilahilä sähalea, Ea hamoi amo sämäia odoa ili misialola nalï sämabio. ");
INSERT INTO etr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ea Gode gagadese nabi amo, dilia abilia helësësebela nabi. Amala nabasebegi, ili sulubadelaea sähalea, Ea asiala hamoi amoïeda, e baagomäia nufulö dialeala säla didigai. ");
INSERT INTO etr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Amala sälahilä odoaea e gofedela galala, ïe si usulala naabo gafea nufudalahilä sähalea, Di dolö gowea nufila dihï olemola säi. Amase, idihë aligilo amoliage elöea nufudala elöeaha nelo. ");
INSERT INTO etr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Fida e yala isogi nogila digala sebegi, gobela ïlo busa edefade amoïe hamoi hamolasilo dolïsä afädë maalahilä, ");
INSERT INTO etr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Fida e hëgï hausa sebe amo fädäla bealahilä sähalea, Dige Nasalese dolö Yesubalä nawesa aligilo amo gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amala säsebegi, Fidaea ne mademelëla sälahilä, dia ado säsebegoda, na dofä dawa mademelëla säi. Amala sälahilä e mosö amoïe idi galo baagido awäha nebegi haea Gagalugoea gäi. ");
INSERT INTO etr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hamoi hamolo dolïsä amea e bu bealahilä, dolö nefolalo amolima sähalea, Dolö goda amoligimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amala säsebegi, Fidaea bu elö sähalea, ne mademelëla säi. Holöfalï nelolahilä dolö nefolalo amolia Fidama bu elö sähalea, Dofä. Dida amoligi. Dige Galili dolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Amala säsebegi, Fidaea gelolafalï säla gabulo amo gadola migalïa diigila sähalea, na we wäfalï säseda, Godea ne dofä së ïmäiamelëla sälahilä, Dilia dolö ëi säse goda na dofä dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ea amala säia gai amole haea gagalugo gawalia nafi bu äudä gäi. Fidaea amo nabalahilä dafidi Yesuea, haea gagalugo gawalia nafi bu äudä made gäla neëgi, dia ne dawa madela nafi bu ohodoala sämolömelëla säi amo helësëi. Amo helësëla gäia güsäla dïisa nelo. ");
INSERT INTO etr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yosefalï gobela ïlo busa amolige, asigi gäwi dafidilo amolige, mala dawadigi amolige, Galïsolö dolö amoli sulubadelage gegedolahilä ilia hamomolö amoïe ado didiäha dilo. Didiäha dilolahilä ilia Yesu e igi ëfëa nafodolahilä Bailadi neebea sigi asi. ");
INSERT INTO etr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sigi maasebegi, Bailadia Yesuma nabahalea, Yu udia dolöïe beaha aligilo ginida dilela nabi. Amala nabasebegi, ea säla obëgësalea, Dia säse gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gobela ïlo busa amolia ea nafade yafie hamoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ilia amala säsebegi, Bailadia ema bu elö nabahalea, Dia ado afädë made säla obëgëmolö neale. Iliada, dia nafade yafie hamoila säi amo nabilela nabi. ");
INSERT INTO etr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amala nabase amogi Yesuea ado bu elö made säla obëgësebegi Bailadi e fudugisa nelo. ");
INSERT INTO etr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gäheo i sulubadelagi Segeyo Ede amoïe molö nülo segeyo amogida, udia dolöea galabaia negei amoligi ëi säla gowe fisigämola säsegi Bailadia fisigähamu aligilo. ");
INSERT INTO etr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Segeyo amo gaalu, dolö odoaea gamanebalä nudusalea dolö odoa nufudasebegi, ilia ili galabaia negei. Amogi dolö afädë galabaia negei nelo amoïe ëida, Balabasa. ");
INSERT INTO etr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Udia dolö gegedoi amolia Bailadi neebea maalahilä, ema sähalea, Dia nilïma gäheo i sulubadelagi hamolo amo gadola walio hamomäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ea ilima säla obëgësalea, Na Yu udia dolöïe beaha aligilo gini dihilima fisigämäiala helësësebelela nabi. ");
INSERT INTO etr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Amala nabi amoïe mida, gobela ïlo busa amolia Yesuma mudiala mihalälahilä, e sigi gaula misi gabula helësëla, Bailadia amala nabi. ");
INSERT INTO etr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gaso, udia dolö gegedoi amolia Bailadima, Balabasa hilima fisigämäiala gelola sämäia gobela ïlo busa amolia ilima si nigilasi. ");
INSERT INTO etr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bailadia ilima bu elö nabahalea, Diliada, Yu udia dolöïe ginila sälo neebe gowema, na abilia hamomäia helësësebela nabi. ");
INSERT INTO etr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Amala nabasebegi, ilia bu uuala sähalea, Eda i fügäigi baala negemalola säi. ");
INSERT INTO etr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Amala säsebegi, Bailadia ilima sähalea, Mi edogi. Ea edo nafade hamoi gabiola nabi. Amala nabasebegi, ilia gelola uala sähalea, I fügäigi baala negemalola säi. ");
INSERT INTO etr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Amala säsebegi, Bailadia, udia dolö gegedoi amolia obeägïmäia, Balabasa hilima fisigälahilä, ea ami dolö amolima Yesu fëgämalolahilä, i fügäigi baala negemolö sigi mosaloi. ");
INSERT INTO etr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami dolö amolia Yesu sigi gaula gamane beaha aligiloïe mosö yala isogi nogila digai. (Mosö amoïe ëida Beledoliama.) Ilia ami dolö odoa misialosebegi ili mafula gegedoi. ");
INSERT INTO etr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gedolahilä, ilia fagulo sedade hogale uii Yesuma salugasilahilä, ëfë äyo gägäi amalela nasigïla giniïe habuga gadoi hamola ïe busagia salugasi. ");
INSERT INTO etr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Amalahilä ilia naabo sögödigila sähalea, Yu udia dolöïe beaha aligilo gini, namolöi namiäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Amala sälahilä, ilia ïe busagia buudi damuia nufudalahilä, gofedela gagalai. Amalahilä, ilia ïe ëi gauia adogose gadoi hamola gumusula dia digafui. ");
INSERT INTO etr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ilia e gagadela hamomolö amo gadoi hamosa maadelahilä, fagulo hogale uii sedade gäsi amo giilahilä hïle fagulo amo salugasi. Amalahilä e i fügäigi baala negemolöïe segea sigi asi. ");
INSERT INTO etr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ili idiafa afiaha dibegi Sailini fii dolö afädë ïe ëida Saimono. Alegisäda Ulufasalele eedo amo, sagaiala maaha nebegi gausiala digalahilä, ami dolö amolia ema Yesuïe i fügäi gaumo gaumola eegedigi. ");
INSERT INTO etr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ilia Yesu sigi gaula sege ëi Gologoda asi. (Gologoda nilïle ado adolada Busa Giwi Sege.) ");
INSERT INTO etr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ilia wani ödäge i afädëïe ödä muwege gegoalahilä egali muäia ï gaso, ea made mai. ");
INSERT INTO etr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Amalahilä, ami dolö amolia e i fügäigi baala negei. Ilia ïe fagulo amo nowëa nimabelela, ilia sadu dahilahilä, ïe fagulo amo amala mogei. ");
INSERT INTO etr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yose eso neëla udigisa nebegi, ilia e i fügäigi baala negei. ");
INSERT INTO etr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ea nafade hamoila sälo amolia dëdëla negesalea, Yu udia dolöïe beaha aligilo ginila säla dëdëla negei. ");
INSERT INTO etr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Amase, Yesu baala negei amo gaalu, fa nelo dolö äudä, elö ïe naabo dafädimadi, elö ïe naabo fefeädimadila, i fügäigi baala negei. ");
INSERT INTO etr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Udia dolö e dibeadi baagila afu mafusalea, Yesu gagadiabola busa dugagila ëhehelahilä, Godeïe mosö haila digila segeyo ohodoagimu ulimolö säi amo, ");
INSERT INTO etr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","dihïmu damula awäla i fügäi daia adogoila digamola säla baagi baagisa nelo. ");
INSERT INTO etr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Amo gadola wäla gobela ïlo busa amoliage, mala dawadigi amoliage Yesu gagadiabola säla didigahalea, Eada udia dolö odoa ugila negela wahilo amo gadola, e hïmu ugila negemolöi made gabugi dialealedu. ");
INSERT INTO etr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nilïa ema asigi afädë negedeläïe Afädë Memelei, Isilale udia dolöïe gini ameada, e i fügäi daia adogoila digamäia. Nilïa amo beala asigi afädë negedeläla säi. E baala negei gaalu, baala negei äudä amoleage e gadiabola amo gadolamu säi. ");
INSERT INTO etr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Eso mogogi gasila, sege sulubadela gasilasi dialeamu deadi eso digase gaalu yo digala obëgëi. ");
INSERT INTO etr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Amala hamose amo gaalu, Yesuea gelola uuala sähalea, Elöi, Elöi, lama sabagadanila säi. Nilïle ado adolada, Nïe Gode, nïe Gode, abisigi ne dïgïla asi. ");
INSERT INTO etr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Amala säi amo nabalahilä, udia dolö odoa ami nefolalo amolia sähalea, Nabuö. Ea Elaia wesebegola säi. ");
INSERT INTO etr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Afädë baluluia awälahilä, nelebo afädë dahudu gadoi wani ödä gamogai dibe amogi gelahilä, i bidigi yaala, egali muäia ïalahilä sähalea, E i fügäigi dibea adogoi, Elaiaea fisigämolö maasebelela aso, beaha aligidila säi. ");
INSERT INTO etr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesuea uuala gelola sälahilä hame doala asi. ");
INSERT INTO etr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Amasebegi, gobela ïlo mosöa fagulo edefade gosagisi dilo amo, gadogola gadelala digalahilä, elö eamu eamula negesi. ");
INSERT INTO etr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ami dolö hädali afädë beaha aligilo amea Yesuïe odagiamadi nea, sida adogola beahamelebe, Yesu hame doala asi amo bealahilä, Dolö goda dofä Godeïe malö gabula säi. ");
INSERT INTO etr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amo gaalu, udiafalï holöbö wagadi madela nea, sida gala nefolalo amolida, Magadala udia Melige, Yamese elö Yosese elele eme Melige, Salomege nelo. ");
INSERT INTO etr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Dafidi Yesu e Galili neëgida, udia amoli e awäse amo gadola awälahilä, e ugila negesa aligilo. Udia odoa yafie ebalä Yalusaleme misi amolige nefolalo. ");
INSERT INTO etr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Segeyo amoda nelebo daialo segeyo. Sabada segeyo aiyo namolö gabula helësëlahilä, ");
INSERT INTO etr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Deadisebegi, Alimadia dolö Yosebe e misi. Eda galïsolö dolö amoligi afädë nelo. E udia dolöïe siigi hedabi neada, Godea Beaha Maadela Sigi Neebe amoge ea beaha nelo. Eada bedälo made mumulasi amea, Bailadi neebea awälahilä, Yesuïe domalo nimolö audulela nabi. ");
INSERT INTO etr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Amala nabasebegi, Bailadia e aabela baagoi gabula fudugilahilä, ami dolö hädali afädë beaha aligilo amo welahilä, e hä baagoilela nabi. ");
INSERT INTO etr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Amala nabasebegi, Bailadima ami beaha aligilo amea, e hä baagoimelëla säi. Amo nabalahilä, ea Yosebema sähalea, dofea ïe domalo nimolöla säi. ");
INSERT INTO etr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Amala sälebegi Yosebea fagulo falei hedabi afädë nealahilä, ïe domalo i fügäidaia dibe amo neala gaula digala, fagulo amea usulala gaulahilä, igi äbä dafidi duwi diloa ami baumolö gaula asi. Gaula awäla bausilahilä, igi edefademalä afädë bebugula gaula maala idi gasi. ");
INSERT INTO etr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Amala bause amo Magadala udia Melile Yoseseïe eme Melilea melï. ");
INSERT INTO etr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Segeyo Sabada gafe baagibua, Magadala udia Melige Yameseïe eme Melige Salomege ilia Yesuïe domalogi hëla moholöïe, weli gafisigäi hïdo elöi amo bidia nii. ");
INSERT INTO etr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Segeyo gifalädalügi yosefalï ili igi äbägi bauia ami afiai. ");
INSERT INTO etr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hilido afiaha dialea sähalea, Bausalea, igi edefadea gai dibe amo, nowëa nilï ugila negela bebugula fisiga gala dogasimolödula säsäla afiai. Igi amoda dofä edefade amo helësëla amala säi, ");
INSERT INTO etr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ili ami besela galamolö nea sida gala beahamelebe, igi edefadea gai dilo amo bebugula nigia gala doga negei melï. ");
INSERT INTO etr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Beala ili awäla äbä isogi nogila digalahilä bauia ami beahamelebe. Malö malibu afädë fagulo falei sedade gäi ilile naabo dafädimadi sebe amo beala, ili fudugi. ");
INSERT INTO etr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ea ilima sähalea, Dilia fudugimabu. Dilia Nasalese fii Yesu, ilia i fügäigi baala negei amo hogola misi goda, na helësësa. E hä nowela asimelë. Eda wi maade. Ilia e negei diloa amo bimo. ");
INSERT INTO etr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hä dili afiala Fidamage ïe bëgëla aulo odoa amolimage säla ïahaleada, Ilia e Galili bimolömelëla dafidi säla ï amo gadola, eda edale Galili moholö awäha neamelëla säla ïmalola säla ï. ");
INSERT INTO etr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Amala säi amo nabalahilä, ili igi äbä isogi amila fodolofalï doadigila fedala afiaha dialea, edefademalä bedäla emo gigisëla fudugila aligi afiai. Ili afiahalea udia dolö odoabaläge made adoi. Mida, ili bedäi afiahalea amea. __________________  ");
INSERT INTO etr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Segeyo gifalädalügi yosefalï Yesu e nowelahilä, Magadala udia Melia bimäia e sebeadale e ulufala besela galai. Dafidi udia amoma mugabe gifalädalïa fedai sebegi Yesuea nesila digi. ");
INSERT INTO etr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Besela galai amo bealahilä, Yesubalä dafidi nawesa aligilo amolia e asigiila dïisa dibea ami säla ïmolö asi. ");
INSERT INTO etr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Awälahilä Melia ilima sähalea, Yesu hï nowela asi amo na melïmelëla säi. Amala säsebe amo ilia nabi gasoda, dofä gabula made helësëi. ");
INSERT INTO etr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hobeala ïe bëgëla aulo äudä Yalusalemela ididila awäha nebegi, elea e bimäia Yesu e domalo elölahilä besela galai. ");
INSERT INTO etr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Amo bealahilä ele obëgëla awäla bëgëla aulo odoa amolima säla ï gaso, ilia dofä gabula made helësëi. ");
INSERT INTO etr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Amalahilä hobeafalï ïe bëgëla aulo gïdälasi amoli molö naha dibea ami Yesu e ulufala besela galai. Ulufala besela galalahilä, ilia asigi afädë made negei amogige, iso asigi geloi neebe amogige, odoa ilia hï nowela neebe melïmelëla säi amo nabala dofä gabula made helësëi amogige ea ilima nemoi. ");
INSERT INTO etr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Amalahilä ea ilima sähalea, Dili sege föi sulubadelagi afufulahilä, udia dolö sulubadelama Ado Mala Hedabi säla ïmolö mosalo. ");
INSERT INTO etr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Afädëa asigi afädë negeseda, ödägi gelahilä damula aulo neala gaumolömelë. Be afädëa asigi afädë made negese amobaläda gudila së ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Asigi afädë negei neebe amoliada, dolöea hamomolöi made gowe gadoi hamomolömelë. Nïe ëigi nea mugabe fedai nesila digimolöge, udia dolö odoaïe ado adomolöge, ");
INSERT INTO etr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","baagolo nuba gausege baagolo ödä nasege made baagomolömelë. Oloi difolalebe amoli ilia naaboea diigiseda wahimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dafidilo Geloi Yesuea ilima ado amo säla ïaha maadelahilä, selesaia mosöa fedala Godeïe naabo dafädimadi awäla sulo. ");
INSERT INTO etr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E asibua ïe bëgëla aulo amoli sege sulubadelagi afufulahilä, ado mala säla ïaha nebegi, Dafidilo Geloia ilibalä hamoi hamolasila, ilia säsebe amo dofä säsebela helësëmäia, dolöea hamomolöi made gadoi hamolasi. __________________ ");
INSERT INTO etr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Mi gäwila hamoi amo siia bealahilä, ado mala amoïe hamoi hamolasilo besela galala nefolalo amolia nilïma säla ï amo gadola, nilï neebeawi gausiala digai amoïe dolö yafiea dëdëmolö helësësa nelomelë. ");
INSERT INTO etr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Amaimo, dafidilo Diofilasa-o, nelebo sulubadela mi gäwila hamoi amo nihï mi fädäla nabaha nelo amea, ado dima olelei amo dia dofä gabula helësëmäiaïe, nage dima mogola dëdëla ïmolöla helësëimelë. ");
INSERT INTO etr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heledo e Yudiaïe gini nelo amo gaaluda, gobela ïlo afädëïe ëi Segelaea nelo. Eda gobela ïlo Abia ea beaha neloamadi gobela ïlo nelo. Ïe udia amoïe ëida Elisabede. Eege ïe yaua mäu Alono nelo. ");
INSERT INTO etr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Eleda Godeïe siigi asigi mogoi nelo. Elea amala neada, Dafidilo Geloiïe ado säla negei dibe amoge, ado malage, elea sulubadela bëgëla hamolo nea, elema asiai maade, hedabi nelo. ");
INSERT INTO etr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gasoda, ele malö maade sulo. Mida, Elisabede e malö maade, haua salea, helegela ëdëi sali hamoi sulo. ");
INSERT INTO etr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Segeyo afädëgi, Abiamadi nefolalo amolia odala ï gobela ïmolö amo galada, Godeïe siigi nea, Segelaeaea odala ï amo gobela ïmolö nelo. ");
INSERT INTO etr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Gobela ïlo amolile mala amo bëgëla, Dafidilo Geloiïe mosö auli dibea ami höba gafisigä hedabi fedamäia gobemolö amo dolö nowëa walebelela sadu hamola beahamelebe, Segelaeaea nogila digala gobela ïmolö melï. ");
INSERT INTO etr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hä, e isogi nogila digala gafisigä fedamäia gobese amo gaaluda, udia dolö gegedoi amoli sulubadela mosö amo baagido segea nea, Godema adosa nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Segelaeaea amala hamosa nebegi, gafisigä fedamäia gobelo auli amoïe dafädimadi, Dafidilo Geloiïe selesaia fii afädë Segelaea neebea ami maala ulufadigila nelo. ");
INSERT INTO etr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Segelaeaea e beala, edefademalä fudugila bedäi. ");
INSERT INTO etr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Fudugila bedäsebegi, selesaia fii amea ema sähalea, Segelaea-o, dia bedämabu. Dia Godema adoi amoda Godea hä, nabi. Dïe udia Elisabedea dïe dolö malö afädë sogobamolömelë. Malö amoïe ëida Yone negemalo. ");
INSERT INTO etr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dïe iso asigi ea hedabolasila obeägïlasimolömelë. Udia dolö yafie nefolalebe amoliage, e neegela ägüse amogi obeägïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mida, Dafidilo Geloiïe siigi eda ëi sälo namolö. Eada wani ödäge, gagaolo ödäge molö mademelë. Eda emea made ägüla maala isogi seëgi, ema Eleloi Gesami nobai namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eada Isilale udia dolö yafie asigi besulasila, ilile Dafidilo Geloi Gode mia sigi obëgësa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eda malage geloige Elaia nelo amohï gadoi nea, Dafidilo Geloi hobeala misiäia, dafidila awäha namolömelë. Eada eedolali asigi besulasila, eedolalia ilile malësäma helësëlasimäiage, amase, udia dolö ado neadigilo neebe amolige, asigi besulasila asigi gäwi neebe amolia asigi falagasela helësëlo amo gadola helësëmäiage, ea ili helësëlasimolömelë. Dafidilo Geloi misiäia beaha nea, ea udia dolö hamogilahilä dadaiala namialamolömelëla selesaia fii amea säla ï. ");
INSERT INTO etr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amala säsebegi, Segelaeaea selesaia fii amoma nabahalea, Neda ëdëi sali, amase, nïe udiage sesalebe hamoi sebe amo, dia walio ado säi amoda, dofä gabula nada abilia helësëmolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Amala nabasebegi, selesaia fii amea säla obëgësalea, Neda Gabelelo. Gode neebea amimu aligilo. Ado hedabi we dima säla ïmäia, ea ne fisiga weimelë. ");
INSERT INTO etr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ä, dia nabuö. Na ado säi amo dia dofäla made helësëse goeada, walio dïe nafi dofogahago. Na ado säsebeweda, Godea daiala negei segeyo gausiala digasolo amo gala, gausiala digamolömelë. Dia adola made nea, nelebo Godea hamomolömelëla na dima säla ïasewe gausiasolo amo gala, dia adomolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Segelaeaea amala hamosa neebe amo gaalu, udia dolö e beaha nefolalo amolia Godeïe mosö isogi sedadeseweda abeahäla hamosadula helësëlahilä, asigiamu hogosa nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hobeala, Segelaea e segea doadigila fedalahilä, ilibalä adomolö ulï nelo. Adoea sämolö amo ulï nea, ea sämolö helësëi amo naaboeamu oodo bibila säla ïasebegi, ilia helësësaleada, Godeïe mosö isogi idogoi sosoäla awäla melï gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Holöfalï nelolahilä, ïe hamoi hamolo segeyo amoligi hamosa maadela, Segelaea e hï mosöa obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hobeala, ïe udia Elisabedeïe isogi malö fagulo hagui aube bia mosöamu musügä sulo. Amala salea Elisabedea sähalea, ");
INSERT INTO etr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dafidilo Geloia ne ugila negesebe weada, segeyo wegi ea ne helësëla, udia dolöïe siigi ne hewalasilo amo haisa maadeila säi. ");
INSERT INTO etr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabede e malö fagulo hagui aube gafe sebegi, Godea selesaia fii Gabeleloma, di Galiliïe sege ëi Nasalese gaamugi mosaloi. ");
INSERT INTO etr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","E udia dolïsä afädë Gini Debidi sosogo nelo amogali säi sebea ami asi. Dolö amoïe ëida Yosebe. Dolïsä amoïe ëida Meli. ");
INSERT INTO etr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amala hamoi sebegi, Gabelelo e dolïsä amo sebea ami awälahilä, ea säla olesalea, Udia malö, di go gabio. Dafidilo Geloi e dibalä gedola nea, edefademalä obeägïsa namiäia, di neala dofä obeägïlasimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ado säi amo Melia nabala edefademalä fudugila bedäla, ea säla olei amoda, abeahäladula asusugala helësësa sulo. ");
INSERT INTO etr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Amala helësësa sebegi, selesaia fii amea ema sähalea, Meli-e, dia bedämabu. Godea di helësëla, dimada obeägïsa neamelë. ");
INSERT INTO etr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dia malö fagulo hagui sulolahilä, dolö malö ägümolömelë. Malö amo ägüseda, ïe ëi Yesu negemalo. ");
INSERT INTO etr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Malö amoda, ëi sälo namolömelë. Udia dolö sulubadelaea eda Dofä Ilibia Edefade neebe amoïe malö neala sämolömelë. Dafidilo Geloi Godea e ïe yaua mäu Debidiïe beaha aligilo filodaia samialamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eda Yeigabaïe mosö amoli beaha namolöi namolömelë. Ea Beaha Maadela Sigi Neebe amoda, namolöi namolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Amalebegi, Melia selesaia fii amoma nabahalea, Neda dolö made fii sebe amo. Walio dia ado säi amoda, abilia hamola hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Amala nabasebegi, selesaia fii amea ema säla obëgësalea, Eleloi Gesami dima digalahilä, Dofä Ilibia Edefade neebe amoïe geloi dima salugamolömelë. Ameada, dia malö ägümolö amoda, asigi mogoi hedabi negei neëgida, Godeïe malö neala säha namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Di sosogo Elisabededa sesalebe sulo gaso, walio e fagulo hagui sebe ameage dolö malö ägümolömelë. Siiba, odoa ilia ema malö sogobalo made, hauala sälo amo, walioda e fagulo hagui sebegi, hä, aube gafe saleamelë. ");
INSERT INTO etr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Godea nelebo hamomolöi made, ulï afädëda maademelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Amala säsebegi Melia säla obëgësalea, Neda Dafidilo Geloiïe hamoi hamolasilo udia saleawe. Dia säsebego gadola nema hamosa maademäiamelëla säi. Amala säi amo nabalahilä, e dïgïla selesaia fii e asi. ");
INSERT INTO etr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Selesaia fii amo asi baagido, Meli e nowela fodolofalï Yudiaïe sege gau dibe amo fedala digala digila awäla, gaamu afädë dibea ami besela galai. ");
INSERT INTO etr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Gaamu amogi besela galala Segelaeaïe mosöa nogila digalahilä, Elisabede e säla olei. ");
INSERT INTO etr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Melia säla olei amo Elisabedea nabi amole, ïe isogi malö dubo sulo amea fologolahilä, Elisabedema Eleloi Gesami nobai. Amasebegi, ");
INSERT INTO etr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabedea gelolafalï sähalea, Dida udia odoa sebe amoli gadoi made. Godea dima edefademalä obeägïlasi gabu. Dia malö ägümolö amomage Godea obeägïlasimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nada hedabi edo hamoi amoïe, nïe Dafidilo Geloiïe eme di ne sebeawi misi. ");
INSERT INTO etr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dia säla olei amo na naba gai amole, malö dubo nïe isogi sebe amea obeägïsalea fologoimelë. ");
INSERT INTO etr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dafidilo Geloia dima hamomolömelëla säla ï amo, dia dofä gausiala digamolö gabula helësëi ameada, dia dofä obeägïsa saleamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Amala säla ïasebegi, Melia sähalea, Neda ïe hamoi hamolasilo udia iso gäwi made sebegi-iii, hï ne beala bobasëi amea-aaa, nïe iso asigia Dafidilo Geloiïe ëi gauia adala-aaa, nïe gesamia nïe damula aulo Godema obeägïsawe-eee. Gode geloi edefade neebe amea-aaa ne hïdo elöla ugila negei ameada-aaa, segeyo wila nofela walio nefolalebeweage-eee hobeala namolö amoliage-eee, obeägïlo edefade Godea negali ïla sämolömelë-eee. Ïe ëida dofä eleloifalï nea-aaa. ");
INSERT INTO etr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Udia dolö walio nefolalebeweage-eee, hobeala namolö amoliage-eee, ebalä bedäse amolida-aaa, ea bobasëmolömu gabio-ooo. ");
INSERT INTO etr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ïe naaboea hamoi geloi edefade hamoi-iii. Asigi dalagala hilile ëi gauia adalo nefolalo amolida-aaa, haila dusudasilasimelë-eee. ");
INSERT INTO etr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Beaha aligilo nefolalo amoli, ea ilile filodaia amila neala nagadaiahalea-aaa, nagadaialo nefolalo amolida, oböla neala gauia adogoimelë-eee. ");
INSERT INTO etr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Udia dolö sïdëa baagoi nefolalo amoligali-iii, ea nelebo hedabi bolela muäia ïahalea-aaa, oböla, udia dolö nelebo yafie negei nefolalo amolimada-aaa ilile naabogi nelebo afädë made gaula-aaa, memalä ili badumu mosalaimelë-eee. ");
INSERT INTO etr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ea ïe hamoi hamolasilo Isilale ili ugila negesalea-aaa, ilile mäuma hamomolöla säla negei amo gadola-aaa, Abalahamamage-eee, ïe yaua mäu amolimage-eee, bobasësa namolöi namolöla helësësamu neamelë-eeela Melia säla wagai. ");
INSERT INTO etr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meli e Elisabedebalä aube ohodoa gadoi sulolahilä, hï segea obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabede e malö ägümolö fu besela galasebegi, olobola sulolahilä, dolö malö neegela ägüi. ");
INSERT INTO etr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hä, Elisabedebalä ami sefolalo amoliage, hïle sosogofalï amoliage, Dafidilo Geloia e edefademalä bobasëila säi amo nabalahilä, Elisabedela hiligila obeägïsa nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ägüla misi segeyo gödö besela galasebegi, ilia malö dubo amoïe gafodo damumolö misi. Maalahilä, ilia malö amoïe eedo Segelaeaïe ëi negedelä hamosebegi, ");
INSERT INTO etr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","emea sähalea, Ai, go made. Ïe ëi Yone negemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Amala säsebegi, ilia ema säla obëgësalea, Di sosogo neebe amogida, ëi goda maademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Amala sälahilä, ilia eedoma naaboea oodo bibila nabahalea, Dïe malö goïe ëida nowë negemolö helësësebela nabi. ");
INSERT INTO etr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Amala nabasebegi, ea ilima naaboea oodo bibila, beba neala ïmola sälahilä, ea amogi ïe ëida Yone dëdëi. Amala dëdëi amogi ili sulubadela fudugi. ");
INSERT INTO etr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Amo gaalu, fodolofalï Segelaea e nafi dofogai amo fisila, bu adomolö hamosebegi, ea Godeïe ëi gauia adala adosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Amala hamoi amogi, udia dolö elebalä nefolalo amoli bedäla fudugi. Amala hamoi amo sulubadela Yudia sege gau dibeamadi sebe amoli sulubadelaea säla daidosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Amala hamoimelëla säi nabi amoli sulubadelaea helësëlahilä nabahalea, Malö go fädäla aligiseda, abodo gadoi hamolo namolödula nabaha difolalo. Mida, Dafidilo Geloiïe geloida, malö amobalä dofä nelo amogi. ");
INSERT INTO etr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Malö amoïe eedo Segelaeama, Eleloi Gesami nobai nea, ea bea säla ulufahalea, ");
INSERT INTO etr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isilaleïe Dafidilo Geloi Gode e maala ïe udia dolö neebe amoli sigi obëgëi amogi, nilïa ïe ëi gauia adadi. ");
INSERT INTO etr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Ea ïe bea sälo memelela odasisi nefolalo amolimadila hamomolömelëla siiba säla negei amoda gowe. Ïe hamoi hamolasilo Debidiïe sosogomadila, nilïle damula aulo geloi gelola namiäia ea memelei gabuwe. ");
INSERT INTO etr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nilïle ado nii neebe amolile naabogi amilage, nilïma bimolö habobaha neebe amolile naabogi amilage, ea nilï damula moholöïe misi. ");
INSERT INTO etr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ea nilïle mäulali bobasëmolöïege, ea gomalä hamomolömelëla asialo made ado hïdo elöi hï dafidi säla negei amo helësësamu aligimolöïege amala hamoimelë. ");
INSERT INTO etr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Asialo made ado ea nilïle mäu Abalahamama migalïa diigila ado gelola sälo amo gadola säla negei amoda gowe. ");
INSERT INTO etr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Nilïle ado nii nefolalebe amolile naabogi amila damula awäla sigi obëgëmolömelëla säla negei. Amase, nilï nagadaiawi neebewe bedäla made, segeyo sulubadelagi ïe sidaia mala mogoige hedabi eleloige hamosa nea, ïe hamoi hamolasisa namiäiaïe amala hamomolömelëla säla negei. ");
INSERT INTO etr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nïe malö-o, Dafidilo Geloi hobeala misiäia, diada ïe idi hahamogila fofodola dafidi awäha namolö amoïe, ilia dida hä, Dofä Ilibia Edefade neebe amoïe bea sälo afädë nebegola sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ïe udia dolö amolia helësëmäia, dia ilima säla ïahaleada, Dilia nafade hamoi amo ea hësa maadela damula moholömelëla säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nilïle Gode eda hedabi bobasëlo amea amala damula moholömelë. Ea nilï bobasëlo amea, yo edefademalä afädë mudaiala besela galalahilä, ");
INSERT INTO etr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","udia dolö gasimi sagaiage, baagoloïe sege augi hawage nefolalebe amolimada, ea yo digalasimolömelë. Nilï dalulasiloïe idigi emesala mosäia sigi namolöïe, amala yo digalasimolömelëla Segelaeaea bea säla negei. ");
INSERT INTO etr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hobeala malö amo ëdëla aligilahilä, ïe gesamige geloi nelo. Amalahilä, Isilale udia dolö neebe amolia siia bimäia, e ulufadigimolö segeyo amo besela galamäia beaha neada, sege nafade udia dolö aligisia made ami nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Segeyo amo gaaluda, Olomo dolö ëi Sisa Ogasadasa ea beaha aligilo gini nea, ea udia dolö beaha neebe amoli sulubadela ëi dëdëmolö dialeala säla negei. ");
INSERT INTO etr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gabenaïe ëi Guliniasaea Bolobinisi Silia beaha neebe amo gaalu, gamane dolö ilia ëi dëdëla negemolöda, amo gala mi gäwila negei. ");
INSERT INTO etr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Amalebe, udia dolö ili sulubadela hilile segea afufula, ëi negemolö afiai. ");
INSERT INTO etr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hä, Yosebe eda Galilimadi gaamu afädë dilo amoïe ëi Nasalese amila, Yudiamadi Debidiïe gaamu afädëgi asi. Gaamu amoïe ëida Bedeleheme. E Debidiïe yaua mäu nelo amea ami asi. ");
INSERT INTO etr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Melida Yosebe egali säi sulo amo nimolö gaalu ameada, Meli fagulo hagui sulo amola helegela ëi negemolö asi. ");
INSERT INTO etr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ele Bedeleheme ami nea, Meli e malö ägümolö fu besela galai. ");
INSERT INTO etr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hä, olobola sulolahilä, dolö malö abulümi afädë ägüsebegi, faguloea usulala sugua gao molö nülo falo gadoi amoïe isogi ami negesi. Amala hamoi amoïe mida, udia dolö amala gegedosalea dilo mosö nelo amo negegi dilo amea amai. ");
INSERT INTO etr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sege amoïe yala baagido nea, sugua sibi sigi aligilo odoa nefolalo amolia gasigi ilile sugua sibi sigi nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Amala sigi nefolalebegi, Dafidilo Geloiïe selesaia fii afädë maala ulufalahilä, Dafidilo Geloiïe yo digalo hïdo elöi ili neebea ami yo digala besela galasebegi, ili edefademalä fudugila bedäi. ");
INSERT INTO etr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bedäsebegi, selesaia fii amea ilima sähalea, Bedämabu. Nabuö. Na dilima ado hedabi afädë säla ïmolö misi neawe. Ado hedabi ameada, udia dolö fifi asi sefolalebe amoli sulubadela obeägïsa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Segeyo walioda, Debidiïe gaamua udia afädëa malö neegela ägüimelë. Malö ameada, dili sulubadela damula moholö. Eda Dafidilo Geloi Gelesomelë. ");
INSERT INTO etr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ado amo dofä gabula bimäiada, malö dubo amo sugua gao molö nülo falo gadoi amoïe isogi ami faguloea usulala negei dië bimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Selesaia fii amea ado amo säha maadeia gai amole, selesaia fii yafie Hebeniïe ami mafula selesaia fii dafidi maala nelo amobalä fodolofalï maala ulufala nelo. Amala nea, ilia Godeïe ëi gauia adogola sähalea, ");
INSERT INTO etr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Gode ilibia neebe amoïe ëi gauia adogosawe. Nagadaia udia dolö neebe amolia Gode obeägïlasilo nefolalebe amolimada, neala dalulasilo diamiäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Amala sälahilä, selesaia fii amolia ili dïgïla selesaia mosöa obëgëibua, sugua sibi sigi aligilo amolia hilidomu sähalea, Walio Dafidilo Geloia nilïma nelebo besela galaila säi amo bimolöïe, Bedeleheme afiadila säi. ");
INSERT INTO etr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Amala sälahilä, ili fodolofalï Bedeleheme afiala Meli Yosebelege malöge ili sebe amo beagolei. Malö dubo amoda, sugua gao molö nülo falo gadoi amoïe isogi negesi dibe melï. ");
INSERT INTO etr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Malö amo bealahilä, ïe ado selesaia fiia ilima säla ï amo säla ïaha maadesebegi, ");
INSERT INTO etr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ado säi nabi amoli sulubadelaea sugua sibi sigi aligilo amolia ado säla ï amogi fudugisa sefolalo. ");
INSERT INTO etr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amalebe, Meliada, ea nabi amoge, melï amoge, sulubadela ïe isogi nea salalahilä, helësësamu sulo. ");
INSERT INTO etr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sugua sibi sigi aligilo amoli obëgësalea, ilia melï amo sulubadelagige, nabi amo sulubadelagige, Gode eda ilibia neala säla, ïe ëi gauia adogola aligi obëgëi. Ilia melï amoge, nabi amoge, sulubadela ilima säi amo gadola gausiala digai. ");
INSERT INTO etr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Malö amo ägüla misi segeyo gödö besela galasebegi, ïe gafodo damumolö segeyogi, malö amoïe ëi Yesu negei. Emea malö amo, aso, fagulo made hagula sebegi, selesaia fiia ëi Yesu negemalola säi amo gadola negei. ");
INSERT INTO etr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosese nebegi Ado säla negei dibe amo gadola segeyo wagasebegi, ele Godeïe siigi nigime baai made namolöïe, Yosebe Melilea malö dubo amo Dafidilo Geloigali odala ïmolöïe, Yalusaleme gaula asi. ");
INSERT INTO etr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dafidilo Geloiïe Ado säla negei dibe amo gadola, udiaea dolö malö abulümi sogobaseda, Dafidilo Geloigali odala ïmalola säla negei amo bëgëla, amala hamoi. ");
INSERT INTO etr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dafidilo Geloiïe Ado säla negei dibe amea sähaleada, Haea maliabu gadoi äudä galëge, haea maliabu gadoi elöïe emalö äudä galëge, ïmalola säla negei amo gadola odala ïmolöïege ami asi. ");
INSERT INTO etr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Segeyo amo gaalu dolö afädë Yalusaleme ami sulo. Ïe ëida Simeono. Dolö amoda asigi mogoi nea, Godeïe mala nabahamu aligilo. Eada Isilale udia dolö damula moholö amo misiäia beaha nelo. Emada Eleloi Gesami nobai nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Eleloi Gesamia Simeonoma sähalea, Di aso, made baagola neëgi wäla, Dafidilo Geloia Geleso moholömelëla säla negei amo misi neëda, dia bimolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eleloi Gesamia Simeono sigi gaula Godeïe mosö amoïe yala isogi digai. Digalahilä beahamelebe, Ado säla negei dibe amo gadola bëgëla hamomolöïe, eedo emelea Yesu dubo amo gaula misi neebe melï. ");
INSERT INTO etr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bealahilä, Simeonoea malö amo sogobala gaula nea, Godeïe ëi gauia adala sähalea, ");
INSERT INTO etr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dafidilo Geloi-e, dia dafidi ado säla negei dilo amo gadola, dïe hamoi hamolasilo gowea, nïe hame eegela, ne hä, baagomolö amo dofea. ");
INSERT INTO etr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mida, dia nilï damula moholömelëla säi amo nïe siia, hä, beahawe. ");
INSERT INTO etr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Dia daiala negei amoda, udia dolö sulubadelaea bimäia hamoi gabuwe. ");
INSERT INTO etr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Eda yo digalo nea, udia dolö fii odoa neebe amoli yo digalasimolöge, dihïle Isilale udia dolö neebe amolile ëi gauia adamolöge nebegola säi. ");
INSERT INTO etr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Malö amoïe ado Simeonoea säi amo nabalahilä, ïe eedo emelea asigia fudugisa nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hä, Simeonoea Godea ele neala obeägïlasimäiamelëla sälahilä, malö amoïe eme Melima sähalea, Nabuö. Malö goeada, Isilale udia dolö yafie digalasila, yafie nowelasimolöge, amase, e nofe elöi neebe amo bealahilä, e helësëla udia dolö yafiea dofea madela sämolöge, Godea e memelela ifosi gabugo. ");
INSERT INTO etr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ameada, udia dolö yafiea iso asigigi helësëi amo, ea ulufadigisa maademolömelë. Amase, helebe siia dihïle bobagi gäwimolömelëla Melima säla ï. ");
INSERT INTO etr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Amo gaalu, bea sälo udia afädëge, ëi Ana sulo. Eda Asa sosogo, Fanueleïe idiwi sulo. E dolö fila awäla dolöbalä gäheo i gifalädalïamu sebegi, dolö amo baagolebeda, e didalo salea, ïe gäheo i nabülasi gödölasiïe odoai biyidiada, sesalebe hamoi sulo. Godeïe mosö amo fisila made, eada Gode helësëla, molö made naala, yoba gasigige Godema adosamu filo. ");
INSERT INTO etr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeonoea säla wagai amole, Ana e malö dubo amo mia ga madela salea, ea Godema nesegei. Amala nesegelahilä, ea Yalusaleme udia dolö Godea sigi obëgëmäia sisiläfüla beaha nefolalo amoli sulubadelama malö amoïe ado säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Elea Dafidilo Geloia Ado säla negei dibe amo gadola hamosa maadelahilä, Galili segeamadi helele segea Nasalese gaamugi obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ami awäla nea, malö amo ëdëla aligilahilä, geloi nelo. Ema asigi falagasei nobai nea, Godeïe ugila negelasilo ema negesi nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gäheo i sulubadelagi Baagila Asi Segeyo amo besela galasegida, Yesuïe eedo emele, Yalusalememu awäha aligilo. ");
INSERT INTO etr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu e gäheo i giwilasi baagilahilä, ilia segeyo edefade amoïe molö nülo mala dilo amo gadola bëgëla, hiligila Yalusaleme afiai. ");
INSERT INTO etr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Segeyo edefade amo baagisebegi, eedo emele helele segea obëgësa nelo. Malö malïbu Yesuda, Yalusaleme ami nebegi gaso, eleada ami neala helësëla made, obëgësa nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Elea helësësaleada, awäse wegi awäha gabula helësëlahilä, ele obëgësalea segeyo afädë baagi. Made beasebegi awäha nea, mogogi amila ele sosogo amolimage, ele damelë amolimage, dilia melïlela naba hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Elea hogoi amo hogosa neamu made beagolesebegi, oböla, e Yalusaleme hogola obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Elea hogosa neamu segeyo ohodoa baagilahilä, oböla hobeala beahamelebe, Godeïe mosöa ami säla olelelo amoli mogogi ami salea, ilia säsebe amo nabadigi, ilima ea nabadigisa sebe melï. ");
INSERT INTO etr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yesuea ado säse nabaha sefolalo amolia, e dawa edefade gaui amole, ea naba obëgëi amolegi ili fudugisa sefolalo. ");
INSERT INTO etr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eedo emelea e beagolela, asigia fudugilahilä, emea ema sähalea, Aea, dia alïma amo hamoi amoda, abilia hamosalea amala hamoi. Diado alïada di hogosalea asigi säosäosa nelomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Amala säsebegi, ea elema säla obëgësalea, Alia ne hogosolo goda edoïe. Ne Naadoïe mosöa samolöi dialeala alia made helësëla dawa made nealela nabi. ");
INSERT INTO etr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Elema ado amala säi amoda, elea mi fädäla made helësëi. ");
INSERT INTO etr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hä, e eedo emelebalä hiligila Nasalese obëgëlahilä, eedo emelea hamomola säsebe amo gadola nabala hamosa nelo. Amo gadola hamosebegi, emea, ea nabi amoge melï amoge sulubadela ïe isogi nea salahamu sulo. ");
INSERT INTO etr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu e ëdësalea, dawa amola fädäsebegi, Godeage udia dolöeage ema boba gosala nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dabeliasa Sisa e Olomoïe gini beaha nelo amoïe gäheo i mimogogida, Bödiasa Bailadi eada, Disiligi Yudiaïe gamane beaha aligiloge nelo. Amo gala, Heledoeada Disiligi Galiliïe beaha aligiloge nelo. Amase, edoo Filibiada disiligi äudä, Iduleale Dalagonaidisilele beaha aligiloge nea, Ilisaniasaeada Disiligi Abiliniïe beaha aligiloge nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gobela ïlo busa edefade Anasale Gaiafasale neebe amo gaaluda, Segelaeaïe malö Yone e sege udia dolö aligilo made dibea ami nebegi, Godea ema ado säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Amalebegi, Yonea ödä Yodona dibe amo ga madela sege dibe amo sulubadelagi nawesa nea, udia dolöma ado mala säla ïahalea, Dilia nafade hamoi amo Godea hëmäia, iso asigi besula ödägi gemolö dialeala säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Amoïe bea sälo Aisaeaïe bebagi ado säla dëdëla negei dibe amoda gowe. Sege nafade udia dolö aligilo made dibea ami nea, afädëa uuala wesalea, Dafidilo Geloi misiäia, idi fodola dadaiaha namialo. Ïe idida, mogolafalï fodomalo. ");
INSERT INTO etr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dogomo dibe amolige, gau dibe amolige, sulubadela abaha maadelahilä, gogoi dibe amoli sulubadelagi föla nobaha maademalo. Idi halowei dibe amo hedabola mogola fodosa maadelahilä, idi fedafu digafui dibe amoli sulubadela abala bobagisa maademalo. ");
INSERT INTO etr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Udia dolö nagadaia nefolalebe amoli sulubadelaea, Godeïe damula aulo bimolömelëla uuala wesa neala säi amo dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Udia dolö yafie Yonea ili ödägi gemäia maala gegedoi nebegi, Yonea ilima sähalea, Dilida säiabëïe malö gadoi nebego. Godea mihaläla së ïmolö amogi fisäla doadigila moholömelëla dilima nowëa säla ïasio. ");
INSERT INTO etr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Dilia nafade hamosa nelo amo fisila asigi besui nebegoïe gägä negela ulufaha namialo. Dilia dihilimu sähaleada, Nilïle naadoda Abalahama nelola sämolöi mademelë. Na dilima ado afädë sähago. Godea igi difolalebe gowe neawelahilä, Abalahamaïe malölali hamomolöi neamelëla sähago. ");
INSERT INTO etr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","I nefolalebe amoli abulöïe i mia gabi bogi dialea. I gägä hedabi made negelo nefolalebe amoli sulubadela abaha maadelahilä, nulogi gobemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amala säi amo nabalahilä, udia dolö gegedoi nefolalo amolia Yonema nabahalea, Amai nilïa edo hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Amala nabasebegi, ea säla obëgësalea, Afädëa fagulo äudä dibe ameada, elö fagulo maade amogali ïmalo. Amase, afädë molö galebe ameada, amo gadola wäla hamomalola säla i. ");
INSERT INTO etr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dolö odoa dagisi muni nelo nefolalo amolige Yonea ili ödägi gemäia misi nefolalo. Ilia ema nabahalea, Säla Olelelo-o, nilïa edo hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Amala nabasebegi, ea ilima säla obëgësalea, Dilia dagisi muni neahalea, gamanea säi amo gadolamu nimalo. Odoa baala nimabiola säla ï. ");
INSERT INTO etr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Amo gadola wäla, ami dolö odoaea Yonema nabahalea, Nilïa edo hamomolödula nabi. Amalebe, Yonea ilima säla obëgësalea, Udia dolöma muni neahalea, nolealela egedidigila säla nimabio. Amase, odoaïe muni nimolöïe gudisalea wäfalï säsäla gudimabio. Ami ilia bidi ïasebe amoda, dofeala helësëmolö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Udia dolö asigia sisiläfüla beaha nefolalo amolia asigia, Yone eda Gelesoledula helësëi. ");
INSERT INTO etr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Amala helësësebegi, Yonea ili sulubadelama sähalea, Nada dili ödäea gesa neawemelë. Be, hobeala afädë moholö neebe amoda, nïe geloi amo baagila awäla, eda geloi edefade neebe amo moholömelë. Neda hedabi made ameada, ïe emo usili fisigämolö amo dofea made neawe. Eada dili Eleloi Gesamilea nulo söalea gemolömelë. ");
INSERT INTO etr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eada eladi gadoi ëi widi dobi amoïe isole giwile gasala sadia adogola mogeloïe nama gadoi gaula nea. Ea mogela iso amo mosö afädëgi negesilahilä, ïe widi dobilo sege amo gëgelë doala digila, giwi amo nulo usilo made, wisamu neebea ami gobemolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Udia dolö amolile isogi gäwilasila, Yonea ado yafie odoa säla ïalahilä, Ado Mala Hedabi säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ilile gamane beaha aligilo Heledoea ïe edoo Filibiïe udia Helodiasa fedela nii amogige, mala nafade odoa hamoi amogige, Yonea Heledoma nemoi. ");
INSERT INTO etr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Amala nemosebegi, Heledoea ïe nafade hamoi amolidaia baala edela, oböla Yone galabaia negei. ");
INSERT INTO etr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yonea udia dolö sulubadela ödägi gesalea, Yesuge ödägi gei. Amala gesebegi, Yesuea Godebalä adoi amole, mu dusuia gala ");
INSERT INTO etr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Eleloi Gesami haea maliabu gadoi Yesudaia digala fii. Amala hamose amo gaalu, selesaia mosöala ado afädë säia idogosalea, Dida nïe malö. Na di boba hamosa neawe. Dima edefademalä obeägïsa neawela säi. ");
INSERT INTO etr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuea hä, ïe hamoi mi gäwila hamosa nelo amoda, gäheo i nabülasi ohodoa gadoi nea hamosa nelo. Udia dolö nefolalo amoliada, eda Yosebeïe malö neala helësësa nefolalo. Yosebe eda, Hilaiïe malö nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai eda, Madadaïe malö. Madada eda, Ilibaiïe malö. Ilibai eda, Maligiïe malö. Maligi eda, Yanaiïe malö. Yanai eda, Yosebe edaioïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosebe edaioda, Madadiasaïe malö. Madadiasa eda, Amosiïe malö. Amosi eda, Nahumuïe malö. Nahumu eda, Eseliïe malö. Eseli eda, Nagaiïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai eda, Madaïe malö. Mada eda, Madadiasa elöïe malö. Madadiasa eda, Semeniïe malö. Semeni eda, Yosegeïe malö. Yosege eda, Yodaïe malö nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda eda, Yoananaïe malö. Yoanana eda, Elesaïe malö. Elesa eda, Selubabeleïe malö. Selubabele eda, Sealadieleïe malö. Sealadiele eda, Neliïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli eda, Melegiïe malö. Melegi eda, Adiïe malö. Adi eda, Gosamaïe malö. Gosama eda, Elemadamaïe malö. Elemadama eda, Eliïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli eda, Yasuaïe malö. Yasua eda, Elieseïe malö. Eliese eda, Yolimiïe malö. Yolimi eda, Madadaïe malö. Madada eda, Ilibaiïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ilibai eda, Simeonoïe malö. Simeono eda, Yudaïe malö. Yuda eda, Yosebeïe malö. Yosebe eda, Yonamaïe malö. Yonama eda, Eliagimiïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliagimi eda, Meleaïe malö. Melea eda, Menaïe malö. Mena eda, Madadaïe malö. Madada eda, Nadanaïe malö. Nadana eda, Debidiïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debidi eda, Yesiïe malö. Yesi eda, Obediïe malö. Obedi eda, Boasaïe malö. Boasa eda, Salomonoïe malö. Salomono eda, Nasonoïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasono eda, Aminadabaïe malö. Aminadaba eda, Adaminiïe malö. Adamini eda, Alaniïe malö. Alani eda, Hesolonoïe malö. Hesolono eda, Feleseïe malö. Felese eda, Yudaïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda eda, Yeigabaïe malö. Yeigaba eda, Aisagaïe malö. Aisaga eda, Abalahamaïe malö. Abalahama eda, Delaïe malö. Dela eda, Neholoïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neholo eda, Seluguïe malö. Selugu eda, Eleuïe malö. Eleu eda, Felegeïe malö. Felege eda, Ebeliïe malö. Ebeli eda, Selaïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela eda, Gainanaïe malö. Gainana eda, Alabagasadaïe malö. Alabagasada eda, Semeïe malö. Seme eda, Noaïe malö. Noa eda, Elamegeïe malö nelo. ");
INSERT INTO etr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Elamege eda, Meduselaïe malö. Medusela eda, Inogoïe malö. Inogo eda, Yaledeïe malö. Yalede eda, Mahalaleleïe malö. Mahalalele eda, Genanaïe malö. ");
INSERT INTO etr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Genana eda, Enosoïe malö. Enoso eda, Sedeïe malö. Sede eda, Adamaïe malö. Adama eda, Godeïe malö nelo. ");
INSERT INTO etr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Eleloi Gesami Yesuma nobasebegi, e ödä Yodonagila obëgëi. Amasebegi, Gesamia e sege nafade udia dolö aligisia made ami sigi awäla ifosi. ");
INSERT INTO etr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ami nebegi, mugabe busaea segeyo nabülasi biyidiagi Yesuea nafade hamomabelela fedogola beaha nelo. Amala fedogola beaha nebegi, Yesu e molö made naala neamu, segeyo amo gadola baagisebegi, Yesu e hä, sïdëa baagoi nelo. ");
INSERT INTO etr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Amala hamoi neebe amo bealahilä, mugabe busaea Yesuma sähalea, Di Godeïe malö nea galëda, igi gowema wahalo hamomalamola säi. ");
INSERT INTO etr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Amala säsebegi, Yesuea säla obëgësalea, Ado säla dëdëla negei dibe amea sähaleada, Udia dolögali namolö ïlo amoda, wahalo nase ameamu ïlo mademelëla säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Amala säsebegi, mugabe busaea segebi ilibia neebedaia ami Yesu sigi fedalahilä, gädili sulubadela dibe amoli ema fodolofalï si hamo dagabolo wäla dagabola olesa maadei. ");
INSERT INTO etr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Amala olelahilä sähalea, Gädili dibe egowe sulubadela sigi namiäiaïe geloige, ëi edefadege negali ïaha maadei ameada, na ïmolö helësëse amogali ïmolöi ameada, hä, digali ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dia nïe emo mia gumusulahilä, nïe ëi gauia adaseda, digali ïaha maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuea ema säla obëgësalea, Ado säi dibe amea sähaleada, Dafidilo Geloi, dïe Gode neebe amo, dia ïe ëi gauia adamalolage, amase, ïemu hamoi hamomalolage, säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Amala säsebegi, mugabe busaea Yesu Yalusaleme sigi awäla, Godeïe mosöa ilibiafalï gadogo ifosilahilä sähalea, Di Godeïe malö nea galëda, hä, di dihï guila nila sadia idogomo. ");
INSERT INTO etr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Amoïe mida, dafidi dëdëla negei dibe amea sähaleada, Ea ïe selesaia fii amolima di hedabola sigi namolö mosalola säsegi, ");
INSERT INTO etr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","igia dïe emo daualoea, ilile naaboea di sogobala gauia adogomolömelëla säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Amala säsebegi, Yesuea säla obëgësalea, Gomalä säi dialea. Dafidilo Geloi dïe Gode neebe amo fedogola bimabiola säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mugabe busaea, Yesu fedogola beaha maadelahilä, hobea bu obëgëmolöïe, fu hogodeläla helësëlahilä, Yesu dïgïla asi. ");
INSERT INTO etr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gesamia Yesu neala gelolasisebegi, e Galili obëgëi. Udia dolö amodi nefolalo amoli sulubadelaea Yesuea hamoi amoïe ado säi amo nabala daidosa maadei. ");
INSERT INTO etr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ea ilile gedolo mosö nefolalo amoligi nea säla olelesebegi, udia dolö nefolalo amoli sulubadelaea ïe ëi gauia adaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu hï e Nasalese ëdëia ami awäla nea, ea segeyo Sabadagi hï hamolo amo gadola hamomolöïe, e gedolo mosöa ami awäla nogila digai. Digalahilä, beba nidemolöïe nowela aligisebegi, ");
INSERT INTO etr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ilia bea sälo Aisaeaïe beba gali dilo amo ema neala ï. Amasebegi, Yesuea beba amo bobagia gala, ado afädë dëdëla negei dilo amo beagolelahilä, nidesa nelo amoda gowe. ");
INSERT INTO etr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dafidilo Geloiïe Gesami e nema nea. Mida, na udia dolö busadäoi nefolalebe amolima Ado Mala Hedabi säla ïmäia, ea nïe busagia weli söga negelahilä, ea ne memelei. Udia dolö gide begela nafodoi nefolalo amolima dili fisigälasimolömelëlage, si golai nefolalebe amolima dili bu hedabola bimolömelëlage säla ïmäia, ne fisiga wei. Amase, dolö odoaea udia dolö daiasala gadiabosa nefolalebe amoli haila digila sigi obëgëmäiage, ");
INSERT INTO etr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dafidilo Geloia udia dolö obeägïlasimolö fu walio dialeala säla ïmäiage, amala hamomolö mosalola säila säi. ");
INSERT INTO etr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Amala nidesa maadelahilä, Yesuea beba amo galila beba beaha aligilo amo hïma ïalahilä, e fila digai. Amala hamosebegi, udia dolö gedolo mosöa sefolalo amoli sulubadelaea ema sisila sefolalo. ");
INSERT INTO etr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Amala sefolalebegi, ea ilima sähalea, Ado bebagi dëdëla negei nidesebegi, dilia nabaha sefolalo amoda, walio wegi wäla, hä, gausiaha gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Amala säi amo nabalahilä, udia dolö sefolalo amoli sulubadelaea ïe ëi gauia adogola, ado hedabi hïdo elöi ïe nafigila säi nabi amogi asigigi fudugilahilä sähalea, Egoweda Yosebeïe malö madelela säi. ");
INSERT INTO etr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuea ilima sähalea, Udia dolöea ado besula säse go gadola, dilia oböla, nema sähalea, Alögoda-o, dihï wahimalola säla, Gabaniama nea mala hamosa nelo nilïa nabi amoda, wige dihï segea nea hamolo amo gadola wäla hamomalola sämolöledu. ");
INSERT INTO etr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na dilima dofä sähago. Bea sälo neebe amoda hïle segeafalï, udia dolö nefolalebe amolia säla olela gausialo mademelë. ");
INSERT INTO etr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Elaia nelo amo gaalu, gäheo i ohodoaïe aube gafeia sege made digala mu gala digila esoi dibegi, sege amo sulubadelagi sïdë i edefade dilo. Segeyo amo gaalu, Isilale segea ami dofä udia didalo yafie sefolalo ");
INSERT INTO etr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","gaso, Godea Elaiama ili sefolalebea ami mosalola made säla, Saidono segeïe Salebada gaamugi udia didalo afädë sebea amimu mosaloi. ");
INSERT INTO etr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hä, amo gadola wäla, bea sälo Elaisa neebe amo gaaluge, Isilale segea udia dolö gudubu hamoi yafie sefolalo gaso, amoligi afädë made wahila, gädili Silia fii Naimono afädë emu wahimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Udia dolö gedolo mosöa sefolalo amolia amala säi amo nabalahilä edefademalä mihaläi. ");
INSERT INTO etr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ilile gaamu amoda segebidaia dilo. Hä, ili nowelahilä, Yesu naabogi gaula iluala didigila gaamu yala baagido segea asi. E amala sigi awälahilä, däeo bidigi amila bobala saledelä hamosebegi ");
INSERT INTO etr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","gaso, ili mogogi amila doadigila moholöi asi. ");
INSERT INTO etr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Amalebe Yesu e awäla Disiligi Galiliïe gaamu Gabaniama ami digai. Ami awälahilä, segeyo Sabadagi udia dolö nefolalo amolima säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ea geloi gaulahilä geloi hïdo elöi olelei amogi, udia dolö ea säla olelese nabaha sefolalo amoli asigigi fudugisa sefolalo. ");
INSERT INTO etr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gedolo mosöa amida dolö afädëma mugabe nafade afädë fedai sulo. Amea gelola üalala digila sähalea, ");
INSERT INTO etr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wae! Nasalese fii Yesu-o, nilï neebeawi dia edo hamomolöïe misi. Amai dia nilï nufulöïe misile. Dida na dawa. Dida mogoi hedabifalï, Gode neebeala misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Amala säsebegi, Yesuea nemosalea, Adomabu! Dolö go dïgïla doadigila mosöla säi. Amala säsebegi, mugabe amea dolö amo udia dolöïe sidaia nagadaia nidala awälahilä, neala nafadela made, geleä doadigila asi. ");
INSERT INTO etr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Udia dolö nefolalo amoli sulubadela iso asigigi fudugilahilä, hilidomu säla didigahalea, Wae! Ado amoda edo gadoi adodu. Mugabe iliada ea doadigila mosöla säse amo gadola mosäia, mosöla säloïe geloi hïdo elöi gaula neebemelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Disiligi amogi Yesuea hamoi amoïe ado säi amo nabala daidosa maadei. ");
INSERT INTO etr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu e gedolo mosöa amila Saimonoea mosöa asi. Saimonoïe esöa hëgï olo edefademalä oloi dilo amo, Yesuea wahimäia, ilia ema säla ï. ");
INSERT INTO etr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Amalebe, Yesu e awäla udia amo mia ga madela nea, hëgï olo amoma nemosebegi, hëgïla oloi amo damui. Amala säi amole, udia amea nowelahilä, ili molö muäia neala ï. ");
INSERT INTO etr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Deadi eso digase amo gaalu, udia dolö ilia oloi elö elöla difolalo amoli sulubadela Yesu neebea gaula mofiai. Amalebe, Yesuea ili afädë afädëlama naaboea diigisebegi, ili wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Amase, ea udia dolö yafiema mugabe fedai nelo amoge sulubadela nesila digisa maadesebegi, mugabe amoli doadigila awähalea, gelola üalala didigala sähalea, Dida Godeïe malömelëla säla didigai. Amalebe, Godea Afädë Memelei moholömelëla säla negei amo e gabula dawadigisebegi, ea ilima nemosalea adomabula säi. ");
INSERT INTO etr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yosefalï nowela Yesuea gaamu amo dïgïla, sege udia dolö aligilo made dibea ami asi. Udia dolö yafie nefolalo amolia hobeala e hogogola awäla e beagolelahilä, di made moholömelëla säla, ilia e gauia idogoi. ");
INSERT INTO etr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gauia idogosebegi, Yesuea ilima sähalea, Gaamu odoa difolalebe amoligi, Godea Beaha Maadela Sigi Neebe amoïe Ado Mala Hedabi säla ïmäia, Godea ne fisiga weimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hä, Yesu e Disiligi Yudiamadi nawesa nea, gedolo mosö difolalebe amoligi ado mala säla ïïa nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Segeyo afädëgi Yesu e oeabo Genesaledi agesua ami nebegi, udia dolö yafie mafula gegedola, Godeïe ado mala nabulöïe, e neebe amo amalela digilahilä, negegi nelo. ");
INSERT INTO etr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Amala hamosebegi, Yesuea du äudä ödä agesua gaula misi dibe melï. Seme digilo dolö amolia du äudä amo negesiä, seme digilo selëgë amoli nigime hësa nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu e ödä du afädëdaia fedala nelo. Amoda Saimonoïe du. Ea Saimonoma sähalea, Ödä agesuala du holöbö eegela fisiga gamola säi. Saimonoea amala hamosebegi, Yesu e du amodaia salea, udia dolö gegedoi amolima säla olelesa sulo. ");
INSERT INTO etr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ea ilima säla olelela wagalahilä, Saimonoma sähalea, Du ödä momogolumadi fulula awälahilä, dilia seme nimolöïe selëgë sadia idogomalola säi. ");
INSERT INTO etr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Amala säsebegi, Saimonoea säla obëgësalea, Dafidilo-o, nilïa gasi sedade digisa nea, häuala baagi sësa nelo gaso, dofä isoïe afädëge made nii. Gaso, dia säse goeada, na selëgë we sadia idogosamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Amala sälahilä, ilia amala hamosebegi, seme yafie digai amea selëgë nulimolöi hamoi. ");
INSERT INTO etr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Amalebegi, ilia ili gaalu hamolo odoa du elö amogi sefolalebe amolia ili ugila negemolö misiäia, naabo hähawela wei. Ili maala hiligila gauia adogola du äudä amoledaia negesebegi, helegela nobalahilä ödägi usabodelä hamoi. ");
INSERT INTO etr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Amala hamose amo bealahilä, Saimono Fidaea Yesuïe emo mia emo gumusula dia digalahilä sähalea, Dafidilo-o, neda nafade hamolo neawe. Ne dïgïla di mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mida, Fidage odoa ebalä seme digisa nefolalo amoliage, seme yafie nii amo beala fudugi. ");
INSERT INTO etr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimonobalä hamoi gaalu hamolo äudä Sebediïe malö Yone Yamese eleage amo gadola wäla fudugi. Amala hamosebegi, Yesuea Saimonoma sähalea, Bedämabu. Segeyo walio wila nofela, dia dolö nelo namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amalahilä, ilia du dusugala gaula agesua awäla, nelebo sulubadela dïgïla, ili Yesu bëgëla afiai. ");
INSERT INTO etr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu e gaamu afädëgi nebegi, dolö domalo gudubu hamosa maadei afädë maala, Yesu beala, e mia gumusula dia digalahilä, ema egedigila sähalea, Dafidilo-o, dia ne wahimäiala asigiseda, wahilasimolöi nebegola säi. ");
INSERT INTO etr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuea ïe naabo mogodigia galahilä, dolö amo diigisa nea sähalea, Na amala asigisa. Di wahimola säi. Amala säia gai amole, dolö amoïe gudubu amo fodolofalï hogosa helesa maadei. ");
INSERT INTO etr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Amala hamosebegi, Yesuea dolö amoma sähalea, Dofä elöma asiala säloeo. Gobela ïlo dolö neebea ami, di siia bimäia olemolö mosalo. Amalahilä, di wahi go udia dolöma olemolöïe, di hëmäia Mosesea nelebo odala ïmalola säla negei dibe amo gadola, odala ïmalola säla ï. ");
INSERT INTO etr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amala säi gasoda, ea hamoi amoïe ado säi amo nabala didigai ameada, udia dolö yafiea ea ado säse amo nabulöge, ili oloi amoli wahilasimäiage afiala gegedoi. ");
INSERT INTO etr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amala hamosebegi, Yesuea segeyo yafiegi ili dïgïla udia dolö aligilo made dibea ami aliga galahilä, Godema adosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Segeyo afädëgi, Yesuea ado mala olelesa nebegi, Felesi dolö odoage, mala säla negei amo olelelo odoage, misi sulo. Amolida Disiligi Galiliïe gaamu dibe sulubadela amilage, Yudialage, amase, gaamu Yalusalemelage mofiai sefolalo. Oloi difolalebe amoli wahimäia, Dafidilo Geloiïe geloi Yesubalä maala nelo. ");
INSERT INTO etr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amala nebegi, dolö odoaea dolö afädë fii si sulo amo dafudaia gaula maalahilä, mosö Yesu neebe amogi gaula digala negedeläïe, fu hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gasoda, udia dolö yafie gegedoi amolia negegi amea, ilia mumusogi gaula digamolö amo fu maade gabugi, dolö amo gaula mosö fïgïdaia fedalahilä, Yesu neebe amo gaalula mosö fïgï dusuia gala, Yesuïe odagi gaalu dafu amola, udia dolö mogogi ami fisiga idogoi. ");
INSERT INTO etr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ilile asigi afädë negei amo bealahilä, Yesuea dolö amoma sähalea, Ne damelë-e, dia nafade hamoi amo hësa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amala säi amo nabalahilä, mala dawadigi amoliage, Felesi dolö amoliage, asigiamu helësësalea, dolö Gode gagadesa neebe goweda nowëdu. Godeamu udia dolöea nafade hamoi amo hëlo nea madelela helësësa sefolalo. ");
INSERT INTO etr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ilia amala helësësa sefolalebe amo bealahilä, Yesuea ilima sähalea, Dilia iso asigigi go helësësa sefolalebegoda, mi edoïe. ");
INSERT INTO etr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dia nafade hamoi amoli hësa maadeila sämolöle, ma, nowela nawesa namiëla sämolöle. Ado aabeida abodo. ");
INSERT INTO etr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amaimo, Dolöïe Malö ameada nagadaiawi nea, udia dolö ilia nafade hamoi amoli hëla digimolöïe geloi gaula neebela dilia helësëmäiamelëla säi. Amala sälahilä, ea dolö fii si amoma sähalea, Dima sähago. Di nowela, dïe fëo go neala gaula, hä, dihï mosöa mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Amala säi amole dolö amea ilile sidaia fodolofalï nowelahilä, fëo e föla adi amo neala gaula, hï mosöa awähalea, Godeïe ëi gauia adala aligi asi. ");
INSERT INTO etr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amala hamosebegi, udia dolö amoli sulubadela fudugila bedälahilä, Godeïe ëi gauia adala sähalea, Nelebo hïdo elöi melëlo made gadoi, walio nilïa beasebemelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Amo hamosa maadelahilä, Yesu e awäha nea beahamelebe, dagisi muni nelo afädë ëida, Ilibai, e dagisi muni nelo mosöa ami sebe melï. Bealahilä, Yesuea ema sähalea, Ne bëgëla misiëla säsebegi, ");
INSERT INTO etr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ilibai e nowela nelebo sulubadela dïgïla, Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Amalahilä, Yesubalä molö molöïe Ilibaia dolö yafie misialola welahilä, ea mosöa molö edefade giai. Dagisi muni nelo yafiege dolö odoage elebalä gegedola molö naha sulo. ");
INSERT INTO etr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amai gaso, Felesi dolö odoaeage, ili sosogo mala dawadigi nefolalo amoliage, Yesuïe bëgëla aulo nefolalo amolima gëgëla sähalea, Dilida dagisi muni nelo nefolalebe amolibaläge, nafade hamolo amolibaläge, molö ödäle naha sebegoda, edoïela säi. ");
INSERT INTO etr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Amala säi amo nabalahilä, Yesuea ilima säla obëgësalea, Udia dolö oloi made neebe amolida, alögoda neebea aulo made. Oloi neebe amolimu aulomelë. ");
INSERT INTO etr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne misiweda, asigi mogoi nefolalebe amoli made, nafade hamolo nefolalebe amoli asigi besumäia wemolö misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Udia dolö nefolalo amolia Yesuma sähalea, Yoneïe bëgëla aulo nefolalo amoliage, Felesi dolöïe bëgëla aulo nefolalo amoliage, segeyo yafiegi Godema adosalea molö made naala aligilo amogi, oböla, dïe bëgëla aulo nefolalebe golia molö ödäle nahamu neebela säi. ");
INSERT INTO etr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Amala säsebegi, Yesuea säla obëgësalea, Dolö afädëa udia neahalea, udia dolö gegedoi amolia, udia nelo dolö amobalä gedola salea, dilida molö made molömelëla sämolöi gabule. ");
INSERT INTO etr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amaimo, ili neebea amila odoaea udia nelo amo sigi moholö segeyo fu besela galamolömelë. Segeyo amogida, ili molö made naala namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Amala sälahilä, Yesuea ado besula sähalea, Afädëa fagulo gähe gadelala neala, fagulo goofogi baala asogelo mademelë. Amala asogeseda, fagulo gähe amo nulilahilä, fagulo gähea fagulo goofogi baala asogei amo afädëdi made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Amo gadoi elöda, afädëa wani ödä gähe dibe amo, ödä i sugua meme gafodoea hamoi goofogi söga salelo mademelë. Amala hamoseda, wani ödä gähe amea meme gafodoea hamoi goofo amo dusulahilä, wani ödä amo awäha maadela, meme gafodoea hamoi i amoge nafademolöi nafademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amaloea, wani ödä gähe dibe amoda, ödä i meme gafodoea hamoi gähegi söga salimolö dialea. ");
INSERT INTO etr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Amase elöda, afädëa wani ödä siiba usi amo nalahilä, wani ödä gähe amo molö made halämolömelë. Mida, ea wani ödä siiba usi amo hedabila sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Segeyo Sabada afädëgi, Yesu e eladi gadoi ëi widi sagai mogo amogi awäha nelo. Awäha nea, ïe bëgëla aulo amolia widi amoïe gägä amo faila, naaboea nologela iso hedefala nana awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Felesi dolö nefolalo amolia nabahalea, Segeyo Sabada gafegi made hamolo negei amo, oböla, dilia hamosebegoda edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Amala nabasebegi, Yesuea ilima säla obëgësalea, Debidige, ebalä aulo amolige, ili sïdëa baagosalea, Debidia hamoi dëdëla negei dibe amo dilia made nidei neale. ");
INSERT INTO etr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ea Godeïe mosöa nogila digala, beledi Godegali odala ï dilo amogi, gobela ïlo neebe amoliamu nülo dilo amo nealahilä, odoa hï nahalea, odoa ebalä aulo amoli muäia neala ïla säi. ");
INSERT INTO etr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuea säla wagala sähalea, Dolöïe Malö neebe amoda, segeyo Sabadaïe Dafidilo neala säi. ");
INSERT INTO etr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Segeyo Sabada elögi, Yesu e gedolo mosöa nogila digalahilä, udia dolöma ado mala säla olelesa sulo. Amida dolö afädë naabo dafädi amo baagoi sulo. ");
INSERT INTO etr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Felesi dolö nefolalo amoliage, mala dawadigi nefolalo amoliage, Yesuma dia nafade hamoimelëla sädelälahilä, ea segeyo Sabadagi oloi afädë wahisebelela bimolöïe, ili ga madela nea, sisila beaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amai gaso, ilia helësësa sebe amo dawadigilahilä, Yesuea dolö naabo baagoi sebe amoma sähalea, Di nowela mogogi namolö misiëla säi. Amalebe, dolö amo nowela fedala nelo. ");
INSERT INTO etr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Amala nowela nebegi, Yesuea ilima nabahalea, Segeyo Sabadagi nilïa hamomolö dofeada abodo. Hedabi hamomolö dialeale, ma, nafade hamomolö dialeale. Udia dolö hedabomäia ugila negemolö dialeale, ma, baagomäia nufulö dialealela nabi. ");
INSERT INTO etr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Amala nabalahilä, Yesuea udia dolö sefolalebe amoli sidawewela bealahilä, dolö amoma sähalea, Dïe naabo mogodigimola säi. Amala säi amo gadola hamosebegi, bu hedabola obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amala hamosebegi, ilia edefademalä habobalahilä, hilidomu säla didigahalea, nilïa Yesuma abilia hamomolödula säha dilo. ");
INSERT INTO etr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Segeyo amo gala, Yesu e Godema adomolöïe, segebi afädëgi fedalahilä, gasi sedade Godema adosamu salea, segeyo sagai. ");
INSERT INTO etr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Segeyo sagasebegi, ea ïe bëgëla aulo amoli e neebea ami misiäia wei. Ili mofiasebegi, ea ili nafolala giwilasi memelei. Amalahilä, ilile ëi abosolo negei. ");
INSERT INTO etr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Afädëïe ëi Saimono, Yesuea e bu oböla Fida negei amoge, ïe edoo Äduluge, Yamesege, Yonege, Filibige, Badolomiuge, ");
INSERT INTO etr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Madiuge, Domasage, Alibiasaïe malö Yamesege, Saimono, ilia ema Selodola sälo amoge, ");
INSERT INTO etr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yameseïe malö Yudasage, Yudasa Isagaliada, hobeala Yesu hololömolö amoge, amoli Yesuea memelei. ");
INSERT INTO etr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesula dolö amolali segebidaia amila digafula, sege hedabi fufuia asi dibea ami nefolalo. E bëgëla aulo yafie odoa amola hiligila ami nebegi, udia dolö yafie Disiligi Yudiaïe sege dibe amo sulubadelagilage, gaamu Yalusalemelage, Daia gaamule Saidono gaamule duhulu ga madela dibea amilage, mafula gegedola negegi nelo. ");
INSERT INTO etr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Amoli mofiai amoda, Yesuea säse amo nabadigi, ea oloi amoli wahila digimäiage mofiai. Amase, mugabe fedai mafui amoli Yesuea nesila digisebegi, wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Geloi ema dibe amea udia dolö amoli sulubadela ea wahisa maadese amogi, udia dolö sulubadelaea Yesuma diigimolöila helësëi. ");
INSERT INTO etr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuea ïe bëgëla aulo amolima siila nea sähalea, Gumusui nefolalebe dilida, obeägïsa nea. Mida, Godea Beaha Maadela Sigi Neebe amoda, dilile dibe amogi. ");
INSERT INTO etr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Walio sïdëa baagosa nefolalebe dilida, obeägïsa nea. Mida, hobeala dili molö bolela molö amogi. Walio dïisa nefolalebe dilida, obeägïsa nea. Mida, hobeala dilia ösa namolö amogi. ");
INSERT INTO etr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dili Dolöïe Malö amoïe neëgi, udia dolö odoaea dilima bimolö habobasege, nesila digisege, ado nafadela säsege, dilile ëi gagadela säsege, amo gadola hamose amo sulubadelagi, dilida obeägïsa nea. ");
INSERT INTO etr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ilia dilima mala amo gadoi hamoseda, segeyo amo gala dilia hïdo elöla helëla obeägïsa namialo. Nabuö. Dilile bidi edefade Hebeni mumului dialea. Mida, siiba ilile mäu nefolalo amoliage bea sälo nefolalo amolibalä amo gadola wäla hamosa nelomelë. ");
INSERT INTO etr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amai gaso, walio nelegei yafie negelo dafidilo dolö nefolalebe dili, asigii gabu. Mida, dili namolö aabei hedabi amo neaha maadesalea, elö nimolö made amogi. ");
INSERT INTO etr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Walio molö bolela nülo sefolalebe dili, asigii gabu. Mida, hobeala dili sïdëa baagomolö amogi. Walio ösa nefolalebe dili, asigii gabu. Mida, hobeala dili gualösa nea, dïisa namolö amogi. ");
INSERT INTO etr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Udia dolö sulubadelaea dilile ëi gauia adogosebe dili, asigii gabu. Mida, siiba ilile yaualali dafidi nefolalo amoliage wäfalï bea sälo nefolalo amolibalä amo gadola wäla hamosa nelomelë. ");
INSERT INTO etr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesuea ado aso, sähamu nea sähalea, Na ado säse nabase dilima sähago. Dilibalä ado nii nefolalebe amoli boba hamosa namialo. Dilima bimolö habobaha nefolalebe amolima dilia hedabi hamomalo. ");
INSERT INTO etr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Odoaea Godea dili neala nafademäiala säsege, Godea ili ugila negela hedabolasimäia sämalo. Dilima nafade hamosege, diliada ilile Godema adolasisa namialo. ");
INSERT INTO etr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amase, afädëa dïe ba näiado go nufudaseda, ba näiado goge ema besula olemalo. Afädëa dïe gögï fagulo neala gaula awälahilä, bu elö neasege beasimalo. ");
INSERT INTO etr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Udia dolö sulubadelaea dima nelebo afädë ïmola ëdëgëseda, ïmalo. Amase, afädëa dïe nelebo afädë neala gaula awäseda, ïa obëgëmola egedigila sämabio. ");
INSERT INTO etr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Odoaea dilima mala hamomäiala hamelo amo gadola, diliage ilima amo gadola wäla hamomalo. ");
INSERT INTO etr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dili boba hamolo amoli boba hamoseda, dili udia dolö hedabi neebela nowëa helësëmolödu. Nafade hamolo nefolalebe amoliage, ili boba hamolo neebe amoli boba hamolo nea. ");
INSERT INTO etr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amalahilä, dilima hedabi hamolo neebe amolima hedabi hamola obëgëseda, dili udia dolö hedabi neebela nowëa helësëmolödu. Nafade hamolo neebe amoliage amo gadola wäla hamolo nea. ");
INSERT INTO etr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dilia nelebo afädë ïahalea, dabe ïmäiala ïaseda, dili udia dolö hedabi neebela nowëa helësëmolödu. Nafade hamolo neebe amoliage nafade hamolo odoaea ili dabe ïmäialahilä ïlo nea. ");
INSERT INTO etr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Gasoda, dilibalä ado nii neebe amoli boba hamosa namialo. Ilima hedabi hamosa neada, nelebo afädë ilima ïahalea, hobeala dabe ïmäiala ïmabio. Amala hamoseda, dilia bidi edefade amo gaula, Dofä Ilibia Edefade neebe amoïe malö namolömelë. Mida, ema nesegelo made neebe amolimage, nafade hamolo neebe amolimage, mala hedabi hamolo nea. ");
INSERT INTO etr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dilile Diado neebe amea ugila negelo neebe amo gadola, diliage ugila negesa namialo. ");
INSERT INTO etr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesuea ado aso, sähamu nea sähalea, Dilia odoaea hamose amo made mogemalo. Amala hamoseda, dilimage made mogemolömelë. Odoama asiala hamoi gabumelëla made sämalo. Amala hamoseda, dilimage asiala hamoi gabumelëla made sämolömelë. Amase, dilia odoaea nafade hamoi amo hëla fisimalo. Amala hamoseda, dilia nafade hamoi amoge hëla fisimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dilia nelebo odoagali ïmalo. Amala ïaseda, diligalige ïmolömelë. Diligali ïmolö amoda, holöfalï made. Baala ïasegi, adugi eegela salala nobala adugai ïmolömelë. Mida, dilia odoagali mogela ïase amo gadola, diligalige amo gadola wäla mogela ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Amala sälahilä, Yesuea ilima ado besula säi. Dolö si golai elöea si golai elö amo naabogi gaula sigi aulole. Sigi awäseda, helegela balagula dögöigi digalo madele. ");
INSERT INTO etr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ema olelesebe amo gadola bëgëla hamolo neebe ameada, ïe olelelo neebe amo baagilo mademelë. Gaso, ea oodo bibila hamola dawadigisa maadelahilä, olelelo amohï gadoi aligilomelë. ");
INSERT INTO etr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Amaimo, dia dïe didooïe sihidoa gëgelë holöbö diëda melëlo amo, amai dihïle sihidoa i gäi gadoi dibe amo helësëlo made amoda, edoïe. ");
INSERT INTO etr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Dia dihïle sihidoa i gäi gadoi dibe amo fädäla made beala, didooma sähalea, Nedoo, dïe sihidoa gëgelë digai dibe alogo neahagola abilia sämolö gabu. Asigi fea negelo, dihïle sihidoa i gäi gadoi difolalebe amodale neadigilahilä, hobeala dïe didooïe gëgelë dibe amo hedabola beala neadigimolöi bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesuea ado aso, sähamu nea sähalea, I hedabi neebe ameada, gägä nafade negelo made. Amase, i nafade neebe ameada, gägä hedabi negelo mademelë. ");
INSERT INTO etr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I neebe amolia gägä negesebe amo bealahilä, i gowe gadoi neebela helësëlomelë. I äyo gägäi neebea ami awälahilä, dolöea äfäeo gägä gabula failo made. Amase, buudi äyo gägäi neebea ami awälahilä, dolöea gelebi gägä gabula failo made nea. ");
INSERT INTO etr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Afädë hedabi neebe ameage, hïle iso asigigila hedabi dibe amo gadoi ulufadigilo nea. Amase, nafade neebe ameage, hïle iso asigigila nafade dibe amo gadoi ulufadigilo nea. Helësëlo isogi nobala adugai dibe amo gadoida, adoea ulufadigilo neala säi. ");
INSERT INTO etr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesuea ado aso, sähamu nea sähalea, Na ado säsebewe dilia made bëgëla hamosalea, nema, Dafidilo Geloi-e, Dafidilo Geloi-ela säha nebegoda edoïe. ");
INSERT INTO etr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Afädë ne mia maalahilä, na ado säsebewe nabala bëgëla hamoseda, na dilima eda dolö gowe gadoi neala säla ulufadigisagomelë. ");
INSERT INTO etr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dolö amoda, afädëa mosö olelo amo gadoi nea. Dafidi ea igidaia dögöla, igi bobogamu salalahilä, mosö uli nebegi, hobeala sege digala ödä bëi edefade asi amea, mosö amo nufi gaso, fogomolöi made nelo. Mida, dolö amea mosö geloi hedabi uli amea. ");
INSERT INTO etr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amai gaso, afädëa nïe ado nabala, made bëgëla hamolo neebe amoda, dolö afädëa mosö nagadaia igau hedabola sagala made uli amo gadoi nea. Ödä bëi edefade asi amea mosö amo fogoi amole fodolofalï dagabola digala, nafademolöi nafadeila säi. ");
INSERT INTO etr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuea ado amo udia dolöma säla ïaha maadelahilä, e Gabaniama awäla besela galai. ");
INSERT INTO etr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Amida, ami hädali afädë beaha aligilo nelo amoïe hamoi hamolasilo afädë, ea edefademalä boba hamoi nelo amo, oloi baagomolöfalï dilo. ");
INSERT INTO etr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Amala dibegi, odoaea Yesu neala säi amo nabalahilä, beaha aligilo amea Yu udia dolö ilile asigi gäwi dafidilo amolima sähalea, Yesu maala, ïe hamoi hamolasilo oloi amo wahimäia, ema säla ïmolö mosaloi. ");
INSERT INTO etr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ili awäla, Yesuma gelola sähalea, Dolö beaha aligilo ameada, Yuda nilï boba hamolahilä, nilïle gedolo mosö ea olasi ameada, dia e ugila negemolöda, dofea galea. Eda hedabimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Amala säsebegi, Yesu e, hä, ilibalä asi. Awäla hä, mosö ga madela suägïla nebegi, beaha aligilo amea e damelë odoa amolima ado säsisalea, Yesu gagai awäla ema gomalä säla ïmalo. Dafidilo-o, dida na mosöa baagi sëla moholö gabu. Nafade ne gadoia mosöa di nogila digamolö amoda, dofea made gabumelë. ");
INSERT INTO etr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne dofea madela helësëse weada, nihï di neebea maala säla moholö amoge dofea made gabumelë. Dia adoeamu säsimäia. Säseda, nïe hamoi hamolasilo amo wahimolö. ");
INSERT INTO etr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na säsebe amoïe mida, gomalä. Nage ami beahamu aligilo geloi nefolalebe amoli hawa aligilo. Amase, ami dolö odoa nefolalebe amoliage, ne hawa aligilomelë. Na afädëma mosöla säseda, e aulomelë. Amase, elöma misiëla säseda, e mulomelë. Na nïe galabaia hamoi gadoi hamolasiloma gowe hamomola säseda, amo gadola hamolomelëla säila säla ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Amala sämalola säla ï amo nabalahilä, Yesu e, ea säi amogi edefademalä fudugilahilä, besuia imogola nea, udia dolö yafie e bëgëla mofiasebe amolima sähalea, Na dilima säla ïahago. Afädëa asigi afädë go gadola negei neebe, na made melï. Isilale udia dolö hili iligige, egowe gadola negei neebe, na made melïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Amala säsebegi, dolö mosaloi amoli mosöa obëgëlahilä beahamelebe, hamoi hamolasilo amo, hä, wahi sebe melï. ");
INSERT INTO etr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Holöbö nelolahilä, Yesu e Naina gaamugi moholö awäsebegi, ïe bëgëla aulo amolige, udia dolö yafie odoage gedola ebalä afiai. ");
INSERT INTO etr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","E awäla, gaamu yala amalei amoïe idi nogila digalo mia besela galaha nebegi, dolö odoaea baagoi afädë baumolöïe, yala baagido gaula mofiaha dibegi, gausiala digai. Baagoi amoïe emeada, dolö malö afädë amomu sogobai sulo. Eme amoda, didalo sulo. Gaamugi ami fii udia dolö odoa yafiege ebalä mofiaha dilo. ");
INSERT INTO etr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dafidilo Geloia udia didalo amo beala, edefademalä bobasëlahilä, ema sähalea, Dïimabula säi. ");
INSERT INTO etr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Amala sälahilä, Yesu e iwasala gaui amo ga madela ami awäla nea, iwasala gaui dafu amogi diigi. Amalebe, iwasala gaulo dolö amoli nefolalo. Yesuea sähalea, Malö malïsä, na dima säha. Nowemola säi. ");
INSERT INTO etr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Amala säsebegi, malö baagoi amo nowela galala adoi. Adosebegi, Yesuea malö amoïe eme amo hïma ï. ");
INSERT INTO etr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Udia dolö nefolalo amoli sulubadela fudugila bedälahilä, Godeïe ëi gauia adogola sähalea, Bea sälo edefade afädë nilï neebeawi maala, ulufadigila besela galalahilä, Godea ïe udia dolö ugila negemolö misi gabula säi. ");
INSERT INTO etr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesuea amala hamoi amo udia dolö amolia gaula afufula, Disiligi Yudiamadige, sege odoa ga madela dibe amoli sulubadelamadige, säla daidosa maadei. ");
INSERT INTO etr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoneïe bëgëla aulo amolia Yesuea nelebo hamoi amo ema säla ï. Amala säla ïasebegi, Yonea ïe bëgëla aulo äudä amole misialolahilä ");
INSERT INTO etr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","elema sähalea, Alia Dafidilo Geloima gomalä nabulö mosalo. Afädë moholömelëla säi amoda, dile, ma, nilïa elö beaha namolöledula nabualola säla ï. ");
INSERT INTO etr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amala säsebegi, ele awälahilä Yesuma sähalea, Alïda ödägi gelo Yonea di neebea misialosebegi misimelë. Ea dima gomalä nabualola säsio. Afädë moholömelëla säi amoda, dile, ma, nilïa elö beaha namolöledula nabulö mosalola säsebegi misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Amo galada, Yesuea udia dolö olo elö elöla oloi difolalo amoli wahila digi, mugabe nafade fedai difolalo amoli nesila digila digi, si golai difolalo amoli siia bimäia, wahila digisa nelo. ");
INSERT INTO etr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hä, Yesuea dolö äudä amolema säla obëgësalea, Ali Yone neebea obëgëla awälahilä, gomalä säla ïmalo. Alia walio nelebo hamose melï amoge, nabi amoge, ema säla ïahaleada, Si golai nefolalo amolige, siia beaha maadela, emo nafadei sefolalo amolige, emesala nawela, gudubu hamoi sefolalo amolige, wahisa maadela, amase, gëhe gai sefolalo amolige, nabaha maadela, baagoi difolalo amolige, nowelasisa maadela, busadäoi nefolalebe amolima Ado Mala Hedabi säla ïaha neebeola sämalo. ");
INSERT INTO etr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Afädëa ne beala ïe asigi afädë negei amo made digase amoda, obeägïsa neamelëlage, säla ïmolö mosalola säla ï. ");
INSERT INTO etr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Malö äudä Yoneïe ado gaula mosalalo amole obëgëibua, Yesuea udia dolö gegedola nefolalo amolima, Yoneïe helësëla sähalea, Sege nafadeia udia dolö aligilo made dibea ami afiai amoda, dilia edo bimolö afiai. Dili afiai amoda, giisi sedade foea auai dibe amo bimolö afiaile. ");
INSERT INTO etr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Amai made galëda, dili afiai amoda, edo bimolö afiai. Dolö afädëa fagulo hedabifalïmu salugai neebe amo bimolö afiaile. Nabuö. Fagulo hïdo elöi salugaloge, domaloïe molöge, nelegeige, yafie negelo amolida, ginia mosöa dilo neamelë. ");
INSERT INTO etr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gaso, dili afiai amoda, edo bimolö afiai. Bea sälo afädë neebe amo bimolö afiaile. Ä, amomelë. Amai galëda, na hä, dilima sähago. Bea sälo ameada, bea sälo odoa baagila asi neamelë. ");
INSERT INTO etr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ïe helësëla, gomalä dëdëla negei dialea. Nabuö. Nïe ado säla ïlo amo, dïe dafidila mosalamolömelë. Di e baagia emesala nawemolöïe, ea dïe idi fodolasimolömelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na dilima säla ïahago. Udiaea neegela ägüi sulubadela amoligida, afädëa Yone made baagila asi nea. Gaso, Godea Beaha Maadela Sigi Neebea ami ëi maade, holöbö gidogofalï ameada, Yone baagila asi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Udia dolö amoli sulubadelaeage, dagisi muni nelo amoliage, Yesuea säi amo nabalahilä sähalea, Godea mala hamosebe amoda, sulubadela mogoimu hamolo dialeala säi. Amala säi amoïe mida, Yonea ödägi gesa nelo amogi ilige gei nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gasoda, Felesi dolö amoliage, mala säla negei amo olelelo dolö amoliage, Yonea ili ödägi gemäia hamei made nelo amea, Godea hamei dibe ilima olei amo baagi ï. ");
INSERT INTO etr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuea ado aso, sähamu nea sähalea, Udia dolö walio neebe gowe ili ado abodo gadoima, oodo beala sämolödu. Ilida edo gadoi neadu. ");
INSERT INTO etr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ilida malësäea magaia gaamugi salea, malësä odoama uuala säia gala sähalea, Nilïa dilile bäidama dülasilebeda, dilia gosala made aligisio. Amase, nilïa oböla, dilile bobasëi gë udäi amogige, dilia bobasëla dïila made nelomelëla sälo amo gadoida ili nea. ");
INSERT INTO etr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mida, ödägi gelo Yone e maala neada, beledige wani ödäge made naala nebegi, dilia sähaleada, E mugabe fedai neala sälomelë. ");
INSERT INTO etr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Amase, Dolöïe Malö maala neada, molö ödäge naala nebegi, dilia sähalea, Wae! Dolö goweada, molö memelela made, badoia nüloge, wani ödäge edefade naala gagaolo dolö gabu. Goda, dagisi muni neloge, nafade hamologe nefolalebe amolile damelë go beasebelela sälomelë. ");
INSERT INTO etr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amala sälo gaso, Godeïe asigi falagasei amoda mogoimu dialeala ïe malö neebe amolia ulufadigilola säi. ");
INSERT INTO etr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Felesi dolö afädëa Yesu e ea mosöa molö molö misialola säsebegi, e ami awäla molö naha sulo. ");
INSERT INTO etr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nafade hamolo udia afädëge gaamu amogi sulo. Udia amea nabelebe, Yesu maala, Felesi dolö amea mosöa molö naha saleala säi amo nabalahilä, weli hedabi gafisigäi hïdo elöi ödä i igia hamoigi usi dilo amo gaula misi. ");
INSERT INTO etr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","E hä, Yesu baagido ga madela maala nea, dïisa nelo. Siaholö amea, Yesuïe emodaia dögi. Siaholöea nahi amo, udia amo hïle busa hilïa doga digilahilä, Yesuïe emogi gaula mimisa sulo. Amalahilä, weli gafisigäi usi gaui amo, Yesuïe emodaia ami söga negei. ");
INSERT INTO etr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amala hamosebegi, e misialola sälo Felesi dolö amea hïdomu helësësalea, dolö gowe bea sälo galebeda, udia ema diigisebe goweda gowe gadoi, ea nafade hamosamu filola dawadigilabio gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuea ema sähalea, Saimono-o, na dima ado afädë sämolö helësësebe amo sähagola säi. Amala säsebegi, Saimonoea sähalea, Säla Olelelo-o, sämola säi. ");
INSERT INTO etr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Amala säsebegi, Yesuea sähalea, Dolö äudäea muni gaui dolö afädëma muni bidi negela nelo. Elö ameada, giwi siliba hädali bia bidi negei. Amase, elö ameada, giwi siliba nabülasi bia bidi negei. ");
INSERT INTO etr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Elea muni beselala ïa obëgëmolö amo maade gabugi, muni eedo amea elema sähalea, Gamelä. Fisisagola säi. Hä, dia helësëseda, muni gaui dolö amoma edefademalä boba hamomolö amoda, abodoea gabula nabi. ");
INSERT INTO etr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Amala nabasebegi, Saimonoea sähalea, Muni edefade bidi negei fisi amealedula säi. Amala säsebegi, Yesuea sähalea, Dia hedabola helësëi gabula säi. ");
INSERT INTO etr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Amala sälahilä, e besuia imogola udia amoma siila nea, Saimonoma sähalea, Dia udia gowe beasebele. Ne dïe mosöa maasebegi, nïe emo nigime hëmäia, dia ne ödä osala made ïasio. Gaso, udia goweïe siaholö nïe emodaia dögi amo, oböla, hïle busa hilïa dogasisio. ");
INSERT INTO etr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne maasebegi, dia ne gaula made mimisio. Gaso, ne dafidi misia amila udia gowea, fisila made, nïe emogi gaula mimisio. ");
INSERT INTO etr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dia nïe busagia weli made hëi, gaso udia gowea weli gafisigäi gaula maalahilä, nïe emogi hësio. ");
INSERT INTO etr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Amaimo, na dima säla ïahago. Ea ne edefademalä boba hamolahilä hamoi ameada, ea nafade yafie hamosa sulo amoda, Godea hësa maadeimelëla ulufala oleimelë. Amaimo, dolö afädëa nafade holöfalï hamoi amo hëi ameada, holöfalï boba hamolomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Amala sälahilä, Yesuea udia amoma sähalea, Dia nafade hamoi amoda, na hësa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Amala säi amo nabalahilä, molö naha sefolalo odoa amolia hilidomu didiähalea, nafade hamoi hëlo neebe egoweda, nowëdula didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amala didiäha dibegi, Yesuea udia amoma sähalea, Dihï Godema asigi afädë negei amea, di damula asimelë. Dalulo salugala mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Holöfalï nelolahilä, Yesu e gaamu sulubadelagige, sege sulubadelagige, nawesa neada, udia dolöma Godea Beaha Maadela Sigi Neebe amoïe Ado Mala Hedabi säla ïïa asi. E awäse amo gadola giwilasi amolige, ");
INSERT INTO etr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","udia odoa mugabe nafade fedaige, oloige sefolalebegi, Yesuea dafidi nesila digila wahi sefolalo amolige, ebalä asi. Gaamu Magadala udia ëi Meli negei sulo amoma, dafidi mugabe gifalädalïa fedai sebegi, Yesuea nesila digi amoge, ");
INSERT INTO etr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","udia elö Yoanage, eda Gusaïe udia sulo. Egoa ameada gini Heledoïe mosö sigi aligilo nelo. Amase, Susanage, udia yafie odoage ebalä asi. Udia amoliada, ilile nelebo gaui amea, Yesuge, giwilasi amolige, ugila nelegela awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gaamu dilo amoli sulubadelagila udia dolö yafie Yesu neebea ami mafula gegedoi dibegi, Yesuea ado besula säla ïahalea, ");
INSERT INTO etr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Dolö afädëa molö gägä sagaido fëfëla aligi asimelë. Ea fëfëla aligi awäha nebegi, gägä odoa idiafa daala negei amo, udia dolöïe emoea emesala dagui dibegi, haea maala neala naha maadei. ");
INSERT INTO etr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gägä odoada, igi naga abelëidaia daala negelahilä, duulu fedala bäui gaso, ödä maadesalea bausoi. ");
INSERT INTO etr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amase, gägä odoada, ëfë äyo gägäi neebea daala negelahilä, ëfë äyo gägäi amola gedola fedala, yau hai nelo. ");
INSERT INTO etr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gägä odoa naga hedabi dibea daala negei ameada, bäulahilä i afädë afädëlaea gägä hädali afädë afädëla negeimelëla säi. Yesuea ado besula säha maadelahilä gelolafalï sähalea, Afädëa gëhea nabulöi galëda, hä, nabualola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ïe bëgëla aulo amolia ado besula säi amoïe, ema mi fädäla nabi. ");
INSERT INTO etr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Amala nabasebegi, Yesuea säla obëgësalea, Godea Beaha Maadela Sigi Neebe amoïe helësëmolöda dafidi, odoa ulufadigi made, musügä negei dilo amo, diliamu mi dawadigimäia ïmelë. Amaimo, udia dolö odoa ilima ado besulamu säla ïlo amoda, ilia beaha gaso, galone gowe gabula made bimolömelë. Amase, ilia ado nabaha gaso, asigia fädäla made helësëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuea ado aso, sähamu nea sähalea, Ado besula säi amoïe mida gowe. Gägä gadoida, Godeïe ado malamelë. ");
INSERT INTO etr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Udia dolö odoaea ado mala nabase amolida, gägä fëfëi idiafa digai amo gadoi nea. Ilia nabala asigi afädë negesegi, Godea ili damula auloea, mugabe busaea hobeala maalahilä, ado mala nabi isogi dibe amo neala gaula aulo neamelë. ");
INSERT INTO etr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Molö gägä igi naga abelëidaia daala negei amo gadoida, udia dolö odoaea ado mala nabala, obeägïla, aabela neala gaulo. Gaso, ili asigi afädë negei amo, difi made awäla, fedogola melëlo segeyogi, dïgïla aulomelë. ");
INSERT INTO etr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Molö gägä ëfë äyo gägäi neebea daala negei amoda gowe gadoi. Udia dolöea ado mala nabelo nea gaso, ili awäla nagadaia namolöïe nelebo odoagi asigia säosäologe, nelegei negelo namolöge, amase, domaloea gelola hameloge, amala helësëse ameada, ado mala nabi amo dedelela yau hahalea, gägä negei amo hedabola bëlo made neamelë. ");
INSERT INTO etr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Molö gägä naga hedabia daala negei amo gadoida, udia dolöea iso asigi mogoi hedabi negei neebe amolimelë. Ilia ado mala nabala, fisila made, aso maadela, gelola aligilo amea, gägä yafie negelo neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuea ado aso, sähamu nea sähalea, Afädëa gamali wala sagaseda, faloea made dabelo. Imidi hawage made negelomelë. Amala made. Ea walahilä, udia dolö mumusogi maase amolia yo amo bimäia, aulidaia negelo nea. ");
INSERT INTO etr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nelebo sulubadela musügä negei dibe amoda, ulufadigisa maademolömelë. Amase, dabela negei dibe amoge dawadigisa maadela, ulufadigisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Amaimo, dilia ado nabahalea, hedabola helësëla nabualo. Afädëa nelebo gaula neebe amomada, odoa baala ïmolömelë. Afädëa nelebo afädë gaui made nea gaso, holöfalï gaula neebe amo dofea gaula neala helësësa neebe amoda, fedela nimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Segeyo amo gala, Yesuïe eme edoolali e neebea ami misi. Gasoda, udia dolö yafie gegedola negegi dilo amea, ili e neebea ami nogila digamolö fu made melï. ");
INSERT INTO etr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Amalebeda, ili ifo baagido nefolalebegi, afädëa ema sähalea, Dibalä adomolöïe dieme didoolali ifo baagido misi neebela säla ï. ");
INSERT INTO etr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Amala säsebegi, Yesuea sähalea, Godeïe ado nabala bëgëla hamosa neebe amolida, nïe neme nedoolalida, amolimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Segeyo afädëgi, Yesula ïe bëgëla aulo amolali dudaia fedala fifigilahilä, Yesuea ilima sähalea, Nilï oeabo dëgëla näiado alogodigogi afiadila sälahilä afiai. ");
INSERT INTO etr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dudaia fifigila afiai gaso, Yesu eda adi dilo. Amala adi dibegi, fo edefade gelola guula maasebe amea, ödä aidagula dudaia häila fedalahilä, ili ödäea nudulä hamoi. ");
INSERT INTO etr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Amala hamosebegi, ïe bëgëla aulo amolia Yesu dibea ami awälahilä, e didiigisalea sähalea, Dafidilo-o, Dafidilo-o, nilï ödäea nudulä hamosebela säi. Amala säsebegi, Yesu e nowela fedalahilä, fo guula maase amomage, ödä aidagula fedasebe amomage nemosebegi, fo guula misi amoge boogelela, ödä aidagula fedai amoge aumalasi. ");
INSERT INTO etr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Amala hamolahilä ilima sähalea, Dilia asigi afädë negei amoda, abidi dialeala nabi. Amala nabasebegi, ili fudugila bedälahilä, hilidomu didiähalea, Dolö goweda nowëdu. Fole ödälema nemosegi, eleada, ïe ado nabelo gabula säla didiäi. ");
INSERT INTO etr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Amala hamolahilä, ili afiala sege Gelasa fii mosöa besela galai. Sege amoda Galili oeabo amo dëgëla alömodi dilo. ");
INSERT INTO etr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu e dudaiala agesua daala aligisebegi, dolö afädë gaamugi ami fii mugabe odoa fedai nelo amo maaha nebegi gausiala digai. Dolö amoda, siibafalï fagulo made gäla nelo amo neada, mosöa made diala, igi äbä baagoi giwi gasa dibea amimu diaha aligilo nelo. ");
INSERT INTO etr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dolö amea Yesu beala gelola üalalahilä, Yesuïe emo mia gumusula dia digala gelolafalï sähalea, Yesu, Gode Dofä Ilibia Edefade neebe amoïe Malö, dia nema edo hamomolö. Dia ne së ïmabiola fudugila gelola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesuea mugabe nafade amoma dolö amo dïgïla mosaloi amea amala säi. Ilia ïe naabo emoge igi ëfëa nafodola negela sigi aligisamu nelo gaso, segeyo yafiegi ema mugabe fedala, igi ëfë hësäla sadia gahamu aligilo. Mugabe amea e yamu galahilä, sege udia dolö aligilo made dibea ami nawelasisamu aligilo. ");
INSERT INTO etr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hä, Yesuea ema, Dïe ëida nowëla nabi. Amala nabasebegi, ea säla obëgësalea, Maleimelëla säi. Mida, ema mugabe yafie fedai amea, amala säi. ");
INSERT INTO etr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Amala sälahilä, mugabe fedai amolia Yesuma gelolafalï sähalea, Dia nilï sege uli nafade, mia made dibea ami mosölada, sämabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Amo gaalu sugua yafie gau ga madela nea, moosa nefolalo. Mugabe amolia Yesuma gelolafalï sähalea, Dia nilïda sugua egowelima nogila fedamolö mosöla sämola säi. Amalebe, Yesuea ilima, Ü, amamalola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Amala säsebegi, mugabe amolia dolö amo dïgïla awäla, sugua amolima nogila fedai. Amalebegi, sugua amoli gau domaladi baluluia digafula oeaba nogila digala, ödäea naha maadei. ");
INSERT INTO etr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Amala hamose amo bealahilä, sugua sigi aligilo amoli baluluia afufulahilä, gaamu dibea amige, mosö gägäwila asi dibea amige, säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Amala säi amo nabalahilä, udia dolö amolia abilia hamoi walebelela, fädäla bea afiai. Ili afiala Yesu neebea beahamelebe, dolö dafidi mugabe fedai nelo amo fagulo salugala, asigi hedabi negela obëgëlahilä, Yesuïe emo mia sebe amo beala, ili bedäi. ");
INSERT INTO etr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Melï amolia udia dolö mofiai nefolalebe amolia nabuäia, dolö mugabe fedai nelo amo Yesuea gomalä hamola nesila digisebegi, wahimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Amasebegi, udia dolö Gelasa segeamadi sefolalebe amoli sulubadela edefademalä fudugila bedälahilä, Yesuma sähalea, Dida wi namolö made. Mosalola säi. Amala säsebegi, Yesu e hä, dudaia fila bu obëgësebegi, ");
INSERT INTO etr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","dolö dafidi mugabe yafie fedai nebegi nesila digi amea, Yesuma gelolafalï, Ne dibalä mudulela nabi. Amala nabasebegi, Yesuea obëgëmalolahilä, ema sähalea, ");
INSERT INTO etr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Di dihï segea obëgëlahilä, Godea dima hamoi amo säla ïmolö mosalola säi. Amala säsebegi, dolö amea hïle gaamu dibe sulubadelamadi, Yesuea ema hamoi amo säla ïïa awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu e dudaia fila oeabo amo agesu näiado alömodi bu obëgësebegi, udia dolö gegedoi amolia, e maase amogi obeägïla, e säla olei. Mida, sulubadelaea e misiäiala beaha sefolalo amea. ");
INSERT INTO etr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dolö afädë misi amoïe ëida Yalusi. Eda gedolo mosö beaha aligilo nelo. Ea Yesuïe emo mia emo gumusula dia digalahilä, ema gelola egedigila sähalea, Na mosöa awähadula säi. ");
INSERT INTO etr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mida, ïe idiwi afädëfalï amomu, ïe gäheo i giwilasi gadoi gasoda, baagomolö ga madefalï dilo. Amalahilä, Yesu e awäse amo gadola, udia dolö yafie negegila aligi afiaha dilo. ");
INSERT INTO etr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Amase, udia afädë gäheo i giwilasigi heale olo olosamu aligilo amoge asi. Dolö afädëa ïe olo amo wahilasimolöi made nelo. ");
INSERT INTO etr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Udia amo Yesuïe baagido ga madela maala nea, fagulo sedade didigala gäi amoïe bidigi diigisebegi, heale olo awäha nelo amo fodolofalï hogosa helei. ");
INSERT INTO etr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Amala hamosebegi, Yesuea nabahalea, Nema diigise nowëala nabi. Amala nabasebegi, ili sulubadelaea, na made, na madela säla didigasebegi, Fidaea sähalea, Dafidilo-o, dibalä udia dolö yafie negegila aligi afiaha dialea madelela säi. ");
INSERT INTO etr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amala säsebegi, Yesuea sähalea, Afädëa nema diigimelë. Diigisebegi, na helësësalea, geloi nema dibe amogi doadigila asila helësësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Amala säsebegi, udia amea, e musügä made gabula helësëla, emo gigisëlahilä maala, Yesuïe emo mia gumusula dia digai. Udia dolö sulubadela amolile sidaia salea, ea Yesu diigi amoïe mi fädäla sälahilä, ne fodolofalï wahimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Amala säsebegi, Yesuea ema sähalea, Nidiwi-e, dihï asigi afädë negei amea, di wahigomelë. Dalulo salugala mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuea amala säha nebegi wäla, gedolo mosö beaha aligilo Yalusi amoïe mosöala, dolö afädë maala ema sähalea, Dïe didiwi hä, baagoi dialeamelë. Säla Olelelo gomada, halasala sämabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amala säi amo nabalahilä, Yesuea Yalusima sähalea, Bedämabu. Dia asigi afädë negemalo. Amala hamoseda, e wahimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Amala sälahilä, Yesu e mosöa ami besela galalahilä, odoa ebalä nogila digamäiala fu made ïala, Fida, Yone, Yamese, eedo emela, ilimu nogila digai. ");
INSERT INTO etr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Digahamelebe, mumusogi ami udia dolö amoli sulubadelaea didigaola gualösa dibegi, Yesuea ilima sähalea, Didigaomabu. Malö goda baagoi made. Adi dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Amala säsebegi, ilia malö amoda, hä, baagoi amodala helësësalea, ebalä öi. ");
INSERT INTO etr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amala hamosebegi, Yesuea udia malö amoïe naabogi gaula nea, Udia malö, di nowemola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Amala säia gai amole, udia malö amo hame fisigila besela galalahilä, fodolofalï nowei. Nowesebegi, Yesuea ilima sähalea, E molö muäia ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Amala hamoi amogi, malö amoïe eedole emelele asigigi edefademalä fudugisebegi, Yesuea elema gelola sähalea, Walio hamoi amoda, afädëma säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuea abosolo giwilasi amoli misialolahilä, ilia mugabe fedai nefolalebe amoli nesila digimäiage, olo elö elöla oloi difolalebe amoli wahimäiage, ilima geloige, beaha aligilo geloige ï. ");
INSERT INTO etr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Amalahilä, Godea Beaha Maadela Sigi Neebe amoïe ado mala säla ïïa afiahaleada, oloi difolalebe amoli wahila aligi afiamalola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ea ilima sähalea, Dili afiahaleada, nelebo gaula made mosalo. Galiamoge, aduge, molöge, munige, fagulo äudäge, gaula mosabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hä, dili afiala sege afädëgi besela galala, mosö afädëgi nogila digase amogimu diaha nelolahilä, giso näiadodi afiahalea, mosö amo dïgïla mosalo. ");
INSERT INTO etr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dili afiahalea, udia dolö gaamu afädëgi sefolalebe amolia, dili sigi awäla mosöa diahadula made säseda, gaamu amo dïgïla awäsolo amo gala, nilïa asiala hamoi amea gabula helësëmäia, dilile emogi gulu dao baai amo fëfëla salalahilä, afiamalola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amala säsebegi, ili afufulahilä, udia dolö nefolalebeadi ado mala säla ïadigi, sege sulubadelagi oloi difolalo amoli wahila digila nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Gamane dafidilo Heledoea, Yesuea nelebo hamosa neala säi amo nabi. Nabahaleada, odoaea sähalea, Ödägi gelo Yone baagoi amo nowela misi neala säla digi. Odoaea sähalea, Elaia ulufadigila misi neala säla digi. Amase, odoaea sähalea, Goda bea sälo dafidi nelo amoligi, afädë nowela misi neala säla digisa dibe amogi, Heledo e asigia säosäosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amalebe, Heledoea sähalea, Yoneda na muugi damumalasebegi damui amo, walio nelebo elö elöla hamosa neala udia dolöea säseweda, dolö nowëa hamosa neadula säi. Amalahilä, ea Yesu bimolöïe, fu hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Abosolo amoli obëgëlahilä, ilia hamoi amo Yesuma säla ïaha maadei. Amalebegi, Yesuea ili sigi gaula, hilidomu gaamu ëi Bedesaida moholö afiai. ");
INSERT INTO etr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Udia dolö yafie gegedoi amolia Yesu asi gabula helësëlahilä, e bëgëla afiai. Ili maala besela galasebegi, Yesuea obeägïla säla olelahilä, ilima Godea Beaha Maadela Sigi Neebe amoïe ado mala säla ïadigi, oloi mofiai amoli wahila didigisa nelo. ");
INSERT INTO etr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hä, deadisebegi, giwilasi amolia e neebea awälahilä, ema sähalea, Udia dolö gegedoi nefolalebeweli, udia dolö aligisia made weada, molö naala midilö maade gabugi, gaamu holöfalï dibea amige, sagai mosö dibea amige, hogogola mosäia afiamalamola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amala säsebegi, Yesuea ïe bëgëla aulo amolima sähalea, Ili molö muäia, dilia ïmalola säi. Amalebegi, ilia sähalea, Nilïa beledi bia, seme äudäla amolemu galea. Amai diada, nilïa udia dolö yafie nefolalebe egowelile molö bidia nea mosäia helësësebelela säi. ");
INSERT INTO etr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dolö yafie dausini bia gadoi amoli nefolalo. Yesuea ïe bëgëla aulo amolima sähalea, Dilia ili nabülasi bia biala fifigimalola sämola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bëgëla aulo amolia ea säi amo gadola säsebegi, ili hä, amo gadola fifigi. ");
INSERT INTO etr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Amala sefolalebegi, Yesuea beledi bia amoge, seme äudä amoge, gauia adala mudaia sida adogola nea, Godema nesegelahilä, beledi amoge, seme amoge, dagabodasi. Amala hamola, ïe bëgëla aulo amolima ïasebegi, ilia udia dolö sefolalo amoligali sogoi. ");
INSERT INTO etr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Amala sogoi amo, ili sefolalo amoli sulubadela naala bolesalea, odoa fea digai amo, bëgëla aulo amolia gegedola, adu giwilasi salala nobala negei. ");
INSERT INTO etr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Segeyo afädëgi, Yesula ïe bëgëla aulo amolali sefolalea, Yesu e hïdo Godema adosa sulo. Amala adolahilä, Yesuea ilima nabahalea, Udia dolö nefolalebe amoliada, ne nowë neala säha difolalebela nabi. ");
INSERT INTO etr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Amala nabasebegi, ilia säla obëgësalea, Odoaeada, ödägi gelo Yone gabula säla digi. Odoaeada, Elaia gabula säla digi. Amase, odoaeada, bea sälo dafidi nelo amoligi, afädë nowela misi gabula säla digisa dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Amala säsebegi, ea ilima nabahalea, Amai diliada, ne nowë neala sähala nabi. Amala nabasebegi, Fidaea säla obëgësalea, Godea Afädë Memelei amoda, dimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Amala säsebegi, Yesuea ilima gelolafalï sähalea, Neda gowe gabiola afädëma säla ïmabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ea amala sälahilä sähalea, Dolöïe Malö amo së edefade molö dialeamelë. Asigi gäwi dafidilo nefolalebe amoliage, gobela ïlo busa nefolalebe amoliage, mala dawadigi nefolalebe amoliage, ema bimolö habobalahilä, e baagomäia nufulömelë. Amala hamoseda, segeyo äudä nelolahilä, osodagi e nowemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Amala sälahilä, ea ili sulubadelama sähalea, Afädëa ne bëgëla moholö helësëseda, hï hamea hamela helësëlo amo fisila, segeyo sulubadelagi hïle i fügäi gaula, ne bëgëla moholö dialea. ");
INSERT INTO etr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mida, afädëa hïle namolö amo gaula fëdöla aligimolö helësëseda, ïe namolö amo hogosa helemolömelë. Gaso, afädëa hïle namolö amo ne helësëla fisiseda, ea ïe namolö amo gaula namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Afädëa nagadaia nelegei sulubadela neala gaula neëgi, hï e hogosa heleseda, nagadaia nelegei amea, e abeahäla ugila negemolödu. ");
INSERT INTO etr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Afädëa nïe ëige, nïe adoge sämolö hewaseda, Dolöïe Malö maasolo amo gala, ïe yo digalo hïdo elöibaläge, Eedoïe yo digalo hïdo elöibaläge, selesaia fii hedabifalï amolile yo digalo hïdo elöibaläge, maasolo amo gala, eege amobalä hewamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na dilima dofä sähago. Dolö odoa walio wi nefolalebeweli, made baagola, neëgi wäla, Godea Beaha Maadela Sigi Neebe amo bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuea ado amo säha maadela, segeyo gödölasi gadoi nelolahilä, ea Fida Yone Yamesela ili sigi gaula segebidaia Godema adomolö fedai. ");
INSERT INTO etr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Fedala, ea Godema adosa nebegi, Yesuïe odagi bedefala, ïe fagulo gäi amo falela, yo digai hïdo elöi eleloi neebe melï. ");
INSERT INTO etr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Amo gaalu, dolö äudä ebalä adosa nelo. Amoleda, Mosese Elaiale. ");
INSERT INTO etr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Eleda, yo digalo hïdo elöibalä maalahilä, Yesu e naga föi we dïgïla moholö ga maadese amoïe, ebalä ado adosa nelo. Amoda, Yalusaleme ami hamomolö amoïe säi. ");
INSERT INTO etr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fidage ebalä misi amolege, si gafodo gadugisalea süwia adidi difolalo. Ili adidi difolalo amo nowelahilä beahamelebe, Yesuïe yo digalo hïdo elöige, dolö äudä ebalä neebe amolege melï. ");
INSERT INTO etr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dolö äudä amolea Yesu dïgïla, hä, awäse amo gaalu, Fidaea Yesuma sähalea, Dafidilo-o, nilï wi neebeweda hedabi gabu. Nilïa sege mosö ohodoa, afädë digali, afädë Mosesegali, afädë Elaiagalila oledulela nabi. Fidaea amala säi amoda, eada gowe sähala helësëla made säi. ");
INSERT INTO etr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fidaea ado säha neebe amo gaalu, gelë häu maala, ili neebe amo dabei. Dabesebegi, ili bedäi. ");
INSERT INTO etr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gelë iso amogila ado afädë säia idogosalea, Egoweda nïe malö. Nihï memelei nelo amoda gomelë. Dilia ïe ado nabualola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ado säi amo wagaia gase amo gaalu beahamelebe, Yesu e hïdomu neebe melï. Bëgëla aulo amolia nelebo hamose melï amoda, segeyo amo gala odoama made säla ïala, musügä negei. ");
INSERT INTO etr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Amo aiyo amogi, ili gau amo digafula daala aligisamelebe, udia dolö yafie Yesu idiafa gausiamolöïe mofiai nefolalebe melï. ");
INSERT INTO etr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ili gedoia amila dolö afädëa uuala sähalea, Säla Olelelo-o, na dima gelola nabasebeweda, nïe dolö malö afädëfalï wemu gabugi, dia bimo. ");
INSERT INTO etr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mugabe fedalahilä, fodolofalï uuaha aligilo nea, mugabea amulämelasilahilä, nafiadi dibu besigaha aligilo. Amea fodolo made doadigila awäla, domalo nafadesebemelë. ");
INSERT INTO etr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na dïe bëgëla aulo golima nesila digimola gelola säi gaso, ilia nesila digimolöi made. Ulï gabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Amala säsebegi, Yesuea säla obëgësalea, Udia dolö asigi afädë made negela, asiala hamolo walio nefolalebela dili-e, na dilile yöi gaula nea, dilibalä segeyo aboläia namolödu. Dïe malö go sigi misiëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Malö amo, hä, sigi gaula, Yesu neebea maaha nebegi, mugabe amea malö amo nagadaia nidala awälahilä, amulämelasi. Amala hamosebegi, Yesuea mugabe amoma nemolahilä, malö amo wahila, eedo amoïe naabogi gausi. ");
INSERT INTO etr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Udia dolö ami nefolalo amolia Godeïe geloi edefade amo bealahilä, ili edefademalä fudugi. Udia dolö nefolalo amolia Yesuea hamoi amogi, aso, fudugisamu dibegi, ea ïe bëgëla aulo amolima sähalea, ");
INSERT INTO etr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ado säsewe dilia hedabola nabualo. Dolöïe Malö amoda, ilia odoaïe naabogi gausimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amala säi gasoda, ilia goweïe säsebela mi fädäla dawadigi made nelo. Ilia helësëmäia säla ïala made, musügä negela aligisebegi, ilia ema naba obëgëmolö amo bedäi nelo. ");
INSERT INTO etr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hä, ïe bëgëla aulo amolia hilidomu sähalea, Nilïgi baagila awäla dafidilo neebe amo eda nowë neala säla gëgësa dilo. ");
INSERT INTO etr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuea ilile asigigi helësëi nefolalebe amo bealahilä, malö holöbö afädë naabogi nabelela gaula maala, hï e mia ami ifosi. ");
INSERT INTO etr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ifosilahilä, ïe bëgëla aulo amolima sähalea, Afädëa nïe ëigi, malö holöbö gowema halïgïla namolö misiëla säseda, amoda ne namolö misiëla sähagomelë. Amase, afädëa ne namolö misiëla säseda, amoda ne fisiga welo amo namolö misiëla sähagomelë. Mida, dolö ëi maade, holöbö gidogofalï afädë dili neebe sulubadela mogogi neebe amoda, baagila asi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Amala säsebegi, Yonea sähalea, Dafidilo-o, afädëa dïe ëigila mugabe fedai nesisa neebe amo nilïa bealahilä, dolö amo nilïbalä nawelo made beala, Dia amamabiola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Amala säsebegi, Yesuea säla obëgësalea, Amamabiola sämabio. Dolö dilibalä ado nii made neebe amoda, dili sosogo neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","E selesaia mosöa gaula fedamolö segeyo amo ga madesebegi, Yesu e Yalusaleme moholö gelola helësëlahilä, awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Awäha nea, ea dolö odoama dafidi afiamalola säsebegi, ilia Samelia segeïe gaamu afädë dibea ami, ïe nelebo daiamolö asi. ");
INSERT INTO etr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gaso, Yesu e Yalusaleme moholö awäse ameada, udia dolö ami nefolalo amolia, e made säla olela gausiai. ");
INSERT INTO etr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Amala hamosebe amo bealahilä, bëgëla aulo äudä Yamese Yonelea sähalea, Dafidilo Geloi-e, udia dolö gowe ili nuloea naha maademäia, alïa selesaia mosöala nulo fisiga idogomola sädulela nabi. ");
INSERT INTO etr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amala nabasebegi, Yesuea besuia imogola elema nemolahilä, ");
INSERT INTO etr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ili sege elögi afiai. ");
INSERT INTO etr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesula ïe bëgëla aulolali idiafa afiaha dibegi, dolö afädëa Yesuma sähalea, Di awäsebe go gadola, ne bëgëla maahagola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Amala säsebegi, Yesuea ema sähalea, Ilua ügülo sefolalebe amolida, naga hagali hawa dilo galea. Amase, haea sefolalebe amolige, dilo mosö galea. Amalo gaso, Dolöïe Malö eda, busa fugulo negela dilo mosöda, maademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Amala sälahilä, Yesuea dolö elöma sähalea, Ne awäsewe gadola bëgëla misiëla säi. Amala säsebegi, dolö amea nabahalea, Dafidilo-o, nïe naadodale baula obëgëmalamolö dofealela nabi. ");
INSERT INTO etr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Amala nabasebegi, Yesuea ema säla obëgësalea, Baagoi difolalebe amoliada, hilile baagoi amo baumäia. Diada Godea Beaha Maadela Sigi Neebe amoïe ado mala säla ïmolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Amase, elöea nabahalea, Dafidilo-o, na di bëgëla moholö gaso, ne sosogoma dafidi dili hawio, namialola sämalamolö dofealela nabi. ");
INSERT INTO etr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Amala säsebegi, Yesuea ema säla obëgësalea, Dolö sagai sagalo neebe amea, noo gäwila buugila sagahalea, baagido besula beaha nea sagalo ameada, Godea Beaha Maadela Sigi Neebe amoïe hamoi hamomolöda, ulïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hobeala, Dafidilo Geloia dolö nabülasi gifalädalïaïe odoai äudä memelelahilä, ili dafidila mosäia, ea äudä äudäla sege dibeamadige, gaamu dibeamadige, e moholöido amogi dafidi afiamaloi. ");
INSERT INTO etr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ea ilima sähalea, Sagaia molö bëi yafie difolalea gaso, hëhela gegedola negelasimolöïe, hamoi hamolo amolida, ede made gabumelë. Amai gabugi, sagai eedoea ïe sagaia hamoi hamomolöïe, hamoi hamolo hï fisiga gamäia, ema adosa namialo. ");
INSERT INTO etr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dili hä, mosäia. Gaso, nabuö. Sugua sibi malö gadoi ilua ügülo nefolalebea ami, na dili fisiga gahagomelë. ");
INSERT INTO etr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dili afiahaleada, muni saleloge, aduge, emo usililoge, gaula made mosalo. Idiafa udia dolö beaseda, gausiala made, baagimalo. ");
INSERT INTO etr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dili afiala mosö afädëgi nogila digalahilä, dafidi gowedale sämalo. Dalulo mosö wegi sebe dilibalä namiäiala sämalo. ");
INSERT INTO etr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Amala sälahilä, mosöa ami sefolalebe amoligi, afädëa dalulo hamei seëda, dilile dalulo amo dolö amea gaula namolömelë. Be, ami sefolalebe amoligi, afädëa dalulo amogi hamei made seëda, dilile dalulo amo dihilima obëgëmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Amase, mosö dili aligise afädë amogimu diaha namialo. Dili molö molöge, ödä molöge, ilia ïase amo naha namialo. Mida, hamoi hamolo neebe amolida, bidi nimolö dialea. Mosö odoagi, made fifi nawemalo. ");
INSERT INTO etr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gaamu afädëgi besela galasegi, ami fii amolia säla olela, mosöa mofiamola säseda, ami awälahilä, molö ilia ïase amo mualo. ");
INSERT INTO etr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gaamugi ami oloi difolalebe amoli wahilasisaleada, ilima Godea Beaha Maadela Sigi Neebe amo, ga made misi dialeamelëla sämalo. ");
INSERT INTO etr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gaso, dili awäla gaamu afädëgi besela galasegi, dili säla olela, mosöa mofiamola made säseda, mosö baagila, idi dibe amogi awähalea, gomalä sämalo. ");
INSERT INTO etr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Dilile gaamu goweïe gulu dao nilïle emogi baai goweda, dilia asiala hamoi amo olesalea, fëfëla salala awähamelë. Godea Beaha Maadela Sigi Neebe amo ga made misi dibe amo hedabola helësëmalola sämalo. ");
INSERT INTO etr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na dilima sähago. Memelela gudimolö segeyo besela galasolo amo gala, Sodomo ilibalä memelela gudimolö amo gadola made, dofä baagila awäla, gaamu amogi nefolalebe amolibalä, gelolafalï memelela gudimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesuea ado aso, sähamu nea sähalea, Gaamu Golasini udia dolö dili, asigii gabu. Amase, Bedesaida udia dolö dilige, asigii gabu. Mida, dili nefolalebea ami geloi melëlo made gadoi hamoi amo gadola, gaamu Daia Saidonolemadi dafidi hamoi galebeda, ilia siiba asigi besula, nafade edefade hamoi amoïe ulufala, hewai fagulo salugalahilä, nisibu uii filabio. ");
INSERT INTO etr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Memelela gudimolö segeyo besela galasolo amo gala, Daia ilibaläge, Saidono ilibaläge, memelela gudimolö amo gadola made, dofä baagila awäla, dilibalä memelela gudimolö amoda, gelolafalï memelela gudimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amase, Gabaniama dilige, Godea dili gauia adogola selesaia mosöa fedamolöla helësësale. Ai. Dilida heli segea nedala digamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Afädëa dilile ado nabaseda, nïe adoge nabahagomelë. Afädëa dilima bimolö habobaseda, nemage bimolö habobahagomelë. Gaso, afädëa nema bimolö habobaseda, ne fisiga welo amomage, bimolö habobahagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dolö nabülasi gifalädalïaïe odoai äudä afiai amoli obëgësalea, obeägïla aligi obëgëi. Obëgëlahilä, ilia sähalea, Dafidilo Geloi-e, nilïa dïe ëi säsebegi, mugabe fedai nefolalo amoliage, nilïle ado nabala bëgësiola säi. ");
INSERT INTO etr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Amala säsebegi, Yesuea ilima säla obëgësalea, Na beaha nebegi, mugabe Saidani sege yabagelelo wäla, mudaiala digala aligise melïmelë. ");
INSERT INTO etr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hä, nabuö. Dilia baagolo nubage, hamabuluge diëgi daiasala mosäiage, ado nii mugabe Saidaniïe geloi baagila mosäiage, geloi amo gaula namiäia, na dilima ï amomelë. Afädëa dili made neala nafademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amaimo, mugabe amolia dilia säse nabase amogida, obeägïla made, Godea dilile ëi selesaia mosöa dëdëla negei dibe amogi, obeägïsa namialola säi. ");
INSERT INTO etr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Segeyo amo gala, Eleloi Gesamia Yesuïe isogi obeägïlasisebegi, Yesuea sähalea, Mudaiaïege nagadaiaïege Dafidilo Geloi Naado-o, na dïe ëi gauia adaha. Mida, asigi falagasei nefolalebe amolimage, nagadaia mala dawadigi nefolalebe amolimage, dia musügä negelahilä, oböla, malësä gadoi nefolalebe amolima, nelebo amoli ulufala olei amogi. Ae, nïe Naado. Dihï hamomolö helësëi amo gadola, amala hamoi gabumelë. ");
INSERT INTO etr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nïe Naadoea nelebo sulubadela nema gausimelë. Afädëa Malö eda gowe neala dawa mademelë. Naadoea hïdomu dawadigi nea. Amase, afädëa Naado eda gowe neala dawa mademelë. Malöea hïdomu dawadigi nea. Amase, Malöea ïe Eedo olemolö helësëse amolima olesegi, iliage e gowe gabula dawadigisa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Amala sälahilä, Yesuea ïe bëgëla aulo amolima besuia imogola, ilimamu sähalea, Dilida obeägïsa nea, nelebo hamose dilile siia bease gogi. ");
INSERT INTO etr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na dilima säla ïahago. Bea sälo yafieage, gini yafieage, nelebo hamose dilia bease go gadola wäla, bimolöila helësëi gaso, made melï nefolalomelë. Amase, ado mala dilia nabase go gadola wälage, nabulöila helësëi gaso, made nabi nefolalomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Segeyo afädëgi, mala säla negei amo olelelo afädëa Yesu fedogola bimolöïe nowela aligilahilä, ema nabahalea, Säla Olelelo-o, ne namolöi namolö neala gaumolöïe, abilia hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Amala nabasebegi, Yesuea ema säla obëgësalea, Ado säla negei dibe amogida, edo säla dëdëla negei dibeo. Dia beala, abilia helësëila nabi. ");
INSERT INTO etr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Amala nabasebegi, dolö amea säla obëgësalea, Dafidilo Geloi dïe Gode neebe amo dïe bobaeage, iso asigiage, geloiage, helësëloeage, boba hamosa namialo. Amase, dihïdi boba hamolo amo gadola, odoa dibalä nefolalebe amoli boba hamosa namialola säla negei dibeola säi. ");
INSERT INTO etr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Amala säsebegi, Yesuea säla obëgësalea, Dia mogolafalï säimelë. Amo gadola hamosa aligiseda, namolöi namolö gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amala säsebegi, dolö amea, ea hamoi amo hedabola hamoila sämolöïe, Yesuma nabahalea, Odoa nebalä nefolalebeda nowëdula nabi. ");
INSERT INTO etr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Amala nabasebegi, Yesuea säla obëgësalea, Segeyo afädëgi, dolö afädë Yalusalemela Yaligo moholö digala asi. Awäha nebegi, fa nelo dolö odoaea, e idiafa idia negela gaulahilä, ea nelebo gäi amo sulubadela giila neaha maadela, hï eda nufudala ïalalela, baagomolöi gadoi negesiä asi. ");
INSERT INTO etr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Segeyo amo galamu, gobela ïlo dolö afädë idi amogimu digala moholö awähaleamelebe, dolö amo bealahilä, e idi agesugi sisigala awäla baagila asi. ");
INSERT INTO etr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Amo gadolamu, Ilibai dolö afädëge amogi awähalea, dolö dibe amo bealahilä, eege idi agesugi sisigala awäla baagila asi. ");
INSERT INTO etr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amai gaso, Samelia dolö afädëge awähalea, dolö dibea ami besela galala, dolö amo bealahilä, ïe asigigi edefademalä bobasëi. ");
INSERT INTO etr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","E dolö dibea ami awälahilä, welige wani ödäge söga negela, nufi amo usulaha maadei. Amalahilä, dolö amo hïle sugua dögidaia ami negesilahilä, gedola dilo mosöa ami gaula awäla, negesiä sigi nelo. ");
INSERT INTO etr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Amalahilä, amo aiyo amogi, Samelia dolö amea muni giwi siliba äudä gaula awälahilä, gedola dilo mosö beaha aligilo amoma ïahalea, Dia dolö gowe hedabola beaha namialo. Dia e sigi nea, dïe muni odoa fisiga gase amoïeda, ne obëgëla maala, na beselala ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hä, fa neloea dolö amo nufudala ïalalei dibegi, diada, dolö ohodoa amoligi, dolö abodoea hamoi amea damelë hamoi gabula helësësebela nabi. ");
INSERT INTO etr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ea säla obëgësalea, Dolö e bobasëi ameala säi. Yesuea säla obëgësalea, Amo hamoi amo gadola, di awäla amala hamomolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesula ïe bëgëla aulolali afiala, sege afädëgi besela galai. Amida udia afädë sulo. Ïe ëida Mada. Amea Yesu sigi gaula ea mosöa asi. ");
INSERT INTO etr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Amida Madaïe emelë sulo. Amoïe ëida Meli. Amea Dafidilo Geloiïe emo mia ga madela maala salea, ea ado säsebe amo nabaha sulo. ");
INSERT INTO etr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sebegi, Madaea molö molö amo hïdomu daiaha nea, asigia yöia idogolahilä, Yesu sebea ami awäla sähalea, Dafidilo-o, nïe namelëada, na hamosewegi, halïgïla hamosalea made. Na nihïdomu hamosebewe, dia made beasebele. Ema ne ugila negela mosöla sämola säi. ");
INSERT INTO etr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gaso, Dafidilo Geloia säla obëgësalea, Mada-o, Mada-o, nelebo yafie dibe amoïe asigia säosäolahilä, asusuga asusugai neago ");
INSERT INTO etr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","gaso, nelebo afädëmu hamomolö dibego. Melia nelebo memelela nease goweda, afädëa fedela made nimolöla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Segeyo afädëgi, Yesu e sege afädëgi Godebalä adosa sulo. Ea Godema adola wagasebegi, ïe bëgëla aulo afädëa ema sähalea, Dafidilo Geloi-e, Yonea ïe bëgëla aulo amolima Godema adomäia olelei amo gadola, nilïage Godema adomolöïe, dia nilïma olelemäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Amala säsebegi, Yesuea ilima sähalea, Dilia Godema adosalea gomalä sämalo. Nilïle Naado, dïe ëi amo eleloifalï hïdo elöi namiäia hamesa neawe. Dïe Beaha Maadela Sigi Neebe amo misiäiage hamesa neawe. ");
INSERT INTO etr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Segeyo sulubadelaïe molö molö amo, segeyo amogi ïmalo. ");
INSERT INTO etr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Odoa ilia nilïma asiala hamosegi, sulubadela fisilo ameada, diage nilïa nafade hamoi amoli fisimalo. Nilï neebeawi fedogola bimolö made negesimalo. ");
INSERT INTO etr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Amala sämalolahilä, Yesuea aso, ilima säla ïahalea, Dili nebegogi afädëa, gasi mogogifalï ïe damelëa mosöa awälahilä ema sähalea, Ne damelë-e, nïe damelë afädë sege wagadi madela, ne molö maade sebegi, na mosöa misi salea. Hobea bedefala ïduläïe, dia ne beledi iso ohodoa ïmola säsegi, ");
INSERT INTO etr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","oböla, ïe damelë mumusogi dilo amea säla obëgësalea, Idi galahilä, nïe malöla nilïda hä, gedola diasia adidi dialeamelë. Dia nema halasala sämabio. Ne nowela digali nelebo neala ïmolö ulï gabumelëla säseda, abilia hamomolö gabu. ");
INSERT INTO etr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na dilima säla ïahago. Mosö eedo amea, dolö egedigila misi amoda, ïe damelë helësëla, made nowela ïalabio gaso, e damelëa bolowela egedigi ameada, ea nowelahilä, ïmose amo gadoi neala ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Amaimo, na dilima säla ïahago. Ïmola ëdëgësa namialo. Ïmola ëdëgëseda, diligali ïmolömelë. Hogosa namialo. Hogosa aligiseda, dilia beagolemolömelë. Idi gai dugimola säha namialo. Idi gai dugimola säha aligiseda, dili digamäia, idi gai doga negesimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mida, udia dolö sulubadelaea ïmola ëdëgësa neebe amolia nimolömelë. Hogosa neebe amea beagolemolömelë. Idi gai dugimola säha neebe amoma, idi gai doga negesimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Malö eedo nefolalebego, dilile malöea seme ïmola säseda, dili afädëa waadima neala ïmolöle. ");
INSERT INTO etr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Amai, dilile malöea haea iso ïmola säseda, hamabulu neala ïmolöle. ");
INSERT INTO etr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Amai, dihili dili nafade hamolo nea gaso, dilile malöma nelebo hedabi ïlo amoda, dilia dawa. Amo gadola made, dofä baagila awäla, dilile Diado selesaia mosöa neebe amea, Eleloi Gesami ïmola ëdëgësa neebe amomada ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dolö afädëma mugabe fedalahilä, adomolö ulï nelo amo Yesuea nesila digisebegi, dolö ado maade amea hä, ado adoi. Amala hamosebegi, udia dolö yafie gegedoi nefolalo amoli fudugisa nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amai gaso, odoaea sähalea, Goda mugabe neebe amolile dafidilo ëi Belesabuluea geloi ïasebegi, mugabe neebe amoli ea nesila digisa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Amase, odoa nefolalo amolia Yesu fedogola bimolöïe ema sähalea, Dolöea hamomolöi made gadoi afädë selesaia mosöala misi, dia nilïma hamola olemola säi. ");
INSERT INTO etr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amala säsebegi, Yesuea ilile asigigi helësëi dibe amo dawadigilahilä, ilima sähalea, Gädili afädë hilimu moge mogela nuduseda, gädili amo nafademolömelë. Amo gadolamu, mosö afädëgi fii hilimu moge mogela nuduseda, fii amoda mugulumolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Amaimo, Saidania sigi neebea ami moge mogela hilimu nuduseda, ea beaha maadela sigi neebe amo abeahäla namolödu. Na ado säsebeweda, dilia nema Belesabuluea geloi ïasebegi, mugabe neebe amoli dia nesila digisa neamelëla säi amoïe sähamelë. ");
INSERT INTO etr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Gaso, na Belesabuluïe geloia mugabe fedai nesila digilo galëda, dilile malö neebe amolia nesila digilo amoda, nowëïe geloia nesila digilo. Ameada, ilia dilile gudi mogelo namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gasoda, na Godeïe naabo geloia mugabe fedai nesila digisa galëda, Godea Beaha Maadela Sigi Neebe amo, hä, dili neebea gui misi dialea gomelë. ");
INSERT INTO etr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Amaimo, dolö geloi afädëa helebe dadifulo hulu sulubadela gaulahilä, hïle mosö idihë aligiseda, ïe nelegei dibe amoli hedabi dië bimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ea helebe dadifulo gaulahilä, neda dofea neala helësëi. Amai gaso, dolö geloi afädë, elö amoïe geloi baagila asi amo maala, ea nudula salolela baagila awäla, ïe helebe, dadile fedela gaulahilä, ïe nelegei amo dolö odoagali mogela sogomolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Afädë e nebalä made nea galëda, hï nebalä ado nii nea. Amase, afädëa nebalä made gedolasiseda, ea dusula afiaha maademäia nesila digisamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesuea ado aso, sähamu nea sähalea, Dolö afädëma mugabe fedai amo doadigila awäseda, mugabe amo sege falaia awälahilä, e hele fimolöïe sege hogosa nea, afädë made beagolelomelë. Made beagolesegi, hïdo sähalea, Mosö dïgïla misia ami bu obëgëmolöla sälomelë. ");
INSERT INTO etr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Awäla mosöa besela galala beahamelebe, gëgelë doala, nelebo sulubadela hedabola negesi diëgi beagolelomelë. ");
INSERT INTO etr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bea negesiä, bu doadigila awälahilä, hï eda holöbö hedabilahilä, mugabe gifalädalïa nafadefalï nafade nefolalo amoli sigi obëgëla awäla nogila digalahilä, mosö amogi aligilo. Amaimo, dolö amo dafidi nafade nelo amo baagila, hobealada, nafadeifalï aligilomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuea ado amo säha nebegi, udia dolö gegedoi nefolalebe amoligi, udia afädëa gelola säia adogosalea, Udia di neegela ägüla dodo ïlo sebe ameada, obeägïsa neala säi. ");
INSERT INTO etr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Amala säsebegi Yesuea sähalea, Amai gaso, udia dolö Godeïe ado nabala bëgëla hamosa neebe amoliada, edefademalä obeägïsa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Udia dolö yafie maahamu nebegi, Yesuea sähalea, Udia dolö walio nefolalebe welia nafademu hamosa neebe go. Ilia dolöea hamomolöi made gadoi hamomola sälo. Gaso, hamomolöi made gadoi afädë ilia bimäia made olela, Yonama hamoi amomu olemolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Siiba, Yonada nofe elöi Godea Niniba udia dolöma olei. Amo gadola wäla, Dolöïe Malöda, nofe elöi Godea udia dolö walio nefolalebe welima olesamelë. ");
INSERT INTO etr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Memelela gudisolo amo gala, gädili Siba udia dolö beaha aligilo gini udia ameada, walio udia dolö nefolalebe welibalä nowela aligilahilä, ilima dofea made hamoimelëla sämolömelë. Mida, udia amea Solomono asigi falagasei neebe amoïe ado nabulöïe, wagadi made hïle segeala naba misimelë. Gaso, nabuö. Afädë walio gui nebego eda, Solomono nelo amo gadoi made, baagila asi neamelë. ");
INSERT INTO etr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Memelela gudisolo amo gala, Niniba udia dolöea walio nefolalebe welibalä nowela nea, ilima dofea made hamoimelëla sämolömelë. Mida, ilia Yonaea Godeïe ado mala säla ï amo nabalahilä, asigi besusa maadei amea. Gaso, afädë walio gui nebego eda, Yona nelo amo gadoi made, baagila asi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesuea ado aso, sähamu nea sähalea, Afädëa gamali yola musügä negelo made, falo hawage negelo made. Ea yolahilä, udia dolö mumusogi maase amolia yo amo bimäia, aulidaia sagalo nea. ");
INSERT INTO etr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Siida domaloïe yo digalo gamali gadoi nea. Dïe si hedabi neëda, dïe domalo sulubadelagi yo digaha maadei nea. Be, dïe si nafadeseda, dïe domalo gasimi sagai nea. ");
INSERT INTO etr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Amaimo, dia hedabola idihë namialo. Dima yo digalo neebe amo usilahilä, asiala gasimi sagaloea. ");
INSERT INTO etr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amai gabugi, dïe domalo go sulubadelagi yo digaha maadelahilä, fu afädëgi gasimi sagalo afädë maade galëda, gamali yoi amo gadoia dihïdi yo digaha maadei namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuea ado amo hä, säha maadesebegi, Felesi dolö afädëa, ea mosöa molö molö misiëla säsebegi, e awäla ea mosöa ami molö naha sulo. ");
INSERT INTO etr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesuea naabo nigime hëla made, molö naha sebe amo bealahilä, Felesi dolö amo fudugisa sulo. ");
INSERT INTO etr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Amala fudugisa sebegi gaso, Dafidilo Geloia ema sähalea, Felesi dolö nefolalebela dilia gaaboge, faloge, gafodo baagidomu nigime hësalea, dilile iso asigiada, gesami awäla fa neloge, nafadege, nobai nebego. ");
INSERT INTO etr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Asigi maade dili, daia go hamosaleada, isoge hamoi madele. ");
INSERT INTO etr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Amaimo, nelebo falodaia dibe amoge, gobo isogi dibe amoge, dolö busadäoi neebe amoligali ïmalo. Amala hamoseda, dilile nelebo amo sulubadelada, dofä nigime hësa maadei diamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Felesi dolö dili, asigii gabu. Dilia molö hëdälo fogomo gadoi elö elöla sagai dibe amogi, nabülasi mogelahilä, nabü afädë neala Godegali ïlo, gaso mogola hamomolö amoge, Gode boba hamomolö amoge, made hamola buludola fisilo goea. Dafidi säi amo made fisisaleada, dilia ado edefade gowele hahamosa namolö dialea. ");
INSERT INTO etr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Felesi dolö dili, asigii gabu. Dilia gedolo mosöa dafidilo filo dibea ami fimolömu hamelo goea. Amase, magaia gaamugi udia dolö nefolalebe amolia, di go gabiola sämäia hamelo goea. ");
INSERT INTO etr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Dili asigii gabu. Dilida udia dolöea baagoi dögöla negei dibe amo made beala, fuduia asiala aulo amo gadoi goea. ");
INSERT INTO etr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Amala säi amo nabalahilä, mala säla negei amo olelelo afädëa Yesuma säla obëgësalea sähalea, Säla Olelelo-o, dia ado säi ameada, nilïge gagadesebegola säi. ");
INSERT INTO etr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Amala säsebegi, Yesuea säla obëgësalea, Mala säla negei amo olelelo nefolalebe dilige, asigii gabu. Dilia nelebo yöi häuala gaulo amo udia dolöea gaumäia negesilahilä, naabo gumu fufuia adogola ugila negelo made goea. ");
INSERT INTO etr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Dili asigii gabu. Dilile mäu nefolalo amolia bea sälo nufi amolile baui mosö, dilia olelo goea. ");
INSERT INTO etr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Amala hamolo ameada, dilile mäu nefolalo amolia hamoi amoda, dilia hedabola hamoila helësëse amo ulufala olelo. Ilia bea sälo nefolalo amoli nufudasebegi, dilia ili bauia amida, mosö olasilo gabugo. ");
INSERT INTO etr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mi amoïe, Godeïe asigi falagasei amea sähalea, Na ili neebea bea säloge, abosologe, fisiga wemolö gasoda, odoada ilia baagomäia nufudadigi, odoada ilia sëlasisa namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Amaimo, dafidi sege föi dibe sulubadela mi gäwila hamoia amila, bea sälo nefolalo nufi amoli, dafidi Aibeledale heale digaia amila awäla, Segelaeage, dolö amolia gobela ïlo mosöle aulile mogogi ami nufi amoïe heale digaia ami awäla, sulubadelaïe heale digai ameada, udia dolö walio nefolalebe weli së molömelë. Na dilima dofä säla ïahago. Amo sulubadela amoïeda, udia dolö walio nefolalebe weli së molömelë. ");
INSERT INTO etr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mala säla negei amo olelelo nefolalebe dili, asigii gabu. Mala amo dawadigimolöïe mosö isogi nogila digamäia, idi gai dogelo gii amo dilia neala musügä negelo goea. Dihili dilida, nogila digahalea made, udia dolö odoa nogila digadelä hamosegida, made nogila digamäia, dilia dofogai gabu. ");
INSERT INTO etr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuea amo sälahilä awäsebegi, segeyo amila Felesi dolö amoliage, mala dawadigi amoliage, ema gelola gagadela, elö elöla naba obëgë obëgësalea, ");
INSERT INTO etr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","e dahila nimolöi walebelela bimolöïe, fedogola bease amogi abeahäla ado säsebelela beaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Udia dolö dausini yafie gegedoi amea negegila, emoea odoa emesala dedabelesebegi, dafidi Yesuea ïe bëgëla aulo amolima säla ïahalea, Felesi dolö ilile beledi edelo yidi idihë nea, hedabola beaha namialo. Na säseweda, ilile asigi musügä negela sälo mala dibe amoïe sähamelë. ");
INSERT INTO etr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nelebo sulubadela dabela negei difolalebe amolida, ulufadigisa maademolömelë. Amase, nelebo sulubadela musügä negei difolalebe amolige, dawadigisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gasimi sagaia nea, ado dilia säi amoda, eso neë dibea ami nabulömelë. Mumusogi geleä sëdäwala säi amoda, mosö daiowa fedalahilä, udia dolöma uuala säha namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesuea ado aso, sähamu nea sähalea, Ne damelëla dili-e, na dilima sähago. Domalo baagomäia nufudalahilä, hobeala elö hamomolöi made neebe amolibalä bedämabio. ");
INSERT INTO etr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na dili gowebalä bedämolö dialeala säha. Afädëa dolö baagomäia nufudalahilä, hobeala heli segea nufuda salimolöïe geloi neebe amobalä bedämalo. Dofä, ebalämu bedämalola sähago. ");
INSERT INTO etr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Haea nelësa gigiso gadoi biada, bidi holöfalï muni giwi äudä gadoia nelo madele. Amai gaso, Godea haea amoli gadoigi, isoïe afädë elabolo made neamelë. ");
INSERT INTO etr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ea aso, dilile busagia busa hilï nebego sulubadela nidesa maadei neamelë. Haea gigiso gadoi sefolalebe amolida, holöbö gidogolahilä, dilida, abulümi hamoi nebego. Dilia bedämabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesuea ado aso, sähamu nea sähalea, Na dilima sähago. Afädëa udia dolö sefolalebe amolile sidaia, neda Gelesoïe neawela säla ulufadigiseda, Dolöïe Malö ameage, Godeïe selesaia fii nefolalebe amolile sidaia, dolö egoweda nïemelëla säla ulufamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gaso, afädëa udia dolö sefolalebe amolile sidaia, neda e sosogo mademelëla säseda, Godeïe selesaia fii nefolalebe amolile sidaia, dolö amoge ne sosogo mademelëla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Afädëa Dolöïe Malö ema ado nafadela säseda, amo hëla fisimolömelë. Gasoda, afädëa Eleloi Gesami e gagadela säseda, made hëla fisimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Amaimo, ilia gedolo mosöage, gamane beaha aligilo nefolalebea amige, busa dolö odoa nefolalebea amige, dilibalä gudimolöïe sigi awäsegi, nilïa ado abilia säla obëgëmolödu, ado edo sämolödula asigia säosäola helësëmabio. ");
INSERT INTO etr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mida, segeyo amo gala ado sämolö amoda, Eleloi Gesamia dilia sämolö dibe amo olemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dolö afädë udia dolö sefolalo amoli mogogi ami salea, Yesuma sähalea, Säla Olelelo-o, naado baagoi amoïe, nalä negei dibe amogi, nedooea ne mogela ïmäia, dia ema säla ïmola säi. ");
INSERT INTO etr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Amala säsebegi, Yesuea ema naba obëgësalea, Dolö, edoeaha. Na ali mogelasilo nea, nelebo go mogemäia, ne nowëa memelela ifosisiola nabi. ");
INSERT INTO etr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Amala nabalahilä, ea aso, udia dolö nefolalo amolima sähalea, Nelebo sulubadela dofea dialeala helësëla made, na edefade negemolöila helësëla, asiala gesami auloea, dilia hedabola idihë namialo. Dilile namolö amoda, nelegei yafie difolalebe amoligida, maademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Amala sälahilä, Yesuea ilima ado besu gowe säla ï. Nelegei yafie negelo dafidilo dolö afädëa sagaia molö mumului yafie dilo. ");
INSERT INTO etr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hä, dolö amea helësësalea, abilia hamomolödu. Nïe molö we nea negemolö mosö maade gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oböla, hïdo sähalea, Amaseda, na gomalä hamodelä. Na molö negelo mosö uli amoli hailahilä, bu edefade odoa oledelä. Amalahilä, amoligi nïe eladi gadoi widi dibe amoge, nïe nelebo odoage, mosö amoligi nidila negedelä. ");
INSERT INTO etr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Amalahilä, na nihïdo sähalea, Neda nelebo yafie hedabi negei diëgi, gäheo ï yafiegi hele salea, molö amo gadoida, negei dialea. Amalahilä, neda memalä saleada, ödä nadigi, molö nadigila hedabi samolö wedala hïdo amala säi. ");
INSERT INTO etr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ea hïdomu amala sälahilä sebegi, gaso Godea ema sähalea, Dolö gagaoi gadoi di. Dida walio gasigi baagomolömelë. Amasegi, dïe nalä negei dibede amoda, nowëa nimolö gabula säi. ");
INSERT INTO etr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesuea säla wagahalea, Afädëa hïle nelebo dagulula negesalea, Godemadi nelegei made negelo amoma, amo gadola hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Amala sälahilä, Yesuea ïe bëgëla aulo amolima sähalea, Amoïeda, na dilima säla ïahago. Molö edo molödula säla, dili namolö goïe asigia säosäola helësëmabio. Amase, fagulo edo salugamolödula säla, domaloïege asigia säosäola helësëmabio. ");
INSERT INTO etr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Molö aso, nigia galahilä, udia dolö namolö amoda, dafidilo neamelë. Amase, faguloge aso, nigia galahilä, domaloda, dafidilo neamelë. ");
INSERT INTO etr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dilia haea sefolalebe amoli helësëmo. Ilia sagai sagala molö hëhela faila gegedola negelo made, amase, negelo mosöge maade, gaso ili muäia Godea ïlomelë. Haea amoli holöbö gidogolahilä, udia dolö dilida, dafidilo nea madele. ");
INSERT INTO etr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dili neebe gogi nowëa asigia säosäose ameada, hïle nagadaia namolö amo fu holöfalï baalasimolödu. ");
INSERT INTO etr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dilia holöfalï amo gadoi hamomolöi made galëda, nelebo odoa dibe amogi asigia säosäosa nebegoda, edoïe. ");
INSERT INTO etr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dilia mama amoli memalä bäulahilä, abeahäla fedaha aligilodula helësëmo. Ilia hamoige made hamolo, amase, faguloge made hamolo neamelë. Amai gaso, na dilima säla ïahago. Solomonoea fagulo hïdo elöi salugalo amoda, mama ilile momadoi hïdo elöi amo gadoi made nelo. ");
INSERT INTO etr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Giisi mamala memalä bäui walio nefolalebe amolida, aiyo dolöea damula nulogi gobelo neamelë. Asigi afädë holöfalï negei nefolalebela dili, Godea giisi mama nefolalebe amolida, memalä momadolasilo. Amo gadola made, dofä baagila awäla, dili nefolalebegoge fagulo gämäia ïmolö madele. ");
INSERT INTO etr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amase, dilia molö ödäge, edo naha namolödula, asigi amogi amogila nea salala helësëmabio. Amo gadola säosäomolöda, dofea mademelë. ");
INSERT INTO etr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Udia dolö Gode helësëlo made amolia, nelebo amoli gadoi helësësamu aligilo nea. Amalo gaso, dilile Diadoea dili nefolalebegoea nelebo amoli nimolöi dibe amoda, dawadigi neamelë. ");
INSERT INTO etr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amaimo, dilia ïe Beaha Maadela Sigi Neebe amo helësëla, hogosa aligiseda, ea nelebo amoli sulubadela dilima baala ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesuea aso, sähamu nea sähalea, Sugua sibi sosogo nahui nefolalebela dili-e, bedämabio. Mida, dilile Diadoea ïe Beaha Maadela Sigi Neebe amo diligali ïmolöïe obeägïsa neamelë. ");
INSERT INTO etr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dilile nelebo difolalebe amo odoama bidi neaha maadelahilä, muni neasebe amoda, udia dolö busadäoi nefolalebe amoligali ïmalo. Amalahilä, dilile muni salelo gäalimulo made amo nealahilä, selesaia mosöa amimu dilile nelebo daiala negesa namialo. Nelebo hedabi amo made maadesia ami negemalo. Amida, fa neloea ga madela made muloge, amase, gasiämoea made damuloge dialea. ");
INSERT INTO etr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Amala säse amoïe mida, sege dilile nelegei hedabi dibea amida, dilile bobahëla asigilo amoda, amimu diamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesuea aso, sähamu nea sähalea, Dilia daia fagulo salugalahilä, gamali wala gaula, daiala nefolamialo. ");
INSERT INTO etr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hamoi hamolasilo dolöea, ilile dafidilo amo, dolö afädëa udia nease amoïe molö nasebea asi amo obëgëmäia, daiala beaha aligilo amo gadola, ilile dafidilo amo maalahilä, idi gai dugimola säseda, ilia e nogila digamäia, idi gai aabela dugimolöi bimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dafidilo amo maala, ïe hamoi hamolasilo amoli, süwia diala made, e beaha neëgi maaseda, ilia obeägïsa namolömelë. Na dilima dofä säla ïahago. Dolö dafidilo amea hamoi hamosalea gälo fagulo gälahilä, ilima sähalea, Dili molö muäia ïdulä, fifigimalola sälahilä, ilima molö mogela ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","E gasi mogogi maasege, sege yose gaalu maasege, ilia daiai diëgi, e maala beaseda, ilia edefademalä obeägïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amase, dilia afädë gowe helësëmäia sähago. Mosö eedoea fa nelo gowe gala moholöla helësëi galebeda, fa neloea ïe mosö dagabola digamäia, fu made ïalabiomelë. ");
INSERT INTO etr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dolöïe Malö moholö amoda, dilia gowe gala moholö gabula helësëi made neëgi, e moholö ameada, diliage daiaha namolö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Amala säsebegi, Fidaea nabahalea, Dafidilo Geloi-e, dia ado besu säsegoda nilïmamu sähale, ma, sulubadelama sähalela nabi. ");
INSERT INTO etr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Amala nabasebegi, Dafidilo Geloia säla obëgësalea, Amai galëda, sigi aligilo asigi falagaseige, nulügäige neebe ameada, ïe dafidiloea ïe hamoi hamolasilo odoa sigi namiäia, ilile molö ïlo amo gadola, segeyo hï daiala negeifalïgi, mogela ïmäiala memeleloda, nowëdu. ");
INSERT INTO etr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ïe dafidilo amo maalahilä beahalea, hamoi hamolasilo amea, hamoi amo gadola wäla hamosa neë beaseda, hamoi hamolasilo amo obeägïsa namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na dilima dofä sähago. Dafidilo amea hamoi hamolasilo amoma, ïe nelegei amo sulubadela sigi namialamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amaimo, hamoi hamolasilo amea asigiamu helësësalea, nïe dafidiloda, fodolo made moholö gabula helësëlahilä, ea udia dolö hamoi hamolasilo odoa nefolalebe amoli nufudadigi, molö ödäle naadigi, gagaolo ödäge nalahilä, gagaosa aligiseda, ");
INSERT INTO etr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ïe dafidilo segeyo gowegi, aoa gowegi moholöla helësëi made neëgi, e moholömelë. Maalahilä, ea hamoi hamolasilo amo neala nafademolöi nafadelasila, ado neadigilo neebe amolibalä namialamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hamoi hamolasilo amea, ïe dafidiloea gowe gadoi hamomalaila helësëlahilä gaso, oböla, säi amo gadola made daiala, made hamola neëgi, ïe dafidiloea e baialaea gelolafalï nufudala ïalalemolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amase, hamoi hamolasiloea, ïe dafidilo amea hamomalai amo dawa made neebe amea, baialaea nufuäiala hamosa aligiseda, ïe dafidiloea e, aso, geleä nufulömelë. Amaimo, sulubadelaea yafie nii gaula neebe amolima, bu yafie obëgëla ïmalamolömelë. Amase, afädëïe naabogi yafie gausi amoma, dofä yafie baala ïa obëgëmalamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuea ado aso, sähamu nea sähalea, Na naga föiwe gobemolö misi amo, hä, aabela söa fedala gobemäiala hamesamelë. ");
INSERT INTO etr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amai gaso, ne hä, ödägi gemolö afädë galea. Amo aso, made hamola neada, nïe iso asigigi yöi neawe. ");
INSERT INTO etr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Diliada, na nagadaiawi dalulasimolö gaula misi gabula helësësale. Na dilima säla ïahago. Amala made. Udia dolö neala mogelasimolö misimelë. ");
INSERT INTO etr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Amaimo, walio wila asogodi gogi, eme afädë sosogo bia mosö afädëgi salea, oböla, amoli äudä eamu, ohodoa eamula hilimu mogelahilä, ohodoa amolia äudä amolebalä ado neala, amase, äudä amoleage ohodoa amolibalä ado nealalahilä, moge mogela namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Amalahilä, eedoea efegebalä ado neadigi, efegeage eedobalä ado neadigisa namolömelë. Amase, emeage idiwibalä ado neadigi, idiwiage emebalä ado neadigi, amase, emea efege udiabalä ado neadigi, efege udiaeage egoamebalä ado neadigisa namolömelëla Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Amala sälahilä, Yesuea udia dolö gegedoi nefolalo amolima bu sähalea, Eso digasebeamadila mu baidili maase amo bealahilä, walio sege digamolö gabula aabela säha neëgi, sege hä, dofä digalomelë. ");
INSERT INTO etr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Amase, eso maasido amoïe dafädimadila fo maaseda, hä, eso neëa hëgïmolö gabula säha neëgi, hä, dofä hëgïlomelë. ");
INSERT INTO etr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Asigi musügä negelola dili, mudaiage, nagadaiage, gomalä hamosebela melëlo amo dawadigi nea. Gaso, walio nebegoïe hamosebe amo, mi goweïe hamosebela, made dawa nefolalebegoda, edoïela säi. ");
INSERT INTO etr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesuea ado aso, sähamu nea sähalea, Dilia mogoi hedabi dibe amo hamomolöïe, dihili made memelesegoda edoïe. ");
INSERT INTO etr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Afädëa dibalä gudimolömelëla säla, di sigi gaula awäseda, gudilo mosöa ami, aso, made besela galala, idiafa awäha nea, ebalä ado adola aeala hamogimolödale helësëmalo. Amala made hamoseda, ea di gudi mogelo dolö neebea ami dusugala gaula awäla, gudi mogelo dolö amea, di dadi gaui dolö amolima gausila, dadi gaui dolö amolia, di galabaia mosöa ami ifosimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na dima sähago. Dia nafade hamoi amoïe, ilia dima muni hamomalai amo gadoi, bidi neaha maademäia, galabaia mosöa ifosi neamu, made moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Segeyo amo gala, dolö odoa Yesuea säsebea ami nefolalo amolia, Galili fii dolö odoaïe ema säla ï. Galili dolö amolia Godegali odala ï gobela ïaha nebegi, Gabena Bailadia ïe ami dolö nefolalo amolima nufualoi. Nufi amolile heale odala ïïe healebalä gegoai amoïe, ilia Yesuma säla ï. ");
INSERT INTO etr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Amala säla ïasebegi, Yesuea säla obëgësalea, Galili dolö amoli amo gadola së mai amoda, dilia helësësalea, ilia nafade hamoi amea, Galili udia dolö odoa amoli sulubadela baagila asila helësësale. ");
INSERT INTO etr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ai, amala mademelë. Na dilima säla ïahago. Dilia asigi made besuseda, dili sulubadelage amo gadola baagomolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Amaimo, Sailoama mosö sedade olola fedai amo dagabola digahalea, nabülasi afädëïe odoai gödölasi nufudala baagoi amolia, nafade hamoi amea, udia dolö odoa Yalusaleme neebe amoli sulubadela baagila asila helësësalela nabi. ");
INSERT INTO etr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ai, amala mademelë. Na dilima säla ïahago. Dilia asigi made besuseda, dili sulubadelage amo gadola baagomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Amalahilä, Yesuea ado besula sähalea, Dolö afädëa ïe gelebi hawa sagaia ami äfäeo hawa afädë sagasi nelo. Ea äfäeo amo gägä negei dibelela bea awähamelebe, gägä made negei melï. ");
INSERT INTO etr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Amai gabugi, ea sagaia hamoi hamolasilo amoma sähalea, Nabuö. Na gäheo i ohodoagi, äfäeo i wagadi egowea gägä negei walebelela bea maahamu nelo amo, walioge bea misi gaso, hä, gägä made negei gabumelë. Amai gabugi, dia i go abadigimalo. Mi edoïe ea memalä naga goïe säfe go nalï naha namolöla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amala säsebegi, dolö amea säla obëgësalea, Dafidilo, e aso, gäheo i afädë namiäia fisigisimo. Na goïe mia naga go dagabola digilahilä, sugua gao gaisa negedelämelë. ");
INSERT INTO etr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gäheo i namolömadi gogi, hä, gägä negeseda, amo dofea. Gägä made negeseda, dia hä, abadigimäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Segeyo Sabada gafegi, Yesu e gedolo mosö afädëgi nogila digalahilä, säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Udia afädëma mugabe nafadea ololasi amea, gäheo i nabülasi afädëïe odoai gödölasi, ïe domalo mogola aligimolö ulï sulo amo, gedolo mosöa ami sulo. Udia amo baagi gugi amea, e dofä mogola aligimolöi made sulo. ");
INSERT INTO etr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuea udia amo beala e misialalahilä, ema sähalea, Udia-o, di oloi amoda, na hä, fisigäimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amala sälahilä, ïe naaboea udia amoma diigi. Amala diigi amole, udia amo hä, mogola aligilahilä, Godeïe ëi gauia adaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amala hamosebegi, gedolo mosö beaha aligilo dolö amea, segeyo Sabada gafegi Yesuea udia amo wahi gabula habobalahilä, udia dolö sefolalo amolima sähalea, Segeyo gafeia dibe amoligida, hamoi hamolo. Segeyo amoligi nea, oloi difolalebe amoli wahimäia moholö dialea. Segeyo Sabada gafegi wahimäia, moholöi mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Amala säsebegi, Dafidilo Geloia ema säla obëgësalea, Asigi musügä negelola dili, segeyo Sabada gafegida, dili sulubadelaea sugua gao mosöa awälahilä, dilile sugua gao galëge, sugua dögi galëge, gide begela negei dibe amo fisigäla, ödä muäia sigi gaula awäla, ifosilo madele. ");
INSERT INTO etr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Amaimo, udia goweda, Abalahamaïe idiwi afädë amo, Saidania e gäheo i nabülasi afädëïe odoai gödölasi nafodoi sulo. Na e nafodoi amo, segeyo Sabada gafegi, fisigämolö dialea madelela säi. ");
INSERT INTO etr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ea amala säla obëgësebegi, ebalä ado nii nefolalo amoli nafadela hewai. Amai gaso, udia dolö nefolalo amolia, ea nelebo hedabi hamose amo sulubadelagi, obeägïsa nelo. ");
INSERT INTO etr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Amasebegi, Yesuea sähalea, Godea Beaha Maadela Sigi Neebe amo gowe gadoimelëla, na abodo gadoima oodo beala sämolödu. ");
INSERT INTO etr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Amoda masada gägä gadoi dialeamelë. Dolö afädëa masada gägä afädë gaula awälahilä, ea sagaia ami sagai. Masada amoda bäulahilä, i gadoi neëgi, haea sefolalebe amolia adomo amogi, gilifa hamola dilola säi. ");
INSERT INTO etr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuea ado aso, sähamu nea, bu elö nabahalea, Godea Beaha Maadela Sigi Neebe amoda, na abodo gadoima oodo beala sämolödu. ");
INSERT INTO etr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Amoda beledi edelo yidi gadoi dialeamelë. Udia afädëa falodaia balawa edefade besigala salala, beledi edelo yidi amola gegoala naabolahilä, beledi sulubadela edela bolela fedalola säi. ");
INSERT INTO etr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu e Yalusaleme aulo idi amogi awäha nea, gaamu dibeamadige, sege dibeamadige, säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dolö afädëa ema nabahalea, Dafidilo-o, Godeada dolö afädë afädëla damula moholölela nabi. Yesuea ilima säla obëgësalea, ");
INSERT INTO etr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Idi doga negei dedelei holöfalï amogi nogila digamolöïe, dilia gelola elëlisa namialo. Amoïe mida, na dilima säla ïahago. Udia dolö maleia nogila digamolöila asigila, nogila digaha gaso, ulïmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hobeala, mosö eedo amo nowela fedalahilä, mosö idi gaseda, dili maala, ifo baagido segea nea, idi galogi nufigisa nea, uuala sähalea, Dafidilo, nilï mudulä, idi gai dugimola sämolömelë. Gaso, ea dilima säla obëgësalea, Na dili dawa made. Dili guwila misilage, na dawa made neamelëla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Amala säsegi, dilia säla obëgësalea, Nilïda dibalä molö ödäge naha aligilo amo, amase, diada nilïle idiafa nea, säla olelelomelëla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amala säsegi, ea bu elö sähalea, Na dili dawa made. Dili guwila misilage, na dawa made neamelë. Mala nafademu hamolo neebe dili sulubadela, nïe odagia namolö made. Moholöi mosöla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Amala säsegi, dilia Abalahamage, Aisagage, Yeigabage, bea sälo ili sulubadelage, Godea Beaha Maadela Sigi Neebea ami neebe amo bealahilä, dili segea sogobala sadia gai nea, dilia dïisalea, bese ali nalëgësa namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Amaimo, udia dolö eso maasidolage, eso digasidolage, agesu näiadodilage näiadodilage, mafula gegedolahilä, Godea Beaha Maadela Sigi Neebea ami molö naha samolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nabuö. Walio udia dolö odoa hobeala nefolalebe amolida, oböla, dafidisalea, amase, dafidila nefolalebe amolida, hobeamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Amala säha neebe amo gaalu, Felesi dolö odoa Yesu neebea maalahilä sähalea, Dida segewe dïgïla, sege odoadi mosalo. Mida, Heledoea di nufulö helësësa nea wabu. ");
INSERT INTO etr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Amala säsebegi, Yesuea säla obëgësalea, Dili awälahilä, ilua ügülo goma gomalä säla ïmalo. Nabuö. Walio aiyo namolö amogida, neda mugabe fedai nefolalebe amoli nesila digi, oloi difolalebe amoli wahila digisa namolömelë. Amalahilä, segeyo osodagida, na hamoi hamoi amo, hä, wagamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amase, walio aiyo gahadala amogida, ne moholö dialea. Mida, bea sälo neebe amoda, sege odoadi nufudala made baagola, ilia e Yalusaleme amimu neëgi, nufudala baagomolö dialea. ");
INSERT INTO etr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yalusaleme-e, Yalusaleme-e, bea sälo nefolalo amoli nufudala baagologe di. Amase, dolö digali fisiga wei amoli igia nufideloge di. Haea gagalugoea ïe malö augia hawa neala gafedela, musügä negelo amo gadola, segeyo aboläiagi gadola, na dïe malö goli neala gegedolasideläi gaso, dihili habosio. ");
INSERT INTO etr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nabuö. Godea dilile mosö dïgïla awäsegi, mosö amo memalä diamolömelë. Na dilima sähago. Dilia ne bu elö made beala nelolahilä, dilia sähalea, Dafidilo Geloiïe ëigila maahago, Godea e neala obeägïlasimäiala säsolo amo gala, dilia ne bimolömelëla Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Segeyo Sabada afädëgi, Yesu e Felesi ilile busa dolö afädëïe mosöa molö naa awäsebegi, udia dolö nefolalo amolia, ga madela sisila beaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dolö domalo gagalula nafadei afädë Yesuïe odagi gaalu ami sulo. ");
INSERT INTO etr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dolö amo bealahilä, Yesuea mala säla negei amo oleleloge, Felesi dolöge sefolalo amolima nabahalea, Segeyo Sabada gafegi wahilasimolöda dofeale, ma, dofea madelela nabi. ");
INSERT INTO etr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amala nabasebegi, ilia made säla obëgëi. Amasebegi, ea dolö amo neawela wahilahilä, e mosaloi. ");
INSERT INTO etr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Amala hamolahilä, ea ilima nabahalea, Dili sebe gogi afädëïe malö galëge, sugua gao galëge, segeyo Sabada gafegi ödä dögöigi digaseda, fodolofalï dusugala nimolölela nabi. ");
INSERT INTO etr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amala nabasebegi, ilia säla obëgëmolöi made melï. ");
INSERT INTO etr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuea beahamelebe, dolö odoa molö naa misi mumusogi digafiai amolia, filo hedabidaiamu fimolö memelesebegi, ea ilima ado besu afädë gowe säla ï. ");
INSERT INTO etr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Dolö afädëa udia neahalea, molö molö misialola säsegi awäseda, filo hedabidaiamu fimabio. Di gadoi made, ilia dolö ëi sälo memelei neebe amoge misialaloea. ");
INSERT INTO etr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Amala misialai galëda, dige, dolö ëi sälo amoge welo amohï maalahilä, dima säla ïahalea, Filo di sebegoda, dolö gowegali ïmola säsegi, di nafadela hewalahilä, baagidofalï fila digamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amo gadola made, dolö afädëa di misialola wesegi awäseda, dida baagido samialo. Dia amala hamoseda, dolö di welo amohï maalahilä dima sähalea, Ne damelë-e, di filo hedabidaia guwi fimolö misiëla sämolömelë. Ea amala säse ameada, udia dolö molö naha sefolalebe amoli sulubadelaïe siigi, di ilibialasimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Udia dolö hili ili ilibialo amoli sulubadela neala nagadaialasisalea, amase, afädë hï e nagadaialo neebe amoda, ilibialasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Amala sälahilä, Yesuea dolö molö molö misialola e wei amoma sähalea, Dia esoa galëge, deadi galëge, molö afädë giaseda, di damelëge, didooge, di sosogoge, amase, muni gaui dibalä sebe amolige, molö molö misialola wemabio. Hobeala, amo dabe ilia dili molö molö misialola säloea. Dabe amala säse ameada, dia hamoi amoïe bidi nii aguimelë. ");
INSERT INTO etr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hä, dia molö afädë giaseda, dolö busadäoi sefolalebe amolige, domalo nafadei sefolalebe amolige, emo nafadei sefolalebe amolige, amase, si golai sefolalebe amolige, molö molö misialola weseda, ");
INSERT INTO etr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","dia obeägïsa namolömelë. Dolö amoli gadoi nefolalebe amoliada, dia molö giala ï amo dabe made ïa obëgëmolö gaso, hobeala Godea udia dolö hedabi hamolo baagoi amoli nowelasisolo amo gala, bidi ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesubalä molö naha sefolalo amoligi, afädëa ado amo nabalahilä, Yesuma sähalea, Udia dolö Godea Beaha Maadela Sigi Neebea ami nogila digala, molö naha samolö amoliada, obeägïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Amala säsebegi, Yesuea säla obëgësalea, Dolö afädëa molö edefade giamolöla helësëlahilä, molö amo molö, ea udia dolö yafie misialola hobe säi. ");
INSERT INTO etr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hä, dolö amea molö molö segeyo daiai amo besela galasebegi, ea ïe hamoi hamolasilo amoma, dolö dafidi hobe säi amoli bea mosalolahilä, dia ilima gomalä sämalo. Nelebo sulubadela daiai dibe ameada, dili misiëla sämalola säi. ");
INSERT INTO etr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amala säsebegi, udia dolö amoli sulubadelaea, Nilïda made moholö gabumelëla säi. Afädëa sähalea, Neda sagai nofela nii dibe amo beaha namolö dibe ameada, asigii gabu, ne made moholömelëla säila sämaloi. ");
INSERT INTO etr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Elöea sähalea, Neda sugua gao nabülasi waliomu nealahilä, ne amo oodo beala beaha namolö awäse weada, asigii gabu, ne made moholömelëla säila sämaloi. ");
INSERT INTO etr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Amase, elöea sähalea, Neda, hä, walio wäla udia nii ameada, ne moholö ulï gabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Amala säla obëgësebegi, hamoi hamolasilo amo obëgëlahilä, ea ado amoli ïe dafidilo amoma säla ï. Amala säla ïasebegi, ïe dafidilo amea ado amo nabala, mihalälahilä, ïe hamoi hamolasilo amoma sähalea, Di fodolofalï awäla, gaamugi aulo idi edefade dibe amoligige, amase, idi holöfalïgi aulo dibe amoligige awälahilä, dolö busadäoi sefolalebe amolige, domalo nafadei sefolalebe amolige, emo nafadei sefolalebe amolige, amase, si golai sefolalebe amolige, dia sigi maala, nïe mosöa nogila digamolö misialola säi. ");
INSERT INTO etr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Amala säsebegi, hamoi hamolasilo amo fodolofalï awäla, obëgëlahilä sähalea, Dafidilo-o, dia säi amo gadola hamosa maadei gaso, mosö, aso, fu dibemelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Amala säsebegi, dafidilo amea hamoi hamolasilo amoma sähalea, Nïe mosö nobamäiaïe, di gaamu dïgïla segea awäla, aulo idi edefade dibe amoligige, sagai mosöa aulo idi holöfalï amoligige awälahilä, udia dolö amolima misiëla gelola sämalola säi. ");
INSERT INTO etr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na dilima säla ïahago. Na dafidi hobe säi dolö amoligi, nïe molö daiai amogi, afädëa diigila, molö made gabumelëla säila Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Segeyo afädëgi, udia dolö yafie Yesu bëgëla maaha dibegi, ea ilima besuia imogolahilä sähalea, ");
INSERT INTO etr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Afädë ne neebea maase amea, ïe eedole emelemage, ïe udia malölalimage, ïe edoole elefilemage, amase, hïle namolöfalï amomage, made habobaseda, eda nïe bëgëla aulo namolöi mademelë. ");
INSERT INTO etr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Amase, afädëa hïle i fügäi neala gaula, ne awäsewe gadola bëgëla made maasege, nïe bëgëla aulo namolöi mademelë. ");
INSERT INTO etr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Amaimo, dili nebegogi, afädëa sagai idihë namolöïe mosö, holöbö ilibia ulimolö helësëseda, na mosö olala agumolöïe muni dofea dialealedula helësëlahilä, mosö we muni gowe gadolaeada ulimolö gabula dafididale helësëmolö madele. ");
INSERT INTO etr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ea dafidi amala made helësëla, mosö igau sagala, sedade olase amo made aguseda, udia dolö amo bease amoli sulubadelaea, e gadiabola ");
INSERT INTO etr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","sähalea, Dolö gowea mosö oledelä mi gäwi gaso, agumolöi made gabula sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Amase, beaha aligilo gini afädëa, gini elöbalä nudula moholö neëda, ea dafidi salea helësësalea, nïe ami dausini nabülasi afädëada, gini elö amoïe ami dausini nabülasi äudä sigi maase amolibalä nudula gaalumolöiledula helësëmolö madele. ");
INSERT INTO etr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Helësëla beahamelële, dofea made gabula helësëseda, aso, wagadi made maaha neëgi, nudula made, fisila dalumolöïe, dolö odoaea aeala ado sämolö mosalala sälomelë. ");
INSERT INTO etr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Amo gadola, dili neebe gogi, afädëa ïe nelebo dibe amoli sulubadela made fisisa maadeseda, nïe bëgëla aulo namolöi mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesuea ado aso, sähamu nea sähalea, Ëbïda hedabi galea. Gaso, ëbï hëdälo amo hogosa heleseda, edoea bu hëdälasimolöi gabu. ");
INSERT INTO etr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ëbï amo gadoiada, molö sagai hedabola fedamäia, ugila negemolöi mademelë. Amase, nilïa sagaia ami sugua gao gaisa gedola negemolöi made. Fisimolö dialea. Afädëa gëhea nabulöi galëda, hä, nabualola säi. ");
INSERT INTO etr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Segeyo afädëgi, dagisi muni neloge, nafade hamologe, Yesu neebea ga madela nea, ea ado säse amo nabulö misi. ");
INSERT INTO etr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Gaso, Felesi dolöle mala dawadigi dolölea, habobala sëdäwala sähalea, Dolö egoweada nafade hamolo neebe amolibalä damelë hamologe, ilibalä molö naha aligiloge, neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Amala säsebegi, Yesuea ilima ado besu gowe säla ï. ");
INSERT INTO etr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Dili afädëa sugua sibi hädali afädë foi nelo amoligi, afädë dabadigi galëda, eada sugua sibi nabülasi sëgëlasiïe odoai sëgëlasi amolida, giisi naha namiäia ifosilahilä, afädë dabadigi amo bimolöila, awäla hogosa nea, giso, beagolelo madele. ");
INSERT INTO etr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ea hä, beagolelahilä, obeägïla, hï sogobala gïdädaia gaula ");
INSERT INTO etr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mosöa obëgëlo. Obëgëlahilä, e damelëla ilige, ea mosö ga mamadela sefolalebe amolige, wela gegedolahilä sähalea, Nïe sugua sibi afädë dabadigi amo, hä, beagolei amogi, obeägïsa neawe. Nihïlïgïla gaalu obeägïdila sälomelë. ");
INSERT INTO etr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Amo gadola hamolo amoïe, na dilima säla ïahago. Udia dolö nabülasi sëgëlasiïe odoai sëgëlasi asigi mogoi neebe amoli, bu asigi besumolö made neëgi, afädëa nafade hamosa nelo amo asigi besuseda, selesaia mosöa hïdo elöla obeägïmolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesuea ado aso, sähamu nea sähalea, Udia afädëa muni giwi nabülasi gaula nea, giwi afädë mosöa ami dabadigiseda, ea hä, gele wala gaulahilä, bimolöila mosöa gëgelë doala, geleä hedabola hogosa nea, giso, beagolelo madele. ");
INSERT INTO etr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ea muni amo beagolelahilä, e damelëla ilige, ea mosö ga mamadela sefolalebe amolige, wela gegedolahilä sähalea, Nïe muni giwi afädë dabadigi amo, hä, beagolei amogi, obeägïsa neawe. Nihïlïgïla gaalu obeägïdila sälomelë. ");
INSERT INTO etr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Amo gadola hamolo amoïe, na dilima säla ïahago. Afädëa nafade hamosa nelo amo asigi besuseda, Godeïe selesaia fii neebe amolia obeägïlomelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuea ado aso, sähamu nea sähalea, Dolö afädëïe dolö malö äudä sulo. ");
INSERT INTO etr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amala salea, malö üfï amea eedoma sähalea, Naado, munige, nelebo odoage, nedoo halïma mogela ïmolö dibe gogi, nïe amo nihïma mogela ïmola säi. Amala säsebegi, eedo amea sulubadela helema mogela ï. ");
INSERT INTO etr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Amala hamola, segeyo ede made nelolahilä, üfï amea, ïe nelegei amo odoama bidi neaha nelolahilä, muni amo gaula, sege wagadi made, gädili elögi namolö bahïla asi. Segea ami nea, nelebo galone hamomolöi made amo hamosalea, ea muni gauia amo waeasesa maadei. ");
INSERT INTO etr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amalahilä, muni gaui amo maadei amoleda, segea ami sïdë i edefade gelola besela galai. Amo gala, malö amea nelebo afädë made gaui nelo. ");
INSERT INTO etr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Amala nebegi, segea ami fii dolö afädëa, ïe hamoi hamomolöïe, yala isogi dia nïe sugua sigi namialai. ");
INSERT INTO etr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Amala sigi nea, sugua amolia falaga mai gafodo dibe amo beala hamelahilä, bolemäia neala nuduläla helësëi. Gaso, afädëa e molö made ï. ");
INSERT INTO etr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amalahilä, hobeala asigi negela obëgësebegi, ea sähalea, Nïe naadoïe hamoi hamolo nefolalebe amolida, molö yafie naha diëgi, ne molö made naala wi nea, hä, dofä baagomolö gabu. ");
INSERT INTO etr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gamelä, neda naado neebea obëgëla awäla, gomalä sämolö. Naado-o, na Gode selesaia mosöa neebe alima, nafade hamoimelë. ");
INSERT INTO etr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hä, walio neda hedabi made. Ne dïe malöla sämolöi made neawe. Dïe hamoi hamolo amolima hamosa neebe go gadola, nemage hamomalola sämolöla säi. ");
INSERT INTO etr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Amala sälahilä, e nowela eedo neebea awäha nelo. E aso, eedo neebea made besela galala, holöbö wagadi made maaha nebegi, eedoea e beala, ïe iso asigia bobasëlahilä, baluluia awäla, neawela mimi. ");
INSERT INTO etr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Amala hamosebegi, efege amea sähalea, Naado-o, na Gode selesaia mosöa neebe amo alima, nafade hamoimelë. Hä, walio neda hedabi made. Ne dïe malöla sämolöi made neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amala säsebegi, gaso eedoea ïe hamoi hamolasilo amolima sähalea, Dilia nïe fagulo didiga salugalo hedabifalï amo, fodolofalï nea awälahilä, egali gäsimalo. Amalahilä, ïe naabo sesafogi, ulini salugasila, emo usililoge salugasimalo. ");
INSERT INTO etr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Amalahilä, sugua gao üdïli säfei neebe amo, dilia sigi gaula maala, nufualo. Nilï, hä, molö naala obeägïdi. ");
INSERT INTO etr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mida, nïe malö go baagoi gaso, walio namolö bu obëgëla misi neebe amogige, e dabadigi gaso, nilïa beagolei amogigela säi. Amala säsebegi, ilia obeägïla molö edefademalä giala mai. ");
INSERT INTO etr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Amo giala nase amo gaalu, malö abulümi amoda sagaia nelo. Hobeala, e mosöa obëgësalea, mosö ga madela nea nabelebe, mosöa ami udia dolöea ilibo gaula digi, gisalï gaula, sigola digisalea, goba fedase amo nabi. ");
INSERT INTO etr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Amala hamosebe amo nabala, ea hamoi hamolasilo amoligi, afädë welahilä nabahalea, Ilia goda edo hamosebela nabi. ");
INSERT INTO etr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hamoi hamolasilo amea säla obëgësalea, Didoo amo, hä, obëgëla misi amogi, diadoea, sugua gao üdïli säfei nelo amo nufualai. Mida, ïe malö amo, made baagola, obëgëla misi amogi. ");
INSERT INTO etr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Amo nabala, malö abulümi amea mihalälahilä, e mosöa nogila digamolö helësëi made nelo. Amala hamosebegi, eedo e segea doadigila fedalahilä, abulümi amo nogila digamäia, ema aeai ado odoa säla ï. ");
INSERT INTO etr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gaso, ea eedoma säla obëgësalea, Ne gäheo i yafie dibalä nea, dïe hamoi baagi sëi, memalä galabaia hamoi gadoi hamolasisa nea, dïe ado neadigila made nelo. Amai gaso, dia segeyo afädëgi, na ne damelë neebe amolibalä obeägïmäia, sugua meme üdïli afädë made ïlo amo, dihï helësëmo. ");
INSERT INTO etr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dïe malö go idigi nawela susugu hamolo udia amoligali, dïe muni ïala waeasesa maadei amo obëgëla maasebegi, dia sugua gao üdïli säfei nelo amo, nufuda negei gabio. ");
INSERT INTO etr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Amala säsebegi, ïe eedo amea säla obëgësalea, Nïe malö-o, dida segeyo sulubadelagi halïgïla nelo. Nelebo nïe dibe amo sulubadela, dïe dilo amoda. ");
INSERT INTO etr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gaso, dïe didoo amo baagoi gaso, walio namolö bu obëgëla misi neebe amogige, e dabadigi gaso, nilïa beagolei amogige, walioda, nilïle iso asigia, hïdo elöla haeafula obeägïmolö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuea ïe bëgëla aulo amolima sähalea, Nelegei yafie negelo dafidilo dolö afädë nelo. Dolö afädëa dafidilo amoïe nelegei amoli sigi nebegi, dolö odoa dafidilo neebea ami maalahilä, ïe nelebo sigi aligilo amea nafade hamoimelëla sämolöïe, dafidiloma sähalea, Dïe nelebo sigi aligilo amea, dïe muni amoda, waeasese melïmelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Amala säla ï amo nabalahilä, nelegei yafie negelo dafidilo amea, ïe nelebo sigi aligilo amo misialola welahilä, ema nabahalea, Dïe sedalu afädë na nabi amoda, abilia hamoi. Nïe nelebo dia sigi neebe amoli hedabola nidelahilä, dëdëla negesa maademolö mosalo. Dida nïe nelebo sigi aligilo namolö mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Amala säsebegi, nelebo sigi aligilo amea hïdo sähalea, Nïe dafidilo ameada, ïe nelebo sigi nelo amo dïgïla mosalola, hä, säi amo gabu. Amai na edo hamomolödu. Na odoaïe hamoi hamolasila, naga dagabomolö amoge, geloi maade gabu. Amase, odoama muni ëdëgëmolö amoge, ne hewai gabu. ");
INSERT INTO etr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wae! Na hamomolö amo helësësawe. Nïe dafidilo neebe amea, na nelebo beaha neebewe haila fisiseda, na gowe gadoi hamomolöla helësësewe hamoseda, ne damelë neebe amolia, neda ilia mosöa misiëla sämolöla helësësala säi. ");
INSERT INTO etr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Amala helësëlahilä, ea ïe dafidilo amoma bidi negelo dolö amoli, hïdo hïdola wela mofiamalolahilä, dafidi misi amomadale nabahalea, Dia nïe busa dolöbalä bidi aboläia negei dialeala nabi. ");
INSERT INTO etr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ea säla obëgësalea, Olibe gägäïe weli ödä i edefadegi usi hädali afädë bidi negei neamelëla säi. Amala säsebegi, sigi aligilo amea dolö amoma sähalea, Dia bidi negei amoïe beba amoda gomelë. Dia beba go nealahilä, hä, fodolofalï fia idogola salea, nabülasi bia dëdëmola säi. ");
INSERT INTO etr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Amala sälahilä, ea dolö elö amoma nabahalea, Dia bidi aboläia negei dialeala nabi. Amala nabasebegi, elö amea säla obëgësalea, Eladi gadoi widi sali adu dausini afädë bidi negeimelëla säi. Amala säsebegi, sigi aligilo amea ema sähalea, Dia bidi negei amoïe beba amoda gomelë. Dia beba go nealahilä, hä, hädali gödölasi dëdëmola säi. ");
INSERT INTO etr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hobeala, dafidilo amea sigi aligilo mogoi made, asigi halowei amoma sähalea, Dia hobeala edo hamomolö amo hedabola helësëla, amala hamoi goda, hedabola hamoi gabumelëla säi. Nagadaia namolöïe malö amolia, yo digaloïe malö amolia hamolo amo gadoi made, baagila awäla, odoa hili ili gadoi helësëla hamolo amoda, hedabola helësëla hamolomelë. ");
INSERT INTO etr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na dilima säla ïahago. Nagadaiaïe muni dibe ameada, udia dolö odoa neebe amoli damelë hamomalo. Amala hamosa neëgi, munia hamoi hamolo amo wagasolo amo gala, Godea namolöi namolö dibea ami, namolö misiëla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Afädëa nelebo holöfalï dibe amo, hedabola sigi aligiseda, nelebo edefade dibe amoge, hedabola sigi namolömelë. Amase, afädëa nelebo holöfalï dibe amo, mala mogola made sigi aligiseda, nelebo edefade dibe amoge, mala mogola made sigi namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Amai gabugi, asigi falagasei made nea, nagadaiaïe muni amo, hedabola made sigi aligiseda, amai nelebo dofä hedabi dibe amo, dilia sigi namiäia, nowëa dilile naabogi gausimolödu. ");
INSERT INTO etr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amaimo, dilia odoaïe nelegei dibe amo asigi falagasei made nea, hedabola made sigi aligiseda, amai dilile nelegeida, nowëa ïmolödu. ");
INSERT INTO etr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hamoi hamolasilo afädëa, dafidilo äudäïe galabaia hamoi gadoi hamolasimolö ulïmelë. Ea elö amoma bimolö habobahalea, elö amo boba hamomolömelë. Ma, elö amo hedabola ugila negesaleada, oböla, elö amo memalä gabula helësëmolömelë. Dilia Godeïege, muniïege, helegelaïe galabaia hamoi gadoi hamolasimolö ulïmelëla Yesuea säla ï. ");
INSERT INTO etr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Felesi dolö muni boba hamolo amolia, Yesuea ado säi amo sulubadela nabalahilä, e gadiabola säha dilo. ");
INSERT INTO etr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Amalebegi, Yesuea ilima sähalea, Diliada udia dolö odoa neebe amolia, dili asigi mogoi neebela helësëmäiala hamelo neago gaso, dilile iso asigida, Godea dawa nea. Udia dolöea nelebo hedabi edefade gabula helësëlo amoda, Godeïe sidaia nafadefalï nafade dialeamelë. ");
INSERT INTO etr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosese nebegi, Ado säla negei dibe amoge, bea sälo ilia ado säla negei dibe amoge, säla ïaha neloa amila maala, Yone neebea besela galai. Amase, Yone misia amila mi gäwilahilä, Godea Beaha Maadela Sigi Neebe amoïe, Ado Mala Hedabi säla ïaha nea. Udia dolö sulubadelaea gelolahilä, ami digaha neamelë. ");
INSERT INTO etr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Amaimo, muge, naga föige, hogosa helemolöi dialea gaso, Mosese nebegi, Ado säla negei dibe amogi, bea sälo ilia ado säla negei dibe amogige, ado holöfalïïe dudumu afädë, made hogosa helemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yesuea ado aso, sähamu nea sähalea, Dolö afädëa ïe udia nii amo fisila, udia elö neaseda, ea udia amo fa nimolömelë. Amase, dolö afädëa udia nii fisi amo neaseda, amoge ea fa nimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuea ado aso, sähamu nea sähalea, Nelegei yafie negelo dafidilo dolö afädë sulo. Dolö amea fagulo hogale uii didiga salugaloge, fagulo hedabi hïdo elöi muni edefadea nii amoge, salugalo neada, segeyo sulubadelagi obeägïla molö hedabifalï amomu naha nelo. ");
INSERT INTO etr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Amase, busadäoi dolö afädëge sulo. Amoïe ëida Elasalusi. Ïe domalo sulubadela äyomu aligisa maadei sulo. Odoaea e sogobala gaula, nelegei yafie negelo dafidilo dolö amoïe mosö idi galo mia ami, ifosisa aligilo. ");
INSERT INTO etr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Busadäoi ameada, nelegei negelo dolö amea molö nahalea, auli hawa dao digase amo molöila gelola helësësa filo. Ügülo amoli maala, ïe domalogi äyo aligi amoli nobaha aligilo. ");
INSERT INTO etr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hobeala, busadäoi amo baagosebegi, selesaia fii ilia e gaula awäla, Abalahama neebea ami ifosi. Nelegei yafie negelo dafidilo dolö amoge baagosebegi, ilia e dögöla negei. ");
INSERT INTO etr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eda heli segea ami së edefademalä naha nea, sida adogola beahamelebe, Abalahama mia made neebe, amobalä Elasalusige neebe melï. ");
INSERT INTO etr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Amala neebe amo bealahilä, ea uuala säia adogosalea, Naado Abalahama-o, ne nulo gobeia wi nea, së edefade naha neebe weada, dia ne bobasëla, Elasalusiïe naabo sögö ödägi gelahilä, nïe elï hisulasila diigila misialala sämola säi. ");
INSERT INTO etr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Amala säsebegi, Abalahamaea säla obëgësalea, Nïe malö-o, di made baagola nea, dida nelebo sulubadela hedabigimu nelo. Elasalusi eda nelebo sulubadela nafadegimu nelo amo, helësëmo. Gaso, walio sege wegi neada, e bobasëla aealasisa nebegida, dida hä, së edefade naha nebego. ");
INSERT INTO etr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Amase elöda, odoaea nilï neebea wila, dili neebea idogoi digadeläla hamese amoli digamolö ulïmäia, nilï mogogi nofe geloi edefade negei dialeamelë. Amo gadola, dili neebea amilage, nilï neebea wi fedamolö ulï neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Amala säsebegi, dolö amea säla obëgësalea, Hä, amai galëda, naado Abalahama-o. Na dima gelola afädë nabahago. Dia Elasalusi e naadoea mosöa fisiga idogomo. ");
INSERT INTO etr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mida, nïe nedoolali bia nea. Amolige së nülo dibea wi asiala muloea, ea ilima gelola säla ïmalamalola säi. ");
INSERT INTO etr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Amala säsebegi, Abalahamaea säla obëgësalea, Ilida Mosesea ado säi dëdëla negei dibe amoge, bea sälo ilia ado säi dëdëla negei dibe amoge, galea. Ilida ilile ado amo nabuäiala säi. ");
INSERT INTO etr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Amala säsebegi, dolö amea sähalea, Ai, Naado Abalahama-o. Afädë baagoia amila nowela, ili neebea awäseda, ili asigi besumolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abalahamaea sähalea, Ilia Mosesea Ado säi dëdëla negei dibe amoge, bea sälo ilia ado säi dëdëla negei dibe amoge, made nabaseda, afädë baagoia amila nowela awäla säse amo nabalage, dofäla made helësëmolöla säimelëla Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuea ïe bëgëla aulo amolima sähalea, Udia dolöea asiala hamomäia, ili neala digalasimolö nelebo elö elöla, dofä moholö gaso, nelebo amoli misiäia, dolö doga negelo amoda, asigii gabu. ");
INSERT INTO etr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dolö amea malö holöbö gowe gadoi nefolalebe goweligi, afädë neala digalasiseda, ëfëa igi edefademalägi begela, bidi näiadoea ïe muugia begelalahilä, ödä duhulugi sadia idogoseda, ïe hedabida amomelë. ");
INSERT INTO etr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amala hamoloea, dihili dili hedabola idihë namialo. Dïe didoo afädëa nafade hamoseda, nemomalo. Amogi, e bu asigi besuseda, nafade hamoi amo säla made, fisimalo. ");
INSERT INTO etr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Amaimo, segeyo afädë amogimu, dima gifalädalïala nafade hamolahilä, gifalädalïala asigi besula, di neebea maalahilä, na dima nafade hamoimelëla säseda, ea nafade hamoi amo, dia säla made, fisimalo. ");
INSERT INTO etr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Abosolo dolö ilia Dafidilo Geloima sähalea, Nilïa asigi afädë negei neebewe, dia neala edelasimalola säi. ");
INSERT INTO etr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Amala säsebegi, Dafidilo Geloia ilima säla obëgësalea, Dilia asigi afädë negeigo, masada gägä holöfalï amo gadoi negei nea galëda, dilia hä, i neebe gowema sähalea, Dihï soomo aala gaula awäla, ödä duhulu dibea ami sagala namiëla säseda, dia säse amo nabala hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesuea ado aso, sähamu nea sähalea, Dili nebegogi afädëa, ïe hamoi hamolasilo neebe amea sagai sagamolöïe naga dagabosa nelo galëge, sugua sibi sigi nelo galëge, e mosöa obëgëla maaha neëgi wäla, ea sähalea, Di fodolofalï maalahilä, molö molöïe samiëla sämolöle. ");
INSERT INTO etr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Amala made. Ea hamoi hamolasilo amoma sähalea, Nïe molö giala daiamalo. Amalahilä, di fagulo afädë neala bulula, ne molö molö amo deala gaula maala, na molö ödäle nase amo gaalu, dia sigi beaha namialo. Amala hamolahilä, hobealada, dihïdi mualola sälo madele. ");
INSERT INTO etr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Oböla, hamoi hamolasilo amea säi amo gadola hamosa maadeseda, ïe dafidilo amea ema nesege, hedabola hamoi gabula sämolöle. Ai, amala made. ");
INSERT INTO etr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dihili dilige amo gadoi wäla neebela helësëla, dilia hamomalola säi amo gadola hamosa maadelahilä, gomalä sämalo. Nilïda hamoi hamolasilo dofea mademelë. Nilïa hamomolö dibe amomu hamoimelëla sämolö dialeala, Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu e Yalusaleme moholö awähalea, Disiligi Samelia Galilile mogogi ami awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","E gaamu afädë dibea ami awäla besela galaha nebegi, dolö gudubu hamoi nabülasi idiafa holöbö wagadi madela nea, ");
INSERT INTO etr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","gelola uuala sähalea, Dafidilo Yesu-o, dia nilï bobasëmola säi. ");
INSERT INTO etr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Amala säsebegi, Yesuea ili bealahilä sähalea, Dili gobela ïlo amoli neebea awäla, dilile domalo go olemolö mosalola säi. Amo nabala, ili idiafa awäha dibegi, ilile gudubu hamoi amo wahisa maadei. ");
INSERT INTO etr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iligi dolö afädëa beahamelebe, ema gudubu hamoi dilo amo wahi amo bealahilä, gelola uuala Godeïe ëi gauia adogola, bu obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Obëgëlahilä, ea Yesu mia, gumusula dia digalahilä nesegei. Eda Samelia dolö. ");
INSERT INTO etr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuea dolö amo bealahilä sähalea, Dolö nabülasi amoli hulu wahisa maadei madele. Amai, sëgëlasi amolida, abilisio. ");
INSERT INTO etr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dolö odoa obëgëla maalahilä, Godeïe ëi gauia adala made, dolö fii elö goweamu, amala hamosalela nabi. ");
INSERT INTO etr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Amala nabalahilä, dolö amoma sähalea, Di, hä, nowela mosö. Dihï asigi afädë negei amea di hä, wahigomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Segeyo afädëgi, Felesi dolö nefolalo amolia Yesuma nabahalea, Godea Beaha Maadela Sigi Neebe amoda, abola moholö gabula nabi. Amala nabasebegi, Yesuea ilima säla obëgësalea, Godea Beaha Maadela Sigi Neebe amo, nofe elöi siia melemolöibaläda, made moholömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Afädëa sähalea, Bimo, gui neebe, ma, gagowei neebela sämolöi mademelë. Nabuö. Mida, Godea Beaha Maadela Sigi Neebe amoda, hä, dili neebea gui misi dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Amala sälahilä, ïe bëgëla aulo amolima sähalea, Segeyo afädë besela galamolö amogi, dilia Dolöïe Malö amoïe segeyo afädë gelola bimolöila helësëmolö gaso, made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Odoaea dilima sähalea, Bimo, gagowei neebela säsege, ma, bimo, gui neebela säsege, dilia ili bëgëla, bea mosabio. ");
INSERT INTO etr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mida, sege yabagelesegi, mu giwi sulubadelagi yo digaha maadelo amo gadolada, Dolöïe Malö amo, ïe segeyogi amo gadoi wäla maala namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amamolö gaso, e dafidi edefademalä së elö elöla nasegi, udia dolö walio segeyo nefolalebe welia, e baagi ïmolö dialeamelë. ");
INSERT INTO etr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noaïe segeyogi hamoi amo gadola, Dolöïe Malö amoïe segeyogige, amo gadola wäla hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Udia dolö nefolalo amolia, molö ödä nadigi, udia neadigi, dolö fila awäla digisa nebegi, Noa eda ödä sibi isogi fila fedamolö segeyo amo besela galaimelë. Amala hamosa nebegi, ödä bëi edefade maalahilä, udia dolö sulubadela ödäea naha maadei. ");
INSERT INTO etr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Amase, Olodeïe segeyogige, amo gadola wäla hamosa nelo. Udia dolö nefolalo amolia, molö ödä nadigi, nelebo neadigi, odoaea nimäia nelebo negela digi, sagai sagala digi, mosö oladigisa nelo. ");
INSERT INTO etr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Olode e Sodomo gaamu amo dïgïla awäsolo segeyo amo gala, mudaiala nulo söabalä, igi gadoi abüai, ëida saloba, neëi amola sadia idogoi amea, ili sulubadela nafadesa maadei. ");
INSERT INTO etr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dolöïe Malö ulufadigimolö segeyo amogige, amo gadola wäla hamosa namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Segeyo amo gala, dolö mosö daiowa sebe amea, ïe nelegei mumusogi dibe amo nea digamabio. Amo gadola wäla, dolö sagaia neebe ameage, nelebo afädë hï mosöa nea obëgëmabio. ");
INSERT INTO etr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dilia Olodeïe udia amo helësëla obëgëmalo. ");
INSERT INTO etr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Afädëa hïle namolö amo gaula fëdöla aligimolö helësëseda, ïe namolö amo hogosa helemolömelë. Gaso, afädëa hïle namolö amo fisiseda, ea ïe namolö amo gaula namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na dilima säla ïahago. Amo gala, gasigi dolö äudä sogobala adi diëgi, elö amo neahalea, elö amo dïgïla moholömelë. ");
INSERT INTO etr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Udia äudä heledo wahalo däilaha neëgi, elö amo neahalea, elö amo dïgïla moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Amala säi amo nabalahilä, ilia ema nabahalea, Dafidilo Geloi-e, abidi hamomolödula nabi. Amalebe, Yesuea säla obëgësalea, Baagoi domalo dibea ami, haea säsalï gadoi mafula gegedomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuea ïe bëgëla aulo amolia, habola made, segeyo sulubadelagi Godema adosa namiäiaïe olelesalea, ado besu afädë säla ï. ");
INSERT INTO etr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ea sähalea, Gaamu afädëgi mogelo dolö afädë sulo ameada, Godebalä bedälo madege, udia dolö helësëlo madege sulo. ");
INSERT INTO etr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aso, gaamu amogimu udia didalo afädëge sulo. Ameada, segeyo sulubadelagi, gudi mogelo neebea ami awähamu nea, ema sähalea, Nïe ado nii neebe amea, ne neala yölasisa neebe amoïe, dia ne ugila negela gudi hamogila mogolasimola säla afufusamu aligilo sulo. ");
INSERT INTO etr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Amala afufusamu nebegi, mogelo dolö amea segeyo yafiegi, üla made, auausa sulo. Gasoda, oböla, hobeala hïdomu sähalea, Nada Godebaläge bedälo made, udia dolöge helësëlo made amo, ");
INSERT INTO etr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","udia didalo gowea segeyo sulubadelagi, nebalä nalï egesamu neebe goweada, ïe yöi dibe amo na fädäla beala, hä, mogola hamogilasidelä. Ea segeyo sulubadelagi ne neebea maahamu nea, ne neala yölasilasiloea sähala säi. ");
INSERT INTO etr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dafidilo Geloia ado aso, sähamu nea sähalea, Mogelo dolö mogoi made amea, ado säi amo nabualo. ");
INSERT INTO etr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Amaimo, Godea ïe udia dolö hï memelei nefolalebe amolia, eso sulubadelagige, gasi sulubadelagige, ema uuala sähamu aligise amolima, mogola mogelasimäia, ea made ugila negemolöle. Ma, asomelëla sämolöle. ");
INSERT INTO etr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na dilima säla ïahago. Ea ili aabela mogola mogelasimäia, ugila negemolömelë. Amamolö gaso, Dolöïe Malö maalahilä, nagadaia wi udia dolö asigi afädë negei nefolalebe bimolölela nabi. ");
INSERT INTO etr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Udia dolö odoaea helësësalea, nilïda asigi mogoi nea, odoa nefolalebe amoli sulubadelada, holöbö gidogola helësëlo amolima, Yesuea ado besula gowe säla ï. ");
INSERT INTO etr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Dolö äudä Godeïe mosöa Godema adomolö asi. Elö amoda, Felesi dolö, amase, elö amoda, dagisi muni nelo dolö. ");
INSERT INTO etr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Felesi dolö amea nowela nea, asigiamu Godema adosalea, Gode, neda odoa ili gadoi made, fa neloge, mala nafade hamologe, udia susugu neloge, amase, dagisi muni nelo dolö wagadi neebe gowe gadoige made ameada, dima nesegesa. ");
INSERT INTO etr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na salele afädëïe segeyo äudägi, molö made naala aligilo. Amase, nelebo bidi nease amo sulubadelagida, nabülasi mogelahilä, nabü afädë neala digali ïlomelëla säla Godema adoi. ");
INSERT INTO etr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gaso, ea amala säha neebe amo gaalu, dagisi muni nelo dolö amea, wagadi made nea, Hebeni sida adogomolö made helësëla, hïle bidagia nufigisa nea, Godema adosalea sähalea, Gode, neda nafade hamolo neawe. Dia ne bobasëmalola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesuea sähalea, Na dilima säla ïahago. Mosöa obëgëla awäla, Godeïe siigi mogola nelo amoda, Felesi dolö amo made, dagisi muni nelo dolö amomelë. Udia dolö hili ili ilibialo amoli sulubadela, Godea neala nagadaialasisalea, gaso, afädë hï e nagadaialo neebe amoda, Godea neala ilibialasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Udia dolö odoa nefolalo amolia ilile malö dubo amolige, Yesu ïe naaboea diigimäia, e neebea ami sogobala gaula maasebegi, bëgëla aulo amolia amo beala, ilima halala nemola dofogai. ");
INSERT INTO etr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amala nemosebegi gaso, Yesuea malësä amoli e neebea ami mofiamalolahilä sähalea, Dofogamabu. Malësä ne neebea misiäia beasimo. Mida, Godea Beaha Maadela Sigi Neebea ami, malësä gowe ili gadoi neebe amolile dialeamelë. ");
INSERT INTO etr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na dilima dofä sähago. Godea Beaha Maadela Sigi Neebe amo, malësäea neala gaulo amo gadola, made neala gaulo amoda, dofä made nogila digamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Beaha aligilo afädëa Yesuma nabahalea, Säla Olelelo hedabi-e, ne namolöi namolö neala gaumolöïe, abilia hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Amala nabasebegi, Yesuea ema säla obëgësalea, Dia nema hedabila säi amoda, mi edoïe. Afädë hedabida maade. Gode emu hedabi nea. ");
INSERT INTO etr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mala säla negei dibe amoda, dia dawadigi nebego. Udia dolö susugu hamomabio. Baagomäia nufuabio. Nelebo fa nimabio. Wäfalï säsäla gudimabio. Amase, diado diemele hawala nea, elele ado nabala hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Amala säsebegi, dolö amea säla obëgësalea, Ado amoli sulubadelada, ne malësägila hamosa maadeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Amala säla obëgëi amo nabalahilä, Yesuea ema sähalea, Afädëfalï dima maademelë. Dïe nelegei difolalebe amo, bidi neaha maademolö mosö. Neaha maadelahilä, dia muni nease amoda, dolö busadäoi nefolalebe amoligali ïmalo. Amala hamoseda, selesaia mosöa bidi edefade nimolömelë. Amo gadola hamolahilä, ne bëgëla misialola säi. ");
INSERT INTO etr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ado säi amo nabalahilä, ïe odagi augia idogola, edefademalä yöi. Mida, ïe nelegei yafie dilo amogi amai. ");
INSERT INTO etr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuea dolö amoma siila nea sähalea, Nelegei yafie negelo dafidilo dolö neebe amolida, Godea Beaha Maadela Sigi Neebea ami nogila digamolöda, häuai galeamelë. ");
INSERT INTO etr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dofä. Sugua gameleda, nusi galabagi doadigila moholöda, häuai holöfalï mademelë. Gaso, nelegei yafie negelo dafidilo dolö nefolalebe amoli, Godea Beaha Maadela Sigi Neebea ami nogila digamolöda, häuai baagila asi dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Udia dolö nefolalo amolia, ea ado säi amo nabalahilä sähalea, Amai, damula auloda, nowëa gaula namolödula säi. ");
INSERT INTO etr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Amala säsebegi, Yesuea säla obëgësalea, Udia dolöea hamomolöi made amoda, Godea hamomolöi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Amala säsebegi, Fidaea sähalea, Hä, bimo. Nilïa nilïle nelegei sulubadela fisila, di bëgëla misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Amala säsebegi, Yesuea ilima sähalea, Na dilima dofä säla ïahago. Sulubadelaea mosöge, udiage, edooge, eedo emelege, malöge fisila, Godea Beaha Maadela Sigi Neebe amomu si gäwisi awäseda, ");
INSERT INTO etr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nagadaia neebe wegi nea, fisi amoli baagila awäla, edefademalä gaula namolölahilä, oböla, segeyo hobea besela galamolö amogi, namolöi namolö dibe amo gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuea ïe bëgëla aulo giwilasi amoli sigi aliga galahilä, ilima sähalea, Nabuö. Nilï hä, Yalusaleme moholö awähamelë. Awäseda, nelebo sulubadela dafidi bea sälo nefolalo amolia, Dolöïe Malö amoïe säla dëdëla negei dibe amo gausiala digaha maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Afädëa Dolöïe Malö amo Yu dolö ilima made, dolö odoa nefolalebe amolima gaula ïaseda, ilia e gadiabola digi, e gagadela digi, ema gofedela galala digimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ilia e fëgälahilä, baagomäia nufulömelë. Amala hamoseda, segeyo äudä nelolahilä, osodagi, hï nowemolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bëgëla aulo amolia, ea säi amo sulubadela made helësëi nelo. Ilia ado säi amoïe, galone made helësëmäia, musügä negela säi amea, ilia ea säi amoda, goweïe säsebela, dofä dawa made nelo. ");
INSERT INTO etr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu e Yaligo gaamugi besela galamolö ga madesa nebegi, dolö si golai afädë idi agesua ami salea, udia dolöma muni ïmola ëdëgësa sulo. ");
INSERT INTO etr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Udia dolö yafie adodola afiasebe amo nabalahilä, ea nabahalea, Goda edo hamosebela nabi. ");
INSERT INTO etr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ilia ema säla obëgësalea, Goda Nasalese fii Yesu awäsebela säi. ");
INSERT INTO etr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Amala säsebegi, ea uuala sähalea, Debidiïe malö Yesu-o, ne bobasëmola säi. ");
INSERT INTO etr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yesu hobeala maaha nebegi, amala uuasebegi, udia dolö dafidila afiaha dilo amolia ema nemosalea, Dia adomabu. Gameläla säi. Amala säsebegi gaso, ea gelolafalï uuahalea, Debidiïe malö-o, ne bobasëmola sähamu sulo. ");
INSERT INTO etr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hä, Yesu e maala beaha nea, dolö si golai amo e neebea ami sigi misialasebegi, ilia e sigi gaula maala, Yesu neebea ami ga madela ifosi. Amalebe, Yesuea ema nabahalea, ");
INSERT INTO etr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Na dima abilia hamomäia hamesebela nabi. Ea säla obëgësalea, Dafidilo Geloi-e, na siia fädäla bimolö hamesebela säi. ");
INSERT INTO etr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesuea ema sähalea, Hä, bimo. Dihï Godema asigi afädë negei amea, di hä, wahi gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Amala säi amole, ïe si golai amo hä, fodolofalï wahisebegi, ea Godeïe ëi gauia adogolahilä, Yesu bëgëla asi. Udia dolö nefolalo amoli sulubadelaea, amala hamose amo bealahilä, iliage Godeïe ëi gauia adaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu e, hä, Yaligo gaamugi besela galala baagila awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Gaamugi amida, dolö afädë sulo. Amoïe ëida Sagiasi. Eda dagisi muni neaha aligilo nefolalebe amolile busa nea, muni yafie negei nelo. ");
INSERT INTO etr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ea Yesuda, abodo gadoi walebelela bimolöla helësëi gaso, udia dolö yafie negegi amea, ea Yesu bimolöi made melï. Mida, e oboba amea. ");
INSERT INTO etr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Udia dolö awäsebe amo gadola, e edale baluluia awälahilä, Yesu eda, idi gowegi maase bimolö gabula helësëlahilä, äfäeo i amogi fedala sulo. ");
INSERT INTO etr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu e maala, Sagiasi e fedai sebea ami besela galala, sida adogola nea, Sagiasima sähalea, Sagiasi-e, neda walio dia mosöa namolö moholömelë. Di hä, fodolofalï digamola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Amala säsebegi, Sagiasi e fodolofalï digala, ïe iso asigia obeägïlahilä, ea mosöa fimäia Yesu säla olela fu ï. ");
INSERT INTO etr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amala säsebegi, udia dolö nefolalo amolia, amala hamosebe amo bealahilä, habobala sëdäwala sähalea, Dolö nafade hamolo amea mosöa söfë awäsebegola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ea mosöa awälahilä, Sagiasia nowela nea, Dafidilo Geloima sähalea, Dafidilo-o, dia nabuö. Na nelebo difolalebe amo mogogi mogelahilä, elö amo busadäoi nefolalebe amoligali ïmolömelë. Amalahilä, afädëïe nimolö dibe amo gadola made, baagia asogola ïmola säla neaha nelo amoïeda, na oböla, dahila neala nii amoïe biyidiala ïa obëgëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Amala säsebegi, Yesuea ema sähalea, Dolö gowe eege, hä, Abalahamaïe malö neebe ameada, mosö gowegi sefolalebe amolia, walio hä, damula aulo neala gausagomelë. ");
INSERT INTO etr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dolöïe Malö ameada, udia dolö dabadigi neebe amoli, hogolahilä sigi obëgëmolö misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Udia dolö nefolalo amolia, ado säse amo nabaha sefolalebegi, Yesuea aso, sähamu nea, ilima ado besula säha nelo. Mida, e hä, Yalusaleme ga madela neëgida, ilia helësësalea, Godea Beaha Maadela Sigi Neebe amo, waliomu ulufadigimolö gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Amala helësësebegi, Yesuea sähalea, Dolö dafidilo ëi sälo afädë nelo amea, ilia e gini neala ifosimäia, sege wagadi made awälahilä, hobeala hï segea udia dolö sigi namolö obëgëmolöïe, naabo negesiä asi. ");
INSERT INTO etr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","E aso, awäla made nea, dafidi ïe hamoi hamolasilo nabülasi welahilä, ilima muni giwi siliba hädali afädë hïdo hïdolama sogosalea sähalea, Gowe ïase goweada, ne asibua hamoi hamolahilä, baala nea negesa namialola säsiä asi. ");
INSERT INTO etr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amala asibua, hïle segeafalï udia dolö sefolalo amolia, ema bimolö habobalahilä sähalea, Dolö goweda, nilïle gini namiäia hamesa mademelëla sälahilä, odoaea e moholö awäsebea ami säla ïmolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Amai gaso, ga nefolalo amolia dolö amo gini neala ifosisebegi, e obëgëi. E hä, obëgëlahilä, ïe hamoi hamolasilo amolima muni ïasila asi amolia hamoi hamolahilä, baala abilia hamoi walebelela bimolöïe, e neebea ami misialamalola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Amala misialasebegi, dolö dafididale misi amea ema sähalea, Dafidilo-o, dia muni giwi siliba hädali afädë ï amea, na hamoi hamolahilä, muni giwi siliba dausini afädë baala nea negeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Amala säsebegi, ea dolö amoma sähalea, Hamoi hamolasilo hedabi-e, hedabola hamoi gabu. Dia holöfalï amo asigi falagasei nea, sigi nelo gabugi, gaamu nabülasi dibe amo dia sigi namialola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Amalahilä, dolö agedu amo maalahilä sähalea, Dafidilo-o, dia muni giwi siliba hädali afädë ï amea, na hamoi hamolahilä, muni giwi siliba hädali bia baala nea negeimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Amala säsebegi, ïe dafidilo amea dolö amoma sähalea, Gaamu bia dibe amo dia sigi namialola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Amase, dolö elö amo maalahilä sähalea, Dafidilo-o, dïe muni giwi siliba hädali afädë amoda gowe. Na faguloea usulala negei dilo. ");
INSERT INTO etr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mida, di geloi bologodei amo helësëla, ne bedäi. Dolö elöea nelebo negei dibe amoda, dia nealahilä, dia made sagaia amida, dia faila nülo gabiola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Amala säsebegi, ea dolö osoda amoma sähalea, Hamoi hamolasilo nafade di, dihï ado säsebe goea, na dibalä gudidelä. Dia helësësaleada, neda geloi bologodeige, nelebo odoaïe dibe amoge, na nelo, amase, molö na sagai made amoge, na faila nülolage helësëile. ");
INSERT INTO etr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Dia nïe muni amo bëgigi negesiä ami, made negei goda, abisalea amai. Amala negei galebeda, ne obëgësegi, baai muni amola nealabio godala säi. ");
INSERT INTO etr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amala sälahilä, ea ami nefolalo amolima sähalea, Ea muni giwi siliba hädali afädë gaula neebe go fedela, muni giwi siliba dausini afädë gaula neebe amogali neala ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Amala säsebegi, ilia ema säla obëgësalea, Dafidilo, eda muni giwi siliba dausini afädë gaula neebela säi. ");
INSERT INTO etr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Amala säsebegi, ea säla obëgësalea, Na dilima säla ïahago. Sulubadelaea nelebo gaula neebe amolimada, odoa baala ïmolömelë. Gaso, afädëa made gaula neebe amomada, holöfalï gaula neebe amo haila nimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amaimo, nebalä ado nealahilä, ne ilile gini made namiëla sälo nefolalebe amolida, dilia sigi maalahilä, nïe odagia baagomäia nufudaha maademalola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuea amala sälahilä, e Yalusaleme aulo idigi, dafidi awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesu e maala Bedefagige, Bedanige, ga madela nea, segebi ëi Olibebia amila, ea bëgëla aulo äudä dafidi mosalolahilä, elema sähalea, ");
INSERT INTO etr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ali segea ago mosö nefolalebea ami awäla besela galala beahamelële, sugua dögi üdïli afädë dafidi dolö afädë filo made, gide begei neë bimolömelë. Amo fisigäla, wi sigi obëgëmalo. ");
INSERT INTO etr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Afädëa alima goda abïdä fisigähala nabaseda, alia gomalä sämalo. Dafidiloea webalä hamomolö galeamelëla sämalola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Amala säsebegi, dolö äudä dafidi mosaloi amole awäla beahamelebe, ea säi amo gadolafalï dibe melï. ");
INSERT INTO etr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hä, elea sugua dögi üdïli gide begei amo fisigäha nebegi, amoïe eedo amolia elema, Goda abilia hamodelä fisigähala nabi. ");
INSERT INTO etr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Elea säla obëgësalea, Dafidiloea webalä hamomolö galeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amala sälahilä, elea sugua dögi üdïli amo sigi, Yesu neebea obëgëi. Amalahilä, elele fagulo daia salugalo giila, sugua dögidaia sadia idogolahilä, Yesu amodaia fila fedamäia, ugila negei. ");
INSERT INTO etr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Amalebe, e amodaia fila awäha nebegi, udia dolöea ilile fagulo daia salugalo amo giilahilä, idiafa föföla awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","E awäla Olibebia amila aliga idogomolö idi ga madesebegi, udia dolö yafie e bëgëla aulo amoli sulubadelaea, geloi melëlo made gadoi sulubadela hamose melï amoïe, edefademalä obeägïlahilä, gelola uuala Godeïe ëi gauia adala sähalea, ");
INSERT INTO etr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Beaha aligilo gini Dafidilo Geloiïe ëigila maahago, Godea e neala obeägïlasimäia. Selesaia mosöa ami, neala dalulasilo diamiäia. Gode ilibia neebe amoïe ëi gauia adogosawela säsäla afiaha dilo. ");
INSERT INTO etr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amala säsäla afiaha dibegi, Felesi dolö odoaea udia dolö gegedoi nefolalebea amila Yesuma sähalea, Säla Olelelo-o, dïe bëgëla aulo golima nemomola säi. ");
INSERT INTO etr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Amala säsebegi, Yesuea säla obëgësalea, Na dilima säla ïahago. Ilia adola made, aumala neëda, igi difolalebe gowe ilia gelola uuala sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu e besela galamolö ga madela nea, Yalusaleme gaamu amo bealahilä, amogi dïisa nea sähalea, ");
INSERT INTO etr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Segeyo walio wegi, di neala dalulasilo amo dihï helësëlabio gaso, walio hä, dia siia bimolöi made, musügä dialeamelë. ");
INSERT INTO etr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hobeala segeyo afädëgi, di mia besela galasegi, dïe ado nii neebe amoli maalahilä, dïe yala edefade go baagido, naga gasala dadagulula nelegela amalelahilä, dïe idi sulubadela gaha maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ilia dihïdige, dïe malö dïe mumusogi sebe amolige, neala nagadaia sadia idogola dusula nafademolömelë. Gode e di neebea misi amoïe segeyo, dia dawa made nelo amea, ilia dïe igi odoa daia dadagulula negei dibe goda, sulubadela mugulula digaha maadela, igi afädë igi elödaia made diamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amala sälahilä, Yesu e Godeïe mosö yala isogi nogila digalahilä beahamelebe, dolöea bidi nimolöïe, nelebo negela digisa difolalebe amoli nesila digilahilä, ");
INSERT INTO etr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ilima sähalea, Ado säla dëdëla negei dibe amea sähaleada, Nïe mosö amoda Godema adolo mosö diamolömelë. Amai gaso, dilia oböla, fa nelo musügä aligilo igi äbä gadoi hamoi gabula säi. ");
INSERT INTO etr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Segeyo sulubadelagi, Yesu e Godeïe mosöa ami nea, ado mala olelesa aligilo nelo. Amala olelesa neëgida, gobela ïlo busa nefolalo amoliage, mala dawadigi amoliage, amase, udia dolö beaha aligilo busa nefolalo amoliage, Yesu nufulöïe idi hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amai gasoda, udia dolö nefolalo amoli sulubadelaea, Yesuea mala olelese amo, afädë damula fisila made, hedabola naba mafusa neebe amea, ilia Yesu nufulö fu made beagolei nelo. ");
INSERT INTO etr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Segeyo afädëgi, Yesu e Godeïe mosöa nea, udia dolöma säla olelela digi, Ado Mala Hedabi säla ïadigisa nebegi, gobela ïlo busa nefolalo amolige, mala dawadigi nefolalo amolige, asigi gäwi dafidilo nefolalo amolali, e neebea ami misi. ");
INSERT INTO etr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ilia Yesuma nabahalea, Dia nelebo hamosebego, nowëa hamomalai hamosa. Nilïa nabedelä, dia säla ïmo. Go hamomäia, geloi go nowëa ïasiola nabi. ");
INSERT INTO etr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Amala nabasebegi, Yesuea ilima säla obëgësalea, Dilia nema säla obëgëmäia, nage dilima ado afädë nabahago. ");
INSERT INTO etr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yonea ödägi gesa nelo amoda, abidila misi. Selesaia mosöala misile, ma, dolömadila misilela nabi. ");
INSERT INTO etr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Amala nabasebegi, hilidomu didiähalea, Nilïa selesaia mosöala misila säseda, ea nilïma, Ema asigi afädë made negei goda, edoïela nabulö gabu. ");
INSERT INTO etr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amase, nilïa dolömadila misila säsege, udia dolö nefolalebe gowe ilia, Yone eda bea sälo afädë neala helësëlo ameada, nilï igia nufulö gabula didiäi. ");
INSERT INTO etr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Amala didiälahilä, ilia säla obëgësalea, Yonea geloi nii amoda, abidi niidu. Nilïa dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Amala säsebegi, Yesuea ilima säla obëgësalea, Amai galëda, na nelebo hamosebeweda, gowea hamomalai hamosa neamelëla, nage dilima made säla ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Amala sälahilä, Yesuea udia dolöma ado besu gowe säla ï. Dolö afädëa i gägä negelo gelebi ëfë sagaia sagala negesiä, dolö odoaea oodola beaha namialola sälahilä, hï eda sege wagadi made, holöbö sedade namolö asi. ");
INSERT INTO etr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gägä amo faimolö fu besela galasebegi, sagai eedo amea, ïe hamoi hamolasilo afädëma sähalea, Nïe sagai oodola beaha nefolalebe amolima, gägä odoa faila ïmola sämolö mosalola säi. Amala säi amo nabala, ea sämolö awäsebegi, oodola beaha nefolalo amolia, hamoi hamolasilo amo nufudala ïalalelahilä, nelebo afädë made gaui, fisiga gai. ");
INSERT INTO etr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Amala hamoi gabugi, sagai eedo amea, ïe hamoi hamolasilo elö amo bu mosaloi. Gaso, amoge oodola beaha aligilo amolia, hïdo elöla gadiabola nufudala ïalalelahilä, nelebo afädë made gaui, e badumu fisiga gai. ");
INSERT INTO etr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Amalamu hamosebegi, sagai eedo amea ïe hamoi hamolasilo osodama oböla, bu mosaloi. Awäsebegi, sagai oodola beaha aligilo amolia, e nufudala afisilahilä, yala baagido sogobala sadia gai. ");
INSERT INTO etr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Amalamu hamosebegi, sagai eedo amea sähalea, Amai na abilia hamomolödu. Hä, nïe malö, nihï boba hamoi neebe wema mosöla sämolö. Ilia e hawala nea, mogola hamomolöla helësësala säi. ");
INSERT INTO etr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amai gaso, malö amo awäsebegi, oodola beaha aligilo amolia e bealahilä, hilido didiähalea, Sagai eedo amoïe nalä negei nimolö amoda, hä, go gabugo. Ïe nelegei dibe goda, nilïgali nedelä, eda baagomäia nufidedila sälahilä, ");
INSERT INTO etr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","sagai yala baagido sogobala sadia galahilä, baagomäia nufimelëla säi. Amala sälahilä, Yesuea ilima sähalea, Amala hamoi amo, sagai eedo amea dolö amolima abilia hamomolödu. ");
INSERT INTO etr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E maala, oodola beaha aligilo amoli nufudaha maadelahilä, sagai amoda, odoaea oodola beaha namiäia ïmolömelëla säi. Amala säsebegi, udia dolö sefolalo amolia, ado amo nabalahilä, Amala hamomolöi mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Amala säsebegi, Yesuea sebe amoli sidawewela bealahilä sähalea, Amai galëda, Godeïe bebagi ado gowe säla dëdëla negei dibe goweda, mi edoïe säla negei dialea. Amea sähaleada, Mosö olelo amolia, igi galone hamomolöi made gabula memelela fisi amoda, galone geloi dafidilo besela galai neamelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Udia dolö sulubadela igi amodaia digase amolida, dusudasimolömelë. Amase, igi amea dolö afädëdaia daala negeseda, eegela fisimolöi fisimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mala dawadigi nefolalo amoliage, gobela ïlo busa nefolalo amoliage, Yesuea ado besula säi amoda, nilï helësëla säsebela helësëlahilä, segeyo amo galamu e gaudelä hamoi gaso, udia dolö nefolalebe amolibalä bedäi. ");
INSERT INTO etr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ilia Yesu gaumolöïe hedabola idihë nea, dolö odoaea hado desega mosäia fisiga galahilä, ilima sähalea, Dilia ea säse amo wäfalï asigi falagasei nea, nabulöi gadoi hamola, fädäla nabulö mosalola säi. Ea ado asiala säse amo nabalahilä, ado amohï, e gaumolöïe mi hogosa nelo. Amalahilä, Olomoïe gabena neebe amoïe naabogi gausimolöla helësësa nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mosaloi amoli awälahilä, Yesuma nabahalea, Säla Olelelo-o, nilïada, dia ado säsebegoge, mala säla olelesebegoge, udia dolöma mogolafalï sähala helësësamelë. Amase, udia dolö sulubadela memelela made, afädëdilamu, Godeïe idigi aulo mala amo, ilima säla olelese amoda, mogolafalïmu säla olelelomelëla helësësamelë. ");
INSERT INTO etr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hä, beaha aligilo Gini Sisa neebe amogali, nilïa dagisi muni ïmolöda, dofeale, ma, dofea madelela nabi. ");
INSERT INTO etr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amala nabasebegi, Yesuea, e fedogola nabasebe amo helësëlahilä, ilima sähalea, ");
INSERT INTO etr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Muni giwi afädë nema olemola säi. Ilia ema olesebegi, ea ilima nabahalea, Muni giwi gogi, dolö busa dibe goge, ëi dibe goge, nowëïe gabula nabi. Amala nabasebegi, ilia säla obëgësalea, Sisaïela säi. ");
INSERT INTO etr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Amala säsebegi, ea ilima säla obëgësalea, Amai galëda, nelebo Sisaïeda, Sisa hïma ïmalo. Godeïeda, Gode hïma ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Amala säsebegi, dolö amolia udia dolö nefolalo amolile sidaia ami, Yesuea ado säi amea, e gaumolö ulï nelo. Ea säla obëgëi amogi, ili fudugilahilä, adola made, aumala nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadiusi dolö iliada, udia dolö baagoi amolida, made nowela galamolöla sälo amoligi, odoaea Yesuma nabulöïe, e neebea misi. ");
INSERT INTO etr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ilia nabahalea, Säla Olelelo-o, Mosesea, nilïa hamomäia, ado afädë dëdëla negei dibe amea sähaleada, Dolö afädëïe edooea udia neala salea, malö made sogobala baagoseda, udia didalo amo edoo elö amea nealahilä, baagoi amoïe ëigila malö sogobamolö dialeala säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amaimo, edoolali gifalädalïa sulo. Abulümi amea udia afädë neala nea, malö made sogobala baagoi. ");
INSERT INTO etr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Baagosebegi, edoo agedu ameage, ");
INSERT INTO etr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","amase, edoo osoda ameage, udia amo neasebegi, amalamu hahamola awäha neamu, dolö gifalädalïa amolia, malö made sogobala neamu, baagosa maadei. ");
INSERT INTO etr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Amala baagosa maadeibua, hobeafalï, udia amoge baagoi. ");
INSERT INTO etr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Amala hamoi amo, dolö gifalädalïa amolia udia afädë amomu neala sulo amo, hobea baagoi amoli nowela galasolo amo gala, udia amoda abodoweïe udia samolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Amala nabasebegi, Yesuea säla obëgësalea, Udia neadigi, dolö fila awäla digise amoda, walio nagadaia wi nea amahamelë. ");
INSERT INTO etr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amaha gaso, Godea udia dolö baagoiala nowela galala, hobeala namolö dibea ami namolö dofeala helësëi amoliada, udia made neadigi, dolö made fila awäla digimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ilida, selesaia fii amoli gadoi namolö ameada, bu elö baagomolö ulï namolömelë. Baagoia amila nowela ifosi amea, ilida Godeïe malölali namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Amaimo, Moseseage, i holöfalïgi nulo söa fedai amoïe dëdëla negei ameada, udia dolö baagoi amoli nowemolö amo ulufala olei. Mida, beba amogila, ea Dafidilo Geloima sähalea, Abalahamaïe Gode, Aisagaïe Gode, amase, Yeigabaïe Godemelëla säi amea olei. ");
INSERT INTO etr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gode eda baagoi amolile made, eda udia dolö nefolalebe amolile Gode neamelë. Mida, udia dolö amoli sulubadelada, ïe siigi nefolaleamelëla säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Amala säla obëgësebegi, mala dawadigi odoa nefolalo amolia säla obëgësalea, Säla Olelelo-o, hedabola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ili bedähalea, afädëa ema ado bu elö made nabi. ");
INSERT INTO etr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesuea udia dolö amolima nabahalea, Afädë Memelei amo eda, Debidiïe malöla sälo amoda, abeahäla sälodu. ");
INSERT INTO etr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Debidi hï Gë Udälo bebagi säla negei dibe amogi sähalea, Dafidilo Geloia nïe Dafidilo Geloima sähalea, Na dïe ado nii nefolalebe amoli, di hawala ifosimäia, dida nïe naabo dafädimadi awäla salea, beaha samialola säimelë. ");
INSERT INTO etr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Debidia hïma, Dafidilo Geloila säi amoda, e oböla, Debidiïe malöda abeahäladula nabi. ");
INSERT INTO etr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Udia dolö nefolalo amoli sulubadelaea, ea ado säsebe amo nabaha sefolalebegi, Yesuea ïe bëgëla aulo amolima sähalea, ");
INSERT INTO etr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mala dawadigi nefolalebe amoli idihë namialo. Ilia fagulo sedade salugalahilä nawesalea, magaia gaamugi awälahilä, udia dolöea ili beala, di go gabiola sämäia hameloge, gedolo mosöa dafidilo filo dibea amimu fimolö hameloge, amase, udia dolö yafie gegedola molö nasebea ami, dolö busa amolile filodaia amimu samolö hameloge, neamelë. ");
INSERT INTO etr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Amase, iliada udia didalo sebe amoli dahila neala, ilile mosöa nelegei dibe amo fa neala gaula aulo nea. Ilile asigi musügä negesilahilä, adoeamu Godema sedadela adolo neamelë. Dolö amala hamose amolida, së edefade muäia, baala ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Amala sälahilä, Yesuea bea gahamelebe, nelegei yafie negelo dafidilo dolö nefolalo amolia, Godeïe mosöa muni negelo i amogi, muni ïmolö gaui amo negese melï. ");
INSERT INTO etr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Amala beaha nebegi, udia didalo busadäoi afädëa muni giwi holöfalï äudä muni salelo bogosi i amogi salase melï. ");
INSERT INTO etr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Amo bealahilä Yesuea sähalea, Na dilima dofä sähago. Udia didalo busadäoi gowea negei ameada, odoa ili sulubadelaea negei amo baagila asimelë. ");
INSERT INTO etr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Udia dolö egowe ili sulubadelaea muni yafie dilo amogi ï. Gaso, udia goweada, muni made gaui, hï molö nimolö muni gaui amo, hulu negesa maadesiola säi. ");
INSERT INTO etr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Odoaea Godeïe mosö neebe amo beala sähalea, Igi boboga hedabi hïdo elöi ameage, udia dolö ilia Godegali galu ï ameage, mosö go hedabola momadoi gabula säsebegi, Yesuea sähalea, ");
INSERT INTO etr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Dilia walio nelebo bease goïe segeyo afädë maasolo amo gala, igi afädë igi elödaia made negela, sulubadela mugulula digaha maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Amala säsebegi, ïe bëgëla aulo amolia nabahalea, Säla Olelelo-o, nelebo hamomolö säi amolida, abola hamomolö amoïe säi. Nilïa dafidi nofe abodo gadoidale hamose amo beala, nelebo besela galamolö amoli hä, ga madesa gabula helësëmolödula nabi. ");
INSERT INTO etr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Amala nabasebegi, Yesuea säla obëgësalea, Odoaea dili dahila neloea, hedabola idihë namialo. Mida, dolö yafie maalahilä, nïe ëi säla sähalea, Neda emelëla säla, amase, Segeyo amo ga madefalï dialeala sämolö moholömelë. Amala säseda, dilia ili bëgëla mosabio. ");
INSERT INTO etr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dilia hobeala nabahalea, gädili neebe amoli edefade nudusalea wabula säsege, udia dolöea ba beala, ilile gamanebalä nudusalea wabula säsege amo nabala, dilia bedäla hehealemabio. Nelebo amoli dafidi amala hamomolö dialea gasoda, segeyo fodolo aligila wagamolö mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Amala sälahilä, ea ilima sähalea, Fii elöle elöle nudula digi, gini elöle elöle nudula digisa namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Fogoli edefademaläge, sïdë iige, amase, olo iige, sege elö elölagi moholömelë. Mudaia hamomolöi made gadoige, edefademalä bedämolö elöla elölage moholömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nelebo amoli sulubadela, aso, made besela galala neëgida, ilia dili gaulahilä, sëlasisa namolömelë. Gedolo mosöa ami dilibalä gudilahilä, galabaia mosöa galabaia negemolömelë. Amase, dilia nïe ëi gaula neebe goïeda, ilia dili beaha aligilo ginile gabenale neebea ami sigi gaula awäla, ifosimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Amala hamoseda, ilima ado mala ulufala säla ïmäiaïe, idi gai doga negesalea amamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amaseda, dilia dafidi ilima ado abodo säla obëgëmolödula asigia säosäola made helësëmalo. ");
INSERT INTO etr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mida, na dilile nafia ado negesila, asigi falagaselasisegi, dilibalä ado nii nefolalebe amolia ado amo haila digila, made neadigimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dilile diadole diemelege, didooge, amase, dili sosogo odoage, dili damelëge, nefolalebe amolia dili hololölahilä, ado nii neebe amoligali gaula ïasegi, ilia diligi odoa baagomäia nufulömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Amase, dili nïe ëigi nefolalebego bealahilä, sulubadelaea dilima bimolö habobamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amala hamomolö gasoda, dilile busa hilï gogi, afädë made beselala fisimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dilia aso maadela, gelola aligiseda, namolö neala gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesuea ado aso, sähamu nea sähalea, Dilia beahaleamelële, ami dolö yafie amoli mafula, Yalusaleme nogöla amalei beaseda, gaamu amo nafademolöda, ga madefalï gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Segeyo amo gala, udia dolö Disiligi Yudia nefolalebe amolida, segebi dibea ami fisäla baluluia afufumolö dialea. Udia dolö Yalusaleme isogi nefolalebe amolida, gaamu amo dïgïla näiadodi moholö dialea. Amase, udia dolö gaamu baagido nefolalebe amolida, gaamu isogi nogila made digamolö dialea. ");
INSERT INTO etr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ado sulubadela säla dëdëla negei dibe amo gadola gausiala digamäia, segeyo amogida, asiala hamoi amoïe së ïmolöïe segeyomelë. ");
INSERT INTO etr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Segeyo amo gala, udia fagulo hagui sefolalebe amolige, malö dodo ïaha sefolalebe amolige, asigii gabu. Mida, yöi edefade nagadaiawi besela galala, udia dolö amoligali Godeïe mihalälo söga salimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ado nii neebe amoli maala, nudulo helebea ili nufudala baagomolömelë. Ilia ili nafodola gädili dibe amo sulubadelagi, sigi gaula moholömelë. Amase, fii odoa nefolalebe amolia Yalusaleme neala emesala nolealesa neamu, ilile wagamolö segeyo daiala negei amogi wagamolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesuea ado aso, sähamu nea sähalea, Segeyo amo gala, esogige, aubegige, gasumilïgige, nofe elöi hamomolömelë. Amala hamose amo gaalu, nagadaia wi duhulu aidagula maase amogige, goba nabase amogige, fifi asi amoli edefademalä hehealela bedäla, asigia säosäosa namolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Udia dolöea nelebo hamose amoli beahalea, nagadaia abilia hamomolödula helësëla bedähalea, si dädäbëlela digamolömelë. Mida, muugi nelebo geloi hïdo elöi amo neala fogolasimolö amea. ");
INSERT INTO etr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Segeyo amo gala, Dolöïe Malö amoda, geloi edefade amole, yo digalo hïdo elöi amolebalä, mu baidilidaia maala neë, ilia bimolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nelebo säi amo gadola hamola ulufadigimolöïe mi gäwiseda, dilia nowela nea, busa fädägägïa adogola namialo. Mida, Godea dili fisigäla fisigisimolö segeyo hä, ga madesagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Amala sälahilä, Yesuea ilima ado besula gowe säla ï. Dilia äfäeoge, i odoa nefolalebe amoli sulubadelage, bimalo. ");
INSERT INTO etr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","I bäu gähe bobagiseda, hä, sege esomolö ga made gabula, dihili amala helësëlomelë. ");
INSERT INTO etr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Amo gadola, dilia nelebo säi amoli hamose beaseda, Godea Beaha Maadela Sigi Neebe amo moholöda, ga made gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na dilima dofä sähago. Udia dolö walio nefolalebego baagola made, nefolalegi wäla, nelebo säi amoli sulubadela hamosa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mu giwige, naga föige, hogosa helemolö gaso, nïe adoda, dofä made hogosa helemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesuea ado aso, sähamu nea sähalea, Gagaomolöïe gagaolo ödä naala, gagaola dädäbëleloge, amase, nagadaia namolöïe säosäola helësëloge, dilile iso asigigi yöia idogola nea, segeyo amo dili mia aabela besela galala, ");
INSERT INTO etr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","gei dibea ami hogoi awäsegi, fädälo amo gadola fädäloea, hedabola idihë namialo. Mida, segeyo amo sege föi sulubadelagi, udia dolö sulubadela nefolalebe amolima moholö ameada. ");
INSERT INTO etr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Segeyo sulubadelagi idihë nea, nelebo hamomolö amo sulubadela dilia sisigala awäla yomäiaïege, amase, Dolöïe Malö amoïe siigi namiäiaïege, geloi ïmäia, Godema adosamu namialo. ");
INSERT INTO etr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Segeyo sulubadelagi, Yesuea udia dolö amolima Godeïe mosöa ami säla olelesa nelolahilä, deadiseda, gaamugi amila doadigila awäla, segebi ëi Olibebia ami midilö afufusa nelo. ");
INSERT INTO etr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Udia dolö sulubadelaea yosefalï nowela, Yesuea säse amo nabulöïe, Godeïe mosöa amimu maaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Segeyo amo gala, Segeyo Edefadegi beledi edelo yidila made gobela molö amoïe segeyoda, ga made dilo. Ëi elöda, Baagila Asi Segeyolage sälo. ");
INSERT INTO etr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gobela ïlo busa nefolalo amoliage, mala dawadigi amoliage, udia dolö nefolalebe amolibalä bedälo ameada, ilia Yesu nufulöïe idi hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Giwilasi amoligi, afädë Yudasa emada, ilia Isagaliadala sälo amoma, hä, Saidani fedai. ");
INSERT INTO etr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudasa e gobela ïlo busa amolige, Godeïe mosö beaha aligilo amolile busa amolige neebea ami awälahilä, ilibalä säla didiähalea, ea Yesu abeahäla hamola hololömolödula didiäi. ");
INSERT INTO etr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Amala didiäsebegi, dolö amolia obeägïlahilä, egali muni ïmolömelëla säla negei. ");
INSERT INTO etr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ilia säi amo nabala Yudasaea ülahilä, Yesu e udia dolö yafie gegedoi diëgi made, hïdo nafolai neëgi, ilile naabogi e gausimolöïe fu hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Beledi yidila made gobelo Segeyo Edefade amo besela galai. Segeyo amo gala, Baagila Asi Segeyo amoïe sugua sibi malö nufulö dilo. ");
INSERT INTO etr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Amamolö gabugi, Yesuea Fidale Yonelema sähalea, Baagila Asi Segeyo amoïe nilï molö molöïe, alia daiamolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Amalebe, elea naba obëgësalea, Amai, diada alïa abidi daiamäia hamesebela nabi. ");
INSERT INTO etr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Amala nabasebegi, ea elema säla obëgësalea, Ali gaamugi awäla besela galasegi, dolö afädë ödä iigi usi gaui maaha neebe amea ali gausiala digamolömelë. E awäse amo gadola bëgëla awälahilä, mosö e nogila digase amogi, alige nogila digala, ");
INSERT INTO etr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mosö eedo amoma gomalä sämalo. Säla Oleleloea dima nabahalea, Ne, nïe bëgëla aulo nefolalebe amolibalä Baagila Asi Segeyo amoïe molö molöïe, mosö hogolida abidi dialeala nabila sämalo. ");
INSERT INTO etr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ea alima mosö daia hogoli edefade afädë, nelebo negesa maadei dibe amo olemolömelë. Ami molö molöïe daiamalola säla ï. ");
INSERT INTO etr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Amala sälebe ele hä, awälahilä, nelebo ea säi amo gadolafalï gausiala digasebegi, elea Baagila Asi Segeyo amoïe molö molö ami daiai. ");
INSERT INTO etr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Segeyo amogi, molö molö fu besela galasebegi, Yesula abosolo dolö amolali molö molöïe auli amo amalela fifigi. ");
INSERT INTO etr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amala sefolalea, ea ilima sähalea, Ne aso, së made naala neebewegi wäla, Baagila Asi Segeyo amoïe molö dilibalä gedola molöila dofä hamesamu nelomelë. ");
INSERT INTO etr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Amoïe mida, na dilima säla ïahago. Na nasewe gadola made naala nea, Godea Beaha Maadela Sigi Neebea ami molö amoïe mi fädäla ulufala negei diëgi, bu molömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Amala sälahilä, ea gaabogi usi neala gaula nea, Godema nesegelahilä sähalea, Gowe nealahilä, gobe dadagabola mualo. ");
INSERT INTO etr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Amoïe mida, na dilima säla ïahago. Na wani ödä walio nasewe gadola, made naala nea, Godea Beaha Maadela Sigi Neebe amo besela galala neëgi, molömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Amala sälahilä, ea beledi afädë gaula nea, Godema nesegelahilä, dagabodasila iligali ï. Ïahalea, ea ilima sähalea, Egoweda nïe domalomelë. Dili ugila negela ïahago. Nahalea, ne helësëla mualo. ");
INSERT INTO etr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Amo naha maadelahilä, amo gadola wäla, ea gaabogi usi amo gaula nea sähalea, Gaabogi usi goweda, asialo made ado gähe elöi nïe healea säla negesebe amoda gomelë. Dili ugila negela, nïe heale besigahawe. ");
INSERT INTO etr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Gaso, Bimo! Dolö ne hololömolö amoda, nebalä aulidaia negela, molö naha saleamelë. ");
INSERT INTO etr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ïe, ado säla negei dibe amo gadola, Dolöïe Malö amo bëgëla moholö gaso, e hololöla odoaïe naabogi gausise dolö amo, asigii gabula säi. ");
INSERT INTO etr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Amala säsebegi, ilia hilimu elöea elöma nabala, elöea elöma nabalalahilä, Nowëa amala hamomolödula säla didiäha sefolalo. ");
INSERT INTO etr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Amala sälahilä, odoaea nilïgi goweda baagila asi neebela helësësebe amoda, nowëdula säla gëgësa dilo. ");
INSERT INTO etr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Amala gëgësa dibegi, Yesuea ilima sähalea, Udia dolö fii odoaïe beaha aligilo gini neebe amoliada, gelola beaha aligilo nea, amase, ilile ëi sälo amolia gelola sigi aligila, hili ili helësëla sähaleada, Udia dolö ugila negelola sälo nea. ");
INSERT INTO etr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gaso, dilida amo gadoi namolöi mademelë. Dili neebe gogi afädë dafidilo nea galëda, bu üfï hamola obëgëmolö galea. Amase, diligi beaha aligilo neebe ameada, oböla, hamoi hamolasilo gadoi hamola obëgëmolö galea. ");
INSERT INTO etr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dafidilo neebe amoda, nowë. Afädë fia idogola salea, aulidaia negela, molö naha sebe amole, ma, e molö muäia deala gaula mafusa neebe amole. Afädë fia idogola salea, aulidaia negela, molö naha sebe amo dafidilo nea madele. Amai gaso, ne dilibalä neada, hamoi hamolasiloea aligilo amo gadola neebewemelë. ");
INSERT INTO etr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ne mia yöi odoa besela galasebegi, dilia ne dïgïla made awäla nelomelë. ");
INSERT INTO etr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nïe Naadoea Beaha Maadela Sigi Neebe amo negali ï amo gadoi wäla, nage diligali ïahago. ");
INSERT INTO etr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nïe Beaha Maadela Sigi Neebea amida, dilia nïe aulidaia negela, molöle ödäle naha sefolamiäiage, amase, dili beaha aligilo filodaia salea, Isilale sosogo giwilasi amoli sigi namiäiage, ïahagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimono-o, Saimono-o, nabuö. Eladi gadoi widi dobi amoïe isole düle gasala sadia adogola mogelo amo gadola, dilima amala hamomäiaïe, mugabe Saidania fu ïmola Godema nabimelë. ");
INSERT INTO etr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gaso, dia asigi afädë negeigo made digamäia, na dïe Godema adolasimelë. Di hä, besula obëgëla maalahilä, didoolali neebe amoli, gelolasisa namialola säi. ");
INSERT INTO etr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Amala säsebegi, Fidaea säla obëgësalea, Dafidilo-o, di galabaia mosöa awäsege, di baagosege, neda dibalä moholöïe daiai neawela säi. ");
INSERT INTO etr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Amala säsebegi, Yesuea säla obëgësalea, Fida-o, na dima sähago. Walio gasigi haea gagalugo gawalia made gäla neëgi, dia nafi bu ohodoala, ne dawa madela sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuea ïe bëgëla aulo amolima nabahalea, Nïe hamoi hamola mosäia, na dili fisiga gahalea, muni saleloge, aduge, amase, emo usililoge, dilia gaula mosabiola säsebegi awäsolo amo gala, dilida nelebo gumusui afädë nelolela nabi. Ilia säla obëgësalea, Ai, amala made hamoila säi. ");
INSERT INTO etr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Amalebe ea ilima sähalea, Amai gaso, walio dolö afädëa muni salelo galea galëge, adu galea galëge, hä, nimolö dialea. Amase, afädë e nudulo helebe maade galëda, fagulo daia gäi amo giila muni nealahilä, nudulo helebe nimalo. ");
INSERT INTO etr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Amoïe na dilima säla ïahago. Godeïe bebagi ado säi dibe amoda, nema gausiala digamolö dialea. Ado amea sähalea, Udia dolöea eda ado säla negei neadigilo dolö amolibalä neala helësëmolömelëla säla dëdëla negei dialea. Mida, ne helësëla ado säla dëdëla negei dibe amo gadola, hä, walio gausiala digasebegomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Amala säsebegi, ilia ema sähalea, Dafidilo-o, bimo. Nilïa nudulo helebe äudä wi dialeamelëla säi. Amalebe, ea ilima, amo dofeala säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu e gaamua amila, hï dafidi aulo amo gadola, Olibebia moholö awäsebegi, ïe bëgëla aulo amolige ebalä asi. ");
INSERT INTO etr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ili segea ami besela galalahilä, ea ilima sähalea, Nafadea dili fedogola beasegi digaloea, Godema adosa namialola säi. ");
INSERT INTO etr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Amala sälahilä, ili dïgïla e holöbö wagadi made, igia nidi habisia amo gadoia awälahilä, emo gumu sasagala salea, Godema adosalea, ");
INSERT INTO etr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naado-o, gaabogi usi na molö gaulubewe, neala gaula moholö helësëseda, neala gaula mosalo. Amamäia gaso, na hamese we gadola made, dia hamese amo gadola hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Amala säha sebegi, selesaia fii afädë Hebenila maala ulufalahilä, e gelolasi. ");
INSERT INTO etr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu e asigigi yöia idogola edefademalä säosäolahilä, Godema gelola adosebegi, ïe filïmo amoda, oböla, heale gadoi besela galala nagadaia dögi. ");
INSERT INTO etr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Godema adola wagalahilä, e nowela, ïe bëgëla aulo sefolalebea ami bu obëgësamelebe, ili adidi difolalebe melï. Mida, ilile asigigi edefademalä yöi amea. ");
INSERT INTO etr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bealahilä ea ilima sähalea, Abilia hamosalea adidi difolalea. Dili adidi dibego nowelahilä, Godema adomalo. Nafadea dili fedogola beasegi digaloeala säi. ");
INSERT INTO etr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuea ilibalä ado amo säha nebegi, dolö yafie e neebea ami misi. Giwilasi amoligi dolö ëi Yudasaea ili sigi gaula misi. E Yesu mia maala, Yesu gaula mimi. ");
INSERT INTO etr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Gaso Yesuea ema nabahalea, Yudasa-o, dia Dolöïe Malö amo gaula mimila hololösalela nabi. ");
INSERT INTO etr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu hïbalä nefolalo amolia gomalä hamodelä hamosebela bealahilä, ema nabahalea, Dafidilo, nilïa ili nudulo helebe wea nufidedulela nabi. ");
INSERT INTO etr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Amala nabalahilä, iligi afädëa gobela ïlo busa edefadeïe hamoi hamolasilo amo nufudalahilä, ïe gëhe dafädimadi amo dagala salisi. ");
INSERT INTO etr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amala hamosebegi, Yesuea sähalea, Mala go gadola hamomabio. Fisimalola säi. Amala sälahilä, ïe naaboea gëhe amogi diigisebegi, gëhe amo bu hedabola obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Amala hamolahilä, gobela ïlo busa amoliage, Godeïe mosö idihë aligilo amolile busa amoliage, amase, asigi gäwi dafidilo nefolalo amoliage, Yesu gaumolöïe misi amolima ea sähalea, Dilia helebege, baialage, gagaula mofiaigoda, fa nelo dolö gaulo amo gadola gaumolöïe mofiaile. ");
INSERT INTO etr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Segeyo sulubadelagi, ne dilibalä Godeïe mosöa aligilo amogida, dilia ne made gaui. Gaso, walio gasimi sagaloea beaha aligisebe goeada, hä, dilile segeyomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Amala säsebegi, ilia Yesu gaulahilä, gobela ïlo busa edefade amoïe mosöa ami e, hä, sigi asi. Amalebe, Fida eda, holöbö hobeala, ili awäse amo bëgëla awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mosö amoïe yala isogi, ili nulo gobela sefolalebegi, Fidage ilibalä ami sulo. ");
INSERT INTO etr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nulo gobei söa fedasebea ami e sebe amo bealahilä, hamoi hamolasilo dolïsä afädëa ema siila nea, Dolö sebe gowege ebalä nelomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amala säsebegi, Fidaea sähalea, Udia, nada e dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Oböla, holöfalï nelolahilä, hobeala dolö elö amea e bealahilä sähalea, Dige dolö amoli sosogo amogimelëla säi. Amala säsebegi, Fidaea sähalea, Dolö, go ne mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Amala säla aoa afädë gadoi nelolahilä, dolö elöea gelola sähalea, Dolö goweda, dofä ebalä nelo. Mida, eege Galili dolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Amala säsebegi, Fidaea sähalea, Wa! Dolö! Dia säsebegoda, na dofä dawa mademelëla säi. Amala säi amole, haea gagalugoea gäi. ");
INSERT INTO etr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gagalugo gäse amo gaalu, Dafidilo Geloia besuia imogola Fidama siila nelo. Amala siila nebegi, Fidaea helësëla obëgësalea, Dafidilo Geloia ema sähalea, Walio gasigi haea gagalugo gawalia made gäla neëgi, dia nafi bu ohodoala, ne dawa madela sämolömelëla säi amo helësëi. ");
INSERT INTO etr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Amala helësëlahilä, e segea doadigila awäla, gäia güsäla dïisa nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesu sigi nelo dolö amolia e gadiabola digi, nufuda digisa nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Faguloea ïe si usulalahilä, ema nabahalea, Dolö di nufudase egoweda, nowëa gabu. Dihï bea säla sämola säha nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Amala sälahilä, ilia e gagadela ado nafadela yafie säha nelo. ");
INSERT INTO etr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yosefalï, eso si besela galase amo gaalu, Yu udia dolö ilile asigi gäwi dafidilo galïsolö dolö hulu gegedoi nelo. Amoligida, gobela ïlo busa amolige, mala dawadigi amolige nelo. Ili gegedoi dibea ami Yesu sigi maalahilä, ");
INSERT INTO etr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ilia ema sähalea, Afädë Memelei amo di galëda, nilïma sämola säi. Ea säla obëgësalea, Na dilima säla ïaseda, dilia na dofä säsebela made helësëmolömelë. ");
INSERT INTO etr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Amase, na dilima ado afädë nabasege, dilia made säla obëgëmolö gabu. ");
INSERT INTO etr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Segeyo walio wila nofela, Dolöïe Malö amoda, Gode Geloi Edefade Neebe amoïe naabo dafädimadi awäla samolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Amala säsebegi, ili sulubadelaea ema nabahalea, Amai dida Godeïe malö nealela nabi. Ea ilima säla obëgësalea, Neda dihili säsebe gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Amala säsebegi, ilia sähalea, Ea hamoi amoïe mi edoïe odoama nalï hogomolö. Hïle nafigila säse, nilïa nabi amomelëla, säi. ");
INSERT INTO etr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Busa dolö amoli sulubadela nowela, Yesu Bailadi neebea sigi afiai. ");
INSERT INTO etr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ilia ebalä gudimolö nea, mi gäwila sähalea, Dolö goea ado halowela säla, Yu udia dolöea asiala hamomäia dusugaha neë, nilïa melëlomelë. Amase, nilïa Sisama dagisi muni negelo amoge, ea negemabiola sälahilä, Afädë Memelei beaha aligilo ginida, emelëla säsio. ");
INSERT INTO etr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ilia amala säsebegi, Bailadia Yesuma nabahalea, Dida Yu udia dolöïe ginilela nabi. Amala nabasebegi, Yesuea säla obëgësalea, Dihï säse gomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Amala säsebegi, Bailadia gobela ïlo busa amolimage, udia dolö gegedoi nefolalo amolimage sähalea, Dolö gowea asiala hamoi afädë na made beasebemelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amala säsebegi, ilia gelolafalï sähalea, Dolö goea Yudia sege sulubadelamadi nawesa nea, ea ado olelese amea, udia dolö neebe amoli sulubadela gëgëlasilo nea. Dafidi Galilimadi mi gäwila hamosa nelo amo, walioda, hä, wi maala hamosa neagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ilia säi amo nabalahilä, Bailadia ilima nabahalea, Dolö goda amai, Galili dolölela nabi. ");
INSERT INTO etr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bailadia helësësalea, Yesu e sege Heledoea sigi neloamadila misi gabula helësëlahilä, e Heledo neebea fisiga gai. Segeyo amo galada, Heledo e Yalusaleme ami misi nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heledoea segeyo sedade dafidi nelo amogi, Yesu bimolöila helësësamu nelo amea, ilia e sigi maasebegi, Heledoea edefademalä obeägï. Yesuea hamolo mala säla ï amo ea nabala nelo ameada, Yesuea dolöea hamomolöi made gadoi hamose amo bimolöila hamesa nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Amalahilä, ea Yesuma ado odoa yafie nabi. Gaso, Yesuea ema ado afädë made säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gobela ïlo busa ami nefolalo amoliage, mala dawadigi dolö ami nefolalo amoliage, gelola gudilahilä, ea nafade yafie hamoimelëla säha nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Amasebegi, Heledoeage, ïe ami dolö nefolalo amoliage, Yesu gagadela gadiaboi. Amalahilä, fagulo sedade hedabi hïdo elöi afädë salugasilahilä, Bailadi neebea sigi obëgëmalola säi. ");
INSERT INTO etr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dafidi Heledo Bailadileda, ado neala gasi gogoi nelo gaso, segeyo amogi, ele oböla, damelë hamoi. ");
INSERT INTO etr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bailadia gobela ïlo busa nefolalo amolimage, beaha aligilo dolö nefolalo amolimage, amase, udia dolö amolimage, wela gegedomalolahilä, ");
INSERT INTO etr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ilima sähalea, Dilia dolö gowe ne neebea sigi maalahilä, nema sähalea, Ea udia dolöea ba bimäia ado neasilo neamelëla säi amo, na e dilile si mogogi ifosiä, ea nafade edo hamoi walebelela, ema nabala hogosamu nelo. Gaso, dilia ea nafade gowe ili hamoimelëla säi amoligida, asiai afädë na made melïmelë. ");
INSERT INTO etr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heledoeage, we gadola wäla bealahilä, nilï neebeawi sigi obëgëmaloi gabumelë. Hä, nabuö. Ea hamoi amoïe e baagomäia nufulöda, mi maade gabu. ");
INSERT INTO etr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ameada, na e fëgämalola sälahilä, fisiga gamola sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bailadia amala säsebegi, udia dolö sulubadelaea gelolafalï gaalu uuala sähalea, Dolö goda nufudala baagomäia. Balabasada, nihïlïma fisigämalola uuala didigai. ");
INSERT INTO etr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasa eada, gaamu isogi ami gamanebalä nudui amoïege, dolö nufudala baagoi amoïege, ilia e galabaia negei nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bailadia Yesu bahïla mosöla sämolöïe, ea ilima bu nabasebegi ");
INSERT INTO etr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","gaso, ilia gelola uuala säla didigahalea, Eda nufualo. Nufualo. I fügäigi baala negemalola uuala säla didigahamu nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Amala säsebegi, Bailadia ilima bu osoda sähalea, Mi edogi. Eada nafade edo hamosio. E baagomäia nufulöïe ea nafade hamoida, na made melïmelë. Amoïeda, na dolö odoama e fëgämalalahilä, mosalahawela säi. ");
INSERT INTO etr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amala säi gasoda, ilia i fügäigi baala negemalola gelolafalï uuala säla didigase amea, Bailadiïe ado hado gai. ");
INSERT INTO etr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Amala säsebegi, Bailadia ilia hamomalola egedigisebegi amo gadola hamomalai. ");
INSERT INTO etr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gamane dolöbalä nudui amoïege, dolö nufi amoïege galabaia negei dolö amoda, ilia Bailadia fisigämäia hamei amo fisigäi. Amalahilä, Yesu hili helësëse amo gadola hamomäia, ami dolö amolile naabogi gausi. ");
INSERT INTO etr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ami dolö amolia Yesu sigi awäha nebegi, gaamu Sailini fii dolö afädë, ëida Saimono, mosö gägäwila asi dibea amila, Yalusaleme besela galamolö maaha nebegi, idiafa gausiala digai. Ilia e gaula, Yesuïe i fügäi ïe gïdädaia negesilahilä, Yesu awäse amo gadola gaula hobeala misialai. ");
INSERT INTO etr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yafie gegedoi amoli Yesu awäse amo gadola afiahalea, iligi udia odoage gualö afiahalea, eegi asigiila didigaola aligi afiaha dilo. ");
INSERT INTO etr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Amasebegi, Yesuea besuia imogola nea, ilima sähalea, Yalusalemeïe idiwilali-e, ne helësëla dïimabu. Dihili diligige, dilile malögige helësëla dïimalo. ");
INSERT INTO etr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nabuö. Hobeala segeyo moholö amogida, ilia sähalea, Udia fagulo made hagula, haua, malö sogobamolöi made, malö dodo dofä made ïlo sefolalebe amolia obeägïsa saleamelëla sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Segeyo amo gala ilia segebi dibe amolima säia adahalea, Dili dagabola digala, nilï dabemalola sälahilä, gau dibe amolima säia gahalea, Nilï hagumalola sämolömelë. ");
INSERT INTO etr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mida, ilia walio i ödäla neebe amoma mala egowe gadola hamosa galëda, amai i bausoi neebe amomada, mala abodo gadoi hamomolödula säi. ");
INSERT INTO etr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ami dolö amolia dolö äudä mala nafade hamolo amolege, Yesubalä gaalu nufulöïe sigi asi. ");
INSERT INTO etr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ili afiala sege ëi Busa Giwi dibea ami besela galala, ilia Yesu i fügäigi ami baala negelahilä, nafade hamolo dolö äudä amolege, elö ïe naabo dafädimadi, elö ïe naabo fefeädimadila i fügäigi baala negei. ");
INSERT INTO etr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Amala hamosebegi, Yesuea sähalea, Naado-o, ilia gowe hamosala helësëla made hamose ameada, dia egowelile nafade hëla fisimalola säi. Amase, ami dolö amolia ïe fagulo gii amo nowëa nimabelela, sadu dahilahilä, ïe fagulo amo mogei. ");
INSERT INTO etr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Udia dolö nefolalo amolia sisila nefolalebegi, busa dolö nefolalo amoliage Yesu gadiabola sähalea, Ea udia dolö odoa ugila negelo. Eda Geleso, Godea Afädë Memelei amo nea galëda, amo gadola, ea hï e ugila negemäiala säi. ");
INSERT INTO etr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ami dolö amoliage e dibe amo ga madela maala aligilahilä, e gadiaboi. Wani ödä gamogai amo muäia, ïe nafia disilahilä ");
INSERT INTO etr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","sähalea, Di Yu udia dolö ilile gini nea galëda, dia dihïmu ugila negemola säi. ");
INSERT INTO etr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ilia i fügäigi ïe busa daia bidigi adomoi, ado afädë dëdëla negesalea, Egoweda, Yu udia dolöïe beaha aligilo ginila säla dëdëlahilä, baala negesi. ");
INSERT INTO etr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nafade hamolo äudä baala negei amolegi, afädëa Yesu gagadela sähalea, Dida Afädë Memelei amo madele. Dia dihïdi ugila negesalea, alïge ugila negemola säi. ");
INSERT INTO etr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amala säsebegi, dolö elö amea elö amoma nemosalea, Diage dolö egowea së nasego gadola nase gogi, dia Godebalä made bedäsebele. ");
INSERT INTO etr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Alïa nafade hamoi amoïe së molö dibe amo gadola, ilia alïma hamosebe weda, mogola hamosebe. Be, dolö goweada, nafade made hamoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Amala sälahilä, ea Yesuma sähalea, Yesu-o, di beaha aligilo gini hamola maasolo amo gala, dia ne helësëmalola säi. ");
INSERT INTO etr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Amala säsebegi, Yesuea ema sähalea, Na dima dofä sähago. Walio dida, hä, nebalä Hebeni namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Eso si mogogila, eso si osoda amo gadola, sege sulubadela gasilasimu dilo. ");
INSERT INTO etr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mida, eso neëla made, usi amea. Gobela ïlo mosöa fagulo edefade gosai dilo amoge, mogogi gadelala digalahilä, elö eamu eamula negesi. ");
INSERT INTO etr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Amase, Yesuea gelolafalï uuala sähalea, Naado-o, nïe gesami dïe naabogi gausisagola säi. Amala sälahilä, hame doala asi. ");
INSERT INTO etr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ami beaha aligilo busa amea, amo beala, Godeïe ëi gauia adogolahilä, sähalea, Dolö goda, dofä asigi mogoi gabula säi. ");
INSERT INTO etr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amase, udia dolö amo bea gegedoi amolia, amala hamosebe amo bealahilä, hilile bidagia nulufuda, hili mosöa obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gaso, Yesu e sosogo amoli sulubadela amola, udiafalï Galilila e bëgëla mofiai amolalida, holöbö mia made nea, amo hamose amo beaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Dolö asigi mogoi hedabi afädë, ëi Yosebe nelo. Eda galïsolö dolö amoligi nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Galïsolö dolö ilia daiala negese amo gadolage, hamose amo gadolage, eada üla made säi. Eda Yudiamadi gaamu afädëïe ëi Alimadia dolö nelo. Eada Godea Beaha Maadela Sigi Neebe amo misiäia beaha nelo. ");
INSERT INTO etr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dolö amea Bailadi neebea awälahilä, Yesuïe domalo nedulela nabi. ");
INSERT INTO etr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Amalebe, ea Yesuïe domalo gaula digala, fagulo hedabia usulalahilä, igi äbä dolö afädë baui made, gähe duwi dilo amogi bausi. ");
INSERT INTO etr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Segeyo amoda, Sabada segeyoïe nelebo daialo segeyo dilo. Segeyo Sabada amoda, hä, ga made dilo. ");
INSERT INTO etr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Udiafalï Galilila Yesu bëgëla mofiai amolia, Yosebe bëgëla awälahilä, igi äbä amoge, ea Yesuïe domalo bause amoge melï. ");
INSERT INTO etr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ili hili mosöa obëgëlahilä, i heale gegoai odoage, weli gafisigäi hedabi odoage daiai. Amalahilä, Sabada segeyogi mala säla negei dibe amo gadola, ili hele sulo. ");
INSERT INTO etr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saleleïe mi gäwi segeyogi, yosefalï, udiafalï amolia nelebo gafisigäi daiala negei dilo amo neala gaula, Yesu bauia ami afiai. ");
INSERT INTO etr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ili awäla beahamelebe, igia baui idi gai amo bauia amila, bebugula asi dibe melï. ");
INSERT INTO etr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Amo bealahilä, ili nogila digala beahamelebe, Dafidilo Geloi Yesuïe domaloda, maade melï. ");
INSERT INTO etr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Domalo maade gabugi, ili asigia säosäosa nefolalebegi, dolö fagulo falei si dëdëgïla digamolöi gäi äudä, ili mia fodolofalï maala ulufadigila nelo. ");
INSERT INTO etr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ele beala, udiafalï amoli bedäla, busa fufuäla nefolalebegi, dolö amolea ilima sähalea, Dolö neebe amoïe, oböla, baagoia gui hogosegoda, edoïe. ");
INSERT INTO etr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eda wi maade. E nowela asimelë. Dafidi Galili nea, ea dilima säi amo helësëla obëgëmalo. ");
INSERT INTO etr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ea sähalea, Odoaea Dolöïe Malö amo nafade hamolo dolö neebe amolile naabogi gausisegi, ilia e i fügäigi baala negeseda, segeyo äudä nelolahilä, osodagi e nowemolömelë. Amala hamomolö dialeamelëla Yesuea säi amomelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Amala säsebegi, ea dafidi säi amo ilia helësëla obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Amalahilä, ili bauia amila obëgëla awäla, bëgëla aulo gïdälasi amolimage, udia dolö odoa ili sulubadelamage, nelebo hamoi amo sulubadela säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Magadala udia Meliage, Yoanaeage, Yameseïe eme Meliage, amase, udiafalï odoa ilibalä nelo amoliage, ado amo gaula awäla abosolo ilima säla ï. ");
INSERT INTO etr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amala säla ï gaso, abosolo ilia udiafalïa ado säi amoda, memalä ado gadoi gabula helësëlahilä, dofä gabula made helësëi. ");
INSERT INTO etr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amai gaso, Fida e bauia ami baluluia awäla, dosogägïla fia idogola salea, aga beahamelebe, isogi ami fagulo amomu dibe melï. Amo bealahilä, hï asigia helësësalea, amo edo hamoidula fudugila hehelësëla obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Segeyo amo galamu, bëgëla aulo amoligi, äudä sege ëi Emeasa moholö asi. Sege amoda Yalusaleme amila, gilomida gïdälasi gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ele idiafa awäha nea, nelebo sulubadela hamoi amoïe säsäla awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Elea amala säsäla awäha nebegi, Yesu hï eege maala baalahilä, ele awäse amo gadola, hiligila awäha nelo. ");
INSERT INTO etr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Gaso, elea e gabula bimolö ulï nelo. ");
INSERT INTO etr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Awäha nea, ea elema nabahalea, Ali awähalea, edo säsäla awäha neala nabi. Ea amala nabasebegi, elele odagi yöia idogolahilä, olobola nelo. ");
INSERT INTO etr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Amalebe, afädëïe ëida Giliobasa, ea ema säla obëgësalea, Udia dolö yafie Yalusaleme mafula gegedoi amoligi, salele walio wegi nelebo ami hamoi amo, di afädë diamu made dawa nealela nabi. ");
INSERT INTO etr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Amala nabasebegi, ea elema nabahalea, Nelebo goda edola nabi. Elea ema säla obëgësalea, Nasalese fii Yesuïe sähamelë. Eda bea sälo nea, Godeïe siigige, udia dolö sulubadelaïe siigige, ea hamoi hamoi amoge, ado säi amoge, hedabola gelola hamoimelë. ");
INSERT INTO etr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gobela ïlo busa nefolalo amoliage, nilïle busa nefolalo amoliage, gamane ilia ebalä gudilahilä, baagomolö dialeala sämäia, ilile naabogi gausisebegi, ilia e i fügäigi baala negei. ");
INSERT INTO etr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amala hamoi gaso, nilïa dafidi helësësaleada, afädëa Isilale udia dolö fisigäla sigi obëgëmolö amoda, e gabula sisiläfüla helësëi. Gaso, nelebo amala hamoi amo, segeyo walio neebeweda, osodamelë. ");
INSERT INTO etr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Amase, nilïbalä aligilo udia odoaea nilï fudugilasisio. Walio yosefalï, ilia e bauia bea awähamelebe, ");
INSERT INTO etr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ïe domalo made melïmelëla säsio. Made beala obëgëla maalahilä sähalea, Sosoäla awäla melëlo amo gadola, nilïa selesaia fii melïmelëla säsio. Amolea nilïma säla ïahaleada, Eda nowela neamelëla säimelëla sämolö obëgëmalasio. ");
INSERT INTO etr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Amala säla ïasebegi, nilïbalä aligilo odoaeage, bauia ami bea awähamelebe, udiafalï amolia säi amo gadola wäla bealahilä, iliage e made melïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Amala säsebegi, ea elema sähalea, Ali asigi maade gabu. Bea sälo nefolalo amolia ado säla negei dibe amo sulubadela, iso asigia dofäla aabela made helësëi gabu. ");
INSERT INTO etr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Afädë Memelei amea, ïe ëi ilibia eleloi hïdo elöi dibe amo salugamolöïe, dafidi e nelebo amoïe së molö dilo madelela säi. ");
INSERT INTO etr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Amala sälahilä, Mosesea Ado säla negei dibea amila mi gäwilahilä, bea sälo nefolalo amoli sulubadelaea ado säla dëdëla negei dibe amo sulubadelagi, ïela säi dibe amo elema awala säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ili afiala sege ele samolöia ami moholö ga madela nea, Yesu eda hä, baagila moholöi awäsebegi, ");
INSERT INTO etr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","elea adoea dofogala sähalea, Eso digala së gämolö ga madesebe, di walio alïbalä wi diahadula säi. Amala säsebegi, elebalä mosöa ami digala sulo. ");
INSERT INTO etr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Elebalä molö molöïe, ea beledi gaula nea, Godema nesegelahilä, dagabola elegali ï. ");
INSERT INTO etr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Amala hamosebegi, elele si doga negesi. Amalebegi, elea eda Yesu gabula helësëse amo gaalu, e ami wäla hogosa helei. ");
INSERT INTO etr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Amalebe, elea heledo sähalea, Idiafa alïbalä adodola maahalea, ea ado säla dëdëla negei dibe amoli alïma doga negela säsebegi, alïle isogi nulo wilo wäla wilasisio madelela säha sulo. ");
INSERT INTO etr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Amalahilä, ele fodolofalï nowela, Yalusaleme obëgëi. Elea ami beahamelebe, bëgëla aulo gïdälasi ilige, odoa ilibalä nefolalo amolige, gedola sefolalebe melï. ");
INSERT INTO etr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ami sefolalo amolia sähalea, Dofä! Dafidilo Geloida, nowei nea. Saimonoma ulufaimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amase, eleage idiafa nelebo ele mia besela galai amo ilima awala säla ïalahilä, ea beledi dagaboia gasebegi, alïa e gabula helësëimelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ilia ado amo, aso, säha dibegi, Yesu hï e ili mogogi ami maala nelo. Ea ilima sähalea, Dalulo dilibalä diamiäiala säi. ");
INSERT INTO etr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","E maala nebegi, baagoi gesami beahala helësëla, ili edefademalä fudugila bedäi. ");
INSERT INTO etr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Amaha dibegi, ea ilima sähalea, Edogi yöia idogola säosäosa dialea. Dilile iso asigigi asigi äudä negei dibegoda edoïe. ");
INSERT INTO etr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Weda nihïne gabula helësëmäiaïe, nïe naabo emo bimo. Dilia ne hüge giwige galebe amo beaha nea, baagoi gesamida, amo gadola aligilo made ameada, ne diigila bimola säi. ");
INSERT INTO etr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Amala sälahilä, ïe naabo emole ilima olei. ");
INSERT INTO etr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Amasebegi, ilia obeägïla digi, fudugila bedäla digisa nelo amea, amo dofä gabula made helësëi nelo. Amalebegi, ea ilima nabahalea, Dilia molö odoa gui dibelela nabi. ");
INSERT INTO etr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Amalebe, ilia seme gobei dagaboi amo egali ïasebegi, ");
INSERT INTO etr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ea amo neala, ilile siigi nea mai. ");
INSERT INTO etr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hobeala, ea ilima sähalea, Ne dilibalä dafidi nelo amogi nea, na dilima gomalä säla ï amoda gowemelë. Mosese nebegi, Ado säla dëdëla negei dibe amogige, bea sälo nefolalo amolia dëdëla negei dibe amogige, Gë Udälo bebagi dëdëla negei dibe amogige, nïela säla dëdëla negei amo sulubadela gausiala digamolö dialeala säla ïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Amalahilä, ea Godeïe bebagi ado säla dëdëla negei dibe amoli, ilia helësëmäiaïe, ilile asigi doga negelasi. ");
INSERT INTO etr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Amalahilä, ea ilima sähalea, Ado säla dëdëla negei dibe amoda gowemelë. Afädë Memelei amea së nalahilä, segeyo osodagi baagoia amila nowela ");
INSERT INTO etr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","odoaea ïe ëigi nea, udia dolöea nafade hamoi amo hëmäia, asigi besumolö dibe amoïe mala amoda, Yalusalemedale mi gäwilahilä, fifi asi difolalebe sulubadelagi, säsäla moholöla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nelebo hamola besela galai amo, dilia säla ulufaha namialo. ");
INSERT INTO etr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nabuö. Naadoea diligali ïmolömelëla säla negei amo, na dilima fisiga idogomolömelë. Ilibiala geloi amo dilia neala salugamolöïe, gaamua wimu beaha namialola säi. ");
INSERT INTO etr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesuea ili sigi sege Bedanimadi awälahilä, ïe naabo gauia adogola nea, Godea ili neala obeägïlasimäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ea ili, aso, obeägïlasila säha nea, Godea e Hebeni gaula fedasebegi, ea ili dïgïla asi. ");
INSERT INTO etr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Amala hamosebegi, ilia ïe ëi gauia adogola, ilima edefademalä obeägïmolö nobala, Yalusaleme obëgëi. ");
INSERT INTO etr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ilia segeyo sulubadelagi, Godeïe mosöa awälahilä, Godeïe ëi gauia adahamu aligilo. Hä amo. ");
INSERT INTO etr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ado eda mi gäwilafalï siiba nelo. Eda Godebalä nelo. Ado hï eda Gode nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Eda mi gäwilafalï, Godebalä siiba nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Afädë idi elömadila misida, maade. Godea Adobalä nea nelebo sulubadela hamosa maadeimelë. ");
INSERT INTO etr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Emada namolö mi dilo. Namolö ameada udia dolöïe yo digalo nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yo digalo ameada gasimi sagaia ami yo digaha nea. Gasimi sagaloeada yo digalo amo gesumolöi made dilo. ");
INSERT INTO etr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Godea dolö afädë nagadaia fisiga wei amoïe ëida Yone e misi nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","E misi amoda yo digalo amoïe säla ïmolöïe misi. Amaimo, udia dolö sulubadelaea ïe ado nabalahilä, asigi afädë negemäiaïe misi. ");
INSERT INTO etr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hï eda yo digalo amo made. E misi amoda yo digalo amoïemu säla ïmolö misi. ");
INSERT INTO etr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yo digalo amoda dofä yo digalofalï nelo. Udia dolö sulubadelagali yo digalo ïlo. E nagadaiawi moholö nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ado eda nagadaiawi nelo. Ado ameamuda Godea sege föi hamoi gaso, nagadaia udia dolöea e gowe gabula made helësëi nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eda hïle segea wi misi gaso, hïle sosogoea e made säla olei. ");
INSERT INTO etr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gaso, odoaea e säla olela ïe ëigi asigi afädë negesebegi, ea ilima sähalea, Dilida Godeïe malö namialola säi. ");
INSERT INTO etr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ili Godeïe malö besela galai amoda, eedole emelele healemadila made, amase, domaloïe hameloea made, amase, dolöïe hameloea made, Godeamu ïe malö hamola besela galai. ");
INSERT INTO etr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ado eda dolö domalola digala, nilïbalä wi nelo. Nilïbalä wi nebegida, ïe yo digaloge ïe geloige hïdo elöi amo nilïa melïmelë. Eedoïe malö emu nea, ugila negelole ado dofäle ema nobala, ïe yo digaloge ïe geloige hïdo elöi dilo amo nilïa melïmelë. ");
INSERT INTO etr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yonea Adoïe säla ïaha nelo. Ea uuala sähalea, Dolö goda dafidi na dilima säla ïahalea, Ne baagia maase amoda, ne baagila asimelë. Mida, ne maadeia e dafidi nelola säila säi. ");
INSERT INTO etr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ema nobai amo adugasebegi, ea nilï sulubadela ugila negelahilä, hä, bu elöge ugila negesamu nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Godea Mosesemadila mala säla negei amo säla ï gaso, ugila negelole ado dofäleda, Yesu Gelesomadila misimelë. ");
INSERT INTO etr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Afädëa Gode dofä made melï gaso, ïe Malö afädëfalï amea Gode e nilïma ulufala olei. Malö amoda dofä Gode. Eda Eedobalä dila nea. ");
INSERT INTO etr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yu ilia gobela ïlo dolöge, amase Ilibai dolöge Yalusalemela Yone neebea mosalosebegi, ili maala Yonema nabahalea, Dida nowëla nabi. Amala nabasebegi, Yonea gomalä säla ï. ");
INSERT INTO etr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ea musügä negela made, hedabola ulufala säla ïahalea, Afädë Memelei amoda ne mademelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Amala säla ïasebegi, ilia ema nabahalea, Amai dida nowë. Dida Elaialela nabi. Amala nabasebegi, ea säla obëgësalea, Neda e mademelëla säi. Amala säsebegi, ilia ema bu nabahalea, Dida bea sälo amolela nabi. Amala nabasebegi, ea säla obëgësalea, Ai. Neda amo mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Amala säsebegi, ilia ema bu nabahalea, Dida dofä nowë. Dolö nilï fisiga welo amolima eda gowe gabiola sämolöïe, diada dihï dimada nowëla sähala nabi. ");
INSERT INTO etr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Amala nabasebegi, Yonea bea sälo Aisaeaea säi amo gadola ilima säla obëgësalea, Neda afädëa sege nafadeia udia dolö aligilo made dibea ami nea uuala wesalea, Dafidilo Geloi misiäia idi mogola fodomalola säha neamelëla säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Felesi ilia dolö fisiga gai ");
INSERT INTO etr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","amolia Yonema nabahalea, Dida Afädë Memelei amo made galëda, amase, Elaia made galëda, amase, bea sälo amo made galëda, amai mi edoïe dia udia dolö ödägi gesa neala nabi. ");
INSERT INTO etr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Amala nabasebegi, Yonea ilima säla obëgësalea, Nada ili ödäeamu gesa neawe. Gaso, dolö afädë dilia made dawa dili mogogi nea. ");
INSERT INTO etr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dolö amoda ne baagia hobeala moholömelë. Nihïneda ïe emo usililo ëfë fisigämolöda dofea mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yonema nabi amoge, amase, ea säla obëgëi amoge ödä Yodona dëgëla alömodi, Bedani segea nea amala säi. Segea amida Yonea udia dolö ödägi gesa nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Amo aiyo amogi, Yonea Yesu e neebea maasebe amo bealahilä sähalea, Bimo. Egoweda Godeïe Sugua Sibi Malömelë. Goeada udia dolö sege föi sulubadelagi nefolalebe amolile nafade hamoi amo hësa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dolö goda dafidi na dilima säla ïahalea, Ne baagia hobeala maase amoda, ne baagila asimelë. Mida, ne maadeia e dafidi nelola säla ï amoda egowemelë. ");
INSERT INTO etr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nada e dawa made nelomelë. Amai gaso, e Isilale udia dolöma ulufala olemolöïe, na udia dolö ödägi gemolö misimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yonea e ulufala sähalea, Na beahamelebe, Gesami Hebenila haea maliabu gadoi digalahilä, edaia fise melïmelë. ");
INSERT INTO etr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nada e dawa made nelo gaso, udia dolö ödägi gemäia ne fisiga welo amea nema sähalea, Dia Gesami digalahilä dolö afädëdaia fise beaseda, dolö ameada udia dolö Eleloi Gesamia gemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eda Godeïe malö neebe amo na melïmelë. Amo na dilima säla ïmelëla Yonea säi. ");
INSERT INTO etr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Amo aiyo amogi, Yonege ïe bëgëla aulo äudä amolege bu amimu nelo. ");
INSERT INTO etr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Amala nea, Yonea Yesu awäha neebe amo bealahilä sähalea, Bimo. Egoweda Godeïe Sugua Sibi Malömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Amala säsebegi, ïe bëgëla aulo äudä amolea ea säse amo nabalahilä, Yesu bëgëla asi. ");
INSERT INTO etr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Amalebegi, Yesuea besula beahamelebe, ele e bëgëla maaha neebe melï. Ea elema nabahalea, Alia edo hogosala nabi. Amala nabasebegi, elea ema nabahalea, Elabai-e, dida mosö abodogi saleala nabi. Elabai amo besulada, säla olelelola sälo. ");
INSERT INTO etr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Amala säsebegi, Yesuea elema säla obëgësalea, Alia bea misiëla säi. Amala säsebegi, ele awälahilä e diasebe mosö amo beaha nelo. Segeyo amoda ebalä ami nelo. Ele ebalä asi amoda eso si biyidugi gadola deadi asi. ");
INSERT INTO etr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bëgëla aulo äudäea Yoneïe ado nabala Yesu bëgëla asi amolegi, afädëda Saimono Fidaïe edoo Ädulu. ");
INSERT INTO etr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Eada Yesu hä amilahilä, fodolofalï ïe edoo Saimono bea asi. Amalahilä, ea Saimonoma sähalea, Alïa hä Mesaea melïmelëla säi. Ëi Mesaea amo besulada, Gelesola sälo. ");
INSERT INTO etr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Amalahilä Äduluea e sigi Yesu neebea asi. Maaha nebegi, Yesuea ema siila nea sähalea, Dida Saimono, Yoneïe malö. Dïe ëida Sifasala sämolömelëla säi. Ëi Sifasa amo besulada, Fidala sälo. ");
INSERT INTO etr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Amo aiyo amogi, Yesu e Galili moholö helësëi. E awäla Filibi gausialahilä ema sähalea, Ne bëgëla misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibida gaamu Bedesaida ami fii dolö. Sege amoda Ädulule Fidalele sege. ");
INSERT INTO etr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Amasebegi, Filibia Nadanale hogola asi amo beagolelahilä ema sähalea, Mosesea Ado säla negei dibe amogi ïe dëdëla negei amo gadolage, amase, bea sälo amolia bebagi ïe dëdëla negei amo gadolage, nilïa hä e melïmelë. Amoda Nasalese fii Yesu, Yosebeïe malö amo gabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Amala säsebegi, Nadanalea ema nabahalea, Amai nelebo hedabi afädë Nasalesela moholöi gabulela nabi. Amala nabasebegi, Filibia ema sähalea, Dia bimolö misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Amala säsebegi, Yesuea Nadanale e maaha neebe amo bealahilä, e helësëla sähalea, Bimo. Dolö maasebe egagoweda dofä Isilale dolömelë. Wäfalï sälo afädë egowemada mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Amala säsebegi, Nadanalea ema nabahalea, Dia ne abilia dawadigila nabi. Amala nabasebegi, Yesuea ema säla obëgësalea, Filibia di, aso, made wela nebegi, di äfäeo i mia sulo amoda na melïmelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Amala säla ïasebegi, Nadanalea säla obëgësalea, Säla Olelelo-o, dida Godeïe malö. Dida Isilaleïe Ginimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Amala säsebegi, Yesuea ema säla obëgësalea, Di äfäeo i mia sulo amo na melïla säi amea dia nema asigi afädë negesale. Hobealada go gadoi made, baagila asi elöi bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Amalahilä, Yesuea ema bu elö sähalea, Na dilima dofä gelola sähago. Hebeni doga negei bealahilä, dilia Godeïe selesaia fii amoli Dolöïe Malöma fedafu digafusa neë bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Segeyo äudä nelolahilä osodagi, Disiligi Galiliïe Gaina segea ami, dolö afädëïe udia ifosebea Yesuïe emea amo bea asi. ");
INSERT INTO etr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ilia Yesuge ïe bëgëla aulo amolige misialola wesebegi, ili awälahilä, udia ifosebea ami nelo. ");
INSERT INTO etr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wani ödä amo hä maadei gabugi, Yesuïe emea ema sähalea, Ilia wani ödä amo hä, maadei gabuwela säi. ");
INSERT INTO etr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Amala säsebegi, Yesuea ema säla obëgësalea, Neme, nïe hamoi amogida, dia nema hamomola sämolöi mademelë. Nïe segeyoda, asomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Amala säsebegi, emea oböla hamoi hamolasilo amolima sähalea, Ea dilima nelebo afädë hamomalola säseda, dilia amo nabala hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Amaimo, amida gobo i igia hamoi bobogamu gafeia dilo. Yu iliada ilile aialo mala dibe amo gadola hësa aligilo dilo. I afädë afädëlagida bagedi i nabülasi gadoia galë, mimogolasi gadoia galë, söga salasegi nobamolöi dilo. ");
INSERT INTO etr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Amala säsebegi, Yesuea hamoi hamolasilo amolima sähalea, Gobo i gogi ödä osaha maademalola säi. Amala säsebegi, ilia ea säsebe amo gadola, osala nobaha maadei. ");
INSERT INTO etr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Amala hamosebegi, ea ilima sähalea, Ödä usi gogi odoa neala gaula, molö sigi aligilo neebea ami mosalola säi. Amala säsebegi, ilia amo gadola hamolahilä, gaula asi. ");
INSERT INTO etr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gaula awälahilä, molö sigi aligilo amoma ïasebegi, ea ödäfalïa wani ödä hamoi amo na bealahilä, abidi niidula asusugai. Hamoi hamolasilo dolö, ödä usi gaula mulo amoliamuda, dawadigi nelo. Amala asusugalahilä, ea udia goa amo welahilä, ");
INSERT INTO etr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ema sähalea, Udia dolö molö molö misialola säi misi sefolalebe amoli wani ödä hedabi amo dafidi muäia osala ïïa awälahilä, udia dolö amoli edefade naala gagaosa neëgi, wani ödä fea amo odoa muäia ïlo negei gaso, wani ödä hedabi amo musügä negei dilolahilä, dia oböla hobeala gaula misi gabula säi. ");
INSERT INTO etr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuea dolöea hamomolöi made gadoi dafidi mi gäwila hamoi amoda, Disiligi Galiliïe gaamu Gaina amidale hamoi. Ea amo hamoi amoda, ïe geloi hïdo elöi dilo amo ulufala olei. Amala hamosebegi, ïe bëgëla aulo amolia ema asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hobeala, Yesuge, ïe emege, ïe edoolalige, amase, ïe bëgëla aulo amolige, Gabaniama gaamugi awälahilä, segeyo ede made ami nelo. ");
INSERT INTO etr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yu ilile Baagila Asi Segeyo edefade amo hä, ga made dibegi, Yesu e Yalusaleme moholö asi. ");
INSERT INTO etr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Amalahilä, ea Godeïe mosöa ami beahamelebe, sugua gaoge, sugua sibige, haea maliabu gadoige, bidi neadigisa dibe melï. Amase, dolö odoa muni bedefaloge ami sefolalebe melï. ");
INSERT INTO etr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Amo bealahilä, Yesuea ëfë gadoia fëgälo ëfë afädë hamoi. Amalahilä, ea dolö amolige, sugua gaoge, amase, sugua sibige, Godeïe mosö yala isogi amila nulufuda segea nesila fisiga gaha maadei. Muni bedefa bedefalo sefolalo amolile muni aulidaia difolalo amola neala besigadasila sadia galahilä, auli amoge besusa maadei. ");
INSERT INTO etr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Amala besusa maadelahilä, haea magaia neaha difolalo amolima sähalea, Goda sulubadela segea gaula afiamo. Naadoïe mosö ameada, magaia nelo mosö gadoi hamomabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ea amala hamose amo bealahilä, ïe bëgëla aulo amolia ado afädë bebagi säla dëdëla negei dibe amo helësëla obëgëi. Amoda gowe. Na dïe mosö gelola hamese amea, ne sëlasimolömelëla säla dëdëla negei dibe amo helësëi. ");
INSERT INTO etr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesuea amala nesila digisebegi, Yu ilia ema nabahalea, Dia hamoi amo gadola hamomolöïe geloi galeamelëla säla, dolöea hamomolöi made gadoi abodo hamola nilïma olemolö gabula nabi. ");
INSERT INTO etr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Amala nabasebegi, Yesuea ilima säla obëgësalea, Dilia Godeïe mosö neebe gowe hä, haila fisimo. Amaseda, na segeyo ohodoagimu bu ulimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Amala säsebegi, Yu ilia säla obëgësalea, Wae! Go hamosaleada, gäheo i nabülasi biyidiaïe gafeia asi amoda. Amai, diada segeyo ohodoagimu ulimolölela nabi. ");
INSERT INTO etr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gaso, Yesuea Godeïe mosöla säi amoda, hïle domalo amo helësëla amala säi. ");
INSERT INTO etr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hobeala, e bauiala nowesebegi, ïe bëgëla aulo amolia bu helësëla obëgësalea, ea ado dafidi säi amo helësëi. Amala helësëlahilä, Godeïe ado säla negei dibe amoge, ado Yesuea säi amoge, dofä säi gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu e Yalusaleme ami nea, Baagila Asi Segeyo amoïe helësëla molö molö gedosolo segeyo amo gala, ea dolöea hamomolöi made gadoi hamose amoli bealahilä, udia dolö yafiea ïe ëigi asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amala negei gaso, Yesuea udia dolö sulubadela dawadigi neebe amea, ilima asigi bogia gala made nelo. ");
INSERT INTO etr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Udia dolöïe iso asigi dawadigi neebe ameada, eda dawa oboba made, amase, afädëa ema ebedada gowe gadoimelëla säla ïmolöi mademelë. ");
INSERT INTO etr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Felesi dolö afädë Yu ilile busa nelo, amoïe ëida Nigudimusi. ");
INSERT INTO etr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","E Yesu neebea gasigi maalahilä, ema sähalea, Säla Olelelo-o, nilïa dida säla olelelo Godea fisiga weila helësësamelë. Mida, Gode e dolö afädëbalä made nea, ea dolöea hamomolöi made gadoi dia hamosego gadola hamomolöi mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Amala säsebegi, Yesuea ema säla obëgësalea, Na dima dofä gelola sähago. Dolö afädë e bu elö made neegela ägüseda, Godea Beaha Maadela Sigi Neebe amo ea made bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Amala säsebegi, Nigudimusia ema nabahalea, Dolö fädäi amoda abilia neegela ägümolödu. Amai emeïe isogi nogila digaseda, emea bu elö neegela ägümolöilela nabi. ");
INSERT INTO etr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Amalebe, Yesuea säla obëgësalea, Na dima dofä gelola sähago. Amai afädë ödäeage, Gesamiage, made neegela ägüi neebe amoda, Godea Beaha Maadela Sigi Neebea ami dofä made nogila digamolömelë. ");
INSERT INTO etr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Afädë e domaloea neegela ägüse amoda, domalomu neamelë. Amase, Gesamia neegela ägüse amoda, gesami neamelë. ");
INSERT INTO etr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na dima sähalea, Dilida hä, bu elö neegela ägümolö dialeala säla ï amogi, dia fudugimabu. ");
INSERT INTO etr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Foda hï hamea aulomelë. Gobamu nabelo gaso, abododila maala abododi awähadu, amoda dia dawa mademelë. Amai Gesamia neegela ägüi nefolalebe amoli sulubadelada, amo gadoi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Amala säsebegi, Nigudimusia ema nabahalea, Dia säsebegoda, abeahäladula nabi. ");
INSERT INTO etr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Amala nabasebegi, Yesuea ema säla obëgësalea, Dida Isilale ilile säla olelelo nebego gaso, na säsebeweda made helësësebele. ");
INSERT INTO etr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na dima dofä gelola sähago. Nelebo nilïa dawadigi amoge, amase, beaha maadei amoge, dilima säla ïahawe gaso, ado nilïa säla ïasebe amoda, dilia dofä säsebela helësëla made nebego. ");
INSERT INTO etr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na dilima nelebo nagadaia dibe amogi neawela säla ïaha gaso, asigi afädë made negese goeada, amai Hebeniïe nelegei dibe amogi neawela säseda, dilia abilia asigi afädë negemolödu. ");
INSERT INTO etr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Afädë nagadaiawila Hebeni fedaida maade. Hebenila Dolöïe Malö nagadaiawi digai amomu Hebeni fedaimelë. ");
INSERT INTO etr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Siiba, Mosesea sege nafadeia udia dolö aligilo made dibea ami nea, nuba iigi baala gauia adogoi amo gadola, Dolöïe Malö amoge amo gadola wäla gauia adogomolö dialea. ");
INSERT INTO etr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mida, udia dolö sulubadelaea ema asigi afädë negese amoliada, namolöi namolö gaula namiäiaïe. ");
INSERT INTO etr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Godea udia dolö sege sulubadelagi nefolalebe amoli boba hamolahilä, ïe malö afädëfalï nelo amo ï. Ïe malöma asigi afädë negei nefolalebe amoli, made baagola, namolöi namolö amo neala gaumäiaïe ïmelë. ");
INSERT INTO etr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Godea ïe malö amoda udia dolöbalä gudimolöïe fisiga wei made. Udia dolö sege sulubadelagi nefolalebe amoli damula mosäia fisiga weimelë. ");
INSERT INTO etr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Godea ïe malöma asigi afädë negei nefolalebe amolibaläda gudila asiala hamoila made säimelë. Ema asigi afädë made negei nefolalebe amolibaläda gudila asiala hamoila säimelë. Mida, Godeïe malö afädëfalï amoïe ëigi asigi afädë made negei amea amaimelë. ");
INSERT INTO etr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Asiala hamoila säi amoda gomalä. Yo digalo nagadaiawi digai nebegi gaso, udia dolöea mala nafademu hamolo amea, gasimi sagalomu boba hamosalea, yo digaloda boba hamoi made nelo. ");
INSERT INTO etr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Udia dolö mala nafade hamolo amoli sulubadelaeada, ilile mala nafade hamoi amo ulufadigiloea, yo digalobalä habobalahilä, ilida yo digalo neebea ami mulo mademelë. ");
INSERT INTO etr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amai gaso, mala dofä hamolo neebe amolia hamosebe amoda, Godeïe geloigila hamosamelëla yo digaloea olemäialahilä, ilida yo digalomadi maala aligilomelëla Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hobeala, Yesula ïe bëgëla aulo amolali, hä, Yudia segea moholö afiai. Afiala ilibalä salele odoa ami nea, ea udia dolö ödägi gesa nelo. ");
INSERT INTO etr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Amase, Salimi gaamu ga madela Ainono segea ami, ödä yafie dilo ameage, amase, udia dolö yafie ödägi gemäia mafui ameage, Yonea ili ödägi gesa nelo. ");
INSERT INTO etr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Amoda Yone e, aso, galabaia negela made nelo amo gaalu, amala hamosa nelo. ");
INSERT INTO etr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Amaha nea, Yoneïe bëgëla aulo amolia, nigime hëla mala negei dibe amo helësëla, Yu dolö afädëbalä gëgësa dilo. ");
INSERT INTO etr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Amala gëgësa dilolahilä, ili Yone neebea afialahilä ema sähalea, Säla Olelelo-o, dolö afädë dibalä Yodona dëgëla alömodi nebegi, dia sähalea, Dolö amoda gowemelëla säi ameada, udia dolö ödägi gesa nea. Amala hamosebegi, udia dolö sulubadela e neebeamu awäha neamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Amala säla ïasebegi, Yonea säla obëgësalea, Afädëa Hebenila nelebo ema ïase amomu neala gaumolöimelë. ");
INSERT INTO etr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na dafidi dilima sähalea, Afädë Memelei amoda ne mademelë. E hobea misiäia, nedale fisiga weila säsebegi, dilia nabi amoda säla ïmolöi galeamelë. ");
INSERT INTO etr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Amaimo, dolö afädëa udia neaseda, udia amoda dolö amoïe udia filo. Dolö esama ebalä ga madela nelo amea, udia goaea ado säsebe amo nabalahilä, edefademalä obeägïlo. Amo gadola obeägïlo nema nobasebe ameada, na obeägïsa neawe. ");
INSERT INTO etr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Neda holöfalïla, eda ilibiala edemolö dialea. ");
INSERT INTO etr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Afädë gadogola digai neebe amoda, sulubadelaïe edefade nea. Afädë nagadaiala misi neebe ameada, nagadaiala maala nagadaia mala amomu sälo nea. Afädë Hebenila digai neebe amoda, sulubadelaïe edefade neamelë. ");
INSERT INTO etr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ea melï amoge, nabi amoge, udia dolöma säla ïaha nea gaso, afädëa ea säsebe amo made nii neamelë. ");
INSERT INTO etr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ea säi amo nii neebe amea, Gode eada dofä sälo neamelëla ulufalomelë. ");
INSERT INTO etr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Amoïe mida, Godea gëla made, ïe Gesami ïlo amea, afädë ea fisiga idai ameada, Godeïe ado amo sälo nea. ");
INSERT INTO etr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eedoea ïe Malö amo boba hamolahilä, nelebo hulu sulubadela ïe naabogi gausisa maadei. ");
INSERT INTO etr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Malö amoma asigi afädë negei neebe ameada, namolöi namolö amo gaula nea. Malö amea ado säsebe amo made nabala, auaula fofolëlo neebe ameada, namolö amo made bimolömelë. Amobaläda, Godeïe mihalälo amo diamolöi diamolömelëla Yonea säi. ");
INSERT INTO etr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yonea ïe bëgëla aulo namiäia udia dolö ödägi gesa nelo amoli holöfalïlahilä, Yesuea yafie gesa neamelëla odoaea säi amo Felesi dolö amolia nabi. ");
INSERT INTO etr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesueada afädë made gei. Gaso, ïe bëgëla aulo amoliamu amala gesa nelo. ");
INSERT INTO etr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Amo nabimelëla säi amo Yesuea nabalahilä, e Yudia dïgïla Galili obëgëi. ");
INSERT INTO etr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galili moholöda, Disiligi Sameliamadi awäla aulo negei. ");
INSERT INTO etr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Amalebe e awäla, Samelia ilile gaamu afädëgi besela galai. Gaamu amoïe ëida Sigala sälo. Siga gaamu amoda siiba Yeigabaea ïe malö Yosebegali sege ïa ami ga madela dilo. ");
INSERT INTO etr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Segea amida siiba Yeigabaea ödä dögöi afädë dilo. Yesu e awäha nea emo hëhela, ödä dögöi amo ga madela ami hele sulo. Amoda eso mogogi amai. ");
INSERT INTO etr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Amala sebegi, Samelia udia afädë ödä usimolö maaha nebegi, Yesuea ema sähalea, Ne ödä molö gabu. Osala ïmola säi. ");
INSERT INTO etr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Amoda ïe bëgëla aulo amoli, gaamugi molö nea afiaibua amai. ");
INSERT INTO etr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Amala säsebegi, Samelia udia amea ema säla obëgësalea, Dida Yu dolö. Neda Samelia udiamelë. Dia ödä ïmo ne nahadula säsebegoda, abilia sähala säi. Udia amea amala säi amoïe mida, Yu iliada Samelia ilibalä gedola made aligilo. ");
INSERT INTO etr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Amala säsebegi, Yesuea udia amoma säla obëgësalea, Dia Godeïe galu amoge, amase, dolö dima ne ödä ïmo nahadula säsebegoge, dawa galebeda, dia ema namolöi namolö ödä ïmola säsegi, ea digali namolöi namolö ödä amo ïalabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Amala säsebegi, udia amea ema säla obëgësalea, Dafidilo-o, dida ödä i maade goda, ödä dögöi goweda ga ga gidogofalï dibe amo, dia namolöi namolö ödäda abidi usimolö. ");
INSERT INTO etr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ödä dögöi oselo goweda, nilïle mäu Yeigabaea nilïgali ï. Amase, hï eege, ïe malölalige, ïe sugua gaoge, sugua sibige, sulubadelada ödä dögöi gowegimu naha nelo amo, amai diada Yeigaba baagilela nabi. ");
INSERT INTO etr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Amala nabasebegi, Yesuea ema säla obëgësalea, Udia dolö sulubadela ödä gowegi naha neebe amolida bu halämolö. ");
INSERT INTO etr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gaso, afädëa ödä na ïmolö amo nasebe amoda, bu elö made halämolö. Ödä na ema ïmolö amo gü dusula besela galahamu neëgi, eda namolöi namolö gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amala säsebegi, udia amea Yesuma sähalea, Dafidilo-o, hobea ne ödä made halämolöïege, ödä dögöi gowegi bu elö made osa moholöïege, dia ödä go negali ïmola säi. ");
INSERT INTO etr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Amalebe Yesuea ema sähalea, Dia dïe dolödale dafidi bea awälahilä, haligila wi misialola säi. ");
INSERT INTO etr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Amala säsebegi, udia amea säla obëgësalea, Neda dolö maadela säi. Amalebe Yesuea ema sähalea, Dia di dolö maadela säi amoda mogola säimelë. ");
INSERT INTO etr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dafidi dïe dolö bia sulo. Amase, dolö afädëbalä di walio sebegoda, dihïle dolö made. Dolö maadela säsebegoda, dofä säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Amala säsebegi, udia amea ema säla obëgësalea, Dafidilo-o, na walio helësësa, dida bea sälo afädë gabumelë. ");
INSERT INTO etr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nilïle mäu iliada segebi wedaia Godeïe ëi gauia adalo. Gaso, Yu udia dolö diliada Yalusaleme amimu gauia adamolö dialeala sälomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Amalebe, Yesuea ema sähalea, Udia-o, na ado säsebewe dia nimalo. Segeyo afädë besela galasegi, dilia segebidaiawi neamuge, amase, Yalusaleme neamuge, Naadoïe ëi made gauia adamolömelë. ");
INSERT INTO etr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samelia diliada nelebo dawa made amoïe ëi gauia adalo. Gaso, nilïada nelebo dawa amoïe ëi gauia adalomelë. Mida, damula auloda Yu fii ilimadila mulomelë. ");
INSERT INTO etr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Godeïe ëi gauia adalofalï amoliada ilile gesamia Naadoïe ëi dofä gauia adamolömelë. Amala hamomolö segeyo besela galasegi hamomolö amo hä, besela galai dialea. Naadoea ïe ëi gauia adaloda amoli gadoi hamesa neamelë. ");
INSERT INTO etr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gode hï eda gesami nea. Ïe ëi gauia adalo amolia ilile gesamia Naadoïe ëi dofä gauia adamolö dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Amala säsebegi, udia amea Yesuma sähalea, Mesaea moholö amoda na helësësamelë. Ema Gelesolage sälo amo. E maaseda, ea nelebo sulubadela awala säla ïmolöla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Amala säsebegi, Yesuea ema säla obëgësalea, Walio dibalä adosa neebeweda, neda amo neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Amala säha nebegi, ïe bëgëla aulo amoli obëgëla mofiahamelebe, Yesu e udiabalä adosa neebe amo bealahilä, ili fudugi. Fudugilahilä, dia edo hogosalage, amase, edoïe udia gobalä adosa nelolage made säi. ");
INSERT INTO etr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Amalebe, udia amea ödä i amo ami dïgïla, e bu gaamugi obëgëlahilä, udia dolö amolima sähalea, ");
INSERT INTO etr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Dolö afädë neebe amea nelebo na hamoi amo sulubadela säla ïaha maadei amo, bea mofiamo. Eda Gelesoledula säi. ");
INSERT INTO etr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Amala säsebegi, ili gaamugi amila Yesu neebea afiai. ");
INSERT INTO etr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Udia amo asibua, ïe bëgëla aulo amolia Yesuma sähalea, Säla Olelelo-o, di hä molö muöla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amala säsebegi, ea ilima säla obëgësalea, Na molö molö galebe amoda, dilia dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Amala säsebegi, ïe bëgëla aulo amolia hilidomu didiähalea, Amai afädëa egali molö gaula maala ïledula didiäi. ");
INSERT INTO etr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Amala didiäsebegi, Yesuea ilima sähalea, Nïe molöda ne misialala sälo amea hamesebe amo gadola bëgëla, ïe hamoi amo hamola wagamolö amomelë. ");
INSERT INTO etr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dilia sähaleada, Aube biyidia nelolahilä, molö nelo segeyo amo besela galamolö gabula sälo madele. Gaso, nabuö. Na dilima sähago. Dilia hä, sagai dibeadi hedabola sidawewela bimo. Molö amolida mumului hä, nimolöi gabuwe. ");
INSERT INTO etr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Walioda, failoea bidi neahawe. Walioda, ea namolöi namolöïe molö faisa nea. Mida, afädëa hawa fëfësa neebe amoge, elöea faisa neebe amoge, ele helegela gedola nea obeägïmäiamelë. ");
INSERT INTO etr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ado goda dofämelë. Afädëa sagasegi, elöea molö amo faila nelomelë. ");
INSERT INTO etr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Dilia dafidi sagaia made ami, na dilima molö nea mosalaimelë. Odoa ilia häuala sagai dibea ami, dilia ilia hamoi amoïe molö niimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samelia udia amea säse amo nabalahilä, gaamugi ami fii yafiea Yesuma asigi afädë negei. Amoïe mida, udia amea na nelebo hamoi amo sulubadela säla ïaha maadeimelëla säi amogi. ");
INSERT INTO etr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Amalebe, Samelia ili Yesu neebea ami maalahilä, e ilibalä neadula säi. Amasebegi, segea ami e segeyo äudä nelo. ");
INSERT INTO etr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Amalebe, udia dolö odoa yafieage ïe ado nabala asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ilia udia amoma sähalea, Nilïa dia säse nabi ameamu asigi afädë negesa mademelë. Nihïlï ïe ado amo nabala helësësaleada, dolö goweda dofä nagadaia udia dolö neebe amolile damula aulo gabula helësësa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu e segeyo äudä Samelia ilibalä nelolahilä, sege amo dïgïla Disiligi Galili asi. ");
INSERT INTO etr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Dafidi Yesu hï sähalea, Bea sälo neebe amoda hïle segeafalï ëi maade neala säi. ");
INSERT INTO etr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","E awäla Galili besela galasebegi, Galili udia dolö ilia e säla olela gausiai. Mida, ilige dafidi Yalusaleme awäla, Segeyo Edefade amoïe molö molö gedosolo amo gala, ea nelebo hamose melï amogi. ");
INSERT INTO etr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu e Disiligi Galiliïe gaamu Gaina ami dafidi ödäfalï neala wani ödä hamoia ami bu awäla besela galai. Segeyo amo galada, giniïe gusigusiïe efege Gabaniama gaamugi ami oloi dilo. ");
INSERT INTO etr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dolö amea nabelebe, Yesu e Yudia dïgïla Galili misi neala säi amo nabi. Amalebe, ïe malö oloi amo baagomolöfalï dibe amea, e Yesu neebea awälahilä sähalea, Nïe malö wahimäia di Gabaniama awähadula säi. ");
INSERT INTO etr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Amala säsebegi, Yesuea ema sähalea, Dolöea hamomolöi made gadoige, hïdo elöige hamose amo made bealada, dofä dilia asigi afädë negelo made gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Amala säsebegi, gusigusi amea ema sähalea, Dafidilo-o, nïe malö baagoloea, awähadula säi. ");
INSERT INTO etr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Amalebe, Yesuea ema sähalea, Di mosalo. Dïe malöda hä, wahi saleamelëla säi. Dolö amea Yesuea ado säsebe amo dofä gabula helësëla e hä, asi. ");
INSERT INTO etr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dolö amo made besela galala awäha nebegi, ïe hamoi hamolasilo amolia maala, idiafa gausiala digalahilä sähalea, Dïe malöda hä wahi saleamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Amala säsebegi, ea ilima nabahalea, Aoa nowëgi wahisiola nabi. Amalebe ilia säla obëgësalea, Aiyo eso si agegi olo amo hä, damuimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Amalebe, eedoea helësësaleada, aiyo aoa amogimu Yesuea ema dïe malöda wahi saleamelëla säi amo gadola, wahi gabula helësëi. Amalebe, eege, e sosogo amoli sulubadelaeage, asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Amoda Yesu e Yudiala Galili maala nea, ea dolöea hamomolöi made gadoi bu agedu hamoida amo. ");
INSERT INTO etr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hobeala, Yu ilile segeyo edefade afädëgi gedolo amo gadola, Yalusaleme gedosebea ami Yesu eege asi. ");
INSERT INTO etr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yalusaleme amida yala edefade amoïe idi afädëda Sugua Sibiïe idila sälo dibe amo ga madela amida, ödä nudugu afädë dilo. Ödä nudugu amoda Hibulu adoeada Bedesedala sälo. Amo amalelada holöbö mosö gadoiïe hadai bia dilo. ");
INSERT INTO etr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Amolidaiada, udia dolö oloi yafie difolalo, si golaige, emo nafadeige, fii sige. ");
INSERT INTO etr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hadai amodaiada dolö afädë dilo. Dolö amo oloi dialeamu gäheo i nabülasi ohodoaïe odoai gödölasi asi dilo. ");
INSERT INTO etr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuea dolö oloi dibe amo beahamelebe, e siibafalï amo wälasi dilo gabula helësëlahilä, ema nabahalea, Di wahimäia hamesebelela nabi. ");
INSERT INTO etr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Amala nabasebegi, oloi amea säla obëgësalea, Dafidilo-o, ödä bebedägïsebea ami ne ugila negela, ödägi gelasimolö dolö madesalea. Nihïdo geleä fifilïla awäha neëgi, odoa iliada ne baagila ilidale digafulomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Amala säi amo nabalahilä, Yesuea ema sähalea, Di nowelahilä, dïe fëogo gaula mosalola säi. ");
INSERT INTO etr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Amala säi amole, dolö oloi amo wahisebegi, ïe fëo amo hï neala gaula asi. Dolö wahi amoda, segeyo Sabada gafegi wahi. ");
INSERT INTO etr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Amai gabugi, Yu ilia dolö wahilasi amoma sähalea, Walio Sabada segeyo gafego. Mala säla negei amea dia fëogo gaula mosabiola säi dialeala säi. ");
INSERT INTO etr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Amala säsebegi, ea säla obëgësalea, Dolö ne wahilasilo amea dïe fëogo gaula mosalola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Amala säsebegi, ilia ema nabahalea, Dolö nowëa dïe fëogo gaula mosalasiola nabi. ");
INSERT INTO etr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dolö wahi amea nowëa e wahilasidula dawa made nelo. Amoïe mida, udia dolö yafie gegedoi dibea ami, Yesu e asi amea amai. ");
INSERT INTO etr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hobeala, Yesuea Godeïe mosöa ami beahamelebe, dolö amo neebe bealahilä ema sähalea, Nabuö. Walio di hä, wahi gomelë. Dia nafade bu elö made hamomalo. Oböla, yöi elö dia dafidi gausiai amo baagila awäla dima besela galaloeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Amalebe, dolö amo awälahilä, Yu amolima sähalea, Ne wahilasi amoda Yesuea gabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuea Sabada segeyo gafegi amala hamolo gabugi, Yu ilia e sëlasisa nelo. ");
INSERT INTO etr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Amasebegi, Yesuea ilima säla obëgësalea, Nïe Naadoea hamoi hahamolamu maaha nelo amo gadola, nage walio hamosa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Amala säi amo nabalahilä, Yu amolia Yesu e nufulö gelola helësëi. Amoïe mida, Yesuea segeyo Sabada gafeïe mala damulo amogimu made. Nïe Naadoda Godela säi ameada, e hï Gode gadoi hamosebela helësëlahilä, ilia e nufulö helësësa nelo. ");
INSERT INTO etr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Amala helësësa dibegi, Yesuea ilima säla obëgësalea, Na dilima dofä gelola sähago. Malöea hïdo asigiamu nelebo afädë hamomolöi mademelë. Eedoea hamose amo bealahilä, Malöeage amomu hamomolömelë. Mida, Eedoea nelebo sulubadela hamosebe amo gadola, Malöeage amo gadola wäla hamosamelë. ");
INSERT INTO etr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eedoea ïe Malö boba hamolahilä, ea hamosebe amo sulubadela Malöma olesa. Dili sulubadela fudugimäia, hamoi geloi hïdo elöi walio hamosebe melï amo gadoi made, edefademalä hamomäia ea ïe Malöma olemolömelë. ");
INSERT INTO etr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Eedoeada udia dolö baagoi amoli nowela ifosilahilä, namolö ïlo amo gadola, Malöeage amo gadola wäla namolö ïmolö helësëse amogali ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Amase, Eedo hïda udia dolöea hamosebe amoïeda made mogemolömelë. Sulubadela ïe Malöeamu mogemäia ifosimelë. ");
INSERT INTO etr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Amala ifosi amoïe mida, udia dolö sulubadelaea Eedoïe ëi gauia adalo amo gadola, ïe Malö amoïe ëige gauia adamäia ifosi nea. Afädëa Malö amoïe ëi made gauia adalo neebe ameada, Eedoea Malö misialala sälo amoïe ëige made gauia adalo nea. ");
INSERT INTO etr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na dilima dofä gelola sähago. Afädëa na ado säsebe amo nabala, ne misialala sälo amoma asigi afädë negei neebe amea namolöi namolö gaula neëgi, ea hamoi amoïeda made mogemolömelë. Eda dafidi baagomolömadi nelo amo, walioda e namolöi namolömadi dëgëla aligi nea. ");
INSERT INTO etr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na dilima dofä gelola sähago. Segeyo afädë besela galamolö amoda hä, walio besela galai dialeamelë. Segeyo amogi, udia dolö baagoi difolalebe amolia Godeïe Malö amoïe ado nabulömelë. Nabase amolida, hä, namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Eedo hï ema namolö dibe amo gadola, Malömage namolö diamiäia ea geloi ï. ");
INSERT INTO etr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Amase, eda Dolöïe Malö neebe amea, Eedoea udia dolöea hamosebe amoïe mogemäiada, ema geloi ï. ");
INSERT INTO etr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na ado säsebewegida, dilia fudugimabio. Segeyo afädë besela galamolö amo, besela galasolo amo galada, udia dolö baui dibe amoli sulubadelaea Malö amoïe ado nabala, ");
INSERT INTO etr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bauia amila nowela galaha maademolömelë. Udia dolö mala hedabi hamosa nefolalo amolida, namolöi namolöïe nowela galamolömelë. Amase, udia dolö nafade hamosa nefolalo amolida, ilibalä gudilahilä ilima asiala hamoila sämolöïe nowela galamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesuea aso, sähamu neamu sähalea, Na nihïdo asigiamu nelebo afädë hamomolöi mademelë. Ado na nabelo amo gadolamu mogelomelë. Na mogelo amoda mogola hamolomelë. Mida, na nihïle hamelo amo fisila, ne misialala sälo amea hamelo amo gadola mogelomelë. ");
INSERT INTO etr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na gomalä hamolomelëlage, amase, ne gowe gadoi neamelëlage säha galebeda, amoda dofä made säsebela sämolö dialea. ");
INSERT INTO etr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Be, nelebo na hamosebe amo, afädëa gomalä hamosamelëla säla ïaha nea. Na ea säsebe amoda dofä sähala helësësamelë. ");
INSERT INTO etr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Dilia Yonema ado naba mosäia dolö fisiga gasebegi, Yonea dolö amolima ado dofä amoïe ulufala säla ï. ");
INSERT INTO etr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Na helësësaleada, dolöfäea ado ulufala säla ïase amoda, na ado säsebeweïe gelolasimolöi madela helësësamelë. Gasoda, dili sigi obëgëmäia, na dilima amala sähawe. ");
INSERT INTO etr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yone eda gele wai gadoi nea, ea gele wala yo digaha nelo. Dilia segeyo ede madegi ïe yo digalo neebe amo beahalea, obeägïsa nelomelë. ");
INSERT INTO etr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yoneada ne dilima holöfalï oleimelë. Nïe Naado hï gelolasisa neëgi, hamoi hamosa maademäia ï amo hamosa neebe ameada, edefadeda ne amea olesamelë. Amo bealahilä, nïe Naadoea ne misialala säsebegi misi gabula helësëmolö dialea. ");
INSERT INTO etr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naado ne misialala sälo amohïda dofä ne neebe amo gadoi ulufala sälo nea. Dilia ïe adoge dofä nabelo made, ïe odagige melëlo made, amase, ");
INSERT INTO etr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ïe ado malage dilile iso asigigi made dibego. Mida, ea misialala säsebegi misi amoma asigi afädë made negei nefolalebe goea. ");
INSERT INTO etr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dilia Godeïe bebagi ado säla dëdëla negei dibe amogi namolöi namolö beagolemolöila helësëlahilä, nidesamu aligilomelë. Be, ado säla dëdëla negei dibe ameada, ne dilima ulufala säla ïlo ");
INSERT INTO etr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","gaso, dihili namolöi namolö nimolöïe ne neebea moholö habosebego. ");
INSERT INTO etr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nada dolöfäea nïe ëi gauia adamäiala helësëla säha made ");
INSERT INTO etr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","gaso, dilile iso asigigi dibe amoda na dawadigi nea. Godeïe boba hamolo amo dilima maade gabula helësësa neamelë. ");
INSERT INTO etr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Neda Naadoïe ëigi misi neebewegida, dilia ne säla olela made gausiaimelë. Amai gaso, dolö elö hïle ëigi maaseda, dilia e säla olela gausiamolömelë. ");
INSERT INTO etr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gode afädëfalï neebe amea dilile ëi gauia adamäiala aligila madeda, dihilimu dihilile ëi gauia adadaha aligilo nebego. Amalamu hamolo neada, dilia asigi afädë abeahäla negemolöi gabu. ");
INSERT INTO etr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na Naadoïe siigi nea, dilia hamosebegoïe asiala hamoila sämolö gabula helësëmabio. Dihili Mosese e sisiläfülo amea, dilia asiala gomalä hamosa nelomelëla Naadoma säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Diliada Moseseïe ado nabala asigi afädë negei galebeda, amai nemage asigi afädë negelabio. Mida, ado ea dëdëla negei dibe amoda nïe säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ea säla dëdëla negei dibe amoda dofä gabula made helësëi nefolalebegoeada, amai nïe ado säsebeweda dofä gabula abeahäla helësëmolödula säi. ");
INSERT INTO etr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hobeala, Yesu e Galili oeabo amo dëgëla alömodi asi. Galili oeabo amoïe ëi elöda Dabeliasa. ");
INSERT INTO etr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Udia dolö yafie gegedola, e awäsebe amo gadola bëgëla afiai. Mida, ea dolöea hamomolöi made gadoi hamola, udia dolö oloi difolalo amoli wahisebe melï amogi. ");
INSERT INTO etr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesula ïe bëgëla aulo amolali segebidaia ami fedafula sefolalo. ");
INSERT INTO etr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Segeyo amo galada, Baagila Asi Segeyo amo besela galamolö dilo. Segeyo edefade amoda Yu ilile gedola molö nülo segeyo dilo. ");
INSERT INTO etr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Amala sefolalea, Yesuea busa fädägägïa adogola beahaleamelebe, udia dolö yafie e sebea ami mofiasebe amo bealahilä, ea Filibima nabahalea, Mofiasebe gowe ili molö muäia abidi bidia nimolödula nabi. ");
INSERT INTO etr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Eada gomalä hamomolöla dawadigi nea gaso, ea Filibi fedogola nabi. ");
INSERT INTO etr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Amala nabasebegi, Filibia ema säla obëgësalea, Muni gina hädali äudäea molö bidia neaseda, udia dolö sulubadelaea holöfalï holöfalïla molöi made gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesu bëgëla aulo Saimono Fidaïe edoo Äduluea Yesuma sähalea, ");
INSERT INTO etr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Malö maalïbu neebe gowea eladi gadoi balia beledi hamoi biage, amase, seme äudäge ägülea gaso, udia dolö yafie gegedoi welibalä dofea made gabula säi. ");
INSERT INTO etr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Amala säsebegi, Yesuea sähalea, Udia dolö fifigimalamalola säi. Sege amogida giisi hedabi yafie dilo. Udia dolö amoli amodaia fifigisa maadei. Dolömu nidelada dausini bia gadoi sefolalo. ");
INSERT INTO etr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sefolalebegi, Yesuea beledi amo neala gaula nea, Godema nesegelahilä, udia dolö sefolalebe amoligali sogomalai. Seme äudä amoge amo gadolamu hamosebegi, ilia helësëi amo gadola mai. ");
INSERT INTO etr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ili sulubadela dofea gaalula nasebegi, ea ïe bëgëla aulo amolima sähalea, Fea digai amo sofäloea, sulubadela neala gegedola negemalola säi. ");
INSERT INTO etr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ilia neala gegedola negei amo, beledi bia amea naala fea digai amo adu giwilasi salala nobai. ");
INSERT INTO etr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Udia dolö amolia Yesuea dolöea hamomolöi made gadoi hamosebe amo bealahilä, säla didigahalea, Bea sälo nagadaiawi moholömelëla säha dilo amoda dofä go gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuea ilia e gini namiäiaïe e gaula fëdömolö gabula helësëlahilä, ea sege amo dïgïla hïdofalï segebidaia ami bu obëgëla asi. ");
INSERT INTO etr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Deadi eso digase gaalu, ïe bëgëla aulo amoli oeaba daala aligilahilä, ");
INSERT INTO etr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ödä duugi fila Gabaniama moholö asi. Awäha dibegi, Yesu e ili sebea ami made maala nebegimu, hä, gasimi sagai. ");
INSERT INTO etr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Amase amo gaalu, fo gelola guula maalahilä, ödä aidagula fedai. ");
INSERT INTO etr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ilia ödä adelo amea ödä adada awäha nea, gilomida bia gafeia gadoi baagise amo gaalu, Yesu e ödädabodo maala ödä du amo ga madela maaha neebe melï. Amo bealahilä, ili edefademalä bedäi. ");
INSERT INTO etr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amala bedäsebegi, ea ilima sähalea, Weda nemelë. Bedämabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Amala säsebegi, ilia e dudaia ami misiäia nabeledelä hamose amo gaalu, du amoda hä, waliomu sege ili moholöia ami besela galai neebe melï. ");
INSERT INTO etr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Amo aiyo amogi, ödä dëgëla alömodi adidi amolia helësësalea, aiyo ödä du afädëmu dilo amogida ïe bëgëla aulo amoli fila afiase amogi, Yesu eda fila made awäla ili hilidomu fila afiaila helësësa dilo. ");
INSERT INTO etr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Amala helësësa dibegi, ödä du odoa Dabeliasa gaamuala, Dafidilo Geloia nesegesebegi, udia dolö molö maia ami ga madela maala negei. ");
INSERT INTO etr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Udia dolö gegedoi amolia Yesuge ïe bëgëla aulo amolige, ami maade, awäha maadei amo bealahilä, ödä du amoligi fifigila Yesu hogola Gabaniama afiai. ");
INSERT INTO etr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Udia dolö amoli afiala ödä dëgëla alömodi Yesu beagolelahilä, ema nabahalea, Säla Olelelo-o, dida wi abola misila nabi. ");
INSERT INTO etr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Amala nabasebegi, Yesuea ilima säla obëgësalea, Na dilima dofä gelola sähago. Ne hogola mofiaigoda, na dolöea hamomolöi made gadoi hamoi amo bealahilä, ne hogola mofiai mademelë. Dilia beledi amo dofea naala gaalui amoïemu, ne hogola mofiai gabumelë. ");
INSERT INTO etr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sïgälo molö amo nimolöïe hamoi hamosa namiabio. Diamolöi diamolö molö amoïe hamoi hamosa namialo. Molö amoda namolöi namolö ïlo molö. Dolöïe Malö amea diligali molö amo ïmolömelë. Naado Godea e amala namiäia memelela ifosi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Amala säsebegi, ilia ema nabahalea, Nilïa Godeïe hamoi amo hamomolöïe edo hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Amala nabasebegi, Yesuea ilima säla obëgësalea, Godeïe hamoi amoda gomalämelë. Ea misialala säsebegi misi amoma asigi afädë negemäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Amala säsebegi, ilia ema säla obëgësalea, Dia dolöea hamomolöi made gadoi hamose amo bealahilä, nilïa dima asigi afädë negedeläïe, dia edo hamomolö. Diada hamoi abodo gadoi hamomolö gabu. ");
INSERT INTO etr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nilïle mäula iliada sege nafadeia udia dolö aligilo made dibea ami nea, mena naha nelo. Amala hamoi amoïe ado säla dëdëla negei dibe amoda gomalä. Eada iligali muäia selesaiala beledi ïla säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Amala säsebegi, Yesuea ilima säla obëgësalea, Na dilima dofä gelola sähago. Selesaiala beledi diligali ï amoda, Mosesea ï mademelë. Nïe Naadoea selesaiala beledifalï amo diligali ïlo neamelë. ");
INSERT INTO etr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Selesaiala digai neebe amea udia dolö nagadaiawi nefolalebewe iligali namolö amo ïaha neebe amoda, Godeïe beledifalïda amomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Amala säsebegi, ilia ema sähalea, Dafidilo-o, dia beledigo nilïgali ïahamu namialola säi. ");
INSERT INTO etr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Amala säsebegi, Yesuea ilima säla obëgësalea, Namolöïe beledida nemelë. Ne neebea maaha neebe amolida sïdëa dofä made baagomolö. Nema asigi afädë negesa neebe amolida, ödä bu elö dofä made halämolömelë. ");
INSERT INTO etr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amaimo, na dilima säi amo gadola, dilia hä, ne melï gaso, oböla nema asigi afädë made negela nebego. ");
INSERT INTO etr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nïe Naadoea udia dolö sulubadela nema ïase amolida nema moholömelë. Ne neebea mafuse amoligida, afädë na dofä made nesila digimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mida, ne selesaiala misi amoda, nihï hamese amo gadola hamomolö misi made. Ne misialala sälo amea hamese amo gadola hamomolöïe misimelë. ");
INSERT INTO etr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne misialala sälo amea, na hamomäia hamesa neebe amoda gowe. Nema ï amoligi afädë fisila made, aligila wagamolö segeyo besela galasolo amo gala, sulubadela nowelasisa maademäia hamesa neamelë. ");
INSERT INTO etr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nïe Naadoea hamesa neebe amoda gowe. Udia dolö sulubadelaea Malö siia bealahilä, ema asigi afädë negei nefolalebe amoliada namolöi namolö neala gausa maademäia hamesa nea. Aligila wagamolö segeyo besela galasolo amo gala, nada udia dolö amoli nowelasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuea säi amo nabalahilä, Yu dolö ilia habobalahilä hilidomu didiäha difolalo. Mida, beledi selesaiala digai amoda ne neawela säi amogi. ");
INSERT INTO etr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ilia sähalea, Goweda Yosebeïe malö Yesu madele. Ïe eme eedoleda nilïa dawadigi amo. Oböla, ea sähalea, Selesaiala digaila säi amoda abeahäladula säla didiäha difolalo. ");
INSERT INTO etr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Amala säla didiäha difolalebegi, Yesuea ilima sähalea, Dilia habobalahilä, dihilido didiäha dibegoda gafisimo. ");
INSERT INTO etr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nïe Naado ne misialala sälo amea, afädë nemadi sigi made maaseda, hïdomuda ne neebea moholöi mademelë. Naadoea ne neebea sigi maase amoda, aligila wagamolö segeyo besela galasolo amo gala, na nowela ifosimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bea sälo amolile bebagi säla dëdëla negesalea, Godea ili sulubadelama säla olelemolömelëla säla dëdëla negei. Naadoea säla olelesebe amo nabalahilä, e dawadigila helësësebe amolida, sulubadela hä ne neebea maahamelë. ");
INSERT INTO etr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Afädëa Naado melïmelëla säha made. Naado melïda afädëfalï e Gode neebeala digai neebe ameamu hïdo, Naado melï nea. ");
INSERT INTO etr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na dilima dofä gelola sähago. Nema asigi afädë negei nefolalebe amoliada namolöi namolö gaula nea. ");
INSERT INTO etr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Namolöïe beledida nemelë. ");
INSERT INTO etr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dilile diadolalia sege nafade udia dolö aligisia made ami nea, mena naha nelo amolida baagosa maadei. ");
INSERT INTO etr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gasoda, beledi selesaiala digasebe amoda wi dialea. Beledi amo nase amolida made baagomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Namolöïe beledi selesaiala digai amoda nihïnemelë. Beledi amo afädëa naseda, eda namolöi namolö. Beledi amoda nihïle domalomelë. Sege föi sulubadelagi nefolalebe amolia namolö gausa maademäia, na nïe domalo ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Amala säi amo nabalahilä, Yu dolö amolia hilidomu gëgëla didiähalea, Dolö gowea ïe domalo amo nilïa muäia ïmolömelëla säha neebe goweda, abilia ïmolöïedula didiäha difolalo. ");
INSERT INTO etr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Amala didiäha difolalebegi, Yesuea ilima sähalea, Na dilima dofä gelola sähago. Dolöïe Malö amoïe domaloge healege made naseda, namolö amoda dili isogi maademelë. ");
INSERT INTO etr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nïe domaloge healege naha neebe amoda, namolöi namolö gaula nea. Amoda aligila wagamolö segeyo besela galasolo amo gala, na e nowelasimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mida, nïe domalo amoda molö dofäfalïmelë. Amase, nïe heale amoda ödä dofäfalïmelë. ");
INSERT INTO etr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Amase, nïe domaloge healege naha neebe amoda nïe isogi nea, amase, nege ïe isogi nea. ");
INSERT INTO etr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Naado namolöi neebe amea ne misialala säi. E namolöi neebe amea, nege namolöi neawe. Amo gadolamu, ne naha neebe amoge, ne namolöi neebe amea eege namolöi namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Goda beledi selesaiala digai. Dilile diadolalia mena naha difolalolahilä baagoi amo gadoi made, beledi gowe afädëa naseda, eda namolöi namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ea säi amoda, Gabaniama gedolo mosöa ami nea, säla olelesolo amo gala amala säi. ");
INSERT INTO etr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Amala säi amo nabalahilä, e bëgëla nawialo yafiea sähalea, Ado ea säsebe goweda yöi gabu. Nowëa nabulöidula säha difolalo. ");
INSERT INTO etr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","E bëgëla nawialo amolia ea säi amoïe habobalahilä, hilidomu didiäha difolalebe amo Yesuea asigia dawadigila nea, ilima sähalea, Na ado säi amea dili neala habobalasisiole. ");
INSERT INTO etr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Dolöïe Malö amo dafidi neloa ami fedase beaseda, abilia helësëmolö gabu. ");
INSERT INTO etr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godeïe Gesamia udia dolögali namolö ïlo. Domaloda galone mademelë. Ado na dilima säla ïase amoda gesamile, namolöi namolölemelë. ");
INSERT INTO etr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amai, dili odoaea asigi afädë made negela nebegola säi. Yesueada ema asigi afädë made negesebe amolige, e hololömolö amoge, mi gäwilafalï dawadigi nelo. Amala nea, ado amo amala säi. ");
INSERT INTO etr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Amala sälahilä sähalea, Mi amo helësëla na dilima sähalea, Nïe Naadoea afädë ne neebea misiäiala made helësëlasiseda, eda moholöi mademelëla dafidi säla ï amomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Segeyo amila nofela, e bëgëla nawialo yafiea e bëgëla made awäla, bahïla obëgësa maadei. ");
INSERT INTO etr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Amala hamosebegi, Yesuea giwilasi amolima nabahalea, Dilige bahïla äuduläla helësësalela nabi. ");
INSERT INTO etr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Amala nabasebegi, Saimono Fidaea säla obëgësalea, Dafidilo-o, nilï nowëma moholö. Namolöi namolö amoïe adoda dima dialea. ");
INSERT INTO etr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dida mogoi hedabifalï, Gode neebeala misi neebe amo helësëlahilä, nilïa asigi afädë negei neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Amala säsebegi, Yesuea ilima säla obëgësalea, Nada dili giwilasi memelei madele. Amai gaso, diligi afädëda mugabe busa neebemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Eada Saimono Isagaliadaïe malö Yudasa helësëla amala säi. Mida, Yudasa eda giwilasi amoligi nelo amea hobeala e hololölo amo. ");
INSERT INTO etr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hobeala, Yu ilia e nufidedelä hamosebegi, Yesu e Yudiamadi nawela made, Galilimadimu nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yu ilile segeyo edefade idia dilo mosö gadoi uligi molö nülo amo ga made dibegi, ");
INSERT INTO etr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesuïe edoolalia ema sähalea, Dia hamoi hamosa nebego, di bëgëla maasebe amolia bimäia, segewe dïgïla Yudia mosalo. ");
INSERT INTO etr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Afädëa ea hamosebe amo sulubadelaea dawadigimäiala asigiseda, musügä negela hamolo made, ulufala hamolomelë. Dia hamoi amo hamosa galëda, sege sulubadelagi nefolalebe amolima olela hamomolö mosöla säi. ");
INSERT INTO etr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ïe edoola iliage ema asigi afädë made negesalea, amala säha nelo. ");
INSERT INTO etr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Amala säsebegi, Yesuea ilima sähalea, Segeyo sulubadelada, hä, dilile segeyo dialea. Nïe segeyoda, aso, made besela galaimelë. ");
INSERT INTO etr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Udia dolö sege sulubadelagi nefolalebe amoliada, dilima bimolö habobamolöi mademelë. Be, na ilima nafade hamosa neebela säla ïahamu neebewegida, ili sulubadelaea nema bimolö habobaha nebegomelë. ");
INSERT INTO etr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dilida segeyo edefade amoïe molö molö afiamo. Nïe segeyoda, aso, made besela galai gabugi, neda saleamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Amala sälahilä, e made awäla, Galili ami nelo. ");
INSERT INTO etr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesuïe edoolali segeyo edefade amoïe molö molö afiasebegi, Yesu eege, udia dolöea e melëloealahilä, musügä hobeala asi. ");
INSERT INTO etr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Segeyo edefade gedosolo amo gala, Yu dolö amolia e hogosalea, dolö amoda abidi neadula naba hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Udia dolö gegedoi amoligi yafiea sëdäwala säla didigaha dilo. Odoaea e hedabimelëla säla digi, amase, odoaea sähaleada, Amala made. Eada udia dolö dahila neaha neala säla digisa dilo. ");
INSERT INTO etr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ili sulubadelaeada, Yu dolö amolibalä bedähalea, ulufadigila ea gomalä hamolomelëla made sälo nelo. ");
INSERT INTO etr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Idia Dilo Mosö Segeyo amoïe segeyo odoa baagilahilä mogogi nebegi, Yesu e Godeïe mosöa ami awälahilä, säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Amala olelesa neebe amo bealahilä, Yu dolö amoli fudugilahilä sähalea, Dolö gowe sugulu made hamoi amea, dawa hïdo elöiweda abeahäla dawa niidula säi. ");
INSERT INTO etr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Amala säsebegi, Yesuea ilima säla obëgësalea, Mala säla olelesa neebeweda, nïe mademelë. Ne misialala sälo amomadila säla olelesa neawe. ");
INSERT INTO etr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Afädëa Godea hamesebe amo gadola hamomolöila helësëseda, na säla olelesa neebewe, Godeïe helësëlogi nea olelesa nealedu, ma nihïle helësëlogi nea olelesa nealedula amohï bimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Afädëa hïle helësëloeamu säla olelesa neebe ameada, hïle ëi gauia adala säla olelelo nea. Amai gaso, e misialala sälo amoïe ëi gauia adamäialahilä, eada ado dofä sälo nea. Emada wäfalï sälo afädë maade neamelë. ");
INSERT INTO etr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Siiba, Ado säla negei amoda Mosesea diligali ï madele. Amai gaso, diligi afädëa gaula mogoloda maade gabu. Mi edoïe oböla ne nufulöïe hamosa dialeala nabi. ");
INSERT INTO etr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Amala nabasebegi, udia dolö gegedoi amolia säla obëgësalea, Dida mugabe fedai nebego. Di nowëa nufulö hamosa neebela säi. ");
INSERT INTO etr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Amala sälebegi, Yesuea ilima säla obëgësalea, Na hamoi afädë hamoi amogi, dili fudugisa dialeamelë. ");
INSERT INTO etr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Amaha gaso, gafodo damulo mala Mosesea hamomalaila helësëla, Sabada gafegi dilia dilile malölali gafodo damulomelë. Gafodo damulo mala amoda, dofä Mosesea negei made. Amoda mi gäwilafalï dilile mäulalia siibafalï mi gäwimelë. ");
INSERT INTO etr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosese nebegi Ado säla negei amoda, dofä made damumolöla sälahilä, dilia Sabada gafegi dolö malësäïe gafodo damusa aligilo amo gadola, nage, dolö afädëïe domalo hulu wahilasisa maadei amogi nema mihaläsebele. ");
INSERT INTO etr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Memalä siiamu beala mogelo amo fisimalo. Mala mogoi amo hogosa nea, hedabola mogesa namialola säi. ");
INSERT INTO etr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Amala säi amo nabalahilä, Yalusaleme udia dolö odoaea sähalea, Ilia nufidedelä hamosa neebe amoda, dolö go madele. ");
INSERT INTO etr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Amai gaso, bimo. Ea udia dolö sidaia mala olelesa neebe amogida, ilia ema ado afädë made säla neebe amoda, beaha aligilo amolia goweda dofä Afädë Memelei amola helësësa nealedu. ");
INSERT INTO etr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Amalada abidi. Afädë Memelei misi amo galebeda, e gowegila maasebela made helësëlabio gaso, dolö goda guwila misi neala nilïa dawadigi nea madelela säi. ");
INSERT INTO etr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Amala säsebegi, Yesuea Godeïe mosöa ami nea, udia dolö amolima säla olelesalea, gelola sähalea, Ä. Dilia nege, sege gowegi fii misilage, helësësa neago gaso, nihïle asigia misi mademelë. Ne misialala sälo amoda dofä sälo mi nea. Gasoda, dilia e dawa made nebego. ");
INSERT INTO etr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne emadila misi neebe ameage, amase, ne misialala säi ameage, na e dawadigi neala säi. ");
INSERT INTO etr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Amala säi amo nabalahilä, ilia e gaudelä hamoi gaso, ïe segeyo amo gala made amea, afädëa ïe naabogi made gaui. ");
INSERT INTO etr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Amai gaso, udia dolö gegedoi amoligi yafiea ema asigi afädë negei. Amolia sähalea, Afädë Memelei amo maalahilä, ea dolöea hamomolöi made gadoi hamomolö amoda, dolö gowea hamosa neebe amo gadola, baagila awäla hamomolölela säi. ");
INSERT INTO etr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Udia dolö gegedoi amolia Yesu helësëla sëdäwala säla didiäha dibe amo Felesi dolö amolia nabalahilä, iliage, gobela ïlo busa nefolalo amoliage, Godeïe mosö idihë nefolalo amolima e nafodola mosalola säi. ");
INSERT INTO etr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Amalebegi, Yesuea sähalea, Ne dilibalä segeyo obobamelë nelolahilä, ne misialala sälo neebea ami obëgëmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Obëgëseda, dilia ne hogomolö gaso, made beagolemolömelë. Sege ne moholöia amida, dili moholöi made nebegola säi. ");
INSERT INTO etr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Amala säi amo nabalahilä, Yu nefolalo amolia hilidomu didiähalea, Ne made beagolemolömelëla säha neebe goweda, eda abododi moholö nea sähadu. Nilï sosogo odoa Giligi sege elö elöla dibea ami afufui amoli neebea ami awälahilä, Giligi udia dolö amolima mala säla olelela moholö nea sähaledu. ");
INSERT INTO etr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ea sähalea, Dilia ne hogomolö gaso, made beagolemolömelëla säi amoge, amase, ne moholöia amida, dili moholöi made nebegola säi amoge, mida edo helësëla sähadula säi. ");
INSERT INTO etr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Idia Dilo Mosö Segeyo amo wagamolöïe segeyo edefadegi Yesuea nowela nea gelola sähalea, Afädë ödä haläi nea galëda, nema naa misialo. ");
INSERT INTO etr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nema asigi afädë negei neebe amolia bebagi säla dëdëla negei dibe amo gadola hamomolömelë. Ado säla dëdëla negei dibe amea sähalea, Ïe isogila namolöïe ödä amo bugagila awäha namolömelëla säla dëdëla negei dialeala säi ");
INSERT INTO etr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ea amo säi amoda udia dolö ema asigi afädë negei nefolalo amolima hobeala Gesami ïmolö amo helësëla amala säi. Yesu e yo hïdo elöi digalomadi gauia adogoi amo, aso, made gauia adogoi amea, Gesami made digala nebegi, amo gala amala säi. ");
INSERT INTO etr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ea ado säi amo nabalahilä, udia dolö gegedoi amoligi odoaea sähalea, Dolö goda dofä bea sälo amo gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Amase, odoaea sähaleada, Afädë Memelei amoda emelëla säi. Oböla odoaea sähaleada, Afädë Memelei amoda amai, Galilila made moholö madele. ");
INSERT INTO etr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Godeïe bebagi gomalä säi dialea. Afädë Memelei amoda, beaha aligilo Gini Debidiïe sosogogila moholömelë. Amase, gaamu Bedeleheme Debidi neloala moholömelëla säla dëdëla negei dialea madelela säi. ");
INSERT INTO etr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Udia dolö gegedoi nefolalo amolia Yesu helësëla moge mogela nefolalo. ");
INSERT INTO etr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Odoaea e gaudeläla helësëi gaso, iligi afädëa e made gaui. ");
INSERT INTO etr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Amasebegi, Godeïe mosö idihë aligilo amoli maala Felesi dolöge, gobela ïlo busage nefolalebea ami bu obëgëi. Obëgësebegi, ilia amolima nabahalea, E sigi made misigoda edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Amala nabasebegi, ilia säla obëgësalea, Siiba dolö afädëa ea säse amo gadola säloda maademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amala säi amo nabalahilä, Felesi dolö amolia ilima säla obëgësalea, Dilige ea neala golisebegi mofiaile. ");
INSERT INTO etr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nilï beaha aligilo busa afädëage, amase, Felesi dolö afädëage, ema asigi afädë negei neebe dilia melïle. ");
INSERT INTO etr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amai gaso, udia dolö amolia Mosese nebegi Ado säla negei amo hedabola helësëla made, ilia ema asigi afädë negesebegoda, Godea ili së ïmolö dialeala säila säi. ");
INSERT INTO etr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Amala säsebegi, Felesi dolö afädë Nigudimusi, dafidi Yesu neebea mulo amea, e sosogo amolima sähalea, ");
INSERT INTO etr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nilïle Ado säla negei dibe ameada, dafidi afädëa ado sähalea, Na gomalä hamoila säse amo nabalahilä, gudi mogelo amo, ïe ado made nabalada, gudi mogelolela nabi. ");
INSERT INTO etr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Amala nabasebegi, ilia ema säla obëgësalea, Dige Galilila misi neale. Bebagi säla dëdëla negei dibe amo hedabola nidela beaseda, bea sälo afädë Galilila moholömelëla säla dëdëla negei diëda, made bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Amala sälahilä, ili sulubadela dusula mosöa bahïla awäha maadei. ");
INSERT INTO etr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu eda Olibebidaia ami fedai. ");
INSERT INTO etr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yesu e hä, yosefalï obëgëla awäla Godeïe mosöa ami besela galala nebegi, udia dolö sulubadela e neebea ami mafula gegedoi. Amalebe, e ami fia idogola salea, ilima säla olelesa sulo. ");
INSERT INTO etr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mala dawadigi dolö amoliage, amase, Felesi dolö amoliage, udia dolö fii afädëa, dolö fa neaha nebegi beagolelahilä, ilia udia amo sigi misi. Sigi maalahilä, udia amo gegedoi amoli mogogi ifosilahilä, ");
INSERT INTO etr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesuma sähalea, Säla Olelelo-o, udia egowea, dolö fa neaha nebegi beagoleimelë. ");
INSERT INTO etr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ado säla negei dibe amogi Mosesea sähaleada, Egowe gadoi hamosebe amoda, igia nufudala baagomalola säi dialea. Amai diada, abilia sämolö gabula nabi. ");
INSERT INTO etr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ilia ea nafadela säimelëla sädeläïe, ea nafadela sämabelela nufigila nabaha dilo. Amalebe, Yesu e dosogägïla fia idogola salea, ïe naabo sögöea nagagi dëdësa sulo. ");
INSERT INTO etr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Amala bu eegela nabahamu nebegi, e noweia adogola nea ilima sähalea, Diligi afädë nafade made hamolo neebe ameadale igia udia go nidimalola säi. ");
INSERT INTO etr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Amala sälahilä, e dosogägïla fia idogola salea, naabo sögöea nagagi bu dëdësa sulo. ");
INSERT INTO etr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ado amala säi amo nabalahilä, dolö asigi fädäi dafidi nefolalo amolidale geleä afädë afädëla doadigila awäha maadeibua, hobeala malïsä nefolalo amolige geleä doadigila awäha maadei. Asibua, Yesu hïdo sulo, amase, udia amoge mogogi ifosia ami nelo. ");
INSERT INTO etr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Amalebe, Yesu e noweia adogola nea, udia amoma nabahalea, Udia-o, ilida hä, abilisio. Di së ïmolö dialeala säi amoligida afädë made gabulela nabi. ");
INSERT INTO etr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Amala nabasebegi, udia amea säla obëgësalea, Dafidilo-o, afädëge maade gabuwela säi. Amala säsebegi, Yesuea ema sähalea, Nage di së ïmolö dialeala säha mademelë. Mosalo. Segeyo walio neebewea nofela, dia nafade bu elö made hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesuea udia dolö amolima bu elö sähalea, Nihïneda sege föi sulubadelaïe yo digalo neawe. Afädëa ne bëgëla maasebe amoda, gasimi sagaido dofä made awäla, namolöïe yo digalo gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Amala säi amo nabalahilä, Felesi dolö amolia Yesuma sähalea, Dia hamosebego sulubadela dihïmu säla ulufadigisa neebe goeada, dia säsebe amo udia dolöea dofä gabula nabulöi made gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Amala säsebegi, Yesuea ilima säla obëgësalea, Na hamoi amo nihï säla ulufadigisa neëda, udia dolö na säse nabase amoliada dofä gabula nabulöimelë. Mida, neda guwila misi, hä, guwi moholö nealage, nihï dawadigi neamelë. Amai, ne misi amoge, ne obëgëmolö amoge, dilia dawa made nebego. ");
INSERT INTO etr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Diliada nagadaia dolöea mogelo amo gadola mogelomelë. Nada afädë made mogelomelë. ");
INSERT INTO etr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Afädëa hamosebe amo na mogeseda, udia dolö na säse nabase amoliada dofä gabula helësëmolöimelë. Mida, ne nihïdomu nea mademelë. Naado ne misialala sälo amo halïgïla neamelë. ");
INSERT INTO etr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dilile mala säla negei dibe amea sähaleada, Dolö elöea säi amo gadola, dolö elö ameage, amo gadola wäla säseda, elea säse amoda dofä gabula helësëmolö dialeamelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nïe malage, na hamolo amoge, nihïmu neala säla ulufadigisa neebewe gadola, Naado ne misialala sälo ameage, nïe säla ulufadigisa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Amala säi amo nabalahilä, Felesi dolö amolia ema nabahalea, Amai dïe Diadoda abidi neala nabi. Amala nabasebegi, Yesuea säla obëgësalea, Dilia nege dawa made, amase, Naadoge dawa made nebego. Ne dawa galebeda, Naadoge dilia dawadigilabiomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuea ado amo säha nelo amoda, Godeïe mosöamadi Godegali muni odala ïlo hogoli ga madela ami nea, amala säha nelo. Ïe segeyo aso, amo gala made amea, afädëa e made gaui. ");
INSERT INTO etr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuea ilima sähamu neamu sähalea, Neda moholö. Dilia ne hogomolömelë. Amase, dilia nafade hamoi amo diëgi wäla dili baagomolömelë. Sege ne moholö awäsebea amida, dili moholöi mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Amala säi amo nabalahilä, Yu ilia sähalea, Ne awäsebea amida, dili moholöi mademelëla säi amogi, e hïmu nufudala baagomolöledula säi. ");
INSERT INTO etr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Amala säha dibegi, Yesuea ilima sähalea, Dilida gidogola. Neda gadogolamelë. Dilida nagadaiala. Neda nagadaiala mademelë. ");
INSERT INTO etr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amoïe mida na dilima sähalea, Dilia nafade hamoi amo diëgi wäla dili baagomolömelëla säi amomelë. Ne Nelo Neebe amo dofäla made helësëseda, dihili nafade hamoi amo diëgi wäla dili baagosa maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Amala säi amo nabalahilä, ilia ema nabahalea, Dida nowë neala nabi. Amala nabasebegi, Yesuea säla obëgësalea, Neda gowe neamelëla dilima dafidi säla ï amomelë. ");
INSERT INTO etr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dilia hamosa nebegoda, gowe hamoimelëla na säla ïmolöge mogemolöge yafie gaulea. Gaso, ne misialala sälo amoda dofä neebe amea, sämola säse amo gadola nagadaiawi nefolalebe amolima säla ïaha neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Amala säi amoda, ea ïe Eedoïe säla ïasebelada ilia made dawadigi nelo. ");
INSERT INTO etr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dawa made nebegi, Yesuea ilima bu sähalea, Hobeala dilia Dolöïe Malö amo gauia adasolo amo gala dilia helësësalea, Ne Nelo amo Nea gabulage, amase, nïe asigiamu nelebo afädë made hamola, Naadoea nema olelei amo gadola, na ado sälo gabulage dawadigimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne misialala sälo amo nebalä nea. Nada ea hamesebe amo gadola hamosamu aligilo ameada, ea ne dïgïla aulo made neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ea amala säi amo nabalahilä, udia dolö yafiea ema asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuea Yu dolöea ema asigi afädë negei nefolalo amolima sähalea, Dilia na ado säsebewe nabala, bëgëla hamosa aligiseda, dilida dofä nïe bëgëla aulo nea, ");
INSERT INTO etr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","amase, dilia ado dofä amo dawadigisegi, ado dofä ameada dili fisigäha maademolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Amalebe, ilia ema säla obëgësalea, Nilïda Abalahamaïe yaualali aliligi misi amogi neebe amo. Nilïada afädëïe galabaia hamoi gadoi made hamolasilo nelo ameada, dia dili fisigäha maademolömelëla säi amoda abeahäladula nabi. ");
INSERT INTO etr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Amala nabasebegi, Yesuea ilima säla obëgësalea, Na dilima dofä gelola sähago. Udia dolö nafade hamolo neebe amoli sulubadelada, nafade hamoloïe galabaia hamoi gadoi hamolasilo nea. ");
INSERT INTO etr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Galabaia hamoi gadoi hamolasilo neebe amoda, mosöa namolöi namolö mademelë. Malöda namolöi namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Amai gabugi, Malöea dili fisigäseda, amoda dili dofä fisigäi namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Dilida Abalahamaïe yaua aliligi misi neebe amoda na dawa. Gaso, nïe adoda dilile isogi fu made ïala neada, oböla ne nufidedelä hamosa nebego. ");
INSERT INTO etr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne Naadobalä nea melï amoda säla ïlo. Amase, diliada dilile diadoea säse nabi amo gadola hamosa nebegola säi. ");
INSERT INTO etr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Amala säi amo nabalahilä, ilia ema säla obëgësalea, Nilïle naadoda Abalahamamelëla säi. Amala säsebegi, Yesuea ilima säla obëgësalea, Dili Abalahamaïe malö galebeda, Abalahamaea hamosa nelo amo gadola, diliage hamosa aligilabiomelë. ");
INSERT INTO etr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Godea nema ado säla ïasebe amo gadola na dilima ado dofä na nabi amo säla ïaha nebegida, oböla dilia ne walio nufidedelä hamosebego. Abalahamaeada amo gadola made hamoimelë. ");
INSERT INTO etr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Diliada dilile diadoea hamolo amo gadola hamosebegola säi. Amala säsebegi, ilia ema sähalea, Nemelalia fofalösa malö sogobaida nilï mademelë. Nilïle Naado afädëfalï neebe amoda Godemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Amala säsebegi, Yesuea ilima sähalea, Dilile diado dofä Gode e nea galebeda, dilia nebalä boba hamolabio. Mida, ne Gode e neebeala misi neawe. Neda nihï asigia misi made, ea ne misialala säimelë. ");
INSERT INTO etr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dilia na ado säsewe made helësëse goda, mi edoea. Amoda, na ado säse dilia nabulöi made neebe goeamelë. ");
INSERT INTO etr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dilida dilile diado mugabe busaïe malö nea. Ea hamese amo gadola, diliage amo gadola hamela hamosa nebego. Siiba, mi gäwia amila ea dolö nufudadigilo nelo. Amase, ema dofä sälo maade ameada, eda dofä sälomadi aligilo made nelo. Ea wäfalï säseda, ea hïle mala amo gadola wäla sälo. Eda wäfalï sälo nea, amase, wäfalï sälo neebe amoïe eedoge e neamelë. ");
INSERT INTO etr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amalebe, na dilima ado dofä amo säla ïaha nea gaso, dilia dofä gabula made helësësebego. ");
INSERT INTO etr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Diligi nowëa na nafade hamoi amo säla ulufamolöi gabu. Be, na ado dofä säla ïasewegi, dilia dofä gabula made asigi amoda mi edoea amai. ");
INSERT INTO etr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Udia dolö Godeïe nefolalebe amoliada, Godeïe ado nabelo nea. Dilida Godeïe made neebe ameada, dilia made nabasebegola säi. ");
INSERT INTO etr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yu ilia Yesuma säla obëgësalea, Nilïa dida Samelia dolölage, amase, dima mugabe fedai nealage sälo amoda dofä sälo madelela säi. ");
INSERT INTO etr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Amala säsebegi, Yesuea säla obëgësalea, Neda mugabe fedai nea mademelë. Nada Naadoïe ëi gauia adaha neebewegida, dilia ne gagadesa nebego. ");
INSERT INTO etr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na nihïle ëi gauia adamolöda made helësësamelë. Afädë neebe amea nïe ëi gauia adamolö helësëla, mogelo nea. ");
INSERT INTO etr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na dilima dofä gelola sähago. Afädëa na ado säsebe amo nabala bëgëla hamosa neebe ameada, baagomolöda dofä made bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Amo nabalahilä, Yu ilia ema sähalea, Di mugabe fedai neebe amoda nilïa hä, dawadigimelë. Abalahamage baagoi, amase, bea sälo amolige hä, baagosa maadei amo. Oböla, dia sähalea, Na ado säsebe amo nabala bëgëla hamosa neebe ameada, baagomolöda dofä made bimolömelëla säsio. ");
INSERT INTO etr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nilïle mäu Abalahama baagoi amo, dia e baagile. Amase, bea sälo nefolalo amolige baagosa maadei amo. Dia dihïda di nowëla asigisebela nabi. ");
INSERT INTO etr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Amala nabasebegi, Yesuea säla obëgësalea, Na nihïle ëi gauia adaha nea galebeda, nihïmu nïe ëi gauia adai amo memalä gadoi hamolabio goda. Naadoma dilia dilile Godela sälo ameada nïe ëi gauia adaha nebego ");
INSERT INTO etr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gaso, eda dilia dawa mademelë. Nada e dawadigi nea. Na e dawa mademelëla säha galebeda, nege dili wäfalï sälo nebego gadoi aligilabio. Na e dawadigilahilä, ea hamomola säse amo gadola hamosa neawe. ");
INSERT INTO etr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dilile diado Abalahamaeada ne moholö segeyo amo bimolöila helësëlahilä, obeägïla nelo. Amo besela galasebegi, obeägïla melïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Amala säi amo nabalahilä, Yu ilia ema sähalea, Dida gäheo i nabülasi bia made baagi nebego gabu. Amai Abalahamada dia melï nealela nabi. ");
INSERT INTO etr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Amala nabasebegi, Yesuea ilima sähalea, Na dilima dofä gelola sähago. Neda Abalahama maadeia Ne Nelo amo Neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Amala säi amo nabalahilä, ilia igi neala e nufulö hamosebegi gaso, Godeïe mosöamadila geleä musügä segea doadigila asi. ");
INSERT INTO etr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu e awäha nea beahamelebe, dolö afädë si golai neebe melï. Amoda neegela ägüsolo amo gala, emea si golai amo gadoi wäla ägüla misi sulo amo neebe melï. ");
INSERT INTO etr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Amo bealahilä, ïe bëgëla aulo amolia ema nabahalea, Säla Olelelo-o, dolö gowe nowëa nafade hamoia emea neegela ägüsolo amo gala si golai amola wäla neegela ägüidu. Hï nafade hamoialedu ma, eedole emelea nafade hamoialedula nabi. ");
INSERT INTO etr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Amala nabasebegi, Yesuea säla obëgësalea, Eedo emeage nafade made hamoi, amase, dolö go hïge nafade made hamoi. Goda Godeïe geloi ulufala olemäia hamoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Walio segeyo dibewegi, nilïa ne misialala sälo amoïe hamoi hamosa namolöla. Gasimi sagaloda hä, besela galasebe. Amo besela galaseda, afädëa hamoi hamomolöi mademelë. ");
INSERT INTO etr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne nagadaiawi neebewe gaaluda, sege föi sulubadelaïe yo digalo ne neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Amala sälahilä, ea nagadaia gofedela sadia idogolahilä, naga amobalä dädälahilä, dolö si golai amoïe sihidoa hëi. ");
INSERT INTO etr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Amalahilä, Yesuea dolö amoma sähalea, Di awälahilä Sailoama nudugu dibea ami hëmolö mosalola säi. Sailoamada, Hibulu ado. Amoïe mida, Mosaloi. Amala säi amo nabalahilä, dolö amo awäla, ödägi ami hëi. Hëlahilä hä, nelebo sulubadela fädäla bebea obëgëi. ");
INSERT INTO etr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amalebe, ebalä gedola aligilo amoliage, amase, dafidi ea muni ëdëgëse melëlo amoliage sähalea, Wae! Dolö goweda udia dolöma muni ïmola säha seë melëlo amo madelela säi. ");
INSERT INTO etr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Odoaea sähalea, Amo gabula säi. Amase, odoaeada, Ai. Goda amo gadoi elö gabula säha dibegi, dolö amo hï sähalea, Amoda nemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Amalebe, ilia hä ema nabahalea, Dïe si goda abeahäla fisigäila nabi. ");
INSERT INTO etr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Amala nabasebegi, ea säla obëgësalea, Dolö ëi Yesuea nagadaia gofedela sadia idogolahilä nagabalä dädäla, nïe sihidoa hëlahilä sähalea, Sailoama nudugu dibea ami awäla hëmolö mosalola säsio. Amala säsebegi, ne hä awäla hëlahilä, siia melïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Amala säsebegi, ilia ema nabahalea, Amai dolö amoda abidi neala nabi. Amala nabasebegi, ea säla obëgësalea, Na dawa mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Amalebe, dolö si golai nelo amo ilia Felesi dolö ili neebea ami sigi asi. ");
INSERT INTO etr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuea gofedela nagabalä dädäi amea, dolö amoïe sihidoa hësebegi, si fisigäi amoda, segeyo Sabada gafegi amai. ");
INSERT INTO etr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Felesi dolö amoliage ema bu nabahalea, Dia siia beasegoda abeahälala nabi. Amala nabasebegi, ea ilima säla obëgësalea, Ea gofedela nagabalä dädäi amo nïe sihidoa negesebegi, na ödägi hëlahilä, siia beahamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amala säi amo nabalahilä, Felesi dolö odoaea sähalea, Segeyo Sabada gafe dialeala made asigi goeada, dolö goda Godemadila misi made gabula säi. Amalebe, odoaea sähalea, Dolöea hamomolöi made gadoi amoli nafade hamoloea abeahäla hamomolöi gabula sälahilä, hilimu moge mogei nelo. ");
INSERT INTO etr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Amasebegi, ilia dolö si golai nelo amoma bu nabahalea, Ea dïe si fisigäi goeada, dia ïeda abilia sähala nabi. Amala nabasebegi, ea säla obëgësalea, Eda bea sälo afädë gabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Amala säsebegi gaso, dolö amoda dafidi si golai sulo amo, hä, siia beahamelëla säi amo, Yu ilia dofä gabula made helësëlahilä, dolö si fisigäi amoïe eedole emele misialola wei. ");
INSERT INTO etr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Maasebegi, ilia elema nabahalea, Alile malö si golai neegela ägüila säi amoda gole. Ea beasebegoda abilia beahadula nabi. ");
INSERT INTO etr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Amala nabasebegi, eedole emelea säla obëgësalea, Goda alïle malö amoge, amase, e si golai neegela ägüi amoge alïa dawa. ");
INSERT INTO etr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ea walio beaha neebe amo abeahäla beahadu. Amoge alïa dawa mademelë. Amase, nowëa ïe si fisigälasidu. Amoge alïa dawa mademelë. E malësä made ameada, hïma fädäla nabualo. Ea hï e hï fädäla sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Elea Yu dolö amolibalä bedälo amea amala säi. Mida, ilia ado säla negesalea, afädëa Yesu eda Afädë Memelei amo gabiola säla ulufadigiseda, gedolo mosöa amila segea beselala fisimolömelëla säla negei. ");
INSERT INTO etr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Amala säla negei amogi, eedole emelea sähalea, Eda malësä made. Hïma nabualola säi. ");
INSERT INTO etr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yu dolö amolia dolö si golai nelo amo bu elö welahilä ema sähalea, Dia Godeïe ëi gauia adala, mogolafalï sämalo. Nilïada dolö goda nafade hamolo neala helësësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Amala säsebegi, ea säla obëgësalea, Eda nafade hamolo nealedu. Na dawa made. Gaso, na afädë helësësebe amoda gowe. Ne si golai nelo amoda, na walio siia beahamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Amala säsebegi, ilia ema bu elö nabahalea, Ea dima abilia hamosio. Dïe si amo abeahäla fisigälasisiola nabi. ");
INSERT INTO etr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Amala nabasebegi, ea ilima säla obëgësalea, Na dilima dafidi säla ï amo made nabile. Edoïe nalï nabahamu nea. Dilige ïe bëgëla aulo namolöïe sähalela säi. ");
INSERT INTO etr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Amala säsebegi, ilia e gagadela sähalea, Dolö amoïe bëgëla auloda di nebego. Nilïda Moseseïe bëgëla aulo neamelë. ");
INSERT INTO etr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Godea Mosesema ado säla ï amoda nilïa dawadigisa maadei nea. Gaso, dolö goda abidila misi neadu, nilïa dawa made neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Amala säsebegi, dolö amea ilima säla obëgësalea, Neme, ne bedäi! Dilia ado elöla säsegogi. Ea ne si golai fisigälasi amogi, dilia e abidila misidula asusugai nebego. ");
INSERT INTO etr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nafade hamoloïe adoda Godea nabelo made neebe amo nilïa dawadigi nea. Gasoda, afädëa ïe ëi gauia adaha nea, Godea hamese amo gadola bëgëla hamosa neebe amoïe adoda, ea nabelo nea. ");
INSERT INTO etr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dafidi nelebo afädë maadeia amila, dolö afädë emea si golai neegela ägüi amo dolö elöea egomalä si fisigälasimelëla säida, dofä made nabimelë. ");
INSERT INTO etr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dolö go Gode neebeala misi made galebeda, ea nelebo afädë hamomolöi mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amala säsebegi, ilia ema säla obëgësalea, Dida diemea nafadeia nea di neegela ägüsebegi, nafadebalä ëdëla aligi nebego gabu. Di gadoiada nilï olelemolö helësësebelela nabi. Amala nabalahilä, ilia e gedolo mosöa amila segea beselala fisi. ");
INSERT INTO etr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ilia e amala beselala fisimelëla säi amo nabalahilä, Yesuea dolö amo beagolelahilä, ema nabahalea, Diada Dolöïe Malö amoma asigi afädë negeilela nabi. ");
INSERT INTO etr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Amala nabasebegi, ea säla obëgësalea, Dafidilo-o, Dolöïe Malö amoda nowë. Na ema asigi afädë negedeläla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Amala säsebegi, Yesuea ema sähalea, Diada e melïmelë. Amase, amohïda walio dibalä adosa nebegomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Amala säsebegi, ea sähalea, Dafidilo-o, na dima asigi afädë negesagola sälahilä, Yesuïe emo mia gumusulahilä, ïe ëi gauia adaha sulo. ");
INSERT INTO etr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuea sähalea, nada mogelasimolöïe nagadaiawi misi neawemelë. Dolöea siia made beaha nefolalebe amolia bimäiage, beaha nefolalebe amolida, oböla, si golamäiage, ne misi neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amala säi amo, Felesi dolö odoa ebalä nefolalo amolia nabalahilä, ema nabahalea, Nilïge hä, si golai neebelela nabi. ");
INSERT INTO etr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Amala nabasebegi, Yesuea ilima sähalea, Dili si golai nea galebeda, nafade dilima made dialealabio. Gaso, dilia sähalea, Nilïa siia beahamelëla sälo ameada, dilile nafadeda dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuea ado aso, sähamu neamu sähalea, Na dilima dofä gelola sähago. Dolö afädëa sugua sibiïe yala idi galogi dogala digala made, oböla yala dabiala fedalo neebe amoda, musügä awäla fa neloge, idiafa naabo gauia adogola fa neloge nea. ");
INSERT INTO etr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amalo gaso, yala idi galo dogala digalo neebe amoda, sugua sibi sigi aligiloda amomelë. ");
INSERT INTO etr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Idi galo idihë aligilo neebe amea, sigi aligilo misiäia idi galo doga negesisegi, sugua sibia sigi aligiloïe ado nabelo. Ea hïle sugua sibi hïdo hïdola ëi säla welahilä, hï sigi segea doadigila aulo. ");
INSERT INTO etr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ea hïle sugua sibi sulubadela segea sigi awälahilä, ilia e bëgëla misiäia, hï e dafidila aulomelë. Ïe sugua sibia ïe ado nabelo amea, e awäse amo gadola bëgëla aulo nea. ");
INSERT INTO etr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sugua sibi amolia dolö dawa made amoda dofä made bëgëla aulo. Dolö elöïe ado made dawa amea, ili ebalä fisäla aulomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuea ilima amala ado besula säsebegi gaso, ilia amoïe mi dawadigi made nelo. ");
INSERT INTO etr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Amala hamosebegi, Yesuea ilima bu sähalea, Na dilima dofä gelola sähago. Nihïneda sugua sibiïe idi galo neawe. ");
INSERT INTO etr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ne made maala dafidila misi amoli sulubadelada, musügä awäla fa neloge, idiafa naabo gauia adogola fa neloge misimelë. Misi gaso, amolile adoda sugua sibia made nabimelë. ");
INSERT INTO etr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nihïneda idi galo neawe. Ne mia maala nogila digase amoda damula moholö. Ea mumusogi digala digi segea doadigila fedala digisa nea, molö hedabi dibe amo beagolemolömelë. ");
INSERT INTO etr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Fa neloeada fa nimolöge, nufudadigimolöge, neala nafademolöge, amoïemu mulomelë. Neda ilia namolö gaumäiage, amase, namolö amo ilima nobamäiage misi neawemelë. ");
INSERT INTO etr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sugua sibi sigi aligilo hedabida nihïne neawe. Sugua sibi sigi aligilo hedabiada sugua sibi amoligali hïle namolö amo fisiga galomelë. ");
INSERT INTO etr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dolö hamoi hamola bidi nelo neebe amoda sugua sibi sigi aligiloge, eedoge made nea. Ilua ügülo maase beaseda, ea sugua sibi dïgïla fisäla asibua, ilua ügüloea sugua sibi nufudala balälelomelë. ");
INSERT INTO etr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Dolö amo fisäla aulo amoïe mida, eda bidi nelo nea, sugua sibi made helësëlo amea. ");
INSERT INTO etr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sugua sibi sigi aligilo hedabida nihïne neawe. Naadoea ne dawadigila, amase, nage Naado dawadigi amo gadola, sugua sibi nihïle nefolalebe amolida nihï dawadigi. Amase, sugua sibi nihïle nefolalebe amoliage ne dawadigi nea. Amala hamola nea, na sugua sibi nefolalebe amoligali nïe namolö fisiga gamolömelë. ");
INSERT INTO etr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yala goweïe isogi sugua sibi nefolalebe welimu made, nada sibi odoage galeamelë. Amolige na sigi moholö dialea. Iliage nïe ado nabala, sosogo afädëfalï hamola, sigi aligiloge afädëfalï namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Naadoea ne edefade boba hamosa neebe amoïe mida, na nïe namolö fisiga galahilä, bu nea obëgëmolö amogi. ");
INSERT INTO etr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nïe namolö amoda afädëa made neahamelë. Nihï fisiga gamolö hamei amo gadola fisiga gaha. Namolö fisiga gamolö amoïe geloige, bu nea obëgëmolö amoïe geloige, nihï gaulea. Naadoea nema amala hamomalola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ea amala säi amo nabalahilä, Yu ili bu äudäla mogela damula gogoi nelo. ");
INSERT INTO etr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ili dolö yafiea sähaleada, Eda mugabe fedai nea, gagaola säsebegoïe dilia nabasebegoda edoïe nabahala säi. ");
INSERT INTO etr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amala säsebegi gaso, odoaea sähalea, Ea ado säsebegoda mugabe fedaia sälo amo gadola made gabu. Amai mugabeada si golai nefolalebe amoli fisigälasimolöi gabulela säi. ");
INSERT INTO etr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Amo baagiada, segeyo edefade siiba Godegali mosö ï amo helësëla, amoïe Yalusaleme gegedolo segeyo dilo. Mugia i bäu giisalea gögï mulo segeyo amogi, ");
INSERT INTO etr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu eda Godeïe mosöa Solomonoïe hadaila sälo dibeadi amogi awäha nelo. ");
INSERT INTO etr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Awäha nebegi, Yu ili maala e amalela digilahilä ema nabahalea, Neda gowe neamelëla abola sämolö gabu. Dida Geleso nea galëda, nilïma ulufala mogola sämola säi. ");
INSERT INTO etr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Amala säsebegi, Yesuea ilima säla obëgësalea, Na dilima säla ï. Gaso, amo dilia dofä gabula helësëla made nebego. Na Naadoïe ëigi nea hamoi hamosa neebeweada, ne dilima olesa. ");
INSERT INTO etr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gaso, dilida nïe sugua sibi made ameada, dilia asigi afädë made negei nebego. ");
INSERT INTO etr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nïe sugua sibi nefolalebe amolia nïe ado nabelo. Na ili dawadigi neëgi, ilia ne bëgëla mulomelë. ");
INSERT INTO etr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na iligali namolöi namolö ïasegi, ili dofä made baagomolömelë. Ili nïe naaboea gaula neebe amoda afädëa fedemolöi made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Naadoea amolida nema ï. Nelebo sulubadela holöbö gidogolahilä, eda dofä dafidilo gelolamelë. Amaimo, Naadoïe naaboea gaula neebe amolida afädëa fedemolöi made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naado alïda afädëfalï neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Amala säi amo nabalahilä, Yu ilia e bu nufidedelä igi nii. ");
INSERT INTO etr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Amala neasebegi, Yesuea ilima nabahalea, Na hamoi hedabi yafie Naadomadila misi amolida dilima olei. Hamoi amoligi na abodo hamoi amoïe oböla ne nufidedelä hamosala nabi. ");
INSERT INTO etr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Amala nabasebegi, Yu ilia säla obëgësalea, Dia hedabi hamola nowei amogi mademelë. Di dolöfä nea oböla, di dihïmu Gode hamola, e gagadei amogi nilïa di igia nufidedelä hamoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Amala säsebegi, Yesuea ilima säla obëgësalea, Dilile mala säla negei dibe amogida, ado afädë dëdësalea, Nada dili godemelëla säila säla dëdëla negei dialea madele. ");
INSERT INTO etr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Siiba Godeïe adoda udia dolöma misi. Ea udia dolö amolima dili godemelëla säi galëda, amase, ado säla dëdëla negei amoda neadigimolöi made galëda, ");
INSERT INTO etr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","na ne Godeïe malö neawela säha neebe amea, dilia Naadoea afädë hïle nafolalahilä, nagadaiawi fisiga wei amoma, dia Gode gagadesebegola sähale. ");
INSERT INTO etr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na Naadoïe hamoi amo made hamosa neëda, dilia na ado säsebewe dofä gabula made helësëmalo. ");
INSERT INTO etr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gaso, ïe hamoi na hamosa neëda, dilia na ado säsebewe dofä gabula made helësësa galëda, na hamoi hamosewegi dofä gabula helësëmalo. Amala säsebe amoïe mida, ne Naadoma aligila, amase, Naadoge nema aligilalahilä neebe amo dilia dofä helësëmäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Amala säi amo nabalahilä, ilia e bu gaudelä hamosebegi, e fisäla doadigila asi. ");
INSERT INTO etr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Amalebe, Yesu e ödä Yodona dëgëla alömodi bu obëgëlahilä, sege dafidi Yonea udia dolö ödägi gesa neloa ami awäla nelo. ");
INSERT INTO etr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E ami awäla nebegi, udia dolö yafie e neebea ami mafulahilä sähalea, Yoneada dolöea hamomolöi made gadoi afädë made hamola nelo gaso, ea dolö goweïe säi amo sulubadelada dofä gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hä, ami yafiea ema asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dolö afädë Bedani gaamugi ami fii Elasalusi oloi dilo. Gaamu amoda Melile ïe esama Madalele sege dilo. ");
INSERT INTO etr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meli ameada Dafidilo Geloiïe emogi weli gafisigäi söga negelahilä, hïle busa hilïa hësa sulo, amoïe elefi Elasalusi oloi dilo. ");
INSERT INTO etr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Oloi dibegi, elefi äudä amolea Yesuma säsisalea, Dafidilo Geloi-e, dolö dia boba hamolo amoda, hä, oloi dialeamelëla säsi. ");
INSERT INTO etr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Amala säsi amo nabalahilä, Yesuea sähalea, Oloi goda, baagomolöïe oloi mademelë. Udia dolöea Godeïe geloi beala ïe ëi ilibia amo gauia adamäia oloi dialea. Ameada, Godeïe Malö amoïe ëige gauia adamäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesueada Madage, esamage, amase, Elasalusige, boba hamoi nelo. ");
INSERT INTO etr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Elasalusi oloi dialeamelëla säsi amo nabalahilä gaso, Yesu e segeyo äudä bu ya aligi. ");
INSERT INTO etr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ya aligilahilä, oböla hobeala ea ïe bëgëla aulo amolima sähalea, Nilï Disiligi Yudiamadi obëgëdila säi. ");
INSERT INTO etr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Amala säsebegi, ïe bëgëla aulo amolia säla obëgësalea, Säla Olelelo-o, Yu dolö ilia di hädamade igia nufulö hamoia ami bu äudulälela nabi. ");
INSERT INTO etr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Amalebe Yesuea ilima säla obëgësalea, Segeyo afädëgi esoea yo digaha neebe amoïeda aoa giwilasi dialea madele. Amai dolö yoba nawesa aligiseda, ea nagadaiaweïe yo digalo melï neebe ameada digalo mademelë. ");
INSERT INTO etr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Gaso, dolö amohïma yo digalo maade nea, gasigi nawesa aligiseda, digalomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuea amala sälahilä ilima hobeala sähalea, Nilïle damelë Elasalusi adi dialea. Ne awäla e didiigimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ea amala säi amo nabalahilä, bëgëla aulo amolia ema sähalea, Dafidilo Geloi-e, e adi dialea galëda, e oloi amo wahimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesueada e baagoi dibe amoïe säi gasoda, iliada e dofä adi dialeala säha gabula helësëi. ");
INSERT INTO etr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Amala säsebegi, Yesuea ilima fädäla sähalea, Elasalusida hä, baagoimelë. ");
INSERT INTO etr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dili helësëla, ne amo gala ebalä ami made nebegi baagoi amogi obeägïsawe. Mida, dilia asigi afädë negemäiaïe amai. Nilï hä, e dibea ami afiadila säi. ");
INSERT INTO etr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yesuea amala säi amo nabalahilä, Domasa, ïe ëi elö Didimusila sälo amea, bëgëla aulo odoa amolima sähalea, Nilïge ebalä baagomolö afiadila säi. ");
INSERT INTO etr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Amala sälahilä awäla, besela galamolö suägïla nea, Yesuea nabelebe, Elasalusi baula asi segeyo ohodoa asi, walioda biyidumelëla säse nabi. ");
INSERT INTO etr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yalusalemela Bedanida holöbö ga madela, gilomida ohodoa gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yu udia dolö yafiea Melile Madalele elefi baagoi amogi asigiisa sebe amobalä aofila sigi samolö asi. ");
INSERT INTO etr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Madaea Yesu maahamelëla säi amo nabalahilä, e idiafa gausiamolö asi. Gaso, Melida mosöa sulo. ");
INSERT INTO etr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Madaea hä, Yesuma sähalea, Dafidilo Geloi-e, di yawe nelo galebeda, nïe nalifi made baagolabio. ");
INSERT INTO etr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gaso, walioge dia Godema afädë ëdëgëseda, ea ïmolöla helësësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Amalebe, Yesuea ema säla obëgësalea, Dïe dialifi amoda hä, nowela galamolömelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Amalebe, Madaea ema säla obëgësalea, Ä, segeyo aligila wagasegi, baagoi amoli nowela galasolo amo gala, eege nowela galamolöla helësësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Amalebe, Yesuea ema säla obëgësalea, Nowelasimolöïe miige, amase, namolöïe miige ne neawe. Afädëa nema asigi afädë negei nea baagoseda, gamelä eda namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Amase, made baagoi sefolalebe amoli sulubadelaea nema asigi afädë negei amolida, dofä made baagomolömelë. Dia dofä säsebela helësësebelela nabi. ");
INSERT INTO etr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Amala nabasebegi, Madaea ema säla obëgësalea, Ä, Dafidilo Geloi-e. Dida Geleso, Godeïe malö nagadaiawi digamolömelëla säi amo gabugi, na asigi afädë negei neawela säi. ");
INSERT INTO etr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Amala sälahilä, Mada e obëgëla awäla esama Meli welahilä, geleä musügä gëhegi sähalea, Säla Olelelo amo hä, misi nea. Ea di misialaimelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Amala säi amo nabalahilä, Meli e fodolofalï nowela Yesu neebea ami asi. ");
INSERT INTO etr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu e gaamugi ami made besela galala, aso, Mada gausiaia amimu nelo. ");
INSERT INTO etr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yu ili mafula Melibalä mosöa ami aofila asigiisa sefolalo amolia Meli e fodolofalï nowela awäse amo bealahilä, elefi bauia ami dïila awäsebela helësëlahilä, ilige e bëgëla afiai. ");
INSERT INTO etr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meli e Yesu neebea ami awäla besela galala e bealahilä, ïe emo mia gumusula dia idogola ema sähalea, Dafidilo Geloi-e, di yawe nelo galebeda, nïe nalifi made baagolabiola säi. ");
INSERT INTO etr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Amala säsebegi, Meliage, Yu ebalä misi amoliage didigaosebe amo bealahilä, Yesuïe isogi edefademalä sogofalala säosäosa nelo. ");
INSERT INTO etr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Amala nelolahilä ea sähalea, Dilia e abidi baui dialeala nabi. Amala nabelebe ilia ema säla obëgësalea, Dafidilo, dia bimolö misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Amalebe afialahilä, Yesueage dïi. ");
INSERT INTO etr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Amala dïisebegi, Yu ilia sähalea, Ea Elasalusi edefade boba hamoi nelogo beasebelela säi. ");
INSERT INTO etr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amase, odoaea sähaleada, Dolö si golai nelo wahilo amea dolö gowe made baagomäia, hamomolöi made beala amailedula säi. ");
INSERT INTO etr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesuïe isogi bu elö edefademalä sogofalala säosäolahilä awäla, Elasalusi baui dibea ami besela galai. Baui amoda igi äbägi bausilahilä, igi edefademalä afädëa dofogai dilo. ");
INSERT INTO etr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesuea sähalea, Igia gaigo dogala bebugula nigia gamola säi. Amala säsebegi, baagoi amoïe elefi Madaea Yesuma sähalea, Dafidilo Geloi-e, e baui segeyo walio biyidu ameada, sïgä gäha moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Amala säsebegi, Yesuea ema sähalea, Dia asigi afädë negeseda, Godeïe geloi edefade amo bimolömelëla na dima dafidi säla ï madelela säi. ");
INSERT INTO etr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Amalebe, ilia igia idi gai dilo amo dogala bebugula negesisebegi, Yesuea sida adogola nea sähalea, Naado-o, na säi amo dia nabi amogi dima nesegesawe. ");
INSERT INTO etr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na ado säse amo dia nabahamu aligilola helësësa. Ado säi amoda udia dolö nefolalebe gowe ili helësëla säimelë. Ilia nabalahilä, dia ne dofä fisiga wei gabula helësëmäia säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Amala sälahilä, ea gelolafalï sähalea, Elasalusi, di segea doadigila misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Amala säsebegi, e baagoi dilo amo nowela maahalea, ïe naaboge emoge fagulo gadelaia neleegila, busage faguloea usulala bausi dilo amola wäla nowela doadigila fedai. Amasebegi, Yesuea ilima sähalea, E mosäia bausi fagulo goli fisigälasimola säi. ");
INSERT INTO etr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yu udia dolö yafie Meli sebea misi sefolalo amolia, Yesuea hamosebe amo bealahilä, ema asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Iligi odoa Felesi dolö neebea afialahilä, Yesuea hamoi amo säla ï. ");
INSERT INTO etr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Amalebe, Felesi dolöfulo gobela ïlo busafulo amolia Galïsolö dolö amoli mofiala gegedomalolahilä didiähalea, Dolö gowea hamomolöi made gadoi yafie hamosebeweïe, nilïa edo hamomolödu. ");
INSERT INTO etr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nilïa ea amala hamomäia guilasiseda, udia dolö sulubadelaea ema asigi afädë negesa maademolö gabu. Amala hamoseda, Olomo dolö ili maala, udia dolö nufudaha maadelahilä, nilïle gobela ïlo mosö amoge haila hësögudumolö gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amala sälahilä, iligi dolö afädë Gaiafasa gäheo i amogi gobela ïlo busa edefade nelo amea sähalea, Dilida dofä asigi maade gabu. ");
INSERT INTO etr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Asiala nilï sosogo neebe amo sulubadela nufideloeada, afädëa udia dolö baagomolö amo bedefala baagomolö dofeada amo gabu, dilia made helësësalela säi. ");
INSERT INTO etr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ado amoda Gaiafasaïe asigiamu made säi. Eda gäheo i amogi gobela ïlo busa edefade neada, Yesuea Yu udia dolö sulubadelaïe baagola bedefamolö amoïe bea säi. ");
INSERT INTO etr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesuea Yu ililemu baagomolöïe made. Godeïe malölali sege sulubadelagi fifi asi sefolalebe amoli neala gegedolasila, afädëfalï hamolasimäiage baagola bedefamolö amoïe bea säla, säla negei. ");
INSERT INTO etr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hä, segeyo amo gala mi gäwila, ilia Yesu nufulöïe idi hogola didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Amasebegi, Yesu e Yu ilile siigi ulufa made nowela, gaamugi amila awäla sege udia dolö aligilo made dibe amo ga madela, gaamu afädë Efalaimula sälo dibea ami, ïe bëgëla aulolali awäla nelo. ");
INSERT INTO etr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yu ilile Baagila Asi Segeyo amo besela galamolö dibegi, udia dolö sege elö elölagi nelo amoli sulubadela Yalusalememu afiai. Godeïe siigi nigime baai made namolöïe hamolo mala dilo amo hamomolöïe, Baagila Asi Segeyo made besela galala dibegi, afiai. ");
INSERT INTO etr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ili afialahilä, Yesu e hogosamu nelo. Godeïe mosöamadi ami nefolalea hilidomu naba hogosalea, Dilia edo helësësa. Eda molö nülo segeyo edefade gedosebeawi made moholöledula naba hogosa dilo. ");
INSERT INTO etr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Dafidi gobela ïlo busa nefolalo amoliage Felesi dolö nefolalo amoliage gelola sähalea, Afädëa Yesu neë beaseda, nihïlï nafodola moholöïe säla ïa misialola säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Segeyo gafeia negesilahilä, Baagila Asi Segeyo edefade amo hä, besela galamolö dibegi, Yesu e Bedani asi. Elasalusi, Yesuea baagoiala nowelasi amoda, Bedani gaamugi ami nelo. ");
INSERT INTO etr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ilia ami Yesu e obeägïlasimolöïe molö daiaha dilo. Madaeada molö mogesa nebegi, Elasalusi eda dolö Yesubalä molö naha sefolalo amolibalä sulo. ");
INSERT INTO etr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Amala sefolalebegi, Melia weli gafisigäi hïdo elöi muni edefadea nii ödä i hasegi usi dilo amo gaula maala, Yesuïe emodaia söga negelahilä, hïle busa hilïa hësa sulo. Weli amoda nadaeamu hamoi. Amala hamosebegi, weli gafisigä amea mosö amo negegi dilo. ");
INSERT INTO etr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amala hamosebegi, Yesuïe bëgëla aulo afädë, ïe ëida Yudasa Isagaliada, hobeala ea Yesu hololömolö amea sähalea, ");
INSERT INTO etr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Weli gafisigäi hedabi gowea muni giwi siliba hädali ohodoa gadoi nealahilä, busadäoi nefolalebe amoligali ïala made, abisigi waeasesadula säi. ");
INSERT INTO etr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Eada busadäoi nefolalebe amoli helësëla säi made. Eda fa nelo nea amala säi. Ilile muni salelo adu amo ägüla nawesalea, ilia muni negesebe amogi ea odoa fa somodala nelo. ");
INSERT INTO etr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Amala säi amo nabalahilä, Yesuea sähalea, Udia goea hamosebego hamomäia guilasimalo. Goda ea ne baagosegi baumolö amoïe hamosamelë. ");
INSERT INTO etr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Busadäoi nefolalebe amolida segeyo sulubadelagi dilibalä namolömelë. Be, neda segeyo sulubadelagi dilibalä namolö mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu e Bedani neala helësëlahilä, Yu ili yafie e neebea ami afiai. Ili afiai amoda, Yesumu helësëla made, Elasalusi e, Yesuea baagoiala nowelasi amoge bimolö afiai. ");
INSERT INTO etr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Amase, gobela ïlo busa nefolalo amolia didiähalea, Elasalusige nufidedelämelëla säla didiäi. ");
INSERT INTO etr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mida, Yesuea Elasalusima hamoi amo helësëla, Yu ili yafiea gobela ïlo busa amoli fisila awäla, oböla, Yesuma asigi afädë negei amogi. ");
INSERT INTO etr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Amo aiyo amogi, udia dolö yafie segeyo edefade amo bimolö Yalusaleme mafula gegedoi amolia Yesu e hä, Yalusaleme maahamelëla säi amo nabalahilä, ");
INSERT INTO etr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","waibo bäu gadoi damula gagaula e idiafa gausiamolö afiai. Gausiala digalahilä obeägïla uuala säsäla afiahalea, Agua. Nesege. Afädë Dafidilo Geloiïe ëigila maasebego, Isilaleïe Gini go, neala hedabolasimäia. Nilïa ïe ëi gauia adadi. Hosanala säsäla afiai. ");
INSERT INTO etr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu e sugua dögi üdïli afädë beagolelahilä, e amodaia fila misi. Amoïe Godeïe bebagi säla dëdëla negei dibe amoda gowe. ");
INSERT INTO etr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Saionoïe idiwi-e, dia bedämabu. Dïe gini hä, sugua dögi üdïlidaia fila maasebego bimalola säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Segeyo amo gala, ïe bëgëla aulo amolia amo hamoi amoïe mi fädäla helësëi made nelo. Gaso, hobeala Yesu e baagola nowelahilä, fedala ïe yo digalomadi sebegi, Godeïe bebagi hï eïe amala säla dëdëla negei dibe amoge, amase, ilia ema amo hamoi amoge, helësëla obëgëi. ");
INSERT INTO etr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dafidi Yesuea Elasalusi bauia amila welahilä, e baagoiala nowelasise melëlo amolia säla daidosamu nelo. ");
INSERT INTO etr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Udia dolö gegedoi amolia ea dolöea hamomolöi made gadoi hamoimelëla säi amo nabalahilä, e idiafa gausiamolö afiai. ");
INSERT INTO etr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amasebegi, Felesi ilia hilidomu didiähalea, Nilïa hamomolöi madego beasebele. Hä, udia dolöda sulubadela e bëgëla awäha maadesebego bimola säla didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Udia dolö ilia segeyo edefade amogi Godeïe ëi gauia adamolöïe Yalusaleme gegedoi amoligi Giligi odoa ilige maala sulo. ");
INSERT INTO etr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Amo gala Giligi ili Filibi neebea ami misi. Filibi eda Galiliïe gaamu Bedesaida ami fii dolö. Ilia ema sähalea, Dafidilo, nilïa Yesu melëdeläla säi. ");
INSERT INTO etr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Amala säsebegi, Filibi e awäla Äduluma säla ïalahilä, ele helegela awäla, Yesuma säla ï. ");
INSERT INTO etr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Amo säla ïasebegi, Yesuea ilima säla obëgësalea, Dolöïe Malö ëi sälo namolö amoda hä, besela galai gabuwe. ");
INSERT INTO etr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na dilima dofä gelola sähago. Widi gägä afädë nagadaia dufigila digala made baagoseda, gägä afädëfalïmu dië bimolömelë. Gaso, nagadaia dufigila digala baagoseda, amea gägä yafie negemolömelë. ");
INSERT INTO etr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Amaimo, afädëa hïle namolö amomu mi hamosa aligiseda, ïe namolö amo hogosa helemolömelë. Amase, afädëa nagadaiawi nea, ïe namolö amoma baagi ïala fisiseda, namolö amo gaula nea namolöi namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Amaimo, afädëa nïe hamoi hamolasilo nea galëda, ea ne bëgëla moholö dialea. Ne neebea ami nïe hamoi hamolasiloge namolömelë. Nïe hamoi hamolasiloda, Naadoea e ëi sälo namialamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesuea aso, sähamu neamu sähalea, Walio nïe iso asigigi yöia idogola säosäosebemelë. Amai na edo sämolödu. Na gomalä sädule. Naado-o, nelebo walio nema hamomolö amo dia neadigimalo. Ai, amala made gabu. Ne wi misi amoïe mida, amo gausiala digamäia misi nea. ");
INSERT INTO etr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Naado-o, dia dïe ëi edelasimalola säi. Yesuea amala säla wagaia gai amole, ado afädë Hebenila säia idogosalea, Na nïe ëi edelasimelë. Amase, amo gadola wäla bu edelasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Udia dolö amala säse nabelo ami nefolalo amolia sähalea, Gomoda sege gudusebegola säi. Amase, odoaea sähaleada, Selesaia fii afädëa ebalä adosebegola säi. ");
INSERT INTO etr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Amala säsebegi, Yesuea sähalea, Ado walio säi ameada, ne ugila negemolöïe säi mademelë. Amoda dili ugila negemolöïe säsio. ");
INSERT INTO etr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Walioda, Godea nagadaia udia dolö nefolalebe amoli gudila mogemolömelë. Ea aso, waliomu nagadaiaïe busa neebe amoge haila digimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ilia ne nagadaia nea gauia adogoseda, amo galada na udia dolö sulubadela nemadi dusugamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesuea ado amala säi amoda, ema gomalä hamosegi baagomolö gabula ulufala olela amala säi. ");
INSERT INTO etr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Amala säsebegi, udia dolö amolia ema säla obëgësalea, Nilïa Godeïe Ado säla negei dibe amogida gomalä säi nabelo. Gelesoda namolöimu namolömelëla säi nabi. Gaso, dia sähalea, Dolöïe Malö gauia adogomolö dialeala säi amoda abeahäladu. Amai Dolöïe Malöla säsebegoda nowëla nabi. ");
INSERT INTO etr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Amala nabasebegi, Yesuea ilima säla obëgësalea, Fu holöfalï dibewegida yo digalo e dilibalä namolömelë. Dili gasimi sagaloea dabeloeada, yo digalo neebewe gaalu nawesa namialo. Dolö gasimi sagaia nawelo neebe ameada, idi gowegi awähala helësëla made nawelo nea. ");
INSERT INTO etr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yo digaloïe malö namolöïe, yo digalo neebewegi wäla dilia yo digaloma asigi afädë negemalola säi. Yesuea ado amo säha maadelahilä, udia dolöea e melëloea musügä namolö asi. ");
INSERT INTO etr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuea ilile sidaia dolöea hamomolöi made gadoi yafie hamosa nelo gaso, ilia ema asigi afädë made negei nelo. ");
INSERT INTO etr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aisaeaea bea säla negei amo gadola gausiala digamäiaïe amala hamoi. Aisaeaea bea säla negei amoda gowe. Dafidilo Geloi-e, nilïa ado säsebeweda, nowëa dofä gabula helësëidu. Amase, Dafidilo Geloiïe geloi amoda nowëma oleidula säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ilia Yesuma asigi afädë negemolö ulï nelo. Amoïe mida, Aisaeaea ado elö säla negei dibe amoda gowe. ");
INSERT INTO etr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ilia siia beala, asigia helësëla besuseda, na ili wahilasiloea, Godea ilile si dofogalasila asigi gala digimelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaeaea amala säi amoïe mida, ea dafidi Gelesoïe yo digalo hïdo elöi amo bealahilä, Gelesoïe amala säimelë. ");
INSERT INTO etr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amala säi gaso, busa dolö nefolalo amoli yafiea Yesuma asigi afädë negei. Gasoda, Felesi ilia ili gedolo mosöa amila segea beselala fisiloea, ilia Felesi amoli helësëlahilä, asigi afädë negei amo ulufala made säi. ");
INSERT INTO etr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mida, ilia dolöea ilile ëi gauia adamäiala helësëlo ameada, Godea ilile ëi gauia adamäiala helësëlo amoda baagi. ");
INSERT INTO etr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuea gelola sähalea, Afädëa nema asigi afädë negei neebe ameada, nemamu made, ne misialala sälo neebe amomage asigi afädë negei nea. ");
INSERT INTO etr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Amase, afädëa ne bease ameada, ne misialala sälo neebe amoge beaha nea. ");
INSERT INTO etr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Afädëa nema asigi afädë negei neebe amo gasimi sagaia aligiloea, neda yo digalo nagadaiawi namolö misi. ");
INSERT INTO etr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Afädëa na ado säsebewe nabalahilä gaso, bëgëlo made neebe amoda, na e made mogemolömelë. Nada udia dolö sege sulubadelagi nefolalebe amoli mogemolö misi made. Nada ili sigi obëgëmolö misimelë. ");
INSERT INTO etr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Be amai gaso, afädëa nema baagi ïala, nïe ado made nabaseda, amoïe gudi mogelo afädë nea. Amoda segeyo aligila wagasolo amo gala, ado na säla ïasebe wea wäla gudila mogemolömelë. ");
INSERT INTO etr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mida, na nihïle asigiamu säha mademelë. Ne misialala sälo Naadoea ado gowe sämalola säla ïmelë. ");
INSERT INTO etr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hamomalalo ameada namolöi namolö amo ulufadigilola helësësamelë. Amala helësëlahilä, na ado säsebeweda, Naadoea nema sämalola säi amo gadolamu säha neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Baagila Asi Segeyo amo hä, ga madesebegi, Yesuea asigia helësësalea, segewe dïgïla ïe Eedo neebea moholö amoda, ga madesebela helësësa nelo. Ea hïle udia dolö nagadaia nefolalebe amoli boba hamosa nelolahilä, e baagosaleage boba hamoi amo wälasimu nea baagoi. ");
INSERT INTO etr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hä deadifalï, ili molö naha sefolalebegi, mugabe Saidania Saimonoïe malö Yudasa Isagaliadaïe asigigi Yesu hololömolö amo hä, helësëlasi. ");
INSERT INTO etr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuea helësësalea, Eedoea nelebo sulubadela ïe naabogimu gausisebegi, Gode neebeala misi amo, bu Gode neebea ami obëgëmolö gabula helësësa nelo. ");
INSERT INTO etr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Amala helësëlahilä, Yesu e molö negela nülo auli mia ami nowela nea, ïe fagulo daia gäi amo giilahilä, dawila neala bului. ");
INSERT INTO etr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Amalahilä, ea falodaia ödä söga negelahilä, ïe bëgëla aulo amolile emo nigime hëla didigila awäla, dawila hï bului amoïe bidia dogadigila digisa nelo. ");
INSERT INTO etr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Amala hëla didigila awäla, Saimono Fida sebeamadi maasebegi, ea sähalea, Dafidilo Geloi-e, dia nïe emo nigime hësalela säi. ");
INSERT INTO etr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Amala säsebegi, Yesuea ema säla obëgësalea, Na walio hamosebeweïeda, dia made helësësebego. Gaso, dia hobeala helësëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Amala säsebegi, Fidaea ema sähalea, Dia nïe emo nigime dofä made hëmolömelëla säi. Amala säsebegi, Yesuea ema säla obëgësalea, Na di made hëseda, dida nebalä made dila namolögodala säi. ");
INSERT INTO etr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Amala säsebegi, Saimono Fidaea ema sähalea, Dafidilo Geloi-e, nïe emomu made. Nïe naabo busala hëmalola säi. ");
INSERT INTO etr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Amala säsebegi, Yesuea ema säla obëgësalea, Dolö afädë nigime hësa maadei neebe amoda, emomu hëmolö dialea. Ïe domalo sulubadela nigime made baai nea. Dilida hä, nigime made baai neamelë. Amai gaso, na dili sulubadela sähalea säha mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ea ili sulubadela nigime baai made nealada made säi amoïe mida, eda dolö gowea hololömolö neala hï dawadigi nelo. ");
INSERT INTO etr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesuea ilile emo nigime hësa maadelahilä, ïe fagulo gii amo bu salugala, hï suloa ami bu fila obëgëlahilä salea ilima nabahalea, Na walio dilima hamosebeweïeda, dilia helësësebele. ");
INSERT INTO etr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Dilia nema sähalea, Säla Olelelolage, Dafidilo Geloilage, säsebe amoda dofä sähamelë. Amai, neda dofä amo neamelë. ");
INSERT INTO etr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dilile Säla Oleleloge, Dafidilo Geloige nea, na dilile emo nigime hëlasisewe gadola, diliage dihilimu amala hamosa namolö dialea. ");
INSERT INTO etr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na dilima hamola olelesewe gadola, hobeala diliage amo gadola hamomäia olelesamelë. ");
INSERT INTO etr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na dilima dofä gelola sähago. Hamoi hamolasilo neebe ameada, ïe busa neebe amo made baagilo. Amase, ado gaula aulo neebe ameada, e mosalalo amo made baagilomelë. ");
INSERT INTO etr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hä, walio na olelei amo gadola helësëla hamoseda, dili obeägïsa namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na dili sulubadelama sähalea säha made. Dolö na memelei amolida nihï dawadigimelë. Gaso, Godeïe bebagi ado säla dëdëla negei dibe amo gadola gausiala digamäiaïe amala sähamelë. Ado säla dëdëla negei amoda gowe. Dolö nïe molö naha filo amea, ne emesala eegeimelëla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Walio na dilima säla ïasebeweda, made hamola neebe amo gaalu säla ïahago. Hobeala na ado säsebewe gadola hamola besela galaseda, amo bealahilä, Ne Nelo amo Neebela dawadigila, dilia nema asigi afädë negesa maademäia, säla ïahagomelë. ");
INSERT INTO etr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na dilima dofä gelola sähago. Afädë na mosalosegi awäse amo neawela sigi aligise ameada, nege neawela sigi aligisagomelë. Amase, ne neawela sigi aligise ameada, ne misialala sälo amoge neawela sigi aligisagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuea amala sälahilä, ïe iso asigigi edefademalä yöi nea säla ulufadigisalea, Na dilima dofä gelola sähago. Diligi afädëa ne hololömolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Amala säi amo nabalahilä, ïe bëgëla aulo amolia gowema säila dawa made ameada, elöea elöma beala, elöea elöma bealai. ");
INSERT INTO etr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bëgëla aulo amoligi Yesuea boba hamolo afädë Yesu hï e miafalï ami sulo. ");
INSERT INTO etr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Amoma Saimono Fidaea odagi nigila sähalea, Ea nowë helësëla sähala dia nabuöla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Amalebe, bëgëla aulo amea, Yesuïe bidagia golögïa alogolahilä nabahalea, Dafidilo Geloi-e, nowëa amamolö gabula nabi. ");
INSERT INTO etr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Amala nabasebegi, Yesuea säla obëgësalea, Na wahalo dagaboi amo neala hëhei gobei ödägi geagilahilä, afädëgali ïaseda, amea amamolömelëla säi. Amala sälahilä, ea wahalo dagaboi amo geagilahilä, Saimono Isagaliadaïe malö Yudasagali ï. ");
INSERT INTO etr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudasaea wahalo amo nii amole, mugabe Saidani ema fedai. Amasebegi, Yesuea ema sähalea, Dia afädë hamomolö neebe amo hä, aabela hamomalola säi. ");
INSERT INTO etr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ami sefolalo amolia, Yesuea säse amo nabi gasoda, mi goweïe säsebela helësëi made sefolalo. ");
INSERT INTO etr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Odoaea helësësaleada, Yudasaea muni adu ägülo ameada, molö nülo segeyo edefade gedosebe amoïe nelebo odoa bidia nea mosalahaledu, ma busadäoi nefolalebe amoligali, gui nelebo afädë ïa mosalahaledula helësëi. ");
INSERT INTO etr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Amalebe, Yudasa e wahalo geagi amo nealahilä, fodolofalï doadigila asi. Amo gaalu hä, gasimi sagala gasi. ");
INSERT INTO etr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasa e doadigila asibua, Yesuea sähalea, Walioda hä, Dolöïe Malö amoïe ëi ilibia amo olesebemelë. Amase, ea hamosebe amea Godeïe ëi ilibia amoge olesagomelë. ");
INSERT INTO etr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Amaimo, Malöea hamosebe amea Godeïe ëi ilibia amo oleseda, Gode hï Dolöïe Malö amoïe ëi ilibia amoge walio wegi wäla olemolömelë. ");
INSERT INTO etr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nïe malöla dili-e, neda dilibalä holöbö ede made namolömelë. Ne awäseda, dilia ne hogomolömelë. Na Yu udia dolö nefolalebe amolima säla ï amo gadola wäla, walioge na dilima säla ïahago. Ne awäse amogida, dili moholöi mademelë. ");
INSERT INTO etr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Dilia hamomäia na dilima mala gähe säla negesebe amoda gowe. Dilia dihilimu boba hahamosa namialo. Na dili boba hamoi amo gadola, diliage dihilimu boba hahamosa namialo. ");
INSERT INTO etr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Dilia dihilimu boba hamose ameada, udia dolö sulubadelaea dilida nïe bëgëla aulo neala helësëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Amala säsebegi, Saimono Fidaea Yesuma nabahalea, Dafidilo Geloi-e, dida abidi moholö nea sähala nabi. Amala nabasebegi, Yesuea ema säla obëgësalea, Sege ne moholö amogida walio dia bëgëla moholöi mademelë. Hobeada dia bëgëla moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Amala säsebegi, Fidaea ema säla obëgësalea, Dafidilo Geloi-e, edoea na walio di bëgëla moholöi madedu. Nïe namolö amo digali fisiga gamolöi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Amala säsebegi, Yesuea säla obëgësalea, Dïe namolö amo dofä negali fisiga gamolöle. Na dima dofä gelola sähago. Haea gagalugo gawalia gäla made neëgi, nafi bu ohodoala dia ne dawa madela sämolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuea ado aso, sähamu neamu sähalea, Dilia yöia idogola säosäola namiabio. Godema asigi afädë negemalo. Amase, nemage asigi afädë negemalo. ");
INSERT INTO etr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nïe Naadoïe mosöa hogoli yafie dialea. Amoli maade galebeda, na dilima made sälabio. Dili namolö sege amo daiamolöïe, ne ami moholömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Awäla dili namolö sege amo daiala negesilahilä, sege ne namolöia ami dilige nebalä nihïlïgïla namolöïe, na dili bu bea obëgëmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ne moholö idi amoda dilia dawadigi nebegomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Amala säsebegi, Domasaea ema nabahalea, Dafidilo Geloi-e, sege di moholö amoda nilïa dawa made. Hä, di idi gowegi moholö neala nilïa abilia helësëmolöi gabula nabi. ");
INSERT INTO etr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Amala nabasebegi, Yesuea ema säla obëgësalea, Idige, ado dofäge, amase, namolöge, nihïne neawe. Afädë Naado neebea moholö, ne neebea made maaseda, moholöi mademelë. ");
INSERT INTO etr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dilia ne dawa galëda, Naadoge dawadigi. Giso, dilia walio mi gäwila, e bealahilä dawadigisagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Amala säsebegi, Filibia ema sähalea, Dafidilo Geloi-e, Diado nilïma olemo. Oleseda, nilïa dofeala helësëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Amala säsebegi, Yesuea ema sähalea, Filibi, segeyo sedade ne dilibalä nelo amo, dia aso, ne dawa made neale. Afädëa ne melï neebe ameada Naadoge melï nea. Amala hamolo dibe amo, dia diado nilïma olemola säi amoda, abeahäladu. ");
INSERT INTO etr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ne Naadoma aligila, amase, Naadoge nema aligilala neebewegi, dia dofä gabula made helësësale. Na dilima ado säla ïaha neebeweda, nïe asigiamu säla ïaha made. Naado e nema neebe amea ïe hamoi amo hamosamelë. ");
INSERT INTO etr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ne Naadoma aligila, amase, Naadoge nema aligilala neamelëla säsewe nabalahilä, dofä gabula helësëmalo. Dofä gabula made helësësa galëda, hamoi hamosa neebewe beala dofä gabula helësëmalo. ");
INSERT INTO etr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na dilima dofä gelola sähago. Afädëa nema asigi afädë negei neebe amea na hamoi hamosa neebewe gadola hamomolömelë. Ne Naado neebea awäse ameada, nema asigi afädë negei neebe amea na hamosa nelo amo baagila awäla, hamoi edefade hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Malöea hamosebe amea Eedoïe ëi gauia adamäia, dilia nïe ëigi nea nelebo afädë ëdëgëseda, na hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dilia nïe ëigi nea nelebo sulubadela ëdëgëseda, na hamomolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesuea ado aso, sähamu neamu sähalea, Dilia ne boba hamoi nea galëda, na hamomalola säsebewe gadola bëgëla hamosa namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dili Ugila Negela Gelolasilo elö, na Naadoma nabulömelë. Eada diligali ïmolömelë. E maalahilä, dilibalä namolöi namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ugila Negela Gelolasilo amoda dofä sälo Gesamimelë. Nagadaia udia dolöea e made melëlo, dawa made amea, e nimolöi mademelë. Gasoda, e dilibalä neebe ameage, amase, dilima nogila digala namolö ameage, dilia e dawadigimelë. ");
INSERT INTO etr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na dili guluba gadoi namiäia dïgïla moholö mademelë. Neda dili neebea obëgëmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Holöfalï nelolahilä, nagadaia udia dolöea ne made bimolö. Gaso, diliamu bimolömelë. Ne neebe ameada, dilige namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ne Naadoma neebe amoge, dili nema neebe amoge, amase, ne dilima neebe amoge, segeyo amo gala dilia dawadigisa maademolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Afädëa na hamomalola säsebe amo nealahilä, bëgëla hamosa neebe ameada, ne boba hamoi nea. Afädëa ne boba hamoi neebe amoda, Naadoeage e boba hamoi namolömelë. Amase, nage e boba hamolahilä, nihïne ema ulufala olemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Amala säi amo nabalahilä, Isagaliada made, Yudasa elöea ema nabahalea, Dafidilo Geloi-e, nilïmada di ulufala olesalea, oböla, nagadaia udia dolö nefolalebe amolimada, di made ulufala olemolömelëla säi amoda, mi edoïela nabi. ");
INSERT INTO etr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Amala nabasebegi, Yesuea ema säla obëgësalea, Afädëa ne boba hamoi neebe ameada, nïe ado bëgëla hamosa namolömelë. Naadoea e boba hamoi nea, e neebea ami Naado alï halïgïla maalahilä, ebalä aligimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Afädëa ne boba made hamoi neebe ameada, nïe ado bëgëla made hamomolömelë. Dilia ado nabaha nebegoda, nïe ado made. Naado ne digamalala sälo amoïe adomelë. ");
INSERT INTO etr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ne made awäla, dilibalä neada, ado amo na dilima säla ïaha nelo amomelë. ");
INSERT INTO etr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gasoda, dili Ugila Negela Gelolasilo, Eleloi Gesami Naadoea nïe ëigila fisiga wemolö amo maalahilä, ea dilima nelebo sulubadela olelesa maademolömelë. Na dilima säla ïaha nelo amo sulubadela, ea dilima helësëlasimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na dalulasilo dilibalä diamiäia dilima ïahagomelë. Nïe dalulasilo amo diligali ïahago. Na ïase amoda, nagadaia udia dolöea ïlo amo gadoi ïaha mademelë. Hä, dilia yöia idogola säosäolage, bedälage namiabio. ");
INSERT INTO etr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na dilima sähalea, Ne awälahilä, dili neebea bu obëgëmolömelëla säi amoda dilia nabi amomelë. Amo nabala nema boba hamoi galebeda, ne Naado neebea awäsewegi dilia obeägïlabio. Mida, Naado eda ne baagila, edefademalä nea. ");
INSERT INTO etr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nelebo amo made besela galala neebe amo gaalu, na dilima säla ïaha nelo amomelë. Säla ï amo gadola hamose beaseda, dilia asigi afädë negemäiaïemelë. ");
INSERT INTO etr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na dilibalä ado sedade säha namolö made gabumelë. Mida, nagadaiaïe busa neebe amo moholö ga made dialea. Ea nema nelebo afädë hamomolö made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gasoda, nagadaia udia dolöea na nïe Naadoma boba hamoi neebe amo helësëmäia, na Naadoea hamomalola säse amo gadolamu hamolomelë. Hä, nowemo. Afiadila säi. ");
INSERT INTO etr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuea ado aso, sähamu neamu sähalea, I gägä negelo gelebi ëfë dofäda nihïne neawe. Amase, gelebi sagai sigi aligiloda Naado neamelë. ");
INSERT INTO etr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nema adomo dila neebe amogi, afädë gägä made negelo neebe amoda, Naadoea damula fisilomelë. Adomo elö gägä negelo neebe amoda, gägä yafie negemäia, Naadoea dagabola digila hahamogisa aligilo nea. ");
INSERT INTO etr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na dilima ado säla ï ameada, dili nigime hësa maadei nefolaleagomelë. ");
INSERT INTO etr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dilia nema dila namialo. Nage dilima dila namolömelë. Adomo afädëa i gelebi ëfë mima dila made hïdo nea, gägä negelo made amo gadola, dilia nema dila made aligiseda, gägä negemolöi mademelë. ");
INSERT INTO etr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","I gägä negelo gelebi ëfëda ne neawe. Dilida adomo gadoi nebego. Afädëa nema dila, amase, nage ema dilala aligiseda, eada gägä yafie negemolömelë. Dilia ne fisila dihilidomu nea, nelebo afädë hamomolöi made nebego. ");
INSERT INTO etr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Afädëa nema dila made aligiseda, eda i adomo dagala fisisegi bausolo amo gadoi nea. Adomo dagala digai bausoi diëgi, ilia gafedelahilä, nulo wisebea ami sadia idogola gobemolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dilia nema dila, amase, nïe adoeage dilima dilala nea, dilia hamesebe amo gadoi ëdëgëseda, ëdëgëse amo gadoi diligali ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dilida ne bëgëla aulo nea, gägä yafie negeseda, Naadoïe ëi gauia adogomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Naadoea ne boba hamose amo gadola, nage amo gadola wäla dili boba hamosa nelomelë. Nïe boba hamolo amogida dili namialo. ");
INSERT INTO etr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na nïe Naadoea hamomalola säse amo bëgëla hamosa nea, ïe boba hamolo amogi ne neebewe gadola, dilia na hamomalola säse amo bëgëla hamosa aligiseda, nïe boba hamolo amogi dilige namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na helësësaleada, nïe obeägïlo dilima negemäiage, amase, dilile obeägïlo dilile isogi nobamäiage, na dilima ado säla ïaha neawemelë. ");
INSERT INTO etr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na dilia hamomäia säsebe amoda gowemelë. Na dili boba hamoi amo gadola, diliage dihilimu boba hahamosa namialo. ");
INSERT INTO etr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Afädëa ïe damelëgali ïe namolö amo fisiga gaseda, ea ïe damelë boba hamose ameada, boba hamolo sulubadela baagila aulomelë. ");
INSERT INTO etr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na dilima hamomalola säse amo gadola hamoseda, dilida ne damelëmelë. ");
INSERT INTO etr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na walio dili hamoi hamolasilo neala sähalea säha made. Hamoi hamolasilo neebe ameada, ïe busa neebe amea abodo gadoi hamosadula dawa made aligilo. Gaso, na dilima damelëla säha. Mida, Naadoea säse nabi amo sulubadela na dilia helësëmäia säla ïaha maadei amomelë. ");
INSERT INTO etr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dilia ne memelei made. Na dili memelela, dilia awäla gägä yafie negemäia nafolala memelelasimelë. Amase, dilia gägä negela diamolöi diamiäia hamogilasimelë. Amala hamoi nea, dilia nïe ëigi Naadoma nelebo afädë ëdëgëseda, ea ïaha maademolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Amaimo, na dilia hamomäia säsebe amoda gowe. Dilia dihilimu boba hahamosa namialola säi. ");
INSERT INTO etr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesuea ado aso, sähamu neamu sähalea, Nagadaia udia dolöea dilima bimolö habobaseda, dafidi nemadale bimolö habobai nelo amo helësëmalo. ");
INSERT INTO etr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dilige nagadaia udia dolö amoli gadoi nelo galebeda, nagadaia udia dolö nefolalebe amolia, ili sosogo nefolalebe amolibalä boba hamolo amo gadola, dilibaläge boba hamola aligilabiomelë. Amai gaso, dili nagadaia udia dolö nebegi na besela neala memelelasi. Ameada, dili nagadaiaïe made nefolalebe goeada, nagadaia udia dolö nefolalebe amolia, dilima bimolö habobasebemelë. ");
INSERT INTO etr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na dilima ado säla ï amo helësëla obëgëmalo. Hamoi hamolasilo neebe ameada ïe busa neebe amo made baagilo. Ilia ne neala sëlasi ameada, dilige neala sëlasimolömelë. Ilia nïe ado bëgëla hamoseda, amase, dilile adoge bëgëla hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amolia dilima hamomolömelëla säi amo sulubadelada, dili nïe ëigi neebe ameage, amase, ne misialala sälo neebe amo dawa made nefolalebe ameage, amala hamomolömelëla säla ï amomelë. ");
INSERT INTO etr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na ilima ado mala säla ïmolö made misi galebeda, ilia nafade hamosala helësëla made hamosa aligilabio. Gaso, walio ilia, nilïa dawa made nea hamoimelëla sämolö ulï bimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nema bimolö habobaha neebe ameada, Naadomage bimolö habobaha nea. ");
INSERT INTO etr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amaimo, ne ili adebawi nea, afädëa siiba hamolo made gadoi hamosa nelo amo ilia bimäia, made hamosa nelo galebeda, ilia nafade hamosala helësëla made hamosa aligilabio. Be, na hamoi amo ilia bealahilä gaso, nemage Naadomage bimolö habobaha neagomelë. ");
INSERT INTO etr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ilia amala hamoi amoïe, ilile Ado säla negei dibe amogi, säla dëdëla negei dibe amoda gowe. Habobamolö mi madegi, memalä ilia nema bimolö habobaimelëla, säla dëdëla negei dibe amo gadola gausiala digamäiaïe amai. ");
INSERT INTO etr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Dili Ugila Negela Gelolasilo, Naadobalä neebe amoda, na e dilima fisiga idamolömelë. Eda dofä sälo Gesami, Naado neebeala moholömelë. E maalahiläda, ne ulufala säla ïaha namolömelë. ");
INSERT INTO etr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Amase, mi gäwiafalï amila dili nebalämu nelo ameada, diliage ne ulufala säla ïmolö galeamelëla Yesuea säi. ");
INSERT INTO etr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Dilia asigi afädë negei nebego dïgïla made mosäia, na dilima ado we säla ïahawemelë. ");
INSERT INTO etr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ilia dili gedolo mosöa amila segea beselala fisimolömelë. Amase, segeyo afädë besela galamolö amogi, afädëa dili nufudahalea, eada Godeïe hamoi hamolasisala helësëla, dili nufulömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ilia Naadoge nege dawa made amea, amala hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amala hamomolömelëla säsebewe hamoseda, säi amo gadola hamosa gabula helësëmäia säla ïahagomelëla säla ï. Yesuea ado aso, sähamu neamu sähalea, Nelebo amala hamomolömelëla, na dafidi mi gäwia amila made säla ïala nelo amoda, ne dilibalä nelo amea, made säla ïala nelomelë. ");
INSERT INTO etr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Amai gaso, walioda, ne misialala sälo amo neebea moholö neamelë. Amai, nema diligi afädëa di abododi moholö neala made nabasebego. ");
INSERT INTO etr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amala säsewegida, oböla dilile asigigi edefademalä bobailösebego. ");
INSERT INTO etr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bobailösa gaso, na dilima dofä säla ïahago. Ne moholö ameada, dili ugila negesalea ne moholö neamelë. Na dili dïgïla moholö made galebeda, Ugila Negela Gelolasilo amo dilibalä namolö made maalabiomelë. Ne awäseda, e dili neebea digamalamolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E maalahilä, nagadaia udia dolöma nafadeda gowe gadoimelëlage, mala mogoida gowe gadoimelëlage, amase, Godea gomalä mogemolömelëlage ea fädäla säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ilia nema asigi afädë made negei neebe ameada, nafadeda gowe gadoimelëla fädäla säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ne Naado neebea awäseda, dilia ne bu elö made bimolö ameada, mala mogoida gowe gadoimelëla fädäla säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sege sulubadelagi nefolalebe amolile beaha aligilo neebe amobaläda, Godea gudila mogei neebe ameada, Godea gomalä mogemolömelëla fädäla säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na dilima ado sämolö yafie gaulea gaso, dilia waliomu neala gaumolöi made gabu. ");
INSERT INTO etr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Amai gasoda, dofä sälo Gesami e maaseda, ea dilile asigi neala mogolasila, ado dofä amo sulubadela helësëlasisa maademolömelë. Ea hïle asigia säla ïmolö mademelë. Ea säse nabase amomu säla ïmolömelë. Amase, nelebo hobeala hamomolö amoïe fädäla säla ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ea nïe ado gaula maala, dilima säla ïmolömelë. Amala hamose ameada, nïe ëige, nïe geloige gauia adogomolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nelebo hulu sulubadela Naadoïe dibe amoda, nïe dialea. Amala dibe amea na sähaleada, Nïe dibe amo Gesamia gaula maalahilä, dilima säla ïmolömelëla säla ï amomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesuea ado aso, sähamu neamu sähalea, Segeyo ede made nelolahilä, dilia ne made bimolömelë. Oböla, segeyo ede made nelolahilä, hobeala bu bimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Amala säi amo nabalahilä, ïe bëgëla aulo odoaea hilidomu didiähalea, Ea nilïma säsebe amoda edodu. Ea ede made nelolahilä dilia ne made bimolömelëla säi amoge, ede made nelolahilä, dilia hobeala bu bimolömelëla säi amoge, amase, ne Naado neebea moholö ameala säi amoge, ea edo helësëla säidu. ");
INSERT INTO etr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aso, sähalea, Ea ede made nelolahiläla säi amoda, edo helësëla säidu. Amoïe mida, nilïa made helësësebela säla didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ilia Yesu ema naba obëgëdeläla helësësebe amo hï dawadigilahilä, ea ilima sähalea, Dihilimu ado na säi amoïe mi hogola didiäha dibegoda, na sähalea, Ede made nelolahilä dilia ne made bimolömelëla säi amogige, amase, ede made nelolahilä hobeala ne bu bimolömelëla säi amogige mi hogola didiäha dialeale. ");
INSERT INTO etr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na dilima dofä gelola sähago. Dilida didigaola dïisa neëgi, udia dolö nagadaia mala hamolo amolida obeägïsa namolömelë. Dilida yöi edefade namolömelë. Oböla hobealada, dili yöi nelo amo bu obeägïlo bedefamolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Udiaea malö ägümolö salea sëmolö fu besela galase gaaluda, asigi säosäosa filo. Gaso, ea hä malö ägüla maala saleada, dafidi sëi amo elabolahilä, ea hä, nagadaiawi malö ägüi amogi obeägïlo. ");
INSERT INTO etr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Amo gadola wäla, walioda hä dili yösa nefolalea. Hobeala na dili bu beasolo amo galada, dilile iso asigigi obeägïmolömelë. Dilia obeägïmolö amoda afädëa neala hogosa helemolöi made bimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Segeyo amogida, dilia nema afädë made nabulömelë. Na dilima dofä gelola sähago. Dilia nïe ëigila Naadoma nelebo afädë ëdëgëseda, ea nabala ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dafidi dilia nïe ëigila nelebo afädë ëdëgëla made nelo gasoda, ëdëgëmalo. Obeägïlo dilima nobamäiaïe, nelebo afädë ëdëgëseda, dilia gaula namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesuea ado aso, sähamu neamu sähalea, Na dilima säla ïaha nelo amoda, ado besulamu säla ïaha nelomelë. Hobeala segeyo afädë besela galasegida, na dilima ado besula made, Naado gowe gadoi neamelëla säla ulufadigimolömelë. ");
INSERT INTO etr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Segeyo amo gala neada, dilia nïe ëigila Naadoma ëdëgëmolömelë. Na Naadoma dilile säsimolömelëla säha mademelë. ");
INSERT INTO etr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Naadoea dili boba hamosa neamelë. Mida, dilia ne boba hamola, ne dofä Gode neebeala misi gabula helësëi neebe gogi. ");
INSERT INTO etr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Naado neebeala maala nagadaiawi digala neawe. Oböla walioda, sege we dïgïla Naado neebea bu obëgësamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Amala säi amo nabalahilä, ïe bëgëla aulo amolia sähalea, Agua, dia besula made säla, dofä ulufadigila säsebego. ");
INSERT INTO etr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nilïa walio helësësalea, diada nelebo sulubadela dawadigisa maadei ameada, afädëa dima nabulöi madela helësësawemelë. Ameada, nilïa dida dofä Gode neebeala misi gabula helësësa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesuea ilima säla obëgësalea, Walioda dilia asigi afädë negei neago gaso, ");
INSERT INTO etr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","nabuö. Segeyo afädë besela galamolö amoda, hä, besela galahagomelë. Amo gala dili sulubadela dusudasila sege dihili neloa ami afufula, ne nihïdofalï dïgïla fisäla dusudasila afiaha maademolömelë. Amamolö gaso, ne nihïdo made, Naado halïgïla neamelë. ");
INSERT INTO etr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na dilima ado amo säla ïaha nelo amoda, dilia nema dilahilä dalulo gaula namiäiaïe, säla ïaha neawemelë. Nagadaiawi neada, dili yöi bimolömelë. Gaso, asigi gelomalo. Na nagadaia galu sulubadelabalä nudula salolela baagila asi neawemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuea ïe bëgëla aulo amolima ado amoli säla ïaha maadelahilä, selesaia mosöa sida adogola nea sähalea, Naado-o, segeyo amoda hä, besela galai gabuwe. Dïe Malöea dïe ëi ilibia amo olemäiaïe, dia Malö amoïe ëi ilibia amo olemalo. ");
INSERT INTO etr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mida, dia udia dolö ema ï amoligali, ea namolöi namolö ïmäiaïe, ea udia dolö sulubadelaïe busa namiäia, dia egali geloi ï gabumelë. ");
INSERT INTO etr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Namolöi namolö amoda gowe gadoi. Gode dofäda dimu neebela helësëlo, amase, Yesu Geleso dia fisiga wei gabula helësëlo amomelë. ");
INSERT INTO etr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Hamoi dia hamomalola säla ï amoda na hä, hamosa maadeimelë. Amala hamosa nelo ameada, ne nagadaiawi nea, dïe ëi ilibia amo ilima oleimelë. ");
INSERT INTO etr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naado-o, siiba naga föi we made hamola ne dibalä nea, nïe ëi ilibia nelo amo gadola, dïe siigi ëi ilibia nelo amo bu ïmalo. ");
INSERT INTO etr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nagadaiawi nelo dolö odoa, dia nema ï amolima dïe ëi ulufala olesa nelomelë. Dïe nelo amoli dia nema ïasio. Ilia dïe ado nabala dia säi amo bëgëla hamoimelë. ");
INSERT INTO etr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nelebo sulubadela dia nema ï amoda, dimadila misi gabula ilia hä, helësësa maadei neamelë. ");
INSERT INTO etr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mida, dia nema ado säla ï amolida, na ilima säla ïaha maadesebegi, ilia hä, niimelë. Nealahilä, ne dofä di neebeala misi gabula helësësa maadei nea. Amase, dia ne dofä fisiga wei gabula helësësa maadei neamelë. ");
INSERT INTO etr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na ili helësëla dima adolasisawe gasoda, nagadaia udia dolö sulubadela helësëla adolasisa mademelë. Na adolasisebeweda dia negali ï amolimu helësëla adolasisamelë. Amoïe mida, ilida dïe neebe amoïe. ");
INSERT INTO etr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Udia dolö nïe neebe amoli sulubadelada dïe neamelë. Amase, dïe neebe amoli sulubadelada nïe nea. Ilia mala hamosebe amea, nïe ëi ilibia amo olesebemelë. ");
INSERT INTO etr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hä, walioda ne di neebea moholö neawe. Neda nagadaiawi made namolö. Ilimu wi namolömelë. Naado Hedabi Eleloifalï-e, alï afädëdi neebewe gadola, ilige afädëdi namiäia, dia dïe ëi nema ï amoïe geloia ili sigi namialo. ");
INSERT INTO etr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ne ilibalä nelo amogida, dïe ëi nema ï amoïe geloia ili sigi nelomelë. Na ili sigi nebegida, afädë dabadigi mademelë. Be, dolö afädë dabadigimolö nelo amomuda hä, dabadigimelë. Amala hamoi amoda ado Godeïe bebagi dëdëla negei dibe amo gadola gausiala digamäia. ");
INSERT INTO etr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Walioda hä, ne di neebea maahago. Gaso, nïe obeägïlo ilile isogi nobamäia, ne nagadaiawi nea dima adolasisamelë. ");
INSERT INTO etr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na ilima dïe ado säla ïaha nebegi, nagadaia malamu hamolo neebe amolia ilima bimolö habobaha nelomelë. Mida, ne nagadaia sosogo made neebe amo gadola, ilige nagadaia sosogo made neebe amea. ");
INSERT INTO etr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na dima adosebe amoda, nagadaiawila dia ili sigi mosäia made adosamelë. Nafade hamolo busaea ili neala nafadelasiloea, dia sigi namiäiaïe adosamelë. ");
INSERT INTO etr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ne nagadaia sosogo made neebe amo gadola, ilige nagadaia sosogo made nea. ");
INSERT INTO etr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Dïe adoda dofä sälo dialea. Ili nafolala dihïle namiäia, dofä sälo ado amea, dia ilile isogi hamoi hamolasimalola sähago. ");
INSERT INTO etr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Dia nema nagadaiawi udia dolö nefolalebe welibalä namiäia fisiga wei amo gadola, nage ili udia dolö nefolalebea ami afufumalaimelë. ");
INSERT INTO etr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na ili helësëla, ili dihïlefalï dofä nafolala namiäiaïe, nege dima odala ïala neawe. ");
INSERT INTO etr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Dima dolö amolimu helësëla adolasisa mademelë. Ilia ado säla ïase amo nabala, nema asigi afädë negemolö amolilege gedola adolasisagomelë. ");
INSERT INTO etr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nada ili afädëdi namiäiala helësëla adolasisago. Naado-o, di nema neebe amo gadolage, amase, dima ne neebe amo gadolage, ilida alïma namiäiala hamesa. Nagadaiawi udia dolö nefolalebe amolia, dia ne dofä fisiga wei gabula helësëmäiaïe amala adolasisago. ");
INSERT INTO etr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Alï afädëdi neebe amo gadola, ilige afädëdi namiäia, dia nema geloile, ëi ilibiale ï amo, na iligali ïmelë. ");
INSERT INTO etr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne ilima neebe ameage, amase, di nema neebe ameage, ili dofä afädëdi namiäiaïe. Amoïe mida, nagadaiawi udia dolö nefolalebe amolia dia ne fisiga wei gabula helësëmäiaïe, amase, dia ne boba hamose go gadola, ilige boba hamoi gabula helësëmäiaïemelë. ");
INSERT INTO etr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Naado-o, dia udia dolö nema ï amoli ne namolöia ami ili nihïlïgïla namiäiage, amase, nïe ëi ilibiale, yo digalole dia nema ï amo bimäiage hamesamelë. Naga föi made hamola nea, dia ne edefademalä boba hamosa nelo amea, ëi ilibia amoge, yo digalo amoge ïmelë. ");
INSERT INTO etr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mogoi neebe Naado-o, nagadaia sosogo nefolalebe amoliada di dawa made gaso, nada di dawadigimelë. Amase, ne sosogo nefolalebe ilia dia ne fisiga wei gabula dawadigisa maadeimelë. ");
INSERT INTO etr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na ilima dïe ëi ulufalasi. Dia ne boba hamoi amo gadola, boba hamolo amo ilima diamiäiage, amase, nihïne ilima namiäiage, dïe ëi, hä, ulufalasisa namolömelëla adola wagai. ");
INSERT INTO etr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuea Godema adosa maadelahilä, ïe bëgëla aulo amolalibalä segea doadigila awäla ödä Gidolono dëgëla alömodi asi. Sagai afädë dibea ami ïe bëgëla aulo amolali awäla besela galai. ");
INSERT INTO etr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sagaia amida dafidi Yesuea ïe bëgëla aulo amolibalä segeyo yafiegi ami gedosa aligilo. Amala gedolo ameada, Yudasa e hololölo amea dawadigi nelo. ");
INSERT INTO etr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Amai ameada, Olomo ami dolö odoage, Godeïe mosö idihë aligilo odoage, Felesi dolö odoaeage gobela ïlo busa amoliage mosalosebegi, ilia gele gamalige gaula, amase, nufidelo neleboge gagaulahilä, sagaia ami Yudasaea ili sigi asi. ");
INSERT INTO etr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Maasebegi, Yesuea ema hamomolö amo sulubadela hï dawadigilahilä, doadigila awäla ilima nabahalea, Dilia nowë hogola mofiaila nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Amala nabasebegi, ilia ema säla obëgësalea, Nilïada Nasalese dolö Yesu hogola misila säi. Amalebe, Yesuea ilima säla obëgësalea, Amoda nemelëla säi. E hololölo Yudasa amoge ilibalä misi nelo. ");
INSERT INTO etr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuea, amoda nemelëla säi amo nabalahilä, ili badadi gasia imomogola nagadaia fila didigafui. ");
INSERT INTO etr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Amasebegi, Yesuea ilima bu nabahalea, Dilia nowë hogola mofiaila nabi. Amalebe ilia sähalea, Nilïada Nasalese dolö Yesu hogola misila säi. ");
INSERT INTO etr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Amala säsebegi, Yesuea säla obëgësalea, Na dilima dafidi säla ï amo, amoda nemelë. Dilia ne hogosa galëda, dolö nefolalebe gowe ili mosäia fu ïmola säi. ");
INSERT INTO etr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Dafidi hï sähalea, Naado-o, dia dolö negali ï gowe ili afädë made dabadigila säi amo gadola gausiala digamäia amala säi. ");
INSERT INTO etr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimono Fidaea nudulo helebe afädë gaula misi amo dusugala neawelahilä, gobela ïlo busa edefadeïe hamoi hamolasilo amo nufi. Nufudasebegi, gëhe dafädimadi amo dagala salisi. Hamoi hamolasilo amoïe ëida Malagusi. ");
INSERT INTO etr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Amala hamosebegi, Yesuea Fidama sähalea, Dia helebego dihï salelo amogi sala obëgëmo. Dia helësësaleada, Naadoea ödä iigi usi ï gowe na made molö gabula helësësalela säi. ");
INSERT INTO etr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Amalebegi, ami dolö amoliage, ilile beaha aligilo busaeage, amase, Yu ilile idihë aligilo amolaliage, Yesu gaulahilä ëfëa nafodoi. ");
INSERT INTO etr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Amalahilä, ilia e Anasa neebeadale sigi asi. Anasa eda Gaiafasaïe esöa nelo. Gäheo i amogida, Gaiafasa eda gobela ïlo busa edefade nelo. ");
INSERT INTO etr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Dolö ameada Yu ilima dafidi sähalea, Afädëa udia dolö baagomolö amo bedefala baagomolö dofea gabumelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimono Fidage bëgëla aulo elöge Yesu awäse amo gadola bëgëla hobeala asi. Bëgëla aulo elö amoda gobela ïlo busa edefade amea dawadigi nelo. Ameada, e Yesubalä gobela ïlo busa edefade amoïe yala isogi nogila digai ");
INSERT INTO etr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","gaso, Fida eda yala idi galo baagido nelo. Amala nebegi, bëgëla aulo elö, gobela ïlo busa edefadea dawadigi amea udia dolïsä idi galo beaha aligilo amoma sälahilä, ea Fida yala isogi sigi digai. ");
INSERT INTO etr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sigi digasebegi, udia dolïsä idi galo beaha aligilo amea Fidama nabahalea, Dige dolö goweïe bëgëla auloledula nabi. Amala nabasebegi, ea säla obëgësalea, Ne mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gögïsebegi, hamoi hamolasilofulo, idihë aligilofulo amolia nulo gobelahilä, gögï hausa nefolalebea ami, Fida eege ilibalä ami gögï hausa nelo. ");
INSERT INTO etr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Amo gala, gobela ïlo busa edefade amea Yesuma ïe bëgëla aulo amolilege, ea ado säla olelei amoïege nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Amala nabasebegi, Yesuea säla obëgësalea, Nada udia dolö nefolalebe amoli sulubadelama ulufala säla olelesa nelo. Segeyo sulubadelagi gedolo mosöage, Godeïe mosöage, sege Yu ili gedosia ami olelesaleada, afädë musügä negela made olelesa nelomelë. ");
INSERT INTO etr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Edoïe dia nema nabaha. Na mala säla ïase nabelo amolima nabualo. Na säi amo ilia dawadigi neagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuea amala säsebegi, idihë aligilo dolö afädë ga made nelo amea nabalahilä, Yesu e naabo gafea nufudalahilä nabahalea, Dia gobela ïlo busa edefade egowe gadoima egomalä säla obëgëmolöi gabulela nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Amala nabasebegi, Yesuea säla obëgësalea, Na nafade säi galëda, gowe asiala säimelëla nefolalebe gowe ilia nabuäia fädäla sämalo. Be, na mogola säi amogi galëda, dia ne edogi nufudahala nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Amalebe, Anasaea Yesu e gobela ïlo busa edefade Gaiafasa neebea sigi mosalola säsebegi, Yesu e ëfëa nafodoi amola wäla sigi asi. ");
INSERT INTO etr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimono Fida e nulo gobeia ami gögï hausa nebegi, ilia ema nabahalea, Dige ïe bëgëla auloledula nabi. Amala nabasebegi, ea säla obëgësalea, Ai. Ne mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Amala säsebegi, gobela ïlo busa edefade amoïe hamoi hamolasilo afädë ami nelo amoda, dafidi Fidaea gëhe dagala sali amoïe sosogo nelo, amea Fidama sähalea, Sagaia ami ebalä neebe na melï amoda di madelela nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Amala nabasebegi, Fidaea bu elö sähalea, Ai. Ne mademelëla säi. Amala säia gai amole, haea gagalugo gawalia gäi. ");
INSERT INTO etr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Amala hamolahilä, ilia Yesu e Gaiafasa neebea amila Beledoliama mosöa ami sigi asi. Yosefalï sigi asi amoda, Yu dolö ilida Godeïe siigi nigime baai made aligilo amo damumolöi made gabugi, ili mosöa ami nogila digala made, segea nelo. Mida, ilia Baagila Asi Segeyo amoïe molö molöïe amai. ");
INSERT INTO etr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ili segea ami nebegi, Bailadi e segea fedalahilä ilima nabahalea, Dolö goweada edo nafade hamosebegi gudimolöïe sigi misila nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Amala nabasebegi, ilia ema säla obëgësalea, Ea nafade made hamoi galebeda, nilïa e sigi made maalabiomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Amalebe, Bailadia säla obëgësalea, Dihilile mala dibe amo gadola gudimolöïe, dihili e sigi obëgëmalola säi. Amala säsebegi ilia ema sähalea, Nilïa gudilahiläda, dolö afädë nufulöi mademelëla säla negei dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Amala säi amoda, dafidi Yesuea sähalea, Nema gomalä hamosegi baagomolö gabula ulufala olei amo gadola gausiala digamäiaïe säi. ");
INSERT INTO etr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Amala säsebegi, Bailadi e Beledoliama mosö isogi bu nogila digala, Yesu welahilä ema nabahalea, Dida Yu ilile ginilela nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Amala nabasebegi, Yesuea ema säla obëgësalea, Dia dihï asigia helësëla nabahale, ma, odoaea nïeïe säi nabala nabahalela nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Amala nabasebegi, Bailadia säla obëgësalea, Neda Yu dolö gabule. Dihïle fiifalï amoliage, gobela ïlo busa amoliage di nïe naabogi gausi amoda, dia edo hamoi amea amahala nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Amala nabasebegi, Yesuea säla obëgësalea, Na beaha maadela sigi neebe amoda nagadaiaïe mademelë. Be, nagadaiaïe galebeda, Yu dolö ilia ne gauloea, nïe hamoi hamolo amolia nudulabiogoda. Na beaha maadela sigi neebe amoda, hä, nagadaiaïe mademelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Amala säsebegi, Bailadia ema sähalea, Hä, di dofä beaha aligilo gini madelela säi. Amala säsebegi, Yesuea säla obëgësalea, Dihï ne beaha aligilo gini neala säsebegomelë. Ado dofä amo säla ïaha maademäia nagadaiawi digasebegi, ne nemea neegela ägüi amo neawe. Udia dolö dofä sälo sosogo nefolalebe amoli sulubadelaeada, nïe ado nabelo neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Amala säsebegi, Bailadia ema nabahalea, Ado dofä amoda edodula nabi. Bailadia ado säha maadela, segea bu doadigila fedala Yu dolö amoli neebea awälahilä, ilima sähalea, Ema nafade afädë made beagoleimelë. ");
INSERT INTO etr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amai gaso, na dilile mala dibe amo gadola, Baagila Asi Segeyo besela galaseda, galabaia dolö afädë dihilima fisigälo. Amo gadola, na walio Yu udia dolöïe beaha aligilo gini gowe dihilima fisigädulela nabi. ");
INSERT INTO etr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Amala nabasebegi, ilia gelola uuala säla didigahalea, E mademelë. Balabasa fisigämalola säi. Balabasa eada fa neaha aligilo nelo. ");
INSERT INTO etr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Amala säi amo nabalahilä, Bailadia Yesu sigi awäla e fëgämaloi. Fëgälahilä, ");
INSERT INTO etr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ami dolö amolia ëfë äyo gägäi gadoia gini busa gadoi nasigïla amalela ïe busagia salugasilahilä, fagulo bëi didiga salugalo afädëge salugasi. ");
INSERT INTO etr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Salugasi nebegi, ili e mia ga madela mafulahilä sähalea, Yu udia dolöïe beaha aligilo gini-e, di go gabiola sälahilä, naabo gafea fadaha nelo. ");
INSERT INTO etr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bailadi e bu elö doadigila fedalahilä, ilima sähalea, Dolö gowema nafade afädë made beagolei gabula helësëmäia, na dili neebea gui sigi segea doadigila fedahagola säi. ");
INSERT INTO etr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu e ëfë äyo gägäi gadoia gini busa gadoi amalela salugasi amola, fagulo bëi didiga salugasi amola wäla fedasebegi, Bailadia ilima sähalea, Dolö amoda gowemelë. Bimola säi. ");
INSERT INTO etr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","E bealahilä, gobela ïlo busa amoliage, idihë aligilo amoliage, uuala säla didigahalea, Eda i fügäigi baala negemalola säla didigai. Amala säla didigasebegi, Bailadia ilima säla obëgësalea, Dihili e sigi awäla, i fügäigi baala negemolö mosalo. Nada ema nafade afädë made beagoleimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Amala säsebegi, Yu ilia ema säla obëgësalea, Nilïa ado afädë säla negei galea. Ea e Godeïe malöla sälo ameada, ado säla negei dibe amo bëgëla, e nufulö dialeala säi. ");
INSERT INTO etr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ado amo nabala Bailadi e edefademalä bedälahilä, ");
INSERT INTO etr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Beledoliama mosö amoïe mumusogi bu nogila digalahilä, Yesuma nabahalea, Dida abidi fii dolöla nabi. Amala nabasebegi, Yesuea ema made säla obëgëi. ");
INSERT INTO etr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Made säla obëgësebegi, Bailadia ema sähalea, Dia made säla obëgësale. Di fisigämola sämolöïe geloige, i fügäigi baala negemola sämolöïe geloige na gaulube amo, dia made helësësalela nabi. ");
INSERT INTO etr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Amala nabasebegi, Yesuea ema säla obëgësalea, Gode ilibia neebe amea dia nema hamomäia geloi made ï galebeda, dia nema hamomolö amo, hamomolöi made bealabio. Be, dolö dïe naabogi gausilo amea nafade hamoi amoda dia hamoi amo baagila, nafade edefademalä hamoimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bailadia amala säi amo nabalahilä, Yesu fisigämolöïe idi hogoi. Gasoda, Yu ilia uuala didigala sähalea, Dia dolö go fisigäla fisiga gaseda, dida Sisaïe damelë mademelë. Dolö afädëa hï e ginila säsebe amoda Sisabalä ado niimelëla säla didigai. ");
INSERT INTO etr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Amala säi amo nabala, Bailadia Yesu sigi segea doadigila fedalahilä, sege ëi Igi Bealë Baledei difolalebea ami gudi mogesalea filo amodaia sulo. Sege amoïe ëi Hibulu adoeada, Gabadala sälo. ");
INSERT INTO etr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Baagila Asi Segeyo amoïe helësëla molö daialo segeyo amo gala eso mogosebegi, Bailadia Yu udia dolö ilima sähalea, Dilile beaha aligilo gini amoda gowemelë. Bimola säi. ");
INSERT INTO etr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Amalebe, ilia uuala didigahalea, Nufualo! Nufualo! Eda i fügäigi baala negemalola uuala säla didigai. Amalebe, Bailadia ilima nabahalea, Diliada na dilile ginigo i fügäigi baala negemäialela nabi. Amala nabasebegi, gobela ïlo busa amolia säla obëgësalea, Nilïle gini elöda maade. Sisa afädëmu neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Amala säsebegi, Bailadia Yesu e i fügäigi baala negemäia, hilile naabogi gausi. Amalebe, ami dolö amolia Yesu e sigi asi. ");
INSERT INTO etr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ea hïle i fügäi amo hï gaulahilä, gaamu amo dïgïla sege ëi Busa Giwi Segela sälo dibea ami asi. Hibulu adoea sege amoda Gologodala sälo. ");
INSERT INTO etr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Segea ami ilia e i fügäigi baala negesaleada, dolö äudäge ebalä baala negei. Eda mogogi, elö ïe naabo dafädimadi, elö ïe naabo fefeädimadila baala negei. ");
INSERT INTO etr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bailadia i gäi baledeidaia ado gowe dëdëla negemalosebegi, ilia amodaia dëdësalea, Nasalese fii Yesu, Yu udia dolöïe beaha aligilo ginila dëdëlahilä, i fügäi amoïe bidigi baasi. ");
INSERT INTO etr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu e gaamu ga madela baala negei ameada, Hibulu adoeage, Olomo adoeage, Giligi adoeage säla dëdëla negei dibe amo, Yu udia dolö yafiea nidesamu nelo. ");
INSERT INTO etr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Amala dëdëla negei dibe amo bealahilä, Yu ilile gobela ïlo busa amolia Bailadima sähalea, Dia Yu ilile beaha aligilo ginila sälada dëdëmabu. Ea hïmu sähalea, Neda Yu udia dolöïe beaha aligilo gini neamelëla sälola säla dëdëmola säi. ");
INSERT INTO etr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Amala säsebegi, Bailadia säla obëgësalea, Na dëdëla negei gomu diamiäia. Gameläla säi. ");
INSERT INTO etr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ami dolö amolia Yesu hä, i fügäigi baala negesilahilä, ïe fagulo gii amo biyidiala mogei. Mogelahilä, ilia afädë afädëla nea gagai. Nea gagalahilä, ïe fagulo elö daia salugalo sedade gii amomu dilo. Fagulo amo asogemolöi made, didigala afädëfalï asi gabugi, ");
INSERT INTO etr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ami dolö amolia hilidomu sähalea, Fagulo go made gadelala, nowëa neasebelela melëdelä sadu hamodila säi. Ado säla negei amea sähalea, Ilia nïe fagulo mogelahilä, nïe daia salugalo gii amoïe sadu hamoimelëla säla dëdëla negei dibe amo gausiala digamäiaïe, amala hamoi. ");
INSERT INTO etr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesuïe emege, emeïe esamage, Golobasaïe udia Melige, amase, gaamu Magadala udia Melige, ili Yesu i fügäigi baala negei amo ga madela ami nefolalo. ");
INSERT INTO etr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuea, ïe emele, ïe bëgëla aulo amoligi ea boba hamolo amole ga madefalï neebe amo bealahilä, emema sähalea, Neme-e, dïe malöda egowemelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Amase, bëgëla aulo amomage sähalea, Dïe diemeda egowemelëla säi. Amalebe, bëgëla aulo amea amo gala säia amila e sigi awäla ea mosöa sigi nelo. ");
INSERT INTO etr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hobeala, Yesuea hamoi hahamola misi amo hä, walio hamosa maadei gabula helësëlahilä, Ne ödä molö gabula säi. Ado säla negei dibe amo gadola gausiala digamäiaïe amala säi. ");
INSERT INTO etr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Amala säsebegi, ödä i afädëgi wani ödä gamogai usi ami dilo amogi, ilia dahudu gadoi i afädëïe ëi hisoboïe adomogi yaala, wani ödä gamogai amogi gelahilä, Yesuïe nafia diisi. ");
INSERT INTO etr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Amala hamosebegi, Yesuea wani ödä amo nalahilä sähalea, Hä, hamosa maadei amola säla, ïe busa fuäia idogola ïe namolö amo fisila, hame hä, mosaloi. ");
INSERT INTO etr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sabada segeyo edefade amoïe molö daialo segeyo gabugi, ilia Sabada segeyo amogi domalo i fügäidaia ami made diamiäiala helësëla, Yu ilia Bailadima sähalea, Ilile emo giwi dagabolahilä, domalo neala gaula mosäia, dia emo giwi dagabomalola sämäia helësëi dialeamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Amala säsebegi, ami dolö amoli awälahilä, Yesubalä baala negei dilo amogi afädëïe emo giwi dagabolahilä, elö amoïe emo giwige dagaboi. ");
INSERT INTO etr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amalahilä, ilia Yesu dibea maala beahamelebe, eda hä, hame doala asi dibe amo bealahilä, ïe emo giwi made dagabola, ");
INSERT INTO etr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","afädëa Yesuïe afawa gögë gäwi amole healele ödäle besigai. ");
INSERT INTO etr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Amo hamose melëlo dolö amea, nelebo ea melï amo säla ulufai. Ea säla ulufai amoda dofämelë. Amase, säla ulufasebe amoda dofäla hï dawadigi. Ameada, diliage asigi afädë negemäiaïe, ea säla ulufasebemelë. ");
INSERT INTO etr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Godeïe ado säla negesalea, ïe giwi afädë made dagabomolömelëla säla negei amo gadola gausiala digamäiaïe amala hamoi. ");
INSERT INTO etr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Amase, ado elö säla negei dibe amoda gowe. Dolö gögë gäwi amoda ilia bimolömelëla säla negei amo gausiala digamäiaïe amai. ");
INSERT INTO etr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Amalahilä, hobeala Alimadia fii Yosebea Bailadima Yesuïe domalo amo nedulela nabi. Yosebe eda Yesuïe bëgëla aulo nelo gaso, Yu ilibalä bedähalea, ïe asigi afädë negei amo musügä negela nelo. Bailadia, ä, nimalola säsebegi, ea awäla Yesuïe domalo amo nii. ");
INSERT INTO etr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nigudimusi e, dafidi Yesu neebea gasigi aulo amoge, ebalä asi. Nigudimusia i afädëïe heale muwege, i ëi elö aloïe healele gegoai dilo amea, Yesuïe domalobalä negemolöïe gaula asi. I heale gegoai dilo amoïe yöi dofeda, gilo nabülasi ohodoa gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Elea Yesuïe domalo amo nealahilä, Yu dolöea bausalea hamolo amo gadola, i heale gegoai dilo amola Yesuïe domalobalä baagoi usililo fagulo hedabia balagula usili. ");
INSERT INTO etr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ilia Yesu i fügäigi baala negesi diloa amida, sagai afädë dilo. Sagaia amida baumolöïe igi äbä afädë doalahilä, dolö afädë made baui, gähe dilo. ");
INSERT INTO etr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Elea Yu ilile Sabada segeyoïe daialo segeyo gabula helësëlahilä, baumolö äbä duwi ga made dilo ameada, elea Yesuïe domalo amogi bausi. ");
INSERT INTO etr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Salele mi gäwi segeyogi, sege yomolö gaalu, Magadala udia Meli e bauia ami awälahilä beahamelebe, äbä igia idi gai amo doga negei dibe melï. ");
INSERT INTO etr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Amo beala, e baluluia awälahilä, Saimono Fidale bëgëla aulo elö Yesu hï boba hamolo amole neebea besela galala, elema sähalea, Ilia Dafidilo Geloi bauia amila gaula asi gabio. Ilia abidi gaula awäla negeidu, nilïa dawa madela säi. ");
INSERT INTO etr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Amo nabalahilä, Fidale bëgëla aulo elöle amila doadigila bauia ami moholö asi. ");
INSERT INTO etr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Helegela gaalu baluluia asi gaso, bëgëla aulo elö amea Fida dïgïla, edale bauia ami awäla besela galai. ");
INSERT INTO etr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Besela galalahilä, nogila digala made, dosogägïla fia idogola salea, aga beahamelebe, fagulo hedabi amomu isogi ami dibe melï. ");
INSERT INTO etr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimono Fida hobeala maala, baui isogi nogila digalahilä beahamelebe, fagulo hedabi amoge, ");
INSERT INTO etr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","fagulo Yesuïe busa neegisila bausi amoge, gedola negela made, fagulo busa neegisi amo hïdo galila negei dibe melï. ");
INSERT INTO etr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Amalebe, bëgëla aulo elö bauia dafidi besela galalo amoge, oböla hobeala baui isogi nogila digalahilä, amala hamoi dibe amo beala, e asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesu bauiala nowemolö dialeamelëla, ado säla negei dilo amoda, amo gala ilia hedabola helësëi made nelo. ");
INSERT INTO etr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Amo bealahilä, hele mosöa obëgëi. ");
INSERT INTO etr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Segea baui baagido nea, Melia dïisa nelo. Dïisa nea wäla, dosogägïla fia idogolahilä, baui isogi beahamelebe, ");
INSERT INTO etr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","selesaia fii fagulo falei salugai äudä, Yesuïe domalo baui diloa ami, elöda busa diloamadi, elöda emo diloamadila sebe melï. ");
INSERT INTO etr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Elea Melima nabahalea, Udia-o, dia goda edogi dïisa neala nabi. Amalebe, ea elema säla obëgësalea, Ilia nïe Dafidilo Geloi gaula awäla, abododi negeidula dawa made amea dïisamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Amala sälahilä, e besuia imogola beahamelebe, Yesu neebe melï. Ea melï gasoda, Yesu gabula made helësëi. ");
INSERT INTO etr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Amasebegi, Yesuea ema nabahalea, Udia-o, dia goda edogi dïisa nea. Dia nowë hogosala nabi. Melia dolö amoda sagai beaha aligilo amo gabula helësëlahilä, ema sähalea, Dolö edefade-e, dia e gaula asi galëda, nihï nea äudulä, guwi gaula awäla negei dialeala sämola säi. ");
INSERT INTO etr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Amala säsebegi, Yesuea ema, Meli-ela säi. Amala säi amo nabalahilä, ea besuia imogolahilä, Hibulu adoea ema Elabonai-ela säi. Nilïle ado sälada Säla Olelelo-o. ");
INSERT INTO etr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Amalebe, Yesuea ema sähalea, Naado neebea gadogo aso, fedaia madeda, dia nema diigimabu. Dia nedoolali neebea awälahilä, gomalä sämalo. Neda aso, nïe Naadoge dilile Eedoge, amase, nïe Godege dilile Godege neebea fedamolö neebeola sämalola säi. ");
INSERT INTO etr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Amala säsebegi, Magadala udia Meli e awälahilä, bëgëla aulo amolima sähalea, Na Dafidilo Geloi e melïmelëla sälahilä, ema säla ï amo ilima säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Segeyo amo galamu, salele mi gäwi segeyogi, eso digase gaalu, ïe bëgëla aulo amoli Yu ilibalä bedähalea, ili sefolalo mosö amo idi fëdöla galahilä sefolalo. Amala sefolalebegi, Yesu ili sebe mogogi ami maala nea, ilima sähalea, Dalulo dilibalä namiäiala säi. ");
INSERT INTO etr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Amala sälahilä, naaboge afoge ilima olei. Ilia hä, Dafidilo Geloi bealahilä, edefademalä obeägï. ");
INSERT INTO etr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuea ilima bu elö sähalea, Dalulo dilibalä namiäia. Naadoea ne fisiga wei amo gadola, nage dili fisiga gahagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Amala sälahilä, ea ilimadi hame hëia fedala nafi fo diigilahilä sähalea, Eleloi Gesami nimo. ");
INSERT INTO etr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Odoaea nafade hamoi amo dilia hëla fisiseda, hëla fisimelë. Be, odoaea nafade hamoi amo dilia made hëla fisiseda, nafade amolida diamolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu besela galasolo amo galada, ili giwilasi amoligi Domasa, ïe ëi elö Didimusila sälo amo, sebegi made besela galai. ");
INSERT INTO etr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hobeala, bëgëla aulo odoa amolia ema sähalea, Nilïa Dafidilo Geloi melïmelëla säla ï. Amala säla ïasebegi, Domasaea ilima sähalea, Ïe naabogi milï gäwi amo made bealage, nïe naabo sögöea ïe milï gäwi bu amogi made digalage, amase, ïe afawa gäwi bu amogi nïe naaboea made digalage, nada dofä gabula made helësëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Amala säi salele afädë baagilahilä, ïe bëgëla aulo amoli bu mosöa gegedola sefolalo. Amo gala Domasage hiligila sulo. Idi sulubadela fëdöla gai gaso, Yesu e ili mogogi ami maala nea, ilima sähalea, Dalulo dilibalä namiäiala säi. ");
INSERT INTO etr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Amala sälahilä, ea Domasama sähalea, Nïe naabogi dïe naabo sögöea digala bimo. Amalahilä, dïe naabo mogodigila nïe afawa digala bimo. Hä, bealahilä, asigi äudä negela made, afädëfalï negemalola säi. ");
INSERT INTO etr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Amala säsebegi, Domasaea ema säla obëgësalea, Nïe Dafidilo Geloi, nïe Godela säi. ");
INSERT INTO etr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Amala säsebegi, Yesuea ema sähalea, Dia ne beala asigi afädë negesale. Ne made beala asigi afädë negese amoliada, edefademalä obeägïsa neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu e bëgëla aulo amolibalä nelo amo gaalu, ilile siigi dolöea hamomolöi made gadoi odoa yafie hamoi dibede amoda, beba gowegi hulu made dëdëla negei. ");
INSERT INTO etr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gaso, beba gowegi dëdësebeweda, Afädë Memelei amoge, Godeïe malö amoge Yesu gabula helësëla, ema asigi afädë negemäiage, amase, dilia ema asigi afädë negesa nea, ïe ëigi namolöi namolö gaula namiäiage, dëdëla negesawe. ");
INSERT INTO etr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hobeala, bëgëla aulo amoli Dabeliasa oeaba ami nebegi, Yesu e bu elö ilima ulufadigila besela galai amoda gomalä hamoi. ");
INSERT INTO etr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimono Fidage, Domasa ïe ëi elö Didimusige, Galili segeïe gaamu Gaina ami fii Nadanalege, Sebediïe malö äudä amolege, ïe bëgëla aulo äudä elölege, ili ami gedola nefolalo. ");
INSERT INTO etr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ami nefolalea, Saimono Fidaea ilima sähalea, Neda seme digila awähadiola säsebegi, ilia nilïge hä, dibalä maahagola säi. Amala sälahilä, ili duugi fifigila awäla, gasigi seme digisa nea, seme isoïe afädëge made neala nelo. ");
INSERT INTO etr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sege yose amo gaalu, Yesu bosea ami maala nelo gaso, ïe bëgëla aulo amolia e Yesu neala made helësëi nelo. ");
INSERT INTO etr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Amala nebegi, Yesuea ilima nabahalea, Malïsä-o, dilia seme afädë made niilela nabi. Amala nabasebegi, ilia säla obëgësalea, Ä, made niimelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Amalebe, ea ilima sähalea, Selëgëgo dilile du dafädimadi digiseda, seme odoa digamolömelëla säi. Amalebe, ilia selëgë amala digilibe, seme yafie digai amea, selëgë dusugamolö ulï. ");
INSERT INTO etr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Amala hamosebe amo bealahilä, bëgëla aulo afädë Yesu hï boba hamolo amea, Saimono Fidama sähalea, Goweda Dafidilo Geloi gabula säi. Dafidilo Geloi gabula säi amo nabalahilä, Fidaea fagulo daia salugalo dafidi giila negei dilo amo salugalahilä, ödägi nila digai. ");
INSERT INTO etr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Amase, bëgëla aulo odoa amoliada dudaia nea, selëgëgi seme digaide amo dusugala gaula agesua moholö asi. Ili neloa amila ödä agesuada, mia made made, mida hädali afädë gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ili agesua aliga alogola beahamelebe, nulo gobei elëlëgi amodaia seme gobei afädë, beledige dibe melï. ");
INSERT INTO etr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuea ilima sähalea, Dilia walio seme nii gogi odoa gaula misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Amala säsebegi, Saimono Fida e awäla dudaia nea, seme selëgë amo agesua dusugala gaula misi. Seme bobogamu selëgëgi digai amo gedolada hädali afädëïe nabülasi biaïe odoai ohodoa (153). Seme malei digai amea, selëgë nulimolöi gaso, made nuli. ");
INSERT INTO etr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuea ilima sähalea, Dili hä, molö naa mofiamola säi. Amalebe, bëgëla aulo amoli bedähalea, iligi afädëa di nowëla made nabi. Iliada Dafidilo Geloi gabulamu helësëi. ");
INSERT INTO etr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu e maala nea, beledi gobei amo neala iligali sogolahilä, seme gobei amoge, amo gadola wäla hamoi. ");
INSERT INTO etr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu e bauiala nowela awäla nea, bëgëla aulo amoli neebea bu osoda ulufala besela galaida amo. ");
INSERT INTO etr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ili molö naha maadelahilä, Yesuea Saimono Fidama nabahalea, Yoneïe malö Saimono-o, odoa gowe ilia ne boba hamose amo gadola made, dia baagila awäla, ne dofä gelola boba hamosalela nabi. Amala nabasebegi, Fidaea ema säla obëgësalea, Ü, Dafidilo Geloi, na di boba hamose amoda, dia dawamelëla säi. Amala säsebegi, Yesuea ema sähalea, Nïe sugua sibi malö amoli molö ïaha namialola säi. ");
INSERT INTO etr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuea ema bu agedu nabahalea, Yoneïe malö Saimono-o, dia ne dofä gelola boba hamosalela nabi. Amala nabasebegi, Fidaea ema sähalea, Ü, Dafidilo Geloi, na di boba hamose amoda, dia dawamelëla säi. Amala säsebegi, Yesuea ema säla obëgësalea, Nïe sugua sibi amoli sigi namialola säi. ");
INSERT INTO etr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuea aso, bu osoda ema nabahalea, Yoneïe malö Saimono-o, dia ne boba hamosalela nabi. Yesuea bu ohodoala dia ne boba hamosalela nabi amogi, Fida e asigia yöia idogolahilä, Yesuma sähalea, Dafidilo Geloi, nelebo sulubadela dia dawadigisa maadei neebe amo, na di boba hamose amoda, dia dawamelëla säi. Amala säsebegi, Yesuea ema sähalea, Nïe sugua sibi amoli molö ïaha namialo. ");
INSERT INTO etr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na dima dofä gelola sähago. Di malïsä nelo amogida, dïe malibu negelahilä, dihï moholö helësëse amo gadola nawesa aligilomelë. Gaso, di momaeala fia idogose amo gaaluda, dïe naabo mogodigia gasegi, dolö odoaea di malibu negesilahilä, dia moholö helësëi madeido amogi sigi moholömelëla säi. ");
INSERT INTO etr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuea ado amala säi amoda, Fida e abeahämola hamola baagola, Godeïe ëi ilibia amo gauia adamolö amoïe helësëla amala säi. Amala sälahilä, Yesuea Fidama sähalea, Di ne bëgëla misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Fidaea besula beahamelebe, bëgëla aulo Yesu hï boba hamolo amo, ele bëgëla maaha neebe melï. Dolö amoda dafidi ili molö naha sefolalo amo gala, Yesuïe bidagia golögïa alogola nabahalea, Dafidilo Geloi-e, nowëa di hololömolö gabula sälo amo maaha neebe melï. ");
INSERT INTO etr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Beahamelebe e gabugi, Fidaea Yesuma nabahalea, Dafidilo Geloi, dolö gowedala nabi. ");
INSERT INTO etr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Amala nabasebegi, Yesuea ema säla obëgësalea, Ne obëgësalea e namolöi namiäiala hameseda, amoda dïele. Dida ne bëgëla misiëla säi. ");
INSERT INTO etr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amalebe, odoa ilia sähalea, Bëgëla aulo go made baagomolöla säimelëla edoolalima säla daidoi. Gaso, Yesueada e made baagomolömelëlada made säi. Ea sähaleada, Ne obëgësalea e namolöi namiäiala hameseda, amoda dïelela amomu amala säi. ");
INSERT INTO etr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Bëgëla aulo amea nelebo ea melï amo hï säla ulufadigisa nea, amala hamoi amo hï bebagi dëdëla negei amoda amomelë. Nilïa ea säla ulufadigi amoda dofä gabula helësësamelë. ");
INSERT INTO etr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuea hamoi elö elöla yafie hamoimelë. Hamoi amo hïdo hïdola hulu sulubadela dëdëla negesa maadei galebeda, sege dibe sulubadelagi beba yafie hamoi amo negemolö fu made bealabiola helësësamelë. Hä amo. ");
INSERT INTO etr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Diofilasa-o, dafidi na bebagi dëdëla negesaleada, Yesuea hamoi amoge, olelei amoge dafidi mi gäwia amila e selesaia mosöa fedala asi segeyo amoge dëdëla negesa maadeimelë. Fedala made nea, ea Eleloi Gesamiïe geloia abosolo dolö namiäia memelei amolima gomalä hamomalo, gomalä sämalola säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu së naala baagolahilä, bu nowela abosolo dolö amolia e dofä nowei gabula helësëmäia e ulufadigila segeyo nabülasi biyidia ilibalä nea, Godea Beaha Maadela Sigi Neebe amoïe ilima säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","E, aso, ilibalä nea ea ilima sähalea, Dilia Yalusaleme dïgïla mosabio. Naadoea ïmolömelëla säla negeila na dafidi dilima säla ï amo ïmäia, gui beaha namialo. ");
INSERT INTO etr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoneada ödäea gesa nelomelë. Segeyo ede made nelolahilä, dili Eleloi Gesamia gemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Amo gala, ili gegedolahilä ema nabahalea, Dafidilo, Isilale udia dolö nilïa nihïlï beaha namolö, nihïlïma ïa obëgëmolö walio gogilela nabi. ");
INSERT INTO etr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Amala nabasebegi, Yesuea ilima säla obëgësalea, Naadoea hï asigia segeyo daiala negei amoïe dawada, dilile made. Segeyo amo daialoda Naado hïdomumelë. ");
INSERT INTO etr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amai gaso, Eleloi Gesami e dili neebea gui maala, ïe geloia dilile isogi nobamolömelë. Amala hamoseda, nïe Ado Mala Hedabi gaula Yalusalemege, Yudiamadige, Sameliamadige, sege föi sulubadelagige olelesa nawesa namolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ea ado amo säha maadelahilä, ilia ami beaha nebegi, e neala gauia adala selesaia mosöa fedai amo baidilia hagui amea, bu elö bimolöi made melï. ");
INSERT INTO etr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","E fedala awäse amo gaalu, ilia muugi sisila nebegimu, dolö fagulo falei salugai äudä fodolofalï maala ilibalä neebe melï. ");
INSERT INTO etr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Amolea ilima nabahalea, Galili dolöla dili-e, mi edoïe muugi sisilamu dialeala nabi. Amala nabalahilä elea sähalea, Yesu goda walio dili dïgïla, e neala gauia adogola selesaia mosöa fedasebe amoda obëgëmolö. E selesaia mosöa awäsebe dilia melï amo gadoi wäla obëgëmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Amala säsebegi, ili segebi ëi Olibebidaia amila Yalusaleme obëgëi. Segebia amila Yalusaleme ga madefalï, Yu udia dolöea segeyo Sabada gafegi nawelo amo gadoi. ");
INSERT INTO etr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ili Yalusaleme besela galalahilä, mosö iso daia hogoli hili fisia ami fedala nogila digai. Amolida Fidage, Yonege, Yamesege, Äduluge, Filibige, Domasage, Badolomiuge, Madiasige, Alibiasaïe malö Yamesege, Selodo sosogo Saimonoge, Yameseïe malö Yudasage. ");
INSERT INTO etr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dolö amolia Godema adomolö ili gegedosamu aligilo. Udia odoage, Yesuïe eme Melige, ïe edoolalige ilibalä amala gegedolo. ");
INSERT INTO etr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Amo gala asigi afädë negei sulubadela gegedolada hädali afädëïe nabülasi äudä gadoi sefolalebegi, Fidaea nowela nea sähalea, ");
INSERT INTO etr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nedoola dili-e, Godeïe ado siiba säla dëdëla negei amo dofä gausiala digamolömelë. Yudasaea dolö nefolalo amolia Yesu gaumäia idi olei amoïe Eleloi Gesamia Debidima aligilahilä bea säla negei amo gadola dofä gausiala digaimelë. ");
INSERT INTO etr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudasada nilï sosogo nelo. Nihïlïgïla hamoi gegedola hamomolöïe e memeleimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudasa hï nafade hamola muni nii amea sege afädë nofela nii. Amala hamola sege niia ami baagola digala bole dusula gahidado besela galai. ");
INSERT INTO etr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Amo hamoi amo hobeala Yalusaleme nefolalo amolia nabaha maadei. Amalebe sege amoïe ëi ilile ado sälada Ageledama negei. Nilïle ado sälada heale sege.) ");
INSERT INTO etr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Fidaea sähalea, Gë Udälo bebagi ado afädë säla negei amo gowe. Ïe mosö nalämäia. Mosö amogi afädë made midiäiala säla dëdëla negei dialea. Amase, ado elö säla negei dibe amo gowe. Hamoi ea hamolo negei amo elöea hamola bedefamäiala säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Amai gabugida nilïa dolö elö gowe gadoi memeledelä. Amoda Dafidilo Geloi Yesu afu mafusa nelo amo gala nilïbalä nawelo. ");
INSERT INTO etr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yonea ödägi gese melëlo, Yesu neala gauia adala fedai melëlo nilïbalä nawelo. Amea nilïa e dofä baagola noweila dawadigi amo nilïbalä sämolöïe memeledelä. ");
INSERT INTO etr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Amala säsebegi, ilia dolö äudä ëi säla negei. Dolö elö amoïe ëida Yosebe, odoaea ïe ëi Basabasala sälo, odoaea Yasadusila sälo nelo amo. Amase, elö amoïe ëi Madiasile säla negei. ");
INSERT INTO etr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Amala sälahilä, ilia Godema adosalea, Dafidilo Geloi, dia sulubadelaïe iso beaha maadei. Dolö äudä memelei amolegi afädëa Yudasaea abosolo hamoi idiadolasia amila bedefamäia dia afädë memelei amo olemalo. Yudasa eda hï segea awähalea abosolo hamoi dïgïla asi gabiola säi. ");
INSERT INTO etr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Amala Godema adolahilä, elele ëi dëdëla salalahilä fofogolebe Madiasiïe ëidale besela galasebegi, abosolo gïdälasi amolibalä giwi e baala namiäia memelela ifosi. ");
INSERT INTO etr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yu udia dolöïe molö nülo segeyo ëi Bëdigosi besela galasebegi, ili sulubadela mosö afädëgi gegedola sefolalo. ");
INSERT INTO etr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Amala gegedola sefolalebegi, fo geloiïe goba gadoi aabela guula maalahilä, mosö ili fifigi sebea ami digala nobai. ");
INSERT INTO etr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Amala digala nobalahilä, nulo söale elïle gadoi moge mogela ili sulubadela hïdo hïdolama aliligisebe melï. ");
INSERT INTO etr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Amalahilä Eleloi Gesamia udia dolö amoli sulubadelama nobalahilä, ilia fii odoaïe ado säla besela gagalamäia Eleloi Gesamia sälasisi. ");
INSERT INTO etr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yalusaleme ami Yu udia dolö Godeïe mala nabelo sege föi sulubadelagi nefolalo amoli bobala asi ami sulo. ");
INSERT INTO etr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Udia dolö amolia goba amo nabalahilä, ili sulubadela gegedoi. Gegedoi amolia hïdo hïdolaea nabelebe, ilile ado sälo amo gadola säsebe amo nabalahilä, ili sulubadela fudugi. ");
INSERT INTO etr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Amo nabala, ili edefademalä fudugilahilä sähalea, Wae! Nilïle ado säla säha dibego ilida Galili dolö madefa. ");
INSERT INTO etr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ilia nilïle ado elö elöi amo säsebe nihïlï nabasebeweda, abeahäladu. ");
INSERT INTO etr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nilï Badialage, Midialage, Elamalage, nilï Mesobodemia dolöge, Yudialage, Gabadosialage, Bödasalage, Esialage, ");
INSERT INTO etr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Filigialage, Bäfilialage, Isibilage, Libiaïe sege Sailinimadilage, Olomola söfë misi amolige, ");
INSERT INTO etr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yu udia dolöge, udia dolö odoaea Yuïe mala gaula mogolo amolige, Gilidilage, Alebialage, nilï sulubadela nefolalebewema, ilia nihïlïle ado adola, Godea hamoi edefade hamoi amoïe säla ïasebegola säi. ");
INSERT INTO etr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ili fudugila asigi säosäolahilä sähalea, Goda edodula säla didigai. ");
INSERT INTO etr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Odoa nefolalo amolia gadiabola sähalea, Wani ödä gähe hamola negei amo edefadela naala gagaosebegola säi. ");
INSERT INTO etr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Amala säi amo nabalahilä, Fida e abosolo gïdälasi amolibalä nowela nea ea ilima ado gelolafalï sähalea, Yu dolö dilimage Yalusaleme nefolalebe dilimage, amo hamoi amo säla ïdulä. Nïe ado hedabola nabualo. ");
INSERT INTO etr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dilia dolö gowe ili gagaosebela helësëi amoda amai mademelë. Segeyo walioda, aso, yosemelë. ");
INSERT INTO etr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Go hamose goda dafidi bea sälo Yoalea säla negei amo gausiahamelë. Eada gomalä säla negei. ");
INSERT INTO etr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Godea sähalea, Segeyo aligila wagamolö ga madese gaaluda, na nïe Gesami udia dolö sulubadelama söga salimolömelë. Dilile didiwi diefegelalia nïe mala olelesa namolömelë. Amase, dilile malö malïsä amoliage sosoäla awäla elö elöla bimolömelë. Amase, dolö asigi fädäi dafidi neebe amolia simasimolömelë. ");
INSERT INTO etr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Segeyo amogimu nïe hamoi hamolasilo udia dolö amolimage na nïe Gesami söga salimolömelë. Ilia nïe mala olelesa namolömelë. ");
INSERT INTO etr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na muugi adogo hïdo elöi hamolasila naga föidaiage dolöea hamomolöi made gadoi hamolasimolömelë. Healege nulo söage höba buguge hamomolömelë. ");
INSERT INTO etr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Amase, Dafidilo Geloiïe Segeyo Edefademalä besela galamolö amo, aso, made besela galala neëgi, esoge usila aubege bëlahilä heale uii besela galamolömelë. ");
INSERT INTO etr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amala hamosegi, Dafidilo Geloia ili ugila negemäia, ïe ëi säla welo nefolalebe amoli sulubadelada, ea ili damula moholömelëla Godea säila Yoalea säla negei amo Fidaea säi. ");
INSERT INTO etr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Fidaea sähalea, Isilale dolöla dili-e, ado sähago. Nabualo. Nasalese fii Yesuea geloi melëlo made gadoi hamolage, hïdo elöi hamolage, dolöea hamomolöi made gadoi hamolage, Godea Yesuma aligila dilibalä nea amala hamoi. Amala hamoi ameada e Godea odala ïala hamoi amo hamomolö misi amo olei. Amoda dilia dawadigi nebego. ");
INSERT INTO etr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dolö amoda gaula ïmolömelëla Godea dafidi daiala negei amo gadola hamomäia fisigisi. Dilia e baagomäia dolö nafade hamolo nefolalo amolia e i fügäigi baala negemäia hamolasi. ");
INSERT INTO etr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Baagoia e nafodomolö ulï amea Godea baago amoïe sëa e fisigisimäia e nowela ifosi. ");
INSERT INTO etr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Debidiage ïe helësëla säi amo gowe. Na beahamelebe Dafidilo Geloi e nebalä ga madefalï namolöi namolö misi neebe melï. Nafadea ne neala fologolasiloea, ne gelolasimolöïe e nïe naabo dafädimadi ga made misi nea. ");
INSERT INTO etr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Amalebe nïe isogi edefade obeägïlo nobalahilä na obeägï ado säi. Amase, nïe domalogi hamomolö amo hamomäia na beaha namolö. ");
INSERT INTO etr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dia nïe gesami baagoi uguli mosöa ami dïgïla made moholö. Dïe hamoi hamolasilo dihï memelela odai amo bauia ami made sïgämolömelë. ");
INSERT INTO etr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dia ne namolöïe idi oleimelë. Dia nebalä namolöi nebegoeada ne obeägïlo nobalahilä obeägïsa namolöla Debidia säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Fidaea amala sälahilä sähalea, Nedoola dili-e, nilïle mäu Debidiïe, na dilima fädäla sähago. E baagoige bauige. E baui amo nilï mia wi walio dialea. ");
INSERT INTO etr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dafidi eda bea sälo nebegi, Godea ema ado dofä gelola säla negesalea sähalea, Hobeafalï dïe mäu afädëa beaha aligilo filodaia samialamolömelëla säla negei amo Debidi hï dawadigi nelo. ");
INSERT INTO etr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Godea Afädë Memelei amo baagolahilä nowela ifosimolö amoïe Debidia bea sähalea, Ïe gesami uguli mosöa dïgïla made moholö, ïe domalo bauia ami sïgämolö madela bea säla negei. ");
INSERT INTO etr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Amaimo, Yesu amoda Godea nowela ifosi. Amo nilïa beaha maadei amo säla ïahamelë. ");
INSERT INTO etr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Godea Yesu neala gauia adala fedalasila ïe naabo dafädimadi ifosilahilä, Eleloi Gesami ï. Eedoea Gesami ïmolömelëla dafidi säla negei amo ï. Ea amo walio söga sali amo dilia siia beala gëhea nabi amomelë. ");
INSERT INTO etr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Debidi eda selesaia mosöa fedai made gaso, ea säla negesalea sähalea, Dafidilo Geloia nïe Dafidilo Geloima sähalea, Na dïe ado nii nefolalebe amoli di hawala ifosimäia, dida nïe naabo dafädimadi awäla salea, beaha samialola säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Fidaea amala sälahilä sähalea, Isilale udia dolö nefolalebe dili sulubadelaea hedabola helësëmalo. Yesu e dofä dilia i fügäigi baala negei amoda Godea e Dafidilo Geloi namiäiage Afädë Memelei namiäiage ifosi amo hedabola helësëmalola Fidaea säi. ");
INSERT INTO etr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ado säi amo nabalahilä, ilile isogi awäla gäwilebe Fidala abosolo odoa amolima nabahalea, Nedoola dili-e, nilïa abilia hamomolödula nabi. ");
INSERT INTO etr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Amala nabelebe Fidaea säla obëgësalea, Dili asigi besula hïdo hïdola Yesu Gelesoïe ëigi ödägi gemalo. Amala hamosegida, dilia nafade hamoi amo hëla digila diligali Eleloi Gesami ïmolömelë. ");
INSERT INTO etr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Godea ïmolömelëla säla negei amo gadola dilimage, dilile malö amolimage, udia dolö wagadi made nefolalebe amoli sulubadelamage ïmolömelëla säla negei. Dafidilo Geloi Godea e neebea misiäia wemolö amoli sulubadelama ïmolömelëla säla negeila Fidaea säi. ");
INSERT INTO etr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Fidaea ado geloi odoage häila nabulöi hamoi odoage ilima gelola säla ïalahilä sähalea, Udia dolö nafade memelela made sulubadela hamolo walio nefolalebe welia së molö amogi dilila nüloea fisäla awäla asigi besumalola säi. ");
INSERT INTO etr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ea amala säi amo hedabola häila nabi amoli ödägi gei. Segeyo amo gala udia dolö dausini ohodoa baai. ");
INSERT INTO etr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abosolo dolö amolia mala olelei amo bëgëla hamola digi, Geleso sosogo odoabalä dila nea, molö gedola nadigi, Godema adola digi, amo sulubadela ilia gelola hamosamu nelo. ");
INSERT INTO etr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Udia dolö sulubadela fudugila bedäi. Godea abosolo dolö amolima aligila hïdo elöi hamolasila, dolöea hamomolöi made gadoi hamola nawei amogi. ");
INSERT INTO etr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Amase, asigi afädë negei nefolalo amolige afädëdi nelo. Hïdo hïdolaïe nelegei dilo amoda, ili sulubadelaïe ua gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Segege, nelegeige bidi nealahilä, mogela nelegei made amoligali ïlo. ");
INSERT INTO etr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Amase, segeyo sulubadelagi ilida Godeïe mosöamu gegedolahilä, hilile mosöa afufusa neada ilile iso asigi falagasei nea hiligila obeägïla molö gegedola naala, ");
INSERT INTO etr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Godeïe ëi gauia adaha neebe amo bealahilä, udia dolö nefolalo amoli sulubadelaea obeägïla melëlo. Segeyo sulubadelagi Dafidilo Geloia odoa asigi afädë negei amolida neala baalasi. ");
INSERT INTO etr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Segeyo afädëgi eso digase gaalu, Fida Yonele Godeïe mosöamadi asi. Deadi amo gadola ilia Godema adosa aligilo negei. ");
INSERT INTO etr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Amaimo, dolö afädë, ïe emea neegela ägüsolo amo gala emo nafadei amo gadoi neegela ägüi, amo ilia sogobala gaula awäla Godeïe mosö idi nogila digalo Aye Negei dibea ami ifosisa aligilo. Segeyo sulubadelagi ea Godeïe mosöa digasebe amolima muni ïmola sämäia ifosilo. ");
INSERT INTO etr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Fida Yonele Godeïe mosöa nogila digasebe amo bealahilä ea elema sähalea, Alia ne muni ïmola säi. ");
INSERT INTO etr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Amala sälebegi Fida Yonelea ema siila nea Fidaea sähalea, Alïma bimola säi. ");
INSERT INTO etr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Amala sälebegi e ïmolö gabula helësëla ea elema si. ");
INSERT INTO etr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amala sisebegi Fidaea ema sähalea, Muni afädë gaui mademelë. Amai gaso, afädë gaui amo digali ïahago. Nasalese fii Yesu Gelesoïe ëigi säha, di nowela nawemola säi. ");
INSERT INTO etr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amala sälahilä ïe naabo dafädi amo nabelela gauia adalasisebegi, ïe emo fodolofalï neala gelolasi. ");
INSERT INTO etr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nowela nila sadia adodogola asi. Amala awäla elebalä Godeïe mosöa nogila digala, Godeïe ëi gauia adala emo gumu sesegegila nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Udia dolö nefolalo amoli sulubadelaea e Godeïe ëi gauia adala awäse amo bealahilä ");
INSERT INTO etr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ilia helësësalea, Godeïe mosöa nogila digalo Aye Negei dibea ami salea muni ïmola säha filo amo gabula helësëi. Ema hamoi amo bealahilä ili hame galalaia fedala fudugi. ");
INSERT INTO etr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Dolö amea Fida Yonelema gaula fëdöla nebegi, udia dolö nefolalo amoli fudugilahilä, Godeïe mosö hadai dibea ami baluluia mafui. Hadai amoda Solomonoïe hadaila sälo. ");
INSERT INTO etr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Fidaea udia dolö mafui amo bealahilä, ea ilima sähalea, Isilale dolö dili-e, amo hamoi amogi dili fudugilahilä alïma sisila dibegoda edoïe. Amai dilia helësësaleada, alïle geloiage Godeïe mala mogola gaula neebeweage alïa dolö gowe nowela ifosila helësësale. ");
INSERT INTO etr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abalahamage Aisagage Yeigabage, nilïle mäuge ilile Godea ïe hamoi hamolasilo Yesuïe ëi ilibiamäia neala gauia adalasi. Dolö amo dilia dilile beaha aligilo neebea sigi gaula asimelë. Bailadi neebea sigi awäsebegi, Bailadia e fisigäla fisiga gamolö hamosebegi, diliada ema baagi ïala golala melïmelë. ");
INSERT INTO etr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dilia dolö hedabi mogoifalï hïdo elöi amoma baagi ïala golala bealahilä, dolö nufidelo amo fisigämola säla didigai. ");
INSERT INTO etr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Udia dolögali Namolö Gaumäia Ïlo amoda baagomäia nufimelë. Amo baagolahilä Godea bauia amila neala nowela ifosi neebe amo alïa siia melïmelë. ");
INSERT INTO etr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesuïe ëigi asigi afädë negei amea Yesuïe ëia dolö dilia beala dawadigi amoma geloi ï. Yesu hï alïle asigi afädë negei neala nowelasimelë. Asigi afädë negei amea dili sulubadelaïe siigi e wahilasimolöi wahilasimelë. ");
INSERT INTO etr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Amai gabugi, nïe nedoola dili-e, dilia Yesuma hamoi amo fädäla helësëla made nea hamoila helësësa. Dilile beaha aligilo amoliage amala hamoila helësësamelë. ");
INSERT INTO etr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amo gadola siibafalï Gode e bea sälo sulubadela nefolalo amolima aligilahilä nea, ea Afädë Memelei amo së molömelëla bea säla negei amo gadola amala gausiala digai. ");
INSERT INTO etr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Amala hamoi gabugi asigi besula dilile nafade hamoi amo hëmäia Godemadi namialo. ");
INSERT INTO etr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dilia amala hamoseda, dilile gesami gelolasimolöïe Dafidilo Geloia e neebeala fu ïmolömelë. Amase, Afädë Memelei amo dilile namiäia dafidi odalasi Yesu amo dili neebea fisiga wemolömelë. ");
INSERT INTO etr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Siibafalï Godea bea sälo hïle nafolai amolima aligila bea säla negei amo gadola, Godea sulubadela bu elö gähe namolö segeyo daiala negei amo gadola gausiala digamäia Yesu e selesaia mosöa beaha nea. ");
INSERT INTO etr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Siiba Mosesea sähalea, Dafidilo Geloi Godea dilile didoomadila aligila afädë bea sälo ne gadoi dilile bea sälo memelela ifosimolömelë. Amala aligiseda, dilia ïe ado nabala bëgëla awäla hamomalo. ");
INSERT INTO etr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ïe ado nabalahilä made hamose dolö amolida Isilale udia dolö amolibalä made namiäia nufudala baagomolömelëla Mosesea säi. ");
INSERT INTO etr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Amo gadola bea sälo sulubadelaea, Samuale neloa amila, bea säla negesalea segeyo waliowegi hamosebeweïe bea säla negei. ");
INSERT INTO etr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dilida bea sälo amolile malöge, amase, Godea dilile mäuma asialo made ado elöi säla negei amoïe malöge nebego. Godea Abalahamama sähalea, Dïe mäuma aligila udia dolö fifi asi dibe amoli sulubadela neala obeägïlasimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Amaimo, Godea Yesu e ïe hamoi hamolasilo namiäia diligalidale fisiga wei. Fisiga wei amoïe mida gowe. Dilia nafade hamosa neebea amila ea sigi gaula obëgëlahilä obeägïlasimäia fisiga weimelëla Fidaea säla wagai. ");
INSERT INTO etr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Elea udia dolöma säla ïaha nebegi, gobela ïlo dolö nefolalo amolige, Godeïe mosö idihë aligilo amolile beaha aligilo amoge, Sadiusi nefolalo amolige ele neebea misi. ");
INSERT INTO etr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Elea udia dolöma Yesu baagola nowei amea baagoi amoli nowela namolömelëla säla olelesebegi, ili mihaläla misi. ");
INSERT INTO etr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ili maalahilä ilia ele gaula nafodolahilä amo gala gasisebegi, aiyo gudimolölahilä galabaia mosöa negei. ");
INSERT INTO etr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amaimo, elea säla ï amo yafiea nabalahilä asigi afädë negei. Hä dolö asigi afädë negei amoli gedolada dausini bia. ");
INSERT INTO etr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Segeyo elö aligisebegi, ilile beaha aligilo amolige, asigi gäwi dafidilo amolige, mala dawadigi amolige ili Yalusaleme gegedoi. ");
INSERT INTO etr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gobela ïlo busa edefade Anasage, Gaiafasage Yonege Alegisädage, gobela ïlo busa edefadeïe sosogo nefolalo amolige sulubadela gegedoi. ");
INSERT INTO etr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ili gegedoi sebea ami ele ifosilahilä elema nabahalea, Alia hamoi amo edo geloia, nowëïe ëigila hamoila nabi. ");
INSERT INTO etr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Amala nabasebegi, Fidama Eleloi Gesami nobai nea ea ilima säla obëgësalea, Udia dolöïe beaha aligiloge, asigi gäwi dafidilola dili-e, ");
INSERT INTO etr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","amai dilia walio alïma mi nabi amoda alïa dolö emo nafadei afädë ugila negei amoïe nabi galëda, amai dilia helësësaleada, dolö emo nafadei amoda abeahäla hedabomolöi gabu. ");
INSERT INTO etr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Amai galëda, dili sulubadelaeage, amase, Isilale fii sulubadelaeage, mi fädäla helësëmolö dialea. Nasalese fii Yesu Gelesoïe ëia dolö wagadi nebegowe wahilasimolöi wahilasi amo dihili beasebegomelë. Dilia Yesu Geleso i fügäigi baala negei amo Godea bauia amila nowelasi amoda amo. ");
INSERT INTO etr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Igi amoda mosö olelo dilia galone hamomolöi made gabulahilä, memelela fisi amoda, galone geloi dafidilo besela galai dibeda amomelë. ");
INSERT INTO etr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Elöea damula moholöi made neamelë. Sege föi sulubadelagi neebe amola nilï damula moholö udia dolögali ëi elö made ïmelëla Fidaea säi. ");
INSERT INTO etr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ilia beahamelebe Fida Yonelea gelolahilä bedäla made säsebe amo beala ele sugulu made hamoi, nelebo afädë oodo bealage made hamoi dolö nelo amo helësëlahilä ili fudugi. Fudugilahilä gaso, ilia helësësalea, ele Yesubalä neë melëlo amo helësëi. ");
INSERT INTO etr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amala helësëlahilä ilia beahamelebe emo nafadei dafidi wahilasi amo elebalä neebe amo bealahilä, elema ado säla obëgëmolöi made melï. ");
INSERT INTO etr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Amalebe ilia ele Galïsolö mosöa amila segea oodola doadigila mosalai. Ele asibua hilido didiäla ");
INSERT INTO etr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","sähalea, Nilïa malö äudä amolema abilia hamomolödu. Elea dolöea hamomolöi made gadoi afädë gelola hamoi amoda udia dolö Yalusaleme nefolalebe amolia dawadigisa maadei. Elea amala made hamoila sämolö ulï gabu. ");
INSERT INTO etr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amaimo, säla daidoloea, nilïa ele nufulöïe sähaleada, elema ëi go säla udia dolö odoama bu säla ïmabiola gelola sädila säi. ");
INSERT INTO etr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Amala sälahilä ele welahilä ele maasebegi elema gelola sähalea, Alia Yesuïe ëi säla udia dolö odoama amala olelemabiola säla ï. ");
INSERT INTO etr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amala säsebegi, Fida Yonelea säla obëgësalea, Godeïe siigi, alïa dilia säse go gadola nabala hamomolö amo dofeale ma, Godea säsebe amo gadola nabala hamomolö amo dofeale. Dilia memelemo. ");
INSERT INTO etr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Amai gaso, alïa melï amoge nabi amoge sämolö amo, made sämolö ulïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Amala sälahilä ilia elema säi amo gadola bu elö ele nufulöïe ado gelolafalï säla ïalahilä ele nufulö fu made beasebegi fisigäla fisiga gai. Fisigäi amoïe mida, udia dolö nefolalebe amoli sulubadelaea Godea hamoi amoïe ïe ëi gauia adaha neebe amo helësëlahilä amai. ");
INSERT INTO etr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dolöea hamomolöi made gadoi hamola dolö wahilasi amo eda gäheo i nabülasi biyidia baagi nelo. ");
INSERT INTO etr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fisigäsebegi Fida Yonele helele sosogo neebea obëgëlahilä, gobela ïlo busa amoliage, asigi gäwi dafidilo amoliage, elema ado säi amo elea ilima säla ïaha maadei. ");
INSERT INTO etr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Säla ï amo nabaha maadelahilä, ili sulubadelaea hame afädë negela Godema adosalea, Dafidilo Geloi-e, muge naga föige ödä duhuluge nelebo sulubadela amoligi dibe neebe sebe amoge dia hamosa maadei. ");
INSERT INTO etr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Siiba nilïle mäu Debidi, dïe hamoi hamolasilo amoma aligila Eleloi Gesamia ado säi amo gowe. Edoïe udia dolö fii odoa ilia edefademalä mihalähamu nea. Edoïe udia dolö amolia nalï ado afädë negesamu nea. ");
INSERT INTO etr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sege sulubadelaïe beaha aligilo gini nefolalo amolia nudumolöïe daiala nefolalo. Beaha aligilo gini amolia gegedolahilä Dafidilo Geloi amoge ïe Afädë Memelei amoge daia sasagala neala golila säi. ");
INSERT INTO etr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Amo gadola Heledoeage Bödiasa Bailadiage elebalä udia dolö fii odoaeage Yu udia dolöeage dofä gaamu gowegi dïe hamoi hamolasilo hedabifalï Yesu, dia memelei amo, daia sasagala neala golimolöïe gegedoi. ");
INSERT INTO etr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ilia amala hamoi amoda dafidi dïe geloiage asigiage daiala negei amo gadola gausiala digai. ");
INSERT INTO etr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Amaimo, Dafidilo Geloi-e, ilia nilï nufulöïe ado gelola säha nelo amo dia walio asigimalo. Dïe hamoi hamolasilo nilïa bedäla made, gelola nea, dïe ado mala säla olelemolöïe geloi ïmalo. ");
INSERT INTO etr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Amo gala oloi dibe amo wahilasimolöïege, dïe hamoi hamolasilo hedabifalï Yesuïe ëia dolöea hamomolöi made gadoi hamolasimolöïege hïdo elöi hamolasimolöïege, dïe naabo mogodigimalola säla adoi. ");
INSERT INTO etr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Godema adola wagai amole mosö ili gedola sefolalo amo fogola Eleloi Gesamia ilima nobasebegi, ilia Godeïe ado mala bedäla made gelola säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Udia dolö Yesuma asigi afädë negei nefolalo amoli sulubadelaea hame afädë negela asigi afädë negela nelo. Amala negela neada afädëa ïe nelegei dibe amo bealahilä goweda nïemelëla sälo made, hïdo hïdolaïe nelegei dilo amoda ili sulubadelaïe ua gadoi dilo. ");
INSERT INTO etr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abosolo dolö amolia gelola nea Dafidilo Geloi Yesu baagolahilä nowela neala gelola säla olelesa nelo. Godea ili sulubadelama edefademalä obeägïlasilahilä hedabola ugila negesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ili sosogo nefolalo amoligida nelebo afädë ufoida made. Ilile sosogo odoaea segege mosöge munia bidi nealahilä, ");
INSERT INTO etr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","abosolo dolö amoligali ïlo. Amala ïalahilä abosolo dolö amoliada udia dolö odoa ufola adi nefolalebe amoligali mogela ïlomelë. ");
INSERT INTO etr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Amo gadola dolö afädë nelo amoïe ëida Yosebe. Ïe ëi elö abosolo dolö amolia negeida Banabasa. (Banabasa amoda ado gowe gadoi. Iso asigi neala gelolasilo dolöla säla ëi negei.) Banabasada Ilibai sosogo nelo. Eda ödä södölogi Saibulusi fii. ");
INSERT INTO etr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Amea ïe sege afädë dolö elöma muni nii amoda gaula maala abosolo dolö amoligali ï. ");
INSERT INTO etr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amala hamolo amo gadola dolö afädë Ananaiasa ïe udia Safailalea elele sege dilo amogi dolö afädëma bidi nii. ");
INSERT INTO etr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Muni bidi nii amo Ananaiasaea mogela odoa hïle negesi. Ïe udiaeage amo dawadigi sulo. Amalahilä Ananaiasaea muni odoa amo gaula awäla abosolo dolö amolima ï. ");
INSERT INTO etr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ïasebegi Fidaea Ananaiasama sähalea, Dia Eleloi Gesamima wäfalï sämolöïe mugabe Saidani dïe isogi nobamäia fu ïgo edoïe. Dia dïe segeïe bidi nii muni amogi odoa dihïle negei gabu. ");
INSERT INTO etr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sege bidi made nealada dihïle dilo madele. Bidi nealahiläda bidi nii amoge dihïle madele. Dïe isogi amala hamomolö helësëi amoda edoïe. Dia wäfalï säi amoda dolöma made, Godema säimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Fidaea säi amo nabala Ananaiasa ulula digala hame doala asi. Amala hamoimelëla säi amo nabelo amoli sulubadelaea edefademalä bedäi. ");
INSERT INTO etr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Amala hamosebegi, malïsäea baagoi amo faguloea usulala gaula awäla bausi. ");
INSERT INTO etr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aoa ohodoa baagibua egoama hamoi amo helësëla made idia amo misi. ");
INSERT INTO etr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Amala maasebegi Fidaea ema nabahalea, Nema sämo. Alia sege muni nii amoda hä amo wäla niilela nabi. Amala nabasebegi, ea säla obëgësalea, Ä. Alïa muni nii amoda hä go wälamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Amala säsebegi, Fidaea ema sähalea, Diage diguaeage ali haligilaea Dafidilo Geloiïe Gesamia abilia hamosebelela bimolöïe fedogola melï amoda edoïe. Digua baulo amolia dige gaula moholöïe mumusogi digamolöïe mosö idiliba maaha neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Amala säi amole fodolofalï Fidaïe emo mia ulula digala hame doala asi. Amala hame doala asi amole malïsä amolia maala e baagoi dibe amo bealahilä ilia ïe domalo segea gaula awälahilä egoa bauia amimu bausi. ");
INSERT INTO etr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Udia dolö Geleso sosogo nefolalo amolia edefademalä bedäla didigai. Amala hamoimelëla säi amo nabelo sulubadelaeage amai. ");
INSERT INTO etr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Udia dolöbalä nea abosolo amolia dolöea hamomolöi made gadoige hïdo elöige yafie hamosa nelo. Amoli sulubadelaeada hame afädë negela Solomonoïe hadai dibea amimu gegedosa aligilo. ");
INSERT INTO etr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ili gegedosebea amida udia dolö odoa nefolalo amolida ilibalä bedälo. Amala bedäi nea gaso, ili beahaleada ilile ëi gauia adaha aligilo nelo. ");
INSERT INTO etr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amalo gaso, udia dolö yafie nefolalo amolia Dafidilo Geloima asigi afädë negesa maadelahilä Geleso sosogo nefolalo amolibalä baai. ");
INSERT INTO etr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Amalebe oloi difolalo amoli gaula mafula idiafa Fida awäsido fëo fösisila nidila negela digi, dafudaia gaula maala nidila negela digi. Amoïe mida, ilia helësësaleada, Fida e maasegi, ïe ausuluboea oloi difolalebe amoli dabemäia amai. ");
INSERT INTO etr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sege odoa Yalusaleme ga madela dibeamadi amodila udia dolö yafiea oloi difolalo amolige mugabe fedai difolalo amolige gaula gegedosebegi, sulubadela neala hedabola wahila digisa maadei. ");
INSERT INTO etr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Amala hamosebegi, gobela ïlo busa edefade nelo ameage, amase, ebalä aligilo Sadiusi sosogo dolö amoliage naabo gëi. ");
INSERT INTO etr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Amala helësëlahilä ilia abosolo dolö amoli neala nafodolahilä gaula awäla galabaia mosöa negesi. ");
INSERT INTO etr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amala negesi dibegi gasigi Dafidilo Geloiïe selesaia fii afädëa galabaia mosö idi gai amo doga negesilahilä, ili sigi gaula segea doadigila fedalahilä ");
INSERT INTO etr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ilima sähalea, Dili afialahilä Godeïe mosöa nea namolö gähe goweïe mala sulubadela udia dolöma olelemalola säla ï. ");
INSERT INTO etr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Amala säi amo nabala abosolo dolö amoli yosefalï Godeïe mosöa ami awälahilä udia dolöma mala olelesa nelo. Gobela ïlo busa edefade nelo amoge ebalä aligilo nefolalo amolige maalahilä ilia ado sämolö Yu udia dolöïe dolö asigi gäwi dafidi nefolalo Galïsolö amoli gegedomalai. Gegedolahilä ilia sähalea, Galabaia mosöa amila dolö amoli sigi misiäiala säla ïmolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amala säsebegi, idihë aligilo amolia galabaia mosöa awälahilä beahamelebe, dolö amoli maade beala Galïsolö dolö amolima säla ïmolö obëgëi. ");
INSERT INTO etr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Obëgëlahilä ilima sähalea, Nilïa galabaia mosö idi fëdöla gai amoge idihë aligilo idi gasia nefolalebe amolige melïmelë. Bealahilä nilïa idi gai amo dogala beahamelebe ami dolö afädë sebege made melïmelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Amala säla ïasebe amo nabalahilä, Godeïe mosö idihë aligiloïe beaha aligilo ameage gobela ïlo busa amolaliage goea edo besela galamolödula helësëla asigia säosäosa dilo. ");
INSERT INTO etr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ilia amala asigi säosäosa dibegi dolö afädë maalahilä ilima sähalea, Nabuö. Dolö dilia galabaia mosöa negei amoliada Godeïe mosöa udia dolöma mala olelesa nefolaleamelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Amala säla ï amo nabalahilä, idihë aligiloïe beaha aligilo amola, idihë aligilo amolali awälahilä ili sigi obëgëi. Udia dolö nefolalebe amolia ili igia nufideloea bedälahilä, ilia ilima nelebo afädë made hamola, geleä awäla sigi obëgëi. ");
INSERT INTO etr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ili sigi obëgëlahilä Galïsolö dolö sefolalebea ami ifosi. Ifosilebe gobela ïlo busa edefade amea ilima sähalea, ");
INSERT INTO etr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nilïa dofä dolö amoïe ëi säla olelemabiola gelola säla ï. Amai gaso, nabuö. Mala amomu Yalusaleme udia dolöma säla ïasebegi ilia dilile ado nabaha maadei gabio. Amase, dolö baagoi amoge diliada nilïa nufila sämolöi nebegola säi. ");
INSERT INTO etr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Amala säsebegi, Fidala abosolo odoa amola ilia säla obëgësalea, Nilïa dolöea säse amo gadola made, Godea säse amo gadola hamomolöi galea. ");
INSERT INTO etr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dilia Yesu baagomäia iigi baala negei amoda nilïle mäuïe Gode neebe amea e nowela ifosimelë. ");
INSERT INTO etr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Eda Dafidiloge Damula Auloge namiäia Godea e gauia adala ïe naabo dafädimadi ifosi. Godea amala hamoi amoïe mida gowe, Isilale udia dolö asigi besumäiage nafade hamoi amo hëla fisimäiage fu ïmolöïe amala hamoi. ");
INSERT INTO etr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nilïage Eleloi Gesami Godea ïe mala hamolo nefolalebe amolima ïlo ameage amala hamoi amo dawadigila siia bealahilä säla ulufadigisa aligilo nilï nefolalebewemelëla säla ï. ");
INSERT INTO etr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Galïsolö dolö amolia ilia säi amo nabalahilä edefademalä habobala abosolo amoli baagomäia nufulöla helësëi. ");
INSERT INTO etr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amala helësësa dibegi, Galïsolö dolö sefolalebea amoligi afädë nowei. Eda Felesi dolö, eada mala säla negei amo olelelo. Ïe ëi Gameliele. Udia dolö nefolalo sulubadelaeada ëi sälo neala sälo nelo. Amea sähalea, Dolö go ili oodola segea namolö mosalamola säi. ");
INSERT INTO etr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Amala sälahilä Galïsolö dolö amolima sähalea, Isilale dolöla dili-e, dilia dolö go ilima nelebo afädë hamomolö helësësa galëda, dafididale fädäla helësëmalo. ");
INSERT INTO etr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Aso, sedade nelola made, Deyudasa e maalahilä ea sähalea, Neda dolö ëi sälomelëla säsebegi, udia dolö hädali biyidia gadoia e bëgëla afiai. Amai gaso, e baagomäia nufudasebegi e bëgëla aulo amoli dusudasisalea mala olelei amo hogosa helei. ");
INSERT INTO etr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Amase, hobeala gamanea udia dolöïe ëi dëdëselo amo gala, Galili fii afädë, ïe ëida Yudasa, misi. Maalahilä ïe adoea udia dolö yafie neaha maadesebegi, eege baagomäia nufudasebegi, e bëgëla aulo amoli sulubadela dusudasisa maadei. ");
INSERT INTO etr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Amaimo, walio na dilima säha, dolö go ilima afädë hamola made hä guilasimalo. Ilia daiai amoge hamoi amoge hili döfelëla hamosa galëda, amoda hogosa helemolömelë. ");
INSERT INTO etr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma, Godea hamomäia daiai hamosa galëda, dilia haimolö ulïmelë. Dilia Godebalä ado neloeamelëla Gamelielea säi. Amala sälebegi Galïsolö dolö amolia Gamelielea säi amo gadola hamodeläla helësëi. ");
INSERT INTO etr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Amala helësëlahilä, ilia abosolo amoli welahilä mofiasebegi, ili fëgämalai. Fëgälahilä Yesuïe ëi säla bu elöda olelemabiola sälahilä ili fisigäi. ");
INSERT INTO etr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Amalebe ili Galïsolö neebea amila obeägïla segea doadigila asi. Obeägïla asi amoïe mida gowe, Yesuïe ëigi hewai amo Godea dofeala helësëi amogi. ");
INSERT INTO etr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amalahilä segeyo sulubadelagi Godeïe mosöa amige udia dolö mosöa amige Ado Mala Hedabi olelesalea, Godea Afädë Memelela ifosi amoda Yesu neamelëla fisila made, säla ïahamu nelo. ");
INSERT INTO etr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Segeyo amo gaaluda, Yesu bëgëla aulo malei maala baahamu nelo. Giligi ado sälo amolia Alamege ado sälo amolibalä gëgësalea sähalea, Dilia segeyo sulubadelagi mogela ïlo amogida nilïle udia didalo sebe amoligali made ïlomelëla säla gëgëi. ");
INSERT INTO etr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Amala gëgësebegi abosolo giwilasi amolia Yesu bëgëla aulo odoa amoli sulubadela gegedomalolahilä ilima sähalea, Nilïa Godeïe ado amo fisilahilä molö mogemolö amo dofea made gabumelë. ");
INSERT INTO etr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Amai gabugi, nedoola, dilia dili nebegogi dolö gifalädalïa mogoi neala sälo, Godeïe Gesami nobai, hedabola dawadigi, amomu memelemalo. Memelelahilä, hamoi amo ilia sigi namiäia ifosidelä. ");
INSERT INTO etr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Amalahiläda, nilïamu Godema adosa namolö amoge udia dolöma Godeïe ado mala säla ïmolö amoge hamosamu namolölamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Amolia säi amo udia dolöea nabalahilä sulubadelaea dofea gabula säi. Amalahilä, ilia Sidibeni memelei. Sidibeni eda asigi afädë negelahilä gelola nea, Eleloi Gesamige ema nobai nelo. Amase, Filibige, Bologolusage, Niganologe, Dimonoge, Bamenasage, Nigolasage ili memelei. Nigolasa eda Ädiago fii. Eda Yu fii made gaso, dafidi Yu udia dolöïe mala neala gaulahilä ilibalä dila nelo. ");
INSERT INTO etr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dolö memelei amoli abosolo ili neebea sigi maala ifosisebegi, Godema adolasila ilia ilima naabo negesi. ");
INSERT INTO etr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Amala hamolahilä Godeïe ado mala säla daidoi. Yalusaleme ami Yesu bëgëla aulo udia dolö yafie, sämolö asusugai awäla baai. Gobela ïlo dolö yafieage Yesuïe mala gaula mogola asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Godeïe ugila negeloge geloige Sidibenima nobalasisebegi, e udia dolöbalä nea hïdo elöige dolöea hamomolöi made gadoige gelola hamosa nelo. ");
INSERT INTO etr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amala hamosebegi, dolö odoaea Sidibenibalä gëgësa nelo. Yu udia dolö amolile gedolo mosö afädë amoïe ëida Fisigäi Amoli Dilo Mosöla sälo amoligi nelo. Dolö amolida Salinialage Alegisädalialage misi. Ilibalä odoage Silisiala Esialage misi amoli sulubadelaea Sidibenibalä gëgësa nelo. ");
INSERT INTO etr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gëgësalea Eleloi Gesamia Sidibeni hedabola dawadigilasi amea ilia ado säi amea e aulo dabemolöi made nelo. ");
INSERT INTO etr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ilile adoea aulo dabemolöi made bealahilä, geleä hado musügä awälahilä dolö odoama sähalea, Sidibenia Mosesele Godele gagadela säse nabimelëla sämalola säi. ");
INSERT INTO etr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Amala säi amogi udia dolö nefolalo amoliage, asigi gäwi dafidilo nefolalo amoliage, mala dawadigi nefolalo amoliage habobala mihalälahilä, ilia Sidibeni sigi gaula Galïsolö dolö neebea ami asi. ");
INSERT INTO etr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Amalahilä, ema ilia wäfalï babala säsäla sämäia dolö odoa sigi maalahilä amolia sähalea, Dolö neebe egoweada sege Godea hïle nafolai goge, Ado säla negei dibe amoge gagadesamu nelomelë. ");
INSERT INTO etr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Eada gomalä säimelë. Nasalese fii Yesuea mosö go haila fisila, mala Mosesea säla negei amo nalaba maaha nelo nilïa nabaha neebewege neala bedefamolömelëla säi amo nilïa nabimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Amo säi amo nabalahilä, Galïsolö dolö sefolalo amolia Sidibeniïe odagi siila beahamelebe, selesaia fiiïe odagi gadoi neebe melï. ");
INSERT INTO etr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Amaimo, gobela ïlo busa edefade nelo amea Sidibenima nabahalea, Ilia ado säsebego dofä säsebelela nabi. ");
INSERT INTO etr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Amala nabelebe Sidibenia säla obëgësalea, Naado nedoola dili-e, ado sähago. Nabualo. Nilïle naua mäu Abalahama e Halana made awäla Mesobodemia nebegi, Gode yo digalo hïdo elöi amo Abalahama neebea maala besela galai. ");
INSERT INTO etr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Maalahilä ea ema sähalea, Dïe segege sosogoge dïgïla sege na olese amogi mosalola säi. ");
INSERT INTO etr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Amala säi amo nabalahilä, e Galadia sege dïgïla Halana namolö asi. Ïe eedo baagolahilä, sege walio dili neebea ami namiäia e Godea namolö mosalola säi. ");
INSERT INTO etr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amo gala ema sege fufu afädë nofela made ï. Sege afädë emo afädëa emesamolöige dofä made ï. Amai gaso, Godea sege amogi dige dïe diaua mäu ilige dili namiäia ïmolömelëla Godea Abalahama e malö maade nebegi säla negei. ");
INSERT INTO etr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Godea gomalä säi. Dïe diaua mäu amoli elöïe segea namolömelë. Ami gäheo i hädali biyidia galabaia hamoi gadoi hamolasisa neebe amo gaaluda, dolö elöea ili neala sëlasimolömelë. ");
INSERT INTO etr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amamolö gaso, ili galabaia hamoi gadoi hamomäia hamolasilo fii amolibalä na gudimolömelë. Gudilahilä ili sege amo dïgïla awälahilä, sege wegi nea nïe ëi gauia adamolömelëla Godea säi. ");
INSERT INTO etr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Amase, Godea asialo made ado elöi säla negei amoïe ea nofe negela Abalahamama gafodo damulasilo mala negei. Amala negei amo gadola Aisaga emea e ägülebeda segeyo gödögi Abalahamaea Aisagaïe gafodo damulasi. Hobeala Aisagaïe malö Yeigabamage amai. Amalahilä Yeigabaïe malö nilïle mäu giwilasi amolimage amai. ");
INSERT INTO etr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nilïle mäu gïdälasi amolia giwi afädë Yosebema naabo gëlahilä, eda Isibi segea galabaia hamoi gadoi hamolasilo namiäia odoama muni ïmolahilä muni nii. Isibi segea sigi asi gasoda, Godea e sigi nea ");
INSERT INTO etr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yöi elö elöla sulubadela dibea amila e damula awäla ugila negei. Isibi sege beaha aligilo gini Felauïe siigi, Godea Yosebegali hedabola dawadigilasiloge mala hedabi hamolasimäiage ï. Amo bealahilä, Isibi udia dolöge, amase, ïe mosö sulubadelage sigi namiäia Yosebe memelela ifosi. ");
INSERT INTO etr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Amalahilä Isibi sege sulubadelagige Gainana sege sulubadelagige sïdë i maasebegi, udia dolö edefade yösa nefolalo, nilïle mäu ilia molö abidi galea walebelela hogoi gaso, afädë made beagolei. ");
INSERT INTO etr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aso, molö made nebegi, Isibi segea molö galeamelëla säi amo nabalahilä, Yeigabaea nilïle mäu nelo amolima degabo mi gäwila afiamola sälahilä ili fisiga gai. ");
INSERT INTO etr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Amalahilä bu elö awäsebegi Yosebea ïe edoolalima, neda Yosebemelëla ulufadigila säla ï. Amala sälahilä nebegi, Felauea Yosebe sosogo amoge dawadigi. ");
INSERT INTO etr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Amalahilä, Yosebea ïe eedo Yeigabala e sosogola Isibi misialola säsi. E sosogo gegedolada nabülasi gifalädalïaïe odoai bia. ");
INSERT INTO etr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Misialola säsi amo nabala Yeigaba Isibi digala nebegi, hobeala e baagoi. Amalahilä nilïle mäu amolalige baagosebegi, ");
INSERT INTO etr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ilile domalo amo Segeme segea gaula obëgëlahilä, sege dafidi Abalahamaea Segeme ami Hamolöïe malöma baulo sege bidia niia ami baui. ");
INSERT INTO etr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Godea Abalahamama ado säla negei amo gausiala digamolö fu ga madesalea, Isilale udia dolö Isibi nefolalo amoli sosogo malei bäula besela galai. ");
INSERT INTO etr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Malei amala nebegi, hobeala beaha aligilo gini elö amea Yosebe made dawa nea, Isibi udia dolö sigi nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gini amea nilï sosogo amoli dahila nealahilä, nilïle mäu sëlasila, ilile malö dubo baagomäia segea sadia gamalai. ");
INSERT INTO etr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Amo gaalu, Moseseïe emea e ägüla misi, malö amoda Godeïe siigi hedabifalï. Aube ohodoa eedo hï mosöa ami sigi nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Amalahilä e segea negei dibegi, Felauïe idiwia neala gaula awälahilä, hïle malö folo wäla fosa nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Amala fosololahilä, ilia Isibiïe dawadigilo amo sulubadela Mosesema olelei. Amasebegi, ea ado adomolö amoge mala hamomolö amoge dolö geloi edefade nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosese e gäheo i nabülasi biyidia baagilahilä, ïe edoo Isilaleïe malö amoli neebea söfë moholö dialeala helësëi. ");
INSERT INTO etr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Awälahilä ea beahamelebe Isibi dolö afädëa Isilale dolö afädë nufudaha neebe melï. Amalebe Mosesea Isilale dolö amo damula awäla Isibi dolö amo hï asiala hamoi amoïe hï e bidigi nufudala baagoi. ");
INSERT INTO etr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesea helësësaleada, ïe edoo amolia Godea Moseseïe naaboea ili fisigämolö gabula helësësa dialeala helësëi. Gasoda, iliada amala made helësëi nefolalo. ");
INSERT INTO etr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Amo aiyo amogi Mosese besela galala beahamelebe Isilale dolö äudä nudusa neebe bealahilä, ele neala aealasidelälahilä elema sähalea, Malö äudä-o, didoo madele. Halimu edogi nudusala nabi. ");
INSERT INTO etr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Amala sälebe, mi hamola nudulo amea Mosese bobala sadia galahilä ema nabahalea, Di nilïle beaha aligilo namiäiage, gudi mogelo namiäiage di nowëa memelesio. ");
INSERT INTO etr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aiyo dia Isibi dolö nufudadigi amo gadola nege nufudadigidelä misi nealela nabi. ");
INSERT INTO etr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Amala säi amo nabalahilä Mosese e Midiana segea fisäla awäla nelo. Ami nea ïe dolö malö äudä sogobai. ");
INSERT INTO etr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ami gäheo i nabülasi biyidia baagilahilä, Mosese e sege nafade udia dolö aligilo made sege Sainai bi ga made neebea ami nebegi, i holöfalï afädëgi nulo söagila selesaia fii afädë Mosesea bimäia ulufadigila nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Amala hamosebe amo beala Mosese e fudugilahilä ga madela hedabola fädäla bimolö awäha nebegi, Dafidilo Geloiïe ado nabi. ");
INSERT INTO etr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Dafidilo Geloia sähalea, Neda dïe diado amolile Gode neawe, Abalahamaïege, Aisagaïege, Yeigabaïege ilile Gode neawemelëla säi. Amala säsebegi, Mosese e edefademalä fudugila emo gigisëlahilä bimolö bedäla nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bedäla nebegi Dafidilo Geloia ema sähalea, Sege di nebegoda na nihïle nafolai sege amea dia emo usililo salugai go giimo. ");
INSERT INTO etr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nïe udia dolö Isibi nefolalebe amolima ilia edefademalä neala sëlasisebe amo siia melïmelë. Ili dudumigila dïisa dibe amo nabalahilä, na ili damula awäla sigi obëgëmolöïe digai neawe. Amai gabugi, hä misië, na di Isibi mosalahagomelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dafidi Mosese ema ilia habobalahilä ema säla obëgësaleada, Di nilïle beaha aligilo namiäiage, gudi mogelo namiäiage di nowëa memelesiola säi amoda Mosese amoma säi gasoda, selesaia fii afädë i holöfalïgila ulufadigi amoïe naaboea dolö amea ili sigi namiäiage damula mosäiage Godea e fisiga galasimelë. ");
INSERT INTO etr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dolö amea Isibi segea neage, ödä duhulu ëida Heale Uii dibea ami neage, gäheo i nabülasi biyidia sege nafadeia ami neage, hïdo elöige dolöea hamomolöi made gadoige hamola ili sigi asi. ");
INSERT INTO etr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosese amea Isilaleïe malöma sähaleada, Godea dilile didoomadila aligila afädë bea sälo ne gadoi dilile bea sälo memelela ifosimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosese amoda selesaia fii afädëa Sainai bia amila ema ado säla ïasolo amo gala sege nafadegi gegedolo amolibalä nelo. Nilïle naado amolibaläge nelo. Ado diamolöi diamolö amo nilïma säla ïmäia ema ï. ");
INSERT INTO etr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Amaimo, nilïle naado amolia ea ado säi amo gadola hamomolö habobalahilä, e bobala sadia gala ilile asigida Isibi obëgësa nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Amala asigila nea ilia Alonoma sähalea, Nilïgali gode odoa naaboea hamomalo, iliadale nilï sigi mosäia. Mosese amea nilï Isibilahilä segea moholöïe sigi nelo amoma edo gadoi besela galaidu nilïa dawa madela säi. ");
INSERT INTO etr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Amala säsolo amo gala ilia sugua afädë gao emalö gadoi naaboea hamolahilä wäfalï gode amoma sugua gadoi elö elöla nufudala göa nelegela ï. Nilïa naaboea hedabi hamoi gabula helësëlahilä ilia edefademalä obeägïsa nelo. ");
INSERT INTO etr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Amala hamolebe Godea ili baagi ïala ilia mu ilibia gasumilïma göa nelegemäia fisigisi. Amo gadola bea säloïe bebagi dëdëla negei amo gowe. Isilale fii dili-e, gäheo i nabülasi biyidiagi sege nafadegi nea, sugua gadoi nufudala göa negela negali ïledu. ");
INSERT INTO etr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amaimo, Molegeïe balai mosö dilia gaula asi. Amase, dilile gode Lëfanaïe gasumilï gadoige, dilia göa nelegemolöïe naaboea hamoi amo dilia gaula asi. Dilia amala hamoi amea na dili Babilono holöbö baagia gala bobala mosäia fisiga gamolömelëla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Gode ilibalä neebe amoïe helësëla balai mosö amo nilïle naadolalibalä sege nafadeia ami nelo. Mosö amoda Godea Mosesema gowe gadoi hamomalola säla olei amo gadola ilia hamoi. ");
INSERT INTO etr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hobealada nilïle naado amolia ilile eedo bedefala balai mosö amo gaula Yasuabalä asi. Yasuabalä awäha nea Godea udia dolö fii odoa nefolalo amoli nesila digila sege amo iligali bedefala aligi awäha neada balai mosö amo gaula awäha nelo. Amalahilä balai mosö amo nebegimu beaha aligilo Gini Debidi besela galai. ");
INSERT INTO etr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Godea ema obeägïsebegi ea Godema nabahalea, Na mosö afädë Yeigaba fii amolile ulimolöda dofealela nabi. ");
INSERT INTO etr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amala nabi gaso, Solomonoea Godeïe mosö uli. ");
INSERT INTO etr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Amai gaso, Ilibia Edefade neebe ameada mosö naaboea uligida aligilo made nea. Bea säloea säi amo gadola, ");
INSERT INTO etr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Dafidilo Geloia sähalea, Muda nïe beaha aligilo filo dialeamelë. Amase, naga föida nïe emoea emesaia idala filo dialeamelë. Dilia ne namolöda mosö abodo gadoi olasimolö. Amase, ne hele fimolöïe sege fuda abidi dialea. ");
INSERT INTO etr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nelebo dibe goda sulubadela nïe naaboea hamoi madelela säila säla dëdëla negei dialeala säi. ");
INSERT INTO etr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Aso, Sidibenia ilima sähamu nea sähalea, Dilile iso asigi geloifalï nebego, bobaeage gëheage asigi afädë made negei amo wälasi nebego. Eleloi Gesamima habobahamu nebego. Dilida dilile diado amoli nelo amo gadoimu nebego. ");
INSERT INTO etr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bea sälo nefolalo amoligi afädë dilile diado amolia neala made sësa neloda nowë. Siiba dolö mogoifalï moholömelëla säla digi amolige ilia baagomäia nufudadigisa nelo. Amase, walio dilia dolö amo hololölahilä baagomäia nufimelë. ");
INSERT INTO etr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diligali Ado säla negei amo selesaia dolöma aulo negela ï amo dilia gaula nea, amo made hamolo nebego dilia amaila Sidibenia säi. ");
INSERT INTO etr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sidibenia ado säi amo nabalahilä, ilia edefade mihaläla ema bese ali nalëgëi. ");
INSERT INTO etr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amasebegi, Sidibeni ema Eleloi Gesami nobala nea, ea selesaia mosöa sida adogola nea beahamelebe, Godeïe yo digalo hïdo elöi amoge, Yesu e Godeïe naabo dafädimadi neebe amoge melï. ");
INSERT INTO etr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Siila nea sähalea, Bimo. Selesaia mosö doga negei dibe amoge Dolöïe Malö amo Godeïe naabo dafädimadi neebe amoge beahamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amala säi amo nabala, ilia gelola hoala digila naaboea ilile gëhe galahilä, e neebea gaalu fodolofalï nawela awäla ");
INSERT INTO etr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","e gaula gaamu yala baagia sadia galahilä, e baagomäia igia nufudaha nelo. Dolö dafidi ema babala sälo amolia ilile fagulo sedade daia salugai amo giilahilä, malïsä afädëïe emo mia nidila negei. Malïsä amoïe ëida Solo. ");
INSERT INTO etr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ilia Sidibeni e igia nufudaha nebegi, ea Godema adosalea, Dafidilo Geloi Yesu-o, dia nïe gesami nea nimola säi. ");
INSERT INTO etr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Amala sälahilä, emo gumu sasagala salea, gelolafalï sähalea, Dafidilo Geloi-e, ilia nafade hamosebe goweïeda ili së ïmabiola sälahilä, Sidibeni e süwia dilo wäla adi. ");
INSERT INTO etr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sidibeni nufudadigi amogi Soloea ïe siigi dofea hamoila helësëi. Segeyo amo gaalu, Sidibeni nufudalahilä, Godea Yalusaleme udia dolö wela ifosi nefolalo amoli mi gäwila edefademalä gelola neala sëlasisa nelo. Amalebe ili sulubadela fisäla awäla Yudia segeamadige Samelia segeamadige dusudasila afiaha maadei. Abosolo ilimu Yalusaleme ami nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dolö odoa Godeïe mala nabelo nefolalo amolia edefademalä didigaola Sidibeniïe domalo bausi. ");
INSERT INTO etr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amalahilä Soloea udia dolö Godea wela ifosi nefolalo amoli nufudala ïalalesa nelo. Amala hamosa nea mosö neebe amo sulubadelagi awälahilä, udiage dolöge gaula dusugaia awäla galabaia negesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Udia dolö fisäla dusudasila afiai amolia sege ili afiaido amo sulubadelagi Ado Mala Hedabi säla ïïa afiai. ");
INSERT INTO etr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Amala afialahilä, Filibi Sameliaïe gaamu afädë dibea ami awälahilä, ea ilima sähalea, Godea Afädë Memelei amo hä misi neamelëla säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Filibia ado säla ï amo udia dolö gegedoi amolia hedabola nabalahilä, ea dolöea hamomolöi made gadoi hamola digisebe amo beala ili sulubadelaea ea ado säsebe amo nabaha nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Amaha nea, udia dolö yafiema mugabe fedai nefolalo amoli nesila digisebegi üalala gäwila doadigila awäla digi, amase, dolö emo nafadeige, dolö fii siige yafie wahila digisa maadei. ");
INSERT INTO etr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Amala hamosebegi, gaamugi ami fii udia dolö amolia edefade obeägïsa nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gaamugi ami dolö afädë ïe ëi Saimono sulo. Dafidida ea golë hamosa nelo. Samelia fii udia dolö fudugimäia elö elöla hamosa nelo. Ea hïmu sähaleada, Neda ëi sälo edefademelëla sälo. ");
INSERT INTO etr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Amase, dolö odoa ëi säloge, memasage sulubadelaea Saimonoïe ado nabaha aligilo. Amoli sulubadelaea sähaleada, Godeïe geloi amo ilia Edefadela sälo amoda amola sälo. ");
INSERT INTO etr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Saimonoea segeyo yafiegi golë hamosa nelo amogi ili neala fudugilasilo amea ilia ea säsebe amo nabaha nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amai gaso, Filibia ilima Godea Beaha Maadela Sigi Neebe amoïege Yesu Gelesoïe ëige Ado Mala Hedabi säla ïasebegi, udiaeage dolöeage, asigi afädë negesebegi, ödägi gei. ");
INSERT INTO etr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Amase, Saimono eege asigi afädë negesebegi ödägi gei. Amalahilä e Filibibalä nawesa nea, dolöea hamomolöi made gadoige, geloi melëlo made gadoige hamosebe amo bealahilä Saimono e fudugi. ");
INSERT INTO etr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Abosolo dolö Yalusaleme nefolalo amolia Samelia ilia Godeïe ado mala neala gausaleala säi amo nabalahilä ilia Fidale Yonele ili neebea fisiga gai. ");
INSERT INTO etr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Amala säsebegi, ele awäla besela galalahilä, elea Samelia udia dolö amolia Eleloi Gesami nimäia Godema adolasi. ");
INSERT INTO etr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mida, Eleloi Gesami ilibalä digala made nelo. Yesuïe ëigimu ödägi gesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Godema adolasilahilä, elea ilima naabo negesisebegi ilia Eleloi Gesami nii. ");
INSERT INTO etr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Abosolo äudä amolea naabo negesi amea Gesami ïasebe amo Saimonoea bealahilä, ea muni ïahagolahilä ");
INSERT INTO etr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","sähalea, Na afädëma nïe naabo negesisegi Eleloi Gesami nimolö amoïe geloi amo nema ïmäiamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amala sälebe Fidaea ema säla obëgësalea, Godea memalä ïmolö amogi dia munia nimolö helësëi amea, dige dïe munige haligila heli segea mosäiamelë. ");
INSERT INTO etr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Dïe iso asigi Godeïe siigi mogoi made nebego. Ameada alïa hamoi hamosebewegida dofä dia hamomolöi mademelë. ");
INSERT INTO etr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dia nafade hamomolö helësëi amoïe asigi besumalo. Amalahilä, dïe isogi nafade asiala helësëi amo hëmäia Dafidilo Geloima adomalo. ");
INSERT INTO etr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na säi amoïe mida, gesami aulo gamogai amo dïe isogi nobalahilä, nafade hamomolö amea di gide begei dibe go beahamelëla Fidaea säi. ");
INSERT INTO etr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Amala säsebegi, Saimonoea säla obëgësalea, Alia säi amo gadola nema made hamomäia Dafidilo Geloima nïe adolasimola säi. ");
INSERT INTO etr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Amalahilä elea Yesuea elema hamoi amo säla ï. Amase, Dafidilo Geloiïe ado malage säla ïalahilä Yalusaleme obëgëi. Obëgësalea Samelia segeïe gaamu holöfalï dibeadi amogi Ado Mala Hedabi säla olelela aliligi obëgëi. ");
INSERT INTO etr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Amalahilä Dafidilo Geloiïe selesaia fii afädëa Filibima sähalea, Yalusalemela Gasa segea aulo idi gumadi mosalo. Idi sege nafadeido aulo amogi mosalola säi. ");
INSERT INTO etr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Amala säi amo nabalahilä Filibi e nowela asi. Idi amogi awäha nebegi, Idiobia dolö afädë idiafa gausiai. Dolö amoda dafidi iso neadigi nelo. Dolö ameada Idiobia udia dolöïe beaha aligilo gini udia ëi Gädasi sulo amoïe muni nelegeige beaha aligilo nelo. Dolö amoda Yalusaleme ami Godeïe ëi gauia adala Godema adomolö asi ");
INSERT INTO etr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","obëgësalea, galo sugua hosima begela dusugala aulo amogi filahilä, bea sälo Aisaeaea bebagi dëdëla negei dibe amo nidela aligi awäha nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nidela aligi awäha nebegi Gesamia Filibima sähalea, Di awäla galo mia ga madela, galo awäse amo gadola mosalola säi. ");
INSERT INTO etr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Amala säsebegi, Filibi e baluluia galo awäse amo gadola awäla nebegi, Idiobia dolö amea Aisaeaea bebagi dëdëla negei dibe amo nidese nabi. Amo nabalahilä Filibia ema nabahalea, Ado nidese goïeda helësësebelela nabi. ");
INSERT INTO etr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Amala nabasebegi, ea säla obëgësalea, Afädëa goïe mida gowemelëla nema made säla ïaseda, na abeahäla helësëmolödula säi. Amala sälahilä ea Filibima sähalea, Galodaia halïgïla fidelä fedala fimola säi. ");
INSERT INTO etr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bebagi ado säla dëdëla negei nidei amoda gowe. Sugua sibi baagomäia nufulö sigi awäsebe amo gadolage, sibi emalö hilï damusegi, nafi dagala adolo made amo gadolage, ea nafi made dagai. ");
INSERT INTO etr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","E neala hewalasilahilä ïe gudi mogola made säsi. E nagadaia namolöda aligila wagai amoïe yaua mäuïe ado nowëa säsimolöla säla dëdëla negei dialea. ");
INSERT INTO etr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Idiobia dolö amea Filibima nabahalea, Bea sälo amea, amo säi amo nowëïe helësëla säi gabu, hï e helësëla säi gabule ma, elöïe helësëla säi gabulela nema säla ïmola nabi. ");
INSERT INTO etr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Amalebe Filibia dafidi ado dëdëla negei nideia amila mi gäwila Yesuïe Ado Mala Hedabi dolö amoma säla olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ele idiafa awähalea ödä afädë dibea ami besela galala Idiobia dolö amea Filibima nabahalea, Bimo. Ödä dialea. Ne ödägi gemolö amo nelebo afädëa dofogamolöi gabulela nabi. ");
INSERT INTO etr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Amalahilä ea galo gaulo amoma beaha namiëlahilä, eege Filibige helegela ödägi digala aligilahilä Filibia e ödägi gelasi. ");
INSERT INTO etr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ele ödägila fedalahilä, Dafidilo Geloiïe Gesamia Filibi fodolofalï sogobala gaula asibua Idiobia dolö amea e bu elö made melï. Amalahilä ea obeägïla nelea hï aulo idi amogi asi. ");
INSERT INTO etr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibi e hä Asodasa gaamua neebe melï. Amalahilä e segea amila doadigila awäla gaamu dibe sulubadelagi nawesalea, Ado Mala Hedabi olelela aliligi awäla Sisalia gaamugi besela galai. ");
INSERT INTO etr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Amo gala Soloea Dafidilo Geloiïe bëgëla aulo nefolalo amolima sëlasila nufudadigideläla gelola sähamu nelo. Ea gobela ïlo busa edefade neebea ami awälahilä sähalea, ");
INSERT INTO etr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Gedolo mosö amoli beaha aligilo Damasaga nefolalebe amolima ïdulä, beba afädë dëdëla ïmo. Yesuïe Idigi aulo nefolalebe, udiage dolöge, beagoleseda, nafodolahilä Yalusaleme sigi obëgëdeläla säi. ");
INSERT INTO etr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Amalahilä, Solo e Damasaga suägïla nebegi, mudaiala yo digalo maala fodolofalï ema sege yabagelelo wäla yabagelei. ");
INSERT INTO etr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Amea e nagadaia digai dibegi, afädëa ema sähalea, Solo-o, Solo-o, edogi dia ne neala sëlasisala säse nabi. ");
INSERT INTO etr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Amo nabalahilä ea säla obëgësalea, Dafidilo, dida nowëla nabi. Amala nabasebegi, ea säla obëgësalea, Neda Yesu, dia neala sëlasilo amomelë. ");
INSERT INTO etr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Di hä nowela Damasaga gaamugi mosalo. Dia hamomolö amo ami säla ïmolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dolö odoa Solobalä asi amolia adola made aumala nelo. Ado säse amo nabi gaso, dolö hodo made melï. ");
INSERT INTO etr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Solo e digai amo noweia adalahilä si fisigäla melï gaso, nelebo bimolö ulï melï. Ulï galebeda ilia e nabelela gaulahilä sigi awäla Damasaga besela galai. ");
INSERT INTO etr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Besela galalahilä, ami segeyo ohodoa nelo amogi bimolö ulï nea, molö ödäge made naala nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasaga ami bëgëla aulo afädë nelo. Amoïe ëida Ananaiasa. Ea sosoäla awäla beahaleamelebe Dafidilo Geloia wela sähalea, Ananaiasa-ola säi. Amala säsebegi, ea säla obëgësalea, Dafidilo Geloi-e, ne neawela säi. ");
INSERT INTO etr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Amasebegi Dafidilo Geloia ema sähalea, Di nowelahilä idi gogi mosalo. Idi amoïe ëida Mogoi Idi. Amogi awälahilä Yudasaïe mosöa besela galamolöïe nowela mosalo. Yudasaïe mosöa besela galalahilä dia Dasasa fii dolö afädë ëi Soloda salealela nabualo. Mosalola säi amoïe mida, ea Godema adosa neebe amoïe. ");
INSERT INTO etr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ea sosoäla awäla beahaleamelebe ïe si hedabomäia dolö afädë ëida Ananaiasa maalahilä ïe naabo negesi melïla säi. ");
INSERT INTO etr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Amala sälebe Ananaiasaea säla obëgësalea, Dafidilo Geloi-e, dolö goeada udia dolö dihïle nafolai Yalusaleme nefolalo amolima nafade edefade hamoimelëla udia dolö yafiea säi amo na nabimelë. ");
INSERT INTO etr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nilï neebea wige udia dolö dïe ëi gauia adalo amoli sulubadela nafodomolöïe gobela ïlo busa nefolalo amolia ema geloi ïmelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amala säsebegi, Dafidilo Geloia ema säla obëgësalea, Mosalo. Dolö amoda nïe hamoi hamolasilo namiäia memeleimelë. Eada udia dolö fii odoa amolige, beaha aligilo gini nefolalebe amolige, Isilale udia dolö nefolalebe amolige, nïe ëi ilile siigi sämäia memeleimelë. ");
INSERT INTO etr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ea nïe ëigi së elö elöla molö amo na ema olemolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Amala säi amo nabalahilä, Ananaiasa awäla besela galalahilä mosö amogi nogila digai. Digalahilä ea ema naabo negesila sähalea, Nedoo Solo-o, Dafidilo Geloia ne wi misialai, di wi maahalea Yesu idiafa dia melï amea. Dïe si bu bimäiage Eleloi Gesami dima nobamäiage ne misialaila säi. ");
INSERT INTO etr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Amala sälebe fodolofalï seme bebe gadoi Soloïe siigila digalahilä ea bu bimolöi melï. Amalebe Solo e hä nowelahilä, ödägi gei. ");
INSERT INTO etr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ödägi gelahilä, molö naala gelola obëgëi. Damasaga nea Solo e bëgëla aulo amolibalä segeyo odoa nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Beaha aligila made fodolofalï gedolo mosöa awäla nea, ea Yesuda Godeïe Efege neamelëla säla ïaha nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Amalebe ea ado säi amo nabelo amoli sulubadelaea fudugilahilä sähalea, Udia dolö ëi go gauia adalo amoli Yalusaleme nufudadigisa aligilo amo e madele. Yawege amala hamomolöïe ili nafodolahilä gobela ïlo busa nefolalebea ami sigi gaula moholöïe misi madelela säla didigai. ");
INSERT INTO etr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Amalo gaso, Soloea edefademalä gelolasila, ado mala säla ïaha nelo. Säla ïahalea, Afädë Memelei amoda dofä Yesu e neamelëla säi amo Yu udia dolö Damasaga nefolalo amolia nabala fudugila, dofä säsebela helësëlahilä, säla obëgëmolö asusugai nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Segeyo yafie baagilahilä, Yu ili gegedola Solo baagomäia nufidedelämelëla säla didiäha dilo. ");
INSERT INTO etr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amala didiäi amo Soloea nabi. Ilia segeyo sulubadela gasi esoage Damasaga gaamu yalala amalela digi amoïe idi nogila digalo amo sulubadela Solo e baagomäia nufulöïe idia negesamu nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amala hamosa nebegi gasi afädëgi Soloïe bëgëla aulo nefolalo amolia Solo adu gadoigi salalahilä yala baagido ëfëa begela fisiga idai. ");
INSERT INTO etr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Solo e Yalusaleme awäla, Yesu bëgëla aulo amolibalä gedola namolö helësëi. Amala helësëla nebegi, eda Yesu bëgëla aulo made neala helësëla sulubadelaea bedäha nefolalo. ");
INSERT INTO etr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Amalo gaso, Banabasaea e sigi awäla abosolo amoli neebea ami asi. Sigi awälahilä ea abosolo amolima Solo e idiafa awäha nebegi Dafidilo Geloi melï amoge, ea Soloma ado säi amoge, ilima awala säla ï. Amala säla ïalahilä Damasaga awäla Soloea Yesuïe ëigi ïe ado mala gelola säla ï amoge ilima awala säla ï. ");
INSERT INTO etr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Amala sälahilä Solo e ilibalä gedola nea, Yalusaleme sege sulubadelagi awäha nea, Dafidilo Geloiïe ëigi gelola säla ïaha nawesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Amala säla ïaha nea, ea Yu dolö Giligi ado adolo nefolalebe amolibalä ado adosa nea gëgësa nelo. Gëgësebegi ilia e baagomäia nufulöïe idi hogosa nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Amala hamosa neamelëla säi amo nabalahilä edoolalia Solo Sisalia sigi awälahilä e Dasasa mosäia ifola asi. ");
INSERT INTO etr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Amala hamolahilä, Yudiage Galilige Sameliage udia dolö Godea wela ifosi nefolaloa ami aeaeala nelo. Amala nea ili neala gelolasisebegi, Dafidilo Geloibalä bedäla nagadaiala nelo. Eleloi Gesamia ilile asigi falagaselasisebegi, udia dolö odoaea asigi afädë negela ilima disa maadei. ");
INSERT INTO etr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fida e sege sulubadelagi nawesalea, udia dolö Godea hïle nafolai Lida gaamugi nefolalebea amige digala nelo. ");
INSERT INTO etr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Digala nea segea ami dolö afädë fii si dibe melï. Dolö amoïe ëida Eniasa, e imididaia diasi dibegimu gäheo i gödölasi baagi. ");
INSERT INTO etr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fidaea ema sähalea, Eniasa-o, Yesu Gelesoea di wahilasisebego. Nowelahilä dïe fëo galimola säi. Amala säi amole e fodolofalï nowei. ");
INSERT INTO etr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Udia dolö sulubadela Lidalage sege Salonolage ili sulubadelaea e bealahilä Dafidilo Geloima asigi besui. ");
INSERT INTO etr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yesu bëgëla aulo udia afädë ëi Dabida, Giligi ado adola ëi elöda Dogasa, e Yoba filo. Udia amea hamoi hedabi hamosamu nea. Udia dolö busadäoi nefolalebe amoli ugila negesamu aligilo. ");
INSERT INTO etr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Amala hamosa sebegi e olola baagoi. Baagosebegi odoaea ïe domalo nigime hëla hogoli ilibia afädëgi nea negesi. ");
INSERT INTO etr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yoba gaamu amoda Lida gaamu ga madela negei. Bëgëla aulo nefolalo amolia Fida segeyo amo gala Lida neai amo nabalahilä, ilia dolö äudäma e neebea bea mosalai. Awälahilä elea ema sähalea, Saula made, nilï nefolalebea fodolo misialola säla ï. ");
INSERT INTO etr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Amala säla ïasebegi, Fida e nowelahilä hiligila obëgëi. Besela galalahilä hogoli ilibia amogi ilia e sigi asi. Sigi awälahilä udia didalo nefolalo amoli e neebe gaalu ga madela nefolalea didigaola fagulo sedadege fagulo odoage Dogasaea hï e made baagola salea hamoi dilo amo ema nidila olei. ");
INSERT INTO etr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fidaea ili sulubadela afiaha maademolahilä, emo gumu sasagala salea Godema adoi. Amala adolahilä Fidaea ïe domalomadi besuia galahilä sähalea, Dabida, nowemola säi. Amalebe udia amea si fisigäla Fidama bealahilä e nowela fii. ");
INSERT INTO etr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Amala hamolebeda Fidaea udia amoïe naabogi nabelela nowela ifosi. Ifosilahilä Fidaea udia dolö Godea hïle nafolai nefolalo amolimage, udia didalo amolimage mofiamolahilä, ea udia wahi neebe amo ilima olei. ");
INSERT INTO etr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Amala hamoi amo Yoba udia dolöea dawadigisa maadelahilä yafiea Dafidilo Geloima asigi afädë negei. ");
INSERT INTO etr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Fida e segeyo yafie Yoba segea ami nelo. E ami nelo amoda dolö afädë ëi Saimonobalä nelo. Saimono ameada sugua gao gafodo nealahilä, amea nelebo odoa hamomolöïe daiaha aligilo. ");
INSERT INTO etr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisalia gaamugi ami dolö afädë nelo. Ïe ëida Gonilïasa. Eada ami dolö hädali afädë beaha aligilo nelo. Hädali afädë amoda hädali gafeia amoligi, hädali gafeia amolile ëida Idali Ami Dolöla sälo. ");
INSERT INTO etr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gonilïasa eada Godea hamei dibe amomu hamolo nea, Godebalä bedäla nagadaiala aligilo. Ïe mosöa nefolalo amoli sulubadelaeage amalo. Eada busadäoi neebe amoli ugila negela muni nelegeige ïaha aligilo nea, segeyo sulubadelagi Godema adolasisa aligilo nelo. ");
INSERT INTO etr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Amala hamosa nebegi segeyo afädëgi eso bëgisebe amo gaalu, Gonilïasaea sosoäla awäla beahaleamelebe, Godeïe selesaia fii afädëa e neebea maalahilä ema Gonilïasa-ola säsebegi ea fädäla melï. ");
INSERT INTO etr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Amala säsebegi, ea bedälahilä, selesaia fii amoma siila dialea nabahalea, Dafidilo, edola nabi. Amala nabasebegi, ea ema säla obëgësalea, Dia Godema adosa aligilo amoge, nelegei muni busadäoi amoligali ïaha aligilo amoge Godea bealahilä di helësësa neamelë. ");
INSERT INTO etr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Amaimo, dolö afädë Saimono, ïe ëi elöda Fida, amoda di neebea gui misiäia dolö odoaea Yoba bea mosalamalo. ");
INSERT INTO etr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Dolö amoda edaio Saimonoïe mosöa söfë misi saleamelë. Saimono ameada sugua gao gafodo nealahilä, amea nelebo odoa hamomolöïe daiaha aligilo. Ïe mosöda duhulu agesugi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Selesaia fii amea ema säla ïala asibua Gonilïasaea ïe hamoi hamolasilo äudä nelo amolege, amase, ami dolö afädë Godea hamei dibe amomu hamolo ebalämu aligilo amoge, ohodoa amoli misialolahilä, ");
INSERT INTO etr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","nelebo e neebea maala hamoi amo sulubadela ilima fädäla säla ïaha maadelahilä ea ili Yoba mosaloi. ");
INSERT INTO etr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Amo aiyo amogi ili awäla idiafa eso mogogi suägïla gaamu ga madela awäha neebe amo gaalu, Fidaea Godema adomolö mosö fïgï baledeidaia fedai. ");
INSERT INTO etr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Fedalahilä adosa salea, Fida e sïdëa baagosebegi molö molö helësëi. Odoaea molö giala daiasebe amo gaalu, Fida e olobola salea sosoäla awäla melï. ");
INSERT INTO etr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Beahaleamelebe mu doga negelahilä nelebo afädë fagulo gadoi edefade bidi biyidiagi gaulahilä nagadaia fisiga idogosebe melï. ");
INSERT INTO etr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Amodaia ami hogoi elö elöige, nagadaia hagömoea aulo elö elöige, hagila aulo haea elö elöige sefolalebe melï. ");
INSERT INTO etr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Amo beaha nebegi, ado afädë sähalea, Fida-o, nowelahilä dia nufudala muöla säse nabi. ");
INSERT INTO etr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Amala säi amo nabalahilä Fidaea säla obëgësalea, Dafidilo Geloi-e. Ai, made molö. Nilïa made mualaige, nelebo dïe siigi dofea madege, na afädë dofä made maimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Amala sälebe, ado amea bu elö ema sähalea, Godea dofea muöla säi amoda ïe siigi dofea madela sämabiola säse nabi. ");
INSERT INTO etr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Amo gadola bu ohodoala hamolahilä fodolofalï nelebo fagulo gadoi amo mudaia dusugala neasebe melï. ");
INSERT INTO etr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Sosoäla awäla melï amo Fidaea mi edoïedula asigi säosäola hehelësësa sebegi, dolö ohodoa Gonilïasaïe mosöala misi amoli maalahilä, Saimonoïe mosö abidi neala nalaba awäla beagolelahilä, idi galo mia ami segeamadi nelo. ");
INSERT INTO etr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Idi galo baagido segea nea wala nabahalea, Dolö afädë Saimono, ïe ëi elöda Fida, mosöa gui sebelela nabi. ");
INSERT INTO etr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sosoäla awäla melï amo Fidaea edodula hehelësësamu sebegi Gesamia sähalea, Nabuö, dolö ohodoaea di hogosa nea. ");
INSERT INTO etr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Di hä nowela digamo. Ilibalä moholö amogi dia asigi säosäomabu. Na ili fisiga weila säi. ");
INSERT INTO etr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Amala säsebegi, Fida e digalahilä dolö amolima nabahalea, Dolö dilia hogose amoda nemelë. Edoïe misila nabi. ");
INSERT INTO etr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Amala nabasebegi, ilia säla obëgësalea, Godeïe selesaia fii afädëa ami dolö hädali afädë beaha aligilo Gonilïasama sähalea, Fida di neebea misialamalo. Ea säse amo dia nabualola säimelë. Gonilïasada dolö asigi mogoi, Godebalä bedäla nagadaiala aligilo neamelë. Yu udia dolö amoliage e asigi mogoi neala sälomelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Amala säsebegi, Fidaea ili mosöa digafiamola sälahilä, ili ami adi. Diala nowela hiligila afiai. Edoolali odoa Yoba gaamugi nefolalo amolige hiligila afiai. ");
INSERT INTO etr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Amo aiyo amogi e Sisalia gaamugi besela galai. Gaamugi ami Gonilïasaea ili beaha nelo. E sosogo amolige e damelëfalï amolige misialolahilä, ili gegedola beaha nefolalo. ");
INSERT INTO etr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Fida e digala besela galasebegi Gonilïasa maalahilä, ïe emo mia gumusula dia idogoi. ");
INSERT INTO etr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amala hamosebegi, Fidaea e nabeleia idahalea sähalea, Di nowemo. Nege dolöfämelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Fidaea ebalä adodola mumusogi digahamelebe udia dolö yafie gegedoi dibe melï. ");
INSERT INTO etr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Bealahilä ilima sähalea, Afädë Yu dolö neebe amogida udia dolö fii elöbalä aligilo madege, amase, söfëge aulo madela säla negei amoda dilia dawadigi nebego. Amala hamolo gaso, dolö elöma dida nafade, amase, Godeïe siigi dofea madela made sämäia Godea nema oleimelë. ");
INSERT INTO etr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Amalebe misialoi amogi na säla obëgëla made, ne misimelë. Amaimo, mi edoïe ne misialaila nabahala nabi. ");
INSERT INTO etr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Amala nabasebegi, Gonilïasaea sähalea, Gomoïe gahada deadi walio neebe we gadola eso bëgisebe amo gaalu, nihï mosöa Godema adosa sebegi, dolö afädë fagulo hedabi eleloi salugai nïe odagia maala nelo gabio. ");
INSERT INTO etr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Amala maala nea ea sähalea, Gonilïasa-o, dia Godema adoi amo ea nabi. Amase, dia nelegei munige busadäoi amoligali ïaha aligilo amoge Godea made elaboi nea. ");
INSERT INTO etr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dolö afädë Saimono, ïe ëi elöda Fida, e Yoba gaamugi neamelë. Dolö odoama bea mosalamalo. Dolö amoda edaio Saimonoïe mosöa söfë misi saleamelë. Saimono ameada sugua gao gafodo nealahilä, amea nelebo odoa hamomolöïe daiaha aligilo. Ïe mosöda duhulu agesugi neamelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Amala sälebe na fodolofalï di bea mosalola säi. Nabalahilä misi goda hedabi hamoi. Nesege. Amaimo, Dafidilo Geloia sulubadela dima sämalola säi amo gadola säsebe amo nabulö nilï sulubadela Godeïe sidaia gedola saleawela säi. ");
INSERT INTO etr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Fidaea sähalea, Godea udia dolö sulubadela memelela made, fii sulubadelaea ebalä bedäla nagadaialahilä, mala mogoi hamosa nefolalebe amoli Godea hulu helësëla obeägïlo neebe amoda, dofä na walio beagolei neawe. ");
INSERT INTO etr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Godea neala dalulasilo Ado Mala Hedabi Yesu Geleso aulodaia nea säla, Isilale udia dolöma säla ï amo dilia dawadigi nebego. Yesu Geleso amoda udia dolö sulubadelaïe Dafidilo Geloi nea. ");
INSERT INTO etr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yonea ödägi gelo mala oleleibua, Galili ami mi gäwilahilä, Yudia sege sulubadelamadi hamoi amo dilia dawadigi nebego. ");
INSERT INTO etr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ami hamoi amoda gowe. Godea Nasalese fii Yesu memelela Eleloi Gesamige, geloige, ema söga negesebegi, Gode ebalä nelo amea Yesuea fufuia nawesa nea, udia dolöma hedabi hamola digi, udia dolö mugabe busaïe geloi hawa nefolalebe amoli sulubadela wahila digi amo dilia dawadigi. ");
INSERT INTO etr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ea Yalusaleme neage, Yu udia dolöïe sege sulubadelagi neage hamoi amo nilïa beaha maadei. Ilia e baagomäia iigi baala negeimelë. ");
INSERT INTO etr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amaimo, segeyo äudä nelolahilä osodagi Godea dolö amo nowela ifosilahilä, udia dolöea e bimäia olei. ");
INSERT INTO etr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Amala olei amoda, udia dolö sulubadelama made, Godea e bimäia memeleiamu melï. E baagola nowesebegi ebalä molö ödäge naha aligilo neebe nilïmamu oleimelë. ");
INSERT INTO etr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ea nilïma sähalea, Udia dolöma ado mala säla ïahalea, udia dolö dafidi baagoi amolilege walio nefolalebe welilege gudi mogelo namiäia Godea ne memelela ifosila säla ïmalola säi. ");
INSERT INTO etr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dafidi bea sälo nefolalo amoli sulubadelaea ïe helësëla bea säla sähalea, Ema asigi afädë negei nefolalebe amolia nafade hamoi amoda Godea ïe ëia hëla digimolömelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fidaea ado amo, aso, säha nebegimu, Eleloi Gesami udia dolö ea säi amo nabaha sefolalo amoli sulubadelama digai. ");
INSERT INTO etr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Asigi afädë negei gafodo damulo Fidabalä misi amolia Eleloi Gesami memalä udu ïlo amo fii odoama söga sali amo beala fudugisa dilo. ");
INSERT INTO etr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Fudugi amoïe mida gowe. Udia dolö amolia ado elö säla, Gode eda edefade neala säse nabi amogi. Amalahilä Fidaea nabahalea, ");
INSERT INTO etr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nilïa Eleloi Gesami nii amo gadola nii amoli ödägi made gemolöila sämolöi nealela nabi. ");
INSERT INTO etr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Amala nabasebegi, ea Yesu Gelesoïe ëigi ödägi gemalola säi. Amalahilä ilia ema segeyo odoa ilibalä namolömelëla säla gauia idai. ");
INSERT INTO etr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abosolo iliage edoolali Yudia sege sulubadelagi nefolalo amoliage nabahalea, udia dolö fii odoa amoliage Godeïe ado mala neala gaui neala säi amo nabi. ");
INSERT INTO etr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nabalahilä nea, gafodo damulo dolö odoaea Fida Yalusaleme awäla besela galasebegi, ilia ema nemoi. ");
INSERT INTO etr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nemola sähalea, Dia dolö gafodo made damui nefolalebe amolile mosöa digalahilä, ilibalä molö gedola naha sulo gabiola säi. ");
INSERT INTO etr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Amala säsebegi, Fidaea nelebo dafidi mi gäwila hamoi amo ilima awala sähalea, ");
INSERT INTO etr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ne Yoba gaamugi Godema adosa sebegi, olobola salea sosoäla awäla beahaleamelebe, mudaiala nelebo fagulo gadoi edefade bidi biyidiagi gaulahilä ne mia fisiga idogosio. ");
INSERT INTO etr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Fisiga idogosebegi fagulo gadoi amogi na siila fädäla beahamelebe, sugua foi elö elöige, hogoi odoage, hagömoea aulo gadoige, hagila aulo haeage sefolalebe melï. ");
INSERT INTO etr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Beaha nebegi nema ado afädë sähalea, Fida-o, nowelahilä dia nufudala muöla säse nabi. ");
INSERT INTO etr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Amo nabalahilä na säla obëgësalea, Dafidilo Geloi-e. Ai, made molö. Nilïa made mualaige, nelebo dïe siigi dofea madege, afädë nïe nafia made maimelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Amala sälebeda ado amea mudaiala bu elö sähalea, Godea dofea muöla säi amoda ïe siigi dofea madela sämabiola säse nabi. ");
INSERT INTO etr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Amo gadola bu ohodoala hamolahilä nelebo amoli sulubadela mudaia dusugala neasebe melï. ");
INSERT INTO etr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Amo gala dolö ohodoa Sisaliala fisiga gai amoli mosö ne neebea ami maala besela galasio. ");
INSERT INTO etr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Besela galasebegi Gesamia nema ilibalä moholö amogi dia asigi säosäomabula säi. Amala säsebegi, nedoo gafeia amolalige nebalä awälahilä, nihïlïgïla dolö amoïe mosöa nogila digai. ");
INSERT INTO etr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Digalahilä ea nilïma säla ïahalea sähalea, Selesaia fii afädë nïe mosöa maase melï. Selesaia fii amea sähalea, Dolö odoa Yoba mosaloi, amoli awäla dolö afädë Saimono, ïe ëi elöda Fida, e misiäia bea mosaloi. ");
INSERT INTO etr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ea ado mala säla ïasebe amea dige dïe mosöa neebe amolige dili sulubadela damula moholömelëla säila säi. ");
INSERT INTO etr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Amaimo, na ado säha nebegi, Eleloi Gesami dafidi mi gäwila nilïma digai amo gadola ilimage digasio. ");
INSERT INTO etr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Amala hamolebe na helësëla obëgësalea, dafidi Dafidilo Geloia ado säi amo gadola, Yoneada ödäea gesa nelo, dili Eleloi Gesamia gemolömelëla säi amo helësëla obëgëimelë. ");
INSERT INTO etr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dafidilo Geloi Yesu Gelesoma asigi afädë negesebegi, Godea nilïgali ï amo gadola, iligalige ïasebegi, na Godema iligali amala ïmabula sämolöi nelolela Fidaea säla wagai. ");
INSERT INTO etr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Amala säi amo nabalahilä, ilia bu säla obëgëla made, Godeïe ëi gauia adala sähalea, Godea udia dolö fii odoa neebe amoliage asigi besulahilä namolö gähe neala gaumäia iligali fu ï gabula säi. ");
INSERT INTO etr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sidibeni baagomäia nufia amila odoaea ili neala sëlasisa nebegi, udia dolö fisäla dusudasila afiai amoli fisäla odoa Fonisiage, Saibulusige, Ädiagoge awäla ado mala säla ïïa Yu udia dolömamu olelela aliligi asi. ");
INSERT INTO etr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amai gaso, fisäla asi amoligi Saibulusi dolö odoage Sailini dolö odoage Ädiago gaamugi awäla Giligi udia dolömage Dafidilo Geloi Yesuïe Ado Mala Hedabi olelesa nelo. ");
INSERT INTO etr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dafidilo Geloia ïe geloi ilima olesebegi udia dolö yafie asigi afädë negesa maadelahilä Godemadi namolö obëgëi. ");
INSERT INTO etr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Amala hamoila säi amo Godea Yalusaleme udia dolö wela ifosi nefolalo amolia nabalahilä, ilia Banabasama Ädiago segea bea mosalai. ");
INSERT INTO etr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","E awäla besela galalahilä beahamelebe, Godea ili hedabola ugila negei amo bealahilä ea obeägï. Obeägïlahilä ea ilile iso asigi gelolasila udia dolö sulubadelama sähalea, Fisila made, Dafidilo Geloibalä dila nebegoda go wälasimu namialola säi. ");
INSERT INTO etr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasa e dolö hedabi, Eleloi Gesami ema nobai nea, asigi afädë negei geloi nelo amea amala säi. Amaimo, udia dolö yafiege Dafidilo Geloima asigi afädë negela baai. ");
INSERT INTO etr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Amala hamolahilä Banabasaea Solo hogomolöïe Dasasa asi. ");
INSERT INTO etr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Beagolelahilä ea e Ädiago sigi obëgëi. Ädiago ami gäheo i afädë ele udia dolö Godea wela ifosi nefolalo amolibalä gegedola nea, udia dolö yafiema mala säla olelesa nelo. Yesu bëgëla aulo Ädiago ami mi gäwila Geleso sosogola ëi negei. ");
INSERT INTO etr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Segeyo amo gaalu, bea sälo odoa Yalusalemelahilä Ädiago digai. ");
INSERT INTO etr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iligi afädëïe ëi Agabasa e nowelahilä, Gesamiïe geloia bea säla negesalea sähalea, Sege föi sulubadelagi sïdë i edefademalä gelola moholömelëla säla negei. Amala säi amo gadola beaha aligilo Gini Sisa Golodiasa nebegi gausiala digai. ");
INSERT INTO etr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ado säi amo nabalahilä, bëgëla aulo nefolalo amolia ado afädë negela, edoolali Yudia nefolalebe amoligali ugila negela ïmolöïe, muni dibe amo gadola ïdulämelëla säi. ");
INSERT INTO etr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ilia amala säi amo gadola hamolahilä, ilia Banabasale Sololele naabogi gausilahilä, dolö asigi gäwi dafidilo nefolalebe amolima ïmolöïe gaula mosaloi. ");
INSERT INTO etr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Amo gaalu, Gini Heledoea udia dolö Godea wela ifosi nefolalo odoa amoli neala sëlasimolöïe gaula nafodosa nelo. ");
INSERT INTO etr_vpl VA