﻿USE sofia;
DROP TABLE IF EXISTS sofia.eskNT_vpl;
CREATE TABLE eskNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eskNT_vpl WRITE;
INSERT INTO eskNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Uvva ukua aglaŋich sivulliaŋiñ Jesus Christ-ŋum, kiŋuviaŋupluni David-miñ Abraham-miñḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham aapagigaa Isaac-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Aasiiñ Judah aapagigaak Perez-ŋumlu Zerah-ŋumlu, taapkuak aakaŋak Tamar, ");
INSERT INTO eskNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram-li aapagigaa Amminadab-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-li aapagigaa Boaz-ŋum, Rahab-mik aakaqaqtuam, ");
INSERT INTO eskNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse-aasiiñ aapagigaa umialgum David. ");
INSERT INTO eskNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Aasiiñ Solomon aapagigaa Rehoboam-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa-li aapagigaa Jehoshaphat-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah-li aapagigaa Jotham-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah-li aapagigaa Manasseh-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah-li aapagigaa Jeconiah-ŋum aniqataiñḷu. (Ukua taimani Israel-aaġmiut aullautraupmata Babylon-mun.) ");
INSERT INTO eskNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iñuich tikiutikkauŋanikmata Babylon-mun, ");
INSERT INTO eskNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel-li aapagigaa Abiud-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor-li aapagigaa Zadok-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud-li aapagigaa Eleazar-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aasiiñ Jacob aapagigaa Joseph-ŋum, uiŋan Mary-m, taamna Mary Jesus annivigikkaŋa taiguutiqaqtuam Christ-mik. ");
INSERT INTO eskNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iluqatiŋaasiiñ kiŋuviaġiich aullaġniipḷutiŋ Abraham-miñ David-munaglaan akimiaġuutaiḷauniqsut, suli aullaġniipḷutiŋ David-miñ iñuich aullautraułhatnunaglaan Babylon-mun kiŋuviaġiich akimiaġuutaiḷaupmiñiqsut. Aasiiḷi iñuich aullautraułhatniñaglaan akimiaġuutaiḷaupmiut kiŋuviaġiich anił̣hanunaglaan Christ-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Uvva Jesus Christ-ŋum anił̣ha itnaiḷipḷugu inniqsuq. Aakaŋa Mary nuliaksrausiutianikami Joseph-mun, aglaan katigaluaqatik iḷitchuġiniqsuq siŋaiyautilaaġmiñik Ipqitchuakun Irrutchikun. ");
INSERT INTO eskNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aasiiñ uiksrautaa Joseph nalaunŋaruaŋuniqsuq. Iḷisimagaa katchuutiłiksrani Mary-mik nalaunŋaitkisilaaŋa, aglaan kanŋusaaġuŋiññiġaa iñuŋnun. Taatnamik sivunniġñiqsuq avitchukługu nalunautchipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Taavrumiŋa isumaaluktitlugu Atanġum isaġulgan sagviutiniġaa siññaktukun nipliqhuni, “Joseph, kiŋuviaġigaatin David-ŋum, sivuuġanak Mary-mik tuvaaqatniŋñiaqniḷutin atakkii siŋaiyaupkaġaa Ipqitchuam Irrutchim. ");
INSERT INTO eskNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iġñiqaġisiruq. Atchiġisigiñ Jesus-mik. Atakkii anniqsuġisigai iñuŋni killuqsautiŋitñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tamatkua iluqatiŋ atuumarut taŋiqsaqługu Atanġum uqauttutigikkaŋa tumigiplugu taimña sivuniksriqiri, ");
INSERT INTO eskNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Taamna aŋutituqsimaitchuaq siŋaiyauniaqhuni iġñiqaġisiruq. Iñuich taiguutiqaġisigaat Immanuel” (itnautauruaq, Agaayyutim iqatigigaatigut). ");
INSERT INTO eskNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph-ŋum itiqami taimma iḷaqatiksraqtaaġigaa Mary isaġulgan Atanġum uqauttutaagun. ");
INSERT INTO eskNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iḷaksiaŋiññiġaa iġñiqałhanunaglaan; aasiiñ Joseph-ŋum atchiġñiġaa Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus anianikman Bethlehem-mi Judea-miittuami, Herod umialgułhani, aŋutit puqiksaat tikiññiqsut Jerusalem-mun, apiqsruqtuqhutiŋ, ");
INSERT INTO eskNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Sumiimma aniva umialgat Jew-ŋuruat? Tautukkikput uvluġiaŋa kivaknamiñ, taatnaqhuta aggiqsugut sitquġvigityaqtuaqługu.” ");
INSERT INTO eskNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Umialgum Herod tusaakamiuŋ taamna isumaalutchaŋniqsuq iluqatiŋlu Jerusalem-miut. ");
INSERT INTO eskNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tavra katipkaqługich iluqaisa qaukłiŋich agaayuliqsit aglaliqirit, iliŋich apiqsruġniġai sumi Christ, anniqsuqti akiqsruutauruaq, aniñiaqmagaan. ");
INSERT INTO eskNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iliŋisa kiuniġaat, “Bethlehem-mi Judea-miittuami, itna sivuniksriqiri aglaŋatigun ittuq, ");
INSERT INTO eskNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Iñuich iñuuruasii Bethlehem-mi, nunaŋaniittuami Judah-m, kamanaiññiqsrauŋuruasii akunġatni iñuiñ Judah-m, ilipsitñiñ sivulliuqti aggiġisiruq aŋalatchityaqtuaġuni iñugikkamnik Israel-ŋum.’” ");
INSERT INTO eskNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod atanġum nalunautchipḷuni puqiksaat aŋutit tikisinniġai, iḷitchuġiviginiallapiaqługich napmun iḷipman uvluġiaq sagviqmagaan. ");
INSERT INTO eskNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iḷitchuġianikamiuŋ Bethlehem-muquniġai nipliqhuni, “Aullaġusi pakallapiaqsiuŋ iḷiḷgauraq, aasiiñ paqitkupsiuŋ iḷitchuġipkaġumagipsitŋa. Uvaŋaptuuq utlakkumagiga sitquġvigityaqtuaġlugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Taavrumiŋa umialgum uqautianikmatiŋ aullaġniqsut. Tautuŋniġaat uvluġiaq qiñikkaqtiŋ kivaknamiñ. Sivulliukkauniqsut uvluġiam nutqaġniałhanunaglaan inimun iḷiḷgauram nayukkaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tautukamitruŋ uvluġiaq quviatchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Isiqhutiŋ tupiġmun tautuŋniġaat iḷiḷgauraq aakaŋalu Mary. Sitquġviginiġaat sivuġaanun iḷiḷgauraq. Aŋmaġniġaich akisuruaġikkatiŋ qaitchipḷuguasiiñ maniŋñik kaviqsaanik tipraġiksautiniglu, frankincense-nik suli myrrh-niglu. ");
INSERT INTO eskNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aasiiñ kilikkauniqsut siññaktukun utiquŋitḷugich Herod-mun. Tavra aiñiqsut atlakun apqutikun. ");
INSERT INTO eskNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Taapkua aullaanikmata isaġulga atanġum sagviġñiqsuq Joseph-mun siññaktukun nipliqhuni, “Makillutin. Pigruutiuŋ iḷiḷgauraq aakaŋalu Egypt-mun, aasiiñ taamaniitchumausi uvamnun uqautiniałłapsiknunaglaan. Atakkii Herod pakaŋniaġaa iḷiḷgauraq tuqqutchuglugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph makitluni aullautiniġaa iḷiḷgauraq aakaŋalu unnuami Egypt-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Immiġñiqsuq Atanġum uqauttutigikkaŋa tumigiplugu sivuniksriqiri, “Egypt-miñ tuqłuġiga Iġñiġa.” Taatnamik tavraniinniqsut tuquniałhanunaglaan Herod-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod iḷitchuġikami saglutaqtilaaġmiñik puqiksaanun aŋutinun qinnallapiaġniqsuq. Tilisiñiqsuq tuqqutquplugich nukatpiaġruurapayaat Bethlehem-miittuat suli iluqaisa avataaniittuat, tamatkua ukiuqaqtuat malġuŋnik nutautluktuatlu, atakkii iḷitchuġiplugu puqiksaat aŋutit uqautigikkaŋat uvluġiam sagvił̣hagun. ");
INSERT INTO eskNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Uqauttutauruaq tumigiplugu sivuniksriqiri Jeremiah taimña immiumaniqsuq, ");
INSERT INTO eskNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nipi tusaġnaġniqsuq Ramah-mi qiaruaq kiŋuvġupluni. Rachel-ŋum qianiġai qitunġaurani arayunaiqhuniunniiñ atakkii qitunġaŋich iluqatiŋ tuquplutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod tuquanikman isaġulga Atanġum sagviġñiqsuq Joseph-mun siññaktukun Egypt-mi uqaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Makillutin aullautiuŋ iḷiḷgauraq aakaŋalu nunaŋanun Israel-ŋum. Taipkua tuqqutchiñiaqtuat iḷiḷgauramik tuqurut.” ");
INSERT INTO eskNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Makitluni aullautiniġaa iḷiḷgauraq aakaŋalu nunaŋanun Israel-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aglaan tusaakamiuŋ Archelaus atanġunipḷugu Judea-mi inaani aapami Herod sivuuġatchaŋniqsuq aullałiksraġmiñik. Kilikkaukami siññaktukun aullaġniqsut nunaŋanun Galilee-m. ");
INSERT INTO eskNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aasiiñ iñuuniagaqsipḷutiŋ nunaaqqimi Nazareth-mi. Immiumaniqsuq uqautaumaruaq tumigiplugich sivuniksriqirit, “Taiguutiqaġisiruq Nazareth-miumik.” ");
INSERT INTO eskNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Taipkunani uvluni John Paptaaqtitchiri quliaqtuaġniqsuq iñuiḷaami Judea-mi, ");
INSERT INTO eskNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","uqaqhuni, “Isummitqigitchi atakkii Agaayyutim aŋaayuqautaa qalliruq.” ");
INSERT INTO eskNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Taamna John ilaaŋuruq sivuniksriqirim Isaiah-m uqautigikkaŋa nipliqhuni, “Iñuk tuqłiraqtuq iñuiḷaamiñ, Itqanaiyautisiuŋ apqutiksraŋa Atanġum, nalġuġlugu tumiksraŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John atnuġaaqaġniqsuq pikukturuam amian nuyaiñik, qisiŋmik tapsiqaqhuni, niqiqaqhuni pigliġianik suli igutchaich siiġñaqtaalliaŋitñik nanipayaaq paqitchumiuŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iñuich utlaŋniġaat John Jerusalem-miñḷu, Judea-miñḷu, nunaaqqiñiñḷu avataani kuuŋan Jordan-ŋum ittuat. ");
INSERT INTO eskNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iñuich quliaġiniġaich killuqsautitiŋ aasiiñ John-ŋum paptaaġniġai kuuŋani Jordan-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aglaan tautukamigich iñugiaktuat Pharisee-ŋuruat Sadducee-ŋuruatlu utlautiruat paptaaġvianun uqautiniġai, “Tuqunaliktun nimiġiatun ittusi. Qimakkumiñaitchusiasu aggiġñiaqtuamiñ qinnautaaniñ? ");
INSERT INTO eskNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Qiñiqtittitchi iñuuniałłapsigun isummitqiḷḷapiaqtilaapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Suli isumaniaqasi, ‘Uvagut Abraham-mik aapaqaqtugut.’ Nipliutiniaġipsi uumiŋa, uyaġaŋniñ makunakŋa Agaayyun iñiqsił̣hiñauruq iḷiḷgaanik Abraham-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ipiġautaqaqtuaq kiprił̣hiñaaġuqtuq napaaqtunik kaŋiŋisigun. Napaaqtupayaaq asirritḷaitchuaq kipikkaugisiruq aasiiñ igitauluni ikniġmun. ");
INSERT INTO eskNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Iḷumun paptaaġipsi imiġmik isummitqił̣iġmun, aglaan aqupkun aggiġisiruq kamanatluktuaq uvaŋniñ. Nakuuŋitchuŋa saagałiksramnik aluġutiknik. Paptaaġisigaasi Ipqitchuamik Irrutchimik suli ikniġmik. ");
INSERT INTO eskNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tigummiaġigaa tiktittaun salummallapiaġukługich mukkaaksrat sanikłuŋniñ. Katitkisigai mukkaaksrat siġḷuaġmiñun, aglaan ikipkaġisigai sanikłuich ikniġmun qamiyumiñaitchuamun.” ");
INSERT INTO eskNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aquagun Jesus tikiññiqsuq Galilee-miñ Jordan-mun John-mun paptaaqupluni ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aglaan John-ŋum paptaaġuŋitkaluagaqsiñiġaa uqautiplugu, “Ilvich paptaaqtaksraġigaluaġikma. Suvaata utlautivich uvaŋnun paptaaquplutin?” ");
INSERT INTO eskNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aglaan Jesus kiuniġaa, “Nakuuruq. Taamna taatnaġuptigu taŋiġñiaġikpuk iluqaan Agaayyutim iŋiaŋa.” John taatna piyumaliġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus paptaakkauŋanikami mayuġniqsuq imiġmiñ. Aasiiñ qiḷak aŋmaqhuni tautuŋniġaa Irrusia Agaayyutim atqaqtuaq tiŋmiaġruuratun mitḷuni ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aasiiñ nipi qiḷaŋmiñ nipliġñiqsuq, “Taamnatavra piqpagikkaġa Iġñiġa. Quyalisimaaġaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Taatnaanikman Ipqitchuam Irrutchim sivulliġñiġaa Jesus iñuiḷaamun uuktuaqsiutyaqtitlugu tuunġaġmun. ");
INSERT INTO eskNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aasiiñ uisauraaqhuni malġukipiani uvluni unnuaniḷu niġisuliġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uuktuaqtitchirim utlakamiuŋ uqautiniġaa, “Iġñiġipiaqpatin Agaayyutim makua uyaġaich qaqqiaġuqtitkich.” ");
INSERT INTO eskNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aglaan Jesus kiuniġaa, “Aglausimaruq Agaayyutim uqałhani, ‘Iñuk iñuuniaŋitchuq niqiłhiñakun aglaan uqałipayaatigun aniruatigun qanġaniñ Agaayyutim.’” ");
INSERT INTO eskNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tavrani tuunġaum aullautiniġaa Jesus Jerusalem-mun, aasiiñ inillakługu qutchiŋñiqsraŋanun nuvukkaŋan agaayyuvikpaum, ");
INSERT INTO eskNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","uqautiplugu, “Iġñiġipiaqpatin Agaayyutim nutigiaġiñ. Aglausimaruq, ‘Tiligisigai isaġuligikkani munaġitqulutin. Argagikkaġmiknik akigaġisigaatin. Atniŋitchumaittin isigaktin uyaġaŋnun.’” ");
INSERT INTO eskNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus-ŋum uqautiniġaa, “Aglausimaruqsuli, ‘Uuktuaġumiñaitchiñ Ataniq Agaayyutin.’” ");
INSERT INTO eskNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tuunġaum aullautitqiḷgiññiġaa Jesus qutchiḷḷapiaqtuamun iġġimun, aasiiñ qiñiqtitlugu atanġuvipayaaŋiñik nunam kamanautiŋitñiglu. ");
INSERT INTO eskNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Uqautiniġaa, “Tamatkua supayaat qaitkisigitka ilipnun sitquġvigigupŋa sivumnun.” ");
INSERT INTO eskNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus-ŋum kiuniġaa, “Tuunġaaq, piiġiñ! Atakkii aglausimaruq, ‘Ataniq Agaayyutigikkan kisian agaayyuvigiyumagiñ savautilugulu.’” ");
INSERT INTO eskNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tavra tuunġaum uniññiġaa, aasiiñ isaġulgich tikiññiġaat savautityaqługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus-ŋum tusaakamiuŋ John isiqtaunipḷugu aullaġniqsuq Galilee-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Unitḷugu Nazareth utlautiniqsuq Capernaum-mun itchaqtuaqhuni siñaani narvaqpaum nunaŋakni Zebulun-ŋumlu Naphtali-mlu. ");
INSERT INTO eskNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Taamna immiumatquplugu uqauttutauruaq tumigiplugu sivuniksriqiri Isaiah, ");
INSERT INTO eskNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Iñuich tamatkua nunaŋakni Zebulun-ŋumlu Naphtali-mlu tuŋaani narvaqpaum, taaganitchiaŋani Jordan-ŋum, Galilee-mi nunaŋatni Jew-ŋuŋitchuat, ");
INSERT INTO eskNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","tamatkua iñuuniaqtuat taaqtuami tautuŋniġaat kamanaqtuaq qauma, aasiiñ qaumam qaggutiniġai iñuuniaqtuat taġġaŋani tuqułhum.” ");
INSERT INTO eskNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tikiñŋanikami Capernaum-mun Jesus-ŋum aullaġniiñiġaa quliaqtuałłi, “Isummitqigitchi atakkii Agaayyutim aŋaayuqautaa qalliruq.” ");
INSERT INTO eskNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus pisukhuni siñaagun narvaqpaŋan Galilee-m tautuŋniġik aniqatigiik, Simon taiguutiqaqtuaq Peter-mik suli Andrew aniqataa, kuvriqsuak narvaqpaŋmun aqaluŋniaqtauplutik. ");
INSERT INTO eskNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Uqautiniġik, “Maliksikŋa, uvakŋaniñaglaan piññaŋniaġisirutik iñuŋnik aqaluŋniaqtitun.” ");
INSERT INTO eskNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tavrauvaa Simon-ŋum suli Andrew-m uniññiġaik kuvratik malikługuasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesus igliqtuiñaqhuni apqusaaqługu narvaqpaŋa Galilee-m. Tautukmiñiġik aniqatigiik James-lu John-lu, iġñak Zebedee-m, ikimmiruak umiami aapariŋlu Zebedee iḷaaqtuiruat kuvramiknik. Jesus-ŋum tuqłuġniġik maliqupluni. ");
INSERT INTO eskNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tavrauvaa uniññiġaak umiaqtik aapariŋlu malikługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus kukiḷuŋniqsuq iluqaani Galilee-mi, iḷisautripḷuni Jew-ŋuruat katraġviŋitñi suli quliaqtuaġiplugu tusaayugaallautaq Agaayyutim aŋaayuqautaata, mavruuqługiḷḷu iñuich atniġñautipayaaŋitñik. ");
INSERT INTO eskNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tusaayugaallautaq Jesus-kun siaminniqsuq iluqaanun Syria-ŋum, aasiiñ iñuich tikiutruġniġaich atniġñapayaaqtuat naŋirrutipayaaqtuatlu, iḷaŋich irrusiqł̣uqaqhutiŋ qiiqsruqtaqhutiŋlu suli avatiŋich tuquŋaplutiŋ. Jesus-ŋum mavruuġniġai iluqaitñik. ");
INSERT INTO eskNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iñugiaktuat iñuich maliŋniġaat, aggiqhutiŋ Galilee-miñ, avataaniittuaniñḷu nunamiñ atiliŋmiñ Decapolis-mik, Jerusalem-miñ, Judea-miñḷu, suli nunamiñ igḷuani ittuam Jordan-ŋum kuuŋan. ");
INSERT INTO eskNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus-ŋum qiñiqamigich iñugiallapiaqtuat mayuġniqsuq qimiġaamun, aquvitluniasii. Maliġuaqtai Jesus-muŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ilaan iḷisautiaqsiñiġai nipliqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Quvianamiurut tamatkua iḷitchuqsriruat inuqsrałiġmiknik irrutchikun, atakkii Agaayyutim aŋaayuqautaa pigigaat. ");
INSERT INTO eskNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Quvianamiurut tamatkua kiŋuvġuruat, atakkii Agaayyutim arakkisigai. ");
INSERT INTO eskNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Quvianamiurut tamatkua piisaaŋitchuat, atakkii nunapayaaq pigigisigaat. ");
INSERT INTO eskNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Quvianamiurut tamatkua kimmutiqaqtuat nalaunŋaruałiġmik, atakkii Agaayyutim pisuiqsimaaqtitkisigai. ");
INSERT INTO eskNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Quvianamiurut tamatkua nagliktauruat, atakkii Agaayyutim nagliktuġisipmigai. ");
INSERT INTO eskNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Quvianamiurut tamatkua uummatiqaqtuat ipqitchuamik, atakkii qiñiġisigaat Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Quvianamiurut tamatkua tutqiutiqaqtitchiruat akunġatni iñuich, atakkii Agaayyutim taiguutiqaġisigai qitunġaġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Quvianamiurut tamatkua piyuaqsiuruat piqutigiplugu nalaunŋaruałiq, atakkii Agaayyutim aŋaayuqautaa pigigaat. ");
INSERT INTO eskNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Quvianamiurusi piiŋiḷaqsruutigikpasi suli piyuaġusi suli niplialutiŋ qanusipayaanik pigiitchuanik ilipsigun sagluturuaġilusi pisigilugu maliġuaqtaułiqsi uvamnun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Quviatchapiaġataġitchi atakkii kamanaqtuq akiḷiusiaksraqsi ittuaq qiḷaŋmi. Taatnatuntuuq piyuaqsiupmiñiqsut taipkua sivuniksriqirit sivupsitñi iñuuniaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ilipsi taġiuġigaasi nunam. Taġiuq taġiuġniiġumi qanuġuni taġiuġniḷitqikkisiva? Atuġumiñaiqsuq aglaan igitaksraġułhiñaqtuq tutmiġaġuqhuni iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Naniġigaasi nunam. Nunaaqqiq nappakkauruaq qimiġaamun iriqsimatlaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kisupayaam ikitnamiuŋ naniq iḷitḷaitkaa ataanun utkusium aglaan naniqaġviŋmun qaummatautlasipḷugu tupqum iḷuani ittuapayaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Taatnatun qaumapkaqsigik nannisi sivuġaatni iñuich. Tautukkumagaat savaallautaqsi, aasiiñ kamaksruaqsiḷugu aapari ittuaq qiḷaŋmi. ");
INSERT INTO eskNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Isumanasi aggiġñiḷuŋa piyaqquġiaġlugich maliġutaksraŋi Moses-ŋum naagaqaa iḷisauttutiŋich sivuniksriqirit. Aggiŋitchuŋa piyaqquġiaġlugich aglaan taŋiġiaġlugich. ");
INSERT INTO eskNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Uqautigipsi, Qiḷaglu nunalu piiġumiñaitchuk aglausimaruapayaaq maliġutaksrani immiumagaluaqnagu. ");
INSERT INTO eskNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kiñapayaaq navguiruaq kamanaiññiqsrallapiaŋatnik tillisit aasiiñ iḷisautripḷuni atlanik iñuŋnik taatnaquplugich, taamna iñuk kamanaiññiqsrauniaqtuq ukunakŋa iñuŋniñ Agaayyutim aŋaayuqautaani. Aglaan kiñapayaaq kamaksriruaq tillisiñik iḷisautripḷuniasiiñ atlanik taatnaquplugich, taamna iñuk taiguutiqaġisiruq kamanaqtuamik ukunakŋa iñuŋniñ Agaayyutim aŋaayuqautaani. ");
INSERT INTO eskNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Uvva uqautigipsi, Nalaunŋaruałiqsi nakuutluŋitpan iñuuniaġusiatniñ aglaliqirit suli Pharisee-ŋuruat suuramikunniiñ isiġumiñaitchusi aŋaayuqautaanun Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tusaamarusi uqautauruamik iñuŋnun iŋiḷġaan, ‘Iñuaġniaqnak’. Kiñapayaaq iñuaqtuaq tikiutraugisiruq atanniiviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aglaan uqautigipsi, Kiñapayaaq qinnautriruaq aniqatmiñik tikiutraugisiruq atanniiviŋmun, suli kiñapayaaq nipliraqtuaq aniqatmiñun suksrauŋiññipḷugu tikiutraugisiruq uqaqsittaaġviŋmun, suli kiñapayaaq nipliraqtuaq aniqatmiñun kinnaunipḷugu tikiutraugisiruq ikniŋanun anasiñŋuqsaġvium. ");
INSERT INTO eskNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Taatnamik, aatchuityaġniġuvich aatchuutiksraqnik Agaayyutmun tuniḷḷaqtuġviŋmi itqaġluguasiiñ aniqatvich sua-tasamma akikŋautaa ilipnun, ");
INSERT INTO eskNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","uniḷḷugu aatchuutiksrautin sivuġaanun tuniḷḷaqtuġvium aasiiñ iłuaqsityaqqaaġlugu taimña akiŋautaa aniqatiupnun, aasiiḷi utiġutin aatchuutigityaġlugu aatchuutiksrautin. ");
INSERT INTO eskNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Akiḷḷiġikkaqpich uqaqsittaaġviŋmuutiniaqpatin iḷauraaġiliutiyumagiñ qilamik piqatigiŋŋaan apqutmi. Aatchuutigiviaġaatin atanniqsuqtimun, aasiiñ atanniqsuqtim qaiḷḷutin qaunaksrimun isiqtautqulutin. ");
INSERT INTO eskNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Uqautigikpiñ, Aniyumiñaipiaqtutin kisianik akiḷiiguvich akiqsruutipnik ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tusaamarusi itna uqaqsimaruamik, ‘Atlatuġniaqnak.’ ");
INSERT INTO eskNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aglaan uqautigipsi, Kiñapayaaq qiñiqtuaq aġnamik ikł̣igiplugu atlatuaniktuq isumamiñi. ");
INSERT INTO eskNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Taliqpium irivich killuqsaqtitpatin piiġḷugu igirruŋ. Nakuutluŋniaqtuq piyaqquġupku iḷaviñġa timivich uumakŋa iluqaan timivich igitaułiksraŋaniñ anasiñŋuqsaġviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Suli taliqpium argakpich killuqsaqtitpatin kipilugu igirruŋ. Nakuutluŋniaqtuq piyaqquġupku argałhiñan uumakŋa iluqaan timivich aullałiksraŋaniñ anasiñŋuqsaġviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Uqaqsimaruqsuli, Kisupayaam avitkumiuŋ nuliani qaitchiḷiuŋ aglaamik nalupqinaiġutinik avinnikun. ");
INSERT INTO eskNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aglaan uqautigipsi, Aŋutim nuliani tuniqsimagaluaŋŋaan ilaanun avitkumiuŋ atlatuqtitkaa. Taamna avittuaq patchisauruq. Suli aŋun nuliaqtuaq avittuamik atlatuqmiuq. ");
INSERT INTO eskNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tusaasimagiksisuli itna uqautaumaruaq iñugikkaptiknun iŋiḷġaan, Akiqsruqtaġuvich naviŋñiaqnagu aglaan atuumayumagiñ akiqsruutigikkan iñuŋnun Atanġum sivuġaani. ");
INSERT INTO eskNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aglaan uqautigipsi, Sumiunniiñ akiqsruġumiñaitchusi qiḷakun atakkii qiḷak Agaayyutim aquppiutaġigaa, ");
INSERT INTO eskNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","naagalu nunakun atakkii iñiqtuiqsiaqvigigaa isigaŋmiñun, naagalu Jerusalem-kun atakkii nunaaqqiġigaa kamanaqtuam umialgum. ");
INSERT INTO eskNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naagaqaa akiqsruġumiñaitchutin niaqupkun, atakkii atausiq nuyaq qatiqsipkaġumiñaitkiñ unniiñ taaqsipkaġlugu. ");
INSERT INTO eskNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Taatnamik, aŋiġniaġuvich aŋillapiaġumuutin suli naagaaġniaġuvich naagaallapiaġutin, atakkii supayaam uqałhum iḷḷatauruam tamatkuŋnuŋa pigiitchuamitŋaqtauruq. ");
INSERT INTO eskNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tusaamagiksi uqauttutauruaq, ‘Iri akisautiqaġli irimik, kiguttuuq kigutmun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aglaan uqautigipsi, Akisaqtuġniaqnagu iñuum pimaqłuktaqpatin. Kisupayaam isaksaqpatin taliqpiagun iqsraqpich alaġumagiñ igḷuanik iqsraqpich. ");
INSERT INTO eskNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kisupayaam akiḷiipkaġniaqpatin atnuġaapnik uqaqsittaaġviŋmi pipkaġumagiñ quppiġaan. ");
INSERT INTO eskNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Suli aŋuyaktim nunuriḷusi saagaqtitpasi natmaŋmiknik atautchimik mile-lamik saagautiyumagiñ malġuŋnik mile-laaknik. ");
INSERT INTO eskNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iñuum iŋiqpatin sumik-tasamma qaitchumagiñ ilaanun. Suli iñuk atugaksraġukpan itigautipkaġniaqnagu. ");
INSERT INTO eskNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tusaamagiksi itna uqaqsimaruaq, ‘Piqpagiyumagisi iñuuniaqatiusi aasiiñ uumigilugich uumiksrigikkasi.’ ");
INSERT INTO eskNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aglaan uqautigipsi, Piqpagiyumagisi uumiksrigikkasi suli agaayutilugich tamatkua piyuaqtigikkasi. ");
INSERT INTO eskNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Taatnaġupsi qiñiqtitkiksi iñuŋnun iłuaqqun atripḷugu aapari qiḷaŋmi ittuaq, atakkii siqiñini siqiññaaġiksitkaa pigiitchuanunlu nakuuruanunlu suli sialuktitlugu nalaunŋaruanunlu nalaunŋaitchuanunlu. ");
INSERT INTO eskNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Piqpagigupsigik kisiitñik tamatkua piqpaksrigikkasi, suvaata akiññaktaaqaġniaqpisi Agaayyutmiñ? Taatnatun tax-siliqirit pitḷapmiut. ");
INSERT INTO eskNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Suli paġlagupsigik kisiitñik aniqatiusi, savaaqaġniqpisi pitḷukhusi atlaniñ? Taatnatuntuuq tax-siliqirit pitḷapmiut. ");
INSERT INTO eskNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Taatnamik nalaunŋaruksraurusi atriḷugu aapagikkaqsi qiḷaŋmi nalaunŋallapiaqtuaq.” ");
INSERT INTO eskNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Qaunagititchi savaaġiniaqasiuŋ nalaunŋaruakun savaaqsi qiñiqqusaaqsiñaġusi sivuġaatni iñuich. Taatnaġupsi aapapsi qiḷaŋmiittuam akiḷiġumiñaitkaasi. ");
INSERT INTO eskNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Taatnamik aatchuġuvich nagliktuutinik nipitusiraġautiginiaqnagich atriḷugich ukpiŋŋuaqtit Jew-ŋuruat katraġviŋitñi suli tumitchiani kamasruqusaaqsiñaqhutiŋ iñuŋnun. Uqautigipsi, akiḷiusiaqaaniktut. ");
INSERT INTO eskNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aglaan aatchuġuvich nagliktuutinik inuqsraqtuanun saumik argaiñ iḷisimapkaġniaqnagu taliqpium argakpich savaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nagliktuisitchi nalunaqtuakun. Aapavich qiḷaŋmi qiñitlaruam supayaanik akiḷiusiaksritkisigaatin.” ");
INSERT INTO eskNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aasiisuli agaayugupsi piñiaqasi atriḷugich ukpiŋŋuaqtit, atakkii agaayullaturut makitaplutiŋ katraġviŋitñi suli saqquviŋitñi tumitchiat qiñillaŋniaquplutiŋ iñuŋnun. Uqautigipsi, akiḷiusiaqaaniktut. ");
INSERT INTO eskNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aglaan agaayutyaġniaġuvich isiġutin inipnun taluluguasiiñ suli agaayuyumautin aapapnun qiñiġnaitchuamun. Aapavich qiñitlaruam nalunaqtuakun akiḷḷiġisigaatin. ");
INSERT INTO eskNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Suli agaayuguvich nipliraġniaqnak imaiḷaanik uqautinik atriḷugich ukpiqtuaŋuŋitchuat, atakkii isumasuurut Agaayyutmun tusaagisiñipḷutiŋ takłiḷugu agaayugumiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tuvrautinasi, atakkii Agaayyutim aapapsi iḷisimagaa sumik inuqsraqtilaaqsi apiqsruġaluaqtitnasi ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Itna agaayuyumuusi, ‘Aapapta qiḷaŋmiittuatiin! Iñupayaaq nunami kamaksriḷi ilipnik ipqiqsitlugu taavrumuuna atqiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aullaġniiḷi aŋalatchił̣hiñ iñupayaanik. Iñupayaaq nunami tupiksriḷi pisułiġikkapnik qiḷaŋmi itmatuntuuq. ");
INSERT INTO eskNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aatchuqtigut uvluġaġikpan niqimik inuġikkaptiknik. ");
INSERT INTO eskNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Suli natqigutiluta killuqsautiptiknik natqigutrisimaaqmatun tamatkua savamaqłuutriruanik uvaptiknun. ");
INSERT INTO eskNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Suli sivulliutiniaqasigut uuktuaqsiułiġmun, aglaan annautiluta pigiitchuamiñ. Atakkii umialgurutin saŋŋipayaaqaqhutin kamanautiqaqhutinlu isuitchuamun. Amen.’ ");
INSERT INTO eskNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Atakkii natqigutigupsigik iñuich killuqsautrigikkasi, Aapapsi qiḷaŋmiittuam natqigutigisipmigaasi. ");
INSERT INTO eskNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aglaan natqigutiŋitkupsigik iñuich killuqsautrigikkasi, Aapapsi qiḷaŋmiittuam natqigutiyumiñaitmigaasi killuutipsitñik.” ");
INSERT INTO eskNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Suli uisauraaġupsi, qiññaqaqnasi ipiqtunaqsiḷusi ukpiŋŋuaqtitun. Qiññaġiiḷiraġaġniġaich kiiñatiŋ qiñiqqusaałhiñaqhutiŋ iñuŋnun iliŋitñik uisauraałiġmikni. Uqautigipsi, akiḷiusiaqaaniktut. ");
INSERT INTO eskNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aglaan uisauraaġupsi uqsruqtiġlugich niaqusi, suli iġġuġlugich kiiñasi; ");
INSERT INTO eskNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Qiñiqtiłhiñaġniaqasi iñuŋnun uisauraaġusi aglaan Aapapsitñun qiñiġnaitchuamun, suli Aapapsi qiñiqtuam nalunaqtuakun akiḷiusiaksritkisigaasi.” ");
INSERT INTO eskNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tugvaiñasi umialgutinik marrumuŋa nunamun, qupilġullu qałhumlu piiñġiqsakkaŋanun, suli tigliŋniaqtit siqumitchipḷutiŋ tigliktuġviatnun. ");
INSERT INTO eskNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aglaan tugvaisitchi anniġikkapsitñik qiḷaŋmun qupilġullu qałhumlu piiñġiqsaġumiñaisaŋanun, suli tigliŋniaqtit siqumitchumiñaisaŋatnun tigliŋniaġutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Atakkii anniġipayaakkavich irviatni uummatin tavraniitkisipmiuq.” ");
INSERT INTO eskNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Iri naniġigaa timim. Irrakkiñ qiñitlakpaknik qaunagilguniaqtutin aullapayaaġuvich. ");
INSERT INTO eskNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aasiiñ irrakkiñ pigiitpaknik ilvich saptaaqsiñiaqtutin. Aglaan qiñilguitchupku Agaayyun kaŋiqsitḷaiḷḷutin pisułhanik qanutunaglaan taaqtuaq ilipni tatamnaqtiginiaqpa!” ");
INSERT INTO eskNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kiñaliqaa savautriyumiñaitchuq malġuŋnik aŋaayuqaqaġuni. Atakkii uumigigisigaa iḷaqataa aasiiñ piqpagilugu iḷaqataa, naagaqaa iluqnauqsimaaġisiruq iḷaqataanun aasiiñ suksraaġlugu iḷaqataa. Savautriyumiñaitchutin iluqaaknik Agaayyutmiglu maniŋmiglu. ");
INSERT INTO eskNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Taatnamik uqautigipsi, isumaaluŋniaqasi iñuułipsitñik, sumik niġigisipmagaapsi suli imiġusi, naagaqaa timigikkaqsi sumik atnuġaaġisipmagaapsi. Uvva iñuułiq pitḷuktuaŋuŋitpa niqimiñ suli timi atnuġaaniñ? ");
INSERT INTO eskNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Qiñiqsigik tiŋmiurat siḷami. Nautchirriitḷaitchut naagaqaa kipritḷaitchut tugvaiḷutiŋlu siġḷuaġmiknun. Naagauvva Aapapsi qiḷaŋmiittuam niġipkaqsimaaġaġigai. Ilipsimi akisutluktuaŋuŋiññiqpisi tiŋmiuraniñ? ");
INSERT INTO eskNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nallipsi isumaaluguni iñuuniqtusiḷaaġisivauŋ iñuułłi? ");
INSERT INTO eskNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Suli suvaata isumaalugaġivisi atnuġaaksrapsitñik? Isummatigillaksigik qanuq nauriat nunami nauraġitilaaŋatnik. Savatlaitmiut naagaqaa ukił̣harritḷaitmiut. ");
INSERT INTO eskNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aglaan uqautigipsisuli, Solomon-unniiñ qanutun kamanaqtigigaluaqhuni atnuġaaqaŋiññiqsuq atripḷugich piññaqnaqtuat nauriat. ");
INSERT INTO eskNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Taatna Agaayyutim qaunagitlaniqpagich ivgich ittuat ugluvak aasiiñ uvlaakun igitauplutiŋ ikniġmun, qaitchigisigaasi atnuġaanik inuġikkapsitñik. Ukpiqsrił̣ikiññiaqpat! ");
INSERT INTO eskNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Isumaalukasi itnaġusi, Sumik niġiñiaqpisa imiġutalu atnuġaaqaġutalu? ");
INSERT INTO eskNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Atakkii ukpiŋaitchuat isumaalukmiraqtut supayaanik tamatkuniŋa. Aasiiñ aapari qiḷaŋmiittuaq iḷisimaruq inuqsraqtilaapsitñik iluqaitñik tamatkuniŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pakaaqqaaġilugu Agaayyun aŋalatchiruaq nalaunŋaruaŋupluni umialiktun. Taatnaġupsi qaitchigisigipsi inuġikkapayaapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Taatnamik isumaaluŋniaqasi uvlaakuksramik atakkii uvlaakuksraq isumaaluutiqaqtuq iŋmigun. Uvlulaat iłuiḷḷiuġutiqaaniktut iŋmigulaa.” ");
INSERT INTO eskNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Atanniiñiaqasi atlanik, Agaayyutimli atanniŋitchumagaasi. ");
INSERT INTO eskNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Atakkii atanniigupsi atlanik, taatnatuntuuq atanniikkaugisipmiusi. Taatnatuntuuq qanuq irrutrigupsi atlanik irrutikkaugisipmiusi. ");
INSERT INTO eskNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Suvaata tautukpiuŋ irriutaŋuluuraq aniqatvich iraani aasiiñ suliqutigiŋitḷugu tamanna qirugraitchiaq iripni? ");
INSERT INTO eskNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Qanuġuvva uqautriñiaġniqpich aniqatiupnun, ‘Piiġḷagu irriutaŋuluuraq irimiitan,’ qiñisuŋaqnagu qirugraitchiaq irimiitan? ");
INSERT INTO eskNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ukpiŋŋuaqtii, sivulliulugu piiqsirruŋ qirugraitchiaq iripniñ. Qiñilguniaġiñḷi nalupqinaiġḷugu irriutaiqsił̣iksran aniqatvich iraaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Qaiññiaqasigiŋ ipqitchuat sut qipmiñun, atakkii saatpiaġaasi siqumitchugusi. Naagaqaa iginniaqasigiŋ akisuruat suŋaurat sivuġaatnun kuniat, atakkii tutmaluginiaġaich isigaŋmiknik.” ");
INSERT INTO eskNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Iŋiġupsi qaisaugisiruq ilipsitñun, pakaaqaġupsi paqitkisigiksi; katchaktuġupsi talu aŋmakkauniaqtuq ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Atakkii kiñapayaaq iŋiqsruqtuaq akuqtuigisiruq, suli pakaaqaqtuaq paqitchigisiruq, suli talu aŋmakkaugisiruq kisupayaamun katchaktuqtuamun. ");
INSERT INTO eskNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kia iġñiñi qaitchigisivauŋ uyaġaŋmik iŋiqpan qaqquqtuġuguni? ");
INSERT INTO eskNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naagaqaa qaitchigisivauŋ nimiġiamik iŋiqpan aqaluktuġuguni? ");
INSERT INTO eskNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pigiitchaluaqhusi iḷisimaraġigiksi qanuq qaitchił̣iksraqsi nakuuruanik sunik qitunġaurapsitñun, maatnaasu aapasi qiḷaŋmiittuaq qaitchiñiapiaqtuq nakuuruamik tamatkunuŋa iŋiqsruqtuanun ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Qanusipayaatigun irrutitqusuugupsi atlanun iñuŋnun taatnatuntuuq irrutriyumausi atlanik. Taavruma atunim iḷigai iluqaisa iḷisauttutiŋich sivuniksriqirit suli maliġutaksraŋi Moses-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Isiġitchi amisuurakun paakun. Atakkii paa sivuniqaqtuaq piyaqquġviksramun aŋiruq, suli tumi tasamuŋa qaġanaqtuq aasiiñ iñugiaktuat igliġvigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aglaan paa sivuniqaqtuaq iñuułiġmun amisuurauraqtuq suli apqun tasamuŋa qaġanaitchuq. Aasiiñ iñugiakisuurat paqitkaat.” ");
INSERT INTO eskNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Qaunagititchi sivuniksriqiŋŋuaqtuanik utlautruqtuat ilipnun atnuġaaġutiŋ ipnaisun qaamiktigun, aglaan iḷumiktigun amaqqutun ugiaġnaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Asiaŋisigun iḷisaġiniaġisi. Iñuich asiaġniaġuuvat asiaviŋñik kakitḷuŋnaniñ, naagaqaa aqpiŋñik kakitḷaġnaligaaniñ? ");
INSERT INTO eskNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Napaaqtuġiksuaq nauriraqtuq asiaġiksuanik, aglaan napaaqtuġiiḷaq nauriraqtuq asiaġiitchuanik. ");
INSERT INTO eskNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Napaaqtuġiksuaq nauritḷaitchuq asiaġiitchuanik, suli napaaqtuġiitchuaq nauritḷaitchuq asiaġiksuanik. ");
INSERT INTO eskNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Napaaqtupayaaq asirritḷaitchuaq asiaġiksuanik kipikkauraqtuq igitaupluniasiiñ ikniġmun. ");
INSERT INTO eskNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Taatnamik asiaŋisigun iḷitchuġiniaġisi, ami iñuuniallaułhatigun.” ");
INSERT INTO eskNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kiñapayaaq uqaqtuaq uvaŋnun, ‘Ataniiq,’ isiġumiñaitchuq aŋaayuqautaanun Agaayyutim, aglaan kisiitñik tamatkua tupiksriruat pisułhanik aapam qiḷaŋmiittuam. ");
INSERT INTO eskNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aqulliġmi uvlumi iñugiaktuat iñuich uqaġisirut uvaŋnun, ‘Ataniiq, sivuniksriqisuurugut atiġikkapkun anitqataqługich irrusiqł̣uich suli savaaqaqhuta iñugiaktuanik quviqnaqtuanik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aasiiñ nalupqinaiġḷugu uqautigisigitka, ‘Piiġitchi uvaŋniñ. Iḷisimaŋiññiġipsi, pigiiḷiqirisii!’” ");
INSERT INTO eskNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Taatnamik kisupayaaq tusaaruaq tamatkuniŋa nipliuttutigikkamnik aasiiñ atuġlugich, atriqaqtuq puqiksaamik iñuŋmik tuppiruamik uyaġaum qaaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sialugruaġuqman kuugich ulitlutiŋ, suli anuqłiġruaġuqman makitalgupluni taamna tupiq ulġuŋiññiqsuq, atakkii turviqaqhuni uyaġaŋmik. ");
INSERT INTO eskNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aglaan kisupayaaq tusaagaluaqhuni nipliuttutimnik atuumaŋitñamigich atriqaqtuq isumalguitchuamik iñuŋmik tuppiruamik qaviam qaaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sialugruaġuqman kuugich ulitlutiŋ, suli anuqłiġuqman makitalguitḷuni tupiq ulġuniqsuq suksraunġiḷḷapiaqhuni.” ");
INSERT INTO eskNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus uqaŋaiqman taapkuniŋa iñugiaktuat iñuich quviġusuŋniqsut iḷisauttutaiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Atakkii Jesus-ŋum iḷisautiniġai aŋalatchisiqaqtuatun iñuktun, atrisuŋaqnagich aglaliqirit. ");
INSERT INTO eskNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus atqaqman qimiġaamiñ, iñugayaaqpaurat maliŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tavrani auyugaqtualgum utlakami sitquġviginiġaa sivuġaanun uqaqhuni, “Ataniiq, pisuksiñaġuvich mamitiłhiñaugikma.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus-ŋum isakługich argakni aksiŋñiġaa nipliqhuni, “Piyummatiqaqtuŋa, mamittin!” Tavrauvaa aŋutim auyugaqtuaŋa mamitikkauruq. ");
INSERT INTO eskNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus-ŋum uqautiniġaa, “Uqaġniaqnak kisumununniiñ iñuŋmun, aglaan tautuktitchaqtuaġiñ agaayuliqsimun isivġiuqtillutin. Aatchuiyumautin tuniḷḷautinik Agaayyutmun tuvraġlugu Moses-ŋum tillisaa. Taatnaġuvich iñupayaam iḷitchuġiniaġaa mamitilaan.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus tikitman Capernaum-mun, aŋuyyiuqtit qaukłiata Rome-maġmium paaġniġaa apiqsruqługu ikayuqupluni. ");
INSERT INTO eskNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tavra nipliġñiqsuq, “Ataniiq, savaktiga amma kiŋunimni nalaruq aulatlaitchuaq iłuiḷḷiullapiaqhuni.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus-ŋum nipliutiniġaa, “Utlakkisigiga aasiiñ iłuaqsiḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aŋuyyiuqtit qaukłiata kiuniġaa, “Ataniiq, utlaktaksrauŋiḷuqtuŋaunniiñ tupimnun, aglaan tillisiqałhiñaġiñ savaktigali iłuaqsiyumuuq. ");
INSERT INTO eskNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Atakkii aŋalatiqaqmiuŋa qaukłiġñik suli aŋuyyiuqtiqaqłuŋa aŋalatamnik. Tilikapku una, ‘Aullaġiñ!’ aullaġaqtuq. Suli tilikapku taamna, ‘Qaġġaiñ!’ aggiġaqtuq. Suli tilikapku savaktigikkaġa, ‘Taamna piuŋ!’ piraġigaa.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus-ŋum tusaakamiuŋ taamna quviġusuŋniqsuq. Nipliutiniġai iñuich maliktuat iŋmiñik, “Iḷumun uqautigipsi, paqitchiŋitchuŋa Israel-unniiñ kisumik ukpiqsriḷḷapiaqtuamik uumatun. ");
INSERT INTO eskNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Suli nipliutigipsi, Iñugiaktuat Jew-ŋuŋitchuat aggiġisirut kivaknamiñ suli kanaknamiñ aquvillutiŋaasiiñ niġiqpaktuani Agaayyutim aŋaayuqautaani piqatigilugich Abraham-lu Isaac-lu Jacob-lu. ");
INSERT INTO eskNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aglaan tamatkua Agaayyutmun qitunġaġiniruat igitaugisirut taaġniqsrallapiamun. Tavrani qiagisirut tiriquulalutiŋunniiñ kigutiŋich.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus-ŋum nipliutiniġaa aŋuyyiuqtit aŋalataat, “Aŋiḷaaġiñ. Ukpiqsrił̣ł̣apkun iñiqtaugisiruq.” Taavrumatavra savaktaa mamitkaniktiġñiqsuq taavrumani sassaġniġmi. ");
INSERT INTO eskNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus isiqami Peter-m tupqanun tautuŋniġaa Peter-m aakaruaŋa nalaruaq uunaqłuktitluni. ");
INSERT INTO eskNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus-ŋum aksiŋñiġaa argaigun aasiiñ uunaqłuŋaiqhuni. Tavra makitiqhuni niqłiuġutiaqsiñiġai. ");
INSERT INTO eskNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Unnuksraaqman iñugiaktuat irrusiqł̣uqaqtuat tikiutruġniġaich ilaanun, aasiiñ Jesus-ŋum anittaġniġai irrusiqł̣uich uqałiġmiñik, suli iłuaqsipḷugich iluqaisa atniġñaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Atuumakamiuŋ taamna taŋiġñiġaa sivuniksriqirim Isaiah-m uqautigikkaŋa, “Ilaan piiġai sayairrutivut timikun suli akigaġiplugich atniġñautivut.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus-ŋum tautukamigich iñugayaat avatimiñi tiliñiġai maliġuaqtini ikaaquplugich igḷuanun narvaqpaum. ");
INSERT INTO eskNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aglaliqiri utlautiniqsuq ilaanun nipliqhuni, “Iḷisautrii, malikkisiikpiñ sumupayaaġuvich.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus-ŋum kiuniġaa, “Kayuqtut sisiqaqtut tiŋmiuratlu siḷam ugluqaqhutiŋ, aglaan Iġñiŋan Iñuum iniksraitkaa napmun tullałiksraŋa niaquġikkaġmi.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Atlamsuli maliġuaqtim nipliutiniġaa, “Ataniiq, iḷuviġiallaktiqqaaġlugu aapaga malikkumaikpiñḷi.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aglaan Jesus-ŋum uqautiniġaa, “Maliŋŋa, tamatkua tuquŋaruat irrutchikun iḷuviqsillich tuquŋaruanik.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aasiiñ ikiniqsuq umiamun maliġuaqtaiḷu malikhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tavrakŋatchiaq anuqłiġruaġuġniqsuq narvaqpak qaiqpaich immautruġnialiqługu umiaq, aglaan Jesus siñiktuaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Maliġuaqtaiñ utlakługu iqiiqsaġniġaat nipliqhutiŋ, “Ataniiq, anniqsuqtigut piyaqquaqsirugut.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aglaan nipliutiniġai, “Ukpiqsrił̣ikiññiaqpat! Suvaata iqsivisi?” Makitnami iñiqtiġniġik anuġilu qaiqpaiḷḷu, aasiiñ quunniġuġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Maliġuaqtai quviġusukhutiŋ uqaġniqsut, “Qanusiuniqpa una aŋun anuġimunniiñ qaiḷiqpauratlu kamagivatruŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus tikitman igḷuanun narvaqpaum nunaŋanun Gadarenes, malġuk aŋutik irrusiqł̣ullak nuyuaġnallapiaqtuak aggiqhutik iḷuviġniñ paaġniġaak, kia-unniiñ iñuum qaaŋiḷguisak apqutmi. ");
INSERT INTO eskNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iġialaniqsuk, “Suniaqpisiguk? Aggiqpich nagliksaaqtitchaqtuaqhunuk sivuani piviksram?” ");
INSERT INTO eskNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kuniaqaġniqsuq iñugiallapiaqtuanik niġiruanik uŋasipiaŋitchuami. ");
INSERT INTO eskNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Irrusiqł̣uich iŋiqsruaġniġaat Jesus, “Aninniaġuptigut tuyuġisigut tamatkunuŋa kunianun.” ");
INSERT INTO eskNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus-ŋum nipliutiniġai, “Aullaġitchi!” Aasiiñ anikamiŋ malġuŋniñ aŋutiŋniñ isiġniqsut munaqsranun kunianun. Iluqatiŋ kuniat paŋaliŋniqsut tuŋaanun narvaqpaum, naparaqhutiŋ qutaiḷakun ipnakun aasiiñ ipiplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Qaunaksriruat kunianik pigruġniqsut nunaaqqimun. Tarani uqautiginiġaat iluqaan qanuqtilaaŋak aŋutik irrusiqł̣ullak. ");
INSERT INTO eskNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iluqatiŋ nunaaqqim iñuiñ paaġniġaat Jesus. Tautukamitruŋ iŋiqtiġniġaat unitquplugu nunaaqqiqtiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus ikipluni umiamun ikaaġniqsuq aasii tikitḷuni nunaaqqimiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iḷaŋich iñuich tikiutriñiqsut aulatlaitchuamik nalaruamik ikivġani. Jesus-ŋum tautukamiuŋ ukpiqsrił̣hat nipliġñiqsuq aulatlaitchuamun, “Iḷauraamaaŋ, quviatchauġigiñ. Killuqsautitin natqigutikkaurut.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iḷaŋich aglaliqirit uqaġniqsut iŋmiknun, “Una iñuk uqaġniqłuktaġniqsuq.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus iḷisimaplugich isummatiŋich nipliġñiqsuq, “Suvaata isumavisi pigiitchuanik? ");
INSERT INTO eskNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nalliaknik qaġanatlukpa nipliqsuni, ‘Killuqsautitin natqigutikkaurut,’ naagaqaa nipliqsuni, ‘Makillutin pisugiñ?’ ");
INSERT INTO eskNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iḷitchuġitqugipsi Iġñiŋanik Iñuum aŋalatchisiqaqtilaaŋanik nunami natqigutritḷaruamik killuqsautinik.” Tavraasiiñ nipliġñiqsuq aulallaitchuamun, “Makillutin tigulugich ikivġatin aggiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aŋun makitluni aiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iñugayaat qiñiqtuat taavrumiŋa quviġutchaŋniqsut, aasiiñ kamaksruġniġaat Agaayyun qaitchiruaq taatnatchimik aŋalatchił̣iġmik iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus aullaqami tavrakŋa tautuŋniġaa aŋun atilik Matthew-mik aquppiruaq tax-siliqiviŋmi nipliutipluguasii, “Maliŋŋa.” Matthew-m makitluni maliŋniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesus niġiñiaqtitlugu Matthew-m tupqani iñugiaktuat tax-siliqirit suli killuliqirit isiqhutiŋ niġiqasiġniġaich Jesus-ŋum maliġuaqtaiñḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee-ŋuruat tautukamitruŋ taamna apiqsruġniġaich maliġuaqtai, “Suvaata iḷisautriksi niġiñiaqatauva tax-siliqirini suli killuliqirini?” ");
INSERT INTO eskNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus-ŋum tusaakamiuŋ Pharisee-ŋuruat apiqsruutaat nipliġñiqsuq, “Tamatkua surruitchuat inuqsratlaitchut taaktimik, aglaan tamatkua atniġñaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ki, iḷitchaqsiuŋata taavruma uqałhan qanuutautilaaŋanik, ‘Kimmutigitlukkiga nagliktaq uumakŋa tuniḷḷaqtułiġmiñ.’ Aggiŋitchuŋa tuqłuġiaġlugich nalaunŋaruat, aglaan killuliqirit.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maliġuaqtaiñ John-ŋum utlaŋniġaat Jesus aasii apiqsruqługu, “Suvaata uvagut Pharisee-ŋuruatlu uisauraaġaġivisa aasiiḷi maliġuaqtitin taatnatun piñġitmipkaqługich?” ");
INSERT INTO eskNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus-ŋum kiuniġai, “Iḷauraaŋi iḷaqatniŋniaqtuam alianniutlaitchut ilaan nayuqataułhani iliŋitñi. Aglaan katchuutiniaqtuam unitchiviksraŋa tikiññiaqtuq. Tavrali aullaanikpan iḷauraaŋi alianniuġisirut uisauraaġutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Iñuk iḷaaqtuitḷaitchuq nutaamik iḷiqniġmik atnuġaaluŋmun, atakkii iḷaaġutauruaq algutiniaqtuq utuqqaqtuamiñ atnuġaamiñ aasiiñ allaq aglitḷukhuni. ");
INSERT INTO eskNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naagaqaa iñuich kuviritlaitchut nutaamik misuqqumik puuġruanun. Taatnaġaluaqmikpata puuġruat qaaġniaqtut aasiiñ misuġuq kuviḷuni suli puuŋich suksraunġiġutiŋ. Aglaan kuviraġigaat nutaaq misuġuq nutaamun puumun. Iluqatikli puuġlu misuġuġlu piiñġiŋitchumuuk.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Taatna uqaqtitlugu tamatkunuŋa sivulliuqtim Jew-ŋuruat katraġviata tikiññiqsuq sitquqhuni sivuġaanun Jesus nipliqhuni, “Paniga amma tuquqammiqsuq. Maligluŋa aksigiaġuŋ argaknik iñuuluniasiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus-ŋum makitluni maliŋniġaa piqatigiplugich maliġuaqtini. ");
INSERT INTO eskNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Maliktitlugu aġnam aunaaqsruġuitḷaiqsuam qulit malġuŋni ukiuni tikiññiġaa tunuanun Jesus-ŋum, aksikł̣uguasiiñ atnuġaaŋan akuagun ");
INSERT INTO eskNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","isumapluni iŋmiñun, “Aksiḷḷagukkaluaġiga quppiġaaŋa mamilluŋaasiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus-ŋum kiŋiaqami qiñiġniġaa aġnaq nipliutipluguasiiñ, “Aġnaaq, quviatchauġigiñ. Ukpiqsrił̣iqpich iłuaqsipkaġaatin.” Tavrakŋatchiaq aġnaq iłuaqsikkauniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesus-ŋum tikitñami sivulliuqtim tupqanun tautuŋniġai supluaqtuġnanik atuqtuuraqtit iñugayaatlu kiŋuvġuruat. ");
INSERT INTO eskNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nipliġñiqsuq, “Annisitchi. Niviaqsiaġruk tuquŋaŋitchuq. Siñiktuaqsiñaqtuq.” Aglaan iñuich mitautiginiġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iñugayaat anianikmata, Jesus isiġniqsuq niviaqsiaġruum inaanun. Tigupmaniasiiñ argaŋmigun niviaqsiaġruk makinniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iñuich siaminniġaat tusaayugaallautaq taavrumuuna nunaaqqipayaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus aullaqman tavrakŋa malġuk ayauŋaruak aŋutik maliŋniġaak kappaiŋaplutik, “Nagligillaŋniaqtiguk, iġñiġikkaŋatiin David-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus isiqman tupiġmun ayauŋaruak utlaŋniġaak. Aasiiñ Jesus-ŋum apiqsruġniġik, “Ukpiġivitku uvamnun taamna savaaġitlatilaaŋa?” Taapkuak kiuniġaak, “Aa, Ataniiq.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesus-ŋum aksiŋñiġik iriŋikkun nipliutiplugik, “Ukpiġipluŋa taatnaqhutik qiñitlasitqiksutik.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Taapkuak aŋutik qiñitlasitqiŋñiqsuk. Jesus-ŋum alġaqsrullapiaġniġik uqaquŋitḷugik kisumununniiñ taavrumiŋa, ");
INSERT INTO eskNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","aglaan aullaqamik siaminniġaak tusaayugaallautaq Jesus-kun nunaaqqipayaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Taapkuak aniaqsipmiuglu. Aŋun irrusiqł̣ulik uqatlaiḷaaq Jesus-muutikkauniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Irrusiqł̣uk anitmagu uqatlaiḷaaq aŋun uqaaqsiñiqsuq, iñugayaat quviġusukhutiŋ nipliġñiqsut, “Qaŋaunniiñ tautuksimaiññiqsugut atriŋanik uuma Israel-mi.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aglaan Pharisee-ŋuruat nipliġñiqsut, “Anitchiraqtut irrusiqł̣uŋnik atuqługu saŋŋia aŋalataata irrusiqł̣uich.” ");
INSERT INTO eskNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aasiiñ Jesus kukiḷuŋniqsuq nunaaqqipayaani nunaaqqiuraniḷu, iḷisautripḷuni Jew-ŋuruat katraġviŋitñi quliaqtuaġiplugulu tusaayugaallautaq Agaayyutim aŋaayuqautaagun suli mamititlugich qanusipayaanik atniġñautilgiḷḷu naŋirrutilgiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tautukamigich iñugayaat iḷunŋutchaŋniqsuq, atakkii iłuiḷḷiuqhutiŋ qanuqsausiuqhutiŋlu atripḷugu ipnaiq qaunaksraiḷaaq. ");
INSERT INTO eskNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesus-ŋum uqautiniġai maliġuaqtini, “Katittaksraq iḷumun iñugiakkaluaqtuq, aglaan savaktit ikittut. ");
INSERT INTO eskNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iŋiqsruqsiuŋ aŋaayuqaŋa katitchivium tuyuqaqulugu savaktinik katitchiviŋmun.” ");
INSERT INTO eskNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus-ŋum iŋmiñuquniġai qulit malġuk maliġuaqtini, aasiiñ saŋŋiksriññiġai anitchitḷasipḷugich irrusiqł̣uŋnik suli iłuaqsipkaitḷasipḷugich qanusipayaanik naŋirrutiliŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Uvva ukua qulit malġuk uqqiraqtaiñ atiŋich: Sivulliq Simon taiguutiqaqtuaq Peter-mik, aniqataalu Andrew, James-lu John-lu iġñak Zebedee-m, ");
INSERT INTO eskNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip-lu, Bartholomew-lu, Thomas-lu, Matthew-lu tax-siliqiri, James-lu iġñiŋa Alphaeus-ŋum, suli Thaddaeus, ");
INSERT INTO eskNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon-lu iḷaŋata Zealot-kuaqtuat, suli Judas Iscariot aatchuutigitniktuaq Jesus-mik aquvatigun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Taapkua qulit malġuk Jesus-ŋum tuyuġiniġai alġaqsruqługich itnaqhuni, “Aullaġniaqasi Jew-ŋuŋitchuanun naagaqaa isiġniaqasi nunaaqqipayaaŋitñun Samaria-ġmiut. ");
INSERT INTO eskNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Aglaan aullałhiñaġitchi iñuiñun Israel-ŋum ittuanun tammaummiruatitun ipnaisun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aasiiñ iglaułłapsitñi quliaqtuaġiyumagiksi, ‘Agaayyun aŋalatchił̣hiñaaġuqtuq iñuŋnik nutaakun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Iłuaqsipkaiḷusi atniġñaqtuanik, aŋipkaqtillugich tuquruat, mamititchiḷusi auyugaqtualgitñik, anittaġlugich irrusiqł̣uich, suli aatchuutigiyumagiksi akuqtuaġikkaqsi akiiḷaaġlugu. ");
INSERT INTO eskNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Maniḷigaaġniaqasi kaviqsaamiglu qatiqtaamiglu unniiñ kanŋuyamiglu. ");
INSERT INTO eskNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Puukataiḷaaġusi aullaġupsi, quppiġaatqiutaiḷaaġusiḷu, suli aluġutitqiutaiḷaaġusi, naagaqaa ayauppiaŋiḷaaġusi, atakkii savakti piqaqtitaksrauruq inuġikkaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nunaaqqimupayaaġupsi naagaqaa nunaaqqiuramun pakakkumausi iñuŋmik tukkiiyumaruamik, aasiiñ tukkuummiḷusi tupqani aullaġniałłapsitñunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tukkuummigupsi taavrumani tupiġmi nipliġumuusi, ‘Agaayyutim iłuaqqutillaŋniaġumagaasi.’ ");
INSERT INTO eskNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iñuich taapkua paġlakpasi tutqiutiqaġniaqtut. Aglaan paġlaŋitpasi tutqiutiqaġumiñaitchut. ");
INSERT INTO eskNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kisupayaam akuqtuŋitpasi naagaqaa naalaġnisuŋitpatigik uqauttutisi, ipsuktuqsiuŋ apyuq isigapsitñiñ aniñiaġupsi tupiġmiñ naagaqaa nunaaqqimiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iḷumun uqautigipsi, qaġanatluŋniaqtuq iñuiñi Sodom-ŋum Gomorrah-ŋumlu Atanniivium uvluani taapkunakŋa iñuiñiñ tukkuliiŋitchuamiñ ilipsitñik nunaaqqiatni. ");
INSERT INTO eskNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tuyuġiniaġipsi ipnaisun akunġatnun amaqqut. Taatnamik puqikkumausi nimiġiatun suli suqłukkatatlaitchuatun tiŋmiaġruuratun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Qaunagilugich iñuich, atakkii uqaqsittaaġviŋmuutigisigaasi ipiġaqtuġlusi Jew-ŋuruat katraġviŋitñi. ");
INSERT INTO eskNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Suli pisigiluŋa tikiutrauniaqtusi sivuġaatnun kavanauruat umialgiḷḷu. Piviksraqaġisirusi iḷisimaraulusi iliŋitñun suli Jew-ŋuŋitchuanun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aglaan tiguraugupsi isumaaluŋniaqasi qanuq naagaqaa sumik uqaġniaqtilaapsitñik, atakkii tavraġuqpan qaitchikkauniaqtusi uqaksrapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Atakkii ilipsi uqaġumiñaitchusi, aglaan Irrusiŋa Aapapsi uqaġisiruq ilipsigun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aniqatim aatchuutigigisigaa aniqatni tuqqutautqulugu, suli aapam pigisipmigaa taatnatun qitunġaurani; iḷiḷgaat akikŋaqtuipmiñiqsut aŋayuqaaġmiknik aasiiñ aŋayuqaatiŋ tuqqutillugich. ");
INSERT INTO eskNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Iñupayaam uumigiliutigisigaasi piqutigiluŋa, aglaan makitaruaq payaŋaiġuni isuanun anniqsukkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Piyuaqsiugupsi uumani nunaaqqimi, qimakkumuusi atlamun nunaaqqimun. Iḷumun uqautigipsi naatchitḷasigaluaqasi savaapsitñik nunaaqqipayaaŋitñi Israel-ŋum Iġñiŋa Iñuum aggiġisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Maliġuaqti kamanatlutlaitchuq iḷisautrimiñiñ, naagaqaa savakti aŋaayuqaġmiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iñuich uumigigisigaat maliġuaqti atunim iḷiḷugu uumigipmatun iḷisautrigikkaŋa, suli taatnatuntuuq savakti aŋaayuqaŋatun. Iñuich tuqłiraġniqpatruŋ aŋaayuqaŋa tupqum Beelzebub-mik tupiqatauruat maatnaasu tuqłiraġniaġaich taavrumiŋa atiġmik. ");
INSERT INTO eskNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Iqsiginiaqnasigik iñuich. Supayaaq matuqaqtuaq sagvikkaugisiruq, suli nalunaqtuapayaaq iḷitchuġipkakkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Uqautigikkaġa ilipsitñun taaġmi uqautigiyumagiksi qaumami. Suli iñuich isivruutigikkaŋat siuttapsitñun quliaqtuaġiyumagiksi tupqich qaaŋatniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Suli iqsiginiaqnagich iñuich tuqqutchiraġaqtuat timimik, aglaan tuqqutchumiñaitkaat iñuusiq; sivuuġagiłhiñaqsiuŋ taamna piyaqquitḷaruaq iluqaaknik iñuutchimiglu timimiglu anasiñŋuqsaġviŋmi. ");
INSERT INTO eskNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Uvva malġuk tiŋmiurak tunitḷaitpak atautchimun nalliġḷugik maniuramik? Naagauvva nalliakunniiñ katakkumiñaitchuq nunamun aapagikkaqsi naluŋŋaan. ");
INSERT INTO eskNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Agaayyutim iḷisimagai iluqaisa nutchasi niaqupsitñi suli qanutun iñugiaktilaaŋat. ");
INSERT INTO eskNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Taatnaġusi sivuuġanasi, akisuruaŋutluktusi tamatkunakŋa tiŋmiuraġayaaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Taatnamik kisupayaaq nalupqinaiqhuni uqaqpan sivuġaatni iñuich piginiḷuni uvamnun, ilaa nalupqinaiġḷugu uqaġigisipmigiga sivuġaani Aapaa qiḷaŋmiittuam. ");
INSERT INTO eskNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aglaan kisupayaam piiḷaaġikpaŋa iñuŋnun piiḷaaġigisipmigiga Aapaanun qiḷaŋmiittuamun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Isumaniaqasi aggiġñiḷuŋa tikiutityaġlugu tutqiun nunamun aglaan savikpak. Aggiŋitchuŋa iñuich piqatigiiksityaġlugich aglaan atinġiquplugich. ");
INSERT INTO eskNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Atakkii piqutigiluŋa iġñiġuruat akikŋaqtuitḷasipḷugich aapamiknik, paniuruat aakamikniglu, ukuaŋuruat aakaruamikniglu. ");
INSERT INTO eskNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iñuum tupiqatiŋi uumigirigigisigai. ");
INSERT INTO eskNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Iñuum piqpagitlukkumiuŋ aapani naagaqaa aakani uvamniñ maliġuaqtaulguyumiñaitchuq uvamni, suli iñuum piqpagitlukkumiuŋ iġñiġikkani naagaqaa panigikkani uvamniñ maliġuaqtigiŋitkiga. ");
INSERT INTO eskNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Suli iñuum akiggiutiŋitkumiuŋ sanniġutani maligluŋa maliġuaqtigiŋitkiga. ");
INSERT INTO eskNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iñuum tigummiñiaqtuam iñuułiġmiñik tammaigisigaa iḷumutuuruaq iñuułiq; aasiiñ iñuum tammaigumiuŋ iñuułłi piqutigiluŋa piññaktaaġigisigaa. ");
INSERT INTO eskNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Iñuum akuqtuqpasi akuqtullapiaqmigaaŋa, suli kisupayaaq akuqtuiruaq uvamnik akuqtullapiaqmigaa tuyuġiriga. ");
INSERT INTO eskNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kiña iñuk akuqtuiruaq sivuniksriqirimik pisigiplugu sivuniksriqiraupluni akuqtuigisiruq sivuniksriqirit akiññaktaaksraŋatitun, suli iñuk akuqtuiruaq nalaunŋaruamik iñuŋmik pisigiplugu nalaunŋaruaŋułha iñuum akuqtuigisiruq nalaunŋaruaŋułha iñuum akiḷiusiaŋatun. ");
INSERT INTO eskNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Suli kisupayaaq aatchuiruaq atautchimununniiñ makua kamanaiññiqsrauruat maliġuaqtima nigliñaqtuamik imiġmik qallutmun pisigilugu maliġuaqtaułha, iḷumun uqautigipsi, tammaiyumiñaiḷḷapiaġaa akiḷiusiaksrani.” ");
INSERT INTO eskNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus naatchianikami iḷisautrił̣iġmiñik qulit malġuk maliġuaqtimiñik aullaġniqsuq tavrakŋa iḷisautrityaqhuni suli quliaqtuaġiaqhuni nunaaqqiŋitñun Galilee-m. ");
INSERT INTO eskNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John tusaakami isiqtaułiġmiñi qanuq Christ, anniqsuqti akiqsruutauruaq, savaaqaqtilaaŋanik, tuyuġiniġik malġuk maliġuaqtiŋni ");
INSERT INTO eskNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","apiqsruġiaquplugu Jesus, “Taimñauvich John-ŋum uqautigikkaŋa aggiġñiaġnipḷugu? Naaga niġiuŋniaqpisa atlamik?” ");
INSERT INTO eskNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus-ŋum kiuniġik, “Utiġusik uqautigityakku John-mun tusaakkaqsik suli qiñikkaqsik. ");
INSERT INTO eskNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ayauŋaruat qiñitlasipḷutiŋ, pisutlaitchuatlu pisutlasipḷutiŋ, auyugaqtualgiḷḷu mamitikkauplutiŋ, tusaatlaitchuat tusaatlasipḷutiŋ, tuquŋaruat aŋipkaqługich, suli tusaayugaallautaq quliaqtuaŋupluni iḷaippaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Quvianamiuruq iñuk qapiqtaŋitchuaq pisigiluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John-ŋum maliġuaqtik aullaaqsipmaknik Jesus uqaaqsiñiqsuq iñugayaanun John-kun, “Sumik qiñiġiaqpisi iñuiḷaami nunami, ivigaamik aŋalataakkaŋanik anuġim? ");
INSERT INTO eskNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Sumikmi qiñiġiaġniqpisi? Iñuŋmik atnuġaaqaqtuaq akisuruanik? Naagga, tamatkua atuqtuat akisuruanik atnuġaanik iñuuniaqtuaŋurut umialgum tupiqpaŋani. ");
INSERT INTO eskNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Taitñiŋitpan sumikmi qiñiġiaqpisi? Sivuniksriqirimik? Aa, John qiñikkaqsi pitḷuktuq sivuniksriqirimiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uvvauna aglausimaruaq John-kun, ‘Ataŋii, tuyuġigisigiga uqqiraqtiga sivupni. Itqanaiyaġisigaa apqutiksran sivunnapni.’ ");
INSERT INTO eskNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iḷumutuuruamik uqaqtuŋa ilipsitñun, John Paptaaqtitchiri kamanatluktuq iñuŋniñ aniruaniñ nunami uvuŋanunaglaan. Aglaan iñupayaaq kamanaiññiqsrauruaq ukunakŋa Agaayyutim aŋalataŋiñiñ kamanatluktuq John-miñ. ");
INSERT INTO eskNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John Paptaaqtitchiri sagviqman Agaayyun aullaġniiñiqsuq aŋalataġmiñik iñuŋnik, aglaan iñuich saqłaktuat aippaavak akiḷḷiḷiqsuiñiqsut uvuŋanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Atakkii sivuniksriqiripayaat suli Moses-ŋum maliġutaksraŋiñ uqaġigaat John-ŋum aggiġñiałhanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ukpiġisukkupsiuŋ sivuniksriqirit uqaġikkaŋat ukpiġiniaġiksi John Elijah-ŋutilaaŋanik aggiqsaġumaruamik. ");
INSERT INTO eskNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kiña iñuk siutiqaqtuaq tusaali. ");
INSERT INTO eskNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sumik atriqaqpat makua iñuuruat pakma? Ittut iḷiḷgaatun aquppipḷutiŋ tuniriñiaqtuatun katimmaviŋñi suli tuqłirautiplutiŋ avatmun, ");
INSERT INTO eskNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Atuqtuurautigaluaġipsi aglaan aġġiŋitḷusi.’ ‘Atuqhutali kiŋuvġuutinik aglaan qiaŋitchusi.’ ");
INSERT INTO eskNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","John aggiqami niġitḷaiññiqsuq imiġluniḷu, naagasuli iñuich uqaqtut irrusiqł̣uqaġnipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iġñiŋa Iñuum aggiqami niġitḷapluni imitlapluniḷu atlatitun, aglaan uqautiginiġaat itna, ‘Marra niġġiqsuruaq imiqtuqtilu, iḷauraaġiniġaat tax-siliqirit killuliqiritlu.’ Agaayyutim puqiutaa iḷitchuġipkautauruq iḷumutuuplugu savaaŋagun.” ");
INSERT INTO eskNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aasiiñ Jesus-ŋum iñiqtiaqsiñiġai iñuich nunaaqqiñi savaaqaġvigitlukkani quviqnaqtuanik atakkii isummitqiŋitmata. ");
INSERT INTO eskNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nakłiuŋ Chorazin-naġmiusii! Nakłiuŋ Bethsaida-ġmiusii! Savaaqaġaluaqtuŋa iñugiaktuanik quviqnaqtuanik akunnapsitñi. Makua quviqnaqtuat qiñikkasi savaaŋuniqpata iŋiḷġaanimma Tyre-miḷu Sidon-miḷu iñuich taimani isummitqianikkayaqtut miissuŋnik atnuġaaġutiŋ suli aġramun aquvillutiŋ qiñiqtitlugu taavrumuuna mumił̣iqtiŋ killuqsautmikniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aglaan uqautigipsi, Uvluani atanniivium igḷutuyunaitḷukkisiruq ukuŋnakŋa Tyre-miñḷu Sidon-miñḷu ilipsitñi. ");
INSERT INTO eskNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aasiiñ Capernaum-miusii! Kamanaġasugivisi? Iktaugisirusi anasiñŋuqsaġviŋmun. Atakkii quviqnaqtuat savaaŋuruat ilipsitñi savaaŋuniqpata Sodom-mi, ittuiñaġayaġaluaqtuq uvuŋanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aglaan uqautigipsi, Sodom-miut atanniusiaksraŋat qaġanatluŋniaqtuq atanniusiaksrapsitñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tavraasiiñ Jesus nipliġñiqsuq, “Aapaaŋ, atanġuruatiin qiḷaŋmi nunamiḷu, quyagikpiñ! Sagviġitin puqiitchuanun sut iriqsimaruat puqiksuaniñ iḷisimaruaniñḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aa, Aapaaŋ, taamna sivunniutigikkan quviagigiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aapaa saŋŋipayaat qaitkai uvamnun. Kia-unniiñ iñuum iḷisimaŋitkaa iġñiġuruaq aglaan kisimi aapam. Suli kia-unniiñ iḷisimaŋitmigaa aapa aglaan kisimi iġñiġuruam iñupayaamlu iġñiġuruam iḷitchuġipkakkaŋa aapamik. ");
INSERT INTO eskNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Minġuqtuasii uqumaiḷḷiuqtuasiiḷu! Uvuŋaġitchi, minġuiqsiaqtitchumagipsiḷi. ");
INSERT INTO eskNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Akiyaqasiutititchi uvamnun iḷisaġvigiluŋaasiiñ. Taatnaġupsi iñuutchisi minġuiqsiaġniaqtut atakkii piisaaŋitchuŋa atchikł̣uŋalu. ");
INSERT INTO eskNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Akiyautiga naammaktuq atuqtuni, suli savaaksrirrutiga ilipsitñun qaġanaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Akuniisuŋaqatiŋ Jesus-lu maliġuaqtaiḷu apqusaaġniqsut mukkaaksrat nautchiiviatigun minġuiqsiaġvium uvluani. Jesus-ŋum maliġuaqtai niġisuliqhutiŋ nutchuigaqsiñiqsut mukkaaksranik aasiiñ niġipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharisee-ŋuruat tautukamisigik upyaŋniġaat Jesus, “Qiñillakkich maliġuaqtitin. Navgiḷḷapiaqtut maliġutaksraptiknik minġuiqsiaġvium uvluagun.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus-ŋum kiuniġai, “Agliqisimasuknaġiksi sumik David-ŋumlu piqataiñḷu pisilaaŋat niġisuliqamiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David isiqhuni tupqanun Agaayyutim, ilaalu piqataiḷu, niġirut ipqiqsakkauruamik qaqqiamik niġiraksriutauruamik kisiitñun agaayuliqsinun. Maliġutaksrakuaġnanġitchuq niġipmatruŋ taamna qaqqiaq. ");
INSERT INTO eskNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Suli agliqisimasuknaġiksi maliġutaksrani, qanuq agaayuliqsit agaayyuvikpaŋmi qaayuġnaqsiḷiuġniałhat minġuiqsiaġvium uvluani, tavraami patchisaił̣hat navguikamiŋ maliġutaksranik. ");
INSERT INTO eskNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aglaan uqautigipsi, iñuk maaniitkaluaqtuq kamanatluktuaq agaayyuvikpaŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iḷisimanayaġniġupsi qanuutautilaaŋanik uuma uqałhum, ‘Kimmutigitlukkiga nagliktaq uumakŋa tuniḷḷaqtułiġmiñ,’ suksraunġiġayaitchisi iñuich killukuaŋitchuat. ");
INSERT INTO eskNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Atakkii Iġñiŋa Iñuum ataniġigaa minġuiqsiaġvium uvluan.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus tavrakŋa aullaqami isiġniqsuq Jew-ŋuruat katraġviatnun. ");
INSERT INTO eskNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aŋutiqaġniqsuq tavrani pannaqłuktanik argalik. Atlanik iñuqaġmiñiqsuq tavrani agvisiksraiḷiqiruanik Jesus-mik. Apiqsruġniġaat maliġutaksrakuaġnaqmagaan iłuaqsipkairuni minġuiqsiaġvium uvluani. ");
INSERT INTO eskNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus nipliutiniġai, “Nalliqsi piqaġniġumi atautchimik ipnaimik aasiiñ ipnaiq kataguni iḷunaamun minġuiqsiaġvium uvluani, taavruma amunayaiññiqpauŋ taavrumakŋa? ");
INSERT INTO eskNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nalupqinaitchuq, Iñuk piqpaknatluktuq ipnaimiñ. Taatnaqhuni maliġutaksrakuaġnaqtuq ikayuiruni minġuiqsiaġvium uvluani.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aasiiñ nipliutiplugu taamna aŋun, “Isakkich argaktin!” Taavruma isaŋniġai argaŋni aasiiñ iłuaqsipḷutiŋ igḷuŋisitun argaiñ iḷipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tavrakŋa Pharisee-ŋuruat anikamiŋ katiplutiŋ sivunniuġniqsut qanuġlugu Jesus tuqqutchukługu. ");
INSERT INTO eskNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus iḷisimapluni sumik sivunniuqtilaaŋatnik, aullaġniqsuq tavrakŋa. Iñugiaktuat iñuich maliŋniġaat. Jesus-ŋum iłuaqsiraġaġniġai iluqaisa atniġñaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesus-ŋum iñiqtiġniġai iñuich uqaġitquŋitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Taamna immiqsaqługu uqautaumaruaq tumigiplugu sivuniksriqiri Isaiah, itnaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Uvvauna savaktiga piksraqtaaġikkaġa! Ilaaŋuruq piqpagikkaġa suli ilaagun quyalikkaupluŋa. Iḷigisigiga irrusiḷḷautaġa ilaanun, suli quliaqtuaġigisigaa iñupayaanun qanuq atanniił̣iksraġa iñupayaanik atisiḷugich. ");
INSERT INTO eskNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Uqaalatlaitchuq iġialaluniḷu. Kia-unniiñ tusaayumiñaitkaa nipaa tumitchiani. ");
INSERT INTO eskNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Piyaqquġniaŋitkai sayaitchuat iñuich ittuat piġittuatun ivikpaktun naagaqaa qamiyasiuraqtuatun nanipiam ipiġaŋatun atanniił̣iksraġmiñunaglaan iñupayaanik nalaunŋaluniḷu atisiḷuniḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Suli ilaan atqagun nunaaqqipayaat niġiugaqaġisirut.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iñuich Jesus-muutiniġaat aŋun irrusiqł̣ulik ayauŋaruaġlu uqatlaitchuaġlu. Jesus-ŋum iłuaqsiñiġaa. Tavrali taamna aŋun uqatlasiruq qiñitlasipḷuniḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iluqatiŋ iñuich quviġutchaŋniqsut uqaqhutiŋ, “Kiŋuviaġiŋitkaluaġniqpauŋ una David-ŋum?” ");
INSERT INTO eskNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aglaan Pharisee-ŋuruat tusaakamitruŋ uqaġniqsut, “Jesus anitchiraġaiñiqsuq irrusiqł̣uŋnik iñuŋniñ atuqługu saŋŋia Beelzebul-ŋum aŋalataata irrusiqł̣uich.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus-ŋum iḷisimaplugich sumik isummatilaaŋatnik uqautiniġai, “Iñuich atanġuviŋmiguuq akikŋautirut avatmun; ataniġliasiiñ taavrumani suksraunġiġñiaqtuq iñugikkaŋi avgumakpata. Nunaaqqipayaat naagaqaa tupiqatigiich avikamiŋ makitatlaitchut. ");
INSERT INTO eskNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Taatnatuntuuq tuunġaq irrusiqł̣uŋi avgumagumiŋ akikŋautilutiŋ avatmun atanġuvia isukłiññiaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aasiiñ anittaġupkich irrusiqł̣uich Beelzebul-kun, kisukunli iñugikkapsi anittaġuuvatigik irrusiqł̣uich? Taatnamik atanniqsuqtiginiaġisi. ");
INSERT INTO eskNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aglaan Irrutchiagun Agaayyutim anittaiguma irrusiqł̣uŋnik, nalupqinaitchuq Agaayyutim aŋalatchianiktilaaŋa iñuŋnik akunnapsitñi. ");
INSERT INTO eskNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kiñapayaaq isiġuktuaq saŋŋiruam iñuum tupqanun tigliguguni, qiḷiqsruqqaaġlugu saŋŋiruaq iñuk tiglikkisiruq suuraŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iñuk piqatauŋitchuaq uvamni akikŋautiruq uvamnun, suli iñuk katitchiqatauŋitchuaq siamitchił̣hiñaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Taatnaqhusi uqautigipsi, Agaayyutim natqigutitlagai iñuich killuqsautipayaaŋich itqaġitqikkumiñaiġḷugich uqaġniqłuktapayaaŋich. Aglaan uqaġniqłuktuaq akikŋaqługu Ipqitchuaq Irrusiq natqigutikkauyumiñaitchuq sumiunniiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kiñapayaaq uqaqtuaq pigiitchuamik akikŋaġlugu Iġñiŋa Iñuum natqigutikkaugisiruq, aglaan kiñapayaaq uqaqtuaq pigiitchuamik akikŋaġlugu Ipqitchuaq Irrusiq natqigutikkauyumiñaitchuq pakmapak suli taimuŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Napaaqtuq iḷitchuġinaqtuq asiaŋigun. Napaaqtuġiksuaq asirriḷḷautaġaqtuq aasiiñ napaaqtuġiitchuaq asirripḷuni asiaġiitchuanik. ");
INSERT INTO eskNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ilipsi tuqunalgich nimiġiat! Uqatlaitchusi nakuuruanik atakkii pigiitchuaŋuplusi. Qanġaum uqaġiraġigaa taatnasiq ittuaq uummatmi. ");
INSERT INTO eskNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iñullautaq piqaġaqtuq nakuuruamik uummatmiñi aasiiñ uqallautat aniraġaqhutiŋ uummatmiñiñ, aasiiḷi pigiitchuaq iñuk uummatiġmiutaġaqtuq killuġmik uqaqhuniasiiñ nakuuŋitchuanik. ");
INSERT INTO eskNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Uqautigipsi, uvluani atanniivium iñuich pasirauniaqtut uqaġiiḷḷapayaaġmiktigun uqautigikkaġmikkun. ");
INSERT INTO eskNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Atakkii uqaġikkapsigun nalaunŋasripkakkauniaqtusi, suli uqaġikkapsigun suksraunġiqsaugisirusi.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tavrani iḷaŋisa Pharisee-ŋuruat suli iḷaŋich aglaliqirit uqaġniqsut Jesus-mun, “Iḷisautrii, qiñiġuktugut quviqnaqtuamik savaamik nalupqinaiġutauplugu kisuutilaaqnik.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus-ŋum kiuniġai, “Makua iñuich pigiitchuatlu sayuŋaruatlu qiñiġuktut quviqnaqtuanik savaanik nalupqinaiġutaulugich, aglaan qiñiġumiñaitḷutiŋ taatnatchimik. Qiñiłhiñaġisigaat quviqnaqtuaq savaaq atuupmatun Jonah-mun sivuniksriqirimun. ");
INSERT INTO eskNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah aqalukpaum narraaŋni inniqsuq piŋasuni uvluniḷu unnuaniḷu. Taatnatuntuuq Iġñiŋa Iñuum iḷuviġmiitkisipmiuq piŋasuni uvluniḷu unnuaniḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Atanniivium uvluani iñuŋisa Nineveh-m patchisiginiaġaasi iñuuruasi pakmapak, atakkii taimani isummitqikhutiŋ killuqsautmikniñ Jonah-m quliaqtuaġutipmatiŋ. Ataŋii, iñuk maaniittuq kamanatluktuaq Jonah-miñ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Atanniivium uvluani atanġum aġnam patchisiginiaġaasi iñuuruasi pakmapak, atakkii aggiqhuni uŋallam tuŋaaniñ uŋasiksuamiñ naalaġnityaqługu Solomon-ŋum puqiksilaaŋa. Ataŋii, iñuk maaniittuq kamanatluktuaq Solomon-miñ. ");
INSERT INTO eskNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Irrusiqł̣uk anipman iñuŋmiñ kukiḷugaqtuq paliqsaakun nunakun pakakhuni iñiqtuiqsiaġviksraġmiñik, aasiiñ paqinġitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Iŋmiñun uqaġaqniqsuq, ‘Utiġlaŋa tupiġmun annivigikkamniñ.’ Aasiiñ utiqami paqillaġniġaa imaiḷaaq inigisimakkani salikuqtaatchiaq suli inillaktullautaqtaq. ");
INSERT INTO eskNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Anipḷuni aggiutriraqniqsuq tallimat malġuŋnik atlanik irrusiqł̣uŋnik pigiitḷuktuanik iŋmiñiñ. Aasiiñ isiqhutiŋ iñuuniagaqsiraġniqsut tavrani. Aqullia taavruma iñuum pigiitḷuksiraqtuq sivulliġmiñ iñuuniałiġmiñiñ. Taatnatuntuuq itkisiruq killuliqirini iñuuniaqtuat pakmapak.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus-ŋum uqaqtitlugu iñuŋnun aakaŋalu aniqatiŋiḷu qikaġniqsut tatqaani uqaqatigisukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iñuich iḷaŋata uqautiniġaa Jesus, “Aakanlu aniqatiutinlu qaani qikaqtut uqaqatigisukhutin.” ");
INSERT INTO eskNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus-ŋum kiuniġaa taamna iñuk uqautriñi, “Kisuuva aakaga? Suli kisuuvat aniqatiutka?” ");
INSERT INTO eskNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tikkuaqługich maliġuaqtini nipliġñiqsuq, “Qiñiqsigik, ukua aakagigitkalu aniqatiutkalu. ");
INSERT INTO eskNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Atakkii kiñapayaaq savaaqaqtuaq pisułhanik aapaa qiḷaŋmiittuam aniqatigigiga naagaqaa aakagiplugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Taavrumani uvlumi Jesus anikami tupiġmiñ, utlautiniqsuq narvam siñaanun aquvitluniasii. ");
INSERT INTO eskNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iñugiallapiaqtuat iñuich katirviginiġaat avatlugu. Kiisaimma ikiniqpuq umiamun aquvitluni, iñugayaaqpaurat makitaplutiŋ narvam siñaani. ");
INSERT INTO eskNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aasiiñ Jesus-ŋum uqautiaqsiñiġai iñugiaktuanik atrikusautinik itnaqhuni, “Iñugguuq nunaliqiri nautchiityaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nautchirripkaqługu nautchiaksrat iḷaŋich katagaġniqsut apqutmun, aasiiñ tiŋmiurat niġipḷugich. ");
INSERT INTO eskNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iḷaŋitsuli katagaġniqsut uyaġauruamun nunamun nunaqapiaŋitchuamun, aasiiñ nauplutiŋ qilamik atakkii nunakitḷuni, ");
INSERT INTO eskNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","aasiiñ siqiñiq nuipman pasikł̣ugich pannaqłuŋniġai atakkii kaŋiḷiviksraitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Suli iḷaŋich nautchiaksrat katagaġniqsut akunġatnun kakitḷaġnat, aasiiñ kakitḷaġnat naukamiŋ nagguviksraiġñiġaich nautchiaġiksaat. ");
INSERT INTO eskNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aglaan iḷaŋich katagaġniqsut nunagiksuamun, aasiiñ nauriñiqsut asianik iñugiaksipḷugich, iḷaŋich atautchimiñ tallimakipiaŋuttaaqhutiŋ naaga piŋasukipiaŋuttaaqhutiŋ naaga iñuiññaq quliŋuttaaqhutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aasiiñ Jesus nipliġñiqsuq, “Kiña siutiqaqtuaq naalaġniḷi.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Maliġuaqtaiñ utlakługu Jesus apiqsruġniġaat, “Suvaata uqaqpich iñuŋnun atrikusautitigun?” ");
INSERT INTO eskNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus-ŋum kiuniġai, “Ilipsitñułhiñaq Agaayyutim sagviġñiġaa nalunaqtuaŋanik aŋaayuqautaan qiḷaum, aglaan makunuŋa iñuŋnun sagvikkauŋitchuq. ");
INSERT INTO eskNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Atakkii iñuk piqaqtuaq akuqtullaaġisiruq, aglaan taavruma piqaŋitchuam anniagisigaa mikiruuraqunniiñ pigikkani. ");
INSERT INTO eskNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Una pisigiplugu uqaqtuŋa iñuŋnun atrikusautitigun: Atakkii qiñiġaluaqhutiŋ iḷisaqsritḷaitchut suli naalaġnigaluaqhutiŋ tusaatlaitchut aasiiñ kaŋiqsitḷaitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aasiiñ makunuuna iñuktigun immiumaniqsuq Isaiah-m sivuniksriqutaa itnaqhuni, ‘Tusaagaluaġupsi kaŋiqsiyumiñaitchusi, suli qiñiġumaaġaluaġupsi iḷitchuqsriyumiñaitchusi. ");
INSERT INTO eskNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Atakkii makua iñuich uummatiŋich pitchiġiiḷiġñiqsut, tusaasunġitḷutiŋ supayaamik, iritiŋḷu siquplugich. Utitqiñġitchut Agaayyutmun mamitiłiksramiknun atakkii qiñitlaitḷutiŋḷu tusaatlaitḷutiŋlu kaŋiqsitḷaitḷutiŋlu.’ ");
INSERT INTO eskNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Aglaan quvianamiurusi, atakkii irigikkasi qiñitlarut suli siutigikkasi tusaatlaplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iḷumun uqautigipsi, iñugiaktuat sivuniksriqirit nalaunŋaruatlu Agaayyutim iñuiñ qiñiġukkaluaġaat tamanna pakma qiñikkaqsi aglaan qiñiŋitkaat. Tusaasukkaluaġaattuuq pakma tusaakkaqsi, aglaan tusaaŋitkaat. ");
INSERT INTO eskNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Naalaġniḷḷaksiuŋ qanuutautilaaŋa atrikusautim nautchirriqirikun. ");
INSERT INTO eskNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tamatkua tusraaruat uqałiġmik aŋaayuqautaagun Agaayyutim kaŋiqsisuŋaqatiŋ atriqaqtut nautchiaksranik kataktuanik apqutmun. Aquagun pigiitchuam aggiqhuni aattaġigai nautchirriutauruat uummataatniñ, suli piiguipkaġai tusaakkaŋatnik. ");
INSERT INTO eskNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aasiiḷi akuqtuiruat uqałiġmik quviasuutigiplugu tusaapqauraqamitruŋ atriqaqtut nautchiaksranik kataktuanik uyaġaulamun nunamun. ");
INSERT INTO eskNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aglaan kaŋiḷiviksraitman akuniutlaitchuq. Tavra iłuiḷḷiułiq piyuaqsiułiġlu tikitmata iñuich taapkua qilamik qapiqtiġaqtut. ");
INSERT INTO eskNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Suli nautchiaksrat kataktuat akunġatnun kakitḷaġnat atrigigaat iñuk tusaaruaq uqałiġmik, aglaan isumaaluutit iñuuniałikun kinnitñiŋniaġutitlu umialgutitigun suqutiginġiġaġigaat uqałiq taimmaasiiñ naurisuŋaqani asianik. ");
INSERT INTO eskNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aglaan iñuk akuqtuiruaq nautchiaksranik nautchirriutauruanik katakhutiŋ nunagiksuamun atriqaqtuq iñuktun tusaaruatun uqałiġmik kaŋiqsipḷugu. Ilaa naurisuuruq asianik, iḷaŋich tallimakipiatun, iḷaŋich piŋasukipiatun, suli atlat iñuiññaq qulitun.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus uqaġniqsuq atlamiksuli atrikusautmik, “Agaayyutim aŋaayuqautaa sagviqpan itkisiruq iñuktun nautchiiruatun mukkaaksraġiksaanik nautchiiviŋmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aglaan iñuich siñiktitlugich uumiksri aggiqhuni nautchiiñiqsuq mukkaaksraġiiḷanik akunġatnun mukkaaksraġiksaat aullaqhuniasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naugaqsipmata nautchiat mukkaaksraurat nuiŋuraqmata mukkaaksraġiiḷattuuq sagviġmiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Savaktit utlakamitruŋ aŋaayuqaqtiŋ apiqsruġniġaat, ‘Ataniiq, nautchiiñigiptigiñ mukkaaksraġiksaanik. Nakiñ makua mukkaaksraġiiḷat nuivat?’ ");
INSERT INTO eskNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Qaukłiata kiuniġai, ‘Uumiksrim savaaġigaa taamna.’ Savaktit apiqsruġniġaat, ‘Aullaquvisigut nutchugiaġlugich mukkaaksraġiiḷat?’ ");
INSERT INTO eskNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tavra kiuniġai, ‘Naaga, nutchuigupsi mukkaaksraġiiḷanik taputriviaqtusi mukkaaksraġiksaanik. ");
INSERT INTO eskNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Iluqatik naulik kipriviksramunaglaan, aasiiñ kiprivik tikitpan uqautigisigitka kipririt sivulliulugu katitqulugich mukkaaksraġiiḷat qiḷiqtaulaalugich ikipkaaqsriuġlugich, aglaan katillugich mukkaaksraġiksaat siġḷuamun.’” ");
INSERT INTO eskNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus-ŋum uqautilgiññiġai atlamik atrikusautmik itnaqhuni, “Agaayyutim aŋaayuqautaa ittuq mustard-ŋum nautchiaksrauraŋatun iñuum nautchiikkaŋatun nunautmiñi. ");
INSERT INTO eskNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mikiniqsraugaluaŋŋaġmi nautchiaksrapayaaniñ naagatarra naukami aŋiniqsrauraqtuq nautchiapayaaniñ napaaqtuġuqhuni. Aasiiñ tiŋmiuraŋi siḷam aggiqamiŋ ugluliñiqsut qisiqsiutiŋitñun.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus-ŋum uqautilgiññiġai atlamik atrikusautmik, “Agaayyutim aŋaayuqautaa sagviqpan itkisiruq aġnaq akutchipmatun puvlaksautmik mukkaaksramun iḷuturuamun puvlagataqtitlugu iluqaan qaqqiaksraq.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus-ŋum uqaġiniġai iluqaisa sut tamatkua iñugayaanun atrikusautitigun. Atrikusautaiḷaaġuni uqatlaiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tavra immiumaniqsuq uqauttutauruaq sivuniksriqirikun itnaqhuni, “Atrikusautitigun uqaġisiruŋa iliŋitñun. Uqautigisigitka sutigun iriqsimaruatigun nunam aullaġniił̣haniñaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus-ŋum aullaqtitqaaqługich iñuich isiġniqsuq tupiġmun. Maliġuaqtai utlautiniqsut ilaanun itnaqhutiŋ, “Kaŋiqsipkallaktigut atrikusaun mukkaaksraġiiḷatigun nautchiiviŋmi.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus-ŋum kiuniġai, “Iñuk taamna nautchiiruaq mukkaaksraġiksaanik Iġñiġigaa Iñuum. ");
INSERT INTO eskNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nautchiivik nunauruq. Mukkaaksraġiksaat tamatkuaŋurut qaitchuat iŋmiknik Agaayyutmun aŋalatquplutiŋ, mukkaaksraġiiḷatli tamatkuaŋurut qaitḷutiŋ iŋmiknik pigiitchuamun aŋalatquplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Taamna uumiksri nautchiiruaq tamatkuniŋa mukkaaksraġiiḷanik tuunġauruq. Kiprivik isugigaa nunam aasiiñ kipririt isaġulguplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Atriḷugich mukkaaksraġiiḷat katitauruat ikipkaqługich ikniġmun taatnatuntuuq itkisipmiuq isukłitpan nuna. ");
INSERT INTO eskNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iġñiŋan Iñuum tuyuġigisigai isaġuligikkani aasiiñ katityaġlugich ukunakŋa Agaayyutim aŋaayuqautmiñiñ killuqsaqusaaġutipayaat suli iñupayaat pigiiḷiqiruat. ");
INSERT INTO eskNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Isaġulgich igitkisigaich ikkaularuamun uunaksautmun. Tavrani iñuich qiagisirut suli tiriquulatchiḷugich kigutitiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nalaunŋaruatli qaumagisirut siqiñiqtun aŋaayuqautaani aapagikkaġmiŋ. Kiña siutiqaqtuaq tusaali. ");
INSERT INTO eskNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Agaayyutim aŋaayuqautaa sagviqpan itkisiruq akisuruaq iriqsimapmatun nautchiiviŋmi. Iñuum paqitnamiuŋ iritqikł̣ugu nautchiiviŋmun; iñuk taamna quviatchakhuni tunirityaġniqsuq sulliñaurapayaaġmiñik, aasiiñ tauqsiġñiġaa nautchiivik. ");
INSERT INTO eskNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Aasiisuli Agaayyutim aŋaayuqautaa sagviqpan itkisiruq tauqsiġñiaqtitun pakaktuatun akisuruamik suŋauraqpagiksaamik. ");
INSERT INTO eskNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Paqitnami akisullapiaqtuamik suŋauraqpaŋmik aipḷuni tunityaqługich sulliñaurapayaani tauqsiqł̣ugu taamna akisullapiaqtuaq suŋauraqpagiksaaq. ");
INSERT INTO eskNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aasiisuli Agaayyutim aŋaayuqautaa sagviqpan itkisiruq qaaqtuutitun niŋitauruatun taġiumun aasiiñ qaaqhuni qanusipayaanik aqaluŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Qaałallaanikamiŋ aqaluŋniaqtit nuqitlugu siñaanun aquvitlutiŋ avguaqsipḷugich aqaluich, nakuuruat iḷipḷugich aqaluqaġviŋmiknun aasiiñ nakuuŋitchuat igitlugich. ");
INSERT INTO eskNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Itna itkisiruq isukłitpan nuna. Isaġulgich avguityaġisirut pigiitchuanik iñuŋnik akunġatniñ nalaunŋaruat iñuich ");
INSERT INTO eskNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","igitlugich ikkaularuamun uunaksautmun. Tavrani iñuich qiagisirut suli tiriquulatchiḷugich kigutitiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus-ŋum apiqsruġniġai maliġuaqtini, “Kaŋiqsivisigik sut tamatkua iluqaisa?” Kiuniġaat, “Aa, kaŋiqsigivut.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aasiiñ Jesus-ŋum uqautiniġai, “Aglaliqipayaaq iḷisaaqaqtuaq Agaayyutim aŋaayuqautaanik atriqaqtuq tupqum iñuanik sagviqsruiruamik suuraġmiñik nutauruanik naagaqaa utuqqauruanik tugvaqsiviŋmiñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus-ŋum uqaġiŋaiqamigich tamatkua atrikusautit aullaġniqsuq tavrakŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tikitḷuni iñuguġviŋmiñun iḷisautiniġai iñuich katraġviatni. Iñuich tusaaruat quviġusukhutiŋ apiqsruqtautiaqsiñiqsut avatmun, “Sumiñ una iñuk piññakpa puqiutmik suli saŋŋimik savaaqatlasipḷuni quviqnaqtuanik? ");
INSERT INTO eskNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Uvvauna kaapintam taivruma iġñiġiŋitpauŋ? Aakaŋa taimña atiqaŋitpa Mary-mik? Aniqatigiŋitpagich ipkua James-lu, Joseph-lu, Simon-lu, suli Judas? ");
INSERT INTO eskNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Iluqatiŋsuli nukatchiaŋi iñuuniaqatauŋiññiqpat uvaptikni? Sumiñ una iñuk piññaŋniqpa tamatkuniŋa supayaanik?” ");
INSERT INTO eskNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tavra atniummatiqaġniqsut Jesus-mik. Aglaan Jesus-ŋum uqautiniġai, “Agaayyutim sivuniksriqiraa kamagikkauraqtuq nanipayaaq aglaan kamagikkauŋitḷuni iñuguġviŋmiñiḷu naagaqaa iḷamiñiḷu.” ");
INSERT INTO eskNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tavra Jesus savaaqaŋiññiqsuq iñugiaktuanik quviqnaqtuanik atakkii iñuich tavrani ukpiqsriŋitḷutiŋ ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Taatnałhatni Herod, atanġa Galilee-m, tusaaniqsuq uqqamik Jesus-kun, ");
INSERT INTO eskNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","uqautiniġai savaktini, “Jesus una John Paptaaqtitchirauniqsuq aŋitqikhuni tuqułiġmiñ. Taatnaqhuni savaaqatlaniqsuq quviqnaqtuanik.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sivuaniimma Herod-ŋum tigupkaġniġaa John qiḷiqsruqługu isiqtaupkaqługu. Taatnaqtinniġaa pisigiplugu Herodias, aniqatmi Philip-ŋum nuliaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Atakkii John Paptaaqtitchirim akulaiqł̣ugu uqautiniġaa Herod, “Maliġutaksrakuaġnanġitchuq iḷaqatiginiaġupku aniqatvich nuliaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod-ŋum tuqqutchukkaluaġniġaa John, aglaan iqsiñiqsuq iñuŋnik atakkii iliŋisa isummatigiplugu John sivuniksriqirauplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod-ŋum annivia tikitman, pania Herodias-ŋum sayuġniqsuq sivuġaatni Herod-ŋumlu tuyuġmiaŋiñḷu quyaliḷḷapiaqługu. ");
INSERT INTO eskNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Akiqsruġniġaa nalupqinaiqł̣ugu qaitchigisiñipḷugu supayaamik iŋiqpan. ");
INSERT INTO eskNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Niviaqsiaq pitchuksaakkaupluni aakamigun nipliġñiqsuq, “Qaitchiŋŋa niaquanik John Paptaaqtitchirim iḷiḷugu alluiyamun.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Umialik aliatchaŋniqsuq, aglaan pisigiplugu akiqsruutni suli tamatkua niġiqatini tiliriñiqsuq qaitquplugu niviaqsiam iŋiaġikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Herod tiliriñiqsuq isiqsiviŋmun niaquiġiaquplugu John. ");
INSERT INTO eskNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Itqutiniġaat niaqua iḷipḷugu alluiyamun qaitḷuguasiiñ niviaqsiamun, aasiiḷi taavruma aakamiñuutiplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John-ŋum maliġuaqtaiñ aggiqhutiŋ piñiġaat timaa iḷuviqługuasiiñ. Taatnaanikamiŋ uqautityaġniġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus tusaakami qanuqtilaaŋanik John-ŋum, aullaġniqsuq umiakun quvġutiplugu iñuiḷaamun kisimi. Iñugayaat tusaakamiŋ maliutiniġaat nunaaqqipayaaniñ pisukkataqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus tulakami tautukługich iñugayaaqpaurat iḷunŋutchaŋniqsuq. Mamitinniġai atniġñautiŋitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Unnuksraaġataqman maliġuaqtaiñ utlaŋniġaat uqautiplugu, “Unnuaġuqtuq. Suviksraiḷaaq manna. Tuyuġikkich iñuich nunaaqqiuranun tauqsiġiaqulugich niqiksramiknik.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus-ŋum uqautiniġai, “Aullaŋitkumiŋ suŋitchut. Ilipsi niġipkaqsigik.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kiuniġaat, “Piqaqtugut tallimałhiñanik qaqqianiglu malġuŋniglu aqaluŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus-ŋum nipliutiniġai, “Uvuŋautisigik uvamnun.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aasiiñ tiliñiġai iñugayaat aquvitquplugich iviŋnun. Tigukamigich taapkua tallimat qaqqiat malġuglu aqaluk aaġluġniqsuq qiḷaŋmun quyyatiplugich. Tavra Jesus-ŋum avguqługich qaqqiat qaiññiġai maliġuaqtimiñun aasiiḷi taapkua autaaqługich iñugayaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iluqatiŋ iñugayaat niġiñiqsut niġisuiqhutiŋ. Niġiŋaiqmata maliġuaqtit katitchiñiqsut iḷakuŋitñik immiġataqługich qulit malġuk aguupmaich. ");
INSERT INTO eskNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Taapkua niġiruat 5,000-tuyuŋnaq inniqsut aŋutit, kisiqatigisuŋaqnagich aġnat iḷiḷgaatlu. ");
INSERT INTO eskNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesus-ŋum maliġuaqtini ikipkaqtiġniġai umiaqpauramun ikaaġiaquplugich igḷuanun narvaqpaum aasiiñ aipkaqługich iñugayaat. ");
INSERT INTO eskNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Taatnaanikami mayuġniqsuq iġġimun agaayutyaqtuaqhuni kisimi. Anaqaksraaqman Jesus kisiŋŋuġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tavra umiaqpauraq tikiññiqsuq qitqanun narvaqpaum. Umiaqpauraq piyaqniuliġniqsuq qaiḷġutiplugu atakkii anuġim paġġaġuutiplugulu. ");
INSERT INTO eskNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aasiiñ Jesus-ŋum utlaŋniġai maliġuaqtini uvluyasipman pisukhuni imġum qaaŋagun. ");
INSERT INTO eskNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Maliġuaqtaiñ tautukamitruŋ Jesus pisuktuaq imġum qaaŋagun iqsitchaŋniqsut nipliqhutiŋ, “Aliuqtuaq marra!” Kappaiŋaaqsiñiqsut tatavrauplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aglaan tavrauvaa Jesus nipliutiniġai, “Quviatchauġigitchi. Uvaŋauruŋa. Iqsiñasi!” ");
INSERT INTO eskNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter-m kiuniġaa, “Ataniiq, ilviupiaġuvich tiliŋŋa utlaqulutin imġum qaaŋagun.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus-ŋum kiuniġaa, “Uvuŋaġiñ.” Peter niukami umiaqpauramiñ pisukhuni imġum qaaŋagun utlautiniqsuq Jesus-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aglaan Peter-m tautukamiuŋ qanutun saŋŋisilaaŋa anuġim iqsitchaŋniqsuq. Kiviaqsikami kappaiŋaniqsuq, “Ataniiq, annautiŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tavrauvaa Jesus-ŋum isautiplugich argaŋni tiguniġaa Peter nipliutiplugu, “Ukpiqsrił̣ikiññiaqpat! Suvaata arguaqtuqpich?” ");
INSERT INTO eskNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ikipmaknik umiaqpauramun anuġaiġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Taapkua umiaqpauramiittuat sitquġviginiġaat sivuġaanun Jesus uqaqhutiŋ, “Iḷumun iġñiġiniġaatin Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ikaaqamiŋ igḷuanun nunaliññiqsut Gennesaret-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aasiiñ iñuŋi taavruma nunam iḷitchuġikamiŋ Jesus-mik tuyuġniqsut uqqamik avalliupayaamiknun nunaaqqiuranun, tikiutruaqsipḷugich aasiiñ atniġñautilipayaat Jesus-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Iŋiqsrullapiaqługu aksiḷḷaŋniaqsiñaġukługuunniiñ akua atnuġaaŋan, aasiiñ aktuipayaaqtuat ilaanik mamitikkauniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pharisee-ŋuruat aglaliqiritlu utlaŋniġaat Jesus Jerusalem-miñ apiqsruqługu, ");
INSERT INTO eskNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Suvaata maliġuaqtivich kamagitlaitpatigik iḷisauttutiŋich sivulliaġikkapta? Iġġuŋitkaich argatiŋ niġigaluaqatiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus-ŋum kiuniġai, “Suvaatamipsuuq kamagitlaitpisigik Agaayyutim tillisai? Kamaksritḷaitchusi atakkii maliġukkisi iḷisauttutiŋich sivulliaġikkapta. ");
INSERT INTO eskNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Agaayyun uqaqtuq, ‘Kamagisigik aapanlu aakanlu. Kiñapayaaq uqamaqłuutriruaq aapamiñik naagaqaa aakamiñik tuquruksraupiaqtuq.’ ");
INSERT INTO eskNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ilipsiḷiasiiñ iḷisautrirusi iñuŋmun uqautiłhiñaunipḷugu aapani naagaqaa aakani, ‘Piqaġaluaqtuŋa aatchuutiksramik. Aatchuutigiyumiñaitkiga ilipsiknun, atakkii akiqsruutigianikkiga Agaayyutmun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Taatnatun iḷisautigupsiuŋ iñuk kamaksritquŋitḷugu aapaŋanik naagaqaa aakaŋanik suunġiġisi Agaayyutim tillisaa pisigiplugich sivulliapsi iḷisauttutiŋich. ");
INSERT INTO eskNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ukpiŋŋuaqtisii! Qanutun nalauttiginiqpa Isaiah sivuniksriqiri uqaqami ilipsigun, ");
INSERT INTO eskNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tamatkua iñuich kamaksrulgugaluaġaatŋa uqałhiñaġmiktigun aglaan uummatiŋich uŋasiksut uvamniñ piqpagillapianġitḷuŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Agaayyuvigiraġigaatŋa imaiḷaakun, atakkii iḷisautrirut iñuich iḷisauttutiŋitñik iḷipḷugich maliġutaksraġiruatun Agaayyutun.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus-ŋum iŋmiñuquniġai iñugayaat nipliutiplugich, “Naalaġniḷḷaksiŋŋa kaŋiqsiḷusiasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sum isiqtaqtuam iñuum qanġagun qaayuġnaqsipkatlaitkaa, aglaan taavruma aniraġaqtuam qaniġmiñ, uqałhum qaayuġnaqsipkaġaġigaa iñuk.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Maliġuaqtaiñ utlakługu apiqsruġniġaat, “Iḷisimavigich Pharisee-ŋuruat atniummatilaaŋat tusaakamitruŋ taamna uqautigikkan?” ");
INSERT INTO eskNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kiuniġai, “Nautchiapayaaq aapama qiḷaŋmiittuam nautchirriutiŋaisaŋa amuruaniaqtuq kaŋituummaan. ");
INSERT INTO eskNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iŋmiktuuġlich. Ayauŋaruani sivulliuqtaurut ayauŋaplutiŋ. Ayauŋaruam sivulliuqpagu ayauŋaruaq, iluqatik katakkisiruk itiqsramun.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tavra Peter-m kiuniġaa, “Uqautitigut qanuutautilaaŋanik taavruma atrikusautim.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus-ŋum nipliutiniġai, “Ilipsipsuuq kaŋiqsisaitmivisi? ");
INSERT INTO eskNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kaŋiqsiŋitpisisuli? Suapayaaq qaniġmuktuaq aqiaġuqmugaqtuq aasiiñ anipḷuni timimiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aglaan sut tamatkua aniraġaqtuat qanikun aniraġaqtut uummatmiñ, aasiiñ qaayuġnaqsiraġaqługu iñuk. ");
INSERT INTO eskNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Atakkii uummatmiñ aniraqtut pigiitchuat isummatit, iñuaqtułiq, iḷaqatiqaġaluaqhuni atlatułiq, iḷaqataiḷḷuni sayuŋałiq, tigliyułiq, taŋiġiḷaakun iḷisimaraułiq, uqaniqłuktałiġlu. ");
INSERT INTO eskNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Taapkuatavra qaayuġnaqsiraġaġaat iñuk, aglaan niġiruni iġġuġaluaġnagich argaich qaayuġnaqsitḷaitchaat iñuk.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus aullaġniqsuq tavrakŋa nunaŋanun Tyre-m suli Sidon-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canaanit-aġmiu aġnaq tamaani iñuuniaqtuaq utlautiniqsuq ilaanun kappaiŋapluni, “Ataniiq, kiŋuviaŋa David-ŋum! Nagligillaŋniaŋŋa! Paniga pigiiḷiḷḷapiaqtuq irrusiqł̣uqaqhuni.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aglaan Jesus kiuŋiññiġaa. Maliġuaqtaiñ utlakługu iŋiqsrullapiaġniġaat itnaqhutiŋ, “Aqpigiuŋ una aġnaq. Nipraulapluni malikkaatigut.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus-ŋum kiuniġai, “Tuyuġikkauruŋa kisiitñun iñuiñun Israel-ŋum ittuanun tammaummiruatun ipnaisun.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aġnaq utlautikami sitquġniqsuq sivuġaanun nipliqhuni, “Ataniiq, ikayullaŋniaŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus-ŋum kiuniġaa, “Nakuunġitchuq pigupsiuŋ iḷiḷgaat qaqquksrautaat qaiḷḷuguasiiñ qipmiñun.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aġnaq nipliġñiqsuq, “Aa Ataniiq, aglaan qipmichunniiñ niġipmiraqtut kanġakunik kanġaalaruanik iñuŋmiŋ niġġiviŋitñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus-ŋum kiuniġaa, “Aġnaaq, kamanallapiaqtuamik ukpiqsrił̣iqaġniqsutin; iŋiqsruaġikkan savaaŋugisiruq ilipnun.” Tavra aġnam pania iłuaqsikkauniqsuq taavrumani sassaġniġmi. ");
INSERT INTO eskNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus aullaqami tavrakŋa iglauniqsuq siñiqsraqługu narvaqpaŋa Galilee-m; aasiiñ mayuqhuni qimiġaamun aquvinniqsuq tamauŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iñugiallapiaqtuat iñuich utlautiniqsut ilaanun tikiutruipḷutiŋ pisutlaitchuanik, ayauŋaruanik, uqatlaitchuanik, sulguiḷimaruanik, suli iñugiaktuanik atlanik. Iḷiuqqaġniġaich Jesus-ŋum sivuġaanun. Aasiiḷi Jesus-ŋum iłuaqsiñiġai. ");
INSERT INTO eskNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iñuich quviġutchaŋniqsut qiñiqamisigik uqatlaiḷaat uqaaqsipmata, sulguiḷimaruat iłuaqsikkaupmata, pisutlaitchuat pisutlasipḷutiŋ, suli ayauŋaruat qiñitlasipḷutiŋ; kamaksruġniġaat Agaayyutaat Israel-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus-ŋum maliġuaqtini iŋmiñuquniġai nipliutiplugich, “Iḷunŋutchaliqsuŋa makuniŋa iñuŋnik nayuutituiñaqtuanik uvamni piŋasuni uvluni, atakkii niqiksraitmiut. Aullaqtinniaŋitkitka niġisuŋaitñik atakkii taaqtukkaqpiaqtut apqutmi.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Maliġuaqtaiñ nipliutiniġaat, “Sumiñ paqitkisivisa naamayumiñaqtuamik qaqqiamik marrumani iñuiḷaami niġipkautiksramik iñugayaanun?” ");
INSERT INTO eskNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus-ŋum apiqsruġniġai, “Qanutun iñugiaktigiruanik qaqqianik piqaqpisi?” Kiuniġaat, “Tallimat malġuŋnik suli iñugiakisuuranik aqalugauranik.” ");
INSERT INTO eskNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesus-ŋum tiliriñiġai iñugayaat aquvitquplugich nunamun. ");
INSERT INTO eskNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tiguniġai tallimat malġuk qaqqiat aqalugauratlu. Quyaanikamiuŋ Agaayyun avguqługich qaiññiġai maliġuaqtimiñun, aasiiḷi taapkua autaaqługich iñugayaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iluqatiŋ iñuich niġiñiqsut niġisuiġataqhutiŋ. Aquagun maliġuaqtai katitchiñiqsut iḷakunik immiġataqługich tallimat malġuktun aguupmaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tamatkua niġiruat 4,000-tun iñugiaktiginiqsut, aġnatlu iḷiḷgaatlu kisirrutisuŋaqnagich. ");
INSERT INTO eskNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus-ŋum aullaqtinŋanikamigich iñugayaat ikiniqsuq umiaqpauramun tikitḷuni nunaŋanun Magadan-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisee-ŋuruatlu Sadducee-ŋuruatlu utlautiniqsut Jesus-mun uuktuaġiaqługu. Apiqsruġniġaat qiñiqtitquplutiŋ quviqnaqtuamik savaamik nalupqinaiġutaulugu Agaayyutim tuyuqtilaaŋanik qiḷaŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kiuniġai, “Unnuksraaqman uqaġuurusi, ‘Siḷaŋŋuġniaqtuq atakkii qiḷak kaviqsiruq.’ ");
INSERT INTO eskNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Suli uvlaami uqaġaqtusi, ‘Siḷaqłuŋniaqtuq ugluvak atakkii qiḷak kaviqsiruq nuviyaqłuġuqman.’ Sivuniqsitḷagaluaqhusi siḷamik qiḷaum qiññaŋagun, aglaan iḷitchuġitlaiññiġisi qanuutautilaaŋat quviqnaqtuat savaat atuumaruat akunnapsitñi. ");
INSERT INTO eskNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Makua iñuich pigiitchuatlu sayuŋaruatlu qiñiġuktut quviqnaqtuanik savaanik, aglaan qiñiġumiñaitḷutiŋ taatnatchimik. Qiñiłhiñaġisigaat quviqnaqtuaq savaaq sivuniksriqirikun Jonah-kun.” Tavra Jesus-ŋum uniññiġai taapkua aullaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesus maliġuaqtaiḷu ikaaġniqsut igḷuanun narvaqpaum. Maliġuaqtai iḷitchuġiniqsut piiguisilaaġmiknik qaqqianik. ");
INSERT INTO eskNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus-ŋum uqautiniġai, “Qaunagititchi puvlaksautiŋatniñ Pharisee-ŋuruatlu Sadducee-ŋuruatlu.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aglaan uqauraġniqsut iŋmiknun itnaqhutiŋ, “Uqautigigaa taamna qaqqialigaaŋiññapta.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus-ŋum iḷisimaplugich qanuq uqaqtilaaŋat apiqsruġniġai, “Suvaata ilipsiguuraq uqauraqpisi qaqquiññipḷugu? Ukpiqsrił̣ikiññiaġniqpat ilipsitñi. ");
INSERT INTO eskNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kaŋiqsitḷaitpisisuli? Naagaunniiñ itqatlaitpisigik avguqapkich tallimat qaqqiat 5,000-nun aŋutinun? Qapsiñik aguupmaŋnun immiqsitpisi? ");
INSERT INTO eskNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naagaunniiñ tallimat malġuk qaqqiat avguqapkich 4,000 iñuŋnun? Qapsiñun aguupmaŋnun immiqsitpisi? ");
INSERT INTO eskNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Qanuġimña kaŋiqsiŋiññiqpisi uqautiqaŋisilaamnik qaqqianik? Qaunagititchi puvlaksautiŋatniñ Pharisee-ŋuruatlu Sadducee-ŋuruatlu.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Taatnaanikman maliġuaqtai kaŋiqsiñiqsut ilaanun uqautiŋisilaaġmiknik puvlaksautinik aglaan qaunagitquplugich iḷisauttutiŋitñiñ Pharisee-ŋuruatlu Sadducee-ŋuruatlu. ");
INSERT INTO eskNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus utlautikami nunaŋanun Caesarea Philippi-m apiqsruġniġai maliġuaqtini, “Iġñiŋa Iñuum kisuunipḷugu uqaġaġivat?” ");
INSERT INTO eskNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kiuniġaat, “Iḷaŋisa John Paptaaqtitchiraunigaat, atlatli Elijah-ŋunipḷugu, atlatsuli Jeremiah-ŋunipḷugu naagaqaa iḷaginasugiplugu sivuniksriqiraiñun Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Apiqsruġniġai, “Ilipsiḷimi kisuunasugivisitŋa?” ");
INSERT INTO eskNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter-m nipliutiniġaa, “Christ-ŋurutin. Iġñiġigaatin iñuuruam Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus-ŋum kiuniġaa, “Simon, iġñiŋa Jonah-m! Quvianamiurutin! Atakkii uqautigikkan iñuum sagviaqtuŋitkaa ilipnun aglaan aapaam qiḷaŋmiittuam. ");
INSERT INTO eskNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Uqautillakkikpiñ, Peter-ŋurutin itnautauruaq Uyaġaŋmik aasiiñ taavrumuŋa uyaġaŋmun nappaġniaġiga agaayyuviga, suli saŋŋipayaaŋiñ tuqułhum akiiḷiyumiñaitkai. ");
INSERT INTO eskNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ilvichuvva, qaitchigisigikpiñ itqutiksranik aŋaayuqautaanun Agaayyutim. Suapayaaq qiḷiqsruumakkaqsi maani nunami qiḷġutiqaqtuiñaġisiruq qiḷaŋmi, aasiiñ suapayaaq qiḷġutaiyakkaqsi maani nunami qiḷġutaiyakkaugisiruq qiḷaŋmi.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesus-ŋum maliġuaqtini uqaquŋiññiġai kisumununniiñ iñuŋmun Christ-ŋuniḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tavrakŋaniñaglaan Jesus uqautriaqsiñiqsuq maliġuaqtimiñik nalupqinaiqł̣ugu, “Jerusalem-muktuksrauruŋa. Tavraniasiiñ nagliksaaqtuksraupluŋa sivulliuqtiġruaniñ qaukłiŋitñiñḷu agaayuliqsit aglaliqiriniñḷu, suli tuqqutauruksraupluŋa. Aglaan aŋipkakkaugisiruŋa piŋayuatigun uvlut.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter-m avuŋaqtaaġutiplugu Jesus iñiqtiġniġaa itnaqługu, “Ataniiq, Agaayyutimtuq taatniitinġiḷḷiuŋ taamna. Atuumaruksrauŋipiaqtuq ilipnun.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus-ŋum qiviaqługu Peter nipliutiniġaa, “Tuunġaaq, piiġiñ uvamniñ! Piñaiḷutaurutin uvamni. Isummatiqaŋitchutin Agaayyutim isummataiñik, aglaan isummatiqaqtutin iñuich isummataatun.” ");
INSERT INTO eskNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesus-ŋum nipliutiniġai maliġuaqtini, “Kisupayaam maligukkumiŋa suksraaqtaksraġigaa pisułłi, iqsriutilugu sanniġutani aasiiñ maligluŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Atakkii kiapayaaq anniġiniaġumiuŋ iñuułłi tammaigisigaa, aglaan kiapayaaq tammaiyumiuŋ iñuułłi piqutigiluŋa piññakkisiruq iḷumun iñuułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Iñuum piññaktaaġiłhiñaugaluaġaa suurapayaaŋa marruma nunam, aglaan tammautigisigaa iñuutchii. Sakuuŋuraġniałha sumun atuġumiñaitchuq! Tarra simmiutiksraitchaa iñuum iñuutchii. ");
INSERT INTO eskNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Atakkii Iġñiŋa Iñuum aggiqsaġumaruq piqatigilugich isaġuliŋni quvianaŋagun aapami, tavraniasiiñ akiḷḷiġisigaa iñupayaaq savaaŋigun. ");
INSERT INTO eskNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iḷumun uqautigipsi, Iñuqaqtuq-samma makitaruanik uvani tuquniaŋitchuanik qiñiġaluaqnagu Iġñiŋa Iñuum aggiqpan umialgulugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Itchaksrat uvlut aquatigun Jesus-ŋum aullautiniġai Peter-lu James-lu John-lu, aniqataa James-ŋum, kisiitñik qutchiksuamun iġġimun. ");
INSERT INTO eskNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tavrani qiñiqtitlugich Jesus atlaŋŋuġniqsuq sivuġaatni. Kiiñaŋa qaummaġiksiñiqsuq siqiñiqtun atnuġaaŋi qatiqsipḷutiŋ kirratchiatun. ");
INSERT INTO eskNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taatnaġmiutlu Moses suli Elijah sagviġñiqsuk uqaqatigiaqsipḷugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter-m nipliutiniġaa Jesus, “Ataniiq, nakuuniqsuq nayuutikapta uvani. Nappaitquguptigut nappaiñayaqtuŋa piŋasunik palapkaaksranik, atautchimik ilipnun, suli atautchimik Moses-mun, suli atautchimik Elijah-mun.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Uqaqtitlugusuli qaumaruam nuviyam qulaŋiutiniġai aasiiñ nipi nipliqhuni nuviyamiñ, “Tavrataamna piqpagikkaġa Iġñiġa quyalimaaqtigillapiakkaġa, naalaġniyumagiksi.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Maliġuaqtit tusaakamitruŋ nipi punniqsut nunamun iqsitchakhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aglaan Jesus-ŋum utlakługich aksiŋñiġai aasiiñ nipliutiplugich, “Makititchi, suli iqsiŋaiġitchi.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aaġluqamiŋ maliġuaqtit qiñiŋiññiqsut iñuŋnik. Jesus inniqsuq kisimi. ");
INSERT INTO eskNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Atqaaqsikamiŋ iġġimiñ Jesus-ŋum tilisiñiġai, “Uqaġniaqasi kisumununniiñ tamatkuniŋa qiñikkapsitñik Iġñiŋa Iñuum aŋitqił̣hanunaglaan tuqułiġmiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Maliġuaqtaiñ apiqsruġniġaat Jesus, “Suvaata aglaliqirit uqaqpat Elijah aggiqqaaqtuksraunipḷugu aggiŋaiñŋaan Christ?” ");
INSERT INTO eskNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus-ŋum kiuniġai, “Taapkua uqaqtut iḷumutuuruamik. Elijah aggiqqaaġniaqtuq Christ-miñ itqanaiyaġiaġlugu suapayaaq. ");
INSERT INTO eskNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aglaan uqautigipsi, Elijah aggianiktuq, aasiiñ iñuich nalurut kisuutilaaŋanik. Qanupayaaq aŋalatchukamitruŋ aŋalatkaat. Taatnatuntuuq Iġñiŋa Iñuum nagliksaaqtinniaqmigaat.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Maliġuaqtaiñ kaŋiqsiḷġataġniġaat Jesus-ŋum uqałha John Paptaaqtitchirimik. ");
INSERT INTO eskNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesus maliġuaqtiniḷu tikitmata iñugayaanun iñuum utlaŋniġaa sitquqhuni sivuġaanun ");
INSERT INTO eskNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nipliqhuni, “Ataniiq, nagligillaŋniaġuŋ iġñiġa. Qiiqsruġuupluni nagliksaallapiaqtuq. Akulaiqł̣ugu puukaġaqtuq ikniġmunlu imiġmunlu. ");
INSERT INTO eskNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Maliġuaqtipnuutigaluaġiga, aglaan iłuaqsiḷguiññiġaat.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus-ŋum kiuniġaa, “Ukpiqqutaitchuasii ilipsitñi! Naagasuli killukuaqmiusi! Qanutunaglaan nayuutiniaqpik ilipsitñi? Qanutunaglaan igḷutuqtaksraġivisisuli? Uvuŋautisaqsiuŋata nukatpiaġruk.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus suamasipḷuni tilisiñiqsuq irrusiqł̣uŋmik anitquplugu nukatpiaġruŋmiñ. Irruqsiqłuk anitman nukatpiaġruk iłuaqsiḷiġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maliġuaqtaiñ utlaŋniġaat Jesus kisipquqhutiŋ apiqsruqługu, “Suvaata irrusiqł̣uk anitlaitpisigu?” ");
INSERT INTO eskNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus-ŋum uqautiniġai, “Pisigiplugu ukpiqsriŋił̣iqsi. Uqautigipsi, Ukpiqsrisiqaġupsi mikitilaaŋatun mustard-ŋum nautchiaksrauraŋatun uqautiłhiñaugiksi una iġġiq, Nuuttin iñuŋa uvakŋa, aasiiñ nuunniaqtuq. Pił̣hiñaugisirusi supayaanik. ");
INSERT INTO eskNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aglaan kisiagun agaayułikun uisauraałikunlu anitlagai taatnatchich irrusiqł̣uich. Atlam sum anitchumiñaitkai.” ");
INSERT INTO eskNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Atautchimukamiŋ Galilee-mi Jesus-ŋum uqautiniġai maliġuaqtini, “Iġñiŋa Iñuum aatchuutigikkauniaqtuq iñuŋnun; ");
INSERT INTO eskNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iliŋisa tuqqutkisigaat. Aglaan piŋayuatigun uvlut aŋipkakkauniaqtuq tuqqutaułhaniñ.” Tavra maliġuaqtai ipiqtutchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus maliġuaqtiniḷu tikitñamiŋ Capernaum-mun nalautchirut iñuŋnik katitchiraunik aatchuutinik agaayyuvikpaŋmun. Tamatkua Peter apiqsruġniġaat, “Umaa, iḷisautriksi akiḷiqsuġaġiva tax-sinik agaayyuvikpaŋmun?” ");
INSERT INTO eskNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Aa, akiḷiisuuruq,” Peter-m kiuniġaa. Aasii isiqman tupiġmun Jesus nipliqqaaġniqsuq ilaanun apiqsruqługu, “Simon, sumik isumavich? Kisuniñ umialiŋi nunam katitchiraġivat tax-sinik? Nunaqatmikniñ naagaqaa avakŋaqtaniñ?” ");
INSERT INTO eskNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter-m kiuniġaa, “Atlaniñ.” Jesus nipliutiniġaa Peter, “Tavra, nunaqatit akiḷiqsuġniaŋiññiqsut tax-sinik. ");
INSERT INTO eskNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aglaan atniummativiaġivut iñuich. Aullaġutin niksigiaġiñ narvamun. Qanġaniñ sivullium aqaluum niksiksaqpich paqitkisirutin maniŋmik. Tigulugu taamna qaitchumagiñ iliŋitñun, aasii akiḷiutilunuk.” ");
INSERT INTO eskNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Maliġuaqtaiñ utlakługu Jesus apiqsruġniġaat, “Kiña kamanaġniqsrauva Agaayyutim aŋaayuqautaani?” ");
INSERT INTO eskNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesus-ŋum tuqłuġniġaa iḷiḷgauraq iŋmiñuquplugu, aasiiñ qikaqtitlugu akunġatnun maliġuaqtit ");
INSERT INTO eskNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nipliqhuniasiiñ, “Uqautigipsi, isummitqiŋisuaġupsi aasiiñ iḷiḷusi iḷiḷgauratun isiġumiñaitchusi Agaayyutim aŋaayuqautaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kiñapayaaq atchiksiruaq iŋmiñik atripḷugu taamna iḷiḷgauraq kamanaġniqsrauruq ukunakŋa Agaayyutim aŋaayuqautaani. ");
INSERT INTO eskNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Suli kisum iñuum akuqtuġumiuŋ iḷiḷgauraq pisigiluŋa akuqtuġaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Aglaan kia iñuum killuqsaqtitpagu iḷaŋat makua ukpiqsrisiqaqtuat uvaŋnun iḷiḷgaatun nakuutlukkayaqtuq taamna quŋisiġmiutchiġḷugu uyaġakpaŋmik ipipkaqpan itiniqsraŋani taġium. ");
INSERT INTO eskNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Qanutun tatamnaqtigivat nunam iñui killuqsaqusaaqtuat iñuŋnik. Taatnatchich killuqsaqusaaġutit atuumarut ataramik. Aglaan qanutun tatamnaqtigiva taamna iñuk ukpiġutaiqsitchiruaq iñuŋnik killuqsaqusaałiġmigun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Argapsi naagaqaa isigapsi killuqsaqtitpasi, kipilugich igitchumagisi. Nakuutlukkayaqtuq isiġupsi iñuułiġmun argaiḷḷusi naagaqaa isigaiḷḷusi uumakŋa igḷuktun argaliŋmiñ naagaqaa isigaliŋmiñ igitauluniasiiñ isuitchuamun ikniġmun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Suli iripsi killuqsaqtitpasi piiġḷugu igitchumagiksi. Nakuutluŋniaqtuq isiġupsi isuksraitchuamun iñuułiġmun atautchimik iriqaġusi uumakŋa malġuŋnik iriliŋmiñ igitauluniasiiñ anasiñŋuqsaġvium ikniŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Qaunagititchi suuŋiḷḷaġiłiksraŋatniñ makua iḷiḷgaurat. Atakkii isaġuliŋich ataramik aapamnułhiñaurut qiḷaŋmi. ");
INSERT INTO eskNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iġñiŋa Iñuum aggiqsuq anniqsuġiaqługu tammaqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Qanuq isummatiginayaġniqpisiuŋ iñuk piqaqtuaq tallimakipianik ipnaiñik aasiiñ atausiq tammaġuni? Pakkiaġumiñaiññiqpauŋ taamna atausiq tammaqtuaq? Uniññiaġai taapkua tallimakipiaġuutaiḷat ipnaich qimiġaamun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Uqautigipsi, paqitkumiuŋ taamna atausiq ipnaiq quviatchautigitluŋniaġaa ukunakŋa tallimakipiaġuutaiḷaniñ tammaŋitchuaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Taatnatuntuuq aapapsi qiḷaŋmiittuam pisułiġiŋitkaa atausiġunniiñ iḷaŋat tamatkua ukpiqsriruat iḷiḷgauratun iḷipḷutiŋ tammaqulugu. ");
INSERT INTO eskNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aniqatin killuqsaqpan akikŋaġutin uqautityaġuŋ killuqsautaanik kisiŋŋuġusik ilaalu ilviḷḷu. Naalaġnikpatin aniqatigiliutitqiŋñiaġiñ utitmun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aglaan naalaġnisuŋitpatin utlatqikkumagiñ piqasiġutin atautchimik naagaqaa malġuŋnik iññuŋnik. Taapkua iñuich iḷisimarautlaniaqtut uqaġipayaakkapkun aniqatiupnun. Atakkii pasikkutipayaaq inillakkaugisiruq malġukkun naagaqaa piŋasutigun iḷisimarauruatigun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Naalaġnisuŋiḷgitpagich uqaġilugu ukpiqtuaŋuruanun; naalaġnisuŋitchuiñaqpan aasiiñ ukpiqtuaŋuruanikunniiñ irrutigisigiksi Jew-ŋuŋitchuatun naagasuli tax-siliqiritun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iḷumun uqautigipsi, Suapayaaq qiḷiqsruumakkaqsi maani nunami qiḷġutiqaqtuiñaġisiruq qiḷaŋmi; suli suapayaaq qiḷġutaikkaqsi maani nunami qiḷġutaiyakkaugisiruq qiḷaŋmi. ");
INSERT INTO eskNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Uqautipsaaġipsi, Malġuugupsik maani nunami aasii aŋiġutilusik supayaakun apiqsruġupsik, aapaa qiḷaŋmi savaaġigisigaa ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Atakkii nani malġuk naagaqaa piŋasut katikpata pisigiluŋa nayuutigisiruŋa iliŋitñi.” ");
INSERT INTO eskNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aasiiñ Peter-m utlakługu Jesus apiqsruġniġaa, “Ataniiq, qapsiñiaglaan natqigutiraksraġivigu aniqatiga akitñaġluŋa killuqsaqpan? Tallimat malġuŋniaglaan?” ");
INSERT INTO eskNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus-ŋum kiuniġaa, “Tallimat malġułhiñauŋiḷaaŋnik aglaan piŋasukipiaq qulit tallimat malġuŋniaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Agaayyutim aŋaayuqautaa sagviqpan atriqaġisiruq umialiŋmik apiqsruqtuamik savaktimiñik qanutun iliŋitñun akiqsruutiqaqmagaaġmi. ");
INSERT INTO eskNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Makpiġarriqisaanikman iñuk akiqsruummirigikkaŋa manikpauramik tikiutikkauniqsuq ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akiḷiiyumiñaiññiqman aŋaayuqaŋan tunirautquniġaa aġnaatlu suli qitunġauraŋi suli iluqaisa suurapayaaŋi aasiiñ akiḷiutigilugich niġġiuqsruutaiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Savakti sitquqami sivuġaanun uqapsaaġniqsuq, ‘Ataniiq, utaqqiurallaŋŋa. Utiqtitchigisigikpiñ iluqaitñik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aŋaayuqaŋan iḷunŋutchautiplugu aullaqtinniġaa natqigutiplugich niġġiuqsruutai. ");
INSERT INTO eskNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aglaan savakti anikami tavrakŋa nalaunniġaa iḷaŋat savaqatmi niġġiuqsruummirigikkani qapsiuranik maniŋñik. Tiguniqłukamiuŋ qimitchiqsruaqsiñiġaa nipliutiplugu, ‘Niġġiuqsruutin utiqtirruŋ uvamnun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Savaqataan purviginiġaa iŋiqsruaqługuasiiñ, ‘Utaqqiurallaŋŋa. Utiqtitchigisigikpiñ iluqaitñik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aglaan akiqsruġvigikkaŋa utaqqisuŋiññiqsuq. Aullautiłhiñaġniġaa isiqsiviŋmun aasiiñ isiqtaupkaqługu utiqtitchiñiałhanunaglaan niġġiuqsruutaanik. ");
INSERT INTO eskNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Atlat savaktit qiñiqamitruŋ taamna atuumaruaq ipiqtutchallapiaġniqsut. Utlakługu aŋaayuqaqtiŋ uqautiniġaat iluqaitñik atuumaruanik. ");
INSERT INTO eskNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aŋaayuqaŋan savakti isiquniġaa nipliutiplugu, ‘Pigiitchuatiin savaktii! Natqigutigaluaġikpiñ niġġiuqsruutipnik uvamnun iŋiqsruaqapŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Suvaata iḷunŋuksriñġiññiqpich savaqatiknik atriḷuŋa nagliksrił̣ł̣aptun ilipnik?’ ");
INSERT INTO eskNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tavra aŋaayuqaŋan qinnautiplugu tuyuġiniġaa isiqsirinun anasiñŋuqsaquplugu akiḷiiñiałhanunaglaan niġġiuqsruutipayaaŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Taatnatuntuuq aapama qiḷaŋmi irrutiniaqmigaasi natqigutriŋitchupsi aniqatiupsitñik uummatipsitñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus uqaŋaiqami tamatkuniŋa aullaġniqsuq Galilee-miñ utlautipluni nunaaqqiuraŋiñun Judea-m akiani Jordan-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iñugiaktuat iñuich maliŋniġaat. Jesus-ŋum mamitinniġai atniġñaqtuat tavrani. ");
INSERT INTO eskNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Iḷaŋisa Pharisee-ŋuruat utlaŋniġaat. Tavra uuktuaqsaqługu apiqsrulgiññiġaat, “Aŋutim avitpagu nuliani patchitchiġuni supayaanik, maliġutaksrakuaġnaqpa?” ");
INSERT INTO eskNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus-ŋum kiuniġai, “Agliqisimasuknaġiksi aullaġniipman Agaayyutim iñiqsił̣ha aŋutmiglu aġnamiglu. ");
INSERT INTO eskNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Taatnaqhuni aŋutim unisaksraġigaa aapani suli aakani aasiiñ piqasiutiluni nuliaġmiñun, iluqatik-aasii atautchisun timinigutik. ");
INSERT INTO eskNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Malġuuŋaiqsuk aglaan atausiŋŋuqtuk. Iñuum avitiŋiḷḷiuŋ tuvaaqatini Agaayyutim piqasiutipkaqmatik.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pharisee-ŋuruat apiqsruġniġaat, “Suvaatami Moses tillisiqaġniqpa aŋutmun agliutiqqaaġlugu aullaqtilluguasiiñ nuliani?” ");
INSERT INTO eskNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus-ŋum kiuniġai, “Moses-ŋum avititkaasi nuliapsitñiñ atakkii iḷisautitchiġiitpaitḷusi. Aglaan itniinġitkaluaqtuq aullaġniił̣haniñaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Uqautigipsi, Aġnaq tuniqsimauraqnaiñŋaan aŋutmiñun naagasuli aŋutim avitkumiuŋ, iḷaqatnitqiguniasii atlamik aġnamik. Taamna aŋun atlatuqtauruq.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Maliġuaqtaiñ nipliutiniġaat, “Taatna inniaqpan akunġakni nuliaġiik nakuutluŋniaġniqsuq iḷaqatniŋitchuni.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aglaan Jesus kiuniġai, “Iñugiaktuat iñuich akuqtutlaitkisigaat taamna iḷisauttun. Kisimiŋaglaan tamatkua Agaayyutim qaitchikkaŋi akuqtutlagisigaat. ");
INSERT INTO eskNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Atakkii aŋutiqaqtuq isuanunaglaan iḷaqatnikkummataitchuanik; suli aŋutiqaqmiuq iḷaqatnikkumiñaiyakkaŋitñik iñuich; atlatsuli, iḷaqatnikkummataitḷutiŋ atakkii savautisutlukkaat Agaayyun. Iñuum akuqtuġumiñaġumiuŋ taamna iḷisauttun akuqtuġliuŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iñuich iḷiḷgaurat tikiutruġniġaich Jesus-mun argaŋi iḷiḷugich iḷiḷgauranun agaayyutitquplugich. Aglaan maliġuaqtit iñiqtiġniġaich tamatkua iñuich. ");
INSERT INTO eskNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus nipliġñiqsuq, “Iḷiḷgaurat uvamnuktitchigik. Avriaqutaunasi iliŋitñun atakkii Agaayyutim aŋaayuqautaa aŋmaruq iñuŋnun atriqaqtuanun iḷiḷgaanik.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iḷikamigich argaŋi agaayyutiqqaaqługich aullaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aŋun utlautiniqsuq Jesus-mun apiqsruqhuni, “Iḷisautrii, sunik nakuuruanik savagluŋa piqatlasiñayaqpik isuitchuamik iñuułiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus-ŋum nipliutiniġaa, “Suvaata taiguutiqaqpiŋa nakuuruamik? Kisimi Agaayyun nakuuruaŋuruq. Aglaan iñuułiqaġukkuvich tupigiyumagitin tillisit.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nukatpiam apiqsruġniġaa, “Nalliŋich?” Jesus nipliġñiqsuq, “Iñuaġniaqnak, atlatuġniaqnak atlam iḷaqataanik, tigliŋniaqnak, sagluniaqnak iḷisimarauguvich. ");
INSERT INTO eskNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kamagilugik aapan aakanlu, piqpagilugu iñuuniaqatin iliptun iḷiḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nukatpiaq nipliġñiqsuq, “Tamatkua iluqaisa qaunagigitka nutaułłamniñaglaan. Sumik minitchivik?” ");
INSERT INTO eskNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus-ŋum uqautiniġaa, “Taŋiġisukkuvich tillisipayaanik tunityakkich suurat pisin aasiiñ qaiḷḷugich maniich iḷaippauranun. Taatnaġuvich piññakkisirutin akisuruamik qiḷaŋmi. Taatnaanikkuvich maliŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nukatpiam tusaakamiuŋ taamna ipiqtutchakhuni aullaġniqsuq atakkii sulliñaurauqaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus-ŋum nipliutiniġai maliġuaqtini, “Iḷumun uqautigipsi, Sakiqnallapiaġisiruq umialguruami iñuŋmi isiġniałiksraŋa Agaayyutim aŋaayuqautaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Uqautipsaaġipsi, qaġanatluktuq pikukturuam isiłiksraŋa ‘Mitqutim Iraagun’ uumakŋa umialguruam isiłiksraŋaniñ Agaayyutim aŋaayuqautaanun.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Maliġuaqtaiñ tusaakamitruŋ taamna quviġutchallapiaġniqsut nipliqhutiŋ, “Kiñami anniqsuġisiñiqpa?” ");
INSERT INTO eskNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus-ŋum takusaqługich nipliutiniġai, “Sua iñuich savaaġiyumiñaisaŋat Agaayyutim savagitlapiaġataġaa.” ");
INSERT INTO eskNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peter-m kiuniġaa, “Supayaat unitkivut maligukhutin. Aasiiḷi sumik piññaŋniaqpisa?” ");
INSERT INTO eskNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus-ŋum nipliutiniġai, “Uqautigipsi, Iġñiŋa Iñuum aquvinŋanikpan aquppiutaqpaŋmiñun quvianaġmiñi suli supayaaq nutaaġuqpan, tavra ilipsi maliġuaqtuasii uvamnik, aquppigisipmiusi qulit malġuŋnun aquppiutaqpaŋnun atanniqsuġlugich kiŋuviaŋi qulit malġuk iġñiŋiñ Israel-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Suli kiñaliqaa unitchiruaq kiŋuniġmiñiglu aniqatmiñiglu aapamiñik aakamiñiglu, iḷiḷgaaġmiñiglu naagaqaa nunamiñik pisigiluŋa akuqtuigisiruq akiḷiusianik tallimakipiaġuġlugu. Piññakkisiruq isuitchuamik iñuułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aglaan iñugiaktuat sivulliuruat pakma aqulliġuġisirut, suli iñugiaktuat aqulliuruat pakma sivulliġuġutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Agaayyutim aŋaayuqautaa sagviqpan itkisiruq iñuktun nautchiiviqaqtuatun. Anipḷuni uvlaatchaurami savaktiksraqsiuġniqsuq nautchiiviŋmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sivunniuqatigiqqaaqługich savaktiksrat akiḷiġisiñipḷugich uvlum akiksraŋanik savakpata nautchiiviŋmiñi tiliñiġai. ");
INSERT INTO eskNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Quliŋuġutaiḷamun sassaq tikitman aullalgitñami qiñiġniġai atlat tunisiñiaġviŋñi qikaqtuat ittuaqsiñaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nipliutiniġai, ‘Savviaġitchiḷi nautchiivimñun. Nalaunŋaruamik akiḷiġisigipsi.’ Savviaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aullalgiññiqsuq uvluq qitiqquġuŋnaqman suli piŋasunun sassaq iḷipman, taatnatunsuli savviaqtitchipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Suli aullalgiññiqsuq tallimanun sassaq tikitchuŋnaqsipman, aasiiñ paqilgitñami atlanik qikaġaaqsiñaqtuanik apiqsruġniġai, ‘Suvaata qikaqtuaqsiñaqpisi taatna uvluvakpauraq ittuaqhusi?’ ");
INSERT INTO eskNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kiuniġaat, ‘Atakkii kia-unniiñ iñuum savaktiksraqtaaġiŋitḷuta.’ Uqautiniġai, ‘Aullaġitchiḷi savviaġusi nautchiivimñun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Anaqaksraaqman nautchiiviqaqtuaq uqaġniqsuq savaktit aŋaayuqaŋatnun, ‘Tuqłuġlugich savaktaut akiḷikkich akiññaktaaŋitñik, aullaġniiḷugich aqulliuplutiŋ savviaqtauniñ sivulliġñunaglaan.’ ");
INSERT INTO eskNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aggiqmataasiiñ taapkua savaktiksraqtaaŋuruat tallimanun sassaq iḷipman, akiḷiqł̣ugich uvlum akiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taapkuali savaktiksraqtaaqqaaŋuruat aggiqamiŋ, isumaniqsut akikŋatluŋniaqhutiŋ. Aglaan atausiullaaplutiŋ akuqtuipmiñiqsut uvlum akiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Taapkua akuqtuikamiŋ akiññaktaaġmiknik uqapiḷuaqsiñiqsut akikŋaqługu nunautilik ");
INSERT INTO eskNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","uqaqhutiŋ, ‘Tamatkua aqulliich savviaqtuat savaktut atautchił̣hiñami sassaġniġmi. Akiḷiġitin atunim uvaptiktun naagauvva igḷutuqługu uunaq savakhuta uvluqtutilaaŋatun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Aglaan kiuniġaa iḷaŋat, ‘Iḷauramaaŋ, savvaqłuutiŋitkikpiñ ivayaġniaġutin. Sivunniuqatigiŋitpiŋa savagukhutin akiksraŋatun uvlum? ");
INSERT INTO eskNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tigulugu akiḷiusian aŋiḷaaġiñ. Qaitchisukkiga aŋun savviaqtuaq aqulliupluni ilipniktuaq akiḷiipmatun. ");
INSERT INTO eskNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nalaunŋaiññiqpik isumaptun aŋalatchikama pigikkamnik? Naagaqaa killuqsraqpich anniqsraitñama?’ ");
INSERT INTO eskNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Taatnatuntuuq aqulliich sivulliġuutigisirut, suli sivulliich aqulliġuutilutiŋ. Iñugiaktuat iñuich tuqłirakkaugaluaqtut, aglaan ikituurat piksraqtaaŋurut.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus Jerusalem-mukhuni saniqpaktaaġutiniġai qulit malġuk maliġuaqtini uqautiplugich, ");
INSERT INTO eskNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Naalaġnisitchi, Jerusalem-muŋniaqtugut Iġñiŋa Iñuum aatchuutigikkauviksraŋanun qaukłiŋitñun agaayuliqsit suli aglaliqirinun. Iliŋisa tuqqutaksraġuġniñiaġaat. ");
INSERT INTO eskNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Qaitkisigaat Jew-ŋuŋitchuanun mitautigitqulugu ipiġaqtuġlugulu, suli kikiaktuutipkaġlugu sanniġutamun; aglaan aŋitqiksikkauniaqtuq piŋayuatigun uvlut.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aasiiñ Zebedee-m iġñakkiñ aakaŋak utlautiniqsuq Jesus-mun piqatigiplugik iġñaŋni. Sitquġviginiġaa sivuġaanun iŋiqługu pisitquplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus-ŋum apiqsruġniġaa aġnaq, “Sumik pisukpich?” Aġnam kiuniġaa, “Tilikkik ukuak iġñakka aquppitḷasiḷugik ilipni, iḷaqataa taliqpiqñun suli iḷaqataa saumipñun atanniqsuiguvich aŋaayuqautipni.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus-aasiiñ nipliġñiqsuq, “Nalurusi sumik iŋiqsruqtilaapsitñik. Imiłhiñauvitku qallun imiqsaġumakkaġa naagaqaa apqusaałhiñauvitku naŋinnaqtuaq apqusaagaksrautigikkaġa?” Taapkuak iġñakkiñ kiuniġaak, “Imiłhiñaugikpuk.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus-ŋum nipliutiniġik, “Iḷumun imiġniaġaluaqtusik qallutmiñ imiġniakkamniñ. Aglaan piksraqtuksrauŋitchuŋa aquppiruksraŋnik taliqpimñi saumimñiḷu. Taapkuak innak iñuqaġniaqtuk aapaa itqanaiyautikkaŋiknun.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Qulit tusaakamiŋ taavrumiŋa iłuagiŋiññiġaich taapkuak malġuk aniqatigiik. ");
INSERT INTO eskNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesus-ŋum tuqłuġniġai maliġuaqtini uqautiplugich, “Iḷisimarusi aŋalatiŋich Jew-ŋuŋitchuat aŋalanniġlugaqtilaaŋatnik iñuŋitñik suli kamanaġniqsraŋisa naŋititchuuplugich. ");
INSERT INTO eskNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aglaan taatnaittuksraunġitchuq ilipsitñi. Kiñapayaaq kamanaġuktuaq akunnapsitñi ilipsitñun savaktiruksrauruq. ");
INSERT INTO eskNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Suli kisupayaaq qaukłiusukkumi savaktaaġruguqtuksrauruq iluqapsitñun. ");
INSERT INTO eskNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Taatnatun Iġñiŋa Iñuum aggiŋitchuq savautipkaġiaġuni, aglaan savautrityaqhuni suli qaitchaqtuqługu iñuułłi tasuġukługich iñugiaktuat iñuich.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus maliġuaqtiniḷu aullaaqsipmata Jericho-mun, iñugiallapiaqtuat maliŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Malġuk aŋutik ayauŋaruak aquppiñiqsuk saniġaatni tumitchiat. Tusaakamik Jesus apqusaaġnipḷugu kappaiŋaniqsuk, “Ataniiq, kiŋuviaŋa David-ŋum! Nagligillaŋniaqtiguk.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Iñugayaat iñiqtiġniġaich nipaisaaquplugik, aglaan nipitutluuraqhutik kappaiŋaniqsuk, “Ataniiq, kiŋuviaŋa David-ŋum! Nagligillaŋniaqtiguk.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus nutqaqhuni tuqłuġniġik, aasiiñ apiqsruqługik, “Sutquvisik uvamnun?” ");
INSERT INTO eskNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kiuniġaak, “Ataniiq, qiñitlasisuktuguk.” ");
INSERT INTO eskNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus iḷunŋutchaŋniqsuq taapkuŋniŋa. Aksiŋñiġik iriŋik. Tavrauvaa qiñitlasiñiqsuk, aasiiñ malikługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aasiiñ qallikamiŋ Jerusalem-mun tikiññiqsut Bethphage-mun, iġġiġñun atiqaqtuamun Olives-mik. Tavrakŋa Jesus-ŋum tiliñiġik malġuk maliġuaqtiŋni, ");
INSERT INTO eskNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","uqautiplugik, “Aullaġutik nunaaqqiuramun sivunnaptikniittuamun. Amaniaŋani paqitkisigiksik pituqaqtuaq natmaksiġvik nuġġaŋalu. Pituiġḷugik uvuŋautiyumagitik uvamnun. ");
INSERT INTO eskNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kia iñuum qanuqpatik uqautiyumagiktik atanġuruamun inuġiniḷugik. Taavruma tavrauvaa aullaqtinniaġik.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iluqaan atuumaniqsuq taŋiqsaqługu sivuniksriqirim uqautigikkaŋa itnaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Uqautisigik iñuŋi Zion-ŋum, Ataŋii, umialiksi aggiqsuq ilipsitñun. Piisaaŋitchuq usiaqsiqsuq natmaksiġviŋmi, nuġġaŋaniunniiñ natmaksiġvium.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Maliġuaqtik aullaġniqsuk tuvraqługu Jesus-ŋum uqauttutaa iŋmiknun. ");
INSERT INTO eskNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Taapkuak aggiutiniġaak natmaksiġvik nuġġaŋalu Jesus-mun. Iḷiñiġaich atnuġaatik natmaksiġviŋmun aasii Jesus aquvitluni taapkuŋnuŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iñugiallapiaqtuat iñuich siaminniġaich atnuġaatiŋ tumitchianun. Atlatli kipriñiqsut akiqqunik napaaqtuniñ siapsiutiplugich tumitchianun. ");
INSERT INTO eskNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iñugayaat pisuktuat sivuagun Jesus-ŋum suli tamatkualu maliktuat niprualaniqsut, “Hosanna. Nanġaġlakput iġñiŋa David-ŋum. Uvvatuq Agaayyutim piḷiutiqaġliuŋ tikitchuaq piqusiqhuni Ataniġmik. Nanġakkauli Agaayyun qutchiŋñiqsrami qiḷaŋmi.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tavra Jesus isiqman Jerusalem-mun iñupayaaŋi nunaaqqim aġayaullaŋniqsut, aasiiñ iñuich apiqsruqtuġniqsut, “Kiña una?” ");
INSERT INTO eskNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tamatkua iñugayaat kiuniġaich, “Taamna tavra Jesus-ŋuruq, sivuniksriqiri Nazareth-miñ Galilee-mi.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus-ŋum isiqami agaayyuvikpaŋmun anittaġniġai iluqaisa tauqsiqsuktuat suli tunisiullaqtuat tavrani, suli ulġutaqługich tiivlut maniŋñik simmiqsuġviŋich aquppiutaŋitḷu tamatkua tunisiullaqtuat tiŋmiaġruuranik. ");
INSERT INTO eskNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesus-ŋum uqautiniġai tamatkua, “Aglausimaruq Agaayyutim makpiġaaŋiñi, Tupiġa taggisiqaġniaqtuq agaayutyaġviŋmik, aglaan iriqtuġvigiliutipkaġiksi tigliŋniaqtinun.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tavrani agaayyuvikpaŋmi ayauŋaruat suli pisutlaitchuat Jesus-muŋniqsut, aasiiñ Jesus mamititlugich. ");
INSERT INTO eskNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Qaukłiŋich agaayuliqsit aglaliqiritlu uumitchaŋniqsut qiñiqamitruŋ Jesus savaaqaqtuaq quviqnaqtuanik suli iḷiḷgaat niprualaruat agaayyuvikpaŋmi nipliqhutiŋ, “Nanġaġlakput iġñiŋa David-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tamatkuali nipliutiniġaat Jesus, “Tusaavigich makua sumik uqaqtilaaŋat?” Jesus-ŋum kiuniġai, “Ii, agliqisimasuknaġiksi uqałiq uqaqsimaruaq, ‘Aniqammiurat iḷiḷgauratlu nanġaipkaġniġitin quyyatillautamik’?” ");
INSERT INTO eskNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesus-ŋum uniññiġai. Aullaġniqsuq nunaaqqiqpaŋmiñ siñiktaqhuni Bethany-mi. ");
INSERT INTO eskNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Uvlaaġuqman Jesus utillaġmi nunaaqqiqpaŋmun niġisuliġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Qiñiqamiuŋ fig napaaqtua apqutmi utlaŋniġaa aglaan paqitchiŋitḷuni fig-nik, tamarra milukataigaluaq. Jesus-ŋum nipliutiniġaa napaaqtuq, “Tavrakŋaniñaglaan asianik nauritqiŋñiaqnak.” Taamna napaaqtuq pannaqłuktiġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Maliġuaqtaiñ qiñiqamitruŋ taamna quviġutchakhutiŋ uqaġniqsut, “Qanuqhuni manna fig napaaqtua paniqtiqpauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus-ŋum kiuniġai, “Uqautigipsi, Ukpiqsrisiqaġupsi arguaqtusuŋaqasi pitḷanayaqtusi savaaġikkaptun taavrumiŋa fig napaaqtuanik, aglaantuuq nipliġupsiunniiñ uumuŋa iġġimun, ‘Nuutittin igitaulutin taġiumun’ taatnallapiaq atuumanayaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ukpiqsrił̣ikun apiqsruġupsi supayaamik akuqtuigisirusi agaayułikun.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus Jerusalem-mun tikiñŋanikman isiġniqsuq agaayyuvikpaŋmun. Qaukłiŋisa agaayuliqsit sivulliuqtiġruatlu utlaŋniġaat Jesus iḷisautripkaqługu aasii nipliutiplugu, “Kisum aŋalatchił̣hagun savaaġivigich tamatkua? Kia saŋŋiksritpatin taatnatun?” ");
INSERT INTO eskNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus-ŋum kiuniġai, “Uvaŋaptuuq apiqsruġniaġipsi atautchił̣hiñamik. Kiugupsitŋa uqautigisipmigipsi nakiñ aŋalatchił̣iqaqłuŋa savaaġitilaaŋatnik tamatkua. ");
INSERT INTO eskNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kia saŋŋiksritpauŋ John paptaaqtitchiquplugu, Agaayyutim naagaqaa iñuich?” Uqaqtuyaaġniqsut iŋmiknun, “Uqaġupta agaayyutmiqsauniḷugu Jesus-ŋum uqautiniaġaatigut, ‘Suvaatami ukpiġiŋitpisiuŋ John?’ ");
INSERT INTO eskNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aglaan uqaġupta iñukmiqnisauniḷugu, iłuiġutchaktinniaġivut iñuich atakkii iñupayaat nalupqigiŋitkaat John sivuniksriqirautilaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aasiiḷi kiuniġaat Jesus, “Nalurugut.” Tavra nipliutiniġai, “Uqautiyumiñaitmigipsi sumiñ aŋalatchisiqaqłuŋa savaaqaqtilaamnik tamatkuniŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Qanuq isummatigiviuŋli aŋun iġñiqaqtuaq malġuŋnik? Utlaŋniġaa aŋayukłiq nipliutiplugu, ‘Iġñiiŋ savviaġiñ nautchiivimñun ugluvak.’ ");
INSERT INTO eskNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Taavruma kiuniġaa, ‘Savviaġumiñaitchuŋa,’ aglaan aquagun nunuuraniqsuq aullaqhuniasii. ");
INSERT INTO eskNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aapaŋak utlautilgiññiqsuq iḷaqataanun iġñiġmi uqautiplugu sivuanisun. Taavruma kiuniġaa, ‘Savviaġisiruŋa,’ aglaan aullaŋiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nalliak taapkuak iġñakkiñ tupiginiqpatku aaparik?” Kiuniġaat, “Taavruma sivullium.” Jesus-ŋum nipliutiniġai, “Nipliutigipsi, tax-siliqirit suli akiisut iñugiliutiniaġai Agaayyutim aŋaayuqautmiñi sivupsitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John aggiġaluaqtuq ilipsitñun iḷisautityaqhusi nalaunŋaruakun iñuuniaġviksrakun, aglaan ukpiġiŋitkiksi John. Aglaan tax-siliqirit akiisutlu ukpiġigaat. Aasiiḷi qiñiqapsigik nunuuraŋitchusi aquvatigun ukpiġilugu. ");
INSERT INTO eskNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Naalaġniḷḷagitchi atlamik atrikusautmik, Iñuqaġniqsuq nunaqaqtuamik. Nautchirriġviḷiuġniqsuq, sapukutchiqł̣ugu avataagun, nivakhuni misuġuliuġviksramik, nappaipḷuni nasiqsruġviŋmik, tavraasiiñ atukkirrutigiplugu nautchirriqirinun. Taatnaanikami aullaġniqsuq uŋasiksuamun nunamun. ");
INSERT INTO eskNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tavra qallipman pukugviksraq asianik tuyuġiniġai savaktini nautchirriqirinun aitquplugich piññaktaaksrautni iliŋitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aglaan nautchirriqirit tiguniġaich savaktai, aasiiñ anaumikł̣ugu atausiq, suli tuqqutlugu iḷaŋat, atlasuli miḷuqtuqługu uyaġaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tuyuqalgiññiqsuq atlanik savaktinik, iñugiatluktuanik sivulliġñiñ. Aglaan savvaġlulgiññiġaich taatnatun. ");
INSERT INTO eskNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aqulliqpiaŋuplugu tuyuġniqsuq iġñiġmiñik iliŋitñun uqaqhuni, ‘Taluġiniaġaat iġñiġa.’ ");
INSERT INTO eskNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aglaan nautchirriqirit qiñiqamitruŋ iġñiq uqaġniqsut iŋmiknun, ‘Tamarra paitchaktaaksralik, ki tuqullakput piññaktaaġiluguasii paitchaktaaksrautaa.’ ");
INSERT INTO eskNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tiguplugu aninniġaat asialiviŋmiñ tuqqutluguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Taatnamik, iñua asirrivium aggiġumi qanuġniaqpagich tamatkua nautchirriqirit?” ");
INSERT INTO eskNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kiuniġaat, “Taapkua iñukłuich naŋitillugich tuqunniaġai, aasiiñ atukkirrutigilugu asialivik atlanun nautchirriqirinun aatchuġumiñaqtuanun iŋmiñun asianik pivik tikitpan.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus-ŋum nipliutiniġai, “Agliqisimasuknaġiksi Agaayyutim uqałha, ‘Uyaġak tuppirit ayakkaŋat, taamna uyaġak piitchuiḷḷapiaġaqtuq tuppirauni. Taamna atanġum savaaġigaa suli quviqnaqtuaŋunasugigikput.’ ");
INSERT INTO eskNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Taatnamik uqautigipsi, Iñuginġiġisigai Agaayyutim aŋaayuqautaa, uvakŋaniñaglaan Agaayyun aŋalatchiñiaqtuq iñuŋnik tupiksriruanik pisułiġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aasiiñ kisupayaaq puukaqtuaq taavrumuŋa uyaġaŋmun siqumitauniaqtuq, aglaansuli taavruma uyaġaum kattaqitñikkumi iñuŋmik kanuġiñiaġaa.” ");
INSERT INTO eskNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Qaukłiŋich agaayuliqsit suli Pharisee-ŋuruat tusaakamisigik Jesus atrikusautiŋi iḷisimaniqsut Jesus-mun uqautigitilaaġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tigusukkaluaġniġaat, aglaan iqsiñiqsut iñugayaanik atakkii iñuich ukpiqhutiŋ Jesus sivuniksriqiraunipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Taimma uqaaqtuagaqsiḷgiññiqsuq atrikusautitigun uqaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Agaayyutim aŋaayuqautaa sagviqpan atriqaġisiruq umialiŋmik itqanaiyairuamik niġiqpagviksramik iġñi iḷaqatnigviksrautaani. ");
INSERT INTO eskNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tiliñiġai savaktini tuqłuġiaquplugich tamatkua aiyugaaqtauruat niġiqpagviksramun, aglaan aggiġuŋiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Umialik tiliritqiḷgiññiqsuq atlanik savaktimiñik uqaqhuni, ‘Uqautiyumagisi tamatkua aiyugaaqtauruat, Itqanaiŋanikkiga nullautchiġviksraġa. Tuqqutchianiktuŋa uqsraqsaŋitñik tuttuqpałuŋma nuġġaġmalu. Suapayaaq itqanaiqsuq. Aggiġusi niġiqpagiaġitchi katchuutiniaqtuaŋnun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tamatkua aiyugaaqtauruat suliqutigiŋiññiġaich aglaan aullałhiñaġniqsut, iḷaŋat savviaqhuni nautchiiviŋmiñun suli atla tauqsiġñiaġviŋmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iḷaŋisa tiguniqłuŋniġaich savaktit anaumikł̣ugich suli tuqqutqataqługich. ");
INSERT INTO eskNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Umialgum tusaakamiuŋ taamna uumitchaŋniqsuq. Tuyuġiniġai aŋuyyiuqtini tuqqutchaqtuaquplugich tamatkua iñuaqtuqtuat suli ikipkaġlugu nunaaqqiŋat. ");
INSERT INTO eskNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tavra nipliutiniġai savaktini, ‘Iḷaqatnigviksraun itqanaitkaluaqtuq aglaan taipkua aiyugaaqtaugaluaqtuat nalliummatiŋitchut. ");
INSERT INTO eskNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aullaġusi tumitchiat kaŋiġaluŋitñun aiyugaaqłiġiaġitchi kisupayaanik qiñikkapsitñik aggiqulugich katchuutiniaqtuak niġipkaiviksrautaaknun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Savaktit aullaġniqsut tumitchianun aasiiñ katitchiaqsipḷutiŋ iñuŋnik atisipḷugich nakuuruatlu pigiitchuatlu. Iḷaqatnigviksraunaasiiñ immiġñiqsuq paqitapayaaġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aglaan umialik isiqami qiñiġiaqługich tuyuġmiaksraqtaaŋuruat, qiñiġniġaa iñuk tavrani atnuġaaqtummaaŋitchuaq piqutigilugu iḷaqatniŋniaqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Umialgum nipliutiniġaa taamna iñuk, ‘Iḷauraamaaŋ, qanuqhutin isiqpich niġiqpagvianun atnuġaaqtusuŋaqnak nalaunŋaruanik?’ Taamna iñuk nipiksraiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Umialgum uqautiniġai savaktini, ‘Qiḷiqsigik argaiḷḷu isigaiḷḷu igillugu aasii taaġniqsrallapiamun. Tavrani itkisiruq qiałiq suli tiraalatchił̣iq kigutinik.’” ");
INSERT INTO eskNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tavrani Jesus niplipsaaġniqsuq, “Iñugiaktuat iñuich aiyugaakkaugaluaqtut, aglaan ikituurat piksraqtaaŋurut.” ");
INSERT INTO eskNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisee-ŋuruat sivunniugaqsiñiqsut pitchaġukługu Jesus uqałhigun. ");
INSERT INTO eskNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tuyuqaġniqsut maliġuaqtimiknik ilaanun, piqasiqł̣ugich Herod-kuaqtuanik uqaqhutiŋ, “Iḷisautrii, iḷisimarugut nalaunŋaruaŋutilaaqnik. Iḷisautrirutin Agaayyutim iñuuniaġvigitqukkaŋanik iḷumutuuruakun sugisuŋaqnagu qanuq iñuich isummatiqaqtilaaŋat, aasiiñ sugiŋitmigiñ iñuum suurautilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Uqautitigut sumik isummatilaaqnik taavrumuuna, Maliġutaksrakuaġnaqpa akiḷiiruni tax-sinik Caesar-mun naaga nalaunŋaitpa?” ");
INSERT INTO eskNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aglaan Jesus iḷisimaplugu sivunniuġutaat pigiiḷiqiłikun nipliġñiqsuq, “Ukpiŋŋuaqtisii! Suvaata uuktuaqpisitŋa? ");
INSERT INTO eskNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Qiñiqtillaksitŋa maniŋmik akiḷiqsuutauruamik tax-sinun!” Qaitchiñiqsut maniŋmik. ");
INSERT INTO eskNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus-ŋum apiqsruġniġai, “Kia-una agliutraŋa maniŋmi? Kiasuli aglaŋa?” ");
INSERT INTO eskNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kiuniġaat, “Caesar-m.” Aasiiñ Jesus-ŋum uqautiniġai, “Akiḷḷiutigilugu Caesar-mun Caesar-m pigikkaŋa, suli Agaayyutmun pigikkaŋa Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tusaakamitruŋ Jesus-ŋum uqaġikkaŋa quviġusuŋniqsut unitḷuguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Taavrumani uvlumi Sadducee-ŋuruat, tamatkua uqaġuuruat tuquruat aŋitqitḷaiññipḷugich, utlautiniqsut Jesus-mun apiqsruġukługu, ");
INSERT INTO eskNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Iḷisautrii, Moses-ŋum uqautigaatigut itnaqhuni, Aŋun iḷaqatiqaqtuaq tuqukpan qitunġigaluaqani, taavruma aŋutim aniqataan iḷaqatniktaaġiraksraġiniġaa uiḷgaġnaaq qitunġisiḷugu aŋutmik iḷisimanaġuniasiiñ tuquruam qitunġaġitilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Samma maani ittut tallimat malġuktun aniqatigiich akunnaptikni: aŋayukłiq nuliaqtuaq tuqupluni qitunġaitḷuni, unitḷugu nuliani aniqatmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tugliasuli aniqataa taatnatun tuqupluni piŋayuaglu, kiisaimma iluqatiŋ aniqatigiich tuquvut. ");
INSERT INTO eskNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aqulliupluniasiiñ aġnaq tuqupmiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Taapkua tallimat malġuuruat aŋutit nuliaqtuat iluqatiŋ taavrumiŋa aġnamik, nalliata nuliaġigisiñiqpauŋ taamna aŋitqigviŋmi?” ");
INSERT INTO eskNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus-ŋum kiuniġai, “Qanutun killukuaqtigivisi! Nalugisi Agaayyutim uqałhich ilaanlu saŋŋia. ");
INSERT INTO eskNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iñuich aŋitqigumiŋ tuqumiñ iḷaqatniktuġumiñaitchut naagaqaa iḷaqatniktitakkauyumiñaitchut. Aglaan itkisirut isaġuliktitun qiḷaŋmiittuatun. ");
INSERT INTO eskNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Agliqisimasuknaġiksi Agaayyutim uqauttutaa ilipsitñun aŋitqił̣ikun tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Agaayyutigigaatŋa Abraham-lu Isaac-ŋumlu Jacob-ŋumlu.’ Agaayyutigiŋitkaat tuquŋaruat aglaan iñuuruat.” ");
INSERT INTO eskNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iñugayaat tusaakamitruŋ Jesus-ŋum iḷisauttutaa quviġusuŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pharisee-ŋuruat katimaniqsut tusaakamiŋ Jesus-mun nipaiqsiñipḷugich Sadducee-ŋuruat. ");
INSERT INTO eskNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iḷaŋata iḷisautriŋuruam maliġutaksranik apiqsruġniġaa Jesus uuktuaġukługu, ");
INSERT INTO eskNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Iḷisautrii, nalliat tillisit kamanaġniqsrauva maliġutaksrani?” ");
INSERT INTO eskNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus-ŋum kiuniġaa, “‘Piqpagiyumagiñ ataniq agaayyutigikkan iluqaaniñ uummatipniñ, iluqaaniñ iñuutchipñiñ, suli iluqaaniñ isummatipniñ.’ ");
INSERT INTO eskNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Taamna tavra sivulliq suli kamanaġniqsraq tilliñ. ");
INSERT INTO eskNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Suli tuglia taatnatun itmiuq, ‘Piqpagilugu iñuuniaqatin iḷiḷugu iliptun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Maliġutaksrapayaaq suli sivuniksriqirit iḷisauttutigikkaŋich tunŋaviqaqtut taapkuŋnuŋa malġuŋnun tillisiŋñun.” ");
INSERT INTO eskNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee-ŋuruat katimapkaqługich Jesus-ŋum apiqsruġniġai, ");
INSERT INTO eskNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Qanuq isummatigivisiuŋ Christ, anniqsuqti akiqsruutauruaq? Kia kiŋuniaġivauŋ?” Kiuniġaat, “David-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus-ŋum nipliutiniġai, “Qanuqhunimi David-ŋum, uqaqhuni Irrutchikun, taiguutiqaġniqpauŋ ataniġmik? Atakkii uqaġniġuguuq, ");
INSERT INTO eskNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ataniq uqaqtuq Atanimnun: Aquvittin kamagitchiuviksrapnun uvaŋnun akiiḷiñiałhatnunaglaan uumigiritin.’ ");
INSERT INTO eskNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David-ŋum iŋmiñik taiguutiqaqpagu Ataniġmik, qanuġmi Anniqsuqti David-ŋum kiŋuviaġitlaniqpauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nalliataunniiñ Pharisee-ŋuruat kiulguiññiġaich Jesus-ŋum apiqsruutai. Tavrakŋaniñaglaan uvlumiñ kia-unniiñ apiqsruqtaġuŋaiġñiġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Taatnaanikman Jesus uqaġniqsuq iñugayaanun maliġuaqtimiñunlu, itnaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Aglaliqirit Pharisee-ŋuruatlu maliġutaksriuqtut Moses-tun iŋiḷġaanimma. ");
INSERT INTO eskNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Taatnamik tupigiraksraġigisi atuġlugiḷḷu supayaanik uqautikpasi tuvrasuŋaqnagich qanuq pisuutilaaŋat. Atakkii atuummitḷaitchaat sumik uqaqqaaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Natmiqsuiraqtut iñuŋnun uqumaiḷanik. Aasiisuli ikayuġummataitkaich akiyautisuglugich. ");
INSERT INTO eskNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Savaapayaaqtiŋ iñiqtaġiraġigaat qiñiqqusaałhiñaġutiŋ iñuŋnun. Agliḷaaqtaġniġaich puukataurat qauġmikniḷu taliġmikniḷu imaqaqtuat uqałiġnik suli atnuġaaġmiŋ niviŋalukkataŋich takłiḷaaqługich. ");
INSERT INTO eskNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iniqallatuniqsut qaukłiŋich aquppiutaŋitñik niġiqpakmata, suli Jew-ŋuruat katraġviŋitñi aquppiḷḷatuplutiŋ qaukłiuruam inaani, ");
INSERT INTO eskNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","suli tumitchiani paġlatqutuplutiŋ suli iñuŋnun tuqłiraqusuuplutiŋ iḷisautriñik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aglaan taiguutiqaġumiñaitchusi iḷisautriñik, atakkii atautchił̣hiñamik iḷisautriqaqhusi aasiiñ iluqasi aniqatigiiksusi. ");
INSERT INTO eskNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Taiguġniaqasiuŋsuli kiñapayaaq maani nunami aapapsitñik, atakkii atautchił̣hiñamik aapaqaqtusi qiḷaŋmiittuamik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naagaqaa taiguqasiuŋ kiñapayaaq sivulliuqtinik atakkii atautchił̣hiñamik sivulliuqtiqaqtusri, taamna Christ-ŋuruq, anniqsuqti akiqsruutauruaq. ");
INSERT INTO eskNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iñuk kamanaġniqsrauruaq akunnapsitñi savaktigiyumagiksi. ");
INSERT INTO eskNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Suli kiñapayaaq kamanaġasugiruaq iŋmiñik atchiksipkakkaugisiruq. Kiñapayaaq atchiksiruaq iŋmiñik kamanaqsipkakkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Kaŋiqsitḷaitkiksi Agaayyutim uqałha uqqiraqtaalu suli iḷisautriŋitḷugich. Atriqaqtusi iñuŋnik aŋmautiqaqtuanik Agaayyutim aŋaayuqautaanun aglaan aŋmaŋitḷugu. Isiŋitchusi sulipsuuq isiqtaiḷigisi tamatkua isiġniuraqtuat. ");
INSERT INTO eskNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Ivayaqtuipḷusi tupiŋitñik sulliñauraŋitñiglu uiḷgaġnaat, aasiiñ taimma qiñiqtinniagaqsipḷusi takiruamik agaayuplusi, taamna pisigilugu anasiñŋuqsaqsiułiksraqsi pigiitḷuŋniaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Kukiḷuktusi taġiukunlu nunakunlu atautchimikunniiñ maliġuaqtinigukhusi. Aasiiñ maliġuaqtiksraqtaaġianikapsiuŋ anasiñŋuqsaġviŋmutlasiraġigiksi pigiiḷitḷukługu ilipsitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nakłiuŋ, ayauŋaplusi sivulliuqtauruasii! Uqaqtusi, ‘Kiñapayaaq akiqsruqami agaayyuvikpakun taamna suuŋitchuq, aglaan kiñapayaaq akiqsruqami kaviqsaakun manikun agaayyuvikpakun, tavra akiqsruutiniktuq!’ ");
INSERT INTO eskNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ayauŋaplusi isumalguitchuasii! Nalliak ukuak pitḷuktuaŋuva—kaviqsaaq manik naaga agaayyuvikpak ipqiqsitchipkairuaq kaviqsaamik maniŋmik? ");
INSERT INTO eskNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Uqaqtusisuli kiña iñuk akiqsruqami tuniḷḷaqtuġvikun taamna suuŋitñipḷugu, aglaan akiqsruqami aatchuutauruakun tuniḷḷaqtuġviŋmi akiqsruutiniktuq. ");
INSERT INTO eskNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ayauŋaruasii! Nalliak ukuak pitḷuktuaŋuva aatchuun naaga tuniḷḷaqtuġvik ipqiqsitchipkairuaq aatchuutmik? ");
INSERT INTO eskNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taatnamik iñuum tuniḷḷaqtuġvikun akiqsruqami taputiraġigai aatchuutit tuniḷḷaqtuġviŋmiittuat. ");
INSERT INTO eskNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iñuk akiqsruqami agaayyuvikpakun, taputipmiraġigaa Agaayyun ittuaq tavrani. ");
INSERT INTO eskNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Iñuk pakivrumuuna akiqsruqtaqami taputipmiraġigaa Agaayyutim aquppiutaŋa taamnalu aquppiruaq tavrani. ");
INSERT INTO eskNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Qulikuraqtusi avuuġutipsitñik—mint, dill suli cummin-nik; aglaan minitlugich qulliupiaqtuat iḷisauttutit maliġutaksrani: nalaunŋaruałiq, nagliktaq suli ukpiqsrił̣iq—taapkua atuumaraksraġaluasi minitchiraġasuŋaqasiaglaan sivulliġñik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ayauŋaplusi sivulliuqtisii, milugiatchiat piiġñiaġaġigisi qallutipsitñiñ salummautituqługich, aglaan iiḷġataqtiġaġigiksi pikukturuaq natmaksiġvik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Salumapkairusi qaałhiñaŋitñik qallutipsi suli puggutapsi, aglaan iḷuŋich immaukkaqhutiŋ ivayaqtułiġmik suli killiqiłiġmik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pharisee-ŋuruasii, qanutun qiñitlaisigivisi! Salummaqqaaqsigik iḷuaŋnik qallutimlu puggutamlu, qaaŋigli salumayumauk. ");
INSERT INTO eskNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Ittusi qiñiyunaqtuatun iḷuvġich siḷataatitun, aglaan iḷuŋich immaukkaqhutiŋ tuquŋaruat iñuich sauniŋitñik suli qaayuġnapayaaqtuanik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taatnallapiaq qaałhiñapsigun sagviaqtuġaqtusi iñuŋnun nalaunŋaruatun iḷipḷusi, aglaan iḷupsitñi immaukkaqtusi ukpiŋŋuaġutinik pigiiḷiqiłiġniglu. ");
INSERT INTO eskNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nakłiuŋ, aglaliqirisiiḷu Pharisee-ŋuruasiiḷu, ukpiŋŋuaqtisii! Qiñiyunaqsaġisi iḷuviŋich sivuniksriqirit suli nalaunŋaruat iñuich. ");
INSERT INTO eskNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Uqaqtusisuli, ‘Iñuuniaqsimagupta iŋiḷġaan taimani aapaavut iñuuniaqmata, piqasiqsuutinayaitchugut iliŋitñi iñuaqtuqmata sivuniksriqirinik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Taatna uqaqapsi ilipsitñik iḷisimarauniqsusi kiŋuviaġitilaapsitñik tuqqutchiruanun sivuniksriqirinik. ");
INSERT INTO eskNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ki naatchiuŋ sivulliapsi aullaġniikkaŋat. ");
INSERT INTO eskNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ilipsi qitunġaŋich tuqunaqaqtuat nimiġiat! Qanuġlugu naŋaqniaqpisiuŋ anasiñŋuqsaġviŋmuktitauviksraqsi? ");
INSERT INTO eskNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Taatnamik tuyuġisiruŋa sivuniksriqirinik ilipsitñun puqiksaaniglu iñuŋnik aglaliqiriniglu—iḷaŋich tuqqutkisigisi, suli iḷaŋich kikiaktuutilugich, atlatsuli ipiġaqtuġlugich katraġvipsitñi suli qimaaratchiḷugich nunaaqqimiñ atlanun nunaaqqiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Taamna pisigiplugu anasiñŋuqsaqsiułiksraqsi tikiññiaqtuq ilipsitñun maqitchipkaił̣ł̣apsigun auŋatnik nalaunŋaruat iñuich mauŋa nunamun, aullaġniiḷugu iñuaqtułhaniñ Abel-ŋum iñuaqtułhanunaglaan Zechariah-m iġñiŋan Barachiah-m, iñuaqtapsi akunġakni agaayyuvikpaumlu tuniḷḷaqtuġviumlu. ");
INSERT INTO eskNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Uqautigipsi iḷumutuuruamik, iluqani tamanna anasiñŋuqsautiksraq tikiumagisiruq makunuŋa iñuŋnun pakmapak iñuuruanun. ");
INSERT INTO eskNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Annaatuk, Jerusalem-miusii! Tuqutchuuruasii sivuniksriqirinik miḷuqtuiruasiiḷu uyaġaŋnik tamatkuniŋa tuyuurauruanik ilipsitñun! Akulaiqł̣ugu katitchummiuġaluaġaġigitka iñugikkasi, atriḷugu aqargiqpak piyaqquqtaiḷitñiktuatun paiyaaġmiñik ataaknun isaqquŋmi. ");
INSERT INTO eskNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ataŋii, tupiqsi suksraakkaullapiaġniaqtuq suuŋiḷḷaġuġlugu. ");
INSERT INTO eskNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taatnaqłuŋa uqautigipsi, qiñitqikkumiñaitkipsitŋa nipliġñiałłapsitñunaglaan, ‘Uvvatuq Agaayyutim piḷiutigiliuŋ taamna tikitchuaq atqagun atanġum.’” ");
INSERT INTO eskNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus unitkaqsipmagu agaayyuvikpak maliġuaqtaiñ upyauġniġaat iniŋitñik agaayyuvikpaum. ");
INSERT INTO eskNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus-ŋum apiqsruġniġai, “Iluqaisa makua tupqich qiñiŋitpisigich? Uqautigipsi, Kisiŋŋuqtaqaġumiñaitchuqunniiñ uyaġaŋmik qalliani atlam ulġusimaitchuamik.” ");
INSERT INTO eskNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus aquppipkaqtitlugu iġġimi taggisiqaqtuamik Olives-mik maliġuaqtaiñ utlaŋniġaat kisipkuqhutiŋ apiqsruqługu, “Uqautitigut uumiŋa. Qakugun tamanna atuummiñiaqpa? Sukun iḷitchuqqutigun iḷitchuġigisivisa aggiyasiguvich suli nuna isukłiyasikpan?” ");
INSERT INTO eskNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus-ŋum kiuniġai, “Qaunatqiaġigitchi iñuiḷḷi kinniŋitchumagaasi. ");
INSERT INTO eskNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Atakkii iñugiaktuat iñuich aggiġisirut uqaġutiŋ, ‘Christ-ŋuruŋa,’ aasiiñ kinnitñigutiŋ iñugiaktuanik iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tusaagisirusi aŋuyaktuanik qanittuamiñ uŋasiksuamiñḷu. Iqsiñiaqasi atakkii iluqatiŋ tamatkua atuumaruksraurut aglaan isukłiñġitchuqsuli. ");
INSERT INTO eskNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nunaaqqich aŋuyyiuġisirut akiḷḷiġiiksillutiŋ avatmun suli atanġuviich akiḷḷiġiiksillutiŋ avatmun, niġisuksiuliqmiḷutiŋ, suli nuna aulapmiḷuni nanipayaaq nunani. ");
INSERT INTO eskNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iluqaitñik tamatkua aullaġniisaaġigai auliyautiłhum. ");
INSERT INTO eskNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Qaisaugisirusi nagliksaaqsiuviksrapsitñun, suli tuqqutaułiksrapsitñun, uumigitchiulusi nunaaqqipayaaniñ piqutigiluŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Taimaniġuqpan iñugiaktuat iñuich ukpiġutaiġñiaqtut, aatchuutigiraġautilutiŋ avatmun suli uumikkutilutiŋ avatmun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Iñugiaktuat sivuniksriqiriŋŋuaqtuat aggiġisipmiñiqsut kinnitñigutiŋ iñugiaktuanik iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Suli pisigilugu iñuich pigiiḷiqiłhat iñugiaksitmukhutiŋ piqpakkutaat niglaqsiñiaġaa. ");
INSERT INTO eskNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aglaan iñuk makitaruaq payaŋaiġuni isuanun anniqsukkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Quliaqtuaġigisigaat taamna tusaayugaallautaq Agaayyutim aŋaayuqautaagun, uqautigilugu nunaaqqipayaanun. Aquagun isukłitkisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Iñuk agliqiruaq ukuniŋa kaŋiqsiḷi. Qiñiġniaġiksi naġġunallapiaġataqtuaq qikaġlugu ipqitchuami inimi iniksraġiŋisamiñi, Daniel-ŋum Agaayyutim sivuniksriqiraa uqautigikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Taipkunani uvluni iñuuniaqtuat nunaŋani Judea-m qimakkumaut iġġiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iñuksuli itkumi tupiġmi qaaŋani atqaġniaqani aikł̣iġuni sumik tupiġmi iḷuaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kiñasuli iñuk nautchiiviŋmi itkumi utiġniaqani aikł̣iġuni quppiġaaġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Taipkua uvlut tikitpata, nakłiuŋ aġnat siŋaiyauniġumiŋ suli aakat miluktitchigumiŋ iḷiḷgauraġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Agaayutitchi qimałiksraqsi atuumatquŋiḷḷugu ukiumi naagaqaa minġuiqsiaġvium uvluani. ");
INSERT INTO eskNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Atakkii taivrumani nagliksaaqpaurałiksraq atuumagisiruq atrigiŋisaŋa atuumaruam aullaġniił̣haniñ nunam uvuŋanunaglaan. Taatnasiq nagliksaaqpaurałiq atuummitqiŋñiaŋitchuq taavruma aquagun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aasii Atanġum makua uvlut iḷaŋŋaqtaaŋisuaqpagich, kiña iñuk anniqsukkauyumiñaitchuq. Aglaan pisigiplugich piksraqtaani Agaayyutim taapkua uvlut iḷaŋŋaqtaaġisigai. ");
INSERT INTO eskNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Taimaniġuqpan kia iñuum uqautikpasi, ‘Qiñiqsiuŋ, uvva Christ,’ naagaqaa itnaqpasi, ‘Ikaniittuq,’ ukpiġiniaqasigik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Atakkii anniqsuqtiŋŋuat suli sivuniksriqiriŋŋuat iḷigisirut savaaqaġutiŋ kamanaqtuanik savaanik suli quviqnaqtuanik. Taapkunuuna kinniñiaġniġaich Agaayyutim piksraqtaaŋi pisaġiyumiñaġumisigik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ataŋii, uqautigipsi taavrumiŋa atuummigaluaqnagu. ");
INSERT INTO eskNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aasiiḷi kisupayaam uqautikpasi Christ iñuiḷaami inniḷugu tatpavuŋaqasi naagaqaa iriqsimaniḷugu uvani tupqum iḷuani ukpiġiniaqasiuŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Atakkii Iġñiŋa Iñuum aggiġisiruq atriḷugu ikniqpalaŋmun qaummaġiksipmatun qiḷak kivaknamiñ kanaknamun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sumipayaaqsuli tuquŋaruaq itpan, tavruŋa tiŋmiaqpaich tuquŋaraqtuġuuruat katisuurut. ");
INSERT INTO eskNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aquuraŋagunaasiiñ uvluiñ nagliksaaqsiułhum, siqiñiq taaqsigisiruq suli tatqiq qaumaġinġiġuni, uvluġiat katagaqmiḷutiŋ qiḷaŋmiñ suli qaummatipayaaŋi siḷam nuktitaulutiŋ inimikniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Taivrumani uvluni iḷitchuqqutaa Iġñiŋan Iñuum sagviġisiruq qiḷaŋmi. Iñupayaaŋa nunam qialuni qiñiġisigaat Iġñiŋa Iñuum aggiqsuaq nuviyakun qiḷaŋmiñ saŋŋimigun suli kamanallapiaqtuakun kamanautmigun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Qalġuqtautiqpaktuġlugich nipituruat tuyuġigisigai isaġuligikkani katitchityaqtillugich piksraqtaaġmiñik iñuŋnik nakitñapayaaq nunami. ");
INSERT INTO eskNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Iḷisaaqaġitchi fig napaaqtumiñ, itnaqhuni, akiġuiñ milukataŋich naugaqsipmata suli suŋaaqsipḷutiŋ qituglipmata iḷisimaraġigiksi upinġaam qallił̣ha. ");
INSERT INTO eskNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Taatnatuntuuq qiñiġupsigik tamatkua atuummiruat iḷisimaniaqmigiksi Iġñiŋa Iñuum qalliḷḷapiaqtilaaŋa qakma. ");
INSERT INTO eskNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iḷumun uqautigipsi, Iñuich iñuuniaqtuat pakma tuquaniŋniaŋitchut tamanna suapayaaq atuumaanikkaluaqnagu. ");
INSERT INTO eskNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iluqani nuna suli qiḷak piyaqqukkaugisiruk, aglaan uqałhich uqautigikkatka piiñġiġumiñaitchut. ");
INSERT INTO eskNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kia-unniiñ iñuum nalugaa uvluq naagaqaa sassaq sumi tikisilaaksraŋa. Isaġulgich qiḷaŋmiittuat unniikii iġñiġuruam nalugaat. Kisimi aapam iḷisimagaa. ");
INSERT INTO eskNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Iġñiŋa Iñuum aggiqpan taimanisun itkisiruq atriḷugich iñuich iñuuniaqmatun uvluiñi Noah-m. ");
INSERT INTO eskNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Atakkii taipkunani uvluni sivuani uliqpałhum iñuich niġimaaqtut imiqsimaaqhutiŋlu, iḷaqatniktuqhutiŋ suli qitunġatiŋ iḷaqatniktuqtitlugich Noah-m isiġniałhanunaglaan umiamun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iñuich iḷitchuġiŋiññiqsut atuumaniaqtuamik uliqpaŋmun pisaġilġataqtitlutiŋ. Taatnatun itkisipmiuq Iġñiŋa Iñuum aggiqpan. ");
INSERT INTO eskNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Malġuk aŋutik savaktuak nautchiiviŋmi, iḷaqataa tigurauliġisiruq aasiiñ iḷaqataa uniktauliġuni. ");
INSERT INTO eskNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Malġuk aġnak mukkaaksriuqtuak mukkaaksriuġviŋmi, iḷaqataa tigurauliġisiruq aasiiñ iḷaqataa uniktauliġuni. ");
INSERT INTO eskNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Taatnaġusi ataramik itqanaitchuksraurusi, atakkii nalugiksi sumi uvlumi atannapsi aggiġñiaqtilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aglaan iḷisimayumagiksi una, tupqum iñuan iḷisimayumiuŋ napmun iḷikpan unnuaq tigliŋniaqtim aggiġñiaqtilaaŋa qaunaginayaqtuq tigliŋniaqti siqumġutitquŋiḷḷugu tupiġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Taatnatuntuuq itqanaitchuksraupmiusi atakkii Iġñiŋa Iñuum aggiġñiaqtuq sassaġniġmi niġiugvigiŋisapsitñi. ");
INSERT INTO eskNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kiña tuniqsimaruaŋupluni isumatupluniḷu savaktauva? Ilaaŋuruq aŋaayuqam qaukłiḷiutikkaŋa atlanun savaktimiñun tupiġmiñi ittuanun niqiksritñiktaqtuamun piviksraq nallaullapiaqługu. ");
INSERT INTO eskNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Qanutun quviasuktigigisiva taamna savakti aŋaayuqam utiġumi paqitaŋa savaaġiglugu. ");
INSERT INTO eskNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iḷumun uqautigipsi, atanġum piksraqtaaġigisigaa taamna savakti qaunaksritqulugu iluqaitñik suuraġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aglaan qanuq savaktauniqpan pigiitḷuni? Isumapiaġniqsuq iŋmiñun, ‘Aŋaayuqaġa maunauraq utiġniaŋitchuq,’ ");
INSERT INTO eskNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aasiiñ anaumiaqsiḷugich atlat savaqatini suli niġiqatigiplugiḷḷu imiqatigiplugiḷḷu imiqtuqtit. ");
INSERT INTO eskNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aŋaayuqaŋa taavruma savaktim utiġniaqtuq iḷaŋatigun uvlut niġiugiŋisillugu ilaanik sassaġniġmiḷu qaunagiŋisillugu. ");
INSERT INTO eskNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Atanġata aggiġumi tatapsallapiaġisigaa piqasiutipkaġlugulu ukpiŋŋuaqtinun. Tavrani iñuich qiagisirut tiriquulatchiḷugiḷḷu kiggutitiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Agaayyutim aŋaayuqautaa sagviqpan itkisiruq qulitun aŋutituqsimaitchuatun tigummiaqaqtuanik nanniuramiknik paaġiaqługu iḷaqatniŋniaqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tallimat taapkunani isumaturuaŋuniqsut, suli tallimat isumatuitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Taapkua isumatuitchuat saagaġmiñiġaich nanniuratiŋ, aglaan uqsritqiutiksraŋitñik saaganġiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Isumaturuataasiiñ uqsritqiutiksraligaaġniqsut nanniuramiknun. ");
INSERT INTO eskNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iḷaqatniŋniaqtuaq tuuliuŋapkaqługu taapkua iluqatiŋ siñiŋnialiqamiŋ siñiksaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tavra unnuaq qitiqquqman iñuk nipliqsuq, ‘Marra, iḷaqatniŋniaqtuaq aggiqsuq. Aniḷusi paaġiaqsiuŋ.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Iluqatiŋ aŋutituqsimaitchuat makitnamiŋ ikummaktaaġniġaich nanniuratiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Isumatuitchuat uqautiniġaich isumaturuat, ‘Qaitchisigut iḷaŋanik uqsrupsi atakkii nanniuravut qamiaqsiñiqsut.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aglaan isumaturuat kiuniġaich, ‘Naaga, naamayumiñaitpaluŋmiugut uvaptiknunlu ilipsitñunlu pigupta, aglaan aullaġusi taipkunuŋa tunisiullaqtuanun uqsrunik tauqsiġiaġitchi piksrapsitñik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tavrali isumatuitchuat aullaġniqsut, aasiiñ tauqsiġiaqtitlugich iḷaqatniŋniaqtuaq aggiġñiqsuq. Taapkua itqanaitchuat isiqatigigaat katchuutiviŋmun niġiqpagiaqhutiŋ, tavraasiiñ taluplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aquvatigunli aggiqmiñiqsut alġiaŋich niviaqsiat. Uqaaqsigaluaqtut, ‘Ataniiq, aŋmautillaŋniaqtigut.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aglaan kiuniġai, ‘Naluniġipsi. Kisuuvisi?’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Taatnaġusi qaunatqiaġigitchi. Atakkii nalugiksi uvluq unniiñ sassaġniq Iġñiŋa Iñuum aggił̣iksraŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Suliuvva Agaayyutim aŋaayuqautaa sagviqpan atriqaqtuq aŋutmik iglausuktuamik uŋasiksuamun nunamun. Iŋmiñuquplugich savaktigikkani qaunaksriḷiutiniġai suuraġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Atausiq iñuk qaitchiñiġaa 5,000-tun maniŋñik, atla iñuk 2,000-tun, atlasuli 1,000-tun, iñullaa akuqtuipḷuni pitḷakkaġmigun. Aasiiñ aullaġniqsuq iglauviksraġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Taamna iñuk akuqtuiruaq 5,000-tun maniŋñik aullaqhuni piñatchiasuŋaqani tauqsiġñiutiginiġai maniksriusriani, aasiiñ piññautigiplugich 5,000-sipsaanik. ");
INSERT INTO eskNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Taatnatunsuli taamna iñuk akuqtuiruaq 2,000-tun piññapsaaqmiuq atlanik 2,000-nik. ");
INSERT INTO eskNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aglaali iñuk akuqtuiruaq 1,000-tun aullaqhuni paksrautiplugu nunamun iriġniġaa aŋaayuqaġmi maniŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Akuni piiḷġataġaluaqami aŋaayuqaŋat taapkua savaktit utiġniqsuq, aasiiñ makpiġarriqutiaqsipḷugich maniksriusriaŋatigun. ");
INSERT INTO eskNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tavra taamna iñuk akuqtuiruaq 5,000-tun tikiutriruq atlamik 5,000-naktaaġmiñik uqaqhuni, ‘Ataniiq, qaitchikapŋa 5,000-tun maniŋñik, uvva piññapsaaqtuŋa 5,000-nik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aŋaayuqaŋan taavruma uqautigaa, ‘Savaaqallautaġniqsutin, nakuuplutin tuniqsimaruaŋuniqsutin savakti! Tuniqsimmatriñiqsutin iñugiakitchaluaqtuatigun suuratigun; inillaŋniaġikpiñ aŋalatiġuġutin iñugiaktuanun suuranun. Quviasuqatautyaġiñ aŋaayuqaġikkapni.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Taamnaptuuq iñuk akuqtuiruaq 2,000-tun maniŋñik aggiqhuni uqaġmiuq, ‘Ataniiq, qaitchikapŋa 2,000-tun maniŋñik, uvva piññapsaaqtuŋa 2,000-nik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Aŋaayuqaŋantuuq uqautipmigaa, ‘Savaaqallautaġniqsutin, nakuuplutin tuniqsimaruaŋuniqsutin savakti. Tuniqsimmatriñiqsutin iñugiakitchaluaqtuatigun suuratigun. Inillakkisigikpiñ iñugiaktuanun suuranun. Quviasuqatautyaġiñ aŋaayuqaġikkapni.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tavrali iñuk akuqtuiruaq 1,000-tun maniŋñik aggiqhuni uqaqtuq, ‘Ataniiq, iḷisimagikpiñ. Anayaktuaqtauŋunġitchutin aŋun. Pukuiraqtutin nautchiivigiñġisapniñ katitchisuuplutinlu kanġaqsruiviginġisaqniñ nautchiaksranik. ");
INSERT INTO eskNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sivuuġapluŋa taatnaqłuŋa iriġitka maniksin nunamun. Uvva, pisin pigigitin.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aŋaayuqaŋan uqautigaa, ‘Pigiitchuatin iqiasruuplutinlu savaktii! Iḷisimagaluaqtutin kiprisuutilaamnik nautchiiġviginġisamniñ katitchipḷuŋalu kanġaqsruiviginġisamniñ nautchiaksranik. ");
INSERT INTO eskNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iḷiñayaġniġitin manitka manniqiriñun, aasiiñ utiġuma akuqtuitḷanayaqtuŋa pimñik naggutiŋitñik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aasiiñ uqautiniġai atlat savaktit, ‘Pisigiŋ taapkua maniich ilaaniñ qaityaġiaġlugichaasii taavrumuŋa 10,000-tun maniqaqtuamun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tavraasiiñ kiñapayaaq aŋalatchiḷḷautaqtuaq aatchuusriaġmiñik piññapsaaġisiruq sippakuuqtualiġuni. Aglaan taamna piññanġitchuaq, mikiruamikunniiñ piginasugikkaġmiñik piikkaugisiruq ilaaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Siŋitchiuŋ piññaŋniuranġitchuaq savakti taaqtuam taaġniqsraŋanun. Tavrani qiagisirut tiriquullaisa kiggutitiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Iġñiŋa Iñuum aggitqikpan kamanaqtuakun qaumamigun iluqaisa ipqitchuat isaġuligikkani piqatigilugich, aquvinniaqtuq aquppiutaqpaŋmiñun kamanaqtuamun. ");
INSERT INTO eskNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aasiiñ iñupayauraŋi nunam katitaugisirut sivuġaanun. Tavrani aviktuġisigai atausiuttaaġlugich, atriḷugu munaqsri aviktuipmatun ipnaiñik tuttułuuraniñ. ");
INSERT INTO eskNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Suli inillakkisigai ipnaich taliqpiŋmi tuŋaanun, aglaali tuttułuurat saumium tuŋaanun. ");
INSERT INTO eskNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Umialgum uqautigisigai taliqpiŋmiñi ittuat, ‘Mauŋaġitchi, aatchuusriaqaqtuasii piḷiusiamik Aapamniñ, paitchaktaaġisiuŋ Agaayyutim aŋaayuqautaa itqanaiyaaŋuruaq ilipsitñun iñiqtaułhaniñaglaan nunam. ");
INSERT INTO eskNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Atakkii niġisuktauqama niqiksritchaġigikma. Imiġukamalu imiksritchaġigikma. Iglaaŋukama aiyugaaqłuŋa isiqtitaġigikma. ");
INSERT INTO eskNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Atnuġaaŋitñama atraksritchaġigikma atnuġaamik. Atniġñaqama takuraġigikma. Isiqtaukama tikitḷuŋa isiqattaaġaġigikma.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tavrali iñuich nalaunŋaruat kiuniaġaat, ‘Ataniiq, qaŋaaglaan qiñiqpisigiñ niġisukavich aasiiñ niġipkaqhutin naagaqaa imiġukavich imiqtitaġivisigiñ? ");
INSERT INTO eskNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Qaŋasuli qiñiqpisigiñ iglaaŋuplutin aasiiñ isiqtitlutin naagaqaa atnuġaaŋitñavich atnuġaaqtitpisigiñ? ");
INSERT INTO eskNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Suli qaŋaaglaan qiñiqpisigiñ atniġñaqhutin naagaqaa isiqsiviŋmiitnavich takuniqpisigiñ?’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Umialgum kiugisigai tamatkua itnaġlugich, ‘Iḷumun uqautigipsi. Qanutunaglaan savautrikapsi nagliŋnaqniqsraŋatnun aniqatiuma savaaġigiksi uvaŋnun.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aasiiḷi uqautiniaqmigai tamatkua saumium tuŋaani, ‘Piiġitchi uvaŋniñ! Anasiñŋuqsakkauniaqtusi isuitchuami ikniġmi itqanaiyaaŋuruamun tuunġaġmun isaġuliŋiñunlu. ");
INSERT INTO eskNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Atakkii niġisukama niqiksritḷaitchipsitŋa. Imiġuliqama imiksritḷaitchipsitŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iglaaŋukama aiyugaatlaitchipsitŋa. Atnuġaitñama atnuġaaqtitlaitchipsitŋa. Atniġñaqamalu isiqsiviŋmiitnamalu isiqattaatlaitchipsitŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tavraptuuq kiuniaġaat itnaġutiŋ, ‘Ataniiq, qaŋaaglaan qiñiqpisigiñ niġisukavich imiġukaviḷḷu naagaqaa iglaaŋukavich atnuġaitñaviḷḷu, naagaunniiñ atniġñaqavich isiqtaukaviḷḷu aasiiñ savautinġitḷutin?’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aasiiñ kiuniaġai, ‘Uqautigipsi, qanusipayaamik savautrisunġitñapsi atautchimununniiñ nagliŋnaqniqsraqtuamun savautriñġitchusi uvaŋnik.’ ");
INSERT INTO eskNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tamatkuali aullaqtitkisigai isuitchuamun anasiñŋuqsaqsiuviŋmun, aglaali nalaunŋaruat isuitchuamun iñuułiġmun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus uqaġuiqami tamatkuniŋa, uqautigai maliġuaqtini, ");
INSERT INTO eskNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Iḷisimarusi, malġuk uvluk aquagun atuumagisiruq Jew-ŋuruat niġiqpagvikaaŋat atilik Apqusaakkaułiġmik, aasiiñ Iġñiŋa Iñuum aatchuutigikkauniaqtuq kikiaktuutraksrauluni.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Qaukłiŋich agaayuliqsit suli aglaliqirit suli sivulliuqtiġruat katinniqsut igluqpaŋanun qaukłiat agaayuliqsit atilgum Caiaphas-mik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sivunniugaqsiñiqsut tigusraġukługu Jesus nalunautchiḷutiŋ tuqulluguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aglaan uqaġniqsut, “Niġiqpagvikaam uvluani taatnaġnianġitchikput. Iñuich aŋalanniqłuktaiviaqtut.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Uvvaasriiñ Jesus Bethany-miititlugu tupqani Simon-ŋum auyugaqtualgum ");
INSERT INTO eskNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","tikiññiġaa aġnam saagaqhuni nakasruŋŋuaŋuramik tipraġiksautmik akisuruamik nanuutiksramik, aasiiñ kuvipḷugu Jesus-ŋum niaquanun niġiñiaqtitlugu. ");
INSERT INTO eskNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Maliġuaqtaiñ qiñiqamitruŋ iłuagiŋiññiġaat nipliqhutiŋ avatmun, “Supman asiñun tipraġiksaun atuqpauŋ? ");
INSERT INTO eskNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Una tipraġiksaun tunikpan atqunautaunayaqtuq qaisauluniasiiñ nagliŋnaqtuanun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus-ŋum iḷitchuġiplugu nipliutigikkaŋat uqautiniġai, “Suvaata una isumaaluksaaqpisiuŋ aġnaq? Savautigaaŋa savaallautamik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nagliŋnaqtuat nayuqtigigisi ataramik, aglaan nayuqtiginianġitchipsitŋa ataramik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Uvvauna aġnam kuvikamiuŋ tipraġiksaun timimnun itqanaiyautigaa iḷuvikkaułiksraġa. ");
INSERT INTO eskNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iḷumun uqautigipsi, nanipayaaq tusaayugaallautaq quliaqtuaŋukpan nunapayaani, taavrumaptuuq aġnam savaaŋa uqautaugisipmiuq itqakkutauluni ilaanun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Taimmali iḷaŋata qulit malġuk maliġuaqtit, atiqaqtuaq Judas Iscariot-mik, utlautiniqsuq qaukłiŋitñun agaayuliqsit ");
INSERT INTO eskNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","uqautiplugich, “Sumik qaitchiñiaqpisitŋa Jesus aatchuutigigupku ilipsitñun?” Akiḷiññiġaat iñuiññaq qulitun maniŋñik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tavrakŋaniñaglaan Judas qaunaksruaqsiruq piviksramik aatchuutigisrukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sivulliqpiami uvluani niġiqpagvikaam puvlaksiġniġiḷaanik qaqqunik maliġuaqtit tikiññiġaat Jesus uqautipluguasiiñ, “Nani itqanaiyaquvisigut niġiqpałiksrapnik atiliŋmik Apqusaakkaułiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kiuniġai, “Nunaaqqimugitchi aŋutmun iḷisimakkamnun uqautilugu, ‘Iḷisautri uqaqtuq, piviksraġa qalliuraqtuq. Niġiqpagvia atilik Apqusaakkaułiġmik niġġivigisukkiga tupipni piqatigilugich maliġuaqtitka.’” ");
INSERT INTO eskNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Maliġuaqtit piñiqsut Jesus-ŋum piraksrirrutaatun iliŋitñun, aasiiñ itqanaiyaqhutiŋ niġiqpagviksramun atiliŋmun Apqusaakkaułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Unnuksraaqman Jesus aquvinniqsuq niġisukhuni piqatigiplugich qulit malġuk maliġuaqtini. ");
INSERT INTO eskNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Niġiñiallaġmiŋ Jesus-ŋum uqautigai, “Uqautigipsi, iḷapsisamma aatchuutiginiaġaaŋa uumiksriñun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iluqatiŋ isumaalutchallapiaġataqtut. Atausiuttaaqhutiŋ apiqsrullaagaqsigaat, “Ataniiq, uvaŋaunġitchuq, amii?” ");
INSERT INTO eskNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Uqautigai, “Ilaaŋuruq misuqatauruaq argaŋmiñik uvapkun puggutauramun. Taavruma aatchuutiginiaġaaŋa uumiksriñun. ");
INSERT INTO eskNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iġñiŋa Iñuum aullaġisiruq uqałhum aglaksimałhatun pisigiplugu ilaa, aglaan qanutun tatamnaqtigigisiva taamna aŋun Iġñiŋanik Iñuum aatchuutigitniktuaq uumiksriñun. Nakuutlukkayaqtuq taamna iñuk taimani aniñġiññiġumi.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tavrali Judas-ŋum aatchuutigitniktuaŋan apiqsruġniġaa, “Iḷisautrii, uvaŋaunġitchuq, amii?” Jesus-ŋum uqautiniġaa, “Ii, ilviuruq.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Niġiḷḷaġmiŋ Jesus-ŋum tigugaa qaqqiaq quyaplugu Agaayyun siqumitkaa qaitḷuguasiiñ maliġuaqtimiñun uqaqhuni, “Tigulugu niġġisiuŋ, tavrataamna timiga.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tigupluguasiiñ qallun quyaanikami qaitkaa iliŋitñun uqaqhuni, “Imiġvigisiuŋ! ");
INSERT INTO eskNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Taamna auga maqipkakkauruaq iñugiaktuanun aullaġniiruq nutaamik sivunniuġutmik Agaayyutmiḷu iñuŋniḷu. Taavrumuuna aukun Agaayyutim nalupqinaiġñiaġaa sivunniuġutni iñuŋnun natqigutiksraupluni killuqsautiŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Imitqiŋñianġitchuŋa taavruma asiam misuġuaniñ uvakŋaniñaglaan tikiḷġataqtillugu taimña uvluq imitqikkuma piqatigilusi Aapaa aŋaayuqautaani.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Atuanikamiŋ atuutmik aullaqtut iġġimun taggisiqaqtuamun Olives-mik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pisullaġmiŋ Jesus-ŋum uqautiniġai maliġuaqtini, “Iluqasi uniññiaġipsitŋa uumani unnuami. Atakkii aglausimaruq uqałiġni itna, ‘Tuqutkisigiga munaqsri, aasiiñ ipnaich siamillapiaġutiŋ.’ ");
INSERT INTO eskNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aglaan aŋipkakkauŋanikkuma tuqułiġmiñ, aullaġisiruŋa sivupsitñi Galilee-mun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter-m uqautigaa Jesus, “Iluqatiŋ atlat suksraaġaluaqpatin sumiunniiñ taatnaġumiñaitchikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus-ŋum uqautigaa Peter, “Uqautigikpiñ, anaqavak piiḷaaġutiginiaġikma piŋasuniaglaan aqargiqpak qalġuqtaġaluaqnagu.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter-m uqautigaa, “Tuquqatigiraksraġigupkiñunniiñ piiḷaaġiyumiñaipiaġikpiñ.” Taatnatuntuuq uqaqtaġmiut iluqatiŋ maliġuaqtit. ");
INSERT INTO eskNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesus-ŋum aullautigai maliġuaqtini inimun atiliŋmun Gethsemane-mik uqautiplugich, “Aquppiuraallagitchi uvani, agaayutyaqtuaqtilluŋa iñuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aullautiplugich Peter malġuglu iġñaŋik Zebedee-m alianniuliqsuq iłuiḷḷiuliḷḷapiaqhuniḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Uqautigai, “Arrii, uvva uqumaiḷḷiullapiaġniqsuŋa. Alianam pisaġiłhiñaaġuqtaġaaŋa. Tavraniittuallagitchi qaunaksruqasiḷḷagluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Taiñuŋaqtaallakhuni pullapiaqługu kiiñani agaayuruq, “Aapaaŋ, pisułiġigupku piiġuŋ qallutaa nagliksaałhum uvaŋniñ. Uvaŋa pisułiġiŋiḷḷaaptun aglaan ilvich pisułiptun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesus utiqami maliġuaqtimiñun paqinniġai siñiktuat. Apiqsruġniġaa Peter, “Qaunagiuraallakkumiñaitpisitŋa atautchimiunniiñ sassaġniġmi? ");
INSERT INTO eskNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Siñiŋniasuŋaqasi agaayulusiḷu. Ukpiqsrisaiŋitchumausiḷi uuktuaqsiugupsi. Iḷumun irrusiq piyummatiqaġaluaqtuq aglaan timi sayaitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus aullatqiḷgitchuq iḷaqataani agaayupluni uqaqhuni, “Aapaaŋ, una qallugauraq piiġumiñaitpan uvaŋniñ imiqtaksraġipiaġupku piḷagu pisułiġikkan.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Utilgitñami paqilgitchai siñiktuat atakkii iriŋich siqupsaġuliḷḷapiaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uvvaasiiñ aullalgitchuq agaayutyaqhuni piŋatchiqł̣ugich, uqaqhuni taapkuniŋasuli uqautigikkaġmiñik sivuani. ");
INSERT INTO eskNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jesus utiqami maliġuaqtimiñun uqautigai, “Siñiktuaqpisisuli iñiqtuiqsiaqhusi? Uvva, sassaq tikitchuq aatchuutigikkauviksraŋa Iġñiŋan Iñuum argaŋitñun killuliqirit. ");
INSERT INTO eskNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Makillusi aullaqta! Aatchuutigitniktuaġa imma tikitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus uqaġugaaqtitlugu Judas aggiġñiqsuq, iḷaŋat qulit malġuk maliġuaqtit. Piqatiqaġniqsuq iñugiallapiaqtuanik iñuŋnik savikpiraqtuanik anautchiraqtuaniglu, tuyuumaruanik qaukłiŋitñiñ agaayuliqsit sivulliuqtiġruaŋitñiñḷu. ");
INSERT INTO eskNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Taavruma aatchuutigitniktuam piqatini iḷitchuqqutiksriññiġai uqaqhuni, “Kiñataimma kunikkupku tavra taamnaugisiruq. Tiguyumagiksi.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Taavrumatavra naliŋiñaaqługu utlakkaa Jesus paġlaplugu, “Paġlagikpiñ, iḷisautrii!” aasiiñ kunikł̣ugu. ");
INSERT INTO eskNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus-ŋum kiuniġaa, “Iḷauraamaaŋ, tavra taatnaġiaġuguutinkii.” Tamatkua iñuich tiguniqłukługu Jesus tigugaat. ");
INSERT INTO eskNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tavrali iḷaŋata taapkua piqatiŋiñ Jesus-ŋum amuniġaa savikpani uugiraqtiqługuasii savaktiŋa qaukłiata agaayuliqsit. Uugiraqamiuŋ tavra siutaiqsiġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tavrani Jesus-ŋum uqautigaa taamna, “Utiqtirruŋ savikpaiñ puuŋanun atakkii iluqatiŋ aŋuyaktuat savikpakun piyaqquġisirut savikpakun. ");
INSERT INTO eskNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Isumaŋitpich iŋiqsruġupku Aapaga ikayuqtaiḷiqiluŋa, akkuvaurapiaq tuyuġayaġaaŋa qulit malġuktun kavluutinik isaġuliŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Taatnaġupku qanuġuni Agaayyutim uqałha immiumagisiva uqaġiruaq taatna ittuksraupluni?” ");
INSERT INTO eskNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Taavrumani Jesus-ŋum uqautigai iñugiallapiaqtuat iñuich, “Savvaqłuktauvik, atakkii aggiqhusi tigutyaqłuŋa savikpaŋnik anautaniglu. Uvluġaġipman aquppigaluaġaqtuŋa piqatigiplusi agaayyuvikpaŋmi iḷisautripḷuŋa, aglaan tigusratlaitchipsitŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aglaan iluqatiŋ tamatkua atuumarut atakkii Agaayyutim uqałhich uqaġikkaŋich sivuniksriqirit immiumaruksraupmata.” Tavrali iluqatiŋ maliġuaqtit unitchaat pigruqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Taapkua tiguriruat Jesus-mik aullautiniġaat Caiaphas-mun qaukłiat agaayuliqsit katimmavigikkaŋatnun aglaliqirit sivulliuqtiġruatlu. ");
INSERT INTO eskNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aasiiñ Peter-m maliŋniġaa uŋasiuraaqhuni qaukłiata agaayuliqsit igluqpaŋan siḷataanunaglaa. Isiqhuni aquppiqatauniqsuq qaunaksrini qiñiġukługu qanuġisitilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Qaukłiŋich agaayuliqsit suli iluqatiŋ uqaqsittaaqtitchirit pakaaqaġniqsut taŋiġiḷaanik iḷisimarauruanik sagluutigilugu Jesus tuqqutchukługu. ");
INSERT INTO eskNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aglaan paqitchiŋiññiqsut sumikunniiñ, iñugiakkaluaqhutiŋ tikiaruat taŋiġiḷaakun iḷisimarauniaqtuat. Naagatai paqitchiŋitchut. Kiisaimmalu malġuk taŋiġiḷaakun iḷisimarauruak saavitpuk ");
INSERT INTO eskNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","uqaqhutik, “Uvvauna iñuk uqaqtuaq, ‘Piyaqqułhiñaugiga agaayyuvikpaŋa Agaayyutim aasiiñ nappatqigḷugu piŋasuni uvluni.’” ");
INSERT INTO eskNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Uvvaasiiñ qaukłiata agaayuliqsit makitluni uqautigaa Jesus, “Kiggutiksraitpich sumik ukuak iññuk uqautaakkun ilipkun?” ");
INSERT INTO eskNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aglaan Jesus nipaisaaqtuq. Qaukłiata agaayuliqsit uqautiniġaa Jesus, “Itqaġuŋ una, Pakma nayuutirugut sivuġaani iñuuruam Agaayyutim. Taatnamik uqautitigut, Christ-ŋuvich, Iġñiŋa Agaayyutim?” ");
INSERT INTO eskNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus-ŋum kiuniġaa, “Uvva ilvich uqaaniktutin taatna. Aglaan uqautigipsi, qakugun taimma qiñiġisigiksi Iġñiŋa Iñuum aquppiruaq taliqpian tuŋaani saŋŋipayaaqaqtuam, aggiġuni nuviyatigun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tavrani qaukłiata agaayuliqsit aligaaġniġai atnuġaani uqaqhuni, “Iŋmiñik uqaġniqłuktaġniqsuq! Suvaatami piqaġupsaaqpisa iḷisimarinik? Pakma tusaagisi uqaġniqłuutai. ");
INSERT INTO eskNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Qanuq isumavisi?” Kiuniġaat, “Tuquruksraġuqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aasiiñ tivvuaqtuaqsiñiġaat kiiñaŋagun qakiqtaqsimmaan pattakługu argaŋmiknik. ");
INSERT INTO eskNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Uqaġniqsut, “Christ-ŋuruatiin! Nalautchaġutin uqautitigut, kia qakiqpatin?” ");
INSERT INTO eskNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Taatnałhatni Peter aquppiñiqsuq siḷataani igluqpaum. Niviaqsiġaam tikitḷugu nipliutiniġaa, “Ilvichtuuq piqatigipmikkan Jesus Galilee-ġmiu.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aglaan Peter piiḷaaqtuq iluqaŋisa takkuatni uqaqhuni, “Naluruŋa sumik uqautiqaqtilaapnik.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aasiiñ anipman qanitchaġruamun, atlam qiñiqługu uqautiniġai tamatkua tavraniittuat, “Uvvauna iñuk piqatauruaq Jesus-mi Nazareth-miumi.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tavrani Peter piiḷaatqiksuq suamasipḷugu, “Nalugiga taamna aŋun.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Suli akkunilitchiallakługu qikaqtuat tamaani utlakkaat uqautilgitḷugu Peter, “Iḷumun iḷagigaatin taapkua, atakkii uqausipkun iḷisimanaqtutin.” ");
INSERT INTO eskNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tavra Peter suviagaqsiñiqsuq itnaqhuni, “Agaayyutim anasiñŋuqsaġliŋa uqanġiññiġuma iḷumutuuruamik. Nalugiga kisuutilaaŋa taavruma aŋutim.” Uqaqtitlugu tavrakŋatchiaq aqargiqpak qalġuqtaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peter-m itqaqtiġai uqautai Jesus-ŋum iŋmiñun itna, “Aqargiqpak qalġuqtaġaluaqnagu piiḷaaġutiginiaġikma piŋasuniaglaan.” Tavra anipḷuni qianiqsuq iłuiḷḷiullapiaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Uvlaatchaurami qaukłiŋich agaayuliqsit suli sivulliuqtiġruaŋich Jew-ŋuruat sivunniġñiqsut tuqqutchukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Qiḷiqługu aullautiniġaat Pilate-mun kavanauruamun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tavrali Judas, Jesus-ŋum aatchuutigiriŋa, iḷitchuġikami Jesus-ŋum tuqqutaksraġuqtilaaŋanik nunuuratchallapiaġniqsuq utiqtitlugich taapkua iñuiññaq qulit maniurat qaukłiŋitñun agaayuliqsitlu sivulliuqtiġruaŋitñunlu Jew-ŋuruat ");
INSERT INTO eskNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nipliqhuni, “Killuqsaqtuŋa atakkii aatchuutigitnikłuŋa patchisaiḷaamik iñuŋmik.” Kiuniġaat, “Suutauniaqpami taamna uvaptiknun? Tavra savaaġigiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas-ŋum miḷuqsautiniġai maniich agaayyuvikpaŋmun. Aullaqami qimiññiqsuq iŋmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Qaukłiŋich agaayuliqsit tiguplugich taapkua maniich nipliġñiqsut, “Maliġutaksrakuaġnanġitchuq tugvaigupta maniŋmik iḷirakuvianun agaayyuvikpaum, atakkii taamna manik akigigaa tuqqutauruam.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Sivunniġñiqsut tauqsiutigisukługu utkutchirim nunaŋanik iḷuviqaġvigisukługu iglaaŋuruanun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Taatnaqługu taamna nuna taiguutiqaġaat nunaŋanik augum ugluvaŋnunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Taamna immiumaniqsuq uqauttutauruaq tumigiplugu Jeremiah sivuniksriqiri uqautigikkaŋa, “Tiguniġaich iñuiññaq qulit maniich. (Taapkua maniich iñugiaktilaaŋat Israel-aaġmiut sivunniutigikkaŋich akiḷiutigisukługich ilaanun.) ");
INSERT INTO eskNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tauqsiutiginiġaat utkutchirim nunaŋa, maliġutlugu atanġum tillisaa uvamnun.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus qikaqtitlugu sivuġaanun Pilate kavanauruam taavruma apiqsruġniġaa Jesus, “Umialigivatin Jew-ŋuruat?” Jesus kiuniġaa, “Uqaaniktutin taatna.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aasiiñ Jesus pasiikkaukami qaukłiŋitñiñ agaayuliqsit sivulliuqtiġruaniñḷu kiuŋiññiġai. ");
INSERT INTO eskNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kiisaimma Pilate nipliqpuq ilaanun, “Tusaqsaġiŋitpigich iḷisimarriqsuutiŋich akikŋaqhutin?” ");
INSERT INTO eskNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aglaan Jesus-ŋum kiuŋiññiġaa atautchimikunniiñ uqaqsaġniġmik. Kavanauruaq quviġutchallapiaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Uvvaasiiñ ukiuġaġipman niġiqpagvikaami kavanauruaq anipkairaġniqsuq atautchimik isiqtamik iñuich pisukkaŋatnik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Taatnałhatni iñuk isiqtauniqsuq iḷisimallautakkaŋat atiqaqtuaq Barabbas-mik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iñugayaat katipmata Pilate-ŋum apiqsruġniġai, “Nalliaknik anipkaitquvisitŋa—Barabbas-mik naagaqaa Jesus-mik taiguutiqaqtuamik Christ-mik?” ");
INSERT INTO eskNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ilaan iḷitchuġiniġaa tamatkua qaisilaaŋat Jesus iŋmiñun siqñataqałiġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aasiiñ Pilate aquppipkaqługu atanġum aquppiutaŋani, aġnaata tuyuġniġaa uqqamik itnaqługu, “Iḷaksianagu taamna nalaunŋaruaq iñuk, atakkii iłuiḷḷiuġutigillakkiga ugluvak siññaktuġiplugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aglaan qaukłiŋisa agaayuliqsit sivulliuqtiġruatlu maliksuŋniġaich iñugayaat apiqsruġlugu anipkaquplugu Barabbas aasiiñ tuqqutillugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kavanauruam apiqsruġniġai, “Nalliaknik ukuak iññuk anipkaitquvisitŋa?” Iñuich kiuliġñiġaat, “Barabbas.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate-ŋum apiqsruġniġai, “Suniaqpiguasiiñ Jesus taiguutiqaqtuaq Christ-mik?” Iluqatiŋ kiuniġaat, “Kikiaktuutili sanniġutamun.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate-ŋum nipliutiniġai, “Sumik savamaqłuqaqpa?” Aglaan nipaalapsaaqsiñaġniqsut nipitusiḷḷapiaqhutiŋ, “Kikiaktuutili sanniġutamun!” ");
INSERT INTO eskNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate iḷitchuġiniqsuq qanuġunniiñ piyumiñaił̣hanik suliasiiñ apai nipruaqhutiŋ iñuich. Imiksraqhuni iġġuġniġai argaŋni sivuġaatni iñugayaat. Aasiiñ nipliqhuni, “Uvva, patchisauŋitchuŋa uuma iñuum tuqqutauniałhagun. Taamna savaaġigiksi.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iluqatiŋ iñuich nipaalaniqsut, “Anasiñŋuqsausiaksraq tuqqutaułhagun illi uvaptiknun qitunġaptiknunlu.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tavrani Pilate-ŋum anipkaġniġaa Barabbas, aasiiñ ipiġaqtuqtitqaaqługu qaiññiġaa Jesus aŋuyyiuqtinun kikiaktuutityaquplugu sanniġutamun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aasiiñ Pilate-ŋum aŋuyyiuqtiŋiñ Jesus aullautiniġaat kavanauruam igluqpaŋanunaasii, katipkaqługich aŋuyyiuqtipayaat avataŋiqł̣ugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Atnuġaiyaqługu atipkaġniġaat kaviqsaamik atnuġaamik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Niaquġusiuġniqsut kakitḷaġnanik iḷipḷugu niaquanun tigummialiqługulu ayauppiamik taliqpiagun. Aasiiñ sitquqhutiŋ sivuġaanun mitautigiaqsiñiġaat nipliqhutiŋ, “Paġlagiptigiñ, umialgat Jew-ŋuruat.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Taatnaanikmata tivvuaqtuġniġaat Jesus pipḷugu taamna ayauppiaq anaumiaqsipḷuguasiiñ niaquagun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mitautigisuiqamitruŋ Jesus aŋuyyiuqtit mattaqługu atnuġaaq atukkaŋa atnuġaatqiksinniġaat atnuġaaŋiñik. Aasiiñ aullautiniġaat kikiaktuutikkauviksraŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aŋuyyiuqtit aniḷḷaġmiŋ nalaunniġaat aŋun Cyrene-naġmiu atilik Simon-mik. Nunuripḷugu taamna aŋun iqsruktinniġaat Jesus-ŋum sanniġutaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tikitñamiŋ inimun atiliŋmun Golgatha, itna mumiutiqaqtuaq “Saunġa niaqum,” ");
INSERT INTO eskNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","aŋuyyiuqtit qaitchiñiġaat misuqqumik avuuqtamik suŋamik. Aglaan Jesus-ŋum uuktuallakkaluaqamiuŋ imiġuŋiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kikiaktuutianikamitruŋ Jesus aŋuyyiuqtit autaaġniġaich atnuġaaŋi iŋmiknun saaptaqtuutigiplugich. ");
INSERT INTO eskNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aquvinniqsut qaunagiaqsipḷugu tavrani. ");
INSERT INTO eskNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qulaanun niaquan iḷiñiġaat pasikkun ilaagun, aglausimaruaq itna, “Uvvauna Jesus, umialgat Jew-ŋuruat.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Malġuk tigliŋniaqtik kikiaktuutiqatigipmiñiġik Jesus-ŋum, iḷaqataa taliqpianun aasiiñ iḷaqataa saumianun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iñuich apqusaaqtuat niaqulaniqsut nipliaplutiŋ pisaaŋŋatinik Jesus-mun, ");
INSERT INTO eskNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Uqaġuuruatin piyaqqułhiñaunipḷugu agaayyuvikpak nappatqigḷugu piŋasuni uvluni, anniqsuġiñ ilipnik. Iġñiġikpatin Agaayyutim, atqaġiñ sanniġutamiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Taatnatun qaukłiŋisa agaayuliqsit aglaliqiritlu sivulliuqtiġruatlu pisaaŋapmiñiġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Uqaġniqsut, “Ikayutlagaluaġai atlat iñuich, aglaan iŋmiñun ikayulguiññiqsuq! Umialgikpauŋ Israel-ŋum, ki atqaġli kikiaktuutriviŋmiñ. Aasiiḷi ukpiġigisigikput. ");
INSERT INTO eskNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tunŋaniqsuq Agaayyutmun. Ki, Agaayyutim pigisullapiaġumiuŋ anniqsuġliuŋ Jesus pakma, atakkii uqaġniqsuq iġñiġinipḷuni Agaayyutmun.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Taapkuak tigliŋniaqtik kikiaktuutiqatauruak ilaani pisaaŋapmiñiġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Uvluq qitiqquqman taaqsiñiqsuq nunapayaami piŋasuni sassaġniġñi. ");
INSERT INTO eskNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iḷiyuŋnaqsipman quliŋŋuġutaiḷam sassaġniŋanun Jesus nipliġñiqsuq nipitusiḷḷapiaqhuni, “Eli, Eli, lama sabachthani?” (Taamna itnautauruaq, Agaayyutmaaŋ, Agaayyutmaaŋ, suvaata suksraaqpiŋa?) ");
INSERT INTO eskNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iḷaŋisa iñuich tamaani qikaqtuat tusaakamitruŋ taamna uqaġniqsut, “Uvva uuma aŋutim tuqłiraġaa Elijah.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tavrauvaa iḷaŋat iñuich tigusiñiqsuq misuktaqtuamik. Immiqsinniġaa misuġuqłuŋmik iḷipḷugu qiruum nuvukkaŋanun. Aasiiñ qaiññiġaa ilaanun imiquplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aglaan iḷaŋich iñuich nipliġñiqsut, “Iḷaksianasiuŋ. Naipiqtuġlakput Elijah aggiġisipmagaan annautityaġlugu.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aasiiñ Jesus nipliatqikami nipitusipḷuni aniġniŋiġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tavraguuq talukuyaaq niviŋaruaq agaayyuvikpaŋmi siiksiġniqsuq tatpichakŋa takanuŋaaglaan. Nuna aulapmiñiqsuq suli uyaġaich qupluqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iḷuvġiḷḷu aŋmaġniqsut aasiiñ iñugiaktuat Agaayyutim iñuŋi tuqugaluaqtuat aŋitqikhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aŋitqianikamiŋ uniññiġaich iḷuviqtiŋ, aglaan aquagun aŋitqił̣han Jesus-ŋum nunaaqqimuŋniqsut ipqitchuamun sagviqhutiŋ iñugiaktuanun iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aŋuyyiuqtit aŋalatiŋiḷḷu qaunaksriruat Jesus-mik qiñiqamiŋ aularuamik nunamik suli supayaanik atuumaruanik, iqsitchallapiaġniqsut nipliqhutiŋ, “Iḷumun iġñiġiniġaa Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iñugiaktuat aġnat qiñiqtuaġniqsut uŋavaniñ. Tamatkua aġnat maliktuat Jesus-mik Galilee-miñ savautrityaqhutiŋ ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iḷaupmiñiqsut Mary Magdalene, Mary aakaŋak James-ŋumlu Joseph-ŋumlu, suli aakaŋak iġñaŋisa Zebedee-m. ");
INSERT INTO eskNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Unnuksraaqman umialik aggiġñiqsuq atilik Joseph-mik Arimathea-ġmiumik maliġuaqtaupmiñiqsuamik Jesus-mi. ");
INSERT INTO eskNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Utlautipluni Pilate-mun apiqsruutiginiġaa timaa Jesus-ŋum. Pilate tiliriñiqsuq qaitquplugu timi Joseph-mun. ");
INSERT INTO eskNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tavra Joseph-ŋum atqaqamiuŋ timi aasii nimiqsruġniġaa salumaruamik ukił̣haamik. ");
INSERT INTO eskNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aasiiñ inillaŋniġaa Jesus-ŋum timaa nutaamun iḷuviḷiuqtamun uyaġaŋmi, iḷuviksraġmiñun iŋmiñik. Aksraanikamitruŋ uyaġakpak umiŋniġaa talua iḷuvġum aullaqhuniasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene-lu atlalu Mary aquppiñiqsuk akiani iḷuvġum. ");
INSERT INTO eskNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Uvvaasiiñ uvlutqikman, itqanaiyaġvium uvluan aquagun, qaukłiŋich agaayuliqsit suli Pharisee-ŋuruat utlautiniqsut Pilate-mun ");
INSERT INTO eskNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nipliqhutiŋ, “Aŋuun, itqaġikput taavruma kinnirim uqaġikkaŋa iñuuŋŋaġmi makitqikkisiñipḷuni aquatigun piŋasut uvlut. ");
INSERT INTO eskNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Taamna pisigilugu tilisiiñ iḷuviq qaunagillapiaqulugu taapkunani piŋasuni uvluni. Maliġuaqtai aggiqpiaqtut tigliglugu timaa Jesus-ŋum aasii uqautilugich iñuich aŋitqiŋñiḷugu tuqumiñ. Taatnasiq saglułiq pigiitḷukkisiruq sivulliġmiñ sagluutimiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate-ŋum uqautiniġai, “Piksraġusi aŋuyyiuqtinik qaunaksriksrapsitñik qaunagityaqsiuŋ iḷuviq pisuqtilaapsitñi.” ");
INSERT INTO eskNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tavrali utlautiniqsut iḷuviġmun aŋmaġumiñaiyaġiaqługu uyaġak, suli qaunaksriḷiqł̣ugu aŋuyyiuqtinik. ");
INSERT INTO eskNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aquagun minġuiqsiaġvium, qauniuraaġataqtuami sivulliġmi uvluani akunniqsaam, Mary Magdalene-ŋumlu atlamlu Mary-m qiñiġiaġniġaak iḷuviq. ");
INSERT INTO eskNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tavratavrani suamaruamik nuna iḷiqsraqtuq, atakkii isaġulgan Atanġum atqaqhuni qiḷaŋmiñ aksraktinniġaa uyaġagruaq paaŋaniñ aasii aquvirvigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Qiññaŋa atriqaġniqsuq ikniqpalaŋmik, suli atnuġaaŋi qatiġniqsut aputitun. ");
INSERT INTO eskNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Iqsigiplugu qaunaksrit uuliksiñiqsut. Iḷiñiqsut tuquŋaruatun iñuktitun. ");
INSERT INTO eskNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Isaġulgum uqautiniġik aġnak, “Iqsiñatik. Iḷisimagiga ivaqłiqtik Jesus-mik kikiaktuutrauruamik. ");
INSERT INTO eskNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Uvaniinġitchuq. Aŋitqiksuq niplił̣iġmisun. Mauŋaġitchik. Qiñiġiatku Atanġuruam nallavia. ");
INSERT INTO eskNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aullaġitchik qilamik uqautilugich maliġuaqtai, ‘Aŋitqiŋñiqsuq tuqułiġmiñ aullaanikhuni sivupsitñi Galilee-mun. Taamani qiñiġisigiksi.’ Tavruŋaaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aullaqtiqtuk qilamiksruaqhutik iḷuviġmiñ iqsiḷḷaġmik quviasullapiaġataqhutiglu. Aqpaqsruaqhutik uqautrityaqtuk maliġuaqtaiñik. ");
INSERT INTO eskNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Uqautrityaqtuaqtitlugik maliġuaqtaiñik taimmaiñaq Jesus-ŋum nalaunniġik nipliutigaluni, “Paġlagiptik.” Taapkuak utlakługu tiguniġaak isigaŋigun, aasiiñ agaayyuvigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Uvvaasiiñ Jesus-ŋum uqautiniġik, “Iqsiñatik. Aullaġutik uqautityatkik aniqatiutka Galilee-muqulugich. Taamani qiñiġisigaatŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tavraguuq, igliqtitlugik iḷaŋich qaunaksrit nunaaqqimuŋniqsut uqautiaqsipḷugich qaukłiŋich agaayuliqsit iluqaŋitñik atuumaruanik. ");
INSERT INTO eskNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Uvvaasiiñ taapkua katimaanikmata sivulliuqtiġruatlu sivunniuqhutiŋ aŋuyyiuqtitlu qaitchiñiġaich manigayaanik ");
INSERT INTO eskNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","uqautiplugich, “Uqautiyumagisi iñuich, maliġuaqtaiñ tikitḷugu unnuami timaa tigliŋniġaat siñiktitluta aullautipluguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Taamnaasii uqautauruaq kavanauruam tusaaniqpauŋ quyaliñiaqsaġisigikput qanuutaisitchaġusi.” ");
INSERT INTO eskNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aŋuyyiuqtit akuqtuġniġaich maniich tupigiplugu urriqsuusiaqtiŋ. Taamna quliaqtuaq siaminŋasugaaqtuq akunġatni Jew-ŋuruat uvluvaŋnunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tavraasiiñ qulit atautchimik maliġuaqtit Galilee-muŋniqsut iġġimun Jesus aullaġvigitqukkaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Uvvaasiiñ qiñiqamitruŋ agaayyuviginiġaat, aglaan iḷaŋisa nalupqisuutigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus-ŋum tikitḷuni uqautiniġai, “Agaayyutim saŋŋiksriññiġaaŋa aŋalataġitlasipḷugich qiḷaŋmiittuat nunamiittuatlu. ");
INSERT INTO eskNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Taatnamik aullaġusi iñuŋnun nanipayaaq nunami maliġuaqtiġuqtititchi, paptaaġlugich atqagun Aapauruamlu Iġñiġuruamlu Ipqitchuam Irrutchimlu, ");
INSERT INTO eskNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iḷisautilugich kamaksritqulugich iluqaŋitñik tillisigikkamnik ilipsitñun. Nalupqigiyumiñaitkiksi nayuutiłiġa ilipsitñi ataramik isukłitchaaġatałhanunaglaan nunam.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uvvauna tusaayugaallautauruq Jesus Christ-kun, iġñiŋagun Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Agaayyutim uqautaa aglausimaruq sivuniksriqirikun Isaiah-kun, itna, “Ataŋii, tuyuġigisigiga uqqiraqtiga sivupni itqanaiyautitqulugu tumiksran sivunnapni.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Iñuk tuqłiraqtuq iñuiḷaamiñ: Itqanaiyautisiuŋ apqutiksraŋa Atanġum, nalġuġlugu tumiksraŋa!” ");
INSERT INTO eskNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Atuumasimaruq taatnatun, John Paptaaqtitchiri quliaqtuaqami iñuŋnun iñuiḷaami itnaqhuni, “Paptaaqtillusi mumiqqaaġusi killuqsautipsitñiñ Agaayyutimli natqigutigisigai killuqsautisi.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iñugiaktuat iñuich aggiumauraaġniqsut ilaanun nakikŋapayaaq Judea-miñ suli Jerusalem-miñ. Quliaġimatigik killuqsautitiŋ John-ŋum paptaaġniġai kuuŋmi taggisiqaqtuami Jordan-mik. ");
INSERT INTO eskNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John atnuġaaqaġniqsuq pikukturuam amianik, qisiŋmik tapsiqaqhuniḷu, niqiqaqhuniḷu pigliġianik suli igutchaich siiġñaqtaalliaŋitñik nanipayaaq paqitnami. ");
INSERT INTO eskNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Quliaqtuaqtuq, “Aŋunimma tikiumagisiruq kamanatluktuaq uvaŋniñ, aasiiñ siŋiiḷguyumiñaitchuŋaunniiñ aluġutiŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aa, iḷumutun paptaaġaluaġipsi imikun, aglaan ilaan paptaaġisigaasi Ipqitchuakun Irrutchikun,” itnaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Taipkunani uvluni Jesus aggiġñiqsuq Nazareth-miñ Galilee-miittuami. John-ŋum paptaaġniġaa Jordan-mi. ");
INSERT INTO eskNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus-ŋum qakipqauraqami imiġmiñ tautuŋniġaa qiḷak aŋmaqman. Agaayyutim Irrusia atqaqhuni miññiqsuq ilaanun tiŋmiaġruuratun. ");
INSERT INTO eskNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nipi tusaġnaġniqsuq pakmakŋa, “Ilvich piqpagiplutin Iġñiġigikpiñ, quyalimaaġikma.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tarakŋatarra Ipqitchuam Irrutchim aullaqtinniġaa iñuiḷaamun. ");
INSERT INTO eskNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Taavani iñuiḷaami inniqsuq malġukipiaq uvluni, aasiiñ tuunġaum uuktuallaŋniġaa. Nayuutiniqsuq iñuiḷaam niġrutaiñi, aasiiñ isaġulgich savautityaġniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Taipkunani uvluni Herod-ŋum, umialguruam, John tiguplugu isiġniġaa. Jesus utlautiniqsuq Galilee-mun quliaqtuaqhuni tusaayugaaŋanik Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nipliġñiqsuq, “Pakma aŋaayuqautaa Agaayyutim qallipḷuni atuumaaqsiruq. Isummitqigitchi ukpiġilugulu tusaayugaaġiksuaq.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Uvvaasiiñ Jesus pisuktualgitḷuni siñaagun narvaŋan Galilee-m, tautuŋniġik aniqatigiik, Simon-lu Andrew-lu, kuvriġñiaġniqsuak narvami, iqaluŋniaqtauplutik. ");
INSERT INTO eskNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus-ŋum nipliutigik, “Maliksikŋa. Uvakŋaniñaglaan piññaŋniaġisirutik iñuŋnik aqaluŋniaqtitun.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tarvauvaa uniññiġiŋik kuvraġikkatik maliaqsipḷuguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tarakŋatarra Jesus pisuktuallaallakhuni tautukkik aniqatigiik, James-lu John-lu, iġñak Zebedee-m, kuvriuġniqsuak umiaġmikni. ");
INSERT INTO eskNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus-ŋum tautupqauraqamigik tuqłuġniġik. Unisiġaaktarra aapagikkaqtik Zebedee akiññakniaqtuanun savaktaiñun umiami, maliaqsipḷuguasiiñ Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tikitñamiŋ Capernaum-mun minġuiqsiaġvium uvluani Jesus katraġviatnuktiġniqsuq iḷisautriaqsipḷuniasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Katimaruat aarigaaġusuŋniqsut iḷisauttutaiñik atakkii iḷisautripḷuni aŋalatchił̣iqaqtuatun, atlakaupluni ukunakŋa aglaliqiriniñ. ");
INSERT INTO eskNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jew-ŋuruat katraġviatni piqaġniqsuq irrusiqł̣uliŋmik nipliaruamik, ");
INSERT INTO eskNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iḷaksianatigut. Jesus Nazareth-miu, suniaqpisigut? Uvuŋaqpich piyaqquġukhuta? Naluŋitchiga kisuutilaan, ipqitchuaŋurutin Agaayyutim tuyuġikkaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus-ŋum tarra tiliñiġaa irrusiqł̣uk itnaqługu, “Qiñuisaaġiñ! Aniḷutinaasii aŋutmiñ!” ");
INSERT INTO eskNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Irrusiqł̣uum iñukniaq nagliksaaqtituullaŋniġaa qiiqsruqmatununniiñ iġialapkaqpauraqługu uniksaqamiuŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iluqatiŋ tautuktuat taavrumiŋa quviġutchakpagitḷutiŋ apiqsruqtuutiaqsiñiqsut avatmun, “Qanusiuniqpa una? Qanusiuniqpa nutaaq iḷisauttun? Una aŋun aŋalatchił̣iqaqhuni tilitḷaniġai irrusiqł̣uich, aasii iliŋisa tupigitlaniġaat.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Qilamik tavra siaminniqsuq taamna atuumaruaq nunaaqqipayaanun Galilee-mi. ");
INSERT INTO eskNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Anikamiŋ Jew-ŋuruat katraġviatniñ tupqatnuŋniqsut Simon-kutlu Andrew-tkutlu, piqatigiplugik James-lu John-lu. ");
INSERT INTO eskNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon-ŋum aakaruaŋa nalaniqsuq uunaqłukhuni. Jesus tikipqauraqman uqautiniġaat atniġñaġnipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Utlakługu aġnaq tiguniġaa argaigun makititlugu, aasiiñ uunaqłunġiqsiqhuni. Tavra niqłiuġutiaqsiñiġai. ");
INSERT INTO eskNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Minġuiqsiaġvium uvlua nuŋitman, unnuksraakun siqiñiq nipianikhuni, iñuich tikiutriñiqsut ilaanun tamatkuniŋa atniġñautiliŋnik atlakaaġiiñik suli irrusiqł̣uliŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iluqatiŋ nunaaqqim iñui katiniqsut taavruma tupqum sivuġaanun. ");
INSERT INTO eskNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus mamititchiñiqsuq iñugiaktuanik atniġñautiqaqtuanik atlakaaġiiñik suli anipkaipḷuni iñugiaktuanik irrusiqł̣uŋnik. Ilaan irrusiqł̣uich nipliquŋiññiġai atakkii iḷisimaniġaat kisuutilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Uvlaatchaurami qaugaluaqnagu Jesus aullaġniqsuq nunaaqqimiñ iñuiḷaamun. Tavrani agaayuniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon-ŋum piqasiqhuni piqatmiñik pakaaqsiñiġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Paqitnamitruŋaasiiñ nipliutiplugu, “Iluqatiŋ iñuich qiñiġukkaatin.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aglaan Jesus-ŋum kiuniġai, “Aullaqtuksraurugut atlamun nunaaqqimun. Uvaŋali quliaqtuaġumauŋa taamani atakkii piqutigiplugu aggiqsuaŋuruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tarra ilaa quliaqtuaqtuq katraġviŋitñi iluqaani Galilee-mi, anipkaipḷuniḷu irrusiqł̣uŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tarrasuli una auyugaqtualik tikiumaniqsuq Jesus-mun sitquqhuniasii iŋiqsruqługu ikayuqupluni, “Ilvich pisuksiñaġuvich mamitiłhiñaugikma.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus iḷunŋutchaŋniqsuq, isakługich argagikkani aksikł̣uguasiiñ. Nipliutiniġaa, “Pisugaaġluŋa, mamititqugikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesus nipliġḷuqqaaqtuq taavrumiŋa, taamna tavrakŋatchiaq iłuaqsiruq auyugaqtuaġmiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tarra Jesus-ŋum taamna aŋun aullaqtitkaluaqnagu iñiqtiġniġaa, ");
INSERT INTO eskNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Uqautiniaqnagu kiñaunniiñ aglaan agaayuliqsimugutin, qiñiqtitchumigiñ iłuaqsił̣hiñ ilaanun. Aatchuutiyumautin tuniḷḷautinik Agaayyutmun tuvraġlugu Moses-ŋum tillisigikkaŋa mamititkaatinkii. Taatnaġuvich iñupayaam iḷitchuġiniaġaa mamitilaan.” ");
INSERT INTO eskNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aglaan taamna aŋun aullaqami uqallaaqsiñiqsuq atqunallapiaq siamitlugu mamitikkaułłi. Taatnaqhuni Jesus isitqiḷguiññiqsuq nunaaqqiñun, aglaan aullaġniqsuq iñuiḷaamun, iñuichaasiiñ utlaaġaaqsipḷugu nakitŋapayaaq. ");
INSERT INTO eskNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kiŋuagun ikituurat uvlut Jesus utitqiŋñiqsuq Capernaum-mun. Iñupayaat uqaaqsiñiqsut aiñipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iñugiaktuat kativagitḷutiŋ tavruŋa iniksraigutiniqsut tupqum iḷuani naagaunniiñ paam siḷataani. Jesus-ŋum quliaqtuaġutiniġai Agaayyutim uqałhanik. ");
INSERT INTO eskNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tarra sisamat iñuich tavruŋautriñiqsut aulatlaiḷaamik iñuŋmik. ");
INSERT INTO eskNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Qalligaluaqhutiŋ tikiḷguiññiġaat Jesus iñugiakpagitḷutiŋ iñuich. Tavra aŋmaqługu tupqum qiḷaŋa atqaqtinniġaat taamna aulatlaiḷaq qaatchiaqtuummaan. ");
INSERT INTO eskNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus-ŋum iḷitchuqłiqamiuŋ ukpiqsrisiqaqtilaaŋat, nipliutiniġaa aulatlaiḷaq, “Nukatpiaq, killuqsautipnik natqigutigikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iḷaŋich aglaliqirit aquppiruat tamaani isummatiqaġniqsut itna, ");
INSERT INTO eskNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Suvaata una uqaqpa Agaayyutitun? Taamna uqaġniqłuktauruq. Agaayyun kisimi natqigutritḷaruq killuqsautinik!” ");
INSERT INTO eskNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus-ŋum irrutchiġmigun kaŋiqsiaġiliqamigich uqapiḷułhat, nipliutliġniġai, “Suvaata uqapiḷukpisi isummatipsigun? ");
INSERT INTO eskNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Qanuq una nipliutitquvisiuŋ aulatlaiḷaq, ‘Killuqsautipnik natqigutigikpiñ’ naagaqaa nipliutiłhanik, ‘Makillutin, uqummatitin tigulugich pisugiñ’? Nalliak qaġanatlukpa? ");
INSERT INTO eskNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aglaan iḷitchuġitqugipsi Iġñiŋan Aŋutim aŋalatchił̣iqałhanik maani nunami natqigutritḷapluni killuqsautinik.” Tavrani nipliutigaa aulatlaiḷaq, ");
INSERT INTO eskNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tiligikpiñ, ‘Makillutin, tigulugu qaatchian aggiiñ!’” ");
INSERT INTO eskNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tavrakŋatchiaq taamna aŋun makitiqtuq. Tiguplugu qaatchiani aullaġniqsuq nakuqsipqauraqami. Qiñiqtuapayaat taavrumiŋa quviġutchaŋniqsut. Kamasruaqsiñiġaat Agaayyun, “Tautunġaŋitchugut taatnatchimik,” itnaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus taivrumuŋalgiññiqsuq siñaanun narvaŋan Galilee-m aasii katirviginiġaat iñugaaġruich. Ilaan iḷisautiaqsiñiġai. ");
INSERT INTO eskNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tamaani apqusaaqami tautuŋniġaa Levi, iġñiġikkaŋa Alphaeus-ŋum aquppiruaq savaaġmiñi manniqipluni. Tavra Jesus-ŋum nipliutipmani itna, “Maliŋŋa,” taavruma makitluni maliutliġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aasiiñ taavruma aquagun Jesus niġiñiqsuq tupqani Levi-ŋum. Iñugiaktuat tax-siliqiritlu atlat killuliqiritlu aquppiqatiginiġaich Jesus-ŋumlu maliġuaqtaiñḷu. Tamatkua iluqatiŋ maliaqsipmiñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aglaliqirit suli Pharisee-ŋuruat tautuŋniġaat niġiqatiqaqługu tax-siliqirinik suli killuliqirinik. Taapkua nipliutigaich maliġuaqtai, “Suvaata ilaa niġiqatauva suli imiqatauva tax-siliqirini suli killuliqirini?” ");
INSERT INTO eskNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus-ŋum tusaakamigich nipliutigai, “Iłuaqtuat taapkua atniġñaitchuat inuqsraŋitchut taaktinik aglaan iliŋich atniġñaqtuat. Uvaŋa aggiŋitchuŋa aiyugaaġiaġlugich nalaunŋaruat aglaan killuliqirit.” ");
INSERT INTO eskNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maliġuaqtai John-ŋum Paptaaġirim suli Pharisee-ŋuruat uisauraaġuuniqsuat piqusiġiplugu. Iḷaŋich iñuich utlakamitruŋ apiqsruġniġaat, “Suvaata maliġuaqtai John-ŋum suli Pharisee-ŋuruat uisauraaqmata, ilviḷḷi maliġuaqtitin taatnatlaiññiqpat?” ");
INSERT INTO eskNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus-ŋum kiuniġai atrikusautmik, “Iḷagiich uumani iḷaqatnigiaqtuami uisauraaġniqpat iḷaqatnigiaqtuam nayuutiniŋanisuli? Taatnaġumiñaitchut iḷaqatnigiaqtuam nayuutiłhani. ");
INSERT INTO eskNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aglaan uvluq tikitkisiruq iḷaqatnigiaqtuam aullaġviksraŋa iliŋitñiñ. Tavra uisauraaġviksraqpaaluk.” ");
INSERT INTO eskNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesus-ŋum iḷisautipsaaġniġai atrikusrautmik, “Iñuum utuqqaq atnuġaaq iḷaaġumiñaitchaa nutaamik ukił̣haamik atakkii iḷaaŋuyumi nutaam utuqqaq alikpalaaġisigaa, aasiiñ allaq aglitḷukhuni. ");
INSERT INTO eskNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Naagasuli, iñuum utuqqaq puuq immiġumiñaitchaa nutaamik asiam misuġuanik atakkii nutaam misuqqum alikkisigaa asiam misuġuan puuŋa, suli asiam misuġua maqigisiruq taavrumakŋa puumiñ. Aglaan nutaaq asiam misuġua immiutraksrauruq nutaamun puumun.” ");
INSERT INTO eskNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Uvluani minġuiqsiaġvium Jesus pisuŋniqsuq nautchiivikun. Tarra maliġuaqtai tamaunnaaqamiŋ pukuŋniqsut mukkaaksranik, niġiaqsipḷugitaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tavra iḷaŋisa Pharisee-ŋuruat nipliutilgiññiġaat, “Ataŋii, suvaata iliŋich savakpat minġuiqsiaġvium uvluani maliġutaksrakuaġnaŋitkaluaqtuat tamarrumani uvlumi?” ");
INSERT INTO eskNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ilaan kiuniġai, “Agliqimasuknaġiksi David-ŋumlu piqataiñḷu inuqsriułhat niqiksraġmiknik? ");
INSERT INTO eskNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David isiġniġuguuq tupqanun Agaayyutim niġipḷuniasii qaqqumik tuniḷḷaqtuutmik Agaayyutmun. Taatna atuumasruuniqsuaq Abiathar-ŋum qaukłiułhatni agaayuliqsit. Maliġutaksraptigun kimun-unniiñ niqiksrautitquŋiññiġaa avataatigun agaayuliqsit. Aglaan David-ŋum niġiñiġaa qaqqiaq, aasiiñ aatchuġniġaa maliktigikkani.” ");
INSERT INTO eskNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Taatnaġaluaqamigich Jesus-ŋum nipliutipsaaġniġai, “Minġuiqsiaġvium uvlua iñiqtauruq iñuŋmun aglaan iñuk iñiqtauŋitchuq minġuiqsiaġvium uvluanun. ");
INSERT INTO eskNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Taatnamik Iġñiŋa Iñuum atanġuruq unniiñ minġuiqsiaġvium uvluani.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus isitqiŋñiqsuq Jew-ŋuruat katraġvianun. Aasiiḷi tarani itmiñiqsuq aŋun argalik pannaqłuktanik. ");
INSERT INTO eskNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jew-ŋuplutiŋ sivulliuqtuat qaunaksruaqsiḷgiññiġaat mavruigisikmaŋaan minġuiqsiaġvium uvluani, tavraami agvisiksraqsiuqługu. ");
INSERT INTO eskNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus-ŋum tarra nipliutiniġaa aŋun argalik pannaqłuktanik, “Makillutin uvuŋaġiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tavraniasiiñ apiqsruqługich taapkua, “Nalliak maliġutaksrakuaġnaqpa Minġuiqsiaġvium uvluani—savaaqałiq nakuuruamik naagaqaa pigiitchuamik, anniqsuił̣iq iñuułiġmik naagaqaa tuqqutchił̣iq?” Aglaan iliŋich nipaisaaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Uumitchaksaałhum tikiumaliġaluaġniġaa tarani aglaantuuq iłuirrutiginiġaa pitchiġiił̣hatigun suli suksraqaŋił̣hatigun, uummatiqaqhutiŋ siqquqtuamik. Tarra nipliutiniġaa aŋun taamna, “Isivitkich argaktin.” Taavruma tarra isivinniġai, aasiitai argai iłuaqsiñiqsut igḷumiktitun iḷipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tarra taapkua Pharisee-ŋuruat aullaqtiġniqsut, tarvauvaa sivunniuqatigityaqługich Herod-kuayaat qanuq tuqułiksraŋagun Jesus-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus aullaqasriqhuni maliġuaqtimiñik Galilee-m narvaŋanuŋniqsuq. Iñugaaġruich malilgiññiġaat Galilee-miñḷu Judea-miñḷu, ");
INSERT INTO eskNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem-miñḷu, Idumaea-miñḷu, uŋataaniñḷu Jordan-ŋum, avataaŋniñḷu Tyre-mlu Sidon-ŋumlu. Taapkua tusaaniġaat kamanaqtuanik savaaqałha utlakługuasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tarra Jesus-ŋum uqautiniġai maliġuaqtini umiaq ikkiviksrani tigułhiñaaġuquplugu qanimiñun atakkii iñugaaġruich ukua iñugiaksivagitḷutiŋ tatruliġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mamititchianikman iñugiaktuanik, atlat atniġñautilgich tatviksraiġñiġaat aksigukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tamarrasuli irrusiqł̣ulgich tautukamitruŋ putqataġvigiplugu niplianiqsutli itna, “Ilvich Iġñiŋa Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aglaan iñiqtiqtaġniġai tamatkua iliŋitñun iḷitchuġipkautigitquŋitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus kilvaqtaaġniqsuq tuŋaanun kiŋiktaam nunam. Tarani qiññuaġniġai tamatkua pigisukkani. Tarra utlaŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nalunaiqsaġai qulit malġuk maliġuaqtiksrat, uqqiraqtaunik taiyuqługich piqatigisukługich, tuyuġisukługich quliaqtuaġiaquplugich. ");
INSERT INTO eskNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Saŋŋiksriññiġai mamititchitḷasipḷugich atniġñaqtuanik suli anitchitḷasipḷugich irrusiqł̣uŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Uvva ukua qulit malġuich Jesus-ŋum nalunaiqsaġikkaŋi: Simon-lu atchikkaŋa Peter-mik, ");
INSERT INTO eskNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James-lu John-lu iġñak Zebedee-m Jesus-ŋum atchikkak Boanerges-mik, mumiutiqaqhuni “Iġñiġikkak katlulam” uumitchiyałallakhutigguuq. ");
INSERT INTO eskNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Suli Andrew-lu, Philip-lu, Bartholomew-lu, Matthew-lu, Thomas-lu, James-lu iġñiŋa Alphaeus-ŋum, Thaddaeus-lu, atla suli Simon Zealot-ŋuruaq, ");
INSERT INTO eskNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","suli Judas Iscariot, taamna aatchuutigitniktuaq ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Akuniisuŋaqani Jesus isiġniqsuq tupiġmun. Iñugaaġruich malilgiññiġaat. Kiisaimmatai taatnaqhutiŋ Jesus-lu maliġuaqtiniḷu niġiḷguiḷiġniqputunniiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tavra iḷaiñ tusaakamitruŋ taatnaqtuaq aullaġniqsut aggisityaġukługu Jesus, atakkii iñuich uqautigigaat iłuanġiġñipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iḷaŋich aglaliqirit tikiññiġaat Jerusalem-miñ itnaqhutiŋ, “Jesus Beelzebul-mik aŋalatiqaqtuq, aasiiñ anitchiraġaqtuq irrusiqł̣uŋnik atuqługu saŋŋia aŋalataata irrusiqł̣uich.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus-ŋumtarra qalliḷaaquniġai iñuich iŋmiñun uqautiuraagaqsipḷugichaasiiñ atrikusautitigun itna, “Qanuġuni tuunġaq anittaigisiva tuunġaġmik? ");
INSERT INTO eskNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uvva nunaaqqim aŋalatai akiḷḷiḷiqsuutikpata avatmun, taamna nunaaqqiq suksraunġiġñiaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Uvvasuli iñuich tupiġmi atinġiqpata akitŋaqtuutilutiŋ suksraunġiġñiaqmiut. ");
INSERT INTO eskNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Uvva taatna qaukłiat tuunġaich irrusiqł̣uŋi piyuutigumiŋ avatmun, ilaan saŋŋia isukłiññiaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Uvvasuli atla atrikusaun: Kiñaunniiñ iñuk isiġumiñaitchuq saŋŋiruam iñuum tupqanun ivayaqtuaqsiḷuniasiiñ sulliñauraŋiñik aglaan sivulliulugu pitukkayaġaa saŋŋiruaq iñuk, tavrakŋaasiiñ ivayaqtuaqsiḷuni sulliñauraŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Uvvauna uqautigipsi, Agaayyun natqigutriyumaaqtuq pisugaaqhuni iñuich killuqsautipayaaŋitñik suli uqaġniqłuktałipayaaŋitñik Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aglaan Agaayyutim natqigutiyumiñaitchaa taimuŋa iñuk uqaġniqłuutriruaq Ipqitchuamik Irrutchimik; taamna iñuk patchisaugisiruq isuitchuaġuni.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus taatnaġniqsuq atakkii taapkua upyaktuqługu itna, “Taamna aŋalatiqaqtuq irrusiqł̣uŋmik.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Uvvali Jesus-ŋum aakaŋa suli aniaqatiuŋi tikiññiqsut. Qichaqhutiŋ qakma kiligiaqtinniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iḷaŋata aquppiruat avataani nipliutigaa Jesus, “Ataŋii, aakanlu aniaqatiutinlu kigga utaqqiñiġaatin.” ");
INSERT INTO eskNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus-ŋum kiuniġai, “Kiña uvaŋa aakapiaġiviyu unniiñ aniaqatiupiaġiviyu?” ");
INSERT INTO eskNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Saatlugich aquppiruat avatmiñi nipliutipsaaġniġai, “Ataŋii, uvaŋa aakapiaġa suli aniaqatiupiatka! ");
INSERT INTO eskNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kisupayaaq savaaqaqtuaq pisułhanik Agaayyutim, taamna iñuk aniaqatiugigiga suli aakagiplugu.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tarrasuli Jesus-ŋum iḷisautiaqsiḷgiññiġai narvam siñaani imma. Iñuich katilgiññiqsut iñugiaksipḷutiŋ. Taatnaqmataasiiñ ikiniqsuq umiamun, mikiruuramik ayaktaallakługu, aquvinniqsuq. Iñugaaġruich qichaqtuiñaqtut narvam siñaani. ");
INSERT INTO eskNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ilaan iḷisautiniġai iñugiaktuatigun atrikusautitigun. Aasii iḷisauttutmiñi uqaaqtuutiuraaqługich. ");
INSERT INTO eskNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Naalaġniḷḷagitchi! Iñugguuq nautchiityaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nautchirapkaqługu nautchiaksrat iḷaŋich katagaġniqsut apqutmun, aasiitai tiŋmiurat tikitḷutiŋ niġiñiġaich. ");
INSERT INTO eskNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iḷaŋich kataŋniqsut uyaġauruamun nunamun nunaqapiaŋitchuamun. Nauniqsut qilamik atakkii nunakitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aasiiñ siqiñġum mayuaqami pasikł̣ugich atakkii kaŋiqapiaŋitḷutiŋ pannaqłuŋniġai. ");
INSERT INTO eskNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Suli iḷaŋich kataŋniqsut akunġatnun kakitḷaġnat, aasiiñ kakitḷaġnat naukamiŋ nagguviksraiġñiġaich asirriŋitḷutiŋaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Iḷaŋitsuli katakhutiŋ nunagiksaamun asirriaqaġniqsut. Iñugiaksipḷutiŋ nauriñiqsut mukkaaksranik atautchimiñ iñuiññaq quliŋuttaaqhutiŋ suli iḷaŋich piŋasukipiaŋuttaaqhutiŋ suli iḷaŋich tallimakipiaŋuttaaqhutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ilaan nipliutigai, “Taamna iñuk siutiqaqtuaq naalaġniḷi.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kisiŋŋuqamiŋ, maliġuaqtaiñ iñuiḷḷu tusaaruat ilaanik apiqsruġniġaat taavrumuuna atrikusautikun. ");
INSERT INTO eskNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus-ŋum nipliutigai, “Agaayyutim sagviġaa nalunaqtuaŋanik aŋaayuqautaan ilipsitñułhiñaq, aglaali tamatkunuŋa ukpiqsriŋitchuanun uqaġaqtuŋa atrikusautitigułhiñaq. Taamna aglausimaruaq uqałiġni immiumaruq Agaayyutim itnauttutigikkaŋa, ");
INSERT INTO eskNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Qiñiġaluaqhutiŋ irimiknik iḷisaqsritḷaitchut, unniiñ tusaagaluaqhutiŋ siutimiknik kaŋiqsiḷḷaitchut. Kaŋiqsiñiġumiŋ mumikpiaqtut Agaayyutmun, ilaanli natqigutigai killuqsautiŋitñik.’” ");
INSERT INTO eskNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus-ŋum apiqsruġniġai, “Naluniqpisiuŋ taamna atrikusaun? Qanuġmi kaŋiqsiñiaqpisigich atlat atrikusautit? ");
INSERT INTO eskNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nautchiiri nautchiiruq tusaayugaallautamik. ");
INSERT INTO eskNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iḷaatni uqałiq nautchiaksratun katagaqhuni apqutmun; tamatkua iñuich tusaaplugu uqałiq, aglaan tuunġaum tikitḷugu qilamik aattaġniġai uqałhich nautchirriutauruat uummatiŋitñi. ");
INSERT INTO eskNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Suli atlat iñuich atripḷugich nautchiaksrat kataktuat uyaġauraaliŋmun; tusaaplugulu uqałiq qilamik quviasukhutiŋ akuqtuqługulu, ");
INSERT INTO eskNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","aglaan uqałiq kaŋiḷiŋitman akuniutlaitchuq. Kiŋuagun iłuiḷḷiułiġlu piyuaqsiułiġlu iḷipmaknik pigiplugu uqałiq qapiqtiġaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Suli atlat iñuich atripḷugich nautchiaksrat kataktuat akunġatnun kakitḷaġnat. Taapkua tusaaruat uqałiġmik ");
INSERT INTO eskNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","aglaan isumaaluutit iñuuniałikun, kinnitñiŋniaġutitlu umialgutmik suli kimmutit supayaanik suqutiginġiġaġigaat Agaayyutim uqałha. Taimmaasiiñ nauritḷaitchut asianik. ");
INSERT INTO eskNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Suli atlat iñuich atripḷugich kataktuat nunagiksaumun: tusaakamitruŋ uqałiq akuqtuqługu suli asirriaqaqhutiŋ, iḷaŋich iñuiññaq qulitun, iḷaŋich piŋasukipiatun, iḷaŋitsuli tallimakipiatun.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus nipliutigikkani iḷaniġai, “Ataŋii, iñuich iḷiraġinġitchaa naniq ataanun utkusium unniiñ ataatnun siñigviich. Aglaan iñuich naniq iḷiraġigaa naniqaġviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Agaayyutim iriqsimakkaŋi pakma sagviġisigai iḷaatnigu. Iñuich kaŋiqsimaŋitchaluaġumisigik pakma kaŋiqsigisigaich taimanigu. ");
INSERT INTO eskNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kiña iñuk siutiqaġumi tusaatlaruaŋnik, ki ilaa tusaali.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ilaan nipliutimmiñiġai, “Ki, naalaġnimmaaġiksi ata! Qanutun naalaġnisilaaqsi taimma itpan, taatnatun kaŋiqsiaqtilaaqsi itkisiruq, suli kaŋiqsisaiñaġniaqtusi. ");
INSERT INTO eskNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ilaa piqaqtuaq akuqtullaaġisiruq aglaan taavruma piqaŋitchuam anniagisigaa pigikkani.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus nipliqsuq, “Atriqaqtuq aŋaayuqautaa Agaayyutim iñuŋmik nautchiiruamik nautchiaksranik nunamun. ");
INSERT INTO eskNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Unnuaġaġipman siñikhuni suli uvluġaġipman makitluni savaaqaqtuq. Qaunaksraiḷaat nautchiaksrat nauraqtut, suli qanupiaq nalugaa naułhat. ");
INSERT INTO eskNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Aglaan nunam naupkaqługu asirriraqtuq, sivulliuplugu nautchiaksraq nuiḷḷagaqtuq qiñiġnaqsiuraqhuni aasiitai nauqqaaqhuni puuŋa piŋŋuqmata mukkaaksram, tavrakŋa iluqani niqiksraq nauvaalukhuni. ");
INSERT INTO eskNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aglaan asiat nautchiirim kipputmik kipiaqsiraġigai, katitchivik tikiumaplunikii.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus nipliqsuq, “Sumun atritḷavisigu Agaayyutim aŋaayuqautaa iñuŋnik? Uqautiniaġipsi atrisilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Atriqaqtuq nautchiaksrauramik atiqaqtuamik mustard-mik. Mikiniqtaġaluaqtuq nautchiaksrapayaaniñ nunami. Aglaan nautchirriutaukami nunami ");
INSERT INTO eskNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","naugaqsiraqtuq aglitḷukhuni nauriapayaaniñ. Akiġuġluksipḷuni tiŋmił̣uich uvluutiqaġvigiraġniġaat taġġaŋatni akutuqpalgich.” ");
INSERT INTO eskNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Suli iñugiaktuatigun atrikusautitigun Jesus-ŋum uqaaqtuutiraġniġai iñuich kaŋiqsiḷgutilaaŋatitun. ");
INSERT INTO eskNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ilaan uqautitlaitkai atrikusautaiḷaaqhuni. Aglaan kisiŋŋuqamiŋ maliġuaqtini kaŋiqsipkaġniuraapiaqługich piraġniġai. ");
INSERT INTO eskNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tamarrumani uvlumi anaqaksraaqman ilaan nipliutiniġai maliġuaqtini, “Akmuŋaqta” ");
INSERT INTO eskNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tavrani iliŋisa uniññiġaich iñugaaġruich. Maliġuaqtai ikiniqsut umiamiknun Jesus-ŋum ikimmivianun. Atlat umiat itmiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Anuqłiġuqman qaiḷiġuqhuni umiaŋat immautiaqsiñiġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus aquani umiam siñiŋniqsuq akitchiḷḷakhuni. Iliŋisa itiqsaġniġaat niplialaplutiŋ, “Ataniiq, sugiŋitpiuŋ piyaqquġupta?” ");
INSERT INTO eskNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ilaa makitluni iñiqtiġniġik anuġilu qaiḷiġḷu, “Ki, anuġaiġḷi!” itnaqhuni. Anuġaiqhuni quunniġuġniqsuq taatnaqman. ");
INSERT INTO eskNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nipliutiniġai, “Suvaata iqsivisi ukpiqqutaitmatun?” ");
INSERT INTO eskNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Taapkua iqsiḷiqpauraġniqsut. Apiqsruutiaqsiñiqsut avatmun, “Qanusiuniqpa una iñuk anuġimunniiñ qaiḷiqpauratlu kamagivatruŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iliŋich ikaaġniqsut igḷuanun narvam nunaŋatnun Gerasene-naġmiut. ");
INSERT INTO eskNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Niupqauraqman umiamiñ paaġniġaa irrusiqł̣ulgum iḷuvġich akunġatniñ. ");
INSERT INTO eskNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Uvvaguuq taamna iñuuniaġniqsuaq tamaani. Kia-unniiñ iñuum qiḷiqsimalguitḷugu kalimñiġñik; ");
INSERT INTO eskNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akulaiqł̣ugu qiḷiġaluaġaġniġaat niukkunlu argaigunlu. Kiktuġaalaraġniġai qilġutini piiyaqługich. Kia-unniiñ iñuum nuyuiqsalguiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ataramik unnuamiḷu uvlumiḷu nayuutiraġniqsuq nipaalapluni qipiqsralakami iḷuviġich akunġatniḷu qimiġaat qaaŋatniḷu, suli iñugiaktuami kiḷḷialapluni uyaġaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Taiññaqiuraq qiñiqamiuŋ Jesus aqpaliqsruġniqsuq ilaanun, sitquġvigipluguasiiñ sivuġaanun. ");
INSERT INTO eskNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Iñuum iḷuaniñ irrusiqł̣uum piyaa nipitugalukut, “Jesus, Iġñiŋa Qutchiŋñiqsrauruam Agaayyutim, suniaqpiŋa? Agaayyutim atqagun iŋiġikpiñ anasiñŋuqsaquŋitḷuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesus-ŋum tiligaa irrusiqł̣uk anitquplugu taavrumakŋa iñuŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Atakkii Jesus-ŋum apiqsruġaa, “Sumik atiqaqpich?” Ilaan kiuniġaa, “Uvaŋa atiġa Iñugiaktuaq atakkii uvagut iñugiaktugut.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tarra taavruma iŋiqsruaġniġaa, “Tuyuġiniaqasigut tamarrumakŋa nunamiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Qanimi munaqsraqpauraqaġniqsuq malġuŋnik kavluutiŋnik kunianik, niġiñiaqhutiŋ qimiġaami. ");
INSERT INTO eskNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Irrusiqł̣uich iŋiqsruaqsiñiġaat, “Isiqtittigut kunianun taapkunuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus-ŋum aŋiġniġai. Irrusiqł̣uk aullaġniqsut aŋutmiñ, isiqhutiŋaasiiñ kunianun. Iluqatiŋ kuniat paŋalikhutiŋ anayasuktuasuŋaqatiŋ ipnakun. Naparaġniqsut narvamun aasiiñ ipiplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Munaqsriruat taapkuniŋa kunianik qimakhutiŋ uqautityaġniġaich nunaaqqiġmiut. Tamatkua iñuich aullaqhutiŋ tautugiaġniġaat tamanna atuumaruaq. ");
INSERT INTO eskNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iñuich utlautikamiŋ Jesus-mun tautuŋniġaat irrusiqł̣uqaġuugaluaqtuaq aquppiruaq atnuġaaqhuni qauġrimapluniḷu. Taatnaqhutiŋ iñuich iqsitchaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tamatkua qiñiqatauruat uqautigiaqsiñiġaat iñupayaanun qanuq atuumałha atlaġuqman irrusiqł̣uqaġuugaluaqtuaq suli qanuq piyaqqułhat kuniat. ");
INSERT INTO eskNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tavra iñuich iŋiqsruagaqsiñiġaat Jesus aullaquplugu nunamikniñ. ");
INSERT INTO eskNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus ikiaqsipman umiamun taavruma irrusiqł̣uqaġuugaluaqtuam iŋiqsruaqsiñiġaa maligukługu Jesus. Maliguliḷḷapiaġniġaa Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Naagauvva Jesus-ŋum maliquŋiññiġaa aglaan itna nipliutiłhiñaġniġaa, “Aiḷutin iḷauraaqnun uqautityakkich tamarrumiŋa kamanaqtuamik Atanġum savauttutaanik ilipnun suli iḷunŋuksrił̣hanik ilipnun.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tavra iñuk aullaġniqsuq, aasiiñ quliaqtuagaqsipḷuni nanipayaaq Qulini Nunaaqqiñi qanuq kamanaqtuamik savaaqałha Jesus-ŋum iŋmiñun. Tarra iluqatiŋ iñuich quviġusuŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus utiqami igḷuanun narvam, iñugiaktuat iñuich katilgiññiqsut siñaani narvam. ");
INSERT INTO eskNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tavra aggiqmiñiqsuq aŋalataa Jew-ŋuruat katraġviata, Jairus-mik atilik. Tautukamiuŋ Jesus punniqsuq sivuġaanun. ");
INSERT INTO eskNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Iŋiqsrullapiaġniqsuq itnaqhuni, “Paniuraġa amma tuqułhiñaaġuqtuq. Iḷiḷḷaŋniaqugitka argaktin ilaanun mamitquplugu. Iñuuyumauġli.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Taatnaqmantarra Jesus taamuŋaqatiqagiññiqsuq. Iñuich iñugiakpagitḷutiŋ malilgiññiġaat tatruqługuunniiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aġnaqtuuq tamaaniitmiñiqsuq atniġñautiqaqtuaq auŋmik qulit malġuŋni ukiuni, ");
INSERT INTO eskNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","iłuaqsipkaġniaġaluaqtitluni iñugiaktuanun taaktinun. Akiḷiqsuutigiplugitunniiñ sulliñaurani iłuaqsiŋiññiqsuq, aglaan atniġñaliqsaiññaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ilaan tusaakamiuŋ Jesus utlautiniqsuq iñugiaktuat akunġatigun. Tarra tunuaniñ aksiŋñiġaa atnuġaaġikkaŋa, ");
INSERT INTO eskNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","isumapluni, “Aksikkupku Jesus-ŋum atnuġaaŋa iłuaqsiyumiñaqtuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tavrakŋatchiaq aunaaqsruŋaiġñiqsuq. Ikpiginiġaa timigikkaġmiñi iłuaqsił̣ł̣i taavrumakŋa atniġñautmiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus iḷisimaliqhuni saŋŋi aullaqtilaaŋanik iŋmiñiñ kiŋiaġniqsuq tatruqtuani nipliqhuni, “Kia aksiksiqpauŋ atnuġaaġa?” ");
INSERT INTO eskNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Maliġuaqtaiñ nipliutigaat, “Iḷisimagaluaqługu iñugiaktuanun tatruqtilaan, naagasuli apiqsruqtutin kimun aksiksilaaqnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus qiñiġniaġniqsuq kimun aksiksilaaġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Taavruma aġnam Jesus utlaŋniġaa iqsiḷiqsiqhuni attaqsraliqsiqhuni iḷisimaplunikii iłuaqsisilaaġmiñik. Putluni sivuġaanun uqautiniġaa aksiŋñipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus-ŋum nipliutigaa, “Ukpiqsrił̣iqpich iłuaqsipkaġaatin. Tutqiksautlasirutin, iłuaqsirutin atniġñautigikkaqniñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus uqaqtitlugu iḷaŋich iñuich tikiññiqsut tupiġikkaŋaniñ taivruma aŋalataan katraġvium nipliqhutiŋ, “Paniuran tuquaniktuq. Iḷaksiatqiŋñiaqnagu Iḷisautri.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus-ŋum suliqutigisuŋaqnagich nipliqsuat nipliutigaa aŋalataa katraġvium, “Iqsiñak, ukpiqsrił̣hiñaġiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ilaan kiñaunniiñ iñuk maliquŋiññiġaa avataatigun Peter-mlu, James-lu, suli John aniqatigikkaŋa James-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tikitñamiŋ tupqanun aŋalataan katraġvium Jesus-ŋum qiñiġniġai kiñuvġurit tamatkualu qiarit atqunallapiaq. ");
INSERT INTO eskNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isiqhuni nipliutigai, “Suvaata itnaġniqpisi qiaplusiḷu? Una iḷiḷgaaq tuquŋitchuq, siñiktuaqsiñaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tamatkua mitautigiaqsiñiġaat. Uvvaasiiñ anitquniġai. Kisiŋŋuqhutiŋ aŋayuqaaglu iḷiḷgaam suli taapkualu piŋasut maliġuaqtai isiġniqsut iḷiḷgaam nalavigikkaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tiguniġaa iḷiḷgaaq argaigun nipliutipluguasii, “Talitha Coum” (mumiutiqaqtuaq “Niviaqsiaġruuk, nipliutigikpiñ, makittin”). ");
INSERT INTO eskNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tavrakŋatchiaq iḷiḷgaaq makinniqsuq pisuaqsipḷuniasiiñ. Taamna ukiuqtutilaaqaġniqsuq qulit malġuŋnik. Taapkua nayuutiruat quviġutchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ilaan iñiqtiġniġai kisumununniiñ iḷitchuġipkaquŋitḷugu tamanna atuumaruaq aglaan niġipkaquniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Taavrumakŋa Jesus aullaġniqsuq iñuguqniaġviŋmiñun. Maliġuaqtaiñ maliŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Minġuiqsiaġvium uvluani ilaa iḷisautriaqsiruq Jew-ŋuruat katraġviatni. Iñugiaktuat tusaakamitruŋ quviġusuŋniqsut nipliqhutiŋ, “Nakikŋakiaq iḷisimmatiqaġnikpa, una iñuk? Kia marrumiŋa puqiutmik aatchuġniqpauŋ suli saŋŋimik savaaqatlasipḷuni quviqnaqtuanik? ");
INSERT INTO eskNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Taamna qiruŋnik savaaqaġuusruguuq, amii? Iġñiġigaa Mary-m. Suli aniaqatigigaat James-ŋumlu, Joseph-ŋumlu, Judas-ŋumlu Simon-ŋumlu, suli aġnat aniaqatai marra iñuuniaqhutiŋ akunnaptikni.” Tarraasiiñ ukpiġiŋiññiġaat kamanałha. ");
INSERT INTO eskNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aglaan Jesus-ŋum itnaġniġai, “Iñuich nanipayaaq kamagiraqniġaat sivuniksriqiri aglaan kamagitlaiññiġaat iñuguġviani unniiñ akunġatni iḷagikkaiñ naagaunniiñ kiñunġani.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesus savaaqalguiññiqsuq quviqnaqtuanik savaanik. Iḷigaluaġniġai argaŋni ikituuranun atniġñaqtuanun iłuaqsipḷugichaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ilaan quviġusuutiginiġaa Nazareth-miut ukpiqsrisuŋił̣hat. Jesus nunaaqqiñuktaġniqsuq iḷisautriaqsipḷuniasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus-ŋum sivunniuqatiginiġai qulit malġuich maliġuaqtini, aasii aullaqtitkaqsipḷugich malġuuttaaqługich. Saŋŋiksriññiġai anitchitḷasipḷugich irrusiqł̣uŋnik, ");
INSERT INTO eskNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","tilipḷugich, “Iglaułłapsitñi saagaġniaqasi sumik aglaan ayauppiuramik kisian; qaqqumik unniiñ iŋiularim puukataŋanik unniiñ maniŋmik aullautriñiaqasi. ");
INSERT INTO eskNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aluġuaqtuġusi suli atnuġaatqiutiksraiḷaaġusi.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Suli ilaan nipliutiniġai, “Tukkuniġupsi tupiġmun atlamik tukkuksraqsiuġumiñaitchusi aullaġniałłapsitñunaglaan, ");
INSERT INTO eskNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","suli iñuich paġlaŋitpasi naalaġnisuŋitpatigiglu uqalusi, uniḷḷugu nunaaqqiq ipsuktuġumagiksi apyuq isigapsitñiñ. Taamna kilgutaugisiruq iliŋitñun akuqtuiŋisilaaŋatnik tusaayugaaġiksuamik. Iḷumun uqautigipsi, qaġanatluŋniaqtuq iñuiñi Sodom-ŋum Gomorrha-ŋumlu atanniivium uvluani taapkunakŋa iñuiñiñ nunaaqqim.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Quliaqtuaġutiginiġaat iñuŋnun isummitqiquplugich mumikługich killuqsautiŋitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Suli anittaiñiqsut iñugiaktuanik irrusiqł̣uŋnik iñuŋniñ, uqsruqtiqługiḷḷu uqsruġutnik iñugiaktuat atniġñaqtuat iłuaqsipḷugichaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod-tuuq, Galilee-m umialga, tusaaniqsuq Jesus-mik atakkii iñuich uqaqaġniqsut ilaanik nanipayaaq. Iḷaŋich iñuich nipliġñiqsut, “John Paptaaqtitchiri aŋitqiŋñiqsuq tuqułiġmiñ. Taatnamik savaaqatlasiñiqsuq quviqnaqtuanik.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Atlat nipliġñiqsut, “Elijah-ŋuvaluktuq.” Suli atlattuuq uqaġniqsut, “Sivuniksriqirauvaluktuq iḷaŋatitun taipkua kamanaqtuat sivuniksriqiritun iŋiḷġaan.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aglaan Herod tusaakami nipliġñiqsuq, “Una John-ŋuniqsuq niaquikkaġa, makitqikhuni tuqułiġmiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sivuani Herod-ŋum iḷaqatigiliutinikkaŋa aniaqatmi Philip-ŋum nuliaŋa atilik Herodias-mik, John-ŋum suakataġaluaġniġaa Herod, “Maliġutaksrakuaġnanġitchuq aniaqatvich nuliaġikkaŋa tuvaaqasiutigupku.” Taatnaqługu Herod-ŋum tigupkaġniġaa John isiqsiuviŋmuktitluguasiiñ aġnaqtiŋ quyalisukługu. ");
INSERT INTO eskNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aasiiñ Herodias-ŋum qinnautigaluaġniġaa tuqqutchukkaluaqługu, aglaan taatnalguiññiġaa piqutigiplugu Herod. ");
INSERT INTO eskNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod-ŋum attaġiniġaa John iḷisimaplugu nalaunŋapluni ipqitchuaq iñuk. Taatnamik tugluaqsimaaġniġaa. Naalaġnisuullapiaġaa John tutqiiḷisuugaluaŋŋaġmi naalaqtuapayaaqamiuŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kiisaimma Herodias-ŋum piviksrani nalautitpaa. Herod-ŋum annivilirvia tikitman aiyugaaqłiqhuni qaukłiŋitñik kavamauruat, aŋuyaktillu qaukłiŋitñik suli sivulliuqtiŋitñiglu Galilee-m. ");
INSERT INTO eskNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tavra pania Herodias-ŋum isiqhuni sayuġniqsuq quyalipḷugu Herod suli tuyuġmiaŋi. Umialgum nipliutiniġaa aġnauraq, “Iŋiqsruġiñ, sumik piqaġukkapnik aatchuġisigikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akiqsruutiniġaa taamna aġnauraq, “Qanutchipayaamik iŋiġupŋa qaitchigisigikpiñ, avvaŋanikunniiñ atanġuviŋma.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Niviaqsiaq aakamiñukhuni itnaġniġaa, “Sumik apiqsruġisivik?” “Apiqsruġumautin niaquanik John Paptaaġirim,” aakaŋan itnaġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Taamna utiġniqsuq qilamiksruaqhuni umialiŋmun nipliutiplugu, “Uvaŋa aatchuquruŋa ilipnun akkupak niaquanik John Paptaaqtitchirim puggutamun iḷiḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Umialgum tusaakamiuŋ aliasuliḷḷapiaġniqsuq. Aglaan akiqsruqtuutni pigiplugu suli pigiplugich tuyuġmiani itigautipchanġitchaa. ");
INSERT INTO eskNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tarva Herod umialik tilisiñiqsuq niaquiqsirimik niaquanik John Paptaaqtitchirim aggiutritquplugu. Taavruma isiqsiviŋmukhuni niaquiġñiġaa John. ");
INSERT INTO eskNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aasiiñ aggiutiplugu niaqua puggutamun iḷipḷugu qaiññiġaa aġnauramun, aasiiñ aġnauram qaitḷugu aakamiñun. ");
INSERT INTO eskNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tavrakŋa John-ŋum maliġuaqtaiñ tusaapqauraqamitruŋ taamna, aiñiġaat timaa tugvaġiaqługuasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Uqqiraqtit utiġniqsut Jesus-mun, uqautipluguasiiñ savaaġikkaġmiknik suli iḷisautrił̣iġmikniglu. ");
INSERT INTO eskNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iñuich utiqtaqpaitḷutiŋ maliġuaqtai niġġiviksraiġniġaichunniiñ. Taatnaqhuni Jesus-ŋum nipliutiniġai, “Kiata, kisiŋŋuġuutiluta iñuiḷaamun, minġuiqsiallagiaġitchi.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tavra aullaġniqsut iñuiḷaamun umiakun kisimiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iñuich tautukamisigiŋ aullaqmata, iḷisaqłiġniġaich. Aqpatkaqsiḷiġñiqsut iluqaitñiñ nunaaqqiñiñ tikiumasukhutiŋ sivuniġvigikkaŋatnun taapkua sivuatni. ");
INSERT INTO eskNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus niukami umiamiñ tautuŋniqsuq iñugiaktuanik iñuŋnik. Iḷunŋutchaŋniqsuq atriḷiutiplugich ipnaiyaatun munaqsraiḷaatun. Tavra Jesus-ŋum iḷisautiuraaġatasrugruŋniġai. ");
INSERT INTO eskNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Uvluqpaguqman maliġuaqtaiñ utlaŋniġaat Jesus nipliutiplugu, “Manna nayukkaqput iñuitchuq, suli unnuaqsiyaa. ");
INSERT INTO eskNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aullaqtitkich iñuich nunaaqqiuranun. Tauqsiġiaġlich niqiksraġmiknik.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tarra Jesus-ŋum kiuniġai, “Aatchuqsigik niqiksraŋitñik.” Taapkua apiqsruġniġaat, “Qaqquqsitquvisigut malġuk tallimakipiak akiksraŋaknik niġipkautiksraŋatnik?” ");
INSERT INTO eskNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus-ŋum nipliutiniġai, “Qanutunmi samma qaqqiaŋuraqaqpisi? Iḷitchuġiniurallaktiġitchi.” Iḷitchuġikamitruŋ Jesus uqautigaat, “Paqittugut tallimanik qaqqiaŋuranik suli malġuŋnik iqaluŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tiligai iñuich aquvititquplugich ivigaamun. ");
INSERT INTO eskNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tavra tallimakipiaŋutqataaqługich suli malġukipiaq qulitqataaqługich aquvititkaich. ");
INSERT INTO eskNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tiguniġai tallimat qaqqiaŋurat suli malġuk iqalugauraak, aaġluqhuni qiḷaŋmun quyyatiplugich. Aasiiñ avguqługich qaqqiat suli iqalugauraak qaiññiġai maliġuaqtimiñun autaaquplugich tamatkunuŋa niġisuktuanun. ");
INSERT INTO eskNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iñuich niġiñiaġniqsut, iluqatiŋaasiiñ niġisuiḷḷapiaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Niġisuiŋanikmata katinniġaich qulit malġuk aguupmaich iḷakunik imalgich. ");
INSERT INTO eskNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Taapkunani niġiruani 5,000-ŋuniqsut aŋutit. ");
INSERT INTO eskNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Niġianipqauraqmata maliġuaqtai aullaqtitkai umiakun sivumiñi narvam igḷuanun, amuŋa nunaaqqiuramun Bethsaida-mun. Aasii taatnaanikami aitquniġai taapkua iñugayaat. ");
INSERT INTO eskNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Suli aullaqtitkanikamigich mayuġniqsuq iġġimun agaayutyaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Qaumauraaŋŋaan unnuksraaqman umiaq iḷiñiqsuq qitqanun narvam, Jesus kisivlipkaqługu nunami. ");
INSERT INTO eskNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Qiñiġniġai sakuullapiaqhutiŋ iputtuat atakkii paaqługu anuġi. Tamaaniguuq uvlaatchauraġuqman pisuktuaġniqsuq qaaŋagun imġum. Qaaŋiqsaġumaruatun piñiġai. ");
INSERT INTO eskNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tautuŋniġaat iḷisaġipmiñagulu pisuktuaqtuaq qaaŋani imġum. Aliuqtuaqsiñasugiplutiŋ nipliagaqsiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Qiñiqamitruŋ iluqatiŋ tataminniqsut. Qilamik Jesus-ŋum nipliutigai, “Quviatchauġigitchi, uvaŋauruŋa, iqsiñasi.” ");
INSERT INTO eskNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tarra utlaŋniġai ikipluni umiamun, aasii anuġaiqhuni. Taapkua quviġutchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tautukkaluaqługu Jesus niġipkaipman qaqqunik iñugiaktuanun kaŋiqsimalguiññiġaatsuli kisuutilaaŋa, ukpiġilguitḷugu tavrakii. ");
INSERT INTO eskNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taapkua ikaaqługu narvaq tulaŋniqsut Gennesaret-mun. ");
INSERT INTO eskNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Niukamiŋ umiamiñ iñuich iḷisaqłiġutiniġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iglauniqsut iluqaani nunami Jesus-muutriaqsipḷutiŋ atniġñaqtuanik akiyaqhutiŋ siñigviksuummaisa iḷitchuġikamitruŋ Jesus sumiitilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Napmupayaaq Jesus nunaaqqiuramukman suli nunaqpaŋmun iñuich aggiutruġniġaich atniġñaqtuat iḷḷiuqaqługich tumitchaanun apqusaagaksraŋiñun Jesus. Tamatkua iñuich iŋiqsruġniġaat Jesus atniġñaqtuat aksiḷḷaŋniaġukługuunniiñ atnuġaaŋa. Aasiiñ taatnaqamitruŋ nakuqsiraġautiginiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tavra iḷaŋisa Pharisee-ŋuruat suli aglaliqirit aggiqsuat Jerusalem-miñ utlaŋniġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tautuŋniġaich Jesus-ŋum maliġuaqtit iḷaŋisa niġiruat iġġuġaluaqnagich argatiŋ Pharisee-ŋuruat piraksriutaatitun iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisee-ŋuruat suli atlat Jew-ŋuruat niġiḷḷaiññiqsut iġġuġaluaqnagich argatiŋ, kamagiplugu iḷisauttutaat sivulliaġikkaġmiŋ iŋiḷġaanimakŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aikamiŋ tauqsiġñiaġviŋmiñ sunik niġiḷḷaiññisut iġġuġaluaqatiŋ. Suli iñugiaktuat piraksriutiŋich aapamiŋ maliġutmigaich itnatun ittuat, iġġuġlugich qallutit suli utkusiich suli puggutat. ");
INSERT INTO eskNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tavra Pharisee-ŋuruat suli aglaliqirit apiqsruġniġaat Jesus, “Suvaata maliġuaqtitin maliġutiŋitpat iḷisauttutigikkaŋitñik sivulliapta, niġipḷutiŋ qaqqianik iġġuġniġiḷaanik argaŋmiknik?” ");
INSERT INTO eskNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus nipliutigai, “Ukpiŋŋuaqtauruasii, Isaiah sivuniksriqiri nalauttuq uqaqami ilipsigun, itnaqhuni, Iñuich kamaksrulgugaluaġaatŋa uqałhiñaġmiktigun aglaan uummatiŋich uŋasiksut uvamniñ piqpagillapianġitḷuŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kamaksruutaat uvamnun taŋiġiḷaaŋuruq atakkii iḷisautrirut iñuich iḷisauttutaitñik iḷipḷugich maliġutaksraġiruatun Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kamagiŋitkaluaġisi tillisai Agaayyutim, aglaan kamaksripḷusi ilitqutchiñik iñuknitŋaqtauruanik.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus-ŋum nipliutipsaaġniġai, “Yaiy, nalunġitkaluaġniġiksi qanuq ayaksimaałiksraŋat tillisai Agaayyutim. Iḷisimagaluaqługu atuumaniaqtaksrauruaq Agaayyutim pisułhagun kamagiraġiŋitkisi aglaan iḷisauttutisi malikkisi. ");
INSERT INTO eskNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses tilisiñiqsuq, ‘Kamagiyumagiñ aapan suli aakan’ suli ‘Kiñaimña uqapiḷuutriruaq aapamiñik suli aakamiñik tuqqutaksraupiaqtuq’. ");
INSERT INTO eskNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aglaan itna iḷisautrirusi iñuum nipliutiłhiñauplugik aŋayuqaaŋni ‘Corban’ (mumiutiqaqtuaq ‘Ikayuġukkaluaġiptik aglaan qaiñŋaniktuŋa Agaayyutmun’). ");
INSERT INTO eskNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Taatnaqamigguuq patchisaiyaġniraqtuq ikayuił̣iksraġaluaġmiñik aŋayuqaaŋmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Taatnaqapsi ayakkisi uqałhi Agaayyutim taavrumuuna iḷisauttutipsigun. Suli iñugiaktuat atlat iḷisauttutipsi atuumanġiġaġigisi.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Uumaguuq tuqłuġniġai iluqaisa iñuich iŋmiñun nipliutiplugich, “Naalaġniḷḷaksitŋa, kaŋiqsiyumausi! ");
INSERT INTO eskNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Isaaġaqtuaq iñuŋmun siḷataaniñ qaayuġnaqsiraġutauŋitchuq aglaan samna anniuġaqtuaq uummatmiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kiña iñuk siutiqaqtuaq tusaali.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus-ŋum unitñamigich iñugayaat isiġniqsuq tupiġmun. Maliġuaqtaiñ kaŋiqsimasrukhutiŋ apiqsrulgiññiġaat taavrumuuna atrikusautikun. ");
INSERT INTO eskNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Suakataġniġai, “Kaŋiqsiḷḷaiññiaqpat! Tusaaŋitchuatun! Uvvaami qanutchim siḷataaniñ isaaġaqtuam qaayuġnaqsiraġaŋitchaa iñuk. ");
INSERT INTO eskNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Atakkii isaaġaqtaŋitchuq uummataanun aglaan aqiaġuanun anipḷuniasiiñ timimiñ.” (Jesus-ŋum nipliutigikmauŋ taamna niġiñaqsigai niqipayaurat.) ");
INSERT INTO eskNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Niplipsaaqtuq, “Sagviqsiqataqtuam iñuŋmiñ taavruma qaayuġnaqsiraġigaa iñuk. ");
INSERT INTO eskNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Samakŋa anniuġaġaqtut uummataaniñ iñuum, pigiitchuat isummatit: sayuŋałiq iḷaqataunnani, tigliyułiq, iñuaqtułiq, ");
INSERT INTO eskNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","atlatułiq, kaviuġutiqałiq, pigiiḷiqiłiq, kinnitñiłiq, iŋmiñun aŋalalguił̣iq, saŋiaktułiq, uqaġniqłuktałiq, kamanaġasrugiłiq, kinnaŋaałiq. ");
INSERT INTO eskNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iluqatiŋ taapkua pigiitchuat sagviġaqtut iñuŋmiñ, qaayuġnaqsipḷuguasiiñ taamna iñuk.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tavrakŋa Jesus aullaġniqsuq tuŋaanun Tyre-m suli Sidon-ŋumlu. Isiġniqsuq tupiġmun nalutqugaluaqhuni iñuŋnun. Aglaan naluŋiḷgiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uvvauna aġnaq paniuraqaġniqsuaq irrusiqł̣uliŋmik. Tusaaniġaa imma Jesus tikiumanipḷugu. Utlakamiuŋ purviginiġaa isigaiñun. ");
INSERT INTO eskNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aġnaq Jew-ŋuŋitchuq, animapluni Phoenicia-mi Syria-mi ittuami. Taavruma iŋiqsruġniġaa irrusiqł̣uk anillaŋniaquplugu paniuraġikkaġmiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aglaan Jesus-ŋum nipliutigaa atrikusautmik, “Iḷiḷgaat sivulliulugu niġisuiqsuksraurut. Nalaunŋaŋitchuq iḷiḷgaat qaqquksraŋat aatchuutigiłiksraŋat makunuŋa qipmiñun.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aġnam kiuniġaa, “Aa tarraami, Ataniiq, naagaunniiñ qipmich niġġiviich ataatni niġisuupmiut kanġaniŋitñik iḷiḷgaat.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ilaan nipliutiniġaa, “Aarigaa, kiusriḷḷautaqtutintarra, ikayuġisigikpiñ. Aggiiñ, taamma irrusiqł̣uk aniruq paniuraġikkaqniñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Taavruma aikami paqinniġaa paniuraġikkani nalauraaqtuaq siñigviŋñi, irrusiqł̣uqaġniaŋitchalukut. ");
INSERT INTO eskNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tarra Jesus aullalgiññiqsuq avataaniñ Tyre-m Sidon-kuaqhuni utlautipluni narvaŋanun Galilee-m, apqusraaqługu nunakun atilikun Decapolis-mik. ");
INSERT INTO eskNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iñuich Jesus-muutilgiññiġaat iñuk tusaallaitchuaq suli uqallaitmisigalugu. Tarra iŋiqsruġnigaat patiglugu argaiñik iłuaqsitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tavra uŋavaqtaaġutillaŋniġaa iñugaaġruŋniñ. Iḷipḷugu tikiġikkani siutaŋnun suli tivvuaqtuqługich aksiŋñiġaa uqaġikkaŋa iłuaqsisukługu. ");
INSERT INTO eskNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aaġluqhuni qiḷaŋmun aniqsaaqpaŋniqsuq nipliqhuni, “Ephphatha” (mumiutiqaqtuaq “Aŋmaġiñ”). ");
INSERT INTO eskNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tavrakŋatchiaq siuttak aŋmaġniqsuk suli uqaŋa iłuaqsipḷuni, uqaaqsipḷuniasiiñ kaŋiqsiñaqsipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus-ŋum tiliñiġai uqaquŋitḷugich, aglaan iñiqtiġaluaqtitlutiŋ uqapsaaġniqsut tamarrumuuna uuma savaaġikkaŋagun. ");
INSERT INTO eskNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Quviġutchallapiaġniqsut nipliqhutiŋ, “Ilaa savaaqaqtuq supayaamik piḷḷautaqługu: tusaallaiḷaat tusaatlasipḷugich suli uqallaitchuat uqatlasipḷugich.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Taipkunani uvluni iñugiaktuat iñuich katiniqsut. Niqiksraitmata, Jesus-ŋum tuqłuġniġai maliġuaqtini iŋmiñun, aasii nipliutiplugich, ");
INSERT INTO eskNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Uvaŋa iḷunŋugigitka iñugiaktuat iñuich, atakkii nayuutirut uvaptikni piŋasuni uvluni niqiksraigutiplutiŋaasiiñ; ");
INSERT INTO eskNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","uvaŋa aullaqtitkupkich niġipkaġaluaġnagich iliŋich taaqtukkaġisirut apqutmi. Iḷaŋich aggiġñiqsut uŋasiksuamiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jesus-ŋum maliġuaqtaiñ kiuniġaat, “Nakikŋami maani iñuiḷaami qaqquqtuġisivat taatnatun iñugiaktigiruat iñuich niġisuiġutiŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tarra apiqsruġniġai, “Qapsiñik qaqqiaŋuranik piqaqpisi?” Kiuniġaat, “Tallimat malġuŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tarra tiliñiġai iñuich aquvitquplugich nunamun; aasiiñ tigukamigich tallimat malġuk qaqqiaŋurat quyyavigiqqaaqługu Agaayyun, avguqługich qaqqiat qaiññiġai maliġuaqtimiñun autaaġutigitquplugich iñuŋnun. Aasiiñ piñiġaat taamna. ");
INSERT INTO eskNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Taapkua piqaqmiñiqsuttuuq mikiruuranik iqalugauranik. Jesus-ŋum quyyatiplugich tiliñiġai maliġuaqtini tamatkuaptuuq autaaġutigitquplugich. ");
INSERT INTO eskNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iluqatiŋ iñuich niġiñiqsut niġisuiġataqhutiŋ. Maliġuaqtit iḷakut pukukmatigich immiġñiġaich tallimat malġuk aguupmaich. ");
INSERT INTO eskNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Taapkua niġiruat iñugiaktilaaqaġniqsut 4,000 iñuich. Jesus-ŋum aipkaqqaaqługich ");
INSERT INTO eskNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ikiniqsuq umiamun maliġuaqtiniḷu tiksiqhutiŋ nunaŋanun Dalmanutha-m. ");
INSERT INTO eskNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee-ŋuruat aggiqhutiŋ uqavaaġutiaqsiḷgiññiġaat Jesus uuktuaqsaġukługu, “Savaaqaġiñ quviqnaqtuamik. Taavrumuuna iḷitchuġipkaġumigaatigut Agaayyutim tuyuġipiałhanik ilipnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aniqsaaqpagataqhuni Jesus-ŋum qatmigiliutiniġai nipliqhuni, “Uvvali ukua tautugukamiŋaglaan quviqnaqtuamik! Nipliutigipsi, Makua iñuich tautukkumiñaitchut quviqnaqtuanik savaanik nalupqinaiġutaulugu kisuutilaamnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Taatnaqqaaqhuni uniŋñiġai. Ikipluniasiiñ umiayamun aullaġniqsuq taavruma narvam siñaan igḷuanun. ");
INSERT INTO eskNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Maliġuaqtai aullaqamiŋ piiguqtiġniqsut qaqqumikunniiñ aglaan atausił̣hiñaq qaqqiaŋuraq taquaġiliġniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus-ŋum tiliñiġai, “Qaunagiyumausi puvlaksautaatniñ Pharisee-ŋuruat suli puvlaksautaaniñ taavruma Herod atanġum.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taapkua uqaqtuyaagaqsiñiqsut avatmun, “Una uqaqtuq taavrumiŋa taquaŋitñapta qaqqiamik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus-ŋum iḷisimalgiññiġai kaŋiqsitḷaił̣hatigun. Uqaqtuaq iḷisautrił̣hatnik Pharisee-ŋuruat suli suraġałhanik Herod-ŋum, taapkuali uqaqhutiŋ taquaŋił̣iġmiknik qaqqumik. Taatnaqhuni apiqsruġniġai, “Suvaata uqaqtuyaagaqsiḷgitpisi akunnapsitñi qaqqumik taquaŋiññipḷusi? Kaŋiqsiŋitpisisuli? Puqiisigivisi taatnatun? ");
INSERT INTO eskNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Iriqaġaluaqhusi qiñilguitchusi suli siutiqaġaluaqhusi tusaalguitchusi. Itqaġiŋiññiqpisiuŋ tallimat qaqqiat niġipkautikapkich 5,000 iñugiaktilaaliŋnun? Qapsiñik aguupmaŋnik immiuvisi iḷakunik katitchikapsi?” Tamatkua kiuniġaat, “Qulit malġuŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Suli niġipkautikapkich tallimat malġuŋnik qaqqiat 4,000 iñugiaktilaaliŋnun aasiiñ iḷakugikkaŋich pukukapsigich qapsiñik immiuvisi aquupmaŋnik?” Tamatkua kiugaat, “Tallimat malġuŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ilaan nipliutigai, “Suvaatami kaŋiqsiḷguitkaqsiḷgitpisi?” ");
INSERT INTO eskNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tikitmata Bethsaida-mun, tavruŋautiniġaat qiñitlaitchuaq iñuk iŋiqsruqługuasiiñ iłuaqsitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus-ŋum tiguplugu qiñitlaitchuaq iñuk argaigun, tasiuqługu annisiniġaa nunaaqqimiñ. Aasiiñ tivvuaqtuqqaaqługik irrak patiŋniġik argaŋmiñik nipliutipluguasii, “Sumik qiñitlasiñiqpich?” ");
INSERT INTO eskNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iñuk tautuŋniagaqsiñiqsuq nipliqhuni, “Uvaŋa tautukkitka iñuich atriqaqługich napaaqtunik pisuktuatun.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus-ŋum iḷitqiŋñiġai argagikkani irraknun, taututqiksaqamiasiiñ taamna iłuaqsiñiqsuq. Takpiksiḷiġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Qiñitlasipkaanikamiuŋ Jesus-ŋum uqautiniġaa, “Aiḷḷaaġiñ, aglaan nunaaqqimun utiqtiġniaġnak.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus aullaġniqsuq piqatigiplugich maliġuaqtini nunaaqqiñun qaniŋanun Caesarea Philippi-m. Igliqtuałiġmikni apiqsruġniġai, “Kisuunivatŋa makua iñuich?” ");
INSERT INTO eskNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tamatkua kiuniġaat, “Iḷaŋisa iñuich John Paptaaqtitchiraunipḷutin, iḷaŋisa Elijah-ŋunipḷutin, atlatlu sivuniksriqiraunipḷutin iŋiḷġaanimma, itna uqaġaqtut.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ilaan nipliutigai, “Ilipsimi kisuunivisitŋa?” Peter-m kiuniġaa, “Christ-ŋurutin Agaayyutim akiqsruutigikkaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus-ŋum tiliñiġai uqautitquŋitḷugu kimun-unniiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tavra Jesus-ŋum iḷisautiuraagaqsiñiġai maliġuaqtini, “Iġñiŋa Iñuum nagliksaaqtuksrauruq, suli sivulliuqtiġruat suli qaukłiŋisa agaayuliqsit suli aglaliqirit ayakkisigaat. Tuqutkisigaat, aglaan piñayuakun uvlut aŋipkakkaugisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nalupqinaiyautigai tamatkuniŋa. Peter-m saniqpaktaaġutillakługu uqautiniġaa Jesus taatnatchiñik uqaquŋitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus-ŋum takullakkaluaqamigich maliġuaqtini iñiqtiġniġaa Peter, “Tuunġaaq, aullaġiñ uvamniñ atakkii isumaŋitchutin Agaayyutim isummasianik aglaan iñuich isumaŋatnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesus-ŋum tuqłuqmiñiġai iñugayaat iŋmiñun maliġuaqtimiñunlu nipliutiplugich, “Kisupayaam maligukkumiña suksraaqtaksraġigaa pisułłi, iqsriutilugu sanniġutani aasiiñ maligluŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Atakkii kisupayaam anniġiniaġumiuŋ iñuułłi tammaigisigaa aglaan kisupayaam tammaiyumiuŋ iñuułłi pigiluŋa suli pigilugu tusaayugaallautaq anniqsuġiakun, taamna iñuugisipiaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iñuum piññaktaaġiłhiñaugaluaġaa suurapayaaŋa marruma nunam, aglaan tammautigisigaa iñuutchii. Sakuuŋuraġniałha atuġumiñaitchuq sumun. ");
INSERT INTO eskNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tarra simmiutiksraitchaa iñuum iñuutchii. ");
INSERT INTO eskNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iḷapsi kanŋugivalukkaatŋa iḷisauttutitkalu sivuġaatni iñuich killuuruat sayuŋaruatlu. Taatnatun Iġñiŋan Aŋutim kanŋugigisipmigaaptuuq utiġumi kamanautiqaġuni aapamisun piqasiġuni ipqitchuanik isaġuliŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Suli iḷaniġai uumiŋa, “Iḷumutuuruamik nipliutigipsi, Iḷaŋich marra iñuich tuquyumiñaitchut qiñiŋaiñŋaan Agaayyutim aŋaayuqautaa saŋŋigun.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kiñuagun itchaksrat uvlut Jesus-ŋum kayuŋiġñiġai Peter-lu, James-lu John-lu aasii sivulliaqsipḷugich iġġimun kisiisa. Qiñiqtitlugich Jesus atlaŋŋuġniqsuq sivuġaatni. ");
INSERT INTO eskNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Atnuġaaŋi qivliqisirauraqhutiŋ qatiqsipḷutiŋ aniutun, kia-unniiñ nunami salummaġumiñaitkai qatiqsitḷuglugich. ");
INSERT INTO eskNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tavrakŋatchiaq tamatkua qiñiġmiñiġaich Elijah-lu Moses-lu uqaqatigiaqsipmatku Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tarra Peter-m nipliutiniġaa Jesus, “Iḷisautrii, nakuunayaqtuq uvani ittuiñaġupta. Nappaitquguptigut nappaiñayaqtugut piŋasunik palapkaaksranik, atautchimik ilipnun, atautchimik Moses-mun suli atautchimik Elijah-mun.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter qanuġviiḷḷapiaġniqsuq tupaŋapluni, taatnaqhuni iḷisimanġiññiqsuq sumikunniiñ uqaġikkaġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Taatnaqsaqtitlugich nuviyam qulaŋiutiniġai. Nipi nuviyamiñ tusaġnaqsiñiqsuq itnaqhuni, “Taamna ilaaŋuruq piqpagikkaġa Iġñiġa, naalaġniyumagiksi!” ");
INSERT INTO eskNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taapkua alaqtaaqsikmata iḷagikkak qiñiġnaiŋaniktiġniqsuk. Qiñiłhiñaġniqsut kisianik Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Iluqatiŋ atqaaqsikamiŋ taavrumakŋa iġġimiñ Jesus-ŋum tiliñiġai uqautigitquŋitḷugich qiñikkaŋit Iġñiŋan Aŋutim aŋitqił̣hanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tamatkua tusaakamitruŋ tillisaa qanuqsaġviitkaluaqhutiŋ apiqsruqtuutiaqsiñiġaat avatmun, “Qanuutauruaq una aŋitqił̣iq tuqumiñ pivauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tavra apiqsruġniġaat Jesus, “Suvaata aglaliqirit uqaġuuvat Elijah aggiqsuksraunipḷugu sivulliuluni?” ");
INSERT INTO eskNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kiuniġai, “Tavra Elijah aggiqqaaġniaqtuq Christ-miñ itqanaiyaġlugich supayaat. Uvvasuli aglausimaruaq Iġñiŋa Iñuum nagliksaallapiaqtuksraugisiñipḷugu suli suksraġinġiġisiñipḷugu iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aglaan nipliutigipsi, Elijah aggianiktuq. Iñuichaasiiñ aŋallaqłukkaat qanupayaaq, tuvraqługu aglausimaruaq ilaagun.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tamatkua utiqamiŋ atlanun maliġuaqtaiñun tautuŋniġaich iñugayaat suli aglaliqirit uqavaaqtuat maliġuaqtinun. ");
INSERT INTO eskNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iñuich tautukamitruŋ Jesus quviġusullapiaqhutiŋ aqpaliqsruqhutiŋ ilaanun paaġniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ilaan aglaliqirit apiqsruġniġai, “Sumik uqaqtuyaaġutiqaqpisi?” ");
INSERT INTO eskNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iḷaŋata iñugaaġruich nipliutiniġaa, “Iḷisautrii, tikiutriruŋa iġñiġikkamnik irrusiqł̣uqaqhuni uqatlaiqsitlugu pitchaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Irrusiqł̣uum aŋalataġipmagu ulġutkaa nunamun. Ilaa qiluraġallapiaġaqtuq, innuliqipluni qaniġmigun, tiriquulaplugich kigutini suli tikkaksiḷḷapiaqhuni iluqaġmi tuquruatununniiñ. Uqautigaluaġitka maliġuaqtitin anitquplugu aglaan taatnalguiññiġaat.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tavrali Jesus-ŋum nipliutiniġai, “Aatai, ukpiqqutaiññiaqpat ilipsitñi! Qanutunaglaansuli nayuġniaqpisi? Qanutunaglaan igḷutuqtaksraġivisi? Taamna nukatpiaq uvuŋautisaqsiuŋata.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iñuich Jesus-muutiniġaat. Irrusiqł̣uum tautupqauraqamiuŋ Jesus, nukatpiaġruk qiiqsruqtitkaqsiñiġaa. Ulġupluni nunamun aksralikhuni innuliqiaqsiñiqsuq qaniġmiñi. ");
INSERT INTO eskNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus-ŋum apiqsruġaa aapaŋa, “Qaŋaaglaan taatnaiḷiva?” Taavruma nipliutigaa, “Imma iḷiḷgauraułiġmiñiñaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Akulaiqł̣ugu irrusiqł̣uum tuqunniaqsimagaa igitqataqługu ikniġmun suli imiġmun. Pitḷagupku suraġallaŋniaġuqtuq! Iḷunŋugillaŋniaġuta ikayuqtigut!” ");
INSERT INTO eskNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus-ŋum uqautiniġaa, “Arguasuktuksrauŋitchutin pitḷaniḷuŋa. Ukpiqsrił̣hiñaġuvich supayaaq pił̣hiñauruq!” ");
INSERT INTO eskNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tavrauvaa aapaŋa iḷiḷgaam kappiaŋaruq nipliqhuni, “Ataniiq. Ukpiqtuŋa. Ikayuŋŋa ukpiqsrisiqatluquluŋa!” ");
INSERT INTO eskNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus-ŋum qiñiġai iñuich utlaktigikkani. Iñiqtiġaa irrusiqł̣uk itnaqhuni, “Uqallaitchuaq suli tusaallaitchuaq irrusiq, anitqugikpiñ uumakŋa nukatpiaġruŋmiñ, aasiiñ isitqisuŋaqnak.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Irrusiqł̣uk iġiallaksaqtuq qiluraġaqtitlugu taamna nukatpiaġruk, aasiiñ uulillaktitlugu aniruq ilaaniñ. Taamna nukatpiaġruk tuquŋaruatun iḷiḷiqtuq. Iñuich uqaaqsiñiqsut, “Ilaa tuquliqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aglaan Jesus-ŋum tiguplugu argaigun ikayuqługu makitinniġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus isianikman tupiġmun maliġuaqtaiñ apiqsruġniġaat kisiŋŋuġuutiplugu, “Suvaata aniḷguitpisigu taamna irrusiqł̣uk?” ");
INSERT INTO eskNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ilaan kiuniġai, “Agaayułhiñałikun piḷiqillapiaqhuni uisauraałikunlu anitlagaa taatnasiq irrusiq.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Taavrumakŋaqhutiŋ Galilee-kuaġniqsut. Iḷisimatquŋiññiġaa kimun-unniiñ naniitilaani, ");
INSERT INTO eskNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","atakkii iḷisautrisukhuni maliġuaqtimiñik, itna, “Iñuich tigugisigaat Iġñiŋa Iñuum tuqulluguasiiñ. Tuqqutauŋanikkumi piñayuakun uvlut taamna aŋitqikkisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aglaan maliġuaqtaiñ kaŋiqsiŋiññiġaat uqaaqtuutigikkaŋa, taluqsraqhutiŋaasiiñ apiqsruaġalguiññiġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tavra tikiññiqsut Capernaum-mun. Tupiġmiillaġmiŋ Jesus-ŋum maliġuaqtini apiqsruġniġai, “Sumik uqaqtuyaaġutiqaqpisi iglaułłaptikni?” ");
INSERT INTO eskNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kiuŋiññiġaat atakkii iglaullaġmiŋ uqaqaqhutiŋ avatmun nalliġmiknik kamanaġniqsrauniaqmagaan. ");
INSERT INTO eskNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ilaan tarra aquvitluni tuqłuġniġai qulit malġuich maliġuaqtigikkani nipliutiplugich, “Kiña iñuk sivulliusukkumi aqulliuruksrauruq savaktiġuqmiḷuni iluqaŋitñun.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aasii qiññuaġniġaa iḷiḷgaaq inillakługu akunġatnun, saġliriutiplugu itnaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kisupayaam akuqtuġumiuŋ iḷiḷgaaq pisigiluŋa akuqtuġaaŋa, suli kisupayaam akuqtuġumiña akuqtuġumiñaitchaaŋa uvaŋałhiñaq aglaan akuqtuġaa taamna tuyuġirigikkaġa.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John-ŋum Jesus nipliutiniġaa, “Iḷisautrii, qiñiġikput una anitchiraġiiruaq irrusiqł̣uŋnik atuqługu atqiñ. Taavruma iñuum maliġuaŋitmigaatigut. Uvvaasiiñ iñiqtiġikput atakkii maliġuaqtigiŋitḷugu uvaptikni.” ");
INSERT INTO eskNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aglaan Jesus-ŋum nipliutiniġai, “Nutqaqtitnasiuŋ atakkii iñuum savaaqaqtuam quviqnaqtuanik atuqługu atiġa uqautigiyumiñaitkaaŋa pigiiḷiḷuŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Akitñaqtuqtiŋitchuaq uvaptiknun iḷagillapiaġikput. ");
INSERT INTO eskNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nipliutigipsi, kisupayaam aatchuġumisi qallugauramun imiksrapsitñik Christ pigipmasi akiḷḷiusiaġitlasipiaġisigaa. ");
INSERT INTO eskNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kia iñuum killuqsaqusaaqpagu iḷaŋat makua ukpiqsrisiqaqtuat uvamnik iḷiḷgaatun, nakuutlukkayaqtuq taamna quŋisiġmiutchiġḷugu uyaġakpaŋmik ipipkaqpan taġiumi. ");
INSERT INTO eskNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Suli argakpich killuqsaqtitpatin piiġumagitin. Iłuatlukkayaqtuq ilipni isiġuvich iñuułiġmun argaiḷḷutin uumakŋa argaqaġutin igḷuktun aullałiksraqniñ anasiñŋuqsaġviŋmun ikniġmun qamitlaiḷaamun. ");
INSERT INTO eskNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tavrani qupilġut tuquyumiñaitchut suli ikniq qamiyumiñaitmiuq. ");
INSERT INTO eskNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Naagasuli isigakpich killuqsaqtitpatin piiġumagitin. Iłuatlukkayaqtuq isiġuvich iñuułiġmun isigaiḷḷutin uumakŋa isigaqaġutin igḷuktun iktaułiksraqniñ anasiñŋuqsaġviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tavrani qupilġut tuquyumiñaitchut suli ikniq qamiyumiñaitmiuq. ");
INSERT INTO eskNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Suli ilvich irigikkaqpich killuqsaqtitpatin piiqsiġumagiñ qaquliġlugu. Iłuatlukkayaqtuq ilipni isiġuvich aŋaayuqautaanik Agaayyutim atautchimik iriqaŋŋaqpich uumakŋa malġuŋnik iriqaġutin iktaułiksraqniñ anasiñŋuqsaġviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tavrani qupilġut tuquyumiñaitchut suli ikniq qamiyumiñaitmiuq. ");
INSERT INTO eskNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Maaniḷi iñuk iŋmiguuraq makitalgutillaakkaugisiruq iknikun. ");
INSERT INTO eskNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Taġiuq nakuuruq, aglaan taġium taġiuġniiqpan qanuq taġiuġniḷiġñiaqpisiuŋ? Taatnamik qanusriułiqaġitchi taġiutun, tutqiutiqaġusi akunnapsitñi.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus aullaqami tavrakŋa Judea-muŋniqsuq igḷuanun Jordan-ŋum kuuŋan. Tavrani iñuich katirvigilgitmatni sivuanisun Jesus-ŋum iḷisautiuraagaqsiḷgiññiġai. ");
INSERT INTO eskNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iḷaŋich Pharisee-ŋuruat tikitḷugu uuktuaqsaġniaġalualgiññiġaat, “Uvva, maliġutaksrakuaġnaqpa iñuum avitkumiuŋ aġnaqtiŋ?” ");
INSERT INTO eskNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Taavrumali kiuniġai apiqsruutmik, “Qanuġmi Moses-ŋum tillisiqaqpasi?” ");
INSERT INTO eskNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tamatkua kiugaat, “Moses aglausimaruq, Iñuum aġnaqtiŋ avitchukkumiuŋ qaitchiqiliuŋ aglaŋnik avirrutiksranik aullaqtilluguasiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus-ŋum kiuniġai, “Moses qaitchiruq taavrumiŋa tillitmik pitchiġiił̣ipsigun. ");
INSERT INTO eskNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aglaan aullaġniił̣hani Agaayyun iñiqsipman supayaanik iñiqsipmiñiqsuq aŋutmik suli aġnamik. ");
INSERT INTO eskNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Taatnamik aŋutim unitkisigaa aapaniḷu aakaniḷu, aġnamiknun iḷiḷuni atausiŋŋuġutikaasiiñ. Tavra malġuuŋŋaiġutik aglaan atausriŋŋuġisiruk. ");
INSERT INTO eskNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Taatnamik kia-unniiñ iñuum avitinniaqnagik Agaayyutim atautchimuktitaġikkak.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Isiqamiŋ tupiġmun maliġuaqtaiñ apiqsrutqiḷgiññiġaat taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus nipliutigai, “Kisupayaaq avitchumi aġnaġmiñiñ aasiiñ kasuutiluni atlamun atlatuqtuq akitñaġlugu aġnaqqaaqtiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Naagaqaa aġnam avitchumiuŋ aŋutni aasiiñ kasuutiluni atlamun taamna aġnaq atlatuqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iḷaŋisa iñuich iḷiḷgaat Jesus-muutiniġaich aksiquplugich. Maliġuaqtaiñaasiiñ iñiqtiaqsiñiġaich iñuich tikiutriruat iḷiḷgaanik. ");
INSERT INTO eskNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus-ŋum iḷitchuġikamigich iłuagiŋiññiġai. Nipliutiniġai, “Iḷiḷgaurat uvamnuktitchigik. Avriaqutaunagich iliŋitñun atakkii Agaayyutim aŋaayuqautaa aŋmaruq iñuŋnun atriqaqtuanun iḷiḷgaanik. ");
INSERT INTO eskNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Itqaġisiuŋ una! Taapkua akuqtuqtuat aŋaayuqautaanik Agaayyutim iḷiḷgaurat akuqtuipmatun, kisimiŋ taapkua tavruŋaġisirut.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tarra ilaan saġliriutikamigich iḷiḷgaat, iḷipḷugich argaŋni iliŋitñun agaayyutiniġai. ");
INSERT INTO eskNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus aullapqauraqman iñuum aqpaliqsruqhuni purviginiġaa itnaqługu, “Nakuuruaq iḷisautrii, qanuġluŋa piññaktaaqatlasiñayaqpik isuitchuamik iñuułiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus-ŋum apiqsruġniġaa, “Suvaata atchiqpiŋa nakuuruamik? Atautchił̣hiñaq nakuuruq, taamna Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Iḷisimagitin tillisauruat, ‘Iñuaqtuqnak, atlatuqnak, tigliktuqnak, saglunak, saglutaqnak, kamagilugu aapan suli aakan.’” ");
INSERT INTO eskNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Taavruma iñuum kiugaa, “Iḷisautrii, iluqaisa tamatkua tupigigitka nutaułłamniñaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tavra Jesus-ŋum tautuŋniġaa piqpaksrił̣ikun itnaqługu, “Atautchimik inuġniqsutin. Aullaġutin tunityakkich sulliñipayaaġikkatin aasiiñ qaiḷḷugich maniññaktatin inuqsraqtuanun. Ilviḷḷi umialgutiqaġumautin pakmani. Aasiiḷi taatnaanikkuvich maligluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iñuk tusaakami taavrumiŋa aliasuliġniqsuq, aasiiñ aullaġniqsuq iłuiḷḷiuliqhuni atakkii suuraupkaqpaitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus qiñiqtuaġataġaluaqamigich nipliutiniġai maliġuaqtini, “Qanutun sakiqnaqtigigisiva tamatkunani umialguruani isiłiksraŋat Agaayyutim aŋaayuqautaanun.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Maliġuaqtai quviġusuŋniqsut taavrumiŋa nipliqman. Aglaan Jesus-ŋum nipliutitqiŋñiġai, “Iḷiḷgaat, qanutun sakiqnaqtigiva umialguruani isiłiksraŋat Agaayyutim aŋaayuqautaanun. ");
INSERT INTO eskNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Qaġanatlukkayaqtuq pikukturuam isiłiksraŋa ‘Iraagun Mitqutim’ uumakŋa umialguruamiñ isiġniałiksraŋaniñ Agaayyutim aŋaayuqautaanun.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Maliġuaqtai quviġutchallapiaġniqsut, suli apiqsruaqsipḷutiŋ iŋmiknun, “Kiñami anniqsuġisiñiqpa?” ");
INSERT INTO eskNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus-ŋum qiñiqamigich iriġruiñaqługich nipliġñiqsuq, “Iñuk anniqsuġumiñaitchuq iŋmiñik, aglaan Agaayyutim kisimi anniqsutlagaa atakkii Agaayyutim supayaaq savaaġitlaplugu.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tavra Peter-m nipliutiniġaa, “Ataŋii, unitchikput sua iluqaan malikhutin.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesus-ŋum kiuniġaa, “Nipliutigipsi, Iñuk unitchiyumi kiŋuniġmiñik, aniaqatmiñik, aapamiñiglu aakamiñiglu, qitunġamiñik, unniiñ umialgutmiñik pigiluŋa suli pigilugu tusaayugaaġiksuaq, tamatkua utiġisirut iluqaitñik ilaanun tallimakipiatunaglaan marrumani iñuułiġmi piyuaqsiugaluaŋŋaġmiunniiñ, suli pigigisipḷugu isuitchuaq iñuułiq sivuniġmi tikiumaraksrani. ");
INSERT INTO eskNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tamatkua sivulliunasugiruat pakma aqulliġuġisiñiqsut aasiiñ aqulliuruat sivulliġuġutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ukua igliġniqsut tuŋaanun Jerusalem. Jesus-ŋum sivulliuqtuaġniġai maliġuaqtit kapyaliḷḷaktuat. Atlat iñuich maliqsruqtuat iqsiḷiḷḷaktut. Aasiiñ katitaallakamigich qulit malġuich iñugiaktigiruat uqautiaqsiḷgiññiġai tamatkua atuumaruaksrat iŋmiñun, ");
INSERT INTO eskNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","nipliqhuni, “Ataŋii, Jerusalem-muŋniaqtugut. Iñuum aatchuutiniaġaa Iġñiŋa Iñuum qaukłiŋitñun agaayuliqsinun aglaliqirinunlu. Tamatkua tuqqutaksraġuġniñiaġaat. Tavrali qaitkisigaat Jew-ŋuŋitchuanun. ");
INSERT INTO eskNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Taipkua mitautigigisigaat suli tivvuaqtuġlugu suli anaumigmiḷugu, aasiiñ tuqqutkisigaat. Aglaan piñayuakun uvlut aŋitqikkisiḷgitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","James-lu John-lu, iġñak Zebedee-m, utlautiniqsuk ilaanun nipliqhutik, “Iḷisautrii, apiqsruutiksraqaġiptigiñ pisullapiakkaptiknik.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tavra nipliutiniġik, “Suqaġukkaluaqpisik?” ");
INSERT INTO eskNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Taapkuak kiuniġaak, “Aquppiqasriġukhutin uvvaami iḷaqatikpuk taliqpikñi suli iḷaqatikpuk saumipni pigaluaqtuguk taivrumani uvlumi aquvitkuvich kamanaqtuani atanġuvipni.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aglaan Jesus-ŋum nipliutigik, “Iḷisimaniġuptiku apqusaagaksrautigikkaġa apiqsruġayaitpaluktutik taatna. Imiłhiñauvitku qallun imiġviksrautigikkaġa naagaqaa apqusaałhiñauvitku naŋinnaqtuaq apqusaagaksrautigikkaġa?” ");
INSERT INTO eskNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Taapkuak malġuk nipliutigaak, “Pił̣hiñauruguk.” Jesus-ŋum nipliutigik, “Iliptik iḷumutun imiġisirutik alianaqtuamik imigaksrautimnik suli apqusaaġisipḷutik naŋinnaqtuakun apqusaagaksrautipkun. ");
INSERT INTO eskNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aglaan piksraqtuksrauŋitchuŋa kimik aquppiruksramik taliqpimñi unniiñ saumimñi, aglaan Agaayyun qaiññiaġik taapkuak inik tamatkunuŋa iñuŋnun itqanaiyautikkaġmiñun inigitquplugik.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Atlat qulit tusaakamitruŋ iłuagiŋiññiġaich James-lu John-lu. ");
INSERT INTO eskNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus-ŋumli iŋmiñuutiniġai aasiiñ nipliutiplugich, “Iḷisimarusi aŋalatiŋich Jew-ŋuŋitchuat aŋalanniġlugaqtilaaŋatnik iñuŋitñik, suli kamanaġniqsraŋisa naqititchuuplugich. ");
INSERT INTO eskNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aglaan taatnatun ittuksrauŋitchuq akunnapsitñi. Kisupayaaq kamanaġukkumi akunnapsitñi savaktigiyumagiksi. ");
INSERT INTO eskNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Suli kisupayaaq qaukłiusukkumi akunnapsitñi savautrisuuyumauq iluqapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iġñiŋa Iñuum aggiŋitchuq iñuŋnun savautityaġuni aglaan savautrityaqhuni suli qaitchaqługu iñuułłi tasuqsautiksrauplugu iñugiaktuanun.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus maliġuaqtiniḷu tikiumaniqsut Jericho-mun. Aasiiñ aullalgitñamiŋ Jericho-miñ qiñitlaiḷaq iŋiulauraaġniaqti aquppiñiqsuq tumitchaam saniġaani, atilik Bartimaeus-mik iġñiŋa Timaeus-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Qiñitlaiḷam iḷitchuqłiqamiuŋ Jesus Nazareth-miu apqusaagaqsiñipḷugu tuqłuġaaqsiñiqsuq, “Jesus, kiŋuviaŋa David-ŋum, anniqsuqtaurutin Agaayyutim akiqsruutigikkaŋa iŋiḷġaanimma. Nagligillaŋniaŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iñugiaktuat iñiqtiġaluaġniġaat nipaisaaquplugu, aglaan nipitusipsaaġniqsuq, “Kiŋuviaŋa David-ŋum, nagligillaŋniaŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus nutqaqtiqami tiliñiġai tikiutitquplugu. Tamatkua utlaŋniġaat qiñitlaiḷaq nipliutiplugu, “Quviatchauġigiñ, makillutin. Tuqłuġaatin.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Quyaliqpagitḷuni maksrikami quppiġaaġniutigalugu aqpaqsruġniqsuq Jesus-mun. ");
INSERT INTO eskNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus-ŋum apiqsruġniġaa, “Suvaata akku tuqłullaviŋa?” Qiñitlaiḷam uqautiniġaa, “Iḷisautrii, qiñitlasitqigukkaluaqtuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Uuma kiugaa, “Itqanaiŋaniktiġniqsuq ukpiqsrił̣ipkun.” Tavrakŋatchiaq qiñitlasiñiqsuq. Nakuqsiḷiqami maliutigaluguuġniġaa Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Qaniŋani Jerusalem Jesus iglauqataiḷu qalliñiqsut nunaaqqiuraaŋnun Bethphage-mun suli Bethany-mun ittuaŋnun iñġiŋani atiqaqtuam Olives-mik. Jesus tuyuqaġniqsuq malġuŋnik maliġuaqtimiñik nipliutiplugik, ");
INSERT INTO eskNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Nunaaqqiuramukkitik. Taamuŋaasii isipqauraġuptik paqitkisigiktik pituksimaruaq nuġġaŋa natmaksiġvium natmaksiġvigimaiḷaq sivuani. Pituiġḷugu uvuŋautityatku! ");
INSERT INTO eskNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kia iñuum apiqsruqpatik suvaata pituiġñiaqmagaan nipliutiyumagiktik, ‘Atanġuruam inuġigaa aglaan utiqtitkisiyaa qilamik.’” ");
INSERT INTO eskNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Taapkuak tarra aullaġniqsuk. Paqinniġaak natmaksiġvium nuġġaŋa tumitchiani pituqaqtuaq paaŋani tupqum. Tarra pituiġñiġaak. ");
INSERT INTO eskNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Taatnalu iñuiḷḷi qichaqtuat tamaani nipliutigaik, “Ukuqtiik, suniaqługu una pituiqpitku?” ");
INSERT INTO eskNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aikł̣iqsuak taapkuak kiggutiniqsuk Jesus-ŋum tillisaatun. Iñuiḷḷi taapkua aullaqtinniġaich. ");
INSERT INTO eskNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Taapkuak taamna nuġġaq Jesus-muutiplugu, aasiiñ quppiġaatik mattaqługik iḷiñiġaik taavrumuŋa nuġġaġmun. Jesus natmaksiaqsiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iñugiaktuat iñuich quppiġaatiŋ siamitkaqsiñiġaich apqutmun, suli iḷaŋich akiġuiñik napaaqtum navguqługich iḷḷiuqaiñiqsut apqutmun. ");
INSERT INTO eskNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iñuich sivuagun Jesus-ŋum suli tamatkua aquagun nipruagaqsiñiqsut, “Hosanna. Nanġaġlakput Agaayyun! Uvvatuq Agaayyutim piḷiutiqaġliuŋ tikitchuaq piqusiqhuni Ataniġmik. ");
INSERT INTO eskNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Agaayyutim piḷiutiqaġliuŋ taamna aŋalatchiaqsiruaq pakma sivulliaptiktun David-tun. Nanġakkauli Agaayyun qutchiŋñiqsrami qiḷaŋmi.” ");
INSERT INTO eskNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Taatnatun Jesus Jerusalem-muŋniqsuq. Tavruŋaqami isiqhuni agaayyuvikpaŋmun, qiñiqtuagataġaluaqami aniñiqsuq. Tanuġaksipḷuni aullaġniqsuq Bethany-mun piqatigiplugich qulit malġuk maliġuaqtini. ");
INSERT INTO eskNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Uvlaakuqman iluqatiŋ pisuktuaqamiŋ Bethany-miñ Jesus niġisuliġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tautuŋniġaa asirrisuuruaq napaaqtuq uŋavaniñ akutuqpaliqaġniqman. Tarra takuniġaa asrirritmaŋaaġiaqługu. Tikitñamiuŋ suqaġnianġitchuq. Akutuqpalił̣hiñanik paqittuq atakkii pukuŋnaqsinġitḷunisuli. ");
INSERT INTO eskNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesus-ŋum nipliutigaa napaaqtuq, “Kia-unniiñ iñuum asiaqtuġvigitqikkumiñaitchaatin pakmakŋaniñaglaan.” Maliġuaqtaiñ tusaaniġaat taatnaqman. ");
INSERT INTO eskNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tikitñamiŋ Jerusalem-mun Jesus isilgitchuq agaayyuvikpaŋmun. Anitkaqsiḷiġniġai tunisiullaqtuat suli tauqsiqsuktuat taavrumakŋa agaayyuvikpaŋmiñ, ulġutqataqługiḷḷu niġġiviich akiñik simmiqsuġviich suli aquppiutaŋich tunisiullaqtuat tiŋmiaġruuranik tuniḷḷautiksrauruanik, ");
INSERT INTO eskNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","suli kiñaunniiñ akiyaqtitchumiñaiññiġaa tuniaksranik agaayyuvikpakuaġlugu. ");
INSERT INTO eskNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iḷisautiniġai iñuich, “Aglausimaruq, ‘Uvaŋa tupiġa taiyuutiqaġisiruq iñupayaat agaayutyaqtuġviatnik.’ Aglaan ilipsi iriqtuġviḷiutiniġiksi tigliŋniaqtinun.” ");
INSERT INTO eskNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Qaukłiŋich agaayuliqsit suli aglaliqirit tusaakamitruŋ taamna, pakaaġiaqsiñiġaat qanuq taimma piyaqquġukługu. Nuyuaġiliutiniġaat atakkii iluqatiŋ iñuich quviġusuutigiplugich Jesus-ŋum iḷisauttutai. ");
INSERT INTO eskNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Unnuksraaqman Jesus aullalgiññiqsuq nunaaqqimiñ piqatiqaqhuni maliġuaqtimiñik. ");
INSERT INTO eskNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Suli uvlaaġuqman apqusaaqamiŋ taututqiŋñiġaat asirrisuuruaq taimña napaaqtuq. Pannaqłuŋniqsuq kaŋituummaġmi. ");
INSERT INTO eskNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter-m itqaqtilgiññiġaa imña atuumaruaq aasiiñ nipliutiplugu Jesus, “Iḷisautrii, asirrisuuruaq napaaqtuq piuŋiḷḷaqsruqtikkan paniqtiġniqsuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus-ŋum kiugai, “Ukpiqsrisitchi Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iḷumutun uqautigipsi, Nipliutigupsiuŋ iġġiq, ‘Ki, nuutittin igitaulutiŋ taġiumun’ atuumagisipiaqtuq. Taamna nalupqinaitchuq. Ukpiġillapiaġupsiuŋ iluqnauġusi taatna atuumagisiniḷugu, tavra savaaŋupkałhiñaugiksi. ");
INSERT INTO eskNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Taatnamik nipliqsuŋa, qanutchipayaat kipiġniuġutigikkasi agaayyutigigupsigik ukpiġitchi akuqtuġiniḷugich, suli piginiaġisi. ");
INSERT INTO eskNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Agaayugupsi, natqigutimaaġumagisi iḷagikkasi qanutchimik akikŋaqtuutiqaġniġupsi. Taatnaġupsi aapagikkapsi pakmani ittuam natqigutimaaġisigaasi killuutipsitñik. ");
INSERT INTO eskNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Natqigutrisimaitkupsi iñuŋnik atlanik aapapsi pakmani ittuam natqigutiyumiñaitmigaasi killuutipsitñik.” ");
INSERT INTO eskNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Utitqikkamiŋ Jerusalem-mun, Jesus isiġniqsuq agaayyuvikpaŋmun. Qaukłiŋich agaayuliqsit suli aglaliqirit suli sivulliuqtiġruat tikiññiġaat ");
INSERT INTO eskNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","apiqsruqługu, “Kia aatchuqpatin aŋalatchił̣iġmik savautiplutin tamatkuniŋa? Kia saŋŋiksriññiqpatin taatnatun?” ");
INSERT INTO eskNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus-ŋum kiuniġai, “Apiqsruġniaġipsi atautchił̣hiñamik apiqsruutmik. Kiulgugupsitŋa uqautigisigipsi aŋalatchił̣ikun tamatkuniŋa savalgutilaamnik. ");
INSERT INTO eskNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nakitña John aŋalatchił̣inikpa ilaan paptaaqtitchisilaaŋanik? Agaayyutmiñ naaga iñuŋniñ? Uqautisitŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Taapkua uqqaaġiaqsiñiqsut iŋmiknun, “Kiuguptigu pakmakŋaktauniḷugu nipliutigisigaatigut, ‘Suvaatami ukpiġiññiqpisiuŋ John?’ ");
INSERT INTO eskNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naagaqaa uqaġumiñaitchugut aŋalatchił̣ha iñukmiqnisauniḷugu.” Iliŋisa sivuuġaginiġaich iñuich, atakkii iñupayaaq ukpiġipiaġniġaaq John sivuniksriqiraunipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Taatnagaluaqamiŋ kiułhiñaġniġaat Jesus, “Uqautilguiññiġiptiġiñ.” Jesus-ŋumli kiugai, “Uvaŋaptuuq uqautiyumiñaitmiñiġipsi nakikŋa aŋalatchił̣inikłuŋa tamatkuniŋa savaaqaqtilaamnik.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tavrali Jesus uqautriñiqsuq Pharisee-ŋuruanik atrikusautmik. “Unaguuq iñuk nautchiiviqaġniqsuq. Nautchirriġviḷiuġniqsuq, sapukutchiqł̣ugu avataagun, nivakhuni misuġuliuġviksramik, nappaipḷuni nasiqsruġviŋmik, tarraasiiñ atukkirrutigiplugu nautchirriqirinun, Taatnaanikami aullaġniqsuq uŋasiksaumun nunamun. ");
INSERT INTO eskNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Katitchiñaqsipman nautchiiviqaqtuaq tuyuqaġniqsuq savaktaaġrukniamik atugaksraqtuanun piññaktaaksrautni aitquplugu iliŋitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tamatkua taamna tigukamitruŋ anauliġniġaat, aullaqtitluguasiiñ saagaiḷaaqługu. ");
INSERT INTO eskNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Una tuyuqatqiŋñiqsuq atlamik savaktimik. Aasiasii tamatkua atniaqługu niaquagun, aullaqtinniġaat uqapiḷuutiplugu. ");
INSERT INTO eskNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tuyuqatqiḷgiŋñiqsuq atlamik. Maatna tamatkua tuqunniġaat. Tarra iñugiaktuat atlat tuyuġikkaŋi iñuum naŋititqatapiaqtaġniġaich, iḷaŋich anauraġaqługich, atlat tuqquttaqługich. ");
INSERT INTO eskNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Uvvaguuq taamna nautchiiviqaqtuaq atautchimik iġñiqaġniqsuq piqpagikkaġmiñik. Aqulliuplugu tuyuġiniġaa itnaqhuni, ‘Tamatkua taluġigisivalukkaat iġñiġikkaġa.’ ");
INSERT INTO eskNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Aglaan taapkua nautchiiriqirit iŋmiknun uqaġniqsut, ‘Taamnauvva paitchaktaaksralguruq. Ki, tuqullakput, aasii paitchaktaaksrautaa piyumagikput.’ ");
INSERT INTO eskNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Atugaksraqtuat tigguqłuŋniġaat iġñiŋa, aasiiñ tuqqutlugu iginniġaat taavrumakŋa siḷataanun nautchiivium. ");
INSERT INTO eskNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Qanuġniaqpa iñua nautchiivium? Utiġisiruq tuqqutchaġlugich taapkua nautchiiriqirit. Qaitkisigaa nautchiivik atlanun atugaksraqtuanun. ");
INSERT INTO eskNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Agliqisimasruknaġiksi Agaayyutim uqałha: ‘Uyaġak tuppirit ayakkaŋat, taamna uyaġak piitchuiḷḷapiaġaqtuq tuppirauni. ");
INSERT INTO eskNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Taamna atanġum savaaġigaa suli quviqnaqtuaŋunasugigikput.’” ");
INSERT INTO eskNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jew-ŋuplutiŋ sivulliuqtit iḷisimaniġaat uqaaqtuutigiplugu atrikusautmik akikŋałiqtiŋ. Taatnaqługu tigusuliqpiavsaaġaluaġniġaat Jesus maatna aglaan taluqsraġniqsut iñuŋnik. Aasiiñ qanuusiksraiqamiŋ uniññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jew-ŋuplutiŋ sivulliuqtit tuyuġiniġaich iḷaŋich Pharisee-ŋuruat suli Herod-kuaqtuat pitchaquplugu Jesus apiqsruqtuutinik. ");
INSERT INTO eskNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tikiumakamiŋ nipliutiniġaat, “Iḷisautrii, iḷisimarugut nalaunŋaruaŋutilaaqnik sugisuŋaqnagu qanuq iñuich isummatiqaqtilaaŋat. Sugiŋitmigiñ iñuum suurautilaaŋa, aglaan iḷisautrirutin Agaayyutim iñuuniaġvigitqukkaŋanik. Maliġutaksrakuaġnaqpa akiḷiiruni tax-sinik Caesar-mun Rome-mi? ");
INSERT INTO eskNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Akiḷiiruksrauvisa tax-sinik naaga akiḷiiñiaŋitpisa?” Aglaan Jesus-ŋum iḷisimaniġaa ukpiŋŋuaġutaat nipliutiplugich, “Suvaata uuktuaqpisitŋa? Kiata aatchuqsitŋa qiñillaaksramnik maniŋmik!” ");
INSERT INTO eskNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tamatkua aatchuqmatni maniuramik apiqsruġniġai, “Kisumik atriqaġniqpa?” Kiuniġaat, “Caesar-mik.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus-ŋum nipliutiniġai, “Utiqtitchumagiksi pigikkaŋa Caesar-m sua-samna ilaanun, suli Agaayyutmun sua-samna pigikkaŋa Agaayyutim.” Tamatkuatarra quviġusuutiginiġaat nipliutipmatiŋ taavrumiŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tavra iḷaŋich Sadducee-ŋuruat Jesus-muŋniqsut, taapkua nipliġuuruat tuquruat aŋitqitḷaiññipḷugich. Iliŋisa apiqsruġniġaat, ");
INSERT INTO eskNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iḷisautrii, Moses-ŋum uqautigaatigut maliġutaksrakun itnaqhuni, Aŋun iḷaqatiqaqtuaq tuqukpan qitunġigaluaqani, taavruma aŋutim aniqataan iḷaqatniktaaġiraksraġiniġaa uiḷgaġnaaq qitunġisiḷugu aŋutmik iḷisimanaġuniasiiñ tuquruam qitunġaġitilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uvva uqaaqtauŋurut itna, Iḷaatniguuq tallimat malġuich aniaqatigiich. Aŋayukłium nuliaġiliutiniġaa una aġnaq, tuqupluniasiiñ qitunġigaluaqani, ");
INSERT INTO eskNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","suli tuglian nuliaġiliutilgiññiġaa taamna aġnaq aasiiñ tuqulgitḷuni qitunġigaluaqani, taatnatunsuli piŋayuak. ");
INSERT INTO eskNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tarra taatnatunsuli tallimat malġuich nuliaġiniġaat qitunġigaluaqatiŋ. Aqulliupluni aġnaq tuqupmiñiqsuqtuuq. ");
INSERT INTO eskNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Taivrumani aŋitqił̣iġmi makitqikkumiŋ nalliata nuliaġigisivauŋ? Atakkii iluqatiŋ tallimat malġuich nuliaġiniġaat.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus-ŋum kiugai, “Naluniqpisiuŋ nalaunġił̣iqsi? Naluniġiksi Agaayyutim uqałha aglausimaruaq ilaanlu saŋŋia. ");
INSERT INTO eskNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tuquŋaruat aŋitqikkumiŋ atrigigisigaich isaġulgich atakkii iḷaqatniktułiq itchumiñaitchuq pakmani. ");
INSERT INTO eskNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Agliqisimasuknaġiksi makpiġaaŋiñi Moses-ŋum aŋitqił̣ikun tuqułiġmiñ—Agaayyutim nipaa tusaġnaqtuq ikualaruamiñ uqpigauramiñ itnaqhuni, ‘Uvaŋa Agaayyutaa Abraham-ŋum Isaac-ŋumlu Jacob-ŋumlu’. ");
INSERT INTO eskNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kaŋiqsimaiññiqsusri. Agaayyutigiŋitkaat tuquŋaruat aglaan agaayyutigiplugu iñuuruat. Taatnamik kinnirusi ilipsitñun.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iḷaŋata aglaliqirit tusaaniġaa Jesus-ŋum uqautigikkaŋa Sadducee-ŋuruatnun. Iḷitchuġiplugu Jesus-ŋum kiggutillautaqałha apiqsruġniġaa, “Nalliat tillisit tupigitluktaksrauva iluqaŋitñiñ?” ");
INSERT INTO eskNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus-ŋum kiugaa, “Una tilliñ piitchuiḷḷapiaqtuq, ‘Naalaġnisitŋa, Israel-aaġmiuŋuruasii, Saŋŋiruaq Agaayyutvut kisimisauluk Atanġuruq. ");
INSERT INTO eskNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Piqpagiraksraġigiñ Ataniq Agaayyutin iluqaaniñ uummatipniñ suli iluqaaniñ iñuutchipñiñ suli iluqaaniñ isummatipniñ suli iluqaaniñ sayagikkapniñ.’ Sivulliuruksraq tilliñ tavrataamna. ");
INSERT INTO eskNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tuglia taatnatun, ‘Piqpagiyumagiñ iñuuniaqatin iliptun iḷiḷugu.’ Atlamik piitchuq tillitmik kamanatluktuamik taapkuŋnakŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Taavruma aglaliqirim kiuniġaa, “Iḷisautrii, uqaqtutin iḷumutuuruamik. Agaayyutaipiaqtuqtavra atlamik. ");
INSERT INTO eskNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iñuum piqpagiraksraġigaa Agaayyun iluqaaniñ uummatmiñiñ suli iluqaaniñ kaŋiqsimałiġmiñiñ, suli iluqaaniñ sayagikkaġminiñ, suli piqpagilugu iñuuniaqatni iŋmisun iḷiḷugu. Iłuatluktuq tupiksriruni taapkuŋniŋa tillisiŋñik tikiutrił̣iġmiñ niġrutinik suli atlanik tuniḷḷautiksranik Agaayyutmun.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Taavruma kiupmani isumaturuatun, Jesus-ŋum nipliutigaa, “Ukpiġiłhiñaaġuġniġiñ Agaayyutmun aŋalatchiił̣iksran.” Tavrakŋa Jesus apiqsruqausiksraiġñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus iḷisautriḷḷaġmi agaayyuvikpaŋmi apiqsruġniqsuq, “Suvaata aglaliqirit nipliġaġivat Christ, anniqsuqti akiqsruutauruaq, kiŋuviaġinipḷugu David-mun? ");
INSERT INTO eskNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David, aŋalatlugu Ipqitchuam Irrutchim, itnaġniqsuq, ‘Atanġum uqaqtuq Atanimnun: Aquvittin kamagitchiiviksrapnun uvaŋnun akiiḷiñiałhatnunaglaan uumigiritin.’ ");
INSERT INTO eskNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David-ŋum iŋmiñik taiguutiqaqpagu Atanġuruamik, qanuġmi Anniqsuqti David-ŋum kiŋuviaġitlaniqpauŋ?” Iñugaaġruich naalaġnisuurut Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iḷisautrił̣iġmiñi nipliutigai, “Qaunagiyumagisi aglaliqirit pisuktuatlaturuat akuqturuanik atnuġaaqhutiŋ suli iñuŋnun paġlatqusuuplutiŋ tauqsiġñiaġviŋñi. ");
INSERT INTO eskNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Katraġviŋitñi suli iñuich niġiqpakmata aquppitḷaturut nakuutluktuani aquppiutaŋitñi. ");
INSERT INTO eskNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ivayaqtuqmigaich uiḷgaġnaat tupiġikkaŋich, aasiiñ agaayuuraalgupmiut sivisuplugu agaayuŋŋuałikun. Tamatkua tamarra anasiñŋuusiaqaġisirut pitḷuglugu atlaniñ iñuŋniñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus aquvinniqsuq igḷuanun iḷirrivium aasiiñ tautuktuagaqsipḷugich iñuich iḷiriruat iḷirriviŋmun. Iñugiaktuat umialguruat iḷiriqpaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Piqaqmiñiqsuq naalgiiktuamik uiḷgaġnaamik iḷiriruamik malġuŋnik susauraaŋnik maniayauraaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus-ŋum tuqłuġniġai maliġuaqtini nipliutiplugich, “Nipliutigipsi, taamna naalgiiktuaq uiḷgaġnaaq iḷiritḷuktuq tamatkunakŋa atlaniñ iḷiriruaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iluqatiŋ atlat piksraqaqhutiŋ iḷirirut sippakuuqtuaqhutiŋ, aglaan aġnaq piksraiñŋaġmi iḷiriruq tamatkiqł̣ugu iluqaan pigikkani iñuuniutiksraiġḷuqhuniunniiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus aullaaqsipman agaayyuvikpaŋmiñ, maliġuaqtaan iḷaŋata nipliutiniġaa, “Iḷisautrii qiñiġuŋ. Qanutun piññaqnaqtigivat makua uyaġaich marrumani agaayyuvikpaŋmi!” ");
INSERT INTO eskNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus-ŋum kiugaa, “Quviġusuutigivigich makua kamanaqtuat tupqich qiñikkatin? Kisiŋŋuqtaqaġumiñaitchuq uyaġaŋmik qalliani atlam ulġutauniaŋitchuamik.” ");
INSERT INTO eskNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aquppiuqtuaqhutiŋ Jesus-lu iġġiñi atiqaqtuaq Olives-mik akiani agaayyuvikpaum, Peter-mlu, James-ŋumlu, John-ŋumlu, suli Andrew-m apiqsruġniġaat kisiŋŋuutiplugu, ");
INSERT INTO eskNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Uqautitigut, qakugun tamanna atuumaniaqpa? Suli sukun iḷitchuqqutigun iḷitchuġigisivisa iluqaġmiŋ tamatkua atuumaaqsikpata?” ");
INSERT INTO eskNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus-ŋum uqaaqsiñiġai, “Qaunagiyumausi; kisumun iñuŋmun kinnipkaġniaqasi! ");
INSERT INTO eskNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iñugiaktuat tikiumagisirut atuġlugu atiġa nipliġutiŋ, ‘Uvaŋa Christ-ŋuruŋa’. Kinnitñikkisirut iñugiaktuanik. ");
INSERT INTO eskNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Iłuiḷḷiuġniaqasi tusaqsraqaġupsi aŋuyaŋmik maani naagaqaa uŋasiktuani. Aglaan isukłitchumiñairgaqtuqsuli. ");
INSERT INTO eskNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nunaaqqich akikŋaqtuliġisigaich atlat nunaaqqich, suli atanġuviich akikŋaqtuliġisigaich atanġuviich atlat, nuna iḷiqsraġisiruq atlakaaġiiñi nunani. Itkisipmiuq niġisuŋnaq suli iłuiḷḷiułiq. Tamarra tamatkua aullaġniisaaġigisigai nagliksaałhum. ");
INSERT INTO eskNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aglaan qaunakkiaġikkumausi ilipsitñik. Qaitqataġisigaasi uqaqsittaaqtitchirinun, suli ipiġaqtuġisiyaasi katraġviŋñi. Tikiutigisigaasi kavanauruanun umialguruanunlu pisigiluŋa. Tavra piviksraqaġisiñiqsusi iḷisimaraulusi. ");
INSERT INTO eskNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tamatkua atuumagaluaqtitnagich quliaqtuaġigisigaat tusaayugaaġiksuaq iñuŋnun nanipayaaq. ");
INSERT INTO eskNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Qakugun tigukpasi aullautilusi uqaqsittaaġviŋmun isumaalusuŋaqasi sivuani piviksram sumik uqaksrapsitñik. Taivrumani Ipqitchuam Irrutchim iḷisautigisigaasi nipliutiksrapsitñik. Tavra nipliutigiyumagiksi. Taamna Irrusia Agaayyutim uqaġisiruq ilipsigun; nipliayumiñaitchusi. ");
INSERT INTO eskNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aniaqatiuŋuruat qaitqataliġisigaich aniaqatiutiŋ tuqqutaksraulugich, suli aapagikkatiŋ iġñiġuruat. Iḷiḷgaat akikŋaqtuliġisigaich aŋayuqaatiŋ unniiñ tuqqutaksraulugich tamatkua. ");
INSERT INTO eskNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iñuich nanipayaaq uumigigisigaasi pigiluŋa. Aglaan Agaayyutim anniqsuġisigaa sivutmuulguruaq isuanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Iñuk agliqiruaq ukuniŋa kaŋiqsiḷi! Tautukkisigiksi naġġunallapiaġataqtuaq qikaġuni tavrani qikaġviksraġvigiŋisaġmiñi. Taipkunani uvlut tamatkua Judea-mi ittuat qimakkumaut iġġiñun. ");
INSERT INTO eskNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iñuk inniġumi tupqum qaaŋani isiġniaqani saagaksraqsiuġiaġuni tupqum iḷuaniñ. ");
INSERT INTO eskNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Suli taamna qakma nautchiiviŋmi utiġniaqani saagaġniaġuni atnuġaamiñik. ");
INSERT INTO eskNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Qanutun tatamnaqtigigisivat tamatkunani siŋaiyauruani suli miluktitchiruani taipkunani uvluni. ");
INSERT INTO eskNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Agaayuyumuusi qimagviksraqsi inġitqulugu ukiumi. ");
INSERT INTO eskNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Taipkunani uvluni iñuich nagliksaatlullapiaġniaqtut qaŋapaŋniñaglaan Agaayyutim nuna iñiġataqmagu. Aasiiñ taatnatun nagliksaaqtigitqikkumiñaitchut aquagun taavruma. ");
INSERT INTO eskNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aasiiñ Atanġum iḷaŋŋaqtaaŋisuaqpagich taipkua uvlut kiña iñuk anniqsukkauyumiñaitchuq, aglaan pisigilugich piksraqtaaġikkaŋi iḷaŋŋaqtaaġisigai taipkua uvlut. ");
INSERT INTO eskNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Taimanigun kia iñuum uqautikpasi, ‘Ataŋii, uvva Christ-ŋuruaq Agaayyutim akiqsruutigikkaŋa’ naagaqaa uqautikpasi ‘Ataŋii, ilaa taimña’, ukpiġiniaqnagich. ");
INSERT INTO eskNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anniqsuqtiŋŋuat suli sivuniksriqiriŋŋuat iḷigisirut savaaniglu quviqnaqtuaniglu. Taavrumuuna kinniñiaġniġaich Agaayyutim piksraqtaaŋi pisaġiyumiñaġumisigik. ");
INSERT INTO eskNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Taatnamik qaunatqiaġikkumausi! Kilikkipsi sivuani tamatkuniŋa iluqaŋitñik piŋaiñŋaisa. ");
INSERT INTO eskNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Taipkunani uvluni, pianikpan taamna iłuiḷḷiuġutiqpak, siqiñiq taaqsigisiruq, suli tatqiq qaumaġinġiġuni. ");
INSERT INTO eskNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Uvluġiat katakkisirut qiḷaŋmiñ, suli qaummatipayaaŋi siḷam nuktitaulutiŋ inimikniñ. ");
INSERT INTO eskNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Taivrumani uvlumi iñuich tautukkisigaat Iġñiŋa Iñuum aggiqsuaq nuviyakun piqaġuni kamanaqtuamik saŋŋimik kamanautituummaġmi. ");
INSERT INTO eskNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Taamna tuyuqaġisiruq isaġuliŋnik katitchityaqtuanik atautchimun Agaayyutim piksraqtaaġikkaŋiñik nakikŋapayaaq. ");
INSERT INTO eskNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Iḷisaaqaġitchi asiaviqutiniñ, itnaqhuni, nauriuraq nauŋuraaqsivaalukman qiñiġnaqsiuraaqsipmata akutuqpaliksrai iḷisimaraġigiksi upinġaam qallił̣ha. ");
INSERT INTO eskNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Taatnatuntuuq, tautukkupsigik tamatkua atuumaruat iḷisimagisigiksi isuksram tikiumaaqsił̣ha. ");
INSERT INTO eskNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iḷumun nipliutigipsi, ukua iñuich tuquyumiñaitchut atuumagaluaqtitnagu iluqaan tamanna. ");
INSERT INTO eskNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Qiḷaglu nunalu piiġisiruk aglaan uqałitka piiġumiñaitchut. ");
INSERT INTO eskNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kia-unniiñ iñuum nalugaa taimanigun Iġñiŋan Aŋutim qakugun aggił̣iksraŋa, uvaŋa unniiñ isaġulgich ittuat pakmani nalugaat, aglaan kisimi Aapaa iḷisimagaa. ");
INSERT INTO eskNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Qaunatqiaġiksiḷusi, itqummaaġikkumausi, atakkii nalugiksi sumi atuumałiksraŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Atriqaqtuq umialiŋmik aullaqtuamik uŋasiksuamun nunamun unitchipḷuni tupiġmiñik. Saŋŋiksriññiġaa pirigikkani savaaksraŋanik, tilipḷuguasiiñ talum munaqsraa qaunatqiaġiquplugu. ");
INSERT INTO eskNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Taatnamik itqummaaġikkumausi atakkii nalugiksi qakugu aŋaayuqaŋa tupqum aggił̣iksraŋan, unnuami naaga unnuaġruami naaga uvlaatchaurami unniiñ uvlaami. ");
INSERT INTO eskNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aggiġumi tavrakŋatchiaq paqinġitchumagaasi siñigusi. ");
INSERT INTO eskNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nipliutigikkaġa iluqapsitñun sivuani uqautigigiga iñupayaanun, Itqummaaġikkumausi!” ");
INSERT INTO eskNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Atuumagaluaqtitnagik malġuk uvluk Jew-ŋuruat niġiqpagvikaaŋatalu atilik Apqusaakkaułiġmik suli niġił̣hata puvlaksiġniġiḷaamik qaqqumik, qaukłiŋisa agaayuliqsit suli aglaliqirit pakaaġiniġaat qanuġimña tigusukługu Jesus iriġaqtuġutiŋ tuqulluguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aglaan iliŋich nipliġñiqsut, “Niġiqpagvikaam uvluani taatnaġnianġitchikput. Iñuich aupatchakpiaqtut.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus-uvva inniqsuq Bethany-mi, tupqani Simon-ŋum atniġñautiqaqtuam auyugaqtuamik. Aasii niġipkaqługu aġnam tikiññiġaa saagaqhuni akisullapiaqtuamik uqsruġutmik atiqaqtuamik Nard-mik. Taavruma aŋmaġniġaa nakasruŋŋuaŋa kuvikługu uqsruġun Jesus-ŋum niaquanun. ");
INSERT INTO eskNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iḷaŋisa iñuich iłuagiŋiḷgiññiġaat aasiiñ avatmun nipliqhutiŋ, “Suvaata una piiḷaamun uqsruġun atuqpa? ");
INSERT INTO eskNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tuniñayaqtuq qaaŋiġḷugu piŋasut kavluutit taalanik aasii qaiḷḷugu manik nagliŋnaqtuanun.” Taatnaqhutiŋ uqapiḷuktut akikŋaqługu aġnaq. ");
INSERT INTO eskNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus-ŋum nipliutigai, “Sugiŋaiqsiuŋ! Suvaata iłuiḷḷiuqtitpisiuŋ taamna aġnaq? Una savaaqaqtuq nakuuruamik uvaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nagliŋnaqtuat itchaġataqtut. Taimma qanutun savautiłhiñaugisi nakuuruamik piyumiñaġupsi, aglaan nayuutiłhaiñaġumiñaitchuŋa. ");
INSERT INTO eskNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aġnaq savaaqaqtuq piyumiñakkaġmiñik. Tipraġiksaġaa timigikkaġa itqanaiyautiplugu iḷuvikkaułiksraŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Uqautigipsi, nanipayaaq nunami quliaqtuaġikpatruŋ tusaayugaaġiksuaq iñuich uqautigigisigaat nalupqinaiġḷugu aġnam taavruma taatnałha itqakkutauluniasii ilaanun.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot, iḷaŋat qulit malġuich maliġuaqtit, utlautiniqsuq qaukłiŋitñun agaayuliqsit aatchuutigisukługu Jesus iliŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tusaakamitruŋ quviasuliġniqsut, suli akiqsruġniġaat aatchuġukługu maniŋñik. Tavrakŋa Judas utaqqiaqsiñiqsuq aatchuiviksramik Jesus-mik pisuġnaqsiḷugu. ");
INSERT INTO eskNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sivulliqpiami uvluani niġiqpagvikaam puvlaksiġniġiḷaamik qaqqumik ipnaiyaaq tuqqutauraqtuq itqakkutaupluni Apqusaakkaułiġmun. Jesus-ŋum maliġuaqtaiñ apiqsruġniġaat, “Nanili itqanaiyaquvisigut niġiqpałiksraptiknik atiliŋmik Apqusaakkaułiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesus-ŋum tuyuġigik malġuk maliġuaqtiŋni nipliutiplugik, “Nunaaqqimukkitchik. Tavrani paaġisigiktik iñuk saagaqtuaq qikumik imiqaġviŋmik. Malikkumagiktik. ");
INSERT INTO eskNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Napmun isiqpan nipliutiyumagiktik tupilik, ‘Iḷisautri nipliqsuq, nanili iniqaqpich niġġiviksramnik ipnaimik atiliŋmik Apqusaakkaułiġmik piqasiġḷuŋa maliġuaqtimnik?’ ");
INSERT INTO eskNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Taavruma urriqsuutigisigaatik nalauraallagviŋmik inituruamik qulliġmi inimi itqanaiḷaamik inuqsraŋaiqł̣ugu. Tavrani itqanaiyautiyumagiptigut.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesus-ŋum maliġuaqtai aullaqtut nunaaqqimukhutiŋ. Paqinniġaat niplił̣ha taatnatupiaq, itqanaiyaqhutiŋ niġiqpagviksramun atiliŋmun Apqusaakkaułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Anaqaksraaqman Jesus tikiññiqsuq piqatigiplugich qulit malġuich. ");
INSERT INTO eskNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Niġipkaqługich Jesus-ŋum nipliutigai, “Iḷapsisamma niġiqatigikkaġma aatchuutigigisigaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Taapkua aliasuliġñiqsut nipliutiplugich atausiuttaaqhutiŋ, “Uvaŋa piviŋa?” atlatsuli, “Naaga uvaŋa?” ");
INSERT INTO eskNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus-ŋum kiuniġai, “Iḷapsisamma qulit malġuuplusi ittuasi misuksiqatigikkaġma puggutamiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iñuk agaayyutitŋaqtauruaq nalunaiqsaq tuquruksrauruq tuvraġlugu aglausimaruaq ilaagun. Nakłiuŋ iñuk tamna aatchuiruaq Iñuŋmik agaayyutitŋaqtauruamik! Iłuatlukkayaqtuq taimani aniŋitchumi.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tamatkua niġiḷġataqtitlugich Jesus-ŋum tigummipḷugu qaqquq quyyatipluguasiiñ avguqługu qaiññiġaa maliġuaqtimiñun nipliqhuni, “Tigulugu niġġisiuŋ, taamna timiga.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jesus-ŋum tigukamiuŋ qallun quyalgitḷugu Agaayyun, qaiññiġaa tamatkunuŋa imiqsiḷḷaavigipluguasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nipliutigai, “Una auga maqiruaq iñugiaktuanun. Taavrumuuna Agaayyutim taluġniqusiġaa akiqsruutni. ");
INSERT INTO eskNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nipliutigipsi, imitqikkumiñaitchuŋa asiam misuġuanik taivrumuŋaaglaan imiġviksramnun nutaakun aŋaayuqautaani Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tavra atuanikamiŋ atuutmik aullaġniqsut iġġimun atiliŋmun Olives-mik. ");
INSERT INTO eskNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus-ŋum nipliutigai, “Marrumani unnuami iluqasi nikatchakkisirusi piqutigiluŋa. Atakkii aglausimaruaq, ‘Tuqqutchiruŋa munaqsrimik, taatnamik ipnaich siamitkisirut.’ ");
INSERT INTO eskNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aglaan kiñuagun aŋitqianikkuma aullaġisiruŋa sivupsitñi Galilee-mun.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter-m nipliutigaa, “Iluqatiŋ unitkaluaqpatinunniiñ, nikatchakkumiñaitchuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus-ŋum itnaġniġaa, “Uqautilakpiñ, marrumani unnuami aqargiqpak qalġuqtaġaluaqnagu malġuŋniaglaan piiḷaaġutigigisigikma piñasuniaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aglaan Peter nipliqsuq qapiŋaiqhuni, “Tuquluŋaunniiñ nayuġniaġikpiñ. Piiḷaaġiyumiñaipiaġikpiñ sumiunniiñ.” Taatnatuntuuq nipliqmiñiqsut iluqatiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesus-lu maliġuaqtiniḷu tikitñamiŋ nunagiksaaŋanun atiliŋmun Gethsemane-mik nipliutigai, “Aquppiuraallagitchi uvani agaayutyaqtilluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piqatiginiġai Peter-lu, James-lu, suli John. Uqumaiḷḷiullapiaġniqsuq nagliŋnaqsipḷuniunniiñ irrutchiġmigun ");
INSERT INTO eskNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nipliqhuniasiiñ, “Arrii, uqumaiḷḷiullapiaġniqsuŋa. Alianam pisaġiłhiñaaġuqtaġaaŋa. Tavraniittuallagitchi qaunaksruqasiḷḷagluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Taavuŋaqtaallakhuni sitquġniqsuq nunamun agaayupluniasiiñ nagliksaaġuŋitḷuni piñaġumiñaqpan. ");
INSERT INTO eskNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Itnaġniqsuq, “Abba, Aapaaŋ, suapayaaq aŋalatkiñ piiqugaluaġiga nagliksaaġutiqpak uvamniñ. Aglaan pisułhiñ atuumayumuuq, pisułiġiŋiḷaapkun.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesus-ŋum utiqami paqitlugich siñiktuat nipliutiniġaa Simon Peter, “Simaan, siñikpich? Munaġiuraallakkumiñaiññiqpichunniiñ akkuvauraq?” ");
INSERT INTO eskNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tavra nipliutilgiññiġai, “Siñiŋniasuŋaqasi agaayulusiḷu, ukpiqsrisaiŋitchumausiḷi uuktuakkaugupsi. Iñuk iḷumutun piyummatiqaġaluaqhuni irrutchiġmigun, aglaan timimigun sayaitchaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesus aullatqiŋñiqsuq agaayutyaqhuni sivuanisun. ");
INSERT INTO eskNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Utiqami paqilgiññiġai siñiktuat, irratiŋ uisalguiḷḷiḷḷakługichunniiñ. Taatnamik kiuqausiksraiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Utiqami piñayuakni nipliutiniġai, “Kiikaa, siñigitchi qanutun minġuiqsiġusiḷu. Aglaan siñikpaaniktusi. Uvva aatchuutaułiksraŋa iñuum Iġñiŋan tikitchuq aŋalataġiyumiñaqsipḷugu killuliqirinun. ");
INSERT INTO eskNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Makillusi, utlaglavut, ataŋii tunirigikkaġa imma tikitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus uqaqtitlugu Judas, iḷaŋat qulit malġuich maliġuaqtaiñ tikiññiqsuq. Aggiqasiqhuni iñugiaktuanik iñuŋnik, saviqaqhutiŋ suli anautchiraqhutiŋ. Qaukłiŋich agaayuliqsit, aglaliqiritlu suli sivulliuqtiġruat tuyuġiniġaich. ");
INSERT INTO eskNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Taavruma tuniritñiktuam ilaanik qaiññiġaa itnaqhuni iḷitchuġipchautigigisiñipḷugu, “Taamna kunikkaġa, tavra ilaaŋugisiruq. Tiguyumagiksi aullautiluguasiiñ qaunagilugu.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas-ŋum tikirgauraqamiuŋ Jesus nipliutiniġaa, “Iḷisautrii,” kunikł̣ugu. ");
INSERT INTO eskNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aasiiñ tamatkua tigguqłuŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iḷaŋata maliġuaqtaiñ qichaqtuam amuliqamiuŋ savikpani anauniġaa savaktaat qaukłiata agaayuliqsit, siutaiqsiqługu. ");
INSERT INTO eskNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus-ŋum nipliutigai, “Suvaata tigutyaqpisitŋa savikpaliraaqhusi anautaniglu? Savvaqłuktaunasugivisitŋa? ");
INSERT INTO eskNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Uvlutauġaġipman agaayyuvikpaŋmi iḷisautiplusi naagauvva tigullaitchipsitŋa, aglaan aglaksimaaqtuaq taatna Agaayyutim uqałhani ittuksraupluni.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tarrali maliġuaqtai iluqatiŋ suksraaqługu qimaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nukatpiaq, maliġuaqtaiñ iḷaŋat, atnuġaaqaġniqsuq qalipquałhiñamik. Tiguliqsaqmanituuq ");
INSERT INTO eskNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","qalipquani unitḷugu qimaŋniqsuq atnuġaunnani. ");
INSERT INTO eskNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Taapkua tigusiruat pituigun tasiuġniġaat Jesus qaukłiatnun agaayuliqsit, katimaruanun iluqatiŋ qaukłiŋich agaayuliqsit sivulliuqtiġruat aglaliqiritlu. ");
INSERT INTO eskNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter malikmiñiqsuq uŋasiuraaqhuni siḷataanunaglaa igluqpaŋan agaayuliqsit qaukłiata. Aquppiqatauniksuq qaunaksrini naniaqtuaqhuni ikniġmi. ");
INSERT INTO eskNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Qaukłiŋich agaayuliqsit suli iluqatiŋ uqaqsittaaqtitchirit pakaaqaġniqsut agvisiksraŋanik akikŋaġlugu Jesus tuqqutchukługu, aglaan paqitchitḷaiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iñugiaktuat iḷisimaraugaluaqtut akikŋaqługu, aglaan iḷisimaruaruat atiŋitqataqtut. ");
INSERT INTO eskNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tavra iḷisimarit iḷaŋich makinniqsut akikŋaqługu nipliqhutiŋ, ");
INSERT INTO eskNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tusaagikput nipliqman, ‘Piyaqquġisigiga agaayyuvikpak iñiqtauruaq argaŋnik, aglaan piŋayuakkun uvlut nappaiñiaqtuŋa atlamik iñiqtauŋitchuamik argaŋnik.’” ");
INSERT INTO eskNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Iḷisimaritunniiñ taapkua piqasiutilguiññiqsut taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Qaukłiat agaayuliqsit makinniqsuq sivuġaatni. Tarra apiqsruġniġaa Jesus, “Kiggutiksraitpiuŋ una iḷisimarit uqaġikkaŋat akikŋaqhutin?” ");
INSERT INTO eskNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aglaan Jesus nipaisaaqtuq uqaŋitḷuni sumik. Apiqsrutqiḷgiññiġaa qaukłiata agaayuliqsit nipliqhuni, “Christ-ŋuvich, Iġñiŋa Nanġakkauruam Agaayyutim?” ");
INSERT INTO eskNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus-ŋum kiuniġaa, “Tarra, Ilaaŋuruŋa. Tautukkisigiksi Iñuum Iġñiŋa aquppikpan taliqpiani Saŋŋipayaalgum qiñiġisipḷugu atqaqpan nuviyakun qiḷaŋmiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Qaukłiata agaayuliqsit aliktuġniġai atnuġaani nipliqhuni, “Inuqsraŋaiqsugut iḷisimarauruksramik! ");
INSERT INTO eskNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tusaagiksi uqaġniqłuutaa! Qanuq sivunniġñiqpisi?” Iluqatiŋ katimaruat tuqqutaksraġuġnigaat. ");
INSERT INTO eskNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iḷaŋisa tivvuaqtuqługu, irrak matuqqaaqługik anaumikkaat apiqsruqługu, “Ki, nalautchaġiñ kimun anaumiktilaaqnik.” Taatnaanikmata qaunaksrit tiguplugu pattaŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter ititlugu siḷataani uqaqsittaaġvium tikiññiġaa aġnam savaktaan qaukłiata agaayuliqsit. ");
INSERT INTO eskNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Uuma tautukamiuŋ naniaqtuaqtuaq iŋmiñik iḷisaqłiġniġaa nipliutiplugu, “Ilvittuuq piqatigipmikkaŋatin Jesus Nazareth-mium!” ");
INSERT INTO eskNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter piiḷaaqtiqtuq, “Naluruŋa. Kaŋiqsimaŋitchiga qanutchimik uqaqtilaan.” Nuktaaqtitlugu aqargiqpak qalġuġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Suli aġnam taututqiḷgitñamiuŋ nipliutiniġai tamatkua qichaqtuat, “Uvvauna iḷagipmikkaŋat.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peter piiḷaatqiḷgiññiqsuq. Kiŋuagunsuli qichaqtuat tavrani nipliutiniġaat Peter, “Iḷumun iḷagigaatin Galilee-ġmiuŋuplutin.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aglaan suviagaqsiñiqsuq itnaqhuni, “Agaayyutim anasiñŋuqsaġliŋa uqaŋitkuma iḷumutuuruamik. Nalugiga kisuutilaaŋa taavruma aŋutim.” ");
INSERT INTO eskNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tugliḷiqł̣ugu aqargiqpak qalġuġniqsuq. Peter-m itqaġniġai uqałiġikkaŋi Jesus-ŋum, “Aqargiqpak qalġuqtaġaluaqnagu malġuŋniaglaan piiḷaaġutigigisigikma piŋasuniaglaan.” Itqaqamiuŋ taamna qiagaqsiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tavra uvlaatchaurami qaukłiŋich agaayuliqsit piqatigiplugich sivulliuqtiġruat suli aglaliqirit suli iluqaġmiŋ uqaqsittaaqtitchirit katimaniqsut sivunniuqhutiŋ. Tamatkua Jesus qiḷiqtinniġaat. Qiḷġutilik tasikuaqługu Pilate-muutiniġaat kavanauruamun. ");
INSERT INTO eskNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate-ŋum apiqsruġaa, “Uvva Jew-ŋuruat umialigivatin?” Jesus-ŋum kiugaa, “Tavra ilvich taatnaqtutin.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qaukłiŋich agaayuliqsit pasiuġniġaat iñugiaktuatigun sutigun. Aglaan Jesus kiumaksriñġiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate-ŋum apiqsrulgitkaa, “Kiggutiksraiññiqpich? Qanutunaglaan iñugiaktautigiruanik pasiuqpatin!” ");
INSERT INTO eskNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus nipliñġitchuq. Taatnamik Pilate quviġusuŋniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ukiupayaaqman Jew-ŋuruat niġiqpagvikaatni atiliŋmi Apqusaakkaułiġmik Pilate annaktitchiraġniqsuq atautchimik isiqtamik kisupayaamik pisukamiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Akunġatni isiqtat iñuk inniqsuq atilik Barabbas-mik iñuaqatauruaq taapkua aŋuyakmata akikŋaqługu Roman kavamaŋatnik. ");
INSERT INTO eskNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iñugayaat Pilate-mukamitruŋ qasriḷiaqsiñiġaat pituiquplugu isiqtaq piraġiłiġmisun sivuani. ");
INSERT INTO eskNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate-ŋum kiugai, “Pituiġitquvisitŋa Umialgatnik Jew-ŋuruat?” ");
INSERT INTO eskNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iḷitchuġiniġaa qaukłiŋisa agaayuliqsit qaitchił̣hat Jesus-mik siqñataqałiġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aglaali qaukłiŋich agaayuliqsit akatchiñiqsut iñuŋnik Pilate-ŋum pituiġitquplugu Barabbas-mik. ");
INSERT INTO eskNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate kiugai, “Qanuġisiñiqpigu una taiguutiqaqtuaq Umialgatnik Jew-ŋuruat?” ");
INSERT INTO eskNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iluqatiŋ iñuich nipliaqpaŋniqsut, “Kikiaktuutili!” ");
INSERT INTO eskNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate-ŋum apiqsruġniġai, “Suvaata? Savamaqłuqaqpa?” Aglaan iñuich nipliaqpaurallapiaġniqsut, “Kikiaktuutisiuŋ!” ");
INSERT INTO eskNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate-ŋum quyalisukługich iñuich pituiġñiġaa Barabbas iliŋitñun. Qaitkamiuŋ Jesus aŋuyyiuqtimiñun tiliñiġai, “Ki, ipiġaqtuqsiuŋ! Kikiaktuutinaqsiruq.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aŋuyyiuqtit itqutiniġaat Pilate-ŋum tupiqpaŋanun, aasiiñ katitquniġaich atlat aŋuyyiuqtit, ");
INSERT INTO eskNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","atnuġaaqługu akisuruanik kaviqsaamik suli niaquusipḷugu kakitḷaġnanik aasiiñ iḷipḷugich niaquanun. ");
INSERT INTO eskNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kamagiŋŋuaġniġaat sivuġaani nipliqhutiŋ, “Uvvaguuq Umialgat Jew-ŋuruat!” ");
INSERT INTO eskNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Anaullaġniġaat niaquagun anautamik suli tivvuaqtuqługu sitquġvigiplugu sivuġaani Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mitautigianikamitruŋ mattaqtinniġaat kaviqsaaq siḷatiġuaq atipkaqługuasiiñ ilaan atnuġaaŋiñik. Tavra aullautiniġaat kikiaktuutiviksraŋanun. ");
INSERT INTO eskNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Uvvaguuq iglaullaġmiŋ aŋuyyiuqtit paaġniġaat iñuk atiqaqtuaq Simon-mik utiqtuaq nunaaqqimun. Nunuriñiġaat iqsruquplugu Jesus-ŋum kikiaktuutriviksraŋa. Taamna Simon Cyrene-naġmiu aapaŋak Alexander-mlu Rufus-ŋumlu. ");
INSERT INTO eskNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tikiutiniġaat nunaŋanun taiyuutiliŋmik Golgotha-mik mumiutiqaqhuni “Niaqum Saunġa.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Imiksritkaluaġniġaat asiam misuġuanik avuplugu suŋaġnitchuamik. Aglaan Jesus imiŋiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tamatkua aŋuyyiuqtit kikiaktuutigaat. Tavra aviktuġniġaich atnuġaaŋi aasiiñ saaptautigiplugich qanutchimik iñuk piksraquplugu. ");
INSERT INTO eskNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nine-akłaaqman uvlaami kikiaktuutiniġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aglaich pasikkusiaŋi iḷiñiġaich niaquan qulaanun itna aglakługich, “Umialgat Jew-ŋuruat.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ilaani kikiaktuutriqatauniqsuk malġuk tigliŋniaqtik, iḷaqataa taliqpian tuŋaani suli iḷaqataa saumiani. ");
INSERT INTO eskNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sivuniksriqirim tarra Agaayyutim uqałha immiumaruq, “Irrutiniġaat savamaqłuktuatun.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iñuich apqusaaqtuat niaqulaniqsut nipliaplutiŋ pisaaŋŋatinik Jesus-mun, “Aa! Uqaġuuruatin piyaqqułhiñaunipḷugu agaayyuvikpak aasiiñ nappatqigḷugu piŋasuni uvluni, ");
INSERT INTO eskNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ki, anniqsuġiñ ilipnik, aasiiñ atqaġiñ sanniġutamiñ.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Taatnatuntuuq qaukłiŋisa agaayuliqsit piqasiqhutiŋ aglaliqirinik mitautigigaat, “Una anniqsuiraqtuq atlanik, aglaan iŋmiñik anniqsulguitmiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ki, Christ, Umialga Israel-ŋum, atqaġutin kikiaktuutrivipniñ! Uvagut tautukkuptigu ukpiġiyumaikput.” Taapkuak kikiaktuutriqatauruak suviaġutiniġaak. ");
INSERT INTO eskNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Uvluq qitiqquqman taaqsiñiqsuq nunapayaami. ");
INSERT INTO eskNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Three-akłaaqman Jesus nipitusiñiqsuq, “Eloi, Eloi, lama sabachthani?” mumiutiqaqhuni, “Agaayyutmaaŋ, Agaayyutmaaŋ, suvaata suqutiginġiqpiŋa?” ");
INSERT INTO eskNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iḷaŋich tamatkua qichaqtuat tusaakamiuŋ nipliqsut, “Ataŋii, tuqłuġaġaa Elijah.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iḷaŋat iñuich tiguliqamiuŋ allaqtiġun qilamiksruaqhuni misuktiqługu misuqqumun, isautchiqsiqługu ayauppiŋmik qaqłuukkun aktuqługu nipliqhuniasiiñ, “Ki, qiñiġumagikput Elijah aggiġisipmagaan atqautityaġlugu.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus nipaalaliqhuni tuquniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Talukuyaaq agaayyuvikpaŋmi siiksiġniqsuq tatpichakŋa takanuŋa taatna. ");
INSERT INTO eskNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tavra aŋuyyiuqtit qaukłiat qichaqtuaq Jesus-ŋum qaniŋani tuqupman nipliġñiqsuq, “Iḷumutun taamna aŋun iġñiġiniġaa Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Itmiñiqsut aġnat tautuktuat uŋavaniñ, iḷagiplugich Salome suli Mary Magdalene suli Mary, aakagikkaŋak taivruma kamanaiññiqsram James-ŋum suli Joses-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tamatkua piqasiqsuġniġaat Jesus Galilee-mi itman savautiplugulu. Atlat iñugiaktuat aġnat maliŋniġaat Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Unnuksraaġuraaqman Joseph Arimathea-ġmiu tikiññiqsuq. Uvva uvluani sivuani Jew-ŋuruat minġuiqsiaġviat piuq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Taatnamik ilaa taluqsraiqhuni utlautiniqsuq Pilate-mun. Iŋiaġiniġaa Jesus-ŋum timaa. Joseph kamagikkaupluni sivulliuqtiġruaŋuniqsuaq niġiugaqaġniqsuq aullaġniił̣iksraŋanik aŋaayuqautaanik Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate quviġusuŋniqsuq Jesus tuquaniktiġniqman. Tuqłuġniġaa aŋuyyiuqtit qaukłiat apiqsruqługu tuquaniktiqmagaan. ");
INSERT INTO eskNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tarra iḷitchuġianikamiuŋ taavrumakŋa aŋuyyiuqtit qaukłiatniñ Jesus-ŋum tuqqutilaaŋa, qaitkaa timaa Joseph-mun. ");
INSERT INTO eskNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph tauqsiġñiqsuq ukił̣haaġiksaamik. Atqautiplugu Jesus-ŋum timaa puuqługu ukił̣haaġiksuamik iḷiñiġaa iḷuviḷiuqtamun uyaġaŋmi. Aksrakługu uyaġaŋmik taluniġaa taamna iḷuviq. ");
INSERT INTO eskNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene suli Mary aakagikkaŋa Joses-ŋum qiñiġniġaak napmun iḷiñiaqmaŋaan. ");
INSERT INTO eskNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jew-ŋuruat minġuiqsiaġviat qaaŋianikman, Mary Magdalene suli Mary aakaŋa James-ŋum suli Salome tauqsiġñiqsut tipraġiksaanik uqsruqtiġukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Uvlaatchaurami sivulliġmi uvluani akunniqsaam tikitchut iḷuviġmun nuiyasriuraqmiuġlu siqiñiq. ");
INSERT INTO eskNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Uqaksraqtuniqsut iŋmiknun, “Kiami aksrakkisivauŋ uyaġak paaŋaniñ iḷuvġum?” (Atakkii uyaġak aŋigaluaqtuaq). ");
INSERT INTO eskNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tavrakŋa tautuŋniġaat uyaġak aksraksimaanikługu. ");
INSERT INTO eskNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tavra aġnat isiġniqsut iḷuviġmun. Tautukkaat nukatpiaq aquppiuraaqtuaq taliqpian tuŋaani atnuġaaqaqhuni takiruamik qatiqtaamik. Quviġutchaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aasiiñ nukatpiam nipliutigai, “Quviġusuŋaqasi! Pakakkiksi Jesus Nazareth-miu kikiaktuutrauruaq. Agaayyutim aŋitqiksitkaa. Uvani inġitchuq. Qiñiqsiuŋ nallavia. ");
INSERT INTO eskNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aglaan uqautityaqsigik maliġuaqtit Peter-lu, ‘Immaimña Galilee-muŋniaqtuq sivupsitñi, taamani tautukkisigiksi tuvraġlugu uqauttutaa ilipsitñun.’” ");
INSERT INTO eskNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tarra uniññiġaat iḷuviq qilamik. Tatamitpaitḷutiŋ uuliksiñiqsut. Nipliŋiññiqsut iñuŋmun apqutmikni iqsitchakpaitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus aŋitqikhuni uvlaatchaurami sivulliġmi uvluani akunniqsaam, sagviġñiqsuq sivulliuplugu taivrumuŋa Mary Magdalene-mun irrusiqł̣uiyakkamiñ tallimat malġuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Taavruma utlaŋniġai piqatigisuukkaŋi Jesus-ŋum kiñuvġuruat qaipḷutiŋlu. ");
INSERT INTO eskNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Uqautiniġai Jesus iñuunipḷugu suli tautuŋnipḷugu. Tamatkua naagatai kiñuvġuruat tusaakamiŋ ukpiġinġiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kiŋuagun Jesus sagviqmiñiqsuq iglaatun iḷipḷuni malġuŋnun iḷaŋiknun aullaqtuaŋnun nunaaqqimiñ. ");
INSERT INTO eskNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tavrakŋatchiaq utiġniqsuk. Uqauraaqsiñiaġaluaġniqsuk atlanun maliġuaqtinun, aglaan tamatkua ukpiġiŋitmiñiġaich. ");
INSERT INTO eskNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kiŋuagun Jesus sagviqmiñiqsuq taapkunuŋa qulit atautchiñun niġiñiaqtitlugich. Suakataġniġai ukpiqsriḷguił̣hatigun pitchiġiił̣hatigunlu atakkii ukpiġiŋitḷugich qiñiqtuat ilaanik kiŋuagun aŋitqił̣han. ");
INSERT INTO eskNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nipliutigai, “Aullaġusi iluqaanun nunamun, quliaqtuaġiyumagiksi tusaayugaaġiksuaq anniqsuġiakun iluqaitñun iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kisupayaaq ukpiqsriruaq suli paptaakkauruaq anniqsuġisiruq. Aglaan kisupayaaq ukpiqsriŋitchuaq suksraunġiqsaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tamatkua ukpiqtuat piqaġniaqtut iḷitchuqqutaiñik saŋŋim taavrumuuna: Atuġlugu atiġa anittaigisirut irrusiqł̣uŋnik suli uqatlagisirut atlakaaġiiñik uqqanik. ");
INSERT INTO eskNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tigugaluaġumiŋ nimiġianik unniiñ imiġaluaġumiŋ tuqunamik nuyuaġnamiuyumiñaitchut. Iḷigisigaich argagikkatiŋ atniġñaqtuanun aasiiñ tamatkua iłuaqsiḷutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kiŋuagun Jesus-ŋum Atanġum uqaqatigianikamigich, Agaayyutim aullautiuraagaqsiñiġaa pakmuŋa aquvititluguasiiñ taliqpiŋmi tuŋaanun. ");
INSERT INTO eskNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Maliġuaqtai aullaqhutiŋ quliaqtuaġniqsut tusaayugaaġiksuamik nanipayaaq. Atanġuruam savaqatiginiġai nalupqinaiġutiplugu uqauttutaat iḷumun itilaaŋanik quviqnaqtuatigun savaaŋisigun. ");
INSERT INTO eskNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Piqpagiplutin iḷauramaaŋ Theophilus! Iñugiaktuat iñuich pisuqtilaaġmiktigun aglaŋniqsut atuumaruanik akunnaptikni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Iḷisimarauruat uqautiniġaatigut tautukkaġmiknik taimakŋaniñ aullaġniił̣haniñ. Iñuich tamatkua pakmapak quliaqtuaġniqsut tusaayugaaġiksuamik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Qutchiksuaŋuruatiin, aglaŋniaqtuŋa iḷitchuġiraksraqnik iḷisaaġillapiaqqaaġlugich uqaġipayaakkaŋich aullaġniił̣haniñaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aglaktuŋa taavrumiŋa iḷisimatquplutin iḷumutuupiałhanik iḷisauttusiaġikkaqpich. ");
INSERT INTO eskNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod-ŋum umialguniŋani Judea-mi agaayuliqsiqaqmiñiqsuq atiliŋmik Zechariah-mik. Agaayyuvikpaŋmi savaqatauniqsuq agaayuliqsini taggisiqaqtuani Abijah-tkutnik. Aġnaata atqa Elizabeth, paniginiġaali atlam agaayuliqsim. ");
INSERT INTO eskNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iluqatik nalaunŋaruaŋuniqsuk Agaayyutim qiñiłhani, tupiksripḷutik iluqaitñik Atanġum tillisaiñiglu atuqtaksraiñiglu. ");
INSERT INTO eskNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Qitunġaiññiqsuk atakkii Elizabeth qitunġitlaitḷuni, suli iluqatik utuqqanaaġuqhutik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Abijah-tkut savagviksriutaata Agaayyuvikpaŋmi tikiummipman, Zechariah-m savautiniġaa Agaayyun agaayuliqsaupluni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tuvraqługu atuiraġiłhat agaayuliqsit piksraqtaaġiniġaat ikipkairuksraupluni tipraġiksautmik. Isiġniqsuq agaayyuvikpaŋanun Atanġum. ");
INSERT INTO eskNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zechariah ikipkaipkaqtitlugu tipraġiksautmik iñugaaġruich agaayuniqsut siḷataani. ");
INSERT INTO eskNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Isaġulgan Atanġum sagviutiniġaa qichaqhuni taliqpiani ikipkaiviuram tipraġiksautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah-m tautukamiuŋ tupaŋniqsuq iqsiḷiqsiqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aglaan isaġulgum nipliutiniġaa, “Zechariah, iqsiñak! Agaayyutim tusaaniġaa iŋiqsrułhiñ. Nuliaġikkan Elizabeth iġñigisiruq aŋugauramik. Atchiġisigiñ John-mik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Quviasuutiqaġniaqtutin! Atlatlu iñugiaktuat quviatchakkisirut anikpan. ");
INSERT INTO eskNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Iñullautaugisiruq kamanaġuni Agaayyutim qiñiłhani. Imiġumiñaitchuq asiam misuqquanik saŋŋisimaruamik. Aniḷġatałiġmiñiñaglaan aŋalatiqaġisiruq Ipqitchuamik Irrutchimik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Utiqtinniaġai iñugiaktuat Israel-ŋuruat Ataniġmun agaayyutaatnun. ");
INSERT INTO eskNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ataniq aggitḷaiñŋaan taamna John quliaqtuaġniaqtuq saŋŋiqaġuni sivuniksriqiritun Elijah-tun. Iḷauraaġiiksitkisigai aapauruat qitunġaŋitñun. Utiqtitkisigai tupiksritḷaitchuat isummatiqatlasiḷugich nalaunŋaruamik. Itqanaiyautigisigai iñuich akuqtuġumiñaqsiḷugu Ataniq.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah-m nipliutiniġaa isaġulik, “Qanuġluŋa iḷisimaniaqpik iḷumutuutilaaqnik? Ataŋii, aŋayuqaaqtuŋa suli nuliaġikkaġa utuqqaġuqmiuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Isaġulgum kiuniġaa, “Gabriel-ŋuruŋa. Qichaqtuŋa sivuġaani Agaayyutim. Tuyuġigaaŋa uqautityaquplutin taavrumiŋa tusaayugaallautamik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ukpiġilguitchiñ uqauttutigikkaġa aglaan atuumagisiruq. Atakkii ukpiġilguitñapŋa uqaġumiñaitchutin tikiḷġataġlugu uvluq tamatkua atuumaviksraŋat.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Taatnaqtitlugu iñuich utaqqiñiġaat Zechariah iḷisimasukhutiŋ suvaata muluvaałłakmagaan iḷuani agaayyuvikpaum. ");
INSERT INTO eskNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Anisulliġataqami uqalguiññiqsuq. Iñuich iḷitchuġiniġaat qiñiqquuraaqałha agaayyuvikpaum iḷuani. Uqalguitḷuni urriqaniqsuq argaŋmiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Abijah-tkut savagviksriutaat Agaayyuvikpaŋmi naatnamiuŋ Zechariah aiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aquvatigun taavruma nuliaŋa Elizabeth siŋiayauniqsuq. Aasiiñ tallimani tatqiñi aimmiñiqsuq ");
INSERT INTO eskNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","itnaqhuni, “Kiisaimma saŋŋiruam Atanġum Agaayyutim ikayuqpaaŋa. Kanŋusutqikkumiñaiqsuŋa qitunġitlaiññiḷuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Itchaksrani tatqiñi Elizabeth siŋiayauŋanikman, Agaayyutim tuyuġilgiññiġaa isaġulik Gabriel nunaaqqimun Galilee-miittuamun atiliŋmun Nazareth-mik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tuyuġiniġaa niviaqsiamun aŋutituqsimaitchuamun atiliŋmun Mary-mik nuliaksrausiutianiktuamun aŋutmun atiliŋmun Joseph-mik. Joseph kiŋuviaġiniġaa Atanġum David. ");
INSERT INTO eskNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Isaġulgum tikiññiġaa nipliutiplugu, “Paġlagikpiñ! Atanġum Agaayyutim piksraqtaaġigaatin iqatigiplutin. Quvianaġniqsraurutin aġnapayaaniñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary tupallapiaġniqsuq isaġulgum nipliuttutaagun kaŋiqsiŋitḷugu suvaata uqaqtilaaŋa taatna. ");
INSERT INTO eskNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Isaġulgum nipliutiniġaa, “Iqsiñak Marii! Agaayyutim iłuaqqutigigaatin. ");
INSERT INTO eskNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Siŋiayaugisirutin iġñiḷutinaasiiñ aŋugauramik atchiqsaksraġikkaqnik Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Taamna kamanaġisiruq, suli iñuich taiguutiqaġisigaat iġñiŋanik Qutchiŋñiqsrauruam Agaayyutim. Agaayyutim ataniġuqtinniaġaa David-tun sivulliaŋatun. ");
INSERT INTO eskNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ataniġuġisiruq kiŋuviaŋiiñi Jacob-ŋum qaŋapak taimuŋa, suli aŋaayuqautaa isuksraqaġumiñaitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary-m tarra nipliutiniġaa isaġulik, “Qanuq una itkisiñiqpa? Iḷaqatniksimaitchuŋasuli.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Isaġulgum kiuniġaa, “Ipqitchuaq Irrusiq tikiumagisiruq ilipnun. Agaayyutim Qutchiŋñiqsrauruam saŋŋigikkaŋan nayuġisigaatin. Taatnaġuni iḷiḷgaaq ipqitkisiruq taiguutiqaġuni Iġñiŋanik Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aasiiñ, itqallauŋ iḷan Elizabeth. Uqautigimasugauq qitunġaqatlaiññipḷugu. Aglaan pakma siŋaiyauruq itchaksrani tatqiñi utuqqanaaġuġaluaŋŋaġmi. ");
INSERT INTO eskNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Atakkii Agaayyutim supayaaq savaaġitlagaa.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary nipliġñiqsuq, “Atanġum savaktigigaaŋa. Atuumali uvaŋnun uqauttutigikkaptun.” Tavrakŋa isaġulgum uniññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Taavruma aquagun, Mary paqnaliqtuqhuni aullaqtiġniqsuq nunaaqqiuramun qimiġaaŋiñiittuamun Judea-m. ");
INSERT INTO eskNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tarra isiqhuni Zechariah-m tupqanun iqinniġaa Elizabeth. ");
INSERT INTO eskNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth-ŋum tusaapqauraqmagu Mary-m paġlataa iḷummiutaq iḷiqsraqtiġniqsuq. Elizabeth aŋalatiqaġniqsuq Ipqitchuamik Irrutchimik ");
INSERT INTO eskNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nipliqhuni nipitusipḷuni, “Quvianaġniqsraurutin aġnapayaaniñ. Quvianamiuruq iḷiḷgaaq siŋaiyaukkan. ");
INSERT INTO eskNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Qanutun quyyasiusiaqaqtigivik, ataniġma aakagikkaŋan utlagluġniġaaŋa qiñiġiaqłuŋa! ");
INSERT INTO eskNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tusaapqauraqapku paġlatigikkan iḷummiutaġa quviatchakhuni iḷiqsraqtiqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Qanutun quviasuktigivich ukpiġikapku Atanġum uqałha tuyuutigikkaŋa ilipnun atuumagisiñipḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary nipliġñiqsuq, “Iñuutchimniñ iluqaaniñ kamaksruġiga Ataniq. ");
INSERT INTO eskNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Quviatchautigigiga Agaayyun Anniqsuqtigikkaġa. ");
INSERT INTO eskNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Suuŋiḷuqtuaŋa itqaġiniġaaŋa. Uvakŋaniñaglaan iluqatiŋ iñuich taiguutiqaġisigaatŋa quvianamiuruamik ");
INSERT INTO eskNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","atakkii kamanaqtuaq Saŋŋiruaq Agaayyun savaaqaqhuni kamanaqtuanik uvamnun. Atqa ipqitchuq. ");
INSERT INTO eskNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kiŋuviaġiiñi aippaavak nagliktuutiqaġai taluġirigikkani. ");
INSERT INTO eskNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Agaayyun isaŋniqsuq saŋŋiruamik taliġmiñik aasiiñ siammayaaqługich kamanaġasuktuat sivunniuġutituummaitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Atchiksinniġai kamanaqtuat atanġich suli atchiksuat kamanaqsipkaqługich. ");
INSERT INTO eskNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Inuqsraqtuat pisuiqsinniġai nakuuruanik suli aullaqtitlugich umialguruat saagaiḷaaqługich. ");
INSERT INTO eskNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ikayuġniġaa savaktigikkani Israel nagliktuqługich, akiqsruutmisun sivulliaptiknun Abraham-mun kiŋuviapayaaŋiñunlu qaŋapak taimuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary nayuutiuraaġniqsuq piñasuni tatqiñi Elizabeth-mi, aasiiñ utiġmun aipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Iġñiviksrani tikitman, Elizabeth iġñiñiqsuq aŋugauramik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Iḷaiñ iḷauraaŋiñḷu tusaaniġaat Atanġum kamanaqtuamik nagliktuił̣ha Elizabeth-mun. Aasiiñ tamatkua quviasuqasiġñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aniqammiuraq tallimat malġuŋnik uvlianikman nalunaitŋutchiaqsiñiġaat atchiġukługu Zechariah-mik, aapaŋan atqanik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aglaan aakaŋa nipliġñiqsuq, “Naagga, atiqaqtuksrauruq John-mik.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nipliutilgiññiġaat, “Aglaan nalliatunniiñ iḷavich atiqaŋitchut taavrumiŋa atiġmik.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Urriqaplutiŋ apiqsruġniġaat aapaŋa kisumik atchiġukkisipmagaan aniqammiuraq. ");
INSERT INTO eskNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah aatchuquniqsuq aglagviksramik, aglakhuniasiiñ, “Atiqaġisiruq John-mik.” Quviġusuŋniqsut iluqatiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Taatnaanikami Zechariah uqatlasitqiŋñiqsuq quyaaqsipḷuguasiiñ Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Siḷalliuŋich atlayuatchaŋniqsut, aasiiñ iñuich nunapayaani Judea-mi uqaġiniġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tusaapayaaqtuat taavrumiŋa isummatiginiġaat apiqsruqhutiŋ, “Qanusiugisiñiqpa una iḷiḷgaaq?” Nalupqinaitchuq Ataniġmun iqatigitilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John-ŋum aapaŋa Zechariah aŋalatiqaġniqsuq Ipqitchuamik Irrutchimik. Uqaġniqsuq sivuniksriqipluni, ");
INSERT INTO eskNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Quyalakput Ataniq Agaayyutaat Israel-aaġmiut! Atakkii ikayuġiaġniġai tasuqsaġiaqługich iñuni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Akunġatniñ kiŋuviaġikkaŋiñ David-ŋum Agaayyun piksraqtaaqaġniqsuq iñuŋmik saŋŋiqaqtuamik anniqsuġiaqhuta. ");
INSERT INTO eskNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Taimakŋaaglaan akiqsruġaatigut tumigiplugich ipqitchuat sivuniksriqirini ");
INSERT INTO eskNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","anniqsuġisiñipḷuta akiḷḷiḷiqsuqtigikkaptikñiñ suli saŋŋiatniñ uumigirigikkapta. ");
INSERT INTO eskNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Uqaġniqsuq nagligigisiñipḷugich sivulliaġikkavut itqaġilugu ipqitchuaq sivunniuġutni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Agaayyutim akiqsruġniġaa sivulliaqput Abraham ");
INSERT INTO eskNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","annautigisiñipḷuta akiḷḷiḷiqsuqtigikkaptikñiñ uvaptiknun savautitqupluni iqsisuŋaqata ");
INSERT INTO eskNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ipqił̣ikun nalaunŋaruałikunlu iñuuniqtutilaaptikni. ");
INSERT INTO eskNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ilvich iḷiḷgauramaaŋ, taiguutiqaġisirutin sivuniksriqiraanik Qutchiŋñiqsrauruam Agaayyutim. Igliġisirutin sivuani Atanġum itqanaiyaġiaġlugu aggił̣iksraŋa ");
INSERT INTO eskNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","uqautilugich iñugikkaŋi anniqsuġisiñiḷugich natqigutigisiñiḷugiḷḷu killuqsautiŋitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Agaayyutigikkaqput iḷunŋuktauruq nagliktaupluniḷu. Tuyuġikpagu anniqsuqti inniaqtuq uvaptiknun uvlum qausaġatauraġniŋatun. ");
INSERT INTO eskNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ikayuġisigai iñuuniaqtuat taaqtuami iqsiñaŋani tuqułhum, aasiiñ ilaan iñuupkaġuta tutqiksilluta.” ");
INSERT INTO eskNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","John aglipḷuni timimigun saŋŋisiñiqsuq irrutchikun. Iñuuniaġniqsuq iñuiḷaami aullaġniiñiałhanunaglaan ilaan quliaqtuaqałhan Israel-aaġmiunun. ");
INSERT INTO eskNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Augustus atanġuŋŋaġmi Rome-mi tilisiñiqsuq iñuich nanipayaaq atqiqsitquplugich. ");
INSERT INTO eskNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Taamna atqiqsitchivik sivulliuniqsuq. Taamna atuumapman aŋun atiqaqtuaq Quirinius kavanauniqsuq Syria-mi. ");
INSERT INTO eskNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iñupayaat utlautiniqsut sivulliaġmiŋ anniviŋitñun atqiqsitchaqtuqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph-tuuq iglaupmiñiqsuq. Aullaġniipḷuni Nazareth-miñ Galilee-miittuamiñ Bethlehem-muŋniqsuq, nunaaqqimun Judea-miittuamun, annivianun atanġum David. Joseph tavruŋaġniqsuq atakkii ilaaptuuq kiŋuviaġiplugu David-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Atqiqsitchaqtuqami aullautiniġaa Mary nuliaksrausiutianikkani siŋiayauruaq. ");
INSERT INTO eskNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bethlehem-miititlugik Mary iġñisuliġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iġñiñġaġniqsuq aŋugauramik. Nimiqsruqtuallaŋniġaa iḷipḷuguasiiñ tuttuqpaich niġġiviatnun atakkii iniksraitḷutiŋ nullaġviŋmi. ");
INSERT INTO eskNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iḷaŋich munaqsrit unnuiñiqsut taavani nunami munaqsripḷutiŋ ipnaimiknik. ");
INSERT INTO eskNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Isaġulgan Atanġum sagviutiniġai aasiiñ qaumaŋan Atanġum qaggutiplugich. Taapkua tatamitchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aglaan isaġulgum nipliutiniġai, “Iqsiñasi, uvuŋaqłuŋa uqautityaġipsi tusaayugaallautamik quviatchaktirrutiksrauruamik iñupayaamun. ");
INSERT INTO eskNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Marrumani unnuami anniqsuqti ilipsitñun aniruq David-ŋum nunaaqqiani, Christ-ŋuruaq Ataniq. ");
INSERT INTO eskNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Una iḷitchuqqutauruq ilipsitñun ilaaŋutilaaŋanik, paqitkisigiksi aniqammiuraq nimiqsrullaktaq nalaruaq tuttuqpaich niġġiviatni.” ");
INSERT INTO eskNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tavrakŋatchiaq iñugiallapiaqtuat isaġulgich qiḷaŋmiñ sagviġñiqsut. Piqasiqł̣ugu isaġulik nanġaġniġaat Agaayyun itnaqhutiŋ, ");
INSERT INTO eskNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kamanaun illi Agaayyutmun qutchiŋñiqsrami qiḷaŋmi, suli tutqiutiqaġli nunami akunġatni iñuich quyalitñiktuat ilaanik.” ");
INSERT INTO eskNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Isaġulgich utiqmata qiḷaŋmun munaqsrit nipliġñiqsut iŋmiknun, “Ki, aullaqta Bethlehem-mun tautugiaġlugu Atanġum uqauttutigikkaŋa uvaptiknun!” ");
INSERT INTO eskNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Qilamiksruaqhutiŋ paqinniġaich Mary-lu Joseph-lu suli aniqammiuraq nalauraqtuaq tuttuqpaich niġġiviatni. ");
INSERT INTO eskNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Munaqsrit tautukamitruŋ uqaġiniġaich isaġulgum nipliuttutigikkaŋi taavrumuuna aniqammiurakun. ");
INSERT INTO eskNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tusaapayaaqtuat quviġusuŋniqsut tamatkuniŋa munaqsrit nipliuttutigikkaŋitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary-m uummatiġmiitchiutiniġai uqautigikkaŋich aasiiñ isummatigiuraaqługich. ");
INSERT INTO eskNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Munaqsrit utiġniqsut kamaksruqługu nanġaqługu Agaayyun iluqaisigun tusaakkaġmiktigunlu tautukkaġmiktigunlu. Atuumaruq atriḷipḷugu isaġulgum atuumagisiñikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tallimat malġuk uvlut naatmata suli aniqammiuraq nalunaitŋutchiqsauŋanikman, atchiġñiġaat Jesus-mik, atiġmik isaġulgum qaisaŋanik Mary siŋaiyaugaluaqtitnagu. ");
INSERT INTO eskNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ipqiqsaġviksraŋat tikitman, Joseph-lu Mary-mlu aniqammiuraq Jerusalem-muutiniġaak qaitchaqtuaqługu Agaayyutmun tuvraqługu maliġutaksraŋa Moses-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","maliġutlugu aglausimaruaq maliġutaksraŋiñi Atanġuruam, “Aniqqaaqtuapayaaq aŋugauraq qaisaksrauruq Agaayyutmun.” ");
INSERT INTO eskNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tuniḷḷaqtuġiaġniqsuk malġuŋnik tiŋmiaġruuraŋnik, iŋiaŋuruamik maliġutaksraŋagun Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalem-mi aŋutiqaġmiñiqsuq atiliŋmik Simeon-mik. Una aŋun nalaunŋaniqsuq taluqsriruaq Agaayyutmik, suli utaqqiñiqsuaq Israel-aaġmiut annautikkaułiksraŋatnik. Ipqitchuam Irrutchim nayuġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ilaan uqautiniġaa tuquyumiñaiññipḷugu qiñiġaluaqnagu Christ Anniqsuqti Agaayyutim akiqsruutigikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeon sivullikkaupluni Ipqitchuakun Irrutchikun utlautiniqsuq agaayyuvikpaŋmun. Jesus-ŋum aŋayuqaaŋiñ tikiutipmatku aniqammiuraq Jesus agaayyuvikpaŋmun atuumatyaqługu atuiraġiłhagun maliġutaksram, ");
INSERT INTO eskNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon-ŋum akiggiutiniġaa iḷiḷgaaq aasiiñ quyaplugu Agaayyun, ");
INSERT INTO eskNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ataniiq, akiqsruutigikkan atuumapkaġiñ, suli tuqqutlasiruŋa tutqigḷuŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Irramnik tautukkiga anniqsuqti ");
INSERT INTO eskNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","tuyuġikkan annautitquplugich iñuich sumipayaaq. ");
INSERT INTO eskNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ilaa qaumauruq sagviiruaq anniqsuġiamik Jew-ŋuŋitchuanun suli kamanautaugisiruq iñuiñun Israel-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iḷiḷgaam aapaŋa aakaŋalu quviġusuŋniqsuk tamatkunuuna Simeon-ŋum uqauttutaigun Jesus-kun. ");
INSERT INTO eskNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon-ŋum qiññuaġutiniġik piḷiusiamik suli nipliutiplugu Mary aakagikkaŋa, “Agaayyutim una iḷiḷgaaq piksraqtaaġiniġaa agvisautyaquplugu tammałiksraŋatnun naagaqaa anniqsułiksraŋatnun iñugiaktuanun Israel-aaġmiunun. Iḷitchuqqutaugisiruq, aasii pisigiplugu ilaan kisuutilaaŋa iñugiaktuat iñuich uqaġisirut akitñaġlugu. ");
INSERT INTO eskNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Taatnaġumiŋ sagviġisiñiġaich iriġaqtuqhutiŋ isummatigikkaŋich ilaagun. Suli alianaq savikpaktun ipiktuatun kapirigisiruq uummatipnik.” ");
INSERT INTO eskNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sivuniksriqiriqaġmiñiqsuq uiḷgaaġnaamik atiliŋmik Anna-mik panianik Phanuel-ŋum kiŋuviaŋiñiñ Asher-ŋum. Anna utuqqauruq. Uiqaġniqsuq tallimat malġuŋni ukiuni, aasii uiŋa tuqupluni. ");
INSERT INTO eskNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Taimakŋaaglaan iñuuniaġniqsuq uiḷgaaġnaaŋupluni, aasiiñ pakma ukiuniŋniqsuq sisamakipiaq sisamanik. Uniḷḷaiññiġaa agaayyuvikpak. Uvlumi unnuaqtuummaan savautiniġaa Agaayyun uisauraaqhuniḷu agaayupluniḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Taavrumani sassaġniġmi tikiññiqsuq qaitchipḷugu quyyatmik Agaayyun. Uqautiginiġaa taamna iḷiḷgaaq iluqaitñun niġiugaqaqtuanun tasuqsaityałiksraŋanik Jerusalem-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph-ŋum suli Mary-m taŋianikamitkik iluqaisa atuqukkat maliġutaksraŋigun Agaayyutim utiġniqsuk kiŋuniġmiknun Nazareth-mun Galilee-miittuami. ");
INSERT INTO eskNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iḷiḷgaaq Jesus aglipḷuni saŋŋisiñiqsuq, puqiutiqallapiaqhuniḷu. Suli Agaayyutim iłuaqqutiniġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ukiuġaġipman aŋayuqaak Jesus-ŋum utlautiraġniqsuk Jerusalem-mun niġiqpagvikaamun atiliŋmun Apqusaakkaułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus qulit malġuŋnik ukiunikman utlautiniqsut niġiqpagvikaamun piraġiłiġmiktitun. ");
INSERT INTO eskNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Niġiqpagvikaam aquagun aigaqsiñiqsut. Utiqsaġmaknik nukatpiaġruk Jesus uniŋñiqsuq Jerusalem-mun, aasiiñ aakaŋan Joseph-ŋumlu naluniġaak. ");
INSERT INTO eskNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Igliġasuginipḷugu iglauqatauruani iglauniqsuk naalġataqługu uvluq. Uvvaasiiñ tikiumakamik nullaġviksraġmiknun pakaaqsiñiġaak akunġatni iḷamiŋ suli iḷauraaŋiñi. ");
INSERT INTO eskNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Paqiŋitñamitku utiaqsiñiqsuk Jerusalem-mun pakkiaqługu. ");
INSERT INTO eskNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Piñayuatigun uvlut paqinniġaak agaayyuvikpaŋmi aquppiqataupluni Jew-ŋuplutiŋ iḷisautriñi, naalaġnipḷugich apiqsruqtaqługiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iluqatiŋ tusaaruat ilaanik quviġusuutiginiġaat puqikhuni kiggutaigun. ");
INSERT INTO eskNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aŋayuqaakkiñ quviġusuutiginiġaak tautukamitku. Aakaŋan nipliutiniġaa, “Iġñiiŋ, qanulgitpisiguk? Aapanlu piŋiksraliḷḷapiaqhunuk taatnaqhunuk pakkiaġiptigiñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus-ŋum kiuniġik, “Suvaata pakakpisitŋa? Naluniqpitku nayuutiruksraułiġa aapaa tupqani?” ");
INSERT INTO eskNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aglaan kaŋiqsiŋiññiġaak kiggutaa. ");
INSERT INTO eskNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tavrakŋa Jesus utiqasiġniġik Nazareth-mun tupigiplugik. Aakagikkaŋan itqaġiplugich iluqaisa tamatkua uummatiġmiitchiutiniġai. ");
INSERT INTO eskNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus agliñiqsuq puqiksipḷuni. Agaayyutimlu iñuiḷḷu nakuaġiniġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Akimiaġuutaatni ukiut atanniqsuił̣hani Caesar-m atilgum Tiberius, Pontius Pilate kavanaupmiñiqsuq nunami taggisiqaqtuami Judea-mik, Herod atanġupluni Galilee-mi, aniqataa Philip atanġupluni nunami taggisiqaqtuami Iturea-mik Trachonitis-miglu, Lysanias atanġupluni Abilene-mi, aasiiñ ");
INSERT INTO eskNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas-lu Caiaphas-lu qaukłiuplutik agaayuliqsini. Taapkua atanġupkaqługich uqałha Agaayyutim tikiumaniqsuq John-mun iġñiŋanun Zechariah-m iñuiḷaami. ");
INSERT INTO eskNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","John kukiḷuŋniqsuq kuuŋan Jordan-ŋum avataani quliaqtuaqhuni, “Isummitqigitchi mumigusi killuqsautipsitñiñ paptaaqtillusi. Taatnaġupsi Agaayyutimli natqigutigisigai killuqsautisi.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","John aggiġñiqsuq tuvraqługu aglausimaruaq makpiġaaŋani sivuniksriqirim Isaiah-m itna, “Iñuk tuqłuiraqtuq iñuiḷaamiñ: Itqanaiyautisiuŋ apqutiksraŋa Atanġum, nalġuġlugu tumiksraŋa! ");
INSERT INTO eskNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Natiġnapayaat immiġḷugich, iñġich qimiġaallu naqigḷiḷugich, saquŋaruat apqutit nalġuqsaqmiḷugich, qaiġiitchuat tumitchaat qaiqsaġlugich. ");
INSERT INTO eskNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tarrali iñupayaaq iḷitchuġiniaqtuq anniqsuqtimik Agaayyutim akiqsruutigikkaŋanik.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iñugiaktuat iñuich utlautiniqsut John-mun paptaaquplutiŋ. Uqautiniġai, “Nimiġiatun ittuasii, kia uqautivasi annatlasiñipḷusi anasiñŋuqsautiksraŋaniñ Agaayyutim? ");
INSERT INTO eskNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iḷitqutchipsigun qiñiġnaqsisiuŋ isummitqił̣iqsi killuqsautipsitñiñ. Isumanasi, ‘Abraham sivulliaġigikput.’ Uqautigipsi, Agaayyutim makua uyaġaich kiŋuvialiutlagai Abraham-mun! ");
INSERT INTO eskNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Agaayyutim atanniił̣ha qallipiaġataqtuq, iñuktun itqanaiqsuatun kipiłhiñaaġukługu napaaqtuq kaŋiagun. Napaaqtupayaaq asirriŋitchuaq kipikkaugisiruq iktauluniasiiñ ikniġmun.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iñuich apiqsruġniġaat, “Qanuġmi pigisiñiqpisa?” ");
INSERT INTO eskNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kiuniġai, “Kisupayaam malġuŋnik qaliġuaqaġumi qaitchiḷi iñuŋmun atnuġaaksraitchuamun, suli kisupayaaq niqiksrautiqaġumi niġipkaiḷi niqiksraitchuamik.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Iḷaŋich tax-siliqirit utlautipmiñiqsut paptaaquplutiŋ aasiiñ apiqsruqługu, “Iḷisautrii, Sugisiñiqpisali?” ");
INSERT INTO eskNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Uqautiniġai, “Katitchiñasi qaaŋiġḷugu piraksriusiaqsi.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iḷaŋisa aŋuyyiuqtit apiqsruqmiñiġaat, “Uvagutaasiiñ, qanuġisiñiqpisa?” Nipliutiniġai, “Aqsaknasigik iñuich nunuritñigusi naagaqaa saglutiginasigik iñuich. Apaigilugu akiḷiusiaġikkaqsi.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iñupayaat niġiugaqaġniqsut Anniqsuqtimik aggiqsaġumaruamik, aasiiñ isumaniqsut taamna John Christ-ŋupmagaan, anniqsuqti akiqsruutauruaq. ");
INSERT INTO eskNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aasiiñ John-ŋum uqautiniġai, “Paptaaqtitchiruŋa imikun, aglaan taimma iñuk aggiqsaġumaruaq kamanatluktuq uvamniñ. Siŋiiḷguyumiñaitchuŋaunniiñ aluġutiŋnik. Paptaaġisigaasi Ipqitchuakun Irrutchikun suli iknikun. ");
INSERT INTO eskNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tigummiaġigaa tiktitaun salummaġukługich mukkaaksrat sanikłuŋniñ, katillugichaasiiñ mukkaaksrat siġḷuaġmiñun. Aglaan ikipkaġisigai sanikłuich ikniġmun qamiyumiñaitchuamun.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Atlakaaġiikun John quliaqtuaġniqsuq tusaayugaallautamik iñuŋnun pitchuksaaqługich atlaġuquplugich iñuuniałhat. ");
INSERT INTO eskNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","John-ŋum iñiqtiqmiñiġaa ataniq Herod atakkii iḷaqatnikhuni Herodias-mik aniqataan nuliaŋanik suli savaaqaqhuni iñugiaktuanik atlanik pigiitchuanik. ");
INSERT INTO eskNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aasiiñ Herod savaaqaġniqsuq pigiitḷuktuamik isiqtaupkaqamiuŋ John. ");
INSERT INTO eskNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Iluqaisa iñuich John-mun paptaaqtinŋanikmata, Jesus-tuuq paptaaqtinniqsuq. Agaayupkaqługu qiḷak aŋmaqtuq ");
INSERT INTO eskNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","suli Ipqitchuaq Irrusiq atqaġniqsuq ilaanun tiŋmiaġruuratun. Nipi tusaaniġaat pakmakŋa, “Piqpagiplutin Iġñiġigikpiñ. Quyalimaaġikma.” ");
INSERT INTO eskNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus-ŋum aullaġniikamiuŋ savaani, iñuiññaq qulinik ukiuqtutilaaqaġniqsuq. Iñuich isummatiginiġaat iġñiġinipḷugu Joseph-mun, ");
INSERT INTO eskNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","iġñiŋa Matthat-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","iġñiŋa Mattathias-ŋum, iġñiŋa Amos-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","iġñiŋa Maath-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","iġñiŋa Joanan-ŋum, iġñiŋa Rhesa-m, ");
INSERT INTO eskNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","iġñiŋa Melchi-m, ");
INSERT INTO eskNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","iġñiŋa Joshua-m, iġñiŋa Eliezer-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","iġñiŋa Simeon-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iġñiŋa Melea-m, iġñiŋa Menna-m, ");
INSERT INTO eskNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","iġñiŋa Jesse-m, ");
INSERT INTO eskNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","iġñiŋa Amminadab-ŋum, iġñiŋa Admin-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","iġñiŋa Jacob-ŋum, iġñiŋa Isaac-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","iġñiŋa Serug-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","iġñiŋa Cainan-ŋum, iġñiŋa Arphaxad-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","iġñiŋa Methuselah-m, ");
INSERT INTO eskNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","iġñiŋa Enos-ŋum, iġñiŋa Seth-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus utiġniqsuq Jordan-miñ aŋalatiqaqhuni Ipqitchuamik Irrutchimik. Sivullikkauniqsuq Irrutchikun iñuiḷaamun ");
INSERT INTO eskNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","uuktuaqsiutyaqhuni tuunġaġmiñ malġukipiami uvluni. Iluqaani taapkunani uvluni niġiŋiññiqsuq, aasiiñ niġisuliqhuni piviksrani isukłitmata. ");
INSERT INTO eskNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tuunġaum nipliutiniġaa, “Agaayyutim iġñiġipiaqpatin tilliuŋ una uyaġak qaqquġuqulugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aglaan Jesus-ŋum kiuniġaa, “Agaayyutim uqałha nipliqsimaaqtuq, ‘Iñuk iñuuyumiñaitchuq qaqqułhiñakun.’” ");
INSERT INTO eskNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tavrakŋa tuunġaum aullautilgiññiġaa qiñiqtitluguasiiñ atanġuviŋiñik nunam ");
INSERT INTO eskNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nipliutiplugu, “Aatchuġisigikpiñ iluqaanik aŋalatchił̣iġmik suli iluqaanik umialgutmik. Tamanna iluqani qaisauruq uvaŋnun. Aasiiñ qaitḷagiga kisumupayaaq qaitchukkupku. ");
INSERT INTO eskNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iluqaan tamanna piginayaġiñ agaayyuvigigupŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aglaan Jesus-ŋum kiuniġaa, “Agaayyutim uqałha nipliqsimaaqtuq, ‘Agaayyuvigisaġiñ Atanġuruaq Agaayyutin savautilugu kisian.’” ");
INSERT INTO eskNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tavrakŋa tuunġaum aullautilgiññiġaa Jerusalem-mun inillakługuasiiñ qutchiŋñiqsraŋanun nuvukkaŋanun agaayyuvikpaum nipliutiplugu, “Iġñiġipiaqpatin Agaayyutim igittin ilipnik taunuŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Atakkii Agaayyutim uqałha nipliqsimaaqtuq, ‘Agaayyutim isaġuliŋmiñun munaġipkaġisigaatin.’ ");
INSERT INTO eskNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nipliqhunisuli, ‘Akiyaġigisigaatin argaŋmiknik, aasii atniġumiñaitchitin isigaktin uyaġaŋnun.’” ");
INSERT INTO eskNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aglaan Jesus-ŋum kiuniġaa, “Agaayyutim uqałha uqaqmiuqtuuq, ‘Uuktuaġumiñaitchiñ Atanġuruaq Agaayyutin.’” ");
INSERT INTO eskNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tuunġaum uuktuaqsaaġuiqamiuŋ Jesus qanutchipayaakun unisimaallaŋniġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tavrakŋa Jesus utiġniqsuq Galilee-mun saŋŋiqaqhuni Ipqitchuakun Irrutchikun. Iñuich uqaġiniġaat nanipayaaq. ");
INSERT INTO eskNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ilaa iḷisautripḷuni katraġviŋitñi suli kamaksruġniġaat iluqatiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus Nazareth-muŋniqsuq iñuguġvigikkaġmiñun. Jew-ŋuruat minġuiqsiaġvium uvluani piraġiłiġmigun isiġniqsuq katraġviŋmun. Makinniqsuq agliqipluniasiiñ Agaayyutim uqałhaniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aatchuġniġaat makpiġaaŋiñik sivuniksriqirim Isaiah-m. Aŋmaqamigich makpiġaat paqinniġaa aglausimaruaq, ");
INSERT INTO eskNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Irrusian Agaayyutim nayuġaaŋa. Piksraqtaaġigaaŋakii quliaqtuaġitquplugu tusaayugaallautaq inuqsraqtuanun. Tuyuġigaaŋa uqaġitquplugu patchisaiġun tigutaaŋuruanun suli mamirrutiksraq qiñitlaitchuanun suli patchisaiquplugich naŋitaaqsiruat ");
INSERT INTO eskNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","suli quliaqtuaġitquplugu Atanġum anniqsuił̣iksraŋan iñugikkaġmiñik tikiññiqsuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus-ŋum umikługich makpiġaat utiqtinniġai katraġvium savaktigikkaŋanun aquvitluniasii. Iluqatiŋ iñuich katraġviŋmi qiñiaqsiñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iḷisautiaqsiñiġai itnaqhuni, “Taamna Agaayyutim uqałha atuumaniqsuq uvlupak agliqiaŋupman tusaałłapsitñi.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iñupayaat aarigaaġutchaŋniqsut quviġusuutigiplugich saŋŋiqaqtuat uqałhich uqauttutigikkaŋi. Nipliġñiqsut, “Una taimña iġñiġinġitpauŋ Joseph-ŋum?” ");
INSERT INTO eskNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus-ŋum nipliutiniġai, “Uqautiniaġipsitŋa uqauttutauruamik iŋiḷġaanimma itna, ‘Taaktii, iłuaqsiiñ ilipnik!’ Tusaagivut savaaġikkatin Capernaum-mi. Ki, Savaaqaġiñ uvani iñuguġvipni. ");
INSERT INTO eskNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iḷumutuuruq, Sivuniksriqiri paġlatlaitchaat iñuguġviŋmiñi. ");
INSERT INTO eskNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Naalaġniḷḷaksitŋa, Iḷumun iñugiaktuanik uiḷgaġnaaqaqtuq Israel-mi taimani Elijah iñuupman. Imani sialuŋitchuġġuuq piŋasuni ukiuni ukium avvaŋaik iḷaplugich niġisuksiullapiaqhutiŋ iluqaani nunami. ");
INSERT INTO eskNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Naagauvva Elijah tuyuuŋiññiqsuq nalliatnun uiḷgaġnaat Israel-mi aglaan kisianun uiḷgaġnaamun iñuuniaqtuamun Zarephath-mi Sidon-miut nunaŋatni. ");
INSERT INTO eskNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Suli iñugiaktuanik iñuqaqmiñiqsuq auyugaqtualiŋnik iñuuniaqtuanik Israel-mi imani sivuniksriqiri Elisha iñuupman. Aglaan nalliatunniiñ mamikkauŋiññiqsuq avataagun Naaman Syria-ġmiu.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iñuiñ katraġviŋmi tusaakamitruŋ taamna qinnallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Makitiqhutiŋ tinuraqługu Jesus annisiniġaat nunaaqqiġmikniñ. Qaaŋanuutiniġaat iñġiuram nunaaqqimiŋ irvianun igitchukługu ipnamiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aglaan akunniraqługich iñugayaat aullaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tavrakŋa Jesus Capernaum-muŋniqsuq, nunaaqqimun Galilee-miittuamun aasiiñ iḷisautripḷuni iñuŋnik Jew-ŋuruat minġuiqsiaġvium uvluani. ");
INSERT INTO eskNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iñuich quviġusuŋniqsut tamarrumiŋa iḷisauttutaanik, atakkii uqaġniqsuq liilaa aŋalatchił̣iqaqtuatun. ");
INSERT INTO eskNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Katraġviŋmi iñuqaqmiñiqsuq irrusiqł̣uliŋmik iġialaruamik, ");
INSERT INTO eskNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iḷaksianatiguk. Jesus Nazareth-miu, suniaqpisiguk? Uvuŋaqpich piyaqquġukhunuk? Naluŋitchiga kisuutilaan, ipqitchuaŋuplutin Agaayyutim tuyuġikkaŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus-ŋum tiliñiġaa irrusiqł̣uk, “Qiñuisaaġiñ! Anniiñ iñuŋmiñ!” Irrusiqł̣uum ulġusaaqtinniġaa aŋun sivuġaatnun iñuich unitḷuguasiiñ atnisuŋaqnagu. ");
INSERT INTO eskNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iñuich quviġutchaŋniqsut nipliqhutiŋ avatmun, “Qanusiuniqpa una nipliun? Aŋalatitchił̣iġmik saŋŋimiglu uuma iñuum tilitḷaniġai aasiiñ irrusiqł̣uich anipḷutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tusaayugaaq taamna Jesus-kun siaminniqsuq napmupayaaq tamarrumani nunami. ");
INSERT INTO eskNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aasiiḷi Jesus anikami katraġviŋmiñ utlautiniqsuq Simon Peter-m kiŋunġanun. Simon-ŋum aakaruaŋa atniġñaġniqsuq uunaqłukpakhuni. Uqautiniġaat Jesus taavrumiŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Utlakługu qichaqhuni siñigviiñ saniġaatnun tiliñiġaa uunaqłuk aullaquplugu ilaaniñ. Tarra uunaqłunġiqsiġniqsuq. Makitiqhuniasiiñ niqłiuġutiaqsiñiġai. ");
INSERT INTO eskNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jew-ŋuruat minġuiqsiaġviat nuŋitman, siqiñiq nipianikmanimma iluqatiŋ iḷauraaqaqtuat atniġñaqtuanik atniġñautilgich atlakaaġiiñik tikiutiniġaich Jesus-mun. Iḷiñiġai argaŋni iluqaŋitñun aasii iłuaqsipḷugich iluqaisa. ");
INSERT INTO eskNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Irrusiqł̣uich aninniġai iñugiaktuaniñ iñuŋniñ nipliaplutiŋ, “Iġñiġigaatin Agaayyutim.” Jesus-ŋum tiliñiġai irrusiqł̣uich nipliquŋitḷugich, atakkii iḷisimaniġaat Christ-ŋutilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Uvlaaġuqman Jesus-ŋum uniññiġaa nunaaqqiq iñuiḷaamukhuniasiiñ. Iñuich pakaaqsiñiġaat. Paqitnamitruŋ iġḷigiaqsiñiġaat aullaquŋitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aglaan nipliutiniġai, “Quliaqtuaqtuksrauruŋa tusaayugaallautaŋanik aŋaayuqautaan Agaayyutim iñuŋnun atlani nunaaqqiñi. Taatnaqhuni Agaayyutim tuyuġigaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Taatnamik quliaqtuaġniqsuq Jew-ŋuruat katraġviŋitñi nanipayaaq. ");
INSERT INTO eskNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iḷaŋatni uvlut Jesus qichaġniqsuq siñaani narvam taggisiqaqtuami Gennesaret-mik. Iñuich tinurautraġniqsut tusaasukhutiŋ uqałhanik Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tautuŋniġik malġuk umiak siñaani. Iqaluŋniaqtit niuplutiŋ salummaiñiqsut kuvramiknik. ");
INSERT INTO eskNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus ikiniqsuq iḷaqataaknun umiak (umiaġikkaŋanun Simon-ŋum) uqautipluguasiiñ ayaktaallaquplugu siñaaniñ. Jesus aquppipḷuni umiami iḷisautriaqsiñiqsuq iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iḷisautriŋaiqami nipliutiniġaa Simon, “Ayallaguŋ umiaq itiruamun aasiiñ kuvriġiaġusri, ilvich piqatigikkatinlu.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon-ŋum kiuniġaa, “Ataniiq, sakuukkaluaqtugut unnuapak. Iqaluŋiḷḷaktugut. Aglaan nipliutigikkan maliglugu kuvriġisirugut.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kuvriqamiŋ iqalukpauraġniqsut kuvratiŋunniiñ aliŋniuraliqługich. ");
INSERT INTO eskNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Isaaqtaġniġaich piqatitiŋ atlami umiami ittuat ikayuġiaquplutiŋ. Utlautikamiŋ immiġñiġaich taapkuak umiak iqaluŋnik kiviñialiġataqługik. ");
INSERT INTO eskNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peter-m tautukamiuŋ tamanna sitquġniqsuq sivuġaanun Jesus-ŋum nipliqhuni, “Ataniiq, aullaġiñ uvamniñ! Killiqirauruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Atakkii ilaalu piqatiniḷu narġiasruŋniqsut iqalukpauraqtaġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon-ŋum piqatik James-lu John-lu, iġñak Zebedee-m, quviġusukmiñiqsuttuuq. Jesus-ŋum Simon nipliutiniġaa, “Iqsiñak, uvakŋaniñaglaan piññaŋniaġisirutin iñuŋnik aqaluŋniaqmatun.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iqaluŋniaqtit qakitiġniġaich umiatiŋ siñaanun, unisiqługichaasiiñ supayaat maliaqsipḷugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus nunaaqqimiitnami nalautchiñiqsuq aŋutmik auyugaqtualiŋmik. Aŋutim tautukamiuŋ Jesus sivuġaanuŋniqsuq iŋiqsruqługuasiiñ, “Ataniiq, pisuksiñaġuvich mamitiłhiñaugikma.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus-ŋum isakługich argaŋni aksiŋñiġaa, “Piyummatiqaqtuŋa. Iłuaqsiiñ!” Tavrauvaa aŋutim auyugaqtuaŋa mamitikkauruq. ");
INSERT INTO eskNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus-ŋum tiliñiġaa, “Uqautiginiaqnagu kisumununniiñ, aglaan agaayuliqsimugutin isivġiuqtitchumuutin. Aatchuiyumuutin tuniḷḷautinik Agaayyutmun tuvraġlugich Moses-ŋum tillisaa mamititkaatinkii. Taatnaġuvich iñupayaam iḷitchuġiniaġaa mamitilaan.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aglaan tusaayugaaq Jesus-kun siaminniqsuq iñugiaksipḷuni. Iñugiaktuat iñuich utlautiniqsut ilaanun tusaasukługu suli mamititausukhutiŋ atniġñautmikniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aglaan iñuiḷaamuaqsiñiqsuq agaayutyaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iḷaatni Pharisee-ŋuruat suli iḷisautrit maliġutaksranik aggiġñiqsut nunaaqqipayaaniñ Galilee-miittuamiñ Judea-miittuamiñḷu suli Jerusalem-miñ. Jesus iḷisautripkaqługu taapkua aquppiñiqsut naalaġnipḷugu. Agaayyutim Jesus saŋŋiksritmiñiġaa iłuaqsitquplugich atniġñaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iḷaŋich iñuich aggiġñiqsut akiyaqługu aulatlaitchuaq aŋun ilaan qaatchiaŋagun. Itqutiniaġaluaġniġaat iḷuanun tupqum iḷisukługu sivuġaanun Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Aglaan apqutiksraniḷguiññamitruŋ, iñuitkii tatiplutiŋ, akiyautiniġaat qaaŋanun tupqum, aasriiñ alikługu qiḷaŋa tupqum atqaqtinniġaat qaatchiaŋagun akunġatnun iñugayaat iḷipḷugu sivuġaanun Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus-ŋum tautukamiuŋ ukpiqsrił̣hat nipliutiniġaa atniġñaqtuaq, “Aŋuun! Killuqsautitin natqigutikkaurut.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aglaliqirit suli Pharisee-ŋuruat isumaaqsiñiqsut, “Taamna iñuk kisuunasugiva uqaġniqłuutriruaq Agaayyutmik? Kiña natqigutriyumiñaitchuq killuqsautinik aglaan Agaayyun kisimi.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus-ŋum iḷisimaniġai sumik isummatiqaqtilaaŋat apiqsruqługich, “Suvaata isumavisi taatnatchimik? ");
INSERT INTO eskNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Qaġanatlukpa nipliqsuni, ‘Killuqsautitin natqigutikkaurut’ naagaqaa ‘Makillutin pisugiñ’? ");
INSERT INTO eskNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iḷitchuġipkaġisigipsi Iġñiŋan Iñuum aŋalatchirrutiqałhanik natqigutritḷapluni killuqsautinik nunami.” Tavra nipliutiniġaa aulatlaitchuaq aŋun, “Makillutin tigulugu qaatchian aŋiḷaaġiñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tavrakŋatchiaq aŋun makinniqsuq sivuġaatnun nayuutipayaaqtuat. Tiguplugich qaatchiani nallavigikkani aiñiqsuq kamaksruqługu Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iñuich katimapayaaqtuat quviġusuliḷḷapiaġniqsut, aasriiñ taluqsraliqhutiŋ nipliqhutiŋ, “Maatnatavra quviqnallapiaqtuamik qiñiqtugut uvlupak.” Tarra kamaksruġniġaat Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kiñuagun taavruma Jesus anikami tautuŋniġaa aŋun atilik Levi-mik aquppiruaq tax-siliqiviŋmiñi. Taamna tax-siliqiri katitchiñiqsuq maniŋñik Rome-maġmiunun. Jesus-ŋum nipliutiniġaa, “Maliŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi makitiqhuni unitḷugu suapayaaq maliaqsiñiġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aquvatigun Levi niġiqpautriñiqsuq Jesus-mik tupiġmiñi. Aiyugaaqtauruani iḷaupmiñiqsut iñugiaktuat tax-siliqirit atlatlu iñuich. ");
INSERT INTO eskNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Uvvaasiiñ Pharisee-ŋuruat suli aglaliqirit uqaalaaqsiñiqsut maliġuaqtaiñun Jesus-ŋum, “Suvaata niġiqatauvisi imiqatauvisiḷu tax-siliqirini suli killuliqirini?” ");
INSERT INTO eskNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aglaan Jesus kiuniġai, “Iñuich atniġñaŋitchuat taaktiqaġniaŋitchut aglaan tamatkua atniġñaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aggiŋitchuŋa tuqłuġiaġlugich nalaunŋagiruat iŋmikni iñuich aglaan killuliqirit mumiquplugich.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iḷaŋisa iñuich nipliutiniġaat Jesus, “Maliġuaqtai John-ŋum uisauraaġniqsut akulaiqł̣ugu agaayuplutiŋ suli maliġuaqtiŋich Pharisee-ŋuruat taatnatunsuli; aglaan maliġuaqtitin niġiraqtut imiqhutiŋlu.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus-ŋum kiuniġai, “Isummatigivisigik aiyugaaqtauruat katchuutiviŋmi uisauraaquplugich uiksraun inŋaan? Naagga! ");
INSERT INTO eskNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Uiksrautaan aullaġviksraŋa tikiññiaqtuq. Aglaan aullaanikpan iḷauraaŋi uisauraaġniaqtut.” ");
INSERT INTO eskNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus-ŋum uqautitqiŋñiġai atrikusautmik, “Kiñapayaaq iḷaaksraġumiñaitchuq nutaamiñ quppiġaamiñ iḷaaġluguasiiñ utuqqaq quppiġaaq. Taatnaġumi aliksiñaġniaġaa nutaaq quppiġaaq, atakkii nutaamiñ quppiġaamiñ iḷaaksraġumiuŋ atriginiaŋitchaa utuqqam. ");
INSERT INTO eskNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uvvasuli nutaaq asiam misuġua ittuksrauŋitchuq utuqqaġmi puumi atakkii nutaam misuqqum alikkisigaa utuqqaq puuq maqiluni, aasiiñ misuġuq puuġlu suunġiġisiruk. ");
INSERT INTO eskNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aglaan nutaaq asiam misuġua ittuksrauruq nutaami puumi. Iluqatigli puuġlu misuġuġlu piiñġiŋitchumuuk. ");
INSERT INTO eskNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kiñaunniiñ imiġukkumiñaitchuq nutaamik imiqqaaġuni asiam misuġuanik saŋŋisimaruamik. Atakkii nipliġisiruq, ‘Utuqqaġuqsiaq nakuutluŋniqsuq.’” ");
INSERT INTO eskNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jesus pisuŋniqsuq tamauna mukkaaksrat nautchiiviatigun minġuiqsiaġvium uvluani. Maliġuaqtiŋi pukuŋniqsut mukkaaksranik sanŋiyaqługich argaŋmiknik niġiaqsipḷugitaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisee-ŋuruat apiqsruġniġaich, “Suvaata savakpisi minġuiqsiaġvium uvluani? Maliġutaksraġikkaptigun savakkumiñaitchusi ugluvak.” ");
INSERT INTO eskNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus-ŋum kiuniġai tamatkua, “Agliqisimasuknaġiksi sumik David-ŋumlu piqataiñḷu pisilaaŋat niġisuliqamiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David isiġniġuguuq tupqanun Agaayyutim. Aasiiñ qaqquksraqhuni tuniḷḷautauruamik Agaayyutmun niġiñiġaa aatchuqługich maliktigikkani. Maliġutaksraptigun kimununniiñ niqiksrautigitquŋiññiġaa taatnasiq qaqquq avataatigun agaayuliqsit.” ");
INSERT INTO eskNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesus nipliġñiqsuqsuli, “Iġñiŋa Iñuum atanġuruq minġuiqsiaġvium uvluaniunniiñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Atlami minġuiqsiaġvium uvluani Jesus katraġviŋmukhuni iḷisautriñiqsuq. Tavrani itmiñiqsuq aŋun argalik pannaqłuktanik. ");
INSERT INTO eskNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aglaliqirit suli Pharisee-ŋuruat patchisiksraiḷiqiniġaat Jesus savaaqaġasugalugu nalaunŋaitchuamik; naipiqtuġniġaat tautugiaqhutiŋ iłuaqsiriigisipmagaan iḷisratlaitchuamik minġuiqsiaġvium uvluani. ");
INSERT INTO eskNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aglaan Jesus-ŋum iḷisimaniġai isummatiŋich. Uvvaasiiñ nipliutiniġaa aŋun argalik pannaqłuktanik, “Makittin uvuŋaġutin.” Aŋun makitluni tavruŋaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus nipliutiniġai tamatkua, “Apiqsruġniaġipsi una, Nalliak maliġutaksrakuaġnaqpa: savaaqałiq nakuuruamik naagaqaa pigiitchuamik minġuiqsiaġvium uvluani? Ikayuqtuksrauvisa iñuŋnik naagaqaa piyaqquqtillugich?” ");
INSERT INTO eskNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Qiñiqługich iñuich avatmiñi nipliġñiqsuq aŋutmun, “Isakkich argaktin!” Taatnaqman argai iłuaqsiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aglaliqirit Pharisee-ŋuruatlu qinnallapiaġniqsut. Aasiiñ uqautigiaqsiñiġaat avatmun qanuġukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Taipkunani uvluni Jesus qimiġaamuŋniqsuq agaayutyaqhuni, unnuaq naatluguasiiñ agaayupluni Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Uvluqman iŋmiñuquniġai maliġuaqtini. Piksraġniqsuq qulit malġuiñik taiguutiqakkaġmiñik uqqiraqtinik: ");
INSERT INTO eskNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon-mik atchikkaġmiñik Peter-mik suli aniqataaniglu Andrew-mik, James-mik suli John-mik, Philip-mik suli Bartholomew-mik, ");
INSERT INTO eskNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew-mik suli Thomas-mik, James-mik iġñiŋanik Alphaeus-ŋum suli Simon-mik taiguutiqaqtuaq Zealot-ŋuruamik, ");
INSERT INTO eskNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas-mik iġñiŋanik James-ŋum suli Judas Iscariot-mik aatchuutigitniktuaq ilaanik aquagun. ");
INSERT INTO eskNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tavrakŋa Jesus atqaqatiginiġai maliġuaqtini qimiġaamiñ. Qichaġataġniqsuq qaiġiksaamun nunamun piqatigiplugich iñugiaktuat maliġuaqtigikkani. Iñugiaktuat iñuich aggiġñiqsut nakikŋaliqaa Judea-miñ Jerusalem-miñḷu suli nunaaqqiŋñiñ taġium siñaani atiqaqtuamiñ Tyre-miglu Sidon-miglu. ");
INSERT INTO eskNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Utlautiniqsut tusaasukługu Jesus suli iłuaqsisukhutiŋ atniġñautmikniñ. Uvvasuli tamatkua iłuiḷḷiuqtitauruat irrusiqł̣uŋmiñ iłuaqsikkauniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iñupayaat aksiguŋniġaat atakkii saŋŋiqaqhuni iŋmiñi iłuaqsitḷaplugich. Aasiiñ tamatkua utlautiruat ilaanun iłuaqsikkauniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus-ŋum tautuŋniġai maliġuaqtini nipliqhuni, “Quvianamiurusi inuqsraqtuasii; Aŋaayuqautaa Agaayyutim pigigiksi! ");
INSERT INTO eskNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Quvianamiurusi niġisuktuasii pakma; Agaayyutim niġisuiqsitkisigaasi! Quvianamiurusi alianniuqtuasii pakma; Iglaġisirusi! ");
INSERT INTO eskNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Quvianamiurusi iñuich uumigikpasi, ayaksimakpasi pigilugu Iġñiŋa Iñuum aivakpasiunniiñ suli nipliutigikpasi pigiitchuaŋuniḷusi. ");
INSERT INTO eskNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Quviatchapiaġitchi tamanna atuumakpan, nuttaglusi quvianakun, atakkii akiḷiusiaksraqsi pakmani kamanaġniaqtuq. Itqaumasigik, sivulliaŋisa taatnautipmiraġigaich sivuniksriqirit. ");
INSERT INTO eskNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aglaan iqsiñamiurusi umialguruasii pakma; qaġanaqtuaq iñuułiqsi isukłiññiaqtuq! ");
INSERT INTO eskNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Iqsiñamiurusi niġisuiqsimaaqtuasii pakma; niġisuliġisirusi! Iqsiñamiurusi iglaqtuasii pakma; kiñuvġugisirusi qialusiḷu! ");
INSERT INTO eskNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iqsiñamiurusi iñupayaat uqautigillautaqpasi. Itqaumasigik, sivulliaŋisa uqautigillautaqmiraġigaich sivuniksriqiŋŋuaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Aglaali naalaġniruasii uqautigipsi, Piqpagiyumagisi akiḷḷiḷiqsuqtigikkasi, iłuaqqutilugich uumigirigikkasi. ");
INSERT INTO eskNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Apiqsruqsiuŋ Agaayyun iłuaqqutitqulugich tamatkua taiyuaniqłuutriruat ilipsitñik, agaayutilugich tamatkua iłuaqqutrigiŋisasi. ");
INSERT INTO eskNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kia qakiqpatin iqsrapkun, ki, maniyumagiñ igḷuanik iqsraqpich; kia iñuum piñiqpagu quppiġaan, ki, pipkaġumagiñ atnuġaanlu. ");
INSERT INTO eskNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kisupayaam apiqsruqpatin suqaġuguni qaiḷḷugu, suli kia tiguniqpagu pigikkan apiqsruġniaqnagu utiqtitqulugu. ");
INSERT INTO eskNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Qanuq irrutitqusuugupsi atlanun iñuŋnun taatnatuntuuq irrutriyumuusi atlanik. ");
INSERT INTO eskNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Piqpaksrigupsi kisiitñik iñuŋnik piqpaksrigikkapsitñik suvaata akuqtuiñiaġasugivisi quyyatmik? Killuliqiritunniiñ piqpagipmiraġigaich tamatkua piqpagirigikkatiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iłuaqqutigupsigik kisiisa iłuaqqutrigikkasi suvaata akuqtuiñiaġasugivisi quyyatmik? Killuliqiritunniiñ taatnaġaqtuttuuq! ");
INSERT INTO eskNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Atugaksritñikkupsi tamatkunuŋa kisiitñun utiqtitchitḷaruanun atugaksraqtaaġmiknik suvaata akuqtuiñiaġasugivisi quyyatmik? Killuliqiritunniiñ atugaksritñikamiŋ killuliqiriqatmiknun utiqtitchivigitqupmiraqtut aktilaaŋatun! ");
INSERT INTO eskNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aglaan ilipsi, piqpagiyumagisi uumigirigikkasi, iłuaqqutilugich iñuich suli atuaksriḷḷugich niġiugisuŋatnagu utiqtitkisiñiḷugich. Taatnaġupsi akuqtuigisirusi kamanaqtuamik akiḷiusiamik, suli iġñiġigisigaasi Qutchiŋñiqsrauruam Agaayyutim iłuaqqutriruaq quyyataitchuanik pigiitchuaniglu. ");
INSERT INTO eskNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nagliktausitchi Aapapsisun nagliktuutiqaqtuatun. ");
INSERT INTO eskNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Suksraunġiqnasi atlanik, suksraunġiqsauŋitchumausiḷi; pigiiññiġaiñiaqasi atlanik, pigiiññiġakkauŋitchumausiḷi; natqigutisimaaġlugich atlat, natqigutisimaakkauyumuasiḷi. ");
INSERT INTO eskNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aatchuġlugich atlat, aatchuusiaqaġumuasiḷi; aa, akuqtuigisirusi immiġḷugu uuktuun, naqiqsraġlugu, aŋalallugu, ulipkaulalugu: akiyaġniqtutilaapsitñun. Agaayyutim aatchuġaġigaasi iġḷikkutaiḷaakun. Uuktuutigikkaqsi atlanun taamna Agaayyutim uuktuutigigisipmigaa ilipsitñun.” ");
INSERT INTO eskNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus uqautiniġai atrikusautmik, “Qiñitlaitchuam iñuum sivulliġumiuŋ atla qiñitlaitchuaq iluqatik katakkisiruk nivviamun. ");
INSERT INTO eskNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maliġuaqti kamanatluŋitchuq iḷisautrimiñiñ, aglaan iḷisaqtaupayaaq naatchigumi iḷisaaġmiñik atrigaigutigisigaa iḷisautriñi. ");
INSERT INTO eskNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Suvaata tautukpiuŋ irriutaŋuluuraq aniqatvich iraani, aasiiñ suliqutigisuŋaqnagu qirugraitchiaq iripni? ");
INSERT INTO eskNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Qanuq uqautriñiaġniqpich aniqatiupnun, ‘Aniqatmaaŋ, piiġḷagu irriutaŋuluuraq iripniñ!’ qiñisuŋaqnagu qirugraitchiaq iripni? Ukpiŋŋuaqtii! Sivulliulugu piiqsirruŋ qirugraitchiaq iripniñ. Qiñilguniaġiñḷi nalupqinaiġḷugu irriutaiqsił̣iksran aniqatvich iraaniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Napaaqtuġiksaaq nauritḷaitchuq asiaġiitchuanik, naagaqaa napaaqtuġiitchuaq asirritḷaitchuq nakuuruanik. ");
INSERT INTO eskNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Napaaqtupayaaq iḷisimanaġaqtuq asirrianigun; pukutlaitchusi aqpiŋñik kakitḷaġnaniñ, naagaqaa asiaviŋñik kakitḷaġnaqaqtuanik uqpiŋniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iñullautaq nakuurualiqiruq atakkii nakuuruamik isumaqaqhuni; iñullautauŋitñami pigiitchualiqiruq atakkii pigiitchuamik isumaqaqhuni. Taatnamik, iñuk uqaqami irrusipiani salapqiġaa uqałiġmigun. ");
INSERT INTO eskNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Taiguqtaksraġiŋitchipsitŋa Atanipsitñik kamagiyumaŋitkupsigik uqauttutigikkatka ilipsitñun! ");
INSERT INTO eskNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kiña iñuk uvaŋnukkumi naalaġniḷugich uqałiġikkatka aasiiñ tupigilugich—iḷisautigisigipsi qanuq atriqaqtilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Taamna atriqaqtuq iñuŋmik nappairuamik tupiġmiñik nivakhuni itisipḷugu aasii iḷipḷugu turvia uyaġaŋmun. Kuuk uliqłukman qasaqtaqługu taamna tupiq auliyaŋitchuq atakkii payaŋaitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aglaan kiña iñuk tusaaruaq uqałiġikkamnik tupigiŋitḷugich atriqaqtuq iñuŋmik nappairuamik tupiġmiñik nunamun turviiḷaaqługu; uliqłuum qasaqtaqmagu taamna tupiq ulġuruq siqumitipiaqhuni.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus-ŋum iḷisautrisuiqami tamatkunuuna iñuŋnik, ilaa Capernaum-muŋniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Taavaniguuq Roman aŋuyyiuqtaiñ qaukłiat savaktiqaġniqsuq piqpagikkaġmiñik; taamnaasii iñuk atniġñaqhuni tuqułhiñaaġuqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Uvvauna aŋuyyiuqtit qaukłiat tusaakami Jesus-mik tuyuqaġniqsuq Jew-ŋuruat sivulliuqtiġruaŋitñik apiqsruġiaqtitlugu mamititquplugu savaktigikkani. ");
INSERT INTO eskNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tikitñamitruŋ Jesus iŋiġniġaat pipiaqhutiŋ, “Taamna iñuk ikayuqtaksraġipiaġiñ, ");
INSERT INTO eskNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","atakkii ilaan piqpagigai iñugikkavut. Nappairuqunniiñ katraġviksraptiknik.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tavra Jesus maliŋniġai. Uŋasiŋaiqmiuġlu tupqaniñ aŋuyyiuqtit qaukłiata tuyuġiniġai iḷauraani nipliutitquplugu Jesus, “Ataniiq, uvuŋaŋiññaqpich. Uvva utlaktaksrauŋiḷuqtuŋaunniiñ tupimnun. ");
INSERT INTO eskNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Naagalu suuŋiḷuqpaitḷuŋa utlaktaksraġiŋiḷuġikpiñunniiñ. Uqallaksiñaġiñ uqałiġmik aasiiñ savaktigikkaġa atniġñaqtuaq iłuaqsiñiaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Atakkii aŋalatiqaqmiuŋa qaukłiġñik suli aŋuyyiuqtiqaqłuŋa aŋalatamnik. Tilikapku una, ‘Aullaġiñ!’ aullaġaqtuq; tilikapkusuli taamna, ‘Qaġġaiñ!’ aggiġaqtuq; suli tilikapku savaktigikkaġa, ‘Taamna piuŋ!’ piraġigaa.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus-ŋum quviġusuutiginiġaa taamna tusaakamiuŋ. Kiŋiaqami iñugaaġruŋnun maliktigikkaġmiñun uqaġniqsuq, “Paqisimaitchuŋasuli ukpiqsrił̣iġmik taatnatun Israel-aaġmiuni!” ");
INSERT INTO eskNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aŋutit tuyuuruat utiqamiŋ aŋuyyiuqtit qaukłiata tupqanun paqinniġaat savakti iłuaqsipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tamanna atuumaanikman Jesus utlautiniqsuq nunaaqqimun atiliŋmun Nain-mik. Maliġuaqtaiñ suli iñugiaktuat iñuich maliŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tikiññiqsuq paaŋanun nunaaqqim aniḷġataqmiñiqsullu akigaqtuat tuquŋaruamik iñuŋmik. Taamna tuquŋaruaq iġñitauġinikkaŋa uiḷgaġnaam. Iñugiaktuat iñuich nunaaqqimiñ maliŋniġaat taamna aġnaq. ");
INSERT INTO eskNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Atanġuruam Jesus tautukamiuŋ iḷunŋutchallapiaġniqsuq. Nipliutiniġaa aġnaq, “Qianak!” ");
INSERT INTO eskNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Utlakługu aksiŋñiġaa tuquŋaruam akigautaat. Iñuich akigaqtuat taavrumiŋa nutqaqmata Jesus nipliġñiqsuq, “Nukatpiaq, tiligikpiñ, makittin!” ");
INSERT INTO eskNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tuquŋaruaq aŋun aquvitiġniqsuq uqaaqsipḷuniasiiñ. Jesus-ŋum utiqtinniġaa aakaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iñuich iluqatiŋ taluqsratchaŋniqsut kamaksruaqsipḷuguasiiñ Agaayyun itnaqhutiŋ, “Kamanaqtuaq sivuniksriqiri salapqiġñiqsuq akunnaptiknun. Agaayyun aggiqsimaniqsuq anniqsuġiaqługich iñugikkani!” ");
INSERT INTO eskNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Taamna tusaayugaaq Jesus-kun siaminniqsuq nunaaqqipayaanun Judea-mun suli avataanun nunamun. ");
INSERT INTO eskNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John-ŋum maliġuaqtaiñ uqautiniġaat iluqaitñik tamatkuniŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tuqłuqługik malġuk maliġuaqtiŋni tuyuġiniġik atanġuruamun apiqsruquplugu, “Anniqsuqtauvich aggiqsaġumaruaq, naagaqaa niġiuktuksrauvisasuli atlamik?” ");
INSERT INTO eskNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Utlautiruk Jesus-mun nipliutiplugu, “John Paptaaqtitchirim tuyuġigaatiguk apiqsruquplutin, ‘Anniqsuqtauvich aggiqsaġumaruaq, naagaqaa niġiuktuksrauvisasuli atlamik?’” ");
INSERT INTO eskNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Taavrumani taatnałhatni Jesus iłuaqsiraġaiñiqsuq iñugiaktuanik iñuŋnik atniġñautiŋitñik naŋirrutiŋitñiglu, suli anittaqługich irrusiqł̣uich, qiñitlasipḷugiḷḷu qiñitlaitchuat iñuich. ");
INSERT INTO eskNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus-ŋum kiuniġai John-ŋum maliġuaqtik, “Uqautityatku John qiñikkaptiknik suli tusaakkaptiknik: ‘Qiñitlaitchuat qiñitlasirut, pisutlaitchuat pisutlasirut, tamatkua auyugaqtualgich mamittut, tusaatlaitchuat tusaatlasirut, tuquŋaruat aŋitqiksikkaurut iñuułiġmun, suli tusaayugaallautaq quliaqtuaŋuruq inuqsraqtuanun.’ ");
INSERT INTO eskNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Qanutun quvianaqtigiva iñuk ukpiġutaiñġitchuaq piqutigipluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John-ŋum uqqiraqtik aullaqmaknik Jesus-ŋum uqautigiaqsiñiġaa iñugaaġruŋnun John-kun, “Uvva John-mukapsi iñuiḷaamun sumik qiñiġasugivisi? Iviŋmik anuġim aŋalataŋanik liilaa? ");
INSERT INTO eskNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Uvvasuli qiñiġasugivisi iñuŋmik atnuġallautaliŋmik? Iñuich atnuġaallautaqaġaqtuat inuqsrasuŋaqatiŋ iñuuniaġuurut inillautani. ");
INSERT INTO eskNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Uqautisitŋa, sumik qiñiġiaqpisi? Sivuniksriqirimik? Taamna iḷumutuuruq, aglaan tautukkaqsi kamanatluktuaŋuruq sivuniksriqirił̣hiñamiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","John taamna ilaaŋuruq Agaayyutim uqałhan uqautigikkaŋa itna, Agaayyun nipliqsuq, ‘Ataŋii, tuyuġigisigiga uqqiraqtiga sivupni itqanaiyautitqulugu tumiksran sivunnapni.’” ");
INSERT INTO eskNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus niplipsaaqtuq, “John Paptaaqtitchiri kamanatluktuq anipayaaqtuaniñ. Aglaan kiñaunniiñ kamanaiññiqsrauruaq aŋaayuqautaani Agaayyutim kamanatluktuq John-miñ. ");
INSERT INTO eskNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Tusaapayaaqtuat ilaanik tax-siliqirituummaġmiŋ tupiksriñiqsut Agaayyutim nalaunŋaruanik atuqukkaŋiñik paptaakkauplutiŋ John-kun. ");
INSERT INTO eskNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aglaan Pharisee-ŋuruat suli iḷisautrit maliġutaksranik ayaksimaniġaat Agaayyutim sivunniutaa iŋmiknun, suli paptaaquŋitḷutiŋ John-mun.) ");
INSERT INTO eskNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Sumik atriqaqpat iñuich iñuuruat pakmapak? Sutun itpat? ");
INSERT INTO eskNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Atriqaqtut iḷiḷgaanik aquppiruanik tuniriñiaqtuat katimmaviŋitñi tuqłirautiplutiŋ avatmun, ‘Atuqtuurautigaluaġipsi katchuutituutinik aglaan aġġiŋitḷusi.’ ‘Uvagutli, atuqapta kiŋuvġuutinik qiaŋitchusi.’ ");
INSERT INTO eskNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","John Paptaaqtitchiri aggiqami niġitḷaiññiqsuq suli iminġitḷuni asiam misuġuanik, naagasuli uqaqtusi irrusiqł̣uqaġnipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iġñiŋa Iñuum niġiraqtuq imiqhuniḷu. Pakma nipliġaqtusi, ‘Tautullaksiuŋ iñuk niġġiqsuruaq imiqtuqtilu, iḷauraaŋat tax-siliqiritlu killuliqiritlu.’ ");
INSERT INTO eskNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Agaayyutim puqiutaa iḷitchuġipkautauruq iḷumutuuplugu savaaŋagun.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iḷaŋata Pharisee-ŋuruat aiyugaaġniġaa Jesus niġiyaqtuaquplugu. Jesus utlautikami tupqanun, nayummagataqhuni tamauŋa niġiaqsiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taavrumani nunaaqqimi aġnaq iñuuniaqmiñiqsuq killuliqiraupluni. Tusaakamiuŋ Jesus niġiñiaġnipḷugu Pharisee-ŋuruam tupqani aggiutriñiqsuq nakasuŋŋuamik imaliŋmik piññaqnaqtuamik tipraġiksautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Qichaġniqsuq tunuani Jesus-ŋum isigaiñi qiapluni, imaġuqługich qulvimiñik, ivikługich nutchamiñik, kunikł̣ugich, suli kuvipḷugich tipraġiksautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisee-ŋuruaq aiyugaaqtuaq Jesus-mik tautukami taavrumiŋa nipliġñiqsuq iŋmiñun, “Uuma iñuum sivuniksriqiraupiaġumi naluŋiññayaġaa una aġnaq aksiksigikkani; naluŋiññayaġaa qanutchimik iñuuniusiqaqtilaaŋa! Atakkii ilaa killuliqirauruq.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus-ŋum nipliutiniġaa, “Simon, uqautraksraġigikpiñ.” “Aa, iḷisautrii, uqautiŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus unipkaagaqsiruq, “Malġuk iññugguuq simmiḷiaksraqtuġvik akiqsruumaniġaak maniŋñik. Iḷaqataan akiqsruumaniġaa naliksraliŋmik tallimat kavluutit uvlut savaaŋatnik, iḷaqataanaasiiñ malġukipiaq qulinik. ");
INSERT INTO eskNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iluqatik taapkuak akiḷiiḷguiññiqmaknik akiqsruutaiġñiġik. Nalliak taapkuak piqpaksritḷukpa ilaanik?” ");
INSERT INTO eskNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon-ŋum kiuniġaa, “Uumaqanuġii natqigutrikkauruam aŋitluktuamik akiqsruutmik.” Jesus nipliġñiqsuq, “Nalauttutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kiŋiaqługuasiiñ aġnaq nipliutiniġaa Simon, “Tautuguŋ una aġnaq! Uvaŋa isiqama tupipnun qaitchiŋitchikma imiġmik iġġuutiksraŋatnik isigaŋma. Aglaan uuma aġnam iġġuġai isigatka qulvimiñik aasiiñ ivikługich nutchamiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ilvich iqiŋitchikma kunigḷuŋa. Aglaan uuma aġnam nutqautiŋitchai kunniuqługich isigatka isiġataqamaaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uqsruqtiŋitchiñ niaquġa. Aglaan uuma aġnam uqsruqtiġai isigatka tipraġiksautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Uqautigikpiñ, uuma aġnam kamanaqtuamik piqpaksrił̣han qiñiqtitkaa iñugiaktuat killuqsautini natqigutikkaułhat. Aglaan iñuk killuqsautiqapiaŋiññasugiruaq natqigutiraksramik piqpaksripiaġniaŋitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tavrakŋa Jesus-ŋum uqautiniġaa aġnaq, “Killuqsautitin natqigutikkaurut.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atlat aiyugaaqtauruat niġiqatigiplugu Jesus nipliġñiqsut avatmun, “Kisuunasugiva una? Natqigutritḷaniqsuqunniiñ killuqsautinik.” ");
INSERT INTO eskNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aglaan Jesus nipliutiniġaa taamna aġnaq, “Ukpiqsrił̣iqpich anniqsuġaatin. Iñuuniaġiñ tutqiksiḷutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Taavruma kiñuagun Jesus iglauniqsuq apqusaaqługich nunaaqqich nunaaqqiuratlu quliaqtuaqhuni tusaayugaallautamik aŋaayuqautaanik Agaayyutim. Qulit malġuich maliġuaqtaiñ maliŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Iḷaŋisa aġnattuuq malikmiñiġaat iłuaqsikkauruat irrusiqł̣uŋniñ suli atniġñautiniñ. Taapkua Mary-lu (taiguutiqaqtuaq Magdalene-mik), taamna Jesus-ŋum tallimat malġuŋnik irrusiqł̣uŋnik anitchirvigikkaŋa, ");
INSERT INTO eskNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna-lu, uiqaqtuaq Chuza-mik aŋalatauruamik atanġum Herod-ŋum iniqpaŋani, suli Susanna suli iñugiaktuat atlat aġnat. Tamatkua ikayuuttutiginiġaich pigikkatiŋ Jesus-mun suli maliġuaqtaiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iḷaatni iñugiaktuat iñuich utlautruġniqsut Jesus-mun nunaaqqipayaaniñ. Iñugayaat katikmata uqautiniġai uumiŋa atrikusautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iḷaatni iñuk nautchiityaġniqsuq. Nautchirripkaqługu nautchiaksrat iḷaŋich katagaġniqsut apqutmun tutmiġaqatauplutiŋaasii, suli tiŋmiurat siḷami niġipḷugich. ");
INSERT INTO eskNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iḷaŋich kataŋniqsut uyaġauruamun nunamun. Nautchiaksrat qilamik naurut, aglaan pannaqłuŋniqsut atakkii nuna aiḷaŋitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Iḷaŋich nautchiaksrat kataŋniqsut kakitḷaġnalgich akunġatnun. Aasiiñ kakitḷaġnat nauqasiqługich nautchiaksrat nagguviksraiġñiġaich. ");
INSERT INTO eskNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Suli iḷaŋich nautchiaksrat kataŋniqsut nunagiksaamun. Naukamiŋ nauriñiqsut mukkaaksranik tallimakipiaŋuttaaqhutiŋ atautchimiñ.” Taamna uqausiġillaan nipitusipḷuni uqallaŋniqsuq, “Kiña siutiqaqtuaq naalaġniḷi!” ");
INSERT INTO eskNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Maliġuaqtaiñ apiqsruġniġaat Jesus qanuutautilaaŋanik taavruma atrikusautim. ");
INSERT INTO eskNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kiuniġai, “Agaayyutim sagviġaa nalunaqtuaŋa aŋaayuqautmi ilipsitñułhiñaq, aglaali tamatkunuŋa ukpiqsriŋitchuanun uqaqtuŋa atrikusautitigułhiñaq. Taatnamik qiñiġaluaqhutiŋ iḷisaqsritḷaitchut, suli naalaġnigaluaqhutiŋ kaŋiqsitḷaitchut. ");
INSERT INTO eskNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Uvvauna qanuutaułha atrikusautim: nautchiaksraq uqałiġigaa Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nautchiaksrat kataktuat apqutmun atriqaqtut tamatkuniŋa tusaaruanik tusaayugaallautamik, aglaan Tuunġaum tikitḷuni aattaġigai uqałhich uummatiŋitñiñ ukpiqsritquŋitḷugich anniqsukkautquŋitḷugiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nautchiaksratli kataktuat uyaġauruamun nunamun atriqaqtut tamatkuniŋa tusaaruanik tusaayugaallautamik akuqtuqługu quviasukhutiŋ aglaan kaŋiḷiŋitḷutiŋ. Ukpiqsriuraallakkaluaqhutiŋ akkuniisuŋaqani aasiiñ uuktuaqsiułiq tikitman qapiqtiġaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nautchiaksratli kataktuat akunġatnun kakitḷaġnat atriqaqtut tamatkuniŋa tusaaruanik tusaayugaallautamik, aglaan isumatuyaałhum umialgułhumlu suli quvianaŋan marruma iñuuniałhum suqutiginġiqsitaġiġaat ukpiqsrił̣iq, aasiiñ asiaŋat piġutlaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nautchiaksratli kataktuat nunagiksaamun atriqaqtut tamatkuniŋa tusaaruanik tusaayugaallautamik akuqtupiaġataqługu. Tamatkua tupiginiġaat Agaayyutim uqałha aasiiñ asirriaqaqhutiŋ anuqsrułikun, suli iñuusiŋich atlaŋŋuqtauplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kia iñuum ikitnamiuŋ naniq matutlaitchaa utkusiŋmik naagaqaa iḷitlaitchaa ataatnun siñigviich. Aglaan iḷiraġigaa naniqaġviŋmun, iñuiḷḷi isiqtuat taututlarut naniqaqman. ");
INSERT INTO eskNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Qanutchipayaaq irikkauruaq sagvikkaugisiruq, suli qanutchipayaaq matukkauruaq paqitaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Qaunagititchi taatnamik qanuq naalaġnisilaapsitñik atakkii kisupayaaq piqaqtuaq akuqtullaaġisiruq, aglaan taavruma piqaŋitchuam anniagisigaa taamnaunniiñ mikillapiaqtuaq pigikkani.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus-ŋum aakaŋan suli aniqatiuŋiñ utlaŋniġaat. Aglaan tikiḷguiññiġaat iñugiakpaitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iḷaŋata iñuich nipliutiniġaa Jesus, “Aakanlu aniqatiutinlu qichaqtut kigga qiñiġukhutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus-ŋum nipliutiniġai iluqaisa, “Aakagigiga aniqatigigitkalu makua tusaaruat uqałhanik Agaayyutim tupigiplugulu.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iḷaŋatni uvlut Jesus maliġuaqtiniḷu ikiniqsut umiamun, ilaa nipliqhuni, “Ki, ikaaqta igḷuanun narvam.” Tarra ayaksaaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tiŋilġaqsiaġviŋmikni Jesus siñiksaġniqsuq. Tavrakŋatchiaq anuqłiġuutiqpauraġniġai narvami, umiaŋat immiaqsipḷuguasiiñ suli iluqatiŋ navianniuliqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Maliġuaqtaiñ utlakługu Jesus itiqsaġniġaat nipliqhutiŋ, “Iirigii, Ataniiq! Kiviaqsirugut.” Jesus makitluni iñiqtiġniġaa anuġi qaiqpauratlu. Aŋniġuiqman quunnitchiaġullapiaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tavra Jesus-ŋum nipliutiniġai maliġuaqtini, “Naami ukpiqsrił̣iqsi?” Aglaan quviġusuŋniqsut iqsiḷiqhutiŋ, aasiiñ uqaqhutiŋ iŋmiknun, “Qanusiuniqpa una iñuk anuġimunniiñ qaiḷiqpauratlu kamagivatruŋ?” ");
INSERT INTO eskNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus maliġuaqtaiḷu tiŋiḷġaqsiaġniqsut nunaŋanun Gerasene-naġmiut, igḷuanun narvaŋan Galilee-m. ");
INSERT INTO eskNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus niupman umiamiñ paaġniġaa iñuum nunaaqqimiñ irrusiqł̣uqaqtuam. Taamna iñuk atnuġaiḷaaġaġniqsuq aimmitḷaiqhuni, aglaan nayuutiraqniqsuq iḷuviġni. ");
INSERT INTO eskNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tautukamiuŋ Jesus igitluni isigaiñun nipliġñiqsuq nipitusipḷuni, “Jesus, iġñiŋa Qutchiŋñiqsrauruam Agaayyutim, suniaqpiŋa? Iŋiġikpiñ anasiñŋuqsaquŋitḷuŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nipliutiniġaa taavrumiŋa atakkii Jesus-ŋum tilipḷugu irrusiqł̣uk anitquplugu ilaaniñ. Aippaavak aŋallaqłuŋniġaa akulaiqł̣ugu. Tiguraugaluaġaqtuq argaiḷḷu isigaiḷu. Qiḷiqsruqługich kalimñiġñik kiktuġaaġaġniġai, aasii iñuiḷaamuktitaqługu irrusiqł̣uum. ");
INSERT INTO eskNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus apiqsruġniġaa, “Kisumik atiqaqpich?” Taavruma kiuniġaa, “Uvaŋa atiġa Iñugiaktuaq,” atakkii iñugiakhutiŋ irrusiqł̣uich isiqsimaniqsut ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Irrusiqł̣uich iŋiqsruaġniġaat Jesus tuyuġitquŋitḷutiŋ samuŋa natiqsiñaitchuamun. ");
INSERT INTO eskNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Uvvaasiiñ iñugiallapiaqtuat kuniat qanimi niġiñiaġniqsut qimiġaami. Irrusiqł̣uich iŋiqsruaġniġaat Jesus aullaqtitquplutiŋ kunianun. Jesus-ŋum aullaqtinniġai tamatkunuŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Irrusiqł̣uich anikamiŋ iñuŋmiñ isiġniqsut kunianun. Iluqatiŋaasiiñ kuniat paŋaliŋniqsut ipnakun. Naparaġniqsut narvamun aasiiñ ipiplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Iñuich munaqsriruat kunianik tautukamitruŋ taamna atuumaruaq, qimakhutiŋ tusaayugaaġutiginiġaat nunaaqqimi avataaniḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iñuich utlautiniqsut tautugiaqhutiŋ supmagaisa. Tikitñamitruŋ Jesus paqinniġaat iñuk anitchivigikkaŋa irrusiqł̣uŋnik aquppiruaq isigaiñi Jesus-ŋum, atnuġaaqaqhuni suli qauġrimmaaġikhuni. Iñuich tamatkua iqsitchaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tamatkua munaqsriruat tautuktuat taavrumiŋa uqautiginiġaat iñuŋnun qanuq iñuum mamitikkaułha. ");
INSERT INTO eskNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iluqatiŋ Gerasene-naġmiut apiqsruġniġaat Jesus aullaquplugu iqsiḷiḷḷapiaqhutiŋ. Jesus ikipluni umiamun utiaqsiñiqsuq Galilee-mun. ");
INSERT INTO eskNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iñuum anitchivigikkaŋan irrusiqł̣uŋnik iŋiġniġaa Jesus, “Maligukkaluaġikpiñ.” Aglaan Jesus-ŋum aullaqtitkaa nipliutiplugu, ");
INSERT INTO eskNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Aiḷutin uqaġiaġiñ Agaayyutim savauttutaanik ilipnun.” Taamna iñuk nunaaqqimukhuni uqaaqsiñiqsuq qanuq Jesus-ŋum savauttutaanik iŋmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus utiqami igḷuanun narvam iñugayaat paġlagaat atakkii utaqqiñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iñuk atilik Jairus-mik, sivulliuqtaa Jew-ŋuruat katraġviata, tikiumaniqsuq. Punniqsuq isigaiñun Jesus-ŋum iŋiqsruqługu kiñuniġmiñuquplugu, ");
INSERT INTO eskNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","atakkii panitaulua, qulit malġuŋnik ukiuqaqtuaq, tuquaqsiñiqsuq. Jesus taamuŋaqami iñugiaktuat iñuich tatviksraiġñiġaat avataaniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Iñuich akunġatni itmiñiqsuq aġnaq aunaaqsruġuitḷaiqsuaq qulit malġuŋni ukiuni. Akiḷiqsuutigigaluaġniġai suurapayaani taaktinun, aglaan kia-unniiñ mamitilguiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Akunġatigun iñugayaat aġnam utlakługu tunuaniñ aksiŋñiġaa Jesus-ŋum akuagun atnuġaaŋan. Tavrakŋatchiaq aunaaqsruġuiqsiġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus apiqsruġniqsuq, “Kia aksikpaŋa?” Iluqatiŋ naluniñiqsut. Peter nipliġñiqsuq, “Ataniiq! Iñuich tatviksraiqhutiŋ tinuraġaatin. Naagauvva apiqsruqtutin kimun aksiksilaaqnik?” ");
INSERT INTO eskNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aglaan Jesus nipliqsuq, “Kia-imña aksikkaaŋa. Iḷisimaliġiga anipman saŋŋigikkaġa uvamniñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aġnam tautukamiuŋ iḷitchuġikkaułłi utlautiniqsuq uulillaġmi putluni Jesus-ŋum isigaiñun. Sivuġaatni iluqaisa iñuich uqautiniġaa suvaata aksił̣hanik Jesus suli qanuq iłuaqsikkaułłi tavrakŋatchiaq. ");
INSERT INTO eskNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus uqautiniġaa, “Aġnaaq, quviatchauġigiñ, ukpiqsrił̣iqpich iłuaqsipkaġaatin. Aullałhiñaaġuqtutin tutqiksiḷutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus uqaqtitlugu kiliktuiruaq tikiññiqsuq Jairus-mun nipliqhuni, “Paniuran tuquruq. Iḷaksiatqiŋñiaqnagu iḷisautri.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aglaan Jesus-ŋum tusaaplugu nipliutiniġaa Jairus, “Iqsiñak; ukpiqsrił̣hiñaġiñ. Paniuran iłuaqsigisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tikitñamiŋ tupiġmun Jesus-ŋum isiquŋitchai iñuich avataagun Peter, John, James suli iḷiḷgaam aapaŋalu aakaŋalu. ");
INSERT INTO eskNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iluqatiŋ iñuich qiaplutiŋ kiñuvġugaat iḷiḷgaaq. Jesus nipliutiniġai, “Qianasi. Iḷiḷgaaq tuquŋitchuq, siñiksiñaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iluqatiŋ mitautigiaqsigaat iḷisimaplugu aġnauram tuqułha. ");
INSERT INTO eskNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aglaan Jesus tigukamigich argai tuqłuġniġaa, “Niviaqsiaq! Makittin.” ");
INSERT INTO eskNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iḷiḷgaaq iñuutqiŋñiqsuq makitluniasiiñ tavrakŋatchiaq. Jesus-tavra tilisiñiqsuq aatchuquplugu niqiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aŋayuqaak quviġutchaŋniqsuk. Aglaan Jesus-ŋum uqaquŋiññiġik kisumun taavrumiŋa atuumaruamik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus-ŋum katipkaqamigich qulit malġuich maliġuaqtini saŋŋiksriññiġai anitchitḷasipḷugich irrusiqł̣uŋnik suli mamititchitḷasipḷugich atniġñautinik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Taatnaanikami tuyuġiniġai quliaqtuaġiaquplugich aŋaayuqautaanik Agaayyutim suli iłuaqsiitquplugich atniġñaqtuanik, ");
INSERT INTO eskNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","nipliqhuni, “Aullautriñiaqasi iglaugupsi: ayaupiamik unniiñ iŋiularim puukataŋanik unniiñ niqiksrapsitñiglu unniiñ maniŋmiglu naagaqaa atnuġaatqiutiksrapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kisupayaam akuqtuqpasi nayuutiyumausi taavrumani inaani aullaġniałłapsitñunaglaan taavrumakŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iñuich nani akuqtuŋitpasi unitchumagiksi taamna nunaaqqiq aasii ipsuktuġlugu apyuq isigapsitñiñ. Taamna kilgutaugisiruq iliŋitñun akuqtuiŋisilaaŋatnik tusaayugaaġiksuamik.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Maliġuaqtit aullaqamiŋ iglauniqsut nunaaqqiurapayaatigun quliaqtuaqhutiŋ tusaayugaallautamik suli mamititchipḷutiŋ iñuŋnik nanipayaaq. ");
INSERT INTO eskNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod-ŋum, aŋalatauruam Galilee-mi, tusaaniġai iluqaisa Jesus-ŋum savaaŋi. Tupaŋaniqsuq atakkii iñuich uqaqhutiŋ John Paptaaqtitchiri iñugutqiŋñipḷugu, ");
INSERT INTO eskNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","iḷaŋich uqaqhutiŋ Elijah sagviġñipḷugu, iḷaŋitsuli uqaqhutiŋ sivuniksriqiri iŋiḷġaaqnisaq iñugutqiŋñipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod nipliqsuq, “Uvaŋa John niaquiqsitaġa, aglaan una iñuk kisuuniqpa tusaqsraġikkaġa tamatkunuuna?” Taatnamik iḷitchuġisuŋniġaa Jesus kisuutilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Uqqiraqtit utiqamiŋ uqautigaat Jesus iluqaanik savaaġikkaġmiknik. Uvvaasiiñ aullaqatiginiġai kisiitñik nunaaqqianun Bethsaida-m. ");
INSERT INTO eskNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iñugaaġruich tusaakamitruŋ maliŋniġaat. Jesus-ŋum paġlaplugich uqautiniġai aŋaayuqautaanik Agaayyutim, suli iłuaqsipḷugich tamatkua ikayuġnaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Unnuksraaqhuni siqiñiq nipipman, qulit malġuk maliġuaqtit utlaŋniġaat Jesus nipliutiplugu, “Tuyuġikkich iñuich nunaaqqiuranun suli nautchiiviḷiŋnun nullaġniuraġiaqulugich suli niqiksraġiaqulugich, atakkii iñuiḷaamiittugut.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus nipliutigai, “Naagga! Aglaan ilipsi, aatchuqsigich niqiksraŋitñik.” Tamatkua kiuniġaat, “Uvva piqaġaluaqtugut tallimanik qaqqiaŋuranik suli malġuŋnik iqalugauraaŋnik. Tauqsiġiaquvisigut niqiksraŋitñik iñugaaġruich?” ");
INSERT INTO eskNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aŋutit 5,000-siyuŋnaq iñugiaktigirut tarani. Jesus nipliutigai maliġuaqtini, “Iñuich aquvititchigik malġukipiaq quliŋullaalugich.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Maliġuaqtit iñupayaat aquvitinniġaich. ");
INSERT INTO eskNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesus tiguniġai tallimat qaqquurat suli malġuk iqalugauraak aasii aaġluqhuni qiḷaŋmun quyyatigiplugich. Avguaġai qaqqut iqalugauraaglu qaitḷugich maliġuaqtimiñun autaaġutigitquplugich iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iñuich niġiñiqsut niġisuiġataqhutiŋ. Tavra maliġuaqtit immiġñiġaich qulit malġuk aguupmaich iḷakunik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Iḷaatniguuq Jesus agaayupman kisiŋŋuqhuni maliġuaqtaiñ utlaŋniġaat. Jesus-ŋum apiqsruġniġai, “Kisuunasugivatŋa iñuich?” ");
INSERT INTO eskNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Maliġuaqtaiñ kiugaat, “Iḷaŋisa uqaġigaat John paptaaqtitchiraunipḷutin, iḷaŋisasuli Elijah-ŋunipḷutin, atlatlu uqaqhutiŋ sivuniksriqiri iŋiḷġaaqnisaq iñugutqiŋñipḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus apiqsruġniġai, “Ilipsiasiiñ? Kisuunasugivisitŋa?” Peter-m kiuniġaa, “Ilvich Christ-ŋurutin, anniqsuqti akiqsruutauruaq.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesus-ŋum iñiqtillapiaġniġai uqautigitquŋitḷuni kisuutilaaġmiñik kimununniiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Uqautipsaaġniġai, “Sivulliuqtiġruatlu, qaukłiŋisa agaayuliqsitlu suli aglaliqirit nagliksaaqtitkisigaat ayaglugulu Iġñiŋa Iñuum tuqulluguasiiñ. Aglaan piŋayuakkun uvlut aŋipkakkaugisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iluqaisa nipliutiniġai, “Kia iñuum maligukkumiña suksraaqtaksraġigaa pisułłi, iqsriutilugu sanniġutani uvluġaġikpan aasii maligluŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Atakkii kia iñuum anniġiniaġumiuŋ iñuułłi tammaigisigaa, aglaan kiapayaaq tammaiyumiuŋ iñuułłi piqutigiluŋa piññakkisiruq iḷumun iñuułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iñuum piññaktaaġiłhiñaugaluaġaa suurapayaaŋa marruma nunam aglaan tammautigisigaa iñuułłi. Sakuuguraġniałha sumun atuġumiñaitchuq! ");
INSERT INTO eskNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iḷapsi kanŋugivalukkaatŋa iḷisauttutitkalu sivuġaatni iñuich suksraqaŋitchuat Agaayyutmik. Taatnatun Iġñiŋan Aŋutim kanŋugigisipmigaaptuuq utiġumi kamanautiqaġuni aapamisun piqasiġuni ipqitchuanik isaġuliŋnik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iḷumun nipliutigipsi, Iñuqaqtuq iḷaŋitñik uvani makitaruat tuquŋaiñŋaġmiŋ qiñiġniatuanik Agaayyutim aŋaayuqautaanik.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Akunniqsaaŋanikman Jesus-ŋum kayuŋiutiplugich Peter-lu, John-lu suli James mayuġniqsuq qimiġaamun agaayutyaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Agaayupkaqługu qiññaŋa atlaŋŋuġniqsuq atnuġaaŋiḷu qivliqisirauraqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tavrakŋatchiaq malġuk aŋutik uqaqatiginiġaak Jesus. Taapkuak Moses-lu Elijah-lu ");
INSERT INTO eskNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","aasiiñ qiññaŋak qaummaġił̣allaŋniqsuq. Uqaqatiginiġaak Jesus tuqqutaułiksraŋagun Jerusalem-mi Agaayyutim sivunniutaagun. ");
INSERT INTO eskNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter-lu piqataiḷu siñiŋnialiḷḷapiaġniqsut, aglaan itiqamiŋ tautuŋniġaat Jesus kamanałhagun qichaqatigiplugu malġuk aŋutik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aŋutik unitkaqsipmatku Jesus Peter-m nipliutiniġaa, “Ataniiq, nakuullapiaqtuq uvaniiłiqput. Nappaitquguptigut nappaiñayaqtugut piŋasunik palapkaaksranik, atautchimik ilipnun, atautchimik Moses-mun suli atautchimik Elijah-mun.” Iḷisimaŋitkaluaġniġaa uqaġikkani. ");
INSERT INTO eskNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter uqaqtitlugu nuviyam qulaŋiutiġniġai; maliġuaqtai iqsitchaŋniqsut nuviya qulaŋiutipman. ");
INSERT INTO eskNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nipi nipliqsuq nuviyamiñ, “Tavrataamna Iġñiġa piksraqtaaġikkaġa; naalaġniyumagiksi.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Uqaġuiqman Jesus kisiŋŋuġniqsuq. Taipkunani uvluni maliġuaqtaiñ uqautigiŋiññiġaat kisumununniiñ tautukkaqtiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Uvlutqikman Jesus-lu piŋasutlu maliġuaqtai atqaqamiŋ qimiġaamiñ iñugiaktuat iñuich paaġniġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Iñuk nipliġñiqsuq akunġatniñ iñugayaat, “Iḷisautrii, tautullaguŋ iġñiġa, tarra iġñitualuga. ");
INSERT INTO eskNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Irrusiqł̣uum aŋalatmani kapyaaqsiñiqsuq. Ilaa qiluraġallapiaġaqtuq suli innuliqiaqsiruq qaniġmigun. Irrusiqł̣uum atniaqtuiñaġaa suli unitḷaiqł̣ugu. ");
INSERT INTO eskNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Uqapsaaġaluaġitka maliġuaqtitin anitquplugu taamna irrusiqł̣uk aglaan anipkalguiññiġaat.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus kiusriñiqsuq, “Ukpiqutaiññiaqpat ilipsitñi. Naagasuli killukuaqmiusi. Qanutunaglaan nayuqtigiraksraġivisi? Qanutunaglaan igḷutuqtigiraksraġivisi?” Tavrali nipliutiniġaa iñuk, “Uvuŋautisaqsiuŋata iġñiġiñ!” ");
INSERT INTO eskNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nukatpiaġruum utlautiłhani irrusiqł̣uum ulġuqsraaqtinniġaa nunamun qiiqsruqtitkaqsipḷugu. Jesus-ŋum iñiqtiġniġaa irrusiqł̣uk aasiiñ mamititlugu nukatpiaġruk utiqtitlugu aapaŋanun. ");
INSERT INTO eskNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iluqatiŋ iñuich quviġusuutiginiġaat kamanaqtuaq saŋŋigikkaŋa Agaayyutim. Iñuich quviġusuktitlugitsuli Jesus-ŋum savaaġikkaŋanik nipliutiniġai maliġuaqtini, ");
INSERT INTO eskNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Piiguġniaqnagu una uqauttutiginiakkaġa ilipsitñun! Iġñiŋa Iñuum aatchuutigikkaugisiruq iñuŋnun tuqqutqulugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aglaan qanuutautilaaŋa uqautigikkaŋan iriqsimaniqsuq maliġuaqtaiñiñ. Taatnaqługu kaŋiqsiḷguiññiġaat. Taluqsraqhutiŋ apiqsrulguiññiġaat taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maliġuaqtit qapiqtaiḷitraaqsiñiqsut nalliqtiŋ kamanaġniqsraupmagaan. ");
INSERT INTO eskNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus-ŋum iḷisimaniġai isummatilaaŋat. Qiññuaġniġaa iḷiḷgaaq inillakługu saniqqamiñun ");
INSERT INTO eskNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nipliutiplugich tamatkua, “Kisupayaam akuqtuġumiuŋ iḷiḷgaaq pisigiluŋa tavra akuqtuġaaŋa; suli kisupayaam akuqtuġumiña akuqtuġisipmigaa taamna tuyuġirigikkaġa. Iñuk kamanaiññiqsrauruaq akunnapsitñi ilaa kamanaġniqsrauruq.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John nipliqsuq, “Ataniiq, tautukkikput iñuk anitchiraġaqtuaq irrusiqł̣uŋnik atuqługu atqiñ. Iñiqtiġikput atakkii uvagut iḷagiŋitḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Nutqaqtinniaŋaiqsiuŋ,” Jesus-ŋum nipliutiniġaa atlatlu maliġuaqtai, “Atakkii kiñapayaaq akiḷḷiḷiqsuŋitchuaq ilipsitñik ilipsitñuktuqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus-ŋum iḷitchuġikamiuŋ utiqtuksraułłi Agaayyutmun isummiġñiqsuq Jerusalem-mugukhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iglaułiġmiñi tuyuqaġniqsuq uqqiraqtiŋnik sivumiñi nunaaqqianun Samaria-m itqanaiyautitqupluni tukkuksraġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aglaan iñuich tarani akuqtuŋiññiġaat atakkii Jerusalem-muŋniaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","James-ŋum suli John-ŋum, maliġuaqtikkiñ, tautukamitku taamna nipliutiniġaak, “Ataniiq, qiññuaquvisiguk ikniġmik qiḷaŋmiñ piyaqquityaqulugu tamatkuniŋa?” ");
INSERT INTO eskNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus-ŋum kiŋiaqługich iñiqtiġniġai. ");
INSERT INTO eskNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aasiiñ Jesus maliġuaqtaiḷu iglauniqsut atlamun nunaaqqiuramun. ");
INSERT INTO eskNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Igliqtaułiġmikni iñuum nipliutiniġaa Jesus, “Malikkisigikpiñ napmupayaaġuvich.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus-ŋum kiuniġaa, “Kayuqtut sisiqaqtut, suli tiŋmiurat siḷami ugluqaqhutiŋ, aglaan Iġñiŋa Iñuum iniksraitchuq minġuiqsiaġviksraġmiñik.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus-ŋum atla iñuk nipliutiniġaa, “Maliŋŋa.” Aglaan taavruma iñuum nipliutiniġaa, “Ataniiq, sivulliulugu aiḷaŋa iḷuviġiaġlugu aapaga.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus-ŋum kiuniġaa, “Ki, tuquŋaruat iḷuviġḷitruŋ tuquruaġikkaqtiŋ. Aglaali ilvich quliaqtuaġiaġiñ aŋaayuqautaanik Agaayyutim nanipayaaq.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Atla iñuk nipliqsuq, “Ataniiq, malikkisigikpiñ. Aglaan sivulliulugu qiñiġuiqsaaġiaġlagich iḷagikkatka.” ");
INSERT INTO eskNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus-ŋum nipliutiniġaa, “Kiña iñuk nunniuqtuaq kiŋiaŋŋatigalugu atuġumiñaitchuq sumun aŋaayuqautaani Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kiñuagun taavruma atanġuruaq piksraqtuq piñasukipiaq qulit malġuŋnik iñuŋnik tuyuġiplugich malġuullaaplugich. Aullaqtitkai sivumiñi nunaaqqipayaanun tikitchaġumakkaġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesus-ŋum nipliutiniġai, “Katitaksraqtugaluaqtuq aglaan savaktit katitchiruksrat ikittut. Iŋiqsruġumausi atanġanun katitchivium tuyupsaaqulugu katitchiruksranik savaqulugich nautchiiviŋmiñi. ");
INSERT INTO eskNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aullałhiñaurusi. Tuyuġiniaġipsi ipnaiyaatun liilaa akunġatnun amaqqut. ");
INSERT INTO eskNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aullautriñiaqasi manikuviuramik naagaqaa puukatauramik naagaqaa sakpakkimik; igliqtaułłapsitñi nutqaaqtuġniaqasi kisumununniiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Supayaami isiġniġupsi tupiġmun nipliutiyumagisi, ‘Tutqiun iñuiñun uumani tupiġmi illi.’ ");
INSERT INTO eskNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Iñuk tavrani iñuuniaġniqpan piqpaksriḷuni tutqiutmik, taamna tutqiun ittuiñaġisiruq ilaani. Aasiiñ taatniinġiññikpan taamna tutqiun utiġisiruq ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nayuutiyumausi taavrumani tupiġmi niġiḷusiḷu imiġusiḷu qanutchipayaamik aatchuqpasi, atakkii savakti akiḷiusiaksraqaqtuksrauruq. Nuktaġniaqasi tupiġmiñ atlamun. ");
INSERT INTO eskNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Supayaami nunaaqqimukkupsi paġlakpasi niġiyumausi payugutaatnik, ");
INSERT INTO eskNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mamititchiḷusi atniġñaqtuanik taavrumani nunaaqqimi, uqautilugich iñuich, ‘Aŋaayuqautaa Agaayyutim qalliruq ilipsitñun.’ ");
INSERT INTO eskNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Aglaan nunaaqqimukkupsi nani iñuich paġlaŋitpasi nipliġumausi tumitchaani, ");
INSERT INTO eskNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Apyua nunaaqqipsi isigaptikniñ ipsuktuġisigikput; aglaan itqaġiyumagiksi una, Aŋaayuqautaan Agaayyutim qallisigaasi!’ ");
INSERT INTO eskNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Uqautigipsi, atanniivium uvluani Agaayyutim iḷunŋugitlukkisigai Sodom-miut taavrumakŋa nunaaqqimiñ taatniittuamiñ. Jesus uqaanikman taavrumiŋa, maliġuaqtai aullaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nakłiuŋ, Chorazin-naġmiusii! Nakłiuŋ, Bethsaida-ġmiusii! Savaaqaġaluaqtuŋa iñugiaktuanik quviqnaqtuanik akunnapsitñi. Makua quviqnaqtuat qiñikkasi savaaŋuniqpata Tyre-miḷu Sidon-miḷu iŋiḷġaanimma, iñuich taimani isummitqianikkayaqtut miissuŋnik atnuġaaġutiŋ suli aġramun aquvillutiŋ qiñiqtillugu taavrumuuna mumił̣iqtiŋ killuqsautmikniñ! ");
INSERT INTO eskNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Atanniivium uvluani igḷutuyunaitḷukkisiruq ilipsitñi ukunakŋa Tyre-miñḷu Sidon-miñḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ilipsitñunlu Capernaum-miusii! Kamanaġnasugivisi qiḷaŋmunaglaan? Iktaugisirusi anasiñŋuqsaġviŋmun!” ");
INSERT INTO eskNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesus nipliutiniġai maliġuaqtini, “Kisupayaam naalaġnikpasi naalaġnigisipmigaaŋa, suli kisupayaam ayakpasi ayakkisipmigaaŋa, suli kisupayaam ayakpaŋa, ayakkisipmigaa taamna tuyuġirigikkaġa.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Piŋasukipiaq qulit malġuich iñuich utiqamiŋ quviasullapiaġniqsut nipliqhutiŋ, “Ataniiq, makua irrusiqł̣uichunniiñ tupigiraġigaatigut tilikaptigiŋ anitquplugich atuqługu atqiñ!” ");
INSERT INTO eskNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus-ŋum kiuniġai, “Tautukkiga tuunġaq atqaqman atripḷugu ikniqpalak pakmakŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naalaġniḷḷagitchi! Saŋŋiksritkipsi tutmatlasipḷusi nimiġianik putyuutiliŋniglu akimatlasipḷusiḷu saŋŋianiñ piyuaqtigikkapsi. Suli tamatkua atniġumiñaitchaasi. ");
INSERT INTO eskNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Quviatchautiginagu irrusiqł̣uŋnun tupiginiḷusi aglaan quviatchautigitluksiuŋ atiġikkasi aglausimaaġniḷugich pakmani.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Taavrumani Ipqitchuam Irrutchim quviatchaktinniġaa Jesus suli uqaqtitlugu, “Aapaaŋ, atanġuruatiin qiḷaŋmi nunamiḷu, quyagikpiñ! Sagviġitin puqiitchuanun sut iriqsimaruat puqiksuaniñ iḷisimaruaniñḷu. Aa, Aapaaŋ, taamna sivunniġikkan quviagigiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aapaa qaitchigaaŋa saŋŋipayaamik. Kia-unniiñ nalugaa Iġñiġuruam kisuupiaqtilaaŋa aglaan kisimi Aapauruam, suli kia-unniiñ nalugaa Aapauruam kisuutilaaŋa aglaan Iġñiġuruam, suli tamatkua Iġñiġuruam sagviutisukkani Aaparuamik.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesus-ŋum kiŋiaqamigich maliġuaqtini nipliutiniġai kisiŋŋuutiplugich, “Quvianamiurusi atakkii iñuurusi taututlasipḷusi atuumaruanik! ");
INSERT INTO eskNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Uqautigipsi, Iñugiaktuat sivuniksriqirit suli umialgich tautugummiuġniġaat tamanna tautukkaqsi aglaan tautulguitḷugu, suli tusaayummiuqługu tusaakkaqsi aglaan tusaalguitḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iḷisautrim maliġutaksranik utlakługu Jesus uuktuaġuŋniġaa apiqsruqtaqługu, “Iḷisautrii, sumik savaktuksrauvik akuqtuisukkuma isuitchuamik iñuułiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus-ŋum kiuniġaa, “Qanuġmi maliġutaksrani aglaksimaaqpa? Qanuq agliqiplugu iḷisauttutigiraġiviuŋ?” ");
INSERT INTO eskNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aŋutim kiuniġaa, “Piqpagiyumagiñ ataniq Agaayyutin iluqaaniñ uummatipniñ, iluqaaniñ iñuutchipñiñ, iluqaaniñ sayagikkapniñ, iluqaaniñ isummatipniñ; suli piqpagilugu iñuuniaqatin iḷiḷugu iliptun.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus-ŋum kiuniġaa, “Tarra, nalauttutin. Taatna iñuuniaġuvich iñuugisirutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aglaan aglaliqirim nalaunŋanasugniaqhuni iŋmiñik apiqsrulgitchaa Jesus, “Kiña iñuuniaqatigivigu?” ");
INSERT INTO eskNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus uqaaqtuagaqsiruq, “Iḷaatniguuq iñuqaġniqsuq Jericho-muktuamik Jerusalem-miñ. Iglauŋŋaan tigliŋniaqtit aŋallaqłuŋniġaat atnuġaiqł̣ugu karukługu unitḷuguasiiñ tuqułhiñaaġuqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Agaayuliqsiptuuq igliġmiñiqsuq tamarrumuuna tumitchaakun. Tautukamiuŋ taamna iñuk apqusaałhiñaġniġaa igḷuagun tumitchaam. ");
INSERT INTO eskNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ikayuqtiptuuq agaayyuvikpaŋmi taatnatun pipmiñiqsuq, aasiiñ tautukamiuŋ taamna iñuk apqusaaġmiñiġaa igḷuagun tumitchaam. ");
INSERT INTO eskNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aglaan Samaria-ġmiu iglaupmiñiqsuq tamarrumuuna tumitchaakun. Tikitmiuq taavrumuŋa aŋallaqłuktamun, aasiiñ tautukamiuŋ iḷunŋugiliutiplugu. ");
INSERT INTO eskNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Utlakługu kuvviqiniġai uqsruġutmik wine-miglu kiḷḷiaġniŋi aasiiñ mamitaqługich. Taatnaanikami iḷiñiġaa taamna iñuk natmaksiġviuraġmiñun nullaġviŋmuutiplugu qaunagiaqsipḷuguasii. ");
INSERT INTO eskNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Uvlutqikman manniññiġaa malġuŋnik nullaġvium iñua uqautiplugu, ‘Qaunagiyumagiñ. Tikiumatqikkuma tamaunnaaġluŋa akiḷiġisigiga qaunaksrił̣ipkun ilaanik akiqsruutiqaġniġupkiñsuli.’” ");
INSERT INTO eskNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesus-ŋum apiqsruġniġaa iḷisautri, “Qanuq isumaniqpich taapkunuuna piŋasutigun? Nalliat iñuuqatauva taavrumuŋa iñuŋmun aŋallaqłukkauruamun tigliŋniaqtitigun?” ");
INSERT INTO eskNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aglaliqirim kiuniġaa, “Taamna nagliktuiruaq ilaanik.” Jesus-ŋum nipliutiniġaa, “Taatnatun iñuuniaġiñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus maliġuaqtiniḷu iglautuiñaqhutiŋ tikiññiqsut nunaaqqiuramun. Aġnam tavrani atilgum Martha-mik aiyugaaġniġaa kiŋuniġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aasiiñ aniqatiqaġniqsuq atiqaqtuamik Mary-mik. Aquptaaqhuni isigaiñ saniġaatnun atanġuruam naalaqtuaġniġaa iḷisautripman. ");
INSERT INTO eskNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aglaan Martha alapisrautiqaġniqsuq suraksraġayaaġmiñik. Utlakługu Jesus uqautiniġaa, “Ataniiq, sugiŋitpiuŋ aniqatma kisivripkaqmaŋa? Uqauttuuŋ uvuŋaqulugu ikayuġiaġluŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Atanġuruam kiugaa, “Annaa, Martha! Isumaaluktutin supayaanik. ");
INSERT INTO eskNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aglaan atausiq piitchuiḷḷapiaqtuq. Mary-m piksraqtaaġigaa nakuuniqtaq atlat piiġumiñaisaŋat ilaaniñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iḷaŋatni uvlut Jesus agaayulgiññiqsuq kisiŋŋuqhuni. Agaayuŋŋaiqman iḷaŋata maliġuaqtaiñ nipliutigaa, “Ataniiq, iḷisauttutigut qanuq agaayułiksraptiknik John iḷisautripmatun maliġuaqtimiñik.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus nipliutiniġai, “Agaayugupsi itnaġusi, ‘Aapapta: Iñupayaaq nunami kamaksriḷi ilipnik ipqiqsitlugu taavrumuuna atqiñ. Aullaġniiḷi aŋalatchił̣hiñ iñupayaanik. ");
INSERT INTO eskNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aatchuqtigut uvluġaġikpan niqimik inuġikkaptiknik. ");
INSERT INTO eskNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Natqigutiluta killuqsautiptiknik natqigutrisimaaqmatun savamaqłuutriruanik uvaptiknun. Sivulliutiniaqasigut uuktuaqsiułiġmun.’” ");
INSERT INTO eskNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesus nipliutigai maliġuaqtini, “Iḷapsisamma utlakkayaġaa iḷauraani tupqanun unnuami nipliutilugu, ‘Iḷauraaŋ, simmiḷiaksraġuktuŋa piŋasunik qaqqianik. ");
INSERT INTO eskNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Iḷauraaġa iglauruaq tikiumaruq tupimnun. Niqaitchuŋa niġipkautiksraŋanik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iḷauraaŋan kiunayaġaa tupqum iḷuaniñ, ‘Iḷaksianaŋa! Talu kiluusaaniktuq. Qitunġatkalu uvaŋalu nallaaniktugut. Makitchuŋitchuŋa aatchuġiaġutin.’ ");
INSERT INTO eskNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Uqautigipsi, una makitchuŋitkaluaġuni aatchuġiaġlugu qaqqumik iḷauraaġiłhagun, makitchumiñaqtuq aatchuġiaġlugu inuġikkaŋanik atakkii taamna iŋiqsruqtuiñaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Taatnamik nipliutigipsi, Iŋiġupsi qaisaugisiruq ilipsitñun; pakaaqaġupsi paqitkisigiksi; katchaktuġupsi talu aŋmakkauniaqtuq ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Atakkii kisupayaaq apiqsruqtuaq akuqtuigisiruq, suli pakaaqaqtuaq paqitchigisiruq, suli talu aŋmakkaugisiruq kisupayaamun katchaktuqtuamun. ");
INSERT INTO eskNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Uvva kisupayaam aapauruam aatchuġayaqpauŋ iġñi nimiġiamik iŋiqsruqpani iqaluktuġukhuni? ");
INSERT INTO eskNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naagaqaa aatchuġayaqpauŋ putyuutiliŋmik iŋiqsruqpani manniksuġukhuni? ");
INSERT INTO eskNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pigiitchaluaqhusi iḷisimaraġigiksi qanuq aatchułiksraqsi nakuuruanik qitunġapsitñun. Maatnaasu Aapa pakmaniittuaq aatchuiñiapiaqtuq Ipqitchuamik Irrutchimik tamatkunuŋa iŋiqsruqtuanun iŋmiñun.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus anitchiñiqsuq irrusiqł̣uŋmik uqalguitchuamik. Aasiiñ irrusiqł̣uk anipman taamna iñuk uqaaqsiñiqsuq. Iñuich quviġutchaŋniqsut ");
INSERT INTO eskNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","aglaan iḷaŋich nipliqhutiŋ, “Beelzebul-ŋum, aŋalataata irrusiqł̣uich, qaitchiñiġaa saŋŋimik anitqataitḷasipḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Atlat uuktuaġukługu Jesus apiqsruġniġaat savaaqaquplugu quviqnaqtuamik iḷitchuqqutaulugu Agaayyutmun tuyuġitilaaŋanik qiḷaŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aglaan Jesus-ŋum iḷisimaniġai qanuq isummatiqałhat. Nipliutiniġai, “Iñuich nunaaqqikpaŋmi akikŋautikpata avatmun makitayumiñaitchuq akuni. Atanġuviich aviksimagumiŋ suksraunġiġñiaqtut. ");
INSERT INTO eskNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Taatnatuntuuq tuunġaum irrusiqł̣uŋi avgumagumiŋ akikŋaqtuutilutiŋ avatmun aŋaayuqautaa isukłiññiaqtuq. Nipliqsusi anitchiraġaġnipḷuŋa irrusiqł̣uŋnik atakkii Beelzebul qaitchipḷuŋaguuq saŋŋimik savaaqatlasipḷuŋa taatnatchimik. ");
INSERT INTO eskNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Anitchiraġaġuma irrusiqł̣uŋnik Beelzebul-kun kisukun maliġuaqtigikkasi anitchiraqmiraġivat? Tarra iliŋich atanniqsuqtiginiaġisi iḷisimanaqsiḷugu killukuapiaġataqtilaaqsi. ");
INSERT INTO eskNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aglaan anitchiraġaqtuŋa irrusiqł̣uŋnik Agaayyutim irrusiḷḷautaŋagun, taavrumuuna nalupqinaitchuq Agaayyutmun aullaġniiŋaniktilaaŋa aŋaayuqautaa akunnapsitñi.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Saŋŋiruam iñuum paqnasimaaqmagich satkupayaani qaunaksripḷuni tupiġmiñik, suurai tiglikkautlaitchut. ");
INSERT INTO eskNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aglaan saŋitḷuktuam aŋuyakługu akiiḷikamiuŋ aullautiraġigai satkui tunŋavigikkaŋi, avguqługich tiglikkani piqatmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iñuk piqatauŋitchuaq uvamni akikŋautiruq uvamnun, suli iñuk katitchiqatauŋitchuaq siamitchił̣hiñaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Irrusiqł̣uk anikami iñuŋmiñ iglauraqtuq paliumaruakun nunakun pakakhuni minġuiqsiallagviksraġmiñik. Paqiŋitñamiuŋ nipliqsuq, ‘Utiġniaqtuŋa tupiġmun unisaġikkamnun.’ ");
INSERT INTO eskNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Utiqami paqinniġaa ini salumaplugu suli iłuaqsaqsimapluni. ");
INSERT INTO eskNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aasiiñ anipḷuni aggiutigai tallimat malġuich irrusiqł̣uich pigiitḷuktuat iŋmiñiñ. Isiqhutiŋ iñuuniaġniqsut tavrani. Taamnaasiiñ iñuk pigiiḷitḷuŋniqsuq sivuaniġniñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus uqaqtitlugu aġnam iñugayaaniñ nipliutiniġaa, “Qanutun quvianaqtigiva aġnaq iġñiruaq ilipnik suli miluktitlutin!” ");
INSERT INTO eskNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus-ŋum kiuniġaa, “Aa, aglaan qanutun quvianatluktigivat tamatkua tusaaruat uqałhanik Agaayyutim aasiiñ tupigiplugu!” ");
INSERT INTO eskNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iñuich iñugiaksisaiñaaqsipmata Jesus uqaaqsiñiqsuq, “Iñuich uvlupak pigiitchuaŋuruat qiñiġuktut quviqnaqtuamik savaamik iḷitchuqqutaulugu kisuutilaamnik, aglaan qiñiġumiñaitchut taatnatchimik. Qiñiłhiñaġisigaat quviqnaqtuaq savaaq atuupmatun sivuniksriqirimun Jonah-mun. ");
INSERT INTO eskNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iġñiŋa Iñuum iḷitchuqqutauniaqtuq iñuŋnun marrumani uvlumi, atripḷugu sivuniksriqiri Jonah iḷitchuqqutauruaq iñuiñun Nineveh-m. ");
INSERT INTO eskNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Atanniivium uvluani atanġuruam aġnam aggiqsuam uŋallamiñ maatnaasu patchisigigisigai iñuich iñuuruat uvlupak atakkii taimmani iglauniqsuq uŋasiksuamiñ naalaġnityaqhuni Solomon iḷisautripman puqiutmigun. Ataŋii, iñuk maaniittuq kamanatluktuaq Solomon-miñ. ");
INSERT INTO eskNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Atanniivium uvluani iñuŋisa Nineveh-m patchisigigisipmigai iñuuruat pakmapak, atakkii taimani isummitqiŋñiqsut mumikhutiŋ killuqsautmikniñ tusaakamitruŋ Jonah-m quliaqtuaqałha. Ataŋii, iñuk maaniittuq kamanatluktuaq Jonah-miñ! ");
INSERT INTO eskNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kia-unniiñ ikitnamiuŋ naniq iritlaitchaa naagaqaa iḷitḷaitchaa ataanun utkusium aglaan iḷiraġigaa naniqaġviŋmun. Iñuiḷḷi qiñiġumagaat qauma isiġumiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Irisi nannisun ittut timipsitñun. Irrakkiñ qiñitlakpaknik qaunagilguniaqtutin aullapayaaġuvich. Aglaan irrakkiñ pigiitpaknik saptaaqsiñiaqtutin. ");
INSERT INTO eskNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Qaunagititchi qaumaruaq iḷupsitñi taaqtuaŋitchumuuq. ");
INSERT INTO eskNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iluqani timin qaummaaġikpan, iḷaŋa taaqtuamiisuŋaqani, qaummaaġikkisiruq iluqaani, atriḷugu naniq qaummatripmatun ilipnik qaumamiñik.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus uqaŋaiqman, Pharisee-ŋuruam aiyugaaġniġaa niġiyaqtuaquplugu. Malikługu nayummagataġniqsuq tamauŋa niġiaqsipḷuniasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisee-ŋuruaq atlasuktuq iḷitchuġikamiuŋ Jesus-ŋum iġġuŋisilaaŋat argaŋiñ niġigaluaqani. ");
INSERT INTO eskNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Atanġuruam nipliutiniġaa, “Aatai Pharisee-ŋuruasii, salumapkairusi qaałhiñaŋitñik qallutipsi suli puggutapsi, aglaan iḷupsitñi immaukkaqtusi ivayaqtułiġmik suli pigiiḷiqiłiġmik. ");
INSERT INTO eskNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ukunani iḷisaġunġitchalukkut. Agaayyutim iñiqtaġigik iluqaanik qaaŋalu iḷualu. Taatnatuntuuq iñiqtaġigik iñuum timaalu isumaalu. ");
INSERT INTO eskNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aatchuutigisiuŋ immaŋat qallutipsiḷu puggutapsiḷu nagliŋnaqtuanun. Taatnaġupsi suapayaaq salumagisiruq sivuġaani Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nakłiuŋ Pharisee-ŋuruasii! Qulikuraqtusi Agaayyutmun avuuġutinik naurianik. Naagatai iñuŋnik aŋalatchitḷaitchusi nalaullugu suli piqpaksriñġitḷusi Agaayyutmik. Atuumaraksraqtarra suli qulikuruksraupmiusi. ");
INSERT INTO eskNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nakłiuŋ, Pharisee-ŋuruasii! Qiñiqusaaġaqtusi aquppiutaġiksaanun aquvitlusi katraġviŋñi suli paġlatqusuurusi kamagilusi tauqsiġñiaġviŋñi. ");
INSERT INTO eskNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nakłiuŋ, ukpiŋŋuaqtisii! Atriqaqtusi nalunaitŋutchiġniġiḷaanik iḷuviġnik iñuich pisugvigikkaŋitñik qaaŋatigun naluplugich.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iḷaŋata iḷisautrit maliġutaksranik nipliutiniġaa, “Iḷisautrii, taavrumiŋa nipliqavich upyaktuġiptiguttuuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus-ŋum kiuniġai, “Nakłiuŋ, iḷisautrisii maliġutaksranik. Iñuich natmiġaġigisi kivipqaqtaġnaqtuanik aglaan ilipsi isatlaitchisi argagikkasi ikayuutigisuglugich natmaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nakłiuŋ! Iñiqsiraqtusi iḷuviġiksaanik sivuniksriqirinun, taipkunuŋaami sivuniksriqiripayaanun sivulliaġikkapsi tuqqutaġikkaŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Taatnaqapsi aŋiqataupmiusi, aasiisuli iłuagigiksi tamanna savaaġikkaŋat sivulliaġikkapsi. Taipkua tuqqutchiñiqsut sivuniksriqirinik, naagasuli nappairusi iḷuviŋitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Piqutigiplugu Agaayyun nipliġñiqsuq puqił̣iġmigun, ‘Tuyuqaġisiruŋa sivuniksriqirinik uqqiraqtiniglu iñugikkamnun. Tamatkua tuqqutkisiḷgitchaich iḷaŋich suli piyuaġlugich atlat.’ ");
INSERT INTO eskNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Taatnaqhutiŋ Agaayyutim anasiñŋuqsaġisigai iñugikkaŋi pakmapak iñuaqtułhatigun iluqaŋitñik sivuniksriqirinik aullaġniił̣haniñaglaan nunam, ");
INSERT INTO eskNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","aullaġniipḷutiŋ tuqqutaułhaniñ Abel-ŋum tuqqutaułhanun Zechariah-m, tuqqutauruam akunġakni tuniḷḷaġvium suli ipqitchuam inim. Aa, nipliutigipsi, iñuich iñuuruat pakmapak anasiñŋuqsakkaugisirut iluqaagun tamarrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nakłiuŋ, iḷisautrisii maliġutaksranik! Kaŋiqsitḷaitkiksi Agaayyutim uqałha uqqiraqtaalu suli iḷisauttutigiŋitḷugich. Atriqaqtusi iñuŋmik aŋmautiqaqtuaq Agaayyutim aŋaayuqautaanun aglaan aŋmaŋitḷugu. Isiŋitchusi sulipsuuq piñaiḷutchiqsuġmipḷugich tamatkua isiġniuraqtuat.” ");
INSERT INTO eskNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus aullaaqsipman tavrakŋa aglaliqirit suli Pharisee-ŋuruat naipiqtuaqsiñiġaat apiqsruqtaqługu supayaatigun, ");
INSERT INTO eskNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","pisaġisukługu uqaqpan nalaunġiḷḷuni. ");
INSERT INTO eskNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iñugaaġruich kativiiñaqhutiŋ tatruutivaitḷutiŋ tutiliqatautiniqsut. Jesus-ŋum nipliutiqqaaġniġai maliġuaqtini, “Qaunagititchi qaqqiam puvlaksrautaatniñ Pharisee-ŋuruat, ami ukpiŋŋuaġutaatniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Qanutchipayaaq matukkauruaq matuiġisiruq, suli iluqani iriqsimaruaq iḷitchuġipkakkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Taatnamik qanutchipayaamik nipliaguvich taaqtuami tusaġnaġisiruq qaumaruami, suli qanutchipayaamik isivrukkuvich inaurami nipitusiḷuni uqautaugisiruq nunaaqqiñi. ");
INSERT INTO eskNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Uqautigipsi, iḷauramaaŋ, iqsiginagich tamatkua tuqqutchiraġaqtuat timimik aasiiñ taavruma aquagun savaaqalguiḷutiŋ pigiitḷuktuamik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Urriqsuutiniaġipsi taluġiraksramik, Sivuuġagisiuŋ Agaayyun tuqupkaiŋanikami aŋalatchił̣iqaqtuaq anasiñŋuqsaġviŋmuktitchitḷapluni. Ukpiġisitŋa, ilaa taluġiraksraġigiksi. ");
INSERT INTO eskNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tallimat tiŋmiurat tunitḷaiññiqpat malġuŋnun maniuraaŋnun? Naagasuli Agaayyutim atausiqunniiñ tiŋmiuraq piiguumaŋitchaa. ");
INSERT INTO eskNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Taatnatuntuuq ilipsitñi, nuyaġikkasiunniiñ niaqupsitñi kisisimaaqtut. Taatnamik iqsiñasi, akisutluktusi iñugiaktuaniñ tiŋmiuraniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nipliutigipsi, Kiña nalupqinaiġuni uqaqpan sivuġaatni iñuich piginiḷuni uvamnun, Iġñiŋan Iñuum nalupqinaiġḷugu uqaġigisipmigaa sivuġaatni isaġuligikkaŋiñ Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aglaan kia ayakpaŋa sivuġaatni iñuich Iġñiŋan Iñuum ayakkisipmigaa sivuġaatni isaġuligikkaŋiñ Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Agaayyutim natqigutiyumaaġaa iñuk uqaġniqłuktaqtuaq Iġñiŋanik Iñuum. Aglaan Agaayyutim natqigutiyumiñaitchaa iñuk uqaġniqłuutiqaqtuaq Ipqitchuamik Irrutchimik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Iñuich uqaqsittaaġviŋmuutikpasi sivuġaatnun atanġich suli aŋalatit, isumaaluŋniaqasi qanuq naagaqaa sumik uqaġniaqtilaapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Atakkii tavraġuqpan Ipqitchuam Irrutchim iḷisautrigisigaasi uqaksrapsitñik.” ");
INSERT INTO eskNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iñuk iñugaaġruŋniñ nipliġñiqsuq Jesus-mun, “Iḷisautrii, uqauttuuŋ aniqatiga aviqulugich paisannaktaaksravuk aapamnuk unisaġikkaŋi.” ");
INSERT INTO eskNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus-ŋum kiuniġaa, “Aŋuun, atanniqsuqtauyumiñaitchuŋa avguitḷasiḷuŋa suuraksrapsitñik ilipnunlu aniqatipnunlu!” ");
INSERT INTO eskNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nipliġñiqsuq iluqaŋitñun, “Munaġititchi siqñaktuałiġmiñ! Atakkii suuraġaiksigaluaġumi iñuk piññautigiyumiñaitchaa iñuułiġmik.” ");
INSERT INTO eskNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tavrali Jesus-ŋum uqautiniġai atrikusautmik, “Iḷaatniguuq iñuqaġniqsuq umialguruamik. Nunaŋa nauqpauraqhuni kipraksranik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Isumaaqsiñiqsuq, ‘Iniksraigutigitka iluqaisa nauriatka. Qanuġisivik? ");
INSERT INTO eskNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Itnaġisiruŋaliqaa,’ uqaġniqsuq iŋmiñun, ‘siqumitkisigitka tugvaġvitka aasiiñ nappaiḷuŋa aŋitluktuanik. Tavruŋa tugvaġisigitka nauriaġikkatka suli atlat suuratka. ");
INSERT INTO eskNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Taatnaanikkuma nipliġisiruŋa uvamnun, Iñuuk, anaktaitchutin. Piññaktutin suurapayaanik inuġikkaqnik iñugiaktuani ukiuni atugaksranik. Ki aasiiñ iñuuniaġiñ qaġalutin niġiḷutin imiġutinlu. Quviasugiñ!’ ");
INSERT INTO eskNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aglaan Agaayyutim nipliutiniġaa, ‘Kinnauniqsutin! Marrumani unnuami tuqugisirutin. Kia pigigisivagich suurannaktapayaatin tugvakkatin ilipnun?’” ");
INSERT INTO eskNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesus niplipsaaġniqsuq, “Taatna ittuq tugvairuani umialgutiksranik iŋmiknułhiñaq aasriiñ suksraitḷutiŋ Agaayyutitŋaqtauruamik.” ");
INSERT INTO eskNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus-ŋum nipliutitqiŋñiġai maliġuaqtini, “Uqautigipsi isumaaluquŋitḷusi iñuułiġmik, sumik niġiñiaqtilaaksrapsitñik naagaunniiñ sumik atnuġaaġniaqtilaapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Iñuułiq pitḷuktuaŋuniqsuq niqimiñ, suli timi pitḷuktuaŋuruq atnuġaaniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tautullaksigichata tulukkat, Nautchiitḷaitchut naagaqaa katitchitḷaitchut, suli siġḷuaqaŋitchut tugvaġviksramiknik. Naagatai Agaayyutim niġipkaġaġigai! Akisutluktusi tamatkunakŋa tiŋmił̣uŋniñ! ");
INSERT INTO eskNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iḷapsi iñuułłi takłiḷaalguitchaa isumaaluutigilugu. ");
INSERT INTO eskNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aŋalataġilguiññiġupsiuŋ sua-samna mikiruaq, suvaata isumaaluutiqaqpisi atlanik sunik? ");
INSERT INTO eskNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tautullaksigich nauriat atnuġarritḷaitchuat iŋmiknik. Aglaan uqautigipsi, Atanġum Solomon atnuġaallautat pigigaluaqługich atriŋitchai tamatkua piññaqnaqtuat nauriat. ");
INSERT INTO eskNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Agaayyutim atnuġaaqatlakpagich nauriat—ivgich illakhutiŋ uvlupak aasiiñ ikipkaqługich uvlaakun—atnuġaatlukkumiñaiññiqpasi? Aatai, ukpiqsrił̣ikiññiaqpat! ");
INSERT INTO eskNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Isumaalukasi niġił̣iksrapsitñik imiłiksrapsitñiglu. ");
INSERT INTO eskNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Atakkii ukpiŋaitchuat marrumani nunami isumaaluutiqaġaqtut tamatkuniŋa. Aapagikkapsi iḷisimagaa inuġikkaqsi. ");
INSERT INTO eskNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Taatnaqhusi pakaaqqaaġilugu Agaayyun aŋalatchiruaq nalaunŋaruaŋupluni umialiktun. Taatnaġupsi qaitchigisigipsi inuġikkapayaapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Iqsiñasi iñugiakitchuasii, atakkii aapagikkapsi qiḷaŋmiittuam aatchuġukkaasi ilaan pigikkaŋanik qaunagilusriḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tunisigik sulliñaurasi qaiḷḷuguasiiñ akuqtuaq nagliŋnaqtuanun. Taatnaġupsi inniaqtuq maniqaġviqaqmatun piunġiġumiñaitchuamik. Tugvaqsiuŋ umialgutiksraqsi pakmuŋa piyaqquġumiñaitchuamun, atakkii tigliŋniaqtim tiglikkumiñaitchai suli qupilġut piyaqquġumiñaitḷugich. ");
INSERT INTO eskNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nani umialgutitin itpata tavrani uummatin itkisipmiuq. ");
INSERT INTO eskNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Itqanaiyaġumausi savautrił̣ipsitñun suli nannisi ikumalugich, ");
INSERT INTO eskNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","atriḷugich savaktit utaqqiruat aŋaayuqaġmiknik utiqsaġumaruamik katchuutiruat niġiqpagviatniñ. Tikiḷḷuni katchaktuqpan aŋmautinayaġaat utaqqipkasuŋatnagu. ");
INSERT INTO eskNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Qanutun quviasuktigivat savaktit aŋaayuqaġmiŋ paqitpatiŋ itqumalutiŋ suli itqanaiḷḷutiŋ utiqpan. Naalaġnisitchi, Aŋaayuqaq saalisaġisiruq aquvitillugich aasiiñ payuglugich. ");
INSERT INTO eskNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Qanutun quvianaqtigivat Ataniġmiŋ paqitpatiŋ pił̣hiñaaġuġutiŋ aggiqsiġniqpan unnuam qitqani unniiñ aquagun. ");
INSERT INTO eskNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nalupqigiŋitchiksi taamna, tupqum iñuan iḷisimagumiuŋ tigliŋniaqtim tikiumałiksraŋa isiqtinnayaitchaa tupiġikkaġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ilipsipsuuq, taatnatun pił̣hiñaaŋuyumausi, atakkii Iġñiŋa Iñuum aggiġisiruq sassaġniġmi niġiugiŋisapsigun.” ");
INSERT INTO eskNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter nipliġñiqsuq, “Ataniiq, uqautrivich taavrumiŋa atrikusautmik uvaptiknun naagaqaa iñupayaanun?” ");
INSERT INTO eskNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Atanġuruam kiuniġaa, “Uqallaglaŋa tuniqsimapluni suli puqikhuni savaktimik. Taamnauruq aŋaayuqaŋata iglaułiġmiñi qaukłiḷiutikkaŋa atlat, savaktit niqiksritquplugich piñaqsikpan. ");
INSERT INTO eskNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Quvianamiuruq taamna savakti aŋaayuqaŋan paqitpani savaguni utiqpan. ");
INSERT INTO eskNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iḷumun uqautigipsi, Atanġum taamna savakti munaqsriḷiutiniaġaa iluqaitñun suuraġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aglaan taamna savakti qaukłiḷiutikkaŋa isummiġñiġumi, ‘Aŋaayuqaġa muluruq,’ tavrakŋaaglaan ipiġaqtuaqsiḷugich atlat savaktit aŋutit aġnatlu, suli niġiaqsiḷuni imiliġuniḷu, ");
INSERT INTO eskNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tavrauvaali aŋaayuqaŋa utiġisiruq niġiugiŋisillugu kilikkaluaqnagulu. Uuma atanġum piiġisigaa savagvianiñ piqasiutipkaġlugu tuniqsimaitchuanun. ");
INSERT INTO eskNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Taamna savakti qaukłiḷiutikkaŋa iḷisimagaluaqtuq aŋaayuqaġmi pisułhanik. Aglaan tupiksriŋitḷuni anasiñŋuqsausiaqallapiaġniaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aglaan savakti naluruaq ataniġmi pisułhanik nalaunŋaiḷiqiruaġlu anasiñŋuqsakkaugisiruq atqunaunġiḷaamik. Iñuk aatchuusiaqaqtuaq atqunaq iñuich niġiugvigigisigaat atqunaq. Aasiiñ iñuk aatchuusiaqatluktuaq iñuich niġiugvigitlukkisigaat. ");
INSERT INTO eskNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Aggiqsuŋa nunamun isummitqigiaqługich iñuich. Aggił̣iġa ittuq ikniqsuġmatun nunamun, aa, uvvatuq iknaktinŋaniksimali. ");
INSERT INTO eskNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Akuqtuigisiruŋa paptaaġutiksramik; qanutun iłuiḷḷiuqtigivik atuumaniałhanunaglaan! ");
INSERT INTO eskNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Isumavisi aggiutriñipḷuŋa tutqiutmik nunamun? Qaŋaa, aggiutriruŋa aviktuił̣iġmik. ");
INSERT INTO eskNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pakmaniñaglaan aŋayuqaaġiich tallimauyumiŋ avikkisirut, piŋasut akiḷḷiḷiġlugich malġuk suli malġuk akiḷḷiḷiġlugich piŋasut. ");
INSERT INTO eskNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aapa akiḷḷiḷiutiniaqtuq iġñiġmiñun suli iġñiq aapamiñun; aaka akiḷḷiḷiutiniaqtuq paniŋmiñun suli panik aakamiñun; aakaruam akiḷḷiḷiġisigaa ukuani suli ukuaŋuruaq aakaruani.” ");
INSERT INTO eskNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus-ŋum nipliutilgiññiġai iñuich, “Tautukapsiuŋ nuviya kanaknamiñ nipliġaqtusi sialuguġniaġnipḷugu, aasii sialuguġaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ikpigikapsiuŋ anuġi uŋallamiñ nipliġaqtusi uunaqsiñiaġnipḷugu, aasii uunaġuġaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ukpiŋŋuaqtausii! Iḷisimagaluaqtusi siḷaksramik qiññaŋagun nunam qiḷaumlu. Suvaatami naluvisiuŋ qanuutaułha atuumaruam pakmapak? ");
INSERT INTO eskNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Suvaata isivġiutlaitpisi ilipsitñik sum nalaunŋatilaaŋanik piraksrapsi? ");
INSERT INTO eskNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kia iñuum pasikpatin maliġutaksratigun aasii uqaqsittaaġviŋmuutilutin, pisuqtilaapni inillaksaġumagiñ agvisigikkan tikitkaluaqnagu uqaqsittaaġvik. Taatnaŋitchuvich tikiutigisigaatin atanniqsuqtimun, aasiiñ atanniqsuqtim qaitkisigaatin aikł̣iqsuqtinun, aasii aikł̣iqsuqtit iḷigisigaatin isiqtauviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Uqautigikpiñ, aniyumiñaitchutin isiqtauviŋmiñ akiḷiġaluaġnagich akiḷiaksrapayaatin.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesus uqaqtitlugu iḷaŋich iñuich Jesus-muŋniqsut uqautiplugu Galilee-ġmiunik Pilate-ŋum tuqqutaŋiñik tuniḷḷaqtuqtitlugich Agaayyutmun; auŋiḷḷu auŋich niġrutitlu avugiiksitlugich. ");
INSERT INTO eskNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus-ŋum kiuniġai, “Isummatigivisigich taapkua Galilee-ġmiut killiqirautluŋnipḷugich atlaniñ Galilee-ġmiuniñ tuqqutaupmata taatna? ");
INSERT INTO eskNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Qaŋaa, uqautigipsi, isummitqiŋitchupsi mumigusi killuutipsitñiñ iluqasi tuqugisirusi taapkunatitun. ");
INSERT INTO eskNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Itqallaksigik taapkua akimiaq piŋasut iñuich Siloam-mi tuqqutauruat nasirvium kattaqipmagich? Isummatigivisigiŋ killiqirautluŋnipḷugich iluqaitñiñ iñuŋniñ Jerusalem-miñ? ");
INSERT INTO eskNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Naagga, uqautigipsi, isummitqiŋitchupsi mumigusi killuutipsitñiñ iluqasi tuqugisirusi taapkunatitun.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesus-ŋum uqautiniġai uumiŋa atrikusautmik, “Iḷaatniguuq iñuk asirrisuuruamik napaaqtuqaġniqsuq nautchiiviŋmiñi. Asiaqaqmagaaqamiuŋ paqitchiŋiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aasiiñ nipliutiniġaa nautchirriqirini, ‘Uvva, piŋasuni ukiuni asiaqaqmagaaqapku taamna napaaqtuq paqitchiŋitchuŋa. Kippuuŋ! Atuqsiñaġaa manna nuna.’ ");
INSERT INTO eskNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aglaan nautchirriqirim kiuniġaa, ‘Aŋuun, taatniillagli atautchimi ukiumi. Nivaŋniaqtuŋa avataagun suli iḷḷiqilugu nagguksautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aasiiñ asirriñiqpan ukiutqikpan nakuuniaqtuq aglaan piŋitpan kipiniaġiga.’” ");
INSERT INTO eskNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iḷaŋatni Jew-ŋuruat minġuiqsiaġviata Jesus iḷisautriñiqsuq katraġviŋmi. ");
INSERT INTO eskNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tavrani itmiñiqsuq aġnaq irrusiqł̣uqaqtuaq naŋititchiruamik ilaanik akimiaq piŋasut ukiuni. Taatnaqhuni imupluni isiviḷguiḷiġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus-ŋum tautukamiuŋ tuqłuġniġaa iŋmiñuquplugu, “Aġnaaq, atniġñautaiqsutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iḷigai argaŋni ilaanun. Aġnam isivitiqami kamaksruaqsigaa Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aŋalataan katraġvium iłuagiŋiññiġaa Jesus-ŋum iłuaqsił̣ha minġuiqsiaġvium uvluani. Tarra uqautiniġai iñuich, “Itchaksrat uvlut ittut savagviksravut. Aggiġaġutitchi taapkunani uvluni iłuaqsirautyaqtuġlusi minġuiqsiaġvium uvluŋiḷaaŋani.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Atanġuruam Jesus kiuniġaa, “Ukpiŋŋuaqtisii! Iluqapsi pituiġayaġaa qunŋiñi unniiñ natmaktini inaaniñ imiġiaqtuqtilluguasii minġuiqsiaġvium uvluani. ");
INSERT INTO eskNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Una aġnaq kiñuviaġigaa Abraham-ŋum naagaunniiñ tuunġaum pituksimaplugu akimiaq piñasuni ukiuni. Pituitḷaiññiqpigu marrumani minġuiqsiaġvium uvluani?” ");
INSERT INTO eskNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Taavruma kiggutaan kanŋutchaktinniġai akiḷḷiqsuqtiŋi, atlat iñuich quviatchakmipkaqługich iluqaagun quviqnaqtautigun savaaŋigun. ");
INSERT INTO eskNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus apiqsruġniqsuq, “Sumik atriqaqpa aŋaayuqautaa Agaayyutim? Sumik atriḷiġñiaqpigu? ");
INSERT INTO eskNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ittuq mustard-ŋum nautchiaksrauraŋatun aŋutim nautchiikkaŋatun nunautmiñi. Nautchiaq naukami napaaqtuqpaġuqtuq aasiiñ tiŋmiurat siḷami ugluliuqhutiŋ akiġuiñun.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus apiqsrutqiŋñiqsuq, “Sumik atriḷiġñiaqpigu aŋaayuqautaa Agaayyutim? ");
INSERT INTO eskNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Itnatun ittuq puvlaksautitun aġnam akarrutiksraŋatun mukkaaksramun, iluqani puvlaŋniałhanunaglaan qaqqiaksram.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus igliġniqsuq nunaaqqisigun suli nunaaqqiuratigun, iḷisautripḷuni iñuŋnik iglaułiġmiñi Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iḷaŋata apiqsruġniġaa, “Ataniiq, ikituurałhiñat anniqsuġniaqpat?” Jesus kiuniġai, ");
INSERT INTO eskNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pisuqtilaapsitñi isiġniaġitchi amitchuakun talukun, atakkii iñugiaktuat iñuich isiġniaġisigaluaqtut aglaan piḷguyumiñaitchut. ");
INSERT INTO eskNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Iñuan tupqum umikkisigaa talu. Qichaġupsi siḷataani katchaktuġisirusi talumi suli nipliġusi, ‘Aŋuun, aŋmautillaktigut!’ Kiugisigaasi, ‘Nalugiga nakitña aggiqsilaaqsi!’ ");
INSERT INTO eskNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tavrali kiugisigiksi, ‘Niġirugut imiqatigiplutinlu iḷisautrikavich nunaaqqiptikni.’ ");
INSERT INTO eskNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aglaan niplitqikkisiruq, ‘Nalugiga nakitña aggiqsilaaqsi. Piiġitchi uvaŋniñ, iluqasi pigiiḷiqirauruasii.’ ");
INSERT INTO eskNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Qanutun qiatigigisirusi tiriquulatchiḷugich kigutisi tautukkupsigik Abraham, Isaac, suli Jacob, suli iluqaisa sivuniksriqirit aŋaayuqautaani Agaayyutim igitaupkaġusi! ");
INSERT INTO eskNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iñuich aggiġisirut kivaknamiñ kanaknamiñḷu suli nigiġmiñḷu uŋallamiñḷu aasiiñ aquvillutiŋ niġiqpagviŋmun aŋaayuqautaani Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Isummatigillaksiuŋ una, iḷasi suvasaġiŋisasi pakma kamanaqsikkaugisirut suli kamanaqhutiŋ isumaruat pakma suvasaunġiġisirut.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iḷaŋisa Pharisee-ŋuruat utlakkaat Jesus nipliutiplugu, “Aullaqtuksraurutin maakŋa, atakkii Herod-ŋum tuqqutchukkaatin.” ");
INSERT INTO eskNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus kiuniġai, “Uqautityaqsiuŋ taamamna Herod kayuqtumik atriqaqtuaq, ‘Anitqataġitka irrusiqł̣uich suli iłuaqsiraġaipḷuŋa atniġñaqtuanik uvlupak uvlaakunlu, suli piñayuakun uvluk naatchigisiruŋa savaamnik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Igliqtuksraupiaqtuŋa tumipkun uvlupak, uvlaakunlu, suli uvlutqikpan, atakkii sivuniksriqiri tuqqutautlaitchuq Jerusalem-ŋum avataani. ");
INSERT INTO eskNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Annaatuk, Jerusalem-miut! Tuqqutaġigitin sivuniksriqirit, uyaġaŋnik miḷḷuuqługiḷḷu uqqiraqtit Agaayyutim tuyuġikkaŋi ilipsitñun! Qapsiñiaglaan katitchukkaluaġaġigipsi atriḷugu aqargiqpak piyaqquqtaiḷitniktuaq paiyaaġmiñik ataani isaqquŋmi, aglaan pitchiġiitchusi! ");
INSERT INTO eskNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Taatnamik tupiqsi suksraakkaullapiaġniaqtuq suuŋiḷḷaġuġlugu. Qiñitqikkumiñaitchipsitŋa nipliġviksrapsitñunaglaan, Uvvatuq Agaayyutim piḷiutiqaġliuŋ taamna tikitchuaq atqagun atanġum.” ");
INSERT INTO eskNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Minġuiqsiaġvium uvluani Jesus niġiyaqtuaġniqsuq kiñunġanun sivulliuqtaata Pharisee-ŋuruat. Iñuich naipiqtulgiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iñuk Jesus-muŋniqsuq puvinniqsuaq iluqaani timimiñi. ");
INSERT INTO eskNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus-ŋum apiqsruġniġai iḷisautrit maliġutaksranik Pharisee-ŋuruatlu, “Maliġutaksrakuaġnaqpa mamititchiruni minġuiqsiaġvium uvluani?” ");
INSERT INTO eskNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aglaan nipliŋiññiqsut. Jesus-ŋum aksikł̣ugu iñuk iłuaqsipkaġniġaa aasiiñ aullaqtitlugu. ");
INSERT INTO eskNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tavra nipliutiniġai, “Iġñiqaġupsi kataguniasiiñ nivviamun minġuisiałhum uvluani nuqinnayaqpisiuŋ tavrakŋa qilamik? Taatnatun piñayaitpisi pamiqsaaqaġupsi? Taatnamik nalaunŋaruq mamititchikama minġuiqsiaġvium uvluani.” ");
INSERT INTO eskNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aglaan kiggutiksraiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus-ŋum iḷitchuġiniġai iḷaŋich aiyugaakkauruat piksrałhat aquppiutaġiŋñiqsranik. Uqautiniġaiḷi atrikusautmik. ");
INSERT INTO eskNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kia aiyugaaqpatin kasuutiruam niġiqpagvianun aquvinniaqnak aquppiutaġiŋñiqsramun. Kiña tavrani kamanatluktuaq ilipniñ aiyugaakkauviaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aiyugaaqtivich aiyugaaqłiqsuam iliptiknik utlakkayaġaatin nipliġuni, ‘Ki, una iñuk aquvilli uvuŋa.’ Kanŋusuliġayaqtutin aquvititpatin atchitḷuktuamun. ");
INSERT INTO eskNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Uvvaasiiñ, aiyugaakkauyuvich aquvillutinaasiiñ atchitḷuktuamun, ilviḷḷi aiyugaaqtivich utlakkayaġaatin nipliutilutin, ‘Iḷauramaaŋ, uvuŋaġiñ aquppiutaġitḷuktuamun.’ Taavrumuuna kamagigisigaatin sivuġaatni iluqatiŋ aiyugaakkauruat. ");
INSERT INTO eskNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Atakkii kisupayaaq iŋmiñik kamanaqsiruaq atchiksikkaugisiruq, suli kisupayaaq atchiksiruaq iŋmiñik kamanaqsikkauluni.” ");
INSERT INTO eskNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tavrakŋa Jesus-ŋum nipliutiniġaa aiyugaaqłiqsuaq, “Qitiquutaqtitchiñiaġuvich unniiñ nullautchiqsitchiñiaġuvich, aiyugaaġniaqnagich iḷauraatin aniaqatiutinlu naagaunniiñ iḷatin umialguruat siḷalliutinlu, atakkii aiyugaaġisipmigaatin. Taavrumuuna akiḷiusiaqaġisirutin. ");
INSERT INTO eskNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Niġiqpaktitchiñiaġuvich aiyugaaġumagisi nagliŋnaqtuat aulatlaitchuatlu suli pisutlaitchuat qiñitlaitchuatlu. ");
INSERT INTO eskNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aasiiñ quviatchaktitauniaqtutin atakkii ilaisa akiḷiutiksraitchaatin. Agaayyutim akiḷiġisigaatin taivrumani uvlumi aŋitqikpata tuqułiġmiñ tamatkua savaaqaqtuat Agaayyutim pisułhanik.” ");
INSERT INTO eskNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iḷaŋat iñuich aquppiqatauruaq niġġiviŋmi tusaakami taavrumiŋa nipliutiniġaa Jesus, “Quvianamiurut tamatkua niġiqatauniaqtuat aŋaayuqautaani Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus-ŋum nipliutiniġaa, “Iḷaatniguuq iñuk aiyugaaqniŋniqsuq iñugiaktuanik iñuŋnik niġiqatiksraġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Niġiñaqsipman tuyuġiniġaa savaktini uqautitquplugich aiyugaakkani, ‘Uvuŋaġitchi, supayaaq pił̣hiñaaġuqtuq!’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aglaan iluqatiŋ patchisiqsuaqsiñiqsut. Sivullium uqautiniġaa, ‘Tauqsiqsuŋa nunamik. Tautugiaġniaġiga. Uvvatuq akuqtuġuŋ pisaŋitchuuġutiga.’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Atla nipliġñiqsuq, ‘Tauqsiqammiqł̣uŋa tallimanik unirrautiqatigiiñik uuktuaġiaġniaġitka. Uvvatuq akuqtuġuŋ pisaŋitchuuġutiga.’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Suli atla nipliġñiqsuq, ‘Iḷaqatnikpaalukłuŋa, taatnaqłuŋa utlautilguitchuŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Savakti utiġniqsuq uqautipluguasiiñ aŋaayuqani. Taavruma qinnakhuni nipliutiniġaa pirini, ‘Qilamiksruġutin tumitchaanugiñ suli akunġatnun tupqich nunaaqqimi qaġġisillugich nagliŋnaqtuatlu aulalguitchuatlu suli qiñitlaitchuatlu pisutlaitchuatlu.’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aquvatigun savakti nipliġñiqsuq, ‘Ataniiq, savaaġigiga savaaġitqukkan aglaan iniksraqaqtuqsuli.’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aŋaayuqam nipliutiniġaa savakti, ‘Aullaġiñ tumitchaanun. Uqautityakkich iñuich nanipayaaq niġiqasiquluŋa. Tupiġa immiġḷi iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Uqautigipsi, taipkua iñuich utlautiŋitchuat aiyugaaqtaugaluaqhutiŋ uuksiyumiñaitchut nullautchiukkamnik!’” ");
INSERT INTO eskNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iñugiaktuat iñuich maliŋniġaat Jesus. Kiŋaiqamigich nipliutiniġai, ");
INSERT INTO eskNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kiña maligukkumi maliġuaqtaulguyumiñaitchuq kisianik piqpagitlugluŋa aapamiñiñ aakamiñiñḷu, nuliaġmiñiñ qitunġamiñiñḷu, suli aniqatiumiñiñ naagaunniiñ iŋmiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kisupayaaq igḷutuiŋitchumi sanniġutaġmiñik maligluŋalu maliġuaqtaulguyumiñaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nalliqsi nappaisukami nasirviŋmik aquvitluni naarrutiksraqaqmagaaġaqtuq savaaksraġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Turviḷianikkaluaqługu maniksraiññiġumi tupqum naarrutiksraŋanik tamatkua qiñiqtuat iglautiginayaġaat ");
INSERT INTO eskNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nipliġutiŋ, ‘Taamna iñuk nappaisaġaluaqhuni naatchiŋitchuq.’ ");
INSERT INTO eskNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aasiisuli ataniq qulit kavluutinik aŋuyyiuqtiqaqtuaq akiḷḷiḷiutisukkumi atlamun umialiŋmun piqaqtuamun iñuiññanik kavluutinik aŋuyyiuqtinik, ilaa aquvitqaaġuni sivunniuġayaqtuq saŋŋigaluaqmagaaġmi igḷuliuġumiuŋ atla umialik. ");
INSERT INTO eskNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Igḷuliutiyumiñaiññiġumi tuyuqaġayaqtuq kiliktimik paaġlugu atla ataniq apiqsruġlugu qiñuirrutitquluni uŋasiŋŋaan.” ");
INSERT INTO eskNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesus nipliġñiqsuq, “Taatnatuntuuq, kiñapayaaq maliġuaqtigiyumiñaitchiga suksraanġisuaqpan iŋmiñik suli suksraaġlugulu iluqaan pigikkani. ");
INSERT INTO eskNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Taġiuq nakuuruq, aglaan taġiuġniraaŋaiġumi, nakitña taġiuġniraalitqikkisiva? ");
INSERT INTO eskNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nakuuŋitchuq nautchiiviksrautmun unniiñ naggutiksriuganun. Iktaksrałhiñauruq. Naalaġniḷḷagitchi, siutiqaqtuasi!” ");
INSERT INTO eskNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iḷaŋatni uvlut iñugiaktuat tax-siliqirit suli killuliqirit utlautiniqsut tusaasukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisee-ŋuruat suli aglaliqirit uqapiḷuaqsiñiqsut, “Uuma iñuum paġlagai killuliqirit niġiqatigiplugiḷḷu!” ");
INSERT INTO eskNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tavrakŋa Jesus-ŋum uqautiniġai atrikusautmik, itna, ");
INSERT INTO eskNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Iḷarisamma tallimakipiamik ipnaiqaġumi tammaiḷugu iḷaŋat, suniaqpa? Uniññiaġai tallimakipiaġuutaiḷat ipnaich iñuiḷaami aasii pakkiaġlugu atausiq tammaqtuaq paqinniałhanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Paqitnamiuŋ quviatchallapiaġniqsuq natmiutiplugu ");
INSERT INTO eskNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aggisiniġaa. Tuqłuqługich iḷauraani siḷalliuniḷu nipliutiniġai, ‘Quviatchaktuŋa paqitnapku tammaqtuaq ipnaiġa. Quviasuqasiqsikŋa!’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Uqautigipsi, taatnatuntuuq quvianatlukkisiruq pakmani atausiq killuliqiri isummitqikpan taapkunakŋa tallimakipiaġuutaiḷaniñ nalaunŋaruaniñ iñuŋniñ isummitqiŋñiaŋiññasugiruaniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aġnaq qulinik qatiqtaanik maniuraqaġumi tammaiḷugu iḷaŋat, suniaqpa? Ikillugu naniq salikuġniaġaa natiq, pakiglugu maniuraq nanipayaaq paqinniałhanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Paqitnamiuŋ tuqłuġai iḷauraani siḷalliuniḷu nipliutiplugich, ‘Quviatchaktuŋa paqitnapku maniuraġa tammaitchaġa. Quviasuqasiqsikŋa!’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Uqautigipsi, taatnatuntuuq isaġulgi Agaayyutim quviasugaqtut atausiq killuliqiri isummitqikman.” ");
INSERT INTO eskNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus uqaaqtupsaaġniqsuq, “Iñugguuġuvva malġuŋnik iġñiqaqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nukaqłium nipliutiniġaa, ‘Aapaaŋ, aatchuŋŋa pakma paisannaktaaksrautimnik.’ Uvvaasiiñ aŋutim aviŋniġai suurani taapkuŋnuŋa iġñaŋmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Uvlut aquuraŋatigun nukaqłium tuniñiġai supayaat pigikkani, aullaqhuni nunamun uŋasiksuamun. Tavraniasiiñ maniiġutiniqsuq iñuuniamaqłukhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Maniiġutipman kakkaaqsiułiq iḷiñiqsuq iñupayaanun taapkunani nunaaqqiñi. Suiḷḷapiaqmiuġlu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kiisaimmalu savaaqsiñiqpuq iḷaŋatnun nunalgich tamarrumani nunami. Taavruma munaqsriḷiutiniġaa qaunagitquplugich kuniani. ");
INSERT INTO eskNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Niġisukpaitḷuni niġisukkaluaġniqsuq kuniat niqiksraŋitñik aglaan iñuich niġipkaġuŋiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tavrakŋa qauġriaqpalaŋniqsuq nipliqhuniasiiñ, ‘Iluqatiŋ aapaa savaktai sippakuuqtuaqhutiŋ niqiksraqaġaqtut. Aglaan kakkaaġataqtuŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Makilluŋa aullaġisiruŋa aapaanun nipliutiluguasiiñ, Aapaaŋ, killuqsaqtuŋa akitñaqługu Agaayyun ilviḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taiguutiqaqtuksraunġiqsuŋa iġñipnik. Iḷaliutiŋŋa akiññaŋniaqtaunun savaktipnun.’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tavra makitluni aapamiñuŋniqsuq. “Uŋasiksitlugusuli aapaŋan tautuŋniġaa aasiiñ iḷunŋutchakhuni. Aqpaqsruġniqsuq iġñiġmiñun iqitluguasiiñ kunikł̣ugulu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iġñiŋan nipliutiniġaa, ‘Aapaaŋ, killuqsaqtuŋa akitñaqługu Agaayyun ilviḷḷu. Taiguutiqaqtuksraunġiqsuŋa iġñipnik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aglaan aapaŋan tuqłuġniġai savaktini, ‘Qilamik, aggiutrisitchi nakuġniqsramik atnuġaatqiutikraŋiñik qitiqłiġutilugulu suli sakpakkiġḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Taatnaanikkupsi aikł̣iġitchi uqsraqsaamik nuġġamik tuqulluguasiiñ, uvagulli quviasuguta niġiqpakkumaugut. ");
INSERT INTO eskNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iġñiġa tuqugaluaqtuaq pakma iñuuruq, tammaġaluaqtuaq pakma paqitauruq.’ Tavraasiiñ niġiqpaaqsiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Taatnaqtitlugich aŋayukłiq nautchiiviŋmiñ aiñiqsuq. Qallikami tupiġmun tusaagaqsiñiqsuq atuqtuuramik aġġiruaniglu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tuqłuqługu iḷaŋat savaktit apiqsruġniġaa, ‘Suvat ipkua?’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Savaktim kiuniġaa, ‘Nukatchian aiñiqsuq suli aapavich tuqqutchisipḷugu uqsraqsaamik nuġġamik. Niġġisigaa utitqigḷuqman nakuupluni.’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aapiyaŋa qinnakpaitḷuni isiġuŋiññiqsuq tupiġmun niġiqpaktuanun. Aapaŋan anipḷuni iŋiqsruaġniġaa isiquplugu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Aglaan uqautiniġaa aapani, ‘Ataŋii, iluqaitñi ukiuni savautigikpiñ kamagiplugulu tilliñ. Aglaan nagruligauramikunniiñ aatchunġaŋitchikma niġiqpautiksramnik iḷauraatkalu. ");
INSERT INTO eskNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aglaan taamna iġñiġiñ maniiġutiniqsuq akiisutigunlu. Aasiiñ aipman tuqqutchirutin uqsraqsaamik nuġġamik pisigiplugu.’ ");
INSERT INTO eskNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aapaŋan kiuniġaa, ‘Iġñiiŋ, ittutin ataramik uvaŋni. Suuratka iluqaisa pigigitin. ");
INSERT INTO eskNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aglaan niġiqpaktuksraurugut quviasullapiaġuta, atakkii nukatchian tuquruaq pakma iñuuruq, tammaqtuaq pakma paqitauruq.’” ");
INSERT INTO eskNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus-ŋum uqaaqtuutiniġai maliġuaqtini, “Taimmaguuq umialik savaktiqaġniqsuaq aŋalatchiruamik suuraġmiñik. Iñuich umialik uqautiniġaat aŋalatchiruamun maniiġutchaġnipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Umialgum tuqłuqamiuŋ uqautiniġaa, ‘Sua uvvauna tusaakkaġa ilipkun? Uqautiŋŋa qanuq aŋalatchisilaaqnik suuramnik. Aŋalatchitqikkumiñaitchutin suuramnik atakkii maniiġutchaġniġikma.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Savakti isummiġñiqsuq, ‘Aŋaayuqaġma piiġataġaaŋa savaamniñ. Qanuġisivik? Paulġiralguitmiuŋa nunamik suli kanŋugipmigiga iŋiulałiksraġa. ");
INSERT INTO eskNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Uvvaliqaa itnaġisiruŋa! Savaŋaiġuma iḷauraaqaġumuuŋa tukkiqsiksramnik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aŋalatauruam tuqłuġniġai iluqaisa iñuich akiqsruutiqaqtuat aŋaayuqaġmiñun. Apiqsruġniġaa sivulliq, ‘Qanutun akiqsruumaviuŋ aŋaayuqaġa?’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Taavruma kiuniġaa, ‘Tallimakipiatun iñugiaktilaaliŋnik qattaġruŋnik uqsrunik.’ Suuranik aŋalatauruam uqautiniġaa, ‘Uvva akiqsruutitin. Aquvillutin aglaguŋ tavruŋa malġukipiaq qulit.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Apiqsrulgiññiġaa atla, ‘Ilvichaasiiñ, qanutun akisruutiqaqpich?’ Taavruma kiuniġaa, ‘Tallimakipiatun iñugiaktilaaliŋnik miissuŋnik mukkaaksranik.’ Suuranik aŋalatauruam uqautiniġaa, ‘Uvva akiqsruutitin. Aglaguŋ sisamakipiaq.’” ");
INSERT INTO eskNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Atanġum Jesus-ŋum uqaġiniġaa nalaunŋaitchuaq aŋalatchiruaq suuranik piḷḷautaġnipḷugu pisaasułhagun. Atakkii iñui nunam pisaasutluktut piqatiqaqamiŋ iñuuqatiumiknik tamatkunakŋa ukpiqsriruaniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Uqautigipsi, Iḷauraalliuġusi atuġusi manigikkapsitñik ikayuutiksraŋatnik tamatkua inuqsralliuqtuat. Iḷaatnigun tuquniġuvich aasiiñ manik nuŋutpan iniqaġisirusi pakmani. ");
INSERT INTO eskNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kisupayaaq tuniqsimaruaq mikiruatigun tuniqsimagisipmiuq aŋiruatigun. Kisupayaaq tuniqsimaitchumi mikiruatigun tuniqsimaitkisipmiuq aŋiruatigun. ");
INSERT INTO eskNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Uvvaasiiñ tuniqsimaitchuvich aŋalatchił̣iqni nunam suuraiñik, qanuġuni Agaayyutim tunŋavigitlagisiñiqpatin aŋalatchił̣iqni iḷumutun umialgutauruanik? ");
INSERT INTO eskNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tuniqsimaitchuvich atlam suuraŋigun, qanuġuni Agaayyutim aatchutlagisivatin piksraqnik. ");
INSERT INTO eskNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kiñaunniiñ savautriḷguitchuq malġuŋnik aŋaayuqaŋnik. Atakkii uumigigisigaa atausiq aasiiñ piqpagilugu iḷaqataa; kamagigisigaa atausiq aasiiñ naġġugilugu iḷaqataa. Savautriḷguyumiñaitchusi iluqaaknik Agaayyutmiglu maniŋmiglu.” ");
INSERT INTO eskNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee-ŋuruat tusaakamitruŋ iluqaan tamanna, mitautiginiġaat Jesus atakkii piqpaksripḷutiŋ maniŋmik. ");
INSERT INTO eskNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus-ŋum nipliutiniġai, “Nalaunŋanisuurusi takkuatni iñuich, aglaan Agaayyutim iḷisimapiaġai uummatisi. Atakkii sut kamanaqsipkakkauruat akunġatni iñuich Agaayyutim naġġugipiaġai. ");
INSERT INTO eskNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Aggił̣hanunaglaan John Paptaaqtitchirim maliġutaksraŋalu Moses-ŋum aglaŋisalu sivuniksriqirit aŋalatkaich iñuuniałivut. Aasiiñ tavrakŋaniñaglaan tusaayugaallautaŋa aŋaayuqautaan Agaayyutim quliaqtuaŋuniqsuq, suli piyumalaaqtuat sakuuktut Agaayyutmun atanniqsimatquplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mikiniqsrallapiaqunniiñ titiġnauraŋa aglaum maliġutaksrani simmiġumiñaitchuq kisianik qiḷaglu nunalu piiqpaknik. ");
INSERT INTO eskNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kia aŋutim avitchumiuŋ nuliani aasiiñ kasuutiluni atlamun aġnamun atlatuġaqtuq; taatnatuntuuq aŋun kasuutiyumi avisimaruamun aġnamun atlatuqmiuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus uqaaqtulgitchuq, “Iḷaatniguuq umialiqaġniqsuq atnuġaaqaġuuruamik akisuruanik suli iñuuniaqhuni ayuqsraŋitḷuni uvluġaġipman. ");
INSERT INTO eskNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Uvvaguuġuna iŋiularikniaq atilik Lazarus-mik kiḷḷiġruaqaqtuaq. Iñuich inillaŋniġaat paaŋanun umialgum tupqan, ");
INSERT INTO eskNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","niġiḷḷakkasugaluni kanġanauranik kataktuanik umialgum niġġivianiñ. Qipmich utlakługu aluktuġaqniġaich kiḷḷii. ");
INSERT INTO eskNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Iŋiularikniaq tuqupman isaġulgich akiyautiniġaat saniġaanun Abraham-ŋum. Umialik tuqupmiñiqsuq iḷuvikkaupluniasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aasiiñ anasiñŋuqsaġviŋmi nagliksaallapiaġataqtuq. Aaġluqhuni tautuŋniġaa Abraham uŋavanun Lazarus-lu saniġaniittuaq. ");
INSERT INTO eskNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Umialik tuqłuġniqsuġli, ‘Abraham Aapaaŋ. Nagligillaŋniaŋŋa! Tuyuġiuŋ Lazarus kiñiḷḷaglugu tikini imiġmun niglaqtiġiaġliuŋ uqaġa, atakkii nagliksaallapiaqtuŋa ikniġmi!’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aglaan Abraham nipliġñiqsuq, ‘Iġñiiŋ, itqallauŋ una! Iñuułiqni piqaqtutin iluqaanik nakuuruamik, aasiiñ Lazarus piqaqhuni iluqaanik pigiitchuamik. Aglaan pakma arauttutiqaqtuq uvani nagliksaaqtitlutin. ");
INSERT INTO eskNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naagaunniiñ itiruamik ikaaġnaġumiñaitchuamik piqaqtuq akunnaptikni. Kiñaasiiñ ikaatlaitchuq uvakŋa ilipnun, naagaqaa kiña ikaatlaitchuq uvaptiknun ilipniñ.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Umialik nipliġñiqsuq, ‘Abraham, aapaaŋ! Iŋiġikpiñ, tuyuġilugu Lazarus aapaa tupqanun. ");
INSERT INTO eskNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tavrani tallimanik aniqatiqaqtuŋa. Kiliktuġiaġligich tatamnaqtuamik, tarrali uvuŋaŋitchumagaat inaanun nagliksaaġvium.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham nipliġñiqsuq, ‘Aniqatiutin piqaqtut aglaaŋitñik Moses-ŋum suli sivuniksriqirit uqautriqaqhutiŋ tatamnaqtuamik. Aniqatiuvich naalaġniraksraġigaich taipkua uqaqpata.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Umialgum kiuniġaa, ‘Abraham, aapaaŋ! Taamna apaiŋuŋitchuq. Aglaan kiña utiqhuni tuquruamiñ utlautikpan, isummitqikkayaqtut killuqsautmikniñ.’ ");
INSERT INTO eskNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aglaan Abraham nipliġñiqsuq, ‘Naalaġniŋitchumisigich aglaaŋi Moses-ŋumlu sivuniksriqiritlu tusaayumiñaitmiut kia-unniiñ utiġuni tuquruamiñ uqautikpatiŋ.’” ");
INSERT INTO eskNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus-ŋum nipliutiniġai maliġuaqtini, “Nalupqinaitchuq. Killuqsaqusaaġutit atuumaniaqtut ataramik. Aglaan qanutun tatamnaqtigiva taamna iñuk ukpiġutaiqsitchiruaq iñuŋnik killuqsaqusaaġiłiġmigun. ");
INSERT INTO eskNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nakuutlukkayaqtuq taatnasiq iñuk igitaukpan taġiumun uyaġaŋmik quŋisiġmiutchiġḷugu, taamna iḷiḷgaamik killuqsaqusaaġitñiktuaq. ");
INSERT INTO eskNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Taatnamik munaġititchi! Aniqatiksi killuqsaqpan suakataġumagiñ, aasiiñ isummitqikpan natqiutiyumagiñ. ");
INSERT INTO eskNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Killuqsaġniqpan akitñaġutin tallimat malġuŋniaglaan atautchimi uvlumi nipliġuni, ‘Nunuuraqłuŋa isummitqiksuŋa,’ natqiutiraksraġigiñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Uqqiraqtit nipliutiniġaat Ataniq Jesus, “Ukpiqsrił̣iqput iḷalaaġuŋ.” ");
INSERT INTO eskNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Atanġuruam kiuniġai, “Ukpiqsrił̣iqaġniġupsi aktilaaliŋmik mikiniqsraŋatitun nautchiaksrat, nipliutiłhiñaugiñ una napaaqtuq, Amulutin ilipnik kaŋituummaqpich aasiiñ nautchirriutilutin ilipnik taġiumun. Ukpiqsrił̣iqaġniġupsi tupiginayaġaatin. ");
INSERT INTO eskNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nalliqsi savaktiqaqtuaq nunniuqhuni naagaqaa munaqsriḷuni ipnaiñik aipman, uqautinayaqpiuŋ, ‘Aquvillaglutin niġġiiñ’? ");
INSERT INTO eskNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Naagga! Uqautisuugiñ, ‘Itqanaiyaġiñ niqiksramnik. Saalisaġutin niġipkaŋŋa imiqtilluŋalu. Niġianikkuma niġiyumautintuuq.’ ");
INSERT INTO eskNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Savaktin quyaraksraġiŋitchiñ tupigipmatin! ");
INSERT INTO eskNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Taatnatuntuuq ilipsi, savaaqaġupsi uqauttusiapsitñik nipliġniaqtusi, ‘Uvagut nalliummatiŋitchuat savaktit savałhiñaqtugut savaaksriusiaptiknik.’” ");
INSERT INTO eskNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus utlautiniqsuq Jerusalem-mun akunġakkun Samaria-m Galilee-mlu. ");
INSERT INTO eskNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nunaaqqiuramukami paaqsiruq qulinik iñuŋnik auyugaqtualiŋnik. Qichaqtut uŋasiksipḷutiŋ ");
INSERT INTO eskNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aasiiñ kappaiŋaplutiŋ, “Jesus! Ataniiq! Nagligillaŋniaqtigut!” ");
INSERT INTO eskNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus-ŋum tautukamigich nipliutiniġai, “Agaayuliqsinugitchi isivġiuqulusi.” Utlautillaġmiŋ iłuaqsiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iḷaŋat iḷitchuġikami mamitilaaġmiñik utiġniqsuq, kamaksruqługu Agaayyun nipitusipḷuni, ");
INSERT INTO eskNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","putluni Jesus-ŋum isigaiñun aasiiñ quyaniġaa. Taamna iñuk Samaria-ġmiuŋuniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus nipliġñiqsuq, “Qulit iñuich mamitchugaut. Naamiimma quliŋŋuġutaiḷat? ");
INSERT INTO eskNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Suvaata una sumiuŋuruaq kisimi utiqpa quyasukługu Agaayyun?” ");
INSERT INTO eskNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesus-ŋum nipliutiniġaa, “Makillutin. Ukpiqsrił̣iqpich iłuaqsigaatin.” ");
INSERT INTO eskNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Iḷaŋich Pharisee-ŋuruat apiqsruġniqsut Jesus qakugun aŋaayuqautaa Agaayyutim aggiġisipmagaan. Jesus-ŋum kiuniġai, “Aŋaayuqautaa Agaayyutim aggiġumiñaitchuq tautuŋnaġuni. ");
INSERT INTO eskNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kiñaunniiñ nipliġumiñaitchuq, ‘Ataŋii, uvva uvaniittuq!’ naagaqaa ‘Iñña iñaniittuq!’ Atakkii Agaayyutim aŋaayuqautaa uvaniittuq akunnapsitñi.” ");
INSERT INTO eskNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tavra nipliġñiqsuq maliġuaqtimiñun, “Iḷaatnigu qiñiġuliġisirusi iḷaŋatnik uvluġikkaiñ Iġñiŋan Iñuum. Aglaan tautukkumiñaitchiksi. ");
INSERT INTO eskNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iḷaŋich iñuich uqaġisirut ilipsitñun, ‘Qiñiqsiuŋ, iñña’ naagaqaa ‘Ataŋii, uvaniittuq!’ Aglaan tautugiaġniaqnagich! ");
INSERT INTO eskNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Atriqaġuni ikniqpalaŋmik qaummaġiksipmatun qiḷak kivaknamiñ kanaknamun, taatnatuntuuq sagviġisiruq Iġñiŋa Iñuum uvluġikkaġmiñi. ");
INSERT INTO eskNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aglaan sivulliulugu nagliksaaqtuksrauruq ayakkauluni iñuŋniñ marrumani uvlumi. ");
INSERT INTO eskNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Uvluġikkaŋisun Noah-m itkisiruq Iġñiŋan Iñuum utiłha. ");
INSERT INTO eskNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iñuich niġipḷutiŋ imiqhutiŋlu suli aŋutit aġnat katchuutiplutiŋ uvlumunaglaan Noah-m isiłhanun umiamun, aglaan uliqłuum tuqqutkai iluqaisa. ");
INSERT INTO eskNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Itkisipmiuq uvluŋisun Lot-ŋum, iñuich niġipḷutiŋ suli imiqhutiŋ, tauqsiqsuqhutiŋ suli tunisiullaqhutiŋ, nautchiipḷutiŋ suli nappaipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Taivrumani uvlumi Lot-ŋum unikmagu Sodom, ikniq suli aġralitlaiḷaat kataŋniqsut qiḷaŋmiñ aasiiñ tuqqutlugich iluqaisa. ");
INSERT INTO eskNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Taatnatun itkisiruq Iġñiŋa Iñuum sagviqpan. ");
INSERT INTO eskNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Taivrumani uvlumi iñuk itchumi qaaŋani tupqum atqaġniaqani isiġuguni tupiġmiñun aikł̣iġuni sulliñauraġmiñik. Taatnatunsuli iñuk nautchiiviŋmi itchumi aiñiaqani tupiġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Itqallaksiuŋ qanuq pił̣ha Lot-ŋum nuliaŋa! ");
INSERT INTO eskNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kia anniġiniaġumiuŋ iñuułłi tammaigisigaa, aglaan kisupayaam tammaiyumiuŋ iñuułłi piqutigipluŋa piññakkisiruq iḷumun iñuułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Uqautigipsi, tamarrumani unnuami malġuk iññuk siñiktuak siñigviŋñi; atausiq aullautlikkaugisiruq, aasii iḷaqataa unisikkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Malġuk aġnak siqupsiruak mukkaaksramik, atausiq aullautlikkaugisiruq, aasii iḷaqataa unisikkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Malġuk aŋutik nautchiiviŋmiittuak; atausiq aullautlikkaugisiruq, aasiiñ iḷaqataa unisikkaugisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Maliġuaqtaiñ apiqsruġniġaat, “Naniitkisiva, Ataniiq?” Jesus-ŋum kiuniġai, “Sumipayaaq tuquŋaruaq itpan tiŋmiaqpaich tuquŋaruaqtuġuuruat katisuurut.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus-ŋum maliġuaqtini uqautiniġai atrikusautmik. Iḷisautiniġai ataramik agaayutquplugich nikaliġasuŋaqnagich. ");
INSERT INTO eskNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Nunaaqqiq atanniqsuqtiqaġniqsuq taluqsriŋitchuamik Agaayyutmik naagaqaa suvasaġiŋitḷugich iñuich isummataat. ");
INSERT INTO eskNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Taavrumaniguuq nunaaqqimi uiḷgaġnaaqaqmiñiqsuq utlautraqtuamik taavrumuŋa isivġiqsimun ikayuqupluni akitñaġlugu igḷuliuqtini. ");
INSERT INTO eskNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Akuniguuq isivġiksaum suqutigiŋiññiġaa. Kiisaimmatai nipliġñiqpuq iŋmiñun, ‘Taluqsriŋitchaluaŋŋaġma Agaayyutmik suli suvasaġiŋiḷḷugich iñuich isummataat, ");
INSERT INTO eskNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","naagasuli taamna uiḷgaġnaaq minġitñiłhagun uvamnik ikayuġisigiga akuqtutlasiḷugu pigikkaŋanik nalaullugu. Taatnaŋitchuma utlakpaitḷuŋa minġisaġataġisigaaŋa.’” ");
INSERT INTO eskNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesus-ŋum iḷapsaaġniġaa, “Isummatigisiuŋ qanuq pigiitchuam atanniqsuqtim nipliutaa. ");
INSERT INTO eskNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Agaayyutim ikayuġumiñaiññiqpagich piksraqtaaġikkani iŋiqsruqtuat iŋmiñun unnuaqtuummaan? Pisaġumagisiva ikayułiksraŋatigun? ");
INSERT INTO eskNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naalaġnisitchi. Agaayyutim ikayuġisigai nalaullugu iñuŋni, suli pisaġumautisuŋaqnagich. Aglaan Iġñiŋa Iñuum utiġumi paqitkisiva taatnatchimik ukpiqsrił̣iġmik nunami?” ");
INSERT INTO eskNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus-ŋum uqautiniġai iñuich atrikusautmik tunŋaruatigun nalaunŋałiġmiknun aasii naġġugiplugich atlat. ");
INSERT INTO eskNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Iḷaatni malġuk iññuk agaayyuvikpaŋmun agaayutyaġniqsuk, iḷaqataa Pharisee-ŋuruaq atlaasiiñ tax-siliqiri. ");
INSERT INTO eskNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee-ŋuruaq qichaqhuni ilaagun agaayuniqsuq, ‘Agaayyuun, quyagikpiñ siqñatuaŋiḷuqtuŋa, qanutitaŋitḷuŋalu naagaqaa atlatuqłuŋa atlatitun. Quyagikpiñ atrigiŋiḷuġiga iñña tax-siliqiri. ");
INSERT INTO eskNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Uisauraaqłuŋa malġuŋni uvluŋni akunniqsaami suli qaitchaġigiga qulikuat akiññaktaaġma.’ ");
INSERT INTO eskNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aglaan tax-siliqiri qichaġniqsuq uŋavanun aasii aaġluqsuŋaqaniunniiñ pattakługu satqani nipliqhuni, ‘Agaayyuun, nagligillaŋniaŋŋa, killuliqirauruŋakii!’” ");
INSERT INTO eskNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesus nipliġñiqsuq, “Uqautigipsi, tax-siliqiri aiñiqsuq nalaunŋasiḷuni Agaayyutmi, aglaan Pharisee-ŋuruaq nalaunŋaŋitchuq. Atakkii kisupayaaq kamanaqsipkaqtuaq iŋmiñik atchiksigisiruq, suli kisupayaaq atchiksiruaq iŋmiñik kamanaqsipkakkauniaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iḷaŋich iñuich tikiutriñiqsut aniqammiuranik Jesus-mun aksiquplugich. Maliġuaqtit tautukamisigich suakataġaich. ");
INSERT INTO eskNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aglaan Jesus-ŋum iḷiḷgaat iŋmiñuquniġai nipliqhuni, “Ki, iḷiḷgaat uvamnuktitchigik. Avriaqutaunasi iliŋitñun atakkii aŋaayuqautaa Agaayyutim aŋmaruq iñuŋnun atriqaqtuanun iḷiḷgaanik. ");
INSERT INTO eskNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Itqaqsiuŋ una! Kisupayaaq akuqtuiŋitchuaq aŋaayuqautaanik Agaayyutim atriḷiḷugich iḷiḷgaat isiġumiñaitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jew-ŋuruat sivulliuqtaata apiqsruġniġaa Jesus, “Nakuuruaq iḷisautrii, sumik savaktuksrauvik akuqtuitḷasiḷuŋa isuitchuamik iñuułiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus-ŋum apiqsruġniġaa, “Suvaata taiviŋa nakuuruamik? Nakuuruamik piitchuq avataagun Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iḷisimagitin tillisit, ‘Atlatuġniaqnak, iñuaġniaqnak, tigliŋniaqnak, naagaqaa sagluuqtuaġniaqnak atlatigun, suli kamagilugik aapan aakanlu.’” ");
INSERT INTO eskNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iñuum kiuniġaa, “Nutaułłamniñaglaan tupigigitka iluqaisa tillisit.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus-ŋum tusaakamiuŋ taamna nipliutiniġaa, “Atautchimiksuli savaktuksraurutin. Tuniḷugich iluqaisa pigikkatin qaiḷḷugiḷḷu maniich inuqsraqtuanun, ilviḷḷi umialgutiqaġumautin pakmani. Taatnaanikkuvich uvuŋaġutin maliŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aglaan taavruma iñuum tusaakamiuŋ taamna, aliatchaŋniqsuq atakkii umialgupluni. ");
INSERT INTO eskNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus tautukamiuŋ aliatchakługu nipliġñiqsuq, “Qanutun sakiqnaqtigiva umialguruat iñuich isiłiksraŋat aŋaayuqautaanun Agaayyutim! ");
INSERT INTO eskNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sakiqnatluktuq umialguruam iñuum isiłiksraŋa aŋayuqautaanun Agaayyutim uumakŋa pikukturuam isiłiksraŋaniñ ‘Mitqutim Iraagun’.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iñuich tusaakamitruŋ apiqsruġniġaat, “Kiñami anniqsukkaugisiva?” ");
INSERT INTO eskNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus-ŋum kiuniġai, “Sua iñuich savaaġiyumiñaisaŋat Agaayyutim savaaġitlapiaġataġaa.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter nipliġñiqsuq, “Ataŋii! Unitchivut kiñunnavut malikhutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesus nipliutiniġai, “Aa, kiñaunniiñ unitchigumi kiŋuniġmiñik, nuliaġmiñik, aniqatiumiñik aŋayuqaaġmiñiglu naagaqaa qitunġaġmiñik piqutigilugu aŋaayuqautaa Agaayyutim akuqtuitḷukkisiruq pitḷuktuamik marrumani iñuułiġmi suli iñuuluni Agaayyutmi qaŋapak taimuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus-ŋum qulit malġuich maliġuaqtini kisiŋŋuutiplugich uqautiniġai, “Naalaġniḷḷagitchi! Jerusalem-muŋniaqtugut. Tavraniasiiñ sivuniksriqirit aglaaŋich Iñuum Iġñiŋagun atuumaniaqtut. ");
INSERT INTO eskNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iñuich qaitchigisirut ilaanik Jew-ŋuŋitchuanun. Mitautigigisigaat kanŋunakun suli tivvuaqtuġlugu. ");
INSERT INTO eskNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ipiġaqtuġlugu tuqqutkisigaat. Aglaan piñayuatni uvlut aŋitqikkisiḷgitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aglaan maliġuaqtit kaŋiqsiŋiññiġaat uqaġikkaŋa. Qanuutautilaaŋa uqałhan iriqsimaniqsuq iliŋitñiñ. Nalugaat sumik Jesus uqaqtilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus qallipman Jericho-mun qiñitlaiḷaq iŋiulari aquppiñiqsuq saniġaatni tumitchaat. ");
INSERT INTO eskNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tusaakamigich iñugiaktuat iñuich apqusaaqtuat apiqsruġniqsuq, “Suvat ukua?” ");
INSERT INTO eskNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Uqautiniġaat, “Jesus Nazareth-miu apqusaaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Taamna kappaiŋaaqsiñiqsuq, “Jesus! Kiŋuviaŋa David-ŋum! Anniqsuqtaurutin Agaayyutim akiqsruutigikkaŋa iŋiḷġaanimma. Nagligillaŋniaŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iñuich sivulliuruat suakataġniġaat uqautiplugu, “Nipaisaaġiñ.” Aglaan nipitusiḷaaġniqsuq, “Kiŋuviaŋa David-ŋum, nagligillaŋniaŋŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus-ŋum nutqaqami iŋmiñuutitquniġaa qiñitlaiḷaq iñuk. Qallipman Jesus-ŋum apiqsruġniġaa, ");
INSERT INTO eskNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Sumik uvaŋnun savautitquvich?” Kiuniġaa, “Ataniiq, qiñitlasitqiguktuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus nipliutiniġaa, “Qiñitlasiiñ! Ukpiqsrił̣iqpich iłuaqsigaatin.” ");
INSERT INTO eskNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tavrakŋatchiaq qiñitlasiruq maliaqsipḷuguasiiñ Jesus kamaksruqługu Agaayyun. Iñugaaġruich tautukamitruŋ, iluqatiŋ nanġaġniġaat Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus isiqtuq Jericho-mun apqusaałhiñaġukługu. ");
INSERT INTO eskNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Itmiñiqsuq qaukłiat tax-siliqirit atilik Zacchaeus-mik, aasiiñ umialgupluni. ");
INSERT INTO eskNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Qiñiġuŋniġaa kisuutilaaŋa Jesus. Aglaan iñuŋuluuraupluni qiñilguiññiġaa atakkii iñugiakpaitḷutiŋ iñuich. ");
INSERT INTO eskNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Taatnaqhuni aqpaqsruġniqsuq sivuatnun iñugaaġruich mayuqhuniasiiñ napaaqtumun qiñiġukługu Jesus apqusaaġniaqtuaq taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus taruŋaqami aaġluġniqsuq nipliutiplugu Zacchaeus, “Qilamik atqaġiñ, atakkii tukkuniaqtuŋa tupiqnun uvlupak.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus qilamik atqaġniqsuq. Paġlaniġaa Jesus quviasullapiaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iluqatiŋ iñuich qiñiqtuat uqapiḷuaqsiñiqsut, “Una aŋun Jesus tukkuruq tupqanun iñuum killuliqirauruam!” ");
INSERT INTO eskNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kiŋuniġmiñi Zacchaeus makitluni nipliutiniġaa Atanġuruaq, “Naalaġniḷḷagiñ! Qaitkisigiga avvaŋa suuraġikaġma inuqsraqtuanun. Aqsakniksimaniġuma kisupayaamik utiqtitchigisigitka sisamaullugu.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus-ŋum Zacchaeus nipliutiniġaa, “Uvluvak una iñuk tupiqatniḷu anniqsukkauniqsut, atakkii ilaaptuuq kiŋuviaġipmigaa Abraham-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iġñiŋa Iñuum aggiqsuq ivaqłiġiaqhuni suli anniqsuityaqhuni tammaummiruanik iñuŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iñuich naalaġnipkaqługich taavrumiŋa Jesus uqautipsaaġniġai atrikusautmik. Tikiyasipḷuni Jerusalem-mun iñuich isummatiginiġaat aŋaayuqautaa Agaayyutim sagviaqsiñipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Uvvaasiiñ nipliġñiqsuq, “Iḷaatniguuq umialiqaġniqsuq aullaġniaqtuamik nunamun uŋasiksuamun umialiguqtitqupluni, aasii utiġuni. ");
INSERT INTO eskNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aullaġaluaqani qulit savaktini aatchuġniġai ilaagullaa kaviqsaamik maniŋmik uqautiplugich, ‘Aglipkaġniuraġumagiksi utiġniałłamnunaglaan.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aglaan nunaqataiñ uumiginiġaat. Tuyuqaġniqsut uqqiraqtinik maliquplugu nipliqhutiŋ, ‘Taamna iñuk umialigisuŋitchikput.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Taamna iñuk umialiguqami utiġniqsuq. Iŋmiñuquniġai savaktit tavrauvaa iḷitchuġisukługu qanutun piññaktilaaŋat. ");
INSERT INTO eskNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sivulliq tikitñami nipliġñiqsuq, ‘Ataniiq, manik qaisan atuqługu quliniksuli piññaktuŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Aarigaa! Savallautaġniqsutin. Tuniqsimarutin mikiruatigun. Aŋalatiġuġisigikpiñ qulinun nunaaqqiñun.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tuglianli pirim tikitñami nipliutiniġaa, ‘Ataniiq, manik qaisan atuqługu tallimaniksuli piññaktuŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Taavrumuŋa taamna nipliġñiqsuq, ‘Aŋalatiġuġisirutin tallimani nunaaqqiñi.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Piŋayuatsuli piri tikiññiqsuq nipliqhuni, ‘Ataniiq, uvva kaviqsaaq maniiñ tugvakkaġa iriqługu kakkiiḷisamun. ");
INSERT INTO eskNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iqsigiplutin atakkii nagliktaitchutin. Piksraġaqtutin pigiŋisaqnik suli katitchiraqtutin nautchiiŋisaqnik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Atanġum nipliutiniġaa, ‘Suksrauŋił̣allaktutin! Nipliutipkun atanniġisigikpiñ! Naluŋitchiñ nagliktaił̣iġa, piksratlałiġa pigiŋisamnik suli katitchitḷałiġa nautchiiŋisamnik. ");
INSERT INTO eskNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Suvaatami iḷiŋitpiuŋ maniga manikuviŋmun? Akuqtuġayaġiga iḷḷataa manium utiġuma.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nipliutiniġai qichaqtuat tamaani, ‘Piḷugu kaviqsaaq manik ilaaniñ qaitchiuŋ pirimun piqaqtuamun qulinik maniŋñik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aglaan nipliutiniġaat, ‘Ataniiq, piqaaniktuq qulinik maniŋñik!’ ");
INSERT INTO eskNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ilaan nipliutipsaaġniġai, ‘Iñupayaaq piqaqtuaq aatchuusiaġmiñik piññapsaaġisiruq sippakuuqtauliġuni, aglaan iñuk piqaŋitchuaq, mikiruaqunniiñ piginasugikkaŋa piikkaugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pakma taipkua igḷuliuqtitka ataniqaġuŋitchuat uvaŋnik, uvuŋautisigich tuqullugich aasii sivuqqamni!’” ");
INSERT INTO eskNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus uqautiqqaaqługich taavrumiŋa igliqtuiñaġniqsuq Jerusalem-ŋum tuŋaanun. ");
INSERT INTO eskNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Qallikami Bethphage-mun suli Bethany-mun iġġiani atiqaqtuam Olives-mik, tuyuġiniġik malġuk maliġuaqtik sivumiñi, ");
INSERT INTO eskNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","itnaqługik, “Aullaġitchik nunaaqqiuramun taichuŋa. Tikitchaġluqaaqtutik paqitkisigiktik nuġġaŋa natmaksiġvium pituksimaruaq natmaksiġviunġaŋiḷaaq. Pituiġḷugu uvuŋautiyumagiktik. ");
INSERT INTO eskNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kia apiqsruqpatik, ‘Suvaata pituiqpitku,’ uqautiyumagiktik, ‘Atanġuruam inuġigaa.’” ");
INSERT INTO eskNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tikitñamik tamauŋa paqinniġaak iluqaan Jesus-ŋum uqałhatun. ");
INSERT INTO eskNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Uvvaasiiñ pituiġñiaqtitlugu nuġġaŋa natmaksiġvium iñuan nipliutigik, “Suvaata pituiqpitku?” ");
INSERT INTO eskNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kiuniġaak, “Atanġuruam inuġigaa.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aasiiñ Jesus-muutiniġaat. Taatnaqqaaqługu quppiġaatiŋ iḷiñiġaik qaaŋanun natmaksiaġvium, Jesus aquvitluniasii. ");
INSERT INTO eskNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Natmaksiaqtitlugu iñuich quppiġaatiŋ tutmaġvigiliutiniġaich tumitchaanun. ");
INSERT INTO eskNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tikiññiqsut inimun tavrakŋa Jerusalem qiñiġnaqsipḷugu. Tavra iñugiaktuat maliġuaqtit Agaayyun quviatchautigiaqsiñiġaat suli nanġaqługu nipitusipḷutiŋ iluqaisigun quviqnaqtuatigun qiñikkaġmiktigun, ");
INSERT INTO eskNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Uvvatuq Agaayyutim piḷiutiqaġliuŋ umialik tikitchuaq piqusiqhuni Ataniġmik! Illi tutqiun qiḷaŋmi suli kamanaun qutchiŋñiqsrami qiḷaŋmi.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aasiiñ iḷaŋisa Pharisee-ŋuruat akunġatniñ iñugaaġruich uqautiniġaat Jesus, “Iḷisautrii, tilikkich maliġuaqtitin iñuksruisaaqulugich!” ");
INSERT INTO eskNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus kiuniġai, “Uqautigipsi, maliġuaqtitka nipaisaaġniqpata uyaġaitḷi niplianayaqtut nipitusiḷutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Natmaksiḷḷaġmi nunaaqqiq tautukamiuŋ qiagaqsiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Aasiiñ nipliġñiqsuq, “Uvvatuq iḷisimatitchi uvlupak suruksrautilaapsitñik tutqiutiqaġukkupsi. Aglaan kaŋiqsitḷaitchusi! ");
INSERT INTO eskNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Uvlut tikitkisirut akiḷḷiḷiqsuqtipsi puuġisigaasi, saulugu avatiksi aniyumiñaiyaġusi quġġutilusiḷu sumiḷḷiqaa. ");
INSERT INTO eskNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Suksraunġiḷḷapiaġisigaasi iñugikkasiḷu. Atausiqunniiñ uyaġak minitchumiñaitkaat. Atuumaniaqtuq atakkii ilipsi iḷisaġiŋitḷugu Agaayyun aggiqman anniqsuġiaqhusi.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus isiġniqsuq agaayyuvikpaŋmun aasiiñ anitlugich tunisiullaqtuatlu tauqsiqsuqtuatlu, ");
INSERT INTO eskNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nipliutiplugich, “Aglausimaruq uqałhani Agaayyutim itnaqhuni, ‘Tupiġa agaayyuviksrauruq.’ Aglaan iriqtuġvigiliutipkaġiksi tigliŋniaqtinun.” ");
INSERT INTO eskNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Uvluġaġipman Jesus iḷisautriñiqsuq agaayyuvikpaŋmi. Qaukłiŋich agaayuliqsit suli aglaliqirit suli sivulliuqtiġruat tuqqutchuŋniġaat, ");
INSERT INTO eskNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","aglaan qanuqsausiiññiġaat, atakkii iluqatiŋ iñuich naalaġnituiñaġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Uvlut iḷaŋatni Jesus agaayyuvikpaŋmi inniqsuq iḷisautripḷuni iñuŋnik quliaqtuaġiplugu tusaayugaallautaq. Qaukłiŋich agaayuliqsitlu aglaliqiritlu piqasiqhutiŋ sivulliuqtiġruanik utlaŋniġaat ");
INSERT INTO eskNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nipliutiplugu, “Uqautitigut, kisum aŋalatchił̣hagun savaaġivigich tamatkua? Kia saŋŋiksritpatin taatnatun?” ");
INSERT INTO eskNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus-ŋum kiuniġai, “Apiqsrullaglapsi uumiŋa. Uqautisitŋa, ");
INSERT INTO eskNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nakitña John-ŋum paptaaġiłha taluġniqusiqpa, Agaayyutmiñ naaga iñuŋniñ?” ");
INSERT INTO eskNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iŋmiknun kiumġatraaqsiñiqsut, “Qanuġmi uqautigisiñiqpisigu? Nipliġupta, ‘Agaayyutmiñ’, nipliġisiruq, ‘Suvaatami ukpiġiŋitpisiuŋ John?’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aglaan nipliġupta, ‘Iñuŋniñ’, iñugaaġruich miḷuqtuġisigaatigut uyaġaŋnik atakkii nalupqigiŋitchaat John sivuniksriqiraułha.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Uvvaasiiñ kiuniġaat, “Nalugikput nakitñaqtaułha.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus-ŋum nipliutiniġai, “Uvaŋaptuuq uqautiyumiñaitmigipsi nakitña saŋŋiqaqłuŋa savaaqaqtilaamnik tamatkuniŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Uqaanikami taavrumiŋa Jesus-ŋum uqaaqtuutiniġai iñuich atrikusautmik, “Iḷaatniguuq iñuqaġmiñiqsuq nautchirriġviḷiuġniqsuamik, atukkirrutigiplugu nautchirriqirinun aasiiñ aullaqami mulupluni. ");
INSERT INTO eskNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Katitchivik asianik tikitman tuyuqaġniqsuq savaktimik nautchirriqirinun akuqtuquplugich piksraġmiñik katittaŋitñiñ. Aglaan nautchirriqirit savakti anaullaġniġaat utiqtitlugu saagaunnagu. ");
INSERT INTO eskNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tuyuqalgiññiqsuq atlamik savaktimik. Aglaan nautchirriqirit anaullaqmiñiġaat uqaniqłuutiplugu kanŋunakun, suli utiqtitmiñiġaat saagaunnagu. ");
INSERT INTO eskNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tuyuqalgiññiqsuq piŋayuaknik savaktimik. Nautchirriqirit aŋallaqłukługu aninniġaat. ");
INSERT INTO eskNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aquagun taamna iñua nautchiivik nipliġñiqsuq, ‘Qanuġisiñiqpik? Tuyuġigisigiga iġñiġa piqpagikkaġa. Iḷumutun kamagigisigaat iłuatun.’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aglaan nautchirriqirit tautukamitruŋ nipliġñiqsut avatmun, ‘Taamna tavra paitchaktaaksrautilik. Ki, tuqullakput suuraŋiasiiñ piññaktaaġilugich!’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Uvvaasiiñ anitlugu nautchiiviŋmiñ tuqunniġaat.” Jesus apiqsruġniqsuq, “Nautchiiviḷgum sugisiñiqpagitmi tamatkua nautchirriqirit? ");
INSERT INTO eskNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aggiġisiruq aasiiñ tuqullugich taapkua iñuich, qaiḷḷuguasiiñ nautchiivik atlanun nautchirriqirinun.” Iñuich tusaakamitruŋ taamna nipliġñiqsut, “Naagga, taatnaqtuksrauŋitchuq!” ");
INSERT INTO eskNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus-ŋum tautukługich apiqsruġniġai, “Taamna uqałiq qanuutauva? ‘Uyaġak tuppirit ayakkaŋat, taamna uyaġak piitchuiḷḷapiaġaqtuq tuppirauni.’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kisupayaaq puukaqtuaq taavrumuŋa uyaġaŋmun siqumitauniaqtuq; aglaansuli taavruma uyaġaum kattaqitñikkumi iñuŋmik kanuġiñiaġaa.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aglaliqirit suli qaukłiŋich agaayuliqsit tigusuŋniġaat Jesus tavrani. Atakkii iḷitchuġiniġaat uqaġnipḷugu taavrumiŋa atrikusautmik iŋmiktigun. Aglaan iqsiñiqsut iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Naipiqtuaqsiñiġaat Jesus. Tuyuqaġniqsut naipiqtuqtiksranik nalaunŋaŋŋuaqtuanik. Pisaġisuŋniġaat Jesus uqayusautinik, qaitchukługu aŋalatchił̣iqaqtuamun kavanauruamun. ");
INSERT INTO eskNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tamatkua naipiqtuqtit pisaasuġmigaqługu nipliutiniġaat Jesus, “Iḷisautrii, iḷisimagikput uqałiqtin suli iḷisauttutitin nalaunŋałhat. Iḷisimagikput suqutiksriŋił̣hiñ iñuich iłhatnik, aglaan iḷisautrirutin Agaayyutim iñuuniaġvigitqukkaŋatnik iḷumutuuruakun. ");
INSERT INTO eskNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Uqautitigut, maliġutaksrakuaġnaqpa akiḷiiruni tax-sinik Caesar-mun naaga nalaunŋaitpa?” ");
INSERT INTO eskNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aglaan Jesus-ŋum kaŋiqsiñiġaa pisaasuġmigałhat aasiiñ nipliutiplugich, ");
INSERT INTO eskNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Maniḷḷaksaqsiuŋ uvamnun maniuraq. Kia agliutraŋa maniŋmi itpa? Kiasuli aglaŋa?” Kiuniġaat, “Caesar-m.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Uvvaasiiñ Jesus nipliġñiqsuq, “Nakuuruq, akiḷiutigigiksi Caesar-mun Caesar-m pigikkaŋa aasiiñ Agaayyutmun pigikkaŋa Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tavrani sivuġaatni iñuich pisaġilguitchaat sukununniiñ. Nipaisaaqhutiŋ quviġusuutiqaġniqsut kiggutaiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iḷaŋich Sadducee-ŋuruat, uqaġuuruat iñuich aŋitqitḷaiññipḷugich tuquŋaruaniñ, utlautiniqsut Jesus-mun nipliqhutiŋ, ");
INSERT INTO eskNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Iḷisautrii, Moses aglaŋniqsuq maliġutaksramik uvaptiknun itnaqhuni, ‘Aŋun iḷaqatiqaqtuaq tuqukpan qitunġigaluaqani, taavruma aŋutim aniaqataan iḷaqatniktaaġiraksraġiniġaa uiḷgaġnaaq qitunġisiḷugu aŋutmik iḷisimanaġuniasiiñ tuquruam qitunġaġitilaaŋanik.’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iḷaatniguuq tallimat malġuk aniqatigiich inniqsut. Aŋayukłiq iḷaqatniŋniqsuq tuqupluniasiiñ qitunġigaluaqani. ");
INSERT INTO eskNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tuglian nuliaġniġaa uiḷgaġnaaq, ");
INSERT INTO eskNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","aasiiñ piñayuaknik. Taatnatuntuuq iluqatiŋ tallimat malġuich tuquniqsut qitunġigaluaqatiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aqulliupluni uiḷgaġnaaq tuquniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Uvvaasiiñ, uvluni tuquŋaruat aŋitqikpata iñuułiġmun, nuliaġiplugu iluqatiŋ tallimat malġuk kia nuliaġigisivauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus kiuniġai, “Katchuutrułiq pigigaa marruma iñuuniałhum, ");
INSERT INTO eskNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","aglaan aŋutit aġnatlu aŋitqikkumiŋ tuqułiġmiñ katchuutiraġaġumiñaitchut pakmani. ");
INSERT INTO eskNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Atriqaġisirut isaġuliŋnik tuqqutlaitchuanik. Iġñiġigai Agaayyutim atakkii aŋitqikkauplutiŋ tuqułiġmiñ nutaamun iñuułiġmun. ");
INSERT INTO eskNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Suli Moses nalunaiqł̣ugu ukpiqnaqsiñiġaa aŋitqił̣iq iñuułiġmun ikualaruakun uqpigaurakun. Moses-ŋum uqautiginiġaa Ataniq itna, ‘Agaayyutaa Abraham-ŋum Isaac-ŋumlu, suli Jacob-ŋum.’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ilaa Agaayyutiginiġaat iñuuruat, pigiŋitchaat tuquŋaruat, atakkii ilaanun iluqatiŋ iñuich iñuurut.” ");
INSERT INTO eskNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iḷaŋich aglaliqirit uqaġniqsut, “Aarigaa kiggutin, iḷisautrii!” ");
INSERT INTO eskNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tavrakŋa apiqsrutqiŋaiġñiġaat taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus-ŋum Pharisee-ŋuruat apiqsruġniġai, “Suvaata iñuich uqaġniqpat Christ, Anniqsuqti akiqsruutauruaq, kiŋuviaġinipḷugu David-mun? ");
INSERT INTO eskNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Atakkii David ilaa nipliġñiqsuq Psalms-ni, ‘Ataniq uqaqtuq Atanimnun: Aquvittin kamagitchiiviksrapnun ");
INSERT INTO eskNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","uvaŋnun akiiḷiñiałhatnunaglaan uumigiritin.’ ");
INSERT INTO eskNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David-ŋum iŋmiñik taiguutiqaqpagu Ataniġmiñik, qanuġmi Anniqsuqti David-ŋum kiŋuviaġiniqpauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iluqatiŋ iñuich naalaġnipkaqługich Jesus-ŋum nipliutiniġai maliġuaqtini, ");
INSERT INTO eskNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Qaunagititchi tamatkunakŋa aglaliqiriniñ. Pisuktuatlaturut akuqturuanik atnuġaaqhutiŋ. Suli purvigitqutlaturut iñuŋnun paġlatqusuuplutiŋ tauqsiġñiaqviŋñi. Aquppiutaksraqtuuraaqmiut aquppiutaġiksaanik katraġviŋñi iñuich niġiqpakmata. ");
INSERT INTO eskNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ivayaqtuqmigaich uiḷgaġnaat, tigliktuipḷugich kiŋunauraŋitñik, suli qiñiqqusaatlaturut agaayuuraaqamiŋ! Anasiñŋuqsausiaqaġisirut pitḷuglugu atlaniñ iñuŋniñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus tautuŋniqsuq umialguruanik iñuŋnik iḷiripmata aatchuutmiknik agaayyuvikpaum iḷirivianun, ");
INSERT INTO eskNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","tautukmiñiġaa inuqsraqtuaq uiḷgaġnaaq iḷisiruaq malġuŋnik patukpaaŋnik maniuraaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nipliġñiqsuq, “Uqautigipsi, taamna inuqsraqtuaq uiḷgaġnaaq iḷisitḷuktuq iluqaitñiñ atlaniñ, ");
INSERT INTO eskNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","atakkii atlat iḷisirut aatchuutmiknik iḷaŋatniñ umialgutmiŋ, aglaan aġnam inuqsraqtuam qaitkaa iluqaan iñuuniutiksraġaluani.” ");
INSERT INTO eskNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iḷaŋisa maliġuaqtit uqautiginiġaat qanutun qiñiyunaqtilaaŋa agaayyuvikpaum, piññaqusiqsaqtaq uyaġaŋnik suli aatchuutauruaniglu qaisauruanik Agaayyutmun. Jesus nipliġñiqsuq, ");
INSERT INTO eskNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Iluqaan tamanna tautukkaqsi—taimanigu kisiŋŋuqtaqaġumiñaitchuqunniiñ uyaġaŋmik qalliani atlam ulġusimaitchuam.” ");
INSERT INTO eskNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iñuich apiqsruġniġaat, “Iḷisautrii, qakugun tamanna atuummiñiaqpa? Sukun iḷitchuqqutikun iḷitchuġigisivisa piyaqquġviksraq aullaġniigaqsikpan?” ");
INSERT INTO eskNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus-ŋum kiuniġai, “Qaunagititchi ukpiqsakkauniaqasi. Iñugiaktuat iñuich aggiġisirut uqaġutiŋ, ‘Christ-ŋuruŋa! Pivik tikiumaruq!’ aglaan maliŋniaqnasigik. ");
INSERT INTO eskNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Iqsiñiaqasi tusaagupsi aŋuyaktuanik aġayaktuaniglu. Tamatkua atuumagisirut sivulliulutiŋ aglaan isukłitchumiñaitchuq taapkunuuna.” ");
INSERT INTO eskNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Niplipsaaġniqsuq, “Nunaaqqich aŋuyyiuġisirut atlanik nunaaqqiñik, atanġuviich aŋuyyiuġisirut atlanik atanġuviŋñik. ");
INSERT INTO eskNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nuna iḷiksraġisiruq tatamnaqsiḷuni. Iñuich kakkaaġisirut. Iñuich atniġñautiqaġisirut tigupqutnaqtuanik naniliqaa. Atlayuaġnaqtuat sagviġisirut qiḷaŋmi iqsipkaġlugich iñuich. ");
INSERT INTO eskNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sivuatni tamatkua tikiumagaluaqnagich, tiguraulusi piyuaqsiugisirusi. Iñuich uqaqsittaaġviŋmuktitkisigaasi katraġviŋmiknun isiqtaupkaġusi, tikiutruġusi sivuġaatnun umialgich kavanauruatlu pisigiluŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Taivrumani piviksraqaġisiñiqsusi iḷisimaraulusi. ");
INSERT INTO eskNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Isumaaluŋaiġitchi kiggutiksrapsitñik tiguraugaluaqasi. ");
INSERT INTO eskNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Atakkii uqaksritkisigipsi isumatułiġmiglu uumigiripsiunniiñ igḷuliuġumiñaisaŋatnik. ");
INSERT INTO eskNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aŋayuqaapsi aniqatiupsiḷu iḷapsiḷu suli iḷannapsiḷu qaitkisigaasi uumigiripsitñun, aasii iḷasi tuqqutaugisirut. ");
INSERT INTO eskNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iluqatiŋ iñuich uumigigisigaasi pigiluŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aglaan atausiqunniiñ nuyaŋa niaquqpich tammakkauyumiñaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Qichaġitchi anuqsrułikun. Nikaitkupsi piññaktaaġiniaġiksi iñuułiqsi. ");
INSERT INTO eskNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Tautukkupsiuŋ Jerusalem puuqpatruŋ aŋuyaich iḷitchuġigisigiksi qallił̣ha piyaqqukkaułiksraŋan. ");
INSERT INTO eskNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Taipkunani uvluni kiñapayaaq iñuuniaqtuaq Judea-mi qimakkumauq iġġiñun. Kiñapayaaq nunaaqqimiittuaq aullaqtuksrauruq, suli avataani nunaviŋmiittuaq nunaaqqimuktuksrauŋitchuq. ");
INSERT INTO eskNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Atakkii taapkua uvluġigai anasiñŋuqsautiksram immiumatquplugich iluqaisa sivuniksriqirit uqauttutiŋich. ");
INSERT INTO eskNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Qanutun tatamnaqtigigisiva taipkunani uvluni aġnanun siŋiayauruanun suli aakanun miluktitchiruanun. Tatamnaqtuaq iłuiññaq tikiumagisiruq tamarrumuŋa nunamun, atakkii Agaayyutim qinnautaa akikŋautaugisiruq makunuŋa iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iḷaŋich tuqqutaugisirut savikpakun atlat suli tigutaaqsiulutiŋ Jew-ŋuŋitchuanun. Iliŋisa tutmiġaġigisigaat Jerusalem piviksraqtiŋ isukłiññiałhatnunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Atlayuaġnaġisirut siqiñiġlu tatqiġḷu suli uvluġiatlu. Iñuich nanipayaaq qanuusiksriaġisirut, iqsiḷutiŋ nipruaġniŋanik taġium aksraligruaŋiñiglu. ");
INSERT INTO eskNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Iñuich iġivrugaġisirut iqsiḷutiŋ isumaalułiġmikni sumsuli tikitchuksraŋanik iluqnaanun nunamun, atakkii qaummatipayaaŋi siḷam nuktitaulutiŋ inimikniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Qiñiġisigaat Iġñiŋa Iñuum aggiqsuaq nuviyakun qiḷaŋmiñ saŋŋimigun kamanallapiaqtuakun kamanautmigunlu. ");
INSERT INTO eskNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tamatkua atuumaaqsikpata qichaġitchi niġiugaqaġusi. Atakkii tasuqsakkaułiksraqsi qalliruq.” ");
INSERT INTO eskNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus-ŋum uqautiniġai atrikusautmik, “Qiñillaksaqsiuŋ asirrisuuruaq napaaqtuq suli iluqaisa atlat napaaqtut. ");
INSERT INTO eskNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Milukatat sagviaqsipmata iḷisimaraġigiksi upinġaam qallił̣ha. ");
INSERT INTO eskNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Taatnatuntuuq atuumaaqsikpata tamatkua uqautigikkatka iḷitchuġigisigiksi aŋaayuqautaan Agaayyutim tikiññialił̣ha. ");
INSERT INTO eskNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Itqallaksiuŋ una! Iñuich iñuuniaqtuat pakma tuquyumiñaitchut tamatkua iluqatiŋ atuumagaluaqtitnagich. ");
INSERT INTO eskNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Qiḷaglu nunalu piiġisiruk aglaan uqałitka piiġumiñaitchut. ");
INSERT INTO eskNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Munaġititchi! Isumaiqsitnasi taaŋŋaġmunlu isumaaluutaanunlu marruma iñuuniałhum. Taatnaŋitchupsi uvlum quviqpiaġaasi tavrakŋatchiaq niġiunġisillusi. ");
INSERT INTO eskNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Naniġiatun pisaġigisigai iluqaisa iñuich nanipayaaq nunami. ");
INSERT INTO eskNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Munaġiyumausiḷi agaayulusi ataramik makitalgulusiasiiñ payaŋaiġusi iluqaani atuumarauksrani aggiġñiałhanunaglaan Iġñiŋan Iñuum.” ");
INSERT INTO eskNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Uvluġaġipman Jesus iḷisautriraqtuq agaayyuvikpaŋmi. Anaqaksraaqman siñiktaġiaġniqsuq iġġiani atiqaqtuam Olives-mik. ");
INSERT INTO eskNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Uvlaaġuqman iñuich utlautiraqtut agaayyuvikpaŋmun naalaġnisukługu uqaqpan. ");
INSERT INTO eskNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Niġiqpagvikaaq atilik Apqusaakkaułiġmik qalliñiqsuq iñuich niġipmata puvlaksiġniġiḷaamik qaqqumik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Qaukłiŋich agaayuliqsit suli aglaliqirit tuqqutchuŋniġaat Jesus nalunautchiḷutiŋ aglaan iqsiginiġaich iñuich. ");
INSERT INTO eskNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tavrakŋa tuunġaq isiġniqsuq Judas-mun atiqaqtuamun Iscariot-mik, iḷaŋat qulit malġuk maliġuaqtit. ");
INSERT INTO eskNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas-ŋum uqaqatigityaġniġai qaukłiŋich agaayuliqsit aŋalatiŋitḷu agaayyuvikpaum iłuaqtitchiñiaqtiŋiñ qanuq aatchuutigisukługu Jesus iliŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Quviasukhutiŋ akiqsruġaat akiḷiġukługu maniŋmik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas aŋiġniqsuq. Piviksraqsiugaqsiñiġaa aatchuutigisukługu Jesus iliŋitñun iñuich nalupkaġlugich. ");
INSERT INTO eskNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Akunniqsaami uvlua Puvlaksiġniġiḷaam qaqqum tikiññiqsuq, taamna Apqusaakkaułhum ipnaiyaam tuqurviksraŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus-ŋum tuyuġigik Peter-lu John-lu itnaqługik, “Itqanaiyaġiatku niġiqpałiksraqput.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Apiqsruġniġaak, “Nani itqanaiyaquvisiguk?” ");
INSERT INTO eskNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus-ŋum kiuniġik, “Isiġuptik nunaaqqimun paaġisigiktik iñuk akiyaqtuaq qattamik imiliŋmik. Malikkumaiktik isiqpan tupiġmun, ");
INSERT INTO eskNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","suliasiiñ nipliutilugu iñua tupqum, ‘Iḷisautri nipliġñiqsuq, Nani iniqaqpich tuyuġmiaqaġviŋmik niġġiviksramnik ipnaimik piqasiġḷuŋa maliġuaqtimnik niġiqpagvikaami atiqaqtuami Apqusaakkaułiġmik?’ ");
INSERT INTO eskNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Uuma urriqsuutigisigaatik inimik nallauraallagviuluumaaqtuamik qulliġmi itqanaiḷaamik inuqsraŋaiqł̣ugu. Tavrani itqanaiyałhiñaurutik.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aullaqamik paqinniġaak taatnatun Jesus-ŋum uqałhatun, aasiiñ itqanaiyaqhutiŋ niġiqpagviksramun atiliŋmun Apqusaakkaułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Niġġiviksraqtiŋ tikitman Jesus aquvinniqsuq piqasiqhuni uqqiraqtinik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nipliutiniġai, “Niġiqatigisullapiaġipsi uumiŋa ipnaimik niġiqpagvikaami atiqaqtuami Apqusaakkaułiġmik nagliksaaŋŋaiñŋaġma! ");
INSERT INTO eskNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Uqautigipsi, niġitqiŋñiaŋitkiga immiumaniałhanunaglaan aŋaayuqautaani Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Taatnaanikami Jesus-ŋum tiguplugu qallun, quyaniġaa Agaayyun nipliqhuni, “Tigulugu taamna imillagvigisiuŋ! ");
INSERT INTO eskNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Uqautigipsi, uvakŋaniñaglaan imitqikkumiñaitchuŋa asiam misuġuanik aggiġñiałhanunaglaan Agaayyutim aŋaayuqautaan.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesus-ŋum tiguplugu qaqquq quyaniġaa Agaayyun. Avguqługu qaqquq qaiññiġaa nipliqhuni, “Taamna qaqquq timigigiga qaisauruaq ilipsitñun. Niġġisiuŋ itqakkutigilugu uvaŋnun.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Taatnatuntuuq, niġianikamiŋ qallun qaiññiġaa nipliqhuni, “Asiam misuġua uumani qallutmi Agaayyutim nutaaq sivunniuġutigigaa taluġniqusiqł̣ugu aupkun maqikkauruamik ilipsitñun.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ataŋii! Iḷapsisamma aquppiqatima qaiññiaġaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iġñiŋa Iñuum tuquruksrauniaqtuq Agaayyutim sivunniutaagun, aglaan nakłiuŋ iñuŋmi qaitchiruami ilaanik!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Maliġuaqtai apiqsruqtautiaqsiñiqsut avatmun nalliqsiŋ qaitchiyummatiqaqmagaan ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Maliġuaqtai qapiqtaiḷitraġniqsut nalliqsiŋ kamanaġniqsraugisipmagaan. ");
INSERT INTO eskNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus-ŋum nipliutiniġai, “Jew-ŋuŋitchuat umialgich saŋŋiqaqtut iñuŋmikni suli aŋalatit taigukkautlatuplutiŋ Iḷauraaŋitñik Iñuich. ");
INSERT INTO eskNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aglaan taatnatun itchuksrauŋitchusi. Kamanaġniqsrauruaq akunnapsitñi iḷiḷi nukaqłiqsun suli sivulliuqti savaktitun. ");
INSERT INTO eskNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kiña kamanaġniqsrauva—taamna aquvitluni niġiruaq naagaqaa taamna payuktaqtuaq? Tavrataamna aquppiruaq kamanatluktuq. Aglaan iqasiġipsi payuktaqtitun. ");
INSERT INTO eskNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ilipsi, nayuġipsitŋa uuktuaqsiupayaaqama. ");
INSERT INTO eskNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Atriḷiḷugu aapaa aŋalatchitḷasipkaił̣ha uvamnik, taatnatuntuuq aŋalatchitḷasipkaġisipmigipsi. ");
INSERT INTO eskNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Niġiqasiġisigipsitŋa imiqasiġḷuŋalu aŋalatchiaqsiguma iñuŋnik, suli aquppiqasiġisigipsitŋa taivrumani atanniityaġuma kiŋuviaġiiñik qulit malġuŋnik iġñiŋitñik Israel-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Annaa, Simon! Naalaġniḷḷagiñ! Tuunġaum uuktuaġumiñaqsiñiġaasi iluqasi, nautchirriqiri aviktuipmatun mukkaaksranik sanikłuŋniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aglaan agaayyutigikpiñ ukpiqsrił̣hiñ qapiquŋiḷḷugu. Utiġuvich uvaŋnun sayyiġisigitin aniqatiutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon Peter-m kiuniġaa, “Ataniiq, isiqtauqasił̣hiñaugikpiñ suli tuquqasiġutin!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus nipliqsuq, “Peter, uqautigikpiñ, aqargiqpak qalġuqtaġaluaqnagu uvlaami piiḷaaġigisigikma piñasuniaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus-ŋum uqaanikami taavrumiŋa apiqsruġniġai maliġuaqtini, “Taimani tuyuġikapsi manikuviiḷaaqhusi puukataiḷaaqhusiḷu sakpakkiiḷaaqhusiḷu, inuqsraqpisi?” Kiuniġaat, “Inuqsraŋitchugut.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesus nipliġñiqsuq, “Aglaan pakma, kiña maniqaġviqaġumi naagaqaa puukataqaġumi saagaġligik. Suli kiñapayaaq savikpaitchumi tuniraksraġigaa quppiġaani aasiiñ tauqsiġuni savikpaŋmik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Uqautigipsi, Taamna uqałiq aglausimaruaq Agaayyutim makpiġaaŋiñi atuumaruksrauruq, itna ‘Irrutiniġaat savamaqłuktuatun.’ Iluqaan aglausimaruaq uvapkun immiumakkauniaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Maliġuaqtit nipliġñiqsut, “Ataniiq, uvva malġuk savikpaak!” Kiuniġai, “Tavra apai!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus aullalgiññiqsuq iġġimun atiliŋmun Olives-mik piraġiłiġmisun, aasiiñ maliġuaqtaiñ malikkaat, aglaan Judas maliŋitchuq. ");
INSERT INTO eskNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tikitñamiŋ taruŋa nipliutiniġai, “Agaayulusi ukpiqsrisaiŋitchumausiḷi uuktuaqsiugupsi.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tavrakŋa aullaqtaallakhuni sitquqhuni agaayuniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nipliġñiqsuq, “Aapaaŋ, pisułiġiyupku piiġuŋ qallutaa nagliqsaałhum uvaŋniñ. Uvaŋa pisułiġiŋiḷaaptun aglaan pisułhiñ savaaŋuli.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Isaġulgum qiḷaŋmiñ sagviutiniġaa sayyiqł̣ugu. ");
INSERT INTO eskNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iłuiḷḷiuqpałikun agaayuniqsuq piḷiqitlukhuni, aasii ilaan siiqsipkałha kataktuq auktun nunamun. ");
INSERT INTO eskNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Makitnami agaayułiġmiñiñ utiqhuniasiiñ maliġuaqtimiñun tavra paqinniġai siñiktuat, minġuqhutiŋ iłuiḷḷiuqpaitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nipliutiniġai, “Suvaata siñikpisi? Makillusi, agaayyutitchi ukpiqsrisaiŋitchumausiḷi uuktuaqsiugupsi.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus uqaqtitlugu iñugiaktuat iñuich tikiññiqsut, sivulliqł̣ugich Judas-ŋum, iḷaŋata qulit malġuk maliġuaqtit. Utlakługu Jesus kuniŋñiġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aglaan Jesus nipliutiniġaa, “Judas, kunikł̣ugu aatchuutigiviuŋ Iġñiŋa Iñuum?” ");
INSERT INTO eskNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Maliġuaqtit nayuutiruat Jesus-mi tautukamitruŋ taamna atuumaruaq uqautiniġaat, “Ataniiq, atuġlavut savikpavut!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iḷaŋata anauniġaa qaukłiata agaayuliqsit savaktaa siutaiqsiqługu taliqpianik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aglaan Jesus nipliġñiqsuq, “Aŋŋaa! Apaiqsuq!” Aksikł̣ugu iñuum siutaa mamitinniġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Taavruma aquagun Jesus-ŋum nipliutiniġai qaukłiŋich agaayuliqsit suli aŋalatiŋich agaayyuvikpaum iłuaqtitchiñiaqtiŋiñ suli sivulliuqtiġruat tikitchuat aipḷugu ilaa, “Aatai, tikitchuksrauvisi savikpaligaaġusi anautaniglu uvaŋa liilaa savamaqłukti? ");
INSERT INTO eskNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nayuġaġikapsi agaayyuvikpaŋmi uvluġaġipman tiguniatlaitchipsitŋa. Aglaan pakma savagviksraġigiksi saŋŋiagun taaqtuam.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tamatkua tiguplugu Jesus aullautiniġaat tupqanun qaukłiata agaayuliqsit, suli Peter-m maliŋniġai taavakŋatluk. ");
INSERT INTO eskNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ikniqaġniqsut siḷataani tupqum, aasii Peter-m iḷaliġniġai aquppiruat tavrani. ");
INSERT INTO eskNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iḷaŋata pirit aġnam tautuŋniġaa Peter aquppiruaq saniġaani ikniġum. Qiñiqługu naliŋiñaaqługu nipliutiniġaa, “Una iñuk piqataupmiruaq Jesus-mi!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aglaan Peter piiḷaaġniqsuq, “Aġnaaq, nalugiga!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kiñuuraŋagun iñuk iḷitchuqsripmiñiqsuq Peter-mik nipliqhuni, “Ilvich, iḷagigaatintuuq taapkua!” Aglaan Peter-m kiuniġaa, “Naagga, iḷagiŋitchaatŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sassaġniġum kiñuagun atlam iñuum qapiŋaiqhuni upyaŋniġaa, “Iḷumun una iñuk piqataupmiruaq Jesus-mi, atakkii Galilee-ġmiuŋuruq!” ");
INSERT INTO eskNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aglaan Peter-m kiuniġaa, “Nalullapiaġiga sumik uqaqtilaan.” Uqaqtitlugu tavrakŋatchiaq aqargiqpak qalġuqtaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Atanġuruam qiviaqhuni tautuŋniġaa naliŋiñaaqługu Peter, aasii Peter-m itqaġniġaa atanġum niplił̣ha iŋmiñun, “Aqargiqpak qalġuqtaġaluaqnagu uvlaapak piiḷaaġutigigisigikma piñasuniaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter tavra anipḷuni qianiqsuq iłuiḷḷiullapiaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iñuich munaqsriruat Jesus-mik mitautiginiġaat anaullaqługulu. ");
INSERT INTO eskNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matuplugik irrak apiqsruġniġaat, “Kia anauvatin? Nalautchaġiñ?” ");
INSERT INTO eskNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nipliutipmiñiġaat iñugiaktuanik pisaaŋŋatinik. ");
INSERT INTO eskNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Uvlaaġuqman Jew-ŋuruat sivulliuqtiġruat qaukłiŋich agaayuliqsitlu aglaliqiritlu katiniqsut, aasiiñ Jesus tikiutiniġaat uqaqsittaaqtitchirinun, ");
INSERT INTO eskNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","nipliqhutiŋ, “Uqautitigut! Ilvich Christ-ŋuvich, taimña akiqsruutauruaq Anniqsuqti?” Jesus-ŋum kiuniġai, “Uqautigupsi ukpiġiniaŋitchipsitŋa; ");
INSERT INTO eskNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","suli apiqsruġupsi apiqsruutmik kiuyumiñaitchipsitŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aglaan uvakŋa Iġñiŋa Iñuum aquppigisiruq tuŋaani taliqpian Agaayyutim piqaqtuam saŋŋipayaamik.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Iluqatiŋ nipliġñiqsut, “Ilvich, Iġñiġivatin Agaayyutim?” Kiuniġai, “Ilipsi, uqaqtusi Iġñiġinipḷuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kiisaimmalu nipliġñiqput, “Inuqsraŋaiqsugut iḷisimarimik! Tusaagikput qanuq niplił̣ha.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Iluqatiŋ iñuich makitlutiŋ Jesus Pilate-muutiniġaat kavanauruamun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tavrani pasiaqsiñiġaat Jesus itnaqhutiŋ, “Iḷitchuġigikput una aŋun killukuaqtitchił̣ha iñuptiknik atakkii uqautiniġai akiḷiquŋitḷugich tax-sinik Caesar-mun Rome-mi. Uqautiniġaisuli ilaa Christ-ŋunipḷuni umialik.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate-ŋum apiqsruġniġaa, “Umialigivatin Jew-ŋuruat?” Jesus aŋiġniqsuq, “Aa, nalauttutin.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Taamna atuumaanikman Pilate-ŋum nipliutiniġai qaukłiŋich agaayuliqsit iñugaaġruiḷḷu, “Iḷitchuġiŋitchuŋa patchisiksramik uumani aŋutmi.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aglaan qapiŋaipsauraqtut, “Iḷisauttutimigun aġayagaġigai iñuich iluqaani Judea-mi. Aullaqniiruq Galilee-mi pakma mauŋaqhuniasiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate-ŋum tusaakamiuŋ taamna apiqsruġniġaa, “Una aŋun Galilee-ġmiuŋuva?” ");
INSERT INTO eskNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Iḷitchuġikamiuŋ Jesus-ŋum aggiqsilaaŋa nunamiñ aŋalataŋaniñ Herod-ŋum, tuyuġiniġaa Herod-mun tavraniitmiñiqsuamun Jerusalem-mi. ");
INSERT INTO eskNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod quviasupiaġataġniqsuq tautukamiuŋ Jesus, atakkii tusaaplugu suli qiñiġummiuqługu iŋiḷġatluk. Tautukkummiuġniqsuq Jesus savakpan quviqnaqtuanik. ");
INSERT INTO eskNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod-ŋum apiqsruqtaaqsiñiġaa Jesus iñugiaktuanik apiqsruutinik, aglaan Jesus-ŋum kiuŋiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Qaukłiŋich agaayuliqsit suli aglaliqirit qapiŋaipsauraqhutiŋ pasiuġniġaat Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod-ŋum aŋuyyiuqtaiñḷu mitautiginiġaat Jesus suvasaġiŋitḷugu. Atipkaqługu atanġum atnuġaallautaŋanik utiqtinniġaat Pilate-mun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Taavrumani uvlumi Herod-lu Pilate-lu iḷauraġiiksinniqsuk sivuani uumigiikkaluaqtuak. ");
INSERT INTO eskNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate-ŋum katipkaġniġai qaukłiŋich agaayuliqsitlu sivulliuqtit iñuiḷḷu, ");
INSERT INTO eskNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","suli nipliutiplugich tamatkua, “Tikiutigiksi una aŋun uvaŋnun nipliqhusi sivulliullautaŋiññipḷugich iñuich. Isivġiuġaluaqługu sivuqqapsitñi paqitlaitchiga savamaqłuutiqaġlugu pasiuġutipsitñik. ");
INSERT INTO eskNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Unniiñ Herod-tuuq paqitchiŋitchuq agvisiksramik, atakkii utiqtitqiŋñiġaa uvaptiknun. Una aŋun piitchuq sumik tuqurrutauyumiñaqtuamik ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Taatnaġluŋa ipiġaqtuqtitqaaġlugu aullaqtitkisigiga.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilate patchisaiqsitchisuuruq atautchimik isiqtamik niġiqpagvikaam uvluani. ");
INSERT INTO eskNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iñugaaġruich niplianiqsut, “Tuqqutchiuŋ taamna iñuk aasiiñ tigutaaqtauŋaiqsillugu Barabbas!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas isiqtauniqsuq atakkii iḷaupluni tamatkunani aġayakhutiŋ nunaaqqimi tuqqutchiruaniḷu). ");
INSERT INTO eskNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate-ŋum Jesus patchisaiġukkaluaġaa. Taatnamik uqaġvigitqikkaluaġai iñugaaġruich. ");
INSERT INTO eskNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aglaan iġialaniqsut nipitusipḷutiŋ, “Kikiaktuutisiuŋ! Kikiaktuutili sanniġutamun!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate-ŋum piŋatchiqł̣ugu nipliġñiqsuq, “Sumik savamaqłuutiqaqpa? Paqitchiŋitchuŋa sumik tuqurrutauyumiñaqtuamik ilaanun. Ipiġaqtuqtillugu patchisaiġisigiga.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aglaan iġialapsauraġniqsut kikiaqtuutiraksraupiaġnipḷugu sanniġutamun. Kiisaimmalu iġialałiġmiktigun akimavut. ");
INSERT INTO eskNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Uvvaasiiñ Pilate-ŋum atanniġñiġaa Jesus kipiqniuġutaatitun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilate-ŋum pituiġñiġaa Barabbas pisukkaŋat, taamna isiqtauruaq atakkii iḷaupluni tamatkunani aġayakhutiŋ iñuaqtuani, aasiiñ qaitḷugu Jesus iliŋitñun pisułhatitun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aŋuyyiuqtit sivulliġñiġaat Jesus. Pisullaġmiŋ paaqsiñiqsut iñuŋmik Cyrene-naġmiumik atiqaqtuamik Simon aitmuktuamik nautchiiviŋmiñ. Tamatkua nunuriñiġaat akiyaġiaquplugu sanniġutamik aquagun Jesus-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Iñugiallapiaqtuat iñuich maliŋniġaat. Akunġatni itmiñiqsut aġnat qairuat uiġualaplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus-ŋum kiŋiaqami nipliutiniġai, “Aġnaaŋisii Jerusalem-ŋum! Qirratiginasitŋa aglaan qirratigisitchi ilipsitñun qitunġapsitñunlu. ");
INSERT INTO eskNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Atakkii uvlut qallirut iñuich nipliġisił̣hat, ‘Quvianamiurut taapkua aġnat qitunġaitchuat siŋaiyautlaitchuatlu miluktitchisimaitchuatlu.’ ");
INSERT INTO eskNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Taivrumani uvlumi iñuich nipliġisirut iġġiñun, ‘Katagitchi uvaptiknun!’ suli qimiġaanun, ‘Iriqtigut.’ ");
INSERT INTO eskNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Atakkii taatnatun irrutikpatruŋ patchisaitchuaq pakmapak, qanutun irrutriñiaqmivat iñuŋnik taimanigu?” ");
INSERT INTO eskNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Malġuk atlak iññuk, iluqatik savamaqłuksimaruak, tuqqutauruksraupmiñiqsuk piqataulugik Jesus-mi. ");
INSERT INTO eskNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aŋuyyiuqtit tikiññiqsut atiqaqtuamun “Saunġa niaqum.” Tavrani kikiaktuutiniġaat Jesus suli taapkuak savamaqłuksimaruak piqasiqł̣ugu, iḷaqataa taliqpian tuŋaanun suli iḷaqataa saumian tuŋaanun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus nipliġñiqsuq, “Aapaaŋ, natqigutikkich tamatkua iñuich! Nalugaat sumik savaaqaqtilaaqtiŋ.” Avguġniġaich atnuġaaŋi nalautchaġautigiplugich. ");
INSERT INTO eskNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iñuich qichaqtuat tautuktuaġniġaat. Jew-ŋuruat sivulliuqtiŋisa mitautiginiġaat, “Annautiraġigai atlat. Ki anniqsuġli iŋmiñik Christ-ŋuyumi, Anniqsuqti akiqsruutauruaq Agaayyutim piksraqtaaġikkaŋa!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aŋuyyiuqtit mitautigipmiñiġaat. Utlakługu aatchuġniġaat suŋaġnitchuamik misuqqumik ");
INSERT INTO eskNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nipliqhutiŋ, “Anniqsuġiñ ilipnik umialigikpatin Jew-ŋuruat!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Niaquan qulaagun aglakługich uqałhich, “Taamnauvva umialgat Jew-ŋuruat.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iḷaqataan savamaqłuksimaruam niviŋaruam uqaġniqłuktaqmiñiġaa, “Christ-ŋuguvich anniqsuġiñ ilipnik uvaguglu!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aglaan iḷaqataan iñiqtiġniġaa nipliqhuni, “Taluġiŋitpiuŋ Agaayyun? Tuqqutaksraurutintuuq ilaatun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tuquniaqtuguk nalautlugu atakkii taatnaġnaqhunuk; aglaan taamna savaaqaŋitchuq pigiitchuamik.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aasiiñ nipliutiniġaa, “Jesus, itqaġillaŋniaŋŋa tikitchuvich aŋaayuqautipnun!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus-ŋum nipliutiniġaa, “Akiqsruġikpiñ, marrumani uvlumi piqasiġisigikma utaqqiviŋmi.” ");
INSERT INTO eskNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Uvluq qitiqquqman siqiññaaġiŋaiġñiqsuq taaqsipḷuni nunapayaami piñasunun iḷipman sassaq; ");
INSERT INTO eskNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","talukuyaaq sapukutchiutauruaq niviŋaruaq agaayyuvikpaŋmi siiksiġniqsuq tatpichakŋa takunuŋaaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus nipaalaliġniqsuq, “Aapaaŋ! Argaknun iḷigiga irrusiġa!” Taatnaanikami tuquniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rome-maġmiut qaukłiata aŋuyyiuqtit tautukługu tamanna atuumaruaq kamaksruġniġaa Agaayyun nipliqhuni, “Iḷumutun taamna aŋun nalaunŋaruq!” ");
INSERT INTO eskNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iñuich katiruat qiñiġiaqługu kikiaktuutrił̣iq tautukamitruŋ tamanna atuumaruaq, utiġniqsut kiŋuniġmiknun ipiqtutchallapiaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iluqatiŋ tamatkua iḷisimaruat Jesus-mik iḷagiplugiḷḷu aġnat maliktuat Galilee-miñ qichaġniqsut taiñakŋatluk qiñiġiaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iñuqaqmiñiqsuq atiliŋmik Joseph-mik Arimathea-ġmiumik, nunaaqqimiñ Judea-mi, nalaunŋaruaq qanutitaŋitchuaġlu iñuk, suli utaqqiñiqsuaq tikił̣iqsraŋanik aŋaayuqautaan Agaayyutim. Iḷaugaluaqhuni uqaqsittaaqtitchirini aŋiqatauŋiññiqsuq sivunniuqmata tuqqutchukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Joseph-ŋum utlautipluni Pilate-mun apiqsruutiginiġaa timaa Jesus-ŋum pisukługu. ");
INSERT INTO eskNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tavrakŋa atqaqługu timaa Jesus-ŋum, nimiqsruġniġaa ukił̣haaġiksaamik, iḷipḷuguasiiñ iḷuviḷiuqtamun uyaġaŋmi atunġaŋitchuamun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iluqani tamanna atuumaniqsuq minġuiqsiaġvium uvlua aullaġniiyasipman. ");
INSERT INTO eskNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aġnat maliktuat Jesus-mik Galilee-miñ maliŋniġaat Joseph tautukługuasiiñ qanuq Jesus-ŋum timaa iḷipmagu iḷuviġmun. ");
INSERT INTO eskNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Utiqhutiŋ kiŋuniġmiknun itqanaiyaġniġaich tipraġiksautilgich uqsruġutiksrai timaan Jesus. Jew-ŋuruat minġuiqsiaġviatni minġuiqsiġniqsut kamagiplugu tillisaa Moses-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Uvlaatchauraŋani sivullium uvlum akunniqsaami aġnat iḷuviġmuŋniqsut saagaqhutiŋ tipraġiksautiliŋnik uqsruġutiksraiñik itqanaiyaaġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Paqinniġaat uyaġak aqsraqtiŋaniqsuaq paaŋaniñ iḷuvġum. ");
INSERT INTO eskNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tavraasiiñ isiqamiŋ paqinġiññiġaat timaa atanġuruam Jesus. ");
INSERT INTO eskNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Qanuqsausiuqtitlugich tavrakŋatchiaq malġuk aŋutik qitñaġnaqtuanik atnuġaallak qichaġniqsuk saniġaatni. ");
INSERT INTO eskNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Iqsitchakhutiŋ aġnat sikinniqsut nunamun. Aŋutik nipliutiniġaich, “Suvaata tautugiaqpisi iñuuruamik akunġatni tuquŋaruat? ");
INSERT INTO eskNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Uvaniinġitchuq atakkii iñugutqiksuq. Itqallaksiuŋ qanuq uqaqtilaaŋa ilipsitñun Galilee-miinŋaġmiñi, itna, ");
INSERT INTO eskNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Iġñiŋa Iñuum qaisauruksrauruq killuuruanun iñuŋnun kikiaktuutikkauluni, aasiiñ piñayuatigun uvlut aŋitqikkumapluni iñuułiġmun.’” ");
INSERT INTO eskNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aġnat itqaġniġaat uqaġikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Utiqhutiŋ iḷuviġmiñ uqautiniġaich qulit atausiq maliġuaqtit atlatlu iluqaitñik tamatkuniŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Taapkua aġnat Mary Magdalene, Joanna-lu, Mary-lu aakaŋa James-ŋum, suli atlat aġnat. Uqautiniġaich uqqiraqtit tamatkuniŋa atuumaruanik iḷuviġmi. ");
INSERT INTO eskNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aglaan maliġuaqtit isumaniqsut aġnat piiŋiḷiqinipḷugich. Taatnamik ukpiġiŋiññiġaich. ");
INSERT INTO eskNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aglaan Peter makitiqhuni aqpaliqsruġniqsuq iḷuviġmun; auġrukami tautuŋniġaa nimġutaa ukił̣haaġiksuaq kisian. Kiŋuniġmukhuni quviġusuutiginiġai tamatkua atuummiruat. ");
INSERT INTO eskNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Taavrumani uvlumi malġuk Jesus-ŋum maliġuaqtik nunaaqqiuramuŋniaġniqsuk atiliŋmun Emmaus-mik, uŋasiksilaaqaqtuaq tallimat malġuŋni mile-lanik Jerusalem-miñ. ");
INSERT INTO eskNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pisullaġmik uqaġniqsuk iluqaanik atuumaruamik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Uqqaaġiksitlugik Jesus pisuqasiġniġik; ");
INSERT INTO eskNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","tautukkaluaġniġaak aglaan iḷisaġiŋiññiġaak. ");
INSERT INTO eskNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus-ŋum nipliutiniġik, “Sumik uqaqpisik pisuktuałłaptikni?” Qichaqpaałłaŋniqsuk alianaqsipḷutik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iḷaqataan atilgum Cleopas-mik apiqsruġniġaa, “Kisivich naluvaluŋniqsutin Jerusalem-mi atuumapman tamanna ikpaksravak.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesus-ŋum apiqsruġniġik, “Sunik?” Kiuniġaak, “Tamatkuniŋa atuumaruanik Jesus Nazareth-miumun. Taamna aŋun sivuniksriqirauniqsuq saŋŋiqaqtuaq uqałiġmigun savaaġmigunlu sivuġaatni Agaayyutimlu iñuiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Qaukłiŋich agaayuliqsipta suli sivulliuqtipta sivunniġñiġaat kikiaktuutitquplugulu tuqqutautquplugulu. ");
INSERT INTO eskNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Niġiugaġigaluakkaqput ilaaŋunipḷugu tasuqsairuksrauplugu Israel-aaġmiunik. Marrumani uvluni piŋayuġigaat atuumapmanaglaan. ");
INSERT INTO eskNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iḷapta aġnat tupakkaatigut pitḷukługuunniiñ. Taapkua utlautiniqsut qauniuraami iḷuviġmun, ");
INSERT INTO eskNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","aglaan paqinġiññiġaat timaa. Utiqamiŋ nipliġñiqsut tautuŋnipḷutiŋ isaġullaŋnik uqautriruaŋnaŋnik Jesus iñuunipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Iḷavut utlautiniqsut iḷuviġmun paqitlugu taatnatupiaq aġnat uqałhatitun, aglaan qiñiŋitmiñiġaat Jesus.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tavrali Jesus-ŋum nipliutiniġik, “Qanutun isumaiḷaaqtigivisik! Qanutun sukaisigivisik ukpiqsrił̣iksrapsitñik supayaanik sivuniksriqirit uqautaitñik! ");
INSERT INTO eskNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Uqaġniġugaut Christ, Anniqsuqti akiqsruutauruaq nagliksaaqtuksraunipḷugu tamatkuniŋa isiġaluaqani kamanautmiñun.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesus-ŋum iḷitchuġipkaġniġik uqautigikkauruanik iŋmigun iluqaitñi Agaayyutim uqałhiñi, aullaġniipḷuni makpiġaaŋiñiñ Moses-ŋum suli aglaŋitñiñ iluqatiŋ sivuniksriqirit. ");
INSERT INTO eskNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Qallikamiŋ nunaaqqiuramun igliġviŋmiknun, Jesus pisuktuiñaġniqsuq qaaŋiiñaġniaqtuatun. ");
INSERT INTO eskNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aglaan nutqaqtinniġaak nipliqhutik, “Ittuallagiñ uvaptikni. Taaqsisiaqsigaatigut.” Malikługik nayuġniġik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jesus aquvinniqsuq niġiqasiġukługik. Tigusikami qaqqumik quyaniġaa Agaayyun. Avguqługu qaqquq qaiññiġaa iliŋiknun. ");
INSERT INTO eskNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Irratik aŋmaqmata iḷisaġiaqsiḷiġniġaak. Aglaan qiñiġnaiqsiġniqsuq iliŋikniñ. ");
INSERT INTO eskNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Uqaaqsiñiqsuk iŋmiknun, “Uunaaqsaaġaluaqpiñuk uummatiptikni uqaqatigipmatiguk tumitchaani suli kaŋiqsipkaqługu Agaayyutim uqałha uvaptiknun.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Maksrikhutik utiqtiġniqsuk Jerusalem-mun. Paqinniġaik qulit atautchich maliġuaqtit katimaqatiqaqtuat atlanik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tamatkua katimaruat niplianiqsut, “Atanġuruaq aŋitqiŋñiqsuq iḷumun! Sagviġñiqsuq Simon-mun.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Malġuk utiqtiqtuak uqautiniġaich atuumaruamik tumitchaani suli qanuq iliŋiknik iḷisaqsrił̣iġmiknik Ataniġmik avguipman qaqqumik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Malġuk uqaqtitlugik taavrumiŋa, tavrakŋatchiaq ataniq Jesus qichaaniktiġniqsuq akunġatni nipliutiplugich, “Tutqiutiqaġitchi!” ");
INSERT INTO eskNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tatamitchaŋniqsut atakkii tautukkasuŋniaqhutiŋ aliuqtumik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aglaan nipliutiniġai, “Suvaata tupaktiqpisi? Suvaata ukpiqsriŋitpisi? ");
INSERT INTO eskNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tautuksigich argatka isigatkalu. Uvaŋaupiaqtuŋa. Aksigḷuŋa iḷitchuġiniaqtusi. Atakkii aliuqtuq timiqaŋitchuq sauniqanġitḷuniḷu uvaptun.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Uqaqami taavrumiŋa qiñiqtitkai argaŋmiñik suli isigaŋmiñik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Maliġuaqtit ukpiġilguiññiġaatsuli aglaan quviġusukhutiŋ quviasullapiaqhutiŋlu. Jesus-ŋum apiqsruġniġai, “Uvani niqiksraqaqpisi?” ");
INSERT INTO eskNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aatchuġniġaat igaamik iqaluŋmik. ");
INSERT INTO eskNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tiguplugu niġiñiġaa sivuġaatni. ");
INSERT INTO eskNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tavra nipliutiniġai, “Tamatkua uqautigikkatka ilipsitñunimma nayuutiŋŋaġma ilipsitñi, suapayaaq atuumaniaġnipḷugu aglausimaruatun uvapkun maliġutaksraŋa Moses-ŋum suli aglaaŋitñi sivuniksriqirit suli Psalms-ni.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tavra aŋmaġniġai isummatiŋich kaŋiqsitquplugich uqałhanik Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nipliutiniġai, “Taamna aglausimaruaq, Christ, Anniqsuqti akiqsruutauruaq, nagliksaaqtuksrauruq tuquluniḷu aŋitqiksuksraupluni tuquŋaruaniñ piñayuatigun uvlut, ");
INSERT INTO eskNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","suli atqagun tusaayugaaġiksuaq quliaqtuakkaugisiruq isummitqił̣ikun suli natqiutikkaułikun killuqsautiniñ iñuŋnun nanipayaaq, aullaġniiḷugu Jerusalem-miñ. ");
INSERT INTO eskNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iḷisimaraugisirusi tamatkunuuna. ");
INSERT INTO eskNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tuyuġisigipsi Irrusiḷḷautamik Agaayyutim akiqsruutigikkaŋanik. Utaqqiruksraurusi nunaaqqimi saŋŋim pakmakŋa tikiññiałhanunaglaan ilipsitñun.” ");
INSERT INTO eskNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesus-ŋum annisiniġai nunaaqqimiñ Bethany-m tuŋaanun. Tavrani isakługich argaŋni piḷiutiksriññiġai maliġuaqtini. ");
INSERT INTO eskNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jesus agaayutillaisa aullautikkauniqsuq pakmuŋa. ");
INSERT INTO eskNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Maliġuaqtit agaayyuviginiġaat utiqhutiŋaasiiñ Jerusalem-mun quviasullapiaġataqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ataramik agaayyuvikpaŋmiinniqsut nanġaqługu quyaplugu Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aullaġniisaqqaaġatałiġmi ittuq Uqałiq, Uqałiq iqataupluni Agaayyutmi, suli Uqałiq Agaayyutaupluni. ");
INSERT INTO eskNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ilaa piqatauniqsuq Agaayyutmi aullaġniisaqqaaġatałiġmi. ");
INSERT INTO eskNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Taavrumuuna Uqałikun Agaayyutim iñiqtaġigai supayaat. Atausriuraqunniiñ iluqaaniñ iñiqtaġikkaŋaniñ iñiqtaunġitchuq ilaa piiḷḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uqałiq kaŋigigaa iñuułhum. Taavruma iñuułhum iñuich qaggutigai, kaŋiqsił̣iksraŋatnun Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Taamna qauma qaggutriruaq taaqtuamik, taaqtuam qamilguitchaa. ");
INSERT INTO eskNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Agaayyun kilgiruaksramik tuyuqaġniqsuq, iñuŋmik atiliŋmik John-mik, ");
INSERT INTO eskNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","taivrumuuna qaumakun iñuŋnik uqautrityaqtitlugu. Aggiġñiqsuq iluqaisa kilgutmik tusraatquplugich ukpiqsritquplugiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John ilaa taivrumiŋaunġitchaluaqhuni, aggiġñiqsuq taivrumiŋa qaumamik uqautrityaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Taimmataimña qauma iḷumun aggił̣iġmiñi nunam iñuiñun kaŋiqsipchaityaqtuaq iñupayaanik nunami. ");
INSERT INTO eskNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ilaa itman nunami, nuna iñiqtaupluni Ilaagun, naagasuli nunam iñuiñ iḷitchuġinġiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ilaa iḷamiñun tikitman, iḷaiñ akuqtunġitchaat. ");
INSERT INTO eskNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aglaan iḷaŋich ukpiqsripḷutiŋ akuqtuiruat ilaanik, ilaan qitunġaġiliutipkaġai Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tamatkua aniñġitchut timim qitunġiułhagun naagaqaa iñuum pisułhagun, aglaan anitqiŋñiqsut tuvraġlugu Agaayyutim pisułha. ");
INSERT INTO eskNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Taamna taggisiqaqtuaq Uqałiġmik iñuguqhuni akunnaptikni iñuuniaqtuq. Uvagut qiñiġikput kamanautaa inuqtuummataitchuaq iłuaqqutrił̣ikun suli iḷumutuułikun. Taamna kamanaun piḷiun Ilaan akuqtuaġigaa aapamiñiñ Iġñituaŋułiġmigun. ");
INSERT INTO eskNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John-ŋum taamna uqautiginiġaa. Itnautigiplugu, “Taamna uqautigikkaġa itnaqama, ‘Taimña aggiqsuaksraq aqupkun kamanatluktuq uvaŋniñ, takku anigaluaqnaŋa inŋaniksimaaqhuni.’” ");
INSERT INTO eskNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Inuqtuusrimaił̣iġmiñiñ nagliktaġmigun Ilaan piḷiutiqaġaatigut; iluqata ikayuġaatigut ikayutqigaaqhuta iłuaqqutmigun. ");
INSERT INTO eskNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Agaayyutim qaitchaa maliġutaksraq uumuuna Moses-kun, aglaan iłuaqqun suli iḷumutuułiq Jesus Christ-kun aggiqsuk. ");
INSERT INTO eskNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kia-unniiñ Agaayyun qiñinġaqsimaitchaa, kisimi Atautchim, taavruma atriŋuruam Agaayyutmi suli Aapam saniġaaniittuam, iḷitchuġipkautigigaa. ");
INSERT INTO eskNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jew-ŋuruat Jerusalem-miñ tuyuqaġniqmata agaayuliqsinik Levi-tkuayaaniglu apiqsruġiaqługu John kisuupmaŋaan, ");
INSERT INTO eskNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","itna kiggutiksraisuŋaqani uqautiniġai nalupqinaiqł̣ugu, “Uvaŋa Christ-ŋunġitchuŋa; Anniqsuqtiksrautaunġitchuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Kisuuvitmi? Elijah-ŋuvich?” John-ŋum kiuniġai, “Taavrumiŋaunġitchuŋa.” “Naaga taimña Moses-ŋum uqautigikkaŋa sivuniksriqirauvich?” John-ŋum piñiġai, “Taimñaunġitchuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nipliutilgiññiġaat, “Uqautitigutmi kisuutilaaqnik. Uvagut kiggutiqaqtuksraurugut tuyuġiriptiknun. Qanuqsamma nipliutigivich ilipkun?” ");
INSERT INTO eskNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John kiuniġai, “Uvaŋa taimñauruŋa uqaġimakkaŋa Isaiah-m sivuniksriqirim, itna, Iñuk tuqłuqtuaq iñuiḷaamiñ, Itqanaiyautisiuŋ apqutiksraŋa Atanġum, nalġuġlugu tumiksraŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Taapkua uqqiraqtit tuyuuruat Pharisee-ŋuruaniñ, John apiġilgiññiġaat, “Uvva, Christ-ŋunġiññiġuvich naagaqaa Elijah-ŋunġitchuvich, naagaqaa taimña sivuniksriqiraunġitchuvich, suvaata paptaaġivich?” ");
INSERT INTO eskNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John kiuniġai, “Uvaŋa paptaaġutiqaqtuŋa imikun. Aglaan akunnapsitñi qichaqtuq iḷitchuġimaisaqsi. ");
INSERT INTO eskNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ilaa aqupkun sagviġisiruq. Uvaŋa siŋiiḷguyumiñaitchuŋaunniiñ aluġutiŋnik.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tamatkua atuummiñiqsut Bethany-mi Perea-mi Jordan taavanitchiaŋani John-ŋum paptaaqtitchiviani. ");
INSERT INTO eskNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Uvlutqikman John-ŋum Jesus qiñiġniġaa utlautiruaq iŋmiñun, aasrii upyakługu, “Uvvauna Agaayyutim ipnaiyaaŋa piiġityaqtuaq nunam iñuiñ killuutaatnik! ");
INSERT INTO eskNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ilaa taimñauruq uqautigikkaġa itnautigiplugu, ‘Iñuk imma aggiġñiaqtuq akiaqtiksraġa. Kamanatluktuaq uvaŋniñ, takku ilaa anigaluaqnaŋa inŋaniksimaaqhuni.’ ");
INSERT INTO eskNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uvaŋa nalugaluaqługu kisuugisił̣ha, tikiumaruŋa paptaaġusriqł̣uŋa imiġmik iḷitchuġipkautigisrukługu Israel-aaġmiunun.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Uvva itnaiḷipḷugu John-ŋum iḷisimarriġaa, “Uvaŋa qiñiġiga Ipqitchuaq Irrusriq atqaqtuaq pakmakŋa atriqaqhuni tiŋmiaġruuratun aasrii ilaaniitluni. ");
INSERT INTO eskNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kaŋiqsianinġitchaluaġiga kisuutilaaŋa, aglaan Agaayyutim tuyuġirima imikun paptaaġityaqłuŋa, uqautigaaŋa itna, ‘Ilvich qiñiġisigiñ Ipqitchuaq Irrusriq atqaqpan aasrii inillaguni iñuŋmun, ilaa taimñaugisiruq paptaaġiruksraq Ipqitchuakun Irrutchikun.’ ");
INSERT INTO eskNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aasrii uvaŋa qiñianikkiga taamna atuumaruaq aasrii uqautigitlaplugu Iġñiġiłhagun Agaayyutmun.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Uvlutqikman John taraniilgiññiqsuq malġuŋnik maliġuaqtiŋmiñik piqasriqhuni. ");
INSERT INTO eskNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Qiñiqamiuŋ Jesus apqusraaqtuaq John-ŋum upyaŋniġaa, “Uvvauna Agaayyutim ipnaiyaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Taapkuak maliġuaqtik tusraaplugu taatnaqman, maliutiniġaak Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus-ŋum kiŋiaqami, maliutiniqmakni qiñiqługik apiġiniġik, “Sua pakikpitchu?” Taapkuak kiuniġaak, “Rabbi, nani tukkuqaqpich?” (Taamnaguuq Rabbi mumiutiqaqtuaq iḷisautrimik.) ");
INSERT INTO eskNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ilaan kiuniġik, “Uvuŋaġutik qiñiġiatku!” Taapkuak utlauti'amik qiñiġniġaak nani irviqaqtilaaŋa, aasrii uvlivigiplugu. Sisamanun tuqtuqtaq iḷiyuŋnaqsiruami sassaq unnuksraaqman. ");
INSERT INTO eskNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Taapkuak tusraaplutik John-ŋum uqautaanik maliutriruak Jesus-mik iḷaqataa atiqaġniqsuq Andrew-mik, Simon Peter-m aniqatigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew-m sivulliuplugu paqilġaaġniġaa aniqatni Simon uqautiplugu, “Uvaguk paqitkikpuk Messiah” (mumiutiqaqtuaq Christ-mik naagaqaa Anniqsuqtimik), ");
INSERT INTO eskNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","aasrii Simon Jesus-muutiplugu. Jesus-ŋum qiñiqługu nipliutiniġaa, “Ilvichuvva Simon, iġñiŋa John. Taiyuutinikkisirutin Cephas-mik” (mumiutiqaqtuamik Peter-mik Iyaġaŋmiglu). ");
INSERT INTO eskNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Uvlutqikman Jesus sivunniġñiqsuq Galilee-mugukhuni. Ilaan Philip paqitlugu nipliutiniġaa, “Maliġuaŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip-guuq Bethsaida-ġmiuŋuniqsuaqtuuq Andrew-mlu Peter-mlu irviakni. ");
INSERT INTO eskNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip-ŋumli nalautlugu Nathanael, uqautiniġaa “Uvagut paqitkikput taimña Moses-ŋum uqautigimakkaŋa maliġutaksrani suli sivuniksriqirit uqautigikkaŋat. Ilaa Jesus-ŋuniqsuq, Nazareth-miu, Joseph-ŋum iġñiŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael-ŋum piñiġaa, “Qanusriq nakuuruaq aggitḷava Nazareth-miñ?” Philip kiugaa, “Kiataamiḷi qiñiġiaqsaġuŋ!” ");
INSERT INTO eskNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus-ŋum qiñiqamiuŋ Nathanael utlautiruaq iŋmiñun nipliġñiqsuq, “Uvvauna Israel-aaġmiupiaġataq! Ilaani piitchuq pigiiḷaq.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael-ŋum apiqsruġniġaa, “Qanuqługu iḷisimaviŋa?” Jesus-ŋum kiugaa, “Philip-mun tuqłuġaluaqtitnak qiñianiŋniġikpiñ ataŋiusrima'avich asrirriraġaqtuami napaaqtumi.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael-ŋum kiugaa, “Iḷisautrii! Ilvich Agaayyutim Iġñiġiniġaatin! Israel-aaġmiut umialiginiġaatin!” ");
INSERT INTO eskNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus-ŋum kiugaa, “Ilvich ukpiliqsiqpich qiñiġni'apkiñ sivuani ataani napaaqtum asrirriraġaqtuam? Qiñiġisirutin kamanatluktuanik taavrumakŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesus-ŋum nipliutipsaaġniġai, “Iḷumutuuruamik nipliutigipsi, Ilipsi qiñiġisigiksi qiḷak aŋmaqpan suli Agaayyutim israġulgi mayutmuktuat naagaqaa atqaqtuat Iñuum Iġñiŋanun.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Uvluk piñayuakun katchuutniaqtuak inniqsuk Cana-mi nunaaqqimi Galilee-mi ittuami. Jesus-ŋum aakaŋa itmiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Suli Jesus-lu maliġuaqtiniḷu aiyugaaqtaupmiñiqsut katchuutniaqtuaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Misruġuutaat nuŋupman, Jesus-ŋum aakaŋan nipliutiniġaa, “Ukua misruġuutaiqsut.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus-ŋum kiuniġaa, “Tiliuqtaksraġinġitchikma sutquluŋa. Piviksraġasuli tikiumaitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesus-ŋum aakaŋan uqautiniġai savaktit, “Piyumigiksi qanupayaaq tilikpasri.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Taraniguuq itchaksrat qattaliat iyaġaich imiġnun inniqsut, atausriq immaqtutilaaqallaapluni iñuiññaqtun naagaqaa iñuiññaq qulit gallon-tun, Jew-ŋuruat maliġutaksrirrusriaġikkaġmikkun iġġuutiksraqtuġvikaaŋich. ");
INSERT INTO eskNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus-ŋum uqautiniġai, “Immiqsigik qattat imiġmik.” Tarra immiġñiġaich qaqłukpiuraqługich. ");
INSERT INTO eskNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tarakŋaasrii Jesus-ŋum nipliutigai, “Tarakŋa qalusriḷusri, niġiqpaktuat aŋalataat payuksiuŋ!” Taapkua payuŋniġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aŋalataata niġiqpaktuat uukamiuŋ imiq misruġuġuqtitaq naluniġaa nakitñaqtautilaaŋa tamarruma misruqqum, aglaan taapkua savaktit qalusriruat imiġmik iḷisimaniġaat. Taavruma aŋalataata niġiqpaktuat tuqłuġniġaa uiksraun, ");
INSERT INTO eskNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nipliutiplugu, “Atlat autaaqtitchiraqtut misruġuġiŋñiksramik sivulliuplugu, aasrii aiyugaaktat imianikmata, akiitḷuŋniqsramik piqaqtitkaqsipḷugich. Aglaan ilvich itinniġiñ misruġuġiŋñiqsraq isruanunaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sivulliqpiaŋuplugu taamna quviqnaqtuaq savaaq Jesus-ŋum iñiqtaġiniġaa Cana-mi Galilee-miittuami. Ilaan kamanautni qiñiqtinniġaa. Aasrii maliġuaqtaiñ ukpiġiliutipsaagniġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tamarruma aquagun Jesus aakaniḷu nukatchiaŋiḷu suli maliġuaqtiŋi Capernaum-muŋniqsut, taraniasriiñ itlutiŋ ikituurani uvluni. ");
INSERT INTO eskNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jew-ŋuruat niġiqpagvikaaŋat atilik Apqusaakkaułiġmik tikiyasriruq, aasriiñ Jesus Jerusalem-mun aullaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Agaayyuvikpaŋmi pakinniġaa iñuich tunniuqqairuat aŋusalluŋnik ipnaiñiglu tiŋmiaġruuraniglu suli simmiqsuqtit maniŋñik aquppiruat manniqiviŋmikni. ");
INSERT INTO eskNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aasriiñ akłunaamik, ipiġaqtuusriqhuni uumaruapayaat aninniġai Jew-ŋuruat agaayyuvikpaŋatniñ, manniqiviŋich simmiqsuirit maniŋñik ulġutlugich, simmiqsuutiŋich siamitlugich. ");
INSERT INTO eskNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Suli tilipḷugich tunisiullaqtuat tiŋmiaġruuranik itnaqhuni, “Tamatkua uvakŋa anitchigik! Aapaa tupqa tunisiuqqaiviguqnagu!” ");
INSERT INTO eskNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Maliġuaqtaiñ itqaġniġaat uqałiq aglausimaruaq itna, “Agaayyuun! Siqñigillapiałiġma tupiġikkapnik iluqnauqsimaaqtitkaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jew-ŋuruat nipliutitqiŋñiġaat apiqsruutmik, “Sumik quviqnaqtuamik iñiqtaqaġutin qiñiqtinnayaqpiuŋ uvaptiknun nalaułhiñ taatnasriġaqavich?” ");
INSERT INTO eskNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus-ŋum kiugai, “Unauvva agaayyuvikpak piiyaġupsiuŋ, piñasruni uvluni nappatqikkisigiga.” ");
INSERT INTO eskNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jew-ŋuruat apiqsruġniġaat, “Piñasruni uvluni nappatqikkisiviuŋ? Malġukipiaq itchaksrani ukiuni nappaġniakkauruq agaayyuvikpak una!” ");
INSERT INTO eskNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aglaan Jesus uqautigikkaŋa agaayyuvikpak atriŋuniqsuq ilaan timaanun. ");
INSERT INTO eskNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Taamani tuqułiġmiñ aŋitqikman, maliġuaqtaiñ itqaġniġaat taatna uqałha, arguaqqutaitḷugich aglausimaruat uqałhich, suli Jesus uqautigikkaŋi. ");
INSERT INTO eskNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesus Jerusalem-mi ititlugu niġiqpagvikaami taggisiqaqtuami Apqusraaqtitaułiġmik iñugiaktuat ukpiġiniġaat qiñiqamisigik quviqnaqtuat savaaŋi. ");
INSERT INTO eskNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aglaan Jesus-ŋum iḷumutuuginġiññiġai, atakkii ilaan iñuich iḷisimmaaġikł̣ugich. ");
INSERT INTO eskNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iñuktigun kaŋiqsipkaġniaġnaqhuni inġiññiqsuq, ilaan kaŋiqsimmaaġikł̣ugich iñuich isrummatiŋich. ");
INSERT INTO eskNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uvvaasriiñ inniqsuq iñuk atiqaqtuaq Nicodemus-mik, Jew-ŋuruat sivulliuqtaiñ iḷaŋat, piqataupluni taapkunani Pharisee-ŋuruani. ");
INSERT INTO eskNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Unnuat iḷaŋatni utlautiniqsuq Jesus-mun nipliqhuni, “Iḷisautrii! Iḷitchuġigikput ilvich iḷisautriksrauplutin tuyuułhiñ Agaayyutmiñ. Kia-unniiñ piyumiñaitchai quviqnaqtuat savaat kisianik Agaayyutim piqasriumalugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus-ŋum kiugaa, “Iḷumutuuruamik uqautigikpiñ, iñuum anitqiñġisuaġuni, Agaayyutim aŋaayuqautaa qiñitlasriyumiñaitchaa.” ");
INSERT INTO eskNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus-ŋum apiqsrulgiññiġaa, “Qanuġuni iñuguaniktuaq anitqikkisiva? Nalupqinaitchuq, aakami iḷuanun isitqiaqsiyumiñaitchuq, anił̣ł̣i tugliḷgitḷasriḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus-ŋum kiugaa, “Iḷumutuullapiaqtuamik nipliutigikpiñ, Iñuk anitqiñġisuaġuni imikun suli Ipqitchuakun Irrutchikun isitlasriyumiñaitchuq Agaayyutim aŋaayuqautaanun. ");
INSERT INTO eskNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tamatkua aniruat iñuŋniñ iñugruiñaurut. Tamatkualiasrii kisiisa Ipqitchuam Irrutchim anitqiksitaŋi iñuugisirut Ipqitchuakun Irrutchikun. ");
INSERT INTO eskNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Quviġusruutiginagu nipliutiga, ‘Anitqiksuksraupiaqtusri’. ");
INSERT INTO eskNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Anuġi igliġaqtuq napmupayaaġukami, ilipsiasriiñ tusraaplugu anuġim siiġruŋniŋa, aglaan iḷisimatlaitchiksi nakiñ aggił̣ha unniiñ napmułha. Taatnatun kiñapayaaq ittuq animaaqtuaq Ipqitchuakun Irrutchikun.” ");
INSERT INTO eskNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus-ŋum apiqsruġniġaa, “Qanuġuni taatniitlagisiva?” ");
INSERT INTO eskNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus-ŋum kiugaa, “Ilvich iḷisautraugaluaqhutin Israel-mi taamna naluniqpiuŋ? ");
INSERT INTO eskNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iḷumutuullapiaqtuamik nipliutigikpiñ, Uvagut uqaġaqtugut iḷisimakkaptiknik suli iḷisautriraqtugut qiñikkaptiknik. Aglaan nallipsi uqałiqput akuqtuġummataitchaa. ");
INSERT INTO eskNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ilipsi ukpiġinġitchipsitña uqautikapsi nunakŋaqtatigun; qanuġusri ukpiġitlasrigisivisitña uqautigupsi pakmakŋaqtatigun? ");
INSERT INTO eskNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kiñaunniiñ pakmuŋa mayuqsimaitchuq, aglaan Iñuum Iġñiŋa atqaqtuaq tatpakmakŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses kivikmatun nimiġiaŋŋuaq nappaqutamun suviksraiḷaami, taatnatun Iñuum Iġñiŋa kiviktaksraugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kisupayaaq ukpiqsripḷuni turviñiktuaq ilaanik isruitchuamik iñuugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Agaayyutim nunam iñui piqpagivagitḷugich, Iġñitualuni aatchuutiginiġaa. Kisupayaaq ukpiqsrił̣ikun turviñiktuaq ilaanik tuquyumiñaitchuq, aglaan isruitchuamik iñuugisiruq. ");
INSERT INTO eskNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Atakkii Agaayyutim Iġñiñi tuyuġinġitchaa atanniqsuqtautquplugu nunam iñuiñun aglaan anniqsuqtautquplugu iluqaitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kisupayaaq ukpiqsripḷuni tunŋaviñiktuaq Iġñiŋanik, atanniusriaksraitchuq. Aglaan ukpiqsriñġitchuaq atanniqsimaaŋaniktuq, takku ukpiqsrił̣ikun tunŋaviñiksimaitḷuni Agaayyutim Iġñituaġikkaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Taatnaiḷipḷugu taamna atanniusriaksraq ittuq, qauma nunam iñuiñun tikitman. Aglaan iñuich piqpagitlukkaat taaqtuaq taavrumakŋa qaumamiñ, takku iliŋich irrusriñiksimaaqhutiŋ pigiitchuamik. ");
INSERT INTO eskNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kisupayaam irrusriñiksimaaqtuam pigiitchuakun qauma uumigigaa, suli utlautisrutlaitchuq qaumamun, takku ilaan irrusriġiliutikkani pigiitchuaq sagviqunġitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aglaan kisupayaaq irrusriñikkami iḷumutuuruamik qaumamun utlautiraqtuq, taavrumuŋa qaumamun sagviumatquplugu irrusriġiliutikkani tupiksrił̣ikun Agaayyutmik.” ");
INSERT INTO eskNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Taavruma aquagun Jesus-lu maliġuaqtiniḷu aullaġniqsut nunaŋanun Judea-m. Tarani ittuallaŋniqsuq iliŋitñi suli paptaaġipluni. ");
INSERT INTO eskNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John-tuuq paptaaġiniqsuq Aenon-mi uŋasriñġitchuamiñ Salem-miñ, takku imġukkaqhuni tamanna. Iñuich utlaaġaqługu ilaan paptaaqtaġniġai. ");
INSERT INTO eskNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","John taamna isiqsimaitchuqsuli isiqsiviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John-ŋum maliġuaqtaiñ iḷaŋich uqaksraqtuaqsiñiqsut Jew-ŋuruatlu taavrumuuna ipqiqsakkaułikun. ");
INSERT INTO eskNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aasriiñ John-mun utlautiplutiŋ uqautiplugu, “Iḷisautrii! Aŋun itqaġiviuŋ Jordan-ŋum igḷuani piqatigikkan, ilvich uqautigikkan? Ilaa paptaaġiaqsiruq, aasrii iñuum iluqani utlakkaa!” ");
INSERT INTO eskNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John-ŋum kiuniġai, “Kiñaunniiñ sumik piqaġumiñaitchuq, Agaayyutmun qaitchiñġunnani. ");
INSERT INTO eskNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ilipsi iḷisimarigigipsi nipliqsimałłapkun ‘Uvaŋa Christ-ŋunġitchuŋa, aglaan ilaan sivuani tuyuumaruŋa,’ itqanaiyautityaqtitlugu. ");
INSERT INTO eskNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nukatpiaq katchuutniaqtuaq niviaqsiam uiksrautigigaa. Nukatpiam iḷauraaŋa qichaqatauraqtuq naalaġnipḷugu, quviagiplugu tusraałha nukatpiam katchuutniaqtuam nipaa. Taatnatun quviasrułiġa naammatigiruq. ");
INSERT INTO eskNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ilaa piġuqtuksrauruq kamanaqsitḷuguni, uvaŋaasrii nuimaiġḷuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ilaa aggiqsuaq pakmakŋa iluqaitñiñ kamanatluktuq. Nunakŋaqtaġli iñułhiñaupluni nunamiittuaŋuruq, nunakŋaqtanik nipiqaqhuni. Ilaa aggiqsuaq qiḷaŋmiñ kamanatluktuq iluqaitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aasrii uqautigigaa qiñikkani tusraakkaniḷu, aglaan kisupayaat uqałha akuqtunġitchaat. ");
INSERT INTO eskNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kia akuqtuiruam uqałhanik nalupqiginġiġaa Agaayyutim iḷumutuułha. ");
INSERT INTO eskNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Taavruma Agaayyutim tuyuġikkaŋan Agaayyutim uqałhi uqaġigai, takku Agaayyutim qaitchipḷugu inuŋaiqł̣ugu Ipqitchuamik Irrutchiġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aapam Iġñiñi piqpagiplugu aasrii supayaat aatchuutigigai ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ilaa ukpiqsriruaq Iġñiġmik isruitchuamik iñuułiqaqtuq, aasrii tupiksriñġitchuaq Iġñiġmik iñuułiqaġumiñaitchuq. Aglaan Agaayyutim qinnautaa nayuutigisiruq ilaani qaŋavak taimuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisee-ŋuruat tusraaniqsut Jesus iñunnatluaqsiñipḷugu paptaaġitlukhuniḷu John-miñ ");
INSERT INTO eskNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesus ilaa paptaaġinġitchaluaqtitlugu, aglaan maliġuaqtai). ");
INSERT INTO eskNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesus-ŋum tusraa'amiuŋ uqaġikkaŋat, Judea-miñ aullaġniqsuq Galilee-mun utiqhuni. ");
INSERT INTO eskNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Utiłiġmiñi taavrumani Samaria-kuaqtuksrauniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tikiññiqsuq Samaria-m nunaaqqiŋanun atiqaqtuamun Sychar uŋasriñġiññiqsuamun nunaŋaniñ Jacob-ŋum qaisaŋaniñ iġñiġmiñun Joseph-mun. ");
INSERT INTO eskNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob-ŋum nivviaŋa taraniinniqsuaq. Aasrii Jesus igluałiġmikniñ iñiqtuqhuni, nivviam saniġaanun aquvinniqsuq, uvluq qitiqquqman. ");
INSERT INTO eskNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria-ġmiu aġnaq aggiġñiqsuq imiqtaġiaqhuni. Aasrii Jesus-ŋum nipliutiniġaa, “Imiksriŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Immali maliġuaqtai nunaaqqimuŋniqsut niqiksramiknik tauqsiġiaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aġnam Samaria-ġmium nipliutiniġaa, “Ilvich Jew-ŋurutin aasrii Samaria-ġmiuŋupluŋa. Qanuqhutin iŋiqpiña imiġukhutin?” (Uvvatakku Jew-ŋuruat piqatiqatlaitchut Samaria-ġmiunik.) ");
INSERT INTO eskNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus-ŋum kiugaa, “Iḷisimagupku Agaayyutim aatchuutiksraŋa suli kisuułha iŋiqtigikkaqpich imiksritqupluni iŋiġayaġiñ, aasrii Ilaan qaitchiḷutin iñuunaqtuamik imiġmik.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aġnam nipliutigaa, “Ilvich qattaitmiutin, aasrii nivviaq itipmiuq. Nakiñmi imiq iñuunaqtuaq piñayaqpiuŋ? ");
INSERT INTO eskNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacob-ŋum sivulliapta uumiŋa nivviamik piqaqtitaŋatigut, qitunġaiñḷu suli pamiqsaaŋisa imiġvigimakkaŋatnik. Ilvich Jacob-miñ kamanatluktuaŋunasrugivich?” ");
INSERT INTO eskNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus-ŋum kiugaa, “Kiñapayaaq imiqtuaq imiġmiñ uumakŋa imiġulitqikkisiruq. ");
INSERT INTO eskNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aglaan kiñapayaaq imiġmiñ aatchuutiksramniñ imiġumi imiġulitqiŋñianġitchuq, takku imiq aatchuutiksraġa itkisiruq ilaani suvliktuatun nivviatun imiġmik iñuunaqtuamik, piqaqtillugu ittuksramik isruiḷaamun iñuułiġmun.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aġnam nipliutigaa, “Taavrumiŋa imiġmik qaitchiŋŋa, imiġulitqiñġitchumuuŋali unniiñ uvuŋa imiqtatqiñġitchumuuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tarra Jesus-ŋum nipliutiniġaa, “Aullaġutin uqautityaġuŋ iḷaqatin pakma nayuqtigikkan, aasriiñ uvuŋatqigutik.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aġnam kiuniġaa, “Iḷaqataitchuŋa.” Jesus-ŋum kiugaa, “Ilvich nalauttutin nipliqavich iḷaqataiññipḷutin. ");
INSERT INTO eskNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ilvich iḷaqatniktuqsimaruami tallimani, aasrii nayuqtigikkan pakma nalaullugu iḷaqatiginġitchiñ katchuusrimaitchiñ. Taatnaqavich nalauttutin.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aġnam nipliutigaa, “Taatnaiḷipḷugu iḷisimmatiqaġniqavich kaŋiqsigiga sivuniksriqiraułhiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Samaria-ġmiut sivulliavut agaayumaaġuurut uumani iñġimi aasriiḷi ilipsi Jew-ŋuruani uqaġaqtusri iñuich agaayumaaqtuksraunipḷugich Jerusalem-mi.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus-ŋum nipliutiniġaa “Aġnaaq, ukpiġiŋŋa, Piviksraq tikitkisiruq iñuich agaayyuvigitlaiġñiaqmatruŋ Aapa uumaniunniiñ iñġimi naagaunniiñ Jerusalem-mi. ");
INSERT INTO eskNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria-ġmiusri iḷisimanġipiaġiksi kisumun agaayumaałiqsi; uvagut aglaan Jew-ŋuruani iḷisimagikput kisumun agaayumaałiqput, takku iñuich anniqsuqtiksraŋat Jew-ŋuruaniñ kaŋiqaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aglaan piviksraq tikisaaqtuq, pakmaunniiñ tikiumaaniktuq, iḷumun putqataġviqaqtuat agaayumaaġviginiaqmatruŋ Aapa Ipqitchuakun Irrutchikunlu iḷumutuułikunlu. Takku Aapauruaq piqaġuktuq iñuich agaayumaaġviginiaqtuanik iŋmiñun taatnaiḷiḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Agaayyun Irrusriuruq. Tamatkua putqataġviqaqtuat ilaanik agaayumaaqtuksraupiaqtut Ipqitchuakun Irrutchikunlu iḷumutuułikunlu.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aġnam nipliutiniġaa, “Uvaŋa kaŋiqsimagiga Messiah taiyuutilik Christ-mik aggiqsaġumaruaq. Ilaan aggiġumi uqautisraġumakkaŋatigut supayaamik.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus-ŋum nipliutigaa, “Uvaŋa uqaqatin Ilaaŋuruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Taatnaanigmiuglu tarani Jesus-ŋum maliġuaqtai utiġniqsut. Atqunaq quviġutchaŋniqsut Jesus aġnamik uqaqatiqaġniqman. Aglaanguuq nalliata nipliutinġiññiġaa aġnaq, “Sumik pisukpich?” naagaqaa apiqsrunġiññiġaat Jesus, “Suvaata aġnamik uqaqatiqaqpich?” ");
INSERT INTO eskNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tarakŋa aġnam imiqtautni unitḷugu, nunaaqqimun utiġniqsuq, uqaaqsipḷuniasriiñ iñuŋnun, ");
INSERT INTO eskNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Maligluŋa qiñiġiaqsiuŋ iñuk uqautriga suraġałipayaamnik. Ilaa Christ-ŋunġitchaluaqpa?” ");
INSERT INTO eskNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tamatkua uniññiġaat nunaaqqiq utlautiplutiŋ Jesus-mun. ");
INSERT INTO eskNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Taatnałhatniguuq, maliġuaqtaiñ Jesus uqapsaaġniġaat, “Iḷisautrii, niġġiiñ!” ");
INSERT INTO eskNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ilaan kiuniġai, “Niqautiqaqtuŋa iḷisimanġisapsitñik.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Taatnaqman maliġuaqtai avatmun apiqsruqtautiaqsiñiqsut, “Iñuum una payunġitchaluaġniqpauŋ niqiksramik?” ");
INSERT INTO eskNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus-ŋum nipliutiniġai, “Niqautiqaqtuŋa tupiksriḷiġmik tuyuġirima pitqutaanik suli itqanaił̣iksraŋanik savaam qaisaŋan iñiqtaġitquplugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Uqaġaqtusri, itnaiḷipḷugu nautchiiviksigun, ‘Sisamani tatqiñi ittaqtuq katitchiviksraq.’ Uvaŋali nipliutigipsi, qiñiqtuallautaqsigik nauruat pakma piŋŋuqtuat katitaułhiñaaġuqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iñuk kipripḷuni katitchiruaq akiññagaqtuq katitchił̣iġmiñi nauruanik isruitchuamun iñuułiġmun, atunim aasrii nautchiiruaġlu kipriruaġlu quviasruqatigiikkisipḷutik. ");
INSERT INTO eskNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Uqautauruaq iḷumutuuruq itna, ‘Iñuk nautchiiraqtuq atlam aasrii kipiplugu, katitlugu mukkaaksraq.’ ");
INSERT INTO eskNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Uvaŋa tuyuġipsi kipriḷusri katitchitquplusri nautchiiviŋmi savaaqaġvigimaisapsitñi atlat savaaŋatni aasrii piññagusri taipchua savaaŋatniñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria-ġmiut iñugiaktuat nunaaqqimikni ukpiqsriñiqsut Jesus-mik aġnam itnałhagun, “Ilaan uqautigaaŋa supayaamik atuqsimakkamnik.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Taatnaqługu Samaria-ġmiut tikitñamitruŋ, ittuallaquaqsiñiġaat iŋmikni. Jesus-ŋumaasriiñ malġuŋni uvluŋni nayuġniġai. ");
INSERT INTO eskNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iñugiaksiḷaaġniqsut ukpiqsriruat ilaan uqauttutaigun. ");
INSERT INTO eskNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aasrii aġnaq uqautiniġaat, “Ukpiqsriḷiqsugut ilvich nipiłhiñaġinġisapkun aglaan uvaptiknik tusraaplugu, iḷitchuġigikput iḷumutun anniqsuqtiksraułha nunam iñuiñik.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kiñuagun malġuk uvluk Jesus aullaġniqsuq Galilee-mun. ");
INSERT INTO eskNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ilaan iḷisimagaluaqługu, “Sivuniksriqiri kamakkusriaqatlaitchuq iŋmi nunamiñi,” aullaġviginiġaa. ");
INSERT INTO eskNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilee-mun tikitman iñuich paġlaniġaat, qiñianikługu supayaaq savaaġikkaŋa niġiqpagvikaami taggisiqaqtuami Apqusaakkaułiġmik, takku iliŋittuuq utlautiniqsut niġiqpagvikaamun Jerusalem-mi. ");
INSERT INTO eskNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Taatnaqhuni Jesus utitqiŋñiqsuq Cana-mun Galilee-mi ittuamun, sivuani imiġmik misruġuġuqtitchiviŋmiñun. Aasrii Capernaum-mi inniqsuq aŋalatchiri iġñiqaġniqsuaq atniġñaqtuamik. ");
INSERT INTO eskNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tusraa'amiuŋ Jesus tikitḷugu Galilee-mun Judea-miñ, utlakługu apiqsruġniġaa Capernaum-muglugu iłuaqsipkaġayaitmaŋaan iġñi tuqułhiñaaġuqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus-ŋum nipliutiniġaa, “Nalliqsiunniiñ tarra ukpiqsriyumiñaipiaqtuq, qiñiġaluaqani kamanaqtuaniglu savaanik quviqnaqtuaniglu.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aŋalatchirim kiulgiññiġaa, “Maliŋŋa, qitunġauraġa tuqugaluaqtitnagu!” ");
INSERT INTO eskNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus nipliutigaa, “Aullaġiñ, iġñiġiñ iñuugisiruq!” Taavruma iñuum Jesus-ŋum nipliutaa ukpiġiplugu aullaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aŋiḷaatmuktitlugu savaktaiñ paaġniġaat tusraapkaġiaqługu “Iġñiġiñ iñuugaqsiruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Apiqsruġniġai qaŋaaglaan iġñi iłuaqsitmuaqsipmaŋaan. Taapkua kiuniġaat, “Ikpaksraq uvluqpaguġniġmiñiñ atautchimun iḷiyuŋnaqsipman uunaqłuutaiqsuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aapauruam iḷitchuġiniġaa atuummił̣ha taivrumani sassaġniġmi Jesus-ŋum nipliutikmani, “Iġñiġiñ iñuugisiruq,” Taatnaqhuni ukpiliġñiqsuq, suli iluqaġmiŋ tupiqatipayaaŋiḷu. ");
INSERT INTO eskNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Taavruma tugliḷiġniġaa quviqnaqtuaq savaaŋa Jesus-ŋum Galilee-mukman Judea-miñ. ");
INSERT INTO eskNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aquagun tamarruma Jew-ŋuruat niġiqpagvikaaŋat ilgiññiqsuq. Aasrii Jesus-tuuq utlautipluni Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Taamani Jerusalem-mi Ipnaich Paaŋatni narvauraqaġniqsuq tallimanik quliġutilik. Hebrew-tguuq uqaŋatigun taiyuutiqaġniqsuq Bethzatha-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Iñugiallapiaqhutiŋ iñuich atniġñaqtuat nalaniqsut tamatkunani quliġutit atiŋitñi qiñitlaitchuat, pisrutlaitchuat, suli auliyatlaiḷat taqqipḷutiŋ imġum iḷiqsraqtiłiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Uvvaguuqtakku qakugulitchiaqługu Agaayyutim israġulgan imiq iḷiqsraqtitaġniqmagu aasrii sivulliq atniġñaqtuaniñ kiñiḷġaaqtuaq aŋalataupkaqqaaqługu imiq mamitauraġniqsuq qanusripayaamik atniġñautiqaġaluaŋŋaġmi. ");
INSERT INTO eskNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iñugguuq atniġñaqtuaq iñuiññaq akimiaq piñasruni ukiuni tarani itmiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus-ŋum qiñiġniġaa nalaruaq suli kaŋiqsipḷugu ilaan atniġñałha takiruami, aasrii nipliutiniġaa, “Iłuaqsisukkaluaqpich?” ");
INSERT INTO eskNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Atniġñaqtuam kiuniġaa, “Uvaŋa kiñisaitchaqtuŋa imiq iḷiqsraqtitaupman. Takanuŋaġniaqtitluŋa atlam sivulliugaġigaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus-ŋum nipliutigaa, “Makillutin, ikivġatin tigulugich pisrugiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Taimmaiñaq taamna mamitauniqsuq; ikivġani tiguplugich, pisruŋniqsuq. Uvluq tamanna taavruma atuummivia Jew-ŋuruat minġuiqsiaġviginiġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Taatnaqługu Jew-ŋuruat nipliatiaqsiñiġaat iñuk iłuaqsikkauruaq, “Ugluvak minġuiqsiaġviuruq. Atuqtaksraptiknun akitñautiniqsutin ikivġapnik akiyaqavich.” ");
INSERT INTO eskNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ilaan kiuniġai, “Taivruma iłuaqsipkaqtima uqautigaaŋa, ‘Ikivġatin tigulugich pisrugiñ.’” ");
INSERT INTO eskNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Taapkua apiqsruġniġaat, “Kia taatnaquvatin?” ");
INSERT INTO eskNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aglaan taavruma iłuaqsikkauruam iḷitchuġinġiññiġaa kisuutilaaŋa, atakkii Jesus tamaakŋa piiġñiqsuq iñugiakpagitḷuni tamanna. ");
INSERT INTO eskNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aquagun taavruma Jesus-ŋum paqinniġaa Jew-ŋuruat agaayyuvikpaŋatni aasriiñ nipliutiplugu, “Ataŋii. Pakma iłuaqsirutin. Killuqsatqiŋñiaqnak. Takku killuqsaġuvich pigiitḷuktuaq tikitpiaqtuq ilipnun.” ");
INSERT INTO eskNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Taavruma iñuum aullaqami Jew-ŋuruat uqautiaqsiñiġai Jesus-ŋunipḷugu iłuaqsipkaqtini. ");
INSERT INTO eskNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Taavrumiŋa piqusriqhutiŋ Jew-ŋuruat piyuagaqsiñiġaat Jesus, ilaa iłuaqsiiñipḷugu minġuiqsiaġvium uvluani. ");
INSERT INTO eskNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus kiuniġai, “Aapaga savaktuq ataramik iñiqługu, suli uvaŋaptuuq savaktuksraupmiuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Taavruma nipliutim Jew-ŋuruat sivunniqsillapiaġniġai tuqqutchukługu, taavrumuunałhiñaunġitchuaq minġuiqsiaġvium atuqtaqsraigun aglaan niplił̣hagunlu Agaayyutmik aapaqaġnipḷuni suli atriḷiutipluni iŋmiñik Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus kiugai, “Uqautigipsi iḷumutuuruamik itna, Iġñiq iñiqtaqatlaitchuq iŋmigułhiñaq. Ilaa savaaqaġaqtuq taavrumiŋa qiñikkaġmiñik Aapani savaaqaqman. Supayaamik Aapauruaq iñiqtaqaqman, Iġñiŋantuuq savaaġiraġigaa. ");
INSERT INTO eskNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aapam Iġñi urriqsuutiraġigaa iluqaanik savaaġitlakkaġmiñik, atakkii piqpagiplugu. Ilaan iḷisautigisipḷugu kamanatluktuanikunniiñ tamatkunakŋa iñiqtaġikkaŋiñiñ, ilipsi quviġusrullapiatlasriḷusri. ");
INSERT INTO eskNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Atripḷugu Aapaa aŋipchairaġiłha tuquruanik iñugutqił̣iġmun, taatnatullapiaq Iġñiŋa qaitchitḷaruq iñuułiġmik tamatkunuŋa pisukkaġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aapaŋa iŋmiñik atanniqsunġiqhuni, aglaan Iġñi qaitchianiŋniġaa atanniił̣iġmik. ");
INSERT INTO eskNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Taatnaqhuni iluqani kamakkun itkisiruq Iġñiŋanun atriḷugu iñuich kamaqsrił̣hat Aapaŋanik. Kiñapayaaq kamakkutaitchumi Iġñiŋanun kamakkutaitmiuq Aapaŋanun tuyuġiraanun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Iḷumutuullapiaqtuamik uqautigipsi, Kiñapayaaq tusraaruaq uqautimnik suli ukpiqsriruaq tuyuġirimnik piññaktaqtuq isruitchuamik iñuułiġmik. Taamna atanniqsiuyumiñaitchuq, aglaan pituġaaniktuq tuquŋałiġmiñ iñuułiġmun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Uqautigipsi iḷumutuullapiaqtuamik, Piviksraq tikiññiaqtuq, ami tikiumaaniktuq tuquŋaruat tusraałiksraŋat nipaanik Iġñiŋan Agaayyutim, aasrii tamatkua tusraaruat iñuuniaqtut. ");
INSERT INTO eskNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Atripḷugu Aapauruaq Ilaa kaŋiuruaq iñuułiġmi, taatnatun Aapauruam inillakkaa Iġñiġikkani kaŋiutlasripḷugu iñuułiġmi. ");
INSERT INTO eskNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Suli qaitchaa Iġñi nalaullugu aŋalatchił̣iksramik atanniqsuił̣iġmik, atakkii Ilaa Iñuum Iġñiġiplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Taamna quviġusruutiginagu, piviksraq tikiññiaqtuq tuquruat iluqatiŋ iḷuviġni tusraagisił̣hat nipaanik. ");
INSERT INTO eskNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aasrii iliŋich aŋitqigḷutiŋ iḷuviġniñ, tamatkua savaaġiksuat aŋiḷutiŋ iñuułiġmun suli tamatkua savaaġiitchuat aŋiḷutiŋ sivuuġanaqtuamun atanniqsiuviksraġmiknun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Sumik savaaqaġumiñaitchuŋa uvapkuiñaq. Uqausriusriaġa tuvraqługu Agaayyutmiñ atanniiraqtuŋa. Taatnaqhutiŋ atanniutitka nalaunŋarut, takku pisułłapkun itinġitḷugu, aglaan tuyuġirima pisułhagun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Uvapkuiñaq uqaqsaġniaġuma, iñuich ukpiġiyumiñaitchaat iḷumutuuniḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aglaan ittuq uqautigiriga, uqaqtuaq iḷumutun uvapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ilipsi tuyuqaqapsi iñuŋnik kaŋiqsiuqtuksranik John-mun Paptaaqtitchirimun, ilaan uqautigaasri taavrumuuna iḷumutuuruamik. ");
INSERT INTO eskNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iñuŋmik iḷisimariqaġnanġitchaluaqłuŋa, aglaan taamna nipliutigigiga ilipsi anniqsuquplusri. ");
INSERT INTO eskNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John atriqaqtuaq nannimik ikimaruamik qaummaġiksipḷugu, ilipsipsuuq sivikitchuami taimani quviagigiksi qaumagikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aglaansuli uvapkun piqaqtuŋa iḷisimarimik kamanatluktuamik John-ŋum iḷisimaraułhaniñunniiñ, makua savaat iñiqtaġikkaġma, Aapaa qaisaŋiñ savaaġitquplugich itqanaiġḷugich tamatkua nalupqinaiqsruġaat Aapamun tuyuġiłiġa. ");
INSERT INTO eskNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aapauruaqtuuq tuyuqaqtuaq uvaŋnik uqaqtuq tamarrumuuna, ilipsi tusraanġaqsimaitchaluaġiksi nipaa unniiñ kigiñaŋa qiñiġlugu. ");
INSERT INTO eskNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ilipsi uqauttutai piginġitḷugich unniiñ ukpiġinġitḷugu taamna tuyuġikkaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Iḷisaaġigisi uqałhich aglausimaruat iñuułiġmik isruitchuamik paqitchiñasugiplusri. Tamarra tamatkua uqautiqaqtuat uvapkun, ");
INSERT INTO eskNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","aglaan piyummataitchusri uvaŋnun utlautisrugusri aasrii piññagusri iñuułiġmik uvapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nanġaqsiułiksraq iñuŋniñ qiñiġniaġaginġitchiga. ");
INSERT INTO eskNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aglaan iḷisimagiksi, suutnaġinġitchiksi piqpaksrił̣iq suvaluk Agaayyutim piqpaktaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aggiqsuŋa Aapaa aŋalatchisaagun aasii akuqtunġitchipsitña. Naagasuli iñuk kiña aggiqpan iŋmi saŋŋimigun, ilipsi akuqtuġniaġiksi. ");
INSERT INTO eskNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ilipsi nanġautisruuruani avatmun aasriiñ suliqutiginġitchiksi nanġausriaksraqsi Agaayyutmiñ kisianiñ. Qanuġusrimi ukpiqsriñiaqpisi? ");
INSERT INTO eskNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Isrummatiginagu uvaŋnun patchisiqutigisiñiḷusri Aapaanun. Moses-ŋum patchitri sagviummigaa, taimñaami Moses ilipsi tunŋavigikkaqsi. ");
INSERT INTO eskNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Iḷumun ukpiġiniġupsiuŋ Moses, tunŋaviginayaqmigipsitña ukpiġiluŋa takku ilaan aglaktigun uqautigigaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aglaan aglaaġikkaŋi ukpiġinġitñapsigik, qanuġusri ukpiqsrigisivisi uvaŋa uqałimnik?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Taavruma aquagun Jesus ikaaŋaruq taagatchiaŋanun narvaŋan Galilee-m. Taamna narvaq taggisiqaqmiuq Tiberias-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iñugiallapiaqtuat malilgiññiġaat, atakkii iliŋisa qiñiqługich quviqnaqtuat savaaŋi iłuaqsiraġaił̣ikun atniġñaqtuanik. ");
INSERT INTO eskNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus qimiġaamun mayuqhuni, aquvinniqsuq maliġuaqtiniḷu. ");
INSERT INTO eskNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jew-ŋuruat niġiqpagvikaaŋat taggisiqaqtuaq Apqusraaqtitaułiġmik tarani qalliñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus qiñiqługich iñugiallapiaqtuat iñuich utlautiruat iŋmiñun nipliutiniġaa Philip, “Nakiñ tauqsiġayaqpisa niġisuiġutiksraŋatnik ukua iñuich?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Taavrumiŋaguuq nipliutiniġaa Philip uuktuaqługu, Jesus-ŋum iḷisimaanikkaluaqługu sułiksrani. ");
INSERT INTO eskNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip-ŋum kiuniġaa, “Malġuk kavluutik akiaknik naamayumiñaitchut qaqqiaqsisigisaġuptigik iñullaa mikiruuramikunniiñ niġiyumiñaqsiḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Maliġuaqtit iḷaŋata, Andrew, Simon Peter-m aniqataa, nipliqsuq, ");
INSERT INTO eskNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Uvvauvani nukatpiaġruk piqaġniqsuq tallimanik qaqquuranik barley-nik suli qaluuraaŋnik. Aglaan suugisivat taapkua itna iñugiaktigiruami iñuŋmi?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus nipliutigai, “Iñuich aquvititchigik.” Ivigaaŋupluniguuq tamanna. Iñuk iluqani aquvinniqsuq. Aŋutiłhiñat 5,000-siyuŋnaq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus-ŋum qaqqiaq tigu'amiuŋ, Agaayyun quyaniġaa agaayupluni, autaaġutaupluniasrii iñuŋnun aquppiruanun. Taatnatunsuli iñiqtaqaġniqsuq qalukkun. Aasrii iluqatiŋ niġiñiqsut pisuiġataqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Niġisuiḷḷakmata, Jesus nipliutigai maliġuaqtini, “Iḷakupayaat katitchigik aasrii iksisruŋaqasri.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Katitchi'amiŋ, immiġñiġaich qulit malġuŋnik aguupmaich iḷakuatnik tallimaniñ barley-niñ qaqquuraniñ iñuich niġġivigikkaŋatñiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iñuich qiñiqamitruŋ quviqnaqtuaq savaaq Jesus-ŋum iñiqtaŋa nipliġñiqsut, “Iḷumutun una ilaaŋuniqsuq. Tarra sivuniksriqirauniqsuq aggiqsuksrautauruaq nunam iñuiñun.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus-ŋum kaŋiqsiñiġaa iñuŋnun umialiguqtinniałiksrani nunuriḷuni. Taatnaqhuni unitḷugich aullaumiugallaŋniqsuq qimiġaanun kisimi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Unnuksraaqman maliġuaqtai narvamun utlautiniqsut. ");
INSERT INTO eskNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Umiamun iki'amiŋ utiaqsiñiqsut Capernaum-mun ikaaqługu narvaq. Unnuaġuqman Jesus-ŋum utlanġiññiġaisuli. ");
INSERT INTO eskNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Anuġiġuutiqpauraġniġai qaiḷġuutipḷugich. ");
INSERT INTO eskNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Maliġuaqtit iputlutiŋ piñasrunik naagaqaa sisamanik mile-lanik iglianigmiullu, qiñiaqsiñiġaat Jesus pisruktuaq imiġmi qalliruaq umiamun. Aasrii iliŋich iqsitchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesus-ŋum nipliutiniġai, “Iqsiñasri! Uvaŋauruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Taapkua ikiyumaliqsipiaġniġaat, aasrii ikipman taimmaiñaq umiam tikiñŋaniktiġniġaa sivuniġikkani. ");
INSERT INTO eskNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Uvlutqikman iñuich iñugiaktuat aullanġitchuat tamaaniaŋaniñ narvam, iḷitchuġiniġaat atausrisualuk umiaq taraniitilaaŋanik. Jesus aullaqataunġił̣ha maliġuaqtimigun suli itqaġiniġaat kisimiŋ maliġuaqtaiñ aullałhat. ");
INSERT INTO eskNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Atlat umiat Tiberias-miñ tulaagaqsiñiqsut qaniŋanun niġiqpagviata Atanġuruaq agaayutrianikman. ");
INSERT INTO eskNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iñugiaktuat kaŋiqsima'amitruŋ Jesus taraniinġił̣ha unniiñ maliġuaqtai, umianun ikiplutiŋ Capernaum-mun aullaġniqsut pakakługu. ");
INSERT INTO eskNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Narvam igḷuani iñuich Jesus paqitnamitruŋ, nipliutiniġaat, “Iḷisautrii! Qaŋaaglaan mauŋaqpich?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus-ŋum kiugai, “Iḷumutuullapiaqtuamik nipliutigipsi, paqitkipsitña takku niġił̣ł̣apsigun qaqqiamik pisuiġataqhusri piqutigitlusruŋaqnagich qiñikkasri quviqnaqtuat savaatka saŋŋigikkapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sakuugutiqaqasri niqimik piunġiqsaqtuamik aglaan sakuugutiqaġitchi niqimun ittuaksramun isruitchuamun iñuułiġmun. Taamna niqi Iñuum Iġñiŋan qaitkisigaa ilipsitñun, takku Agaayyutim Aapam nalunaiqsaġigaa iłuaġikkaułhagun Ilaa.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tamatkua apiqsruġaat, “Suruksrauvisa savaaqaġniaġupta Agaayyutim savaaŋiñik?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus kiugai, “Uvva savaaq savaaġitqukkaŋa Agaayyutim ilipsitñun, ukpiqsritqugaasri ilaanik tuyuġikkaġmiñik.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tamatkua kiugaat, “Sumik qiñikkiġayaqpisigut quviqnaqtuamik saŋŋipkun, uvagut qiñiġlugu ukpiqsritḷasriḷuta ilipnik. Sumik iñiqtaqaġayaqpich? ");
INSERT INTO eskNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sivulliavut niġimarut taiyuutiliŋmik Manna-mik qaqqumik pakmakŋaqtamik suviksraiḷaami atripḷugu uqautigimaruaq iŋiḷġaan uqałiġmi, itna, ‘Ilaan qaitchigai qaqqumik niqiksraŋatnik pakmakŋa.’” ");
INSERT INTO eskNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus nipliqsuq, “Iḷumun nipliutigipsi, taimña Moses niqiqaqtitchiruq ilipsitñik pakmakŋa timiłhiñamun ittuamik, taiyuutiliŋmik Manna-mik. Uvvaaglaan Aapaa qaitchigaasri iñuunaqtuamik iḷumutuuruamik niqiksramik pakmakŋa qiḷaŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Uvvatakku niqiksraq Agaayyutim qaisaŋa ilaaŋuruq atqaqtuaq pakmakŋa iñuułiġmik qaitchipḷuni nunam iñuiñun.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tamatkua nipliutiniġaat, “Ataramik qaitchisigut taavrumiŋa niqiksramik.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus-ŋum nipliutigai, “Uvaŋa atrigigaaŋa qaqqiam niqiksrauruam timikun, uvaŋa kaŋigigaaŋa iñuutlasrił̣iksram iñuutchikun. Iñuk utlautiruaq uvaŋnun niġisulitqikkumiñaitchuq, suli ukpiqsriruaq uvapkun imiġulitqikkumiñaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aglaan uvaŋa uqautianikkipsi arguaqtułłapsigun, takku ilipsi qiñiġaluaqłuŋa savaaġikkapkun ukpiqsrisunġitchusri. ");
INSERT INTO eskNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kiñapayaaq Aapaa qaisaŋa uvaŋnun utlautigisiruq. Aasrii kiñapayaaq uvaŋnun utlautiruaq saqitchumiñaitchiga. ");
INSERT INTO eskNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Takku atqaqtuŋa pakmakŋa tuyuġirima pitqutigikkaŋa iñiqtaġityaqługu, pisułłapkuunġitchuaq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uvvauna pisułiġigaa tuyuġirim uvamnik tammaitqunġił̣iksraġa nalliatnikunniiñ qaisaġianikkaŋiñiñ uvaŋnun aglaan iluqaisa aŋitqiksillugich iñuułiġmun uvlumi aqulliġmi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Uvvauna Aapaa pisułiġigaa iluqatiŋ qiñiqtuat iġñiġuruamik suli ukpiqsriruat ilaanik piqałiksraŋat isruitchuamik iñuułiġmik aasrii uvaŋa makititkisipḷugich iñuułiġmun aqulliġmi uvlumi.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jew-ŋuruat uqapiḷuutigiaqsiñiġaat ilaan niplił̣hagun, itna, “Uvaŋa niqiksrauruŋa atqaqtuaq pakmakŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iliŋich nipliġñiqsut, “Jesus-ŋunġitpauna, Joseph-ŋum iġñiŋa? Uvagut iḷisimagivut aapaŋalu aakaŋalu. Qanuqhunimi nipliava atqaġnipḷuni pakmakŋa?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus kiugai, “Uqapiḷuguiqitchi! ");
INSERT INTO eskNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kiñaunniiñ uvaŋnun utlautilguitchuq kisianik Aapauruam tuyuġirima uvaŋnun utlautipkaqmani. Aasrii uvaŋa aŋitqiksitkisigiga iñuułiġmun uvlumi aqulliġmi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sivuniksriqirit aglausimaruat, ‘Agaayyutim iñupayaat iḷisautigisigai.’ Kisupayaaq naalaġniruaq Aapamik suli iḷitchiyumaruaq Ilaaniñ utlautiraqtuq uvaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kia-unniiñ qiñiqsimaitchaa Aapa, aglaan kisimi Agaayyutmiqnisauruam qiñiqsimagaa Aapa. ");
INSERT INTO eskNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iḷumutuuruamik nipliutigipsi, kiñapayaaq ukpiqsriruaq isruitchuamik iñuułiqaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Uvaŋa qaqqiaŋuruŋa iñuunaqtuaq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ilipsi sivulliasri niġimaŋŋaġmiŋ pakmakŋaktamik qaqqumik suviksraiḷaami tuqurut timimikkun. ");
INSERT INTO eskNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aglaan qaqqiaq atqaqtuaq pakmakŋa itniittuq, kiapayaaq niġikpagu tuquyumiñaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Uvaŋa iñuunaqtuaq qaqqiaq atqaqtuaq pakmakŋa. Kiñapayaaq iñuk niġigumi taavrumakŋa qaqqiamiñ iñuugisiruq taimuŋa, aasrii timiga qaqqiaŋuruq qaisaksraġikkaġa nunam iñui iñuutlasritquplugich.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Taatnaqman Jew-ŋuruat uqaatchagutiniqsut iŋmiknun aasrii apiqsruqługu, “Qanuġuni uuma iñuum timimiñik niqiksriññiaqpatigut?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus-ŋum kiugai, “Iḷumutuuruamik nipliutigipsi, ilipsi niġiñġitchupsiuŋ timaa Iġñiŋan piqaġumiñaitchusri iñuułiġmik ilipsitñi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kiñapayaaq niqiniktuaq timimnik suli iminiktuaq augikkamnik isruitchuamik iñuułiññaktaqtuq, aasrii aŋitqiksitkisigiga iñuułiġmun aqulliġmi uvlumi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Uvvatakku timiga iḷumun niqiksrauruq, suli auga iḷumun imiksrauruq. ");
INSERT INTO eskNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kisupayaaq niqiqaqtuaq timimnik suli imiqaqtuaq augikkamnik iñuuruq uvapkun suli iñuugisipḷuni piqasriutiluni uvaŋni. ");
INSERT INTO eskNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Iñuuruam Aapam tuyuġipluŋa, suli uvaŋaptuuq iñuuruŋa ilaagun, taatnatuntuuq kiña niqiqaqtuaq uvamnik iñuugisipmiuq uvapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iñuum taamna qaqqiaq niqigigumiuŋ iñuugisiruq qaŋavak taimuŋa. Taamnauruŋa qaqqiaq atqaqtuaq pakmakŋa atriginġisaŋa qaqqiam sivulliapsi niġitchaŋat, naagaunniiñ tuquplutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Taatnaġniġai Jesus-ŋum iḷisautriñiġmiñi katraġviŋmi Capernaum-mi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iñugiaktuat maliġuaqtaiñ tusraaplugu nipliġñiqsut, “Taamna iḷisauttun akuqtułiksraŋa sakiqnaqtuq. Kia naalaġnigisivauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Uqautigaluaqtitnaniguuq, Jesus-ŋum kaŋiqsimapmitchaŋi maliġuaqtini uqapiḷuktuat tamarrumuuna uqaġikkaġmigun. Taatnaqługich nipliutiniġai, “Taavruma nipim piyummataiqsitkaqsivasri? ");
INSERT INTO eskNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Isrummatigisriuŋ qiñiłiksraŋa Iġñiŋan Iñuum utiaqsikpan sivuani irvigimakkaġmiñun. Taatnaaqsikpan nikaliġukkayaġniqpisi? ");
INSERT INTO eskNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ipqitchuaq Irrusriq iñuułiqaqtitchiruaŋuruq. Timi iñuułiqaqtitchiñġitchuq. Uqałhich ilipsitñun uqautigianikkatka Irrusriurut, suli iñuupkaġisipiaġaasri. ");
INSERT INTO eskNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Naagauvva iḷapsi ukpiġinġitchaich,” Jesus-ŋum taatnaġniġai. Iḷisimaplugu aullaġniisaġatałhaniñ kisuułhat ukpiqsriñġitchuaq suli kisuugisił̣ha tuniriksraġmi. ");
INSERT INTO eskNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aasrii nipliġñiqsuq. “Taavrumiŋa piqusriqł̣ugu uqautigipsi, kia-unniiñ utlautiyumiñaił̣ha uvaŋnun kisianik Aapam utlautipkaqpani taatnatlasriḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Taavruma aquagun iñugiaktuat maliġuaqtai kiñumuaktut malitqikkummataiqł̣ugu ilaa. ");
INSERT INTO eskNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Taatnaqhuni Jesus nipliutiniġai qulit malġuk maliġuaqtini, “Ilipsipsuuq kiñumuakkumanġitchaluaqmivisi?” ");
INSERT INTO eskNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter-m kiuniġaa, “Ii, Ataniiq, kimunmi aullaġisivisa? Ilvich pigigitin uqałhich isruitchuamik iñuunaqtuat. ");
INSERT INTO eskNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pakma ukpiġigikput iḷitchuġiplugu ipqitchuaŋutilaan Agaayyutmiqnisauplutin.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus kiugai, “Ilipsi qulit malġuuplusri piksraqtaaġinġitpisimi? Aglaan iḷari Tuunġaqmiqnisauruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ilaanguuq uqautiginiġaa Judas, iġñiŋa Simon Iscariot-ŋum. Uvvatakku Judas qulit malġuuqataugaluaqhuni, tunisiyumaniqsuq Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tamarruma kiñuagun Jesus igliġniqsuq Galilee-mi, igliġummataiḷaqhuni Judea-mi, atakkii Jew-ŋuruat tuqqutchukługu. ");
INSERT INTO eskNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jew-ŋuruat niġiqpagvikaaŋata Palapkaat tikiyasriruq. ");
INSERT INTO eskNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Uvvaasriiñ Jesus-ŋum nukatchiaŋiñ aŋutit nipliutiniġaat, “Uniḷḷugu mannaaq, aullaġiñ Judea-mun, ilviḷḷi maliġuaqtivich taamani qiñiġumigaat savaaq iñiqtaġikkan. ");
INSERT INTO eskNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kiñaunniiñ iriqsimatlaitchuq savaaġmigun iḷisimatqullapiaqami. Ilvich iñiqtaqaqtuami tamatkuniŋa, iluqaitñun iñuŋnun iḷitchuġipkaġiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Taatnaġniġaat nukatchiaŋiunniiñ ukpiqsriñġitḷutiŋ Ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus nipliutigai, “Piviksraġa nalaullugu tikiumanġitchuqsuli. Ilipsi aullałhiñaaŋurusri sumipayaaq. ");
INSERT INTO eskNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nunam iñuiñ uumigikkaġinġitchaasri uvaptun, atakkii uvaŋa uqausrimaplugich iñuuniałhat pigiił̣hagun. ");
INSERT INTO eskNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ilipsi niġiqpagvikaanukkitchi. Aullanġitchuŋa pakma atakkii aullaġviksraġa tikiumanġitchuqsuli.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Taatna uqautilġaaqługich Galilee-mi ittuallaŋniqsuqsuli. ");
INSERT INTO eskNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aquagun nukatchiani niġiqpagvikaanuanikmata, Jesus-tuuq aullaġniqsuq sagviaqtusruŋaqani iñuŋnun, aglaan nalunautchipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jew-ŋuruat qiñiġniaġaluaġniġaat niġiqpagvikaaŋani itnaqhutiŋ, “Naamiimma taimña?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iñuich atqunaq uqaksraqtuniqsut Ilaagun, iḷaŋich uqaqhutiŋ iñullautaunipḷugu aasriiḷu iḷaŋich uqaqhutiŋ pigiiññipḷugu kinnitñiŋnipḷugu iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aglaan kia-unniiñ uqaksraqtutiginġiññiġaa sagviġḷugu, atakkii iqsipḷutiŋ Jew-ŋuruat sivulliuqtinik. ");
INSERT INTO eskNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Niġiqpagvikaaŋata avvaŋa atuumaanikman, Jesus utlautiniqsuq Jew-ŋuruat agaayyuvikpaŋatnun aasriiñ iḷisautriaqsipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jew-ŋuruat atqunaq quviġutchaŋniqsut nipliqhutiŋ, “Qanuqhuni una iñuk iḷisimaniqpa apai, iḷisaqsimaitchaluaqhuni?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus kiugai, “Iḷisauttutiga uvamniqnisaunġitchuq aglaan Agaayyutmiñ tuyuġirimniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kisupayaam piyummatiqaġumi maliguglugu Agaayyutim pisułha iḷisimatlagisigaa iḷisauttutma Agaayyutiqniqsaukmagaan naagaqaa uvamniqnisaukmagaan. ");
INSERT INTO eskNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iñuk nipiqaqtuaq iŋmigułhiñaq piññaŋniaġaqtuq kamagitchiułiksraġmiñik. Aglaan taamna kamanaqtitchiruaq tuyuġirimiñik iḷumutuuruq, ilaani piitchuq taŋiġiḷaaq. ");
INSERT INTO eskNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses-ŋumliumaa qaitchitchaŋasri maliġutaksranik? Aglaan nallipsiunniiñ maliġutaksrapayaaq tupiginġitchaa. Suvaata tuqqutchumavisitña?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iñugiaktuat kiugaat, “Ilvich tuunġaqtaqaqtutin! Kia tuqqutchukpatin?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus kiugai, “Atautchimik quviqnaqtuamik savaaqaqama, iluqasri quviġusruutigigiksi. ");
INSERT INTO eskNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses-ŋum tiliñigaasri iġñaurasri nalunaitŋutchiquplugich. Nalunaitŋutchiqsauviksraŋat nukatpiaġruich uvluq nalaurrutipman minġuiqsiaġviŋmun nalunaitŋutchiqsuurusri minġuiqsiaġviŋmi. Uvvasuli, taamna tillisiñ aullaġniiñġitchaluaqmiuq Moses-miñ aglaan sivulliapsitñiñ ilaan sivuani. ");
INSERT INTO eskNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nukatpiaġruk nalunaitŋutchikkautlaniqpan Jew-ŋuruat minġuiqsiaġviatni, Moses-ŋum maliġutaksraŋa navigunġiḷḷugu, suvaatami uumisuutivisitña iñuŋmik iłuaqsipkaiñipḷuŋa Jew-ŋuruat minġuiqsiaġviatni? ");
INSERT INTO eskNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Atanniqsuiñasri sagvirautigułhiñaq qiññałhiñakun aglaan atanniqsuisitchi nalaunŋaruakun.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem-miut iḷaŋich nipliġñiqsut, “Imñaunġitchaluaqpa iñuk ipchua tuqqutchukkaŋat? ");
INSERT INTO eskNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aasrii maaniittuq! Ilaa uqautriruq sagviqhuni. Naagauvva nalliatunniiñ akitñanġitchaat. Ipchua sivulliuqtit kaŋiqsiñġitchaluaqpatruŋ Christ-ŋuniḷugu? ");
INSERT INTO eskNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aglaan Christ aggiqpan, kia-unniiñ iḷisimayumiñaitchaa nakitñaqtaułha. Naagauvva iḷisimagikput uuma iñuum kisuŋnik aŋayuqaaqałha.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus iḷisautriñiġmiñi Jew-ŋuruat agaayyuvikpaŋatni nipliġñiqsuq nipitusripḷuni, “Ilipsi iḷitchiġipiaġaluaqpisitña? Kaŋiqsivisiuŋ nakitñaqtautilaaġa? Uvaŋa agginġitchuŋa uvapkuiñaq, aglaan tuyuġiriga iḷumutuuruq. Ilipsi nalugiksi. ");
INSERT INTO eskNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aglaan iḷisimagiga atakkii Ilaaniñ aggiqł̣uŋa, aasriiñ Ilaan tuyuġipluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tamatkuaguuq iñuich tiguyumagaluaġniġaat, aglaan kia-unniiñ tigunġiññiġaa takku Ilaan tigukkauviksraŋa tikitmanġitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iñugiakpauraqtuat ukpiqsriñiqsut Ilaanik, aasrii nipliqhutiŋ, “Taimña Christ aggiġumi, quviqnatluktuanik savaanik iñiqtaqaġisiva uuma iñuum iñiqtaŋiñiñ?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisee-ŋuruat tusraa'amisigik, iñugiaktuat isivruaġutiqaqtuat ilaanik, iliŋich piqasriqhutiŋ qaukłiŋich agaayuliqsinik tuyuqaġniqsut qaunaksrinik tigutaaquplugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus nipliġñiqsuq, “Uvaŋa nayuqtaullapsaaġaluaġupsi aullaġisiruŋa Ilaanun tuyuġirimnun. ");
INSERT INTO eskNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ilipsi pakiaqsigisigipsitña, aglaan paqitchumiñaitchipsitña, aasriiñ irviksramnun tikitchumiñaitchusri.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Taatnaqman Jew-ŋuruat uqaaqsiḷgiññiqsut iŋmiknun, “Napmuŋniaqpa una iñuk uvaptiknun paqitchumiñaiññiva? Ilaa aullaġniaqpa Jew-ŋunġitchuat nunaaqqiatnun, Jew-ŋuruat iñuuniaġviatnun iḷisautityaġlugich Jew-ŋunġitchuat? ");
INSERT INTO eskNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uvvatakku nipliqsuq, ‘Ilipsi pakikkisigaluaġipsitña, aglaan paqitchumiñaitchipsitña.’ Nipliqsuqsuli, ‘Irviksramnun tikitchumiñaitchusri.’ Qanuqpami taatnaqami?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Niġiqpagvikaam uvlua aqulliq nuimatluktauŋuniqsuq. Taavrumani uvlumi Jesus qichaqhuni nipliġñiqsuq nipitusripḷuni, “Kisupayaaq imiġukkumi utlautiluni uvaŋnun imiġli. ");
INSERT INTO eskNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Atriḷugu aglausimaruat uqałhich, itna, ‘Kiñapayaaq ukpiqsriqpan uvapkun imġa suvliktuaġuġniaqtuq siḷatmun uummataaniñ.’” ");
INSERT INTO eskNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Taatnaiḷipḷugu Jesus-ŋum uqautiginiġaa Ipqitchuaq Irrusriq akuqtuġniakkaŋat ukpiqsriruat ilaanik. Tarani taatnałhani Ipqitchuaq Irrusriq aatchuutaumaitḷunisuli, takku Jesus utiqsimaitḷunisuli pakmuŋa qiḷaŋmun. ");
INSERT INTO eskNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iñugiaktuam iñuum tusraa'amitruŋ Jesus-ŋum uqałhi nipliġñiqsut, “Una tarra iñuk iḷumun taimña sivuniksriqiraupiaqtuq!” ");
INSERT INTO eskNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iḷaŋiḷḷi niplianiqsut, “Christ-ŋuruq (itnautauruamik Anniqsuqtimik).” Aglaali atlat itnaġniqsut, “Christ aggiġumiñaitchuq Galilee-miñ. ");
INSERT INTO eskNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Agaayyutim uqałhich aglausimaruat itnaqtut Christ kiñuviaġigisiñipḷugu David-mun, suli anigisiñipḷugu Bethlehem-mi nunaaqqiani David-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taatnaqhutiŋ igḷugiiksinniqsut iñugiaktuat piqusriqhutiŋ ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iḷaŋisa tiguyumagaluaġniġaat aglaan kia-unniiñ tigunġiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Qaunaksrit utiġniqsut qaukłiŋich agaayuliqsinun suli Pharisee-ŋuruanun. Taapkua apiqsruġniġaich, “Suvaata uvuŋautinġitpisiuŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Qaunaksrit kiuniġaich, “Uvagut tusraavaaluktugut iñuŋmik taatna uqalgutigiruamik.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisee-ŋuruat nipliḷgiññiqsut, “Ilipsi kinnipchanġitchaluaqpisi? ");
INSERT INTO eskNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Iḷitchuġimaitpisiuŋ nalliata sivulliuqtipsa suli Pharisee-ŋuruat ukpiqsriñġił̣hat Ilaanik? ");
INSERT INTO eskNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aglaan iñugaaġruich kisimiŋ ukpiġigaat. Tamatkua iñuich kaŋiqsimmataitchut maliġutaksranik Moses-kun. Taatnaqhutiŋ suksraunġiqsauyumaaqtut.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus-guuq iḷauniqsuq taapkunani qaukłiġñi suli Pharisee-ŋuruani. Taamna qiñiġiaqtuaq Jesus-mik sivuani, aasrii nipliġñiqsuq, ");
INSERT INTO eskNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Maliġutaksraġikkaptigun atanniipkatlaitchaatigut iñuŋmik tusraagaluaqnagu naagaqaa iḷitchuġigaluaqnagu sumik pisilaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Taapkua iḷaiñ kiuniġaat, “Uvva, Galilee-ġmiuŋupmivich? Iḷitchuġimaiññiqpiuŋ uqałhich aglausimaruat? Iḷisaġlugich aasriiñ kaŋiqsigisigiñ sivuniksriqirit aggiñġaqsimaił̣hat Galilee-miñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tarani iluqatiŋ aŋiḷaaġniqsut, ");
INSERT INTO eskNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","aglaali Jesus utlautiniqsuq iñġiuramun atiliŋmun Olives-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Uvlaakuagun uvlaatchaurami Jesus utlautilgiññiqsuq Jew-ŋuruat agaayyuvikpaŋatnun. Iñuich iñugiakpauraqtuat kattivigilgiññiġaat. Aasrii aquvitluni iḷisautiaqsiḷgiññiġai. ");
INSERT INTO eskNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aglaliqirit suli Pharisee-ŋuruat tikiutriñiqsut aġnamik aŋukkauruamik sayuŋałikun aasrii iluqaisa sivuġaatnun qichaqtitlugu. ");
INSERT INTO eskNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesus-mun nipliġñiqsut, “Iḷisautrii! Una aġnaq aŋukkauruq sayuŋałikun. ");
INSERT INTO eskNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Uvagut maliġutaksriusriaptikni Moses-ŋum tillisiqakkaŋatigut taatnasriq aġnaq iyaġaŋnik miḷuqtuġlugu tuqqutaksrauplugu. Qanuġli una aġnaq nipliutiginayaqpiuŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Taatnaġniġaat Jesus pitchaqługu iliŋich piqaġukkaluaqhutiŋ agvisiksramik. Aglaan Jesus sikitluni nunamun aglaŋniqsuq argaŋmiñik. ");
INSERT INTO eskNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Taapkua apiqsruqtaqtuiñaaqsipmata, Jesus qichaqhuni nipliutiniġai, “Nallipsi killuqsaqsimaitchuam sivulliuluni iyaġaŋmik miḷuqsaqqaaġliuŋ.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Taatnaqqaaqhuni sikitluni nunamun aglaaqsiḷgiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Taamna tusraa'amitruŋ, taapkua iluqatiŋ aullaġniqsut atausriuttaaqhutiŋ aullaġniipḷutiŋ utuqqautluŋniġmikniñ, Jesus kisiŋŋuqługu aġnaġlu qichaqtuaq tarani. ");
INSERT INTO eskNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Qichatqikhuni nipliutiniġaa aġnaq, “Naamiimma taipchua? Nalliataunniiñ tuqqutaksraġuġnivatin?” ");
INSERT INTO eskNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aġnam kiuniġaa, “Ii, Aŋuun! Nalliatnik israaqtaitchuŋa.” Jesus nipliutigaa, “Uvaŋaptuuq tuqqutaksraġuġumiñaitchikpiñ. Aullałhiñaaġuqtutin aglaan killuqsatqisruŋaqnak!” ");
INSERT INTO eskNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus-ŋum iñuich nipliutitqiŋñiġai, “Qaumaksrauruŋa nunam iñuiñun. Kisupayaam malikkumiña, qaumamik iñuunaqtuamik piññakkisiruq. Taatnaġuni iñuuniatqikkumiñaitchuq taaqtuakun.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee-ŋuruat kiuniġaat, “Ilvich iḷisimarriqsimarutin ilipniłhiñaq, taatnaqługu iḷumutuugilguitchikput. Sumun atuġumiñaitchuq taamna.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus kiugai, “Taatniinġitchuq. Uqautigigaluaŋŋaġma uvamnik, nipliutipayaaġa iḷumutuuruq, takku iḷisimagiga nakitñaqtautilaaġa suli napmun aullaġniaqtilaaġa. Ilipsi iḷisimanġitchiksi nakiñ aggiqsilaaġa unniiñ napmuŋniaqtilaaġa. ");
INSERT INTO eskNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ilipsi atanniqsuiraqtusri iñułhiñaułikun, atanniġviaġautaitchuŋa kimun-unniiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aglaan atanniiruksrauniġuma atanniutiksraġa iḷumutuuniaqtuq, takku tamarrumuuna kisima inġitchuŋa, aglaan Aapauruam tuyuġirima piqasriqsuġaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aglausimaruq maliġutaksriusriapsitñi malġuulutik iḷisimarik atikpaknik uqautaak iḷumutuuginipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uvaŋa uvamnik iḷisimarriqsimaaqtuŋa suli Aapam tuyuġirima iḷisimarriqsimaaqmigaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tamatkua apiqsruġniġaat, “Naami aapagikkan?” Jesus kiugai, “Nalugiptiguk Aapagalu. Iḷisimaniġupsitña, Aapagaptuuq iḷisimanayaġiksi.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus-ŋum taatnaġniġai tarani Jew-ŋuruat agaayyuvikpaŋatni iḷiraqaġvigiplugu pivigikkaŋatni. Aglaan nalliataunniiñ tigunġiññiġaa, takku tuqqutauviksraŋa tikiumanġitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus nipliutitqiŋñiġai, “Uvaŋa aullaqsaġumaruŋa. Pakiaqsigisigaluaġipsitña, aglaan tuqugisirusri killuuŋŋapsi natqiguttusriaqanġitchupsi. Atlaŋunġiḷḷusri, aullalguyumiñaitchusri aullaġviginiakkamnun.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jew-ŋuruat nipliġñiqsut, “Qanuqpa una, naaga iŋmiñik tuqunniaqpa? Takku nipliqsuq, ‘Aullaġumiñaitchusri aullaġviginiakkamnun.’” ");
INSERT INTO eskNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus kiugai, “Ilipsi maakŋaqtaurusri, aglaan pakmakŋaqtauruŋa. Ilipsi aggiqsauŋurusri marrumakŋa nunamiñ, aglaan nunamiqnisaunġitchuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Taatnaqhusri uqautigipsi killuliqirauŋŋapsi tuqugisiñipḷusri. Tuqugisipiaqtusri killuliqirauŋŋapsi ukpiġinġisuaġupsiuŋ ilaaŋutilaaġa.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Taapkua apiqsruġniġaat, “Kisuuvichuvva?” Jesus kiugai, “Aullaġniisaqqaapiałhaniñ uqautigaluaġipsi kisuutilaamnik. ");
INSERT INTO eskNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iñugiaktuatigun nipliġḷuŋa isiḷġiġumiñaġaluaġipsi. Uvaŋa nipiqaqtuŋa nunam iñuiñun tusraakkałhiñamnik Ilaaniñ tuyuġirimniñ iḷumutuuruamiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tamatkua kaŋiqsiñġiññiġaat uqautrisilaaqtiŋ Agaayyutikun Aapauruakun. ");
INSERT INTO eskNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Taatnaqługich Jesus nipliutilgiññiġai, “Iñuum Iġñiŋa kivianikkupsiuŋ, iḷitchuġipmiḷugulu pigisigiksi ilaaŋutilaaġa, suli iñiqtaqaqtanġił̣iġa uvapkuiñaq aglaan nipiqałiġa Aapam kisimi iḷisauttutaagun. ");
INSERT INTO eskNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aasrii tuyuġiriga uvamni piqatauruq, Ilaan kisivripchanġitchaaŋa, takku ataramik quyalimaaġiga.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iñugiaktuat tusraaruat Jesus taatnaqman ukpiqsriñiqsut Ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Taatnaqługich Jesus nipliutiniġai Jew-ŋuruat ukpiqsriruat ilaanik, “Ilipsi iḷisauttutitka tupigituiñaġupsigik sivutmun, iḷumutun maliġuaqtiginiaġipsi. ");
INSERT INTO eskNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Iḷumutuuruaq iḷitchuġiniaġiksi, iḷumutuułhum patchisaisitkisigaasri.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Taapkua kiuniġaat, “Uvagut Abraham-ŋum kiñuviaġigaatigut. Kimununniiñ savaktaaġruumaitchugut. Uvvami qanuqpich nipliqavich ‘patchisaisitkisigaasri’ itna?” ");
INSERT INTO eskNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus nipliutiniġai, “Iḷumutuuruamik nipliutigipsi, kiñapayaaq killuqsaqtaqtuaq savaktaaġruliutraqtuq killuġmun. ");
INSERT INTO eskNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Savaktaaġrugli nayuutitlaitchuq aŋayuqaaġiiñi ataramik, aglaan iġñiġuruaq nayuutiraqtuq. ");
INSERT INTO eskNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ilipsi Agaayyutim Iġñiŋan patchisaisitpasri, tarra nalupqinaitchuanik patchisaitkisirusri. ");
INSERT INTO eskNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iḷisimagiga Abraham-mun kiñuviaġiłiqsi, naagasuli tuqurviksraqsiuġipsitña, takku akuqtuumanġitḷugu iḷisauttutiga. ");
INSERT INTO eskNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Uqautiqaqtuŋa Aapama qiñiqtitaŋanik uvamnun, aasriiḷi iñiqtaqaġaqtusri Aapapsitñiñ uqauttusriapsitñik.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tamatkua kiuniġaat, “Uvagut aapagigikput Abraham.” Jesus-ŋum kiuniġai, “Ilipsi iḷumun Abraham-ŋum qitunġaġikpasri, savaaqaġayaqtusri ilaatun. ");
INSERT INTO eskNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Naagauvva tuqurviksraqsiuġipsitña, uqautigaluaqtitlusri iḷumutuuruamik tusraakkamnik Agaayyutmiñ. Abraham taatnaqsimaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ilipsi savaaqaqtusri Aapagikkapsi savaaŋiñik.” Tamatkua kiuniġaat, “Uvagut aapaiḷauŋunġitchugut. Aapa atausriq pigigikput, Agaayyun ilaa.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus kiugai, “Agaayyutmik iḷumun aapaqaġupsi piqpaginayaġipsitña, takku aggiqsauŋuruŋa Agaayyutmiñ, aasrii pakma uvaniitluŋa aggiñġitchuŋa uvapkuiñaq aglaan ilaan tuyuġipluŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Suvaata kaŋiqsitḷaitpisiuŋ uqałiġa? Ilipsi naalaġniyummatiqanġitchiksi uqauttutiga. ");
INSERT INTO eskNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tuunġaum aapagikkapsi qitunġaġiplusri aasrii maliġutchiyumaruaŋuplusri aapagikkapsi kimmutaiñik. Aullaġniisaqqaapiałhaniñaglaan ilaa tuqqutchiruaruq. Ilaa tapiqsuusrimaitchuq tuŋaanun iḷumutuułhum ilaa piitḷuni iḷumutuuruamik iŋmiñi. Uqaqami saglumik iñiqtaqaġaqtuq takku sagluturuaŋupluni, sagluuqtuałipayaam aapagiplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Uvaŋa iḷumutuuruamik uqautigipsi, taatnaqhusri ukpiġinġitchipsitña. ");
INSERT INTO eskNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kiñaunniiñ nipliḷguitchuq uvapkun iḷumutuġuġlugu killuuruaŋuniḷuŋa? Uvvami uqauti'apsi iḷumutuuruamik, suvaata ukpiġisrunġitpisitña? ");
INSERT INTO eskNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iñuum aggiqsuam Agaayyutmiñ naalaġnigai Agaayyutim uqautai. Ilipsi agaayutiqniqsaunġitḷusri naalaġniyummataitchusri.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jew-ŋuruat kiuniġaat Jesus, “Uvagut nalauttugut nipliqapta ilvich Samaria-ġmiunipḷutin suli tuunġaqtaqaqhutin.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus kiuniġai, “Uvaŋa tuunġaqtaqanġitchuŋa. Aapaga kamagikkaġigiga aglaan kamakkutaitchipsitña. ");
INSERT INTO eskNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pakkiaġinġitchiga kamagikkaułiksraq uvapkuiñaq, aglaan atlam pakkiaġigaa kamanaqtitaułiksraġa, aasrii ilaa atanġuruq. ");
INSERT INTO eskNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iḷumutuuruamik nipliutigipsi, kisupayaam uqauttutitka tupigigumigich tuquyumiñaipiaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jew-ŋuruat kiuniġaat, “Pakma nalupqiginġiġikput tuunġaqtaqałhiñ. Abraham sivuniksriqirillu tuqumarut, naagasuli uqaqtutin, kisupayaam tupigikpagu uqauttutin tuquyumiñaipiaġnipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Uvagut sivulliaqput Abraham tuquaniksimaaqtuaq sulipsuuq sivuniksriqiripayaatlu. Kamanatlukkumavich Abraham-miñ? Kisuunasrukniaqpiñmiuvva ilvich?” ");
INSERT INTO eskNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus kiugai, “Uvapkuiñaq kamakkutiqaġniaġuma suutnauyumiñaitchuq. Aapamnik kamagiriqaqtuŋa, taavrumiŋa ilipsi Agaayyutiginitchapsitñik. ");
INSERT INTO eskNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Aasriisuli iḷitchuġianiksimaitchiksi, aglaan uvaŋa iḷisimagiga Agaayyun. Uqaġuma Ilaa naluniḷugu sagluturuaŋuniaqtuŋa ilipsisun. Aglaan iḷisimallapiaġiga aasriiñ uqałha tupigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham-ŋum sivulliapsi ukpiqsrił̣iġmigun kaŋiqsipḷugu aggiġisił̣iġa nunamun quviatchautigikkaŋa suli qiñiġummiuqługu taimña uvluġa. Arguaqqutaiḷḷapiaqługu aggiġisił̣iġa ilaa quviasruktuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jew-ŋuruat kiuniġaat, “Malġukipiaq qulinik ukiuniksimaitchutinsuli aasiiñ qiñiqsimaniviuŋ Abraham?” ");
INSERT INTO eskNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus kiugai, “Iḷumutuuruamik nipliutigipsi, Sivuaniunniiñ Abraham-ŋum anił̣iksraŋan, inŋaniktuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tamatkua tigusriñiqsut iyaġaŋnik miḷuqtuġukługu, aglaan Jesus iriġniqsuq aasriiñ anipḷuni Jew-ŋuruat agaayyuvikpaŋatniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus pisruksaałiġmiñi qiñiġniqsuq aŋutmik ayauŋaniqsuamik aniḷġatałiġmiñiñaglaan. ");
INSERT INTO eskNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Maliġuaqtaiñ apiqsruġniġaat, “Iḷisautrii! Kia killuqsautaan anił̣haniñ ayauŋapkaġniqpauŋ? Ilaan naagaqaa aŋayuqaakkiñ killuqsautaaknik?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus-ŋum kiugai, “Taavruma ayauŋałha kaŋiqanġitchuq ilaan killuqsałhanun unniiñ aŋayuqaakkiñ killuqsałhaknun. Ayauŋaruq Agaayyutim saŋŋia qiñiġnaqtitquplugu ilaagun. ");
INSERT INTO eskNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Savaaġiraksraġigikput sivutmun piyumiñaġnaptikni. Unnuaq tikiññiaqtuq, kia-unniiñ savagvigiyumiñaisaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Uvaŋa maani nunami innamni qaumaksrauruŋa nunam iñuiñun.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Taatnaanikami Jesus-ŋum tivvuaqhuni nunamun akurrutiniġaa maġġamun, aasriiñ nanukługik maġġamik taavruma aŋutim irrak, ");
INSERT INTO eskNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","nipliutiplugu, “Aullaġutin iġġuġiaġuŋ kigiñan narvauraŋanun Siloam.” (Taamnaguuq mumiutiqaqtuaq Tuyuułiġmik.) Taamna aŋun aullaqhuni, kigiññi iġġuġiaqamiuŋ utiġniqsuq qiñitlasripḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iñuuniaqataiñ suli tamatkua qiñiqtikaaŋiñ iŋiularaupman apiqsruqtautiaqsiñiqsut, “Unauvva taimñaunġitpa aŋun aquppipḷuni iŋiulayuk?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iḷaŋisa taivrumiŋaunigaat. Iḷaŋiḷḷi nipliġñiqsut, “Qaŋaa! Taivrumiŋaunġitchuq, taatnatun qiññaqaqsiñaqtuq.” Taamna aŋun iŋmiñik nipliġñiqsuq, “Taimñauruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tamatkua apiqsruġniġaat, “Qanuqhutinmi qiñitlasripkakkauvich?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ilaan kiugai, “Iñuum atiqaqtuam Jesus-mik irrakka maqatlamik nanuqqaaqługik aasriiñ tiligaaŋa Siloam-mun iġġuġiaquplugu kigiñaġa. Tarra aullaqtuŋa, aasriiñ iġġuqsaġluqqaaqtuŋa qiñitlasriruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Taapkua apiqsruġniġaat, “Naamiimmami ilaa?” Kiuniġai, “Naluruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tamatkua taamna aŋun qiñitlaisimaruaq aullautiniġaat Pharisee-ŋuruanun. ");
INSERT INTO eskNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tamannaguuq uvluq Jesus-ŋum maqatlamik nanukługik aŋutim irrak pił̣ha qiñitlasritquplugu Jew-ŋuruat minġuiqsiaġviginiġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tarra Pharisee-ŋuruat apiqsrulgiññiġaat qanuqhuni qiñitlasripmaŋaan. Aasrii uqautiniġai, “Taivruma maqatlatiqługik irrakka, iġġuqapku kigiñaġa pakma qiñitlasriruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisee-ŋuruatguuq iḷaŋich nipliġñiqsut, “Taimña iñuk taatnaiḷipḷugu iñiqtaqaqtuaq Agaayyutmiqnisaunġiññiqsuq, takku atuqtaksraq minġuiqsiaġvikun tupikkutaiñiġaa.” Atlatli nipliġñiqsut, “Qanuġunimi iñuk killuliqirauruaq iñiqtaqatlagisiva taatnatchiñik quviqnaqtuamik savaanik?” Taapkua igḷugiiksinniqsut taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pharisee-ŋuruat apiqsrutqiḷgiññiġaat taamna aŋun, “Qanuġli nipliutigitlanayaqpiuŋ ilaa qiñitlasripkaġnipḷutin?” Taavruma kiuniġai, “Sivuniksriqirauruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jew-ŋuruat ukpiqqutiqaġumanġiññiġaat qiñitlaił̣iġmiñiñ qiñitlasrił̣ha. Kiisaimma tuqłuqpaich taavruma aŋutim aŋayuqaak. ");
INSERT INTO eskNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iliŋisa apiqsruġniġaich, “Una iġñiġivitchu? Nipliutigitlavitchu animałha ayauŋapluni? Qanuqhunimi qiñitlasriva pakma?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aŋayuqaakkiñ kiuniġaich, “Uvaguk iḷisimagikpuk ilaa iġniġikkaqpuk suli iḷisimagikpuk anił̣iġmiñiñaglaan ayauŋałha. ");
INSERT INTO eskNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Aglaan nalugikpuk qanuqhuni pakma qiñitlasrił̣ha, naagaqaa nalugikpuk kimun qiñitlasripchałha. Ilaa iñuguaniksimaaqtuq suli kiggutitlasrimaaqtuq iŋmiñun. Apiqsruqtaqsiuŋ.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aŋayuqaaŋuruak taatna nipliġñiqsuk iqsikkutiqaqhutik Jew-ŋuruanun, takku sivunnianiksimaaqtut kia iñuum nalupqinaiġḷugu uqaġikpagu Jesus Christ-ŋuniḷugu anitkisipḷugu katraġviŋmikniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Taatnaqhutik taapkuak aŋayuqaaŋuruak nipliġñiqsuk, “Ilaa iñuguaniksimaruq, apiqsruqtaqsiuŋ!” ");
INSERT INTO eskNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tugliḷiqł̣ugu tuqłulgiññiġaat iŋmiknun taimña aŋun animaruaq ayauŋapluni aasriiñ nipliutiplugu, “Agaayyutim sivuġaani akiqsruġiñ iḷumutun uqaġisił̣ł̣apkun. Uvagut iḷitchuġigikput taimña uisitin killuliqiraułha.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Taavruma kiuniġai, “Ilaan qanusriułha nalugiga. Atausriq iḷisimagiga, uvaŋa ayauŋagaluaqtuami pakma qiñitlasriruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Taapkua apiqsrutqiḷgiññiġaat, “Qanusriġaqhutin qiñitlasripkaqpatin?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kiuniġai, “Uqautianikkaluaġipsi aglaan naalaġnisunġitchusri. Suvaatami tusraatqiguaqsiḷgitpisiuŋ? Naaga maliġuaqsiutisrukpisi ilaanun?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tamatkua kiuniġaat uqaniġluutiplugu, “Ilvich taivruma maliġuaqtigiliutigaatin. Uvagut Moses-ŋum pigigaatigut. ");
INSERT INTO eskNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Iḷisimagikput Agaayyutmun uqautrułha taimña Moses, aglaan nalugikput tamanna iñuk nakiñ aggiqsilaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Taavruma aŋutim kiuniġai, “Atlayuaġnarruqtugalukkut nalunikapsiuŋ nakitñaqtaułhagun, aglaan qiñitlasripkaġaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Iḷisimagikput, Agaayyutim naalaġnitḷaił̣ha killuuruanun, aglaan naalaġniraġigai kamagirini suli tupiksriruat pisułiġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunam aullaġniisaġatałhaniñ tusraanġaqsimaitchut iñuŋmik qiñitlasripkakkauruamik ayauŋapluni animaruamik. ");
INSERT INTO eskNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kisianik taimña iñuk aggiqsuaŋuluni Agaayyutmiñ pigumi avataagun sumik iñiqtaqalguyumiñaitmiuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tamatkua kigguqłuŋniġaat, “Animagaluaqtutin killukun iñukkuksaaŋuplutinlu aglaan iḷisautniagaqsivisigut?” Taatnaqqaaqługu iliŋisa aninniġaat katraġviŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus tusraaniġaa ilaa aninnipḷugu. Paqitnamiuŋ nipliutiniġaa, “Ukpiġiviuŋ Iġñiŋa Iñuum?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Taavruma Jesus kiuniġaa, “Uqautiŋŋa kisuutilaaŋanik. Uvaŋali ukpiġiyumigiga ilaa.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus nipliutigaa, “Ilvich qiñianiksimaaġiñ, suli ilaaŋuruq pakma uqaqatin.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Ataniiq! Uvaŋa ukpiġigikpiñ,” taamna nipliġñiqsuq, aasrii sitquqhuni sivuġaanun Jesus-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus nipliġñiqsuq, “Aggiġñiqsuŋa nunamun pisigiplugu atanniqsuił̣iksraq, ayauŋaruat qiñitlasripkaġlugich, suli qiñitlanasrugiruat ayaupkaġiaqługich.” ");
INSERT INTO eskNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Iḷaŋisaguuq Pharisee-ŋuruat tarani ittuat tusraa'amitruŋ taatna nipliqman apiqsruġniġaat, “Uvaguttuuq qiñitlaitchuaġivisigut?” ");
INSERT INTO eskNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus-ŋum kiugai, “Ilipsi qiñitlaitchupsi killuutaiññiaġaluaqtusri, aglaan qiñitlaruaġiplusri ilipsitñik killuutiqaġugaaqtusri.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iḷumutuuruamik nipliutigipsi, “Iñuk isinġitchuaq ipnaiqaġvium taluagun, aglaan mayuaqtaqtuaq atlakun tigliŋniaqtauruq ivayaqtuqtaupluniḷu. ");
INSERT INTO eskNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aglaan isiġaqtuaq talukun ipnaich munaqsrigiraġigaat. ");
INSERT INTO eskNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Taluliqirim taluiġutiraġigaa. Ipnaich tusraaraġigaat nipaa tuqłuġaqmatiŋ atiġmiktigun, aasrii ilaan annisiraġigai. ");
INSERT INTO eskNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Annisianikamigich sivulliuġaġigai aasrii ipnaich malikługu nipaa iḷisimaplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tamatkua atlamik maliutritḷaitchut, aglaan qimagaġigaat nipaa iḷisimanġitḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus atrikusrautmik uqautipmatiŋ, iliŋisa kaŋiqsiñġiññiġaat sumik uqautitilaaqtiŋ. ");
INSERT INTO eskNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus nipliutitqiŋñiġai, “Iḷumutuuruamik nipliutigipsi, Uvaŋa taluuruŋa ipnaiñi. ");
INSERT INTO eskNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Atlakauplutiŋ sivumni tikiaruat iluqatiŋ tigliŋniaqtaurut ivayaqtuqtauplutiŋḷu aglaan ipnaich naalaġnisaitchaich tamatkua. ");
INSERT INTO eskNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Uvaŋa taluuruŋa. Kisupayaaq isiġumi uvapkun anniqsuġisiruq; ilaa isiqtuni naagaqaa aniruni paqittaġnaqtuq niqiksraq. ");
INSERT INTO eskNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tigliŋniaqti tikitchaqtuq kisianik tigligiaqhuni tuqqutchityaqhuni unniiñ piyaqquqtaityaqhuni. Uvaŋali aggiqsuŋa tamatkua iñuich iñuułiġmik piññaquplugich inuŋaiḷḷapiaġlugu. ");
INSERT INTO eskNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Uvaŋa munaqsriḷḷautaġigaatŋa ipnaich. Munaqsriq nakuuruaq tuquyummatiqaqtuq ipnaiñik piqusriġuni. ");
INSERT INTO eskNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Akiññaŋniaqtim munaqsriŋunġitchua ipnaich piginġitchai. Unitḷugich qimagaqtuq qiñiqami amaqqumik aggiaqsiruamik. Amaqqumaasrii kiŋmaqługich siamitkaqsipḷugich tamatkua ipnaich. ");
INSERT INTO eskNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Akiññaŋniaqti iñuk qimagaqtuq akiññaŋniaqtaułhiñałiġmigun. Suksraġinġitchai ipnaich. ");
INSERT INTO eskNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Uvaŋa ipnaich munaqsraat nakuuruaq. Iḷisimmaaġitka ipnaitka suli iliŋisa uvaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Taatnatun Aapam iḷisimałha uvamnik, uvaŋaptuuq Aapa iḷisimagiga. Uvaŋa piyummatiqaġiga tuqułiksraġa piqutigilugich. ");
INSERT INTO eskNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aasrii atlattuuq ipnaich pigigitka munaqsriviŋmi uvaniinġitchuat. Tikiutraksraġitmigitka, aasriiñ naalaġniñiaġaat nipiga. Tarra atautchiiñaġuġniaqtut ipnaich suli munaqsriri atautchiiñamik. ");
INSERT INTO eskNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Aapam piqpagigaaŋa tuqqutriyumałłapkun piqusriġḷuŋa iñuŋnik, aasriiñ tuqqutauŋanikkuma iñugutqikkił̣hitchuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kia-unniiñ tuqqutchumiñaitchaaŋa nunuriḷuŋa. Uvapkuiñaq qaisaġigiga pisułłapkun, qaił̣hiñaaġiplugu suli satułhiñaaġiplugu. Taamna tillisiaġikkaġa Aapaaniñ atuqugiga.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tarani Jew-ŋuruat atinġiḷgiññiqsut piqusriqhutiŋ tamatkuniŋa uqauttutinik. ");
INSERT INTO eskNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iñugiaktuat niplianiqsut, “Ilaa tuunġaġmik piqaġniqsuq, kinniqiruq. Suvaata naalakpisiuŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Atlatli niplianiqsut, “Iñuk tuunġaqtalik uqaġumiñaitchuq taatna. Qanuġuni tuunġaqtalik qiñitlasripkaigisiva ayauŋaruamik?” ");
INSERT INTO eskNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ilgiññiqsuq niġiqpagvikaaq Jerusalem-mi. Itqauttutiginiġaa Jew-ŋuruat agaayyuvikpaŋat aŋmalgitqikman taimani qaayuġnaiŋanikmagich. ");
INSERT INTO eskNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus pisruksaaġniqsuq Jew-ŋuruat agaayyuvikpaŋatni Solomon-ŋum Quliġutaanik taggisiliŋmi. ");
INSERT INTO eskNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aasriiñ Jew-ŋuruat avataanun kati'amiŋ nipliutiniġaat, “Qanutun taktigiruami naliġutitchaaqsivisigut? Iḷumutun uqauttutigut, Ilvich Christ-ŋuvich?” ");
INSERT INTO eskNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus kiugai, “Uqautianikkaluaġipsi, aglaan ukpiġinġitchipsitña. Savaat iñiqtaġikkaġma Aapaa saŋŋiqutaagun uqautigigaatŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aglaan ukpiġinġitchipsitña atakkii ipnaiġinġitḷusri. ");
INSERT INTO eskNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Uvaŋa ipnaima nipiga naalagaġigaat, uvaŋa iḷisimaplugich, iliŋisa malikłuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iñuułiġmik isruitchuamik qaitchigitka, iliŋich tuquyumiñaiqł̣ugitunniiñ. Kia-unniiñ ivayaaġiyumiñaitchai uvaŋniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sua Aapaa qaiñŋanikkaŋa uvaŋnun kamanatluktuq iluqaaniñ. Kia-unniiñ ivayaaġiyumiñaitchaa Aapam qaunakkutaaniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aapagalu atausriuruguk.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jew-ŋuruat iyaġaŋnik tigusritqiḷgiññiqsut miḷḷuuġukługu. ");
INSERT INTO eskNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus nipliutiniġai, “Sivuqqapsitñi uvaŋa savaaqaqtuami iñugiaktuanik savaallautanik Aapam uvaŋnun iñiqtaġitqukkaŋiñik, nalliatigun tamatkua miḷuqtuġukpisitña?” ");
INSERT INTO eskNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jew-ŋuruat kiuniġaat, “Savaallautatigun miḷuqtuġunġitchiptigiñ, aglaan sagluuqtuaġutiqałłapkun, takku iñułhiñaugaluaqhutin uqaqtutin ilipnik Agaayyutaunipḷutin.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus kiugai, “Maliġutaksraġikkapsitñi aglausimaruq, ‘Agaayyun nipliġñiqsuq, Ilipsi agaayyutaurusri.’ ");
INSERT INTO eskNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kaŋiqsimagivut uqałhich aglausimaruat iḷumutuugisiłhat taimuŋa. Agaayyutim taiñiġai agaayyutinik taipchua iñuich akuqtuiruat uqałiġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Uvaŋali tigusriaġipluŋa Aapam tuyuġikkaġigaaŋa nunam iñuiñun, qanuqhusrimi nipliavisi saglupluŋa uqaġniġluutigiñipḷugu Agaayyun nipliqama iġñiġinipḷuŋa Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ukpiġinaŋa savaaqanġitchuma Aapaa savaaŋiñik, ");
INSERT INTO eskNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","aglaan savaaġiniġupkich, ukpiġiñġitchaluaġupsitñaunniiñ, savaaġikkatka ukpiġiraksraġigisri. Taatnaġupsiuŋ kaŋiqsiñiaqtusri nalupqisrunġiġḷusri Aapam uvamniitilaaŋanik suli uvaŋa Aapamniitilaamnik.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Taapkuaguuq tiguyumatqiaqsiḷgiññiġaat aglaan annalgiññiqsuq iliŋisa argaŋitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus utilgiññiqsuq Jordan kuuk ikaaqługu taivruma John paptaaġivianun, aasrii tarani itkaqsipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Iñugiaktuat iñuich tikiagaqsiñiġaat avatmun itnaqhutiŋ, “John taimña iñiqtaqanġitchaluaqtuq quviqnaqtuanik aglaan uqauttutipayaaŋa uumuuna iñukun iḷumutuuruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Taatnaqhutiŋ iñugiaktuam iñuum ukpiġiniġaa Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iñuk Bethany-mi iñuuniaqtuaq atiqaqtuaq Lazarus-mik atniġñaliġñiqsuq. Taamna Bethany nunaaqqiuraq nukaġiik Mary-mlu Martha-mlu irviak. ");
INSERT INTO eskNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Taamnaguuq Mary taimña kuviriruaq tipraġiksaumik Atanġum isigaiñun aasrii allaqługich nutchamiñik. Taavruma aŋutnunġa Lazarus atniġñaliġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nukaġiik aġnak tuyuqaġniqsuk Jesus-mun kilgutmik itnaqługu, “Ataniiq, iḷauraannan piqpagikkan atniġñaliqsuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus tusraa'ami nipliqsuq, “Taamna atniġñaq isruqanġitchuq tuqułiġmun. Atuummigisiruq kamagikkaułiksraŋanun Agaayyutim, aasriiñ Agaayyutim Iġñiŋa kamanaqsikkautquplugu taavrumuuna atniġñakun.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus-ŋum piqpagigai Martha-lu aniqataalu Mary Lazarus-lu. ");
INSERT INTO eskNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ilaan tusraa'amiuŋ Lazarus atniġñaġnipḷugu, irviŋmiñi ittuallapsaaġniqsuq malġuŋni uvluŋni. ");
INSERT INTO eskNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tarakŋa maliġuaqtini nipliutiniġai, “Ki, utitqiḷḷakta Judea-mun!” ");
INSERT INTO eskNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Maliġuaqtaiñ kiuniġaat, “Iḷisautrii! Uvvaquyuuraqnaami Jew-ŋuruat iyaġaŋnik miḷuqtuġniaġugaatin, utiġnialgitpiñmi taamuŋa?” ");
INSERT INTO eskNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus nipliqsuq, “Uvlum qaumaniŋa sassaqanġitpa qulit malġuŋnik? Iñuk uvlum qaumaniŋani igliġumi putukkitchumiñaitchuq, atakkii qiñiqługu siqiñġum qaummataa marruma nunam. ");
INSERT INTO eskNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Aglaan unnuam taaqtuami igliġumi, putukkitkisiruq piiḷḷuni qaumamik.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesus taatnaqqaaqługich nipliġñiqsuq, “Iḷauraaqput Lazarus siñiksaqtuq, aglaan iqiiqsitchaqtuġniaġiga.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Maliġuaqtaiñ kiuniġaat, “Ataniiq, siñikkumi iłuaqsiñiaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aglaan Jesus piñiqsuaq Lazarus tuqunipḷugu. Taapkua isrumaniqsut uqaġasrukniaqługu siñiksapiaqtuamik. ");
INSERT INTO eskNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesus nipliutiniġai nalupqinaiqł̣ugu, “Lazarus tuquruq. ");
INSERT INTO eskNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aglaan piqutigiplusri, quyaruŋa taamani inġił̣ł̣apkun, ukpiqsrisiñiquplusri pitḷuglugu. Utlaglakput!” ");
INSERT INTO eskNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas, taiyuutilik Malġimik, nipliġñiqsuq maliġuaqtauqatmiñun, “Ki! Iḷisautrii, piqasriġḷakput! Uvagullu tuquqatigiyumigikput!” ");
INSERT INTO eskNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus tikitñami, iḷitchuġiniġaa Lazarus iḷuviqtauŋaniksimaplugu sisamani uvluni. ");
INSERT INTO eskNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany-guuq uŋasriguni inġiññiqsuq Jerusalem-miñ. Sivisutilaaqaġniqsuq malġuktun mile-laksrayuŋnatun. ");
INSERT INTO eskNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aasriiñ Jew-ŋuruat iñugiaktuat aggiġñiqsut, Martha-lu Mary-lu qiñiġiaqługik araaqtuġiaqługik aniŋauraŋaknik tuqułhagun. ");
INSERT INTO eskNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha-m tusraa'amiuŋ Jesus aggiaqsipḷugu anipḷuni paaġniġaa. Aglaan Mary aimmiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha-m Jesus nipliutigaa, “Ataniiq! Uvani itchuvich, aniŋauraġa tuqunayaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aglaan iḷisimagiga, pakmaunniiñ Agaayyutim qaitchitḷagaatin, qanusripayaamik iŋiġuvich iŋmiñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus-ŋum nipliutigaa, “Aniŋauran aŋipchakkaugisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha-m nipliutigaa, “Kaŋiqsimagiga Ilaan aŋipchakkaugisił̣ha aqulliġmi uvlumi.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus-ŋum nipliutigaa, “Uvaŋa aŋitqigviuruŋa suli iñuułhupluŋa. Kisupayaaq tunŋapluni ukpiqsriruaq uvamnik iñuugisiruq tuquŋagaluaqtuaqunniiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Suli kisupayaaq iñuuruaq ukpiqsripḷuni uvamnik tuquyumiñaipiaqtuq. Taamna ukpiġiviuŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha-m kiugaa, “Aa! Ataniiq! Ukpiġigiga Christ-ŋułhiñ, Agaayyutim Iġñiġiplutin, aggiqsuksrautauruaq nunamun.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha taatnaqqaaqhuni utiġniqsuq, aasrii Mary aniqatni tuqłuqługu nalunaitchipḷuni, “Iḷisautri aggiġñiqsuq, amma utlaqugaatin.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary-m tusraa'amiuŋ iġñiqsruqhuni paaġiaġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus-suli tikiñŋaniksimaitḷuni nunaaqqimun aglaan itluni taivrumani Martha-m paaġiviani. ");
INSERT INTO eskNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jew-ŋuruatguuq tarani Mary-m tupqani ittuat araaqtuġniaqługu qiñiqamitruŋ makitluni aniaqsiḷiqman, isrumaniqsut iḷuviġmun qiatyaaqsiñipḷugu aasrii aniqasriqł̣ugu. ");
INSERT INTO eskNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary-m tikitḷugu Jesus qiñiqamiuŋ isigaiñun punniqsuq nipliqhuni, “Ataniiq! Uvani itchuvich, aniŋauraġa tuqunayaitchuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus-guuq qiñiqamiuŋ Mary kiñuvġuruaq qiapluni tamatkualu Jew-ŋuruat tuvaaqataiñ qiaqasriqł̣ugu, ilaaptuuq iłuiḷḷiullapiaġniqsuq Irrutchiġmiñi iḷunŋutchakhuni. ");
INSERT INTO eskNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Apiqsruġniqsuq, “Napmunimma iḷuviqpisiuŋ?” Taapkua kiuniġaat, “Ataniiq! Maliguta qiñiġiaġuŋ!” ");
INSERT INTO eskNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus-tuuq qulviruq. ");
INSERT INTO eskNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jew-ŋuruat qiñiqamitruŋ nipliġñiqsut, “Qanutun atqunaq piqpagitigigaluaġniqpauŋ!” ");
INSERT INTO eskNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aglaali iḷaŋich nipliġñiqsut, “Uvva uuma qiñitlasripchaitḷaruam ayauŋaruam irraknik tuqqutchaiḷiyumiñaiññayaġniqpauŋ Lazarus, amaġaa?” ");
INSERT INTO eskNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iłuiḷḷiullapiaqhuni Jesus utlautiniqsuq iḷuviġmun inillaksimaruamun sisitun ittuamun taluplugu iyaġakpaŋmik. ");
INSERT INTO eskNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus tiliñiġai, “Iyaġak piiqsiuŋ!” Martha nipliġñiqsuq tuquruam aġnaunġa, “Ataniiq! Tipliġuŋnaqsiruq. Sisamani uvluni iḷuviqtuaŋaniksimaruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus nipliutigaa, “Uqautianikkugaakpiñ, ukpiqqutiqaġuvich qiñiġayaġniqsutin Agaayyutim kamanautaanik.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tarakŋa tamatkua iñuich iyaġak piiqmatruŋ, Jesus aaġluqhuni nipliġñiqsuq, “Aapaaŋ! Quyagikpiñ tusraaraġi'apŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iḷisimaruŋa ataramik naalaġnigikma. Taamna nipliutigigiga piqutigiplugich makua iñuich qichaqtuat uvani ukpiqsritquplugich tuyuqałłapkun uvamnik.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Taatnaanikami nipitusripḷuni tuqłuġniqsuq, “Lazarus, anniiñ!” ");
INSERT INTO eskNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tuquŋaruaq aniñiqsuq iḷuviqsisinik nimiqsruqtat argai isigaiḷḷu kigiñaŋalu. Jesus nipliutiniġai, “Qiḷġutaiġḷugu aullaqtitchiuŋ.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jew-ŋuruat iñugiaktuat Mary-muqattaaqsimaruat qiñiqługu Jesus iñiqtaŋa, turvigiplugu ukpiġiagutriñiqsut ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aglaan iḷaŋich Jew-ŋuruat Pharisee-ŋuruanun utiġniqsut, aasrii uqautiplugich Jesus iñiqtaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Taatnaqhutiŋ Pharisee-ŋuruatlu qaukłiŋiḷḷu agaayuliqsit kattutriñiqsut uqaqsittaaqtitchirinik uqaqatigiigukhutiŋ itnaqhutiŋ, “Qanuġisivisa quviqnaqsipḷugu savaaŋigun taivruma iñuum iñiqtaigun?” ");
INSERT INTO eskNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Ilaatuuqtitchuptigu taatna iñupayaam ukpiġiagutigisigaa. Aasriiḷi Rome-maġmiut qaukłiŋich piyaqquġisigaat agaayyuvikpakput suli nunaaqqiqput.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Taapkua iḷaŋarguuq atiqaqtuaq Caiaphas-mik, qaukłiupluni agaayuliqsi tamarrumani ukiumi, nipliġñiqsuq, “Kaŋiqsimaiḷġataqtusri! ");
INSERT INTO eskNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iḷisimanġitpisiuŋ iłuatlułha uvaptiknun atautchim iñuum tuqqutaułha piqusriġuni iñuŋnik uumakŋa iluqaġmi nunaaqqim piyaqqukkaułhaniñ?” ");
INSERT INTO eskNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Taatnaguuq nipliñġiññiqsuq iŋmiñiłhiñaq, aglaan qaukłiupluni agaayuliqsaupluni tamarrumani ukiumi, ilaan sivuniksriqiginiġaa Jesus-ŋum tuqqutrił̣iksraŋa Jew-ŋuruanik, ");
INSERT INTO eskNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","taapkuniŋałhiñaunġitchuaq aglaan atausriġuqtitchitqiguni aŋayuqaaġiisun iluqaitñik siammayaaqsimaruanik ukpiqsriruanik Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Taatnaqhutiŋ tamarrumakŋa uvlumiñaglaan Jew-ŋuruat qaukłiŋich sivunniuġniqsut, qanuġlugu tuqqutchukługu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Taatnaqhuni Jesus igliġatqiñġiññiqsuq sagviḷuni Judea-mi. Aglaan aullaġniqsuq nunamun qanittuamun suviksraiḷaamun nunaaqqimun atiqaqtuamun Ephraim-mik, aasrii tarani itkaqsipḷutiŋ maliġuaqtiniḷu. ");
INSERT INTO eskNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jew-ŋuruat niġiqpagvikaaŋat taggisiqaqtuaq Apqusraaqtitaułiġmik qalliñiqsuq, aasrii iñugiaktuat iñuich nunamiñ utlautipluni Jerusalem-mun niġiqpagvikaam sivuani itqanaiyaġiaqhutiŋ, qaayuġnaityaqhutiŋ iŋmiknik maliglugu maliġutaksraq. ");
INSERT INTO eskNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iñuich niġiuŋniqsut Jesus-mik, Jew-ŋuruat agaayyuvikpaŋatnun kati'amiŋ apiqsruqtautiplutiŋ, “Qanuġli isrumavich? Nalupqinaitchuq utlautigisuknaitchuq niġiqpagvikaamun taavrumani.” ");
INSERT INTO eskNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Qaukłiŋich agaayuliqsit Pharisee-ŋuruatlu tiliriñiqsuat kia iñuum iḷitchuġikpagu naniitilaaŋa Jesus kilgutigitquplugu iliŋisa tigusrukługu. ");
INSERT INTO eskNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Itchaksrat uvlut sivuatni niġiqpagvikaam taggisiqaqtuam Apqusraaqtitaułiġmik Jesus utlautiniqsuq Bethany-mun, Lazarus iñuuniaġvianun, taimña Jesus-ŋum aŋipchakkaŋa tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nullautchiuġutiniġaat Jesus tarani. Martha-m savautigai Lazarus aquppiqataupkaqługu Jesus-mi niġġiviŋñi. ");
INSERT INTO eskNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aasriiñ Mary-m tigusripḷuni akisullapiaqtuamik tipraġiksautmik kuvviqiniġai Jesus-ŋum isigai, aasrii nutchamiñik allaqługich. Naimasruġnaqtuam tipraġiksautim immiġñiġaa iluqaan tupiq. ");
INSERT INTO eskNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jesus maliġuaqtaiñ iḷaŋat, Judas Iscariot, taimña tunisirauksraq Jesus-mik, nipliġñiqsuq, ");
INSERT INTO eskNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Suvaata tipraġiksaun tunikkaunġitpa piñasrunun kavluutinun maniŋñun, qaisauluniasriiñ inuqsraqtuanun?” ");
INSERT INTO eskNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Taatnaġniqsuq pigaqatlułikuunġiḷaaq inuqsraqtuanik, aglaan ilaa tigliktuqtaupluni; maniqaġviat akiyaġikkani piksraqtuġvigiraqniġaa. ");
INSERT INTO eskNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus nipliqsuq, “Iḷaksianagu aġnaq! Ilaan pigiliuŋ iḷakuni taivrumuŋa uvluanun iḷuviqtuaviksraġma. ");
INSERT INTO eskNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ilipsi ataramik piqaġniaqtusri inuqsraqtuanik iñuŋnik, aglaan nayuutiyumiñaitchuŋa ataramik.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iñugiaktuarguuq Jew-ŋuruat tusraaniġaat Jesus iłha Bethany-mi aasriiñ taamuŋaqhutiŋ, pisigisruŋaqnagu Jesus kisian aglaan Lazarus qiñiġiaġukługu, Jesus-ŋum aŋipkakkaŋa tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Taatnaqługu qaukłiŋich agaayuliqsit sivunniuqmiñiqsut tuqqutchukługuptuuq Lazarus; ");
INSERT INTO eskNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","atakkii ilaa piqutigiplugu Jew-ŋuruat iñugiaktuat unitkaqsiñiġaich qaukłiisiŋ ukpiġiagutripḷutiŋ Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Uvlutqikman, iñugiakpauraqtuat utlautiruat niġiqpagvikaamun taggisiqaqtuaq Apqusraaqtitaułiġmik tusraaniqsut Jesus Jerusalem-mun aggiaqsipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iliŋich Palm napaaqtuŋitñiñ akiġuksraqhutiŋ paagaqsiñiġaat nipliaplutiŋ, “Hosanna. Nanġaġlakput Agaayyun! Uvvatuq Agaayyutim piḷiutiqaġliuŋ tikitchuaq piqusriqhuni Ataniġmik, Agaayyutim piḷiutiqaġliuŋ Israel-aaġmiut Umialgat!” ");
INSERT INTO eskNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus paqitluni natmaksiġviŋmik natmaksiaġniqsuq uqałhich aglausimaruatun, itna, ");
INSERT INTO eskNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Israel iñugikkaŋasri, Iqsiñasri! Umialigikkapsi aggiqigaasri, natmaksiġvium nuġġaŋani usriaqsiaqhuni.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tarani maliġuaqtaiñ kaŋiqsiñġiññiġaat taamna; aglaan Jesus aŋitqianikman pakmuŋaanikhuni, iliŋisa itqaġniġaat aglausimaruam uqałhum taatnaqsimałha, suli itqaqmigaat iñuich immiutiłhat taivrumuŋa uqauttutmun. ");
INSERT INTO eskNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iñugiaktuarguuq nayuutiruat Jesus-mi Lazarus-mik iḷuviġmiñ tuqułiġmiñ aŋitqiksitman, tusraayugaaqtirrutiginiġaat tamanna atuumaaniktuaq. ");
INSERT INTO eskNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Taatnaqhutiŋ iñugiaktuat Jesus paaġniġaat, atakkii tusraaŋanikhutiŋ ilaa savaktilaaŋanik taavrumiŋa quviqnaqtuamik. ");
INSERT INTO eskNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pharisee-ŋuruatguuq avatmun uqaaqsiñiqsut, “Uvagut piġunġiḷḷapiagaqsirugut! Takkua, iñupayaat iluqatiŋ maliutigaat!” ");
INSERT INTO eskNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iḷaŋitguuq Jew-ŋunġitchuat akunġuruat tamatkunani Jerusalem-muktuani kamaksrityaqhutiŋ Agaayyutmik niġiqpagvikaami. ");
INSERT INTO eskNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tikiññiqsut Philip-mun Bethsaida-ġmiumun Galilee-mi, uqaqhutiŋ, “Aŋuun! Uqaqatigillagukkaluaġikput Jesus.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip-ŋum uqautityaġniġaa Andrew, malġuuplutikaasrii uqautityaġniġaak Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus kiuniġik, “Tuqqutauviksraġa tikiumaruq, sivuniqaqtuaq Iñuum Iġñiŋan atqunaq kamagikkaułiksraŋanun. ");
INSERT INTO eskNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Uvaŋa iḷumutuullapiaqtuamik uqautigipsi, mukkaaksram nautchiaksraŋa suunġitchuq kisianik kataktitau'ami nunamun tuqupluni. Taatnaiḷipḷugu tuquanikami tikiutriraqtuq iñugiatluktuanik nautchiaksranik. ");
INSERT INTO eskNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kisupayaam iñuułłi piqpagigumiuŋ tammaigisigaa. Aglaan kisupayaam iñuułłi piqpaginġitchumiuŋ nunami marrumani pigigisigaa isuitchuamun taimuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kisupayaam savautisrukkumiña maliktaksraġigaaŋa, aasrii sumiitchuma tarani savaktiga inniaqmiuq. Kiapayaaq savautikpaŋa Aapam kamanaqtitkisigaa. ");
INSERT INTO eskNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Pakma uummatiga iłuiḷḷiuġniqsuq. Qanuq nipliġisivik? Nipliġayaqpik itna, ‘Aapaaŋ! Tikiumapkaqnagu taamna nagliksaaqsiułiq uvaŋnun?’ Taatnaġnianġitchuŋa, takku taamna piqutigiplugu aggiqsauŋuruŋa apqusraaġiaqługu taamna nagliksaaqsiułiq. ");
INSERT INTO eskNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aapaaŋ! Kamanaqtirruŋ atqiñ!” Taatnaqman nipi nipliqsuq qiḷaŋmiñ, “Uvaŋa kamanaqtinŋanikkiga, suli kamanaqtitqikkisipḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iñugiaktuam iñuum qichaqtuam tarani nipi tusraaniġaa aasrii nipliqhutiŋ, “Katlularuq!” Atlatliguuq nipliqsut, “Israġulgum uqaqatigigaa ilaa.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aglaan Jesus-ŋum nipliutiniġai, “Uvaŋa piqutigiluŋa taamna nipi tusaġnanġitchuq, aglaan ilipsi. ");
INSERT INTO eskNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pakma tikiumaruq nunam iñuiñ atanniusriaqałiksraŋat. Tuunġaq, nunam marruma aŋalataa akiiḷirauniaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aasrii kivikkauguma marrumakŋa nunamiñ nuqitkisigitka iluqaisa iñuich uvaŋnun.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Taatnaqamiguuq uqautiginiġaa qanuq tuqqutauluni nagliksaałiksrani. ");
INSERT INTO eskNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iñugiaktuat iñuich kiuniġaat, “Maliġutaksraġikkapta uqausrimagaatigut, Christ iñuugisiñipḷugu taimuŋa. Qanuqhutinmi uqaqpich, Iñuum Iġñiŋa kivikkaugisiñipḷugu? Kisuuva una Iñuum Iġñiŋa?” ");
INSERT INTO eskNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus kiugai, “Qauma ittuatlullakkisiruq akunnapsitñi. Qauma pigiŋŋaan iñuuniaġitchi taaqsisikkaunġitchumuusriḷi. Uvvatakku iñuum taaqtuakun iñuuniaqami, iḷisimatlaitchaa napmun sivuniqaqtilaani. ");
INSERT INTO eskNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Qaummatiqaŋŋapsi ukpiksrisitchi qaumamik, aasriiḷi iñugiliutiyumagaasri qaumam.” Jesus taatnaqqaaqhuni aullaġniqsuq tamatkunakŋa iriqhuni iliŋitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus iñiqtaqaġaluaqtitlugu quviqnaqtuanik savaanik sivuġaatni ukpiġinġiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Taavrumuuna sivuniksriqirim Isaiah-m uqauttutaa taŋiqsitauniqsuq itnaqsimałha, “Ataniiq! Kisut ukpiqsrivat uqauttutigikkaptiknik? Kisumun Atanġuruam saŋŋiñi urriqsuqpauŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Taatnaqhutiŋ tamatkua ukpiqqutaiññiqsut, takku Isaiah-suli itnaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Agaayyutim ayaupkaġai, isrummatiŋich muliktuġai, iḷitchuqsritḷaiqł̣ugich qiñikkamiknik suli isrummatiŋich kaŋiqsiyumiñaiqł̣ugich, aasriiñ saatkumiñaiqł̣ugich uvamnun mamititqulutiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah-m taatna nipliutiginiġaa takku ilaan qiñiqługu Jesus-ŋum kamanałha. ");
INSERT INTO eskNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iñugiaktuat Jew-ŋuruat sivulliuqtit ukpiqsrigaluaqmiñiqsut Jesus-mik, aglaan sivuuġagiplugich Pharisee-ŋuruat anitqunġitḷutiŋ Jew-ŋuruat katraġviatniñ. Taatnaqhutiŋ uqautiginġiññiġaat sagviġḷugu ukpiqsrił̣iqtiŋ Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iliŋisa piqpagitlukługu iłuaġitchiułiq iñuŋniñ uumakŋa iłuaġitchiułiksraġmikniñ Agaayyutmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus nipliutiniġai nipitusripḷuni, “Kisupayaaq uvamnik ukpiqsriyumi ukpiqsrił̣hiñanġitchuq uvamnun, aglaan ukpiġigisipmigaa tuyuġiriga. ");
INSERT INTO eskNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kisupayaam qiñiqsimaruam uvamnik qiñiqsimaaqmigaa ilaa tuyuġiriga. ");
INSERT INTO eskNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Uvaŋa nunamun qaumatun iḷipḷuŋa aggiqsauŋuruŋa, kisupayaaq uvamnik ukpiqsrikpan, irviqaġumiñaiqł̣ugu taaqtuamik. ");
INSERT INTO eskNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kia ivruma tusraagaluaġlugich uqauttutitka tupiginġitpagich atanniġumiñaitchiga. Atakkii aggiñġitchuŋa atanniqsuityaġluŋa nunam iñuiñik aglaan anniqsuġiaqługich. ");
INSERT INTO eskNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kisupayaam ayagluŋa, uqauttutiga akuqtunġitchumiuŋ, atanniqsimaaqtiqaqtuq. Uqałhum uqautigianikkaġma atanniġisigaa aqulliġmi uvlumi. ");
INSERT INTO eskNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Takku uqanġitchuŋa uvapkuiñaq, aglaan Aapam tuyuġirima tillisiqaġaaŋa sumik uqaġiraksramnik. ");
INSERT INTO eskNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Uvaŋa iḷisimagiga ilaan tillisigikkaŋa isruitchuamik iñuułhuruq. Tamanna uqauttutigikkaġa Aapam uqautigaaŋa uqaġitquplugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aasriiñ sivuuraŋani niġiqpagvikaam taggisiqaqtuam Apqusraaqtitaułiġmik, Jesus iḷisimaniqsuq aullaġviksrani tikisilaaŋanik nunamiñ marrumakŋa Aapamun. Ilaan pigikkani piqpagiraġiplugich marrumani nunami ittuat piqpaginiġai isruanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus-lu maliġuaqtiniḷu nullautchiġñiqsut. Tuunġaum isrummianiŋniġaa Judas Iscariot, Simon iġñiġikkaŋa, tunitquplugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus-ŋum iḷisimaniġaa Aapam aatchuutigitilaaŋa iluqaan saŋŋi iŋmiñun. Iḷisimapmigaa aggiqsilaani Agaayyutmiñ suli aullaġniaqtilaani Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tarraasriiñ Jesus makinniqsuq niġġiviŋñiñ, aasriiñ qalliich atnuġaani piiqł̣ugich, ivgutmik tapsipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Aasriiñ kuviripḷuni imiġmik iġġuġviuramun, iġġuaqsipḷugich maliġuaqtigikkaġmi isigaŋich, aasriiñ allaqtiqługich ivgutmik tapsigikkaġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Peter-m tikitmani nipliutiniġaa Jesus, “Ataniiq! Ilvich iġġuġniaqpigich isigatka?” ");
INSERT INTO eskNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus-ŋum kiugaa, “Pakma nalugiñ savaaġikkaġa, aglaan aquvatigun iḷitchuġigisigiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter-m nipliutilgiññiġaa, “Qakugununniiñ isigatka iġġuġumiñaipiaġitin.” Jesus-ŋum kiuniġaa, “Iġġunġitchupkich isigaktin piqatauyumiñaitchutin uvaŋni.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter-m kiulgiññiġaa, “Ataniiq! Isigałhiñaġinġisatka aglaan argatkalu niaquġalu.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus-ŋum kiuniġaa, “Kisupayaaq iġġuaniksimaruaq salumallapiaqhuni iġġutqiksuksraunġitchuq avataagun isigaiñ. Iluqasri salummaqsimarusri aglaan taamna atausriq.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus iḷisimaniġaa kisumun tuniñiaqtilaani; taatnaqhuni nipliutiginiġaa, “Iluqasri salummaqsimarusri, aglaan atausriq.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ilaan isigaŋich iġġuanikamigich atitqianikługich atnuġaaniḷu utiġniqsuq inimiñun niġġiviŋñun. Aasriiñ apiqsruġniġai, “Kaŋiqsivisi sutilaamnik ilipsitñun? ");
INSERT INTO eskNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Taiyuġipsitña Iḷisautrimik suli Ataniġmik, aasrii nalaunŋapluni taatnałiqsi, atakkii taavrumiŋauruŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Uvaŋaasrii, ilipsi Atannapsi suli Iḷisautripsi, isigasri iġġuġitka. Ilipsipsuuq iġġuutiruksraurusri isigapsitñik avatmun. ");
INSERT INTO eskNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Qaitchigipsi urrautiksrapsitñik, ilipsipsuuq iñiqtaqaquplusri iñiqsił̣ł̣aptun ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iḷumutuullapiaqtuamik uqautigipsi, Savaktaaġruk kamanatluktuaŋunġitchuq ataniġmiñiñ, unniiñ uqqiraqti kamanatlunġitchuq taavrumakŋa tuyuġirimiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Iḷisimagupsigik tamatkua qanutun quvianamiuniaqtusri atuġupsigik. ");
INSERT INTO eskNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Taamna nipliutiginġitchiga iluqapsigun. Iḷisimaniġitka taapkua piksraqtaaġikkatka, aglaantuuq uqałiq aglausimaruaq immiqsuksrauruq itna, ‘Iñuk niġiqatiga niqimik akiḷḷiġuqtuq uvamni.’ ");
INSERT INTO eskNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kilikkipsi taavrumiŋa pakma atuumałiksraŋan sivuani aasriiñ taamna qakugu atuummikpan ukpiġitquplugu ilaaŋutilaamnik. ");
INSERT INTO eskNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iḷumutuullapiaqtuamik nipliutigipsi, iñupayaam akuqtuġumiuŋ kiñapayaaq tuyuġikkaġa akuqtuqmiraġigaaŋaptuuq. Suli akuqtuipayaaqtuat uvamnik akuqtuqmiraġigaat tuyuġiriga.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Taatnaqqaaqługich Jesus iłuiḷḷiuliġñiqsuq irrutchiġmiñi aasrii nipliutiplugich, “Iḷumutuullapiaqtuamik nipliutigipsi, iḷapsi tuniñiaġaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Maliġuaqtit qiñġutiaqsiñiqsut avatmun, kaŋiqsiñġiḷḷapiaqługu. ");
INSERT INTO eskNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Maliġuaqtit iḷaŋat, taimña Jesus piqpagikkaŋa, aquppiñiqsuq tugliupluni Jesus-mun. ");
INSERT INTO eskNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter-m urriqaniġaa itnaqhuni, “Apiqsruġuŋ kisumik uqautiqaqtilaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Taamna maliġuaqti qalliḷaaqhuni Jesus-mun apiqsruġniqsuq, “Kisuuva, Ataniiq?” ");
INSERT INTO eskNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus kiugaa, “Ilaaŋuruq qaitchikkaġa uumiŋa qaqqiaviñauramik misruqqaaġlugu imiqqamun.” Tarakŋa tigusripḷuni qaqqiaviñiġmik misruqqaaqługu qaiññiġaa Judas-mun, iġñiŋanun Simon Iscariot. ");
INSERT INTO eskNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas tiguluqqaaġaa qaqqiaq Tuunġaum isiġniġaa. Tarani Jesus-ŋum nipliutigaa, “Savaaġisrukkan piuŋ qilamik!” ");
INSERT INTO eskNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nalliataunniiñ niġiñiaqatauruat kaŋiqsiñġiññiġaat qanuutautilaaŋanik Jesus-mun nipliutiłha. ");
INSERT INTO eskNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iḷaŋich maliġuaqtit isrumaniqsut, Judas aŋalatigipmagu maniqaġviŋat, Jesus-mun tauqsiġiaqunipḷugu inuġikkaġmiknik niġiqpagvikaami, unniiñ qaitchityaquplugu sumik inuqsraqtuanun. ");
INSERT INTO eskNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas akuqtuanikamiuŋ qaqqiaviñauraq, tarvauvaa aniñiqsuq. Tarra unnuaŋuruq. ");
INSERT INTO eskNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas anianikman Jesus nipliqsuq, “Pakma Iñuum Iġñiŋa kamanaqsipkakkauruq. Suli Agaayyun kamanaqsipkakkauruq Ilaagun. ");
INSERT INTO eskNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aasrii Agaayyun kamanaqsipkakkauniqpan Ilaagun, Agaayyutimtuuq iŋmiñik sagviġisigaa kamanautaa Iġñiŋan Iñuum, Ilaan kamanausriġḷugu tarvauvaa. ");
INSERT INTO eskNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Iḷilgauramaaŋ! Uvaŋa nayuutiqpakkumiñaiqsuŋa. Pakaaqsigisigaluaġipsitña, aglaan Jew-ŋuruat uqautipmatun nipliutigipsi pakma, ‘Aullalguitchusri aullaġviginiakkamnun.’ ");
INSERT INTO eskNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nutaamik tillitmik qaitchigipsi, Avatmun piqpakkutiyumuusri! Atriḷugu piqpaksrił̣iġa ilipsitñik, taatnatuntuuq piqpagiikkumuusri. ");
INSERT INTO eskNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Avatmun piqpakkutigupsi, iñupayaat iḷitchuġigisigaat uvamni maliġuaqtaułiqsi.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter-m apiqsruġniġaa, “Ataniiq! Napmuŋniaqpich?” Jesus-ŋum kiuniġaa, “Pakma malilguitchiñ aullaġviginiakkaġa, aglaan aquvatigun malikkisigikma.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter-m apiġiniġaa, “Ataniiq! Suvaata malilguitpigiñ pakma? Uvaŋa tuqułhiñaaġuqtuŋa pisigilutin.” ");
INSERT INTO eskNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus-ŋum kiugaa, “Itqanaipiaqpich tuqqutisukłuŋa? Iḷumutuuruamik nipliutigikpiñ, aqargiqpak qalġuŋaiñŋaan piiḷaaġutigigisigikma piñasruniaglaan.” ");
INSERT INTO eskNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus-ŋum nipliutigai, “Iłuiḷḷiuqtitnagich uummatisri. Ukpiqsrimaaġitchi Agaayyutmun, uvamnun ukpiqsriḷusripsuuq! ");
INSERT INTO eskNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aapaa kiñunġani iniksrat iñugiaktuat ittut. Itqanaiyautityaġniaġipsi iniksrapsitñik. Taatna uqautinayaitchipsi, taatniinġitpan. ");
INSERT INTO eskNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aasrii aullaġuma itqanaiyaġiaġlugu iniksraqsi aggitqikkisiruŋa, aasrii uvaŋnun iŋmagusri nayuutitlasriḷusri nani itchuma. ");
INSERT INTO eskNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aasrii iḷitchuġianikkiksi qanuq tikiññiałiksraqsi taivrumuŋa aullaġniaġvigikkamnun.” ");
INSERT INTO eskNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas-ŋum nipliutigaa, “Ataniiq! Iḷisimanġitchikput napmuŋniaqtilaan. Qanuġlugu taivrumuŋaġniałhum apqutaa iḷisimagisivisigu?” ");
INSERT INTO eskNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus-ŋum kiugaa, “Uvaŋa apqutauruŋa, iḷumutuupluŋa, suli iñuułhupluŋa. Kiñaunniiñ Aapaanukkumiñaitchuq kisianik uvapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pakma iḷitchuġi'apsitña iḷitchuġipmigiksipsuuq Aapaga. Aasriiñ uvakŋaniñaglaan iḷisimagiksi suli qiñiqsimaplugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip-ŋum nipliutiniġaa, “Ataniiq! Aapamik urriqsuutitigut. Taamna inuġikkatuaġigikput.” ");
INSERT INTO eskNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus-ŋum kiugaa, “Takiruami nayuuti'ama ilipsitñi naagasuli iḷitchuġinġitpiña, Philip? Kisupayaam qiñiqsimaruam uvaŋnik qiñianiksimagaa Aapa. Suvaatami nipliqpich Aapamik urriqsuutitquplusri? ");
INSERT INTO eskNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Philip! Ukpiġinġitpiuŋ uvaŋa Aapami nayuutitilaaġa suli Aapa uvaŋni itilaaŋa? Tamatkua uqałhich uqautigianikkatka ilipsitñun uvamniqnisaunġitchut. Aapauruam nayuutiruam uvaŋni iñiqtaġigai savaani. ");
INSERT INTO eskNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ukpiġisritña uqaqama Aapami itilaamnik suli Aapa uvaŋni itilaaŋanik! Naagaunniiñ ukpiġisritña savaapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iḷumutuuruamik nipliutigipsi, kisupayaaq ukpiqsriruaq uvapkun savaŋniaqmiuq savaaġikkamnik, piñiaqtuqunniiñ kamanatluktuanik savaanik tamatkunakŋa, atakkii aullaaqsiruŋa Aapaanun. ");
INSERT INTO eskNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aasrii iñiqsisigisigipsi qanusripayaamik iŋiġupsi attapkun piqutigilugu Aapauruam kamanaqtitaułiksraŋagun uvapkun Iġñiġuruakun. ");
INSERT INTO eskNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sukupayaaq iŋiġupsitña atiġikkapkun, iñiqtaġigisigiga. ");
INSERT INTO eskNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Piqpagigupsitña tupigigisigisri tillisitka. ");
INSERT INTO eskNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aasrii iŋiġisigiga Aapa qaitchitqulusri atlamik ikayuqtiksramik nayuqtiksrapsitñik qaŋavak taimuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Taamna Irrusriġigaa iḷumutuułhum. Nunam iñuiñ akuqtulguitchaat qiñinġitḷugu unniiñ kaŋiqsimaitḷugu. Aglaan iḷisimagiksi, takku iñuuqatauruq piqatigiplusri suli ilipsitñiinniaqtuq. ");
INSERT INTO eskNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Unitchumiñaitchipsi kisiŋŋuġusri. Utiġiłhitchuŋa ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sivikisuurami nunam iñuiñ qiñitqikkumiñaiġisaatŋa aglaan ilipsi qiñiġisigipsitña, takku iñuułłapkun ilipsipsuuq iñuugisirusri. ");
INSERT INTO eskNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taimña uvluq tikitpan iḷitchuġigisigiksi Aapamni itilaaġa suli ilipsi uvamni, aasriipsuuq uvaŋa ilipsitñi. ");
INSERT INTO eskNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kisupayaaq piqaqtuaq tillisimnik tupigiplugiḷḷu ilaaŋuruq piqpaksrirauruq uvamnik. Aapaa piqpagigisigaa piqpaksriruaq uvamnik. Uvaŋaptuuq piqpagigisigiga iḷisimapkaġluŋa ilaanun.” ");
INSERT INTO eskNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas-ŋum (Iscariot-ŋunġitchuam) nipliutiniġaa, “Ataniiq! Qanuġutin iḷisimapkaġisivich uvaptiknun iḷisimapkasruŋaqnak nunam iñuiñun?” ");
INSERT INTO eskNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus-ŋum kiugaa, “Kisupayaam piqpaksriruam uvamnik tupigigisigai uqałłatka. Aapaa piqpagigisigaa suli Aapagalu tikitkisigikpuk iñuuniaqasriġḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kisupayaam piqpaksriñġitchuam uvamnik tupigitlaitchai uqałłatka. Uqałhich tusraakkasri uqałiġinġitchitka, aglaan aggiaġaqtuq Aapamiñ tuyuġirimniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tamatkuniŋa uqautigipsi nayuutiŋŋaġmasuli ilipsitñi. ");
INSERT INTO eskNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ikayuqtim Ipqitchuam Irrutchim Aapauruam tuyuġiraksraŋan attapkun iḷisautigisigaasri supayaamik itqaqtitaġlugiḷḷu iluqaisa uqauttutitka ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Qiñuiññamik unirvigigipsi. Tutqiutimnik tutqiutiqaqqitchi. Nunam iñui qiñuiññaqaġumiñaitchut qiñuiññaqaqtirrutiptun. Iłuiḷḷiuqtitnagich uummatisri! Iqsisuŋaqasri! ");
INSERT INTO eskNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tusraagipsitña nipliqama aullaġniaġnipḷuŋa, aglaan aggitqiŋñiaġnipḷuŋa ilipsitñun. Piqpagipiaġniġupsitña quviasrugayaġaluaqtusri aullaġniałłapkun Aapamun, atakkii Ilaa kamanatluktuq uvamniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tamarrumiŋa pakma kilianikkipsi atuummigaluaqnagu ukpiqsritquplusri atuummiḷuni pikpan. ");
INSERT INTO eskNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tarakŋaaglaan uqaaqtuqatigilguiġñiaġipsi, takku nunam marruma aŋalataa, Tuunġaq, aggiaqsiruq. Ilaa piitchaluaqtuq saŋŋimik akiiḷiḷuŋa, ");
INSERT INTO eskNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","aglaan nunam iñuiñ iḷitchuġiraksraġigaat piqpaksrił̣iġa Aapamik. Taatnaqługu tupigiraġigiga Aapam tillisipayaaŋa. Makillusri, uvakŋa aullakta!” ");
INSERT INTO eskNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Uvaŋa atriqaqtuŋa napaaqtupiamik aasrii Aapaga nautchirriqiraupluni. ");
INSERT INTO eskNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ilaan piiġaġigaa akiġupayaaq uvamniittuaq asrirriraġanġitman, suli nagguksaqługu akiġupayaaq asrirriraġaktuaq asrirripsaaquplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ilipsi salummakkauŋaniktusri uqałikun uqautigianikkapkun ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Piqatautuiñaġitchi uvamni suli uvaŋaptuuq ilipsitñi. Uvamni nayuutinġiqsuaŋugupsi asrirriaqaġumiñaitchusri, atriḷugu akiġuq iŋmigun asrirritlaitchuaq kisianik napaaqtumi itnami. ");
INSERT INTO eskNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Uvaŋa atriqaqtuŋa napaaqtumik, ilipsiasriiñ akiqqutun. Kisupayaaq nayuutiruaq uvaŋni suli uvaŋa ilaani, atqunaq asrirriaqaġisiruq, takku sumik iñiqsiyumiñaipiaqtusri piiḷḷuŋa uvaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kiñapayaaq nayuutinġitchuaq uvamni ittuq akiqqutun igitaupluni tuqulliruatun. Taatnatchich akiqqut katitlugich ikniġmun igittaġigaich ikipkaġviksraŋatnun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ilipsi uvamni nayuutigupsi suli uqałiġikkatka ilipsitñi, aasriiḷi qanutchimik pigiyumakkapsitñik iŋiqsruġupsi qaisauniaqtuq ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aapaa kamanautaa qiñiġnaqtitaugisiruq tumigilugu atqunaq savaaqqallautałiqsi. Taatnatun ukpiqnaqsigiksi maliġuaqtigitilaaqsi uvamnun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Piqpagikkaġigipsi atripḷugu Aapaa piqpaksrił̣ha uvamnik. Nayuutititchi piqpakkutimni. ");
INSERT INTO eskNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tillisitka tupigigupsigik piqpakkutimni itkisirusri, atriḷuguptuuq uvaŋa Aapaa tillisaiñik tupiksripḷuŋa itmatun piqpakkutaani. ");
INSERT INTO eskNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tamatkuniŋa uqautigipsi quvianaġikkaġa ilipsitñiitquplugu, suli quvianaqaquplusri naamaruamik. ");
INSERT INTO eskNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Unauvva tillisiga, piqpakkutiyumuusri avatmun atriḷugu piqpaksrił̣iġa ilipsitñik. ");
INSERT INTO eskNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kiñaunniiñ kamanatluktuamik piqpakkutaitchuq uumakŋa iñuum qaitchił̣haniñ iñuułiġmiñik piqutigiplugich iḷauraani. ");
INSERT INTO eskNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ilipsi uvaŋni iḷauraaŋurusri tillisitka atuġupsigik. ");
INSERT INTO eskNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Savaktaaġrunik taiyutqikkumiñaitchipsi, takku savaktaaġruum iḷisimatlaitchaa ataniġmi suraġałha. Aglaan iḷauraanik taiyuutiqaġisigipsi, takku supayaamik Aapamniñ tusraakkamnik iḷitchuġipkaġipsi. ");
INSERT INTO eskNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ilipsi piksraqtaaġinġitchipsitña, aglaan piksraqtaaġigipsi suli nalunaiġusri asrirriaqaquplusri iñugiaglugu suli asrirrituiñaġusri itquplusri. Aasrii Aapam qaitchigisigaasri qanusripayaamik iŋiġupsiuŋ attapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Taatnaqhusri taatnaiḷipḷugu tiligipsi piqpakkutitquplusri avatmun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nunam iñuiñ uumigikpasri itqaġiraksraġigiksi uumigikkaułiġaptuuq sivupsitñi. ");
INSERT INTO eskNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ilipsi pigipkaġupsi nunam iñuiñun, piqpaginayaġaasri pimiktitun iḷiḷusri. Aglaan piksraqtaaġigipsi marrumakŋa nunakuałiġmiñ piginġiqsitlusri tamarrumuŋa; taatnaqhuni nunam iñuiñ uumigigaasri. ");
INSERT INTO eskNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Itqaġiyumagiksi uqałhich uqautigikkatka ilipsitñun, ‘Savaktaaġruk kamanatluktuaŋunġitchuq ataniġmiñiñ.’ Iliŋisa piyuakkaġigaatŋa, tarrali piyuaġisigaasripsuuq. Tupigigaich uqauttutitka, tarrali tupigigisigaasripsuuq. ");
INSERT INTO eskNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Aglaan iliŋisa taatna irrutigisigaasri piqutigilugu pigipkałiqsi uvaŋnun, iḷisimanġitḷugu tuyuġiriga. ");
INSERT INTO eskNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aggiñġitchuma suli uqautinġitchupkich patchisaikkaunayaqtut. Aglaan pakma pisanġitchuuġutiksraitchut killuqsautmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kisupayaam uumigi'amiña Aapagaptuuq uumigipmiraġigaa. ");
INSERT INTO eskNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Savaaqaqsimaitchuma akunġatni iñuum iñiqtaġinġaqsimaisaŋanik patchisaikkaunayaqtut, aglaan qiñianikkaluaqługu iñiqtaġa uumigituiñaġaatŋa suli Aapaga. ");
INSERT INTO eskNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Taamna taatniittuksrauruq taŋiquplugu taimña uqautauruaq aglaksimakkaŋa maliġutaksriusraiŋitñi, ‘Uumigigaatŋa patchisaiḷaakun.’ ");
INSERT INTO eskNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aglaan ikayuqti aggiqpan, tuyuġiniakkaġma Aapamiñ, Irrusria iḷumutuułhum Aapamiqnisauruaq, ilaa uqautiniaqtuq uvapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Uqaġigisigipsitñapsuuq takku iqataurusri uvamni aullaġniiłhaniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Uqautigipsi tamatkuniŋa ukpiqqutaiqunġitḷusri. ");
INSERT INTO eskNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Iñuich anitqataġisigaasriunniiñ iliŋisa katraġviŋmikniñ. Aa, piviksraq tikitchumaaqtuq kia iñuum tuqqutchumisi savautriñasrukniaġisiruq Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Taatnaiḷiḷugu irrutigisigaasri iḷitchuqsrimaił̣iġmikkun Aapamik unniiñ uvaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aglaan uqautigipsi tamatkuniŋa itqaġitquplugich uqauttutitka ilipsitñun taimanigu irrutiaqsikpasri taatnaiḷiḷugu. Uqautinġitchaluaġipsi tamatkuniŋa maliġuaqsiutiqqaaqapsi takku nayuqtuiñaqhusri. ");
INSERT INTO eskNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Aglaan pakma utiġniaqama ilaanun tuyuġirimnun nallipsi apiqsruqtanġitmigaatŋa napmuaqsisilaapkun, ‘Napmuŋniaqpich?’ ");
INSERT INTO eskNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aasriiñ pakma kilikapsi aliatchaktusri. ");
INSERT INTO eskNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aglaan iḷumutuuruamik nipliutigipsi, iłuatlukkisiruq aullałiksraġa. Uvvatakku aullanġitchuma ikayuqtiksrapsi utlaŋnianġitchaasri. Aglaan aullaġuma tuyuġigisigiga ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aasrii aggiġumi iḷitchuġipkaaqsigisigai iñui nunam nalaunġitḷutiŋ killuqsautikun suli nalaunŋaruałikunlu atanniiviksrakunlu. ");
INSERT INTO eskNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Uqautigisigai nalaunġiññiḷutiŋ killuqsautikun takku ukpiqsriñġitḷutiŋ uvamnik, ");
INSERT INTO eskNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","suli nalaunŋaruałikun takku Aapamuŋniaqtuŋa aasrii qiñitqikkumiñaitchipsitña, ");
INSERT INTO eskNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","suli atanniivikun takku aŋalatchiruaq marrumani nunami Tuunġaq atannikkauŋaniktuq. ");
INSERT INTO eskNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Uqaksraqaġaluaqtuŋa iñugiaktuanik ilipsitñun aglaan pakma kaŋiqsiyumiñaitchusri. ");
INSERT INTO eskNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aglaan Ipqitchuaq Irrusriq iḷumutuułiġmik iḷitchuġipkairuksraq aggiġumi, ilaan kaŋiqsipchaaqsigisigaasri iluqaanik iḷumutuuruanik. Ilaa uqaġumiñaitchuq aŋalatchił̣iqaqmatun iŋmigun aglaan uqautigisigaasri tusraakkaġmiñik, suli quliaqtuaġutiniaġaasri sunik tikitchuksranik. ");
INSERT INTO eskNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ilaan kamanaqtitkisigaaŋa, takku uqaksraġikkaġa quliaqtuaġiniaġaa ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iluqaan Aapam pigikkaŋa pigipmigigaptuuq. Taatnaqługu nipliutigigiga Ipqitchuamun Irrutchimun quliaqtuaġiniaġnipḷugu ilipsitñun uqaksraġikkaġa. ");
INSERT INTO eskNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Sivikisuurami qiñinġisaallakkisigipsitña, aasriiñ kiñuvaaŋagun qiñiaqsiḷgiḷḷuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iḷaŋitguuq maliġuaqtaiñ uqaaqsiñiqsut avatmun, “Sumik uqautivatigut itnaqami, ‘Akuniisruŋaqasri qiñinġiġisigipsitña aasriiñ taamuunavak qiñiaqsiḷgiḷḷuŋa,’ suli itnaqami, ‘Aullaġniaqtuŋa Aapamun’? ");
INSERT INTO eskNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Qanuutauva ‘sivikisuuraq’? Uvagut kaŋiqsitḷaitchikput sumik uqautiqałha.” ");
INSERT INTO eskNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus-ŋum kaŋiqsimaplugu apiqsruġułhat taavrumuuna nipliutiniġai, “Apiqsruqtuutivisi ilipsitñun sumik qanuutautiqaqtilaaŋanik uqaqama, ‘Akuniisruŋaqasri qiñinġiġisigipsitña aasriiñ taamuunavak qiñiaqsiḷgiḷḷuŋa.’ Taamna apiqsruutigisukługu uqaksraqtutigivisiuŋ akunnapsitñi? ");
INSERT INTO eskNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Uvaŋa nipliutigipsi iḷumutuuruamik, qiapkaġusriḷu alianniuqtillusriḷu nunam iñui quviatchakkisirut, aglaan alianniułiqsi mumikkisiruq quviasrułiġmun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aġnaq qitunġiuqtuaq auliyautipmani nagliksaaġaqtuq tikiumałhagun atniġñam, aglaan annaaniktiqami puuyuġaġigaa nagliksaałłi auliyausrima'ami, quviatchagaqtuq iḷaalugruaq anipman nunamun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Taatnatun alianniuġutiqaġaluaqtusri pakma aglaan qiñitqikkisiḷgitchipsi suli uummatisri quviatchakkisirut, aasrii kia-unniiñ iñuum ivayaaġiyumiñaitchaa quvianaq ilipsitñiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Taivrumani uvlumi apiqsruqtaaqsiyumiñaitchipsitña sutigun. Uqautigipsi iḷumutun, Aapam qaitchigisigaasri ilipsi iŋiġupsiuŋ qanusripayaamik attapkun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Uvuŋanunaglaan iŋiqsruqtanġitchusri sumik attapkun. Iŋiqsruġitchi ilipsiḷi akuqtuiyumuusri suli quvianaksraqsi inuŋaitchumuuq. ");
INSERT INTO eskNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Uqautigipsi tamatkuniŋa atrikusrautitigun. Pivik tikitchaġumaruq uqaġuiġviksraġa ilipsitñun atrikusrautitigun aglaan uqautitlasrigisigipsi kaŋiqsiñaqsiḷugu Aapauruakun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Taimña uvluq tikitpan, iŋiqsruqtaġisigiksi attapkun. Uvaŋaunniiñ iŋiqsruutinġitkipsi Aapamun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Uvvatakku Aapam piqpagigaasri takku piqpaksripḷusri uvamnik suli ukpiqsripḷugu aggiqsimałiġa Agaayyutmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uvaŋa iḷumun aggiqsuami Aapamiñ marrumuŋa nunamun. Uvva pakma aullaaqsiḷgitchuŋa maakŋa nunamiŋ utiqsaqłuŋa Aapamun.” ");
INSERT INTO eskNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Maliġuaqtaiñ nipliutiniġaat, “Uvvaliqaa uqałhiñ kaŋiqsiñaqtuq. Pakma uqanġitchutinunniiñ atritigun. ");
INSERT INTO eskNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Uvagut kaŋiqsigikput pakma iḷisimałhiñ supayaamik. Inuqnanġitchuq kisumun apiqsruqtaqulutin. Taavrumuuna ukpiġigikput aggiqsuaŋułhiñ Agaayyutmiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus kiugai, “Uvvapakma ukpiqsriḷiqpaalukpisi? ");
INSERT INTO eskNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pivik tikiññiaqtuq, tikiumaaniktuqami, iluqasri siammayaaqtitaułiksraqsi, atausriukattaaġusri kiñunnapsitñun kisiŋŋuġluŋa. Aglaan kisimallapiaq inġitchuŋa, takku Aapaa nayuġaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tamarrumiŋa uqautigipsi qiñuiññaqaquplusri piqataułłapsigun uvamni. Nunam iñuiñ nagliksaaqtitkisigaasri, aglaan quviatchauġikkitchi. Uvaŋa akiiḷianiksimagiga nunam aŋalataa. ");
INSERT INTO eskNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus taatnaanikami, ilaa aaġluqhuni nipliġñiqsuq, “Aapaaŋ, pakma piviksraq tikiumaruq. Kamanaqsipkaġuŋ Iġñiġiñ, Iġñiqpiḷḷi kamanaqsiyumagaatin. ");
INSERT INTO eskNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Uvvatakku ilvich aŋalatchitḷapkaġiñ iluqaitñik iñuŋnik suli qaitchitḷapluni isruitchuamik iñuułiġmik iluqaitñun qaisaġikkaqnun ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Una isruitchuaq iñuułiq itnautauruq, iñuich iḷitchuqsrił̣iksraŋat ilipnik kisivich iḷumun Agaayyutautilaaqnik suli iḷitchuġilugu Jesus Christ ilvich tuyuġikkan. ");
INSERT INTO eskNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iḷitchuġipkautianikkiga kamanałhiñ nunam iñuiñun. Itqanaiŋanikkiga savaaksrirrutigikkan uvaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pakma, Aapaaŋ, kamanaqsipkaŋŋa sivuqqapni, kamanautim atriŋanik pigikkaġma itnama ilipni nuna iñiqtaugaluaqnaguunniiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Uvaŋa iḷitchuġipkautigianikkikpiñ iñuŋnun ilvich qaisaqnun uvaŋnun marrumakŋa nunamiñ. Ilvich pigiliutigitin, aasriiñ qaitkitin uvaŋnun, aasriiñ tupigigaat uqałhiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pakma iḷitchuġigaat suapayaaq qaisan uvaŋnun aggiqsałha ilipniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Qaitchigitka uqałiġmik qaisaqnik uvaŋnun. Iliŋisa akuqtuqługu, iḷitchuġigaat iḷumun aggiqsuaŋułiġa ilipniñ ukpiġiplugu ilipnun tuyuġiłiġa. ");
INSERT INTO eskNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Agaayyutigitka tamatkua. Pakma agaayyutinġitchitka nunam iñui, aglaan agaayyutigitka tamatkua qaisatin uvaŋnun, takku iliŋich pigigitin. ");
INSERT INTO eskNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iluqaan uvaŋa piga pigipmigiñ suli iluqaan ilvich piñ uvaŋaptuuq pigigiga, aasriiñ kamanałiġa qiñiġnaqtitauruq tamatkunuuna. ");
INSERT INTO eskNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pakma utlautiniaqtuŋa ilipnun nunami inġiġḷuŋa, aglaan tamatkua inniaqtut nunami. Ipqitchuaq Aapaaŋ! Qaunagiyummigitin annautruġlugich saŋŋigikkaŋagun atiġikkaqpich qaisaġikkapkun uvaŋnun, iliŋiḷḷi atautchiiñauyumuut atriḷugu uvaguk atausriułiqpuk. ");
INSERT INTO eskNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Uvaŋa nayuutinnamni nunami iliŋitñi qaunagigikkatka annautruqługich saŋŋiagun atiġikkaqpich, ilvich atchiutigikkapkun. Qaunagigitka aasrii atausriqunniiñ tammanġitchuq, aglaan taimña iñuk tammaqtuksrauruaq, Agaayyutim uqałha immiutaupluni. ");
INSERT INTO eskNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pakma utlautiyasriruŋa ilipnun. Taatnaiḷipḷugu uqaqtuŋa innamni nunami, iliŋich piqaquplugich quvianaġikkamnik inuŋaiġḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Qaitchiruŋa uqałiġnik iliŋitñun, aasrii nunam iñuiñ uumigigaich, takku piqatiginġiqł̣ugich nunam iñui atripḷugu uvaŋa piqataunġił̣iġa nunam iñuiñun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Uvaŋa iŋiqsrunġitchikpiñ piiqulugich marrumakŋa nunamiñ, aglaan iŋiġikpiñ qaunagitquplugich piŋiŋnaiġḷugich tuunġaġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Uvaŋa piqataunġitmatun nunam iñuiñun iliŋittuuq piqataunġitchut nunam iñuiñi. ");
INSERT INTO eskNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Iḷumutuułłapkun ipqiqsimaakkich ilipnun. Uqałhiñ iḷumutuuruq. ");
INSERT INTO eskNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tuyuġigitka nunamun, ilvittuuq tuyuqaqmatun uvamnik nunamun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iliŋich piqutigiplugich ipqiqsimaaqtuŋa ilipnun, iliŋittuuq ipqiqsimaaquplugich ilipnun iḷumutuułikun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Agaayyutinġitchitka kisiisa tamatkua, aglaantuuq taipchua ukpiqsriruaksrat uvamnik iliŋisa uqałhatigun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Agaayyutigitka iluqaġmiŋ atautchisun itquplugich. Aapaaŋ! Atautchisuttuq illich uvaptikni, atriḷugu ilvich uvamniitmatun suli uvaŋa ilipni. Taatnatuq atausriuyumuut, taavrumuunali nunam iñuiñ ukpiġiagutiyumigaat ilvich tuyuqałhiñ uvaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Uvaŋa qaitchigitka atriŋanik kamanałiqpich qaisaqpich uvaŋnun, piqutigiplugu iliŋich atautchiiñaułiksraŋat atriḷugu uvaguk atausriułiqpuk. ");
INSERT INTO eskNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Uvaŋa illuŋa iliŋitñi suli ilvich uvaŋni, taavrumuuna iliŋich atausriŋŋuġumuut. Nunamli iñuiñ kaŋiqsiyumigaat ilipnun tuyuġiłiġa suli ilvich piqpaksrił̣hiñ iliŋitñik piqpaksripmatun uvaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Aapaaŋ, tamatkua qaisatin uvaŋnun iqatigisrukkitka sumiitchuma iliŋitñun qiñiqquplugu kamanaun pigipkakkan uvaŋnun takku ilvich piqpagipluŋa nuna iñiqtauŋaiñŋaan. ");
INSERT INTO eskNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nalaunŋaruaq Aapaaŋ! Nunam iñuiñ nalugaatin, aglaan uvaŋa iḷisimagikpiñ suli ukua maliġuaqtit iḷitchuġigaat tuyuġitilaaġa ilipnun. ");
INSERT INTO eskNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iḷitchuġipkaġikpiñ iliŋitñun, suli iḷitchuġipkapsaaġniaġikpiñ. Tarrali piqpaksrił̣iq piqpakkutigikkan uvaŋnun uvaŋalu nayuutiyumuuq iliŋitñi.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus agaayuanikami taavrumani, aullaġniqsuq maliġuaqtiniḷu ikaaqługu kuuġuuraq taiñaqtuaq Kidron-mik. Taakmaniaŋani inniqsuq nautchiivik. Jesus maliġuaqtiniḷu isiġniqsut taavrumuŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas-ŋumaasrii, aatchuutigitniktuam ilaanik, iḷisimaniġaa suniitilaaŋa. Uvvatakku Jesus-ŋum taruŋautisruuniġai akulaiqł̣ugu maliġuaqtini tarani. ");
INSERT INTO eskNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Taatnaqhuni Judas utlautiniqsuq nautchiiviŋmun piqasriqhuni aŋuyyiuqtinik suli agaayyuvikpaum qaunaksraiñik, tuyuuplutiŋ qaukłiŋitñiñ agaayuliqsiniñ suli Pharisee-ŋuruaniñ, saagaqhutiŋ satkunik suli nanniñik. ");
INSERT INTO eskNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus-ŋum kaŋiqsimaplugu suapayaaq atuumaniaqtuaq iŋmiñun paaġniġai nipliutiplugich, “Kiña pakikpisiuŋ?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Taapkua kiuniġaat, “Jesus Nazareth-miu.” Ilaan kiugai, “Uvaŋa taimñauruŋa.” Judas-ŋum, aatchuutigitniktuam ilaanik, qichaqasriqsimaniġai tamatkua pakaktuat. ");
INSERT INTO eskNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesus-ŋum nipliutipmatiŋ, “Uvaŋa taimñauruŋa,” tamatkua kiñumuktuqhutiŋ ulġusraaġniqsut nunamun. ");
INSERT INTO eskNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus-ŋum apiqsrutqiŋñiġai, “Kiña pakikpisiuŋ?” Kiuniġaat, “Jesus Nazareth-miu.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Uqautianikkipsi ilaaŋutilaamnik. Ilipsi pakakkupsitña, maliġuaqtitka aullaqtitchigik!” ");
INSERT INTO eskNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Taatna nipliutiniġai Jesus-ŋum taŋiqsaqługu nipliutigimaanikkani itnaiḷipḷugu, “Aapaaŋ, atausriqunniiñ tammanġitchuq qaisaqniñ uvaŋnun.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter-guuq savikpaqaqhuni, aasriiñ amuliqamiuŋ anaupluni ilaan siutaiqsiġniġaa taliqpianik tamarrumiŋa qaukłiata agaayuliqsit savaktaa, atiqaqtuaq Malchus-mik. ");
INSERT INTO eskNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus-ŋum nipliutigaa Peter, “Tugvaġuŋ satkugikkan puuŋanun. Isrumavich akuqtuġnianġiññasrugalugu uvamnun nagliksaaġutiqpak Aapama sivunniaġikkaŋa uvamnun? Uvaŋa nagliksaaġluŋa tuquruksrauruŋa. Imiqtaksraġigiga taamna imaŋa qallutim Aapama qaisaŋa uvamnun?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aŋuyyiuqtit piqasriqhutiŋ qaukłiġmiknik suli Jew-ŋuruat qaunaksriŋisa tiguniġaat Jesus qiḷiqsruqługu, ");
INSERT INTO eskNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","aasrii sivulliuplugu Annas-muutiplugu ataniġmun, taataruaŋanun Caiaphas-ŋum. Caiaphas-guuq qauqłiupluni agaayuliqsauniqsuaq tamarrumani ukiumi, niŋuagiplugu taavruma Annas-ŋum atanġum. ");
INSERT INTO eskNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Taamna Caiaphas uqautriñiqsuaq qaukłiŋitñik Jew-ŋuruat iłuatlukkisiñipḷugu atausriq iñuk tuqqutaukpan piqusriġuni iluqaitñik iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter-m suli atlam maliġuaqtim kiñuagun maliŋniġaak Jesus. Taamna atla maliġuaqti, iḷisimaplugu qaukłiata agaayuliqsit, isiġniqsuq igluqpaŋanun qaukłiata agaayuliqsit piqatigiplugu Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter-li qichaġniqsuq tatkiani paami. Taamna atla maliġuaqti, iḷisimaplugu qaukłiata agaayuliqsit, aniñiqsuq kiñumun. Itqutiniġaa Peter tatqamuŋa uqatigianikamiuŋ niviaqsiaġruk taluliqiri. ");
INSERT INTO eskNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Taavruma taluliqirim niviaqsiaġruum nipliutiniġaa Peter, “Uvva, iḷagivatin maliġuaqtaiñ tatqavruma iñuum?” Peter-m kiugaa, “Iḷaginġitchaatŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Alappaaŋupluniguuq savaktit suli qaunaksrit ikniqsuqhutiŋ aumaniñ qichaġniqsut avataani auksiqhutiŋ iŋmiknik. Peter-m qichaqasriqamigich, auksiaqsipmiñiqsuq iŋmiñik. ");
INSERT INTO eskNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Qaukłiata agaayuliqsit apiqsruqtuġniġaa Jesus ilaan maliġuaqtaigun suli ilaan iḷisauttutaigun. ");
INSERT INTO eskNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus-ŋum kiugaa, “Uqaġaqtuŋa sagvipḷuŋa kisupayaamun. Iḷisautrisruuruŋa Jew-ŋuruat katraġviŋitñi suli agaayyuvikpaŋatni. Nipiqanġitchuŋa qanutchiñik iriġaqtuġluŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Suvaatami apiqsruqtaqpisitña uvaŋa. Apiqsruqsigik tamatkua iñuich tusraaritka sumik uqautiłhat uvaŋnun. Iliŋisa iḷisimagaat qanuq uqałiġa.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Taatnaqman Jesus iḷaŋataguuq qaunaksrit patiktiqługu nipliutigaa, “Qanuqhutin itnaiḷipḷugu kiuliqpiuŋ qaukłiat agaayuliqsit?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus-ŋum kiugaa, “Uvaŋa nipliġuma qanutchimik nalaunŋaiġḷugu uqautigiuŋ iluqaitñun uvaniittuanun. Aglaan nalaunŋaruamik pakma nipliġñiġuma, suvaata patikpiña?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas-ŋum tuyuġiniġaa Jesus qiḷiqsruutraq Caiaphas-mun qaukłiat agaayuliqsitnun. ");
INSERT INTO eskNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peter-guuq auksiġugaaġniqsuq ikniġmun aasriiñ iñuich apiqsruġniġaat, “Taavruma iñuum iḷaginġitpatin maliġuaqtaiñ?” Peter-m piiḷaaġutiniġai, “Iḷaginġitchaatŋa ilaan maliġuaqtaiñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iḷaŋataguuq qaukłium agaayuliqsim savaktaiñ, iḷaginikkaŋan taivruma siutaiqsikkaŋan Peter-m, nipliutiniġaa, “Qiñinġitpigiñ piqatauplutin ilaani nautchiiviŋmi?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter piiḷaalgiññiqsuq, “Iḷaginġitchaatŋa.” Taatnaqmiuġlu taimña aqargiqpak qalġuqtaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Taapkua aullautiniġaat Jesus Caiaphas-ŋum tupqaniñ kavanam Pilate-ŋum inaanun uvlaatchaurami. Aglaan Jew-ŋuruat isiqataunġiññiqsut tatqamuŋa agliqsrałikun salumaiġumanġitḷutiŋ iŋmiknik. Piqutigiplugu niġiqataułiksraqtiŋ itquplugu niġiqpagvikaami taggisiqaqtuaq Apqusraaqtitaułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Taatnaqhuni Pilate anipḷuni uqaqatigityaqtuaġniġai nipliutiplugich, “Sumik agvisiqaqpisiuŋ qamna iñuk?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Taapkua kiuniġaat, “Uvagut tikiutinayaitchikput ilipnun ilaa savvaqłukkataġuni piñġitpan.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate-ŋum nipliutiniġai, “Tigusriuŋ ilipsitñik atanniqsuġlugu tuvraġlugich maliġutaksrasri.” Jew-ŋuruat kiuniġaat, “Rome-maġmiut tuqqutchipkaiyumiñaitchaatigut iñuŋmik maliġutaksrirrutiptigun.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Taamnaguuq atuummiñiqsuq immiutaupluni Jesus uqautigimakkaŋanun qanuq iḷiḷugu tuqqutaułiksraġmigun. ");
INSERT INTO eskNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate isiġniqsuq kiñumun inimiñun aasrii tuqłuqługu Jesus-ŋum apiqsruġniġaa, “Uvva umialigivatin Jew-ŋuruat?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus-ŋum kiuniġaa, “Taamna apiqsruutigiviuŋ ilipnił̣hiñaq naaga atlat uqautivatin uvapkun?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate nipliqsuq, “Jew-ŋunasugiviña? Jew-ŋuqativich suli qaukłiŋisa agaayuliqsit qaisaġigaatin uvaŋnun. Suruami pivatin?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus-ŋum kiugaa, “Uvaŋa umialgunġitchuŋa marrumani nunami. Umialguguma atriḷugu umialik marrumani nunami, maliġuaqtitka aŋuyakkayaqtut tigutqunġiḷḷuŋa Jew-ŋuruanun. Aglaan aŋalatchił̣iġa maakŋaqtaunġipiaqtuq.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate-ŋum apiqsrulgiññiġaa, “Ilviñmi umialguvich?” Jesus-ŋum kiugaa, “Tarra, nipliutigigiñ umialgunipḷuŋa. Uvaŋa aniruaŋuruŋa suli nunamuktuaŋuruŋa piqusriqł̣uŋa uqałiksrapkun iḷumutuuruamik. Kisupayaam iñuuruam iḷumutuułikun naalagaġigaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate-ŋum apiqsruġaa, “Suami una iḷumutuułiq?” Pilate-ŋum kiñumun aniḷgitḷuni Jew-ŋuruanun nipliutiniġai, “Uvaŋa paqitchiḷguiññiqsuŋa sumik tuqurrutiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Aglaan tuvraqługu atuumiraġikkaqsi pił̣hiñaaġuutigiga patchisaiġiłiksraġa isiqtamik ilipsitñun uumani niġiqpagvikaami taggisiqaqtuaq Apqusraaqtitaułiġmik. Ilipsi uvaŋnun patchisaiqsitquvisiuŋ umialgat Jew-ŋuruat ilipsitñun?” ");
INSERT INTO eskNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Taapkua kiugaat nipitusriḷḷapiaqhutiŋ, “Taamnaunġitchuaq, pisutlukkikput Barabbas.” Taamna tigliŋniaqtauruq. ");
INSERT INTO eskNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tarra Pilate-ŋum Jesus tigupkaqługu ipiġaqtuqsiupkaġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","Aŋuyyiuqtit niaquusriġñiġaat kakitḷaġnanik suli atnuġaaqługu umialiktamik ukił̣haaġiksaamik aasrii nipliatiaqsipḷugu, “Iñuuqpakkumuutin umialgat Jew-ŋuruat.” Suli tikiññiġaat patiktiqataaqsipḷuguasrii. ");
INSERT INTO eskNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate-ŋum anitqikhuni nipliutiniġai iñuich, “Pakma ilaa annisigisigiga ilipsitñun, iḷitchuġitqulugu uvaŋa sumik paqitchiñġił̣hagun atanniusriaksraŋanik pigiiḷiḷugu.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesus aniñiqsuq niaquutilik kakitḷaġnanik suli umialiktamik atnuġaalik. Pilate nipliutiniġai iñuich, “Uvva, qiñiqsiuŋ iñuk!” ");
INSERT INTO eskNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Qaukłiŋich agaayuliqsit suli qaunaksrit qiñiqamitruŋ iġiallaksaġniqsut, “Kikiaktuutisriuŋ sanniġutamun, kikiaktuutisriuŋ sanniġutamun!” Pilate-ŋum nipliutigai, “Ilipsi tigulugu kikiaktuutisriuŋ sanniġutamun. Paqitchiñġitchuŋa agvisiksraŋanik atanniusriaqałiksraŋan taatna.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jew-ŋuruat kiuniġaat, “Maliġutaksraqaqtugut uqałiqaqtuamik ilaa tuquruksrauplugu takku nipiqaqtuq iġñiġinipḷuni Agaayyutmun.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate-ŋum tusraa'amigich taatna nipliaruat, ilaa naviasruliḷḷapiaqhuni itqutipkaġniġaa Jesus. ");
INSERT INTO eskNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Aasrii ilaa isitqikhuni tatqamuŋa uqaqsittaaġviŋmun nipliutiniġaa Jesus, “Nakiñ aggiqsuami?” Aglaan Jesus kiunġiññiġaa. ");
INSERT INTO eskNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate-ŋum nipliutilgiññiġaa, “Ilvich uqautisrunġitpiña? Itqaġiuŋ uvaŋa aŋalatchirrutiqałiġa patchisaił̣hiñauplutin suli kikiaktuutipkałhiñauplutin sanniġutamun.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus-ŋum kiugaa, “Pigigiñ aŋalatchił̣iq uvapkun kisianik qaisaułhagun ilipnun Agaayyutikun. Taatnaqhuni taimña iñuk qaitchiruaq uvamnik ilipnun killuqsautiqaqtuq kamanatluktuamik ilipniñ.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilate-ŋum tusraa'amiuŋ taamna ilaan annautisruliḷḷapiatlukkaluaġniġaa patchisaiġḷugu. Aglaan Jew-ŋuruat iġialaplutiŋ kiumaniġaat, “Annaktitchupku una iñuk, Caesar-m Rome-miittuam iḷauraaġiyumiñaitchaatin. Kiñapayaaq iŋmiñik ataniġuqtaqtuaq Caesar-m akiḷḷiġigaa umialguruam Rome-mi.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilate tusraa'amigich tamatkua nipliatit, ilaan annisiniġaa Jesus aasrii aquvitluni atanġum inaanun, taggisiliŋmun “Iyaġaŋmik Natilik,” aasrii Hebrew-tigun taiyuutiqaqhuni “Gabbatha.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Uvluqpaguqtuami uvluani paqnałhum niġiqpagvikaamun taggisiqaqtuam Apqusraaqtitaułiġmik, Pilate nipliutiniġai Jew-ŋuruat, “Kiikaami, uvva umialiksi!” ");
INSERT INTO eskNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tamatkua iñuich iġialaplutiŋ kiuniġaat, “Tuqulli! Tuqulli! Kikiaktuutili sanniġutamun.” Pilate-ŋum apiqsruġniġai, “Uvaŋnun kikiaktuutipkaqtitquvisiuŋ umialigikkaqsi sanniġutamun?” Qaukłiŋich agaayuliqsit kiuniġaat, “Uvagut qaukłiġmik umialiqaqtugut Rome-mi. Avataagun atlamik umialiqanġitchugut.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tarra Pilate-ŋum qaiññiġaa Jesus iliŋitñun aŋuyyiuqtinun kikiaktuutitquplugu sanniġutamun. ");
INSERT INTO eskNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tamatkua iñuich aŋalatkaqsiñiġaat Jesus. Aniñiqsuq akiyaqhuni kikiaktuutriviksraġmiñik, tikiutiplugu nunamun taiyuutiqaqtuamun “Niaqum Saunġanik,” Hebrew-tigunaasrii taiyuutiqaqhuni “Golgotha-mik.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Taapkua aŋuyyiuqtit kikiaktuutiniġaat Jesus sanniġutamun, piqasriqł̣ugu malġuŋnik atlaŋnik iññuŋnik kikiaktuutiplugik sanniġutaŋnun avataanun, Jesus qitiqłiḷiutiplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate-ŋum aglaŋniġaa iḷisimmatiksraq aglak aasrii taapkua aŋuyyiuqtit iḷipḷugu sanniġutam qulaanun, itna aglalik, “Jesus Nazareth-miu, umialgat Jew-ŋuruat.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iñugiaktuat Jew-ŋuruat agliqiniġaat, taamna Jesus kikiaktuutikkauvia uŋasriñġitḷuni nunaaqqimiñ. Iḷisimmatiksraq aglak aglaksimapluni piñasruiŋutlugu uqautchisigun Hebrew-tigullu Latin-tigullu suli Greek-tigun. ");
INSERT INTO eskNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jew-ŋuplutiŋ qaukłiŋisa agaayuliqsit itnaġniġaat Pilate, “Aglaknagu ‘Umialgatnik Jew-ŋuruat,’ aglaan ‘Taamna iñuk uqaġniḷugu, uvaŋa umialigigaatŋa Jew-ŋuruat.’” ");
INSERT INTO eskNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate-ŋum kiuniġai, “Qanuq iḷipḷugu uvaŋa aglakkaġa taatna aglaksimagisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aŋuyyiuqtit kikiaktuutianikmatruŋ Jesus sanniġutamun, tiguniġaich atnuġaaŋi autaagaqsipḷugich sisamaiŋutlugich, atausriuttaaġutiŋ piqatlasripḷutiŋ, aasriiñ atnuġaaŋa kiluiḷaaq ukił̣haaq aulaiḷaq qaliġurriaŋumaniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aŋuyyiuqtit uqaaqsiñiqsut avatmun, “Aliktusruŋaqnagu una, nalautchaaġautigilakput iḷitchuġisaġlugu kimun piginiaqtilaaŋa.” Taatnaqamitruŋ immiġñiġaat uqałiq uqautigimaruaq itna, “Iliŋisa autaaġaich atnuġaatka iŋmiknun, suli nalautchaaġautigiplugu atnuġaaġa.” Aŋuyyiuqtit piñiġaat taamna. ");
INSERT INTO eskNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Taatnaqtitlugich qichaġniqsut killiŋani kikiaktuutrivium Jesus aakaŋalu, suli aakaŋan aniqataa, Mary-lu iḷaqataa Clopas, suli Mary Magdalene. ");
INSERT INTO eskNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus-ŋum qiñiqamiuŋ aakani suli maliġuaqti piqpagikkani qichaqatauruak, nipliutiniġaa aakani, “Aakaaŋ, tarra iġñiġiñ!” ");
INSERT INTO eskNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Suli nipliutiplugu taamna maliġuaqti, “Tarra ilvich aakan!” Tarakŋaniñaglaan taavruma maliġuaqtim iŋmaŋniġaa kiñuniġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus-ŋum iḷisimaniġaa, sum iluqani immikkaułha, suli agliqsimaruaq uqałiq immianiktitchaqługu nipliġñiqsuq, “Imiġuktuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Piŋaluguuq tamaani inniqsuq imalik siiġñaġluktuamik misruqqumik. Tarra iḷiñiġaat misruktaqtaq misruqqumun, aasiiñ akiqqumik israuttusriqł̣ugu takpichuŋa israaġutiplugu qaqłuuknun. ");
INSERT INTO eskNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus akuqtuqamiuŋ misruġuq nipliġñiqsuq, “Tarra naattuq.” Aasriiñ sikitlugu niaquni aniġniŋiġñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tarra Jew-ŋuruat iŋiġniġaat Pilate, niugaaqtaġukługich tuqunaġiaquplugich taapkua aŋutit tuqqutauruat aasrii atqaqtillugich sanniġutaŋitñiñ. Taatnaġuŋniqsut takku tikiumapluni tallimmiułiq akunniqsaami iliŋisa niviŋatqunġitlugich timit sanniġutaŋitñi minġuiqsiaġvium uvluani, takku tikiumaniaqhuni nuimaniqsraq minġuiqsiałiq atlaniñ minġuiqsiałiġniñ. ");
INSERT INTO eskNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aŋuyyiuqtit taruŋaqamiŋ niugaaqtaġniġaich taapkuak avataani Jesus-ŋum tuqqutauqatauruak Jesus-kun. ");
INSERT INTO eskNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aglaan tikitmatruŋ Jesus iḷitchuġiniġaat tuquaniksimałha. Taatnaqługu iliŋisa niugaaqtanġiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aglaan iḷaŋata aŋuyyiuqtit kapiniġaa panamiñik Jesus-ŋum sanniġaagun aasrii tarvauvaa auglu imiġlu maqiplutik. ");
INSERT INTO eskNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Iñuk taamna qiñiqtuaq taavrumiŋa iḷisimarriġñiġaa ilipsipsuuq ukpiqsritquplusri. Ilaan uqauttutaa iḷumutuuruq, suli iḷisimagaa uqauttutmi iḷumutuułha. ");
INSERT INTO eskNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Taatnaiḷipḷugu iñiqtauniqsuq aglausimaruaq uqałiġmi immiqł̣ugu, “Nalliatunniiñ sauniġikkaŋiñ piiyaqtakkauyumiñaitchut.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Suli atla uqałiq itnaqsimaruaq, “Iliŋisa sukuiġḷugu qiñiġisigaat ilaa kapukkaqtiŋ.” ");
INSERT INTO eskNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Taavruma aquagun Joseph-guuq Arimathea-ġmiu maliġuaqtaupmiñiqsuq Jesus-mi nalunautchipḷuni takku iqsimmaġmi Jew-ŋuruanik pipḷuni. Apiqsruqman Pilate-ŋum pitquniġaa timi, Joseph-ŋumaasrii aullautiplugu. ");
INSERT INTO eskNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus, taimñaptuuq qiñiġiaqtuaq Jesus-mik unnuami, tuvaaqatauniqsuq Joseph-mi saagaqhuni tallimakipiatun uqumaisilaaliŋmik tipraġiksautinik atlagiiñik atiqaqtuanik myrrh-miglu aloe-miglu. ");
INSERT INTO eskNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Taapkuak iññuk piñiġaak Jesus-ŋum timaa nimiqsruqługu ukił̣haamik piunġiyaikkusriqsuqsimmaan, taatnatun Jew-ŋuruat timimik savaaqaġaġiłhat atripḷugu. ");
INSERT INTO eskNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Taavrumaniguuq nautchiiviŋmi Jesus-ŋum tuqqutauviani inniqsuq nutaaq iḷuviksraq atuqsimaiḷaaq. ");
INSERT INTO eskNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Uvvaasriiñ pisigiplugu Jew-ŋuruat paqnaviat, suli taavruma iḷuviksram qaniłhagun, inillaŋniġaat Jesus taruŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Uvlaatchaurami aullaġniisautaani akunniqsaam tanuġagugaaqtitlugu, Mary Magdalene iḷuviġmuŋniqsuq aasrii qiñiqługu iyaġak. Piiqsimaniqsuq paaŋaniñ iḷuvġum. ");
INSERT INTO eskNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aqpaqsruqhuni utlautiniqsuq Simon Peter-mun suli atlamun maliġuaqtimun, Jesus-ŋum piqpagikkaŋanun, aasrii uqautiplugik, “Iñuich aullautiniġaat Ataniq iḷuviġmiñ. Iḷitchuġinġitchikput napmun inillaktilaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peter-lu atlalu taamna maliġuaqti utlautiniqsuk iḷuviġmun. ");
INSERT INTO eskNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iluqatik aqpaqsruqhutik, aglaan iḷaqataan maliġuaqtim uniññiġaa Peter tikiḷġaaqhuniasrii iḷuviġmun. ");
INSERT INTO eskNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Auġrukami qiñiġniġaa ukił̣haaġiksaaq nimiqsruutaa aglaan isinġiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kiñuagun tikitñami Simon Peter uiyuiñaqhuni isiġniqsuq tatqamuŋa qiñiqługich aasriiñ ukił̣haat nallaviani, ");
INSERT INTO eskNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","suli ukił̣haaq nimġutauruaq Jesus niaquanun inillaksimanġiññiqsuq taapkunuŋa ukił̣haanun aglaan imullaksimaniqsuq ilaagun. ");
INSERT INTO eskNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Taimñali atla maliġuaqti tikiḷġaaġaluaqtuaq iḷuviġmun isiqmiñiqsuq, qiñiqługu aasrii ukpiqsripḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iliŋik kaŋiqsianilguiññiġaaksuli aglausimaruaq uqałiq itnaqsimaruaq ilaa aŋitqikkisiñipḷugu tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tarakŋa taapkuak maliġuaqtik utiġniqsuk aŋiḷaaqhutik. ");
INSERT INTO eskNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary-li siḷataani itluni iḷuvġum qianiqsuq. Qiallaġmi auġruaġniqsuq qiñiġukhuni iḷuviġmun. ");
INSERT INTO eskNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aasrii qiñiqtuq malġuŋnik israġullaŋnik atnuġaallaŋnik qatiqtaanik aquppiruak Jesus-ŋum timaan irviani, iḷaqataa niaquan tuŋaani aasriiñ iḷaqataa isigaiñ tuŋaatni. ");
INSERT INTO eskNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Taapkuak nipliutiniġaak, “Marii, suvaata qiavich?” Kiuniġik, “Iñuich aullautiniġaat Ataniġa, aasriiñ nalugiga iliŋitñun napmun inillaktilaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Taatnaqqaaqhuni kiŋiaqhuniasrii qiñiġniġaa Jesus qichaqtuaqtuaq, aglaan iḷitchuġinġiññiġaa Jesus-ŋutilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus-ŋum apiqsruġniġaa Mary, “Suvaata qiavich? Kiña pakikpiuŋ?” Aġnam nautchialiqinasugiplugu nipliutiniġaa, “Iñuuk, aullautigupku uvakŋa, uqautillaŋŋa napmun inillaktilaaŋa; uvaŋali aiyumigiga.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tarra Jesus tuqłuġaa atqanik, “Marii!” Aġnaq kiŋiaqhuni uqaġniqsuq ilaanun, “Rabboni!” (itnautauruaq Hebrew-t uqausriŋisigun, Iḷisautrii!) ");
INSERT INTO eskNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus-ŋum nipliutitqiŋñiġaa, “Aksiŋñiaqnaŋa takku aullanġitchuŋasuli pakmuŋa Aapamun. Aglaan aullaġutin aniaqatiumnun kiligiakkich pakmuŋaġniaġniḷuŋa ilaanun Aapamnun Aapagikkapsitñunlu, uvaŋa Agaayyutimnun suli ilipsi Agaayyutipsitñun.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene uqautityaġniġai maliġuaqtit qiñiġnipḷugu Ataniq suli tamatkuniŋa uqautinipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tamarrumani uvlumi unnukman aullaġniisautaani akunniqsaam, maliġuaqtit katimmiñiqsut atautchimi kiluusautipḷutiŋ nuyuaqhutiŋ Jew-ŋuruaniñ. Taimmaiñaq Jesus-ŋum tikitḷugich akunaŋiġñiġai nipliutiplugich, “Qiñuiññaq ilipsitñun!” ");
INSERT INTO eskNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Taatnaqqaaqhuni qiñiqtinniġai ikiñiġmiñik argaŋmiñi suli saniqqamiñi. Tarra maliġuaqtit quviatchaŋniqsut qiñiqamitruŋ Ataniq. ");
INSERT INTO eskNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus-ŋum nipliutitqiŋñiġai, “Qiñuiññaq illi ilipsitñun! Atripḷugu Aapam tuyuqałha uvamnik, taatnatuntuuq tuyuġigipsi.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Taatnaqamigich aniqsaaġviginiġai taapkua maliġuaqtini nipliutiplugich, “Akuqtuqsiuŋ Ipqitchuaq Irrusriq. ");
INSERT INTO eskNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ilipsi natqiusrimaaġupsigik iñuich killuqsautiŋich natqikkaurut, aglaan natqiusrimaanġitchupsigik killuqsautiŋich natqikkaunġitchut.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iḷaŋarguuq maliġuaqtit, Thomas-mik taiyuutilik Malġimik, tarani inġiññiqsuq Jesus tikitman. ");
INSERT INTO eskNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Atlat maliġuaqtit uqautiniġaat, “Qiñiġikput Ataniq!” Thomas nipliutiniġai, “Qiñinġisuaġupkich ikiñiŋi kikiagich argaiñi suli iḷiḷugich argatka ikiñiŋanun saniġaani ukpiqsriyumiñaitchuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Akunniqsaaŋanikhutiŋ kiñuvatigun maliġuaqtit katimalgiññiqsut, Thomas piqataupluni taavrumani. Talut umiktuutiqaġniqsut, aglaan Jesus akunaŋianilgiññiġai nipliqhuni, “Qiñuiññaq ilipsitñun!” ");
INSERT INTO eskNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ilaan nipliutiniġaa Thomas, “Israutilugich argaktin uvuŋa, qiñikkich argatka, israaġutilugich argaktin saniqqamnun. Arguaqtunġiġutin ukpiqsriiñ!” ");
INSERT INTO eskNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas kiuniġaa, “Ilvich ataniġigikpiñ suli Agaayyutigigikpiñ!” ");
INSERT INTO eskNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus-ŋum nipliutigaa, “Ukpiliqpich qiñianikapŋa kisianik? Qanutun quvianaqtigivat tamatkua ukpiqsriruat qiñiġaluaqnaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus-guuq iñiqtaqaġniqsuq iñugiaktuanik atlanik quviqnaqtuanik savaanik maliġuaqtimi sivuġaatni, aglaksimalutiŋ inġitchuanik ukunani makpiġaani. ");
INSERT INTO eskNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aglaan tamatkua aglausimarut ukpiqsritquplusri Jesus Christ-ŋutilaaŋanik Iġñiŋa Agaayyutim, suli iñuutlasritquplusri ukpiqsrił̣ipsigun ilaanik. ");
INSERT INTO eskNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kiñuagun tamarruma Jesus sagviaqtupsaaġniqsuq iŋmiñik maliġuaqtimiñun siñaani narvam taiyuutiqaqtuam Tiberias-mik, uvva itnaiḷipḷugu, ");
INSERT INTO eskNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter-lu, Thomas-lu taiyuutilik Malġimik, Nathanael-lu Cana-ġmiu Galilee-mi, iġñaglu Zebedee-m suli malġuk atlak maliġuaqtik, iluqatiŋ atautchimiinniqsut. ");
INSERT INTO eskNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter nipliġñiqsuq iḷamiñun “Qalliaġniaqtuŋa.” Taatnaqman taapkua atlat nipliutipmiñiġaat, “Malikkisigiptigiñ.” Iluqatiŋ ikiniqsut umiamun, aglaan unnuaqtutilaaŋani sumikunniiñ qalunġiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Siqiñġum mayuuraałhani Jesus qichaġniqsuq imġum siñaani aglaan maliġuaqtaiñ iḷitchuġinġiññiġaat Jesus-ŋutilaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ilaan nipliutiniġai, “Iḷiḷgaat, qaluutiqaqpisi?” Iliŋisa kiuniġaat, “Naami.” ");
INSERT INTO eskNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ilaan nipliutilgiññiġai, “Siŋitchiuŋ kuvraqsi taliqpian tuŋaaŋanun umiapsi, ilipsiḷi qalukkumuusri.” Maliġuaqtit siŋinniġaat kuvraqtiŋ aasriiñ payyaksaġniġaat nuqitchaqamitruŋ umiam iḷuanun takku qaluuvagitḷuni. ");
INSERT INTO eskNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Maliġuaqtim Jesus-ŋum piqpagikkaŋan nipliutiniġaa Peter, “Piñña Ataniġiniġikput.” Simon Peter-m tusraa'amiuŋ takpiñña Atanġułha, ilaan atitqiksiqamiuŋ atnuġaani mattaummitchani misiŋñiqsuq taġiumun. ");
INSERT INTO eskNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Taapkua iḷai maliġuaqtit kilvaġniqsut umiakun nuqirrutigalugu kuvraq imalik qaluŋnik iliŋich uŋasriuraqhutiŋ siñaaniñ, tallimakipiatun apluqpaktaaqhuni urraksrayuŋnaliktun. ");
INSERT INTO eskNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Iliŋich tulakamiŋ, qiñiqtut iknipiamik qaluŋnik uutaliŋmik suli qiñiqhutiŋ qaqqunik. ");
INSERT INTO eskNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus-ŋum nipliutiniġai, “Uvuŋautrisitchi iḷaŋitñik qaluich qaluktapsi akkuvak.” ");
INSERT INTO eskNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter-m ikitqikhuni umiamun kaliŋñiġaa kuvraq siñaanun imalik qalukpaŋnik, tallimakipiaq malġukipiaq qulit piñasrunik iñugiaktilaaliŋnik; naagatarra iñugiakkaluaqhutiŋ kuvraŋat alinġiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus-ŋum nipliutigai, “Uvuŋaġusri niġisitchi.” Nalliataunniiñ maliġuaqtit apiqsruġumanġiññiġaa, “Kisuuvich?” Iliŋisa iḷitchuġiniġaat Atanġutilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus-ŋum qalliḷaaqhuni tigu'amiuŋ qaqqiaq autaaġniġaa iliŋitñun. Taatnatunsuli piñiġaa qaluk. ");
INSERT INTO eskNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Taavrumani piñatchiġñiġai Jesus-ŋum qiñiqtitałłi iŋmiñik maliġuaqtinun aŋitqiqqaaqhuni tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iliŋich niġianikmata Jesus-ŋum nipliutigaa Simon Peter, “Simon! Iġñiŋa John! Piqpagitlukpiña ukunakŋa?” Peter-m kiugaa, “Aa, Ataniiq! Iḷisimagiñ uvaŋnun piqpagiłhiñ.” Jesus-ŋum nipliutigaa, “Niġipkakkich ipnaiyaatka.” ");
INSERT INTO eskNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tugliḷiqł̣ugu Jesus nipliutilgiññiġaa, “Simon! Iġñiŋa John! Piqpagiviña?” Peter-m kiugaa, “Aa, Ataniiq! Iḷisimagiñ uvaŋnun piqpagiłhiñ.” Jesus-ŋum nipliutilgitchaa, “Qaunagikkich ipnaitka.” ");
INSERT INTO eskNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Piñatchiqł̣ugik Jesus-ŋum nipliutilgitchaa “Simon, Iġñiŋa John, piqpagiviña?” Peter aliatchaŋniqsuq Jesus-ŋum apiqsruqmani piñasruni atiruamik, “Piqpagiviña?” Aasrii Peter-m kiuniġaa, “Ataniiq! Iḷisimagiñ suapayaaq. Iḷisimagiñ uvaŋnun piqpagiłhiñ.” Jesus-ŋum kiugaa, “Niġipkakkich ipnaitka. ");
INSERT INTO eskNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iḷumutuuruamik nipliutigikpiñ, nutau'avich tapsiaġiksipḷutin igliġaqtutin napmupayaaġukavich. Aglaan utuqqaġuġuvich atlam iñuum qiḷiġniaġaatin israaqtillutin aullautilutin aullaġvigisrunġisaqnun.” ");
INSERT INTO eskNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Taatnaqamiuŋ Jesus-ŋum uqautiginiġaa qanutchikun tuqułikun Peter-mun kamanaqtinniaqtilaaŋa Agaayyun. Taatnaqqaaqługu nipliutiniġaa, “Maliġuaŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter-m kiŋiaqhuni qiñiġniġaa maliġuaqti Jesus-ŋum piqpagikkaŋa maliktuaq. Taimñauniqsuq ikusiksimaaqtuaq qanitluni Jesus-mi nullautchiqamiŋ suli apiqsruqtuaq, “Ataniiq, kia aatchuutigitniŋniaqpatin?” ");
INSERT INTO eskNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter-m qiñiqamiuŋ taamna apiqsruġniġaa Jesus, “Ataniiq! Qanuġniaqpaliuna?” ");
INSERT INTO eskNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus-ŋum kiugaa, “Uvaŋa iñuupkaġukkupku aggitqiŋñiałłamnunaglaan, suuva taamna ilipnun? Maliŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Taamna uqauttutaa siaminniqsuq akunġatnun aniqatigiiñun taamna maliġuaqti tuquyumiñaiññipḷugu. Jesus taatnanġiññiqsuq tuquyumiñaiññiḷugu, aglaan itnałhiñaqhuni, “Iñuupkaġukkupku aggitqiŋñiałłamnunaglaan, suuva taamna ilipnun?” ");
INSERT INTO eskNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Taamna maliġuaqti taamnauruq quliaqtuaqtuaq tamatkuniŋa, sulipsuuq aglaktuaq tamatkuniŋa, aasrii nalunġitchikput quliaqtuaġikkaŋan iḷumutuułha. ");
INSERT INTO eskNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iñugiakkaluaqtuq atla qanusriq Jesus iñiqtaġikkaŋa. Iluqatiŋ aglaksimalutiŋ atausriukattaaġlugich pimakpata, iluqaniqanu nunam tigummianilgunayaitpalukkai aglaich aglakkaukpata. ");
INSERT INTO eskNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Aglaktuŋa uumiŋa Theophilus-mun piqpagikkamnun. Sivulliġñi makpiġaani aglaktuaŋaa suraġałipayaaŋiñik Jesus aullaġniił̣haniñaglaan savaaqałiġmiñik ");
INSERT INTO eskNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taivrumuŋaaglaan uvlumun Agaayyutim aullautipmani tatpakmuŋa. Sivuani Jesus aullaġaluaqani ilaan Ipqitchuakun Irrusikun alġaqsruġai piksraqtaaġikkani uqqiraqtauruksrauplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesus tuqqutitqaaqhuni piqatigiraġigai uqqiraqtit sagviaqtuutigai arguaqtuġnaġumiñaiqł̣ugu aŋitqił̣ha malġukipiat uvlut akunġatni, suli Jesus-ŋum uqautiplugich aŋaayuqautaanik Agaayyutim. ");
INSERT INTO eskNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iḷaatniguuq Jesus-ŋum piqatigilgitñamigich tiliñiġai itna, “Uniññiaqnagu Jerusalem aglaan utaqqiyumigiksi aatchuutiksraŋa Aapaa akiqsruutigikkaŋa qaitkisiñipḷugu, uqautigikkaġa ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Taimñaguuq John paptaaġutiqaqtuaq iñuŋnun imiġmik aglaan aquatigun qapsich uvlut paptaakkaugisirusi Ipqitchuakun Irrutchikun.” ");
INSERT INTO eskNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Taapkua uqqiraqtauruksrat katilgitñamiŋ piqatigiplugu Jesus apiqsruġniġaat, “Ataniiq! Uvva taavrumani nappatqiŋñiaqpiuŋ aŋaayuqaun Israel-aaġmiunun umialiqaġumiñaġlugich taimanisun?” ");
INSERT INTO eskNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus-ŋum kiuniġai, “Aapaa kisimi sivunniġisigaa qakugun atuumałiksraŋa. Ilaan iḷisimapkaġumiñaitkaa tamanna ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Akuqtuigisirusi saŋŋimik taimña Ipqitchuaq Irrusriq aggianikpan ilipsitñun, aasii iḷisimaraugaqsiḷusi uvapkun Jerusalem-mi iluqaaniḷu Judea-mi suli Samaria-mi unniiñ nunaaqqipayaaŋiñi nunam.” ");
INSERT INTO eskNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Taatnaanikamigich Agaayyutim nuqinniġaa tatpakmuŋa iliŋitñun qiñiqtitluni aasii iliŋisa qiñitlaiqsiġniġaat nuviyam puuqtiqmauŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Aullaqtiqman qiñiġugaaqtitlugich tatpakmuŋa, taimmaiñaq malġuk iññuk atnuġaallak qatiqtaanik qikaqasiitḷiġñiqsuk iliŋitñun, ");
INSERT INTO eskNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nipliqhutik, “Galilee-ġmiut, suvaata qikaqhusi qiñiqniaqpisi qiḷaŋmun? Tamanna Jesus aullaqtuaq ilipsitñiñ tatpakmuŋa aggitqikkił̣hitchuq taatnatun ilipsi qiñiqmatun aullaqman tatpakmuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Maliġuaqtit tavrakŋa utiġniqsut Jerusalem-mun iñġiuramiñ taiguutiqaqtuamiñ Olives-mik uŋasikpaguni inġiññiqsuamiñ nunaaqqimiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tavruŋa tikitñamiŋ Jerusalem-mun, iliŋich mayuġniqsut inimun taivrumuŋa irvigikkaġmiknun, Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, James iġñiġikkaŋa Alphaeus, Simon-lu Zealot-ŋuruaq, suli Judas iġñiġikkaŋa James-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iluqaġmiŋ katiniqsut akulaiqł̣ugu iŋiqsruġviksraġmiknun piqasiqhutiŋ aġnanik suli Mary-mik aakagikkaŋanik Jesus nukatchiaŋiñiglu. ");
INSERT INTO eskNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ikituurat uvlut aquatigun ukpiqtuat katimaniqsut, tallimakipiaq iñuiññamik iñugiaktigiyuŋnaqhutiŋ. Peter-m makitluni nipliutiniġai, ");
INSERT INTO eskNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Aniqatiumaaŋ, Ipqitchuam Irrusim uqaqtinniġaa David makpiġaaŋiñi Agaayyutim. Uqaġiniġaa Judas-kun sivuani atuumagaluaqtitnagu ilaan savaaqałiksraŋa, taamna Judas sivulliuruaq tiguriruksranik Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas iḷaugaluaqtuaq uvaptikni atakkii Jesus-ŋum piksraqtaaġikkaŋa savaqatigitquplugu uvaptikni. ");
INSERT INTO eskNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas-ŋum aatchuutigianikamiuŋ Jesus akiññaktaaqaġniqsuq maniŋñik. Taavrumiŋaasiiñ tauqsiġñiqsuq nunaviñiġmik ilaan iḷuviġikkaġmiñik. Tavrani katakami iluqani iḷua qaaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iluqaġmiŋ iñuich Jerusalem-mi ittuat tusaaniġaat, aasii iŋmiŋ uqaġmikkun taiguusiġniġaat Judas-ŋum tuqquvia Akeldama-mik (mumiutiqaqtuamik nuna augum maqqivia). ");
INSERT INTO eskNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Agaayyutim makpiġaaŋani aglausimaruaq Psalms-ni itna, ‘Ilaan tupqa iñuiġumauq iññitqikkumiñaiġuni.’ Aglausimaruaqsuli, ‘Atlamik iñuŋmik inaŋiqsiqaġumauq savaaŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Taatnaqługu iñuk inaŋiutiruksrauruq Judas-ŋum savaaŋanun. Taamna iñuk ittuksrauruq aullaġniimaruaq uvaptikni aasiisuli iḷisimarautlasiruaq aŋitqił̣hagun Atannapta Jesus. Ilaa piqatigisimakkaqput John-ŋum quliaqtuaġipmauŋ paptaaktitchił̣ł̣isuli nayuqtigisimakkaqput uvlumunaglaan Agaayyutim aullautipmauŋ Jesus pakmuŋa qiḷaŋmun.” ");
INSERT INTO eskNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iliŋich nalunaiġiñiqsut malġuŋnik iññuŋnik Joseph-miglu taiguutiliŋmik Barsabbas-mik atiqaqmiruaq Justus-mik suli Matthias-miglu. ");
INSERT INTO eskNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Aasii agaayuniqsut itnaqhutiŋ, “Ataniiq! Ilvich iḷisimarauŋuruatin uummatiŋitñik iñupayaat, taatnaġlugu tikkuaġutillaŋniaqtigut nalliaknik piksraqtaaqaġuvich. ");
INSERT INTO eskNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Taamna uqqiraqti inaŋiutiyumuuq Judas-mun atakkii unisaġigaatigut aullaqhuni piksraqtaaġmiñun.” ");
INSERT INTO eskNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Taatnaqqaaqhutiŋ tigusiñiqsut attak ilaqataaknik. Taatnaqmata Matthias piksraqtaaŋuniqsuq aasii iḷaliutikkaupluni qulit atautchinun uqqiraqtinun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Uvluġġuuq taiguutilik Pentecost tikiumapman iluqatiŋ ukpiqsriruat katimalgiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Taimmaiñaq iliŋisa tusaagaqsiḷiġniġaat siiġruktuaq pakmakŋa liilaa anuqłiqpaktitmatun. Taamna siiġruktuaq tusaġnaqsiñiqsuq iluqaani inimi. ");
INSERT INTO eskNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iliŋich qiñiaqsiñiqsut ikniġmik liilaa qiññaliŋnik uqqatun siamitlutiŋ iñupayaanun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ipqitchuam Irrusim aŋalatkaqsiñiġai iluqnaaqługich. Taapkua iñuich uqaaqsiñiqsut atlakaaġiiñik uqqiqhutiŋ, taatna kaŋiqsiñaqsipḷugich Ipqitchuam Irrusim uqaqupmatiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tavraniguuq Jerusalem-mi Jew-ŋuruat iñuuniaqtut nunaaqqipayaaŋiñiñ nunam taluqsriruat Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tusaakamitruŋ siiġruktuaq iñugiaktuat iñuich katiniqsut taapkunuŋa. Iluqatiŋ qanuġviiġñiqsut tusaakamisigik taapkua uqaqtuat kaŋiqsiñaqsipḷutiŋ sumiugiisigun uqqatigun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Quviġutchallapiaqhutiŋ uqaaqsiñiqsut, “Tamatkua uqaqtuat Galilee-ġmiuŋurut, amii? Qanuqhutiŋ ukua uqaqpat uqaptiknik? ");
INSERT INTO eskNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naagaunniiñ kaŋiqsitḷanigivut uqaqmata uqausiḷḷaaptigun iñuguqniałłaptigun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Uvagut Parthia-ġmiut, Media-ġmiut, Elam-miut, Mesopotamia-ġmiut, Judea-ġmiut, Cappadocia-ġmiut, Pontus-miut, Asia-ġmiut, ");
INSERT INTO eskNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia-ġmiut, Pamphylia-ġmiut, Egypt-miut. Uvagut iñuich nunaaqqimiñ Cyrene-miñ nunami Libya-mi, suli iglaat nunaaqqimiñ Rome-miñ, ");
INSERT INTO eskNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","suli Crete-taġmiut Arabia-ġmiutlu. Aniŋaruaguut Jew-ŋupluta aasiiñ mumiksuaguut Jew-ġuqsimaaqhuta—iluqapta tusaagivut kaŋiqsipḷugiḷḷu tamatkua uqaqmata kamanaqtuatigun Agaayyutim iñiqtaigun.” ");
INSERT INTO eskNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Quviġutchallapiaqamiŋ kaŋiqsitḷaiqhutiŋlu apiqsruqtautiniqsut avatmun, “Qanuutauva una?” ");
INSERT INTO eskNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iñuiḷḷiasiiñ iḷaŋich mitautigiplugich ukpiqtuat uqaaqsiñiqsut, “Ukua imiliḷḷapiaqsimaplutiŋ piñiqsut.” ");
INSERT INTO eskNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Taatnaaqsipmata Peter makittuq piqasiqhuni uqqiraqtiqatmiñik kiutyaqługich. Nipitusipḷuni nipliutiniġai, “Jew-ŋuqatiptaa suli iñuuniaqtuasii Jerusalem-mi, naalaġniḷḷaksitŋa! Nalupqinaiġḷugu uqautiuraallaglapsi taavruma suutautilaaŋanik. ");
INSERT INTO eskNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ukua imiliqsauŋuŋitchut isumałłapsisun atakkii uvlaaŋusugaaqtuqsuli. ");
INSERT INTO eskNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Taamna atuumaruaq Joel-ŋum sivuniksriqirim uqautigikkaŋa itna, ");
INSERT INTO eskNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Agaayyun uqaqtuq, itnaiḷiḷugu itkisiruq aqulliġñi uvluni, Uvaŋa siamitkisigiga Irrusiġikkaġa iluqaitñun iñuŋnun, Iġñasi suli panigikkasi sivuniksriqiaqsigisirut, nutaaġikkasi qiñiqquuraaliġutiŋ suli utuqqanaasi siññaqtuqtaġutiŋ; ");
INSERT INTO eskNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","aa, kuvviqigisigitka savaktitka aŋutitlu aġnatlu Irrusiġikkamnik taipkunani uvluni aasii sivuniksriqiaqsiḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Qiñiqtitkisigitka quviqnaqtuat qiḷaŋmi suli atlayuaġnaqtuat nunami, auglu ikniġlu suli itchialaruaq, ");
INSERT INTO eskNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","siqiñiqunniiñ tanuġaaqsiḷugu unnuatun unniiñ tatqiq kaviqsaaġuġlugu auktun sivuani kamanallapiaqhuni uvluan Atanġuruam tikiumałiksraŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Taipkunaniasii kisupayaaq tuqłuqpan Agaayyutmun ilaan anniqsuġisigaa.’ ");
INSERT INTO eskNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel-aaġmiut, naalaġnisitchi uqałłamnun! Jesus Nazareth-miñ aŋutauruq Agaayyutim tilikkaŋa. Agaayyutim savaaġipkaġaa saŋŋiqaqhutiŋ atlayuaġnaqhutiŋlu qiñikkiqsuutinik. Qiñiġisi nalupqinaiqł̣ugu iḷisimaplugich tamanna atakkii atuummipḷuni maani akunnapsitñi. Taavrumuuna iḷisimapmigiksipsuuq Agaayyutmun tuyuġiłha. ");
INSERT INTO eskNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ilipsi aŋalataksrirrutigigiksi Jesus sumiuŋuruanun tuqqutitlugu kikiaktuutipkaqługu sanniġutamun. Aglaan Agaayyutim pisułiġmigunlu iḷisimałiġmigunlu sivunniuŋanikkaŋa taatna. ");
INSERT INTO eskNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aglaan Agaayyutim makititnamiuŋ tuqułiġmiñ pituiqł̣ugu iñuułiġmun. Jesus tuqqutqikkumiñaitchuq atakkii ilaa nayuutiyumiñaitchuq iḷuviġmi tuquŋaruapayaatitun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Taivruma David-ŋum uqautiginiġaa itna, ‘Uvaŋa qiñiġiga Atanġuruaq sivuqqamni ataramik. Ilaa taliqpimniitluni aasiiñ tunŋalguruŋa ilaani iłuiḷḷiuqama. ");
INSERT INTO eskNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Taatnaqługu uummatiga quviasuktuq, suli nipiqaqtuŋa quviasułiġmik. Tuqugisigaluaŋŋaġmaunniiñ niġiugaġigiga nalupqinaiqł̣ugu, ");
INSERT INTO eskNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Agaayyuun, unitchumiñaitchiñ iñuusiġa iḷuviġmun, naagaqaa timaa savaktivich piunġiġniaqulugu. ");
INSERT INTO eskNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Urriqsuutriruasii uvamnun apqutmik iñuuniaġviksramnik, aasii quviasukkisiruŋa atakkii nayuutipluŋa ilipni.’ ");
INSERT INTO eskNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Aniqatiut, uvaŋa uqautiraksraġigipsi nalupqinaiġḷugu sivulliaptigun David-kun. Ilaa tuqupman iḷuviġaat, aasiiñ iḷisimagaat iḷuvġa marrumuŋaaglaan uvlumun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ilaa sivuniksriqirauruaq suli kaŋiqsimaplugu Agaayyutim akiqsruutigikkani iŋmiñun, Agaayyutim nalupqinaiqsruutinikkaŋa David-ŋum kiŋuviaŋiñ iḷaŋat ataniġuqtitkisiñipḷugu iŋmisun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David-ŋum qiñiqquuraaġiniġaa qanuq Agaayyutim aŋipkatqił̣iksraŋa anniqsuqti akiqsruutigikkaŋa taamna Christ uqautigiplugu itnaqhuni, ‘Agaayyutim uniŋitchaa ilaa iḷuviġmun suli timaa piunġiŋitchuq.’ ");
INSERT INTO eskNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Taamna Jesus Agaayyutim aŋitqiksitkaa iḷuviġmiñ, aasii uvagut iḷisimaraurugut taavrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Agaayyutim ilaa taliqpiŋmiñuktitkaa kamanaqsipḷugu suli qaitchipḷugu Ipqitchuamik Irrusiġmiñik Aapami akiqsruutigikkaŋatun aasiiñ Jesus-ŋum qaitchipḷugu uvaptiknun. Tamanna akuqtuġikput pakma, taatnamik qiñiaqsigiksi tusaaplugulu savaaqsipman uvaptigun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David iŋmi timituummaġmi pakmuŋaqsimaitkaluaqtuq, aglaan nipliġñiqsuq, ‘Agaayyutim nipliutiniġaa Ataniġa, Aquvittin kamagiviksraułipnun, ");
INSERT INTO eskNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","aquppił̣ł̣apni uumiksritin aŋalataksrirrutigigisigitka ilipnun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aasiiñ Israel-aaġmiupayaasii iḷitchuġiraksraġigiksi nalupqinaiġḷugu, taamna Jesus kikiaktuutikkaqsi Agaayyutim inillakkaa ataniġuqługu suli anniqsuutauplugulu.” ");
INSERT INTO eskNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Taapkua iñuich tusaakamitruŋ Peter-m uqautigikkaŋa iłuiḷḷiuġniqsut. Apiqsruġniġaat Peter-lu atlatlu uqqiraqtit, “Aniqatiut, Qanuġisiñiqpisami?” ");
INSERT INTO eskNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter-m uqapsaaġniġai, “Nunuuraliġusi mumigitchi killuqsautipsitñiñ. Suli atausriukattaaġusi paptaaqtittitchi ukpiqsririġuġusi atqagun Jesus Christ. Agaayyutimli natqiutiyumagaasi killuqsautipsitñiñ, aasiiñ ilaan aatchuġisigaasi Ipqitchuamik Irrusimik. ");
INSERT INTO eskNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Taamna Agaayyutim akiqsruutigikkaŋa tuŋaaqaqtuq ilipsitñun qitunġapsitñunlu iluqaitñunlu ittuanun uŋasiksuami, iñuich iluqaisa Atanġuruam Agaayyutipta tuqłuġai iŋmiñun.” ");
INSERT INTO eskNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter uqaqtuq iñugiaktuanik atlanik uqałiġnik. Aasiiñ ilaa naatchiqami itnaqługich, “Annautillaksaġniaġitchi ilipsitñik anasiñŋuqsautmiñ tikiññiaqtuamiñ pigiitchuanun iñuŋnun tuqqutchiruanun Jesus-mik.” ");
INSERT INTO eskNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iñugiaktuat ukpiqsriñiqsut uqałiġmik suli paptaaqtitlutiŋ, iñuk 3,000-yuŋnaq iḷaliutiniqsuq ukpiqsriruanun tamarrumani uvlumi. ");
INSERT INTO eskNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iliŋich iḷisaaqaaqsiñiqsut uqqiraqtiniñ, aasii piqasiqsuutiniqsut niġiqatigiikhutiŋ suli iŋiqsruqatigiikhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uqqiraqtit iñiqtaqaġniqsut iñugiaktuanik quviqnaqtuanik savaanik, naagaunniiñ iñupayaat ikpigiagutiniġaat Agaayyutim savaaqałha uqqiraqtitigun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iluqaġmiŋ ukpiqtuat atautchimiiyusiñiqsut suli piqaqtirrutiplutiŋ suuraġmikkun avatmun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Inuqsriuliqamiŋ tunisiñiqsut nunautmiknik suli suuramiknik, aasiiñ autaaqługich piññaktaatiŋ iluqaitñun inuqsriuqtuanun. ");
INSERT INTO eskNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Uvlutauġaġipman iliŋich katraġniqsut agaayyuvikpaŋmun. Niġiraġaġniqsut atautchimi kiŋuniqmikni, aasiiñ niġikamiŋ quviasukhutiŋ pisuiḷḷapiaqhutiŋlu. ");
INSERT INTO eskNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Iliŋisa quyaraġigaat Agaayyun, aasiiñ atlat iñuich nakuaġigaich ukpiqsriruapayaat. Suli uvluġaġipman Atanġum iḷaniktuuqtinniġai iñuŋnik ukpiqtuaŋuruanun tamatkuniŋa anniqsukkaġmiñik. ");
INSERT INTO eskNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iḷaatniguuq Peter-lu John-lu utlautiniqsuk agaayyuvikpaŋmun, iñuich iŋiqsruġviat tikitmałhani. ");
INSERT INTO eskNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Agaayyuvikpaŋmi paaqaġniqsuq taggisiliŋmik Piññaqnaqtuamik. Tavraniguuq aŋun una aquppiraqniqsuq pisunġaŋitchuaq aniñiġmiñaglaan. Uvluġaġipman iḷamiñun tavruŋautipkaġaġniqsuq taavrumuŋa paamun iŋiqsruġviksraġmiñun maniuranik iñuŋniñ isiqtuaniñ agaayyuvikpaŋmun. ");
INSERT INTO eskNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter-mlu John-ŋumlu apqusaaqmakni isiaqsipḷutik agaayyuvikpaŋmun iŋiġniġik aatchullałiksraġmigun maniŋmik. ");
INSERT INTO eskNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Taapkuak kiŋiaqamitku iriġruiñaaqługu Peter-m nipliutiniġaa, “Qiñiqtiguk!” ");
INSERT INTO eskNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Taavruma iñuum qiñiaqsiñiġik niġiukhuni aatchuusiaksraġmiñik iliŋikñiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peter-m nipliutiniġaa, “Maniitchuŋa suuramikunniiñ aglaan aatchuġniaġikpiñ pigikkamnik, atqagun Jesus Christ Nazareth-mium pisuqugikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peter-m tigukamiuŋ taliqpiagun makitquplugu, taimmaiñaq aŋutiqniam niuŋi sayaniktiġniqsuk. ");
INSERT INTO eskNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nutiŋniqsuq qikaqtiqhuniasiiñ pisuaqsipḷuni. Ilaan isiqatiginiġik Peter-lu John-lu agaayyuvikpaŋmun pisukhuni misigaqsimmaġmi quyyasimmaan Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Iñuich tavrani qiñiġniġaat pisukługu quyammaġmi Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iñupayaat iḷisaġiniġaat iŋiularauplugu aquppisuuruaq agaayyuvikpaum paaŋani taggisiliŋmi Piññaqnaqtuamik. Iluqaġmiŋ quviġutchallapiaġniqsut taavrumuuna atuumaruakun taavrumuŋa aŋutmun. ");
INSERT INTO eskNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iñuitguuq qiñiqamitruŋ pisutlasipkakkauruam saqunaurapayaaŋak Peter-mlu John-ŋumlu aupił̣ł̣autiginiġaat, aasiiñ qiñiġiaqługich katimmaviŋmun taggisilikkun Solomon. ");
INSERT INTO eskNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter-m qanuġviiqsuat qiñiqamigich nipliutiniġai, “Israel-aaġmiut, qanuġmi taamna quviġutchautigivisiuŋ qiñiqpaaqsipḷutaasiiñ? Uvaguk pisutlasipkaŋitkikpuk manna aŋun saŋŋiptikkun naagaqaa ukpiqsrił̣ł̣aptikkun. ");
INSERT INTO eskNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aglaan Agaayyutaata sivulliapta Abraham-ŋumlu Isaac-ŋumlu Jacob-ŋumlu iłuaqsipkaġaa manna aŋun Jesus-kun, aasiiñ taavrumuuna ilaan kamanaqtitkaa iġñiñi Jesus. Ilipsi qaitkiksi Jesus aŋalatinun pigiitchuanun suksraaqługu sivuġaani Pilate-ŋum sivunniutianikmauŋunniiñ patchisaiġukługu. ");
INSERT INTO eskNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ilaa iluqnauqsimaruaq Agaayyutmun nalaunŋaruaġlu naagasuli ayakkiksi, iŋiqsruqługu Pilate pituiġitquplugu iñuaqtuqtimik. ");
INSERT INTO eskNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Taatnałłapsigun tuqqutkiksi taamna qaitchiruaq iñuułiġmik aglaan Agaayyutim aŋitqiksitaŋa tuquŋaruaniñ. Uvagut iḷisimarriqsimmaaġikput taamna. ");
INSERT INTO eskNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Turviqaqhuni atqanik Jesus-ŋum manna pisutlaiḷaaq qiñikkaqsi iḷisimakkaqsiḷu mamititkauruq. Taamna aŋun ukpiqsriñiqsuq Jesus-ŋum atqanik, taatnaqługu iłuaqsikkauruq sivuqqapsitñi. ");
INSERT INTO eskNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Aniqatiumaaŋ, iḷisimagaluaġmigiga una, ilipsiḷu sivulliuqtituummapsiḷu qaitkiksi Jesus sumiuŋuruanun aglaan nalugiksi suvaata taatnatun irrutrił̣iqsi Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Agaayyutim iŋiḷġaan uqaġikkaŋa iluqaisigun sivuniksriqirimigun akiqsruutauruaq anniqsuqti nagliksaaqtuksraunipḷugu, aasiiñ ilaan taatnaqtitkaa. ");
INSERT INTO eskNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aasiiñ mumigitchi suli saallusi Agaayyutmun, ilaanli piiġumagai killuqsautigikkasi. ");
INSERT INTO eskNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Taatnaġupsi Atanġum sayyaaġiksipkaġisigaasi irrutchipsigun. Taivrumani ilaan tuyuġitlayumagaa Jesus annautriksraqtaġianikkani ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Taamna Jesus qiḷaŋmi ittuksrauruq taivrumuŋa uvlumun supayaat nutaaġułiksraŋatnunaglaan, Agaayyutim ipqitchuat sivuniksriqiraiñ uqautigipmatun iŋiḷġaan. ");
INSERT INTO eskNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses-ŋum nipliutiginiġaa, ‘Agaayyutim Atanipsi tuyuqaġisigaasi sivuniksriqirimik, atriḷugu tuyuqałłi uvamnik; taimña itkisiruq iñupsitñiñ. Ilipsi naalaġniraksraġigiksi supayaamik uqautikpasi. ");
INSERT INTO eskNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kiñapayaaq naalaġniŋitkumi sivuniksriqirim nipliutigikkaŋanik iḷauyumiñaitchuq Agaayyutim iñuiñi suli piyaqqukkaugisipḷuni.’ ");
INSERT INTO eskNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iluqaġmiŋ atlat sivuniksriqirit Samuel-miñaglaan uqaqsritkaumaruat uqautigigaich makua nayukkavut uvlut. ");
INSERT INTO eskNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Atuumaruaq uglupak atuumaruq pisigiplusi, ilipsi kiŋuviaġikkaŋasi Abraham-ŋum. Agaayyutim akiqsruġaa qitunġanik, suli sivuniksriqirit uqautigaatigut taavrumiŋa akiqsruutmik, itna, Uvaŋa piḷiutiqaġisigitka iluqaisa iñuich nunami kiŋuviaġikkaptigun. ");
INSERT INTO eskNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Taatnaqługu Agaayyutim aŋitqiksitmauŋ savaktini Jesus tuyuġigaa ilipsitñun sivulliuplugu ikayuġukhusi mumigusiḷu pigiiḷiqiłiġikkapsitñiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter-lu John-lu uqautrisugaaqtitlugik iñuŋnik agaayuliqsit suli qaunaksria agaayyuvikpaum piqasiqhutiŋ Sadducee-ŋuruanik tikiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iliŋisa iłuagiŋiññiġaich uqqiraqtik iḷisautripmaknik Jesus aŋitqiŋñipḷugu tuquŋaruaniñ, taamnaasiiñ iḷitchuqqutaupluni tuquruat aŋitqikkisił̣hatnun. ");
INSERT INTO eskNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tigupkaġniġaich isiqtaupkaqługik isiqsiviŋmi unnuapak unnuaġuqhunikii. ");
INSERT INTO eskNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aglaan iñugiaktuat tusaaruat uqautaaknik ukpiqsriñiqsut, iñugiaktilaaliyuŋnat 5,000-mik aŋutiłhiñat. ");
INSERT INTO eskNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Uvlutqikman Jew-ŋuruat sivulliuqtiŋiḷḷu sivulliuqtiġruatlu aglaliqiritlu katiniqsut Jerusalem-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas-tuuq qaukłiat agaayuliqsit itmiñiqsuq suli Caiaphas-lu John-lu Alexander-lu piqasiqhutiŋ atlanik ittuanik qaukłium agaayuliqsim iḷaiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Taapkua Peter-lu John-lu itqutipkaqamisigik apiqsruqtaaqsiñiġaich, “Qanuqługu iłuaqsipkaqpitku taamna aŋun? Qanutchimik saŋŋiqaqpisik? Kia atqagun taamna pivitku?” ");
INSERT INTO eskNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter-m aŋalatiqaqhuni Ipqitchuamik Irrutchimik kiuniġai, “Sivulliuqtauruasii sivulliuqtiġruaŋuplusi, ");
INSERT INTO eskNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Suvaatatai tamarrumani uvlumi uqaqsittaaġutikkauviñuk ikayuił̣ł̣aptigun taavrumiŋa pisutlaiḷaamik iłuaqsipkakkaptiknik? ");
INSERT INTO eskNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Iluqasi suli Israel-aaġmiupayaat iḷisimaraksraġigiksi una, Saŋŋiqaqtuq atiġikkaŋagun Jesus Christ Nazareth-mium kikiaktuutikkaqsi aasiiñ Agaayyutim aŋitqiksitlugu tuquŋaruaniñ. Taatnaqługu taamna aŋun qikaqtuq iłuaqsikkaupluni sivuqqapsitñi. ");
INSERT INTO eskNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Taamna Jesus taimña Agaayyutim uqałhiñ uqautigikkaŋat itna, ‘Uyaġak tuppirit ayakkaŋat, taamna uyaġak piitchuiḷḷapiaġaqtuq tuppirauni.’ ");
INSERT INTO eskNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Aasiiñ Agaayyun atchiiruq atautchił̣hiñamik iluqaani nunami taavrumuuna atikun anniqsuġumiñaqsipḷuta. Taamna anniqsuqti Jesus Christ kisimi ittuq.” ");
INSERT INTO eskNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tarra uqaqsittaaqtitchirit quviġutchaŋniqsut qiñiqamisigik Peter-mlu John-ŋumlu taluqsrautaisilaaŋakniglu iḷisaqsimaisilaaŋakniglu. Iḷisimagaich piqataułhak Jesus-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aasiiñ qiñiġniġaat aŋun iłuaqsikkauruaq qikaqataułha Peter-miḷu John-miḷu. Taatnaqhutiŋ nipliḷguiññiqsut akikŋaġlugik. ");
INSERT INTO eskNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Taatnaqqaaqhutiŋ aniḷḷaquniġaich uqaqsittaaġviŋmiñ, aasiiñ anipmaknik sivunniuqtaullakhutiŋ itna: ");
INSERT INTO eskNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Qanuġlugik atanniġisivisigik ukuak aŋutik? Jerusalem-miupayaat iḷitchuġianiŋniġaat atlayuaġnaqtuaq iłuaqsipkaił̣iq atuumakkaŋa taapkuŋnuuna, aasiiñ naagaaġumiñaitkikput. ");
INSERT INTO eskNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aglaan siamitquŋitḷugu marrumani tusaayugaaq iñuŋnun, taatnaġuta aniqsraaqtuġlavut uqatqiquŋiḷḷugik kimununniiñ taavrumuuna Jesus-kun.” ");
INSERT INTO eskNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Taatnaiḷipḷugu sivunnianikamiŋ iñiqtiġniġaich quliaqtuaquŋitḷugik Jesus-kun iñuŋnun sumiunniiñ naagaqaa itqautitqiquŋitḷugich taavruma atqanik. ");
INSERT INTO eskNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aglaan Peter-mlu John-ŋumlu kiuniġaik, “Nalliqsi tupiginaġayaqpisigu? Ilipsi naagaqaa Agaayyun? Nalliak nakuaġitlukpauŋ ilaan? Sivunniqsiuŋ taamna! ");
INSERT INTO eskNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Uqautigiŋaiġumiñaitkikpuk sua qiñikkaqpuk tusaakkaqpuglu.” ");
INSERT INTO eskNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aniqsraaqtutqianikamisigik aasiiñ pilitlugik agvisiksraitḷutiŋ anasiñŋuqsalguiññiġaich. Iqsigipḷugittuuq iñuich atakkii iñupayaat kamaksriḷḷapiaqhutiŋ Agaayyutmik tamarrumuuna atuumaaniktuakun pisutlaiḷaamun. ");
INSERT INTO eskNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Taamnaguuq aŋun quviqnaqtuakun iłuaqsipkakkauruaq malġukipiaġuaniksimaruaq. ");
INSERT INTO eskNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Taapkuagguuq Peter-lu John-lu anipkapqauraqmatik utiġniqsuk ukpiqtuaŋuruaqatiumiknun uqautiplugich qanuq qaukłiata agaayuliqsit suli sivulliuqtiġruat sivunniułhatnik. ");
INSERT INTO eskNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iliŋisa tusaakamitruŋ agaayuqatiqaġniqsut itnaqhutiŋ, “Kamanaqtuatiin atanġuruaq, iñiqsiruatiin iluqaanik qiḷaŋmiḷu nunamiḷu taġiumiḷu. ");
INSERT INTO eskNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aasiiñ ilvich uqaqtuatin Ipqitchuakun Irrutchikun sivulliaqput David savaktigikkan uqaqman itna, ‘Suvaata Jew-ŋuŋitchuat qinnakpat? Suvaata iñuich sivunniuqpat imaiḷaanik? ");
INSERT INTO eskNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Umialgi nunaaqqipayaani sivulliuqtillu paqnaniġaich aŋuyautnatiŋ akiḷḷiḷiġuqługu Agaayyutauruaq ilaan anniqsuqtiksriukkaŋalu.’ ");
INSERT INTO eskNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Iḷumun marrumani nunaaqqimi Herod-lu Pontius Pilate-lu piqasiqhutik Jew-ŋuŋitchuanik suli iñuiñik Israel katimaniqsut. Sivunniutiginiġaat akikŋaqługu Jesus savaktin ipqitchuaq anniqsuutiksriukkan. ");
INSERT INTO eskNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Katinniqsut savaŋniaġukhutiŋ supayaanik sivunniutigikkan kamanaqtuakun isumałipkun iŋiḷġaan atuumaruksrauruaq. ");
INSERT INTO eskNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Aasiiñ pakma, Ataniiq, itqaġlugich Jew-ŋuruat qulliŋich qanuqhutiŋ aniqsraaqtuqmatigut. Savaktigikkaqpich, uqaqtitigut uqałiġnik taluqsrautaiġuta. ");
INSERT INTO eskNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ikayuqtigut iłuaqsitḷasiḷugich naŋittuat suli savaktitigut atlayuaġnaqtuaniglu quviqnaqtuaniglu atanniutaagun ipqitḷuni savaktigikkapkun Jesus.” ");
INSERT INTO eskNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Agaayuanikmata taamna ini katimavigikkaŋat aulaniqsuq. Tavraami aŋalatiliqhutiŋ Ipqitchuamik Irrutchimik aullaqhutiŋ uqaaqsiñiqsut Agaayyutim uqałhiñik taluqsrautaiqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Uvvaguuq ukpiqsripayaaqtuat atausiŋŋuutripḷutiŋ atipiaġniqsut irrutchimikkun. Nalliatunniiñ iġḷiginġiqł̣ugu iŋmi suurani aglaan atunim atuġniġaat suuraġikkaqtiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Uqqiraqtit kamanaqtuakun saŋŋikun iḷisimarauniqsut aŋitqił̣hagun atanġuruam Jesus suli Agaayyutim ikayuqpaŋniġai iluqaisa. ");
INSERT INTO eskNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Taapkunani ukpiqsriruani piiññiqsuq inuqsraqtuamik. Sua inuqnaqsipman iḷaŋa tunisiraqtuq nunaviñiġmik naagaqaa tupiġmiñik, tunisianikamiasiiñ tavruŋautiraġniġaa akuqtuani tuniaġmiñiñ ");
INSERT INTO eskNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aatchuutigiplugu uqqiraqtinun. Taapkua-aasiiñ autaaġaġniġaat taamna manik inuqsriupayaaqtuanun. ");
INSERT INTO eskNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ukpiqsriruamik iñuqaġniqsuq Joseph-mik, Levi-tkuayaaŋupluni iñuguqtuaq Cyprus-mi, taavrumiŋa uqqiraqtit taiguutiqakkaŋat Barnabas-mik (mumiutiqaqtuamik pitchuksaaqtimik). ");
INSERT INTO eskNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ilaaptuuq tuniripmiñiqsuq nunautmiñik qaitḷuguasiiñ akuqtuani uqqiraqtinun. ");
INSERT INTO eskNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tavraniguuq iñuqaġmiñiqsuq nuliaġiiŋñik atiqaqtuaŋnik Ananias-miglu Sapphira-miglu. Taapkuak iññuk tuniriñiqsuk nunautmiknik iluqatik pigikkaġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Akuqtuaġmik iḷaŋanik tugvaiñiqsuq aġnaataasiiñ iḷisimaplugu aŋiġaa. Aglaan sippaŋa qaitkaa uqqiraqtinun. ");
INSERT INTO eskNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter-m nipliutiniġaa, “Suvaata tuunġaġmun aŋalatitpich? Suvaata sagluqsruutiviuŋ Ipqitchuaq Irrusriq iriqqakun tugvaqsipḷutin iḷaŋanik nunautvich akian? ");
INSERT INTO eskNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tunigaluaqnagu nuna pigikkan aasiiñ kiŋuagun tunił̣han akuqtuaġikkan pigigiñ. Sum taatna isummiqpatin? Sagluqsruutriŋitchutin iñuŋnik aglaan Agaayyutmik.” ");
INSERT INTO eskNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias-ŋum tusaapqauraqamigich Peter-m uqaġikkaŋi puuktiġniqsuq tuqupluni. Tusaapayaaqtuat taavrumiŋa taluqsratchaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nukatpiat nimiqsruqtuallakamitruŋ timaa annisipḷugu iḷuviġiaġniġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Uvvaasiiñ piŋasut sassaġniġich kiŋuatigun aġnaat aggiġñiqsuq sutilaaŋatnik nalupluni. ");
INSERT INTO eskNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter-m apiqsruġniġaa, “Uqautiŋŋa, iliptik tunivitku nunautrik taatnatunaglaan?” Aġnam kiuniġaa, “Ii, tavra taatnatunaglaan ittuq.” ");
INSERT INTO eskNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter-mli piñiġaa, “Suvaata uuktuaġniqpitku Agaayyutim Irrusia? Ataŋii, taapkua iḷuviqsiruat iḷaqatipnik qakma aullautigisipmigaatin taatnatun.” ");
INSERT INTO eskNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tavrauvaa puuktiġniqsuq Peter-m sivuġaanun tuquliqhuni. Nukatpiat isiqamiŋ qiñiqługu tuquruaq aullautiniġaat iḷuviġiaqługu saniġaanun aŋutaata. ");
INSERT INTO eskNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tavra ukpiqtuaŋuruat suli iñupayaat tusaaruat taavrumiŋa taluqsratchaŋniqsut atqunaq. ");
INSERT INTO eskNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Uqqiraqtit savaaqaġniqsut iñugiaktuanik atlayuaġnaqtuanik suli quviqnaqtuanik akunġatni iñuich. Iluqatiŋ ukpiqsriruat atausiŋŋuġniqsut katimmavianun Solomon-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ukpiqtuaŋuŋitchuat iḷaliqsuaqsiniġaich taluġiplugich aglaan iliŋisa uqautigillautaġaluaqługich. ");
INSERT INTO eskNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aglaan iñugiaktuat aŋutitlu aġnatlu ukpiqsriḷiqsuat Ataniġmik Jesus-mik, taatnaqługu ukpiqtuat iñugiaksitmullapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iñuich iḷḷiuqaigaqsiñiqsut atniġñaqtuanik tumitchaanun siñigviŋnun naagaqaa ikivġanun niġiugiplugu qakugun Peter tamaunnaaqpan taġġaŋanun mamitinnasugalutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Suli nunaaqqiñiñ avataaniñ Jerusalem iñugiaktuat iñuich tikiutriñiqsut atniġñaqtuanik suli iłuiḷḷiuqtittaŋitñik irrusiqł̣uich. Taatnaiḷipḷugu iluqatiŋ iłuaqsikkauniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Taamna atuumaanikman qaukłiat quliaqtuaqtit piqasiqhutiŋ maliġuaqtaiñik Sadducee-ŋuruanik qinnallapiaġniqsut uqqiraqtitigun. Sivunniuġniqsut qanuq aŋalałiksraŋatigun. ");
INSERT INTO eskNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Iliŋisa tiguniġaich uqqiraqtit aasii inillaktitlugich isiqsiviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aglaan tamarrumani unnuami isaġulgan Agaayyutim aŋmaġniġai isiqsivium paaŋi aasii annisipḷugich, itnaqhuni, ");
INSERT INTO eskNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Agaayyuvikpaŋmugusi uqaġiaġitchi iñuŋnun nutaakun iñuuniałikun tumigiplugu Jesus.” ");
INSERT INTO eskNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Taamna tusaapqauraqamitruŋ agaayyuvikpaŋmukhutiŋ qauŋuraaqman tavraniasiiñ iḷisautriaqsipḷutiŋ. Qaukłiat agaayuliqsit piqatiniḷu katinniġaich uqaqsittaaqtitchirit suli iluqaisa Jew-ŋuruat sivulliuqtiġruaŋich. Tuyuqaġniqsut isiqsiviŋmun uqqiraqtit tavruŋautitquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Uvvaasiiñ qaunaksrit tikitmata isiqsiviŋmun paqinġiññiġaich tavrani uqqiraqtit. Aasiiñ utiqhutiŋ taamuŋa katimaruanun uqautiniġaich, ");
INSERT INTO eskNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Isiqsiviŋmun tikitñapta kiluusaqaqhuni suli qaunaksrit paani qaunaksrigaluaġniqsut. Aglaan paat aŋmaqaptigik paqitchiŋitchugut iñuŋmik iḷuani.” ");
INSERT INTO eskNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Agaayyuvikpaum qaunaksraŋata qaukłiata suli qaukłiŋisa agaayuliqsit tusaakamitruŋ taamna isumatuyaagaqsiñiqsut sutilaaksraŋagun. ");
INSERT INTO eskNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Taatnaqtitlugich iñuk isiqhuni, “Ataŋii, isiqtasi amma agaayyuvikpaŋmi iḷisautrirut iñuŋnik” itnaqtiġniġai. ");
INSERT INTO eskNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Agaayyuvikpaum qaunaksrit piqasiqhuni qaukłiġmiknik taamuŋaġniqsuq tavruŋautityaqługich uqqiraqtit. Aglaan aŋallaġluutaiqhutiŋ nuyuaġiplugu iñuŋnun miḷuqtuaqsił̣iksraqtiŋ uyaġaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iliŋisa uqqiraqtit tavruŋautikamisigik sivuġaatnun uqaqsittaaqtitchirit, qaukłiata agaayuliqsit apiqsruqtaaqsiñiġai, ");
INSERT INTO eskNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Qanusiġalgitpisi?” itnaqhuni, “Uvagut aniqsraaqtuutigigaluakkaqput iḷisautritquŋitḷusi taavrumuuna Jesus-kun, aglaan pakma Jerusalem-miupayaat iḷisauttutri iḷisimagaat suli iliŋisa patchisiġuqhuta tuqułhanun Jesus-ŋum!” ");
INSERT INTO eskNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter-m atlatlu uqqiraqtitlu kiuniġaich, “Tupiksriruni Agaayyutmik sivulliuruq tupiksrił̣iġmiñ iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ilipsi Jesus kikiaktuutikkaqsi sanniġutamun aglaan Agaayyutaata sivulliapta aŋitqiksitaŋa tuquŋaruaniñ ");
INSERT INTO eskNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","kamanaġviksraŋanun ataniġuqługu anniqsuutiġuqługulu. Taavrumuuna Jesus-kun Israel-aaġmiut mumikkumiñaqsipḷugich natqigutikkauniqsut killuqsautmikniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Uvagut iḷisimarriqsimmaaġikput piqasiqhuta Ipqitchuamik Irrutchimik Agaayyutim qaisaġikkaŋa tamatkunuŋa tupiksriruanik ilaanik.” ");
INSERT INTO eskNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jew-ŋuruat uqaqsittaaqtitchirit tusaakamitruŋ taamna uumitchallapiaġniqsut, suli tuqqutchisuliġñiqsut uqqiraqtinik. ");
INSERT INTO eskNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Uqaqsittaaqtitchirit iḷaŋata Pharisee-ŋuruaq makinniqsuq uqallagukhuni, atiqaqtuaq Gamaliel-mik suli kamagikkaupluni iḷisautrauruaq maliġutaksramiknik. Makitnami tiliñiġai uqqiraqtit aniḷḷaquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“Israel-aaġmiuŋuruasii!” itnaqtiġniqsuq ataniġnun, “Aniyagilugu qanuq aŋalatchił̣ł̣aksraqsi taapkuniŋa aŋutinik. ");
INSERT INTO eskNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Aippaaniguuq iñuqaġniqsuq atiliŋmik Theudas-mik kamanaġasugaluni iḷiruamik. Iñunnaŋniqsuq sisamanik kavluutinik iñugiaktigiruanik. Aglaan tuqqutaupman iluqaġmiŋ maliġuaqtai siaminniqsut taatnaqługuasiiñ suuŋaiqhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aquagunsuli Judas itmiñiqsuq Galilee-miñ tamarrumani kisitchikamiŋ iñupayaanik nunami. Ilaaptuuq iñunnakhuni iñugiaktuanik iŋmiñun naagatarra tuqqutaupman iluqaġmiŋ maliġuaqtai siaminniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pakmaasiiñ alġaqsrullaglapsi itniiḷiḷugu, Aullaġlich ukua iñuich. Iḷaksianagich. Tamanna sivunniuġutaatlu savaaŋatlu iñukmiqnisaukpan atlatitun piunġiġisiruq, ");
INSERT INTO eskNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","aglaan agaayyutmiqnisaukpan akiiḷiyumiñaipiaġisi. Inniaqtusi nuyuaġnami akiḷḷiḷiuġutisaġupsi Agaayyutmi.” Taatnaiḷipḷugu Gamaliel-ŋum alġaqsruġniġai. ");
INSERT INTO eskNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Atanġich akuqtuġniġaat alġaqsruutaa aulaiḷaŋuġutiŋ kamakkutiqaġukługukii. Uqqiraqtit isiqtitqiŋñiġaich kiŋumun aasiiñ ipiġaqtuqtitlugich. Aniqsraaqtuġniġaich uqatqiquŋitḷugich taavrumuuna Jesus-kun, aasiiñ anipkaqługich. ");
INSERT INTO eskNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Uqqiraqtit aullaġniqsut uqaqsittaaqtitchiriniñ. Iliŋich quviasuktut atakkii Agaayyutmun piksraqtaaġiplutiŋ nagliksautigiłiksraŋagun Jesus. ");
INSERT INTO eskNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Uvluġaġipman agaayyuvikpaŋmi iñuich tupiŋitñiḷu iḷisauttutigituiñaġniġaat quliaqtuaġiplugu Jesus akiqsruutaupluni anniqsuqtauruaq, Jew-ŋuruat niġiugikkaŋat. ");
INSERT INTO eskNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Taipkunani uvluni ukpiqtuat iñugiaksipmata Greek-ŋuraaqtuat suli Hebrew-ŋuraaqtuat uqaallatiniqsut. Tamatkua Greek-ŋuraaqtuat nipliġñiqsut uiḷgaġnaatiŋ miñitchuunipḷugich uvluġaġipman autaaqmata iñuuniutiksranik. ");
INSERT INTO eskNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Taatnaqhutiŋ qulit malġuuplutiŋ uqqiraqtit ukpiqtuapayaat katitquniġaich nipliqhutiŋ, “Nalaunŋaŋitchuq quliaqtuaŋaiġupta piqusiġuta aŋalatchiñiałikun autaałiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Taatnaġusi, aniqatiut, piksraġitchi tallimat malġuŋnik aŋutinik akunnapsitñiñ, iñuŋnik aŋalatiqaqtuanik Ipqitchuamik Irrutchimik puqikhutiŋlu. Aŋalatchipkaġniaġivut autaałiksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Uvagut iŋiqsruqtuiñaġisirugut suli quliaqtuaqtuiñaġuta.” ");
INSERT INTO eskNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Taapkua sivunniuġutaat quyaqnaġniqsuq iluqaitñi katiruani, aasiiñ nalunaiqsiñiqsut Stephen-mik ukpiqsriḷḷapiaqtuamik aŋalatiqaqhuni Ipqitchuamik Irrutchimik. Iḷaksraqługu Philip, Prochorus, Nicanor, Timon, Parmenas, suli Nicolaus-mik Antioch-miñ mumikhuni Jew-ġuqsimaruamik. ");
INSERT INTO eskNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Taapkua katimaruat tikiutiniġaich piksraqtaatiŋ uqqiraqtinun aasii iliŋisa iŋiqsruutiplugich iḷipḷugiḷḷu argatiŋ iliŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tavra Agaayyutim uqałha siaminniqsuq. Ukpiqtuat Jerusalem-mi iñugiaksitmuktuġniqsut suli iñugiaktuat agaayuliqsit ukpiqsriḷiqmipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen, iłuaqqutaagun suli saŋŋiagun Agaayyutim, savatlasiñiqsuq quviqnaqtuanik suli atlayuaġnaqtuanik akunġatni iñuich. ");
INSERT INTO eskNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iñuqaġniqsuġġuuq ittuanik Jew-ŋuruanik Cyrenia-miñ Alexandria-miñḷu sulipsuuq Cilicia-miñ Asia-miñḷu. Tamatkua taggisiqaqhutiŋ Pituikkauruanik uqaallatiaqsiñiġaat Stephen. ");
INSERT INTO eskNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aglaan Ipqitchuam Irrutchim puqiutiqaqtinniġaa. Tavraasiiñ nipliqman qapiqtalguiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Taatnaqhutiŋ tamatkua piyuaqtit akiḷiiñiqsut aŋutinik sagluuqtuaquplugich, “Tusaagikput uqaqman akikŋaqługu maliġutaksraq Moses aglagikkaŋa suli akikŋaqługu Agaayyun.” ");
INSERT INTO eskNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tamatkua taatnałiġmikkun aŋalanniġaich sivulliuqtiġruat suli aglaliqirit. Kiisaimma Stephen tiguniqpaat sivuġaŋiutipkaqługu Jew-ŋuruat uqaqsittaaqtitchiriŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aasii iḷaŋitñik aŋutinik itqutripḷutiŋ sagluuqtuaqtuksranik ilaagun. Taapkua nipliagaqsipḷutiŋ itna, “Una aŋun ataramik uqaqtuq akikŋaqługu uvagut ipqitchuaġikkaqput agaayyuvikpak suli akikŋaqługu maliġutaksraŋa Moses-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Aasiisuli tusaagikput nipliapman Jesus-mun Nazareth-miumun siqumitqaaġlugu agaayyuvikpak simmiġisiñipḷugich atuqtaksrat tamatkua ivrumakŋa Moses-miñ tunŋavigikkavut.” ");
INSERT INTO eskNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iñupayaarguuq aquppiruat uqaqsittaaġviŋmi qiñiqpaaqsiñiġaat iriġruiñaaqługu Stephen, tautukługuasiiñ kiiñaŋa iḷiruaq kiiñaŋatun isaġulgum. ");
INSERT INTO eskNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Qaukłium agaayuliqsim apiqsruġniġaa Stephen, “Tamanna iḷumutuuva ukua nipliałhat?” ");
INSERT INTO eskNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen kiuniġaa, “Aniqatiut suli Aapaaŋuruasii, naalaġniḷḷaksiŋŋa! Agaayyun kamanaqtuaq sagviġñiqsuaq sivulliaptiknun Abraham-mun iñuuniaġugaaqtitlugu Mesopotamia-mi sivuani aullałiksraŋan Haran-mi itchaqtuqhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nipliutiplugich itna, ‘Unigḷugu nunan suli iḷatin aullaġiñ nunamun tikirvigitqukkamnun ilipnun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Taatnaqhuni nunaŋatniñ Chaldea-ġmiut aullaġniqsuq Haran-mun iñuuniaġiaqhuni. Aasii kiŋuagun Abraham-ŋum aapaŋa tuquanikman tavrani Agaayyutim nuutinniġaa marrumuŋa nunamun nayukkaptiknun pakma. ");
INSERT INTO eskNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Taatnaqtiłhani tamaani Agaayyutim qaitchiŋitkaluaġniġaa Abraham iŋmaktillugu ilaanun tamanna nuna. Aglaan akiqsruġniġaa qaitchigisiñipḷugu pigiliutilugulu ilaanun suli kiŋuviaŋiñun, naagaunniiñ Abraham qitunġiuŋŋaan. ");
INSERT INTO eskNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Agaayyutim nipliutiniġaa itna, ‘Kiŋuviaġikkatin iñuuniaġisirut iglaaŋulutiŋ atlami nunami. Sumiuŋuruat nunurilugich savaktitaulutiŋ suli sisamani kavluutini ukiuni iłuaqqutitchiuŋiḷḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aglaan anasiñŋuqsaġisigitka taapkua savaktaaġruqaqtuat iñugikkamnik. Kiŋuagun tamarruma iliŋich utiġutiŋ taivrumakŋa agaayumaaġvigiaqsiḷuŋa marrumani nunami.’ Taatna Agaayyutim uqautiniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Agaayyutim akiqsruutikamiuŋ Abraham tiliñiġaa nalunaitŋutchiquplugich aŋutitiŋ. Taatnaqami qiñiqtitkaa tupiksrisukhuni Agaayyutim akiqsruutaiñik ilaanun. Tavra Isaac anipman Abraham-ŋum nalunaitŋutchiqmiñiġaa tallimat piŋayuatigun uvlut. Isaac-ŋum nalunaitŋutchiqmiñiġaa Jacob, ilaanli piñiġai qulit malġuk sivulliavut. ");
INSERT INTO eskNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aglaan taapkua sivulliaġuqtuat killuġiniġaat nukatchiaqtiŋ Joseph tunipḷuguasii savaktauviksraŋanun Egypt-mi. Aglaan Agaayyutim nayuġniġaa ");
INSERT INTO eskNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ikayuqługu iłuiḷḷiuġviŋmiunniiñ itman. Agaayyutim nakuaġiliutipkaġaa puqiisiqługulu. Taatnaqhuni Pharaoh-m umialgum Egypt-mi aŋalatiġuġniġaa Joseph iluqaanun Egypt-mun suli iŋmi tupiġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kiŋuagun niġisuŋnaqsiñiqsuq Egypt-mi Canaan-miḷu, taatna sivulliavut niġisuksiuliqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aasiiñ Jacob tusaakami niqiksraqaqnipḷugu Egypt-mi ilaan sivulliavut tuyuġiqqaaġniġai tasamuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iḷaŋatni tasamuŋalgitmata Joseph iḷitchuġipkaġniqsuq iŋmiñik aniqatiumiñun, aasiiñ Pharaoh-m iḷitchuġiniġai Joseph-ŋum iḷai. ");
INSERT INTO eskNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joseph-ŋum aapani Jacob aiyugaaġniġaa Egypt-muquplugu qitunġaqtuummaan. Taapkuaguuq iñugiaktiginiqsut piŋasukipiaq akimiamik. ");
INSERT INTO eskNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tavra Jacob-ŋum qitunġani nuurrutiniġai Egypt-mun, tavraniasiiñ ilaalu sivulliavutlu tuquplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iliŋisa timiŋich iḷuviġiaqtaġniġaich Shechem-mun taivrumuŋa Abraham-ŋum tauqsiaġimakkaŋanun iḷuviġviksrauplugu iŋmiknun Hamor-m kiŋuviaŋiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tamauna Agaayyutim akiqsruutaa Abraham-mun atuumaaqsipman, kiŋuviaŋi iñugikkapta tavrani Egypt-mi iñugiaksiḷḷapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Umiallitqiŋñiqsut atlamik tavrani naluruamik Joseph-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Taavruma umialgum kinniaqsiñiġai iñuvut suli nagliksaaqtitlugich sivulliavut, nunuripḷugitunniiñ igitqataqtitlugich aniqqamiurat tuquviksraŋatnun. ");
INSERT INTO eskNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Taatnałhatniguuq Moses aniñiqsuq qiñiyunaqhuni, aasiiñ aŋayuqaakkiñ qaunagiplugu piŋasuni tatqiñi. ");
INSERT INTO eskNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Iriqsimalguiqł̣ugu kiŋunġani anipkaġniġaat. Taatna Pharao-m panian tiguaqługu iġñiġmisun pamiqsaġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ilaa iḷisaaqaġniqsuq iluqaagun Egypt-miut isumatuutaatigun, kamanaqsipḷugu uqałiġmiñi savaamiñiḷu. ");
INSERT INTO eskNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Aasiiñ malġukipiamik ukiunikkami Moses sivunniġñiqsuq takuqattaaġukługich Israel-aaġmiuqatiuni. ");
INSERT INTO eskNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tikitqammiqhuniḷu Egypt-miu aŋallaġluipman iḷaŋatnik tamatkua taatnaqhuni ikayuġiaġniġaa payyaksaqtuaq. Ikayuisaġniaqhuni tuqunniġaa taamna Egypt-miu. ");
INSERT INTO eskNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Isumapluni aniqatiumiñun kaŋiqsimanasukniaqługu Agaayyutmun atułiksrani annautrił̣iksraŋagun iñuŋmiñik. Aglaan taapkua kaŋiqsimaŋiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Uvlutqikman qiñilgiññiqsuq Israel-aaġmiuŋnik aŋuyaktauŋnik. Ilaan iłuaqsisipkaġniagaqsiñiġik itnaqługik, ‘Ukuqtiik, aniqatigiiksutik! Qanuqhusik iliptiknun piyuutivisik?’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aglaan iḷaqataaknik piyuutiruak piñuniġaa Moses itnaqługu, ‘Kisuunasugivichuvva? Aŋalatchiñiaqpich atanniqsuiñiaqhutinlu uvaptiknik? ");
INSERT INTO eskNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tuqutchuaqsiḷgitpiŋa taivrumatun Egypt-miutun tuqqutaptun ikpaksraq?’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses-ŋum tusaakamiuŋ taamna qimaŋniqsuq Egypt-miñ iñuuniagaqsipḷuniasii Midia-ġmiut nunaŋatni. Taapkunani malġuŋnik iġñiqaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Malġukipiami ukiuŋanikman isaġulgum sagviutiniġaa Moses ikualaraukun uqpikun iñuiḷaami qaniŋani iġġian Sinai-m. ");
INSERT INTO eskNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses-ŋum qiñiqamiuŋ atlayuaġiplugu utlaŋniġaa taamna uqpik qiñimmaġiksaaġukługu. Tavraasiiñ tusaaniġaa Agaayyutim uqautigikkaŋa, ");
INSERT INTO eskNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Uvaŋa sivulliaqpich Abraham-ŋum Isaac-ŋumlu Jacob-ŋumlu Agaayyutaat.’ Moses tatavraullaŋniqsuq qiñiġnianġiqł̣uguunniiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Agaayyutim nipliutiniġaa, ‘Aluġutikkiñ mattakkik, taamna qikaġviiñ Agaayyutim nunagigaa. ");
INSERT INTO eskNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iḷumun qiñiġniġiga pigiiḷipḷuni nagliksaaqtitaułhat iñuŋma Egypt-miittuat tusaaplugich minġuqtułhat, atqaqtuŋaasiiñ ikayuġiaġlugich. Pakma mauŋaġiñ, tuyuġigisigikpiñ Egypt-mun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Taamna taimña Moses Israel-aaġmiuqataiñ ayakkaŋat itnaqługu, ‘Kia uvaptiknun sivulliuqtiġuqpatin atanniqsuitquplutin uvaptiknik?’ taimñauruq Agaayyutim tuyuġikkaŋa iliŋitñun sivulliuqtaulugu anniqsuityaquplugulu, ikayuqługu isaġulikun qiñikkaŋa ikualaruami uqpiŋmi. ");
INSERT INTO eskNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses-ŋum annisiniġai Egypt-miñ. Iñiqtaqaqniqsuq quviqnaqtuanik suli atlayuaġnaqtuanik Egypt-miḷu, Kaviqsaami Taġiumiḷu suli iñuiḷaami malġukipiani ukiuni. ");
INSERT INTO eskNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Taamna Moses nipliqsimaruaq Israel-aaġmiunun, ‘Agaayyutim sivuniksriqirimik tuyuġisigaasi atriḷugu tuyuqałłi uvamnik; taimña itkisiruq iḷapsitñiñ.’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Israel-aaġmiut katimałhatni iñuiḷaami iġġiani Sinai-m isaġulgum uqaqatiqaġniqsuq Moses-mik, aquagunaasiiñ Moses-ŋum uqautiplugich sivulliavut uqałiġnik akuqtuaġikkaŋitñik Agaayyutmiñ. Taimakŋaaglaan iḷitchuġirugut qanuq iñuuniałiksraptiknik. ");
INSERT INTO eskNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Sivulliapta tupigiyumaŋiññiġaat, aglaan suqutigiŋitkaat aŋalatiqaqhutiŋ kimmutmikkun utiġukhutiŋ Egypt-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Taatnaqhutiŋ Aaron uqautiniġaat, ‘Kiikaa, aanġurrisigut sivulliqsiksraptiknik, atakkii imña Moses annitrivut Egypt-miñ naluplugu sutilaaŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iliŋich iñiqsiñiqsut aanġuamik nuġġaqtun aasiiñ tuniḷḷaqtuaqsipḷutiŋ aanġuaġmiknun, quviasuutigiplugu iñiqtaġikkaqtiŋ argaŋmiknik. ");
INSERT INTO eskNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Taatnaqmata Agaayyutim suqutigiŋisaallaŋniġai agaayuyumiñaqsipḷugich uvluġianun qiḷaŋmi, aglausimaruatun makpiġaaŋatni sivuniksriqirit itnaiḷipḷugu, ‘Israel-aaġmiuŋuruasii, malġukipiami ukiumi iñuiḷaami tuniḷḷaqtuqtusi agaayuvigigaluaqnaŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Igliġutiniġiksi panapkaaqtuummaan aanġuaq Moloch suli atriŋa uvluġiaŋan aanġuaġikkapsi Raiphan. Tamatkuak aanġurrigigaasi iñiqtaġikkasi putqataġvigisrukługich. Taatnaġusi tuyuġigisigipsi uŋataanun Babylon.’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sivulliapta iñuiḷaami igliġutiniġaat panapkaaq. Taavrumuuna Agaayyun nayuutiruq akunġatni. Moses-ŋum iñiqtaġikkaŋa Agaayyutim pigisukkaŋatun, tuvraqługu iḷiktiġun iŋmi iḷisauttusiaŋatun. ");
INSERT INTO eskNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kiŋuvatigun sivulliapta akuqtuqługu taamna panapkaaq sivulliamikniñ igliġutiniġaat akiqsruutauruamun nunamun. Joshua-mlu iliŋisalu tigusiaġisaaqsiñiġaat nuna taipkunakŋa iñuŋniñ Agaayyutim uŋutaŋiñiñ, tavruŋaasii panapkaaq nappaqługu David-ŋum aŋalatiġułhanunaglaan. ");
INSERT INTO eskNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Agaayyutim David nakuaġiginiġaa. Aasiiñ David-ŋum iŋiġniġaa Agaayyun nappaitḷasipḷuni tupiġmik ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kiisaimmaguuq Solomon nappaiñiqpuq taavrumiŋa tupiġmik, agaayyuvikpaŋmik. ");
INSERT INTO eskNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Aglaan Agaayyun qutchiŋñiqsraqtuaq irviqaŋitkaluaqtuq tupiġmik iñuich nappakkaŋatnik, nipliqmatun Isaiah-m sivuniksriqirim itnaiḷipḷugu, ");
INSERT INTO eskNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Agaayyun nipliqsuq, Qiḷak atanġuvigigiga aasii nuna tutmaġvigiplugu. Qanutchimikmi tupiġmik nappaiñayaqpisi uvamnun? Sumimi minġuiqsiaġviqaġisivik? ");
INSERT INTO eskNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iḷumun iñiqtaġimakkaġa supayaaq tamanna.’ ");
INSERT INTO eskNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Taipkunatitun pitchiġiiḷaurusi tiggakhusiḷu. Tusaasuŋitmiusi Agaayyutim uqałhanik naagasuli ukpiksrisuŋitmipḷusiunniiñ. Sivulliapsitun ilipsipsuuq ataramik akiḷḷiḷiqsuirusi Ipqitchuamik Irrutchimik. ");
INSERT INTO eskNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sivuniksriqiripayaat sivulliapsi nagliksaaqtinniġaat, tuqqutlugich Agaayyutim uqqiraqtaiñik uqaqtuanik iŋiḷġaan aggił̣iksraŋagun Agaayyutim nalaunŋaruaq savaktiksraŋa. Pakma ilipsi aatchuutigigiksi tuqqutluguasii. ");
INSERT INTO eskNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ilipsi akuqtuigaluaqhusi maliġutaksraq tumigiplugu isaġuliŋñi Agaayyutim qaisaŋanik naagasuli tupigiŋitkiksi.” ");
INSERT INTO eskNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iḷauruat uqaqsittaaqtitchirit naalaġnił̣iġmikni Stephen-mun qinnallapiaġniqsut. Qinnakpaitḷutiŋ iŋmiknununniiñ aŋalalguiḷiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aglaan Stephen Ipqitchuam Irrutchim aŋalatlugu aaġluqhuni Agaayyutim qaumanġa qiñiġniġaa suli Jesus qikaqługu Agaayyutim taliqpiani. ");
INSERT INTO eskNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nipliġñiqsuq, “Ataŋii, qiñiġiga qiḷak aŋmaqługu suli Iġñiŋa Iñuum qikaqługu Agaayyutim taliqpiani.” ");
INSERT INTO eskNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tamatkua qulliŋich niprallaŋniqsut umikługich siuttatiŋ argaŋmiknik. Iluqaġmiŋ pitchaqługich ");
INSERT INTO eskNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aasiiñ nunaaqqimiñ anitnamitruŋ miḷuqtuġataġniġaat uyaġaŋnik. Iḷisimariksraqtaat mattaġniġaich quppiġaatiŋ iḷipḷugich nukatpiamun atiligaamun Saul-mik qaunagitquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iliŋitñun miḷuqtuqtitluni Stephen agaayuniqsuq, “Ataniiq Jesus! Aniġniġa piuŋ!” ");
INSERT INTO eskNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sitquqami niplianiqsuq, “Ataniiq! Taavrumuuna killuqsałhatigun anasiñŋuqsaqnagich.” Taatnaanikami tuquniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul-ŋum iłuaginiġaa tamatkunuŋa tuqqutaułha. Taivrumakŋa uvlumiñ ukpiqtuaŋuruat Jerusalem-mi nagliksaaqtitaugaqsiñiqsut atqunallapiaq. Tavrakŋa ukpiqtuat siamitkaqsiñiqsut nunaaqqiuraiñun Judea-mlu Samaria-mlu, aglaan uqqiraqtit kisiŋŋuqługich Jerusalem-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Iḷaŋisa iñuich taluqsriruat Agaayyutmik iḷuviġniġaat Stephen aliasułikun kiŋuvġuplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Taavrumali Saul-ŋum piyaqquaqsisiġniġai ukpiqtuaŋuruat. Siñiqsraqługich iliŋisa tupiŋich pakagiaqługich aŋutitlu aġnatlu isiqtautquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Qimaktuat nanipayaaq tusaayugaallautaq quliaqtuaġiniġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip-li nunaaqqimukhuni Samaria-mun quliaqtuaqmiñiqsuq Christ-mik taavrumiŋa akiqsruutauruamik anniqsuutmik iñuŋnun tavrani. ");
INSERT INTO eskNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iñugiaktuat iñuich naalaġniḷḷapiaġniqsut Philip-ŋum uqaġikkaŋiñun. Atakkii qiñiġviginiġaat atlayuaġnaqtuanik ilaa. ");
INSERT INTO eskNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nipitusipḷutiŋ irrusiqł̣uich anitauniqsut iñugiaktuaniñ iñuŋniñ, suli iñugiaktuat sayairrutilgich aulatlaitchuatlu iłuaqsikkauplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Taatnaqhutiŋ Samaria-ġmiut quviatchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Taavrumaniguuq nunaaqqimi iñuqaġniqsuq atiliŋmik Simon-mik. Ilaa quviġutchaktitchiñiqsuq Samaria-ġmiunik aŋatkuułikun aasiiñ uqaviutigiplugu kamanaġasukniaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Iluqaġmiŋ nunaaqqimi kamanaiññiqsramiñḷu kamanaġniqsramiñḷu naalaġnitqiaġipiaġniġaat aasiiñ uqaqhutiŋ, “Taavrumani iñuŋmi ittuq Agaayyutim saŋŋia iḷisimakkaqput Saŋŋiqpauraq.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sivisuruamik ilaan quviġutchaktinnikkaŋi aŋatkuułikun, taatnaqhutiŋ naalaġnitqiaġiŋñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aglaan Philip-ŋum quliaqtuaġiaqsipmauŋ tusaayugaallautaq Agaayyutim aŋaayuqautaagun suli Jesus-kun anniqsuqtauruakun tamatkua iñuich ukpiġiniġaat, aasiiñ paptaakkauplutiŋ aŋutitlu aġnatlu. ");
INSERT INTO eskNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon-tuuq ukpiqsripḷuni aasii aquagun paptaaqtiłiġmi nayuutiaqsiñiqsuq Philip-mi. Quviġutchaŋmiñiqsuq qiñiqami Philip-ŋum iñiqtaġikkaŋigun quviqnaqtuaniglu atlayuaġnaqtuaniglu. ");
INSERT INTO eskNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aasiiñ uqqiraqtit Jerusalem-mi tusaakamisigik Samaria-ġmiunun Agaayyutim uqałhi akuqtuġnipḷugich tuyuqaġniqsut Peter-miglu John-miglu tavruŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Ukpiqsriḷiqsuat paptaakkauplutiŋ Atanġum Jesus atqagun aglaan akuqtuisimaiññiqsutsuli Ipqitchuamik Irrutchimik. Taatnaqhutiŋ taapkuak tikitñamik iŋiqsruutiniġaich akuqtuitquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter-mlu John-ŋumlu iḷḷiqiniġaich taapkua argaŋmiknik. Tarvauvaa Ipqitchuam Irrutchim aŋalatkaqsiñiġai. ");
INSERT INTO eskNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon-ŋum qiñiġniġaa Ipqitchuam Irrutchim qaisauraġałha tamatkunuŋa uqqiraqtik iḷḷiqipmatigik argaŋmiknik. Taatnaqhuni Simon-ŋum Peter-lu John-lu qaitchisuaqsiñiġik maniŋñik ");
INSERT INTO eskNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","itnaqhuni, “Tunisisitŋaptuuq taavrumiŋa saŋŋimik. Uvvatuq iḷḷiqigupku argamnik iñuk akuqtuitḷayumauq Ipqitchuamik Irrutchimik.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tavra Peter-m kiuniġaa, “Piyaqquġviŋmugiñ maniksuummaqpich! Uvvaa tauqsitḷanasugiviuŋ maniŋñik Agaayyutim aatchuutigikkaŋa? ");
INSERT INTO eskNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sivuġaani Agaayyutim nalautisimaitḷutin naagasuli tupigiŋitḷugu, taatnaqhutin iḷaliqsuutiviksraiññiqsutin uvaptikni suli Agaayyutim savaaŋani. ");
INSERT INTO eskNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mumigiñ taavrumakŋa nalaunŋaił̣iqniñ! Iŋiqsruġutin Agaayyutmun natqiutitqulutin kaviuġuksaałipnik! ");
INSERT INTO eskNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Iḷitchuġigikpiñ immaukkaqsipḷutin killuqsrił̣iġmik suli killuġmun aŋalatitlutin.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon-ŋum itnaġniġik Peter-lu John-lu, “Iŋiqsruutillaŋniaqsitŋa Agaayyutmun anasiñŋuqsaquŋiḷḷuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Taatna Peter-lu John-lu iñuuniaqtaullaŋniqsuk Samaria-mi quliaqtuaqhutik uqałhiñik atanġuruam aasiiñ utiqhutik Jerusalem-mun. Iglaułiġmikni tusaayugaallautaq quliaqtuaġiniġaak nunaaqqiuraiñi Samaria-m. ");
INSERT INTO eskNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Aasiiñ isaġulgan atanġuruam Philip uqautiniġaa, “Paqnalutin uŋallam tuŋaanugiñ tikirviksraqnunaglaan iñuitchuamun apqutmun Jerusalem-miñ Gaza-mun.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ilaa aullaqtiġniqsuq. Igliqtaullakhuni nalautchiñiqsuq Ethiopia-ġmiumik. Taamnali iñuk iḷirakuviuraqniqsuq Ethiopia-ġmiut Kandaki-ŋatni (Ethiopia-ġmiut taggisiqaġnikkaŋat ataniqtiŋ Kandaki-mik), aasiiñ ilaa Jerusalem-muŋniqsuaq agaayutyaqhuni Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aitmułiġmiñi tuttuqpagaqtuaġmiñi agliqiniqsuq Isaiah-m sivuniksriqirim makpiġaaŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ipqitchuam Irrutchim nipliutiniġaa Philip, “Utlaguŋ tamanna tuttuqpagaqtuaq maliaqsiḷuguasiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tavra Philip malikkaa. Aasii tusaakamiuŋ taamna iḷirakuvik agliqipluni makpiġaaŋiñiñ sivuniksriqirim Isaiah-m apiqsruġniġaa, “Kaŋiqsiviuŋ agliqikkan?” ");
INSERT INTO eskNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Taavruma kiuniġaa, “Kaŋiqsipkaġniaqtaunnaŋa qanuġluŋa kaŋiqsiñiaqpik?” ");
INSERT INTO eskNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Taamna uqałiq agliqiaġikkaŋa itniinniqsuaq, “Iñuk ipnaisun tasikuaqtauruatun tuqqutaksraqtimiñun, ipnaiyaatun niplitḷaitchuatun salikkaukami ilaa nipliġñaiyuġattuq. ");
INSERT INTO eskNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Uqaqsittaałiġmiñi iñupayaam aŋallaqłuutiniġaa atchiksipkaqługuasiiñ. Kia-unniiñ kaŋŋiulguvagich? Ilaa kiŋuviaŋitchuq atakkii tuqqutlugu.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Taavruma iḷirakuvium qanuġviiqhuni apiqsruġniġaa Philip, “Uqautiłhiñauviŋa kisumik sivuniksriqirim Isaiah-m uumani uqautiqaqtilaaŋanik? Iŋmiñik naaga atlamik uqautiqaqpa?” ");
INSERT INTO eskNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip-ŋum iḷitchuġipkaqługu Isaiah-m uqałhaniñ sivulliuplugu uqautiniġaa tusaayugaallautamik Jesus-kun. ");
INSERT INTO eskNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iglaułiġmikñi tikiññiqsuk imiġmun. Taavruma iḷirakuvium nipliutiniġaa, “Uvva imiq! Sum piraiḷigisivaŋa paptaakkaułiksramniñ?” ");
INSERT INTO eskNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip-ŋum piñiġaa, “Ukpiqsriguvich iluqaaniñ uummatipniñ paptaałhiñaurutin.” Ilaa nipliġñiqsuq, “Ukpiġillapiaġiga Jesus Christ Agaayyutmun iġñiġiłha.” ");
INSERT INTO eskNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Taavruma iḷirakuvium tuttuqpagaqtuaq nutqaqtinniġaa aasii Philip-lu ilaalu atqaqhutik imiġmun. Philip-ŋum paptaaġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Imiġmiñ qakikamikaasiiñ Agaayyutim Irrusian nuktitiġniġaa Philip atlamun. Taavruma iḷirakuvium qiñitqiŋitñamiuŋ igliqtuiñaġniqsuq quviatchallapiaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip iḷitchuġiniqsuq Ashdod-mi itilaaġmiñik. Tavrakŋa tusaayugaallautamik quliaqtuaġniqsuq iluqaŋitñi nunaaqqiurani tikiḷġatałiġmiñunaglaan Caesarea-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul-ŋumli sivutmuutiniġaa aniqsraaqtuił̣ł̣i tuqqutchisułikun tamatkuniŋa Atanġum ukpiqtuaŋuruaŋiñik. Ilaa utlautiniqsuq qaukłiatnun agaayuliqsit ");
INSERT INTO eskNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aglaqaġukhuni taluġnaqutiksraġmiñik Jew-ŋuplutiŋ katraġviŋitñi Damascus-mi. Aasiiñ iḷitchuqsrigumi ukpiqtuanik Ataniġmun Jesus taamani ilaan tigutlalugich aŋutitlu aġnatlu utqutiraksraulugich Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tavra iglauniaqtitlugu qallipḷuni Damascus-mun, taimmaiñaq qaumanġum qiḷaŋmiñ qaggutiniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Katakami nunamun tusaaniqsuq tuqłuġaqtimiñik, “Saul! Ataŋii! Suvaata nagliksaaqtitpiŋa?” ");
INSERT INTO eskNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul-ŋum kiuniġaa, “Ataniiq, kisuuvich?” Uqautraan nipliutiniġaa, “Uvaŋa Jesus ilvich nagliksaaqtitaġikkan. ");
INSERT INTO eskNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Makillutin utlautiiñ nunaaqqimun. Taamani taamma uqautigisigaatin qanuq pił̣iksraqnik.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tavrani Saul-ŋum igliqatai taatnakkaułhani qikaġniqsut niplitḷaiqhutiŋ, tusaagaluaqługu nipi aglaan iñua qiñiŋitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul makitnami nunamiñ uiññami qiñitlaiġñiqsuq. Taapkua tasiuqługu Damascus-muutiniġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ilaa piŋasuni uvluni qiñitlaiññiqsuq, niġiŋitmiuq naagaunniiñ imiŋitmiuq. ");
INSERT INTO eskNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ukpiqsriruaqaqtuġġuuq Damascus-mi atiqaqtuaq Ananias-mik. Agaayyutim qiñiqquuraaqtitlugu tuqłuġniġaa, “Ananias!” Ilaan kiuniġaa tuqłuusiani, “Aa, Ataniiq! Uvaniittuŋa, naalakkikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Atanġum piñiġaa, “Makillutin aullaġiñ apqutmun atiqaqtuamun Nalġuqtuamik. Taamma Judas-ŋum tupqani apiqsruġumuutin Tarsus-miumik atiqaqtuamik Saul-mik. Taamna taamma agaayuruq. ");
INSERT INTO eskNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ilaan taamna qiñiqquuraakun qiñiġniġaa aŋun atilik Ananias-mik utlakługu iŋmiñun patikługu argaŋmiñik qiñitlasitqiksinniġaa.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias-ŋum kiuniġaa, “Ataniiq! Iñugiaktuat iñuich uqautigigaat taamamna aŋun Saul qanutun kapyapkaiñipḷugu Jerusalem-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pakmaimma tikiññiqsuq Damaskus-mun qaukłiat agaayuliqsitniñ taluġnaqusiqł̣ugu tigusił̣iksraŋagun kisupayaanik agaayumaaqtuanik ilipnun.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Agaayyutim nipliutilgiññiġaa, “Ananias, Saul-mugiñ. Piksraqtaġigiga savautritquplugu uvamnik iḷitchuġipkautigiluŋa iñuŋnun Jew-ŋuŋitchuanunlu umialiŋitñunlu suli Israel-aaġmiunun. ");
INSERT INTO eskNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Suli kaŋiqsipkaġisigiga qanutun nagliksaałiksraŋa piqutigipluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tavrakŋa Ananias aullaġniqsuq. Isiqamiasiiñ taamavrumuŋa tupiġmun patiŋniġaa Saul argaŋmiñik nipliqhuni, “Aniaqaan Saul! Atanġum Jesus tuyuġigaaŋa ilipnun taivruma qiñikkaqpich apqutmi utlautiniqñi mauŋa. Ilaan tuyuġigaaŋa qiñitlasitqiquplutin aasiiñ Ipqitchuamun Irrutchimun sivulliquplutinlu.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Taimmaiñaq sutimña iqaluum kavisaiŋisun katagaalaaqsiñiqsut Saul-ŋum irrakniñ aasiiñ ilaa qiñitlasitqikhuni. Makitnami paptaaqtinniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Niġianikman sayaŋan uttaqiniġaa. Aasriiñ Saul nayuutiuraallaŋniqsuq ukpiqsriruani Damascus-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ilaa utlautiniqsuq Jew-ŋuruat katraġviŋitñun quliaqtuaġutiplugich Jesus-kun itnaiḷipḷugu, “Taamna Jesus Agaayyutim iġñiġiniġaa.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tamatkua iluqaġmiŋ tusaaruat taavrumiŋa quviġutchakhutiŋ itnaaqsiñiqsut, “Unuuna Saul taimñauŋitkaluaqpa Jerusalem-mi tuqqutchiraġaqtuaq ukpiqtuaŋuruanik? Suli mauŋa utlautipluni sivuniqaqhuni tigusiḷuni taatnatchiñik utqutrisukhuni qaukłiŋitñun agaayuliqsit?” ");
INSERT INTO eskNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aglaan Saul quliaqtuałiġmiñi kaŋiqsipkaiñiqsuq iñugiaktuanik iñuŋnik Jesus taamna Christ-ŋułhanik nalupqinaiqł̣ugu. Jew-ŋuruat iñuuniaqtuat Damascus-mi kiggutiksraiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Aquagun iñugiaktuat uvlut Jew-ŋuruat katimaaqsiñiqsut sivunniuqhutiŋ tuqqutchukługu Saul. ");
INSERT INTO eskNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aglaan kiliŋniġaat taatna sivunniuġnipḷugich. Unnuaqtuummaan uvlumiḷu Jew-ŋuruat qaunaksruġniġaat nunaaqqim paaŋiñi tuqqutchumaplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tamatkuali ukpiqsriruat unnuat iḷaŋatni ikiniġaat Saul aguupmaŋmun atqautipluguasiiñ siḷatmun aŋmanġagun katchiqpaum. ");
INSERT INTO eskNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tavrakŋa Saul utiġniqsuq Jerusalem-mun. Tavraniasiiñ iḷaliutniagaqsigaluaġniqsuq ukpiqtuanun. Tamatkua arguaġiplugu ukpiqtuaġułha iqsigiaqsiñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Aglaan Barnabas-ŋum ikayuġniġaa Saul taapkunuŋautiplugu uqqiraqtinun. Ilaan kaŋiqsipkautiginiġai Saul-ŋum qiñiłha Agaayyutmik apqutmiñi suli Agaayyutmun tuqłuġnipḷugu suli uqautipmipḷugich Saul-ŋum quliaqtuałhanik taluqqutaiqhuni Jesus-kun Damascus-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saul itkaqsiñiqsuq iluqaani Jerusalem-mi taluqqutaiqhuni quliaqtuaqaqhuni Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Uqaqatiqaqmiuq akiḷḷiḷiqługich Greek-ŋuraaqtuat aglaan iliŋitñun tuqqutchumagaluaqtitluni. ");
INSERT INTO eskNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ukpiqtuaqatiuŋiñ (iḷitchuġikamiŋ taavrumiŋa) samuŋautiniġaat Caesarea-mun Saul aullaqtitlugu Tarsus-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tavrali ukpiqtuaŋuruapayaat Judea-mi, Galilee-miḷu suli Samaria-mi tutqiksiñiqsut sayyikkauplutiŋ irrusiġmikkun. Ukpiqtuaŋuruat iñuuniqsut taluqsripḷutiŋ Agaayyutmik, suli Ipqitchuam Irrutchim pitchuksaaġniġai aasiiñ iñugiaksisaiñaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter-li igliġniqsuq napmupayaaq. Igliłiġmiñi utlakmiñiġai Agaayyutim iñui Lydda-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Taavrumani nalautchiñiqsuq aŋutmik atiqaqtuamik Aeneas-mik, taamna aulatlaiḷaq, makinġiññiqsuaq tallimat piŋasuni ukiuni siñigviŋmiñiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter-m nipliutiniġaa Aeneas, “Jesus Christ-ŋum iłuaqsigaatin. Makittin, imulugich uqummatitin!” Taimmaiñaq taamna makinniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iñupayaat Lydda-mi Saron-miḷu qiñiqamitruŋ taamna ukpiliġñiqsut Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa-miḷi aġnaqaġniqsuq ukpiqtuaq atilik Tabitha-mik (Greek-tigun atqa taiñaġniqsuq Dorcas-mik mumiutiqaġniqsuaq tuttumik). Ataramik savaaqaġniqsuq nakuuruamik ikayuipḷuni inuqsraqtuanik. ");
INSERT INTO eskNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Taamna aġnaq atniġñaliqhuni tuquniqsuq. Iġġuanikamitruŋ inillaŋniġaat qullianun tupqum. ");
INSERT INTO eskNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa taamna qaninniqsuq Lydda-miñ. Ukpiqtuat taamani tusaakamitruŋ Peter innipḷugu Lydda-mi, malġuŋnik iññuŋnik tuyuqaġniqsut ilaanun, itna uqaksriuqługik, “Qilamiksruġutin utlautiiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peter-m itqanaiyaqtiqami maliŋniġik taapkuak. Tikitmata taamuŋa mayuutiniġaat qulliġmun inimun. Uiḷgaġnaat puuġniġaat qiaplutiŋ qiñiqtitaqługu atnuġarriaŋiñik Dorcas-ŋum iñuuŋŋaġmi. ");
INSERT INTO eskNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter-m anipkaqługich iluqaisa taapkua tavrakŋa inimiñ. Sitquqhuni agaayuniqsuq aasii kiŋiaqługu taamna timi nipliutiniġaa, “Tabitha makittin!” Taavruma aġnam uitñami qiñiġniġaa Peter aquvitluniasii. ");
INSERT INTO eskNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter-m isakhuni ikayuġniġaa makititlugu. Tavrakŋa ukpiqtuat uiḷgaġnaatlu isiqtitlugich qiñiqtinniġaa iliŋitñun iñuuplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iñugiaktuat iñuich Joppa-mi tusaaniqsut taavrumiŋa aasiiñ ukpiqsriḷiqhutiŋ Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter tuyuġmiaŋuniqsuq Joppa-mi iñugiaktuani uvluni, tukkuqaqhuni Simon-mik qitummairimik. ");
INSERT INTO eskNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tavra Caesarea-mi aŋutiqaġniqsuq atiliŋmik Cornelius-mik aŋalatchipḷuni tallimakipianik aŋuyyiuqtinik. Taapkuali aŋuyyiuqtit aggiġñiqsuat Italy-miñ. ");
INSERT INTO eskNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Taamna Cornelius agaayyutiqaġniqsuq tupiqatituummaġmi taluqsripḷutiŋ Agaayyutmik. Ikayuiñiqsuq Jew-ŋuruat nagliŋnaqtuaŋitñik agaayumaaqtuaŋupluni. ");
INSERT INTO eskNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iḷaŋatni unnuksraat piŋasuġuġuŋnaqsipman qiñiqquuraaġniqsuq nalupqinaiqł̣ugu qiñiġniġaa Agaayyutim isaġulga isiqhuni tuqłuqtini, “Cornelius!” ");
INSERT INTO eskNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius-ŋum qiñiqpakługu isaġulik iqsił̣ikun kiuniġaa, “Suva? Aŋuun! Qanuq-samna?” Isaġulgum itnaġniġaa, “Agaayyutim tusaagaa iŋiqsrułhiñ tautukługu ikayuił̣hiñ nagliŋnaqtuanik. Taatnaqhuni itqaġigaatin. ");
INSERT INTO eskNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pakma Joppa-mun tuyuqaġiñ iñuŋnik uvuŋautityaqtillugu Simon taggisiqaqtuaq Peter-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Taamamna tukkumaruaq Simon-miptuuq qitummairimi taġium siñaani irviqaqtuami.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Taatna uqautianikamiuŋ taamna isaġulik qiñiġnaiġñiqsuq. Cornelius tuqłuiñiqsuq malġuŋnik savaktiŋmiñik suli atautchimik aŋuyyiuqtimik agaayyutiqaqhuni savautriruamik. ");
INSERT INTO eskNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ilaan uqautiqqaaqługich tamarrumiŋa atuumaruamik Joppa-munaasiiñ tuyuġiniġai. ");
INSERT INTO eskNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Uvlutqikman qallipmiullu Joppa-mun, Peter-li mayuġniqsuq tupqum qaaŋanun iŋiqsruġiaqhuni uvluqpaguqtuami. ");
INSERT INTO eskNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ilaa niġisuliḷḷapiaqmiuġlu. Niqiksranik itqanaiyaqtitlugich Peter-li qiñiqquuraaġniqsuq tatpakmani. ");
INSERT INTO eskNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Qiñiġniġaa qiḷak aŋmaqługu sumimña atqaqiaqsiñiġaa atriqaqtuam ukił̣haaqpaktun niŋitauruatun nunamun sisamatigun iqirġuigun. ");
INSERT INTO eskNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Taamna imaqaġniqsuq qanusipayaanik nunam niġrutaiñik paamġuqtuanik suli tiŋmiruanik. ");
INSERT INTO eskNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Agaayyutim nipliutiniġaa, “Peter! Makillutin tuqqutchiḷutin niġġiiñ!” ");
INSERT INTO eskNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peter-m kiuniġaa, “Ataniiq! Taatnaġumiñaipiaqtuŋa! Niġiñġaqsimaitchuŋa qanutchimik agliġikkamnik unniiñ qaayuġikkaŋatnik.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Peter-m tusaatqiḷgiññiġaa nipi, “Qanutchich Agaayyutim salummakkaŋi ilvich isummatigiyumiñaitchitin qaayuġnaġlugich.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Taatnaiḷiñiqsuq piŋasuniaglaan aasii taavruma aquagun ukił̣haaq nuqitqiŋñiġaa tatpakmuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter isumaksraqtuaqsiñiqsuq qanuutautilaaŋanik qiñikkiutauruam iŋmiñun. Taatnaqtitlugu taipkuali Cornelius-ŋum tuyuġikkaŋi apiqsruqtaġniqsut nani Simon tupqa itmaŋaan, aasiiñ iḷitchuqsrianikamiŋ nutqaġniqsut talum sivuġaanun. ");
INSERT INTO eskNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Apiqsruġniqsut, “Tukkumaruaqaqpa uvani atiliŋmik Simon Peter-mik?” ");
INSERT INTO eskNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter-mli taamna kaŋiqsiñiaqtitlugu qiñiqquuraakkaġmi qanuutautilaaŋanik Ipqitchuam Irrutchim nipliutiniġaa, “Qakma siḷatipni piŋasut iñuich pakakkaatin. ");
INSERT INTO eskNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Paqnalutin atqaġiñ. Piqasiġiakkich tuyuġikkaġigitkakii.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peter atqaqami nipliutipiaġai, “Uvaŋa pakiŋñiġipsitŋa. Suplusi aggiqpisi?” ");
INSERT INTO eskNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Taapkua kiuniġaat, “Cornelius-ŋum aŋuyyiuqtit atanġata tuyuġigaatigut. Ilaa nakuuruaŋuniqsuq aŋun agaayusuuruaq Agaayyutmun suli iluqatiŋ Jew-ŋuruat kamagiplugu. Agaayyutim isaġulgan uqautiniġaa tupqanun aiyugaaquplutin tusaatquplugu uqauttutiksraqnik.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter-m tukkiġñiġai taapkua unnuitquplugich tavrani. Uvlaakuġuqman aullaqmata maliŋniġai. Iḷaŋisaptuuq ukpiqtuat tavrakŋa Joppa-miñ tuvaaqasiġñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Uvlutqiḷgitman Caesarea-mun tikiññiqsut. Cornelius-ŋum niġiukhuni iḷani suli iḷauraani katinŋaniksimaniġai. ");
INSERT INTO eskNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aasiiñ Peter isiaqsipman Cornelius-ŋum purviginiġaa agaayuvigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aglaan Peter-m makitinniġaa nipliutiplugu, “Makittin! Uvaŋaptuuq iñułhiñauruŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter-m uqaqatiginiġaa Cornelius itqutigalugu tupiġmun. Tavraniasiiñ iḷitchuġiniġai iñugiaktuat iñuich katianiŋniqsuat. ");
INSERT INTO eskNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tavraasiiñ nipliutiniġai, “Ilipsipsuuq iḷisimallapiakkaqsi Jew-ŋuruat piqasiqsuutilguyumiñaitchuat atuqtaksraŋisigun Jew-ŋuŋitchuat. Aglaan Agaayyutim iḷisautigaaŋa uvaŋnun kiñapayaaq iñuk qaayuġitquŋitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Taatnaqłuŋa qanniġñiqapŋa utlautiruŋa pisaġumasuŋaqnaŋa. Apiqsrullaglakpiñ, suvaata qanniġñiqpiŋa?” ");
INSERT INTO eskNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius-ŋum kiuniġaa, “Sisamat uvlut uŋataatni itnaiḷiyuŋnaqsiruami uvlumi kiñunnamni uvluqpaguqman agaayulgisitḷuŋa, taimmaiñaq aŋun atnuġaalik qaummaġiksuanik qikaaniktiġniqsuq sivuqqamnun. ");
INSERT INTO eskNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Itnaġaaŋa, ‘Cornelius! Iŋiqsruutigikkatin Agaayyutim tusaagai suli nagliksripḷutin savaatin itqaġigai. ");
INSERT INTO eskNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuyuqaġiñ Joppa-mun aŋutinik uvuŋautityaqtillugu Simon taggisiqaqtuaq Peter-mik. Taamamna taamma tukkuummiruq Simon-miptuuq qitummairimi taġium siñaani ittuami.’ ");
INSERT INTO eskNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Taatnaqłuŋa uiguiñaqługu qanniġikpiñ, iłuaqqutiluġniġiptigut uvuŋałłapkun. Uvva iluqata katirugut Agaayyutim sivuġaanun tusaayumaplugu qanuq Agaayyutmun uqautiłiksraptigun ilipkun.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter aullaġniiñiqsuq itnaqhuni, “Pakma puttuqsrigiga iḷumutun Agaayyutim irrutrił̣ha iñuŋnik atisipḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nanipayaaq nunaaqqimi iñuk taluqsripman ilaanik nalaunŋarualiqipluni Agaayyutim akuqtuumaaġniġaa, taamna sumiuŋugisiŋŋaan. ");
INSERT INTO eskNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nalupqisuŋitchuŋa tusaatilaapsitñik tusaayugaallautakun Agaayyutim tuyuġikkaŋa Israel-aaġmiunun, itnaqhuni, Agaayyutim qiñuiġutripkaġaa iñuŋnik Jesus Christ-kun, taamna Jesus Atanġuruaq iñupayaani. ");
INSERT INTO eskNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tamanna tusaayugaallautaq aullaġniipḷuni Galilee-miñ kiŋuagun John-ŋum Paptaaqtitchirim quliaqtuałhan siamittuq iluqaanun Judea-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tusaakkaqsi Jesus Nazareth-miu Agaayyutmun sayyiqł̣ugu piqasiqł̣ugu Ipqitchuamik Irrutchimik pikkaŋa. Taamna Jesus napmupayaaqami nakuurualiqiniqsuq suli iłuaqsiraġakkaŋi tamatkua tuunġaum aŋalataŋi, atakkii Agaayyutim piqasiqsuqługu. ");
INSERT INTO eskNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aasiiñ uvagulli qiñiqługu iluqaan iñiqtaġikkaŋa Jew-ŋuruat nunaŋatni suli Jerusalem-mi, uqautigilgugikput qanuq iḷipḷugu kikiaktuutiłha sanniġutamun suli iñuŋnun tuqqutaġiłha. ");
INSERT INTO eskNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Taamna taatnakkaŋat Agaayyutim aŋitqiksitkaa tuqułiġmiñ piŋayuakni uvlut. Iḷaŋisa iñuich nalupqinaiqł̣ugu qiñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Iluqallapiaġmiŋ iñuich qiñinġitchaluaġaat, aglaan qiñiġikput Agaayyutim piksraqtaaġipluta quliaqtuaġitquplugu ilaagun. Uvagut niġiqatigigikput imiqatigiplugu Agaayyutim aŋitqiksinŋanikmagu tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aasiiñ ilaan tiligaatigut tusaayugaallautaq uqautigitquplugu iñuŋnun, iḷisimarausimaaqupluta ilaa taivrumiŋaułłi Agaayyutim piksraqtaaŋa ataniġuqługu iñuuruani suli tuquŋaruani. ");
INSERT INTO eskNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Taamna Jesus sivuniksriqiripayaat uqautigikkaŋat, itna, Kiñapayaaq ukpiqsrigumi ilaanik Jesus-ŋum natqigutigisigai killuqsautai atiġmigun.” ");
INSERT INTO eskNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tavrani Peter uqautrisugaaqtitlugu iluqaitñun naalaġniruanun uqauttutaanik Ipqitchuam Irrutchim atqaqiniġai. ");
INSERT INTO eskNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tamatkua Jew-ŋuplutiŋ ukpiqsriruat taamakŋa Joppa-miñ maliktuat Peter-mik quviġusuŋniqsut Agaayyutmun qaił̣ha Ipqitchuamik Irrutchimik tamatkunuŋaptuuq Jew-ŋuŋitchuanun. ");
INSERT INTO eskNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Sumiuliraaqhutiŋ uqqatigun tusaagaqsiñiġaich uqaqtuat Agaayyutmik quyaplutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tavraasiiñ Peter nipliġñiqsuq, “Uvaptiktituntuuq ukua Ipqitchuam Irrutchim aŋalatkai. Kiami paptaaqsaiḷiraġniaqpagich imiġmik?” ");
INSERT INTO eskNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Taatnaqługich ilaan tiliñiġai paptaaqtitquplugich Jesus atqagun. Taapkua iŋiqsruġniġaat uvliuqtuallaquplugu piqatigilutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Uqqiraqtit suli ukpiqtuapayaat iluqaani Judea-mi tusaaniqsut qanuq Jew-ŋuŋitchuanik Agaayyutim uqałhanik akuqtuiruanik. ");
INSERT INTO eskNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Aasiiñ Peter Jerusalem-mun utiqman iḷaŋich ukpiqsriruat Jew-ŋuplutiŋ isumaqaqtuat Jew-ŋuŋitlutiŋ ukpiqsriruat nalunaitŋutchiquplugich nakuaġiŋiññiġaat Peter-m quliaqtuałha Jew-ŋuŋitchuanun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Piñiġaat ilaa, “Uvva aiyugaaqtauplutin kiŋunġatnun nalunaitŋutchiŋaitchuat, niġiqatigikapkich killuqsaġniqsutin.” ");
INSERT INTO eskNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Taatnaqługich Peter-m uqautiaqsiñiġai qanuq atuumałhagun aullaġniiḷġatałhaniñaglaan. ");
INSERT INTO eskNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Itnaġniqsuq, “Itluŋa nunaaqqiani Joppa-m iŋiqsrułłamni qiñiqquuraaqtuŋa. Qiñiġiga sua-imña atqaqtuaq qiññalik ukił̣haaqpaktun. Niŋititauruq sisamatigun iqirġuigun tatpakmakŋa, nutqaqhuni saniqqamnun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Qiñiviksuqapku qiñiqtuŋa niġrutinik uumaruanik paamġutlaruaniglu suli tiŋmitḷaruanik, imaiñik taavruma. ");
INSERT INTO eskNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tavraasiiñ Agaayyutim nipliutigaaŋa, ‘Peter! Makillutin tuqqutchiḷutin niġġiiñ!’ ");
INSERT INTO eskNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Taamna kiugiga, ‘Taatnaġumiñaipiaqtuŋa, Ataniiq! Qanusiq agliġikkaġa qaayuġnaqtuaq uvaŋa uqummiqsimaitchiga.’ ");
INSERT INTO eskNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Agaayyutim tatpakmakŋa nipliutitqikkaaŋa, ‘Qanusiq Agaayyutim salummaanikkaŋa isummatigiyumiñaitchiñ qaayuġnaġlugu.’ ");
INSERT INTO eskNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Taatnaiḷipḷugu atuummiruq piŋasuniaglaan, aasiiñ taamna qiñikkaġa nuqitaupluni kiŋumun tatpakmuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Taatnaqtitluŋa piŋasut iñuich tikiññiqsut taavrumuŋa tupiġmun nayukkamnun. Taapkua tuyuġirauniqsuat uvaŋnun Caesarea-miñ. ");
INSERT INTO eskNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ipqitchuaq Irrutchim uqautipmaŋa maliquplugich qanuġviitchuŋaqnaŋa. Ukua itchaksrat aniqatiut tuvaaqasiġaatŋa Caesarea-mun. Iluqata isiqtugut Cornelius-ŋum tupqanun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aasii uqautipluta Cornelius-ŋumli qiñiqquuraakkaġmiñik isaġuliŋmik tupiġmiñi aasiiñ nipliutiplugu, ‘Joppa-mun tuyuqaġutin uvuŋautityaqtirruŋ Simon Peter. ");
INSERT INTO eskNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Taamavruma amma uqautiginiakkaŋan anniqsuġisigaatin kiŋuniqtuummaqpitḷu.’ ");
INSERT INTO eskNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Aasiiñ tasamuŋitḷuta uqaaqsikama Ipqitchuam Irrutchim atqaqigai iliŋich atriḷḷapiaqługu pił̣ł̣i uvaptiknuntuuq taimani Pentecost-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Itqaġitka Agaayyutim uqałhi itnaqsimaruat, ‘John-ŋum imikun paptaaqtitchił̣ha aglaan ilipsi paptaakkaugisił̣iqsi Ipqitchuakun Irrutchikun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Taamna nalupqinaiḷḷapiaqtuq Agaayyutim qaitchił̣haptuuq Ipqitchuamik Irrutchimik Jew-ŋuŋitchuanun atripḷugu qaisaġikkani uvaptiknun ukpiqsriqapta Atanġuruakun Jesus Christ-kun. Qanuġlugu nutqaqtitkisivigu Agaayyun savaaksraŋaniñ?” ");
INSERT INTO eskNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Taatnaiḷipḷugu tusaakamitruŋ Peter-m tusaayugaaqtirrutaa iliŋisa nutqautiniġaat pisaaŋŋatriŋ. Iliŋich quyaaqsiñiqsut Agaayyutmik itnaqhutiŋ, “Agaayyutimtuuq piviqaqtilluġniġai mumił̣iksraŋatigun Jew-ŋuŋiḷaat piññaktaaqaquplugich isuitchuamik iñuułiġmik.” ");
INSERT INTO eskNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tamaakŋa ukpiqtuat siaminniqsut atakkii piyuaqsiuplutiŋ aquagun Stephen tuqqutaupkaqqaaqługu. Iḷaŋich tikiumaniqsut Phoenicia-mun iḷaŋich Cyprus-mun suli Antioch-mun, tusaayugaallautamik uqautiqaqhutiŋ tuŋaaqaqługu Jew-ŋuruanun kisiitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aglaan iḷaŋiḷḷi ukpiqtuat Cyprus-miñ Cyrene-miñḷu utlautiruat Antioch-mun tamatkunuŋaptuuq Jew-ŋunġitchuanun uqautigiluumaaġniġaat tusaayugaallautaq Atanġuruakun Jesus-kun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Agaayyutim sayyiqsimaniġai, aasiiñ iñugiaktuat tusaaruat mumiksitḷasipḷugich Ataniġmun ukpiqsrił̣ikun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ukpiqtuaŋuruat Jerusalem-mi tusaaniqsut tamatkunuuna. Taatnaqhutiŋ tuyuqaġniqsut Barnabas-mik Antioch-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas tikitñami, ilaan iḷitchuġiniġaa Agaayyutim savaaġikkaŋa taamani, aasiiñ quyallapiaġniqsuq. Ilaan pitchuksaaġniġai iluqaisa tuniqsimmatritquplugich Agaayyutmi iluqnaaqsimaałikun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas iñullautaupluni ukpiqsriḷḷapiaqhuni Ipqitchuam Irrutchim aŋalataġiniġaa. Tavraasiiñ iñugiaktuat iñuich maliġuaqtiġuġniqsut Agaayyutmi. ");
INSERT INTO eskNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tavrakŋa Barnabas aullaġniqsuq Tarsus-mun pakkiaqługu Saul. ");
INSERT INTO eskNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aasiiñ paqitnamiuŋ Antioch-muutiniġaa. Tavraniasiiñ atautchimi ukiumi iqatauplutik iñugiaktuanik ukpiqtuaŋuruanik iḷisautripḷutik. Taavrumani Antioch-mi ukpiqtuaŋuruat taiyuutiniŋniqsut sivulliuplugu “Christ-ŋum iñuiñik.” ");
INSERT INTO eskNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Taatnałhatni tamaani iḷaŋiḷḷi sivuniksriqirit utlautiniqsuat Jerusalem-miñ Antioch-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iḷaŋat atiqaġniqsuq Agabus-mik sivullikkaułiġmigun Ipqitchuakun Irrutchikun makitluni uqaġniqsuq niġisuŋnamun tikitkisiñipḷugu iluqaanun nunamun. Taamnaasiiñ niġisuŋnaq taavruma uqautigikkaŋa atuumaruq Claudius qaukłiupkaqługu Rome-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Taatnaqhutiŋ ukpiqtuat sivunniġñiqsut aatchuutinik tuyuqaġukhutiŋ piyummiñaġniqtutilaaġmikni ukpiqtuaqatiumiknun Judea-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iliŋich tuyuġniqsut aatchuutinik Barnabas-kunlu Saul-kunlu ukpiqtuaŋuruat qaukłiŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Umialgumli Herod-ŋum aullaġniiñiġaa nagliksaaqtitchił̣iq iḷaŋitñik ukpiqtuaŋuruat. ");
INSERT INTO eskNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","James, John-ŋum aniqataa, savikpaŋmik tuqqutinniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Aasiiñ Herod kaŋiqsikamiuŋ quyalitñił̣ł̣i Jew-ŋuruanik tiguniġaa Peter suli naŋititchiaqsiñiqsuq ukpiqtuanik. Taatna irrutrił̣ha atuummiñiqsuq niġił̣hatni pupsaŋniġiḷaamik qaqqiamik. ");
INSERT INTO eskNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter taamna tigukamitruŋ inillaŋniġaat isiqsiviŋmun, qaitḷugu sisamaiñun aŋuyyiuqtinun qaunagitquplugu. Herod-ŋum sivunniġaa Peter tikiutilugu iñuŋnun atanniqsitchukługu niġiqpagvikaaq atilik Apqusaakkaułiġmik pitḷukpan. ");
INSERT INTO eskNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Peter isiqtaułhani ukpiqtuaŋuruatli iŋiqsruutiniġaat piḷiqillapiaqhutiŋ Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod-ŋum tikiutisukkaa Peter iñuŋnun atanniġukługu sivuġaatni iñuich. Unnuaŋani anitchił̣iksraŋan iñuŋnun Peter siñiŋniqsuq akunġatni malġuk munaqsrik, malġuiñik kalimñiġñik pituqaqhuni, suli isiqsivium paaŋi qaunaksriqaqhutiŋ munaqsriñik. ");
INSERT INTO eskNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Taimmaiñaq atanġum isaġulga sagviġñiqsuq, isiqsivium iḷua qauplugu. Isaġulgum iqiiqsaġniġaa aksikł̣ugu Peter tuiqqaŋagun nipliutiplugu, “Qilamik makittin!” Tavrauvaa kalimñiġich kataŋniqsut tayaġnikniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Isaġulgum qilamiksriġñiġaa, “Tapsiaġiksaaġutin, aluġutikkiñ atilugik.” Peter taatnatun piñiqsuq. Isaġulgum nipliutipsaaġniġaa, “Uligaaġutin maliŋŋa!” ");
INSERT INTO eskNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter-m maliaqsiñiġaa isiqsiviŋmiñ kaŋiqsiḷḷapiaġaluaqnagu isaġuliŋmun taatna pił̣ł̣i. Ilaa siññaqtuġasukniaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Apqusaaġutiniġaa sivulliġñi qaunaksrini tugliŋitñi sulipsuuq, aqulliupluguasiiñ tikiññiqsuk savigruaġmun paamun anigisipḷutik nunaaqqimun. Taamna paa aŋmalgiññiqsuq iŋmigun, iliŋikaasiiñ anipḷutik. Iliŋik qilamiksruqhutik apqutikun, aasiiñ taimmaiñaq isaġulgum uniŋñiġaa Peter tamauŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tavrani Peter-m kaŋiqsivaaluaqsiñiġaa tamanna atuumaruaq. Uvva itnaġniqsuq, “Nalupqigiŋaiġiga Agaayyutim tuyuqałha isaġuliŋmiñik annautisaqłuŋa Herod-ŋum aŋalatchił̣haniñ. Ilaan anniqsuqmigaaŋa Herod-miñ suli Jew-ŋuruaniñ piyaqquisuktuaniñ uvamnik.” ");
INSERT INTO eskNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Taamna qauġriaqpalaktiqami utlautiniqsuq kiŋunġanun Mary-m, aakaŋan John Mark-ŋum. Tavraniḷi iñugiaktuat katimaniqsut iŋiqsruqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Taluata siḷataani Peter katchaqtuġniqsuq. Niviaqsiaq atiqaġniqsuaq Rhoda-mik utlautiniqsuq paamun kisuupmagaan. ");
INSERT INTO eskNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Peter-m nipaa iḷisaqłiġniġaa. Quviatchaqtiqpaitḷuni aŋmautigaluaqnaguunniiñ utiqtiġniqsuq kiñumun uqaġiaqhuni, “Peter qakma!” ");
INSERT INTO eskNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Taapkua nipliutiniġaat, “Kinniqivaluktutin!” Aglaan taamna niviaqsiaġruk nalupqisuŋiññiqsuq. Aasiiñ kiulgiññiġaat, “Irrusia pivalukkiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peter-m nutqautiŋiññiġaa katchaqtułłi. Kiisaimmatai aŋmautiniqpaat. Iliŋisa qiñiqamitruŋ quviġutchaŋniqsut niġiunġiḷḷaqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter-m urriqaniġai nipaisaaquplugich aasiiñ uqautiaqsipḷugich qanuq Agaayyutmun annisisilaaġmiñik isiqsiviŋmiñ. Uqautipsaaġniġai, “Kilikkumagisi James-lu atlatlu ukpiqtuat.” Aasiiñ ilaa aullaġniqsuq atlamun inimun. ");
INSERT INTO eskNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Uvlutqikman isiqsivium qaunaksrai aupił̣ł̣aŋniqsut. Kaŋiqsitḷaiġñiġaat qanuqtilaaŋa Peter-m. ");
INSERT INTO eskNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod-aasiiñ tiliriñiqsuq iñuŋnun pakaquplugu Peter aglaan paqiŋiññiġaat. Herod-ŋum apiqsruqtuqqaaġniġai munaqsrit aasiiñ tilisigiplugich tuqqutquplugich. Tamanna atuumaanikman Herod Judea-miñ aullaġniqsuq ittuallagiaqhuni Caesarea-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod-ŋumguuq qinnausimallapiaġniġai iñuich iñuuniaqtuat Tyre-miḷu Sidon-miḷu. Taatnaqhutiŋ iliŋisa katiplutiŋ qiñiġiaġniġaat Herod. Taapkua utlautiruat sivulliuplugu iḷauraannaktaaġiniġaat umialgum tuglia, taamna atiqaqtuaq Blastus-mik. Aasiiñ taatnaqqaaqhutiŋ utlautiplutiŋ Herod-mun iŋiqsruġiaġniġaat qiñuiġusimaałiksraġmiktigun, atakkii taapkua Tyre-miut Sidon-miut niqiqaġviqaqtut umialgum nunagikkaŋaniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Uvvaasiiñ nalunaiqsami uvlumi Herod atnuġaaqtuqhuni umialgutnaġmiñik aquvinniqsuq atanġuviŋmiñun uqautriviksraġmiñun iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tyre-miut suli Sidon-miut naalaġniruat Herod-mik nipliagaqsiñiqsut itnaqhutiŋ, “Taamna Agaayyutim nipigigaa. Iñułhiñaq nipiqaŋitchuq taatnatchiñik.” ");
INSERT INTO eskNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Taimmaiñaq Agaayyutim isaġulgan Herod atniġñatchiġñiġaa iŋalauŋiñi atakkii kamakkutaitḷuni Agaayyutmik. Qumaich niġiñiġaat aasiiñ tuquniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Aglaan ukpiqtuarguuq siamitchiñiqsut Agaayyutim uqałhanik aasiiñ iñugiallapiaqtuat akuqtuġniġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Suli Barnabas-lu Saul-lu naatchikamik savaaġmiknik utiġniqsuk Jerusalem-miñ Antioch-mun tuvaaqatigiplugu John Mark iŋmikkun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ukpiqtuaŋuruat Antioch-mi iḷaqaġniqsut iñuŋnik sivuniksriqiriniglu iḷisautriñiglu itna, Barnabas-miglu, Simeon-miglu (taiyuutiliŋmik Taaqsipaŋmik), Lucius-miglu (Cyrene-miumik) Manaen-mik (iñuguqatiqaġniqsuaq Herod-mik kavanauruamik) suli Saul-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Uisauraaġniqsut tamarrumani uvlumi. Agaayupkaqtitlugich Ipqitchuam Irrutchim nipliutiniġai, “Barnabas-lu Saul-lu piksraqtaaġisigik uvaŋnun savaaksranun tuqłuummatigikkamnun iliŋiknun.” ");
INSERT INTO eskNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tavra uisauraaqhutiŋ agaayuanikamiŋ argaŋmiknik patikługigḷu tuyuġiniġaich. ");
INSERT INTO eskNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ipqitchuam Irrutchim tuyuġiniġik Barnabas-lu Saul-lu. Igliqhutik Seleucia-mun aasii tavrakŋa tiksiġñiqsuk qikiqtamun taiyuutiliŋmun Cyprus-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Iliŋik tikitñamik Salamis-mun nunaaqqiuramun Cyprus-mi quliaqtuaġniqsuk Agaayyutim uqałhanik Jew-ŋuruat katraġviatni. John Mark-mik ikayuqtiqaġniqsuk. ");
INSERT INTO eskNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tavrakŋa nunakuaqhutik taavrumuuna qikiqtakun tikiññiqsuq Paphos-mun. Taavrumani nalautchiñiqsuk aŋatkumik Jew-ŋuruamik atiqaqtuamik Bar-Jesus-mik Hebrew-miutun suli Elymas-mik Greek-miutun. Ilaa nipiqaġniqsuq sivuniksriqiraunipḷuni. ");
INSERT INTO eskNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ilaan iḷannaġiniġaa kavanauruaq taavrumani qikiqtami, atiqaqtuaġġuuq Sergius Paulus-mik suli puqiksuaŋupluni. Taavruma kavanauruamguuq aiyugaaqtullapiaġniġik Barnabas-lu Saul-lu tusaasukhuni Agaayyutim uqałhanik. ");
INSERT INTO eskNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Aglaan taavruma aŋatkum Elymas-ŋum akiḷḷiḷiqsuġniġik taapkuak atakkii kavanauruaq ukpiqsritquŋitḷugu Christ-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Aasiiñ Ipqitchuam Irrutchim aŋalataġigaa Saul, taggisiqaġmiruaqtuuq Paul-mik. Taavruma Paul-ŋum qiñiqamiuŋ naliŋiñaaqługu taamna aŋatkuq ");
INSERT INTO eskNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nipliutiniġaa, “Ilvich tuunġaum atrigigaatin! Iluqaan nakuuruaq uumiginiġiñ ataramik kinnipḷugich iñuich pisaasułipkun. Uqautigiŋaiġuŋ Agaayyutim iḷumutuułha sagluuqtuaŋuniḷugu. ");
INSERT INTO eskNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pakma Agaayyutim anasiñŋuqsaġniaġaatin. Qiñitlaisaallakkisirutin qaumamik.” Taatnaġluqaaqtuq Elymas-ŋum iḷitchuqłiġniġaa taaqtuamun matułhak irraŋmi. Ilaa saptaaqsiñiqsuq kisumun iñuŋmun tasiullaŋniaqupluni argaŋmigun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kavanauruam qiñiqamiuŋ taamna atuummiruaq ukpiliġñiqsuq quviġutchakhuni iḷisauttutaanik Agaayyutikun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul-lu tuvaaqatiuniḷu Paphos-miñ tiksiġñiqsut Perga-mun Pamphylia-mi. John Mark-ŋum uniŋñiġik utiqhuni Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Taapkuak Perga-miñ igliġniqsuk tikitḷutik Antioch-mun Pisidia-mi. Jew-ŋuruat minġuiqsiaġviata uvluani utlautiniqsuk katraġviatnun aquvitlutikaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses-ŋum maliġutaksraŋa suli sivuniksriqirit aglaaŋitñiñ agliqianikman katraġvium qaukłiŋisa itnaġniġiŋik, “Aniaqatiuk, uqauttutiksraqaġuptik pitchuksaaġutmik iñuŋnun uqaqugiptigiñ iliŋitñun.” ");
INSERT INTO eskNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul makitnami urriqaplugich uqautiaqsiñiġai, “Jew-ŋuqatiumaaŋ suli sumiuŋuruapayaasii taluqsriruasii Agaayyutmik! Naalaġniḷḷaksitŋa! ");
INSERT INTO eskNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Agaayyutaata Israel-aaġmiut sivulliavut piksraqtaaġinikkaŋi. Ilaan kamanaqsipkaqługich taimani iñuuniałhatni Egypt-mi. Suli Agaayyutim annisipḷugich Egypt-miñ saŋŋimigun kamanaqtuakun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Suli malġukipiani ukiuni Agaayyutim igḷutuqługich Israel-aaġmiut iglaułhatni suviksraiḷaami munaġiplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tavra iñugaaġruich Canaan-mi piyaqquanikamigich iñuksraqtaġmiñun nunaksrirrutiginiġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Suli aquagun tamatkua sisamat tallimakipiat malġukipiaq qulit ukiut ilaan qaitchiñiġai sivulliuqtiksraŋitñik iñuguġniałhanunaglaan Samuel-ŋum taivruma sivuniksriqirim. ");
INSERT INTO eskNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Aasiiñ taapkua Jew-ŋuruat umialiqaġuaqsipmata Agaayyutim qaitchiñiġai Saul-mik iġñiŋanik Kish-ŋum kiŋuviaŋiñiñ Benjamin-ŋum. Malġukipiani ukiuni atanniqsuqtigiluummaan umialiginiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Aglaan Agaayyutim Saul piiqł̣ugu inaŋiqsinniġaa David-mun umialiguqługuasii taapkunuŋa. Taamna iñuk Agaayyutim itnautigimanikkaŋa sivuani, ‘Taamna David iġñiŋa Jesse-m iñuk quviasuutigigiga atuigisipḷuni pisułiġikkamnik iluqaagun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Taavrumakŋa David-ŋum kiŋuviaŋiñiñ Agaayyun tikiutriruq Jesus-mik anniqsuqtiksramik Jew-ŋuruanun, taatna ilaan akiqsrułiġmisun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sivuani Jesus-ŋum aggił̣han John-ŋumli quliaqtuaġutiniġai iluqaisa Jew-ŋuruat mumiquplugich paptaaqtillugiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aasiiñ John naatchiyasikami savaaġmiñik ilaan nipliutiniġai, ‘Kisuunasugivisitŋa? Uvaŋa taivrumiŋauŋitchuŋa niġiugikkaqsi. Ilaapiaq aggiġñiaqtuq kiŋupkun. Uvaŋa taivruma isigaiñi aluġutaiqsiksrauluŋaunniiñ nalliummatiŋitchuŋa.’ ");
INSERT INTO eskNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Aniqatiumaaŋ, Abraham kiŋuviaġikkaŋasii suli iluqasi uvani taluqsriruasii Agaayyutmik, taamna tusaayugaallautaq anniqsuġiakun tuyuuruq uvaptiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jew-ŋuruat iñuuniaqtuat Jerusalem-mi suli sivulliuqtituummaġmiŋ iḷitchuġiŋiññiġaat Jesus Anniqsuutaułha. Minġuiqsiaġvipayaami agliqiraġigaich uqauttutiŋich sivuniksriqirit katraġviŋmikni aglaan kaŋiqsisaitḷugich. Patchisigikamitruŋ Jesus iliŋisa iḷumun atuumapkaġniġaich sivuniksriqirit uqautigikkaŋich. ");
INSERT INTO eskNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Sumikunniiñ patchisiksraitchaluaŋŋaġmiŋ agvisiksraitḷugu iŋiġniġaat Pilate tuqqutitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Aasiiñ immianikmatigik supayaat Agaayyutim uqauttutai maliġuaqtaiñ atqaġniġaat kikiaktuutriviŋmiñ inillakługuasiiñ iḷuviġmun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Aglaan Agaayyutim aŋitqiksinniġaa tuqułiġmiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iñugiaktuani uvluni Jesus sagviaqtuġniqsuq tamatkunuŋa igliqatmiñun Jerusalem-mun Galilee-miñ. Pakma taapkua iḷisimaraurut ilaagun iñugikkaptiknun Jew-ŋuruanun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Uvaguttuuq uqautigiptigiñ tusaayugaallautamik, itna, Agaayyutim akiqsruutigikkaŋa sivulliaptiknun pakma atuumapkaġniġaa uvaptiknun kiŋuviaŋuruanun aŋitqiksitnamiuŋ Jesus iñuułiġmun. Atakkii tugliani Psalm aglausimaruq itna, ‘Ilvich iġñiġigikpiñ, ugluvak aapaġuqtuŋa ilipnun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Agaayyutim aŋipkaqamiuŋ Jesus tuqqutqikkumiñaiqł̣ugu akiqsrupsaaġniqsuq itna, ‘Aatchuqniaġipsi ipqitchuaniglu nalupqinaitchuaniglu akiqsruutigikkamnik David-mun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Taatnaqhuni atlamisuli Psalm-mi David-li nipliġñiqsuq, ‘Savaktin ipqitchuaq aupkaġumiñaitkiñ.’ ");
INSERT INTO eskNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David-guuq savautrigaluaqmiruaq Agaayyutmik iñuułiġmiñi. Tuqupman iḷuviġniġaat piqasiutiplugu sivulliaŋiñun, timaa aasiiñ tavrani aupluni. ");
INSERT INTO eskNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Aglaan taimña Jesus Agaayyutim aŋipkakkaŋa tuqułiġmiñ auŋaitchuq. ");
INSERT INTO eskNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Iḷauramaaŋ, iluqasi kaŋiqsiruksraurusi iḷumutuułiġmik quliaqtuaġikkamnik ilipsitñun, Taavrumuuna Jesus-kun Agaayyutim natqił̣hiñaugai killuqsautisi. Kiñaunniiñ tupiksriñiałiġmigun maliġutaksraiñik Moses-ŋum nalaunŋasipkakkauyumiñaitchuq Agaayyutmi. ");
INSERT INTO eskNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Aglaan kisupayaaq ukpiqsriruaq ilaanik nalaunŋasipkakkauruq ilaani. ");
INSERT INTO eskNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Taatnamik qaunagititchi. Atuummiŋitchumauq ilipsitñun taipkua sivuniksriqirit itnautaat, ");
INSERT INTO eskNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ataŋii, mitautiqaqtuasii Agaayyutmik! Atlayuaġilugu piyaqquġniaqtusi. Iñuupkaġlusi savaaqaġisiruŋa ukpiġiyumiñaisapsitñik unniiñ iñuum uqautiniaġaluaqpasi.’” ");
INSERT INTO eskNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul-lu Barnabas-lu aniaqsipmaknik katraġviatniñ iñuich aiyugaaqtuaqsiñiġaich utitqiquplugik minġuiqsiaġvik tikitqikpan uqautipsaaġiaquplutiŋ tamarrumuuna. ");
INSERT INTO eskNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kiŋuagun katimałhum iñugiaktuat Jew-ŋuruat suli mumiksimaaqtuat Jew-ŋuruat ukpiġusiatnun maliaqsiñiġaich Paul-lu Barnabas-lu. Aasii iliŋik pitchuksaaġniġaich ataramik tunŋavigitquplugu Agaayyutim iłuaqqutrisaa. ");
INSERT INTO eskNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Minġuiqsiaġvik tikitqiḷgitman iñuich iluqatiqayaq katiniqsut naalagiaqhutiŋ Agaayyutim uqałhanik. ");
INSERT INTO eskNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tavrali Jew-ŋuruat qiñiqamisigiŋ iñugiakpauraqtuat siqñaliḷḷapiaqhutiŋ akikŋaqługich Paul-ŋum uqautai uqaġniqłuutiaqsiñiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Aglaan Paul-lu Barnabas-lu uqaġniqsuk taluqsraŋiḷḷapiaqhutik itna, “Agaayyutim uqałha sivulliulugu uqautauruksrauruq ilipsitñun Jew-ŋuruanun aglaan tusaasukkumiñaitkiksi. Taatnałipsigun ayakkiksi iñuułiq Agaayyutitŋaqtauruaq. Taatnamik uniŋñiaġipsi aullaġunuk tamatkunuŋa Jew-ŋuŋitchuanun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Taatnakii Agaayyutim urriqsuġaatiguk itnaiḷipḷugu, ‘Nalunaiqsaġigikpiñ qaumaruatun itquplutin Jew-ŋuŋitchuanun anniqsuquplugich iñuich suniaŋanipayaaq nunam.’” ");
INSERT INTO eskNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tavra Jew-ŋuŋitchuat tusaakamitruŋ taamna quyaaqsiñiqsut Agaayyutim uqałhanik quviatchallapiaqhutiŋ. Aasiiñ taapkua piksraqtaaŋuruat iñuułiqaquplugich Agaayyutitŋaqtauruamik ukpiqsriḷiġñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Uvvaguuq Agaayyutim uqałha siaminniqsuq napmupayaaq tamaani nunami. ");
INSERT INTO eskNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tavrali Jew-ŋuruat akatchiñiqsut aġnanik kamagikkauruanik taluqsriruanik Agaayyutmik suli qaukłiiñik taavrumani nunaaqqimi. Piyuaqtinniġaich Paul-lu Barnabas-lu anittitlugikaasiiñ nunamikniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Uqqiraqtik ipsuŋniġaak qavia isigaŋmikniñ. Tavrakŋaasiiñ aullaġniqsuk Iconium-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aglaan ukpiqtuat unisauruat Antioch-mi quviasuŋniqsut Ipqitchuam Irrutchim aŋalatlugich. ");
INSERT INTO eskNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Taapkuak Paul-lu Barnabas-lu tikitñamik Iconium-mun, sivuanisun utlautilgiññiqsuk Jew-ŋuruat katraġviatnun. Uqautriḷḷautapiaġataġniqsuk aasiitai iñugiaktuat Jew-ŋuruatlu Jew-ŋuŋitchuatlu ukpiqsriḷiqsitlugich. ");
INSERT INTO eskNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Aglaan Jew-ŋuruat ukpiqsriyumiñaitchuat akatchiñiqsut Jew-ŋuŋitchuanik. Iliŋisaunniiñ akikŋaqtuliqsitkaich ukpiqsriruanik. ");
INSERT INTO eskNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Uqqiraqtik nayuutiniqsuk tavrani akuni uqautripḷutik taluqsrautaiqhutik Agaayyutikun. Quliaqtuałhakni iłuaqqutrił̣iġmigun Agaayyutim savaktitlasipḷugik quviqnaqtuanik savaanik, taavrumuuna qiñiqtinniġaa uqauttutaak iḷumutuułha. ");
INSERT INTO eskNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nunaaqqim iñui malġuiguġniqsut, iḷaŋich iñuich iḷaliutiplutiŋ Jew-ŋuruanun atlatsuli tappiutiplutiŋ uqqiraqtiŋnun. ");
INSERT INTO eskNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kiisaimma Jew-ŋuŋitchuat suli Jew-ŋuruat sivulliuqtituummaġmiŋ sivunniġñiqput aŋallaqługukługik unniiñ miḷuqtuġlugik uyaġaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Uqqiraqtik iḷitchuġikamitku taamna sivunniuġun qimaŋniqsuk Lystra-munlu Derbe-munlu, nunaaqqiŋñun Lycaonia-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Lycaonia-mi quliaqtuagaqsiḷgiññiqsuk tusaayugaallautamik. ");
INSERT INTO eskNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tavraniguuq Lystra-mi qiñiġniqsuk iñuŋmik piḷguirrutiqaqtuamik isigaŋmigun aniḷġatałiġmiñiñaglaan. Pisunġaŋiññiqsuq aglaan aquppitḷapluni. ");
INSERT INTO eskNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Taamnaguuq naalaġniñiqsuq Paul-ŋum uqauttutaiñun. Aasiiñ iḷitchuġiplugu taavruma ukpiqsrisilaaŋa iłuaqsikkaułiksraġmigun Paul-ŋum qiñiaqsiñiġaa nalaagun ");
INSERT INTO eskNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nipliutiniġaa nipitusipḷuni, “Qikaġiñ.” Taamnaguuq aŋun maksriŋñiqsuq pisukkataaqsipḷuniasii. ");
INSERT INTO eskNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Uvvaguuq iñugiaktuam Paul-ŋum savaaġikkaŋa qiñiqamiuŋ Lycaonia-ġmiuraaqhutiŋ niprallaŋniqsut itnaqhutiŋ, “Agaayyutivut iñuguġniqsut aasii atqaqhutiŋ uvaptiknun.” ");
INSERT INTO eskNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Atchiġñiġaat Barnabas Zeus-mik Paul-aasiiñ Hermes-mik atakkii taamna Paul nipliraqtaupman. ");
INSERT INTO eskNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tavraniguuq piqaġniqsuat agaayyuviŋmik aanġuaġmiknun Zeus-mun siḷataani nunaaqqim. Aasiiñ agaayuliqsi taamavrumuŋa Zeus-mun tikiutriñiqsuq uumaruanik aŋusalunik naurianiglu paamun. Tavrataamna iñuiḷḷu tavrani tuniḷḷaġuaqsiñiqsut kamaksrisukhutiŋ uqqiraqtiŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Uvvaasiiñ iḷitchuġiaqsikamitku taamna Barnabas-ŋumlu Paul-ŋumlu aliktuġniġaik atnuġaatik aasiiñ upaktuutiplutik itnaqhutik tamatkunuŋa, ");
INSERT INTO eskNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ukuqsii, suvaata itnasiġaqpisi? Iñułhiñauruguk ilipsisuntuuq. Aggiqsuaŋuruguk uqautityaqhusi tusaayugaallautamik mumiqugaluaqhusi matkunakŋa agaayyutiŋŋuaniñ iñuuruamun Agaayyutmun, iñiqtaanun qiḷamlu nunamlu taġiumlu supayaamlu taapkunani ittuam. ");
INSERT INTO eskNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Taavruma Agaayyutim qaaŋianiktuami iluqaisa iñuich iḷatchiġñiġai sivunnitḷasipḷugich iñuuniałhatigun. ");
INSERT INTO eskNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Aglaan ataramik kaŋiqsimapkaġniġaa nakuuruaŋułłi savaallautaġmigun, sialuk tatpakmakŋa qaitḷugu suli niqiksrat nautchiat piviksraŋisigun qaisimaaġai, ilipsiḷiasiiñ quviasuktitlusi.” ");
INSERT INTO eskNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Taatnaiḷipḷugu uqautiuraġniallaisa Barnabas-ŋumlu Paul-ŋumlu nutqaqtipqauraġniġaik tuniḷḷałiksraŋatniñ iŋmiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Aasiiñ iḷaŋich Jew-ŋuruat Antioch-miñ Pisidia-miittuamiñ suli Iconium-miñ tavruŋalgiññiqsut. Tavra piqatiksraġniaqtuqhutiŋ iñugiaktuanik iŋmiknun uyaġaŋnik miḷuqtulgiññiġaat Paul. Kaliŋñiġaat anitlugu nunaaqqimiñ tuqunasukniaqługu. ");
INSERT INTO eskNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Aglaan ukpiqtuaqatiuŋi katipmata avataanun Paul makitluni utiġniqsuq nunaaqqimun, uvlaakuqmanaasiiñ ilaalu Barnabas-lu aullalgitḷutik Derbe-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul-lu Barnabas-lu quliaqtuaqmaknik tusaayugaallautamik Derbe-mi iñugiaktuat ukpiqsriḷiġñiqsut. Tavraasiiñ utiġniqsuk Antioch-mun Pisidia-miittuamun Lystra-kun Iconium-kunlu. ");
INSERT INTO eskNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pitchuksaaqługich tunŋaviqaquplugich Agaayyutmik, uqautiniġaich itna, “Uvagut igḷutuqtuksraurugut iñugiaktuanik iłuiḷḷiuġutinik isitlasiñiapiaġuta aŋaayuqautaanun Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tikitchaġikamik ukpiqtuaŋuruanun nalunaiqsisiraqniġaich ukpiqtuaŋuruat qaukłiksraŋitñik, suli agaayuqqaaqhutiŋ uisauraaqhutiŋlu tamarrumani uvlumi iŋiqsruutiniġaich Agaayyutmun qaunagitquplugich tunŋavigikkaŋatnun. ");
INSERT INTO eskNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Taapkuak iglianikamik Pisidia-m nunaŋani Pamphylia-mun tikiññiqsuk. ");
INSERT INTO eskNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tamatkunani Perga-miḷu tusaayugaallautaq uqautigiaqsiḷgiññiġaak, tavrakŋaasiiñ Attalia-mukhutik. ");
INSERT INTO eskNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Taavrumakŋa tiksiqhutik utiġniqsuk Antioch-mun aullaqqaaġataġviŋmiknun. Tavrakŋa aullaqtuak ukpiqtuaŋuruat iŋiqsruutianikamisigik Agaayyutmun qaunagitquplugik savautiłhakni iŋmiñun. Taavrumuŋa utiġniqsuk naatchikamik savaaġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tikitmaknik Antioch-mun ukpiqtuaŋuruat katipmata taapkuak tusaayugaaqtinniġaich iluqaanik Agaayyutim savaaŋanik tumigiplugik suli Jew-ŋuŋitchuatunniiñ ukpiliqsitlugich. ");
INSERT INTO eskNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tavraniasiiñ ukpiqtuaqatiumikni taapkuak nayuutiniqsuk akuni. ");
INSERT INTO eskNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kiŋuagun iñuich iḷaŋich tikiññiqsut Antioch-mun. Iḷisautriaqsiñiqsut ukpiqtuanik itna, “Nalunaitŋutchiqsimaitchupsi timipsigun tuvraqługich Moses-ŋum tillisai anniqsukkauyumiñaitchusi.” ");
INSERT INTO eskNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul-lu Barnabas-lu qapiqtaiḷiaqsiñiqsuk iliŋitñik taavrumuuna. Taatnaqhutiŋ sivunniġñiqsut Paul-lu Barnabas-lu iḷalugik atlanik Antioch-miunik Jerusalem-muquplugich. Taakmani uqaqatigiruksraġigaich uqqiraqtitlu ukpiqtuaŋuruat qaukłiŋitḷu tamatkunuuna Moses-ŋum tillisaigun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Taatnaqhutiŋ ukpiqtuaŋuruaqatiŋisa tuyuġiniġaich. Igliġniqsut Phoenicia-kunlu Samaria-kunlu uqautripḷutiŋ Jew-ŋuŋitchuatunniiñ mumiŋñipḷugich Agaayyutmun. Taatnatchim tusaayugaam iluqaisa aniaqatigiich quviatchaktinniġai. ");
INSERT INTO eskNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Aasiiñ Jerusalem-mun tikitmata ukpiqtuaŋuruat piqasiqhutiŋ uqqiraqtinik suli qaukłiġñik paġlaniġaich. Taapkunuŋa tusaayugaaqtirrutiginiġaat Agaayyutim iluqaan savaaġikkaŋa iŋmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Aglaan iḷaŋich ukpiqsriruat Pharisee-ŋusuuruat makinniqsut itnaqhutiŋ, “Jew-ŋuŋitchuat ukpiqsriruat nalunaitŋutchiqsuksraupiaqtut uqautikkaulutiŋ tupigiraksraġiniḷugu maliġutaksraŋa Moses-ŋum.” ");
INSERT INTO eskNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Taatnaqhutiŋ uqqiraqtitlu ukpiqtuaŋuruat qaukłiŋisalu katimaniqsut isummatigisukługu taamna. ");
INSERT INTO eskNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Uqaksraqtugaluaqmata Peter makitluni nipliġñiqsuq, “Aniqatiumaaŋ! Iḷisimarusi iŋiḷġaan akunnapsitñiñ Agaayyutim piksraqtaaġipmaŋa uqaġiaqupluŋa tusaayugaallautamik Jew-ŋuŋitchuanun ukpiqsritquplugich Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Aasiiñ Agaayyutim iḷisimałiġmigun iñuich isumaŋitñik uqaġigaa akuqtuił̣ł̣i Jew-ŋuŋitchuanik qaitchipḷugich Ipqitchuamik Irrutchimik, atripḷugu qaitchił̣ł̣i uvaptiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Uvagullu iliŋiḷḷu atlakaaġiiksinġitkaatigut. Killuqsautiŋitñik natqiutiniġai ukpiġiagutripmata. ");
INSERT INTO eskNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Uvvami suvaata naipitchukpisiuŋ Agaayyun suli Jew-ŋuŋitchuat tupiksripkaġniaġlugich tillisinik sivulliaptalu uvagullu tupigilguisaptiknik? ");
INSERT INTO eskNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Uvagut ukpiġigikput Agaayyutmun anniqsułiqput iłuaqqutrił̣hagun Atanikun Jesus Christ tamatkunatuntuuq.” ");
INSERT INTO eskNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Katimaruarguuq iñuksruiqhutiŋ naalaġniñiqsut Barnabas-ŋumlu Paul-ŋumlu tusaayugaaqtirrutaaknun atlayuaġnaqtuaniglu quviqnaqtuaniglu Agaayyutim iñiqtaġikkaŋagun iŋmikkun akunġatni Jew-ŋuŋitchuat. ");
INSERT INTO eskNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Uqaġuiqmaknik James-ŋum uqautiaqsiñiġai, “Aniaqatiumaaŋ, naalaqsitŋa! ");
INSERT INTO eskNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Peter-m uqautigaatigut qanuq Agaayyutmun aullaġniipḷuni ukpiqtitlugich iŋmiguaqtitchaqługu Jew-ŋuŋitchuaniñ iñuksraqtaaqaqtuq ukpiqsriyumiñaqsipḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Suli sivuniksriqirit uqautaatnun immiutiłha itnauvva aglausimaruamun, ");
INSERT INTO eskNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Aquagun Atanġuruaŋaa utiġisiruŋa. Aasiiḷi ikayuitqikkisiruŋa David-ŋum kiŋuviaŋiñik tupaaġruktitun ittuanik. Nappatqikkisigiga piyaqqukkauruaq. ");
INSERT INTO eskNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iluqaġmiŋ atlatlu iñuich pakaaqaġumuut Agaayyutmik, iluqaġmiŋ Jew-ŋuŋitchuat piksraqtaaġikkatka uvaŋnun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Taatna Atanġuruaq uqaqsimaruq, iḷitchuġipkairuaq tamatkuniŋa iŋiḷġaan.’ ");
INSERT INTO eskNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Aasiiñ uvaŋali sivunniutigiga uqumaiḷḷiuqtitpałłasuŋaqnagich piḷavut Jew-ŋuruat atuqtaksraŋisigun Jew-ŋuŋitchuat mumiksuat Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Aglaan aglaglugich uqautilavut qanusiq niqi tuniḷḷautaumakpan aanġuanun niġitquŋiḷḷugu, suli qaayuġnaqtuałiġmiñ atlatułikun piisimaaqulugich, suli augiqsimaiḷaanik niġrutituquŋiḷḷugich unniiñ auktuquŋiḷḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Taimakŋaqaŋa Jew-ŋuruapayaat iḷisimagaat atuqtaksrat Moses-kun qaisauruat atakkii minġuiqsiaġvipayaami agliqiplugich iñuŋnun katraġviŋitñi. Tavra.” ");
INSERT INTO eskNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tusaakamisigiŋ uqqiraqtit suli qaukłiuruatlu iluqaġmiglu ukpiqtuaŋuruat sivunniġñiqsut aŋutinik piksraġukhutiŋ Antioch-muktuksranik Paul-kunlu Barnabas-kunlu, aasii nalunaiqsipḷutiŋ Judas-mik taggisiqaqtuamik Barsabbas-mik suli Silas-mik. Taapkuak iññuk sivulliuqtillautauniqsuak ukpiqtuaqatiumikni. ");
INSERT INTO eskNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Taapkuŋnuuna tuyuutiŋich tuyuuniqsut, “Aniaqatiusii, uvagut uqqiraqtauruaguutlu qaukłiuruaguutlu, tuyuqtugut nayaaŋŋaġmik iluqaitñun Jew-ŋuŋitchuanun ukpiqtuanun Antioch-mi, Syria-miḷu suli Cilicia-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tusaaniġikput iḷaŋitñun iḷagikkaptiknun iłuiḷḷutaaġnipḷusi akatlusi uqałiġmikkun, taatna pitqulugich piŋitkaluaqtitlutiŋ uvaptiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tavra-taatna katimapluta suli iluqata atisipḷuta, piksraqtaaqaqtugut uqaġiaqtauksranik aasii aullaqtillugich ilipsitñun. Taapkuak piqataugisiruk iḷauraannaptikni Barnabas-miḷu Paul-miḷu, ");
INSERT INTO eskNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","taapkuak iññuk suksraaġiruak iñuułiġmiknik savautrił̣iġmikni Atannaptiknik Jesus Christ. ");
INSERT INTO eskNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judas-lu Silas-lu tuyuġiniaġivut ilipsitñun. Uqautipsaaġisigaasi tamatkunuuna aglakkaptigun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Atakkii Ipqitchuaq Irrusiq piqatigiplugu sivunniqsugut qaitchisuŋitḷusi malilgunaitchuanik tuvraaksranik, aglaan taapkuniŋa atuumanapiaqtuanik: ");
INSERT INTO eskNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","niqinik tuniḷḷautigimaruanik aanġuanun niġiñasi auktusuŋaqasiḷu unniiñ qimisimaruamik niġrutmik niġiñasi, suli piisimaaġusi qaayuġnaqtuałiġmiñ atlatułikun. Taapkunakŋa qaunagigupsi piḷḷautaġniaqtusi. Tavra.” ");
INSERT INTO eskNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aullaqtitauruat tikitmata Antioch-mun katipkaġniġaich iluqaisa ukpiqtuat aasiiñ qaitchipḷugich taapkuniŋa aglaŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Iñuich agliqianikamisigik tuyuutiŋich quviatchaŋniqsut pitchuksaaġiłiġmikkun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas-lu Silas-lu sivuniksriqiraułiġmikkun uqautriñiqsuk ukpiqtuanik pitchuksaaqługich ukpiqsrił̣iġmikkun sayyaksaqługiḷḷu. ");
INSERT INTO eskNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Aasiiñ tavraniisugruanikmaknik ukpiqtuaqatiuŋitñik taikuuqhutiŋ aullaqtinniġaich kiŋumun tuyuġiriŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Aglaan Silas sivunniġñiqsuq nayuutisukhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Taapkuagli Paul-lu Barnabas-lu ittuiñaġniqsuk Antioch-mi. Piqasiqhutik atlanik iḷisautriñiqsuk Atanġuruam uqałhiñik quliaqtuaqhutik. ");
INSERT INTO eskNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kiŋuvatigun Paul-ŋum nipliutiniġaa Barnabas, “Kiata, utiġvigilavuk nunaaqqiurapayaat Agaayyutim uqałhanik quliaqtuaġvigikkavuk tikitqattaaġlugich aniaqatiut kaŋiqsityaġlugu qanuġli pisilaaŋat.” ");
INSERT INTO eskNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas-ŋum tuvaaqatigisuŋniġaa John Mark aullaġumik. ");
INSERT INTO eskNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Aglaali Paul-ŋum iłuaġiŋitkaa aullautiłha ikayuŋitḷugikkii quliaqtuaqmaknik, unitḷugikunniiñ Pamphylia-qsiułhakni. ");
INSERT INTO eskNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Taatnaqhutik qapiqtaiḷiḷḷapiaġniqsuk piqatigiiñġiqhutikunniiñ. Barnabas-li tuvaaqasiqhuni Mark-mik Cyprus-mun umiakun aullaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Taamnali Paul tuvaaqatiksraqhuni Silas-mik aullaġniqsuq. Ukpiqtuaqatiutik iŋiqsruutiniġaich Agaayyutmun qaunagitquplugik igliłhakni. ");
INSERT INTO eskNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Igliġniqsuk Syria-kuaqhutik suli Cilicia-kun, aasiiñ Paul-ŋum sayyaksaqługich ukpiqtuaŋuruat ukpiġutiŋich. ");
INSERT INTO eskNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul-kuk iglaugaluaqamik tikiḷġataġniqsuk Derbe-mun suli Lystra-mun. Tavraniguuq ukpiqtuaqaqmiñiqsuq atiliŋmik Timothy-mik, aakaŋaptuuq ukpiqtuaŋupmiñiqsuaq Jew-ŋupluni aglaali aapaŋa Greek-ŋupluni. ");
INSERT INTO eskNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iluqaġmiŋ ukpiqtuat Lystra-mi Iconium-miḷu uqautigillautaġniġaat taamna Timothy. ");
INSERT INTO eskNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul-ŋum Timothy maliquniġaa iŋmigun. Taatnaqługu nalunaitŋutchiqsinniġaa piqutigiplugich Jew-ŋuruat iñuuniaqtuat tamaani naluŋitmatruŋ taamna Timothy aapaqałha Jew-ŋuŋitchuamik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Apqusrautiłiġmikni nunaaqqiurani uqautiniġaich ukpiqtuaŋuruat tuvraqtaksranik, uqqiraqtit suli qaukłiich Jerusalem-mi sivunnikkaŋitñik iliŋitñun tupigitquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Taatnaqhutiŋ ukpiqtuaŋuruat sayyikkauniqsut ukpiqsrił̣iġmiktigun suli iḷaniktuuġniqsut ukpiqtuaġuqtuanik uvluġaġipman. ");
INSERT INTO eskNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Taapkua igliġniqsut tumigiplugu Phrygia-miut Galatia-ġmiut nunaŋat. Ipqitchuam Irrutchim piyummataisitmatiŋ tusaayugaallautamik Asia-muutriŋiññiqsut. Iliŋich taunuŋaŋiññiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Aasiiñ qallikamitruŋ Mysia-m killiŋa saqusukkaluaġniqsut Bithynia-m tuŋaanun, aglaan Jesus-ŋum Irrutchiġmigun taatnamuquŋiññiġai. ");
INSERT INTO eskNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Taatnaqhutiŋ nalġuġniqsut Mysia-kun tasamuŋa Troas-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tamarrumani unnuami Paul qiñiqquuraaġniqsuq Macedonia-ġmiumik qiññuaqtuqtuamik itnaqhuni, “Macedonia-mun ikaaġutin ikayuġiaqtigut!” ");
INSERT INTO eskNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul qiñiqquuraaqtitqaaqługu itqanaiyaqtiqapta aullaqtiqtugut Macedonia-mun. Ikpigigikput tuqłułiqput tusaayugaallautamik quliaqtuaġiaqupluta iñuŋnun taakipkunuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas-miñ umiakun aullaqtugut nalġuqhuta qikiqtamun Samothrace-mun, aasiiñ taavrumakŋa uvlutqikman Neapolis-mun tiksiqhuta. ");
INSERT INTO eskNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tavrakŋa tagraqtugut Philippi-mun, qaukłiġmun nunaaqqiatnun Macedonia-ġmiut, iñugiaktuanik Rome-maġmiunik iñuqaqtuamun. Taavrumani nunaaqqimi uvliuqtugut. ");
INSERT INTO eskNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Minġuiqsiaġvium uvlua tikitman anipḷuta nunaaqqimiñ utlautirugut kuugum siñaanun iŋiqsruġiaġasugiplugich. Aquvitnapta uqaaqtuutrirugut aġnanik tavruŋaptuuq katiruanik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Iḷaŋat naalaqtikput atiqaġniqsuaq Lydia-mik. Taamna tunniuqqairuaŋuniqsuq suŋauraammaġiksuanik ukił̣haanik, aggiqsuaŋumapluni nunaaqqianiñ Thyatira-m. Kamaksriruaŋuniqsuq Agaayyutmik. Aasriiñ Agaayyutim piyumiñaqsipkaġaa akuqtuił̣iksraŋanun Paul-ŋum uqaġikkaŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Taamna aġnaq paptaakkaukami piqasiqhuni tupiqatiuŋiñik ilaan aiyugaaqługich itnaqhuni, “Ukpiqtauŋunasugigupsitŋa utlauttuttitchi tuppamni itchaqtuaġusi.” Kayuŋaiġñiġai tukkiqł̣ugichaasiiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uvlut iḷaŋatni iŋiqsruġviptiknun utlautiłłaptikni kipaluuniksuaq niviaqsiġaksraq nalautkikput. Ilaa tuunġaqtaqaġniksuaq taatnatchikun saŋŋiqałiġmigun sivuniksriqipluni, aasiiñ atqunaq maniŋmik piññautinikkaŋa atanni. ");
INSERT INTO eskNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Taavruma Paul-lu uvagullu maliaqsigaatigut nipliapluni itna, “Ukua iñuich savaktai kamanaġniqsrauruam Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Iñugiaktuani uvluni taamna niviaqsiġaksraq taatnaġniqsuq. Uvvaasiiñ Paul-ŋum aġiuplugu kiŋiaqługu irrusiq itnaġniġaa, “Jesus Christ-ŋum atqagun tiligikpiñ anitquplutin taavrumakŋa.” Tavrauvaaguuq tuunġaqtaq aniñiqsuq niviaqsiġaksramiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tavra pigirai iḷitchuġikamiŋ maniññaŋniutriŋ piiqsiġniqman Paul-lu Silas-lu tiguniġaich. Kaliksraqługik katimmaviŋmuutiniġaich sivulliuqtiŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rome-maġmiunun atanniqsuqtinun tikiutiniġaich itnaqhutiŋ, “Ukua iñuich Jew-ŋuruat akatchirut iñuŋnik nunaaqqipsitñi. ");
INSERT INTO eskNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iḷisautripḷutiŋ atuqtaksrirrutit akikŋaqługich maliŋniakkavut. Rome-maġmiuŋurugut! Iliŋisa iḷisauttutiŋich akuqtuġumiñaitkivut unniiñ tupigiyumiñaitkivut.” ");
INSERT INTO eskNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iñugaaġruich tappiutiniqsut piyuaqniktuanun. Rome-maġmiut aŋalarrutilgich tilisiñiqsut aliktuiḷugik atnuġaaŋiknik Paul-ŋumlu Silas-ŋumlu aasii ipiġaqtuquplugik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ipiġaqtuqqaaqługik isiqtaupkaġniġaich, tilipḷugu isiqsivium qaunaksraa qaunagillautaquplugik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Taatna tilianikmatni qaunaksrim inillaŋniġik qamaniakłiġmun inimun, isigaŋiglu payaŋaiqsuusiqługik uqumaiḷanik qiruŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Uvvaasiiñ unnuaqpaguġuŋnaqsipman Paul-lu Silas-lu agaayuniqsuk quyaplugulu Agaayyun atuqhutik. Atlat isiqtauqatiŋikñik naalaġniñiġaich. ");
INSERT INTO eskNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Taimmaiñaq nuna iḷiqsraaqsiñiqsuq. Isiqsivium tunŋavii auliyaŋniqsut, talupayaat aŋmaqługich suli kalimñiġich isiqtapayaaniñ katakhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Isiqsivium qaunaksraa itiqtiqami iḷitchuġiplugu talut aŋmaniqmata isumaniqsuq isiqtapayaat aninipḷugich. Taatnaqhuni satkuni tiguplugu tuqqutchaġumaaqsiḷiġniqsuq iŋmiñun. ");
INSERT INTO eskNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aglaan Paul-ŋum nipitusipḷuni nipliutiniġaa, “Aniyasaaqnak ilipnun! Iluqata ittugut!” ");
INSERT INTO eskNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Isiqsiri qiññuaġniqsuq nannimik. Itchaġlukami tatkivuŋa punniqsuq uulillaġmi sivuġaaknun Paul-lu Silas-lu. ");
INSERT INTO eskNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tavrakŋa annisikamigik atlamun apiqsruġniġik, “Aŋutiik! Qanuġluŋali anniqsuġayaqpik?” ");
INSERT INTO eskNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Taapkuak nipliutiniġaak, “Atanġuruakun Jesus Christ-kun ukpiqsriḷutin anniqsuġisirutin tupiqatituummaqpich.” ");
INSERT INTO eskNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Agaayyutim uqałhiñik quliaqtuaġvigiaqsiñiġaak atlallu ittuat tupqani. ");
INSERT INTO eskNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Unnuaqpaguqman isiqsirim iġġuaqsiñiġik atniaġniŋik aasiiñ ilaa tupiqatituummaġmi paptaaqtikkauniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Taatnaanikami ilaan Paul-lu Silas-lu tupiġmiñuutiplugik niġipkaġniġik. Tupiqatigiich quviatchaŋniqsut ukpiġiagutripḷutiŋ Agaayyutmik. ");
INSERT INTO eskNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Uvlaaġutqikman Rome-maġmiut aŋalatiŋisa aikł̣iqsuqtitiŋ tiliñiġaich anipkaquplugik taapkuak aŋutik aullaqtillugiglu. ");
INSERT INTO eskNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Taavruma isiqsirim Paul uqautiniġaa itna, “Qaukłiich anitqugaatik Silas-lu. Aullałhiñaaġuqtutik aniuraġniaġitchik.” ");
INSERT INTO eskNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aglaan Paul-ŋum aikł̣iqsuqtit nipliutiniġai, “Pasiyumiñaitkaatiguk savvaġluutiqaqtilaaptiknik aglaan ipiġaqtuqhunuk iñuŋnun qiñiqtitlugu inillakmipḷunuk isiqsiviŋmun. Uvaguktuuq Rome-maġmiuŋuruguk. Uvvami pakma aullaqtitchuŋniqpatiguk iriqqakun? Taatniitchumiñaipiaqtuq! Rome-maġmiut qaukłiich iŋmiknik uvuŋaġutiŋ anipkaġlisiguk!” ");
INSERT INTO eskNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Aikł̣iqsuqtit Rome-maġmiut aŋalatiŋitñun uqautiginiġaich Paul-ŋum uqautai. Tusaakamiŋ Paul-lu Silas-lu Rome-maġmiuŋułhakkuntuuq iqsitchaŋniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Taatnaqhutiŋ uqapsaaġiaġniqsut iliŋikñun. Anipkaġniġaich isiqsiviŋmiñ aullaquplugik nunaaqqimiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul-lu Silas-lu anikamik isiqsiviŋmiñ utlautiniqsuk Lydia-m kiŋunġanun. Tavrani ukpiqtuaqatiutik qiñilgiññiġaik suli pitchuksaaqługich aasiiñ unitḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Amphipolis-kuaqhutik suli Apollonia-kun igliġniqsuk Thessalonica-mun piqaġniqsuamun Jew-ŋuruat katraġviatnik. ");
INSERT INTO eskNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Piraġiłiġmisun tavruŋalgiññiqsuq iñuŋni uqaqataupluniasiiñ. Piŋasuni minġuiqsiaġvium uvluani kaŋiqsipkautiginiġai Agaayyutim uqałhi, ");
INSERT INTO eskNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","suli nalupqinaiyaġuŋniġaa Anniqsuutim nagliksaaqhuni tuqqutauruksraułha suli aŋitqiksuksraułha tuqułiġmiñ. Paul-ŋum itnaġniġai, “Taamna Jesus uqaġikkaġa ilipsitñun Anniqsuutauruq.” ");
INSERT INTO eskNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iḷaŋich Jew-ŋuruat ukpiqsriḷiḷḷapiaqhutiŋ iḷaliutiniqsut Paul-mullu Silas-mullu. Taatnaqmiñiqsuttuuq iñugiaktuat Greek-ŋuruat agaayusriqisruuruat suli qulliuruat aġnat. ");
INSERT INTO eskNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Aglaan Jew-ŋuruat siqñaliġñiqsut. Katitchiñiqsut nalaunŋaniuraŋitchuanik iññukhutiŋ piqatiksraġmiknik. Iliŋisa nunaaqqim iñui akatkaqsiñiġaich. Isiġiaġniġaat Jason-ŋum tupqa pakakhutiŋ Paul-miglu Silas-miglu iñuŋnuutisukługik. ");
INSERT INTO eskNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Aglaan paqiŋitñamisigik Jason-lu atlatlu ukpiqtuatlu kaliksraġniġaich nunaaqqim aŋalataiñun. Tavraniasiiñ Paul-lu Silas-lu pasipḷugik niplianiqsut itna, “Taapkuak iññuk akatchiñiqsuk iñuŋnik nanipayaaq. Pakmatuuq nunaaqqiptiknuŋniqsuk ");
INSERT INTO eskNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aasiiñ Jason-ŋum tukkiqsimaplugik. Paaqłaŋniġaich tillisai umialgum Rome-mi, uqaqhutiŋ atlamik umialiqaġnipḷugu atiqaqtuamik Jesus-mik.” ");
INSERT INTO eskNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Taatnaqmata iñugiaktuat iñuich nunaaqqimlu aŋalatai akanniġaich uqaatchagutiłiġmun. ");
INSERT INTO eskNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Taatnamik aŋalatit Jason-lu atlallu annitchiqsinniġaich maniŋñik aasiiñ aullaqtitlugich. ");
INSERT INTO eskNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Unnupqauraqman ukpiqtuaqatiuŋiknik Paul-lu Silas-lu aullaqtinniġaich Berea-mun. Tavrani utlautilgiññiqsuk Jew-ŋuruat katraġviatnun sivuanisun. ");
INSERT INTO eskNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Iñuich Berea-mi uqautisuŋnatlukpayaaġniqsut apkunakŋa Thessalonica-ġmiuniñ. Tusaayumallapiaqhutiŋ uqałiq naalaqługu, suli uvluġaġipman Agaayyutim uqałhi iḷisaaġiniġaich iḷitchuġiniapiaqługu tamanna Paul-ŋum uqaġikkaŋa iḷumutuutilaaŋagun. ");
INSERT INTO eskNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Iñugiaktuat tavrani ukpiqsriḷiġñiqsut, iñugiaktuat qulliuŋuplutiŋ Greek-ŋuruat aġnatlu aŋutitlu. ");
INSERT INTO eskNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Aglaan Jew-ŋuruat Thessalonica-mi tusaaniġaat Paul-ŋum Agaayyutim uqałhiñik quliaqtuaqaġnipḷuguptuuq Berea-mi. Taatnamik tavruŋaqtiġniqsut akatchiaqsiḷgitḷutiŋ iñuŋnik isaałhiñaaġuqługich. ");
INSERT INTO eskNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ukpiqtuat qilamiksriġñiġaat Paul aullaquplugu taunuŋa taġium siñaanun, aglaan Silas-lu Timothy-lu tavraniittuiñaġniqsuk Berea-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Taapkua aullautriruat Paul-mik taunuŋautinniġaat Athen-mun. Taapkuali Berea-ġmiut utiġniqsut. Paul-ŋum uqautitquniġik Silas-lu Timothy-lu iŋmiñuquplugik piyumiñaqsipqauraqpaknik. ");
INSERT INTO eskNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul taqqił̣iġmiñi Silas-miglu Timothy-miglu Athen-mi aliatchallapiaġniqsuq qiñiqami iñugiaktuanik aanġuanik nunaaqqimi. ");
INSERT INTO eskNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Paul uqaqatiqaġniqsuq Jew-ŋuruaniglu katraġviatni suli Jew-ŋuŋitchuaniglu agaayyiaqtaqtuanik. Uvvasuli uvluġaġipman uqaqatiginiġai nalautnamigich atautchimugviatni. ");
INSERT INTO eskNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Taatnaqami nalautchikami Epicurea-ŋuruaniglu Stoic-ŋuruaniglu iḷisautriŋitñik qapiqsiġiutraqatiqaġniqsuq. Iḷaŋich uqaġniqsut, “Sumik una uqavaałłakti uqaksraqtuva?” Iḷaŋiḷḷiguuq niplianiqsut, “Atlanik agaayyutinik una uqaqaqpalliqsuq.” Taatnautiginiġaarguuq Paul quliaqtuaqman Jesus-mik suli aŋitqił̣iġmik. ");
INSERT INTO eskNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Aasiiñ tikiutiniġaat Paul sivuġaatnun katimaruat Areopagus-mi itnaqługu, “Iḷisimasukkaluaqtugut tamarrumiŋa nutaamik iḷisauttutigikkapnik. ");
INSERT INTO eskNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Iḷaŋa tusaakkapta atlayuaġigikput. Iḷitchuġisukkikput qanuutautilaaŋa tamarruma.” ");
INSERT INTO eskNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tamaanili iluqaġmiŋ Athen-naġmiut suli avakŋaqtat tavrani naalaguuniqsut tamarrumuuna nutauplugu tusaakkaġmikkun unniiñ uqaksraqtuutigiplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tavrani Paul qikaġniqsuq sivuġaatnun taapkua katimaruat Areopagus-mi itnaqhuni, “Athen-naġmiut! Iḷitchuġigiga agaayyutinik ukpiqsriḷḷapiałiqsi. ");
INSERT INTO eskNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Pisuktaułłamni nunaaqqipsitñi qiñiġitka agaayumaniaġvigikkasi. Paqittuŋa aanġuaqtuġviŋmik aglaqaqtuamik, ‘Agaayyutmun nalukkaptiknun.’ Taavrumuuna agaayumaniaġvigikkapsitñun nalugaluaqługu uqautiniaġipsi. ");
INSERT INTO eskNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Agaayyun iñiqtaqaqtuq nunamik suli supayaanik imaġikkaŋiñik. Atanġuruaq qiḷaŋmiḷu nunamiḷu irviqaŋitchuq agaayyuvikpaŋni iñuich iñiqtaŋitñi. ");
INSERT INTO eskNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Unniiñ tunŋaŋitchuq iñuŋnun qaitchił̣iksraŋatnun inuġikkaġmiñik atakkii iñupayaat qaitchigai iñuułiġmiglu aniġniġmiglu supayaaniglu. ");
INSERT INTO eskNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Iñuŋmiñ atautchimiñ iñiqtaġigaa iñupayaaq, taamna aggiġvigiplugu iñuuniaqtuapayaat iluqaani nunami. Sivuani iñiqtaġigaluaqnagich sivunniqsimagai qanutun suli nani iñuich iñuutilaaksraŋat. ");
INSERT INTO eskNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Agaayyutim inillaŋniġaa taatnatun iñuich pakaaġikpatni paqitauyumiñaqsipḷuni atakkii Agaayyun qanitkaluaqtuq iluqaptikni. ");
INSERT INTO eskNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Atakkii ilaagun kisian iñuuniaqhutalu aulaalukhutalu ittugut. Taatnaqhutiŋ aglaktipsi iḷaŋisa uqaġigaat itna, ‘Uvaguttuuq ilaan qitunġaġigaatigut.’ ");
INSERT INTO eskNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tavra qitunġaġiniqmatigut isumaruksrauŋitchugut Agaayyutim irrusia atriqaġasukniaġlugu aanġuanik maniŋñik kaviqsaanik naagaqaa qatiqtaanik unniiñ uyaġaŋnik piḷiukkanik savayułhatigun iñuich. ");
INSERT INTO eskNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Taipkunani ukiuni iñuich naluplutiŋ pił̣hatni Agaayyutim tautuiñaġaa iłhat aglaan pakma tillisiqaġaa iñupayaaq mumiquplugu killukun iłhatniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ilaa nalunaiqsaqaqtuq uvlumik atanniigaqsigumi nunam iñuanik nalaunŋaruałikun tumigiplugu iñuk piksraqtaaġimakkani. Ilaan nalupqinaiyaġniġaa iñupayaanun aŋipkaqamiuŋ piksraqtaaġimakkani tuqqutaułhaniñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tusaakamitruŋ Paul-ŋum uqaaqtuutaa aŋitqił̣ikun tuqqutaułiġmiñ iḷaŋisa tipsisautiginiġaat aglaan iḷaŋiḷḷi nipliġñiqsut, “Naalaqtaupsaaġukkiptigiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tavra Paul-ŋum uniññiġai katimaruat. ");
INSERT INTO eskNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Iḷaŋisa iñuich piqasiġñiġaat ukpiliqhutiŋ. Piqasiqsai iḷaqaġniqsut Dionysius-mik, iḷaŋnatniglu Areopaa-ŋuruat aġnamiglu atiliŋmik Damaris-mik suli atlanik. ");
INSERT INTO eskNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Taatnaanikami Paul aullaqhuni Athen-miñ Corinth-muŋniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Taamani nalautchiñiqsuq Jew-ŋuruamik atiqaqtuamik Aquila-mik animaruamik Pontus-mi suli aġnaatnik Priscilla-mik. Tavruŋaptuuq tikitqammiġñiqsuk atakkii Rome-maġmiut atanġata Claudius-ŋum aqpigiplugich Jew-ŋuruapayaat Rome-miñ aullaquplugich. Tavra Paul-ŋum qiñiġiaġniġik. ");
INSERT INTO eskNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Piññaŋniutiqaġniqsuk iñuuniutigiplugu palapkarriruałiġmik atripḷugu Paul. Taatnaqhuni tukkuniqsuq taapkuŋnuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Aasii minġuiqsiġaġipmata Jew-ŋuruat katraġviatni uqaqatiqaġaġniqsuq Jew-ŋuruaniglu Greek-niglu ukpiliqsinniaqługich. ");
INSERT INTO eskNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas-lu Timothy-lu Macedonia-miñ tikitmaknik Paul-ŋum aullaġniiŋaniŋniġaa quliaqtuatlułłi tusaayugaallautamik Jew-ŋuruanun uqautigiplugu taimña Jesus Christ-ŋunipḷugu anniqsuqtaunipḷugulu. ");
INSERT INTO eskNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Jew-ŋuruat igḷuliqmatni uqaqhutiŋ pigiiḷipḷugu, Paul-ŋum ipsuŋniġaa qavia atnuġaamiñiñ aasiiñ ilaan kaŋiqsipkaqsaqługich qanuqhuni taatnałiġmiñik itnaqhuni, “Anniqsuqtitchumiñaitkupsi patchisigiruksraurusi ilipsitñun. Uvaŋa patchisaiqsuŋa. Uvakŋaniñaglaan Jew-ŋuŋitchuanun quliaqtuaġisiruŋa.” Taatnaqqaaqługich uniŋñiġai. ");
INSERT INTO eskNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Paul nayuutiaqsiruq tupqani Jew-ŋuŋitchuam atiqaqtuam Titius Justus agaayusuuruam Agaayyutmun. Tupqa siḷalliġiplugu Jew-ŋuruat katraġviata inniqsuaq. ");
INSERT INTO eskNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, qaukłiq Jew-ŋuruat katraġviatni, ukpiġiagutiniġaa Agaayyun qitunġaqtuummaġmi. Suli iñugiaktuat Corinth-aġmiut tusaakamiŋ uqałiġmik ukpiqsriḷiġmiñiqsut suli paptaaqtitlutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Unnuat iḷaŋatni Paul qiñiqquuraaġniqsuq. Agaayyutim uqautiniġaa itna, “Iqsisuŋaqnak! Sivutmun uqaġiñ! Qapiqtasuŋaqnak! ");
INSERT INTO eskNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Piqasiumagikpiñ. Kia-unniiñ iñuum aniyasaaġumiñaitkaatin atakkii uumani nunaaqqimi iñugikkatka iñugiaktut.” ");
INSERT INTO eskNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ukiuq avvaġmik iḷaqasiqł̣ugu Paul inniqsuq tavrani iḷisautripḷuni iñuŋnik Agaayyutim uqałhanik. ");
INSERT INTO eskNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gallio kavanauŋupkaqtitlugu Greece-mi Jew-ŋuruat katiplutiŋ tigguġlukługu Paul uqaqsittaaġviŋmuutiniġaat ");
INSERT INTO eskNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","itnaqhutiŋ, “Uuma iñuum ukpiliqsinniaġai iñuich agaayutquplugich Agaayyutmun akikŋaqługu maliġutaksraq.” ");
INSERT INTO eskNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul-aasiiñ niplił̣hiñaaġuqtuġlu Gallio-m uqautiniġai Jew-ŋuruat, “Taamna iñuk iñiqtaqaqpan nalaunŋaitchuamik tuvraqtaksrallu tupigiŋiḷḷugich, nalaunŋanayaqtuq uvamni naalaġnił̣iksraġa anuqsrusiḷuŋa ilipsitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Aglaan pasikapsiuŋ uqałiqtigun iñuiḷḷu atiŋisigun ilipsiḷu maliġutaksrapsigun, ilipsitñik iłuaqsaqtaksraġigiksi. Taatnatchisigun atanniqsuiyumiñaitchuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Taatnaanikami anipkaġniġai uqaqsittaaġviŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jew-ŋuruat tigguġluŋniġaat Sosthenes, aŋalataa Jew-ŋuruat katraġviata, ipiġaqtuqługu sivuġaani uqaqsittaaġvium. Aglaan Gallio-m suqutigiŋiññiġai. ");
INSERT INTO eskNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Iñugiaktuani uvluni Paul itkaluaqami Corinth-mi ukpiqtuaqatmiñi uniññiġai piqasiqhuni Priscilla-miglu Aquila-miglu tiksiqhutiŋ Syria-mun. Sivuani ayałiksraġmi Cenchreae-miinŋaġmi niaqqi salipkaġniġaa piḷġusiatitun Jew-ŋuruat pisigiplugu akiqsruutmigun Agaayyutmun. ");
INSERT INTO eskNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Paul-kut tikiññiqsut Ephesus-mun. Utlautipluni Jew-ŋuruat katraġviatnun tavrani uqaqatiqaġniqsuq Jew-ŋuruanik. ");
INSERT INTO eskNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ittuatluuraallaqugaluaġniġaat iŋmikni aglaan Paul aŋiŋiññiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Unitkaqsikamigich uqautiniġai, “Agaayyutim pitqutigikpagu utiġiłhitchuŋa ilipsitñun.” Aullalgiññiqsuq Ephesus-miñ umiakun aasii ilaan uniññiġik Priscilla-lu Aquila-lu tavruŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tikitñami Caesarea-mun utlautipluni Jerusalem-mun qiñiġiaqługich ukpiqtuaŋuruat tavrakŋaasiiñ aullaġniqsuq Antioch-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tavrani itkalualgitñami qanutuntai aullalgiññiqsuq Galatia-mun Phrygia-munlu pitchuksaaġiaqługich iluqaisa ukpiqtuat. ");
INSERT INTO eskNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jew-ŋuruatliguuq iḷaŋat atiqaqtuaq Apollos-mik animapluni Alexandria-mi tikiññiqsuq Ephesus-mun. Taamnaguuq uqalgurauŋuniqsuaq kaŋiqsimmaaġiksauŋupluni Agaayyutim uqałhanik. ");
INSERT INTO eskNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Iḷisausiaqaqhuni Agaayyutikun aasiiñ piyummatiqallapiaqługu iḷisauttutiginiġaa Jesus nalautlugu. Aglaan Apollos-ŋum iḷisimałhiñaġniġaa John Paptaaqtitchirim quliaqtuaġiłhalu paptaaqtitchił̣halu. ");
INSERT INTO eskNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Uqautriaqsiñiqsuq taluqsrautaiqhuni Jew-ŋuruat katraġviatni. Priscilla-mlu Aquila-mlu tusaakamitku aggisiñiġaak kiŋuniġmiknun aasii iḷisautipsaaqługu sukuitḷukługu Agaayyutim annautriḷḷatilaaŋanik iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apollos sivunniqman aullaġukhuni Greece-mun ukpiqtuaŋuruat Ephesus-mi ikayuġniġaat aglakhutiŋ ukpiqtuaqatiumiknun Greece-mi pitchuksaaqługich paġlatquplugu taakmani. Apollos tikitñami ikayuutaullapiaġniqsuq ukpiliqsuanun Agaayyutim iłuaqqutrił̣hagun. ");
INSERT INTO eskNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kaŋiqsiñaqsipḷugu uqaaqtuutrił̣iġmigun akiiḷitḷaniġai Jew-ŋuruat aasiiñ uqaqatigiił̣iġmikni Agaayyutim uqałhatniñ nalunaiġaqługu taamna Jesus Christ-ŋułha. ");
INSERT INTO eskNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos-li Corinth-miititlugu Paul-li kukiḷukhuni kivataagun tikiḷġataġniqsuq Ephesus-mun. Tavraniguuq nalautchiñiqsuq iḷaŋitñik ukpiqtuat. ");
INSERT INTO eskNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Apiqsruġniġai, “Akuqtuivisi Ipqitchuamik Irrutchimik ukpiliqapsiaglaan?” Taapkua kiuniġaat, “Tusaaŋiññiqsugutunniiñ Ipqitchuamik Irrutchiqaqtilaaŋanik.” ");
INSERT INTO eskNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paul-ŋum apiqsruġniġai, “Qanuqhusimi paptaaqtitpisi?” Taapkua kiuniġaat, “John-ŋum paptaaqtitchisaagun.” ");
INSERT INTO eskNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul-ŋum itnaġniġai, “John paptaaqtitchiruaq iñuŋnik mumiksuanik killuqsautmikniñ. Uqautiniġai Israel-aaġmiut ukpiqsriruksraułhat aggiqsuksrauruamik kiŋumigun, taavrumiŋa Jesus-mik.” ");
INSERT INTO eskNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tusaakamitruŋ paptaaqtitauniqsut atqagun Atanġuruam Jesus. ");
INSERT INTO eskNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Aasiiñ Paul-ŋum aksikmagich argaŋmiñik Ipqitchuam Irrutchim ukpiqtuaŋuruat aŋalatkaqsiñiġai. Uqaaqsiñiqsut uqautchikun kaŋiqsiñatlaitchuakun suli sivuniksriqipmiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Iñugiaktilaaqaġniqsut qulit malġuiyuŋnamik iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul inniqsuq tavrani piŋasuni tatqiñi isaaġaqhuni Jew-ŋuruat katraġviatnun. Uqaqatauniqsuq taluqsrautaiqhuni iñuŋni Agaayyutim aŋaayuqautaanik ukpiqsriḷiqsinniaqługich. ");
INSERT INTO eskNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Aglaan iḷaŋich taapkua pitchiġiiḷauniqsut ukpiqsriŋitḷutiŋ. Uqautigiaqsiñiġaat akiḷḷiḷiqł̣ugu agaayyutikuaġiaq katimaqatiumiknun. Taatnaqhuni Paul-ŋum uniññiġai maliktitluni ukpiqsriruanun iŋmigun. Aasiiñ uvluġaġipman iḷisautriaqsiñiqsuq Tyrannus-ŋum iḷisautriviani. ");
INSERT INTO eskNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Taamna atuummiñiġaa malġuŋni ukiuŋni. Taatnamik iluqatiŋ iñuich Jew-ŋuruatlu Jew-ŋuŋitchuatlu iñuuniaqtuat Ephesus-ŋum avataani tusaaniġaat Agaayyutim uqałha. ");
INSERT INTO eskNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Agaayyun iñiqtaqaġniqsuq quviqnaqtuanik tumigiplugu Paul. ");
INSERT INTO eskNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Iñuich iŋiqsruġniġaat Paul qaitquplugich nasaġaurat atuanikmagich. Iliŋisa tikiutiniġaich atniġñaqtuanun. Iḷikamisigik nasaġaurat atniġñaqtuanun iłuaqsikkauniqsut suli irrusiqł̣uich unitḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Iḷaŋich Jew-ŋuruat iñuuniaġniqsutunniiñ irrusiqł̣uiyaipḷutiŋ iñuŋnik. Iliŋich igliġaġumaatchaŋniqsut nunaaqqipayaanun. Uuktuaġniġaat anitchiullałiksraqtiŋ irrusiqł̣uŋnik Jesus atqagun, nipliutruqługich itna, “Tiligipsi anitquplusi atqagun Jesus Paul-ŋum quliaqtuaġikkaŋagun.” ");
INSERT INTO eskNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sceva-m Jew-ŋuruat qaukłiat agaayuliqsiŋisa tallimat malġuŋnik iġñiġutai uuktuaqpaalukmiñiqsuttuuq taatnatun. ");
INSERT INTO eskNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Aglaan taapkua irrusiqł̣uich nipliutiniġai, “Jesus iḷisimagikput suli Paul iḷisimapmipḷugu. Aglaan ilipsi—kisuuvisi?” ");
INSERT INTO eskNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Taatnaguuq nipliutiqqaaqługich iñuum irrusiqł̣ulgum mitchiqiniġai piyukługich. Tatamnaqsiḷḷapiaqługu akiiḷiñiġai. Taapkuaguuq taatnasiġaġniaqtuat pikiaġniqsut tupiġmiñ atniaqtat suli atnuġaigutrat. ");
INSERT INTO eskNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Iluqaġmiŋ Jew-ŋuruatlu Jew-ŋuŋitchuatlu Ephesus-mi tusaakamitruŋ tamanna atuumaruaq iqsitchaŋniqsut. Taluqsriḷiġñiqsut atanġuruam Jesus atqanik. ");
INSERT INTO eskNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iñugiaktuat ukpiqtuaġuqtuat uqaġiaqsiñiġaat sagviqł̣ugu iñuŋnun iñuuniaġaluałiqtiŋ aŋatkukun. ");
INSERT INTO eskNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Suli iñugiaktuat iḷisaaqaqtuat aŋatkuułiġnik katitlugich makpiġaat ikipkaġniġaich iluqaitñun qiñiġnaqsipḷugu. Kisiiqipmatigik makpiġaat akisutilaaŋat 50,000 taalaŋuniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Taatnaiḷipḷuni Agaayyutim uqałha siaminniqsuq suli iñugiaktuat iñuich iḷitchuqsripḷutiŋ saŋŋianik. ");
INSERT INTO eskNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kiŋuagun Paul Ipqitchuam Irrutchim sivulliutaagun sivunniġñiqsuq Macedonia-kuaġukhuni Greece-kunlu utlautipluni Jerusalem-mun. “Taavrumuŋaqqaaġluŋa igliqtuksraugisiruŋa Rome-mun,” itnaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Timothy-lu Erastus-lu ikayuqtiŋni tuyuġiniġik Macedonia-mun inŋaġmi Ephesus-mi uŋataaniḷu. ");
INSERT INTO eskNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Taatnałhatni tamaani Ephesus-miut akatauniqsut tamarrumuuna agaayyutikuaġiakun. ");
INSERT INTO eskNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iñuk suliuqti atiqaġniqsuq Demetrius-mik. Agaayyuviŋŋualiuġniqsuq aanġuanik atiqaqtuamik Artemis-mik maniŋmiñ qatiqtaamiñ. Taatnaasii savaaŋata maniññaktitpagaġniġai savaktit. ");
INSERT INTO eskNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Taatnaqhuni tuqłuġniġai iluqaisa savaktini piqasiquplugich atlanik piŋŋualiuqtinik aasii nipliutiplugich, “Aŋutiit, iḷisimarusi taavruma savaapta maniññaktillautaġaġigaatigut. ");
INSERT INTO eskNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ilipsi iḷitchuġigiksi qanuġli taimña Paul nipliġaġiłha aanġuat iñiqtauruat iñuktigun agaayyutauŋiññipḷugich. Uvani Ephesus-mi suli iluqaaniyuŋnak Asia-mi iñugiaktuat iñuich maliġualiġaich iḷisauttutai. ");
INSERT INTO eskNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Pakma iḷirugut navianaqtuamun savaaġikkapta piił̣iksraŋanun. Taatnałhiñauŋitchuq. Atuumaniaqpaluktuq taamavruma agaayyuvikpaum aanġuaqpauraŋan Artemis suuyumiñaił̣iksraŋa suli taavruma aanġuaqpauram piigukkaugisił̣iksraŋaptuuq, taavruma aanġuaqpauram putqataġvigikkaŋata iñupayaam Asia-mi unniiñ iluqaani nunam.” ");
INSERT INTO eskNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Taapkuaguuq iñugiaktuat tusaakamitruŋ tamanna qinnaŋniqsut aasiiñ iġiallaksaqhutiŋ, “Kamanaqtuq Artemis Ephesus-mi!” ");
INSERT INTO eskNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Akarrutauruaq siaminniqsuq iluqaanun nunaaqqimun. Taapkua akiḷḷiuruat tiguplugik Gaius-lu Aristarchus-lu, malġuk Macedonia-ġmiuk Paul-ŋum igliqatik, aullautiniġaich katimmavikpauraġmiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul-tuuġġuuq taamuŋaġukkaluaġniqsuq uqaġiaġuni katimaruanun aglaan ukpiqtuaqatiuŋiñ pitquŋiññiġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Iḷaŋisali qaukłiich iḷannaaŋiñ qanniuġniġaat qiñiqtitquŋitḷugu katimaruanun. ");
INSERT INTO eskNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Taamapkua katimaniqtutilaaġmikni uqaatchagusimaniqsut. Avvaġiiksinniqsut kaŋiqsimallapiasuŋaqnagu sumik kattutiqaqtilaaqtiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jew-ŋuruat Alexander saqinniġaat sivuġaatnun katimaruat uqaġviŋmun nipliutiksraqaqhunikii. Urriqaplugich uqaqniuraġaluaġniqsuq iñuŋnun. ");
INSERT INTO eskNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Iñuich iḷitchuġikamitruŋ Jew-ŋutilaaŋa iluqaġmiŋ iġialaniqsut malġuŋni sassaġniyuŋnaaŋni itna, “Kamanaqtuq Artemis Ephesus-mi!” ");
INSERT INTO eskNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kiisaimmatai nunaaqqim aŋalataata nipaiqsiḷġataqamigich iñugiakpauraqtuat nipliutiniġai, “Ephesus-miut! Iñupayaam iḷisimagaa Ephesus-mi piqałha agaayyuvikpauraŋanik kamanaqtuam aanġuam atriḷiaŋuruam atqaqtitlugu pakmakŋa qiḷaŋmiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tamanna kia-unniiñ piiḷaaġilguitkaa. Taatnaġusi nipaiqsuksraurusi, qanułłaktitchiñiaġuiqitchi. ");
INSERT INTO eskNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Iññuk uvuŋautiniġisi ivayaqtuiŋitkaluaqtitlugik agaayyuvikpapsitñiñ unniiñ uqaqaŋitkaluaqtitlugik akikŋaġlugu aanġuaqpauraqput. ");
INSERT INTO eskNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrius-ŋum suli savaktaiñ akikŋautiqaġumitruŋ nalliat iñuich, ittut piviksrat uqaqsittaałiġmun suli taatnatchimun nalunaiqsaqaqtugut ataniġnik. Taapkunuŋa iñuich tikiutitlagaich agvisitiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aglaantuuq piqaġniġupsi qanutchimik pigisukkapsitñik inillałhiñaupmiuq nalaullugu katimałhatni nunaaqqim iñuiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nuyuaġnallapiaqtuami ittugut itnaiḷipḷugu akataułłaptigun uglupak. Pisaŋitchuuġutiksraitḷugu iġialałiqput qaisaksraitchugut agvisiksrallautamik.” ");
INSERT INTO eskNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Taatnaqqaaqługich aġiupkaġniġaa katimałhat. ");
INSERT INTO eskNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Akataulġataanikmata iñuich Paul-ŋum katinniġai ukpiqtuat. Tavra pitchuksaaqqaaġlugich aullaġniqsuq Macedonia-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Igliłiġmiñi tamatkunani nunaaqqiñi uqautriñiqsuq ukpiqtuanik pitchuksaaġillapiaqhuni sivutmuquplugich. Aasiiñ tikiḷgitḷuni Greece-mun, ");
INSERT INTO eskNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","aasiiñ nayuutiniqsuq tavrani piŋasuni tatqiñi. Kiŋuagun utiaqsiñiqsuq Syria-mun umiakun. Iḷitchuġiniġai Jew-ŋuruat sivunniułhat piyaqquġukługu. Taatnaqhuni igliġniqsuq Macedonia-kun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopater Pyrrhus-ŋum iġñiŋa Berea-ġmiu, Aristarchus suli Secundus Thessalonica-ġmiu, Gaius Derbe-ġmiu, Timothy Lystra-ġmiu, Tychicus suli Trophimus nunaŋaniñ Asia-m tuvaaqatiginiġai. ");
INSERT INTO eskNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Aullaġniqsut sivuptikni Troas-mun aasiiñ utaqqipḷuta tavrani. ");
INSERT INTO eskNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kiŋuagun niġiqpagvikaam puvlaŋniġiḷaanik qaqqianik atuumaanikman tiksiqsugut Philippi-miñ aasii tallimat uvlut kiŋuatigun Troas-mi iḷaliqługich taipkua sivuptikni aullaqtuat. Tavraniasiiñ nayuutipluta akunniqsaami. ");
INSERT INTO eskNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sivulliuplugu uvluani akunniqsaam katirugut atautchimun nullautchiġviḷiqiniaqhuta. Atakkii aullaqhuni uvlutqikman Paul-ŋum quliaqtuaġviginiġai katimaruat unnuaqpaguġataqtitlugu. ");
INSERT INTO eskNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Iñugiaktuanik naniqaqtut qulliġmi katimmaviptikni. ");
INSERT INTO eskNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nukatpiaġġuuq atilik Eutychus-mik aquppiñiqsuq igalġum siñaani Paul uqaqtitlugu. Taamna Eutychus siñiŋnialiḷḷapiaqhuni kiisaimmatai siñiksaġniqpuq. Taavrumakŋaasii qulliġiiñiñ piŋayuakniñ init kataŋniqsuq nunamun. Iḷaiñ tikitmatruŋ tuquaniŋniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul-aasiiñ atqaqhuni qulaŋiqsiqamiuŋ iqittaaġniġaa nipliqhuni, “Isumatuyaaqasi! Iñuuruqsuli.” ");
INSERT INTO eskNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Utianikami tatpakmuŋa autaaġniqsuq qaqqiamik niġipḷutiŋaasiiñ. Aquagun Paul-ŋum uqautipsaaġniġai uvluġataqtitluguaglaan. Tavra aullaġniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iñuich taimña nukatpiaq aggisiñiġaat iñuuplugu. Aasiiñ iñupayaat quviatchallapiaġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tavraasiiñ ayupluta umiaqpaŋmun tiksiqsugut Assos-mun. Taavrumani nunaaqqimi ikisaġumaplugu Paul sivuniqaqtuaq timautchukhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Paul-ŋum iḷaliutikamisigut Assos-mi uvagut ikipkaġikput umiaqpaŋmun igliqtuiñaqhutaasiiñ Mitylene-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Taavrumakŋa tiksiḷgitchugut uvlaakuagun tikitḷugu Chios qikiqtaq. Uvlutqiḷgitman Samos-mun atlamun qikiqtamun tikitqaaqhuta, piŋayuatni uvlut kinilitchugut Miletus-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul sivuniqaġniqsuq nutqaġuŋitḷuni Ephesus-mun akuniitchuŋitḷuni Asia-mi. Tikiḷuaġuliġniqsuq Jerusalem-mun, itchukhuni taamani piyumiñaqpan uvluani Pentecost-liqikpata Jew-ŋuruat niġiqpagvikaaŋata. ");
INSERT INTO eskNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus-miñ Paul-ŋum qanniġñiġai ukpiqtuaŋuruat qaukłiŋich Ephesus-mi katimaqatigisukługich. ");
INSERT INTO eskNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Taapkua tikitmata nipliutiniġai, “Iḷisimagiksi iñuuniałiġa akunnapsitñi taivrumakŋa sivulliuplugu uvlumiñ tikitñama Asia-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Atanġuruaq Jesus savautigiga iluqnauqłuŋa. Iḷaatniḷu qulvisigun unniiñ sakiqniuġutitigun Jew-ŋuruat nagliksaaqtitkaatŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Iḷisimaplusi anniqqutitlaitkipsi supayaamik ikayuutauyumiñaqtaumik ilipsitñun uqautrił̣ł̣amni iḷisautiplusi katimmaviŋñi suli kiŋunnapsitñi. ");
INSERT INTO eskNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jew-ŋuruatlu Jew-ŋuŋitchuatlu atisipḷugich alġaqsruġitka killuqsautiŋitñiñ Agaayyutmun mumiquplugich suli Atannaptiknik Jesus-mik ukpiqsritquplugich. ");
INSERT INTO eskNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Pakma Ipqitchuam Irrutchim piyumapkaqłuŋa Jerusalem-mun aullaġniaqtuŋa iḷisimaŋitkaluaqługu qanuq irrutikkaułiksraġa taamani. ");
INSERT INTO eskNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Aglaan iḷisimatuaġiga una, iluqaŋitñi nunaaqqiñi Ipqitchuam Irrutchim kiligaġigaaŋa isiqtaugisiñipḷuŋa nagliksaaqtitaugisiñipḷuŋalu. ");
INSERT INTO eskNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Aglaan iñuułiġa pitḷuktuaŋuŋitchuq uvamni. Naatchisuktuŋa savaamnik Atanġuruam Jesus qaisaŋanik uvamnun, Ilaan uqaqupmaŋa tusaayugaallautamik Agaayyutmun iłuaqqutiginipḷugich iñuich. ");
INSERT INTO eskNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Akuni itkaluaqtuaŋaa ilipsitñi quliaqtuaġiplugu Agaayyutim uqałha ilipsitñun, aglaan pakma iḷisimagiga ilipsitñun qiñitqikkumiñaił̣iġa. ");
INSERT INTO eskNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Taatnaqługu kilikkipsi pakma, nalliqsi anniqsukkauyumiñaiññiqpan ukpiqsrił̣ikun patchisauyumiñaiqsuŋa, ");
INSERT INTO eskNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","atakkii anniqqutiŋitḷusi uqautikapsi iluqaan Agaayyutim sivunniutaanik. ");
INSERT INTO eskNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Qaunagiyumuusi ilipsitñun suli ukpiqsriruapayaanun Ipqitchuam Irrutchim qaunaksraqsrirrutigikkaŋi ilipsitñun. Munaqsriġuġusi Agaayyutim iñuiŋiñi pigiliutikkaŋiñun iġñiġmi tuqqutaułhagun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Naluŋitkiga aullaanikkuma iḷisautrit ittuat iqsiñaqtuatun amaqqutitun tikitkisił̣hat akunnapsitñun, aasii atniiḷutiŋ ukpiqtuanik. ");
INSERT INTO eskNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Suli akunnapsitñiñ iñuich sagviġisirut sagluuqtuaqtit ukpiqtuanik maliksuaqtitchiñiaġutiŋ iŋmiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Qaunakkiaġikkumuusi. Itqaġilugu uvaŋnun qulvisigun alġaqsrułiqsi piŋasuni ukiuni uvluŋitñi unnuaqtuummaisa. Taatnamik munaġitqugipsi. ");
INSERT INTO eskNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Pakma agaayyutigipsi Agaayyutmun qaunagitquplusi suli maliktuatquplusi uqauttutaanik iḷisautigikkaġma ilipsitñun. Agaayyutim sayaksraqaġaasi suli qaitchiḷusi ikayuutmik pigikkaġmiñik iluqaitñun iñugikkaġmiñun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Uvaŋa kaviuŋitchuŋa iñuum manianik naagaqaa atnuġaaŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Iḷisimagiksi argamnik savaaqałiġa piqaġniutigiplugich supayaamik tuvaaqatiumalu inuġikkaptiknik. ");
INSERT INTO eskNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tamatkunuuna iḷisautianikkipsi sakuuguni iñuum ikayuił̣iksraŋanik sayaitchuanik itqaġilugu Atanġuruam Jesus-ŋum uqauttutaa itna, ‘Quvianatluktuq aatchuiruni aatchuusiaqałiġmiñ.’” ");
INSERT INTO eskNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul-ŋum uqaaqtuutianikamigich sitquqatiginiġai iŋiqsrułiġmun. ");
INSERT INTO eskNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Qianiqsut iqitlugu Paul kunikł̣ugulu, ");
INSERT INTO eskNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","aasiiñ aliasruutigiplugu niplił̣ha qiñitqikkumiñaiññipḷuni iliŋitñun. Tuvaaqatchiġñiġaat ikityaqman umiaqpaŋmun. ");
INSERT INTO eskNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tavra avitnapta iliŋitñiñ tiksiqhuta nalġuqhuta ikaaqtugut qikiqtamun Cos-mun. Uvlutqikmanaasiiñ tikitchugut qikiqtamun Rhodes-mun tavrakŋaasiiñ tiksiḷgitḷuta Patara-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tavrani iḷitchuġigikput umiaq ikaaġniaġniqsuaq Phoenicia-mun. Taavrumuŋa ikipluta tiksiḷgitchugut. ");
INSERT INTO eskNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Qiñiqnaqsipman qikiqtaq Cyprus uŋalliñaaŋagun qikiqtam tiksiqsugut Syria-mun. Tyre-mun tulaktugut, taavrumaniasiiñ taamna umiaqpak niuriñiaqhuni usiamiñik. ");
INSERT INTO eskNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Paqitlugich iḷaŋich ukpiqtuat nayuġivut akunniqsaami. Aŋalataagun Ipqitchuam Irrutchim iñiqtiġaluaġaat Paul Jerusalem-muquŋitḷugu. ");
INSERT INTO eskNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aglaan tavrani irviksraqput nuŋitman aullalgitchugut. Iluqaġmiŋ ukpiqtuat iḷaqatituummaġmiŋ suli qitunġaqtuummaġmiŋ malikkaatigut siḷataanun Tyre-m. Tasamaniasiiñ taġium siñaani sitquqhuta iŋiqsruqtugut. ");
INSERT INTO eskNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tavra ikikapta umiaqpaŋmun iliŋiḷḷi airut. ");
INSERT INTO eskNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyre-miñ tikitchugut Ptolemais-mun. Taavrumani piqasiḷgitkivut aniqatiut nayuqługich uvlumi. ");
INSERT INTO eskNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Uvlutqikman pisuktuaqhuta tikitchugut Caesarea-mun. Taavrumani uqaqtim Philip-ŋum tupqanukapta nayuutirugut ilaani. Philip tallimat malġuġuutigikkaŋat ikayuqtiksraqtat Jerusalem-mi piksraqtaaŋuruat. ");
INSERT INTO eskNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Taamna Philip paniqaġniqsuaq sisamanik niviaqsianik uiñiŋniġiḷaanik sivuniksriqirauplutiŋtuuq. ");
INSERT INTO eskNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Inŋanikmiugullu qapsiñi uvluni sivuniksriqiri atilik Agabus-mik aggiġñiqsuq Judea-miñ. ");
INSERT INTO eskNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Aasii utlakamisigut Paul-ŋum tapsia tigukamiuŋ isigaŋni argaŋniḷu qiḷiġniġai nipliqhuni, “Taatna Ipqitchuaq Irrusiq nipliqsuq taatnatun, Jew-ŋuruat Jerusalem-mi qiḷiqsruġisiġaat marruma tapsim iñua aasii Jew-ŋuŋitchuanun qaisaġilugu.” ");
INSERT INTO eskNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Taamna tusaakaptigu uvagutlu atlatlu tavraniittuat uqapsaaġaluaġikput utlautitquŋitḷugu Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Aglaan Paul-ŋum kiugaatigut, “Suvaata qiaplusi sayaiġniaqpisitŋa? Uvaŋa itqanaigutianiksimagiga qiḷiqsrukkaułiksraq Jerusalem-mi unniiñ tuqqutaułiksraq piqusiġḷuŋa Ataniġmik Jesus-mik.” ");
INSERT INTO eskNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nutqaqtilguitñaptigu nipliutiłhiñaġikput, “Agaayyutim pitqutaa iñiqtauyumuuq!” ");
INSERT INTO eskNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ipsaaġaluaqapta paġnapluta aullaqtugut Jerusalem-mun. ");
INSERT INTO eskNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Iḷaŋisa ukpiqtuat Caesarea-miñ tuvaaqatchiġaatigut Mnason-ŋum kiŋunġanun nullaŋaviksraptiknun anaqami. Mnason-guuq Cyprus-miuŋuruaq ukpiqtuaġuniqsuaq sivulliqsigun sivuaniimma. ");
INSERT INTO eskNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalem-mun tikitñapta aniaqatiupta quyaplutiŋ paġlagaatigut. ");
INSERT INTO eskNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Uvlutqikmanaasiiñ Paul-ŋum piqasiġaatigut qiñiġiaqługu James, aasiiñ ukpiqtuaŋuruatlu qaukłiŋich nayuutiniqsut tavrani. ");
INSERT INTO eskNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul-ŋum paġliiŋanikamigich tusaayugaaqtinniġai iluqaanik Agaayyutim iñiqtaŋanik tumigiplugu savaaġikkani akunġatni Jew-ŋuŋitchuat. ");
INSERT INTO eskNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Naalaqtauŋanikamitruŋ quyaniġaat Agaayyun nipliutiplugu Paul itna, “Aniqatmaaŋ, kaŋiqsiḷḷagiñ piqałha iñugiallapiaqtuanik Jew-ŋuruanik ukpiqsriruaniktuuq aglaan iliŋich piipkaitḷutiŋ Moses-ŋum maliġutaksraŋanik. ");
INSERT INTO eskNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Iñuich uqautigigaich iḷisautriñipḷutin Jew-payaanik iñuuniaqtuanik atlat nunaaqqiŋitñi suksraaquplugich maliġutaksraq qaisauruaq Moses-kun, uqautinipḷugich nalunaitŋutchiqsuquŋitḷugich qitunġauraġikkaŋich naagaunniiñ kamagitquŋitḷugich Jew-ŋuruat ilitqusiat. ");
INSERT INTO eskNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Taipkua nalupqinaitchuamik tusaagisigaat aggił̣hiñ. Qanuġisiñiqpisami? ");
INSERT INTO eskNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Atuiruksraurutin. Piqaqtuq-samma sisamanik aŋutinik uvani akiqsruqtuanik Agaayyutmun taaŋŋaġumiñaił̣hat salipkaġumiñaił̣hatlu niaquŋich. ");
INSERT INTO eskNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Taapkunuŋa aŋutinun iḷaliutilutin Jew-ŋuruat ilitqusiatigun salummaqsaġutin suli akiḷiutilugich tuniḷḷautiksranik nuyaitḷasiḷugich. Taatnaġuvich iluqaġmiŋ iḷitchuġinayaġaat taŋiġił̣ha qanutchim tusaakkaġmiŋ ilipkun, sulipsuuq tupiksrił̣hiñ maliġutaksraŋanik Moses-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Aglaan Jew-ŋuŋitchuat ukpiqtuaġuqtuat iḷitchuġipkaanikkivut sivunniutiptiknik itna, iliŋitñun niġitquŋitkivut niqiniglu tuniḷḷautauruamik aanġuanun aukmiglu unniiñ qimisanik suli piisimaaġlugich qaayuġnaqtuałiġmiñ atlatułikun.” ");
INSERT INTO eskNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Aasiiñ Paul iḷaliutiniqsuq aŋutinun. Uvlutqikmanaasiiñ salummaqsaqatauniqsuq tuvraqługu Jew-ŋuruat ilitqusiatigun suli utlautipluni agaayyuvikpaŋmun uqautityaqługu agaayuliqsi qakuguaglaan salummaqsaqtiłiqtiŋ naanniaqtilaaŋanik. Akunniqsaaŋanikpan tuniḷḷaqsaġumaniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Tallimat malġuk uvlut nuŋitchautaatni iḷaŋisa Jew-ŋuruat Asia-ġmiuŋuruat qiñiġniġaat Paul agaayyuvikpaum iḷuani. Akatiġniġaat iñugiaktuat iñuich, aasiiñ tigguġlukługu Paul. ");
INSERT INTO eskNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Iġialaplutiŋ itna, “Israel-aaġmiut! Ikayuġitchi. Uuma iñuum iḷisautriruam iñuŋnik nanipayaaq akikŋaqługich Israel-aaġmiut suli akikŋaqługu maliġutaksraq qaisauruaq Moses-kun unniiñ akikŋautipluni uumuuna agaayyuvikpaŋmun. Pakmaunniiñ itqutrimalgitchuq Jew-ŋuŋitchuanik uvuŋa qaayuġnaqsipkaqługu ipqitchuaq ini.” ");
INSERT INTO eskNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Taatna niplianiqsut atakkii sivuani qiñiqługu Paul nunaaqqimi piqatiqałha Jew-ŋuŋitchuamik Trophimus-mik Ephesus-miumik aasiiñ itqutinasugniaqługu agaayyuvikpaum iḷuanun. Taatnaqługu tigguġluŋniġaat.) ");
INSERT INTO eskNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Taatnaqhutiŋ iluqatiŋ iñuich nunaaqqimi akatauniqsut. Iñuich atautchikun aqpaqsruqhutiŋ Paul tigguġluŋniġaat aasii kalikługu agaayyuvikpaŋmiñ. Tavrauvaa agaayyuvikpaum paaŋi umiŋniġaich. ");
INSERT INTO eskNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Taapkua aupił̣ł̣autriruat tuqułhiñaaġuqsaqmigaatlu Paul, imma kiliŋniġaat Rome-maġmiut aŋuyyiuqtiŋisa qaukłiat iñupayaat Jerusalem-mi akataunipḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Taavruma qaukłium katitiqługich aŋalatit suli aŋuyyiuqtini upaktuġniġai iñugiakpauraqtuat iñuich. Qiñiqamitruŋ qaukłiq aŋuyyiuqtituummaan anauminġiġñiġaat Paul. ");
INSERT INTO eskNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Taavruma qaukłium tikitñamiuŋ Paul tiguniġaa aasii tillisigiplugu qiḷiqsruquplugu malġuiñik kalimñiġñik. Tavraasiiñ apiqsruqtaaqsiñiġai itna, “Kiña una aŋun? Sumik savvaqłukpa?” ");
INSERT INTO eskNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tamatkua iñugiakpauraqtuat iġialaaqsiñiqsut atiŋitchuamik nipimik. Qaukłium iḷitchuġilguiññiġaa sumik agvisiqhutiŋ itnasiġałhat. Taatnaqhuni tiliñiġai aŋuyyiuqtit Paul inaatnuutitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tikiutikamitruŋ tutipqiñun aŋuyyiuqtit akiyaġaat Paul atakkii iñuich qinnaktaliqpaitḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Iñuich malgutigaluaġniqsut iġialaplutiŋ, “Tuqqutchiuŋ!” ");
INSERT INTO eskNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Aŋuyyiuqtit itqutiłhiñaaġuqmatni Paul inimiknun ilaan nipliutiniġaa qaukłiq, “Uqaqatigillakkumiñaqpigiñ?” Taavruma apiqsruġniġaa, “Uqatlavich Greek-tun? ");
INSERT INTO eskNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ivrumiŋauŋitpich Egypt-miu qaŋaqammiuraq akatchipḷuni akiḷḷiḷiqsuutmik, sivulliqł̣ugich sisamanik kavluutiyuŋnanik satkuliŋnik iñuiḷaamun?” ");
INSERT INTO eskNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul-ŋum kiuniġaa, “Jew-ŋuruŋa animapluŋa Tarsus-mi Cilicia-miittuami, iñugipluŋa taavrumani nunaaqqimi iñuich iḷisimallautakkaŋatni. Nipliqsillaŋniaŋŋa iñuŋnun!” ");
INSERT INTO eskNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tavra qaukłium uqaquniġaa. Paul-guuq tutipqiñun qikaqhuni urriqaniġai iñuich. Nipaiqmata ilaan nipliutiniġai Hebrew-tun itna, ");
INSERT INTO eskNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Aniaqatiumaaŋ suli aapaŋuruasii, naalaġniḷḷaksiuŋ uqautiksraġa patchisaił̣ł̣apkun sivuqqapsitñi!” ");
INSERT INTO eskNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Taapkuaguuq tusaagaqsikamitruŋ uqaqługu Hebrew-tun iñuksruiġñiqsut. Paul-ŋum uqautipsaaġniġai itna, ");
INSERT INTO eskNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Uvaŋa Jew-ŋuruŋa. Tarsus-mi Cilicia-miittuami animagaluaqłuŋa, uvaniasiiñ Jerusalem-mi iñuguqtuŋa. Gamaliel-mik iḷisautriqaqtuŋa. Ilaan piḷḷautaqługu iḷisautigaaŋa sivulliapta maliġutaksraŋanik. Nalaunŋasuktuaŋuruŋaptuuq Agaayyutikun iluqapsisun uvaniittuatun uvlupak. ");
INSERT INTO eskNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nagliksaaqtitkitka iñuich tuqunniaqługich ukpiqsripmata Christ-mik, aŋutiniglu aġnaniglu tigusiullakłuŋa inillaktaqługich isiqsiviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Qaukłiat agaayuliqsit suli iluqaġmiŋ sivulliuqtiġruat Jerusalem-mi nalupqinaiyaġaat uqaqtilaaġa iḷumutun. Iliŋitñiñ aglaksraqłuŋa Jew-ŋuruat katraġviatnun Damascus-miittuanun, aullalgitchuŋa tigusityaqłuŋa ukpiqtuanik Jesus-mik Jerusalem-mun utqutrityaqłuŋa kalimñiġñik qiḷiġlugich anasiñŋuqsaġviksraŋatnun. ");
INSERT INTO eskNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Uvluqpaguqtuami igliłłamni qallipḷugu Damascus taimmaiñaq qaumanġum pakmakŋa qaggutigaaŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Katakkama nunamun tusaagiga nipi uvaŋnun itnaqtuaq, ‘Saul, suvaata naŋititpiŋa?’ ");
INSERT INTO eskNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Apiqsruġiga, ‘Ataniiq, kisuuvich?’ Kiugaaŋa, ‘Uvaŋa Jesus-ŋuruŋa Nazareth-miu nagliksaaqtitaġikkan.’ ");
INSERT INTO eskNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tuvaaqatiuma qaumaniq qiñiġaluaġaat aglaan nipaa uqautrima tusaaŋitkaat. ");
INSERT INTO eskNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Apiqsruġiga, ‘Ataniiq, sutquviŋa?’ Atanġum kiugaaŋa, ‘Makillutin Damascus-mugiñ. Taamma taamani uqautiniaġaatin iluqaanik Agaayyutim sivunniutaanik ilipnun atuquplugu.’ ");
INSERT INTO eskNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Taavruma qaumaniqpauram qiñitlaiqsitiġniqmaŋa tuvaaqatiuma tasiuqłuŋa Damascus-mun tikiutigaatŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Taavrumani aŋun inniqsuaq atilik Ananias-mik agaayyutiqaqhuni tupiksriruaq maliġutaksranik kamagikkaupluniḷu Jew-ŋuruanun Damascus-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Taavruma utlaŋniġaaŋa. Qikaqami saniqqamnun nipliutigaaŋa, ‘Aniaqaan Saul, qiñitlasitqigiñ!’ Taimmaiñaq qiñitlasitqiksuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nipliutigaaŋa, ‘Sivulliapta Agaayyutaata piksraqtaaġigaatin iḷitchuġitquplugu pisułłi, qiñiquplugu Agaayyutim savaktini suli tusaatquplugu taavruma nipaa. ");
INSERT INTO eskNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Iḷisimaraugisirutin ilaagun uqautilugich iñupayaat qiñikkapnik suli tusaakkapnik. ");
INSERT INTO eskNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Pakma utaqqisuŋaqnak! Makillutin paptaaqtillutin, killuqsautitin piiqsillugich agaayuiñ atqagun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalem-mun utiqama agaayyuvikpaŋmi iŋiqsrułłamni qiñiqquuraaqtuŋa, ");
INSERT INTO eskNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Agaayyutmun uqautipkaqłuŋa itna, ‘Qilamiksruġutin Jerusalem-miñ aullaġiñ atakkii iñuich uvani akuqtuġumiñaitkaat iḷisimaraułhiñ uvapkun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kiugiga, ‘Ataniiq, iliŋisa iḷisimallapiaġaat katraġviŋñi isiqtaksraqtułiġa ukpiqsriruanik ilipnik ipiġaqtuqługich. ");
INSERT INTO eskNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Suli Stephen iḷisimarigikkan tuqqutaupman uvaŋaptuuq tavraniittuŋa iłuagiplugu tuqqutaułha unniiñ qaunaksipḷuŋa tuqqutchiruat atnuġaaŋitñik.’ ");
INSERT INTO eskNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","‘Aullaġiñ tuyuġigisigikpiñ Jew-ŋuŋitchuanun uŋasiksuanun,’ Atanġuruam nipliutigaaŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Iñuich naalaġniñiġaat Paul. Aglaan nipliutigikmagu taamna iġialaksaġniqsut nipitutilaaġmikni, “Igitchiuŋ, tuqqutchiuŋ! Ilaa iñuuruksrauŋitchuq!” ");
INSERT INTO eskNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Iliŋich iġiallaġmiŋ atnuġaamiknik isaaqtausiqhutiŋ qavia siḷamun tiŋipkaġniġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Aasii Rome-maġmiut atanġata iñugikkani tiliñiġai Paul itqutitquplugu aŋuyyiuqtit inaatnun tillisigiplugu ipiġaqtuquplugu iḷitchuġiniaġlugu suvaata Jew-ŋuruat qinnallapiaqtilaaŋatnik. ");
INSERT INTO eskNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Iliŋisa qiḷiqsruanikmatni ipiġaqtuġviksraġmiñun Paul-ŋum nipliutiniġaa aŋuyyiuqtit qaukłiat qikaqtuaq tavrani, “Ipiġaqtułhiñauvisiuŋ Rome-ŋum iñugikkaŋa apiqsruqtaġaluaqnaguunniiñ savvaġlukmaŋaan?” ");
INSERT INTO eskNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Taavruma aŋuyyiuqtit aŋalataata tusaakamiuŋ ilaan qulliqpiaq nipliutiniġaa, “Qanuq savaaqaqpich? Taamna aŋun Rome-ŋum iñuginiġaa.” ");
INSERT INTO eskNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Taatnaqhuni aŋuyyiuqtit qulliqpiaŋata Paul utlakługu apiqsruġniġaa, “Uqautiŋŋa. Rome-ŋum iñugivatin?” Paul-ŋum aŋiġniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Qulliqpiam nipliutiniġaa, “Uvaŋali tauqsiaġikkaġa Rome-maġmiuġułiksraġa maniŋmik.” “Aglaan uvaŋa animaruŋa Rome-maġmium iñugipluŋa,” Paul-ŋum itnaġniġaali. ");
INSERT INTO eskNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Taatnaqmarguuq tamatkua apiqsruqtaqtiksrautai Paul-ŋum piiqsaaġniqsut tavrauvaa. Taamnaunniiñ qulliqpiaq iqsitchaŋniqsuq kaŋiqsikamiuŋ Paul-ŋum Rome-maġmiuŋutilaaŋa suli ilaan qiḷiqsruqtinniqamiuŋ kalimñiġñik. ");
INSERT INTO eskNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Taavrumaguuq aŋuyyiuqtit qulliqpiaŋata kaŋiqsisuŋniġaa nalupqinaitḷukługu sumik piqusiqł̣ugu Jew-ŋuruanun patchisiqutiłha Paul. Taatnaqhuni uvlutqikman ilaan kalimñiġich piiqsinniġai aasii qaukłiŋisa agaayuliqsit suli iluqaisa uqaqsittaaqtitchirit tiliñiġai katitquplugich. Tavrakŋa Paul tavruŋautiniġaa aasii qikaqtitlugu sivuġaatnun. ");
INSERT INTO eskNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul-ŋum qiñiqtuaġataġniġai iriġruiñaaqługich taapkua uqaqsittaaqtitchirit aasii nipliqhuni, “Aniqatiumaaŋ! Uumuŋaaglaan uvlumun patchisaitchuakun qauġrimmaaġiutillautakun iñuuruaŋuruŋa sivuġaani Agaayyutim.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Paul taatnaqman Ananias-ŋum, qaukłiat agaayuliqsit, tiliñiġai tamatkua qikaqtuat qaniŋani Paul-ŋum patiktiquplugu qanġagun. ");
INSERT INTO eskNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paul-ŋum nipliutiniġaa, “Ilvich ukpiŋŋuaqtii! Agaayyutimtuuq nalupqinaiġḷugu patikkisipmigaatin. Ilvich aquppiruatiin tavrani atanniqsaksraġipluŋa tuvraqługu maliġutaksraq naagasuli ilvich naviksimaaġitin tilirikavich patiqupluŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Aŋutirguuq qanittuat Paul-mun nipliutiniġaat, “Agaayyutim qaukłiŋuruaq agaayuliqsaa uqamaqłuutigiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul-ŋum kiuniġai, “Aniqatiumaaŋ! Uvaŋa iḷisimaŋiññiġiga sivulliuqtaupluni agaayuliqsautilaaŋa. Atakkii Agaayyutim makpiġaaŋiñi aglausimaruq itna, ‘Ilipsi uqamaqłuutiyumiñaitkisi iñugikkapsi aŋalatiŋich.’” ");
INSERT INTO eskNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paul-ŋum iḷitchuġikamigich iḷaŋich katimaruat Sadducee-ŋuruaŋułhat suli iḷaŋich Pharisee-ŋuplutiŋ ilaan nipliutiniġai taapkua uqaqsittaaqtitchirit, “Aniqatiumaaŋ, uvaŋa Pharisee-ŋuruŋa iġñiġipluŋa Pharisee-ŋuruam. Ittitauruŋa uqaqsittaaġviŋmi uvani piqutigiplugu niġiugaqałiġa tuquruat aŋitqił̣iksraŋatigun iñuułiġmun.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Taatnaguuq Paul nipliqman tavrauvaa Pharisee-ŋuruatlu Sadducee-ŋuruatlu uqaalatraaqsiñiqsut, aasiiñ katimaruat atiŋaiqhutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Atakkii Sadducee-ŋuruatguuq uqaqhutiŋ tuquruat iñuutqikkumiñaitḷugich suli piiññipḷugu irrutchiñiglu isaġuliŋniglu. Aglaali Pharisee-ŋuruat ukpiqsripḷutiŋ iluqaitñik taapkuniŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Taatnaqhutiŋ katimaruat nipitusisaiñaġniqsut. Iḷaŋich aglaliqirit Pharisee-ŋuruaŋuplutiŋ qapiqtaiḷiḷḷapiaġniqsut itnaqhutiŋ, “Paqitchiḷguitchugut savvaqłuutaanik uuma iñuum. Isaġulgum naagaqaa irrutchim iḷumun uqautivalukkaa.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Taapkua uqavaałhat igḷutuyunaiqman taamna aŋuyyiuqtit qulliqpiaŋat isummiġñiqsuq iliŋitñun siquminnasugalugu Paul. Taatnaqhuni aŋuyyiuqtini tiliñiġai taapkunuŋa katimaruanun ivayaaġitquplugu Paul iliŋitñiñ aasii itqutilugu aŋuyyiuqtit inaatnun. ");
INSERT INTO eskNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tamarrumani unnuami Atanġuruam qikaqasiqługu Paul nipliutiniġaa, “Qapiqtaqnak! Iḷisimaraupmatun uvapkun uvani Jerusalem-mi taatnatuntuuq Rome-mi iḷisimaraugisirutin.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Uvlaaġutqikman Jew-ŋuruat katimakamiŋ sivunniuġniqsut. Nalupqinaiqsruqhutiŋ akiqsruġniqsut, “Uvagut niġiyumiñaitchugut unniiñ imiġumiñaitchugut sumik Paul tuqunŋanikkaluaqnagu.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Sippaqaqługuguuq malġukipiaq taapkua inniqsut sivunniuqtuat itna. ");
INSERT INTO eskNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Aasii utlautiplutiŋ agaayuliqsit qaukłiŋitñun suli sivulliuqtiġruatnun itnaġniqsut, “Uvagut nalupqinaiqł̣ugu akiqsruqtugut qanutchimik niġiyumiñaitḷuta Paul tuqqutkaluaqnagu. ");
INSERT INTO eskNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Taatnaġusi, ilipsi uqaqsittaaqtitchirituummapsi tuyuqaġitchi aŋuyyiuqtit qulliqpiaŋatnun Paul tavruŋautitqulugu liilaa apiqsruqtapsaaŋŋuaġukługu. Uvagut tuqqutkisipmigikput sivuani tikił̣iksraŋan uvuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Aglaarguuq Paul-ŋum uyuġuan, aġnaunġan iġñiŋa, tusaaniġaa taamna sivunniukkaŋat. Taatnaqhuni aŋuyyiuqtit inaatnun isiqhuni utlaŋniġaa Paul uqautityaqługu taavrumiŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paul-ŋumaasii tuqłuqamiuŋ aŋuyyiuqtit aŋalataat nipliutiniġaa, “Aŋuyyiuqtit qulliqpiaŋatnun taamuŋautiuŋ una nukatpiaq, piqaġniqsuq uqauttutiksraġmiñik ilaanun.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Taavruma aŋalatim taamuŋautiniġaa qulliqpiaŋatnun aŋuyyiuqtit itnaqhuni, “Paul-ŋum isiqtauruam tuqłuqłuŋa iŋiġaaŋa ilipnuutitquplugu una nukatpiaq. Sammaguuq uuma uqauttutiksraqaġaatin.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Taavruma aŋuyyiuqtit qulliqpiaŋata tasirriutipluguguuq avuŋaqtaaġutiniġaa aasiiñ apiqsruqługu, “Sumik uqauttutiksraqaqpiŋa?” ");
INSERT INTO eskNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Taavruma nukatpiam nipliutiniġaa, “Jew-ŋuruat sivunniuqtut iŋiġukhutin uvlaakun tikiutitquplugu Paul uqaqsittaaġviŋitñun apiqsruqtapsaaŋŋuaġukługu. ");
INSERT INTO eskNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Aglaan aŋiqnagich atakkii malġukipiaq iñuich sippalik iriqsimaniaqtut utaqqiruat ilaanik apqutmi. Iliŋich akiqsruqtaanikhutiŋ niġitqikkumiñaitḷutiŋ unniiñ imitqikkumiñaitḷutiŋ tuqqutkaluaqnagu ilaa. Iliŋich-amma itqanaiqhutiŋ utaqqigaat ilvich aŋił̣iksran.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Taavruma qulliqpiam nipliutiniġaa taamna nukatpiaq, “Kisumununniiñ taamna iḷitchuġipkaġniaqnagu suli tamatkuniŋa uqaqtilaan uvamnun.” Taatnaqqaaqługu taamna nukatpiaq aullaqtinniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Taamna qulliqpiaq tuqłuiñiqsuq malġuŋnik aŋalatiŋitñik aŋuyyiuqtit uqautiniġik, “Itqanaiyaġitchik malġuk kavluutik aŋuyyiuqtinik suli piŋasukipiaq qulinik tuttuqpiraqtinik suli malġuk kavluutik panaliraqtinik Caesarea-muktuksranik. Itqanaiġumagitik anaqapak aullatlasiḷugich. ");
INSERT INTO eskNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Suli itqanaiyautilugu tuttuqpaŋnik Paul-ŋum usiaqsiġviksraŋiñik tikiutriksraŋiñik aniyaŋniusuŋaqani kavanauruamun Felix-mun.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Aasii taamna qulliqpiaq aglaŋniqsuq taamuŋa itna, ");
INSERT INTO eskNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Claudius Lysias tuyuqtuq uumiŋa kavanauruamun kamanaqhuni Felix-mun, iłuaqqun! ");
INSERT INTO eskNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Una aŋun Jew-ŋuruat tiguplugu tuqułhiñaaġuġnikkaŋat aasiiñ piqasiqł̣uŋa aŋuyyiuqtimnik annautikkaqput, atakkii iḷitchuġigiga ilaa Rome-miñ kaŋiqałha. ");
INSERT INTO eskNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kaŋiqsipsaaġukługu sumik pił̣hagun patchitchiqł̣ugu uqaqsittaaqtitchiriŋitñun utlautigiga. ");
INSERT INTO eskNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Iḷitchuġiruŋa qanutchimik piŋaisilaaŋanik tuqurrutauyumiñaqtuamik unniiñ isiqtauluni. Aglaan iŋmiŋ maliġutaġmikkun patchisiqusimagaat. ");
INSERT INTO eskNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Uvaŋa kilikkaukama Jew-ŋuruanun sivunniuġutinipḷugu tuqqutchukługu piñatchiasuŋaqnagu tuyuġigiga ilipnun, tamatkuaptuuq patchisiqutrai uqautigitka tikiutitquplugich agvisiŋich akikŋaqługu ilipnun.” ");
INSERT INTO eskNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Aŋuyyiuqtit atuummiñiġaat tillisiusiaqtiŋ. Aullautiniġaat Paul tamarrumani anaqami tikiutiplugu Antipatris-munaglaan. ");
INSERT INTO eskNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Uvlutqikman tamatkua pisukhutiŋ aŋuyyiuqtit piruat utiġniqsut aglaan tuttuqpiraqtuat igliġutituiñaqługu Paul. ");
INSERT INTO eskNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tikiutikamitruŋ Caesarea-mun kavanauruamun qaiññiġaich aglaiḷḷu Paul-lu. ");
INSERT INTO eskNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Taavruma kavanam agliqianikamigich apiqsruġniġaa Paul sumiuŋupmagaan. Iḷitchuġikamiuŋ taamakŋa Cilicia-ġmiuŋułha, ");
INSERT INTO eskNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Felix-ŋum Paul uqautiniġaa, “Ilvich pasiritin tikitpata naalaġnigisiñiġikpiñ.” Aasii ilaan tillisiginiġaa Herod-ŋum atanġum inaani Paul qaunagitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kiŋuatigun tallimat uvlut Ananias, qaukłiat agaayuliqsit, piqasiqhuni iḷaŋitñik sivulliuqtiġruat suli maliġutaksraliqirimik atiliŋmik Tertullus-mik tikiññiqsut Caesarea-mun. Aasii uqaġigaat akikŋautriŋ Paul-kun taavrumuŋa kavanauruamun. ");
INSERT INTO eskNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tavruŋautianikmatruŋ Paul, Tertullus uqaġniqsuq itna, “Kamanaqtuatiin Felix! Tumigiplugu aŋalatillautaułhiñ sivisuruamik aŋuyautairrutiqaqtitkiptigut suli isumatułipkun ikayuġitin iñuvut tumigiplugich iñugiaktuat iłuaqsruutit. ");
INSERT INTO eskNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Quyyatigigikput sumiunniiñ nanipayaaq, aasii quyyatiqallapiaġiptigiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aglaan minġuqtillutin piyumagaluaqnak iŋiġikpiñ naalallaquplugu naigḷiḷugu uqaġiraksraqput. ");
INSERT INTO eskNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Una iñuk iḷitchuġikkaqput iñukłuqutauplugu, akunġatni Jew-ŋuruat iluqaani nunami aullaġniiraġaqtuaq akarrutinik suli ilaa qaukłiupluni Nazarene-ŋuruani. ");
INSERT INTO eskNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Agaayyuvikpaŋmik qaayuġnaqsiḷiuġniałha pisigiplugu uvagut tigukkaqput atanniġukługu tuvraġlugu maliġutaksraqput. ");
INSERT INTO eskNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Aglaan qaukłium aŋuyyiuqtit qulliqpiaŋata Lysias-ŋum upaktuqhuta uvaptikniñ ivayaaġigaa. ");
INSERT INTO eskNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Aasii Lysias-ŋum uqautigaatigut tikiutritquplugich patchisaatnik ilipnun. Ilvich apiqsruqtaġupku iḷitchuġinayaqmigiñ ilaaniñ iluqaan akikŋautivut ilaagun.” ");
INSERT INTO eskNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tamatkuaptuuq atlat Jew-ŋuruat tavrani tappiġñiġaat Tertullus-ŋum akikŋautaa Paul-kun itnaqhutiŋ, “Iluqani tamanna uqauttun iḷumutuuruq.” ");
INSERT INTO eskNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Taavruma kavanauruam urriqaniġaa Paul nipliquplugu. Paul nipliaqsiñiqsuq, “Iḷisimagiga iñugiaktuami ukiumi aŋalatchił̣hiñ uumiŋa nunaaqqimik. Quyagigiga patchisaiyałiksraġa sivuqqapni. ");
INSERT INTO eskNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Iḷitchuġiraksraġigiñ qulit malġuk uvlut qaaŋianikkaluaqtitnagich utlautiłiġa Jerusalem-mun Agaayyutmik kamaksrityaqłuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Jew-ŋuruat iḷitchuġiŋitkaluaġaatŋa taamavrumani agaayyuvikpaŋmi qapiqsiġiutraġluŋa iñuŋnik naagaunniiñ akatchiḷuŋa iñuŋnik katimmaviŋmikni tupiġni naagaqaa nanipayaaq nunaaqqiñi. ");
INSERT INTO eskNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Naagaunniiñ iliŋisa nalupqinaiyaġlugu piḷguitkaat akikŋautriŋ uvamnun. ");
INSERT INTO eskNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Aglaan nalupqinaiqł̣ugu uqautigikpiñ, maliktaullakkiga tamanna apqutaa nutaupluni ukpiġiraksram iliŋisa uqaġikkaŋata sagluuqtuaŋuplugu. Sivulliapta Agaayyutaat agaayumaaġvigigiga, ukpiġigitkaptuuq tuvraqługu maliġutaksraq qaisauruaq Moses-kun suli aglausimaruat makpiġaaŋitñi sivuniksriqirit. ");
INSERT INTO eskNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Niġiugaqaqmiuŋaptuuq iliŋisitun, itna, Agaayyutim iluqaisa tuquruat iñuich aŋipkaġisipḷugich, nakuuruatlu pigiitchuatlu. ");
INSERT INTO eskNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Taatnaqłuŋa ataramik qauġrimmaaġiutillautaqaġuktuŋa patchisaitḷuŋa sivuġaani Agaayyutim suli iñuich. ");
INSERT INTO eskNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Iñugiaguraqtuani ukiuni piisaallaqqaaqłuŋa Jerusalem-miñ utiqtuŋa saagaqaqłuŋa maniŋmik aatchuutinik nunaaqqiġmiuŋuqatimnun suli tuniḷḷaġiaqłuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Taamna savaaġipkaqtitlugu paqinniġaatŋa agaayyuvikpaŋmi, naatchianikama iġġuutiksraqtuġvikaanik atuqtaksraŋisigun Jew-ŋuruat. Tavrani iñugiaktuat iñuich iqatauŋitchut uvamni unniiñ qanusiq akarrun inġitchuq. ");
INSERT INTO eskNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aglaan iḷaŋich Jew-ŋuruat Asia-ġmiuŋuplutiŋ ittuat. Taipkuaptuuq uvuŋa sivuġaŋiutiruksraugaluaqtut ilipnun iḷitchuġipkaġiaġlugu akikŋautriŋ piqaġumiŋ qanutchimik uvapkun. ");
INSERT INTO eskNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ki, ukua iñuich uvaniittuat uqaġilitruŋ paqitaġikkaqtiŋ nalaunġirrutiga sivuġaŋiusimmałłamni uqaqsittaaqtitchirinun. ");
INSERT INTO eskNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Aglaan una atausiq nipliutigigiga makitałłamni sivuġaatni, ‘Ilipsi atanniġñiaqpisitŋa ugluvak piqutigilugu ukpiqsrił̣iġa tuquruat aŋitqikkisiñipḷugich.’” ");
INSERT INTO eskNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix-ŋum iḷitchuqsriruam agaayyutikuaġiamik katimałiq umikkaa itnaqhuni, “Aŋuyyiuqtit qulliqpiaŋat, Lysias, aggiqpan sivunniġisigiga taamna uqavaaġutiksi.” ");
INSERT INTO eskNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Taatnaqman Felix-ŋum tillisiginiġaa aŋuyyiuqtit qaukłiatnun Paul qaunagitquplugu aglaan tigutaaġisuŋaqnagu, aasiiñ tillisigiplugu iḷannaaŋiñun piqaqtiłhiñaaġuqługu inuġikkaŋigun. ");
INSERT INTO eskNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Qavsich uvlut qaaŋianikmiullu Felix Jew-ŋuruamik iḷaqatilik Drusilla-mik tikiññiqsuk aasii uqaqatigisukługu Paul. Taatnakii Felix tusaapsaaġuktuq ukpiqsrił̣ikun Christ Jesus-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paul uqaġaluaqman nalaunŋaruałikun, iŋmun aŋalalgusił̣iksrakun, suli atanniivium uvluagun tikitchuksrakun Felix isumallaagaqsiñiqsuq. Aasii nipliqhuni, “Aullałhiñaaġuqtutin pakma. Piviksranitqikkuma qanniġisigikpiñ.” ");
INSERT INTO eskNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Suli ilaan niġiugaġigaluaġniġaa Paul qaitchiñasugalugu maniŋmik. Taatnaqługu ilaan uqaqatigigaluaġniġaa akulaiqł̣ugu. ");
INSERT INTO eskNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aglaan malġuk ukiuk atuumaanikmaknik Porcius Festus inaŋiġñiġaa Felix kavanaułhagun. Taatnaqhuni Felix-ŋum iłuaqnaġukhuni Jew-ŋuruanun isiqtaġituiñaġniġaa Paul. ");
INSERT INTO eskNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tavra Festus taamna piŋasunik uvlianikami tavrani nunamiñi qaukłiġuqamiaglaan Caesarea-miñ Jerusalem-muŋniqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tavrani Jew-ŋuruat qaukłiŋich agaayuliqsiŋisa suli sivulliuqtiġruaŋisa tikiutiniġaich iliŋisa akikŋautigikkatiŋ Paul-kun. ");
INSERT INTO eskNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Taamna kavanauruaq Festus apiġiniġaat quyalitqulutiŋ Paul Jerusalem-muktitquplugu. Iliŋich sivunniuġaqaqhutiŋ tamaani apqutaani tuqqutchukługu. ");
INSERT INTO eskNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus-ŋum kiuniġai, “Tasamani Caesarea-mi Paul isiqsimakkauruq. Uvaŋali sivuniqaqtuŋa utitqigukłuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Qaukłiġikkasi Caesarea-muktiłhiñaugisi uvapkun akikŋaġiaġlugu tasamma iñuk savvaqłuksimakpan.” ");
INSERT INTO eskNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus taamna itkaluaqami tallimat piŋasuniḷu naagaqaa qulini uvluni. Utiġniqsuq Caesarea-mun. Uvlutqikman atanġum aquppiviani aquppipḷuni tiliriñiqsuq Paul tavruŋautitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul tikitman Jew-ŋuruat aggiqatauruat Jerusalem-miñ qikaqhutiŋ avataanun igḷulisullapiaġniġaat supayaatigun, iḷumutuutilaallapiaġlugich piḷguisaġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Aglaan Paul uqautiginiqsuq iŋmiñun itna, “Savvaġluutaitchuŋa akikŋaqługu Jew-ŋuruat maliġutaksraŋa unniiñ agaayyuvikpak naagaqaa Rome-maġmiut umialgata tillisai.” ");
INSERT INTO eskNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Taatnaqman Festus-ŋum quyaliñiaqługich Jew-ŋuruat apiqsruġniġaa Paul itna, “Jerusalem-mukkumiñaqpich atannikkautyaġutin sivuqqamni taamani tamatkunuuna akikŋausiapkun?” ");
INSERT INTO eskNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul-ŋum kiuniġaa, “Qikaġuktuŋa sivuġaani atanniivian Caesar-m, umialgum Rome-mi. Sivunniuġliŋŋa taakmani. Killuqsaġumiñaitkitka Jew-ŋuruat supayaakun, ilvittuuq taamna iḷisimapmigiñ. ");
INSERT INTO eskNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Savvaġluktauŋuluŋa piguma uvaŋnun tuqurrutiksrauyumiñaqtuamik iŋiqsruŋitchuŋa annagugluŋa anasiñŋuqsautmiñ. Aglaan tamatkua akikŋautaat akikŋaqtima taŋiġiḷaukpan, kia-unniiñ qaisaksraġiŋitkaaŋa iliŋitñun aŋalataksrauluŋa. Taatnaqługu Rome-maġmiut umialganun utlautiłiksrapkun iŋiaqaqtuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tavra Festus-ŋum uqaqatigiqqaaqługich sivunniuqtini kiuniġaa, “Rome-maġmiut umialgatnun iŋiaqaqtuatiin, taakmuŋa umialgamun aullaġisirutin.” ");
INSERT INTO eskNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Qavsich uvlut kiŋuatigun Umialik Agrippa suli Bernice tikiññiqsuk Caesarea-mun paġlatyaqługu Festus. ");
INSERT INTO eskNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Iliŋik qapsiñik uvlianikmaknik tavrani Festus-ŋum uqautiniġaa umialik Agrippa Paul-ŋum pasikkusiaŋanik itna, “Aŋun-samma uvani ittuq Felix unisaŋa isiqsiviŋmun. ");
INSERT INTO eskNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Uvaŋa utlautikama Jerusalem-mun Jew-ŋuruat qaukłiŋisa agaayuliqsit suli sivulliuqtiġruaŋisa akikŋaqługu uvaŋnun tuqqutitqukkaŋat. ");
INSERT INTO eskNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Aglaan kiugitka Rome-maġmiut taatnalguiññipḷugich, uvagut uqaqsittaaqtitlaitkikput pasikkauruaq iñuk uqapsaaġaluaqtitnagu kigiñaaġlugich taipkua pasirai. ");
INSERT INTO eskNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Taatnaqługu taipkua pasirai tikitmata uvuŋa piñatchiasuŋaqnagu uvlutqikman isivġiuġukługu tilisiruŋa taamamna aŋun sivuġaŋiutitquplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Taapkua igḷuliqsuutiruat makitnamiŋ akikŋautiksraiññiġaat savvaġluutaanik niġiugikkamnik. ");
INSERT INTO eskNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Naagatai iliŋisa uqaksraqtuutigiłhiñaaqsigaat ukpiġusiġmikkun suli iñukun tuquruakun atiqaqtuakun Jesus-mik Paul-ŋum uqaġikkaŋagun iñuuplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Uvaŋa nalupqisrukama qanuq iḷitchuġiniałiksraŋatnik tamatkua, apiqsruġiga Paul ilaa piyummatiqaġayaqmagaan Jerusalem-mułiksraŋagun tamatkunuuna uqaqsittaaġiaġuni tasamani. ");
INSERT INTO eskNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Aglaan Paul-ŋum iŋiaġikkaŋa ataniġmuutitqupluni Caesar-mun umialiŋmun Rome-mi. Taatnaqłuŋa tiligiga qaunagitquplugu tuyuġiniałhanunaglaan taakmuŋa umialiŋnun.” ");
INSERT INTO eskNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa-m nipliutiniġaa Festus, “Taamamna aŋun tusaayummiuqmiñiġiga.” “Uvlaakuġuqpan tusaagisiñiġiñ,” Festus-ŋum kiuniġaa. ");
INSERT INTO eskNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Uvlaakuagun Agrippa-lu Bernice-lu utlautiniqsuk atnuġaallauqhutik savaktituummaġmik. Isiqtut katimmaviŋmun piqasiqhutik qaukłiġñik aŋuyyiuqtinik suli nunaaqqim sivulliuqtaiñik. Festus-ŋum tillisiginiġaa Paul tavruŋautitquplugu ");
INSERT INTO eskNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","nipliqhuni, “Ataniiq Agrippaa suli iluqasi uvaniiqatauruasii! Una aŋun ittuq iluqaġmiŋ Jew-ŋuruat uvani suli Jerusalem-mi pasikkaŋat uvaŋnun niplirautigiplugu iñuuruksraunġiġñipḷugu. ");
INSERT INTO eskNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Aglaan paqitchiḷguitkiga qanutchimik tuqurrutiksraŋanik. Aasii ilaa Caesar-mun iŋiaqaqman sivunniutigiga tuyuġisukługu taakmuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aglaan nalupqinaitchuamik piitchuŋa agvisiksraŋanik Paul-ŋum umialimnun tuyuksramnik. Taatnaqługu sivuġaŋiutipkaġiga ilipsitñun, suvaluk sivuqqapnun, Umialiik Agrippaa, iḷitchuġiniurapsaaqqaaġlugu aglaaksranikkasugaluŋa qanutchimik. ");
INSERT INTO eskNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Uvamni nalaunŋaitḷuni tuyuqałiksraq isiqtamik Rome-mun nalupqinaiqł̣ugu akikŋautiksraitḷuni ittuamik.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa-m nipliutiniġaa Paul, “Ilvich uqautigiłhiñaaġuqtutin ilipkun.” Tavra Paul isakługich argaŋni aullaġniiñiġaa itna, ");
INSERT INTO eskNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Umialiik Agrippaa! Uvaŋa quviasullapiaqtuŋa uvlupak sivuqqapni uqaġviqaqtitaułłapkun tamarrumuuna iluqaġmiŋ Jew-ŋuruat akikŋautaatigun uvamnun. ");
INSERT INTO eskNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ilvich suvaluk iḷisimmaaġiksutin iluqaitñik Jew-ŋuruat ilitqusiatnik suli uqaksraqtutigisuukkaŋitñik. Taatnaqługu iŋiġikpiñ naalaġnitqupluŋa qiñuiġutin. ");
INSERT INTO eskNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Iluqaġmiŋ Jew-ŋuruat iḷisimagaat iluqaan iñuuniałiġa, atakkii nutaułłamniñaglaan iñuuniaqtuŋa iñumni nunamni suli Jerusalem-miḷu. ");
INSERT INTO eskNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Uqałhiñaaŋurut iḷisimakkaqtiŋ uqautigisugluŋa piyumiŋ. Iḷisimapmiut aullaġniił̣haniñaglaan iḷagitilaamnik Pharisee-ŋuruanun tuvraiñiapiaġaqtuat maliġutaksranik pitḷuglugu atlaniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Pakma qikaqtuŋa uvuŋa atanniqsaksraġukłuŋa piqutigiplugu niġiugaqałiġa Agaayyutmun immiumaniałhanik akiqsruutmiñik sivulliaptiknun. ");
INSERT INTO eskNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Iluqatiŋ qulit malġuich qitunġaġiich sivulliapta niġiugigaattuuq Agaayyutim akiqsruutaa agaayumaaġvigikkaqtiŋ uvluġaġipman. Umialiik, taavrumuuna niġiugaqaġnipḷuŋaptuuq patchisiqutigaatŋa Jew-ŋuruat. ");
INSERT INTO eskNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Suvaata Jew-ŋuruasi ukpiġilguitpisiuŋ Agaayyutim aŋipkaitḷałha iñuŋnik tuquŋaruaniñ? ");
INSERT INTO eskNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Uvaŋaptuuq isumaqaġaluaqtuaŋaa piyumiñaġniqtutilaaptun akikŋaqtuġukługich iñuich Jesus Nazareth-mium maliġuaqtai. ");
INSERT INTO eskNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Taatnaiḷipḷugu savaaqaqłuŋa Jerusalem-mi. Qaukłiŋitñiñ agaayuliqsiniñ akuqtuiruŋa aŋalatchirrutiksramnik Agaayyutim iñugiaktuat iñui isiqtaupkatlasipḷugich. Tuqqutaksraġuqmatigik iḷaupmiraqtuŋa qaukłiġñi. ");
INSERT INTO eskNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Iñugiaktuani anisiŋuqsaqługich Jew-ŋuruat katraġviŋitñi piiḷaaġipkaġniaqługu ukpiġikkaŋat. Uvaŋa qinnausimavaitḷugich aullaaġaqtuŋaunniiñ uŋasiksuamun nunaaqqiñun tamatkua naŋititchukługich. ");
INSERT INTO eskNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Taatnatchimik piqusiqł̣uŋa Damascus-mun aullalgitchuaŋaa aŋalatchisaigun suli tillisaigun qaukłiŋisa agaayuliqsit. ");
INSERT INTO eskNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Umialiik, igliłłamni uvluqpaguqtuami qauma siqiñiġmiñ qaumatluŋniqsuaq qiñiġiga. Puuqtiġaatigut taapkualu igliqatitka qaumanġum pakmakŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Iluqata katakapta nunamun nipi tusaagiga Hebrew-liraaqhuni uqaqtuaq uvaŋnun, ‘Saul, suvaata nagliksaaqtitpiŋa? Ilipnun atniaqsiñaqtutin akiḷḷiḷiuqapŋa atripḷugu natmaksiġvik atniaqtitaqtuaq akiḷḷiḷiqsuikami iñumi anautaŋanun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Apiqsruġiga, ‘Ataniiq, kisuuvich?’ Atanġum nipliutigaaŋa, ‘Jesus-ŋuruŋa nagliksaaqtitaġikkan. ");
INSERT INTO eskNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Makittin! Sagviutigikpiñ nalunaiġiaqługu savaktiksraqtaaŋułhiñ uvaŋnun. Uqautritqugikpiñ iñuŋnik iḷitchuġikkapnik uvapkun uglupak suli iḷitchuġipkaġumaakkamnik ilipnun aquagun. ");
INSERT INTO eskNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Uvaŋa annautigisigikpiñ Jew-ŋuruaniñ suli Jew-ŋuŋitchuaniñ tuyuġigupkiñ iliŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ilvich aŋmaqsruġisigitin irigikkaŋich mumiksillugich taaqtuamiñ qaumaruamun suli tuunġaum saŋŋianiñ taavrumuŋa Agaayyutim saŋŋianun. Tunŋaviñigutiŋ uvamnik natqigutigisigitka killuqsautiŋich aasiisuli iḷaliutiniaġlutiŋ Agaayyutim iñuŋiñun piksraqtaaġikkaŋiñun.’ ");
INSERT INTO eskNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Umialiik Agrippaa! Taatnaqłuŋa savaaqaqtuŋa tupigiplugu qiñiqtirrusiaġa pakmakŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Quliaqtuaqtuŋa sivulliuplugu Damascus-mi Jerusalem-miḷu, kiŋuagunsuli iluqaani Judea-mi akunġatniḷu Jew-ŋuŋitchuat. Uqautigitka iñupayaat mumiquplugich killuqsautiŋitñiñ Agaayyutmun aasiiñ iñuuniagaqsitquplugich simmikkauŋaruatitun. ");
INSERT INTO eskNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Taamna pisigiplugu Jew-ŋuruat tigguġlukłuŋa agaayyuvikpaŋmi tuqunniuraġaatŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Uvlupaŋnunaglaan Agaayyutim ikayuqłuŋa qikaqtitkaaŋa uqatlasipḷuŋa iluqapsitñun kamanaġniaŋitchuanunlu kamanaqtuanunlu. Tamanna uqaġikkaġa atrigigaa uqautigikkaŋata sivuniksriqirit Moses-ŋumlu atuumagisiñipḷugu ");
INSERT INTO eskNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","taamna Christ-ŋuruaq nagliksaaqtuksraunipḷugu, suli sivulliuruksraupluni aŋitqiksuaniñ tuquŋaruapayaaniñ iḷitchuġipkaġlugulu anniqsuġiaq iluqaitñun Jew-ŋuruanunlu Jew-ŋuŋitchuanunlu.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Taatnaiḷipḷugu Paul uqaqman Festus-ŋum nipitusipḷuni nipliutiniġaa, “Paul! Ilvich isumaiḷaġuqtutin. Iḷitpauraqsimałiqpich kinnaŋaaġuigaatin.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul-ŋum kiuniġaa, “Kamanaqtuatiin Festus! Uvaŋa isumaiḷaġuŋitchuŋa. Uqautiqaqtuŋa iḷumutuupluni ittuamik. ");
INSERT INTO eskNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Uqautiłhiñaugiga umialiŋmun taluqsrautaiġḷuŋa atakkii iḷisimagaa Agaayyutim uqałhagun suli anniqsuqtimigun. Nalupqigiŋitchiga iḷitchuġiłha supayaamik Jesus-kun atakkii iluqani atuumaŋitchuq iriġaqtuġuni. ");
INSERT INTO eskNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Umialiik Agrippaa! Ukpiġivigich sivuniksriqirit uqautaat? Iḷisimagiga ukpiqsrisilaan tamatkuniŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tavra Agrippa-m nipliutiniġaa Paul, “Ayyai, ukpiqtuaġuqtitqayauraġikma.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul-ŋum kiuniġaa, “Agaayyutmun iŋiqsruqtuŋa ilvich suli atlat naalaqtuat uvaŋnun uglupak maliġuaqsiutitquyumaplugich Christ-kun uvaptun, aglaan itna kalimñiqsuġayaitchut.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Taatnaanikman Paul umialiglu kavanauraġlu Bernice-lu suli atlallu makinniqsut ");
INSERT INTO eskNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","aasii anił̣hiñaqhutiŋ uqaaqsiñiqsut avatmun, “Manna aŋun piŋitchuq sumik tuqurrutiksraġmiñik unniiñ isiqsiviŋmi irrutiksraġmiñik.” ");
INSERT INTO eskNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Tavra Agrippa-m nipliutiniġaa Festus, “Tamanna aŋun pituiġayaġniqsuaq iŋiaqaŋitpan Caesar-muguguni.” ");
INSERT INTO eskNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sivunniuġutauŋanikman tiŋiḷġaqsiġviksraqput Italy-mun qaiññiġaich Paul-lu atlat isiqtatlu Julius-mun aŋalataatnun aŋuyyiuqtit taggisiqaqtuat aŋuyyiuqtaiñik Augustus-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Umiaqpaŋmun Adramyttium-mikŋaqtuamiñ ikirugut Asia-mun aullałhiñaaġuġniqsuamun. Aristarchus Macedonia-ġmiu Thessalonica-miñ piqataupmiuq uvaptikni. ");
INSERT INTO eskNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Uvlutqikman tikitchugut Sidon-mun. Julius-ŋum iłuaqqutiplugu Paul iḷannaaŋi tavrani qiñiġiaqtitkai qaitchitquplugulu inuġikkaŋiñik. ");
INSERT INTO eskNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tavrakŋa aullalgitñapta anuġim paġġaġuutigaatigut. Qikiqtam Cyprus qamanġagun tiŋilġaqsiaqsirugut. ");
INSERT INTO eskNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Siñiqsraqtuallakługik Cilicia-lu Pamphylia-lu tikitchugut Myra-mun Lycia-miittuamun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tavrani Julius paqinniqsuq umiaqpaŋmik Alexandria-miñ igliġniaġniqsuamik Italy-mun. Ilaan ikipkalgitkaatigut taavrumuŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tiksiuraaqhuta iñugiaktuani uvluni atakkii anuqłiqpaitḷuni. Arguġianniuqhuta tikiḷġataqtugut akianun nunaaqqim Cnidus. Nigiqłuum igliqtitchumiñaiqmatigut nalġuġuta tiksiaqsirugut qamanġagun qikiqtam Crete naŋaqqaaqługu nuvuġaq Salmone-mi. ");
INSERT INTO eskNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Piyaqniułikun siñiqsraqtuaqługu tikiḷġataġikput qamannillautaġvik qaniŋaniittuaq nunaaqqian Lasea-m. ");
INSERT INTO eskNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Taavrumani nunaaqqimi uvliuqtugut iñugiaktuani. Nuyuaġnaqsisigaatigut ikaaqsałiksraŋanun taġiuqpaum atakkii ukiaksraqhuni Jew-ŋuruat uvlua uisauraaġviat qaaŋianikman. Taatnaqhuni Paul-ŋum alġaqsruġniġai taapkua ");
INSERT INTO eskNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","itnaqhuni, “Aŋutiit, iḷitchuġigiga aullalgitchupta uvakŋa iglaułiqput navianaġisipḷugu. Usiavutlu umiaqpaglu unniiñ iḷaŋisa iñuich nuyuaġnaġisiruq piyaqqułiksraŋatigun.” ");
INSERT INTO eskNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Aglaan Julius naalatluŋniqsuq uqaġikkaŋanun aquttaanunlu iñuanunlu umiaqpaum nipliutaaniñ Paul-ŋum. ");
INSERT INTO eskNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Taamna qamannirvik iłuaqnaŋiññiqman umiaqpaum ukiuvigilugu pikpagu iñugiatluktuat ayakkumaniqsut tavrakŋa tikitchaġukługu Phoenix piyumiñaġumiŋ. Taamna qamannirvik Crete-mi sanmiruaq uŋallamullu nigiqpamullu, taamamna ukiuvigisukkaat. ");
INSERT INTO eskNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tavrani uŋallaaġiksiḷġataġniqman taapkua isumaniqsut sivunniukkaqtiŋ atuumasukługu. Kisat nuqinniġaich aasiiñ tiksiaqsipḷutiŋ qikiqtam siñaagautlaniqtutilaaġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Aglaan akuniisuŋaqani anuġiqłuk nigiqpaġniqsuq anuqqałłaqhuni qikiqtam tuŋaaniñ. ");
INSERT INTO eskNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Anuġim akikŋaqmagu umiaqpak paalguiġñiġaat anuġi sivuniġikkaġmiñun aasii nikaliqhuta tiktaurugut. ");
INSERT INTO eskNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Apqusautilgitñapta mikiruurami qikiqtami Cauda-mik atiligaami qamanniłaurallaktugut. Aasii sakuugutiqaqhuta ikiniaġikput umiayauraq. ");
INSERT INTO eskNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Taamna umiayauraq ikianilġiñaqman taapkua iñuich akłunaanik nimiqsruaqsigaat umiaqpak. Nuyuaqhutiŋ ikkalġił̣iksraġmiknun Syrtis-mi tiŋiḷġautaiġñiqsut tiktaułiġmikni. ");
INSERT INTO eskNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Aŋniqpauraq qasullaŋitchuq. Uvlaakuġuqman umiaqpak usiiqsaaġaat. ");
INSERT INTO eskNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Uvlut piŋayuatniasii umiaqpaum suqutnai igitkaqsigaich. ");
INSERT INTO eskNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Uvluni iñugiaktuani siqiñiq naagaqaa uvluġiat qiñiŋitchivut aasii aŋniqpauraq qasullaŋitḷuni. Tavrakŋaasiiñ niġiugaġiŋaiġikput annałiksraqput. ");
INSERT INTO eskNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Uvvaasiiñ akuni taapkua iñuich niġiŋitmata Paul-ŋum qikaqhuni aŋutit sivuġaatnun nipliutigai, “Aŋutiit, naalaġnigupsitŋa ayasuŋaqasi Crete-miñ tamanna atuumanayaitchuqsuli, usiavutunniiñ iginnayaitkivut. ");
INSERT INTO eskNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Aglaan pakma iŋiġipsigiñ, qapiqasi! Nallipsiunniiñ tammaiyumiñaitkaa iñuułłi, umiaqpak kisimi piyaqquġisiruq. ");
INSERT INTO eskNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Atakkii marrumani unnuami makitaniqsuq saniqqamni isaġulga Agaayyutim ukpiġikkaġma agaayumaaġvigisuukkaġmalu, ");
INSERT INTO eskNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nipliutipluŋa, ‘Paul, iqsiñak! Tikitchuksraurutin Caesar-mun Rome-mi. Piqutigilutin Agaayyutim annautigisigai iñupayaat usiaqsiqsuat uumani umiaqpaŋmi.’ ");
INSERT INTO eskNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Taatnaġusi aŋutiit, nikaliqasi! Ukpiġigiga Agaayyun taatnallapiaġisił̣ha uqaġikkaŋatun uvamnun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Aglaan qikiqtat iḷaŋatnun tipiniaġaatigut.” ");
INSERT INTO eskNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Akimiaġuutaiḷaġutaatigun unnuat tiŋitaułłaptikni anuġimiñ Mediterranean taġiuŋani, unnuaq qitiqquqman tiŋilġausiqirit iḷimatchaktut qalliaqsipḷuta nunamun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Taatnaqhutiŋ kivitchiñiqsut ititilaaġutmik aasii iḷitchuġiniġaat imġum ikkagliłha iñuiññaqtun isaŋniqtun. Igliqtaaqtuallakhuta uuktualgitmatruŋ iḷitchuġiniġaat akimiaq isaŋniqtun ititilaanikhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Iliŋich aniyatchaŋniqsut umiaqpak ikkalġiññasugalugu iyaġaŋnun. Taatnaqhutiŋ niŋitchiñiqsut sisamanik kitchanik umiaqpaum aquagun aasiiñ uvluqsiaqsipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tiŋilġausiqirit qimakkumaatchaŋniqsut umiaqpaŋmiñ. Nipliŋŋuaqhutiŋ iłuaqsruityaqtuqhutiŋ kitchanik sivuani umiaqpaum aasiiñ niŋitchipḷutiŋ umiayauramik imiġmun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Aglaan Paul-ŋum nipliutiniġai aŋuyyiuqtit aŋalataatlu itna, “Ukua tiŋilġausiqirit inġitpata ikimatuiñaġutiŋ umiaqpaŋmi ilipsi annakkumiñaitchusi.” ");
INSERT INTO eskNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Taatnaqhutiŋ taapkua aŋuyyiuqtit kipputiniġaat umiayauraq aasii tiŋititlugu. ");
INSERT INTO eskNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Uvluq qauŋuraagaqsipman Paul-ŋum niġitquaqsiñiġai, “Akimiaġuutaiḷami uvlumi utaqqirusi anuġaił̣iksraŋanik niġigaluaqasi sumik. ");
INSERT INTO eskNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Uvlupak niġiḷḷaqupiaġipsi. Niġiruksraurusi iñuusugusi pigupsi. Suli nalupqinaiqsruutigipsi annakkisił̣iksrapsigun.” ");
INSERT INTO eskNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Taatnaqqaaqługich Paul tigusipḷuni qaqqiamik sivulliuplugu iŋiqsruqhuni Agaayyutmun sivuġaatni taapkua avguqługu taamna qaqqiaq niġiaqsiñiqsuq. ");
INSERT INTO eskNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Taapkua iluqaġmiŋ piyumatchakhutiŋ niġiaqsipmiñiqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Iluqaġmiŋ iñugiaktilaaŋat tavrani umiam usiaŋi 276 inniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Iliŋich niġisuiġataanikamiŋ umiaqpak usiiqsaagaqsiñiġaat igitlugu mukkaaksraq taġiumun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Uvluq qaupman tiŋilġausiqirit iḷisaġitḷaiññiġaat nunam siñaa. Aglaan qamannirviksramik tautuŋniqsut. Iliŋich sivunniġñiqsut taiñuŋa siñiqłisitchaġukługu umiaqpak piyumiñaġumitruŋ ikkalġisillugu nunamun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Taatnaqhutiŋ kitchat akłunaaŋich kipluġniġaich tasamuŋa unikługich kitchat taġiumun suli akłunaaŋik aquutmiŋ qiḷġutaiqł̣ugik. Kiŋuagun sivuġutriŋ tiŋilġautaq nuqitlugu anuġimun tiŋitquplugu umiaqpak sivukkiqsinniġaat nunamun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Aglaan umiaqpak ikkalġiññiqsuq. Sivua aulayakkumiñaiqsipiaqhuni aasiiñ aqua piiyaqtaaqsiñiġaa qaim tutqataġvigiplugu. ");
INSERT INTO eskNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Aŋuyyiuqtit tuqqutchuaqsiḷgiññiġaich isiqtapayaat nalliat-samna puuvraġuni nunamun aullaunasugalugich. ");
INSERT INTO eskNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Aglaan Julius-ŋum anniġiplugu Paul taatnasiġaquŋiññiġai. Tilił̣hiñaġniġai iñuich puuvratlaruat misigaġlugich tulaktiqataquplugich nunamun. ");
INSERT INTO eskNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Unniiñ puktaġusiqsuġlugich umiaqpaviñiġmik nunniaquplugich. Tavra iluqata annaktugut nunamun. ");
INSERT INTO eskNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Annaanigataqapta iḷitchuġigikput taamna qikiqtaq atiqałha Malta-mik. ");
INSERT INTO eskNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Malta-ġmiut iłuaqqutiaqsigaatigut tukkuġiksitluta. Uvvaasiiñ sialuguqhuni alappaaġuqman taapkua ikniqsuutigaatigut quyalipḷuta. ");
INSERT INTO eskNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul qirriqsuisaqmiuġlu ikniġmun. Nimiġiaq sagviġñiqsuq, uunaŋan ikniġum iqiiqsitlugu aasiiñ argaiñun nipitiqhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Taapkua qikiqtam iñuiñ qiñiqamitruŋ nimiġiaq niviŋaruaq Paul-ŋum argaiñi uqaaqsiñiqsut avatmun itna, “Una aŋun iḷumun iñuaqtuqtauniqsuq. Annakkaluaqhuni taġiumiñ pakmapak tuquruksrauniqsuq savvaqłuutmigun.” ");
INSERT INTO eskNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Aglaan Paul-ŋum ipsuktiġniġaa taamna nimiġiaq ikniġmun piyaqqusiallasuŋaqani. ");
INSERT INTO eskNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Taapkua qikiqtaġmiut niġiugiaqsiñiġaat puviłiksraŋa naagaqaa tavrauvaa tuquliłiksraŋa Paul-ŋum. Takiruami qiñiŋitñamiŋ sumik atlayuaġnaqtuamik Paul-mi isummiġitqiŋñiqsut itnaqhutiŋ, “Ilaa agaayyutauvaluŋniqsuq.” ");
INSERT INTO eskNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Qaniŋani tulagvipta qikiqtam qaukłiġikkaŋa atilik Publius-mik nunautiqaġniqsuq. Taavruma iñuum iłuaqqutipluta tukkuqaqtitkaatigut piŋasuni uvluni. ");
INSERT INTO eskNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius-ŋum aapaŋa atniġñaqniqsuq uunaqłukhuni suli itiktaliqhuni auvyuliŋmik. Paul-ŋum utlaŋniġaa qiñiġiaqługu aasii agaayupluni patikługu argaŋmiñik mamititlugu. ");
INSERT INTO eskNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Paul mamititchipman taavrumiŋa qikiqtam iñuiñ tavruŋautiaqsiñiġaich atniġñaqtuapayaaŋi aasiiñ Paul-ŋum iłuaqsipkaqługich iluqaitñik. ");
INSERT INTO eskNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Iñugiaktuanik aatchuutinik qaitchigaatigut suli aullałhiñaaġuqapta umiaqpak usiḷḷiġñiġaat inuġikkaptiknik iglaugupta. ");
INSERT INTO eskNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Piŋasuni tatqiñi tavrani itqaaqhuta aullalgitchugut umiaqpakun atiqaġniqsuakun Malġiŋñik Agaayyutiŋŋuanik. Taamna umiaqpak Alexandria-ġmiutaq ukiuniqsuaq taavrumani qikiqtami. ");
INSERT INTO eskNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Aullaanikapta tikitchugut nunaaqqianun Syracuse-ŋum tavraniasiiñ nayuutipluta piŋasuni uvluni. ");
INSERT INTO eskNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Aullalgitñapta tikitchugut nunaaqqianun Rhegium-ŋum. Uvlutqikman uŋallamiñ anuqłiġuġniqsuq. Tikitkikput malġuŋni uvluni nunaaqqia Puteoli-m. ");
INSERT INTO eskNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Taavrumani nunaaqqimi paqitchirugut iḷaŋitñik ukpiqtuanik aasii aiyugaaġaatigut nayuquplutiŋ akunniqsaami, aasiiñ tavrakŋa aullalgitḷuta Rome-mun nunakun. ");
INSERT INTO eskNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Taamapkua ukpiqtuat Rome-mi tusaaniqsut tikiññipḷuta. Aullaġniqsut paaġiaqhuta nunaaqqimun atiqaqtuamun Nullaġvianik Appius-ŋum aasii iḷaŋisasuli nunaaqqimun atiqaqtuamun Piŋasunik Tukkumaviŋñik. Paul-ŋum qiñiqamigich taapkua ukpiqtuat Agaayyun quyagaa qapiŋaipsaaqhuni. ");
INSERT INTO eskNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tikitñapta Rome-mun iniqaqtitkaat iŋmigun aŋuyyiuqtimik munaqsriḷiqługu. ");
INSERT INTO eskNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Aquagun piŋasut uvlut Paul-ŋum Jew-ŋuruat qaukłiŋisa tavrani aiyugaaġniġai katimaqatigisukługich. Iliŋich katianikmata nipliutiniġai, “Aniqatiumaaŋ, uvaŋa piŋitkaluaqtitluŋa qanutchimik akikŋaġlugich iñugikkavut naagaqaa maliġuaqtaksraŋat sivulliapta qaisauruaq uvaptiknun tigurauruŋa Jerusalem-mi Rome-ŋum kavanaŋanun qaisaupluŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rome-maġmiut kavanaŋata Felix-ŋum apiqsruqtaġaluaġaatŋa, anipkaġluŋa piḷitchukłuŋa iḷitchuġiŋitñamitruŋ sumik tuqurrutiksramnik. ");
INSERT INTO eskNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Aglaan Jew-ŋuruat akiḷḷiḷiutipmata anipkaquŋitḷuŋa, nunuripḷuŋa naŋaġviiqama iŋiaġigiga Caesar-mun atanniqupluŋa, piitkaluaqłuŋa qanutchimik akikŋautiksramnik iḷagikkamnun. ");
INSERT INTO eskNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Taatnaqłuŋa iŋiaġigiga qiñiġukhusi uqaqatigisukhusi, atakkii ukpiġigiga niġiugaġikkaŋat taimña Israel-aaġmiut Christ tikiumaaniłha aasii taamna pisigiplugu pituutaqaqtuŋa.” ");
INSERT INTO eskNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Taapkua Jew-ŋuruat kiuniġaat, “Akuqtuiŋitchugutsuli aglaŋnik ilipkun Judea-miñ unniiñ aniqatiuvut tikiutriŋitchut tusaayugaaġiitchuanik ilipkun taamakŋa. ");
INSERT INTO eskNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aglaan isummatitin tusaayumagivut. Iḷisimagikput nanipayaaq iñuich akikŋautiqałhat tamatkuniŋa ukpiqsripḷutiŋ iliptun tikiumaaniłhanik Anniqsuqtim.” ");
INSERT INTO eskNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tavrani nalunaiqsiñiqsut kattutitqił̣iksraŋanik Paul-ŋum, aasiiñ taimña uvluq tikiumapman iñugiaktuat utlautiniqsut Paul-ŋum inaanun. Uvlaaŋaniñ unnugataqtitlugu ilaan kaŋiqsipkaġniġai Agaayyutim aŋaayuqautaanik. Ilaan maliksuktinniaġniġai Jesus-mik itqaaqtuutiplugich iluqatik maliġutaksraŋa Moses-ŋum suli sivuniksriqirit aglaaŋitñik. ");
INSERT INTO eskNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Taatnałhani iḷaŋich iñuich ukpiqsriḷiġñiqsut uqaġikkaŋigun, iḷaŋiḷḷi iñuich arguaqtuġniqsut. ");
INSERT INTO eskNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Taapkua katimaruat qasuġniqsut atinġiqhutiŋ iŋmiknun Paul-ŋum uqaġianikmauŋ una, “Ipqitchuaq Irrusiq nalaunniqsuq uqaqami sivulliapsitñun sivuniksriqirikun Isaiah-kun itna, ");
INSERT INTO eskNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Aullaġutin uqautityakkich taamapkua iñuich: Tusaagaluaġupsi kaŋiqsiyumiñaitchusi suli qiñiġumaaġaluaġupsi iḷitchuqsriyumiñaitchusi. ");
INSERT INTO eskNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Atakkii makua iñuich uummatiŋich pitchiġiiḷiġñiqsut, tusaasunġitḷutiŋ supayaamik iritiŋlu siquplugich. Utitqiñġitchut Agaayyutmun mamitiłiksraġmiknun atakkii qiñitlaitḷutiŋlu tusaatlaitŋutiŋlu kaŋiqsitḷaitḷutiŋlu, Agaayyun uqaqtuq.’” ");
INSERT INTO eskNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Suli Paul-ŋum uqapsaaġniġai, “Iḷitchuġiraksraġigiksi Agaayyutim tusaayugaallautaŋa tuyuułha Jew-ŋuŋitchuanun. Taipkuataimma tusaagisigaat.” ");
INSERT INTO eskNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paul taatnaqman Jew-ŋuruat aniñiqsut uqavaaqhutiŋ iŋmiknun atqunaq. ");
INSERT INTO eskNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul iñuuniaġniqsuq tavrani Rome-mi malġuŋni ukiuŋni, iniqaqhuni iŋmigun inilġusiqsuqługu, paġlaplugich iluqaisa qiñiġiaqtaqtini. ");
INSERT INTO eskNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Quliaqtuaġviginiġai Agaayyutim aŋaayuqautaagun suli Atanġuruakun Jesus-kun, iḷisautiplugich taluqsrautaiqhuni uqaqsaiḷiraqtaitḷuniḷu. ");
INSERT INTO eskNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul-miñ savaktaaniñ Christ Jesus-ŋum. Agaayyutim piksraqtaaġigaaŋa quliaqtuaġitquplugu tusraayugaallautaq ");
INSERT INTO eskNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","akiqsruutigikkaŋa iŋiḷġaan sivuniksriqirimigun. Taamna akiqsruun aglausimaruq ipqitchuani makpiġaaŋani. ");
INSERT INTO eskNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tusraayugaallautaq uqaqtuq Agaayyutim iġñiŋagun, Jesus Christ-kun atannaptigun. Piqutigiplugu iñukmiqnisaułha aniruq kiñuviaġiplugu David-ŋum, ");
INSERT INTO eskNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","aasiiñ piqutigiplugu agaayyutmiqnisaułhalu. Agaayyutim aŋipkaqmagu ilaan tuqułhaniñ uqautiniġai iñupayaat nalupqinaił̣ikun Jesus Iġñiġiñipḷugu suli qaitchiñipḷugu saŋŋiñi ilaanun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Uumuuna Christ-kun Agaayyutim iłuaqqutigaaŋa piksraqtaaġipluŋa uqqiraqtautqupluŋa sivulliquplugich iñuich iluqaani nunami ukpiqsrił̣iksraŋatnun suli tupiksrił̣iksraŋatnun. Taamna savaaġigiga Christ-mun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ilipsi ittuani Rome-mi tuqłukkaupmiusri pigitquplusri Jesus Christ-mun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Aglaktuŋa uumiŋa tuyuqsriugamik iluqapsitñun Rome-mi ittuanun. Agaayyutim piqpagiplusri tuqłukkaġigaasri ipqiḷḷusri iñugisrukhusri. Agaayyutimtuq Aapapta suli atannapta Jesus Christ qiñiqtillaŋniaġlisi iłuaqqutrił̣iġmiñik suli qaitchiḷusri qiñuiññamik. ");
INSERT INTO eskNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Sivulliuplugu quyyatigigiga Agaayyutiga Jesus Christ-kun pisigiplusri. Iñuich nanipayaaq nunami uqaġigaat kamanaqtuaq ukpiqsrił̣iqsi. Taatnaqługu quyagiga Agaayyun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Agaayyun savautigiga iluqaaniñ uummatimniñ uqautigikapku tusraayugaallautaq iġñiŋagun. Agaayyun iḷisimaruq taiyułiġa ilipsitñik agaayupayaaqama. ");
INSERT INTO eskNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Agaayuruŋa tikiḷḷaŋniaġukłuŋa ilipsitñun. Atuummigisiruq Agaayyutim pitqukpaŋa. ");
INSERT INTO eskNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Qiñiġullapiaġipsi qaitchisukhusri irrutchim aatchuutaanik saŋŋiksritquplusri. ");
INSERT INTO eskNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Itnaami, ikayuutiruksraurugut avatmun ukpiqsrił̣ikun pigikkaptigun. Ukpiqsrił̣ł̣apsi ikayuġisigaaŋa suli ukpiqsrił̣iġma ikayuġisipmigaasri. ");
INSERT INTO eskNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Aniqatiumaaŋ, iḷisimatqugipsi uumiŋa. Iñugiaktuami aggiġumagaluaġaqtuŋa ilipsitñun quliaqtuaġukłuŋa, qiñitlasiḷuŋa ukpiqsriruanik sayyiqsilaaqtuanik suli killiqirauruanik annautrauruanik atriḷugu suraġałiġa atlani nunani, aglaan piñġitchaqtuŋa. ");
INSERT INTO eskNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Savautiraksraġigitka iluqaisa iñuich, iḷisimaruatlu naluruatlu, puqiksuatlu puqiitchuatlu. ");
INSERT INTO eskNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Taatnaqłuŋa quliaqtuaġisrullapiaġiga tusraayugaallautaq ilipsitñun ittuanun Rome-mi. ");
INSERT INTO eskNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nalupqisruutiginġiḷḷapiaġiga tusraayugaallautaq atakkii saŋŋigigaa Agaayyutim. Taavrumuuna saŋŋikun ilaan anniqsuġaa kisupayaaq ukpiqsriruaq Christ-mik, sivulliuplugich Jew-ŋuruat sulipsuuq Jew-ŋunġitchuat. ");
INSERT INTO eskNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Taavruma tusraayugaallautam sagviġñiġaa Agaayyutim nalaunŋasripchaił̣ha iñuŋnik iŋmiñi. Agaayyutim nalaunŋasripchaił̣ha iñuŋnik aullaġniiruq suli isrukłitchaaqhuni ukpiqsrił̣ikun, aglausimaruatun Agaayyutim makpiġaaŋiñi, “Iñuk nalaunŋasripkakkauruaq ukpiqsrił̣iġmigun iñuugisiruq.” ");
INSERT INTO eskNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Agaayyutim sagviġñiġaa qiḷaŋmiñ qanuq ilaan anasriñŋuqsaiñiałha iluqaanik pigiitchuanik suli nalaunŋaitchuanik iñuich atukkaŋatnik. Iriġaat iḷumutuuruaq pigiiḷiqiłiġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Tamanna iḷisimanaqtuaq Agaayyutikun nalunaitkaluaqtuq iñuŋnun takku Agaayyutim iḷitchuġipkaġniġaa iliŋitñun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Taimakŋaqaŋa Agaayyutim iñiġaluaqtitnagich supayaat iñuich kaŋiqsiḷgugaat Agaayyutim agaayyutaułha suli qiñitlaplugu saŋŋiqaqtilaaŋa kamanaqtuamik isruiḷaamik. Taatnaqhutiŋ iñuich patchisiksraitchut. ");
INSERT INTO eskNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Iḷisimagaluaqługu Agaayyun kamaginġitchaat unniiñ quyanġitchaat. Isrumałhat atuġumiñaiqsuq suli isrumaŋich kaŋiqsitḷaiqhutiŋ taaqsisiniġai. ");
INSERT INTO eskNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Uqavigaaqhutiŋ isrumatunipḷutiŋ isrumatunġipiaqtut. ");
INSERT INTO eskNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Suksraaġaat kamanałha Agaayyutim tuquyumiñaitchuam, aasriiñ simmiḷiutigaat taamna kamanałiq putqataqhutiŋ atriñun qiññaliŋnun tuquyumiñaqtuatun iñuktun tiŋmiuratunlu niġrutitunlu nimiġiatunlu. ");
INSERT INTO eskNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Taamna pisigiplugu, Agaayyutim pilitkai iñuich killiqisułhatnun. Iliŋich killuqsaqtaurut malikługich pigiitchuat kipiġniuġutitiŋ aasriiñ atugaġiplugich timigikkatiŋ kanŋunaqtuakun avatmun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Simmiḷiutigaat Agaayyutim iḷumutuułha sagluuqtuamun suli putqataġvigiplugich savautiplugiḷḷu sut iñuich iñiqtaŋich. Aglaan putqataġviginġiġaat savautilugu Agaayyun iñiqsiruaq supayaanik, taamna Agaayyun quyagiraksraġaluaqtiŋ qaŋavak. Taatnatuq. ");
INSERT INTO eskNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Taatnaqługich Agaayyutim iñuich pilitkai kanŋunaqtuakun kimmutaatnun. Aġnat simmiḷiutiplugu iḷaqatigiił̣iq sayuŋałiġmun atugaġiplugich timitiŋ atlanun aġnanun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Taatnatun aŋutit nutqautiplugu iḷaqatiqałiq aġnamik aglaan piqaġuŋniqsut atlanik aŋutinik. Aŋutit kanŋunaqtuakun sayuŋaqatiniktut atlanik aŋutinik, aasriiñ timigikkaġmiktigun akuqtuipmiñiqsut nalaullugu anasriñŋuqsautmik tamarrumuuna nalaunŋaitchuakun savaaġmiktigun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Iñuich pigisrunġiqmatruŋ iḷumutun iḷitchuqsrił̣iksraq Agaayyutmik, Agaayyutim pilitkai qaayuġnaqtuamun isrummatmun. Taatnaqhutiŋ pigiiḷiqisruktut atuqtaksraġinġisaġmiknik. ");
INSERT INTO eskNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Imaukkaqsiñiqsut qanusripayaamik nalaunŋaitchuamik, pigiiḷiqiłiġmiglu, kaviuġutiłiġmiglu suli uumiksrił̣iġmiglu, piqaġułiġmiglu, iñuaqtułiġmiglu, aŋuyałiġmiglu, sagluuqtuałiġmiglu, suli isrummatinikhutiŋ pigiitchuakun avatmun. ");
INSERT INTO eskNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Saŋurrutiniqsut nipliaplutiŋ pigiitchuanik atlatigun, uumigiliutiplugu Agaayyun, arguaŋaplutiŋ, kamanaġasrugiplutiŋ suli uqavikhutiŋ iŋmiktigun, pakikhutiŋ savaaqałiksraġmiktigun pigiitchuamik, tupiksriñġiqhutiŋ aŋayuqaamiknik, ");
INSERT INTO eskNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","kaŋiqsiḷguitḷutiŋ, tuniqsimatlaitḷutiŋ, iłuaqqutriñġiqhutiŋ unniiñ nagliksriñġiqhutiŋ atlanik iñuŋnik. ");
INSERT INTO eskNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Agaayyutim nipliutiginiġaa taatnatchich iñuich tuquruksraunipḷugich. Iñuich taamna iḷisimagaluaġaat aglaan sivutmuutiniġaat pigiiḷiqiłiq, sulipsuuq aŋiġniqsut nalaunnipḷugich tamatkua pigiiḷiqiruat taatnatchisigun. ");
INSERT INTO eskNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Tavrali ilvich, kisuugaluaġuvich, patchisiksraitchutin, atanniqsuqtauruatiin. Taatnamik atanniqsuqapkich atlat iñuich tuqqutaksraġuqtutin ilipnik, takku killiqipmiutin taipkunatitun. ");
INSERT INTO eskNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Agaayyutim atanniġñiaġai iluqaŋich killiqiruat, aasriiñ iḷisimagikput Agaayyutim atanniutaan nalaunŋałha. ");
INSERT INTO eskNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Patchisigiraġigisri killuliqiruat savaaqaġaluaŋŋapsi nalaunŋaitchuamik. Isrumavisi annakkisiñipḷusri atanniutaaniñ Agaayyutim? ");
INSERT INTO eskNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Agaayyutim iłuaqqutikkaŋasri suli anuqsrutiplusri, ilaan taqqigaluaġaasri simmiquplugu iñuuniałiqsi aglaan suksraġinġitchiksi uuktuġnaġumiñaitchuaq iłuaqqutrił̣ha. Kaŋiqsiñġitpalukkiksi, Agaayyutim iłuaqqutigaasri simmiquplugich uummatigikkasri suli mumiquplusri iñuuniałłapsitniñ. ");
INSERT INTO eskNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Aglaan uummatisi siqquqtut iyaġaqtun suli tiggaŋarusri mumigunġitḷusri. Taatnaqapsi anasriñŋuqsausriaksraqsi agliḷaaġiksi taivrumani uvlumi Agaayyutim sagviqpagu qinnautni suli atanniqsuġniaqpagich iñupayaat nalaunŋałiġmigun. ");
INSERT INTO eskNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Agaayyutim akiḷiġisigaa iñupayaaq savaaŋigun iñuuniałhani. ");
INSERT INTO eskNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Iḷaŋich iñuich savaaqaqtuat nakuuruanik anuqsrułikun piññaguktut kamanautaanik kamakkutmiglu suli tuquyumiñaił̣iġmik. Agaayyutim qaitchigisigai isruitchuamik iñuułiġmik. ");
INSERT INTO eskNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Aglaan atlat iñuich iŋmiguaqtut ayakługu maliġutchił̣iksraqtiŋ iḷumutuuruamik. Taatnaqamiŋ malikkaat nalaunŋaitchuaq, aasriiñ Agaayyutim anasriñŋuqsaġisigai qinnautmigun. ");
INSERT INTO eskNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ilaan sakiqniuqtitkisigai nagliksaaqtillugich pigiiḷiqiruat, Jew-ŋuŋŋaisa Jew-ŋunġiñŋaisalu. ");
INSERT INTO eskNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Aglaan Agaayyutim qaitchigisigai kamanautmiglu, kamakkutmiglu suli qiñuiññamik tamatkua savaaqaqtuat nakuuruamik, Jew-ŋuruanun sivulliulugu Jew-ŋunġitchuanunlu. ");
INSERT INTO eskNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Uvvatakku Agaayyutim atanniqsuġisigai iñuich atisriḷugich. ");
INSERT INTO eskNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Iñuich maliġutaksraqaqtuat Agaayyutim qaisaŋanik Moses-mun suli iñuich taavrumiŋa maliġutaksraqanġitchuat iluqatiŋ atirut killuqsaqamiŋ. Tamatkua maliġutaksraqanġitchuat killiqirauplutiŋ piyaqquġniaqtut. Taatnatuntuuq, tamatkua maliġutaksraqaqtuat killiqirauplutiŋ atanniqsuikkauniaqtut taavrumuuna maliġutaksrakun. ");
INSERT INTO eskNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Agaayyutim iñuich nalaunŋasripchanġanġitchai tusraakamitruŋ maliġutaksraq tupigigaluaġnagu. Agaayyutim nalaunŋasripchaġaġigai iŋmiñi kisianik tupiksripmata maliġutaksram nipliutaanik. ");
INSERT INTO eskNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Jew-ŋunġitchuat piqanġitchuat Agaayyutim maliġutaksraiñik tupigipmatruŋ tillisaa maliġutaksram nalupqinaiyaġaa maliġutaksraqałhat isrummatmikni. Taamna iḷumutuuruq maliġutaksraqanġitchaluaqhutiŋ aglausimaruamik. ");
INSERT INTO eskNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Qiñiqtitaġipmigaat kaŋiqsisilaaqtiŋ maliġutaksram tillisaanik iḷitchuġipkairuamik qauġrimmaaġiutillautaġmikni nalaunŋaruamik nalaunŋaitchuamiglu. Iḷaatni isrummataata patchitchiġaġigaich suli iḷaatni iḷisimaraqtut patchisaunġiññipḷutiŋ. ");
INSERT INTO eskNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Iluqatiŋ nalunaqtuaŋich iñuich sagvikkauniaqtut taivrumani uvlumi Agaayyutim atanniqsuaqsikpagich iñupayaat Christ Jesus-kun. Taapkua iḷagigaich tusraayugallautam quliaqtuaġikkaġma. ");
INSERT INTO eskNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Qanuġmi ilvich? Ilvich Jew-ŋuniraqtutin, tunŋaplutin maliġutaksramun Moses-ŋum aglagikkaŋa suli uqavikhutin qaninnipḷutin Agaayyutmi ");
INSERT INTO eskNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","suli iḷisimanipḷugu Agaayyutim pisułha suli iḷitchuġinipḷugu nakuuniqsrauruaq takku iḷisaqsimaplutin maliġutaksramik. ");
INSERT INTO eskNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nalupqisunġipiaqtusri sivulliqsiksraunipḷusri qiñitlaitchuani suli qaumaksraunipḷusri tamatkunani ittuani taaġmi. ");
INSERT INTO eskNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Isrumaraqtutin alġaqsrułhiñauplugich kinnaŋaruat iñuich suli iḷisautilugich tamatkua naluruat. Taatnaqhusri, piqaqapsi maliġutaksramik, isrumaraqtusri iḷisimanipḷugu supayaaq suli piqaġnipḷusri iluqaanik iḷumutuuruamik. ");
INSERT INTO eskNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Iḷisautriraqtusri atlanik iñuŋnik. Suvaatami iḷisautriñġitpisi ilipsitñik? Uqautiraġigisi atlat tigliktuqunġitḷugich. Suvaatami tigligaqpisi? ");
INSERT INTO eskNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Nipliġaqtusri atlat sayuŋatqunġitḷugich, aglaan ilipsi atugaqpisi taatnatun? Ilipsi uumiksripḷusri aanġuanik, aglaan tigligaqpisi agaayyuviŋitñiñ? ");
INSERT INTO eskNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Uqavikkaluaqtusri piqaġnipḷusri Agaayyutim maliġutaksraŋanik, aglaan kamagitlaitchiksi Agaayyun navikapsiuŋ maliġutaksraŋa. ");
INSERT INTO eskNT_vpl VALUE