﻿USE sofia;
DROP TABLE IF EXISTS sofia.esg_vpl;
CREATE TABLE esg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES esg_vpl WRITE;
INSERT INTO esg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","येसु किरिस्‍तुना पेद्‍दाल्कुना तंतुल्क इल्‍हा मंतां. येसुना एनकटा मातिर-दादाल अब्राहाम आंदुर. अब्राहामुना तंतुनाल दाविद राजाल पुटतोर, दाविदुना तंतुनाले येसु सामि वातोर. ");
INSERT INTO esg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहामुंक इसाक पुटतोर, इसाकुना मर्रि याकोब, याकोबुना मर्क यहुदल आनि ईना दादालोर-तम्मुह्‍क. ");
INSERT INTO esg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहुदाना मर्क पेरेस आनि जेराल, ईरा यावन पोरोल तामरि आंद. पेरेसुना मर्रि हेसरोन, हेसरोनुना मर्रि अराम, ");
INSERT INTO esg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","अरामुना मर्रि अमिनादाब, अमिनादाबुना मर्रि नहसोन, नहसोनिना मर्रि सलमोन, ");
INSERT INTO esg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोनुना मर्रि बोआज, बोआजुना यावन पोरोल राहोबी आंद. बोवाज आनि ओना मुत्‍तो रूतुंकु ओबेद पुटतोर. ओबेदुना मर्रि यिस्‍सल, ");
INSERT INTO esg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिस्‍साना मर्रि दाविद राजाल. दाविदना मर्रि सुलेमान, सुलेमानना यावल मोदाला उरियाना मुत्‍तो मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलेमानुंकु रहोबाम पुटतोर. रहोबामुना मर्रि अबियेल, अबियेलुंकु आस्यल पुटतोर. ");
INSERT INTO esg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आस्यना मर्रि येहोसपात, यहोसपातुना मर्रि योराम, योरामुना तंतुनाल उजियाल पुटतोर. ");
INSERT INTO esg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उजियाना मर्रि योताम आनि योतामुना मर्रि अहाज, अहाजना मर्रि हिजकियल. ");
INSERT INTO esg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकियन हेंदाल मनसे पुटतोर, मनसेना मर्रि आमोन, आमोनुना मर्रि योसियाल. ");
INSERT INTO esg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","इस्राएल लोकुल्‍कुन गुलाम कीसि बेबिलोन देसेमते ओयनेंके योसियांक येकोनियेल आनि इंका ईना तम्मुह्‍क आतुर. ");
INSERT INTO esg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबिलोन ओता पजा येकोनियंकु सलितिएल पुटतोर, सलितिएलुन मर्रि जेरुबाबेल. ");
INSERT INTO esg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जेरुबाबेलुना मर्रि अबियुद, अबियुदुना मर्रि एलकिमु, एलकिमुंकु अजिरल पुटतोर. ");
INSERT INTO esg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजिरना मर्रि सादोक, सादोकुना मर्रि याकिम, याकिमुंकु एलहुदल पुटतोर. ");
INSERT INTO esg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलहुदना मर्रि एलियाजर, एलियाजरना मर्रि मत्‍तन, मत्‍तानिंकु याकोब पुटतोर. ");
INSERT INTO esg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकोबुना मर्रि योसेप, योसेपुन मुत्‍तो मरियम. मरियम “किरिस्‍तु” इनना येसु सामिन यावल आंद. ");
INSERT INTO esg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ई परकारम अब्राहामुनगटाल दाविदुनदाका पडनालुं तंतुल्क. दाविदुनगटाल बेबिलोनते गुलाम कीसि ओयानदाका पडनालुं तंतुल्क. अल्हे बेबिलोनते यहुदिल्कुन गुलाम कीसि ओतागटाल अय्ते येसु किरिस्‍तु पुट्‍टनदाका पडनालुं तंतुल्क आतां. ");
INSERT INTO esg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","येसु किरिस्‍तुना पुटमळ इल्‍हा जर्गता. मरियमुन योसेपुंक तल्किस एर्रा बोट्‍टु कीतुर. योसेप मरियमुन इट्‍टक मुन्‍नेने पवित्र आत्माता हेंदाल मरियमुंकु पीर आता. ");
INSERT INTO esg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","मरियमुन तल्कता योसेप न्‍यायमते ताकाना मनकल मत्‍तोर. अद पीटे मत्‍ता संगति ओन्क तेळियतस्के दान अंटोरा मुन्‍ने बदनाम कियामन्‍नि इन्कुत्‍तोर. अदुनहाटीं बोर्के तेळियाकोंटा मरियमुन होळसना विचारम कीसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","गानि इल्‍हा विचारम कीसेक मनानेंके पेनदा दूता कलाते वासि, “योसेपु, दाविदुन वंसमतोना, निमे मरियमुन नीवा मुत्‍तो इंचि ओप्‍कुनालय वेरियमा. बारित्‍ते दाना पीटे मनना पिंडेम पवित्र आत्माहेंदाल आसि मंता. ");
INSERT INTO esg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","अद पेडन कनंता, ओर ओना लोकुल्‍कुन ओरा पापाल्कुनाल पिसागोटंतोर. अदुनहाटीं ओना पोरोल येसु दोस्‍सा,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","मुन्‍ने पेनदा कबुरतोर रासता पोल्‍ले निजम आयनाहाटीं आता. अद पोल्‍ले इल्‍हा मंता. ");
INSERT INTO esg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“हुळाट, मरमिं आयवा पेगिड्‍क पीर आसि, वरोर मर्रिन कनांता. ओना पोरोल इम्मानुएल दोस्सानुर.” इत्‍ते, “मनातोनि पेन मंता,” इंचि ई पोरोल्क अर्तम. ");
INSERT INTO esg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","अस्‍के निद्रताल तेदतारित्‍ते योसेप पेनदा दूता वेहता परकारम कीतोर. ओर मरियमुन ओना मुत्‍तो इंचि स्विकारम कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","अय्नागानि अद एर पूरानाल ओर दानतोनि मींडा हिल्‍लोर. ओर पेडन पोरोल येसु इंचि दोसतोर. ");
INSERT INTO esg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","येसु यहुदिया एरियाता बेतलहेम नाटे पुटतस्के अगा हेरोद इनना राजाल राज्येम कीसेक मत्‍तोर. अदे कालमते पोळ्‍द पेयसनाहेंदाल बोरो पंचांगम हूळानोर येरुसलेम सहरते वातुर. ");
INSERT INTO esg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","वासि राजांक कलियसि, “पूनें-पूने पुटता यहुदिल्कुना राजाल बगा मंतोर? पोळ्‍द पेयसनाहेके ओर पुटताप मोमोट उंदि सुक्‍कातुन हूळतोम. ओना काल्क मोळ्‍कालय मोमोट वातोम,” इंचि राजन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","इद केंजसि हेरोद राजाल आनि येरुसलेम सहरअंता वेरिय्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","अस्‍के हेरोद राजाल येरुसलेम सहरता पेद्‍दा पेर्मालोर्कुन आनि अगाटा दर्मसास्‍त्रम कराहना गुरुल्‍कुन अंटोर्कुन केय्‍सि, “किरिस्‍तु बगा पुट्‍टनद मत्‍तोर?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","अस्‍के ओर, “यहुदिया एरियाता बेतलहेम नाटेने,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","एनकटा पेनदा कबुरतोर रासताप, “ए यहुदिया एरियाता बूमिपोर्रो मंदना बेतलहेम नाटेनोरिटा, मिमेट मीवा नार, सिन्‍नादे इंचि इनकुन्‍मट. बारित्‍ते नावा इस्राएल देसेमता लोकुल्‍कुन कापाळनोर, आ राजाल मीवा नाटेनेन पुटनद मंता.” ");
INSERT INTO esg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","अस्‍के पोळ्‍द पेय्सनाहेंदाल वाता पंचांगम हूळानोर्कुन हेरोद राजाल सपुडदाका कलियसि “सुक्‍का बद वेलाक दिसता?” इंचि पूस कीसि एरपाट कीकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","पजा “मिमेट होंचि आ पुटता पेडन बेस पह्कट आनि दिसतारित्‍ते नाकु वासि वेहट, अस्‍के ननागुडा होंचि ओना काल्क मोळ्‍ककन,” इंचि वेहचि ओर्कुन बेतलहेम नार लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","पजा राजाल वेहता पोल्‍लें केंजसि आ पंचांगम हूळानोर अगटाल पेय्‍स्‍तुर. मुन्‍ने बद सुक्‍का दिस्‍सि मत्‍तानो अद सुक्‍का ओरा मुन्‍ने-मुन्‍ने होंचि आ पेडल मत्‍ता जेगा पोर्रेन आगुता. ");
INSERT INTO esg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","आ सुक्‍कातुन हूळसि ओर्कु इरगा आनंदम आता. पंचांगम हूळानोर येसु पुटतगा बेतलहेम नाटे होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ओर लोता लोप्पो होंचि आ पेडन तल्‍लुर मरियमनगा हूळतुर. आ पेडाना काल्कुनपोर्रो अरसि मोळ्‍कतुर. आयंका ओर जोरानाल बंगारम, गंदकम, ऊदु इसंटा एक्‍को दराता वस्‍तुक तेंडसि ओन्क हीतुर. ");
INSERT INTO esg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","आयंका “मल्सि हेरोदनाहेके होनमट” इंचि पेन कलाते वेहताहेंका ओर इंकुंदि हर्रि पीसि ओरा देसेम पेय्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","पंचांगम हूळानोर होत्‍तारित्‍ते, योसेपुंक उंदि पेनदा दूता कलाते दिस्‍सि, “निमे तेदा, पेडन आनि ओना तल्‍लुन पीसि इजिप्‍त देसेम पेय्सि होन. हेरोद राजाल पेडन हव्कनाहाटीं पह्कांतोर. अदुनहाटीं नना नीकु मर्रा वेहनदाका अग्गेन मन्‍नु,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","अस्‍के योसेप अदे नर्का पेडन आनि पेडाना तल्‍लुन पीकुंचि इजिप्‍त देसेम्‍कु पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","हेरोद राजाल हासोननदाका अग्गेन मत्‍तोर. “नना नावा मर्रिन इजिप्‍त देसेमताल केयतन” इंचि वेल्‍लेन वर्सां मुन्‍ने पेनदा कबुरतोराहेंदाल वेहामळ जर्गता, पोल्‍ले निजम आयगोम इंचि इदंता जर्गता. ");
INSERT INTO esg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","आ पंचांगम हूळना लोकुल्‍क ओन नाडहे कीतद एरपाट कीसि, हेरोद राजांक इरगा होंग वाता. आ पंचांगम हूळानोराहेंदाल आ पेडल पुटता वेला एर्का कीकुंचि मत्‍ताहेंका बेतलहेम आनि पकापीसि मत्‍ता नाटेने मनना रोंडु वर्सानोर, इंका रोंडु वर्सांकन्‍ना सिन्‍नोर्क अंटोर मांड्‍सा पिलाल्कुन हव्कट इंचि हेरोद राजाल आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ई परकारम यिर्मयाह इनना एनकटा पेनदा कबुरतोर वेहता पेनदा पोल्‍ले निजम आता. अद पोल्‍ले इल्‍हा मत्‍ता: ");
INSERT INTO esg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रेचेलना पिलाल्क हासि होत्‍तुर, इंचि रामाह इनना नाटे दुक्‍कमते अळाना सप्पुड केंजावाता. अद दाना पिलाल्‍कुनाहाटीं अळसेके मत्‍ता, बोर सम्‍मत किय्यिनागानि अद समत आयाहिल्‍ले.” ");
INSERT INTO esg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","कोन्‍नि रोजकुंक हेरोद राजाल हातोर. अस्‍के इजिप्‍तते मनना योसेपुनतोनि कलाते पेनदा दूता वासि, ");
INSERT INTO esg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“तेदा, पेडन हव्कालय हूळसेक मत्‍तोर हातोर, अदुनहेंके निमे पेडन आनि ओना तल्‍लुन पीसि इस्राएल देसेमते मल्सि होन,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","अस्‍के योसेपु पेडन आनि पेडाना तल्‍लुन पीसि इस्राएल देसेमते मल्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","गानि यहुदिया एरियाता हेरोद राजाल हातारित्‍ते “ओना जेगाते ओना मर्रि अर्केलाल राजाल आतोर,” इंचि तेळियतारित्‍ते ओर अगा होनालासि वेरियतोर. आयंका कलाते पेन वेहताहेंका ओर गालिल एरियाते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अगा ओर नासरेत इनना नाटे होंचि जेगा पीतोर. इंचि “ओन नासरेततोर इंतुर.” इल्‍हा पेनदा कबुरतोर मुन्‍नेने वेहचि मत्‍तद इंदके निजम आता. ");
INSERT INTO esg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","अदे कालमते, पेनदा पोरोलते एते मुळ्‍हाचि बापतिस्मा हियना योहान यहुदिया एरियाता बय्‍लि जेगाते वातोर. वासि, “स्वर्ग राज्येम दग्गेर्क एव्ता, मिमेट मनसु मार्सकुंटु,” इंचेके वरगेयसि वेहालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","एनकटा कालमते यसायाहल इनना पेनदा कबुरतोर, ई योहानुना बारेमते इल्‍हा वळ्‍किसि मत्‍तोर गदा: “सामिनाहाटीं हर्रि तयार कीम्‍टु, ओना हर्रि सवरगा कीम्‍टु, इंचि केडाते केयानद उंदि अल्किर केंजावाता.” ");
INSERT INTO esg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","आ योहान लोटापेटा बूराते तयार कीता कपडिं केरसि तोल्‍दा पट्‍टा नडिक तासकुनुंदुर. ओर गोल्‍लाबामां आनि तेने इवे तिंडि तिनुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","येरुसलेम सहरताल, यहुदिया राज्येमता अन्‍नि जेगानाल आनि योर्दन बेरेटा सुट्‍टु-मट्‍टुना जेगाता लोकुल्‍क योहानुनगा वातुर. ");
INSERT INTO esg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","वासि ओरा पापाल्क ओप्‍कुंचि ओनहेंदाल योर्दन बेरेटे बापतिस्मा येतकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","बापतिस्मा हियना जेगातगा वेल्‍लेन मंदि परिसिल्क,सदुकिर्क वायानद हूळसि योहान ओर्कुन, “ए कट्‍ला तरासनसंटोरिटा, पेनदा होंगुनाल तपिच्‍कुनालय बापतिस्मा येतट इंचि मीकु बोर वेहतुर? ");
INSERT INTO esg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","अय्ते मरि, निजमे मीवा मनसु मार्सुकुत्‍तिर इंचि रुजुव कीसि हुप्‍सट. ");
INSERT INTO esg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","वट्‍टिदे, मोमोट अब्राहामुना वंसमतोरम आंदुम, इंचि बस्‍केने इनकुनमट. नना मीकु निजम वेहांतन, पेन अब्राहामनाहाटीं ई बंडानालगुडा पिलाल्क पुट्‍टिचि हिया परंता. ");
INSERT INTO esg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","इंदके मराकुना हिह्‍कुनगा मर्सु इरसि मंता. बव मराकुंक अय्ते बेसता पंडिं हादोंगों, अवुन नर्किसि तडमिते वाटमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मिमेट मीवा मनसु मार्सकुत्‍ताहाटीं नना मीकु एते मुळ्‍हाचि बापतिस्मा हीसेक मंतन. गानि नाकन्‍ना सक्‍तिमंतुड नावा पज्जोटाल वासंतोर. ओना हेरपुह्कुन इटाना लायकगुडा नना हिल्‍लेन. ओरे मीकु पवित्र आत्माते आनि तडमिते बापतिस्मा हींतोर. ");
INSERT INTO esg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ओना कय्‍दे हेती मंता. ओर ओना कडातुन बेस साप कीतारित्‍ते गोह्कुन तूरपाल्क पीसि गुम्मिते दोसंतोर, पोट्‍टुनबारे बस्‍केने पिर्रुवा तडमिते वाटसि बोळसंतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","पजा येसु, गालिल एरियाताल योर्दन बेरेटगा, योहानुनाहेंदाल बापतिस्मा एतालय वातोर. ");
INSERT INTO esg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","अस्‍के “नना नीवा कयदाल बापतिस्मा येतकुनगोम, गानि निमे नहगा वासि बापतिस्मा एतकुन्‍मळा!” इंचि योहान येसुन आपालय हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","अस्‍के येसु, “पेनदा इच्‍चागुडा मनम इल्हेन कियाना इंचि मंता. अदुनहाटीं ई नीतिता दंडकम इल्हेने जर्गिकांटी,” इंचि इत्‍तोर. इल्‍हा योहान येसुंक बापतिस्मा हियालय तयार आतोर. ");
INSERT INTO esg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","येसु बापतिस्मा एतसि एताल पलाते पेय्‍स्‍तस्‍के मब्बु बय्यारा आता. पेनदा आत्मा उंदि पावरेम पिट्‍टेतालेसीं आसि येसुनपोर्रो रेयतद येसु हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अस्‍केन स्वर्गमताल, “ईर ना पावरमगल्‍ला मर्रि आंदुर. ईर इत्‍ते नाकु बच्‍चोनो संबरम,” इंचि उंदि अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","पजा पेद्‍दा देय्यम येसुना पट्‍टु हूळागोम इंचि पेनदा आत्मा ओन बय्‍लि जेगाते ओता. ");
INSERT INTO esg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","अगा येसु नल्‍पै रोजकु, नल्‍पै नर्कां उपासम मत्‍तोर. अदुनहाटीं येसुंक इरगा कर्वेस्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","अस्‍के आ पट्‍टु हूळानोर येसुनगा वासि, “ओक्‍कला निमे पेनदा मर्रिन आते ई बंडां हारिं आयिं इंचि आदेस हीम,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","अस्‍के येसु इल्‍हा जवाब हीतोर, “मनकल सिराप वट्‍टि हारिं तिंचे पिस्‍सोर, गानि पेनदा तोळ्‍दाल पेय्‍सना उंदि-उंदि पोल्‍लेताहेंदाल पिस्संतोर. इल्‍हा दर्मसास्‍त्रमते रासि मंता.” ");
INSERT INTO esg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","पजा आ पेद्‍दा देय्यम येसुन येरुसलेम इनना पवित्र सहरते ओसि, गुळि पोर्रो कोस्‍सक निल्‍हाचि इल्‍हा इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ओक्‍कला निमे पेनदा मर्रिन आते हिळु दुनका, बारित्‍ते, नीकुन कापाळालय पेन दाना दूतांक आदेस हींता, आनि आ दूतां वासि नीवा काल्कुंक देब्बां दल्‍गामन्‍नि इंचि, नीकुन पोर्रोटद पोर्रेन अंदकुंतां, इल्‍हा दर्मसास्‍त्रमते रासि मंता.” ");
INSERT INTO esg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","अस्‍के येसु दान इल्‍हा इत्‍तोर, “निमे सामि इनना नीवा पेनदा पट्‍टु हूळमा, इल्‍हागुडा दर्मसास्‍त्रमते रासि मंता.” ");
INSERT INTO esg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","पजा आ पेद्‍दा देय्यम येसुन उंदि एत्‍तु गुट्‍टापोर्रो ओसि ओन्क दुनियाता अन्‍नि राज्येल्‍क, अवुना पेद्‍दातनाल्‍क बोत्‍तिगा हुपिच्‍चि, ");
INSERT INTO esg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“निमे नावा मुन्‍ने वंगिसि, नावा काल्क मोळ्‍कानय्‍ते, अवंता बोत्‍तिगा नीके हींतन,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","अस्‍के, “ए देय्यमतुना हब्बेर होन, बारित्‍ते निमे नीवा पेनदुने मोळ्‍कना, सिराप दानादे सेवा कियना, इल्‍हा दर्मसास्‍त्रमते रासि मंता.” इंचि येसु दान इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","अल्हा इत्‍तरित्‍ते पेद्‍दा देय्यम ओन होळसि होत्‍ता. अस्‍के हुळाट! पेनदा दूतां वासि येसुना सेवा कीतां. ");
INSERT INTO esg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","योहानुन जेलते वाटतुर इंचि येसुंक तेळिय्ताहेंका ओर गालिल एरियाता नासरेत नाटेने होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","अगटाल नासरेत नाटेने आगाकोंटा कपर्नाहुम इनना सहर होंचि मनालय दल्‍गतोर. आ सहर गालिल सेरवु पकापीसि मनना नप्‍तालि आनि जबलुन इनना एरियांक दल्‍गिसि मंता. ");
INSERT INTO esg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ओर अगा मत्‍ताहाटीं यसायाह इनना पेनदा कबुरतोनतोनि पेन वेहता पोल्‍ले निजम आता. आ पोल्‍ले इल्‍हा मत्‍ता, ");
INSERT INTO esg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबलुन आनि नप्‍तालि एरियाता सेरवुना हरदाहेंदाल, योर्दन बेरेटा हब्बेटा बाजुंक, यहुदि आयवोरा गालिल एरियाते, ");
INSERT INTO esg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","बोर अय्ते लोकुल्‍क हीकटते उदिस मत्‍तुरो ओर पेद्‍दा वेलगुन हूळतुर. आनि बोरपोर्रो अय्ते हामुरता नीडा अर्सि मत्‍तानो, ओर अंटोरपोर्रो वेल्‍गु अरता.” ");
INSERT INTO esg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","अस्‍केटाल येसु इल्‍हा वेहालय सुरुव कीतोर, “स्वर्ग राज्येम दग्गेर्क एव्ता इंचि मिमेट मनसु मार्सकुंटु.” ");
INSERT INTO esg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","येसु गालिल समुद्रम ओड्‍डु पीसि होननेंके वरोर सिमोनुन ओन पत्रुगुडा इनुंदुर आनि ओना तम्मुर अंदरियन हूळतोर. ओर जिम्मां पिय्‍यानोर आताहाटीं, समुद्रमते ओल्‍लां वाटसि जिम्मां पीसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ओर्कुन हूळसि, “नावा पज्जो वट, नना मीकुन मनकालोर्कुन नहगा तायानोर कींतन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","अस्‍के ओर, बिराना ओरा ओल्‍लां अग्गेन होळसि ओना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","अगटाल इंकिच्‍चो मुन्‍नेळ्‍क होत्‍तारित्‍ते येसु इव्वुर दादाल-तम्मुन इत्‍ते जब्‍दिना मर्कु याकोब आनि ओना तम्मुर योहानुन हूळतोर. ओर ओना बाबोनतोनि डोंगापोर्रो ओल्‍लां सवरिच्‍नेंके येसु ओर्कुन केयतोर. ");
INSERT INTO esg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","अस्‍के ओर, बिराना ओरा बान आनि डोंगातुन होळसि ओना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यहुदिल्कुना दर्मसास्‍त्रम कराहना लोतागा येसु पेनदा पोल्‍लें कराहतोर. स्वर्ग राज्येम बारेमते बेसता कबुर वेहचेके, लोकुल्‍कुना अन्‍नि तीरकुना रोगाल्‍कुन, कमजोरिन बेस कीसेके गालिल एरियाते पूरा तिरियतोर. ");
INSERT INTO esg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","येसु कियना कबळ पूरा सिरिया देसेमंता तेळियसि होत्‍ता. दानहाटीं तीरतीराता रोगाल्कुनोर, नोप्पिनोर, देय्याल्क पीतोर, कुंदेल रोगमतोर आनि लकवा बिमारतोर इसंटा लोकुल्‍कुन ओनगा तत्‍तुर. येसु ओर अंटोर्कुन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","गालिल एरिया, देकापोलिस एरिया, येरुसलेम सहर, यहुदिया एरिया आनि योर्दन बेरेटा हब्बेटाल वाता लोकुल्‍कुना मंदा येसुना पज्जो होनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","वेल्‍लेटुर लोकुल्‍कुना मंदातुन हूळसि येसु गुट्‍टापोर्रो होंचि उदतोर. उदतस्‍के सिस्युल्क इंका ओना दग्‍गेरा वातुर. ");
INSERT INTO esg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","अस्‍के येसु ओर्क इल्‍हा कराहलय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“बोर अय्ते आत्माताल गरिब मंतुर पेन ओर्के आसिर्वाद हींता, स्वर्ग राज्येम ओरदे आंद. ");
INSERT INTO esg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","दुक्‍कमते मत्‍तोर्कुंक पेन आसिर्वाद हींता, अद ओर्क दैरनेम हींता. ");
INSERT INTO esg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","सादा सिंपल गुनम मत्‍तोर्कुंके पेन आसिर्वाद हींता, अद ई बूमि ओर्के हीसींता. ");
INSERT INTO esg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","नीतिताहाटीं कर्वु दूपा इनाका कस्‍टम कियानोर्कुंके पेन आसिर्वाद हींता, पेन ओर्के समादानम हींता. ");
INSERT INTO esg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","दया कियानोर्कुनपोर्रो पेन दया कींता, पेन ओर्के आसिर्वाद हींता. ");
INSERT INTO esg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","बोर ओना मनसु पेनदापोर्रो इर्रंतोर, पेन ओन्‍के आसिर्वाद हींता, उंद रोजु ओरे पेनदुन हूळांतोर. ");
INSERT INTO esg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","पगातोर्कुन उंदि कियानोर्कुंके पेन आसिर्वाद हींता, ओर्कुने पेनदा पिलाल्क इंचि इंतुर. ");
INSERT INTO esg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","पेनदा सत्‍तेमते ताकनाहाटीं तकलिप, दुक्‍कम अर्रानोर्कुंके पेन आसिर्वाद हींता, अद स्वर्ग राज्येम ओराहाटींगे मंता.” ");
INSERT INTO esg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“मिमेट नावा सिस्युल्क आताहाटीं लोकुल्‍क मीवा अपमानम कींतुर, तिप्‍पल्‍क कींतुर, मीवा विरोदमते बच्‍चुंगो आबद्‍दम पोल्‍लें वेहांतुर, अस्‍के मीकुगुडा पेन आसिर्वाद हींता. ");
INSERT INTO esg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","मीकन्‍ना मुन्‍नेटा पेनदा कबुरतोर्कुनगुडा लोकुल्‍क इल्हेने तकलिप कीतुर. अदुनहाटीं मिमेट कुसिते मंटु, आनंदमते मंटु. स्वर्गमते मीकु पेद्‍दा इनाम दोर्कंता.” ");
INSERT INTO esg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","मिमेट दुनियातोराहाटीं होव्वोरतसंटोर आंदिर. ओक्‍कला होव्वोर, होव्वोरलेसीं रुसि वायाकोंटे अव्टे मर्रा बल्हा होव्वोर रुसि तरा परांतोम? अस्‍के अद बता कबळ्‍क ओज्‍जो. अद पलाते पोहचियना कबळ्‍के ओज्जंता, लोकुल्‍क दान जारसेके दांतुर. ");
INSERT INTO esg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","गुट्‍टापोर्रो मत्‍ता नार दिसाकोंटा मन्‍नो. अल्‍हेने मिमेट दुनियाताहाटीं वेलगु आंदिर. ");
INSERT INTO esg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","बोरे आयिर वेडसि निरिच्‍चि, दान गुल्‍ला हिळु इर्रुर. एत्‍तुने उंदि दीसोडिपोर्रो इर्रंतुर. अस्‍के अद लोतोर अंटोर्कुंक वेल्‍गु हींता. ");
INSERT INTO esg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","अदुनहाटीं मीवा पिस्वर लोकुल्‍कुना मुन्‍ने इल्‍हा मनना गदा मीवा वेलगुनसोंटा बेसता कबाह्‍कुन हूळसि वेरेतोर स्वर्गमता बाबानद कदर कियानुर. ");
INSERT INTO esg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","नना मूसाना नियमतुन, पेनदा कबुरतोर रासतदुन रद्‍द कियालय वातन इनकुनमटु. नना दान रद्‍द कियालय आयो गानि अव्टे नावा बारेमते रासता पोल्‍लेन पुरागा कियालय वातन. ");
INSERT INTO esg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","नना मीकु निजम वेहचेके मंतन, बूमि मब्बु नासडेम आयानदाका दर्मसास्‍त्रमतद उंदि सिन्‍ना गीता, पोल्‍लेगुडा रद्‍द आयो. ");
INSERT INTO esg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","मिमेट अंटोर आदेस परकारम ताकना. बोरे आयिर पेनदा सिन्‍ने आदेसतुनगुडा पालन कियाकोंटा, अल्‍हेने वेरेतोन्‍कगुडा वेहानय्ते, ओर स्वर्ग राज्येमते सिन्‍नासि मनंतोर. गानि बोर अय्ते नियम परकारम ताकंतोर आनि इंकावरोंक दाना परकारम ताकालय वेहांतोर ओर स्वर्ग राज्येमते बच्‍चोनो पेद्‍दा आयानुर. ");
INSERT INTO esg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","नना मीकु वेहासेक मंतन केंजट. दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्क ईरकन्‍ना मिमेट एक्‍को नीतिमंतुल्क आयवा स्वर्ग राज्येमते नेंगा पर्रिट. ");
INSERT INTO esg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","मिमेट बोन हव्कमट, बोर अय्ते हव्कंतोर ओन्क कोरटताल सिक्‍सा आंता इंचि मीवा एनकटा पेद्‍दाल्कुंक पेन वेहतद मिमेट केंजसि मंतिर. ");
INSERT INTO esg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","गानि नना मीकु वेहंतन गदा, बोर अय्ते ओना दंटातोनपोर्रो होंग आंतोर ओर पेनदा कोरटता सिक्‍सालायक आंतोर. अल्‍हेने बोर अय्ते ओना दंटातोना अपमानम कींतोर, ओर पेद्‍दाल्कुना कोरटता सिक्‍सालायक आंतोर. बोरन्‍ना अरे मुर्का इनानय्ते ओन्क देय्याल्क मनना अग्नि गुंडमता सिक्‍सा आयार. ");
INSERT INTO esg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","दानहाटीं निमे ओक्‍कला पेन गद्‍देतगा उपारम वाटानेंके नीवा दंटातोर नीवा पोर्रो होंग आसि मंतोर इंचि मति वायानय्ते, ");
INSERT INTO esg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","निमे आ उपारमतुन अग्गेन होळसिसि मुन्‍ने दंटातोनगा होन. दंटातोन समत कीतारित्‍ते वासि उपारम वाटा. ");
INSERT INTO esg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","नीवा पगातोर नीकुन कोरटते ओयानेंके, निमे बिराना हरदेन ओन दोस्ती कीम. हिलाकोंटे ओर नीकुन ओसि मजिस्‍टरुंक अप्‍पजेपनुर. मजिस्‍टर पोलिसुंक अप्‍पजेपनुर, पोलिस ओसि नीकुन जेलने वाटानुर. ");
INSERT INTO esg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","नना नीकु निजम वेहांतन, कोत्‍तक-कोत्‍ता दोहनदाका निमे अगटाल पेय्‍सा पर्रिन. ");
INSERT INTO esg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","बोगमतनम कियमट इंचि एनकटा वेहतद मिमेट केंजसि मंतिर. ");
INSERT INTO esg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","गानि नना मीकु वेहसेके गदा बोरन्‍ना आयिर, बदाना मुरतळता हेके पापि नदरते हूळानय्ते ओर ओना मनसुने दानतोनि बोगमतनम कीतापे. ");
INSERT INTO esg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अदुनहाटीं तिना कळुगिंटा पापम किया वेहते, दान तेंडसि पोहतेने नीकु बेस मनंता. बारित्‍ते पूरा मेंदुल नरकमते होननदानकन्‍ना उंदि कळु होत्‍ते होन्‍नि. ");
INSERT INTO esg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अल्हेन ओक्‍कला नीवा तिना कय नीकुन पापम किया वेहते, दान नर्किसि पोहतेने बेस मनंता. बारित्‍ते नीवा पूरा मेंदुल नरकमते होननदानकन्‍ना मेंदुलता उंदि कय होत्‍ते होन्‍नि. ");
INSERT INTO esg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","बोरन्‍ना ओना मुत्‍तोन होळसियाना मत्‍ते, दानकु ओर सोडसिट्‍टि हीसि होळसिय्यिर, इल्‍हा मूसाना नियमते वेहचि मंता. ");
INSERT INTO esg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","गानि नना मीकु वेहासेक गदा, बोरन्‍ना ओना मुत्‍तोन बोगमतनमता कारनम तप्‍पा वेरे कारनमते होळसियानय्ते ओर दानतोनि बोगमतनम किया वेहांतोर. होळसीता मुत्‍तोनतोनि बोरन्‍ना मरमिं आयानय्ते ओरगुडा बोगमतनम कींतोर. ");
INSERT INTO esg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ओक्‍कला निमे ओट्‍टु तिनानय्ते, दान नेमुह्‍मा, गानि निमे तित्‍ता ओट्‍टुन पेनदाहाटीं पूरा कीम इल्‍हा मूसाना नियमते पेद्‍दाल्कुंक वेहतद मिमेट केंजतिर. ");
INSERT INTO esg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","नना मीकु वेहासेक मंतन गदा, निमे ओट्‍टु तिनने तिनमा. स्वर्गम पेनदा राजगद्‍दे आंद, इंचि निमे दाना ओट्‍टु तिनमा. ");
INSERT INTO esg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","अल्हेन बूमि, पेन काल्क इर्रना जेगा आंद, अदुनहाटीं बूमि तोड इंचि दानदगुडा ओट्‍टु तिनमा. आनि येरुसलेम सहर पेद्‍दा महाराजानद इत्‍ते पेनदाद आंद, इंचि दानदगुडा ओट्‍टु तिनमा. ");
INSERT INTO esg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","नीवा तल्‍लातद उंदिंका केल्‍दुन तेल्‍लगा हिलाकोंटे नल्‍लगा किया पर्रिन, बारित्‍ते अन्‍नि पेनदा कय्‍देन मंता, इंचि तल्‍लतदगुडा ओट्‍टु तिनमा. ");
INSERT INTO esg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","दानहाटीं नीवा वळ्‍कुमळ हो इत्‍ते हो, हिलाकोंटे हिल्‍ले इत्‍ते हिल्‍ले इंचि मन्‍नि. नीवा पोल्‍लेतुन निजम कियालय ओट्‍टु तिनानय्ते अद देय्यमताहेंदाल वाता. ");
INSERT INTO esg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","कळदुक बदला कळु, पलदुक बदला पल्‍लु तेंडाना इंचि मूसाना नियमते वेहता पोल्‍लेतुन मिमेट केंजतिर गदा. ");
INSERT INTO esg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","गानि नना मीकु वेहासेके मंतन गदा, मिमेट मीवा पगातोरकुंक एदुर तिरियमटु. ओक्‍कला बोरन्‍ना नीकुन तिना सेंपापोर्रो तंते निमे इंकुंदि सेंपागुडा तिरहा. ");
INSERT INTO esg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","बोरन्‍ना नीपोर्रो केस कीसि नीवा कोट तेंडकुननय्ते ओन्क नीवा अंगिगुडा हीम. ");
INSERT INTO esg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","अल्हेन बोरन्‍नागिंटा नीकुन उंदि कोसेड लक्‍कु सामान पीसि वांतिना, इंचि बल्‍मि कियानय्ते, निमे आ मनकनतोनि रोंडु कोसकुना लक्‍कु होन. ");
INSERT INTO esg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","बोरन्‍ना नीकुन बतलन्‍ना तल्‍कते अद ओन्क हीम. उद्‍देरा तल्किनागानि, हिल्‍ले इनमा. ");
INSERT INTO esg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“निमे नीवा दंटातोर्कुन पावरम कीम, पगातोर्कुन बारे हय्स्मा,” इंचि इत्‍तद मिमेट केंजतिर. ");
INSERT INTO esg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","गानि नना मीकु वेहानद बतल इत्‍ते, मीवा पगातोर्कुन पावरम कीम्‍टु. मीकुन तकलिप कियानोराहाटीं मिमेट पारतना कीम्‍टु. अस्‍के मिमेट मीवा स्वर्गमते मनना बाबाना पिलाल्क आंतिर. ");
INSERT INTO esg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","बारित्‍ते सेड्‍डोर्क, बेसतोर्क इव्वुर्किंका पोळ्‍दुनाहेंदाल वेलगु ओरे हींतोर. अल्हेन पापिल्कुंक नीतिमंतुल्‍कुंक पिर्रुगुडा ओरे हींतोर. ");
INSERT INTO esg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","अयना मीकुन पावरम कियानोर्कुने मिमेट पावरम कीते मीकु पेनदाहेंदाल बता इनाम दोर्कंता? कर वसुल कियानोरगुडा अल्हे कींतुर. ");
INSERT INTO esg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","निमे ओक्‍कला नीवा दंटातोर्कुनतोने बेस मत्‍ते, निमे वेरे बतल बेस कीसंतिन? यहुदि आयवोरगुडा अल्हे कींतुर. ");
INSERT INTO esg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","अदुनहाटीं स्वर्गमते मंदना मीवा पेनबाबाल बल्हा पुरागा मंतोर अल्हे मिमेटगुडा मंटु. ");
INSERT INTO esg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","उसारते मंटु! मिमेट लोकुल्‍कुंक हुप्‍सनाहाटीं नीति कबाह्‍क कियमट. अल्हा कीते, स्वर्गमते मनना मीवा पेनबाबानहेंदाल मीकु बतले इनाम दोर्को. ");
INSERT INTO esg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","अदुनहेंके मिमेट बोनकन्‍ना दर्मम कियनेंके डप हाटमट. बारित्‍ते अल्हा डोंगि लोकुल्‍क मिटिंगुल्कुना जेगाते, हरकुन पीसि ओर्कुन कदर कियगोम इंचि कींतुर. नना निजम वेहंतन, बोर अय्ते अल्हा कींतुरो ओर्कु ओरा इनाम दोर्कुता. ");
INSERT INTO esg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","मिमेट बोनकन्‍ना दर्मम कियनेंके मीवा तिना कय बतल कींतनो अद रोड्‍डा कय्‍दुक बिल्कुल तेळियामन्‍नि. ");
INSERT INTO esg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","अल्हा कीते मिमेट कियना दर्मम बोनकु तेळियाकोंटा मनंता, अद बतल आंदो मीवा पेनबाबांक एर्के मंता. अदुन हूळसे मीकु इनाम हींतोर. ");
INSERT INTO esg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","अल्‍हेने बस्के अय्ते मिमेट पारतना कींतिरो, अस्‍के डोंगि लोकुल्‍कुनलेसीं कियमट. डोंगि लोकुल्‍क हरकुना मूलनपोर्रो, पंचादिं कियना जेगाने नित्‍तिसि पारतनां कींतुर, अल्हा कीते वेल्‍ले लोकुल्‍क ओर्कुन हूळंतुर इंचि ओर्कु अनपिंचंता. गानि नना मीकु निजम वेहंतन, ओरा इनाम ओर्कु दोर्कुता. ");
INSERT INTO esg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","गानि मिमेट पारतना कियना वेलाक लोता लोप्पोटा अर्राते होंचि तल्‍पु वाटकुंचि बोर्के दिसुवा मीवा पेनबाबांक पारतना कीम्‍टु. अस्‍के मीवा पेनबाबाल मीकु अद पारतनाता जवाब हींतोर. ");
INSERT INTO esg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","वेरे जातितोर पारतना कियनेंके उंदे पोल्‍लेतुन वेल्‍लेन मल्कां वळकांतुर, अल्हा कीते पेन ओरद केंजंता इंचि ओर्क अनपिच्‍चंता. ");
INSERT INTO esg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","गानि मिमेट ओरा लेह्का आयमट. बारित्‍ते मीकु बतल गावालेनो अद तल्कका मुन्‍नेन पेनदुक एरपाट मनंता. ");
INSERT INTO esg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","अदुनहाटीं मिमेट पारतना कियनेंके इल्‍हा पारतना कीम्‍टु: “ए स्वर्गमते मनना मावा पेनबाबा, नीवा पोरोलतुन अंटोर कदर कियिरकांटी. ");
INSERT INTO esg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","निमेन मापोर्रो राज्येम कीम, स्वर्गमते नीवा इच्‍चा बल्हा पूरा आंतानो, अल्हेन ई बूमिपोर्रोगुडा आयिकांटी. ");
INSERT INTO esg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","माकु रोजता तिंडि इय्यालागुडा हीम, ");
INSERT INTO esg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","माकु विरोदमते कीता तप्‍पुकुन मोमोट बल्हा माप कीतोमो, निमेगुडा मोमोट कीता तप्‍पुकुन माप कीम. ");
INSERT INTO esg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","माकुन पट्‍टुने अर्राकोंटा कापाळा, सेड्‍डातनमताल माकुन पिसागोट्‍टा. बस्केळक राजाल निमेन आंदिन. अदुनहाटीं ताकत आनि महिमा बस्केळक नीवदे आंद.” आमीन! ");
INSERT INTO esg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","मिमेट वेरेतोरा तप्‍पुकुन माप कीते, स्वर्गमते मनना पेनबाबालगुडा मीकुन माप कींतोर. ");
INSERT INTO esg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","गानि उंदि वेलाते मिमेट मनकालोरा तप्‍पुकु मापि कियाकोंटे स्वर्गमते मनना मीवा पेनबाबालगुडा मीकुन मापि किय्योर. ");
INSERT INTO esg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","मिमेट बस्के ओक्‍कापोद्‍दु मनंतिटो अस्‍के मिमेट जिव्वरा मोकोम कीसि मनमट. डोंगि लोकुल्‍क अल्हेन कींतुर. ओर्कु अनपिंचंता गदा जिव्वरा मोकोम कीसि मत्‍ते लोकुल्‍क ओर्कुन हूळसि ईर ओक्‍कापोद्‍दु मंतुर इंचि इंतुर. गानि नना मीकु निजम वेहंतन, ओर्कु ओरा इनाम दोर्कुता. ");
INSERT INTO esg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","अदुनहाटीं मिमेट बस्के अय्ते ओक्‍कापोद्‍दु मनंतिटो, अस्‍के तल्‍लाक निय होकसि मोकम नोर्राट. ");
INSERT INTO esg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","अल्हा कीते ओक्‍कापोद्‍दु मत्‍तद बोर्के दिस्सो गानि बोर्के दिसुवा मीवा पेनबाबाल मात्रम ओक्‍का पोद्‍दुन हूळांतोर. अदुनहेंके मीकु इनाम हींतोर. ");
INSERT INTO esg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","मिमेट बूमिपोर्रो दनम जमा कीते अदुन सेदेल तिंचि, सिलुम पीसि नासडेम आंता आनि दोंगाल्क दोसकुंचि ओंतुर. अदुनहाटीं ई बूमिते दनम जमा कियमट. ");
INSERT INTO esg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","गानि मिमेट मीवाहाटीं स्वर्गमते दनम जमा कीम्‍टु, अगा अवुन सेदेल तिन्‍नो, सिलुम पिय्यो, दोंगाल्कगुडा दोसकुंचि ओयुर. ");
INSERT INTO esg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","बारित्‍ते मीवा दनम बगा मत्‍ते अग्गेन मीवा मनसु मनंता. ");
INSERT INTO esg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","मीवा कळु मेंदुलता वेडसि आंदु. अदुनहाटीं मीवा कळु बेस मत्‍ते, मीवा मेंदुलंता वेलगु मनंता. ");
INSERT INTO esg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","मीवा कळु बेस हिलाकोंटे मीवा मेंदुलंता हीकटे मनंता. दानहाटीं मिमेटगिंटा पेनदा वेलगुन हूळाकोंटे मीवा पिस्वरंता हीकटे मनंता. ");
INSERT INTO esg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","अल्हेन वरोर मनकल इव्वुर मालकुल्कुनगा सेवा किया पर्रोर. अल्हा सेवा कीते ओर वरोन बेस पावरम कींतोर, इंकावरोन हयसोर. हिलाकोंटे वरोना पोल्‍ले बेस केंजंतोर इंकावरोना पोल्‍ले बारे केंजोर. इंचि मिमेट पेनदुन आनि दनमतुन उंदे मल्का सेवा किया पर्रिर. ");
INSERT INTO esg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","अदुनहाटीं नना मीकु वेहनद बतल इत्‍ते जीवा तिंडिकन्‍ना मुक्‍केम, मेंदुल कपडींकन्‍ना मुक्‍केम आंदु. इंचि पिस्‍सनाहाटीं तिनकोम बतल, उनकोम बतल, इंका मेंदुल्ताहेंका केर्कोम बतल इंचेके रंदि कियमट. ");
INSERT INTO esg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","आ पिट्‍टेनहेके हुळट, अव वीतों आनि कोय्यों, अचोने आयका गुम्मिने जमागुडा किय्यों, अय्नागानि मीवा स्वर्गमते मनना पेनबाबाल अवुंक तिंडि हींतोर. मीकु अय्ते पेनदा मुन्‍ने पिट्‍टेंकन्‍ना बच्‍चोनो विलवा मंता इदु मीकु एर्के मंता. ");
INSERT INTO esg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","अय्नागानि रंदि कीसि ओना आवसुन उंदि गंटा एक्‍को बेरसागोटतोर मीवा नड्‍डुम बोरन्‍ना मंतोरा? ");
INSERT INTO esg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","मरि मिमेट केर्रना कपडिनहाटीं रंदि बारि कींतिट? केडाते पूयाना आ पूतनहेके हुळट अव बल्हा बेर्ससंतांगो! अव कबळ किय्यों, कपडिं इंका कुट्‍टों. ");
INSERT INTO esg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","गानि नना वेहानद बतल इत्‍ते, सुलेमान राजाल वेल्‍लेन सिरमंत मंचिगुडा ओना कपडिं आ पूतानाल उंदि पूतातच्‍चोगुडा सोकु मनाहिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","अरे विस्वासम तक्‍को लोकुरिटा, जाडि इय्याला मंता, नाडि तडमिते वेसि दांता. अयना पेनबाबाल अवुंक इच्‍चो बेसता कपडिं हींतोर, अय्ते अवुंकन्‍ना बेसता कपडिं मीकु हिय्या पर्रोरा? ");
INSERT INTO esg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","अदुनहाटीं बतल तिंदकोम, बतल उंडकोम, बतल केर्कोम इंचि रंदि कीसेक मनमट. ");
INSERT INTO esg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","विस्वासम कियवोरगुडा इव गावाले इंचि तनलाळसेक मनांतुर. गानि मीकु इव अन्‍नि गावाले इंचि स्वर्गमते मनना मीवा पेनबाबांक एर्के मंता. ");
INSERT INTO esg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","अदुनहाटीं मिमेट मुन्‍ने स्वर्ग राज्येमतुन आनि पेनदा नीतितुन पह्कट, अस्‍के इव अन्‍निगुडा मीकु दोर्कनुं. ");
INSERT INTO esg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","बस्केळक बद्‍दना बद रंदि मनंता. इंचि नाडीता रंदि इयालेन कियमट. नाडीता रंदि नाडीताहाटीं होळसीम्टु. ");
INSERT INTO esg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","मिमेट वेरेतोरपोर्रो दोसेम दोसमट, अस्‍के मीपोर्रोगुडा पेन दोसेम दोस्‍सो. ");
INSERT INTO esg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","मिमेट बल्हा दोसेम दोस्‍संतिरो, अल्‍हेने मीपोर्रोगुडा पेन दोसेम दोस्‍संता. बद कोल्ताते मिमेट हींतिरो, अदे कोल्ताते मीकु हियमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","अरे डोंगि मनका, नीवा कळ्‍दे अरता सित्‍कुन तेंडका, नीवा दंटातोना कळ्‍दे अरता बुस्सितुन निमे बारि तेंडा हूळंतिन? ");
INSERT INTO esg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","नीवा कळ्‍देन सित्‍कु अर्सि मननेंके, “नीवा कळ्‍दे अरता बुस्सितुन तेंडाहीम इंचि नीवा दंटातोन बल्हा इना पर्रांतिन?” ");
INSERT INTO esg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","मोदाला नीवा कळ्‍दा सित्‍कुन तेंडा. अस्‍के नीवा दंटातोना कळ्‍दा बुस्सितुन तेंडालय नीकु बेस दिस्‍सार. ");
INSERT INTO esg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","पवित्र वस्‍तुक नय्‍कुन मुन्‍ने वाटमट, पद्‍दिना मुन्‍ने मुच्‍च्याल्‍क पोच्‍चुमट. अल्हा कीते पद्‍दिं अवुन काल्कुने जारांतां, नय्‍कु बारे मीपोर्रो अर्सि मीकुने कस्कंतां. ");
INSERT INTO esg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","पेनदुन तल्‍कट मीकु हिय्यार, पह्कट मीकु दोर्कार, तल्‍पुन तनट तल्‍पु तेंडार. ");
INSERT INTO esg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","बारित्‍ते बोर अय्ते तल्कंतोर ओन्क हियमळ जर्गंता, बोर अय्ते पह्कंतोर ओन्क दोर्कंता, बोर अय्ते तल्‍पुन तनंतोर ओनाहाटीं तल्‍पु तेंडमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","मीलोप्‍पो बोरन्‍ना मनकल मंतोरा, ओना मर्रि हारि तल्‍कते बंडा हियानोर? ");
INSERT INTO esg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","हिलाकोंटे जिम्मा तल्‍कते तरास हियना मनकल मंतोरा? इल्‍हा बोरे किय्योर. ");
INSERT INTO esg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","अय्ते मिमेट सेड्‍डोर्क आसिगुडा मीवा पिलाल्कुंक बेसतव हियना इंचि मीकु तेळियतस्के, स्वर्गमते मनना मीवा पेनबाबाल ओन तल्कानोर्कुंक वेल्‍लेन बेसतव हिय्योरा? ");
INSERT INTO esg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","अदुनहाटीं लोकुल्‍क मीवातोनि बल्हा मनना इंचि मिमेट इनकुंतिरो, अल्हेन मिमेट ओरतोनि मंटु. इदे पोल्‍ले मूसाना नियम आनि पेनदा कबुरतोर रासतदगुडा वेहंता. ");
INSERT INTO esg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","नासडेमताहेके होनना हर्रि, तल्‍पु नेर्वुंक नेरवु मंता, आ हरपीसि वेल्‍ले मंदि दांतुर. अदुनहाटीं इर्कुटोम मत्‍ता हरपीसि होळियट. ");
INSERT INTO esg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","पिस्वरताहेके होनना हर्रि आनि तल्‍पु वेल्‍ले इर्कुटोम मंता. आ हर्रि वेल्‍ले तक्‍को मंदिक दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","आबद्‍दम कबुरतोरागटाल उसारते मंटु. ओर मिहगा सादा गोर्रेतालेसीं वांतुर गानि ओरा लोप्पो तोडेल्‍लिता गुनम मनंता. ");
INSERT INTO esg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ओर कियाना कबाह्‍कुन हूळसे ओर डोंगि कबुरतोर इंचि एरपाट कींतिर. बल्हा अय्ते हाह्कुना जप्‍पिताल अंगुर पंडिं हादों, हिलाकोंटे ईरामुस्‍टी मराकुनाल मरका पंडिं हादों, ");
INSERT INTO esg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","अल्हेन बेसता मराकु बेसता पंडिं हादंतां, कराब मराकु कराब पंडिं हादंतां. ");
INSERT INTO esg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","बेसता मराकु कराब पंडिं हादों कराब मराकु बेसता पंडिं हादों. ");
INSERT INTO esg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","बव मराकु बेसता पंडिं हादों असोंटव अन्‍नि मराकुन नर्किसि तडमिते वाटंतुर. ");
INSERT INTO esg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","इंचि डोंगि कबुरतोर्कुन मिमेट ओर कियाना कबाह्‍कुन हूळसे एरपाट कीकिट. ");
INSERT INTO esg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","नाकुन सामि सामि इनानोर अंटोर स्वर्ग राज्येमते होळयुर. गानि स्वर्गमते मनना नावा पेनबाबाना मनसु मत्‍ताप बोर अय्ते ताकंतुर ओरे स्वर्ग राज्येमते होळियंतुर. ");
INSERT INTO esg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","नना न्‍यायम कियाना आकिर रोजुने वेल्‍लेटुर नहगा वासि, सामि मोमोट नीवा पोरोलते बविस्यवानि कीतोम, नीवा पोरोलते देय्याल्क-बूताल्कुन पेचाहतोम, नीवा पोरोलते बच्‍चुंगो अद्‍बूतामाता कबाह्‍क कीतोम, इंचेके इनानुर. ");
INSERT INTO esg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","अस्‍के ओर्कुन, ए सेड्‍डा कबाह्‍क कियानोरिटा! नना मीकुन एरपाट किय्योन. मिमेट इगेटाल पेय्सि होंटु इंचि इंतन. ");
INSERT INTO esg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","अदुनहाटीं नावा पोल्‍लें केंजसि दाना परकारम ताकाना हरेक मनकल, बंडा पुनादिपोर्रो लोन दोहकुता तेल्‍विता मनकनलेसीं मंतोर. ");
INSERT INTO esg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","पिर्रु वाता, कम्मुड वाता, वळि-दुमारम वासि लोतुक दल्‍गिना गानि अद कूला हिल्‍ले. बारित्‍ते अद लोता पुनादि बंडातोनि दोहाचि मंता. ");
INSERT INTO esg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","गानि नावा पोल्‍लें केंजसि, दाना परकारम ताकवा हरेक मनकल, उस्केते लोन दोहकुता तेल्वि हिल्वासंटोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","पिर्रु वाता, कम्मुड वाता वळि-दुमारम वासि लोतुक दल्‍गता अस्‍के अद लोन पूरा कूल्‍सि पाड आता, इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","येसु पेनदा पोल्‍लें कराहमळ महातस्के ओना कराहमळतुन केंजसि लोकुल्‍क वेल्‍ले इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","बारित्‍ते येसु ओर्कु ओरा दर्मसास्‍त्रम कराहना गुरुल्‍कुनलेसीं आयो गानि अदिकारम मत्‍ताप कराहतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","येसु गुट्‍टा पोर्रोटाल हिळु रेयतस्के वेल्‍लेन लोकुल्‍क ओना पज्जो-पज्जो वासेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","हुळाट! अस्‍के वरोर कुस्‍टरोगम आता मनकल येसुनगा वासि ओना काल्कुनपोर्रो अर्सि, “सामि, निमे इन्‍कुत्‍ते नाकुन बेस किया पर्रांतिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","अस्‍के येसु कय मुन्‍नेळ्‍क कीसि ओन इट्‍सि इल्‍हा इत्‍तोर, “निमे बेस आयगोम इंचि नावा मनसु मंता, बेस आम” इंचि इत्‍ता इन्‍मळे आ कुस्‍टरोगम आसि मत्‍ता मनकल बेस आतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","पजा, “इगे जर्गतद बोर्के वेहमा. गानि निमे होंचि मीवा पेर्मांक हुप्‍सा. कुस्‍टरोगमताल निमे बेस आता गवाइ इंचि मूसाल वेहता मोक्‍कु हीम. अदुन हूळसि निमे बेस आतिन इंचि लोकुल्‍कुंक एरपाट आंता,” इंचि येसु ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","येसु कपर्नाहुम सहर होत्‍तस्के ओनगा वरोर दरोगल वासि, ");
INSERT INTO esg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“सामि, नावा जीतागाड लकवा बिमारते इरगा तकलिपने लोन मंतोर,” इंचि सहायमहाटीं विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","अस्‍के, “नना वासि ओन बेस कींतन,” इंचि येसु दरोगन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","गानि आ दरोगल, “सामि, निमे नावा लोन वायानच्‍चो पेद्‍दातनम नहगा हिल्‍ले. ननागुडा वरोर अदिकारिना कय्‍दा हिळु कबळ कींतन; नावा कय्‍दा हिळुगुडा सिपाइल्क मंतुर. नना अव्टेटाल वरोन ‘होन’ इत्‍ते ओर दांतोर, इंकावरोन ‘वा’ इत्‍ते ओर वांतोर. अचोने आय्‍का नावा दासुन, ‘इद कीम’ इत्‍ते ओर कींतोर. अदुनहाटीं निमे सिराप उंदि पोल्‍ले इन, नावा जीतागाड बेस आंतोर.” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","इद केंजसि येसुंक वेल्‍ले इचंत्रम आता. अस्‍के ओना पज्जो ताकसेक मत्‍तोर्कुन इल्‍हा इत्‍तोर, “नना मीकु निजम वेहांतन, इस्राएल लोकुल्‍कुन लोप्‍पोगुडा इच्‍चोन विस्वासम मत्‍ता मनकल नाकु बग्‍गेन दोर्का हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","इंका नना मीकु वेहंतन गदा, वेल्‍लेटुर लोकुल्‍क पोळ्‍द पेय्‍सनाहेंदाल, पोळ्‍द अर्रानाहेंदाल वासि, अब्राहाम, इसाक, याकोब ईरतोनि स्वर्ग राज्येमते उद्‍दानुर. ");
INSERT INTO esg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","गानि बोर अय्ते, ‘मोमोट पेनदा संतानम आंदुम’ इनकुंतुरो, ओर्कुन मात्रम पेन पलाते हीकटते वाटसींता. अगा सिराप अळमळ, पल्कु कोर्कमळे मनंता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","पजा येसु आ दरोगन, “निमे होन, नीवा विस्वासम बल्हा मंतनो अल्हेन नीकु जर्गंता” इंचि इत्‍ता इनमडे ओना जीतागाड बेस आतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","पजा येसु पत्रुना लोन वातस्के ओना पोरड एळकि वासि मींडसि मत्‍तद हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","येसु दाना कयदुन इट्ता इट्‍टुडे एळकि रेय्ता. अस्‍के अद तेदसि येसुना सेवा कियालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","पजा पोळ्‍द होंचि लोकुल्‍क देय्याल्क पीतोर्कुन वेल्‍लेन मंदितुन येसुनगा पीसि वातस्के ओर उंदे पोल्‍लेते देय्याल्कुन गेदमिसि, बिमार मत्‍ता अंटोर्कुन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","अद अल्हा बारि जर्गुता इत्‍ते एनकटा बस्‍केनो यसायाह इनना पेनदा कबुरतोर वेहता पोल्‍ले पुरागा आयना इंचि जर्गुता. यसयाल इल्‍हा वेहचि मत्‍तोर: “ओर मना रोगाल्‍कुन तेंडसि पोहतोर मना बादन एतकुत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","येसु ओना सुट्‍टु वेल्‍लेन मंदि मत्‍तद हूळसि ओना सिस्युल्कुन मिमेट समुद्रमता हब्बेटा बाजुंक होंट, इंचि आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","पजा वरोर दर्मसास्‍त्रम कराहना गुरु ओनगा वासि, “गुरु, निमे बगा दांतिनो अगा नना नीवा पज्जो वांतन.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","अस्‍के येसु ओन इल्‍हा इत्‍तोर, “नक्‍कांक बारे मनालय सोर्रें मंतां, पिट्‍टेंक मनालय गूडां मंतां, गानि मनकना रूपमते पुटतोन नाकु मात्रम तल्‍ला इर्रालयगुडा जेगा हिल्‍ले.” ");
INSERT INTO esg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","अस्‍के येसुना पज्जो वातोरव्टेटाल वरोर, “सामि, नाकुन मोदाला होनाहीम, नावा बाबाल हातास्के ओन गति कीसि वांतन.” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","गानि, “हिल्‍ले, निमे इंदकेन नावा पज्जो वा. बोर अय्ते हाताप मंतुरो, ओरे ओरा हातोरा गति किय्‍यिर,” इंचि येसु ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","पजा येसु डोंगाते एक्‍कुतंका ओना सिस्युल्क इंका ओना पज्जेन एक्‍कुतुर. ");
INSERT INTO esg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","अस्‍के समुद्रमते उंदि पेद्‍दा दुमारम वाता. आ दुमारम इच्‍चो पेद्‍देद मत्‍ता गदा, एता तळाने डोंगा मुळगालय दल्‍गता. गानि येसु मात्रम आ डोंगाते मींडसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","अस्‍के सिस्युल्क ओनगा होंचि ओन निद्रताल तेहाचि, “सामि, माकुन कापाळा, मनम नासडेम आसि होंचंतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","अस्‍के, “अरे विस्वासम तक्‍को लोकुरिटा, बारि वेरियंतिर?” इंचि येसु ओर्कुन इत्‍तोर. पजा तेदसि आ वळि-दुमारमतुन आनि समुद्रमतुन गदरिचतोर अय्ते अव सांत आतां. ");
INSERT INTO esg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","अद हूळसि सिस्युल्कुंक पेद्‍दा इचंत्रम आता. अस्‍के ओर, “अरे ईर बसोंटा मनकल रो, वळि, समुद्रमगुडा ईना पोल्‍ले केंजंता!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","पजा ओर समुद्रमता हब्बेटा बाजुंक मनना गदरेकरकुना एरियक एव्‍तुर. अस्‍के इव्वुर देय्याल्क पीता मनकालोर तापळन बोग्‍ळाताहेंदाल येसुनगा वातुर. ओर इरगा वेरियनाल मत्‍तुर इंचि ओर मत्‍ता हरदाहेके बोरे ताकाकोंदुर. ");
INSERT INTO esg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","हुळाट! ओर इव्वुर येसुनगा वासि, “पेनदा मर्रिना, मातोनि नीकु बता कबळ? इत्‍ता वेलाकन्‍ना मुन्‍नेन निमे माकु सिक्‍सा हियालय वातिना?” इंचि मोत्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ओर नित्‍तिसि मत्‍तगटाल इच्‍चोन लक्‍कु पद्‍दिना मंदा मेय्‍सेके मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","अस्‍के, “ओक्‍कला निमे माकुन इराव्टेटाल तेंडानय्ते माकुन आ पद्‍दिना मंदाते होनाहीम,” इंचि आ देय्याल्क येसुन विनंति कीतां. ");
INSERT INTO esg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","अय्ते ओर आ देय्याल्कुन, “होंट” इंचि इत्‍तोर, इत्‍तस्के आ देय्याल्क ओराव्टेटाल पेय्सि पद्‍दिना मंदाते होत्‍तां. हुळाट! पजा आ पद्‍दिना मंदा समुद्रम ओड्‍डुन पोर्रोटाल हिळतुक वितसि एते मुळ्‍गिसि हासोत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","अस्‍के आ पद्‍दिं मेहानोर नाटे वित्‍सि होंचि अगा जर्गतद आनि आ देय्याल्क पीतोरद बतल आता अन्‍नि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","हुळाट! अस्‍के पूरा नाटेना लोकुल्‍क येसुंक कलियालय वातुर. वासि ओर बस्के अय्ते येसुन हूळतुरो अस्‍के, “मावा एरियाताल पेय्सि होन,” इंचि ओन विनंति कीतुर. बारित्‍ते पद्‍दिं हाताहेंका अद नाटेनोरद वेल्‍लेन नुकसान आता. ");
INSERT INTO esg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","येसु डोंगाते उदिस सेरवु दाटसि ओना सहर मल्सि वातोर. ");
INSERT INTO esg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","हूळा! अस्‍के इच्‍चुर लोकुल्‍क वरोर लकवा बिमारतोन कटुलते वाटसि येसुनगा तत्‍तुर. ओरा विस्वासमतुन हूळसि येसु लकवा बिमारतोन, “कोको, दैरनेम इर्रा. नीवा पापाल्क मापि आतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","अस्‍के हूळा, “ई मनकल पेनदा अपमानम कीसंतोर.” इंचि अगा मत्‍ता दर्मसास्‍त्रम कराहना गुरुल्क ओर-ओरे गुसगुसा इनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ओरा विचाराल्क एरपाट कीसि येसु ओर्कुन इल्‍हा इत्‍तोर, “मी मनसुने मिमेट कराब विचाराल्क बारि कींतिर? ");
INSERT INTO esg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","बद अल्कगा मंता? बिमारतोन, ‘नीवा पापाल्क मापि आतां इंचि इनमळा, हिलाकोंटे तेदिस ताका इनमळा?’ ");
INSERT INTO esg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","गानि मनकना रूपमते पुटतोन नाकु बूमिपोर्रोटा पापाल्कुन माप कियना अदिकारम मंता इंचि मिमेट एरपाट कियमळ गावाले,” इंचि इत्‍तोर. आ लकवा बिमारतोनगुडा “तेदसि कटुल पीसि लोन होन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ओर तेदसि लोन होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","अगा मत्‍ता लोकुल्‍कुंक अद हूळसि वेरियसि इचंत्रम आता. “इच्‍चोर पेद्‍दा अदिकारम पेन मनकालोर्कुंक हीता,” इंचि आ पेनदा स्‍तुति कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","आयंका येसु अगटाल होननेंके मत्‍तयाल इनना वरोर मनकल कर वसुल कियना नाकातगा उद्‍दिसि मत्‍तद हूळतोर. ओन नावा पज्जो वा! इंचि इत्‍तस्के ओर तेदसि ओना पज्जो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","पजा येसु मत्‍तयाना लोन गाटो तिंचेके मननेंके वेल्‍लेटुर कर वसुल कियानोर आनि पापि लोकुल्‍क वासि येसु आनि ओना सिस्युल्कुनतोनि गाटो तिनालय उदतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","अदुन हूळसि, “मी गुरु कर वसुल कियानोरतोनि आनि पापि लोकुल्‍कुनतोनि गाटो बारि तिंतोर?” इंचि परिसिल्क ओना सिस्युल्कुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","अस्‍के येसु अद केंजसि ओर्कुन इल्‍हा इत्‍तोर, “बिमार हिल्‍वोर्कुंक डाक्‍टरना अव्‍सरम मन्‍नो गानि बिमार मत्‍तोर्कुंक डाक्‍टरना अव्‍सरम मनंता. अदुनहाटीं, मिमेट होंट, होंचि ‘नना कोरानद दया आंद, मोक्‍कु आयो,’ इंचि दर्मसास्‍त्रमते रासि मनना पोल्‍लेता अर्तमतुन तेळियागोटकुंटु. बारित्‍ते नना नीतिमंतुल्‍कुन केयालय आयो गानि पापि लोकुल्‍कुन केयालय वातन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","आयंका बापतिस्मा हियना योहानुना सिस्युल्क येसुनगा वासि, “गुरु, परिसिल्क आनि मोमोट ऊके ओक्‍कापोद्‍दु मनंतोम गानि नीवा सिस्युल्क बस्‍केने ओक्‍कापोद्‍दु मन्‍नुर. अल्हा बारि?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","अस्‍के येसु ओर्क इल्‍हा वेहतोर, “मरमिन पेडल मरमिं वाता हेडमितोरतोनि मननेंके, ओर्कु दुक्‍कम आयाना अव्‍सरम मनंतना? मन्‍नो. गानि मरमिन पेडल ओरागटाल लक्‍कु आयाना रोजकु वायनुं, अस्‍के ओर ओक्‍कापोद्‍दु मनानुर.” ");
INSERT INTO esg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","पजा येसु ओर्कु रोंडु सिन्‍ना वेसुडिं वेहतोर. “बोरे आयिर, पडना कप्‍पिड हर्ते दानकु पूना कप्‍पिडता गंडा अंटा वाट्‍सि कुट्‍टोर. अल्हा कुट्‍टानय्ते अंटा वाटता कप्‍पिड गंडा पडना कप्‍पिडतुन इंकिच्‍चो हरहंता. ");
INSERT INTO esg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अल्‍हेने पूना अंगुर पानकमतुन पडना तोलपुर्काते बोरे दोस्सुर. ओक्‍कला दोस्‍सानय्ते आ तोलपुर्का पय्सि पानकम पोंगिस दांता आनि तोलपुर्कागुडा नासडेम आंता. इंचि पूना अंगुर पानकम पूना तोलपुर्कातेन दोसंतुर. अस्‍के रोंडुगुडा बेस मनंतां.” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","इव पोल्‍लें येसु ओरतोनि वळकसेके मन्‍नेंकेन, दर्मसास्‍त्रम कराहना लोता वरोर अदिकारि अगा वासि, “नावा मिय्यड इंदकेने हाता गुरु, गानि निमे वासि दानपोर्रो कय इरते, दान्क मर्रा जीवा अर्रंता,” इंचि येसुना काल्कुनपोर्रो अर्सि विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","अस्‍के येसु तेदसि, ओना सिस्युल्कुनतोनि आ अदिकारिन पज्जो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","होननेंके पन्‍नेंड वर्सानाल उंदेतीर कप्‍पिड आयना मुरतळ कलियता. कलियसि, “नना सिराप येसुना कप्‍पिडतुन इट्‍टिनागानि बेस आंतन,” इंचि दाना मनसुने इनकुत्‍ता. आनि पज्जोटाल वासि ओना कप्‍पिडता अंचुन इट्ता. ");
INSERT INTO esg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","इट्तारित्‍ते येसु पज्जो मल्सि हूळसि, “दैरनेम इर्रा पेगिटुना, नीवा विस्वासमे नीकुन बेस कीता,” इंचि इत्‍तोर. अस्‍केने अद बेस आता. ");
INSERT INTO esg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","पजा ओर दर्मसास्‍त्रम कराहना लोता अदिकारिना लोन होत्‍तस्के, हामुरता डोलकु-बाजें, लोकुल्‍क जमा आसि अळानद, मोत्‍कुनानद हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","अस्‍के येसु ओर्कुन “पलाते होंट पेगिड हाया हिल्‍ले, अद अय्ते मींडसि मंता.” इंचि इत्‍तोर. अस्‍के लोकुल्‍क येसुन कव्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","अगा मत्‍ता लोकुल्‍क पलाते पेय्सतारित्‍ते, येसु पेगिड मत्‍ता अर्राते होळियसि दाना कयदुन पीतोर अस्‍के अद तेदसि उद्‍दुता. ");
INSERT INTO esg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","अद पोल्‍ले पूरा एरिया अंता तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","येसु अगटाल पेय्सि होननेंके, इव्वुर गुड्‍डोर्क ओना पज्जो-पज्जो होंचि, “ए दाविद राजाना वंसमतोना! निमे मापोर्रो दया कीम.” इंचि वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","येसु लोता लोप्पो होळियतस्‍के ओर गुड्‍डिर ओनगा वातुर. अस्‍के येसु ओर्कुन, “नना बेस कींतन इंचि मीकु विस्वासम मंताना?” इत्‍तस्के, “हो सामि,” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","“अल्हा अय्ते मीवा विस्वासम मत्‍तापे आयि,” इंचि येसु ओरा कळ्‍कुन इटतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अस्‍केन ओरा कळ्‍कु दिसालय दल्‍गतां. पजा येसु ओर्कु, “इद पोल्‍ले बोर्के तेळियामन्‍नि.” इंचि गट्‍टिगा हुकुम हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","गानि ओर अगटाल होंचि, ओना बारेमते पूरा एरिया अंता तेळियागोटतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ओर इव्वुर अगटाल पेय्सि होननेंके, लोकुल्‍क वरोर देय्यम पीता मूकन येसुनगा तत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","येसु देय्यमतुन पेचाहतोर, अस्‍के मुन्‍ने वळकुवा मूकल वळकालय दल्‍गतोर. इदुन हूळसि अंटोर लोकुल्‍क इचंत्रमते, “इस्राएल देसेमते इल्‍हा आतद बस्‍केने हूळा हिल्‍लोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","गानि परिसिल्क, “ईर अय्ते देय्याल्कुना मुक्‍यना बलमते देय्याल्क तेंडांतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","पजा येसु अगाटा दर्मसास्‍त्रम कराहना लोतागा पेनदा पोल्‍लें कराहतोर. स्वर्ग राज्येम बारेमते बेसता कबुर वेहचेके, लोकुल्‍कुना अन्‍नि तीरकुना रोगाल्‍कुन, कमजोरिन बेस कीसेके अन्‍नि सहरकुने, नाह्कुने तिरियतोर. ");
INSERT INTO esg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","तिरियनेंके येसुन नदर लोकुल्‍कुनपोर्रो होत्‍ता. कोहानोर हिल्वा गोर्रें बल्हा तकांचि, सिल्‍लर-सिल्‍लर आसि मनांतंगो अल्हा आ लोकुल्‍क आसि मत्‍तुर, इंचि ओर्कुन हूळसि येसुंक दया वाता. ");
INSERT INTO esg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","अस्‍के ओर ओना सिस्युल्कुन “पंटा वेल्‍लेने पंडुता, गानि बूतिनोर तक्‍को मंतुर. ");
INSERT INTO esg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","अदुनहाटीं पंटाता मालकुंक बूतिनोर्कुन पंटा कोय्‍यालय लोहा इंचि विनंति कीम्‍टु,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","येसु ओना पन्‍नेंड सिस्युल्कुन दग्‍गेरा केय्‍सि, ओर्कु देय्याल्क गेदमना अदिकारम हीतोर. अचोने आयका अन्‍नि तीरकुना रोगाल्क, बादन बेस कियना अदिकारमगुडा हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","आ पन्‍नेंडु मंदि प्रेरितुल्कुना पोरोलीं इल्‍हा मंतां: मोदाला सिमोन (ओन पत्रुगुडा इंतुर), ओना तम्मुर अंदरियल, जब्‍दिना इव्वुर मर्क याकोब, योहान, ");
INSERT INTO esg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","पिलिप, बरतलमय, तोमल, कर वसुल कियना मत्‍तयाल, अल्‍पिना मर्रि याकोब, तद्‍दि, ");
INSERT INTO esg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सिमोन कनानि, इस्‍कारियोत यहुदल (ईरे येसुन पीसि हीतोर). ");
INSERT INTO esg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ई पन्‍नेंड मंदि सिस्युल्कुंक येसु इसोंटा हुकुम हीसि लोहचीतोर: यहुदि आयवोरा नड्‍डुम होनमट, सामरिया लोकुल्‍कुना बद्‍दे नाटेने होळियमट. ");
INSERT INTO esg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","दानकु बदुलु इस्राएलता तप्‍सोत्‍ता आ गोर्रेनहेके होंट. ");
INSERT INTO esg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","मिमेट होनानेंके, “स्वर्ग राज्येम दग्गेर्क एव्ता,” इंचि वेहासेक होंट. ");
INSERT INTO esg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","रोगाल्‍कुन बेस कीम्‍टु, हातोर्कुंक जीवा अरहट, कुस्‍टरोगम आतोर्कुन बेस कीम्‍टु, देय्याल्कुन गेदमिसिम्टु. मीकु ई हक्‍कु पुक्‍कटते दोर्कुता इंचि मिमेट इंका इसोंटा सेवा पुक्‍कटते कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","होननेंके मी नडिक बंगारम, एंडि, रागिता कोत्‍तां इरमट. ");
INSERT INTO esg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","जोरा ओयमट, एक्‍कोतव अंगिं, हेरपुह्क ओयमट. दुड्‍डुगुडा ओयमट. बारित्‍ते कबळ कियनोंक ओना बूति ओन्क दोर्कमळ गावाले. ");
INSERT INTO esg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","मिमेट मोदाला बद नाटे, बद सहरते अय्ते दांतिटो, अद नाटे वरोर बेसता मनकना बारेमते जाडा कीम्‍टु. मिमेट अगटाल पेय्सि होननाल ओना लोने मंटु. ");
INSERT INTO esg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","मिमेट लोते होळियनेंके, “सांति मन्‍निकांटी,” इंचि होळियट. ");
INSERT INTO esg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ओक्‍कला आ लोन बेसतद आते मिमेट हीता सांति अगा मनंता. गानि ओक्‍कला आ लोन बेसतद आयाकोंटे मिमेट हीता आ सांति मिहागेन वापस वांता. ");
INSERT INTO esg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","बोर अय्ते मीकुन लोप्पो वाया हिय्‍युरो मी पोल्‍लें केंजुरो अस्‍के ओना लोतालो मरि नाटेनालो पेय्सनेंके मिमेट मी कादा दुब्बा अग्गेन दुल्‍पिसि पेय्‍सट. ");
INSERT INTO esg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","नना मीकु निजम वेहासेक गदा, पेन न्‍यायम कियना रोजुने सदोम आनि गमोरा सहरकुना परिस्तिति आ नाह्‍कुंकन्‍ना बच्‍चोरो बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","हुळाट, तोडेल्‍लिन लोप्पो गोर्रेन लोहताप नना मीकुन लोहचंतन, इंचि मिमेट तरासुनलेसीं जेगर्ता आनि पावरेम पिट्‍टेनलेसीं इमानदार मंटु. ");
INSERT INTO esg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","मनकालोर मीकुन पंचादितोरा कय्‍दे अप्‍पजेपनुर आनि दर्मसास्‍त्रम कराहना लोह्कुने ओसि मीकुन पोट्‍टे देब्बांगुडा तना परांतुर. इंचि मिमेट मनकालोरागटालगुडा जेगर्ता मंटु. ");
INSERT INTO esg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","नाहेंका मीकुन ओर राज्यपाल आनि राजालोरा मुन्‍ने ओयानुर अस्‍के ओरा मुन्‍ने, विस्वासम कियवोरा मुन्‍ने नावा बारेमते मिमेट गवाइदार्क आकिट. ");
INSERT INTO esg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","वळकानोर मिमेट आयो मीलोप्‍पो मनना पेनबाबाना आत्मा आंद. अदुनहाटीं मीकुन बस्के अय्ते ओरा कय्‍दे अप्‍पजेपंतुरो अस्‍के अगा बतल वळ्कना, बतल वळ्‍कानायो इंचि रंदि कियमट. वेलापोर्रेन मिमेट बतल वळकुगोमो अद मीकु पेन वेहंता. ");
INSERT INTO esg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","कासा दादल-तम्मुह्‍क पगां आसि हव्कालय अप्‍पजेपनुर. पिलाल्क ओरा तल्‍लुर-बाबोंक अड्‍डम तिरियसि ओर्कुन हव्का वेहांतुर. ");
INSERT INTO esg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","नावा पोरोलताहेंका अंटोर लोकुल्‍क मीकुन हय्सुर. गानि बोर अय्ते आकिरदाका ओर्सकुंचेके ओप्के पीसि मनंतुर, ओर्के मुक्‍ति दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","मीकुन उंदि नाटे तकलिप हियानय्ते मिमेट इंकुंदि नाटे पेय्सि होंट. नना निजम वेहासेक मंतन, इस्राएलता अन्‍नि नाह्कुने तिरियसि पेनदा बेसता कबुर वेहामळ मारवा मुन्‍नेने मनकना रूपमते पुटतोन नना वांतन. ");
INSERT INTO esg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","गुरुंकन्‍ना सिस्युड पेद्‍दोड आयोर, अल्‍हेने मालकुंकन्‍ना जीतागाड पेद्‍दोड आयोर. ");
INSERT INTO esg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","सिराप सिस्युड गुरुनलेसीं, जीतागाड मालकुनालेसीं आयगोम अचोने सालु. ओक्‍कला लोता मालकुन नाकुने बेलजेबुल इनानय्ते, लोते मनना मीवद अंटोरद बद गति आयार! ");
INSERT INTO esg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","गानि ओर्कु मिमेट वेरियमट. मुच्‍चिसि मत्‍तव अन्‍नि पोल्‍लें बय्यर आंता, तेळियाकोंटा मत्‍तव अन्‍नि वस्‍तुक पलातुक वांतां. ");
INSERT INTO esg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","नना मीकु हीकटते वेहतवुन, मिमेट वेलगुने होंचि वेहट. नना मी केव्‍कुने वेहतवुन मिमेट येनागर्रापोर्रो एक्‍किसि वेहट. ");
INSERT INTO esg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","बोर अय्ते मीवा मेंदुल्तुन हव्का परांतुर गानि मी आत्मातुन हव्का परुर ओर्क मिमेट वेरियमट. गानि बोर अय्ते मेंदुल्तुन आनि आत्मातुन नरकमते वाट्‍सि नासडेम किया परांतोर ओन्‍के वेरियट. ");
INSERT INTO esg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","रोंडु कोळ्‍का पिट्‍टें रोंडु कोत्‍तांकु अम्मुड दांतां गदा! अय्नागानि पेनबाबाना इच्‍चा हिल्वा अवुनाल उंदिगुडा बूमिपोर्रो अर्रो. ");
INSERT INTO esg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","मीवा तल्‍लाता उंदि-उंदि केल्‍लु लेक्‍किस मंता. ");
INSERT INTO esg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","अदुनहाटीं वेरियमट! पेनदा मुन्‍ने मिमेट वेल्‍लेन कोळ्‍का पिट्‍टेंकन्‍ना बच्‍चोरो विल्‍वा मत्‍तोर आंदिर. ");
INSERT INTO esg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","बोर अय्ते लोकुल्‍कुना मुन्‍ने नाकुन एरपाट कींतन इंचि ओप्‍कुंतोरो, ओन ननागुडा स्वर्गमते मनना पेनबाबाना मुन्‍ने नावा सिस्युड इंचि ओप्‍कुंतन. ");
INSERT INTO esg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","गानि बोर अय्ते लोकुल्‍कुना मुन्‍ने नाकुन एरपाट किय्योन इंतोरो, ननागुडा ओन नावा स्वर्गमते मनना पेनबाबाना मुन्‍ने एरपाट किय्योन इंतन. ");
INSERT INTO esg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","नना इद बूमिपोर्रो सांति हियालय वातन इंचि इनकुनमट. मर्रिनद बाबोनतोनि अर्राकोंटा, मिय्‍याटद तल्‍लुनतोनि अर्राकोंटा आनि कोळियाटद पोरळतोनि अर्राकोंटा कियालय नना वातन. इंचि नना सांति हियालय आयो गानि ओर्कुन वेरे-वेरे कियालय वातन. ");
INSERT INTO esg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","मनकना पगातोर ओना लोतोर्के आयानुर. ");
INSERT INTO esg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","बोर अय्ते तल्‍लुर-बाबोन पोर्रो नाकन्‍ना एक्‍को पावरम कींतोर, ओर नावा सिस्युड आयनलायक हिल्‍लोर. बोर अय्ते मियाह्क-मर्कुन पोर्रो नाकन्‍ना एक्‍को पावरम कींतोर, ओरगुडा नावा सिस्युड आयनलायक हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","बोर अय्ते ओना सतता क्रुस पीसि नावा पज्जो वायोन इंतोर, ओरगुडा नावा सिस्युड आयनलायक हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","बोर अय्ते ओना जीवातुन पिसागोटालय हूळांतोर, ओर ओना जीवातुन पोगोटकुंतोर. बोर ओना जीवातुन नावाहाटीं पोगोटंतोर, ओन्क जीवा दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","बोर अय्ते मीकुन दग्‍गेरा कींतोर, ओर नाकुन दग्‍गेरा कीतापे. बोर अय्ते नाकुन दग्‍गेरा कींतोर, ओर नाकुन लोहता पेनदुनगुडा दग्‍गेरा कीतापे. ");
INSERT INTO esg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","बोर अय्ते पेनदा कबुरतोन, कबुरतोर इंचि ओप्‍कुंतोर ओन्क पेनदा कबुरतोंकु दोर्कना इनाम दोर्कंता. नीतिमंतुन नीतिमंतुड इंचि बोर ओप्‍कुंतोर ओन्क नीतिमंतुक दोर्कना इनाम दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ओक्‍कला बोरन्‍ना, ई सीदा-सादा सिस्युल्कुना लोप्पोटाल वरोंकु, नावा सिस्युड इंचि गिलासमेड सल्‍लाटेर उनालय हियानय्ते, नना मीक निजम वेहांतन, ओन्क तप्‍पाकोंटा इनाम दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","येसु ओना पन्‍नेंडु सिस्युल्कुंक आदेस हीतारित्‍ते, अगटाल पेय्सि गालिल एरियाता नाहकुने प्रचार कियालय आनि पेनदा पोल्‍लें कराहलय होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","बापतिस्मा हियना योहान जेलने मत्‍तस्के किरिस्‍तुना कबाह्‍कुना बारेमते केंजतोर. अस्‍के ओर ओना सिस्युल्कुंक इल्‍हा पूसकियालय येसुनहेके लोहतोर. “बोर अय्ते पिसागोटनोर वायानद मत्‍ता ओन निमेन ना? हिलाकोंटे मोमोट इंकावरोना एदुर हूळमळा?” ");
INSERT INTO esg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","येसु ओर्कु इल्‍हा जवाब हीतोर. “बतल अय्ते मिमेट केंजसंतिरो, हूळसंतिरो अवुन योहानुनगा होंचि वेहट. ");
INSERT INTO esg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","गुड्‍डोर्क हूळसंतुर, कुंटोर्क ताकसंतुर, कुस्‍टरोगम आतोर बेस आसंतुर, सेव्टोर्क केंजसंतुर, हातोर्कुंक जीवां अरसंतां आनि गरिबोर्कुंक बारे बेसता कबुर एवसंता. ");
INSERT INTO esg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","बोर अय्ते नावा बारेमते अन्‍समन्‍स किय्योर, ओन्‍के आसिर्वाद दोर्कंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","योहानुना सिस्युल्क अगटाल पेय्सि होत्‍तस्के, योहानुना बारेमते येसु लोकुल्‍कुंक इल्‍हा वेहालय दल्‍गतोर, “मिमेट बय्‍लि जेगाते बतल हूळालय होत्‍तिर? वळिक ऊंगना जाडितुना? ");
INSERT INTO esg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","मिमेट बतल हूळालय होंचि मत्‍तिर? मेत्‍तटा कपडिं केर्ता मनकन हूळालय होत्‍तिरा? मेत्‍तटा कपडिं केर्रानोर राजवाडाने मनांतुर. ");
INSERT INTO esg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","अय्ते मरि मिमेट बतल हूळालय होत्‍तिर? पेनदा कबुरतोन हूळालय होत्‍तिरा? हो. नना मीकु वेहासेक मंतन, मिमेट बोन अय्ते हूळतिर ओर पेनदा कबुरतोनकन्‍ना बच्‍चोरो पेद्‍दा मंतोर. ");
INSERT INTO esg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ओना बारेमते पेन इल्‍हा वेहचि मत्‍ता. हूळा! नना नीकन्‍ना मुन्‍नेने नावा कबुरतोन लोहंतन, ओर नीवाहाटीं हर्रि तयार कींतोर. इंचि दर्मसास्‍त्रमते रासि मंता.” ");
INSERT INTO esg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","नना मीकु निजम वेहासेक मंतन, पुट्तोराव्‍टेटाल बापतिस्मा हियना योहानुंकन्‍ना पेद्‍दा बोर पुट्‍टा हिल्‍लुर. अय्नागानि स्वर्ग राज्येमते सिन्‍ना मनकलगुडा योहानुंकन्‍ना पेद्‍दोडे. ");
INSERT INTO esg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","बापतिस्मा हियना योहानुना रोजकुनस्केटाल अय्ते इदवेरदाकागुडा लोकुल्‍क स्वर्गमते जबरदस्‍तिते होळियसेक मंतुर. गानि बदमास लोकुल्‍क मात्रम अड्‍डम तिरियसि आपालय हूळसंतुर. ");
INSERT INTO esg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","बारित्‍ते योहानुन दाका मूसाल आनि अंटोर पेनदा कबुरतोर स्वर्ग राज्येमता बारेमते बविस्यवानिं कीसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","मिमेटगिंटा अव बविस्यवानिन ओपकुनानय्ते, पेनदा कबुरतोर एलियाल वायनद मंता इंचि इत्‍तुर, ओर ईरे योहान आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","बोर्कु केंजालय केव्क मंतां ओर केंजट. ");
INSERT INTO esg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“गानि नना ई पीळिता लोकुल्‍कुन बोरा लोप्पो कल्‍पकन? मिमेट अय्ते बजारते उद्‍दिसि, वरोंक-वरोर केय्‍सि, ");
INSERT INTO esg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","मोमोट मीहाटीं तूरीला उह्कुतोम, गानि मिमेट एगरा हिल्‍लिर. मोमोट दुक्‍कमता पाटां पारतोम, गानि मिमेट अळा हिल्‍लिर, इंचि इनना पिलाल्कुनालेसीं मंतिर. ");
INSERT INTO esg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","बारित्‍ते योहान बतल तिनाकोंटा उनाकोंटा वातोर. अयना लोकुल्‍क मात्रम ओन देय्यम पीता इनुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","अल्हेन मनकना रूपमते पुटतोन नना तिंचेके-उंचेके वातन गानि लोकुल्‍क मात्रम, हुळाट, ईर बच्‍चोर तिंतोर, बच्‍चोर उंटोर? कर वसुल कियानोर आनि पापि लोकुल्‍क ईना दंटातोर आंदुर, इत्‍तुर. गानि पेनदा बुद्‍दि सत्‍तेमतद आंद इंचि, दाना बुद्‍दिते ताकानोर कियाना कबाह्‍कुन पोर्रोटाल तेळियंता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","आयंका येसु बव नाह्कुने एक्‍को अद्‍बूताल्‍क कीतोरो, आ नाहकुना लोकुल्‍क मनसु मार्सकुंचि पेनदाहेके तिरिया हिल्‍लुर. दानहाटीं येसु आ नाह्कुन पोर्रो दोसेम दोसतोर. ");
INSERT INTO esg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ए कोरजिना आनि बेतसेदा नाटेना लोकुरिटा, मीकु गोसा तप्‍पो! ओक्‍कला मिहगा बव अद्‍बूताल्‍क आतां, अवे गिंटा सूर, सिदोन नाह्कुने आसि मत्‍ते अगाटा लोकुल्‍क बिराना बोंतां हुट्‍सि, मेंदुल्क बूळ्‍दि होकसि, दुक्‍कमते मनसु मार्सकुंचि मन्‍नेर. ");
INSERT INTO esg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","गानि नना मीकु वेहासेक गदा, पेन न्‍यायम कियना रोजुने सूर आनि सिदोनतुरा परिस्तिति मीकन्‍ना बच्‍चोरो बेस मनंता.” ");
INSERT INTO esg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“ए कपर्नाहुम सहरता लोकुरिटा, मिमेट स्वर्गमते दांतोम इनकुंचंतिरा? मिमेट नरकमते दांतिर. ओक्‍कला मिहगा जर्गता अद्‍बूताल्‍क सदोम सहरते जर्गिसि मत्‍ते, अद सहर इदवेरादाका आगवड. ");
INSERT INTO esg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","गानि नना मीकु वेहासेक गदा, पेन न्‍यायम कियना रोजुने सदोम सहरता परिस्तिति मीकन्‍ना बच्‍चोरो बेस मनंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","आ वेलाते येसु इल्‍हा इत्‍तोर: “ए नावा बाबा, बूमि आनि स्वर्गमता सामि, तेल्‍विगल्‍लोर्क आनि समजदार लोकुल्‍कुनगटाल इव पोल्‍लें मक्‍किचि इरतिन, सादा-सिंपल लोकुल्‍कुंक बारे इव पोल्‍लें हुपिस्‍तिन, इंचि नना नीवा स्‍तुति कीसेक मंतन. ");
INSERT INTO esg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हो बाबा! नीकु इदे बेस अनपिस्ताहाटीं निमे इल्‍हा कीतिन.” ");
INSERT INTO esg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","मर्रा येसु लोकुल्‍कुनतोनि इल्‍हा वळकुतोर. “नावा बाबाल नाकु अन्‍नि अप्पजेपतोर. बाबान तप्‍पा मर्रिन बोरे एरपाट किय्युर, मर्रिन तप्‍पा बाबान बोरे एरपाट किय्युर. मर्रि ओना इस्‍टमाताप बाबाना बारेमते बोर्क अय्ते तेळियानाल वेहांतोर ओरे बाबान एरपाट कींतुर.” ");
INSERT INTO esg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“अरे बर्वु कांजसि नेरबडता लोकुल्‍कुनिटा! मिमेट अंटोर नाहेके वट, नना मीकु आराम हींतन. ");
INSERT INTO esg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","ना कांडी मिमेट तेहाकुंचि नावातोनि करियट, नना बेस आनि सादा-सिंपल मंतन. इंका नावा कांडी सवरगा मंता नावा बर्वु अल्कगा मंता. इंचि मी आत्माकु सांति दोर्कंता.” ");
INSERT INTO esg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","उंदि नोमकेम रोजुने येसु आनि सिस्युल्क पोलाल्‍कुनाल होंचेके मत्‍तुर. अस्‍के सिस्युल्कुंक कर्वेस्‍सि मत्‍ताहेंके हेनकु नल्‍सि तिंचेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","परिसिल्क अदुन हूळसि, “हूळा! नोमकेम रोजुने बद कबळ अय्ते कियमळ नियम परकारम ओज्‍जोनो, अदे कबळ नीवा सिस्युल्क कीसंतुर,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","अस्‍के येसु ओर्कुन, “दाविदुंक आनि ओना दंटातोर्कुंक कर्वेस्‍तस्‍के ओर बतल कीतोर, मिमेट हदवा हिल्‍लिरा? ");
INSERT INTO esg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ओर पेनदा गुळिते होळियसि, पेनदुक मोळ्कता हारिन अंटोर तित्‍तुर. अव हारिं तिनमळ इत्‍ते दर्मसास्‍त्रम परकारम विरोदमते मत्‍ता. अव हारिं सिराप पेर्मालोर्क तप्‍पा इंका बोरे तिना पर्रुर. ");
INSERT INTO esg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","अचोने आयका पेर्मालोर्क नोमकेमता रोजु गुळिते कबळ कींतुर इत्‍ता संगति मूसाना नियमते मंता इद मीकु एर्के मंता. अल्हा कियमळ तप्पु आयो. ");
INSERT INTO esg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","8","नना कोरानद दया आंद, मोक्‍कु आयो, इंचि दर्मसास्‍त्रमते रासि मनना पोल्‍लेना अर्तम मीकु तेळियसि मत्‍ते ई दोसेम हिल्वोरपोर्रो मिमेट दोसेम दोस्‍सा कोन्‍नेर. नना वेहनद बतल इत्‍ते, गुळिकन्‍ना पेद्‍दोड वरोर इगे मंतोर. बारित्‍ते मनकना रूपमते पुटतोन नना, नोमकेमता रोजुना मालकगुडा आंदुन.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","येसु अगटाल पेय्सि यहुदिल्कुना दर्मसास्‍त्रम कराहना लोते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","अगा वरोर कय वत्‍सोत्‍ता मनकल मत्‍तोर. येसुन बल्हा तप्पुने पियना इंचि, “नियम परकारम, नोमकेम रोजुने बोनना बेस कियमळ बेसा, बेस आयोना?” इंचि परिसिल्क ओन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “मिहागटाल बोनागन्‍ना उंदि गोर्रे मंता इनकुंटु, अदगिंटा नोमकेम रोजुने पोक्‍काते अर्रानय्ते दान तेंडिरा? तेंडांतिर! ");
INSERT INTO esg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","इगे अय्ते, गोर्रेकन्‍ना मनकना जीवाक बच्‍चोरो विलवा मंता! अदुनहाटीं दर्मसास्‍त्रम परकारम नोमकेम रोजुने बेस किया परांतिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","अस्‍के येसु, “नीवा कय मुन्‍नेळ्‍क हहा,” इंचि कय वत्‍सोत्‍तोन इत्‍तोर. ओर कय मुन्‍नेळ्‍क हाहतस्‍के अद कय इंकुंदि कयदालेसीं बेस आता. ");
INSERT INTO esg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","पजा परिसिल्क अगटाल पलाते पेय्‍स्‍तुर. पेय्सि, येसुन बल्हा हव्कना? इंचि येसुना विरोदमते वळ्‍क्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ओर वळकानद कन्‍कुंचि येसु अगटाल पेय्सि होत्‍तोर. वेल्‍लेटुर लोकुल्‍क ओना पज्जो होत्‍तुर. अस्‍के येसु ओर्कुन अंटोर्कुन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","पजा, “नावा बारेमते बोर्के बतले वेहमट इंचि अंटोर्क हुकुम हीतोर.” ");
INSERT INTO esg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","इत्‍ते यसायाह इनना पेनदा कबुरतोर इत्‍तव पोल्‍लें पूरा आयना इंचि येसु सामि इल्‍हा कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","यसयाना बविस्यवानि इल्‍हा मत्‍ता: “ईर नावा सेवक आंदुर, ईन नना पेर्कुत्‍तन. नना ईन पावरम कींतन ईना बारेमते कूस मंतन. नना नावा पवित्र आत्मा ईना पोर्रो इर्रंतन, ईर नावा न्‍यायमतुन अन्‍नि जातिनोर्क वेहांतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ईर बोनतोने तेरहानोर आयोर, जोरते वरगेयानोर आयोर, हरकुन पीसि लोकुल्‍कुंक ईना अल्किर केंजा वायो. ");
INSERT INTO esg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","नावा न्‍यायम गेल्सनाजेम ईर दुरसोत्‍ता बोंगुनगुडा उरहोरु, इंका पिर्रना वेडसितुनगुडा पिरहोर. ");
INSERT INTO esg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","दानहाटीं अन्‍नि जातिनोर ईना पोरोलते आसेते मंदनुर.” ");
INSERT INTO esg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","पजा वरोर देय्यम पीता गुड्‍डि-मूकन लोकुल्‍क येसुनगा तत्‍तुर. येसु ओन बेस कीतोर. अस्‍के आ मनकल हूळालय-वळकालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","इदुन हूळसि अगाटा अंटोर लोकुल्‍क इचंत्रमते, “वरोर दाविद राजाना तंतुने पुट्‍टनोर मत्‍तोर, ओर ईरे आयोर गदा?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","गानि अगा मत्‍ता परिसिल्क दीन केंजसि, “ईर अय्ते बेलजेबुल इनना देय्याल्कुना मुक्‍यना बलमते देय्याल्क तेंडांतोर” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","परिसिल्कुना मनसुना विचाराल्कुन एरपाट कीसि येसु ओर्कुन इल्‍हा इत्‍तोर, “बद राज्येम लोप्पो वरोना पोल्‍ले-वरोंक अर्राकोंटा आंता, अद राज्येम पाडासि दांता. अल्‍हेने लोते आयि, नाटे आयि वरोना पोल्‍ले-वरोंक अर्राकोंटे बतले नित्‍तापर्रो. ");
INSERT INTO esg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अल्‍हेने देय्यम दाना दंटाता देय्याल्कुन पेचाह्‍चि गेदुमते, अवुना लोप्पेन अर्राकोंटा आंता. अस्‍के अवुना राज्येम बल्हा नित्‍तंता? ");
INSERT INTO esg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","मिमेट इत्‍ताप नना ओक्‍कला बेलजेबुलना सहायमते देय्याल्कुन गेदमंतन इन्‍कुंटु. गानि मीवा लोकुल्‍कगुडा देय्याल्कुन गेदमंतुर, ओरगुडा देय्यमता सहायमतोने गेदमंतुरा? अदुनहाटीं मीवा लोकुल्‍के मीवा न्‍यायम कींतुर. ");
INSERT INTO esg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","गानि नना ओक्‍कला पेनदा आत्माता सहायमते देय्याल्कुन गेदमानय्ते, पेनदा राज्येम मीवा दग्गेर्क एव्ता इंचि एरपाट कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","बोरे आयिर, वरोर ताकतवर मनकना लोते होळियसि ओना सामानतुन दोंगा कियना इत्‍ते, मोदाला आ ताकतवर मनकन दोहचि वाटतेन, दोंगा किया परांतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","बोर अय्ते नावा दंटाते मन्‍नोर, ओर नावा विरोदमते मंतोर, बोर अय्ते नाकु सहायम किय्योर, ओर नाहगटाल पायिचना कबळ कींतोर.” ");
INSERT INTO esg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","नना मीकु वेहनद बतल इत्‍ते, मनकना अन्‍नि पापाल्कुन, ओर कीता अपमानमतुन पेन मापि किय्‍यार. गानि पवित्र आत्माता अपमानम कियानोन मात्रम पेन माप किय्‍यो. ");
INSERT INTO esg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","अल्‍हेने मनकना रूपमते पुटतोन नाकु विरोदमते बोर वळ्‍किना, पेन ओना तप्‍पुकुन मापि किय्‍यार. गानि पवित्र आत्माकु विरोदमते वळ्‍कानोन मात्रम पेन माप किय्‍यो. इद कालमते आयि, वायना कालमते आयि, बस्‍केने माप किय्‍यो. ");
INSERT INTO esg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","पजा येसु परिसिल्कुनतोनि इल्‍हा वळकालय दल्‍गुतोर. “केंजट, पंडितुन हूळसे मिमेट मरातुन एरपाट कीकिर, मरा बेसतद इत्‍ते दाना कायां इंका बेसतवे. अल्‍हेने मरा कराबतद इत्‍ते दाना कायां इंका कराबतवे. ");
INSERT INTO esg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ए कट्‍ला तरास पोरिह्कुनसंटोरिटा, मिमेट कराबतोर आसि, मीवा तोळ्‍दाल बेसतां पोल्‍लें बल्हा पेय्‍सनुं? बारित्‍ते मनसुने मनना पोल्‍लेंगे तोळ्‍दाल पलाते पेय्‍संतां. ");
INSERT INTO esg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","बेसता मनकल ओना मनसुने मनना बेसता पोल्‍लेंगे पेच्‍हांतोर, अल्‍हेने कराब मनकल ओना मनसुने मनना कराब पोल्‍लेंगे पेच्‍हांतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","इंका नना मीकु वेहानद बतल इत्‍ते, पज्जो-मुन्‍ने विचारम कियाका मीवा तोळ्‍दाल पेय्सता उंद-उंदि वट्‍टि पोल्‍लेता लेक्‍का आकिर न्‍यायम कियना रोजु पेन मीवाहेंदाल एतार. ");
INSERT INTO esg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","मी पोल्‍लेना पोर्रोटाले मिमेट दोसेम हिल्‍वोरा लेक्‍काते वांतिर, इंका मिमेट वळ्कता पोल्‍लेना पोर्रोटाले मीपोर्रो दोसेम दोसमळ जर्गंता.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","अस्‍के इच्‍चुर परिसिल्क आनि दर्मसास्‍त्रम कराहना गुरुल्क येसुनगा वासि, “गुरु, नीवा कयदाल माकु उंदि चिन्‍ह हूळना मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “सेड्‍डोर्क आनि बोगमतनम कियाना पीळिता लोकुल्‍क, चिन्‍ह हुप्‍सा इंतुर. गानि योनाल इनना पेनदा कबुरतोना चिन्‍ह तप्‍पा ओर्कु इंकुंदि चिन्‍ह हुपिच्‍मळ जर्गो. ");
INSERT INTO esg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","इत्‍ते योनाल बल्हा नर्का-पिय्यल मूड रोजकु पेद्‍दा जिम्माता पीटा लोप्पो मत्‍तोर, अल्‍हेने मनकना रूपमते पुटतोन नना, नर्का-पिय्यल मूड रोजकु बूमिता पीटा लोप्पो मनंतन. ");
INSERT INTO esg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","योनाल वेहता कबुर केंजसि निनवे सहरतोर अय्ते ओरा मनसु मार्सकुत्‍तुर. गानि हुळाट, योनांकन्‍ना पेद्‍दोड इंदके मी मुन्‍ने नित्‍तिसि मंतोर. अय्नागानि मिमेट मनसु मार्सकुंचेके हिल्‍लिर. अदुनहाटीं आकिर न्‍यायमता रोजुने निनवे सहरतोर नित्‍तिसि इद पीळिता लोकुल्‍कुनपोर्रो दोसेम दोस्‍सनुर.” ");
INSERT INTO esg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“अल्‍हेने सिबा देसेमता रानि सुलेमान राजाना तेल्‍विता पोल्‍लें केंजालय वेरे देसेमताल अगा वासि मत्‍ता. हुळाट, सुलेमानुंकन्‍ना पेद्‍दोड वरोर मी मुन्‍ने नित्‍तिसि मंतोर. अय्नागानि मिमेट नावा बुद्‍दिता पोल्‍लें केंजसेक हिल्‍लिर. अदुनहाटीं आकिर न्‍यायमता रोजुने आ रानि इद पीळिता लोकुल्‍कुनपोर्रो दोसेम दोस्‍सार.” ");
INSERT INTO esg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“उंदि देय्यम बस्के अय्ते वरोर मनकानाल पेय्सि दांता, अस्‍के अद आराम कियालय एर हिल्वा जेगा पह्‍कंता, गानि दान्क असंटा जेगा दोर्को. ");
INSERT INTO esg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","अस्‍के अद देय्यम, ‘नना बद लोताल अय्ते पेय्सि वातानो, अदे लोते मर्रा मल्सि दांतन,’ इन्‍कुंता. मर्रा अगा होंचि हूळतस्‍के मुन्‍नेटा लोन रिकम आताप, मंचिगा ऊसताप दानकु बेस दिसंता. ");
INSERT INTO esg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","अस्‍के अद देय्यम तिरियसि होंचि दानकन्‍ना एक्‍को सेड्‍डातव एडुं देय्याल्कुन पीसि वांता. पजा अंटव कलियसि अदे लोते मनालय दल्‍गंतां. इल्‍हा आ मनकना परिस्तिति मोदाटा परिस्तितिकन्‍ना एक्‍को कराब मनंता. इद कालमता लोकुल्‍कुना जीवाते पेनदा पोल्‍लेक जेगा हिलाकोंटे इसोंटा गोसे आयार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","मंदितोनि येसु वळ्कसेक मननेंके ओना यावल, ओना तम्मुह्‍क वासि, ओनतोनि वळकानद मंता इंचि लोता पलाते नित्‍तिसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","अस्‍के, “गुरु, नीवा यावल, नीवा तम्मुह्‍क नीतोनि वळकानद मंता इंचि पलाते नित्‍तिसि मंतुर,” इंचि बोरो येसुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","अस्‍के, “बद ना यावल, बोर ना तम्मुह्‍क?” इंचि येसु ओन्क वेहता मनकन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","पजा ओना सिस्युल्कुनहेके कय हुपिच्‍चि, “हुळाट, ईरे ना यावल, ईरे ना तम्मुह्‍क आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","बोर अय्ते नावा स्वर्गमता बाबाल वेहताप ताकंतोर, ओरे नावा तम्मुर, हेलड आनि यावनलेसीं दग्‍गेटोर आंदुर,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","अदे रोजु येसु लोताल पेय्सि समुद्रम ओड्‍डुनगा होंचि उदतोर. ");
INSERT INTO esg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","वेल्‍लेटुर लोकुल्‍क ओनगा जमा आताहेंका ओर उंदि डोंगा एक्‍किस उदतोर. लोकुल्‍क बारे ओना मुन्‍ने समुद्रम ओड्‍डुनपोर्रो नित्‍तिसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","अस्‍के ओर वेल्‍लेन पोल्‍लें वेसुडिं वेहासेक कराहतोर. अव्टेटाल उंदि वेसुडि इल्‍हा मंता: “केंजट, वरोर कास्‍तकरि मनकल विज्‍जां वीतालय पेय्‍स्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ओर वीतनेंके इच्‍चुं विज्‍जां हरदगा अरतां, अस्‍के अवुन पिट्‍टें वासि पेर्सि तित्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","इच्‍चुं विज्‍जां बंडाना गेर्सेपोर्रो अरतां. अगा तोळि एक्‍को हिलुवादानकु आ विज्‍जां बिराने मोलियतां. ");
INSERT INTO esg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","गानि हिह्‍कु लोप्‍पोळ्‍क होनवाहेंका पोळ्‍द पेय्‍स्‍तस्‍के मोल्‍कां वत्‍सि हासोत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","इंका इच्‍चुं विज्‍जां हाह्कुना पोदाने अरतां. हाह्कुना पोदां इरगा बेर्सि अव विज्‍जन बेर्सा हिया हिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","इच्‍चुं विज्‍जां बेसता जेगाते अरतां. बेस पंटा पेय्‍स्‍ता. अव उंद-उंदि मोदोल्कु बगा मुप्‍पै अंताल्‍क, बगा अरवै अंताल्‍क, बगा नूर अंताल्कुना पंटा पेय्‍स्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","बोर्कु केंजालय केव्क मंतां ओर केंजट.” ");
INSERT INTO esg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","पजा सिस्युल्क ओनगा वासि, “गुरु, निमे लोकुल्‍कुनतोनि वळकानेंके वेसुडिं वेहासेक बारि वळकांतिन?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","येसु अस्‍के ओर्कु इल्‍हा वेहतोर. “मीक अय्ते स्वर्ग राज्येमता बारेमता मर्ममतुन एरपाट कीकुनालय बुद्‍दि मंता, गानि ओर्कु हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","बारित्‍ते, बोनगा अय्ते मंता, ओन्क पेन इंका हींता, अस्‍के ओन्क वेल्‍लेन आंता. गानि बोनगा अय्ते हिल्‍ले, ओनागटाल मात्रम मत्‍तदुनगुडा पेन वापस एतकुन्‍नार. ");
INSERT INTO esg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ओर हूळुळ अय्ते हूळंतुर, गानि ओर्कु अद दिस अर्रो. ओर केंजुड अय्ते केंजांतुर, गानि ओर्कु केंजा वायो, अद ओर्कु तेळियोगुडा. अदुनहाटीं नना वेसुडिं वेहासेक ओरतोनि वळ्‍कंतन. ");
INSERT INTO esg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","यसायाह इनानोर ओरा बारेमते रासतद पेनदा पोल्‍ले इंदके इल्‍हा निजम आता: “मिमेट केंजंतिर निजमे, गानि बस्‍केने अर्तम कीकुन्‍निर. कळ्‍कुने हूळंतिर, गानि अद मीकु तोसो. ");
INSERT INTO esg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ओर कळ्‍कुने हूळसि, केव्‍कुने केंजसि, मनसुनाल अर्तम कीकुंचि नाहेके तिरियतस्के ओर्कुन नना बेस कीकन. इल्‍हा बस्‍केने जर्गामन्‍नि इंचि ओरा मनसु गट्‍टि पडता, केव्क बारे मंदोम आसि केंजा वायाकोंटा आतां, कळ्‍कुन बारे मुचकुतुर.” इद पोल्‍ले नावां केंजवोरा बारेमते निजम आता. ");
INSERT INTO esg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","गानि मीवा कळ्‍कु हुळंतां, केव्क केंजंतां इंचि मिमेट आसिर्वाद दोर्कतोर आंदिर. ");
INSERT INTO esg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","नना मीकु निजम वेहांतन, इय्याला मिमेट बव हूळसंतिरो, केंजसंतिरो, अवुन वेल्‍लेटुर पेनदा कबुरतोर आनि नीतिमंतुल्क हूळालय, केंजालय तन्‍लाळुंदुर. गानि ओर्क हूळालय, केंजालय दोर्काहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","मिमेट इंदके विज्‍जां वीतानोना वेसुडिता अर्तम केंजट. ");
INSERT INTO esg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","स्वर्ग राज्येमता बारेमता कबुरतुन केंजसि बोर दान अर्तम कीकुन्‍नोर, ओना मनसुने बतल अय्ते वीतिस मत्‍तनो अदुन देय्यम वासि इग्‍गिस ओंता. आ लोकुल्‍क इत्‍ते विज्‍जां अरता हर्दा जेगातसंटोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","बोर अय्ते पेनदा पोल्‍लेतुन केंजसि कूस आसि बिराना दान ओप्‍कुंतोर, ओर इत्‍ते विज्‍जां अरता बंडाना गेर्से जेगातसंटोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ओनालोप्‍पो पेनदा पोल्‍लेता हिह्‍कु गट्‍टि पळुवाहाटीं, ओर कोन्‍नि रोजके अव्टे निल्‍सि मनांतोर. पजा पेनदा पोल्‍लेताहाटीं तिप्‍पल्‍क, कस्‍टाल्‍क वातस्के, विस्वासमताल ओर बिराना लक्‍कु आंतोर. ");
INSERT INTO esg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","बोर अय्ते पेनदा पोल्‍लेतुन केंजांतोर गानि सम्‍सारमता रंदि, दनमता आस्‍ति, इसोंटा विचाराल्क ओर केंजता पोल्‍लेतुन ओनालोप्‍पो बेर्सा हिय्यों. अस्‍के अद पोल्‍लेताल बतल पायदा आयो. असंटोर इत्‍ते, विज्‍जां अरता हाह्कुना पोदाना जेगातसंटोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","बोर अय्ते पेनदा पोल्‍लेतुन केंजसि, ओप्‍कुंचि तेळियागोटकुंतोर, ओर इत्‍ते विज्‍जां अरता बेसता जेगातसंटोर आंदुर. ओर बेस पायदा तरांतोर. बगा मुप्‍पै अंताल्‍क, बगा अरवै अंताल्‍क, बगा नूर अंताल्‍क इल्‍हा पलांचंतोर. ");
INSERT INTO esg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","येसु इंकुंदि वेसुडि वेहतोर. बोर मनकल अय्ते ओना पोलमते गोह्कुना बेस विज्‍जां वीततोर, आ मनकन लेह्का स्वर्ग राज्येम मंता. ");
INSERT INTO esg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","गानि अंटोर लोकुल्‍क मींडतद हूळसि ओना पगातोर वासि गोह्कुने हकोलिं वीतिस होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","पजा गोह्कु मोलिय्सि पोट्‍टाक वासि मियतां, हकोलिं इंका दिसतां. ");
INSERT INTO esg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","अस्‍के नेदा मालकुनगा जीतागाह्‍क वासि, “मालक, निमे अय्ते नीवा नेदे बेसता विज्‍जां वीत्सि मत्‍तिन गदा? मरि अगा हकोलिं बेंदाल वातां?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","अस्‍के “इदु बोरो पगातोर कीता कबळ आंद.” इंचि मालक इत्‍तोर. “अय्ते निमे बतल इंतिन मरि, मोमोट होंचि हकोलितुन पीक्‍सि पोहकोमा?” इंचि जीतागाह्‍क मालकुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","अस्‍के मालक, “मन्‍नि, हकोलितुन पीकनेंके गोह्कुनगिंटा पीकिकिट! ");
INSERT INTO esg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","कोताक वयनदाका अव रोंडुगुडा कलियसे बेर्सिंकांटी. पजा कोताक वातस्के कोय्यानोर्कुंक नना, ‘मुन्‍ने हकोलिन कोय्‍सि, हेरकीं दोहाचि अवुन बोडसि पोहट. पजा नावा गोह्कुन जमा कीसि गुम्मिते दोस्सटु इंतन,’ इंचि जीतागाह्कुंकु वेहतोर.” ");
INSERT INTO esg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","पजा येसु ओर्कु इंकुंदि वेसुडि वेहतोर. “स्वर्ग राज्येम, आवाल्‍कुना उंदि पेडेतसोंटद आंद. आ पेडेतुन बोरो वरोर मनकल ओसि, ओना तोटाते वीततोर. ");
INSERT INTO esg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","आवाल्‍कुना पेळे अन्‍नि पेडेकुंकन्‍ना सिन्‍नागा मनंता, गानि बेरस्तस्के अद तोटाते मनना अन्‍नि मराकुंकन्‍ना पेद्‍दा मरा आंता. मब्बुने परियना पिट्‍टें वासि दाना कोम्मांक गूडां दोहंतां.” ");
INSERT INTO esg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","येसु पजा ओर्कु इंकुंदि वेसुडि वेहतोर. “स्वर्ग राज्येम पुल्‍लटा पिंडितसोंटद आंद. बदो उंदि मुरतळ पुल्‍लटा इच्‍चुर पिंडितुन मूड तव्‍वना पिंडिते कल्‍पता. अय्ते मेल्‍लगा-मेल्‍लगा आ पूरा पिंडिअंता पुल्‍लगा आता.” ");
INSERT INTO esg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","इव अन्‍नि पोल्‍लें येसु लोकुल्‍कुंक वेसुडिनेन वेहतोर. वेसुडि वेहाका ओर्कु बतले वेहाकोंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","बारित्‍ते पेनदा कबुरतोराहेंदाल मुन्‍ने वेहचि मत्‍ता पोल्‍ले इंदके निजम आता, अद पोल्‍ले इल्‍हा मंता: “नना नावा तोळ्‍दे वेसुडिं वेहंतन. दुनिया पुट्‍तस्‍केटाल मक्‍सि मत्‍ता पोल्‍लेन नना वळ्‍किसि वेहंतन.” ");
INSERT INTO esg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","पजा येसु लोकुल्‍कुन होळसिसि लोन होत्‍तोर. अस्‍के सिस्युल्क ओनगा वासि, “गुरु, पोलमते वीतता हकोलिता वेसुडतुन माकु तेळियागोट्‍सि वेहा.” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","अस्‍के येसु ओर्कु इल्‍हा वेहतोर. “केंजट, बेसता विज्‍जां वीतानोर इत्‍ते मनकना रूपमते पुटतोन नना आंदुन. ");
INSERT INTO esg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","पोलम इत्‍ते ई दुनिया आंदु. आनि बेसता विज्‍जां इत्‍ते पेनदुन ‘मावा राजाल’ इंचि विस्वासम कीतोर, हकोलिं इत्‍ते देय्याल्कुन पोल्‍लें केंजानोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","हकोलिं वीतुता पगातोर इत्‍ते, देय्यम आंद. पंटा कोयना वेला इत्‍ते दुनिया मुंळगना आकिर वेला. कोय्‍यानोर इत्‍ते पेनदा दूतां आंद. ");
INSERT INTO esg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","अस्‍के बल्हा हकोलितुन कोयसि, जमा कीसि तडमि दोसतुर, अल्‍हेने इद दुनिया मुंळगना आकिर वेलाते आयार. ");
INSERT INTO esg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","बारित्‍ते अद वेलाते मनकना रूपमते पुटतोन नना, नावा दूतन लोहंतन. अव नावा राज्येमते मनना पापिर्कुन आनि पापम किया वेहानोर्कुन अंटोर्कुन पेच्‍हासि, ");
INSERT INTO esg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","बस्‍केने पिर्रकोंटा पोत्‍तना तडमिते वाटसींतां. अगा बस्‍केळ्‍क अळमळ, किटुर-किटुर पल्कु कोर्कमळे मनंता. ");
INSERT INTO esg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","अस्‍के नीतिमंतुल्क बोर अय्ते मंतुरो ओर ओरा पेनबाबाना राज्येमते पोळ्‍दुन लेह्का मेर्सेके मनांतुर. बोर्कु केंजालय केव्क मंतां ओर केंजट.” ");
INSERT INTO esg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","स्वर्ग राज्येम बारेमते इंकुंदि वेसुड वेहंतन केंजट. उंदि पोलमते दनम मक्‍किचि मत्‍ता. बोरो वरोर मनकल आ मक्‍किचि मत्‍ता दनमतुन हूळतोर. आनि मर्रा अग्गेन मक्‍किचि इरगा कूस आसि लोन होत्‍तोर. पजा ओर ओना लोन मत्‍तद-हिलवद अन्‍नि अमकुंचि वाता कोत्‍ताने अद पोलमतुन असकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","स्वर्ग राज्येम बारेमते इंकुंदि वेसुड वेहासेक केंजट. वरोर व्यापारि बेसता मुच्‍च्याल्‍क पहकसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","अय्ते ओन्क उंदि वेल्‍ले दराता मुच्येम दिसता, अस्‍के ओर लोन होंचि ओनगा मत्‍तद-हिलवद अन्‍नि अमकुंचि वाता कोत्‍ताने अद मुच्येमतुन असकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“स्वर्ग राज्येम बारेमते मर्रा उंदि वेसुड वेहासेक केंजट. उंदि ओल्‍ला मत्‍ता. अद ओल्‍लातुन बेरेडते इसुरतस्के अन्‍नि रकाल्कुना मीन्कु अरतां. ");
INSERT INTO esg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ओल्‍लामेड मीन्कु अरतस्के, मीन्कु पिय्‍यानोर दान ओड्‍डुंक इग्गुतुर बेसतवुन पेर्सि तोत्‍तिते वाटतुर, अल्‍हेने कराबतवुन बारे पोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","इद दुनिया मुंळगना आकिर वेलातेगुडा अल्हेन आयार. पेनदा दूतां वासि, सेड्‍डोर्कुन नीतिमंतुल्‍कुनाल वेरे कींता. ");
INSERT INTO esg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","कीसि ओर्कुन बस्‍केने पिर्रकोंटा पोत्‍तना तडमिते वाटसींतां. अगा बस्‍केळ्‍क अळमळ, किटुर-किटुर पल्कु कोर्कमळे मनंता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","पजा “इव अन्‍नि पोल्‍लें मीकु तेळियतंगा?” इंचि येसु सिस्युल्कुन पूसकीतोर. अस्‍के “हां गुरु, माकु तेळियतां,” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","अस्‍के येसु “बोर मनकल अय्ते ओना कजानाताल पूनद-पळानद सोम्मुन पलाते पेच्‍हांतोर, आ मनकन लेह्कने स्वर्ग राज्येमता सिस्युड मत्‍ता हरेक दर्मसास्‍त्रम कराहना गुरु मनांतोर, ओर यहुदि लोकुल्‍कुना पडाना आनि पूना बोदा रोंडु इंका करहा परांतोर.” इंचि ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","पजा इव वेसुडिं वेहमळ महासि येसु अगटाल पेय्सतोर. ");
INSERT INTO esg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ओना नार वासि अगाटा दर्मसास्‍त्रम कराहना लोते होंचि लोकुल्‍कुंक पेनदा पोल्‍लें कराहलय दल्‍गतोर. अस्‍के अव पोल्‍लें केंजसि अंटोर लोकुल्‍क इचंत्रम आसि, “ईनकु इच्‍चोर बुद्‍दि, अद्‍बूताल्‍क कियना ताकत, बगटाल दोर्कता? ");
INSERT INTO esg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ईर अय्ते वडलना मर्रे गदा? ईना तल्‍लुर अय्ते मरियमे आंद, इंका याकोब, योसेप, सिमोन, यहुदल ईर अय्ते ईना तम्मुह्के आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","अचोने आयका ईना हेलाह्कगुडा मना नड्‍डुमे मंतां. अय्ते मरि ईन्कु इवन्‍नि पोल्‍लें, कबाह्‍क बोर हीतुर?” इंचि नाटेनोर वळ्ककुनुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","अदुनहाटीं ओर येसुनपोर्रो होंग आतुर. अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “पेनदा कबुरतोंकु ओना नाटे, ओना लोते तप्‍पा दुनियांता कदर दोर्कंता.” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ओर विस्वासम कियवाहाटीं अगा येसु वेल्‍ले अद्‍बूतामाता कबाह्‍क किया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","अद वेलाते गालिल एरियाता राजाल, हेरोद इनानोर, येसुना बारेमते केंजतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","केंजसि “ई येसु इत्‍ते बापतिस्मा हियना योहान आंदुर. ओर हातोराव्टेटाल मर्रा तेदतोर. अदुनहाटीं ओर इसंटा अद्‍बूतामाता कबाह्‍क कीसंतोर.” इंचि ओना सेवाकुल्कुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","बारित्‍ते हेरोद राजाल ओना तम्मुर पिलिपुना मुत्‍तो हेरोदियान इरकुंचि मत्‍तोर अस्‍के, “नीवा तम्मुना मुत्‍तोन निमे निहगा इरमळ नियम परकारम बेस आयो,” इंचि योहान हेरोद राजांक वेहचि मत्‍तोर. अदुनहाटीं हेरोद राजाल योहानुंक बेडीं वाटसि ओन जेलने वाटतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","अस्‍केटाल हेरोद राजाल योहानुन हव्कालय कोरसेके मत्‍तोर, गानि लोकुल्‍क योहानुन पेनदा कबुरतोर इंचि नम्मुंदुर, अदुनहेंके राजाल लोकुल्‍कुंक वेरियसि योहानुन हव्काकोंदुर. ");
INSERT INTO esg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","गानि हेरोद राजाना पुटता रोजु मत्‍तस्के अगा हेरोदियाना मिय्यड लोकुल्‍कुन मुन्‍ने एगरिसि ओन कूस कीता. ");
INSERT INTO esg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","अस्‍के राजाल कूस आसि, “निमे बतल तल्कंतिन अद नीकु हींतन” इंचि ओट्‍टु तिंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","अस्‍के अद दाना तल्‍लुर वेहता परकारम, “बापतिस्मा हियना योहानुना तल्‍ला उंदि गिन्‍नेते वाटसि नाकु हीम,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","इद केंजसि राजांक इरगा दुक्‍कम वाता. गानि अगा मत्‍ता अंटोर हेडमितोराहाटीं आनि तित्‍ता ओट्‍टुहाटीं, अद तल्कतद दान्क हीम्टु इंचि आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","जेलते मत्‍ता योहानुन हव्‍किसि ओना तल्‍ला कोय्‍सि तायलय मनकन लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","अस्‍के योहानुना तल्‍ला गिन्‍नेते वाट्‍सि दान्क हीते अद ओसि दाना यावांक हीता. ");
INSERT INTO esg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","पजा योहानुना सिस्युल्क ओना पीनगुन ओसि बोंदा दोसतुर. होंचि इद पोल्‍लेतुन येसुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","इद पोल्‍ले केंजसि येसु डोंगाते उदिस बदो अलग-सलग जेगाते पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ओर होतद एरपाट आतारित्‍ते लोकुल्‍क ओरा नाहकुनाल ताक्‍सेक ओना पज्जो पेय्‍स्‍तुर. पजा येसु डोंगाताल रेय्तोर अस्‍के ओन्क अगा वेल्‍लेने मंदि दिसतुर. अय्ते येसुंक ओरपोर्रो दया वासि, ओरा रोगाल्कुनंता बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","पोळ्‍द होनना वेलाक सिस्युल्क येसुनगा वासि, “मनम सुनसान जेगाते मंतोम, वेलागुडा बागेन आता. पोळ्‍द अर्राका मुन्‍नेन ईर दग्‍गेटा नाह्कुने होंचि ओराहाटीं तिनालय बतलन्‍ना अस्‍कुन्‍निर, ईरकुन लोहा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","अस्‍के “ओर्क बेके होनना अव्‍सरम हिल्‍ले, मिमेटे ओर्कु बतलन्‍ना तिनालय हीम्टु,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","अस्‍के सिस्युल्क “महगा अय्ते सिराप हेय्युं हारिं आनि रोंडु जिम्मां मंतां,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","अस्‍के, “अय्ते अवुन नहगा पीसवटु,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","अगा मत्‍ता मंदितुन जाडि पोर्रो उद्‍दा वेहतोर. हेय्युं हारिं, रोंडु जिम्मां पीसि पोर्रो हूळसि पेनदुक दन्यवाद कीतोर. पजा हारिन तुकडां कीसि आ तुकडन सिस्युल्कुंक हीतोर. सिस्युल्क बारे लोकुल्‍कुंक हीतुर. ");
INSERT INTO esg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","अस्‍के ओर अंटोर पीरनिंडा तित्‍तुर. अंटोर तिननेंके मिगुल्ता हारिना तुकडां ओर जमा कीतुर अय्ते पन्‍नेंड तट्‍टां पेय्सतां. ");
INSERT INTO esg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","तित्‍ता मंदिताल हेय्युं वेय्‍कु मांडसे मत्‍तुर, इंका मुर्ताह्क, पिलाल्कुनद अय्ते लेक्‍के हिल्‍ले! ");
INSERT INTO esg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","पजा अस्‍केन येसु अंटोर लोकुल्‍कुन सार्ला कियाका मुन्‍नेन ओना सिस्युल्कुन उंदि डोंगाते उपिच्‍चि ओनकन्‍ना मुन्‍नेन सेरवुना हब्बेटा बाजुंक दाटसि होनालय वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","अंटोर लोकुल्‍कुन सार्ला कीता पजा, येसु वरोरे पारतना कियालय गुट्‍टापोर्रो होत्‍तोर. पोळ्‍द होनिनागानि ओर वरोरे अगा मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","अद वेलाते सिस्युल्कुना डोंगा समुद्रम ओड्‍डुनाल वेल्‍लेन लक्‍कु होंचि मत्‍ता. अस्‍के ओर्क एदुर वळि वायालय दल्‍गताहेंका एता तडांक डोंगा डव्क-डिव्क आयालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","नर्कटां मूड-नालुं एगनेंके येसु एता पोर्रोटाल ताकसेक ओरहेके वातोर. ");
INSERT INTO esg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ओर एता पोर्रोटाल ताकसेक वायानद हूळसि, “देय्यम वासंता!” इंचि सिस्युल्क वेरियसि वरगेयालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","अस्‍के येसु बिराने ओर्कुन, “ननाने आंदुन, वेरियमट, दैरनेम इर्राट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पजा पत्रु येसुन, “सामि, ओक्‍कला निमेने आयानय्ते नाकुन नीहेके एता पोर्रोटाल ताकसेक वायालय वेहा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“अय्ते हीके वा,” इंचि येसु इत्‍तोर. अस्‍के पत्रु डोंगाताल रेय्‍सि एता पोर्रोटाल ताकसेक येसुनहेके होनालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","गानि वळि वायनद हूळसि, वेरियसि मुळगालय दल्‍गुतोर. अस्‍के “सामि, नाकुन पिसागोट्‍टा,” इंचि मोत्‍कुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","अस्‍के बिराना कय हाह्सि येसु ओन पीसि, “अरे तक्‍को विस्वासमतोना, निमे नापोर्रो अनमानम बारि कीतिन?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","पजा ओर इव्वुर डोंगा एकतस्के, वळि वायमळ आगुता. ");
INSERT INTO esg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","अस्‍के, “सामि, निमे निजमे पेनदा मर्रिन” इंचि डोंगाते मत्‍तोर ओना काल्कुनपोर्रो अरतुर. ");
INSERT INTO esg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","पजा ओर अद समुद्रम दाटसि गेनेसरेत इनना नाटे वातुर. ");
INSERT INTO esg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","अगाटा लोकुल्‍क येसुन एरपाट कीसि दग्‍गेर पट्‍कुनव अन्‍नि नाहकुंक कबुर लोहचि बिमार मत्‍तोर्कुन अंटोर्कुन पीसि वातुर. ");
INSERT INTO esg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","पजा “सिराप नीवा कप्‍पिडता अंचुन इट्‍टा हीम,” इंचि विनंति कियुंदुर. बोर-बोर अय्ते ओना अंचुन इट्‍तुरो, ओर अंटोर पुरागा बेस आतुर. ");
INSERT INTO esg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","पजा येरुसलेमताल इच्‍चुर परिसिल्क आनि दर्मसास्‍त्रम कराहना गुरुल्क येसुनगा वासि, “नीवा सिस्युल्क पेद्‍दाल्कुना रीति-रिवाजुने बारि ताकुर? ओर तिनाका मुन्‍ने कय्‍क बारि नोर्रुर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर. “मिमेट अय्ते मीवां मुन्‍नेटा रीति-रिवाजकुन ताकसालय पेनदा आदेसतुन होळसेक मंतिर. ");
INSERT INTO esg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","पेन अय्ते इत्‍ते गदा, निमे नीवा तल्‍लुर-बाबोना कदर कीम. अचोने आय्‍का बोर अय्ते तल्‍लुर-बाबोन रांगंतोर, ओन हव्कमळे गावाले इंचिगुडा पेन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","गानि मिमेट अय्ते, बोरन्‍ना मनकल ओना तल्‍लुर-बाबोन, नना मीकु हियानद पूरा पेनदुके हींतन, दानहाटीं मीवा सहायम किया पर्रोन, इल्‍हा तल्‍लुर-बाबोना कदर इर्रना अव्‍सरम हिल्‍ले, इंचि कराहंतिर. ");
INSERT INTO esg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","इत्‍ते मिमेट मीवा रीति-रिवाजकुनाहाटीं पेनदा पोल्‍लेतुन होळसेक मंतिर. ");
INSERT INTO esg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","अरे डोंगिरिटा, यसायाह इनना पेनदा कबुरतोर मीवसोंटा डोंगिरा बारेमते निजमे वेहतोर, ओर इत्‍ताप ");
INSERT INTO esg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ईर लोकुल्‍क सिराप तोळ्‍देने नावा कदर कींतुर, गानि ईरा मनसु मात्रम नहागटाल बच्‍चोनो लक्‍कु मनंता. ");
INSERT INTO esg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ईर अंगडमे नावा आरादना कीसेके मनांतुर. बारित्‍ते ओराहाटीं मनकालोर तयार कीता रीति-रिवाजके निजमतव, अवुना पालन कियमळे दर्मम इंचि कराहंतुर,” इल्‍हा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","अस्‍के येसु लोकुल्‍कुन दग्गेर्क केय्‍सि इल्‍हा इत्‍तोर, “केंजट आनि अर्तम कीकुंटु. ");
INSERT INTO esg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","बतल अय्ते तोळ्‍दाल लोप्पो दांतनो अद मनकन हेळ्‍हो, गानि बद अय्ते तोळ्‍दाल पलाते वांता, अदे मनकन हेळ्‍हंता.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","पजा सिस्युल्क येसुनगा वासि, “निमे वेहतद केंजसि परिसिल्क होंग आतुर इद नीकु तेळियतना?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","अस्‍के येसु जवाबुने, “स्वर्गमते मनना नावा बानाहेंदाल वाटुवद बदे मोल्का आयि, दान पीकिस पोहमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ओरद होन्‍नि, ओर गुड्‍डोर्कुंक हर्रि हुप्‍सना गुड्‍डोर्क आंदुर. ओक्‍कला वरोर गुड्‍डि मनकल इंकावरोर गुड्‍डि मनकंक हर्रि हुप्‍सालय होत्‍ते इव्वुरगुडा पोक्‍कातेन अर्रंतुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","पजा पत्रु, “निमे वेहता इद वेसुडितद अर्तम बतल माकु वेहा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “मीकु इंदकेगुडा तेळिया हिल्‍लेना? ");
INSERT INTO esg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","बतल अय्ते तोळ्‍दाल पीटे दांता, अदंता पजा पलाते अर्रंता. इद मीकु इंकागुडा तेळियोना? ");
INSERT INTO esg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","गानि बतल अय्ते तोळ्‍दाल पलाते पेय्संता, अद मनसुनाल वांता, अदे मनकन हेळ्‍हंता. ");
INSERT INTO esg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","इत्‍ते कराब विचाराल्क, हव्‍कमळ, बोगमतनम, व्यबिचारम, दोंगातनाल्‍क, आबद्‍दम वळ्‍कमळ, अपमानम कियमळ इवन्‍नि पापि कबाह्‍क मनसुनाले पलाते पेय्‍संतां. ");
INSERT INTO esg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","इवे पोल्‍लें मनकन हेळ्‍हंतां. गानि कय नोर्राकोंटा तिनानय्ते मनकल हेळोर.” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","पजा येसु अगटाल पेय्सि सूर, सिदोन एरियाते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","अस्‍के हूळा! उंदि कनानि मुरतळ येसुनगा वासि अळसेके, “सामि, दाविद राजाना वंसमतोना, नावा मिय्यटुन देय्यम पीसि वेल्‍ले तकलिपने मंता, नापोर्रो दया कीम” इंचि मोत्‍कुनालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","गानि येसु मात्रम बतले वळकाकोंटा सपुडदाका मत्‍तोर. अस्‍के सिस्युल्क येसुनगा वासि, “आ मुरतळ मना पज्जो मोत्‍कुंचेके वासंता दान वापस लोहचीम.” इंचि विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","अस्‍के येसु, “गानि नाकुन पेनबाबाल सिराप इस्राएलता तप्‍सोत्‍ता लोकुल्‍कुनाहाटीं लोहचीतोर.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","अयना आ मुरतळ मर्रा येसुनगा वासि टोंगरां ऊनसि, “सामि नाकु सहायम कीम,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","अस्‍के येसु, “पिलाल्कुना हारिं तेंडकुंचि अवुन नय्‍कुंक वाटमळ बेस आयो,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","अस्‍के आ मुरतळ, “अद निजमे सामि, गानि मालक तिननेंके हिळु अरता अंटकुल्‍कुन अय्ते नय्‍के तिंतां गदा!” इंचि येसुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","अस्‍के “बाई नीवा विस्वासम गट्‍टिदि. इंचि नीवा इच्‍चा मत्‍ताप नीकु जर्गीकांटी,” इंचि येसु इत्‍तोर. अस्‍केन दाना मिय्यड बेस आता. ");
INSERT INTO esg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","पजा येसु अगटाल गालिलता सेरवुनहेके होत्‍तोर अगा उंदि गुट्‍टापोर्रो एक्‍किस उदुतोर. ");
INSERT INTO esg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","अस्‍के वेल्‍लेन मंदि लोकुल्‍क ओनगा वातुर. वायनेंके गुड्‍डोर्क, गूनोर्क, कुंटोर्क-तोंटोर्क, मूकालोर्क आनि इंका वेरे रोगाल्कुनोर्कुन पीसि ओनगा तायसि ओना काल्कुनगा इरतुर. येसु अंटोर्कुन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","अस्‍के मूकालोर्क वळकालय दल्‍गुतुर, कुंटोर्क ताकालय दल्‍गुतुर, तोंटोर्क सवरगा आतुर, गुड्‍डोर्क हूळालय दल्‍गुतुर. इवंता हूळसि जमा आता लोकुल्‍कुंक इचंत्रम आता, आनि इस्राएलता पेनदा स्‍तुति कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","पजा येसु ओना सिस्युल्कुन दग्गेर्क केय्‍सि, “ईर लोकुल्‍क नहगा मूड रोजकुनाल मंतुर, ईरगा तिनालय बतल हिल्‍ले. ईरकुन उपासम लोहुड बेस आयो. ओक्‍कला अल्हे लोहते कर्वेस्‍सि नड्‍डुम हरदे बगानना कूलाबडनुर. अदुनहाटीं नाकु ई लोकुल्‍कुन हूळसि पापम अनपिच्‍चंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","अस्‍के, “इच्‍चो वेल्‍ले लोकुल्‍कुंक हालानाल तिंडि, ई उस्‍के बूमिते मनाकु बगा दोर्कार?” इंचि सिस्युल्क येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","अस्‍के, “मिहगा बच्‍चुं हारिं मंतां?” इंचि येसु ओर्कुन पूसकीतस्‍के ओर “एडुं हारिं आनि इच्‍चुं सिन्‍ने जिम्मां मंतां.” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","अस्‍के येसु मंदितुन हिळु बूमिपोर्रो उद्‍दा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","पजा येसु आ एडुं हारिं आनि आ जिम्मान कय्‍दे पीसि पेनदुक दन्यवाद कीतोर. पजा अवुन तुकडां कीसि सिस्युल्कुना कय्‍दे हीतस्के सिस्युल्क आ हारि तुकडन अगा मत्‍ता मंदिकु तूसि हीतुर. ");
INSERT INTO esg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","अगा मत्‍तोर अंटोरगुडा पीरनिंडा तित्‍तुर. पजा मिगुल्ता हारि तुकडन जमा कीते अव एडुं तट्‍टां आतां. ");
INSERT INTO esg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","अगा तित्‍तोरव्टे मुर्ताह्क, पिलाल्कुन होळसि नालुं वेय्‍कुना मंदि मांडसे मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","पजा अगा मत्‍ता मंदितुन होनालय वेह्‍चि, ओर डोंगाते उद्‍दिसि मगदान इनना एरियाक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","परिसिल्क आनि सदुकिर्क येसुनगा वातुर. ओर येसुना पट्‍टु हूळना उद्‍देसमते “निमे पेनदा अदिकारम पीसि वातिन इंचि नम्‍मालय, स्वर्गमताल माकु उंदि चिन्‍ह हुप्‍सा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","अस्‍के येसु ओर्कु इल्‍हा जवाब हीतोर. “पोळ्‍द होंचि मब्बु एर्रगा आयानय्ते मिमेट पिर्रु वायो इंतिर, ");
INSERT INTO esg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","हक्‍केर्कु मब्बु एर्रगा, गुम्मरा आयानय्ते, इय्याला वळि दुमारम वांता बारे मिमेट इंतिर. मीकु मब्बुना रूपाल्‍कु एरपाट किया वांता, गानि वेलाना चिन्‍हन हूळसि अवुन मिमेट बारि एरपाट कीसेक हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","सेड्‍डोर्क आनि बोगमतनम कियाना पीळिता लोकुल्‍क चिन्‍ह हुप्‍सा इंतुर. गानि योनाल इनना पेनदा कबुरतोना चिन्‍ह तप्‍पा ओर्कु इंकुंदि चिन्‍ह हुपिच्‍मळ जर्गो,” इंचि इत्‍तोर. आनि ओर्कुन होळसि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","सिस्युल्क समुद्रमता हब्बेर ओड्‍डुंक एव्‍तुर, गानि ओर हारिं ओयालय मरुंगतुर. ");
INSERT INTO esg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","पजा येसु ओर्कुन इल्‍हा इत्‍तोर, “परिसिल्क आनि सदुकिर्कुना पुल्‍लटा पिंडिता बारेमते जेगर्ता मंटु,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","अस्‍के, “मनम हारिं तर्रालय मर्गताहाटीं ओर अल्हा इंतोर बारे,” इंचि ओर ओरे वळ्‍ककुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","गानि येसु अदुन एरपाट कीसि, “अरे विस्वासम तक्‍को लोकुरिटा, मनागा हारिं हिल्‍लें इल्‍हा विचारम मिमेट बारि कीसेक मंतिट? ");
INSERT INTO esg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","इदवेरदाकागुडा मीकु तेळिया हिल्‍लेना? हेय्युं हारिंने, हेय्युं वेय्‍कुना मंदि तित्‍तदगुडा मीकु मति हिल्‍लेना? तित्‍तारित्‍ते बच्‍चुं तट्‍टाना हारिं मिमेट जमा कीतिर मीकु मति हिल्‍लेना? ");
INSERT INTO esg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","अचोने आयाका एडुं हारिनतोनि नालुं वेय्‍कुना मंदि तित्‍तस्के, बच्‍चुं तट्‍टाना हारिं जमा कीतिर मीकु मति हिल्‍लेना? ");
INSERT INTO esg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","नना वळ्‍कानद हारिना बारेमते आयो इंचि मीकु बल्हा तेळियसेक हिल्‍ले? नना बारे परिसिल्क आनि सदुकिर्कुना पुल्‍लटा पिंडिता बारेमते जेगर्ता मंटु इत्‍तन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","अस्‍के ओर्कु, “हारिना होयता पिंडिता बारेमते उसारते मंटु,” इंचि वेहा हिल्‍लोर गानि परिसिल्क आनि सदुकिर्कुना कराहना बारेमते उसारते मनालय वेहतोर इंचि तेळियता. ");
INSERT INTO esg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","येसु कैसरिया पिलिपिया एरियाते होत्‍तारित्‍ते, “मनकना रूपमते पुटतोन नना बोन आंदुन इंचि लोकुल्‍क इंतुर?” इल्‍हा येसु सिस्युल्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","अस्‍के सिस्युल्क इल्‍हा इत्‍तुर. “इच्‍चुर इंतुर निमे बापतिस्मा हियना योहानुन आंदिन, इंका इच्‍चुर इंतुर निमे एलियाल आंदिन, इंका बोरो इंतुर निमे यिर्मयाहन हिलाकोंटे पेनदा कबुरतोरा लोप्पोटाल बोनो वरोन आंदिन,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“अय्ते मरि, मिमेट, नना बोन आंदुन इंतिर?” इंचि येसु ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“निमे जीवाते मनना पेनदा मर्रिन किरिस्‍तुन आंदिन,” इंचि सिमोन पत्रु इतोर. ");
INSERT INTO esg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","अस्‍के येसु “योनाना मर्रि सिमोनु! नीकु आसिर्वाद दोर्कुता. बारित्‍ते, इद पोल्‍ले नीकु बोर मनकल वेहा हिल्‍लोर, गानि नावा स्वर्गमता बाबाल नीवा लोप्पोटाल वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","इंदके नना नीवा पोरोल पत्रु इंचि इरसंतन, बारित्‍ते इदे बंडापोर्रो नना नावा कलिसिया निलाहंतन. दीन हामुरता ताकतगुडा कूल्हा पर्रो. ");
INSERT INTO esg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","नना नीकु स्वर्ग राज्येमता तालम कय्‍क हीसंतन, निमे बूमिपोर्रो बदुन अय्ते दोहंतिनो, अदुन स्वर्गमतेगुडा दोहमळ जर्गंता. निमे बूमिपोर्रो बदुन अय्ते लेहांतिनो, अदुन स्वर्गमतेगुडा लेहमळ जर्गंता.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","पजा, “ननाने किरिस्‍तुन आंदुन इंचि मिमेट बोर्के वेहमट,” इंचि येसु ओर्क गट्‍टिगा हुकुम हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","अस्‍केटाल येसु ओना सिस्युल्कुंक इल्‍हा वेहालय दल्‍गतोर. “नाकु येरुसलेम होनापींता. अगा यहुदि पेद्‍दाल्क, पेद्‍दा पेर्मालोर आनि दर्मसास्‍त्रम कराहना गुरुल्कुनाहेंदाल वेल्‍ले तिप्‍पल्‍क कीसि नाकुन हव्कानुर. मूडोव रोजुने नना मर्रा जीवाते तेदंतन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","अस्‍के पत्रु ओन अलग ओसि, “अल्हा वळ्का मन्‍नि सामि! पेन दीन तपिचगोम. नीकु इल्‍हा बस्‍केने आयामन्‍नि,” इंचि ओन रांगतोर. ");
INSERT INTO esg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","गानि येसु पत्रुनहेके तिरियसि हूळसि, “अरे देय्यम, नावा मुन्‍नेटाल पेय्सि होन. निमे मनकालोरा तेल्‍विते वळ्‍कसंतिन, पेनदा विचारमते वळ्कसेक हिल्‍लिन. निमे नावाहाटीं उंदि आपत आंदिन.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","अस्‍के येसु ओना सिस्युल्कुंक इल्‍हा वेहतोर. “ओक्‍कला बोरन्‍ना मनकल नावा पज्जो वायना इत्‍ते, ओर ओना पूरा इस्‍टाल्क होळसिसि सतता क्रुस तेह्‍कुंचि नावा पज्जो वायिर. ");
INSERT INTO esg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","बोर अय्ते ओना जीवातुन पिसागोटालय हूळांतोर, ओना जीवा होन्‍नार. गानि बोर अय्ते नावाहाटीं जीवा होनागोटंतोर अद ओन्क दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ओक्‍कला मनकल पूरा दुनियातुन संपलिच्‍चि ओना जीवातुन पोगोटकुत्‍ते ओन्क बता पायदा आंता? हिलाकोंटे मनकल ओना जीवाहाटीं बदला बतल हियानुर? ");
INSERT INTO esg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","मनकना रूपमते पुटतोन नना नावा बाबाना महिमाते दूतनतोनि वांतन, आ वेलाते बोरे मनकल आयिर, ओर कीता कबाह्‍कुना परकारमे ओर्क इनाम हींतन. ");
INSERT INTO esg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","नना मीकु निजम वेहांतन, इग्‍गे नित्‍तिसि मनानोरा लोप्पोटाल इच्‍चुर इल्‍हा मंतुर गदा, मनकना रूपमते पुटतोन नाकुन नावा राज्येमते वायनेंके बदवेरदाका अय्ते हूळुर, अदवेरदाका ओर्कु हामुर वायो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","हारुं रोजकु आतारित्‍ते येसु पत्रुन, याकोबुन आनि ओना तम्मुर योहानुन पीकुंचि उंदि एत्‍तु गुट्‍टापोर्रो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","अगा ओरा मुन्‍ने ओना रूपम मारिय्ता. ओना मोकम पोळ्‍दुनलेसीं मेर्सता, ओना कपडिं वेल्‍गुनलेसीं तेल्‍लगा आतां. ");
INSERT INTO esg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","हुळाट! मूसाल आनि एलियाल अगा वासि येसुनतोनि वळ्‍कानद ओर्कु दिसतुर. ");
INSERT INTO esg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","अस्‍के पत्रु येसुन, “मनम इग्‍गे मनमळ बेस मंता सामि! नीवा मनसु मत्‍ते, उंदि नीहाटीं, उंदि मूसानाहाटीं, उंदि एलियानाहाटीं इल्‍हा मूड गुडसें वाटंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","पत्रु वळ्‍कसेकेन मत्‍तोर, अस्‍केन उंदि तेल्‍ला मब्बु तेर्पे ओरापोर्रो नीडा कीता, आ मब्बुनाल उंदि इसंटा अल्किर केंजावाता, “ईर नावा पावरमगल्‍ला मर्रि आंदुर, ईनतोनि नना कूस मंतन, मिमेट ईना पोल्‍लें केंजट.” ");
INSERT INTO esg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","आ अल्किर केंजतस्के येसुनतोनि मत्‍ता सिस्युल्क वेरियसि बूमिपोर्रो मुसकिर कुच्‍चि अरतुर. ");
INSERT INTO esg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","अस्‍के येसु ओरा दग्‍गेर वासि ओर्कुन इट्‍टिसि, “वेरियमट, तेदट” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","अस्‍के ओर तेदसि कळ्‍कु विच्‍चि पोर्रो हूळते, ओर्कु येसुंक तप्‍पा अगा बोरे दिसा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ओर गुट्‍टा पोर्रोटाल हिळु रेय्‍नेंके येसु सिस्युल्कुंक इल्‍हा आदेस हीतोर गदा, “मनकना रूपमते पुटतोन नना, हामुरताल मर्रा तेदनदाका, गुट्‍टापोर्रो मिमेट बतल अय्ते हूळतिरो अद बोर्के वेहमट,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","अस्‍के सिस्युल्क, “मरि किरिस्‍तुंकन्‍ना मुन्‍ने, एलियाले वायमळ गावाले इंचि दर्मसास्‍त्रम कराहना गुरुल्क बारि इंतुर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","अस्‍के येसु इल्‍हा जवाब हीतोर. “एलियाल तप्‍पाकोंटा वांतोर, वासि मोदाला बल्हा मत्‍ता अल्हे अन्‍निन कींतोर. ");
INSERT INTO esg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","गानि नना मीकु वेहानद बतल इत्‍ते, एलियाल वासे मंतोर गानि ओन बोरे एरपाट किया हिल्‍लुर. अदुनहाटीं लोकुल्‍क ओरा मनसुंक वाताप ओनतोनि कीतुर. मनकना रूपमते पुटतोन ननागुडा ओराहेंदाल अल्हेन तकलिप्‍कु बोगांचना मंता.” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","येसु बापतिस्मा हियना योहानुना बारेमते वेहासेक मंतोर इंचि सिस्युल्कुंक अस्‍के तेळियता. ");
INSERT INTO esg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","येसु आनि ओना सिस्युल्क लोकुल्‍कुनगा वातस्के, वरोर मनकल येसुनगा वासि ओना मुन्‍ने टोंगरां ऊनसि, ");
INSERT INTO esg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“सामि! नावा मर्रिनपोर्रो दया कीम. ओन्क कुंदेल रोगम अर्रंता. अरतस्के ओर ऊके-ऊके तडमिते आनि एते अर्रंतोर, ओन्क इरगा तिप्‍पल्‍क आसेक मंता. ");
INSERT INTO esg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","नना ओन नीवा सिस्युल्कुनगा तत्‍तन गानि ओर बेस किया पराहिल्‍लुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","अस्‍के येसु ओर्कुन, “अरे विस्वासम तक्‍को आनि हर्रि तप्‍ता पीळितोरिटा, नना बदवेरदाका मीतोनि मनकन? बदवेरदाका नना मीकुन सहन कीकन? ओन नाहेके तटु.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ओन तत्‍तस्के येसु आ पेडन पीता देय्यमतुन गद्‍दरिच्‍चि गेदुमतोर. अस्केटद अस्‍केन आ पेडल बेस आतोर. ");
INSERT INTO esg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","पजा बोर हिल्वस्के सिस्युल्क येसुनगा वासि, “आ देय्यमतुन मोमोट बारि गेदमा पर्रा हिल्‍लोम?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","अस्‍के येसु ओर्कु इल्‍हा वेहतोर. “मीवद पेनदापोर्रो गट्‍टिगा विस्वासम हिल्‍ले. नना मीकु निजम वेहांतन, ओक्‍कला मीलोप्‍पो आवाल्‍कुना पेळेतच्‍चो विस्वासम मनिनागानि, ‘ई गुट्‍टातुन इग्‍गेटाल अगा होन’ इंचि मिमेट वेहानय्ते अद होंदार. अस्‍के मिमेट अन्‍नि कबाह्‍क किया परांतिर. ");
INSERT INTO esg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","गानि इसंटा देय्याल्क सिराप पारतना आनि ओक्‍कापोद्‍दूक कीतेने दांतां,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ओर गालिलते वासि उंदि जेगाते जमा आतस्के येसु ओर्कुन इल्‍हा इत्‍तोर. “मनकना रूपमते पुटतोन नाकुन, लोकुल्‍कुना कय्‍दे दोर्कापीसि हियानद मंता. ");
INSERT INTO esg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ओर नाकु हव्कानुर गानि, मूडोव रोजुने नाकु मर्रा जीवा अर्रार,” इत्‍तोर. इद केंजसि सिस्युल्कुंक इरगा दुक्‍कम अनपिस्ता. ");
INSERT INTO esg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","अगटाल येसु कपर्नाहुम नाटेंक वातस्के गुळिना कर वसुलि कियानोर पत्रुनगा वासि, “मीवा गुरु, गुळिता कर दोहोरा?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","अस्‍के पत्रु, “आ दोहंतोर!” इंचि इत्‍तोर. ओर लोता लोप्पो होत्‍तोर, होंचि येसुंक वेहाक मुन्‍नेन येसु, “सिमोनु, नीकु बतल अनपिच्‍चेक मंता? ई दुनियाते मनना राजुकु जकात आयि कर आयि बोराहेंदाल एतंतुर, ओरा मर्कुन हेंदाला मरि इंका बोरन्‍ना वेरेतोरा हेंदाला?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","अस्‍के पत्रु, “वेरेतोरा हेंदाल,” इंचि इत्‍तरित्‍तेन येसु ओन, “अय्ते मर्क पिरि मंतुर मरि! ");
INSERT INTO esg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","अयना ओर्कुन नाराज कियामन्‍नि इंचि निमे गालम वाटालय होन्‍नु आनि मुन्‍ने अरता जिम्मातुन पीसि दाना तोळ्‍दुन पर्हा, पर्हातारित्‍ते उंदि कल्‍दार दोर्कार. अद ओसि नावा आनि नीवा पोरोलते कर दोहासि हीम.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","आ वेलाते सिस्युल्क येसुनगा वासि, “स्वर्ग राज्येमते अंटोर्कन्‍ना पेद्‍दा बोर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","अस्‍के येसु वरोर सिन्‍ना पेडन केय्‍सि, ओरा नड्‍डुम निलाहचि इल्‍हा वेहालय दल्‍गुतोर. “नना निजम वेहांतन, मीवा गुनाल्‍कुन मार्सकुंचि मिमेट पेडनलेसीं आयवा, स्वर्ग राज्येमते बस्‍केने होना परिर. ");
INSERT INTO esg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","दानहाटीं बोर अय्ते ओनाद ओरे ई सिन्‍ना पेडन लेह्का सादा-सिंपल मनांतोर, ओरे स्वर्ग राज्येमते पेहरोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","बोर अय्ते नापोर्रो विस्वासम कियना ई सिन्‍ना पेडनसंटोन बेस हूळांतोर, ओर नाकुन बेस हूळतापे. ");
INSERT INTO esg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","गानि नापोर्रो विस्वासम कियना ई सिन्‍ना पेडानसंटोन बोरन्‍ना पापमते अरहते, ओना बोंळगेक जोत्‍ता बंडा दोहाचि ओन समुद्रमते लोतु एते ओसि मुळुहमळे बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","पापमते अरहना पोल्‍लें ई दुनियाते वेल्‍लेन मंतां. अवुनहेंदाल दुनिया लोकुल्‍कुन पापमते अरहंता. अदुनहाटीं ई दुनियाक बच्‍चोन गोसा वायार! पापमते अरहना पोल्‍लें अय्ते वायमळे गावाले, गानि अव बोनाहेंदाल अय्ते वांतांगो ओन्क बच्‍चोन गोसा वायार!” ");
INSERT INTO esg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ओक्‍कला नीवा कय आयि काल आयि नीकुन पापम किया वेह्ते दान नर्किसि पोहा. बारित्‍ते रोंडु कय्‍क, रोंडु काल्क मंचि बस्‍केळ्‍क पोत्‍सेके मनना तडमिता नरकमते होननदानकन्‍ना, अपंग हिलाकोंटे कूटाल आसि पिस्वरते होनमळे नीहाटीं बेस. ");
INSERT INTO esg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अल्‍हेने, ओक्‍कला नीवा कळु नीकुन पापम किया वेहते दान तेंडसि पोहा. बारित्‍ते रोंडु कळ्‍क मंचि नरकमता तडमिते होननदानकन्‍ना गुड्‍डि आसि पिस्वरते होनमळे नीहाटीं बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","हुळाट, नावापोर्रो विस्वासम कीता ई सिन्‍नोरकुन बोने तेंडसि पोहमटु. नना वेहनद बतल इत्‍ते, ओरा पेनदा दूतां स्वर्गमते मनना नावा पेनबाबांक बस्केळक कलियसेके मनंतां. ");
INSERT INTO esg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","अचोने आयका मनकना रूपमते पुटतोन नना तप्‍सोत्‍तोर्कुन पिसागोटलय वातन. ");
INSERT INTO esg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ओक्‍कला वरोर मनकानगा नूर गोर्रें मंतां इनकुंटु. अवुनाल उंदि गोर्रे तप्‍पिस होनानय्ते, कळमता टोंबै तोम्मिद गोर्रेन ओर अग्गेन होळसिसि, तप्‍सोत्‍ता आ उंदि गोर्रेतुन पहकालय होन्‍नोरा? दांतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","नना निजम वेहांतन, ओक्‍कला ओन्क होत्‍ता गोर्रे दोर्कानय्ते, आ टोंबै तोम्मिद तप्‍पिस होनवा गोर्रेंकन्‍ना, तप्‍सोत्‍ता आ उंदि गोर्रेपोर्रो एक्‍को आनंदम आयानुर. ");
INSERT INTO esg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","अल्‍हेने ई सिन्‍नोरकुनाल वरोर इंका नासडेम आयामन्‍नि इंचि स्वर्गमते मनना मीवा बाना मनसु मंता.” ");
INSERT INTO esg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ओक्‍कला तम्मुर आयि दादाल आयि नीवा विरोदमते पापम कियानय्ते, निमे वरोने ओनगा होंचि ओर कीता पापम ओन्क तेळियागोट्‍सि वेहा. ओर ओक्‍कला नीवा पोल्‍ले केंजानय्ते निमे ओना मनसुन गेल्सताप. ");
INSERT INTO esg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","उंदि वेला ओरगिंटा नीवा पोल्‍ले केंजुवस्के, वरोर-इव्वुरकुन नीवा पज्जो पीसि होन. बारित्‍ते, अगा बतल जर्गुतनो अदुन वेहालय ओर गवाइ मनांतुर. ");
INSERT INTO esg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ओक्‍कला ओर ओरा पोल्‍लेगुडा केंजाकुंटे कलिसियातोर्क वेहा. कलिसियातोर वेहतदगुडा केंजाकुंटे, ओर पेनदा मनकल आयोर इंचि इनकुन. हिलाकोंटे कर वसुल कियानसंटोर इनकुन. ");
INSERT INTO esg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“नना मीकु निजम वेहांतन, मिमेट बूमिपोर्रो बदुन अय्ते दोहंतिरो, अदुन स्वर्गमतेगुडा दोहमळ जर्गंता, मिमेट बूमिपोर्रो बदुन अय्ते लेहांतिरो, अदुन स्वर्गमतेगुडा लेहामळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","अचोने आयका नना वेहनद निजम बतल इत्‍ते, ई बूमिपोर्रो मीवा लोप्पोटाल बोरन्‍ना इव्वुर उंदि आसि मीकु बतल अय्ते गावालेनो अद तल्कानय्ते स्वर्गमते मनना नावा पेनबाबाल तप्‍पाकोंटा हींतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","बारित्‍ते बगा अय्ते नावा पोरोलते इव्वुर-मुव्वुर उंदगा जमा आंतुरो, अगा ओरा नड्‍डुम नना मनांतन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","अस्‍के पत्रु येसुनगा वासि, “सामि, वरोर तम्मुर आयि दादाल आयि नावा विरोदमते पापम कियानय्ते, नना ओन बच्‍चुं मल्कां मापि कीकन? एडुं मल्कंगां?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","अस्‍के येसु ओन्क, “एडुंगें मल्कां आयो, ओर बच्‍चुं मल्कां तप्पु किय्यिनागानि ओन निमे माप कीसेक मन्‍नु,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","पजा येसु इल्‍हा वेहालय दल्‍गुतोर, स्वर्ग राज्येम वरोर राजन लेह्का मंता. आ राजाल ओन्क बाकि मत्‍ता जीतागाह्कुना हेंदाल बाकीं वसुल कियना इंचि विचारम कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","बस्के अय्ते ओर वसुल कियालय सुरुव कीतोर, अस्‍के वरोर लक्‍सेना बाकि मत्‍ता जीतागान राजानहेके तत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","आ जीतागानगा ओना मालकुना बाकि दोहालय बतले मनाहिल्‍ले. अस्‍के ओर ओन्क आदेस हीतोर गदा, “ओर ओना मुत्‍तो-पिलाल्क, लोन-दारा अचोने आय्‍का ओनगा बतल अय्ते मंतनो अव अन्‍नि अम्मिसि, वाता कोत्‍तानाल बाकि दोहिरकांटी,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","अस्‍के आ जीतागाल राजाना काल्कुनपोर्रो अर्सि बात्मिलाडतोर, “राजा नाकु कोन्‍नि रोजकुना मुदत हीम, मेल्‍लगा-मेल्‍लगा नावा बाकि पुरागा दोहंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","अस्‍के आ मालकुंक ओना जीतागानपोर्रो दया वासि ओना बाकि अंता पुरागा माप कीसि होळसीतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","पजा आ जीतागाल अगटाल पेय्सि होननेंके ओन्क नूर रूपें बाकि मत्‍ता ओना दंटाता जीतागाल हरदे कलियतोर. अस्‍के ई मुन्‍नेटा जीतागाल आ जीतागाना बोंळ्‍गे पीसि, “नाकु हियना कोत्‍तां बस्के हींतिन? नाकु इंदकेटद इंदकेन हीम,” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","पजा आ जीतागाल मुन्‍नेटा ओना दंटाता जीतागाना काल्कुना पोर्रो अर्सि विनंति कीसि, “निमे कोन्‍नि रोजकु ओप्के पीम, नना नीवा बाकीं नीकु हींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","अयना ओर बतले केंजाकोंटा, ओर बाकि दोहनाल ओन जेलने वाटसीतोर. ");
INSERT INTO esg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","अस्‍के अगा जर्गतद ओना दंटाता जीतागाह्‍क हूळतुर ओर्कु वेल्‍ले दुक्‍कम आता. ओरा मालकुनगा होंचि जर्गतव अंता वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","अस्‍के मालक ओन केय्‍सि इत्‍तोर, “अरे तेल्वि तक्‍को जीतागा, नीकु इच्‍चोरगुडा दया वाया हिल्‍लेना? निमे नावा काल्क पीसि विनंति कीतिन अय्ते नना नीवा पूरा बाकितुन माप कीतन. ");
INSERT INTO esg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","नना बल्हा नीवा पोर्रो दया कीतनो अल्‍हेने निमे नीवा दंटाता जीतागाना पोर्रो दया किया मत्‍तिन.” ");
INSERT INTO esg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","इंचि मालक ओनपोर्रो होंग आसि ओन जेलने वाटसीतोर. ओना बाकि नेम्मनजेप ओन जेलनाल होळसा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","इल्हेने मिमेटगुडा मीवा तम्मुन आयि दादान आयि मनसुनाल मापि कियाकोंटे ई राजाल बल्हा कीतोरो अल्‍हेने नावा स्वर्गमते मनना बाबालगुडा मीकुन मापि किय्योर. ");
INSERT INTO esg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","इव अन्‍नि पोल्‍लें वेहामळ आतारित्‍ते येसु गालिल एरियाताल पेय्सि योर्दन बेरेडता हब्बेर ओड्‍डुंक मनना यहुदिया एरियाते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","अस्‍के वेल्‍लेन मंदि ओना पज्जो होत्‍तुर. येसु ओर्कुन बिमारकुनाल बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","अगा इच्‍चुर परिसिल्कगुडा वातुर. येसुना पट्‍टु हूळना इंचि, “मूसाना नियम परकारम, बद कारनमताहाटीं अयना मुत्‍तोन होळसिय्या वच्‍चा?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","येसु इल्‍हा जवाब हीतोर, “बस्के अय्ते पेन मनकन कीतानो, अस्‍केन ओर्कुन मांड्‍सा मुरतळ इल्‍हा इंचि कीता. इदु मिमेट हदवा हिल्‍लिरा? ");
INSERT INTO esg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","दीनाहाटीं मांड्‍सा यावन-बाबान होळसिसि, ओना मुत्‍तोन पीसि मनांतोर. ओर इव्वुर उंदे मेंदुल आसि मनांतुर. ");
INSERT INTO esg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","अदुनहाटीं ओर इव्वुर उंदे मेंदुल आसि मनांतुर. इल्‍हा पेने ओर्कुन कल्‍पताहाटीं, मनकल वेरे कियानायो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","इद केंजसि, “अल्हा अय्ते मरि, मनकल ओना मुत्‍तोंक सोडसिट्‍टि हीसि होळसियना आदेस मूसाल बारिंक हीतोर?” इंचि परिसिल्क मर्रा पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “मीवा मनसु बंडालेसीं मत्‍ताहाटीं मूसाल मुत्‍तोह्‍कुन होळसिय्या वच्‍चु इत्‍तोर, गानि मुन्‍नेटाल इसोंटा रिवाज मनाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","नना मीकु वेहासेक गदा, बोरन्‍ना ओना मुत्‍तोन बोगमतनमता कारनम तप्‍पा वेरे कारनमते होळसिसि इंकुंदानतोनि मरमिं आयानय्ते, ओर बोगमतनम कींतोर.” इल्‍हा इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","इद केंजसि ओना सिस्युल्क ओन, “अय्ते मुत्‍तो मुय्दोन नड्‍डुम इसंटा लेक्‍का मत्‍ते मरमिं आयाकोंटेन सूटि,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","येसु ओर्कु इल्‍हा समजांस्तोर, “मिमेट इत्‍ता पोल्‍लेतुन ओप्कुनमळ अंटोर्क कुदुरो, गानि बोनकु अय्ते ई पोल्‍लेन पीसि ताकना ताकत पेन हीतनो ओरे ओप्कुना परांतोर. ");
INSERT INTO esg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","बारित्‍ते बोरो-बोरो तलुह्कुना पीटाले आडिगुंलोर्क आसि पुटतोर मंतुर, मनकालोरा कयदालगुडा आडिगुंलोर्क आतुर मंतुर, आनि स्वर्ग राज्येमता हेंका इच्‍चुर मंदि मरमिं आयाकोंटा मंतुर. इंचि बोर्क अय्ते ई पोल्‍लें नच्‍चंतंगो ओर इदुन ओपकुनिरकांटी.” ");
INSERT INTO esg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","पजा इच्‍चुर लोकुल्‍क ओरा पिलाल्कुनपोर्रो येसु कय इर्सि पारतना कियाना इंचि ओनगा पीसि वातुर, गानि सिस्युल्क ओर्कुन रांगतुर. ");
INSERT INTO esg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","गानि येसु, “पिलाल्कुन नाहेके वायाहीम्ट, ओर्कुन आपमट. स्वर्ग राज्येम इसंटोरदे आंद,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","पजा येसु पिलाल्कुनपोर्रो कय इर्सि अगटाल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","वरोर मनकल येसुनगा वासि, “गुरु, बस्‍केळ्‍क पिस्सना पिस्वर गावाले मत्‍ते नना बव बेसता कबाह्‍क कीते सरे?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","अस्‍के येसु ओन इल्‍हा इत्‍तोर, “बेस इत्‍ते बतल, नाकुन बारि पूसकींतिन? बेसतद अय्ते सिराप पेन उंदे आंद. ओक्‍कला नीकु बस्‍केळ्‍क पिस्सना पिस्वर गावाले अनपिस्‍ते पेनदा आदेसकुना परकारम ताका,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“बव आदेसकु?” इंचि आ मनकल इत्‍तस्के, “बोने हव्कमा, बोगमतनम कियमा, दोंगातनम कियमा, आबद्‍दम गवाइ हियमा, ");
INSERT INTO esg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","नीवा तल्‍लुर-बाबाना कदर कीम. नीवद निमे बच्‍चोन पावरम कींतिनो, अचोने पावरम इंकावरोनगुडा कीम.” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","अस्‍के, “नना अय्ते इव अन्‍नि कीसेकेन वातन, इंका नावा लोप्पो बतल तक्‍को मंता?” इंचि आ लेय्योड येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","अस्‍के येसु इत्‍तोर. “ओक्‍कला नीकु सत्‍तेमते पुरागा आयानद मत्‍ते, होन, निहगा बतल अय्ते मंता अदुन पूरा अम्मिसि, गरिबोर्कुंक तूसि हीम. अस्‍के नीकु स्वर्गमते दनम दोर्कार. पजा नहगा वासि ना पज्जो ताका,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","गानि ओनगा सोम्मु वेल्‍लेन मत्‍ताहाटीं ई पोल्‍ले केंजसि लेय्योड सिम्मरा आसि पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","अस्‍के येसु ओना सिस्युल्कुन इल्‍हा इत्‍तोर. “नना मीकु निजम वेहांतन, स्वर्ग राज्येमते सिरमंत मनकल होळियमळ इत्‍ते वेल्‍लेन कस्‍टम. ");
INSERT INTO esg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","नना मर्रा वेहांतन, पेनदा राज्येमते सिरमंत मनकल होळियमळकन्‍ना लोटापेटा सूदि बोंगाताल होनमळ अल्कगा मनंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","इद केंजसि सिस्युल्कुंक वेल्‍लेन इचंत्रम आता. अदुनहाटीं, “अय्ते मरि मुक्‍ति बोर्क दोर्का पर्रंता?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","अस्‍के येसु सिस्युल्कुनहेके हूळसि, “मनकालोरतोनि अय्ते इद आयापर्रो, गानि पेन मात्रम अन्‍नि किया पर्रंता.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","अस्‍के पत्रु येसुन इल्‍हा इत्‍तोर. “हूळा, मोमोट अय्ते मत्‍तद-हिलवद अन्‍नि होळसिसि नीवा पज्जो वातोम. अय्ते माकु बतल दोर्कार?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","“नना मीकु निजम वेहांतन, पूना दुनियाते, मनकना रूपमते पुटतोन नना नावा महिमाता राजगद्‍देपोर्रो उद्‍दंतन, अस्‍के नावा पज्जो मनानोर मिमेटगुडा पन्‍नेंड राजगद्‍देन पोर्रो उद्‍दिसि, इस्राएलना पन्‍नेंड गोत्राल्कुनोरा न्‍यायम कीकिर. ");
INSERT INTO esg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अचोने आयका नावाहाटीं बोर अय्ते लोन-दारातुन, दादल-तम्मुह्‍कुन, अक्‍कल-हेलाह्कुन, तल्‍लुर-बाबोन, पिलाल्कुन, इंका बूमिं-जेगान होळसीतुरो ओर्कु आ होळसीतवुंकन्‍ना नूर अंताल्‍क एक्‍को दोर्कार. इंका ओर बस्‍केळ्‍क पिस्सना पिस्वरता वारसदार आयानुर. ");
INSERT INTO esg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","गानि मुन्‍ने मत्‍तोर वेल्‍लेटुर पज्जो आयानुर. पज्‍जोटोर मुन्‍ने आयानुर,” इंचि येसु ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","येसु मर्रा इल्‍हा इत्‍तोर. नना मीकु स्वर्ग राज्येम बारेमते उंदि वेसुड वेहंतन केंजट. वरोर मालक मत्‍तोर. ओर हक्‍केरेने तेदसि, ओना अंगुर बगिचाते कबळ कियालय बूतिनोराहाटीं पलाते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","मनकंकंटिकि उंदि रोजुना बूति हींतन इंचि करार कीसि, ओर्कुन अंगुर बगिचाते कबळ्‍क लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","जावोळ्‍द पोळ्‍द आतस्के आ नेदा मालक हाटुमते होंचि हूळतोर, अस्‍के रिकम मनानोर इच्‍चुर मंदि ओन्क दिसतुर. ");
INSERT INTO esg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","मिमेटगुडा नावा अंगुर बगिचाते कबळ कियालय होंट. मीवा कबळलायक बूति मीकु हींतन, इंचि मालक ओर्क वेहतोर. अल्हा इत्‍तारित्‍ते ओरगुडा बगिचाते कबळ कियालय होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","आ मालक पियाटील आनि पोंटेकु मर्रा हाटुमते होत्‍तोर. रोंडु मल्कां इंका बूतिनोर्कुन तच्‍चि बगिचाते कबळ कियालय वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","पोळ्‍द अर्रालय गंटामेड मत्‍तस्के आ मालक मर्रा उंदि मल्का हाटुमते होत्‍तोर, अस्‍के इंका इच्‍चुर मंदि रिकम मत्‍तोर्कुन हूळतोर. “मिमेट इगे पोळ्‍दमेड वट्‍टिदे बारि नित्‍तिसि मंतिर?” इंचि मालक ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","अस्‍के, “माकुन बोरे बूतिक केया हिल्‍लुर, दानहेंके मोमोट नित्‍तिसि मंतोम दादा!” इंचि ओर इत्‍तुर. अस्‍के, “अल्हा अय्ते मिमेट इंका नावा अंगुर बगिचाते कबळ कियालय होंट,” इंचि आ मालक ओर्कुन वेहतोर. अस्‍के ओर होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“पोळ्‍दु होत्‍तारित्‍ते अंटोर बूतिनोर्कुन केय्‍सि, अंटोर्क बूति हीम, आकिर वातोरकुंक मुन्‍ने हीम, मुन्‍ने वातोर्कुंक आकिर हीम,” इंचि मालक ओना जीतागानकु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","पोळ्‍दु अर्रालय गंटामेड मत्‍तस्के बूतिक वातोर, बूति एतालय होत्‍तुर, अस्‍के ओर्कु पोळ्‍दमेटा बूति दोर्कुता. ");
INSERT INTO esg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","अदुन हूळसि “माकु वेल्‍लेन कोत्‍तां दोर्कनुं बारे,” इंचि हक्‍केरे वाता बूतिनोर इनकुत्‍तुर. गानि ओर्कु इंका अचोने बूति दोर्कुता. ");
INSERT INTO esg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","आ बूति एततस्के ओर मालकुन इत्‍तुर, “ईर पज्जो वासि उंदि गंटा कबळ कीतुर, मोमोट अय्ते ईरकन्‍ना एक्‍को कस्‍टमते, एर्रना एद्‍दिते कबळ कीतोम. गानि निमे माकु ओरा अचोने बूति हीतिन, इद माकु नच्‍चा हिल्‍ले,” इंचि गुल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“नना नीकु बतल अन्‍यायम किया हिल्‍लेन, नना नीकु उंदि रोजुना बूति हींतन इंचि इत्‍तस्के निमे ओप्कुतिन गदा? ");
INSERT INTO esg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","अदुनहाटीं निमे गुल्‍गाकोंटा नीवा बूति पीसि होन. नीकु नना बच्‍चोन बूति हीतन, अचोने बूति ईर आकिरते वातोर्क इंका हियना नावा मनसु मंता. ");
INSERT INTO esg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","नना नावा कोत्‍तन नावा मनसु मताप कर्स कियना हक्‍कु नाकु हिल्‍लेना? नना बेस मनकन मत्‍ताहाटीं निमे नापोर्रो बारि अळसंतिन?” इंचि ओरा अव्टेटाल वरोन मनकन मालक इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","इल्‍हा बोर अय्ते पज्जो मंतुर, ओर मुन्‍ने आयानुर, मुन्‍ने मत्‍तोर पज्जो आयानुर, इंचि वेह्‍चि, येसु वेसुडि वेहमळ आपतोर. ");
INSERT INTO esg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","येसु येरुसलेम होननेंके, पन्‍नेंडु सिस्युल्कुन उंदि बाजुंक ओसि, ");
INSERT INTO esg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“हुळाट, मनम येरुसलेम होंचंतोम, अगा होत्‍ता पजा मनकना रूपमते पुटतोन नाकुन पेद्‍दा पेर्मालोर्कुना आनि दर्मसास्‍त्रम कराहना गुरुल्कुना कय्‍दे पीसि हियानुर. ओर नाकु हामुर सिक्‍साता आदेस हियानुर. ");
INSERT INTO esg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","पजा यहुदि आयवोरा कय्‍दे अप्‍पजेपनुर, ओर नाकुन सिडांच्‍नुर, नापोर्रो उस्कानुर, पोट्‍टेते तन्‍नानुर, पजा नाकुन क्रुसुनपोर्रो मोल्‍लां कोह्कानुर. गानि मूडोव रोजुने नना मर्रा जीवाते तेदंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","अच्‍चोटेन जब्‍दिना मुत्‍तो दाना मर्क याकोब आनि योहानुन पीसि, येसुनगा वासि ओना काल्कुनपोर्रो अर्सि उंदि विनंति कीता. ");
INSERT INTO esg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“नीकु बतल गावाले?” इंचि येसु दान पूसकीतस्‍के, “निमे नीवा राज्येमते नावा इव्वुर मर्कुन, नीवा तिना बाजुंक वरोन, डेमा बाजुंक वरोन उद्‍दाना आदेस हीम” इंचि अद इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","जवाबुने, “मिमेट बतल पूसकीसंतिरो, अद मीक तेळियसेक हिल्‍ले. नना बव कस्‍टाल्‍क अय्ते बोगांचना मंता, अवुन मिमेट बोगांचा परकिटा?” इंचि येसु इत्‍तस्के, “हो, मोमोट तयार मंतोम,” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","पजा येसु ओर्कुन इल्‍हा इत्‍तोर, “नना कस्‍टाल्‍क बोगांचताप मिमेट बोगांचा परकिट, निजमे! गानि राज्येम कियनेंके, नावा तिना बाजुंक आनि नावा डेमा बाजुंक उपिच्‍चना अदिकार नाक हिल्‍ले. अव जेगां बोराहाटीं ना बाबाल तयार कीतोरो, ओरे अगा उद्‍दंतुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","आ दादाल-तम्मुना पोल्‍लें केंजसि, अगा मत्‍ता कळमता पदि मंदि सिस्युल्क ओरापोर्रो होंग आतुर. ");
INSERT INTO esg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","अस्‍के येसु सिस्युल्कुन ओना दग्‍गेरा केय्‍सि, “यहुदि आयवोरा राजालोर ओरा जीतागाह्कुन, ओरा कय्‍दा हिळु इर्रालय हूळंतुर, अल्‍हेने ई दुनियाता पेद्‍दा मनकालोरगुडा सिन्‍ना मनकालोरपोर्रो अदिकारम ताकसालय हूळंतुर, इद मीकु एर्के. ");
INSERT INTO esg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","गानि मिमेट मात्रम ओरालेसीं कियानायो. मी लोप्पोटाल बोर अय्ते पेद्‍दा आयालय हूळांतोरो, ओर मीवा सेवा कियानोर आयापींता. ");
INSERT INTO esg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","इंका मी लोप्पोटाल बोर अय्ते लीडर आंतन इंतोरो, ओर मीवा दासुड आयापींता. ");
INSERT INTO esg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","बारित्‍ते मनकना रूपमते पुटतोन नना, सेवा कियागोटकुनालय वाया हिल्‍लेन गानि वेरेतोरा सेवा कियालय आनि वेल्‍लेटोर्कुन पापमताल पेचाहलय, ओराहाटीं नावा जीवा हियालय वातन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","येसु आनि ओना सिस्युल्क यरिहो सहरताल पेय्सि होननेंके, ओना पज्जो लोकुल्‍कुना पेद्‍दा मंदा वाता. ");
INSERT INTO esg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अस्‍के हर्दा पक्‍काते इव्वुर गुड्‍डोर्क उद्‍दिसि मत्‍तुर. मावा मुन्‍नेटाल येसु होंचंतोर, इंचि ओर्कु एरपाट आतस्के ओर येसुन, “ए सामि, दाविद राजाना वंसमतोना! निमे मापोर्रो दया कीम,” इंचि वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","अस्‍के, “चुपचाप मंटु” इंचि लोकुल्‍क आ गुड्‍डोर्कुन रांगतुर. गानि आ गुड्‍डोर्क मात्रम, लगांचि, “ए सामि, दाविद राजाना वंसमतोना, मापोर्रो दया कीम,” इंचि मोत्‍कुनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","अस्‍के येसु आगसि, ओर्कुन केय्‍सि इल्‍हा इत्‍तोर. “नना मीहाटीं बतल कियना इंचि मीवा मनसु मंता?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","अस्‍के ओर, “माकु दिस्‍सानाल मावा कळ्‍कुन बेस कीम सामि!” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","येसुंक ओरापोर्रो दया वासि ओरा कळ्‍कुन इटतोर. इट्ता इट्‍टुडे ओरा कळ्‍कु बेस आसि, दिसालय दल्‍गतां. अस्‍के ओरगुडा येसुना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ओर अंटोर येरुसलेम सहरता दग्‍गेरा जय्‍तुन मराकुना गुट्‍टापोर्रो मनना बैतपागे इनना नाटेना दग्‍गेरा एव्‍तुर. पजा येसु इव्वुर सिस्युल्कुन केय्‍सि, ");
INSERT INTO esg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ओर्क इल्‍हा वेह्‍चि नाटे लोहतोर. “मी मुन्‍ने दिस्‍सना नाटे होंट, अगा एव्ता एव्‍वुडे मीकु उंदि दोहाचि मत्‍ता गाडदि आनि दाना पोरि दिसंता. अवुन लेहकुंचि नहगा पीसि वटु. ");
INSERT INTO esg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ओक्‍कला अवुन पीसि वायनेंके बोरन्‍ना मीकुन बतलन्‍ना इत्‍ते, ‘सामिंक इवुना अव्‍सरम मंता,’ इंचि वेहट. अस्‍के ओर अवुन बिराना ओम्टु इंचि इंतोर.” ");
INSERT INTO esg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","एनकटा पेनदा कबुरतोर वेहता पोल्‍लें निजम आयगोम इंचि इल्‍हा जर्गता. अद पोल्‍ले इल्‍हा मंता: ");
INSERT INTO esg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सियोनुना मिय्यळ्‍क वेहट गदा, हुळाट, मीवा राजाल मीहेके वासंतोर, ओर सांत बुद्‍दितोनि, बर्वु कांजना गाडदि पोरिनपोर्रो उद्‍दिस वासंतोर.” ");
INSERT INTO esg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","अस्‍के सिस्युल्क होंचि येसु वेहताप कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","सिस्युल्क गाडदि आनि गाडदि पोरिन येसुनगा पीसि वातुर. पजा अवुनपोर्रो ओरां कपडिं तारतुर. तारतारित्‍ते येसु आ गाडदि पोरिनपोर्रो उदुतोर. ");
INSERT INTO esg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","आ गर्दिते वेल्‍ले लोकुल्‍क येसुनहाटीं ओर केर्ता कपडिं तेंडसि हर्दे तारतुर. इंकिच्‍चुर अय्ते मराकुना कोम्मां नर्किसि हर्दे तारतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","अचोने आयका, “दाविद राजाना मर्रिंक होसन्‍ना! पेनबाबाना अदिकार पीसि वायानोंक, आसिर्वाद दोर्किकांटी! स्वर्गमता पेनबाबाना स्‍तुति आयिकांटी.” इल्‍हा वरगेयसेके येसुना पज्जो-मुन्‍ने लोकुल्‍कुना मंदा ताकसेक होनुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","येसु येरुसलेम सहरते होळियतोर, अस्‍के पूरा सहरअंता उंदे रोद्‍दा आता. “ईर बोर आंदुर?” इंचि अंटोर पूसकियुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","अस्‍के, “ईर गालिल एरियाता नासरेत नाटेना पेनदा कबुरतोर येसु आंदुर,” इंचि लोकुल्‍क वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","पजा येसु अगाटा गुळिते होंचि, अगा अम्मानोर्कुन, अस्सानोर्कुन अंटोर्कुन पेच्‍हाचि गेदुमतोर. अचोने आयका अगा मत्‍ता कोत्‍तां अदला-बदला कियानोरा बल्‍लन पावरेल्क अम्मानोरा कुर्सिन मिड्हाचि वाटतोर. ");
INSERT INTO esg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","पजा येसु ओर्कुन इल्‍हा इत्‍तोर. “नावा लोतुन, पारतना कियाना लोन इंतुर, इंचि दर्मसास्‍त्रमते रासि मंता, गानि मिमेट दीन दोंगाल्क मक्‍कना जेगा कीतिर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","गुळिते येसुनगा गुड्‍डोर्क, कुंटोर्क वातुर, ओर्कुन अंटोर्कुन येसु बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","गुळितगा येसु कीता पेद्‍दा-पेद्‍दा इचंत्रमता कबाह्‍क हूळसि “दाविद राजाना मर्रिंक होसन्‍ना” इंचि पिलाल्कुना मोत्‍कुन्‍मडतुन केंजसि अगा मत्‍ता पेद्‍दा पेर्मालोर दर्मसास्‍त्रम कराहना गुरुल्क इरगा होंगुंक वातुर. ");
INSERT INTO esg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","अस्‍के ओर येसुन, “पिलाल्क नीकुन बतल इंचंतुर, अद निमे केंजतिना?” इंचि पूसकीतुर. अस्‍के येसु, “हो, केंजसंतन. ए पेनबाबा, निमे सिन्‍ना पिलाल्कुंक आनि पाल उनना पिलाल्कुंक स्‍तुति कियमळ कराहतिन, इंचि दर्मसास्‍त्रमते रासि मंता. अद मिमेट बस्‍केने हदवा हिल्‍लिरा?” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","पजा येसु ओर्कुन अग्गेन होळसि, सहरता पलाते बेतानि सहर होंचि, अद नर्का अग्गेन मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","हक्‍केरे येसु वापस सहरताहेके होननेंके ओन्क कर्वेस्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","अस्‍के हर्दा पक्‍काते उंदि अंजिर मरातुन हूळसि आ मरातगा होत्‍तोर. गानि आ मराकु आकिं तप्‍पा बतांगे मनाहिल्‍लें. अस्‍के, “इंका नीकु बस्‍केने कायां हादा मन्‍नि,” इंचि येसु आ मरातुन इत्‍तोर. अल्हा इत्‍ता इन्‍मळे आ मरा वतसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","अल्हा आतद हूळसि सिस्युल्कुंक इचंत्रम आता. अस्‍के ओर, “अंजिर मरा इच्‍चोर बिराना बल्हा वतसि होत्‍ता?” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","अस्‍के येसु ओर्कु इल्‍हा जवाब हीतोर. “नना मीकु निजम वेहांतन, ओक्‍कला मीकु बतले अनमानम हिलाकोंटा पेनदापोर्रो विस्वासम मनानय्ते, नना बल्हा अंजिर मरातुन कीतनो अल्हा मिमेटगुडा किया परांतिर. अचोने आयो इद गुट्‍टातुन, ‘इग्‍गेटाल तेदसि समुद्रमते होंचि अर्रा,’ इंचि इनानय्ते, अद होंचि समुद्रमते अर्रंता. ");
INSERT INTO esg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","मिमेट विस्वासमतोनि पारतनाते बतल तल्‍किना अद मीकु दोर्कार,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","पजा येसु गुळिते होळियसि पेनदा पोल्‍लें कराहसेके मननेंके, अगा पेद्‍दा पेर्मालोर आनि यहुदिल्कुना पेद्‍दाल्क ओनगा वातुर. वासि, “निमे ई कबाह्‍क बद अदिकारमते कीसंतिन? नीकु ई अदिकारम बोर हीतोर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर. “ननागुडा मीकुन उंदि सवाल पूसकींतन, मिमेट जवाब हियानय्ते, नना बद अदिकारमते इव कबाह्‍क कीसंतन इत्‍तद वेहंतन. ");
INSERT INTO esg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","अय्ते वेहट, योहानुंक बापतिस्मा हियाना अदिकारम बगाटाल दोर्कता? स्वर्गमताला हिलाकोंटे मनकालोराहेंदाल दोर्कतना?” इत्‍तोर. अस्‍के ओर ओरे इल्‍हा वळ्ककुनालय दल्‍गतुर. “ओक्‍कला स्वर्गमताल दोर्कता इंचि मनम इनानय्ते, ‘योहानुन बारि विस्वासम किय्‍यिर?’ इंचि इनानुर. ");
INSERT INTO esg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ओक्‍कला मनकालोराहेंदाल दोर्कता इनानय्ते, लोकुल्‍कुना वेर्रे! बारित्‍ते योहान पेनदा कबुरतोर आंदुर इंचि लोकुल्‍क नम्मंतुर.” ");
INSERT INTO esg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","अदुनहाटीं ओर, “माक एर्का हिल्‍ले,” इंचि इत्‍तुर. अस्‍के, “अल्हा अय्ते, इव कबाह्‍क बद अदिकारमते कीसंतनो, ननागुडा मीकु वेहोन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","केंजट, नना उंदि सिन्‍ना वेसुड वेहंतन, दान केंजसि मिमेट बतल इनकुंतिरो वेहट. वरोर मनकंक इव्वुर मर्क मत्‍तुर. उंदि मल्का आ मनकल ओना पेद्‍दा मर्रिनगा होंचि, “कोको, निमे इय्याला अंगुर बगिचाते होंचि कबळ कीम,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","अस्‍के आ पेद्‍दा मर्रि “नना होनोन” इत्‍तोर गानि पज्जो ओर विचारम कीसि बगिचाते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","पजा आ मनकल ओना इंकावरोर मर्रिनगा होंचि, “कोको, इय्याला निमे अंगुर बगिचाते होंचि कबळ कीम” इंचि वेहतोर. अस्‍के आ मर्रि, “सरे दांतन बाबा!” इत्‍तोर, गानि ओर होनेन हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","अय्ते आ इव्वुर मर्कनाल बा मर्रि बाबोना पोल्‍ले केंजताप? इंचि येसु ओर्कुन पूसकीतोर. अस्‍के ओर, “पेद्‍दा मर्रि केंजतोर,” इंचि इत्‍तुर. “नना निजम वेहंतन, बोगामोताह्क आनि कर वसुल कियानोर मीकन्‍ना मुन्‍ने पेनदा राज्येमते दांतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","योहान मीकु सत्‍तेमता हर्रि हुप्‍सालय वातोर, ओन मिमेट नम्मा हिल्‍लिर. गानि बोगामोताह्क, कर वसुल कियानोर बारे ओन नमतुर, इद मीकु एर्के. अय्नागानि मीवा मनसु बदलांचि योहानुन नम्‍मालय मिमेट तयार आया हिल्‍लिर,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","पजा येसु इल्‍हा इत्‍तोर. केंजट, इंकुंदि वेसुडि वेहांतन, वरोर मनकल मत्‍तोर. ओर उंदि अंगुर तोटा कीतोर. आ तोटा सुट्‍टु गूरे दोहाचि तोटाता लोप्पेन अंगुर पंडिना पानकम तेंडालय उंदि पोक्‍का तव्‍सि गानगु तयार कीतोर. दाना दग्गेरेने कावेलहाटीं उंदि मंडा वाटतोर. पजा तोटातुन वेरेतोर्क बटाइक हीसि, वेरे देसेम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","अंगुर पंडिं कोय्याना वेला वाता, अस्‍के पालुनाहाटीं ओना दासुल्‍कुन बटाइतोरहेके लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","अस्‍के बटाइतोर दासुल्‍कुन दोर्कापीसि, वरोन तंतुर, वरोन हव्कतुर, वरोनपोर्रो बारे बंडां हुक्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","इद केंजसि बगिचाता मालक इंका एक्‍को दासुल्‍कुन लोहतोर. ओरतोनिगुडा बटाइतोर मोदाला कीतापे कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आकिरते, “नावा मर्रिन बेस कदर कियानुर,” इनकुंचि ओना मर्रिन ओरहेके लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","गानि बटाइतोर, ओना मर्रि वायानद हूळसि, “ईर अय्ते वारसदार आंदुर, दट ओन हव्‍किसि, ओना जाय्‍दाद मनम एतकुनकोम,” इंचि ओर ओरे इनकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","पजा ओन दोर्कापीसि तोटाता पलाते ओसि हव्कतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","अय्ते आ तोटाता मालक वायानय्ते, आ बटाइतोर्कुन बतल कियानुर? ");
INSERT INTO esg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ओर येसुन इत्‍तुर, “असोंटा दुस्‍टुल्कुन तंचि-तंचि हव्कानुर आनि बोर अय्ते पंटा पेय्‍स्‍तस्‍के ओन्क वेलापोर्रो तूस हींतोरो, ओन्क बटाइक हिय्यानुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","पजा येसु ओर्कुन इल्‍हा इत्‍तोर. “मिमेट दर्मसास्‍त्रमते बस्‍केन हदवा हिल्‍लिरा? बद बंडातुन अय्ते मिस्‍त्रिल्‍क कबळ्‍क ओज्‍जो इंचि हय्‍सा हिल्‍लुर, अदे बंडा सेंकु मूलाता पुनादि बंडा आता. इद सामि कीता कबळ आंद, इद मना नदरते इचंत्रमाता कबळ आंद,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“मिमेट निजम इत्‍तिर. केंजट, दाना अर्तम इल्‍हा मंता. पेन मीकु हियना स्वर्ग राज्येमतुन तेंडसि, मीवा जेगाते दाना पोल्‍लेपोर्रो तिरियना वेरे जाति लोकुल्‍कुंक हींता. ");
INSERT INTO esg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","बोर अय्ते इद बंडापोर्रो अर्रंतुर, ओर तुकडां-तुकडां आयनुर, गानि अद बंडा बोरपोर्रो अय्ते अर्रंता, ओर पिच्‍चि-पिच्‍चि आयानुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","पेद्‍दा पेर्मालोर्क आनि परिसिल्क येसु वेहता वेसुडिं केंजसि, येसु ओरा बारेमतेन वळ्कसंतोर इंचि एरपाट कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","पजा ओर येसुन दोर्का पियालय हूळतुर, गानि लोकुल्‍कुन हूळसि वेरियतुर. बारित्‍ते लोकुल्‍क येसुन पेनदा कबुरतोर आंदुर इंचि नमतुर. ");
INSERT INTO esg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","येसु मरुंदि मल्का, लोकुल्‍कुंक वेसुडि वेहासेक इल्‍हा वळकालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","स्वर्ग राज्येम वरोर राजानलेसीं मंता. ओर ओना मर्रिना मरमिंकु उंदि कुळ्‍पु इरतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","आ कुळ्‍पुंकु बोर्कुन अय्ते केय्‍सि मत्‍तोरो, ओर्कुन केय्‍सि तायालय, ओना दासुल्‍कुन लोहतोर. गानि ओर वायोम इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","वायोम इंचि इत्‍तारित्‍ते, मर्रा इच्‍चुर दासुल्‍कुन राजाल इल्‍हा वेहट इंचि लोहतोर, “हुळाट, मीहाटीं नना कुळ्‍पु इरतन, बल्सता कुर्रा आनि कोंदा कोयतन, कुसिरगुडा वेसि तयार मंता. अदुनहाटीं मिमेट गाटो तिनालय ताकट इंचि इंटु,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","राजाल वेहिनागानि, राजाना पोल्‍लेता कदर कियाकोंटा, इच्‍चुर ओरा पोलाल्‍कुनहेके होत्‍तुर, इच्‍चुर बारे ओरा कबळ दंदानहेके होत्‍तुर. इच्‍चुर बारे राजाना दासुल्‍कुन पीसि तंचि हव्‍किसि पोहतुर. ");
INSERT INTO esg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","अस्‍के राजांक इरगा होंग वाता. पजा राजाल ओना सिपाइल्कुन लोहचि, ओना दासुल्‍कुन हव्कतोर्कु हव्‍किसि ओरा सहरकु तडमि दोस्‍सा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","पजा राजाल ओना दासुल्‍कुंक इल्‍हा वेहतोर. “मरमिना कुळ्‍पु तयार मंता. गानि केयता मनकालोर बेसटुर आयुर. ");
INSERT INTO esg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","अदुनहाटीं मिमेट हर्कुन पीसि, गल्‍लीं, बजारकुन पीसि होंचि दोर्कुतोर अंटोर्कुन गाटो तिनालय केय्‍सि तटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","अस्‍के दासुल्क, हर्कु, गल्‍लीं पीसि होंचि बेसतोर, सेड्‍डोर अंटोर्कुन जमा कीसि तत्‍तुर. अस्‍के मरमिना लोते हेडमितुर निंडिस होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","अस्‍के वाता हेडमितोर्कुन राजाल हूळतस्‍के, मरमिन लोप्पो मरमिन लायक बेसता कपडिं केरुवा वरोर मनकल ओन्क दिसतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","अस्‍के राजाल ओन, “निमे मरमिन लोप्पो बेसता कपडिं केरुवा, मरमिना मंडाता हिळु बल्हा वातिन?” इंचि ओन पूसकीतोर गानि आ मनकल बतले वळका हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","अस्‍के राजाल ओना जीतागाह्कुन केय्‍सि, “ईना कय्‍क-काल्क दोहचि, पलाते हीकटते पोहचीम्ट. अगा मनानोर अळसेके, वरगेयसेके, पल्कु कोर्कसेक मनांतुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","पजा, “केयतोर वेल्‍लेटुरे मंतुर. गानि पेर्कुत्‍तोरु मात्रम इच्‍चुरे मंतुर,” इंचि येसु वेसुड वेहामळ आपतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","पजा परिसिल्क अगटाल पेय्सि उंदगा जमा आसि, येसुन बल्हा किसन्‍ना ओर वळकाना पोल्‍लेतेन ओना तप्पु दोर्का पियाना इंचि उपायम कियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","परिसिल्क येसुन पसांचना उपायाल्‍क कीसि, ओरा इच्‍चुर सिस्युल्कुन हेरोद राजाना मनकालोरतोनि ओनाहेके लोहचीतुर. ओर येसुनगा होंचि इल्‍हा इत्‍तुर. “गुरु, निमे निजम वळ्‍कानोन, पेनदा हर्दा बारेमते सत्‍तेमते करहानोन आंदिन इंचि माक एरपाट मंता. बोर बतल इनिनागानि दाना पिकिरगुडा किय्‍यिन, निमे लोकुल्‍कुना मोकम हूळसि वळ्किन, इदिंका माकु एरके. ");
INSERT INTO esg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","अय्ते माकु वेहा. नियम परकारम, कैसर राजांक कर दोहमळ न्‍यायमेना आयोना? नीवा विचारमते बतल मंता?” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ओरा कोंटे उपायाल्‍क येसुंक मुन्‍नेटाले एर्का मत्‍ताहाटीं ओर ओर्कुन इल्‍हा इत्‍तोर. “ए डोंगिरिटा, बारि नावा पट्‍टु हूळांतिर? ");
INSERT INTO esg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","मिमेट कर दोहना कोत्‍ता नाकु हुप्‍सट,” इत्‍तोर. अस्‍के आ लोकुल्‍क ओन्क उंदि एंडि बंडि हुपिस्तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","हुपिस्तस्के, “इद एंडि बंडिपोर्रो बोना पोटुवा आनि पोरोल मंता?” इंचि येसु ओर्कुन पूसकीतस्‍के, ");
INSERT INTO esg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“कैसर राजानद,” इंचि ओर इत्‍तुर. पजा येसु ओर्कु वेहतोर. “बद कैसर राजानद मंता, अद कैसर राजांक हीम्टु, बद अय्ते पेनदाद मंता, अद पेनदुक हीम्टु.” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","येसुना पोल्‍लें केंजसि, ओर्कु इचंत्रम आता. पजा ओर अगटाल होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","अदे रोजु इच्‍चुर सदुकिर येसुनगा वातुर (ईर हासि मर्रा जीवाते तेदमळतुन ईर नम्मुर.) ");
INSERT INTO esg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","वासि इल्‍हा सवाल पूसकीतुर, “गुरु, मूसाना नियम परकारम, वरोर मनकल पिलाल्क आयाका मुन्‍नेन हायानय्ते ओना मुत्‍तोनतोनि ओना तम्मुर मरमिं आसि, हातोना वंसम बेर्सागोटालय पिलाल्कुन कना परांतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","अय्ते महगा एडुर दादाल-तम्मुह्‍क मत्‍तुर. पेद्‍दा दादाना मरमिं आतां गानि पिलाल्क आयाका मुन्‍नेन ओर हातोर. पजा ओना मुत्‍तोन ओना तम्मुर मरमिं आतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","आ तम्मुरगुडा पिलाल्क आयाका मुन्‍नेन हातोर. पजा ओना पज्‍जोटोर दान मरमिं आतोर ओरगुडा हातोर. इल्‍हा एडुरगुडा दानतोनि मरमिं आसि पिलाल्क आयाका मुन्‍नेन हातुर. ");
INSERT INTO esg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","अंटोर हाता पजा, आ मुरतळगुडा हाता. ");
INSERT INTO esg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","अय्ते हातोर अंटोर मर्रा जीवाते तेदतस्‍के, आ एडुर लोप्पोटाल अद बोना मुत्‍तो आयार? बारित्‍ते, ओर एडुरगुडा दान मरमिं आसि मत्‍तुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर. “मिमेट दर्मसास्‍त्रमतुन आनि पेनदा ताकततुन एरपाट कियाका तप्पु अर्तम कीकुंचंतिर. ");
INSERT INTO esg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","बारित्‍ते हातोर मर्रा जीवाते तेदानुर अस्‍के, ओर मरमिं आयुर, मरमिं कीसिगुडा हिय्युर. गानि ओर स्वर्गमता पेनदा दूतनलेसीं मनांतुर. ");
INSERT INTO esg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","गानि हातोर मर्रा जीवाते तेदानुर इंचि दर्मसास्‍त्रमते वेहचि मंता, अद बतल इत्‍ते, ‘नना अब्राहाम, इसाक आनि याकोबुना पेनदुन आंदुन,’ इंचि पेन इत्‍ता. अदुन हद्‍विसि दाना अर्तम बस्‍केने एरपाट किय्‍या हिल्‍लिरा? इंचि अद हातोरा पेन आयो गानि जीवाते मनानोरा पेन आंद,” इल्‍हा येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","येसु इच्‍चोन वळ्‍कतारित्‍ते, अगा मत्‍ता लोकुल्‍क ओना पोल्‍लें केंजसि इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","येसु सदुकिर्कुन वळकाकोंटा कीतोर इंचि परिसिल्कुंक तेळियतारित्‍ते ओर जमा आसि येसुनहेके वातुर. ");
INSERT INTO esg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ओरा लोप्पो मूसाना नियम बेस तेळियतोर वरोर मत्‍तोर, ओर येसुना पट्‍टु हूळालय, ");
INSERT INTO esg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“गुरु, मूसाना नियम लोप्पो अन्‍निंकन्‍ना पेद्‍दा आदेस बद आंद?” इंचि येसुन सवाल पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","अस्‍के, “निमे नीवा सामि आता पेनदुन पूरा मनसुनाल, पूरा आत्माताल, पूरा बुद्‍दिताल पावरम कीम. ");
INSERT INTO esg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","इदे अन्‍निंकन्‍ना पेद्‍दा आनि मोदोलता आदेस आंद. ");
INSERT INTO esg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","रोंडो आदेस बतल इत्‍ते, नीवद निमे बच्‍चोन पावरम कींतिनो, अचोने पावरम इंकावरोनगुडा कीम. ");
INSERT INTO esg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","इव रोंडु आदेसकुना आदारम पोर्रेने मूसाना नियम आनि पेनदा कबुरतोर रासता पुस्तकाल्क मंतां.” इंचि येसु जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","पजा परिसिल्क उंदगा जमा आसि मत्‍तस्के, येसु ओर्कुन उंदि सवाल पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“किरिस्‍तुना बारेमते मीवद बतल विचारम मंता? ओर बोना मर्रि आंदुर?” अस्‍के, “ओर दाविदना मर्रि आंदुर,” इंचि परिसिल्क इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “अय्ते, दाविद पवित्र आत्माते निंडसि इल्‍हा इत्‍तोर. सामि नावा सामिन इत्‍तोर, बदवेरदाका अय्ते नीवा पगातोर्कुन नीवा काल्कुनगा तायोन, अदवेरदाका नावा तिना बाजुंक उद्‍दिसि मन. ");
INSERT INTO esg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","कुद्‍दु दाविद ओन सामि इंचि इत्‍तोर अय्ते ओर दाविदना मर्रि बल्हा आया परांतोर?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","अस्‍के ओर बोरे येसुना पोल्‍लेक जवाब हिया पराहिल्‍लुर. आ रोजुनाल येसुन बद्‍दे सवाल पूसकियालय बोर्कु हिम्मत आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","सिस्युल्कुन आनि अगाटा मंदितुन हूळसि येसु इत्‍तोर गदा, ");
INSERT INTO esg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“दर्मसास्‍त्रम कराहना गुरुल्कुंक आनि परिसिल्कुंक मूसाना नियम कराहना हक्‍कु मंता. ");
INSERT INTO esg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","4","इंचि ओर तेहते तेदा पर्रुवा मोता दोह्‍चि मनकालोरा हट्‍टनपोर्रो इर्रंतुर गानि आ मोतातुन कांजसि ओयनेंके वेलु दोस्‍सि आसरागुडा आयुर. अदुनहाटीं ओर मीकु बतल-बतल वेहंतुरो अव अन्‍नि कीसेके ताकटु, गानि ओर कीताप मात्रम कियमट.” ");
INSERT INTO esg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ओर ओरा कबाह्‍क लोकुल्‍क हूळना इंचि कींतुर. पेनदा पोल्‍लेन रासि, तायित्‍कुने निहचि पेद्‍दा-पेद्‍दा दुम्में ओरा दंडा कयकुंक, कप्पर्क दोहकुंतुर. ओरा कपडिना कोंगुल्कु जिल्‍लर-जल्‍लर होळसींतुर. लोकुल्‍क ओर्कुन “सादु” इनागोम इंचि इल्‍हा कींतुर. ");
INSERT INTO esg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","अचोने आयाका दर्मसास्‍त्रम कराहना लोह्कुने, कुळ्‍पुकुने पेद्‍दाल्‍क उद्‍दाना जेगाते उदमळ इत्‍ते ओर्क वेल्‍ले इस्‍टम. ");
INSERT INTO esg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हाटुमकुने जोहार वेहागोटकुनमळ, मनकालोराहेंदाल गुरु इंचि केया वेहकुनमळ ओर्कु बेस अनपिच्‍चंता. ");
INSERT INTO esg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","गानि मिमेट अंटोर दादालोर-तम्मुह्‍क आंदिर, मीवा अंटोरा गुरु वरोरे. अदुनहाटीं मिमेट मीकुन “गुरु” इंचि इनागोटकुन्‍मटु. ");
INSERT INTO esg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","स्वर्गमते मनना पेने मीवा बाबाल आंदुर, अदुनहाटीं इद बूमिते मिमेट बोने “बाबा” इंचि इनमटु. ");
INSERT INTO esg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","अल्‍हेने मीकु वरोरे सामि मंतोर, ओर किरिस्‍तु आंदुर. अदुनहाटीं मीकुन बोरे “सामि” इंचि केया मन्‍नि. ");
INSERT INTO esg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","गानि बोर अय्ते पेनदा मुन्‍ने अंटोर्कन्‍ना पेद्‍दा आयालय हूळांतोर, ओर अंटोरा सेवा कियानोर आयिर. ");
INSERT INTO esg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","बोर अय्ते, ओनद ओरे पेद्‍दा इनकुनानुर, पेन ओन सिन्‍ना किय्‍यार. अल्‍हेने बोर अय्ते पेनदाहाटीं सिन्‍ना आसि ताकांतोर, ओन पेन पेद्‍दा किय्‍यार. ");
INSERT INTO esg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","अरे डोंगि परिसिल्क आनि दर्मसास्‍त्रम कराहना गुरुल्कुनिटा, मीक गोसा तप्‍पो. स्वर्ग राज्येमते होनानोरा हर्रि मिमेट बंद कीतिर. मिमेट अय्ते होन्‍निर, होनानोर्कुनगुडा होन्‍ना हिय्यिर. ");
INSERT INTO esg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","अरे डोंगि दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्कुनिटा, मीकु गोसा तप्‍पो. मुंडामोस्ता मुर्ताह्‍कुन मुळाहंतिर. अल्‍हेने लोकुल्‍कुंक हुप्‍सालय वेल्‍लेनजेम पारतना कींतिर. मिमेट डोंगिर्क आंदिर! मीकु पेन एक्‍को सिक्‍सा हिय्यार. ");
INSERT INTO esg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","अरे डोंगि दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्कुनिटा! वरोन मीवा मतमते तायालय मिमेट देसे-देसेम तिरियसि बूमि-मब्बु उंदि कींतिर. ओर मीलोप्‍पो वातस्के, मिमेट ओन मीकन्‍ना एक्‍को पापमते अरहचि नरकमते लोहंतिट, दानहाटीं मीकु बच्‍चोर पेद्‍दा गोसा वायार. ");
INSERT INTO esg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","अरे, हर्रि हुप्‍संतोम इनना गुड्‍डिर्कनिटा! मिमेट इंतिर गदा, बोर अय्ते पेनदा गुळिता ओट्‍टु तिंतोर, ओन्क बतल आयो. गानि बोर अय्ते गुळि लोप्पोटा बंगारमता ओट्‍टु तिंतोर, ओन्क मात्रम आ ओट्‍टु परकारम ताका पींता, इंचि इंतिर. दानहाटीं मीकु बच्‍चोर पेद्‍दा गोसा वायार. ");
INSERT INTO esg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","अरे गुड्‍डिर! बद पेद्‍देद, बंगारमा बंगारमतुन पवित्र कियना गुळिआ? ");
INSERT INTO esg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","इंका इल्‍हा इंतिर गदा, बोरन्‍ना पेन गद्‍देता ओट्‍टु तिंचि दान परकारम ताकाकोंटे बतल आयो, गानि पेन गद्‍देपोर्रो वाटता उपारमता ओट्‍टु बोर अय्ते तिंतोर, ओन्क मात्रम आ ओट्‍टु परकारम ताका पींता. ");
INSERT INTO esg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","अरे गुड्‍डिर्कनिटा! पेन गद्‍दे पेद्‍देदा मरि पेन गद्‍दे हेंदाल पवित्र आयना दानपोर्रो वाटता उपारम पेद्‍देदा? ");
INSERT INTO esg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","अदुनहेंके बोर पेन गद्‍देता ओट्‍टु तिंतोर, ओर पेन गद्‍देपोर्रो मत्‍ता अन्‍निटवुना ओट्‍टु तित्‍तापे. ");
INSERT INTO esg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","अल्‍हेने बोर अय्ते गुळिता ओट्‍टु तिंतोर, ओर गुळिते मनना पेनदा ओट्‍टु इंका तिंतोर. ");
INSERT INTO esg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","बोर अय्ते स्वर्गमता ओट्‍टु तिंतोर, ओर पेनदा राजगद्‍दे आनि राजगद्‍देपोर्रो उदिस मनानोनद इंका ओट्‍टु तिंतोर. ");
INSERT INTO esg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","अरे डोंगि दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्कुनिटा, मीक गोसा तप्‍पो. बारित्‍ते मिमेट पुदिना, जिल्करा, सोप इसोंटा पंटातालगुडा पदि तूसकुनाल उंदि तूस पेनदुक हींतिर. गानि न्‍यायमते तिरियमळ, दया कियमळ, पेनदापोर्रो विस्वासम इरमळ इसोंटव दर्मसास्‍त्रमता बेसता पोल्‍लेन मिमेट होळसीतिर. पदि तूसकुनाल उंदि तूस पेनदुक हियमळ इद बेसे. गानि इद कीसेक-कीसेक अवुनगुडा होळसाकोंटा ताका मत्‍तिर. ");
INSERT INTO esg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हर्रि हुप्‍संतोम इनना गुड्‍डिर्कनिटा! मिमेट नुल्‍लेतुन बारे वडा पीसि उंटिर गानि लोटापेटातुन बारे हूळवा अल्हे मिंगांतिर. ");
INSERT INTO esg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","अरे डोंगि दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्कुनिटा, मीकु गोसा तप्‍पो. बारित्‍ते, मिमेट गिन्‍नें-गिलासकु सिराप लोकुल्‍कुंक दिसालय पलाताल तोमसि साप कींतिर, गानि लोप्पो मात्रम मीवा कराब गुनाल्‍क, पापाल्क निंडिस मंतां. ");
INSERT INTO esg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","अरे गुड्‍डि परिसिल्कुनिटा! मुन्‍ने मीवा गिलासकु-गिन्‍नेन लोप्पोटाल तोमसि नोर्राटु, अस्‍के अव पलातालगुडा बेस दिसंता. ");
INSERT INTO esg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","अरे डोंगि दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्कुनिटा, मीकु गोसा तप्‍पो. बारित्‍ते मिमेट तेल्‍लटा सुन्‍ना होकता गोरिनसंटोर आंदिर. अव पलाताल हूळालय सक्‍कगा दिसंतां, गानि लोप्पो हूळते, पीनगुना बोक्‍कां कळियसि होंचि गब्‍बु पीसि मनंतां. ");
INSERT INTO esg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","अल्‍हेने मिमेट इंका पलाताल लोकुल्‍कुंक पक्‍का नीतिमंतुल्‍कुन लेह्का दिसंतिर. गानि मीवा पीट लोप्पो नडेह कियना बुद्‍दि, पापमता कबाह्‍क निंडिस मंता. ");
INSERT INTO esg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","अरे डोंगि दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्कुनिटा, मीकु गोसा तप्‍पो. बारित्‍ते, मिमेट पेनदा कबुरतोराहाटीं गोरिं दोहांतिर आनि नीतिमंतुल्‍कुना गोरिन सोक कींतिट. ");
INSERT INTO esg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अल्हा कीसि मिमेट इंतिर, मोमोट पेद्‍दाल्कुना कालमते मंचि मत्‍ते, पेनदा कबुरतोर्कुन हव्कानेंके, ओर्क सायता आया कोन्‍नेम. ");
INSERT INTO esg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","इल्‍हा इंचि, “मोमोट पेनदा कबुरतोर्कुन हव्कतोरा वंसमतोर्कुम आंदुम,” इंचि मीवद मिमेटे उल्टा गवाइ वेहकुंतिर. ");
INSERT INTO esg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","अय्ते मिमेट मीवा पेद्‍दाल्क सुरुव कीता पापमतुन पूरा कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ए तरासकुनसंटोरिटा! आनि नय तरास पोरिह्कुनसंटोरिटा! मिमेट बल्हा अयना नरकमते होनमळ तप्‍पो. ");
INSERT INTO esg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","अदुनहाटीं नना मीहेके पेनदा कबुरतोर्कुन, बुद्‍दिमंतुल्‍कुन आनि दर्मसास्‍त्रम कराहना गुरुल्‍कुन लोहांतन. मिमेट ओराव्टेटाल इच्‍चुर्कुन हव्‍ककिर, इच्‍चुर्कुन क्रुसुंक वेलाड वाटकिर, इच्‍चुर्कुन मीवा दर्मसास्‍त्रम कराहना लोह्कुने ओसि पोट्‍टेते तनकिर, तंचि ओर्कुन नार-नार तिराह्‍चि तिप्‍पल्‍क कीकिर. ");
INSERT INTO esg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","दीनहेंदाल, नीतिमंतुड आता आबेलनगटाल अय्ते गुळि आनि गद्‍दे नड्‍डुम मिमेट हव्‍कता बर्काना मर्रि जकर्याहनगड्‍क, बचटुर नीतिमंतुल्‍कुना नेत्‍तुर अय्ते ई बूमिपोर्रो पोंगागोटमळ जर्गता, आ अंटोरा नेत्‍तुरता दोसेम पूरा मीपोर्रो अर्रार. ");
INSERT INTO esg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","नना मीकु निजम वेहांतन, इव अन्‍नि पोल्‍लें ई पीळितोरपोर्रेन अर्रंतां. ");
INSERT INTO esg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ए येरुसलेमतोरिटा, ए येरुसलेमतोरिटा! मिमेट पेनदा कबुरतोर्कुन हव्‍कानोर आंदिर, इंका पेन मिहगा लोहचीतोर पोर्रो मिमेट बंडां हुक्‍कानोर आंदिर. कोर्रु दाना पीसेन रेक्‍काना हिळु बल्हा जमा कींतनो, अल्हेन ननागुडा मीवा पिलाल्कुन जमा कियना इंचि बच्‍चुंगो मल्कां कोरतन. गानि मिमेट मात्रम कोराहिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","हूळा, इंदके मी लोतुन मीहाटीं कुल्‍ला होळ्‍समळ जर्गता. पूरा लोन बतल हिलाकोंटा आंता. ");
INSERT INTO esg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","नना मीकु वेहानद बतल इत्‍ते, “सामिना पोरोलते वायानोर आसिर्वाद दोर्कतोर,” इंचि बदवेरदाका अय्ते मिमेट इन्‍निरो अदवेरदाका नाकुन मर्रा हूळिर. ");
INSERT INTO esg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","येसु गुळिताल पलाते पेय्सि होननेंके, ओना सिस्युल्क ओन्क गुळिता बंगलां हुप्‍सालय ओनगा होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","गानि येसु ओर्कु इल्‍हा जवाब हीतोर. “मिमेट इवन्‍निन हूळसंतिर गदा! नना मीकु निजम वेहांतन, इव बंडां उंदानपोर्रो उंदि मनाकोंटा कूल्‍हाना वेला वायनद मंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","आयंका येसु जय्‍तुन मराकुना गुट्‍टापोर्रो होंचि उदतोर. ओर ओंटिगा मत्‍तद हूळसि ओना सिस्युल्क ओनगा होंचि इल्‍हा इत्‍तुर, “इवन्‍नि गटनां बस्के जर्गनुं माक वेहा. इंका निमे वायाना वेला आनि दुनिया मुंळगना आकिर वेला बस्के आंता इंचि मोमोट बव चिन्‍हां हूळसि एरपाट कीकोम?” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","अस्‍के येसु ओर्कु इल्‍हा जवाब हीतोर. “मीकुन बोर पसांचकोंटा मिमेट उसारते मंटु. ");
INSERT INTO esg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","नावा पोरोल एतसेके बचुटूरो लोकुल्‍क वांतुर. वासि, ‘ननाने किरिस्‍तुन आंदुन’ इंचि वेल्‍लेटोर्कुन पसांचंनुर. ");
INSERT INTO esg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","मिमेट लडाईं आनि लडाईना पोल्‍लेना बारेमते केंजसि वेरियमट, अल्हा तप्‍पाकोंटा आयानुंगे. गानि दुनियाता आकिर वेला अस्‍केने वायो. ");
INSERT INTO esg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","देसेमपोर्रो देसेम, राज्येमपोर्रो राज्येम लडाईं आयनुं, वेरे-वेरे जेगाने बूकंपाल्क आयनुं, कर्वु अर्रार. ");
INSERT INTO esg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","गानि इल्‍हा आयमळ इत्‍ते एर पूरालय नोप्‍पिं सुरुव आताप आंद.” ");
INSERT INTO esg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“मिमेट नाकुन विस्वासम कीताहाटीं लोकुल्‍क मीकुन तकलिप कियालय अदिकारिल्कुंक अप्पजेपंतुर, अस्‍के ओर मीकुन हव्कंतुर, नावा पोरोलताहेंका दुनियातोर बोरे मीकुन हय्सुर. ");
INSERT INTO esg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","आ वेलाते बच्‍चटुरो विस्वासम कियानोर ओरा विस्वासम होळसंतुर. वरोंक-वरोर पगां आसि वरोंक-वरोर हयसाकोंटा आंतुर. ");
INSERT INTO esg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","बच्‍चटुरो आबद्‍दम कबुरतोर, पेनदा कबुरतोर्कुम इंचेके वांतुर, लोकुल्‍कुंक सेड्‍डा हर्रि हुपसंतुर. ");
INSERT INTO esg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","पापाल्क एक्‍को आसि वेल्‍ले मंदिता पावरम इंका तक्‍को आसेक दांता. ");
INSERT INTO esg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","गानि बोर अय्ते पेनदापोर्रोटा विस्वासमते आकिरदाका निल्‍सि मनंतोर, ओनके मुक्‍ति दोर्कार. ");
INSERT INTO esg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","पेनदा राज्येमता बारेमता बेसता कबुर दुनियाता अन्‍नि देसेल्‍कुना लोकुल्‍कुंक उंदि गवाइ इंचि तेळियागोटसि वेहतस्के, इद दुनियाता आकिर आयार.” ");
INSERT INTO esg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","दानिएल पोरोलता पेनदा कबुरतोर वेहताप, बोरे हय्‍सवसोंटा नासडेम कियाना वस्तु, गुळि लोप्पो पवित्र जेगाते नित्‍तिसि मत्‍तद मिमेट हूळकिर (हद्‍वानोर इदुन अर्तम कीकुंटु.) ");
INSERT INTO esg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","अस्‍के बोर अय्ते यहुदिया एरियाते मंतुरो, ओर गुट्‍टनहेके वित्‍तिर, ");
INSERT INTO esg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","बोर अय्ते लोतपोर्रो मंतोर, सामान पीसि वायालय लोप्पो होळियानायो, ");
INSERT INTO esg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","बोर अय्ते नेलिने कबळ कीसेक मंतोर, कपडिं पीसि वायालय मल्सि लोन होनानायो. ");
INSERT INTO esg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","अव रोजकुने पीटे मत्‍ता मुर्ताह्‍कुंक आनि सिन्‍ने मर्तल्‍लुह्‍कुंक वेल्‍लेन तकलिप वांता. ");
INSERT INTO esg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","पीनि कालमते अल्‍हेने नोमकेम रोजुने ई वित्‍तना वेला वायामन्‍नि इंचि मिमेट पारतना कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","बारित्‍ते अद वेलाते इसोंटा तकलिप वायार गदा, दुनिया पुट्तस्केटाल अय्ते इदवेरादाका, बस्‍केन वाया हिल्‍ले. मुन्‍नेगुडा बस्‍केन वायो. ");
INSERT INTO esg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ओक्‍कला पेन अव रोजकुन तक्‍को कियाकोंटा मंचि मत्‍ते, बोरे पिसाकोन्‍नेर. गानि पेर्कुत्‍ता लोकुल्‍कुनाहाटीं पेन अव रोजकुन तक्‍को किय्‍यार. ");
INSERT INTO esg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","अद वेलाते ओक्‍कला बोरन्‍ना मीकुन किरिस्‍तु इगे मंतोर, अगा मंतोर इनानय्ते, मिमेट ओर्कुन नम्मुमट. ");
INSERT INTO esg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","बारित्‍ते अव रोजकुने आबद्‍दम किरिस्‍तुल्‍क, पेनदा आबद्‍दम कबुरतोर वायानुर. आनि कुदुरते पेन पेर्कुत्‍ता लोकुल्‍कुन पसांचलय पेद्‍दा-पेद्‍दा चिन्‍हां, इचंत्रमता कबाह्‍क कीसि हुप्‍सानुर. ");
INSERT INTO esg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","हुळाट! नना अय्ते इव पोल्‍लें मीक मुन्‍नेने वेहचीतन. ");
INSERT INTO esg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","दानहाटीं “किरिस्‍तु केडाते मंतोर” इंचि मीकु बोरन्‍ना वेहानय्ते, मिमेट अगा होनमट. इंका “किरिस्‍तु लोप्पोटा अर्राते मंतोर” इंचि मीकु वेहानय्ते मिमेट ओनापोर्रो विस्वासम इरमट. ");
INSERT INTO esg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","बारित्‍ते बल्हा अय्ते पोळ्‍द पेयसनाहेके मेर्सते दाना वेलगु पोळ्‍द अर्रानगाह्क दिसंता, मनकना रूपमते पुटतोन नना वायानस्‍केगुडा अल्हे आयार. ");
INSERT INTO esg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","अल्‍हेने बगा अय्ते पीनगु मनंता अग्गेन गद्‍दलिं जमा आंतां. ");
INSERT INTO esg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","आ रोजकुना तकलिपकु मारता मारुडे, “पोळ्‍दुंक हीकट मुच्‍चका वायार, वेळसि वेल्‍गु हियाकोंटा आयार, मब्बुनाल सुक्‍कां हिळु अर्रानुं, मब्बुने मनना अन्‍नि सक्‍तिन कदलिच्‍मळ जर्गंता.” ");
INSERT INTO esg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","पजा मनकना रूपमते पुटतोन नना वायना चिन्‍ह स्वर्गमते दिस्‍सार, अस्‍के बूमि पोर्रोटोर अन्‍नि जातिना लोकुल्‍क वेल्‍ले दुक्‍कम कियानुर. पजा मनकना रूपमते पुटतोन नना पेद्‍दा महिमा आनि ताकततोनि मब्बु तेर्पेनपोर्रो उद्‍दिसि वायानेंके लोकुल्‍क हूळानुर. ");
INSERT INTO esg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","अस्‍के तूताकोमता पेद्‍दा आवाजुनतोनि, नना नावा दूतन बूमिपोर्रो लोहांतन. आ दूतां बूमिपोर्रो नालुं मूलानाल, मब्बुना ई कोस्‍साताल अय्ते आ कोस्‍सादाका नना पेर्कुत्‍ता लोकुल्‍कुन जमा कींतां. ");
INSERT INTO esg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","इंदके अंजिर मराताल उंदि पोल्‍ले करियट. अंजिर मराता कोम्मांक इग्गुर बस्के अय्ते वांता, अस्‍के एद्‍दि कालम दग्‍गेरा एव्ता इंचि मिमेट एरपाट कींतिर. ");
INSERT INTO esg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","इल्‍हा इव अन्‍नि गटनां जर्गनद हूळसि, ओर दग्‍गेरा मंतोर, गल्‍मातगेन मंतोर इंचि मिमेट एरपाट कींतिर. ");
INSERT INTO esg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","नना मीकु निजम वेहांतन, बदवेरदाका अय्ते इव अन्‍नि पोल्‍लें पुरागा आयोंगो, अदवेरदाका ई पीळि मुळगो. ");
INSERT INTO esg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","इद बूमि, मब्बु नासडेम आसि होंदार, गानि नावा पोल्‍लें बस्‍केने नासडेम आयों. ");
INSERT INTO esg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","अद रोजु, अद गळिया बोर्के तेळियो. स्वर्गमता दूतांक आयि, मनकना रूपमते पुटतोन नाकु आयि बोर्के तेळियो. गानि सिराप पेनबाबांके तेळियंता. ");
INSERT INTO esg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","नोहाना रोजकुने बल्हा जर्गतनो, मनकना रूपमते पुटतोन नना वायानस्‍केगुडा अल्हे जर्गार. ");
INSERT INTO esg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","कम्मुड वासि नोहाल डोंगाते नेंगनादाका लोकुल्‍क तिंचेके-उंचेके मरमिं कीसेके, आसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","कम्मुड वासि ओर्कुन तंचि ओयनदाका ओर्कु तेळिया हिल्‍ले. मनकना रूपमते पुटतोन नना वायानस्‍केगुडा अल्हे जर्गार. ");
INSERT INTO esg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","आ वेलाते नेदे इव्वुर कबळ कीसेके मनानुर, ओराव्टेटाल वरोन तेहाकुंचि ओयमळ जर्गंता, इंकावरोन अग्गेन होळ्‍समळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","रोंडु मुर्ताह्क गट्‍का नोरसेक मनंतां, उंदितुन ओयमळ जर्गंता, इंकुंदितुन अग्गेन होळ्‍समळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","बद रोजु मीवा सामि वायानुर अद मीकु एरपाट हिल्‍ले, अदुनहाटीं मिमेट तेल्‍विते मंटु. ");
INSERT INTO esg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","गानि मिमेट उंदि पोल्‍ले बेस तेळियागोट्‍कुंटु. अद बतल इत्‍ते, दोंगल नर्कटा बद वेलाक वांतोर इंचि ओक्‍कला लोता मालकुंक मुन्‍नेन तेळियसि मत्‍ते ओर तेल्वितेन मनांतोर आनि आ दोंगन लोते होळिया हिय्योर. ");
INSERT INTO esg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","अल्‍हेने मिमेट इनकुनवा वेलाते मनकना रूपमते पुटतोन नना वांतन. अदुनहाटीं मिमेटगुडा बेस तयारते मंटु. ");
INSERT INTO esg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","मालक हिल्वस्के ओनगा कबळ कियानोर्कुंक वेलापोर्रो गाटो-जावा दोस्‍सालय, वरोर बेस तेल्विगल्‍लोड, विस्वासमलायक सेवक मालाकुंक गावाले. अय्ते असोंटा सेवक बोर मंतोर? बोर सेवक अय्ते, मालक मल्सि वातस्के वेहता कबळ बरोबर कीसेक मनांतोर, ओरे सेवक बेस आसिर्वाद दोर्कुतोर आंद. ");
INSERT INTO esg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","नना मीक निजम वेहांतन, मालक आ सेवाकुन ओना पूरा आस्‍ति-पास्तिनपोर्रो अदिकारि इंचि इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","गानि ओक्‍कला आ दुस्‍ट सेवक ओना मनसुने, “नावा मालक वायालय अय्ते इंका आल्‍सेमे मंता” इनकुंचि, ");
INSERT INTO esg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ओना दंटाता सेवाकुल्कुन तन्‍नुड-गुद्‍दुड कियमळ, इरगा तिंचि-उंचि बदमासिं कियमळ सुरुव कीतोर इनकुन! ");
INSERT INTO esg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","अस्‍के आ सेवक विचारमगुडा किय्योर असोंटा रोजुने, गळियाते ओना मालक वायानुर. ");
INSERT INTO esg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","वासि, आ सेवाकुंक पेद्‍दा सिक्‍सा हीसि, ओन डोंगि लोकुल्‍कुने कल्‍पानुर. अगा सिराप अळमळ, पल्कु कोर्कमळे मनंता. ");
INSERT INTO esg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","येसु मर्रा उंदि वेसुड वेहालय सुरुव कीतोर. ओर इत्‍तोर, स्वर्ग राज्येम बारेमते नना उंदि वेसुड वेहंतन केंजट. पदि लेय्यां कंदिलिं पीसि वरोर मरमिना पेडांक कलियालय होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","अवनगटाल हेय्युं तेल्वि हिल्वव मत्‍तां, हेय्युं बारे तेल्‍वितव मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","तेल्वि हिल्वा लेय्यां कंदिलिं पीसि अय्ते होत्‍तां, गानि अवुनतोनि निय ओया हिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","तेल्‍विता लेय्यां बारे कंदिलिनतोनि डब्बाने निय इंका पीसि होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","मरमिना पेडल वायालय आलसेम आताहेंके, अव निद्र वासि मींडतां. ");
INSERT INTO esg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","नड्‍डुम नर्का, “मरमिना पेडल वासेक मंतोर, ओन्क कलियालय दट,” इंचि लोल्‍लि केंजावाता. ");
INSERT INTO esg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","अस्‍केने अव पदि लेय्यां बिराना तेदसि, कंदिलिं तयार कीतां. ");
INSERT INTO esg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","तेल्वि हिल्वा लेय्यां, तेल्‍विता लेय्यान, “मिहगटा निय इच्‍चुर माकु हीम्टु, मावा कंदिलिं पिर्रालय आतां,” इंचि इत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","गानि, “इद निय बोनकु इंचि बोनकु हालंता? इत्‍ते माकु इंका हालो, मीकु इंका हालो, अल्हा आयो गानि, मिमेट दुकानमते होंचि मीवाहाटीं निय अस्सि तटु,” इंचि तेल्‍विता लेय्यां इत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","अव निय अस्सालय दुकानमते होत्‍तस्के मरमिन पेडल एवतोर. तयारते मत्‍तव लेय्यां मरमिन पेडनतोनि मरमिंकु होत्‍तां, पज्जो तल्‍पु वाटसीतुर. ");
INSERT INTO esg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","गडसेम मत्‍तारित्‍ते, दुकानमते होत्‍तव हेय्युं तेल्वि हिल्वा लेय्यां मरमिना लोन वासि, “सामि-सामि, मोमोट वातोम, तल्‍पु तेंडा!” इंचि केयालय दल्‍गतां. ");
INSERT INTO esg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","अस्‍के मरमिन पेडल, “मिमेट बोर आंदिर? नना निजम वेहचंतन, मीकुन बिल्कुल एरपाट किय्योन,” इंचि लोप्पोटाल अवुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","पजा येसु सिस्युल्कुन इल्‍हा इत्‍तोर. “मनकना रूपमते पुटतोन नना वायानदगुडा इल्हे मनंता. अद रोजुन आनि वेलातुन मिमेट बिल्कुल एरपाट किय्‍यिर. अदुनहाटीं मिमेट तेल्‍विते मंटु,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","पजा येसु इंकुंदि वेसुडि वेहतोर. स्वर्ग राज्येम वरोर मनकनलेसीं मंता, बोर अय्ते, पय्‍नेम होनाका मुन्‍ने ओना दासुल्‍कुन केय्‍सि ओनगा मत्‍ता दनम ओर्कु अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ओर ओरा उसारतनमतुन हूळसि, वरोंक बंगारमते निंडसि मत्‍ता हेय्युं मुल्‍लें हीतोर, वरोंक रोंडु मुल्‍लें हीतोर. इंकावरोंक उंदि मुल्‍ले हीतोर. पजा ओर पय्‍नेम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","बोनकु अय्ते हेय्युं मुल्‍लें दोर्कतंगो ओर बिराने अव कोत्‍तन दंदाते दोस्‍सि, इंका हेय्युं मुल्‍लेना कल्‍दार्क संपलिच्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","अल्‍हेने रोंडु मुल्‍लें दोर्कतोर इंका दंदा कीसि, रोंडु मुल्‍लें एक्‍को संपलिच्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","गानि उंदि मुल्‍ले दोर्कतोर बारे, लोन ओसि पोक्‍का तव्‍सि ओना मालक हीता मुल्‍लेतुन मक्‍किचि इरतोर. ");
INSERT INTO esg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","वेल्‍लेन रोजकु आतारित्‍ते आ दासुल्कुना मालक मल्सि वासि, ओर हीता दनमता हिसाब तल्कतोर. ");
INSERT INTO esg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","अस्‍के बोनकु हेय्युं मुल्‍लें दोर्किस मत्‍तां, ओर इंका एक्‍को हेय्युं मुल्‍लें तच्‍चि, “मालक, निमे नाकु बंगारमते निंडसि मत्‍ता हेय्युं मुल्‍लें हीसि मत्‍तिन. हूळा, नना अव कोत्‍तना दंदा कीसि, इंका हेय्युं मुल्‍लें संपलिच्‍तन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","अस्‍के मालक कूस आसि, “वा रे वा, निमे बेस विस्वासमलायक दासुन आंदिन. इच्‍चोटा पोल्‍लेतगा निमे विस्वासमलायक मंतिन, अदुनहाटीं नना नीकु वेल्‍लेटोरपोर्रो अदिकारम हींतन. निमे लोप्पो होंचि मालकुनतोनि कूळसि कुसिते मन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","पजा बोनकु अय्ते रोंडु मुल्‍लें दोर्किस मत्‍तां, ओरगुडा मालकनगा वासि, “मालक, निमे नाकु बंगारमते निंडसि मत्‍ता रोंडु मुल्‍लें हीसि मत्‍तिन. हूळा, अव कोत्‍तना दंदा कीसि, इंका रोंडु मुल्‍लें संपलिच्‍तन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","अस्‍के मालक कूस आसि, “वा रे वा, निमे बेस विस्वासमलायक दासुन आंदिन. इच्‍चोटा पोल्‍लेतगा निमे विस्वासमलायक मंतिन, अदुनहाटीं नना नीकु वेल्‍लेटोरपोर्रो अदिकारम हींतन. निमे लोप्पो होंचि मालकुनतोनि कूळसि कुसिते मन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","पजा उंदि मुल्‍ले दोर्कतोर मालकुनगा वासि, “मालक, निमे कळक मनकन आंदिन, निमे वीतवगा कोय्‍यंतिन, सल्‍लुवगा जमा कींतिन इंचि नाकु एरपाट. ");
INSERT INTO esg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","अदुनहाटीं नना वेरियसि निमे हीता मुल्‍लेतुन ओसि पोक्‍का तव्‍सि मक्‍किचि इरतन. इदे, नीवा मुल्‍ले नीकु वापस हीसंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","गानि ओना मालक ओन्क इल्‍हा जवाब हीतोर. “निमे दुस्‍ट, लंडु दासुन आंदिन. नना वीतवगा कोय्‍यानोन, सल्‍लुवगा जमा कियानोन इंचि नीकु एरपाटे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","अय्ते निमे नावा दनमतुन बोर्कन्‍ना वड्‍डिक हिय्या मत्‍तिन. नना मल्सि वातस्के नावा दनमतुन वड्‍डितोनि एत्‍कुंचि मन्‍नेन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","पजा मालक ओना दासुल्‍कुन केय्‍सि, “मिमेट ओनागटाल मुल्‍ले एतसि, पदि मुल्‍लें मत्‍तोनगा हीम्टु. ");
INSERT INTO esg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","बारित्‍ते, बोनगा अय्ते पेनदा पोल्‍लेन तेल्‍पिचकुनना बुद्‍दि मंता, पेन ओन्क इंका हींता. अस्‍के ओन्क वेल्‍लेन आंता. गानि बोनगा पेनदा पोल्‍लेन तेल्‍पिचकुनना बुद्‍दि हिल्‍ले, ओनगा मत्‍ता बुद्‍दितुनगुडा पेन वापस एतकुन्‍नार. ");
INSERT INTO esg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","अय्ते ई कबळ्‍क ओज्जुवा दासुन पलाते हीकटते पोहचीम्ट. अगा मननोर अळसेके, वरगेयसेके, किटुर-किटुर पल्कु कोर्कसेक मनांतुर,” इंचि मालक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","मर्रा येसु इल्‍हा वळकालय दल्‍गुतोर. बस्के अय्ते मनकना रूपमते पुटतोन नना नावा महिमाते राजाल आसि अन्‍नि दूतनतोनि वांतन, अस्‍के नावा अदिकारमते राजगद्‍देपोर्रो उद्‍दंतन. ");
INSERT INTO esg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","पजा नावा मुन्‍ने दुनियाता अन्‍नि देसेल्‍कुना लोकुल्‍क जमा आयनुर. अस्‍के गोल्‍लल एटिनाल गोर्रें बल्हा वेरे कींतोर, अल्‍हेने लोकुल्‍कुन नना वरोनगाटाल वरोन वेरे कींतन. ");
INSERT INTO esg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","अल्हा कीसि नना गोर्रेन बारे तिना बाजुंक, एटिन बारे डेमा बाजुंक कींतन. ");
INSERT INTO esg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","अस्‍के राजाल तिना बाजुनोर्कुन इनानुर, “वटु, ना बाबाना आसिर्वाद मीकु दोर्कुता, मीवाहाटीं दुनिया पुटतस्केटाले राज्येम तयार कीसि मंता, दान एतट. ");
INSERT INTO esg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","इद राज्येम मीवादे आंदु, बारित्‍ते नना कर्वुने मत्‍तस्के नाकु मिमेट तिनालय हीतिर, नाकु दूपातस्के उनालय एर हीतिर. नना मीकु एरपाट हिलाकुना गानि मीवा लोहकुने मनालय जेगा हीतिर. ");
INSERT INTO esg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","नाकु केर्रालय कपडिं हिल्वस्के मिमेट नाकु कपडिं हीतिर, नना बिमारते मत्‍तस्के मिमेट नावा सेवा कीतिर. नना जेलने मत्‍तस्के मिमेट नाकु कलियालय वातिर.” ");
INSERT INTO esg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","अस्‍के तिना बाजुंक मत्‍ता नीतिमंतुल्क ओन इनानुर, “सामि, नीकु कर्वेस्तद हूळसि बस्के तिनालय हीतोम? नीकु दूपातद हूळसि बस्के एर उनालय हीतोम? ");
INSERT INTO esg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","निमे एरपाट हिलाकुना गानि बस्के नीकुन लोन ओसि मनालय जेगा हीतोम? नीकु कपडिं हिलवद हूळसि बस्के कपडिं केर्रालय हीतोम? ");
INSERT INTO esg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","निमे बिमार मत्‍तस्के, जेलते मत्‍तस्के बस्के मोमोट नीकु कलियालय वातोम?” ");
INSERT INTO esg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","अस्‍के राजाल, “नना मीकु निजम वेहासेक मंतन, इगे मत्‍ता नावा कदर हिलुवा विस्वासुल्‍कुनाल बोन वरोन बेस हूळिना, नाकुन बेस हूळतापे,” इंचि ओर्कुन इनानुर. ");
INSERT INTO esg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","पजा ओना डेमा बाजुंक मत्‍तोर्कुन, “सापनेमते मनानोरिटा, नहागटाल पेय्सि होंट. देय्याल्कुना मुक्‍यानाहाटीं आनि अवुना दूतनहाटीं तयार कीता बस्‍केळ्‍क पोत्‍सेके मनना तडमिते होंचि अर्रट. ");
INSERT INTO esg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","बारित्‍ते नना कर्वुने मत्‍तस्के, नाकु तिनालय तिंडि हिय्या हिल्‍लिर. नाकु दूपातस्के उनालय एर हिय्या हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","नना एरपाट हिलवोन लेह्का मत्‍तस्के नाकु मीवा लोहकुने जेगा हिय्या हिल्‍लिर. नाकु कपडिं हिल्वस्के मिमेट केर्रालय कपडिं हिय्या हिल्‍लिर, नना बिमार मत्‍तस्के, जेलने मत्‍तस्के मिमेट नाकु कलियालय इंका वाया हिल्‍लिर, दानहाटीं इदे मीवा सिक्‍सा आंद,” इंचि सामि इनानुर. ");
INSERT INTO esg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","अस्‍के ओर, “सामि, नीकुन मोमोट, कर्वेस्‍सि मत्‍तस्के, दूपातस्के, एरपाट कियवस्के, कपडिं हिल्वस्के, बिमार मत्‍तस्के आनि जेलने मत्‍तस्के हूळसि बस्के सेवा किया हिल्‍लोम?” इंचि इनानुर. ");
INSERT INTO esg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","अस्‍के राजाल ओर्कुन, “नना मीकु निजम वेहासेक मंतन, इगे मत्‍ता नावा कदर हिलुवा विस्वासुल्‍कुनाल बोन वरोनगुडा बेस हूळाकोंटे, अस्‍के नाकुनगुडा बेस हूळवापे!” इंचि इनानुर. ");
INSERT INTO esg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","पजा “ई सेड्‍डा लोकुल्‍कुंक मारवा सिक्‍सा आंता. नीतिमंतुल्‍कुंक बारे बस्‍केळ्‍क पिस्सना पिस्वर दोर्कंता,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","इव अन्‍नि पोल्‍लें वेहमळ आतारित्‍ते येसु सिस्युल्कुन इल्‍हा इत्‍तोर. “नाडि आयो मन्‍ने दाटसि होनना पंडुगु मंता इंचि मीकु एरपाटे. मनकना रूपमते पुटतोन नाकुन क्रुसुनपोर्रो वेलाड वाटालय, पगातोरा कय्‍दे पीसि हियमळ जर्गंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","अस्‍के कयपा इनना पेद्‍दा पेर्माना मिद्‍देते, पेद्‍दा पेर्मालोर आनि यहुदिरा पेद्‍दाल्क जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","येसुन सप्‍पुडदाका दोर्कापीसि हव्ककोम, इंचि ओर मीटिंगते उपायम कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","गानि “पंडुगु रोजकुना लोप्पो हव्का मन्‍नि, अल्हा कीते लोकुल्‍क गडबड किया परांतुर,” इंचि इन्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","पजा येसु बेतानिया इनना नाटे होंचि, कुस्‍टरोगम आसि मत्‍ता सिमोनिना लोन आगतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","अस्‍के उंदि मुरतळ वेल्‍ले दराता अत्‍तर निय उंदि गुर्गिते पीसि येसुनगा वाता. ओर गाटो तिनालय उद्‍दिसि मत्‍तस्के अद मुरतळ आ नियदुन ओना तल्‍ला पोर्रोटाल वळियता. ");
INSERT INTO esg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","अदुन हूळसि अगा मत्‍ता सिस्युल्कुंक होंग वासि, “ई अत्‍तर नियदुन वट्‍टिदे बारि पोचीतिन? ");
INSERT INTO esg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","इद अत्‍तर निय वेल्‍ले दराते अम्मिसि अव कोत्‍तां गरिबोर्कुंक हिया वायवड गदा!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","येसु ओर वळकानदुन एरपाट कीसि इल्‍हा इत्‍तोर. “दान बारिंक तकलिप कीसंतिर? अद नावाहाटीं बेसता कबळे कीता. ");
INSERT INTO esg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरिबोर्क अय्ते बस्केळक मिहगा मनांतुर, गानि नना बस्केळक मिहगा मनानोन आयोन. ");
INSERT INTO esg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","नावा हामुर एव्ता इंचि नावा मेंदुल्क अत्‍तर निय होकताप, अद इल्‍हा कीता. ");
INSERT INTO esg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","नना मीक निजम वेहांतन, पूरा दुनियाते, बगा-बगा पेनदा बेसता कबुर वेहमळ जर्गंता, अगा ई मुरतटुन, आनि इद कीता कबळतुन मति कियानुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","पजा, पन्‍नेंड सिस्युल्‍कुनाल वरोर इस्‍कारियोत यहुदल मत्‍तोर. ओर पेद्‍दा पेर्मालोरगा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","होंचि, “नना मीक येसुन पीसि हीते, मिमेट नाकु बतल हींतिर?” इंचि इत्‍तोर. अस्‍के ओर ओन्क मुप्‍पै एंडि रूपें हीतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","अस्‍केटाल ओर येसुन पीसि हियालय मोका हूळसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","पुल्‍लगा आयवा पिंडिता हारिना पंडुगुना मोदाटा रोजु, सिस्युल्क येसुनगा वासि, “गुरु, दाटसि होनना पंडुगुना गाटो तिनना तयारिं बगा कीकोम इंचि नीवा मनसु मंता?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “सहरते पलाना मनकानगा होंचि, नावा आकिर वेला दग्‍गेरा एव्ता. नीवा लोन नना नावा सिस्युल्कुनतोनि दाटसि होनना पंडुगु कियालय वांतन इंचि मावा गुरु वेहतोर इल्‍हा ओन्क वेहट.” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","अस्‍के येसु वेहतापे सिस्युल्क होंचि, दाटसि होनना पंडुगुना गाटो तयार कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","पोळ्‍द होत्‍तारिते, येसु ओना पन्‍नेंडु सिस्युल्कुनतोनि गाटो तिनालय उदतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","तिननेंके येसु ओर्कुन, “हीके केंजट नना निजम वेहचंतन, मिहगटाल वरोर नाकुन पगातोरा कय्‍दे पीसि हींतोर.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","इदुन केंजसि ओर्कु वेल्‍लेन दुक्‍कम आता. अदुनहाटीं, “ओन नना अय्ते आयोन गदा सामि?” इंचि वरोन पज्जो वरोर येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","अस्‍के, “नावातोनि गिन्‍नेते कलियसि तिनानोरे नाकुन पीसि हियनुर. ");
INSERT INTO esg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","दर्मसास्‍त्रमते रासि मत्‍ताप, मनकना रूपमते पुटतोन नना अय्ते दांतने. गानि बोनाहेंदाल अय्ते नाकुन पीसि हियमळ जर्गंता, आ मनकल पुट्‍टाकोंटेन बेस आसि मनवळ,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","अस्‍के येसुन पीसि हियना यहुदल, “ओन नना अय्ते आयोन गदा गुरु?” इंचि पूसकीतस्‍के, “निमे इत्‍तिन अल्‍हेने!” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","गडसेम आतारित्‍ते ओर तिननेंके, येसु हारितुन पीसि पेनदुक दन्यवाद कीतोर. पजा हारितुन तुकडां कीसि ओना सिस्युल्कुंक हीसेक. “तिंटु, इद नावा मेंदुल आंद,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","इंका ओर अंगुर पंडिना पानकमता गिलास कय्‍दे पीसि, पेनदुक दन्यवाद कीतोर. पजा ओर्कु हीसि, “मिमेट अंटोर दीन उंटु. ");
INSERT INTO esg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","बारित्‍ते इद पूना करारता नेत्‍तुर आंदु. वेल्‍लेटुर लोकुल्‍कुना पापाल्क मापि कियालय पोंगसेक मंता. ");
INSERT INTO esg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","नना मीक वेहांतन, नावा बाबाना राज्येमते पूना तरिकाते ई अंगुर पानकम उनाना रोजुनदाका, मर्रा बस्‍केने अंगुर पानकम उन्‍नोन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","पजा ओर, पेनदा स्‍तुति कियाना उंदि पाटा पारसि, जय्‍तुन मराकुना गुट्‍टापोर्रो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “इय्याला नर्कळ्‍क मिमेट अंटोर नाकुन होळसि वित्‍तंतिर, बारित्‍ते, गोर्रें कोहानोन नना हव्कंतन, मंदता गोर्रें बेंदव-हेके पायसि वित्‍तंतां. इंचि दर्मसास्‍त्रमते रासि मंता. ");
INSERT INTO esg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","गानि नना हासि, मर्रा जीवाते तेदतंका, मीकन्‍ना मुन्‍ने गालिल एरियाते दांतन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","अस्‍के पत्रु, “अंटोर नीकुन होळसि होनिनागानि, नना नीकुन बस्‍केने होळसि होन्‍नोन गुरु,” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“नना नीकु निजम वेहचंतन, इय्याला नर्कडकु गोगोड कूसाका मुन्‍ने निमे मूड मल्कां नाकुन एरपाट किय्योन इंतिन,” इंचि येसु पत्रुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","गानि, “ओक्‍कला नाकु नीतोनि हामुर वायिना बेसे, नीकुन नना एरपाट किय्योन इंचि बस्‍केने इन्‍नोन,” इंचि पत्रु इत्‍तोर. अंटोर सिस्‍युल्‍कगुडा अल्हे इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","येसु, ओना सिस्युल्कुनतोनि गेतसेमनि इनना जेगातगा एवतस्‍के, “नना इच्‍चुर मुन्‍ने होंचि पारतना कीसि वायनदाका मिमेट इग्‍गेने उद्‍दिसि मंटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","पजा पत्रुन आनि जब्‍दिना इव्वुर मर्कुन पीसि ओनतोनि ओतोर. अगा ओर वेल्‍ले दुक्‍कमते सिम्मरा आतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","अस्‍के ओर्कुन, “नावा जीवा दांता बारे इत्‍ताप नाक वेल्‍ले दुक्‍कम आसेक मंता. मिमेट नातोनि इग्‍गेने आगसि तेल्‍विते मंटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","इच्‍चुर मुन्‍ने होंचि बोकबोर्लें अर्सि ओर इल्‍हा पारतना कियालय दल्‍गुतोर, “ए बाबा, ओक्‍कला कुदुरते, नावा इद गोसा तप्‍पिसि होन्‍नि, गानि इद नावा विचारम मत्‍ताप आयो, नीवा विचारम मत्‍तापे आयि.” ");
INSERT INTO esg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","पजा सिस्युल्कुनगा वासि हूळते ओर निद्रा होंचि मत्‍तुर. अस्‍के येसु पत्रुन इल्‍हा इत्‍तोर. “मिमेट उंदि गंटामेडगुडा नातोनि तेल्‍विते मंदा पर्रिरा? ");
INSERT INTO esg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","मिमेट पट्‍टुने अर्राकोंटा मननाहाटीं तेल्‍विते मंचि, पारतना कीसेके मंटु. नना वेहताप कियालय मीवा आत्मा तयार मंता, गानि मीवा मेंदुल कमजोर मंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","येसु मरुंदि मल्का होंचि, “नावा बाबा, नना इदुन उन्‍ने पींता इनानय्ते, नीवा विचारमे पूरा आयि,” इंचि पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","येसु मर्रा वासि हूळतस्‍के, ओर मंचि निद्रते मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ओर्कुन अग्गेन होळसि येसु मर्रा पारतना कियालय होत्‍तोर. अस्केगुडा मुन्‍ने कीतापे पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","पजा सिस्युल्कुनगा वासि ओर्कुन इल्‍हा इत्‍तोर. “मिमेट इंदकेगुडा मींडसेक, आराम कीसेके मंतिरा? हुळाट, मनकना रूपमते पुटतोन नाकुन पापिर्कुना कय्‍दे पीसि हियना वेला एव्ता. ");
INSERT INTO esg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","तेदाट, मनम दाकोम. नाकुन पीसि हियानोर दग्गेरेन एव्‍तोर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","येसु इव पोल्‍लें इंचेकेने मत्‍तोर, अच्‍चोटेन पन्‍नेंडु सिस्युल्कुना लोप्पोटोर वरोर यहुदल इनानोर अगा वातोर. ओनातोनि पेद्‍दा पेर्मालोर आनि यहुदि पेद्‍दाल्क लोहता, गुळि कावेल कियानोरा गेंग कसेह्‍क, गुत्‍पां, पीसि वातुर. ");
INSERT INTO esg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","येसुन पीसि हियानोर, “नना बोन अय्ते बुर्रांतनो, ओरे येसु आंदुर, ओन दोर्का पींटु,” इंचि मुन्‍नेन ओर्क उंदि चिन्‍ह वेह्‍चि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","पजा यहुदल बिराना येसुनगा होंचि, “जोहार गुरु” इंचि ओन बुरतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","अस्‍के येसु, “ना दंटातोना, निमे बद कबळ्‍क वातिन अद कीम,” इंचि इत्‍तस्के, अगा मत्‍ता मत्‍तोर मुन्‍नेळक वासि येसुनपोर्रो कय वाट्‍सि ओन दोर्का पीतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","अच्‍चोटेन येसुनतोनि मत्‍तोरव्टे वरोनगा कसेर मत्‍ता, ओर दान तेंडसि पेद्‍दा पेर्माना वरोर दासुन हव्कालय कसेरते हीतोर गानि, अद कसेर सिराप ओना केवदुन नेमाहकुंचि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","अस्‍के येसु ओन, “नीवा कसेर नीवा नडिके मन्‍नि, बारित्‍ते कसेर पियानोर कसेरतेन हांतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","नना नावा बाबान तल्किस मत्‍ते, उंदि गेंगुने वेय्‍कुना दूतां मनना पन्‍नेंडु गेंगुल्कुंकन्‍ना बच्‍चुंगो वेय्‍कुना पेनदा दूतन नाकुन पिसागोटालय लोहचि मन्‍नेर, इद नीकु तेळियोना? ");
INSERT INTO esg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","इल्‍हा आते दर्मसास्‍त्रमते नावा बारेमते रासता पोल्‍लें बल्हा निजम आयनुं? अव्टे इल्‍हा आयमळ गावाले, इंचि रासतद मंता,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","अस्‍के येसु मंदितुन इल्‍हा इत्‍तोर. “वरोन दोंगन पिय्‍यालय वाताप मिमेट कसेह्‍क, गुत्‍पां पीसि नाकुन पिय्‍यालय वातिरा? नना अय्ते रोजे गुळिते कराहसेक मीतोनि मनुंदुन, अस्‍के नाकुन पिया हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","गानि दर्मसास्‍त्रमते नावा बारेमते पेनदा कबुरतोर रासता पोल्‍लें पूरा आयाना इंचि इल्‍हा जर्गता,” इत्‍तोर. पजा ओना सिस्युल्क अंटोर ओन होळसि तेगा विततुर. ");
INSERT INTO esg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","लोकुल्‍क येसुन पीसि कयपा इनना पेद्‍दा पेर्मानगा ओतुर. अगा दर्मसास्‍त्रम कराहना गुरुल्क आनि यहुदि पेद्‍दाल्क जमा आसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","गानि पत्रु लक्‍कुटाले येसुना पज्जो-पज्जो पेद्‍दा पेर्माना दारादाका होत्‍तोर. अगा बतल आयार इंचि हूळालय, दाराते होंचि कावेल कियानोरतोनि उदतोर. ");
INSERT INTO esg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","पेद्‍दा पेर्मालोर आनि पंचादितोर अंटोर येसुंक हामुरता सिक्‍सा हियानाहाटीं ओना विरोदमते तप्‍पुड गवाइ पह्‍कतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","गानि बच्‍चुटुरो वासि ओना विरोदमते आबद्‍दम गवाइ हिय्‍यिना, ओर्कु उंदिगुडा तप्पु दोर्काहिल्‍ले. आकिरते इव्वुर वासि, “पेनदा गुळितुन कूलाह्‍चि दान मूड रोजकुने मर्रा दोहा परांतन इंचि ओर इत्‍तोर,” इसोंटा गवाइ हीतुर. ");
INSERT INTO esg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","अस्‍के पेद्‍दा पेर्मल तेदसि, “ईर नीकु विरोदमते बल्हा गवाइ हीसंतुर हूळा, निमे बतले जवाब हिय्‍यिना?” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","गानि येसु चुपचाप मत्‍तोर. अस्‍के पेद्‍दा पेर्मल येसुन इल्‍हा इत्‍तोर. “जीवाते मनना पेनदा ओट्‍टु तिंचि नीकुन पूसकीसंतन, ओक्‍कला निमे पेनदा मर्रि, किरिस्‍तुन आते माक वेहा,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","अस्‍के येसु ओन इल्‍हा इत्‍तोर. “निमे इत्‍तिन अद निजमे! गानि नना मीकु वेहांतन, इंका मुन्‍ने मिमेट मनकना रूपमते पुटतोन नाकुन ताकतवर पेनदा तिना बाजुंक उद्‍दिसि मत्‍तद आनि मब्बु तेर्पेनपोर्रो उद्‍दिसि वायानेंके हूळकिर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","अस्‍के, पेद्‍दा पेर्मल होंगुने ओना कपडिं हराह्‍कुंचि, “ईर पेनदा अपमानम कीतोर. मनाकु इंका बतल गवाइ गावाले? ओना पोल्‍लें मिमेट केंजतिरे गदा! ");
INSERT INTO esg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","अय्ते मिमेट बतल इंतिर?” अस्‍के यहुदिल्क, “ओर हामुर सिक्‍सालायक मंतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","अस्‍के इच्‍चुर लोकुल्‍क येसुना तोड्‍डि पोर्रो उस्किसि, ओन तंचि-गुद्‍दिसि, ");
INSERT INTO esg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ए किरिस्‍तु, नीकुन बोर तंतुर, माकु बविस्यवानि वेहा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","हीके पत्रु पेद्‍दा पेर्माना दारातेने उदिस मत्‍तोर, अस्‍के उंदि दासि ओनगा वासि, “गालिल एरियाता येसुनतोनि निमे इंका मत्‍तिन गदा?” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","अस्‍के पत्रु “निमे बतल इंचांतिनो नाकु तेळिया हिल्‍ले!” इंचि ओर अगा मत्‍तोरा अंटोर मुन्‍नेन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","आयंका ओर दाराताल पेय्सि गलमातगाह्कु होत्‍तोर. अस्‍के इंकुंदि दासि ओन हूळसि, “ईर इंका नासरेत नाटेना येसुनतोनि मत्‍तोर,” इंचि अगा मत्‍तोर्कुंक वेहता. ");
INSERT INTO esg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","अस्‍के पत्रु मर्रा उंदि मल्का, ओट्‍टु तिंचि, “नना ओन बिल्कुल एरपाट किय्योन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","गडसेम मत्‍तारित्‍ते, अगा नित्‍तिसि मत्‍तोर इच्‍चुर लोकुल्‍क पत्रुनगा वासि, “निमे निजम ओना दंटातोने! नीवा वळकुड केंजसि निमे गालिल एरियातोन इंचि तेळियंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","अस्‍के पत्रु, “नना ओट्‍टु तिंचि वेहचंतन, नना आबद्‍दम वळ्‍कानय्ते पेन नाकुन तिन्‍नि, आ मनकन नना बिल्कुल एरपाट किय्योन,” इंचि इत्‍ता इनुडे गोगोड कूसता. ");
INSERT INTO esg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","“इय्याला नर्कळ्‍क गोगोड कूसाका मुन्‍ने, निमे नाकुन मूड मल्कां, एरपाट किय्योन इंतिन” इंचि येसु पत्रुंक मुन्‍ने वेह्‍चि मत्‍ता, पोल्‍ले मति वासि, ओर पलाते होंचि वेल्‍ले दुक्‍कमते इरगा अळतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","पंग आतारित्‍ते पेद्‍दा पेर्मालोर आनि यहुदि पेद्‍दाल्क अंटोर येसुन हव्कना निरनायम कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","पजा ओन दोह्‍चि वाट्‍सि ओसि, पिलातुस राज्यपालुंक अप्पजेपतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","येसुंक हामुरता सिक्‍सा दोर्कता इंचि, येसुन पीसि हीता यहुदांकु तेळियतारित्‍ते वेल्‍ले पस्तांचतोर. पजा ओर पेद्‍दा पेर्मालोर्कुंक, यहुदि पेद्‍दाल्कुंक आ मुप्‍पै एंडि कल्‍दार्क मलाह्‍चि हीसेक, ");
INSERT INTO esg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“नना तप्पु हिल्वा मनकन हव्कालय पीसि हीसि पापम कीतन” इंचि इत्‍तोर. अस्‍के ओर, “माकु बतल कियना मंता? नीवद निमे हूळकुन” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","अस्‍के यहुदल आ एंडि कल्‍दार्कुन गुळिते विसिरसि, अगटाल पलाते होंचि उर्रि दोसकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","पेद्‍दा पेर्मालोर्क अव कोत्‍तन जमा कीसि, “वरोन हव्कालय हीता कोत्‍तन, मना नियम परकारम दान पेटिते वाटा वायो,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","दानहाटीं ओर अव कोत्‍तनतोनि, येरुसलेमते बोरन्‍ना पलाताल वातोर हायानय्ते ओर्कुन बोंदा दोसालय आंता, इंचि वरोर कुम्माना नेलि अस्तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","इंदके इंका आ नेदुन “नेत्‍तुर नेलि” इंचि इंतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","अस्‍के यिर्मयाह इनना पेनदा कबुरतोर इत्‍ता पोल्‍ले निजम आता, अद इल्‍हा मत्‍ता: “इस्राएल लोकुल्‍क ओना दरा, मुप्‍पै एंडि कल्‍दार्क कीतुर, अव ओर तेंडकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","पेन नाकु वेहताप, आ मुप्‍पै एंडि कल्‍दार्कुनतोनि, कुम्माना नेलि अस्तुर.” ");
INSERT INTO esg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","पजा येसुन पिलातुस राज्यपालना मुन्‍ने निपिस्तस्‍के, राज्यपाल ओन, “निमे यहुदिल्कुना राजाना?” इंचि पूसकीतोर. अस्‍के “निमे इंचेकेने गदा,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","पेद्‍दा पेर्मालोर आनि यहुदि पेद्‍दाल्क ओनापोर्रो दोसेल्क दोसतुर. गानि येसु बतले जवाब हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","अस्‍के पिलातुस येसुन, “ईर नीवा पोर्रो बच्‍चुंगो तप्पुक दोस्सेक मंतुर, नीकु केंजा वासेक हिल्‍लेना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","गानि ओर उंदि पोल्‍ले इंका वळका हिल्‍लोर. अदुनहाटीं पिलातुसुंक वेल्‍ले इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","दाटसि होनना पंडुगुना रोजुने, लोकुल्‍कुनाहाटीं बोनन्‍ना वरोन कैदिन होळसनद राज्यपालना रिवाज मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","अद वेलाते अगा जेलने वरोर पोरोल पेय्‍स्‍ता “बरब्बल” इनना कैदि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","लोकुल्‍क अगा जमा आतारित्‍ते पिलातुस ओर्कुन, “नना बोन होळ्‍सकन इंचि मीवा मनसु मंता, बरब्बन होळ्‍सकना हिलाकोंटे किरिस्‍तु इनना येसुना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","येसु तप्पु कियाकोन्‍ना ओना कबाह्‍कुन हूळसि कळ्‍क पोतताहेंकेन ओन तच्‍चि नाक अप्पजेपतुर इंचि पिलातुसुंक एरपाटे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","अचोने आय्‍का पिलातुस न्‍यायम कियालय बस्के अय्ते गद्‍देपोर्रो उदतोर अस्‍के ओना मुत्‍तोनाहेंदाल उंदि कबुर वाता, अद इल्‍हा मत्‍ता, “नाकु उंदि कला वाता, ओर तप्पु हिलुवा मनकल आंदुर. ओन निमे बतले कियमा. नना ओनाहाटीं इय्याला पोद्‍दला दुक्‍कमते मत्‍तन.” ");
INSERT INTO esg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","गानि हीके पेद्‍दा पेर्मालोर आनि पेद्‍दाल्क, बरब्बन होळसिसि येसुन हव्कना इंचि इनालय लोकुल्‍कुंक एक्‍किस्तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","राज्यपाल ओर्कुन, “नावा मुन्‍ने बरब्बल आनि येसु इव्वुर मंतुर, नना मीवाहाटीं ईरा इव्वुरा लोप्पोटाल बोन होळसना इंचि मीवा मनसु मंता?” इंचि पूसकीतोर. अस्‍के ओर, “बरब्बन” होळसना इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“अय्ते मरि, ‘किरिस्‍तु’ इनना येसुन बतल कियना?” इंचि पिलातुस ओर्कुन पूसकीतोर. अस्‍के “ओन क्रुसुनपोर्रो मोल्‍लां कोहकिस हव्का,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“बारि, ओर बतल तप्पु कीतोर?” इंचि पिलातुस पूसकीतस्‍के, “ओन क्रुसुनपोर्रो मोल्‍लां कोह्‍किसि हव्का” इंचि ओर जोरसे वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","इच्‍चो वेल्‍ले लोकुल्‍कुना मुन्‍ने नावद बतले ताका पर्रो. ओर लोल्‍लि कींतुर इल्‍हा पिलातुस इनकुंचि, इच्‍चुर एर पीसि लोकुल्‍कुना मुन्‍ने कय्‍क नोर्सि, “ईना हामुटे नावद कय हिल्‍ले, मिमेटे दीना जबाबदारी मंतिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","अस्‍के ओर अंटोर वरगेयसि, “ईना हामुटा जबाबदारी मावा पोर्रो आनि मावा पिलाल्कुना पोर्रेन मन्‍निकांटी,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","अस्‍के पिलातुस, बरब्बन होळसिसि, येसुन बारे पोट्‍टेते तंचि, क्रुसुनपोर्रो मोल्‍लां कोह्‍किसि हव्कालय सिपाइल्कुना कय्‍दे अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","पजा सिपाइल्क येसुन पीसि राज्यपालना किल्‍लाते ओतुर. अगा सिपाइल्कुना पूरा गेंगुन केया वेह्‍चि ओना सुट्‍टु जमा कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ओना कपडिं कुळाह्‍चि, ओन्क एर्रा रंगुना कोट केराहतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","हाह्कुना वेलिता किरिटम कीसि ओना तल्‍लक दोसतुर, ओना तिना कय्‍दुक उंदि दुरसोत्‍ता कट्‍टे हीतुर. सिपाइल्क ओना मुन्‍ने टोंगरां ऊनसि, “यहुदिल्कुना राजांक बस्‍केने हामुर हिल्‍ले,” इंचि ओन इरगा कारेड्‍डाल्‍क कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","आयंका ओर ओनपोर्रो उस्‍कतुर, ओनागटा कट्‍टे इगकुंचि अदे कट्‍टेते ओना तल्‍लापोर्रो तंतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ओन इरगा कारेड्‍डाल्‍क कीतारित्‍ते ओर केर्सि मत्‍ता कोट तेंडसि, ओना कपडिं ओन्‍के केराहतुर आनि क्रुसुनपोर्रो वेलाड वाटालय पलाते पीसि ओतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","येसुन पीसि पलाते होननेंके, कुरेनि सहरतोर वरोर सिमोन इनना मनकल कलियतोर. सिपाइल्क ओन वेराहचि येसुना क्रुस कांजा वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","आयंका ओर गोलगोता इत्‍ते, “तला बोरसेम” इनना जेगातगा एवतारित्‍ते, ");
INSERT INTO esg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","अंगुर पंडिना पानकमते कयमुल कल्‍पिसि येसुंक उनालय हीतुर, ओर दान नाकिसि हूळसि, उन्‍नोन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","37","अस्‍के ओन क्रुसुनपोर्रो वेलाड वाटतुर. वाटतारित्‍ते, “येसु, यहुदिल्कुना राजाल आंदुर,” इंचि उंदि ओना तप्पु हुप्‍सना बोर्ड रासि येसुना तल्‍लापोर्रो वेलाड वाटतुर. पजा सिपाइल्क सिट्‍टिं वाट्‍सि ओना कपडिन पंचकुत्‍तुर. आनि ओना कावेल कीसेके अग्गेन उद्‍दिसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","इंका इव्वुर दोंगाल्कुनगुडा ओना पक्‍का पीसि हीके वरोन हेके वरोन क्रुसुनपोर्रो मोल्‍लां कोह्‍कतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","हर्रि पीसि होनानोर-वायानोर तल्‍लां ऊपसेके, “ओ! गुळितुन कूलाह्‍चि मूड रोजकुने दोहानोन, ओक्‍कला निमे पेनदा मर्रिन आते, क्रुसताल रेय्‍सि निमे नीवा जीवातुन पिसागोटकुन,” इंचि कारेड्‍डाल्‍क कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","अचोने आयका पेद्‍दा पेर्मालोर, दर्मसास्‍त्रम कराहना गुरुल्क आनि यहुदि पेद्‍दाल्कगुडा अल्हे कारेड्‍डाल्‍क कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","अव्टेटाल इच्‍चुर, “ईर अय्ते इंकावरोन पिसागोटतोर गानि ओनद ओरे पिसागोटकुना परसेके हिल्‍लोर. ईर इस्राएलतोरा राजाल गदा! अय्ते क्रुसुनपोर्रोटाल हिळु रेय्‍सि वायिरकांटी, अस्‍केने मोमोट ईनपोर्रो विस्वासम ईरा परकोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","इंका इच्‍चुर बारे, “ओन्क अय्ते पेनदापोर्रो बरोसा मंता. इंका ओर, ‘नना पेनदा मर्रिन आंदुन,’ इंचि इत्‍तोर. अदुनहाटीं इंदके पेनदा मनसु मत्‍ते ओन पिसागोट्‍टि,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","अल्‍हेने येसुना पक्‍काते क्रुसुंक वेलाड वाट्‍सि मत्‍ता दोंगाल्कगुडा ओना अपमानम कीतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","पजा पिय्यटा पन्‍नेंड एगानस्‍केटाल अय्ते मूड एगनदाका पूरा बूमिअंता हीकट आता. ");
INSERT INTO esg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","दग्‍गेरा-दग्‍गेरा मूड एगनेंके येसु अळसेके जोरसे वरगेयसि, “एलि, एलि, लमा सबकतनि.” इत्‍ते, “ना पेनदुना, ना पेनदुना निमे नाकुन बारि होळसीतिन?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","अस्‍के अगा नित्‍तिसि मत्‍तुर इच्‍चुर लोकुल्‍क, “ओर एलियान केयसंतोर बारे” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","पजा ओराव्टेटाल वरोर मनकल वितसि होंचि पुल्‍लटा अंगुर पंडिना पानकमते मुळाहता स्पंज तत्‍तोर आनि दुड्‍डुना कोस्‍सक ताससि येसुना तोळ्‍दगा नाकालय हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","अस्‍के कळमतोर, “जेरासेप आगाट, एलियाल ईन पिसागोटालय वांतोरा वायोरा हूळकोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","येसु मरुंदाम अळसेके जोरसे वरगेयसि जीवा होळस्तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","हुळाट! अस्‍केने गुळिता परदा, पोर्रोटाल हिळुदाका हर्सि रोंडु तुकडां आता, बूमि अदुलता, गुट्‍टां नेर्रें हीसि पैतां. ");
INSERT INTO esg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","पेनदा लोकुल्‍क बोर अय्ते हातुर ओराव्टेटाल वेल्‍ले मंदि जीवा अर्सि बोंदानाल मर्रा तेदतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","येसु मर्रा जीवाते तेदतस्‍के, ओर अंटोर बोंदानाल पेय्सि येरुसलेम इनना पवित्र सहरते वेल्‍लेटुर लोकुल्‍कुंक दिसतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","अगा जर्गुता गटनां आनि बूमि अदुल्तद हूळसि, नूर मंदि सिपाइल्कुना पोर्रो मनना अदिकारि आनि येसुनगा कावेल कीसेक मत्‍ता सिपाइल्क वेल्‍ले वेरियतुर. वेरियसि, “ईर निजमे पेनदा मर्रि आंदुर” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","येसुना सेवा कीसेक गालिल एरियाताल वातव वेल्‍लेने मुर्ताह्क अगा लक्‍कुटाल हूळसेक मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","अवुने मरियम मगदलेनि, याकोब आनि योसेप ईरा यावल मरियम आनि जब्‍दिना मर्कुना यावल, इव अन्‍नि अगा मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","आयंका पोळ्‍दु होनना वेलाक अरिमताइ नाटेनाल वरोर योसेप इनना सिरमंत मनकल वातोर. ओर इंका येसुना सिस्युड मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","योसेप पिलातुसुनगा होंचि, येसुना पीनगु गावाले इंचि इत्‍तोर. अस्‍के पिलातुस, “येसुना पीनगु, योसेपुंक हीम्टु,” इंचि सिपाइल्कुंक आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","योसेपु आ पीनगुन पूना कपडिते हुटतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","बंडातुन तुल्हाचि ओनाहाटीं तयार कीता पूना बोंदाते, येसुना पीनगुन इर्सि, बोंगाकु उंदि पेद्‍दा बंडातुन अड्‍डम दोसतोर. पजा अगटाल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","गानि मगदलेनि नाटेना मरियम आनि इंकुंदि मरियम इव बोंदा मुन्‍ने उदिस मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","नोमकेमता मुन्‍नेटा रोजुने पेद्‍दा पेर्मालोर्क आनि परिसिल्क पिलातुसुंक कलियसि, ");
INSERT INTO esg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“महाराज, आ बोंकिच्‍चना मनकल जीवाते मननेंके, ‘नना हासि मूड रोजकुंक मर्रा जीवाते तेदंतन’ इंचि इत्‍तोर, अद माकु मते मंता. ");
INSERT INTO esg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","दानहाटीं मूड रोजकुनदाका ओना बोंदातगा कडक कावेल इर्रानद आदेस हीम. बारित्‍ते ओना सिस्युल्क बस्‍केनना वासि दोंगातनमते ओना पीनगुन ओयानुर आनि ‘येसु मर्रा जीवाते तेदतोर’ इंचि लोकुल्‍कुन बोंकिचानुर. इल्‍हा गिंटा आयानय्ते मुन्‍नेटकना इंका वेल्‍ले बेकार आंता,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","अस्‍के पिलातुस, “मिमेट सिपाइल्कुन ओम्टु, ओसि ओना बोंदातगा कडक कावेल इर्रट,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","अस्‍के ओर सिपाइल्कुन ओसि येसुना बोंदातगा कडक कावेल इरतुर. बोंदक अड्‍डम दोसता बंडाकु सरकार सिक्‍का वाटसि अगा कावेल कीसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","नोमकेम आतारित्‍ते इंकुंदि रोजु अय्तारम पंग आयनेंके मगदलेनि नाटेना मरियम आनि दाना दंटातद इंकुंदि मरियम, बोंदातुन हूळालय होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","अस्‍के उंदि पेनदा दूता स्वर्गमताल अगा रेयताहाटीं अगा पेद्‍दा बुकंप आता. पजा आ पेनदा दूता बोंदक अड्‍डम मत्‍ता बंडातुन तेंडसि, अदे बंडापोर्रो उद्‍दुता. ");
INSERT INTO esg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","दाना रूपम पोळ्‍दुनालेसीं जगा-जगा मेर्सेक मत्‍ता, दाना अंगि बारे बर्पलेह्का तेल्‍लगा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","दान हूळसि कावेल कियानोर इरगा वेरियसि, गजा-गजा वनकुसेक, अल्‍हेने हाताप आतुर. ");
INSERT INTO esg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","अस्‍के पेनदा दूता इल्‍हा इत्‍ता. “वेरियमट, क्रुसुनपोर्रो वेलाड वाट्‍सि हव्‍कता येसुन मिमेट पह्कसेक मंतिट, इद नाकु एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","गानि ओर इग्‍गे हिल्‍लोर, ओर वेहताप मल्सि जीवाते तेदतोर. वटु, ओना पीनगु इरता जेगातुन हुळाट. ");
INSERT INTO esg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","इंका बिराना होंचि ओना सिस्युल्कुंक, ओर हामुरताल जीवाते तेदतोर, ओर मीकन्‍ना मुन्‍नेने गालिल एरियाते होंचेक मंतोर, अगा ओर मीकु दिस्‍सानुर, इंचि वेहट. बतल अय्ते नना मीकु वेहतन, अदुन मति इर्राट,” इंचि आ मुर्ताह्‍कुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","अस्‍के आ मुर्ताह्क वेर्रेते, वेल्‍लेन आनंदमते, बोंदातगाटाल जटपेट पेय्सि ओना सिस्युल्कुंक इद कबुर वेहालय विततां. ");
INSERT INTO esg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","अगटाल पेय्सि होननेंके, येसु अवुंक कलियसि अवुन, “बेस पिस्‍सट,” इंचि इत्‍तोर. पजा अव ओना दग्‍गेर होंचि काल्क मोळ्‍कतां. ");
INSERT INTO esg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","अस्‍के येसु अवुन, “वेरियमट होंट, नावा तम्मुह्‍कुंक गालिल एरियाहेके होनालय वेहट, अग्गेन ओर नाकुन हूळंतुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","अव सिस्युल्कुंक वेहालय होंच्‍चेकेन मत्‍तां, अच्‍चोटेन बोंदातगा कावेल कीसेक मत्‍तोर इच्‍चुर सिपाइल्क सहरते होत्‍तुर, होंचि अगा जर्गुतदंता पेद्‍दा पेर्मालोर्कुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","अस्‍के ओर यहुदि पेद्‍दाल्कुंक कलियसि उंदि उपायम कीतुर. सिपाइल्कुंक वेल्‍लेन कोत्‍तां हीसि वेहतुर गदा, ");
INSERT INTO esg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“मोमोट निद्रते मननेंके ओना सिस्युल्क नर्का वासि ओना पीनगुन दोंगातनमते ओतुर, इल्‍हा लोकुल्‍कुंक वेहट. ");
INSERT INTO esg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ई पोल्‍ले गिंटा राज्यपालना केव्‍दे अर्रानय्ते मोमोट ओन समत कीसि मीकु पोल्‍ले वायकुंटा कींतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","अस्‍के ओर कोत्‍तां एतसि वेहताप कीतुर, ई पोल्‍ले यहुदिल्कुना लोप्पो इदवेरादाका इंका इल्हे ताकसेक मंता. ");
INSERT INTO esg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","अद आतंका पदाकोंडु मंदि सिस्युल्क गालिल एरियाते येसु वेहता गुट्‍टापोर्रो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","अगा येसुन हूळसि ओन मोळ्‍कतुर. अय्नागानि इच्‍चुर सिस्युल्कुंक अनमानम मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","अस्‍के येसु ओरा दग्‍गेर होंचि ओर्कुन इल्‍हा इत्‍तोर. “स्वर्गमते आनि बूमिपोर्रोटा अदिकारम अंता नाकु हीसि मंता. ");
INSERT INTO esg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","अदुनहाटीं मिमेट होंचि दुनियाता अन्‍नि देसेल्‍कुना लोकुल्‍कुन सिस्युल्क कीम्‍टु. ओर्कु बाबाना पोरोलते, मर्रिना पोरोलते आनि पवित्र आत्माता पोरोलते बापतिस्मा हीम्टु. ");
INSERT INTO esg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","नना मीकु हीता आदेस परकारम ओर्कु ताकालय करहट, ई दुनिया मुंळगना आकिर वेलादाका नना बस्केळक मीतोने मनंतन,” इत्‍तोर.");
INSERT INTO esg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","पेनदा मर्रि, येसु किरिस्‍तुना बेसता कबुर इल्‍हा सुरुव आता. ");
INSERT INTO esg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","पेनदा कबुरतोर यसायाहना पुस्तकमते, “हूळा! नना नीकन्‍ना मुन्‍नेने नावा कबुरतोन लोहंतन. ओर नीवाहाटीं हर्रि तयार कींतोर.” इंचि रासि मंता. ");
INSERT INTO esg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","वरोना अल्किर बय्‍लि जेगाते, “सामिनाहाटीं हर्रि तयार कीम्‍टु, ओना हर्रि सवरगा कीम्‍टु,” इंचि केंजा वासेक मंता, इल्‍हा बापतिस्मा हियना योहानुना बारेमतेन पेन वेहचि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","पेनदा कबुरतोर रासतापे बापतिस्मा हियना योहान बय्‍लि जेगाते वासि लोकुल्‍कुंक इल्‍हा वेहालय दल्‍गतोर, “कीता पापाल्कुन ओप्‍कुंचि मनसु मार्सकुंचि बापतिस्मा येतानय्ते, पेन मीवा पापाल्कुन मापि कींता.” ");
INSERT INTO esg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","इद केंजसि पूरा यहुदिया राज्येमते, येरुसलेम सहरते मंदना लोकुल्‍क ओनगा वातुर, वासि ओरा पापाल्क ओप्‍कुंचि, ओनहेंदाल योर्दन बेरेटे बापतिस्मा येतकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","योहान लोटापेटा बूराते तयार कीता कपडिं केरसि तोल्‍दा पट्‍टा नडिक तासकुनुंदुर. ओर गोल्‍लाबामां आनि तेने इवे तिंडि तिनुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","“नाकन्‍ना सक्‍तिमंतुड नावा पज्जोटाल वासंतोर. नना ओना मुन्‍ने वंगिसि, ओना बूटकुना नोंडेन लेहना लायकगुडा हिल्‍लेन. ");
INSERT INTO esg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","नना मीक एतोनि बापतिस्मा हीतन गानि ओर मीक पवित्र आत्माते बापतिस्मा हियानुर,” इंचि योहान वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","अव रोजकुने येसु गालिल एरियाता नासरेत सहरताल वासि, योर्दन बेरेटे योहानुनाहेंदाल बापतिस्मा येतकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","येसु बस्के अय्ते एताल पलाते वातोर, अस्‍केने मब्बु बैय्यरा आयानद आनि पवित्र आत्मा पावरेम पिट्‍टेलेसीं ओनपोर्रो रेयानद हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","अच्‍चोटेन मब्बुनाल, “निमे नावा पावरमगल्‍ला मर्रिन आंदिन. नीहेंदाल नना वेल्‍लेने कूस मंतन,” इंचि उंदि अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","अद आता पजा पेनदा आत्मा बिराना येसुन बय्‍लि जेगाताहेके लोहता. ");
INSERT INTO esg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","अगा नल्‍पै रोजकु केडा जिवरासिना नड्‍डुम मननेंके, देय्यम येसुनगा वासि, ओना पट्‍टु हूळता. पजा पेनदा दूतां वासि ओना सेवा कीतां. ");
INSERT INTO esg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","हेरोद राजाल योहानुन जेलते वाटता पजा, येसु गालिल एरियाते वासि, “पेन इत्‍ता वेला पुरागा आसि, पेनदा राज्येम दग्गेर्क एव्ता. अदुनहाटीं मिमेट मनसु मार्सकुंचि पेनदा बेसता कबुरपोर्रो विस्वासम इर्रट,” इंचि वेहालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","येसु गालिल समुद्रम ओड्‍डु पीसि होननेंके सिमोनुन आनि ओना तम्मुर अंदरियन हूळतोर. ओर जिम्मां पिय्‍यानोर आताहाटीं, समुद्रमते ओल्‍लां वाटसि जिम्मां पीसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","अस्‍के, “नावा पज्जो वट, नना मीकुन मनकालोर्कुन नहगा तायानोर कींतन,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","अस्‍के ओर, बिराना ओरा ओल्‍लां अग्गेन होळसि ओना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","येसु इंकिच्‍चो मुन्‍नेळ्‍क होत्‍तारित्‍ते जब्‍दिना मर्कु याकोब आनि ओना तम्मुर योहान डोंगाते ओल्‍लां सवरिच्‍नेंके हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","येसु ओर्कुन बिराना केयतस्‍के, ओर ओरा बाबाल जब्‍दिन आनि बूतिनोर्कुन अग्गेन डोंगाते होळसि ओना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ओर अंटोर कूळसि कपर्नाहुम सहरते होत्‍तुर. अगा येसु नोमकेम रोजुने दर्मसास्‍त्रम कराहना लोते होंचि पेनदा पोल्‍लें कराहलय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","येसु पेनदा पोल्‍लें ओरा दर्मसास्‍त्रम कराहना गुरुल्‍कुनलेसीं आयो गानि अदिकारम मत्‍ताप कराहतोर. अदुनहाटीं ओना कराहमळतुन केंजसि लोकुल्‍क वेल्‍ले इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","अदे दर्मसास्‍त्रम कराहना लोते वरोर देय्यम पीता मनकल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ओर येसुन हूळसि, “निमे बोन आंदिनो नाक एरपाटे, निमे नासरेत सहरता येसुन, पेनदा पवित्र मनकन आंदिन. मातोनि नीकु बाता कबळ? माकुन नासडेम कियालय वातिना?” इंचि वरगेयसि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","अद केंजसि, “निमे चुपचाप मन, ओनागटाल पलाते पेय्‍सा,” इंचि येसु जोरसे गदरिच्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","अस्‍के आ देय्यम ओन गजा-गजा ऊपसि जोरसे वरगेयसेके ओना लोप्पोटाल पेय्सि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","अदुन हूळसि अगा मत्‍तोर अंटोर इचंत्रम आसि, वरोंक-वरोर इल्‍हा वळकालय दल्‍गतुर, “इद बसोंटा पोल्‍ले, इद अय्ते पूना बोदा आंदु, ईर अदिकारमते देय्याल्कुन ओना लोप्पोटाल पेय्सि होंटु इंचि आदेस हींतोर, अव ईना पोल्‍ले केंजसेक मंतां.” ");
INSERT INTO esg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","इल्‍हा येसु अगा कीता गटनना बारेमते पूरा गालिल एरिया आनि सुट्‍टु-मट्‍टु मत्‍ता अन्‍नि नाह्कुने तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","येसु आनि ओना सिस्युल्कु सिमोन, अंदरियल, याकोब, योहान दर्मसास्‍त्रम कराहना लोताल बिराना पलाते पेय्सि सिमोन आनि अंदरियना लोन होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","अगा सिमोनुना पोरड एळकि वासि मींडसि मत्‍ता. इद पोल्‍ले अगा मत्‍तोर बोरो येसुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","येसु होंचि दाना कय पीसि तेहतोर. अस्‍के दाना एळकि रेय्‍सि, अद ओरा सेवा कियालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","पजा पोळ्‍द होंचि, लोकुल्‍क बिमारते मत्‍तोर्कुन, देय्याल्क पीतोर्कुन अंटोर्कुन येसुनगा पीसि वातुर. ");
INSERT INTO esg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","पूरा सहरतोर येसु मत्‍ता लोता गलमातगा जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","येसु तीरतीरकुना बिमार्क मत्‍तोर वेल्‍लेटोर्कुन बेस कीतोर, देय्याल्क पीसि मत्‍ता वेल्‍लेटोर्कुना देय्याल्कुन पेचाह्‍चि गेदुमतोर. अव ओन एरपाट कियुंदुं, अदुनहाटीं ओर अवुन वळ्का हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","येसु इंकुंदि रोज हक्‍केरेने बय-बय आयानेंके तेदसि बोरे हिल्वगा होंचि पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","सिमोन आनि ओना दंटातुर तेदता पजा येसुन पहकालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","पह्‍किसि-पह्‍किसि दोर्किच्‍चि, “नीकुन अंटोर पह्कसेक मंतुर,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “मनम पकापीसि मत्‍ता नाह्कुने दाकोम, आ नाह्कुने पेनदा पोल्‍लें वेहमळ गावाले. इद कबळताहाटींगे नना वातन.” ");
INSERT INTO esg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","अल्हा ओर पूरा गालिल एरियाते तिरियसेके, ओरा दर्मसास्‍त्रम कराहना लोहकुने होंचि पेनदा पोल्‍लें वेहचेके, देय्याल्क पीसि मत्‍तोरागटाल देय्याल्कुन पेचाह्‍चि गेदुमसेके होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","अल्हा होंचेके मननेंके वरोर कुस्‍टरोगम आता मनकल येसुनगा वासि, ओना काल्कुनपोर्रो अर्सि, “निमे इन्‍कुत्‍ते नाकुन बेस किया पर्रांतिन,” इंचि येसुन विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","येसुंक ओनपोर्रो दया वाताहेंका कय मुन्‍नेळ्‍क कीसि ओन इट्‍सि, “निमे बेस आयगोम इंचि नावा मनसु मंता. निमे बेस आम” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","इत्‍ता इनुडे ओना कुस्‍टरोगम होत्‍ता ओर बेस आतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","अस्‍के, “हूळा! इगे जर्गतद बोर्के वेहमा. गानि निमे होंचि मीवा पेर्मांक हुप्‍सा. कुस्‍टरोगमताल निमे बेस आता गवाइ इंचि मूसाल वेहता मोक्‍कु हीम. अदुन हूळसि निमे बेस आतिन इंचि लोकुल्‍कुंक एरपाट आंता,” इंचि येसु ओन्क गट्‍टिगा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","गानि आ मनकल अगटाल पेय्सि अद पोल्‍ले अंटोर्क वेहालय दल्‍गतोर. अस्‍के, “अंटोर्क तेळियता, नाकुन हूळसि लोकुल्‍क मंदानां-मंदां वांतुर,” इन्कुंचि येसु कळमता नाह्कुने होना हिल्‍लोर. ओर अल्किर हिल्वा जेगाते मत्‍तोर, अगागुडा लोकुल्‍क नालुं-मूलानाल ओना जाडा पीसि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","कोन्‍नि रोजकु आतारित्‍ते येसु कपर्नाहुम सहरते मल्सि वातोर, ओर लोन मंतोर इंचि लोकुल्‍कुंक तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","अस्‍के लोतागा इच्‍चोर वेल्‍ले लोकुल्‍क जमा आतुर गदा, गल्‍माते नित्‍तालय जेगागुडा मनाहिल्‍ले. येसु ओर्कु पेनदा पोल्‍लें कराहतोर. ");
INSERT INTO esg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","अद वेलाते नालुर मनकालोर वरोर लकवा बिमारतोन पीसि येसुनगा वातुर. ");
INSERT INTO esg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","गानि वेल्‍ले गर्दि मत्‍ताहाटीं ओर येसुनगा ओया पराहिल्‍लुर. अय्ते ओर लोतपोर्रो कटुल पियानच्‍चो बोंगा कीसि लकवा बिमारतोन येसुनगा रेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","येसु ओरा विस्वासमतुन हूळसि, आ लकवा बिमारतोन, “कोको, नीवा पापाल्क मापि आतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","अस्‍के अगा उद्‍दिसि मत्‍तोरा लोप्पोटाल इच्‍चुर दर्मसास्‍त्रम कराहना गुरुल्क, “ईर इल्‍हा बारि वळ्कसंतोर? ईर पेनदा अपमानम कींतोर. पेन तप्‍पा इंका बोरे पापाल्कुन मापि किया पर्रुर,” इंचि ओर-ओरे मनसुने विचारम कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ओर-ओरे विचारम कियानद येसु ओना मनसुने बिराना एरपाट कीसि, “मी मनसुने मिमेट इसोंटा विचारम बारि कींतिर? ");
INSERT INTO esg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","बद अल्कगा मंता? लकवा बिमारतोन, ‘नीवा पापाल्क मापि आतां इंचि इनमळा हिलाकोंटे, नीवा कटुल तेहकुंचि ताका’ इनमळ?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पजा, “गानि मनकना रूपमते पुटतोन नाकु, ई बूमिपोर्रोटा पापाल्क मापि कियाना अदिकारम मंता इंचि मीक तेळियोना?” इंचि इत्‍तोर. पजा आ लकवा बिमारतोन, ");
INSERT INTO esg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“नना नीकु वेहासेके, तेदसि नीवा कटुल तेहकुंचि लोन होन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","इत्‍ता इनुडे ओर तेदसि कटुल पीसि अंटोर मुन्‍नेटाल पेय्सि होत्‍तोर. अदुन हूळसि अंटोर इचंत्रम आतुर. “इल्‍हा मोमोट बस्‍केने हूळा हिल्‍लोम” इंचि पेनदा स्‍तुति कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","येसु मर्रा उंदि मल्का समुद्रम ओड्‍डुंक होत्‍तोर. वेल्‍लेटुर लोकुल्‍क ओनगा वातुर अस्‍के येसु ओर्कु पेनदा पोल्‍लें कराहलय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","कराहमळ आतस्के अगटाल होननेंके अल्‍पिना मर्रि लेवि, कर वसुल कियना नाकातगा उद्‍दिसि मत्‍तद हूळतोर. हूळसि ओन, “नावा पज्जो वा,” इंचि इत्‍तस्के ओर तेदसि ओना पज्जो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","पजा येसु लेविना लोन गाटो तिंचेके मननेंके वेल्‍लेटुर कर वसुल कियानोर आनि पापि लोकुल्‍क वासि येसु आनि ओना सिस्युल्कुनतोनि गाटो तिनालय उदतुर. ओरव्टे वेल्‍लेटुर येसुन विस्वासम कीतोर मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","कर वसुल कियानोरतोनि आनि पापि लोकुल्‍कुनतोनि येसु गाटो तिनानद परिसिल्क आनि दर्मसास्‍त्रम कराहना गुरुल्क हूळतुर. हूळसि, “कर वसुल कियानोरतोनि आनि पापि लोकुल्‍कुनतोनि येसु गाटो बारि तिंतोर?” इंचि ओर येसुना सिस्युल्कुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","अद केंजसि येसु ओर्कुन इल्‍हा इत्‍तोर, “बिमार हिल्‍वोर्कुंक डाक्‍टरना अव्‍सरम मन्‍नो गानि बिमार मत्‍तोर्कुंक डाक्‍टरना अव्‍सरम मनंता. नना नीतिमंतुल्‍कुन केयालय आयो गानि पापि लोकुल्‍कुन केयालय वातन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","बापतिस्मा हियना योहानुना सिस्युल्क आनि परिसिल्क ओक्‍कापोद्‍दु मनुंदुर. अय्ते इच्‍चुर लोकुल्‍क वासि, “योहानुना सिस्युल्क आनि परिसिल्क ओक्‍कापोद्‍दु मनंतुर. गानि नीवा सिस्युल्कु मन्‍नुर. अल्हा बारि?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","अस्‍के येसु ओर्क इल्‍हा वेहतोर, “मरमिन पेडल मरमिं वाता हेडमितोरतोनि मननेंके ओर्कु ओक्‍कापोद्‍दुना अव्‍सरम मनंतना? मन्‍नो. बदवेरादाका मरमिन पेडल ओरतोनि मनंतोर अदवेरदाका ओर ओक्‍कापोद्‍दु मन्‍नुर. ");
INSERT INTO esg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","गानि मरमिन पेडल ओरागटाल लक्‍कु आयाना रोजकु वायनुं, अस्‍के ओर ओक्‍कापोद्‍दु मनानुर.” ");
INSERT INTO esg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“बोरे आयिर पडना कप्‍पिड हर्ते, दानकु पूना कप्‍पिडता गंडा अंटा वाट्‍सि कुट्‍टोर. ओक्‍कला ओर अल्हा कियानय्ते अंटा वाटता पूना कप्‍पिडता गंडा इगका होंचि पळाना कप्‍पिडतुन इंकिच्‍चो हरहंता. ");
INSERT INTO esg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","अल्‍हेने पूना अंगुर पानकमतुन पळाना तोलपुर्काते बोरे दोस्सुर, अल्हा दोसते अद अंगुर पानकम, पळाना तोलपुर्कातुन हराह्‍चि पोंगिस दांता. आनि तोलपुर्कागुडा नासडेम आंता. अदुनहाटीं पूना अंगुर पानकम, पूना तोलपुर्कातेन दोसंतुर,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","उंदि नोमकेम रोजुने येसु आनि सिस्युल्क पोलाल्‍कुनाल होंचेके मत्‍तुर, होननेंके ओना सिस्युल्क हेनकु नल्‍सि तिंचेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","परिसिल्क अदुन हूळसि, “बद कबळ अय्ते नोमकेम रोजुने कियमळ नियम परकारम ओज्‍जोनो, अदे कबळ नीवा सिस्युल्क बारि कीसंतुर?” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","अस्‍के येसु ओर्कुन, “दाविदुंक आनि ओना दंटातोर्कुंक कर्वेस्‍तस्‍के ओर बतल कीतोर मिमेट हदवा हिल्‍लिरा? ");
INSERT INTO esg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","अबियातार इनानोर पेद्‍दा पेर्मल मननेंके दाविद पेनदा लोते होळियसि पेनदुक मोळ्कता हारिन तित्‍तोर, ओना दंटातोर्कुंकगुडा हीतोर. अव हारिं तिनमळ इत्‍ते दर्मसास्‍त्रम परकारम विरोदमते मत्‍ता. अव हारिं सिराप पेर्मालोर्क तप्‍पा इंका बोरे तिना पर्रुर,” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","मर्रा ओरतोनि, “नोमकेम रोजु मनकनाहाटीं कीसि मंता, मनकल नोमकेम रोजुनाहाटीं आयो. ");
INSERT INTO esg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","अदुनहाटीं मनकना रूपमते पुटतोन नना, नोमकेमता रोजुना मालकगुडा आंदुन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","येसु मर्रा उंदि मल्का दर्मसास्‍त्रम कराहना लोते होत्‍तोर. अगा वरोर कय वत्‍सोत्‍ता मनकल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","नोमकेम रोजुने येसु ओन बेस कियानय्ते ओन तप्पुने पीकोम इंचि इच्‍चुर लोकुल्‍क हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","“अंटोरा मुन्‍ने वासि नित्‍ता,” इंचि येसु, कय वत्‍सोत्‍तोन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","पजा, “नियम परकारम, नोमकेम रोजुने बेस कियमळ मंचिदा, कराब कियमळ मंचिदा? हिलाकोंटे पिसागोटते मंचिदा, हव्कते मंचिदा?” इंचि पूसकीतोर. गानि ओर चुपचाप मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ओर्क बोर्के जीवा नोय्यो इंचि कन्‍कुंचि येसुंक दुक्‍कम वासि, ओर अंटोरहेके होंगुने हूळतोर. पजा, “नीवा कय मुन्‍नेळ्‍क हहा,” इंचि आ कय वत्‍सोत्‍तोन इत्‍तोर. ओर कय मुन्‍नेळ्‍क हाहतस्‍के ओना कय बेस आता. ");
INSERT INTO esg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","पजा परिसिल्क अगटाल पलाते पेय्सि, हेरोद राजाना लोकुल्‍कुंक होंचि कलियतुर. कलियसि येसुन बल्हा हव्कना? इंचि येसुना विरोदमते वळ्‍क्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","येसु ओना सिस्युल्कुन पीसि अगटाल पेय्सि समुद्रमहेके होत्‍तोर. येसु कियाना इचंत्रमता कबाह्‍क केंजसि गालिल एरिया, यहुदिया एरिया, येरुसलेम सहर, इदुमिया एरिया, सूर, सिदोन इनना सहरकुनाल, योर्दन बेरेटा हब्बेटाल, आनि पकापीसि मत्‍ता नाहकुनाल वेल्‍लेटुर लोकुल्‍क ओनगा वातुर. ");
INSERT INTO esg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","बिमार मत्‍तोर्कुन वेल्‍लेटोर्कुन येसु बेस कीतोर. अदुनहाटीं बिमार लोकुल्‍क येसुन इट्‍टानाहाटीं वरोंक-वरोर दोब्सेके वासेक मत्‍तुर. ओरपोर्रो अर्राकोंटा लक्‍कु मंदना इंचि, “उंदि सिन्‍ना डोंगा नाहाटीं तयार कीम्‍टु,” इंचि येसु ओना सिस्युल्कुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","देय्याल्क पीसि मत्‍ता लोकुल्‍क येसुन बस्के अय्ते हूळुंदुरो अस्‍के, “निमे पेनदा मर्रिन!” इंचि वरगेयसि ओना मुन्‍ने हिळु अर्रुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","गानि येसु मात्रम, “नावा बारेमते बोर्के बतले वेहमट,” इंचि आ देय्याल्‍कुंक गट्‍टिगा हुकुम हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","पजा येसु गुट्‍टापोर्रो होत्‍तोर. आ मंदिताल येसु बोर्कुनय्ते कोरतोर, ओर्कुन ओनगा केयकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","ओर ओनतोनि मनालय, पेनदा बेसता कबुर वेहनाहाटीं लोहालय इंचि पन्‍नेंड मंदितुन पेरतोर. पेरसि ओर्कु प्रेरितुल्क इंचि पोरोल दोसतोर. ओर्क देय्याल्क गेदमना अदिकारम हीसि निलाहतोर. ");
INSERT INTO esg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ओरा पोरोलीं इल्‍हा मंतां: सिमोन, ईनकु येसु पत्रु इंचि पोरोल दोसतोर, ");
INSERT INTO esg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जब्‍दिना मर्क याकोब आनि ओना तम्मुर योहान. ईर इव्वुर्कुन बोनेर्गेस इंचि येसु पोरोल दोसतोर, इत्‍ते गर्जना कियानोर इंचि अर्तम. ");
INSERT INTO esg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अंदरियल, पिलिपु, बरतलमय, मत्‍तयाल, तोमल, अल्‍पिना मर्रि याकोब, तद्‍दि, सिमोन कनानि, ");
INSERT INTO esg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","आनि येसुन दोकाते पीसि हियानोर इस्‍कारियोत नाटेना यहुदल. ");
INSERT INTO esg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","पजा येसु उंदि लोन होत्‍तोर. अगागुडा इच्‍चोर वेल्‍ले मंदि जमा आतुर गदा, येसुंक, ओना सिस्युल्कुंक गाटो तिनालयगुडा वेला दोर्काहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","येसु पिसा-पिसा कीसंतोर इंचि लोकुल्‍कुनहेंदाल ओना लोतोर केंजसि ओन लोन तायालय होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","येरुसलेमताल वाता दर्मसास्‍त्रम कराहना गुरुल्‍कु, येसु देय्याल्कुन गेदुमसेके इंचि, “ईना लोप्पो ‘बेलजेबुल’ इनना देय्याल्कुना मुक्‍यल होळियसि मंता, दाना बलमते ओर देय्याल्क तेंडांतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","अदुनहाटीं येसु ओर्कुन दग्‍गेरा केय्‍सि ओर्कु वेसुडिते वेहातोर. “देय्यम दाना देय्याल्कुन बल्हा तेंडा परांता? ");
INSERT INTO esg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ओक्‍कला, उंदि राज्येमते मनानोरा लोप्पो वरोनद-वरोंक अर्राकोंटे अद राज्येम निल्‍ला परांतना? बस्‍केने निल्‍ला पर्रो. ");
INSERT INTO esg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अल्‍हेने उंदि लोता लोप्पो वरोनद-वरोंक अर्राकोंटे अद लोन गट्‍टिगा मन्‍नो. ");
INSERT INTO esg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","अदुनहाटीं देय्यम दाना दंटाता देय्याल्कुना विरोदमते नितते, अवुना राज्येम बल्हा नित्‍तंता? नित्‍तापर्रो, गानि नासडेम आंता. ");
INSERT INTO esg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","बोरे आयिर! वरोर ताकतवर मनकना लोते होळियसि ओना सामानतुन दोंगा कियना इत्‍ते, मोदाला आ ताकतवर मनकन दोहचि वाटतेन दोंगा किया परांतोर. ");
INSERT INTO esg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","नना मीक निजम वेहांतन, मनकालोरा अन्‍नि पापाल्कुन, ओर कीता अपमानमतुन पेन मापि किय्‍यार. ");
INSERT INTO esg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","गानि पवित्र आत्माता अपमानम कीते, ओर बोरे आयिर, ओन्क बस्‍केने मापि हिल्‍ले. असोंटा तप्पु कीता लोकुल्‍क बस्‍केळ्‍क पापमता दोसेमतेन मनंतुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","अल्हा बारि वेहतोर इत्‍ते, “ओनालोप्‍पो देय्यम मंता,” इंचि दर्मसास्‍त्रम कराहना गुरुल्क ओन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","पजा येसुना यावल, ओना तम्मुह्‍क ओर मत्‍ता लोतगा वातुर. ओर लोता पलाते नित्‍तिसि येसुन केयट इंचि लोहतुर. ");
INSERT INTO esg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","लोकुल्‍क येसुना सुट्‍टु उद्‍दिसि मत्‍तुर. अस्‍के, “नीवा यावल, नीवा तम्मुह्‍क, हेलाह्क पलाते एदुर हूळसेक मंतुर,” इंचि ओर वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","अय्ते, “बद नावा यावल, बोर ना तम्मुह्‍क?” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","अस्‍के ओना सुट्‍टु उद्‍दिसि मत्‍तोरहेके हूळसेक, “ईरे नावा यावल, ईरे ना तम्मुह्‍क आंदुर. ");
INSERT INTO esg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","बोर अय्ते पेनदा इच्‍चा परकारम ताकंतुरो ओरे नावा तम्मुर, हेलड आनि यावनलेसीं दग्‍गेटोर आंदुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","येसु मरुंदि मल्का गालिल समुद्रम ओड्‍डुनगा होंचि पेनदा पोल्‍लें कराहलय दल्‍गतोर. अस्‍के ओनगा वेल्‍लेटुर लोकुल्‍क जमा आताहेंका ओर उंदि डोंगा एक्‍किस उदतोर. लोकुल्‍क बारे बूमिपोर्रो नित्‍तिसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","अस्‍के ओर वेल्‍लेन पोल्‍लें लोकुल्‍कुंक वेसुडिं वेहासेक कराहतोर. उंदि वेसुडि इल्‍हा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“केंजट, वरोर कास्‍तकरि मनकल विज्‍जां वीतालय पेय्‍स्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ओर वीतनेंके इच्‍चुं विज्‍जां हरदगा अरतां, अस्‍के अवुन पिट्‍टें वासि पेर्सि तित्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","इच्‍चुं विज्‍जां बंडाना गेर्सेपोर्रो अरतां. अगा तोळि एक्‍को हिलुवादानकु आ विज्‍जां बिराने मोलियतां. गानि हिह्‍कु लोप्‍पोळ्‍क होनवाहेंका पोळ्‍द पेय्‍स्‍तस्‍के अव वत्‍सि हासोत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","गानि हिह्‍कु लोप्‍पोळ्‍क होनवाहाटीं पोळ्‍द पेय्सि वेल्‍ले एद्‍दि आतस्के अव वतसि कर्विसि होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","इंका इच्‍चुं विज्‍जां हाह्कुना पोदाने अरतां. हाह्कुना पोदां इरगा बेर्सि, अव विज्‍जन बेर्सा हिया हिल्‍लें, अदुनहाटीं पंटा पेय्‍सा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","इच्‍चुं विज्‍जां बेसता जेगाते अरतां. अव बेस मोलियसि, बेर्सि बेस पंटा पेय्‍स्‍ता. बगा मुप्‍पै अंताल्‍क, बगा अरवै अंताल्‍क, बगा नूर अंताल्कुना पंटा पेय्‍स्‍ता,” इंचि वेसुडि महतोर. ");
INSERT INTO esg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","पजा मर्रा ओर्कुन, “बोर्कु केंजालय केव्क मंतां ओर केंजट,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","येसु वरोरे मत्‍तद हूळसि अगा मत्‍तोरा लोप्पोटाल इच्‍चुर लोकुल्‍क आनि ओना पन्‍नेंड सिस्युल्कु ओनगा होंचि “ई वेसुडिता अर्तम वेहा,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","येसु ओर्कुन, “मीक अय्ते पेनदा राज्येमता बारेमता मर्ममतुन एरपाट कीकुनालय बुद्‍दि मंता, गानि पलातोर्कुंक बारे इद मर्मम तेळियालय वेसुडिने वेहा पींता.” ");
INSERT INTO esg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","बारित्‍ते, “ओर हूळुळ अय्ते हूळंतुर, गानि अदुन एरपाट किय्युर. केंजुड अय्ते केंजांतुर, गानि अद ओर्क तेळियो. ओक्‍कला ओर एरपाट कीकुंचि मत्‍ते, तेळियागोटकुंचि मत्‍ते, पेनदागा मल्सि वायेर, पेन ओर्कुन मापि कियवळ,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","मर्रा येसु ओर्कुन इल्‍हा इत्‍तोर. “मीक इद वेसुडिता अर्तम तेळिया हिल्‍लेना? इदे मीक तेळियाकोंटे इंका वेरे वेसुडिं मीक बल्हा तेळियानुं? ");
INSERT INTO esg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","इगे वीतानोर इत्‍ते पेनदा पोल्‍लेतुन वेरेतोर्क वेहानोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","इच्‍चुर लोकुल्‍क विज्‍जां अरता हर्दा जेगातसंटोर आंदुर. ओर पेनदा पोल्‍लेतुन केंजांतुर, केंजतारित्‍ते देय्यम बिराना वासि ओर केंजतवुन तेंडसि पोहंता. ");
INSERT INTO esg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","विज्‍जां अरता बंडाना गेर्से जेगातसंटोर बोर इत्‍ते, बोर अय्ते पेनदा पोल्‍लेतुन केंजसि कुसिते बिराने ओप्‍कुंतुर. ");
INSERT INTO esg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","गानि ओरा मनसुने पेनदा पोल्‍लेता हिह्‍कु गट्‍टि पळुवाहाटीं कोन्‍नि रोजके विस्वासमते मनांतुर. पेनदा पोल्‍लेताहाटीं तिप्‍पल्‍क, कस्‍टाल्‍क वाते विस्वासमताल ओर बिराना लक्‍कु आंतुर. ");
INSERT INTO esg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","विज्‍जां अरता हाह्कुना पोदाना जेगातसंटोर बोर इत्‍ते, बोर अय्ते पेनदा पोल्‍ले केंजांतुर, ");
INSERT INTO esg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","गानि सम्‍सारमता रंदि, दनमता आस्‍ति, दिसतवंता गावाले इत्‍ता मनसु, इवन्‍नि मत्‍ताहाटीं पेनदा पोल्‍लेतुन ओनालोप्‍पो बेर्सा हिय्यों. पजा अद पोल्‍लेहेंदाल ओन्क बतल पायदा आयो. ");
INSERT INTO esg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","बोर अय्ते पेनदा पोल्‍लेतुन केंजसि, ओप्‍कुंचि बेस पायदा तरांतोर, ओर इत्‍ते, विज्‍जां अरता बेसता जेगातसंटोर आंदुर ओर मुप्‍पै अंताल्‍क, अरवै अंताल्‍क आनि नूर अंताल्‍क इल्‍हा पलांचंतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","येसु मरुंदि वेसुडि वेहतोर. “बोरे आयिर वेडसि निरिच्‍चि गंजुना हिळु मुच्‍चोर, कटुल हिळुगुडा इर्रोर. गानि वेल्‍गु दिसगोम इंचि दान उंदि दीसोडिपोर्रो इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","मक्‍किस मत्‍तव अन्‍नि दिस्‍सि अर्राकोंटा मन्‍नों, आनि मर्ममते मत्‍तव बवे पलाते अर्राकोंटा मन्‍नों. ");
INSERT INTO esg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","बोर्कु केंजालय केव्क मंतां ओर केंजट,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","मर्रा येसु ओर्कुन इल्‍हा इत्‍तोर. “मिमेट बेस उसारते केंजट, बद कोल्ताते मिमेट हींतिरो, अदे कोल्ताते मीकु हियमळ जर्गंता, इंका दानकन्‍ना एक्‍कोगुडा हियमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","बारित्‍ते, बोनगा अय्ते मंता, ओन्क पेन इंका हींता. गानि बोनगा अय्ते हिल्‍ले, ओनगा मत्‍तदुनगुडा पेन वापस एतकुन्‍नार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","मर्रा येसु इल्‍हा वेहतोर. “पेनदा राज्येम इल्‍हा मंता, वरोर मनकल ओना नेलिते विज्‍जां वीतंतोर. ");
INSERT INTO esg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ओर नर्कळ्‍क मींडंतोर, पोद्‍दला तेल्‍विते मनंतोर. अद विज्जा मोलियसि बेर्स्‍सेकेन दांता. अद विज्जा बल्हा मोलियता, बल्हा बेर्सता इत्‍तद ओनकु तेळियो. ");
INSERT INTO esg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","बूमि दानद अदे पंटातुन पंडागोटंता. अद बल्हा इत्‍ते मोदाला मोल्का मोलियंता, कर्रे बेर्संता, पोट्‍टक वांता, हेन्‍नु पेय्सि पेडेक निंडंतां. ");
INSERT INTO esg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","गानि बस्के अय्ते पेडेक मुदरंतां अस्‍के नेलिता मालक पंटा कोतक वाता इंचि हेटेळ पीसि कोय्‍यंतोर.” ");
INSERT INTO esg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","मर्रा येसु ओर्कु इल्‍हा वेहतोर, “पेनदा राज्येम बल्हा मनंता इंचि वेहकन? बद वेसुडि वेह्‍चि तेल्‍पिचकन? ");
INSERT INTO esg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","पेनदा राज्येम आवाल्‍कुना उंदि पेडेतसोंटद आंद. अद बूमिपोर्रो वीततस्के, अन्‍नि पेडेकुंकन्‍ना सिन्‍ना पेडे मनंता. ");
INSERT INTO esg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","गानि अद बेर्सतस्‍के अगा मनना अन्‍नि कुसिर कायाना मराकुंकन्‍ना पेद्‍दा मरा आंता. दाना पंगां पोळ्‍गुंक-पोळ्‍गु बेर्सि, पिट्‍टें इंका नीडाते गूडां किया परांतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","येसु इसोंटव बच्‍चुंगो वेसुडिं वेह्‍चि, ओर्क पेनदा पोल्‍लें तेळियानाल वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","वेसुडि वेहाका येसु ओर्कु बतले वेहाकोंदुर. गानि सिराप ओना सिस्युल्क मत्‍तस्के अव वेसुडिना अर्तम ओर्क तेळियागोट्‍सि वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","अद रोज पोळ्‍द होनना वेलाते, “मनम हब्बेटा बाजुंक दाकोम दट,” इंचि येसु ओना सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ओना सिस्युल्क अगाटा मंदितुन अग्गेन होळसि, येसु उद्‍दिस मत्‍ता डोंगाते उद्‍दिस होनालय पेय्‍सतुर. ओरा पज्जो इंकिच्‍चुं डोंगांगुडा पेय्सतां. ");
INSERT INTO esg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","अस्‍के उंदि पेद्‍दा वळि-दुमारम वाता. पेद्‍दा-पेद्‍दा तळां डोंगाक दल्‍गिसि एर निंडालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","गानि येसु डोंगाता पज्‍जोटा बाजुंक होंचि मेत्‍तापोर्रो मींडसेक मत्‍तोर. अस्‍के सिस्युल्कु येसुन तेहचि, “गुरु! मनम नासडेम आसि होनिनागानि नीकु बतल पिकिर हिल्‍लेना?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","अस्‍के ओर तेदसि, वळि-दुमारमतुन आनि समुद्रमतुन, “आगा, चुपचाप मन” इंचि गदरिचतोर, अस्‍के वळि-दुमारम मग्‍गिसि, अगा पूरा सांत आता. ");
INSERT INTO esg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","अस्‍के येसु सिस्युल्कुन, “मिमेट बारि वेरियंतिर? मीकु गिच्‍चचोगुडा विस्वासम हिल्‍लेना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ओर इरगा वेरियसि, “ईर बोर आंदुर? वळि, समुद्रमगुडा ईना पोल्‍ले केंजंता,” इंचेके ओर-ओरे वळ्‍ककुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","अस्‍के ओर समुद्रमता हब्बेटा बाजुंक मनना गिरासेन इनना एरियक एव्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","येसु डोंगाताल रेयतस्के वरोर देय्यम पीता मनकल तापळन बोग्‍ळाताहेंदाल वासि येसुंक कलियतोर. ");
INSERT INTO esg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","ओन बच्‍चुंगो मल्कां बेडिने, गोल्सुकुने दोहचि वाटतुर, गानि ओर बेडिन उराहचि पोहतोर, गोल्सुकुन नेम्‍हाचि पोहतोर. ओन बोरे आपा पराहिल्‍लुर. ओर तापळानेन मनुंदुर, ओन बोरे गोल्सुकुने दोहा पराकोंदुर. ");
INSERT INTO esg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ओर नर्का-पिय्यल तापळाने, गुट्‍टाने तिरियसेक वरगेयसेक मनुंदुर. ओनद ओरे बंडाने कोह्‍ककुंचि नोप्‍पिं कीकुंनुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ओर लक्‍कुटाले येसुन हूळसि, विच्‍चि वासि ओना काल्क मोळ्‍कतोर. ");
INSERT INTO esg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","अस्‍के, “ओनागटाल पलाते पेय्‍सा,” इंचि येसु आ मनकन पीता देय्यमतुन इत्‍तोर. अदुनहाटीं ओर येसुन, “ए अन्‍निटकन्‍ना पेद्‍दा पेनदा मर्रि येसु, नातोनि नीकु बता कबळ? निमे नाकुन तकलिप किय्योन इंचि पेनदा ओट्‍टु तिंचि वेहा,” इंचि जोरसे वरगेयसि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","मर्रा, “नीवा पोरोल बतल?” इंचि येसु पूसकीतोर. अस्‍के ओनालोप्‍पो मत्‍ता देय्यम, “मोमोट वेल्‍लेन मंदा आसि मंतोम, इंचि नावा पोरोल ‘मंदा’ आंद,” इल्‍हा जवाब हीता. ");
INSERT INTO esg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ओनालोप्‍पो मत्‍ता देय्याल्क, “माकुन इद एरियाताल पलाते गेदुममा,” इंचि येसुन बच्‍चोरो विनंति कीतां. ");
INSERT INTO esg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","अद वेलाते गुट्‍टा पक्‍काते पद्‍दिना मंदा मेय्‍सेके मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","पजा, “माकुन आ पद्‍दिना मंदाते होनाहीम,” इंचि आ देय्याल्क येसुन विनंति कीतां. ");
INSERT INTO esg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","अस्‍के येसु अवुन होना वेहतोर अय्ते, आ देय्याल्क ओनागटाल पेय्सि पद्‍दिना मंदाते होत्‍तां. अव पद्‍दिं रोंडु वेयकुनदाका मत्‍तां. पजा आ पद्‍दिना मंदा समुद्रम ओड्‍डुन पोर्रोटाल हिळतुक वित्‍सि समुद्रमते मुळ्‍गिसि हासोत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","अद हूळसि पद्‍दिं मेहानोर वित्‍सि होंचि, सहरते, पक्‍का पीसि मत्‍ता नाह्कुने अगा जर्गतद वेहतुर. अस्‍के आ देय्याल्क पीतोरद बतल आता इंचि लोकुल्‍क हूळालय अगा वातुर. ");
INSERT INTO esg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","येसुनगा वासि हूळतुर अय्ते, देय्याल्क पीसि मत्‍ता मनकल पुरागा बेस आसि, कपडिं केर्सि उद्‍दिसि मत्‍तद ओर्क दिसतोर. अल्हा मत्‍तद हूळसि ओर्क वेर्रे दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","येसुना कबाह्‍कुन हूळतोर अगा बोर अय्ते मत्‍तुरो ओर, देय्याल्क पीसि मत्‍ता मनकल बल्हा बेस आतोर, पद्‍दिंक बल्हा-बतल आता इवन्‍नि पोल्‍लें लोकुल्‍कुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","इवन्‍नि पोल्‍लें केंजसि, “निमे मा एरियाताल पेय्सि होन,” इंचि लोकुल्‍क येसुन विनंति कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","अस्‍के येसु होनालय डोंगाते उदसेके मननेंके, देय्याल्कुनाल बेस आता मनकल वासि, “नाकुन नीवातोनि वाया हीम,” इंचि येसुन विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","गानि येसु ओप्‍कुन्‍ना हिल्‍लोर, “सामि नीपोर्रो दया कीसि नीहाटीं बल्हा बतल कीतोरो, लोन होंचि नीवा लोतोर्कुंक वेहा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","अय्ते ओर मनकल अगटाल देकापोलिस एरियाते होंचि, येसु ओनाहाटीं बतल-बतल कीतोरो अव अन्‍नि पोल्‍लें वेहालय दल्‍गतोर. अद केंजसि अंटोर इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","येसु डोंगाते उद्‍दिसि समुद्रमता हब्बेटा ओड्‍डुंक मर्रा मल्सि होत्‍तोर. ओन हूळसि वेल्‍लेटुर लोकुल्‍क ओनगा जमा आतुर. ओर समुद्रम ओड्‍डुनगा मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","अस्‍के दर्मसास्‍त्रम कराहना लोता वरोर याईर पोरोलतोर अदिकारि येसुनगा वातोर. वासि ओना काल्कुनपोर्रो अर्सि, ");
INSERT INTO esg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“नावा सिन्‍ना मिय्यड बेस हिलाका हायनाल आसि मंता. निमे वासि दानपोर्रो कय इरते, अद बेस आसि दाना जीवा पिस्‍संता,” इंचि विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","येसु आ अदिकारिनतोनि होत्‍तोर. ओना पज्जो वेल्‍लेन मंदि पेय्सि ओना सुट्‍टु वेल्‍ले गर्दि कीसि पोर्रो-पोर्रो अर्रालय आयुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","आ गर्दिते पन्‍नेंड वर्सानाल उंदेतीर कप्‍पिड आयना उंदि मुरतळ मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","अद वेल्‍लेटुर वैदकुल्‍कुंक हुपिस्‍ता. दानगा मत्‍ता कोत्‍तांता मार्तां गानि दाना बिमार बेस आयाका एक्‍कोने आसेके होत्‍ता. इल्‍हा अद वेल्‍लेने तकलिप बोगांचेक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","अद मुरतळ येसुना बारेमते केंजसि मत्‍ता. दाना मनसुने, “नना सिराप येसुना कप्‍पिडतुन इट्‍टिनागानि बेस आंतन,” इंचि इनकुत्‍ता. अदुनहाटीं गर्दिते येसुना पज्जो वासि ओना कप्‍पिडतुन इट्ता. ");
INSERT INTO esg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","इट्ता इट्‍टुडे दाना कप्‍पिड आयमळ बंद आसि बिमार बेस आता इंचि दानकु अनपिस्ता. ");
INSERT INTO esg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","अदे वेलाते येसुंक ओना लोप्पोटाल ताकत पेय्सता इंचि अनपिस्ता. अस्‍के पज्जो मल्सि, “नावा कपडितुन बोर इटतुर?” इंचि येसु पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ओना सिस्युल्कु ओन, “गर्दिते लोकुल्‍क वरोनपोर्रो-वरोर अर्रानद निमे हूळसेक मंचिगुडा, नावा कपडितुन बोर इटतुर? इंचि पूसकीसेके मंतिन,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","गानि, “नाकुन बोरन्‍ना इटसि मंदगोम,” इंचि येसु अंटोरहेके हूळसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","अस्‍के अद मुरतळकु, बेस आतद तेळियताहाटीं, वेर्रेक वनकुसेक येसुनगा वासि ओना काल्कुना पोर्रो अर्सि अगा जर्गतद सत्‍तेम-सत्‍तेम वेहता. ");
INSERT INTO esg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","अस्‍के येसु आ मुर्ताटुन, “पेगिटुना, नीवा विस्वासमे नीकुन बेस कीता. इसोंटा बिमार मर्रा बस्‍केने वायो, सांतिते होन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","येसु अल्हा वळ्कसेक मननेंके, दर्मसास्‍त्रम कराहना लोता आ अदिकारिना लोताल इच्‍चुर लोकुल्‍क वासि, “नीवा मिय्यड हाता, इंदके गुरुन तकलिप कियमा,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ओर वळ्‍कानदुन केंजवाप कीसि येसु आ दर्मसास्‍त्रम कराहना लोता अदिकारिनतोनि, “निमे वेरियमा, विस्वासम इर्रा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","येसु अगटाल पेय्सनेंके पत्रुन, याकोबुन आनि याकोबुना तम्मुर योहानुन ओनतोनि पीकुत्‍तोर. ओर्क तप्‍पा बोने ओना पज्जो वाया हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ओर दर्मसास्‍त्रम कराहना लोता अदिकारिना लोन होत्‍तस्के अगा लोकुल्‍क इरगा अळानद, मोत्‍कुनानद हूळतोर. ");
INSERT INTO esg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","अस्‍के येसु लोप्पो होळियसि, “मिमेट अडमळ-मोत्‍कुनमळ बारि कीसेक मंतिर? अद पेगिळ हाया हिल्‍ले, मींडसि मंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","अल्हा इत्‍तद केंजसि ओर येसुन कव्‍तुर. गानि येसु ओर अंटोर्कुन पलाते लोहतोर. पेगिटा तल्‍लुर-बाबोन, ओनतोनि बोर अय्ते मत्‍तुर ओर्कुन पीकुंचि पेगिड मींडसि मत्‍ता अर्राते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","होंचि अद पेगिटा कयदुन पीसि, “तलिता कुम” इंचि इत्‍तोर. इत्‍ते, “पेगिटुना, नना वेहासेक, तेदा!” इंचि अर्तम. ");
INSERT INTO esg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अल्हा इत्‍ता इनुडे, आ पन्‍नेंड वर्साना पेगिड तेदिस ताकालय दल्‍गता. अदुन हूळसि, अगा मत्‍तोर वेल्‍लेन इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","“इगे जर्गतद बोर्के तेळिया मनि” इंचि ओर्कु गट्‍टिगा हुकुम हीतोर. पजा “अद पेगिड्‍क बतलन्‍ना तिनालय हीम्टु,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","येसु अगटाल पेय्सि ओना सहरते होत्‍तोर, ओना सिस्‍युल्‍कगुडा ओना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","नोमकेम रोजुने दर्मसास्‍त्रम कराहना लोते होंचि पेनदा पोल्‍लें कराहसेक मत्‍तोर. वेल्‍लेटुर लोकुल्‍क अव पोल्‍लें केंजसि, “ईर इच्‍चोर बेस बल्हा वेहासेक मंतोर? ईनकु इच्‍चोर बुद्‍दि बगाटाल वाता? ईर अद्‍बूतामाता कबाह्‍क बल्हा कीसेक मंतोर? ");
INSERT INTO esg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ईर अय्ते मरियमुना मर्रि वडलल आंदुर, याकोब, योसेस, सिमोन, यहुदल, ईरा दादल आंदुर. इगे मनातोनि उद्‍दिसि मनानव ओना हेलाहके आंदु,” इंचि इनालय दल्‍गतुर. अदुनहाटीं ओर येसुन ओप्कुना हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","अस्‍के येसु ओर्कुन, “पेनदा कबुरतोंक ओना संतम नाटेने, ओना जीवातोरगा आनि ओना लोन होळसिसि, कळमतव अन्‍नि जेगाने मान-मर्यादा दोर्कंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","अगा येसु बतले अद्‍बूतामाता कबाह्‍क किया हिल्‍लोर, सिराप बिमार मत्‍तोर्कुन इच्‍चुर्कुन इट्‍सि बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","येसुन ओर विस्वासम कियवाहाटीं ओन्क इचंत्रम आता. पजा नार-नार होंचि पेनदा पोल्‍लें कराहसेके तिरियतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","उंदि रोज येसु पन्‍नेंड मंदि सिस्युल्कुन दग्‍गेरा केयतोर. ओर्कुन इव्वुर-इव्वुर दंटा कीसि, ओर्क देय्याल्क गेदमना अदिकारम हीसि सेवा कियालय लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","अदिकारम हीसि ओर्कु इल्‍हा वेहतोर, “मिमेट होननेंके मीतोनि गाटो आयि, जोरा आयि, कोत्‍ताना संचि आयि, एक्‍कोतव अंगिं आयि ओयमट. सिराप कय्‍दे दुड्‍डु, काल्कुंक हेरपुह्क ओम्टु. ");
INSERT INTO esg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","मिमेट बद लोन अय्ते दांतिटो, अगटाल पेय्सनदाका अदे लोते मंटु. ");
INSERT INTO esg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","बोर अय्ते मीकुन ओप्‍कुन्‍नुर, मीवा पोल्‍लें केंजुर अगटाल पेय्सनेंके ओर्क विरोदमते गवाइलेसीं मीवा काल्कुना दुम्मु दुल्‍पट. नना मीक निजम वेहासेक मंतन, न्‍यायमता रोजुने आ नाटुक वाता गोसाकन्‍ना सदोम, गमोरा सहरकुंक वायाना गोसा बच्‍चोरो तक्‍को मनंता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","अस्‍के सिस्युल्कु अगटाल होंचि, “मीवा पापाल्क ओप्‍कुंचि, मनसु मार्सकुंटु” इंचि लोकुल्‍कुंक प्रचार कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","देय्याल्क पीतोरगटाल बच्‍चुंगो देय्याल्कुन गेदुमतुर. बिमारते मत्‍तोर्कुन निय होकसि बेस कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","येसुना पोरोल अंटोर्क तेळियसि होत्‍ता. हेरोद राजालगुडा येसुना बारेमते केंजतोर. अस्‍के ओर इल्‍हा इत्‍तोर, “बापतिस्मा हियना योहान हातोराव्टेटाल मर्रा तेदतोर. अदुनहाटीं ओर इसंटा अद्‍बूतामाता कबाह्‍क कीसंतोर.” ");
INSERT INTO esg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","अल्‍हेने इच्‍चुर बारे, “पेनदा कबुरतोर एलियल आंदुर,” इंकिच्‍चुर बारे, “एनकटा पेनदा कबुरतोरा लोप्पोटाल बोरन्‍ना वरोर मंदनुर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","गानि हेरोद राजाल इदुन केंजसि, “बापतिस्मा हिय्यना योहानुना तल्‍ला नना कोय्यागोटतन, ओरे हातोराव्टेटाल मर्रा जीवाते तेदतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","बारित्‍ते, हेरोद राजाल ओना तम्मुर पिलिपुना मुत्‍तो हेरोदियान इरकुंचि मत्‍तोर. अय्ते योहान हेरोद राजानगा होंचि, “नीवा तम्मुना मुत्‍तोन निमे निहगा इरमळ नियम परकारम बेस आयो,” इंचि वेहुंदुर. अल्हा वेहतादान्‍कु हेरोदियनहाटीं हेरोद राजाल सिपाइल्कुन लोहचि योहानुन जेलने वाटा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","अय्नागानि मोका दोर्कते योहानुन हव्कालय हेरोदियल हूळुंदु, गानि अद हव्का पर्राहिल्‍ले. बारित्‍ते योहान नीतिमंतुड, पवित्र मनकल इंचि हेरोद राजाल वेरियुंदुर. अदुनहाटीं ओर जेलते मननेंके ओन्क बतल आयामन्‍नि इंचि ओन कापाळसि इर्रुंदुर. हेरोद राजाल योहानुना पोल्‍लें केंजसि परेसान आसिगुडा कुसिते केंजुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","उंदि रोज हेरोदियांक मोका दोर्कता. हेरोद राजाल ओना पुटता रोज मंता इंचि ओनगा मनना पेद्‍दाल्कुन, सिपाइल्कुना अदिकारिल्‍कुन आनि गालिल राज्येमता लीडर्कुन बोजनमहाटीं केयतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","अस्‍के हेरोदियाना मिय्यड अगा वासि हेरोद राजाल अल्‍हेने हेळमितोरा मुन्‍ने एगरिसि ओर्कुन कूस कीता. अस्‍के राजाल आ पेगिटुन केय्‍सि, “नीकु बतल गावाले नाकुन तल्का, नना अद हींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","अल्‍हेने, “नावा सगम राज्येमगुडा नीकु हियालय तयार मंतन,” इंचि ओट्‍टु तित्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","अस्‍के अद पेगिळ दाना यावानगा पलाते होंचि, “बतल तल्ककन” इंचि पूसकीता. अस्‍के, “बापतिस्मा हियना योहानुना तल्‍ला तल्का,” इंचि दाना यावल वेहता. ");
INSERT INTO esg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","गाबरते आ पेगिड हेरोद राजानगा बिराना लोप्पो होंचि, “बापतिस्मा हियना योहानुना तल्‍ला उंदि गिन्‍नेते वाटसि नाकु हीम,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","इद केंजसि राजांक इरगा दुक्‍कम वाता. गानि अगा मत्‍ता अंटोर हेडमितोराहाटीं आनि तित्‍ता ओट्‍टुहाटीं, दानकु हींतन इत्‍तद हिय्योन इना पराहिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","अस्‍के राजाल, जेलते मत्‍ता योहानुना तल्‍ला कोय्‍सि ता इंचि वरोर सिपाइंक बिराना आदेस हीसि लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","आ सिपाइ जेलते होंचि, योहानुना तल्‍ला कोय्‍सि, उंदि गिन्‍नेते वाट्‍सि तच्‍चि पेगिड्‍क हीतोर, अस्‍के आ पेगिड अदुन दाना यावांक हीता. ");
INSERT INTO esg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","इद पोल्‍ले योहानुना सिस्युल्कुंक तेळियता. अस्‍के ओर होंचि ओना पीनगुन ओसि बोंदाते इरतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","नार-नार होंचि मत्‍ता येसुना प्रेरितुल्क, येसुनगा मल्सि वातुर. ओर होंचि लोकुल्‍कुंक बतल-बतल कीतुर, बतल-बतल कराहतुर इवन्‍नि पोल्‍लें येसुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ओरगा वायानुर-होनानुर लोकुल्‍क वेल्‍लेटुर मत्‍तुर, ओर्क गाटो तिनालयगुडा वेला दोर्काकोंदु. अदुनहाटीं, “मीक अराम किया पींता, बोरे हिल्वा जेगातगा दाकोम दट,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","अस्‍के ओर उंदि डोंगाते उद्‍दिसि बोरे हिल्वा जेगाते होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","गानि वेल्‍लेटुर लोकुल्‍क ओर्कुन होननेंके हूळसि एरपाट कीतुर. अदुनहाटीं अन्‍नि सहरकुनाल विच्‍चि वासि, ओर्कन्‍ना मुन्‍नेने अगा जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","येसु डोंगाताल रेयसि अद जेगातगा वेल्‍लेने मंदितुन हूळतस्‍के, कोहानोर हिल्वा गोर्रें बल्हा मनांतंगो ओर अल्हा आसि मत्‍तुर. अदुनहाटीं ओनकु ओरपोर्रो दया वासि ओर ओर्क पेनदा पोल्‍लें कराहलय सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","पोळ्‍द होनना वेलाक सिस्युल्क येसुनगा वासि, “मनम सुनसान जेगाते मंतोम, वेलागुडा बागेन आता. लोकुल्‍कुन लोहचीम, ओर दग्‍गेटा नाह्कुने होंचि, ओराहाटीं तिनालय बतलन्‍ना अस्कुंतुर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","गानि, “मिमेटे ओर्क हीम्टु,” इंचि ओर्कुन येसु इत्‍तोर. अस्‍के ओर इत्‍तुर गदा, “रोंडु नुह्कुना दिनारकुनतोनि अंटोराहाटीं तिंडि अस्सि तच्‍चि हियमळा बतला?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“मिहगा बच्‍चुं हारिं मंतां, होंचि हुळट,” इंचि येसु इत्‍तोर. ओर अवुन हूळसि, “हेय्युं हारिं, रोंडु जिम्मां मंतां,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","अस्‍के येसु, “अंटोर लोकुल्‍कुन पच्‍चाटा जाडि पोर्रो ग्रुप-ग्रुपुने उप्‍सट,” इंचि सिस्युल्कुंक आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ओर अंटोर ग्रुप-ग्रुपकुने उदतुर, उंदि ग्रुपने एबै, नूर इल्‍हा मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","अस्‍के येसु अव हेय्युं हारिं, रोंडु जिम्मां कय्‍दे पीसि, स्वर्गमताहेके हूळसि पेनदुक दन्यवाद कीतोर. अवुन तुकडें कीसि, “ओर्क पंचि हीम्ट” इंचि सिस्युल्कुंक हीसीतोर. अल्‍हेने अव रोंडु जिम्मानगुडा तुकडां कीसि हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ओर अंटोर पीरनिंडा तित्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","तिनुड आतस्के मिगुल्ता हारिना आनि जिम्माना तुकडां जमा कीते पन्‍नेंड तट्‍टां निंडतां. ");
INSERT INTO esg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","हारिं तित्‍तोरव्टे, सिराप मांडसे हेय्युं वेय्‍कुना मंदि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","अद आता पजा येसु बिराना ओना सिस्युल्कुन डोंगाते उपिच्‍चि, “मिमेट अंटोर समुद्रमता हब्बेटा बाजुंक मंदना बेतसेदा सहरते नाकन्‍ना मुन्‍नेने होंट,” इंचि इत्‍तोर. अगा मत्‍ता लोकुल्‍कुन ओरा नाहकुनहेके होनालय सार्ला कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ओर्कुन सार्ला कीता पजा, येसु पारतना कियालय गुट्‍टापोर्रो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","पोळ्‍द होत्‍ता पजा सिस्युल्कुना डोंगा नड्‍डुम समुद्रमते मत्‍ता, गानि येसु वरोरे ओड्‍डुनपोर्रो मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","समुद्रमते वळि-दुमारम डोंगाक एदुर तेदताहाटीं सिस्युल्कुंक डोंगा ताकसालय तकलिप होंचेके मत्‍तद येसु हूळतोर. हूळसि, नर्कटां मूड-नालुं एगाना वेलाते येसु सिस्युल्कुना डोंगातेके एतपोर्रो ताकसेक होत्‍तोर. ओर ओरगटाल मुन्‍ने पेय्सि होननदे मत्‍ता, ");
INSERT INTO esg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","गानि येसु एतपोर्रो ताकानद हूळसि देय्यम इंचि मोत्‍कुत्‍तुर, बारित्‍ते अंटोर ओन हूळसि वेरियतुर. अस्‍के येसु, “वेरियमट! ननाने आंदुन. दैरनेमते मंटु!” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","पजा सिस्युल्कुना डोंगाते येसु एक्‍कुता एक्‍कुडे वळि-दुमारम बंद आता. अद हूळसि ओर्क वेल्‍ले इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","बारित्‍ते मुन्‍ने हेय्युं वेय्‍कुना मंदिक गाटो दोसतद हूळसि मत्‍तुर, अय्नागानि येसु सामिना बलमतुन ओर एरपाट किया हिल्‍लुर. ओरा मनसुक बंडालेसीं आसि होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","पजा ओर अद समुद्रम दाटसि गेनेसरेत इनना नाटे एव्‍सि, अगा डोंगातुन आपतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ओर डोंगाताल रेयनेंकेन वेल्‍लेटुर लोकुल्‍क हूळसि येसुन एरपाट कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","पकापीसि मत्‍ता नाह्कुने विच्‍चि होंचि बिमार मत्‍तोर्कुन कटुल्‍कुने वाटसि येसु बगा मंतोर इंचि तेल्‍पिचकुंचि, अगा-अगा कांजसेक ओयुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","येसु नाटेने, सहरते, नेलिने बद-बद जेगाते अय्ते होनुंदुरो, अगाटा बिमार मत्‍तोर्कुन चौकते तच्‍चि मींडिच्‍चि, “सिराप नीवा कप्‍पिडता अंचुन इट्‍टा हीम,” इंचि येसुन विनंति कियुंदुर. अल्हा बोर-बोर अय्ते ओना अंचुन इट्‍तुरो, ओर अंटोर पुरागा बेस आतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","उंदि रोजु येरुसलेमताल इच्‍चुर परिसिल्क आनि दर्मसास्‍त्रम कराहना गुरुल्क येसुनगा जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","येसुना इच्‍चुर सिस्युल्कु यहुदि लोकुल्‍कुना रीति-रिवाज परकारम सुद्‍द आयाकोंटेन इत्‍ते, कय्‍क नोर्राकेने तिनानद ओर हूळतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","बारित्‍ते, परिसिल्क आनि यहुदिल्क अंटोर पेद्‍दाल्कुना रीति-रिवाज मत्‍ताप कय नोर्रका तिन्‍नुर. ");
INSERT INTO esg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","इंका ओर हाटुम होंचि वायना गानि एर तुंगाका तिन्‍नुर. अचोने आयका वाटिं, तालिं, रागिता बोळिं नोर्रमळ इसोंटव पेद्‍दाल्कुनाल ताकसेक वाता रीति-रिवाजकुन नोमंतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","अय्ते, “नीवा सिस्युल्क, पेद्‍दाल्कुना रीति-रिवाजुने बारि ताकुर, तिनाका मुन्‍ने ओर कय्‍क बारि नोर्रुर?” इंचि परिसिल्क आनि दर्मसास्‍त्रम कराहना गुरुल्क येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “यसायाह इनना पेनदा कबुरतोर, मीवसोंटा डोंगिरा बारेमते निजमे बविस्यवानि कीतोर: ‘ईर लोकुल्‍क सिराप तोळ्‍देने नावा कदर कींतुर, गानि ईरा मनसु मात्रम नहागटाल बच्‍चोनो लक्‍कु मनंता. ");
INSERT INTO esg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ईर अंगडमे नावा आरादना कीसेके मनांतुर. बारित्‍ते, ओराहाटीं मनकालोर तयार कीता रीति-रिवाजके निजमतव, अवुना पालन कियमळे दर्मम इंचि कराहंतुर,’ इल्‍हा रासि मंता. ");
INSERT INTO esg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","मिमेट पेन हीता आदेसतुन होळसि, मनकल तयार कीतव रीति-रिवाजकुन पीसि ताकसेक मंतिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","मर्रा ओरतोनि, “मीवा रीति-रिवाजकुन पीसि ताकानाहाटीं, पेनदा आदेसतुन लक्‍कु कियमळ मीक बेस अनपिच्‍चंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“निमे नीवा तल्‍लुर-बाबोना कदर कीम, बोर अय्ते तल्‍लुर-बाबोन रांगंतोर, ओन हव्कमळे गावाले,” इंचि मूसाल इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","गानि, “मिमेट अय्ते, बोरन्‍ना मनकल ओना तल्‍लुर-बाबोन, नना मीकु हियानद पेनदुक कोर्बान इंचि हीतन इनानय्ते, मिमेट ओन ओना तल्‍लुर-बाबोना सेवा किया हिय्यिर, इंचि कराहंतिर. ");
INSERT INTO esg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","इल्‍हा मिमेट तयार कीता, मीवा रीति-रिवाजकुनाहाटीं पेनदा पोल्‍लेतुन होळसेक मंतिर. इल्‍हा इंका बच्‍चुंगो कबाह्‍क कींतिर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","मरुंदि मल्का येसु लोकुल्‍कुन दग्गेर्क केय्‍सि, “मिमेट अंटोर नना वेहानद केंजट आनि अर्तम कीकुंटु,” इंचि वेहालय सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","“पलाताल मनकना पीटे होनानव ओन हेळ्‍हों, गानि मनकना तोळ्‍दाल पलाते पेय्‍सना पोल्‍लेंगे ओन हेळ्‍हंतां,” इंचि वेहतोर. बोर्कु केंजालय केव्क मंतां ओर केंजट. ");
INSERT INTO esg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","पजा येसु लोकुल्‍कुन होळसिसि, सतता लोन होत्‍तोर. अस्‍के ओना सिस्युल्कु ओर वेहता वेसुडिता अर्तम पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “पलाताल बतल अय्ते पीटे दांता, अद मनकन हेळ्‍हो इंचि मीकु इंकागुडा तेळियोना? ");
INSERT INTO esg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","पलाताल होनानद ओना मनसुने होन्‍नो गानि ओना पीटे दांता. पजा पलाते अर्रंता,” अल्हा वेह्‍चि, तिनानव अन्‍नि तिंडिं तिनालय बेसतवे इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","पजा ओर इल्‍हा वेहतोर, “मनकना लोप्पोटाल बतल अय्ते पलाते पेय्संता अदे मनकन हेळ्‍हंता. ");
INSERT INTO esg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","बारित्‍ते मनकना मनसुनाल कराब विचाराल्क, बोगमतनम, दोंगातनाल्‍क, हव्‍कमळ, व्यबिचारम, ");
INSERT INTO esg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","आस्‍ति कियमळ, दुस्‍ट गुनम, डोंगिगुनम, मेंदुलता आसे, कळ्‍क पोतमळ, अपमानम कियमळ, गर्रा आनि मुर्का गुनाल्‍क पलाते पेय्‍संतां. ");
INSERT INTO esg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","इव अन्‍नि सेड्‍डा पोल्‍लें मनकना तोळ्‍दाल पलाते पेय्सि, मनकन हेळ्‍हंतां,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","पजा येसु अगटाल तेदसि सूर, सिदोन एरियाते होत्‍तोर. अगा मनानद बोनके तेळिया मनि इनकुंचि, ओर उंदि लोन होंचि आगतोर. गानि मक्‍का पर्रा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","उंदि युनानि मुरतळ येसुना बारेमते केंजता. अद सिरिया देसेमता पोनिसिया इनना नाटे पुटतद आंदु. दाना सिन्‍ना मियाटुन देय्यम पीसि मत्‍ताहाटीं अद येसुनगा वासि, ओना काल्कुनपोर्रो अरता. अर्सि “देय्यमतुन पेच्‍हाचि गेदमा,” इंचि येसुन विनंति कीता. ");
INSERT INTO esg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","येसु अदुन, “पिलाल्क मोदाला पीरनिंडा तिनिरकांटी, पिलाल्कुना हारिं तेंडकुंचि नय्‍कुंक वाटमळ बेस आयो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","गानि आ मुरतळ, “निजमे सामि! पिलाल्क तिननेंके हिळु अरता अंटकुल्‍कुन अय्ते नय्‍के तिंतां गदा!” इंचि येसुंक जवाब हीता. ");
INSERT INTO esg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","अस्‍के, “निमे इल्‍हा इत्‍ताहाटीं, नीवा मिय्यटाल देय्यम पेय्सि होत्‍ता. निमे लोन होन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","अद मुरतळ लोन होंचि हूळतस्‍के, दाना मिय्यड कटुलते मींडसि मंता, दानाल देय्यमगुडा पेय्सि होत्‍ता इंचि अद हूळता. ");
INSERT INTO esg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","अद आता पजा येसु सूर एरियाताल मल्सि सिदोन होत्‍तोर. अगटाल देकापोलिस एरिया दाटसि गालिल समुद्रमतगा वातोर. ");
INSERT INTO esg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","अस्‍के इच्‍चुर लोकुल्‍क, वरोर पनकना-सेव्टि मनकन येसुनगा पीसि वासि, “नीवा कय ईना पोर्रो इर्रा,” इंचि विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","येसु आ पनकना-सेव्टि मनकन मंदिताल पक्‍कक ओसि, ओना केव्‍कुने सतता वेल्कु दोसतोर, आयंका आ वेल्कुना पोर्रो उस्किसि ओना नाल्केतुन इटतोर. ");
INSERT INTO esg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","मब्बुनहेके हूळसेक जोरसे नेस्किसि “एप्पता” इत्‍तोर. इत्‍ते कुल्‍ला आम इंचि अर्तम. ");
INSERT INTO esg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","अस्‍केने ओना केव्क केंजा वायालय दल्‍गतां, ओना नाल्केगुडा मेसलिसि ओर साप वळ्कालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","इद पोल्‍ले बोर्के वेहमट इंचि येसु ओर्कु गट्‍टिगा वेहतोर गानि लोकुल्‍कुंक ओर वेहतादानकन्‍ना एक्‍को वेहासेक होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","केंजता लोकुल्‍क अंटोर इचंत्रम आसि, “ओर बतलय्ते कीतोर, बेस कीतोर. सेव्टोर्कुन केंजा वायानाल, मूकालोर्कुन वळ्का वायानाल कींतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","अव रोजकुने मरुंदि मल्का येसुनगा वेल्‍लेन लोकुल्‍क जमा आतुर. ओरगा तिनालय बतले मनाहिल्‍ले. अदुनहाटीं येसु ओना सिस्युल्कुन दग्गेर्क केय्‍सि, ");
INSERT INTO esg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ईर लोकुल्‍क नहगा मूड रोजकुनाल मंतुर, ईरगा तिनालय बतल हिल्‍ले. अदुनहाटीं नाक ई लोकुल्‍कुन हूळसि पापम अनपिच्‍चंता. ");
INSERT INTO esg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","इच्‍चुर लोकुल्‍क वेल्‍ले लक्‍कुटाल वातोर मंतुर. ननागिंटा ईर्कुन कर्वुने लोन लोहानय्ते, नड्‍डुम हर्दे बगानना कूलाबडनुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","अस्‍के, “ई उस्‍के बूमिते इच्‍चो वेल्‍ले लोकुल्‍कुंक हालानाल तिंडि बगाटाल तरा परकोम?” इंचि सिस्युल्क येसुंक जवाब हीतुर. ");
INSERT INTO esg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","अस्‍के, “मिहगा बच्‍चुं हारिं मंतां?” इंचि येसु ओर्कुन पूसकीतस्‍के, ओर, “एडुं हारिं मंतां” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","पजा येसु मंदितुन हिळु बूमिपोर्रो उद्‍दा वेहतोर. आ एडुं हारिं पीसि पेनदुक दन्यवाद कीतोर. हारिन तुकडां कीसि, “ओर्क तूसि हीम्टु” इंचि सिस्युल्कुंक हीतोर. अस्‍के सिस्युल्कु मंदिकु तूसि हीतुर. ");
INSERT INTO esg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ओरगा इच्‍चुं सिन्‍ना जिम्मांगुडा मत्‍तां. येसु अवुनहाटींगुडा पेनदुक दन्यवाद कीसि “लोकुल्‍कुंक तूसि हीम्टु” इंचि सिस्युल्कुंक आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","अगा मत्‍तोर अंटोरगुडा पीरनिंडा तित्‍तुर. पजा मिगुल्ता हारि तुकडन जमा कीते, अव एडुं तट्‍टां निंडतां. ");
INSERT INTO esg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","अगा तित्‍तोरव्टे दग्‍गेरा-दग्‍गेरा नालुं वेय्‍कुना लोकुल्‍क मत्‍तुर. ओर अंटोर्कुन सार्ला कीसि, येसु बिराना ओना सिस्युल्कुनतोनि उंदि डोंगाते उद्‍दिसि दलमनुता एरियाक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","पजा येसुना पट्‍टु हूळना इंचि, “निमे पेनदा अदिकारम पीसि वातिन इंचि नम्‍मालय, स्वर्गमताल माकु उंदि चिन्‍ह हुप्‍सा,” इंचि परिसिल्क ओन पूसकियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","अस्‍के येसु आत्माते जोरते नेस्किसि, “इद पीळितोर चिन्‍ह हुप्‍सा इंचि बारि इंतुर? नना मीक निजम वेहंतन, इद पीळितोर्क बदे चिन्‍ह हुपिच्‍मळ जर्गो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","पजा ओर्कुन अग्गेन होळसि, डोंगाते उद्‍दिसि समुद्रमता हब्बेटा ओड्‍डुंक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","सिस्युल्कु हारिं ओयालय मरुंगतुर. आनि ओरगा डोंगाते उंदे हारि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","अस्‍के येसु ओर्कुन इल्‍हा जेगर्ता कीतोर. “परिसिल्क आनि हेरोदना पुल्‍लटा पिंडिता बारेमते जेगर्ता मंटु,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","अद केंजसि, “मनागा अय्ते हारिं हिल्‍लें,” इल्‍हा इंचेके सिस्युल्कु ओर-ओरे वळ्‍ककुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","येसु अदुन एरपाट कीसि, “हारिं हिल्‍लें इल्‍हा विचारम मिमेट बारि कीसेक मंतिट? इदवेरदाकागुडा मीकु तेळिया हिल्‍लेना? एरपाट कीसेक हिल्‍लिरा? मीवा मनसु बंडा आताना? ");
INSERT INTO esg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","मीक कळ्‍कु मंचिगुडा हूळा परसेक हिल्‍लिरा? केव्क मंचिगुडा केंजा परसेक हिल्‍लिरा? मिमेट मति मर्गतिरा? ");
INSERT INTO esg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","नना हेय्युं वेय्‍कुना मंदिहाटीं हेय्युं हारिं उराहचि दोसतन, अस्‍के बच्‍चुं तट्‍टाना हारिं मिमेट जमा कीसि निहतिर?” इंचि पूसकीतोर. अस्‍के, “पन्‍नेंड तट्‍टां” इंचि ओर जवाब हीतुर. ");
INSERT INTO esg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","आनि “अल्‍हेने, एडुं हारिनतोनि नालुं वेय्‍कुना मंदि तित्‍तस्के, बच्‍चुं तट्‍टाना हारि तुकडां जमा कीतिर?” इंचि येसु पूसकीतोर. अस्‍के, “एडुं तट्‍टां” इंचि ओर वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“अय्ते मीकु इंकागुडा तेळियसेक हिल्‍लेना?” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ओर बेतसेदा इनना नाटे एव्ता पजा इच्‍चुर लोकुल्‍क वरोर गुड्‍डिन येसुनगा पीसि वासि, “निमे ईन इट्‍टा,” इंचि विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","येसु आ गुड्‍डिना कय पीसि नाटेना पलाते ओतोर. ओसि गुड्‍डिना कळ्‍कुने उस्कतोर. पजा ओनपोर्रो कय इर्सि, “इंदके नीकु बतलन्‍ना दिस्सेक मंतना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","अस्‍के आ गुड्‍डि मनकल पोर्रो हूळसि, “मनकालोर दिस्सेक मंतुर गानि ओर मराकु ताकताप मागुर-मागुर दिस्सेक मंतुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","अस्‍के येसु मर्रा उंदि मल्का ओना कय्‍क, आ गुड्‍डिना कळ्‍कुना पोर्रो इरतोर. ओर उंदेतीर हूळता पजा नदर वाता. ओन्क अन्‍नि साप-साप दिसालय दल्‍गतां. ");
INSERT INTO esg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","अस्‍के, “निमे नाटे होळियाकोंटा, सवरगा नीवा लोन होन,” इंचि येसु ओन लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","येसु, ओना सिस्युल्क कैसरिया पिलिपि सहरता पकापीसि मत्‍ता नाह्कुने होत्‍तुर. होननेंके, “नना बोन आंदुन इंचि लोकुल्‍क इंतुर?” इंचि येसु सिस्युल्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","अस्‍के सिस्युल्क इल्‍हा वेहतुर. “इच्‍चुर इंतुर निमे बापतिस्मा हियना योहानुन आंदिन, इंका इच्‍चुर इंतुर निमे एलियाल आंदिन, इंका बोरो इंतुर निमे पेनदा कबुरतोरा लोप्पोटाल बोनो वरोन आंदिन,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“अय्ते, नना बोन आंदुन इंचि मिमेट इंचेके मंतिट?” इंचि येसु ओर्कुन पूसकीतस्‍के, “निमे किरिस्‍तुन आंदिन,” इंचि पत्रु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","अस्‍के, “नावा बारेमते बोर्के वेहमट,” इंचि येसु ओर्क गट्‍टिगा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","पजा ओना सिस्युल्कुंक इल्‍हा कराहलय दल्‍गतोर. “यहुदि पेद्‍दाल्क, पेद्‍दा पेर्मालोर आनि दर्मसास्‍त्रम कराहना गुरुल्कुनाहेंदाल मनकना रूपमते पुटतोन नाकु तिप्‍पल्‍क अर्रापींता. ओर हय्साकोंटा आसि नाकुन हव्कानुर. गानि नना हासि मूड रोजकुंक मर्रा जीवाते तेदंतन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","33","येसु इद पोल्‍लेतुन कुल्‍ला-कुल्‍ला वेहतोर. अय्ते पत्रु येसुन अलग ओसि रांगतोर. गानि येसु सिस्युल्कुनहेके तिरियसि हूळसि पत्रुन, “अरे देय्यम, नावा मुन्‍नेटाल पेय्सि होन. निमे मनकालोरा तेल्‍विते वळ्‍कसंतिन, पेनदा विचारमते वळ्कसेक हिल्‍लिन,” इंचि ओन रांगतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","पजा येसु ओना सिस्युल्कुन आनि लोकुल्‍कुन ओनहेके केय्‍सि इल्‍हा वेहालय दल्‍गतोर, “ओक्‍कला बोरन्‍ना मनकल नावा पज्जो वायना इत्‍ते, ओर ओना पूरा इस्‍टाल्क होळसिसि सतता क्रुस तेह्‍कुंचि नावा पज्जो वायिर. ");
INSERT INTO esg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","बारित्‍ते, बोर अय्ते ओना जीवातुन पिसागोटालय हूळंतोर, ओर ओना जीवातुन पोगोटकुंतोर. गानि बोर अय्ते नाहाटीं आनि बेसता कबुरताहाटीं जीवा हींतोर, ओर ओना जीवातुन कापाळकुंतोर. ");
INSERT INTO esg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ओक्‍कला मनकल पूरा दुनियातुन संपलिच्‍चि, ओना जीवातुन पोगोटकुत्‍ते ओन्क बता पायदा आंता? ");
INSERT INTO esg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","हिलाकोंटे मनकल ओना जीवाहाटीं बदला बतल हियानुर? ");
INSERT INTO esg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","बोगमतनमते, पापमते निंडिस मत्‍ता इद पीळितोर नड्‍डुम बोर अय्ते नाकुन, नावा पोल्‍लेन वेहालय सिग्गु अर्रंतोर, मनकना रूपमते पुटतोन नना बस्के अय्ते पवित्र दूतनतोनि, नावा बाबाना महिमाते वाकन, अस्‍के असोंटा मनकन नावोर इनालय ननागुडा सिग्गु अर्रंतन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","मर्रा येसु ओर्कुन इल्‍हा इत्‍तोर. “नना मीकु निजम वेहांतन, इग्‍गे नित्‍तिसि मनानोरा लोप्पोटाल इच्‍चुर इल्‍हा मंतुर गदा, पेनदा राज्येमतुन दाना ताकततोनि वातद हूळवा, ओर्कु हामुर वायो,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","हारुं रोजकु आतारित्‍ते येसु पत्रुन, याकोबुन आनि योहानुन पीकुंचि उंदि एत्‍तु गुट्‍टापोर्रो होत्‍तोर. अगा ओरा मुन्‍ने ओना रूपम मारिय्ता. ");
INSERT INTO esg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ओना कपडिं इच्‍चोर तेल्‍लगा मेर्सेक मत्‍तां गदा, बूमि पोर्रोटोर बोरे साकलल अच्‍चोर तेल्‍लगा आयनाल हुक्‍का पर्रोर. ");
INSERT INTO esg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अस्‍के मूसाल आनि एलियाल येसुनतोनि वळ्‍कानद ओर हूळतुर. ");
INSERT INTO esg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","हूळसि ओर इरगा वेरियतुर. अदुनहाटीं पत्रु येसुनतोनि बतल वळ्कना अद तेळियका, “गुरु! मनम इग्‍गे मनमळ बेस मंता. उंदि नीहाटीं, उंदि एलियानाहाटीं, उंदि मूसानाहाटीं मोमोट मूड गूळसें वाटंतोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","अस्‍केने उंदि मब्बु तेर्पे वासि ओर्कुन मुच्‍ता. आ मब्बुनाल, “ईर नावा पावरमगल्‍ला मर्रि आंदुर, ईना पोल्‍लें केंजट,” इंचि ओर्क अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","अस्‍के अचानक ओर नालुं-मूलां हूळतुर गानि येसुंक तप्‍पा अगा बोरे दिसा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ओर गुट्‍टा पोर्रोटाल हिळु रेय्‍नेंके, “मनकना रूपमते पुटतोन नना हामुरताल मर्रा तेदनदाका, गुट्‍टापोर्रो मिमेट बतल अय्ते हूळतिरो अद बोर्के वेहमट,” इंचि येसु ओर्क गट्‍टिगा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ओर अद पोल्‍लेतुन ओरा मनसुनेन इरतुर गानि “हातोरा लोप्पोटाल मर्रा जीवाते तेदमळ, इत्‍ते बतल?” इंचि ओर वरोंक-वरोर वळ्ककुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","पजा ओर येसुन, “किरिस्‍तुंकन्‍ना मुन्‍ने, एलियाले वायमळ गावाले इंचि दर्मसास्‍त्रम कराहना गुरुल्क बारि इंतुर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","अस्‍के येसु ओर्क इल्‍हा वेहतोर. “एलियाल तप्‍पाकोंटा मोदाला वांतोर. वासि मोदाला बल्हा मत्‍ता अल्हे अन्‍निन कींतोर. गानि मनकना रूपमते पुटतोन नाकु वेल्‍ले तकलिप बोगांचा पींता, नाकुन हय्सुर इंचि दर्मसास्‍त्रमते बारि रासि मंता? ");
INSERT INTO esg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","गानि नना मीकु वेहानद बतल इत्‍ते, एलियाल वासे मंतोर. ओना बारेमते दर्मसास्‍त्रमते बल्हा रासि मंता, अल्‍हेने लोकुल्‍क ओरा मनसुंक वाताप ओनतोनि कीतुर,” इंचि येसु ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","पजा येसु आनि सिस्युल्क, हिळु मत्‍ता सिस्युल्कुनगा वासि हूळतस्‍के, ओरा सुट्‍टु वेल्‍लेन लोकुल्‍क जमा आसि मत्‍तुर. आनि दर्मसास्‍त्रम कराहना गुरुल्क ओरतोनि लोल्‍लि कीसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","अगा मत्‍ता लोकुल्‍क येसुन हूळसि इचंत्रमते अरतुर, पजा अंटोरगुडा बिराना विच्‍चि होंचि ओन्क जोहार कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","अस्‍के येसु, “मिमेट ईरतोनि बारि वदुरकुंचेक मंतिट?” इंचि दर्मसास्‍त्रम कराहना गुरुल्‍कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","अस्‍के आ मंदिताल बोरो वरोर येसुन, “गुरु, ना मर्रिंक मूका-देय्यम पीता, ओन निहगा पीसि तत्‍तन. ");
INSERT INTO esg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","देय्यम ओन बस्के अय्ते पींता, अस्‍के ओन अग्गेन हिळु हुक्‍कंता. ओना तोळ्‍दाल पोंगुर पेय्संता. ओर कर्रा-कर्रा पल्कु कोर्कसेके अल्‍हेने गट्‍टिगा आंतोर. इद देय्यमतुन ओना लोप्पोटाल गेदमट इंचि नीवा सिस्युल्कुंक वेहतन गानि ओरतोनि आया पर्राहिल्‍ले,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","अस्‍के येसु ओर्कुन, “अरे विस्वासम तक्‍को पीळितोरिटा! नना बदवेरदाका मीतोनि मनकन? बदवेरदाका नना मीकुन सहन कीकन? ओन नाहेके पीसि वट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ओर आ पेडन येसुनगा पीसि वातुर. देय्यम येसुन हूळता-हूळुळे, पेडन तेल्हाचि हिळु अरहता. आ पेडल तोळ्‍दाल पोंगुर पेचाहसेके पोर्लालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","अस्‍के, “नी मर्रिंक इल्‍हा बस्केटाल आसेक मंता?” इंचि येसु पेडाना बाबोन पूसकीतोर. अय्ते ओर, “सिन्‍नस्केटाले इल्‍हा आसेक मंता. बच्‍चुंगो मल्कां तळमिते अरहचि, एते अरहचि हव्कालय हूळता गानि निमे मापोर्रो दया वासि, माहाटीं बतलन्‍ना सहायम कियापर्ते कीम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","येसु ओन, “कियापर्ते कीम, इत्‍ते बतल इत्‍ताप? पेनदापोर्रो विस्वासम कियानोर्क अन्‍नि आया परांतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","अस्‍केने पेडाना बाबल कांडेर तेंडसेके, “नना विस्वासम कींतन सामि, नावा विस्वासम गट्‍टिगा आयालय सहायम कीम” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","वेल्‍लेटुर लोकुल्‍क विच्‍चि वासि गर्दि कियानद हूळसि येसु आ देय्यमतुन, “सेव्टि-मूका देय्यमतुना, नना नीकु हुकुम हींतन, ईनगटाल पलाते पेय्‍सा, ईन मर्रा बस्‍केने पिय्मा,” इंचि गदरिचतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","अस्‍के आ देय्यम ओन जोरसे तेल्हाचि, वरगेय्‍सि आ पेडाना लोप्पोटाल पेय्सि होत्‍ता. अस्‍के पेडल हातोनलेसीं आतोर. वेल्‍लेटुर लोकुल्‍क ओन हातोर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","गानि येसु ओना कय पीसि तेहातस्‍के ओर तेदसि निल्तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","पजा येसु लोन होतस्के बोरे हिल्‍वद हूळसि सिस्युल्क येसुनगा वासि, “आ देय्यमतुन मोमोट बारि गेदमा पर्रा हिल्‍लोम,” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","येसु ओर्कुन, “इसोंटा देय्यमतुन सिराप पारतनातोने गेदमा परांतोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","पजा ओर अगटाल पेय्सि गालिल राज्येमताल होंचेक मत्‍तुर. ओर होनानद बोर्कन्‍ना तेळियमळ येसुंक इस्‍टम मनाहिल्‍ले. बारित्‍ते येसु ओना सिस्युल्कुंक, “मनकना रूपमते पुटतोन नाकुन, वरोर दोकाते पीसि, लोकुल्‍कुना कय्‍दे हींतोर. ओर नाकुन हव्कानुर गानि, मूड रोजकु आतंका नना मर्रा जीवाते तेदंतन,” इंचि कराहचेके मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","गानि येसु वेहता पोल्‍ले ओर्क तेळिया हिल्‍ले. आनि ओन पूस कियालयगुडा ओर वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ओर कपर्नाहुमते एवसि उंदि लोते मत्‍तस्के, “हर्रि पीसि वायानेंके मिमेट बतल वळ्कसेक वातिट?” इंचि येसु सिस्युल्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","गानि “अंटोर्कन्‍ना पेद्‍दा बोर?” इंचि ओर वरोंक वरोर वळ्कसेक वातुर. अदुनहाटीं ओर चुपचाप मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","अस्‍के येसु उद्‍दिसि ओना पन्‍नेंड सिस्युल्कुन केय्‍सि ओर्कुन इल्‍हा इत्‍तोर. “बोर अय्ते पेद्‍दा आंतन इनकुंतोरो, ओर अंटोर्कन्‍ना सिन्‍नोड आसि अंटोरा सेवा कियानोर आयापींता,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","वेह्‍चि, वरोर सिन्‍ना पेडन ओरा नड्‍डुम निलाहतोर. पजा ओन दग्‍गेरा पीकुंचि ओर्कुन इल्‍हा इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“बोर अय्ते ई सिन्‍ना पेडनलेसीं आसि मनानोन नावा पोरोलते ओप्कुंतुरो, ओर नाकुनगुडा ओप्‍कुंतुर. बोर अय्ते नाकुन ओप्‍कुंतुर ओर सिराप नाकुने आयो गानि नाकुन लोहतोनगुडा ओप्‍कुंतुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","अस्‍के योहान येसुन, “गुरु! वरोर मनकल नीवा पोरोलते देय्याल्कुन पेचाहनेंके मोमोट हूळतोम, मालेसीं ओर नी पज्जो ताकानोर आयोर. अदुनहाटीं अल्हा कियमा इंचि मोमोट ओन आपतोम,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","अस्‍के येसु ओन इल्‍हा इत्‍तोर. “बोर अय्ते ना पोरोलते अद्‍बूतामाता कबाह्‍क कींतोरो, ओर नावा विरोदमते बिराना कराब वळ्का पर्रोर, अदुनहाटीं ओन आपमट. ");
INSERT INTO esg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","बारित्‍ते बोर अय्ते मनाकु विरोदमते हिल्‍लोर, ओर मना बाजुनोरे. ");
INSERT INTO esg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","नना मीक निजम वेहांतन, मिमेट किरिस्‍तुना सिस्युल्क इंचि मीक बोरन्‍ना गिलासमेड एर उनालय हियानय्ते, ओन्क तप्‍पाकोंटा इनाम दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","नापोर्रो विस्वासम कियना ई सिन्‍ना पेडानसंटोन बोरन्‍ना पापमते अरहते, ओना बोंळगेक जोत्‍ता बंडा दोहचि समुद्रमते दोब्‍बुतेने बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","ओक्‍कला नीवा कय नीकुन पापम किया वेहते, दान नर्किसि पोहा. बारित्‍ते रोंडु कय्‍क मंचि बस्‍केने पिर्रकोंटा बगाबगा पोत्‍तना तडमि मनना नरकमते होननदानकन्‍ना, तोंटि कय आसि पिस्वरते होनमळे नीहाटीं बेस. ");
INSERT INTO esg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","अल्‍हेने, ओक्‍कला नीवा काल नीकुन पापम किया वेहते, दान नर्किसि पोहा. बारित्‍ते रोंडु काल्क मंचि नरकमते होननदानकन्‍ना, कूटाल आसि पिस्वरते होनमळे नीहाटीं बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","अल्‍हेने, ओक्‍कला नीवा कळु नीकुन पापम किया वेहते, दान तेंडसि पोहा. बारित्‍ते रोंडु कळ्‍कु मंचि नरकमते होननदानकन्‍ना, उंदि कळ्‍दे पेनदा राज्येमते होनमळे नीहाटीं बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","बारित्‍ते हरेक मनकन तळमितोनि होव्वोरलेसीं कियमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","होव्वोर बेसे मनंता गानि होव्वोर, होव्वोरलेसीं रुसि वायाकोंटे अव्टे मर्रा बल्हा होव्वोर रुसि तरा परांतोम? अल्‍हेने मिमेटगुडा होव्वोर रुसिते बेस वरोंक-वरोर कलियसि-मेलियसि सांतिते मंदना,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","पजा येसु अगटाल पेय्सि योर्दन बेरेड दाट्‍सि यहुदिया एरियाते होत्‍तोर. अगागुडा लोकुल्‍क मंदानां मंदां ओनगा जमा आयालय दल्‍गतुर. अस्‍के येसु ओना अलवट परकारम ओर्क कराहलय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","अगा इच्‍चुर परिसिल्कगुडा वातुर. वासि येसुना पट्‍टु हूळानाहाटीं ओन इल्‍हा पूसकीतुर. “नियम परकारम, वरोर मनकल ओना मुत्‍तोन होळसिय्या वच्‍चा?” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","अस्‍के येसु ओर्कुन, “मूसाल मीक बद आदेस हीतोर?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","अय्ते, “वरोर मनकल सोडसिट्‍टि हीसि, मुत्‍तोन होळसियना इंचि मूसाना आदेस मंता,” इंचि ओर येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “मीवा मनसु बंडालेसीं मत्‍ताहाटीं मूसाल ई आदेसतुन मीकु रासतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","गानि बस्के अय्ते पेन ई दुनियातुन कीतानो, अस्‍केन ओर्कुन मांड्‍सा मुरतळ इल्‍हा इंचि कीता. ");
INSERT INTO esg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","अदुनहाटींगे मांडसा ओना यावन-बाबन होळसिसि, ओना मुत्‍तोनतोनि कलियसि मनंतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ओर इव्वुर उंदे मेंदुल आसि मनांतुर. ओर वेरे-वेरे आयुर गानि उंदे मेंदुल आंतुर. ");
INSERT INTO esg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","इल्‍हा पेने ओर्कुन कल्‍पताहाटीं मनकल वेरे कियानायो,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","पजा, येसु लोन मत्‍तस्के इदुना बारेमते सिस्युल्कु मर्रा उंदि मल्का ओन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","अस्‍के येसु ओर्कु इल्‍हा वेहतोर, “बोरन्‍ना ओना मुत्‍तोन बोगमतनम कारनम तप्‍पा वेरे कारनमते होळसिसि इंकुंदानतोनि मरमिं आयानय्ते, ओर मोदाटा मुत्‍तोना विरोदमते बोगमतनम कीताप आंतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अल्‍हेने ओक्‍कला मुत्‍तो दाना मुय्दोन होळसिसि इंकावरोनतोनि मरमिं आयानय्ते, अद बोगमतनम कीतद आंता.” ");
INSERT INTO esg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","उंदि रोज लोकुल्‍क ओरा पिलाल्कुनपोर्रो येसु कय इर्सि आसिर्वाद हियना इंचि ओनगा पीसि वातुर, गानि सिस्युल्क ओर्कुन रांगतुर. ");
INSERT INTO esg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","गानि येसु ओर रांगानद हूळसि ओर्कुन इल्‍हा इत्‍तोर. “पिलाल्कुन नाहेके वायाहीम्ट, ओर्कुन आपमट. पेनदा राज्येम इसंटोरदे आंद, ");
INSERT INTO esg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","नना मीक निजम वेहंतन, बोरे आयिर पेनदा राज्येमतुन सिन्‍ना पिलाल्कुनालेसीं आसि स्विकार किय्युर, ओर पेनदा राज्येमते बस्‍केने होळिया पर्रुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","पजा आ पिलाल्कुन एत्‍कुंचि, ओरा तल्‍लापोर्रो कय इर्सि आसिर्वाद हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","येसु अगटाल पेय्सि हर्रि पीसि होननेंके, वरोर मनकल विच्‍चि वासि काल्कुनपोर्रो अर्सि, “गुरु, निमे बेसतोन आंदिन. बस्‍केळ्‍क पिस्सना पिस्वरता वारसदार आयानाहाटीं नना बतल कीते बेस?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","अस्‍के येसु ओन इल्‍हा इत्‍तोर, “नाकुन बारि बेसतोर इंतिन? बोरे बेसतोर आयोर, सिराप पेन उंदे बेसतद आंद. ");
INSERT INTO esg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","नीकु पेनदा आदेसकु अय्ते एरपाटे मंतां: बोने हव्‍कुमा, बोगमतनम कियमा, दोंगातनम कियमा, आबद्‍दम गवाइ हियमा, इंकावरोन पसांचमा, नीवा तल्‍लुर-बाबोना कदर कीम,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","अस्‍के, “गुरु, नना अय्ते इवन्‍नि सिन्‍नास्केटाल कीसेकेन वातन,” इंचि ओर येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","येसु ओनहेके हूळतोर. पावरम अनपिच्‍चि, ओन इल्‍हा इत्‍तोर. “निहगा उंदि पोल्‍ले तक्‍को मंता. होन, निहगा बतल अय्ते मंता अदुन पूरा अम्मिसि, गरिबोर्कुंक तूसि हीम. अस्‍के नीकु स्वर्गमते दनम दोर्कार, पजा नहगा वासि ना पज्जो ताका,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ओनगा सोम्मु वेल्‍लेन मत्‍ताहाटीं, येसुना पोल्‍ले केंजसि ओना मोकम सिम्मरा आता. पजा दुक्‍कमते अगटाल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","अस्‍के येसु नालुं-मूलां हूळसि सिस्युल्कुन इल्‍हा इत्‍तोर. “सिरमंतुल्‍क पेनदा राज्येमते होळियमळ इत्‍ते वेल्‍लेन कस्‍टम!” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","ओना पोल्‍लें केंजसि सिस्युल्क इचंत्रम आतुर. गानि येसु मरुंदि मल्का सिस्युल्कुन इल्‍हा इत्‍तोर, “पिलाल्‍कुनिटा! वरोर सिरमंत मनकल पेनदा राज्येमते होळियमळकन्‍ना लोटापेटा सूदि बोंगाताल होनमळ अल्कगा मनंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","इद केंजसि सिस्युल्कुंक वेल्‍लेन इचंत्रम आता. अस्‍के ओर-ओरे, “अल्हा अय्ते मुक्‍ति बोर्क दोर्का पर्रंता?” इंचि वळकालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","अस्‍के येसु ओराहेके हूळसि, “मनकालोरतोनि अय्ते इद आयापर्रो गानि पेनतोनि आंता. बारित्‍ते पेन अन्‍नि किया पर्रंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","अस्‍के पत्रु, “हूळा, मोमोट अय्ते मत्‍तद-हिलवद अन्‍नि होळसिसि नीवा पज्जो वातोम,” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","येसु ओन, “नना निजम वेहांतन. बोरे आयिर नावाहाटीं, बेसता कबुरताहाटीं ओना लोन दारातुन, तम्मुह्‍क-दादालोर्कुन, अक्‍कल-हेलाह्कुन, तल्‍लुर-बाबोन, पिलाल्कुन, बूमि-जेगातुन होळसीतोर. ओन्क इंदकेने नूर अंताल्‍क एक्‍को लोन दारा, तम्मुह्‍क-दादालोर्क, अक्‍कल-हेलाह्क, तल्‍लुह्‍क, पिलाल्क, बूमि-जेगा दोर्कार. ओन्क कस्‍टाल्‍क वायानुं गानि वायाना कालमते ओन्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कका मन्‍नो. ");
INSERT INTO esg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","गानि मुन्‍ने मत्‍तोर वेल्‍लेटुर पज्जो आयानुर, पज्‍जोटोर मुन्‍ने आयानुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","34","येसु आनि ओनतोनि मत्‍तोर येरुसलेमतेके होंचेके मत्‍तुर. येसु अंटोर्कन्‍ना मुन्‍ने मत्‍तोर. ओना सिस्युल्क इचंत्रमते मत्‍तुर, ओना पज्जो ताकानुर वेर्रेते मत्‍तुर. अस्‍के येसु ओना पन्‍नेंड सिस्युल्कुन बाजुंक ओसि, “हुळाट, मनम येरुसलेम होंचंतोम, अगा होत्‍ता पजा मनकना रूपमते पुटतोन नाकुन पेद्‍दा पेर्मालोर्कुना आनि दर्मसास्‍त्रम कराहना गुरुल्कुना कय्‍दे पीसि हियानुर. ओर नाकु हामुर सिक्‍साता आदेस हीसि, यहुदि आयवोरा कय्‍दे अप्‍पजेपनुर. अस्‍के ओर नाकुन सिडांचनुर, नापोर्रो उस्कानुर, पोट्‍टेते तन्‍नानुर, हव्कानुर. गानि मूड रोजकुंक नना मर्रा जीवाते तेदंतन,” इंचि मुन्‍ने जर्गना बारेमते सिस्युल्कुंक मर्रा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","पजा जब्‍दिना मर्क याकोब आनि योहान येसुनगा वासि, “गुरु, मोमोट बतल अय्ते तल्‍कंतोम अदुन माहाटीं निमे कियमळ गावाले इंचि मा मनसु मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","येसु ओर्कुन इल्‍हा इत्‍तोर. “मीहाटीं नना बतल कियाना इंचि मीवा मनसु मंता,” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","अस्‍के ओर, “निमे नीवा महिमाते राज्येम कियनेंके नीवा तिना बाजुंक वरोन, डेमा बाजुंक वरोन उद्‍दाहीम,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","गानि येसु ओर्कुन, “मिमेट बतल पूसकीसंतिरो अद मीक तेळियसेक हिल्‍ले. नना बव कस्‍टाल्‍क अय्ते बोगांचना मंता, अवुन मिमेट बोगांचा परकिटा? हिलाकोंटे नना बद बापतिस्मा एतंतनो, अद मिमेट एता परकिटा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","अस्‍के “हो, मोमोट तयार मंतोम,” इंचि ओर इत्‍तुर. अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “नना कस्‍टाल्‍क बोगांचताप मिमेट बोगांचा परकिट आनि नना एताना बापतिस्मा मिमेटगुडा एता परकिट. ");
INSERT INTO esg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","गानि नावा तिना बाजुंक आनि नावा डेमा बाजुंक उपिच्‍चना अदिकार नाक हिल्‍ले. अव जेगां बोराहाटीं अय्ते तयार कीसि मंतांगो, ओरे अगा उद्‍दंतुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ओर इत्‍ता पोल्‍लें केंजसि, अगा मत्‍ता कळमता पदि मंदि सिस्युल्क, याकोब, योहानुना पोर्रो होंग आतुर. ");
INSERT INTO esg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","अस्‍के येसु सिस्युल्कुन ओना दग्‍गेरा केय्‍सि, “यहुदि आयवोरा राजालोर ओरा जीतागाह्कुन, ओरा कय्‍दा हिळु इर्रालय हूळंतुर, अल्‍हेने ई दुनियाता पेद्‍दा मनकालोरगुडा सिन्‍ना मनकालोरपोर्रो अदिकारम ताकसालय हूळंतुर, इद मीकु एर्के. ");
INSERT INTO esg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","गानि मिमेट मात्रम ओरालेसीं कियानायो. मी लोप्पोटाल बोर अय्ते पेद्‍दा आयालय हूळांतोरो, ओर मीवा सेवा कियानोर आयापींता. ");
INSERT INTO esg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","अल्‍हेने मी लोप्पोटाल बोर अय्ते लीडर आंतन इंतोरो, ओर मीवा दासुड आयापींता. ");
INSERT INTO esg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","बारित्‍ते मनकना रूपमते पुटतोन नना सेवा कियागोटकुनालय वाया हिल्‍लेन गानि वेरेतोरा सेवा कियालय आनि वेल्‍लेटोर्कुन पापमताल पेचाहलय ओराहाटीं नावा जीवा हियालय वातन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","पजा येसु, ओना सिस्युल्कु यरिहो सहरते एव्‍तुर. अगटाल मर्रा पेय्सनेंके लोकुल्‍कुना पेद्‍दा मंदा ओरतोनि पेय्सता. तिमाउसना मर्रि बरतलमय इनानोर गुड्‍डि बिच्‍चागाड हर्दा पक्‍काते उद्‍दिसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","नासरेत सहरता येसु इगेटाल होंचेके मंतोर इंचि ओन्क तेळियतस्के ओर, “येसु, दाविद राजाना वंसमतोना! नापोर्रो दया कीम,” इंचि जोरसे वरगेयतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","अस्‍के वेल्‍लेटुर लोकुल्‍क ओन, “चुपचाप मन” इंचि रांगतुर, गानि, “दाविद राजाना वंसमतोना, नापोर्रो दया कीम,” इंचि ओर जोरसे मोत्‍कुनालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","अस्‍के येसु आगसि, “ओन केयट,” इंचि इत्‍तोर. अस्‍के ओर आ गुड्‍डिन केय्‍सि, “दैरनेम इर्रा, येसु नीकुन केयसंतोर तेदा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","अस्‍के ओर मुच्‍कुंचि मत्‍ता कप्‍पिडतुन तेंडसि पोहचि बिराना तेदसि येसुनगा वातोर. ");
INSERT INTO esg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","अस्‍के येसु ओन, “नना नीहाटीं बतल कियना इंचि नी मनसु मंता?” इंचि पूसकीतोर. अस्‍के, “गुरु, नावा कळ्‍कुना नदर दिस्‍सानाल कीम,” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","अय्ते येसु, “निमे होन, नीवा विस्वासमे नीकुन बेस कीता,” इंचि इत्‍तोर. अल्हा इत्‍ता इनुडे ओना कळ्‍कुंक नदर वासि ओरगुडा येसुना पज्जो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","पजा ओर अंटोर येरुसलेम सहरता दग्‍गेरा जय्‍तुन मराकुना गुट्‍टापोर्रो मनना बैतपागे आनि बेतानिया इनना नाह्‍कुना दग्‍गेरा एव्‍तुर. पजा येसु ओना इव्वुर सिस्युल्कुन केय्‍सि, ");
INSERT INTO esg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ओर्क इल्‍हा वेह्‍चि नाटे लोहतोर. “मी मुन्‍ने दिस्‍सना नाटे होंट. अद नाटे होळियता होळयुळे, बस्‍केने बोरे उद्‍दुवद उंदि गाडदि पोरि दोह्‍चि मत्‍तद मीकु दिसंता, दान लेहकुंचि पीसि वटु. ");
INSERT INTO esg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ओक्‍कला अदुन पीसि वायनेंके, इल्‍हा बारि कीसंतिर? इंचि बोरन्‍ना पूसकीते, सामिंक दीना अव्‍सरम मंता इंचि वेहट. अस्‍के ओर बिराना अदुन इग्‍गे लोहानुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","येसु वेहताप ओर अद नाटे होत्‍तुर. अगा हर्दा पक्‍काते उंदि लोता तल्‍पुना दग्‍गेरा गाडदि पोरि दोहचि मत्‍तद ओर्क दिसता. अस्‍के अदुन लेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","अगा नित्‍तिसि मत्‍तुर इच्‍चुर लोकुल्‍क हूळसि, “मिमेट बतल कीसंतिर? गाडदि पोरिन बारि लेहसंतिर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ओर येसु वेहतापे ओर्क वेहतस्के, आ लोकुल्‍क ओर्कुन होना हीतुर. ");
INSERT INTO esg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ओर अद गाडदि पोरिन येसुनगा तच्‍चि, दानपोर्रो ओरा कपडिं वाटतुर. अस्‍के येसु दानपोर्रो उद्तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","वेल्‍लेटुर लोकुल्‍क ओर केर्ता कपडिं तेंडसि, येसु होनना हर्दे तारतुर. इंकिच्‍चुर लोकुल्‍क अय्ते नेलिने मत्‍ता मराकुना कोम्मां नर्किसि हर्दे तारतुर. ");
INSERT INTO esg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","येसुना पज्जो-मुन्‍ने ताकाना लोकुल्‍क वरगेयसेके इल्‍हा इनुंदुर, “सामिना पोरोलते वायानोंक, पेनदा आसिर्वाद दोर्किकाटीं, होसन्‍ना! होसन्‍ना! दाविदनालेसीं राज्येम कियालय वायानोंक, पेनदा आसिर्वाद दोर्किकाटीं, स्वर्गमते मंदना पेनदुक दन्यवाद,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","इल्‍हा येसु येरुसलेम सहरते होळियतोर. पजा गुळितगा होंचि, सुट्‍टु अन्‍नि वस्‍तुकुन तिरियसि हूळतोर. पोळ्‍दु होत्‍ता इंचि ओना पन्‍नेंड सिस्युल्कुन पीसि बेतानिया नाटे होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","इंकुंदि रोजु येसु बेतानिया नाटेनाल वायनेंके ओन्क कर्वेस्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","हरदाल इच्‍चुर लक्‍कु उंदि पच्‍चटा अंजिर मरातुन हूळसि, दानकु पंडिं मंतां बारे इंचि आ मरातगा होत्‍तोर. गानि आ मराकु आकिं तप्‍पा बतांगे मनाहिल्‍लें. बारित्‍ते अद पंडिं हादाना वेला आयो. ");
INSERT INTO esg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","अस्‍के येसु अद मरातुन, “इंदकेटाल नीवा पंडिं बस्‍केने बोरे तिन्‍नुर,” इंचि इत्‍तोर. अद पोल्‍लेतुन ओना सिस्युल्कु केंजतुर. ");
INSERT INTO esg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ओर येरुसलेम एव्ता पजा येसु गुळिते होत्‍तोर. अगा गुळिते बोर अय्ते अम्मुमळ-अस्सुड कीसेक मत्‍तुर, ओर्कुन पलाते गेदुमतोर. अल्‍हेने कोत्‍तां अदला-बदला कियानोरा बल्‍लन आनि मोक्‍कु हियालय पावरेम पिट्‍टें अम्मानोर्कुना कुर्सिन मिळ्‍हाचि वाटतोर. ");
INSERT INTO esg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अल्हा कीसि गुळिताल बोने बदे वस्तु पीसि होनुळ-वायुळ किया हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","पजा ओर्क इल्‍हा वेहालय दल्‍गतोर. “नावा लोतुन दुनियाता अंटोर लोकुल्‍क पारतना कियाना जेगा इनानुर, इंचि दर्मसास्‍त्रमते रासि हिल्‍लेना? गानि मिमेट दीन दोंगाल्क मक्‍कना जेगा कीतिर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","इल्‍हा अंटोर लोकुल्‍क येसु वेहाना पोल्‍लें केंजसि इचंत्रम आयुंदुर. अदुनहाटीं पेर्मालोर, दर्मसास्‍त्रम कराहना गुरुल्क येसुन हव्कालय हूळुंदुर. गानि ओन अल्हा बतलन्‍ना कियालय ओर वेरियुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","पजा येसु, ओना सिस्युल्कु पोळ्‍दु होत्‍तारिते येरुसलेमताल पेय्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","इंकुंदि रोजु हक्‍केरेने मर्रा येरुसलेमतेके वायानेंके ओर अद अंजिर मरातुन हूळतुर, अस्‍के अद मरा हिह्कुनाल अय्ते कोस्‍सादाका पूरा वतसि होंचि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","येसु अद मरातुन इत्‍ता पोल्‍ले पत्रुंक मति वाता. अस्‍के ओर येसुन, “अद हूळा गुरु! निमे सापनेम हीता अंजिर मरा वतसि होत्‍ता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","अस्‍के येसु ओर्कु इल्‍हा जवाब हीतोर. “मिमेट पेनदापोर्रो विस्वासम इर्राट. नना मीकु निजम वेहांतन, बोरन्‍ना इद गुट्‍टातुन, ‘इग्‍गेटाल तेदसि समुद्रमते होंचि अर्रा’ इंचि बतले अनमानम हिलाकोंटा विस्वासमते इनानय्ते, अद होंचि अर्रार. ");
INSERT INTO esg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","अदुनहाटीं नना मीकु वेहांतन, मिमेट विस्वासमतोनि पारतनाते बतल तल्‍किना, अद मीकु दोर्कता इंचि विस्वासम कीम्‍टु, अस्‍के अद मीवादे आंता. ");
INSERT INTO esg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","अल्‍हेने मीवा मनसुनेगिंटा बोना पोर्रोनना पगा मत्‍ते, मिमेट पारतना कियालय निततस्के मुन्‍ने ओन मापि कीम्‍टु. अस्‍के स्वर्गमते मंदना पेनबाबालगुडा मीवा तप्‍पुकुन मापि कींतोर. ");
INSERT INTO esg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","मिमेटगिंटा इंकावरोना तप्‍पुकुन मापि कियाकोंटे, स्वर्गमते मंदना पेनबाबालगुडा मीवा तप्‍पुकुन मापि किय्योर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ओर येरुसलेम सहरते मर्रा वातस्के, येसु गुळिते तिरियसेक मत्‍तोर. अस्‍के पेर्मालोर, दर्मसास्‍त्रम कराहना गुरुल्क आनि यहुदि पेद्‍दाल्क येसुनगा वातुर. वासि, ");
INSERT INTO esg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“निमे ई कबाह्‍क बद अदिकारमते कीसंतिन? नीकु ई कबाह्‍क कियालय अदिकारम बोर हीतोर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","अस्‍के येसु ओर्कुन इत्‍तोर. “ननागुडा मीकुन उंदि सवाल पूसकींतन. मिमेट जवाब हियानय्ते, नना बद अदिकारमते इव कबाह्‍क कीसंतन इत्‍तद वेहंतन. ");
INSERT INTO esg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","अय्ते जवाब हीम्टु, योहानुंक बापतिस्मा हियाना अदिकारम बगाटाल दोर्कता? स्वर्गमताला हिलाकोंटे मनकालोराहेंदाल दोर्कतना?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","अस्‍के, ओर-ओरे इल्‍हा वळ्ककुनालय दल्‍गतुर, “ओक्‍कला स्वर्गमताल दोर्कता इंचि मनम इनानय्ते, ‘मिमेट योहानुन बारि नम्मिर’ इंचि इनानुर. ओक्‍कला मनम मनकालोराहेंदाल दोर्कता इनानय्ते, लोकुल्‍कुना वेर्रे! बारित्‍ते योहान निजमे पेनदा कबुरतोर इंचि ओर नम्मंतुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","अदुनहाटीं ओर, “माक एर्का हिल्‍ले,” इंचि इत्‍तुर. अस्‍के, “अल्हा अय्ते, इव कबाह्‍क बद अदिकारमते कीसंतनो ननागुडा मीकु वेहोन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","अस्‍के येसु ओर्कु उंदि वेसुडि वेहमळ सुरुव कीतोर, “वरोर मनकल अंगुर तोटा कीतोर. आ तोटा सुट्‍टु गूरे दोहाचि तोटाता लोप्पेन अंगुर पंडिना पानकम तेंडालय उंदि पोक्‍का तव्‍सि, दाना दग्गेरेने कावेलहाटीं उंदि मंडा वाटतोर. पजा तोटातुन वेरेतोर्क बटाइक हीसि, वेरे देसेम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","पजा बस्के अय्ते अंगुर पंडिं कोय्याना वेला वाता, अस्‍के ओरागटाल पंडिना तूस एतालय ओना वरोर दासुन बटाइतोरहेके लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","गानि बटाइतोर आ दासुन पीसि पक्‍का तंचि, उत्‍ता कय्‍के वापस लोहतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","पजा मालक इंकावरोन दासुन बटाइतोरहेके लोहतोर. आ बटाइतोर ओना तल्‍ला पयाहचि ओन कदर हिलाकोंटा कीसि लोहतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","मालक मर्रा इंकावरोन दासुन ओरहेके लोहतोर, ओर ओन हव्कतुर. अस्‍के मालक इल्‍हा इंका वेल्‍लेन दासुल्‍कुन लोहतोर. गानि बटाइतोर इच्‍चुर्कुन तंतुर, इच्‍चुर्कुन बारे हव्कतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","आकिरते मालकनगा ओना पावरमगल्‍ला मर्रि वरोरे मिगिल्सि मत्‍तोर. अस्‍के मालक, ‘नावा मर्रिन बेस कदर कियानुर’ इनकुंचि ओरहेके लोहतोर. ");
INSERT INTO esg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","गानि बटाइतोर ओर वायानद हूळसि, ‘ईर अय्ते वारसदार आंदुर. दट ओन मनम हव्ककोम, अस्‍के ओना जाय्‍दाद मनाक आयार,’ इंचि वरोंक-वरोर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","पजा ओन दोर्कापीसि हव्‍किसि, तोटाता पलाते ओसि पोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","इंदके अंगुर तोटाता मालक वासि ओर्कुन बतल कियानुर? ओर वासि बटाइतोर्कुन हव्‍किसि अद तोटातुन वेरेतोर्क अप्‍पजेपनुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","पजा येसु ओर्कुन इल्‍हा इत्‍तोर. “मिमेट दर्मसास्‍त्रमते बस्‍केन हदवा हिल्‍लिरा? “बद बंडातुन अय्ते मिस्‍त्रिल्‍क, कबळ्‍क ओज्‍जो इंचि हय्‍सा हिल्‍लुर, अदे बंडा, सेंकु मूलाता पुनादि बंडा आता. इद सामि कीता कबळ आंद, इद मना नदरते इचंत्रमाता कबळ आंद,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","पजा दर्मसास्‍त्रम कराहना गुरुल्क आनि पेद्‍दा पेर्मालोर्क, येसु वेहता वेसुडिं केंजसि, “ईर मनाकुने इंचंतोर,” इंचि एरपाट कीतुर. अदुनहाटीं ओर येसुन दोर्का पियालय हूळतुर. गानि लोकुल्‍कुना वेर्रेक ओन पिय्याकेन होळसि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","पजा, येसुन ओना पोल्‍लेन लोप्पेन दोर्का पिय्याना इंचि इच्‍चुर परिसिल्कुन आनि इच्‍चुर हेरोद राजाना मनकालोर्कुन येसुनगा लोहतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ओर येसुनगा वासि इल्‍हा इत्‍तुर. “गुरु, निमे निजम वळ्‍कानोन आंदिन, बोर बतल इनिनागानि दाना पिकिरगुडा किय्‍यिन, निमे लोकुल्‍कुना मोकम हूळसि वळ्किन, इंका पेनदा हर्दा बारेमते सत्‍तेमते कराहंतिन इंचि माक एरपाटे मंता. इंदके माकु वेहा, नियम परकारम, कैसर राजांक कर दोहमळ न्‍यायमेना, आयोना?” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","येसु ओरा मनसुना कराब पिलान एरपाट कीसि, ओर्कुन इल्‍हा इत्‍तोर. “मिमेट बारि नावा पट्‍टु हूळांतिर? नाकु उंदि एंडि बंडि हुप्‍सट,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ओर उंदि एंडि बंडि हुपिस्तुर. अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “इद एंडि बंडिपोर्रो बोना पोटुवा आनि पोरोल मंता?” इत्‍तोर. “कैसर राजानद” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","पजा येसु, “बद कैसर राजानद मंता, अद कैसर राजांक हीम्टु. बद अय्ते पेनदाद मंता, अद पेनदुक हीम्टु,” इंचि ओर्कुन इत्‍तोर. अस्‍के ओना पोल्‍लें केंजसि ओर वेल्‍लेने इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","इच्‍चुर सदुकिर येसुनगा वातुर (हासि मर्रा जीवाते तेदमळतुन ईर नम्मुर.) वासि इल्‍हा सवाल पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“गुरु, मूसाना नियम परकारम, वरोर मनकल पिलाल्क आयाका मुन्‍नेन हासि होंचि ओना मुत्‍तो मत्‍ते, दानतोनि ओना तम्मुर मरमिं आसि, हातोना वंसमताहाटीं पिलाल्क कनना इंचि रासि मंता. ");
INSERT INTO esg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","अय्ते, एडुर दादाल-तम्मुह्‍क मत्‍तुर. ओरा लोप्पोटाल पेद्‍दोड मरमिं आतोर, गानि पिलाल्क आयाका मुन्‍नेन ओर हातोर. ");
INSERT INTO esg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","हातस्के ओना पज्‍जोटोर दानतोनि मरमिं आतोर, ओरगुडा पिलाल्क आयाका मुन्‍नेन हातोर. अल्‍हेने ओना पज्जोटोरगुडा दानतोनि मरमिं आतोर, ओरगुडा पिलाल्क आयाका मुन्‍नेन हातोर. ");
INSERT INTO esg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","इल्‍हा ओर एडुरगुडा दानतोनि मरमिं आसि पिलाल्क आयाका मुन्‍नेन हातुर. आकिरते अद मुरतळगुडा हाता. ");
INSERT INTO esg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","अय्ते हातोर अंटोर मर्रा जीवाते तेदतस्‍के, आ एडुर लोप्पोटाल अद बोना मुत्‍तो आयार? बारित्‍ते ओर एडुरगुडा दान मरमिं आसि मत्‍तुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “मिमेट दर्मसास्‍त्रमतुन आनि पेनदा ताकततुन एरपाट कियाका दान मिमेट तप्पु अर्तम कीकुंचंतिर. ");
INSERT INTO esg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","बारित्‍ते ओर हामुरताल जीवाते तेदानुर अस्‍के, ओर मरमिं आयुर, मरमिं कीसिगुडा हिय्युर. गानि ओर स्वर्गमता पेनदा दूतनलेसीं मनांतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","हातुर मर्रा जीवाते तेदाना बारेमते पेन, ‘नना अब्राहामुना पेनदुन, इसाकुना पेनदुन आनि याकोबुना पेनदुन’ इंचि दर्मसास्‍त्रमते पोत्‍तना पोदाता गटना जर्गनेंके मूसांक वेहता, अदुन मिमेट हदवा हिल्‍लिरा? ");
INSERT INTO esg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","अद हातोरा पेन आयो गानि जीवाते मत्‍तोरा पेन आंद. मिमेट वेल्‍ले तप्पु कीसेक मंतिट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ओर वदुरकुंचेक मत्‍तद केंजसि, अच्‍चोटेन वरोर दर्मसास्‍त्रम कराहना गुरु अगा वातोर. येसु ओर्क बेस जवाब हीतद हूळसि, “गुरु, पेन हीता आदेसकुनाल मेन आदेस बद आंद?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","अस्‍के येसु ओन्क इल्‍हा जवाब हीतोर. “ए इस्राएल! इद केंजा, अन्‍नि आदेसकुनाल इद मेन आदेस आंद: मावा पेने सामि आंदुर. ");
INSERT INTO esg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","निमे नीवा सामि आता पेनदुन पूरा मनसुनाल, पूरा आत्माताल, पूरा बुद्‍दिताल, पूरा ताकतताल पावरम कीम. ");
INSERT INTO esg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","रोंडो आदेस बद इत्‍ते, नीवद निमे बच्‍चोन पावरम कींतिनो, अचोने पावरम इंकावरोनगुडा कीम. इव रोंडुन होळसि वेरे पेद्‍दा आदेस बद्‍दे हिल्‍ले,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","अस्‍के दर्मसास्‍त्रम कराहना गुरु येसुन, “गुरु, निमे सत्‍तेम वळ्‍कतिन. पेन उंदे आंद, दान्क तपिच्‍चि इंकुंदि पेन हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अदुनहाटीं कमुरबलिं कियानदानकन्‍ना, मोक्‍कुल्क हियनदानकन्‍ना पूरा मनसुनाल, पूरा आत्माताल, पूरा बुद्‍दिताल, पूरा ताकतताल मनम पेनदुन पावरम कियमळे बेस आंद. अल्‍हेने मनद मनम पावरम कीतच्‍चोने इंकावरोनगुडा पावरम कियना.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","अल्हा ओर तेल्‍विते वेहतद केंजसि येसु ओन, “निमे पेनदा राज्येमकु वेल्‍ले लक्‍कु हिल्‍लिन,” इंचि इत्‍तोर. दाना पजा येसुन बद्‍दे सवाल पूसकियालय बोर्कु हिम्मत आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","येसु गुळिते पेनदा पोल्‍लें कराहनेंके ओर्कुन इल्‍हा इत्‍तोर. “किरिस्‍तु दाविदना मर्रि आंदुर, इंचि दर्मसास्‍त्रम कराहना गुरुल्क बल्हा इना परांतुर?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","इद पोल्‍लेतुन कुद दाविद पवित्र आत्माते निंडसि इल्‍हा इत्‍तोर, “बदवेरदाका अय्ते नीवा पगातोर्कुन, नीवा काल्कुनगा तर्रोन, अदवेरदाका नावा तिना बाजुंक उद्‍दिसि मन, इल्‍हा सामि, नावा सामिन इत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","इल्‍हा दाविद ओन, सामि इंचि इत्‍तोर. अय्ते किरिस्‍तु दाविदना मर्रि बल्हा आया परांतोर? इत्‍तोर. अगा मत्‍ता लोकुल्‍क येसुना पोल्‍लें बच्‍चोरो गम्मतते केंजतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","येसु ओर्क कराहसेके इल्‍हा इत्‍तोर. “दर्मसास्‍त्रम कराहना गुरुल्कुनाल उसारते मंटु. पोर्रोटाल हिळुदाका पोळ्‍गु अंगिं केर्सि तिरियमळ, हाटुमकुने जोहार वेहागोटकुनमळ ओर्क बेस अनपिच्‍चंता. ");
INSERT INTO esg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","इंका दर्मसास्‍त्रम कराहना लोह्कुने, कुळ्‍पुकुने पेद्‍दाल्‍क उद्‍दाना जेगाते उदमळ इत्‍ते ओर्क वेल्‍ले इस्‍टम. ");
INSERT INTO esg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ईर मुंडामोस्ता मुर्ताह्‍कुन मुळहंतुर, लोकुल्‍कुंक हुप्‍सालय वेल्‍लेनजेम पारतना कींतुर. गानि ईर्क मात्रम पेन अंटोर्कन्‍ना एक्‍को सिक्‍सा हियार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","येसु गुळिते दान पेटिता मुन्‍ने उद्‍दिसि, लोकुल्‍क दान पेटिते कोत्‍तां वाटनद हूळसेक मत्‍तोर. वेल्‍लेटुर सिरमंत लोकुल्‍क वेल्‍लेने कोत्‍तां वाटतुर. ");
INSERT INTO esg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","पजा मुंडामोस्ता उंदि गरिब मुरतळ वासि रोंडु रागि कोत्‍तां वाटता. अवुना विलुवा वेल्‍ले तक्‍को मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","अस्‍के येसु ओना सिस्युल्कुन दग्‍गेरा केय्‍सि इल्‍हा इत्‍तोर. “नना मीक निजम वेहांतन, ई मुंडामोस्ता गरिब मुरतळे अंटोर्कन्‍ना एक्‍को दानम कीता. बारित्‍ते इग्‍गे सिरमंत लोकुल्‍क ओरा दनमताल दानम कीतुर, गानि इद गरिब मुंडामोस्ता मुरतटगा रोंडे रागि कोत्‍तां मत्‍तां. अद अवुनगुडा इत्‍ते दाना पिस्वरताहाटीं इरतादानगुडा पेनदुक वाटसीता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","येसु गुळिताल पलाते पेय्सि वातस्के ओना सिस्युल्‍कुनाल वरोर सिस्युड येसुन, “गुरु, हूळा! बच्‍चोर पेद्‍दा बंडां, बच्‍चोर बेसता बंगलां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","अस्‍के येसु ओन इल्‍हा इत्‍तोर. “बंडाने दोहतव पेद्‍दा-पेद्‍दा बंग्लां हूळसेक मंतिन गदा, अव बंडां उंदानपोर्रो उंदि मनाकोंटा कूल्‍हाना वेला वायनद मंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","येसु अगटाल पेय्सि गुळिकु मुन्‍ने मंदना जय्‍तुन मराकुना गुट्‍टापोर्रो होंचि उदतोर. ओर ओंटिगा मत्‍तद हूळसि, पत्रु, याकोब, योहान आनि अंदरियल ओनगा होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","होंचि, “इवन्‍नि गटनां बस्के जर्गनुं माक वेहा. इंका इव गटनां जर्गना मंता इन्‍नेंके माकु बतल चिन्‍ह दिस्‍सार?” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","अस्‍के येसु ओर्कु इल्‍हा वेहालय दल्‍गतोर, “मीकुन बोर पसांचकोंटा मिमेट उसारते मंटु. ");
INSERT INTO esg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","नावा पोरोल एतसेके बचुटूरो लोकुल्‍क वांतुर. वासि, ‘ओन ननाने आंदुन’ इंचि वेल्‍लेटोर्कुन पसांचंनुर. ");
INSERT INTO esg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","मिमेट लडाईं आनि लडाईना पोल्‍लेना बारेमते केंजसि वेरियमट, अल्हा तप्‍पाकोंटा आयानुंगे. गानि दुनियाता आकिर वेला अस्‍केने वायो. ");
INSERT INTO esg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","देसेमपोर्रो देसेम, राज्येमपोर्रो राज्येम लडाईं आयनुं, वेरे-वेरे जेगाने बूकंपाल्क आयनुं, कर्वु अर्रार. गानि इल्‍हा आयमळ इत्‍ते एर पूरालय नोप्‍पिं सुरुव आताप आंद. ");
INSERT INTO esg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","गानि मिमेट उसारते मंटु. बारित्‍ते मीकुन पंचादितोरा कय्‍दे अप्‍पजेपनुर आनि दर्मसास्‍त्रम कराहना लोह्कुने ओसि तनानुर. पजा नावा बारेमते गवाइ वेहालय मीकुन राज्यपाल आनि राजालोरा मुन्‍ने निलाहनुर. ");
INSERT INTO esg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","गानि दीनकन्‍ना मुन्‍ने अन्‍नि देसेल्कुने तप्‍पाकोंटा पेनदा बेसता कबुर वेहमळ जर्गगोम. ");
INSERT INTO esg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","अद वेलाते मीकुन पीसि ओसि पूसकियानुर. अस्‍के अगा बतल वळ्कना, बतल वळ्‍कानायो इंचि मोदाले रंदि कियमट. वळ्कानोर मिमेट आयो गानि पवित्र आत्मा आंद. अदुनहाटीं मीवा मनसुने बतल वळ्‍कागोम इंचि अनपिचंतनो अदे वळ्कट. ");
INSERT INTO esg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","इंका बल्हा जर्गंता इत्‍ते, कासा तादल-तम्मुह्‍क पगां आसि हव्कालय अप्‍पजेपनुर. पिलाल्क ओरा तल्‍लुर-बाबोंक अड्‍डम तिरियसि ओर्कुन हव्का वेहांतुर. ");
INSERT INTO esg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","नावा पोरोलताहेंका अंटोर लोकुल्‍क मीकुन हय्सुर. गानि बोर अय्ते पेनदापोर्रोटा विस्वासमते आकिरदाका निल्‍सि मनंतोर, ओनके मुक्‍ति दोर्कार. ");
INSERT INTO esg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","गानि बस्के अय्ते, बोरे हय्‍सवसोंटा नासडेम कियाना वस्तु, गुळि लोप्पो बगा अय्ते मंदनायो अगा नित्‍तिसि मत्‍तद मिमेट हूळकिर, अस्‍के बोर अय्ते यहुदिया एरियाते मंतुरो, ओर गुट्‍टनहेके वित्‍तिर (हद्‍वानोर इदुन अर्तम कीकुंटु) ");
INSERT INTO esg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","बोर अय्ते लोतपोर्रो मंतोर, बवे वस्‍तुक पीसि वायालय लोप्पो होळियानायो. ");
INSERT INTO esg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","बोर अय्ते नेलिने कबळ कीसेक मंतोर, कपडिं पीसि वायालय मल्सि लोन होनानायो. ");
INSERT INTO esg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","अव रोजकुने पीटे मत्‍ता मुर्ताह्‍कुंक आनि सिन्‍ने मर्तल्‍लुह्‍कुंक वेल्‍लेन तकलिप वांता. ");
INSERT INTO esg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","अव तकलिपकु पीनि कालमते वायामन्‍नि इंचि पारतना कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","बारित्‍ते पेन कीता ई दुनिया पुट्तस्केटाल अय्ते इदवेरादाका बस्‍केन वायवसोंटा तकलिप अव रोजकुने वायाना मंता आनि मुन्‍नेगुडा असोंटा तकलिप बस्‍केने वायो. ");
INSERT INTO esg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ओक्‍कला सामि अव रोजकुन तक्‍को कियाकोंटा मंचि मत्‍ते, बोरे पिसाकोन्‍नेर. गानि बोर्कुनय्ते पेन पेरता, ओराहाटीं अव रोजकुन तक्‍को कीता. ");
INSERT INTO esg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","अव रोजकुने आबद्‍दम किरिस्‍तुल्‍क, पेनदा आबद्‍दम कबुरतोर वायानुर. आनि कुदुरते पेन पेर्कुत्‍ता लोकुल्‍कुन पसांचलय चिन्‍हां, इचंत्रमता कबाह्‍क कीसि हुप्‍सानुर. अदुनहाटीं ओक्‍कला बोरन्‍ना मीकुन, ‘हुळाट, किरिस्‍तु इगे मंतोर, अगा मंतोर’ इनानय्ते मिमेट ओर्कुन नम्मुमट. ");
INSERT INTO esg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","गानि मिमेट उसारते मंटु; इव अन्‍नि पोल्‍लें नना मीक मुन्‍नेने वेहचीतन. ");
INSERT INTO esg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","गानि अव रोजकुने तकलिपकु मारतस्के पोळ्‍दुंक हीकट मुच्‍चका वायार, वेळसि वेल्‍गु हियाकोंटा आयार. ");
INSERT INTO esg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","मब्बुनाल सुक्‍कां हिळु अर्रानुं, मब्बुने मनना अन्‍नि सक्‍तिन कदलिच्‍मळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","अस्‍के मनकना रूपमते पुटतोन नना, पेद्‍दा बलम आनि महिमातोनि मब्बु तेर्पेनपोर्रो उद्‍दिसि वायानेंके लोकुल्‍क हूळानुर. ");
INSERT INTO esg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","अस्‍के नना नावा दूतन बूमिपोर्रो लोहांतन. आ दूतां बूमिपोर्रो नालुं मूलानाल, मब्बुना ई कोस्‍साताल अय्ते आ कोस्‍सादाका नना पेर्कुत्‍ता लोकुल्‍कुन जमा कींतां,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“अंजिर मराताल उंदि पोल्‍ले करियट. अंजिर मराता कोम्मांक इग्गुर बस्के अय्ते वांता, अस्‍के एद्‍दि कालम दग्‍गेरा एव्ता इंचि मिमेट एरपाट कींतिर. ");
INSERT INTO esg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","इल्‍हा इव अन्‍नि गटनां जर्गनद हूळसि ओर दग्‍गेरा मंतोर, गल्‍मातगेन मंतोर इंचि मिमेट एरपाट कींतिर. ");
INSERT INTO esg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","नना मीकु निजम वेहांतन, बदवेरदाका अय्ते इव अन्‍नि पोल्‍लें पुरागा आयोंगो, अदवेरदाका ई पीळि मुळगो. ");
INSERT INTO esg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","इद बूमि, मब्बु नासडेम आसि होंदार, गानि नावा पोल्‍लें बस्‍केने नासडेम आयों. ");
INSERT INTO esg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“अद रोजु आयि, अद गळिया आयि बोर्के तेळियो. स्वर्गमता दूतांक आयि, मनकना रूपमते पुटतोन नाकु आयि बोर्के तेळियो. गानि सिराप पेनबाबांके तेळियंता. ");
INSERT INTO esg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","अद वेला बस्के वांतानो मीक तेळियो. अदुनहाटीं मिमेट तेल्‍विते, उसारते मंटु. ");
INSERT INTO esg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","इद वरोर मनकनलेसीं मंता, बोर अय्ते पय्‍नेम होनाका मुन्‍ने, ओना जीतागाह्कुन केय्‍सि, बोना कबळ ओनकु अप्‍पजेपसि, लोतुन कावेल कियानोन ‘तेल्‍विते मन’ इंचि आदेस हींतोर. ");
INSERT INTO esg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","लोता मालक पोळ्‍द होंचि वांतोरो, नळ्‍जाम नर्का वांतोरो, गोगोड कूसानेंके वांतोरो, हक्‍केरे वांतोरो, बस्के वांतोरो मीक एरपाट हिल्‍ले. अदुनहाटीं मिमेट तेल्‍विते मंटु. ");
INSERT INTO esg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ओर अचानक वासि, मीकुन निद्र होंचि मत्‍तद हूळा मनि इंचि मिमेट तेल्‍विते मंटु. ");
INSERT INTO esg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","इद नना मीक वेहतन, अल्‍हेने अंटोर्कगुडा अदे वेहासेक मंतन. तेल्‍विते मंटु,” इंचि येसु ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","रोंडु रोजकुना पजा दाटसि होनना पंडुगु आनि पुल्‍लगा आयवा पिंडिता हारिना पंडुगु आयाना मत्‍ता. अस्‍के येसुन सप्‍पुडदाका दोर्कापीसि हव्ककोम इंचि पेर्मालोर्क, दर्मसास्‍त्रम कराहना गुरुल्क पिलान कीसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","गानि, “पंडुगु रोजकुना लोप्पो हव्का मन्‍नि, अल्हा कीते लोकुल्‍क गडबड किया परांतुर,” इंचि ओर इनकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","अद वेलाते येसु बेतानिया नाटे, मुन्‍ने कुस्‍टरोगम आसि मत्‍ता सिमोनुना लोते गाटो तिनालय उद्‍दिसि मत्‍तस्के, उंदि मुरतळ तेल्‍लाटा बंडा गुर्गिते जटामासि मराताल तयार कीतद, वेल्‍ले दराता पिव्‍वर अत्‍तर निय पीसि वाता. अद गुर्गिता बुच्‍चातुन पयाहचि येसुना तल्‍लापोर्रो वळियता. ");
INSERT INTO esg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","अदुन हूळसि, अगा मत्‍तोर्क इच्‍चुर्कु होंग वासि, “इद अत्‍तर निय अट्‍टिदे बारि नासडेम कीतिन? ");
INSERT INTO esg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","इदुन अम्मिसि मत्‍ते मूड नुह्कुंकन्‍ना एक्‍को एंडि रूपें वायवह्कु. अवुन गरिब लोकुल्‍कुंक हियालय ओज्‍जुवाह्‍क,” इंचि दान तेराहतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","गानि येसु ओर्कुन इल्‍हा इत्‍तोर. “दीन बतल इनमट, मिमेट दीन बारि तकलिप कीसंतिर? इद नावाहाटीं बेसे कीता. ");
INSERT INTO esg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरिब लोकुल्‍क मीवातोनि बस्‍केळ्‍क मनंतुर, मिमेट बस्के इनकुत्‍ते अस्‍के ओर्क बेस किया परांतिर, गानि नना मीवातोनि बस्‍केळ्‍क मन्‍नोन. ");
INSERT INTO esg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","नावा मेंदुल्तुन बोंदा दोस्‍साका मुन्‍नेने अद मुरतळ नाक निय होकता. अद किया परतच्‍चोन कीता. ");
INSERT INTO esg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","नना मीक निजम वेहांतन. पूरा दुनियाते बगा-बगा पेनदा बेसता कबुर वेहमळ जर्गंता, अगा ई मुरतटुन आनि इद कीता कबळतुन मति कियानुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","पजा, पन्‍नेंड सिस्युल्‍कुनाल वरोर इस्‍कारियोत यहुदल मत्‍तोर. येसुन पीसि हियालय ओर पेद्‍दा पेर्मालोरगा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","अद केंजसि ओर कूस आसि, ओन्क कोत्‍तां हींतोम इंचि ओप्‍कुत्‍तुर. अदुनहाटीं ओर येसुन पीसि हियालय मोका हूळसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","पुल्‍लगा आयवा पिंडिता हारिना पंडुगुना मोदाटा रोजु, दाटसि होनना पंडुगुना गोर्रे पोरिन मोक्‍कु हियुंदुर. अदे रोजुने येसुना सिस्युल्कु, “गुरु, दाटसि होनना पंडुगुना गाटो तिनना तयारिं बगा कीकोम इंचि नीवा मनसु मंता?” इंचि ओन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","येसु ओना इव्वुर सिस्युल्कुन केय्‍सि ओर्क इल्‍हा वेह्‍चि लोहतोर. “मिमेट सहरते होंट. अगा वरोर मनकल अळकाते एर पीसि होननेंके कलियंतोर, ओना पज्जेन होंट. ");
INSERT INTO esg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ओर बद लोन अय्ते दांतोरो, अद लोता मालकुन, ‘नना नावा सिस्युल्कुनतोनि कलियसि, दाटसि होनना पंडुगुना गाटो तिननाहाटीं हेळमितोर आगाना अर्रा बगा मंता? इंचि गुरु पूसकीसंतोर,’ इल्‍हा इंटु. ");
INSERT INTO esg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","अस्‍के ओर मीकु मिद्‍दे पोर्रोटा पेद्‍दा अर्रा सजांचि तयार कीसि मत्‍तद हुप्‍सानुर, अदे अर्राते पंडुगुना गाटो मनाहाटीं तयार कीम्‍टु,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","सिस्युल्कु अगटाल पेय्सि सहरते होत्‍तस्के, ओर बल्हा वेहतोर अल्‍हेने अगा मत्‍ता, पजा ओर अग्गेन दाटसि होनना पंडुगुना गाटो तयार कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","पोळ्‍द होत्‍तारिते, येसु ओना पन्‍नेंडु सिस्युल्कुनतोनि अगा वातोर. ");
INSERT INTO esg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ओर गाटो तिंचेके मत्‍तुर अस्‍के येसु, “नना मीक निजम वेहसेक मंतन, मीवा लोप्पोटाल वरोर नाकुन पीसि हींतोर, ओर नावातोनि उद्‍दिसि गाटो तिंचेके मंतोर,” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","अद केंजसि ओर्क वेल्‍लेन दुक्‍कम अनपिस्ता, ओर वरोन पज्जो वरोर, “ओन नना अय्ते आयोन गदा?” इंचि येसुन पूसकियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","अस्‍के येसु, “ओर पन्‍नेंड मंदिताल वरोर आंदुर, ओर नावातोनि गिन्‍नेते हारि मुळाह्‍चि तिनानोरे. ");
INSERT INTO esg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","दर्मसास्‍त्रमते रासि मत्‍ताप, मनकना रूपमते पुटतोन नना अय्ते दांतने. गानि बोनाहेंदाल अय्ते नाकुन पीसि हियमळ जर्गंता, आ मनकल पुट्‍टाकोंटेन बेस आसि मनवळ,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","अल्हा ओर तिंचेके मनेंकेने, येसु हारितुन येत्‍सि, पेनदुक दन्यवाद कीसि तुकडां कीतोर. अवुन सिस्युल्कुंक हीसि, “तिंट, इद नावा मेंदुल आंद,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","मर्रा ओर, उंदि तालिते अंगुर पानकम येत्‍सि, पेनदुक दन्यवाद कीसि ओर्क हीतोर. अदुन ओर अंटोर उट्‍टुर. ");
INSERT INTO esg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","पजा, “इद करारता नावा नेत्‍तुर आंद, इद नेत्‍तुर वेल्‍लेटोराहाटीं पोंगागोटमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","नना मीक निजम वेहांतन, पेनदा राज्येमते पूना तरिकाते अंगुर पानकम उनाना रोजुनदाका, मर्रा बस्‍केने अंगुर पानकम उन्‍नोन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","पजा ओर, पेनदा स्‍तुति कियाना उंदि पाटा पारसि, जय्‍तुन मराकुना गुट्‍टापोर्रो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “गोर्रें कोहानोन नना हव्कंतन, मंदता गोर्रें बेंदव-हेके पायसि वित्‍तंतां, इंचि दर्मसास्‍त्रमते रासि मंता. अदुनहाटीं मिमेट अंटोर नाकुन होळसि वितकिर. ");
INSERT INTO esg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","गानि, नना हासि मर्रा जीवाते तेदतंका, मीकन्‍ना मुन्‍ने गालिल एरियाते दांतन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","अस्‍के पत्रु, “अंटोर नीकुन होळसि वित्‍तिना गानि नना नीकुन होळसि वित्‍तोन,” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","अस्‍के येसु, “नना निजम वेहासेक मंतन, इय्याला नर्कळ्‍क रोंडु मल्कां गोगोड कूसाका मुन्‍ने, निमे नाकुन मूड मल्कां ‘एरपाट किय्योन’ इंचि इनकिन,” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","गानि पत्रु इंका जोसने, “ओक्‍कला नाकु नीतोनि हामुर वायिना बेसे, नीकुन नना एरपाट किय्योन इंचि बस्‍केने इन्‍नोन,” इंचि इत्‍तोर. अद केंजसि, कळमतोरगुडा पत्रु इत्‍तापे इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","अगटाल ओर गेतसेमनि इनना जेगातगा होत्‍तुर. अगा एवतस्‍के, “नना पारतना कियानादाका इग्‍गेने उद्‍दिसि मंटु,” इंचि ओना सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","पजा पत्रुन, याकोबुन, योहानुन ओनतोनि ओतोर. येसु अद वेलाते वेल्‍ले दुक्‍कमते, सिम्मरा आतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","अस्‍के ओर्कुन, “नावा जीवा दांता बारे इत्‍ताप नाक वेल्‍ले दुक्‍कम आसेक मंता. मिमेट इग्‍गेने आगसि, तेल्‍विते मंटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","इच्‍चुर मुन्‍ने होंचि बोकबोर्लें अर्सि पारतना कीतोर, “आया परते इद तकलिपता वेला तप्‍सि होन्‍नि. ");
INSERT INTO esg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","बाबा! नावा बाबा, नीतोनि अन्‍नि आया परांता, इद तकलिपता वाटितुन लक्‍कु कीम. गानि नावा इच्‍चा मत्‍ताप आयो, नीवा इच्‍चा मत्‍तापे आयि,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","पजा सिस्युल्कुनगा वासि हूळते ओर निद्रा होंचि मत्‍तुर. अस्‍के येसु सिमोन पत्रुन इल्‍हा इत्‍तोर. “सिमोनु, मंचिगा मींडसंतिरा? उंदि गंटामेडगुडा नातोनि तेल्‍विते मंदा परिना? ");
INSERT INTO esg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","मिमेट पट्‍टुने अर्राकोंटा मननाहाटीं तेल्‍विते मंचि पारतना कीसेके मंटु, नना वेहताप कियालय मीवा आत्मा तयार मंता गानि मीवा मेंदुल कमजोर मंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","अस्‍के येसु मरुंदि मल्का होंचि, मुन्‍ने कीतापे मर्रा पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","येसु मर्रा वासि हूळतस्‍के, ओर मंचि निद्रते मत्‍तुर. येसुंक बतल जवाब हियना ओर्क तेळिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","येसु मूडोव मल्का ओरगा होंचि ओर्कुन इल्‍हा इत्‍तोर. “मिमेट इंदकेगुडा मींडसेक, आराम कीसेके मंतिरा? इद वेल्‍लेन आता, मनकना रूपमते पुटतोन नाकुन पापिर्कुना कय्‍दे पीसि हियना वेला एव्ता. ");
INSERT INTO esg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","तेदाट, मनम दाकोम. नाकुन पीसि हियानोर दग्गेरेन एव्‍तोर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","येसु वळ्‍कसेकेन मंतोर, अच्‍चोटेन पन्‍नेंड सिस्युल्कुना लोप्पोटोर वरोर यहुदल वातोर. ओनतोनि पेर्मालोर्क, दर्मसास्‍त्रम कराहना गुरुल्क, यहुदि पेद्‍दाल्क लोहचीता लोकुल्‍कुना पेद्‍दा मंदा ओर कसेह्‍क, दुड्‍डुक पीसि वातुर. ");
INSERT INTO esg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","येसुन पीसि हियानोर, “नना बोन अय्ते बुर्रांतनो, ओरे येसु आंदुर. ओन दोर्कापीसि जेगर्ताते ओम्टु,” इंचि मुन्‍नेन ओर्क उंदि चिन्‍ह वेह्‍चि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","अदुनहाटीं ओर वाता वायुडे येसुनगा होंचि, “गुरु!” इंचि ओन बुरतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","अस्‍के ओर ओनापोर्रो कय वाट्‍सि, ओन दोर्का पीतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","अच्‍चोटेन अगा दग्‍गेरा नित्‍तिसि मत्‍तोरागटाल वरोर ओना कसेर तेंडसि, पेद्‍दा पेर्माना वरोर दासुना केव नेम्मानाल हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","अस्‍के येसु ओर्कुन, “वरोन दोंगन पिय्‍यालय वाताप मिमेट कसेह्‍क, गुत्‍पां पीसि नाकुन पिय्‍यालय वातिरा? ");
INSERT INTO esg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","नना अय्ते रोजे गुळिते कराहसेक मीतोनि मनुंदुन, अस्‍के नाकुन पिया हिल्‍लिर. गानि दर्मसास्‍त्रमते नावा बारेमते रासता पोल्‍लें पूरा आयाना इंचि, इल्‍हा जर्गता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","पजा ओना सिस्युल्क अंटोर ओन होळसि तेगा विततुर. ");
INSERT INTO esg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","वरोर लेय्या मनकल ओना मेंदुल्क सिराप चादर हुटकुंचि येसुना पज्जो होंचेके मत्‍तोर. लोकुल्‍क ओनगुडा पीतुर, ");
INSERT INTO esg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","गानि ओर चादर होळसिसि कुळ्केंगे वीततोर. ");
INSERT INTO esg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ओर येसुन पेद्‍दा पेर्माना लोन ओतुर. अगा अंटोर पेर्मालोर्क, यहुदि पेद्‍दाल्क, दर्मसास्‍त्रम कराहना गुरुल्क जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","गानि पत्रु लक्‍कुटाले येसुना पज्जो-पज्जो पेद्‍दा पेर्माना दारादाका होत्‍तोर. अगा सिपाइल्कुनतोनि तडमितगा सेका कासेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","अगा पेद्‍दा पेर्मालोर आनि पंचादितोर अंटोर येसुंक हामुरता सिक्‍सा हियानाहाटीं, ओना विरोदमते तप्‍पुड गवाइ पहकतुर, गानि ओर्क उंदिगुडा तप्‍पुड गवाइ दोर्काहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","बारित्‍ते येसुना विरोदमते वेल्‍लेटोरे आबद्‍दम गवाइ वेहतुर, गानि ओरा गवाइ वरोनद वरोंक कलिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","अस्‍के इच्‍चुर लोकुल्‍क नित्‍तिसि, “मनकालोर दोह्‍ता गुळितुन कूलाह्‍चि, मूड रोजकुने मर्रा दोहंतन, गानि अद मनकालोर दोहतद आयो, इनानेंके मोमोट केंजतोम,” इंचि येसुना विरोदमते गवाइ हीतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","गानि इवनेगुडा वरोना गवाइ वरोंक कलिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","अस्‍के पेद्‍दा पेर्मल नड्‍डुम नित्‍तिसि, “ईर नीकु विरोदमते बल्हा गवाइ हीसंतुर हूळा, निमे बतले जवाब हिय्‍यिना?” इंचि येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","गानि ओर चुपचाप मत्‍तोर, बतले जवाब हिया हिल्‍लोर. अस्‍के मरुंदि मल्का पेद्‍दा पेर्मल येसुन, “निमे कदरगल्‍ला पेनदा मर्रि किरिस्‍तुन आंदिना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","अस्‍के येसु इत्‍तोर. “हो, ननाने आंदुन. आनि मनकना रूपमते पुटतोन नाकुन ताकतवर पेनदा तिना बाजुंक उद्‍दिसि मत्‍तद आनि मब्बु तेर्पेनतोनि वायानद मिमेट हूळकिर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","अस्‍के पेद्‍दा पेर्मल ओना कपडिं हराह्‍कुंचि, “मनाक इंका बतल गवाइ गावाले? ");
INSERT INTO esg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ईर पेनदा अपमानम कीतद मिमेट केंजतिरे गदा! अय्ते मिमेट बतल इंतिर?” इंचि पेर्मल इत्‍तस्के, ओर अंटोर, “ओर हामुर सिक्‍सालायक मंतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","अस्‍के इच्‍चुर लोकुल्‍क येसुनपोर्रो उस्‍कतुर, इंका इच्‍चुर बारे ओना कळ्‍कुन मुच्‍चिसि तंचेके, “निमे बविस्यवानि वेहानोनाते, नीकुन बोर तंतुर वेहा,” इंचि इत्‍तुर. अल्‍हेने कावेल कियानोरगुडा ओन सेंपापोर्रो तंतुर. ");
INSERT INTO esg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","अव अन्‍नि आयानेंके पत्रु हिळु दाराते उद्‍दिसि मत्‍तोर, अस्‍के पेद्‍दा पेर्मानगा पासि कबळ कियानद उंदि मुरतळ वाता. ");
INSERT INTO esg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","वासि, पत्रु तळमि सेका कासेक मत्‍तद हूळसि, “निमेगुडा नासरेत नाटेना येसुनतोनि मत्‍तिन गदा!” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","गानि पत्रु अद पोल्‍लेतुन ओप्कुना हिल्‍लोर. “निमे बतल इंचंतिनो, नाक तेळियो, नना एरपाट किय्योन,” इंचि पलाता गलमातगा होत्‍तोर, अच्‍चोटेन गोगोड कूसता. ");
INSERT INTO esg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","अद पासि कबळ कियाना मुरतळ पत्रुन हूळसि, “ईर तप्‍पाकोंटा ओरा लोप्पोटोरे वरोर आंदुर,” इंचि अद मर्रा उंदि मल्का अगा नित्‍तिसि मननोरतोनि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","गानि पत्रु मर्रा ओप्कुना हिल्‍लोर. गडसेम मत्‍तस्के अगा नित्‍तिसि मत्‍तोर पत्रुन, “निजमे, निमे ओरा लोप्पोटोने आंदिन, बारित्‍ते निमेगुडा गालिल राज्येमतोन आंदिन,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","अस्‍के पत्रु ओर्कुन, “नना ओट्‍टु तिंचि वेहसेक मंतन, नावा पोल्‍ले आबद्‍दम आते नाकु सापनेम दल्‍गि! मिमेट बोना बारेमते वळ्‍कसंतिरो, आ मनकन नना निजम एरपाट किय्योन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","अल्हा इत्‍ता इनुडे गोगोड रोंडो मल्का कूसता. येसु पत्रुंक मुन्‍नेने वेह्‍चि मत्‍तोर, “गोगोड रोंड मल्कां कूसाका मुन्‍ने, निमे नाकुन मूड मल्कां एरपाट किय्योन इंतिन,” इंचि. आ पोल्‍ले पत्रुंक मति वाता. अस्‍के वेल्‍ले दुक्‍कमते अळतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","बल्हा अय्ते पंग आता अल्हा पेद्‍दा पेर्मालोर, यहुदि पेद्‍दाल्क, दर्मसास्‍त्रम कराहना गुरुल्क आनि पूरा पंचादितोर उंदि निरनायम कीसि, येसुन दोह्‍चि वाट्‍सि ओसि, पिलातुस राज्यपालुंक अप्पजेपतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पजा पिलातुस, “निमे यहुदिल्कुना राजाना?” इंचि येसुन पूसकीतोर. “निमे इत्‍तापे” इंचि येसु जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","अस्‍के पेद्‍दा पेर्मालोर ओनापोर्रो वेल्‍लेन पोल्‍लेना दोसेल्क दोसतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","अदुनहाटीं पिलातुस येसुन मर्रा पूसकीतोर, “हूळा ओर नीवा पोर्रो बच्‍चुंगो तप्पुक दोस्सेक मंतुर, निमे बतले जवाब हिय्‍यिना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","गानि येसु बतले जवाब हिया हिल्‍लोर, इंचि पिलातुस इचंत्रम आतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","दाटसि होनना पंडुगुना रोजुने, लोकुल्‍कुंक इस्‍टमातोन एटा वरोन जेलनाल होळ्‍सियाना रिवाज मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरब्बल इनना वरोर मनकल ओना दंटातोरतोनि जेलने मत्‍तोर. ओर ओना दंटातोरतोनि कलियसि, बचुटूरो लोकुल्‍कुन हव्‍किसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","लोकुल्‍क पिलातुसनगा वासि, “एटा मावाहाटीं बल्हा कियिंदिनो अल्‍हेने कीम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","पेर्मालोर्कुंक येसुनपोर्रो कळ्‍क पोतताहेंकेन ओन तच्‍चि नाक अप्पजेपतुर इंचि पिलातुस एरपाट कीकुत्‍तोर. अदुनहाटीं पिलातुस ओर्कुन, “मीवा बतल विचारम मंता, यहुदिल्कुना राजान मीहाटीं होळसीकाना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","गानि पेर्मालोर्क, “मावाहाटीं बरब्बने होळ्‍सीम इंचि मिमेट इंटु,” इल्‍हा लोकुल्‍कुन एक्‍किस्तुर. ");
INSERT INTO esg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","मर्रा पिलातुस ओर्कुन, “अय्ते मिमेट यहुदिल्कुना राजाल इंचि बोनय्ते इंतिर, ओन नना बतल कीकन,” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","अस्‍के, “ओन क्रुसुनपोर्रो वेलाड वाटा!” इंचि ओर वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","अस्‍के पिलातुस, “बारि, ईर बतल तप्पु कीतोर?” इंचि ओर्कुन पूसकीतोर. गानि ओर इंका जोरते, “ओन क्रुसुनपोर्रो वेलाड वाटा!” इंचि वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पिलातुसुंक लोकुल्‍कुन कूस कियाना मत्‍ता इंचि ओराहाटीं बरब्बन होळसिसि येसुन बारे पोट्‍टे देब्बां तंचि क्रुसुनपोर्रो वेलाड वाटालय सिपाइल्कुना कय्‍दे अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","पजा सिपाइल्क येसुन पीसि राज्यपालना पिरटोरियम इनना किल्‍लाते ओतुर. अगा सिपाइल्कुना पूरा गेंगुन केय्‍सि जमा कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ओर येसुंक नेडि पंडि रंगुना कोट केराह्‍चि, हाह्कुना वेलितुन किरिटम कीसि ओना तल्‍लक दोसतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","अस्‍के ओर, “यहुदिल्कुना राजांक जय!” इंचेके ओन्क जोहार कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","पजा ओर ओना तल्‍लापोर्रो दुड्‍डुने तंतुर, ओनपोर्रो उस्‍कतुर, ओर ओना मुन्‍ने वंगिस जोहार कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ओन इरगा कारेड्‍डाल्‍क कीतारित्‍ते, ओन्क केराह्‍ता नेडि पंडि रंगुना कोट तेंडसि, ओना कपडिं ओन्‍के केराहतुर. अस्‍के ओन क्रुसुनपोर्रो वेलाड वाटालय पलाते ओतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","सिपाइल्क येसुन पीसि पलाते होननेंके, सिकंदर आनि रुपुसना बाबाल सिमोन इनानोर नेलिनाल अदे हर्रि पीसि वासेक मत्‍तोर. ओर कुरेनि सहरतोर मत्‍तोर. सिपाइल्क ओन वेराहचि येसुना क्रुस कांजा वेहतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ओर गोलगोता इनना जागातगा येसुन पीसि वातुर. गोल्‍गोता इत्‍ते तल्‍ला बोरसेम इंचि अर्तम. ");
INSERT INTO esg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","अगा ओर, मुर्र इनना मत्‍तु अंगुर पंडिना पानकमते कल्‍पिसि येसुंक उनालय हीतुर, गानि ओर उना हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","अस्‍के ओन क्रुसुनपोर्रो वेलाड वाटतुर. पजा ओना कपडिन बद बोर एताना इंचि सिट्‍टिं वाट्‍सि पंचकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","येसुन क्रुस पोर्रो मोल्‍लाने कोह्‍किसि वेलाड वाटतस्के हक्‍केटां तोम्मिद एगिस मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ईर “यहुदिल्कुना राजाल” आंदुर इंचि, उंदि बल्‍लापोर्रो कसूर रासि ओना तल्‍लातगा क्रुसुंक तासतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","येसुनतोनि इंका इव्वुर दोंगाल्कुन, तिना बाजुंक वरोन, डेमा बाजुंक वरोन क्रुसकुन पोर्रो वेलाड वाटतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","इदुनहेंदाल दर्मसास्‍त्रमते रासि मत्‍ताप, “ओर दोंगाल्‍कुना लेक्‍काते वातोर” इद पोल्‍ले पूरा आता. ");
INSERT INTO esg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","अद हर्रि पीसि होनानोर-वायानोर तल्‍लां ऊपसेके, “ओ! गुळितुन कूलाह्‍चि मूड रोजकुने दोहानोन, क्रुसताल रेय्‍सि निमे नीवा जीवातुन पिसागोटकुन,” इंचि अपमानम कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","अल्‍हेने पेर्मालोर्क, दर्मसास्‍त्रम कराहना गुरुल्कगुडा, “ओर इंकावरोन पिसागोटतोर गानि ओनद ओरे पिसागोटकुना परसेके हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इस्राएलतोरा राजाल किरिस्‍तु क्रुसुनपोर्रोटाल हिळु रेय्‍सि वायिरकांटी, अस्‍के मोमोट हूळसि, ईनपोर्रो विस्वासम ईरा परकोम,” इंचेके ओना कारेड्‍डाल्‍क कीतुर. येसुना पक्‍काते क्रुसुंक वेलाड वाट्‍सि मत्‍ता दोंगाल्कगुडा ओना अपमानम कीतुर. ");
INSERT INTO esg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","अस्‍के पिय्यटा पन्‍नेंड एगानस्‍केटाल अय्ते, मूड एगनदाका पूरा बूमिअंता हीकट आता. ");
INSERT INTO esg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","पिय्यटा मूड एगनेंके येसु अळसेके जोरसे वरगेयसि, “एलि, एलि, लमा सबकतनि?” इंचि इत्‍तोर. इत्‍ते, “ना पेनदुना, ना पेनदुना निमे नाकुन बारि होळसीतिन?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","अस्‍के अगा नित्‍तिसि मत्‍तुर इच्‍चुर लोकुल्‍क, “हुळाट! ओर एलियान केयसंतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ओरा लोप्पोटाल वरोर विच्‍चि होंचि स्पंजतुन पुल्‍लाटा अंगुर पानकमते मुळ्‍हाचि, दुड्‍डु कोस्‍सक तासिसि ओनकु उनालय हीतोर. हीसि, “आगा! एलियाल ओन हिळु रेहालय वांतोरा वायोरा? हूळकोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","अस्‍के येसु पेद्‍दा आवाजते वरगेयसि जीवा होळ्‍सीतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","अस्‍के गुळिता परदा पोर्रोटाल हिळुदाका हर्सि रोंडु तुकडां आता. ");
INSERT INTO esg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","अस्‍के नूर मंदि सिपाइल्कुना पोर्रो मनना अदिकारि येसुना क्रुसता मुन्‍नेने नित्‍तिसि मत्‍तोर. ओर येसु वरगेयसेके जीवा होळ्‍सनद हूळतोर, हूळसि, “ईर निजमे पेनदा मर्रि आंदुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","अगा मगदलेनि नाटेना मरियम, सिन्‍ना याकोब, योसेसना यावल मरियम, सलोमि इव मुर्ताह्कगुडा लक्‍कुटाले नित्‍तिसि हूळसेक मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","येसु गालिल एरियाते मत्‍तस्के, इव मुर्ताह्क ओना पज्जो होंचि सेवा कियुंदुं. इवे आयाका ओना पज्जो येरुसलेमदाका वातव इंका वेल्‍लेन मुर्ताह्क मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","नोमकेन रोजुना मुन्‍नेटा रोजु येसु हातोर, अद नोमकेमता तयारिता रोजु आंदु. अस्‍के पोळ्‍दु होंचि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमताइ नाटेनोर योसेपु इनानोर वरोर मत्‍तोर. ओर यहुदिल्कुना पंचादिता वरोर मेंबर मत्‍तोर. लोकुल्‍क ओन्क कदर हियुंदुर. ओर पेनदा राज्येम बस्के वायार इंचि एदुर हूळसेक मनुंदुर. ओर दैरनेमते पिलातुसनगा होंचि, “येसुना पीनगुन नाक हीम,” इंचि तल्कतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","अस्‍के पिलातुस, “अरे! इच्‍चोन बिराना हातोरा” इंचि इचंत्रम आतोर. पजा नूर मंदि सिपाइल्कुना पोर्रो मनना अदिकारिन केय्‍सि, “येसु हातोरा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","येसु हातोर इंचि ओर अदिकारि वेहतस्के, ओना पीनगुन ओया परांतिन इंचि पिलातुस योसेपुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","अस्‍के योसेपु उंदि पूना कपडि अस्तोर. येसुन क्रुसतगटाल हिळु रेहचि, अद कपडितुन हुटतोर. हुटसि, बंडातुन तुलाह्‍चि तयार कीता बोंदाते दोसतोर. पजा दाना बोंगाकु उंदि पेद्‍दा बंडा अड्‍डम दोसतोर. ");
INSERT INTO esg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","येसुन बोंदाते दोसता जेगातुन मगदलेनि नाटेना मरियम, योसेसुना यावल मरियम इव हूळतां. ");
INSERT INTO esg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","नोमकेमता रोजु मारतारित्‍ते, मगदलेनि नाटेना मरियम, याकोबुना यावल मरियम आनि सलोमि इव येसुना पीनगुंक होकालय, गमागमा गब्‍बु वायानव वस्‍तुक अस्तां. ");
INSERT INTO esg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","वारमता मोदाटा रोज अय्तारम हक्‍केरेने पोळ्‍दु पेय्सता पेय्सुळे बोंदातगा होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","अव होननेंके, “अद बोंदक अड्‍डम दोसता बंडातुन मनाहाटीं बोर गुळाहनुर?” इंचि अवुनद अवे वळ्कसेक होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","अगा एवसि हूळते, अच्‍चोन पेद्‍दा बंडा गूळसि मत्‍तद अवुंक दिसता. ");
INSERT INTO esg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","अव बोंदाते होळियतस्‍के वरोर लेय्या मनकल तेल्‍लाटा कपडिं केर्सि तिना बाजुंक उदिद्‍स मत्‍तद हूळसि अव वेरियतां. ");
INSERT INTO esg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ओर अवुन इल्‍हा इत्‍तोर. “वेरियमट, क्रुसुनपोर्रो वेलाड वाट्‍सि हव्‍कता, आ नासरेत नाटेना येसुन मिमेट पह्कसेक मंतिट, ओर इग्‍गे हिल्‍लोर, जीवाते तेदतोर. इद हुळाट, ओना पीनगु इरता जेगा. ");
INSERT INTO esg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ओर मीक वेहता परकारम, मीकन्‍ना मुन्‍नेने गालिल एरियाते होंचेक मंतोर, अदुनहाटीं मिमेट होंचि ओना सिस्युल्कुंक आनि पत्रुंक वेहाट, अगा ओर मीकु दिस्‍सानुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","अव मुर्ताह्क इरगा वेरियसि वनकालय दल्‍गतां. अदुनहाटीं अव बोंदातगाटाल पलाते पेय्सि विच्‍चि, आ वेर्रेक बोर्क बतल वेहा हिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","वारमता मोदाटा रोज इत्‍ते अय्तारम रोज, येसु हामुरताल जीवाते तेदतोर. तेदता पजा मोट्‍टा मोदाला मगदलेनि नाटेना मरियमुंक दिसतोर. इदे मरियमुनगटाल एडुं देय्याल्कुन येसु गेदमिस मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","अद अगटाल पेय्सि, येसुनतोनि मत्‍ता सिस्युल्कुनगा होत्‍ता. ओर वेल्‍लेने दुक्‍कमते अळसेके मत्‍तुर, ओर्क येसुना बारेमते वेहता. ");
INSERT INTO esg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","येसु जीवाते तेदतोर, अद येसुन हूळता इत्‍ता पोल्‍लेतुन ओर केंजतुर गानि विस्वासम किया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","अद आता पजा, ओरा लोप्पोटाल इव्वुर येरुसलेमताल उंदि नार होंचेके मननेंके, ओर्क वेरे रूपमते येसु दिसतोर. ");
INSERT INTO esg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ओर पज्जो मल्सि होंचि, कळमतोर्कुंक इद पोल्‍ले वेहतुर, गानि ओर ईरा पोल्‍लेन विस्वासम किया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","पजा पदाकोंडु मंदि सिस्युल्कु उद्‍दिसि गाटो तिंचेके मननेंके येसु ओर्क दिसतोर. “नना जीवाते तेदतन इंचि वेल्‍लेटुर मीक वेहिनागानि मिमेट बारि विस्वासम किया हिल्‍लिर? मीवा मनसुक बंडालेसीं मारियतां,” इंचि तेराहतोर. ");
INSERT INTO esg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","पजा ओर्कु इल्‍हा वेहतोर. “मिमेट होंचि दुनियाता अन्‍नि देसेल्‍कुना लोकुल्‍कुंक बेसता कबुर प्रचार कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","बोर अय्ते विस्वासम कीसि, बापतिस्मा एतंतोर ओनके मुक्‍ति दोर्कंता, गानि बोर अय्ते विस्वासम किय्योर, ओनकु पेन सिक्‍साता आदेस हिय्यार. ");
INSERT INTO esg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","नाकुन विस्वासम कियानोनगा इव चिन्‍हां मनंतां, ओर नावा पोरोलते देय्याल्कुन गेदमानुर, वेरे-वेरे बासाने वळ्कानुर, ");
INSERT INTO esg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","तरासकुन पियानुर, बदे विसम वस्तु उनिनागानि ओर्क बतल आयो, बिमार्क मत्‍तुरा पोर्रो ओरा कय्‍क इरते, ओर बेस आयानुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","येसु सामि ओना सिस्युल्कुनतोनि इव पोल्‍लें वेहता पजा, पेन ओन स्वर्गमते तेहकुत्‍ता. अस्‍के ओर दाना तिना बाजुंक उद्तोर. ");
INSERT INTO esg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","पजा येसुना सिस्युल्कु नालुं-मूलां होंचि अन्‍नि जेगाने ओना बारेमते प्रचार कीतुर. सामि ओरतोनि मंचेके कबळ कियुंदुर. कबळ कियनेंके जर्गना चिन्‍हाना हेंदाल सामि ओना पोल्‍ले निजम इंचि रुजुव कियुंदुर. आमेन.");
INSERT INTO esg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","तियपिलुस सायाब, मावा नड्‍डुम येसु कीता कबाह्‍कुना बारेमते वेल्‍लेन लोकुल्‍क रासालय कोसिस कीतुर. बोर अय्ते जर्गुता आ गटनन कळ्‍कुने हूळतुर आनि पेनदा बेसता कबुरतुन कराहतुर, ओरे माकु ई पोल्‍लें एव्विचि हीतुर. माकु एव्ता पोल्‍लेन ननागुडा बेस हदविसि, परमेरका कीसि तेळियागोटकुत्‍तन. अदुनहाटीं इव अन्‍नि पोल्‍लेन बेस उंदान पज्जो उंदि नीकु रासि लोहना इंचि नाकु अनपिस्ता. दीनहेंदाल निमे बतल अय्ते करियतिनो, अदे निजम इत्‍ता संगति नीकु तेळियंता. ");
INSERT INTO esg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहुदिया एरियापोर्रो पेद्‍दा हेरोद राजाल राज्येम कियना कालमते, जकर्याह पोरोलता यहुदि जातितोर वरोर पेर्माल मत्‍तोर. ओर आबिया इनना पेर्मालोरा गेंगुना मेंबर मत्‍तोर. जकरयाहनलेह्का ओना मुत्‍तो एलिसिबालगुडा हारून इनना पेर्माना वंसमतदे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ओर इव्वुरगुडा पेनदा नदरते नीतिमंतुल्क मत्‍तुर आनि सामि वेहता अन्‍नि नियमकु आनि आदेसकुन पीसि दोसेम हिलाकोंटा ताकुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","गानि एलिसिबाल गोडमुर्रादि मत्‍ता. अल्‍हेने ओर इव्वुर वेल्‍लेन मातरालोर आसि मत्‍तुर अदुनहाटीं ओर्कु पिलाल्क आया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","बस्के अय्ते जकरयाना गेंगुनोरद येरुसलेम सहरते मनना गुळिते सेवा कियना वेला वाता, अस्‍के ओर अगा पेर्माल इंचि पेनदा सेवा कीसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","पेर्मालोरा रिवाज मत्‍ताप सिट्‍टिं वाटसि पेनदा गुळिते गुगलेम वाटालय जकरयान पेरतुर. ");
INSERT INTO esg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ओर गुगलेम वाटना वेलाते पलाते जमा आता अंटोर लोकुल्‍क पारतना कीसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","अच्‍चोटेन ओन्क उंदि पेनदा दूता, गुगलेम वाटना गद्‍देता तिना बाजुंक नित्‍तिसि मत्‍तद दिसता. ");
INSERT INTO esg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","जकर्याहल पेनदा दूतातुन हूळसि उल्‍किसि अर्सि इरगा वेरियकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पजा पेनदा दूता ओन, “जकर्याह, वेरियमा. पेन नीवा पारतनातुन केंजता. नीवा मुत्‍तो एलिसिबाल नेला तपसि वरोर पेडन कनंता, निमे ओना पोरोल योहान इंचि इर्रा. ");
INSERT INTO esg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","पेडल पुटताहाटीं नीकु अय्ते वेल्‍लेन कुसि आंता. अचोने आयका वेल्‍लेन लोकुल्‍कुंक इंका आनंदम आंता. ");
INSERT INTO esg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","बारित्‍ते आ पेडल सामिना नदरते पेद्‍दोर आंतोर. ओर अंगुर पंडिना पानकम आयि इंका वेरे बदे कल्‍लु उन्‍नोर. अचोने आयका यावाना पीटे मननास्केटाले ओर पेनदा पवित्र आत्माते निंडसि मनंतोर. ");
INSERT INTO esg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","मीवा वेल्‍लेन इस्राएल लोकुल्‍कुन ओर मीवा पेनदाहेके तिरहंतोर. ");
INSERT INTO esg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ओर, बाबुर्कुना मनसुन मर्क-मियाह्कुनहेके तिरहंतोर. पेनदा पोल्‍लें केंजवोर्कुन नीतिमंतुल्‍कुना तेल्वि दोर्किच्‍कुना वेहंतोर. सामि मीवा नड्‍डुम वायका मुन्‍ने सामिनाहाटीं लोकुल्‍कुन तयार कियालय ई पेडल एलियाहनगा मत्‍ता गुनम आनि ताकततोनि सामि वायना कबुरतुन सामि वायका मुन्‍नेन वेहांतोर,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","पजा, “नना अय्ते मातरन आतन. इंका नावा मुत्‍तोगुडा वेल्‍लेन मातरि आता. अय्ते निमे इत्‍ता पोल्‍ले निजम आयार इंचि नाकु बल्हा तेळियार?” इंचि जकर्याहल पेनदा दूतातुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","अस्‍के पेनदा दूता, “निमे नाकुन बोर इनकुंचंतिन? नना गब्रिएल दूतातुन आंदुन. नना पेनदा मुन्‍ने नित्‍तिसि मनानदुन आंदुन. नीवातोनि वळ्‍कानाहाटीं, इद बेसता कबुर वेहनाहाटीं पेने नाकुन लोहता. ");
INSERT INTO esg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","नना वेहता पोल्‍लें अय्ते वेला वातस्के निजम आयानुंगे, अयना निमे नावा पोल्‍लेपोर्रो विस्वासम इर्रा हिल्‍लिन. अदुनहाटीं नावा पोल्‍ले निजम आयानदाका नीकु वळका वायो, निमे मूकन आसि मनांतिन,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","इदंता जर्गनेंके पलाते नित्‍तिसि पारतना कीसेक मत्‍ता लोकुल्‍क इचंत्रम आसि, जकर्याहल गुळिता लोप्पो इच्‍चोन आलसेम बारि कीसंतोर, इंचेके एदुर हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","पजा जकरयाल गुळिताल पलाते वातोर. गानि ओर लोकुल्‍कुनतोनि वळका पराहिल्‍लोर. अस्‍के लोकुल्‍क, “गुळिता लोप्पो ईर बतलो दर्सनम हूळतोर बारे! अदुनहाटीं वळका पर्राका सय्गें कीसंतोर,” इंचि इनकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","इल्‍हा ओना सेवा कियना रोजकु मारतां, अस्‍के ओर ओना लोन होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","कोन्‍नि रोजकु आता पज्जो, ओना मुत्‍तो एलिसिबाल नेला तपता. नेला तपतस्के अद हेय्युं नेल्कुनदाका लोताल पलाते पेय्साकोंटा लोप्पेन मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","अस्‍के अद, “नाकुन गोडमुर्रद इंचि लोकुल्‍क कव्वुंदुर. गानि लोकुल्‍कुना नड्‍डुम नावा सिग्गु होनानायो इंचि सामि नाकु इल्‍हा सहायम कीतोर,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","एलिसिबाल नेला तप्‍सि हारुं नेल्क आसंतां. अवे तूकुल्कुने पेन, गब्रिएल इनना दाना दूतातुन गालिल एरियाता नासरेत पोरोलता सहरते मनना, ");
INSERT INTO esg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","उंदि मरमिं आयवा पोरिनगा लोहता, आ पोरिन पोरोल मरियम. आ पोरिनद दाविद राजाना वंसमते पुटता योसेप इनना वरोर मनकनतोनि एर्रा बोट्‍टु आसि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","आ गब्रिएल दूता दाना दग्गेर्क होंचि दानतोनि, “पेनदा आसिर्वाद दोर्कुता बाई, नीकु जोहार! पेन नीकु तोळ मंता,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","पेनदा दूताता पोल्‍ले केंजसि मरियम वेल्‍लेन परेसान आता. ई जोहारता अर्तम बतल आयावच्‍चु, इंचि इचंत्रमते अरता. ");
INSERT INTO esg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","अस्‍के पेनदा दूता दान, “मरियम, वेरियमा! पेन नीपोर्रो दया कीता. ");
INSERT INTO esg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","केंजा! निमे नेला तप्पंतिन आनि वरोर मांड्‍सा पेडन कनांतिन. निमे ओना पोरोल येसु (इत्‍ते पेन पिसागोटंता) इंचि दोस्‍सा. ");
INSERT INTO esg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ओन अंटोर ‘अन्‍निटकन्‍ना पेद्‍दा पेनदा मर्रि’ इंचि इनानुर, इल्‍हा ओर पेद्‍दा पोरोलता मनकल आयानुर. ओना वंसमता पेद्‍दा मनकल दाविद राजानलेसीं पेन ओनगुडा राजाल कींता. ");
INSERT INTO esg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","अचोने आयका ओर इस्राएल लोकुल्‍कुनपोर्रो राज्येम कींतोर. इंका ओना राज्येम बस्‍केने मारो,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","अस्‍के मरियम पेनदा दूतातुन, “नावां अय्ते मरमिं इंका आया हिल्‍लें, नाकु मुय्दोगुडा हिल्‍लोर. अय्ते मरि इद बल्हा निजम आयार?” इंचि पूसकीता. ");
INSERT INTO esg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","अस्‍के पेनदा दूता इल्‍हा इत्‍ता, “पेनदा पवित्र आत्मा नीवा पोर्रो वांता आनि अन्‍निटकन्‍ना पेद्‍दा पेनबाबाना ताकतहेंदाल नीवा पोर्रो उंदि नीडा अर्रंता, अस्‍के निमे नेला तप्पंतिन. दानहाटीं नीकु पुट्‍टना पेडल पवित्र मनांतोर, ओन ‘पेनदा मर्रि’ इंचि इंतुर. ");
INSERT INTO esg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","केंजा! नीवा जीवातद एलिसिबा मातिरगुडा नेला तप्‍सि मंता. अंटोर लोकुल्‍क दान गोडमुर्रद इंचि इनुंदुर, गानि अद नेला तप्‍सि हारुं नेल्क आसंता. ");
INSERT INTO esg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","पेन अन्‍नि कबाह्‍क किया पर्रंता, अद किया परवद बतले हिल्‍ले,” इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","अस्‍के मरियम, “नना अय्ते पेनदा सेवा कियनदुन आंदुन, निमे इत्‍तापे नाकु जर्गिकांटी,” इंचि इत्‍ता. पजा पेनदा दूता अगटाल पेय्सि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","पजा अवे रोजकुने मरियम बतल कीता इत्‍ते, बिराना तयार आसि गाबरते गुट्‍टान लोप्पो मनना यहुदिया एरियाता उंदि नाटे होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","नाटे एवतस्‍के अद जकर्याहना लोन होंचि एलिसिबांक जोहार कीता. ");
INSERT INTO esg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","मरियम वळकुता पोल्‍लेतुन केंजसि एलिसिबाना पीटे मत्‍ता पिंडेम मेसुलता, अस्‍के एलिसिबाल पवित्र आत्माते निंडिस होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","निंडिस होंचि अद पेद्‍दा आवाजते, “अन्‍नि मुरताह्कुंकन्‍ना निमे एक्‍को आसिर्वाद दोर्कुता मुरताटुन आंदिन मरियम! अल्‍हेने नीवा पीटे मनना पिंडेमगुडा वेल्‍लेन आसिर्वाद दोर्कुतद आंद. ");
INSERT INTO esg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","नावा सामिना यावल नाकु कलियालय वायमळ इत्‍ते गम्मत पोल्‍ले आयो. इच्‍चोर वेल्‍ले कदर नाकु बगाटाल दोर्कुता? ");
INSERT INTO esg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","हूळा! नीवा अल्किर केंजता केंजुडे नावा पीटे मत्‍ता पिंडेम कुसिते मेसुलता. ");
INSERT INTO esg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","इंका निमे पेन वेहता पोल्‍लेतुन निजम आयि इंचि विस्वासम कीतिन, अदुनहाटीं निमे वेल्‍लेन आसिर्वाद दोर्कुतदुन आंदिन,” इंचि एलिसिबाल इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","पजा मरियम इल्‍हा इनालय दल्‍गता: “नना नावा मनसुनाल पेनदुन तल्‍सकुंतन. ");
INSERT INTO esg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","नाकुन पिसागोटना पेन नावा आत्माकु कुसि हीता. ");
INSERT INTO esg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","नना दाना उंदि सिन्‍ना दासिदान आंदुन, अयना पेन नावापोर्रो दाना दया हुपिस्‍ता. हूळा! इंदकेटाल पीळि-पीळिना अंटोर लोकुल्‍क, नाकुन, ‘पेनदा आसिर्वाद दोर्कुतद,’ इंचि इनानुर. ");
INSERT INTO esg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","बारित्‍ते अन्‍निटकन्‍ना पेद्‍दा पेन नावाहाटीं, पेद्‍दा-पेद्‍दा कबाह्‍क कीता. दानद पोरोल पवित्रमाता पोरोल आंद. ");
INSERT INTO esg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","दानकु वेरियसि दाना कदर कीसेके ताकानोरपोर्रो, दाना दया पीळि-पीळिनदाका मनंता. ");
INSERT INTO esg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","अद दाना ताकत हुपिस्‍ता, गर्रा मत्‍ता लोकुल्‍कुन, ओरा विचाराल्कुन पीसि हिके-हेके पायिस्ता. ");
INSERT INTO esg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","राज्येम कियानोर्कुन, ओरा राजगद्‍दे पोर्रोटाल अद हिळु रेहता. कदर हिलवोर्कुन बारे पेद्‍दा कीता. ");
INSERT INTO esg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","हिल्वोंक गावाले मत्‍तव हीसि समादानम कीता. सिरमंत लोकुल्‍कुन बारे उत्‍ता कय्‍क लोहता. ");
INSERT INTO esg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","अद मना एनकटा पेद्‍दाल्कुंक हीता पोल्‍ले परकारम, दाना सेवा कियना इस्राएल लोकुल्‍कुंक सहायम कीता. इत्‍ते अब्राहाम आनि ओना वंसमतोरपोर्रो, बस्‍केळ्‍क दया कियानदुन मति इरता,” इंचेके मरियम पाटा पारता. ");
INSERT INTO esg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","इल्‍हा मरियम एलिसिबानगा मूड नेलकु मत्‍ता. पजा दाना लोन अद होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","एलिसिबांक नेलां निंडिसि अद पेडन कंता. ");
INSERT INTO esg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","दानकु मर्रि पुटतोर इंचि दाना पक्‍का पीसि मत्‍ता लोहकुनोर्क, जीवातोर्क तेळियता अस्‍के, पेन दानपोर्रो वेल्‍लेन दया कीता, इंचि दानातोनि अंटोरगुडा वेल्‍लेन कूस आतुर. ");
INSERT INTO esg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","आ पेडल एनमिदि रोजकुनोर आतस्के ओना कतना कियनाहाटीं ओर अंटोर वातुर. वासि आ सिन्‍ना पेडाना पोरोल ओना बाबोना पोरोल पोर्रोटाल जकर्याह इंचि दोस्‍सनद मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","गानि पेडाना यावल मात्रम, “मन्‍नि, ई पेडन पोरोल ‘योहान’ इंचि दोसगोम,” इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","अस्‍के दान ओर अंटोर, “निजमे गानि, मीवा जीवातोरा लोप्पो ई पोरोलतोर बोरे मनकल हिल्‍लोर गदा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","पजा ओर ओना बाबान सय्गें कीसि, “निमे ई पेडन पोरोल बतल इर्रांतन इंचि इनकुंचंतिन?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","अस्‍के आ पेडाना बाबाल रासालय उंदि पाटि तल्कतोर आनि, “ओना पोरोल योहान आंद” इंचि रासतोर. अस्‍के रासतदुन हूळसि अंटोर्क इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","अस्‍केन जकरयांक तोड्‍डि वाता. अस्‍के ओर वळ्कसेक पेनदा स्‍तुति कियालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","अगा पकापीसि मत्‍तोर अंटोर इरगा वेरियतुर. इद संगति यहुदिया एरियाता गुट्‍टन पीसि मत्‍ता नाहकुने तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ई संगति केंजता हरेक मनकल विचारम कीसि, “ई पेडल मुन्‍ने ताकसि बतल आयानुर?” इंचि इनुंदुर. बारित्‍ते आ पेडन पोर्रो निजम पेनदा कय मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","पजा आ पेडाना बाबो जकर्याहल पवित्र आत्माते निंडिसि होंचि, इल्‍हा बविस्यवानि वेहालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“मावा इस्राएलतोरा पेनदुन नना तल्‍सकुंतन, बारित्‍ते अद दाना लोकुल्‍कुंक, सहायम कियालय वासि ओर्कु मुक्‍ति हीता. ");
INSERT INTO esg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","पेन दाना पवित्र कबुरतोराहेंदाल वेल्‍ले वर्साना मुन्‍ने इत्‍ताप, अद मावाहाटीं दाना सेवक दाविदना वंसमताल, वरोन वेल्‍लेन ताकत मत्‍ता मुक्‍ति हियानोन लोहचीता. ");
INSERT INTO esg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","मावा पगातोरागटाल आनि हयस्वोरागटाल माकु मुक्‍ति हींता. ");
INSERT INTO esg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","मावा एनकटा तादो-बाबुरापोर्रो दया कीतन इत्‍ता. ओरतोनि कीता पवित्र करारतुन बस्‍केने मति मरगोन इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ई करार मावा एनकटा पेद्‍दा मनकल, अब्राहामुनतोनि तित्‍ता ओट्‍टु आंदु. ");
INSERT INTO esg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","अद करार इल्‍हा मत्‍ता गदा, मिमेट पिसतच्‍चुं रोजकु नीतिते आनि पवित्र मंचेके, वेरियाकोंटा नावा सेवा कियनाहाटीं, नना मीकुन मीवा पगातोरा कयदाल होळसींतन. ");
INSERT INTO esg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ए नावा सिन्‍ना पेडा! इंदके नीकुन अन्‍निटकन्‍ना पेद्‍दा पेनदा कबुरतोर इंचि इंतुर. बारित्‍ते निमे सामिना हर्रि तयार कियालय, ओना मुन्‍ने-मुन्‍ने ताकंतिन. ");
INSERT INTO esg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","मीवा पापाल्क मापि आतेने मीकु मुक्‍ति दोर्कंता, इत्‍ता संगतितुन निमे ओना लोकुल्‍कुंक वेहांतिन. ");
INSERT INTO esg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","बारित्‍ते पेन दाना पेद्‍दा दया मनापोर्रो हुप्पिचि, स्वर्गमताल वरोर पोळ्‍दुनसंटोन लोहंता. ");
INSERT INTO esg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","हामुर इनना नीडा आनि पापमता हीकटते मनना मनापोर्रो, ओर वेल्‍गु अराहचि, मनाकुन सांतिता हर्दे ताकसंतोर.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","इल्‍हा आ पेडल पेद्‍दा बेर्सतोर. अल्हे आत्मातेगुडा बेस गट्‍टिगा आतोर. ओर ओना इस्राएल लोकुल्‍कुंक पेनदा पोल्‍लें वेहना वेला एवनदाका ओर बय्‍लि जेगाने मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","योहान पुटतस्के, रोम सरकारता राजाल कैसर अगस्तुस ओना कय हिळु मनना अन्‍नि देसेल्‍कुना लोकुल्‍कुनद सिरगंति कियना इंचि आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","कुरिनियुस इनना पोरोलतोर सिरिया एरियाता राज्यपाल मननेंके ई सिरगंति आता. इदे मोट्‍टा मोदाटा सिरगंति आंद. ");
INSERT INTO esg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","अय्ते सिरगंतिता आदेस दोर्कुताहेंके अंटोर लोकुल्‍क पोरोलीं रासागोटकुनालय बोना नाटे ओर होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","अल्हेन योसेप दाविद राजाना वंसमतोर मत्‍तोर. अदुनहाटीं ओर गालिल एरियाता नासरेत नाटेनाल यहुदिया एरियाता दाविद राजाना पुटता नार बेतलहेम इनना नाटेंक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ओर सिरगंतिहाटीं नार होननेंके ओनतोनि एर्रा बोट्‍टु आसि मत्‍ता मरियमुन पीसि होत्‍तोर. अस्‍के अद पीटे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ओर अगा मननेंकेन दाना एरपूराना वेला वाता. ");
INSERT INTO esg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","अद दाना तोल्सूर मर्रिन कंता. अगा ओर्कु आगालय बेस जेगा दोर्कुवाहेंके मरियम आ पेडन पेगुने हुटता, हुटसि कोळ्‍कते कोंदाक कुटार तासाना डालाते वाटसि इरता. ");
INSERT INTO esg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","अय्ते अदे नर्का इच्‍चुर गोर्रें मेहानोर नाटेना पलाते नेलिने ओर ओरा गोर्रेना कावेल कीसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","अस्‍के अचानक ओरा मुन्‍ने उंदि पेनदा दूता वासि नितता. अस्‍के सामिना महिमाता वेल्‍गु ओरा सुट्‍टु एल्‍गता. अदुन हूळसि गोर्रें मेहानोर इरगा वेरियकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","अस्‍के पेनदा दूता ओर्कुन, “मिमेट वेरियमट. नना मीवाहाटीं उंदि बेस कबुर पीसि वातन. इद कबुर अंटोर लोकुल्‍कुंक बेस आनंदम हींता. ");
INSERT INTO esg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","इय्याला दाविद राजाना नाटे, मीकुन पिसागोटनोर पुट्तोर, ओरे किरिस्‍तु सामि आंदुर. ");
INSERT INTO esg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ओन मिमेट एरपाट कियना चिन्‍ह बतल इत्‍ते, उंदि कोळ्‍कते पेगुने हुटसि कोंदांक कुटार तासाना डालाते वरोर सिन्‍ना पेडल मीकु दिस्‍सानुर,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","अल्हा इत्‍ता इन्‍मळे इंका वेल्‍लेन पेनदा दूतां वातां. वासि अगा मत्‍ता पेनदा दूतातोनि कलियसि पेनदुन तल्‍सकुंचेके, ");
INSERT INTO esg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“स्वर्गमते पेनदा कदर आयि, बूमिपोर्रो अद पावरम कीता लोकुल्‍कुंक सांति दोर्किकांटी,” इंचि इनालय दल्‍गतां. ");
INSERT INTO esg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","पजा पेनदा दूतां ओर्कुन होळसिसि स्वर्गमते मल्सि होत्‍तां. अस्‍के आ गोर्रें मेहानोर वरोंक-वरोर, “अय्ते ताकट! मनम बेतलहेम नाटे दाकोम. होंचि, सामि मनाकु वेहताप जर्गुता गटनातुन हूळकोम,” इंचि इनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","पजा ओर अगटाल बिराना होंचि अगा मरियमुन, योसेपुन हूळतुर. इंका अगा कोळ्‍कते कोंदांक कुटार तासाना डालाते सिन्‍ना पेडल मत्‍तदगुडा हूळतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","हूळसि, ओर्कु आ पेडाना बारेमते पेनदा दूता बतल वेहतानो, अद पोल्‍लेतुन आ गोर्रें मेहानोर अंटोर्क वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ओर वेहता पोल्‍लेतुन केंजता हरेक मनकल इचंत्रमते अरतोर. ");
INSERT INTO esg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","पजा आ गोर्रें मेहानोर ओर्क पेनदा दूता बतल अय्ते वेहता, अल्हेन जर्गुतदुन केंजसि, हूळसि ओर पेनदुन इरगा स्‍तुति कीसेके मल्सि होत्‍तुर. गानि मरियम मात्रम अव अन्‍नि पोल्‍लेन दाना मनसुने इरकुंचि इदुना अर्तम बतल मरि, इंचेके ऊके विचारम कीसेके मनुंदु. ");
INSERT INTO esg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","इल्‍हा आ पेडल पुटसि एनमिदि रोजकु आतस्के ओनाद कतना रिवाज कीतुर. मरियम नेला तप्पका मुन्‍नेन पेनदा दूता दानकु वेहता परकारम, आ पेडाना पोरोल “येसु” इंचि इरतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","पजा मूसाना नियम परकारम दाना सुद्‍दिकरन कियाना वेला वातस्के ओर येरुसलेम गुळिते होत्‍तुर. होंचि “रोंडु पावरेल्क हिलाकोंटे रोंडु गुव्वां अयना मोक्‍कु हियना.” इंचि मूसाना नियमते रासि मत्‍ताप मोक्‍कु हीतुर. अल्‍हेने मूसाना नियमते, “तोल्सूर पेडन बस्‍केळ्‍क सामिंक हियना.” इंचि वेहचि मंता. अदुनहाटीं सामिना कय्‍दे येसुन अप्पजेपतुर. इल्‍हा ओर सामिना नियम परकारम मोक्‍कु हियालय येरुसलेम होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","अवे तूकुल्कुने येरुसलेमते सिमोन पोरोलतोर वरोर मनकल मनुंदुर. ओर नीतिमंतुड आनि पेनदा पोल्‍लेपोर्रो ताकानोर मत्‍तोर. इस्राएलता लोकुल्‍कुंक पेन बस्के सुकम-सांति हींतनो इंचेके ओर एदुर हूळसेक मनुंदुर. ओनतोनि पवित्र आत्मा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","इंका पवित्र आत्मा, “बदवेरदाका अय्ते निमे, ‘पेन लोहना किरिस्‍तुन’ हूळिन, अदवेरदाका नीकु हामुर वायो,” इंचि ओन्क वेहचि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","पजा पवित्र आत्मा सिमोनुंक वेहताहेंका, योसेप आनि मरियम गुळितगा वाता रोजे ओरगुडा गुळितगा होत्‍तोर. मूसाना नियम परकारम दंडकाल्क कियनाहाटीं पेडाना तल्‍लुर-बाबो पेडन अगा पीसि वातुर. ");
INSERT INTO esg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","सिमोन आ पेडन ओरागटाल तेंडकुंचि एतकुत्‍तोर, एतकुंचि पेनदुन इल्‍हा स्‍तुति कियालय दल्‍गुतोर: ");
INSERT INTO esg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ए सामि, निमे नाकु हीता पोल्‍ले परकारम नीवा सेवक आता नना, इंदके सांतिते हाया परांतन. ");
INSERT INTO esg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","बारित्‍ते निमे पेरकुत्‍ता पिसागोटनोन नना नावा कळ्‍कुन निंडा हूळतन, ");
INSERT INTO esg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","निमे ओन दुनियाता अंटोर लोकुल्‍कुना मुन्‍ने पेर्कुत्‍तिन, ");
INSERT INTO esg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","वेरे जातिनोर्क बेसता हर्रि हुप्‍सना वेल्‍गु, नीवा इस्राएल लोकुल्‍कुंक पेनदाहेंदाल दोर्कुता पेद्‍दातनम ओरे आंदुर.” ");
INSERT INTO esg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","सिमोन मातरल येसुना बारेमते वळकाना पोल्‍लें केंजसि, ओना यावल-बाबल इचंत्रमते अरतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","पजा सिमोन ओर्क आसिर्वाद हीसि, येसुना यावल मरियमुंक इल्‍हा वेहतोर: “हूळा, इस्राएलते ई पेडनहेंदाल वेल्‍लेन मंदि लोकुल्‍कुंक नस्‍टम जर्गार अल्‍हेने वेल्‍लेन मंदि लोकुल्‍कुंक बेसगुडा जर्गार. ई पेडल इत्‍ते पेनदाद उंदि चिन्‍ह आंदुर. ई चिन्‍हातुन वेल्‍लेन मंदि पास्कानुर. ");
INSERT INTO esg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","इदुनहेंदाल वेल्‍लेन मंदिता मनसुना विचाराल्क पलाते अर्रनुं. गानि नीकु मात्रम उंदि कसेर नीवा गुंडेताल आरपार पेय्सि होत्‍ताचोन दुक्‍कम वायार.” ");
INSERT INTO esg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","अगा पेनदा कबुर वेहना उंदि मातिर मनुंदु, दान पोरोल हन्‍ना. अद अस्सेर वंसमते पुटता पनुएल पोरोलतोना मिय्यड आंद. अद वेल्‍लेन मातिर आसि मत्‍ता. मरमिं आता एडुं वर्सानेन दाना मुय्दो हासोत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","इल्‍हा अद मुंडामोससि एनबै नालुं वर्सां आतां. अद रोज-रोज गुळिते वासेके मनुंदु. अद बस्केळक ओक्‍कापोद्‍दु मंचेके पेनदुक पारतना कियुंदु. ");
INSERT INTO esg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","सिमोन मातरल योसेप आनि मरियमुनतोनि वळ्‍कसेकेन मत्‍तोर, अस्‍केन अद ओरा दग्गेर्क वासि पेनदुक दन्यवाद कीता. पजा बोर लोकुल्‍क अय्ते, पेन इस्राएल लोकुल्‍कुन ओरा तिप्पल्कुनाल बस्के पेच्‍हार इंचेक एदुर हूळसेक मत्‍तुरो, आ अंटोर लोकुल्‍कुंक आ पेडाना बारेमते अद वेहता. ");
INSERT INTO esg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","इल्‍हा सामिना नियम परकारम कियानव अन्‍नि दंडकाल्क कियमळ मारतारित्‍ते योसेप आनि मरियम गालिल एरियाते मनना ओरा नासरेत इनना नाटेंक मल्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","पजा आ पेडल पेद्‍दा बेर्सतोर. ओन्क पेन ताकत अल्‍हेने बुद्‍दिगुडा बेस हीता. दाना दया ओनपोर्रो मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","दाटसि होनना पंडुगुनाहाटीं येसुना यावल-बाबल एटा येरुसलेम सहर होनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","अय्ते येसु पन्‍नेंड वर्सानोर आतोर, अस्केगुडा एटा होत्‍ताप येसुन पीसि पंडुगुनाहाटीं येरुसलेम होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","पंडुगु मारतंका येसुना यावल-बाबल ओरा नार मल्सि होनालय पेय्‍सतुर. गानि पेडल येसु मात्रम येरुसलेमतेन आगिसि मत्‍तोर. अयना इद संगति मात्रम ओना यावल-बाबांक बिल्कुल एरपाट आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","मनातोनि कलियसि ताकाना मंदितेन मंतोर बारे, इनकुंचि ओर इंकुंदि रोजमेड ताकसेक होत्‍तुर. पजा ओर ओरा जीवातोर्कुन, एरपाटतोर्कुन पूसकीसेके पहकालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","हीके-हेके पह्‍किसि हूळतुर गानि येसु ओर्कु दिसा हिल्‍लोर. अदुनहाटीं ओर मर्रा ओन पहकसेक-पहकसेक येरुसलेम वापस होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","मूड रोजकु आतस्के गुळितगा येसु ओर्कु दिसतोर. अगा ओर यहुदि गुरुल्‍कुनतोनि उद्‍दिसि ओरा पोल्‍लें केंजसेके इंका ओर्कुन सवाल्क पूसकीसेके मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","येसुना उसारतनमतुन आनि जवाब हियानदुन हूळसि अगा मत्‍तोर अंटोर इचंत्रमते अरतुर. ");
INSERT INTO esg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ओना यावल-बाबल गुडा ओन हूळसि इचंत्रम आतुर. पजा ओना यावल ओन, “निमे मावातोनि इल्‍हा बारि कीतिन पेडा? नीवा बाबल, नना इरगा परेसान आसि नीकुन बगा-बगा पहकतोम नीकु एरके ना?” इंचि पूसकीता. ");
INSERT INTO esg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","अस्‍के येसु ओर्कुन, “मिमेट नाकुन बारिंक पहकतिट? नना नावा बाबाना लोतेन मनमळ बेस इंचि मीकु तेळियोना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","गानि येसु वळकुता पोल्‍लेना अर्तम मात्रम ओना यावल-बाबांक तेळिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","पजा येसु ओना यावल-बाबानतोनि कलियसि नासरेत नार होत्‍तोर. तल्‍लुर-बाबो वेहता पोल्‍ले पोर्रेन ताकसेक मनुंदुर. ओना यावल इव अन्‍नि पोल्‍लें दाना मनसुने इरसि विचारम कीसेके मनुंदु. ");
INSERT INTO esg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","इल्‍हा येसु, बुद्‍दिते, ताकतते बेर्स्‍सेके होत्‍तोर. इंका पेन आनि मनकालोरा नदरतेगुडा बेस ताकुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबेरियुस कैसर इनना वरोर राजाल पूरा रोम राज्येमपोर्रो पेद्‍दा राजाल मत्‍तोर. ओर राज्येम कियालय दल्‍गिसि पदिहेन वर्सां पूरा आतां. अवे तूकुल्कुने पुंतुस पिलातुस इनानोर यहुदिया एरियाता राज्यपाल मत्‍तोर. अंतिपस हेरोद राजाल गालिल एरियाता राज्यपाल मत्‍तोर. इंका ओना तम्मुर पिलिप इतुरिया आनि तारकोनितिस इव एरियान पोर्रो राज्यपाल मत्‍तोर. लिसानियास इनानोर बारे अबिलेन इनना एरियाता राज्यपाल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","अस्‍के हन्‍नाल आनि ओना हडे कयपाल इनानोर इव्वुर पेद्‍दा पेर्मालोर मत्‍तुर. अवे तूकुल्कुने बतल आता इत्‍ते जकर्याहना मर्रि योहान बय्‍लि जेगाते मननेंके ओनगा पेनदा वचनम एव्ता. ");
INSERT INTO esg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","अस्‍के ओर योर्दन बेरेटा सुट्‍टु-मट्‍टुना एरियंता इल्‍हा वेहासेके तिरियुंदुर, “कीता पापाल्कुन ओप्‍कुंचि मनसु मार्सकुंचि बापतिस्मा येतानय्ते, पेन मीवा पापाल्कुन मापि कींता.” ");
INSERT INTO esg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","इल्‍हा यसायाह इनना पेनदा कबुरतोर वेल्‍लेन वर्सां मुन्‍ने रासतद इंदके निजम आता. अद पोल्‍ले इल्‍हा मत्‍ता: “बय्‍लि जेगाते केयानद उंदि अल्किर केंजा वांता, सामि मीवा मनसुने वायनाहाटीं हर्रि तयार कीम्‍ट, इंका ओना हर्कुन सवरगा कीम्‍ट. ");
INSERT INTO esg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","इत्‍ते, अन्‍नि लोद्‍दिं-लोंका निंडमळ गावाले, अन्‍नि गुट्‍टां-गट्‍टुक समानम आयमळ गावाले. वंकर-डिंकर मत्‍ता हर्कु अन्‍नि, सवरगा आयमळ गावाले. उतार-बोगडा मत्‍ता हर्कुगुडा, समानम आयमळ गावाले. ");
INSERT INTO esg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अस्‍के अंटोर लोकुल्‍क पेन मुक्‍ति हियानदुन हूळंतुर.” ");
INSERT INTO esg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","योहानुनाहेंदाल बापतिस्मा येतानाहाटीं लोकुल्‍क पेद्‍दा मंदानां-मंदां वातुर. अस्‍के बापतिस्मा हियना योहान ओर्कुन, “ए कट्‍ला तरासनसंटोरिटा! पेनदा होंगुनाल तपिच्‍कुनालय बापतिस्मा येतट इंचि मीकु बोर वेहतुर? ");
INSERT INTO esg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","अय्ते मरि, निजमे मीवा मनसु मार्सुकुत्‍तिर इंचि रुजुव कीसि हुप्‍सट. वट्‍टिदे, मोमोट अब्राहामुना वंसमतोरम आंदुम, इंचि बस्‍केने इनकुनमट. नना मीकु निजम वेहांतन, पेन अब्राहामनाहाटीं ई बंडानालगुडा पिलाल्क पुट्‍टिचि हिया परंता. ");
INSERT INTO esg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","इंदके मराकुना हिह्‍कुनगा मर्सु इरसि मंता. बव मराकुंक अय्ते बेसता पंडिं हादोंगों, अवुन नर्किसि तडमिते वाटमळ जर्गंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“अय्ते इंदके मोमोट बतल कियना मरि?” इंचि आ लोकुल्‍क योहानुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","अस्‍के योहान, “बोनगा रोंडु अंगिं मंतां, ओर ओनद उंदि अंगि, अंगि हिल्वोंकु हियना आनि बोनगा अय्ते गाटो मंता, ओरगुडा हिल्वोंकु तूस कीसि हियना,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","बापतिस्मा येतनाहाटीं अगा कर वसुल कियानोरगुडा वासि मत्‍तुर. ओर लोकुल्‍कुन वेल्‍लेन मुळाह्‍चि मत्‍तुर. ओरगुडा, “मोमोट बतल कीकोम गुरुजी?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","अस्‍के योहान, “सरकार मीकुन बच्‍चोन जमा कियालय वेहता, अचोने जमा कीम्‍टु, दानकन्‍ना एक्‍को जमा कियमट,” इंचि ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","अस्‍के इच्‍चुर सिपाइल्कगुडा ओनगा वासि, “अय्ते मोमोट बतल कीकोम मरि?” इंचि पूसकीतुर. अस्‍के योहान ओर्क, “मीकु दोर्कना पगारतेन मिमेट कूस मंटु, बोरहेकटाले आयि बेदरिच्‍चि हिलाकोंटे आबद्‍दम तप्पु दोस्‍सि कोत्‍तां येतमट,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","पेन लोहना पिसागोटनोर बिरानेन वायानुर इंचेके लोकुल्‍क बेस आसेते एदुर हूळसेक मत्‍तुर. अदुनहाटीं योहानुन हूळसि, वायनद मत्‍ता किरिस्‍तु ईरे अय्ते आयोर गदा, इल्‍हा अंटोर ओरद-ओरे मनसुल्कुने इनकुनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","अस्‍के योहान ओरा मनसुना विचारमतुन एरपाट कीसि ओर अंटोर्कुन, “नना अय्ते मीकु बापतिस्मा एततोने हींतन. गानि बोर अय्ते वायानोर मंतोर, ओर नाकन्‍ना एक्‍को ताकततोर मंतोर. ओर केरसि मत्‍ता हेरपुह्कुन इट्‍टना विलुवागुडा नाकु हिल्‍ले. ओर मीकु पवित्र आत्मा आनि तळमितोनि बापतिस्मा हींतोर. ");
INSERT INTO esg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ओना कय्‍दे हेती मंता. ओर ओना कडातुन बेस साप कीतारित्‍ते गोह्कुन तूरपाल्क पीसि गुम्मिते दोसंतोर, पोट्‍टुनबारे बस्‍केने पिर्रुवा तडमिते वाटसि बोळसंतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","इल्‍हा योहान वेल्‍लेन पोल्‍लें कराहसेक, ओर्क बेसता कबुर वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","पजा बतल आता इत्‍ते, गालिल एरियाता राजाल हेरोद, ओना तम्मुर पिलिप पिस्सि मननेंकेन ओना मुत्‍तो हेरोदियास इनानदान ओनगा तच्‍चि इरकुत्‍तोर. हेरोद राजाल ओना अंगेनतोनि कीता पापम, इंका वेरे-वेरे वेल्‍लेन तप्पु कबाह्कुनाहाटीं हेरोद राजान योहान तेराहतोर. अदुनहाटीं हेरोद राजाल योहानुन जेलने वाटसि, ओना तप्पुकुने इंकुंदि तप्पु कल्‍पकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","योर्दन बेरेटे योहान वेल्‍लेन लोकुल्‍कुंक बापतिस्मा हीसेक मत्‍तोर. अस्‍के येसुगुडा अगा वासि योहानुना कय्‍दे बापतिस्मा एततोर. बापतिस्मा एततंका येसु पारतना कियनेंके मब्बु अंता बैय्यरा आता. ");
INSERT INTO esg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","अस्‍के पवित्र आत्मा पावरेम पिट्‍टे रूपमते वासि ओनपोर्रो रेयतस्के, स्वर्गमताल उंदि अल्किर इल्‍हा केंजावाता. “निमे नावा पावरमगल्‍ला मर्रिन आंदिन, नना नीकुन वेल्‍लेन जीवा कींतन, नीवा लोप्पो नना वेल्‍लेन आनंदमते मंतन.” ");
INSERT INTO esg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","येसु सेवा कियना कबळ सुरुव कीतस्‍के ओर दग्‍गेर-दग्‍गेरा मुप्‍पै वर्सानोर मत्‍तोर. लोकुल्‍क येसुन, योसेपुना मर्रि इनकुनुंदुर. योसेप एलि पोरोलतोना मर्रि आंदुर. ");
INSERT INTO esg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एलिना बाना पोरोल मत्‍तातु, मत्‍तातुना बाना पोरोल लेवि, लेविना बाना पोरोल मल्कि, मल्किना बाना पोरोल यान्‍ना, यान्‍नाना बाना पोरोल योसेपु. ");
INSERT INTO esg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","योसेपुना बाना पोरोल मत्‍तियाल, मत्‍तियाना बाना पोरोल आमोस, आमोसुना बाना पोरोल नाहोम, नाहोमुना बाना पोरोल एस्‍लि, एस्‍लिना बाना पोरोल नागय्या. ");
INSERT INTO esg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नागय्याना बाना पोरोल मयातु, मयातुना बाना पोरोल मत्‍तियाल, मत्‍तियाना बाना पोरोल सिमय्या, सिमय्याना बाना पोरोल योसेकु, योसेकुना बाना पोरोल योदाल. ");
INSERT INTO esg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाना बाना पोरोल योहानन, योहानननुना बाना पोरोल रेसाल, रेसाना बाना पोरोल जेरुबाबेल, जेरुबाबेलना बाना पोरोल सलितिएल, सलितिएलना बाना पोरोल नेरी. ");
INSERT INTO esg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरीना बाना पोरोल मल्कि, मल्किना बाना पोरोल अद्‍दि, अद्‍दिना बाना पोरोल कोसाम, कोसामुना बाना पोरोल एलमादामु, एलमादामुना बाना पोरोल एर्राल. ");
INSERT INTO esg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर्राना बाना पोरोल यहोसु, यहोसुना बाना पोरोल एलियाजर, एलियाजरना बाना पोरोल योरिमु, योरिमुना बाना पोरोल मत्‍तातु, मत्‍तातुना बाना पोरोल लेवि. ");
INSERT INTO esg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेविना बाना पोरोल सिमोनु, सिमोनुना बाना पोरोल यहुदल, यहुदाना बाना पोरोल योसेपु, योसेपुना बाना पोरोल योनामु, योनामुना बाना पोरोल एलकिमु. ");
INSERT INTO esg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एलकिमुना बाना पोरोल मल्‍लयाल, मल्‍लयाना बाना पोरोल मिन्‍नाल, मिन्‍नाना बाना पोरोल मत्‍तातु, मत्‍तातुना बाना पोरोल नातानु, नातानुना बाबल दाविद राजाल. ");
INSERT INTO esg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाविद राजाना बाना पोरोल यिस्‍सल, यिस्‍साना बाना पोरोल ओबेद, ओबेदुना बाना पोरोल बोआज, बोआजुना बाना पोरोल सलमोनु, सलमोनुना बाना पोरोल नहसोन. ");
INSERT INTO esg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहसोनुना बाना पोरोल अमिनादाब, अमिनादाबुना बाना पोरोल अदमिन, अदमिनुना बाना पोरोल अरनि, अरनिना बाना पोरोल हेसरोन, हेसरोनुना बाना पोरोल पेरेस, पेरेसना बाना पोरोल यहुदा. ");
INSERT INTO esg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहुदाना बाना पोरोल याकोब, याकोबुना बाना पोरोल इसाक, इसाकुना बाना पोरोल अब्राहाम, अब्राहामुना बाना पोरोल तेराहाल, तेराहाना बाना पोरोल नाहोर. ");
INSERT INTO esg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोरुना बाना पोरोल सरुग, सरुगुना बाना पोरोल रेऊ, रेऊना बाना पोरोल पेलेग, पेलेगुना बाना पोरोल एबेराल, एबेरालना बाना पोरोल सेलाल. ");
INSERT INTO esg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","सेलाना बाना पोरोल केनान, केनानुना बाना पोरोल अरपक्‍सद, अरपक्‍सदना बाना पोरोल सेमु, सेमुना बाना पोरोल नोहाल, नोहाना बाना पोरोल लामेक. ");
INSERT INTO esg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लामेकुना बाना पोरोल मतुसेल, मतुसेलना बाना पोरोल हनोक, हानोकुना बाना पोरोल यारेद, यारेदुना बाना पोरोल महलेल, महलेलना बाना पोरोल केनान. ");
INSERT INTO esg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनानुना बाना पोरोल अनोस, अनोसुना बाना पोरोल सेतु, सेतुना बाना पोरोल आदाम, आदाम पेनदा मर्रि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","पजा येसु योर्दन बेरेटाल बापतिस्मा एतसि पवित्र आत्माते निंडतस्के, पेनदा आत्मा ओन बय्‍लि जेगाते पीसि ओता. ");
INSERT INTO esg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","अगा नल्‍पै रोजकुनदाका पेद्‍दा देय्यम ओना पट्‍टु हूळता. अव रोजकुने येसु बतले तिना हिल्‍लोर. अदुनहाटीं अव रोजकु मारतस्के येसुंक इरगा कर्वेस्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","अस्‍के पेद्‍दा देय्यम ओनगा वासि, “ओक्‍कला निमे पेनदा मर्रिन आते ई बंडां हारिं आयिं इंचि आदेस हीम,” इंचि ओन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","इत्‍तस्के, “मनकल सिराप वट्‍टि हारिं तिंचे पिस्‍सोर, गानि पेनदा तोळ्‍दाल पेय्‍सना, उंदि-उंदि पोल्‍लेताहेंदाल पिस्संतोर. इल्‍हा दर्मसास्‍त्रमते रासि मंता,” इंचि येसु दान्क जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","पजा पेद्‍दा देय्यम येसुन उंदि एत्‍तु जेगाते पीसि ओसि, उंदे मल्का दुनियाता अन्‍नि राज्येल्‍क हुपिस्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","हुपिच्‍चि, “इव अन्‍नि राज्येल्कुनपोर्रो अदिकारम आनि अवुना पेद्‍दातनम नीकु हींतन. बारित्‍ते अव अन्‍नि राज्येल्‍क नाके हियमळ जर्गता. नना इद अदिकारम बोन्क इत्‍ते ओन्क हिया परांतन. ");
INSERT INTO esg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","अदुनहाटीं, निमे नावा काल्क मोळ्‍कानय्‍ते इव अन्‍नि नीवांगें आंतां,” इंचि पेद्‍दा देय्यम इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","अस्‍के, “निमे नीवा पेनदुने मोळ्‍कना, सिराप दानादे सेवा कियना, इल्‍हा दर्मसास्‍त्रमते रासि मंता,” इंचि येसु दान इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","आयंका पेद्‍दा देय्यम येरुसलेमते मनना गुळितगा येसुन ओसि, गुळि पोर्रो कोस्‍सक निल्‍हाचि इल्‍हा इत्‍ता, ओक्‍कला निमे पेनदा मर्रिन आते हिळु दुनका. ");
INSERT INTO esg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","बारित्‍ते, “नीकुन कापाळालय पेन दाना दूतांक आदेस हींता, आनि आ दूतां वासि, नीवा काल्कुंक देब्बां दल्‍गामन्‍नि इंचि, नीकुन पोर्रोटद पोर्रेन अंदकुंतां, ");
INSERT INTO esg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","इल्‍हा दर्मसास्‍त्रमते रासि मंता.” ");
INSERT INTO esg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","अस्‍के येसु दान्क इल्‍हा जवाब हीतोर. “निमे सामि इनना नीवा पेनदा पट्‍टु हूळमा, इल्‍हागुडा वेहतद मंता.” ");
INSERT INTO esg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","इल्‍हा पेद्‍दा देय्यम अन्‍नि तीरुकुने येसुना पट्‍टु हूळतारित्‍ते, दान्क इंकुंदि मोका दोर्कनदाका ओन होळसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","पजा येसु पवित्र आत्माता ताकतते निंडसि गालिल एरियाते वापस वातोर, अस्‍के गालिल एरियाता अन्‍नि नाहकुनोर ओना बारेमतेन वळ्‍कुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","येसु ओरा दर्मसास्‍त्रम कराहना लोह्कुने होंचि पेनदा पोल्‍लें करहुंदुर. अंटोर ओन बेस कराहंतोर इंचि कदर हिय्युंदुर. ");
INSERT INTO esg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","पजा येसु सिन्‍नास्केटाल बेर्सता नार नासरेतते होत्‍तोर. वारमता नोमकेम रोजुने ओना अलवट परकारम दर्मसास्‍त्रम कराहना लोते होंचि, दर्मसास्‍त्रम हदवालय निततोर. ");
INSERT INTO esg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","अस्‍के यसायाह इनना पेनदा कबुरतोर रासता पुस्तकम ओन्क हीतुर. ओर आ पुस्तकमते उंदि पोल्‍ले दोर्किच्‍चि, इल्‍हा हदवालय सुरुव कीतोर: ");
INSERT INTO esg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“पेनदा पवित्र सेवक इल्‍हा वेहचंतोर, पेनदा आत्मा नावापोर्रो वाता. गरिबोर्कुंक बेसता कबुर वेहालय, पेन नाकुन अबिसेकम कीता. दोहचि वाटसि ओतोर्कुन, पेन होळसीता इंचि वेहालय, गुड्‍डोर्कुन, मिमेट हूळंतिर इंचि वेहालय, तकलिपते मनानोर्कुन, तकलिपताल तेंडालय, ");
INSERT INTO esg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","पेन दया कियना वेला एव्‍ता, इंचि वेहालय नाकुन लोहता.” इल्‍हा रासि मत्‍तदुन हदुवतोर. ");
INSERT INTO esg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","हदुवमळ आतारित्‍ते, पुस्तकमतुन बंद कीसि वरोर चपरासिंक हीसि कराहलय येसु हिळु उदुतोर. आ दर्मसास्‍त्रम कराहना लोते मत्‍ता अंटोरा नदर ओनहेकेन मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","अस्‍के, “इय्याला मिमेट केंजतव दर्मसास्‍त्रमता पोल्‍लें, मीवा मुन्‍ने नावा कयदाल पूरा आतां,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","“ओर बेस वेहतोर, बेस-बेसतां पोल्‍लें ओना तोळ्‍दाल पेय्सुंदुं,” इंचेके ओर अंटोर इचंत्रम आतुर. आसि ओर, “ईर अय्ते योसेपुना मर्रे गदा?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “‘मत्‍तु हियानोना! नीवद निमेने बेस कीस हुप्‍सा,’ इंचि उंदि सात्रम मत्‍ताप, मिमेट इंका नाकुन तप्‍पाकोंटा इंतिर, इत्‍ते, ‘कपर्नाहुमते निमे कीता अद्‍बूताल्कुना बारेमते मोमोट केंजतोम, अव अद्‍बूताल्‍क नीवा संतम नाटेनेगुडा कीम,’ इंचि इंतिर. ");
INSERT INTO esg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","नना मीकु निजम वेहांतन, बोरे पेनदा कबुरतोंक आयि, ओना नाटेनेन ओन्क कदर मन्‍नो. ");
INSERT INTO esg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","अद बल्हा इत्‍ते, पेनदा कबुरतोर एलियाहना कालमते बतल जर्गुता मीकु एर्केना? अस्‍के पूरा देसेमते मूड वर्सां हारुं नेल्कुनदाका पिर्रु वाया हिल्‍ले, अदुनहाटीं वेल्‍ले कर्वु अर्सि मत्‍ता. नना मीकु निजम वेहांतन, अद वेलाते इस्राएल देसेमते वेल्‍लेने मुंडामोस्ता मुर्ताह्क मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","गानि बदे मुंडामोस्ता मुरतटगा सहायम कियनाहाटीं पेन एलियान लोहा हिल्‍ले. ओन सिराप सिदोन सहर दग्‍गेटा सारपत नाटेना वेरे जातिता मुंडामोस्ता मुरतटगा लोहता. ");
INSERT INTO esg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अल्‍हेने पेनदा कबुरतोर एलिसाना कालमते इंका कुस्‍टरोगम आतोर इस्राएल देसेमते वेल्‍लेटुरे मत्‍तुर. गानि ओराव्टेटाल वरोन इंका बेस कियालय पेन एलिसान लोहा हिल्‍ले. सिराप सिरिया देसेमता नामान इनानोने बेस कीतोर, इल्‍हा बोरे पेनदा कबुरतोंक आयि, ओना नाटेनेन ओन्क कदर मन्‍नो,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","इस्राएल लोकुल्‍कुन होळसि, वेरे देसेमता लोकुल्‍कुन पेन सहायम कीता इंचि येसु वेहतस्के, दर्मसास्‍त्रम कराहना लोते उदिस मत्‍तोर अंटोर्क इरगा होंग वाता. ");
INSERT INTO esg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","होंग वातस्के ओर तेदसि, येसुन ओरा नाटेनाल पलाते गुंजिस ओतुर. ओरा नार उंदि गुट्‍टापोर्रो मत्‍ता. येसुन गुट्‍टा पोर्रोटाल दोब्‍बिसि हियालय एत्‍तु मत्‍तगा ओतुर. ");
INSERT INTO esg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","गानि येसु ओरा नड्‍डुमताल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","अगटाल येसु ओना सिस्युल्कुनतोनि गालिल एरियाता कपर्नाहुम नाटे होत्‍तोर. अगा वारमता नोमकेम रोजुननाड पेनदा पोल्‍लें कराहमळ सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ओर इच्‍चोन अदिकारमते करहुंदुर गदा, ओना कराहमळतुन केंजसि लोकुल्‍क इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","अगा दर्मसास्‍त्रम कराहना लोते वरोर देय्यम पीता मनकल मत्‍तोर. ओर येसुन हूळसि जोरते वरगेयसि केयतोर, ");
INSERT INTO esg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ए नासरेत नाटेना येसु! मातोनि नीकु बाता कबळ? माकुन नासडेम कियालय वातिना? निमे बोन आंदिनो नाक एरपाटे, निमे नासरेत सहरता येसुन, पेनदा पवित्र मनकन आंदिन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","अस्‍के येसु ओनालोप्‍पो मत्‍ता देय्यमतुन, “चुपचाप मन! ओनागटाल पलाते पेय्‍सा,” इंचि गदरिचतोर. अस्‍के, अद ओन हिळु अरहचि, ओन्क बतले नोप्पि कियाकोंटा, ओना लोप्पोटाल पेय्सि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","अगा मत्‍तोर लोकुल्‍क इचंत्रम आसि, वरोंक-वरोर वळकालय दल्‍गतुर, “इद बसोंटा पोल्‍ले आंदु? ओर अदिकारमते, ताकतते देय्याल्‍कुंक आदेस हींतोर, अव पेय्सि दांतां!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","इल्‍हा येसुना पोल्‍लें सुट्‍टु-मट्‍टु मत्‍ता अन्‍नि नाह्कुने तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","येसु दर्मसास्‍त्रम कराहना लोताल पेय्सि सिमोन इननोना लोन होत्‍तोर. अगा सिमोनुना पोरळकु बागा एळकि वासि मत्‍ता. दाना एडकितुन बेस कियालय ओर येसुन विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","अस्‍के येसु दाना दग्‍गेरा नित्‍तिसि एडकितुन गदरिचतस्‍के दाना एळकि रेय्ता. पजा अद बिराना तेदसि, ओरा सेवा कियालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","पजा पोळ्‍द होनना वेलाक तीरतीरकुना बिमार्क मत्‍तोर्कुन लोकुल्‍क ओनगा पीसि वातुर. अस्‍के येसु वरोन-वरोनपोर्रो कय इरसि, ओर्कुन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","वेल्‍लेटोर्कुन देय्याल्क पीसि मत्‍तां. अव देय्याल्कुन येसु गद्‍दरिच्‍चि पेचाहतोर. देय्याल्क ओरागटाल पेय्सनेंके, येसु किरिस्‍तु आंदुर इंचि एरपाट कीसि, “निमे पेनदा मर्रिन आंदिन” इंचेके जोरते वरगेयसेके पेय्सुंदुं. गानि येसे किरिस्‍तु आंदुर इंचि अव एरपाट कियुंदुं इंचि येसु अवुन वळ्का हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","पंगातस्के येसु, नाटुन होळसि बोरे हिल्वगा ओंटिगा होत्‍तोर. गानि लोकुल्‍क ओन पह्‍किसि-पह्‍किसि दोर्किच्‍चि, निमे माकुन होळसि होनमा इंचि आपालय हूळतुर. ");
INSERT INTO esg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","गानि येसु ओर्कुन इल्‍हा इत्‍तोर. “पेन मनकालोरगा राज्येम कियना बेसता कबुरतुन नाकु वेरे नाह्कुने इंका वेहा पींता. इदे कबळताहाटीं पेन नाकुन लोहता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","पजा येसु, यहुदिया एरियाते यहुदिल्कुना दर्मसास्‍त्रम कराहना लोहकुने होंचि पेनदा पोल्‍लें वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","उंदि रोजु येसु गेनेसरेत इनना समुद्रमतगा नित्‍तिसि पेनदा पोल्‍लें वेहासेक मत्‍तोर. येसु ओड्‍डुनपोर्रो नित्‍तिसि पेनदा पोल्‍लें वेहनेंके, आ पोल्‍लें केंजालय अगा वेल्‍लेने लोकुल्‍क ओना सुट्‍टु जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","अस्‍के येसु समुद्रम ओड्‍डुनगा रोंडु डोंगन हूळतोर. जिम्मां पियानोर डोंगानाल रेय्‍सि ओरा ओल्‍लां नोर्सेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","येसु, अव डोंगानाल वरोर सिमोन पत्रु इननोना डोंगाते एकतोर. एकसि, अंटोर्क बेस केंजा वायना इंचि अद डोंगातुन ओड्‍डुनाल इच्‍चुर लक्‍कु ओसि निप्‍सा इंचि वेहतोर. ओर डोंगातुन लक्‍कु निपिस्‍ता पजा, येसु डोंगाते उद्‍दिसि लोकुल्‍कुंक पेनदा पोल्‍लें वेहालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","पेनदा पोल्‍लें वेहमळ आता पजा, “डोंगातुन वेल्‍ले लोतु मत्‍तगा ओसि मिमेट ओल्‍लां मर्रा वाटट,” इंचि येसु सिमोनुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","अस्‍के, “गुरु! मोमोट नर्का पल्हीं तिप्‍पल्‍क अरतोम, माकु उंदिंका जिम्मा दोर्काहिल्‍ले, गानि निमे इंचेके मंतिन अदुनहाटीं नना ओल्‍ला वाटंतन,” इंचि सिमोन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","पजा सिमोन आनि ओना दंटातुर येसु वेहताप कीतुर अय्ते वेल्‍लेने जिम्मां अर्सि ओरा ओल्‍लां हर्रालय आतां. ");
INSERT INTO esg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ओल्‍लां हर्रंतां बारे इंचि वेरे डोंगाते मत्‍ता ओरा दंटातोर्कुन आसरा आयालय सय्गें कीसि केयतस्‍के, ओर वासि रोंडु डोंगाने जिम्मां निहतुर, अस्‍के ओरां रोंड डोंगा इंका मुळगालय आतां. ");
INSERT INTO esg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","वेल्‍लेन जिम्मां अरतद हूळसि, सिमोन पत्रु आनि ओना दंटातुर वेल्‍ले इचंत्रम आतुर. अस्‍के सिमोन येसुना काल्कुना पोर्रो अरसि, “सामि, नना पापि मनकन आंदुन, नीवा दग्‍गेरा मनना लायक हिल्‍लेन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","अल्‍हेने जब्‍दि इननोना मर्क याकोब, योहान, ईर सिमोन पत्रुना दंटातोरे आंदुर, इचंत्रम आतुर. अस्‍के, “निमे वेरिय्मा, गानि इंदकेटाल निमे मनकालोर्कुन पीसि वायानोन आकिन,” इंचि येसु सिमोनुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","पजा ओर ओरा डोंगां ओड्‍डुंक तत्‍तुर. तच्‍चि अव अन्‍नि अग्गेन होळसि ओना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","उंदि रोजु येसु उंदि सहरते मत्‍तोर. अगा वरोर मनकल कुस्‍टरोगमते पूरा निंडसि मत्‍तोर. ओर येसुन हूळसि ओना काल्कुनपोर्रो अर्सि, “सामि, निमे इन्‍कुत्‍ते नाकुन बेस किया पर्रांतिन,” इंचि विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","अस्‍के येसु कय मुन्‍नेळ्‍क कीसि ओन इट्‍सि इल्‍हा इत्‍तोर, “निमे बेस आयगोम इंचि मनसु मंता, बेस आम,” इंचि इत्‍ता इन्‍मळे ओना कुस्‍टरोगम पुरागा होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","पजा, “इगे जर्गतद बोनके वेहमा. गानि निमे होंचि मीवा पेर्मांक हुप्‍सा. पजा मूसाल वेहता मोक्‍कु हीम. अस्‍के निमे बेस आतिन इंचि लोकुल्‍कुंक एरपाट आंता,” इंचि येसु ओन्क गट्‍टिगा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","निमे बोर्के वेहमा इंचि येसु वेहचि मत्‍तोर गानि ओना पोल्‍ले मुन्‍नेटकन्‍ना एक्‍को लोकुल्‍कुंक तेळियसेक होत्‍ता. अदुनहाटीं वेल्‍लेन लोकुल्‍क ओना पोल्‍लें केंजालय, बिमारकुनाल बेस आयालय ओना पज्जो-पज्जो वायुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","गानि येसु बोरे हिल्वगा अलग-सलग होंचि पारतना कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","येसु उंदि रोज वरोन लोन पेनदा पोल्‍लें वेहनेंके, अगा परिसिल्क, आनि दर्मसास्‍त्रम कराहना गुरुल्क उदिस मत्‍तुर. ओर गालिल आनि यहुदिया एरियाना अन्‍नि नाहकुनाल, अल्‍हेने येरुसलेम सहरताल वासि मत्‍तुर. पेनदा ताकत येसु सामिनगा मत्‍ताहेंके बिमारतोर्कुन बेस कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","हूळा! अस्‍के इच्‍चुर लोकुल्‍क वरोर लकवा बिमारतोन कटुलते वाटसि येसुनगा तत्‍तुर. तच्‍चि येसु उद्‍दिसि मत्‍तगा लोप्पो ओयालय हूळतुर. ");
INSERT INTO esg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","गानि अगा वेल्‍ले गर्दि मत्‍ताहाटीं ओर लोता लोप्पो ओया पराहिल्‍लुर. अस्‍के ओर बतल कीतुर इत्‍ते लोतपोर्रो एकतुर, कटुल पियानच्‍चो बोंगा कीसि येसु लोप्पो बगा अय्ते उदिस मत्‍तोरो ओन्क सवरगा आ लकवा बिमारतोन कटुल्क कटुले ओना मुन्‍ने रेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","येसु, ओरा विस्वासमतुन हूळसि, “कोको, नीवा पापाल्क मापि आतां,” इंचि लकवा बिमारतोन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","अस्‍के दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्क केंजसि, “पेनदा अपमानम कियानोर, ईर बोर आंदुर? पेनदुन होळसि इंका बोरे पापाल्कुन मापि किया पर्रुर,” इंचि ओर-ओरे मनसुने विचारम कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","येसु सामि, ओरा मनसुना विचारमतुन एरपाट कीसि, “मी मनसुने इसोंटा विचारम बारि कींतिर? ");
INSERT INTO esg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","बद अल्कगा मंता? ई बिमारतोन, ‘नीवा पापाल्क मापि आतां’ इनमळा? हिलाकोंटे, ‘तेदिस ताका’ इनमळा? ");
INSERT INTO esg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","गानि मनकना रूपमते पुटतोन नाकु, ई बूमिपोर्रोटा पापाल्कुन मापि कियना अदिकारम मंता इंचि मीकु हुप्‍संतन,” इत्‍तोर. इंचि, “नना नीकु वेहासेके, निमे तेदसि कटुल पीसि लोन होन,” इंचि लकवा बिमार आतोन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","अस्‍के ओर बिराना अंटोरा मुन्‍ने तेदसि, बद कटुलते अय्ते ओर मींडसि मत्‍तोर अद कटुल पीकुंचि, पेनदुन तल्‍सकुंचेके लोन होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","अद हूळसि, अगा मत्‍तुर अंटोर वेल्‍लेन इचंत्रम आसि, पेनदुन तल्‍सकुनालय दल्‍गतुर. पजा वेरियसि, “इदवेरादाका मोमोट बस्‍केने इसोंटा इचंत्रम आयना कबाह्‍क हूळा हिल्‍लोम,” इंचि इनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","पजा येसु अगटाल होननेंके, कर वसुल कियना नाकातगा लेवि पोरोलता वरोर कर वसुल कियानोन हूळतोर. हूळसि ओन, “नावा पज्जो वा,” इंचि इत्‍तस्के ");
INSERT INTO esg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ओर, ओनगा मत्‍तव अन्‍नि अग्गेन होळसि ओना पज्जो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","पजा लेवि येसुन ओना लोन केय्‍सि, उंदि पेद्‍दा बोजनम हीतोर. अगा वेल्‍लेटुर कर वसुल कियानोर, इंका वेरेटोर लोकुल्‍क येसुनतोनि उद्‍दिसि गाटो तिंचेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","अस्‍के परिसिल्क आनि ओरा दर्मसास्‍त्रम कराहना गुरुल्क येसुना सिस्युल्कुनगा वासि, “कर वसुल कियानोरतोनि आनि पापि लोकुल्‍कुनतोनि मिमेट तिनुळ-उनुळ बारि तिंतिर,” इंचि गुल्‍गालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","अस्‍के येसु ओर्कु इल्‍हा जवाब हीतोर, “बिमार हिल्‍वोर्कुंक डाक्‍टरना अव्‍सरम मन्‍नो गानि बिमार मत्‍तोर्कुंक डाक्‍टरना अव्‍सरम मनंता. ");
INSERT INTO esg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","नना नीतिमंतुल्‍कुन केयालय आयो गानि पापि लोकुल्‍कुन मनसु मार्सकुननाहाटीं केयालय वातन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","पजा अगा मत्‍ता लोकुल्‍क येसुन इल्‍हा पूसकीतुर, “योहानुना सिस्युल्क अय्ते ऊके ओक्‍कापोद्‍दु मनंतुर, पारतनागुडा कींतुर. अल्‍हेने परिसिल्कुना सिस्‍युल्‍कगुडा कींतुर, गानि नीवा सिस्युल्क अय्ते बस्‍केळ्‍क तिंचेक-उंचेके मनंतुर. अल्हा बारि?” ");
INSERT INTO esg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","अस्‍के येसु ओर्क इल्‍हा वेहतोर, “मरमिन पेडल मरमिं वाता हेडमितोरतोनि मननेंके, ओर्कुन ओक्‍कापोद्‍दु मना वेहा परकिटा? वेहा पर्रिर. ");
INSERT INTO esg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","गानि मरमिन पेडल ओरागटाल लक्‍कु आयाना रोजकु वायनुं, अव रोजकुने ओर ओक्‍कापोद्‍दु मनानुर.” ");
INSERT INTO esg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","पजा, येसु ओर्क इंकुंदि वेसुडि वेहतोर. “बोरे आयिर, पूना कप्‍पिडतुन हराह्‍चि पळाना कप्पिड्‍क अंटा वाट्‍सि कुट्‍टोर. ओक्‍कला ओर अल्हा कियानय्ते पूना कप्‍पिड अय्ते हेळसि दांते, अल्‍हेने पूना कप्‍पिडता तुकडा पळाना कप्पिड्‍क सोकगुडा दिस्सो. ");
INSERT INTO esg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","अल्‍हेने पूना अंगुर पानकमतुन, पळाना तोलपुर्काते बोरे दोस्सुर. अल्हा दोसते अद अंगुर पानकम, पळाना तोलपुर्कातुन हराह्‍चि पोंगिस दांता. पजा आ तोलपुर्कागुडा नासडेम आंता. ");
INSERT INTO esg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","अल्हा कियवा पूना अंगुर पानकम पूना तोलपुर्कातेन दोसना. अस्‍के तोलपुर्कातुन हरहो. ");
INSERT INTO esg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","बोरे आयिर, पळाना अंगुर पानकम उट्‍टारित्‍ते, पूना अंगुर पानकम गावाले इन्‍नोर. ओर पळाना अंगुर पानकमे बेस मंता इंचि वेहांतोर.” ");
INSERT INTO esg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","उंदि नोमकेम रोजुने येसु पोलाल्‍कुनाल होंचेके मत्‍तोर. होननेंके ओना सिस्युल्क हेनकु उरहाचि कय्‍दे नल्‍सि तिंचेके होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","इच्‍चुर परिसिल्क अदुन हूळसि, “नोमकेम रोजुने बद कबळ अय्ते कियमळ नियम परकारम ओज्‍जोनो, अदे कबळ मिमेट बारि कीसंतिर?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","अस्‍के येसु ओर्कुन, “दाविदुंक आनि ओना दंटातोर्कुंक कर्वेस्‍तस्‍के ओर बतल कीतोर, मिमेट हदवा हिल्‍लिरा? ");
INSERT INTO esg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ओर पेनदा लोते होळियसि, पेनदुक मोळ्कता हारिन तित्‍तोर, ओना दंटातोर्कुंकगुडा हीतोर. अव हारिं तिनमळ इत्‍ते दर्मसास्‍त्रम परकारम विरोदमते मत्‍ता. अव हारिं सिराप पेर्मालोर्क तप्‍पा इंका बोरे तिना पर्रुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","पजा, “मनकना रूपमते पुटतोन नना, नोमकेमता रोजुना मालकगुडा आंदुन,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","अल्‍हेने इंकुंदि नोमकेम रोजुने येसु दर्मसास्‍त्रम कराहना लोन होंचि कराहसेक मत्‍तोर. अगा वरोर तिना कय वत्‍सोत्‍ता मनकल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","अद लोतगा इच्‍चुर दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्क मत्‍तुर. नोमकेम रोजुने येसु ओन बेस कींतोरा किय्योरा? बेस कियानय्ते, नोमकेम रोजुने बल्हा बेस कीतोर इंचि तप्पुने पियालय हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","गानि येसु मात्रम ओरा विचाराल्कुन एरपाट कीसि, “तेदसि अंटोरा मुन्‍ने नित्‍ता,” इंचि कय वत्‍सोत्‍तोन इत्‍तोर, इत्‍तस्के ओर तेदसि मुन्‍ने वासि निततोर. ");
INSERT INTO esg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","पजा येसु ओर्कुन इल्‍हा पूसकीतोर, “नना मीकुन उंदि पोल्‍ले पूसकींतन वेहाट. नियम परकारम, नोमकेम रोजुने बेस कियमळ मंचिदा, कराब कियमळ मंचिदा? हिलाकोंटे उंदि जीवातुन पिसागोटते मंचिदा, नासडेम कियमळ मंचिदा? बद बेस” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","येसु अंटोरहेके हूळतोर. पजा, “नीवा कय मुन्‍नेळ्‍क हहा,” इंचि आ कय वत्‍सोत्‍तोन इत्‍तोर. ओर कय मुन्‍नेळ्‍क हाहतस्‍के ओना कय बेस आता. ");
INSERT INTO esg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","गानि परिसिल्कुंक आनि दर्मसास्‍त्रम कराहना गुरुल्कुंक होंग वासि, ओर पलाते पेय्‍स्‍तुर. पेय्सि, येसुन बतल कीते सरे? इंचि ओर-ओरे विचाराल्क कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","पजा उंदि रोज पारतना कियालय येसु गुट्‍टापोर्रो होत्‍तोर. अगा ओर नर्का-पल्‍हिं पेनदुक पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","पंगातस्के ओना सिस्युल्कुन अंटोर्कुन दग्गेर्क केय्‍सि ओराव्टेटाल पन्‍नेंड मंदितुन पेरतोर. पेरसि ओर्कु, प्रेरितुल्क इंचि पोरोल दोसतोर. येसु पन्‍नेंड मंदितुन पेरकुत्‍तोर ओरे प्रेरितुल्क इंचि पोरोल दोसतोर. ");
INSERT INTO esg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","पन्‍नेंड मंदि बोर-बोर इत्‍ते, सिमोन (ईन पत्रु इंचि येसु पोरोल दोसतोर), सिमोनुना तम्मुर अंदरियल, जब्‍दिना मर्क याकोब आनि योहान, पिलिप, बरतलमय, ");
INSERT INTO esg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्‍तयाल (ईर कर वसुल कियना लेवि आंदुर, ईन मत्‍तयालगुडा इंतुर), तोमल, अल्‍पिना मर्रि याकोब, सिमोन जिलोति ");
INSERT INTO esg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","तद्‍दि यहुदल (ईना बाना पोरोल याकोब) आनि इस्‍कारियोत नाटेना यहुदल (ई यहुदले आकिरते येसुन पगातोरा कय्‍दे पीसि हीतोर). ");
INSERT INTO esg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","पजा येसु ओना सिस्युल्कुनतोनि गुट्‍टा पोर्रोटाल हिळु रेय्‍सि, सपाट जेगाते वासि निततोर. अगा ओना वेल्‍लेन मंदि सिस्युल्क मत्‍तुर. अचोने आयाका पूरा यहुदिया एरिया, येरुसलेम सहर, समुद्रम ओड्‍डु पीसि मत्‍ता सूर, सिदोन इनना सहरकुनाल वेल्‍लेटुर लोकुल्‍क ओनगा जमा आसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ओर अंटोर येसु वेहता पोल्‍लें केंजालय, बिमारकुनाल बेस आयालय वासि मत्‍तुर. बोर्कु अय्ते देय्याल्क पीसि मत्‍तंगो ओरगुडा वासि बेस आतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ओनागटाल पेनदा ताकत वासि ओर अंटोर्कुन बेस कियुंदु. अदुनहाटीं आ मंदि अंता ओन इट्‍टालय हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","पजा येसु ओना सिस्युल्कुन हूळसि इल्‍हा इत्‍तोर, “मिमेट बोर अय्ते गरिब मंतिरो, पेन मीकु आसिर्वाद हींता, पेनदा राज्येम मी असंटोरदे आंदु. ");
INSERT INTO esg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","मिमेट बोर अय्ते इंदके कर्वुने मंतिट, पेन मीकु आसिर्वाद हींता, मीवा करवु सल्‍लारंता. बोर अय्ते इंदके अळसेके मंतिट, पेन मीकु आसिर्वाद हींता, वायना रोजकुने मिमेट कव्‍सेक मनंतिर. ");
INSERT INTO esg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","मनकना रूपमते पुटता पेनदा मर्रिना सिस्युल्क आताहाटीं, बस्के अय्ते लोकुल्‍क मीकुन हय्साकोंटा आंतुर, गेदमिसींतुर, अपमानम कींतुर, मिमेट हेळसोत्‍तिर इंचि, मीवा पोरोल एताकोंटा आंतुर, अस्‍के मीकु पेन आसिर्वाद हींता. ");
INSERT INTO esg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ओरा एनकटा पेद्‍दाल्कगुडा मीकन्‍ना मुन्‍नेटा पेनदा कबुरतोर्कुन, इल्हेने तकलिप कीतुर. अदुनहाटीं हुळाट! मीक तकलिप वातस्के, मिमेट कुसिते एगरट, स्वर्गमते मीकु पेद्‍दा इनाम मंता.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","मर्रा येसु इल्‍हा इत्‍तोर, “ए दनवंतुल्कुनिटा! मीकुन पेन बेस हूळो, बारित्‍ते, मीकु सिराप इग्‍गेटा सुकम-सांते दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","इंदके पीरनिंडा तिनना लोकुरिटा! मीकुन पेन बेस हूळो, मुन्‍ने मिमेट कर्वुने मंदकिर. इंदके कव्वानोरिटा! मीकुन पेन बेस हूळो, वायना रोजकुने मिमेट दुक्‍कमते अळकिर. ");
INSERT INTO esg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","इंदके अंटोराहेंदाल कदर दोर्किच्‍कुत्‍तोरिटा! मीकुन पेन बेस हूळो, बारित्‍ते बोर अय्ते मीक कदर हीतुर, ओरा एनकटा पेद्‍दाल्कगुडा, मुन्‍नेटा पेनदा आबद्‍दम कबुरतोर्क कदर हियुंदुर. आ आबद्‍दम कबुरतोर्क दोर्कताप, मीकुगुडा सिक्‍सा दोर्कार.” ");
INSERT INTO esg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","इंदके नावा पोल्‍लें केंजानोरिटा! नना मीक वेहानद बतल इत्‍ते, मीवा पगातोर्कुन पावरम कीम्‍टु. मीकुन हय्सवोर्कुन बेस हुळाट. ");
INSERT INTO esg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","बोर अय्ते मीकु सापनेम हींतोर ओन्क आसिर्वाद हीम्टु. बोर अय्ते मीकुन सिडांचंतोर, ओनाहाटीं पारतना कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","बोरन्‍ना नीवा सेंपापोर्रो तंते ओनाहेके इंकुंदि सेंपागुडा तिरहा. बोरन्‍ना नीवा कोट तेंडकुत्‍ते, ओन नीवा अंगिगुडा ओया हीम. ");
INSERT INTO esg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","बोरन्‍ना नीकुन बतलन्‍ना तल्‍कते, अद ओन्क हीम. बोरन्‍ना मिहागटाल बतलन्‍ना तेंडकुत्‍ते, अदुन वापस तल्कमट. ");
INSERT INTO esg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","लोकुल्‍क मीवातोनि बल्हा मनना इंचि मिमेट इनकुंतिरो, अल्हेन मिमेट ओरतोनि मंटु. ");
INSERT INTO esg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","मीकुन पावरम कियानोर्कुने मिमेट पावरम कीते, मीकु पेनदाहेंदाल बता पायदा दोर्कंता? पापिर्कगुडा ओर्कुन पावरम कियानोर्कुन पावरम कींतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","मीकुन बेस हूळानोर्कुंके मिमेट बेसता कबाह्‍क कीसि हीते, मीकु पेनदाहेंदाल बतल पायदा दोर्कंता? पापि लोकुल्‍कगुडा अल्हे कींतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","बोर वापस हींतुरो ओर्के बाकिक हीते, मीकु पेनदाहेंदाल बतल पायदा दोर्कंता? पापि लोकुल्‍कगुडा वापस दोर्कंतां इत्‍ता आसेते बाकिक हींतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","अल्हा कियाकोंटा मिमेट मीवा पगातोर्कुन पावरम कीसि ओर्कुन बेस हुळाट. बाकि वापस दोहंतोर इंचि आसे इर्राकोंटा बाकि हीम्ट. अस्‍के पेन मीकु पेद्‍दा इनाम हियार, मिमेट अन्‍निटकन्‍ना पेद्‍दा पेनदा मर्क-मियाह्क आकिट. बारित्‍ते, बोर अय्ते पेनदुन मति किय्युर आनि कराब मंतुर असोंटा लोकुल्‍कुनपोर्रो इंका पेन दया कींता. ");
INSERT INTO esg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","मीवा पेनबाबाल दया कियानोर आंदुर, अदुनहाटीं मिमेटगुडा दया कियानोर आम्टु. ");
INSERT INTO esg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“मिमेट वेरेतोरपोर्रो दोसेम दोसमट, अस्‍के मीपोर्रोगुडा पेन दोसेम दोस्‍सो. मिमेट वेरेतोर्कुन, ‘दोसिल्‍क,’ इंचि इनमटु, अस्‍के पेन मीकुनगुडा ‘दोसिल्‍क,’ इंचि इन्‍नो. मिमेट वेरेतोर्कुन मापि कीम्‍टु, अस्‍के मीकुनगुडा पेन मापि किय्‍यार. ");
INSERT INTO esg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","अव्‍सरम मत्‍तोर्कु बीसकेतनम कियाकोंटा हीम्ट, अस्‍के पेन मीकुगुडा हिय्यार. तव्वाते बेस निहचि, अदमिसि, कुदलिचि, पोंगानाल मीवा ओटिते वाटताप, पेन मीकु हिय्यार. बारित्‍ते, बद कोल्ताते मिमेट हींतिरो, अदे कोल्ताते मीकु हियमळ जर्गंता.” ");
INSERT INTO esg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","मर्रा येसु ओर्क उंदि वेसुडि वेहतोर: “वरोर गुड्‍डि मनकल, इंकावरोर गुड्‍डि मनकंक हर्रि हुप्‍सा परांतोरा? अल्हा कीते, ओर इव्वुरगुडा पोक्‍कातेन अर्रंतुर. ");
INSERT INTO esg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","सिस्युड ओना गुरुंकन्‍ना पेद्‍दा आया परोर, गानि गुरुनां पूरा करियसि ओर गुरुनलेसीं आंतोर. ");
INSERT INTO esg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“नीवा कळ्‍दे अरता सित्‍कुन तेंडका, नीवा दंटातोना कळ्‍दे अरता बुस्सितुन निमे बारि तेंडा हूळंतिन? ");
INSERT INTO esg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","नीवा कळ्‍देन सित्‍कु अर्सि मननेंके, नीवा कळ्‍दे अरता बुस्सितुन तेंडाहीम इंचि नीवा दंटातोन बल्हा इना पर्रांतिन? ए डोंगि मनका! मोदाला नीवा कळ्‍दा सित्‍कुन तेंडा. अस्‍के नीवा दंटातोना कळ्‍दा बुस्सितुन तेंडालय नीकु बेस दिस्‍सार.” ");
INSERT INTO esg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","“पंडितुन हूळसे, मिमेट मरातुन एरपाट कीकिर. बेसता मराकु कराब पंडिं हादों, कराब मराकु बेसता पंडिं हादों. हाह्कुना जप्‍पिताल अंगुर पंडिं हादों हिलाकोंटे ईरामुस्‍टी मराकुनाल मरका पंडिं हादों. ");
INSERT INTO esg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","बारित्‍ते, मनसुने मनना पोल्‍लेंगे तोळ्‍दाल पलाते पेय्‍संतां. अदुनहाटीं बेसता मनकल ओना मनसुने मनना बेसता पोल्‍लेंगे पेच्‍हांतोर, अल्‍हेने कराब मनकल ओना मनसुने मनना कराब पोल्‍लेंगे पेच्‍हांतोर.” ");
INSERT INTO esg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“नना वेहता पोल्‍लेन केंजिर अय्ते नाकुन सामि सामि इंचि बारि इंतिर? ");
INSERT INTO esg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","बोरे आयिर नहगा वासि, नावा पोल्‍लें केंजसि, दाना परकारम ताकाना हरेक मनकल, ओर बसंटोर आंदुर वेहंतन केंजाट. ");
INSERT INTO esg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ओर बसंटोर इत्‍ते, लोन दोहनेंके पायवा लोत तव्विसि, बंडातोनि पुनादि दोहचि लोन दोहतोर. बस्के अय्ते कम्मुड वाता, एता तडां वासि लोतुक दल्‍गतां. अय्नागानि अद लोन कूला हिल्‍ले. बारित्‍ते, अद लोन गट्‍टिगा दोहचि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","गानि नावा पोल्‍लें केंजसि दाना परकारम ताकवा मनकल बसंटोर इत्‍ते, लोन दोहनेंके पुनादि दोहाकेन बूमिपोर्रो लोन दोहतोर. बस्के अय्ते एता तडां वासि लोतुक दल्‍गतां. अस्‍के अद लोन पूरा कूल्‍सि पाड आता,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","लोकुल्‍कुंक वेहना मत्‍ता अन्‍नि पोल्‍लें वेहतारित्‍ते येसु कपर्नाहुम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","अगा वरोर रोम सरकारता दरोगाल मत्‍तोर. ओना वरोर दासुड बिमारते हायनाल आसि मत्‍तोर. ओन दरोगाल बागा पावरम कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","आ दरोगाल येसुना बारेमते बस्के अय्ते केंजतोरो, अस्‍के इच्‍चुर यहुदि पेद्‍दाल्कुनतोनि, “मिमेट येसुनगा होंचि, ‘दरोगाना दासुड बागा बिमारते मंतोर, ओन बेस कियालय नीकुन वा इंचि वेहालय माकुन लोहतोर,’ इंचि वेहाट,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","ओर येसुनगा वासि, “आ दरोगाल बेसतोर आंदुर, ओर मावा यहुदि लोकुल्‍कुन पावरम कींतोर. ओर मावाहाटीं दर्मसास्‍त्रम कराहना लोनगुडा दोहचीतोर, अदुनहाटीं निमे ओन्क सहायम कीम,” इंचि येसुन बतिमलाडसेके विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","अस्‍के येसु ओरतोनि पेय्सतोर. ओर दरोगाना लोतुक दग्‍गेरा एवतस्‍के, ओर ओना दंटातोर्कुन येसुनहेके इल्‍हा वेहालय लोहतोर. “सामि, निमे तकलिप अरमा. निमे नावा लोन वायानच्‍चो पेद्‍दातनम नहगा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","अचोने आयका नना नीकु कलियाना लायकगुडा हिल्‍लेन. अदुनहाटीं निमे सिराप उंदि पोल्‍ले इन, नावा जीतागाड बेस आंतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","बारित्‍ते, ननागुडा वरोर अदिकारिना कय्‍दा हिळु कबळ कींतन. नावा कय्‍दा हिळुगुडा सिपाइल्क मंतुर. नना बोनना वरोन ‘होन’ इत्‍ते ओर दांतोर, इंकावरोन ‘वा’ इत्‍ते ओर वांतोर. इंका नावा दासुन, ‘इद कीम’ इत्‍ते ओर कींतोर.” ");
INSERT INTO esg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","इद केंजसि येसुंक वेल्‍ले इचंत्रम आता. अस्‍के पजोळ्क तिरियसि, ओना पज्जो वासेक मत्‍ता मंदितुन इल्‍हा इत्‍तोर, “नना वेहानद केंजट, इस्राएल लोकुल्‍कुन लोप्‍पोगुडा इच्‍चोन विस्वासम मत्‍ता मनकल नाकु बग्‍गेन दोर्का हिल्‍लोर.” ");
INSERT INTO esg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","येसु सामिनहेके लोहचीता दंटातोर मल्सि दरोगाना लोन वातस्के ओना दासुड बेस आसि दिसतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","पजा येसु नाईन इनना नाटेनहेके पेय्सतोर. ओनतोनि ओना सिस्युल्क इंका वेल्‍लेटुर लोकुल्‍क मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","येसु नाटेने होळियाना गेटुना दग्गेर्क एवतोर, अच्‍चोटेन वरोन हातोन बोंदा दोसालय ओसेके मत्‍तुर. हातोना यावल मुंडामोसि मत्‍ता. दानकु ईर वरोरे मर्रि मत्‍तोर. नाटेनोर वेल्‍लेटुर लोकुल्‍क दानतोनि पेय्‍सतुर. ");
INSERT INTO esg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","येसु सामिंक दान हूळसि दया वाता, अस्‍के “निमे अळमा बाई,” इंचि, ");
INSERT INTO esg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","दग्‍गेरा होंचि पाडेतुन इटतोर. अस्‍के पाडेतुन कांजानोर अग्गेन आगतुर. अस्‍के येसु, “पेडा तेदा!” इंचि हातोन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","इत्‍तस्के, आ हासोत्‍ता पेडल तेदिस उद्‍दिसि वळकालय दल्‍गतोर. पजा येसु ओन ओना यावंक अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","अगा मत्‍तोर अंटोर्क वेर्रे दल्‍गता, ओर वेरियसि, “पेन दाना लोकुल्‍कुंक सहायम कियालय वाता, मना नड्‍डुम दाना पेद्‍दा कबुरतोन लोहचीता,” इल्‍हा इंचेके पेनदुन तल्‍सकुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","येसुना इद पोल्‍ले यहुदिया एरिया आनि पक्‍का पीसि मत्‍ता अन्‍नि नाह्कुने तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","जर्गतव इव अन्‍नि पोल्‍लेना बारेमते, बापतिस्मा हियना योहान जेलने मननेंके ओना सिस्युल्क होंचि ओन्क वेहतुर. अस्‍के ओर, ओना सिस्युल्‍कुनाल इव्वुर्कुन केय्‍सि, “बोर अय्ते पिसागोटनोर वायानद मत्‍ता, ओन निमेन ना? हिलाकोंटे मोमोट इंकावरोना एदुर हूळमळा?” इंचि पूसकियालय ओर्कुन सामिनगा लोहतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","अस्‍के ओर सामिनगा वासि, “गुरु, ‘बोर अय्ते पिसागोटनोर वायनद मत्‍ता, ओन निमेन ना? हिलाकोंटे मोमोट इंकावरोना एदुर हूळमळा?’ इंचि नीकुन पूसकियालय, बापतिस्मा हियना योहान माकुन लोहतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","अस्‍केने येसु, बिमार मत्‍तोर्कुन, नोप्पिनोर्कुन, देय्याल्क पीसि मत्‍तोर्कुन इल्‍हा वेल्‍लेटोर्कुन बेस कीतोर, वेल्‍लेटुर गुड्‍डोर्कुना कळकु दिस्‍सानाल कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","पजा ओर्कु इल्‍हा जवाब हीतोर. “इंदके मिमेट बतल अय्ते हूळतिर, केंजतिर अद होंचि योहानुंक वेहट. गुड्‍डोर्क हूळसंतुर, कुंटोर्क ताकसंतुर, कुस्‍टरोगम आतोर बेस आसंतुर, सेव्टोर्क केंजसंतुर, हातोर्कुंक जीवां अरसंतां आनि गरिबोर्कुंक बारे बेसता कबुर एवसंता. ");
INSERT INTO esg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","बोर अय्ते नावा बारेमते अन्‍समन्‍स किय्योर, ओन्‍के आसिर्वाद दोर्कंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","योहानुना सिस्युल्क अगटाल पेय्सि होत्‍तस्के, योहानुना बारेमते लोकुल्‍कुंक येसु इल्‍हा वेहालय दल्‍गतोर, “मिमेट बय्‍लि जेगाते बतल हूळालय होत्‍तिर? वळिक ऊंगना जाडितुना? ");
INSERT INTO esg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","हिलाकोंटे मिमेट बतल हूळालय होंचि मत्‍तिर? मेत्‍तटा कपडिं केर्ता मनकन हूळालय होत्‍तिरा? हुळाट! मेत्‍तटा कपडिं केर्रानोर आनि सिरमंतुल्‍क राजवाडाने मनांतुर, बय्‍लि जेगाते आयो! ");
INSERT INTO esg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","अय्ते मरि मिमेट बतल हूळालय होत्‍तिर? पेनदा कबुरतोन हूळालय होत्‍तिरा? हो! नना मीकु वेहासेक मंतन, मिमेट बोन अय्ते हूळतिर ओर पेनदा कबुरतोनकन्‍ना बच्‍चोरो पेद्‍दा मंतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ओना बारेमते पेन मुन्‍नेने इल्‍हा वेहचि मत्‍ता. “हूळा! नना नीकन्‍ना मुन्‍नेने नावा कबुरतोन लोहंतन, निमे वायानाहाटीं ओर हर्रि तयार कींतोर.” इंचि दर्मसास्‍त्रमते रासि मंता. ");
INSERT INTO esg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“नना मीकु वेहानद बतल इत्‍ते, पुट्तोराव्‍टेटाल योहानुंकन्‍ना पेद्‍दा बोरे हिल्‍लोर. अय्नागानि पेनदा राज्येमते सिन्‍ना मनकलगुडा योहानुंकन्‍ना पेद्‍दोडे,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","अस्‍के वेल्‍लेटुर लोकुल्‍क आनि कर वसुल कियानोरगुडा येसु वेहता पोल्‍लेन केंजतुर. केंजसि, पेनदा हर्रि नीतिता हर्रि, इंचि इत्‍तुर. ओर्क अंटोर्क योहान मोदालेन पेनदा पोरोलते बापतिस्मा हीसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","गानि परिसिल्क आनि मूसाना नियम बेस तेळियतोर बारे योहानुनाहेंदाल पेनदा पोरोलते बापतिस्मा एतुवा, पेन ओर्क हुपिस्‍ता हर्दे ताका हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","मर्रा येसु इल्‍हा वळकालय दल्‍गतोर, “ई पीळिता लोकुल्‍क बोरालेसीं मंतुर इंचि, ओर्कुन बोरा लोप्पो कल्‍पकन? मिमेट अय्ते चौकुने उद्‍दिसि, वरोंक-वरोर केय्‍सि, “मोमोट मीहाटीं दुक्‍कमता पाटां पारतोम, अयना मिमेट अळा हिल्‍लिर. मोमोट मीहाटीं तूरीला उह्कुतोम, गानि मिमेट एगरा हिल्‍लिर, इंचि इनना पिलाल्कुनालेसीं मंतिर.” ");
INSERT INTO esg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“अल्‍हेने बापतिस्मा हियना योहान एक्‍कोते एक्‍को ओक्‍कापोद्‍दु मनुंदुर. अंगुर पंडिना पानकमगुडा उनाकोंदुर, अयना मिमेट ओन, देय्यम पीता इंचि इत्‍तिर. ");
INSERT INTO esg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","गानि मनकना रूपमते पुटतोन नना तिंचेके-उंचेके वातन. गानि मिमेट मात्रम, ‘हुळाट, ओर बच्‍चोर तिंतोर, बच्‍चोर उंटोर? कर वसुल कियानोर आनि पापि लोकुल्‍क ओना दंटातोर आंदुर,’ इंचि नाकुन इंतिर. ");
INSERT INTO esg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","गानि पेनदा बुद्‍दि नीतितद आंद इंचि, दाना बुद्‍दिते ताकानोर कियाना कबाह्‍कुन पोर्रोटाल तेळियंता.” ");
INSERT INTO esg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","उंदि मल्का सिमोन इनना वरोर परिसि मनकल ओना लोन गाटो तिनालय येसुन केयतोर. अस्‍के येसु ओना लोन होंचि गाटो तिनालय उदतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","हुळाट! आ नाटेने उंदि पापि मुरतळ मत्‍ता. येसु वरोर परिसिन लोन गाटो तिंचंतोर इंचि दान्क तेळियतस्के अद उंदि बंडाता गुर्गिते बेस गमागमा गब्‍बु वायना अत्‍तर निय पीसि वाता. ");
INSERT INTO esg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","वासि येसुना पज्जो नित्‍तिसि अळसेके दाना कळ्‍कुनाल पोंगाना एरतोनि येसुना काल्‍कुन नहालय दल्‍गता. पजा दाना केल्कुनतोनि उसुमसेके, ओना काल्‍कुन बुर्सेके अत्‍तर निय होकुंदु. ");
INSERT INTO esg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","अल्हा कियानद हूळसि, बोर अय्ते येसुन केयतोरो आ परिसि इल्‍हा इन्कुत्‍तोर गदा, “इद अय्ते पापि मुरतळ आंदु! ईर निजमे पेनदा कबुरतोर आसि मत्‍ते, ओन इट्‍टानद बसोंटा मुरतळ आंद इंचि ओन्क तेळियसि मनवळ. पापि मुरतळ इटते मुट्‍टुळ इंचि दान इट्‍टा हियाकोन्‍नेर,” इंचि ओर इनकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","अस्‍के येसु ओना मनसुन एरपाट कीसि, “सिमोन, नीकुन उंदि पोल्‍ले पूसकियना मंता,” इंचि इत्‍तस्के ओर, “वेहा गुरुजी,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","अस्‍के येसु उंदि वेसुड वेहतोर, “इव्वुर मनकालोर वरोर सावकारनगटाल बाकि तेंडतुर, वरोर बारे हेय्युं नुह्कु, इंकावरोर बारे एबै एंडि बंडिं. ");
INSERT INTO esg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","गानि ओर बाकि दोहा पराहिल्‍लुर. अदुनहाटीं सावकार ओरा इव्वुरा बाकितुन मापि कीतोर. अय्ते इंदके ओरा इव्वुरा लोप्पोटाल सावकारुन बोर एक्‍को पावरम कींतोर, वेहा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","अस्‍के, “बोर अय्ते एक्‍को बाकि मत्‍तोर, ओरे एक्‍को पावरम कियानुर बारे,” इंचि सिमोन इत्‍तोर. इत्‍तस्के, “निमे बरोबर वेहतिन,” इंचि येसु ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","येसु मुरतटहेके तिरियसि सिमोनुन इल्‍हा इत्‍तोर, “निमे ई मुरताटुन हूळा. नना नीवा लोन वातन, निमे नावा काल्क नोर्रालय एरगुडा हिय्या हिल्‍लिन. गानि इद बारे दाना कांडेह्कुनतोनि नावा काल्‍कुन नाहचि, केल्कुने उसुमता. ");
INSERT INTO esg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","निमे नाकुन बुर्सि जोहार किया हिल्‍लिन, गानि नना लोप्पो होळियतस्केटाल इद नावा काल्‍कुन बुर्सेके मंता. ");
INSERT INTO esg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","निमे नावा तल्‍लक निय होकसि नाकु कदर हिया हिल्‍लिन, गानि इद नावा काल्कुंक वेल्‍लेन दराता अत्‍तर निय होकता. ");
INSERT INTO esg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","अदुनहाटीं नना नीकु वेहानद बतल इत्‍ते, दाना अन्‍नि पापाल्क मापि आतां इंचि अद वेल्‍लेन पावरम कीता, गानि बोनद इच्‍चुने पापम मापि आता, ओर इच्‍चुने पावरम कींतोर.” ");
INSERT INTO esg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","पजा येसु, “नीवा पापाल्क मापि आतां,” इंचि आ मुरतटुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","अस्‍के, “ईर बोर आंदुर, ओनद ओर पेन इन्कुंचि, पापाल्कुन मापि कींतोर?” इल्‍हा ओनतोनि गाटो तिंचेक उदिस मत्‍तुर अंटोर ओरद-ओरे वळ्ककुनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पजा, “निमे नावापोर्रो विस्वासम कीताहाटीं पेन नीकु मुक्‍ति हीता, निमे सांतिते होन,” इंचि येसु आ मुरतटुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","पजा इल्‍हा जर्गुता गदा, येसु अन्‍नि सहरकुने, नाह्कुने पेनदा राज्येमता बारेमता बेसता कबुर वेहासेके तिरियालय दल्‍गतोर. ओनतोनि पंन्‍नेड मंदि प्रेरितुल्क मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","अगा देय्याल्कुनाल, बिमारकुनाल बेस आतव इच्‍चुं मुर्ताह्कगुडा ओरतोनि मत्‍तां. अव मुर्ताह्कुनाल उंदि मगदलेनि नाटेनद मरियम पोरोलता मुरतळ मत्‍ता. येसु दानगटाल एडुं देय्याल्कुन पेचाह्‍चि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","इंकुंदि मुरतळ योहानि इनानद, हेरोद राजाना दिवांजि कोजा इननोना मुत्‍तो मत्‍ता. अल्‍हेने सुसान्‍नल आनि वेल्‍लेन मुर्ताह्कगुडा मत्‍तां. इवन्‍नि मुर्ताह्क येसु आनि ओना सिस्युल्कुना सेवाताहाटीं अवुना संतम कोत्‍तन कर्स कियुंदुं. ");
INSERT INTO esg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","अल्‍हेने उंदि रोजु वेरे-वेरे नाहकुनाल वेल्‍लेटुर लोकुल्‍क येसुनगा वासि जमा आसेक मत्‍तुर, अस्‍के येसु ओर्क उंदि वेसुड वेहतोर. अद इल्‍हा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“वरोर कास्‍तकरि मनकल विज्‍जां वीतालय पेय्‍स्‍तोर, विज्‍जां वीतनेंके इच्‍चुं विज्‍जां हरदगा अरतां. अव विज्‍जन हर्रि पीसि होनानुर-वायानुर जारतुर, पजा अवुन पिट्‍टें वासि पेर्सि तित्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","इच्‍चुं विज्‍जां बंडाना जेगाते अर्सि अव मोलियतां. गानि अगा पदन दोर्कवाहाटीं वत्‍सि हासोत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","इच्‍चुं विज्‍जां हाह्कुना पोदाने अरतां. अवुनतोनि हाह्कुना पोदांगुडा बेर्सि अव विज्‍जन बेर्सा हिया हिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","इच्‍चुं विज्‍जां बेसता जेगाते अरतां. अव बेस मोलियसि नूर अंताल्कुना पंटा पेय्‍स्‍ता,” इंचि वेहचि, “बोर्कु केंजालय केव्क मंतां ओर केंजट,” इंचि जोरते इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","“ई वेसुडिता अर्तम बतल गुरु?” इंचि ओना सिस्युल्कु पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “मीक अय्ते पेनदा राज्येमता बारेमता मर्ममतुन एरपाट कीकुनालय बुद्‍दि मंता. गानि वेरेतोर्कुंक बारे वेसुडिने वेहांतन. इल्‍हा कीते “ओर नावा कबाह्‍कुन हूळांतुर, गानि अव कबाह्‍कुन अर्तम कीकुन्‍नुर. ओर केंजांतुर गानि तेळियागोटकुन्‍नुर.” ");
INSERT INTO esg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“इद वेसुडिता अर्तम इल्‍हा मंता, विज्‍जां इत्‍ते पेनदा पोल्‍ले आंदु. ");
INSERT INTO esg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","बोर अय्ते पेनदा पोल्‍लेतुन केंजतुर गानि, ओर विस्वासम कीसि ओर्कु मुक्‍ति दोर्कामन्‍नि इंचि देय्यम वासि ओर केंजतवुन ओरा मनसुनाल तेंडसि पोहंता. असंटोर इत्‍ते, विज्‍जां अरता हर्दा जेगातसंटोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","विज्‍जां अरता बंडाना गेर्से जेगातसंटोर बोर इत्‍ते, बोर अय्ते पेनदा पोल्‍लेतुन कुसिते केंजसि दान ओप्‍कुंतुर. गानि ओरा मनसुने पेनदा पोल्‍ले गट्‍टि पळुवाहाटीं, ओर कोन्‍नि रोजके विस्वासमते मनांतुर. पजा पट्‍टु हूळना वेला वातस्के विस्वासमताल ओर लक्‍कु आंतुर. ");
INSERT INTO esg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","विज्‍जां अरता हाह्कुना पोदाना जेगातसंटोर बोर इत्‍ते, बोर अय्ते पेनदा पोल्‍लें केंजांतुर गानि विस्वासमते मननेंके सम्‍सारमता रंदि, दनमता आस्‍ति, दुनियाता सुकाल्क इव अन्‍नि ओर्कुन पेनदा पोल्‍लेन लोप्पो बेर्सा हिय्यों. अदुनहाटीं पेनदा पोल्‍लेनहेंदाल ओर्क बतल पायदा वायो. ");
INSERT INTO esg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","गानि विज्‍जां अरता बेसता जेगातसंटोर बोर इत्‍ते, बोर अय्ते पेनदा पोल्‍लेन सत्‍तेम, बेस मनसुने केंजसि, अव पोल्‍लेन मनसुने इर्रंतुर. पजा ओर्क बच्‍चोन तकलिप वायना गानि ओप्‍केते बेसता कबाह्‍क कींतुर, असंटोर इत्‍ते विज्‍जां अरता बेसता जेगातसंटोर आंदुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“बोरे आयिर वेडसि निरिच्‍चि गंजुना हिळु मुच्‍चोर, कटुल हिळुगुडा इर्रोर. गानि लोप्पो होळियानोर्क बेस वेल्‍गु दिसगोम इंचि दान उंदि दीसोडिपोर्रो इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","अल्‍हेने मक्‍किस मत्‍तव अन्‍नि दिस्‍सि अर्राकोंटा मन्‍नों, आनि मर्ममते मत्‍तव बवे पलाते अर्राकोंटा मन्‍नों. ");
INSERT INTO esg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","अदुनहाटीं बेस मनसु तासि केंजट. बारित्‍ते, बोनगा अय्ते पेनदा पोल्‍लेन तेल्‍पिचकुनना बुद्‍दि मंता, पेन ओन्क इंका हींता. गानि बोनगा अय्ते पेनदा पोल्‍लेन तेल्‍पिचकुनना बुद्‍दि हिलाकोन्‍ना, मंता इनकुंतोर, अदुनगुडा पेन एतकुन्‍नार,” इंचि येसु ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","अस्‍के येसुना यावल, ओना तम्मुह्‍क ओनगा कलियालय वातुर. गानि गर्दि मत्‍ताहाटीं ओर ओनकु कलिया पराहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","अदुनहाटीं, “नीवा यावल, नीवा तम्मुह्‍क नीकु कलियालय पलाते नित्‍तिसि मंतुर,” इंचि बोरो येसुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","अस्‍के, “बोर अय्ते पेनदा पोल्‍लें केंजसि अल्‍हेने ताकंतुरो, ओर्कुने नावा यावल, नावा तम्मुर इंतन,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","उंदि रोज येसु ओना सिस्युल्कुनतोनि डोंगाते उद्‍दिस, “मनम समुद्रमता हब्बेटा बाजुंक दाकोम दट,” इंचि इत्‍तस्के ओर होनालय पेय्‍सतुर. ");
INSERT INTO esg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ओर डोंगाते उद्‍दिस होननेंके येसु निद्रा होत्‍तोर. अस्‍के समुद्रमते पेद्‍दा वळि-दुमारम वाता. अदुनहेंदाल डोंगाते एर निंडालय दल्‍गिसि, ओर वेल्‍ले दोकाते मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","अस्‍के सिस्युल्क येसुनगा होंचि, “गुरु, गुरु मनम नासडेम आसि होंचंतोम,” इंचि इत्‍तुर. अस्‍के ओर तेदसि वळि-दुमारमतुन, एता तडान गदरिचतोर अय्ते वळि-दुमारम आगता, तडांगुडा दिसाकोंटा आतां. ");
INSERT INTO esg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","अस्‍के, “मिमेट नावापोर्रो विस्वासम बारि इर्रा हिल्‍लिर?” इंचि येसु ओर्कुन इत्‍तोर. गानि ओर इरगा वेरियसि, इचंत्रमते, “ईर आदेस हीते ईना पोल्‍ले वळि, एता तडांगुडा केंजंतां, ईर बोर आंदुर?” इंचि ओर ओरे वळ्‍ककुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","पजा ओर गिरासेन इनना वेरे देसेमते एव्‍तुर, अद जेगा गालिल समुद्रमता हब्बेटा बाजुंक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","येसु डोंगाताल बल्हा रेयतोर अल्‍हेने अद सहरतोर वरोर देय्याल्क पीसि मत्‍ता मनकल अगा वातोर. ओर वेल्‍लेने रोजकुनाल कपडिं केर्राकोंदुर, लोन मनाकोंदुर, ओर तापळानेन मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","देय्यम ओन ऊके-ऊके पिय्‍युंदु, लोकुल्‍क ओन गोल्सुकुने दोहचि कावेल मनुंदुर. गानि ओर गोल्सुकुन नेम्‍हुंदुर, अस्‍के देय्यम ओन बोरे हिल्वगा ओयुंदु. येसु अद देय्यमतुन ओनागटाल पेय्सि होनालय आदेस हीतोर. अदुनहाटीं ओर येसुन हूळसि, “ए अन्‍निटकन्‍ना पेद्‍दा पेनदा मर्रि येसु, नातोनि नीकु बता कबळ? नाकु तकलिप हियमा इंचि नीकु विनंति कींतन,” इल्‍हा जोरसे वरगेयसि ओना मुन्‍ने अरतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“नीवा पोरोल बतल?” इंचि येसु पूसकीतोर. ओनकु वेल्‍लेने देय्याल्क पीसि मत्‍ताहाटीं, “मोमोट वेल्‍लेन मंदा आसि मंतोम, इंचि नावा पोरोल मंदा आंद,” इंचि अव येसुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","पजा देय्याल्क येसुनतोनि, “माकुन नरकमता लोतु जेगाते होनना आदेस हियमा,” इंचि बच्‍चोरो विनंति कीतां. ");
INSERT INTO esg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","अगा गुट्‍टापोर्रो पद्‍दिना उंदि मंदा मेय्‍सेके मत्‍ता. “माकुन आ पद्‍दिना मंदा लोप्पो होनाहीम,” इंचि देय्याल्क येसुन विनंति कीतां, अस्‍के येसु अवुन पद्‍दिना मंदा लोप्पो होना हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","अस्‍के आ देय्याल्क मनकना लोप्पोटाल पेय्सि पद्‍दिना मंदाते होंचि होळियतां. अस्‍के आ पूरा मंदा ओड्‍डुन पोर्रोटाल हिळतुक वित्‍सि सेरवुने मुळ्‍गिसि हासोत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","पजा आ पद्‍दिं मेहानोर इल्‍हा आतद हूळसि वित्‍सि होंचि अद सहरते अल्‍हेने पक्‍का पीसि मत्‍ता नाह्कुने इद पोल्‍लेतुन वेहातुर. ");
INSERT INTO esg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","बतल आता इंचि हूळालय अगाटा लोकुल्‍क येसुनगा वातुर. अगा वासि हूळतुर अय्ते, देय्याल्कुनाल इळबळता मनकल ओर बेस आसि, कपडिं केर्सि येसुना काल्कुनगा उद्‍दिसि मत्‍तोर. अल्हा मत्‍तद हूळसि ओर्क वेर्रे दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","येसुना कबाह्‍कुन हूळतोर अगा बोर अय्ते मत्‍तुरो ओर, देय्याल्क पीसि मत्‍ता मनकल बल्हा बेस आतोर इंचि लोकुल्‍कुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","अस्‍के गिरासेन एरियाता अंटोर लोकुल्‍क बागा वेरियसि, “निमे महागटाल पेय्सि होन,” इंचि येसुन विनंति कीतुर. अदुनहाटीं येसु, ओना सिस्युल्क होनालय डोंगाते उदतुर. ");
INSERT INTO esg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","उदता पजा, “नाकुन नीवातोनि वाया हीम गुरु,” इंचि देय्याल्कुनाल बेस आता मनकल येसुन विनंति कीतोर. गानि येसु ओन, ");
INSERT INTO esg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“निमे लोन होंचि नीवाहाटीं पेन बतल कीता अद वेहा,” इंचि मल्‍हाचि लोहतोर. अस्‍के ओर मल्सि होंचि, येसु ओनाहाटीं बतल-बतल कीतोरो अव अन्‍नि, सहरते अंटोर्क वेहाचेके तिरियतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","पजा येसु गालिल एरियाते मल्सि वातस्के ओन एदुर हूळसेक मत्‍तोर वेल्‍लेटुर लोकुल्‍क कुसिते ओन्क कलियतुर. ");
INSERT INTO esg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","अच्‍चोटेन दर्मसास्‍त्रम कराहना लोता अदिकारि याईर इननोर अगा वातोर. ओन्क पन्‍नेंड वर्सानद उंदे मिय्यड मत्‍ता, अद हायनाल आसि मत्‍ता. अदुनहाटीं ओर येसुना काल्कुनपोर्रो अर्सि, “नावा लोन वा,” इंचि विनंति कीतोर. अस्‍के येसु आ अदिकारिनतोनि होनालय पेय्सतोर. अगा ओना सुट्‍टु वेल्‍ले गर्दि मत्‍ताहेंके लोकुल्‍क दोब्बें-नूकें कीसि येसुन इटसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","आ गर्दिते उंदि मुरतळ मत्‍ता, दानकु पन्‍नेंड वर्सानाल उंदेतीर कप्‍पिड होनुंदु. अद वेल्‍लेटुर वैदकुल्‍कुंक हुपिच्‍चि दाना पूरा कोत्‍तां महता गानि दान बोरे बेस किया पराहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","अद मुरतळ येसुना पज्जो वासि, सिराप ओना कप्‍पिडता अंचुन इट्ता अय्ते अस्केटद अस्‍केने दाना कप्‍पिड आयमळ बंद आता. ");
INSERT INTO esg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","अस्‍के, “नाकुन बोर इटतुर?” इंचि येसु पूसकीतोर. अगा मत्‍तुर अंटोर, “नना आयोन, नना आयोन,” इंचि इननेंके, “अंटोर नीवा सुट्‍टु आसि दोब्बें-नूकें कीसंतुर गुरु, बोरन्‍ना दल्‍गिसि मनानुर,” इंचि पत्रु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","गानि, “ना लोप्पोटाल ताकत पेय्सता इंचि अनपिस्ता. बेस आयानाहाटीं बोरो नाकुन इटतोर,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","पजा अद मुरतळ, “नना इटतद एरपाट कीतोर,” इनकुंचि वेर्रेक वनकुसेक वासि ओना काल्कुना पोर्रो अर्सि, अगा अंटोर लोकुल्‍कुन मुन्‍ने अद येसुन बारि इट्ता अद बल्हा बिराना बेस आता इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","अस्‍के, “पेगिटुना! नीवा विस्वासमे नीकुन बेस कीता. सांतिते होन,” इंचि येसु दान इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","येसु अल्हा वळ्कसेक मननेंके दर्मसास्‍त्रम कराहना लोता आ अदिकारिना लोताल बोरो वरोर वासि, “नीवा मिय्यड हाता, गुरुन लोन ओयालय तकलिप कीसि इंका बाता पाय्दा हिल्‍ले,” इंचि अदिकारिन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","अस्‍के अदुन केंजसि, “निमे वेरियमा, विस्वासम इर्रा! अद बेस आंता,” इंचि येसु आ अदिकारिंक जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","येसु ओना लोन वातोर, वासि पेगिळ मत्‍ता अर्राते बोर्कुने होळिया हिया हिल्‍लोर, सिराप पत्रुन, योहानुन, याकोबुन आनि पेगिटा तल्‍लुर-बाबोन पीसि लोप्पो होळियतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","अंटोर पेगिटाहाटीं अळमळ-मोत्‍कुनमळ कीसेके मत्‍तुर. गानि येसु ओर्कुन, “अळमट! अद हाया हिल्‍ले, मींडसि मंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","अद पेगिळ हाता इंचि ओर अंटोर्क एरपाट मत्‍ता. अदुनहाटीं येसु इत्‍ता पोल्‍ले केंजसि ओर कव्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पजा येसु आ पेगिटा कय पीसि, “पेगिटुना, तेदा!” इंचि केयतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","अस्‍केन दाना जीवा मल्सि वासि, अद बिराना तेदिस उदता. अद पेगिड्‍क बतलन्‍ना तिनालय हीम्टु इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","अद हूळसि, दाना तल्‍लुर-बाबो इचंत्रम आतुर. गानि, “इगे आता पोल्‍लेतुन बोर्के वेहमटु,” इंचि येसु ओर्कु गट्‍टिगा हुकुम हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","येसु ओना पन्‍नेंड सिस्युल्कुन केय्‍सि ओर्क अन्‍नि देय्याल्कुन पेचाहनद, बिमार मत्‍तोर्कुन बेस कियना ताकत, अदिकारम हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","पजा येसु ओर्कुन, पेनदा राज्येम बारेमते बेसता कबुर वेहालय, बिमार मत्‍तोर्कुन बेस कियालय लोहतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ओर्कुन लोहनेंके इल्‍हा इत्‍तोर, “मिमेट सेवा कियालय होननेंके मीवातोनि दुड्‍डु, जोरा आयि, गाटो आयि, कोत्‍तां, एक्‍कोतव अंगिं ओयमट. ");
INSERT INTO esg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","उंदि नाटे होत्‍तस्के मिमेट बद लोन अय्ते दांतिटो, अद नार होळसनदाका अदे लोते मंटु. ");
INSERT INTO esg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","बद नाटेना लोकुल्‍क मीकुन मना हिय्‍युरो, अद नाटेनाल पेय्सनेंके ओर कीता तप्पुन हुप्‍सालय उंदि गवाइ लेह्का मननाहाटीं, मिमेट मीवा काल्कुना दुम्मु दुल्‍पिसि पेय्‍सट” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","अस्‍के ओर अगटाल पेय्सि, नार-नार बेसता कबुर वेहासेके, बिमार मत्‍तोर्कुन बेस कीसेके होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","पजा गालिल एरियाता राजाल हेरोद, बस्के अय्ते येसु कियना कबाह्‍कुना बारेमते केंजतोरो अस्‍के बतल जर्गसंता ओन्क बतले तेळिया हिल्‍ले. बारित्‍ते इच्‍चुर लोकुल्‍क, “योहान हातोराव्टेटाल मर्रा तेदतोर,” इंचि इनुंदुर. इंका इच्‍चुर लोकुल्‍क, “पेनदा कबुरतोर एलियल मर्रा वातोर,” इंचि इनुंदुर आनि इच्‍चुर लोकुल्‍क बारे, “एनकटा पेनदा कबुरतोरा लोप्पोटाल बोरो वरोर जीवाते तेदतोर,” इंचि इनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","गानि, “नना अय्ते योहानुना तल्‍ला कोय्यागोटतन, इंदके इसोंटा पोल्‍लें केंजसेक मंतन, अय्ते ईर बोर आंदुर?” इंचि हेरोद राजाल ओन हूळना विचारम कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","पजा प्रेरितुल्क मल्सि वातस्के ओर बतल-बतल कीतुर अव अन्‍नि येसुंक वेहतुर. वेहतस्के, येसु ओर्कुन लोकुल्‍कुनाल अलग कीसि बोर्के तेळियाकोंटा बेतसेदा इनना सहर पीसि ओतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","गानि येसु बगा मंतोर इंचि लोकुल्‍कुंक तेळियतस्के ओर ओन दोर्काबेटसि ओना पज्जो होत्‍तुर. अय्ते येसु कुसिते ओरतोनि कलियसि ओर्कु पेनदा राज्येमता बारेमते वेहतोर. पजा ओरागटाल बोर्क बेस आयानद मत्‍ता ओर्कुन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","पोळ्‍द होनना वेलाक पन्‍नेंडु सिस्युल्क येसुनगा वासि, “मनम सुनसान जेगाते मंतोम, अदुनहाटीं लोकुल्‍कुन लोहचीम, ओर दग्‍गेटा नाह्कुने, नेलिने होंचि तिनालय गाटो, मींडालय जेगा दोर्किच्‍कुंतुर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","अस्‍के, “मिमेटे बतलन्‍ना ओर्क तिनालय हीम्ट,” इंचि येसु ओर्कुन इत्‍तोर. “महगा सिराप हेय्युं हारिं, रोंडु जिम्मां मंतां, अवुन तप्‍पा बतले हिल्‍ले. मोमोट होंचि ई अंटोर लोकुल्‍कुनाहाटीं गाटो अस्सि तायना इंचि निमे इंचेकेना?” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","अगा दग्‍गेर-दग्‍गेरा हेय्युं वेय्‍कुना मंदि मांडसा मत्‍तुर. गानि येसु सिस्युल्कुनतोनि, “ओर्कुन एबै-एबै मंदि कीसि उपसट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","येसु वेहताप ओर अंटोर्कुन उपिस्तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","पजा येसु हेय्युं हारिं, रोंडु जिम्मां पीसि, स्वर्गमताहेके हूळसि पेनदुक दन्यवाद कीसि अवुन तुकडां कीतोर. कीसि, “इवुन लोकुल्‍कुंक हीम्ट,” इंचि सिस्युल्कुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","लोकुल्‍कुंक हीतस्के, ओर पीरनिंडा तित्‍तुर. मिगुल्ता तुकडां जमा कीते अव पन्‍नेंड तट्‍टां निंडतां. ");
INSERT INTO esg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","उंदि रोज येसु वरोरे पारतना कीसेक मननेंके, ओना सिस्‍युल्‍कगुडा ओनतोनि मत्‍तुर. अय्ते, “नना बोन आंदुन इंचि लोकुल्‍क इंतुर?” इंचि येसु ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","अस्‍के ओर इल्‍हा जवाब हीतुर. “इच्‍चुर बारे नीकुन बापतिस्मा हियना योहान इंतुर. गानि इच्‍चुर बारे निमे एलियाल आंदिन इंतुर. इंकिच्‍चुर बारे एनकटा पेनदा कबुरतोरा लोप्पोटाल बोरो वरोर जीवा अरतोर इंतुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“गानि मिमेट बतल इंतिर?” इंचि येसु सिस्युल्कुन मर्रा पूसकीतोर. अस्‍के, “निमे पेन लोहता पिसागोटनोन किरिस्‍तुन आंदिन,” इंचि पत्रु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","गानि, “इद पोल्‍ले मिमेट बोर्के वेहमट,” इंचि येसु ओर्क गट्‍टिगा हुकुम हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","पजा ओर्क इल्‍हा वेहालय दल्‍गतोर. “यहुदि पेद्‍दाल्क, पेद्‍दा पेर्मालोर आनि दर्मसास्‍त्रम कराहना गुरुल्कुनाहेंदाल मनकना रूपमते पुटतोन नाकु तिप्‍पल्‍क अर्रापींता. ओर हय्साकोंटा आसि नाकुन हव्कानुर. गानि मूडोव रोजुने नना मर्रा जीवाते तेदंतन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","पजा येसु अंटोर लोकुल्‍कुन इल्‍हा इत्‍तोर. “ओक्‍कला बोरन्‍ना मनकल नावा पज्जो वायना इत्‍ते, ओर ओना पूरा इस्‍टाल्क होळसिसि, दररोज सतता क्रुस तेह्‍कुंचि नावा पज्जो वायिर. ");
INSERT INTO esg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","बोर ओना जीवातुन पिसागोटालय हूळंतोर, ओर ओना जीवातुन पोगोटकुंतोर, ओन्क बस्केळक पिस्सना पिस्वर दोर्को गानि नावाहाटीं बोर अय्ते जीवा हींतोर, ओन्क बस्केळक पिस्सना पिस्वर दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ओक्‍कला मनकल पूरा दुनियातुन संपलिच्‍चि, जीवा पोगोटकुत्‍ते हिलाकोंटे नासडेम आते, ओन्क बता पायदा आंता? ");
INSERT INTO esg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","बोर अय्ते नाकुन, नावा पोल्‍लेन वेहालय सिग्गु अर्रंतोर, मनकना रूपमते पुटतोन नना बस्के अय्ते नावा महिमाते, नावा बाबाना महिमाते, पवित्र पेनदा दूताना महिमाते वांतन, अस्‍के असोंटा मनकन नावोर इनालय ननागुडा सिग्गु अर्रंतन. ");
INSERT INTO esg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","गानि, नना मीकु निजम वेहांतन, इग्‍गे नित्‍तिसि मनानोरा लोप्पोटाल इच्‍चुर इल्‍हा मंतुर गदा, ओर पेनदा राज्येमतुन हूळवा, ओर्कु हामुर वायो.” ");
INSERT INTO esg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इव पोल्‍लें वेह्‍चि एनमिदि रोजकु आतां बारे! येसु पत्रुन, योहानुन, याकोबुन पीसि येसु गुट्‍टापोर्रो पारतना कियालय होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ओर पारतना कियानेंकेन ओना रूपम मारिय्ता. ओना कपडिं तेल्‍लगा मेर्सालय दल्‍गतां. ");
INSERT INTO esg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","हुळाट! अचानक येसुनगा मूसाल आनि एलियाल महिमाते वासि, येसुना हामुर येरुसलेमते बल्हा पूरा आंता, इंचि वळ्कसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पत्रु आनि ओना दंटातुर निद्रा होंचि मत्‍तुर. पजा ओर निद्रताल तेदतस्‍के येसुना महिमाता वेल्‍गुन हूळतुर. अचोने आयाका ओनतोनि इव्वुर मनकालोर नित्‍तिसि मत्‍तदगुडा हूळतुर. ");
INSERT INTO esg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","पजा मूसाल आनि एलियाल येसुनगटाल होननेंके, “गुरु, मनम इगे मनमळ बेस मंता. अय्ते मनम मूड डेरां वाटकोम. उंदि नीहाटीं, उंदि मूसानाहाटीं उंदि एलियानाहाटीं,” इंचि पत्रु येसुन इत्‍तोर. (ओर ई पोल्‍लें वळ्कानेंके विचारम कियाकोंटेन वळ्कतोर.) ");
INSERT INTO esg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ओर ई पोल्‍लें वळकसेके मननेंकेन उंदि मब्बु तेर्पे वासि ओर्कुन मुच्‍का होत्‍ता, अस्‍के ओर मुव्वुर वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ओर्कु मब्बुनाल, “ईर नावा मर्रि आंदुर, ईन नना पेर्कुत्‍तन, ईनां केंजट,” इंचि पेनदा अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","अद अल्किर मग्तस्‍के ओर्क अगा येसु वरोरे दिसतोर. पजा ओर चुपचाप मत्‍तुर. अगा हूळतद आ रोजकुने ओर बोर्के वेहा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","इंकुंदि रोज ओर गुट्‍टा पोर्रोटाल हिळु रेयतस्के वेल्‍लेन लोकुल्‍क येसुंक कलियालय वातुर. ");
INSERT INTO esg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","अस्‍के आ मंदिताल वरोर मनकल जोरते वरगेयसि, “गुरु, नना नीवा काल्क मोळ्कंतन, नावा मर्रिनपोर्रो दया कीम, नाकु ओर वरोरे मर्रि आंदुर. ");
INSERT INTO esg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ओन देय्यम पीतस्‍के ओर बागा वरगेयंतोर, ओना तोळ्‍दाल पोंगुर पेय्सानाल ओन तेल्हंता, अद ओन बस्‍केने होळसो, तकलिप कीसेकेने मनंता. ");
INSERT INTO esg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","अदुन गेदमालय नना नीवा सिस्युल्कुंक विनंति कीतन, गानि ओरतोनि आया पराहिल्‍ले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","अस्‍के येसु ओर्कुन, “अरे विस्वासम तक्‍को आनि हर्रि तप्‍ता पीळितोरिटा, नना बदवेरदाका मीतोनि मनकन? इंका बदवेरदाका नना मीकुन सहन कीकन? नीवा मर्रिन इग्‍गे पीसि वा,” इंचि आ मनकन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","आ पेडल येसुनहेके वायानेंकेन देय्यम ओन हिळु अरहचि तेल्हता. अस्‍के येसु आ देय्यमतुन गदरिचतोर. पजा पेडन बेस कीसि ओना बाबांक अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","अस्‍के अंटोर लोकुल्‍क पेनदा ताकततुन हूळसि इचंत्रम आतुर. येसु बतल अय्ते कीतोरो अद हूळसि अंटोर लोकुल्‍क इचंत्रमते मननेंके येसु ओना सिस्युल्कुन इल्‍हा इत्‍तोर, ");
INSERT INTO esg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“इंदके नना मीकु बतलय्ते वेहांतनो, अव पोल्‍लेन मिमेट बेस केंजट. मनकना रूपमते पुटतोन नाकुन, लोकुल्‍कुना कय्‍दे पीसि हियानद मंता.” ");
INSERT INTO esg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","गानि येसु वेहता पोल्‍ले ओर्क तेळिया हिल्‍ले. अद पोल्‍ले ओर्क तेळियामन्‍नि इंचि मक्‍किचि मत्‍ता. आनि इदुना बारेमते ओन पूस कियालयगुडा ओर वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","पजा, “मनालोप्‍पो अंटोर्कन्‍ना पेद्‍दा बोर?” इदुना बारेमते सिस्युल्कुंक ओर्क-ओर्के पोल्‍लें आतां. ");
INSERT INTO esg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","गानि येसु ओरा मनसुना विचाराल्कुन एरपाट कीसि, वरोर सिन्‍ना पेडन ओना दग्‍गेरा निलाहतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","निल्‍हाचि, “बोर अय्ते ई सिना पेडनसंटोन नावा पोरोलते स्विकार कींतोर ओर नाकुन स्विकार कीतापे. अल्‍हेने बोर अय्ते नाकुन स्विकार कींतोर ओर नाकुन लोहता पेनदुन इंका स्विकार कींतोर. अदुनहाटीं बोर अय्ते मीलोप्‍पो अंटोर्कन्‍ना सिन्‍ना मंतोर, ओरे अंटोर्कन्‍ना पेद्‍दोड आंदुर,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","अस्‍के, “गुरु, वरोर मनकल नीवा पोरोलते देय्याल्कुन पेचाहनेंके मोमोट हूळतोम. मालेसीं ओर नी पज्जो ताकानोर आयोर, अदुनहाटीं अल्हा कियमा इंचि मोमोट ओन आपतोम,” इंचि योहान जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","इत्‍तस्के, “बोर अय्ते मीक विरोदमते हिल्‍लोर, ओर मीवोरे आंदुर, अदुनहाटीं ओन आपमट,” इंचि येसु योहानुन वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","येसु स्वर्गमते होनना रोजकु दग्‍गेरा वासेक मत्‍तां. अदुनहाटीं ओर येरुसलेम होनालय गट्‍टि निरनायम कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ओर पेय्‍सका मुन्‍ने ओना कबुरतोर्कुन लोहतोर. ओर ओन्क जेगा तयार कियालय सामरिया लोकुल्‍कुना उंदि नाटे एव्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","गानि येसु येरुसलेम होनालय पेय्सतोर इंचि सामरि जातिता लोकुल्‍क ओन अगा आगा हिया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ओर्कुन अगा आगा हिया हिल्‍लुर अय्ते ओना सिस्युल्कु याकोब आनि योहान इल्‍हा इत्‍तुर, “सामि! ओर्कुन हव्कालय, मब्बुनाल तडमि अर्रि इंचि मोमोट आदेस हिय्याना, इंचि नीवा विचारम मंताना?” ");
INSERT INTO esg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","अस्‍के येसु ओरहेके तिरियसि ओर्कुन तेराहतोर. ");
INSERT INTO esg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","पजा ओर अगटाल वेरे नाटे होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ओर हरपीसि होंचेक मननेंके बोरो वरोर मनकल येसुनगा वासि, “निमे बगा-बगा दांतिनो, अगा-अगा नना नीवा पज्जो वांतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","अस्‍के येसु ओन इल्‍हा इत्‍तोर, “नक्‍कांक बारे मनालय सोर्रें मंतां, पिट्‍टेंक मनालय गूडां मंतां, गानि मनकना रूपमते पुटतोन नाकु मात्रम तल्‍ला इर्रालयगुडा जेगा हिल्‍ले.” ");
INSERT INTO esg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","पजा येसु इंकावरोन, “नावा पज्जो वा” इत्‍तोर. गानि, “सामि, नाकुन मोदाला होनाहीम, नावा बाबाल हातास्के ओन गति कीसि वांतन,” इंचि ओर येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","अस्‍के येसु ओन इत्‍तोर, “बोर अय्ते हाताप मंतुरो, ओरे ओरा हातोरा गति किय्‍यिर. निमे मात्रम होंचि पेनदा राज्येम बारेमता बेसता कबुर वेहा.” ");
INSERT INTO esg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","इंकावरोर मनकल इत्‍तोर, “नना नीवा पज्जो वांतन सामि, गानि मुन्‍ने नना लोन होंचि, नावा लोतोर्कुंक वेहचि वांतन.” ");
INSERT INTO esg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","अस्‍के येसु ओन इत्‍तोर, “पज्जो वांतन इंचि पेय्सि, मर्रा पजोळ्क मल्सि हूळना मनकल पेनदा राज्येमता सेवा कियनालायक हिल्‍लोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","अद आता पजा सामि, इंका डेब्बै रोंड मंदि सिस्युल्कुन पेरतोर. पेरसि, बव नाह्कुने अय्ते ओन्क होनना मत्‍ता अव नाह्कुने ओना सिस्युल्कुन इव्वुर-इव्वुर्कुन कीसि मुन्‍ने लोहातोर. ");
INSERT INTO esg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ओर्कुन लोहानेंके इल्‍हा वेहातोर, “पंटा वेल्‍लेने पंडुता गानि बूतिनोर तक्‍को मंतुर. अदुनहाटीं पंटाता मालकुंक बूतिनोर्कुन पंटा कोय्‍यालय लोहा इंचि विनंति कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","मिमेट होंट! हुळाट, तोडेल्‍लिन लोप्पो गोर्रे पोरिह्कुन लोहताप नना मीकुन लोहचंतन. ");
INSERT INTO esg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","मीवातोनि कोत्‍ताना संचि, जोरा आयि, हेरपुह्क आयिं पियमट. हर्रि पीसि होननेंके बोर कलियते ओर्कु जोहारगुडा वेहमट. ");
INSERT INTO esg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","मिमेट बद लोन अय्ते दांतिटो, मोदाला, ‘इद लोतुक सांति दोर्कि’ इंचि इंटु. ");
INSERT INTO esg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अद लोते सांति गावाले इनना मनकल मत्‍ते अद सांति ओनगा दांता, गानि अगा गिंटा सांति गावाले इनना मनकल हिलाकोंटे आ सांति मिहागेन वापस वांता. ");
INSERT INTO esg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","कबळ कियानोंकु बूति दोर्कंता. अदुनहाटीं मिमेट बद लोन अय्ते दांतिटो अद लोतुर बतल हींतुरो अद तिंचेक-उंचेके अदे लोते मंटु, अलग-अलग लोह्कुने मनमट. ");
INSERT INTO esg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","मिमेट बद सहरते दांतिरो, अद सहरतोर मीकु बेस मान-मरयादा कीते, ओर मीक बतल तिनालय हींतुर अदे तिंटु. ");
INSERT INTO esg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","अगाटा बिमारतोर्कुन बेस कीसि, ‘पेनदा राज्येम दग्गेर्क एव्ता’ इंचि ओर्क वेहाट. ");
INSERT INTO esg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","गानि मिमेट बदन्‍ना सहरते होतस्के ओर मीकुन बेस मान-मरयादा कियाकोंटे, अगाटा हरकुने होंचि, ‘मिमेट माकु मरयादा कियुवा विरोदमते, मावा काल्कुंक अंटता मीवा सहरता दुब्बागुडा मोमोट इगेन दुल्‍पसंतोम. अय्नागानि इद मतिते इर्रट, पेनदा राज्येम दग्गेर्क एव्ता,’ इंचि ओर्क वेहाट. ");
INSERT INTO esg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","नना मीकु वेहासेक गदा, न्‍यायम कियना रोजुने, सदोम सहरता परिस्तिति आ नाह्‍कुंकन्‍ना बच्‍चोरो बेस मनंता,” इंचि येसु ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","येसु मर्रा इत्‍तोर, “ए कोरजिना आनि बेतसेदा नाटेना लोकुरिटा! मीकु गोसा तप्‍पो! ओक्‍कला मिहगा बव अद्‍बूताल्‍क आतां, अवे गिंटा सूर, सिदोन नाह्कुने आसि मत्‍ते, अगाटा लोकुल्‍क बिराना बोंतां हुट्‍सि, मेंदुल्क बूळ्‍दि होकसि उद्‍दिसि दुक्‍कमते मनसु मार्सकुंचि मन्‍नेर. ");
INSERT INTO esg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","गानि पेन न्‍यायम कियना रोजुने सूर आनि सिदोनतुरा परिस्तिति मीकन्‍ना बच्‍चोरो बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ए कपर्नाहुम सहरता लोकुरिटा! मिमेट स्वर्गमते दांतोम इनकुंचंतिरा? मिमेट नरकमते दांतिर.” ");
INSERT INTO esg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“सिस्युल्कुनिटा! बोर मीवा पोल्‍लें केंजंतोरो, ओर नावा पोल्‍लें केंजंतोर. बोर मीकुन हय्‍सोर ओर नाकुन हय्‍सोर. नाकुन हय्सवोर नाकुन लोहता पेनदुनगुडा हय्‍सोर,” इंचि येसु वेहातोर. ");
INSERT INTO esg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","पजा, येसु लोहता डेब्बै रोंडु मंदि सिस्युल्कु वेल्‍लेन कुसिते मल्सि वासि, “सामि, नीवा पोरोल्ते देय्याल्कगुडा मावा पोल्‍लेतुन केंजतां,” इंचि येसुंक वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “नना पेद्‍दा देय्यमतुन मब्बुनाल पिळगुनलेसीं अरनेंके हूळतन. ");
INSERT INTO esg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","केंजट, नना मीकु तरासकु, मिच्‍चोन जारानद आनि पगातोरा पूरा बलमतुन गेल्सानद अदिकारम हीतन. मीपोर्रो बोरे अन्‍यायम किया पर्रुर. ");
INSERT INTO esg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","अयना मीवा पोल्‍ले देय्याल्क केंजतां इंचि कूस आयमट, गानि मीवा पोरोल स्वर्गमते रासि मंता इंचि कूस आम्टु,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","अस्‍केने येसु पवित्र आत्माते निंडसि कूस आसि इल्‍हा इत्‍तोर, “ए नावा बाबा, बूमि आनि स्वर्गमता सामि, तेल्‍विगल्‍लोर्क आनि समजदार लोकुल्‍कुनगटाल इव पोल्‍लें मक्‍किचि इरतिन, सादा-सिंपल लोकुल्‍कुंक बारे इव पोल्‍लें हुपिस्‍तिन, इंचि नना नीवा स्‍तुति कीसेक मंतन. हो बाबा! नीकु इदे बेस अनपिस्ताहाटीं निमे इल्‍हा कीतिन. ");
INSERT INTO esg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","नावा बाबाल नाकु अन्‍नि अप्पजेपतोर. बाबान तप्‍पा मर्रिन बोरे एरपाट किय्युर, मर्रिन तप्‍पा बाबान बोरे एरपाट किय्युर. मर्रि ओना इस्‍टमाताप बाबाना बारेमते बोर्क अय्ते तेळियानाल वेहांतोर ओरे बाबान एरपाट कींतुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","पजा ओर ओना सिस्युल्कुन पक्‍कक ओसि ओर्कुन इल्‍हा इत्‍तोर, “मिमेट हूळानवुन हूळना मीवा कळ्‍कु वेल्‍लेन आसिर्वाद दोर्कतव आंदुं. ");
INSERT INTO esg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","बारित्‍ते नना मीकु वेहांतन, इय्याला मिमेट बव हूळसंतिरो, केंजसंतिरो, अवुन वेल्‍लेटुर पेनदा कबुरतोर आनि राजालोर हूळालय, केंजालय तन्‍लाळुंदुर. गानि ओर्क हूळालय, केंजालय दोर्काहिल्‍ले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","अच्‍चोटेन मूसाना नियम बेस तेळियतोर वरोर गुरु निततोर. नित्‍तिसि येसुना पट्‍टु हूळानाहाटीं, “गुरु, बस्‍केळ्‍क पिस्सना पिस्वरता वारसदार आयानाहाटीं नना बतल कीते बेस?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","अस्‍के येसु ओन, “मूसाना नियमते बतल रासि मंता? दानहेंदाल नीकु बतल तेळियता?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","इत्‍तस्के आ गुरु, “निमे नीवा सामि आता पेनदुन पूरा मनसुनाल, पूरा आत्माताल, पूरा ताकतताल, पूरा बुद्‍दिताल पावरम कीम. अल्‍हेने नीवद निमे बच्‍चोन पावरम कींतिनो अचोने पावरम इंकावरोनगुडा कीम. इल्‍हा रासि मंता,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","अस्‍के येसु ओन, “निमे बरोबर वेहतिन, अल्हेन निमेगुडा कीम, अस्‍के नीकु बस्केळक पिस्सना पिस्वर दोर्कंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ओर, नना नीतिमंतुन इंचि हुप्‍सालय, “नावा पक्‍कातोर इत्‍ते बोर आंदुर?” इंचि येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","अल्हा पूसकीतस्‍के येसु ओन्क उंदि वेसुड वेहातोर: “वरोर मनकल येरुसलेम सहरताल यरिहो इनना नार होंचेके मत्‍तोर. होननेंके नड्‍डुम हरदे ओन दोंगाल्क पीतुर. ओर ओनगा मत्‍ता सामानतुन इग्गुकुत्‍तुर, कपडिं तेंडकुत्‍तुर. पजा ओन पक्‍का तंचि, डुक-डुक जीवा मननेंके होळसि होत्‍तुर.” ");
INSERT INTO esg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“पजा बतल आता इत्‍ते, अदे हरपीसि वरोर पेर्माल होंचेक मत्‍तोर. आ पेर्माल हिळु अरसि मत्‍ता मनकन हूळसि होरियसि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ओर होतस्के वरोर लेवि जातिता मनकल अदे हर्रि पीसि वातोर. ओर इंका हिळु अरसि मत्‍ता मनकन हूळसि होरियसि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ओर होत्‍ता पजा, अदे हर्रि पीसि वरोर सामरिया मनकल अगा एवतोर. एवतस्‍के हिळु अरसि मत्‍ता मनकन हूळसि ओनकु इरगा जीवा नोता. ");
INSERT INTO esg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ओर ओनगा वासि ओन्क देब्बां आतगा, अवुनपोर्रो निय, अंगुर पंडिना पानकम होकसि पट्‍टि दोहतोर. दोहता पजा, आ सामरि मनकल हिळु अरसि मत्‍ता मनकन ओना गाड्‍दिपोर्रो वाटसि, उंदि लाजुने ओसि ओन बेस हूळकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","इंकुंदि रोज लाजता मालकुंक रोंडु एंडि कोत्‍तां हीसि, ईन बेस हूळा, ईनाहाटीं एक्‍को कोत्‍तां कर्स आयानय्ते, नना मल्सि वातस्के अव नीकु हींतन इत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","पजा येसु, “दोंगाल्कुन कय्‍दे देब्बां तित्‍ता मनकंक मुव्वुर मनकालोर कलियतुर. आ मुव्वुर लोप्पो नीवा विचारमते ओना पक्‍कातोर बोर आंदुर?” इंचि ओन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","अस्‍के आ गुरु, “बोर अय्ते ओन हूळसि ओनपोर्रो दया कीतोर ओरे,” इंचि इत्‍तोर. अस्‍के येसु, “होन, ओर कीताप निमेगुडा कीम,” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","पजा येसु, ओना सिस्युल्कु हर्रि पीसि होननेंके, उंदि नाटेनगा एवतुर. अगा उंदि मार्ता इनना मुरतळ मत्‍ता. अद येसुन दाना लोन ओसि बेस हूळकुत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","दान्क मरियम इनना उंदि हेलड मत्‍ता. अद सामिना काल्कुनगा उद्‍दिसि ओर वेहना पोल्‍लें बेस केंजसेक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","गानि दाना अक्‍कल मार्ताल सेवा कीसि-कीसि, पूरा मोता दान पोर्रोने अरताप आता. अदुनहाटीं अद येसुनगा वासि, “सामि, नावा हेलड पूरा कबळ नावा पोर्रोने वाटसि हीता, इद निमे हूळसेक हिल्‍लिना? नाकु आसर आयालय दानकु वेहा,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","अस्‍के सामि दानकु इल्‍हा जवाब हीतोर. “मार्ता, निमे वेल्‍लेन कबाह्‍कुना बारेमते विचारम कीसि गाबर आंतिन. ");
INSERT INTO esg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","गानि असल उंदे कबळ कियना अवसरम मंता. मरियम आ बेस कबळतुन पेरकुत्‍ता. अदुनहाटीं दानगटाल अद कबळतुन बोरे इगुकुन्‍ना परुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","उंदि मल्का येसु उंदि जेगाते पारतना कीसेक मत्‍तोर. पारतना आतंका ओना सिस्युल्‍कुनाल वरोर सिस्युड ओन, “सामि, योहान ओना सिस्युल्कुंक बल्हा पारतना कियमळ कराहतोरो, अल्हेन निमे माकुगुडा पारतना बल्हा कियमळो करहा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","अस्‍के येसु ओर्कुन, मिमेट पारतना कियनेंके इल्‍हा इंटु, “ए मावा पेनबाबा, नीवा पोरोलतुन अंटोर कदर कियिरकांटी. निमेन मापोर्रो राज्येम कीम. ");
INSERT INTO esg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","माकु रोजता तिंडि इय्यालागुडा हीम. ");
INSERT INTO esg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","माकु विरोदमते कीता तप्‍पुकुन मोमोट बल्हा माप कीतोमो, निमेगुडा मोमोट कीता तप्‍पुकुन माप कीम, माकुन पट्‍टुने अर्राकोंटा कापाळा.” ");
INSERT INTO esg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","पजा येसु ओर्कु इल्‍हा वेहालय दल्‍गतोर. “मीवाव्टेटाल बोरो वरोर, मीवा दंटातोनगा नडजाम नर्का होंचि, अरे दादा, नहगा इंदकेन वरोर दंटागाल वातोर. गानि ओन्क अट्‍टिस दोसालय नहगा बतले हिल्‍ले. अदुनहाटीं नाकु इच्‍चुं पर्रिक बदल हीम, इंचि इत्‍तोर इनकुंटु! ");
INSERT INTO esg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","अस्‍के आ दंटागाल लोप्पोटाले, नना नावा पिलाल्कुनतोनि मींडसि मंतन, नना तेदते ओरगुडा तेदांतुर, इंका तल्‍पुगुडा लोप्पोटाल गट्‍टिगा वाटतन. अदुनहाटीं नना इंदके तेदिस नीकु बतल हिया परोन. नाकुन वट्‍टिदे परेसान कियमा, इंचि इंतोर. ");
INSERT INTO esg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","नना मीकु वेहानद बतल इत्‍ते, आ दंटागाल ‘नावा दंटागाल वातोर,’ इंचि तेदसि ओन्क पर्रिक हिय्या हिल्‍लोर. गानि ओना दंटागाल ओन उंदेतीर, हीम-हीम इंचेके बातिमलाडताहाटीं ओर तेदसि ओन्क गावाले मत्‍ताचोन पर्रिक तप्‍पाकोंटा हींतोर. ");
INSERT INTO esg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अदुनहाटीं नना मीकु वेहचंतन पेनदुन तल्कसेक मंटु, मीकु हिय्यार. पह्कसेक मंटु, मीकु दोर्कार. तलपुन टोक-टोक कीसेक मंटु, मीवाहाटीं तल्‍पु तेंडार. ");
INSERT INTO esg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","बारित्‍ते बोर अय्ते तल्कंतोर ओन्क हियमळ जर्गंता. बोर अय्ते पह्कंतोर ओन्क दोर्कंता. बोर अय्ते तल्‍पुन तनंतोर ओनाहाटीं तल्‍पु तेंडमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","मीलोप्‍पो बोरन्‍ना बाबो मंतोरा ओना मर्रि, जिम्मा तल्‍कते ओन्क तरास हियानोर? हिलाकोंटे मेंज तल्‍कते ओन्क मिच्‍चो हियानोर मीलोप्‍पो बोरन्‍ना बाबो मंतोरा? हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","अय्ते मिमेट सेड्‍डोर्क आसिगुडा मीवा पिलाल्कुंक बेसतद हियमळ तेळियतस्के, स्वर्गमते मनना पेनबाबाल, ओन तल्कानोर्कुंक पवित्र आत्मा बच्‍चोन वेल्‍ले हियनुर?” ");
INSERT INTO esg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","वरोर मनकन देय्यम पीताहाटीं ओर मूकल आसि मत्‍तोर. पजा येसु आ मनकानाल अद देय्यमतुन पेच्‍हाचि गेदुमतोर, अस्‍के आ मूकल वळकालय दल्‍गतोर. इदुन हूळसि अगा मत्‍ता अंटोर लोकुल्‍कुंक वेल्‍लेन इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","गानि अव्टेटाल इच्‍चुर मंदि, “बेलजेबुल इनना देय्याल्कुना मुक्‍यना बलमते ओर देय्याल्क तेंडांतोर,” इंचि इनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","इंका इच्‍चुर बारे ओना पट्‍टु हूळना इंचि ओनाहेंदाल स्वर्गमताल उंदि चिन्‍ह हुप्‍सा इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ओरा मनसुना विचाराल्कुन एरपाट कीसि येसु ओर्कुन इल्‍हा इत्‍तोर, “बद राज्येम लोप्पो वरोना पोल्‍ले-वरोंक अर्राकोंटा आंता, अद राज्येम पाडासि दांता. अल्हेन उंदि लोते मनानोरा नड्‍डुम वरोनद वरोंक अर्राकोंटा मत्‍ते अद लोनगुडा नासडेम आसि दांता. ");
INSERT INTO esg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","मिमेट इत्‍तिर गदा, नना बेलजेबुल इनना देय्यमता सहायमतोनि देय्याल्क गेदुमतन इंचि. अल्हा अय्ते देय्यम दाना दंटाता देय्याल्कुना विरोदमते नितते, अवुना राज्येम बल्हा नित्‍तंता? ");
INSERT INTO esg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","सरे! मिमेट इत्‍ताप, नना बेलजेबुलना सहायमते देय्याल्कुन गेदमंतन इन्‍कुंटु. गानि मीवा लोकुल्‍कगुडा देय्याल्कुन गेदमंतुर, ओरगुडा देय्यमता सहायमतोने गेदमंतुरा? अदुनहाटीं मीवा लोकुल्‍के मीवा न्‍यायम कींतुर. ");
INSERT INTO esg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","गानि नना ओक्‍कला पेनदा बलमते देय्याल्कुन गेदमानय्ते, पेनदा राज्येम मीवा दग्गेर्क एव्ता इंचि एरपाट कीम्‍टु.” ");
INSERT INTO esg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“वरोर ताकतवर मनकल गोर्कां, कसेह्‍क, तुपाकीं पीसि ओना लोता कावेल कीतेने, ओना लोता लोप्पो मनना अन्‍नि सामान बेस सांतिते मनंतां. ");
INSERT INTO esg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","गानि ओनकन्‍ना एक्‍को ताकतवर मनकल वासि ओनतोनि लडाइ कीसि ओन ओळिच्‍चानय्ते, बव गोर्कां, कसेह्कुन पोर्रो वेल्‍लेन वर्सानाल बरोसा इरतोर, अवुन इग्गुकुंचि ओनगा मत्‍ता मालुन दोसकुंतोर. पजा अंटोर्कुंक पंचि हींतोर.” ");
INSERT INTO esg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“बोर अय्ते नावा दंटाते मन्‍नोर, ओर नावा विरोदमते मंतोर, बोर अय्ते नाकु सहायम किय्योर, ओर नाहगटाल पायिचना कबळ कींतोर.” ");
INSERT INTO esg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“उंदि देय्यम बस्के अय्ते वरोर मनकानाल पेय्सि दांता, अस्‍के अद आराम कियालय एर हिल्वा जेगा पह्‍कंता. गानि दान्क असंटा जेगा दोर्को. अस्‍के अद देय्यम, नना बद लोताल अय्ते पेय्सि वातानो, अदे लोते मर्रा मल्सि दांतन, इन्‍कुंता. ");
INSERT INTO esg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","मर्रा अगा होंचि हूळतस्‍के मुन्‍नेटा लोन रिकम आताप, मंचिगा ऊसताप दानकु बेस दिसंता. ");
INSERT INTO esg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","अस्‍के अद देय्यम तिरियसि होंचि दानकन्‍ना एक्‍को सेड्‍डातव एडुं देय्याल्कुन पीसि वांता. पजा अंटव कलियसि अदे लोते मनालय दल्‍गंतां. इल्‍हा आ मनकना परिस्तिति मोदाटा परिस्तितिकन्‍ना एक्‍को कराब मनंता.” ");
INSERT INTO esg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","पजा बतल आता इत्‍ते, येसु इव पोल्‍लें वेहसेकेन मत्‍तोर, अच्‍चोटेन अगा मत्‍ता मंदिताल उंदि मुरतळ लगांचि, “नीकुन कंचि, पाल उहचि, बेरसागोटता आ तल्‍लुर वेल्‍लेन आसिर्वाद दोर्कुतद आंदु,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","अस्‍के येसु, “गानि बोर अय्ते पेनदा वचनाल्क केंजसि अवुन पीसि ताकंतोरो ओर एक्‍को आसिर्वाद दोर्कुतोर आंद,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","वेल्‍लेन लोकुल्‍क जमा आयानद हूळसि येसु इल्‍हा वळकालय दल्‍गतोर: “इद पीळितोर कराब लोकुल्‍क आंदुर. अदुनहाटीं चिन्‍ह हुप्‍सा इंचि पूस कीसंतुर. गानि योनाल इनना पेनदा कबुरतोना चिन्‍ह तप्‍पा ओर्कु इंकुंदि चिन्‍ह हुपिच्‍मळ जर्गो. ");
INSERT INTO esg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","बल्हा योनाल निनवे सहरता लोकुल्‍कुनाहाटीं चिन्‍ह आतोर, अल्हेन मनकना रूपमते पुटतोन नना, ई पीळितोरहाटीं चिन्‍ह आंतन. ");
INSERT INTO esg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","अल्‍हेने सिबा देसेमता रानि सुलेमान राजाना तेल्‍विता पोल्‍लें केंजालय वेरे देसेमताल अगा वासि मत्‍ता. हुळाट, सुलेमानुंकन्‍ना पेद्‍दोड वरोर मी मुन्‍ने नित्‍तिसि मंतोर. अय्नागानि मिमेट नावा बुद्‍दिता पोल्‍लें केंजसेक हिल्‍लिर. अदुनहाटीं आकिर न्‍यायमता रोजुने आ रानि इद पीळिता मनकालोरपोर्रो दोसेम दोस्‍सार. ");
INSERT INTO esg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","योनाल वेहता कबुर केंजसि निनवे सहरतोर अय्ते ओरा मनसु मार्सकुत्‍तुर. गानि हुळाट, योनांकन्‍ना पेद्‍दोड इंदके मी मुन्‍ने नित्‍तिसि मंतोर. अय्नागानि मिमेट मनसु मार्सकुंचेके हिल्‍लिर. अदुनहाटीं आकिर न्‍यायमता रोजुने निनवे सहरतोर नित्‍तिसि इद पीळिता लोकुल्‍कुनपोर्रो दोसेम दोस्‍सनुर.” ");
INSERT INTO esg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“बोरे आयिर वेडसि निरिच्‍चि दान गुल्‍ला हिळु मुच्‍चोर, साटुंकगुडा इर्रोर. गानि लोप्पो होळियानोर्क बेस वेल्‍गु दिसगोम इंचि दान उंदि दीसोडिपोर्रो इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","नीवा कळु नीवा मेंदुल्क वेडसिलेह्का आंदुं. नीवा कळु बेस मत्‍ते नीवा मेंदुलंता बेस वेल्‍गु मनंता. ओक्‍कला नीवा कळु बेस हिलाकोंटे नीवा मेंदुलंता हीकटे मनंता. ");
INSERT INTO esg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","अदुनहाटीं नीवा लोप्पो मनना वेल्‍गु पिरसोन्‍नाकुंटा बेस कापाडकुन. ");
INSERT INTO esg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","नीवा पूरा मेंदुल पुरागा वेल्‍गुने मत्‍ते, अद वेडसि एल्‍गुताप बेस एल्‍गुसेके मनंता आनि गिचचो मेंदुलगुडा हीकटते मन्‍नो.” ");
INSERT INTO esg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","इल्‍हा येसु ओना वळकुमळ मारतस्के वरोर परिसि ओना लोन येसुन गाटो तिनालय केयतोर. अय्ते येसु ओना लोन होंचि लोप्पो होळियसि गाटो तिनालय उदुतोर. ");
INSERT INTO esg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","येसु यहुदिल्कुना रिवाज परकारम तिनाका मुन्‍ने कय्‍कु नोरसि गाटो तिनालय उद्‍दा हिल्‍लोर. अदुन हूळसि आ परिसिंक इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","अस्‍के सामि ओन इल्‍हा इत्‍तोर, “मिमेट परिसि लोकुल्‍क गिन्‍नें-गिलासकु सिराप लोकुल्‍कुंक दिसालय पलाताल तोमसि साप कींतिर, गानि लोप्पो मात्रम मीवा कराब गुनाल्‍क, वेल्‍लेन लालच निंडसि मनंता. ");
INSERT INTO esg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","अरे बुद्‍दि तक्‍को लोकुरिटा! पलाताल तयार कीता पेने लोप्पोटाल तयार कीता. ");
INSERT INTO esg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","अदुनहाटीं मिहगा बतल अय्ते मंतनो अदुन गरिब लोकुल्‍कुंक मनसुनाल हीम्ट. अस्‍के मीहाटीं अन्‍नि साप मनंता. ");
INSERT INTO esg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","अरे परिसिल्कुनिटा! मीकु गोसा तप्‍पो. बारित्‍ते मिमेट मीवा तोटाते पुटता पुदिना, इंका वेरे अन्‍नि पंटाता पदि तूसकुनाल उंदि तूस पेनदुक हींतिर. गानि न्‍यायमतुन आनि पेनदा पावरमतुन मात्रम मिमेट मति किय्‍यिर. पदि तूसकुनाल उंदि तूस पेनदुक हियमळ इद बेसे. गानि इद कीसेक-कीसेक न्‍यायमतुन आनि पेनदा पावरमतुनगुडा होळसाकोंटा ताका मत्‍तिर. ");
INSERT INTO esg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","परिसिल्कुनिटा मीकु गोसा तप्‍पो, दर्मसास्‍त्रम कराहना लोह्कुने पेद्‍दाल्‍क उद्‍दाना जेगा मीकु गावाले इनकुंतिर. हाटुमकुने जोहार वेहागोटकुनमळ इत्‍ते वेल्‍ले इस्‍टम. ");
INSERT INTO esg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","मीकु गोसा तप्‍पो. बारित्‍ते, अगा बोंदा मंता इंचि तेळियका लोकुल्‍क जारसेके दांतुर, मिमेट आ बोंदानसंटोर आंदिर.” ");
INSERT INTO esg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","अस्‍के दर्मसास्‍त्रम बेस तेळियतोर वरोर गुरु वासि येसुन, “गुरु, निमे इसोंटा पोल्‍लें वळ्‍किसि मावदगुडा अपमानम कीसंतिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","अस्‍के येसु इल्‍हा इत्‍तोर. “अरे मूसाना नियम बेस तेळियतोरिटा, मीकु सिक्‍सा तप्‍पो. बारित्‍ते मिमेट लोकुल्‍कुनपोर्रो, तेहते तेदा पर्रुवा मोता तासंतिट, गानि मिमेट मात्रम अद मोतातुन तेहालय उंदि वेलुगुडा तासिर. ");
INSERT INTO esg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","इंचि मीकु गोसा तप्‍पो. बारित्‍ते, मीवा एनकटा पेद्‍दाल्‍क हव्‍कता पेनदा कबुरतोराहाटीं गोरिं दोहांतिर. ");
INSERT INTO esg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","इल्‍हा कीसि, मीवा एनकटा पेद्‍दाल्‍कुने आनि ओर कीता कबाह्‍कुने मिमेट कलियसि मंतिर इत्‍ताप मिमेटे गवाइ मंतिर. बारित्‍ते मीवा एनकटा पेद्‍दाल्‍क पेनदा कबुरतोर्कुन हव्कतुर, मिमेट बारे ओरा गोरिं दोहचंतिर. ");
INSERT INTO esg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","अचोने आयका पेन दाना बेस बुद्‍दिते मीवा बारेमते इल्‍हा वेहता, नना पेनदा कबुरतोर्कुन आनि प्रेरितुल्कुन ओरगा लोहांतन. अस्‍के ओर, ओराव्टेटाल इच्‍चुर्कुन हव्कानुर, इच्‍चुर्कुन बारे इरगा तिप्‍पल्‍क कियानुर.” ");
INSERT INTO esg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“दीनहेंदाल, ई दुनिया पुटतस्केटाल बच्‍चोन मंदि पेनदा कबुरतोरा नेत्‍तुर अय्ते पोंगागोटमळ जर्गतनो, आ ओरा अंटोरा नेत्‍तुरता हिसाब ई पीळितोराहेंदाल एतमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","इत्‍ते आबेलनगटाल अय्ते, गुळि आनि गद्‍दे नड्‍डुम हव्‍कता जकर्याहनगड्‍क. हां, नना मीकु निजम वेहांतन, ईर अंटोरा नेत्‍तुरता हिसाब ई पीळिता लोकुल्‍कुनहेंदाले एतमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","अरे मूसाना नियम बेस तेळियतोरिटा, मीक गोसा तप्‍पो. बारित्‍ते मिमेट पेनदा तेल्‍विता तालम कयदुन तेंडकुत्‍तिर. गानि मिमेट कुद्‍दु अय्ते होळिया हिल्‍लिर, होळियानोर्कुनगुडा आपिसि इरतिर.” ");
INSERT INTO esg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","पजा येसु अगटाल होनालय पेय्सतोर अस्‍के, परिसिर्क आनि दर्मसास्‍त्रम कराहना गुरुल्क ओन्क अड्‍डम तिरियसि, ओन रकारकाल्कुना सवाल्क पूस कीसि परेसान कियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","येसु बतलन्‍ना वळकते ओर वळकना पोल्‍लेने ओन दोर्का पियना विचारम ओरा मनसुने मत्‍ताहाटीं ओर अल्हा कियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","अच्‍चोटेन अगा वेय्‍कुना मंदि जमा आसि, इरगा गर्दि आताहेंका वरोंक वरोर जारसेके मत्‍तुर. अस्‍के येसु मोट्‍टा मोदाला ओना सिस्युल्कुनतोनि इल्‍हा वळकालय दल्‍गतोर. “परिसिल्क डोंगिर्क आंदुर, ओरा पुल्‍लटा पिंडिता बारेमते जेगर्ता मंटु. ");
INSERT INTO esg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","मुच्‍चिसि मत्‍तव अन्‍नि पोल्‍लें बय्यर आंता, तेळियाकोंटा मत्‍तव अन्‍नि वस्‍तुक पलातुक वांतां. ");
INSERT INTO esg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","अदुनहाटीं मिमेट हीकटते वळ्कता पोल्‍लें वेलगुने केंजमळ जर्गंता. आनि लोता लोप्पोटा अर्राते होंचि गुसागूसा वळ्कता पोल्‍लें येनागर्रापोर्रो एक्‍किसि वेहमळ जर्गंता.” ");
INSERT INTO esg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“इंचि नावा दंटातोरिटा, नना मीकु वेहानद बतल इत्‍ते, बोर अय्ते मीवा मेंदुल्तुन हव्का परांतुर ओर्क मिमेट वेरियमट. ओर दानकन्‍ना एक्‍को बतल किया परुर. ");
INSERT INTO esg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मिमेट बोर्कु वेरियगोमो नना वेहांतन. मीकुन हव्कुतंका नरकमते वाटना अदिकारम बोन्क अय्ते मंतानो, मिमेट ओन्‍के वेरियट. नना वेहनद इदे.” ");
INSERT INTO esg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“हेय्युं कोळ्‍का पिट्‍टें रोंडु कोत्‍तांकु अम्मुड दांतां गदा! अय्नागानि अव्टेटाल उंदि पिट्‍टेतुनगुडा पेन मति मर्गो. ");
INSERT INTO esg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","मीवा तल्‍लाता उंदि-उंदि केल्‍लु लेक्‍किस मंता. अदुनहाटीं वेरियमट! पेनदा मुन्‍ने मिमेट वेल्‍लेन कोळ्‍का पिट्‍टेंकन्‍ना बच्‍चोरो विल्‍वा मत्‍तोर आंदिर.” ");
INSERT INTO esg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“नना मीकु वेहांतन, बोर अय्ते लोकुल्‍कुना मुन्‍ने नाकुन एरपाट कींतन इंचि ओप्‍कुंतोरो, मनकना रूपमते पुटतोन ननागुडा ओन पेनदा दूताना मुन्‍ने, ‘एरपाट कींतन’ इंचि ओप्‍कुंतन. ");
INSERT INTO esg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","गानि बोर अय्ते लोकुल्‍कुना मुन्‍ने नाकुन ‘एरपाट किय्योन’ इंतोरो, ननागुडा ओन पेनदा दूताना मुन्‍ने ‘एरपाट किय्योन’ इंचि इंतन. ");
INSERT INTO esg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","मनकना रूपमते पुटतोन नाकु विरोदमते बोर वळ्‍किना, पेन ओना तप्‍पुकुन मापि किय्‍यार. गानि पवित्र आत्माता अपमानम कियानोना तप्‍पुकुंक मात्रम मापि हिल्‍ले.” ");
INSERT INTO esg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","“मीकुन दर्मसास्‍त्रम कराहना लोह्कुने, राज्येम कियानोरा मुन्‍ने इंका अदिकारिल्कुनगा पूसकियालय ओतास्के, अगा मिमेट बतल वळकुगोमो अद, पवित्र आत्मा मीकु अस्‍केन कराहंता. अदुनहाटीं बतल वळ्कना, बतल वळ्‍कानायो इंचि रंदि कियमट.” ");
INSERT INTO esg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","आ मंदिताल बोरो वरोर मनकल येसुन, “गुरु, नावा दादल नावा बाबाना अस्तिताल नाकु बतले हीसेक हिल्‍लोर, नावा पालुंक वायना आस्‍ति नाकु पंचि हीम इंचि निमे ओन्क वेहा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","अस्‍के येसु ओन, “अरे दादा! मीवा आस्‍तिं पंचि हियालय नाकुन बोरन्‍ना ‘पेद्‍दा मनकल हिलाकोंटे न्‍यायम कियानोर’ इंचि इरतोरा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","पजा येसु ओरतोनि, “बेस जेगर्ता मंचि, अन्‍नि लालचकुनाल मीवद मिमेटे लक्‍कु मंटु! बारित्‍ते मनकना पिस्वर वेल्‍लेन आस्‍ति मत्‍तेन बेस मनंता इंचि इनकुन्‍मट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","पजा येसु ओर्कु उंदि वेसुड वेहतोर: “वरोर वेल्‍लेन सिरमंत मनकल मत्‍तोर. उंदि मल्का बतल आता इत्‍ते, ओना नेदे इरगा पंटा पेय्‍स्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","अस्‍के मनसुने ओनद ओरे, ‘पंटा अय्ते वेल्‍लेन पेय्‍स्‍ता. गानि दीन इर्रालय मात्रम जेगा हिल्‍ले, बतल कीकन?’ इन्कुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","मर्रा विचारम कीसि, ‘सरे! नना नावा पडना जेगातुन कुल्हाचि पेद्‍दागा कींतन. कीसि पूरा पंटातुन, सामानतुन अव्टे वाटसि इर्रांतन. ");
INSERT INTO esg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","पजा नना नावा जीवक, नीकु वेल्‍लेन वर्सांनदाका हालानाल रुसि आता गाटो दोसतन, तिन्‍नु, उन्‍नु आनंदमते मन्‍नु, रंदि कियमा, इंचि वेहांतन,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","गानि पेन ओन, ‘अरे तेलिवि तक्‍को मनका, इय्याला नर्कळके नीवा जीवा होनानय्ते निमे संपादिस्तादंता बोन्क आयार?’ इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","बच्‍चोर पेद्‍दा सिरमंत मनकल अयना ओर पेनदा मुन्‍ने सिरमंतुड आयोर, बारित्‍ते ओर ओनाहाटींगें आस्‍ति जमा कींतोर इंचि. ई वेसुडिते ई मनकना गति गुडा अल्हेन आता.” ");
INSERT INTO esg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","पजा येसु ओना सिस्युल्कुंक इल्‍हा वेहालय दल्‍गतोर: “नना मीकु वेहनद बतल इत्‍ते, जीवा तिंडिकन्‍ना मुक्‍केम, मेंदुल कपडींकन्‍ना मुक्‍केम आंदु. इंचि पिस्‍सनाहाटीं तिनकोम बतल, उनकोम बतल, इंका मेंदुल्ताहेंका केर्कोम बतल इंचेके रंदि कियमट. ");
INSERT INTO esg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","बारित्‍ते तिंडिकन्‍ना पिस्वर मुक्‍येम, कपडींकन्‍ना मेंदुल मुक्‍येम. ");
INSERT INTO esg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","आ काकाह्कुन हुळाट! अव वीतों आनि कोय्यों. अचोने आयका अवुनगा गुम्मिं इंका हिल्‍लें. अयना पेन अवुन पोस कीसंता. अदुनहाटीं मिमेट अय्ते आ पिट्‍टेंकन्‍ना बच्‍चोनो विलवा मत्‍तोर आंदिर. ");
INSERT INTO esg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","रंदि कीसि ओना आवसुन उंदि गंटा एक्‍को बेरसागोटतोर मीवा नड्‍डुम बोरन्‍ना मंतोरा? हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","इसंटा सिन्‍ना-सिन्‍ना कबाह्के मिमेट किया परिर. अय्ते इंका मिगुल्ता कबाह्‍कुना बारेमते मिमेट रंदि बारि कींतिर?” ");
INSERT INTO esg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“आ पूतनहेके हुळट अव बल्हा बेर्ससंतांगो! अव कबळ किय्यों, कपडिं इंका कुट्‍टों. नना वेहानद बतल इत्‍ते, सुलेमान राजाल वेल्‍लेन सिरमंत मंचिगुडा ओना कपडिं आ पूतानाल उंदि पूतातच्‍चोगुडा सोकु मनाहिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","अय्ते जाडि इय्याला मंता, नाडि तडमिते वेसि दांता. अयना आ जाडिके पेनबाबाल इच्‍चोन बेसता कपडिं हींतोर. अय्ते अवुंकन्‍ना बेसता कपडिं मीकु हिय्या पर्रोरा रो, विस्वासम तक्‍को लोकुरिटा? ");
INSERT INTO esg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अदुनहाटीं बतल तिंदकोम, बतल उंडकोम इंचेके मिमेट रंदि कियमट. अल्‍हेने अवुन दोर्किच्‍कुनाहाटीं गाबरगुडा आयमट. ");
INSERT INTO esg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","दुनियातोर अंटोर लोकुल्‍क इवुनाहाटींगें तनलाळसेक मनांतुर. गानि मीकु इव अन्‍नि गावाले इंचि मीवा पेनबाबांक एर्के मंता. ");
INSERT INTO esg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","अदुनहाटीं मिमेट मुन्‍ने स्वर्ग राज्येमतुन आनि पेनदा नीतितुन पह्कट. अस्‍के इव मीकु दोर्कनुं.” ");
INSERT INTO esg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“अरे नावा सिस्युल्कुनिटा, ‘मीवा पेनबाबाल ओना राज्येमतुन मीकु हियालय वेल्‍लेन कुसिते तयार मंतोर. अदुनहाटीं मोमोट वेल्‍ले मंदि हिल्‍लोम’ इंचि वेरियमट. ");
INSERT INTO esg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अय्ते मिमेट मिहगा मत्‍ता आस्तिनअंता अम्मिसि, गरिबोर्कुंक दान-दर्मम कीसि, बस्‍केने पडन आयाकोंटा मनना कोत्‍ताना संचितुन दोर्किच्‍कुंट. इंका मिमेट मीवाहाटीं स्वर्गमते दनम जमा कीम्‍ट. अगा बोर दोंगलगुडा वायोर, दानकु सेदेलगुडा पिय्यो. ");
INSERT INTO esg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","बारित्‍ते मीवा दनम बगा मत्‍ते अग्गेन मीवा मनसु मनंता.” ");
INSERT INTO esg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“मरमिना कुळपुने होंचि वायना मालकुन एदुर हूळसेक मनना सेवाकुल्कुनलेसीं कबळ कियालय बस्केळक नडिकट्‍टु दोहचि तयार मंटु. अल्हे मीवा वेडसिन इंका बस्केळक एल्‍गिच्‍चे इर्राट. अल्हा मत्‍ते बतल आंता इत्‍ते, मालक वासि तल्‍पुन तंता तन्‍मडे तल्‍पु तेंडालय अल्कगा मनंता. ");
INSERT INTO esg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","मालक वातस्के एदुर हूळसेक तेल्‍विते मत्‍ता सेवाकुल्कु वेल्‍लेन आसिर्वाद दोर्कुतोर आंदुर. नना मीकु निजम वेहासेक मंतन, मालक वासि अंटोर सेवाकुल्कुन बेस उद्‍दा वेहांतोर. पजा नडिकट्‍टु दोहकुंचि ओरे सेवाकुल्कुना सेवा कियालय तयार आंतोर. ");
INSERT INTO esg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","मालक बस्के वायिना, इत्‍ते नडजाम नर्का आयि हिलाकोंटे नडजाम नर्का दाटसि होतंका आयि वातस्के, बोर सेवाकुल्क अय्ते तेल्‍विते मनांतुरो आ सेवाकुल्कु वेल्‍लेन आसिर्वाद दोर्कुतोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","गानि मिमेट उंदि पोल्‍ले बेस तेळियागोट्‍कुंटु. अद बतल इत्‍ते, दोंगल बद वेलाक वांतोर इंचि ओक्‍कला लोता मालकुंक मुन्‍नेन तेळियसि मत्‍ते ओर तेल्वितेन मनांतोर आनि आ दोंगन लोते होळिया हिय्योर. ");
INSERT INTO esg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","अल्‍हेने मिमेट इनकुनवा वेलाके मनकना रूपमते पुटतोन नना वांतन. अदुनहाटीं मिमेटगुडा बेस तयारते मंटु.” ");
INSERT INTO esg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","अस्‍के पत्रु, “सामि, निमे ई वेसुडिं सिराप मावाहाटींगे वेहचंतिना, हिलाकोंटे अंटोर हाटींगा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","अस्‍के सामि इल्‍हा इत्‍तोर: “मालक हिल्वस्के ओनगा कबळ कियानोर्कुंक वेलापोर्रो गाटो-जावा दोस्‍सालय, वरोर बेस तेल्विगल्‍लोड, विस्वासमलायक दिवांजि मालाकुंक गावाले. अय्ते असोंटा सेवक बोर मंतोर? ");
INSERT INTO esg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","बोर सेवक अय्ते, मालक मल्सि वातस्के वेहता कबळ बरोबर कीसेक मनांतोर, ओरे सेवक बेस आसिर्वाद दोर्कुतोर आंद. ");
INSERT INTO esg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","नना मीक निजम वेहांतन. मालक आ सेवाकुन ओना पूरा आस्‍ति-पास्तिनपोर्रो अदिकारि इंचि इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","गानि ओक्‍कला आ सेवकुडु, ‘नावा मालक वायालय अय्ते आल्‍सेमे मंता,’ इनकुंचि कळमता दासि मुरतळ, मांड्‍सा सेवाकुल्कुन तन्‍नुड-गुद्‍दुड कियमळ, इरगा तिंचि-उंचि बदमासिं कियमळ सुरुव कीतोर इनकुन! ");
INSERT INTO esg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","अस्‍के आ सेवक विचारमगुडा किय्योर असोंटा रोजुने, गळियाते ओना मालक वायानुर. वासि, आ सेवाकुंक पेद्‍दा सिक्‍सा हीसि, ओन अविस्वासुल्‍क मनना जेगाते वाटसीयनुर.” ");
INSERT INTO esg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“बा सेवक अय्ते, ओना मालाकुंक बतल गावालेनो तेळियसिगुडा, मालक वेहताप केंजाकोंटा, कियाकोंटा मनांतोर, आ सेवक मात्रम वेल्‍लेन देब्बा तिंतोर. ");
INSERT INTO esg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","गानि तेळियका बदो कबळ कीसि देब्बाना पाल आता सेवाकुंक मात्रम तक्‍को देब्बां आंतां. पेन बोर्कु अय्ते बेसता कबळ कियनाहाटीं वेल्‍लेन गुनम हीता ओराहेकटाल वेल्‍लेन लेक्‍का तल्कंता. अल्‍हेने बोन्क अय्ते एक्‍को अप्पजेपता, ओनहेकटाल अप्पजेपता दानकन्‍ना एक्‍कोने तल्कंता.” ");
INSERT INTO esg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“नना ई बूमिते लोकुल्‍कुनपोर्रो तळमितसोंटा न्‍यायम कियालय वातन. अद इंदकेन अंटुकुंचि मत्‍ते बच्‍चोनो बेस आयवड इंचि इनकुत्‍तन. ");
INSERT INTO esg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","गानि नाकु उंदि कस्‍टाल्‍कुना बापतिस्मा एतानद मंता, अद एतनदाका नाकु तिप्‍पल्‍क तप्पों. ");
INSERT INTO esg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","नना इद बूमिपोर्रो सांति हियालय वातन इंचि मिमेट इन्कुंचंतिरा? हिल्‍ले. नना अदुनहाटीं वाया हिल्‍लेन. गानि मीकुन वेरे-वेरे कियालय वातन इंचि नना मीकु वेहासेक मंतन. ");
INSERT INTO esg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","इंदकेटाल बदन्‍ना उंदि लोते हेय्युर मत्‍ते, ओरद ओर्के अर्राका इव्वुर उंदि पक्‍काक, मुव्वुर इंकुंदि पक्‍काक आसि वेरे आंतुर. ");
INSERT INTO esg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","अल्‍हेने मर्रिनद बाबोनतोनि-बाबोनद मर्रिनतोनि, मिय्‍याटद तल्‍लुनतोनि-तल्‍लुनद मिय्यळतोनि, कोळियाटद पोरळतोनि-पोराटद कोळियळतोनि अर्राकोंटा आंता.” ");
INSERT INTO esg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","पजा ओर मंदिक इल्‍हा वेहतोर. “मब्बु तेर्पेन पोळ्‍द अर्रनहेके हूळसि मिमेट, ‘अद हुळट, पिर्रु वासेक मंता,’ इंचि वेह्कुंतिर. अल्हेन आंतागुडा. ");
INSERT INTO esg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","इंका होव्वोर वळि वायनद हूळसि, ‘इंदके गर्मी अर्रंता’ इंचि इंतिर. अल्हे आंतागुडा. ");
INSERT INTO esg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","अरे डोंगिरिटा, मीकु बूमि, मब्बुना रूपाल्‍कु एरपाट किया वांता. गानि इद वेलाते बतल जर्गसंता इदुन मिमेट बारि एरपाट कीसेक हिल्‍लिर?” ");
INSERT INTO esg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“असल बेस न्‍यायम बद आंद, अद मीवद मिमेटे बारि निरनायम किया परसाहिल्‍लिर? ");
INSERT INTO esg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","निमे नीवा पगातोनतोनि कलियसि कोरटते मजिस्‍टरनगा होननेंके हरदेन ओनतोनि बेस संबंदम कल्‍पुकुन. अल्हा कियाकोंटे नीकुन नीवा पगातोर कोरटते मजिस्‍टरुंक अप्‍पजेपनुर. मजिस्‍टर नीकुन पोलिसुल्‍कुंक अप्‍पजेपनुर, पोलिसुल्क ओसि नीकुन जेलने वाटानुर. ");
INSERT INTO esg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","नना नीकु निजम वेहांतन, कोत्‍तक-कोत्‍ता दोहनदाका निमे अगटाल पेय्‍सा पर्रिन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","अदे वेलाते अगा मत्‍ता लोकुल्‍कुनाल इच्‍चुर लोकुल्‍क वासि येसुंक, “गालिल एरियाता इच्‍चुर मनकालोर गुळिते मोक्‍कु हीसेक मननेंके पिलातुस ओना सिपाइल्कुन लोहचि ओर्कुन हव्का वेहतोर. आ सिपाइल्क ओर्कुन गुळितेन हव्कतुर. इल्‍हा पिलातुस ओरा नेत्‍तुरतुन मनम मोक्‍कु हियना नेत्‍तुरते कल्‍पतोर,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","अस्‍के येसु ओर्कु इल्‍हा जवाब हीतोर, “गालिल एरियाताल वाता ई मनकालोर्कुंक इसंटा हामुर वाता अय्ते, ई मनकालोर गालिल एरियाता वेरे मनकालोर्कुंकन्‍ना एक्‍को पापम कीतुर इंचि मिमेट इन्कुंचंतिरा? ");
INSERT INTO esg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","नना वेहासेक! अल्हा बिल्कुले आयो. गानि पापमताल मनसु मार्सकुंचि पेनदाहेके तिरियाकोंटे मिमेटगुडा ओरालेसींगे हासि नासडेम आंतिर. ");
INSERT INTO esg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","सरे इंदके वेहाट! सिलो इनना गोपुरमकूलसि अरताहेंका पद्‍देनमिदि मंदि मनकालोर हातुर. अय्ते ई गोपुरम कूलता वेलाते येरुसलेमते मत्‍ता वेरे मनकालोर्कुंकन्‍ना हासोत्‍ता ई पद्‍देनमिदि मनकालोर एक्‍को तप्पु कीतुर इंचि इन्कुंचंतिरा? ");
INSERT INTO esg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","हिल्‍ले. नना मीकु वेहनद बतल इत्‍ते, पापमताल मनसु मार्सकुनाकुंटे मिमेट अंटोरगुडा ओरालेसींगे हासि नासडेम आंतिर.” ");
INSERT INTO esg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ओर्कु बेस तेळियनाहाटीं पजा येसु इंकुंदि वेसुड वेहालय सुरुव कीतोर. “वरोर मनकल ओना अंगुर तोटाते उंदि अंजिर मरा वाटतोर. उंदि रोज अद मरा कायां हादतना, हादा हिल्‍लेना, इंचि हूळालय होत्‍तोर, गानि अदुंक कायां हादसि मनाहिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","अस्‍के आ मनकल ओना तोटाते कबळ कियना जीतागानकु, हूळा, ई अंजिर मरा कायां हादता बारे इंचि नना मूड वर्सानाल इगे दीन हूळालय वासंतन, गानि दीनकु बस्‍केने उंदि काया इंका नाकु दिसा हिल्‍ले. इसंटा मरातुन इर्सि बता पायदा? नर्किसि पोहा, इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","अस्‍के आ जीतागाड, मालक, ई उंदि वर्सामेड मन्‍निकांटी. नना दीन सुट्‍टु तव्‍सि बेस एरवु वाटंतन. ");
INSERT INTO esg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","अस्केनना हादते सरे, हिलाकोंटे नर्किसि पोहा वच्‍चु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","उंदि नोमकेम रोजुननाड येसु उंदि दर्मसास्‍त्रम कराहना लोते कराहसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","देय्यम पीताहेंका पद्‍देनमिदि वर्सानाल बिमार अर्सि मत्‍ता उंदि मुरतळ अगा मत्‍ता. दाना नळि वंकर आसि गूनि पेय्सि मत्‍ताहेंका दान्क बेस नित्‍ता वायाकोंदु. ");
INSERT INTO esg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","येसु दान हूळसि ओना दग्गेर्क केयतोर. केय्‍सि, “बाई! निमे नीवा रोगमताल पलाते अरतिन,” इंचि, पजा दाना तल्‍लापोर्रो कय इरतोर. कय इरता इरमळे अद बेस नित्‍तिसि पेनदुन तल्‍सकुनालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","बिमार मत्‍ता मुर्ताटुन नोमकेम रोजुननाड येसु बेस कीताहेंका दर्मसास्‍त्रम कराहना लोता अदिकारिंक इरगा होंगु वाता. अस्‍के ओर लोकुल्‍कुन, “कबाह्‍क कियालय उंदि वारमते हारुं रोजकु मंतां गदा! अय्ते आ रोजकुने वासि मिमेट मीवा बिमारकुनाल बेस आम्टु, गानि नोमकेम रोजुननाड वासि आयो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","अस्‍के सामि जवाबुने ओर्कुन, “अरे डोंगि लोकुरिटा, नोमकेमनाडु मीवाव्टेटाल हरेक मनकल कोंदातुन आयि गाडदितुन आयि लेहाकुंचि एर उहालय ओयिरा? ");
INSERT INTO esg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","अय्ते पद्‍देनमिदि वर्सानाल पेद्‍दा देय्यम पीसि मत्‍ता अब्राहामुना वंसमता ई मुरताटुन, नोमकेम रोजुननाड बेस कीते इव्टे तप्पु बतल मंता?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","येसु वळ्‍कुता ई पोल्‍लें केंजसि बोर लोकुल्‍क अय्ते ओना विरोदमते मत्‍तुरो, ओर्क अंटोर्क सिग्गु वाता. गानि येसु कीता इचंत्रम आयना कबाह्‍कुन हूळसि लोकुल्‍क मात्रम इरगा कूस आतुर. ");
INSERT INTO esg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","पजा येसु इल्‍हा वेहतोर. “पेनदा राज्येम बल्हा मनंता? नना दान बदुनलेह्का मंता इनकन? ");
INSERT INTO esg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","पेनदा राज्येम आवाल्‍कुना उंदि पेडेतसोंटद आंद. आ पेडेतुन बोरो वरोर मनकल ओसि ओना तोटाते वीततोर. अद मोलियसि, बेर्स्‍सि पेद्‍दा मरा आता. अस्‍के परियना पिट्‍टें दाना पंगांक गूडां दोहकुत्‍तां.” ");
INSERT INTO esg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","येसु मर्रा इल्‍हा इत्‍तोर. “पेनदा राज्येमतुन नना बदुनलेह्का मंता इंचि इनकन? ");
INSERT INTO esg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","अद पुल्‍लटा पिंडितसोंटद आंद. बदो उंदि मुरतळ पुल्‍लटा इच्‍चुर पिंडितुन मूड तव्‍वना पिंडिते कल्‍पता. अस्‍के आ पिंडिअंता पुल्‍लगा आता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","येसु येरुसलेम होननेंके वेल्‍लेन नाह्कुने, सहरकुने होंचि अगाटा लोकुल्‍कुंक पेनदा पोल्‍लें कराहसेक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","अस्‍के बोरो वरोर मनकल येसुन, “सामि, पापमताल मुक्‍ति इच्‍चुर मंदिके दोर्कंतना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","अस्‍के येसु ओन्क इल्‍हा वेहतोर. “मिमेट बस्‍केळ्‍क इर्कुटोम मत्‍ता हरदाल होळियालय इरगा कोसिस कीम्‍ट. नना वेहानद बतल इत्‍ते, आ हरदाल वेल्‍ले मंदि होळियालय हूळांतुर गानि ओर होळिया परुर. ");
INSERT INTO esg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","लोता मालक तेदसि उंदि मल्का तल्‍पु वाटानय्ते मिमेट पलाते नित्‍तिसि तल्‍पुन टोक-टोक कीसेके, ‘सामि मावाहाटीं तल्‍पु तेंडा,’ इंचि इंदकिर. गानि, ‘मिमेट बगाटाल वातिर? नना मीकुन एरपाट किय्योन,’ इंचि ओर मीकुन इंतोर. ");
INSERT INTO esg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","अस्‍के मिमेट, ‘नीवातोनि कलियसि मोमोट तित्‍तोम, उट्‍टोम. इंका निमे मावा नाटे वासि माकु बजारकुने पेनदा पोल्‍लें कराहतिन,’ इंचि इंदकिर. ");
INSERT INTO esg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","गानि ओर मात्रम, ‘नना मीकु वेहासेक मिमेट बगाटाल वातिरो, बोर आंदिरो नना मीकुन एरपाट किय्योन. अरे सेड्‍डा कबाह्‍क कियानोरिटा, मिमेट इगेटाल पेय्सि होंटु,’” इंचि इंतोर. ");
INSERT INTO esg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“पेनदा राज्येमते अब्राहाम, इसाक, याकोब अल्‍हेने पेनदा कबुरतोर अंटोर्कुन मिमेट हूळांतिर, गानि मीकुन मात्रम अगटाल, पेन पलाते हीकटते वाटसींता. अगा सिराप अळमळ, पल्कु कोर्कमळे मनंता. ");
INSERT INTO esg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","अस्‍के उत्‍तर-दक्‍सिनताहेंदाल, पोळ्‍द पेयसनाहेंदाल, पोळ्‍द अर्रानाहेंदाल लोकुल्‍क वासि, पेनदा राज्येमते उद्‍दानुर. ");
INSERT INTO esg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","गानि हुळाट! मुन्‍ने मत्‍तोर इच्‍चुर पज्जो आयानुर आनि पज्जो मत्‍तोर इच्‍चुर मुन्‍ने आयानुर.” ");
INSERT INTO esg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","अच्‍चोटेन इच्‍चुर परिसिल्क वासि येसुन, “नीकुन अंतिपस हेरोद राजाल हव्कालय हूळसंतोर, निमे इगेटाल बद्‍दना वेरे जेगाते पेय्सि होन,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","अस्‍के येसु ओर्क इल्‍हा वेहालय दल्‍गतोर. सरे! मिमेट होंचि आ नक्‍काकु वेहट गदा, इय्याला नाडि नना देय्याल्कुन पेचाहसि गेदमंतन, बेस हिलवोर्कुन बेस कींतन, मन्‍ने नावा कबाटुन महांतन. ");
INSERT INTO esg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","अयना येरुसलेम सहरता पलाते वरोर पेनदा कबुरतोंक हामुर वायमळ बेस आयो. अदुनहाटीं इय्याला, नाडि, मन्‍ने नाकु ताकसेकेन मना पींता. ");
INSERT INTO esg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ए येरुसलेमतोरिटा, ए येरुसलेमतोरिटा! मिमेट पेनदा कबुरतोर्कुन हव्‍कानोर आंदिर, इंका पेन मिहगा लोहचीतोर पोर्रो मिमेट बंडां हुक्‍कानोर आंदिर. कोर्रु दाना पीसेन रेक्‍काना हिळु बल्हा जमा कींतनो, अल्हेन ननागुडा मीवा पिलाल्कुन जमा कियना इंचि बच्‍चुंगो मल्कां कोरतन. गानि मिमेट मात्रम कोराहिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","हूळा, मीवा लोन मीहाटीं कुल्‍ला होळ्‍समळ जर्गता. नना मीकु वेहानद बतल इत्‍ते, सामिना पोरोलते वायानोर आसिर्वाद दोर्कतोर इंचि बदवेरदाका अय्ते मिमेट इन्‍निरो अदवेरदाका नाकुन मर्रा हूळिर, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","उंदि नोमकेम रोजुननाड येसु परिसि अदिकारिल्कुनाल वरोर अदिकारिना लोन गाटो तिनालय होत्‍तोर. अगा मत्‍तोर अंटोर लोकुल्‍क येसुन बदन्‍ना पोल्‍लेते दोर्का पियालय ओनहेके बेस हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","अगा येसुना मुन्‍ने वरोर काल्क-कय्‍क तोयाना बिमार मत्‍ता मनकल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","अस्‍के येसु, “नोमकेम रोजुननाड बिमार मत्‍तोर्कुन बेस कियमळ दर्मसास्‍त्रम परकारम बेसा, बेस आयोना?” इंचि मूसाना नियम बेस तेळियतोर्कुन आनि परिसिल्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","गानि ओर बतले वळकाकोंटा चुपचाप मत्‍तुर. पजा येसु आ तोयसि मत्‍ता मनकनपोर्रो कय ताससि ओन बेस कीसि, अगटाल होना वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","पजा, “मिहागटाल बोनादन्‍ना गाडदि आयि कोंदा आयि नोमकेम रोजुने कुहिते अरते, अदे रोजुने दान बिराना कुहिताल तेंडिरा?” इंचि येसु ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","अयना ओर मात्रम येसुंक जवाब हिया पराहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","पजा अगा बोजनमहाटीं वाता मनकालोर्कु, पेद्‍दा मनकालोर उद्‍दाना जेगां पहकिसि उद्‍दालय हूळुंदुर. अदुन हूळसि येसु ओर्कु इल्‍हा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“बोरन्‍ना मीकुन मरमिने गाटो तिनालय केयतस्‍के मिमेट होंचि पेद्‍दा मनकालोर उद्‍दना जेगाते उदमट. बारित्‍ते मीकुन बोर मनकल अय्ते केयतोरो ओर मीकन्‍ना एक्‍को कदर मत्‍ता मनकनगुडा केय्‍सि मनानुर. ");
INSERT INTO esg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","पजा मीकुन इव्वुर्कुन केयता आ मनकल मिहगा वासि, ‘निमे उद्‍दिसि मनना जेगाते ईन उद्‍दाहीम’ इंचि मीकुन अगटाल तेहानुर. अस्‍के मीवद सिग्गु होंचि अंटोरा मुन्‍ने सिन्‍नाल्क उद्‍दाना जेगाते होंचि हिळु उद्‍दा पींता. ");
INSERT INTO esg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","अदुनहाटीं बोरन्‍ना मीकुन गाटो तिनालय केयंतोर अस्‍के मिमेट होंचि, सिन्‍नाल्क उद्‍दाना जेगाते हिळु उद्‍दिसि मंटु. बस्के अय्ते मीकुन केयता मनकल वासि मीकुन, ‘दादा, इगेटाल तेदसि आ बेसता जेगाते होंचि उद्‍दा,’ इंचि वेहनुर अस्‍के मीवातोनि कलियसि गाटो तिनना अंटोर हेडमितोरा मुन्‍ने मीकु बेस कदर दोर्कार. ");
INSERT INTO esg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","बारित्‍ते, बोर अय्ते ओनद ओरे ‘नना पेद्‍दोन’ इंचि वेहकुंतोर, ओन पेन सिन्‍ना किय्‍यार आनि बोर अय्ते ‘नना सिन्‍नोन’ इंचि वेहकुंतोर, ओन पेन पेद्‍दा किय्‍यार.” ");
INSERT INTO esg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","पजा येसुन बोर अय्ते केयतोरो आ मनकंकगुडा येसु उंदि पोल्‍ले वेहतोर. “निमे नर्का-पिय्यल बस्के बोजनम हिय्‍यिना आ बोजनमते नीवा दंटागाह्कुन, नीवा दादल-तम्मुह्‍कुन, जीवातोर-हेडमितोर्कुन, मीवा पक्‍का लोह्कुना सिरमंत लोकुल्‍कुन केयुमा. ओर्कुन केयते, निमे ओर्कुन केयताप ओरगुडा नीकुन केयांतुर, इल्‍हा नीवा बाकि तीरंता. ");
INSERT INTO esg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ओर्कुन केयनदानकन्‍ना निमे गरिबोर्कुन, गुड्‍डोर्क-गूनोर्कुन, ताका परवोर्कुन केया. ");
INSERT INTO esg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","अस्‍के नीवा बाकि तीरसालय ओर नीकु बतल हिया पर्रुर. गानि पेनदा नदरते नीतिमंतुल्क मत्‍तोर हासि मर्रा जीवाते तेदतस्‍के पेनदाहेंदाल नीकु नीवा इनाम तप्‍पाकोंटा दोर्कंता.” ");
INSERT INTO esg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","येसु इत्‍ता आ पोल्‍लेतुन केंजसि, उद्‍दिसि गाटो तिनानोराव्टेटाल वरोर मनकल येसुन, “पेनदा राज्येमते उद्‍दिसि बोजनम कियना मनकल आसिर्वाद दोर्कुतोर आंद,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","अस्‍के येसु वेसुडिते इल्‍हा वळकालय दल्‍गतोर. वरोर मनकल पेद्‍दा कुळ्‍पु इर्सि आ कुळ्‍पुंकु वेल्‍लेन मंदितुन केयतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","कुळ्‍पु तयार आतस्के, अन्‍नि तयारिं आतां, बोर्कुन अय्ते केयतोम आ मनकालोर्कुन केय्‍सि तराहोंटु, इंचि आ मालक ओना दासुन लोहतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","गानि ओर अंटोर इल्‍हा विनंति कियालय दल्‍गतुर. मोदाला कलियतोर, नना उंदि पूना पोलम अस्तन, नाकु दान हूळापींता, निमे बतल इनिना बेसे, नना वाया पर्रोन, नाकुन मापि कीम इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","इंकावरोर, नना हेय्युं जोडिं कोंदां अस्तन, अव बल्हा कबळ कींतंगों नाकु अवुन हूळापींता. नाकुन मापि कीम, नना वाया पर्रोन, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","मर्रा इंकावरोर, नना इंदकेन मरमिं आतन, नना वाया पर्रोन, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","अस्‍के आ दासुड मल्सि वासि जर्गुतद अंता ओना मालकुंक वेहतोर. अस्‍के मालकुंक इरगा होंग वाता. पजा ओर ओना दासुंक इल्‍हा वेहतोर. निमे बिराना सहरता हर्कुन पीसि, मूला-मूलाक होंचि गरिबोर्कुन, गुड्‍डोर-गूनोर्कुन, कुंटोर्कुन इगे केयकुंचि वा, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","अस्‍के दासुड मालक वेहतापे कीतोर. पजा मर्रा मल्सि वासि मालकुंक इल्‍हा वेहतोर. मालक, निमे वेहतापे नना होंचि केय्‍सि तत्‍तन. अय्नागानि इंका वेल्‍लेन जेगा मिगिल्सि मंता, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","अस्‍के मालक दासुंक इल्‍हा वेहतोर. “निमे रोडकुन पीसि, हर्कुन पीसि होंचि लोकुल्‍कुन बतिमलाडसि पीसि वा. नावा लोन पुरागा निंडिसि मनगोम अचोने. ");
INSERT INTO esg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","नना मीकु निजम वेहचंतन, नना मुन्‍ने केय्‍सि मत्‍ता वरोर मनकलगुडा नना हीता बोजनमता रुसि हूळा परुर, इंचि इत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","येसुनतोनि वेल्‍लेन मंदि लोकुल्‍क ताकसि वासेके मत्‍तुर. अस्‍के येसु ओराहेके तिरियसि इल्‍हा वळकालय दल्‍गतोर: “नहगा वांतन इंचि इनकुत्‍तोर बोरन्‍ना आयिर, ओर ओना यावन-बाबान, मुत्‍तो-पिलाल्कुन, तम्मुर-तादन, अक्‍कल-हेलाह्कुन, इंका ओना जीवातुन एक्‍को पावरम कीते, ओर नावा सिस्युड आया परोर. ");
INSERT INTO esg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","अचोने आयका बोर अय्ते ओना सतता क्रुस पीसि नावा पज्जो वायोन इंतोर, ओरगुडा नावा सिस्युड आया परोर.” ");
INSERT INTO esg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“मीवाव्टेटाल बोरन्‍ना आयिर, उंदि एत्‍तुंक एत्‍तु मिद्‍दे दोहंतन इनकुत्‍ते, ओर मोदाला आरामते उद्‍दिसि इद मिद्‍देतुन दोहालय बच्‍चोन वेल्‍ले कर्च वायार? इंका बतल-बतल अय्ते गावालेनो, अव अन्‍नि मंतंगां मरि हिल्‍लेंगां? इवुना बारेमते विचारम किय्योरा? कींतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","ओक्‍कला अल्हा कियाकोंटे ओर पायवा अय्ते दोहंतोर गानि मिद्‍देता कबळ मात्रम पुरागा किया परोर. असोंटस्के अदुन हूळतोर अंटोर ओन कारेड्‍डाल्‍क कीसेके, अद हुळट रो! ई मनकल मिद्‍दे दोहालय अय्ते सुरुव कीतोर गानि पुरागा दोहा पराहिल्‍लोर, इंचि इंतुर.” ");
INSERT INTO esg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“हिलाकोंटे, ‘नना पदि वेय्‍कुना सिपाइल्कुन पीसि इरवै वेय्‍कुना मंदि सिपाइल्कुन गेल्सा परांतना?’ इंचि गिच्‍चचोगुडा विचारम कियाकोंटा लडाइ कियालय दांतोर! असंटोर बोरन्‍ना राजाल मंतोरा? ");
INSERT INTO esg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ओक्‍कला अल्हा कीते आ राजाल बोनतोनि अय्ते लडाइ कियानद मंता, ओना सिपाइल्क लक्‍कु मननेंके इच्‍चुर विस्वासमता सिपाइल्कुन एदुर लोहचि सांति-समादानम कियना विचारम कींतोर. ");
INSERT INTO esg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","इल्हेने मीवाव्टेटाल बोरन्‍ना आयिर, मिहगा मत्‍तव अन्‍नि आस्‍ति-पास्तिन होळसोन इंतोर, ओर नावा सिस्युड आया परोर.” ");
INSERT INTO esg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“होव्वोर बेसे मनंता गानि होव्वोर, होव्वोर रुसि वायाकोंटे, अव्टे मर्रा बल्हा होव्वोर रुसि तरा परांतोम? ");
INSERT INTO esg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","असंटा होव्वोर तोळिते कल्‍पालयगुडा ओज्‍जो, एरवुहाटींगुडा ओज्‍जो. अद सिराप पलाते पोहचियालये ओज्जंता. बोर्कु केंजालय केव्क मंतां ओर केंजट.” ");
INSERT INTO esg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","उंदि रोज कर वसुल कियानुर आनि पापि लोकुल्‍क येसुना पोल्‍लें केंजालय ओनगा जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","जमा आतद हूळसि, परिसिल्कु आनि दर्मसास्‍त्रम कराहना गुरुल्क येसुन, “ई मनकल पापि लोकुल्‍कुन दग्गेर्क केय्‍सि उपसंतोर अल्‍हेने ओरतोनि कलियसि गाटोगुडा तिंतोर,” इंचि गुल्‍गसेक इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ओर इनानद केंजसि येसु ओर्क उंदि वेसुडि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“मी लोप्पोटाल वरोनगा नूर गोर्रें मंतां इनकुंटु. अवुनाल उंदि गोर्रे तप्‍पिस होनानय्ते, कळमता टोंबै तोम्मिद गोर्रेन अग्गेन मंदा वाटसि, तप्‍सोत्‍ता आ उंदि गोर्रे दोर्कनदाका दान पहकालय होन्‍नोरा? ");
INSERT INTO esg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","पजा अद गोर्रे दोर्कतस्के, ओर वेल्‍लेन कूस आसि दान हट्‍टापोर्रो वाटकुंचि पीसि वांतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","वासि, दंटातोर्कुन, लोता पक्‍कातोर्कुन केय्‍सि, ‘नावा तप्‍सोत्‍ता गोर्रे नाक दोर्कुता, नावातोनि कलियसि आनंदम कीम्‍ट,’ इंचि इंतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","नना मीक वेहानद बतल इत्‍ते, बोर्क अय्ते मनसु मार्सकुनना अव्‍सरम हिल्‍ले, असोंटा टोंबै तोम्मिद मंदि नीतिमंतुल्‍कुना बारेमते आयना आनंदमकन्‍ना, वरोर पापि मनकल मनसु मार्सकुत्‍ते ओनाहाटीं स्वर्गमते बच्‍चोरो आनंदम आंता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“मर्रा उंदि वेसुडि वेहांतन केंजाट. उंदि मुरतटगा पदि एंडि कोत्‍तां मत्‍तां. आ पदि कोत्‍तानाल उंदि कोत्‍ता बगानो अरसि होत्‍ता. अस्‍के अद मुरतळ सिमलि निरिच्‍चि, लोनअंता हेय्सि आ कोत्‍ता दोर्कनदाका पहकंता. ");
INSERT INTO esg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","पजा अद कोत्‍ता दोर्कतस्के, दाना दंटातवुन, लोता दग्गेटवुन केय्‍सि, ‘नावद बगानो अरसोत्‍ता कोत्‍ता दोर्कुता, मिमेट नातोनि कलियसि आनंदम कीम्‍ट,’ इंचि इंता. ");
INSERT INTO esg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","नना मीक वेहांतन, इदुनलेसींगे वरोर पापि मनकल ओना पापमताल मनसु मार्सकुत्‍ते ओनाहाटीं स्वर्गमते पेन दाना दूतानतोनि आनंदम कींता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","येसु इंकुंदि वेसुडि वेहातोर. “वरोर मनकंक इव्वुर मर्क मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उंदि रोजु सिन्‍ना मर्रि ओना बाबोन, बाबा, संपत्‍तिताल बच्‍चोन नावा पालु मंता, अद नाकु पंचि हीम, इत्‍तोर. इत्‍तस्के ओना बाबो संपत्‍तितुन इव्वुर मर्कुंक पंचि हीतोर.” ");
INSERT INTO esg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“कोन्‍नि रोजकुना पजा, सिन्‍ना मर्रि ओना पालुंक वाता संपत्‍तितुन बोत्‍तिगा पीकुंचि, बेकेनो लक्‍कु देसेम पेय्सि होत्‍तोर. अगा होंचि बोगम कबाह्‍कुने ओना संपत्‍तितुन नासडेम कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ओनगा मत्‍तव अंता मारतस्के आ देसेमते पेद्‍दा करवु अरता, ओनगा बतले हिलाकोंटा आता. ");
INSERT INTO esg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","अदुनहाटीं ओर आ देसेमता वरोर मनकनगा जीतम मत्‍तोर. आ मनकल ओना पोलाल्कुने पद्‍दिं मेहालय ओन लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","पजा ओर पद्‍दिं मेयाना मेतातुन तिंचि पीर निहकन बारे इंचि इनकुंदुर, गानि अद मेता इंका ओनकु बोरे हिय्या हिल्‍लुर.” ");
INSERT INTO esg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“अस्‍के ओनकु लोता मति वाता, नावा बाबानगा बच्‍चुरो जीतागाह्‍क मंतुर, ओर तित्‍ते मारवच्‍चोन गाटो अगा मंता, गानि नना बारे इगे कर्वुंक हासेके मंतन. ");
INSERT INTO esg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","नना ई देसेम होळसि, नावा बाबानगा मल्सि दांतन. होंचि, ‘बाबा, स्वर्गमता पेन आनि नीकु विरोदमते नना पापम कीतन. ");
INSERT INTO esg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","इंदके नना नीवा मर्रिन लायक हिल्‍लेन गानि निहगा नाकुन नीवा जीतागानलेसीं ईरकुन इंचि इंतन,’ इल्‍हा इंतन, इनकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","पजा ओर अगटाल ओना बाबोनहेके पेय्सतोर. पजा ओर ओना बाबाना लोतुक वेल्‍लेन लक्‍कु मत्‍तोर अस्‍के ओना बाबाल ओन हूळतोर. मर्रिन हूळसि बाबोंक वेल्‍ले पापम अनपिस्ता. अदुनहाटीं ओर एदुर वितसि होंचि ओन चातिक अदमुकुंचि बुरतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","अस्‍के मर्रि बाबोन, ‘बाबा, स्वर्गमता पेन आनि नीकु विरोदमते नना पापम कीतन. इंदके नना नीवा मर्रिन लायक हिल्‍लेन,’ इत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","गानि बाबाल ओन लोन तच्‍चि, जीतागाह्कुनतोनि, बिराना होंचि बेसता कपडिं तच्‍चि ईनकु केरहट, ईना वेलुंक उंदि मुद्‍दा दोस्सट, काल्कुंक हेरपुह्क केरहट. ");
INSERT INTO esg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","अल्‍हेने बेस बल्सता कुर्रातुन तच्‍चि कोय्यट, अदुन तिंचि मनम कूस आकोम. ");
INSERT INTO esg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","बारित्‍ते, नावा मर्रि नहागटाल वेल्‍लेन लक्‍कु होंचि हासोत्‍ताप मत्‍तोर, इंदके ओर मल्सि वातोर. तप्‍सोंचि मत्‍तोर गानि इंदके दोर्कतोर, इंचि इत्‍तोर. इल्‍हा ओर कूस आयालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“पजा बतल आता इत्‍ते, ओना पेद्‍दा मर्रि नेदहेके होंचि मत्‍तोर. ओर नेदाल लोन वायानेंके लोता दग्‍गेरा एवतोर अस्‍के ओन्क पाटां पारानद, एगरानद अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","केंजा वातस्के ओर वरोन जीतागान केय्‍सि, लोन बतल जर्गुसंता? इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","अस्‍के आ जीतागाड, ‘नीवा तम्मुर बेस मल्सि वातोर. अदुनहाटीं नीवा बाबाल, बेस बल्सता कुर्रातुन कोय्या वेहातोर,’ इंचि इत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“इद पोल्‍ले केंजसि पेद्‍दा मर्रिंक इरगा होंग वाता. ओर लोप्पो होळियोन इंचि पलातेन मत्‍तोर. अस्‍के ओना बाबाल पलाते वासि, ओन समजांचलय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","गानि पेद्‍दा मर्रि बाबोन, इच्‍चुं वर्सानाल नना नीवा सेवा कीसेके वातन, नीवद बद्‍दे आदेसतुन नना नेम्‍हा हिल्‍लेन. गानि नावा दंटातोरतोनि कलियसि कूस आयालय, नाकु निमे बस्‍केन उंदि एटि पोरिनगुडा हिया हिल्‍लिन. ");
INSERT INTO esg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","गानि नीवा ई मर्रि, नीवा संपत्‍तितुन बोगम कबाह्‍कुने पूरा नासडेम कीतोर, ओनाहाटीं निमे बेस बल्सता कुर्रातुन कोय्या वेहतिन, इंचि इत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“इत्‍तस्के ओना बाबाल, नावा पेडा, निमे बस्केळकु नावातोनि मनांतिन, नहगा बतल-बतल अय्ते मंता, अद अंता पूरा नीवादे आंदु. ");
INSERT INTO esg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","गानि ईर नीवा तम्मुर वेल्‍लेन लक्‍कु होंचि हासोत्‍ताप मत्‍तोर, इंदके पिस्सि मल्सि वातोर. तप्‍सोंचि मत्‍तोर गानि इंदके दोर्कतोर. अदुनहाटीं मनम कूस आयमळ गावाले इत्‍तोर.” इल्‍हा वेहचि येसु वेसुडि वेहमळ महतोर. ");
INSERT INTO esg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","पजा येसु सिस्‍युल्‍कुंकगुडा वेहालय दल्‍गुतोर: “वरोर सिरमंत मनकल मत्‍तोर. ओनगा वरोर दिवांजि मत्‍तोर. सिरमंत मनकानगा बोरो लोकुल्‍क वासि, ‘नीवा दिवांजि नीवा दनमतुन नासडेम कीसंतोर,’ इंचि वेहातुर. ");
INSERT INTO esg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","अस्‍के सिरमंत मनकल दिवांजिन केय्‍सि, ‘नीवा बारेमते इल्‍हा बारि केंजसेक मंतन? इंदके नीकुन दिवांजि कबळते ईरा पर्रोन, निमे इच्‍चुं रोजुक कीता कबाटद पूरा इसाब हीम,’ इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","इत्‍ता पजा आ दिवांजि, ‘इंदके नना बतल कीकन? नावा मालक अय्ते नाकुन कबळ पोर्रोटाल तेंडसंतोर. इंदके नहगा कास्‍तकरि कबळ कियानच्‍चो बलम हिल्‍ले आनि बिच्‍चम तल्कालय नाकु सिग्गु वांता,’ इंचि विचारम कियालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘नाकुन दिवांजिता कबाटाल तेंडिना गानि लोकुल्‍क ओरा लोह्कुने केयमळ गावाले इत्‍ते नना बतल कियगोमो अद नाकु तेळियता,’ इंचि इनकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","इनकुंचि सिरमंत मनकंक बोर अय्ते बाकि मत्‍तुर, ओर्कुन वरोन-वरोन केयतोर, केय्‍सि वरोन पूसकीतोर, ‘निमे मालकुंक बच्‍चोन बाकि मंतिन?’ ");
INSERT INTO esg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘नालुं वेय्‍कु लीटर्क जय्‍तुन निय बाकि मंतन,’ इंचि इत्‍तोर. इत्‍तस्के दिवांजि ओन, ‘इद पीम नीवा काता बुक आनि बिराना दीन रोंड वेय्‍कु लीटर्क रासा,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","मर्रा इंकावरोन, ‘निमे बच्‍चोन बाकि मंतिन?’ इत्‍तोर. ओर, ‘नूर गिद्‍दें गोह्कु हियना मंतन,’ इंचि इत्‍तोर. इत्‍तस्के ओन इंका, ‘इद पीम नीवा काता बुक! इवने एनबै गिद्‍दें रासा,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“पजा सेड्‍डा कबाह्‍क कियाना दिवांजि तेल्‍विते कीता कबाह्‍कुन आ सिरमंत मनकल हूळसि, ‘निमे उसार मंतिन’ इंचि ओन इत्‍तोर. इल्हेने पेनदा लोकुल्‍कुंकन्‍ना एक्‍को, पेनदुन एरपाट किय्युवा दुनियाता लोकुल्‍क वरोंक-वरोर हियमळ-एतमळते वेल्‍ले तेल्‍विते मनांतुर. ");
INSERT INTO esg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","नना वेहानद बतल इत्‍ते, इद दुनियाते मिमेट संपलिच्‍ता दनमतुन कर्च कीसि, दंटातोर्कुन दोर्किचकुंटु, बारित्‍ते अद दनम बस्के अय्ते मारंता अस्‍के, बस्‍केळ्‍क मनना लोह्कुने मीक जेगा दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“सिन्‍ना पोल्‍लेतेगुडा बोर अय्ते विस्वासमलायक मंतोर ओर पेद्‍दा पोल्‍लेतेगुडा विस्वासमलायक मंतोर. अल्‍हेने बोर अय्ते सिन्‍ना पोल्‍लेतेगुडा विस्वासमलायक हिल्‍लोर ओर पेद्‍दा पोल्‍लेतेगुडा विस्वासमलायक हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अदुनहाटीं ओक्‍कला मिमेट दुनियाते संपलिच्‍ता दनमतगा विस्वासमलायक हिलाकोंटे, पेन दाना राज्येमता निजम दनमतुन मीवा कय्‍दे बल्हा हिय्यार? ");
INSERT INTO esg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","मनद आयवा दनमता बारेमते मिमेट विस्वासमलायक हिलाकोंटे, बद दनमतुन अय्ते पेन मीक हींतन इंचंता, अद मीक बल्हा दोर्कार? ");
INSERT INTO esg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“वरोर जीतागाल इव्वुर मालकुल्कुनगा सेवा किया पर्रोर. अल्हा सेवा कीते वरोन बेस पावरम कींतोर, इंकावरोन हयसोर, हिलाकोंटे वरोना पोल्‍ले केंजंतोर, इंकावरोना पोल्‍ले बारे केंजोर. अल्‍हेने मिमेट पेनदुन आनि दनमतुन उंदे मल्का सेवा किया पर्रिर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","येसु इव पोल्‍लें वेहनेंके, अगा परिसिल्क मत्‍तुर. ओर कोत्‍ताना पोर्रो बागा जीवा कियुंदुर. अदुनहाटीं येसुना पोल्‍लें केंजसि ओन कारेड्‍डाल्‍क कीतुर. ");
INSERT INTO esg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","पजा येसु ओर्कुन, “मिमेट लोकुल्‍कुना मुन्‍ने, ‘मोमोट नीतिमंतुल्‍कुम’ इंतिर, गानि पेन मीवा मनसुन एरपाट कींता. बव पोल्‍लें अय्ते मनकना विचारमते कदरतव मंतां, अव पोल्‍लेन पेन बिल्कुल हय्‍सो.” ");
INSERT INTO esg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“बापतिस्मा हिय्यना योहान वायानादाका, लोकुल्‍क मूसाना नियमकु आनि पेनदा कबुरतोरा रासता पोल्‍लेन परकारम ताकुंदुर. दाना पजा, पेनदा राज्येमता बारेमते बेसता कबुर लोकुल्‍कुंक वेहमळ जर्गसेक मंता. वेल्‍लेटुर लोकुल्‍क पेनदा राज्येमते जबरदस्‍तिते होळियसेक मंतुर. ");
INSERT INTO esg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ओक्‍कला बूमि, मब्बु नासडेम आसि होना पर्रंता गानि दर्मसास्‍त्रमते रासतद उंदि सिन्‍ना पोल्‍लेगुडा नासडेम आयो.” ");
INSERT INTO esg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“बोरे आयिर, मुन्‍नेटा मुत्‍तोन होळसि, इंकुंदानतोनि मरमिं आयानय्ते, ओर बोगमतनम कींतोर. अल्‍हेने बोरे आयिर, मुय्दोन होळसीता मुर्ताटुन मरमिं आयानय्ते, ओरगुडा बोगमतनम कींतोर.” ");
INSERT INTO esg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","इंकुंदि पोल्‍ले केंजाट, वरोर सिरमंत मनकल मत्‍तोर. ओर, एक्‍को दराता नेडि पंडिना रंगुना मलमल कपडिं केर्सि रोज सुकमते, आनंदमते मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","गानि वरोर लाजर इनानोर गरिब मनकल मत्‍तोर. ओनकु मेंदुलंता पुनकु आसि मत्‍तां. ओन रोज सिरमंत मनकना गलमातगा बोरो तच्‍चि, होळसि होनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","सिरमंत मनकल तिननेंके हिळु अरतव मेत्‍कुल्क तिंचि पीर निहंतन इंचि अगा हूळसेक मनुंदुर. इंका ओना मेंदुल्ता पुनकुन नय्‍कु वासि नाकुंदुं. ");
INSERT INTO esg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","उंदि रोज बतल आता इत्‍ते, आ गरिब मनकल हासोत्‍तोर. अस्‍के पेनदा दूतां वासि ओना जीवातुन स्वर्गमते पीसि ओसि, अब्राहामुना पक्‍काते इरतां. कोन्‍नि रोजकुना पजा सिरमंत मनकल इंका हातोर. ओन बोंदा दोसतुर. ");
INSERT INTO esg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","सिरमंत मनकना जीवा नरकमते तकलिपने तनलाळसेक मननेंके वेल्‍ले लक्‍कुने ओनकु अब्राहाम दिसतोर. ओना पक्‍काते लाजर मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","अस्‍के ओर अब्राहामुन जोरसे केय्‍सि, “मावा एनकटा मातिर दादा, नावापोर्रो दया कीसि लाजरुन नावाहेके लोहचीम. नना तडमिते तनलाळसेक मंतन. ओर वासि ओना वेल्‍दुन एते मुळाहचि नावा नाल्केतुन सल्‍लागा कियिरकांटी,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","अस्‍के अब्राहाम ओन, “हूळा पेडा, निमे मति कीम, निमे पिस्सि मननेंके नीकु बतल गावाले मत्‍ता अव अन्‍नि दोर्कतां, गानि लाजरुंक मात्रम अव अन्‍नि सुकाल्क दोर्का हिल्‍लें. इंदके इगे ईनकु बतल तकलिप हिल्‍ले गानि निमे मात्रम तडमिते तनलाळसेक मंतिन. ");
INSERT INTO esg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","मर्रा उंदि पोल्‍ले बतल इत्‍ते, मीवा-मावा नड्‍डुम उंदि पेद्‍दा लोंद्का मंता. अदुनहाटीं मावाहेंदाल मीहेके बोरन्‍ना वाकोम इत्‍ते वाया परुर, मिहगटाल बोरन्‍ना मावाहेके वाकोम इनना गानि वाया परुर, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","अस्‍के आ सिरमंत मनकल, ‘अल्हा अय्ते मातिर दादा, नना नीकु विनंति कींतन, लाजरुन नावा बाना लोन लोहचीम. ");
INSERT INTO esg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","बारित्‍ते नाक हेय्युर तादह्क-तम्मुह्‍क मंतुर. ईर होंचि इव पोल्‍लें ओर्क वेहते, ओर इसोंटा तकलिपना जेगाताल तप्‍पानुर,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","इत्‍तस्के अब्राहाम, ‘ओरगा मूसाल रासता नियमकु, पेनदा कबुरतोर रासता पुस्तकाल्क मंतां. अवुन हद्‍विसि, अल्हे केंजिर, अल्हे ताकिर,’ इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","अस्‍के सिरमंत मनकल, ‘अल्हा आयो अब्राहाम दादा, हातोरा लोप्पोटाल बोरन्‍ना होंचि ओर्क वेहते, ओर पापाल्कुनाल मनसु मार्सकुंतुर,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अस्‍के अब्राहाम, मूसाल रासता नियमकु, पेनदा कबुरतोर रासता पोल्‍लेन बोर अय्ते केंजुर, ओर्कु वेहालय हाता मनकल जीवा अरसि होंचि वेहाना गानि ओर केंजुर,” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","उंदि रोज येसु ओना सिस्युल्कुन इल्‍हा इत्‍तोर. “पापमते अरहना पोल्‍लें वायाका मन्‍नों, अव अय्ते वांतंगे. गानि अव बोनाहेंदाल वांतांगो, ओन्क बच्‍चोन गोसा वायार! ");
INSERT INTO esg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","नापोर्रो विस्वासम कियना ई सिन्‍ना पेडानसंटोन बोरन्‍ना पापमते अरहते, ओना बोंळगेक जोत्‍ता बंडा दोहाचि ओन समुद्रमते ओसि वाटतेने ओनाहाटीं बेस मनंता. ");
INSERT INTO esg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","अदुनहाटीं मिमेट उसारते मंटु.” “मीवा दंटातोर पापम कीते ओन समजांचटु, ओर कीता पापमताल मनसु मार्सकुत्‍ते, ओन मापि कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","उंदि रोजुने ओर एडुं मल्कां तप्‍पु कीते, एडुं मल्कांगुडा ओर मिहगा वासि, नना तप्‍पु कीतन, इंदकेटाल इल्‍हा किय्योन, इंचि ओप्पुकुत्‍ते, ओन मापि कीम्‍टु,” इंचि येसु वेहातोर. ");
INSERT INTO esg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","इल्‍हा येसु वेहतद केंजसि, “मावा विस्वासमतुन बेर्सागोटा सामि,” इंचि ओना प्रेरितुल्क इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","अस्‍के सामि ओर्कुन इल्‍हा इत्‍तोर. “ओक्‍कला मीलोप्‍पो आवाल्‍कुना पेळेतच्‍चो विस्वासम मनिनागानि, मिमेट इद पेद्‍दा ताडि मरातुन, ‘निमे नीवा हिह्कुनतोनि पीकका वासि, समुद्रमते होंचि अर्रा,’ इंचि इत्‍ते अद मरा मीवा पोल्‍ले केंजंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","येसु मर्रा इल्‍हा वेहातोर, “मिहगा बोनागना वरोर जीतागाल मंतोर इनकुंटु, ओर नांगेल पूहाचि हिलाकोंटे गोर्रें मेहाचि, बस्के अय्ते ओना कबाटाल लोन वांतोर, अस्‍के, ओर वाता वायमळे, ‘गाटो तिनालय उदा,’ इंचि इंतिरा? बस्‍केने इन्‍निर. ");
INSERT INTO esg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","गानि, ‘नाहाटीं गाटो अट्‍टा, वेरे कपडिं केरसि नाकु गाटो वाटसि हीम, नना तित्‍ता पजा निमे तिन’ इंचि इंतिर. ");
INSERT INTO esg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","निमे वेहता कबळ जीतागाल कीतोर इंचि ओन्क, दन्यवाद इंचि बस्‍केने हिय्यिर. ");
INSERT INTO esg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","अल्‍हेने मिमेट इंका पेन वेहता कबळ पूरा मारतस्के, ‘मोमोट मामुल जीतागाह्कुम आंदुम, माक बद कबळ कियाना मत्‍ता अदे कबळतुन कीतोम’ इंचि इंटु,” इंचि येसु वेहातोर. ");
INSERT INTO esg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","पजा येसु येरुसलेम होनानेंके सामरिया आनि गालिल एरियाना नड्‍डुमताल होंचेके मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","अस्‍के बदो उंदि नाटेने होळियनेंके कुस्‍टरोगम आतोर पदि मंदि, हर्दुक इच्‍चुर लक्‍कु नित्‍तिसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ओर येसुन हूळसि, “ए येसु, ए सामि! मावा पोर्रो दया कीम,” इंचि वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","येसु ओर्कुन हूळसि, “मिमेट होंचि, मीवा मेंदुल पेर्मालोर्कुंक हुप्‍सट,” इंचि इत्‍तोर. इत्‍तस्के ओर होननेंके-होननेंकेन बेस आतुर. ");
INSERT INTO esg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","अस्‍के ओरागटाल वरोर मनकल नना बेस आतन, इंचि हूळसि पेनदुन जोर-जोरसे तल्‍सकुंचेके येसुनगा मल्सि वातोर. ");
INSERT INTO esg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","वासि ओना काल्कुनपोर्रो अरसि ओन्क दन्यवाद कीतोर. ओर सामरिया मनकल मत्‍तोर, इत्‍ते सिन्‍ना जातितोर मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","अस्‍के येसु, “पूरा पदि मंदि बेस आया हिल्‍लिरा? कळमता तोम्मिद मंदि बेके होत्‍तुर? ");
INSERT INTO esg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","पेनदुन स्‍तुति कियालय, ई सामरि जातितोन होळसि, कळमतोर बेस आतोर बोरे वाया हिल्‍लुरा?” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","मर्रा येसु, “तेदिस होन! निमे विस्वासम कीताहाटीं बेस आतिन,” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","“पेनदा राज्येम बस्के वांता?” इंचि उंदि मल्का परिसिल्कु येसुन पूसकीतुर. अस्‍के येसु, “पेनदा राज्येम कळ्‍कुंक दिस्सेक वायो. ");
INSERT INTO esg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","पेन मीवा नड्‍डुम राज्येम कींता. अदुनहाटीं पेनदा राज्येम इगे मंता, अगा मंता इंचि लोकुल्‍क इन्‍नुर,” इंचि वेहातोर. ");
INSERT INTO esg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","अद वेहता पजा सिस्युल्कुन इल्‍हा इत्‍तोर, “मनकना रूपमते पुटतोर वायाना रोजकुनाल उंदि रोजुन हूळना विचारम कींतिर, गानि मिमेट हूळा पर्रिर इसोंटा वेला वायार. ");
INSERT INTO esg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","अस्‍के, हुळाट! मनकना रूपमते पुटतोर इगे मंतोर, अगा मंतोर इंचि लोकुल्‍क इनानुर, गानि मिमेट अगा होनमट, ओरा पज्जो ताकमट. ");
INSERT INTO esg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","बारित्‍ते मब्बुने उंदि बाजुंक मेरस्‍ते इंकुंदि बाजुंक बल्हा वेलगु अर्रंतनो, मनकना रूपमते पुटतोन नना वायानस्‍केगुडा अल्हे आयार. ");
INSERT INTO esg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","गानि दानकन्‍ना मुन्‍ने नाकु बागा तकलिप वायार. इद पीळितोर नाकुन हय्सुर.” ");
INSERT INTO esg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","नोहाना रोजकुने बल्हा जर्गता, अल्‍हेने मनकना रूपमते पुटतोन नना वायानस्के जर्गार. ");
INSERT INTO esg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नोहाल डोंगाते नेंगनदाका लोकुल्‍क तिंचेके-उंचेके मत्‍तुर, मरमिं कीसेके, आसेके मत्‍तुर. अस्‍के पेद्‍दा कम्मुड वासि अंटोर्कुन मुळाहता. ");
INSERT INTO esg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","लोतुना कालमतेगुडा अल्‍हेने आता. लोकुल्‍क तिनुड, उनुळ, अस्सुड, अम्मुड, वीतुड लोहकु दोहुड कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","गानि लोतु सदोम सहरताल बस्के अय्ते पेय्सतोर, अस्‍के मब्बुनाल तडमि डोग्गां अरसि अद नाटेनोर अंटोर्कुन नासडेम कीता. ");
INSERT INTO esg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","अय्ते मनकना रूपमते पुटतोन नना वायाना रोजुनेगुडा अल्हे आयार. ");
INSERT INTO esg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","अदुनहाटीं अद रोज बोर अय्ते लोतपोर्रो मंतोर, लोता लोप्पो मंदना सामानतुन पीसि वायालय हिळु रेयानायो. अल्‍हेने बोर अय्ते नेलिने कबळ कीसेक मंतोर, ओर मल्सि वायानायो. ");
INSERT INTO esg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लोतुना मुत्‍तो पेनदा पोल्‍ले केंजवा, सदोम सहरतुन तिरियसि हूळतस्‍के, दानकु बल्हा आता, अदुन मति कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“बोर अय्ते ओना जीवातुन ई दुनियाते पिसागोटालय हूळांतोर, ओर ओना जीवातुन पोगोटकुंतोर. बोर ओना जीवातुन नावाहाटीं पोगोटकुंतोर, ओन्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","नना मीक वेहानद बतल इत्‍ते, अद नर्का उंदि कटुलते इव्वुर मनानुर. ओराव्टेटाल वरोन तेहाकुंचि ओयमळ जर्गंता, इंकावरोन अग्गेन होळ्‍समळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","अल्‍हेने रोंडु मुर्ताह्क कूळसि गट्‍का नोरसेक मनंतां, उंदितुन ओयमळ जर्गंता, इंकुंदितुन अग्गेन होळ्‍समळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","इव्वुर मनकालोर पोलमते मत्‍ते, पेन वरोन पीसि ओयार, वरोन बारे अग्गेन होळसिय्यार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","अस्‍के सिस्युल्कु येसुन, “इव पोल्‍लें बगा आयानुं सामि?” इंचि पूसकीतुर. अस्‍के, “बगा अय्ते पीनगु मनंता, अग्गेन गद्‍दलिं जमा आंतां,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","पजा येसु ओना सिस्युल्कुन, “रोज पारतना कीसेके मंदानां, पारतना कियानाहाटीं बस्‍केने पजोळ्क आयामन्‍नि,” इल्‍हा इंचि उंदि वेसुडि वेहातोर. ");
INSERT INTO esg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“उंदि नाटेने वरोर न्‍यायम कियाना पेद्‍दा मनकल मत्‍तोर. ओर पेनदुक वेरियाकोंदुर, लोकुल्‍कुना पर्वा कियाकोंदुर. ");
INSERT INTO esg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","अदे नाटेने उंदि मुंडामोस्ता मुरतळ मत्‍ता. अद ओनगा रोज वासि, ‘नावापोर्रो अन्‍यायम आता, नाकु न्‍यायम कियमळ गावाले,’ इंचि ओन इनुंदु. ");
INSERT INTO esg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ओर वेल्‍लेने रोजकुनदाका दाना पोल्‍लेन केंजाकोंटा मत्‍तोर. गानि उंदि रोज ओर इल्‍हा विचारम कीतोर. ‘नना पेनदुक वेरियानोन आयोन, मनकालोर्कुना पर्वा कियानोन आयोन. ");
INSERT INTO esg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","अय्नागानि इद मुरतळ रोज वासि नाकुन परेसान कीसेक मंता. अदुनहाटीं इंदके नना दीना न्‍यायम कींतन. हिलाकोंटे इद बस्‍केळ्‍के नाकुन परेसान किय्‍यार,’ इनकुत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","मर्रा सामि इत्‍तोर, “सेड्‍डा मजिस्‍टर बतल इत्‍तोर, अद पोल्‍लेतुन मति कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","पेन पेरकुत्‍ता लोकुल्‍क न्‍यायम आयागोम इंचि नर्का-पल्‍हिं पेनदुन पारतना कीसेक मनांतुर, पेन ओर्क सहाय्यम कियालय आलसेम किय्‍यारा? ");
INSERT INTO esg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","नना मीक वेहासेक मंतन, पेन ओरा न्‍यायम बिराना किय्‍यार. अय्नागानि मनकना रूपमते पुटतोन नना मल्सि वातस्के, इद बूमिते विस्वासम होळसाकोंटा पारतना कीसेक मनानोर दोर्कानुरा?” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","बोर अय्ते लोकुल्‍क मोमोटे नीतिमंतुल्‍कुम इन्कुंचि सतता पोर्रेन बरोसा इर्सि, इंकावरोन सिन्‍ना हूळुंदुर, ओराहाटीं इंका येसु उंदि वेसुडि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","इव्वुर मनकालोर गुळिते पारतना कियालय होत्‍तुर. ओरंटे वरोर बारे परिसि मनकल, इंकावरोर बारे कर वसुल कियानोर. ");
INSERT INTO esg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","परिसि वेरे नित्‍तिसि पारतना कियालय दल्‍गतोर, ए पेनबाबा! नना इंका वरोनलेसीं दोंगन आयोन, इंकावरोन बोंकिचानोन आयोन, बोगम कबाह्‍क कियानोन आयोन, ई कर वसुल कियानोनलेसीं लोकुल्‍कुन मुळहानोन आयोन. ");
INSERT INTO esg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","वारमकु रोंडु मल्कां ओक्‍कापोद्‍दु मनंतन, नावा कमयता पदि तूसकुनाल उंदि तूसगुडा नीकु हींतन, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“गानि कर वसुल कियानोर लक्‍कु निततोर, ओनकु पोर्रो हूळालयगुडा दैरनेम आयाहिल्‍ले. ओर चातितुन तंचेके पारतना कीतोर, ‘ए पेनबाबा, नना पापि मनकन आंदुन, नावापोर्रो दया कीम,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","नना मीक वेहांतन गदा, ओरा इव्वुरा लोप्पोटाल कर वसुल कियानोरे पेनदा मुन्‍ने नीतिमंतुड आसि लोन होत्‍तोर. गानि परिसि नीतिमंतुड आयोर. बारित्‍ते, बोर ओनद ओरे नना पेद्‍दोन इंचि इनकुंतोर, पेन ओन सिन्‍नगा कींता. अल्‍हेने बोर ओनद ओरे नना सिन्‍नोन इंचि इनकुंतोर, पेन ओन पेद्‍दा कींता,” इल्‍हा वेहचि येसु सामि वेसुडितुन महतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","उंदि रोजु लोकुल्‍क ओरा सिन्‍ना पिलाल्कुंक येसु आसिर्वाद हियाना इंचि पीसि वायालय दल्‍गतुर. गानि सिस्युल्क हूळसि ओर्कुन रांगतुर. ");
INSERT INTO esg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","गानि येसु पिलाल्कुन केय्‍सि इत्‍तोर, “पिलाल्कुन नाहेके वायाहीम्ट, ओर्कुन आपमट. पेनदा राज्येम इसंटोरदे आंद. ");
INSERT INTO esg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","नना मीक निजम वेहांतन, बोरे आयिर ओरा मनसुने पेनदा राज्येमतुन सिन्‍ना पिलाल्कुनालेसीं ओप्‍कुन्‍नुर, ओर पेनदा राज्येमते होळिया पर्रुर,” इंचि सिस्युल्कुंक वेहातोर. ");
INSERT INTO esg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","पजा यहुदिल्कुना वरोर लीडर इल्‍हा इत्‍तोर, “गुरु, निमे बेसतोन आंदिन. बस्‍केळ्‍क पिस्सना पिस्वरता वारसदार आयानाहाटीं नना बतल कीते बेस?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","अस्‍के येसु ओन इल्‍हा इत्‍तोर. “नाकुन बारि बेसतोर इंतिन? बोरे बेसतोर आयोर, सिराप पेन उंदे बेसतद आंद. ");
INSERT INTO esg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","नीकु पेनदा आदेसकु अय्ते एरपाटे मंतां: बोगमतनम कियमा, बोने हव्‍कुमा, दोंगातनम कियमा, आबद्‍दम गवाइ हियमा, तल्‍लुर-बाबोना कदर कीम,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","अस्‍के ओर, “नना अय्ते इव अन्‍नि सिन्‍नास्केटाल कीसेकेन वातन,” इंचि ओर इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ओर इत्‍तद केंजसि येसु ओन इल्‍हा इत्‍तोर. “इंदकेगुडा निहगा उंदि पोल्‍ले तक्‍को मंता. निहगा बतल अय्ते मंता, अदुनंता पूरा अम्मिसि, गरिबोर्कुंक तूसि हीम. अस्‍के नीकु स्वर्गमते दनम दोर्कार, पजा नहगा वासि ना पज्जो ताका,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","गानि येसुना पोल्‍ले केंजसि, ओन्क इरगा दुक्‍कम वाता. बारित्‍ते ओर वेल्‍लेन सिरमंत मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","येसु ओर्कुन हूळसि इल्‍हा इत्‍तोर. “सिरमंतुल्‍क पेनदा राज्येमते होळियमळ इत्‍ते वेल्‍लेन कस्‍टम. ");
INSERT INTO esg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","वरोर सिरमंत मनकल पेनदा राज्येमते होळियमळकन्‍ना लोटापेटा सूदि बोंगाताल होनमळ अल्कगा मनंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","अस्‍के बोर अय्ते येसुना पोल्‍लें केंजतुर, ओर, “अल्हा अय्ते मरि मुक्‍ति बोर्क दोर्का पर्रंता?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","अस्‍के, “मनकालोरतोनि आया पर्रुवा पोल्‍लें, पेन किया पर्रंता,” इंचि येसु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","अस्‍के पत्रु, “हूळा, मोमोट अय्ते लोन-दारा होळसिसि नीवा पज्जो वातोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","अस्‍के येसु इल्‍हा इत्‍तोर, “नना मीक निजम वेहांतन. पेनदा राज्येमताहाटीं ओना लोन-दारातुन, मुत्‍तोन, तम्मुह्‍क-दादालोर्कुन, पिलाल्कुन, तल्‍लुर-बाबोन होळसीतोरो, ");
INSERT INTO esg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","आ मनकंक इद कालमते होळसीतवुंकन्‍ना बच्‍चोरो एक्‍को संपत्‍ति, जीवातोर दोर्कानुर, अल्‍हेने वायाना कालमते बस्‍केळ्‍क पिस्सना पिस्वरगुडा दोर्कार,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","पजा येसु ओना पन्‍नेंड सिस्युल्कुन बाजुंक ओसि इल्‍हा इत्‍तोर, “हुळाट, मनम येरुसलेम होंचेके मंतोम. मनकना रूपमते पुटतोन, ना बारेमते पेनदा कबुरतोर बतलय्ते रासतुर, अव पूरा आंतां. ");
INSERT INTO esg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","अगा नाकुन यहुदि आयवोरा कय्‍दे अप्‍पजेपनुर, अस्‍के ओर नाकुन सिडांचनुर, अपमानम कियानुर, नापोर्रो उस्कानुर, ");
INSERT INTO esg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","पोट्‍टेते तन्‍नुड आतस्के हव्कानुर. गानि मूडोव रोजुने नना मर्रा जीवाते तेदंतन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","गानि ओना सिस्युल्कुंक मात्रम ओर वळ्कता पोल्‍ले तेळिया हिल्‍ले. अद पोल्‍ले ओराहाटीं मर्ममते मत्‍ताहेंके, ओर्क बतल अर्तम आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","पजा येसु यरिहो सहरता दग्‍गेरा एव्‍तोर. अगा हर्दा पक्‍काते वरोर गुड्‍डि बिच्‍चागाड बिच्‍चम तल्कसेके उद्‍दिसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ओना पक्‍काताल लोकुल्‍कुना मंदा होनना सप्पुड केंजसि, “इगे बतल आसेके मंता,” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","अस्‍के बोरो ओन, “नासरेत नाटेना येसु इग्‍गेटाल होंचंतोर,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","वेहतस्के, “येसु, दाविद राजाना वंसमतोना! नापोर्रो दया कीम,” इंचि आ गुड्‍डि वरगेयतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","अस्‍के ओना मुन्‍नेटाल होनानोर अंटोर ओन, “चुपचाप मन,” इंचि रांगतुर. गानि, “दाविद राजाना वंसमतोना, नापोर्रो दया कीम,” इंचि जोरसे मोत्‍कुनालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","अस्‍के येसु आगसि, “ओन नहगा पीसि वटु,” इंचि हुकुम कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","पजा ओन येसुनगा तत्‍तस्के, “नना नीहाटीं बतल कियना इंचि नी मनसु मंता?” इंचि येसु ओन पूसकीतोर. अस्‍के, “सामि, नावा कळ्‍कुना नदर दिस्‍सानाल कीम,” इंचि आ गुड्‍डि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","पजा येसु ओन, “इंदकेटाल हूळालय दल्‍गा, नीवा विस्वासमे नीकुन बेस कीता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","अल्हा इत्‍ता इनुडे ओना कळ्‍कुंक नदर वासि पेनदुन तल्‍सकुंचेके ओना पज्जो होत्‍तोर. अगा मत्‍ता लोकुल्‍क अल्हा आतद हूळसि, ओरगुडा पेनदुन तल्‍स्‍कुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","अल्हा आता पजा, येसु यरिहो नाटेनाल होंचेके मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","अद नाटेने वरोर जकय्या पोरोलतोर कर वसुल कियानोरा पोर्रो अदिकारि मत्‍तोर. ओर बागा सिरमंत मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","येसु बोर आंदुर हूळंतन इंचि ओर इनकुत्‍तोर, गानि अगा वेल्‍ले गर्दि मत्‍ताहाटीं हूळा पर्रा हिल्‍लोर. बारित्‍ते ओर पोट्‍टिगा मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","अदुनहाटीं ओर येसु होनना हर्दुक मुन्‍ने वितसि, ओन हूळालय उंदि नेडि मरा पोर्रो एकतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","येसु अद मरातगा एवतस्‍के पोर्रो हूळसि, “जकय्या, बिराना हिळु रेय्‍या! इय्याला नाकु नीवा लोने आगाना मंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","इत्‍तारिते जकय्याल बिराना मराताल रेय्‍सि, कुसिते येसुन ओना लोन ओतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","येसु जकय्याना लोन होत्‍तद हूळसि लोकुल्‍क, “ईर पापि मनकना लोन हेडमिं इंचि होत्‍तोर,” इल्‍हा गुल्‍गालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","पजा जकय्याल नित्‍तिसि सामिन, “सामि, नावा सम्‍सारमताल सगम गरिबोर्कुंक हींतन, नना बोनना मुळाहचि येततद मत्‍ते, येततादानकन्‍ना नालुं अंताल्‍क एक्‍को मलाहचि हींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","अस्‍के येसु, “तप्‍सि होत्‍ता पापि लोकुल्‍कुन पहकिसि, ओर्कुन पिसागोटालय मनकना रूपमते पुटतोन नना वातन. अदुनहाटीं ईरगुडा अब्राहामुना वंसमते पुटतोरे आंदुर इंचि, इय्याला ईना लोतोर पापमताल पिस्तुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","लोकुल्‍क ओर वेहाना पोल्‍लें केंजसेके मत्‍तुर. अगटाल येरुसलेम सहर दग्गेरेने मत्‍ता. इंदके येसु येरुसलेमते एवतस्‍के ओर पेनदा राज्येम निलाहनुर इनकुंचेके मत्‍तुर. अदुनहाटीं येसु ओर्क उंदि वेसुडि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“वरोर पेद्‍दा वंसमतोर मनकल मत्‍तोर, ओर राजाल आसि वायालय लक्‍कुटा देसेम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","होनाका मुन्‍ने ओना पदि दासुल्‍कुन केय्‍सि, मनकंक पदि बंगारम बंडि हीसि, ‘नना मल्सि वायानादाका इव कोत्‍ताने मिमेट दंदा कीम्‍टु,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“गानि नाटेना लोकुल्‍क ओन हय्साकोंदुर, अदुनहाटीं, ‘ओर मापोर्रो राज्येम कियमळ माकु इस्‍टम हिल्‍ले,’ इंचि पेद्‍दा राजांक वेहालय पेरतोर्कुन ओना पज्जेन लोहतुर. ");
INSERT INTO esg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","पजा आ मनकल राजाल आसि मल्सि वातोर. ओर बोर्क अय्ते कोत्‍तां हीसि मत्‍तोरो ओर दंदा कीसि बच्‍चोन कमय कीतुरो हूळानाहाटीं आ दासुल्‍कुन केया वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","मोदाटा दासुड वासि, ‘मालक, निमे हीता पदि बंडिनतोनि नना इंका पदि बंगारम बंडिं कमय कीतन,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","अस्‍के राजाल, ‘निमे बेस कबळ कीतिन, निमे बेसता दासुन आंदिन, निमे सिन्‍ना कबळतगागुडा विस्वासमलायक मत्‍तिन, अदुनहाटीं पदि नाह्कुन ताकसालय नीकु अदिकारम हींतन,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","अल्‍हेने रोंडो दासुडगुडा वासि, ‘सामि! निमे हीता बंडिनतोनि नना इंका हेय्युं बंडिं कमय कीतन,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","अस्‍के राजाल ओनगुडा, ‘निमे हेय्युं नाह्कुन पोर्रो अदिकारिन आकिन,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","पजा इंकावरोर दासुड वासि, ‘सामि! इद हूळा निमे हीता बंगारमता बंडिं. इदुन नना पेगुने दोहाचि मक्‍किचि इरतन. ");
INSERT INTO esg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","बारित्‍ते निमे कळक मनकन आंदिन, अदुनहाटीं नना वेरियतन. निमे बद अय्ते इर्रा हिल्‍लिन अदुन तेंडकुंतिन, निमे वीतवगा कोय्‍यंतिन,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","अस्‍के राजाल ओन इल्‍हा इत्‍तोर, ‘अरे निमे लंडु दासुन आंदिन! नीवा तोळ्‍दाल पेय्सता पोल्‍लेतेन नीवा न्‍यायम कींतन. नना कळक मनकन, नना बद अय्ते इर्रा हिल्‍लेन अदुन तेंडकुंतन, नना वीतवगा कोय्‍यंतन इंचि नीकु एरपाटे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","अय्ते नना हीता कोत्‍तातुन बेंकते बारि वाटा हिल्‍लिन? नना मल्सि वातस्के नावा कोत्‍तां वड्‍डितोनि एत्‍कुंचि मन्‍नेन,’ इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","पजा दग्‍गेरा नित्‍तिसि मत्‍तोर्कुन इल्‍हा इत्‍तोर. ‘मिमेट ओनागटाल आ बंगारम बंडितुन एतट. एतसि पदि बंगारम बंडिं मत्‍तोनगा हीम्टु,’ इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","अस्‍के ओर, ‘अय्ते सामि, ओनगा पदि बंगारम कोत्‍तां मंता गदा,’ इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","नना मीक वेहंतन, बोनगा अय्ते पेनदा पोल्‍लेन तेल्‍पिचकुनना बुद्‍दि मंता, पेन ओन्क इंका हींता, गानि बोनगा पेनदा पोल्‍लेन तेल्‍पिचकुनना बुद्‍दि हिल्‍ले, ओनगा मत्‍ता बुद्‍दितुनगुडा पेन एतकुन्‍नार. ");
INSERT INTO esg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","गानि, ‘ईर राज्येम कियामन्‍नि,’ बोर पगातोर अय्ते इत्‍तुरो, ओर्कुन नावा मुन्‍ने तच्‍चि हव्कट, इंचि मालक इत्‍तोर,” इल्‍हा वेहचि येसु वेसुडितुन महतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","इव पोल्‍लें वेहता पजा येसु लोकुल्‍कुना मुन्‍ने-मुन्‍ने येरुसलेमताहेके ताकसेके पेय्सतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","होननेंके जय्‍तुन मराकुना गुट्‍टापोर्रो मनना बैतपागे आनि बेतानिया इनना नाह्‍कुना दग्‍गेरा एव्‍तोर. पजा येसु ओना इव्वुर सिस्युल्कुन केय्‍सि, ");
INSERT INTO esg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ओर्क इल्‍हा वेह्‍चि नाटे लोहतोर. “मी मुन्‍ने दिस्‍सना नाटे होंट. मिमेट अद नाटे होळियतस्‍के बस्‍केने बोरे उद्‍दुवद उंदि गाडदि पोरि दोह्‍चि मत्‍तद मीकु दिसंता, दान लेहकुंचि इग्‍गे पीसि वटु. ");
INSERT INTO esg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ओक्‍कला अदुन पीसि वायनेंके, ‘दीन बारि लेहचंतिर?’ इंचि बोरन्‍ना पूसकीते, ‘सामिंक दीना अव्‍सरम मंता’ इंचि वेहट,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","बोर्कुन अय्ते लोहमळ जर्गता, ओर नाटे होतस्के येसु वेहतापे ओर्क दिसता. ");
INSERT INTO esg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","पजा ओर गाडदि पोरिन लेहनेंके, दाना मालकुल्क हूळसि, “मिमेट गाडदि पोरिन बारि लेहसंतिर?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","अस्‍के ओर, “सामिंक दीना अव्‍सरम मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","पजा गाडदि पोरिन येसुनगा तत्‍तुर. तच्‍चि ओरा कपडिं दानपोर्रो तारसि, येसुन दानपोर्रो उपिस्तुर. ");
INSERT INTO esg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","उद्‍दिसि होननेंके ओन्क कदर हियानाहाटीं लोकुल्‍क ओर केर्ता कपडिं तेंडसि हर्दे तारतुर. ");
INSERT INTO esg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","अल्‍हेने पजा ओर जय्‍तुन मराकुना गुट्‍टा पोर्रोटाल हिळु रेयनेंके ओना पज्जो वायाना ओना अंटोर सिस्युल्क ओर हूळता अद्‍बूतामाता कबाह्कुनहाटीं वेल्‍ले कुसिते जोर-जोरते पेनदुन इल्‍हा तल्‍सकुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“पेनदा अदिकारम पीसि वायाना राजाल वेल्‍लेन आसिर्वाद दोर्कतोर आंद. पेनदाहेंदाल सांति वायि! पोर्रोटा पेद्‍दा पेनदा कदर आयि!” इंचेके तल्‍सकुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","अस्‍के मंदिताल इच्‍चुर परिसिल्क येसुनगा वासि, “गुरु! नीवा सिस्युल्कुन वरगेयमट इंचि गदरिच्‍चा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","पजा येसु ओर्कुन, “नना मीक वेहंतन, ओक्‍कला ईरगिंटा चुपचाप मत्‍ते, इव बंडां वरगेयालय दल्‍गंतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","पजा येरुसलेम सहरता दग्‍गेरा एव्‍तस्‍के, अद सहरतुन हूळसि येसु अळतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","अळसेके, “सांति दोर्कना पोल्‍लें इय्याला मीकु तेळियसि मत्‍ते बेस आसि मनवळ, गानि इंदके अव पोल्‍लें मीवा कळ्‍कुंक दिस्सों. ");
INSERT INTO esg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","मीवा पगातोर सुट्‍टु आसि मीकुन नालुं मूलानाल तकलिप कियानुर, असोंटा वेला वायार. ");
INSERT INTO esg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","मीवा पेन मीकुन पिसागोटालय मिहगा वाता वेलातुन एरपाट किया हिल्‍लिर. अदुनहाटीं मीवा पगातोर मीकुन, मीवा पिलाल्कुन तोळिते कल्‍पानुर. पजा बंडां उंदानपोर्रो उंदि इर्सि दोहता गूरेतुन कूलाह्‍चि समानम कियानुर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","पजा येसु गुळिते होळियतोर, होळियसि अगा अम्मानोर्कुन गेदमालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","पजा येसु ओर्कुन इल्‍हा इत्‍तोर. “नावा लोतुन पारतना कियाना लोन इंतुर, इंचि दर्मसास्‍त्रमते रासि मंता. गानि मिमेट दीन दोंगाल्क मक्‍कना जेगा कीतिर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","इल्‍हा येसु रोज गुळिते पेनदा पोल्‍लें करहुंदुर. गानि पेद्‍दा पेर्मालोर्क, दर्मसास्‍त्रम कराहना गुरुल्क, पेद्‍दा मनकालोर्क ओन हव्कालय हूळुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","गानि अंटोर लोकुल्‍क वेल्‍ले कुसिते येसु वेहाना पोल्‍लें केंजुंदुर. अदुनहाटीं ओन बल्हा हव्कना ओर्क आटम आयाकोंदु. ");
INSERT INTO esg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","उंदि रोजु येसु लोकुल्‍कुंक गुळिते कराहसेके, बेसता कबुर वेहासेके मत्‍तोर. अस्‍के पेद्‍दा पेर्मालोर, दर्मसास्‍त्रम कराहना गुरुल्क, आनि यहुदि पेद्‍दाल्क येसुनगा वातुर. ");
INSERT INTO esg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","वासि, “निमे इव कबाह्‍क बद अदिकारमते कीसंतिन? इव कबाह्‍क कियालय नीकु अदिकारम बोर हीतोर? माक वेहा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर, “ननागुडा मीकुन उंदि सवाल पूसकींतन, अय्ते वेहाट, ");
INSERT INTO esg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","योहानुंक बापतिस्मा हियाना अदिकारम बगाटाल दोर्कता? स्वर्गमताला हिलाकोंटे मनकालोराहेंदाल दोर्कतना?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","अस्‍के, ओर-ओरे इल्‍हा वळ्‍ककुत्‍तुर. “ओक्‍कला स्वर्गमताल दोर्कता इंचि मनम इनानय्ते, ‘मिमेट योहानुन बारि नम्मिर?’ इंचि इनानुर. ");
INSERT INTO esg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ओक्‍कला मनम मनकालोराहेंदाल इनानय्ते, अंटोर लोकुल्‍क मनापोर्रो बंडां हुक्‍कानुर, बारित्‍ते योहानुन पेनदा कबुरतोर इंचि ओर नमतुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","अदुनहाटीं ओर, “ओन्क अदिकारम बगाटाल दोर्कतनो माक एर्का हिल्‍ले,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“अल्हा अय्ते, इव कबाह्‍क बद अदिकारमते कीसंतनो, ननागुडा मीकु वेहोन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","पजा येसु लोकुल्‍कुंक ई वेसुडि वेहालय दल्‍गतोर. “वरोर मनकल उंदि अंगुर तोटा कीतोर. पजा वेरेतोर्क बटाइक हीसि वेल्‍लेन रोजकुनाहाटीं वेरे देसेम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","पजा बस्के अय्ते अंगुर पंडिं कोय्याना वेला वाता, अस्‍के ओरागटाल पंडिना तूस एतालय ओना वरोर दासुन बटाइतोरहेके लोहतोर. गानि बटाइतोर आ दासुन पीसि पक्‍का तंचि उत्‍ता कय्‍के वापस लोहतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","अस्‍के मालक इंकावरोन दासुन बटाइतोरहेके लोहतोर. आ बटाइतोर ओनगुडा पीसि तंचि कदर हिलाकोंटा कीसि उत्‍ता कय्‍के वापस लोहतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","पजा मालक मूडोव दासुन लोहतोर. ओनगुडा बटाइतोर नोप्‍पिं आयनाल तंचि तोटाता पलाते दोब्बिसीतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","पजा तोटाता मालक, ‘नना बतल कीकन?’ इंचि विचारम कीतोर. ‘सरे, इंदके नावा पावरमगल्‍ला मर्रिन लोहंतन, अस्‍के ओन हूळिसन्‍ना कदर हिय्युरा?’ इनकुंचि ओना मर्रिन ओरहेके लोहतोर. ");
INSERT INTO esg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","गानि बटाइतोर ओर वायानद हूळसि, ‘ईर अय्ते वारसदार आंदुर, दट ओन मनम हव्ककोम, अस्‍के ओना जाय्‍दाद मनाक आया पर्रंता,’ इंचि वरोंक-वरोर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","पजा ओर अगा वातस्के, ओन तोटाता पलाते ओसि हव्कतुर. “इंदके अंगुर तोटाता मालक वासि ओर्कुन बतल कियानुर? ");
INSERT INTO esg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ओर वासि आ बटाइतोर्कुन हव्‍किसि अद तोटातुन वेरेतोर्क बटाइक हिय्यानुर,” इत्‍तोर. अद पोल्‍ले केंजसि, “अल्हा जर्गाकोंटा पेन आपिकांटी,” इंचि अगा मत्‍तोर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","अस्‍के ओरहेके हूळसि येसु ओर्कुन इल्‍हा इत्‍तोर. “बद बंडातुन अय्ते मिस्‍त्रिल्‍क कबळ्‍क ओज्‍जो इंचि हय्‍सा हिल्‍लुर, अदे बंडा सेंकु मूलाता पुनादि बंडा आता. इल्‍हा पेनदा पोल्‍लें रासि मंतां, इवुना अर्तम बतल आंदु? ");
INSERT INTO esg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","बोर अय्ते इद बंडापोर्रो अर्रंतुर, ओर तुकडां-तुकडां आयनुर, गानि अद बंडा बोरपोर्रो अय्ते अर्रंता, ओर पिच्‍चि-पिच्‍चि आयानुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","येसु वेहता पोल्‍लें केंजसि, दर्मसास्‍त्रम कराहना गुरुल्क आनि पेद्‍दा पेर्मालोर्क, “ईर मनाकुने इंचंतोर,” इंचि एरपाट कीतुर. अदे वेलाते ओन दोर्का पियालय हूळतुर गानि लोकुल्‍कुन हूळसि वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","अस्‍के ओर, येसु बतलन्‍ना तप्पु वळ्कते ओन पीसि रोम सरकारता राज्यपालनगा ओकोम इंचि, ओनपोर्रो नदर इरतुर. इच्‍चुर्कुन नीतिमंतुल्‍कुनालेसीं मंचि ओना आयडां गुंजालय येसुनगा लोहतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","आ आयडां गुंजानोर येसुनगा वासि इल्‍हा इत्‍तुर. “गुरु, निमे सत्‍तेम वळ्‍कानोन, निजम करहानोन आंदिन, बोने सिन्‍ना-पेद्‍दा हूळिन. पेनदा हर्दा बारेमते सत्‍तेमते कराहंतिन इंचि माक एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","अय्ते नियम परकारम, कैसर राजांक मोमोट कर दोहमळ न्‍यायमेना, आयोना?” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","येसु ओरा पिलान एरपाट कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","कीसि, “नाक उंदि एंडि बंडि हुप्‍सट, दानपोर्रो बोना पोटुवा आनि पोरोल मंता,” इंचि इत्‍तोर. अस्‍के “कैसर राजानद,” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","अस्‍के, “कैसरुंक दोहना कर कैसरुंक दोहाटु, पेनदुक हियानव पेनदुक हीम्टु,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","इल्‍हा लोकुल्‍कुना मुन्‍ने येसुन ओना पोल्‍लेने ओर पिय्या पर्राहिल्‍लुर. गानि ओना पोल्‍लें केंजसि इचंत्रम आसि चुपचाप आतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","पजा इच्‍चुर सदुकि इनना लोकुल्‍क येसुनगा वातुर. मनकल हासि मर्रा जीवाते तेदोर इंचि ईर नम्मंतुर. ");
INSERT INTO esg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","वासि इल्‍हा सवाल पूसकीतुर. “गुरु, मूसाना नियम परकारम, वरोर मनकल पिलाल्क आयाका मुन्‍नेने हायानय्ते, ओना मुत्‍तोनतोनि ओना तम्मुर मरमिं आसि, हातोना वंसम बेर्सागोटालय पिलाल्कुन कना परांतोर, इंचि मंता. ");
INSERT INTO esg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","अय्ते, एडुर दादाल-तम्मुह्‍क मत्‍तुर. ओरा लोप्पोटाल पेद्‍दोड मरमिं आतोर, गानि पिलाल्क आयाका मुन्‍नेन ओर हातोर. ");
INSERT INTO esg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","हातस्के ओना पज्‍जोटोर दान मरमिं आतोर, ओरगुडा पिलाल्क आयाका मुन्‍नेन हातोर. ");
INSERT INTO esg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ओना पज्जोटोरगुडा दान मरमिं आसि पिलाल्क आयाका मुन्‍नेन हातोर. इल्‍हा एडुरगुडा दानतोनि मरमिं आसि, पिलाल्क आयाका मुन्‍नेन हातुर. ");
INSERT INTO esg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","पजा आ मुरतळगुडा हाता. ");
INSERT INTO esg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","अय्ते, हातोर अंटोर मर्रा जीवाते तेदतस्‍के, आ एडुर लोप्पोटाल अद बोना मुत्‍तो आयार? बारित्‍ते ओर एडुरगुडा दान मरमिं आसि मत्‍तुर,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","अस्‍के येसु इल्‍हा वेहतोर, “ई दुनियाता लोकुल्‍कुने मरमिं आयमळ, मरमिं कीसि हियमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","गानि बोर अय्ते हामुरताल मर्रा जीवाते तेदनलायक मनंतुर आनि मर्रा जीवाते तेदमळतुन दोर्किच्‍कुंतुर, ओर वायाना कालमते बस्‍केने मरमिं आयुर, मरमिं कीसिगुडा हिय्युर. ");
INSERT INTO esg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ओर पेनदा दूतनलेसीं मनांतुर, बस्‍केने हायुर. ओर हामुरताल मर्रा जीवाते तेदताहाटीं, ओर पेनदा पिलाल्क आयानुर. ");
INSERT INTO esg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","पोत्‍तना पोदाता बारेमते मूसाल बतल रासतोर मिमेट हदवा हिल्‍लिरा? अब्राहाम, इसाक, याकोब ईर वेल्‍लेन मुन्‍ने हासोत्‍तुर. अयना मूसाल पेनदुन अब्राहाम, इसाक, याकोब मोळ्‍काना पेन इंचि इत्‍तोर. पेन हातोरद आयो गानि जीवाते मनानोरद आंद इंचि मनाकु एरपाट मंता. अद पेनदुन एरपाट कियानोरा अंटोरा जीवां पिसंतां. इल्‍हा हातोरगुडा जीवा अर्रंतुर इंचि मूसाल हुपिस्तोर.” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","येसु वेहता पोल्‍लेतुन केंजसि, “गुरु! निमे बेस वेहतिन,” इंचि इच्‍चुर दर्मसास्‍त्रम कराहना गुरुल्क इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","पजा येसुन सवाल पूसकियालय बोर्के हिम्मत आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","पजा येसु ओर्कुन इल्‍हा इत्‍तोर. “किरिस्‍तु दाविदना मर्रि आंदुर इंचि दर्मसास्‍त्रम कराहना गुरुल्क बल्हा इना परांतुर? ");
INSERT INTO esg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","कुद्‍दु दाविदे ओना बजन संहिता पुस्तकमते इल्‍हा रासतोर. ‘सामि, नावा सामिन इत्‍तोर, बदवेरदाका अय्ते नीवा पगातोर्कुन, नीवा काल्कुनगा तर्रोन, अदवेरदाका नावा तिना बाजुंक उद्‍दिसि मन, इत्‍तोर.’ ");
INSERT INTO esg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","इल्‍हा दाविद ओन, ‘सामि’ इंचि इत्‍तोर. अय्ते ओर दाविदना मर्रि बल्हा आया परांतोर?” ");
INSERT INTO esg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","अंटोर लोकुल्‍क ओना पोल्‍लेतुन केंजसेके मननेंके, येसु ओना सिस्युल्कुन इल्‍हा इत्‍तोर, ");
INSERT INTO esg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“दर्मसास्‍त्रम कराहना गुरुल्कुनाल उसारते मंटु. पोर्रोटाल हिळुदाका पोळ्‍गु अंगिं केर्सि तिरियमळ, हाटुमकुने जोहार वेहागोटकुनमळ ओर्क बेस अनपिच्‍चंता. अल्‍हेने दर्मसास्‍त्रम कराहना लोह्कुने, कुळ्‍पुकुने पेद्‍दाल्‍क उद्‍दाना जेगाते उदमळ इत्‍ते ओर्क वेल्‍ले इस्‍टम. ");
INSERT INTO esg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ईर मुंडामोस्ता मुर्ताह्‍कुन मुळहंतुर, लोकुल्‍कुंक हुप्‍सालय वेल्‍लेनजेम पारतना कींतुर. गानि ईर्क मात्रम पेन अंटोर्कन्‍ना एक्‍को सिक्‍सा हियार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","पजा येसु इच्‍चुर लक्‍कु नदर वाटतोर अस्‍के सिरमंत लोकुल्‍क दान पेटिते पेनदाहाटीं कोत्‍तां वाटनेंके ओन्क दिसतुर. ");
INSERT INTO esg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","अस्‍के मुंडामोस्ता उंदि गरिब मुरतळगुडा दान पेटिते रोंडु रागि कोत्‍तां वाटनेंके येसु हूळतोर. ");
INSERT INTO esg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","अस्‍के येसु इल्‍हा इत्‍तोर. “नना निजम वेहांतन, इग्‍गे दान पेटिते कोत्‍तां वाटता अंटोर लोकुल्‍कुंकन्‍ना ई मुंडामोस्ता गरिब मुरतळे एक्‍को दानम कीता. ");
INSERT INTO esg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","इल्‍हा नना बारि वेहासेके इत्‍ते, अंटोर बारे ओरा दनमताल इच्‍चुरे दानम कीतुर. गानि इद मुरतळ मात्रम दान्क पिस्‍सनाहाटीं इरतादानगुडा पेनदुक वाटसीता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","अस्‍के इच्‍चुर लोकुल्‍क, “इद गुळिता बंडां हुळाट बच्‍चोन सोक मंतां! इंका पेनदाहाटीं हीता सामानतोनि तयार कीता आ सिंगारम हुळाट बच्‍चोन बेस मंता,” इंचेके वळ्कसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","अस्‍के येसु ओर्कुन, “इंदके मिमेट हूळना इव बंडां उंदानपोर्रो उंदि मनाकोंटा कूल्‍हाना वेला वायनद मंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","अस्‍के सिस्युल्क, “गुरु, इव पोल्‍लें बस्के जर्गनुं? इंका इव गटनां जर्गना मंता इन्‍नेंके माकु बतल चिन्‍ह दिस्‍सार?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","अस्‍के येसु इल्‍हा इत्‍तोर. “मीकुन बोरन्‍ना पसांचनुर, उसारते मंटु. नावा पोरोल एतसेके बचुटूरो लोकुल्‍क वासि, ‘ओन ननाने आंदुन, इंतुर. इंका अद वेला दग्‍गेरा एव्ता,’ इंचि इनानुर. असंटोरा पज्जो होनमट. ");
INSERT INTO esg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","लडाईं, जगडाल्‍कुना बारेमते केंजसि वेरियमट. इव अय्ते तप्‍पाकोंटा मोदाला जर्गनुंगें. गानि अच्‍चोटेन आकिर वेला वायो. ");
INSERT INTO esg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“इंका देसेमपोर्रो देसेम, राज्येमपोर्रो राज्येम लडाईं आयनुं. ");
INSERT INTO esg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","पेद्‍दा बूकंपाल्क आयनुं, वेरे-वेरे जेगाने कर्वु अर्रार, तीराता रोगाल्क पुट्‍टानुं. मब्बुने वेल्‍लेन वेरियनसोंटा गटनां जर्गनुं, पेद्‍दा-पेद्‍दा चिन्‍हां दिस अर्रानुं. ");
INSERT INTO esg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“गानि इवन्‍नि जर्गाका मुन्‍ने, मिमेट नावापोर्रो विस्वासम इरताहाटीं यहुदिल्कु मीकुन दोर्कापीसि, वेल्‍लेन तकलिप कीसि मीवा न्‍यायम कियनाहाटीं दर्मसास्‍त्रम कराहना लोह्कुने ओयानुर, ओसि मीकुन जेलने वाटानुर. पजा मीवा इच्‍चुर पगातोर मीकुन राजालोरा आनि राज्यपालना मुन्‍ने ओयानुर. ");
INSERT INTO esg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","दीनहेंदाल मीकु नावा बारेमते गवाइ वेहालय हर्रि दोर्कार. ");
INSERT INTO esg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","इंचि मीवा न्‍यायम जर्गनेंके बतल वळ्कना इंचेके मोदाले रंदि कियमट. ");
INSERT INTO esg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","वेला वातस्के नना मीकु इसोंटा पोल्‍लें आनि बुद्‍दि हींतन गदा, मिमेट वळ्कानेंके मीवा पगातोर केंजसि वळ्‍काकोंटा आयनुर, इंका मीवा पोल्‍लेक अड्‍डमगुडा वळ्का पर्राकोंटा आयानुर. ");
INSERT INTO esg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","अयना मीवा तल्‍लुर-बाबो, तम्मुह्‍क-दादालोर, जीवातोर-हेळमितोर मीवा दंटातोरे मीकुन पीसि पगातोर्कुंक हियानुर. अचोने आयका मीवाव्टेटाल इच्‍चुर्कुन हव्कानुरगुडा. ");
INSERT INTO esg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","नावा पोरोलताहेंका अंटोर लोकुल्‍क मीकुन हय्सुर. ");
INSERT INTO esg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","इदंता अय्नागानि मीकुन बोरे नासडेम किया पर्रोर. ");
INSERT INTO esg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","पेनदापोर्रोटा विस्वासमते आकिरदाका निल्‍सि मत्‍ते, मिमेट मीवा जीवातुन कापाळकुना परांतिर. ");
INSERT INTO esg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“हुळाट! सिपाइल्क येरुसलेम सुट्‍टु आतद मिमेट बस्के अय्ते हूळांतिर, अस्‍के सहर नासडेम आयना वेला एव्ता इंचि इनकुंटु. ");
INSERT INTO esg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","अस्‍के बोर अय्ते यहुदिया एरियाते मंतुरो ओर गुट्‍टनहेके वित्‍तट, बोर अय्ते सहरते मंतुरो ओर सहरता पलाते पेय्सि होनगोम अल्‍हेने नाटे मनना लोकुल्‍क सहरते होळिया मन्‍नि. ");
INSERT INTO esg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","बारित्‍ते पेनदा पिलान परकारम अव सिक्‍सा हियना रोजुक आंदु. दर्मसास्‍त्रमते रासि मत्‍ता अन्‍नि पोल्‍लें पूरा आयना वेला आंदु. ");
INSERT INTO esg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","अव रोजकुने पीटे मत्‍ता मुर्ताह्‍कुंक आनि सिन्‍ने मर्तल्‍लुह्‍कुंक वेल्‍लेन तकलिप वांता. बारित्‍ते इद बूमिपोर्रो वेल्‍लेन तिप्‍पल्‍क वायाना मंता. आनि यहुदिल्कुनपोर्रो पेन दाना होंगुन हुपिचना मंता. ");
INSERT INTO esg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","इच्‍चुर मनकालोर कसेह्कुने कोह्‍ककुंचि हायानुर, इंक्‍किच्‍चुर मनकालोर्कुन बारे वेरे देसेमतोर्कुंक दोर्कापीसि हियनुर. पजा यहुदि आयवा लोकुरा कालम मारनदाका, ओर येरुसलेमता लोकुल्‍कुन ओरा कादा हिळु जारसि इर्रानुर. ");
INSERT INTO esg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“पोळ्‍दुनपोर्रो, वेळसिपोर्रो, सुक्‍कनपोर्रो चिन्‍हां दिस्‍सानुं. इंका बूमिपोर्रो समुद्रमता आवाज आनि अव्टे तेदाना पेद्‍दा तडाना सप्पुड केंजसि देसे-देसेल्‍कुना लोकुल्‍क इरगा वेरियानुर. ");
INSERT INTO esg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","इरगा वेरियसि, इद दुनियाते वायाना तिप्‍पल्‍कुना बारेमते विचारम कीसि, लोकुल्‍कुना जीवा पेय्सोत्‍ताप आयार. बारित्‍ते मब्बुने मनना अन्‍नि सक्‍तिन कदलिच्‍मळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","अस्‍के मनकना रूपमते पुटतोन नना, ताकत आनि पेद्‍दा महिमातोनि, मब्बु तेर्पेनपोर्रो वायानेंके लोकुल्‍क हूळानुर. ");
INSERT INTO esg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","इल्‍हा जर्गमळ सुरुव आतस्के मिमेट अंटोर मीवा तल्‍ला तेह्‍चि पोर्रोळ्‍क हुळट. बारित्‍ते पेन मीकु मुक्‍ति हियाना वेला दग्गेर्क एवसेकेन मंता.” ");
INSERT INTO esg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","पजा येसु ओर्क उंदि वेसुडि वेहतोर. “अद अंजिर मरातुन आनि केडाते मत्‍तव अन्‍नि मराकुन हुळट. ");
INSERT INTO esg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","अवुना आकिं रालतद हूळसि, एद्‍दि कालम दग्‍गेरा एव्ता इंचि मीकु बिराना तेळियसि दांता. ");
INSERT INTO esg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","इल्‍हा इव अन्‍नि गटनां जर्गनद हूळसि, पेनदा राज्येम दग्गेर्क एव्ता इंचि मिमेट एरपाट कींतिर. ");
INSERT INTO esg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","नना मीकु निजम वेहांतन, बदवेरदाका अय्ते इव अन्‍नि पोल्‍लें पुरागा आयोंगो, अदवेरदाका ई पीळि मुळगो. ");
INSERT INTO esg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","इद बूमि, मब्बु नासडेम आसि होंदार, गानि नावा पोल्‍लें बस्‍केने नासडेम आयों.” ");
INSERT INTO esg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“अदुनहाटीं मिमेट पार्टिं किय्युड, कल उनुड इंका इद दुनियाता रंदिनेन मीवा मनसु मनना आयो. गानि नना मर्रा वायना रोजु अचानक अर्रना कोम्मालेह्का मीपोर्रो वासि अर्राकोंटा मीवद मिमेट जेगर्ता मंटु. ");
INSERT INTO esg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","बारित्‍ते अद रोजु इद बूमिपोर्रो मनना अंटोर लोकुल्‍कुनपोर्रो अल्हेन अर्रानद मंता. ");
INSERT INTO esg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","अदुनहाटीं वेल्‍लेन उसारते मंचि, बव अय्ते गटनां जर्गनद मंता, अव अन्‍नि गटनानाल पिस्‍सनाहाटीं ताकत दोर्कगोम इंचि बस्केळक पारतना कीसेक मंटु. अल्हा मत्‍तिरित्‍ते, बस्के अय्ते मनकना रूपमते पुटतोन नना वांतन, अस्‍के नावा मुन्‍ने वेरियाकोंटा नित्‍ता परकिट.” ");
INSERT INTO esg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","इल्‍हा येसु हरेक रोजु पोद्‍दाला गुळिते कराहसेक मनुंदुर. गानि नर्कळ्‍क मात्रम सहरताल पलाते जय्‍तुन इनना गुट्‍टातगा होंचि मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","हक्‍केर-हक्‍केरा अंटोर लोकुल्‍क तेदसि ओना पोल्‍लें केंजानाहाटीं गुळितगा जमा आयुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","पुल्‍लगा आयवा पिंडिता हारिना पंडुगु दग्गेर्क एव्‍सि मत्‍ता. इद पंडुगुन दाटसि होनना पंडुगुगुडा इंतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","अस्‍के पेद्‍दा पेर्मालोर, दर्मसास्‍त्रम कराहना गुरुल्क ईर अंटोर उंदगा कलियसि, येसुन बल्हा हव्कना? येसुन बल्हा सप्‍पुडदाका दोर्कापीसि हव्‍कोम, इंचि पिलानकु कियालय दल्‍गुतुर. गानि लोकुल्‍कुंक येसुनपोर्रो मत्‍ता विस्वासमतुन हूळसि ओर वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","पजा येसुना पन्‍नेंडु सिस्युल्‍कुनाल वरोर इस्‍कारियोत नाटेना यहुदाना लोप्पो पेद्‍दा देय्यम होळियता. ");
INSERT INTO esg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","अस्‍के ओर पेद्‍दा पेर्मालोरगा आनि गुळिता कावेल कियना अदिकारिल्कुंक होंचि कलियतोर. कलियसि येसुन ओर बल्हा पीसि हिया पर्रांतोर इदुना बारेमते, ओरतोनि वळ्कतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","यहुदाना पोल्‍ले केंजसि पेद्‍दा पेर्मालोर आनि अदिकारिल्‍क वेल्‍लेन कूस आसि ओर, ओन्क कोत्‍तां हींतोम, इंचि ओप्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","अदुनहाटीं गर्दि हिल्‍वद हूळसि येसुन ओरा कय्‍दे पीसि हियालय मोका हूळसेक मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","पजा दाटसि होनना पंडुगु एव्ता. मूसाना नियम परकारम अद पंडुगुना मोदाटा रोजु उंदि गोर्रे पोरिना मोक्‍कु हियमळ मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","अदुनहाटीं येसु, पत्रुन आनि योहानुन, “मिमेट मुन्‍ने होंचि दाटसि होनना पंडुगुना गाटो तयार कीम्‍टु अस्‍के मनम तिनकोम,” इंचि ओर्कुन लोहतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","अस्‍के, “मोमोट पंडुगुना गाटो तिनना तयारिं बगा कीकोम इंचि नीवा मनसु मंता सामि?” इंचि ओर येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","अस्‍के येसु ओर्कु इल्‍हा वेहतोर, “मिमेट सहरते होळियतस्‍के, मीकु वरोर मनकल अळकाते एर पीसि होननेंके कलियंतोर. ओर बद लोन अय्ते दांतोरो, अदे लोतागा मिमेटगुडा ओना पज्जो होंटु. ");
INSERT INTO esg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अगा होत्‍तस्के, आ लोता मालाकुंक, ‘गुरु ओना सिस्युल्कुनतोनि कलियसि, दाटसि होनना पंडुगुना गाटो तिननाहाटीं हेळमितोर आगाना अर्रा बगा मंता, इंचि गुरु पूसकीसंतोर,’ इंचि वेहाट. ");
INSERT INTO esg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","अस्‍के ओर मीकु मिद्‍दे पोर्रोटा उंदि पेद्‍दा अर्रा सजांचि तयार कीसि मत्‍तद हुप्‍सानुर. अदे अर्राते मिमेट पंडुगुना गाटो तयार कीम्‍टु,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","अस्‍के ओर होंचि हूळतुर अय्ते, ओर बल्हा वेहतोर अल्‍हेने अगा मत्‍ता. पजा ओर अग्गेन दाटसि होनना पंडुगुना गाटो तयार कीतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","दाटसि होनना पंडुगुना गाटो तिनना वेला एवतस्‍के, येसु ओना प्रेरितुल्कुनतोनि कलियसि गाटो तिनालय उदतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","उदतस्‍के येसु ओर्कुन, “नाकु तिप्‍पल्‍क वायका मुन्‍ने मीवातोनि कलियसि ई दाटसि होनना पंडुगुना गाटो तिनना इंचि नाकु वेल्‍लेन आसे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","नना मीकु वेहानद बतल इत्‍ते, इद पंडुगु बद पोल्‍लेतुन अय्ते हुप्‍संता, अद पोल्‍ले पेनदा राज्येमते पुरागा आयनदाका नना इद पंडुगुना गाटो तिन्‍नोन.” ");
INSERT INTO esg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","पजा ओर अंगुर पंडिना पानकमतोनि निंडिस मत्‍तद उंदि गिलास पीतोर आनि पेनदुक दन्यवाद कीसि अदुन ओना सिस्युल्कुंक हीतोर. हीसि, “इदेट, दीन मिमेट पंचकुंचि उंटु. ");
INSERT INTO esg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","नना मीक वेहांतन, पेनदा राज्येम बदवेरदाका अय्ते वायोनो, अदवेरदाका, इय्याटाल नना अंगुर पानकम उन्‍नोन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","पजा येसु उंदि हारितुन पीसि, पेनदुक दन्यवाद कीतोर. पजा आ हारितुन तुकडां कीसि ओना सिस्युल्कुंक पंचि हीसेक, “इद हारि इत्‍ते, मीवाहाटीं मोक्‍कु आयना नावा मेंदुलता चिन्‍ह आंदु. नाकुन मति कियनाहाटीं मिमेट इल्हेन कीसेक मंटु,” इंचि ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","पजा अंटोरा तिनमळ आतस्के, अंगुर पंडिना पानकमते निंडिस मत्‍ता गिलासुन पीसि, “इद पानकम इत्‍ते मीवातोनि पेन कियना पूना करारता चिन्‍ह आंदु. नना मीवाहाटीं नावा नेत्‍तुरतुन पोंगागोटंतन, अस्‍के पेन दाना राज्येमतुन निलाहंता. ");
INSERT INTO esg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“अयना हिके केंजाट, नाकुन दोकाते पीसि हियानोरगुडा इंदके इगे नातोनि गाटो तिनालय उद्‍दिसि मंतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","मनकना रूपमते पुटतोन नना, नावा बारेमते बल्हा अय्ते रासि मंता, अल्हे दांतन. गानि बोनाहेंदाल अय्ते नाकुन पीसि हियमळ जर्गंता ओन्क बच्‍चोर गोसा आयार,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","येसु वेहतदुन केंजसि सिस्युल्क, “अल्हा कियानोर मना नड्‍डुम बोर मंतोर मरि?” इंचि ओरद-ओरे वळ्ककुनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","पजा “मना नड्‍डुम अंटोर्कन्‍ना पेद्‍दा बोर मनना?” इत्‍ता पोल्‍लेहाटीं सिस्युल्कुंक ओर्क-ओर्के पोल्‍लें आतां. ");
INSERT INTO esg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर. “यहुदि आयवोरा राजालोर लोकुल्‍कुनपोर्रो जबरदस्‍तिते राज्येम कींतुर. आनि ओरपोर्रो अदिकारम ताकसालय हूळानोर, ‘मोमोट लोकुल्‍कुंक बेस सहायम कियानोरम,’ इंचि वेह्‍कुंतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","गानि मिमेट ओरालेसीं कियमट. मी लोप्पोटाल बोर अय्ते पेद्‍दा मंतोर, ओर अंटोर्कन्‍ना सिन्‍नोनलेसीं आयना. अल्‍हेने बोर मीवा लीडर मंतोर ओर सेवाकुनलेसीं आयना. ");
INSERT INTO esg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","असल पेद्‍दा इत्‍ते बोर आंद? बोर अय्ते गाटो तिनालय उद्‍दंतोर ओरा? मरि उद्‍दुतोंकु गाटो वाटांतोर ओरा? गाटो तिनालय उद्‍दुतोरे पेद्‍दोड आंद. गानि नना अय्ते मीवा नड्‍डुम गाटो वाटाना सेवाकुनलेसीं मंतन.” ");
INSERT INTO esg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“मिमेट अय्ते नना तिप्पल्कुने मत्‍तस्केगुडा नावातोनि मत्‍तोर आंदिर. ");
INSERT INTO esg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","अदुनहाटीं नावा बाबाल बल्हा नाकु राज्येम कियना अदिकारम हीतोर, अल्हेन ननागुडा मीकु अदिकारम हींतन. ");
INSERT INTO esg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","अद अदिकारम बद इत्‍ते, मिमेटगुडा नावा राज्येमते नावातोनि उद्‍दिसि तिनकिर, उनकिर. इंका राजगद्‍देन पोर्रो उद्‍दिसि इस्राएलना पन्‍नेंड गोत्राल्कुनोरा न्‍यायम कीकिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","येसु मर्रा सिमोन पत्रुन, “सिमोनु, ए सिमोनु हिके केंजा! मीकुन अंटोर्कुन वंजिन हेचाहताप हेचाहचि मी अंटोरा विस्वासमता पट्‍टु हूळानाहाटीं पेद्‍दा देय्यम पेनदुन अदिकारम तल्कता. ");
INSERT INTO esg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","गानि निमे विस्वासमताल पजोळ्क होनाकोंटा मनना इंचि नना नीवाहाटीं पारतना कीतन. अयना निमे मर्रा विस्वासमते नाहेके तिरियतस्के नीवा दंटाता विस्वासुल्कुना विस्वासमतुनगुडा गट्‍टिगा कीम,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","गानि सिमोन पत्रु मात्रम, “सामि! नीवातोनि कलियसि जेलुंक होनालय, हायालयगुडा नना तयार मंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","अस्‍के येसु पत्रुन, “पत्रु नना वेहानद केंजा! इय्याला नर्कळ्‍क मोदाटा गोगोड कूसाका मुन्‍ने निमे, ‘नना येसुन एरपाट किय्योन,’ इंचि मूड मल्कां इनकिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","पजा येसु ओना सिस्युल्कुन, “उंदि मल्का नना मीकुन कोत्‍तना पाकिट, जोरा इंका हेरपुह्क हिलाकोंटेन लोहचि मत्‍तन. अस्‍के मीकु बतलन्‍ना तक्‍को होंचि मत्‍तना?” इंचि पूसकीतोर. अस्‍के सिस्युल्कु, “हिल्‍ले, बतले तक्‍को होना हिल्‍ले,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","पजा येसु ओर्कु इल्‍हा वेहतोर. “मिहगा बोरागन्‍ना कोत्‍तना पाकिट मत्‍ते, दान पज्जेन पीकुन्‍निर, इंका जोरागुडा पीकुन्‍निर. अल्‍हेने कसेर हिलवोरु ओना कपडिं अम्मिसि उंदि कसेर असकुन्‍निर. ");
INSERT INTO esg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","बारित्‍ते, नना वेहानद केंजाट! दर्मसास्‍त्रमते, ‘ओन तप्पु कीतोरव्टे कल्‍पतुर,’ इंचि नावा बारेमते रासि मत्‍ता. दर्मसास्‍त्रमते नावा बारेमते बतल अय्ते रासि मंता, अद इंदके नावातोनि निजम आयमळे गावाले,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","अस्‍के सिस्युल्क, “इद हूळा सामि, इव रोंडु कसेह्‍क मंतां,” इंचि इत्‍तुर. इत्‍तस्के येसु, “सरे! आंतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","पजा अद लोताल पेय्सि ओना अलवट परकारम, जय्‍तुन इनना गुट्‍टापोर्रो होत्‍तोर. ओना पज्जो ओना सिस्‍युल्‍कगुडा होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","अगा होत्‍तस्के येसु ओना सिस्युल्कुंक, “मिमेट पट्‍टुने अर्राकोंटा मननाहाटीं पारतना कीसेके मंटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","पजा येसु ओरागटाल, इच्‍चोन लक्‍कु होंचि टोंगरां ऊनसि इल्‍हा पारतना कियालय दल्‍गतोर: ");
INSERT INTO esg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ए पेनबाबा! ओक्‍कला नीवा इच्‍चा मत्‍ते, नाकु वायाना ई तकलिपतुन नावा पोर्रोटाल तप्पिच्‍चा. अयना नावा इच्‍चा मत्‍ताप आयो गानि नीवा इच्‍चा बल्हा मंता अल्हे जर्गि,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","अस्‍के अगा उंदि पेनदा दूता स्वर्गमताल वासि ओन्क ताकत हियालय दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","येसु वेल्‍लेन दुक्‍कमते निंडिसि पेनदुक पारतना कीतोर. ओर अल्हा पारतना कियनेंके ओना सेमटा, नेत्‍तुरलेसीं आसि बोट्‍टुक-बोट्‍टुक बूमिपोर्रो अरसेक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","पारतना कियमळ मारतस्के, सिस्युल्कुनगा वासि हूळते, ओर दुक्‍कमते तकांचि निद्रा होंचि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","अस्‍के येसु ओर्कुन, “मिमेट बारि निद्रा होत्‍तिर? तेदट! तेदसि मिमेट पट्‍टुने अर्राकोंटा मननाहाटीं पारतना कीसेके मंटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","येसु इव पोल्‍लें वळकसेकेन मत्‍तोर. अच्‍चोटेन अगा उंदि लोकुल्‍कुना मंदा वाता. अद मंदातुन यहुदल पीसि वातोर (ई यहुदल येसुना पन्‍नेंड सिस्युल्‍कुनाल वरोर आंद). तच्‍चि ओर येसुन बुर्रालय ओना दग्गेर्क होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","अस्‍के येसु ओन, “यहुदा, उंदि मुद्‍दु बुर्सि निमे मनकना रूपमते पुटतोन नाकुन दोर्कापीसि हियालय हूळसंतिना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","येसुन पियानदुन हूळसि कळमता सिस्युल्क, “सामि, महगा कसेह्‍क मंतां, मोमोट ईरकुन नर्क्‍कोमा?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अच्‍चोटेन ओरा लोप्पोटाल वरोर सिस्युड पेर्मालोरा लीडरना वरोर दासुन कसेटे हीतोर अय्ते ओना तिना केव नेमसोत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","अस्‍के येसु, “मन्‍नि, अल्हा कियमट,” इत्‍तोर. इंचि ओना नेमसोत्‍ता केवदुन इटसि ओन बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","पजा येसु, ओन्क विरोदमते तेदता पेद्‍दा पेर्मालोर्कुन, गुळिता अदिकारिल्‍कुन आनि यहुदिल्कुना पेद्‍दाल्कुन इल्‍हा इत्‍तोर. “वरोन दोंगन पिय्‍यालय वाताप मिमेट कसेह्‍क, गुत्‍पां पीसि नाकुन पिय्‍यालय वातिरा? ");
INSERT INTO esg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","नना अय्ते रोज गुळितगा मीतोनि मनुंदुन, मिमेट अस्‍के नाकुन पिया हिल्‍लिर. अयना इद मीवा वेला आंदु, हीकटता राज्येम कियना वेला आंदु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","पजा ओर येसुन दोर्कापीसि, अगटाल पेद्‍दा पेर्माना लोन ओतुर. पत्रुगुडा लक्‍कुटाले ओना पज्जो-पज्जो होंचेके मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","पेद्‍दा पेर्माना दाराते तडमि माससि ओर अंटोर सुट्‍टु उद्‍दिसि मत्‍तुर. पत्रुगुडा ओरतोनि अग्गेन उदतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","पत्रु तळमितगा उद्‍दिसि मत्‍ताहेंके तळमि वेलगु ओनपोर्रो अरसि उंदि दासि पोरिंक ओर दिसतोर. अस्‍के आ दासि पोरि पत्रुनहेके हूळसेक, “ई मनकलगुडा येसुनतोने मत्‍तोर,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","गानि पत्रु, “नना ओन एरपाट किय्योन बाई,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","जेरासेप आतंका इंकावरोर मनकल पत्रुन हूळसि, “निमेगुडा ओराव्टेटाल वरोन आंदिन गदा,” इंचि इत्‍तोर. अस्‍के पत्रु, “हिल्‍ले दादा, नना आयोन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","दग्‍गेर-दग्‍गेरा उंदि गंटा आता पजा, इंकावरोर मनकल, “ईर गालिल एरियाता मनकनलेसीं वळ्कसंतोर, अदुनहाटीं निजमे ईर येसुनतोनि मत्‍तोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","अस्केगुडा पत्रु, “निमे बतल वळ्‍कसंतिन दादा! नना ओन असले एरपाट किय्योन,” इंचि इत्‍तोर. अल्हा इत्‍ता-इनुडे मोदाटा गोगोड कूसता. ");
INSERT INTO esg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","अस्‍के सामि पत्रुनहेके तिरियसि हूळतोर. अस्‍के, “इय्याला नर्कळ्‍क गोगोड कूसाका मुन्‍ने निमे नाकुन मूड मल्कां एरपाट किय्योन इंतिन,” इंचि येसु मुन्‍नेने वेह्‍चि मत्‍ता पोल्‍ले पत्रुंक मति वाता. ");
INSERT INTO esg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अस्‍के ओर पलाते होंचि इरगा अळतोर. ");
INSERT INTO esg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","येसुन बोर अय्ते पीसि मत्‍तुरो ओर कारेड्‍डाल्‍क कीसेके इरगा तनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ओना कळ्‍कुंक कप्‍पिड गंडा दोह्‍चि, “इंदके नीकुन बोर तंतुर? माकु बविस्यवानि वेहा,” इंचि ओन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","अचोने आयका ओना अपमानम कियानाहाटीं वेल्‍लेन पोल्‍लें इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","पंगातस्के यहुदि पेद्‍दाल्क उंदि पंचादि उपिस्तुर, अगा पेद्‍दा पेर्मालोर, दर्मसास्‍त्रम कराहना गुरुल्क मत्‍तुर. अद पंचादिते येसुन पीसि तच्‍चि ओरा मुन्‍ने निलाहतुर. ");
INSERT INTO esg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","पजा ओर येसुन, “ओक्‍कला निमे किरिस्‍तुन आते माक वेहा,” इंचि इत्‍तुर. गानि येसु, “ओक्‍कला नना वेहिनागानि मिमेट नम्मिर. ");
INSERT INTO esg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","इंका नना सवाल्क पूसकिय्यिनागानि मिमेट जवाबगुडा हिय्यिर. ");
INSERT INTO esg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","गानि इंदकेटाल, गडसेम मत्‍तंका मनकना रूपमते पुटतोन नना ताकतवर पेनदा तिना बाजुंक उद्‍दंतन,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","अस्‍के पंचादिते मत्‍ता अंटोर लोकुल्‍क, “अय्ते निमे पेनदा मर्रिना?” इंचि इत्‍तुर. अस्‍के येसु, “मिमेट इनानद निजमे,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","अस्‍के, “कुद्‍दु ओना तोळ्‍दाल ओरे वेहतद मनम केंजतोम. अय्ते मनाक बतल गवाइ गावाले?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","पजा पंचादिता अंटोर लोकुल्‍क तेदसि येसुन अगटाल पिलातुस इनना राज्यपालनगा ओतुर. ");
INSERT INTO esg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ओसि, “ईर मावा यहुदि लोकुल्‍कुंक एकरेवुल्क वेहचि ओर्कु तप्‍पुड हर्रि हुप्‍सानेंके मोमोट हूळतोम. इंका कैसर राजांक कर दोहामन्‍नि इंचि वेहांतोर. अचोने आयका ओनद ओरे, ‘नना किरिस्‍तुन, राजुन आंदुन,’ इल्‍हा वेहकुंतोर,” इंचि दोसेल्क दोसालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","अस्‍के पिलातुस येसुन, “निमे यहुदिल्कुना राजुन आंदिना?” इंचि पूसकीतोर. अय्ते, “निमेन इंचंतिन गदा,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","अस्‍के पिलातुस पेद्‍दा पेर्मालोर्कुन आनि लोकुल्‍कुन, “नाकु ई मनकनगा बतले तप्पु दिस्सेक हिल्‍ले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","गानि लोकुल्‍क मात्रम पिलातुस राज्यपालना पोल्‍ले केंजाकोंटा, “ईर पुरागा यहुदि लोकुल्‍कुना देसेमते ओना पोल्‍लें कराहचि अंटोर लोकुल्‍कुंक एकरेवुल्क वेहचंतोर. इद कबळ ईर गालिल एरियाते सुरुव कीसि इंदके इग्‍गेळदाका एवतोर,” इंचेके इरगा लोल्‍लि कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","लोकुल्‍क इनानदान केंजसि पिलातुस, “बतल, ई मनकल गालिल एरियातोरा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","अव रोजकुने गालिल एरियापोर्रो हेरोद अंतिपस राजाल राज्येम कीसेके मत्‍तोर. येसु गालिल एरियातोर इंचि तेळियतस्के, पिलातुस ओन हेरोद राजानहेके लोहचीतोर. आ वेलाते हेरोद राजालगुडा येरुसलेम सहरतेन मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोद अंतिपस राजाल येसुना बारेमते केंजसि मत्‍तोर अदुनहाटीं वेल्‍लेन वर्सानाल येसुन हूळना आसेते मत्‍तोर. इंका ओन्क येसुना कयदाल बतलन्‍ना चिन्‍ह हूळानद मत्‍ता. अदुनहाटीं येसुन हूळसि हेरोद राजांक वेल्‍लेन कुसि आता. ");
INSERT INTO esg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","अस्‍के ओर येसुन वेल्‍लेन सवाल्क पूसकीतोर. गानि येसु बतले जवाब हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","पेद्‍दा पेर्मालोर आनि दर्मसास्‍त्रम कराहना गुरुल्क मात्रम येसुनपोर्रो ओरा मनसुंक वाताप तप्पुक-दोसेल्क दोस्सेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","पजा हेरोदगुडा ओना सिपाइल्कुनतोनि कलियसि येसुन कारेड्‍डाल्‍क कीसेके कव्‍तोर. येसुंकु राजालोर केर्राना कपडिं केराह्‍चि ओर मर्रा पिलातुसुनहेके लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","अदे रोजु हेरोद अंतिपस राजाल आनि पिलातुस ईर इव्वुर दंटातोर आतुर. दीनकन्‍ना मुन्‍ने ओर वरोंक वरोर विरोदमते मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पजा पिलातुस पेर्मालोर्कुन, राज्येम कियानोर्कुन आनि लोकुल्‍कुन केयतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","केय्‍सि ओर्कुन इल्‍हा इत्‍तोर, “लोकुल्‍कुंक एकरेवुल्क वेहचि ओर्क तप्‍पुड हर्रि हुपिच्‍चंतोर इंचि येसुन मिमेट इगे तत्‍तिर. नना मीवा मुन्‍नेन ईन बेस परमेरका कीसि पूसकीतन. मिमेट ईनपोर्रो दोसता तप्पुक-दोसेल्कुनाल उंदिगुडा नाकु ईना लोप्पो दिसा हिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","इंका हेरोद अंतिपस राजांकगुडा ईना लोप्पो तप्पुक-दोसेल्क दोर्का हिल्‍लें. अदुनहाटीं ओर ईन मर्रा नाहेकेन तिराह्‍चि लोहतोर. ईन्कु हामुर सिक्‍सा हियनलायक ईर बतल तप्पु किया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","अदुनहाटीं नना ईन पोट्‍टे देब्बां तंचि होळसींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","इद पंडुगुने एडादिक वरोन यहुदि मनकन जेलनाल होळसा पिय्‍युंदु. ");
INSERT INTO esg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","अस्‍के अंटोर लोकुल्‍क कलियसि उंदेतीर, “ई येसुंक हामुर सिक्‍सा हीम, मावाहाटीं बरब्बन होळसीम,” इंचि इरगा वरगेयालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(ई बरब्बल इनानोर सहरता मनकालोर्कुन सरकारता विरोदमते कीसि मत्‍तोर. इंका बचुटूरो लोकुल्‍कुन हव्‍किसिगुडा मत्‍तोर. अदुनहाटीं ओन जेलने वाटसि मत्‍तुर.) ");
INSERT INTO esg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातुसना मनसुने येसुन होळसियानद मत्‍ता, अदुनहाटीं ओर लोकुल्‍कुंक इंकुंदि मल्का विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","गानि लोकुल्‍क मात्रम, “ओन क्रुसुनपोर्रो मोल्‍लां कोह्‍किसि वेलाड वाटट, ओन क्रुसुनपोर्रो वेलाड वाटट,” इंचि इरगा मोत्‍कुंचेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","अयना पिलातुस मूडो मल्का ओर्कुन, “बारि? ईर बतल तप्पु कीतोर? ईनकु हामुर सिक्‍सा हियनलायक नाकु बतले तप्पु दोर्काहिल्‍ले. अदुनहाटीं नना ईन पोट्‍टे देब्बां तंचि होळसींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","गानि लोकुल्‍क मात्रम उंदेतीर, “येसुन क्रुसुनपोर्रो वेलाड वाटा,” इंचि इरगा मोत्‍कुंचेके मत्‍तुर. ओरा मोत्‍कुन्‍मळता मुन्‍ने पिलातुसनद उंदिंका पोल्‍ले ताका हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","अदुनहाटीं पिलातुस, लोकुल्‍कुना इच्‍चा परकारमे आयि, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","पजा सरकारता विरोद कीसि, लोकुल्‍कुन हव्‍किसि जेलुंक होंचि मत्‍ता बरब्बन लोकुल्‍क तल्कताहेंका ओन होळसिया वेहतोर. येसुन बारे लोकुल्‍कुना इच्‍चा मत्‍ताप कीकुन्‍निर इंचि ओरा कय्‍दुक अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","सिपाइल्क येसुन पीसि होननेंके, अच्‍चोटेन कुरेनि सहरतोर वरोर सिमोन इनना मनकल ओना सहरताल वासेके मत्‍तोर, ओर्क कलियतोर. अय्ते सिपाइल्क ओन दोर्कापीसि येसुना क्रुसुन कांजसेक येसुना पज्जो-पज्जो ताका वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","अस्‍के लोकुल्‍कुनद उंदि पेद्‍दा मंदा येसुना पज्जो होंचेके मत्‍ता. अद मंदाते इच्‍चुं मुर्ताह्क इंका मत्‍तां, अव येसुनाहाटीं वेल्‍लेन बादाते इरगा अळसेके मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","अस्‍के येसु अवुनहेके तिरियसि अवुन इल्‍हा इत्‍तोर. “ए येरुसलेम सहरता मुरताह्‍कुनिटा! मिमेट नावाहाटीं अळमट, गानि मीवा मर्क-मियाह्क, मीवा सतताहाटीं अळट. ");
INSERT INTO esg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","बारित्‍ते मुन्‍ने इसोंटा तकलिपता रोजकु वायानव मंतां गदा, अव रोजकुने, ‘गोड्होत्‍ता मुरतळके सुकम मंता, पिलाल्क आयवा मुरतळके सुकम मंता, बस्‍केने मरतल्‍लुर आयवा मुरतळके सुकम मंता,’ इंचेके लोकुल्‍क इनानुर. ");
INSERT INTO esg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","इंका ओर, ‘मावा पोर्रो वासि अर्रट,’ इंचि गुट्‍टान इनानुर आनि ‘माकुन पूळसट’ इंचि गुप्पन इनानुर. ");
INSERT INTO esg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","मरा पच्‍चगा मननेंकेन ईर लोकुल्‍क इल्‍हा कीसंतुर अय्ते, वत्‍सोत्‍ता मरातुन बल्हा कियनुरो?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","पेद्‍दा तप्पु कीता इंका इव्वुर मनकालोर्कुनगुडा हामुर सिक्‍सा हिय्यालय येसुनतोनि ओसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","पजा ओर “तला बोरसेम” इनना जेगातगा एवतुर. एवतस्‍के येसुन क्रुसुनपोर्रो मोल्‍लां कोह्‍किसि वेलाड वाटतुर. अल्‍हेने पेद्‍दा तप्पु कीता आ इव्वुर मनकालोर्कुनगुडा येसुनतोनि ओना तिना बाजुंक वरोन, रोड्‍डा बाजुंक वरोन क्रुसुनपोर्रो वेलाड वाटतुर. ");
INSERT INTO esg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","अस्‍के, “पेनबाबा, ईर बतल कीसंतुरो, अद ईरके तेळियो. अदुनहाटीं ईर्कुन मापि कीम,” इंचि येसु इत्‍तोर. पजा सिपाइल्क सिट्‍टिं वाट्‍सि ओना कपडिन पंचकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","अगा जर्गनदुनंता लोकुल्‍क नित्‍तिसि हूळसेक मत्‍तुर. राज्येम कियानोरगुडा, “ईर अय्ते इंकावरोन पिसागोटतोर. अय्ते ईर ओक्‍कला पेन पेरता किरिस्‍तु आयानय्ते, ओना जीवातुन ओरे पिसागोटकुन्‍निर,” इंचि कारेड्‍डाल्‍क कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","सिपाइल्कगुडा ओना दग्गेर्क होंचि ओन कारेड्‍डाल्‍क कीसेके, पुल्‍लटा पंडिना पानकम उह्‍चेके, “ओक्‍कला निमे यहुदिल्कुना राजान आते, निमे नीवा जीवातुन पिसागोटकुन,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","इंका ओना तल्‍लातगा पोर्रो, “ईर यहुदिल्कुना राजाल आंदुर,” इंचि उंदि पाटि पोर्रो रासि क्रुसुंक हिरकिस्तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","अगा येसुनतोनि वेलाड वाट्‍सि मत्‍ता तप्‍पु कीता इव्वुर लोप्पोटाल वरोर, “निमे पेन लोहता किरिस्‍तुने गदा! अय्ते नीवद निमे पिसागोटकुंचि माकुनगुडा पिसागोटा,” इंचि ओना अपमानम कीतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","गानि तप्पु कीता इंकावरोर मनकल बारे अल्हा इत्‍ता मनकन गदरिच्‍चि, “ईन्क दोर्कता सिक्‍से नीकुगुडा दोर्कता. अयना नीकु पेन इत्‍ते वेर्रे हिल्‍लेना रो? ");
INSERT INTO esg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","मनम अय्ते तप्पु कीतोम इंचि न्‍यायम परकारम मनाकु सिक्‍सा दोर्कता. गानि ईर अय्ते बतले तप्पु किया हिल्‍लोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","मर्रा येसुन, “येसु, निमे राजाल आतस्के नाकुन मति कीम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","अस्‍के येसु ओन, “नना नीकु निजम वेहचेके, निमे इय्यालेन नावातोनि स्वर्गमते मनकिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","अद वेलाक पिय्यटा पन्‍नेंड एगानस्‍केटाल अय्ते मूड एगनदाका पूरा बूमिअंता हीकट आता. ");
INSERT INTO esg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","पोळ्‍दुना वेल्‍गुगुडा दिसाकोंटा आता. अस्‍के येरुसलेम सहरते मनना गुळिता लोप्पो पवित्र जेगा आनि अन्‍नि जेगांकन्‍ना एक्‍को पवित्र जेगाता नड्‍डुम मत्‍ता परदा, पोर्रोटाल हिळुदाका हर्सि रोंडु तुकडां आता. ");
INSERT INTO esg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","अस्‍के येसु, “ए पेनबाबा! नना नावा आत्मातुन नीवा कय्‍दे अप्‍पजेपंतन,” इंचि लगांचि वरगेयसि जीवा होळस्तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","नूर मंदि सिपाइल्कुनपोर्रो मनना दरोगाल अगा जर्गतद हूळसि, “ई मनकल निजमे नीतिमंतुड आंदुर,” इंचेके पेनदुन तल्‍सकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","अगा हूळालय जमा आता अंटोर लोकुल्‍क अगा जर्गतदुनंता हूळसि ओर ओरा चातिन तनकुंचेके मल्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","गानि येसुन एरपाट कियानोर अंटोर आनि गालिल एरियाताल ओना पज्जो-पज्जो वातव मुर्ताह्क इच्‍चुर लक्‍कु नित्‍तिसि अगा जर्गतदुनंता हूळसेक मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","पजा अगा यहुदिया एरियाता अरिमताइ नाटेनोर वरोर योसेप इनना मनकल मत्‍तोर, ओर यहुदिल्कुना पंचादिता मेंबर मत्‍तोर. अल्‍हेने ओर बेस नीतिमंतुड मत्‍तोर. पंचादिते येसुन हव्कना बारेमते येतता निरनायम ओन्क इस्‍टम मनाहिल्‍ले. इस्राएल देसेमते पेन दाना राज्येम बस्के निलाहंता इंचि ओर एदुर हूळसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ई योसेप पिलातुसनगा होंचि येसुना पीनगुन गति कियनाहाटीं तल्कतोर. ");
INSERT INTO esg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","तल्किसि येसुना पीनगुन क्रुसुनपोर्रोटाल हिळु रेहतोर. पजा एक्‍को दराता हामुर कप्पिडते ओना पीनगुन हुटतोर. अल्हा कीसि बंडातुन तुल्हाचि तयार कीता बोंदाते ओसि इरतोर. अद बोंदाते दीनकन्‍ना मुन्‍ने बोना पीनगुन इर्रा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","आ रोजु नोमकेमताहाटीं तयारिं कियना रोज आंदु. जेरासेप अय्ते पोळ्‍द होंचि नोमकेम रोज होळियानदे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","पजा येसुनतोनि गालिल एरियाताल वाता मुर्ताह्क पीनगुन ओयनेंके बोंदातुन हूळनाहाटीं योसेपुना पज्जो होत्‍तां. इंका अव येसुना पीनगुन बोंदाते बल्हा इरतुर अदुनगुडा हूळतां. ");
INSERT INTO esg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","आयंका अव मुर्ताह्क अगटाल तिरियसि होंचि बेस गमागमा गब्‍बु वायना वस्‍तुक आनि अत्‍तर निय येसुना पीनगुंक होकानाहाटीं तयार कीतां. गानि वारमता नोमकेम रोजु होळियताहाटीं, आदेस परकारम बद्‍दे कबळ कियामन्‍नि इंचि लोने मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पजा वारमता मोदाटा रोजु इत्‍ते अय्तारम हक्‍केरेन पोळ्‍द पेय्‍सका मुन्‍नेन, आ मुर्ताह्क अव तयार कीता गमागमा गब्‍बु वायना वस्‍तुक पीसि येसुन इरता बोंदातगा एवतां. ");
INSERT INTO esg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","एवतस्‍के बोंदाता हरदुक अड्‍डम ताससि मत्‍ता बंडा पक्‍काक दोब्‍बिसि मत्‍तदुन अव हूळतां. ");
INSERT INTO esg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","अस्‍के अव मुर्ताह्क लोप्पो होळियसि हूळतां अय्ते अवुंक अगा येसु सामिना पीनगु दिसा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","अव इदुना बारेमते इल्‍हा बल्हा आता इंचि विचारमते मननेंकेन अचानक इव्वुर मनकालोर जगा-जगा मेर्सना कपडिं केर्सि अवुनगा वासि निलतुर. ");
INSERT INTO esg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","अस्‍के अव इरगा वेरियसि तल्‍ला हिळु वराहचि दंडम दोस्तां. पजा ओर मनकालोर अवुन इल्‍हा इत्‍तुर. “जीवाते मनना मनकन हातोरव्टे बारि पह्कसेक मंतिट? ");
INSERT INTO esg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","ओर इग्‍गे हिल्‍लोर, हामुरताल जीवाते तेदतोर. ओर मीवातोनि गालिल एरियाते मननेंके मीकु, ‘मनकना रूपमते पुटतोन नाकुन पापि मनकालोरा कय्‍दे पीसि हियमळ जर्गार, पजा ओर नाकुन क्रुसुनपोर्रो वेलाड वाट्‍सि हव्कानुर. गानि नना मूड रोजकुने मर्रा जीवाते तेदकन. इवन्‍नि निजम आयनुंगें,’ इंचि वेह्‍चि मत्‍तोर. इद मीकु मति हिल्‍लेना?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","अस्‍के अव मुरताह्कुंक येसु मुन्‍ने वेहता पोल्‍लें मति वातां. ");
INSERT INTO esg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","पजा अव मुर्ताह्क बोंदातगा हूळता पोल्‍लेन बोंदातगाटाल मल्सि होंचि पदाकोंडु प्रेरितुल्कुंक आनि अगा मत्‍ता कळमता अंटोर सिस्युल्कुंक वेहतां. ");
INSERT INTO esg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","अव मुर्ताह्कुने, मगदलेनि नाटेना मरियम, योहानि, याकोबुना यावल मरियम, इंका अवुनतोनि मत्‍ता मुर्ताह्क. इवे मुर्ताह्क अव हूळतव, केंजतव अन्‍नि पोल्‍लें प्रेरितुल्कुंक वेहतां. ");
INSERT INTO esg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","गानि प्रेरितुल्कुंक आ मुरताह्कुना पोल्‍लें अट्‍टिगेन अनपिस्तां. अदुनहाटीं अवुना पोल्‍लेन ओर नम्मा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","अयना पत्रु अगटाल तेदसि बोंदातेके विततोर. अगा लोप्पो होळियसि हूळते, सिराप येसुना पीनगुन हुटसि मत्‍ता कपडिं बल्हा मत्‍तव अल्हे अरसि मत्‍तद दिसता. अगा अल्हा हूळसि इल्‍हा बल्हा आता इंचेके ओनद-ओरे मनसुने विचारम कीसेके मल्सि लोन होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","अदे रोजु येसुना सिस्युल्‍कुनाल बोरो इव्वुर इमाउस इनना नार होंचेके मत्‍तुर. अद नार येरुसलेम सहरताल दग्‍गेर-दग्‍गेरा पदाकोंडु किलोमिटर्क लक्‍कु मंता. ");
INSERT INTO esg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ओर इव्वुर येरुसलेमते जर्गता अन्‍नि गटनन बारेमते वळ्कसेक होंचेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ओर अव पोल्‍लें वळकसेके होंचेके मननेंके येसु अचानक कुद्‍दु ओरगा वासि ओरतोनि कलियसि ताकालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","गानि ओर बोर आंदुर इंचि ओर्क इव्वुर्क एरपाट आयाकोंटा कियमळ जर्गता. ");
INSERT INTO esg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","पजा येसु ओर्कुन, “मिमेट बव पोल्‍लेना बारेमते वळ्कसेक ताकसंतिर?” इंचि पूसकीतोर. अस्‍के ओर इव्वुर दुक्‍कमते अग्गेन निततुर. ");
INSERT INTO esg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","पजा ओर इव्वुरगटाल वरोर किलयुपास इननोर, “इव रोजकुने येरुसलेमते जर्गता गटनन बारेमते नीकु एरपाट हिल्‍लेना? पंडुगुंक वातोरव्टेटाल इव गटनां तेळियवोन निमे वरोने मंतिना?” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","अस्‍के येसु, “बव पोल्‍लें आंदुं?” इंचि पूसकीतस्‍के ओर इल्‍हा वेहालय दल्‍गतुर. “नासरेत नाटेना येसुना बारेमता पोल्‍लें आंदुं दादा. ओर इसंटा मनकल मत्‍तोर गदा, ओर बतल वेहिना, बतल किय्‍यिना पेनदा ताकततोने कियुंदुर. ओर पेनदा कबुरतोर मत्‍तोर. लोकुल्‍कगुडा ओन बेसतोर इंचि इनुंदुर. ");
INSERT INTO esg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","गानि मावा पेद्‍दा पेर्मालोर, अदिकारिल्‍क ओन्क हामुर सिक्‍सा हियमळ गावाले इंचि ओन पीसि पिलातुसना कय्‍दे हीतुर. पजा लोकुल्‍क ओन क्रुसुनपोर्रो मोल्‍लां कोह्‍किसि हव्कतुर. ");
INSERT INTO esg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","गानि इस्राएल लोकुल्‍कुन पगातोरा कयदाल ओरे होळसियानुर इंचि मोमोट आसे पळतोम. इव अन्‍नि गटनां हन्‍नेट रोजे जर्गतां.” ");
INSERT INTO esg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“अचोने आयका मावाव्टेटाल इच्‍चुं मुर्ताह्कगुडा माकुन इचंत्रमते अरहतां. अव इय्याला हक्‍केरेन बोंदातगा होंचि मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","गानि अगा अवुंक येसुना पीनगु दिसा हिल्‍ले. अदुनहाटीं अव मल्सि वासि, माकु पेनदा दूतां दिसतां, अव माकु येसु जीवाते तेदतोर, इंचि वेहतां, इंचेके अव मुर्ताह्क माकु वेहतां. ");
INSERT INTO esg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","अवुना पोल्‍लें केंजसि मातोनि मत्‍तोर इच्‍चुर बोंदातगा होंचि हूळतुर. अय्ते अव मुर्ताह्क बल्हा वेहतांगो अल्हेन मत्‍ता, येसु अगा मनाहिल्‍लोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","अस्‍के येसु ओर्कुन, “अरे बुद्‍दि तक्‍को लोकुरिटा, पेनदा कबुरतोर मुन्‍ने वेहचि मत्‍ता पोल्‍लेन मिमेट बस्के नम्मंतिर? ");
INSERT INTO esg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","पेन लोहता पिसागोटना किरिस्‍तु स्वर्गमता महिमाते होळियका मुन्‍ने ओर इवन्‍नि तकलिप बोगांचेपींता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","पजा, मूसाना नियमते, अंटोर पेनदा कबुरतोर रासता पोल्‍लेने, अल्‍हेने दर्मसास्‍त्रमते ओना बारेमते बगा-बगा रासि मंतानो अवुनंता येसु ओर्कु बेस तेळियानाल वेहतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","पजा ओर्क होनना मत्‍ता नाटुक दग्‍गेर एवतुर. अस्‍के येसुंक इंकिच्‍चो मुन्‍नेळ्‍क होनानद मंता इत्‍ताप ओर्क अन्‍पिस्‍ता. ");
INSERT INTO esg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","अदुनहाटीं ओर ओन, “इंदके पोळ्‍द होत्‍ता, इय्याला निमे इगेन महगा आगा दादा!” इंचि वेल्‍लेन विनंति कीतुर. अस्‍के येसु ओरगा मननाहाटीं ओरतोनि लोप्पो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","पजा येसु ओरतोनि कलियसि गाटो तिनालय उदतस्‍के, हारितुन पीसि पेनदुक दन्यवाद कीतोर. पजा दान तुकडां कीसि ओर्क हियालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","अल्हा हारि तुकडां हियानेंकेन ओरा इव्वुरा कळ्‍क जग्गरा आतां आनि ईर येसु आंदुर इंचि एरपाट कीतुर. गानि येसु ओर्क दिसाकोंटा मायम आतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","पजा ओर इव्वुर ओरद-ओरे, “हरपीसि मनातोनि वळकसेके ताकानेंके ओर मनाकु दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍लेना निजम अर्तमतुन बेस तेळियानाल वेहतोर. अस्‍के ओना पोल्‍लें केंजसि बच्‍चोन बेस अनपिच्‍चेक मत्‍ता!” इंचेके वळ्‍ककुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","पजा ओर अगटाल बिराना तेदसि मर्रा तिरियसि येरुसलेम होत्‍तुर. होत्‍तस्के अगा पदाकोंडु मंदि प्रेरितुल्क अल्‍हेने कळमता लोकुल्‍क उंदगा जमा आसि मत्‍तद ओर हूळतुर. ");
INSERT INTO esg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","अस्‍के आ जमातोर, “हो, इद निजमे! येसु सामि जीवाते तेदतोर. ओर सिमोन पत्रुंक दिसतोर,” इंचि वळकसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","अस्‍के ओर इव्वुरगुडा हरपीसि होननेंके बतल-बतल जर्गता, इंका येसु हारितुन उराहचि ओर्क हियनेंके ओर येसुन बल्हा एरपाट कीतुर, इदंता अंटोर्क वेहतुर. ");
INSERT INTO esg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ओर इव्वुर इव पोल्‍लें अंटोर्क वेहचेकेन मत्‍तुर, अच्‍चोटेन येसु ओरा नड्‍डुम वासि निलतोर. निल्‍सि, “मीकु अंटोर्क सांति दोर्कि,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","अस्‍के ओर अंटोर, ‘मोमोट बूतमतुन हूळसंतोम,’ इन्कुंचि इरगा वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","गानि येसु ओर्कुन, “मिमेट इच्‍चोन बारि वेरियतिर? मीवा मनसुने नावा बारेमते अनमानम बारि वाता? ");
INSERT INTO esg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","नावा कय्‍क-काल्‍कुन हुळाट! नाकुन इट्‍टिस हुळाट, ननाने आंदुन! बूतमकु हव्‍विं-बोक्‍कां मन्‍नों गानि नाकु मंतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","इल्‍हा वळकसेके येसु ओना कय्‍क-काल्‍कुन ओर्क हुपिस्तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","अस्‍के ओर वेल्‍लेन कुसिते, इल्‍हा बल्हा आता इंचेके इचंत्रम आसि ओर्क पुरागा विस्वासमगुडा आसेके मनाहिल्‍ले. येसु ओर्कुन अल्हा हूळसि, “मिहगा बतलन्‍ना तिनालय मंतना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","अस्‍के ओर ओन्क उंदि बोळस्ता जिम्मा तुकडा हीतुर. ");
INSERT INTO esg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","पजा येसु अद तुकडातुन ओरा मुन्‍नेन तित्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","तित्‍तारित्‍ते येसु ओर्कु, “इव पोल्‍लें बव इत्‍ते, नाकुन हव्कका मुन्‍ने नना मीवातोनि मत्‍तन, अस्‍के मीकु वेहतव आंदुं. मूसाना नियमते, पेनदा कबुरतोरा पुस्तकाल्कुने आनि बजन संहिताने रासि मत्‍ता अन्‍नि पोल्‍लें निजम आयनदे मत्‍ता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","पजा दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍लें तेळियना इंचि येसु ओर्क तेल्वि हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","हीसि ओर्कुन इल्‍हा इत्‍तोर. “दर्मसास्‍त्रमते रासि मत्‍ताप, किरिस्‍तुंक वेल्‍लेन तकलिपकु वासि ओर हायानुर, पजा मूड रोजकुने मर्रा जीवाते तेदानुर इद अदे पोल्‍ले आंद. ");
INSERT INTO esg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","पापाल्क मापि आयनाहाटीं मनसु मार्सकुनुळ अव्‍सरम मंता. इदे कबुरतुन येरुसलेमताल सुरुव कीसि, दुनियाता अन्‍नि देसेल्‍कुना लोकुल्‍कुंक किरिस्‍तुना अदिकारमते वेहमळ जरगार. ");
INSERT INTO esg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","इव अन्‍नि पोल्‍लेंक मिमेटे गवाइ मंतिर. ");
INSERT INTO esg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","इंका नावा पेनबाबाल हींतन इंचि पोल्‍ले हीता आ पवित्र आत्मातुन नना मिहगा लोहांतन. गानि बदवेरदाका अय्ते स्वर्गमताल पवित्र आत्माता ताकत मीपोर्रो रेय्योनो, अदवेरदाका मिमेट इदे येरुसलेम सहरते मंटु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","पजा येसु ओर्कुन येरुसलेम सहर दग्‍गेरा मनना बेतानि इनना नाटाहेके ओतोर. ओसि ओर ओना कय तेहचि ओर्कु आसिर्वाद हीतोर. ");
INSERT INTO esg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ओर्क आसिर्वाद हियानेंकेन येसु ओरागटाल लक्‍कु आतोर. पजा ओन पेन स्वर्गमते तेहाचि ओता. ");
INSERT INTO esg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","अस्‍के ओर अंटोर येसुंक टोंगरां ऊनसि, मोळ्‍किसि अगटाल वेल्‍लेन कुसिते येरुसलेम सहर मल्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","पजा ओर बस्केळक गुळिते जमा आसि पेनदा स्‍तुति कीसेके मनुंदुर.");
INSERT INTO esg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","बतले पुट्‍टका मुन्‍ने पोल्‍ले मत्‍ता. आ पोल्‍ले पेनतोनि मत्‍ता. आ पोल्‍ले पेन आंद. ");
INSERT INTO esg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","आ पोल्‍ले मुन्‍नेटाले पेनतोनि कलियसि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","दुनियाते मननव अन्‍निटवुन, पेन अदुनहेंदाले पुटिस्ता. अदुन होळसि बतले तयार आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","अदुन लोप्पो पिस्वर मत्‍ता. आ पिस्वरे अंटोर लोकुल्‍कुनाहाटीं वेलगु आता. ");
INSERT INTO esg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","आ वेलगु हीकटते एल्‍गंता. हीकट वेल्‍गुन बस्‍केने गेल्सा परो. ");
INSERT INTO esg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","पेन वरोर कबुरतोन लोहता, ओन पोरोल योहान. ");
INSERT INTO esg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","आ वेलगुना बारेमते ओर गवाइ वेहतस्के ओना पोल्‍ले केंजसि, अंटोर लोकुल्‍क आ वेल्‍गुनपोर्रो विस्वासम कियना, इंचि ओर वेहालय वातोर. ");
INSERT INTO esg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","आ वेलगु योहान आयोर. गानि लोकुल्‍कुंक आ वेलगुना बारेमते गवाइ वेहालय योहान वातोर. ");
INSERT INTO esg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","हरेक मनकंक निजमाता वेलगु हियानोर, इद दुनियाते वासेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ओर इद दुनियातेन मत्‍तोर. ओनाहेंदाले पेन ई दुनियातुन पुटिस्ता. गानि ई दुनिया ओन एरपाट किया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ओर ओना लोकुल्‍कुनेन वातोर, गानि कुद्‍दु ओना लोकुल्‍के ओन ओप्कुना हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","गानि बोर अय्ते ओन ओप्‍कुंचि ओना पोरोल पोर्रो विस्वासम कीतुरो, ओर्क अंटोर्क पेनदा मर्क-मियाह्क आयना अदिकारम ओर हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","पेनदा मर्क-मियाह्क आयमळ इत्‍ते मनकना पीटाल, मनकना इच्‍चा मत्‍ताप पुटमळ, मुय्दोना इच्‍चा मत्‍ताप पुटमळ आयो. गानि पेने ओर्कुन दाना संतानम कीकुंता. ");
INSERT INTO esg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","आ पोल्‍ले मनकना रूपमते मारियता. अद कुर्पा, सत्‍तेमतोनि पुरागा निंडिस मना नड्‍डुम जेगा आता. मोमोट महिमातुन हूळतोम. अद महिमा बाबाना वरोरे मर्रिना महिमालेसीं मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ओना बारेमते योहान, “नावा पज्जोटाल बोर अय्ते वायनद मत्‍तोर, ओर ईरे आंदुर. ओर नाकन्‍ना वेल्‍लेन मुन्‍नेटाल मत्‍तोर इंचि नाकन्‍ना ओर वेल्‍लेन पेद्‍दोड,” इल्‍हा लोकुल्‍कुंक लगांचि मोत्‍कुंचेके गवाइ वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ओर अन्‍नि तीरकुने पुरागा मत्‍ताहेंका, ओनहेंदाल मनाकु अंटोर्क कुर्पाता आसिर्वाद पोर्रो आसिर्वाद दोर्कता. ");
INSERT INTO esg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","मूसाल इनानोनहेंदाल पेन मनाकु नियमाल्‍क हीता. गानि कुर्पा, सत्‍तेम मनाकु येसु किरिस्‍तुनाहेंदाल दोर्कता. ");
INSERT INTO esg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","पेनदुन बस्‍केने बोरे हूळा हिल्‍लुर. गानि पेनबाबाना संकाते मनना ओना वरोरे मर्रि, ओरे मनाकु ओन हुपिस्तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","“निमे बोन आंदिन?” इंचि योहानुन पूसकियालय येरुसलेम सहरते मनना यहुदि पेद्‍दाल्क, इच्‍चुर पेर्मालोर्कुन आनि लेवि जातितोर्कुन, ओनगा लोहतस्के योहानुना गवाइ इल्‍हा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","अस्‍के, “नना किरिस्‍तुन आयोन,” इंचि योहान पोल्‍ले मक्‍साकोंटा कबुल कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","अस्‍के पेर्मालोर्क आनि लेवि जातितोर, “अय्ते निमे एलियन आंदिना?” इंचि पूसकीतस्‍के, “नना एलियागुडा आयोन,” इंचि योहान इत्‍तोर. अस्‍के ओर, “हिलाकोंटे निमे पेनदा कबुरतोना?” इंचि इत्‍तस्के, “नना पेनदा कबुरतोनिंका आयोन,” इंचि योहान इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","पजा ओर लोकुल्‍क ओन मर्रा, “अय्ते मरि निमे बोन आंदिन? माकुन लोहतोर्कुंक मोमोट होंचि बतल वेहकोम? अदुनहाटीं नीवा बारेमते निमे बतल वेहकुंतिन, माकु वेहा,” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","अस्‍के, यसायाह इनना पेनदा कबुरतोर मुन्‍ने वेहताप, “सामिनाहाटीं सवरटा हर्रि तयार कीम्‍टु, इंचि केडाते मोत्‍कुनानोना अल्किरतुन ननाने आंदुन,” इंचि योहान ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","योहानुन पूसकियालय वाता परिसि लोकुल्‍क, “निमे किरिस्‍तुन आयिन, एलियन आयिन, पेनदा कबुरतोनगुडा आयिन. असोंटस्के निमे लोकुल्‍कुंक बारि बापतिस्मा हीसंतिन?” इंचि योहानुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","अस्‍के योहान, “नना अय्ते बापतिस्मा एततोनि हींतन. गानि इगे मीवा नड्‍डुम वरोर नित्‍तिसि मंतोर, ओन मात्रम मिमेट एरपाट किय्‍यिर. ");
INSERT INTO esg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","नावा पज्जोटाल वायानोना कादा हेरपुमता नोंडे लेहना विलुवागुडा नाकु हिल्‍ले,” इंचि योहान जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","इवन्‍नि गटनां योर्दन बेरेटा हब्बेर, पोळ्‍द पेय्सनेंके मनना बेतानि इनना नाटे जर्गतां. अगा योहान बापतिस्मा हियुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","इंकुंदि रोजु योहान, येसु ओनाहेके वायनद हूळसि, “अद हुळाट, दुनियातुन पापमता सिक्‍साताल तप्‍सानाहाटीं मोक्‍कु आयाना पेनदा गोर्रे पोरिनसंटोर! ");
INSERT INTO esg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","नना दीनकन्‍ना मुन्‍ने वेहचि मत्‍तन गदा, नावा पज्जोटाल वरोर वायाना मंतोर इंचि! अद ईना बारेमतेन आंद. ओर नाकन्‍ना वेल्‍लेन मुन्‍नेटाल मत्‍तोर, अदुनहाटीं ओर नाकन्‍ना पेद्‍दोड आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ओर बोर आंदुर कुद्‍दु नाके तेळियो. गानि इस्राएलता लोकुल्‍कुंक ओर दिसगोम, इंचि नना एततोनि बापतिस्मा हियालय वातन,” इंचि योहान इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","मर्रा योहान येसुना बारेमते इल्‍हा गवाइ वेहालय दल्‍गतोर, “नना कुद्‍दु ओन एरपाट कियाकोंदुन. गानि एततोनि बापतिस्मा हियालय नाकुन लोहता पेने नाकु वेहचि मत्‍ता, ‘पवित्र आत्मा पावरेम पिट्‍टे लेह्का आसि बोनपोर्रो अय्ते रेयनेंके निमे हूळंतिन, ओरे लोकुल्‍कुंक पवित्र आत्माते बापतिस्मा हियानोर आंदुर,’ इंचि. पवित्र आत्मा पावरेम पिट्‍टे लेह्का आसि स्वर्गमताल हिळु रेय्‍सि, ओनपोर्रो वासि उदतद नना हूळतन. ");
INSERT INTO esg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","इदंता नना नावा कळ्‍कुन निंडा हूळतन. अदुनहाटीं, ‘ईरे पेनदा मर्रि आंदुर,’ इंचि नना गवाइ हीसंतन,” इंचि योहान वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","इंकुंदि रोज योहान ओना सिस्युल्‍कुनाल इव्वुर सिस्युल्कुनतोनि नित्‍तिसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","अस्‍के येसु ओना दग्गेटाल होननद हूळसि, “हुळाट, पेनदा गोर्रे पोरि,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","योहान इत्‍ता पोल्‍ले केंजसि ओना इव्वुर सिस्युल्कु येसुना पज्जो होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","येसु पजोळ्क तिरियसि हूळतोर अस्‍के ओर इव्वुर ओना पज्जो वायनद हूळसि ओर्कुन, “मिमेट बतल पहकसंतिर?” इंचि पूसकीतोर. अस्‍के ओर, “रब्‍बी! निमे बगा मनांतिन?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","अस्‍के येसु ओर्कुन, “वट हूळकिर,” इत्‍तोर. ओर येसुनतोनि होंचि ओर मनना जेगातुन हूळतुर. हूळसि येसु मनना जेगातगा एवसि ओनतोनि अग्गेन मत्‍तुर. अस्‍के नुल्‍पेळतां नालुं एगसेक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","योहानुना पोल्‍ले केंजसि येसुना पज्जो होत्‍ता इव्वुर सिस्युल्‍कुनाल वरोन पोरोल अंदरियल. ई आंद्रेयल, सिमोन पत्रु इनानोना तम्मुर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","आंद्रेयल अगटाल सवरगा ओना दादल सिमोन पत्रुंक होंचि कलियतोर. कलियसि, “दादा मोमोट मेसय्यांक इत्‍ते किरिस्‍तुंक कलियतोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","पजा आंद्रेयल ओना दादल सिमोन पत्रुन येसुनगा पीसि वातोर. येसु सिमोनुन हूळसि, “निमे योहानुना मर्रि सिमोन आंदिन. गानि इंदकेटाल नीकुन केपा इत्‍ते पत्रु इंचि केयानुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","इंकुंदि रोज येसु गालिल राज्येमते होनना निरनायम एततोर. अस्‍के पिलिपुन कलियसि, “निमे ना पज्जो वा,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","पिलिप, अंदरियल आनि पत्रु ईर मुव्वुरगुडा बेतसेदा इनना सहरतोरे आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","पजा पिलिप होंचि नतेनलुंक कलियतोर. कलियसि, “बोना बारेमते अय्ते मूसाल दर्मसास्‍त्रम रासतोर आनि पेनदा कबुरतोरगुडा रासतुर, ओर माकु दोर्कतोर. ओर नासरेत नाटेना योसेप इनानोना मर्रि येसु आंदुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","अस्‍के नतेनल, “अल्हाना! नासरेततालगुडा बेसता पोल्‍लें वाया परंतंगा?” इंचि इत्‍तोर. अस्‍के पिलिपु, “अय्ते निमेन वासि हूळा!” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","येसु नतेनलुन ओनहेके वायनद हूळसि ओना बारेमते, “अद हुळाट, निजम इस्राएल मनकल. ओनालोप्‍पो बतले आबद्‍दम पोल्‍ले हिल्‍ले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","अद केंजसि नतेनल, “नना बसंटोन, बसंटोन आयोन नीकु बल्हा एर्का?” इंचि येसुन पूसकीतोर. अस्‍के येसु, “पिलिप नीकुन केयाका मुन्‍ने, निमे अंजिर मर्रा हिळु मत्‍तिन. अस्‍केन नना नीकुन हूळतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","अस्‍के नतेनल, “रब्‍बी, निमे पेनदा मर्रिन आंदिन, इस्राएलता राजान आंदिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","अस्‍के येसु, “नना नीकुन अंजिर मर्रा हिळु मन्‍नेंकेन हूळतन इंचि वेहताहेंका नाकुन नम्मुसंतिना? इंका मुन्‍ने इदुंकन्‍ना पेद्‍दे-पेद्‍दे पोल्‍लें हूळकिन,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","पजा, “हिके केंजट, नना निजम-निजम वेहासेक! स्वर्गम बैय्यरा आयानद हूळकिर, पेनदा दूतां मनकना रूपमते पुटतोना पोर्रो एक्‍कानदुन-रेयानदुन हूळकिर,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","इद जर्गुता मूडोव रोजुननाड गालिल राज्येमता काना इनना नाटे मरमिं मत्‍तां, आ मरमिने येसुना यावलगुडा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","मरमिंकु येसुन, ओना सिस्युल्कुनगुडा केय्‍सि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","मरमिने अंगुर पानकम मारतस्के, येसुना यावल, “ओरागटा अंगुर पानकम मारसोत्‍ता कोको,” इंचि येसुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","अस्‍के येसु, “यावा! निमे नाकु बारि वेहचंतिन? नना बतलन्‍ना कियना वेला इंका वाया हिल्‍ले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","पजा येसुना यावल अगा मत्‍ता जीतागाह्कुन, “ईर मीकु बतल वेहंतोरो, मिमेट अदे कीम्‍टु,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","यहुदिल्कुना सुद्‍दिकरन कियाना रिवाज कियनाहाटीं अगा बंडातोनि तयार कीतव हारुं पेरपुल्क मत्‍तां. आ उंद-उंदि पेरपु नूर (100) लीटर्कुना एर पियनलायक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","“आ पेरपुल्कुने एर निहाट,” इंचि येसु आ जीतागाह्कुंक वेहतोर. अस्‍के ओर आ पेरपुल्क सीगा निंडानाल निहातुर. ");
INSERT INTO esg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","अस्‍के येसु, “इंदके उंदि पेरपुनाल इच्‍चुर एर पीसि, ई कुळपु हियना पेद्‍दा मनकानगा ओम्टु,” इंचि आ जीतागाह्कुंक वेहतोर, अस्‍के ओर ओतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","पजा आ पेद्‍दा मनकल एतुन गिचचो उंचि हूळतोर अय्ते, अद एर पुरागा अंगुर पानकम आसि मत्‍ता. इद पानकम बोर तत्‍तोर, बगाटाल वाता इत्‍तद आ पेद्‍दा मनकंक तेळिया हिल्‍ले गानि आ जीतागाह्कुंक मात्रम एर्का मत्‍ता. पजा आ पेद्‍दा मनकल मरमिना पेडन केय्‍सि, “अंटोर अय्ते पिव्‍वर अंगुर पानकम मोट्‍टा मोदाला हींतुर. लोकुल्‍क पीरनिंडा उट्‍टारित्‍ते, पज्जोटाल सप्पटा पानकम हींतुर. गानि निमे अय्ते पिव्‍वर अंगुर पानकम इदवेरदाकागुडा मिगलिच्‍चि इरतिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","इल्‍हा येसु गालिल राज्येमता काना नाटे इचंत्रम आयना कबळ कीसि, ओना महिमातुन हुपिस्तोर. इद ओना मोट्‍टा मोदाटा चिन्‍ह आंद. अदुनहाटीं ओना सिस्युल्क ओन नम्मुतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","पजा येसु, ओना यावल, ओना तम्मुह्‍क, ओना सिस्युल्क अंटोर कलियसि कपर्नाहुम इनना सहर होत्‍तुर. ओर अंटोर अग्गेन कोन्‍नि रोजुक आगतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहुदि लोकुल्‍कुनद दाटसि होनना पंडुगु दग्गेर्क एवसि मत्‍ता. दानहाटीं येसु येरुसलेम होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","अगा होत्‍तस्के गुळिता लोप्पो, लोकुल्‍क पेनदुक मोक्‍कु हियालय कुर्रां, गोर्रें, पावरेम पिट्‍टें अमसेक दिसतुर. अचोने आयका सरकार कोत्‍तां पेनदा गुळिते वाटालय कुदरों इंचि, आ कोत्‍तां बदलांचि यहुदिल्कुना कोत्‍तां हियानोरगुडा अगा उद्‍दिस मत्‍तद येसु हूळतोर. ");
INSERT INTO esg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","हूळसि, उंदि नोंडे नोटसि पोट्‍टे तयार कीसि, गुळिताल अंटोर्कुन गेदुमतोर. गोर्रें, कुर्रन गुळिताल पलाते गेदमिसि, कोत्‍तां बदलांचानोरा बल्‍लन बोर्ला वाटसि कोत्‍तानंता लीकतोर. ");
INSERT INTO esg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","पजा पावरेल्क अम्मानोर्कुन, “इवुन इगेटाल पलाते ओम्टु, नावा पेनबाबाना लोतुन हाटुमलेह्का कियमट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","अगा जर्गतदुन हूळसि, “नीवा लोता बारेमते नावा जीवा बागा तंलाडसंता,” इंचि दर्मसास्‍त्रमते दाविद राजाल रासता पोल्‍ले ओना सिस्युल्कुंक मति वाता. ");
INSERT INTO esg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","येसु अल्हा कीतदुन हूळसि यहुदि पेद्‍दाल्क ओनगा वासि, “इल्‍हा कियना अदिकारम नीकु मंता इंचि मोमोट नम्मनाहाटीं निमे माकु बसोंटा चिन्‍ह हुपसंतिन?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","अस्‍के येसु, “इद गुळितुन कूल्हाट, नना मूड रोजकुने मर्रा निलाहंतन,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","अस्‍के यहुदि पेद्‍दाल्क, “इदु गुळितुन दोहालय नल्‍पै हारुं वर्सां दल्‍गतां. अय्ते निमे दीन मूड रोजकुने बल्हा निलाहंतिन?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","गानि येसु मात्रम ओना सतता मेंदुलता गुळिता बारेमते वळ्कतोर. ");
INSERT INTO esg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","येसु हासि मर्रा जीवाते तेदतस्‍के ओना सिस्युल्कुंक इद पोल्‍ले मति वाता. अस्‍के ओर दर्मसास्‍त्रमते रासि मत्‍तादुन आनि येसु वेहता पोल्‍लेन नम्मुतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","दाटसि होनना पंडुगुना वेलाते येसु येरुसलेम सहरते मत्‍ताहाटीं, वेल्‍लेटोर लोकुल्‍क ओर कीता अद्‍बूताल्‍क हूळसि, ओनपोर्रो विस्वासम इरतुर. ");
INSERT INTO esg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","गानि अंटोर लोकुल्‍क बोर-बसंटोर इंचि येसुंक एरपाट मत्‍ताहेंका, ओरा बारेमते येसुंक बोर गवाइ वेहना अव्‍सरम हिल्‍ले. अदुनहाटीं ओर बोरे लोकुल्‍कुन नम्मा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","परिसि लोकुल्‍कुनाल वरोर निकोदेमस इनना मनकल मत्‍तोर, ओर यहुदिल्कुना लीडर मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ओर उंदि रोजु नर्कटा वेलाक येसुंक वासि कलियतोर. कलियसि, “रब्‍बी, निमे कियना ई अद्‍बूतामाता कबाह्‍क पेनदा तोळ हिल्वा बोरे किया परोर. दीनहेंदाल निमे पेनदाहेंदाल वाता गुरुनिंचि मोमोट तेल्‍पिचकुत्‍तोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","अस्‍के येसु ओन, “नना निजम-निजम वेहासेक, बोरे आयिर, पूना रीतुने मर्रा पुट्‍टुवा, ओर पेनदा राज्येमतुन हूळा परोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","अस्‍के निकोदेमस, “गानि वरोर मातरल आता मनकल मर्रा बल्हा पुट्‍टा परंतोर? ओर ओना यावाना पीटे होळियसि मर्रा पुट्‍टा परांतोरा?” इंचि येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","अस्‍के येसु ओन्क इल्‍हा वेहतोर: “नना निजम-निजम वेहासेक, वरोर मनकल एताल आनि पवित्र आत्माहेंदाल पुट्‍टुवद, ओर पेनदा राज्येमते होळिया परोर. ");
INSERT INTO esg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","मना मेंदुल अय्ते तल्‍लुर-बाबोनहेंदाल पुट्‍टा परंता, गानि आत्मा मात्रम सिराप पवित्र आत्माहेंदाले पुट्‍टा परंता. ");
INSERT INTO esg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","अदुनहाटीं, मीकु मर्रा पुट्‍टे पींता, इंचि नना मीकु वेहतद केंजसि निमे इचंत्रम आयमा. ");
INSERT INTO esg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","बल्हा अय्ते वळि दान इस्‍टमाताप बेके इत्‍ते हेक्‍के वित्‍तंता, दाना सप्पुडगुडा नीकु केंजा वांता, गानि अद बेंदाल वासंता, बेके होंचंता इत्‍तद मात्रम नीकु तेळियो. अल्हेन पवित्र आत्माहेंदाल पुट्ता हरेक मनकलगुडा मनंतोर,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","गानि “इद बल्हा आया परंता?” इंचि निकोदेमस येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","अस्‍के येसु ओन्क इल्‍हा जवाब हीतोर, “निमे अय्ते इस्राएल लोकुल्‍कुंक कराहना पेद्‍दा गुरुन आंदिन. अयना इव पोल्‍लें नीकु तेळियोंगां? ");
INSERT INTO esg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","नना निजम-निजम वेहासेक, माकु तेळियता पोल्‍लेंगें मोमोट वेहांतोम, कळ्‍कुने हूळता पोल्‍लेना गवाइ मोमोट मीकु वेहांतोम. अयना मिमेट मावा गवाइतुन ओप्‍कुंचेक हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","नना मीकु इद दुनियाता पोल्‍लें वेहतेने मिमेट नमसेक हिल्‍लिर. अय्ते नना स्वर्गमता बारेमता पोल्‍लें वेहते मिमेट बल्हा नम्मंतिर? ");
INSERT INTO esg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","मनकना रूपमते पुट्तोन नना स्वर्गमताल वातन. इंका नाकु तप्‍पा स्वर्गमते वेरे बोरे होना हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","नाकुन बोर अय्ते विस्वासम कींतोर, ओन्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कगोम इत्‍ते, मूसाल बल्हा बय्‍लि बूमिते इत्‍तोळता तरासुन कोय्यापोर्रो वेलाड वाटसि मत्‍तोर, अल्‍हेने मनकना रूपमते पुटतोन नाकुनगुडा वेलाड वाटमळ जर्गागोम,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","पेन दुनियातोर्कुन इच्‍चोन पावरम कीता गदा, दाना वरोरे मर्रिनगुडा ई दुनियातोराहाटीं हीता. ओन नम्मना हरेक मनकल नासडेम आयामन्‍नि गानि ओन्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कना इंचि अद अल्हा कीता. ");
INSERT INTO esg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","पेन ई दुनियातोर्क सिक्‍सा हिया वेहालय, दाना मर्रिन ई बूमिपोर्रो लोहा हिल्‍ले, गानि दुनियातोर्कुन पिसागोटालय ओन लोहचीता. ");
INSERT INTO esg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ओन बोर अय्ते नम्मंतुरो, ओर्क ओर सिक्‍सा हिया वेहोर. गानि बोर अय्ते ओन नम्मुरो, पेनदा वरोरे मर्रिनपोर्रो विस्वासम कियवाहेंका ओर्क पेन मुन्‍नेन सिक्‍सा हीसि इरता. ");
INSERT INTO esg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","पेन मुन्‍नेन बारि सिक्‍सा हीसि इरता इत्‍ते, पेनदाहेंदाल उंदि वेलगु दुनियाते वाता. गानि दुनियातोर ओरा तप्‍पुड कबाह्कुनहेंका वेलगुने पिसनद होळसि हीकटते पिसमळतुने मेच्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","तप्‍पुड हरदे ताकाना बोरे मनकल आयि, ओर वेलगुन मेच्‍कुन्‍नोर. ओना तप्‍पुड कबाह्‍क बय्यर दिस अर्रंतां इंचि ओर वेलगुने वायोर. ");
INSERT INTO esg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","गानि सत्‍तेम हरदे ताकाना मनकल, ओर कियना कबाह्‍क पेनदा सहायमते आसंतां इनकुंचि अव अंटोर्क बय्यर दिस्‍सनाहाटीं ओर वेलगुने वांतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ई पोल्‍लें मारतस्के, येसु, ओना सिस्युल्कु अगटाल यहुदिया राज्येमते होत्‍तुर. होंचि अगाटा लोकुल्‍कुंक बापतिस्मा हीसेक कोन्‍नि रोजकु अग्गेन मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","सलिम इनना नाटेंक दग्‍गेरा मनना एनोन पोरोलता जेगाते वेल्‍लेन एर मत्‍ताहेंका, योहानगुडा अगा बापतिस्मा हियुंदुर. लोकुल्‍क ओना कय्‍दे बापतिस्मा एतालय अगा वायुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ई गटनां योहानुन जेलने वाटका मुन्‍नेने जरगतां. ");
INSERT INTO esg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","अस्‍के योहानुना सिस्युल्क आनि वरोर यहुदि मनकन नड्‍डुम सुद्‍दिकरन कियाना रिवाजता बारेमते रोंड-रोंड पोल्‍लें आतां. ");
INSERT INTO esg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","दानहाटीं योहानुना सिस्युल्कु योहानुनगा वासि, “गुरु, निमे योर्दन बेरेटा हब्बेरा मननेंके नीवातोनि बोर अय्ते मत्‍तोरो, निमे बोना बारेमते अय्ते गवाइ हीसि मत्‍तिनो, ओर इंदके लोकुल्‍कुंक बापतिस्मा हीसंतोर. अंटोर लोकुल्‍क ओनहेकेन होंचंतुर,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","अय्ते योहान ओर्क इल्‍हा जवाब हीतोर, “स्वर्गमताल पेन हियवद बोनके बतल दोर्का परो. ");
INSERT INTO esg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","नना किरिस्‍तुन आयोन. नना सिराप ओनाहाटीं हर्रि तयार कियालय मुन्‍ने वातोन आंदुन. नना वेहता पोल्‍लेंक मिमेट गवाइ मंतिर! ");
INSERT INTO esg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","मरमिन पेडल मत्‍तागेन मरमिन पेगिड मनंता. नना अय्ते मरमिन पेडाना पक्‍काते निलसि मनना ओना दंटागानसंटोन आंदुन. मरमिना पेडल बतलन्‍ना वेहते अद केंजसि आ दंटागाल वेल्‍लेन कूस आंतोर. ननागुडा अल्हेन, लोकुल्‍क ओनगा होननद हूळसि नना पुरागा कुसिते निंडसोत्‍तन. ");
INSERT INTO esg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","इंदके ओना कदर वेल्‍लेन बेर्सगोम, नावा कदर वेल्‍लेन तक्‍को आयगोम अचोने!” इंचि योहान वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","बोर अय्ते पोर्रोटाल वातोर, ओर अंटोर्कुंकन्‍ना पेद्‍दोड. बोर अय्ते इद दुनियाते पुटतोर, ओर इदे दुनियातोर आंदुर. अदुनहाटीं ओर ई दुनियाते जरगानवुना बारेमतेन वळ्कंतोर. गानि बोर अय्ते स्वर्गमताल वातोर ओर अंटोर्कुंकन्‍ना पेद्‍दोड आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ओर अगा बतल अय्ते हूळतोर, केंजतोर अदुना बारेमतेन गवाइ वेहंतोर, गानि ओना गवाइतुन बोरे नम्मुर. ");
INSERT INTO esg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ओर वेहता गवाइतुन बोर अय्ते नम्मंतुरो, ओर अंटोर पेने सत्‍तेम इंचि पक्‍का कबुल कींतुर. ");
INSERT INTO esg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","बोन अय्ते पेन लोहचीता, ओन पेन दाना आत्माते पुरागा निहता. अदुनहाटीं ओर सिराप पेनदा पोल्‍लेंगें वेहांतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पेन बाबल ओना मर्रिन इरगा पावरम कींतोर, इंचि मर्रिना कय्‍दुक अन्‍नि अप्पजेपतोर. ");
INSERT INTO esg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","पेनदा मर्रिन बोर अय्ते नम्मंतुरो, ओर्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कंता. गानि बोर अय्ते मर्रिना पोल्‍ले केंजुरो, ओर्क बस्‍केळ्‍क पिस्सना पिस्वर अय्ते दोर्केन दोर्को, गानि ओनपोर्रो पेन होंग पीसि मनंता. ");
INSERT INTO esg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","येसु योहानुंकन्‍ना एक्‍को मंदिक बापतिस्मा हीसंतोर, योहानुंकन्‍ना एक्‍को मंदितुन ओना सिस्युल्क कीसंतोर, इंचि परिसिल्कुंक तेळियता. ");
INSERT INTO esg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(निजम हूळते, येसु कुद्‍दु बापतिस्मा हियाकोंदुर, ओना सिस्युल्क बापतिस्मा हियुंदुर.) ");
INSERT INTO esg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","इद पोल्‍ले सामिंक तेळियतस्के ओर यहुदिया राज्येमतुन होळसि, मर्रा गालिल राज्येम होनालय पेय्सतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","गानि इंदके ओन्क सामरिया इनना राज्येमताल होनापीता. ");
INSERT INTO esg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","इल्‍हा येसु सामरिया राज्येमते मनना सुकर इनना सहरते एवतोर. ई सुकर सहर, एनकटा यहुदिल्कुना मातिर दादल याकोब ओना मर्रि योसेपुंक हीता जेगाक दग्‍गेरा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","अगा याकोबुना कुहि मत्‍ता. वेल्‍लेन लक्‍कुनाल ताकसि वाताहेंका नेरबळसि येसु, आ कुहिता पक्‍काते उद्तोर. अस्केळ्क पिय्यल आसि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","अस्‍के तिननाहाटीं बतलन्‍ना तर्रालय येसुना सिस्युल्क नाटेंक होंचि मत्‍तुर. अदे वेलाते उंदि सामरिया मुरतळ एतुक वाता. अय्ते येसु, “उनालय नाकु इच्‍चो एर हीम,” इंचि अद मुरतटुन तल्कतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","अस्‍के अद मुरतळ, “निमे यहुदिन आसिगुडा, उंदि सामरिया मुरतटुन, उनालय एर हीम, इंचेके बल्हा तल्कसंतिन?” इंचि इत्‍ता. (यहुदिल्क सामरिया लोकुल्‍कुनतोनि बदे संबंदम इर्रकोंदुर. अदुनहाटीं अद अल्हा इत्‍ता.) ");
INSERT INTO esg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","अस्‍के येसु, “ओक्‍कला निमे, पेनदा वरमतुन आनि उनालय एर हीम इंचि नीकुन तल्कानोर बोर आंदुरो, एरपाट कीसि मत्‍ते, निमेने कुद्‍दु नाकुन एर तल्किस मन्‍नेन, अस्‍के नना नीकु पिस्वर हियना एर हीसि मन्‍नेन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","अस्‍के आ मुरतळ, “कुहि अय्ते वेल्‍लेन लोतु मंता महाराज. निहगा एर तोरालय बाल्टिगुडा हिल्‍ले. इसोंटस्के ई पिस्वर हियना एर नीकु बल्हा दोर्कार? ");
INSERT INTO esg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","माकु ई कुहि मावा मातिर दादल याकोब हीतोर. ई कुहिता एर ओर कुद्‍दु उनुंदुर, इंका ओना मर्क, एटिं, गोळ्कु-गोदां उनुंदुं. अय्ते निमे ओनकन्‍ना पेद्‍दोना?” इंचि पूसकीता. ");
INSERT INTO esg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","अय्ते येसु, “ई एतुन उनना हरेक मनकंक मर्रा तप्‍पाकोंटा दूपांता. ");
INSERT INTO esg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","गानि नना हियना एतुन बोर अय्ते उंटोरो, ओन्क मर्रा बस्‍केने दूपायो. नना हीता एर ओनालोप्‍पो बस्‍केळ्‍क ऊरसेके मनना ऊटालेसीं मारियसि, ओन्क बस्‍केळ्‍क पिस्सना पिस्वरतुन हिय्यार,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","अय्ते अद मुरतळ, “अल्हा अय्ते अद एर नाकु हीम महाराज! अद एतुन नना उट्‍टुनित्‍ते नाकु बस्‍केने दूपा आयो, नाकु मर्रा बस्‍केने एर ओयालय इच्‍चोर लक्‍कु वायना अव्‍सरमगुडा मन्‍नो,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","अस्‍के येसु दान, “होन, होंचि नीवा मुय्दोन केय्‍सि तरा होन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","अस्‍के अद, “नाकु मुय्दो हिल्‍लोर,” इंचि इत्‍तस्के येसु, “निमे निजमे वेहतिन! नीकु मुय्दो हिल्‍लोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","पजा येसु, “अद बल्हा इत्‍ते, नीकु हेय्युर मुय्दुर मत्‍तुर, निमे इंदके बोनतोनि अय्ते मंचंतिनो ओरगुडा नीवा मुय्दो आयोर. अदुनहाटीं निमे निजम वेहतिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","अस्‍के अद मुरतळ, “महाराज, नीवा पोल्‍लें केंजसि नाक अय्ते, निमे पेनदा कबुरतोन आंदिन इंचि नाकु तेळियता. ");
INSERT INTO esg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","मावा एनकटा पेद्‍दाल्क इदे गुट्‍टापोर्रो मोळ्‍कुंदुर. गानि मिमेट बारे, मोळ्‍कना असल जेगा येरुसलेमे आंदु इंतिर,” इंचि अद मुरतळ येसुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","अस्‍के येसु दान्क इल्‍हा वेहतोर: “बाई नाकुन नम्मा! पेनबाबांक मोळ्‍कनाहाटीं इद गुट्‍टातगा हिलाकोंटे येरुसलेम सहर होनना अव्‍सरम हिल्‍ले, मिमेट बगानना मोळ्‍का परंतिट, इसोंटा वेला मुन्‍ने वासेक मंता. ");
INSERT INTO esg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","मिमेट सामरिया राज्येमतोर मीकु तेळियवादान मोळ्‍कंतिर. गानि मुक्‍ति यहुदिल्कुनाहेंदाले वासेक मंता. अदुनहाटीं मोमोट यहुदिल्क अय्ते माकु तेळियतदुने मोळ्‍कंतोम. ");
INSERT INTO esg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","गानि पेनदुन निजम मोळ्‍कानोर पेनदा सत्‍तेमतुन एरपाट कीसि ओर पेनदा आत्माते मोळ्‍कना वेला मुन्‍ने वासेक मंता. आनि अद वेला एव्‍से मंतां. बारित्‍ते इल्‍हा मोळ्‍कानोर्कुने पेन मेच्‍कुंता. ");
INSERT INTO esg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","पेन आत्मा रूपमते मंता. अदुनहाटीं दान मोळ्‍कानोर अंटोरगुडा आत्माते, सत्‍तेमते मोळ्‍कना,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","पजा अद मुरतळ, “किरिस्‍तु इनना मेसय्याल वासेक मंतोर इंचि नाकु एरपाटे. ओर वातस्के माकु अंटोर्क अन्‍नि पोल्‍लें वेहानुर,” इंचि येसुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","अस्‍के, “नीतोनि वळ्‍कानोन, ननाने ओन आंदुन,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","अच्‍चोटेन अगा ओना सिस्युल्क वातुर. येसु उंदि मुरतळतोनि वळकानद हूळसि ओर्क वेल्‍ले इचंत्रम आता. अय्नागानि बोरे ओन, “नीकु बतल गावाले? दानतोनि निमे बारि वळ्‍कसंतिन?” इंचिगुडा इना हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","अस्‍के अद मुरतळ अळकातुन अग्गेन होळसि नाटे होंचि लोकुल्‍कुंक वेहता. ");
INSERT INTO esg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“इदवेरादाका नना कीतव अन्‍निना बारेमते वरोर मनकल वेहतोर. ओरे किरिस्‍तु बारे, मिमेट वासि हुळट!” इंचि नाटेनोर्कुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","अस्‍के नाटेनोर नाटुन होळसि येसु मत्‍ता जेगातगा वातुर. ");
INSERT INTO esg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","अद मुरतळ नाटे होत्‍तस्के, सिस्युल्क, “गिचचो तिन रब्‍बी!” इंचि येसुन विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","गानि येसु, “नहगा तिनालय इसंटा तिंडि मंता गदा, अद तिंडिता बारेमते मीकु बतले तेळियो,” इंचि सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","अस्‍के सिस्युल्क, “गुरुनाहाटीं बोरन्‍ना तिनालय बतलन्‍ना तत्‍तुरा?” इंचि ओरद-ओरे वळ्ककुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","अस्‍के येसु ओर्क इल्‍हा वेहतोर: “नाकुन लोहतोना इच्‍चा मत्‍ताप ताकमळ, ओर वेहता कबाह्‍कुन पूरा कियमळ, इदे नावा तिंडि आंद. ");
INSERT INTO esg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","वंजि वीतता पजा, इंका नालुं नेल्क अय्ते वंजि कोताक वांता, इंचि मिमेट इंतिर. गानि नना वेहनद केंजट, कळ्‍क विच्‍चि पोलमतेके बेस हुळट, पंटा कोताक वासि मंता. ");
INSERT INTO esg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","पंटा कोय्‍यानोर बूति दोर्किच्‍कुंचेक मंतोर आनि बस्‍केळ्‍क पिस्सना पिस्वरताहाटीं पलम जमा कीसेक मंतोर. दीनहेंदाल वीततोर, कोय्‍यानोर इव्वुरगुडा कुसिते कलियसि मना परांतुर. ");
INSERT INTO esg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","वरोर वीतंतोर, इंकावरोर कोय्‍यंतोर इनना वेसुड इगे निजम आंता. ");
INSERT INTO esg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","बोरो वेरेतोर कस्‍टपळसि पंडिस्ता पंटातुन कोय्‍यालय नना मीकुन लोहतन. मिमेट कस्‍टपळा हिल्‍लिर, गानि ओर कीता कस्‍टमता पायदा मीकु दोर्कसंता,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“नना कीतव अन्‍निना बारेमते वरोर मनकल नाकु वेहतोर,” इंचि वेहता, आ मुरतटा गवाइतुन केंजसि, अद नाटेना वेल्‍लेन मंदि सामरिया लोकुल्‍क, येसुनपोर्रो विस्वासम इरतुर. ");
INSERT INTO esg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","सामरिया लोकुल्‍क येसुनगा वासि, “निमे महगा मन्‍नु,” इंचि विनंति कीताहेंके, येसु रोंड रोजकु अगा आगतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","येसु कराहता पोल्‍लें केंजसि इंका वेल्‍लेन लोकुल्‍क ओन विस्वासम कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","“सिराप निमे वेहताहेंकेन मोमोट येसुन नम्मा हिल्‍लोम. इंदके कुद्‍दु मोमोटे ओना पोल्‍ले केंजसि, दुनियातोर्कुन पिसागोटना निजम किरिस्‍तु ईरे आंदुर इंचि मोमोट विस्वासम कीतोम,” इंचि आ लोकुल्‍क मुरतटुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","रोंड रोजकु आतंका, येसु अगटाल गालिल राज्येमते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","पेनदा कबुरतोंक ओना सतता देसेमते कदर दोर्को, इंचेके येसु मुन्‍नेने वेहचि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","दाटसि होनना पंडुगुनाहाटीं गालिल राज्येमता लोकुल्‍कगुडा येरुसलेम होंचि मत्‍तुर. अगा येसु कीतव अन्‍नि कबाह्‍कुन ओर हूळतुर. अदुनहाटीं येसु गालिल राज्येमते वातस्के ओर अंटोर येसुन बेस दग्‍गेरा कीकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","बद नाटे अय्ते येसु एतुन अंगुर पानकम कीतोर, अदे काना नाटे ओर मर्रा होत्‍तोर. गालिल राज्येमता कपर्नाहुम इनना नाटे, राजाना हिळु कबळ कियाना वरोर सायाबुना मर्रि बिमार अरसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","अय्ते यहुदिया राज्येमताल गालिल राज्येमते येसु वातोर इंचि ओन्क कबुर तेळियताहेंका ओर येसुंक कलियालय होत्‍तोर. होंचि येसुना काल्कुनपोर्रो अरसि, “नावा मर्रि इरगा बिमार आसि हायनाल आसि मंतोर, निमे ओन बेस कियालय नातोनि ताका,” इंचि विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","अस्‍के येसु, “चिन्‍हां, इचंत्रमता कबाह्‍क हूळवद मिमेट नम्मनोर आयिर!” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","आ सायाब, “ना मर्रि हायका मुन्‍नेन निमे ताका सामि,” इंचि विनंति इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","अस्‍के, “नीवा मर्रि पिस्संतोर, निमे होन,” इंचि येसु ओन इत्‍तस्के, ओना पोल्‍लेतुन नम्मिसि ओर तिरियसि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ओर हर्रि पीसि होंचेकेन मत्‍तोर, नड्‍डुम हरदेने ओना जीतागाह्‍क कलियसि, “सायाब, नीवा मर्रि बेस आतोर,” इंचि वेहातुर. ");
INSERT INTO esg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","अस्‍के “नावा मर्रि बद वेलाक बेस आतोर?” इंचि ओर्कुन पूसकीतोर. “निन्‍ने पिय्यल उंद एगनेंके ओना एळ्कि रेय्ता सायाब!” इंचि ओर वेहतुर. ");
INSERT INTO esg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","अस्‍के आ सायाब ओर वेहतद केंजसि, बद वेलाते येसु, “नी मर्रि पिस्संतोर,” इंचि इत्‍तोरो, अदे वेलाते ओना मर्रि बेस आतोर, इंचि ओन्क तेळियसोत्‍ता. अदुनहाटीं ओर, ओना लोतोर अंटोर येसुन नम्मुकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यहुदियाताल गालिलते वासि येसु कीतद इद रोंडो इचंत्रमायना चिन्‍हे आंद. ");
INSERT INTO esg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","पजा येसु यहुदिल्कुना उंदि पंडुगुनाहाटीं येरुसलेम सहर होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","येरुसलेम सहरते गोर्रे दरबाजा इनना जेगातगा उंदि सेरवु मंता, दान इब्रानि बासाते बेतेस्‍दा इंचि इंतुर. आ सेरवुना ओड्‍डुंक हेय्युं गुडसें वाटसि मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","बदो उंदि वेलाते पेनदा दूता वासि अद एतुन लोपुंदु, अल्हा लोपतस्के, अद एते बोर मनकल अय्ते मुन्‍ने होळियंतोरो ओर मनकल ओना बसोंटा बिमार अयना बेस आयुंदु. अदुनहाटीं पेनदा दूता एतुन बस्के लोपार इंचि एदुर हूळसेक गुड्‍डोर्कु, गूनोर्क, कुंटोर्क, लकवा बिमारतोर इल्‍हा वेल्‍लेन मंदि आ गुडसेने जेगा पीसि मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","अगा मत्‍तोरव्टे मुप्‍पै एनिमिदि वर्सानाल बिमार मत्‍ता वरोर मनकल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ओर अगा मींडसि मत्‍तद येसु हूळतोर. हूळसि ओर वेल्‍लेन वर्सानाल कुक्‍कि पीसि मत्‍तद एरपाट कीसि ओनगा होत्‍तोर. होंचि ओन, “नीकु बिमारताल बेस आयानद मंतना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","अस्‍के आ मनकल, “नाकु बेस आयगोम इंचि मंता सामि! गानि बतल कीकन? एतुन लोपतस्के नाकुन आ एतगा ओयालय नहगा बोरे हिल्‍लुर. एतुन लोपतस्के मेल्‍लगा-मेल्‍लगा नना होननदाका बोरन्‍ना वरोर नाकन्‍ना मुन्‍नेन होळियंतोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","अस्‍के येसु ओन, “अय्ते तेदा! तेदसि नीवा कटुल पीसि ताकसेक होन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","येसु ओन अल्हा इत्‍ता इन्‍मळे आ मनकल बेस आतोर. आसि, ओना कटुल पीसि ताकसेक होत्‍तोर. इद गटना यहुदिल्कुना नोमकेम रोजुननाड जर्गता. ");
INSERT INTO esg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","अदुनहाटीं बिमारताल बेस आता मनकन, “नोमकेम रोजुने निमे इल्‍हा कटुल तेहचि ताकमळ मावा दर्मसास्‍त्रम परकारम न्‍यायम आयो,” इंचि यहुदि पेद्‍दाल्क इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","जवाबुने आ मनकल, “नाकुन बेस कीतोरे, नाकुन नीवा कटुल पीसि ताकसि होन इत्‍तोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","अस्‍के “नीकुन कटुल पीसि ताका इंचि वेहतोर, ओर बोर आंदुर?” इंचि यहुदि पेद्‍दाल्क ओन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","गानि अगा वेल्‍लेन मंदि मत्‍तुर, येसुगुडा अगटाल पेय्सि होत्‍तोर. अदुनहाटीं ओन बेस कीतोर बोर आंदुर इंचि, आ बेस आता मनकंकगुडा तेळिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","इदंता आतंका येसु आ मनकंक गुळिते कलियसि, “हूळा, निमे इंदके बेस आतिन! मर्रा पापि कबाह्‍कुना जोलिक होन्‍मा. होत्‍तिनित्‍ते दीनकन्‍ना एक्‍को बिमार अर्रंतिन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","पजा आ मनकल यहुदिल्कुना पेद्‍दाल्कुंक कलियसि, “नाकुन बिमारताल बेस कीतोर, येसु आंदुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","येसु इसोंटा कबाह्‍क नोमकेम रोजुननाड कीतोर इंचि यहुदि पेद्‍दाल्क येसुन तकलिप कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","अस्‍के येसु ओर्कुन, “ना बाबाल बस्‍केळ्‍क कबळ कीसेकेने मनंतोर. अदुनहाटीं ननागुडा कबळ कीसेकेने मनंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","येसु इल्‍हा इत्‍ताहेंका यहुदि पेद्‍दाल्क ओन हव्कालय उंदे पट्‍टु पीतुर. बारित्‍ते नोमकेम रोजुने कबळ कियानायो इत्‍ता नियमतुन ओर हेळाहतोर. आनि पोर्रोटाल, पेनदुन “ना बाबाल,” इंचि वेहचि “नना पेनदुक समानमतोन” इंचि ओनद ओरे वेहकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","अस्‍के येसु ओर्क इल्‍हा वेहतोर: “नना मीकु निजम-निजम वेहचंतन, मर्रि ओनद-ओर बतले किय्योर. गानि बाबो बतल-बतल अय्ते कींतोर, बाबो कियनदुन हूळसि मर्रि अल्हेन कींतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","मर्रिनपोर्रो बाबोंक वेल्‍लेन पावरम मंता, अदुनहाटीं ओर कियानव अन्‍नि कबाह्‍कुन ओना मर्रिंक हुपिच्‍चंतोर. वायना रोजकुने इवुंकन्‍ना पेद्‍दा-पेद्‍दा कबाह्‍क कीसि मर्रिंक हुप्‍सना मंता. अस्‍के मिमेट हूळसि अंटोर इचंत्रम आकिर. ");
INSERT INTO esg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","बल्हा अय्ते बाबो हातोर्कुन मर्रा जीवाते तेहंतोरो, अल्हेन मर्रिगुडा ओन्क इस्‍टमातोर्कुन मर्रा जीवाते तेहंतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","बाबोनद अंटोर कदर कींतुर. अल्‍हेने मर्रिना कदरगुडा अंटोर लोकुल्‍क कियना इंचि बाबाल बोनदे न्‍यायम कियाकोंटा, न्‍यायम कियना पूरा अदिकारम मर्रिंक हीतोर. मर्रिना कदर बोर किय्युरो, ओर मर्रिन लोहचीता बाबाना कदरगुडा किय्युर. ");
INSERT INTO esg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","नना निजम-निजम वेहासेक, बोर अय्ते नना वेहना पोल्‍लेन केंजसि नाकुन लोहतोना पोर्रो विस्वासम इर्रंतोर, ओन्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कंता. पेन ओन्क सिक्‍साता आदेस हिय्यो, ओर हामुरताल पेय्सि पिस्वरतुन संपादिंच्‍कुंतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","नना निजम-निजम वेहासेक, हासोत्‍तोरगुडा पेनदा मर्रिना अल्किर केंजना वेला वासेक मंता. अद अय्ते वासे मंता. बोर अय्ते अद अल्किरतुन केंजांतुर, ओर्क पिस्वर दोर्कार. ");
INSERT INTO esg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","बल्हा अय्ते पेनबाबाल कुद्‍दु पिस्वरता मालक आंदुर, अल्हेन मर्रिनगुडा पिस्वरता मालक कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","इच्‍चोने आयाका, पेनबाबाना मर्रि मनकना रूपमते पुटताहाटीं ओन्क लोकुल्‍कुना न्‍यायम कियना अदिकारम हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","मिमेट इदुन केंजसि इचंत्रम आयमटु. बारित्‍ते मुन्‍ने इसोंटा वेला वायनद मंता गदा, हातोर अंटोर पेनदा मर्रिना अल्किर केंजानुर. ");
INSERT INTO esg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","पजा बोर अय्ते बेस पुन्‍नेम कबाह्‍क कीतुरो ओर अंटोर बस्‍केळ्‍क पिस्सना पिस्वरहाटीं मर्रा जीवाते तेदानुर. आनि पापि कबाह्‍क कीतोर बारे सिक्‍साताहाटीं मर्रा जीवाते तेदानुर. ");
INSERT INTO esg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","नावद नना बतले किया पर्रोन. पेनबाबानाहेंदाल केंजतापे न्‍यायम कींतन. नना नावा इच्‍चातुन पूरा कियालय वाया हिल्‍लेन, नाकुन लोहचीता पेनबाबाना इच्‍चातुन पूरा कियालय वातन. अदुनहाटीं नना कियना न्‍यायम सत्‍तेम मंता.” ");
INSERT INTO esg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“नावा बारेमते ननाने गवाइ वेहकुत्‍ते, नावा गवाइ निजमतद आयो. ");
INSERT INTO esg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","गानि नावा बारेमते गवाइ वेहालय इंकावरोर मंतोर. ओर वेहना गवाइ सत्‍तेम इंचि नाक एरपाट मंता. ");
INSERT INTO esg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","मिमेट मीवा मनकालोर्कुन योहाननेके लोहतिर. ओर मीकु सत्‍तेमता गवाइ वेहतुर. ");
INSERT INTO esg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","मीकु मुक्‍ति दोर्कगोम, इंचि इव पोल्‍लें नना मीकु वेहासेक मंतन अचोने. गानि नावा बारेमते लोकुल्‍कुना गवाइता अव्‍सरम नाकु हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","योहान वेडसिलेह्का पोत्‍सि मीकु वेलगु हीतोर. मीकुगुडा गडसेमताहाटीं आ वेलगुने कूस मनालय बेस अनपिस्ता. ");
INSERT INTO esg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","गानि योहानुना गवाइकन्‍ना पेद्‍दा गवाइ नहगा मंता. बारित्‍ते पूरा कियनाहाटीं पेनबाबाल नाकु हीता कबाह्‍क आनि नना कियना कबाह्‍क. इवे पेनबाबाल नाकुन लोहतोर इत्‍तादांकु गवाइ मंतां. ");
INSERT INTO esg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","नाकुन लोहचीता पेनबाबाल कुद्‍दु नावा बारेमते गवाइ वेहतोर. गानि मिमेट बस्‍केने ओना अल्किर केंजा हिल्‍लिर, बस्‍केने ओना रूपमतुन हूळा हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","अचोने आयका ओर लोहतोना पोर्रो मिमेट विस्वासम इर्रुवाहेंका, ओर कराहता पोल्‍लें मीवा मनसुना लोप्पो मना पर्रों. ");
INSERT INTO esg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","बस्‍केळ्‍क पिस्सना पिस्वर दर्मसास्‍त्रमहेंदाल दोर्कंता इंचि मिमेट अव्टे पह्कट, अदे दर्मसास्‍त्रम नावा बारेमते गवाइ वेहचंता. ");
INSERT INTO esg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","अयना, बस्‍केळ्‍क पिस्सना पिस्वरहाटीं मिमेट नहगा वायालय हूळिर. ");
INSERT INTO esg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","नना मनकालोराहेंदाल कदर कोरोन. ");
INSERT INTO esg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","बारित्‍ते मिमेट बसंटोर आंदिरो नाकु एरपाटे. मीलोप्‍पो पेनदाहाटीं पावरम हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","नना नावा बाबाना पोरोल्ते वातन, गानि मिमेट नाकुन स्विकार किया हिल्‍लिर. गानि बोरन्‍ना वेरेतोर, ओना पोरोल्ते ओरे वायानय्ते मिमेट ओन स्विकार कींतिर. ");
INSERT INTO esg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","मीवद मिमेटे कदर कीकुनमळ इत्‍ते मीकु वेल्‍लेन इस्‍टम. गानि पेनदाहेंदाल दोर्कना कदरतुन मात्रम बोरे पहका हूळिर. असोंटस्के मिमेट नापोर्रो बल्हा विस्वासम किया परांतिर? ");
INSERT INTO esg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","बाबाना मुन्‍ने नना मीपोर्रो तप्पु दोसतन इंचि इनकुन्‍मट. मिमेट अय्ते मूसाना पोर्रो आसे पडसि मनंतिर, आ मूसाले मीवापोर्रो तप्पु दोसंतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","मिमेटगिंटा मूसान पोर्रो विस्वासम कियानय्ते, नावापोर्रो इंका विस्वासम कींतिर, बारित्‍ते मूसाल नावा बारेमते रासतोर. ");
INSERT INTO esg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","मूसाल रासता पोल्‍लेन पोर्रोगुडा मीवा विस्वासम हिल्‍ले अय्ते, नावा पोल्‍लेन मिमेट बल्हा नमकिर?” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","अद आता पजा येसु गालिल इनना समुद्रमतुन दाटसि हब्बेर ओड्‍डुंक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","बिमार मत्‍तोर्कुन बेस कीसि येसु इचंत्रम आयाना कबाह्‍क कीतोर. आ कबाह्‍कुन हूळसि, वेल्‍लेन मंदि ओना पज्जो-पज्जो वासेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","पजा येसु गुट्‍टापोर्रो एकसि, अगा ओना सिस्युल्कुनतोनि उद्तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","अव रोजकुने यहुदिल्कुना दाटसि होनना पंडुगु दग्गेर्क एवसि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","पजा येसु अगटाल हूळतोरय्ते, वेल्‍लेन मंदि ओनहेके वायनद ओन्क दिसतुर. अस्‍के, “ईरकु अंटोर्क तिनालय तिंडि मनम बगाटाल अस्सि तरकोम?” इंचि पिलिपुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","येसुंक अन्‍नि एर्के मत्‍ता गानि पिलिपुना परिक्‍सा हूळालय, ओन इसोंटा सवाल पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","अस्‍के पिलिपु, “ईराहाटीं रोंड नुह्कु एंडि रूपेना हारिं अस्सि तच्‍चि तासिना, वरो-वरोंक उंद-उंदि मुक्‍कागुडा एव्‍वा परो,” इंचि जवाब इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","अस्‍के येसुना सिस्युल्‍कुनाल वरोर सिस्युड, सिमोन पत्रुना तम्मुर अंदरियल इनानोर, “इगे वरोर सिन्‍ने पेडानगा हेय्युं जोन्‍ना हारिं, रोंड बोळ्स्ता जिम्मां मंतां, गानि इच्‍चा वेल्‍ले मंदिक इव बगा हालनूं?” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","अस्‍के येसु, “अंटोर लोकुल्‍कुन उद्‍दालय वेहाट,” इंचि इत्‍तोर. अगा वेल्‍लेन पच्‍चाटा जाडि मत्‍ता. अगा उदतोरव्टेटाल दग्‍गेर-दग्‍गेर हेय्युं वेय्‍कुना मंदि मांड्‍से मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","पजा येसु आ हारिन कय्‍दे पीसि पेनदुक दन्यवाद कीतोर. पजा आ हारिन उद्तोर अंटोर्क वाटालय ओना सिस्युल्कुंक हीतोर. जिम्मानगुडा अल्हेन कीतोर. अंटोर पीरनिंडा तित्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ओर अंटोर पीरनिंडा तित्‍तंका, “बतंगे उत्‍तगा पोच्‍चमन्‍नि, मिगुल्तव अन्‍नि जमा कीम्‍टु,” इंचि येसु सिस्युल्कुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","तिनालय लोकुल्‍कुंक हीता हेय्युं हारिनाल मय्तव तुकडें जमा कीते, पन्‍नेंड तट्‍टां निंडतां. ");
INSERT INTO esg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","येसु कीता इसोंटा अद्‍बूतामाता चिन्‍हतुन हूळसि लोकुल्‍क, “निजमे! इद दुनियाते वरोर पेनदा कबुरतोर वायानोर मत्‍तोर, ओर ईरे आंदुर,” इंचि इनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","पजा लोकुल्‍क ओन राजाल कियालय बल्हैना बल्‍मि कींतुर, इंचि ओन्क तेळियता. अदुनहाटीं ओर वरोरे मर्रा गुट्‍टातेके पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","नुल्‍पेटा वेलाक येसुना सिस्युल्क गालिल समुद्रमता ओड्‍डुंक होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","हीकट अय्नागानि येसु वायाहिल्‍लोर इंचि सिस्युल्क उंदि डोंगाते उद्‍दिस समुद्रमता हब्बेटा बाजुंक मनना कपर्नाहुम इनना सहर होनालय पेय्‍स्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","वळि इरगा वासेक मत्‍ताहेंका समुद्रमते पेद्‍दा-पेद्‍दा तडां तेदसेक मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ओरा डोंगा हेय्युं-हारुं किलोमिटर्क मुन्‍ने होत्‍ता बारे, अचानक येसु एतापोर्रो ताकसेके डोंगा दग्‍गेरा वायानद ओर हूळसि, इरगा वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","गानि येसु, “ननाने आंदुन! वेरियमट,” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","इत्‍तारित्‍ते ओर कूस आसि, येसुन डोंगाते उपिच्‍कुनालय तयार आतुर. अच्‍चोटेन ओर बगा अय्ते होनालय पेय्‍स्‍तुर अद जेगातगा ओरा डोंगा एवता. ");
INSERT INTO esg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","येसु सामि पेनदुक दन्यवाद कीसि, अंटोर्क हारिं हीता जेगातगा ओन्क कलियालय लोकुल्‍क इंकुंदि रोजु पंगासि जमा आयालय दल्‍गतुर. अगा सिराप उंदे डोंगा मत्‍ता. अद डोंगाते अय्ते सिराप ओना सिस्युल्‍के उद्‍दिस होत्‍तुर. येसु ओरतोनि होना हिल्‍लोर. इंचि आ लोकुल्‍कुंक एरपाटे मत्‍ता. गानि पज्जोटाल तिबेरिया नाटेनाल वेरे इच्‍चुं डोंगां अगा वासि मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","पजा आ लोकुल्‍क येसुन, ओना सिस्युल्कुन पहकतुर, गानि ओर्क बोरे दोर्का हिल्‍लुर. अदुनहाटीं ओर लोकुल्‍क अगा मत्‍ता डोंगाने उद्‍दिस येसुन पहकालय कपर्नाहुम होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","पजा लोकुल्‍क हब्बेर ओड्‍डु एवतंका येसुन अगा हूळसि, “रब्‍बी! निमे इगे बस्के वातिन?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","अस्‍के येसु इल्‍हा वळकालय दल्‍गतोर: “नना निजम-निजम वेहासेक, नना कीता अद्‍बूतामाता चिन्‍हन हूळसि मिमेट नाकुन पह्कसेक हिल्‍लिर. नना मीकु पीरनिंडा तिंडि तासतन इंचि नाकुन पहकसंतिर. ");
INSERT INTO esg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","हवसोननसोंटा तिंडि पज्जो मिमेट होनमट. दानकु बदुल, बस्‍केळ्‍क पिस्सना पिस्वर हियानद, बस्‍केने हव्वाकोंटा मनना तिंडितुन पह्कट. अदुन हियना अदिकारमता सिक्‍का पेनबाबाल नापोर्रो वाटतोर, अदुनहाटीं असोंटा तिंडि, मनकना रूपमते पुटतोन नना, मीकु हिया परांतन.” ");
INSERT INTO esg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","अस्‍के लोकुल्‍क, “अय्ते पेनदा कबळ कियालय, मोमोट बतल कियना?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","पूसकीतस्‍के, “पेन बोन अय्ते लोहतनो, ओनपोर्रो मिमेट विस्वासम इर्रट,” इंचि येसु जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","पजा लोकुल्‍क, “मावा एनकटा पेद्‍दाल्क इजिप्‍त देसेमताल वायनेंके बय्‍लि जेगातगा मन्‍ना इनना तिंडि तित्‍तुर. ओर्क तिनालय तिंडि मूसाल स्वर्गमताल हीतोर, इंचि दर्मसास्‍त्रमते रासि मत्‍तापे ओर्क आ तिंडि तिनालय दोर्कुता. अय्ते मोमोट नीपोर्रो विस्वासम इर्रलय इंदके निमे माकु बसोंटा चिन्‍ह हुप्‍संतिन?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","अस्‍के येसु, “नना निजम-निजम वेहासेक, स्वर्गमताल तिंडितुन मीकु हीतोर मूसाल आयोर, नावा बाबाल हीतोर. इंदके नावा बाबाल स्वर्गमताल वायना आ निजमाता तिंडितुन मीकु हीसंतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","बारित्‍ते पेनबाबाल स्वर्गमताल लोहतदे, इद दुनियातोर्क पिस्वरतुन हींता. पेनबाबाल लोहचीता निजमाता तिंडि अदे आंद,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","अस्‍के लोकुल्‍क, “अय्ते अद तिंडितुन माकु बस्‍केळ्‍क हीम सामि,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","अस्‍के येसु ओर्क इल्‍हा वेहालय दल्‍गतोर, “पिस्वर हियना तिंडि ननाने आंदुन. नहगा बोर अय्ते वांतुर, ओर्क बस्‍केने करवेस्सो. बोर अय्ते नापोर्रो विस्वासम इर्रंतुर, ओर्क बस्‍केने दूपा आयो. ");
INSERT INTO esg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","गानि नना मीकु मुन्‍नेन वेहताप, मिमेट नाकुन हूळसिगुडा नावापोर्रो विस्वासम इर्रा हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","अयना बाबाल बोर-बोर्कुन अय्ते नाकु अप्‍पजेप्‍पंतोर, ओरे नहगा वांतुर. नहगा वायानोर्कुन नना बस्‍केने मलाहचि लोहोन. ");
INSERT INTO esg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","बारित्‍ते नना नावा इच्‍चां पूरा कियालय स्वर्गमताल हिळु रेय्‍सि वाया हिल्‍लेन. नाकुन लोहतोना इच्‍चातुन पूरा कियालय नना वातन. ");
INSERT INTO esg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","नाकुन लोहतोना इच्‍चा बतल इत्‍ते, नाकु अप्पजेपतोर्कुन वरोरगुडा तप्‍सोनाकोंटा हूळना आनि आकिरता रोजु ओर्कुन मर्रा जीवाते तेहना. ");
INSERT INTO esg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","नावा बाबाना इच्‍चा बतल मंता इत्‍ते, मर्रिनेके हूळसि ओनपोर्रो विस्वासम कियानोर अंटोर्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कना. अल्हा बोर अय्ते विस्वासम इर्रंतुरो, ओर्कुन नना आकिरता रोजुने मर्रा जीवाते तेहांतन,” इंचि येसु ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","“स्वर्गमताल रेय्ता तिंडि ननाने आंदुन,” इंचि येसु इत्‍तस्के यहुदि पेद्‍दाल्क ओरद ओरे येसुना बारेमते, “अरे! ईर योसेप इनानोना मर्रि आयोरा! ईना तल्‍लुर-बाबो मनाकु एरपाट. अय्ते ईर, नना स्वर्गमताल वातोनांदुन, इंचि बल्हा इंचंतोर?” इंचेके गुल्‍गालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “मीवद मिमेटे गुल्‍गकुनमट. ");
INSERT INTO esg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","नाकुन लोहचीता बाबाल, बोना मनसुने अय्ते नहगा वायना इच्‍चातुन पुटसंतोरो, ओरे नहगा वांतुर. वेरे बोरे वाया परुर. आकिर रोजुने नहगा वातोर्कुन ननाने जीवाते तेहांतन. ");
INSERT INTO esg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","पेनदा कबुरतोरा पुस्तकाल्कुने, अंटोर लोकुल्‍कुंक पेने कराहंता, इंचि रासि मंता. बोर अय्ते बाबाना पोल्‍लें केंजांतुर, करियांतुर, ओर अंटोर नहगा वांतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","पेनबाबान बोरे हूळा हिल्‍लुर. नना अगटाल वातोनांदुन, ननाने हूळतन. ");
INSERT INTO esg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","नना निजम-निजम वेहासेक, नापोर्रो विस्वासम कीतोन्कु बस्‍केळ्‍क पिस्सना पिस्वर दोर्कते इनकुंटु. ");
INSERT INTO esg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","पिस्वर हियना तिंडि ननाने आंद. ");
INSERT INTO esg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","मीवा एनकटा पेद्‍दाल्क बय्‍लि बूमिते पेन अरहता मन्‍ना इनना तिंडि तित्‍तुर गानि हातुर. ");
INSERT INTO esg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","गानि स्वर्गमताल हिळु वाता तिंडितुन तित्‍तोर, बस्‍केने हायोर. ");
INSERT INTO esg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","स्वर्गमताल वाता जीवाते मनना तिंडि ननाने आंद. बोर अय्ते ई तिंडितुन तिंतुरो, ओर बस्‍केळ्‍क जीवातेन मनांतोर. ई तिंडि ना मेंदुल आंद, नना इद मेंदुलतुन दुनियातोरा पिस्वरताहाटीं हींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","इद केंजसि यहुदिल्क, “ओर मनकल ओना मेंदुलतुन मनाकु तिनालय बल्हा हिया परंतोर आयो?” इंचि ओरद-ओरे वदुरकुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","अस्‍के येसु, “हिके केंजट, निजम नना वेहांतन. मिमेट, मनकना रूपमते पुट्तोना, मेंदुलतुन तिन्‍वा, ओना नेत्‍तुरतुन उन्‍वा, मीकु पिस्वर हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","गानि बोर अय्ते नावा मेंदुलतुन तिंतुर, नावा नेत्‍तुरतुन उंटुर, ओर्क बस्‍केळ्‍क पिस्सना पिस्वर दोर्कंता. आकिर रोजुने ओर्कुन नना जीवाते तेहांतन. ");
INSERT INTO esg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","बारित्‍ते नावा मेंदुल निजमाता तिंडि आनि नावा नेत्‍तुर निजमाता उनानद आंदु. ");
INSERT INTO esg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","बोर अय्ते नावा मेंदुलतुन तिंतुर, नावा नेत्‍तुरतुन उंटुर, ओर नातोनि, नना ओरतोनि निलसि मनंतन. ");
INSERT INTO esg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","नाकुन लोहता जीवाते मनना नावा बाबाना ताकततोनि, नना जीवाते मंतन. अल्हेन बोर अय्ते नावा मेंदुलतुन तिंतुर, ओर नाहेंदाल जीवाते मनांतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","स्वर्गमताल हिळु वाता निजम तिंडि ननाने आंदुन. मीवा एनकटा पेद्‍दाल्क मन्‍ना इनना तिंडि तिंचिगुडा हातुर, गानि इद तिंडितुन तिनानोर मात्रम बस्‍केळ्‍क जीवाते मनांतुर,” इंचि येसु ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","कपर्नाहुम सहरता दर्मसास्‍त्रम कराहना लोते, कराहनेंके येसु इव पोल्‍लें वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","इव पोल्‍लें केंजसि, येसुना सिस्युल्‍कुनाल वेल्‍ले मंदि सिस्युल्क, “इव पोल्‍लें तेळियालय वेल्‍लेन कस्‍टम मंता, इवुन बोर केंजंतुर?” इंचि इनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","सिस्युल्क गुल्‍गकुंचंतुर इंचि येसु एरपाट कीसि ओरतोनि इल्‍हा वळकालय दल्‍गतोर, “मीकु इव पोल्‍लें केंजसि, कस्‍टमासंतना? ");
INSERT INTO esg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","अय्ते मनकना रूपमते पुटतोन नना, मुन्‍ने बगा मत्‍तन अगा मल्सि होननेंके हूळानय्ते, अस्‍के मिमेट बतल इंदकिरो मरि? ");
INSERT INTO esg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","मेंदुल पिस्वर हिया परो, दानकु बतल विलुवा हिल्‍ले. सिराप पेनदा आत्मे पिस्वर हींता. नना वेहना पोल्‍लेंगें आत्मा आनि पिस्वर आंद. ");
INSERT INTO esg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","गानि मीलोप्‍पो इच्‍चुर नावा पोल्‍लेन नमवोरगुडा मंतुर,” इंचि इत्‍तोर. बारित्‍ते, ओन नम्मनोर बोर, ओन वेरे लोकुल्‍कुंक पीसि हियानोर बोर? इत्‍तद येसुंक मुन्‍नेटाले एर्का मंता. ");
INSERT INTO esg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","पजा येसु, “नना मीकु वेहचि मत्‍तन गदा, बाबाल लोहवद बोरे नहगा वाया परुर इंचि. अदुनहाटींगे इव अन्‍नि पोल्‍लें नना मीकु वेहतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","अस्‍केटाल वेल्‍लेटुर येसुना सिस्युल्क येसुन होळसि मल्सि होत्‍तुर, मर्रा बस्‍केने ओना पज्जो होना हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","अदुनहाटीं येसु पन्‍नेंड सिस्युल्कुन, “मिमेटगुडा मल्सि होनालय हूळसंतिरा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","अस्‍के सिमोन पत्रु, “सामि, मोमोट इंका बोनगा दाकोम? बस्‍केळ्‍क पिस्सना पिस्वर हियना पोल्‍लें अय्ते निहागेन मंतां! ");
INSERT INTO esg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","पेन लोहता पवित्रुन निमेन आंदिन इंचि मोमोट विस्वासम कीसि एरपाट कीतोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","अस्‍के येसु, “मीकुन पन्‍नेंड मंदितुन ननाने पेरतन, अय्नागानि मी अव्टे वरोर देय्यम मंतोर,” इंचि सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","येसु इद पोल्‍ले इस्‍कारियोत नाटेना सिमोनुना मर्रि यहुदाना बारेमते वळ्कतोर. पन्‍नेंड मंदि सिस्युल्‍कुनाल ओर वरोरे येसुन पज्जोटाल दोकाते पीसि हियनोर मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","इद आता पजा, येसु गालिलतेन नार-नार तिरियसेक मत्‍तोर. यहुदि पेद्‍दाल्क ओन हव्कालय पोंचादोस्‍सि मत्‍ताहेंका ओर यहुदिया राज्येमते होना हूळा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","गानि अद वेलाते यहुदिल्कुना डेराना पंडुगु दग्गेर्क एवसि मत्‍ता, ");
INSERT INTO esg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","अदुनहाटीं येसुना तम्मुह्‍क येसुन, “निमे इगेटाल यहुदिया होन. अस्‍केन निमे कियना अद्‍बूतामाता कबाह्‍क नीवा सिस्युल्क हूळा परांतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","बोर अय्ते ओना पोरोल दुनियाक तेळियगोम इंचि इंतोरो, ओर बतले कबळ मक्‍किस किय्योर. निमे निजमे इसोंटा अद्‍बूतामाता कबाह्‍क कियानय्ते, दुनियातोरा मुन्‍ने कीसि हुप्‍सा,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ओना तम्मुह्कगुडा ओन नम्मा हिल्‍लुर, अदुनहाटीं ओर अल्हा इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","अस्‍के येसु, “मीकु अय्ते अन्‍नि वेलां मंचिये, मिमेट बस्के इत्‍ते अस्‍के अगा होना परांतिर. गानि नना अगा होनना वेला इंका एव्‍वा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","दुनियातोर मीकुन हय्साकोंटा मना परुर. गानि नना दुनियातोरा कबाह्‍क बेसतव आयों इंचि दुनियातोरा विरोदमते गवाइ हींतन, अदुनहाटीं नाकुन दुनियातोर हय्सुर. ");
INSERT INTO esg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","मिमेट पंडुगुंक होंटु. नना वायना वेला इंका एव्‍वा हिल्‍ले, अदुनहाटीं इद पंडुगुंक नना वासेक हिल्‍लेन,” इंचि येसु ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ओर्क इव पोल्‍लें वेहचि ओर गालिलतेन मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","गानि ओना तम्मुह्‍क पंडुगुंक होतंका, पज्जोटाल येसुगुडा अंटोर्क दिस्सेक आयो, गानि चुपचाप पंडुगुंक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहुदि पेद्‍दाल्क पंडुगुनगा, “ओर बगा मंतोर?” इंचेके ओन पहकालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","अद मंदिताल इच्‍चुर लोकुल्‍क बारे येसुना बारेमते, “ओर बेस मनकल आंदुर,” इंचि इनुंदुर. इंकिच्‍चुर बारे, “हिल्‍ले रो! ओर लोकुल्‍कुन गयबेत कींतोर,” इंचि गुसा-गूसा वळ्ककुनुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","गानि यहुदि पेद्‍दाल्कुना वेर्रेकु बोरे लोकुल्‍क येसुना बारेमते कुल्‍ला-कुल्‍ला वळ्‍काकोंदुर. ");
INSERT INTO esg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","पजा पंडुगु सुरुव आसि सगम पोळ्‍द आतंका, येसु गुळिते होंचि कराहलय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ओर कराहनदुन केंजसि यहुदि पेद्‍दाल्क, “ई मनकल अय्ते बदे इस्कुलते, बोरे गुरुनगा होंचि करिया हिल्‍लोर. अयना ईन्कु इच्‍चोन वेल्‍ले तेल्वि बगाटाल वाता?” इंचेके इचंत्रमते अरतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर, “नना कराहना पोल्‍लें नावां आयों, नाकुन लोहचीता पेनदव आंदुं. ");
INSERT INTO esg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","मीवा लोप्पोटाल बोरे आयिर, पेनदा इच्‍चा मत्‍ताप ताकंतन इनकुनानय्ते, नना कराहना पोल्‍लें नहगटाल वासंतंगा हिलाकोंटे पेनदागटाल वासंतंगा, इंचि ओन्क तेळियंता. ");
INSERT INTO esg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","बोर अय्ते ओना सतता पोल्‍लें कराहंतोरो, ओर ओना पोरोल्तुने पेद्‍दा कियालय हूळांतोर. गानि बोर अय्ते ओन लोहतोन्कु कदर दोर्कना इंचि इनकुंतोरो, ओर सत्‍तेम मनकल आंदुर, ओनगा बतले आबद्‍दम हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","मूसाल अय्ते मीकु दर्मसास्‍त्रमतुन एव्विचि हीतोर. गानि मिहागटाल वरोरगुडा अव्टेटा नियमकुनपोर्रो ताकसेक हिल्‍लिर. अय्ते बारि नाकुन हव्कालय हूळसंतिर?” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","अस्‍के लोकुल्‍क, “नीकुन देय्यम पीताना बतला, अल्हा वळ्‍कसंतिन! बोर नीकुन हव्कालय हूळसंतुर?” इंचि येसुंक जवाब हीतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","अय्ते येसु इल्‍हा वळ्कालय दल्‍गतोर, “नोमकेम रोजुननाड नना उंदि अद्‍बूतामाता कबळ कीतदुन हूळसि, मिमेट अंटोर वेल्‍लेन इचंत्रमते अरतिर. ");
INSERT INTO esg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","कतना कियना इंचि मीकु मूसाल वेहचि मत्‍तोर. असल निजम हूळते, ई कतना रिवाज मूसाल सुरुव किया हिल्‍लोर. अद एनकटा पेद्‍दाल्कुनगटाल वाता. मिमेट अय्ते कतना कियना वेला वातस्के, नोमकेम रोजुननाडगुडा मीवा मर्कुना कतना कींतिर. ");
INSERT INTO esg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","मूसाना नियम तप्पानायो इंचि, नोमकेम रोजुननाड बोनादन्‍ना कतना कियना वेला वायानय्ते मिमेट ओना कतना किया वच्‍चु. गानि अदे नोमकेम रोजुने नना वरोर मनकन पुरागा बेस कीते, मीकु नापोर्रो होंग बारि वायना? ");
INSERT INTO esg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मोकोम हूळसि न्‍यायम कियमट, निजम-निजम न्‍यायम कीम्‍टु,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","अस्‍के येरुसलेमतोर इच्‍चुर लोकुल्‍क, “यहुदि पेद्‍दाल्क बोन अय्ते हव्कालय हूळसंतुरो, ओर ईरे अय्ते आयोर गदा! ");
INSERT INTO esg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","हुळट, ओर लोकुल्‍कुना नड्‍डुम नित्‍तिसि बल्हा कुल्‍लम-कुल्‍ला वळ्कसंतोर! अय्नागानि ओन बोरे बतल इंचेक हिल्‍लुर. ईरे किरिस्‍तु इंचि, मना पेद्‍दाल्कगुडा निजम एरपाट कीतुर बारे! ");
INSERT INTO esg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","किरिस्‍तु वायनेंके ओर बगाटाल वांतोर, बोनके तेळियो. गानि ईर मनकल बगाटाल वातोर, मनाकु अंटोर्क एरपाटे मंता.” इंचि ओर वरोंक-वरोर वळकालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","येसु गुळितगा कराहनेंके इल्‍हा वळकालय दल्‍गतोर, “हो! नना बोन आंदुन, बगाटाल वातन इदंता मीकु एरपाटे मंता. गानि नावद ननेन इगे वाया हिल्‍लेन. नाकुन लोहतोर सत्‍तेमंतुड आंदुर, ओर बोर आंदुरो मीकु एरपाट हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","गानि नना ओन एरपाट कींतन. बारित्‍ते ओरे नाकुन लोहातोर, नना ओनागटाले इगे वातन,” इंचि लगांचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","पजा यहुदि पेद्‍दाल्क येसुन दोर्का पियालय हूळतुर. गानि अस्केळ्क ओना वेला एव्‍वका मत्‍ता. अदुनहाटीं वरोरगुडा ओन्क कय दोस्‍सा पराहिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","अयना गुळितगा मत्‍ता मंदिताल वेल्‍लेटोर येसुन नमतुर. नम्मिसि, “किरिस्‍तु वातस्के, ईनकन्‍ना एक्‍को अद्‍बूतम आयना कबाह्‍क कियनुरा?” इंचि ओर वळ्कालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","लोकुल्‍क येसुना बारेमते इसोंटा पोल्‍लें गुसा-गुसा वळ्कानेंके परिसिल्क केंजतुर. केंजसि पेर्मालोर्क आनि परिसिल्क येसुन दोर्का पियानाहाटीं गुळितगा कावेल कीसेक मत्‍ता सिपाइल्कुन लोहतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","अस्‍के येसु ओर्क, “इंका जेर्रासेप नना मीतोनि मनंतन, पजा नाकुन लोहतोनगा नना तिरियसि दांतन. ");
INSERT INTO esg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","मिमेट नाकुन पहककिर, गानि मीकु दोर्कोन. इंका नना मनना जेगातगा मिमेट वाया परिर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","अल्हा वेहाटेलक, यहुदि पेद्‍दाल्क ओरद-ओरे, “मनम पहकिना गानि दोर्काकोंटा ओर बगा दांतोर आयावच्‍चु? युनानि देसेमते होंचि, सिल्‍लर-सल्‍लर आसि मनना मना लोकुल्‍कुंक पेनदा पोल्‍लें अय्ते करहोर गदा! हिलाकोंटे युनानि लोकुल्‍कुनगा दांतोरा? ");
INSERT INTO esg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘मिमेट नाकुन पहकाकिर, गानि मीकु दोर्कोन. इंका नना मनना जेगातगा मिमेट वाया परिर,’ इंचि इत्‍ता पोल्‍लेंक अर्तम बतल आयावच्‍चु?” इंचेके वळ्ककुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","अद पंडुगुना आकिरता रोजुंकु वेल्‍लेन विलुवा मनंता. अद रोजुने येसु नित्‍तिसि, “दूपातोर नहगा वासि उंडावच्‍चु. ");
INSERT INTO esg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","दर्मसास्‍त्रमते रासि मत्‍ताप, नापोर्रो विस्वासम कीतोना लोप्पोटाल पिस्वर हियना एता बेरेह्क पोंगनूं,” इंचि लगांचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","येसुनपोर्रो विस्वासम कीतोर्क पेनदा आत्मा दोर्कनद मत्‍ता. अदे आत्माता बारेमते वेहालय येसु इव पोल्‍लें वळ्कतोर. येसु हासि मर्रा महिमाते तेदानदे मत्‍तोर. अदुनहाटीं पेन अदवेरदाका अद आत्मातुन बोर्के हिय्या हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","इव पोल्‍लें केंजतोर इच्‍चुर लोकुल्‍क, “निजमे! बोर पेनदा कबुरतोर अय्ते वायनद मत्‍तोरो, ओर ईरे आंदुर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","इंकिच्‍चुर बारे, “ओर किरिस्‍तु आंदुर,” इंचि इत्‍तुर. आनि इंकिच्‍चुर लोकुल्‍क, “अरे! गालिल एरियाताल किरिस्‍तु वांतोरा? ");
INSERT INTO esg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","‘किरिस्‍तु दाविद राजाना वंसंमते पुट्‍सि, दाविद राजाल पुटता बेतलहेम नाटेनाले वांतोर,’ इंचि दर्मसास्‍त्रमते रासि हिल्‍लेना!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","येसुना बारेमते लोकुल्‍कुंक रकारकाल्कुना विचाराल्क मत्‍ताहेंका, लोकुल्‍क ओरद ओर्के अर्राकोंटा आसि वेरे-वेरे आतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","इच्‍चुर ओन दोर्का पियालय हूळतुर, गानि बोर वरोरगुडा ओनपोर्रो कय वाटा पराहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","गुळितगा कावेल कियानोर बोर अय्ते येसुन दोर्का पियालय होत्‍तुर, ओर उत्‍ता कय्‍के मल्सि वातुर. अस्‍के, “मिमेट ओन बारि पीसि तराहिल्‍लिर?” इंचि पेद्‍दा पेर्मालोर आनि परिसिल्क ओर्कुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","अस्‍के आ कावेल कियानोर, “ओर वळ्कताप बोरे मनकल बस्‍केने वळ्का हिल्‍लोर,” इंचि जवाब हीतुर. ");
INSERT INTO esg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","पजा परिसिल्क ओर्कु इल्‍हा जवाब हीतुर. “ओर मीकुनगुडा पसांच्‍तोरा? ");
INSERT INTO esg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","यहुदि पेद्‍दाल्कुनाल आयि, परिसिल्‍कुनाल आयि, बोर वरोरन्‍ना ओन नम्मुतोर मंतोरा? बोरे हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","गानि येसुन बोर अय्ते नम्मुतुरो ओर्क मूसाना नियमकु तेळियों, ओर्क तप्‍पाकोंटा सापनेम दल्‍गंता,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","अगा निकोदेमस पोरोलतोर वरोर मत्‍तोर, ओर मुन्‍ने उंदि मल्का येसुंक कलियसि मत्‍तोर. ओरगुडा आ परिसिल्‍कुनाल वरोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","अय्ते ओर, “वरोर मनकंक मनम ओना गवाइ केंजाकोंटेने, ओर बतल कीतोर तेल्‍पिचकुनाकोंटेने मना दर्मसास्‍त्रमता नियमकुना परकारम, न्‍यायम किया परांतोमा?” इंचि ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","अय्ते ओर, “अरेय, निमेगुडा गालिल एरियातोना रो? होन! होंचि दर्मसास्‍त्रमते बेस पहकिसि हदवा, गालिलताल बोरे पेनदा कबुरतोर वायोर इंचि रासि मंता,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","पजा ओर अंटोर ओरा-ओरा लोह्कुने होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","गानि येसु जय्‍तुन मराकुना गुट्‍टतेके होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","हक्‍केरेन मर्रा गुळितगा वातोर. वेल्‍लेन लोकुल्‍क ओनगा जमा आतुर. येसु उद्‍दिस ओर्क कराहलय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","ओर्क कराहसेके मननेंकेन, बोगमतनम कियनेंके दोर्कता उंदि मुरतटुन, दर्मसास्‍त्रम कराहना गुरुल्क आनि परिसिल्क ओनगा पीसि तच्‍चि लोकुल्‍कुना मुन्‍ने निलाहतुर. निल्‍हाचि, “गुरु, इद मुरतटुन बोगमतनम कियानेंके मोमोट दोर्का पीतोम. ");
INSERT INTO esg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","इसंटा मुरतटुन बंडाने तंचि हव्कना इंचि मूसाना नियम मनाकु आदेस हीता. अय्ते दीना बारेमते निमे बतल इंतिन मरि?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ओर वळ्कानेंके बतलन्‍ना तप्पु कीते ओन दोर्का पियना उपायमते, ओर असोंटा सवाल पूसकीतुर. गानि येसु हिळु वंगिसि बूमिपोर्रो बतलो वेलुने रासालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","8","ओर उंदे हट्‍टु पीताहाटीं, येसु तेदसि ओर्कुन, “सरे! बंडाने तनाटु. गानि मिहगटाल बोर अय्ते बस्‍केने पापम किया हिल्‍लोर, मुन्‍ने ओरे दीन बंडाते तनना,” इंचि वेहतोर. पजा मर्रा वंगिसि बूमिपोर्रो वेलुने रासालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","दान तत्‍तोर अंटोर येसु इत्‍तदुन केंजसि, मोदाला मातरालोर आनि पज्जोटाल अंटोर वरोन पज्जो वरोर अगटाल पेय्सि होत्‍तुर. ओर अंटोर अगटाल होत्‍तस्के लोकुल्‍कुना नड्‍डुम सिराप येसु आनि आ मुरतळे मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","पजा येसु इंकुंदि मल्का तेदसि, “बाई, नीकु सिक्‍साता आदेस हियानोर बेके होत्‍तुर? नीकु बोरे सिक्‍साता आदेस हिय्या हिल्‍लुरा?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","अस्‍के अद मुरतळ, “नाकु बोरे सिक्‍साता आदेस हिय्या हिल्‍लुर सामि!” इंचि इत्‍तस्के येसु, “ननागुडा नीकु सिक्‍साता आदेस हिय्योन. होन, इंका बस्‍केने पापम कियमा,” इंचि दान्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","पजा येसु, “नना दुनियातोराहाटीं वेलगु आंदुन. बोर अय्ते नावा पज्जो ताकंतोर, ओनगा पिस्वरताहेके ओयना वेळसि मनंता, अदुनहाटीं ओर बस्‍केने हीकटते ताकोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","अस्‍के परिसिल्क, “नीवा बारेमते निमेन गवाइ वेहकुंचंतिन, अदुनहाटीं नीवा गवाइते सत्‍तेम हिल्‍ले,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","अय्ते येसु ओर्क इल्‍हा जवाब हीतोर, “नावा बारेमते ननाने गवाइ वेहिनागानि, नावा गवाइ मात्रम सत्‍तेम आंद. बारित्‍ते, नना बगाटाल वातन, बगा दांतन, इत्‍तद नाक एरपाट मंता. गानि नना बगा वातन, बगा दांतन मीकु बतले एरपाट हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","मिमेट मनकना बुद्‍दिते न्‍यायम कींतिर, गानि नना बोनदे न्‍यायम किय्योन. ");
INSERT INTO esg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ओक्‍कला नना न्‍यायम कियिनागानि नावा न्‍यायम निजम मनंता, बारित्‍ते नना वरोने हिल्‍लेन, नाकुन लोहचीता ना बाबाल नाक तोळ मंतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","इव्वुरा गवाइ उंदि आते, अद गवाइ निजम मनंता इंचि मीवा मूसाना नियमतेन रासि मंता. ");
INSERT INTO esg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","दीन परकारम, नावाहाटीं नना वरोर गवाइ आनि नाकुन लोहचीता ना बाबल इंकावरोर गवाइ,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","इद केंजसि ओर, “नीवा बाबाल बगा मंतोर?” इंचि पूसकीतुर. अस्‍के येसु, “असल नना बोन, नावा बाबाल बोर? मीकु एरपाट हिल्‍ले. मिमेट नाकुन एरपाट कियानय्ते, ना बाबान इंका एरपाट कींतिर,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","येसु इव पोल्‍लें, गुळिता लोप्पो कोत्‍तां वाटना जेगातगा नित्‍तिसि कराहनेंके वळ्कतोर. अय्नागानि ओन बोरे दोर्का पिया हिल्‍लुर. बारित्‍ते ओना वेला एव्वनदे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","पजा इंकुंदि मल्का येसु ओर्कुन, “नना अय्ते होंचंतन. मिमेट नाकुन पहककिर. मिमेट मीवा पापाल्क मापि आयका मुन्‍नेन हाकिर. नना बगा अय्ते होंचंतन अगा मिमेट वाया परिर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","अस्‍के यहुदि पेद्‍दाल्क ओरद ओरे, “नना बगा अय्ते होंचंतन अगा मिमेट वाया परिर, इंचि बारि इंचंतोर मरि? ओक्‍कला ओना जीवातुन ओरे पोळागोटकुन्‍नोर गदा!” इंचि वळ्कालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","पजा येसु ओर्कुन, “मिमेट हिळतोर आंदिर, नना पोर्रोटोन आंदुन. मिमेट इद दुनियातोर आंदिर, गानि नना आयोन. ");
INSERT INTO esg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","अदुनहाटींगे, मिमेट मीवा पापाल्क मापि आयका मुन्‍नेन हाकिर, इंचि नना इत्‍तन. ओन ननाने आंदुन इंचि विस्वासम कियाकोंटे, मिमेट मीवा पापाल्क मापि आयका मुन्‍नेन हाकिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","अस्‍के ओर, “अय्ते निमे बोन आंदिन मरि? माकु वेहा,” इंचि पूसकीतस्‍के येसु, “नना बोन इंचि मीकु मुन्‍नेटाल वेहचेके वातानो, नना ओने आंदुन. ");
INSERT INTO esg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","मीवा बारेमते वळ्कालय, मीवा न्‍यायम कियालय, नहगा वेल्‍लेन पोल्‍लें मंतां. गानि नाकुन लोहतोर सत्‍तेमंतुड आंदुर, इंचि नना सिराप ओनागटाल केंजता पोल्‍लेंगें लोकुल्‍कुंक वेहचंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","गानि येसु ओना बाबाना बारेमते वेहतोर इंचि ओर्क इंकागुडा अर्तम आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","अदुनहाटीं येसु, “मनकना रूपमते पुटतोन नाकुन, बस्के अय्ते वेलाड वाटमळ जर्रगंतनो, अस्‍के, ओन ननाने आंदुन इंचि, मीकु एरपाट आयार. अचोने आयका, नना सतागा बतले कीसेक हिल्‍लेन, गानि बव पोल्‍लें अय्ते बाबाल नाकु कराहतोरो, अवे पोल्‍लें नना वेहतन. ");
INSERT INTO esg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","नाकुन लोहतोर नावा तोळ मंतोर. नना बस्‍केळ्‍क ओन्क कुसि हियना कबाह्के कींतन, अदुनहाटीं ओर नाकुन बस्‍केने ओंटिगा होळसोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ओना ई पोल्‍लें केंजतोर, वेल्‍लेटोरे ओन नम्मुतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","पजा येसु, ओनपोर्रो विस्वासम कीता यहुदिल्कुनतोनि, “मिमेट नना कराहता पोल्‍लें पीसि ताकानय्ते निजमे नावा सिस्युल्क आंतिर. ");
INSERT INTO esg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","अस्‍के मिमेट सत्‍तेमतुन एरपाट कीकिर, आ सत्‍तेमे मीकुन होळसार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","अस्‍के ओर, “मोमोट अय्ते अब्राहामुना वंसंमतोरम आंदुम, इदवेरदाका मोमोट इद बूमिपोर्रो बोनदे कय हिळु दासुल्क आसि मना हिल्‍लोम. अय्ते, अद सत्‍तेम मीकुन होळसार, इंचि निमे बल्हा इंतिन?” इंचि येसुंक जवाब हीतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","अस्‍के येसु ओर्क इल्‍हा वेहतोर, “नना निजम-निजम वेहासेक, पापम कियना हरेक मनकल पापमता दासुडे. ");
INSERT INTO esg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","वरोर दासि मनकल मालकुना लोतोरतोनि बस्‍केळ्‍क मन्‍नोर, गानि मालकुना मर्रि मात्रम बस्‍केळ्‍क मनांतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","अदुनहाटीं पेनदा मर्रि मीकुन पापमताल होळसीतेने, निजमते मिमेट पापमताल पलाते अर्रंतिर. ");
INSERT INTO esg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मिमेट अब्राहामुना वंसमतोर इंचि नाकु एरके. अय्नागानि नावा पोल्‍लेंक मीलोप्‍पो जेगा हिलुवाहेंका मीवा लोप्पोटाल इच्‍चुर नाकुन हव्कालय हूळसंतिर. ");
INSERT INTO esg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","नना नावा बाबानतोनि मत्‍तस्के बतल अय्ते हूळतनो, अदे मीकु वेहचंतन. आनि मिमेटगुडा मीवा बाबानहेंदाल केंजतद कीसंतिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","अस्‍के ओर, “अब्राहाम मावा बाबाल आंदुर,” इंचि इत्‍तुर. पजा येसु, “हिल्‍ले! मिमेटगिंटा अब्राहामुना पिलाल्क आसि मत्‍ते, ओर कीतापे मिमेटगुडा कीसि मन्‍नेर. ");
INSERT INTO esg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","गानि नना पेनदागटाल केंजता सत्‍तेम पोल्‍लें मीकु वेहते, मिमेट नाकुने हव्कालय हूळसंतिर. अब्राहाम अय्ते अल्हा किया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","मिमेट मीवा बाबाल कीताप कीसंतिर,” इंचि इत्‍तोर. अस्‍के ओर, “मोमोट बोगमतनम कीते पुट्‍टा हिल्‍लोम! माकु वरोरे बाबाल मंतोर, ओर पेनबाबाले,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","अस्‍के येसु ओर्कुन इल्‍हा इत्‍तोर, “पेन मीवा बाबाल आसि मत्‍ते मिमेट नाकुन पावरम कीसि मन्‍नेर. बारित्‍ते नना पेनदागटाल वातन. इगे नावद ननेन वाया हिल्‍लेन. पेने नाकुन लोहता. ");
INSERT INTO esg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","नना वेहानदुन मिमेट असल केंजिर, अदुनहाटींगे नावा पोल्‍लें मीकु अर्तम आयों. ");
INSERT INTO esg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","मिमेट देय्यमता पिलाल्क आंदिर, देय्यमे मीवा बाबाल आंदुर. अदुनहाटीं मीवा बाबाल कियना तप्‍पुड कबाह्‍क कियमळ इत्‍ते मीकु वेल्‍लेन इस्‍टम. देय्यम मुन्‍नेटाले जीवां तिंचेके वाता. अद सत्‍तेमतुन बस्‍केने हय्सो. दानागा सत्‍तेम हिल्‍लेन हिल्‍ले. आबद्‍दम वळ्‍कमळे दाना गुनम आंदु, अदुनहाटीं अद बस्‍केळ्‍क आबद्‍दमे वळ्कंता, आबद्‍दमतुन पुट्‍संता. ");
INSERT INTO esg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","अदुनहाटीं नना मीकु सत्‍तेम वेहिनागानि मिमेट नाकुन नम्मिर. ");
INSERT INTO esg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","नना बतलन्‍ना पापम कीतन इंचि मिहागटाल बोरन्‍ना हुप्‍सा परांतिरा? नना निजम वेहचंतन, अय्ते मिमेट बारि नाकुन नमसेक हिल्‍लिर? ");
INSERT INTO esg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","बोर अय्ते पेनदा मनकल, ओर पेनदा पोल्‍लें केंजंतोर. गानि मिमेट पेनदा मनकालोर आयिर, अदुनहाटीं मिमेट अव पोल्‍लेन केंजसेक हिल्‍लिर,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","अस्‍के यहुदिल्क, “निमे सामरियातोन आंदिन, नीकुन देय्यम पीता, इंचि इनानय्ते, मोमोट इनानद निजमे गदा?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर, “नाकुन देय्यम पिया हिल्‍ले. नना नावा बाबाना कदर कींतन, गानि मिमेट नावा कदर कीसेक हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","नाकु कदर दोर्कना इंचि नना बस्‍केने इनकुनोन, गानि नाकु कदर दोर्कना इंचि इनानोर वरोर मंतोर. ओरे न्‍यायम कियानोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","नना निजम-निजम वेहासेक, बोरे आयिर नना कराहता पोल्‍लेनपोर्रो ताकानय्ते, ओर बस्‍केने हामुरतुन हूळोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","इदुन केंजसि यहुदिल्क, “नीकु निजमे देय्यम पीता इंचि इंदके माकु एरपाट आता. अब्राहाम आनि पेनदा कबुरतोरगुडा हातुर, आनि निमे, ‘बोर आयिर, नना वेहता पोल्‍लेनपोर्रो ताकानय्ते, ओर बस्‍केने हामुरतुन हूळोर’ इंचि वेहांतिन. ");
INSERT INTO esg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","मावा एनकटा पेद्‍दा मातरल अब्राहामगुडा हातोर, निमे ओनकन्‍ना पेद्‍दोना? पेनदा कबुरतोरगुडा हातुर. नीवद निमे बोन आंदिन इंचि इनकुंचंतिन?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","येसु ओर्क इल्‍हा जवाब हीतोर, “नावद ननाने कदर कीकुत्‍ते, अद कदरक बतले विलुवा मन्‍नो. गानि बोन अय्ते मिमेट, ‘मावा पेन आंदुर’ इंचि इंतिरो, ओरे नावा बाबाल आंदुर, ओरे नाकु कदर हीसंतोर. ");
INSERT INTO esg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","गानि मिमेट ओन एरपाट किय्‍यिर, नना ओन एरपाट कींतन. ननागिंटा, ‘ओन नना एरपाट किय्योन,’ इंचि इनानय्ते, ननागुडा मीलेसीं आबद्‍दम वळ्‍कानोन आंतन. गानि नना ओन एरपाट कींतन, ओना पोल्‍लेनपोर्रो ताकंतन. ");
INSERT INTO esg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","नना वायना रोजुन हूळंतन इत्‍ता आसेते, मीवा एनकटा पेद्‍दा मातरल अब्राहाम, कूस मत्‍तोर. पजा अद रोजुन हूळसि ओर वेल्‍लेन कूस आतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","पजा यहुदिल्क, “निमे अब्राहामुन हूळतिना? नीकु अय्ते एबै वर्सांगुडा हिल्‍लें!” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","अस्‍के येसु, “नना निजम-निजम वेहासेक, अब्राहाम मातरल पुट्‍टका मुन्‍नेटाले नना मत्‍तन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","इद पोल्‍ले पोर्रोटाल, ओन बंडाने तंचि हव्कना इंचि अंटोर बंडां पेरतुर. गानि येसु ओर्क दिसाकोंटा मक्‍किस गुळिताल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","हरपीसि होननेंके-होननेंके येसु, पुट्तस्केटाल कळ्‍क दिसवोर वरोर मनकन हूळतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","अस्‍के सिस्युल्कु, “गुरु, ईर इल्‍हा गुड्‍डिगा पुट्‍टालय कारनम बतल आंद? ईर पापम कीताहेंका इल्‍हा पुट्तोरा मरि ईना तल्‍लुर-बाबो पापम कीताहेंकाना?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर, “ईर पापम कीताहेंकानो मरि ईना तल्‍लुर-बाबो पापम कीताहेंकानो ईर गुड्‍डिगा पुट्‍टा हिल्‍लोर. गानि ईनाहेंदाल पेनदा ताकत दिस अर्रना इंचि ईर इल्‍हा गुड्‍डिगा पुटतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","नाकुन लोहतोना कबाह्‍कुन मनम, पोळ्‍द होनाका मुन्‍नेन महापींता. बोरे कबळ किया परुर असोंटद नर्का वायनद मंता. ");
INSERT INTO esg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","गानि नना इद दुनियाते मत्‍तचोनजेम दुनियातोराहाटीं नना वेळ्‍सी आसि मनंतन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","पजा ओर बूमिपोर्रो उस्कतोर, उस्किसि आ उच्‍चुलतोनि बुर्दा तयार कीसि आ बुर्दातुन आ गुड्‍डोना कळ्‍कुंक होकतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","होकसि, “निमे सिलोम सेरवुनगा होंचि कळ्‍कुन नोर्कुन,” इंचि येसु आ गुड्‍डोन इत्‍तोर. अस्‍के ओर गुड्‍डि होंचि कळ्‍कुन नोरतस्के, ओना कळ्‍क दिसालय दल्‍गतां. अस्‍के ओर मल्सि वातोर. ");
INSERT INTO esg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","पजा ओना पका पीसीतोर, मुन्‍ने ओन बिच्‍चोम तल्कनेंके हूळतोर, इंदके ओन हूळसि, “उद्‍दिस बिच्‍चोम तल्कसेक मनुंदुर, ओर ईरे मनकल गदा!” इंचि वरोंक-वरोर पूसकियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","इच्‍चुर लोकुल्‍क, “हो, ईर ओरे आंदुर,” इत्‍तुर. इंकिच्‍चुर बारे, “आयोर रो! ओनसंटोर इंकावरोर आंदुर,” इंचि इत्‍तुर. गानि आ मनकल, “हिल्‍ले, ओन ननाने आंदुन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","अस्‍के ओर लोकुल्‍क, “अय्ते नीवा कळ्‍कुन बोर दिस्‍सानाल कीतोर?” इंचि ओन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","अस्‍के आ मनकल, “येसु पोरोलतोर वरोर मनकल बुर्दा कीसि, ना कळ्‍कुंक होकतोर, होकसि, ‘सिलोम सेरवुने कळ्‍कुन नोर्कुन,’ इंचि इत्‍तोर. होंचि नोरतन अय्ते, नावा कळ्‍क दिसालय दल्‍गतां,” इंचि ओर जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","लोकुल्‍क, “आ येसु बगा मंतोर?” इंचि पूसकीतस्‍के, “नाकु एर्का हिल्‍ले,” इंचि आ मनकल इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","पजा आ लोकुल्‍क, मुन्‍ने गुड्‍डि मत्‍ता मनकन परिसिल्कुनेके पीसि ओतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","येसु बद रोज अय्ते बुर्दा कीसि, कळ्‍क दिसवोना कळ्‍कुंक होकसि कळ्‍क दिस्‍सानाल कीतोर, अद रोज नोमकेम मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","तत्‍तस्के, आ मनकन, “नीवा दिसवा कळ्‍क बल्हा दिसालय दल्‍गतां?” इंचि परिसिल्कगुडा पूसकीतुर. अस्‍के आ मनकल, “ओर नावा कळ्‍कुंक बुर्दा होकतोर, पजा होंचि नोरतस्के, नावा कळ्‍क दिसालय दल्‍गतां,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ओर वेहतद केंजसि इच्‍चुर परिसिल्क, “ओर मनकल नोमकेम रोजुन नोमा हिल्‍लोर, अदुनहाटीं ओर पेनदागटाल वायाहिल्‍लोर,” इंचि इत्‍तुर. इंकिच्‍चुर बारे, “गानि वरोर पापि मनकल इसंटा अद्‍बूतामाता चिन्‍ह बल्हा हुप्‍सा परंतोर?” इंचि इत्‍तुर. इल्‍हा ओरद-ओर्के अर्राका ओर रोंड गेंग्क आतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","पजा परिसिल्क आ गुड्‍डितनमताल बेस आता मनकन, “ओर नीवा कळ्‍कुन बेस कीतोर, अय्ते निमे ओना बारेमते बतल इंतिन?” इंचि इंकुंदि मल्का पूसकीतुर. अय्ते आ मनकल, “ओर वरोर पेनदा कबुरतोर आंदुर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","आ मनकल गुड्‍डि मत्‍तोर, इंदके मर्रा ओना कळ्‍क दिसालय दल्‍गतां, इत्‍ता पोल्‍लेतुन यहुदि पेद्‍दाल्क इदवेरादाका गुडा नम्मा हिल्‍लुर. अदुनहाटीं ओर आ मनकना तल्‍लुर-बाबोन केयतुर. केय्‍सि, “ईर मी मर्रेना? पुट्तस्केटाल गुड्‍डिगा पुटतोर इंचि मिमेट इंतिर? अय्ते मरि ईर इंदके बल्हा हूळा परसंतोर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","अस्‍के ओना तल्‍लुर-बाबो, “ईर मावा मर्रे आंदुर, ईर पुट्नेंकेन गुड्‍डिगा पुटतोर, इद माकु एरपाटे. ");
INSERT INTO esg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","गानि इंदके ईर बल्हा हूळा परसंतोरो माकु तेळियो, इंका ईन हूळानाल बोर कीतोरो माकु तेळियो. इंदके ईर सतता बारेमते वळ्कनलायक आतोर, मिमेट ओने पूस कीम्‍टु, ओरे वेहंतोर!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यहुदि पेद्‍दाल्कुंक वेरियसि ओना तल्‍लुर-बाबो अल्हा इत्‍तुर. बारित्‍ते येसुए किरिस्‍तु आंदुर इंचि बोर अय्ते ओप्‍कुंतोर, ओन दर्मसास्‍त्रम कराहना लोताल पेचाहमळ जर्गंता, इंचि ओर मुन्‍नेन उंदि आसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","अदुनहाटींगे आ तल्‍लुर-बाबो, “इंदके ईर सतता बारेमते वळ्कनलायक आतोर, मिमेट ओने पूस कीम्‍टु,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","अदुनहाटीं परिसिल्क, गुड्‍डितनमताल दिस्‍सानाल आता मनकन मरुंदि मल्का केय्‍सि, “ई मनकल पापि इंचि माकु एर्के, अदुनहाटीं पेनदुक कदर हीम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","अस्‍के गुड्‍डितनमताल दिस्‍सानाल आता आ मनकल, “ओर मनकल पापि आंदुरो, आयोरो नाकु एरका हिल्‍ले. गानि मुन्‍ने नाकु कळ्‍क दिस्साकोंदुं, इंदके दिसंतां, इद मात्रम नाकु एरका,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","अयना परिसिल्क मर्रा ओन, “ओर नीकुन बतल कीतोर? ओर नीवा कळ्‍क दिस्‍सानाल बल्हा कीतोर?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","अय्ते गुड्‍डितनमताल दिस्‍सानाल आता आ मनकल, “दीनकन्‍ना मुन्‍नेन नना मीकु वेहतन, गानि मिमेट केंजा हिल्‍लिर. अय्ते मर्रा-मर्रा बारि पूस कीसंतिर? मीकुगुडा ओना सिस्युल्क आयानद मंतना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","अस्‍के परिसिल्क, “निमेन ओना सिस्युन आंदिन, मोमोट मूसाना सिस्‍युल्‍कुम आंदुम. ");
INSERT INTO esg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","पेन मूसानतोनि वळ्कता इंचि माकु एरपाट मंता. गानि ई मनकल बगाटाल वातोर? माकु बतले एरपाट हिल्‍ले,” इंचेके ओन तेराहतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","पजा आ मनकल इल्‍हा वळ्कालय दल्‍गतोर, “इद वेल्‍लेन इचंत्रम आयना पोल्‍ले आंद. ओर बगाटाल वातोर मीकु बतले एरपाट हिल्‍ले. अय्नागानि ओर मात्रम नावा दिसुवा कळ्‍कुन दिस्‍सानाल कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","पेन पापि मनकालोरा पोल्‍लेतुन केंजो, गानि बोर अय्ते दान मोळ्कसेक दाना इच्‍चा परकारम ताकंतोरो ओना पोल्‍लेतुन मात्रम पेन केंजंता, इंचि मनाकु एरपाट मंता. ");
INSERT INTO esg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","इद दुनिया पुटतस्केटाल अय्ते इदवेरदाका, वरोर मनकल, पुटनेंकेन गुड्‍डिगा पुट्तोना कळ्‍कुन दिस्‍सानाल कीतोर इत्‍ता पोल्‍ले मनम बस्‍केने केंजा हिल्‍लोम. ");
INSERT INTO esg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ईर मनकलगिंटा पेनदागटाल वातोर आयाकोंटे, इसोंटव बवे कबाह्‍क किया परा कोन्‍नेर,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","इव पोल्‍लें केंजसि परिसिल्क, “निमे अय्ते पुरागा पापमते पुट्‍सि-बेरस्तोन आंदिन. निमे माकु कराहंतिना?” इंचेके आ मनकन पेचाहचि गेदुमतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","आ मनकन पेचाहचि गेदुमतुर इंचि येसु केंजतोर. केंजसि, आ मनकंक कलियसि, “निमे मनकना रूपमते पुटतोन पोर्रो विस्वासम इर्रंतिना?” इंचि ओन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","अय्ते आ मनकल, “नना ओनापोर्रो विस्वासम इर्रनाहाटीं ओर बोर आंदुर, नाकु वेहा सामि!” इंचि येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","अस्‍के येसु, “निमे ओन हूळतिन, ओर नीतोनि इंदके वळ्कसंतोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","इद पोल्‍ले केंजसि, “नना विस्वासम कींतन सामि,” इंचि ओर येसुना काल्क मोळ्‍कतोर. ");
INSERT INTO esg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","अस्‍के येसु, “नना इद दुनियाते न्‍यायम कियालय वातन. गुड्‍डिर्क कळ्‍क दिस्सागोटालय आनि बोर अय्ते, ‘मोमोट अन्‍नि हूळा परंतोम’ इनकुंतुर, ओर्क ओर गुड्‍डिर्क इंचि हुप्‍सालय नना वातन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","अगा मंचि ओना इव पोल्‍लें केंजता इच्‍चुर परिसिल्क, “अय्ते मोमोटगुडा गुड्‍डिर्के इंतिना मरि?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","अस्‍के येसु, “मिमेटगिंटा गुड्‍डिर्क आयानय्ते मिहगा पापम मना कोनवळ. गानि मिमेट, ‘मोमोट बेस हूळा परंतोम’ इंतिर. अदुनहाटीं मीलोप्‍पो पापम मय्सि मनंता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","येसु इल्‍हा वळ्कालय दल्‍गतोर, “नना निजम-निजम वेहासेक, बोर अय्ते गोर्रेना पोदिते होळियनेंके, गलमाताल होळियका गूरे पोर्रोटाल दुनकिसि होळियंतोर, ओर दोंगल आनि दोसकुनानोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","गानि बोर अय्ते गलमाताल होळियंतोर, ओर गोर्रें मेहानोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","गोर्रें मेहानोनहाटीं गलमातगा कावेल कीसेक मनानोर गिल्कोम तेंडांतुर. गोर्रें ओना लेंग केंजंतां. ओर ओना गोर्रेन उंद-उंदाना पोरोल पीसि केय्‍सि, अवुन पलाते ओंतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","अन्‍नि गोर्रेन पलाते ओसि, ओर अवुना मुन्‍ने-मुन्‍ने दांतोर. गोर्रें ओना पज्जो-पज्जो दांता. बारित्‍ते अव ओना लेंगुन एरपाट कींतां. ");
INSERT INTO esg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","गानि एरपाट हिलवोना पज्जो अव होन्‍नों, ओनागटाल लक्‍कु वित्‍तंतां. बारित्‍ते अव ओना लेंगुन एरपाट किय्यों,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","येसु इद उदाहरन लोकुल्‍कुंक वेहतोर. गानि येसु बदुना बारेमते वळ्कतोर इत्‍तद ओर्क अर्तम आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","अदुनहाटीं येसु मरुंदि मल्का ओर्क इल्‍हा वेहतोर. “नना निजम वेहासेक केंजट, गोर्रें होळियाना गलमा ननेन आंदुन. ");
INSERT INTO esg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","नाकन्‍ना मुन्‍ने वातोर अंटोरे दोंगाल्क, दोसकुनानोर आंदुर. गानि गोर्रें ओरा पोल्‍लें केंजा हिल्‍लें. ");
INSERT INTO esg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","गलमा ननाने आंदुन. बोर अय्ते नहगटाल लोप्पो नेंगंतोर, ओन नना पिसागोटंतन. ओर लोप्पो-पलाते होनुळ-वायुळ कींतोर, तिनालय ओन्क मेता दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","दोंगाल्क सिराप दोंगा कियालय, हव्कालय, नासडेम कियालये वांतुर. गानि नना नावा गोर्रेंकु पिस्वर हियालय वातन. अदगुडा पुरागा पिस्वर हियालय वातन. ");
INSERT INTO esg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","बेस मेहानोन ननाने आंदुन. बेस मेहानोर, गोर्रेनाहाटीं ओर ओना जीवा हींतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","गानि बूतिक मेहालय वातोर, ओर निजम मेहानोर आयोर. मेहनेंके ओन्क तोडेल्‍लिगिंटा दिस्सानय्ते, गोर्रेन अग्गेन होळसि बेकेनो वित्‍तंतोर. बारित्‍ते अव गोर्रे ओनव आयों. अस्‍के आ तोडेल्‍लि वासि गोर्रेन पोर्रो अर्रंता आनि गोर्रें बारे सिल्‍लर-सिल्‍लर आंता. ");
INSERT INTO esg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ओर बूतिक वातोर इंचि अल्हा वित्‍तंतोर. ओन्क गोर्रेना पिकिर हिल्‍ले. अदुनहाटीं ओर वित्‍तंतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","गानि नना बेस मेहानोन आंदुन. बल्हा अय्ते बाबाल नाकुन एरपाट कींतोर, नना बाबान एरपाट कींतन, अल्हेन नावा गोर्रेन नना एरपाट कींतन, अव नाकुन एरपाट कींतां. नना नावा गोर्रेनाहाटीं जीवा हींतन. ");
INSERT INTO esg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","इद पोद्‍दितव आयवा गोर्रेंगुडा नहगा मंतां. नाकु अवुनगुडा तरानद मंता, अवगुडा नावा लेंग केंजनूं. अस्‍के अन्‍नि उंदे मंदा आसि मनंतां आनि अवुना मेहानोरगुडा वरोरे मनांतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","नना हासि मर्रा जीवाते तेदंतन इंचि नना नावा जीवा हीसंतन, इदुनहाटींगे नावा बाबाल नाकुन वेल्‍लेन पावरम कींतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","नावा जीवातुन नहगटाल बोरे तेंडकुन्‍नुर, नावा जीवातुन नना कुद्‍दे हींतन. नावा बाबाल नाकु आदेस हीताहेंका नावा जीवातुन हियनद, हीसि मर्रा मल्सि तेंडकुनना अदिकारम नाकु मंता,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","इव पोल्‍लेनहेंदाल मरुंदि मल्का यहुदिल्क वरोनद वरोंक अर्राका वेरे-वेरे आतुर. ");
INSERT INTO esg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ओराव्टेटाल वेल्‍लेटोर, “ओन्क देय्यम पीसि ओर पिस्सल आतोर, मिमेट ओना पोल्‍लें बारि केंजांतिर?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","गानि इच्‍चुर बारे, “इव पोल्‍लें देय्यम पीतोनां आयों. देय्यम बस्‍केनना कळ्‍क दिसवोना कळ्‍कुन दिस्‍सानाल किया परंतना?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","पीनि कालम वासि मत्‍ता. येरुसलेम सहरते गुळिते होळियाना हानुक इनना पंडुगु मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","अय्ते गुळितगा येसु सुलेमान इनना पंदिरतगा तिरियसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","अस्‍के, इच्‍चुर यहुदि लोकुल्‍क येसुना सुट्‍टु आसि, “निमे इंका बच्‍चुं रोजकु माकुन मर्ममते इर्रंतिन? निमे गिंटा किरिस्‍तुन आयानय्ते माकु कुल्‍ला-कुल्‍ला वेहा,” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर, “नना मीकु मुन्‍नेन वेहतन, गानि मिमेट नम्मा हिल्‍लिर. नावा बाबाना पोरोल्ते नना कियना कबाह्के नावा बारेमते गवाइ वेहचंतां. ");
INSERT INTO esg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","गानि मिमेट नावा गोर्रेना मंदातोर आयिर. अदुनहाटीं मिमेट नापोर्रो विस्वासम कीसेक हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","नावा गोर्रें नावा लेंगुन केंजंतां. नावा गोर्रेन नना एरपाट कींतन, अव नावा पज्जो-पज्जो वांतां. ");
INSERT INTO esg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","नना अवुंक बस्‍केळ्‍क पिस्सना पिस्वर हींतन, अव बस्‍केने नासडेम आयों, नावा कय्‍दाल अवुन बोरे गुंजकुना पर्रोर. ");
INSERT INTO esg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","बारित्‍ते अवुन नाकु, नावा बाबाल हीतोर. नावा बाबाल अंटोरकन्‍ना पेद्‍दोड आंदुर. अदुनहाटीं बाबाना कय्‍दाल अवुन बोरे गुंजकुना परोर. ");
INSERT INTO esg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","बाबल, नना मोमोट इव्वुरोम उंदे आंद,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","अस्‍के मरुंदि मल्का यहुदिल्क येसुन हव्कालय बंडां पेरतुर. ");
INSERT INTO esg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","अय्ते येसु, “नावा बाबाल नाकु वेहताप नना वेल्‍लेन बेसता कबाह्‍क मीकु कीसि हुपिस्तन. अव्टेटाल बद कबळहाटीं नाकुन बंडाने तनालय हूळसंतिर?” इंचि ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","अस्‍के ओर, “निमे कीता बेसता कबाह्कुनाहाटीं नीकुन बंडाने तन्‍नोम. गानि निमे पेनदा अपमानम कीतिन. अचोने आयका निमे मनकन आसिगुडा नीवद निमे पेन इंचि वेहकुंतिन, अदुनहाटीं मोमोट नीकुन बंडाने तनंतोम” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","अस्‍के येसु ओर्क इल्‍हा जवाब हीतोर, “मीवा मूसाना नियमते, ‘मिमेट पेनकु आंदिर इंचि नना इत्‍तन,’ इंचि इच्‍चुर लीडर्कुन पेन इत्‍तद, रासि हिल्‍लेना? मंता. ");
INSERT INTO esg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","दर्मसास्‍त्रम बस्‍केने तप्पु वेहो. ओक्‍कला, पेन दाना पोल्‍ले, बोर्क-बोर्क अय्ते दोर्कतनो, ओर्कुन पेनकु इंचि इत्‍तय्ते, नाकुन बाबाल पेरसि इद दुनियाते लोहचीतस्के, ‘नना पेनदा मर्रिन’ इल्‍हा इंचि इत्‍ते, नना पेनदा अपमानम कीतन इंचि मिमेट बल्हा इंतिर? ");
INSERT INTO esg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","नावा बाबाल कियना कबाह्‍क नना कियाकोंटे, नाकुन नममट. ");
INSERT INTO esg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","गानि नना अव कबाह्‍कुन कींतन इंचि, नाकुन नम्मकोन्‍ना, नना कियना कबाह्कुनपोर्रो अयना विस्वासम इर्रट. अस्‍के, बाबाल ना लोप्पो, नना बाबाना लोप्पो मंतोम इंचि मीकु तेळियार,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","अस्‍के ओर मरुंदि मल्का येसुन दोर्का पियालय हूळतुर, गानि ओर ओरा कय्‍दाल तपिच्‍कुंचि अगटाल होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","येसु मर्रा योर्दन बेरेटा हब्बेरा, बगा अय्ते मुन्‍ने योहान बापतिस्मा हियुंदुर, अदे जेगाते होंचि अग्गेन मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","42","अस्‍के ओनगा वेल्‍लेन मंदि वासि, “बापतिस्मा हियना योहान इचंत्रम आयनव बवे कबाह्‍क किया हिल्‍लोर. गानि ई मनकना बारेमते ओर बतल अय्ते वेहतोरो, अव अन्‍नि निजम आतां,” इंचि ओरद-ओरे वळ्कालय दल्‍गतुर. पजा अगा वेल्‍लेन मंदि येसुनपोर्रो विस्वासम कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","लाजर पोरोलतोर वरोर मनकल बिमार अर्सि मत्‍तोर. ओर ओना मरियम आनि मार्ता इनना अक्‍काह्कुनतोनि बेतानि इनना नाटे मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","मुन्‍ने उंदि मल्का उंदि मुरतळ, सामिना काल्कुंक अत्‍तर निय होकसि दाना केल्कुने उसुमता, अद इदे मरियम आंद. ई बिमार अरता लाजर दाना तम्मुर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","अदुनहाटीं अव रोंड अक्‍काह्‍क, “सामि, नीवा पावरमगल्‍लोड वरोर, बिमारते मंतोर,” इंचि येसुंक कबुर लोहतां. ");
INSERT INTO esg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","अद कबुर केंजसि येसु, “लाजरुंक अद बिमारि ओन हव्‍किसि ओयालय वाया हिल्‍ले, गानि पेनदा पेदातनमतुन हुप्‍सालय वाता. इदुनहेंदाल पेनदा मर्रिंक कदर दोर्कार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","येसुंक मार्ताल, दाना अक्‍कल आनि लाजर ईर इत्‍ते पावरम. ");
INSERT INTO esg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","लाजर बिमारते मंतोर इत्‍ता कबुर तेळियिनागानि येसु बद नाटे अय्ते मत्‍तोरो, अदे नाटे इंका रोंड रोजकु आगतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","पजा येसु, “वट, मनम यहुदिया राज्येम मल्सि दाकोम,” इंचि ओना सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","गानि सिस्युल्क, “रब्‍बी, कोन्‍नि रोजकु मुन्‍नेन अगाटा यहुदि पेद्‍दाल्क नीकुन बंडाने तंचि हव्कालय हूळतुर. अयना निमे मर्रा अग्गेन दांतिना?” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","अस्‍के येसु, “पोद्‍दाला पन्‍नेंड गंटां मन्‍नोंगां? ई वेलाते ताकानोर दुनियाता वेलगुन हूळसेक ताकंतोर, इंचि ओना कादुक बतल दल्‍गो ओर हिळु अर्रोर. ");
INSERT INTO esg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","गानि नर्काटा वेलाते ताकानोना लोप्पो वेलगु मन्‍नो, अदुनहाटीं ओना कादुक बतलन्‍ना दल्‍गिसि ओर हिळु अर्रा परंतोर,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","इव पोल्‍लें आता पजा मर्रा येसु, “मना दंटगाड लाजर निद्रा होत्‍तोर, गानि ओन नना निद्रताल तेहालय दांतन,” इंचि सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","अस्‍के सिस्युल्क, “सामि, ओक्‍कला ओर निद्रा होंचि मनानय्ते बेस आंतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","येसु लाजरना हामुरता बारेमते वळ्कतोर. गानि सिस्युल्क अय्ते लाजर निजम निद्रा होंचि आराम कीसंतोर इंचि इनकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","अदुनहाटीं येसु ओर्क, “लाजर हासोत्‍तोर,” इंचि कुल्‍ला-कुल्‍ला वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","वेहचि, “हासोत्‍तस्के नना ओनगा मना हिल्‍लेन. इद मीहाटींगे जर्गता, इंचि नना कूस मंतन. दीनहेंदाल मिमेट नापोर्रो विस्वासम कीकिट. वट! इंदके मनम ओनगा दाकोम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","अस्‍के, “दट! येसुनतोनि हायालय मनमगुडा दाकोम,” इंचि एमडाल्‍कुनाल वरोर तोमल इनना सिस्युड कळमता सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","बेतानि नाटे एवतस्‍के, लाजरुन बोंदाते ताससि नालुं रोजकु आता, इंचि येसुंक तेळियता. ");
INSERT INTO esg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बेतानि नार येरुसलेम सहरताल दग्‍गेर-दग्‍गेरा मूड किलो मीटर्क लक्‍कु मंता. ");
INSERT INTO esg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","तम्मुर हासोत्‍ताहेंका वेल्‍लेन दुक्‍कमते मनना मार्ता आनि मरियमुंक दैरनेम हियालय वेल्‍लेटोर यहुदिल्क वासि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","येसु वासंतोर इंचि मार्तांक तेळियतस्के ओन्क कलियालय अद एदुर होत्‍ता. गानि मरियम मात्रम लोने मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्ताल येसुंक कलियसि, “सामि, निमे गिंटा इगे मंचि मत्‍ते, नावा तम्मुर हायाकोन्‍नेर. ");
INSERT INTO esg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","गानि इंदके अयना बतल आयो. निमे पेनदुन बतल तल्‍कते अद, नीकु पेन हींता, इंचि नाकु एरपाट,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","अस्‍के येसु, “नीवा तम्मुंक मर्रा जीवा अर्रंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","पजा मार्ताल, “हो सामि, हातोर अंटोर्क जीवा अर्रना आकिरता रोजुने, ओर मर्रा जीवाते तेदानुर इंचि नाकु एरपाट मंता,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","अद केंजसि येसु, “हातोर्कुन तेहानोन आनि पिस्वरतुन ननाने आंदुन. नापोर्रो विस्वासम कीतोर, हायिनागानि मर्रा जीवाते तेदांतुर. ");
INSERT INTO esg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","जीवाते मननेंके नापोर्रो विस्वासम इर्रनोर अंटोर्क बस्‍केने हामुर वायो. इद पोल्‍लेतुन निमे नम्मंतिना मार्ता?” इंचि दान पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","अस्‍के अद, “हो सामि, पेनदा मर्रिन निमेन आंदिन, इंचि नना नम्मंतन. इंका इद दुनियाते वायना मत्‍तोर किरिस्‍तुनगुडा निमेन आंदिन,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","इच्‍चोन वळ्‍किसि अद अगटाल पेय्सि होंचि, दाना अक्‍कल मरियमुन सपुडदाका पक्‍कक केयता. केय्‍सि, “गुरु वातोर, ओर नीकुन केयसंतोर,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","मार्ताना पोल्‍ले केंजता केंजमळे मरियम बिराना तेदसि येसुनगा होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","येसु इंका नाटे होळिया हिल्‍लोर. मार्ताल ओन्क बगा अय्ते कलियतनो, अदे जेगाते मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","मरियमुंक दैरनेम हियालय दानतोनि लोते बोर अय्ते मत्‍तुरो, आ यहुदिल्क मरियमुन कुस्कुने तेदसि होननेंके हूळसि, “अद लाजरुना बोंदातगा होंचि अळंता बारे,” इन्कुंचि ओरगुडा दाना पज्जेन होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","येसु मत्‍ता जेगातगा मरियम एवसि, ओन हूळता. हूळसि ओना काल्कुनपोर्रो अरसि, “सामि, निमे इगे मंचि मत्‍ते ना तम्मुर हायाकोन्‍नेर,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","मरियम आनि दानतोनि वातोर अंटोर यहुदिल्कुना अळुळ हूळसि, येसुंक बादा अनपिस्ता. मनसुने ओर वेल्‍लेन दुक्‍कमते मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","पजा येसु, “ओन मिमेट बगा इरतिर?” इंचि पूसकीतस्‍के, “वासि हूळा सामि!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","हूळसि येसु अळतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","अस्‍के यहुदिल्क, “हुळट, लाजर इत्‍ते ओन्क बच्‍चोन पावरमो!” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","गानि इच्‍चुर लोकुल्‍क, “ईर मनकल, वरोर गुड्‍डिंक कळ्‍क दिस्‍सानाल कीतोर अय्ते, लाजरुन हामुरताल कापाळा पराकोन्‍नेरा?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","येसुंक मरुंदि मल्का मनसुने बादा अनपिस्ता. पजा ओर लाजरुना बोंदातगा होत्‍तोर. अद बोंदा उंदि पडालेह्का मत्‍ता. दाना सोर्रेक अड्‍डम उंदि बंडा दोब्‍बिसि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","पजा येसु, “अद बंडातुन तेंडट,” इंचि इत्‍तोर. गानि हासोत्‍तोना अक्‍कल मार्ताल, “सामि, ओर हासि नालुं रोजकु आसंता. अदुनहाटीं ओना सेत्‍ता इरगा गब्‍बु पीसि मंदगोम!” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","अस्‍के येसु, “निमे विस्वासम कियानय्ते पेनदा महिमातुन हूळकिन, इंचि नना नीकु वेहा हिल्‍लेना?” इंचि दान इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","अदुनहाटीं ओर आ बंडातुन तेंडतुर. पजा येसु पोर्रो हूळसेक, “बाबा, निमे ना पारतना केंजताहाटीं, नीकु दन्यवाद. ");
INSERT INTO esg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","निमे बस्‍केळ्‍के नावा पारतना केंजंतिन इंचि नाकु एरके. गानि नाकुन निमेन लोहतिन इत्‍तादुन, ना सुट्‍टु निलसि मत्‍ता लोकुल्‍क नम्मुगोम इंचि ओराहाटींगे नना ई पोल्‍ले वळ्‍कतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","इल्‍हा वळ्‍किसि येसु, “ए लाजर, पलातुक पेय्सि वा!” इंचि लगांचि केयतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","अस्‍के हासोत्‍ता लाजर पलाते वातोर, अस्‍के ओना कय्‍क-काल्क हामुर कप्पिडते हूट्‍टिस मत्‍तां, ओना मोकोमगुडा उंदि सेल्‍लाते हूट्‍टिस मत्‍ता. पजा येसु, “ओना कट्‍टुकु लेह्‍चि ओन होना हीम्टु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","येसु कीता अद कबळतुन हूळसि, मरियमुनगा वाता यहुदिल्कुनाल वेल्‍ले मंदि यहुदिल्क, येसुन नम्मुतुर. ");
INSERT INTO esg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","गानि ओराव्टेटाल इच्‍चुर लोकुल्‍क मात्रम, परिसिल्कुनगा होंचि येसु बतल-बतल कीतोर अदुन वेहतुर. ");
INSERT INTO esg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","अदुनहाटीं पेर्मालोर्क, परिसिल्क कलियसि उंदि पेद्‍दा पंचादि उपिस्तुर. उपिच्‍चि, “ओर मनकल अय्ते वेल्‍लेन अद्‍बूतामाता चिन्‍हां कीसि हुपिच्‍चंतोर. अय्ते मनम बतल कीकोम? ");
INSERT INTO esg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ओर कियानदुनंता मनम इल्हेन हूळसेक मत्‍ते, अंटोर ओने नम्मिसि ओन राजाल कींतुर. पजा रोम सरकारता सिपाइल्क वासि मना गुळितुन, मना लोकुल्‍कुन नासडेम कीसि पोहांतुर,” इंचि वळ्कतुर. ");
INSERT INTO esg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ओरव्टे वरोर कयपाल इनानोर मत्‍तोर. अद वर्सा ओरे पेद्‍दा पेर्माल मत्‍तोर. ओर, “मीकु बतले तेळियोना! ");
INSERT INTO esg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","देसेमता अंटोर लोकुल्‍क नासडेम आयनदानकन्‍ना, लोकुल्‍कुनाहाटीं वरोर मनकल हाते, बेस आयोना!” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","सिराप यहुदि लोकुल्‍कुना पायदाहाटींगे आयो गानि, पूरा दुनियाते बेके-बेकेनो सिल्‍लर आसि मत्‍ता पेनदा लोकुल्‍कुन उंदि कियालय, येसु ओना जीवातुन हींतोर इत्‍ता पोल्‍लेतुन ओर वेहतोर. इद पोल्‍ले ओर ओना सतता विचारमताल वळ्का हिल्‍लोर, गानि अद वर्सा ओर पेद्‍दा पेर्माल मत्‍तोर इंचि बविस्यवानि कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","इल्‍हा अद रोजुनाल येसुन हव्कालय यहुदि पेद्‍दाल्क पिलान कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","अदुनहाटीं येसु अस्‍केटाल यहुदिल्कुन नड्‍डुम अंटोर्क दिस्सेक वेलियाकोंदुर. पजा ओर येरुसलेम सहर होळसिसि बय्‍लि जेगाक दग्‍गेर मनना एप्राइम इनना नार होत्‍तोर. होंचि अगा ओना सिस्युल्कुनतोनि मनालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","अस्‍के यहुदिल्कुना दाटसि होनना पंडुगु दग्गेर्क एवसि मत्‍ता. अदुनहाटीं ओरा सततुन सुद्‍द कीकुनना रिवाज कियालय पंडुगुंकन्‍ना मुन्‍नेन वेल्‍लेन लोकुल्‍क नाहकुनाल येरुसलेम होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ओर अंटोर येसुन पह्कसेक मत्‍तुर. गुळिते नित्‍तिसि, “मीकु बतल अनपिच्‍चेक, ओर ई पंडुगुनाहाटीं वांतोरा, वायोरा?” इंचि वरोंक-वरोर पूसकियुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","अचोने आयका पेर्मालोर्क, परिसिल्क, येसुन दोर्का पियनाहाटीं, “येसु बगा मंतोर इत्‍ता संगति बोर्कन्‍ना तेळियते, माकु वासि वेहाट हुळाट!” इंचि आदेस हीसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","दाटसि होनना पंडुगुंकन्‍ना हारुं रोजकु मुन्‍नेन येसु बेतानिया इनना नाटे एवतोर. येसु बोन अय्ते हामुरताल जीवाते तेहतोरो आ लाजर ई बेतानियातेन मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","अगा येसुनाहाटीं नर्कटा गाटो तयार कीतुर. मार्ताल गाटो वाटता. लाजरगुडा गाटो तिनानोरतोनि उद्‍दिस मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","अस्‍के मरियम, जटामासि इनना मराता एक्‍को दराता सगोम लीटर अत्‍तर निय तच्‍चि, येसुना काल्कुनपोर्रो वळियता. वळियसि, दाना केल्कुने ओना काल्‍कुन उसुमता. अस्‍के अद नियदा गब्‍बु लोनंता विच्‍चका होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","गानि ओना सिस्युल्‍कुनाल इस्‍कारियोत नाटेनोर यहुदल इननोर वरोर मत्‍तोर. ई यहुदले पज्जो, येसुन दोकाते पीसि हियानोर आंदुर. ओर, “अरेरे! ई अत्‍तर नियदुन मूड नुह्कुना एंडि रूपेंक अम्मिसि, आ रूपेन गरिब लोकुल्‍कुंक हियानायोना?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ओन्क गरिब लोकुल्‍कुना पर्वा मंता इंचि अल्हा इना हिल्‍लोर. गानि ओना दोंगा बुद्‍दिहेंदाल, ओनगा कोत्‍तना संचि मननेंके, आ संचिते वाटता कोत्‍तानाल ओर दोसकुनुंदुर. अदुनहाटींगे ओर अल्हा वळ्कतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","अस्‍के येसु, “नना हायना रोजु दग्‍गेर एवताहाटीं नाकुन तयार कियालय अदुन होळसीम. ");
INSERT INTO esg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","गरिब लोकुल्‍क बस्‍केळ्‍क मीतोने मनांतुर, गानि नना मीतोनि बस्‍केळ्‍क मनोन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","अच्‍चोटेन येसु अगा मंतोर इंचि तेळियतस्के, वेल्‍लेन यहुदि लोकुल्‍क, सिराप येसुन हूळालये आयो गानि, येसु हामुरताल जीवाते तेहता आ लाजरुनगुडा हूळालय अगा होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","ई लाजरुनहेंकेन वेल्‍लेन मंदि यहुदिल्क ओर्कुन होळसि येसुनपोर्रो विस्वासम इरतुर, अदुनहाटीं पेद्‍दा पेर्मालोर लाजरुनगुडा हव्कना पिलान कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","इंकुंदि रोजु, येसु येरुसलेम वासंतोर इंचि, पंडुगुंक वाता लोकुल्‍कुंक तेळियता अय्ते, वेल्‍लेन मंदि लोकुल्‍क कजूर मराकुना कोम्मना-कोम्मां पीसि ओन्क कलियालय एदुर होत्‍तुर. होंचि, “होसन्‍ना! सामिना पोरोल्ते वायना इस्राएलता राजाना वेल्‍लेन दन्यवाद आयि, जय जोहार!” इंचि मोत्‍कुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍ले पूरा आयगोम इंचि येसु उंदि लेय्या गाडदि पोर्रो उद्‍दिस सहरतेके वासेक मत्‍तोर. दर्मसास्‍त्रमते रासता पोल्‍ले इल्‍हा मंता: “सियोनता लोकुल्‍कुनिटा वेरियमटु, हुळाट, मीवा राजाल गाडदि पोर्रो उद्‍दिस वासंतोर.” ");
INSERT INTO esg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","इव गटनां जर्गनेंके येसुना सिस्युल्कुंक बतले तेळिया हिल्‍ले. गानि येसु हामुरताल जीवाते तेदसि महिमाते स्वर्गम होत्‍तस्के, जर्गता अन्‍नि गटनां, दर्मसास्‍त्रमते रासि मत्‍तापे जर्गतां, लोकुल्‍कगुडा ओनतोनि अल्हेन कीतुर. इंचि ओर्क अर्तम आता. ");
INSERT INTO esg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","येसु लाजरुन बोंदाताल केय्‍सि जीवा अरहतदुन हूळता लोकुल्‍क, ओर हूळतदुना बारेमते गवाइ वेहतुर. ");
INSERT INTO esg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","येसु ई अद्‍बूतामाता चिन्‍ह हुपिस्तोर इंचि लोकुल्‍क केंजतुर, अदुनहाटीं ओर ओन्क कलियालय होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","पजा परिसिल्क, “मना पिलानकु बता कबळ्‍क ओज्जा हिल्‍लें. हुळाट, पूरा दुनियंता ओना पज्जो अरसि होंचंता,” इंचि ओरद-ओरे वळ्कालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","पंडुगुने मोळ्‍कालय वाता लोकुल्‍कुनाल इच्‍चुर युनानि लोकुल्‍क मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ओर गालिल राज्येमता बेतसेदा नाटेना, पिलिपनगा वासि, “महाराज, माकु येसुन कलियाना मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","इद पोल्‍ले पिलिप, अंदरियल इनानोंक वेहतोर. पजा पिलिप आनि अंदरियल इव्वुर कलियसि येसुंक वेहातुर. ");
INSERT INTO esg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","अस्‍के येसु इल्‍हा वेहालय दल्‍गतोर, “मनकना रूपमते पुटतोन नना, इंदके नावा महिमातुन हुप्‍सना वेला दग्गेर्क एव्ता. ");
INSERT INTO esg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","नना निजम-निजम वेहासेक, वंजि पेडे बूमिते अर्सि हासोन्‍नाकोंटे अद उंदे मनंता. गानि अद हासोंचि मोल्का वाते मात्रम पेद्‍दा बेर्सि वेल्‍लेन पेडेकुन तयार कींता. ");
INSERT INTO esg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","अल्‍हेने, बोरे आयिर! इद दुनियाते ओर ओना जीवातुन पावरम कींतोर, ओर ओना जीवातुन पोळागोटकुंतोर. गानि बोर अय्ते इद दुनियाते ओना जीवाता पर्वा किय्योर, ओर ओना जीवातुन बस्‍केळ्‍क पिस्सना पिस्वरहाटीं कापाळसि इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","बोर नावा सेवा कींतन इंतोर, ओर नावा पज्जो ताकना. बारित्‍ते नना बगा मनंतनो, अगा नावा सेवा कियानोरगुडा मना पींता. अल्‍हेने बोर नावा सेवा कींतोर, नावा बाबाल ओन्क कदर हींतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","इंदके नावा जीवा तकलिपते मंता. नना बतल इंदकन? बाबा, इद तकलिपता वेलाताल नाकुन तप्‍सा, इंचि इंदकना? इनोन. बारित्‍ते नना इद वेलाहाटींगे वातन. ");
INSERT INTO esg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","बाबा! नीवा पोरोल्क निमेन कदर हीम,” इंचि येसु इत्‍तोर. अल्हा इत्‍तस्के स्वर्गमताल उंदि अल्किर, “नना नावा महिमाता कदरतुन दीनकन्‍ना मुन्‍ने हीतन, मर्रा इंका हींतन,” इंचि केंजावाता. ");
INSERT INTO esg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","अद अल्किरतुन केंजसि अगा नित्‍तिसि मत्‍ता इच्‍चुर लोकुल्‍क, “मब्बु उरुमसंता रो!” इंचि इत्‍तुर. इंकिच्‍चुर बारे, “आयो, पेनदा दूता ओनतोनि वळ्कता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","अस्‍के येसु, “अद अल्किर नाहाटीं आयो, मीवाहाटीं वाता. ");
INSERT INTO esg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","इंदके इद दुनियाता न्‍यायम कियना वेला एवता. इद दुनियापोर्रो राज्येम कियना अदिकारिन पलाते पेचाहचि गेदमना वेला इंदके वाता. ");
INSERT INTO esg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","बस्के अय्ते नाकुन बूमिताल पोर्रोळ्‍क तेहमळ जर्गंतनो, अस्‍के अंटोर्कुन नाहेके इग्कुंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","इल्‍हा वळ्‍किसि येसु, ओन्क बसोंटा हामुर वायनद मंता इत्‍तदुन वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","अस्‍के लोकुल्‍क, “किरिस्‍तु बस्‍केळ्‍क जीवातेन मनंतोर, इंचि मोमोट मूसाना नियमते केंजतोम. अय्ते, मनकना रूपमते पुटतोन बूमिताल पोर्रोळ्‍क तेहांतुर, इंचि निमे बल्हा वेहा परंतिन? ई मनकना रूपमते पुटतोर बोर आंदुर?” इंचि येसुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","अस्‍के येसु, “वेलगु मीतोनि इंका जेरासेप मनंता. हीकट मीकुन मुच्‍चका मुन्‍नेन, वेलगुने मिमेट ताकसेके मंटु. बारित्‍ते हीकटते ताकानोर, ओर बगा दांतोर ओनद ओन्‍के तेळियो. ");
INSERT INTO esg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","मीकु इद वेलगुना संतानम आयानद मत्‍ते, मिहगा वेलगु मननेंकेन मिमेट दानपोर्रो विस्वासम इर्रट,” इंचि येसु ओर्क वेहतोर. वेहचि ओर्क दिसाकोंटा ओरागटाल होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","लोकुल्‍कुना मुन्‍ने येसु वेल्‍लेन अद्‍बूतामाता चिन्‍हें कीतोर. अयना ओर लोकुल्‍क येसुनपोर्रो विस्वासम इर्रा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","दीनहेंदाल, यसायाह इनना पेनदा कबुरतोर, एनकटा रासता पोल्‍ले, पुरागा आता. अद पोल्‍ले इल्‍हा मत्‍ता: “सामि! मोमोट वेहता कबुरतुन बोर नमतुर? पेनदा ताकततुन बोर्क हुपिचमळ जर्गता?” ");
INSERT INTO esg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ओर विस्वासम इर्रा पराहिल्‍लुर. बारित्‍ते, यसायाहल इंकुंदि जेगाते इल्‍हा रासतोर: ");
INSERT INTO esg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ओर ओरा कळ्‍कुन दिसाकोंटा कीतोर आनि ओरा मनसुन बंद कीतोर. अदुनहाटीं ओर कळ्‍कुने हूळा परसेक हिल्‍लुर, मनसुनाल ओर्क तेळियसेक हिल्‍ले. दीनहेंदाल ओर नाहेके तिरियुर, नना ओर्कुन बेस किय्योन.” ");
INSERT INTO esg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसायाहल येसुना महिमातुन हूळताहेंकेन ओना बारेमते ओर इव पोल्‍लें वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","अय्नागानि वेल्‍ले मंदि यहुदि अदिकारिल्‍क येसुनपोर्रो विस्वासम इरतुर. अव्टे यहुदि पेद्‍दाल्कगुडा मत्‍तुर. गानि परिसिल्कुंक तेळियते, ओर्कुन दर्मसास्‍त्रम कराहना लोते होळिया हिय्युर इत्‍ता वेर्रेक, ओर कुल्‍ला-कुल्‍ला ओप्कुनाकोंदुर. ");
INSERT INTO esg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","बारित्‍ते, ओराहाटीं पेनदाहेंदाल दोर्कना कदरकन्‍ना, लोकुल्‍कुनहेंदाल दोर्कना कदरे ओर्क एक्‍को पावरम. ");
INSERT INTO esg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","अस्‍के येसु वरगेय्‍सि, “बोर अय्ते नापोर्रो विस्वासम इर्रंतोर, ओर सिराप ना पोर्रेन आयो गानि, नाकुन लोहचीतोन पोर्रोगुडा विस्वासम इर्रंतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अल्हेन बोर अय्ते नाकुन हूळांतोर, ओर नाकुन लोहचीतोनगुडा हूळांतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","नापोर्रो विस्वासम इर्रनोर ओर बोरे आयिर, हीकटते मनानायो, इंचि नना इद दुनियाते वेल्‍गुनलेह्का वातन. ");
INSERT INTO esg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","बोरे आयिर, ओक्‍कला नावा पोल्‍लें केंजसिगुडा अवुन परकारम ताकाकोंटे, ओना न्‍यायम नना किय्योन. बारित्‍ते नना इद दुनियाते न्‍यायम कियालय वाया हिल्‍लेन, गानि इद दुनियातोर्कुन पिसागोटलय वातन. ");
INSERT INTO esg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","बोर अय्ते नाकुन हय्साका नावा पोल्‍लेन पिय्योर, ओना न्‍यायम कियनाहाटीं वेरे उंदि मंता. अद नना मीकु कराहता पोल्‍ले आंद. आकिर रोजुननाड ओना न्‍यायम नावा पोल्‍ले किय्‍यार. ");
INSERT INTO esg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","बारित्‍ते नना नावा मनसुंक वाताप वळ्का हिल्‍लेन, गानि नना बतल वळकना, बतल वेहना, इंचि नाकुन लोहचीता बाबाले नाकु आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ओना आदेस बस्‍केळ्‍क पिस्सना पिस्वरताहेके ओंता इंचि, नाकु एर्का मंता. अदुनहाटीं बाबाल नाकु बल्हा वेहना इंचि वेहतोरो, अल्हेन नना मीकु वेहचंतन,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","इद दुनियातुन होळसि पेनबाबानगा मल्सि होनना वेला दग्गेर्क एव्ता इंचि, येसुंक दाटसि होनना पंडुगुंकन्‍ना मुन्‍नेन तेळियता. इद दुनियाते मनना ओना लोकुल्‍कुन ओर वेल्‍लेन पावरम कीतोर. अचोने आयाका अद पावरमतुन आकिरदाका ओरपोर्रो हुपिच्‍चेकेन मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","येसु, ओना सिस्युल्क नर्कटा वेलाते गाटो तिनालय उद्‍दिस मत्‍तुर. गानि गाटो तिन्‍नका मुन्‍नेन देय्यम, इस्‍कारियोत नाटेना सिमोन इनानोना मर्रि यहुदन लोप्पो वासि, येसुंक दोका हियालय ओन एक्‍किसता. ");
INSERT INTO esg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","पेनबाबाल अन्‍नि अदिकाराल्‍क येसुना कय्‍दुक हीतोर, इंका ओर पेनदागटाल वातोर, पेनदागेन मल्सि दांतोर इत्‍तद अन्‍नि ओन्क एरपाटे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","अदुनहाटीं ओर गाटो तिनालय उद्‍दिस मत्‍तागटाल तेदतोर. तेदसि, केरसि मत्‍ता अंगितुन तेंडतोर. तेंडसि उंदि सेल्‍लातुन नडिक हुटतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","पजा उंदि गमेलाते एर पीसि सिस्युल्कुना काल्क नोरसेके, नडिक हुटसि मत्‍ता सेल्‍लाते उस्मालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","अल्हा कीसेके ओर सिमोन पत्रुनगा वातोर. अस्‍के पत्रु, “निमे नावा काल्क बारि नोरसंतिन सामि?” इंचि येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","अस्‍के येसु, “नना कियानद नीकु इंदके अर्तमायो, गानि मुन्‍ने-मुन्‍ने नीके तेळियार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पजा पत्रु, “निमे नावा काल्क बस्‍केने नोरमा,” इंचि इत्‍तोर. अस्‍के येसु, “ननागिंटा नीवा काल्क नोर्रकोंटे, निमे नावोन आया परिन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","अस्‍के सिमोन पत्रु, “अय्ते सिराप नावा काल्के आयो, नावा कय्‍कुन, नावा तल्‍लातुनगुडा नोर्रा सामि!” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","पजा येसु, “बोर अय्ते एर तुंगतोर, ओर बेस साप मनंतोर. ओर सिराप काल्क नोरकुत्‍ते सालु. अल्हेन मिमेट बेस साप मंतिर, गानि मिहागटाल अंटोर बेस साप हिल्‍लिर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ओन्क दोका हियानोर बोर इंचि, ओन्क एरपाट मत्‍ता. अदुनहाटीं ओर, “मिहागटाल अंटोर बेस साप हिल्‍लिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ओरां अंटोरा काल्क नोरमळ आता पजा, येसु अंगि केरसि, मुन्‍ने उद्‍दिस मत्‍ता जेगाते होंचि उद्तोर. उद्‍दिस इल्‍हा वळ्कालय दल्‍गतोर, “नना मीकु बतल कीतन, मीकु अर्तम आतना? ");
INSERT INTO esg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","16","मिमेट नाकुन गुरु, सामि इंचि केयंतिर. नना गुरु, सामिन आंदुन, अदुनहाटीं मिमेट इनानद बरोबरे. नना गुरुन, सामिन आसिगुडा मीवा काल्क नोरतन. अय्ते मिमेटगुडा वरोना काल्क वरोर नोरसेके सेवा कियना. नना मीकु निजम-निजम वेहासेक, वरोर दासि मनकल ओना मालकुंकन्‍ना पेद्‍दा आयोर. अल्हेन वरोर कबुरतोर ओन लोहतोनकन्‍ना पेद्‍दा आयोर. नना बल्हा अय्ते कीतनो, अल्हेन मिमेटगुडा कियना इंचि, इद उंदि उदाहरन हुपिस्तन. ");
INSERT INTO esg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","इंदके इव पोल्‍लें मीकु तेळियतां. अदुनहाटीं मिमेट इवुन पीसि ताकतिरित्‍ते, पेन मीकु आसिर्वाद हींता.” ");
INSERT INTO esg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“नना मी अंटोरा बारेमते वळ्कसेक हिल्‍लेन. नना बोर्कुन अय्ते पेर्कुत्‍तन, ओरा बारेमते नाक बेस एरपाट. गानि, ना हारि तित्‍तोरे नाकु अड्‍डम आतोर, इल्‍हा दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍ले पुरागा आयना इंचि इल्‍हा जर्गपींता. ");
INSERT INTO esg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","इल्‍हा जर्गतस्के, ओन ननाने आंदुन, इंचि मिमेट विस्वासम कियनाहाटीं, इव पोल्‍लें जर्गका मुन्‍नेन मीकु वेहासेक मंतन. ");
INSERT INTO esg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","नना निजम-निजम वेहासेक, नना लोहतोन, बोर अय्ते स्विकार कींतोर, ओर नाकुन इंका स्विकार कींतोर. नाकुन स्विकार कियानोर, ओर नाकुन लोहचीतोनगुडा स्विकार कींतोर,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","इव पोल्‍लें वळ्‍कुड आतस्के येसुंक मनसुने बादा अनपिस्ता. पजा ओर, “नना निजम-निजम वेहासेक, मीवा लोप्पोटाल वरोर नाकुन दोकाते पीसि हींतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","येसु बोना बारेमते वळ्कतोरो इंचि तेळियका, सिस्युल्क वरोना मोकोम वरोर हूळकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","येसुना सिस्युल्‍कुनाल येसु बोन अय्ते पावरम कियुंदुरो, ओर येसुना दग्गेरेन उद्‍दिस मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","अय्ते सिमोन पत्रु, “येसु बोना बारेमते इंचंतोरो पूस कीम,” इंचि ओन्क कय सय्गे कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","अस्‍के आ सिस्युड इंकिच्‍चो येसुनेके जर्गिसि येसुना रोमबोच्‍चेतगा तला इरसि, “ओर बोर आंदुर सामि?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","अस्‍के येसु, “नना ई हारि तुकडातुन कुसिटे मुळ्‍हाचि बोनकय्ते हींतन, ओरे आंदुर,” इंचि जवाब हीतोर. पजा हारि तुकडातुन कुसिटे मुळ्‍हाचि इस्‍कारियोत नाटेना सिमोनुना मर्रि यहुदांक हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","यहुदल हारि तुकडा एतता एतमळे, ओन देय्यम पीता. अस्‍के येसु यहुदन, “निमे कियनद बतलो, अद बिराना कीम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","गानि येसु ओन अल्हा बारि इत्‍तोर इत्‍ता संगति मात्रम अगा तिनालय उद्‍दिस मत्‍तोर्कुंक बोर्के अर्तम आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","कोत्‍तना जोरा यहुदानगेन मनुंदु. अदुनहाटीं पंडुगुंक अव्‍सरम मत्‍ता बतलन्‍ना सामान अस्सि तर्रालय वेहतोर बारे, इंचि इच्‍चुर इनकुत्‍तुर. इंकिच्‍चुर बारे, अव्टेटाल इच्‍चुं गरिब लोकुल्‍कुंक हीम इंचि वेहतोर आंद, इंचि इनकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","पजा यहुदल हारि एत्‍कुंचि, बिराना पलाते होत्‍तोर. अस्‍के वेल्‍लेन नर्का आसि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यहुदल पलाते होत्‍तस्के, येसु इल्‍हा वेहालय दल्‍गतोर. “मनकना रूपमते पुटतोंक नाकु, महिमा दोर्कना वेला इंदके एव्ता. नाकु जर्गना अन्‍निटवुनहेंदाल पेनदुक महिमाता कदर दोर्कार. ");
INSERT INTO esg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","नावाहेंदाल पेनदुक महिमाता कदर दोर्कानय्ते, पेन नाकु दाना कदर हिय्यार. अद आल्सेम कियाकोंटा बिरानेन हींता. ");
INSERT INTO esg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","नावा पिलाल्कनिटा! नना इंका गडसेम मीवातोनि मनंतन. पजा मिमेट नाकुन पहककिर. यहुदिल्कुना पेद्‍दाल्कुंक, नना बगा दांतन, अगा मिमेट वाया परिर, इंचि बल्हा नना वेहतनो, अल्हेन मीकुगुडा वेहचंतन. ");
INSERT INTO esg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","अदुनहाटीं नना मीकु उंदि पूना आदेस हीसंतन, मिमेट वरोंक-वरोर पावरम कीम्‍टु. नना मीकुन बल्हा पावरम कीतन, अल्हेन मिमेटगुडा वरोंक-वरोर पावरम कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","मीवा वरोनद वरोर पावरम कियमळतुन हूळसि, मिमेट नावा सिस्युल्क आंदिर, इंचि अंटोर लोकुल्‍कुंक तेळियसि दांता,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","पजा सिमोन पत्रु, “निमे बेके दांतिन सामि?” इंचि पूसकीतोर. अय्ते येसु, “नना होनानगा, निमे इंदके वाया परिन. गानि नना होत्‍तंका पज्जोटाल वाकिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","गानि पत्रु, “इंदके नना नीतोनि बारि वाया पर्रोन सामि? नीवाहाटीं नना नावा जीवा हियालयगुडा तयार मंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","अस्‍के येसु, “बतल! निमे नावाहाटीं जीवा हींतिना? नना नीकु निजम-निजम वेहासेक, निमे मूड मल्कां, नाकुन एरपाट किय्योन, इंचि इंदकिन, अस्‍केन गोगोड कूसार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","इंका येसु, “मिमेट मीवा मनसुन कस्‍टमते वाटमट. पेनदापोर्रो विस्वासम इर्रट, इंका ना पोर्रोगुडा विस्वासम इर्रट. ");
INSERT INTO esg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","नावा बाबाना लोते वेल्‍लेन अर्रां मंतां. ओक्‍कला हिलाकोंटे मंचि मत्‍ते, मीवाहाटीं जेगा तयार कियालय होंचंतन इंचि, नना मीकु वेहचि मन्‍नेन. ");
INSERT INTO esg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","नना होंचि अवुन सदुरतंका, मल्सि वासि मीकुन ओंतन. अस्‍के नना मनानगेन, मिमेटगुडा मंदकिट. ");
INSERT INTO esg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","नना होनना हर्रि अय्ते मीकु एर्का मंता,” इंचि सिस्युल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","अस्‍के तोमल, “निमे बेके होंचंतिनो माकु अय्ते एरपाटे हिल्‍ले सामि! असोंटस्के, माकु नीवा होनना हर्रि बल्हा तेळियंता?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","पजा येसु, “हर्रि, सत्‍तेम, आनि पिस्वर ननाने आंदुन. नाकुन होळसि बाबानगा बोरे एव्‍वा परोर. ");
INSERT INTO esg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","नना बोन आंदुन, इंचि मिमेट एरपाट कीसि मत्‍ते, नावा बाबान इंका मिमेट एरपाट कीसि मन्‍नेर. इंदकेटाल मिमेट ओन एरपाट कींतिर, ओन हूळतिरगुडा,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","अस्‍के पिलिप, “सामि, माकु बाबान हुपिस्ते, अचोने सालु,” इंचि येसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","अस्‍के येसु ओन्क इल्‍हा वेहतोर, “नना इच्‍चुं रोजकुनाल मीवातोने मंतन, अयना निमे नाकुन एरपाट किया हिल्‍लिना पिलिपु? नाकुन हूळतोर, ओर बाबान हूळतोर. अयना, माकु बाबान हुप्‍सा, इंचि निमे बल्हा इंचंतिन? ");
INSERT INTO esg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","नना बाबाना लोप्पो, बाबाल नावा लोप्पो मंतोर. इदुन निमे विस्वासम कीसेक हिल्‍लिना? नना वेहना पोल्‍लें ना इच्‍चटा नना वेहसेक हिल्‍लेन, गानि नावा लोप्पो मनना नावा बाबाल, ओना कबाह्‍कुन नाहेंदाल कीकुंचंतोर. ");
INSERT INTO esg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","नना बाबाना लोप्पो, बाबाल नावा लोप्पो मंतोर इत्‍ता पोल्‍लेपोर्रो मिमेट विस्वासम इर्रट. हिलाकोंटे नना कियना कबाह्कुनहेंदाल अयना नाकुन विस्वासम कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","नना मीकु निजम-निजम वेहासेक, बोर अय्ते नाकुन नम्मंतुर, ओरगुडा नना कियनसोंटा कबाह्‍क कियानुर. अचोने आयका नना कियना कबाह्कुंकन्‍ना पेद्‍दा-पेद्‍दा कबाह्‍क कियानुर. बारित्‍ते नना नावा बाबानाहेके होंचंतन. ");
INSERT INTO esg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","अदुनहाटीं, मिमेट नावा पोरोल्ते बतल तल्‍किना, नावा बाबांक महिमा वायानाहाटीं नना अदुन कींतन. ");
INSERT INTO esg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ओक्‍कला मिमेट ना पोरोल्ते बतल तल्‍किना, अद नना कींतन.” ");
INSERT INTO esg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“मिमेटगिंटा नाकुन पावरम कीते, नना वेहता आदेसकुन पीसि ताकट. ");
INSERT INTO esg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","अस्‍के नना बाबांक विनंति कींतन. बाबाल मीवाहाटीं बस्‍केळ्‍क मीवातोनि मनालय इंकावरोर सहायम कियानोन हींतोर. ");
INSERT INTO esg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","आ सहायम कियानोर इत्‍ते, पवित्र आत्मा मीकु सत्‍तेमतुन हुप्‍संता. दुनियातोर दानहेके हूळसेक हिल्‍लुर, दान एरपाट कीसेक हिल्‍लुर. अदुनहाटीं अद दुनियातोर्क दोर्को. गानि मिमेट दान एरपाट कींतिर. बारित्‍ते अद मीवातोनि मंता आनि पजा मीवा लोप्पेन मन्‍नार. ");
INSERT INTO esg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","नना मीकुन दिक्‍कु हिलवोरलेह्का होळसि होन्‍नोन, नना मिहगा मल्सि वांतन. ");
INSERT INTO esg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","इंका कोन्‍नि रोजकु आता पज्जो, दुनियातोर नाकुन हूळा परुर, गानि मिमेट नाकुन हूळा परकिट. बारित्‍ते नना जीवातेन मनंतन, मिमेट इंका जीवातेन मंदकिर. ");
INSERT INTO esg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","अल्हा जर्गतस्के, नना बाबाना लोप्पो, मिमेट ना लोप्पो, नना मीलोप्‍पो मंतन इंचि मीकु तेळियार. ");
INSERT INTO esg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","बोर अय्ते नना वेहता आदेसकुन स्विकार कीसि अवुन पीसि ताकंतोर, ओरे नाकुन पावरम कियानोर आंदुर. बोर अय्ते नाकुन पावरम कींतोर, ओन नावा बाबालगुडा पावरम कींतोर. पजा ननागुडा ओन पावरम कीसि, नना कुद्‍दु ओन्क दिस अरकन,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","पजा इस्‍कारियोत नाटेनोर आयका, इंकावरोर यहुदल, “सामि, निमे माके बारि दिस अरकिन? दुनियातोर्कुंक बारि दिस्सिन?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","अस्‍के येसु ओन्क जवाब हीतोर, “नाकुन पावरम कियानोर अंटोर नना वेहता पोल्‍लेनपोर्रो ताकंतुर, आनि नावा बाबाल ओर्कुन जीवा कींतोर. असंटोनगा मोमोट होंचि ओनालोप्‍पो जेगा पींतोम. ");
INSERT INTO esg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","नाकुन पावरम कियवोर, ओर नावा पोल्‍लेनपोर्रो ताकोर. मिमेट केंजना पोल्‍लें नावां आयों, गानि नाकुन लोहचीता बाबानव आंदुं. ");
INSERT INTO esg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","इव पोल्‍लें नना मीवातोनि मननेंकेन वेहतन. ");
INSERT INTO esg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","अय्नागानि, बाबाल नावा पोरोल्ते लोहना सहायम कियानोर, इत्‍ते पवित्र आत्मा, मीकु अन्‍नि पोल्‍लें करहार. अचोने आयका, नना मीकु वेहता अन्‍नि पोल्‍लें अद मीकु मति कीसि हिय्यार. ");
INSERT INTO esg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","नना मीकु सांतितुन हीसि होंचंतन. दुनिया हियानसोंटा सांति आयो, गानि नना नावा सांतितुन मीकु हीसंतन. अदुनहाटीं मिमेट मीवा मनसुन कस्‍टमते वाटमट, वेरिया हियमट. ");
INSERT INTO esg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","नना लक्‍कु होंचंतन, गानि मर्रा तिरियसि मीहेके वांतन, इंचि नना मीकु वेहचि मत्‍तन, अदुन मिमेट केंजतिरे गदा! अय्ते, मिमेट नाकुन निजम पावरम कियानय्ते, नना बाबानाहेके होंचंतन इंचि वेहतस्के मिमेट कूस आसि मंदकिट. बारित्‍ते बाबाल नाकन्‍ना पेद्‍दोड आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","इव अन्‍नि पोल्‍लें निजम आयनुं अस्‍के, मिमेट विस्वासम कियगोम इंचि, नना इव पोल्‍लें जर्गका मुन्‍नेन वेहतन. ");
INSERT INTO esg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","इंका मीतोनि एक्‍को वळ्‍कोन. बारित्‍ते दुनियापोर्रो राज्येम एलाना अदिकारि वासेकेन मंतोर. वासि अयना नावापोर्रो ओन्क बतले अदिकारम हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","अयना, नना बाबान पावरम कींतन इत्‍ता पोल्‍ले, दुनियाक तेळियगोम इंचि, बाबाल नाकु हीता आदेस परकारमे नना कींतन. सरे तेदट! मनम इगेटाल दाकोम,” इंचि येसु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","येसु इल्‍हा वेहतोर. “निजम अंगुर वेलितसंटोन ननाने आंदुन. नावा बाबाल बारे अंगुर तोटातुन बेस हूळकुनानोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","नावा पंगानाल बव पंगांक अय्ते कायां हादोंगो, अवुन ओर नरकिस पोहांतोर. आनि हादाना पंगान बारे, इंका बेस हादगोम इंचि अवुना कोस्‍सन कत्रिच्‍चंतोर. ");
INSERT INTO esg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","दीनकन्‍ना मुन्‍ने नना मीकु वेहता पोल्‍लेहेंदाल मिमेट साप आतिर. ");
INSERT INTO esg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","मिमेट नावातोनि बस्‍केळ्‍क कलियसि मंटु, अस्‍के ननागुडा इंका मीवातोनि बस्‍केळ्‍क कलियसि मनंतन. पंगा वेलिक अंटिस मनाकोंटे दान्क कायां हादों, अल्हेन मिमेटगुडा नावातोनि कलियसि मनाकोंटे बेसता कबाह्‍क किया परिर.” ");
INSERT INTO esg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ननाने अंगुर वेलितसंटोन आंदुन, मिमेट बारे पंगांनसंटोर आंदिर. बोर अय्ते नातोनि कलियसि मनंतुरो, नना बोरतोनि कलियसि मनंतनो, ओर वेल्‍लेन बेसता कबाह्‍क कींतुर. नाहगटाल वेरे आसि मंचि, मिमेट बतले किया परिर. ");
INSERT INTO esg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","बोर अय्ते नावातोनि कलियसि मन्‍नुरो, ओर्कुन कबळ्‍क ओज्जुवा पंगान पोहताप पोहचियमळ जर्गंता. पजा अव पंगां वत्‍तुतस्के, अवुन जमा कीसि तडमिते वाटसि बोळ्‍संतुर. ");
INSERT INTO esg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","मिमेट ना लोप्पो आनि नावा पोल्‍लें मीलोप्‍पो मनानय्ते, मीकु गावाले मत्‍तद बतल तल्‍किना, अद मीवाहाटीं कियमळ जर्गंता. ");
INSERT INTO esg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मिमेट वेल्‍लेन बेसता कबाह्‍क कियानय्ते नावा बाबांक वेल्‍लेन महिमा दोर्कंता. दीनहेंदाल मिमेट नावा सिस्युल्क इंचि दिस अर्रंतिर. ");
INSERT INTO esg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","नावा बाबाल नाकुन बल्हा पावरम कीतोर, अल्हेन नना मीकुन पावरम कीतन. मिमेट नावा पावरमते निलसि मंटु. ");
INSERT INTO esg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","नना नावा बाबाल वेहता आदेसकुनपोर्रो ताकसेके, ओना पावरमते निलसि मंतन. अल्हेन मिमेटगुडा नना वेहता आदेसकुनपोर्रो ताकतिरित्‍ते, नावा पावरमते निलसि मनंतिर. ");
INSERT INTO esg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","नावा कुसि मीलोप्‍पो मनना, आनि मीवा कुसि पुरागा आयना इंचि, नना मीकु इव पोल्‍लें वेहतन.” ");
INSERT INTO esg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“नना मीकुन बल्हा पावरम कीतनो, अल्हेन मिमेटगुडा वरोंक-वरोर पावरम कीकुंटु, इदे नावा आदेस आंदु. ");
INSERT INTO esg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","वरोर मनकल ओना दंटागानाहाटीं ओना जीवा हियमळकन्‍ना पेद्‍दा पावरम बद्‍दे आयो. ");
INSERT INTO esg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","नना हियना आदेसकुनपोर्रो गिंटा मिमेट ताकानय्ते, मिमेट नावा दंटातोर आंदिर. ");
INSERT INTO esg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","इंदकेटाल नना मीकुन दासुल्क इंचि केयोन. बारित्‍ते मालक बतल कींतोर अद ओना दासुंक बतल तेळियो. गानि नना अय्ते मीकुन दंटातोर इंचि केयंतन. बारित्‍ते नावा बाबाल नाकु वेहता अन्‍नि पोल्‍लें मीकु वेहतन. ");
INSERT INTO esg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","नाकुन मिमेट पेर्रा हिल्‍लिर, गानि मीकुन नना पेरतन. पेरसि, मिमेट बेसता कबाह्‍क कीसेक बेस पलम हियगोम, इंचि नना मीकुन निलाहतन. अल्हा कीते, मिमेट नावा पोरोल्ते बाबान बतल तल्किनागानि, अद मीकु दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","मिमेट वरोंक-वरोर पावरम कीकुंटु, इद मीकु नावा आदेस आंदु.” ");
INSERT INTO esg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ओक्‍कला दुनियातोर मीकुन हय्‍साकोंटे, मीकन्‍ना मुन्‍ने ओर नाकुन हय्‍सा हिल्‍लुर, इंचि मीकु एर्के. ");
INSERT INTO esg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","मिमेट दुनियातोर्क नच्‍चताप मनानय्ते, ओर मीकुन पावरम कीसि मन्‍नेर. गानि मिमेट दुनियातोर्क नच्‍चताप मंचेके हिल्‍लिर. नना मीकुन इद दुनियाताल पेरतन. अदुनहाटीं दुनियातोर मीकुन हय्सुर. ");
INSERT INTO esg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","वरोर दासुड ओना मालकुंकन्‍ना पेद्‍दोड आयोर, इंचि नना दीनकन्‍ना मुन्‍ने वेहता पोल्‍लेतुन मिमेट मति इर्कुंटु. ओर नाकुने तकलिप कीतुर अय्ते, मीकुनगुडा तकलिप कींतुर. ओर नावा पोल्‍ले परकारम ताकानय्ते, मीवा पोल्‍ले पोर्रोगुडा ताकंतुर. ");
INSERT INTO esg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","नाकुन लोहचीतोन ओर एरपाट किय्युर, अदुनहाटीं ओर मीकुन नावा पोरोलहाटीं इव अन्‍नि तकलिप्क कींतुर.” ");
INSERT INTO esg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“उंदि वेला नना वासि ओरतोनि वळ्‍काकोंटा मंचि मत्‍ते, ओरपोर्रो पापम मना कोनवळ. गानि इंदके मात्रम ओर्क ओरा पापमताल तपिच्‍कुनालय हर्रि हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","नाकुन हय्सवोर, ओर नावा बाबान इंका हय्‍सोर. ");
INSERT INTO esg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","वेरे बोर किया हिल्‍लोर असोंटा, अद्‍बूतामाता कबाह्‍क नना कियाकोंटा मंचि मत्‍ते, ओरपोर्रो पापम मना कोनवळ. गानि इंदके ओर नना कीता अद्‍बूतामाता कबाह्‍कुन हूळसिगुडा, नाकुन, नावा बाबान हय्सेक हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","नाकुन हय्साकोंटा मनालय बतले कारनम हिलाकोन्‍ना ओर नाकुन हय्सुर, इंचि ओरा दर्मसास्‍त्रमते रासि मंता. अद पोल्‍ले पुरागा आयानाहाटींगें इल्‍हा जर्गता. ");
INSERT INTO esg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","गानि बाबानाहेंदाल नना लोहना सहायम कियानोर, इत्‍ते बाबानगटाल वायना सत्‍तेम आत्मा, बस्के अय्ते मिहगा वायार. अद मीकु नावा बारेमते गवाइ वेहंता. ");
INSERT INTO esg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","नना सेवा सुरुव कीतस्केटाल मिमेट नातोनि मत्‍तिर, अदुनहाटीं मिमेटगुडा नावा बारेमते गवाइ वेहंतिर.” ");
INSERT INTO esg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“मिमेट विस्वासमताल पजोळ्क आयामन्‍नि, इंचि मीकु इव पोल्‍लें वेहतन. ");
INSERT INTO esg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","विस्वासम कियवा पेद्‍दाल्क मीकुन दर्मसास्‍त्रम कराहना लोहकुनाल पेच्‍हांतुर. इंका मीकुन हव्कना हरेक मनकल, नना पेनदा सेवा कीसंतन, इंचि इनकुनना कालम वायाना मंता. ");
INSERT INTO esg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","बाबाल आनि नना बोर आंदुम, ओर्क तेळियो, अदुनहाटीं ओर मीकुन अल्हा कींतुर. ");
INSERT INTO esg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","अद कालम वातस्के, नना वेहता पोल्‍लें मीकु मति वायाना इंचि, इव पोल्‍लें नना मीकु वेहचंतन. इव पोल्‍लें नना मीकु मुन्‍ने वेहा हिल्‍लेन, बारित्‍ते नना मीतोने मत्‍तन.” ");
INSERT INTO esg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“नना अय्ते इंदके नाकुन लोहतोनगा मल्सि होंचंतन. गानि निमे बगा दांतिन इंचि मीवा लोप्पोटाल वरोरगुडा नाकुन पूसकीसेक हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","नना इव पोल्‍लें मीकु वेहताहेंका, मिमेट वेल्‍लेन दुक्‍कमते मंतिर. ");
INSERT INTO esg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","अयना नना मीकु निजम-निजम वेहासेक, नना मिहागटाल होत्‍ते, मीके पायदा आयार. बारित्‍ते नना होनाकोंटे सहायम कियानोर मिहगा वायोर. नना होनानय्ते ओन मिहगा लोहंतन. ");
INSERT INTO esg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ओर वातस्के पापम बारेमते, सत्‍तेम बारेमते आनि न्‍यायम बारेमते लोकुल्‍कुन ओप्‍संतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ओर नापोर्रो विस्वासम इर्रका पापम कीतुर, इंचि सहायम कियानोर ओर्क हुप्‍संतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","नना बाबानाहेके होंचंतन, मर्रा मिमेट नाकुन हूळा परिर. अदुनहाटीं सहायम कियानोर सत्‍तेमता बारेमते लोकुल्‍कुंक तेळियागोट्‍सि वेहंतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","इंका इद दुनियापोर्रो राज्येम एलाना अदिकारिना न्‍यायम अय्ते मुन्‍नेन आसि मंता. अदुनहाटीं सहायम कियानोर न्‍यायमता बारेमते लोकुल्‍कुंक तेळियागोट्‍सि वेहंतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","मीकु वेहालय नहगा इंका वेल्‍लेन पोल्‍लें मंतां, गानि अवुनंता इंदके ओर्सुकुना परिर. ");
INSERT INTO esg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","गानि सत्‍तेम आत्मा वातस्के, अद मीकु पूरा सत्‍तेमतुन हुप्‍सार. अद दाना मनसुंक वाताप वळ्को, गानि बतल अय्ते अद बाबानगटाल केंजंता, अदे वेहंता. इंका मुन्‍ने जर्गना बारेमतेगुडा वेहंता. ");
INSERT INTO esg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","अद नाहगटाल तेंडकुंचि, वासि मीकु वेहंता. अल्हा कीसेके अद नाकु कदर हींता. ");
INSERT INTO esg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","बव अय्ते बाबानवो, अव अन्‍नि नावां आंदुं. अदुनहाटींगे, अद नाहगटाल तेंडकुंचि, वासि मीकु वेहंता, इंचि नना मीकु वेहतन. ");
INSERT INTO esg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","इंका जेरासेप आते, मिमेट नाकुन हूळा परिर, पजा इंका जेरासेपुंक, मिमेट नाकुन मर्रा हूळकिर,” इंचि येसु सिस्युल्कुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","इद पोल्‍ले केंजसि, ओना इच्‍चुर सिस्युल्क वरोंक-वरोर पूसकीसेक, “इंका जेरासेप आते, मिमेट नाकुन हूळा परिर, पजा इंका जेरासेपुंक, मिमेट नाकुन मर्रा हूळकिर, बारित्‍ते नना बाबानगा दांतन, इल्‍हा मनाकु येसु बारि वेहचंतोर मरि? ");
INSERT INTO esg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","इंका जेरासेप आते इनना पोल्‍लेक अर्तम बतल? असल ओर इनानद बतलो मनाकु अर्तमे आसेक हिल्‍ले,” इंचि वळ्ककुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","सिस्युल्क ओन पूसकींतुर इंचि येसुंक तेळियता. अस्‍के येसु ओर्क इल्‍हा वेहतोर, “इंका जेरासेप आते, मिमेट नाकुन हूळा परिर, पजा इंका जेरासेपुंक, मिमेट नाकुन मर्रा हूळकिर, इत्‍ता नावा पोल्‍लेता बारेमते मिमेट वरोंक-वरोर बतां पूस कीकुंचंतिर? ");
INSERT INTO esg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","नना निजम-निजम वेहासेक, मिमेट मोत्‍कुंचि-मोत्‍कुंचि अळकिर, गानि दुनियातोर कुसिते मनानुर. मीकु दुक्‍कम वासि अळकिर, गानि मीवा दुक्‍कम कुसिते मारियंता. ");
INSERT INTO esg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","उंदि मुरतळ दाना एरपूराना वेला एवतस्‍के, नोप्‍पिं वासि वेल्‍लेन दुक्‍कमते मनंता. गानि दान्क पेडालो-पेगिडो पुटतस्के, उंदि जीवा दानहेंदाल इद दुनियाते वाता इत्‍ता कुसिते, मुन्‍ने बोगांच्‍ता तकलिपकु मर्रा दान्क मतिगुडा मन्‍नों. ");
INSERT INTO esg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","इदगुडा अल्हेन! इंदके दुक्‍कम वांता, गानि नना मीकु मर्रा कलियंतन अस्‍के, मिमेट वेल्‍लेन कूस आकिर. अद कुसितुन मिहागटाल बोरे तेंडकुना परुर. ");
INSERT INTO esg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","अद रोज मिमेट नाकुन बदे तल्किर. गानि नना निजम-निजम वेहासेक, मिमेट नावा पोरोल्ते बाबान बतल तल्किनागानि ओर मीकु अदुन हींतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","इदवेरदाका मिमेट ना पोरोल्ते बतले तल्का हिल्‍लिर. तल्‍कट मीकु दोर्कार, अस्‍के मीवा कुसि पूरा आयार.” ");
INSERT INTO esg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“इव पोल्‍लें नना मीकु उदाहरनकु हीसि वेहतन. गानि मुन्‍ने इंका बस्‍केने उदाहरनकु हीसि वेहोन. बाबाना बारेमते बल्हा मत्‍तद अल्हा कुल्‍ला कीसि वेहना वेला वायनद मंता. ");
INSERT INTO esg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","अद रोज मिमेट नावा पोरोल्ते ओन तल्ककिट. अस्‍के नना मीवाहाटीं बाबांक विनंति कींतन इंचि मीकु वेहासेक हिल्‍लेन. ");
INSERT INTO esg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","बारित्‍ते मिमेट नाकुन पावरम कीतिर, नना पेनदागटाल वातन इत्‍ता पोल्‍लेतुन विस्वासम कीतिर, अदुनहाटीं कुद्‍दु बाबाले मीकुन पावरम कीसंतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","नना बाबानगटाल इद दुनियाते वातन. इंदके मर्रा इद दुनियातुन होळसि बाबानाहेके होंचंतन,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","अस्‍के सिस्युल्क, “हूळा! इंदके निमे उदाहरन हीसि वळ्कसेक हिल्‍लिन, कुल्‍ला-कुल्‍ला वळ्‍कसंतिन. ");
INSERT INTO esg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","नीकुन बोरे बतल पूसकियना अव्‍सरम हिल्‍ले. नीकु अन्‍नि तेळियंता इंचि माकु एर्का मंता. दीनहेंदाल, निमे पेनदागटाल वातिन, इंचि मोमोट विस्वासम कींतोम,” इंचि येसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","अस्‍के येसु, “इंदके अयना मिमेट विस्वासम कींतिरा? ");
INSERT INTO esg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","हुळाट, नाकुन वरोने होळसि, मिमेट बेकेटोर हेके आसि बोना लोन ओर होनना वेला वायनद मंता, अद वासे मंता. अयना नना वरोन हिल्‍लेन, नातोनि बाबाल मंतोर. ");
INSERT INTO esg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","नाहगटाल मीकु सांति दोर्कि, इंचि इव पोल्‍लें मीकु वेहतन. दुनियाते मीकु तिप्‍पल्‍क-कस्‍टाल्‍क वायनुं, गानि नना दुनियाता ताकततुन गेल्सतन, अदुनहाटीं मिमेट बेस दैरनेमते मंटु,” इंचि येसु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","4","इव अन्‍नि पोल्‍लें वेहमळ आतस्के, येसु पोर्रो स्वर्गमताहेके हूळसेक इल्‍हा पारतना कियालय दल्‍गतोर. “बाबा, अंटोर लोकुल्‍कुनपोर्रो निमे नाकु अदिकारम हीतिन. दीनहेंदाल निमे बोर्कुन अय्ते नाकु हीतिनो, ओर्क अंटोर्क नना बस्‍केळ्‍क पिस्सना पिस्वर हीकन. निमे वरोने सत्‍तेम पेनदुन आंदिन, बोर अय्ते नीकुन, निमे लोहता येसु किरिस्‍तुन एरपाट कींतुरो ओर्के आ बस्‍केळ्‍क पिस्सना पिस्वर दोर्कंता. निमे नाकु बव कबाह्‍क अय्ते कियालय हीतिनो, अवुन पुरागा कीसि, नना बूमिपोर्रो नीवा महिमा कीतन. इंदके नावा वेला एव्ता. अदुनहाटीं निमे नाकु कदर हीते, नना नीवा महिमा कींतन. ");
INSERT INTO esg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","बाबा, दुनिया पुट्‍टका मुन्‍ने नना नीतोनि मननेंके बसोंटा महिमा मत्‍तानो, असोंटा महिमा इंदकेगुडा नी मुन्‍ने हीम.” ");
INSERT INTO esg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ई दुनियाताल निमे नाकु हीता लोकुल्‍कुंक, नना नीवा पोरोल्तुन हुपिस्तन. ओर बस्‍केळ्‍क नीवोर्के आंदुर. ओर्कुन निमे नाकु हीतिन. ओर नीवा पोल्‍लेपोर्रो ताकतुर. ");
INSERT INTO esg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","निमे बतल अय्ते नाकु हीतिनो, अव अन्‍नि निहेंदाले दोर्कतव इंचि इंदके ओर्क तेळियता. ");
INSERT INTO esg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","बारित्‍ते बव पोल्‍लें अय्ते निमे नाकु हीतिनो, अवुन नना ओर्क एविच्‍तन. ओर अवुन ओप्‍कुत्‍तुर. नना निजम निहागटाले वातन, नाकुन निमेन लोहतिन इंचि ओर विस्वासम कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ईराहाटींगे नना पारतना कीसंतन. दुनियाताहाटीं आयो. निमे बोर्कुन अय्ते नाकु हीतिनो, ओर नीवोरे इंचि ओराहाटींगे नना पारतना कीसंतन. ");
INSERT INTO esg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","नहगा मनना अन्‍नि पोल्‍लें नीवंगें आंदुं, नीवां अन्‍नि पोल्‍लें नावां आंदुं. अवुनहेंदाल नाकु महिमा दोर्कता. ");
INSERT INTO esg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","इंदकेटाल नना इद दुनियाते मनोन. नना निहगा वासंतन. गानि ईर ई दुनियाते मनंतुर. पवित्र बाबा! इंदके मनम उंदि आसि मत्‍ताप, ईरगुडा उंदि आसि मनालय, निमे नाकु हीता नीवा पोरोलता ताकतते ईरकुन कापाळा. ");
INSERT INTO esg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","नना ई दुनियाते ईरतोनि मननेंके, निमे नाकु हीता नीवा पोरोलता ताकतते ओर्कुन कापाळतन. सिराप, दर्मसास्‍त्रमते रासता पोल्‍ले पूरा आयनाहाटीं बोर अय्ते नासडेम आयना मत्‍ता ओन होळसि, वेरे बोरे नासडेम आया हिल्‍लुर, नना ओर्कुन कापाळतन. ");
INSERT INTO esg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","नना इंदके निहगा वासंतन. गानि नावा आनंदम ओरा लोप्पो पुरागा आयना इंचि, इव पोल्‍लें नना इद दुनियाते मननेंकेन वेहंतन. ");
INSERT INTO esg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","नीवा पोल्‍ले नना ईरकु वेहतन. नना इद दुनियातोन आयोन. अल्हेन ईरगुडा इद दुनियातोर आयुर. अदुनहाटीं ई दुनियातोर ईरकुन हय्सेक हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","निमे ईरकुन इद दुनियाताल ओम इंचि नना पारतना कीसेक हिल्‍लेन, गानि पेद्‍दा देय्यमताल ईरकुन कापाळा इंचि पारतना कीसंतन. ");
INSERT INTO esg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","नना ई दुनियातोन आयोन, अल्हेन ईरगुडा ई दुनियातोर आयुर. ");
INSERT INTO esg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","नीवा पोल्‍ले सत्‍तेम आंद, नीवा सत्‍तेमते ओर्कुन पवित्र कीम. ");
INSERT INTO esg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","बल्हा अय्ते निमे नाकुन ई दुनियाते लोहतिन, अल्हेन नना ईरकुन दुनियाते लोहंतन. ");
INSERT INTO esg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","नीवा सत्‍तेमते ओर पवित्र आयगोम इंचि, नावद ननेन उंदि पवित्र मोक्‍कुनलेह्का आतन.” ");
INSERT INTO esg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“नना सिराप ईराहाटींगे पारतना कीसेक हिल्‍लेन, गानि बोर अय्ते ईर वेहना पोल्‍लेतुन केंजसि नापोर्रो विस्वासम इर्रंतुर, ओराहाटींगुडा नना पारतना कीसंतन. ");
INSERT INTO esg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","बाबा! बल्हा अय्ते निमे नहगा, नना निहगा उंदि आसि मंतोमो, अल्हेन ओरगुडा उंदि आसि मननाहाटीं पारतना कीसंतन. नाकुन निमेन लोहतिन, इंचि दुनियातोर विस्वासम कियना इत्‍ते, ओरगुडा मनांटे उंदि आयापींता. ");
INSERT INTO esg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","निमे ना लोप्पो मंतिन, नना नी लोप्पो मंतन. निमे नाकु हीता कदरतुन नना ओर्क हीतन. मनम इंदके बल्हा उंदि आसि मंतोमो, अल्हेन ओरगुडा उंदि आसि मंदना. अल्हा मत्‍तेने, नाकुन निमे लोहतिन आनि नाकुन पावरम कीताप ओर्कुनगुडा पावरम कीसंतिन, इंचि दुनियाक एरपाट आयापींता.” ");
INSERT INTO esg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“बाबा! बोर्कुन अय्ते निमे नाकु हीतिनो, ओर निमे नाकु हीता कदरतुन हूळानाहाटीं, नना बगा मत्‍ते अगा ओरगुडा मनना इंचि, नना पारतना कीसंतन. बारित्‍ते इद दुनिया पुट्‍टका मुन्‍नेन निमे नाकुन पावरम कीतिन. ");
INSERT INTO esg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","बाबा! निमेन नीतिमंतुन आंदिन. ई दुनिया नीकुन एरपाट किय्‍यो. गानि नना एरपाट कींतन. अल्हेन नाकुन निमेन लोहतिन इंचि ई सिस्युल्क एरपाट कींतुर. ");
INSERT INTO esg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ना पोर्रोटा नीवा पावरम ओरा लोप्पो मननाहाटीं आनि ननागुडा ओरा लोप्पो मनना इंचि, नीवा पोरोल्तुन ओर्क एरपाट कीसीतन. इंका मुन्‍नेगुडा एरपाट कीसि हीसेक मनंतन,” इंचेके येसु पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","इव पोल्‍लें वळ्‍कमळ आतंका, येसु ओना सिस्युल्कुनतोनि, किद्रोन इनना कुरेटा लोद्‍दि दाटसि हब्बेटा बाजुंक होत्‍तुर. अगा जय्‍तुन मराकुना तोटा मत्‍ता, आ तोटाते येसु, ओना सिस्युल्क होळियतुर. ");
INSERT INTO esg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","येसु ओना सिस्युल्कुनतोनि अद तोटाते वेल्‍लेन मल्कां वासि मत्‍तोर. अदुनहाटीं ओन्क दोका हियना यहुदांकगुडा अद जेगा एरपाट मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","अय्ते यहुदल सिपाइल्कुना गेंगुन, पेद्‍दा पेर्मालोर, परिसिल्क लोहता गुळितगा कावेल कियानोर्कुन पीसि अगा वातोर. ओरतोनि दिव्टीं, कंदिलिं, लडाइ कियना विस्रें मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ओन्क बतल जर्गनद मंता इत्‍तदुन एरपाट कीसि, येसु मुन्‍नेळ्‍क होत्‍तोर. होंचि, “मिमेट बोन पहकसंतिर?” इंचि ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","अस्‍के ओर, “नासरेत नाटेना येसुन पहकसंतोम,” इंचि जवाब हीतुर. पजा येसु, “ओन ननाने आंदुन,” इंचि इत्‍तोर. येसुंक दोका हियना यहुदलगुडा ओरतोनि निलसि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","येसु ओर्कुन, “ओन ननाने आंदुन,” इंचि इत्‍तस्के, ओर पजोळ्क जरगिसि बूमिपोर्रो अरतुर. ");
INSERT INTO esg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","येसु, “मिमेट बोन पहकसंतिर?” इंचि मर्रा उंदि मल्का पूसकीतोर अय्ते ओर, “नासरेत नाटेना येसुन पहकसंतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","अस्‍के येसु, “ओन ननाने आंदुन इंचि वेहतन गदा! ओक्‍कला मिमेट नाकुन पहकानय्ते, ईरकुन होना हीम्टु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","बारित्‍ते, “निमे नाकु हीतोरव्टेटाल, नना वरोनिंका तप्‍सोना हिय्या हिल्‍लेन,” इंचि ओर इत्‍ता पोल्‍ले पुरागा आयगोम इंचि अल्हा इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","सिमोन पत्रु इनना सिस्युनगा उंदि पेद्‍दा कसेर मत्‍ता. ओर अद कसेटे वरोन हीतोर अय्ते, पेद्‍दा पेर्माना वरोर जीतागाना तिना केव नेमसि अरता. आ जीतागान पोरोल मल्कोसि. ");
INSERT INTO esg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","गानि येसु, “नीवा कसेर दाळोतगा इर्रा. नावा बाबाल नाकु हीता तिप्पलता वाटिते नना उना मन्‍निआ?” इंचि पत्रुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","अस्‍के अगा वाता सिपाइल्कुना गेंग, ओरा दरोगाल आनि गुळितगा कावेल कियानोर येसुन दोर्कापीसि दोह्‍चि वाटतुर. दोह्‍चि वाटसि, मोट्‍टा मोदाला ओन हन्‍ना इनानोनगा ओतुर. ई हन्‍नाल कयपा इनानोना मामाल आंदुर. अद वर्सा ई कयपाल पेद्‍दा पेर्माल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“लोकुल्‍कुनाहाटीं वरोर मनकल हाते बेसे,” इंचि यहुदि पेद्‍दाल्कुना मुन्‍ने वळ्‍किसि मत्‍तोर, ओर ईरे कयपाल आंदुर. ");
INSERT INTO esg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","येसुन अल्हा पीसि होननेंके सिमोन पत्रु आनि इंकावरोर सिस्युड, येसुन पज्जो होत्‍तुर. आ सिस्युड पेद्‍दा पेर्माना एर्कातोर मत्‍ताहेंका, पेद्‍दा पेर्माना दाराते येसुनतोनि ओरगुडा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","गानि पत्रु पलाते गलमातगेन नित्‍तिसि मत्‍तोर. अदुनहाटीं पेद्‍दा पेर्मांक एर्का मत्‍ता आ सिस्युड पलाते वासि, गलमातगा देकरेकहाटीं मत्‍ता मुरतटुन पूस कीसि, पत्रुन लोप्पो केय्‍सि तत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","गलमातगा देकरेकते मत्‍ता आ पासि कबळ कियाना मुरतळ, “निमेगुडा आ मनकना सिस्युल्‍कुनाल वरोन आंदिन गदा!” इंचि पत्रुन पूसकीता. अय्ते पत्रु, “नना आयोन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","अद वेलाते वेल्‍लेन पीनि मत्‍ता. अदुनहाटीं सेवाकुल्क आनि गुळितगा कावेल कियानोर, तडमि मासि, सेका कासेके मत्‍तुर. अगा पत्रुगुडा ओरतोनि नित्‍तिसि आरसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","पजा पेद्‍दा पेर्माल येसुन, ओना सिस्युल्कुना बारेमते आनि ओना कराहमळ बारेमते पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","अस्‍के येसु, “नना अंटोरा मुन्‍ने कुल्‍ला-कुल्‍ला वळ्‍कतन, यहुदिल्क अंटोर जमा आयना दर्मसास्‍त्रम कराहना लोह्कुने, गुळिने नना बस्‍केळ्‍क कराहतन. नना मक्‍किचि बतले वळ्का हिल्‍लेन. ");
INSERT INTO esg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","अयना इद सवाल नाकुन बारि पूसकीसंतिन? नना वेहतदुन केंजतोर्कुन पूस कीम, ओर्क एरपाटे नना बतल वेहतन,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","येसु अल्हा इत्‍तस्के, दग्‍गेरा नित्‍तिसि मत्‍ता वरोर गुळितगा कावेल कियानोर, “पेद्‍दा पेर्मांक इल्हेन जवाब हींतिना?” इंचि येसुना सेंपापोर्रो तंतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","अस्‍के येसु, “नना वळ्कतव्टे बतलन्‍ना तप्पु मत्‍ते इगे अंटोर्क वेहाट. गानि नना वळ्कतद निजम आते, नाकुन तनंतिर बारि?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","पजा आ हन्‍नाल, दोह्‍चि मननेंकेन येसुन कयपा इनना पेद्‍दा पेर्मानेके लोह्‍चीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","सिमोन पत्रु तडमितगा सेका कासेके मत्‍तस्के, अगा मत्‍तोर इच्‍चुर लोकुल्‍क ओन, “निमेगुडा ओना सिस्युल्‍कुनाल वरोन आंदिन गदा?” इंचि पूसकीतस्‍के, “नना आयोन,” इंचि पत्रु आबद्‍दम वळ्कतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","पत्रु बोना केव्‍दुन अय्ते नर्कतोरो, ओना जीवातोर वरोर, पेद्‍दा पेर्मानगा सेवा कीसेक मत्‍तोर. ओर पत्रुन, “अद रोजु जय्‍तुन मराकुना तोटाते नीकुन नना, ओनतोनि हूळतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","मर्रागुडा पत्रु, “नना आयोने आयोन,” इंचि आबद्‍दम वेहतोर. ओर अल्हा इत्‍ता इन्‍मळे, गोगोड कूसता. ");
INSERT INTO esg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","पजा हक्‍केरेन येसुन ओर कयपानगटाल रोम सरकारता राज्यपालना राजवाडाते ओतुर. अस्‍के रिवाज परकारम अपवित्र आयाकोंटा मनालय आनि दाटसि होनना पंडुगुना गाटो तिनगोम, इंचि ओर राजवाडाते नेंगा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","अदुनहाटीं रोम सरकारता राज्यपाल पिलातुस, पलाते ओरगा वासि, “ई मनकनपोर्रो मिमेट बद कसूर ताससंतिर?” इंचि ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","अस्‍के ओर, “ईर कसूर कियाकोंटे मंचि मत्‍ते, मोमोट ईन नीकु अप्पजेप्पा कोन्‍नेरम,” इंचि जवाब हीतुर. ");
INSERT INTO esg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","“अल्हा अय्ते ओन ओसि, मीवा सतता नियम परकारम मिमेटे ओना न्‍यायम कीम्‍टु,” इंचि पिलातुस इत्‍तोर. अस्‍के यहुदिल्क, “हामुर सिक्‍सा हियना अदिकारम सिराप, रोम सरकारुंके मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","अद अल्हा बारि जर्गता इत्‍ते, येसुंक बसोंटा हामुर वायनद मंता इंचि येसु कुद्‍दु वेहता पोल्‍ले पुरागा आयनाहाटीं अल्हा जर्गता. ");
INSERT INTO esg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","पजा पिलातुस ओना राजवाडाते होंचि येसुनलोप्‍पो केया वेहतोर. केय्‍सि, “निमे यहुदिल्कुना राजाना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","अस्‍के येसु, “ई पोल्‍ले नी इच्‍चटा निमेन इंचंतिना? हिलाकोंटे नावा बारेमते नीकु बोरन्‍ना वेहतुरा?” इंचि पिलातुसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","अय्ते पिलातुस, “नाकुन निमे यहुदि इनकुंचंतिना? कुद्‍दु नीवा लोकुल्‍क आनि ओरा पेर्मालोर नीकुन नाकु अप्पजेपतुर. निमे बतल कीतिन?” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","अस्‍के येसु, “नावा राज्येम ई दुनियाक संबंदिस्तद आयो. ओक्‍कला नावा राज्येम ई दुनियाक संबंदिस्तद आसि मत्‍ते, नाकुन यहुदि पेद्‍दाल्कुंक अप्‍पजेपकोंटा नावा सेवाकुल्क लडाइ कीसि मन्‍नेर. गानि इंदके नावा राज्येम ई दुनियाक संबंदिस्तद आयो,” इंचि जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","अस्‍के पिलातुस, “अल्हा अय्ते निमे राजाना?” इंचि इत्‍तोर. अय्ते येसु, “निमेन इंचंतिन नाकुन राजाल इंचि! नना अय्ते सत्‍तेम बारेमते गवाइ वेहालय पुटतन. इद कारनमहाटींगे नना ई दुनियाते वातन. सत्‍तेमते ताकाना हरेक मनकल, नावा अल्किरतुन केंजंतोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","अद केंजसि पिलातुस, “सत्‍तेम इत्‍ते बतल?” इंचि येसुन पूसकीतोर. अल्हा पूस कीसि, पलाते यहुदिल्कुनगा होत्‍तोर. होंचि, “नाकु ईना लोप्पो अय्ते बतले कसूर दिस्सेक हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","गानि दाटसि होनना पंडुगुना रोजु, एडादिक उंदि मल्का, जेलने मत्‍तोन वरोन होळसना, इंचि मीवा उंदि रिवाज मंता. अय्ते मीवाहाटीं नना ई यहुदिल्कुना राजान होळ्‍समळ मीकु इस्‍टमेना?” इंचि ओर्कुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","अस्‍के ओर वरगेयसेके मर्रा, “मन्‍नि ओन होळ्‍समा, मावाहाटीं बरब्बान होळसा,” इंचि इत्‍तुर. ई बरब्बल इनानोर, पेद्‍दा दोंगल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","अस्‍के पिलातुस येसुन दोर्कापीसि पोट्‍टे देब्बां तना वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाइल्क बारे, उंदि हाह्कुना वेलितुन किरिटम कीसि, येसुना तल्‍लक तासतुर. तासि ओन्क नेळि पंडि रंगुना कपडिं केराहतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","केराहता पजा, “यहुदिल्कुना राजांक जय” इंचेके ओना सेंपापोर्रो तंतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पिलातुस मरुंदि मल्का पलाते पेय्सि, “हुळाट, ओन्क सिक्‍सा हियालय, नाकु ओनालोप्‍पो बतले कसूर दोर्काहिल्‍ले, इद मीकु तेळियना इंचि नना ओन मीहेके पलाते तच्‍चंतन,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","पजा येसु हाह्कुना किरिटम, नेळि पंडि रंगुना कपडिं केरसि पलाते पेय्‍स्‍तोर. अस्‍के पिलातुस, “हुळाट ई मनकन,” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","येसुन हूळसि, पेद्‍दा पेर्मालोर आनि गुळितगा कावेल कियानोर, “ओन क्रुसुनपोर्रो वेलाड वाटा, ओन क्रुसुनपोर्रो वेलाड वाटा,” इंचि वरगेयतुर. अस्‍के पिलातुस ओर्कुन, “ओन ओसि मिमेटे क्रुसुनपोर्रो वेलाड वाटट, नाकु ओनालोप्‍पो बदे कसूर दोर्काहिल्‍ले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","अद केंजसि यहुदिल्क इल्‍हा जवाब हीतुर, “माकु उंदि नियम मंता. ओर, नना पेनदा मर्रिन, इंचि इत्‍तोर. अदुनहाटीं मावा नियम परकारम ओर हायमळे गावाले,” इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ओर अल्हा इन्‍मळतुन केंजसि, पिलातुस वेल्‍लेन वेरियतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","अस्‍के पिलातुस येसुन मर्रा राजवाडाते ओसि, “निमे बगाटाल वातिन?” इंचि पूसकीतोर. गानि येसु बतले जवाब हिया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","अदुनहाटीं, पिलातुस येसुन, “निमे नातोनि बारि वळ्कसेक हिल्‍लिन? नीकुन होळसियना आनि क्रुसुनपोर्रो वेलाड वाटना अदिकारम नाके मंता, इंचि नीकु एर्का हिल्‍लेना?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","अस्‍के येसु, “पोर्रो मनना पेन आ अदिकारम नीकु हीता, अचोने! हिलाकोंटे नीकु नावापोर्रो बतले अदिकारम हिल्‍ले. अदुनहाटीं, नाकुन नीवा कय्‍दुक अप्पजेपतोंके एक्‍को पापम दल्‍गंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","अस्‍केटाल पिलातुस, येसुन होळसालय वेल्‍लेन कोसिस कीतोर. गानि यहुदिल्क, “ओक्‍कला निमे ओन होळसियानय्ते, निमे कैसर राजाना दंटातोन आयिन. इंका नना राजान इंचि इनना हरेक मनकल, महाराजाना विरोदमते वळ्कतोर आंतोर,” इंचेके वरगेयालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","अव पोल्‍ले केंजसि, पिलातुस येसुन मर्रा पलाते तत्‍तोर. तच्‍चि, न्‍यायम कियनेंके उद्‍दना कुर्सिते उद्तोर. अद कुर्सि मनना जेगातुन, इब्रानि बासाते, गब्बाता इंतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","अद रोज, दाटसि होनना पंडुगुना तयारिं कियना रोज आंद. अस्केळ्क, पन्‍नेंड एगसि मत्‍ता. अस्‍के, “इद हुळाट, मीवा राजाल!” इंचि पिलातुस यहुदिल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","अस्‍के यहुदिल्क, “ओन लक्‍कु ओम, ओन लक्‍कु ओम! ओसि क्रुसुनपोर्रो वेलाड वाटा,” इंचि वरगेयालय दल्‍गतुर. अय्ते पिलातुस, “बतलु! नना मीवा राजान, क्रुसुनपोर्रो वेलाड वाटकना?” इंचि ओर्कुन पूसकीतोर. अस्‍के पेद्‍दा पेर्मालोर, “माकु कैसर राजान होळसिसि वेरे बोरे राजाल हिल्‍लोर,” इंचि वरगेयतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","पजा पिलातुस, येसुन क्रुसुनपोर्रो वेलाड वाटालय ओरा कय्‍दुक अप्पजेपतोर अय्ते, ओर येसुन ओतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","येसु ओना क्रुसुन कांजसेक, “तला बोरसेम” इनना जेगातगा होत्‍तोर. इब्रानि बासाते, अद जेगातुन गोलगोता इंतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","अगा ओना काल्क-कय्‍कुंक मोल्‍लां कोह्‍किसि ओन क्रुसुंक वेलाड वाटतुर. येसुन नड्‍डुम इरसि ओना रोंड बाजकुंक इंकिव्वुर्कुन क्रुसुंक वेलाड वाटतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","अस्‍के पिलातुस, “नासरेत नाटेना येसु, यहुदिल्कुना राजाल,” इल्‍हा उंदि बल्‍लापोर्रो कसूर रासि, येसुना क्रुसुंक कोह्का वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","येसुन वेलाड वाटता जेगा सहरकु दग्‍गेरा मत्‍ता. अद बल्‍लापोर्रो इब्रानि, लटिन आनि युनानि बासाते रासि मत्‍ता. अदुनहाटीं वेल्‍लेटोर यहुदिल्क, आ कसूरतुन हदवुंदुर. ");
INSERT INTO esg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","पजा यहुदि पेद्‍दा पेर्मालोर पिलातुसनगा होंचि, “यहुदिल्कुना राजाल इंचि रासमा. दान जेगाते, नना यहुदिल्कुना राजान, इंचि ओर इत्‍तोर, इल्‍हा रासा,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","अस्‍के पिलातुस, “नना रासतन! रासतन. अचोने!” ");
INSERT INTO esg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","सिपाइल्क येसुन क्रुसुनपोर्रो वेलाड वाटतंका, ओना कपडिं तेंडकुत्‍तुर. तेंडकुंचि, वरो-वरोंक उंदि-उंदि हिस्सा वायना हिसाबते, नालुं पाल्क कीतुर. ओना अंगितुनगुडा तेंडकुत्‍तुर. अद अंगि पोर्रोटाल हिळुदाका पोळ्‍गुंक-पोळ्‍गु कुट्‍टु वाटाकेन मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","अदुनहाटीं सिपाइल्क, “दीन मनम हराहमन्‍नि, गानि सिट्‍टिं वाटकोम. अस्‍के अद बोर्क दोर्कंतनो हूळकोम,” इंचि ओर-ओरे इनकुत्‍तुर. “ओर नावा कपडिन हिस्सां कीसि, नावा अंगिहाटीं सिट्‍टिं वाटंतुर,” इंचि दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍ले पुरागा आयनाहाटीं अल्हा जर्गता. सिपाइल्कगुडा अदुनहाटींगे अल्हा कीतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","येसुन वेलाड वाटता क्रुसुना दग्‍गेरा, येसुना यावल, ओना यावाना हेलड, कोल्‍पाना मुत्‍तो मरियम, आनि मगदलेनि नाटेना मरियम इव निलसि मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","येसु, ओना यावल आनि ओर बोन अय्ते पावरम कीतोर आ सिस्युड, ओना दग्‍गेरा निलसि मत्‍तद हूळसि, येसु ओना यावन, “यावा, ईर हूळा नीवा मर्रि!” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","पजा आ सिस्युनहेके हूळसि, “इद हूळा, नीवा यावल!” इंचि वेहतोर. अस्‍केटाल आ सिस्युड दान ओना यावल इंचि लोन ओतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","पजा, ओर बद कबळहाटीं वातोर, अद कबळ पूरा आता, इंचि ओर एरपाट कीसि, दर्मसास्‍त्रमते रासि मत्‍तद पूरा आयनाहाटीं, “नाकु दूपा आसंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","अगा उंदि अळका मत्‍ता, अव्टे मुरगिसि होत्‍ता अंगुर पंडिना पानकम मत्‍ता. ओर अद अळकाते दूदि मुळाहतुर आनि हिस्सोप इनना मराता कोम्मक कळाह्‍चि, येसुना तोळदागा ओतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","येसु आ मुरगिसोत्‍ता अंगुर पंडिना पानकमता रुसि हूळसि, “पूरा आता,” इंचि इत्‍तोर. अल्हा इंचि, हिळु तला वराहचि जीवा होळ्‍सतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","अद नोमकेम आनि दाटसि होनना पंडुगुना तयारिं कियना रोज मत्‍ता. अद रोजुने पीनगुल्कु क्रुसुनपोर्रो वेलाड मनमळ यहुदिल्कुंक इस्‍टम हिल्‍ले. अदुनहाटीं यहुदि पेद्‍दाल्क पिलातुसनगा वासि, “ओरा काल्‍कुन उराहचि, सेत्‍तातुन हिळु रेहा वेहा,” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","अस्‍के सिपाइल्क वासि, येसुनतोनि क्रुसुनपोर्रो वेलाड वाटसि मत्‍ता इव्वुरा काल्‍कुन उराहतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पजा ओर येसुनगा वासि हूळतस्‍के, येसु हासे मत्‍तोर, इंचि ओना काल्क उराह हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","गानि ओराव्टेटाल वरोर सिपाइ येसुना संका हिळु, गोर्काते कोह्कतोर. अय्ते कोह्कता कोह्कुळे नेत्‍तुर आनि एर पोंगता. ");
INSERT INTO esg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","अदंता बोर अय्ते हूळतोर ओर, मिमेटगुडा विस्वासम कियगोम इंचि ओना गवाइ वेहतोर. ओर वेहता गवाइ निजम आंद. ओर सत्‍तेम वेहचंतोर इंचि ओन्क एरपाट. ");
INSERT INTO esg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","“ओना बोक्‍कानाल उंदि बोक्‍किंका उंरुंगो,” इंकुंदि जेगाते, “ओन कोह्कतोनहेके हूळानुर” इंचि दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍लें पुरागा आयगोम इंचि, इल्‍हा जर्गता. ");
INSERT INTO esg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","अवंता आतंका, अरिमताइ नाटेना योसेप इनानोर, पिलातुसनगा होंचि, “येसुना पीनगुन हीम,” इंचि पूसकीतोर. पिलातुस ओम इत्‍तस्के ओर येसुना पीनगुन ओतोर. ");
INSERT INTO esg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","उंदि मल्का नर्कटा वेलाक वासि येसुंक कलियता निकोदेमसगुडा योसेपुनतोनि वातोर. ई निकोदेमस, दग्‍गेर-दग्‍गेरा मुप्‍पै (30) किलोना “बोलम” आनि “अगर” इनना गमागमा गब्‍बु वायना वस्‍तुक पीनगुंक होकालय पीसि वातोर. ");
INSERT INTO esg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ओर इव्वुर कूळसि, यहुदिल्कुना गति कियना रिवाज परकारम, आ गमागमा वायना वस्तुकुनंता येसुना मेंदुल्क होकतुर. होकसि, येसुना पीनगुन उंदि पूना पोळ्‍गु कप्पिडते हुटतुर. ");
INSERT INTO esg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","येसुन क्रुसुंक वेलाड वाटता जेगाक दग्गेरेन उंदि तोटा मत्‍ता. आ तोटाते उंदि पूना बोंदा मत्‍ता, अद बोंदाते अदवेरदाका बस्‍केने बोनदे पीनगुन इर्रा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","अद बोंदा दग्‍गेरा मत्‍ता, अचोने आयाका अद यहुदिल्कुना दाटसि होनना पंडुगुना तयारिं कियना रोज मत्‍ता. अदुनहाटीं ओर येसुन अदे बोंदाते इरतुर. ");
INSERT INTO esg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","वारमता मोदाटा रोजु, इत्‍ते अयतारमनाडु, मुसामुसा हीकट मननेंकेन, मगदलेनि नाटेना मरियम बोंदातगा होत्‍ता. अगा अद, बोंदा हर्दुक अड्‍डम इरसि मत्‍ता बंडा तेंडसि मत्‍ताप हूळता. ");
INSERT INTO esg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","अदुनहाटीं अद मरियम, सिमोन पत्रुनगा आनि येसु बोन अय्ते पावरम कियुंदुरो आ सिस्युनगा विच्‍चि होंचि, “सामिना पीनगुन बोंदाताल बोरो तेंडसि ओतुर, अदुन बगा इरतुरो, माकु तेळियो,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","अद वेहतद केंजसि, पत्रु आनि आ इंकावरोर सिस्युड बोंदातेके होनालय पेय्‍स्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ओर इव्वुर वितसेके होनंनेके, आ इंकावरोर सिस्युड पत्रुंकन्‍ना मुन्‍ने विच्‍चि, बोंदातगा एवतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","अगा एवसि, ओर पलाताले माळकिस हूळतोर, अय्ते ओन्क सिराप येसुंक हुटसि मत्‍ता कपडिं दिसतां. गानि ओर लोप्पो नेंगा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","पजा सिमोन पत्रुगुडा अगा एव्‍तोर. लोप्पो होळियसि, येसुंक हुटसि मत्‍ता कपडिन हूळतोर. गानि येसुना तल्‍लक हुटसि मत्‍ता कप्‍पिड मडता कीसि, वेरे जेगाते मत्‍तद ओन्क दिसता. ");
INSERT INTO esg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","पजा, बोंदातगा मुन्‍ने एव्ता सिस्युडगुडा लोप्पो होळियसि, हूळसि विस्वासम कीतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","अदवेरदाकागुडा, “येसु हासि तप्‍पाकोंटा मर्रा जीवाते तेदंतोर,” इंचि दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍ले ओर्क तेळिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","पजा ओर सिस्युल्क ओरा लोह्कुने मल्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","मगदलेनि नाटेना मरियम मात्रम बोंदाता पलाते निलसि अळसेके मत्‍ता. अळसेके-अळसेकेन अद लोप्पो माळकिस हूळता. ");
INSERT INTO esg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","अस्‍के, तेल्‍लटा कपडिं केरता रोंड पेनदा दूतां दान्क दिसतां. अव येसुना सेत्‍तातुन इरतागा उंदि बारे तल्‍लाताहेके, इंकुंदि बारे काल्कुनहेके उद्‍दिस मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","आ दूतां, “बाई, निमे बारि अळसंतिन?” इंचि पूसकीतस्‍के, “नावा सामिना मेंदुलतुन बोंदाताल बोरो बेकेनो ओसि इरतुर, नाकु एरपाट हिल्‍ले,” इंचि मरियम इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","अल्हा इंचि अद पजोळ्क तिरियता. अस्‍के अगा येसु निलसि मत्‍तद दान्क दिसता. गानि ओरे येसु इंचि, अद एरपाट किया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","अस्‍के येसु, “बाई, निमे बारि अळसंतिन? बोर्कुन पहकसंतिन?” इंचि मरियमुन पूसकीतोर. अस्‍के मरियम ओन, ओर तोटाक कावेल मनानोर बारे इन्कुंचि, “महाराज, निमे गिंटा सामिना पीनगुन इगेटाल ओयानय्ते, अदुन बगा इरतिन नाकु वेहा नना होंचि तरकुंतन,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","अय्ते येसु, “मरियम,” इंचि दान केयतोर. अस्‍के मरियम ओनहेके तिरियसि हूळसि, दाना इब्रानि बासाते, “रबोनि” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","अस्‍के येसु, “इदवेरदाका नना बाबानगा होना हिल्‍लेन. निमे नाकुन इट्‍टुमा, गानि नावा तम्मुह्कुनगा होंचि इल्‍हा वेहा: नना नावा बाबाल आनि मीवा बाबाल, इंका नावा पेन आनि मीवा पेनदागा पोर्रो होंचंतन, इंचि ओर्क वेहा,” इंचि दानकु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","अस्‍के मगदलेनि नाटेना मरियम सिस्युल्कुनगा होंचि, “नना सामिन हूळतन, ओर मीकु इव पोल्‍लें वेहा इत्‍तोर,” इंचि ओर्क येसु वेहता पोल्‍लें वेहता. ");
INSERT INTO esg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","अदे रोजु इत्‍ते वारमता मोदाटा रोजु, पोळ्‍द अर्रना वेलाक, सिस्युल्क अंटोर, यहुदि पेद्‍दाल्कुना वेर्रेक, तल्‍पुंक तालम वाटसि, उंदि अर्राते जमा आसि मत्‍तुर. अचानक, येसु ओरा नड्‍डुम वासि निल्‍सि, “मीकु सांति दोर्कि,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","अल्हा वळ्‍किसि, येसु ओर्क ओना कय्‍कुंक आनि पक्‍काक मत्‍ता देब्बां हुपिस्तोर. सामिन हूळसि ओर वेल्‍लेन कुसिते निंडिस होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","येसु मर्रा उंदि मल्का ओर्कुन, “मीकु सांति दोर्कि. बाबाल नाकुन ई दुनियाते लोहताप, ननागुडा मीकुन ई दुनियाते लोहंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","अल्हा वेहचि, “पवित्र आत्मा येतट,” इंचि ओरपोर्रो उह्कुतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","उह्किसि, “मिमेट बोना पापाल्क मापि कींतिरो, ओरा पापाल्क मापि आंतां, मिमेट बोरा पापाल्क अय्ते मापि किय्यिरो, ओरा पापाल्क मापि आयों,” इंचि ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","येसु वासि मत्‍तोर अस्‍के, ओना पन्‍नेंड सिस्युल्‍कुनाल वरोर, तोमल ईर एमडाल्‍कुनाल वरोर आंदुर, ई सिस्युड मनाहिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","अदुनहाटीं सिस्युल्क, “मोमोट सामिन हूळतोम,” इंचि ओन्क वेहतुर. गानि तोमल, “नना कुद्‍दु ओना कय्‍कुंक कोह्कता पुनकुन हूळसि, आ पुनकुने नना वेलु इर्रुवा, इंका गोर्काते कोह्कता बर्रातगा कय इर्रुवा, नना विस्वासम किय्योन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ओर अल्हा इंचि एनिमिदि रोजुक आता पजा, सिस्युल्क मर्रा अदे लोते तल्‍पुंक तालम वाटसि जमा आसि मत्‍तुर. ई मल्का ओरतोनि तोमालगुडा मत्‍तोर. तल्‍पुंक तालम वाटसि मननेंकेगुडा येसु ओरा नड्‍डुम वासि निल्तोर. निलसि, “मीकु सांति दोर्कि,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","पजा येसु तोमान, “तोमा, नावा कय्‍दा पुनकुने नीवा वेलु इर्सि हूळा. नीवा कय हाह्‍चि, नावा पक्‍काक मनना गोर्का बर्राते नीवा कय इर्रा. निमे अनमानमते मन्‍मा, विस्वासम कीम,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","अस्‍के तोमल, “ना सामि, ना पेनदुना,” इंचि तोमल येसुंक जवाब हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","पजा येसु ओन, “निमे नाकुन हूळसि विस्वासम कीतिन. गानि बोर नाकुन हूळाकोन्‍ना विस्वासम कींतोर, ओर आसिर्वाद दोर्कतोर आंद,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","सिराप इवे आयका, सिस्युल्कुना मुन्‍ने येसु वेरे इंका वेल्‍लेन अद्‍बूतामाता चिन्‍हे कीसि हुपिस्तोर. इवन्‍नि ई पुस्तकमते रासमळ जर्गाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","गानि येसे किरिस्‍तु, ओरे पेनदा मर्रि, इंचि मिमेट विस्वासम कीसि ओना पोरोल्ते पिस्वर दोर्किच्‍कुननाहाटीं, इवन्‍नि रासमळ जर्गता. ");
INSERT INTO esg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","इवंता आता पज्जो, येसु मरुंदि मल्का सिस्युल्कुंक तिबेरिया समुद्रमता ओड्‍डुंक सिस्युल्कुंक दिसतोर. अद इल्‍हा जर्गता: ");
INSERT INTO esg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","अगा सिमोन पत्रु, एमडाल्‍कुनाल वरोर तोमल, गालिल राज्येमता काना नाटेना नतेनल, जब्‍दिना मर्क आनि येसुना इंका इव्वुर सिस्युल्कु जमा आसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","अस्‍के सिमोन पत्रु, “नना जिम्मां पियालय दांतन,” इंचि ओर्कुन इत्‍तस्के ओर, “मोमोटगुडा नीतोनि वांतोम,” इंचि, होंचि डोंगाते उदतुर. गानि अद नर्कामेड ओर्क उंदिंका जिम्मा दोर्काहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","अद रोजु पंगा आयनेंके येसु वासि ओड्‍डुनगा निलसि मत्‍तोर. गानि ओना सिस्युल्क, ओन येसु आंदुर इंचि एरपाट किया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","अस्‍के येसु, “मिहगा इच्‍चुंगना जिम्मां मंतंगा, पिलाल्कनिटा?” इंचि पूसकीतोर. अय्ते ओर, “उंदिंका हिल्‍ले,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","अस्‍के येसु ओर्क, “डोंगाता तिना बाजुंक ओल्‍ला वाटट, अस्‍के मीकु जिम्मां अर्रंतां,” इंचि वेहतोर. येसु वेहतापे ओर ओल्‍ला वाटतुर. अस्‍के हुळाट! ओर ओल्‍लातुन ओड्‍डुंक इग्गा पराहिल्‍लुर, अचोने वेल्‍ले जिम्मां ओल्‍लाते अरतां. ");
INSERT INTO esg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","अस्‍के येसु बोन अय्ते पावरम कियुंदुरो आ सिस्युड, “ओर सामिए आंदुर,” इंचि पत्रुंक वेहतोर. अय्ते सिमोन पत्रु, ओर अल्हा वेहतदुन केंजता केंजमळे तेंडसि मत्‍ता कपडिं केरसि समुद्रमते दुन्कतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ओड्‍डु वेल्‍ले लक्‍कु मनाहिल्‍ले. दग्‍गेर-दग्‍गेरा रोंड नुह्कुना कूटां लक्‍कु मत्‍ता बारे. अदुनहाटीं कळमता सिस्युल्कु, जिम्माने निंडिस मत्‍ता ओल्‍लातुन इग्गिसेक अदे डोंगाते वातुर. ");
INSERT INTO esg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ओर ओड्‍डुंक एवतस्‍के, रेय्‍सि हूळते, अगा ओर्क इच्‍चुं हारिं आनि तडमि पोर्रो वाटसि, इच्‍चुं जिम्मां दिसतां. ");
INSERT INTO esg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","अस्‍के येसु, “मिमेट इंद-इंदके पीता जिम्मानाल इच्‍चुं जिम्मां हीके पीसि वटु,” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","अदुनहाटीं सिमोन पत्रु डोंगाते एक्‍किसि ओल्‍लातुन एताल ओड्‍डुंक इग्गुतोर. अद ओल्‍लाते नूटा एबै मूड पेद्‍दा-पेद्‍दा जिम्मां निंडिस मत्‍तां. अचोने वेल्‍ले जिम्मां निंडिस मनिनागानि अद ओल्‍ला हर्रा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","पजा येसु, “वटु, वासि नास्ता कीम्‍टु,” इंचि ओर्कुन केयतोर. सिस्युल्कुंक, ओरे सामि इंचि एरपाट आताहाटीं, “निमे बोन आंदिन?” इंचि पूसकियालय बोनके हिम्मत आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","अस्‍के येसु वासि, आ हारिन, जिम्मान येतसि ओर्क हीतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","येसु हासि मर्रा जीवाते तेदता पज्जो, इल्‍हा सिस्युल्कुंक ओर दिसमळ, इद मूळोव मल्का आंदु. ");
INSERT INTO esg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","अंटोरा तिनुळ आतास्के येसु सिमोन पत्रुन, “योहानुना मर्रि सिमोनु, ईर अंटोरकन्‍ना निमे नाकुन एक्‍को पावरम कींतिना?” इंचि पूसकीतोर. अस्‍के सिमोन, “हो सामि! नना नीकुन पावरम कींतन इंचि नीकु एर्के मंता,” इंचि इत्‍तोर. “अय्ते निमे नावा गोर्रे पोरिह्कुन मेहा,” इंचि येसु पत्रुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","रोंडो मल्का, “योहानुना मर्रि सिमोनु, निमे नाकुन पावरम कींतिना?” इंचि येसु पूसकीतस्‍के, “हो सामि! नना नीकुन पावरम कींतन इंचि नीकु एर्के मंता,” इंचि पत्रु इत्‍तोर. “अय्ते निमे नावा गोर्रेन बेस मेहा,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","येसु मूळोव मल्का पत्रुन, “योहानुना मर्रि सिमोनु, निमे नाकुन पावरम कींतिना?” इंचि पूसकीतोर. “योहानुना मर्रि सिमोनु, निमे नाकुन पावरम कींतिना?” इल्‍हा मूळोव मल्का येसु पूसकीताहाटीं, पत्रुंक दुक्‍कम वासि, “हो सामि! नीकु अय्ते अंता एरपाट मंता. नना नीकुन पावरम कींतन इंचिगुडा नीकु एरपाटे मंता,” इंचि पत्रु इत्‍तोर. अस्‍के येसु, “अय्ते निमे नावा गोर्रें मेहा. ");
INSERT INTO esg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","नना निजम-निजम वेहासेक, निमे लेयोन मत्‍तिन अस्‍के, नीवा कपडिं निमे हदुरकुनिंदिन. नी इस्‍टमाता जेगातगा होनिंदिन. गानि नीवा मातिरतनमते, निमे नीवा कय्‍क हाह्ते, बोरो वेरेतोर वासि नीवा कपडिं हदुरनुर नीकु इस्‍टम हिलुवा जेगाते नीकुन पीसि ओयनुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","पत्रु बसोंटा हामुर हासि, पेनदुक महिमा हियनुरो, इदुन ओन्क हुप्‍सालय येसु अल्हा वळ्कतोर. अल्हा वळकता पजा, “नावा पज्जो ताका,” इंचि ओन्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पत्रु पजोळ्क मल्सि हूळतस्‍के, येसु बोन अय्ते पावरम कियुंदुरो आ सिस्युड, बोर अय्ते पंडुगुना गाटो तिननेंके वेल्‍लेन दग्‍गेर उद्‍दिस, सामि, नीकुन बोर दोकाते पीसि हींतोर इंचि, पूसकीता आ सिस्युड, ओना पज्जो वायनद ओन्क दिसतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ओन हूळसि पत्रु, “ईनद बता संगति सामि?” इंचि येसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","अस्‍के येसु, “नना मल्सि मर्रा वायनदाका ओर पिस्सि मनगोम इंचि नाकु इस्‍टमातस्के, ओना बारेमते नीकु बतल गावाले? निमे नावा पज्जो ताका,” इंचि पत्रुंक वेहतोर. ");
INSERT INTO esg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","दानहेंदाल, आ सिस्युड हायोर इत्‍ता पोल्‍ले, कळमता विस्वासुल्कुना नड्‍डुम पैलांचि होत्‍ता. गानि आ सिस्युड हायोर इंचि येसु इना हिल्‍लोर. ओर सिराप “नना मल्सि मर्रा वायनदाका ओर पिस्सि मनगोम इंचि नाकु इस्‍टमातस्के, ओना बारेमते नीकु बतल गावाले?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ई सिस्युडे इव पोल्‍लेना बारेमते गवाइ वेहचि, रासतोर. ईना गवाइ निजम आंद इंचि मनाकु एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","बूमिपोर्रो येसु कीतव इंका वेल्‍लेन पोल्‍लें मंतां. आ उंदुंदि पोल्‍लेतुन रासते, रासता पुस्तकाल्कुन इर्रालय दुनियाते जेगा हाला पर्रो बारे, इंचि नाकु अनपिच्‍चंता.");
INSERT INTO esg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","नावा पावरमगल्‍ला तियपिलुस, नना मोदाटा पुस्तकमते सुरुवनाल येसु बतल-बतल कीतोर, बतल-बतल कराहतोर अदुना बारेमते रासतन. ");
INSERT INTO esg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","अचोने आयका येसु पेर्कुत्‍ता प्रेरितुल्कुंक पवित्र आत्माहेंदाल आदेस हीसि, मर्रा स्वर्गमते तिरियसि होननदाका पूरा पिस्वरता बारेमते नना रासतन. ");
INSERT INTO esg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","येसु हासोंचि तिरियसि तेदतस्‍के, “नना पिस्सि मंतन,” इंचि प्रेरितुल्कुंक गट्‍टिगा रुजुव कीसि हुपिस्तोर. ओर नल्‍पै रोजकुनदाका ओर्क दिस्सेक, पेनदा राज्येम बारेमते वेहासेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","उंदि मल्का ओरतोनि कलियसि मननेंके येसु, “येरुसलेम सहर होळसिसि होनमट. नावा पेनबाबाल हीता पोल्‍लेता बारेमते नना मीकु मुन्‍नेन वेहचि मत्‍तन, अद पूरा आयानदाका एदुर हूळसेक मंटु. ");
INSERT INTO esg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","बारित्‍ते, योहान एतोनि बापतिस्मा हीतोर, गानि मीवा बापतिस्मा कोन्‍नि रोजकुंक पवित्र आत्माताहेंदाल आयार,” इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","पजा अंटोर प्रेरितुल्क उंदि जेगाते जमा आतुर. अस्‍के येसुन, “सामि, निमे इदे वेलाते इस्राएल देसेमता लोकुल्‍कुंक ओरा राज्येम मर्रा हींतिना?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","अस्‍के येसु ओर्कुन, “अद सिराप पेनबाबांके तारिक आनि वेलाता निरनायम एतना अदिकारम मंता. दान एरपाट कियमळ मीवा कबळ आयो. ");
INSERT INTO esg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","गानि पवित्र आत्मा मीपोर्रो वातस्के मिमेट येरुसलेम सहर, पूरा यहुदिया एरिया, सामरिया एरिया अल्‍हेने बूमिता आकिरदाका नावा गवाइ आयना ताकत मीकु वायार,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","येसु इल्‍हा इत्‍तस्के, ओर हूळसेक मननेंकेन ओन स्वर्गमते तेहाचि ओयमळ जर्गुता. ओर्क दिस्‍साकोंटा उंदि मब्बु तेर्पे अड्‍डम वासि ओन मुच्‍चुता. ");
INSERT INTO esg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ओर पोर्रोळ्‍क तेदिस होननेंके अगा मत्‍ता प्रेरितुल्क मब्बुनहेके उंदेतीर हूळसेक मत्‍तुर. अस्‍केने इव्वुर तेल्‍ला कपडिं केरतोर ओरगा वासि नित्‍तिसि, ");
INSERT INTO esg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ए गालिल लोकुल्‍कुनिटा, मिमेट इल्‍हा नित्‍तिसि मब्बुनहेके उंदेतीर बारि हूळसेक मंतिर? येसुन मिहागटाल स्वर्गमते तेहकुंचि ओयमळ जर्गुता गदा! अय्ते बल्हा मिमेट ओन स्वर्गमते होननेंके हूळतिरो, अल्‍हेने ओर मर्रा तिरियसि वांतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","पजा प्रेरितुल्क जय्तुन मराकुना गुट्‍टातगटाल नोमकेम रोजुनच्‍चो लक्‍कु मत्‍ता येरुसलेम सहरते मल्सि वातुर. ");
INSERT INTO esg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ओर अगा वासि, बद मिद्‍देते मनुंदुरो अदे मिद्‍देता पोर्रोटा अर्राते होत्‍तुर. अगा पत्रु, योहान, याकोब, अंदरियल, पिलिप, तोमल, बरतलमय, मत्‍तयाल, अल्‍पिना मर्रि याकोब, सिमोन (जिलोति), याकोबुना मर्रि यहुदल ईर मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ईरतोनि इच्‍चुंग मुर्ताह्क, येसुना यावल मरियम, ओना तम्मुह्‍क ईर अंटोर उंदे मनसुने पारतना कीसेके मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","उंदि रोजु नूटा इरवै (120) विस्वासि दादालोरा नड्‍डुम पत्रु नित्‍तिसि, ");
INSERT INTO esg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“नावा विस्वासुल्‍कुनिटा! दाविद राजाल पवित्र आत्माहेंदाल दर्मसास्‍त्रमते रासि मत्‍ता पोल्‍लेतुन मुन्‍नेन इंचि मत्‍तोर, अद इंदके यहुदाना हेंदाल पूरा आता. ई यहुदाले येसुन पियानोर्कुंक मुन्‍ने अरतोर. ");
INSERT INTO esg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहुदल मना लोप्पोटोरे वरोर मत्‍तोर, मनातोनि कलियसि सेवा कियालय आसर आतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","तप्‍पु कबळ कीसि कमांच्‍ता कोत्‍ताने यहुदल उंदि बूमि अस्तोर. अदे बूमिते बोकबोर्लें अरताहेंका पीर पय्सि ओना पूरा पोदुह्कंता पलाते पेय्सतां. ");
INSERT INTO esg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","इदु येरुसलेम सहरते मत्‍तोर्कुंक अंटोर्क तेळियता. दानहाटीं ओरा बासाते आ नेदुन हकलदामा, इत्‍ते नेत्‍तुरता नेलि इल्‍हा पोरोल अरता. ");
INSERT INTO esg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","पत्रु मर्रा इल्‍हा इत्‍तोर, “ओना लोन पाडासि दांता, अवुने मनालय वरोरगुडा पिस्‍सोर. ओना पेद्‍दातनम, इंकावरोंक दांता.” इल्‍हा बजन संहिताते रासि मंता. ");
INSERT INTO esg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“अदुनहाटीं येसु सामि बच्‍चुं रोजकु मनातोनि कलियसि होंचेके-वासेके मत्‍तोरो, इत्‍ते योहानुना बापतिस्मातगटाल अय्ते येसुन मना नड्‍डुमताल स्वर्गमते तेहाचि ओयनदाका बोर अय्ते मनातोनि मनुंदुर ओरव्टेटाल वरोन पेरते बेस मनंता. येसु हासि मर्रा जीवाते तेदतद ओर मनातोनि गवाइ हियमळ गावाले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","दानहाटीं इव्वुर मनकालोर्कुन मुन्‍ने तत्‍तुर. अव्टेटाल वरोर योसेप, ईन बरसब्बा इनुंदुर, इंका ईन युसतुस इंचिगुडा एरपाट कियुंदुर. इंकावरोर मत्‍तिया. ");
INSERT INTO esg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","अस्‍के प्रेरितुल्क पारतनाते, “सामि! निमे अंटोरा मनसुन एरपाट कींतिन, यहुदल अय्ते ओन्क हीता कबळतुन होळसिसि ओर होनना जेगाते होत्‍तोर. गानि निमे ईर इव्वुरा लोप्पोटाल प्रेरित इंचि नीवा सेवा कियालय बोन पेरकुत्‍तिन माकु हुप्‍सा,” इंचि तल्कतुर. ");
INSERT INTO esg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","अस्‍के ओर ओराहाटीं सिट्‍टिं वाटतुर अय्ते सिट्‍टि मत्‍तियाना पोरोलते पेय्सता. अस्‍के पदाकोंडु मंदि प्रेरितुल्कुने आ मत्‍तियालगुडा कलियतोर. ");
INSERT INTO esg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","पेंतेकोस्‍त पंडुगु रोजुने अंटोर विस्वासुल्‍क उंदि जेगाते जमा आसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","अस्‍के उंदे मल्का मब्बुनाल पेद्‍दा वळि-दुमारम लेह्का वाता. ओर अंटोर उद्‍दिसि मत्‍ता लोन दाना सप्पुडतोनि पूरा निंडिस होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","अस्‍के तळमितालेसीं पोत्‍तना नाल्‍कें ओर्कु दिसतां, अव अगा मत्‍तोरा पोर्रो उंद-उंदि रेयतां. ");
INSERT INTO esg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ओर अंटोर पवित्र आत्माते निंडिस होत्‍तुर, आ आत्मा ओर्कु वळकाना बलम हीता परकारम ओर वेरे-वेरे बासाने वळ्‍कमळ सुरुव कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","अद वेलाते, मब्बुना हिळु मत्‍ता वेल्‍लेने देसेल्‍कुना यहुदि विस्वासुल्‍क येरुसलेमते मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","आ सप्पुड केंजतस्के ओर उंदगा जमा आतुर. ओर अंटोर ओरा संतम बासाते वळ्कनद केंजसि इचंत्रम आतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","अस्‍के ओर इचंत्रम आसि, “ईर वळ्कानुर अंटोर गालिल एरियातोरे गदा, ");
INSERT INTO esg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","अरे मनम अंटोरम मना संतम बासातेन केंजसंतोम गदा! इद बल्हा मरि? ");
INSERT INTO esg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","मनम पारति, मेदी, एलामि, मेसोपोटामिया, यहुदिया, कप्‍पुदुकिया, पुंतुस, आसिया ");
INSERT INTO esg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","पुगरिया, पंपुलिया, ई जेगानाल, इजिप्‍त देसेमताल, कुरेनि सहर दग्‍गेरा मत्‍ता लिबिया देसेमताल, रोम सहरताल वाता यहुदिल्कुम, यहुदि मतम पीतोरम. क्रेति, अरब देसेमताल वाता अंटोरम पेनदा इचंत्रमाता पेद्‍दा कबाह्‍कुन मना-मना संतम बासाने केंजसेके मंतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ओर अंटोर इचंत्रम आसि, “इद बतल आसंता” इंचि तेळियका वरोंक वरोर तल्कतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","गानि वेरेतोर अय्ते, “ईर अंगुर पंडिना पूना कल्‍लु उंचि मंतुर,” इंचि ओर्कुन कारेड्‍डाल्‍क कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","अस्‍के पत्रु पदाकोंडु मंदितोनि नित्‍तिसि, लोकुल्‍कुंक अंटोर केंजा होनानाल जोरते वळकालय दल्‍गुतोर. यहुदियाता दादालोरिटा, येरुसलेमते मनानोरिटा, नना वेहानद मीकु तेळियमळ गावाले. इंचि मिमेट अंटोर नावा पोल्‍लेतुन बेस केव दोस्‍सि केंजट. ");
INSERT INTO esg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","मिमेट इनकुत्‍ताप ईर कल्‍लु उंचि रिम्मां आया हिल्‍लुर. इंदके हक्‍केटां तोम्मिद एगसंतां. ");
INSERT INTO esg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","गानि इय्यला इगे मिमेट हूळता गटनना बारेमते योएल इनना पेनदा कबुरतोर इल्‍हा जर्गंता इंचि मुन्‍नेने वेहचि मत्‍तोर, अद इल्‍हा मंता: ");
INSERT INTO esg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","पेन इंता गदा, “आकिर रोजकुने नना अंटोर लोकुल्‍कुनपोर्रो, नावा आत्मातुन कुम्मरिचंतन. अस्‍के मीवा मर्क-मियाह्क बविस्यवानिं कियानुर, मीवा लेय्युर्क दर्सनाल्‍क हूळानुर, आनि मात्रालोर कलां हूळानुर. ");
INSERT INTO esg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","आ रोजकुने नना मुरतळ मांडसा इनाकोंटा, अंटोर नावा दास-दासिह्कुनापोर्रो, आत्मातुन कुम्मरिचंतन आनि ओर बविस्यवानिं कियानुर. ");
INSERT INTO esg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","नना मब्बुने इचंत्रमता कबाह्‍क हुप्‍संतन. बूमिपोर्रो चिन्‍हां इत्‍ते, नेत्‍तुर, तडमि, मब्बुनसोंटा पोया हुप्‍संतन. ");
INSERT INTO esg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","पेनदा आ बच्‍चोनो पेद्‍दा, बेसता रोज वायाका मुन्‍ने, पोळ्‍द हीकटा, वेडसि बारे नेत्‍तुरलेह्का आंता. ");
INSERT INTO esg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","अस्‍के बोर अय्ते पेनदा पोरोल एतंतुरो, ओर्कुन पापाल्कुनाल पिसागोटमळ जर्गंता.” ");
INSERT INTO esg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","इस्राएल लोकुल्‍कुनिटा, इव पोल्‍लें केंजट. पेन नासरेत नाटेना येसुनाहेंदाल पेद्‍द-पेद्‍दा कबाह्‍क, इचंत्रमता कबाह्‍क आनि चिन्‍हां मीवा मुन्‍ने हुपिच्‍चि, पेन लोहतोर ईरे आंदुर इंचि रुजुव कीता, इद मीकु एरपाटे. ");
INSERT INTO esg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","पेनदा उंदि पिलान आनि तेल्वि परकारमे येसुन मीवा कय्‍दे हियमळ जर्गुता. मिमेट सेड्‍डा मनकालोर्कुना सायता पीसि ओन क्रुस पोर्रो मोल्‍लां कोह्‍किसि हव्कतिर. ");
INSERT INTO esg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","गानि येसुन पेन हामुटाल अलग कीसि मर्रा जीवाते तेहाता, अदुनहाटीं हामुर ओन इर्रा पराहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ओना बारेमते दाविद राजाल इल्‍हा इत्‍तोर, “नना पेनदुन बस्‍केळ्‍क, नावा मुन्‍नेन हूळसेक मत्‍तन, नाकुन कस्‍टाल्कुनाल पिसागोटालय अद नावा तिना बाजुंक मंता, ");
INSERT INTO esg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","इंचि नावा मनसु आनंदमते मंता, नावा तोड्‍डि कुसिते वळ्कसेके मंता. इचोने आयका नावा मेंदुलगुडा आसेते मनंता. ");
INSERT INTO esg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","निमे नावा आत्मातुन नरकमते होळसियिन, निमे नीवा पवित्र मनकन, कळियसि होना हिय्‍यिन. ");
INSERT INTO esg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","निमे नाकु पिस्सना हर्रि हुपिस्‍तिन, नीवा लोप्पो नाकुन आनंदमते इर्रंतिन.” ");
INSERT INTO esg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","अय्ते नावा विस्वासुल्‍कुनिटा! नना मीवा मुन्‍ने एनकटा मनकल दाविद राजाना बारेमते विस्वासमते वेहा परांतन, ओर हातोर, ओन बोंदा दोस्तुर. ओना बोंदा इदवेरदाकागुडा मना नड्‍डुम मंता. ");
INSERT INTO esg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ओर पेनदा कबुरतोर मत्‍तोर. ओना वंसमताल वरोन राजगद्‍देपोर्रो उप्‍संतन इंचि पेन ओट्‍टु तिंचि पोल्‍ले हीता, अद ओन्क एरपाटे मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","दानहाटीं मुन्‍ने बतल जर्गनद मंता अदुन एरपाट कीसि, ओन नरकमते होळसिया हिल्‍ले ओना मेंदुल कळियसि होना हिल्‍ले, इंचि वेहचि मत्‍तोर. इत्‍ते किरिस्‍तु हासि मर्रा जीवाते तेदतदुना बारेमते वेहता पोल्‍ले आंद. ");
INSERT INTO esg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","आ येसुन पेने मर्रा जीवा तेहता इंचि मोमोट अंटोरम गवाइ मंतोम. ");
INSERT INTO esg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","इंदके पेन येसुन दाना तिना बाजुंक उपिस्ता. पवित्र आत्मातुन हींतन इंचि पेन पोल्‍ले हीसि मत्‍ता अद ओन्क दोर्कता. येसु अदे पवित्र आत्मातुन वळियतोर, अदुन मिमेट हूळसेक, केंजसेक मंतिर. ");
INSERT INTO esg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","बारित्‍ते दाविद राजाल स्वर्गमते होना हिल्‍लोर, गानि दीना बारेमते ओर कुद वेहतोर: “पेन नावा सामिनतोनि इत्‍ता गदा, नना नीवा पगातोर्कुन नीवा काल्कुनगा तर्रनदाका, निमे नावा तिना बाजुंक उदसि मन.” ");
INSERT INTO esg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“अदुनहाटीं इस्राएलता अंटोर लोकुल्‍क बेस एरपाट कीकुनना पोल्‍ले बतल इत्‍ते मिमेट बा येसुन अय्ते क्रुस पोर्रो मोल्‍लां कोहकिस हव्कतिरो, पेन ओन सामि आनि किरिस्‍तु कीता,” इंचि पत्रु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","इव पोल्‍लें केंजनेंके ओरा गुंडें दडेल इत्‍तां. अस्‍के ओर, “दादालोरिटा, इंदके मोमोट बतल कीकोम?” इंचि पत्रुन आनि अगा मत्‍ता प्रेरितुल्कुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","अस्‍के पत्रु, “मिमेट कीता पापाल्क मापि आयगोम इंचि मनसु मार्सकुंचि पेनदाहेके तिरियट, मिमेट अंटोर येसु किरिस्‍तुना पोरोलते बापतिस्मा एतट. अल्हा कीतिरित्‍ते मीकु पवित्र आत्माता वरम दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ई पोल्‍ले मीहाटीं, मीवा पिलाल्‍कुनाहाटीं आनि बोर अय्ते लक्‍कु मत्‍तोर्कुन मना सामि आता पेन, दग्‍गेरा केयता ओरा अंटोराहाटीं हींता.” इंचि ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पजा पत्रु, इंका वेल्‍लेने पोल्‍लेनहेंदाल गवाइ हीसि, “ई युगमता कराब लोकुल्‍कुनाल मिमेट जेगर्ता मंटु,” इंचि विनंति कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","अस्‍के बोर अय्ते ओना पोल्‍लेन ओप्‍कुत्‍तुर, ओर अंटोर बापतिस्मा एततुर. इल्‍हा ओर अंटोर कलियसि मूड वेय्‍कुना मंदि आतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ओर अंटोर, प्रेरितुल्कुना कराहमळते, कूळमळते, हारि उरुहमळते आनि पारतना कियमळते उंदि आसि मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","प्रेरितुल्क तीराता इचंत्रमता कबाह्‍क, चिन्‍हां किय्युंदुर. अदुनहाटीं अंटोर पेनदा कदर कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","विस्वासुल्‍क अंटोर उंदासि कलियसि मनुंदुर. बोनगा बतल मनिनागानि दान अंटोर तूसकुनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","अचोने आयका ओरा सम्‍सारमतुन, सामानतुन अम्मिसि अव्‍सरम मत्‍तोर्कुंक तूसि हियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","रोज गुळिते उंदि मनसुने जमा आयुंदुर. ओर लोन-लोन हारि उराहचि, आनंदमते पीटे बतले अन्‍समन्‍स हिलाकोंटा अंटोर कलियसि गाटो तिनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ओर रोज पेनदा स्‍तुति कियुंदुर, अंटोर ओरतोनि कूस मत्‍तुर. पापमताल मुक्‍ति दोर्कतोर्कुन, सामि विस्‍वासुल्‍कुने कल्‍पुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","उंदि मल्का पिय्यटा पारतना वेलाक इत्‍ते मूड एगनेंके पत्रु आनि योहान गुळिते होंचेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","अस्‍के इच्‍चुर लोकुल्‍क पुट्तस्केटाल कुंटि मत्‍तोन वरोन तेहकुंचि तत्‍तुर. गुळिते होना-वाया कियानोर्कुन बिच्‍चम तल्कागोम इंचि ओन ओर रोजु गुळिता सक्‍कगा इनना गलमातगा उपिच्‍चि इर्रुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","पत्रु आनि योहान गुळिते होळियानद हूळसि ओर ओर्कुन बिच्‍चम तल्कतोर. ");
INSERT INTO esg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","अस्‍के पत्रु योहानुनतोनि ओनाहेके उंदेतीर हूळसि, “माहेके हूळा” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","पजा ओराहेंदाल बतलन्‍ना दोर्कार बारे इंचि आसेते, ओराहेके हूळसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","अस्‍के पत्रु, “नना अय्ते एंडि बंगाराल्क मत्‍तोन आयोन, गानि नहगा बतलय्ते मंतनो अदे नीकु हींतन, नासरेत नाटेना येसु किरिस्‍तुना पोरोलता बलमते नित्‍तिसि ताका,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","पजा ओर ओना तिना कय पीसि तेहता तेहामळे ओना काल्कुने, टोंगराने ताकत वाता. ");
INSERT INTO esg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","अस्‍के ओर दुनकिसि तेदसि ताकालय दल्‍गुतोर, ताकसेके, दुन्किसेके, पेनदा स्‍तुति कीसेके ओरतोनि गुळिते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ओर ताकानदुन आनि पेनदा स्‍तुति कियमळतुन अंटोर लोकुल्‍क हूळतुर. ");
INSERT INTO esg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ईर गुळिता सक्‍कगा इनना गलमातगा बिच्‍चम तल्ककुनानोर इंचि लोकुल्‍क एरपाट कीकुत्‍तुर. ओर बेस आतद हूळसि, इद बल्हा आता इंचि अंटोर वेरियसि इचंत्रमते अरतुर. ");
INSERT INTO esg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","आ कुंटि मनकल पत्रु आनि योहानुन पीसि नित्‍तिसि मत्‍तोर. ओर सुलेमान राजाना पंदिरतगा मत्‍तस्के अंटोर लोकुल्‍क इचंत्रम आसि आ जेगातगा विच्‍चि वातुर. ");
INSERT INTO esg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ओर्कुन हूळसि पत्रु इल्‍हा वळकालय दल्‍गतोर. “ए इस्राएलता लोकुल्‍कुनिटा, मिमेट जर्गतदुन हूळसि इल्‍हा बारि इचंत्रम आसि माहेके हूळसेक मंतिर? मोमोट मावा ताकतते, मावा बक्‍तिते ईन ताकानाल-तिरियानाल किया हिल्‍लोम. ");
INSERT INTO esg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहाम, इसाक आनि याकोबुना पेन, इत्‍ते मना एनकाटोरा पेन, दाना सेवक येसुंक कदर हीता. गानि मिमेट ओन दोर्कापीसि हव्कालय हीतिर. अयना पिलातुस ओन होळसियाना विचारम कीतस्‍के मिमेट ओन होळसियामन्‍नि इत्‍तिर. ");
INSERT INTO esg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","पवित्र आनि नीतिमंतुड मत्‍ता येसुन ओप्‍कुन्‍ना हिल्‍लिर, गानि वेरेतोरा जीवां तेंडाना पापि मनकन गावाले इत्‍तिर. ");
INSERT INTO esg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","मिमेट लोकुल्‍कुंक बस्‍केळ्‍क पिस्‍साना पिस्वरता हर्रि हुप्‍सानोन हव्कतिर, गानि पेन ओन हातोराव्टेटाल मर्रा जीवा अरहता, दीना मोमोट गवाइ मंतोम. ");
INSERT INTO esg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","मोमोट येसुन नम्मुताहाटीं ओना पोरोलतेन ईर कुंटि बेस आतोर. ई मनकन मिमेट हूळतिर, एरपाट कींतिर. येसुना पोर्रोटा विस्वासमतेन ई मनकल पुरागा बेस आतोर. इदंता मी मुन्‍नेन जर्गुता.” ");
INSERT INTO esg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“नावा दादालोर तम्मुह्कनिटा! मिमेट आनि मीवा राज्येम कियानोर बतल कीतिरो अद मीकु तेळियवा हेंकेन कीतिर इंचि नाकु एर्के. ");
INSERT INTO esg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","येसु किरिस्‍तुंक तकलिप अर्रापींता इंचि पेन दाना कबुरतोर्कुना हेंदाल मुन्‍नेन वेहचि मत्‍ता, अद इंदके पूरा आता. ");
INSERT INTO esg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","दानहाटीं मिमेट मनसु मार्सकुंचि पेनदाहेके तिरियसि वाते, मीवा पापाल्क पाय्सि दांता. अस्‍के मीकु पेनदा मुन्‍ने आत्मिक सांतिता वेला वायार. ");
INSERT INTO esg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","पेन मुन्‍नेटाले तयार कीसि इरता येसु किरिस्‍तुन मीहाटीं लोहार. ");
INSERT INTO esg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","गानि पूरा दुनियातुन मोदाटालेसीं बेस कींतन, इंचि पेन वेल्‍ले मुन्‍नेने पवित्र कबुरतोराहेंदाल वेहचि मत्‍ता. अद कालम वायनादाका किरिस्‍तु स्वर्गमतेन मनंतोर.” ");
INSERT INTO esg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","“पेन मीवा लोप्पोटाले वरोन नावसोंटा पेनदा कबुरतोन लोहार, ओर वेहतापे मिमेट ताकाना, बोर अय्ते ओर वेहताप ताकोर, ओर वेहताप ताकानोरव्टेटाल वेरे आसि नासडेम आंतोर, इंचि मूसाल वेहचि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","अचोने आयका, सामवेल आनि ओना पज्जो वाता पेनदा कबुरतोर अंटोर इव रोजकुना बारेमते वळ्कुतुर. ");
INSERT INTO esg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","‘नीवा वंसमतोराहेंदाल बूमि पोर्रोटोर्क अंटोर्क आसिर्वाद दोर्कंता’ इंचि पेन अब्राहामुनतोनि इत्‍ता. मिमेट अय्ते आ करार कीता एनकाटोरा आनि पेनदा कबुरतोरा पिलाल्क आंदिर. ");
INSERT INTO esg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","पेन ओना सेवक येसुन मर्रा जीवा अरहतस्के, मीकुन कराब हरदाल तप्पिचि आसिर्वाद हियनाहाटीं मोदाला मीहेके लोहता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रु आनि योहान लोकुल्‍कुनतोनि वळकसेके मननेंके पेर्मालोर्क, गुळिता कावेल कियानोरा दरोगाल आनि सदुकिर ओरगा वातुर. ");
INSERT INTO esg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","येसु बल्हा अय्ते हातोरा लोप्पोटाल मर्रा जीवाते तेदतोर, अल्‍हेने हातोर मर्रा जीवाते तेदंतुर इंचि पत्रु आनि योहान लोकुल्‍कुंक कराहमळतुन हूळसि ओर्कु इरगा होंग वाता. ");
INSERT INTO esg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","पजा ओर ओर्कुन पीतुर गानि पोळ्‍दु होत्‍ता इंचि इंकुंदि रोजुनदाका ओर्कुन जेलने बंद कीसि इरतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","गानि बोर अय्ते ओरा पोल्‍लें केंजतुरो, ओराव्टेटाल वेल्‍लेन मंदि येसुनपोर्रो विस्वासम कीतुर. विस्वासम कीतोरा लोप्पोटाल मांड्‍सा दग्‍गेर-दग्‍गेरा हेय्युं वेयकुनदाका आतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","इंकुंदि रोजु यहुदि पेद्‍दाल्क, राज्येम कियानोर आनि दर्मसास्‍त्रम कराहना गुरुल्क येरुसलेमते जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","इंका पेद्‍दा पेर्माल हन्‍नाल ओना जीवातोर कयपाल, योहान, सिकंदर आनि ओना लोतुर अंटोर अगा मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ओर पत्रुन आनि योहानुन ओरा नड्‍डुम निलाहचि, “मिमेट बद ताकतते, बोना पोरोलते इव कबाह्‍क कीतिर?” इंचि ओर्कुन पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","अस्‍के पत्रु पवित्र आत्माते निंडसि इल्‍हा वळकालय दल्‍गतोर. ए लोकुल्‍कुनपोर्रो राज्येम कियानोरिटा अल्‍हेने पेद्‍दाल्कुरिटा! इय्याला वरोन कुंटिन बेस कीताहेंके, ओर बल्हा बेस आतोर, इंचि माकुन तल्कसेक मंतिर. ");
INSERT INTO esg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","अय्ते मीकु अंटोर्क आनि इस्राएलता लोकुल्‍कुंक, नासरेत नाटेना येसु किरिस्‍तुना पोरोलतेन ई मनकल बेस आसि मी मुन्‍ने नित्‍तिसि मंतोर इंचि तेळियमळ गावाले. मिमेट, मीवा लोकुल्‍क, येसु किरिस्‍तुन क्रुस पोर्रो मोल्‍लां कोहकिसि हव्कतिर गानि पेन ओन हातोरा लोप्पोटाल मर्रा जीवाते तेहता ");
INSERT INTO esg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“मिमेट लोन दोहालय कबळ्‍क वायो इंचि पोहता बंडे, इंदके लोतुक अव्‍सरमाता बंडा आता, इंचि दर्मसास्‍त्रमते रासि मंता. अदे बंडा ई येसु आंदुर. ");
INSERT INTO esg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","येसुना पोरोल तप्‍पा मब्बुना हिळु मनानोरा बोना पोरोले मनाकुन पापमताल पिसागोट्‍टो, इंका बोरे मनाकुन पिसागोट्‍टोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ओर पत्रुन आनि योहानुन हूळसि इस्कुल करियवोर, सादा मनकालोर आंदुर इनकुत्‍तुर, गानि ओरा दैरनेम हूळसि इचंत्रम आतुर. अस्‍के ईर येसुनतोनि मत्‍तोर आंदुर इंचि ओर्कुन एरपाट कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","बेस आता कुंटि ओरतोनि नित्‍तिसि मत्‍तद हूळसि ओर्कु अड्‍डम बतल वळका पराहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","अदुनहाटीं ओर पत्रुन आनि योहानुन इगेटाल पलाते होंट इंचि इत्‍तुर आनि वरोंक-वरोर विचारम कियालय दल्‍गतुर गदा, ");
INSERT INTO esg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ई मनकालोर्कुन मनम बतल कीकोम? येरुसलेमते मनानुर अंटोर्क ईर कुंटिन बेस कीता चिन्‍ह एरपाटे, अदुन मनम निजम आयो इंचि इना परोम. ");
INSERT INTO esg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","गानि इद पोल्‍ले एक्‍को लोकुल्‍कुंक तेळियामन्‍नि इत्‍ते ओर्कुन मनम, मिमेट येसुना पोरोल इंका बोना मुन्‍ने एतमट, इंचि वेराहकोम, इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","अस्‍के ओर्कुन मर्रा केय्‍सि, “मिमेट येसुना पोरोलते बतले वळ्‍कमट, बतले कराहमट,” इंचि आदेस हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","गानि पत्रु आनि योहान, “पेनदा पोल्‍ले केंजाका मीवा पोल्‍ले केंजमळ इद पेनदा मुन्‍ने न्‍यायामेना? मिमेटे वेहाटु. ");
INSERT INTO esg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","बदाय्ते मोमोट हूळतोम, केंजतोम अदुन वेहाकोंटा मनमळ मावातोनि आया परो,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","अगा जर्गुतदुन हूळसि, अंटोर लोकुल्‍क पेनदा स्‍तुति कियालय दल्‍गतुर. अदुनहाटीं लोकुल्‍कुना वेर्रेक ओर्क सिक्‍सा हियाका, ओर्कुन मर्रा वेराहचि होळसीतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","बोर मनकल अय्ते चमत्‍कार आसि बेस आतोरो, आ मनकल नल्‍पै वर्साना पोर्रो मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पत्रुन, योहानुन होळसीतस्के ओर ओरा दंटातोरगा वापस वासि, पेद्‍दा पेर्मालोर्क, यहुदि पेद्‍दाल्क इत्‍ता पोल्‍लें अंता ओर्कु वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ओर वेहतद केंजसि, ओर अंटोर कलियसि उंदे पेद्‍दा आवाजते पेनदुक पारतना कियालय दल्‍गतुर. “सामि! मब्बु, बूमि, समुद्रम आनि अवुना लोप्पो बतल अय्ते मंता, अवुन निमेन पुटिस्तिन. ");
INSERT INTO esg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","नीवा पवित्र आत्माताहेंदाल नीवा सेवक, मावा एनकटा पेद्‍दा मनकल दाविद राजाना तोळ्‍दाल निमे इल्‍हा वेहतिन गदा, वेरे जाति लोकुल्‍क बारि लोल्‍लिं कीतुर? लोकुल्‍क वट्‍टिदे अव्‍सरम हिल्वा पिलानकु बारि कीसेके? ");
INSERT INTO esg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ई बूमिपोर्रोटा राजालोर पेनदुक अड्‍डम लडाइहाटीं तयार आतुर. राज्येम कियानोर अंटोर उंदि आसि, पेनदुक आनि दाना किरिस्‍तुंक अड्‍डम, आतुर.” ");
INSERT INTO esg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“निजमे, निमे पेरकुंचि लोहचीता नीवा पवित्र सेवक येसुना विरोदमते हेरोद आनि पुंतुस पिलातुसगुडा वेरे जातितोरतोनि, इस्राएल लोकुल्‍कुनतोनि कलियसि उंदि आतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","बारित्‍ते नीवा ताकत नीवा इच्‍चाते इल्‍हा जर्गना इंचि निमे मुन्‍नेने निरनायम कीतिन. अल्‍हेने जर्गसि पूरा आता. ");
INSERT INTO esg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","अदुनहाटीं, सामि! इंदके ओर वेराहसेक हूळा, नीवा पोल्‍ले दैरनेमते वेहालय सेवाकुल्कुंक बलम हीम. ");
INSERT INTO esg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","रोगाल्क बेस कियालय, नीवा पवित्र सेवक येसुना पोरोलते चिन्‍हां, इचंत्रमता कबाह्‍क किया परालय नीवा कय हाहचि बलम हीम,” इंचि पारतना कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","पारतना कीतारित्‍ते, ओर जमा आसि मत्‍ता जेगा मेदुलता, ओर अंटोर पवित्र आत्माते निंडिसोंचि पेनदा पोल्‍ले वेरियाकोंटा वेहालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","विस्वासुल्‍क अंटोर उंदि मनसु, उंदि जीवा आसि मत्‍तुर. बोरन्‍ना आयि बदे सोम्मु, इद नावद इंचि इनाकोंदुर, गानि बोनगन्‍ना बतलन्‍ना मत्‍ते दान तूसकुनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","येसु सामि हासि मर्रा जीवाते तेदतोर, इंचि ओना पेद्‍दा ताकतते प्रेरितुल्क गवाइ हियुंदुर. इल्‍हा ओर अंटोरपोर्रो पेनदा कुर्पा मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","ओरा लोप्पो बोनके बतल तक्‍को मनाहिल्‍ले. बूमि, लोहकु मत्‍तोर, अवुन अम्मिसि वाता कोत्‍तन तच्‍चि प्रेरितुल्कुंक हियुंदुर. बोन्क बच्‍चोर गरज मंता अच्‍चोर तूसि हियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","साइप्रस दीबेते पुटता योसेप इनना लेवि वंसमतोर वरोर मत्‍तोर. ओन्क प्रेरितुल्क बरनाबास इंचि पोरोल दोस्तुर. बरनाबास इत्‍ते “अंटोर्कुन समत कियना मनकल” इंचि अर्तम. ");
INSERT INTO esg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ओर ओना नेलितुन अम्मिसि वाता कोत्‍तन अंता प्रेरितुल्कुंक हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्या पोरोलतोर वरोर मनकल अल्‍हेने ओना मुत्‍तो सपीरा, ईर इव्वुर कूळसि ओरदे इच्‍चो बूमितुन अमतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","वाता कोत्‍तानाल इच्‍चुं कोत्‍तां इरकुत्‍तोर इंचि ओना मुत्‍तोंक एर्के मत्‍ता, कडमता कोत्‍तां ओसि प्रेरितुल्कुंक हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","अदुन हूळसि पत्रु, “हनन्या! निमे बूमि अमता कोत्‍तानाल इच्‍चुं कोत्‍तां इरकुत्‍तिन. अय्ते पवित्र आत्मातोनि आबद्‍दम वळकालय नीवा मनसुने देय्यम बारि होळियता? ");
INSERT INTO esg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","आ बूमि अम्मका मुन्‍ने नीवदे मत्‍ता गदा! अम्मुतंकागुडा वाता कोत्‍तन पोर्रो नीवदे अदिकारम मत्‍ता. अय्नागानि पेनदुक इस्‍टम हिलवद कबळ कियालय नीवा मनसुने बल्हा वाता? निमे मनकलोरतोनि आयो गानि पेनतोनि आबद्‍दम वळ्‍कतिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ई पोल्‍लें केंजतारित्‍तेन हनन्‍याल हिळु अर्सि जीवा होळ्‍सतोर. अचोने आयका ई पोल्‍लें केंजतुर अंटोर्क पेद्‍दा वेर्रे दल्‍गता. ");
INSERT INTO esg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","अस्‍के लेय्युर्क तेदसि ओन्क कपडि हुट्‍सि पलाते ओसि बोंदा दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","दग्‍गेर-दग्‍गेरा मूड गंटां आतंका ओना मुत्‍तो लोप्पो वाता. अगा बतल जर्गुता दान्क तेळिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","अस्‍के पत्रु अद वातद हूळसि, “मीवा बूमि इच्‍चोट्‍के अमतिरा वेहा!” इंचि तल्कतस्‍के, “आ इच्‍चोट्‍के अमतोम,” इंचि अद इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पत्रु दान मर्रा, “मिमेट इव्वुर सामिना आत्माता परिक्‍सा बारि हूळालय दल्‍गतिर? हूळा नीवा मुय्दोन बोंदा दोसतोर गलमातगेन एवतुर, ओर नीकुन इंका अल्‍हेने ओयानुर.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ओर अल्हा इत्‍ता इन्‍मळे अद ओना काल्‍कुन मुन्‍ने अर्सि अल्हेन जीवा होळसीता. पजा दाना मुय्दोन बोंदा दोस्ता लेय्युर्क लोप्पो वासि हूळतस्‍के अद मुरतळ हासि दिसता. ओर दान इंका तेहकुंचि ओसि दाना मुय्दोना पक्‍काते बोंदा दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","अस्‍के येरुसलेमता कलिसियातोर अंटोर, ई पोल्‍लें बोर अय्ते केंजतुरो ओर अंटोर बागा वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","अल्‍हेने प्रेरितुल्कुना कय्‍दाल वेल्‍ले चिन्‍हां, इचंत्रमता कबाह्‍क लोकुल्‍कुना मुन्‍ने आयुंदुं. विस्वासुल्‍क अंटोर गुळिते सुलेमान राजाना पंदिरतगा बस्‍केळ्‍क उंदि मनसुने जमा आयुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","अविस्वासुल्‍क ओरतोनि कलियालय वेरियुंदुर, गानि विस्वासुल्कुना बेस कदर कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","अयना वेल्‍लेन मंदि मुर्ताह्क-मांडसा सामिन विस्वासम कीसि ओरगा वासि कलियुंदुर, इल्‍हा एक्‍कोते एक्‍को मंदि बेरस्सेक होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","प्रेरितुल्कुना कबाह्‍कुन हूळसि लोकुल्‍क बिमार मत्‍तोर्कुन कटुल्‍कुने, केत्‍तिने पत्रु होनना हर्दागा तच्‍चि इर्रुंदुर. पत्रु होननेंके ओना नीडाय्‍ना बिमारतोरा पोर्रो अरते ओर बेस आयनुर इंचि लोकुल्‍कुना आसे मनुंदु. ");
INSERT INTO esg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","अचोने आयका येरुसलेम सहरता पक्‍का पीसि मत्‍ता नाहकुनाल वेल्‍लेटुर बिमार मत्‍तोर्कुन, देय्याल्क पीतोर्कुन अगा पीसि वायुंदुर. ओर अंटोर प्रेरितुल्कुना कय्‍दे बेस आयुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","अस्‍के पेद्‍दा पेर्माल, ओनातोनि मत्‍ता सदुकिर्क, प्रेरितुल्कुन हूळसि ओरा मनसु मसुलुंदु. ");
INSERT INTO esg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","अदुनहाटीं प्रेरितुल्कुन पीसि जेलने वाटतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","गानि अदे नर्का उंदि पेनदा दूता वासि जेलना तल्‍पु तेंडसि ओर्कुन पलाते ओता. ");
INSERT INTO esg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ओसि, “होंटु, गुळिते नित्‍तिसि ई पूना पिस्वरता अन्‍नि पोल्‍लें अंटोर लोकुल्‍कुंक वेहाटु,” इंचि ओर्कु वेहता. ");
INSERT INTO esg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","पेनदा दूता वेहतद केंजसि ओर पोळ्‍दु पेय्सतंका गुळिते होंचि लोकुल्‍कुंक कराहलय दल्‍गतुर. हीके, पेद्‍दा पेर्माल आनि ओना दंटातुर, इस्राएलता अंटोर पेद्‍दाल्कुन पंचादिते केय्‍सि, प्रेरितुल्कुन जेलनाल तायालय लोहतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","गानि सिपाइल्क जेलने होंचि हूळतस्‍के अगा प्रेरितुल्क मना हिल्‍लुर, अदुनहेंके ओर मल्सि वासि, ");
INSERT INTO esg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“जेलता तल्‍पुकुंक अय्ते तालम वाटसि मत्‍ता. सिपाइल्कगुडा गलमानगा नित्‍तिसि मत्‍तद मोमोट हूळतोम, गानि तल्‍पु तेंडसि लोप्पो हूळतस्‍के लोप्पो बोरे मना हिल्‍लुर,” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","गुळितगा कावेल कियानोरा अदिकारि आनि पेद्‍दा पेर्मालोर इद केंजसि, “इंदके बतल आयार” इंचि वेल्‍ले विचारम कियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","अस्‍के बोरो वरोर मनकल वासि, “हुळट, मिमेट जेलने वाटतुर गुळितगा नित्‍तिसि लोकुल्‍कुंक येसुना पोल्‍लें कराहसेक मंतुर.” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","अस्‍के आ अदिकारि, गुळिता कावेल कियानोर्कुन पीसि गुळितगा होत्‍तोर. होंचि, लोकुल्‍क मापोर्रो बंडां हुक्‍सि हव्कानुर इत्‍ता, वेर्रेते ओर्कुन बतले बल्‍मि कियाकोंटा पंचादितगा तत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ओर्कुन पीसि तच्‍चि पंचादिता मुन्‍ने निलाहतोर. अस्‍के पेद्‍दा पेर्माल ओर्कुन, ");
INSERT INTO esg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ई येसुना पोरोलते करुहमट इंचि मोमोट मीकु कडक आदेस हिय्‍यिना गानि मिमेट पूरा येरुसलेम अंता ओना पोरोलते कराहतिर. अचोने आयाका ओन मोमोटे हव्कतोम इंचेके मावा पोर्रो तप्पु दोसालय हूळसेक मंतिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","अदुनहाटीं पत्रु, कळमता प्रेरितुल्क, “माकु मनकालोरा पोल्‍लें आयो, गानि पेनदा पोल्‍ले केंजा पींता. ");
INSERT INTO esg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","मिमेट येसुन क्रुस पोर्रो वेलाड वाटसि हव्कतिर गानि मावा पेद्‍दाल्कुना पेन ओन हामुरताल मर्रा तेहता. ");
INSERT INTO esg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","हामुरताल तेहचि ओने पेन, राजाल आनि पिसागोटनोर इंचि निलाहता. मावा इस्राएलता दादालोर्कुंक मनसु मार्सकुनालय, पापाल्कुनाल मापि कियालय पेनदा तिना बाजुंक ओन कदर हीसि उपिस्ता. ");
INSERT INTO esg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","इव अन्‍नि पोल्‍लेनहाटीं मोमोट गवाइ मंतोम. पेनदा पोल्‍लें केंजसि ताकानोराहाटीं पवित्र आत्मागुडा गवाइ मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ओरा पोल्‍लें केंजसि, आ पंचादिता पेद्‍दाल्कुंक होंग वासि ओर्कुन हव्कना विचारम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","गानि पंचादितगा गमलियेल पोरोलतोर वरोर परिसि, ओर मूसाना नियमता गुरुजीगुडा मत्‍तोर, ओन अंटोर कदर कियुंदुर. ओर तेदसि प्रेरितुल्कुन गडसेम पलाते ओयालय वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ओर्कुन पलाते ओतस्के, ओर पंचादिता मुन्‍ने, “मावा इस्राएलता लोकुल्‍कुनिटा! मिमेट ओर्कुन बतल कींतोम इंचंतिरो, बेस विचारम कीसि कीम्‍टु. ");
INSERT INTO esg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","बारित्‍ते कोन्‍नि रोजकु मुन्‍ने तियुदास पोरोलतोर वरोर मनकल, ‘नना पेद्‍दोन’ इंचि वेहकुत्‍तोर. ओना पज्जो नालुं नुह्कुना मंदि इंका मत्‍तुर. गानि ओन हव्कतुर, अस्‍के ओना पज्जो ताकानोर अंटोर बेंदोर-हेके पायसि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","अद आता पज्जो सिरगंतिता वेलाते गालिल एरियाता यहुदल इनानोर वातोर. ओर इंका वेल्‍लेने लोकुल्‍कुन ओनाहेके कीकुत्‍तोर गानि ओन इंका हव्कतुर. ओना पज्जो ताकानोर अंटोर बेंदोर-हेके पायसि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","अदुनहाटीं इंदके इंका नना मीकु वेहसेक मंतन, मिमेट पीतोर्कुन बतले कियमट, ओर्कुन होळसीम्टु. ओरां विचाराल्क, ओरां कबाह्‍क मनकानव मनानय्ते मायसि दांतां. ");
INSERT INTO esg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","गानि पेनदाहेंदाल मनानय्ते दान मिमेट आपा पर्रिर, मिमेट आपालय हूळते मात्रम पेनदुक अड्‍डम आंतिट,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","अस्‍के पंचादितोर, गमलियेलना पोल्‍ले केंजतुर. पजा प्रेरितुल्कुन लोप्पो केय्‍सि ओर्कुन पोट्‍टेते तन्‍ना वेहचि, येसुना पोरोलते बग्‍गेन वेहमटु इंचि वेहचि होळ्‍सीतुर. ");
INSERT INTO esg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","प्रेरितुल्कुन होळसीतस्के, येसुना पोरोलताहाटीं मोमोट देब्बां तित्‍तोम, इंचि बेस आनंदमते पंचादिताल पेय्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","रोज गुळितगा, लोन-लोन होंचि, येसु ईरे किरिस्‍तु आंदुर इंचि पेनदा बेसता कबुर वेहामळ, कराहमळ होळसा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","इल्‍हा विस्वासुल्‍क वेल्‍लेन बेर्स्‍सेक होत्‍तुर. अय्ते अवे रोजकुने युनानि बासा वळ्‍काना यहुदिल्कु, इब्रानि बासा वळकाना यहुदिल्कुनतोनि, “रोज हिय्यना गाटोता बारेमते मावा मुंडामोस्ता मुरताह्कुनहेके बेस हूळसेक हिल्‍लिर,” इंचि जगडम दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","अस्‍के आ पन्‍नेंड मंदि प्रेरितुल्क अंटोर विस्‍वासुल्‍कुन उंदगा केय्‍सि, “पेनदा पोल्‍लें कराहमळ पक्‍कक इरसि गाटो पंचि तासेक मनमळ मावाहाटीं बेस आयो. ");
INSERT INTO esg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","अदुनहाटीं नावा विस्वासुल्‍कुनिटा! मिमेट मीवव्टेटाले बेस कदर, बुद्‍दि आनि पवित्र आत्माते निंडिस मत्‍ता एडुर मांडसातुन पेरकुंट. मोमोट ओर्कुन ई कबळ पोर्रो इर्रांतोम. ");
INSERT INTO esg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","अस्‍के पारतना, पेनदा पोल्‍लें कराहना मावा सेवा कबळ आगाकोंटा जर्गसेक मनंता.” इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","इद पोल्‍ले अंटोर्कुंक नच्‍चुताहेंका ओर विस्वासमते, पवित्र आत्माते निंडिस मत्‍ता स्‍टिपन इनानोन पेरतुर. ओन वरोने आयका पिलिपुस, परकोरस, निकानोर, तिमोन, परमिनास आनि अंताकिया नाटेना निकोलस (ईर ओना जाति होळसि यहुदि जातिते वातोर) पोरोलतोर्कुन पेरतुर. ");
INSERT INTO esg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","पजा ईर एडुरकुन प्रेरितुल्कुना मुन्‍ने निलाहतुर. अस्‍के प्रेरितुल्क ओरपोर्रो कय इरसि पारतना कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","इल्‍हा पेनदा पोल्‍ले वेल्‍लेन मंदिक एवसेक होत्‍ता. येरुसलेमते विस्वासुल्कगुडा वेल्‍लेन आतुर. अचोने आयका वेल्‍लेन मंदि यहुदि पेर्मालोर्कगुडा विस्वासमते वातुर. ");
INSERT INTO esg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","पेनदा कुर्पाते, ताकतते निंडिस मत्‍ता स्‍टिपन लोकुल्‍कुना मुन्‍ने पेद्‍दा-पेद्‍दा इचंत्रमता कबाह्‍क, चिन्‍हां कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","गानि स्वतंत्रम दोर्कुता यहुदि लोकुल्‍कुना दर्मसास्‍त्रम कराहना लोताल इच्‍चुर लोकुल्‍क वासि स्‍टिपनुनतोनि जगडम दोसकुत्‍तुर. आ लोकुल्‍कुने कुरेनि, सिकंदरिया इनना सहरकुने मनना यहुदि लोकुल्‍क आनि किलिकिया, आसिया इनना एरियान पीसि मनना यहुदिल्कु मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","गानि वळ्‍कानाहाटीं पवित्र आत्मा स्‍टिपनुंक तेल्वि हीता. अदुनहाटीं आ लोकुल्‍क ओना पोल्‍लेंक अड्‍डम वळका पराहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","पजा आ यहुदि लोकुल्‍क वेरेतोर्क तेळियाकोंटा इच्‍चुर लोकुल्‍कुंक लंचम हीसि, स्‍टिपन, मूसानद आनि पेनदा अपमानम आयना पोल्‍लें वळकानेंके मोमोट केंजतोम, इल्‍हा आबद्‍दम वळकालय वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","अल्‍हेने ओर अगाटा लोकुल्‍कुन, यहुदि पेद्‍दाल्कुन, दर्मसास्‍त्रम कराहना गुरुल्कुनगुडा एक्‍किस्तुर. अस्‍के ओर स्‍टिपनुन दोर्कापीसि यहुदिल्कुना पेद्‍दा पंचादिते तत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","अय्ते आ पंचादिते लंचम तित्‍ता गवाइदार्क निलसि, “ई मनकल पवित्रमाता जेगा इत्‍ते गुळिता बारेमते इंका मूसाल वेहता नियमता बारेमते तप्‍पुड पोल्‍लें बस्‍केळ्‍क वळ्कसेक मनांतोर. ");
INSERT INTO esg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","बारित्‍ते, नासरेत नाटेना येसु इद गुळितुन कूलाह्‍चि नासडेम कियानुर आनि मूसाल वेहता रीति-रिवाजकुन बदलांचनुर, इंचि वेहनेंके मोमोट केंजतोम” इल्‍हा गवाइ हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","अस्‍के अगा पंचादिते उद्‍दिस मत्‍ता अंटोर लोकुल्‍क स्‍टिपनुनहेके बागा हूळतुर. अय्ते ओर्कु स्‍टिपनुना मोकम पेनदा दूताता मोकमलेह्का दिसता. ");
INSERT INTO esg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","पजा पेद्‍दा पेर्माल, “ईर वेहना पोल्‍लें निजमेना?” इंचि स्‍टिपनुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","अस्‍के स्‍टिपन ओर्कु इल्‍हा वेहालय दल्‍गुतोर, “नावा दादालोर आनि बाबानसोंटा पेद्‍दाल्कुनिटा! नना वेहनद केंजट. मना एनकटा पेद्‍दा मनकल अब्राहाम मातरल मेसोपोटामिया देसेमतुन होळसि हारान इनना सहरते हेराका मुन्‍नेन पेन दाना महिमाते ओन्क दिसता. ");
INSERT INTO esg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","दिस्‍सि, निमे नीवा देसेमतुन, नीवा जीवातोर्कुन होळसिसि नना नीकु हुपिचना देसेमते होन, इंचि ओन्क वेहता. ");
INSERT INTO esg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","अस्‍के अब्राहाम कसदिल्कुना देसेम होळसि हारान एरियाते होंचि मनालय दल्‍गुतोर. ओना बाबाल हासोत्‍तंका पेन ओन अगटाल इंदके मिमेट मनना ई देसेमते लोहता. ");
INSERT INTO esg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","अयना पेन इगे ओन्क अळगुमेड बूमिगुडा हिय्या हिल्‍ले. गानि ओन्क संतानम हिलुवा रोजकुनेगुडा पेन, ई देसेमतुन, ई बूमितुन नीकु हींतन, नीवा पज्जोटाल वायाना नीवा वंसमतोर्कुंक हींतन, इंचि ओन्क पोल्‍ले हीता.” ");
INSERT INTO esg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“अचोने आयका पेन ओनातोनि, नीवा वंसमतोर वेरे देसेमते होंचि मनांतुर, अगाटा लोकुल्‍क नीवा वंसमतोर्कुन नालुं नुहकुना वर्सांनदाका गुलामगिरिते इरसि, वेल्‍ले तकलिप हींतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","गानि बोर अय्ते नी वंसमतोर्कुन गुलामगिरिते इर्रांतुरो ओर्कु नना सिक्‍सा हींतन, पजा नीवा लोकुल्‍क अगटाल पेय्सि वासि इद जेगाते नाकु पूजा कियानुर, इंचि वेहता.” ");
INSERT INTO esg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“पजा पेन अब्राहामुनतोनि कतना इनना उंदि करार कीता. अदुनहाटीं अब्राहामुंक इसहाक पुटतस्के ओर एनमिदि रोजकुनोर मनानेंकेन ओना कतना कीतोर. इल्हेन इसाकुंक याकोब पुटतोर. पजा याकोबुंक पन्‍नेंडु मंदि मर्कु पुटतुर. ईरद अंटोरदगुडा कतना आता. इल्‍हा ई पन्‍नेंड मंदि मर्कुनाले मुन्‍ने इस्राएलता पन्‍नेंड वंसाल्कु तयार आतां. ईरे ई पन्‍नेंड वंसाल्कुना मोदोल मनकालोर आतुर.” ");
INSERT INTO esg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“याकोबुना मर्कु ओराव्टेटाल योसेप इनानोन पोर्रो अळूंदुर. अदुनहाटीं ओर ओन इजिप्‍त देसेमते गुलामगिरि कियालय अमतुर, गानि ओना पेन ओन्क सायता मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ओन अन्‍नि कस्‍टाल्कुनाल दक्‍किस्ता. इंका पेन ओन्क बेस बुद्‍दि हीता. पेन हीता बुद्‍दितोनि ओर इजिप्‍त देसेमता पिरोन राजाना मनसु गेल्‍स्‍कुत्‍तोर. पजा इजिप्‍त देसेमता पिरोन राजाल ओना देसेमपोर्रो, ओना राजवाडानपोर्रो अदिकारि इंचि इरतोर.” ");
INSERT INTO esg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“अच्‍चोटेन कनान आनि इजिप्‍त देसेमते पेद्‍दा करवु अर्सि लोकुल्‍क इरगा कस्‍टाल्‍कुने अरतुर. इंका मना एनकटा पेद्‍दाल्कुंक तिनालय बतल दोर्काकोंटा आता. ");
INSERT INTO esg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","इजिप्‍त देसेमते गाटो मंता इंचि तेळियतस्के याकोब मना एनकटा पेद्‍दाल्कुन अगा मोट्‍टा-मोदाटा मल्का लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ओर रोंडो मल्का होतस्के योसेप ओना बारेमते ओना दादालोर-तम्मुह्‍कुंक वेहतोर. अस्‍केन पिरोन राजांकगुडा योसेपना कानदानता बारेमते एरपाट आता. ");
INSERT INTO esg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","अस्‍के योसेप ओना बाबाल याकोब आनि कानदानता अंटोर्कुन इत्‍ते पूरा डेब्बै हेय्युर मंदितुन इजिप्‍तते केया लोहतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","अस्‍के याकोब इजिप्‍त देसेमते होत्‍तोर. अग्गेन याकोब आनि मना अंटोर एनकटा पेद्‍दाल्क इंका हातुर. ");
INSERT INTO esg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","पजा ओरा पीनगुल्कुन इस्राएल देसेमता सेकेम इनना सहर ओसि, अगा हामोर इनना मनकना मर्कुनहेंदाल नगदि कोत्‍तां हीसि अब्राहाम उंदि बोंदा अस्सि मत्‍तोर, अदे बोंदाते ईरदगुडा गति कीतुर.” ");
INSERT INTO esg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“अब्राहामुंक पेन हीता पोल्‍ले पूरा आयना वेला दग्गेर्क एव्ता, अस्‍के इजिप्‍त देसेमते मना लोकुल्‍क वेल्‍लेन आतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","कोन्‍नि रोजकु आतारित्‍ते योसेपुन बारेमते बतले एरपाट हिलुवा बोरो वरोर दुस्‍ट मनकल इजिप्‍त देसेमता राजाल आतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ओर राजाल मना लोकुल्‍कुंक वेल्‍ले तकलिप हीतोर. मना लोकुल्‍कुना पिलाल्क पिसा मन्‍नि इंचि ओर्कुन पलाते पोहचियालय वेहतोर.” ");
INSERT INTO esg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“अदे कालमते मूसाल पुटतोर. पेनदा नदरते आ पेडल सक्‍कगा मत्‍तोर. आ पेडल मूड नेल्क ओना बाबाना लोते मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","पजा बस्के अय्ते आ पेडन ओना तल्‍लुर-बाबो पलाते होळसीतुरो अस्‍के पिरोन राजाना मिय्यड ओन तेहकुंचि ओसि, दाना मर्रिनलेसीं पोस कीता. ");
INSERT INTO esg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसांक इजिप्‍त देसेमता बेसता विद्‍दे कराहमळ जर्गुता. मूसाल पोल्‍लेने आनि कबळते रोंडुने इंका बेस हुसार मत्‍तोर.” ");
INSERT INTO esg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ओर नल्‍पै वर्सानोर आतोर अस्‍के ओना लोकुल्‍कुंक इत्‍ते इस्राएलना लोकुल्‍कुंक होंचि कलियना मनसु आता. ");
INSERT INTO esg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","पजा अगा होत्‍तस्के इस्राएल लोकुल्‍कुनाल वरोन मनकनपोर्रो इजिप्‍त देसेमता वरोर मनकल अन्‍यायम कियानद हूळतोर. हूळसि आ अन्‍यायम कियना इजिप्‍त मनकन हव्‍किसि आ इस्राएल मनकन कापाळसि ओना बदला एततोर. ");
INSERT INTO esg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","इस्राएल लोकुल्‍कुन पिसागोटनाहाटीं पेन ओन वाळकुंचंता इत्‍ता संगतितुन ओना लोकुल्‍क एरपाट कींतुर इंचि ओर इन्कुत्‍तोर, गानि अद ओर्क तेळिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","इंकुंदि रोजु ओना लोकुल्‍कुनाले बोरो इव्वुर मनकालोर उर्रें अर्रनद हूळसि ओर्कुन कल्‍पना उद्‍देसमते, अरे मिमेट बसंटा मनकालोर आंदिर? दादल-तम्मुह्‍क आसिगुडा, वरोनपोर्रो वरोर अन्‍यायम कीसंतिर! इंचि ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","अस्‍के ओना पक्‍कातोनपोर्रो अन्‍यायम कीसेके मत्‍ता मनकल मूसन पक्‍कक दोब्‍बिसि, माकुन जगडमताल पापसि, मावा न्‍यायम कियना अदिकारम नीकु बोर हीतोर? ");
INSERT INTO esg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","निन्‍ने आ इजिप्‍त मनकन हव्कुताप, नाकुनगुडा हव्कंतन इनकुंचंतिना?” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","इद पोल्‍ले केंजसि मूसाल इजिप्‍त देसेम होळसिसि मिदान देसेमते पेय्सि होत्‍तोर. अगा होंचि वरोर पराय देसेमतोनलेसीं पिसालय दल्‍गुतोर. अग्गेन मरमिं आतोर, अस्‍के ओन्क इव्वुर मर्कु पुटतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","इल्‍हा नल्‍पै वर्सां आसि होत्‍तां. अय्ते उंदि रोजु मूसांकु सिनाइ इनना गुट्‍टा दग्‍गेरा बय्‍लि जेगाते पोत्‍तना पोदाता लोप्पो उंदि पेनदा दूता दिसता. ");
INSERT INTO esg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","अदुन हूळसि मूसांक इचंत्रंम आता. दग्गेर्क होंचि बेस हूळकोम इंचि मुन्‍नेळ्‍क अळगु वाटनपेडकु ओन्क पेनदा अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","पेन मूसनतोनि, नना नीवा एनकाटोरा तादो-बाबुरा पेनदुन आंदुन, इत्‍ते नना अब्राहाम, इसाक, याकोबना पेनदुन आंदुन, इंचि वळ्कुतोर. अस्‍के मूसाल इरगा वेरियकुत्‍तोर. ओन्क तला तेहचि पोर्रोळ्‍क हूळना हिम्मत आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","अस्‍के पेन ओन, निमे नित्‍तिसि मनना जेगा पवित्र जेगा आंदु. नीवा काल्कुना हेरपुह्क तेंडा. ");
INSERT INTO esg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","इजिप्‍त देसेमते मनना नावा लोकुल्‍कुना तकलिप नना हूळतन, ओरा अळमळ नना केंजतन. इंचि ओर्कुन कस्‍टाल्कुनाल तेंडानहाटीं नना हिळु रेयतन. अय्ते वा! इंदके नना नीकुन मर्रा इजिप्‍त देसेमते लोहंतन. इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","बा मूसन अय्ते इस्राएल लोकुल्‍क, माकुन जगडमताल पापसि, मावा न्‍यायम कियना अदिकारम नीकु बोर हीतोर? इंचि हय्साकोंटा पकाक दोबसीतुरो, आ मूसाने पेन पोत्‍ताना पोदाते दिसता पेनदा दूताता हेंदाल ओरा राज्येम कियानोर आनि पिसागोटनोर इंचि लोहता. ");
INSERT INTO esg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","इल्‍हा मूसाल, एर्रा समुद्रम आनि बय्‍लि जेगाते नल्‍पै वर्सनदाका इचंत्रमता कबाह्‍क कीसेक, चिन्‍हां हुप्‍पिचेक आ लोकुल्‍कुन इजिप्‍त देसेमताल पलातुक पेचाहचि तत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ईर, ओरे मूसाल आंदुर, बोर अय्ते इस्राएलना लोकुल्‍कुन, पेन मीहाटीं मीवा लोप्पोटाले वरोन नावसोंटा पेनदा कबुरतोन लोहंता, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","मना इस्राएल लोकुल्‍क बय्‍लि जेगाते मत्‍तस्के ओरतोनि कलियसि मत्‍तोर ईरे मूसाल आंदुर. इंका सिनाइ गुट्‍टापोर्रो पेनदा दूतातोनि ईरे मूसाल वळकुतोर. अचोने आयका पेन दाना पिस्वर हियना पोल्‍लेन मनाकु एवसानाहाटीं बोन्क अय्ते हीतानो ओर ईरे मूसाल आंदुर. ");
INSERT INTO esg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","गानि मना एनकटा पेद्‍दाल्क मात्रम ओर वेहताप ताकालय तयार मना हिल्‍लुर. मर्रा ओरा मनसु इजिप्‍त देसेमताहेकेन तिरियता. ");
INSERT INTO esg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","अस्‍के आ लोकुल्‍क वरोर हारून इनानोनतोनि, माकुन इजिप्‍त देसेमताल पलाते तत्‍ता आ मूसांक बतल आतानो माकु बतले तेळियसेक हिल्‍ले. अदुनहाटीं मावा मुन्‍ने ताकालय पेनकु तयार कीम, इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","पजा ओर अंटोर कलियसि पेय्यातसंटा उंदि बोम्मा तयार कीसि, आ बोम्मक मोक्‍कुल्क हियालय दल्‍गुतुर. आ बोम्मातुन ओरे तयार कीता कुसिते दाना मुन्‍ने पेद्‍दा पंडुगु कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","दानहाटीं पेन ओरा हेकेटाल मोकम तिराहकुंचि, मब्बुने मनना पोडदुन, वेडसितुन, सुक्‍काना पूजा कियालय ओर्कुन कुल्‍ला होळसीता. इदुन बारेमते पेनदा कबुरतोरा पुस्तकमते, “ए इस्राएल लोकुरिटा, मिमेट नल्‍पै वर्सनदाका, बय्‍लि जेगाते मोक्‍कुल्क, पूजें नावाहाटीं कीतिरा? हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","मिमेट मोलेक इनना पेनदा डेरा आनि मीवा रिपान इनना सुक्‍का पेनदा बोम्मातुनगुडा मीवातोनि ओतिर. मिमेट मोळ्‍कानाहाटीं मिमेटे तयार कीकुत्‍ता अन्‍नि बोम्मां ओतिर. अदुनहाटीं नना मीकुन वेल्‍लेन लक्‍कु मनना, बेबिलोन सहरकन्‍ना हब्बेर लोहांतन.” इंचि रासि मंता. ");
INSERT INTO esg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","मना एनकटा पेद्‍दाल्क केडाते मत्‍तस्के ओरगा उंदि गवाइता डेरा मत्‍ता. अद डेरा मूसाल तयार कीता डेरे आंदु. अद डेरा तयार कियाका मुन्‍ने पेन मूसांक उंदि डेराता नमुना हुप्पिचि, अद मत्‍तापे तयार कीम, इंचि आदेस हीता. ");
INSERT INTO esg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","मना एनकाटोरा मुन्‍नेटाल पेन पेचाहचि गेदुमता वेरे जातितोरा बूमितुन मना लोकुल्‍क, जोसुवाल इनना वरोर मनकन मुन्‍ने अरहचि एतकुत्‍तुर. अस्केगुडा इद डेरा ओरगा मत्‍ता. अद डेरा दाविद राजाना कालमदाका ओरागेन मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाविद राजांक पेन आसिर्वाद हीता, अदुनहाटीं ओर याकोबुना पेनदाहाटीं उंदि गुळि दोहाना इंचि आसे पडतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","गानि पेनदाहाटीं गुळि अय्ते सुलेमान राजाल दोहतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","बच्‍चो बतल अय्नागानि पेन मनकल दोहता गुळिते मन्‍नो. बारित्‍ते इदुन बारेमते पेनदा कबुरतोर इल्‍हा रासतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“पेन इत्‍ता, स्वर्गम नावा राजगद्‍दे आंदु, ई बूमि नना काल्क इर्रना पीटे आंदु. अय्ते मिमेट नावाहाटीं बसोंटा गुळि दोहा परांतिर? नावा आराम किय्यना जेगा बल्हा मंदार? ");
INSERT INTO esg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","इव अन्‍नि नावा कय्‍दे कीतवे आयोंगा!” ");
INSERT INTO esg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","अरे पिस्‍सा लोकुरिटा, मीवा मनसु बारे वेरे जातितोरा मनसुन लेह्का मंता, मीवा केव्क बारे पेनदा पोल्‍लें केंजाकोंटा डोप्पां अरसोत्‍तां. मिमेट बस्‍केळ्‍क पवित्र आत्मातुन पक्‍काक दोबसेके, इंदके मिमेटगुडा मीवा एनकटा पेद्‍दाल्कुनालेसीं कीसंतिर. ");
INSERT INTO esg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","मीवा पेद्‍दाल्क तकलिप हियाकोंटा पेनदा कबुरतोन वरोनगुडा होळसा हिल्‍लुर. वरोर नीतिमंतुड वायानोर मंतोर, इंचि वेहानोर्कुन मीवा एनकटा पेद्‍दाल्क हव्कतुर. इंदके मिमेट बारे, ओर बा नीतिमंतुना बारेमते वेहचि मत्‍तुरो आ नीतिमंतुन दोकाते पीसि हव्कतिर. ");
INSERT INTO esg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","पेनदा दूतानाहेंदाल मीकु मूसाना नियम अय्ते दोर्कुता, गानि मिमेट दाना परकारम ताका हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ओना पोल्‍लें केंजसि पंचादिते मत्‍ता पेद्‍दाल्क वेल्‍ले होंगुंक वासि, ओनाहेके हूळसि पटपटा पल्कु कोर्कालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","गानि पूरा पवित्र आत्मातोनि निंडिस मत्‍ता आ स्‍टिपन स्वर्गमताहेके हूळतोर. अस्‍के ओर पेनदा महिमाता वेल्‍गुन आनि पेनदा तिना बाजुंक नित्‍तिसि मत्‍ता येसुन हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","हूळसि, “हुळाट! स्वर्गम बय्यर आयानद आनि मनकना रूपमते पुटता पेनदा मर्रि पेनदा तिना बाजुंक नित्‍तिसि मत्‍तद नना हूळसंतन,” इंचि ओर इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","अस्‍के आ मंदि केव्क मुच्‍कुंचि, जोरसे वरगेयसेके अंटोर उंदेदम ओनपोर्रो वासि अरतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ओन इग्गिसेक नाटेन पलाते ओसि बंडाने तनालय दल्‍गुतुर. इद जर्गनदान हूळता गवाइदार्क ओरा कपडिं तेंडसि साऊल इनना वरोर लेय्योना काल्‍कुन मुन्‍ने इरतुर. ");
INSERT INTO esg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","लोकुल्‍क बंडाने तनानेंके स्‍टिपन, “येसु सामि, नावा आत्मातुन निमे एतकुन.” इंचि पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","पजा ओर टोंगरां ऊनसि, “हे सामि, ई पापम ईरापोर्रो तासुमा,” इंचि जोरसे वरगेयसि, कळ्‍क मुचतोर. इल्‍हा साऊलगुडा ओना हामुरते पोत्‍तु आतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","अवे रोजकुनाल येरुसलेमता कलिसियातोरपोर्रो पेद्‍दा कस्‍टाल्‍क वायालय सुरुव आता. प्रेरितुल्कुन होळसि कळमातोर अंटोर विस्वासि लोकुल्‍क यहुदिया, सामरिया एरियाता नाहकुने बेकेटोर हेके सिल्‍लर-सल्‍लर आतुर. ");
INSERT INTO esg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","बोरो इच्‍चुर विस्वासुल्‍क स्‍टिपनुन गति कीसि ओनाहाटीं वेल्‍ले दुक्‍कमते मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","साऊल बारे कलिसियातोर्कुन तकलिप हियमळ सुरुव कीतोर. ओर लोन-लोन होंचि मुर्ताह्क इनाका मांडसा इनाका अंटोर्कुन इग्गिसि ओसि जेलने वाटालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","गानि सिलर-सिलर आसि होत्‍ता विस्वासि लोकुल्‍क मात्रम बगा-बगा अय्ते होत्‍तुरो अगा-अगा ओर लोकुल्‍कुंक पेनदा बेसता कबुर वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","पिलिपुस इनना वरोर बक्‍तुड सामरिया सहरते होंचि अगाटा लोकुल्‍कुंक किरिस्‍तुना बारेमते वेहामळ सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","पिलिपुस कीता चिन्‍हां हूळसि लोकुल्‍क ओर वेहाना पोल्‍लेन मनसु ताससि केंजतुर. ");
INSERT INTO esg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","वेल्‍लेन मंदिक देय्याल्क पीसि मत्‍तां, आ देय्याल्क इंका इरगा मोत्‍कुंचेके पलाते पेय्सि विततां. अचोने आयका अगा वेल्‍लेन मंदि कुंटोर्क, कय-काल्क अरसोनना रोगमतोरगुडा मत्‍तुर, ओर अंटोरगुडा बेस आतुर. ");
INSERT INTO esg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","अदुनहाटीं अद सहरते आनंदमे आनंदम मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","अद नाटे सिमोन पोरोलतोर वरोर मनकल मनुंदुर. ओर होदें-मंत्राल्कुना बलमते इचंत्रमाता कबाह्‍क कीसि, नाके एक्‍को तेळियंता, इंचि वेहकुंचेके सामरिया सहरता लोकुल्‍कुन इचंत्रमते अरहुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","सिन्‍नाल्क, पेद्‍दाल्क अंटोर, “पेनदा पेद्‍दा ताकत इत्‍ते ईरे आंदुर,” इनकुंचि, ओना पोल्‍लें केव ताससि केंजुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","बारित्‍ते ओर वेल्‍ले रोजकुनाल ओना मंत्राल्कुना बलमते अंटोर लोकुल्‍कुन इचंत्रमते अरहचि मत्‍तोर. दानहाटींगे लोकुल्‍क ओर बतल वेहिना नम्मुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","गानि पेनदा राज्येम आनि येसु किरिस्‍तुना पोरोलता बारेमते पिलिपुस वेहता बेसता कबुर केंजसि मुर्ताह्क-मांडसा नम्मिसि बापतिस्मागुडा एततुर. ");
INSERT INTO esg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","कुद सिमोन इंका नम्मिसि बापतिस्मा एततोर. इल्‍हा ओर पिलिपुस बेके होत्‍ते हेके होंचेके ओनतोने मनालय दल्‍गुतोर. पजा पिलिपुस कियना चिन्‍हां, अद्‍बूताल्‍क हूळसि इचंत्रमते अर्रुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","सामरिया सहरता लोकुल्‍क पेनदा पोल्‍लेन स्विकार कीतुर इंचि बस्के अय्ते येरुसलेमते प्रेरितुल्कुंक तेळियतनो, अस्‍के ओर पत्रुन आनि योहानुन सामरिया एरियाक लोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","पजा ओर अगा वासि अगाटोर्कुंक पवित्र आत्मा दोर्कना इंचि पारतना कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","बारित्‍ते दीनकन्‍ना मुन्‍ने ओरा बोरापोर्रेन पवित्र आत्मा वाया हिल्‍ले. ओर्कु सिराप येसु सामिन पोरोलते बापतिस्मा दोर्कुता अचोने. ");
INSERT INTO esg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","18","पजा पत्रु आनि योहान ओरापोर्रो कय इरता इर्रुडे ओर्कु पवित्र आत्मा दोर्कुता. इदुन सिमोन हूळसि, प्रेरितुल्कुनगा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","होंचि, “नना मीकु कोत्‍तां हींतन, गानि नना बोनपोर्रो अय्ते कय इर्रंतनो ओन्क पवित्र आत्मा दोर्कागोट्‍टना ई बलमतुन नाकुगुडा हीम्टु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","अस्‍के पत्रु ओन, “निमे कोत्‍ताने पेनदा वरमतुन अस्सा परांतन इंचि इनकुत्‍तिन. अदुनहाटीं नीवा कोत्‍तां नीतोने नासडेम आंतां. ");
INSERT INTO esg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","पेनदा नदरते नीवा विचारम बेसतद आयो, इंचि ई सेवा कबाह्‍कुने नीकु पोत्‍तु हिल्‍ले, पालु हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","निमे कराब विचाराल्क कियमळ होळसिसि मनसु मार्सकुंचि पेनदुक पारतना कीम. अस्‍के नीवा इसोंटा विचाराल्कुनहाटीं नीकु मापि दोर्का पर्रार. ");
INSERT INTO esg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","नना नीकुन बेस हूळसंतन, नीवा लोप्पो वेल्‍लेन विसम निंडिस निमे पुरागा तप्‍पुड कबाह्कुनतोनि दोहाचि मंतिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","अस्‍के सिमोन, “मिमेट इत्‍तद बद्‍दे पोल्‍ले नापोर्रो वायामन्‍नि इंचि मिमेट सामिंक नाहाटीं पारतना कीम्‍टु,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","पजा पत्रु आनि योहान सामिना बारेमते बतल अय्ते केंजतुर, हूळतुर अदुना गवाइ हीतुर. पजा सामि वेहता पोल्‍लेन वेहचि येरुसलेम मल्सि होनालय पेय्‍स्‍तुर. ओर होननेंके सामरिया नाहकुने वेल्‍लेन जेगाने पेनदा बेसता पोल्‍लें वेहचेके होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","अस्‍के सामिनद उंदि पेनदा दूता पिलिपुसुंक वेहता गदा, “निमे तयार आसि, येरुसलेमताल बद हर्रि अय्ते गाजा सहरताहेके दांता, अदे हर्रि पीसि दक्‍सिनतेके होन्‍नु, आ हर्रि बय्‍लि जेगाताल दांता.” ");
INSERT INTO esg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","पजा ओर तयार आसि होत्‍तोर. होननेंके हर्दे ओन्क इतोपिया देसेमतोर वरोर आडिगुंल्‍ला मनकल कलियतोर. ओर इतोपिया देसेमता रानि कंदाकेनगा कोत्‍ताना लेक्‍का हूळना पेद्‍दा अदिकारिनलेहका कबळ कियुंदुर. दाना पूरा कजाना ओना कय्‍दा हिडे मत्‍ता. ओर आरादनाहाटीं येरुसलेम वासि, मल्सि होननेंके रतमते उदसि यसायाह इनना पेनदा कबुरतोना पुस्तकम हदविसेके मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","अस्‍के पेनदा आत्मा, “निमे आ रतम दग्गेर्क होंचि दानतोनि ताका,” इंचि पिलिपुसुंक वेहता. ");
INSERT INTO esg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","अस्‍के पिलिपुस वितसि होंचि आ रतमतुन अंदकुत्‍तोर. रतमते उदिस मनना मनकल यसायाहल रासता पुस्तकम हदवानदुन हूळसि, “निमे बतल अय्ते हदविसंतिनो अदुना अर्तम नीकु तेळियसेके मंतना?” इंचि ओर आ मनकन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“इदुना अर्तम बतलो, बोरन्‍ना वेहुवद नाकु बल्हा तेळियंता?” इंचि आ मनकल इत्‍तोर. पिलिपुसुन रतम पोर्रो एक्‍किस ओना पक्‍काते उद्‍दालय वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ओर आ पुस्तकमते बतल अय्ते हदविसेके मत्‍तोरो अद इल्‍हा मंता: “हव्कालय ओयना गोर्रेतालेसीं ओन ओतुर, गोर्रे दाना मेंदुल्ता बूरातुन कतरिचिनेंके बल्हा सपुडदाका मनंता, अल्‍हेने ओरगुडा सपुडदाका मत्‍तोर, ओना तोळ्‍दाल उंदि पोल्‍लेगुडा पेय्‍सा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ओना अपमानम कीसि ओनपोर्रो अन्‍यायम कीतुर, बूमिपोर्रोटाल ओना पिस्वरतुन तेंडतुर, ओना वंसमतोर बोरे हिल्‍लुर.” इल्‍हा रासि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","अस्‍के, “असल ई कबुरतोर बोना बारेमते वेहचंतोर? ओना सतता बारेमतेना, हिलाकोंटे मरि इंका बोरन्‍ना वेरेतोना बारेमतेना? दया कीसि नाकु तेळियनाल वेहा,” इंचि आ आडिगुंल्‍लोड पिलिपुसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","अस्‍के पिलिपुस, आ मनकल हदवुसेके मत्‍ता वचनाल्कुनाल मोदोल पीसि, येसुना बेसता कबुरदाका अन्‍नि ओन्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","इल्‍हा हर्रि पीसि होननेंके-होननेंके ओर उंदि एर मत्‍ता जेगातगा एव्‍तुर. अस्‍के एतुन हूळसि, “हूळा! इगे एर मंता. इंदके नाकु बापतिस्मा एतालय बतलन्‍ना तकलिप मंतना?” इंचि आ आडिगुंल्‍ला मनकल इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(निमे गिंटा मनसुनाल पुरागा विस्वासम कियानय्ते बापतिस्मा एता परांतिन, इंचि पिलिपुस वेहतस्के, ओर हां, येसु सामिए पेनदा मर्रि आंदुर इंचि नना विस्वासम कींतन, इंचि जवाब हीतोर.) ");
INSERT INTO esg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","अस्‍के ओर रतमतुन आपालय वेहतोर. पजा पिलिपुस आनि आ आडिगुंल्‍ला मनकल ईर इव्वुर एते रेयतुर. पिलिपुस आ मनकंक बापतिस्मा हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ओर एताल पलाते पेय्‍स्‍तस्‍के पिलिपुसुन सामिना आत्मा बेकेनो ओता. आ आडिगुंल्‍लोड ओन मर्रा बस्‍केने हूळा हिल्‍लोर. अयना आ आडिगुंल्‍ला मनकल आनंदमते ओना हर्रि पीसि ओर होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","इल्‍हा पिलिपुस अजोतु इनना सहरते दिसतोर. पजा ओर होननेंके हर्रि पीसि कलियता नाहकंता पेनदा बेसता कबुर वेहचेके कैसरिया सहरते एवतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","अदे वेलाते साऊल सामिनपोर्रो विस्वासम कियानोर्कुन हव्कंतन इंचि बेदरिचेक मत्‍तोर. ओर पेद्‍दा पेर्मानगा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","होंचि, “दमिस्‍क सहरते मनना दर्मसास्‍त्रम कराहना लोहकुनाल बोरन्‍ना सामि वेहता हर्रि पीसि ताकाना मुरतळ आयि मांडसा आयि दोर्कुते, ओर्कुन दोहाचि येरुसलेमते वापस तायाना अदिकारमता सिट्‍टि रासि हीम,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","इल्‍हा ओर दमिस्‍क एरियाक दग्‍गेर एवतोर. अस्‍के उंदेदम मब्बुनाल ओना सुट्‍टु उंदि वेलगु जग्गरा मेर्सता. ");
INSERT INTO esg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","अल्हा आता आयमळ ओर बूमिपोर्रो अरतोर. पजा ओन्क, “साऊल, साऊल निमे नाकुन बारि तकलिप कीसंतिन?” इंचि इत्‍ताप उंदि अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","अस्‍के, “सामि! निमे बोन आंदिन?” इंचि साऊल पूसकीतोर. अस्‍के, “निमे बोन अय्ते तकलिप कीसंतिनो नना आ येसुन आंदुन. ");
INSERT INTO esg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","निमे इंदके तेदसि सहरतेके होन. बतल कियमळो अद नीकु अगा वेहमळ जर्गंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ओनतोनि होंचेके मत्‍ता मनकालोर्कु अल्किर अय्ते केंजतुर, गानि ओर्क अगा बोरे दिसा हिल्‍लुर. अदुनहाटीं ओर मूकालोरलेसीं वळकाकोंटा अल्हे नित्‍तिसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","अस्‍के साऊल बूमिपोर्रोटाल तेदसि कळ्‍क उस्मिसि हूळते अगा ओन्क बतले दिसा हिल्‍ले. पजा ओनतोनि मत्‍तोर ओना कय पीसि दमिस्‍कते ताकिच्‍चेके ओतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","मूड रोजकुनदाका ओर गुड्‍डोनलेह्का आसि मत्‍तोर. अचोने आयका ओर बतल तिना हिल्‍लोर, उन्‍ना हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिस्‍कते हनन्‍याल इनना पोरोलतोर वरोर सिस्युड मत्‍तोर. सामि ओन्क दर्सनम हीसि, “हनन्या!” इंचि केयतोर. अस्‍के ओर, “हां सामि,” इंचि इत्‍तस्के, ");
INSERT INTO esg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","सामि ओन, “तेदा, तेदिस ‘सवरगा’ इनना हरदुक होन. अगा यहुदाना लोन मंता. ओना लोन तरसुस सहरताल वाता साऊल इनना वरोर मनकल मंतोर. अगा ओना बारेमते पूस कीम. ओर इंदके पारतना कीसेके मंतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","साऊल दर्सनमते, हनन्‍याल इनना मनकल ओनगा वासि ओन्क मर्रा कळ्‍क दिसगोम इंचि ओनपोर्रो कय तासताप हूळतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","अस्‍के हनन्‍याल, “सामि, ई मनकल येरुसलेमते मनना नीवा पवित्र लोकुल्‍कुन बच्‍चोनो तकलिप कीता संगति नना वेल्‍लेन लोकुल्‍कुना तोळ्‍दाल केंजतन. ");
INSERT INTO esg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","इग्‍गेगुडा नीवा पोरोल एताना हरेक विस्वासिन दोहाचि ओयना अदिकारम, पेद्‍दा पेर्मालोर्कुन हेंदाल एतकुंचि वातोर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","अस्‍के सामि ओन, “नावा पोरोलतुन वेरे जातितोरा नड्‍डुम, राजालोरा मुन्‍ने, इस्राएलता लोकुल्‍कुन मुन्‍ने वेहनाहाटीं नना ईन नावा विस्रे इंचि पेर्कुत्‍तन, अदुनहाटीं निमे होन. ");
INSERT INTO esg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","नावा पोरोल एतानाहाटीं ओन्क बच्‍चोर कस्‍टाल्‍क अर्रा पींतानो नना कुद ओन्क हुप्‍संतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","अस्‍के हनन्‍याल अगटाल पेय्सि साऊल बद लोते मत्‍तोरो अद लोन होत्‍तोर. होंचि ओनपोर्रो कय इर्सि, “साऊल दादा, निमे हर्रि पीसि वायानेंके नीकु दिसतोर हूळा! आ येसु सामिए नीकु मर्रा कळकु दिसगोम, निमे पवित्र आत्माते पुरागा निंडिस होनगोम इंचि नाकुन लोहतोर,” इल्‍हा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","अस्‍केने ओना कळ्‍कुनाल बतलो पोर्रानसंटव रालसि, ओर हूळालय दल्‍गुतोर. पजा तेदसि बापतिस्मा एततोर. ");
INSERT INTO esg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","गाटो तित्‍तस्के ओन्क ताकत वाता. इल्‍हा ओर कोन्‍नि रोजकु दमिस्‍कते मत्‍ता सिस्युल्कुनतोनि अग्गेन मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","पजा ओर आल्सेम कियाकोंटा, “येसे पेनदा मर्रि,” इंचेके यहुदि लोकुल्‍कुना दर्मसास्‍त्रम कराहना लोह्कुने होंचि येसुना बारेमते वेहालय सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","अगा ओना पोल्‍लें केंजतोर अंटोर इचंत्रमते अर्सि, “येरुसलेमते येसुन नम्मुतोर्कुन दोर्कापीसि ओर्कुन हव्कुता मनकल ईरे आयोरा? इंका इग्‍गेगुडा येसुन नम्मुतोर्कुन पीसि दोहाचि वाटसि पेद्‍दा पेर्मालोरा मुन्‍ने ओयाना विचारमते वातोर गदा!” इंचि इनालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","गानि साऊलना कराहना तेल्वि मात्रम रोज-रोज बेरसेकेन होत्‍ता. अदुनहाटीं दमिस्‍कते मनना यहुदिल्कुन, येसु सामिए किरिस्‍तु आंदुर, इंचि रुजुव कीसि ओर्कुन वळकाकोंटा कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","इल्‍हा वेल्‍लेने रोजकु आतारित्‍ते यहुदिल्क साऊलुन हव्कना उपायम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","गानि ओन हव्कालय नर्का-पियल सहरता गेटकुनगा यहुदिल्क पोंचादोसि मनना संगति साऊलुंक तेळियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","अस्‍के साऊलना सिस्युल्क नर्कटा वेलाते ओन उंदि तट्‍टाते उपिच्‍चि सहरता सुट्‍टु मत्‍ता गूरे पोर्रोटाल वेलाड वाटसि हिळु रेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","साऊल येरुसलेमते वातंका सिस्युल्कुनतोनि कलियसि मनालय हूळतोर. गानि सिस्युल्क मात्रम ईर निजम सिस्युड आदुंरो आयोरो, इंचि विस्वासम हिलाका वेरियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","बरनाबास मात्रम साऊलुन पीसि प्रेरितुल्कुनहेके वातोर. साऊल वायनेंके हर्दे येसु सामिन बल्हा हूळतोर, येसु सामि ओनतोनि बल्हा वळकुतोर, दमिस्‍कते ओर येसु सामिना पोरोलता बारेमते बल्हा वेरियाकोंटा वेहतोर, इव अन्‍नि पोल्‍लें ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","इल्‍हा साऊल ओरतोनि कलियसि-मेलियसि मनुंदुर आनि वेरियाकोंटा येसु सामिना पोरोलता बारेमते वेहसेके येरुसलेमते तिरियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ओर युनानि बासा वळ्‍काना यहुदिल्कुनतोनि सामिना बारेमते वळ्‍कुंदुर, चर्चा कियुंदुर. गानि ओर मात्रम ओन हव्कालय हूळतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","बस्के अय्ते इद संगति दादालोर्कुंक तेळियतनो अस्‍के ओर ओन मुन्‍ने कैसरिया ओतुर. पजा अगटाल ओना पुटता सहर तरसुसते लोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","इल्‍हा यहुदिया, गालिल, सामरिया एरियाता कलिसियानोर्कुंक कोन्‍नि रोजकु सांति मत्‍ता. आ कलिसियानोर सामिंकु वेरियसि बेस बक्‍तितोनि पिसुंदुर, पवित्र आत्मागुडा ओर्कु बेस प्रोत्‍साहन हियुंदु. अदुनहाटीं ओर बेस ताकतवान आतुर. इल्‍हा ओर वेल्‍लेन आसेक होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पजा पत्रु देसेमंता तिरियसेक-तिरियसेक लुद्‍दा इनना सहरते मनना पेनदा लोकुल्‍कुनगा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","अगा ओर, लकवा बिमार आसि एनमिदि वर्सानाल कटुल पीसि मत्‍ता आनियासु पोरोलता वरोर मनकंक कलियतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","अस्‍के, “आनियासु, येसु किरिस्‍तु नीकुन बेस कींतोर, निमे तेदसि नीवा कटुल्तुन हद्रा,” इंचि पत्रु ओन इत्‍तोर. अस्केटद अस्‍केन आ मनकल तेदतोर. ");
INSERT INTO esg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","अस्‍के लुद्‍दा आनि सारोन सहरकुने मनना वेल्‍ले लोकुल्‍क आनियासुन हूळसि सामिनहेके तिरियतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","यापा सहरते उंदि विस्वासि मुरतळ मनुंदु, दाना पोरोल तबिता. तबिता इत्‍ते युनानि बासाते, दोरकस, इत्‍ते तल्‍लुर दुप्‍पि इंचि अर्तम. अद मुरतळ बस्‍केळ्‍क बेसता कबाह्‍क कीसेके, गरिबोर्कुंक दान-दर्मम कीसेके मनुंदु. ");
INSERT INTO esg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","पत्रु लुद्‍दा सहरते मत्‍ता रोजकुनेन अद बिमार अर्सि हासोत्‍ता. अस्‍के दाना पीनगुंकु एर दोस्‍सि मिद्‍देता पोर्रोटा अर्राते इरतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्‍दा नार यापा सहरकु दग्गेरेन मत्‍ता. अय्ते पत्रु अगा मंतोर इत्‍ता संगति सिस्युल्कुंक तेळियतस्के इव्वुर मनकालोर्कुन ओनगा लोहचि, आलसेम कियाकोंटा ओरहेके वायालय विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","अस्‍के पत्रु बिराना तयार आसि ओरतोनि होत्‍तोर. ओर अगा एव्ता-एव्‍वुडे ओन मिद्‍दे पोर्रोटा अर्राते ओतुर. अगा ओर होत्‍तस्के अगा मत्‍ता मुंडामोस्ता मुर्ताह्क, दोरकस अवुनतोनि मननेंके कुट्‍ता अंगिं आनि कपडिं पत्रुंकु हूपिच्‍चेके ओन सुट्‍टु आसि अळालय दल्‍गतां. ");
INSERT INTO esg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","गानि पत्रु अवुन अंटोर्कुन पलाते लोहचि टोंगरां ऊनसि पारतना कीतोर. पजा पीनगुनहेके तिरियसि, “तबिता, तेदा!” इंचि इत्‍तोर. अस्‍के अद पत्रुन हूळसि तेदिस उदुता. ");
INSERT INTO esg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पजा अद दाना काल्कुनपोर्रो नित्‍तालय कय हीसि सहायम कीतोर. पेनदा लोकुल्‍कुन, मुंडामोस्ता मुर्ताह्‍कुन केय्‍सि जीवाते मत्‍ता तबितान ओर्कु हुपिस्तोर. ");
INSERT INTO esg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ई संगति पूरा यापा सहरअंता तेळियसि, वेल्‍ले लोकुल्‍क सामिन नम्मुकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","आयंका पत्रु यापा सहरतेन सिमोन इनना वरोर तोलकुन कबळ कियानोनगा वेल्‍लेन रोजकु आगतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया सहरते कुरनेलियुस पोरोलतोर वरोर मनकल मनुंदुर. ओर इटलि इनना पोलिस दलमते नूर मिल्ट्री पोलिसुल्कुन पोर्रो दरोगाल मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","कुरनेलियुस बेस नीतिमंतुड मत्‍तोर. ओर, ओना लोतोरगुडा पेनदुक वेरियुंदुर. ओर गरिब लोकुल्‍कुंक वेल्‍ले सहायम कियुंदुर. बस्केळक पेनदुक पारतना कीसेके मनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ओर उंदि रोज पियल मूड एगना पारतना कियनेंके दर्सनमते उंदि पेनदा दूता ओनगा निजम वासि, “कुरनेलियुस!” इंचि ओन केयताप हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","अस्‍के कुरनेलियुस वेर-वेरियसेक पेनदा दूताहेके हूळसि, “नीकु बतल गावाले वेहा,” इंचि इत्‍तोर. अस्‍के पेनदा दूता, “नीवा पारतनां पेन केंजता. गरिबोर्कुंक निमे कियना सहायमतुन पेन हूळता. ");
INSERT INTO esg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","निमे इंदके इच्‍चुर मनकालोर्कुन यापा सहर लोहचि सिमोन पोरोलता मनकन (ईन पत्रुगुडा इंतुर) निहगा केया. ");
INSERT INTO esg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ओर सिमोन इनना वरोर तोलकुन कबळ कियानोना लोते मंचंतोर. ओना लोन समुद्रम ओड्‍डुंक मंता.” इंचि ओन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","इल्‍हा ओनतोनि वळकसेके मत्‍ता पेनदा दूता अगटाल होत्‍ता होनमळे, कुरनेलियुस ओना लोन कबळ कियाना जीतागाह्कुनाल इव्वुर जीतागाह्कुन आनि पेनदुक वेरियानोर अल्‍हेने ओन्क बेस सेवा कियना वरोर पोलिसुन, इल्‍हा मुव्वुर्कुन केयतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","पजा अगा बतल अय्ते जरुगुतनो, अद पूरा वेहचि ओर्कुन यापा सहरकु लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","इंकुंदि रोजु ओर यापा सहर दग्‍गेरा एवतस्‍के पिय्यटा वेलाकु पारतनाहाटीं पत्रु मिद्‍देपोर्रो होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","अस्‍के ओन्क कर्वेस्‍सि मत्‍ताहेंका बतलन्‍ना तिनकन बारे इंचि अनपिस्ता. गाटो वेसेकेन मत्‍ता अच्‍चोटेन ओर उंदि दर्सनम हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","अद दर्सनमते, मब्बु बय्यर आसि, पोर्रोटाल बतलो उंदि वस्तु हिळु वायनद ओर हूळतोर. अद उंदि पेद्‍दा सेदरलेह्का मंता. दाना नालुं मूलां पीसि हिळु रेयताप ओर हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","अव्टे नालुं काल्क मत्‍ता अन्‍नि तीरकुना जिवरासीं, बेंगाना जिवरासीं आनि मब्बुने परियना पिट्‍टें मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","अस्‍के पत्रुंक उंदि अल्किर, “पत्रु, तेदा! अवुन हव्‍किस तिन,” इंचि केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","गानि पत्रु, “मन्‍नि सामि, नावा पिस्वरते नना बस्‍केने मूसान नियम परकारम तिनुमा इत्‍तद, अपवित्रमातद तिंडि तिना हिल्‍लेन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","पजा अद अल्किर, “पेन सुद्‍द कीतद बतले वस्तु आयि, दान निमे असुद्‍द इंचि इनुमा,” इल्‍हा रोंडो मल्का ओन्क केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","इल्‍हा मूड मल्कां जर्गुता. पजा अद सेदरतसोंटा वस्तु बिराने पोर्रोळ्‍क मब्बुनहेके तिरियसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","पत्रु आ हूळता दर्सनमता अर्तम बतल आयावच्‍चु इंचि विचारम कीसेकेन मत्‍तोर, अद हूळा! कुरनेलियुस लोहता मनकालोर सिमोनुना गुयमाकुल्कुनगा वासि, “पत्रु इनानोर इदे लोते मंचंतोरा?” इंचि पूसकीतुर. ");
INSERT INTO esg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पत्रु इंकागुडा अदे दर्सनमता बारेमते विचारम कीसेके मत्‍तोर. अच्‍चोटेन पेनदा आत्मा, “हूळा, मुव्वुर मनकालोर नीकुन पहकसंतुर. ");
INSERT INTO esg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","अय्ते तेदा, हिळु रेय्‍सि मनसुने बतले अनमानम इर्राकोंटा ओरतोनि होन्‍नु. ओर्कुन ननाने लोहतन,” इंचि ओन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","अस्‍के पत्रु हिळु रेय्‍सि ओरगा होंचि, “मिमेट बोन अय्ते पहकसंतिरो ओर ननाने आंदुन. अय्ते मिमेट हीके बारिंक वातिर?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","अस्‍के आ मनकालोर, “माकुन उंदि पोलिस दलमता दरोगाल कुरनेलियुस इनानोर लोहतोर. ओर बेस नीतिमंतुड आनि पेनदुक वेरियसि ताकाना मनकल आंदुर. यहुदि जातिता लोकुल्‍कुने ओर बेस पोरोल होत्‍तोर. नीकुन ओना लोन केया वेहचि, नीहेंदाल ओन्क पोल्‍लें वेहालय उंदि पवित्र पेनदा दूता ओन्क वेहता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","पजा पत्रु ओर्कुन लोप्पो केय्‍सि ओर्कुन हेडमितोरलेसीं हूळकुत्‍तोर. इल्‍हा इंकुंदि रोजु तयार आसि ओरतोनि होत्‍तोर. होननेंके यापा सहरता इच्‍चुर विस्वासुल्कगुडा ओनतोनि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","इंकुंदि रोजु ओर अंटोर कैसरिया सहरते एवतुर. अगा कुरनेलियुस ओना जीवातोर्कुन आनि दग्‍गेटा दंटातोर्कुन केय्‍सि ओना एदुर हूळसेक मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","पत्रु लोप्पो होळियतस्‍के कुरनेलियुस ओना काल्कुनपोर्रो अर्सि ओना काल्क मोळ्‍कतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","गानि पत्रु ओन तेहचेके, “अरेरे! नित्‍ता, ननागुडा नीलेसीं वरोन मनकने आंदुन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","पजा पत्रु कुरनेलियुसुनतोनि वळकसेके-वळकसेके लोप्पो होत्‍तोर. अस्‍के अगा ओर वेल्‍लेने मंदि जमा आसि मत्‍तद हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","हूळसि, “मीकु उंदि पोल्‍ले अय्ते एरपाटे, अद बतल इत्‍ते, यहुदि मनकल वेरे जातिता मनकनगा होनमळ, ओनतोनि बेसता संबंदम इरमळ यहुदि रीति-रिवाजकुने बेस आयो. गानि पेन मात्रम, नना बोने मनकन पास्कामन्‍नि, बोने अपवित्र इना मन्‍नि इंचि नाकु हुपिस्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","अदुनहाटीं नाकुन मिमेट केयतस्‍के नना बतले विचारम कियाकोंटा मीतोनि पेय्सि वातन. अय्ते मिमेट नाकुन बारि केयतिर नाकु वेहाट,” इंचि पत्रु ओर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ओर अल्हा पूसकीताहाटीं कुरनेलियुस, “मूड रोजकु मुन्‍ने इदे वेलाकु पियल मूड एगानेंके नना नावा लोनु पारतना कीसेके मत्‍तन, अस्‍के उंदेदम तलातला मेर्सना कपडिने वरोर मनकल नावा मुन्‍ने वासि निततोर. ");
INSERT INTO esg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","नित्‍तिसि, ‘कुरनेलियुस, नीवा पारतना पेन केंजता, गरिबोर्कुंक निमे कियना सहायमतुन पेन हूळता. ");
INSERT INTO esg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","अदुनहाटीं यापाते बोनना लोहचि पत्रुन केया लोहा. ओर समुद्रम ओड्‍डुनगा सिमोन इनना तोलकुन कबळ कियानोन लोन आगसि मंतोर,’ इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","अदुनहाटीं नना बिराना नीकुन केया लोहतन, निमे इगे वासि बच्‍चोरो बेस आता. इंदके नीकु पेन बतल वेहतनो अव अन्‍नि केंजालय मोमोट अंटोरम इगे पेनदा मुन्‍ने जमा आतोम,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","अस्‍के पत्रु वळ्‍कमळ सुरुव कीतोर. ओर इत्‍तोर, “पेन हरेक मनकन उंदेतीर हूळंता इंचि इंदके नाकु निजम तेळियता. ");
INSERT INTO esg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","दुनियाता अन्‍नि देसेल्‍कुना लोकुल्‍क ओर बोरन्‍ना आयिर, ओर पेनदुक वेरियसि नीति कबाह्‍क कियानय्ते पेन ओनपोर्रो कूस मनंता. ");
INSERT INTO esg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","येसु किरिस्‍तु अंटोरा सामि आंदुर. ओनहेंदाल पेन दाना सांतिता बेसता कबुर इस्राएलता लोकुल्‍कुंक हीता, अद कबुर इदे आंदु. ");
INSERT INTO esg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","बापतिस्माता बारेमते योहान वेहमळ सुरुव कीता पजा, गालिलते उंदि गटना सुरुव आता. इद गटनाता बारेमते पूरा यहुदिया एरियंता पैलांचता संगति मीकु एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","नासरेत नाटेना येसुन पेन पवित्र आत्मातोनि अबिसेकम कीसि अद्‍बूतामाता ताकत हीता. पेन ओनतोनि मत्‍ताहेंका, ओर अंटोराहाटीं बेसता कबाह्‍क कियुंदुर, देय्याल्कुना मुक्‍याना कय्‍दा हिळु मत्‍तोर्कुन बेस कीसेके तिरियुंदुर, इद मीकु एरके. ");
INSERT INTO esg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","येरुसलेम, यहुदिया देसेमते ओर कीता अन्‍नि कबाह्‍कुन मोमोट प्रेरितुल्कुम, कळ्‍कुने हूळतोम. इंका ओर ओन क्रुसुनपोर्रो वेलाड वाटसि हव्कतुर. ");
INSERT INTO esg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","गानि पेन मात्रम ओन मूड रोजकुने मर्रा जीवाते तेहाचि दिस्‍सानाल कीता. ");
INSERT INTO esg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","अंटोर लोकुल्‍क ओन हूळा हिल्‍लुर. गानि पेन माकुन मुन्‍नेन गवाइदार्क इंचि पेर्कुत्‍ता. अदुनहाटीं मोमोटे ओन हूळतोम. ओर हासि तेदतारित्‍ते मोमोट ओनतोनि कलियसि तित्‍तोम, उट्‍टोम. ");
INSERT INTO esg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","जीवाते मत्‍तोर्कुंक, हासोत्‍तोर्कुंक न्‍यायम कियानोर इंचि पेन ईने पेर्कुत्‍ता. इदुना बारेमते लोकुल्‍कुंक बेसता पोल्‍लें कराहना, गवाइ वेहना इंचि ओरे माकु आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","येसुनपोर्रो विस्वासम इर्रना हरेक मनकंक येसुना पोरोलते पापाल्क मापि आंतां, इंचि अंटोर पेनदा कबुरतोर्क गवाइ हीसि मत्‍तुर.” ");
INSERT INTO esg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रुना वळ्‍कमळ सुरुव मनेंकेने पेनदा बेसता पोल्‍लें केंजसेक मत्‍तुरा अंटोरपोर्रो पवित्र आत्मा रेयता. ");
INSERT INTO esg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","पवित्र आत्माता वरम वेरे जातितोर पोर्रोगुडा वळियतदुन हूळसि पत्रुनतोनि वाता कतना आता विस्वासुल्कुंक इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","ओर अंटोर्कुन ओर्कु तेळियवा बासाने पेनदा स्‍तुति कीतद केंजतुर. अस्‍के, “मनाकु दोर्कताप ईर्कगुडा पवित्र आत्मा दोर्कुता. ईर एते बापतिस्मा एता मन्‍नि इंचि बोरन्‍ना अड्‍डम वळकानोर मंतुरा?” इंचि पत्रु इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","इल्‍हा पत्रु, येसु किरिस्‍तुना पोरोलते ओर्कु बापतिस्मा हियालय आदेस हीतोर. इदंता आता पजा कोन्‍नि रोजकु पत्रु ओरतोनि मननाहाटीं अंटोर कलियसि पत्रुंक विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","वेरे जातितोरगुडा पेनदा पोल्‍लेतुन ओप्‍कुत्‍तुर इत्‍ता संगति, प्रेरितुल्क आनि यहुदिया एरियाते मत्‍ता दादालोर केंजतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","गानि बस्के अय्ते पत्रु येरुसलेमते वातोर अस्‍के, इच्‍चुरकतना आता विस्वासुल्‍क, “निमे वेरे जातितोरा लोहकुने होंचि ओरतोनि गाटो बारि तित्‍तिन.” इंचि ओनतोनि जगडम दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","अस्‍के पत्रु बतल अय्ते जरुगुतनो अद बल्हा मत्‍तद अल्हे ओर्कु ई परकारम तेळियागोट्‍सि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“नना यापा सहरते पारतना कीसेक मननेंके उंदि दर्सनम हूळतन. अद दर्सनमते, पेद्‍दा सेदरतसोंटा उंदि वस्तुन नालुं मूलां पीसि मब्बुनाल हिळु रेहानद हूळतन. अद हिळु रेय्‍सि नना मत्‍तागेन वाता. ");
INSERT INTO esg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","नना दान लोप्पो बेस हूळतस्‍के नाकु अव्टे बूमिपोर्रो मनना नालुं काल्कुना जिवरासीं, केडा जिवरासीं, बेंगना जिवरासीं आनि मब्बुने परियाना पिट्‍टें दिसतां. ");
INSERT INTO esg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अस्‍के नाकु, पत्रु तेदा, अवुन हव्‍किसि तिन, इंचि वेहताप उंदि अल्किर केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","अस्‍के, मन्‍नि सामि, मूसान नियम परकारम तिनुमा इत्‍तद, अपवित्रमातद नना बस्‍केने तिना हिल्‍लेन, इंचि इत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","अदे अल्किर मब्बुनाल रोंडो मल्का, पेन सुद्‍द कीतद बतले वस्तु आयि, निमे दान असुद्‍द इंचि इनुमा, इंचि केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","इल्‍हा मूड मल्कां आता. पजा अदुन मर्रा पोर्रोळ्‍क तेहाकुंचि मब्बुनहेके ओयमळ जर्गुता.” ");
INSERT INTO esg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","अस्‍केने नाकुन केय्‍सि ओयालय कैसरियाताल वाता मुव्वुर मनकालोर नना मत्‍ता लोतागा वासि निल्तुर. ");
INSERT INTO esg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","बतले अनमानम कियाकोंटा ओरतोनि पेय्सि होन. इंचि पेनदा आत्मा नाकु वेहता. ईर हारुर विस्वासि दादालोरगुडा नावातोनि वातुर. मोमोट अंटोरम माकुन केया वेहता मनकना लोते होळियतोम. ");
INSERT INTO esg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","आ मनकल माकु वेहतद बतल इत्‍ते, ओर उंदि पेनदा दूतातुन ओना लोते नित्‍तिसि वळ्‍कतदुन हूळतोर. आ पेनदा दूता, यापाते मनकालोर्कुन लोहचि पत्रु इनना सिमोनुन केयकुन. ");
INSERT INTO esg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ओर नीकु, नीवा लोतोर्कगुडा मुक्‍ति बल्हा दोर्कंता, अदुन बारेमते वेहांतोर इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","नना वळ्‍कमळ सुरुव कीतारित्‍ते पवित्र आत्मा मुन्‍ने मनापोर्रो बल्हा रेय्तनो अल्हेन ओरापोर्रो इंका रेय्ता. ");
INSERT INTO esg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","अस्‍के, योहान एततोनि बापतिस्मा हीतोर, गानि मीकु पवित्र आत्माते बापतिस्मा हियमळ जर्गंता. इंचि सामि इत्‍ता आ पोल्‍ले नाकु मति वाता. ");
INSERT INTO esg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","येसु किरिस्‍तुन मनम सामि इंचि विस्वासम कीतस्‍के मनाकु हीता वरमे ओर्कु इंका हीता. अय्ते पेनदुक अड्‍डम तिरियानोन नना बोन आंदुन? ");
INSERT INTO esg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ई पोल्‍लें केंजसि ओर अंटोर सपुडदाका आतुर. पेन वेरे जातितोर्कगुडा पिस्वर दोर्किच्‍कुननाहाटीं मनसु मार्सकुनना वरम हीता, इंचि पेनदा स्‍तुति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्‍टिपन हासोत्‍ता पज्जो वेल्‍लेन कस्‍टाल्‍क वातां, अदुनहाटीं लोकुल्‍क सिल्‍लर आसि हिके-हेके पायसि होत्‍तुर. आ लोकुल्‍क पिनिके, साइप्रस, अंताकिया इनना सहरकुने होंचि अगा सिराप यहुदिल्कुंके पेनदा बेसता पोल्‍ले वेहचेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ई विस्वासुल्कुनाले इच्‍चुर विस्वासुल्‍क साइप्रस आनि कुरेनि इनना सहरतोर मत्‍तुर. ओर अंताकियाक होंचि येसु सामिना बेसता कबुर युनानि लोकुल्‍कुंकगुडा वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","सामिना ताकत ओरतोनि मत्‍ता इंचि वेल्‍लेटुर लोकुल्‍क विस्वास कीसि सामिनहेके तिरियतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","बस्के अय्ते ई कबुर येरुसलेमता कलिसियातोर्क तेळियता, अस्‍के ओर बरनाबासुन अंताकियाक लोहतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ओर अगा होंचि अगाटा लोकुल्‍कुनपोर्रो पेनदा कुर्पा हूळसि इरगा कूस आतोर, सामिनतोनि बस्‍केळ्‍ताहाटीं पूरा मनसुनाल बेस विस्वासमते नित्‍तिसि मनना, इंचि ओर्क अंटोर्क दैरनेम हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ओर बेस मनकल मत्‍तोर, अचोने आयका विस्वासम आनि पवित्र आत्माते निंडिस मत्‍तोर. इल्‍हा वेल्‍लेन मंदि सामिन नम्मिसि विस्वासुल्‍क आतुर. ");
INSERT INTO esg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","पजा बरनाबास साऊलुन पहकालय तरसुस इनना सहर होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","अगा ओन दोर्किच्‍कुंचि अंताकियाक पीसि वातोर. अगा ओर इव्वुर अगाटा कलिसियातोर्क कलियसेके, वेल्‍लेन लोकुल्‍कुंक कराहसेके मत्‍तुर. इल्‍हा ओर इव्वुर उंदि एडादिमेड अंताकियातेन मत्‍तुर. अय्ते मोट्‍टा मोदाला सिस्युल्कुन “किरिस्‍तुनोर” इंचि इन्‍मळ ई अंताकियातेन जर्गुता. ");
INSERT INTO esg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","अवे तूकुल्कुने इच्‍चुर पेनदा कबुरतोर येरुसलेमताल अंताकियाक वातुर. ");
INSERT INTO esg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ओरव्टे वरोर अगबुस पोरोलतोर मत्‍तोर. ओर पवित्र आत्माते निंडिस, पूरा दुनियाते उंदि पेद्‍दा कर्वु अर्रानद मंता, इंचि वेहतोर. इदु कर्वु कलादियुस इनना राजाना कालमते अर्सि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","अस्‍के अंताकियाते मत्‍ता अंटोर सिस्युल्क ओरा-ओरा एलवान परकारम यहुदियाते मनना विस्वासुल्कुंक सहायमहाटीं बतलन्‍ना लोहना इंचि निरनायम एततुर. ");
INSERT INTO esg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ओरा निरनायमनुसार सहायमहाटीं जमा कीता सोम्मुन ओर बरनाबास आनि साऊलना कय्‍दे यहुदियाते मनना पेद्‍दाल्कुनहेके लोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","अवे रोजकुने हेरोद अग्रिपा राजाल कलिसियानाल इच्‍चुर मंदितुन तकलिप कियालय सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ओर योहानुना दादल याकोबुना तल्‍लातुन कसेटे कोय्‍सि हव्का वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ओर कियना कबाह्‍क यहुदि लोकुल्‍कुंक बेस अनपिस्ता इन्कुंचि हेरोद राजाल पत्रुन इंका दोर्का पीतोर. (इद गटना होयवा पिंडिता हारिना पंडुगुना रोजु जर्गुता.) ");
INSERT INTO esg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","दोर्कापीसि जेलने वाटतोर. पजा तेपाक नालुर सिपाइल्क ओनगा कावेल कियना इंचि, पदाहारुर सिपाइल्कुना कय्‍दे ओन अप्पजेपतोर. दाटसि होनना पंडुगु आतारित्‍ते पत्रुना न्‍यायम कियालय लोकुल्‍कुना मुन्‍ने तायाना विचारम हेरोद राजाना मनसुने मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","इल्‍हा पत्रुन ओर जेलने वाटसि इरतोर. गानि ओनाहाटीं कलिसियातोर मात्रम आगाकोंटा उंदेतीर पेनदुक पारतना कीसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","हेरोद राजाल पत्रुन पलाते पीसि वायना उंदि रोज मुन्‍ने, नर्काटा वेलाक पत्रु इव्वुर सिपाइल्कुना नड्‍डुम निद्रा होंचेके मत्‍तोर. सिपाइल्क ओन रोंडु गोल्सुकुने बेडीं वाटसि इरतुर. पलाते तल्‍पुनगा कावेल कियानोर जेलता कावेल कीसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","अचानक सामिनद उंदि पेनदा दूता अगा दिसता. आ अर्रंता पूरा वेल्‍गुनतोनि निंडिस होत्‍ता. आ पेनदा दूता पत्रुन मेलाहचि, बिराना तेदा! इंचि ओन तेहाता. ओना कय्‍कुना बेडीं लेंगसि हिळु अरतां. ");
INSERT INTO esg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","अस्‍के, बिराना तयार आसि हेरपुह्क केर्रा, इंचि पेनदा दूता ओन्क वेहता. अस्‍के अद वेहतापे ओर कीतोर. पजा पेनदा दूता, नीवा सेदर मुचकुंचि नावा पज्जो वा, इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ओर पेनदा दूताता पज्जो-पज्जो होंचि जेलनाल पलाते अय्ते पेय्सतोर, गानि पेनदा दूता बतल अय्ते कीसंतनो अद अंता निजमे जर्गुसंता इंचि ओर इनकुना हिल्‍लोर. ओर उंदि दर्सनम हूळसंतन बारे इत्‍ताप अनपिस्ता. ");
INSERT INTO esg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","पजा ओर मोदाटोन आनि ओना पज्‍जोटा कावेल कियानोन दाटसि सहरकु होनना कच्‍चि तल्‍पुनगाह्कु वातुर. अस्‍के आ तल्‍पु ओराहाटीं दानद अदे पेय्‍स्‍ता. अस्‍के ओर दान दाटसि पलाते पेय्सि होत्‍तुर. इच्‍चोन लक्‍कु होतंका अचानक आ पेनदा दूता ओन होळसि होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","पजा पत्रुंक तेल्वि अरता. अस्‍के निजमे! सामिए ओना उंदि पेनदा दूतातुन लोहचि नाकुन हेरोद राजाना कय्‍दाल तप्‍पिस्तोर. यहुदि पेद्‍दाल्क नाकुन बतल-बल्हा कियाना इंचि विचारम कीसेक मत्‍तुरो, अव अन्‍निटावुनालगुडा सामिए नाकुन पिसागोटतोर, इंचि इन्कुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","इदंता तेळियता पजा ओर मरियम इनना मुरतटा लोन होत्‍तोर. ई मरियम योहान (ईन मरकुसगुडा इंतुर) इनानोना यावल आंद. अगा वेल्‍लेन मंदि उंदगा जमा आसि पारतना कीसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पत्रु पलाताल तल्‍पुन तंतस्के तल्‍पु तेंडालय रुदा इनना उंदि दासि पेगिड वाता. ");
INSERT INTO esg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पत्रुना लेंग एरपाट कीसि अद वेल्‍ले आनंदमते तल्‍पु तेंडाकोंटेन मल्सि लोप्पो वित्‍सि, “पत्रु तल्‍पुनगा नित्‍तिसि मंतोर,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","अस्‍के, नीकु पिसा पीताना? इंचि अगा मत्‍तोर इत्‍तुर. अद वेहनद निजमे इंचि बच्‍चोनो वेहता. अस्‍के ओर, अद ओना पेनदा दूता आयावच्‍चु, इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","अयना पत्रु तल्‍पुन अल्हेन तंचेके मत्‍तोर. पजा तल्‍पु तेंडतस्के पत्रुन हूळसि ओर्कु इचंत्रम आता. ");
INSERT INTO esg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","अस्‍के पत्रु ओर्कुन सपुडदाका मंटु इंचि कय्‍दे सय्गे कीसि वेहतोर. सामि ओन जेलनाल बल्हा पलाते तत्‍तोर, इद ओर्कु पूरा समजांचि वेहतोर. पजा, ई संगति याकोबुंक (येसुना तम्मुर) आनि कळमता विस्वासुल्कुंक वेहाट, इंचि वेहचि अगटाल ओर इंकुंदि वेरे जेगाते पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","पंग आतास्के, पत्रु बेके होत्‍तोर, बतल आता? इंचि सिपाइल्क पेद्‍दा गाबर आतुर. ");
INSERT INTO esg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","हेरोद राजाल ओन पहकतोर. गानि पत्रु ओन्क बग्‍गेन दोर्का हिल्‍लोर. अस्‍के ओर कावेल इरता सिपाइल्कुन पूस कीसि ओर्कुन हव्कना आदेस हीतोर. हेरोद राजाल यहुदियाताल कैसरियाते वासि मनालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोद राजाल सूर आनि सैदा सहरकुना लोकुल्‍कुनपोर्रो वेल्‍ले होंग आसि मत्‍तोर. ओर अंटोर उंदि आसि ओनतोनि वळकालय होत्‍तुर. राजाना वरोर बेस दग्‍गेटा सेवक बलासतुस इनानोन मुन्‍ने अरहचि, माकु सांति गावाले, इंचि ओन्क विनंति कीतुर. बारित्‍ते ईरा देसेमतोर्कु तिनालय तिंडि राजाना देसेमताले दोर्कुंदु. ");
INSERT INTO esg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","निरनायम कीता रोजु हेरोद राजाल, राजाल केर्राना कपडिं केरसि ओना राजगद्‍देपोर्रो उदसि लोकुल्‍कुंक बासन हियालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","अस्‍के लोकुल्‍क, “इद अय्ते पेनदा लेंग आंदु, मनकानद आयो,” इंचि वरगेयालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","अस्‍के राजाल पेनदा कदर कियाकोंटा पोंगसोत्‍तोर. अदुनहाटीं अस्केटद अस्‍केने सामिनद उंदि पेनदा दूता ओन बिमार अरहता आनि ओर पुळकु अरसि हासि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","गानि पेनदा पोल्‍ले मात्रम पैलांचेके होत्‍ता. अव पोल्‍लें केंजसि वेल्‍लेन लोकुल्‍क विस्वासमते वातुर. ");
INSERT INTO esg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","बरनाबास आनि साऊल ओरा सेवा कबळ पूरा कीसि येरुसलेमताल वापस अंताकिया होत्‍तुर. होननेंके मरकुस इनना योहानुनगुडा पज्जो पीकुंचि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अंताकिया सहरता कलिसियातोरव्टे इच्‍चुर पेनदा कबुरतोर आनि कराहनोर मत्‍तुर. ओर बोर इत्‍ते, बरनाबास, सिमोन ईन निगर (इत्‍ते कर्रेटोर) गुडा इनुंदुर, कुरेनि सहरता लुकियुस, साऊल, गालिल एरियाता राजाल हेरोद अंतिपासुनतोनि बेर्सता मनाहेम ईर आंदुर. ");
INSERT INTO esg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","उंदि रोज ओर ओक्‍कापोद्‍दु मंचि सामिंक आरादना कीसेके मननेंके पवित्र आत्मा ओर्कुन, “नना बद कबळताहाटीं बरनाबासुन आनि साऊलुन पेरकुत्‍तनो, अदुन कियानाहाटीं ओर्कुन अलग कीम्‍टु,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","अस्‍के ओर ओक्‍कापोद्‍दु मंचि पारतना कीसि ओरापोर्रो कय इरसि ओर्कुन लोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","पवित्र आत्माहेंदाल ओर्कुन लोहतारित्‍ते ओर सिलुकिया सहरते होत्‍तुर, अगटाल उंदि डोंगाते उद्‍दिस साइप्रस दीबेहेके पेय्‍स्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","पजा अदे दीबेते मनना सलमीस इनना सहरते एवतारित्‍ते, यहुदिल्कुना दर्मसास्‍त्रम कराहना लोहकुने होंचि पेनदा पोल्‍लें वेहालय दल्‍गतुर. योहान (ईन मरकुसगुडा इनुंदुर) ओर्कु सहायम कियालय ओरतोनि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","पजा ओर पूरा दीबेतुन तिरियसेक पापूस इनना नाटे एवतुर. अगा ओर्कु वरोर यहुदि जातिता मंत्रगाड आनि पेनदा आबद्‍दम कबुरतोर कलियतोर. ओन पोरोल बार-येसु. ");
INSERT INTO esg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","अगा वरोर सिरगु पौलुस इनना तेल्‍विता अदिकारि मत्‍तोर, ओनतोने बार-येसु मत्‍तोर. आ अदिकारि पेनदा पोल्‍लें केंजंतन इंचि बरनाबासुन आनि साऊलुन ओनगा केयतोर. ");
INSERT INTO esg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","गानि एलिमल इनना मंत्राल्कुनोर (युनानि बासाते बार-येसुना पोरोल एलिमल मत्‍ता), बरनाबास आनि साऊलुंक अड्‍डम आसि आ अदिकारि विस्वासम कियामन्‍नि इंचि आपालय हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","अस्‍के साऊल (ईन पौलुस इंका इनुंदुर) पवित्र आत्माते निंडिसि, एलिमलनाहेके उंदेतीर हूळसेक, ");
INSERT INTO esg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“अरे! दोका हियानोना, अन्‍नि तीरकुना नडेह कियाना बुद्‍दिं निंडिस मत्‍ता देय्यमता मर्रिना! अन्‍नि नीति पोल्‍लेंक अड्‍डम तिरियना पगातोन आंदिन. सामिना निजम पोल्‍लेतुन बदवेरदाका आबद्‍दम वळ्कसेक मनांतिन? ");
INSERT INTO esg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","इंदके हूळा! सामि नीवा पोर्रो कय तेहातोर, निमे गुड्‍डिन आंतिन. कोन्‍नि रोजकुनदाका पोळ्‍दुनगुडा हूळाकोंटा आंतिन,” इंचि इत्‍तोर. इत्‍तस्केने एलिमलना कळकु मागुर-मागुर आतां. हिर्र हीकट आसि दिसाकोंटा आतां, अस्‍के, नाकुन बोरन्‍ना कय पीसि ओयगोम, इंचि ओर हीके-हेके पहकालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","एलिमलुंक अल्हा आतदुन हूळसि, सामिना बारेमते वेहता पोल्‍लें केंजसि इचंत्रम आसि, आ अदिकारि सामिन विस्वासम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","आयंका पौलुस ओना दंटातोरतोनि पापूस सहरताल डोंगाते उदसि, पंपुलिया एरियाते मनना पिरगा सहरते होत्‍तुर. अगा होत्‍तारित्‍ते योहान ओर्कुन होळसिसि येरुसलेम मल्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","हेके पौलुस आनि बरनाबास पिरगा सहरताल तिरियसेके पिसिदिया एरियाते मनना अंताकिया सहरते एवतुर. नोमकेम रोजुने यहुदिल्कुना दर्मसास्‍त्रम कराहना लोते होंचि उदतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","अगा मूसाना नियम आनि पेनदा कबुरतोर रासतव पुस्तकाल्कुन हदुवतुर. हदवुतस्‍के दर्मसास्‍त्रम कराहना लोता अदिकारिल्‍क पौलुसुन आनि बरनाबासुन, “दादालोरिटा! लोकुल्‍कुंक कराहनाहाटीं मिहगा बदाना प्रोत्‍साहन कियाना पोल्‍ले मत्‍ते करहट,” इंचि पूसकियालय लोहतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","अस्‍के पौलुस नित्‍तिसि, लोकुल्‍कुन सपुडदाका कियालय कय तेहाचि वळ्कालय दल्‍गुतोर, इस्राएलता लोकुरिटा आनि पेनदुक वेरियना वेरे जातितोरिटा, केंजट. ");
INSERT INTO esg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ई इस्राएल लोकुल्‍कुना पेन, मना एनकटा पेद्‍दाल्कुन पेर्कुत्‍ता. ओर इजिप्‍त देसेमतोरा कय्‍दा हिळु बस्के अय्ते मत्‍तुरो, अस्‍के ओर्कुन पेद्‍दा कीसि, दाना पेद्‍दा बलमतोने आ देसेमताल पलाते तत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","मना पेद्‍दाल्क पेनदा पोल्‍लें केंजाकोंदुर, अय्नागानि दग्‍गेर-दग्‍गेरा नल्‍पै वर्सनदाका पेन ओर्कुन बय्‍लि जेगाते ओर्सकुत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","कनान देसेमता एडुं जातिन नासडेम कीसि, अद बूमि इस्राएल लोकुल्‍कुंक, इद मीवा बूमि, इंचि हीता. इव अन्‍नि आयालय नालुं नुह्कुना एबै वर्सां दल्‍गतां. पजा सामवेल पोरोलता पेनदा कबुरतोर वायानादाका पेन ओर्कु बच्‍चुरो न्‍यायम कियानोर्कुन हीता. ");
INSERT INTO esg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","आयंका वरोर राजाल गावाले इत्‍ताहाटीं, पेन ओर्कु बेंजामिनना वंसमतोर कीस इननोना मर्रि साऊलुन हीता, ओर नल्‍पै वर्सां राज्येम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","मर्रा साऊलुनगटाल राज्येम तेंडसि दाविदुंक हीता. दाविदुना बारेमते पेन इल्‍हा गवाइ वेहता, “यिस्‍सल पोरोलतोना मर्रि दाविद, नना इनकुत्‍ताप नाकु दोर्कतोर, नना वेहतव अन्‍नि ओर पूरा कींतोर,” इंचि वेहता. ");
INSERT INTO esg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“पेन हीता पोल्‍ले परकारम ईना वंसमताले इस्राएल लोकुल्‍कुंक मुक्‍ति हियानोर इंचि येसुन, पेन लोहता. ");
INSERT INTO esg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","येसु वायाका मुन्‍ने, बापतिस्मा हियना योहान इस्राएलता अंटोर लोकुल्‍कुन, मनसु मार्सकुंचि बापतिस्मा एतट,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","योहान ओना कबाटुन पूरा महना वेलाते, “नना बोन इंचि मिमेट इनकुंचंतिर? मिमेट बोनय्ते एदुर हूळसंतिर, ओन नना आयोन. ओर नावा पज्जो वायानुर, नना ओना काल्कुना हेर्पुह्‍क तेंडना लायक इंका हिल्‍लेन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","मावा दादालोरिटा, अब्राहामुना वंसमतोरिटा आनि पेनदुक वेरियना वेरे जातितोरिटा! मुक्‍ति हियना बेसता कबुरतुन पेन मनागा लोहचीता. ");
INSERT INTO esg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","येरुसलेमते मनानुर आनि ओरा अदिकारिल्‍क येसुन एरपाट किया हिल्‍लुर. वारा-वारम नोमकेम रोजुने पेनदा कबुरतोरा पोल्‍लें हदवुंदुर, गानि अदुन एरपाट कियवा, येसुन हव्‍किसि आ पेनदा कबुरतोरा पोल्‍लेन पूरा कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","हामुर सिक्‍सा हियनलायक बतले तप्पु येसुनलोप्‍पो दोर्काकोन्‍नागानि ओन हव्कगोम इंचि पिलातुस राज्यपालुंक विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","येसुन बतल-बतल कियानुर इंचि रासि मत्‍तानो, अव अन्‍नि पूरा आतस्के ओन क्रुसुनपोर्रोटाल हिळु रेहचि बोंदा दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","गानि पेन ओन हामुरताल मर्रा तेहता. ");
INSERT INTO esg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","तेहतारित्‍ते, गालिल एरियाताल येरुसलेमदाका ओनतोनि होत्‍तोर्कुंक वेल्‍लेने रोजकुनदाका ओर दिस्सेक मत्‍तोर. इंदके लोकुल्‍कुना मुन्‍ने येसुना गवाइ इंचि ओरे मंतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","पेन मना पेद्‍दाल्कुंक मुन्‍नेने पोल्‍ले हीसि मत्‍ता. अदे पोल्‍लेता कबुरतुन मोमोट मीक वेहासेक मंतोम. ");
INSERT INTO esg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","इल्‍हा पेन येसुन हामुरताल मर्रा तेहाचि, मना पेद्‍दाल्कुंक मुन्‍नेने हीता पोल्‍ले, इंदके मनाहाटीं निजम आता. इदु, बजन संहितता रोंडो बजनते इल्‍हा रासि मंता: “निमे नावा मर्रिन आंदिन, इय्यला नना नीकु बाबोन आतन.” ");
INSERT INTO esg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","पेन ओन हातोरा लोप्पोटाल तेहता, ओर मर्रा बस्‍केने कळियसि होन्‍नोर. “नना दाविदुंक तप्‍पाकोंटा हींतन इत्‍ता पवित्रमाता आसिर्वाद नीकु हींतन,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","अल्‍हेने इंकुंदि बजनते, “नीवा पवित्र मनकन कळियसि होना हिय्‍यिन.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“दाविद पेनदा इच्‍चा मत्‍तापे ओन्क हीता सेवा-कबाटुन ओना कालमते महाचि हातोर. हातस्के ओना पेद्‍दाल्कुन बगा बोंदा दोस्तुरो, अग्गेन ओन इंका बोंदा दोस्तुर ओर कळियसिगुडा होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","गानि पेन तेहातोर मात्रम कळियसि होना हिल्‍लोर.” ");
INSERT INTO esg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","अदुनहाटीं मावा दादालोरिटा! मिमेट दीन तेळियागोटकुंटु. येसुनाहेंदाले मीवा पापाल्कुन पेन मापि कींता इंचि मोमोट वेहासेक मंतोम. ");
INSERT INTO esg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","मूसाना नियम हेंदाल मीकु पापाल्कुनाल मापि दोर्को, गानि येसुना पोर्रो विस्वास इर्रानुर अंटोर्क ओरा पापाल्कुनाल मापि दोर्कंता. ");
INSERT INTO esg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","अदुनहाटीं पेनदा कबुरतोर रासता पोल्‍लें मीपोर्रो वायाकोंटा उसारते मंटु, इंचि पेन इल्‍हा इत्‍ता: ");
INSERT INTO esg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“नावा पोल्‍लेतुन पास्कानोरिटा हुळाट, इचंत्रम आसि, हासि दांतिट. बारित्‍ते, मीवा रोजकुने नना इसोंटा कबळ कींतन गदा, अदुना बारेमते बोर वेहिनागानि मिमेट विस्वासम किय्‍यिर,” इंचि पेन वेहता. ");
INSERT INTO esg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","पौलुस, बरनाबास दर्मसास्‍त्रम कराहना लोताल पलाते पेय्सतस्के, “इव पोल्‍लें वायाना नोमकेम रोजुने इंका एक्‍को माकु वेहाटु,” इंचि लोकुल्‍क ओरतोनि विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","वेल्‍लेटुर यहुदिल्कु अल्‍हेने यहुदि जातिते वाता वेरे जातितोर, पौलुस, बरनाबासुना पज्जो होत्‍तुर. ओर, लोकुल्‍कुनतोनि वळकसेके, “बस्‍केळ्‍क पेनदा कुर्पाते मंटु,” इंचि ओर्कु वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","इंकुंदि नोमकेम रोजुने सामिना पोल्‍लें केंजालय, पूरा नाटेनोर इत्‍ताप जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","अच्‍चो वेल्‍ले मंदितुन हूळसि यहुदिल्कुना जीवा मसुल्ता, अदुनहाटीं ओर पौलुसना पोल्‍लेंक विरोद कीसि ओन बदनाम कियालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","गानि पौलुस आनि बरनाबास वेरियाकोंटा, मीकु पेनदा पोल्‍ले मुन्‍नेने वेहना अव्‍सरम मत्‍ता, गानि मिमेट दान हय्सका, बस्‍केळ्‍क पिस्सना पिस्वरकु लक्‍कु आताप हुपिस्‍तिर. अदुनहाटीं इंदके मोमोट यहुदि आयवोरहेके दांतोम. ");
INSERT INTO esg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","बारित्‍ते पेन माकु इल्‍हा आदेस हीता: “सामि लोकुल्‍कुन बल्हा पिसागोटंतोर इदु पोल्‍ले निमे दुनियंता वेहगोम इंचि, नना नीकुन वेरे जातितोरहाटीं वेडसि हुप्‍सानोन कीतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ई पोल्‍ले केंजसि वेरे जातितोर वेल्‍ले कूस आसि, सामिना पोल्‍लेता कदर कियालय दल्‍गुतुर. बचटूर्कुन अय्ते बस्‍केळ्‍क पिस्सना पिस्वरताहाटीं पेन पेरकुत्‍तनो, अचटुर येसुनपोर्रो विस्वासम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","इल्‍हा सामिना पोल्‍लें पूरा एरियाता लोकुल्‍कुंक तेळियता. ");
INSERT INTO esg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","गानि यहुदि लोकुल्‍क मात्रम निजमाता पेनदुन आरादना किय्यानव सहरता कदरगल्‍ला वेरे जातिता मुर्ताह्‍कुन, पेद्‍दाल्कुन एक्‍किस्तुर. अस्‍के ओर पौलुस, बरनाबासुन पक्‍का तकलिप कीसि ओर्कुन आ एरियाताल पलाते पेचाहतुर. ");
INSERT INTO esg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ओर इव्वुर ओरा काल्कुना दुब्बा अग्गेन दुल्‍पिसि ओरापोर्रो विरोद हुप्पिचि इकोनिया सहरते पेय्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","गानि अंताकियाता विस्वासुल्‍क पवित्र आत्माते पूरा निंडिस आनंदमते मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इल्‍हा पौलुस आनि बरनाबास इकोनिया सहरते यहुदिल्कुना दर्मसास्‍त्रम कराहना लोते होत्‍तुर. अगा पेनदा पोल्‍लें बेस वेहतुर. अदुनहाटीं यहुदिल्क आनि युनानि जातितोर वेल्‍लेटुर लोकुल्‍क येसुनपोर्रो विस्वासम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","गानि विस्वासम कियवा यहुदिल्कु, विस्वासुल्‍कुनतोनि जगडम कियालय वेरे जातितोर्कुन एक्‍किस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","अय्नागानि पौलुस आनि बरनाबास अगा वेल्‍लेने रोजकु आगिसि मत्‍तुर. सामिना कुर्पाता बारेमते वेरियाकोंटा वेहचेके मत्‍तुर. ओर वेहना पोल्‍लें निजम इंचि गवाइ हुप्‍सालय सामि ओरा कय्‍दाल चिन्‍हां, इचंत्रमता कबाह्‍क हुप्‍सुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","गानि हेके सहरते वरोनद वरोंकु अर्राकोंटा आता. इच्‍चुर यहुदिल्कुनहेके, इच्‍चुर बारे प्रेरितुल्कुनहेके आतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","वेरे जातितोर आनि यहुदिल्कु ओरा अदिकारिल्कुनतोनि कलियसि पौलुसुन आनि बरनाबासुना कदर रेहचि बंडां हुक्‍कालय तयार आतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","इद पोल्‍ले पौलुसुंक आनि बरनाबासुंक एर्का आता. अदुनहाटीं ओर लुकावनिया जिल्‍लाते विततुर. अद जिल्‍लाता लिसरा, दिरबे सहरते आनि दग्‍गेटा नाहकुने होंचि पेनदा बेसता कबुर वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लिसराते वरोर कुंटि मनकल उदिस मत्‍तोर. ओर पुटतगाटाल बस्‍केने ताका हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","पौलुस वेहना पोल्‍लें ओर केंजसेके मत्‍तोर. अस्‍के पौलुस ओन उंदेतीर हूळसि, ई कुंटिन लोप्पो बेस आयना विस्वासम मंता, इंचि इनकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अस्‍के पौलुस ओन, “तेदसि बेस नित्‍ता,” इंचि लगांचि इत्‍तस्के, ओर एगरिसि तेदसि ताकालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","लोकुल्‍क पौलुस कीतदुन हूळसि, लुकावनिया बासाते, “पेनकु मनकना रूपमते मनागा रेय्‍सि वातां,” इंचि लगांचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ओर बरनाबासुन, जेयुस पेन, इत्‍तुर. आनि पौलुस वळ्‍कानंटे पेद्‍दा मत्‍तोर इंचि ओन, हिरमेस पेन, इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","जेयुस पेनदा गुळि, नाटुक मुन्‍ने मत्‍ता. दाना पेर्माल, लोकुल्‍कुनतोनि कलियसि, पौलुस आनि बरनाबासुनाहाटीं मोक्‍कु हियालय कोंदां, पुंगाह्कुना दुम्में पीकुंचि सहरते नेंगना गलमानगा तत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","गानि ओर इल्‍हा कीतद केंजसि, प्रेरित बरनाबास आनि पौलुस ओरां कपडिं हराहकुत्‍तुर. लोकुल्‍कुना लोप्पो वितसि, ");
INSERT INTO esg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ए लोकुरिटा, मिमेट इल्‍हा बारि कीसंतिर? मोमोटगुडा मीलेसींटा मनकालोरमे. मिमेट वट्‍टि पोल्‍लेन होळसि, जीवाते मनना पेनदाहेके तिरियट. अदे पेन मब्बुन, बूमितुन, समुद्रमतुन आनि अव्टे मत्‍तव अन्‍निटवुन पुटिस्ता. इंचि अदे पेनदा बेसता कबुर वेहालय मोमोट वातोम. ");
INSERT INTO esg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","मुन्‍नेटा कालमते पेन, अन्‍नि जातिना लोकुल्‍कुन ओरा इस्‍टमाताप ओर्कुन मोळ्‍का हीता. ");
INSERT INTO esg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","गानि मीकु मब्बुनाल पिर्रु हीता, कालमनुसार पंटा पंडिस्ता, तिनालय गाटो हीसि, मीकुन आनंदमते इरसि, ‘ननाने निजम पेनदुन आंदुन’ इंचि दाना बेसता कबाह्‍कुनाहेंदाल मीकु हुपिस्‍ता,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","अच्‍चोन वेहिनागानि वेल्‍ले तिप्पलते ओर्क मोक्‍कु हियालय वातोर्कुन आपा परतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","आयंका पीसिदियाता अंताकिया सहरताल, इकोनिया सहरताल इच्‍चुर यहुदिल्क वातुर. वासि लोकुल्‍कुन ओरा बाजुंक कीकुंचि, पौलुसुनपोर्रो बंडां हुक्‍तुर. ओर हातोर इनकुंचि ओन सहरता पलाते इग्‍गिस ओतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पजा सिस्युल्कु ओनगा वासि सुट्‍टु निततुर. अस्‍के पौलुस तेदिस सहरते होत्‍तोर. मर्रा इंकुंदि रोज बरनाबासुनतोनि दिरबे सहरते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पजा पौलुस आनि बरनाबास दिरबे सहरता लोकुल्‍कुंक पेनदा बेसता कबुर वेहचि, वेल्‍लेटोर्कुन सिस्युल्कु कीतुर. पजा लिसरा, इकोनिया, पीसिदियाता अंताकिया सहरते मल्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","अगा होंचि, “पेनदा राज्येमते होनना इत्‍ते तिप्‍पल्‍क वांतां, दानाहाटीं विस्वासमते गट्‍टिगासि मंटु,” इंचि वेहचि दैरनेम हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","पजा ओर, अगाटा हरेक कलिसियाने पेद्‍दाल्कुन निलाहतुर. ओराहाटीं ओक्‍कापोद्‍दु मंचि पारतना कीसि, ओर बा सामिनपोर्रो अय्ते विस्वासम कीतुर, आ सामिंक अप्पजेपतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","आयंका ओर पिसिदियाताल पंपुलिया एरियाते होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","अगा होंचि, पिरगा सहरते पेनदा बेसता पोल्‍लें वेहचि अतलिया सहरते होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अगटाल डोंगा उदसि सिरियाता अंताकियाते मल्सि होत्‍तुर. बद कबळ अय्ते ओर पूरा कीतुरो, अद कबळ पेनदा कुर्पाते अदे जेगाताल सुरुव कीसि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","अगा होत्‍तरित्‍ते, ओर कलिसियातोर्कुन जमा कीसि, पेन ओरा कय्‍दे बल्हा पेद्‍दा-पेद्‍दा कबाह्‍क कीता, वेहतुर. वेरे जातितोर्कुनगुडा विस्वासम कियालय पेन बल्हा हर्रि कीता, इंचि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","आयंका सिस्युल्कुनतोनि वेल्‍लेन रोजकु ओर अगा मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","पजा यहुदियाताल इच्‍चुर लोकुल्‍क अंताकियाक वासि, “मूसाना नियम परकारम मीवद कतना आयाकोंटे मीकु मुक्‍ति दोर्का पर्रो” इंचि अगाटा दादालोर्कुंक कराहलय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ओर लोकुल्‍क कराहता पोल्‍लें पौलुसुंक, बरनाबासुंक नच्‍चा हिल्‍लें. अदुनहाटीं ओरा नड्‍डुम वेल्‍लेन लोल्‍लिं आतां. अय्ते ई लोल्‍लिंकु समादानम पूस कियनाहाटीं पौलुस, बरनाबास आनि इच्‍चुर विस्वासुल्‍क येरुसलेम होंचि अगाटा प्रेरितुल्कुंक, पेद्‍दाल्कुंक कलियना इंचि निरनायम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","पजा अगाटा कलिसियातोर ओर्कुन सार्ला कीतुर. अय्ते ओर पिनिके, सामरिया इनना एरियानाल तिरियसेक येरुसलेम होत्‍तुर. होननेंके वेरे जातितोर ओरा मनसु बल्हा मार्सकुत्‍तुर, अदुन बारेमते वेहासेक होत्‍तुर. इल्‍हा ओर अगाटा दादालोर्कुन इरगा कूस कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ओर येरुसलेम एवतस्‍के, अगाटा कलिसियातोर, प्रेरितुल्क, पेद्‍दाल्क ओर्कु बेस आनंदमते कलियतुर. पजा पौलुस आनि बरनाबास पेन ओरतोनि मंचि बता-बता कबाह्‍क कीता, अदंता वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","अस्‍के परिसिल्‍कुनाल इच्‍चुर विस्वासुल्‍क तेदसि, “वेरे जातितोरद कतना तप्‍पाकोंटा आये पींता, मूसाल वेहता नियम परकारम ओर ताके पींता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","अस्‍के ई पोल्‍लेन बारेमते विचारम कियालय प्रेरितुल्क आनि पेद्‍दाल्क उंदगा जमा आतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","बच्‍चोनो जेम विचारम कीतारित्‍ते पत्रु तेदतोर. तेदसि, “नावा दादालोरिटा, वेरे जातितोर नावा तोळ्‍दाले पेनदा बेसता कबुर केंजसि विस्वासमते वायाना इंचि, वेल्‍लेन रोजकु मुन्‍ने पेन मना अंटोर नड्‍डुमताल नाकुन पेर्कुत्‍ता. इद संगति मीकु अंटोर्क एर्के मंता. ");
INSERT INTO esg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मनकालोर्कुना मनसुन एरपाट कियाना पेन, बल्हा मनाकु पवित्र आत्मातुन हीता, अल्‍हेने ओर्कु इंका हीसि ओरतोनि कलियसि मत्‍ता संगति मनाकु वेहता. ");
INSERT INTO esg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ओर विस्वासम कीताहेंका पेन ओरा मनसुकुन इंका बेस कीसि, ओर्कु, मनाकु बतले बेदबावम इर्रा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","अय्ते मरि, मनमगुडा मना पेद्‍दाल्कगुडा कांजा पर्रुवा कांडितुन मिमेट सिस्युल्कुना हट्‍टनपोर्रो ताससि, मीकु पेनदा परिक्‍सा हूळानद मंताना? ");
INSERT INTO esg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","येसु सामिना कुर्पाते मनाकु मुक्‍ति दोर्कंता इंचि मनम नम्मंतोम गदा! अल्हेन ओर्कगुडा मुक्‍ति दोर्कंता इंचि विस्वासम मंता.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","अस्‍के बरनाबास आनि पौलुस, पेन ओर्कुन वेरे जातितोर लोप्पो लोहचि ओराहेंदाल बसंटा चिन्‍हां, इचंत्रमता कबाह्‍क कीता, अदुन ओर वेहालय दल्‍गुतुर अय्ते अंटोर लोकुल्‍क सपुडदाका आसि ओरा पोल्‍लें केंजालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ओरा वळकुमळ आतारित्‍ते याकोब इल्‍हा वळकालय दल्‍गुतोर. नावा दादालोरिटा, नना वेहनद केंजट. ");
INSERT INTO esg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","पेन मोट्‍टा मोदाला वेरे जातितोर पोर्रो दाना दया हुपिच्‍चि ओरागटाल इच्‍चुर्कुन दाना लोकुल्‍कुन लेह्का बल्हा कीकुत्‍ता, इदुना बारेमते सिमोन पत्रु मनाकु वेहचि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","पेनदा कबुरतोर वेहता पोल्‍लें इंका इद गटनकु कलियंतां. अव पोल्‍लें इल्‍हा रासि मंतां: ");
INSERT INTO esg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“नना तिरियसि वासि दाविदना अरसोत्‍ता राज्येमतुन मर्रा निल्‍हंतन, दाना नासडेम आता मुक्‍का-मुक्‍कातुन कल्‍पिसि अद मुन्‍ने मत्‍ताप मर्रा कींतन. ");
INSERT INTO esg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","अस्‍के पेर्कुत्‍ता वेरे जातितोर आनि मिगिल्सि मत्‍ता अन्‍नि वेरे जातिनोर, पेनदुन पहकानुर, इव पोल्‍लें पेन वेहता. ");
INSERT INTO esg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","पेन कुद इदुन बारेमते वेल्‍लेन रोजकु मुन्‍ने वेहचि मत्‍ता.” ");
INSERT INTO esg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","अदुनहाटीं नावा विचारम बतल मंता इत्‍ते, मनसु मार्सकुंचि पेनदाहेके तिरियता आ वेरे जातितोर्कुन मनम तकलिप कियामन्‍नि. ");
INSERT INTO esg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","गानि बोम्मांक मोळ्‍कतदुन तिनामन्‍नि, व्यबिचारम कियामन्‍नि, गोंदके पिसकिसि हव्‍कता जिवरासिता हव्‍विं, नेत्‍तुरतुन तिनामन्‍नि इंचि ओर्क मनम रासि लोहकोम. ");
INSERT INTO esg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","बारित्‍ते ओर एनकाटाल मूसाल वेहता नियमतुन, अन्‍नि सहरकुने वेहासेक अल्हेन हरेक नोमकेम रोजुननाड दर्मसास्‍त्रम कराहना लोते हद्‍विसि वेहासेक मंतुर, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","पजा प्रेरितुल्क, पेद्‍दाल्क आनि कलिसियातोर अंटोर कलियसि, अगाटा विस्वासुल्‍कुनाल इच्‍चुर लोकुल्‍कुन पेरसि पौलुस आनि बरनाबासुनतोनि अंताकियाक लोहना निरनायम कीतुर. पजा बरसब्बान आनि सिलासुन ईर इव्वुर्कुन पेरतुर. ईर इव्वुरगुडा विस्वासुल्‍कुनाल मुक्‍य मनकालोर मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ओर होननेंके ओरा कय्‍दे उंदि सिट्‍टि हीतुर, अद सिट्‍टिते इल्‍हा रासि मंता. अंताकिया, सिरिया, किलिकिया सहरकुने मनना अंटोर वेरे जाति विस्वासुल्कुंक, येरुसलेमते मनना मीवा पेद्‍दाल्क आनि प्रेरितुल्‍कुना हेंदाल जोहार. ");
INSERT INTO esg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","मावा पावरमगल्‍ला दादालोरिटा, माकुन पूस कियाकोंटेन महागटाल इच्‍चुर लोकुल्‍क मिहगा वासि ओरा मनसुंक वाताप वळकिसि मी मनसुने अनमानम पुट्‍टिचि मीकु तकलिप हीतुर इत्‍ता संगति मोमोट केंजतोम. ");
INSERT INTO esg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","अदुनहाटीं मना पावरमगल्‍ला बरनाबास आनि पौलुसुनतोनि, पेर्कुत्‍ता इच्‍चुर लोकुल्‍कुन मीहेके लोहना इंचि मोमोट अंटोरम कलियसि निरनायम कीतोम. ");
INSERT INTO esg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","मना अंटोरा किरिस्‍तु येसु सामिना पोरोलहाटीं बरनाबास आनि पौलुस ईर ईरा जीवातुन इंका हियालय तयार आता मनकालोर आंदुर. ");
INSERT INTO esg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","अय्ते मोमोट सिट्‍टिते रासता अन्‍नि पोल्‍लें यहुदल आनि सिलास ओर ओरा तोळ्‍दाल मीकु वेहना इंचि ओर्कुन मीहेके लोहसेक मंतोम. ");
INSERT INTO esg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","बोम्मांक मोळ्‍कतदुन मिमेट तिनमट, गोंदके पिसकिसि हव्‍कता जिवरासिता हव्‍विन, नेत्‍तुरतुन तिनमट, व्यबिचारमताल लक्‍कु मंटु. इसंटा अवसरमाता नियमकुंक तप्‍पा इंका वेरे बद्‍दे बर्वु मीपोर्रो वाटा मन्‍नि इत्‍ता पोल्‍ले पवित्र आत्माकु आनि माकु बेस अनपिस्ता. मिमेटगिंटा इव पोल्‍लेनाल लक्‍कु मत्‍ते मीके बेस आयार. मीकु अंटोर्क जोहार. ");
INSERT INTO esg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","इल्‍हा रासि ओर्कुन अगटाल सार्ला कीतंका, ओर पजा अंताकियाक एवतुर. एव्‍सि, अंटोर विस्‍वासुल्‍कुन जमा कीसि अद सिट्‍टितुन ओरा कय्‍दे हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","सिट्‍टिते रासि मत्‍ता प्रोत्‍साहन हियना पोल्‍लें हद्‍विसि ओर्क अंटोर्क वेल्‍लेन कुसि आता. ");
INSERT INTO esg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहुदल आनि सिलास, ईर इव्वुरगुडा पेनदा कबुरतोर आंदुर. अदुनहाटीं अगाटा विस्वासुल्‍कुनतोनि वेल्‍लेनजेम वळ्‍किसि ओर्कुन विस्वासमते गट्‍टिगा कीसि ओर्कु प्रोत्‍साहन हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","इल्‍हा यहुदल आनि सिलास कोन्‍नि रोजकु अगा मत्‍तुर. पजा अंटोर विस्वासुल्‍क जमा आसि, ओर्कुन बोर अय्ते अंताकियाक लोहतुरो ओराहेके वापस येरुसलेम होनालय सांतिते सार्ला कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","गानि सिलास अंताकियातेन मनना विचारम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पजा पौलुस आनि बरनाबास कोन्‍नि रोजकु अंताकियातेन आगतुर. अगाटा वेल्‍लेन लोकुल्‍कुनतोनि कलियसि सामिना पोल्‍लें कराहसेक, बेसता कबुर वेहासेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","इच्‍चुं रोजकु आतारित्‍ते, “मनम सामिना पोल्‍लें बव-बव सहरकुने वेहतोमो अव अन्‍नि सहरकुने मर्रा दाकोम. पेनदुन नम्मुकुत्‍ता पजा अगाटा विस्वासुल्कुना पिस्वरकु बल्हा बतल मंतांगो हूळसि वाकोम,” इंचि पौलुस बरनाबासुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","अय्ते बरनाबासुंक मरकुसुन (ईन योहानगुडा इंतुर) इंका पज्जेके ओयाना मनसु मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","गानि, पेनदा कबळते आकिरदाका कलियसि मनाकोंटा नड्‍डुमे पंपुलिया एरियाताल होळसि वापस होत्‍ता मरकुसुन पज्जो ओयमळ पौलुसुंक नच्‍चा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","इल्‍हा ओर इव्वुर नड्‍डुम वेल्‍लेन पोल्‍लें आसि ओर वेरे-वेरे आतुर. अस्‍के बरनाबास मरकुसुन पीकुंचि डोंगाते उद्‍दिस साइप्रस इनना दीबेक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पजा पौलुस ओनतोनि मननाहाटीं सिलासुन पेरकुंचि अगटाल होत्‍तोर. अय्ते अगाटा विस्वासुल्कगुडा पौलुसुंक आनि सिलासुंक पेनदा कुर्पा दोर्कानाहाटीं पारतना कीसि ओर्कुन पेनदा कय्‍दे अप्पजेपतुर. ");
INSERT INTO esg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","अस्‍के ओर सिरिया, किलिकिया इनना एरियानाल तिरियसेके अगाटा कलिसियानोर्कुंक कलियसि पेनदा विस्वासमते बेस एदगानाहाटीं ओर्कु बेसता पोल्‍लें वेहासेक होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पजा पौलुस मर्रा दिरबे इनना सहर होंचि अगटाल लिसरा इनना सहर होत्‍तोर. हूळा! अगा तिमोति पोरोलतोर वरोर सिस्युड मत्‍तोर. ओना तल्‍लुर यहुदि जातिता उंदि विस्वासि मुरतळ आंद. गानि ओना बाबाल वेरे जातितोर (युनानि जातितोर) मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लिसरा, इकोनिया सहरकुने मनना विस्वासुल्‍क ओन बेस मनकल इनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","अय्ते पौलुस, तिमोतिन ओना पज्जेके ओयाना विचारम कीतोर. गानि अद एरियाते मनना अंटोर यहुदि लोकुल्‍कुंक, तिमोति वेरे जातितोना (युनानि जातितोना मर्रि) मर्रि इंचि एर्का मत्‍ता, अदुनहाटीं यहुदिल्कुंक समादानम आयना इंचि पौलुस तिमोतिना कतना कियागोटतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","अस्‍के ओर येरुसलेमता प्रेरितुल्क आनि पेद्‍दाल्क वेहता पोल्‍लेन सहर-सहर होंचि वेहचि, अव पोल्‍लेन परकारम ताकना इंचि वेहासेक होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","इल्‍हा अगाटा कलिसियानोरा विस्वासम गट्‍टिगासि इंका वेल्‍लेन लोकुल्‍क विस्वासमते वासि रोज-रोज वेल्‍लेन मंदि आतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ओर्कुन पवित्र आत्मा, ‘आसिया एरियाते पेनदा पोल्‍ले वेहा मन्‍नि’ इंचि इत्‍ताहाटीं ओर अदे एरियाता पुगरिया, गलातिया एरियानाल होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","पौलुस आनि तिमोति मूसिया एरियाता गेट्‍टुदाका एवतस्‍के ओर बितुनिया एरिया होनना कोसिस कीतुर. गानि येसुना आत्मा अगा इंका होन्‍ना हिया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","अय्ते ओर मूसियाताल त्रोआस सहरते एव्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","अदे नर्का मेसिडोनिया एरियातोर वरोर मनकल, निमे मेसिडोनियाते वासि, मावा सहायम कीम, इंचेक विनंति कीसेके मंतोर. इल्‍हा पौलुस दर्सनमते हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ओन्क इल्‍हा दर्सनम आतारित्‍ते, आ लोकुल्‍कुंक पेनदा बेसता पोल्‍लें वेहालय पेन माकुन केयता इल्‍हा इनकुंचि मोमोट अस्‍केन मेसिडोनिया होनानद विचारम पक्‍का कीतोम. ");
INSERT INTO esg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","इल्‍हा मोमोट त्रोआस सहरताल डोंगाते समुद्रम हर्रि पीसि सवरगा सुमात्राके सहरते एव्‍सि, इंकुंदि रोजु नियापुलिस इनना सहर होत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","पजा अगटाल पिलिपिया इनना सहर होत्‍तोम. अद मेसिडोनिया एरियाता मुक्‍य सहर आंदु. अगा रोमि लोकुल्‍क मनुंदुर. अद सहरते मोमोट कोन्‍नि रोजकु मत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","उंदि नोमकेम रोजुने, यहुदिल्कुना पारतना कियाना जेगा, सहरता पलाते बेरेड ओड्‍डुंक मंदार इंचेके मोमोट होत्‍तोम. अगा पारतनाकु वासि मत्‍ता मुर्ताह्कुनतोनि उद्‍दिस वळकसेके मत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","अवुन लोप्पो उंदि लिदिया पोरोलता मुरतळ मत्‍ता. अद तुयतीरा सहरतद आंद. दान्क पेनदापोर्रो वेल्‍लेन विस्वासम मत्‍ता. अद वेल्‍लेन दराता नेडि पंडि रंगुना कपडिं अम्मुंदु. अद बेस मनसु दोस्‍सि मावा पोल्‍लें केंजसेके मत्‍ता. पौलुस वेहना पोल्‍लेन बेस केंजालय सामि दाना मनसुन तयार कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","अद आनि दाना लोते मत्‍तोर अंटोर बापतिस्मा एततारित्‍ते अद, “मिमेटगिंटा नाकुन पेनदा निजम विस्वासि मुरतळ इंचि इनकुनानय्ते नावा लोन वासि आगट,” इंचि माकुन विनंति कीता. अस्‍के मोमोट दाना लोन होत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","उंदि मल्का मोमोट पारतना कियाना जेगातेके होंचेके मत्‍तोम, अस्‍के माकु उंदि दासि पेगिड कलियता, दाना लोप्पो बविस्य वेहाना आत्मा मत्‍ता. अद लोकुल्‍कुंक ओरा बविस्य वेहचि दाना मालकुल्कुंक वेल्‍लेन दनम संपलिच्‍चि हियुंदु. ");
INSERT INTO esg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","अद, “ई मनकालोर अन्‍निंकन्‍ना पेद्‍दा पेनदा सेवाकुल्क आंदुर. ईर मीकु मीवा पापमताल मुक्‍ति दोर्कना हर्दा बारेमते वेहासेक मंतुर,” इंचि वरगेयसेके पौलुस आनि मावा पज्जो वाता. ");
INSERT INTO esg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","अद वेल्‍ले रोजकुनाल इल्हेने वेहासेक मत्‍ता अय्ते पौलुस परेसान आतोर. अदुनहाटीं ओर पजोळ्क तिरियसि, “येसु किरिस्‍तुना पोरोलते नना नीकु आदेस हीसेक मंतन, ई पेगिटाल पेय्सि होन,” इंचि आ आत्मातुन इत्‍तोर. अस्‍के आ आत्मा पेगिटाल बिराना पलाते पेय्सता. ");
INSERT INTO esg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","पजा आ पेगिटा मालकुल्कुंक दोर्कना दनम दोर्काकोंटा आताहेंके ओर पौलुसुन आनि सिलासुन दोर्कापीसि, इग्‍गिसेके नड्‍डुम सहरते अदिकारिल्कुना मुन्‍ने ओतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","रोमि अदिकारिल्कुना मुन्‍ने ओसि, “ईर यहुदि लोकुल्‍क आंदुर. मावा नाटेने वेल्‍ले तकलिप कीसंतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ईर वेहना रीति-रिवाजकुन परकारम ताकमळ मावा रोमि लोकुल्‍कुना नियमकुना विरोदमते मंता,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","लोकुल्‍कुना मंदागुडा पौलुस आनि सिलासुना विरोदमते तिरियतुर. रोमि अदिकारिल्‍क, पौलुस आनि सिलासुना कपडिं हराहचि ओर्कुन दुड्‍डुकुने तनना आदेस हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ओर्कुन पक्‍का तंतारित्‍ते जेलने वाट्‍सि, ओरपोर्रो कडक पहारा इर्राना इंचि जेलना अदिकारिंक आदेस हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ओन्क इल्‍हा आदेस दोर्कतारित्‍ते ओर्कुन जेलना लोप्पोटा अर्राते वाट्‍सि, ओरां काल्‍कुन उंदि मोट्‍टुंकु बोल अरहचि दोहतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","नळजाम नर्काटा वेलाते पौलुस, सिलास पेनदा स्‍तुति पाटां पारसेके, पारतना कीसेक मत्‍तुर. जेलने मत्‍ता वेरेतोर केंजसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","अस्‍के उंदेदम बूमि इल्‍हा कदुलता गदा, जेलना पुनादि कदुलसि जेलनव अन्‍नि तल्‍पुक उंदे मल्का कुल्‍ला आतां. जेलने मत्‍ता अंटोरा बेडीं लेंगसि होत्‍तां. ");
INSERT INTO esg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","जेलना अदिकारि निद्राताल तेदसि हूळतस्‍के जेलना तल्‍पुक कुल्‍ला दिसतां. अदुन हूळसि, जेलने मत्‍तोर अंटोर पेय्सि वित्‍तुर बारे, इनकुंचि, ओनाद ओरे कोह्‍ककुंचि हांतन इंचि कसेर तेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","गानि पौलुस, “मोमोट अंटोरम इगेने मंतोम, नीवद निमेने नुकसान कीकुनमा,” इंचि जोरते वरगेयतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","अस्‍के वरोनतोनि वेडसि ताया वेहचि आ अदिकारि बिराना लोप्पो होत्‍तोर. वनकुसेक पौलुस, सिलासुना काल्कुनपोर्रो अरतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","पजा ओर्कुन पलाते तच्‍चि, “दादालोरिटा, पापाल्कुनाल मुक्‍ति दोर्कालय नाकु बतल किया पींता?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","अस्‍के, “निमे येसु सामिना पोर्रो विस्वासम इर्रा, नीकु, नीवा लोते मत्‍तोर अंटोर्क मुक्‍ति दोर्कंता,” इंचि ओर इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ओर ओन्क, ओना लोते मत्‍ता अंटोर्क पेनदा पोल्‍लें वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","अस्‍के जेलना अदिकारि अदे नर्का अदे वेलाते ओर्कुन अगटाल ओसि, ओरां पुनकुन नोरतोर. पजा आल्सेम कियाकोंटा ओर, ओना लोते मत्‍तोर अंटोर बापतिस्मा येततुर. ");
INSERT INTO esg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","पौलुस, सिलासुन ओर ओना लोन पीसि ओसि ओर्कु गाटो दोस्तोर. इंदके पेनदापोर्रो विस्वासम इरताहेंके ओर, ओना लोते मत्‍तोर अंटोर इरगा कूस आतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","पंगातारित्‍ते रोमि अदिकारिल्‍क, ओर्कुन होळसीम्टु इंचि जेलना अदिकारिंक वेहालय इच्‍चुर सिपाइल्कुन लोहतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जेलता अदिकारि, “मीकुन होळ्‍सगोम इंचि रोमि अदिकारिल्‍क सिपाइल्कुन लोहचीतुर, इंदके मिमेट सांतिते पेय्सि होंटु,” इंचि पौलुसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","अस्‍के पौलुस, “मोमोट इंका रोम देसेमता रहिवासिल्के आंदुम. अय्नागानि ओर मावा बतले तप्पु हूळाकेने माकुन लोकुल्‍कुना मुन्‍ने तंतुर, जेलने वाटसीतुर. इंदके सपुडदाका बोर्कु एरपाट हिलाकोंटा माकुन होळसियालय हूळसंतुर, गानि इल्‍हा आयापर्रो. माकुन होळसानद मत्‍ते ओर कुद इग्‍गे वासि होळसियिरकांटी,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाइल्क होंचि रोमि अदिकारिल्कुंक इद संगति वेहचीतुर. पौलुस, सिलास ईर रोम देसेमता रहिवासिल्क आंदुर इंचि रोमि अदिकारिल्कुंक तेळियतारित्‍ते ओर इरगा वेरियतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","आयंका रोमि अदिकारिल्‍क वासि ओर्कुन मापि तल्किसि पलाते ओतुर. ओर्क विनंति कीसि इद सहर होळसि होनालय वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","पौलुस, सिलास जेलनाल पलाते पेय्सि लिदियाना लोन होत्‍तुर. विस्वासि दादालोर्कुंक कलियसि, ओर्कु प्रोत्‍साहन हीसि अगटाल पेय्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पजा ओर अंपिपुलि आनि अपुलोनिया सहरकंता तिरियसेके-तिरियसेके तेसलोनि सहरते एवतुर. अगा यहुदिल्कनद उंदि दर्मसास्‍त्रम कराहना लोन मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पौलुस ओना अलवट परकारम यहुदिल्कुना दर्मसास्‍त्रम कराहना लोतागा होत्‍तोर. होंचि मूड नोमकेमकुन दाका ओरतोनि दर्मसास्‍त्रमता बारेमते चर्चा कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","अगा ओर, किरिस्‍तुना हायमळ आनि हामुरताल तिरियसि तेदमळ बच्‍चोनो अवसरम मत्‍ता, इत्‍ता संगतितुन दर्मसास्‍त्रमताल हद्‍विसि ओर्कु बेस तेळियागोट्‍सि वेहतोर. पजा बा येसुना बारेमते अय्ते नना मीवा मुन्‍ने वेहसेक मंतनो आ येसे किरिस्‍तु आंदुर, इंचि ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","इल्‍हा इच्‍चुर लोकुल्‍कुंक निजम अनपिच्‍चि ओर पौलुस, सिलासुनहेके कलियतुर. पेनदुक वेरियना वेल्‍लेटुर युनानि लोकुल्‍कगुडा ओरतोनि कलियतुर. अचोने आयका वेल्‍लेन बेस पोरोल होत्‍ता मुर्ताह्कगुडा ओरतोनि कलियसि मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","गानि यहुदिल्कुंक मात्रम मंटा अरसेक मत्‍ता. ओर इच्‍चुर बदमासुल्कुन जमा कीसि सहरते लोल्‍लिं कीतुर. बल्हा कीसन्‍ना गानि पौलुस, सिलासुन लोकुल्‍कुना मुन्‍ने तायागोम इंचि ओर यासोन इनानोना वरोन लोतपोर्रो होंचि अरतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","पौलुस, सिलास ओर्कु दोर्का हिल्‍लुर अय्ते यासोनुन आनि इच्‍चुर दादालोर्कुन सहरता अदिकारिल्‍कुन मुन्‍ने इग्‍गिस ओतुर. ओसि, “ईर मनकालोर पूरा दुनियातुने हिळु-पोर्रो कीतुर, इंदके इग्‍गेगुडा वातुर. ");
INSERT INTO esg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ईरकु यासोन ओना लोन मनालय जेगा हीतोर. ईर अंटोर कैसर राजाना नियमकुंक अड्‍डम कबळ कींतुर. अचोने आयका ओर, इंकावरोर राजाल मंतोर ओना पोरोल येसु आंद,” इंचि वेहांतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","इद पोल्‍लेतुन केंजसि अगा मत्‍ता लोकुल्‍क आनि सहरता अदिकारिल्‍क इरगा होंगुंक वातुर. ");
INSERT INTO esg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","पजा यासोनुन हेंदाल आनि कळमातोरहेंदाल दंडगु तेंडकुंचि, रासकुंचि ओर्कुन होळसीतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","पजा बिराना नर्काटद-नर्केन दादालोर पौलुस, सिलासुन बिरिया इनना सहर लोहचीतुर. ओर अगा एवतारित्‍ते यहुदिल्कुना दर्मसास्‍त्रम कराहना लोते होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","तेसलोनि सहरता यहुदिल्कुंकन्‍ना इगेटा यहुदिल्क बच्‍चोरो बेस मत्‍तुर. ईर पौलुस वेहना पोल्‍लेन बेस मनसु ताससि केंजुंदुर. हरेक रोजु दर्मसास्‍त्रमतुन हद्‍विसि पौलुस वेहना पोल्‍लें निजमेना इंचि बेस अर्तम कीकुनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","इल्‍हा वेल्‍लेन मंदि यहुदिल्क विस्वासम कीतुर. यहुदिल्कुन लेह्कने बेस कदर मत्‍ता युनानि मुर्ताह्क-मांड्‍सागुडा विस्वासम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","गानि बस्के अय्ते पौलुस, पेनदा पोल्‍लें बिरिया सहरतेगुडा होंचि कराहचंतोर इंचि तेसलोनि सहरता यहुदिल्कुंक तेळियतनो, अस्‍के ओर अगा वासि लोल्‍लिं कियमळ, लोकुल्‍कुंक एकरेवुल्क वेहमळ सुरुव कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","अदुनहाटीं दादालोर पौलुसुन बिराना समुद्रम ओड्‍डुनहेके लोहचीतुर. गानि सिलास, तिमोति मात्रम अग्गेन आगतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुसुनतोनि बोर अय्ते होत्‍तुरो ओर पौलुसुन एतेंस इनना सहरदाका अरहतुर. पौलुसुन हेंदाल, सिलास, तिमोति बिराना ओनगा वायागोम, इंचि इत्‍ता आदेस पीकुंचि ओर अगटाल मल्सि बिरिया सहरकु वातुर. ");
INSERT INTO esg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पौलुस, एतेंस सहरते सिलास आनि तिमोतिना एदुर हूळसेक मत्‍तस्के, अद सहर बोम्मानतोनि निंडिस मत्‍तद हूळसि ओना मनसुने बागा दुक्‍कम वाता. ");
INSERT INTO esg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","दानहाटीं ओर रोज-रोज दर्मसास्‍त्रम कराहना लोह्कुने होंचि यहुदिल्कुनतोनि आनि पेनदुक वेरियना वेरे जाति लोकुल्‍कुनतोनि चर्चां कियुंदुर. अचोने आयका चौकुल्कुने होंचि बोर दोर्कुते ओरतोने चर्चा कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","अस्‍के इच्‍चुर इपिकुरि आनि स्तोइकि इनना एक्‍को तेल्वि मत्‍ता लोकुल्‍क ओनतोनि जगडम दोसकुत्‍तुर. अव्टेटाल इच्‍चुर, “ई पिचुर-पिचुर वळकानोर बतल वेहांतन इंचंतोर?” इंचि इत्‍तुर. इंकिच्‍चुर बारे, “ईर अय्ते वेरे जातितोरा पेनदा बारेमते कराहनोर दिसंतोर” इंचि इत्‍तुर. पौलुस येसुना बारेमते आनि ओर हासि मर्रा जीवाते तेदतदुन बारेमते कराहुंदुर इंचि ओर अल्हा इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","आयंका ओन पीसि अरियपगुस इनना पंचादिते ओसि, “निमे कराहना ई पूना पोल्‍लें बतांगो माकु तेळियानाल वेहा. ");
INSERT INTO esg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","इंका निमे माकु मोमोट बस्के केंजुवा, तेळियवा पोल्‍लें वेहचंतिन. ई पोल्‍लेना अर्तम बतलो माकु तेळियागोट्‍सि वेहा.” इंचि विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","एतेंस सहरता लोकुल्‍क आनि वेरेटागटाल वासि अगा मनना पलाता लोकुल्‍क, बस्‍केळ्‍क बतलन्‍ना पूनद केंजालय आनि दाना बारेमते चर्चा कियमळ तप्‍पा इंका वेरे बतले कबळ कियाकोंदुर. ");
INSERT INTO esg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","अस्‍के पौलुस, अरियपगुस इनना पंचादिते नित्‍तिसि इल्‍हा वळकालय दल्‍गुतोर. एतेंसता लोकुरिटा! मिमेट अन्‍नि तीरकुने पेनदा कदर कीसंतिर इत्‍ता संगति नाकु दिस्‍संता. ");
INSERT INTO esg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","नना मीवा सहरअंता तिरियसि मिमेट मोळ्‍कना अन्‍नि वस्‍तुकुन हूळतन. अचोने आयका, “एरपाट हिलवा पेनदाहाटीं” इंचि रासि मत्‍ता उंदि गद्‍देतुन इंका नना हूळतन. अय्ते मीकु एरपाट हिलाकोन्‍ना मिमेट मोळ्‍कना आ पेनदा बारेमतेन नना मीकु वेहंतन. ");
INSERT INTO esg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","इद दुनियातुन, इद दुनियाते मनना अन्‍निटवुन पुटिस्ता पेने, बूमि आनि स्वर्गमता सामि आंद. अदुनहाटीं मनकालोर तयार कीता गुळिने अद मन्‍नो. ");
INSERT INTO esg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","दानगा बतले तक्‍को हिल्‍ले. इंका अदे अंटोर्क ऊपिरि, पिस्वर आनि गावाले मत्‍तव अन्‍नि वस्‍तुक हींता. अय्ते असोंटा पेनदुक मनकना कय बतल हिया पर्रंता? ");
INSERT INTO esg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","पेन वरोर मनकन तयार कीता. आ वरोर मनकनतोनि ई दुनियंता निंडिस मननाहाटीं अन्‍नि जातिना लोकुल्‍कुन तयार कीता. इंका ओराहाटीं उंदि वेला, ओर मनना जेगांक गेट्‍टुकु, इल्‍हा पेने कीता. ");
INSERT INTO esg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","मनकालोर पेनदुन पहकागोम इंचि दाना मनसु मत्‍ता. ओक्‍कला पहकिस-पहकिस दान ओर दोर्काबेटकुनानुर. अयना अद मनागटाल बोर्के लक्‍कु हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","मनम दानतोने पिस्सेक मंतोम, दानतोने तिरियसेक मंतोम, अद मंता इंचे मनम मंतोम. इचोने आयका, मनम दाना पिलाल्क आंदुम, इंचि मीवा लोप्पोटोरे इच्‍चुर पाटां रासाना लोकुल्‍कगुडा वेहातुर. ");
INSERT INTO esg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“अय्ते मनम पेनदा मर्कुम आसिगुडा, मनकल ओना तेल्विनुसार तयार कीता एंडि, बंगारम आनि बंडाता बोम्मानलेह्का पेन मनंता इंचि बस्‍केने इननायो. ");
INSERT INTO esg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","मुन्‍नेटा लोकुल्‍कुना पेनदा बारेमते तेल्वि तक्‍को लेक्‍कनहेंका पेन ओर्कुन हूळसिगुडा हूळवाप कीता. गानि इंदके मात्रम दुनियाता अंटोर लोकुल्‍क मनसु मार्सकुननाहाटीं आदेस हीसंता. ");
INSERT INTO esg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","अद पेर्कुत्‍ता मनकनाहेंदाल, इद दुनियाते मनना हरेक मनकना न्‍यायम नीतिते कियानाहाटीं पेन उंदि रोजुन पिक्‍स कीता. अचोने आयका अद पेर्कुत्‍ता मनकन हातोराव्टेटाल मर्रा जीवा अरहचि अंटोर मनकालोर्कुंक अद हीता पोल्‍लेतुन रुजुव कीता.” ");
INSERT INTO esg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","बस्के अय्ते लोकुल्‍क, हातोराव्टेटाल मर्रा जीवाते तेदतोर इत्‍ता पोल्‍ले पौलुसुना तोळ्‍दाल केंजतुरो, अस्‍के इच्‍चुर लोकुल्‍क ओन कव्‍तुर. गानि इंका इच्‍चुर मात्रम, “निमे वेहना पोल्‍ले मर्रा बस्‍केनना केंजंतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","अस्‍के पौलुस पंचादिताल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","इच्‍चुर लोकुल्‍क विस्वासम कीसि पौलुसुंक कलियतुर. ओराव्टेटाल वरोर दियोनुस इनानोर मत्‍तोर, ओर अरियपगुस पंचादिता मेंबर मत्‍तोर. अचोने आयका दामेरा इनना पोरोलतद उंदि मुरतळ ओरतोनि मत्‍ता, इंका वेरे लोकुल्‍कगुडा मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","पजा पौलुस एतेंस सहर होळसिसि कुरेंति सहरते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","अगा ओर अकविला इनना पोरोलता यहुदि मनकंक कलियतोर. ई अकविलाल पुंतुस इनना एरियाते पुटतोर. रोम सहरते मनना अंटोर यहुदिल्कुन कलादियुस राजाल पेय्सि होंटु इंचि आदेस हीतोर. अदुनहाटीं ओर इटलि एरियाताल ओना मुत्‍तो पिरिसकिलानतोनि कुरिंति वातोर. अय्ते पौलुस ओर्क कलियालय होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","पौलुसुनद आनि अकविलानद इव्वुरद इंका डेरां निलाहना दंदे मत्‍ता. अदुनहाटीं पौलुस ओरगा वासि आगतोर. ओर अंटोर कलियसि कबळ कियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ओर हरेक नोमकेम रोजुननाड यहुदिल्कुना दर्मसास्‍त्रम कराहना लोहकुने होंचि युनानि, यहुदि लोकुल्‍कुनतोनि चर्चा कीसि ओर्कु बेस तेळियागोट्‍सि वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","सिलास आनि तिमोति मेसिडोनिया एरियाताल वातस्के, पौलुस ओना पूरा वेला पेनदा पोल्‍लें कराहमळतेन तासुंदुर. इंका यहुदिल्कुनतोनि वळकिसि, येसे किरिस्‍तु आंदुर, इंचि वेहचि गवाइ हियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","गानि यहुदि लोकुल्‍क पौलुसुन हय्‍सा हिल्‍लुर. ओना अपमानम कीतुर. अस्‍के पौलुस ओना कपडिं दुल्‍पसेके ओर्कुन, “मीवा नेत्‍तुर मीवा तल्‍लापोर्रो अर्रि. अव्टे नावद बतल दोसेम हिल्‍ले. इंदकेटाल नना वेरे जातितोर हेके दांतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","इल्‍हा पौलुस दर्मसास्‍त्रम कराहना लोताल पेय्सि दाना बाजुंक मनना तीतु-युसतुस पोरोलता वरोर वेरे जाति बक्‍तुना लोन होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","यहुदिल्कुना दर्मसास्‍त्रम कराहना लोतुक अदिकारि मत्‍ता वरोर क्रिसपुस पोरोलता मनकल, ओना लोतोर अंटोर सामिना पोर्रो विस्वासम कीतुर. अचोने आयका कुरेंति सहरतोर वेल्‍लेटुर लोकुल्‍क पौलुसना पोल्‍लें केंजसि, सामिनपोर्रो विस्वासम इर्सि, बापतिस्मा एततुर. ");
INSERT INTO esg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","उंदि नर्का सामि दर्सनमते पौलुसुंक इल्‍हा वेहतोर, “निमे वेरियाकोंटा वळ्कसेक होन, सपुडदाका मनमा. ");
INSERT INTO esg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","इद सहरते नावा वेल्‍लेन लोकुल्‍क मंतुर, ननागुडा नीवातोनि मंतन. नीवा पोर्रो बोरे कय तेहुर नीकुन बोरे तकलिप किय्युर,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","इल्‍हा पौलुस एडादि नरादाका अग्गेन मंचि ओर्कु पेनदा पोल्‍लें कराहतोर. ");
INSERT INTO esg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","13","गल्‍लिया पोरोलतोर वरोर अकाया इनना एरियाक राज्यपाल मत्‍तोर, अस्‍के यहुदिल्क अंटोर उंदि आसि, पौलुसुंक अड्‍डम तिरियतुर आनि ओन कोरटते पीसि वासि, “ई मनकल नियम परकारम हिलुवा पदतकुने पेनदुन आरादना कियालय लोकुल्‍कुंक वेहासेक मंतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पौलुस वळ्कालय आतोर अच्‍चोटेन गल्‍लिया राज्यपाल यहुदिल्कुनतोनि, “मिमेट वेहना पोल्‍ले बदाना तप्‍पु कीतदुन बारेमते, हिलाकोंटे पेद्‍दा अन्‍यायमता बारेमते आसि मत्‍ते, नना मीवद केंजालय अर्तम मनवड. ");
INSERT INTO esg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","गानि इद केस, पोल्‍लें, पोरोल्क आनि मीवा दर्मसास्‍त्रमता बारेमते मंता. अदुनहाटीं दीन मीवद मिमेटे नेमाहकुंटु. इसोंटा केसकुना न्‍यायम नना किय्योन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","इल्‍हा इंचि गल्‍लियाल ओर्कुन कोरटताल पलाते पेचाहतोर. ");
INSERT INTO esg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","पजा यहुदिल्क, दर्मसास्‍त्रम कराहना लोतुक अदिकारि मत्‍ता सोस्‍तिनेस पोरोलतोन पीसि, कोरटता मुन्‍नेने तंतुर. अय्नागानि गल्‍लियाल मात्रम जर्गनदाना बारेमते विचारम किया हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलुस वेल्‍लेन रोजकुनदाका अग्गेन कुरेंति सहरते मत्‍तोर. आयंका अगा मत्‍ता विस्‍वासुल्‍कुन होळसि, मोळ्‍ककुत्‍ता परकारम पौलुस किंकिरया सहर होंचि केल्क कोरियकुत्‍तोर. पजा ओनतोनि पिरिसकिला आनि अकविला ईरकुन पीकुंचि सिरिया एरियाक होनना डोंगाते उद्‍दिस इपीसि सहर होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","इल्‍हा ओर इपीसि सहरते एवतुर. पजा पौलुस पिरिसकिल्‍लन आनि अकविलान अग्गेन होळ्‍सतोर. ओर वरोरे दर्मसास्‍त्रम कराहना लोते होंचि यहुदिल्कुनतोनि चर्चा कियालय दल्‍गतोर. ");
INSERT INTO esg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","आयंका ओर अंटोर, ओन इंका इच्‍चुं रोजकु अग्गेन मननाहाटीं विनंति कीतुर गानि ओर, मनोन, इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","गानि अगटाल पेय्‍सका मुन्‍ने, “ओक्‍कला पेनदा मनसु मनानय्ते नना मिहगा मर्रा वांतन,” इंचि ओर इत्‍तोर. पजा इपीसिताल डोंगाते उद्‍दिस पेय्सतोर. ");
INSERT INTO esg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","पजा ओर कैसरिया सहरते एव्‍सि, अगटाल येरुसलेम सहर होत्‍तोर. अगा होंचि अगाटा कलिसियातोर्कुंक कलियसि जोहार कीतोर, पजा अगटाल अंताकिया सहर होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","अगा इच्‍चुं रोजकु मत्‍तारित्‍ते मर्रा ओर गलातिया आनि पुगरिया एरियाताल अंटोर सिस्युल्कुना विस्वासम गट्‍टिगा कीसेके तिरियतोर. ");
INSERT INTO esg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अच्‍चोटेन अप्‍पुलोस इनानोर वरोर यहुदि मनकल इपीसि सहरते वातोर. ओर सिकंदरिया इनना सहरते पुटतोर. ओर वेल्‍लेन तेल्वि मत्‍ता मनकल मत्‍तोर. ओन्क दर्मसास्‍त्रम पुरागा तेळियुंदु. ");
INSERT INTO esg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ओर सामि वेहता हर्दा बारेमते करियसि मत्‍तोर. ओर येसुना बारेमते कराहनेंके वेल्‍ले कुसिते बल्हा मत्‍तद अल्हेन बरोबर कराहुंदुर. गानि बापतिस्माता बारेमते अय्ते सिराप योहानुना बापतिस्माता बारेमतेन एरपाट मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","अय्ते ओर यहुदिल्कुना दर्मसास्‍त्रम कराहना लोते होंचि वेरियाकोंटा वळकालय सुरुव कीतोर. उंदि मल्का ओर वळ्कानेंके पिरिसकिला आनि अकविला ईर इव्वुर ओना पोल्‍लें केंजतुर. केंजसि ओन दग्गेर्क केयकुंचि ओन्क पेनदा हर्दा बारेमते इंका बेस तेळियागोट्‍सि वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","अय्ते अप्‍पुलोस अकाया इनना एरियाक होनना विचारम कीतोर. अस्‍के दादालोरगुडा ओन्क बेस दैरनेम हीतुर. अचोने आयका अकाया एरिया पीसि मनना सिस्युल्कुंक, ईन बेस दग्‍गेर कीकुंटु, इंचि उंदि सिट्‍टि रासतुर. ओर अगा एवतारित्‍ते, पेनदा कुर्पाहेंदाल विस्वासमते वाता लोकुल्‍कुंक वेल्‍ले सहायम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","बल्हा इत्‍ते, अंटोर लोकुल्‍कुना मुन्‍ने यहुदिल्कुनतोनि जिद्‍दुने चर्चा कियुंदुर. इंका दर्मसास्‍त्रमते, येसु सामिए किरिस्‍तु आंदुर, इंचि ओर्क हुपिच्‍चि दान रुजुव कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","अप्‍पुलोस कुरेंति सहरते मननेंके, पौलुस वेरे-वेरे नाहकु तिरियसेके इपीसि सहरते वातोर. अगा ओन्क इच्‍चुर सिस्युल्क कलियतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“मिमेट विस्वासमते वातस्के मीपोर्रो पवित्र आत्मा वाताना?” इंचि पौलुस ओर्कुन पूसकीतोर. अस्‍के, “मोमोट अय्ते पवित्र आत्मा मंता इंचिगुडा केंजा हिल्‍लोम,” इंचि आ सिस्युल्क इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","पजा, “अय्ते मरि मिमेट बोना बापतिस्मा एततिर?” इंचि पौलुस पूसकीतस्‍के, “योहानुना बापतिस्मा एततोम,” इंचि ओर वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","अस्‍के, “योहान अय्ते पापाल्कुनाल मनसु मार्सकुनना बारेमता बापतिस्मा हियुंदुर. इंका ओर लोकुल्‍कुंक, ओना पज्जोटाल वरोर वायानोर मंतोर, ओनपोर्रो, इत्‍ते येसुनपोर्रो विस्वासम कीम्‍टु, इंचि वेहुंदुर,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","इद केंजिस ओर येसु सामिना पोरोलते बापतिस्मा एततुर. ");
INSERT INTO esg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","पजा बस्के अय्ते पौलुस ओरापोर्रो कय इरतोरो अस्‍के ओर अंटोरपोर्रो पवित्र आत्मा रेयता. ओर वेरे-वेरे बासाने वळकालय, बविस्यवानि कियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ओर अंटोर कलियसि पन्‍नेंडु मंदि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","आयंका पौलुस मूड नेल्कुनदाका यहुदिल्कुना दर्मसास्‍त्रम कराहना लोते होनुंदुर. वेरियाकोंटा ओरतोनि चर्चा कीसि पेनदा राज्येमता बारेमते ओर्कु तेळियागोट्‍सि वेहुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","गानि ओरंटे इच्‍चुर जिद्‍दि मनकालोर मत्‍तुर. ओर विस्वासम किया हिल्‍लुर. अचोने आयका लोकुल्‍कुना मुन्‍ने पेन वेहता हर्दा बारेमते रोता-रोता पोल्‍लें वळ्कसेक मत्‍तुर. अदुनहाटीं पौलुस, सिस्युल्कुन ओना पज्जो केयकुत्‍तोर. आ लोकुल्‍कुन अग्गेन होळसि रोज तरन्‍नुसना मिटिंग बंगलाते होंचि चर्चा कियुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","रोंडु वर्सनदाका इल्हे ताकसेके मत्‍ताहाटीं आसिया एरिया पीसि मनना अंटोर यहुदि आनि युनानि लोकुल्‍क पेनदा पोल्‍लेतुन केंजतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","पौलुसना कयदाल पेन पेद्‍दा-पेद्‍दा अद्‍बूतामाता कबाह्‍क कीसेक मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","इंका लोकुल्‍क पौलुस इटता दस्तिगुड्‍डान, ओना सेल्‍लान रोगम मत्‍तोरगा ओते ओरा रोगाल्कंता होनुंदु, देय्याल्क इंका होळसि वित्‍तुंदुं. ");
INSERT INTO esg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","इच्‍चुर यहुदि लोकुल्‍क, सुट्‍टु-मट्‍टु एरियाने देय्याल्क पीसि मत्‍तोर्कुन मंत्राल्कुना बलमते बेस कीसेके तिरियुंदुर. इसकिवा इनना वरोर यहुदि पेद्‍दा पेर्मांक एडुर मर्कु मत्‍तुर. ओर इल्हे कियुंदुर. अय्ते उंदि मल्का ओर सामि येसुना पोरोल येत्‍सि, “पौलुस बोना बारेमते अय्ते वेहचंतोरो आ येसुना पोरोलते आदेस हीसंतन, पलाते पेय्‍सा” इंचि देय्याल्कुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","अस्‍के आ देय्यम, “येसु अय्ते नाकु एरके, इंका पौलुसगुडा नाकु एरके. मरि मिमेट बोर आंदिर?” इंचि ओर्कुन पूसकीता. ");
INSERT INTO esg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","पजा आ देय्यम पीसि मत्‍ता मनकल ओरापोर्रो अरसि, ओर्कुन इरगा तंतोर. अदुनहाटीं ओर इरगा देब्बां दल्‍गिसि नेत्‍तुर पोंगनेंकेन अद लोताल कपडिं केर्राकोंटेन पेय्सि विततुर. ");
INSERT INTO esg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","इद संगति इपीसिते मनना अंटोर यहुदिल्कुंक, युनानि लोकुल्‍कुंक तेळियता. अदुनहाटीं ओर अंटोर इरगा वेरियतुर. येसु सामिना पोरोलता कदर बेर्स्‍सेके होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","इल्‍हा बोर लोकुल्‍क अय्ते विस्वासुल्‍क आतुरो, ओर कीता तप्‍पुकुन अंटोरा मुन्‍ने ओप्‍कुनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","होदें-मंत्राल्कु कियानोर वेल्‍लेटुर लोकुल्‍क ओरा पुस्तकाल्क उंदगा जमा कीसि अवुन अंटोरा मुन्‍ने बोळस्तुर. पजा आ पुस्तकाल्कुना दरा लेक्‍का कीते एबै वेय्‍कुना (50,000) एंडि कोत्‍तानच्‍चोर मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इल्‍हा सामिना पोल्‍ले बेस मजबुत आसेके नालुं मूलां पैलांचेके होत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","इदंता जर्गुता पज्जो, पौलुस मेसिडोनिया, अकाया इनना एरियानाल येरुसलेम होनना पिलान पवित्र आत्माता सहायमतोनि कीतोर. अगा होत्‍ता पज्जो, बल्हा कीसि अयना रोम सहरतुन हूळापींता, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","दानहाटीं ओर तिमोति आनि इरास्‍तुस पोरोलता इव्वुर सेवाकुल्कुन मेसिडोनिया एरियाते लोहचीतोर. ओर कुद बारे इंका इच्‍चुं रोजकु आसिया एरियातेन आगतोर. ");
INSERT INTO esg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","अव रोजकुने पेन वेहता हर्दा बारेमते वेल्‍लेन लोल्‍लिं आतां. ");
INSERT INTO esg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","देमेत्रि पोरोलतोर वरोर कमसालोड मत्‍तोर. ओर अर्तेमि इनना पेनदा गुळितालेसींटव एंडिता गुळिं तयार कीसि अम्मुकुनुंदुर. दीनहेंदाल ओनगा कबळ कियानोर्क रिकम हिलाकोंटा कबळ दोर्कुंदु. ");
INSERT INTO esg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","आ कमसालोड, ओनगा कबळ कियानोर्कुन आनि ओनालेसीं कबळ कियाना इंका वेरेतोर्कुन अंटोर्कुन जमा कीसि ओर्कु इल्‍हा वेहतोर, “दादालोरिटा! मीकु अय्ते एरपाटे गदा, ई दंदाहेंदाल मनाकु बेस कोत्‍तां दोर्कंतां. ");
INSERT INTO esg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ई पौलुस इपीसि सहरता आनि दग्‍गेर-दग्‍गेरा पूरा आसिया एरियाता लोकुल्‍कुंक, ‘मनकल कीता पेनकु निजम पेनकु आयों,’ इंचि ओर्क एकरेवुल्क वेहसेक ओर्कुन बदलांचतोर. इद संगतितुन मिमेट हूळतिर आनि केंजतिर गुडा. ");
INSERT INTO esg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","दीनहेंदाल मना दंदाक मत्‍ता बेस पोरोल बदनाम आंता. मना पेद्‍दा पेन अर्तेमिना गुळिता इलवागुडा दांता. इचोने आयका सिराप आसिया एरियातेन आयो गानि पूरा दुनियाता अंटोर लोकुल्‍क मोळ्‍कनसोंटा ई पेनदुक मत्‍ता पेद्‍दातनमगुडा हिलाकोंटा आंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","इसोंटा पोल्‍लें केंजसि ओर इरगा होंगुंक वासि, “इपीसितोरा पेन अर्तेमि अन्‍नि पेनकुंकन्‍ना पेद्‍दा पेन आंद,” इंचि वरगेयालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","अदुनहाटीं सहरते लोल्‍लि आता. पजा लोकुल्‍क मेसिडोनिया एरियाताल वाता गयुस आनि अरिसतरकुस पोरोलतोर इव्वुर्कुन दोर्का पीतुर. ईर इव्वुरगुडा पौलुसुनतोनि कलियसि पय्‍नेम कियुंदुर. अय्ते लोकुल्‍क अंटोर उंदि आसि ओर्कुन पीसि नाटकम बंगलातगा जोरसे इग्गिसेक पीसि विततुर. ");
INSERT INTO esg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलुस लोकुल्‍कुना मुन्‍ने होनना इनकुत्‍तोर गानि सिस्युल्कु ओन होना हिया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसिया एरियाता इच्‍चुर अदिकारिल्‍क पौलुसना दंटातोर मत्‍तुर, ओरगुडा, “निमे नाटकम बंगलाते होंचि दोकाते अरमा,” इंचि कबुर लोहचि ओन्क विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","अस्‍के बोरो बतलो, बोरो बतलो इल्‍हा पेद्‍दा लोल्‍लि कियालय दल्‍गुतुर. वेल्‍ले मंदिक अय्ते ओर अगा बताहाटीं जमा आतुर अदगुडा एर्का हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","यहुदि लोकुल्‍क सिकंदर पोरोलतोन वरोर मनकन मंदिताल पेरसि मुन्‍ने निलाहतुर. सिकंदर कय ऊपसि-ऊपसि लोकुल्‍कुंक समजांचलय हूळतोर. ");
INSERT INTO esg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","गानि ओरगुडा वरोर यहुदि मनकल आंदुर इंचि तेळियतारित्‍ते ओर अंटोर रोंडु गंटानदाका उंदे आवाजते, “इपीसितोरा पेन अर्तेमि अन्‍नि पेनकुंकन्‍ना पेद्‍दा पेन आंद,” इंचि वरगेयसेके मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","अस्‍के सहरता अदिकारि मंदितुन सांत कीतोर. सांत कीसि, “अरे इपीसि लोकुरिटा, बेस पोरोल होत्‍ता अर्तेमि पेनदा गुळितुन आनि स्वर्गमताल अरता दाना पवित्र बंडा बोम्मातुन बेस कापाळना सहर इपीसि सहर आंद, इद पोल्‍ले दुनियाकंता एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","इद पोल्‍लेतुन बोरे हिल्‍ले इन्‍नोर. अदुनहाटीं मिमेट सांत मंटु, विचारम कियाकोंटा गाबर आसि बतले कियमट. ");
INSERT INTO esg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ईर मनकालोर अय्ते मना पेनदा गुळिताल बतले दोंगा किया हिल्‍लुर. मना पेनदा अपमानमगुडा किया हिल्‍लुर. अय्नागानि मिमेट ईरकुन इगे पीसि वातिर. ");
INSERT INTO esg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ओक्‍कला देमेत्रिसुंक आनि ओनतोनि कलियसि कबळ कियानोर्कुंक गिंटा बोरादन्‍ना विरोदमते बतलन्‍ना वेहनद मनानय्ते कोरटकुना तल्‍पुक कुल्‍ले मंतां, अगा ओर वरोनपोर्रो वरोर तप्पुक-दोसेल्क वेहकुना परांतुर. ओरां केंजालय अगा अदिकारिल्कगुडा मंतुर. ");
INSERT INTO esg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","अयना इंका बतलन्‍ना वेरेतदुन बारेमते वळकानद मनानय्ते दाना पय्सला मना पंचादिते किया वच्‍चु. ");
INSERT INTO esg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","इय्याला इगे बतल अय्ते जर्गतनो दीनद पूरा दोसेम मना तल्‍लापोर्रेन अर्रनलायक मंता. इद जर्गुता गटना बेसताहाटींगे जर्गुता इंचि रुजुव कियालयगुडा मनागा बतले हिल्‍ले.” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","इल्‍हा इत्‍ता पजा ओर पंचादि मारता इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","लोल्‍लिंअंता मगता पज्जो पौलुस सिस्युल्कुन केय्‍सि, ओर्क बेस प्रोत्‍साहन हीसि ओर्कुन होळसि मेसिडोनिया एरियाक होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","मेसिडोनिया एरियाताल होननेंके आ एरिया पीसि मनना विस्वासुल्कुंक प्रोत्‍साहन हियानसोंटव बच्‍चोनो पोल्‍लें ओर्क वेहासेके होत्‍तोर. पजा ओर अकाया एरियाते एवतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","अगा पौलुस मूड नेल्क मत्‍तोर. अगटाल डोंगाते उद्‍दिस सिरिया एरियाते होनना विचारम कीतोर, गानि अच्‍चोटेन यहुदि लोकुल्‍क ओन हव्काना पिलान कीसंतुर इंचि तेळियतस्के ओर मर्रा मेसिडोनिया एरियाक मल्सि होनना निरनायम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरिया सहरता पिरूस इनानोना मर्रि सोपत्रु, तेसलोनि सहरता अरिसतरकुस आनि सेकुंदल, दिरबे सहरताल गयुसु, आसिया एरियाताल तुकिकुस आनि तोरोपिमुस, इंका तिमोति. ईर अंटोर आसिया एरिया एवनाल पौलुसुनतोनि मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ईर अंटोर मुन्‍ने होंचि त्रोआस सहरते मावा एदुर हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","गानि मोमोट पिलिपिया सहरताल होयवा पिंडिता हारिना पंडगु होत्‍तारित्‍ते डोंगाते उदिस पेय्‍सतोम. त्रोआस सहरते ओर्कु होंचि कलियालय माकु हेय्युं रोजकु दल्‍गतां. अगा मोमोट एडुं रोजकु मत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","आयंका मोमोट वारमता मुन्‍नेटा रोजु हारि उरहालय उंदगा जमा आतस्के पौलुस लोकुल्‍कुनतोनि वळकालय दल्‍गुतोर. ओन्क इंकुंदि रोजु पय्‍नेम होनना मत्‍ताहाटीं ओर नळजाम नर्कादाका वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","मोमोट जमा आसि मत्‍ता पोर्रोटा अंतरम पोर्रो वेल्‍लेने वेडसिं मत्‍तां. ");
INSERT INTO esg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","अगा युतुकुस पोरोलतोर वरोर लेय्या पेडल किडकिते उद्‍दिस मत्‍तोर. पौलुस वेल्‍लेनजेम वळ्कसेक मननेंके ओन्क इरगा निद्रा वासि मूडोव अंतरमताल डोलसि हिळु अरतोर, ओनगा होंचि तेहतारित्‍ते ओर हासि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पौलुस हिळु रेय्‍सि ओन रोमबोच्‍चेक अदमुकुंचि, “वेरियमटु, इंदके ओनालोप्‍पो जीवा मंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","आयंका पौलुस पोर्रो होत्‍तोर. हारिना तुकडां कीसि तिंचि पंगायनदाका ओरतोनि वळ्कसेक मत्‍तोर. पजा अगटाल पेय्सि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","लोकुल्‍क आ लेय्या पेडन जीवाते ओना लोन ओतुर, अदुनहाटीं ओर्कु बच्‍चोरो बेस अनपिस्ता. ");
INSERT INTO esg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","मोमोट पौलुसुन अग्गेन होळसि डोंगाते उदसि मुन्‍नेन अस्सुस सहरतेके होत्‍तोम. पौलुस कुद अस्सुसदाका ताकसि वासि अगा माकु कलियंतन इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ओर अस्सुस सहरते माकु कलियतस्‍के, ओन डोंगाते एकिच्‍कुंचि मोमोट मितुलेन सहरते होत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","अगटाल पेय्सि इंकुंदि रोजु मोमोट, कियुस इनना दीबेता मुन्‍नेळ्‍क एवतोम. मर्रा इंकुंदि रोजु सामोस इनना दीबेतुन दाटसि होत्‍तोम. मर्रा इंकुंदि रोजु आतारित्‍ते मोमोट मिलेतुस इनना सहरते एवतोम. ");
INSERT INTO esg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","बल्हा कीसन्‍ना गानि पेंतेकोस्‍त पंडुगुंक येरुसलेम सहरते मनगोम इंचि पौलुस गाबर आसेक मत्‍तोर. अदुनहाटीं आसिया एरियाते वेल्‍ले रोजकु आगिसि वेला बरबाद कियमळ इस्‍टम हिलाका, इपीसिते आगाकोंटा मुन्‍नेळ्‍क पेय्सि होनना विचारम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","पौलुस इपीसि सहरता कलिसिया पेद्‍दाल्कुंक कबुर लोहचि ओर्कुन मिलेतुस सहरते ओनगा केयतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ओर अंटोर वातारित्‍ते पौलुस ओरतोनि इल्‍हा वळकालय दल्‍गतोर. “नना आसिया एरियाते वातस्के, मोदाटा रोजुनाल मीवातोनि उंदि-उंदि निमसम बल्हा मत्‍तन, इद मीकु एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","यहुदिल्कुनाहेंदाल नाकु बच्‍चोनो कस्‍टाल्‍क वातां. अयना, नना मनसुनाल गरिब आसि अळसेके सामिना सेवा कीतन. ");
INSERT INTO esg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","मीवा बेसताहाटीं अवसरम मत्‍ता बदे पोल्‍ले आयि वेहालय नना बस्‍केने पजोळ्क आया हिल्‍लेन. नना अव पोल्‍लें अंटोर लोकुल्‍कुना नड्‍डुम, लोन-लोन होंचि वेरियाकोंटा कराहतन, इद संगति मीकु एर्के मंता. ");
INSERT INTO esg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","पापाल्कुनाल मनसु मार्सकुंचि पेनदाहाटीं पिस्‍सट, अल्‍हेने मना येसु सामिना पोर्रो विस्वासम कीम्‍टु इंचि नना यहुदिल्कुंक, युनानि लोकुल्‍कुंक गवाइ हीसि वेहुंदुन. ");
INSERT INTO esg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","इंदके पवित्र आत्मा वेहताप कियना इंचि नना येरुसलेम सहर होंचंतन. गानि अगा होत्‍तारित्‍ते नावद बतल आंतो नाकु एर्का हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","उंदि पोल्‍ले मात्रम नाकु एरपाट मंता. अद बतल इत्‍ते, अन्‍नि सहरकुने जेल, कस्‍टाल्‍क नावाहाटीं एदुर हूळसंतां इंचि पवित्र आत्मा नाकु वेहासेक मंता. ");
INSERT INTO esg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","नाकु नावा जीवाता पिकिर हिल्‍ले. नना अय्ते सिराप येसु सामिनहेंदाल नाकु दोर्कुता आ पंदेमतुन, सेवातुन पूरा कींतन. अद बतल इत्‍ते, पेनदा कुर्पाता बारेमते बेसता पोल्‍लेना गवाइ वेहामळ आंद.” ");
INSERT INTO esg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","नना मी अंटोरतोनि कलियसि मंचि मीकु पेनदा राज्येमता बारेमते कराहसेक तिरियतन. मीवाव्टेटाल बोरेगुडा नाकुन मर्रा बस्‍केने हूळा पर्रिर इंचि नाकु एर्के. ");
INSERT INTO esg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","दानहाटीं इय्याला नना वेहासेक मंतन गदा, मीवा लोप्पोटाल बोरन्‍ना आयिर, हासोत्‍ते दान्क जबाबदारी नना आयोन. ");
INSERT INTO esg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","बारित्‍ते नना पेनदा पूरा इच्‍चातुन मीकु वेहालय बस्‍केने पजोळ्क होना हिल्‍लेन. ");
INSERT INTO esg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","पवित्र आत्मा मीकुन मीवा कलिसियातोरपोर्रो कोहानोन-मेहानोन लेह्का पेर्कुत्‍ता. अद मंदातुन पेन कुद्‍दु दाना मर्रिना नेत्‍तुर हीसि असकुत्‍ता. अदुनहाटीं मीवद मिमेट अल्‍हेने मीवा जिम्मेदारिते मनना मंदातुनगुडा मिमेट बेस कापाळसेके मंटु. ");
INSERT INTO esg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","नना होत्‍तारित्‍ते कतरनाक तोडेल्‍लिनसंटा मनकालोर मीवा नड्‍डुम वासि मीकु नुकसान कींतुर इद नाकु एरपाट मंता. ");
INSERT INTO esg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","अचोने आयका मीवा लोप्पोटाले इच्‍चुर इसंटा मनकालोर पेय्संतुर गदा, ओर सिस्युल्कुन ओरा पज्जो इग्गुकुनालय आबद्‍दम पोल्‍लें वळकांतुर. ");
INSERT INTO esg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","अदुनहाटींगे मिमेट हुसारते मंटु. मूड वर्सनदाका वरो-वरोंकु, नर्का-पियल अळसि-अळसि जेगर्ता मननाहाटीं वेहमळते नना बस्‍केने पजोळ्क होना हिल्‍लेन इद मति इर्रट. ");
INSERT INTO esg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","इंदके नना मीकुन पेनदा कय्‍दे आनि दाना कुर्पाता कबुरता कय्‍दे अप्‍पजेपंतन. मीकुन बेस बेरसागोटना ताकत अद कबुरते मंता. पेन पवित्र कीता अंटोर लोकुल्‍कुना लोप्पो मीकुनगुडा वारसदार किया पर्रंता. ");
INSERT INTO esg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","नना बस्‍केने बोनहेंदाले एंडि-बंगारम हिलाकोंटे बेसता कपडि गावाले इंचि आसे पडा हिल्‍लेन. ");
INSERT INTO esg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","नना नावा कय्‍कुनतोने कबळ कीसि नावा अवसराल्कु आनि नातोनि मत्‍ता नावा दंटागाह्कुना अवसराल्कु तीरस्‍ता संगति मीकु कुद एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","वेल्‍लेन कस्‍टम कीसेके नादान मत्‍तोर्कुंक मनम बल्हा सहायम कियगोम इत्‍ता संगतितुन नना मीकु नावा हरेक कबळताल कीसि हुपिस्तन. “एतकुनुळकन्‍ना हियमळतेन एक्‍को सुकम मंता,” इंचि कुद्‍दु येसु सामि इत्‍ता पोल्‍लेतुन मतिते इरमळ बच्‍चोनो अवसरम मंता, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","इल्‍हा इंचि ओर टोंगरां ऊनसि, अंटोरतोनि कलियसि पारतना कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","अस्‍के ओर अंटोर इरगा अळसेके बेस पावरमतोनि पौलुसुंक कलियसि ओन बुरतुर. ");
INSERT INTO esg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","मिमेट मर्रा ना मोकम बस्‍केने हूळा पर्रिर, इंचि पौलुस इत्‍ता पोल्‍लेताहेंदाल ओर अंटोर लोकुल्‍कुंक बागा दुक्‍कम वाता. पजा ओर अंटोर, ओन डोंगादाका सार्ला कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ओर माकुन सार्ला कीतस्‍के मोमोट डोंगा उदसि सवरगा कोस इनना दीबेक होत्‍तोम. अगटाल इंकुंदि रोजु रुदास इनना दीबेक आनि अगटाल पतरा इनना सहर होत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","अगा माकु पिनिके इनना एरियाक होनानद उंदि डोंगा दोर्कता अय्ते मोमोट अंटे उदसि पेय्‍सतोम. ");
INSERT INTO esg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","4","बस्के अय्ते माकु साइप्रस दीबे दिसालय दल्‍गता अस्‍के मोमोट दान मावा डेमा बाजुंक होळसि सिरिया एरियाहेके तिरियतोम. सूर सहर सिरिया एरियाते मत्‍ताहेंका डोंगाते मत्‍ता माल सूर सहरते रेहानद मत्‍ता. पजा मोमोटगुडा अग्गेन रेयतोम. अगा माकु सिस्युल्क कलियतुर अय्ते ओरतोनि मोमोट एडुं रोजकुनदाका आगतोम. ओर पवित्र आत्माहेंदाल, निमे येरुसलेम होनमा, इंचि पौलुसुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","वारम आता पज्जो अगटाल मोमोट मावा पय्‍नेम पेय्‍सतोम. अगाटा विस्वासुल्‍क ओरा मुत्‍तोह्‍क, पिलाल्क अंटोर सहरता पलाते समुद्रम ओड्‍डुनदाका मातोनि वातुर. अगा मोमोट टोंगरां ऊनसि पारतना कीतोम. ");
INSERT INTO esg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ओर माकुन सार्ला कीतंका मोमोट डोंगा एकतोम, ओर ओरा लोहकुने वापस होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सूर सहरताल डोंगाते उदसि पय्‍नेम कीसेके मोमोट पोलेमा इनना सहरते वासि रेयतोम. अगाटा विस्वासुल्कुंक कलियसि ओरतोनि मोमोट उंदि रोज मत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","इंकुंदि रोजु मोमोट अगटाल पेय्सि कैसरिया सहर होत्‍तोम. अगा होंचि मोमोट, पिलिपुस पोरोलता पेनदा सेवाकुना लोन आगतोम. ई पिलिपुस येरुसलेम सहरते गाटो पंचि दोसनाहाटीं पेरता एडुर लोप्पोटाल वरोर मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ओन्क नालुं मरमिं आयवा मियाह्क मत्‍तां. अय्ते अव नालुंगुडा बविस्यवानि वेहुंदुं. ");
INSERT INTO esg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","मोमोट अगा कोन्‍नि रोजकु आगसि मत्‍तोम, अस्‍के यहुदिया एरियाताल वरोर पेनदा कबुरतोर वातोर ओन पोरोल अगबुस. ");
INSERT INTO esg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ओर मावा दग्गेर्क वासि पौलुसना नडिता पट्‍टा तेंडकुंचि, ओना कय्‍कु-काल्‍कुन दोहकुंचि, “इद पट्‍टा बोनद अय्ते आंदो ओन येरुसलेम सहरते यहुदि लोकुल्‍क इल्हेन दोहाचि वेरे जातितोर्कुंक अप्पजेपंतुर, इंचि पवित्र आत्मा वेहासेक मंता,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","इद केंजतारित्‍ते मोमोट आनि अगटा लोकुल्‍क, निमे येरुसलेम सहर होनमा, इंचि विनंति कीतोम. ");
INSERT INTO esg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","अस्‍के, “इल्‍हा अळसि-अळसि नावा मनसुन कमजोर बारि कीसंतिर? नना येरुसलेम सहरते सिराप दोहांतुर इंचि आयो गानि, येसु सामिना पोरोलहाटीं हायालयगुडा तयार मंतन,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","मोमोट बच्‍चोन वेहिनागानि ओर केंजवाहेंका, पेनदा इच्‍चा मत्‍ताप जर्गिकांटी, इंचि मोमोट सपुडदाका आतोम. ");
INSERT INTO esg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","इल्‍हा कोन्‍नि रोजकुन पजा मोमोट मावा तयारिं कीसि येरुसलेम सहर होत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","मावातोनि कैसरिया सहरतोर इच्‍चुर सिस्युल्क इंका वातुर. ओर माकुन साइप्रस दीबेतोर वरोर मनकल मनासोनना लोन ओतुर. मोदोलता विस्वासुल्‍कुनाल ओर वरोर सिस्युड आंदुर. माकु ओनागेन आगनद मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","मोमोट येरुसलेम सहर एवतस्‍के अगाटा विस्वासुल्‍क वेल्‍लेन आनंदमते माकुन कल्‍पुकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","इंकुंदि रोजु पौलुस माकुन अंटोर्कुन पीसि याकोबुंकु कलियालय होत्‍तोर. अगा येरुसलेम सहरतोर अंटोर विस्वासि पेद्‍दाल्क मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","मोदाला पौलुस ओर्क अंटोर्क जोहार कीतोर. पजा पेन ओन दाना सेवाते वाळकुंचि यहुदि आयवोरा लोप्पो बता-बता कबाह्‍क कीता, अव उंदि-उंदि कबळता बारेमते ओर्क वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","पौलुस वेहतद केंजसि पेद्‍दाल्क अंटोर पेनदा स्‍तुति कीतुर. पजा पौलुसुन, “दादा, बच्‍चोनो वेय्‍कुना मंदि यहुदिल्कु इगे विस्वासुल्‍क आतुर इत्‍ता संगति निमे हूळसेकेन मंतिन. ओर अंटोर मूसाना नियमतुन बेस पीसि ताकसेक मंतुर. ");
INSERT INTO esg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","गानि, मूसाना नियमतुन पीसि ताकमट, मर्कुनद कतना कियमट इंका यहुदिल्कुना रीति-रिवाजकुन होळसीम्टु इंचि वेरे जातितोरा नड्‍डुम मनना यहुदिल्कुंक निमे कराहतिन इंचि बोरो इग्‍गे वेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","अय्ते इंदके बतल कीकोम मरि? निमे इगे वातिन इत्‍ता संगति ओर्कु बल्हैना तेळियंते. ");
INSERT INTO esg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","अदुनहाटीं निमे मोमोट वेहताप कीम. महगा मोक्‍कु मोळ्‍ककुत्‍तोर नालुर मनकालोर मंतुर. ");
INSERT INTO esg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","निमे ईरकुन नीतोनि ओम. ओरतोनि कलियसि नीवदगुडा सुद्‍दिकरन कीकुन. अचोने आयका ओरा तल्‍ला कोरियनाहाटीं कर्सुंक कोत्‍तां इंका निमेने हीम. इल्‍हा कीतिन इत्‍ते नीवा बारेमते केंजतद अंता वट्‍टि आबद्‍दमे. इंका निमे मूसाना नियम परकारमे ताकसंतिन इंचि ओर्कु तेळियसि दांता. ");
INSERT INTO esg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","मोमोट अय्ते वेरे जातिता विस्वासुल्कुंक दीनकन्‍ना मुन्‍नेन उंदि सिट्‍टि रासि अव्टे, बोम्मांक मोळ्‍कतदुन तिनमट, गोंदके पिसकिसि हव्‍कता जिवरासिना हव्‍विं, नेत्‍तुर तिनमट, बोगमतनमताल लक्‍कु मंटु, इल्‍हा रासि लोहतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","इल्‍हा पौलुस आ नालुर्कुन पीसि इंकुंदि रोजु ओरतोनि कलियसि ओरगुडा सुद्‍दिकरन कीकुत्‍तोर. पजा अगटाल येरुसलेमता गुळिते होंचि, पुरागा सुद्‍दिकरन आयगोम इत्‍ते बच्‍चुं रोजकु एदुर हूळसेक मनापींतनो अदुन बारेमते पेर्मालोर्कुंक वेहतोर. अचोने आयका आकिरता रोजकुने ओनतोनि वाता हरेक मनकंक ओना सतताहेंदाल मोक्‍कु हियापींता इंचिगुडा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","एडुं रोजकु पूरा आयानवे मत्‍तां, आसिया एरियाताल वाता इच्‍चुर यहुदिल्क पौलुसुन गुळिते हूळतुर. ओर अंटोर लोकुल्‍कुंक पौलुसना बारेमते एकरेवुल्क वेहचि ओन पीतुर. पजा वरगेयसि, “इस्राएलता लोकुरिटा, मिमेट अंटोर माकु सहायम कीम्‍टु. ईर मनकल अन्‍नि एरियाने तिरियसि मना इस्राएलता लोकुल्‍कुना विरोदमते, मूसाना नियमता विरोदमते आनि ई गुळिता विरोदमते लोकुल्‍कुंक कराहसेक मंतोर. अचोने आयका इंदके युनानि लोकुल्‍कुन गुळिते केय्‍सि तच्‍चि पवित्रामाता गुळितुनगुडा हेळाहतोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(तोरोपिमुस पोरोलतोर वरोर इपीसिता मनकन पौलुसुनतोनि तिरियनेंके लोकुल्‍क हूळसि मत्‍तुर, ओने पौलुस गुळिते तत्‍तोर बारे इनकुत्‍तुर.) ");
INSERT INTO esg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","अस्‍के पूरा सहरअंता गजबज आता. लोकुल्‍क अंटोर विच्‍चि वासि उंदगा जमा आतुर. पौलुसुन दोर्कापीसि गुळिताल पलाते इग्‍गिस ओसि, बिराना तल्‍पुक वाटतुर. ");
INSERT INTO esg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","लोकुल्‍क ओन हव्कना विचारम कीसेक मननेंकेन रोमि पोलिस दलमता सिपाइल्कुना अदिकारिंक, पूरा येरुसलेम सहरते लोल्‍लि आता इंचि कबुर तेळियता. ");
INSERT INTO esg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","अस्‍के ओर बिराना इच्‍चुर सिपाइल्कुन आनि दरोगालोर्कुन पीसि पौलुसुन तनना यहुदिल्कुनहेके पेय्सतोर. सिपाइल्कुना अदिकारि, सिपाइल्कुन हूळतारित्‍ते यहुदिल्क पौलुसुन तनमळ आपतुर. ");
INSERT INTO esg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","पजा आ सिपाइल्कुना अदिकारि पौलुसनगा होंचि ओन पीसि गोल्सुकुने दोहनाहाटीं आदेस हीतोर. आयंका ओर लोकुल्‍कुन, ईर बोर आंदुर, ईर बतल कीतोर? इल्‍हा पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","अस्‍के इच्‍चुर लोकुल्‍क उंदितीर, इंकिच्‍चुर लोकुल्‍क इंकुंदि तीर वेहालय आतुर. इल्‍हा वेल्‍लेन लोल्‍लि आसि निजम बतल ओन्क तेळिया पराहिल्‍ले. अदुनहाटीं ओर पौलुसुन किल्‍लाते ओयालय आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","पौलुस पायरिनगळ्‍क एवतस्‍के वेल्‍लेन मंदि लोकुल्‍क, “ओन हव्कट, ओन हव्कट,” इंचेके उंदेतीर मोत्‍कुंचेके इरगा लोल्‍लि कियालय दल्‍गुतुर. अदुनहाटीं सिपाइल्कुंक ओन ओरा बुजाल्कुन पोर्रो तेहकुंचि किल्‍लाता लोप्पो ओया पीता. ");
INSERT INTO esg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","सिपाइल्क पौलुसुन किल्‍लाता लोप्पो ओयका मुन्‍ने, “नना नीतोनि बतलन्‍ना वळका पर्रांतना?” इंचि पौलुस सिपाइल्कुना अदिकारिन पूसकीतोर. अस्‍के आ सिपाइल्कुना अदिकारि, “अब्‍बा! नीकु युनानि बासागुडा वळका वांताना? ");
INSERT INTO esg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","अय्ते मरि कोन्‍नि रोजकु मुन्‍ने रोम सरकारुंक विरोद कीसि, नालुं वेय्‍कुना आतंकवादिर्कुन बय्‍लि जेगाते केय्‍सि ओता इजिप्‍त देसेमता मनकन निमेन गदा?” इंचि पौलुसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","अस्‍के, “नना किलिकिया एरियाता उंदि बेस पोरोल होत्‍ता तरसुस सहरता यहुदि मनकन आंदुन. नना नीकु विनंति कींतन, ई लोकुल्‍कुनतोनि नाकुन वळका हीम,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","सिपाइल्कुना अदिकारिनहेंदाल वळकाना अदिकारम दोर्कतस्के पौलुस पायरिनपोर्रो नित्‍तिसि लोकुल्‍कुंक कय हुपिच्‍चि सपुडदाका मनालय सय्गे कीतोर. लोकुल्‍क सपुडदाका आतास्के पौलुस इब्रानि बासाते वेहालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“दादालोरिटा आनि पेद्‍दाल्कुनिटा, नाकु मीवा मुन्‍ने इच्‍चुर वळ्‍कानद मंता अदुन केंजट.” इंचि पौलुस वळकालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ओर इब्रानि बासाते वळकानदुन केंजसि लोकुल्‍क इंका इच्‍चो सपुडदाका आतुर. ");
INSERT INTO esg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“नना यहुदि मनकन आंदुन. नना किलिकिया एरियाता तरसुस सहरते पुटतन. इदे येरुसलेम सहरते बेर्सतन. इंका गमलियेल इनानोना कय्‍दा हिळु मंचेके ओनहेंदाल बेस सदवु करियतन. अचोने आयका मना पेद्‍दाल्कुना नियम्‍क, रीति-रिवाज्‍क मत्‍ताप बेस टेरनिंग दोर्कुता. मिमेट बल्हा अय्ते इय्याला पेनदाहाटीं मीवा बक्‍तितुन हुपिच्‍चंतिरो, अल्हेन ननागुडा हप्‍सुंदुन. ");
INSERT INTO esg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","नना पेनदा हर्रि पीसि ताकाना लोकुल्‍कुन बच्‍चोनो तकलिप कीतन, दीनहेंदाल इच्‍चुर लोकुल्‍कुना जीवां इंका होत्‍तां. मुरतळ-मांडसा इनाकोंटा अंटोर्कुन पीसि जेलने वाटुंदुन. ");
INSERT INTO esg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","पेद्‍दा पेर्माल आनि अंटोर यहुदि पेद्‍दाल्क नावा ई कबळहाटीं गवाइ मंतुर. अचोने आयका दमिस्‍क सहरते मनना यहुदि दादालोर्कुंक सिट्‍टिं रासि दमिस्‍क सहर होनालय पेय्सतन. अगा होंचि पेनदा हर्रि पीसि ताकानोर्कुन दोर्कापीसि येरुसलेमते तच्‍चि, ओर्कु सिक्‍सा आयगोम. इदे नावा उद्‍देसम मत्‍ता.” ");
INSERT INTO esg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","इल्‍हा नना दमिस्‍क सहर होनालय पेय्सतन. नना दमिस्‍क सहर दग्गेर्क एवतन बारे! अस्‍के पियल वेलाक मब्बुनाल उंदेदम उंदि पेद्‍दा वेलगु नावा सुट्‍टु जग्गरा मेर्सता. ");
INSERT INTO esg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","नना अल्हेन बूमिपोर्रो हिळु अरतन. अस्‍के उंदि अल्किर, “साऊल, साऊल! निमे नाकुन बारि तकलिप कीसंतिन?” इंचेके नाकुन इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","अस्‍के, निमे बोन आंदिन सामि? इंचि नना पूसकीतस्‍के, “निमे बोन अय्ते तकलिप कीसंतिनो आ नासरेत नाटेना येसुन आंदुन,” इंचि आ अल्किर इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","नावातोनि मत्‍तुर ओर अद वेलगुन हूळतुर गानि नावातोनि वळकता अल्किर मात्रम ओर्क केंजा वाया हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","पजा, अय्ते नना बतल कीकन सामि? इंचि पूसकीतस्‍के, “निमे तेदसि दमिस्‍क सहरते होन. बव कबाह्‍क अय्ते कियालय नना नीकुन पेरकुत्‍तनो अव कबाह्‍क अगा नीकु वेहमळ जर्गंता.” इंचि सामि नाकु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","आ जग्गरा वेल्‍गुन हूळसि नावा कळकु दिस्‍साकोंटा आतां. अदुनहाटीं नावा दंटातुर नाकुन कय पीसि दमिस्‍क सहरते ओतुर. ");
INSERT INTO esg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","अगा हनन्‍याल पोरोलतोर वरोर मनकल मत्‍तोर. ओर मूसाना नियम परकारम ताकुंदुर. अगाटा अंटोर यहुदिल्क इंका ओन बेस मनकल इनुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ओर नाहेके वासि, नावा दग्‍गेरा नित्‍तिसि, “साऊल दादा! नीवा कळकु मर्रा दिस्सींकांटी,” इंचि इत्‍तोर. ओर अल्हा इत्‍ता इन्‍मळे नावा कळकु दिसालय दल्‍गतां. नना ओन हूळतन. ");
INSERT INTO esg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","पजा ओर नाकुन, “मना एनकटा पेद्‍दाल्कुना पेन दाना इच्‍चातुन एरपाट कियालय, नीतिमंतुड आता दाना सेवकुन हूळालय, ओना तोळ्‍दा पोल्‍लेन केंजालय नीकुन पेर्कुत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","निमे बतल अय्ते हूळतिन, बतल अय्ते केंजतिन अदुना बारेमते दानाहेंदाल अंटोर लोकुल्‍कुना मुन्‍ने गवाइदार आंतिन. ");
INSERT INTO esg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","अय्ते इंदके आलसेम बारि कीसंतिन? तेदसि बापतिस्मा एतसि, सामिना पोरोलते पारतना कीम, अस्‍के ओर नीवा पापाल्कुन नोर्रांतोर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","आयंका नना येरुसलेम तिरियसि वासि गुळिते पारतना कीसेके मत्‍तन, अस्‍के अल्हेन दर्सनम हूळतन. ");
INSERT INTO esg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","दर्सनमते मननेंकेन नना सामिन हूळतन, अस्‍के, “बिराना तेदसि येरुसलेम सहरताल पेय्सि होन, नावा बारेमते निमे वेहाना गवाइतुन ओर ओप्‍कुन्‍नुर,” इंचि सामि नाकु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","अस्‍के नना इत्‍तन. “सामि! यहुदिल्कुना दर्मसास्‍त्रम कराहना हरेक लोते होंचि नीपोर्रो विस्वासम कियानोर्कुन दोर्कापीसि ओर्कुन जेलने वाटता संगति आनि तंता संगति आ लोकुल्‍कुंक बेस एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","अचोने आयका नीवा गवाइदार स्‍टिपनुन हव्कानेंके, हव्कानंटे नावदगुडा कय मत्‍ता, इंचि हुपिच्‍चेक, ओन हव्कानोरा कपडिना कावेल कीसेक नना अग्गेन नित्‍तिसि मत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","अस्‍के सामि नाकुन, निमे होन, नना नीकुन वेल्‍लेन लक्‍कु वेरे जातितोरा लोप्पो लोहंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","इद पोल्‍ले वेहनदाका यहुदि लोकुल्‍क पौलुसना बासन केंजतुर, पजा जोरसे वरगेयसि, “ई मनकल जीवाते मनमळ बेस आयो. इसंटा मनकन ई बूमिपोर्रोटाल हिलाकोंटा कीम्‍टु,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ओर जोर-जोरसे वरगेयसेक मत्‍तुर, अंगिपोर्रो केर्ता कोटकुन तेंडसि विसिरसेके मत्‍तुर, इंका मब्बुनहेके दुब्बा तेहासेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","अस्‍के सिपाइल्कुना अदिकारि पौलुसुन किल्‍लाते ओयानाहाटीं आदेस हीतोर. “लोकुल्‍क ओना विरोदमते इल्‍हा बारिंक वरगेयसंतुर, कारनम बतल आंद तेळियनाहाटीं, ओन पोट्‍टे देब्बां तंचि-तंचि पूस कीम्‍टु,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","गानि बस्के अय्ते पौलुसुन पोट्‍टे देब्बां तनालय दोहचेके मत्‍तास्‍के, “तप्पु कीतोर इंचि निरनायम पेय्‍सका मुन्‍नेन वरोन रोम रहिवासिन पोट्‍टे देब्बां तनमळ मीवाहाटीं न्‍यायामेना?” इंचि अगा नित्‍तिसि मत्‍ता वरोर दरोगान पौलुस पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","अल्हा इत्‍तद केंजसि आ दरोगाल सिपाइल्कुना अदिकारिनगा होंचि, “मिमेट इद बतल कीसंतिर? ईर रोम रहिवासि अले,” इंचि ओन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","अस्‍के आ सिपाइल्कुना अदिकारि पौलुसनगा वासि, “नाकु वेहा, निमे रोम रहिवासिन आंदिना?” इंचि पूसकीतस्‍के, “आ” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","पजा, “नना रोम रहिवासि आयानाहाटीं वेल्‍लेन कोत्‍तां कर्स कीतन,” इंचि आ सिपाइल्कुना अदिकारि इत्‍तस्के, “नना अय्ते पुट्तस्केटाले रोम रहिवासिन आंदुन,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","पजा ओन पूसकियालय हूळसेक मत्‍ता सिपाइल्क बिराना पजोळ्क आतुर आनि सिपाइल्कुना अदिकारिगुडा, रोम देसेमता वरोन रहिवासिन दोहाचि वाटतोम, इंचि वेल्‍ले वेरियकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","यहुदि लोकुल्‍क पौलुसुनपोर्रो बारि दोसेम दोस्तुर. निजम बतलो पलाते अरगोम इंचि सिपाइल्कुना अदिकारिना मनसुने मत्‍ता. अदुनहाटीं सिपाइल्कुना अदिकारि इंकुंदि रोजु, पेद्‍दा पेर्मालोर्कुन आनि यहुदिल्कुना पेद्‍दा पंचादितोर्कुन जमा आयालय आदेस हीतोर. अंटोर जमा आतास्के पौलुसुन पेचाहचि ओरा मुन्‍ने तच्‍चि निलाहतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुस पेद्‍दा पंचादितगा जमातोर्कुन उंदेतीर हूळसि, “नावा दादालुरिटा! नना, इय्यालादाका पेनदा मुन्‍ने बेसता मनसुने पिसतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","अस्‍के हनन्‍याल इनना पेद्‍दा पेर्माल, “ओना तोड्‍डि पोर्रो तन्‍नाटु,” इंचि पौलुसुना पक्‍काते नित्‍तिसि मत्‍तोर्कुंक आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","अस्‍के पौलुस ओन, “ए चुना होकता गुरेतसंटोना! पेन नीकुन तनंता. बारित्‍ते, निमे दर्मसास्‍त्रमता नियम मत्‍ताप नावा न्‍यायम कियालय उदतिन, गानि दानकु अड्‍डम नाकुन तनालय आदेस बल्हा हीतिन?” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","अस्‍के पक्‍काते नित्‍तिसि मत्‍तुर, “निमे पेनदा पेद्‍दा पेर्माना अपमानम कीसंतिना?” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","“दादालुरिटा, ईर पेद्‍दा पेर्माल आंदुर इंचि नाकु एरपाट मनाहिल्‍ले. बारित्‍ते, ‘नीवा अदिकारिनाहाटीं सेड्‍डा पोल्‍ले वळका मन्‍नि,’ इंचि नियमते रासि मंता,” इल्‍हा पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","अगा यहुदिल्कुना पंचादिते उद्‍दिसि मत्‍ता लोकुल्‍कुने इच्‍चुर सदुकिर आनि इच्‍चुर परिसिल्कु मंतुर इंचि पौलुसुंक तेळियतस्के, ओरा मुन्‍ने जोरसे वरगेय्‍सि, “दादालोरिटा! नना परिसिन आंदुन. नावा तादल-बाबोगुडा परिसिल्कु आंदुर. हातोर मर्रा जीवाते तेदांतुर इत्‍ता ओरा आसेतुन नना विस्वासम कीताहाटीं मीवा मुन्‍ने निल्‍सि मंतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ओर इल्‍हा इत्‍तारित्‍ते परिसिल्कु आनि सदुकिर लोप्पो लोल्‍लि आसि, ओर अलग-अलग आतुर. ");
INSERT INTO esg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","बारित्‍ते, हातुर मर्रा जीवाते तेदुर, पेनदा दूतां हिल्‍लें, आत्मां हिल्‍लें इल्‍हा सदुकिर इंतुर. गानि परिसिल्कु बारे इव अन्‍नि मंतां इंचि इंतुर. ");
INSERT INTO esg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","अगा वेल्‍ले लोल्‍लिं आतां. अगा उद्‍दिस मत्‍ता परिसि दर्मसास्‍त्रम कराहना गुरुल्कुनाल इच्‍चुर तेदिसि, “माकु ईना लोप्पो बतल तप्पु दिस्सेक हिल्‍ले. ईनतोनि बदाना आत्मा हिलाकोंटे बदाना पेनदा दूता वळकिस मंदार,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","इल्‍हा ओरा लोप्पो इच्‍चोर लोल्‍लिं आतां गदा, पौलुसुन हव्कानुर बारे इंचि सिपाइल्कुना अदिकारि वेरियतोर. पजा, “पौलुसुन ओरागटाल अलग कीसि किल्‍लाते पीसि ओम्ट,” इंचि सिपाइल्कुंक आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","अदे नर्का सामि पौलुसनगा वासि, “पौलुस निमे वेरियमा. बल्हा निमे येरुसलेमते नावा गवाइ हीतिन, अल्‍हेने रोम सहरते इंका नीकु नावा गवाइ हियनद मंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","इंकुंदि रोजु हक्‍केरे पौलुसुन हव्कालय यहुदिल्कु पिलान कीसि, ओन हव्कवा मोमोट तिन्‍नोम-उन्‍नोम, इंचि ओट्‍टु तित्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","इल्‍हा पिलान कीतोरु नल्‍पै मंदिकन्‍ना एक्‍को मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ओर पेद्‍दा पेर्मालोर्कुनगा आनि यहुदि पेद्‍दाल्कुनगा होंचि, “मोमोट बच्‍चोरदाका पौलुसुन हव्‍कोम, अच्‍चोरदाका मोमोट बतले तिन्‍नोम-उन्‍नोम इंचि गट्‍टिगा ओट्‍टु तित्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","अदुनहाटीं इंदके मिमेट आनि यहुदिल्कुना पेद्‍दा पंचादितोर कलियसि सिपाइल्कुना अदिकारिनगा होंटु. अगा होंचि, पौलुसुन, इंका बेस पूसकियानद मंता, ओन महगा लोहचीम, इंचि तेडियागोटसि वेहाट. ओर मिहगा एव्‍वका मुन्‍नेने ओन हव्कालय तयारते मनंतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","गानि पौलुसुन हव्कालय कोरसंतुर इंचि पौलुसुना हेलटा मर्रि केंजतोर. अस्‍के ओर किल्‍लाते होंचि पौलुसुंक पूरा वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","वेहतारित्‍ते पौलुस वरोन दरोगान केय्‍सि, “ई लेय्योन सिपाइल्कुना अदिकारिनगा ओम, ईर ओन्क बतलो वेहंतोर अले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","अस्‍के दरोगाल सिपाइल्कुना अदिकारिनगा ओसि, “जेलने मनना पौलुस ईन मीहेके तायालय नाकुन विनंति कीतोर. ईर नीकु बतलो वेहंतोर अले,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पजा आ सिपाइल्कुना अदिकारि ओना कय पीसि, बोरे हिल्वगा ओसि, “वेहा, नावातोनि बतल वळकानद मंता?” इंचि पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","अस्‍के लेय्योड, “यहुदिल्क उंदि आसि, पौलुसुन इंका बेस गट्‍टिगा पूसकियाना बहानाते नाडि यहुदिल्कुना पेद्‍दा पंचादिते केयागोटनाहाटीं, नीकुन विनंति कींतुर. ");
INSERT INTO esg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","गानि निमे ओरा पोल्‍लें केंजमा. बारित्‍ते, नल्‍पैकन्‍ना एक्‍को लोकुल्‍क पौलुसुन हव्कवा मोमोट तिन्‍नोम-उन्‍नोम इंचि ओट्‍टु तित्‍तुर. निमे ‘ओन ओम्टु’ इंचि आदेस हियानद एदुर हूळसंतुर,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","वेहतस्के, आ सिपाइल्कुना अदिकारि, “निमे नाकु इव पोल्‍लें वेहतिन इंचि बोर्के वेहमा,” इंचि आ लेय्योन लोहचीतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","अस्‍के आ सिपाइल्कुना अदिकारि ओना इव्वुर दरोगालोर्कुन केय्‍सि, “रोंडु नुह्कु सिपाइल्क, डेब्बै मंदि गुर्राल्कुनपोर्रो उद्‍दिस होनानुर, रोंड नुह्कु गोर्कां पियानोर्कुन नर्काटां तोम्मिद एगानेंके कैसरिया सहरते होनालय तयार इर्रट. ");
INSERT INTO esg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","पौलुसुन ओयालय गुर्राल्कुन तयार इर्रट. ओन बेस कापाळसि पिलिक्‍स राज्यपालनगा ओम्टु,” इंचि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ओर उंदि इल्‍हा सिट्‍टि रासतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“महाराज पिलिक्‍स राज्यपाल नीकु, कलादियुस लुसियाना हेंदाल जोहार. ");
INSERT INTO esg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","यहुदिल्क ई मनकन पीसि हव्कसेक मत्‍तुर, गानि ईर रोम रहिवासि इंचि नना केंजतस्के सिपाइल्कुन पीसि होंचि ओरागटाल ओन पिसागोटतन. ");
INSERT INTO esg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ओना तप्पु बतल आंदु, इदुन एरपाट कियालय ओन ओरा पेद्‍दा पंचादिते ओतन. ");
INSERT INTO esg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","अगा ओर, ओनपोर्रो तप्पुक दोसतव अन्‍नि ओरा दर्मसास्त्राल्कुना हेंदाले मत्‍तां. अदुनहाटीं ओन हव्कनसोंटा हिलाकोंटे ओन जेलने वाटानसोंटा तप्पु ओनगा दिसा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","गानि ओन बोरो हव्कना मंता इंचि नाकु तेळियतस्के, ओन बिराना नीहेके लोहचीतन. ओनपोर्रो तप्पु दोस्सानोर बोर अय्ते मंतुर ओर नीवा मुन्‍ने वासि ओना तप्पु बतलो नीकु वेहगोम इंचि ओर्क आदेस हीतन,” इंचि सिट्‍टि रासतोर. ");
INSERT INTO esg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","सिपाइल्कुंक बल्हा आदेस हीतोर, अल्‍हेने पौलुसुन पीसि नर्कटद-नर्केन अंतिपत्रि सहरते ओतुर. ");
INSERT INTO esg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","इंकुंदि रोजु गुर्राल्कुनपोर्रो होनानोर्कुन ओनतोनि होनालय होळसि, कळमातोर किल्‍लाते तिरियसि वातुर. ");
INSERT INTO esg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ओर कैसरिया सहरते एवतारित्‍ते राज्यपालुंक सिट्‍टि हीसि पौलुसुन ओना मुन्‍ने निलाहतुर. ");
INSERT INTO esg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","राज्यपाल सिट्‍टि हद्‍विसि, “निमे बद एरियातोन,” इंचि पौलुसुन पूसकीतोर. ओर किलिकिया एरियातोर इंचि तेळियतारित्‍ते, ");
INSERT INTO esg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“नीवा पोर्रो तप्पु दोस्सानुर इगे वातारित्‍ते नीवा न्‍यायम कींतन,” इंचि ओर इत्‍तोर. पजा पौलुसुन, हेरोद राजाना किल्‍लाते मनना जेलने इर्सि, ओना पहारा कीम्‍टु, इंचि आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","हेय्युं रोजकु आतारित्‍ते हनन्‍याल इनना पेद्‍दा पेर्माल, इच्‍चुर यहुदि पेद्‍दाल्कुन, तिरतुल्‍लुस पोरोलतोर वकिलुन पीकुंचि कैसरिया सहरते वासि, राज्यपालुना मुन्‍ने पौलुसना विरोदते केस कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","राज्यपाल पिलिक्‍स, पौलुसुन केयतारित्‍ते, तिरतुल्‍लुस इनना वकिल पौलुसुनपोर्रो तप्पु दोस्‍सि इल्‍हा इनालय दल्‍गतोर, “राज्यपाल सायाब, नीवाहेंदाल मोमोट वेल्‍ले रोजकुनाल सांतिते मंतोम, नीवा तेल्विहेंदाल मावा देसेम सुदरांचेके मंता. ");
INSERT INTO esg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","दीन मोमोट अन्‍नि जेगाने, अन्‍नि तीरकुने, पूरा मनसुने ओप्‍कुंतोम. ");
INSERT INTO esg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","नना नीकु वेल्‍लेने पोल्‍लें वेह्‍चि तिप्‍पल किय्योन, गानि मावां रोंड पोल्‍लें केंजा इंचि विनंति कींतन. ");
INSERT INTO esg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ई मनकल जगडाल्‍क पुटिच्‍चानोर, दुनियाते मनना अंटोर यहुदिल्कुंक होंग वायागोटनोर आनि ईर नासरेत पार्टिता लीडर आंदुर. ");
INSERT INTO esg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","मावा गुळितुनगुडा हेडहासेक मत्‍तोर, गानि ईन मोमोट दोर्का पीतोम. (मावा नियम मत्‍ताप ईना न्‍यायम कींतोम इंचि मोमोट हूळतोम, ");
INSERT INTO esg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","गानि सिपाइल्कुना अदिकारि लुसियाल वासि जबरदस्‍तिते ईन महागटाल इग्‍गिस ओतोर. ");
INSERT INTO esg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","तप्पु दोस्‍सनुर मीवा मुन्‍ने वायना इंचि आदेस हीतोर.) मोमोट ईना पोर्रो बव तप्पुक अय्ते दोसतोम अव अन्‍नि निजमा-आबद्‍दमा निमेने पूस कीसि हूळा, पूसकीते नीकु पूरा तेळियसि दांता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","अस्‍के यहुदिल्कगुडा ओनाहेके आसि, इवन्‍नि पोल्‍लें निजमे, आंदुं इंचि इनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","पजा राज्यपाल, पौलुसुन वळकालय सय्गे कीतस्‍के पौलुस इल्‍हा वळकालय दल्‍गुतोर. “निमे वेल्‍लेने वर्सानाल ई देसेमते न्‍यायम कीसेक मंतिन इंचि तेळियता. अदुनहाटीं नीवा मुन्‍ने नना कुसिते नावा पोल्‍लें वेहंतन. ");
INSERT INTO esg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","नना येरुसलेमते पेनदुन मोळकालय होंचि पन्‍नेंडु रोजकुंकन्‍ना एक्‍को आयाहिल्‍ले, इद पोल्‍ले निजमे इंचि नीकु तेळियार. ");
INSERT INTO esg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","नना गुळिते बोनतोने लोल्‍लि कीतद ईर हूळा हिल्‍लुर, दर्मसास्‍त्रम कराहना लोहकुने आयि, सहरते आयि, लोकुल्‍कुनतोनि जगडम पुटिस्तदगुडा ईर हूळा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","इंदके नीवा मुन्‍ने, नावापोर्रो दोस्ता तप्‍पुकुन ईर निजम कीसि हुप्‍सा पर्रुर. ");
INSERT INTO esg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","गानि उंदि पोल्‍लेतुन नीवा मुन्‍ने नना ओप्‍कुंतन. नना पेनदा हर्दे ताकसि, मना पेद्‍दाल्कुना पेनदा सेवा कींतन. आ हर्दुन ईर तप्‍पुड पार्टि इंतुर. मूसाना नियमते, पेनदा कबुरतोरा नियमते रासतव अन्‍नि पोल्‍लेनपोर्रो नना विस्वासम कींतन. ");
INSERT INTO esg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","नीतिते ताकानोर, नीतिते ताकवोर इव्वुरगुडा हातोरा लोप्पोटाल मर्रा जीवाते तेदांतुर इंचि ईर आसे इरताप, ननागुडा पेनदापोर्रो आसे इरंतन. ");
INSERT INTO esg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","अदुनहाटीं नना पेनदा मुन्‍ने आयि, लोकुल्‍कुना मुन्‍ने आयि, बस्‍केळ्‍क बेस मनसुने ताकालय हूळंतन.” ");
INSERT INTO esg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","नना वेल्‍लेने वर्सानाल येरुसलेमते हिलाका मत्‍तन, गानि इंदके मावा गरिब लोकुल्‍कुनाहाटीं दान-दर्मम एविच्‍चि हियालय आनि गुळितगा पेनदुक मोक्‍कु हियालय वासि मत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","नना गुळितगा सुद्‍दिकरन कीकुंचि, दंडकाल्क महानेंके नाकुन हूळतुर. अस्‍के अगा वेल्‍ले मंदि मना हिल्‍लुर, लोल्‍लि मनाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","गानि आसियाताल वातुर इच्‍चुर यहुदिल्क अगा मत्‍तुर. नावदगिंटा बतलन्‍ना तप्पु मंचि मत्‍ते, ओर नीवा मुन्‍ने वासि, नापोर्रो तप्पु दोस्‍सि मन्‍नेर. ");
INSERT INTO esg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","हिलाकोंटे, नना यहुदि पंचादिते निल्‍सि मत्‍तास्‍के नावद बतल तप्‍पु दोर्कुतानो, अदन्‍ना इग्‍गे मत्‍तोर वेहिरकांटी. ");
INSERT INTO esg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","“हातोर मर्रा जीवाते तेदांतुर,” इंचि ओरा मुन्‍ने नना जोरते इत्‍तन. इद उंदे पोल्‍लेताहेंदाल नावा न्‍यायम मीवा मुन्‍ने जर्गसेक मंता, इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","पिलिक्‍सुंक, पेनदा हर्दा बारेमते बेस एरपाट मत्‍ता. अदुनहाटीं न्‍यायम कियानद आपसि, “सिपाइल्कुना अदिकारि लुसियाल वातारित्‍ते नीवा पोल्‍लेता पय्सला कींतन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","पजा, “ईन दोहाकोंटा जेलते इर्रा, ईना दंटातुर बतलन्‍ना हियालय वाते ओर्कुन आपमा,” इंचि दरोगांक आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","कोन्‍नि रोजकु आतारित्‍ते पिलिक्‍स ओना यहुदि जातिता मुत्‍तो दुरसिल्‍लानतोनि अगा वातोर. पजा पिलिक्‍स पौलुसुन केया लोहतोर. अय्ते, येसु किरिस्‍तुनपोर्रो विस्वासम इर्राना बारेमते पौलुस ओर्कु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","गानि बस्के अय्ते, सत्‍तेमते बल्हा ताकाना, बल्हा ओप्‍केते मनना, पेन दुनियातोरा न्‍यायम आकिरते बल्हा किय्‍यार इव पोल्‍लेना बारेमते पौलुस पिलिक्‍सुनतोनि चर्चा कीतोर, अस्‍के पिलिक्‍स वेरियसि, “इंदके निमे होन, वेला दोर्कतस्के नना नीकुन मर्रा केयंतन,” इंचि पौलुसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","पौलुस कोत्‍तां हियानुर बारे इंचि पिलिक्‍स आसे पळसि ओन ऊके-ऊके केय्‍सि ओनतोनि वळ्‍कुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","रोंडु वर्सां इल्हेने पेय्सि होत्‍तारित्‍ते पिलिक्‍सना जेगाते पुरकियुस पेसतुस पोरोलतोर राज्यपाल आतोर. पिलिक्‍स होनना वेलाते, यहुदिल्कुन कूस कियानाहाटीं पौलुसुन जेलतेन इरतोर. ");
INSERT INTO esg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","पेसतुस राज्यपाल कैसरिया सहरते वासि, मूड रोजकु आतारित्‍ते, अगटाल येरुसलेम सहरते होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","अगा पेद्‍दा पेर्मालोर आनि यहुदि पेद्‍दाल्क वासि पेसतुस राज्यपालना मुन्‍ने पौलुसुनपोर्रो तप्पु दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","पौलुसुन नड्‍डुम हरदेन हव्कना विचारम मत्‍ताहाटीं, “मावा पोर्रो दया कीसि ओन येरुसलेमते लोहचीम इंचि पेसतुस राज्यपालुन ओर विनंति कीतुर.” ");
INSERT INTO esg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","अस्‍के पेसतुस इत्‍तोर, “पौलुस कैसरिया सहरता जेलते मंतोर, नना बिराना अगा दांतन. ");
INSERT INTO esg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","अदुनहाटीं मिहागटाल यहुदि पेद्‍दाल्कुन नावातोनि लोहचीम्टु. आ मनकानद बतलन्‍ना तप्पु मत्‍ते, ओना तप्पुन मिमेट हुप्‍सा परांतिर,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","पेसतुस राज्यपाल एनमिदि पदि रोजकु ओरतोनि मंचि, कैसरिया सहरते वापस होत्‍तोर. इंकुंदि रोजु कोरटते न्‍यायम कियाना जेगातगा उद्‍दिस पौलुसुन तायालय आदेस हीतोर. ");
INSERT INTO esg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","पौलुस वातारित्‍ते, येरुसलेमताल वाता यहुदिल्कु ओना सुट्‍टु निततुर. ओनपोर्रो पेद्‍दा-पेद्‍दा तप्पुक दोस्तुर, गानि उंदिंका तप्पु निजम कीसि वेहा पर्राहिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","अस्‍के, “नना यहुदिल्कुना दर्मसास्‍त्रमता नियमकुना अड्‍डम बतले कबळ किया हिल्‍लेन, गुळितगा बतले तप्‍पु कबळ किया हिल्‍लेन, कैसर राजांक अड्‍डम बतले वळका हिल्‍लेन,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","पौलुस अल्हा इत्‍तस्के, यहुदिल्कुन कूस कियालय, “इव पोल्‍लेना न्‍यायम येरुसलेमते नावा मुन्‍ने आयागोम इंचि नीवा मनसु मंताना,” इंचि पेसतुस पौलुसुन पूसकीतोर. ");
INSERT INTO esg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","अस्‍के पौलुस इल्‍हा जवाब हीतोर, “इंदके नना कैसरना कोरटतगा नित्‍तिसि मंतन, इग्‍गेने नावा न्‍यायम आयापींता. यहुदिल्कुना विरोदमते नना बतल तप्‍पु किया हिल्‍लेन इंचि नीकुगुडा बेस एरपाट मंता. ");
INSERT INTO esg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ओक्‍कला नना तप्‍पु कीतोन आसि, नावा तप्‍पु हामुर सिक्‍सालायक मनानय्ते, नना हायालय तयार मंतन. गानि बव पोल्‍लेन पोर्रोटाल अय्ते लोकुल्‍क नापोर्रो तप्‍पु दोस्सेक मंतुरो, अव पोल्‍लें ओक्‍कला आबद्‍दम पेय्‍सानय्ते, नाकुन बोरे ओरा कय्‍दे हिया पर्रुर. नावा न्‍यायम इग्‍गे आयाकोंटे, कैसर राजाना मुन्‍ने आयागोम इंचि कोरसंतन.” ");
INSERT INTO esg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","जवाबुने पेसतुस ओना पंचादिते उदता पेद्‍दाल्कुनतोनि वळ्‍किसि, “निमे कैसर राजानगा न्‍यायमताहाटीं विनंति कीतिन अय्ते ओनागेन दाकिन,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कोन्‍नि रोजकु आतारित्‍ते, अग्रिपा राजाल आनि ओना हेलड बर्निका, पेसतुस राज्यपालुंक कलियालय कैसरिया सहरते वातुर. ");
INSERT INTO esg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ओर इव्वुर वेल्‍लेने रोजकु अगा मत्‍तुर. मत्‍तस्के, पेसतुस राज्यपाल पौलुसुना न्‍यायमता बारेमते अग्रिपा राजांक इल्‍हा वेहतोर. मुन्‍नेटा पिलिक्‍स राज्यपाल, वरोर मनकन इग्‍गेने जेलने इरसि होत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","नना येरुसलेमते मत्‍तास्‍के, पेर्मालोर्क आनि यहुदि पेद्‍दाल्क ओनपोर्रो तप्पु दोस्‍सि, ओन्क सिक्‍साता आदेस हियालय नाकुन इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","अस्‍के नना ओर्कुन इल्‍हा इत्‍तन, “बदवेरदाका अय्ते तप्पु कीता मनकल, तप्पु दोस्तोरा मुन्‍ने नित्‍तिसि, ओना तप्पुना बारेमते वळ्कोरो, अदवेरदाका ओन्क सिक्‍सा हियना रोमि लोकुल्‍कुना रिवाज हिल्‍ले,” इत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","अल्हा इत्‍तस्के, ओर लोकुल्‍क नावातोनि इग्‍गे वातुर. नना आल्सेम कियाका, इंकुंदि रोजु न्‍यायम कियाना जेगातगा उद्‍दिस, आ मनकन तायालय आदेस हीतन. ");
INSERT INTO esg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ओनपोर्रो तप्पु दोस्सानुर नित्‍तिसि ओना तप्पुक वेहतुर, गानि नना इनकुत्‍ताप बदे तप्पु ओनपोर्रो वेहा हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","सिराप ओर ओरा दर्मता बारेमते आनि येसु पोरोलता वरोर हासोत्‍ता मनकना बारेमते ओरा लोल्‍लि मत्‍ता. गानि पौलुस मात्रम हासोत्‍ता येसु जीवाते मंतोर इंचि इंतोर. ");
INSERT INTO esg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","इसोंटा पोल्‍लेन बल्हा न्‍यायम कीकन इंचि नाकु तेळियाकोंदु. अदुनहाटीं नना, “इव पोल्‍लेना पय्सला कियालय येरुसलेम दांतिना?” इंचि ओन पूसकीतन. ");
INSERT INTO esg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","अस्‍के पौलुस इत्‍तोर, “नावा न्‍यायम कैसर राजानगा आयागोम, अदवेरदाका इग्‍गेने जेलते मनंतन,” इंचि विनंति कीतोर. अदुनहाटीं नना ओन कैसरनगा लोहनदाका ओर इग्‍गेने मन्‍निर, इंचि आदेस हीतन. ");
INSERT INTO esg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","अस्‍के अग्रिपा राजाल, “आ मनकल इनना पोल्‍लें नाकु केंजना मनसु मंता,” इंचि पेसतुसुनतोनि इत्‍तोर. “अल्हा अय्ते, ओना पोल्‍लें नाडि केंजकिन,” इंचि पेसतुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","इंकुंदि रोजु अग्रिपा राजाल आनि बर्निका बेस सोक आसि वातुर. सिपाइल्कुना अदिकारिल्‍क, सहरता पेद्‍दा मनकालोर्कुनतोनि कूळसि पंचादि कियाना जेगाते ओर होत्‍तुर. अस्‍के, पौलुसुन पीसि वटु, इंचि पेसतुस आदेस हीतारित्‍ते, पौलुसुन तत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","अस्‍के पेसतुस राज्यपाल इत्‍तोर, “अग्रिपा राजाल आनि इगे जमा आता लोकुरिटा! ई मनकन मिमेट हूळसंतिर, येरुसलेमतोर आनि इग्‍गेटुर वेल्‍लेटोरगुडा यहुदिल्क नहगा वासि, ईन जीवाते इरमळ बेस आयो, इंचि वरगेयसेक विनंति कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","गानि ईर हामुटा सिक्‍सालायक बतले तप्पु कियवाप नाकु दिसता. ओर कुद कैसर राजाना मुन्‍ने न्‍यायम आयागोम इंचि विनंति कीतोर, अदुनहाटीं ईन कैसर राजानहेके रोमते लोहना विचारम कीसेक मंतन. ");
INSERT INTO esg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","गानि ईना बारेमते कैसर राजांक बतल रासाना नाकु तेळिया हिल्‍ले. अदुनहाटीं ईना पोल्‍लें केंजता पजा, बदन्‍ना पोल्‍ले नाकु रासालय दोर्कार बारे इंचि मीवा मुन्‍ने ईन तत्‍तन, कास कीसि अग्रिपा राजाना मुन्‍ने तत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","जेलते मत्‍ता मनकना बारेमते ओना तप्पु बतले वेहवा, उंदे मल्का ओन कैसर राजानगा लोहमळ नाकु बेस दिस्सो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","“इंदके नीवा पोल्‍लें वेहा परांतिन,” इंचि अग्रिपा राजाल पौलुसुन इत्‍तोर. अस्‍के पौलुस, नना वळकंतन, इंचि वेहालय ओना कय तेहचि वळकुमळ सुरुव कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","अग्रिपा राजा! यहुदिल्क नावापोर्रो बव पोल्‍लेना बारेमते अय्ते तप्पु दोस्तुरो, अव अन्‍नि पोल्‍लेन नीवा मुन्‍ने वेहालय नाकु मोका दोर्कता इंचि नना कूस आसेक मंतन. ");
INSERT INTO esg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","कास कीसि, यहुदिरा रीति-रिवाजकु, ओरा विचाराल्‍कुना बारेमते नीकु बेस एरपाट मंता. अदुनहाटीं दया कीसि नावा नना वळ्‍काना पोल्‍लेन बेस केंजा इंचि विनंति कींतन. ");
INSERT INTO esg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","नना सिन्‍ना मत्‍तस्केटाल नावा लोकुल्‍कुनतोनि येरुसलेमते मत्‍तन. अदुनहाटीं नावा ताकमळ, नावा पिस्वर बल्हा मत्‍ता अंटोर यहुदिल्कुंक एरपाटे मंता. ");
INSERT INTO esg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","(यहुदिल्क मोदोटाले नाकुन एरपाट कींतुर. अदुनहाटीं नावा बारेमते गवाइ वेहाना ओरा मनसु मत्‍ते, मावा दर्मता रीति-रिवाजकुन अंटोर्कन्‍ना एक्‍को नोमानोन ननाने इंचि ओर वेहा परांतुर) मावा दर्मतां रीति-रिवाजकुन, परिसिल्कु अंटोर्कन्‍ना एक्‍को नोमुंदुर, अवने नना वरोन परिसिन आंदुन. इदुन यहुदिल्कु बेस एरपाट कींतुर. ओर इनकुत्‍ते इद पोल्‍लेता गवाइगुडा हिया परांतुर. ");
INSERT INTO esg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","पेन मावा एनकटा पेद्‍दाल्कुंक पोल्‍ले हीसि मत्‍ता, अदे पोल्‍ले निजम इंचि नना आसे पडतन. अदुनहाटींगे, इंदके नावा न्‍यायम आयना मंता. ");
INSERT INTO esg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","अदे पोल्‍ले पूरा आंता इत्‍ता आसेते, मावा पन्‍नेंडु गोत्राल्कुना इस्राएल लोकुल्‍क पूरा मनसुने नर्का-पिय्यल उंदेतीर पेनदा सेवा कीसंतुर. इदे बरोसा इरताहाटीं राजा, यहुदिल्क नावापोर्रो दोसेम दोस्तुर. ");
INSERT INTO esg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","अयना, पेन हातोर्कुन मर्रा तेहंता इत्‍ता पोल्‍लेपोर्रो मीवा लोप्पोटाल बोनके विस्वासम बारि हिल्‍ले? ");
INSERT INTO esg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","मुन्‍ने ननागुडा, नासरेत नाटेना येसुना पोरोलता विरोदमते वेल्‍लेने कबाह्‍क किय्‍याना इंचि विचारम कीसि मत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","येरुसलेमते नना अल्हा कीतनगुडा. पेर्मालोरकुनाहेंदाल अदिकारम दोर्किच्‍कुंचि, वेल्‍लेटुर पेनदा लोकुल्‍कुन नना जेलने वाटतन. पेनदा लोकुल्‍कुन हव्कानेंके, हव्कट इंचि नना ओप्‍कुनुंदुन. ");
INSERT INTO esg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","हरेक दर्मसास्‍त्रम कराहना लोते, ओर येसुना अपमानम कियानादाका, ओर्कुन नना तिप्‍पल्‍क किया वेहुंदुन. ओरापोर्रो नाकु इच्‍चोर होंग वायुंदु गदा, ओर्कुन तकलिप कियालय नना पलाते सहरकुनेगुडा होनुंदुन. ");
INSERT INTO esg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","अल्‍हेने उंदि मल्का नना पेर्मालोरकुनाहेंदाल अदिकारम एत्‍कुंचि दमिस्‍क सहर होंचेके मत्‍तन. ");
INSERT INTO esg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","होननेंके पिय्यल आता नना हर्देने मत्‍तन, अस्‍के मब्बुनाल उंदि पोळ्‍दुंकन्‍ना एक्‍को वेलगु नावा आनि नातोनि मत्‍तोरा सुट्‍टु मेर्सता. ");
INSERT INTO esg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","मेर्सतस्के मोमोट अंटोरम हिळु अरतोम. अस्‍के नाकु उंदि अल्किर केंजावाता, अद इब्रानि बासाते नाकुन इल्‍हा इत्‍ता, “साऊल, ए साऊल, नाकुन निमे बारि तकलिप कीसंतिन? मुल्कि पोर्रो कादे तंते नीके कस्‍टम,” इंचि केंजावाता. ");
INSERT INTO esg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","अस्‍के, “सामि निमे बोन आंदिन?” इंचि नना पूसकीतन. सामि इत्‍तोर, “निमे बा येसुनय्ते तकलिप कीसंतिन ओने नना आंदुन. ");
INSERT INTO esg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","गानि इंदके निमे तेदसि, काल्कुनपोर्रो नित्‍ता. नावा बारेमते निमे हूळता पोल्‍लेन अल्हेन नना नीकु हुप्‍सना पोल्‍लेन लोकुल्‍कुंक गवाइ वेहालय, नावा सेवक इंचि नीकुन निलाहंतन. ");
INSERT INTO esg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","नना नीकुन नीवा यहुदिल्कुनगा आनि यहुदि आयवोरगा लोहांतन, अल्हेन ओरागटाल नीकु कापाळंतन. ");
INSERT INTO esg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ओर्कुन हीकटताल वेल्‍गुनहेके, देय्यमता अदिकारमताल पेनदाहेके तिरियना हर्रि हुप्‍सालय नीकुन लोहसेक मंतन. ओर अल्हा तिरियते, ओरा पापाल्क मापि आंतां, अल्‍हेने नापोर्रो बोर अय्ते विस्वासम कीसि पवित्र आतुरो, ओरतोनि ओर्कु वारसाहक्‍क दोर्कार,” इंचि येसु नाकु वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","अदुनहाटीं अग्रिपा राजा! पोर्रोटाल नाक हुपिस्‍ता दर्सनम हूळसि, अद आदेस परकारम ताकतन. ");
INSERT INTO esg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","आयंका, मुन्‍ने दमिस्‍क सहरतोर्कुंक, पजा येरुसलेमते मनानोर्कुंक, यहुदियाता पूरा एरियाते मनानोर्कुंक आनि वेरे जातितोर्कुंकगुडा मनसु मार्सकुंचि पेनदागा वटु. वासि, मनसु मार्सकुत्‍तोरा लायकता बेसता कबाह्‍क कीसि हुप्‍सट, इंचि वेहतन. ");
INSERT INTO esg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इदे कारनमहेंदाल यहुदिल्क नाकुन गुळिते पीसि हव्कालय हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","गानि इदवेरदाका पेन नाकुन सहायम कीता. अदुनहाटीं नना इग्‍गे नित्‍तिसि सिन्‍नाल्क, पेद्‍दाल्क अंटोर मुन्‍ने गवाइ हीसेक मंतन. बव पोल्‍लें अय्ते आयानव मंतां इंचि पेनदा कबुरतोर आनि मूसाल मुन्‍नेन वेहतुर, अव पोल्‍लें तप्‍पा नना वेरे बतले वेहोन. ");
INSERT INTO esg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","अव पोल्‍लें बव इत्‍ते, किरिस्‍तुंकु तकलिप्‍कु बोगांचा पींता आनि हातोरा लोप्पोटाल ओरे मोदाला मर्रा जीवाते तेदसि, यहुदिल्कुंक, यहुदि आयवोर्कुंक वेलगुना बारेमता पोल्‍लें वेहंतोर, इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","इल्‍हा ओर वेहासेक मननेंके पेसतुस वरगेयसि, “पौलुस निमे पागल आतिन. एक्‍को करियतदे नीकुन पागल कीसंता,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","अस्‍के पौलुस इल्‍हा इत्‍तोर, “पेसतुस महाराज, नना पागल आया हिल्‍लेन, निजमतुन नना बेस बुद्‍दिते वेहासेक मंतन. ");
INSERT INTO esg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ई पोल्‍लें मूलाते मक्‍किसि कीतव आयों. इवन्‍नि पोल्‍लें अग्रिपा राजांक बेस तेळियसे मंतां, इंचि नाकु विस्वासम मंता. अदुनहाटीं वेरियाकोंटा ओना मुन्‍ने वळ्कसेक मंतन. ");
INSERT INTO esg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","अग्रिपा राजा! पेनदा कबुरतोर रासतवुन विस्वासम कींतिना, कियिना? निमे विस्वासम कींतिन नाकु एरपाटे,” इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","अस्‍के, “बिरानेन नाकुन किरिस्‍तुनोन कियालय हूळसंतिना?” इंचि अग्रिपाल पौलुसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","अस्‍के “बिरानेन आयि, आल्‍सेमते आयि, सिराप निमेने आयो, इय्याला इग्‍गे केंजानोर अंटोर, इव बेडीं होळसि, कळमता अन्‍नि पोल्‍लेने नावालेसीं आयना इंचि पेनदुक पारतना कीसेक मंतन,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","अल्हा इत्‍तस्के, अग्रिपा राजाल, ओना हेलड बर्निका, राज्यपाल आनि ओरतोनि उद्‍दिस मत्‍तुर अंटोर तेदतुर. ");
INSERT INTO esg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","अगटाल पलाते पेय्सि ओर-ओरे इल्‍हा वळकालय दल्‍गुतुर, “हामुर सिक्‍सालायक हिलाकोंटे जेल सिक्‍सालायक ईर बतले तप्पु किया हिल्‍लोर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","पजा, “कैसर राजाना मुन्‍ने नावा न्‍यायम आयगोम इंचि, ईर इनाकोंटा मंचि मत्‍ते, ईन होळसालय कुदुरवळ,” इंचि अग्रिपा राजल पेसतुसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","आयंका माकुन डोंगाते उद्‍दिस, इटलि एरियाते लोहाना निरनायम कीतुर. कीसि, पौलुसुनतोनि इच्‍चुर जेलने मत्‍तुर्कुन, अगस्तुस दलमता युलियुस पोरोलता दरोगाना कय्‍दे अप्पजेपतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अद्रमुतियुम सहरता डोंगाते मोमोट उदतोम, अद डोंगा आसिया एरियाता ओड्‍डु पीसि मत्‍ता नाहकुनाल पेय्सता. मेसिडोनिया एरियाता तेसलोनि सहरतोर अरिसतरकुसगुडा मावातोनि मत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","इंकुंदि रोजु मोमोट सिदोन सहरतगा एवतोम. अगा एवतस्‍के युलियुस दरोगानकु पौलुसुनपोर्रो दया वाता. अदुनहाटीं पौलुसुना दंटागाह्‍क ओन अवरिचगोम इंचि, “निमे होंचि नीवा दंटागाह्‍कुंक कलियसि वा,” इंचि दरोगाल पौलुसुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","अगटाल मोमोट पेयसनहेके वळि माकु एदुर मत्‍ताहाटीं साइप्रस दीबेता वळि वायवा बाजुनाल पेय्‍सतोम. ");
INSERT INTO esg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","मर्रा मोमोट किलिकिया आनि पंपुलिया एरिया दग्‍गेटा समुद्रम दाटसि, लुकिया एरियाता मूरा इनना सहरतगा रेयतोम. ");
INSERT INTO esg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","अगा सिकंदरिया सहरताल इटलि एरियाक होनालय डोंगा तयार मत्‍ता. माकुन ओयना दरोगाल अद डोंगाते उपिस्तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","वळि माक एदुर मत्‍ताहाटीं, मेल्‍लगा-मेल्‍लगा बच्‍चुंगो रोजकुनदाका वेल्‍ले कस्‍टमते कनिदुस सहरकु दग्‍गेरा एवतोम. एदुर वळि माकुन मुन्‍ने होना हियुवाहाटीं, मोमोट क्रेति दीबेता ओड्‍डु साटने, सलमोने इनना जेगा पक्‍का पीसि दाटतोम. ");
INSERT INTO esg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","अदुन दाटसि, समुद्रमता ओड्‍डुनाल वेल्‍ले तकलिपने डोंगातुन मुन्‍नेळ्‍क जर्पुसेके, डोंगा नित्‍तना बेसता जेगा, इनना जेगातगा एवतोम. अगटाल लसया सहर दग्गेरेने मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","पय्‍नेमते वेल्‍ले रोजकु आसि ओक्‍कापोद्‍दुना रोजगुडा पेय्सि होत्‍ता. वातावरनम कराब मत्‍ताहाटीं डोंगातुन मुन्‍ने ओयालयगुडा वेर्रे मत्‍ता. अदुनहाटीं, ");
INSERT INTO esg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“दादालोरिटा! मनम इगेटाल पेय्सते वेल्‍ले तकलिप आंता इंचि नाकु अनपिच्‍चेक मंता. डोंगा आनि अवुने मत्‍ता सामानय्ते मुळगारे गानि मना जीवां इंका होना परांतां,” इंचि पौलुस डोंगाते मत्‍तोर्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","गानि पौलुसना पोल्‍लेतुन दरोगाल केंजाका, डोंगा ताकिचनोर आनि डोंगा मालकुना पोल्‍लेतुन एक्‍को विस्वासम कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","अद जेगा पीनि कालमते (इग्गमते) मनालय बेस मनाहिल्‍ले, अदुनहेंके वेल्‍लेटुर लोकुल्‍क, “बच्‍चोन बिराना आया परते अच्‍चोन बिराना क्रेति दीबेता पिनिक्‍स सहरतगा होंचि आगते बेस मनंता,” इंचि इत्‍तुर. बारित्‍ते पिनिक्‍स सहरतगा डोंगां आगना उंदि जेगा इल्‍हा मंता: दक्‍सिन-पस्‍चिम आनि उत्‍तर-पस्‍चिमता हेंदाल होळिया वांता. पीनि कालमते अद जेगाते वळि दल्‍गो. ");
INSERT INTO esg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","पजा दक्‍सिन बाजुनाल वळि मेल्‍लगा-मेल्‍लगा वासेके मत्‍तय्ते ओर इंदके मनम पिनिक्‍स सहरते एव्‍वा परांतोम इंचि इनकुत्‍तुर. अस्‍के ओर अगटाल लंगर तेहकुंचि क्रेति दीबेता ओड्‍डु साटने डोंगातुन होना हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","गानि गळसेम मत्‍तारित्‍ते दीबेता हेंदाल उंदि पेद्‍दा वळि दुमारम तेदता. दानु उत्‍तर-पूर्वी तुपान इंतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","मोमोट मत्‍ता डोंगा तुपान लोप्पो दोर्कता. आ तुपानता वळि एदुर मत्‍ताहाटीं डोंगा मुन्‍नेळ्‍क होना पराहिल्‍ले. अस्‍के मोमोट वळि दोब्बुतेके डोंगा होन्‍निकांटी इंचि दान अल्‍हेने होळसीतोम. ");
INSERT INTO esg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","अल्हा मोमोट कौदा इनना सिन्‍ना दीबे साटने होननेंके, डोंगाता पज्जो दोहचि इग्गिसि ओयना पडवन वेल्‍लेन तकलिपने डोंगापोर्रो एक्‍किस्तोम. ");
INSERT INTO esg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","पडवां पोर्रो एक्‍किसतारित्‍ते, डोंगाते कबळ कियानोर बच्‍चुंगो उपायाल्‍क कीसि डोंगातुन नोंडेने, सुट्‍टु इग्‍गिस दोहतुर. सुरतिस इनना उस्‍के जेगाते डोंगा दिगाबडार इंचि आ वेर्रेकु डोंगाता परदातुन रेह्‍चि, डोंगातुन वळिते होळसीतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","अस्‍के इंकुंदि रोजु वळि दुमारमते पक्‍का तकलिप आताहेंके ओर माल पोहचियालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","मूडो रोजुने डोंगाता कबळ्‍क ओज्‍जना सामानगुडा ओरा कय्‍कुनेन पोहचीतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","पजा वेल्‍लेने रोजकु माकु पोळ्‍दु, सुक्‍कां दिसा हिल्‍लें. तुपानते पक्‍का वळि वायुंदु, मोमोट पिस्‍सोम इंचि आसे होळसतोम. ");
INSERT INTO esg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","वेल्‍ले रोजकुनाल बोरे बतल तिना हिल्‍लुर. अस्‍के पौलुस ओरा नड्‍डुम नित्‍तिसि इल्‍हा इत्‍तोर. दादालोरिटा! नावा पोल्‍लें केंजसि क्रेति दीबेताल पेय्‍सका मंचि मत्‍ते, मनाकु ई तिप्‍पल वायाकोनवड, नुकसानगुडा आयाकोनवड. ");
INSERT INTO esg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","अल्हा आयिनागानि मीकु विनंति कींतन, मिमेट दैरनेम इर्राट. मीवा लोप्पोटाल बोनदे जीवा होन्‍नो गानि डोंगाता मात्रम नुकसान आंता. ");
INSERT INTO esg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","24","बारित्‍ते, बद अय्ते नावा पेन, नना अदे पेनदा सेवा कींतन दाना दूता निन्‍ने नर्का वासि, “पौलुस निमे वेरियमा, नीकु कैसर राजाना मुन्‍ने तप्‍पकोंटा नित्‍तना मंता, हूळा! नीतोनि डोंगाते मत्‍तुर अंटोर्कुनगुडा पेन पिसागोटंता,” इंचि इत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","अदुनहाटीं दादालोरिटा! दैरनेम इर्राट. पेन नाकु बल्हा वेहता अल्‍हेने आयार, इंचि नाकु विस्वासम मंता. ");
INSERT INTO esg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","गानि बल्हा अयना मनम बदन्‍ना दीबेतगा उस्केते होंचि हिरकंतोम, इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","पडनालुं रोजकु आयिना, मोमोट अद्रिया समुद्रमता एते हीके-हेके वळिक तिरियसेक मत्‍तोम. तिरियसेक मननेंके नळजाम नर्काटा वेलाकु मनम बदन्‍ना ओड्‍डुंक एवतोम बारे इत्‍ताप डोंगा ताकसानोर्कुंक अनपिस्ता. ");
INSERT INTO esg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ओर समुद्रमता लोतु कहतुर अय्ते अगा नूटा इरवै पूटकु मत्‍ता. इंका इच्‍चुर लक्‍कु होत्‍ता पजा मर्रा कहतुर अय्ते अस्‍के टोंबै पूटकु मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","अस्‍के, बंडाना लोप्पो डोंगा हिरकार बारे इंचि वेरियसि, ओर डोंगाता पज्‍जोटा बाजुंक नालुं लंगर्कु वाटसि बस्के पंगांता इंचि हूळसेक मत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","डोंगा ताकसानोर्कु अगटाल वित्‍ताना मत्‍ताहाटीं, “डोंगाता मुन्‍नेटा बाजुंक लंगर्कु वाटंतोम,” इंचि बोंकिच्‍चि पडवां रेहतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","अस्‍के पौलुस, “ईरगिंटा डोंगाते मनाकोंटे मिमेट इंका पीस्‍सिर,” इंचि सिपाइल्कुना अदिकारिन आनि सिपाइल्कुन इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","अस्‍के सिपाइल्क, पडवां दोहता नोंडेन नेमाहचि पडवन एते अरहतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","पंगायना वेलाते पौलुस अंटोर्कुन गाटो तिननाहाटीं विनंति कीसि इल्‍हा इत्‍तोर, “तुपान मग्‍गंता इंचि मिमेट एदुर हूळ-हूळसि, इय्यळ्‍क पडनालुं रोजकु आसंता. उपासम मंतिर, बतले तिना हिल्‍लिर. ");
INSERT INTO esg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","अदुनहाटीं मिमेट गाटो तिंटु इंचि विनंति कीसेक मंतन. तित्‍तेने मिमेट जीवाते मनांतिर. मीवा लोप्पोटाल वरोनदगुडा तल्‍लाता उंदि केल्‍ददगुडा नुकसान आयो,” इंचि इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","अल्हा वेह्‍चि, अंटोरा मुन्‍ने ओर हारि पीतोर. पेनदुक दन्यवाद कीसि, हारितुन तुकडां कीसि तिनालय दल्‍गुतोर. ");
INSERT INTO esg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ओन हूळसि, अंटोर्क हिम्मत वाता, ओरगुडा तिनालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","डोंगाते मोमोट अंटोरम रोंडु नुहकुना डेब्बै हारुर (276) मंदि मत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ओर पीरनिंडा गाटो तित्‍तारित्‍ते, डोंगाते मत्‍तव गोह्कुन समुद्रमते पोहचि डोंगातुन अल्कगा कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","पंगातारित्‍ते ओर्कु समुद्रमता ओड्‍डु दिसता, गानि अद बद देसेम इंचि एरपाट किया हिल्‍लुर. कुदुरते डोंगातुन इदे ओड्‍डुंक दल्‍गिच्‍चि इरकोम इंचि विचारम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ओर लंगर्कुना नोंडें नेमाहचि, अवुन समुद्रमते होळसि, अस्‍केने पतवारकुंक दोहाचि मत्‍ता नोंडेंगुडा ओदोल कीतुर. ओदोल कीसि डोंगातुन वळि मुन्‍नेळ्‍क ओयि इंचि परदां एक्‍किचि डोंगातुन ओड्‍डुनहेके ओयालय दल्‍गुतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","गानि बगा अय्ते रोंड समुद्राल्क कलियंतां, असोंटा जेगातगा डोंगा होत्‍ता. अगा डोंगाता मुन्‍नेटा बाजु उस्केकु दल्‍गिसि, मुन्‍नेळक जर्गाकोंटा दिगाबळता. पज्‍जोटा बाजु बारे जोरते वायाना तडां दल्‍गिसि डोंगा पय्यालय आता. ");
INSERT INTO esg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","अस्‍के कैदिल्कु बोरे ईतार्सि वित्‍ता मन्‍नि इंचि सिपाइल्क ओर्कुन हव्कना विचारम कीतुर. ");
INSERT INTO esg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","गानि दरोगांक पौलुसुन पीसागोटनद मत्‍ता, अदुनहाटीं ओरा पिलानतुन आपिसि ओर्कु इल्‍हा आदेस हीतोर, “बोर्क अय्ते ईता वांता, ओर मुन्‍नेने डेयसि ओड्‍डुंक पेयसट. ");
INSERT INTO esg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","कळमातोर बारे बल्‍लां आनि डोंगाता उरुंगता तुकडनपोर्रो उद्‍दिस पेयसट,” इंचि इत्‍तोर. इल्‍हा बोर्के बतल आयाकोंटा अंटोर ओड्‍डुंक पेय्‍सतुर. ");
INSERT INTO esg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","इल्‍हा मोमोट ओड्‍डुंक पेय्सतारित्‍ते, अद माल्टा इनना दीबे इंचि माकु तेळियता. ");
INSERT INTO esg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","आ दीबेते मनना लोकुल्‍क मावा पोर्रो वेल्‍ले दया हुपिस्तुर. पिर्रु, इरगा पीनि मत्‍ताहेंके, तडमि माससि माकुन बेस दग्‍गेरा केयकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पौलुस जमा कीता कट्‍टेना हेरकितुन तडमिते वाटसेके मत्‍तोर. अस्‍के उंदि नय तरासु तळमि सेकाकु हेरकिताल पेय्सि ओना कय्‍दुक हुटकुत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","तरासु कय्‍दुक वेलाड अरसि मत्‍तद हूळसि दीबेता लोकुल्‍क वरोंक-वरोर इल्‍हा इत्‍तुर, “निजमे, ईर तप्‍पाकोंटा बोनो गानि हव्कतोर. ईर समुद्रमताल अय्ते पिस्सि पेय्सतोर गानि न्‍यायम मात्रम ईन पिस्‍सा हियानाल हिल्‍ले,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","गानि पौलुस आ तरासुन तळमितेन दुल्‍पिसि वाटतोर. ओन्कुगुडा बतल आयाहिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ओना मेंदुल तोयार हिलाकोंटे ओर उंदे मल्का हिळु अरसि हायानुर इंचि लोकुल्‍क हूळसेक मत्‍तुर. वेल्‍लेनजेम आयिनागानि ओन्क बतले आयाहिल्‍ले. अस्‍के ओरा मनसु मार्सकुंचि, “ईर अय्ते बदो पेन आंदुर,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","आ दीबेता पेद्‍दा अदिकारि पबलियुस इनानोना बूमिं दग्गेरेने मत्‍तां. ओर माकुन केय्‍सि ओसि मूड रोजकुनदाका हेडमितोर्कुन हूळकुत्‍ताप बेस हूळकुत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पबलियुसुना बानकु एडकि वासेके मत्‍ता. अल्‍हेने नेत्‍तुर बयलि दोस्‍सि, कटुलते मींडसि मत्‍तोर. पौलुस ओनगा लोप्पो होंचि पारतना कीसि, ओनपोर्रो कय इरसि बेस कीतोर. ");
INSERT INTO esg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","अल्हा आतद हूळसि आ दीबेते बिमार अर्सि मत्‍ता कळमतोरगुडा अगा वासि बेस आतुर. ");
INSERT INTO esg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ओर माकुन वेल्‍ले कदर कीतुर. मोमोट अगटाल पेय्सनेंके माकु बतल-बतल गावाले मत्‍ता अवन्‍नि डोंगाते तच्‍चि इरतुर. ");
INSERT INTO esg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","मूड नेल्क आतारित्‍ते सिकंदरिया सहरताल वाता डोंगाते मोमोट पेय्‍सतोम. आ डोंगा पीनि कालम पेय्सनदाका माल्टा दीबेतगा आगसि मत्‍ता. डोंगाता मुन्‍नेटा बाजुंक एमडाल्‍कुना पेनकुना बोम्मा रेहचि मत्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","मोमोट सरकुस सहरते एव्‍सि, अगा मूड रोजकु मत्‍तोम. ");
INSERT INTO esg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","अगटाल मोमोट तिरियसि रेगियुम सहरते एवतोम. इंकुंदि रोजु दक्‍सिन बाजुनाल वळि तेदता. अस्‍के मर्रा उंदि रोजु अगटाल पेय्सि पुतियुलि सहरते वातोम. ");
INSERT INTO esg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","अगा माकु इच्‍चुर विस्वासुल्‍क कलियतुर. ओर माकुन ओरतोनि एडुं रोजकु मंटु इंचि इत्‍तुर. इल्‍हा मोमोट रोम सहरते एवतोम. ");
INSERT INTO esg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","बस्के अय्ते रोम सहरता विस्वासुल्कुंक मोमोट वासेक इंचि तेळियता, अस्‍के ओर माकु कलियालय अप्पियुस हाटुमदाका वातुर. इंका आगाना मूड जेगा इनना नारदाका वातुर. ओर्कुन हूळसि, पौलुस पेनदुक दन्यवाद कीतोर, ओना दैरनेम बेरस्‍ता. ");
INSERT INTO esg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","मोमोट रोम एवतारित्‍ते वरोर सिपाइना पहाराते पौलुसुंक मनालय अलग उंदि लोन दोर्कता. ");
INSERT INTO esg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","मूड रोजकु आता पजा पौलुस अगाटा यहुदि पेद्‍दाल्कुन केयतोर. ओर उंदगा जमा आतारित्‍ते पौलुस ओरतोनि इल्‍हा वळकालय दल्‍गुतोर, “दादालोरिटा, मना लोकुल्‍कुन आयि मना एनकटा पेद्‍दाल्कुना रीति-रिवाजकुन आयि नना बतले किया हिल्‍लेन गानि नाकुन येरुसलेमते रोम लोकुल्‍कुना कय्‍दे यहुदिल्कु पीसि हीतुर. ");
INSERT INTO esg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","रोमि अदिकारिल्‍क नावा चौकसि कीतारित्‍ते नाहेके हामुर सिक्‍सातसोंटा बतले तप्पु मनाहिल्‍ले. अदुनहाटीं ओर नाकुन होळसींतोम इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","गानि, ‘ईन होळसियामन्‍नि’ इंचि यहुदिल्क इत्‍तुर. अदुनहाटीं, ‘कैसर राजानगा नावा न्‍यायम आयागोम,’ इंचि नना विनंति कीतन, अचोने. इगे नना नावा लोकुल्‍कुनपोर्रो दोसेम दोसालय वाया हिल्‍लेन. ");
INSERT INTO esg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ई पोल्‍लेन मीतोनि कलियसि वळ्कालय मीकुन केयतन. वरोर वायाना मंतोर इत्‍ता आसेते, इस्राएल लोकुल्‍क बोनद एदुर हूळसेक मत्‍तुर, ओर वातोर इंचि नना विस्वासम कीताहाटींगे नाक बेडीं अरतां,” इंचि पौलुस इत्‍तोर. ");
INSERT INTO esg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","अस्‍के यहुदि पेद्‍दाल्‍क पौलुसुन इल्‍हा इत्‍तुर, “नीवा बारेमते यहुदिया एरियाताल बतले सिट्‍टि दोर्काहिल्‍ले. अगटाल वायाना दादालोरगुडा नीवा बारेमते बतल वेहा हिल्‍लुर, नीवा बारेमते बदे कराब पोल्‍लेगुडा इना हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","गानि अन्‍नि जेगाने नासरेत पार्टितोरा विरोदतेन वळ्‍कानद माकु एर्का मंता. अयना नीवा विचारम बतल मंता, इद मोमोट नीवाहेंदाले केंजंतोम,” इंचि इत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","अस्‍के ओनतोनि कलियालय उंदि रोजु पक्‍का कीतुर. पक्‍का कीता रोजुने ओर आगसि मत्‍ता लोतगा यहुदिल्कु वेल्‍लेटुर जमा आतुर. पौलुस हक्‍केटाल अय्ते पोळ्‍द होननदाका पेनदा राज्येम बारेमते ओर्कु गवाइ वेहतोर. अल्‍हेने मूसाना नियमताल आनि पेनदा कबुरतोर रासता पुस्तकाल्कुनाल येसुना बारेमते ओर्कु तेळियागोट्‍सि वेहतोर. ");
INSERT INTO esg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ओर वेहता पोल्‍लें इच्‍चुर्कु नच्‍चुतां, इच्‍चुर्कु नच्‍चुवा ओर विस्वासम किया हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","पजा ओरद-ओर्के वरोन पोल्‍लें वरोंक अर्राका, अगटाल तेदसि होनालय आयानेंके पौलुस इंकुंदि पोल्‍ले इत्‍तोर, पवित्र आत्मा यसायाह इनना पेनदा कबुरतोनाहेंदाल, मीवा एनकटा पेद्‍दाल्कुनतोनि वेहता पोल्‍ले निजमे आंदु, अद इल्‍हा मंता: ");
INSERT INTO esg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“निमे लोकुल्‍कुनगा होंचि इल्‍हा वेहा, मिमेट बस्‍केळ्‍क केंजसेके मनंतिर, गानि अर्तम कीकुन्‍निर. मिमेट बस्‍केळ्‍क हूळसेक मनंतिर, गानि एरपाट किय्‍यिर. ");
INSERT INTO esg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","बारित्‍ते ई लोकुल्‍कुना मनसु गट्‍टिगा आता, ओर केव्‍कुने तक्‍को केंजांतुर, ओर ओरा कळ्‍क मुच्‍कुत्‍तुर. अल्हा कियाकोंटे ओर कळ्‍कुने हूळसि मन्‍नेर, केव्‍कुने केंजसि मन्‍नेर, मनसुने एरपाट कीसि मन्‍नेर, नावाहेके तिरियसि मन्‍नेर, नना ओर्कुन बेस कीसि मन्‍नेन.” ");
INSERT INTO esg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","अदुनहाटीं, मुक्‍ति हियना कबुरतुन पेन वेरे जातितोरगा लोहता. ओर अदुन केंजंतुर, इंचि मिमेट एरपाट कियगोम. ");
INSERT INTO esg_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","पौलुस इव पोल्‍लें इत्‍तारित्‍ते यहुदिल्कु वरोंकु वरोर वरगेयसेके अगटाल पेय्सि होत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","अगा किरायता लोते पौलुस पूरा रोंड वर्सनदाका मत्‍तोर. बोर कलियालय वायिनागानि ओर्कुन बेस हूळुंदुर. ");
INSERT INTO esg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","वेरियाकोंटा, आगाकोंटा पेनदा राज्येम बारेमते वेहुंदुर, येसु किरिस्‍तुना बारेमते कराहुंदुर.");
INSERT INTO esg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","नना पौलुस, येसु किरिस्‍तुना दासुन आंदुन. नना मीकु इद सिट्‍टि रासेक मंतन. येसु किरिस्‍तुना कबाह्‍क कियालय पेन नाकुन प्रेरित इंचि पेरता. पेरसि दाना बेसता कबुर वेहालय लोह्ता. ");
INSERT INTO esg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","पेनबाबाल हींतन इत्‍ता इदे बेसता कबुरता बारेमते पेनदा कबुरतोर मुन्‍नेने पवित्र दर्मसास्‍त्रमते रासि इरतुर. ");
INSERT INTO esg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","इद बेसता कबुर, मनकना रूपमते पुटसि वाता पेनदा मर्रिना बारेमते मंता. ओर दाविद राजाना वंसंमते पुटतोर. ");
INSERT INTO esg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","गानि मना सामि येसु किरिस्‍ते पेनदा मर्रि आंदुर इंचि हुप्‍सालय पेन दाना पवित्र आत्माता ताकतहेंदाल ओन हातोरा लोप्पोटाल मर्रा जीवाते तेहता. ");
INSERT INTO esg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","अंटोर लोकुल्‍क ओन विस्वासम कियना, ओर वेहताप ताकना इंचि पेन नावापोर्रो कुर्पा हुपिच्‍चि नाकुन येसुनहेंदाल प्रेरित इंचि निलाहता. ");
INSERT INTO esg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","येसु किरिस्‍तुना लोकुल्‍क आयनाहाटीं केयतोरव्टे मिमेटगुडा मंतिर. ");
INSERT INTO esg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","रोम सहरते मनना मीकु अंटोर्क ई सिट्‍टि रासि नना बतल वेहासेक इत्‍ते, पेनदुक मिमेट इत्‍ते वेल्‍लेन पावरम. इंका अद मीकुन दाना पवित्र लोकुल्‍क आयालय केयता. मना पेनबाबाल आनि येसु किरिस्‍तु सामिनहेंदाल मीकु कुर्पा, सांति दोर्कि. ");
INSERT INTO esg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","मोदाला नना मीकु वेहानद बतल इत्‍ते, मीवा विस्वासम बारेमते पूरा दुनियाक तेळियसि होत्‍ता. इदुन मति कीसेक मीवा अंटोराहाटीं येसु किरिस्‍तुनहेंदाल पेनदुक दन्यवाद कींतन. ");
INSERT INTO esg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","पेनदा मर्रिना बारेमता बेसता कबुरतुन वेहासेक, नावा पूरा मनसुनाल नना पेनदा सेवा कीसेक मंतन. ");
INSERT INTO esg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","नना पारतना कियानस्के बस्‍केळ्‍क मीकुन मति कींतन. दीनकु आ पेने गवाइ मंता. पेनदा इच्‍चा मत्‍ते, ई मल्का अयना मिहगा वायना हर्रि दोर्कि इंचि इल्‍हागुडा नना पेनदुक पारतना कीसेक मंतन. ");
INSERT INTO esg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","सामिनाहेंदाल नाकु दोर्कता आत्माता वराल्कुन मीतोनि पंचकुनना इंचि नावा इच्‍चा मंता. दीनहेंदाल मिमेट पेनदा बक्‍तिते गट्‍टिगा बेर्सकिर, अदुनहाटीं नना मिहगा वायालय हूळसंतन. ");
INSERT INTO esg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","इत्‍ते, मीकु-नाकु मनालोप्‍पो मत्‍ता विस्वासमताहेंदाल मनम वरोंक-वरोर प्रोत्‍साहन कीकुनना इंचि नावा मनसु मंता. ");
INSERT INTO esg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","विस्वासुल्‍कुनिटा! नना मीकु वेहानद बतल इत्‍ते, यहुदि आयवा लोकुल्‍कुंक बेसता कबुर वेह्‍चि ओर्क सहायम कीतन, अस्‍के ओर ओरा विस्वासमता पिस्वरते बेस बेर्सतुर. अल्हेन मिमेटगुडा मीवा विस्वासमता पिस्वरते बेस बेर्सना इंचि नना ऊके-ऊके मिहगा वायालय हूळुंदुन, गानि इदवेरादाका बतलन्‍ना-बतल अड्‍डम वासेक मत्‍ता, इद पोल्‍ले मीकु तेळियना इंचि नना वेहासेके मंतन. ");
INSERT INTO esg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","युनानि बासा, युनानि रीति-रिवाजकु तेळियतोर, तेळियवोर लोकुल्‍कुंक आनि करियतोर्क, करियवोर्क इल्‍हा अंटोर्के पेनदा पोल्‍ले वेहना जिम्मेदारि नावा पोर्रेन मंता. ");
INSERT INTO esg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","अदुनहाटीं रोम सहरते मनना मीकगुडा नना बेसता कबुर वेहालय तयार मंतन. ");
INSERT INTO esg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","विस्वासम कियना अंटोर्कुंक, इत्‍ते मुन्‍ने यहुदिल्कुंक पजा युनानि लोकुल्‍कुंक मुक्‍ति हियालय ई बेसता कबुरते पेनदा ताकत मंता. अदुनहाटीं नना पेनदा बेसता कबुर वेहालय सिग्गु अर्रोन. ");
INSERT INTO esg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","बारित्‍ते पेनदा मुन्‍ने मनकल नीतिमंतुड बल्हा आंतोर इत्‍ता पोल्‍ले बेसता कबुर मनाकु वेहंता. सुरुवनाल आकिरदाका विस्वासमतेन इद आया परंता. “नीतिमंतुल्क विस्वासमतोनि पिस्संतुर,” इंचि दर्मसास्‍त्रमते रासि मंता. ");
INSERT INTO esg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","बेसता कबुर अंटोर लोकुल्‍कुंक एविच्‍चना अव्‍सरम बारि मंता इत्‍ते, सत्‍तेम हर्दे ताकवा लोकुल्‍क कराब कबाह्‍क कीसि सत्‍तेमतुन दबांचि इरतुर. निजम पेन हिल्‍ले इत्‍ताप ताकसि, तप्‍पुड कबाह्‍क कीतुर. अदुनहाटीं पेन ओरपोर्रो स्वर्गमताल दाना होंगुन हुप्‍संता. ");
INSERT INTO esg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","निजमाता पेन दाना गुनाल्‍कुन अंटोर लोकुल्‍कुना मुन्‍ने हुपिस्ताहाटीं इव अन्‍नि पोल्‍लें ओर्क एर्के मंतां. ");
INSERT INTO esg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","बल्हा इत्‍ते, इद दुनिया पुटतस्केटाल पेन तयार कीता दुनियातुन हूळते, दाना बस्‍केने दिसुवा गुनम, बस्‍केळ्‍क मनना ताकत मनाकु दिसंता. अदुनहाटीं पेनदुन एरपाट किय्‍योम इंचि मनकालोर इना परुर. ");
INSERT INTO esg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ओर पेनदुन अय्ते एरपाट कींतुरे, गानि पेनदुन बल्हा अय्ते तल्‍सकुनागोम अल्हा तल्सकुन्‍नुर इंका दाना कदरगुडा किय्युर. अल्हा किय्यका ओर अट्‍टि विचाराल्क कीसि ओरा मनसुने हीकटा कीकुत्‍तुर. ");
INSERT INTO esg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","“मोमोट तेल्विगल्‍लोरम,” इंचि वेहकुंचि ओर बुद्‍दि हिल्‍वोरलेसीं आतुर. ");
INSERT INTO esg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","बस्‍केळ्‍क नासडेम आयाकोंटा मंदना महिमागल्‍ला पेनदुन ओर मोळ्‍कका, दाना जेगाते नासडेम आयना मनकानव, पिट्‍टेनव, जिवरासिनव आनि तरासुनलेह्का बेंगना जिवरासिना बोम्मां कीसि मोळ्‍कालय दल्‍गतुर. ");
INSERT INTO esg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","अदुनहाटीं ओरा मनसुने मत्‍ता बोगम विचाराल्कुन पूरा कीकुनालय पेन ओर्कुन होळसीता. अस्‍के ओर वरोना मेंदुल वरोंक कदर हिलाकोंटा बोगमतनाल्क कीतुर. ");
INSERT INTO esg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","पेनदा बारेमता सत्‍तेम पोल्‍ले आबद्‍दम आंद, इल्‍हा इन्कुंचि ओर्कुन तयार कीता पेनदुन मोळ्‍कका, अद तयार कीतवुन पेन इंचि मोळ्‍कालय दल्‍गतुर. गानि अवुन तयार कीता पेने बस्‍केळ्‍ताहाटीं तल्‍सकुननालायक मंता, आमीन. ");
INSERT INTO esg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","अदुनहाटीं पेन ओर्कुन ओरा मनसुंक वाता सिग्गु हिल्वा कबाह्‍क कियालय होळसीता. अस्‍के मुर्ताह्क मुय्दुरतोनि मींडानद होळसि, मुर्ताह्कुनतोनि मुर्ताह्के मींडसि बस्‍केने ओप्वा कबाह्‍क कियालय दल्‍गतां. ");
INSERT INTO esg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","अल्‍हेने मांड्‍सागुडा ओरा मुत्‍तोह्कुनतोनि मींडानद होळसि, मांड्‍सातोनि मांड्‍सा मुत्‍तो-मुय्दोनलेह्का मींडसि बोगमतनम कियालय दल्‍गतुर. इसोंटा बोगमतनम कीताहाटीं ओर्क ओरा पिस्वरते रोगाल्क-तकलिप वासि सिक्‍सागुडा दोर्कता. ");
INSERT INTO esg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","पेनदा सत्‍तेमता पोल्‍लेतुन ओर एरपाट कियालय हूळा हिल्‍लुर. अय्ते ओर बद कबळ कियमळ बेस आयो, अदे कबळ कियालय पेन ओर्कुन होळसीता. ");
INSERT INTO esg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ओरा लोप्पो अन्‍नि तीरकुना कराब कबाह्‍क, पगा, आस्‍ति, सीडातनम निंडिस होत्‍ता. चुगलीं कियमळ, कळ्‍क पोतमळ, हव्‍कमळ, जगडाल्‍क कियमळ, विरोद कियमळ, नळेह कियमळ इसोंटा गुनम निंडिस ओर इंकावरोना बारेमते कराब विचारम कियानोर आतुर. ");
INSERT INTO esg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","इंकावरोन तेंडसि पोहानोर, पेनदुन हय्सवोर, गर्रा कियानोर, पोंगुळ वळ्कानोर, कराब पोल्‍लें पुटिच्‍चनोर, तल्‍लुर-बाबोना पोल्‍ले केंजवोर; ");
INSERT INTO esg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बुद्‍दि हिल्वोर, हीता पोल्‍लेपोर्रो ताकवोर, जीवा नोयवोर, दया हिल्वोर आतुर. ");
INSERT INTO esg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","इसोंटा मनकालोर्कुंक पेनदाहेंदाल हामुरता सिक्‍सा तप्‍पो इंचि ओर्क एरपाट मंचिगुडा ओर इल्हे ताकंतुर. अचोने आयका अल्हा ताकानोर्कुन “बेस ताकसेक मंतिट,” इंचि मेच्‍चकुंतुर. ");
INSERT INTO esg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","अरे तप्पु दोसना लोकुरिटा, मिमेट बोरन्‍ना आम्टु! मिमेटगुडा अदे तप्पु कियानोर आंदिर. अदुनहाटीं इंकावरोन पोर्रो मिमेट तप्पु दोसमट. इल्‍हा वेरेतोरपोर्रो तप्पु दोस्‍सि, मीवद मिमेटे “दोसिर्क” इंचि हुपिच्‍कुंतिर. दानहाटीं वेरेतोरपोर्रो तप्पु दोस्‍सि मिमेट तपिच्‍कुना परिर. ");
INSERT INTO esg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","इसोंटा तप्पु कबाह्‍क कियानोरद पेन सत्‍तेमते न्‍यायम कीसि, ओर्क दगता सिक्‍सा हींता, इंचि मनाकु एरपाटे. ");
INSERT INTO esg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","अय्ते मिमेटे वेहाट! बव कबाह्कुनहेंका मिमेट वेरेतोरपोर्रो तप्पु दोस्‍संतिरो, अवे कबाह्‍क मिमेट कीसि, पेनदा सिक्‍साताल तपिच्‍कुंतोम इन्कुंचंतिरा? ");
INSERT INTO esg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","हिलाकोंटे दाना दया, ओप्के आनि मापितुन गम्मत इन्कुंचंतिरा? निजम बतले इत्‍ते, मिमेट मनसु मार्सकुनना इंचि पेने मीवापोर्रो दया हुपिस्‍ता, इद मीकु तेळियोना? ");
INSERT INTO esg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","गानि गट्‍टि मनसु, हेंडुतनमहेंका बस्‍केने मिमेट मनसु मार्सा हूळिर. इल्‍हा कीसि मीवा सिक्‍सातुन मिमेटे बेरसागोटसंतिर. बस्के अय्ते पेन दाना होंगुन मीपोर्रो हुप्पिचि, मीकु सिक्‍सा हिय्यार अस्‍के लोकुल्‍क दाना सत्‍तेमता न्‍यायमतुन हूळानुर. ");
INSERT INTO esg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","आ रोजुने पेन हरेक मनकना न्‍यायम ओर कीता कबाह्‍कुन हूळसि कींता. ");
INSERT INTO esg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","बोर अय्ते बस्‍केळ्‍क बेसता कबाह्‍क कीसेके, पेनदाहेंदाल कदर, दोसेम हिल्वा पिस्वरतुन दोर्किच्‍कुनालय हूळांतुरो पेन ओर्क बस्‍केळ्‍क पिस्सना पिस्वर हींता. ");
INSERT INTO esg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","गानि बोर अय्ते सत्‍तेमते ताकाकोंटा तप्‍पुड कबाह्‍क कीसेके सतताहाटीं पिस्संतुर, ओरपोर्रो पेन होंग आसि सिक्‍सा हींता. ");
INSERT INTO esg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","तप्‍पुड कबाह्‍क कियना हरेक मनकंक तिप्‍पल्‍क, दुक्‍काल्क वांतां. अव्टे मोदाला यहुदिल्कुंक, पजा युनानिर्कुंक. ");
INSERT INTO esg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","गानि अवे रोजकुने बेसता कबाह्‍क कीसेक ताकानोर्कुंक पेद्‍दातनम, कदर, सांति दोर्कार. अव्टे मोदाला यहुदिल्कुंक पजा युनानिर्कुंक. ");
INSERT INTO esg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","बारित्‍ते पेन मोकम हूळसि कबळ किय्‍यो. ");
INSERT INTO esg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","मूसाना नियम एरपाट हिल्वोर पापम कीते, मूसाना नियम परकारम सिक्‍सा आयाकोन्‍ना गानि सिक्‍सा अय्ते तप्‍पो. बोर अय्ते मूसाना नियम एरपाट मंचि पापम कीतुर, ओर्क मूसाना नियम परकारमे सिक्‍सा आंता. ");
INSERT INTO esg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","बारित्‍ते, सिराप मूसाना नियम केंजानोर पेनदा मुन्‍ने नीतिमंतुल्क आयुर, गानि मूसाना नियम केंजसि दान परकारम ताकानोरे पेनदा मुन्‍ने नीतिमंतुल्क आंतुर. ");
INSERT INTO esg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","यहुदि आयवोर्कुंक मूसाना नियम तेळियो. गानि ओक्‍कला ओरा मनसु मूसाना नियमते वेहताप मनानय्ते, ओर्क मूसाना नियम तेळियाकोन्‍ना गानि मूसाना नियम परकारम ताकतापे आंता. ");
INSERT INTO esg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","मूसाना नियमकु ओरा मनसुने रासि मंतां इंचि ओर कियना कबाह्के हुप्‍संतां. दीनकु ओरा पिस्वरगुडा गवाइ मंता. बारित्‍ते ओर तप्‍पुड कबळ कियनेंके ओरा मनसे “इद तप्पु” इंचि दोसेम दोसंता. अल्‍हेने बेस कबळ कियनेंके ओरा मनसे ओर्क “इद बेस” इंचि वेहंता. ");
INSERT INTO esg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","नना वेहना बेसता कबुर परकारम, बोर्क तेळियाकोंटा मनकालोर्क कीता कबाह्‍कुन पोर्रोटाल, अद रोजुने पेन येसु किरिस्‍तुनाहेंदाल लोकुल्‍कुना न्‍यायम किय्‍यार. ");
INSERT INTO esg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अय्ते इंदके मीवद मिमेट, “मोमोट यहुदिल्क” इंचि वेह्कुंतिर, मूसाना नियमपोर्रो विस्वासम इर्रंतिर, “मोमोट पेनदुक वेल्‍ले दग्गेटोर्कुम” इंचि पेद्‍दातनम वेह्कुंतिर, ");
INSERT INTO esg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","मिमेट मूसाना नियम करियसि मंतिर इंचि पेनदा इच्‍चा बल्हा मंता आनि बेस हर्रि बद्‍दु इंचि मीकु तेळियता. ");
INSERT INTO esg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","मिमेट इल्‍हा इंतिर गदा, “गुड्‍डिर्कुनलेसीं मनानोर्कुंक हर्रि हुप्‍संतोम, हीकटा पिस्वर पिसानोर्कुंक वेल्‍गुनलेसीं मनंतोम.” ");
INSERT INTO esg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","मूसाना नियमते रासि मत्‍ता पोल्‍लेंगें सत्‍तेम आनि तेल्वि हियानव इंचि मीकु तेळियताहाटीं, “मुर्कालोर्कुंक बुद्‍दि वेहानोरम, पिलाल्कुंक कराहनोरम,” इंचि मिमेट इनकुंतिर. ");
INSERT INTO esg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","अय्ते मरि वेरेतोर्कुंक कराहना पोल्‍लें मीवद मिमेटे बारि कराहकुनिट? “दोंगातनम कियमट” इंचि कराहचि मिमेटे दोंगातनम कींतिर. ");
INSERT INTO esg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","बोगमतनम कियामन्‍नि इंचि कराहचि, मिमेटे बोगमतनम कींतिर. बोम्मांक मोळ्‍का मन्‍नि इंचि कराहंतिर, गुळिते होंचि दोसकुंतिर. ");
INSERT INTO esg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","महगा मूसाना नियम मंता इंचि पेद्‍दातनम वेहकुंतिर गानि नियमते ताकका पेनदा कदरगुडा किय्‍यिर. ");
INSERT INTO esg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“मीवा इसोंटा कबाह्कुनहेंका यहुदि आयवोरा नड्‍डुम पेनदा अपमानम आंता,” इंचि दर्मसास्‍त्रमते रासिगुडा मंता. ");
INSERT INTO esg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","मिमेट मूसाना नियम परकारम ताकानय्ते, कतना कीतद मीकु पाय्दा आंता. गानि मिमेटगिंटा मूसाना नियम परकारम ताकाकोंटे मिमेट कतना कीसिगुडा बतल पाय्दा हिल्‍ले. ");
INSERT INTO esg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","बोरन्‍ना कतना कियवोर गिंटा मूसाना नियम परकारम ताकते, ओर कतना कियाकोन्‍नागानि पेनदा नदरते कतना कीतोना लेक्‍कातेन वांतोर. ");
INSERT INTO esg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","मूसाना नियम मिहगा मंचि दाना परकारम कतना आसिगुडा मिमेट नियम परकारम ताकसेक हिल्‍लिर. अदुनहाटीं बोरद अय्ते कतना आयाहिल्‍ले, यहुदि आयवोर, मूसाना नियम मत्‍ताप ताकानोर मीपोर्रो दोसेम दोस्‍सनुर. ");
INSERT INTO esg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","सिराप यहुदि जातिते पुटतोर, पलाताल कतना आतोर ईर निजम यहुदि मनकालोर आयुर. ");
INSERT INTO esg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","बोर अय्ते पेनदा इच्‍चा मत्‍ताप ताकंतुर ओरे निजम यहुदिल्क आंदुर. मूसाना नियम परकारम पलाताल आतदे कतना आयो, गानि पेनदा आत्माहेंदाल मनसु मारियता मनकालोरे निजम कतना आता यहुदिल्क आंदुर. इसंटा मनकालोर लोकुल्‍कुना कदरतुन आयो गानि पेनदा कदरतुन पहकंतुर. ");
INSERT INTO esg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","इद केंजसि, “अय्ते यहुदि आसि बतले पायदा हिल्‍लेना? कतनाकु इच्‍चोगुडा विलवा हिल्‍लेना?” इंचि मिमेट इनकुंतिर बारे. ");
INSERT INTO esg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","विलवा अय्ते वेल्‍लेने मंता. अद बल्हा इत्‍ते, पेन दाना पोल्‍लेन मोट्‍टा मोदाला यहुदिल्कुंके हीता. ");
INSERT INTO esg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","यहुदिल्कुना लोप्पो पेनदा पोल्‍ले केंजवोर इच्‍चुर मत्‍तुर. ओर अल्हा मत्‍तुर इंचि पेन विस्वासमतद आयो इनकुंचंतिरा? ");
INSERT INTO esg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","अल्हा आयापर्रो. लोकुल्‍क अंटोर आबद्‍दम वळकानोर आयिना, पेन मात्रम बस्‍केळ्‍क निजम मनंता. बारित्‍ते दर्मसास्‍त्रमते, “निमे वळ्कते नीवा पोल्‍ले निजम इंचि दिस अर्रंता, निमे न्‍यायम कियनेंके नीवा पोल्‍ले गेल्‍संता,” इंचि रासि मंता. ");
INSERT INTO esg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","मना तप्‍पुड कबाह्‍कुन हूळसि पेन बच्‍चोरो नीतिमंतुड इंचि एर्का आंता. इल्‍हा आतास्के पेन मनाकु सिक्‍सा हीसि अन्‍यायम कीसंता इंचि मनम इनकुना परंतोम. (इद नना मनकना विचारम मत्‍ताप वळ्‍कसंतन.) ");
INSERT INTO esg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","गानि अल्हा इनकुनमळ तप्‍पु आंद, अल्हा गिंटा पेन कीते, अद दुनियातोरा न्‍यायम बल्हा किय्‍यार? ");
INSERT INTO esg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","अचोने आयका, “मावा तप्‍पुड कबाह्कुनहेंदाल पेने सत्‍तेमतद इंचि तेळियसि दाना कदरगुडा वेल्‍लेन आसेके अय्ते, पेन माकुन पापिर्क बल्हा इना परंता?” इंचिगुडा इच्‍चुर लोकुल्‍क लोल्‍लि कींतुर. ");
INSERT INTO esg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","इल्‍हा कियानोर, “पापम कीते बेस जर्गसेक गदा! अय्ते दट पापम कीकोम,” इंचिगुडा इंतुर. इंका इल्‍हा मोमोटे कराहतोम इंचि इच्‍चुर लोकुल्‍क मापोर्रो दोसेमगुडा दोसंतुर. गानि अल्हा कियानोर अंटोर्कुंक, पेन दगता सिक्‍सा हींता. ");
INSERT INTO esg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","सरे! अय्ते मनम यहुदिल्कुम, यहुदि आयवोरकन्‍ना बेसतोर्कुमा? असले आयोम. बारित्‍ते यहुदिल्क आयिर, युनानिर्क आयिर. अंटोर पापम कीतोरे इंचि नना मीकु मुन्‍नेन वेहचि मत्‍तन. ");
INSERT INTO esg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","दर्मसास्‍त्रमतेगुडा इदुना बारेमते इल्‍हा रासि मंता गदा: “बोरे नीतिमंतुड हिल्‍लोर, वरोरगुडा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","निजम तेळियतोर बोरे हिल्‍लुर, वरोरगुडा हिल्‍लोर. पेनदुन पह्कानोर बोरे हिल्‍लुर. ");
INSERT INTO esg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","अंटोर पेनदा निजम हरदाल तप्‍सि तप्‍पुड हर्दुक होत्‍तुर. कबळ्‍क ओज्जनलायक बोरे हिल्‍लुर, बेसता कबळ कियानोर बोरे हिल्‍लुर, वरोरगुडा हिल्‍लोर. ");
INSERT INTO esg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ओरा तोळ्‍दाल पेय्‍सना पोल्‍लें, बोंदा कुल्‍ला मत्‍ते पीनगुना गब्‍बु बल्हा वांता अल्हा मंतां. ओरा तोळ्‍द