﻿USE sofia;
DROP TABLE IF EXISTS sofia.eseNT_vpl;
CREATE TABLE eseNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eseNT_vpl WRITE;
INSERT INTO eseNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiquio esohui etehueꞌyo Jesosa Quitoja etiiquiana. Yahuajo jama poa baꞌa: Dabi Jesosaja etiiquiana poa, Amajama peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eꞌe, jamaya poa: Amajamaja bacua ejja Isaaca bajjani poa. Isaacaja bacua ejja Jacobo bajjani poa. Jacoboja bacua Joda bajjani poa; echahua mese cuana enequia poa peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jodaja bacua cuana Panesi bajjani, pea Sana bajjani poa, Tamaja mejo poa. Panesija bacua Esomo bajjani poa. Esomoja bacua Anami bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Anamija bacua Aminanami bajjani poa. Aminanamija bacua Nasoni bajjani poa. Nasonija bacua Sanamo bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sanamoja bacua Bosi bajjani poa, Shajamija mejo poa. Bosija bacua Obeda bajjani poa, Shotija mejo poa. Obedaja bacua Isaiꞌ bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaija bacua emeshi mese Dabi poa. Dabija bacua Sanomoni bajjani poa. Sanomonija enaese eꞌahuemano poa, Oniaja quijjojea, Dabija huanaꞌyo poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sanomonija bacua Shobiami bajjani poa. Shobiamija bacua Abiase bajjani poa. Abiaseja bacua Asa bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaja bacua Josapati bajjani poa. Josapatija bacua Jonami bajjani poa. Jonamija bacua Osia bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiaja bacua Jotami bajjani poa. Jotamija bacua Acasi bajjani poa. Acasija bacua Esequia bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esequiaja bacua Manase bajjani poa. Manaseja bacua Amoni bajjani poa. Amonija bacua Josia bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaja bacua Jeconia bajjani poa; echahua mese cuana enequia poa peaꞌai. Jeconia nequinajejo, Babinonia dejja cuaa Isaeni cuana iña majje dojo ca poa oja meshi yasijje sosemaꞌ chaco meeya. ");
INSERT INTO eseNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Majoya Babinonia meshi yasijje dojo majje Jeconiaja bacua Sanati cuaya poa. Sanatija bacua Sonomame bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sonomameja bacua Amioni bajjani poa. Amionija bacua Eniaqui bajjani poa. Eniaquija bacua Asoni bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asonija bacua Sanoco bajjani poa. Sanocoja bacua Aquimi bajjani poa. Aquimija bacua Eniodi bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eniodija bacua Eneasa bajjani poa. Eneasaja bacua Matani bajjani poa. Matanija bacua Jacobo bajjani poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacoboja bacua Jose bajjani poa. Oya Maniaja yahue poa. Maniaja bacua Jesosa bajjani aca poa, Quito bajjani peaꞌai poa, Eyacuiñajjija huoojeaꞌyo ojjaña cuana jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jamajjeya Amajamaja bacua ejja tii majje jea ca poa pea. Majoya tii majje ohuaya pea jea ca poa. Jamaya aca poquiapoquia poa. Quijje nei etiiquiana Dabi cuaya poa. Etiiquiana Amajamaja jeaja osecua cuana 14 poa Dabi cuaya jjimahuajo. Majoya oya jayojja Dabija bacua ejja tii majje jea ca poa pea. Tii majje ohuaya pea jea ca poa. Quijje nei Dabija osecuaja jeaja osecua cuana 14 po majje, dejja mase cuaa etiiquiana cuana Babinonia meshi yasijje dojo ca poa. Majoya Babinonia meshi yasijje poqui majje oya jayojja aca poquiapoquia poa. Majoya quijje nei Jesosa Quito cuaya poa Joseja tii mee. Ma etiiquinaja jeaja osecua cuana 14 poa Jesosa Quito cuaya jjimahuajo. Eꞌe, jamaya poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesosa Quitoja ecuayaꞌyo jama poa baꞌa: Joseja Mania emese na poa. Mania bii ania poa; dejja cuana ba jjima poa. Jamatii oꞌejji poa. Eyacuiñajjija Edojjoshahua Pameya ebacua baꞌe mee ca poa, Maniaja ebacua. ");
INSERT INTO eseNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jose quea pame nee poa. Jamajjeya Mania oꞌejji poajo jjahuanaqui sa po ajja poa. Jjashahuabaquia poa jama baꞌa: —Eꞌe pojjaꞌa Mania pea cojjojji poanaje. Jamajjeya oya jjamejoquinaje. Eyaya oya cajaa aje. Quehuajje cajaa aje Mania, pea cuanaja ba jjima. Jamajjeya pea cuana Maniajo maimai ajja poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jamaya jjashahuabaquianijo Joseya cahuiba ca poa. Oe Eyacuiñajjija esohuidojojji miminaje onijje. Jama poanaje baꞌa: —Jose, ¡aꞌa Mania cajaa ajji! ¡Oya huanacue! Oja bacua Eyacuiñajjija Edojjoshahua Pameja baꞌe mee. ");
INSERT INTO eseNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ojaya ebacua cuayaje. Jamajjeya jiquio ebacua tii majje ojaya epeejji cuanaja mimishi cuijeaꞌyojji poaje. Jamajjeya ojaya ebajjani poaje Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eꞌe, Eyacuiñajjija esohui huohuijjija esohui yahuajo nei nei jayojjaya jjeya nei jamaya poani. Jamaya yahuajo poa baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Epona shoꞌi bii ani jamatii oꞌejji poanaje. Cuayajo oja bacua bajjani acaje Emanuel. Ese Ejjaja esohuijo ca jama baꞌa: Eyacuiñajji ecuana nijje nequi”. Jamaya Joseya cahuiba ca poa. ");
INSERT INTO eseNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Majoya shequiꞌyo majje Eyacuiñajjija esohuidojojjija esohuijo Mania huana canaje, Joseya. ");
INSERT INTO eseNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jamatii ebacua cuaya jjimajo, Joseja Mania napa jjima poa. Ebacua cuayajo Jesosa bajjani acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesosa cuayanaje Jodea meshijo, Benena cuiñajjijo. Cuayanajejo dejja Enode bajjani emeshi mese poa. Jamajjeya Jesosa Quito cuayanajejo, pea dejja cuana majametajo jjashahuaba neineiquiani, eshequi poeje mijijje meshijo baꞌe quea huesha nee poeyanaje Jenosanena cuiñajji yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Majoya oya cuanaa Enode huohuiꞌajja canaje jama baꞌa: —Emeshi mese, ¿achejo jaa ebacua eshoꞌi nei, ma Jodio cuanaja Emeshi Mese poajeꞌyo? Pea meshijo eshequi poeje mijijjejo nequi ojaya majameta ai quea jiji nee nee ecuaa banaje. Majoya ecuana poeyanaje o bihuiaa —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jama huohuiꞌajjame acajje emeshi mese Enode quea ajjajja nee nee poanaje. Ojjaña dejja cuana Jenosanenajo baꞌe peaꞌai quea ajjajja poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jamajjeya Enodeya ojjaña Eyacuiñajji nijje emimijji etii cuana, ojjaña Moisesija esohui etehueꞌyo huohuijji cuana peaꞌai iyaa canaje o que. Jama huohuiꞌajjame acanaje baꞌa: —¿Achejo shai cuayaje ebacua Quito? Oya Eyacuiñajjija huoojeaꞌyo ese jaahuanajji poajeꞌyo —acanaje Enodeya. ");
INSERT INTO eseNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Oya cuanaa huohui canaje jama baꞌa: —Quito Benenajo cuayaje, Jodea meshijo. Yahuajo nei nei huohui canaje Eyacuiñajjija esohui huohuijjiya jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Cuiñajji sisi Benena bajjani Jodea meshijo yani. Pea cuiñajji cuana quea quemo Jodea meshijo yani peaꞌai. Benena cuiñajji quea biso. Jamatii jomajo cuayaje Isaeni dejja cuanaja Emeshi Mese quea pame nee. Ohuaya Eyacuiñajjija epeejji cuana jaahuana cajeꞌyo”. Jamaya aca poa esohui huohuijjiya yahuajo nei nei —oya cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Emeshi mese Enodeya dejja cuana eshequi poeje mijijje baꞌe iyaa ca oꞌoyanaje o que. Quehuajje huohuiꞌajja canaje ebacuajo. Ma dejja cuaa huohui canaje ache mecajje majameta ai quea jiji nee nee ba coo canaje, ebacua cuayajo pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ebacuajo huohui mee majje Enodeya oya cuana huoojea canaje Benena huasijje ebacua baa. Jama huohui canaje Enodeya: —¡Poquicue miya! ¡Ebacua saꞌajja neineiquicue! ¡Baꞌyo majje poecue! !Eya huohuihuacue achejo ebacua jaa! Jamajjeya eya poquije peaꞌai ebacua bihuiaa —Enode siajje poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Emeshi mese Enodeya huoojea cajje ma dejja cuana poquinaje ejiojjijje. Ejiojjijo poquianijo majameta ai quea jiji nee eyajo ba ca oꞌoyanaje ehui dojojji, yahuajo jama. Majameta ai nequi cojja nei poquiꞌyonaje ebacua huasijje. Majameta jijinequinaje tii ebacua jaa cojja nei. ");
INSERT INTO eseNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Majameta jijiqui ba majje quea bihui nee nee poanaje oya cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Equi yasijje dobiquinaje. Ebacua Jesosa ba canaje enaese nijje, Mania nijje. Ba majje ebacua bihuia canaje ecuiꞌoshajjajo nequiya. Bashosoco pichojea majje aquiana quea nahue quia canaje ebacuaja. Mei huoꞌo quia canaje, shiyeshiye quea nahue quia canaje, esei quea shiye nee quia canaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Majoya ma dejja cuana jjacahuibaquianijo, Eyacuiñajji onijje miminaje jama baꞌa: —¡Aꞌa poqui oꞌoyajji emeshe mese Enode yasijje! Jamajjeya oya cuana poqui oꞌoyanaje oja meshi yasijje pea ejiojjijje. Enode banaꞌyo jjima aca poa. ");
INSERT INTO eseNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Majameta eba neineiꞌyojji dejja cuana poquiꞌyo majje Eyacuiñajjija esohuidojojji poeyanaje Jose que, Jose ecahuijaajo. Miminaje Jose nijje jama baꞌa: —¡Shequicue oe! ¡Nequisohuacue oe! ¡Ebacua, enaese peaꞌai dojocuajicue jjeyahua nei Ejito meshi yasijje! ¡Jomajo nequicue! Quijje eyaya miya huohuije miquea meshi yasijje epoe oꞌoyajji. Jjeya emeshi mese quea maseya Enode bajjaniya ebacua saꞌajja neinei cani equecuajeaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jose nequisohua majje ebacua, enaese peaꞌai dojocuaji canaje ejiojjijje Ejito meshi yasijje, mecashono. ");
INSERT INTO eseNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ejito meshijo nequiꞌyonaje emeshi mese Enode eshe nequijo. Enode manoꞌyajo Isaenija meshi yasijje poe oꞌoyanaje, Jose. Jamajjeya Eyacuiñajjija esohui huohuijjija esohui yahuajo nei nei jayojja jama poa. Eyacuiñajjija esohui tehue ca poa yahuajo nei nei jama baꞌa: “Ecuea ebacua Ejito meshijo baꞌe eyaya iyaaꞌyonaje”. ");
INSERT INTO eseNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Emeshi mese Enodeya ba canaje dejja majameta eba neineiꞌyojji cuanaa oya dasia ca poa. Jamajjeya oya quea quene nee nee poa. Oja sohuinano cuana huoojea caꞌya poa: —¡Ojjaña ebacua joya tonatona aiꞌai quecuajeaquicue! ¡Benenajo baꞌeja ebacua dejja shoꞌi cuana, Benena pejjejo baꞌeja peaꞌai oe quecuajeaquicue! Jamajjeya manoꞌyonaje ojjaña ebacua dejja shoꞌi daqui she becanejjijji peaꞌai epo tonatona aiꞌai, eshoꞌi nei peaꞌai. Eꞌe, majameta eba neineiꞌyojji dejja cuanaja ehuohuiꞌyojo, majameta ai quea jiji nee poanaje, ojjaña ebacua quecua sa poa Enode. ");
INSERT INTO eseNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eyacuiñajjija esohui huohuijji Jenemiaja esohui yahuajo nei nei jayojja jama aca poa Enodeya. Ebacua cuana quecua caꞌya poa jamaya. Jenemiaa aca poa jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Shama cuiñajjijo eyiyo aoꞌao cuiñajjijo quea shajjaquijjo. Ojjaña janobajjima nei nei pa tiitiiꞌyani. Jodio enaese cuana paꞌañani oja bacua cuana manoꞌyajo. Quea yeno nee nee. Papajeaꞌyo ajja”. Jamaya etehueꞌyo yahuajo nei nei poa. ");
INSERT INTO eseNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Emeshi mese Enode manoꞌyajo Eyacuiñajjija esohuidojojji poeyanaje Jose que, Jose cahuijaajo, Ejito meshijo baꞌejo. ");
INSERT INTO eseNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Huohui canaje jama baꞌa: —¡Nequisohuacue, oe! ¡Ebacua, ojaya enaese peaꞌai dojoꞌyocue Jodio meshi yasijje! Emeshi mese Enode manoꞌyonaje, ma ebacua Jesosa quecuaꞌyojji nisho poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jamajjeya Joseya nequisohua majje ebacua Jesosa, enaese peaꞌai dojo ca oꞌoyanaje oja meshi yasijje, Jodioja meshi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Enodeja bacua ejja Aquenao bajjani Jodea meshi mese eyacua poanaje. Jose jama shajjaꞌajja majje quea mete poanaje ma meshijo ebaꞌejji. Eyacuiñajjiya huohui canaje Jose jjacahuibaquianijo: —¡Janinea meshi yasijje poquicue, Jose! Jamajjeya Jose poquinaje Janinea meshi yasijje baꞌeꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasanena cuiñajjijo Jose baꞌenaje. Jamajjeya Eyacuiñajjija esohui huohuijjija esohui yahuajo nei nei jayojja jama poa baꞌa: “Quijje pishana oya Nasanenajo baꞌe dejja bajjani acaje”. ");
INSERT INTO eseNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesosa Nasanenajo baꞌyanijo, Huani, ona besameejji poani poeyanaje Jodea meshi yasijje. Dejja cuana meshi jabojo anica huasijje sohuihuohui huichaꞌa huichaꞌa canaje Huaniya. Jama acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—¡Miquea mimishi cuanajo quea yeno pocue; miquea mimishi cuana pajeaꞌyocue! Jjeya nei Eyacuiñajji poeje ojjañaja Emeshi Mese nei nei —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaiaa Eyacuiñajjija esohui huohuijjiya jama huohui ca poa yahuajo nei nei Huanijo baꞌa: “Oe dejja meshi jabojo nequi taaanequije. Jama poaje baꞌa: —Jiquio ecua Emeshi Cuiñajji nei neija ejiojji shabo jea cani jama, quea pojje nee nee acani jayojja jamaya ¡miquea ejjashahuabaquijji tai quea boejea nee nee aꞌyocue! Emeshi Mese nei nei poeje”. Jamaya Isaiaa yahuajo nei nei tehue ca poa. ");
INSERT INTO eseNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Huaniya huo ña, cameno ña oja sipi huosho canaje. Ejjayicaꞌaquijji ejee iya canaje. Shacui ijjia canaje, huini peaꞌai ishi canaje Huaniya. ");
INSERT INTO eseNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Quea huiso dejja cuana Jodea meshijo baꞌe, pea cuana Jenosanenajo baꞌe peaꞌai, pea cuana cuei Jodana sahuajo baꞌe peaꞌai Huani que poeyanaje o shajjaꞌajjaa. ");
INSERT INTO eseNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Oya cuana quea mimishi poanijo quea yeno poani. Jamajjeya oja mimishi cuana huohui caꞌyonaje. Mimishi cuana pajea sa poanijo, Huaniya oya cuana Eyacuiñajji nijje epoꞌyojji besa mee canaje Jodana cueijo. ");
INSERT INTO eseNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jodioja esohui huohuijji Paniseo bajjani cuana, Sanoseo dejja cuana peaꞌai poeyanaje Huani que; Eyacuiñajji nijje ejjapeequiꞌyojji nisho besaꞌyo sa poani peaꞌai. Huaniya oya cuana ba majje tecuea canaje. Jama acanaje baꞌa: —Miya peyo jama, jjadasiaquiani. ¿Aya acuae mi huohui canaje? Jama baꞌa: “¡Eyacuiñajjijo besa meecue! Jamajjeya ojaya miquianaya enapaꞌyojji pojjeama”. ");
INSERT INTO eseNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chojja. ¡Quea pame tii oe baꞌeꞌyocue! ¡Mimishi cuana oe pajeaꞌyocue; aꞌa quea jjashahuabaqui tai po oꞌoyajji! Jamajjeya miya Eyacuiñajjija enapajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aꞌa jjashahuabaquijji jama baꞌa: “Amajama ecuanaja etiiquiana. Oya quea pame nee poanaje. Ecuana Amajamaja bacua poanijojo, Eyacuiñajjija enapajji pojjeama”. Chojja de. Miquiana Amajamaja bacua quea mimishi poanijo, Eyacuiñajjiya cajaa mi acajeꞌyo. Eꞌe de, ohuaya pea Amajamaja bacua jayojja epojji pana cajeꞌyo pojjaꞌa mei, meshi pojjaꞌa —Huaniya acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Jama baꞌa: Acui tai sajja jajacajja cajeꞌyo cuaqui cabojjiya. Ejjajja chamajo acui cajaa acajeꞌyo. Jajajeaꞌyo majje dahuajea cajeꞌyo. Dejja mimishi acui tai jayojja jama acajeꞌyo Eyacuiñajjiya; cuaqui yasijje jea cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Eyaya miquianaya Eyacuiñajjijo besa meejeꞌyo enajo, ca mique mimishi cuana epajeaꞌyojo. Quijje pishana poeje Quito. Ohuaya mi que Eyacuiñajjija Edojjoshahua Pame dobiqui mee cajeꞌyo. Jamajjeya miya quea pame poajeꞌyo. Mimishi cuana pajea sa poꞌyo ajjajo ca ca jeajea cajeꞌyo cuaqui yasijje. Jamaya peaꞌai baꞌa: Quito oe nei quea caꞌa nee nee nequi. Eya ca iña quea caꞌa pishana nequi. Jamajjeya eya ca iña onijje nequi sa po ajja miquiana que cojja. Quea bicho. ");
INSERT INTO eseNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Dejjaa oja tepeya shaa dojo mee majje anoso iya caꞌyani equijo; eshaa dahuajea cani. Jiquio ecua anoso shaa dojo mee cani jama eseya acajeꞌyo Eyacuiñajjiya. Joya quea pame nee baꞌyani jaahuana cajeꞌyo tii. Mimishi cuana ca ca quiyojea canequijeꞌyo tii tii. ");
INSERT INTO eseNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Majoya Jesosa Janinea meshi yobijo ani macua huasijje poꞌoquequinaje Jodana cuei yasijje Huani que. Jesosaa Huani ba majje jama acanaje baꞌa: —Huani, ¡eya besa meecue Eyacuiñajjijo, miyaya! ");
INSERT INTO eseNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","—Chojja, Emeshi Mese —Huani poanaje—. ¡Miyaya eya besa meecue Eyacuiñajjijo, miya quea pame nee neejo! ¿Yajjajje miya e que poeꞌyonaje? Eya ca ca iña quea pame pishana, de. ");
INSERT INTO eseNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—¡Eyaya huohuiaña jama miyaya aꞌyocue! ¡Jamajjeya Eyacuiñajjija ehuohuiꞌyo ejo acue! —Jesosa poanaje. Jamajjeya Huaniya Jesosa besa mee canaje Eyacuiñajjijo. ");
INSERT INTO eseNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Huaniya Jesosa besa mee majje jjequicuaya caꞌyajje, ba canaje eyatahuatahua caꞌapejo canaje. Eyacuiñajjija Edojjoshahua Pame huiaꞌ jama o sapa biajje cuabesa baꞌenaje. Ecapashinei baꞌeoquenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eyacuiñajjiya oja Bacua Ejja jama acanaje baꞌa: —Miya ecue Bacua Ejja quea jea nee nee. Eya mijo quea bihui nee nee poani. ");
INSERT INTO eseNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jjeyahua nei Edojjoshahua Pameya Jesosa quima huasijje meshi jabo huasijje huoojea canaje. Majoya Edosiquiaa Jesosa quea mimishi po mee sa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesosa jomajo nequinaje peaja ejiojji cahui huisome, 40 cahuime. Mahuiso epojja, mecajje peaꞌai nequinaje quimajo bobimaꞌ nei nei. Majoya quea shoe poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Majoya aje Edosiquiana poeyanaje Jesosa que; miminequinaje jama baꞌa: —Miya Eyacuiñajjija Bacua Ejja jjabaqui majje ¡miyaya jiquio mei cuana pahui jayojja acue, miquea eꞌijjiajji! ");
INSERT INTO eseNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Chojja de. ¡Bacue Eyacuiñajjija esohui etehueꞌyo! Jama poani baꞌa: “Dejja cuana bobijo caꞌa po majje pojjeama baꞌe tiitiijeꞌyo. Ojjaña Eyacuiñajjija esohui jayojja jama añajo ca se ca quea pame nee baꞌe tiitiijeꞌyo”. Jamaya aca poa —jamaya Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Majoya Edosiquiaa Jesosa dojo canaje Jenosanena huasijje. Jomajo Eyacuiñajjija equi quea ao nee nee yasijje nequisohuaqui mee canaje; equi jamacoo biajje nequi mee canaje. Jama acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Miya Eyacuiñajjija Bacua Ejja jjabaqui majje ¡tohuaacue meshi yasijje! Jamajjeya Eyacuiñajjija esohui jama etehueꞌyo jaa baꞌa: “Eyacuiñajjiya esohuidojojji cuana huoojea caje mi yasijje, mi jaahuanaa. Oquequiajo ojaya emeya miya iñajjequisohua cajeꞌyo, ohuaya. Jamajjeya miya ejjajiojji quecuasajaqui jjima poaje meijo”. ");
INSERT INTO eseNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesosa onijje miminaje jama baꞌa: —Chojja. Yahuajo jama Eyacuiñajjija esohui etehueꞌyo peaꞌai baꞌa: “Aꞌa jama ajji baꞌa: —¿Aꞌa eꞌe jojo nei Eyacuiñajjiya oja sohui acajeꞌyo pojjaꞌa? ¿Aꞌa eya Eyacuiñajjiya jaahuana nei cajeꞌyo? ¡Cabaꞌajjasahua! —aꞌa pojji”. Jamaya yahuajo nei Moisesiya tehue ca poa —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Majoya Edosiquiaa Jesosa dojosohuaqui canaje eyiyo ao huasijje. O shajjaꞌajjajji nisho jamaya Edosiquiaa Jesosa huohui canaje: —¡Bacue ojjaña meshi cuana, emeshi mese cuana peaꞌai, cuiñajji cuana, aquiana quea nahue cuana peaꞌai! Ojjaña quea pame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ojjaña jiquio aquiana cuana, dejja cuana peaꞌai miquea poajeꞌyo; miya Emeshi Mese nei nei eyaya po meejeꞌyo jjeya nei ca miyaya eya bihuiaꞌyajo ecuiꞌoshajjajo nequi majje —jama siajje ameya acanaje Edosiquiaa Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jamajjeya Jesosaa jama huoojeajeame acanaje baꞌa: —¡Chojja Edosiquiana! Eyaya miya bihuia ajja, de. ¡Poquicue miya! Jamaya Eyacuiñajjija esohui etehueꞌyo yahuajo peaꞌai baꞌa: “¡Eyacuiñajji oe nei bihuiacue! Oya oe nei ojjañaja Emeshi Mese nei nequi. ¡Ojaya esohui jama oe acue!” ");
INSERT INTO eseNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jamajjeya Jesosaa huoojea cajje Edosiquiana, Satanasa poquiꞌyonaje. Majoya Eyacuiñajjija esohuidojojji cuana quea huiso poeyanaje Jesosa jaahuanaa, bobiaa peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quijje pea cuaa Huani, ma ona besameejji poa jeanobiajea canaje. Shajjaꞌajja majje Jesosa posohuaqui oꞌoyanaje oja meshi yasijje, Janinea meshi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Oya nequiñaqui jjima Nasanenajo. Pea cuiñajji yasijje, Capenaoma huasijje poquinaje baꞌeya. Janinea bae sahuajo, Samononi meshi, Netani meshi peaꞌai pejjejo baꞌenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yahuajo nei nei Eyacuiñajjija esohui huohuijjiya Isaiaa huohui ca poa jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Ojjaña cuana quea mimishijo, esohui ba jjimajo quea apo baꞌyani. Eyacuiñajji ba majje oya cuana quea jaꞌa nee baꞌe mee cajeꞌyo. Eyacuiñajji ojaya ba jjimajo quea yeno nee baꞌyani. Jjeya ca ca quea jaji nee baꞌe mee cajeꞌyo. Eꞌe, Samononi meshijo, Netani meshi peaꞌaijo, Janinea bae sahuajo baꞌeca cuana, Cueji Pashi ma Jodana cuei bajjani sahuajo, ojje baꞌeca cuana, Janinea meshijo, pea bajjani Ese Ejja sohuijo baꞌa: Eyacuiñajji ba po jjimaja meshijo baꞌeca cuana peaꞌai quea mimishi poanaje. Jjeya ca ca quea jaꞌa nee baꞌe mee cajeꞌyo”. Jamaya Isaiaa huohui ca poa yahuajo nei nei Jesosaja epoejjijo. ");
INSERT INTO eseNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Majoya Jesosaa esohui huohui canaje jama baꞌa: —Jjeyahua nei Eyacuiñajji miquea Emeshi Mese nei poeje. Jamajjeya ¡miquea mimishijo quea yeno pocue! ¡Mimishi cuana pajeaꞌyocue miquiaaya! —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Majoya Jesosa poquinaje Janinea bae sahua huasijje. Jomajo ohuaya Anesi, Anesija oꞌi Peno bajjani, ma Simohui peaꞌai bajjani ba canaje. Oya cuana nahuoo cuiashajajji nei nei bajio. Nahuoo cuiashaja cani. ");
INSERT INTO eseNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesosaa oya cuana iyaa canaje: —¡Enijje poꞌyocue! Eyaya miya dejja cuana jjequi meesahuaꞌyojji ajeꞌyo e que. ");
INSERT INTO eseNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jjeyahua nei nei oya cuana ojaya eshajajji cuana jeanaꞌyo majje onijje poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Majoya Jesosaa poqui pishana majje pea cuana ba canaje. Semeneoja bacua ejja Jacobo ba canaje ojaya echahua mese nijje, Huani nijje. Bishe aijo eshajajji jeꞌeꞌyo poꞌani ba canaje. Jjeyahua nei Jesosaa oya cuana iyaa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jamajjeya Jesosaa iyaa cajje oja chii Semeneo bishejo ani tii jiña caꞌya poa cuaa Jesosa nijje epoquiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesosa poquinaje ojjaña cuiñajji cuana huasijje Janinea meshijo. Jodio dejja cuanaja equi ojee ejjachichaquijji yasijje dobiquinaje esohui huohuiya. Jama poanaje baꞌa: —Eya ojjañaja Emeshi Mese poajeꞌyo. Ohuaya quea huiso emanojaa cuana jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Quea huiso Sinia meshijo baꞌeca cuaa Jesosaa huaquia mee caꞌyoqui shajjaꞌajja canaje peaꞌai. Jamajjeya o que jjequi canaje quea huiso emanojaa cuana. Eꞌe, ojjaña cuana quea nee poani, pea cuana niñepoqui cuana, jjequiꞌihuicajaa cuana peaꞌai, jiojjijjajja cuana peaꞌai o que jjequi canaje. Ojjaña cuana huaquia mee caꞌyonaje, jjaaja meequi caꞌyonaje, Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jamajjeya Jesosa poquianijo, quea huiso nee nee cuana ojee poquinaje onijje. Eꞌe, dejja cuana quea huiso nee, ponaponaña peaꞌai Janinea meshijo baꞌe cuana, Jenosanenajo baꞌe cuana, Jodea meshijo baꞌe cuana, pea Ome miji peaꞌai Cuiñajjijo baꞌe cuana, Cuei Cueji Pashijo Jodana cuei ojje mijijje baꞌe cuana peaꞌai; quea huiso nee nee Jesosa nijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dejja quea huiso cuana ba majje Jesosa eyiyo huasijje jaasohua pishanaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jomajo anioque majje ojjaña cuana sohuihuohui canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—¡Bacue! Beca cuana jjashahuabaquiani jama baꞌa: “Eꞌe, de, eya quea mimishi nee. ¡Eyacuiñajjiya ecuea mimishi cacuijea caꞌyahua!” Jamaya jjashahuabaquianijo Eyacuiñajjiya oya baꞌe tiitii mee cajeꞌyo onijje eyajo. ¡Oya cuana quea bihui nee capoꞌyahua! ");
INSERT INTO eseNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Oja epeejji cuana mimishijo quea yeno poanijo, Eyacuiñajjiya quea bihui nee po mee cajeꞌyo mimishi cuijea caꞌyajje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ojaya epeejji cuana quea bei poani Eyacuiñajjija quea jea nee; onijje baꞌe tiitii mee cajeꞌyo. ¡Quea bihui nee capoꞌyahua oya cuana! ");
INSERT INTO eseNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Ojaya epeejji cuana Eyacuiñajjija esohui jayojja jama a sa neinei poanijo, Eyacuiñajjiya oya cuana quea jaji nee nee baꞌe meesahua cajeꞌyo. ¡Quea bihui nee capoꞌyahua oya cuana! ");
INSERT INTO eseNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Ojaya epeejji cuana pea cuanajo jjashahuabaquiani pea jaahuanajji. Jamaya poanijo pea cuaa, Eyacuiñajjiya peaꞌai oya cuana jaahuana cajeꞌyo. Tecueꞌama poajeꞌyo ona nijje. ¡Eꞌe jojo nei quea bihui nee capoꞌyahua ojaya epeejji cuana! ");
INSERT INTO eseNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ojaya epeejji cuana mimishi cuana aꞌajjajo Eyacuiñajji nijje baꞌe tiitiijeꞌyo. ¡Quea bihui nee capoꞌyahua oya cuana! ");
INSERT INTO eseNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ojaya epeejji cuaa pea cuana quea bei po meesahua canijo, ojjañaja eba oya cuana Eyacuiñajjija bacua cuana eꞌe jojo nei; quea pame nee. ");
INSERT INTO eseNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ojaya epeejji cuana quea jaꞌa nee baꞌyanijo, onaaya oya cuana cuia cajeꞌyo. ¡Jamatii oya cuana quea bihui nee capoꞌyahua! Eꞌe, quijje eyajo oya cuana ojjaña huoojeaꞌyojji enijje poajeꞌyo —Jesosaa huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Majoya Jesosa Quitohua ojaya epeejji cuana huohui canaje jama baꞌa: —Miquianaya ecuea epeejji poanijo, pea cuana minijje mimijajije; miya napa caje peaꞌai, siajje poaje mijo peaꞌai. Jamatii Eyacuiñajjiya miquianaya quea bihui nee po mee cajeꞌyo. Eyajo onijje baꞌe tiitii mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Eꞌe, Eyacuiñajjija esohui huohuijji yahuajo nei nei baꞌya poa cuana jamaya aca poa mimishi cuaa; napa ca poa peaꞌai. Jamajjeya ¡ona jayojja jama pocue, quea bei! Eyacuiñajjiya miquianaya ojee baꞌe mee cajeꞌyo tiitii eyajo quea bihui nee nee —Jesosaa huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Ecuea esohui jayojja jama añajo, pea cuana mi jayojja jama baꞌeje quea pame nee peaꞌai. Jamajjeya miya sane jama, mei sese jama. Mei seseya shicui cajje bobi ihuiꞌyo ajja poani. Jamatii mei sese seseꞌama poa jojjemo ¿aꞌa quea sese po meeje oꞌoya? Chojja. Seseꞌamajo quea huesha jeajeaꞌaña seya. Jiquio ecua sane seseꞌama jeajeaꞌaña seya jama miya ecuea esohui jama po ajjajo, cajaa achanaꞌ eyaya. ");
INSERT INTO eseNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Enijje jjapeequianijo miquianaya cuaquijiji jama. Cuiñajji emaco aoꞌaojo nequi ba caje cuaa quea huesha nee mecajje peaꞌai. Jiquio ecua emacojo nequia jama ecuea epeejjiya pea cuana Eyacuiñajji ba meesahua cajeꞌyo enijje jjapeequianiya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Cuaquijiji sisi capaca ajja. Chojja. Cuaquijiji sisi nequia cajji acui biajje, ojjaña equijo ani cuana jeajaꞌajji. ");
INSERT INTO eseNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","¡Jiquio ecua cuaquijijiya ojjaña equijo ani jeajaꞌa cani jayojja jama quea pame nee baꞌecue! Jamajjeya miquianaya quea pame ba majje pea cuanaa Eyacuiñajji, esejaya Chii eyajo bihuia cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesosaa pea esohui huohui canaje jama baꞌa: —Eyaya Moisesija esohui yahuajo etehueꞌyo cajaa aꞌajja. Eyacuiñajjija esohui huohuijji cuanaja esohui yahuajo nei eyaya cajaa aꞌajja peaꞌai. Cho. Eya poeyanaje onajaya esohui jama aꞌyohua. Eꞌe, oya cuaa yahuajo nei nei ejo huohui ca poa. Jjeya eyaya onajaya esohui jayojja jama ajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eꞌe jojo nei ojjaña Moisesija esohui cuana cajaa pojjeama poajeꞌyo. Ojaya esohui biso nei peaꞌai cajaa pojjeama poajeꞌyo. Quea pame nee ani tiitiijeꞌyo. Jamajjeya ojjaña ojaya esohui yahuajo nei nei etehueꞌyo jama ajeꞌyo. Ojjaña apoa ajeyoꞌyo majje ecuea echacojji jiquio meshijo apoa poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jamajjeya joya Moisesija esohui etehueꞌyo jama baꞌe sa po ajjajo, oja sohui jama pojjeama huohui cajo, enijje baꞌe meemee ajja quijje eya ojjañaja Emeshi Mese nei poajo. Joya Moisesija etehueꞌyo jama acani, oja sohui jama huohui cani peaꞌai ca ca enijje baꞌejeꞌyo quijje eya ojjañaja Emeshi Mese oe nei poajo. ");
INSERT INTO eseNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¡Bacue! Moisesija etehueꞌyo huohuijji poani, Jodioja esohui huohuijji Paniseo bajjani cuana peaꞌaiya quea pame nee huohui ajja; quea pame baꞌe ajja peaꞌai. Jamajjeya miquiana ona jama baꞌyajo, ona jama huohuiajo peaꞌai miquianaya baꞌe ajja enijje quijje eya ojjañaja Emeshi Mese nei poajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Miquea eba Moisesija etehueꞌyo yahuajo jama baꞌa: “¡Aꞌa pea quecuajji!” Jamajjeya pea quecuajji epo dojo cajeꞌyo cuaa emeshi meseja dejja huoojeajji yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","¡Jjeya ecuea esohui eyacua shajjaꞌajjacue oe! Ojjaña joya pea nijje quea quene nee nee poani aje oe emeshi mese yasijje poquije. Quea tecue poaje emeshi mese onijje. Joya pea nijje mimijajiajo, “miya cajaa” acajo, cadojo cahua emeshi meseja esohui huohuijji cuana huasijje jjabahuejjaqui meeya. Joya pea nijje panajaji neineiyajo, cajaa nei nei acajo peaꞌai cuaqui yasijje huoojea ca chanaꞌ peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Eꞌe pojjaꞌa miya Eyacuiñajjija equi yasijje poquiani aquiana quiaꞌyohua Eyacuiñajji bihuiajji. Ma aquiana quiaꞌyo jjimahuajo ¡jjashahuabaquicue miquea epeejjijo! ¿Aꞌa miquea epeejji quea yeno poani minijje miya quea tai añajo? ");
INSERT INTO eseNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","¡Jamajjeya miquea epeejji yasijje poquicue! ¡Onijje mimiquicue! ¡Quea bei minijje po mee oꞌoyacue! ¡Majoya miquea aquiana quiaquicue Eyacuiñajji bihuiajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—¡Pea cuana quea quene minijje poajo o que poquicuajicue! ¡Quea bei po mee oꞌoyacue jjeya nei! Ohuaya miya dojo ca chanaꞌ emeshi mese yasijje, napa meeya. Emeshi meseya miya huoojea ca chanaꞌ sohuinano huasijje. Sohuinanohua miya equi ejjajeanobiaquijji yasijje jeanobia ca chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jomajo nequi tiitii mee caje. Ma minijje quea quene nee poanaje sosequiajeyoꞌyo majje miya ejeanobianequi jeacuaya cajeꞌyo, de —Jesosa poanaje—. ¡Jiquio jayojjaya oe pocue! ¡Jamajjeya Eyacuiñajji nijje jjapeequicuajicue manoꞌyo jjimahua, cuaqui yasijje jeajea jjimahua! ");
INSERT INTO eseNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Cuanaya miquea eba Moisesija etehueꞌyo jama baꞌa: “¡Aꞌa pea cojjojji pojji!” ");
INSERT INTO eseNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jjeya ecuea esohui eyacua shajjaꞌajjacue jama baꞌa: Dejja pea eponajo jjashahuabaquianijo oya pea cojjojji epojji jayojja jama poani, ojaya ejjashahuabaquiꞌyojjijo; quea mimishi poani. ");
INSERT INTO eseNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jamajjeya ¡aꞌa quea mimishi pojji! Miya quea mimishi poani epona, aquiana pojjaꞌa baqui majje ¡maya bapajeaꞌyocue! Jea ba majje mimishi po majamajañajo cuaqui yasijje dobiquijeꞌyo tii. Jamajjeya ¡aꞌa jea bajji! ");
INSERT INTO eseNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Peaꞌai miya quea mimishi poani aquiana emeya napañajo ¡aꞌa aquiana napajji! Quea mimishi po chanaꞌ; cuaqui yasijje dobiquiꞌyo chanaꞌ. Jamajjeya ¡aꞌa onaja aquiana napajji! Sii chanaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Moisesija etehueꞌyo jama poa peaꞌai baꞌa: “Dejjaa ojaya ehuanase cajaa acajo, huei canijo ¡esohui catehue cahua ehueijji!” ");
INSERT INTO eseNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","¡Ecuea esohui eyacua shajjaꞌajjacue! ¡Aꞌa miquea ehuanase pea dejjaja sii jjima hueijji! Epona quea pame baꞌe hueiꞌyo majje pea dejja nijje jjahueaquiajo, yahue ebionei eshe nequijo, quea mimishi po mee cani ebionei yahueya. Oya eshe enequijojo oja yahue eyacua quea mimishi poani peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Moisesija etehueꞌyo jama poa peaꞌai baꞌa: “Miyaya huohuiaña jama baꞌa: —Eyacuiñajjiya eya shajjaꞌajja canijo, eꞌe jojo nei eyaya ecuea esohui jama ajeꞌyo. ¡Jamaya mimi majje miquea esohui jama acue; aꞌa pajeaꞌyojji!” ");
INSERT INTO eseNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","¡Jjeya ecuea esohui eyacua shajjaꞌajjacue! Jama baꞌa: ¡Aꞌa oe siajje pojji! ¡Pea nijje mimi majje miquea esohui jayojja jama acue! Jamajjeya pea nijje mimianijo aꞌa huohuijji jama baꞌa: “Eyacuiñajji eshe eyajo yanijo, ecuea esohui jama eyaya ajeꞌyo. Ecuea esohui eꞌe nei pojjeama jojjemo eya quea nee po mee caꞌyome”. Cho. Eyajo Eyacuiñajji ejjahuoojeaquijji tii tii. ");
INSERT INTO eseNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jamaya aꞌa mimijji peaꞌai baꞌa: “Meshi yanijo, oe po jjimajo ecuea esohui jama eyaya ajeꞌyo. Ecuea esohui eꞌe nei pojjeama jojjemo meshi jjani yasijje eya mojea caꞌyome”. Cho. Meshi cuana miquea pojjeama; Eyacuiñajji Emeshi Mese oe nei poani. Jamaya aꞌa mimijji peaꞌai baꞌa: “Jenosanena yanijo, oe po jjimajo ecuea esohui jama eyaya ajeꞌyo. Ecuea esohui eꞌe nei pojjeama jojjemo Jenosanena cuiñajji esecue yasijje mo huoojeacuaya caꞌyome”. Cho, Jenosanena miquea pojjeama; Eyacuiñajji Jenosanena Meshi Mese poani. ");
INSERT INTO eseNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jamajjeya aꞌa huohuijji miyaya: “Ecuea esohui eꞌe nei pojjeama jojjemo camano mee caꞌyome”. Chojja. ");
INSERT INTO eseNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jamajjeya huohuicue jama baꞌa: “Eꞌe, eyaya jama ajeꞌyo”. “Chojja eyaya jama aꞌajja” acue —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Miquea eba Moisesija etehueꞌyo jama peaꞌai baꞌa: “¡Peaa cojja cuiasejjajea cajje jjasosequiaquicue; cojja cuiasejjajea peaꞌaicue! ¡Peaa seꞌ cuiasajajea cajo seꞌ cuiasajajea peaꞌaicue!” ");
INSERT INTO eseNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ecuea esohui eyacua ca ca jama baꞌa: Onaaya miya napa cajje ¡aꞌa jjashahuabaquijji onijje ejjasoseaquijji! ¡Mique shemo ebianei mijijje cuia cajje shemo shani mijijje cuia mee oꞌoyacue! ");
INSERT INTO eseNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Peaa miquea daqui sa poanijo miya dojo cani dejja etii bajjani yasijje huohuiya; miquea daqui dojo cajo, jamatii ¡miquea daqui moo quiacue peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dejja maseya miya iña cajje ojaya aquiana quea huesha pishana dojo mee cajo, ¡quea huesha nee dojocue, jamatii! ");
INSERT INTO eseNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pea Ese Ejja miquea aquiana sa neinei poanijo ¡aꞌa quea dejja tai pojji! ¡Aꞌa quea nishehui pojji! ¡Oya quiacue! Pea cuana miquea aquiana dojo sa poanijo ¡oe pojji cahuime dojo meecue! Minijje mimiajo: “¡Che iña jiquio dojo meecue; quijje aje jje jeahuajeꞌyo!” acajje; “¡Eꞌe, dojocue!” sajaꞌame acue. Jamajjeya ¡ojjaña cuana nijje quea bei baꞌecue! ¡Aꞌa o jayojjaya quea mimishi, quea tai pojji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Miquea eba etehueꞌyo yahuajo nei jama baꞌa: “¡Miquea epeejji quea jea nee acue! Miquea epeejji pojjeama, cho. ¡Onijje quea quene pocue epeejji pojjeama jjejojo!” ");
INSERT INTO eseNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ecuea esohui eyacua ca ca jama baꞌa —Jesosa poanaje—: ¡Miquea epeejji pojjeama quea jea nee acue peaꞌai! Miya Eyacuiñajjija epeejji poanijo, miya napa cajje ¡Eyacuiñajji nijje mimicue maa mi napajji poanijo! Jamajjeya eꞌe pojjaꞌa oya cuana Eyacuiñajji nijje jjapeequijeꞌyo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jamaya poanijo miquianaya Eyacuiñajji eseja Chii eyajo anija bacua cuana poani. Eꞌe, Eyacuiñajjiya eshequi quea jaꞌa nee jiji mee cani dejja quea pamejo, dejja quea mimishijo peaꞌai. Ohuaya ena huoojea cani dejja quea pame neeja que shepajji, dejja quea mimishija que shepajji peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Joya mi quea jea nee ajji poani miquea quea jea nee peaꞌai; minijje quea mase ca ca miquea botiꞌama. Eyacuiñajjija epeejji pojjeama cuana aje oe jamaya poani peaꞌai, de. Jamajjeya miya jamaya poanijo ¿aꞌa Eyacuiñajjiya miya bihuia caje? Cho. ");
INSERT INTO eseNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Miquianaya aje jja oe miquea epeejji cuana nijje quea bei nee mimiani, pea cuana nijje mimi ajja. ¿Aꞌa jamaya poani ojjaña dejja cuana? Eꞌe. Eyacuiñajjija epeejji pojjeama cuana aje oe jamaya poani peaꞌai, de. ");
INSERT INTO eseNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jamajjeya esejaya Chii eyajo quea pame nee ani. Ojjaña cuana Eyacuiñajjija quea jea nee nee. ¡Eyacuiñajji jayojjaya jama pocue quea bei nee nee! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesosa poanaje peaꞌai: —¿Apiojji miya Eyacuiñajjijo chacochacoani pea cuaa ba canijo? Eꞌe pojjaꞌa jjashahuabaquiani miya bihuia caje cuaa ba majje. Onaja ebajji chacochacoanijo, quijje eyajo miquea echaco ojo Eyacuiñajjiya miya bihuia ajja, esosequiajji pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Aquiana aema huasijje quiaꞌyo majje aꞌa mimijji jama baꞌa: “¡Bacue, eya quea pame nee poani!” Chojo. Jamaya poani Eyacuiñajjija epeejji nisho cuana Eyacuiñajjija equijo, ejiojji cuanajo peaꞌai. Onaaya Eyacuiñajjijo chaco cani pea cuanaja ebajji. Jamajjeya quijje eyajo Eyacuiñajjija oya ebihuiajji pojjeama; ojaya echaco esosequiajji pojjeama peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","¡Miyaya aema huasijje aquiana cuana quehuajje quiacue! Jamajjeya ¡miquea epeejji neineija ba jjima quiacue! ");
INSERT INTO eseNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Miquea Chiiya eyajo aniya ca ca oe ba caje; ohuaya miya quijje sosequia cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesosaa o shajjaꞌajjajji cuana huohui canaje pea jama baꞌa: —Eyacuiñajji nijje mimianijo ¡aꞌa joya ecua Eyacuiñajji nijje jjapee nishoquiani jayojja jama mimijji! Oya cuana aje oe Jodioja ojee ejjachichaquijji equijo nequiani, ojjañaja ebajji miminequiani. Esecuejo ojjaña anica cojja nei peaꞌai miminequiani. Eyaya miya eꞌe jojo nei huohuiaña oya cuana miminishonequiani —Jesosa poanaje—. Jamajjeya Eyacuiñajjija epeejji nei poso ojjañaa oya ba cani. Jamajjeya onaaya bihuia canaje sosejje Eyacuiajji nijje miminishoꞌaninajejo quijje eyajo oya cuana enijje enequiꞌyojji pojjeama, Eyacuiñajjija epeejji nisho jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","¡Miquianaya ca ca miquea equi quecuayijjijo mee nei mimiꞌanicue Eyacuiñajji nijje, pea cuaa eba ca poani jjejojo! ¡Eseja Chii nijje jomajo mimicue! Ohuaya miya ba cani, shajjaꞌajja cani; mi pejjejo nequiani oya. Esejaya emimi bame bame jayojja jama acajeꞌyo, eseja Chiiya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Pea cuana Eyacuiñajji ba jjimajo eyacuiñajji nisho nijje mimiani. Oya esohui majamaja acani. Mimi majamajani eyacuiñajji nishohua eshajjaꞌajja caje poso. ");
INSERT INTO eseNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","¡Aꞌa o jayojja jama pojji! Eyacuiñajji nijje mimi sa po jjimahuajo, ojaya esejaya ejjashahuabaquijji eba, de, eseja Chiija eyajo anija —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Jamajjeya Eyacuiñajji nijje mimianijo mimicue jama baꞌa: Eyacuiñajji, miya ecuanaja Chii quea bame nee. Miya eyajo quea caꞌa nee ani. ¡Ojjaña cuaa miya cabihuia cahua, oe nei quea jaꞌa nee! ");
INSERT INTO eseNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Miya ojjaña cuanaja Emeshi Mese poani tii tii. Eyajo miquea ejjashahuabaquiꞌyojji jayojja jama poani ojjaña. ¡Jamaya oe pocue ojjaña meshijo peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","¡Jjeya eya baꞌe meesahuacue! ");
INSERT INTO eseNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Eya queneꞌama pea cuana nijje, joya enijje quea mimishi poani nijje. Jamajjeya ¡ecuea mimishi cuanajo aꞌa quea quene pojji peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","¡Aꞌa eya quea mimishi po meejji! ¡Nahue neineicue mo, Eyacuiñajji! ¡Edosiquianaja epeejjijo eya jaahuanacue! Eꞌe Eyacuiñajji, miya ojjañaja Emeshi Mese poani tii tii. Miya oe nei quea caꞌa nee enequi tii tii, quea pame nee. ¡Ojjañaa miya cabihuia cahua tii tii! Eꞌe, jamaya apoa ecuea emimi. ¡Jamaya Eyacuiñajji nijje mimicue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Eꞌe, ¡jiquio ecua eya jama jjashahuabaquime oe pocue! Pea cuana nijje mimicue jama baꞌa: “Miya enijje mimijajinaje quea tai. Jamatii eya miquea mimishijo queneꞌama” jamaya pocue. Jamaya pea nijje mimianijo Eyacuiñajji miquea mimishijo queneꞌama poajeꞌyo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pea nijje quea quene tii tii poanijo ca ca Eyacuiñajji eseja Chii miquea mimishijo quea quene tii tii poajeꞌyo peaꞌai; miquea mimishi ecuijeaꞌyojji pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Eyacuiñajjija epeejji nisho ijjiaꞌijjia jjima mimianijo quea yeno jayojja poani, ecojja topo jjima ojjaña cuanaja ebajji. Jamajjeya ojo jama poani baꞌa: “Eꞌe, oya Eyacuiñajjija epeejji nei nei; ijjiaꞌijjia jjima mimiani Eyacuiñajji nijje, de” poani —Jesosa poanaje—. Chojja, edasiaꞌyojji poani. Eyacuiñajjija epeejji nei poso pea cuaa acani. Jamajjeya ojjañaja ebajji oya mimiani. Quijje oya cuana enijje enequiꞌyojji pojjeama eyajo Eyacuiñajjija epeejji nisho jjejojo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Miquianaya ca ca ecuea epeejji nei. Ijjiaꞌijjia jjima Eyacuiñajji nijje mimianijo ¡aꞌa quea yeno jayojja pojji! ¡Aꞌa jjadasiaquijji jayojja jama pojji! Chojja —Jesosa poanaje—. Ijjiaꞌijjia jjima Eyacuiñajji nijje mimi huichaꞌa huichaꞌanijo ¡jamatii emeꞌ, ecojja peaꞌai shacuacue; ehuojjaña shiyeshiyejo shacue! ");
INSERT INTO eseNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","¡Jamajjeya onaja ba jjima Eyacuiñajji nijje mimicue ijjiaꞌijjia jjima ani! Jamajjeya eseja Chiiya ohuaye nei miya ba caje, mi pejjejo nequiya. Miquea emimi bame bame jayojja jama acaje, ohuaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Jiquio meshijo baꞌyanijo ¡aquiana echichaꞌyo quea huisojo aꞌa quea nahue bajji! —Jesosa poanaje—. Siipojjiya miquea aquiana sii ca chanaꞌ. Mojo ca chanaꞌ. Seeꞌyo chanaꞌ peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cho. ¡Jjeya Eyacuiñajjijo chacochaco neineicue! Eꞌe jojo nei ohuaya quijje miya sosequia cajeꞌyo quea huiso nee nee eyajo. Esiiꞌyojji pojjeama; miquianajaya poajeꞌyo tii, miquea ebaꞌeꞌyojji eyajo. ");
INSERT INTO eseNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eꞌe, jamaya jjashahuabaquiajo miquianaya quea jaꞌa baꞌejeꞌyo, ecuea ehuohuiꞌyo jayojja jjashahuabaquije eyajo ebaꞌeꞌyojjijo; aquiana quea huiso yanijo ca ca miquianaya jjashahuabaquije meshijo ebaꞌejjijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","—Miquea ecojja quea pame nee neejo miya quea jaꞌa nee bajeꞌyo echacojji; quea jaꞌa nee baꞌejeꞌyo peaꞌai. Cojja jamajama ca ca quea jaꞌa ebaꞌejji pojjeama. Quea apo nee nee, de, cojjamaꞌ —Jesosa poanaje—. Jiquio ecua quea cojja pame nee jayojja jama miya quea jjashahuabaqui pame nee neejo quea jaꞌa nee baꞌejeꞌyo Eyacuiñajjija ejjashahuabaquiꞌyojji jayojja. Quea jjashahuabaqui tai poanijo onaja aquiana cuana quea jea ba majje ca ca quea dejja tai baꞌejeꞌyo, quea nishehui. Jamajjeya Eyacuiñajjiya miya tecuea cajeꞌyo jama baꞌa: “Miya ca mi ca oe quea tai nee nee baꞌyani, ejo jjashahuabaqui ajja” acajeꞌyo Eyacuiñajjiya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Cuanaya ¿aꞌa acuae chacochaco cajji beca dejjaa meeꞌajja cajje? Chojja. Oe echacomeejji shajjaꞌajja caje, quea boti acaje peaꞌai. Pea echacomeejji shajjaꞌajja jjima acaje, botiꞌama acaje peaꞌai. Jamaya miquianaya aquiana cuanajo jjashahuaba tiitiiquianijo Eyacuiñajjijo echacojji pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jamajjeya Jesosaa huohui canaje pea jama baꞌa: —Eꞌe jojo nei eyaya miya huohuiaña: ¡Aꞌa quea yeno jjashahuaba tiitiiquijji miquea ebaꞌejjijo! “Eꞌe pojjaꞌa eya bobimajo manojeꞌyo, bobi yasijje poajeꞌyo; eꞌishijji pojjaꞌa chamaꞌ poajeꞌyo, quea naba taja; ecuea daqui huiñaje pojjaꞌa, daquimaꞌ nei nei eya poajeꞌyo”. ¡Aꞌa jamaya jjashahuabaquijji! Eyacuiñajjiya miya eshe pana canaje, yamijji. Jamajjeya ohuaya miya bobi quia meesahua caje, daqui quia meesahua caje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Eꞌe de, ¡bacue cuichojji cuana! Quea jaji baꞌyani. Oya cuanaa que chaco ajja, bobi chicha ajja, equi yasijje iya ajja quijje eꞌijjiaꞌyojji. Eseja Chiiya oya cuana jaahuana cani. Cuichojji ojaya nahueꞌama; miya ca ca oe ojaya quea nahue nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¡Jjashahuabaquicue! ¿Aꞌa miya quea ao nee epoaje poso jjashahuaba neineiquianijo miya tii aojeꞌyo? Chojja. Jamatii. Jamajjeya oya jayojja aquiana chamaꞌ epoaje poso ¡aꞌa quea mete pojji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—¿Apiojji miya jjashahuabaquiani quea yeno daquijo? ¡Bacue eshasha ebiojo tiiani! Shasha cuana chaco ajja, oja daqui cuana soco ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jamatii quea bame nee nee nequiani. Jodioja emeshi mese yahuajo nei nequiya Sanomo bajjaniya daqui quea nahue nee nee huosho ca poa; jamatii oja daqui quea bame pishana. Shasha ca ca quea bame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Eꞌe —Jesosa poanaje—, Eyacuiñajjiya shasha cuana tii mee cani quea bame nee. Jjeya shasha cuana enequi; mecahuajje yaaꞌyani, jocaꞌyani; dahuajea cani cuaa pojjaꞌa, chamaꞌyo tii poani. Jiquio ecua Eyacuiñajjiya shasha quea bame nee pohua mee cani jamaya ohuaya eꞌe jojo nei miya baꞌe meesahua cajeꞌyo. Miya ojaya quea boti nee nee. Miquianaya jjashahuaba taiquiani jama baꞌa: “Eꞌe pojjaꞌa Eyacuiñajjija eseya jaahuana jjima” jamaya miquianaya poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Aꞌa jjashahuaba taiquijji jama baꞌa: “¿Aꞌya cuee che ijjiaje, de? ¿Aꞌya cuee ishije, de, chamaꞌ ena? ¿Aꞌya cuee che huoshoje?” ");
INSERT INTO eseNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Eyacuiñajjija epeejji pojjeama cuana ojjaña aquianajo jjashahuabaquiani tii tii. Eyacuiñajjijo jjashahuabaqui ajja. Eꞌe jojo nei esejaya Chii eyajo ani miquea aquiana ebaꞌe meejjijo jjashahuabaquiani. Ohuaya miya jaahuana cajeꞌyo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jamajjeya jjashahuabaquicue tii tii jama baꞌa: “Quijje Eyacuiñajji ojjañaja Emeshi Mese po majje onijjeya eyaya pea cuana huoojeajeꞌyo eyajo. ¡Ojaya esohui quea jaꞌa jayojja jama caꞌaꞌyahua!” acue —Jesosa poanaje—. Jamaya jjashahuabaquianijo ohuaya miquiana huasijje aquiana ebaꞌe meejji quia meesahua cajeꞌyo peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—Jamajjeya aꞌa quea yeno jjashahuabaquijji jama baꞌa: “¿Aya shai ecuana jaahuana caje mecahuajje?” Miya Eyacuiñajjiya jaahuana cajeꞌyo. Quijje quea camaja ebaꞌejji poaje pojjaꞌa. Jamatiiya ohuaya miya baꞌe meesahua cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—¡Aꞌa pea niñebajji! —Jesosa poanaje peaꞌai—. Jamaya Eyacuiñajjija botiꞌama. ");
INSERT INTO eseNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Miya pea cuana niñebajji poanijo Eyacuiñajjiya miya tecuea cajeꞌyo peaꞌai. Miquiana pea nijje jjabeiquiꞌyajo Eyacuiñajjiya miquianajaya mimishi cuijea cajeꞌyo. Ma ecua miyaya onaya aña, jamaya miya acajeꞌyo Eyacuiñajjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—¿Apiojji acuae jja oe miquea epeejji tecueaña soꞌo ca mimijajijjiya? ¿Aꞌa miquianaaya mimishi pajeaꞌyonaje pea tecuea jjimahuajo ojaya mimishijo? Chojja, miya ca mi ca oe mimijajipajeaꞌyo jjima peaꞌai. Jamaya miya poani baꞌa: Miyaya baña huenihueni shabo biso nei nei miquea epeejjija ecojjajo nequi. ¿Aꞌa cuae jja oe miyaya miquea ecojja dojjojo nequi huenihueni shabo quea quemo baña soꞌo? ¡Miquea ecojjajo nequi huenihueni shabo quea quemo jja oe huijjeajea meecue! ");
INSERT INTO eseNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Aꞌa jiquio jama mimijji baꞌa: “Epeejji, huenihueni shabo biso neiya mi cojja dobi canaje. Ache baꞌajja cahuijjeaꞌajjaꞌyo sahua, de shabo biso nei”. Chojja. Shabo quea quemo nee miquea ecojjajo nequi, miya quea cojja shojo poanijo ca jje ca ebajji pojjeama. Miya ca mi ca oe ma shabo miquea ecojjajo nequi ¡ebionei huijjeajea meeꞌyo socue! ¡Majoya shabo biso nei nei miquea epeejjija ecojjajo nequi huijjeajeaꞌyocue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Miquea aquiana quea nahue nee nee ¿aꞌa quiaña iñahuehua huasijje, cuichi yasijje peaꞌai? Aquiana nahue quishipasha cajeꞌyo, de. Oya cuana quea mase; ijjia ca chanaꞌ mi. Jamaya poani dejja jjashajjaꞌajjaqui ajja nei nei; quea mase iñahuehua jama, cuichi jama. Jamajjeya ¡ona huasijje Eyacuiñajjija esohui quea pame nee aꞌa huohui tiitiijji! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesosa jama poanaje peaꞌai baꞌa: —Jama acue baꞌa: ¡Mimi neineicue Eyacuiñajji nijje! Onijje mimianijo ohuaya miya jaahuana cajeꞌyo. Cuanaya aquiana chamaꞌ ba majje saꞌajja neineiaña ¡jama mimi neineimeya pocue Eyacuiñajji nijje! Ohuaya miya shajjaꞌajja cajeꞌyo. Cuanaya esecuejo nequiya miyaya taaaña miquea epeejji nijje emimijji. Esecuejo nequi taaa tiitii nequiani jayojjaya ¡Eyacuiñajji nijje mimi majamajacue! Ohuaya miquea esohui jayojja jama acajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Eꞌe jojo nei onijje mimianijo Eyacuiñajjiya jaahuana cajeꞌyo; o sa neinei poanijo ohuaya miya sajaꞌa cajeꞌyo. Esecuejo taaa nequi jayojja jama pocue; ohuaya miya sajaꞌa cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Ebacua ejja oja chii nijje jama mimime poajo baꞌa: “Ecue chii, ¡che mo oe pahui quiacue eꞌijjiꞌajji!” acajo, ¿aꞌa oja chiiya mei quia caje? Chojja. ");
INSERT INTO eseNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Ecue chii, ¡che mo oe jai quiacue eꞌijjiꞌajji!” acajo, ¿aꞌa oja chiiya peyo quia cajeꞌyo? Chojja. ");
INSERT INTO eseNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jamajjeya miquianaaya, jamatii quea mimishi jjashahuabaquianiya miquianajaya bacua cuana jaahuanaña. Jamajjeya esejaya Chii eyajo aniya miya jaahuana cajeꞌyo eꞌe jojo nei onijje mimianijo. Oya ca ca oe quea pame nee nee enequi tii tii —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Miya mimiani pea nijje jama baꞌa: “¡Enijje quea pame nee po tiitiiꞌyocue!” Jamajjeya ¡pea cuana nijje quea pame nee po tiitiiꞌyocue! Eꞌe, jamaya yahuajo Moisesija esohui etehueꞌyo poa. Jamaya Eyacuiñajjija esohui huohuijji yahuajo nei baꞌya poa peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jesosaa huohui canaje pea jama baꞌa: —¡Esecue biso neijje dobicue! ¡Ejiojji biso neijje poquicue, ma eyahuasijje epoquijji ejiojjijje! Jomajo baꞌe tiitiijeꞌyo eseya. Eyacuiñajjija esohui ejiojji pame jayojja. Eya ejiojji esecue jayojja peaꞌai poani —Jesosa poanaje—. Oe pojji cuana Eyacuiñajjija ejiojjijje poquiani, de. Pea esecue ejiojji aiꞌaijje epoquijji. Ma ejiojji aiꞌaijje poqui majje cuaqui yasijje poquijeꞌyo. Jamajje quea huiso poquiani ejiojji aiꞌaijje, de —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesosa jama poanaje peaꞌai baꞌa: —¡Esohui huohuijji nishoja esohui aꞌa shajjaꞌajjajji! Dasia ca chanaꞌ mi. Mi que poeje jjapee nishoquiya. Oya cuana quea bei jayojja poeꞌani. Cho, quea bei pojjeama. Aquiana quea mase jama poani oya cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","¡Quea mimishi poanijo bahuejjacue oya cuana esohui huohuijji nisho! ¿Aꞌa acuae acuisha jjonojo acuijjajja quea pame baꞌyani? Cho. ¿Aꞌa shaponajo acuijjajja quea pame chicha cani? Cho. ");
INSERT INTO eseNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jamaya esejaya eba baꞌa: Acui quea pamejo acuijjajja quea bame. Acui quea taijo ejjajja quea tai poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Acui quea pamejo acuijjajja quea tai pojjeama baꞌyani. Acui quea taijo ejjajja quea bame pojjeama baꞌyani. ");
INSERT INTO eseNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Acui taijo ejjajja quea tai poani. Jamajjeya jajajeaña seya, dahuajeaꞌyaña seya. ");
INSERT INTO eseNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Acui eseya baje ejjajja ba majje. Acui quea tai ba majje esejaya eba acui quea tai. Jama jayojja esohui huohuijji quea mimishi ba majje eseyaya oya esohui huohuijji nisho bahuejjaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Quea huiso dejja cuana huohui cani jama baꞌa: “Jesosa Quito, miya ecuanaja Emeshi Mese eꞌe jojo nei”. Chojja, beca cuana siajje poani. Ecue Chii eyajo anija ejjashahuabaquiꞌyojji jayojja jama po ajja. Jamajjeya oya cuana ecue Chii eyajo ani yasijje poquiꞌyo ajja. Pea cuana eꞌe jojo nei ecue Chiija ejjashahuabaquiꞌyojji jama poani. Oya cuana poquijeꞌyo ecue Chii eyajo ani yasijje, ojaya Emeshi Mese nei yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quijje e poe oꞌoyajo quea huiso cuana siajje poaje enijje jama baꞌa: “Ecuea Emeshi Mese, Eyacuiñajjiya eya huoojea canaje miquea esohui huohuiya. Ohuaya eya eshahua huoojeacuayajea meesahua caꞌyonaje. Ohuaya eya ameesahua canaje ma dejjaa ajjima acani”. Quijje jiquio jayojja jama acajeꞌyo siajjepojjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Majoya eyaya oya cuana tecuea neineijeꞌyo jama baꞌa: “Chojja. Miquianaya enijje jjapeequiꞌyo jjima. ¡Miña ca oe poquicue quea huesha nee! Quea mimishi, quea mimijjequijea ca miña” ajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Joya beca cuaa ecuea esohui shajjaꞌajja majje jamaya acajeꞌyo. Ojaya ejjashahuabaquiꞌyojji quea pame nee. Jamajjeya jiquio ecua equi quea caꞌa emacojo iyaña jayojja jama jjashahuabaquime oya poani. ");
INSERT INTO eseNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ena quea quemo poajo, jjayehuequiyajo beni quea quemohua equi jeaquena cani. Jamatii equi quea caꞌa emacojo ani; jaabicha jjima acani. ");
INSERT INTO eseNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pea cuaa ecuea esohui shajjaꞌajja ajja. Ecuea esohui jayojja jama aꞌajja peaꞌai. Oya cuana quea jjashahuabaqui quehua jayojja jama poani, equi quea quemo iya cani meshijajijo jama. ");
INSERT INTO eseNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ena quea quemo poajo ohua caje. Beni quea quemohua po majje equi janobajjima nei jeabichajea cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesosaa eyiyo quibojo esohui huohui ca poa. Apoa po majje dejja quea huiso cuana shajjaꞌajja majje jama poanaje baꞌa: —Eꞌe de, Jesosaa esohui quea jaꞌa nee nee huohui cani. ");
INSERT INTO eseNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ohuaya huohui cani emeshi mese jayojja jamaa, Moisesija esohui etehueꞌyo huohuijji jayojja jama pojjeama, de —poanaje ojjaña cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Majoya Jesosa eyiyo biajje ani esohui huohuipajea majje jaaoqueꞌyonaje. Quea huiso dejja cuana poquinaje onijje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Oe dejja quea mano nee, batata epoꞌyo poeyanaje Jesosa que. Ecuiꞌoshajjajo nequinaje o bihuiajji. Jama poanaje baꞌa: —Jesosa, ecuea eba miya ona jjajeaqui meeꞌyojji nei nei poani. Jamajjeya miyaya eya jjajeaqui meeꞌyo sa amajje ¡mo che jjajeaqui meeꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesosaa ma dejja napaꞌajja canaje emeya. Jama miminaje onijje baꞌa: —Eꞌe, eyaya miya jjajeaqui meeꞌyo sa aña. ¡Jjajeaquiꞌyocue miya! Jjajeaquinanaꞌyonaje jjeya nei. ");
INSERT INTO eseNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jamajjeya Jesosaa oya huohui canaje: —¡Shajjaꞌajjacue mo! Eyaya miya jjajeaqui meeꞌyonaje. Jamatii ¡aꞌa jjeya pea cuana huohuijji! ¡Poquicuajicue Jenosanena huasijje, Eyacuiñajjija equi yasijje, Eyacuiñajji nijje mimiani yasijje! Oya huohuicue miyaya: “Eya huaquiaꞌyonaje, jjajeaquiꞌyonaje mo” acue. ¡Moisesija esohui jayojja jama oe pocue peaꞌai! Miya ehuaquiaꞌyohua jjejojoya ¡Eyacuiñajji nijje mimiani yasijje beca huiaꞌ quiaquicue Eyacuiñajji bihuiajji! Jamajjeya ojjañaa ba caje miya eꞌe jojo nei ejjajeaquiꞌyo —oya acanaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Quijje Jesosa Capenaoma huasijje poquiꞌyonaje. Jomajo oe dejja sohuinano quea huiso nee, 100 huoojeajji poani Jesosa que poeyanaje. Oya pea, Jodio dejja pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ohuaya Jesosa huohui neinei canaje jama baꞌa: —Jesosa, ecuea epeejji, ¡shajjaꞌajjacue mo che! Ecuea echacojji poani quea mano nee nee ecuea equijo jaa. Jeoꞌyo ajja poanaje. Quea yami nee nee jaa —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesosaa oya sajaꞌa canaje jama baꞌa: —Eꞌe, eya poquije miquea equi yasijje miquea echacojji poani huaquia meeꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Chojja, Jesosa —sohuinano huoojeajji poanaje—. Miya Jodio dejja quea pame nee nee poanijo ¿apiojji ecuea equi yasijje dobiquije? Eya Jodio pojjeama; quea pame pojjeama. Miya jjahuaquiameequiꞌyojji nei nei. Jamajjeya ecuea echacojji quea huesha jaa. ¡Miyaya jiquiojo tii nequiya huohuicue! ¡Huaquia meeꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eꞌe, jamaya poani baꞌa: Pea emeshi mese cuaa eya huoojea cani. Ojaya esohui jama eyaya aña. Peaꞌai eyaya sohuinano cuana huoojeaña. Eya huoojeajje poquije. Eya iyaajje pea sohuinano poeje. Eya huohuiajje ecuea echacojji chacochacoje ejo. Jamajjeya miya huohuiajje ecuea echacojji jjaajaquijeꞌyo, de. ");
INSERT INTO eseNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Shajjaꞌajja majje Jesosa quea bihui nee nee poanaje. Ojjaña cuana huohui canaje: —¡Shajjaꞌajjacue! Jiquio dejja Jodio pojjeama. Jamatii Eyacuiñajji nijje jjapeequiani eꞌe jojo nei. Miya ca mi ca oe, oe pojji jjashahuabaquiani Eyacuiñajjijo. ");
INSERT INTO eseNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eꞌe de, quea huiso dejja cuana Jodio pojjeama ojjaña meshijo baꞌe enijje jjapeequijeꞌyo. Eyajo eya Emeshi Mese oe nei poaje, oya cuana ojee ijjiaꞌijjiaje Jodio etiiquiana cuana nijje, Amajama nijje, Isaaca nijje, Jacobo peaꞌai nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Beca Jodio cuana ca ca jjashajjaꞌajjaqui ajja jjejojo enijje ebaꞌejji pojjeama. Eyacuiñajjiya oya cuana jeacuayajea cajeꞌyo quea misi nee yasijje. Jomajo pa neineijeꞌyo. Quea yenohua jjejojo eseꞌ ijjiayaijea cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jamajjeya sohuinano huoojeajji acanaje: —¡Poquicue miya miquea equi yasijje! Miquea eba eya ejjaajaquimeeꞌyojji nei nei. Jamajjeya eyaya miquea echacojji jjaajaqui meejeꞌyo. Jesosa mimianijo tii sohuinanoja echacojji jjaajacuajiquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Majoya Jesosa poquinaje Penoja equi yasijje. Penoja ano ba canaje quea quiyo nee nee jaa. ");
INSERT INTO eseNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Emanojaa meꞌ napa cajje jjaajaquiꞌyonaje. Boe cananaꞌyonaje. Jamajjeya anisohuaꞌyo majje Jesosa, pea cuana peaꞌai bobia canaje, Penoja anohua. ");
INSERT INTO eseNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Majoya aje oe sinecua dejja cuaa quea huiso niñepoqui cuana Jesosa que ye canaje. Jesosaa eshahua cuana huoojeacuayajea caꞌyonaje: —¡Cuayaquiꞌyocue, oe! —poanaje. Jesosa mimi jeahuajo, o niñepoqui po meejji poani cuayaquinananaje. Ojjaña emanojaa cuana jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje peaꞌai, Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jamaya poanijo Jesosa Isaiaja esohui yahuajo nei jayojja jama acaꞌyonaje. Isaia Eyacuiñajjija esohui huohuijji yahuajo nei nei Jesosa Quitojo jama poa baꞌa: “Ohuaya ecuana quea mano poanijo, quea nee peaꞌai poanijo, quea jaji nee po mee caꞌyonaje; huaquia mee caꞌyonaje”. Isaiaa jamaya aca poa yahuajo nei nei Jesosa Quitojo. ");
INSERT INTO eseNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pea pojjajo quea huiso dejja cuana Jesosa que jjachichaquinaje. Poqui sa poanijo Jesosaa ojaya epeejji cuana huohui canaje: —Cuaꞌa ¡bae ojje miji yasijje besapoquicue! ");
INSERT INTO eseNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Poqui jjimahuajo oe dejja Jesosa que poeyanaje, Moisesija etehueꞌyo huohuijji poani. Ohuaya Jesosa huohui neinei canaje: —Miya esohui huohuijji quea pame nee. Eya miquea epeejji nei poajeꞌyo. Minijje tii eya poꞌayequi sa poani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesosaa oya sajaꞌa canaje jama baꞌa: —Eꞌe pojjaꞌa, de. Eya ojjaña cuanaja Edoe Mese poani. Jamatii ecuea equi chamaꞌ ejomishocajji, de. Samao ca ca oja jjanijo cahuijaa. Cuichojji cuana peaꞌai oja ejajo cahuiani. Jiquiojo ecuea equi chamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Majoya Jesosaja pea epeejji poeyanaje o que. Ohuaya Jesosa huohui canaje: —Ecuea esohui huohuijji, eya ecue chii cuiña poaje soꞌo. Oya etii nei nei. Quijje oya manoꞌyajo ohuajeajeꞌyo. Majoya aje mo oe minijje poquijeꞌyo chacochacohua. ");
INSERT INTO eseNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Chojja —Jesosaa oya sajaꞌa canaje—. Pea cuaa, Eyacuiñajjija epeejji pojjeama cuaa mique chii cacuiña cahua; ohuaya camojea cahua manoꞌyajo. ¡Jjeyahua nei enijje poꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Majoya Jesosa bishe ai yasijje nequisohuaqui majje ojje besapoquinaje. O shajjaꞌajjajji cuana nijje besapoquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","O besapoquianijo beni quea quemo nee nee poeyanaje. Enashajohua bishe nanejea canaje. Jeasohuajea canaje. Bishe ai yiyedojjojo Jesosa cahuijaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","O shajjaꞌajjajji cuaa Jesosa ishe acanaje. Jama poanaje baꞌa: —Emeshi Mese Jesosa, ¡shequicue oe! ¡Coya aje se huiꞌiꞌya! —taaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Shequiꞌyo majje Jesosaa oya cuana sajaꞌa canaje: —¿Apiojji acuae nequiana quea mete nee nee poani? ¿Aꞌa mi ejo eꞌe nei pojjeama poani? Jamaya mimi majje Jesosa nequisohuanaje. Beni tecuea canaje: —¡Beni, jamaya, nequioquequicue oe! Majoya bae ena nijje jama poanaje baꞌa: —¡Aꞌa enashajo pojji! ¡Enashajo popajeaꞌyocue! O jama mimime poajo, enashajo popajeaꞌyonaje. Beni popajeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jamajjeya bishe aijo anica Jesosajo quea bihui nee nee poanaje. Ojee mimimiminaje jama baꞌa: —¡Ache dejja shai jiquio quea sohui poja nee nee! Beniya, enashajo cuaa peaꞌai oja sohui shajjaꞌajja cani, de. ");
INSERT INTO eseNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesosa bae ojje miji yasijje baꞌeñaquinaje, Jjanana meshi yasijje. Majoya beca dejja Jesosa que poeyanaje. Oya cuana baꞌenaje mei jjanijo, ma emanoꞌyo cuana sajaajo. Eshahuaa oja eyami yasijje dobiquinajejo, quea mase nee nee, niñepoqui poanaje. O ani chipi nei jjayejjequi ca ajja pea cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Niñepoqui cuana Jesosa ba majje taaanaje jama baꞌa: —Miya Eyacuiñajjija Bacua Ejja. ¿Apiojji miya ecuana que poeyanaje? ¿Aꞌa jjeyahua nei ecuana cuaqui yasijje jeajeajeꞌyo? Eyacuiñajjiya eshahua cuana cuaqui yasijje huoojea cajeꞌyo quijje, jjeya nei pojjeama, de —taaame poanaje niñepoqui. ");
INSERT INTO eseNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Quea chipi nee cuichi cuana quea huiso ijjiaꞌijjia nequi. ");
INSERT INTO eseNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Eshahua cuaa Jesosa jama huohuime acanaje baꞌa: —Miyaya ecuana dejjajo nequi cuayaqui meeꞌyo majje ¡cuichi cuana huasijje ecuana huoojeaꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Eꞌe, ¡poquicue cuichi cuana huasijje! ¡Dobiquicue! —Jesosa poanaje. Jamajjeya dejja cuana jeananaꞌyo majje eshahua cuana cuichi cuana huasijje dobiquinaje, ojjaña. Dobiqui majje cuichi cuana cuajicuaji jaaoquequinananaje. Bae quea sahua doe nee nee yasijje cuichi cuana huiꞌiꞌyonaje, ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ba majje cuichi jaahuanajji cuana jjajjasoaquinaje. Cuajicuajipoquinaje cuiñajji yasijje. Ojjaña cuana ma cuiñajjijo baꞌe huohui capoquinaje. Eshahua cuanajo, cuichi cuanajo, dejja cuana niñepoqui jjimaꞌ po mee canaje peaꞌai huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jamajjeya ojjaña cuana ma cuiñajjijo baꞌe quea mete poeyanaje Jesosa que. Jesosa quea sohui poja nee nee jojoya ojjaña onijje quea mete miminaje jama baꞌa: —¡Poquicue miya pea meshi yasijje! Ojjaña ojo quea mete poanijo Jesosa ojje besapoqui oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jamajjeya Jesosa bishejje besapoqui oꞌoyanaje ojje miji yasijje, Capenaoma huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jomajo pea dejja cuaa quibojjisha quea mano nee jaa ye canaje Jesosa que, equipajaajjijo. Ma ba majje Jesosa jjashahuabaquinaje jama baꞌa: —Eꞌe, jiquio dejja cuana jjashahuabaquiani eya ejjaajaqui meeꞌyojji nei nei. Jamajjeya Jesosaa emanojaa huohui canaje: —Eꞌe ecuea epeejji, ¡quea bihui nee pocue! Eyaya miquea mimishi cuana cuijeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesosaja esohui shajjaꞌajja majje Moisesija etehueꞌyo huohuijji poani cuana quenequenenaje. Jjashahuaba taiquinaje jama baꞌa: —¡De! Jiquio oya Eyacuiñajji pojjeama. ¿Apiojji Eyacuiñajji jayojja jama nei nei mimiani, de? Jamaya quea mimishi. ");
INSERT INTO eseNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jamajjeya Jesosa ojaya ejjashahuaba taiquijji ba majje jama poanaje: —¿Yajjajje acuae quiana quea quene enijje poani soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ache shai quibojjishajo quea camaja eyaya anaje? ¿Aꞌa ojaya mimishi cuijeaꞌyojji quea camaja? ¿Aꞌa jja oya nequisohua meejeꞌyo eyaya? Baꞌajja —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jamajjeya eyaya ojjañaja Edoe Meseya miquianaya ba meeaña eya ca ca iña Emeshi Cuiñacoojji quea caꞌa nee nee nequi. Jamajjeya eyaya mimishi cuijeajeꞌyo nequianaja. Majoya Jesosaa quibojjisha acanaje: —¡Nequisohuacue! ¡Miquea equipajaajji bebo majje miquea equi yasijje poquicue! ");
INSERT INTO eseNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jjeya nei quibojjisha nequisohua majje jeoꞌyonaje. Jeojeopoquinaje ojaya equi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ba majje ojjaña cuana quea bihui nee nee poanaje: —¡Eꞌe nei, joya quibojjisha jeoꞌyonaje jjeya nei! ¡Eꞌe e, Eyacuiñajji nijjeya Jesosaa emanojaa cuana huaquia mee caꞌyani! ¡Mimishi cuijea mee caꞌyani peaꞌai! —poanaje ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Majoya Jesosa poquinaje pea cuiñajji cuana huasijje. Poquijeya Mateo ba canaje equi ejjeshejji jaahuanajjijo ani. Mateo ona sose jjeshejji poani, ebaꞌejji sosejje. Ojjañaja emeshi meseja esohuijo jjeshe mee cani, dejja cuana ebaꞌejji sosejje. Ba majje Jesosaa Mateo iyaa canaje: —Mateo, ¡enijje poꞌyocue! Jamajjeya Mateo nequisohua majje Jesosa nijje poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Majoya Mateohua ojaya epeejji cuana iyaa canaje ojaya equi yasijje eꞌijjiaꞌijjiajji Jesosa nijje. Jamajjeya Jesosa o shajjaꞌajjajji cuana nijje Mateoja equi yasijje poquinaje ijjiaꞌijjiaa. Quea huiso dejja cuana Mateo jama ona sose jjeshejji poani, dejja mimishi cuana peaꞌai poquinaje. Ojee ijjiaꞌijjiaꞌaninaje Jesosa nijje, Jesosa shajjaꞌajjajji cuana nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ba majje Jodio esohui huohuijji Paniseo cuana Jesosa shajjaꞌajjajji cuana nijje mimijajinaje jama baꞌa: —¿Apiojji miquea esohui huohuijji ijjiaꞌijjiani dejja mimishi nijje, ejjeshejji chichajji cuana nijje peaꞌai? ¿Apiojji, de? ");
INSERT INTO eseNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesosaa oya cuana shajjaꞌajja canaje. Huohui canaje: —¿Aꞌa dejja cuana quea mano pojjeama eshicuijjiquiajji sa poani? Quea mano poanijo ca ca eshicuijji quia cajji. Jamaya miquianaya joya mimishiꞌama poso jjabaquiani ecuea esohui shajjaꞌajja sa po ajja. Mimishi cuaa ca ca shajjaꞌajja cani. Jamajjeya eya dejja quea mimishi nijje jjapeequiani quea jaꞌa nee epo meejji. ");
INSERT INTO eseNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","¡Bacue oe! Siajjepojji jama poani baꞌa: “Eya ca ca iña quea pame nee, mimishiꞌama nei nei”. Jamajjeya joya quea pame poso jjabaquiani ecuea eꞌiyaaꞌyojji pojjeama enijje ejjapeequijji. Chojja. Eya poeyanaje dejja joya quea mimishi nee nee iyaaa, mimishi pajea meeꞌyojji. Jamajjeya esohui etehueꞌyojo jjabahuejjaquicue jama baꞌa: Yahuajo nei nei Eyacuiñajjiya Osea tehue mee ca poa jama baꞌa: “Huo cuana cuia cani. Cuia majje na sho cani e bihuiajji. Jamaya ecuea quea boti pishana. ¡Pea cuana oe baꞌe meecue tii quea bei! Jamaya ecuea quea boti nee nee”. Jamaya tehue mee ca poa yahuajo —jamaya Jesosaa Paniseo cuana acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Majoya Huani, ma ona besameejji poa ejeanobiajea jaa. Ojaya eshajjaꞌajjajji cuana poeyanaje Jesosa que. Jama huohuiꞌajjame acanaje baꞌa: —Ecuana, Paniseo cuana peaꞌai Jodio etiiquianaja esohui jama poanijo bobi ijjiaꞌijjia jjima ani Eyacuiñajjijo jjashahuaba neineiquianijo, onijje mimi neineianijo. Jesosa, ¿apiojji acuae mi mi shajjaꞌajjajji cuana jama po ajja? —oya cuana poanaje beshahua nei quea tecue. ");
INSERT INTO eseNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesosaa oya cuana sajaꞌa canaje: —Chojja, eya ecuea epeejji cuana nijje yanijo caꞌijjia cahua. Ejjahuanaquijjijo yahueja epeejji cuana onijje yanijo caꞌijjiaꞌijjiaquiahua. ¿Aꞌa yahueja epeejji cuana onijje yanijo quea yeno? Chojja. Quea bihui nee. Yahue poquiꞌyajo ca ca oe ojaya epeejji cuana ijjiaꞌijjia sa po ajja poaje, quea yeno jjejojo jjashahuaba neineiquiani. Eya jiquio ecua yahue poquiani jayojjaya jama poaje: Quijje eya poquiꞌyo majje ecuea epeejji cuana Eyacuiñajjijo jjashahuaba neineiquianijo ijjiaꞌijjia ajja poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Majoya Jesosaa huohui canaje pea esohui ejjashahuabaqui meejji: —Eseyaya baacojja eseeꞌyohua caca ajja bishe eyacuajo. Cho. Baacojja etii enajo nequi seeꞌyani, caꞌaꞌama. Jjasajajeaquijeꞌyo. Bishe ihuicuajicuajije. Bishe eyacuajo ca ca baacojja eyacuaa cacaña. ");
INSERT INTO eseNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—Peaꞌai ena sese cuatatanijo iya ajja meshimisi etiijo. Ena sese cuatata neineianijo, meshimisi caꞌaꞌama jjaajajeaqui majje ena sese jjashojeajeaquijeꞌyo. Cho, ena sese cuatatanijo meshimisi eyacua quea caꞌajo iya cajji. Jamaya Jesosaa huohui canaje o jjabahuejjaquijji baꞌa: Ojaya esohui eyacua quea jaꞌa jama caꞌa cahua. Jamajjeya Eyacuiñajjiya oya cuana quea boejea nee ba cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesosa jamaya dejja cuana nijje mimianijo, pea Jodio dejja o que poeyanaje, ma Jodioja ojee ejjachichaquijji equi jaahuanajji poani. Ecuiꞌoshajjajo nequinaje o bihuiajji. Jama poanaje baꞌa: —Esohui huohuijji, ecuea ebacua piona manoꞌyonaje jjeya nei. ¡Poecuajicue o napaꞌajjaa emeya! Jamajjeya oya shequije oꞌoya, de. ");
INSERT INTO eseNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nequisohua majje Jesosa epona shoꞌija chii nijje poquinaje. Jesosa shajjaꞌajjajji cuana onijje poquinaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jesosa poquije oe eponaa ba canaje. Oya quea mano, najji popajeaꞌyo ajja. Ome miji pea beca, 12 eshequiajame na cuayapajeaquiꞌyo ajja poa. Jesosa que quehuajje poeyanaje. Ohuaya oja daqui cuema iña canaje, emeya. ");
INSERT INTO eseNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jjashahuabaquinaje jama baꞌa: —Eya Jesosaja daqui cuema iña majje najji popajeajeꞌyo. Ohua daqui cuema iña cajje Jesosa jjabajeaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Epona namaꞌyo ba canaje. Jama poanaje onijje baꞌa: —She, ¡quea bihui nee pocue! Miya quea jaꞌa jjashahuabaquinaje ejo jama baꞌa: “Eꞌe jojo nei Jesosaa eya najji popajea mee cajeꞌyo”. Jamajjeya eyaya miya najji popajea meeꞌyonaje. Jamajjeya ma epona najji popajeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Majoya Jesosa equi jaahuanajjija equi yasijje poquinaje. Dobiquinaje. Ba cañaquinaje quea huiso dejja cuana, ponaña peaꞌai equijo nequi. Epona shoꞌi emanoꞌyojo ojee paꞌani. Ojjaña quea shajjaquijjo poani. Dehue mia cani emojeaꞌyojjijo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesosaa ojjaña cuana huoojeacuayajea canaje: —¡Cuayaquicue nequiana esecue yasijje! Jiquio epona shoꞌi cahuijaa; epoquijeyoꞌyo pojjeama —poanaje. —Chojja de. Oya manoꞌyonaje, de; shequiꞌyo ajja —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ojjaña cuana esecue yasijje cuayaquiꞌyajo, Jesosa epona shoꞌi jaa huasijje dobiquinaje, pea equecuayijji yasijje. Meꞌ iña majje epona shoꞌi shequi mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jamajjeya ojjaña ma meshijo baꞌe yasijje huohuiqui canaje cuaa: —¡Jesosa jjashequi meequiꞌyojji, de! ¡Jiquio epona shoꞌi ma emanoꞌyo poanaje shequiꞌyonaje! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Quijje pishana Jesosa ma equijo ani cuayaquiꞌyonaje. Ejiojjijje poquianijo beca dejja o quiquishijji poquinaje, cojjamaꞌ cuana. Taaanaje jama baꞌa: —Jesosa, miya emeshi mese Dabija bacua. ¡Ecuanajo jjashahuabaquicue! ¡Cojjajji mo po meeꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesosa pea equi yasijje dobiquiajo cojjamaꞌ cuana o que poeyanaje. Jesosaa oya cuana huohuiꞌajja canaje: —Miquianaya ejo jjashahuabaquiani jama baꞌa: “Eꞌe, Jesosa ca ca quea cojja jaꞌa jjapo meequiꞌyojji, de”. —Eꞌe, Jesosa, miya quea cojja jaꞌa jjapo meequiꞌyojji —poanaje cojjamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jamajjeya Jesosaa ojaya ecojja napaꞌajja canaje emeya. Huohui canaje jama baꞌa: —Eꞌe, miquianajaya ejjashahuabaquijji ejo quea jaꞌa nee nee. Jamajjeya eyaya cojjajji po meejeꞌyo nequiana. ");
INSERT INTO eseNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jjeya nei quea cojja jaꞌa nee nee poꞌyonaje. Jesosaa huohui neinei canaje peaꞌai: —Eꞌe, eyaya miquianaya quea cojja jaꞌa po meeꞌyonaje. Jamatii ¡aꞌa jihuohuijji soꞌo! —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jamatii poqui majje huohui poanaje ojjaña huasijje: —¡Jesosaa ecuana quea cojja jaꞌa nee nee po mee caꞌyonaje, de! —jamaya poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Majoya ma cojjamaꞌ poanaje cuana poquiꞌyajo, pea cuaa dejja mimiꞌajja jjequi canaje Jesosa que. Eshahuaa oja yami yasijje dobiqui majje mimiꞌajja po mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesosaa eshahua huoojeacuayajeaꞌyo majje dejja mimiꞌajja quea jaꞌa nee mimi oꞌoyanaje. Ba majje ojjaña cuana quea bihui nee nee poanaje. Miminaje jama baꞌa: —¡Chamaꞌ beca dejja Jesosa jama, de! Ohuaye nei eshahua huoojeacuayajea caꞌyani, mimiꞌajja mimi mee caꞌyonaje, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jamatii Paniseo cuanaa Jesosa quehua niñeba canaje. Jama acanaje baꞌa: —Chojja de, Jesosa eyamiquecua pojjaꞌa. Pea eshahua huoojeacuayajea mee cani Edosiquiana nijjeya —siajje pome poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jamajojoya Jesosa poquinaje ojjaña cuiñajji quea quemo huasijje, ojjaña cuiñajji sisi cuana huasijje peaꞌai. Jodioja equi ojee ejjachichaquijji cuana huasijje dobiquinaje esohui huohuiya. —Eya quijje eyajo ojjañaja Emeshi Mese oe nei poajeꞌyo —Jesosaa acanaje. Ojjaña quea mano jaa jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dejja cuana quea huiso nee nee jjachichaquinaje o que. Jesosaa oya cuana ba canaje ñajjajja jama. Ejaahuanajji quea pame chamajo ñajjajja nequi mee ajja quea pame nee. Jamaya ojjaña cuana quea yeno poani; ebaꞌejji quea camaja baꞌyani, ejaahuanajji quea pame chamaꞌ peaꞌai, de. Jamajjeya Jesosa ojjañajo quea yeno poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","O shajjaꞌajjajji cuana nijje miminaje dejja cuanajo. Jama poanaje Jesosa baꞌa: —Anoso quejo jahua majje echacojji cuanaa cachicha cahua. Dejja cuana anoso jahuajahua jayojja jama, quea huiso nee nee. Eꞌe de, jjeya ojjaña cuana jjashahuabaquiani eꞌe jojo nei epojji; shajjaꞌajja caje eya Emeshi Mese nei poeyanaje o jaahuanaa. Jamatii oe pojji Eyacuiñajjijo chaco sa poani. ¿Aya acuae oya cuana jjabahuejjaqui mee cajeꞌyo Eyacuiñajjijo? ");
INSERT INTO eseNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jamajjeya ¡Eyacuiñajji nijje mimicue! Jama acue baꞌa: “Eyacuiñajji, ¡huoojeacue oe miquea echacojji cuana esohui huohuiya, pea cuana minijje ejjapeequi meeꞌyojji!” —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jamajjeya Jesosaa o que iyaa canaje o shajjaꞌajjajji cuana. Oya cuana quea caꞌa po mee canaje eshahua cuana huoojeacuayajea meeꞌyojji, ojjaña emanojaa cuana huaquia meeꞌyojji, ejjaajaqui meeꞌyojji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesosa shajjaꞌajjajji nei 12 poa, yohua bajjani baꞌa: Simohui ojaya pea bajjani Peno, oja chahua Anesi; Semeneoja bacua ejja Jacobo, oja chahua Huani; ");
INSERT INTO eseNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Penipe, Matonome, Tomasi, Mateo ma bejjo chichajji emeshi mesejo poa; Apeoja bacua ejja Satiaco; ");
INSERT INTO eseNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Senote; Nemeo ojaya pea bajjani Taneo; Jodasa Isicaniote, ma Jesosa iña meesahuajji poanaje dejja mimishija quecuaꞌyojji. Mahuiso Jesosaa babaca caꞌyonaje ojaya esohui huohuijji epojji. ");
INSERT INTO eseNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jamajjeya Jesosaa jiquio 12 huoojea canaje onijje chacohua. Jamaya huohui canaje: —¡Aꞌa poquijji Jodio dejja pojjeama cuanaja meshi yasijje! ¡Dejja cuana Samania meshijo baꞌe cuana huasijje peaꞌai aꞌa poquijji jjeya! ");
INSERT INTO eseNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Chojja, ¡jjeya poquicue Jodio cuana huasijje! Oya cuana poquiquehuanaje; Eyacuiñajji nijje jjapeepajeaquinaje ñajjajja epoquiquehua jayojja jama, de. ");
INSERT INTO eseNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ojjaña cuana huohuicue jama baꞌa: “Jjeya Jesosa ojjaña huoojeajji poani” acue. ");
INSERT INTO eseNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","¡Emanojaa cuana jjaajaqui meeꞌyocue! ¡Emanoꞌyo cuana shequi mee oꞌoyacue! ¡Dejja batata epoꞌyo cuana jjajeaqui meeꞌyocue peaꞌai! ¡Eshahua cuana dejja cuana huasijje dobiquiajo huoojeacuayajeaꞌyocue peaꞌai! Eyaya miquianaya huaquia meesahuaña pea dejja cuana sosemaꞌ. Jamajjeya ¡pea cuana quea bihui nee oe huaquia meeꞌyocue sosemaꞌ! ");
INSERT INTO eseNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jjeya ¡ejjeshejji, mei huoꞌo peaꞌai, bejjo peaꞌai aꞌa dojojji! ");
INSERT INTO eseNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","¡Bashosoco bobi dojojji aꞌa dojojji! ¡Aꞌa beca daqui dojojji! ¡Miquea ejiojjijo nequi ejiojji shejee dojocue! ¡Oe acui ejjaquecuacaꞌaquijji dojocue, beca pojjeama! Miquea esohui shajjaꞌajja majje pea cuaa miya cabobia cahua. Eꞌe, miyaya esohui huohuiañajo, bobi caquia cahua. ");
INSERT INTO eseNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Miquianaaya pea cuiñajji yasijje poqui majje ¡saꞌajjacue oe dejja miquea epeejji epojji, joya bei bei! ¡Ojaya equijo anicue ma cuiñajjijo ani majje! ");
INSERT INTO eseNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ojaya equi yasijje dobiqui majje huohuicue jama baꞌa: “¡Eyacuiñajjiya miquianaya cajaahuana cahua!” ");
INSERT INTO eseNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ojjaña ma equijo baꞌeya miya quea pame nee acajo, Eyacuiñajjiya miquea esohui jayojja jama oya cuana jaahuana caje. Miya quea pame nee mi baꞌe mee cajo, cho; Eyacuiñajjiya oya cuana ejaahuanajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eꞌe pojjaꞌa beca equijo, beca cuiñajjijo miquea esohui shajjaꞌajja sa poꞌyo ajjajo, niñeba cani peaꞌaijo, ¡oya cuana jeajeanaꞌyocue! Poquijeꞌyohua jama acue baꞌa: “Eyaya miquianaya cajaa ajeꞌyo, ¡quea mimishi mi coma. Eyacuiñajjiya miya ba cani quea mimishi nee nee. Ohuaya miya quea nee nee po mee cajeꞌyo” acue —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eyaya miya eꞌe jojo nei huohuiaña jama baꞌa: Quijje Emeshi Mese nei poeje oꞌoya, ojjaña quea mimishi poani quea nee nee po meejeꞌyo. Yahuajo nei nei dejja cuana Sonomajo baꞌe, Jomoshajo baꞌe peaꞌai quea mimishi nee baꞌyanijo, Eyacuiñajjiya quea nee po mee caꞌya poa, yahuajo. Ma dejja shajjamaꞌ cuana ca ca Eyacuiñajjiya quea nee nee po tiitii mee cajeꞌyo, de. Sonomajo baꞌe cuana ca ca quea nee pishana po tiitii mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesosaa o shajjaꞌajjajji cuana huohui canaje peaꞌai: —Eyaya miya huoojeaña dejja quea mase ibia jama huasijje. Miquianaya quea beijo ohuaya mi napa ca chanaꞌ. Jamajjeya ¡quea jjashahuabaqui jaꞌa pocue! ¡Quea bei pocue; mimishiꞌama peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","¡Aꞌa pajeaꞌyojji dejja cuana quea mase poajeꞌyo minijje! Miya iña majje dojo caje Jodio etii ani yasijje jeanobiaa. Janobajjima nei cuia caje Jodioja equi ojee ejjachichaquijjijo. ");
INSERT INTO eseNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Miya cuana enijje jjapeequianijo dojo caje cuaa pea emeshi mese cuana huasijje, ona huoojeajji nei nei yasijje peaꞌai. ¡Jamajjeya miquianaaya esohui quea pame nee ejo huohuicue ona huasijje, Jodio pojjeama cuanaja ejjahuoojeaquijji nei nei yasijje peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dojo majje huohuiꞌajja caje jama baꞌa: “¿Ae poani miquianaya?” Jamaya acajje ¡aꞌa quea mete pojji! Aꞌa jjashahuabaquijji jama baꞌa: “¿Ae shai eyaya huohuije?” ");
INSERT INTO eseNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eꞌe nei Eyacuiñajjiya miya mimi meesahua caje. Ohuaya huoojea caje Edojjoshahua Pame mi que. Edojjoshahua Pameya miquianaya huohui meesahua caje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Eꞌe, quijje pishana dejja cuana, ponaña peaꞌai quea mase nee poaje ecuea epeejji cuana nijje. Jamajjeya eꞌoꞌi mese oja chahua iña meesahua cajeꞌyo onajaya equecuaꞌyojji. Ejeajji cuaa jamaya acajeꞌyo oja bacua. Ebacua cuana shajjamaꞌ poaje. Dejja mase oja chii, oja enaese pojjaꞌa iña mee cajeꞌyo equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Miquiana enijje jjapeequianijo, quea huiso cuana quea quene nee nee poajeꞌyo minijje. Jamatii enijje jjapeequi pajeaꞌyo ajjajo nequi tiitii meejeꞌyo enijje eyajo, eya ojjañaja Emeshi Mese oe nei, ejjahuoojeaquijji nei nei poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dejja cuaa oe cuiñajjijo baꞌeya miquianaya janobajjima napa cajo, ¡poquicue pea cuiñajji yasijje! Eyaya miya eꞌe jojo nei huohuiaña: Ojjaña Jodio dejja cuanaja cuiñajji cuana huasijje poqui jjimahuajo, ojjaña cuana huasijje ecue sohui huohui jjimahuajo peaꞌai eya, ojjañaja Edoe Mese poeje oꞌoya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Ojjaña cuana enijje quea mase poani. Jamajjeya minijje quea mase poaje peaꞌai e shajjaꞌajjajji poani jojoya. ");
INSERT INTO eseNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Echacojji poani o chacomeejji nijje chacochacoanijo, pea cuaa echacomeejji napa cajo, echacojji poani peaꞌai napa caje cuaa. ¿Aꞌa eꞌe? Dejja mimishi cuana ejo siajje poanaje jama baꞌa: “Miya Edosiquiana Meesemo bajjani”. Jamaya enijje quea tai mimijajianijo quijje quea tai nee nee mimijajije minijje ecuea epeejji poani jojoya. Jamajjeya miya e jayojjaya acajeꞌyo; ¡jamatii quea bihui nee pocue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Jamajjeya dejja mimishi cuanajo ¡aꞌa quea mete pojji! Ojjaña esohui quehuajje acani, pea cuanaja shajjaꞌajja jjima, quijje shajjaꞌajja caje. Ojjaña quehuajje amajje quijje ojjaña ba mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","—Jjeya eyaya esohui huohuiaña miquiana huasijje, ma pea cuanaja shajjaꞌajja jjima. Quijje pishana miquianaaya ojjaña huasijje huohuiquije ecuea esohui. ¡Quea jaꞌa nee huohuicue! ");
INSERT INTO eseNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ojjaña cuanajo, eshahua cuanajo peaꞌai ¡aꞌa quea mete pojji! Oya cuanaa miya quecua cajeꞌyo pojjaꞌa. Jamatii, miquea edojjoshahua mano meemee ajja. ¡Eyacuiñajji oe neijo jjashahuabaquicue! Shajjamaꞌ poajo ohuaya miya mano meeꞌyo majje cuaqui yasijje jea cajeꞌyo miquea edojjoshahua —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—Eꞌe —Jesosa poanaje—, beca anohuii jjeshe cajji beshahua nei sosemaꞌ. Nahueꞌama nei cuichojji cuana. Jamatii Eyacuiñajjiya, esejaya Chiiya cuichojji cuana ba cani, bobi ijjia mee cani. ");
INSERT INTO eseNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Peaꞌai ¿ache huiso ehuojjaña miquea esapajo baꞌe? Eyacuiñajjija eba. Ojjaña ojaya ehuojjaña esico, de. ");
INSERT INTO eseNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jamajjeya ¡aꞌa quea mete pojji! Cuichojji cuana Eyacuiñajjija nahueꞌama; miya ca ca ojaya quea nahue nee nee —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Beca cuaa bichoꞌama huohui cani: “Eꞌe, eya ca iña bichoꞌama Jesosaja epeejji eꞌe jojo nei”. Jamajjeya eyaya ecue Chii eyajo ani huohuije bichoꞌama jama baꞌa: “Eꞌe, oya cuana ecuea epeejji eꞌe jojo nei”. ");
INSERT INTO eseNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pea cuana quea bicho poani: “Cho, eya Jesosa Quitoja epeejji pojjeama”. Jamajjeya eyaya ecue Chii eyajo ani huohuije jama baꞌa: “Cho, oya cuana ecuea epeejji pojjeama. Cajaa” eyaya aje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—¡Aꞌa jjashahuabaquijji eya poeyanaje ojjaña cuana ojjaña meshijo ojee quea bei baꞌe meeya! Chojja, de. Pea cuana quea mase poaje ecuea epeejji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eꞌe, ecuea esohui ohua shajjaꞌajja canijo, oja chii nijje oja bacua ejja cuana quea quene poaje. Ecuea esohui jayojja jama ohua acanijo, oja enaese nijje ojaya ebacua piona quea quene poaje peaꞌai. Enijje jjapeequianijo, oja ano nijje oja bacua ejjaja huanase quea quene poaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jamajjeya ecuea epeejjija huapa pojjeama cuana quea quene poaje onijje ecuea epeejji pojjeama jjejojo; pea cuana quea quene pishana poaje onijje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Ojjañaa joya oja chii, ojaya enaese pojjaꞌa quea jea nee nee acanijo eya quea jea pishana acani ecuea epeejji pojjeama, de. Peaꞌai ojjañaa joya oja bacua ejja, oja bacua piona pojjaꞌa quea jea nee nee acanijo eya quea jea pishana acani enijje jjapeequi meemee ajja. Cajaa. ");
INSERT INTO eseNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Eyaya Eyacuiñajjija esohui huohuiañajo, pea cuana enijje quea quene poajeꞌyo. Dejja mimishiya enapa ca poani jjejojo enijje mi jjapeequiani. Ojjaña joya e jayojjaya baꞌe sa po ajja ecuea epeejji pojjeama. Eꞌe, jiquio ecua acui ecueataꞌapee quea camaja eꞌabojji jama jayojja enijje jjapeequiyajo quea camaja poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dejja mimishi cuaa ecuea epeejji quecua ca chanaꞌ. Jamajjeya quea mete nee neejo enijje jjapeequi sa po ajja. Cuaqui yasijje dobiquijeꞌyo tiitii. Joya enijje jjapeequiani ca ca dejja mimishi cuaa quecua cajeꞌyo pojjaꞌa. Jamatii. Manoꞌyo majje enijje baꞌe tiitiijeꞌyo quea pame nee eyajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Eꞌe —Jesosa poanaje peaꞌai—, beca cuana minijje jjapeequijeꞌyo miya ecue sohui huohuiañajo. Jamajjeya oya ecuea epeejji poani peaꞌai. Eyacuiñajji e huoojeajji poani; ojjaña joya enijje jjapeequiani Eyacuiñajjija epeejji poani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Quijje Eyacuiñajjiya ojaya esohui huohuijji sosequia cajeꞌyo ojaya esohui huohui cani sosejje. Pea cuana ojaya esohui huohuijji nijje jjapee neineiquianijo, sosequia cajeꞌyo esohui huohuijji jayojja jama. Ojjaña joya Eyacuiñajjija epeejji nijje eꞌe jojo nei jjapeequiani Eyacuiñajjiya sosequia cajeꞌyo quea pame nee oya quea pame nee poanijo. ");
INSERT INTO eseNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eꞌe jojo nei ojjaña joya ecuea eshajjaꞌajjajji poani baꞌe meesahua cani, ena eꞌishijji quia cani pojjaꞌa eya ojaya quea boti neejo, Eyacuiñajjiya oya quijje sosequia cajeꞌyo oya quea pame nee poanijo —Jesosaa o shajjaꞌajjajji cuana huohui canaje mahuiso huoojea jjimahuajo. ");
INSERT INTO eseNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Majoya Jesosaa ojaya ome miji becanejjijji peaꞌai, 12 eshajjaꞌajjajji cuana huasijje esohui huohui majje pea cuiñajji quea chipi nee yasijje poquinaje esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahuajo pea dejja cuaa Huani iña ca poa, ma ona besameejji poa. Dejja maseja equi ejjajeanobiaquijji yasijje jeanobiajea ca poa, emeꞌ jeyoꞌyo. Ejeanobiajaaa Huaniya shajjaꞌajja canaje onaja ehuohuiꞌyo Jesosajo. Jamajjeya o shajjaꞌajjajji cuana huoojea canaje Jesosa que. ");
INSERT INTO eseNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Oya cuana Jesosa huohuiꞌajjaña meequi canaje jama baꞌa: —Jesosa, yahuajo Huaniya huohui canaje jama baꞌa: “Eyacuiñajjiya Emeshi Mese nei ojjaña jaahuanajji huoojea cajeꞌyo ecuana huasijje”. ¿Aꞌa miya ma Emeshi Mese nei? Eꞌe pojjaꞌa ecuaa pea ishoaje. ¡Jamajjeya huohuicue miyaya! ¿Yajja shai ecuaa Huani ajeꞌyo soꞌo? —Huanija eshajjaꞌajjajji cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesosaa oya cuana sajaꞌa canaje: —¡Poqui oꞌoyacue Huani que! ¡Ecuea esohui miquianaaya shajjaꞌajjaña, jiquio miya eya banajeya peaꞌai oe Huani huohuiquicue! Jama acue baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Huani, Jesosaa cojjamaꞌ cuana quea cojja jaꞌa po mee caꞌyani. Jiojjijjajja jeo mee caꞌyani. Dejja batata epoꞌyo cuana jjajeaqui mee caꞌyani. Shajjaqueba peaꞌai quea shajja jaꞌa po mee caꞌyani. Emanoꞌyo cuana shequi mee caꞌyani peaꞌai. Esohui quea pame nee huohui caꞌyani ojjaña dejja quea yeno huasijje”. ");
INSERT INTO eseNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Eꞌe, eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Quea bihui nee capoꞌyahua ojjaña joya ejo jjashahuabaquiani jama baꞌa: “Eꞌe jojo nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji”. ¡Aꞌa jjashahuaba quehuaquijji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jamajjeya Huanija epeejji cuana poqui oꞌoyanaje Huani que. Majoya poquiꞌyajo Jesosa miminaje pea cuana nijje: —Yahuajo Huani meshi jabojo, quimajo aninaje. Miquianaya o que poquinaje. ¿Ae shai banaje miyaya? ¿Ae jjashahuabaquinaje Huanijo? ¿Aꞌa jjashahuabaquinaje Huani esohui huohuijji quea jaꞌa pojjeama? Chojja. ");
INSERT INTO eseNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Miquianaya Huani que poquinaje ¿ae baa? ¿Aꞌa dejjaja daqui quea nahue nee ehuosho baꞌe banaje? Chojja. Dejjaa daqui quea nahue nee huosho cani equi quea quemojo baꞌeya. ");
INSERT INTO eseNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Achajja Huani baꞌya poa? ¿Aꞌa miya jjashahuabaquinaje Huani Eyacuiñajjija esohui huohuijji nei nei? Eꞌe, de. Jamatii Eyacuiñajjija esohui huohuijjiya ba cani oe pojji. Huanija eba quea huiso nee. ");
INSERT INTO eseNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yahuajo nei Eyacuiñajjija esohui etehueꞌyo Huanijo jama poa baꞌa: “Jiquio dejja ecuea esohui huohuijji nei poani. Jamaya eya sa poani. Eyaya oya huoojeaje ebionei, mi hui dojojji. Ohuaya dejja cuana huasijje huohui caje miquea epoejjijo”. Jamaya yahuajo nei nei Eyacuiñajjiya ojjaña ba mee ca poa Huaniya poe majje ejo jjabahuejjaqui mee caje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ecuea pea esohui aꞌa pajeaꞌyojji jama baꞌa: Ojjaña pea cuana quea pame. Huani ma ona besameejji poa quea pame nee nee. Jjeya pea chamaꞌ Huani jayojja jama. Jamatii quijje eya Emeshi Mese nei poaje, ojjaña ecuea epeejji cuana Huani jayojja jama poajeꞌyo, quea pame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Eya poeyanajejo Huaniya ojjaña pojjajo ejo huohui canaje jama baꞌa: “Jjeya nei Emeshi Mese nei Quito poeje”. Jamatii dejja mase cuaa Huani napa cani ojjaña pojjajo. Eya, Emeshi Mese nei jeabichajea sa acani cuaa peaꞌai. Oya cuana emeshi mese jayojja jama huohui sa poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","—Yahuajo nei Eyacuiñajjija esohui huohuijji cuaa huohui ca poa, Moisesija esohui etehueꞌyojo jama poa peaꞌai baꞌa: “Quijje Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji Emeshi Mese oe nei poeje”. Jamaya Huani miminaje. Jamaya pea cuana miminaje Huani poe jjimahuajo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eꞌe, yahuajo nei Eyacuiñajjija esohui huohuijjiya tehue ca poa jama baꞌa: “Ecuea ehuoojeaꞌyo ojjaña jaahuanajji poe jjimahuajo, eyaya Enia huoojeaje ebionei, ehui dojojji”. —Huaniya Enia jayojja jama huohui canaje, ma Eyacuiñajjija esohui huohuijji yahuajo nei nequia poa jama. ");
INSERT INTO eseNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jamajjeya ¡bacue; aꞌa shajjamaꞌ pojji, ca miquiana ba sa poanijo! ");
INSERT INTO eseNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ojjaña cuana jjeya nei baꞌe ecuea eba. Oya cuana eshoꞌiquiana quebanei poani jayojja jama. Quebanei poanijo jama poani: Eshoꞌi cuaa pea eshoꞌi taaa cani. ");
INSERT INTO eseNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Jjamimihueꞌequiani jama baꞌa: “Ecuaa dehue miaña epona ejjahueaquijjijo jama. Jamatii miquianaya majamaja ajja. Peaꞌai e pa nishoanijo, emanoꞌyojo paꞌani jayojjayajo, miquianaya pa nisho ajja. Jamajjeya miquianaya quebanei po ajja ecuana nijje” poani eshoꞌiquiana —Jesosa poanaje—. Jamaya miquianaya jjeya poani, de. ");
INSERT INTO eseNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Eꞌe, yahuajo pishana Huani poeyanaje. Eyacuiñajji nijje mimi tiitiianijo bobi ijjiaꞌijjia ajja. Ecahuishi ishi jjima peaꞌai. Jamajjeya ojjaña cuaa huohui canaje ojo jama baꞌa: “Huani jja ca niñepoqui jama”. ");
INSERT INTO eseNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Eya ojjaña cuanaja Edoe Mese poeyanaje. Eya ca jja ca ijjiaꞌijjiani; ojjaña nijje mimimimiani. Jamajjeya miquianaya ejo siajje poani jama baꞌa: “¡Bacue jiquio dejja Jesosa! Oya jejje ajja tii. Dejja mimishi nijje jjapeequiani, bejjo chichajji cuana nijje peaꞌai, de”. Jiquio ecua eshoꞌiquiana pea nijje jjapeequi sa po ajja jama jayojja miquianaya ecuana nijje jjapeequi sa po ajja. Miquianaya jjashahuaba quehuaquiani Huanijo, ejo peaꞌai. Jamatii ecuanaa Eyacuiñajjija ejjashahuabaquijjijo quea jaꞌa nee jayojja jama añajo ecuanaa quea pame nee aña —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Quea huiso cuiñajjijo Jesosaa ma dejja cuaa ajjima acani ahuichaꞌa huichaꞌa canaje. Jamatii quea huiso cuana mimishi pajea sa poꞌyo ajja. Jamajjeya Jesosaa oya cuana tecuea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jama poanaje baꞌa: —Miquianaya quea mimishi nee nee. ¡Quea yeno nee nee miquianaya poaje Conasijo baꞌe, Betesainajo baꞌe peaꞌai! Ma dejjaa ajjima acani eyaya ahuichaꞌa huichaꞌanaje miquianaja cuiñajji cuanajo miquea ebajji nisho. Yahuajo nei nei pea dejja cuana Tinojo, Sinonojo peaꞌai baꞌeja ojaya ba jjima eyaya ma dejja cuaa ajjima aña. Eba jojjemo oya cuanaa mimishi cuana pajea caꞌyo queaye mimishijo quea yeno po majje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","¡Bacue oe! Quijje Eyacuiñajjiya ojjaña cuana sosequia cajeꞌyo ojaya ebaꞌeꞌyojji sosejji. Ohuaya yahuajo nei nei Tinojo baꞌe cuana, Sinonojo baꞌe cuana peaꞌai quea nee po mee cajeꞌyo mimishijo. Miquianaya Conasijo baꞌe, Betesainajo baꞌe peaꞌai ca ca quea nee nee po mee cajeꞌyo ecuea esohui miquiaaya mi shajjaꞌajjajo. ");
INSERT INTO eseNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Miquianaya Capenaomajo baꞌe quea pame poso jjabaquiani, jjashahuabaquiani jama baꞌa: “Ecuana quea pame nee nee; pea meshijo baꞌe cuana quea pame pishana”. Chojja, de. Siajje miya poani. Quijje Eyacuiñajjiya janobajjima nei napa cajje miquianaya quea yeno poaje. Eyaya ma dejjaa ajjima acani aña miquianajaya cuiñajjijo quea huiso. Jamatii miquea mimishi cuana pajea sa poꞌyo ajja. Yahuajo nei nei pea cuiñajji Sodoma bajjani yania poa. Eyacuiñajjiya ma dejjaja ba jjima acani eba jojjemo oya cuana quiyo jeyojeyoꞌyo jjima poqueaye. Jamatii jjeya Sodoma chamaꞌyo tii. ");
INSERT INTO eseNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","¡Bacue oe! Quijje aje Eyacuiñajjiya ojjaña cuana sosequia cajeꞌyo ma ecua oya po nequia poa jama. Ma pojjajo ohuaya dejja cuana yahuajo nei Sodomajo baꞌe quea nee po mee cajeꞌyo quea mimishijo. Miquianaya Capenaomajo baꞌe ca ca quea nee nee po mee cajeꞌyo ecuea esohui miquiaaya mi shajjaꞌajjajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jamaya dejja cuana tecuea majje Jesosa eseja Chii ai nijje miminaje jama baꞌa: —Ecuea Chii, miya eyajo Emeshi Mese nei poani. Ojjaña meshi cuana miquea poani peaꞌai. Eyaya miya bihuiaña. Eꞌe, beca cuana jjashahuabaquiani jama baꞌa: “Ecuea eba quea huiso esohui, quea huiso aquiana peaꞌai”. Jamajjeya miyaya oya cuana ba meesahua ajja. Jamajjeya oya cuanaja ba jjima eya Emeshi Mese oe nei poani. Pea cuana eshoꞌi cuana jama ca ca miyaya jjashahuabaqui meesahuaña quea jaꞌa nee eya Emeshi Mese nei poani. Jamajjeya eyaya miya bihuiaña. ");
INSERT INTO eseNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eꞌe ecue Chii, jamaya miyaya aña miquea ejjashahuabaquijji. Apoa —jamaya Jesosa miminaje eseja Chii ai nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Majoya Jesosa jama poanaje baꞌa: —Eyacuiñajji ecue Chii e huoojeajji epo. Eya ojaya esohui huohuijji poani. Ecue Chiija eyajo anija ecuea ejjashahuabaquijji ojaya eba nei nei, ojaye nei. Ecue Chiija ejjashahuabaquijji ecuea eba nei nei peaꞌai, ecuee nei. Eyaya ecuea epeejji ba meesahuaña quea jaꞌa nee ecue Chiija ejjashahuabaquijji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—¡Enijje jjapeequicue quea bei! Mique mimishi cuanajo miya quea yeno. Miquea echaco quea camajajo miya quea yeno poani peaꞌai. ¡Enijje jjapeequicue! Eyaya miya jomishoca meejeꞌyo camajaꞌama ebaꞌeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Eyaya quiana ca ca oe miquianaya jama pojjeamaa jjejojo quea jea aña; tecueꞌama; quea bei peaꞌai. Ecuea epeejji po majje miquianaya quea bei poajeꞌyo. Baꞌe tiitii meejeꞌyo enijje eyajo peaꞌai. Jamajjeya ¡ecuea esohui jayojja jama acue! ¡Jjashajjaꞌajjaquicue quea jaꞌa nee ecuea esohuijo! ");
INSERT INTO eseNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Camajaꞌama ecuea esohui jama ebaꞌeꞌyojji. Ecuea esohui aquiana pejapeja eꞌabojji jayojja poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Majoya epojja ejomishocajjijo Jesosa o shajjaꞌajjajji cuana nijje ejiojjijje poquinaje. Que yiyejje poquije quea shoe poanaje; quejo nequi anoso ai sejja canananaje eshe tii eꞌijjiajji, o shajjaꞌajjajjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maya Paniseo cuaa ba canaje. Jamajjeya Jesosa nijje mimijajinaje jama baꞌa: —¡Bacue oe! Mi shajjaꞌajjajji poani cuaa chaco cani. Anoso ai sejja cani epojja ejomishocajjijo. Moisesija etehueꞌyo jama poani baꞌa: “¡Aꞌa chacojji epojja ejomishocajjijo!” ");
INSERT INTO eseNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesosaa oya cuana sajaꞌa canaje jama baꞌa: —¿Aꞌa miquea ba jjima esohui etehueꞌyo emeshi mese Dabija? ");
INSERT INTO eseNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yahuajo nei nei ojaya epeejji cuana quea shoe po majje ojee Eyacuiñajjija equi yasijje dobiquinananaje. Ijjia ca poa ejji ecabeje, maya Eyacuiñajji yasijje quia ca poa cuaa ojaya ebajji. Jiquio ca oe Eyacuiñajji nijje mimianiya caꞌijjia cahua; pea cuanaja eꞌijjiajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Aꞌa miquea ba jjima Moisesija esohui etehueꞌyo? Jama poa baꞌa: Ojjaña epojja ejomishocajjijo Eyacuiñajji nijje mimiani cuaa ca oe Eyacuiñajjija equijo cachaco cahua. Jamatii mimishiꞌama, mimijaji ajja, de; ojaya yajjijo cachaco cahua. ");
INSERT INTO eseNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","—Eꞌe, eyaya miya eꞌe jojo nei huohuiaña jama baꞌa: Moisesija esohui Eyacuiñajjija equijo quea jaꞌa pishana yahuajo nei poa. Ecuea esohui ca ca quea jaꞌa nee nee —Jesosaa acanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Eꞌe, miquianajaya Eyacuiñajjija esohui etehueꞌyo eba neineiꞌyo jojjemo dejja cuana mimishiꞌama jjaniñebaqui ajja pome. Jamaya quea tai. Yahuajo Eyacuiñajjija esohui etehueꞌyo jama poa baꞌa: “Huo cuana cuia cani. Cuia majje na sho cani e bihuiajji. Jamaya ecuea quea boti pishana. ¡Pea cuana oe baꞌe meecue tii quea bei! Jamaya ecuea quea boti nee nee”. Jamaya tehue ca poa yahuajo. ");
INSERT INTO eseNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—Jamajjeya eya ojjañaja Edoe Mese Emeshi Mese nei poani. Eyaye nei huohuije epojja ejomishocajjijo; ¡quea pame nee nee acue! ¡Pea cuana quea jea nee acue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Majoya Jesosa poquinaje pea huasijje. Equi ojee ejjachichaquijji yasijje dobiquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jomajo dejja meshahuamaꞌyo epo aninaje. Jamajjeya Jesosa ba majje Paniseo cuana jama jjashahuabaquinaje baꞌa: —Eꞌe pojjaꞌa Jesosaa chaco caje epojja ejomishocajjijo; eꞌe pojjaꞌa emeꞌ jeapisa mee cajeꞌyo epojja ejomishocajjijo. Cabaꞌajja sahua —poanaje Paniseo. Jesosa nijje mimijaji sa poanaje. Jamajjeya oya huohuiꞌajja canaje Paniseo cuaa: —Jesosa, ¿aꞌa dejja quea mano jaa miyaya huaquia meeꞌyome epojja ejomishocajjijo? ");
INSERT INTO eseNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—Epeejji cuana, eꞌe pojjaꞌa miquea ñajjajja jjani quea doe yasijje oquequije epojja ejomishocajjijo. ¿Aꞌa miyaya ñajjajja iña majje ma pojjajo jjequisohuajeꞌyo? Eꞌe, de. ");
INSERT INTO eseNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Bacue oe! —Jesosa poanaje—, dejja Eyacuiñajjija quea boti nee; ñajjajja ca ca quea boti pishana. Jamajjeya eꞌe, pea cuana caꞌa meesahuaꞌyahua epojja ejomishocajjijo. Jamaya Moisesija esohui etehueꞌyojo poani peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma mimi majje Jesosaa meshahuamaꞌyo epo jama acanaje baꞌa: —Epeejji, ¡miquea emeꞌ jeapisaꞌajjaꞌyo socue! Jamajjeya emeꞌ jeapiihui majje emeꞌ jeapisa caꞌyonaje; pea mijijje jayojjaya poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Majoya Paniseo cuana esecue yasijje cuayaqui majje ojee miminaje: —¿Yajja amajje Jesosa quecua caꞌyojji soꞌo, de? —jamaya poanaje Paniseo cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eꞌe, Paniseo cuaa oya quecuapana canaje. Ma shajjaꞌajja majje Jesosa poquinaje pea meshi yasijje. Quea huiso dejja cuana onijje poquinaje. Ojjaña cuana huaquia mee caꞌyonaje, jjaajaqui mee caꞌyonaje, Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jama poanaje baꞌa: —Eꞌe, eyaya miya huaquia meeꞌyonaje. ¡Jamatii aꞌa jihuohuijji soꞌo! ");
INSERT INTO eseNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eꞌe, Jesosaa ojjaña cuana huaquia mee caꞌyonaje, sohuihuohui canaje peaꞌai. Jamaya Isaiaja esohui etehueꞌyo ojo yahuajo nei nei jayojja jama poa. Eyacuiñajjiya Isaia yahuajo nei nei tehue mee ca poa Jesosajo jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“¡Bacue! Jiquio dejja ecuea echacojji ecuea yajjijo. Eyaya oya huoojeajeꞌyo. Oya ecuea quea jea nee nee. Ojo eya quea bihui nee nee. Ecuea Edojjoshahua Pame o que eyaya huoojeajeꞌyo; ohuaya ojjaña Jodio pojjeama cuana huasijje huohui caje jama baꞌa: —¡Ojjaña cuana ecuea esohui eꞌe jojo neijo jjabahuejjaquiꞌyajo Eyacuiñajjiya quea boejea po mee cajeꞌyo! ");
INSERT INTO eseNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Oya ecuea echacojji jjamimicuiajea nobiajeaqui ajja. Quea bei nee mimijeꞌyo. Ejiojjijje poquiani quea shajjaquijjo poꞌyo ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Joya quea mimishi nee nee aje jja oe ohua mimishi cuana cuijea caꞌyajje quea boejea poajeꞌyo. Cuanaya jiquio ecua cuaquijiji quijjoꞌyo jjimahuajo esei sho oꞌoyaña jama jayojja ecuea epeejji quea mimishi po oꞌoya chanajo ohuaya quea jaꞌa nee nee po mee caje oꞌoya, de. Eꞌe, ohuaya ejo chaco tiitii cajeꞌyo; quea huiso nee nee baꞌe mee cajeꞌyo quea jaꞌa nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jodio pojjeama quea huiso nee nee ojjaña meshijo baꞌe cuanaya eꞌe jojo nei onijje jjapeequijeꞌyo peaꞌai”. Jamaya Eyacuiñajjiya Isaia tehue mee ca poa yahuajo nei nei Jesosa Quitojo. ");
INSERT INTO eseNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Majoya Jesosa que jjequi canaje cuaa dejja niñepoqui. Oya cojjamaꞌ, mimiꞌajja peaꞌai. Jesosaa eshahua huoojeacuayajea caꞌyonaje. Jamajjeya oya quea cojja jaꞌa poanaje, emimijji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ba majje ojjaña cuana quea bihui nee poanaje. Jama acanaje baꞌa: —Eꞌe de, aꞌya shai de, ¿aꞌa pojjaꞌa Jesosa Eyacuiñajjija huoojeaꞌyo Quito? ");
INSERT INTO eseNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma shajjaꞌajja majje Paniseo cuaa Jesosa niñeba canaje. Jama poanaje baꞌa: —Chojja, de. Jesosa aje oe eyamiquecua pojjaꞌa. Ohuaya aje jja oe eshahua cuana huoojeacuayajea canaje Edosiquiana etii nijjeya, Satanasa bajjani, pea bajjani Meesemo nijjeya —poso acanaje Paniseo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Paniseo cuanaja ejjashahuabaquiꞌyojji quea tai Jesosaja eba poanaje. Jamajjeya oya cuana tecuea canaje jama baꞌa: —¡Shajjaꞌajjacue oe! Joya emeshi mese shajjaꞌajja sa po ajjajo ojee jjaquecuaqui majje jjaquecua iyaiyaquijeꞌyo; dejja cuana ma meshijo baꞌe chamaꞌyo tii poajeꞌyo. Cuiñajjijo baꞌe cuana jamaya po peaꞌaije, chamaꞌyo tii poaje emeshi meseje echacojji cuana. Huapa pojjeama cuana jjacuiaquiajo chamaꞌ epeejji cuana poajeꞌyo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jamaya peaꞌai Edosiquianaa, Satanasaa pea eshahua ehuoojeacuayaꞌyo jojjemo dejja huoojeaꞌyojji pojjeama poꞌyoqueaye —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—¿Aꞌa ya eya Edosiquiana nijjeya niñe, pea eshahua cuana peaꞌai huoojeacuayajeaña poso aña? Jamajjeya miquea epeejji cuanaa ¿ae nijje eshahua huoojeacuayajea cani? Eyacuiñajjiya asahua canijo. Jamajjeya ojaya eba miquianaya ejo siajje poani. ");
INSERT INTO eseNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eꞌe, Eyacuiñajji nijjeya eyaya eshahua huoojeacuayajeaꞌyaña. Jamajjeya bacue eya eꞌe jojo nei Eyacuiñajji, Emeshi Mese oe nei jjeya poani tii. ");
INSERT INTO eseNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Cuanaya ¡bacue! ¿Aꞌa dejja quea caꞌa neeja equi yasijje dobiquiani oja aquiana siiya o jeyo jjima nequijo? Chojja. O jeyo majje ojaya aquiana cuana sii caje cuaa. Jiquio ecua eꞌaquiana mese ebionei jeyo cani jama amajje eyaya eshahua cuana jeacuayajeaña —Jesosa poanaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Cuanaya ojjaña joya enijje jjapeequi ajja aje oe e quecuapanajji poani, ojjaña enijje chaco ajja ecuea epeejji pojjeama aje oe e ejeabichajeajji nisho poani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Jamajjeya eyaya miya eꞌe jojo nei huohuiaña: Eyacuiñajjiya ojjaña mimishi cuana, siajjepojji cuana peaꞌai cuijea cajeꞌyo. Jamatii joya Edojjoshahua Pame niñeba cani tii ca ca Eyacuiñajjija maya emimishi cuijeaꞌyojji pojjeama tii tii. ");
INSERT INTO eseNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Eꞌe —Jesosa poanaje—, eya niñeba cajo Eyacuiñajjiya ma mimishi cuijea cajeꞌyo. Joya Edojjoshahua Pame niñeba cani tii ca ca Eyacuiñajjija maya emimishi cuijeaꞌyojji pojjeama tii tii. Jjeya ecuijeaꞌyojji pojjeama; quijje ecuijeaꞌyojji pojjeama tii tii poajeꞌyo, eya ecue Chii nijje eyajo ojjaña huoojeaꞌyojji poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesosaa Paniseo tecuea canaje peaꞌai jama baꞌa: —Acui quea pame jjajjani. Acui quea tai jjajja ajja, quea jjajja biso. Jamajjeya miyaya baña dejja mimishi acui tai jayojjaya; ohuaya quea tai acani. ¿Aꞌa miyaya eya baña quea pame nee? Jamajjeya eya quea pame acui quea pame jayojja. ");
INSERT INTO eseNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Miquianaya aje oe peyo quea se nee nee jama, quea mase. Miquianaya quea tai poanijo quea pame mimi ajja. Eꞌe, quea jjashahuabaqui tai po tiitiianijo quea tai mimiani —Paniseo cuana acanaje Jesosaa—. ");
INSERT INTO eseNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Eꞌe, joya quea jjashahuabaqui jaꞌa nee poanijo quea jaꞌa nee baꞌyani. Quea jjashahuabaqui taijo ca ca quea tai baꞌyani. ");
INSERT INTO eseNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jamajjeya eyaya miya huohuije e epoe oꞌoyajjijo ojjaña mimishi tecueaa, ojjaña joya jjaniñebaquiani, mimijajiani, siajje poani peaꞌai quea nee nee po tiitii meejeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Eꞌe, miquea esohui quea jaꞌa nee poanijo, Eyacuiñajjiya miya etecueajji pojjeama. Quea shoꞌi taijo ca mi ca Eyacuiñajjiya quea nee nee po tiitii mee cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Majoya beca Paniseo cuaa, Moisesija tehue huohuijjiya peaꞌai Jesosa huohui canaje jama baꞌa: —Esohui huohuijji Jesosa, ¡quea pame acue! ¡Ma dejjaa ajjima acani aꞌoꞌoyacue soꞌo, Eyacuiñajjiya miya huoojea canaje ecuanaja ebajji! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","—Chojja. Miquianaaya Eyacuiñajjija esohui cajaa anaje. Jamajjeya miya peapea ba sa poani. Jamatii Eyacuiñajjiya yahuajo nei Jjonajo aca poa jayojja jama ohuaya jjeya acaje oꞌoya miquianaja ebajji. ");
INSERT INTO eseNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ma ecua yahuajo Eyacuiñajjija esohui huohuijji Jjona jai aiꞌaija seejo baꞌya poa pea beca peejjima cahuime jama jayojjaya aje eya ojjañaja Edoe Mese bajjani quijje pishana manoꞌyo majje mei jjanijo ehuananobia jaa shequije oꞌoya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Yahuajo nei nei dejja cuana Ninebejo baꞌeya Jjonaja esohui shajjaꞌajja majje mimishi cuana pajea caꞌya poa. Jjona quea caꞌa pishana poa; eya ca iña quea caꞌa nee nee. Jamatii miquianaya ecuea esohui shajjaꞌajja sa po ajja. Jamajjeya quijje eya poe oꞌoya majje mimishi cuana tecueajeaje. Ninebe dejja cuaa miya tecuea caje jama baꞌa: “Miquianaya ca ca oe quea mimishi nee nee poanaje”. ");
INSERT INTO eseNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jama peaꞌai poaje baꞌa: Yahuajo nei nei Sama mese epona quea huesha nee poeya poa Jodioja emeshi mese Sanomoja esohui shajjaꞌajjaa. Sanomo quea jjashahuabaqui jaꞌa pishana poa; eya ca quea jjashahuabaqui jaꞌa nee nee. Jamatii miquianaya ecuea esohui shajjaꞌajja sa poꞌyo ajja. Jamajjeya quijje eya poe oꞌoyaje mimishi cuana tecuejeaa, eeno poejjijje emeshi mese ponaa, Sama meseya jama miquianaya tecueame acaje peaꞌai baꞌa: “Miquianaya ca ca oe quea mimishi nee nee poanaje” acaje nequiana —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesosaa esohui ejjabahuejjaqui meejji huohui canaje peaꞌai jama baꞌa: —Eshahua dejjaja yamijo nequi cuayaquiꞌyo majje quea huesha poquinaje. Saꞌajja canaje pea huasijje enequijji. Jamatii baꞌyo jjima. Oya poꞌayequiequi tii. ");
INSERT INTO eseNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jamajjeya oya jjashahuabaquiani jama baꞌa: “Eya poquije oꞌoya huacuaya oyaꞌ dejja huasijjeya, ma e cuayaquinaje yasijjeya, ma ecuea equi jayojja huasijjeya”. Jamajjeya oyaꞌ dejja huasijje poe oꞌoya majje ba cañaquiꞌyani chamaꞌ enahuejji Eyacuiñajjija epeejji nei pojjeama jjejojo. Ojaya eyami equi ecuiashaba jayojja jama, ehuana bame bame jayojja, equi se ejjamaꞌ jayojja. ");
INSERT INTO eseNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jamajjeya oya poquije pea eshahua cuana saꞌajjaa. Ba caje quea huiso, me mijijje beca onijje enequijji. Oya cuana quea mase nee nee; pea quea mase pishana. Majoya ojjaña dobiquiajo ma dejja quea yeno nee nee poani. Yahuajo oe eshahua nequia huajo quea yeno pishana poanaje. Jamaya poanaje Jesosa shajjamaꞌ cuana nijje, oya cuana onijje jjapeequi sa po ajjajo. —Ma dejja jayojjaya miya poaje, quea mimishi nee nee tii tii poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesosa mimianijo ojaya enaese, oja chahua cuana peaꞌai o que poeyanaje. Esecuejo nequinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Majoya Jesosa huohui canaje cuaa: —Miquea enaese, mique chahua cuana esecuejo nequi. Minijje mimi sa poani. ");
INSERT INTO eseNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Jesosaa sajaꞌa canaje: —¿Ache shai ecuea huapa pojjeama cuana? ¡Bacue! Jiquio ecuea shajjaꞌajjajji cuana ecuea huapa pojjeama cuana, ecuea quea jea nee nee ecuea ecue nae quea jea aña jayojja jama. ");
INSERT INTO eseNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Eꞌe, ecue Chii eyajo ani; ojjaña jjashajjaꞌajjaquiani ojaya esohuijo ecuea huapa pojjeama, ecue chahua, ecue jjoꞌi, ecuea enaese peaꞌai —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Majoya Jesosa equijo ani cuayaquinaje. Bae sahua huasijje poqui majje anioquenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Majoya o que jjachichaquinaje dejja cuana quea huiso nee nee. Jamajje bishe yasijje nequisohuaqui majje anioquenaje esohui huohuiya. Dejja cuana meshijajijo aninaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bishe quecuayiyejea cajo, Jesosaa oya sohuihuohui canaje quea huiso nee nee. Pea esohui ona jjashahuabaquijji huohui canaje o ba meesahuajji. Jama acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","—Ebanajji cuana poquinaje banaa. Esoꞌ jeaaja canijo, oe pojji esoꞌ oquequinaje ejiojji yasijje. Poeyanaje cuichojji cuana; ijjia caꞌyonaje esoꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pea esoꞌ oquequinaje mei biajje. Meshi chamajo esoꞌ pohuaꞌajjaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Quijje cuayanaje eshequi. Quiyoꞌyonaje, esajja jocaꞌyonaje, manoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pea esoꞌ oquequinaje acuisha huasijje. Pohuaꞌyo majje jjonohua bebo caꞌyonaje. Tatajo nequi jjajja ajja poanaje. Manoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pea esoꞌ oquequinaje meshi quea pame yasijje. Pohuaꞌyonaje esoꞌ cuana. Ejjajja quea pame nee nee poanaje. Oe esajo ejjajja iye huiso aninaje; pea esajo ejjajja quea huiso, pea esajo quea huiso nee nee aninaje. Sejja canaje quea huiso nee. ");
INSERT INTO eseNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Miya jjashajjaꞌajjaquicue! ¡Aꞌa shajjamaꞌ pojji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Quijje o shajjaꞌajjajji cuana poeyanaje Jesosa que. Huohuiꞌajja canaje: —Jesosa, ¿apiojji miyaya esohui eba meesahuajji quea quehua huohuiaña jiquio dejja cuana huasijje? ");
INSERT INTO eseNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Oya cuana sajaꞌa canaje Jesosaa: —Miya ca ca oe Eyacuiñajjiya ba meesahua cani eya ojjañaja Emeshi Mese nei poajeꞌyo. Yahuajo ba mee jjima poa. Pea cuana ca ca eba meesahuajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jamajjeya joya Eyacuiñajjija esohui ba cani quea huiso pishana quijje quea huiso ba mee cajeꞌyo. Joya ojaya esohui ba sa po ajjaa ca ca pajea cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jamajjeya eyaya peapea esohui eba meesahuajji huohuinaje o ba meesahuajji. Jamatii ecuea esohui shajjaꞌajja majje oya cuana jjashahuabaqui ajja, de, shajjaꞌajja jjima jama acani, de. ");
INSERT INTO eseNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Eꞌe, oya cuana quea sapa caꞌa nee poani. Jamajjeya Eyacuiñajjiya Isaia tehue mee ca poa yahuajo nei nei jama baꞌa: “Shajjaꞌajja huichaꞌa huichaꞌa majje jamatii jjashajjaꞌajjaqui ajja poaje. Eyacuiñajjiya acani ba huichaꞌa huichaꞌa majje jamatii jjashahuabaqui ajja poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Quea sapa caꞌa nee nee poani, shajja dojjomaꞌ jama, cojjamaꞌ jama peaꞌai. Ecuea esohui eba jojjemo, eshajjaꞌajja jojjemo jjabahuejjaquiꞌyome. Peaꞌai enijje ejjapeequiꞌyo jjemo eyaya mimishi cuijeaꞌyome”. Jamaya yahuajo nei nei tehue ca poa etiiquiana Isaiaa —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jamajjeya Jesosaa o shajjaꞌajjajji cuana jama acanaje peaꞌai baꞌa: —Miquianaya ca ca quea cojja jaꞌa, quea shajja jaꞌa peaꞌai. ¡Jamajjeya quea bihui nee pocue! ");
INSERT INTO eseNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eꞌe jojo nei eyaya miya huohuiaña jama baꞌa: Quea huiso Eyacuiñajjija esohui huohuijji yahuajo, ojaya epeejji nei yahuajo baꞌe peaꞌai e ba sa neinei poa. Ecue huohui shajjaꞌajja sa neinei poa peaꞌai. Jamatii ojaya eya ba jjima poa. Ecue huohui shajjaꞌajja jjima peaꞌai poa. Eꞌe jojo nei eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Ma ba sa poa Eyacuiñajjija esohui huohuijji yahuajo nei nei. ");
INSERT INTO eseNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Majoya ojjaña cuana acanaje Jesosaa: —Jamajjeya eyaya miquianaya ba meesahuaje ecuea esohui ebanajjijo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Maya: Beca cuana ejiojji yasijje oquequi esoꞌ cuana cuichojjiya ijjiajeyo caꞌyonaje. Jamaya beca cuana ecuea esohui eya ojjañaja Emeshi Mese oe nei poaje shajjaꞌajja majje jamatii jjashahuabaqui ajja. Jamajjeya Edosiquiaa o que poe majje ecuea esohui pajea mee cani. ");
INSERT INTO eseNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Beca cuana esoꞌ mei biajje oquequinaje jayojja jama ecuea esohui shajjaꞌajja majje quea bihui nee enijje jjapeecuajiꞌajjaquiani. Jamatii ecuea esohui jayojja jama baꞌe tiitii ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Esoꞌ mei biajje pohua esajja jocaꞌyajo manoꞌyani jayojja jama poani; pea cuaa oya napa cajje Eyacuiñajji nijje jjapeequipajeani. ");
INSERT INTO eseNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Beca cuana esoꞌ acuisha nijje pohuani jama poani. Acuishaa bebo cajje jjajja ajja jayojja jamaya ecuea esohui shajjaꞌajja majje jjapee nishoquiani. Jamatii oya cuana quea bejjo nahue poanijo, aquianajo quea huiso jjashahuabaquianijo, quea mete peaꞌai poanijo Eyacuiñajjijo chaco ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Esoꞌ meshi quea pame neejo pohua majje quea jjajja huiso poanaje jayojja jama beca cuana; ecuea esohui shajjaꞌajja majje jjabahuejjaquiani; ecuea epeejji quea jaꞌa nee nee poani, pea cuana ejo jjabahuejjaqui meesahua cani iye huiso pojjaꞌa, quea huiso pojjaꞌa, quea huiso nee nee pojjaꞌa —Jesosaa mahuisoya oya cuana acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Majoya Jesosaa oya cuana huohui canaje pea esohui eba meesahuajji. Jama poanaje baꞌa: —Eyacuiñajjija esohui ejo ebanajjiya esoꞌ bana canaje jama. Esoꞌ ache bame nei quecua canaje quejo, anoso. ");
INSERT INTO eseNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Majoya ojjaña echacojji cuana ecahuijaajo, dejja quea mimishi, o jeabichajeajji epo poeyanaje. Sipone soꞌ quea huiso quehuajje nei jeaajaqui canaje quejo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Anoso pohuaꞌyo majje jjajjanaje. Sipone pohuanaje anoso tejjee, jjajjanaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Quijje pishana eque meseja echacojji cuana o que poeyanaje. Jama poanaje baꞌa: “Emeshi mese, ¿aꞌa miquea anoso sipone tejjee quecua pojjeama poanaje?” huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—Echacojji meseya sajaꞌa canaje: “Eꞌe, quea pame poanaje. Dejja quea mimishiya quehuajje jeaajaqui canaje sipone soꞌ ecuea quejo, de” poanaje. —Echacojji cuaa huohuiꞌajja canaje: “¿Aꞌa sipone chiyojeajeꞌyo?” ");
INSERT INTO eseNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—“Chojja” poanaje eque mese. “Anosoya miyaya chiyojea chanaꞌ. Jamatii. ");
INSERT INTO eseNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ojee sipone nijje catiiquiahua. Eꞌe, majoya anoso jahuajo eyaya huoojeaje anoso sejjaꞌyojji cuana anoso sejjaa. Sejjajeyo majje anoso chichaje. Ecuea equi yasijje iyanobiaje anoso, ecuea ejaahuanajji. Sipone ca oe caquiyojeaquiꞌyahua pasiꞌyo majje” poanaje eque mese. —Eꞌe, jiquio eque meseya sipone dahuajea cani jama dejja mimishi Eyacuiñajjiya acajeꞌyo. Anoso sejjajeyo majje equijo huana cani jamaya ecuea epeejji ajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Majoya Jesosaa pea esohui eba meesahuajji huohui canaje jama baꞌa: —Eyacuiñajjija ehuohui ojaya epeejji cuanajo jama peaꞌai baꞌa: Pea esoꞌ motasa che biso nei esoꞌ bana cani equi quibojo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jiquio esoꞌ che biso nei nei; tii majjeya quea cui quemo nee poaje apoꞌe cui quemajja. Jamajjeya cuichojji cuana poeyani motasa acui biajje cahuiya —jamaya Jesosaa huohui canaje ojjaña ba meejji quijje Eyacuiñajjija epeejji cuana quea huiso nee, quea caꞌa nee poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pea esohui eba meesahuajji huohui canaje Jesosaa jama baꞌa: —Eponaa pahui dahuajjiya quea huiso nee pohuipohui tejjee oe pojji nei nei eshejjee meejji iñahuahuo neinei cani, ojjaña eshejjee meejji. Jiquio eshejjee meejjiya ojjaña pohuipohui shejjee mee cani jamaya poaje ecuea epeejji cuana. Jama baꞌa: Jjeya beca cuana jjashajjaꞌajjaquiani. Majoya aje quea huiso nee ojjaña pojjaꞌa jjashajjaꞌajjaqui mee cajeꞌyo Eyacuiñajjijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Eꞌe, jiquio esohui ehuohuiꞌyo cuana Jesosaa ma bishejo nequiya huohui canaje. Esohui eba meesahuajjijo ca ca oe huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jamaya poanijo ohuaya Eyacuiñajjija esohui huohuijjija esohui yahuajo nei nei jama acanaje. Jamaya aje yahuajo nei nei Eyacuiñajjiya ojaya esohui huohuijji huohui mee ca poa Jesosajo baꞌa: “Eyaya aje jja esohui huohuije esohui eba meejji. Yahuajo jiquio meshi panajeyo majje ecuea dejja cuana ba meesahua jjima poanaje ecuea ejjashahuabaquiꞌyojji. Jjeyahua ca ca ecuea ejjashahuabaquiꞌyojji ba meejeꞌyo, eyaya”. ");
INSERT INTO eseNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Majoya Jesosaa —Poquia iña —acanaje dejja cuana. Bishejo ani cuayaquiꞌyo majje poquinaje equi yasijje. Dobiqui majje o shajjaꞌajjajji cuana o que poeyanaje. Huohuiꞌajja canaje: —Jesosa, ¡ba meesahuacue ehuohuiꞌyo siponejo! Maya ecuanaja quea quehua. ");
INSERT INTO eseNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jamajjeya Jesosaa oya cuana huohui canaje: —Eꞌe, eya ojjañaja Edoe Mese anoso banajji nei nei jama. ");
INSERT INTO eseNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Que quea pame jayojja ojjaña dejja ojjaña meshijo baꞌe cuana. Esoꞌ quea pame nee Eyacuiñajjija epeejji nei jayojja jama. Sipone soꞌ quea tai jayojja eshahuaja epeejji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Joya dejja sipone soꞌ jeaajajji epo jayojja jama dejja mimishi, e cuiajji nisho epo, Edosiquiana, de, Satanasa. Jiquio ecua epojja anoso jahuajo sejjajeyo caꞌyonaje jama meshi oe poaje. Joya anoso sejjaꞌyojji ca ca Eyacuiñajjija esohuidojojji cuana jama. ");
INSERT INTO eseNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jamajjeya jiquio ecua sipone pasiꞌyo majje dahuajea canaje jayojja jamaya poaje dejja mimishi meshi oe poajo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","—Eꞌe, eyaya ojjañaja Edoe Meseya esohuidojojji cuana huoojeaje dejja mimishi cuana iñaa, ona mimishi po meejji poani peaꞌai iñaa. ");
INSERT INTO eseNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iña majje jeajea cajeꞌyo cuaqui quea quiyo nee nee yasijje. Jomajo pa neineijeꞌyo; eseꞌ ijjiayaijea cajeꞌyo cuaqui quea quiyo nee neejo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ecuea epeejji ca ca ecuea esohui jama acanijo baꞌe tiitiijeꞌyo eyajo eseja Chii nijje quea jaꞌa nee nee, eshequi jaꞌajja, de —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Majoya Jesosaa huohui canaje pea esohui eba meesahuajji jama baꞌa: —Eyacuiñajjija esohui cuana ojaya epeejji cuanajo jama peaꞌai baꞌa: Quejo aquiana pame quea nahue nee nee ba majje dejja jjataqui canaje jomajo tii. Majoya oya quea bihui nee poquinaje. Ojjaña ojaya aquiana cuana dojo canaje; quia canaje que sosejje. Jiquio ecua aquiana quea nahue nee nee jjeshe canaje jama jayojja dejja Eyacuiñajji nijje jjapeequiani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Eyacuiñajjija esohui ojaya epeejji cuanajo jama peaꞌai baꞌa: Dejja aquiana nahuejjiya saꞌajja tiitii canaje mei sisi siyosiyo copocopo quea nahue nee. ");
INSERT INTO eseNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oe mei sisi siyosiyo copocopo quea nahue nee nee ba majje ojjaña ojaya aquiana quiaa dojo canaje mei siyosiyo quea pame nee nee jjeshejji. Eya ca ca iña mei quea nahue nee nee quea pame nee nee jama, ojjaña jaahuanajji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Eꞌe jojo nei pea baꞌeme epojji jamaya peaꞌai baꞌa: Nahuoo cuiashajajji jea cani cuaa bae yasijje. Nahuoo cuiashaja cajje dobiquiani. Peapea nahuoo cuiashaja cani. ");
INSERT INTO eseNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Quea huiso yanijo nahuoo cuiashajajji cuaa meshijaji sahua huasijje jjequisohua cani. Majoya pejo majje nahuoo cuana ba cani. Ojjaña nahuoo quea pame nee bio cani jjepai yasijje; peajja ijjia ca ajja jojoya ca ca jeajea cani. ");
INSERT INTO eseNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jamaya poaje e poe oꞌoyajo. Esohuidojojji cuana poeje; Eyacuiñajjija epeejji cuana ojjaña quea pame baꞌe chicha cajeꞌyo. Dejja mimishi cuana ca ca jeajea cajeꞌyo cajaajojo. ");
INSERT INTO eseNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Cuaqui quea quiyo nee nee yasijje dobiquijeꞌyo tii tii. Jomajo siasiaꞌyoquije tii; eseꞌ ijjiayaijea cajeꞌyo quea nee poanijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Majoya Jesosaa oya cuana huohuiꞌajja canaje: —¿Aꞌa ecuea esohui quea jaꞌa nee? ¿Aꞌa jjabahuejjaquinaje? —Eꞌe, quea jaꞌa nee. ");
INSERT INTO eseNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jamajjeya Jesosaa o shajjaꞌajjajji cuana acanaje: —Eꞌaquiana meseya ojaya aquiana cuana etii, aquiana eyacua peaꞌai ojjaña cuana huohuiꞌajja cani. Jiquio ecua pea huohuiꞌajja pea huohuiꞌajja acani jayojja jama esohui huohuijji poani, jjabahuejjaqui majje, Jodio esohui huohuijjiya Eyacuiñajjija esohui yahuajo etehueꞌyo, ecuea esohui eyacua peaꞌai pea cuana ba meesahua cani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Majoya esohui huohuipajea majje Jesosa jomajo ani poqui oꞌoyanaje ojaya cuiñajji yasijje, Nasanena huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jodioja equi ojee ejjachichaquijji yasijje dobiquinaje. Esohui huohui canaje. Ojaya esohui shajjaꞌajja majje Nasanenajo baꞌeca cuana quea tecue poanaje. Oya Jesosa Joseja jea poso acanaje cuaa: —¿Yajjajje shai jiquio dejjaa Jesosaa esohui quea jaꞌa nee nee huohui cani, de? ¿Eyacuiñajji jayojjaya jjaajaqui mee cani emanojaa quea huiso nee, de? ");
INSERT INTO eseNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Oya aje oe acui cacajji nei neija bacua ejja pojjaꞌa, oja nae Mania bajjani, oja chahua cuana Jacobo, Jose, Simohui, Jonasa peaꞌai bajjani. ");
INSERT INTO eseNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Oja jjoꞌi cuana peaꞌai jiquiojo baꞌe, de. Jamajje ¿achejo joya Jesosaa ojjaña jiquio esohui ba canaje soꞌo? —jamajjeya quea quene poanaje Jesosa nijje. Joseja jea poso cajaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jamajjeya Jesosaa oya cuana jama acanaje baꞌa: —Eꞌe de, pea cuaa Eyacuiñajjija esohui huohuijji shajjaꞌajja cani. Jamatii oja meshijo baꞌe cuana ojaya huapa pojjeama cuana ca ca oe jjashajjaꞌajjaqui sa poꞌyo ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jamajjeya oya cuana jjashajjaꞌajjaqui sa po ajja. Jesosa Eyacuiñajjija bacua pojjeama posojo, ohuaya emanojaa cuana oe pojji jjaajaqui mee caꞌyonaje, ma dejjaa ajjima acani oe pojji nei acanaje Nasanenajo, Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Jesosa Janinea meshijo anijo, Janinea meshi mese Enode bajjaniya shajjaꞌajja canaje onaja ehuohuiꞌyo Jesosajo. Ma Enode pea emeshi mese, Enode peaꞌai bajjani. Oya emeshi mese Enodeja bacua ejja; oya Enode Antipa bajjani peaꞌai poanaje. Shajjaꞌajja majje ma Enodeya Huani shequi oꞌoya posoya acanaje: —Eꞌe de, jiquio dejja aje oe Huani, ma ona besameejji poa. Eꞌe pojjaꞌa oya manoꞌyo majje shequi oꞌoyanaje. Jamajjeya ohuaya Eyacuiñajjiya jayojjaya acani —jamaya ohuaya ojo chacochacoani acanaje. Yahuajo nei Jesosajo shajjaꞌajja jjimahuajo ma Enodeya Huani sapa jajasejjajea mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Eꞌe, yahuajo ma emeshi mese Enodeja edoe mese Penipeja ehuanase Enodiasi bajjani Huani nijje quea quene poa. Jamajjeya ma Enodeya Huani iña mee canaje; jeanobiajea mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eꞌe, Huaniya yahuajo ma Enode jama tecueame aca poa baꞌa: —¡Miyaya aje oe mique doeja Penipeja ehuanase Enodiasi aꞌa huanaꞌyojji! Jamaya pojjeama Jodioja etehueꞌyo; quea mimishi. ");
INSERT INTO eseNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jamajjeya ohua tecuea cajje quenequenenaje Huani nijje. Quecua sa aca poa. Jamatii quecua jjima; quea mete poanaje pea Jodio cuanajo. Eꞌe, quea huiso Jodio cuana jjashahuabaquinaje Huani Eyacuiñajjija esohui huohuijji nei nei poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jamatii ma Enodeya o cuaya poa pojjajo ojjaña ojaya epeejji cuana iyaa canaje ojee ijjiaꞌijjiaa, majamajaqui baa peaꞌai. Enodiasija bacuase peaꞌai oe nei majamaja nequinaje ojjañaja ebajji, quea bihui nee epo meejji. Enode Antipa quea bihui nee nee poanaje epona shoꞌijo. ");
INSERT INTO eseNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jamajjeya onijje miminaje jama baꞌa: —¿Ae shai sa poani miya? ¡Huohuicue mo! Eyaya miya quiaje. Eꞌe jojo nei nei she, coya miya sañaya aje mi quiaje —acanaje Enodeya. ");
INSERT INTO eseNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jamajjeya epona shoꞌi poquinaje ojaya enaese Enodiasi huohuiya. —Eꞌe —oja nae poanaje—, eꞌe ¡Huani sapa jajasejjajea meequicue, she! Epona shoꞌi poe oꞌoyanaje Enode que. Huohui canaje jama baꞌa: —Huani, ma ona besameejji poani ejeanobia jaa. ¡Ojaya esapa jajasejjajeaꞌyo majje piatojo jjequicue jjeyahua nei! Maya eya sa poani. ");
INSERT INTO eseNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Shajjaꞌajja majje emeshi mese Enode quea ajjajja nee nee poanaje. Jamatii ojaya esohui epona shoꞌi nijje ojjaña ojaya epeejji cuanaa shajjaꞌajja canaje. Jamajjeya ojaya esohui pajea ajja, Enodeja. Jamajjeya ohuaya sohuinano cuana huoojea canaje: —¡Epona shoꞌija esohui jayojja jama acue! ");
INSERT INTO eseNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","¡Huani ma ejeanobia jaa oe sapa jajasejjajeaquicue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jjeya nei sohuinano cuana poquinaje Huani que. Huani sapa jajasejjajea caꞌyonaje. Esapa jjequi canaje piatojo. Epona shoꞌi quia canaje. Majoya ohuaya Huanija esapa oja nae yasijje quia cañaquiꞌyonaje, epona shoꞌiya. ");
INSERT INTO eseNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Majoya Huani shajjaꞌajjajji cuana poeꞌyonaje o dojoꞌyohua emojeaꞌyojji. Mojeaꞌyo majje papoquiꞌyonaje Jesosa huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesosa Huani emanoꞌyo shajjaꞌajja majje o shajjaꞌajjajji cuana nijje sohuaquinaje bishe aijo quima huasijje. Jamatii ma ba majje quea huiso dejja cuana cuiñajji cuanajo baꞌe ejiojjijje poquinaje Jesosa baa. Poquicuajinaje ma Jesosa besapoquije yasijje. Onaya jjaja ebionei aniñaquinaje Jesosa hui que añaquiya. ");
INSERT INTO eseNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Quijje pishana Jesosa o shajjaꞌajjajji cuana nijje baꞌeñaquinaje. Bishe aijo ani nequisohuaquinaje etaja huasijje. Quea huiso nee nee dejja cuana ba cañaquinaje. Onajo quea yeno jjashahuabaquinaje, quea huiso emanojaajo, quea nee jaajo peaꞌai. Jamajjeya ojjaña huaquia mee caꞌyonaje, jjaajaqui mee caꞌyonaje, Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Siniajo Jesosa que poe majje o shajjaꞌajjajji cuaa huohui canaje jama baꞌa: —Jesosa, sinia coma, de. Jiquiojo chamaꞌ equi, chamaꞌ bobi peaꞌai. ¡Dejja cuana huoojeacue cuiñajji sisi cuana huasijje oja bobi jjesheya! ");
INSERT INTO eseNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Chojja. Caꞌaniahua cuana. ¡Bobiacue oe miquiaaya! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—¿Yajja yajji? Oya cuana quea huiso nee nee aña ebobiajji. Ecuanaja bobi oe pojji yani. Me oejje pahui, beca nahuoo sisi peaꞌai yani —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—¡Comaya jjajja oe yacua yecue! —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ojjaña cuana jama acue peaꞌai baꞌa: “¡Ojjaña anioquecue sipone biajje!” acue. Anioque mee canaje sipone biajje. Majoya pahui me oejje huiso, nahuoo sisi becanejjijji peaꞌai jjeshe majje Jesosaa eyahuasijje jjabajeasohuaquinaje. Eyacuiñajji bihuia canaje. Eyacuiñajji nijje bobijo mimi majje pahui miji canaje, nahuoo sisi peaꞌai. O shajjaꞌajjajji que quia canaje, Jesosaa. Majoya ohuaya bobi quia canaje dejja cuana huasijje. Quia ca poquije quea huiso nee nee jjapanaqui poquipoquinaje bobi, de. ");
INSERT INTO eseNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ojjaña jejje majje eshajjaꞌajjajji cuaa chicha caꞌyonaje bobi ojjañaja ijjiasejja. Jjepai ai yasijje iya caꞌyonaje. Quea huiso nee poanaje; 12 jjepai huisome bobi eꞌijjiasejjaja ecuatajea poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Quea huiso nee nee bobi ijjia mee canaje, de, 5.000 dejja. Epona cuana, eshoꞌi cuana peaꞌaiya quea huiso nee nee ijjia canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Majoya siniajo Jesosaa o shajjaꞌajjajji cuana huoojea canaje. Jama acanaje baꞌa: —¡Bishe ai yasijje nequisohuaquicue! ¡Bae ojje miji yasijje besapoquicue! Quijje eya poquije mi que pea dejja cuana quea huiso nee nee cuana huoojeaꞌyo majje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Majoya dejja cuana quea huiso cuana huoojeaꞌyo majje eyiyo huasijje jaasohuaquinaje oe nei oja Chii nijje mimiya. Mecajje Jesosa oe nei aninaje eyiyojo. ");
INSERT INTO eseNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jesosa eyiyojo anijo o shajjaꞌajjajji cuaa bishe ai quea huesha nee dojo canaje. Bae yiyesamajo o epojo beni quea quemo poeyanaje. Enashajohua bishe ai janobajjima nei nane canaje, cuio canaje enaa. ");
INSERT INTO eseNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mecashono Jesosa eyiyojo ani o que poquinaje ena biajje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","O shajjaꞌajjajji cuaa Jesosa quea huesha pishana ena biajje jeojeojebeje ba majje quea ajjajja nee nee poanaje. Quea metejo taaanaje; jama poanaje baꞌa: —¡Coya ae shai poeje baꞌa! —siasianaje—. ¡Coya eshahua, de! ");
INSERT INTO eseNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jamajjeya Jesosa onijje miminaje. Jama poanaje baꞌa: —¡Aꞌa quea mete pojji! Eya jja iña iquio, eshahua pojjeama. ¡Quea jaji nee pocue! ");
INSERT INTO eseNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jamajjeya Penohua jama huohuime acanaje baꞌa: —Ecuea Emeshi mese, miya enequiya jjejojoya, ¡eya mi que poqui meecue ena biajje! ");
INSERT INTO eseNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Eꞌe Peno, ¡poecue! —oya acanaje Jesosaa. Jamajjeya Peno bishe aijo ani nequioquequinaje. Ena biajje Jesosa que poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Jamatii poqui pishana majje beni tii tii, enashajo quea quemo nee nee ba majje metenaje, de. Mete majje jaadobiꞌajjaquinaje Peno. Taaanaje: —Jesosa, ¡eya huiꞌijeꞌyo! ¡Iñacue mo, oe! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesosaa meꞌ iñacuaji canaje. Peno jama acanaje baꞌa: —¿Apiojji acuae mi meteani soꞌo? ¿Aꞌa eya quea caꞌa nee nee miquea ba jjima? ");
INSERT INTO eseNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Majoya Jesosa Peno nijje bishe ai yasijje anisohuaquiꞌyajo beni nequioquequinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jamajjeya ojjaña cuana bishe aijo aniya Jesosa bihuia canaje. Jama poanaje baꞌa: —¡Eꞌe jojo nei miya Eyacuiñajjija Bacua Ejja oe nei! ");
INSERT INTO eseNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Majoya bae ai ojje miji yasijje Jenesaneꞌ meshi yasijje besapoqui oꞌoyanaje Jesosa. Baꞌeñaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dejja cuanaja jomajo baꞌeja Jesosa eba poanaje yahuajo. Jamajjeya oya ba oꞌoya majje ojjaña cuana iyaa meequi canaje Jesosa que. Jamajjeya ojjaña emanojaaca cuana Jesosa que ye canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jama huohuiꞌajjame acanaje cuaa baꞌa: —Jesosa, ¡ojjaña emanojaaca cuana che mique daqui iñaꞌajja meecue ehuaquiaꞌyojji! —acanaje. Ojjaña oja daqui cuema iñaꞌajja majje jjaajacuajiquiꞌyonaje, huaquiaꞌyonaje peaꞌai, de. ");
INSERT INTO eseNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Majoya Paniseo cuana Jodio esohui huohuijji cuana peaꞌai Jenosanenajo baꞌe Jesosa que poeyanaje. Oya huohuiꞌajja canaje: —Esohui huohuijji, ¿apiojji acuae mi mi shajjaꞌajjajji cuana etiiquianaja ehuohuiꞌyo jama po ajja? ");
INSERT INTO eseNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Eꞌe, ijjiaꞌijjia jjimahuajo emeꞌ topo neinei ajja, de. ");
INSERT INTO eseNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesosaa sajaꞌa canaje jama baꞌa: —Miquianaya acuae ¿ae poani peaꞌai? ¿Apiojji acuae miquianaaya Eyacuiñajjija esohui pajeaꞌyaña etiiquianaja ehuohuiꞌyo yajji nisho? ");
INSERT INTO eseNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Eꞌe, Eyacuiñajjija esohui jama poani baꞌa: “¡Mique chii, miquea enaese etii peaꞌai jaahuanacue! ¡Joya oja chii, oja nae peaꞌai cajaa acajo cajajahuejjajea caꞌyahua cuaa, meiya!” ");
INSERT INTO eseNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Miyaya ca ca jama huohui taime yaña baꞌa: “Dejja oja chii etii nijje, oja nae etii nijje pojjaꞌa mimije jama baꞌa: “Eyaya miya ebaꞌe meesahuajji pojjeama. Chojja, eyaya ecuea aquiana Eyacuiñajji yasijje quiaña o bihuiajji”. ");
INSERT INTO eseNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jamajjeya oja chii etii, ojaya enaese etii peaꞌai pajea meeaña. Peaꞌai Eyacuiñajjija esohui pajea meeꞌyo sa aña etiiquianaja ehuohuiꞌyo yajji nisho. ");
INSERT INTO eseNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Miya ca mi ca oe jjadasiaquijji nei nei! Eyacuiñajjija esohui huohuijji Isaiaja esohui mijo eꞌe jojo nei yahuajo nei poa. Eꞌe, yahuajo nei Eyacuiñajjiya Isaia tehue mee ca poa jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Jiquio dejja cuanaa eya bihuia nisho cani. Jamatii jjashajjaꞌajjaqui ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jamajjeya ecuea equi yasijje jjachichaquiani ejjachichajeaquijji. Ohuaya ojaya ejjashahuabaquiꞌyojji huohui cani, ecuea esohui pojjeama”. Jamaya Isaiaa yahuajo nei tehue ca poa miquianajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jamajjeya Jesosaa pea cuana huasijje jama huohuime acanaje baꞌa: —¡Shajjaꞌajjacue, jjabahuejja neineiquicue oe! ");
INSERT INTO eseNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bobi cuana, ojjaña aquiana enabajje dobiquianijo pojjeama miquianaya quea mimishi poani. Chojja. Quea jjashahuabaqui tai po majje esohui quea tai enabajje cuayaquianijo ca ca quea mimishi poani. Eyacuiñajjiya miquianaya ba cani quea mimishi —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Quijje o shajjaꞌajjajji cuaa Jesosa huohui canaje jama baꞌa: —Jesosa, miquea esohuijo Paniseo cuana quea quene poani minijje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesosaa oya cuana sajaꞌa canaje jama baꞌa: —Ojjaña acui ecue Chiija eyajo anija bana pojjeama ohuaya chiyojea cajeꞌyo jiquio ecua ohuaya ojaya epeejji nisho acajeꞌyo jama. ");
INSERT INTO eseNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jamajjeya ¡aꞌa Paniseo cuanajo quea mete pojji! Oya cuaa aje oe esohui huohui cani quea tai, quea jaꞌa pojjeama. Cojjamaꞌ jayojja jama poani, de. Cojjamaa pea cojjamaꞌ mepejjejea cani jayojja o peaꞌai oquejeaquijeꞌyo jjani yasijje. Cojjamaꞌ jayojja dejja mimishi pea dejja mimishiya dojo cajje cuaqui yasijje poquijeꞌyo onijje tii —jamaya Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Penohua Jesosa huohuiꞌajja canaje: —Jesosa, ecuanajaya ca ca esohui quea quehua miquea. ¡Ba meesahuacue mo! ");
INSERT INTO eseNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Aꞌa ecuea esohui miquianajaya ba jjima peaꞌai? —Jesosa poanaje—. ¿Aꞌa miquea eba pojjeama? ");
INSERT INTO eseNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ojjaña bobi, pea aquiana peaꞌai enabajje ijjiajea see ai yasijje dobiquiani. Quijje jamatii seejea cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Joya quea tai jjashahuabaquianiya ca ca esohui tai jeacuaya cani. Maaya oya quea tai po mee caꞌyani; quea mimishi Eyacuiñajjiya oya ba cani. ");
INSERT INTO eseNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Eꞌe, jjashahuaba taiqui majje pea quecua cani, onaja eponajo baꞌe sa poani, peaja yahuejo baꞌe sa poani, quehuajje cojjo cani, sii cani, siajje poani, mimijajiani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eꞌe, joya jama acanijo Eyacuiñajjiya ba cani quea mimishi; bobi ijjia cani emeꞌ shacua neinei jjimajo pojjeama quea mimishi poani. ");
INSERT INTO eseNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Majoya Jesosa Jenesaneꞌ meshijo ani poquinaje Sinono meshi yasijje, Tino meshi yasijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jomajo poquiani oe Cananea epona ma meshijo baꞌe o que poeyanaje. Oya Jodio pojjeama. Jamatii ejiojjijje poquije taaa majamaja poquinaje: —Emeshi Mese nei, Dabija osecua, ¡ejo jjashahuabaquicue! Ecue bacua piona quea sapa niñe jaa. Quea nee nee poani, quea mano. ");
INSERT INTO eseNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jamatii Jesosaja oya sajaꞌa jjima. Jamajjeya ojaya eshajjaꞌajjajji cuana Jesosa nijje miminaje: —Jesosa, ¡epona huoojeacue! Joya ese nijje taaajebeje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jamajjeya oya cuana sajaꞌa canaje Jesosaa: —Oya Jodio pojjeama. Eyacuiñajjiya eya huoojea canaje Jodio cuana saꞌajjaꞌyohua. Oya cuana ñajjajja ecuaquishoꞌyo jayojja jama poquiquehuani Eyacuiñajjijo. ");
INSERT INTO eseNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jamatii epona Jesosa que poe majje ecuiꞌoshajjajo nequiñanaje; jama poanaje baꞌa: —Emeshi Mese nei, ¡ecuea ebacua piona jjaajaqui meeꞌyocue, quea mano nee nee jaa! ");
INSERT INTO eseNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma epona Jodio pojjeamajo huapa jayojja sajaꞌame acanaje Jesosaa: —¿Aꞌa acuae ecue bacuaja bobi jeaje iñahuehua que? ¿Aꞌa cuae jamaya quea pame? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Epona quea shoe jama jjejojo jama poanaje baꞌa: —Eꞌe, Emeshi Mese. Jamatii o huonejjiya ijjia canijo, iñahuehuaa ehuonejjija ijjiasejja caꞌijjia cahua —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Epona, miya ca mi ca oe quea jaꞌa nee, quea pame nee ejo jjashahuabaquiani. Jamajjeya eyaya miquea esohui jayojja jama ajeꞌyo. Jjeya nei miquea ebacua piona jjaajaqui meejeꞌyo —Jesosaa acanaje. Jamajjeya jjeya nei oja bacua piona jjaajaquiꞌyonaje; quea aja nee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Majoya Jesosa jomajo ani ejiojjijje poqui oꞌoyanaje Janinea bae sahuajje. Eyiyo huasijje jaasohuaqui majje anioquenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Quea huiso nee nee poeyanaje; o que jjachichaquinaje. Jjequi canaje emanojaaca cuana: quibojjisha cuana, cojjamaꞌ cuana, jiojjijjajja cuana, mimiꞌajja cuana peaꞌai, peapea epoꞌyo cuana peaꞌai huanaoquea canaje cuaa Jesosa pejjejo ejjaajaquiꞌyojji. Ojjaña cuana jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje, de, Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ba majje ojjaña cuana quea bihui nee nee poanaje. Eyacuiñajji bihuia neinei canaje: —Eꞌe, e, mimiꞌajja cuana quea jaꞌa mimi mee caꞌyonaje; jiojjijjajja jeo mee caꞌyonaje; quibojjisha jjaquibopiqui mee caꞌyonaje; cojjamaꞌ quea cojja jaꞌa po mee caꞌyonaje, jjabaqui mee caꞌyonaje peaꞌai. Ma ecua ohuaya jjajaꞌaqui jjimahua Isaeni cuana nijje acaninaje, jamaya aje jja oe jjeya acani, Jesosaa —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Majoya Jesosaa o shajjaꞌajjajji iyaa canaje. O que poeyajo huohui canaje jama baꞌa: —Jiquio dejja cuana enijje poani beca cahuime. Ojaya bobi oe poanaje. Jamajjeya ojo eya quea yeno jjashahuabaquiani bobimajo. Oja equi yasijje huoojea sa poꞌyo ajja. Quea shoe nee nee; ejiojjijo bobi yasijje po chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","O shajjaꞌajjajji cuaa Jesosa sajaꞌa canaje: —Jiquiojo chamaꞌ bobi, dejjamaꞌ. ¿Yajja yajji? Oya cuana quea huiso nee nee ebobiajji. ¿Achacua pahui ejjeshejji ojjaña bobiajji? ");
INSERT INTO eseNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Ache huiso pahui miquea yani? —Jesosaa huohuiꞌajja canaje. —Me oejje beca peaꞌai, 7 pahui yani. Nahuoo sisi oe pojji yani peaꞌai —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jamajjeya Jesosaa ojjaña ejjachichaquiani cuana jama acanaje baꞌa: —¡Meshijo anioquecue! —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Majoya ma 7 pahui, nahuoo sisi peaꞌai jjeshe majje Eyacuiñajji nijje, oja Chii nijje miminaje bobijo. Pahui, nahuoo peaꞌai miji canaje, Jesosaa. O shajjaꞌajjajji que quia canaje. Majoya ohuiya dejja cuana huasijje quia canaje. Quia ca poquije quea huiso nee nee jjapanaqui poquipoquinaje, bobi. ");
INSERT INTO eseNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jamajjeya ojjaña cuaa ijjia canaje, quea jejje poanaje, de. Ijjia majje o shajjaꞌajjajji cuaa bobi eꞌijjiasejja jjepai aijo chicha caꞌyonaje. Quea huiso poanaje, 7 jjepaime. ");
INSERT INTO eseNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eꞌe, dejjaa quea huiso nee neeya bobi ijjia canaje, 4.000 dejjaa. Quea huiso nee epona cuana, eshoꞌi cuana peaꞌaiya ijjia canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Majoya Jesosaa ojjaña cuana huoojea canaje ojaya equi yasijje. Majoya Jesosa o shajjaꞌajjajji cuana nijje bishe ai yasijje nequisohuaquinaje. Besapoquinaje ojje, pea meshi yasijje, Majadana meshi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Majoya Paniseo cuana, Sanoseo cuana peaꞌai poeyanaje Jesosa que. Oya cuaa Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama poso acanaje. Jamajjeya jama anisho canaje baꞌa: —Esohui huohuijji Jesosa, ¿aꞌa miya Eyacuiñajjija huoojeaꞌyo nei ojjaña jaahuanajji pojjaꞌa? ¡Ejjabaꞌajjaqui soꞌo! ¡Eyacuiñajjiya jayojja jama acue ecuanaja ebajji! ¡Eyajo oe panacue! —acanaje Paniseo cuaa. Jamatii Paniseo cuaa Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama poso acanaje. Jamajjeya pea Paniseo cuana nijje jama poanaje baꞌa: —Chojja, Jesosa Eyacuiñajjija huoojea pojjeama. Jamajjeya Eyacuiñajjiya jama pojjeama mi pana cajo, capajea caꞌyahua. ");
INSERT INTO eseNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesosaa oya cuana sajaꞌa canaje: —Eshequi oquequiajo bo huoꞌohuoꞌo poanijo miquianaaya huohuiaña: “Eꞌe, de, mecahuajje quea jea poaje eshequi, ena epojji pojjeama”. ");
INSERT INTO eseNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mecajjeahua ca ca quea apo nee nee poanijo miquianaya jama poani baꞌa: “Eꞌe de, quea apo; jjeya ena poaje”. Eꞌe —Jesosa poanaje—, eyahuasijje bo ba majje miquianaaya huohuiaña ena chamaꞌ pojjaꞌa, ena poaje pojjaꞌa. Jamatii Eyacuiñajjija esohuijo miquianajaya ba jjima ache shono ojjaña jaahuanajji poeje. ¿Apiojji miquea ba jjima? ");
INSERT INTO eseNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Miquianaaya Eyacuiñajjija esohui pajea yaña. Jamajjeya Eyacuiñajjiya pana cani ba majamaja sa poani. Jamatii Eyacuiñajjiya Jjona yahuajo nei nei aca poa jayojja jama ohuaya jjeyahua acaje miquea ebajji. Jamajjeya Jesosaa oya cuana jea canaꞌyonaje jjabahuejjaqui ajjajojo. ");
INSERT INTO eseNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Majoya bae ojje miji yasijje besapoquianijo Jesosa shajjaꞌajjajji cuana jjashahuabaquinaje. Jama poanaje baꞌa: —Eꞌe de, ecuanaa bobi pajeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jamajjeya Jesosaa oya cuana huohui canaje: —¡Quea jaꞌa nee jjashahuabaquicue! Paniseo cuana, Sanoseo cuana peaꞌaija pahui shejjee meejjijo miya quea tai poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jamajjeya o shajjaꞌajjajji cuana ojee mimimiminaje: —Eꞌe pojjaꞌa oya jama poanaje ecuanaja pahui ye jjimajo. ");
INSERT INTO eseNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ojaya ejjashahuabaquiꞌyojji Jesosaja eba poanaje. Jamajjeya oya cuana acanaje: —¿Apiojji acuae jja nequiana ojee mimimimiani pahuijo? ¿Aꞌa jja nequianajaya eya ba jjima quea caꞌa nee nee? ");
INSERT INTO eseNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Aꞌa jja quiana ejo jjashahuabaqui jjima tii? Eyaya me oejje pahui miji majje quea huiso dejja bobianaje, 5.000 dejja. ¿Aꞌa jja miyaya maya pajeaꞌyonaje? Ijjiaꞌijjiajeyo majje acuae jjaya ¿ache jjepai huiso chichaꞌyonaje pahui? ");
INSERT INTO eseNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Oya jayojjaya me oejje beca pahui, 7 pahui miji majje quea huiso dejja bobianaje, 4.000 dejja. Majoya miyaya pahui ¿ache jjepai huiso chichaꞌyonaje soꞌo? ¿Aꞌa ya pajeaꞌyonaje? ");
INSERT INTO eseNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eyaya miquianaya huohuinaje jama baꞌa: “Paniseo, Sanoseo peaꞌaija pahui shejjee meejjijo quea tai miya poaje” —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jamajjeya o shajjaꞌajjajji cuana jjabahuejjaquinaje Jesosaa huohui cajje: —Eꞌe, Paniseo, Sanoseo peaꞌaija ehuohui taijo se quea tai poaje; pahui shejjee meejjijo pojjeama Jesosaa huohui canaje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Majoya Jesosa Pinipo meshi yasijje poquinaje. Sesanea huasijje poquijeya o shajjaꞌajjajji huohuiꞌajja canaje Jesosaa: —Dejja cuana acuae jja ¿yajja poani ejo, ojjañaja Edoe Mesejo? ¿Aꞌya cuae eya? ");
INSERT INTO eseNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Oya cuaa sajaꞌa canaje: —Beca cuana jja jama poani baꞌa: Miya Huani, ma ona besameejji poa shequi oꞌoyanaje poso ca jja mi ca acani. Pea cuana aje jja oe jama poani: Miya Enia, Eyacuiñajjija esohui huohuijji yahuajo nei nequia poa. Pea poani jama baꞌa: Miya Jenemia pojjaꞌa pea esohui huohuijji yahuajo nei nequia poa pojjaꞌa. Oya cuana yahuajo nei manoꞌya poa shequi oꞌoyanaje poso ca jja mi ca acani cuaa —poanaje o shajjaꞌajjajji. ");
INSERT INTO eseNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jamajjeya Jesosaa oya cuana huohuiꞌajja canaje: —¿Miya acuae yajja poani ejo? ¿Aꞌya cuae eya? ");
INSERT INTO eseNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—¡Miya ca ca Eyacuiñajjija Bacua Ejja oe nei, oja huoojeaꞌyo ojjaña jaahuanajji! —Simohuiya Jesosa sajaꞌa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jamajjeya Jesosaa oya jama acanaje baꞌa: —Simohui, Jjonaja bacua, ¡quea bihui nee pocue! Ecue Chii eyajo aniya miya ba meesahua cani eya oja huoojeaꞌyo ojjaña jaahuanajji. Dejjaa pojjeama miya ba meesahua cani, de. ");
INSERT INTO eseNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jamajjeya eyaya miya huohuiaña miya bajjani aje Peno, esejaya esohuijo Mei bajjani. Eyacuiñajjija esohui eꞌe jojo nei ejo eyaya miya huohui meesahuajeꞌyo ecuea epeejji cuana quea caꞌa nee epoꞌyojji. Equi mei jiyo nei jayojja jama quea caꞌa nee nequi tii jayojja jama ecuea epeejji cuana quea caꞌa nee nequi tiitiijeꞌyo; ejeabichajeaꞌyojji pojjeama Edosiquianaja, eshahua cuanaja peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Eya Emeshi Mese nei jiquio meshijo poajeꞌyo. Jamajjeya aje miya huoojeaña ecue sohui huohuiya. Ecuea esohui esecue caꞌapejojji jayojja jama eyahuasijje edobiqui meeꞌyojji. Jamajjeya ecuea esohui ba majje miyaya huohuije ache ebaꞌejji quea mimishi Eyacuiñajjija botiꞌama. Miyaya huohuije peaꞌai ache ebaꞌejji quea pame nee Eyacuiñajjija eyajo anija quea boti nee. ");
INSERT INTO eseNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Majoya Jesosaa o shajjaꞌajjajji cuana huohui neinei canaje jama baꞌa: —Eꞌe, eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Jamatii ¡aꞌa oe jihuohuijji soꞌo! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Majoya Jesosaa o shajjaꞌajjajji cuana huohui coo canaje ojaya emanoꞌyojjijo: —Eya quijje Jenosanena huasijje poquije. Jomajo Moisesija etehueꞌyo huohuijji cuaa, Jodio etii bajjani cuaa peaꞌai, Eyacuiñajji nijje emimijji etii cuaa peaꞌai eya quea huiso cuia cajeꞌyo. Quea nee nee poajeꞌyo eya. Quijje ya mo manojeꞌyo ohua me caca mee cajje. Jamatii beca cahuime po majje mo shequi mee caje oꞌoya ecue Chiiya —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jamajjeya Peno quea yeno nee poanaje Jesosajo. Oya oe nei iyaa canaje, Penohua. Jama poanaje baꞌa: —Chojja, ecuea Emeshi Mese, miya Eyacuiñajjiya jaahuana cajeꞌyo. Peaa aje oe miya enapajji pojjeama, equecuaꞌyojji pojjeama jja mi, de. ");
INSERT INTO eseNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jamajjeya aje jja oe Jesosaa oya Peno cojja ba neinei cani jama tecueame acanaje baꞌa: —Peno, ¡aꞌa jamaya mimijji! Miya e dasiajji nisho epo jayojja mimiani. Miya Edosiquiana Satanasa jama mimiani. Jjashahuabaquiani quea tai, dejja jama; Eyacuiñajjija ejjashahuabaquiꞌyojji jama pojjeama —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jamajjeya Jesosa ojjaña o shajjaꞌajjajji nijje jama miminaje baꞌa: —¡Ojjaña joya enijje eꞌe jojo nei jjapeequiꞌyo sa poani Eyacuiñajjija esohui jayojja jama baꞌecue! Eꞌe, e jayojjaya jja enijje capoquiahua, jamatii onaa napa cajje aje jja oe quea nee poajeꞌyo pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Eꞌe, ojjaña joya Eyacuiñajjija esohui jayojja jama baꞌe sa po ajja aje oe baꞌe tiitii ajja enijje. Joya ecuea esohui jayojja jama baꞌe sa poani ca ca baꞌe tiitiijeꞌyo enijje eyajo. ");
INSERT INTO eseNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eꞌe pojjaꞌa dejjaa quea huiso nee nee aquiana ojaya yajji chicha caje. Jamatii oya cuana cuaqui yasijje jeajea cajo, ojjaña ojaya aquiana cuana edojojji pojjeama. ¿Aꞌa ojjaña ojaya aquiana cuana Eyacuiñajji yasijje quia cajo, oya cuana cuaquijo ani cuayaqui mee cajeꞌyo? ¿Aꞌa Eyacuiñajjiya oya cuana onijje eyajo baꞌe mee cajeꞌyo ma aquiana quea huiso nee nee sosejje? Chojja. ");
INSERT INTO eseNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Eꞌe jojo nei eya ojjañaja Edoe Mese poeje oꞌoya. Quea jeajahua nee nee, quea caꞌa nee nee poejeꞌyo. Eya esohuidojojji quea huiso nee nijje poejeꞌyo. Poe majje eyaya ojjaña cuana sosequiajeꞌyo. Ojjaña baꞌenaje jayojja eyaya sosequiajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eꞌe jojo nei eya ojjañaja Edoe Mese ojjaña huoojeaꞌyojji quea caꞌa nee nee poajeꞌyo. Beca cuaa jiquiojo nequiya jjaja mo jamaya ba caje manoꞌyo jjimahuaa —Jesosaa o shajjaꞌajjajji cuana acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Quijje pishana me oejje pea emejje oe cahuime po majje Jesosa poquinaje o shajjaꞌajjajji nijje pea beca peejjima dejja nijje, Peno nijje, Satiaco, oja doe Huani nijje peaꞌai. Mahuiso dejja nijje poquinaje eyiyo huasijje quea huesha nee. ");
INSERT INTO eseNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jocuama nequi oya Jesosa jjahuapaquiꞌyonaje; quea cojja jiji nee poanaje, eshequi jayojja poanaje, quea jeajahua nee nee. Oja daqui quea oshe nee nee, bo oshe jayojja poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moisesi, Enia peaꞌai ma yahuajo nei baꞌya poa Jesosa nijje mimimiminequi ba canaje o shajjaꞌajjajji cuaa. Moisesi, Enia peaꞌai Jesosa nijje mimimiminequinaje Jesosa onaja mimishijo emanoꞌyojji jjejojoya. ");
INSERT INTO eseNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jamajjeya Peno Jesosa nijje jama poanaje baꞌa: —Eꞌe Emeshi Mese, jiquiojo ecuana canequiquiahua, quea pame nee. Pea beca peejjima equi sisi ecuaaya caꞌiyaahua miquea, Moisesija, Eniaja peaꞌai ebaꞌejji. ");
INSERT INTO eseNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peno mimianijo tii bo quea oshe nee nee nequioquenaje. Queya canaje huojaa. Shajjaꞌajja canaje Eyacuiñajji jama poani baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","—Jiquio ecuea ecue Bacua Ejja quea jea nee nee. Eya ojo quea bihui nee nee. ¡Oya oe shajjaꞌajjacue! O shajjaꞌajja majje quea mete nee nee poanaje Peno, Satiaco, Huani peaꞌai. Meshi yasijje hui oquequinaje. Ecuiꞌoshajjajo nequinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jamajjeya o que poeyanaje Jesosa. Napa canaje emeya. —¡Nequisohuacue! ¡Aꞌa quea mete pojji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jamajjeya oya cuana nequisohuanaje. Jesosa oe nei nequi bajea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eyiyojo jaaoquequijeꞌyo mimimimi jaaoqueꞌyonaje. Jesosaa ma ojjañaja Edoe Meseya acanaje jama baꞌa: —¡Ma miya eyiyojo banaje aꞌa jihuohuijji! ¡Quijje eya emanoꞌyojaa shequi oꞌoyajo mo oe pea cuana huohuicue! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jamajjeya oya cuaa huohuiꞌajja canaje: —Jesosa, Moisesija etehueꞌyo huohuijji poaniya jama acani baꞌa: “Enia oe ebionei capoeꞌyahua Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji poe jjimahuajo”. ¿Yajjajje acuae Moisesija esohui huohuijji cuaa jama acani? —poanaje Peno, Satiaco, Huani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesosaa sajaꞌa canaje jama baꞌa: —Eꞌe jojo nei Enia jayojja jama oe dejja ebionei epoejji, ojjaña cuana ejo eꞌe jojo nei ejjashahuabaqui meesahuajji. ");
INSERT INTO eseNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eꞌe, Enia jama ca ca oe yahuajo pishana poeyanaje. Jamatii Jodio cuanaja oya ba jjima poa. Pea poso acanaje. Jamajjeya cuia caꞌya poa. Jamaya peaꞌai eya acajeꞌyo cuaa. Eya ojjañaja Edoe Mese quea nee nee po mee cajeꞌyo cuaa —poanaje Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jamajjeya o shajjaꞌajjajji cuana jjashahuabaqui nequinaje. Jama poanaje: —Eꞌe de, oya Huanijo mimiani, ma ona besameejji poajo. Eniaa jama sohui huohuime acanaje Huaniya, de —poanaje Peno Satiaco nijje Huani peaꞌai nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eyiyojo nequi jaaoqueꞌyo majje Jesosaa, o shajjaꞌajjajjiya peaꞌai ba cañaquinaje quea huiso cuana ejjachichaqui nequica. Oe dejja Jesosa que poeyanaje. Ecuiꞌoshajjajo nequiya huohuiꞌajja canaje: ");
INSERT INTO eseNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Emeshi Mese Jesosa, ¡ecuea ebacua ejjajo quea yeno jjashahuabaquicue! Oya quea mano nee nee, niñepoqui poani. Niñepoqui majje ena huasijje jea cani, cuaqui yasijje peaꞌai jea cani. ");
INSERT INTO eseNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eyaya oya yenaje mi shajjaꞌajjajji cuana huasijje. Jamatii niñepoquipajea ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesosaa ojjaña cuana acanaje: —¡De! ¿Ache shono acuae jja nequiana ejo jjashahuabaquije eꞌe jojo nei? Quea sapa caꞌa mi coma. ¿Ache cahui huiso minijje nequi majje miyaya eya bajeꞌyo Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji quea caꞌa nee nee? ¡Miquea ebacua ejja e que jjequicue! ");
INSERT INTO eseNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jjequi canaje Jesosa que. Jesosaa o niñepoquimeejji poani huoojeacuayajea caꞌyonaje: —Eshahua, ¡cuayaquiꞌyocue, eshoꞌi niñepoquimeejji poani! —Jesosa poanaje. Cuayaquiꞌyonaje. Jamajjeya oja bacua ejja niñepoquipajeaꞌyonaje, quea aja nee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Quijje ojjaña cuana poqui majje Jesosa que poeyanaje o shajjaꞌajjajji cuana. Huohuiꞌajja canaje: —¿Yajjajo acuae ecuaaya eshahua mi huoojeacuayajea meeꞌajjaꞌyonaje? ");
INSERT INTO eseNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesosaa sajaꞌa canaje: —Miquianaya jja ejo jjashahuabaqui jaꞌa jjima. Jjashahuabaquiani jama baꞌa: “Eꞌe pojjaꞌa Jesosaa ecuanaja eshahua huoojeacuayajea mee ajja”. Jamajjeya mi huoojeacuayajeaña. ¡Bacue oe! Ejo jjashahuabaquicue jama baꞌa: “Jesosaa eꞌe nei ohuaya jayojja jama ecuana ameesahua cajeꞌyo”. Miya jama jjashahuabaquiajo, Eyacuiñajjiya miya amee cajeꞌyo ojjaña eyaya aña jayojja jama, ma dejjaa ajjima acani amee cajeꞌyo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Eꞌe, jamatii jiquio eshahua jayojja quea huoojeacuayajea camaja. Eyacuiñajji nijje mimi huichaꞌa huichaꞌa majje, ojo jjashahuabaquianijo ijjiaꞌijjia jjima po majje peaꞌai huoojeacuayajeajeꞌyo miyaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Majoya Janinea meshijo ojee poquijeya Jesosaa o shajjaꞌajjajji cuana huohui canaje: —Eꞌe, quijje eya iña meesahuaje onaja equecuaꞌyojji. Quecua cajeꞌyo cuaa. Jamatii beca cahuime po majje mo shequi mee cajeꞌyo Eyacuiñajjiya. O shajjaꞌajja majje o shajjaꞌajjajji cuana quea yeno nee nee poanaje. Quea mete peaꞌai poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Majoya Capenaoma huasijje poeyajo, bejjo chichajji poani Peno que poeyanaje; huohuiꞌajja canaje jama baꞌa: —¿Aꞌa acuae mi mi sohui huohuijjiya bejjo quia cani, ma Eyacuiñajjija equi iya bameꞌyojji? ");
INSERT INTO eseNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Eꞌe de, quia cani —Peno poanaje. Majoya Simohui Peno equi yasijje dobiquiajo, Jesosaa oya huohuiꞌajja canaje: —Simohui, ¿yajjajje acuae mi jjashahuabaquiani? ¿Emeshi mese neiya ajea bejjo sosequia mee cani? ¿Aꞌa quea huesha baꞌeja? ¿Aꞌa oja meshijo baꞌeja pojjaꞌa? —Quea huesha baꞌeya poe majje sosequia cajeꞌyo —poanaje Peno. ");
INSERT INTO eseNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Eꞌe —Jesosa poanaje—. Jamajjeya emeshi mese neija echacojji cuana esosequiaꞌyojji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jamatii oya queneꞌama epojji ejjasosequiaquijji. ¡Poquicue miya bae yasijje! ¡Joya ebionei ijjia caje oe jjequiquiayacue! ¡Oja nabajo baꞌe oe bacue ejjeshejji quea sose huiso nee nee, ejo, mijo peaꞌai esosequiaꞌyojji! ¡Dojocue! ¡Bejjo chichajji poani yasijje quiacue! “Maꞌaje esohui huohuijjija, ecuea peaꞌai” acue —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Majoya ojjaña o shajjaꞌajjajji cuaa Jesosa que poe majje huohuiꞌajja canaje: —Jesosa, quijje miya ojjaña huoojeajji poaje. ¿Aꞌya cuae mi jayojja jama poaje minijje ona huoojeajji? ¿Aꞌa ecuanaya pojjaꞌa? ");
INSERT INTO eseNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jamajjeya Jesosaa oe eshoꞌi nei o que iyaa canaje. O cojja nei nequinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","O shajjaꞌajjajji cuana huohui canaje Jesosaa: —¡Bacue oe! ¡Jiquio eshoꞌi nei jama pocue! ¡Jjashajjaꞌajjaquicue oe! Eshoꞌi nei pojji mi poꞌyajo ca ca enijje ebaꞌeꞌyojji pojjeama quijje eya ojjaña huoojeaꞌyojji poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jamajjeya joya eshoꞌi jama quea bei jjashajjaꞌajjaquiani e que poquijeꞌyo, e jayojja ona huoojeaꞌyojji eyajo poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Eꞌe, ecuea epeejji eshoꞌi quea pame jama jjashajjaꞌajjaquiani. Ojjañaa joya ecuea epeejji quea jea acani eya peaꞌai quea jea acani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Ecuea epeejji jjeya nei jjapeequi caꞌaꞌama ¡aꞌa quea mimishi po meejji cuana! Joya o mimishi pomeejji poani Eyacuiñajjiya quea nee nee po mee cajeꞌyo, de. Jamajjeya ¡quea mimishi epo mee cuahuajje oe manoꞌyocue! ¡Jjanaayiipecaqui majje mei quea quemo nee jeyocue; bae quea doe yasijje oe tohuaacue! ");
INSERT INTO eseNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mimishi pomeejji cuanajo quea yeno nee nee ojjaña poani. Jamatii mimishi pomeejji yani, de. Quea yeno ca ca oe mimishi pomeejji poaje, quea nee nee po mee cajeꞌyo tii Eyacuiñajjiya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Jamajjeya miya quea mimishi po mee cani emeya, ejiojjiya pojjaꞌa. ¡Ejiojji, emeꞌ pojjaꞌa ejajasejjajea jayojja jama acue mimishiꞌama epojji! Emeꞌ, ejiojji peaꞌai chamajo eyahuasijje poquiꞌyajo Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji quea pame nee nee. Miquea beca emeꞌ, ejiojji peaꞌai yanijo pojjaꞌa quea mimishi tii poani ca ca cuaqui yasijje poquijeꞌyo. Quea tai nee nee, quea nee nee; cuaqui jijipajeaꞌyo ajja, de. ");
INSERT INTO eseNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ecojjajo jjabaqui majje miya quea mimishi poani pojjaꞌa. Jamajjeya ¡ecojja ecajjajea jayojja jama acue! Cojjamaꞌ, mimishiꞌama miya eyahuasijje poquijeꞌyo quea pame nee nee poajeꞌyo. Cojjajji, quea mimishi tii poani miya cuaqui yasijje poquijeꞌyo ca ca quea tai nee nee, quea nee nee poajeꞌyo tii tii. Eꞌe, ¡quea jjashahuabaqui jaꞌa oe pocue! ¡Mimishi cuana oe pajeaꞌyocue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Jamajjeya ¡ecuea epeejji eyacua aꞌa botiꞌama ajji! Eꞌe jojo nei eyaya miya huohuiaña eyajo esohuidojojjiya, o jaahuanajjiya ecue Chii yasijje huohuiqui cani. ");
INSERT INTO eseNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Eya ca iña ojjañaja Edoe Mese poeyanaje mimishi cuana cuijeaꞌyohua cuaqui yasijje miquianaya epoqui poani jjejojo —Jesosaa o shajjaꞌajjajji huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Jamajjeya eyaya miquianaya huohuije esohui ejjashahuabaquijji —Jesosa poanaje—. Oe dejjaja quea huiso ñajjajja yaninaje, 100 huisome. Oe nei poquiquehuaꞌya poa, ¿ae poanaje oya? ¿Aꞌa saꞌajja canaje? Eꞌe. Pea cuana, 99 huisome ñajjajja ojee ijjiaꞌijjiaqui jeanana canaje epoquiquehua saꞌajjaꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Baꞌyo majje quea bihui nee poꞌyonaje. Pea ñajjajja poquiquehua jjimajo quea bihui pishana poanaje: “¡Jiquioya ecuea ñajjajjaja bacua, de!” poanaje eñajjajja mese. ");
INSERT INTO eseNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ñajjajja jaahuanajji ñajjajja baꞌyo majje quea bihui nee nee poa. Jamaya poaje ecue Chii: Ecuea epeejji eyacua quea mimishi jjejojo epoquiquehuaꞌyo jayojja jama ojo jjashahuabaqui oꞌoyajo, Eyacuiñajji quea bihui nee poajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Ecuea epeejji minijje quea mimishi poanijo, ¡onijje mimiquicue! ¡Ojaya mimishijo jjashahuabaqui meesahuacue! Jjashahuabaqui majje mimishi capajea caꞌyahua. Jamajjeya minijje jjapeequije oꞌoya. ");
INSERT INTO eseNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","O mi jjashajjaꞌajjaquiajo ¡pea iyaacue, beca pojjaꞌa, ecuea epeejji peaꞌai! ¡Ojee poquicue onijje mimiya! Jamajjeya oya cuaa miya ba caje eꞌe jojo nei miquea epeejji nijje jjapeequi oꞌoya sa poani. ");
INSERT INTO eseNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ohuaya oya cuana mi jjashajjaꞌajjaquiajo ¡ojjaña Eyacuiñajjija epeejji cuana huasijje iyaacue emimijji, ojaya mimishi epajeaꞌyojji! Ojjañaa niñesheꞌajja cajo mi jjashajjaꞌajjaquiajo, Eyacuiñajjija epeejji jama pojjeama oya. Jamatii jjadasiaquijji jama, de —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Jamajjeya ojjaña ecuea epeejji cuana miquianaaya huohui meeje ache ebaꞌejji quea mimishi, ma Eyacuiñajjija eyajo anija botiꞌama peaꞌai. Huohui meeje peaꞌai ache ebaꞌejji quea pame nee, ma Eyacuiñajjija eyajo anija quea boti nee peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Eꞌe jojo nei miquianaya meshijo baꞌe ojee mimiajo, Eyacuiñajjiya, ecue Chiiya eyajo aniya miquianajaya esohui sajaꞌa cani. ");
INSERT INTO eseNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Beca cuana enijje jjapeequiani ejjachichaquianijo, eya o pejjejo nequiani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Majoya Penohua Jesosa huohuiꞌajja canaje: —Emeshi Mese Jesosa, ecuea epeejjiya quea mimishi ahuichaꞌa huichaꞌa cajo, ¿aꞌa eyaya oja mimishi capajea huichaꞌa huichaꞌaꞌyahua? ¿Ache huiso huohuiꞌyome amajje jjabeiqui caꞌyojji? ¿Aꞌa quea huiso pojjaꞌa, me oejje pea beca, 7 pojjaꞌa? ");
INSERT INTO eseNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesosaa sajaꞌa canaje: —Chojja, Peno, me oejje pea beca, 7 pojjeama. Quea huiso nee nee huohuiꞌyome amajje jjabei neineiqui caꞌyojji, jama tii tii epoꞌyojji —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jamajjeya Jesosaa pea esohui ejjashahuabaqui meejji huohui canaje jama poani baꞌa: —Eyacuiñajji ojjaña huoojeaꞌyojji poaje. Jamaya poaje baꞌa: Emeshi meseya aquiana oja quia sosequia mee caꞌyani echacojji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sosequia mee canijo o que jjequi canaje oe echacojji poani. Aquiana quea huiso nee nee oja jjeshe poanaje. Jamajjeya sosequia ajjaꞌajja jjima, ojaya. ");
INSERT INTO eseNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma echacojji sosequiaquia ajja; yajja sosequiaꞌyome yajji jojoya mi sosequiajeyo caꞌyonaje. Jamajjeya emeshi meseya quea quene huohui canaje: “¡Oya oe quiacue ejjeshejji sosejje! Sosemaꞌ cachaco cahua. ¡Ojaya ehuanase, oja bacua cuanaya quiacue peaꞌai, ojaya aquiana cuana peaꞌai quiaꞌyocue e sosequiaꞌyojji!” ");
INSERT INTO eseNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—O shajjaꞌajja majje echacojji o que poquinaje. Ecuiꞌoshajjajo nequi oya mimi nequinaje: “Ecuea emeshi mese, ¡aꞌa ecuana dojojji equiaꞌyojji bejjo sosejje! ¡Ishoaꞌajjacue! Eyaya ojjaña sosequia jeyojeyojeꞌyo miya”. ");
INSERT INTO eseNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Emeshi mese ojo jjashahuabaquinaje. Quea aquiana huiso nee nee nee sosequia jjima. Jamatii oja bajjani cuijea caꞌyonaje, sosequia jjima tii. Poqui mee caꞌyonaje, de. ");
INSERT INTO eseNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Majoya echacojji poquinaje quea bihui nee nee. Jamatii poqui majje ma echacojjiya pea echacojji onijje nequi saꞌajja canaje. Ba majje iñasibijea canaje. Jama poanaje baꞌa: “¡Jjeya nei mo sosequiacue mique jjeshe cuana!” oya poanaje. Ojaya oe pojji nei sosequia jjima poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ecuiꞌoshajjajo nequi mimi nequinaje jiquio pea echacojji: “Epeejji, ¡ejo jjashahuabaquicue! ¡Ishoaꞌajja socue! Ojjaña aje mi sosequia jeyojeyojeꞌyo de”. ");
INSERT INTO eseNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—“¡Chojja! ¡Ishoa sa po ajja iña!” poanaje. Jeanobiaa dojo canaje; ohua sosequiajeyo caꞌyajje huoojea caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Pea echacojji cuaa ba canaje. O dojo cajo quea yeno jjashahuabaquinaje. Poquinaje emeshi mese huohuiꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ma shajjaꞌajja majje emeshi meseya huoojea canaje ojaya echacojji jjequiꞌyohua. Poeyajo tecuea canaje emeshi meseya: “Miya ca mi ca oe quea mimishi nee. Miquea aquiana quea huiso nee nee sosequia jjima. Jamatii enijje mimiꞌyajo eyaya miquea bajjani cuijeaꞌyonaje, sosequia jjima tii. ");
INSERT INTO eseNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jamajjeya ¿yajjajo miquea epeejjijo mi jjashahuabaquinaje miya? ¡E jayojja oe miya mi poanaje!” emeshi mese poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Quenequene neineiꞌyonaje emeshi mese. Ejeanobiajji huoojea caꞌyonaje quea nee nee po meeya ohua sosequiajeyo caꞌyajje —jamaya Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Jamajjeya jiquio ecua emeshi meseya acani jayojjaya jamaya miquianaya acajeꞌyo ecue Chiiya, ca onaja mimishi miya mi pajea neineiꞌyajo. Miquea mimishi cuana pajeaꞌyo ajja, cuijeaꞌyo ajja peaꞌai —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Majoya esohui huohui majje Jesosa Janinea meshijo ani poꞌoquequinaje Jodea meshi yasijje, Jodana cuei ojje miji yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jomajo quea huiso dejja cuana onijje poquinaje. Ohuaya ojjaña jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Paniseo cuana ca ca o que poeyanaje jjadasiaquiya nisho. Jamaya jjashahuabaquinaje baꞌa: —Eꞌe pojjaꞌa Jesosa Moisesija etehueꞌyo jayojja jama pojjeama mimije. Jamajjeya ecuaaya oya tecueaje. Jamajjeya Jesosa huohuiꞌajja canaje cuaa jama baꞌa: —Esohui huohuijji, ¿aꞌa acuae ehuanase huei cajji? ¿Yajjajo acuae ehuanase hueijea cajji soꞌo? ¿Achajja tehuemeya acuae oe Moisesiya aca poa? ");
INSERT INTO eseNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sajaꞌa canaje Jesosaa: —¿Aꞌa miquea Moisesija etehueꞌyo ba jjima esohui? Yahuajo nei nei tehue ca poa Moisesiya jama baꞌa: “Yahuajo Eyacuiñajjiya pana coo ca poa yahue, epona peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Huohui ca poa ohuaya: —Jamajjeya yahueya oja chii, ojaya enaese peaꞌai cajiñayiya caꞌyahua oja huanase nijje ebaꞌejji”. ");
INSERT INTO eseNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Oya cuana beca. Jamatii oe nei jayojja Eyacuiñajjiya oya ba cani, becanejjijji peaꞌai pojjeama, oe nei jayojjaya. Cuanaya Eyacuiñajjiya oe jayojja aca poa. Jamajjeya ¡aꞌa oe jea meejji! ¡Jama tii tii oe nei oe acue! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Huohuiꞌajja oꞌoya canaje Paniseo cuaa: —Jamajjeya ¿yajjajo acuae Moisesiya tehueme aca poa? Jama baꞌa: “Hueiꞌyo majje yahueya ehueijeajji papeni etehueꞌyo caquia cahua oja huanase. Majoya cahuoojea cahua”. ");
INSERT INTO eseNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sajaꞌa canaje Jesosaa: —Miquea etiiquiana quea mimishi nei jjejojoya Moisesiya huei meeꞌajja canaje. Quijje nei Moisesiya jamaya tehue ca poa; jamatii Eyacuiñajjiya jamaya pojjeama pana coo ca poa. ");
INSERT INTO eseNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jamajjeya eyaya miya huohuiaña eꞌe jojo nei ehuanase pea dejjaja sii jjima huei ca ajja. Joya ehuanase hueijji epo pea epona ehuanaꞌyojji quea mimishi nee, epona siijji epo jama. Eyacuiñajjiya oya ba cani quea mimishi. Joya ma eponajo jjahuanaquiajo quea mimishi peaꞌai poani; onaja ehuanase nijje poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","—¡De! Jamajojoya eseya jjahuanaqui ca ajja. Jamatii shacuimaꞌ nequi cajji ojjaña eseya cuana. —o shajjaꞌajjajji poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—Cho, ojjaña pojjeama shacuimaꞌ nequi cajji —Jesosa poanaje—. Beca cuana Eyacuiñajjiya huoojea cajeꞌyo shacuimaꞌ tii enequijji. ");
INSERT INTO eseNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Beca cuana jjahuanaqui ajja, jamatii ejjahuanaquijji pojjeama. (Jamaya joya quibojjisha nei, biñajjajjamaꞌ cuana peaꞌai.) Beca cuana jjahuanaqui ajja jamatii yajjajje shai jjahuanaqui sa poꞌyo ajjajo. Beca cuana Eyacuiñajjija esohui ehuohui aiquijji, ojo echaco neinei cajji Eyacuiñajjiya huoojea canaje jjahuanaqui jjima tii tii enequijji. Jamatii Eyacuiñajjiya ojjaña huoojeaꞌyo ajja shacuimaꞌ tii enequijji. Jamajjeya ¡ojaya ejjashahuabaquiꞌyojji mijo jamaya acue, miyaya! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Majoya Jesosa que eshoꞌi nei cuana jjequi canaje cuaa. Huohui canaje: —Jesosa, jiquio eshoꞌi nei sapa napaꞌajja majje ¡Eyacuiñajji nijje mimicue ojaya ejaahuanajji! —poanaje. Jesosa shajjaꞌajjajji cuaa oya cuana tecuea canaje: —¡Aꞌa jja oe Jesosa que jjequi majajji eshoꞌiquiana! ¡Esohui oe cahuohui cahua! ");
INSERT INTO eseNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma ba majje Jesosa poanaje: —¡Eshoꞌiquiana e que capoeꞌyahua! ¡Aꞌa quea huesha nequi meejji! Eꞌe, eshoꞌiquiana jjashahuabacuajiquiani; enijje jjapeecuajiquiani. Jamaya ecuea epeejji eshoꞌi jayojja eyaya jaahuana mee sa aña peaꞌai. Jamajjeya e que poquijeꞌyo, eya eyajo ojjaña huoojeaꞌyojji poaje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jamajjeya eshoꞌi cuana biajje emeꞌ huana majje Jesosa poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Majoya oe dejja Jesosa que poeyanaje. Huohuiꞌajja canaje jama baꞌa: —Emeshi Mese, ¿achajja po majje acuae mo eyahuasijje poqui caꞌyojji Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji? ¿Achajja acuae baꞌe cajji quea pame nee epojji? ");
INSERT INTO eseNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Apiojji miyaya eya huohuiꞌajjaña: “¿Ae quea pame nee epoꞌyojji?” Eyacuiñajji ca oe nei quea pame nee. Jamajjeya onijje baꞌe tiitiiꞌyo sa po majje ca oe ¡oya shajjaꞌajjacue! ¡Ojaya esohui etehueꞌyo jayojja jama oe baꞌecue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ache esohui etehueꞌyo? —huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jesosaa sajaꞌa canaje: —Eyacuiñajjija esohui etehueꞌyo jama poani baꞌa: “¡Aꞌa pea quecuajji! ¡Aꞌa sii pojji! ¡Aꞌa siajje pojji! ¡Aꞌa pea siijji! ¡Mique chii, mique nae peaꞌai oe shajjaꞌajjacue! ¡Pea cuana mi pejjejo baꞌe mique huapa pojjeama jayojja quea jea oe acue!” ");
INSERT INTO eseNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Eꞌe, eyaya jamaya aña, eshoꞌyahuaa jama tii tii sohuaqui eya. ¿Pea acuae yajja po cajji eyajo ebaꞌe tiitiiꞌyojji? —jiquio dejjaa Jesosa huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Eꞌe, miya quea pame nee nee Eyacuiñajji jayojjaya po sa po majje ¡poquicue, miquea aquiana cuana quiaquicue ejjeshejji sosejje! ¡Ejjeshejji quiaꞌyocue aemaꞌ cuana huasijje! ¡Majoya poecue, enijje epoꞌyojji! Jamajjeya eyajo Eyacuiñajjiya miya aquiana quea pame nee quea huiso quia cajeꞌyo quijje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesosaja esohui shajjaꞌajja majje dejja etii pishana quea dejja tai jjejojo quea yeno poquinaje; ojaya aquiana quea huiso nee nee yani jojoya quia sa poꞌyo ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jamajjeya Jesosaa o shajjaꞌajjajji cuana huohui canaje: —Eꞌe, dejjaa quea mimishiya jjejojoya aquiana quea huiso, meshi quea quemo pojjaꞌa nahue canijo beshahua nei e que poqui ajja, eya eyajo ojjaña huoojeaꞌyojji poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","—Eꞌe, eyaya huohuiaña peaꞌai jama baꞌa: Ahuoja quii huejjajje ino jeanobiaña jamaya, ¿aꞌa mapichi jeanobia cajji ahuoja quii huejjajje? Quea camaja coma. Jiquio ecua mapichi ahuoja quii huejjajje jeanobia cajji pome jamaya dejja quea aquiana huiso nee nee nahue cani eyahuasijje edobiquijji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","O shajjaꞌajja majje jjashahuaba neineiquinaje o shajjaꞌajjajji. Ojee mimimiminaje: —Jamajjeya ¿aꞌya shai eyahuasijje dobiqui mee cajeꞌyo? ");
INSERT INTO eseNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Cojja ba neinei canaje Jesosaa. Huohui canaje: —Dejjaa jamaya amee ajja tii. Eyacuiñajjiya oe neiya ojjaña acani. (Eyahuasijje dobiqui mee cani peaꞌai joya quea aquiana huiso nee) —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jamajjeya Peno jjashahuabaquinaje ma dejja aquiana quea huiso nee nee jeanaꞌyo sa po ajjajo. Huohuiꞌajja canaje: —Jesosa, ecuaaya ojjaña aquiana jeanaꞌyonaje minijje epoquiꞌyojji. Jamajjeya ¿ae acuae ecuana quiaje soꞌo, de? ");
INSERT INTO eseNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesosaa sajaꞌa canaje: —Eꞌe jojo nei quijje Eyacuiñajjiya ojjaña eyacua pana caꞌyajo eya eyajo nequijeꞌyo ojjaña huoojeaꞌyojji nei. Miquianaya, 12, e shajjaꞌajjajji poani enijje nequijeꞌyo, enijje ona huoojeaꞌyojji poajeꞌyo. Eꞌe, miquianaaya Jodio cuana, ecuea pea epeejji cuana peaꞌai huoojeajeꞌyo tii. ");
INSERT INTO eseNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eꞌe nei beca cuana ecuea esohui jama a sa poanijo aquiana cuana jeana caꞌyani: Ojaya equi, oja huapa pojjeama, oja chii, oja nae pojjaꞌa, oja bacua cuana pojjaꞌa, oja huanase pojjaꞌa jeana caꞌyani. Jamajjeya eꞌe jojo nei quijje Eyacuiñajjiya oya cuana quea huiso nee nee o jayojja quia cajeꞌyo; quea bihui nee nee baꞌe tiitii mee cajeꞌyo peaꞌai eyajo onijje. ");
INSERT INTO eseNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jamatii beca cuana jjeya ona huoojeajji poani eyajo ona huoojeaꞌyojji pojjeama poajeꞌyo. Joya jjeya ona huoojeaꞌyojji pojjeama ca ca eyajo ona huoojeaꞌyojji nei nei poajeꞌyo e jayojja —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Eꞌe —Jesosa poanaje—, quijje eya ojjaña huoojeaꞌyojji poaje, ojjaña sosequiajeꞌyo jjeya enijje chaco canaje sosejje. Jamaya poaje baꞌa: Oe dejja, eꞌacuijjajja mese mecajjeahua poquinaje. Echacojji cuana iyaa canaje. Huohuiꞌajja canaje: ");
INSERT INTO eseNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“¿Aꞌya cuae jjeya poquije acuijjajja huojohua? Ojjaña miya eyaya sosequiaje oe esodojjo quea sose huiso nee nee sosejje”. “Eꞌe” poanaje, “chacoje ecuaaya oe esodojjo quea nahue nee sosejje”. Majoya huoojea canaje chacohua. ");
INSERT INTO eseNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Quijje pishana eshequi jaasohua pishana majje ona ijjiaꞌijjiaꞌani yasijje poquinaje eꞌacuijjajja yiye mese. Beca dejja chacochaco jjima ani ba canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Huohuiꞌajja canaje: “¿Aꞌa miyaya acuijjajja yiyejo chacoje peaꞌai? Miya eyaya sosequiaje quea sose huiso peaꞌai”. “Eꞌe, chacoje” poanaje. Poquinaje chacohua. ");
INSERT INTO eseNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","—Quijje eshequi biacojjajja nequijo, sinecua nei peaꞌai oya poqui majamajanaje pea cuana iyaa echacojji. ");
INSERT INTO eseNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Eshequi ejjajeapaaquijo peaꞌai poqui oꞌoyanaje. Dejja cuana chacochaco jjima ani ba canaje. “¿Apiojji acuae mi chacochaco jjima ani?” acanaje eꞌacuijjajja meseya. ");
INSERT INTO eseNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Chama oya ecuea echacomeejji aña, de; ajea esosequiaꞌyojji” sajaꞌame acanaje cuaa. “Eꞌe. ¡Ecuea acuijjajja yiyejo chacoquicue peaꞌai!” poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Meca nei eꞌacuijjajja meseya ona chacomeejji huohui canaje: “¡Echacojji cuana iyaacue! ¡Sosequiacue! ¡Joya quijjeyejje nei dobiquinaje ebionei sosequiacue! ¡Joya ebionei dobiquinaje quijje yejje nei sosequiacue!” ");
INSERT INTO eseNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Majoya echacomeejjiya joya eshequi ejjajeapaaquijo dobiqui cuana sosequia canaje oe esodojjo quea nahue. ");
INSERT INTO eseNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","11","Jamajje quijje joya mecajjeahua dobiqui cuana poeyanaje. Sosequia canaje oe esodojjo quea nahue peaꞌai. Ba majje quea yeno poanaje, quea huiso nee nee esosequia caje poso. Jamatii oya sose huisoajja peaꞌai sosequia canaje. Eꞌacuijjajja mese nijje quenequenenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mimijajinaje jama baꞌa: “Joya eshequi ejjajeapaaquijo poeyanajeya aje oe oe pojji chaco canaje. Ecuanaaya ca chaco neineinaje eshequi quea quiyojo. Jamatii miyaya oya sose huisoajja peaꞌai sosequianaje. ¿Apiojji acuae jja ecuana jayojja peaꞌai sosequianaje soꞌo?” poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Eꞌe epeejji cuana, eyaya miya sosequianaje quea pame nee” poanaje. “Mi poeyajo jama poanaje baꞌa: —Eꞌe, chacoje oe esodojjo quea nahue sosejje —poanaje. ¿Aꞌa eꞌe? Jamajjeya eyaya jamaya miya quia meenaje. Jamajjeya ¡aꞌa quea quene pojji! ");
INSERT INTO eseNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eyaya jiquio dejja quijjeyejje nei cuana oe esodojjo quea nahue nee quia sa poani mi jayojjaya. Jamaya quea pame. ");
INSERT INTO eseNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mi jayojjaya quea huiso sosequianaje. ¡Aꞌa jja oe miya quea quene pojji! Bejjo ecuea jojoya eyaya quia sa amajje eyaya quiaña” eꞌacuijjajja mese poanaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—Eꞌe, eꞌacuijjajja meseya ojjaña sosequia canaje ojaya ejjashahuabaquiꞌyojji jayojja jama. Jamaya Eyacuiñajjiya acajeꞌyo. Joya quijje nei jjapeequijeꞌyo quea bihui nee baꞌe tiitii mee cajeꞌyo eyajo onijje peaꞌai. Ojjaña ojaya ejjashahuabaquijji jayojjaya jama sosequia cajeꞌyo peaꞌai. Eyacuiñajjiya quea huiso iyaa caje onijje ebaꞌe tiitiiꞌyojji. Jamatii oe pojji babaca cajeꞌyo oja epeejji huoojeaꞌyojji epojji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Majoya Jenosanena huasijje poquinaje. Jesosaa o shajjaꞌajjajji cuana dojo canaje ejiojji sahua huasijje esohui huohuijji: ");
INSERT INTO eseNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—¡Bacue oe! Eya jiquio ojjañaja Edoe Mese. Eseya Jenosanena huasijje poquije. Jomajo mo iña meesahuaje eya Jodio cuanaja equecua meeꞌyojji. Eꞌe, Moisesija etehueꞌyo huohuijjiya, Eyacuiñajji nijje emimijji etii cuaa peaꞌai eya iña mee caje. Taaa neineije cuana: “¡Oya quecuajeacue!” poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jodio pojjeama cuana huasijje mo huoojea caje. Ejo soa neineije cuana; cuia cajeꞌyo mo cuaa huaca jee ejeapashajjajjaa; acui ecueataꞌapeejo me cacajea majje mo baꞌehuanasohuajea caje cuaa emanoꞌyojji. Jamatii mo beca cahuime po majje Eyacuiñajjiya shequi mee cajeꞌyo —Jesosaa huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Majoya Jacobo, Huani peaꞌai enaese nijje Jesosa que poeyanaje. Ecuiꞌoshajjajo nequiñanaje onijje emimijji. ");
INSERT INTO eseNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—She, ¿ajeo ami poeyanaje? —Jesosa poanaje. —Jesosa, ecuea ebacua ejja cuana mi pejjejo canequiꞌyahua quijje miya ojjaña huoojeaꞌyojji poaje. Oe shani mijijje, pea ebianei mijijje canequiꞌyahua minijje, ona huoojeaꞌyojji. ¡Jamaya oe acue! —poanaje enaese. ");
INSERT INTO eseNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Chojja. Miquianajaya ba jjima —Jesosaa oya cuana acanaje—. Eya quea nee nee po mee cajeꞌyo cuaa. ¿Aꞌa miquianaya e jayojja quea nee nee poajo quea caꞌa poaje? Eya quecua cajeꞌyo peaꞌai cuaa. Enijje jjapeequianijo miquiana quecua cajeꞌyo peaꞌai pojjaꞌa cuaa. ¿Aꞌa jamatii miquianaya quea caꞌa poaje? —Eꞌe —sajaꞌa canaje Jacobohua, Huaniya peaꞌai—. Quea caꞌa poaje mi jayojja onaa quea nee nee po mee caꞌyajje. ¡Jamaya capoahua, jamatii caquecua cahua cuaa mo! ");
INSERT INTO eseNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Eꞌe —poanaje Jesosa—, jamajjeya eꞌe jojo nei miquiana e jayojja quea nee nee po mee cajeꞌyo cuaa; e jayojja quea caꞌa nee nee poaje, onaa mano mee caꞌyajje. Jamatii, e pejjejo eyajo eyaya miya enequi meeꞌyojji pojjeama enijje ona huoojeaꞌyojji. Chojja, ecue Chiiya eyajo aniya yahuajo nei pea cuana babaca caꞌyonaje. Ohuaye nei nequi mee cajeꞌyo e pejjejo quijje, eya ojjaña huoojeaꞌyojji poajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesosa pejjejo nequi sa peaꞌai poanijo onijje ona huoojeaꞌyojji epojji, Jacobo, Huani nijje peaꞌai quea quene poanaje pea shajjaꞌajjajji cuana, ome mijijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jamajoya aje oe Jesosaa oya cuana iyaa canaje. Jama huohuime acanaje baꞌa: —¡Aꞌa onijje quea quene pojji! Miquea eba dejja cuana, Eyacuiñajjija epeejji pojjeama. Onajaya emeshi mese cuaa, ona huoojeajji cuanaa peaꞌaiya pea cuana huoojea neinei cani; quea quene nee nee poani, quea mase. ");
INSERT INTO eseNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jamaya pojjeama miquianaya poaje, ecuea epeejji cuana. ¡E jayojjaya po sa poanijo pea cuana baꞌe meesahuacue! ");
INSERT INTO eseNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Joya ona huoojeaꞌyojji po sa poani ca ca echacojji sosemaꞌ jayojja capoahua. ");
INSERT INTO eseNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Eꞌe, ¡e jayojja jama pocue! Eya ca ca iña ojjañaja Edoe Mese poeyanaje ojjaña cuana baꞌe meesahuaa; ojjañaja eya ebaꞌe meesahuajji pojjeama. Ojjañaja mimishi sosequiaꞌyojji mo manojeꞌyo, ojjaña cuaqui yasijje epoquiꞌyo poani jjejojoya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jenosanena huasijje poquije Jesosa dobiquinananaje Jenico huasijje. Majoya dobinana majje poquinaje Jenosanena huasijje. Quea huiso nee nee cuana onijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Becanejjijji peaꞌai cojjamaꞌ ejiojji sahuajo eꞌanioque ani. Jesosa shajjaꞌajja canaje poeje. Taaa neineinaje cuana: —Jesosa, miya emeshi mese Dabija osecua. ¡Ejo jjashahuabaquicue quea yeno! —taaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","—¡Aꞌa oe taaa majajji! ¡Esohui oe caꞌacue! —acanaje cuaa. Jamatii taaa neineinaje cojjamaꞌ cuana: —Jesosa, Dabija osecua, ¡ejo jjashahuabaquicue! ");
INSERT INTO eseNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jamajjeya o shajjaꞌajja majje Jesosa nequiñaquinaje. Cojjamaꞌ cuana iyaa canaje: —Eꞌe, ¡poecue! ¿Aꞌya soꞌo? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Emeshi Mese, ¡miyaya iña jjacojjapojjaqui meeꞌyocue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jamajjeya Jesosa cojjamaꞌ cuanajo jjashahuabaquinaje. Cojja napa canaje. Cojja napa cajje ecojja jjabapojjaquiꞌyonaje. Quea bihui nee nee poꞌyonaje jjacojjajaꞌaqui mee caꞌyajje. Jamajjeya Jesosa nijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Majoya Jesosa Mepajejo nequiñaquinananaje Jenosanena pejjejo, acui tiiꞌajja yiyejo, Onimo bajjani eyiyo pejjejo peaꞌai. Nequiñaquinana majje o shajjaꞌajjajji becanejjijji peaꞌai huoojea canaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jama poanaje baꞌa: —¡Poquicue Mepaje yasijje! ¡Dobiqui majje mapichi sisi, ebacua shoꞌi ai nijje ejeyo nequia nequi bañaquicue! ¡Ba majje, picho majje yecue e que! ");
INSERT INTO eseNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Onaa: “¿Apiojji acuaeya ecua mapichi sisi pichojeaña soꞌo?” acajje, “Ecuea Emeshi Mese sa poani” sajaꞌame acue. Jamajjeya: “Ee, ocue dojoꞌajja joya mapichi” acaje dejjaa Mepajejo baꞌeya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eꞌe, jamaya acanaje Jesosaa, Eyacuiñajjija esohui huohuijji yahuajo nei nei ojo tehue ca poa jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ojjaña Jenosanenajo baꞌe huohuicue jama baꞌa: —¡Bacue oe! Mi huoojeaꞌyojji nei poeyani; oya quea bei nee. Jamajjeya mapichi sisija daasa biajje poeyani, mapichi sisija ebacuaja daasa biajje”. Jamaya yahuajo nei nei Jesosajo tehue ca poa Eyacuiñajjija esohui huohuijjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jamajjeya Jesosaa huoojea cajje o shajjaꞌajjajji poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mapichi sisi bacuajji dojo canaje. Daqui ao cuana mapichi sisija bacuaja daasaꞌ biajje iya canaje. Jesosa anisohuaquinaje mapichija bacua shoꞌi aija daasaꞌ biajje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ojjaña cuana ejjachichaqui nequi canaje, quea huiso nee nee. Ojaya daqui ao cuana ejiojjijo jeapiihui canaje Jesosa jaꞌajjequijji. Pea cuaa acui iña jajasejja canaje. Huana yiyoyiyo canaje ejiojjijo. Jama yahuajo nei Jodio cuaa emeshi mese cuana jaꞌajjequi caninaje cuiñajji yasijje, jama jaꞌajjequimeya acaninaje ohua ba cahuajje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ojjaña ehui dojojji poquije, Jesosa quishishijji poquije peaꞌai taaaca poquinaje quea bihui nee nee: —Eꞌe Jesosa, emeshi mese Dabi yahuajo baꞌe miquea etiiquiana. Mi poeyajo ecuana quea bihui nee nee. Quea pame nee nee miya, Jesosa. ¡Eyacuiñajji eyajo aniya miya cajaahuana cahua! ¡Eyacuiñajji cabihuia cahua, ojjañaa! ");
INSERT INTO eseNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jamajjeya Jesosa Jenosanena huasijje dobiquianijo, ojjaña cuana jomajo baꞌe cuajicuajijebenaje jjachichaquiya, ojjaña. Huohuiꞌajja canaje: —¿Aꞌya shai poeje? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Jesosa poeje, Eyacuiñajjija esohui huohuijji nei, ma Nasanenajo baꞌenaje —sajaꞌame acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Quijje pishana Jesosa ojjaña cuana nijje Eyacuiñajjija equi yasijje poqui oꞌoyanaje. Dobiquinaje. Aquiana quiajji poani Eyacuiñajjija equijo nequi cuana huoojeacuayajea canaje Jesosaa, aquiana jjeshe poequi peaꞌai. Aquiana cuana jjahuojjojeajeaqui canaje; bejjo, pea bejjo sosejje quia cani cuanaja bejjo nequijji cuana jeapajjajea canaje; huiaꞌ quiajji peaꞌaija huiaꞌ nequijji cuana jeabichajea canaje: ");
INSERT INTO eseNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—¡Aꞌa jja oe Eyacuiñajjija equijo aquiana quiajji! —tecueame acanaje Jesosaa—. Eyacuiñajjija esohui jama poani baꞌa: “Ecuea equi ojjaña cuana enijje emimijji”. Miquianaaya ca ca siipojji nequijji jayojja amee aña Eyacuiñajjija equi. ");
INSERT INTO eseNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Majo tii aniya cojjamaꞌ cuana, jeoꞌajja cuana peaꞌai Jesosa que poeyanaje. Ojjaña cuana Jesosaa quea pame nee po mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jesosaja jjaajaqui meeꞌyo cuana quea pame nee ba canaje; eshoꞌiquiana majo tii ani sohuicuayanaje shajjaꞌajja canaje peaꞌai. Jamatii Jodio etii cuana aje oe Jesosa nijje quea quene poanaje. Jesosa Eyacuiñajjija Bacua Ejja pojjeama poso tecuea canaje Moisesija etehueꞌyo huohuijji poaniya, Eyacuiñajji nijje emimijji etii cuaa. Jama poanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—¿Apiojji acuae jiquio eshoꞌiquiana sohuicuaya meeaña mi bihuiajji? ¿Aꞌa shajjaꞌajja jjima? —Eꞌe, shajjaꞌajjaña —Jesosa poanaje—. ¿Aꞌa miquea ba jjima Eyacuiñajjija esohui etehueꞌyo ejo? Jama poani baꞌa: “Joya eshoꞌi aiꞌai, eshoꞌi jjonajjona ai peaꞌai quea pame nee esohui cuaya meeꞌyojji mi bihuiaꞌyojji”. Jamaya Eyacuiñajjija esohui yahuajo nei ejo etehueꞌyo poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mimi majje Jesosa poquinaje. Jea canaꞌyonaje. Jenosanenajo ani poquinaje Betania huasijje cahuiya. ");
INSERT INTO eseNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mecajjeahua Jenosanena huasijje poe oꞌoyanaje; quea shoe poanaje Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ba canaje ejiojji sahuajo nequi acui etona jjajja jayojja. Acuijjajja baꞌajjaqui canaje. Chamaꞌ poanaje ejjajja. Eña oo pana nequiꞌyo. Jamajjeya oya Jesosaa huohui canaje: —¡Jamajjeya jjajjamaꞌ tii capoꞌyahua acui! —Jesosaa jama acajje jjeya nei sajjainanaꞌyonaje acui. ");
INSERT INTO eseNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Quijje pishana acui esajjaiꞌyo ba majje o shajjaꞌajjajji cuana jjajjasoaquinaje: —¡De! ¡Jjeya nei ca ca sajjaiꞌyonaje! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","22","—Eꞌe —Jesosa poanaje—. ¡Miya Eyacuiñajjijo quea jaꞌa nee jjashahuabaquicue! Aꞌa jjashahuabaquijji jama baꞌa: “Eꞌe pojjaꞌa Eyacuiñajjija eya shajjaꞌajjaꞌyo jjima”. Cho, jama jjashahuabaquicue baꞌa: “Eyacuiñajjiya eꞌe jojo nei nei eya sajaꞌa cajeꞌyo”. Jamaya miya jjashahuabaquiajo, Eyacuiñajjiya miquea esohui sajaꞌa caje. Eꞌe, Eyacuiñajjiya e jayojja jama ameesahua cajeꞌyo peaꞌai, ma dejjaa ajjima acani. ");
INSERT INTO eseNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Majoya Jesosa Eyacuiñajjija equi yasijje dobiqui oꞌoyanaje. Esohui huohui canijo, Jodio etii cuana, Eyacuiñajji nijje emimijji etii cuana peaꞌai o que poeyanaje. Jesosa ojaya ba jjimajo huohuiꞌajja canaje: —¿Aya acuae mi huoojea canaje? ¿Apiojji acuaeya esohui huohuiaña soꞌo? ¿Apiojji acuaeya aquiana quiajji poani huoojeacuayajeanaje oma mecajje? —acanaje Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Jesosaa oya cuana sajaꞌa canaje: —Eꞌe, eyaya miya ebionei huohuiꞌajjaje. ¿Aya Huani huoojea canaje ona besa meeya? ¿Aꞌa Eyacuiñajjiya? ¿Aꞌa dejja cuaa pojjaꞌa? ¡Huohuicue mo! Eyaya majoya huohuije e huoojeaꞌyojji epo. ");
INSERT INTO eseNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Shajjaꞌajja majje Jodio cuana ojee mimimiminaje: —¿Yajja sajaꞌame shai eseya aje soꞌo, de? Quea mete ojjaña dejja cuanajo. Ojjañaa ba cani Huani Eyacuiñajjiya huoojea canaje esohui huohuiya. Jamajjeya: “Dejjaa Huani huoojea canaje” eseya ajje se jajahuejjajea ca chanaꞌ meiya. “Eyacuiñajjiya Huani huoojea canaje” eseya ajje aje se oe jama acaje baꞌa: “Jamajje, ¿apiojji miyaya Huani shajjaꞌajja jjima aña?” Jesosaa acaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jamajjeya jjashahuabaqui majje Jesosa huohui canaje Jodio cuaa: —Cuaꞌa, de. Ecuanaja ba jjima —anisho canaje. —Jamajjeya ecuea miya ehuohuijji pojjeama e huoojeaꞌyojji epo —Jesosaa acanaje Jodio esohui huohuijji cuana, etii cuana peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesosaa oya Jodio cuana huohui canaje peaꞌai jama baꞌa: —Shajjaꞌajjacue oe ecue sohui ejjashahuabaqui meejji jama baꞌa: Oe dejjaja becanejjijji peaꞌai ebacua ejja yaninaje, shacuimaꞌ nequi cuana. Ejeajjiya oja bacua ejja etii huohui canaje: “Cha, ¡che oe jjeya que chacoquicue!” ");
INSERT INTO eseNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Cho, cajaa. Mijo chaco sa poꞌyo ajja ca iña” poanaje. Jamatii, jjashahuabaqui majje “Cachacoquiahua” poanaje. Poquinaje que yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Ejeajjiya oja pea ebacua ejja, echahua mese huohui canaje peaꞌai: “Cha, ¡che oe que chacoquicue jjeya!” poanaje. “Eꞌe ecue Chii, jaaya chacoquije aje ca eya” poanaje. Jamatii poqui jjima poanaje, de. ");
INSERT INTO eseNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Jamajjeya ¿ache eshoꞌi oja chiija ehuohui jama poanaje? ¿Achajja acuae miña jjashahuabaquiani? —Eꞌoꞌi mese —acanaje cuaa. —Eꞌe —Jesosa poanaje—. Eyaya miya eꞌe nei huohuiaña jama baꞌa: Jiquio ecua eꞌoꞌi mese jjashahuabaqui majje oja chiiya huohui canaje jayojja jama acanaje jama jayojja dejja mimishi cuana, epona pea cojjojji poani peaꞌai. Eyacuiñajji nijje jjapeecuajiquiani oja ejaahuanajji. Miquiana ca mi ca oe, cho. Eyacuiñajji nijje jjapeequi jjima. ");
INSERT INTO eseNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eꞌe, Huani, ma ona besameejji poa yahuajo nei poeya poa miquiana ba meesahuaa. Huohui ca poa jama baꞌa: “¡Miquea mimishijo quea yeno pocue! ¡Mimishi cuana pajeaꞌyocue Eyacuiñajjija esohui jama ebaꞌejji, onijje ejjapeequijji!” Huani poa. Miquianaya aje oe Huani shajjaꞌajja sa po ajja poanaje. Dejja mimishi cuana, epona quea mimishi cuanaya ca ca shajjaꞌajja majje: “Eꞌe, ¡Eyacuiñajji nijje ejjapeequi, mimishi cuana ejjapajeaquiꞌyo!” poanaje. Ma ba majje jamatii miquianaya jjashahuabaqui jjima, Eyacuiñajjija esohui jama a sa po ajja tii poanaje —Jesosaa acanaje Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—¡Jiquio shajjaꞌajjacue pea esohui ejjashahuabaqui meejji! —Jesosa poanaje—. Oe dejjaa emeshi meseya que quea quemo nee neejo bana canaje jjonojjajja oo pana, uva. Que peeyi canaje meija peeyi. Majoya que yiyesamajo equishipashajji iya canaje, mei cueehue iñaca canaje jjonojjajja na quishipashajeajji. Majoya mei iyasohua aoꞌao majje peehuana canaje que jaahuanajji quea huesha nee ojaya ebajji. Pea echacojji cuana iyaa canaje. Huohui canaje emeshi meseya: “¡Ecuea que jaahuanacue! Jaahuana sosejje quiajeꞌyo oya jjonojjajja quea huiso nee” poanaje. Majoya emeshi mese quea huesha poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Quijje jjonojjajja jahuajo emeshi meseya pea o chacosahuajji poani beca huoojea canaje que jaahuanajji que, jjonojjajja jjequiya. Que jaahuanajji bañaqui majje huohui canaje jama baꞌa: “¡Che mo jjonojjajja joya ecuea emeshi meseya pa cadojoꞌyahua, de!” poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","—Que jaahuanajji cuana quea mimishi poanaje. Jjonojjajja quia sa po ajja, joya emeshi meseja iya tepe mee. Jamajjeya o chacosahuajji cuana iña canaje, cuiajea canaje, pea quecua canaje, pea jajahuejjajea canaje meiya. ");
INSERT INTO eseNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Emeshi meseya pea huoojea ca oꞌoyanaje huacuaya o chacosahuajji poani quea huiso pishana. Jamatii yahuajo jama acanaje que jaahuanajji cuaa. Cuiajea ca oꞌoyanaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Quijje yejje nei oja bacua ejja oe nei huoojea canaje que jaahuanajji baa: “Eꞌe, ohuaya ecuea ebacua ejja shajjaꞌajja caje” poanaje emeshi mese. ");
INSERT INTO eseNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cho, oja bacua ejja poeje ba majje jama poanaje baꞌa: “Joya emeshi meseja bacua ejja poeje. Jiquio meshi quijje ojaya poaje, ejeajji manoꞌyajo. ¡Cuaꞌa, ejjaquecuajeaqui oya eque mesenaꞌyojji! Jamajjeya meshi esejaya tii poajeꞌyo, de” poanaje que jaahuanajji quea mimishi cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","—Jamajjeya aje oe ebacua ejja iña canaje, quecuajea canaje, jeaqui canaje quea huesha nee, que jaahuanajji cuaa. Mahuiso esohui. ");
INSERT INTO eseNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—Jamajjeya emeshi meseya poe oꞌoya majje ¿yajja acuae acajeꞌyo jiquio que jaahuanajji quea mimishi cuana? —Jesosaa huohuiꞌajja canaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Oya quea quene nee nee poajeꞌyo. Ma que jaahuanajji quea mimishi cuana quecuajea cajeꞌyo, de. Que cuiña meequi cajeꞌyo pea cuana, joya ojjaña jjonojjajja shejo jjasosequiaquijji cuana —acanaje Jodio cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—Eꞌe —Jesosa poanaje—. ¿Aꞌa miquea eba Eyacuiñajjija esohui etehueꞌyo yahuajo nei? jama baꞌa: “Oe equi yamajjana equi iyajji cajaa aca poa cuaa. Jamatii Eyacuiñajjiya ma eyamajjana equi yamajjana quea caꞌa nee nequi mee ca poa. Jamajoya ojjaña ojaya epeejji cuanaa Eyacuiñajji bihuia cani”. Jamaya yahuajo nei tehue ca poa ejo; eya ma eyamajjana equi iyajji jayojja jama quea caꞌa nee nee nequi —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Eꞌe, jiquio esohui eba meesahuajji jayojja jama Eyacuiñajjiya acajeꞌyo —Jesosa poanaje—. Ohuaya yahuajo nei miquianaya babaca caꞌya poa ojo echacoꞌyojji, onijje ebaꞌe tiitiiꞌyojji. Jjeya ca ca Eyacuiñajjiya miquianaya, Jodio cuana, cajaa acajeꞌyo shajjamaꞌ jojoya. Pea cuana babaca cajeꞌyo ojo echacojji, onijje ebaꞌe tiitiiꞌyojji peaꞌai, joya eꞌe jojo nei ojo jjashahuabaquiani. ");
INSERT INTO eseNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","—Jiquio ecua eyamajjana cajaa aca poa cuaa jjeya quea caꞌa nee nequi jama eya miquianaaya cajaaya anaje; jjeya ca ca iña quea caꞌa nee eya nequiꞌyo. Ojjaña joya e ba jjima e cajaa amajje quea yeno poaje, de. E cajaa tiitii amajje ca ca quea nee nee po tiitiijeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesosaja esohui shajjaꞌajja majje Moisesija etehueꞌyo huohuijji cuana, Eyacuiñajji nijje emimijji etii cuana peaꞌai quea quene nee poanaje: —¡De! Ecuanajo oya mimiani, equi yamajjanajo pojjeama. Eseya que jaahuanajji quea mimishi jayojja peaꞌai ohuaya acani —poanaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jamajjeya Jesosa iña sa acanaje ejeanobiajeajji. Jamatii iña jjima; quea mete poanaje. Ojjaña dejja echichaꞌyo nequicaꞌyo cuaa Jesosa Eyacuiñajjija esohui huohuijji nei nei ba cani. Onajaya quea nahue nee nee Jesosa eꞌiñajji. ");
INSERT INTO eseNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jamajjeya Jesosaa o poe oꞌoyajjijo pea esohui ejjashahuabaquijji huohui canaje Jodio cuana huasijje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Eyacuiñajjiya ojjaña cuana huoojeaꞌyojji poajo jamaya poaje: Oe emeshi meseya oja bacua ejjaja ejjahuanaquijjijo bobi quea huiso dahua mee canaje ojaya epeejjija eꞌijjiajji nisho. ");
INSERT INTO eseNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ojjaña apoa poajo, o chacosahuajji huoojea canaje epeejji cuana iyaaa, bobi ijjiajji. Cho, poe sa po ajja poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jamajjeya emeshi meseya pea chacosahuajji cuana huoojea canaje. “¡Jamaya acue!” poanaje: “Epeejji, ¡poecuajicue oe! Ojjaña apoa. Anaꞌai quea sei quecua meenaje. Bobi cuana apoa, ojjaña. ¡Poecue ecue ebacua ejjaja ejjahuanaquijjijo quea bihui nee epojji! acue” emeshi mese poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Jamatii jjashajjaꞌajjaqui ajja poanaje cuana. Poe ajja. Beca cuana que yasijje poquinaje; peaa aquiana quiaa poquinaje; ");
INSERT INTO eseNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","pea cuaa emeshi meseja echacosahuajji iña majje cuia canaje, quecua caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma shajjaꞌajja majje emeshi mese quea quene poanaje. Sohuinano cuana huoojea canaje dejja shajjamaꞌ iñaa. Quecuajeyo caꞌyonaje; equi cuana dahuajea canaje, sohuinano cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Majoya emeshi meseya o chacosahuajji iyaa canaje pea cuana: “Ojjaña apoa eꞌijjiajji ejjahuanaquijjijo. Pea cuana epeejji nisho poanaje, jamajjeya epoejji pojjeama. Cajaa. ");
INSERT INTO eseNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","¡Poquicue! Quea huesha baꞌe cuana iyaaquicue: —¡Poecue emeshi meseja bacua ejjaja ejjahuanaquijji yasijje! ¡Bobi quea huiso ijjiahuacue! —acue” emeshi mese poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Jamajjeya poquinaje. Ojjaña cuana iyaa canaje; dejja quea pame, dejja quea mimishi cuanaya. Quea huiso poeyanaje. Dobiquinaje. Equi cuio canaje. Chamaꞌ pea eꞌanijji poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Majoya emeshi meseya ojjaña cuana baa poeyanaje, ojjaña cuana nijje mimiya. Ba canaje oe dejja daqui jehuejji. ");
INSERT INTO eseNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Epeejji, ¿apiojji acuae miya poeyanaje daqui quea jehuejji? ¡Jamaya pojjeama ecue bacua ejjaja ejjahuanaquijji yasijje epoejji!” poanaje. Sajaꞌa jjima ma dejjaja. ");
INSERT INTO eseNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jamajjeya emeshi mese quea tecue poanaje. Iyaa canaje o chacosahuajji: “¡Oya jeyo majje jeaquicue quea misi nee yasijje! Jomajo pa neineijeꞌyo, eseꞌ ijjiayaijea cajeꞌyo quea nee neejo” poanaje. Mahuiso ecuea esohui —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—Eꞌe, ojjaña cuana iyaaꞌajja caje Eyacuiñajjiya. Jamatii oe pojji dobiquijeꞌyo onijje ebaꞌe tiitiiꞌyojji —Jesosaa ojjaña cuana acanaje. (Eꞌe, Eyacuiñajjiya Jodio cuana iyaa coo canaje onijje ebaꞌeꞌyojji quea bihui nee. Jamatii shajjamaꞌ poanaje. Ojaya huoojeaꞌyo quecuajea canaje. Jamajjeya Eyacuiñajjiya Jodio pojjeama iyaa canaje. Quea huiso poeyanaje. Ma dejja daqui jehue jayojja jama beca cuanaja mimishi cuijeaꞌyo jjima. Jamajoya jeacuayajea cajeꞌyo quea nee nee epoꞌyojji.) ");
INSERT INTO eseNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesosa mimije shajjaꞌajja majje Paniseo cuana quea quene poanaje: —Oya Jesosa jjashahuabaquiani eseya epeejji nisho jayojja jama, de —poanaje. Poqui majje ojee mimimiminaje: —Cuaꞌa, Jesosa ejjadasiaquiqui; esohui quea camaja nee ejjahuohuiꞌajjaquiqui, ojaya yajja sajaꞌame yaꞌyojji. Jamajjeya Moisesija etehueꞌyo jayojja jama mi sajaꞌa cajo, cacuiajea meequiꞌyahua. ");
INSERT INTO eseNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jamajjeya Paniseo cuaa o shajjaꞌajjajji cuana, joya Enodeja esohui quea boti nee poani peaꞌai huoojea canaje Jesosa que. Huohuiꞌajja mee canaje jama baꞌa: —Esohui huohuijji, miyaya eꞌe jojo nei huohuiaña Eyacuiñajjija ejjashahuabaquiꞌyojji jama. Miya etii cuanajo jjashahuabaqui ajja; emeshi mese cuanajo peaꞌai meteꞌama. Jamajjeya quea jaꞌa nee huohuiaña. ");
INSERT INTO eseNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eꞌe. Jamajjeya mo oe che huohuicue: ¿Aꞌa bejjo quia cajji Shomano meshi mese Sesa bajjanija yajji? ¿Aꞌa equiajji pojjeama esejaya pojjaꞌa? ¿Aꞌa cuae jja ma Sesaja meshijo baꞌe sosejje quia cajji soꞌo? —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Jodio cuanaja ejjashahuabaquijji Jesosaja eba poanaje. Jamajjeya: —¡Miquianaya ca mi ca oe e dasiajji nisho cuana, epeejji nisho quea tai nee nee! ¿Apiojji nequiaa eya dasia sa aña? ");
INSERT INTO eseNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","¡Bejjo mo huohuiꞌajjacue esodojjo! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jjequi canaje cuaa. Esodojjo ba majje huohuiꞌajja canaje Jesosaa: —¿Ae ecajjaꞌyo jiquio? ¿Ae bajjani tehuemeꞌya? ");
INSERT INTO eseNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Emeshi mese ecajjaꞌyo, Sesa bajjani —acanaje Jodio cuaa. —Eꞌe —poanaje Jesosa—. Jamajjeya ¡Sesaja bejjo quiaquicue ohua sa cajo! ¡Eyacuiñajji aꞌa pajeaꞌyojji; oya bihuiacue, shajjaꞌajjacue peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesosa shajjaꞌajja majje ojjaña cuana quea mete nee poanaje: —¡Quea jjashahuabaqui jaꞌa nee nee oya Jesosa! ¡Jjadasia meequi ajja! Jamajjeya poquinaje, jeana caꞌyonaje Paniseo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma pojjajo tii beca Sanoseo cuana poeyanaje Jesosa huohuiꞌajjaa. Sanoseo cuana aje oe jama poani baꞌa: —Manoꞌyo majje jama tii tii; eshequi oꞌoyajji pojjeama quijje. Jesosaja ca ca jama sohuihuohuime ajjima. Jamajjeya Jesosa huohuiꞌajja canaje Sanoseo cuaa; edasiajji nisho jama acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Esohui huohuijji, Moisesiya jama tehue ca poa yahuajo nei nei baꞌa: “Dejja ejjahuanaqui, bacuamaꞌ manoꞌyajo, oja chahuaa ehuanase equijjojea ani cahuana caꞌyahua, oja oꞌija bacua jea jayojja jama epojji”. ¿Aꞌa eꞌe? ");
INSERT INTO eseNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jamajjeya jama poso baꞌa: Quea huiso edoe mese, me oejje pea beca nequia poa. Eꞌoꞌi mese ebionei jjahuanaquia poa eponajo. Manoꞌyonaje bacuamaꞌ tii. Oja chahuaa epona equijjojea ani huana ca oꞌoyanaje, bacuamaꞌ tii ani. ");
INSERT INTO eseNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Oya jayojja manoꞌyonaje bacuamaꞌ tii. Jamajjeya peaa echahua meseya huana ca oꞌoyanaje. Manoꞌyonaje bacuamaꞌ peaꞌai. Jamaya ojjaña manojeyoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Quijje ehuanase peaꞌai manoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jamajjeya shequi oꞌoya majje eyajo, ¿ajea ehuanase epona poaje, ache edoe meseja? Ojjaña echahua cuana hueaꞌajjaꞌyo epo —Sanoseo cuaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesosaa sajaꞌa canaje jama baꞌa: —Chojja. Jamaya pojjeama. Miquea ba jjima Eyacuiñajjija esohui; oya quea caꞌa nee nee miquea ba jjima peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Eꞌe, shequi oꞌoya majje ejjahuanaquiꞌyojji pojjeama. Esohuidojojji eyajo ani jama poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Cuanaya ¿aꞌa miquea ba jjima dejja cuana ojjaña manoꞌyo majje shequije oꞌoya? Jamajjeya Eyacuiñajjiya yahuajo nei esohui tehue mee ca poa miquiana jjabahuejjaquijji. Jamaya poa baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Eya ca ca iña Amajama jaahuanajji, Isaaca, Jacobo peaꞌai jaahuanajji”. ¿Aꞌa Eyacuiñajjiya emanoꞌyo cuana meshijo eꞌohuajea jaa jaahuana cani? Cho. Ojaya epeejji cuana eshe nequi, manoꞌyo majje shequiꞌyo peaꞌai jaahuana cani Eyacuiñajjiya —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesosaja esohuijo ojjaña cuana quea bihui nee poanaje: —¡Quea pame nee ohuaya Jesosaa huohui cani! —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Majoya Paniseo cuaa shajjaꞌajja canaje Jesosa quea jjashahuabaqui jaꞌa nee; Sanoseo cuana jjadasia meequi ajja. Jamajjeya jjachichaqui majje ojee jjashahuabaqui oꞌoyanaje Jesosa dasiaquijji, esohui quea camaja nee ehuohuiꞌajjaquijji. ");
INSERT INTO eseNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Majoya Jesosa que poe oꞌoyanaje Paniseo cuana. Dasiaꞌyohua nisho Moisesija etehueꞌyo huohuijjiya huohuiꞌajja canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Esohui huohuijji, yahuajo Moisesiya tehue ca poa Eyacuiñajjija esohui. ¿Ache esohui quea pame nee nee eꞌajji? ");
INSERT INTO eseNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesosaa acanaje: —Eꞌe, jamaya quea pame nee acue baꞌa: “¡Eyacuiñajji miquea Emeshi Mese nei quea jea nee nee acue! Miquea huapa pojjeama cuana miquea quea jea; ¡quea jea nee neeya oe acue Eyacuiñajji! Jamajjeya ¡ojo jjashahuaba tiitiiquicue!” ");
INSERT INTO eseNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","Jiquio ehuohuiꞌyo quea pame nee. Pea oya jayojja quea pame nee jama baꞌa: “¡Ojjaña pea cuana quea jea nee acue, miquea huapa pojjeama jama quea jea neeya oe acue!” ");
INSERT INTO eseNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jamaya miya poajo miya Moisesija etehueꞌyo jama baꞌe; Eyacuiñajjija esohui huohuijji yahuajo nei baꞌeja esohui jama baꞌe peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jamajjeya ojjaña Paniseo cuana jjachichaquiajo oya cuana huohuiꞌajja canaje Jesosaa: ");
INSERT INTO eseNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Yajja huohuime acuae nequiaa aña Eyacuiñajjija huoojeaꞌyo dejja jaahuanajjijo Quitojo? ¿Ache etiiquianaja osecua oya? —Quito emeshi mese Dabija osecua, ma yahuajo baꞌya poaja —acanaje Paniseo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Jamajjeya ¿yajjajje acuae Eyacuiñajjija Edojjoshahua Pameya emeshi mese Dabi jama amee ca poa yahuajo baꞌa: “Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji Quito ecuea Emeshi Mese nei”? Yahuajo nei Dabiya jama huohui ca poa peaꞌai baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Eyacuiñajjiya ecuea Emeshi Mese Quito jama aca poa: —¡Enijje anioquecue ebianei mijijje ojjaña cuana huoojeaꞌyojji! Eyaya mi quecuajji nisho epo jeabichajea jeyojeyojeꞌyo”. Jamaya huohui ca poa yahuajo Dabiya ejo. ");
INSERT INTO eseNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eꞌe, Dabiya Eyacuiñajjija huoojeaꞌyo Quito aca poa “Ecuea Emeshi Mese”. Jamajjeya Quito Dabija Emeshi Mese nei poani. Jamatii oya Dabija osecua peaꞌai, de —Jesosaa acanaje—. Eya, Eyacuiñajjija huoojeaꞌyo, dejjaja jea pojjeama; Eyacuiñajjija Bacua Ejja. Jamajjeya eya ojjañaja Emeshi Mese nei. ");
INSERT INTO eseNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesosa mimije shajjaꞌajja majje Paniseo cuana quea mete poanaje. Jeca poanaje, mimimaꞌyo aninaje; huohuiꞌajja becaꞌyo jjima tii acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Majoya Jesosaa ojjaña cuana, o shajjaꞌajjajji cuana peaꞌai huohui canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisesija etehueꞌyo huohuijji, Paniseo cuana peaꞌai miquea esohui huohuijji. ");
INSERT INTO eseNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jamajjeya ¡oya cuana shajjaꞌajjacue! ¡Ojaya esohui jayojja jama acue ojjaña! Jamatii oya cuana aje oe esohui jama baꞌe ajja; quea mimishi. Jamajjeya ¡aꞌa o jayojja baꞌejji! —poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eꞌe, jamaya poani baꞌa: Dejjaa aquiana quea biquie abo mee cani pea dejja. Jamatii huanasohua sahua ajja, de, quea mimishiya jjejojo. O jayojja Jodio esohui huohuijjiya pea cuana baꞌe meesahua ajja Eyacuiñajjija etehueꞌyo jama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Quea pame poso oya jjabaquiani onaja ebihuiajji: “Eꞌe de, oya esohui huohuijji quea pame nee” epo meejji acani. Jamajjeya esohui etehueꞌyo quea quemo jjasapahuahuo iyaquiani, aa huahuo peaꞌai ojjañaja ebajji. Daqui quea pame nee nee, quea ao nee huosho cani ojjañaja ebajji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ojee ijjiaꞌijjianijo, emeshi mese pejjejo anioqueani ebionei ijjia sa poanijo. Jodioja equi ojee ejjachichaquijjijo peaꞌai ebionei anioque sa poani Eyacuiñajjija esohui huohuijji pejjejo, ojjaña nijje emimimimijji. “Eꞌe, oya cuana Eyacuiñajjija esohui huohuijji nei quea pame nee” epo meejji acani. ");
INSERT INTO eseNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ejiojjijje poquiani ojjañaa aquiana quia cani yasijje anicuaa, pea cuaa jama bihuia cani baꞌa: “Esohui huohuijji, miya quea pame nee nee.” Jamaya aje oe ojaya quea boti nee, jiquio Jodio etii cuanaja, esohui huohuijji quea pame nee poso jjabaquiani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jamajjeya o shajjaꞌajjajji cuana Jesosaa acanaje peaꞌai jama baꞌa: —¡Aꞌa miquianaya o jayojja jama pojji! Pea cuana aꞌa jjabihuia meequijji: “¡Miya esohui huohuijji quea pame nee nee!” aꞌa jjapo meequijji cuana. Cho. Miquea Esohui Huohuijji quea pame nee oe nei yani, miquea Emeshi Mese nei. Miquianaya ecuea epeejji cuana ca ca Eyacuiñajjiya ba cani pea epeejji jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Oe nei eyajo ani eseja Chii. Jamajjeya ¡esohui huohuijji oya jayojja “Esejaya Chii” aꞌa ajji! ");
INSERT INTO eseNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Cuanaya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, Quito miquiana huoojeaꞌyojji nei nei. Jamajjeya pea cuana “ese huoojeaꞌyojji nei” aꞌa jjapo meequijji. ");
INSERT INTO eseNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Eꞌe, ¡emeshi mese jayojja jama nequi sa poani ca ca pea cuana chacosahuacue! ");
INSERT INTO eseNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jamajjeya joya emeshi mese poso jjabaquiani Eyacuiñajjiya emeshi mese pojjeama acajeꞌyo. Echacosahuajji jjabaquiani ca ca Eyacuiñajjiya emeshi mese jayojja po mee cajeꞌyo —jamaya acanaje Jesosaa o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Majoya Jesosaa Paniseo cuana, Moisesija etehueꞌyo huohuijji poani peaꞌai jama tecueame acanaje baꞌa: —Miquianaaya aje oe Moisesija etehueꞌyo huohuiaña, Jodioja esohui huohuijji poaniya peaꞌai. Jamatii miya ca mi ca oe esohui huohuijji nisho, siajjepojji. Eꞌe, miquianaya Eyacuiñajji nijje jjapeequi ajja. Pea cuana Eyacuiñajji nijje jjapeequi sa poani miyaya jjapeequipajea meeyaña, de. Eꞌe, jiquio ecua esecue caꞌa cani cuaa ona edobiqui poani jjejojo jama jayojja miquiaaya pea cuana dobiqui mee ajja eyahuasijje Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji. Jamajoya miquianaya quea nee nee po mee cajeꞌyo quijje, quea nee nee tii tii, de —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Eꞌe, miquianaya ca ca oe eꞌahuemanoja equi cuana jjesheaña sosemaꞌ. Majoya Eyacuiñajji nijje mimi nishoani quea huiso nee. Jamajoya Eyacuiñajjiya miquianaya cajaa acajeꞌyo. Quea nee nee po mee cajeꞌyo tii tii —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Jodioja esohui huohuijji cuana, Moisesija etehueꞌyo huohuijji cuana peaꞌai, miquianaya aje oe esohui huohuijji nisho, peajja. Miquianaaya chaco neineiaña; quea huesha poquiani peaꞌai pea cuana Moisesija etehueꞌyo shajjaꞌajja meeya. Jamatii mi shajjaꞌajjajji cuana mi jayojja quea mimishi nee nee. Jamajoya oya cuana eꞌe jojo nei quea nee nee po mee cajeꞌyo, mi jayojjaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Eꞌe, miquianajaya ehuohui quea quehuajo cojjamaꞌ jama poani. Cojjamaꞌ cuana pea cojjamaꞌ cuaa me iña majje mepejjejea cani jayojja. Ojjaña poquiquehuajeꞌyo —Jesosa poanaje—. Miquea ehuohui jama baꞌa: “Eyacuiñajjija equi nequianijo, ecuea ehuohui jama eyaya eꞌe jojo nei aje”. Pea cuana jama poani baꞌa: “Chojja, jamaya mimi majje miquea ehuohui jama eꞌajji pojjeama”. Jamaya huohui cani cuaa peaꞌai baꞌa: “Ma mei huoꞌo Eyacuiñajjija equijo anijo, ecuea ehuohuiꞌyo jayojja jama eyaya aje”. “Eꞌe, ¡jamaya mimi majje miquea ehuohui jayojja jama eꞌe jojo nei acue!” pea cuana poani. Jamaya mimi quehuani miquianaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oya cuana tecuea canaje jama peaꞌai baꞌa: —Chojja, de. Miquianaya jjashahuaba quehuaquiani. Mei huoꞌo Eyacuiñajjija equijo quea pame ani; Eyacuiñajjija equi quea pame nee peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Miquianajaya pea ehuohui quea quehua peaꞌai jama baꞌa: “Mei ehuana huichaꞌa huichaꞌa pea mei biajje yani Eyacuiñajjija equijo aquiana dahuajji, Eyacuiñajji bihuiajji. Ma mei eꞌiya cuana nequianijo, eyaya ecuea ehuohui jayojja jama eꞌe jojo nei aje” amajje, dejja ojaya ehuohui jama eꞌajji pojjeama, miquianaya poani. Jiquio jama poani baꞌa: Aquiana mei eꞌiya biajje huana cani cuaa. Majoya jama mimiani baꞌa: “Ma aquiana mei eꞌiya biajje yanijo, ecuea ehuohui jayojja jama eyaya aje”. “Eꞌe, ¡jamaya mimi majje ca ca miquea ehuohui jayojja jama eꞌe jojo nei acue!” ¡Miquianaya jamaya mimi quehuaꞌani cuana! ");
INSERT INTO eseNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ma ehuohuiꞌyo cajaa! —Jesosa poanaje—. Mei eꞌiya quea pame nee; aquiana mei eꞌiya biajje ani quea pame peaꞌai. Pea jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jamajjeya dejja mei eꞌiyajo mimianijo oya ojjaña aquiana mei eꞌiya biajjejo mimiani peaꞌai. Pea jayojjaya poani. ¡Jamaya aꞌa mimijji ma aquiana cuanajo! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","—Miquianaya Eyacuiñajjija equi yasijje mimiani cuana jama baꞌa: “Eyaya ecuea ehuohuiꞌyo jayojja jama eꞌe jojo nei aje Eyacuiñajjija equi yanijo”. Jamaya aje oe miya mimiani Eyacuiñajjijo, ma equijo baꞌyanijo peaꞌai. Jamajjeya ¡Eyacuiñajjija equi yasijje aꞌa jama mimijji! ");
INSERT INTO eseNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pea cuana mimianijo eyahuasijje jama poani baꞌa: “Eyajo Eyacuiñajjija ebaꞌejji yanijo eyaya ecuea ehuohuiꞌyo jayojja jama eꞌe jojo nei aje. Ecuea esohui eꞌe nei pojjeama jojjemo eya quea nee capoahua”. Jamaya amajje miya Eyacuiñajjija ebaꞌejjijo mimiani; “Eyacuiñajji eyajo aniya eya ba canijo, eyaya ecuea ehuohuiꞌyo jayojja jama eꞌe jojo nei aje”. “Ecuea ehuohuiꞌyo jayojja jama ajjima jojjemo eya quea nee po mee caꞌyome” beshahua nei aña; oya jayojjaya. Jamajjeya ¡aꞌa jamaya mimijji Eyacuiñajjijo; quea tai! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Majoya Jesosaa Moisesija etehueꞌyo huohuijji cuana, Paniseo cuana peaꞌai jama tecueame acanaje baꞌa: —Miquea aquiana bobi quea johua eꞌajji equi pejjejo pohuani. Tiiyajo quiaña iye huiso Eyacuiñajjija epojji, ojaya ehuohuiꞌyo jayojja jama poani: “Miquianajaya aquiana ipiacue; ome miji peaꞌai, 10 oya jayojjaya, oe Eyacuiñajjija epojji, pea me oejje ebeca pee peaꞌai, 9 miquea epojji”. Eyacuiñajji yahuajo nei jamaya poa. Jamaya miya poani. Quea pame. Jamatii de, Moisesija etehueꞌyojo quea jaꞌa jjashahuaba tiitiiqui ajja. Jamaya quea tai aña baꞌa: Miya eꞌe jojo nei jjashahuabaqui jjima, siajje poani, jjashahuabaqui ajja aemaꞌ cuana baꞌe meesahuajji. Eyacuiñajjija esohui jayojja jama po tiitii ajja. Jamajjeya ¡Eyacuiñajjija etehueꞌyo jama baꞌecue! ¡Majoya Eyacuiñajji yasijje iye huiso quiacue ojjaña miquea aquiana peaꞌai! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—Miquianaya cojjamaꞌ jama; jjashahuabaqui ajja peaꞌai. ¿Aꞌa huashapa bobijo anidobiquiajo jeajeaꞌaña, jamatii aquiana quea quemo anidobiquiajo ijjiajeaña? Jamaya miya poani; ojjaña miquea aquiana quea biso peaꞌai ipiaꞌajja majje iye huiso quiaña Eyacuiñajjija epojji. Jamatii pea cuana baꞌe meesahua ajja, de. Jamajoya Eyacuiñajjiya miquianaya cajaa acajeꞌyo; quea nee nee po mee cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Eꞌe Paniseo cuana, miquianaya Moisesija etehueꞌyo huohuijji peaꞌai. Jamatii miquianaya ca ca oe esohui huohuijji nisho de, quea tai. ¿Aꞌa caneco cueehue topo cani cuaa ena ishi jjimahuajo, jamatii eyiyedojjojje quea ihui shacua jjima? Jamaya miya. Jjabaquiani quea pame jayojja. Jamatii quea jjashahuabaqui tai nee; sii poani; epona, onaja aquiana jea baña peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Paniseo cuana, miquianaya aje oe quea jjashahuabaqui quehua. Jamajjeya Eyacuiñajjiya miquianaya cajaa acajeꞌyo; quea nee nee po mee cajeꞌyo, de. ¿Aꞌa caneco yiyedojjojje ebionei topo cani cuaa? Jamajjeya eꞌe jojo nei quea pame nee. ¡Caneco topo cani jayojja jama acue miquiaaya; ebionei jjashahuabaqui tai pajeaꞌyocue eꞌe jojo nei quea pame epojji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Paniseo cuana, Moisesija etehueꞌyo huohuijji peaꞌai, miquianaya esohui huohuijji nisho de, quea mimishi. Emano mojeaꞌyojji cuiaꞌasha cani cuaa quea pame jayojja. Jamatii eyiyedojjojje quea ihui, emanoꞌyo sajaajji. ");
INSERT INTO eseNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Emanoꞌyo mojeaꞌyojji jayojja jama miquianaya cuana; quea pame jayojja ojjañaa ba cani; jamatii quea jjashahuabaqui tai. Shajjamaꞌ, quea pame po nishoani peaꞌai. Jamajoya Eyacuiñajjiya miquianaya cajaa acajeꞌyo; quea nee nee po mee cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Moisesija etehueꞌyo huohuijji, Paniseo cuana peaꞌai, miquianaya aje oe esohui huohuijji nisho, quea mase. Jamajjeya Eyacuiñajjiya miquianaya quea nee nee po mee cajeꞌyo. Eꞌe, miquianaya emano sajaajji moꞌyaña, quea pame aꞌyaña ma Eyacuiñajjija esohui huohuijji yahuajo mojea jaa. Esajaajji cuiaꞌashaꞌaña quea pame nee Eyacuiñajjija epeejji nei yahuajo emanoꞌyo bihuiaꞌyojji —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Siajje miya poani jama baꞌa: “Yahuajo ecuanaja etiiquiana cuana nijje ebaꞌeꞌyo jojjemo ecuanaja ca ca oe Eyacuiñajjija esohui huohuijji cuana ecuiajeaꞌyojji pojjeama poqueaye. Chamaꞌ ecuanaja ejjashahuabaquijji etiiquiana jama; ecuanaja ca ca pea” miquianaya poani —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chojja. Jamaya miquianaya po nishoani. Jamatii miquianajaya etiiquiana jama Eyacuiñajjija esohui huohuijji quecuajji nei nei peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jamajjeya o jayojja jama poani quiana; Eyacuiñajjija huoojeaꞌyo cuana cuiajea jeyojeyojeꞌyo, de —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Miquianaya peyo quea se nee nee jama de, quea mase nee nee, esohui huohuijji quecuajji, miquea etiiquiana cuana jama. Jamajjeya ¿aꞌa acuae nequiana Eyacuiñajjijo jjanequiquehuaquijji? Chojja. Eꞌe jojo nei ohuaya miya huohui cajeꞌyo: “¡Poquicue nequiana! ¡Cuaqui yasijje dobiquicue! ¡Quea mase nee nee aje oe nequiana!” —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—Jamajjeya eyaya miquiana huasijje huoojeaña Eyacuiñajjija esohui huohuijji, esohui bameesahuajji, dejja quea jjashahuabaqui jaꞌa nee peaꞌai. Jamatii beca cuana cuiajeajeꞌyo; pea cuana acui ecueataꞌapeejo me cacajeajeꞌyo; pea cuana cuiasejjajeajeꞌyo miquea equi ojee ejjachichaquijji yasijje; pea cuana ocuenajeꞌyo ojjaña cuiñajji yasijje equecuaꞌyojji, miquianaaya —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eꞌe Jodio cuana, miquea etiiquiana cuaa dejja mimishiꞌama quecuajea caꞌyonaje quea huiso. Eyacuiñajjija etehueꞌyo ebionei tehue ca poa jama baꞌa: Abeni cuiahuejjajea ca poa miquea etiiquiana Cainiya. Oya jayojja quea huiso cuiajea ca poa cuaa. Quijje nei Eyacuiñajjija etehueꞌyo quijje yejje nei tehue ca poa oja sohui huohuijji Sacania, Benequiaja bacua ejja cuiahuejjajea ca poa cuaa Eyacuiñajjija equijo, aquiana dahuajeajji pejjejo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jamajjeya eyaya miya eꞌe jojo nei huohuiaña: Jjeya nei apoa poaje; Eyacuiñajjiya miquiana cuana quea nee nee po mee cajeꞌyo ojjaña miquea etiiquianaja mimishi cuanajo, o jayojja jama miquianaya poani jojoya. Jamaya Jesosaa Jodio cuana tecuea canaje quea mimishi nee jojoya. ");
INSERT INTO eseNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Majoya Jesosa quea yeno nee nee ojjaña cuana Jenosanenajo baꞌe cuanajo jama poanaje baꞌa: —Jodio cuana Jenosanenajo baꞌe, miquiana cuana ecuea quea jea nee nee. Jamajjeya eya miquianajo quea yeno poani. Eꞌe, miquianaaya aje oe Eyacuiñajjija esohui huohuijji quecuajeaꞌya poa; ojaya huoojeaꞌyo jajahuejjajeaꞌya poa meiya peaꞌai. ¡Bacue oe! Cachina enaeseya ebacua huojje cani ejaahuanajji jama jayojja eyaya miquiana iyaa sa neineiaña e que, ejaahuanajji. Jamatii enijje jjapeequi sa po ajja. Cajaa aña jama baꞌa: “Chojja, Eyacuiñajjija miya huoojea jjima ojjaña jaahuanajji”. ");
INSERT INTO eseNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jamajjeya ¡bacue! —Jesosa poanaje—, Eyacuiñajjiya miquianaya cajaa acajeꞌyo. Jeajea cajeꞌyo ejaahuana majajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eꞌe, eya jiquiojo tii nequi tii ajja. Jamajjeya eya miquianajaya ba oꞌoya jjima poaje e poe oꞌoya jjimahuajo. Quijje e poe oꞌoyajo ca nequiana ca oe jama poaje baꞌa: “Jesosa miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. ¡Eyacuiñajjiya miya cajaahuana cahua quea pame!” poaje miquianaya quijje —Jesosa poanaje Jenosanenajo baꞌe cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesosa Eyacuiñajjija equijo ani poquinaje. Poquijeya o shajjaꞌajjajji cuaa oya huohui canaje: —¡Bacue Eyacuiñajjija equi! Quea quemo, quea pame mei cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—Eꞌe. ¿Aꞌa jiquio equi quea pame nee baña? Eꞌe jojo nei quijje mei cuana cajjajeajea cajeꞌyo cuaa. Chamaꞌyo tii acajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Quijje Jesosa eyiyo huasijje Onimo acui yiye yasijje jaasohuaquinaje o shajjaꞌajjajji cuana nijje. Anioquenaje. Pea dejja poqui jjima. Jamajjeya o shajjaꞌajjajji cuaa huohuiꞌajja canaje: —Jesosa, ¿ache shono acuae mei cuana cajjajeajea cajeꞌyo cuaa soꞌo? ¿Ae acuae poaje mi epoe oꞌoya cuahuajje? ¿Aꞌya ba majje ecuanaja eba poaje miya poeje oꞌoya, meshi chamaꞌyo tii epojjijo? ");
INSERT INTO eseNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesosaa sajaꞌa canaje: —¡Jjashahuaba neineiquicue onajaya miya edasiajji pojjeama! ");
INSERT INTO eseNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Quea huiso siajjepojji poeje, ecuea ehuoojeaꞌyo pojjeama: “Eyacuiñajjiya eya huoojea canaje, eya ca ca iña ojjaña jaahuanajji” siajje poaje. Quea huiso dasia cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Ojjaña jjaquecuaquiani ojjaña meshi yasijje” huohui caje peaaya peaꞌai. Jamatii ¡aꞌa quea mete pojji! Jamaya poaje. Jamatii apoa pojjeama, oe po ajja jjima poaje soꞌo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Eꞌe, jjaquecuaqui cajeꞌyo cuana ojjaña meshi yasijje, ojjaña cuiñajji yasijje peaꞌai. Quea huiso emanomeejjiya mano mee cajeꞌyo; bobi yasijje po majje manojeꞌyo quea huiso; meshi huehuahuehuaje ojjaña meshi yasijje peaꞌai —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eꞌe, jiquio ecua epona bacua cuayaje ebionei jjapashineijje neeꞌani; quijje quea nee nee. Jamaya poaje e poe oꞌoya jjimahuajo. Quea nee pishana po majje quea nee nee poaje ojjaña cuana —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Majoya pea cuaa miquianaya iña majje jeanobiajea cajeꞌyo ecuiasejjajeajji, equecuaꞌyojji peaꞌai. Enijje jjapeequianijo miquianaya botiꞌama nei poaje ojjaña meshijo baꞌe cuanaja. ");
INSERT INTO eseNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jamajoya quea huiso enijje jjapeepajeaquiꞌyo majje mimishi aje oꞌoya. Peaja epeejjija botiꞌama poajeꞌyo —Jesosa poanaje—. Jamajoya dejja mase iña mee cajeꞌyo equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Quea huiso pea cuana poeje: “Eya Eyacuiñajjija esohui huohuijji” siajje poaje. Cho, Eyacuiñajjija pojjeama. Jamatii, ecuea epeejji dasia cajeꞌyo quea huiso. Poquiquehua mee cajeꞌyo eshahua nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dejja cuana shajjamaꞌ jayojja po majje emeshi mese cuana shajjaꞌajja sa po ajja poajeꞌyo. Jamajjeya pea cuana botiꞌama poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jamatii e poe oꞌoya jjimahuajo, enijje jjapeequi pajeaꞌyo ajja tii ca ca Eyacuiñajji nijje baꞌe tiitiijeꞌyo, enijje peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Eya poeje oꞌoya. Eyacuiñajji nijje ojjaña cuanaja Emeshi Mese nei poajeꞌyo. Ma ehuohuiꞌyo quea pame nee ojjaña meshi cuana huasijje huohui caje, ojjaña dejja cuana huasijje peaꞌai ojjañaja eshajjaꞌajjajji. Majoya e poe oꞌoyajo ojjaña oe poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Eyacuiñajjija esohui huohuijji Dañeniya yahuajo nei huohui ca poa jama baꞌa: “Quijje Eyacuiñajjija equijo nequije aquiana quea tai nee nee, ojjaña quea mete nee nee epo meejji”. ");
INSERT INTO eseNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jamajjeya ma ba majje ca ca, ma pojjajo tii ojjaña Jodio meshijo baꞌe capoquicuajiahua eyiyo cuana huasijje. (Jiquio ehuohuiꞌyojo cajjashahuabaquiahua quea jaꞌa epojji.) ");
INSERT INTO eseNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","¡Joya equi huisa biajje chacochacoani aꞌa equi yasijje dobiquinanajji aquiana cuana biohua edojojji! ");
INSERT INTO eseNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","¡Joya quejo chacochacoqui peaꞌai aꞌa equi yasijje poquinanajji daqui moojo! Eyiyo huasijje poquicuaji ajja aje oe manoꞌyo chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Epona cuana oꞌejji, bacua shoꞌijji peaꞌai quea yeno poaje; quea camaja equehua poquicuajijji poaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jamajjeya Eyacuiñajji nijje mimicue jama baꞌa: “Eyacuiñajji, ¡eenojo pojjeama capoahua, epojja ejomishocajjijo pojjeama peaꞌai ecuanaja epoquijji eyiyo cuana huasijje!” acue —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Eꞌe, ma pojja cuanajo ojjaña quea mete nee nee, quea yeno nee nee poaje. Jamaya pojjeama yahuajo, meshi pana majje, jjeya nei peaꞌai, quijje peaꞌai; quea mete pishana, quea yeno pishana. Ma pojja cuanajo ca ca quea nee nee poaje dejja cuana —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","—Eyacuiñajjiya oe pojji cahuime quea camaja po mee cajeꞌyo; oe pojji cahuime epoꞌyo jojjemo ojjaña cuana manoꞌyome. Ojaya epeejji jaahuana canijo, ojaya quea nahue nee emano jeyojeyoꞌyojji, Eyacuiñajjiya oe pojji cahuijo quea camaja po mee cajeꞌyo, quea cahui huiso pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Ma pojja cuanajo aꞌa jjashajjaꞌajjaquijji ona siajje poajo jama baꞌa: “¡Bacue oe, Eyacuiñajjija huoojeaꞌyo Quito jiquiacua poeꞌyonaje!” jama poso, ¡aꞌa shajjaꞌajjajji! “¡Bacue oe, Quito jocuama pa poeꞌyonaje!” Jama onaa acajje ¡aꞌa jjashajjaꞌajjaquijji, aꞌa poquijji! ");
INSERT INTO eseNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eꞌe, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji e jayojja nisho, Eyacuiñajjija esohui huohuijji nisho peaꞌai poeje quea huiso nee nee. Ohuaya ma pea dejjaa ajjima acani acajeꞌyo Eyacuiñajjija epeejji cuana dasiaꞌyojji nisho. Dasia cajeꞌyo quea huiso nee; ecuea epeejji nei peaꞌai beshahua nei eya pajea mee cajeꞌyo o jayojja epojji; chojja, jjadasia meequi ajja. ");
INSERT INTO eseNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","E shajjaꞌajjajji cuana, eyaya miya huohuinaje quijje oya poeje ejjadasiaquiꞌyojji. ¡Aꞌa oya cuana shajjaꞌajjajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Jamajjeya aꞌa jjashajjaꞌajjaquijji onaa miya siajje acajje jama baꞌa: “¡Baquicue oe, Quito jocuama huenihueni aijo nequi!” Jama acajje ¡aꞌa baquijji! “¡Bacue oe, Quito equi equecuayijji dojjojo ejjaꞌaniquehuaqui ani!” acajje ¡aꞌa jjashajjaꞌajjaquijji; aꞌa o que dobiquijji! ");
INSERT INTO eseNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","28","Cho, shajjaꞌajjacue ecue sohui: ¿Aꞌa joya eꞌihuijaa huasijje beꞌo cuana cuabesajebeje? Eꞌe jojo nei miquianaaya eya baje joya ecua beꞌo eꞌihui yasijje oqueani jama. Cuanaya pojjejje nei nei poajo jeajaꞌa cani eyajo; ojjañaa ba caje quea huesha nee. Jamaya eya ojjañaja Edoe Mese poeje oꞌoya, pojjejje jama. Jeajaꞌajeajebeje. Eya ojjañaa ba cajeꞌyo. Quehuajje pojjeama eya poejeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Eꞌe, quea camaja nee nee po majje majoya eshequi quea apo poajeꞌyo. Baꞌi jijiꞌyo ajja poajeꞌyo. Majameta cuana jjacajjaquiꞌyo majje jijijijioquejeꞌyo ojjaña peaꞌai. Majameta nequijji cuana huehuahuehuajeꞌyo janobajjima nei peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","—Majoya miquianaaya baje aquiana eyajo. Ma ba majje huohuije jama baꞌa: “¡Eꞌe jojo nei Jesosa Quito ojjañaja Edoe Mese jjeyahua nei poeje oꞌoya, de!” poaje. —Jamajjeya ojjaña cuana ojjaña meshijo baꞌe quea mete nee nee poajeꞌyo. Ecuea epeejji pojjeama siasiaje jama baꞌa: “Coya aje oe ¿ae shai poeje baꞌa? ¡Bacue, ojjañaja Edoe Mese Jesosa Quito poeje oꞌoya bo biajje! Oya oe nei quea caꞌa nee nee, quea sohui poja nee nee. Quea jeajahua nee nee peaꞌai. Esohuidojojji quea caꞌa nee onijje poeje quea huiso nee nee” poaje cuana —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Esohuidojojji quea caꞌaa aquiana esheꞌana ai jayojja mia cajo, eyaya esohuidojojji cuana huoojeajeꞌyo biacua, macua huasijje peaꞌai ojjaña ecuea epeejji cuana jjequiya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesosaa huohui canaje pea esohui jama baꞌa: —Eꞌe, eyaya miquianaya esohui ejjashahuabaqui meejji huohuije iquena acuijo. Esejaya meshijo acui iñaꞌyani ba majje eseya jama poani baꞌa: “Eꞌe nei, nayaja poꞌyonaje. Jjeya eshequiaja po pajeaꞌyonaje”. ");
INSERT INTO eseNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","—Jamaya eshequi, baꞌi quea misi, majameta eyajo jijijijioqueꞌani ba majje peaꞌai quea bihui jjashahuabaquicue jama baꞌa: “Eꞌe, jjeya nei apoa poaje. ¡Jjeyahua nei esejaya Emeshi Mese nei Jesosa Quito poeje oꞌoya!” ");
INSERT INTO eseNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","—Eꞌe jojo nei ojjaña ma pojja cuanajo baꞌe cuana mano jeyojeyoꞌyo jjimahuajo ojjaña apoa poajeꞌyo; eya ojjañaja Emeshi Mese oe nequijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Eꞌe, aquiana eyajo nequi chamaꞌ poajeꞌyo; ojjaña meshi chamaꞌyo tii poajeꞌyo peaꞌai. Jamatii ecuea esohui oe epoꞌyojji pojjeama; shajjaꞌajja tiitii cajeꞌyo cuaa —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","¿Ache shono shai jamaya poaje, ojjaña apoa poajeꞌyo? Dejja cuanaja ba jjima; esohuidojojji cuanaja ba jjima peaꞌai; ecuea ehuohuijji pojjeama. Ecue Chiija eba ojaye nei. Ohuaye nei huohui cajeꞌyo ojjaña apoa epoꞌyojji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Yahuajo nei nei dejja Noe bajjani nequia poa. Noe enequiahuajo ojjaña cuana quea mimishi poa. Quijje eya ojjañaja Edoe Mese poe oꞌoyajo, ojjaña cuana quea mimishi poaje oꞌoya, yahuajo nei nei jayojjaya poaje oꞌoya. ");
INSERT INTO eseNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yahuajo ojjaña meshi ohua jjimahuajo jamatii dejja cuana ijjiaꞌijjia ania poa. Ishiꞌishi nequia poa peaꞌai. Jjahuanaqui nequia poa. Jamaya poanaje Noe bishe ai yasijje dobiqui jjimahuajo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ona ojjaña jjashahuabaqui jjima anijo ena quea quemo poa. Jjayehuequia poa; johui oquea poa; huiꞌi caꞌya poa. Jamaya poaje oꞌoya eya ojjañaja Edoe Mese epoe oꞌoya cuahuajo: jjashahuabaquije cuana jama baꞌa: “Jamatii ecuana quea pame nequi”. Ojjañaja ba jjima meshi ojjaña tii chamaꞌyo tii poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Eꞌe, e poe oꞌoyajo beca dejja nequije quejo. Oe dojosohuaqui cajeꞌyo; pea jea canajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Beca epona quecuapasha pashaqui, oe dojosohuaqui cajeꞌyo; pea jea canajeꞌyo, Eyacuiñajjiya —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","¡Jamajjeya jjashahuabaqui tiitii anicue! Ache pojjajo Emeshi Meseja epoe oꞌoyajji miquea ebajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jiquio jama poaje baꞌa: Equi mese siipojji ache shono poeje poso jjabaquiani. Ojaya eba jojjemo ohuaya ishoa caꞌanime, equi jaahuanajjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eya miquianajaya Edoe Mese ache pojjajo miquiana que poeje oꞌoya ebajo ese. Jamajjeya ¡jjaꞌishoaꞌajjaqui anicue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Ecuea esohui shajjaꞌajjacue echacomeejji cuanajo jama baꞌa: Equi ai meseya poqui jjimahuaa echacomeejji iyaa canaje. Huoojea canaje: “¡Ecuea equi cuiñacue, miyaya! ¡Ecuea pea echacojji cuana oe bobiacue peaꞌai! Quijje eya poeje oꞌoya”. ");
INSERT INTO eseNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","—Equi mese poeꞌyo majje ojjaña quea pame nee ba cañaꞌya poa; quea bihui nee poñaꞌya poa. Jamajjeya echacomeejji quea bihui nee poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jamajoya equi meseya echacomeejji quea pame huoojea cajeꞌyo ojjaña ojaya aquiana cuiñaa. ");
INSERT INTO eseNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pea echacomeejji siipojji ca ca jjashahuaba taiquiani jama baꞌa: “Equi mese poquinaje quea huesha nee. Quijje nei nei poejeꞌyo”. ");
INSERT INTO eseNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Quea tecueya jjejojo ohuaya echacojji cuana cuia cani. Pea cuana nijje ishiꞌishiani, huooani. Apoa pojjeama nequi. ");
INSERT INTO eseNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Equi mese ache pojjajo epoejeꞌyo poso acani. Jamajjeya equi mese quehua poejeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ojaya equi cuiñajji poani ehuoo jaa bañaꞌyo majje tecuea cañajeꞌyo. Jeacuayajea cañajeꞌyo ojjaña quea mimishi poani nijje. Jomajo quea nee nee poajeꞌyo tii tii; eseꞌ ijjiayaijea cajeꞌyo quea neejo —Jesosa poanaje—. Jiquio ecua equi meseya ojaya equi cuiñajji shajjamaꞌ tecueajea majje jeacuayajea cañaꞌyonaje jayojja jamaya eyaya ajeꞌyo ojjaña ejo ishoaꞌajja, poe oꞌoya majje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—¡Pea esohui shajjaꞌajjacue Eyacuiñajji ojjañaja Emeshi Mese oe nei poajejo! Jiquio jayojja jama poaje baꞌa: Epona shoꞌi ahuemaꞌani ome miji peaꞌai huisome, 10 poa. Ma jjahueaquiequi baa cuaquijiji dojo canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Me oejje epona jjashahuabaquinaje. Pea me oejje jjashahuabaqui jjima. ");
INSERT INTO eseNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Joya jjashahuabaqui jjimaa cuaquijiji dojo canaje; jamatii esei dojo jjima ejijijji, de. ");
INSERT INTO eseNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Peaa jjashahuabaqui majje cuaquijiji dojo canaje eseijji. Tahuoojo dojo canaje peaꞌai ejijijji. ");
INSERT INTO eseNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","—Epona shoꞌi cuana quea cojja jee mano po majje cahuinaje. Shacuimaꞌ nequi mecashono poeyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jamajjeya mecashono pea equi yasijje poeꞌyo majje taaanaje; “Shacuimaꞌ nequi aje poeꞌyonaje. ¡Cuaꞌa, baquicue!” ");
INSERT INTO eseNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Taaaje shajjaꞌajja majje ojjaña epona shoꞌi cuana shequinaje. Ejijijji hui jeacuaya canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Epona shoꞌi jjashahuabaqui jjima cuaa ma ejjashahuabaqui cuana huohuiꞌajja canaje jama baꞌa: “¡Esei mo quiacue! Esei ecuanaja oe poanaje. Cuaquijiji ecuanaja jijiꞌyo ajja”. ");
INSERT INTO eseNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Epona shoꞌi ojaya ejjashahuabaquiꞌyo cuaa sajaꞌa canaje: “Miquea esei chamaꞌ eshojji. Ecuea ca ca jiquio che oe pojji. ¡Poquicue miya ma esei quia caqui yasijje; jocuama jjequicue!” ");
INSERT INTO eseNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Jocuama o poquiahuajo, shacuimaꞌ nequi poeyanaje. Ojjaña dobiquiꞌyonaje, joya apoa epo, o jjahueaquijji equi yasijje. Dobiqui majje esecue caꞌa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Joya esei jjequiya poquiya cuana poeꞌyo majje esecue ecaꞌa nequi ba cañaꞌyonaje. Taaa aninaje: “¡Che esecue caꞌapejocue!” ");
INSERT INTO eseNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—Shacuimaa eyiye dojjojo nequiya sajaꞌa canaje: “Chojja, ecuea miya ba jjima” acanaje. Jamaya poanaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—Eꞌe —Jesosa poanaje oja epeejji cuana nijje—, ¡jamajjeya jjaꞌishoaꞌajjaqui ani tiitiicue peaꞌai! Ecuea epoe oꞌoyajji miquea ebajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesosaa pea esohui eba meesahuajji huohui canaje: —Jjeya eyaya pea esohui huohuije, eya ojjañaja Emeshi Mese poe oꞌoyajo —Jesosa poanaje—. Jama poaje baꞌa: Oe dejjaa, emeshi meseya quea huesha poqui jjimahuajo iyaa canaje ojaya echacojji cuana, ojjaña ojaya aquiana jaahuana meejji. ");
INSERT INTO eseNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Majoya ohuaya oe echacojji quea jjashahuabaqui jaꞌa huasijje esodojjo me oejje, 5 huisome quea nahue nee nee quia canaje aquiana jjeshejji, quea huiso bejjo chichajji. Pea echacojji quea jjashahuabaqui jaꞌa pishana huasijje beca esodojjo quea nahue nee nee quia canaje aquiana jjeshejji, quea huiso bejjo chichajji. Pea echacojji beshahua nei jjashahuabaqui ajja huasijje oe esodojjo quea nahue nee nee quia canaje bejjo chichajji nisho. Esodojjo quia majje emeshi mese poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Echacojji quea jjashahuabaqui jaꞌaa ojaya esodojjo me oejje huisome quea nahue quia canaje aquiana jjeshejji. Majoya chicha canaje ome peaꞌai huisome. ");
INSERT INTO eseNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Oya jayojjaya pea echacojjiya ojaya beca esodojjo quea nahue quia canaje aquiana jjeshejji. Majoya ohuaya chicha canaje ebeca pee peaꞌai huisome esodojjo. ");
INSERT INTO eseNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pea echacojji aje oe jjashahuabaqui ajja poanaje. Ojaya emeshi meseja esodojjo oe nei quehuajje nei ohua canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Quijje nei emeshi mese poe oꞌoyanaje ojaya echacojji cuana huasijje. Jjashahuabaquinaje jama baꞌa: “¿Ae shai poani soꞌo echacojji cuana ecuea esodojjojo?” Jamajjeya echacojji cuana iyaa majje huohuiꞌajja canaje: “¿Ache huiso esodojjo yani soꞌo jjeya?” ");
INSERT INTO eseNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","—Echacojji esodojjo me oejje huisome jaahuanajji ojaya emeshi mese nijje jama poanaje baꞌa: “Yahuajo nei miyaya me oejje esodojjo quiaꞌyonaje eya. Maꞌaje miquea. Pea me oejje huisomeya miquea poanaje. Maꞌaje pea me oejje ecue chicha” poanaje echacojji. ");
INSERT INTO eseNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Ojaya emeshi mese onijje quea bihui nee poanaje jama baꞌa: “Eꞌe de, miya echacojji quea pame nee. Yahuajo eyaya miya quianaje me oejje esodojjo. Miyaya maya quea pame nee chichanaje. Jamajjeya jjeya eyaya miya ecuea aquiana quea huiso jaahuana meejeꞌyo. Cuaꞌa, ¡enijje anicue quea bihui nee!” emeshi mese poanaje quea bei nee. ");
INSERT INTO eseNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Majoya pea echacojji poeyanaje, ma beca esodojjo yahuajo quia canaje. Ma echacojji jama poanaje baꞌa: “Emeshi mese, yahuajo nei miquea esodojjo becanejjijji peaꞌai quiaꞌyonaje eya. Maꞌaje miquea beca esodojjo. Pea esodojjo becanejjijji peaꞌai ecue chicha yenaje. Maꞌaje ecue chicha esodojjo peaꞌai” echacojji poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Emeshi mese onijje quea bei miminaje jama baꞌa: “Eꞌe, de, miya echacojji quea pame nee. Yahuajo eyaya miya quianaje esodojjo becanejjijji peaꞌai. Miyaya pea chichanaje quea pame nee. Jamajjeya jjeya eyaya miya ecuea aquiana quea huiso jaahuana meejeꞌyo. Cuaꞌa, ¡enijje anicue quea bihui nee!” emeshi mese poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Majoya pea echacojji poeyanaje, ma esodojjo oe nei quia canaje. Emeshi mese huohui canaje ohuaya jama baꞌa: “Emeshi mese, ecuea eba miya quenequene cuajiani. Miyaya miquea echacojji chaco meeaña sosemaꞌ. Quea dejja taija jjejojo miquea aquiana quea huiso yani” jama posoya acanaje echacojjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Jamajjeya eya quea mete poanaje. Miquea esodojjo emoquehua aninaje onaa esii ca poani jjejojo. Maꞌaje miquea bejjo, ma miyaya quianaje huisome tiiya” echacojji poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—Ojaya emeshi meseya oya acanaje: “Miya echacojji quea mimishi, quea huea. Miya quea jjashahuabaqui tai poanaje jama baꞌa: —Ecuea echaco sosemaꞌ poanaje. Ecuea emeshi mese quea dejja tai. Jamajjeya quea huiso ojaya aquiana yani —miya poanaje. Siajje miya poani. Miquea ejjashahuaba taiquijji jayojja jama eyaya miya aje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Apiojji acuae miyaya ecuea ejjeshejji mi quianaje bejjo jaajji yasijje? Quijje pishana ohuaya eya quea huiso quia caꞌyo queaye”. ");
INSERT INTO eseNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Emeshi mese ma echacojji nijje quea tecue poanijo pea cuana huoojea canaje jama baꞌa: “Echacojji quea hueaa jjejojo ecuea esodojjo mi chicha canaje. ¡Maya esodojjo oe nei jjeshe majje quiaꞌyocue pea echacojji hueaꞌama huasijje, maya ecuea esodojjo me oejje ecue quia poanaje yasijje quiacue! ");
INSERT INTO eseNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eꞌe, joya hueaꞌama poani aquiana cuana quia caje cuaa. Dejja aemaꞌ quea hueaja aquiana ojjaña jjesheꞌyo majje dojo cajeꞌyo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jiquio echacojji cajaa ajeajeꞌyo; quea huea coma. Enijje oya enequijji pojjeama. Huoojeacuayajeajeꞌyo. Oya quea yeno nee nee poajeꞌyo. Quea nee nee peaꞌai poajeꞌyo” emeshi mese poanaje —jamaya Jesosaa acanaje. Eꞌe, jiquio Jesosaja ejjashahuabaquiꞌyojji jama baꞌa: Poe oꞌoya majje Jesosaa ojaya epeejji quea jjashahuabaqui jaꞌa quea pame baꞌe mee cajeꞌyo onijje eyajo. Onijje ona huoojeaꞌyojji po mee cajeꞌyo. Pea echacojji quea huea ba majje ca ca cajaa acajeꞌyo. Quea nee nee poajeꞌyo oya cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesosaa huohui canaje peaꞌai: —Eya poe oꞌoya majje quea caꞌa poajeꞌyo. Ojjaña huoojeaꞌyojji poajeꞌyo. Ojjaña esohuidojojji cuana enijje poejeꞌyo. Majoya eya baꞌesohuaquiꞌyo majje eyahuasijje, jocuama eya nequijeꞌyo, Emeshi Mese nei. ");
INSERT INTO eseNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ojjaña cuana e que jjachichaqui meejeꞌyo. Majoya eyaya ñajjajja cuiñajji jayojja jama aje jama baꞌa: Ñajjajja cuiñajjiya ñajjajja cuana, chivo cuana nequiashiña cani. ");
INSERT INTO eseNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ñajjajja oo pana nequiashiña cani ebianeijje. Chivo ca ca huapa nequia acani, shanijje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ñajjajja cuiñajji jayojja jama eyaya, ojjañaja Emeshi Meseya ojjaña dejja cuana nequishiñajeꞌyo. Ecuea epeejji quea pame nee ebianeijje nequiajeꞌyo. Oya cuana ajeꞌyo jama baꞌa: “Miquianaya ecue Chiija bacua cuana eꞌe jojo nei poanaje, ojaya huapa pojjeama. Jamajjeya onijje nequi tiitiijeꞌyo. Eyacuiñajji jamaya jjashahuabaquiꞌya poa yahuajo nei nei, meshi pana jjimahuajo. ");
INSERT INTO eseNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jamaya poajeꞌyo jjeya miquianajo, miya quea pame nee nee poanajejo. Eꞌe, yahuajo eya quea shoe poajo, eya bobi quianaje miyaya. Eya quea naba taja poajo, ena quianaje miyaya. Eya miquianajaya ba jjima poanaje. Jamatii miquea equi yasijje dobiqui meenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Eya daquimaꞌ poajo, miquianaaya daqui huosho meenaje. E emanojaajo, ejeanobiajaajo peaꞌai, miquianaya poeyanaje enijje jjapeequiya” jamaya eyaya ajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Majoya dejja pame cuaa eya huohuiꞌajja caje jama baꞌa: “¿Ache shono acuae ecuaaya miya bobianaje, miya quea shoe poanajejo? ¿Ache shono ena quianaje miya quea naba taja poanajejo? ");
INSERT INTO eseNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Aꞌa miya ecuanaja equi yasijje dobi meenaje? ¿Aꞌa daqui huosho meenaje miya daquimajo? ¿Ache shono shai ecuaaya jamaya anaje? ");
INSERT INTO eseNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mi emanojaajo, ejeanobiajaajo peaꞌai, ¿aꞌa ecuana mi que poeyanaje? ¿Ache shono acuae jja jama ecuaaya mi anaje soꞌo?” Jamaya dejja pame cuaa quijje huohuiꞌajja caje eya eyajo. ");
INSERT INTO eseNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Jamajjeya eyaya, Emeshi Mese neiya sajaꞌajeꞌyo quijje eyajo jama baꞌa: “Miyaya ecuea huapa pojjeama aemaꞌ yahuajo jaahuananajejo, eya jaahuananaje. Jamajjeya ecuea eba miquianaya ecuea epeejji eꞌe jojo nei poanaje. Ecuea ejjashahuabaquiꞌyojji jayojja jama ca ca miyaya aꞌyonaje”. ");
INSERT INTO eseNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Mayoja eyaya, Emeshi Mese neiya dejja tai cuana shanijje nequi tecueajeꞌyo jama baꞌa: “¡Poquicue miya! Cajaaꞌyo ca mi ca ecua. Edosiquiana etii Satanasa, eshahua cuana peaꞌai cuaqui yasijje poquijeꞌyo. Miya cuana peaꞌai anijeꞌyo cuaquijo tii. ");
INSERT INTO eseNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yahuajo eya quea shoe, bobia jjima poanaje miquea. Eya quea naba taja, ena quia jjima poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Eya miquea eba pojjeama, miquea equi yasijje dobi mee jjima poanaje. Eya daquimaꞌ, daqui huosho mee jjima poanaje miquea. E emanojaajo, ejeanobiajaajo peaꞌai miya poe jjima poanaje e jaahuanaa” jamaya eyaya aje dejja mimishi cuana —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Majoya dejja mimishi cuaa eya huohuiꞌajja caje jama baꞌa: “¿Ache shono acuae miya bobia jjima apoa? ¿Ena cuana quia jjima apoa? ¿Aꞌa ecuanaya miya ecuanaja equi yasijje dobi mee jjima apoa? ¿Aꞌa daquimajo, ecuanaya daqui huosho mee jjima apoa? ¿Aꞌa mi emanojaajo, ejeanobiajaajo peaꞌai, aꞌa miya ecuanaja jaahuana jjima apoa? ¿Ache shono shai, de?” dejja mimishi cuaa huohuiꞌajja caje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Majoya eyaya, Emeshi Mese neiya sajaꞌajeꞌyo jama baꞌa: “Ecuea huapa pojjeama cuanajje jaahuana jjima. Jamajjeya miquianaaya eya cajaa aꞌyonaje peaꞌai”. ");
INSERT INTO eseNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Majoya eyaya, Emeshi Mese neiya dejja quea mimishi cuana quea huesha nee huoojeajeꞌyo cuaqui yasijje edobiquiꞌyojji. Quea nee nee po tiitiijeꞌyo. Dejja pame cuana ebianeijje nequi ca ca baꞌe tiitii meejeꞌyo Eyacuiñajji nijje —jamaya huohui canaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Majoya Jesosaa o shajjaꞌajjajji cuana jjabahuejjaqui mee canaje. Pea esohui huohui canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Quijje pishana, becanejjijji peaꞌai cahuime po majje, Jodio cuana jjashahuabaquije oꞌoya etiiquianaja bacua cuana yahuajo Ejitojo manoꞌyo jjima poajo. Jamajjeya ojee ijjiaꞌijjiaje oꞌoya quea bei nee. Eꞌe, yahuajo nei nei Ejito meshijo ani Jodioja ebacua ejja cuiaꞌyo jjima aca poa esohuidojojjiya. Ma shejo ijjia jjimahuajo Jodio cuaa eya iña majje dejja quea mase yasijje quia cajeꞌyo equecuaꞌyojji. Acui ecueataꞌapeejo me caca majje baꞌehuanasohuajea cajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Majoya Eyacuiñajji nijje emimijji etii cuana, Jodio dejja jaahuanajji cuana peaꞌai ojee jjachichaquinaje Eyacuiñajji nijje emimijji etiija equi aijo, Caipa bajjanija equijo. ");
INSERT INTO eseNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Caipa jjashahuaba taiquinaje pea cuana huoojeajji Jesosa iñajji, quijje equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jodio etii cuana ojee miminaje jama baꞌa: —¡Jesosa quehua neijje iñacue ojjaña Jodio cuana jjachichaqui jjimahuajo, ojee ijjiaꞌijjia jjimahuajo! ¡Oya iñacue jjeyahua nei, de! Quijje pishana ojjaña ojee ijjiaꞌijjia anijo, ecuanajaya Jesosa eꞌiñajji pojjeama. Chojja. Ojjaña Jodio cuana quea quene nee nee ecuana nijje po chanaꞌ, Jesosa onajaya quea nahue nee equecua meeꞌyojji. Quea shajjaquijjo po chanaꞌ peaꞌai —jamaya acanaje Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesosa Betaniajo aninaje dejja Simoni bajjanija equijo. Yahuajo nei Simoni quea mano nee nee batata epoꞌyo poa, ma dejja cuaa jjajeaqui meeꞌyo jjima acani. Jesosaa oya yahuajo huaquia mee caꞌyonaje, jjajeaqui mee caꞌyonaje. Simonija equijo Jesosa eꞌanioque aninaje. Ijjiaꞌijjia aninaje bobi ijjiajji pejjejo. ");
INSERT INTO eseNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesosa ijjiaꞌijjia anijo, oe epona poeꞌyonaje o que. Ohuaya tahuoo quea nahue neejo shiyeshiye ye canaje Jesosa huojja shajji. Huojja sha canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ba majje Jesosa shajjaꞌajjajji cuaa epona tecuea canaje: —¿Apiojji acuae miyaya shiyeshiyeya shaña soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¿Sha jjima yajjijo poso ca mi ca oe shiyeshiye dojo meenaje esodojjo quea huiso sosejje? Eꞌe, aemaꞌ cuana huasijje esodojjo equiajji poso —Jesosa shajjaꞌajjajji cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesosaa oya cuana shajjaꞌajja majje huohui canaje: —¿Apiojji acuaeya epona tecueaña soꞌo? Eꞌe, eya ohuaya huojja sha canaje. Jamaya quea pame nee. ");
INSERT INTO eseNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aemaꞌ cuana minijje po tiitiijeꞌyo. ¡Oya cuana jaahuanaꞌyocue quijje peaꞌai! Eya ca ca nequi tiitii ajja minijje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Eya huojja sha cajo epona jjashahuabaquinaje jama baꞌa: “Jesosa manoꞌyo jjimahuajo eyaya oya huojja shaña shiyeshiyeya, onaja mojea jjimahua shaña” poanaje epona —Jesosaa acanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jamajjeya quijje ojjaña meshijo ecuea esohui huohui caje. Jiquio eponajo huohui caje peaꞌai jama baꞌa: “Oe eponaa Jesosa huojja sha ca poa shiyeshiyeya, quea jeajojo”. Jiquio epona pajeaꞌyo ajja tii tii, eꞌe jojo nei —jamaya Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yaninaje quea huiso Jesosa shajjaꞌajjajji cuana, 12. Oe nei Jodasa Isicaniote bajjani poquinaje Eyacuiñajji nijje emimijji etii cuana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Miminaje jama baꞌa: —Eyaya miya Jesosa iña mee sahuaje. ¿Ache sose huiso acuae mo ya oe sosequiajeꞌyo soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Onaaya sajaꞌa canaje jama baꞌa: —Quea huiso, 30 esodojjo quea nahue nee sosequiajeꞌyo miya. Jamajjeya Jodasa jjashahuaba neineiqui aninaje achajja iña meeme aje soꞌo cuana: —Cabaꞌajjaquisahua —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jodio cuana quea bihui ojee ijjiaꞌijjianaje yohua shejo baꞌa esohuidojojjija yahuajo nei etiiquianaja bacua cuana cuiaꞌyo jjima ñajjajja naꞌ esecuejo ecuiapepa ba majje shejo. Pahui quea caꞌa eshejjee meejji chamaꞌ ijjia ca poa. Ebionei epojja eꞌijjiaꞌijjiajjijo, Jesosa que poe majje o shajjaꞌajjajji cuaa huohuiꞌajja canaje jama baꞌa: —Jesosa, ¿ache equijo acuae seya pahui caꞌa ijjiaje soꞌo? ¡Ecuana huoojeacue aquiana iyajea, miquiana ishoajji! ");
INSERT INTO eseNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesosaa huohui canaje jama baꞌa: —¡Poquicue miya cuiñajji yasijje! ¡Jomajo ecuea epeejji baquicue! Onijje mimicue jama baꞌa: “Ecuana sohui huohuijji jama poanaje baꞌa: —E manoꞌyajo aje apoa poaje. Miquea equijo eyaya e shajjaꞌajjajji cuana nijjeya pahui caꞌa ijjiajeꞌyo, esohuidojojjiya etiiquianaja bacua ejja cuana cuiaꞌyo jjima poa shejo” acue —Jesosaa huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jamajjeya o shajjaꞌajjajji cuana ojaya ehuoojeaꞌyo jayojjaya jama poanaje. Bobi iyajea canaje pahui caꞌa ijjiajji. ");
INSERT INTO eseNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Majoya sinecua neijo Jesosa o shajjaꞌajjajji cuana nijje anioquenaje bobi ijjiajji pejjejo ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ojee ijjiaꞌijjiaꞌanijo Jesosa jama poanaje baꞌa: —Eꞌe jojo nei jiquiojo ani oe dejja poquije ona jjequiya e iñaꞌyojji. Ohuaya eya huohui caje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eshajjaꞌajjajji cuana quea yeno nee nee poanaje. Pea mimiajo pea poanaje jama baꞌa: —Ecuea Emeshi Mese, eya ca ca o jayojja pojjeama, eꞌe jojo nei. Jamaya ojjaña miminaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Majoya Jesosa onijje miminaje jama baꞌa: —Oe dejjaa e shajjaꞌajjajjiya joya enijje pahui shapeshi poꞌaniya eya onaya cuana iña mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Eꞌe, yahuajo nei Eyacuiñajjija esohui tehuejji cuaa esohui tehue ca poa jama baꞌa: “Quijje oe dejjaa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji onaya cuana iña meesahua cajeꞌyo equecuaꞌyojji”. Jamajjeya ma dejja quijje quea yeno poaje. Jjashahuabaquije jama baꞌa: “¿Apiojji shai eya ecue naeya mejo ca poa? Eya ca ca nequi sa po ajja. Ecuea ejjashahuaba taiquijjijo manoꞌyo sa poani” oya poaje. Quijje oya quea nee nee po tiitiijeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Majoya Jodasa Jesosa nijje miminaje jama baꞌa: —Emeshi Mese, eya ca ca o jayojja pojjeama. Eyaya miya onaya eꞌiña meesahuajji pojjeama —poanaje. Jesosa onijje miminaje: —Eꞌe, Jodasa, miya jama quea tai poaje, eꞌe jojo nei —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Majoya ojee ijjiaꞌijjiaꞌanijo tii Jesosaa pahui caꞌa jjeshe canaje. Eyacuiñajji bihuia majje, pahui mijisisi majje quia canaje o shajjaꞌajjajji cuana. Jama huohuime acanaje Jesosaa baꞌa: —¡Ijjiacue! Jiquio ecuea eyami —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pahui ijjia majje caneco jjeshe canaje, Jesosaa. Eyacuiñajji bihuia majje quia canaje ojjaña o shajjaꞌajjajji cuana. —¡Ishicue! Jiquio ecuea enaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ecuea enaꞌ cuayaquiajo eya manojeꞌyo. Jamajoya eyaya Eyacuiñajjija esohui eyacua jayojjaya aje. Eꞌe, ojjaña ecuea epeejjija mimishi cuana cuijeajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jjeya eyaya jiquio jjonojjajja na, uva na eꞌishi oꞌoyajji pojjeama miquiana nijje; eya manojeꞌyo. Quijje nei poe oꞌoya majje eyaya jiquio ishije oꞌoya miquiana nijje. Eꞌe, eya poe oꞌoyajo ecue Chiiya eya ojjaña huoojeaꞌyojji po mee cajeꞌyo. Ojjañaa eya shajjaꞌajja cajeꞌyo —jamaya Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Majoya ojee sohuicuaya majje poquinaje eyiyo huasijje Onimo yiye yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Majoya Jesosa o shajjaꞌajjajji cuana nijje miminaje jama baꞌa: —Jiquio mecajje ojjaña miquianaya enijje jjapeequi pajeajeꞌyo. Eꞌe, yahuajo Eyacuiñajjija esohui tehuejji cuaa tehue ca poa ejo: Eya ñajjajja cuiñajji jayojja jama poaje. E manoꞌyajo ecuea epeejji cuana ñajjajja cuana jayojja jama poaje; jjajeaajajeaquinanajeꞌyo. Etehueꞌyo yahuajo nei nei jama poa baꞌa: “Quijje eyaya ñajjajja cuiñajji jaahuana neinei ajja. Jamajjeya onaaya oya cuia cajeꞌyo. Ñajjajja cuiñajji chamajo, ñajjajja cuana jjajeaajajeaquinanajeꞌyo”. Jamaya aca poa yahuajo nei nei —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jamatii, shequi oꞌoya majje eya poquije Janinea meshi yasijje. Jomajo aje mi poeyajo ishoañaquije —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Penohua Jesosa jama acanaje baꞌa: —Eꞌe pojjaꞌa pea cuana minijje jjapee tiitiiquiꞌyo ajja. Eya ca ca pea jayojja jama pojjeama. Eya jjapee tiitiiquijeꞌyo minijje —Peno poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesosaa Peno jama acanaje baꞌa: —Eyaya eꞌe jojo nei miya huohuiaña Peno, jiquio mecajje tii cachina yahue pea beca peejjima taaame po jjimahuajo, pea beca peejjima huohuiꞌajjame amajje miya ejo poaje jama baꞌa: “Chojja, ¡ecuea Jesosa ba jjima nei nei!” miyaya sajaꞌame aje quea meteya jjejojo —Jesosaa Peno acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Chojja, Jesosa —Peno poanaje—. Eꞌe pojjaꞌa eya minijje jjapeequianijo, pea cuaa eya cuiajea cajeꞌyo. Jamatii ¡ecuea ca mi ca epajeaꞌyojji pojjeama! Oya jayojja pea cuaa jama acanaje peaꞌai baꞌa: —Eꞌe Jesosa, ¡ecuanajaya ca mi ca epajeaꞌyojji pojjeama tii! ");
INSERT INTO eseNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Majoya Jesosa o shajjaꞌajjajji cuana nijje Jetesemani que yasijje poquinaje. Jesosa jama poanaje baꞌa: —¡Anioquecue jiquiojo tii! Jocuama eya poquije ecue Chii nijje mimiya. ");
INSERT INTO eseNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesosaa Peno, Huani, Satiaco peaꞌai dojo canaje jocuama, ma Semeneoja bacua ejja cuana bajjani Huani, Satiaco peaꞌai. Jesosa jjashahuabaquinaje quea yeno nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jamajjeya onijje jama poanaje baꞌa: —Eya quea yeno nee nee, emano caꞌyojji jayojja. ¡Anioquecue enijje; aꞌa cahuijji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesosa cuama pishana ani poqui majje ecuiꞌoshajjajo nequinaje. Oja Chii nijje miminaje jama baꞌa: —Ecue Chii, miquea ejjashahuabaquiꞌyojji jayojja jama ajeꞌyo eyaya. Miyaya eya huoojeanaje dejjaja mimishi cuanajo manoꞌyohua. Quea camaja nee nee ejo. ¿Aꞌa miyaya che onaaya eya quecua meeꞌyo jjima aje soꞌo? ¿Aꞌa onaaya eya iña meeꞌyo jjima ajeꞌyo? Jamatii ¡miquea ejjashahuabaquiꞌyojji jayojja jama acue! ¡Ecuea ejjashahuabaquiꞌyojji jayojja jama aꞌa ajji! —Jesosa jamaya poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Majoya oya poqui oꞌoyanaje o shajjaꞌajjajji cuana que. Ba cañaquiꞌyonaje cahuijaa. Tecueꞌama Peno nijje miminaje jama baꞌa: —¿Aꞌa mi cahuijaa? ¿Aꞌa che enijje cahui jjima nequi jjima soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","¡Aꞌa cahuijji! ¡Eyacuiñajji nijje mimi majamajacue! Jamajoya pea cuaa miya quea mimishi epo meeꞌyojji pojjeama. Eꞌe, miquianaya enijje jjapeequi sa poani eꞌe jojo nei. Jamatii miya caꞌaꞌama; quea mimishi poaje oꞌoya pojjaꞌa —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Majoya Jesosa poqui oꞌoyanaje jocuama pishana oja Chii nijje mimi oꞌoyaa. Mimi oꞌoyanaje jama baꞌa: —Ecue Chii, eya ojjañaja mimishijo manoꞌyo ajjajo, ¿aꞌa onajaya mimishi ecuijeaꞌyojji pojjeama poajeꞌyo? Jamajjeya ¡miquea ejjashahuabaquiꞌyojji jayojja jama acue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oja Chii nijje mimiꞌyo majje Jesosa poqui oꞌoyanaje o shajjaꞌajjajji cuana que. Oya cuana quea cojja jee mano poanaje; cahui oꞌoyanaje. Jamatii Jesosaa onijje mimi jjima; shequi meeꞌyo jjima acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ona jeana oꞌoya majje jocuama pishana poqui oꞌoyanaje Jesosa, oja Chii nijje mimi oꞌoyaa. Oya jayojja mimi oꞌoyame poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mimi oꞌoya majje poe oꞌoyanaje o shajjaꞌajjajji cuana que. Onijje mimi oꞌoyanaje: —¿Aꞌa mi cahuijaa tii? ¿Jomishocajaa pojjaꞌa ca mi ca oe? Jjeyahua nei dejjaa eya onaya iña meesahua cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Cuaꞌa, jjeya nei ecuea epeejji nisho poejeꞌyo! Joya aje poeje baꞌa. ");
INSERT INTO eseNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesosa mimianijo tii, Jodasa o que poeyanaje, ma eshajjaꞌajjajji cuana sohuihuohui poequi yasijje. Oya aje oe Jesosaja epeejji peaꞌai poanaje; pea 11 nijje nequinaje tii. Quea huiso nee nee dejja nijje Jodasa poeyanaje; yohuajji poeyanaje acuijji, baajji, mejejji peaꞌai poeyanaje. Jodio etii cuaa, Eyacuiñajji nijje emimijji etiiya peaꞌai ojjaña huoojea canaje Jesosa iñaa. ");
INSERT INTO eseNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jodasaa, Jesosa eꞌiña meejjiya yahuajo jama huohuime aca poa baꞌa: —¡Bacue oe! Eyaya oe dejja ba majje cuiapashi nishoje. ¡Majoya oe miquianaaya iñacue! ");
INSERT INTO eseNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jamajjeya Jodasa Jesosa que jjanequichipiquinaje: —¡Aꞌa mi ecuea Emeshi Mese nei jiquio! —amajje cuiapashi nisho canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesosaa acanaje: —Ecuea epeejji Jodasa, ¿ajeo ami poeyanaje? —Jesosa poanaje. Pea dejja cuaa ba majje, Jesosa que poe majje iña canaje edojojji. ");
INSERT INTO eseNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesosa iña cajo, oja epeejjiya onijje nequiya baa iña canaje. Onaja sapa jajapojojeajji nisho shajja jajasejja canaje, Eyacuiñajji nijje emimijji etiija echacojji poanija eshajja. ");
INSERT INTO eseNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—Chojja. ¡Aꞌa jja oe jajajji! —Jesosaa oya huohui canaje—. ¡Baa oe ejee yasijje nequianobiaꞌyocue! Ojjaña jjajajaquiani manojeꞌyo yacua caꞌyajje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Aꞌa miquea eba pojjeama eyaya ecue Chii ehuohui jojjemo ohuaya esohuidojojji ache huiso nei nei huoojea came jjeyahua nei, e jaahuanaa? ");
INSERT INTO eseNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jamatii eya jama po ajja. Eꞌe, yahuajo nei Eyacuiñajjija esohui etehueꞌyo jama tehueme ejo aca poa baꞌa: “Onaaya iña mee majje dojo caje emano meeꞌyojji”. Jamaya ejo yahuajo nei tehue ca poa. Jamaya eya acajeꞌyo cuaa jjeya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jamajjeya Jesosaa ojjaña dejja ejjachichaquiꞌyo nequi yasijje huohui canaje: —¿Apiojji miya poeyanaje baajji, acuijji, mejejji peaꞌai e iñaa? ¿Aꞌa cuae jja iña siipojji soꞌo? Ojjaña pojjajo eya ojjaña nijje esohui huohuijji po nequinaje Eyacuiñajjija equijo. Jamatii eya miquianajaya iña jjima poanaje. ¿Apiojji miquianaya mecajje poeyanaje e iñaa? ");
INSERT INTO eseNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jamatii jamaya nequiana poani. Miquianaaya ca mi ca oe Eyacuiñajjija esohui huohuijjija etehueꞌyo yahuajo nei nei miquianajo jayojja jama quea tai aña. Majoya o shajjaꞌajjajji cuana cuajicuajinananaje; Jesosa jeajea canananaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jamajjeya joya Jesosa iñajji cuaa oya dojo canaje Eyacuiñajji nijje emimijji etiija equi yasijje, Caipaja equi yasijje. Jocuama Jodio cuana jjachichaquinaje, Jodio etii cuana, Moisesija etehueꞌyo huohuijji poani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Penohua ca ca equijje aca poquinaje Jesosa onaa dojo caje. Caipaja equi yasijje Peno nequiñaquinaje. Dobiquinaje epeeyi nequi yasijje, sohuinana cuana nijje anioquenaje ae onaa Jesosa acaje ebajji. ");
INSERT INTO eseNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eyacuiñajji nijje emimijji etii, ojjaña Jodio etii cuana, Jodio esohui huohuijji poani peaꞌaiya ojee mimimiminaje Jesosajo, ojjaña ejjachichaqui nequiya o quecuaꞌyo sa acani. Jamajjeya saꞌajja canaje dejja cuana Jesosa huohuijji nisho, Shomano emeshi mese Pinato bajjani yasijje dojo majje Jesosa huohuijji nisho: —Jesosa ca ca jama acanaje baꞌa —siajje yajji. ");
INSERT INTO eseNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Quea huiso dejjaa Jesosa siajje acanaje. Jamatii peaa siajjeꞌa, peaa siajjeꞌa acanaje Jesosajo. Chamaꞌ beca oya jayojja mimime epojji Jesosa mano meeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Quijje yejje nei beca dejja poeyanaje eꞌe jojo nei jayojja emimijji. Jama poanaje baꞌa: —Eyaya oya shajjaꞌajjanaje. Jama poanaje Jesosa baꞌa: “Eyaya Eyacuiñajjija equi jeabichajeajeꞌyo. Jeabichajeaꞌyo majje pea equi iyajeꞌyo pea beca peejjima cahuime”. ");
INSERT INTO eseNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ma shajjaꞌajja majje Eyacuiñajji nijje emimijji etiiya nequisohua majje Jesosa huohuiꞌajja canaje: —¿Aꞌa pa miya jama poanaje? ¿Jesosa, aꞌa acuaeya dejja cuana miyaya sajaꞌajeꞌyo soꞌo? Jamatii Jesosa jjamimisajaꞌaqui ajja poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jamajjeya Eyacuiñajji nijje emimijji etiiya huohui neinei canaje: —¡Eyacuiñajji eshe nequi tiiya eseya ba canijo, ecuana huohuicue eꞌe nei! ¿Aꞌa acuae miya Eyacuiñajjija Bacua Ejja nei, oja huoojeaꞌyo ojjaña jaahuanajji? ¡Huohuicue mo oe! ");
INSERT INTO eseNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jamajjeya Jesosaa huohui canaje: —Eꞌe, joya ecua miya mimiani jayojjaya eya. Cuanaya eyaya miya eꞌe nei huohuiaña: Quijje miyaya eya bajeꞌyo ecue Chii nijje ebianeijje ani. Oya quea caꞌa nee nee enequi tii tii. Eya miquianaaya baje peaꞌai poeje oꞌoya; bo biajje poejeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Shajjaꞌajja majje Jodio etii quea quene nee nee poanaje. Quea quene nee nee po majje ojaya daqui, oja huosho baꞌe daqui isajea canaje. Jodio dejjaa jamaya oja daqui isajea cani quea quene po majje. Ojjaña cuana huohui canaje jama baꞌa: —De, ¡pea dejja aꞌa iyaajji Jesosa huohuijji! Jamatii. ¡Oya Jesosa mimiqui Eyacuiñajjija Bacua Ejja miame! ¿Aꞌa acuae miquiaaya shajjaꞌajjanaje oja sohui? Jamajjeya ¿yajja acuae seya aje soꞌo, de, Jesosa? ");
INSERT INTO eseNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","—¡Oya oe manojea meeꞌyocue; quea tai ca esohui acanaje! —jamaya acanaje Jodio dejja cuaa, Jesosa Eyacuiñajjija Bacua Ejja pojjeama posojo. ");
INSERT INTO eseNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Majoya aje oe Jodio dejjaa Jesosa cojja cuichojea canaje. Ejjachichaqui nequiya cuia canaje peaꞌai emeya. ");
INSERT INTO eseNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Cuia majje huohuiꞌajja canaje: —¡Miya Eyacuiñajjija huoojea nei jjabaqui majje jja ca oe huohui pocue! ¿Aya acuae mi cuia canaje soꞌo? —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ojjaña cuaa napa caqui Penohua ba canaje Jesosa; esecuejo sohuinano pejjejo eꞌanioque aniya ba caꞌaninaje. Oe echacojjiya ahuemaꞌaniya Peno ba majje huohuiꞌajja canaje: —¡Miya ca jja mi ca oe Jesosa nijje aninaje Janinea meshijo! Eponaa huohui cajje ojjaña cuaa Peno bajea canaje. Jamajje Peno metenaje. Jama sajaꞌame acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—¡Chojja, ecuea oya ba jjima! ¿Ajeo acuae mi mimiani? —Peno siajje poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Majoya Peno epeeyijo nequi cuayaquinaje quea mete jjejojo. Pea epona echacojjiya Peno ba canaje esecuejo nequi. Ohuaya ojjaña dejja cuana huohui canaje: —Eꞌe jojo nei oya Jesosa nijje aninaje, ma Nasanenajo baꞌe nijje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—Chojja, ecuea oya ba jjima nei nei. Eyacuiñajjija eba eya eꞌe jojo nei mimiani —Penohua sajaꞌa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Quijje pishana beca cuana Peno que ojee nequi jjanequichipiquinaje. Jama poanaje baꞌa: —Eꞌe nei miya Jesosaja epeejji peaꞌai pea cuana nijje. Jamaya miquea emimi, pea Janinea meshijo baꞌe jayojja jama miya mimiani, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ojaya esohui shajjaꞌajja majje Peno quea mete nee nee poanaje; ona nijje mimijajinaje: —¡Siajje miya poani! Jiquio dejja ecuea ba jjima. Eya eꞌe jojo nei pojjeama poani jojjemo Eyacuiñajjiya eya mano mee caꞌyome —Peno poanaje. Jamatii Peno siajje poanaje. Peno jamaya poajo, cachina yahue taaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cachina taaajo Penohua shahuaba caꞌyonaje ma Jesosaa oma mecajje o jama acanaje jama baꞌa: —Peno, cachina yahue taaa jjimahuajo miyaya eya ba jjima nei nei nisho ajeꞌyo, ebeca pee peejjima huohuime ajeꞌyo —jamaya Jesosaa Peno acanaje. Jamajjeya jjashahuabaqui majje Peno quea yeno nee nee poanaje; pa neinei poquiꞌyonaje Jesosa ba jjima nisho epo jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mecajjeahua ojjaña Jodio etii cuana, Eyacuiñajji nijje emimijji etii cuana ojee miminaje Jesosajo: —¿Achajja amajje acuae seya Jesosa quecua meejeꞌyo soꞌo? Cuaꞌa, ¡ejjaquecua meequiqui! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jamajjeya Jesosa me jeyo majje dojo canaje Shomano emeshi mese Pinato bajjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jamajjeya Jodasa, ma Jesosa iña meesahuajji epo Jesosa quecua cajeꞌyo ba majje quea yeno nee nee poanaje. Poquicuajinaje Jodio etii yasijje, Eyacuiñajji nijje emimijji etii yasijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Huohui cañaquinaje: —Eya Jesosa iña mee majje quea mimishi poanaje; oya ca ca Jesosa maseꞌama nei nei poanaje, mimishiꞌama nei. ¡Maꞌaje miquea esodojjo, 30, ma miyaya eya quianaje Jesosa iña meesahua sosejje! —Eꞌe pojjaꞌa, de. Eꞌe jamatii, Jesosa caquecuajea cahua —Jodio etiiya sajaꞌa canaje—. Miquea mimishijo ca jja mi ca jjashahuabaquiani, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jamajjeya Jodasaa esodojjo meshi yasijje huojjojeajea canaje. Pa poquinaje ebio huasijje jjanaayisibijeaquiꞌyohua. Manoꞌyonaje. Chamaꞌyo tii Jodasa poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jodio cuaa aje oe esodojjo meshijo ani chicha canaje: —¿Yajja acuae jja seya jiquio esodojjo aje soꞌo? Jesosa sosequiaꞌyojji ya ca coma, de. Eyacuiñajjija equi yasijje iya sa po ajja. Jamaya pojjeama eseyaya aña —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jamajjeya mimimimi majje meshimisi iñabajijjija meshi, Apaneno meshi jjeshe canaje emano ohuajeajji, Jodio pojjeama ohuajeajji, ma 30 esodojjo sosejje jjeshe canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jjeya ca ca yohua bajjani baꞌa ma enaꞌ cuayaquinaje meshi bajjaniꞌyo, Jesosaja enaꞌ cuayaquinajejo. ");
INSERT INTO eseNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Eꞌe, yahuajo nei nei Eyacuiñajjija esohui huohuijji Jenemiaa tehue ca poa jama baꞌa: “Ecuea Emeshi Meseya eya huohui canaje: —¡Ma 30 esodojjo sosejje meshi jjeshequicue! —aca poa—, ma bajjanija baꞌa meshimisi iñabajijji poanija meshi. Mahuiso esodojjo quia canaje Jodio cuaa Eyacuiñajjija huoojeaꞌyo Quito iña meesahuajji, equecuaꞌyojji”. Jamaya Jenemia poa yahuajo nei nei. ");
INSERT INTO eseNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jamajjeya Jesosa emeshi mese Pinato huasijje dojo canaje, eme jeyo. Pinatohua ba majje huohuiꞌajja canaje: —¿Aꞌya acuae mi soꞌo? ¿Aꞌa miya Jodioja Emeshi Mese poajeꞌyo? —Eꞌe, joya ecua miyaya huohuiaña jamaya epoꞌyojji eya —Jesosaa sajaꞌa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jodio etii cuaa, Eyacuiñajji nijje emimijji etiiya peaꞌai siajje acanaje Pinato Jesosajo. Jamatii Jesosaa sajaꞌa jjima acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jamajjeya Pinatohua huohuiꞌajja canaje: —¿Yajjajje acuae mi mi jjasajaꞌaquiani soꞌo? ¿Aꞌa jje shajjaꞌajja jjima? ");
INSERT INTO eseNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Chojja, Jesosa jjasajaꞌaqui ajja nei nei. Ba majje Pinato jjashahuaba neineiquinaje: —¿Yajjajje shai Jesosa jjasajaꞌaqui ajja, de? ");
INSERT INTO eseNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","Jamajjeya Pinatohua niñeba caꞌyonaje jama baꞌa: —Ojjaña eshequiaja eyaya oe Jodio dejja jeacuayaꞌyaña Jodio quea bihui nee poanijo. Eꞌe, ojjaña Jodio cuana jjashahuabaquiani jama baꞌa: Yahuajo Ejito meshijo Jodio etiiquianaja bacua ejja cuiaꞌyo jjima aca poa esohuidojojjiya, enaꞌ ecuiapepa jojoya —Pinato poanaje. Jiquio shejoya Pinatohua oe Jodio dejja ejeanobia nequi huoojeacuayajea mee caꞌyaninaje. Jamajjeya oya Pinato jjashahuabaquinaje: —Eꞌe, eyaya oe Jodio huoojeacuayajea meejeꞌyo jjeyahua nei. Jesosa pojjaꞌa pichojea meejeꞌyo. Pea yani Mashama bajjani, ojjañaja eba nei. Oya ejeanobia nequi quea masejojo. ¿Ache dejja shai Jodio cuaa sa cani soꞌo? Cabaꞌajja sahua —jamaya Pinato jjashahuabaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jamajjeya Pinatohua ojjaña Jodio cuana ehuohuiꞌajjajji iyaa canaje. Jjachichaquiajo huohuiꞌajja canaje: —Jjeyahua nei eyaya jeacuayajeajeꞌyo oe Jodio dejja. ¿Ache acuae jja oe jeacuayajeajeꞌyo soꞌo? ¿Aꞌa Mashama? ¿Aꞌa Jesosa Quito pichojeajeꞌyo? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pinatoja eba poanaje Jodio etiiya quea quene nee poani ojjaña cuana Jesosa nijje jjapeequianijo. Jamajjeya Jesosa iña mee canaje equecuajeaꞌyojji, Jodio etiiquiaa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Emeshi mese chacochacoañani yasijje Pinato Jesosa nijje mimimiminequianijo, oja huanaseya pea echacojji huoojea canaje Pinato huohuiya. Jama huohuime acanaje baꞌa: —Huee, mecajje eyaya cahuibanaje Jesosa mimishiꞌama nei nei. ¡Aꞌa oya quecua meeꞌyojji! Eya quea mete ani ojo. Eꞌe, jjacahuibaqui majje piopionaje quea mete jjejojo —Pinatoja huanaseya echacojji huohui mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Oja huanase quea mete poanijo, Pinatohua Jesosa pichojeaꞌyo sa acanaje. Jamatii Jodio etii cuaa, Eyacuiñajji nijje emimijji etiiya peaꞌai ojjaña ejjachichaqui nequi taaa mee canaje: —¡Mashama oe huoojeacuayajeaꞌyocue! ¡Jesosa aꞌa pichojeajji! ¡Quecuajeaꞌyocue ca oma oe! ");
INSERT INTO eseNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jamajjeya Pinatohua: —¿Ache acuae jja oe pichojeajeꞌyo? Jamaya acajje, taaa neinei canaje cuana: —Mashama, ¡Mashama jeacuayajeaꞌyocue! —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—Jamajje ¿yajja acuae oe eyaya Jesosa Quito aje soꞌo? Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji ca pa coma —Pinatohua huohuiꞌajja canaje. —¡Me cacajeacue oe acui ecueataꞌapeejo! —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Yajja acuae jja soꞌo? ¿Yajjajo acuae jjaya quecuaꞌyo sa aña Jesosa? —Pinatohua huohuiꞌajja canaje. Jamatii taaa majamajanaje Jodio cuana: —¡Me cacajeacue oe; me cacajeacue oe Jesosa! —jama taaameya Jodio cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eꞌe, Jesosa pichojea mee jjima acanaje cuaa; quea quene nee neejo janobajjima nei siasianaje; taaa nequinaje Jodio. Taaa majamajajo Pinatohua huoojea canaje ena eme shacuajji jjequiya. Majoya ojjaña cuanaja ebajji Pinatohua eme topo canaje: —¡Eyaya pojjeama me cacaje Jesosa emanoꞌyojji! ¡Jamaya pojjeama ecuea esohui! ¡Miyaya ca jja ca oe jamaya aña! —Pinatohua acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Taaajebenaje ojjaña Jodio etii cuana: —Eꞌe, ¡ecuaaya oya mano meejeꞌyo Jesosa; quea tai coma! ¡Oya mimishiꞌama jojoya, ecuanajaya ebacua, osecua cuana peaꞌai cacuia caꞌyahua, Eyacuiñajjiya! —Jesosa quea mimishi poso acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jamajjeya Pinatohua ohua sa canijo Mashama jeacuayajea mee caꞌyonaje; Jesosa ca ca huoojea canaje cuiasejjajea majje me cacajeaa, emanoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Majoya emeshi meseja sohuinano cuaa Jesosa dojo canaje emeshi mese chacochacoañani equi dojjo huasijje. Ojjaña sohuinano o que jjachichaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Oja daqui huijjiajea mee majje daqui huoꞌo nei huosho mee canaje emeshi mese nishoꞌyajji. ");
INSERT INTO eseNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Acuisha sipi majje sapahuahuo iya canaje emeshi mese jayojja nisho epojji. Emeshi meseja acui ejehuijjajja iñanequia mee canaje ebianei mejje. Majoya ecuiꞌoshajjajo nequianaje ojjaña, Jesosa bihuiajji nisho. Jama bihuia nishome acanaje cuaa baꞌa: —¡Miya Jodioja Emeshi Mese quea caꞌa nee! ¡Baꞌe tiitiiꞌyocue! —jama sajeameya anisho canaje cuaa Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Majoya cuichojea canaje oja yami yasijje; acui ejehuijjajja jjequisejjajea caꞌyonaje oja emejo nequi. Jjequisejjajeaꞌyo majje sapa cuiapeꞌejea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ojo soa neineiꞌyo majje daqui huoꞌo nei huijjeajeajea caꞌyonaje; ojaya daqui quia ca oꞌoyanaje. Majoya Jesosa dojo canaje me cacajeaa, baꞌehuanasohuajeaa peaꞌai, sohuinano cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jenosanenajo aniya Jesosa dojo caje, ba cajjequinaje pea dejja Simoni bajjani, Sinene meshijo baꞌe poeꞌyo. Sohuinano cuaa Simoni acui ecueataꞌapee dojo mee canaje Jesosa quishishijji, Jesosa baꞌehuanasohuajeajji. ");
INSERT INTO eseNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jamaya oya poquinaje Jonijota eyiyo huasijje, Ese Ejjaja esohuijo Esapa Jjii anijji bajjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nequiñaquiajo Jesosa ishi meeꞌajja canaje cuaa acuijjajja na quea sese, quea pase. Ishi meeꞌajja canaje quecua caꞌyajje neeꞌama epojji. Sio majje ishi jjima acanaje Jesosaa. Majoya me cacajea caꞌyonaje. Me caca majje nequiasohuajea canaje. Majoya oja daqui cuana chicha caꞌyonaje, sohuinano cuaa. Iyachichaꞌyo majje, hueꞌe nisho majje daqui majjo caꞌyonaje, ojaya pojji epoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","38","Etehueꞌyo o baꞌe sapa biajje oja bajjani caca canaje, Jesosa bajjani, oya apiojji me cacajea caꞌyonaje huohui epoꞌyojji. Etehueꞌyo jama poa baꞌa: OYA JESOSA JODIOJA EMESHI MESE EPOꞌYOJJI Jesosa baꞌe pejjejo beca siipojji pea acui ecueataꞌapee cuanajo baꞌehuanasohuajea peaꞌai caꞌyonaje, Jesosaja ebianei mijijje, pea shani mijijje. Majoya eꞌanioque aniya ojjaña cuaa ba neinei ca aninaje oja epeejjiya ebaꞌehuanaoquea caꞌyo poajejje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pea dejja cuaa ejiojjijje poquianiya Jesosa que poe majje esapa jeacajjacajja canaje, soa huisahuisa nequinaje. Jama mimijajime poanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—¿Aꞌa acuae oe miyaya Eyacuiñajjija mei equi iñajeabichajeaꞌyo majje pea equi iyaje oꞌoya soꞌo pea beca peejjima cahuime? ¡Baꞌajja socue! Ache baꞌajja; miya Eyacuiñajjija Bacua Ejja nei jjabaqui majje ca oe ¡acui ecueataꞌapeejo baꞌe nequioqueꞌajjaꞌyo socue emanoꞌyojji pojjeama! —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jamaya peaꞌai Jodio etii bajjani cuaa, Moisesija etehueꞌyo huohuijji cuaa, Eyacuiñajji nijje emimijji etii cuaa peaꞌaiya Jesosa niñeba canaje: ");
INSERT INTO eseNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—¿Aꞌa Jesosa ojjaña jaahuanajji epoꞌyojji? Oya ona nahuejji pojjeama. Oya ca ca oma nequioqueꞌyo jjima poani, de. ¿Aꞌa acuae jja oe oya Jodioja Emeshi Mese poajeꞌyo? ¡Jjabaꞌajjaqui socue! Jodioja Emeshi Mese nei epoꞌyojji jjabaqui majje ¡acui ecueataꞌapeejo baꞌe jja ca oe canequioqueahua jjeyahua neiya ecuanaja ebajji! Ba majje ecuaaya: “Jesosa eꞌe jojo nei Eyacuiñajjija Bacua Ejja poanaje” ajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ohuaya: “Eꞌe, eya ca ca iña Eyacuiñajjija Bacua Ejja; ohuaya eya jaahuana cani” acanaje yahuajo. Jamajjeya oya Jesosa Eyacuiñajjija quea boti nee neejo, ¡Eyacuiñajjiya oya canahue cahua jjeyahua nei! —Jodio cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Siipojji cuaa ma o pejjejo ebaꞌehuanasohuajea baꞌeya peaꞌai Jesosa jamaya niñebame acanaje, quea huiso nee. ");
INSERT INTO eseNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Majoya eshequi biacojjajja nequijo shequimaꞌ jayojja poanaje; quea misi nee poanaje ojjaña meshi yasijje. Quijje eshequi jjajeapaaquiꞌyo majje jiji oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sinecua, quea misi poajo Jesosa quea yeno nee neejo taaa neineinaje: —¿Eli, Eli, lama sabactani? —taaame poanaje—; ecue Chii, ecue Chii, ¿yajjajo acuae moya jeanaꞌyonaje soꞌo? —Jesosa poanaje Jodioja esohuijo. ");
INSERT INTO eseNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Shajjaꞌajja majje joya quea chipi nee nee nequi jama poanaje baꞌa: —¡Bacue oe! ¡Ohuaya etiiquiana Enia iyaa cani pojjaꞌa! ");
INSERT INTO eseNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jamajjeya oe dejja poquicuajinaje acuijjajja na sese jjequiya. Jjequi majje shajashaja iyanobia canaje ena ejjequi yasijje. Majoya bequiobo sajo quecuahuosho majje Jesosaja enaba huasijje huoo canaje ojaya eꞌishijji nisho. ");
INSERT INTO eseNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","—Chojja, ¡ishoa socue! ¡Enia pojjaꞌa poeje o nahueya! ¡Baꞌajja socue! —Jodio cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jamatii taaa neinei oꞌoya majje Jesosa manoꞌyonaje. Chamaꞌyo tii poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesosa manoꞌyajo tii, Eyacuiñajjija equijo daqui quea moo ebaꞌehuana baꞌe Eyacuiñajjiya eyajje jjaꞌisajea meequi canaje; biacuajje ebionei jjaꞌisajeaquinaje. Meshi janobajjima nei huehuahuehuanaje peaꞌai. Mei quea quemo cuana jjayajjejeaquinaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mei jjani, esajaajji cuana peaꞌai jjayajjejeaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Quijje Jesosa eshe oꞌoya poajo, Eyacuiñajjija epeejji yahuajo emanoꞌyo ma jjani cuanajo jaa cuayaquiꞌyonaje, quea huiso Jenosanena huasijje poquinaje cuana; quea huiso dejjaa ba canaje ma emanoꞌyo cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ojjaña ba majje, meshi huehuahuehuani ba majje peaꞌai sohuinano quea huiso nee, 100, huoojeajji poaniya pea sohuinano cuana nijjeya, ma Jesosa nahuejji poani, quea mete nee nee poanaje. —¡Eꞌe jojo nei, de, oya Jesosa Eyacuiñajjija Bacua Ejja nei poanaje! —sohuinano poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Quea huesha nequiya epona cuaa peaꞌai Jesosa ebaꞌehuanasohuajea baꞌe ba canaje. Oya cuana yahuajo Jesosa nijje Janinea meshijo ania poa. Onijje Jenosanena huasijje poeyanaje oja bobi cuacua meesahuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Oya cuana ma bajjani baꞌa: Mania Madanena; Satiaco, oja chahua Jose peaꞌaija enaese Mania bajjani; Semeneoja ehuanase peaꞌai; Jesosaja enaese peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jamajjeya sinecua nei Jesosa manoꞌyajo, dejja quea aquiana huiso nee Jose bajjani poeyanaje, pea Jose, Amatea meshijo baꞌe. Oya Jesosa nijje jjapee tiitiiquia poa yahuajo nei. ");
INSERT INTO eseNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jamajjeya poe majje oya Pinato baa poquinaje. Huohui cañaquinaje: —Emeshi mese Pinato, Jesosa manoꞌyonaje. Eyaya oya cadojoꞌyahua ecuea mei jjani yasijje ehuananobiaquiꞌyojji —poanaje. Pinatohua huoojea canaje: —Eꞌe, ¡dojocue! Eyaya sohuinano cuana jamaya huohuime aje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jamajjeya Joseya Jesosa acui ecueataꞌapeejo emanoꞌyo baꞌe jjequioqueaꞌyo majje dojo caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Daqui oshe eyacua neijo bebo majje huananobia caꞌyonaje ojaya mei jjani yasijje, ma oja jjeya nei tio huasijje. Majoya mei quea quemo jeacajjajja canaje mei jjani naba capaꞌyojji. Jesosa mei jjani dojjojo jaa capajea canaje. Capaꞌyo majje poquinaje Jose pea cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mania Madanena, pea epona Mania bajjani peaꞌai mei jjani yasijje poeyanaje peaꞌai Jesosa jjanijo ehuananobia jaa baa. Jomajo eꞌanioque aniya ba canaje, epona cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jamajjeya mecahuajje epojja ejomishocajji jjayejjequiajo Paniseo cuana, Eyacuiñajji nijje emimijji etii peaꞌai poqui oꞌoyanaje Pinato que. ");
INSERT INTO eseNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Huohui cañaꞌyonaje: —Emeshi mese, ecuana jjashahuabaquiani yahuajo Jesosa manoꞌyo jjimahua siajje poanaje jama baꞌa: “Beca cahuime po majje eya emanoꞌyojaa shequijeꞌyo” —Jodio poanaje, Jesosa siajje poanajejo poso—. ");
INSERT INTO eseNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jamajjeya ¡jjeyahua nei sohuinano huoojeacue jjani baa, beca cahuime pohua, Jesosaja epeejjiya oe equehua dojoꞌyo bacue! Jamaya po majje ojjaña cuana dasia ca chanaꞌ jama baꞌa: “¡Bacue oe! ¡Jesosa ca jja ca emanoꞌyojaa shequi oꞌoyanaje!” huohui ca chanaꞌ oja epeejjiya. Ojjaña cuana siajje nei nei acaꞌyo chanaꞌ —Jodio cuana jamaya poanaje, Jesosa eshequi oꞌoyajji pojjeamajo poso. ");
INSERT INTO eseNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jamajjeya Pinatohua huoojea canaje: —¡Maꞌaje sohuinano cuana! ¡Dojoꞌyocue mei jjani yasijje, ma Jesosa ehuananobia jaa huasijje! ¡Aꞌa acuae jjani caꞌajeꞌyo baꞌajja socue! —poanaje Pinato. ");
INSERT INTO eseNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jamajjeya poquinaje Jodio cuana sohuinano cuana nijje mei jjani yasijje. Jjani capajji ijjia caꞌa meequi caꞌyonaje baacuiya. Majoya esecue jjanijo emeshi mese nisho iya canaje ona edobiqui poaje jjejojo. Etehue iya canaje, emeshi mese nisho. Majoya Jodio cuana poquinaje. Sohuinano ca ca enequinaje tii, esecue jaahuanajjiya. ");
INSERT INTO eseNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jamajjeya epojja ejomishocajji jjayejjequiajo mecajjeahua nei nei, ebionei jjapojjaquiajo, nomico pojjajo, Mania Madanena, pea Mania nijje poquinaje mei jjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Epona cuana jjani pejje yasijje poeyajo, meshi huehuahuehuanaje janobajjima nei. Eyacuiñajjija esohuidojojji eyajo ani nequioquenaje. Mei jeacajjajjajea canaje. Majoya esohuidojojji mei biajje anioquenaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oya quea jiji nee nee poanaje pojjejje jayojja; ojaya daqui quea oshe nee nee, bo oshe nee nee jayojja ani ba canaje epona cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sohuinano cuana quea mete nee nee poanaje. Piopio neineinaje; meshi yasijje jaabichajeaquinaje, emanoꞌyo jayojja jama jaanaje esohuidojojji yajjajo. ");
INSERT INTO eseNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Majoya esohuidojojjiya epona cuana jama huohuime acanaje baꞌa: —¡Aꞌa quea mete pojji! Ecuea miya eba. ¿Aꞌa Jesosa, ma acui ecueataꞌapeejo manoꞌyonaje saꞌajjaꞌyo poequi? ");
INSERT INTO eseNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Chamaꞌ oya jjeya jiquiojo. Shequiꞌyonaje ca jja coma; ma ecua ohuaya huohui canaje jamaya eꞌe jojo nei poꞌyonaje; oya shequiꞌyonaje jjeya. Eꞌe, ¡quiaꞌo jiquio baꞌajjahuaꞌyo! Jiquiojo jaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","¡Jjeyahua nei poquicuajicue oja epeejji cuana huohuiya! ¡Jama huohuime acue baꞌa: “Jesosa pa shequiꞌyonaje” acue! “Oya jjeya nei Janinea meshi yasijje poquije miquiana poqui jjimahuajo. ¡Oya oe jocuama baquicue!” jamaya o shajjaꞌajjajji cuana huohuiquicue! ¡Ecue sohui ma eya huohuinaje oe aꞌa pajeaꞌyojji; pea huasijje huohui neiquicue! —esohuidojojji jamaya poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jamajjeya epona cuana poqui cuajicuajinaje. Quea mete, quea bei nee nee poanaje. Cuajicuajinananaje Jesosa shajjaꞌajjajji cuana esohuidojojjija esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ejiojjijje poquijejo Jesosa jjanequipanaquinaje. Ehui dojojji nequinaje. Huohui canaje: —Jjoꞌi, ¡ejo quea bei pocue! Eya poeyanaje —Jesosa poanaje. O que poe majje o que jjanequichipiquinaje. Ecuiꞌoshajjajo nequinaje; jiojji napa canaje. Quea bihui nee nee yajji epona cuaa oya bihuia canaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jamajjeya Jesosaa oya cuana huohui canaje: —¡Aꞌa quea mete pojji! ¡Poquicue; ecuea epeejji cuana huohuiquicue, miyaya! ¡Jama oe acue baꞌa: “¡Jjeyahua nei oe Janinea meshi yasijje poquicue! ¡Jocuama oe Jesosa baquicue, Janinea meshi yasijje!” acue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Epona cuana poquiꞌyajo sohuinano cuana meshijo jaa nequisohuaꞌyonaje. Jenosanena huasijje poquinaje Jodio etii baa. Eyacuiñajji nijje emimijji etii huohui cañaꞌyonaje ojjaña ohua jama acanaje, sohuinano cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Huohui poñaꞌyonaje. Sohuinanoja esohui shajjaꞌajja majje Jodio etii cuana jjachichaquinaje emimimimijji. Majoya sohuinano cuana quea huiso bejjo quia canaje o siajje poani sosejje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jama huohuime acanaje baꞌa: —¡Miyaya ojjaña cuana jama huohuime acue baꞌa: “Mecajje ecuana ecahuijaajo Jesosa sii caꞌyonaje jjanijo jaa, o shajjaꞌajjajjiya” acue! ");
INSERT INTO eseNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Emeshi mese Pinato miquea ehuohui shajjaꞌajja cajo ecuana onijje mimije, eꞌe jojo nei, miya ojaya enapaꞌyojji pojjeama. Pinato quea bei po meejeꞌyo ecuanaa —Jodio cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jamajjeya Jodio etii cuaa sohuinano bejjo quia canaje. Bejjo jjeshe majje sohuinano cuana poquinaje ojjaña huasijje huohui pohua. Jodio etiija esohui jayojja jama acanaje. Jamajjeya quea huiso Jodio cuana sohuinanoja esohui shajjaꞌajja majje eꞌe jojo nei poani posojo jjashajjaꞌajjaquinaje. Jjeya jiquio pojjajo cuanaya jamaya Jodio cuaa huohui cani tii: —¡Jesosa ca jja ca ojaya epeejjiya quehuadojo caꞌyonaje; shequi oꞌoya ajja! —sohuinano siajje poanaje jayojja jama poani tii, Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jamajjeya Jesosa shajjaꞌajjajji cuana 11 huisome poquinaje Janinea meshi yasijje Jesosa baa. Poquinaje eyiyo huasijje ma Jesosa huohui poequi baa. ");
INSERT INTO eseNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Poqui majje, Jesosa ba majje bihuia canaje cuaa. Jamatii beca cuana ca ca jama poanaje baꞌa: —Eꞌe pojjaꞌa. Edojjoshahua pojjaꞌa coma, Jesosa pojjeama —jjashahuabaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jamajjeya Jesosa o que jjanequichipichipiqui majje jama huohuime acanaje baꞌa: —Eyacuiñajjiya eya Emeshi Mese nei epojji acaꞌyonaje eyajo, meshijo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jamajjeya ¡poquicue ojjaña dejja cuana huasijje! ¡Ojjaña pea esohui mimiani yasijje ecuea esohui ba meequicue peaꞌai! ¡Enijje jjapeequi meequicue! Enijje jjapeequiyajo, ¡ena huasijje besa meecue, eseja Chii nijje epojji, enijje epojji, Edojjoshahua Pame nijje peaꞌai epojji! ");
INSERT INTO eseNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","¡Ojjaña cuana ecue sohui ba meesahuacue oe! ¡Ojjaña oe jjashajjaꞌajja meequicue quea bame nee nee ebaꞌejji, mimishiꞌama ebaꞌejji! ¡Bacue oe! Eya eꞌe jojo nei minijje nequi tiitiijeꞌyo ojjaña pojjajo, jiquio meshi oe epojji jiquio epojja huisome tii —Jesosa poanaje. Mahuiso ecuea esohui etehueꞌyo. Eyaya Mateo bajjaniya tehuejeyonaje. Apoa.");
INSERT INTO eseNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Eyaya, Macoso bajjaniya esohui quea pame nee tehueaña Jesosa Quitoja, Eyacuiñajjija Bacua Ejjaja, ojjañaja ebajji. Jamaya poanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yahuajo nei nei ecuanaja etiiquiana Isaia bajjani Eyacuiñajjija esohui huohuijji poa. Eyacuiñajjija Bacua Ejja Jesosa Quitojo Isaiaa tehue ca poa Eyacuiñajjija esohui. Eꞌe, Eyacuiñajjiya oja Bacua Ejja jama aca poa baꞌa: “¡Shajjaꞌajjacue! Eyaya ecuea esohui huohuijji huoojeaje mi huoojea jjimahuajo. Ohuaya miquea ejiojji shabojea caje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Eꞌe, oya quimajo, meshi jabojo nequi taaanequije. Jama poaje baꞌa: —¡Jiquio ecua emeshi cuiñajji nei neija ejiojji shabojea cani jama, quea pojje nee nee acani jayojja jamaya miquea ejjashahuabaquijji tai quea boejea nee nee aꞌyocue! Emeshi Mese nei poeje. ¡Jamajjeya oe apoa pocuajicue!” Jamaya Isaiaa yahuajo nei nei tehue ca poa Jesosajo. ");
INSERT INTO eseNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jamajjeya Isaiaja esohui jayojjaya Huaniya, ma ona besameejji poaniya, meshi quimajo aniya esohui quea bihui nee Jesosajo huohui canaje. Jama acanaje baꞌa: —¡Miquea mimishijo quea yeno pocue! ¡Mimishi jja oe pajeaꞌyocue! Eꞌe, jamaya poajo, Eyacuiñajjiya miquea mimishi cuana cuijea cajeꞌyo. Jamajjeya eyaya miya besa meeje ojjañaja ebajji miya Eyacuiñajjija epeejji poꞌyonaje —acanaje Huaniya. ");
INSERT INTO eseNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Quea huiso nee nee cuana Jenosanena cuiñajjijo baꞌeca, ojjaña Jodea meshijo baꞌeca peaꞌai poquinaje Jodana cuei yasijje Huani baa. Huani shajjaꞌajja majje oya cuana quea yeno nee poanaje ojaya mimishijo. Miminaje Eyacuiñajji nijje. Ojaya mimishi huohui canaje. Majoya Huaniya oya cuana besa mee canaje Jodana enajo, Eyacuiñajjija epeejji epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Huaniya huo ña, cameno ña oja sipi huosho canaje. Ejjayiicaꞌaquijji ejee iya canaje. Shacui ijjia canaje, huini peaꞌai ishi canaje, Huaniya. ");
INSERT INTO eseNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ohuaya huohui canaje jama baꞌa: —Quijje pishana poeje Jesosa Quito. Oya oe nei quea caꞌa nee nee nequi. Eya ca iña quea caꞌa pishana nequi. Jamajjeya eya ca iña onijje nequi sa po ajja miquiana que cojja. Quea bicho. ");
INSERT INTO eseNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eyaya miquianaya Eyacuiñajjijo besa meeaña enajo. Poe majje ohuaya, Jesosa Quitohua miquiana que Eyacuiñajjija Edojjoshahua Pame dobiqui mee cajeꞌyo. Jamajjeya miquianaya quea pame nee poajeꞌyo —acanaje Huaniya ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Majoya Huaniya Jodana cuei sahuajo sohuihuohui canijo tii, Jesosa Janinea meshijo baꞌenaje, Nasanena cuiñajjijo. Macua huasijje poꞌoquenaje Huani que. Huani jama acanaje baꞌa: —Huani, ¡eya besa meecue Eyacuiñajjijo, miyaya! Jamajjeya Huaniya Jesosa besa mee canaje Eyacuiñajjijo Jodana enajo. ");
INSERT INTO eseNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Huaniya Jesosa besa mee majje, jjequicuaya caꞌyajje ba canaje eyatahuatahua caꞌapejo caje. Eyacuiñajjija Edojjoshahua Pame huiaꞌ jama Jesosa sapa biajje cuabesa baꞌenaje. Ecapashi nei baꞌeoquenaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eyacuiñajjiya eyajo aniya oja Bacua Ejja jama acanaje baꞌa: —Miya ecue Bacua Ejja quea jea nee nee. Eya mijo quea bihui nee nee poani. ");
INSERT INTO eseNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jjeyahua nei Edojjoshahua Pameya Jesosa quima huasijje, meshi jabo huasijje huoojea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesosa jomajo nequinaje peaja ejiojji huiso cahuime, 40 cahuime. Mahuiso epojja cuana, mecajje cuana peaꞌai aninaje. Oe nei nei aninaje. Ijjiacajji quea mase cuana jomajo nequinaje peaꞌai. Edosiquiana aje Jesosa que poeyanaje. Quea mimishi epo meejji nisho acanaje. Majoya Eyacuiñajjija esohuidojojji cuana quea huiso poeyanaje Jesosa bobiaa. ");
INSERT INTO eseNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Majoya pea cuaa Huani, ma ona besameejji poani iña canaje; equi ejjajeanobiaquijji yasijje jeanobiajea canaje. Jamajjeya Jesosa posohuaquinaje Janinea meshi yasijje. Eyacuiñajjija esohui quea pame nee huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jama poanaje baꞌa: —Jjeyahua nei Eyacuiñajji miquea Emeshi Mese nei poaje. ¡Jamajjeya miquea mimishijo quea yeno pocue! ¡Mimishi cuana pajeaꞌyocue miquiaaya! ¡Ecuea esohui quea pame shajjaꞌajjacue! Eꞌe, enijje jjapeequiajo, eyaya miya baꞌe tiitii meejeꞌyo enijje —Jesosaa huohui tiitii canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Majoya Jesosa poquinaje Janinea bae ai sahua huasijje. Jomajo ohuaya Anesi, Anesija oꞌi Peno bajjani, Simohui peaꞌai bajjani ba canaje. Oya cuana nahuoo cuiashajajji nei nei bajio. Nahuoo cuiashaja poequi. ");
INSERT INTO eseNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesosaa oya cuana iyaa canaje: —¡Enijje poꞌyocue! Eyaya miya dejja cuana jjequi meesahuaꞌyojji ajeꞌyo e que. ");
INSERT INTO eseNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jjeyahua nei nei oya cuana ojaya eshajajji cuana jeanaꞌyo majje onijje poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Majoya Jesosaa poqui pishana majje pea cuana ba canaje. Semeneoja bacua ejja Jacobo ba canaje oja chahua mese nijje, Huani nijje bishe aijo eshajajji jeꞌeꞌyo poꞌani oja chii nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jjeyahua nei Jesosaa oya cuana iyaa canaje. Jamajjeya Jesosaa iyaa cajje oja chii Semeneo bajjani echacojji cuana nijje bishejo ani tii jiña caꞌyonaje cuaa, Jesosa nijje epoquiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Majoya quijje pishana Jesosa o shajjaꞌajjajji nijje posohuaquinaje Capenaoma cuiñajji yasijje. Epojja ejomishocajjijo oya cuana poquinaje Jodio cuanaja equi ojee ejjachichaquijji yasijje. Dobiqui majje Jesosaa ojjaña jomajo ani sohuihuohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","O shajjaꞌajja majje ojjaña cuana jama poanaje baꞌa: —¡De! Ohuaya Jesosaa esohui huohui cani quea jaꞌa nee. Huohui cani emeshi mese jayojja jamaa quea jaꞌa nee nee. Moisesija esohui etehueꞌyo huohuijjiya quea jaꞌa pishana esohui huohui cani, de. ¡Cashajjaꞌajjaꞌyahua Jesosa! —poanaje ojjaña cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jjeyahua nei dejja niñepoqui dobinaje ma equi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jesosa ba majje eshahua o niñepoqui meejji poani siasianaje jama baꞌa: —Jesosa, Nasanenajo baꞌe, ¿apiojji miya poeyanaje ecuana que ecuana quea nee nee po meeya? Ecuanaja eba miya Eyacuiñajjija Bacua Ejja quea pame nee. ¡Aꞌa jjeyahua nei ecuana cuaqui yasijje jeajeajji! Eyacuiñajjiya eshahua cuana cuaqui yasijje huoojeajea cajeꞌyo quijje, jjeya nei pojjeama, de —taaame poanaje eshahua. ");
INSERT INTO eseNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jamajjeya Jesosaa eshahua, o niñepoqui meejji poani huoojeacuayajea caꞌyonaje: —Eshahua, ¡aꞌa mimijji! ¡Cuayaquiꞌyocue oe, jiquio dejjajo nequi! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesosa mimi jeahuajo, eshahuaa o niñepoqui meejji poaniya dejja jjequiꞌihui mee majje, siasia mee majje cuayaquinananaje. Dejja jea canaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ba majje ojjaña cuana quea mete nee nee poanaje. Ojee miminaje jama baꞌa: —¡De! ¿Yajja shai poani? Jamaya yahuajo ecuanaja ba jjima, de. Jesosaa quea jaꞌa nee huohui cani emeshi mese jamaa, oya quea sohui poja nee nee. Ojaya esohui shajjaꞌajja cani eshahuaa. Oja sohui jayojja jama acani, de —poanaje ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jjeyahua nei ojjañaa Janinea meshijo baꞌecaa shajjaꞌajja canaje Jesosajo. Jama poanaje baꞌa: —Jesosaa quea jaꞌa nee ojjaña acani. Oya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji eꞌe jojo nei —ojjaña poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesosa Jodio cuanaja equi ojee ejjachichaquijjijo nequi cuayaquiꞌyo majje poquinaje Simohuija equi yasijje, Anesija peaꞌai equi yasijje. Dobiquinaje Jacobo nijje, Huani peaꞌai nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simohuija ano quea quiyo nee jaa. Jamajjeya Jesosa huohui canaje jama baꞌa: —Jesosa, ecue ano, ecue huanaseja enaese quea quiyo nee nee jaa, quea mano, de —Simohui Peno poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jamajjeya Jesosa o que poquinaje. Emanojaa ba canaje. Napaꞌajja canaje emeya. Me napaꞌajja cajje, boe cananaꞌyonaje. Jamajjeya me iña majje jjequisohua canaje Jesosaa. Majoya ohuaya, Simohuija anohua, bobi ojjaña huasijje jjequi canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Majoya sinecua neijo, eshequi eꞌoquequiajo, dejja cuaa quea huiso emanojaa cuana, niñepoqui cuana peaꞌai Jesosa que jjequi canaje ejjaajaqui meeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ojjaña jiquio cuiñajjijo baꞌeca Jesosa que jjachichaquinaje Simohuija equi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesosaa ojjaña emanojaa jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje peaꞌai. Eshahua cuana huoojeacuayajea caꞌyonaje peaꞌai. Eshahua cuana, o ebajo, jama acanaje Jesosaa baꞌa: —Eya miquianajaya ebajo ¡aꞌa mimijji! Eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, oja Bacua Ejja ¡aꞌa pea cuana huohuijji! —poanaje Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mecajjeahua nei, eshequi jjajaꞌaꞌajjaqui jjimahuajo, Jesosa shequi majje cuiñajji esecue yasijje poquinaje dejjama huasijje. Jocuama oya miminaje Eyacuiñajji nijje, oja chii nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jamajjeya shequi majje pea cuaa Simohui nijjeya oya saꞌajjaqui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","O ba majje jama poanaje baꞌa: —Jesosa, ojjañaa miya saꞌajja caqui —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jamajjeya Jesosaa oya cuana jama acanaje baꞌa: —¡Cuaꞌa, enijje poquicue pea cuiñajji cuana huasijje! Eyacuiñajjiya eya huoojea canaje pea cuiñajji yasijje ojaya esohui jocuama huohuiya peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jamajojoya Jesosa Janinea meshijo ojjea poquinaje ojjaña cuiñajji cuana huasijje. Ojjaña Jodioja equi ejjachichaquijji yasijje dobiquinaje; esohui huohui canaje. Eshahua cuana huoojeacuayajea caꞌyonaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Majoya oe dejja quea mano nee batata epoꞌyo poeyanaje Jesosa que. Ecuiꞌoshajjajo nequinaje o bihuiajji. Onijje miminaje jama baꞌa: —Jesosa, ecuea eba miya jjajea meequiꞌyojji nei nei poani. Jamajjeya miyaya jjajeaqui meeꞌyo sa amajje ¡mo che jjajeaqui meeꞌyocue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesosa ma dejja quea mano ba majje quea yeno poanaje. Oya napaꞌajja canaje emeya. Jama poanaje baꞌa: —Eꞌe, eyaya miya jjajeaqui meejeꞌyo. ¡Jjajeaquiꞌyocue, miya! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jjajeaquinanaꞌyonaje jjeya nei. Quea pame nee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jamajjeya Jesosaa oya huohui canaje jama baꞌa: —¡Shajjaꞌajjacue mo! Eyaya miya jjajeaqui meeꞌyonaje. ¡Jamatii aꞌa oe jjeya huohuipojji ecue jjajeaqui meeꞌyo! ¡Poquicuajicue Jenosanena huasijje, Eyacuiñajjija equi yasijje, ma onajo Eyacuiñajji nijje mimiani yasijje! Oya huohuicue jama baꞌa: “Eya jjajeaquiꞌyonaje” acue. ¡Moisesija sohui jayojja jama oe pocue peaꞌai! Miya ehuaquiaꞌyohua jjejojoya ¡Eyacuiñajji nijje mimiani yasijje beca huiaꞌ quiaquicue Eyacuiñajji bihuiajji! Jamajjeya ojjañaa ba caje miya eꞌe jojo nei ejjajeaquiꞌyo —oya acanaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jamatii poqui majje huohui canaje ojjaña huasijje jama baꞌa: —¡Jesosaa eya jjajeaqui mee caꞌyonaje de, huaquia mee caꞌyonaje jjeya nei! Jamajoya dejja quea huiso nee nee nee o ba sa poanaje, ejjaajaquiꞌyojji. Quea huiso nee nee jjachichaqui majje Jesosa cuiñajji cuana huasijje dobiqui mee jjima acanaje. Oya quimajo nequinaje. Quea huiso nee nee o que poeyanaje, ojjaña huapajje aequiana poeyanaje o baa. ");
INSERT INTO eseNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Majoya quijje pishana Jesosa Capenaoma huasijje poe oꞌoyanaje. Jamajjeya pea cuaa jomajo nequiya huohui canaje jama baꞌa: —Jesosa poeꞌyonaje ojaya equi yasijje. ¡Cuaꞌa, ejjabaquiqui! ");
INSERT INTO eseNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jamajjeya quea huiso nee nee jjachichaquinaje ojaya equi yasijje. Dobiqui mee ajja quea dejja huisojojo. Esecuejo nequinaje; equi shajjaquibojo aequiana nequi canaje peaꞌai. Jesosaa oya cuana Eyacuiñajjija esohui huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Majoya pea dejja cuaa, ebeca pee peaꞌaiya, quibojjisha quea mano nee nee equipajaajjijo jaa sejjaiña majje Jesosa que dojo canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","O que poe meemee ajja, quea huiso equijo ejjachichaqui nequijojo. Jamajjeya oya cuanaa equi biajjejje quibojjisha dojosohuaqui canaje. Equi huejja caꞌyonaje. Huejjajje equipajaajji ecapashinei jeaoquea caꞌyonaje jjonojo. ");
INSERT INTO eseNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma ba majje Jesosa jjashahuabaquinaje jama baꞌa: —Eꞌe, jiquio dejja cuana jjashahuabaquiani eya ejjaajaquimeeꞌyojji nei nei poani. Jamajjeya quibojjisha nijje jama poanaje baꞌa: —Cha, ¡quea bihui nee pocue! Eyaya miquea mimishi cuana cuijeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jesosaja esohui shajjaajja majje Moisesija etehueꞌyo huohuijji poani jomajo ani quenequenenaje. Jesosa Eyacuiñajjija Bacua pojjeama posojo jjashahuaba taiquinaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¡De! Jiquio oya Eyacuiñajji pojjeama. ¿Apiojji Eyacuiñajji jayojja jama nei nei mimiani, de? Jamaya quea mimishi. ¿Aꞌa acuae ohuaya mimishi cuijea mee cajeꞌyo jjabaquiani? Chojja, Eyacuiñajji oe nei mimishi cuijeaꞌyojji poani —poanaje Jodio etii cuana, Jesosa Eyacuiñajjija Bacua Ejja pojjeama poso acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jamajjeya Jesosa Jodio etiija ejjashahuaba taiquijji ba majje jama poanaje baꞌa: —¿Yajjajje acuae nequiana enijje quea quene poani soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ache shai quibojjishajo quea camaja eyaya ajeꞌyo? ¿Aꞌa ojaya mimishi cuijeaꞌyojji quea camaja? ¿Aꞌa jja eyaya oya nequisohua meejeꞌyo? Baꞌajja —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jamajjeya eyaya ojjañaja Edoe Meseya miquianaya ba meeaña eya ca ca iña Emeshi Mese nei quea caꞌa nee nee nequi. Jamajjeya eyaya mimishi cuijeajeꞌyo nequianaja. ");
INSERT INTO eseNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Majoya Jesosaa quibojjisha acanaje: —¡Nequisohuacue! ¡Miquea equipajaajji bebo majje miquea equi yasijje poquicue! ");
INSERT INTO eseNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jjeya nei quibojjisha nequisohua majje jeoꞌyonaje. Equipajaajji bebo canaje. Jeojeopoquiꞌyonaje oja equi yasijje. Jamajjeya ba majje ojjaña cuana quea bihui nee nee poanaje. Eyacuiñajji bihuia canaje jama baꞌa: —¡Eꞌe nei, joya quibojjisha jeoꞌyonaje jjeya nei! ¡Eꞌe, e, Eyacuiñajjiya Jesosa quea caꞌa nee po mee cani; emanojaa cuana huaquia mee caꞌyani! ¡Mimishi cuijea mee caꞌyani peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Majoya Jesosa poqui oꞌoyanaje meshijaji yasijje, bae sahua huasijje. Quea huiso nee nee o que poeyajo, oya cuana Eyacuiñajjija esohui huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Majoya Jesosaa poquijeya Apeoja bacua ejja Mateo ba canaje, ma Nemi peaꞌai bajjani. Oya yaninaje equi ejjeshejji jaahuanajjijo, ojjañaja emeshi meseja esohuijo jjeshe mee cani dejja cuana ebaꞌejji sosejje. Oya bejjo jjeshejji poani. Ba majje Jesosaa oya iyaa canaje: —Nemi, ¡enijje poꞌyocue! Jamajje Nemi nequisohua majje Jesosa nijje poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Majoya Nemiya Jesosa iyaa canaje ojaya equi yasijje ijjiaꞌijjiaa. Jamajjeya Jesosa o shajjaꞌajjajji cuana nijje Nemija equi yasijje poquinaje ijjiaꞌijjiaa. Quea huiso dejja cuana Nemi jama bejjo jjeshejji poani, dejja mimishi cuana peaꞌai poquinaje. Ojee ijjiaꞌijjia aninaje Jesosa nijje, Jesosa shajjaꞌajjajji cuana nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesosa ma dejja mimishi cuana nijje ijjiaꞌijjia ani ba majje Jodio esohui huohuijji Paniseo cuana bajjani, Moisesija esohui etehueꞌyo huohuijji cuana peaꞌai quea quene poanaje. Jesosa shajjaꞌajjajji cuana nijje mimijajinaje jama baꞌa: —¿Apiojji miquea esohui huohuijji ijjiaꞌijjiani bejjo jjeshejji cuana nijje, dejja mimishi nijje peaꞌai? ¿Apiojji, de? ");
INSERT INTO eseNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesosaa oya cuana shajjaꞌajja canaje. Huohui canaje jama baꞌa: —¿Aꞌa dejja cuana quea mano pojjeama eshicuijji quia sa poani? Quea mano poanijo ca ca eshicuijji quia cajji. Oya jayojja eya dejja quea mimishi nijje jjapeequiani quea jaꞌa nee epo meeꞌyojji. ¡Bacue! Beca cuana jama poani baꞌa: “Eya ca ca iña quea pame nee, mimishiꞌama nei nei” poso jjabaquiani. Jamajjeya ma dejja cuana ecuea eꞌiyaajji pojjeama enijje ejjapeequiꞌyojji. Chojja, eya poeyanaje dejja quea mimishi iyaaa, mimishi pajea meeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Majoya Huani, ma ona besameejji poani, jeanobiajea canaje cuaa. Jamajjeya Jodio etiiquianaja esohui jama poanijo o shajjaꞌajjajji cuanaa bobi ijjia jjima aninaje Eyacuiñajjijo ejjashahuabaquijji, onijje emimijji peaꞌai. Jamaya Paniseo shajjaꞌajjajji cuana poa peaꞌai. Jamajjeya beca cuana Jesosa que poeyanaje. Jama huohuiꞌajjame acanaje baꞌa: —Jesosa, ecuana, Paniseo cuana peaꞌai, Jodio etiiquianaja esohui jama poanijo bobi ijjia ajja Eyacuiñajjijo ejjashahuaba neineiquijji. ¿Apiojji acuae mi shajjaꞌajjajji poani jama po ajja? —poanaje; beshahua nei tecuea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesosaa oya cuana acanaje jama baꞌa: —Chojja, ¡eya ecuea epeejji cuana nijje yanijo, caꞌijjia cahua! Ma jayojja jama baꞌa: Ejjahuanaquijjijo yahueja epeejji cuana onijje yanijo caꞌijjia cahua quea bihui nee. ¿Aꞌa yahueja epeejji cuana onijje yanijo quea yeno? Chojja, quea bihui nee. ");
INSERT INTO eseNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yahue poquiꞌyajo ca ca oe ojaya epeejji cuana ijjiaꞌijjia sa po ajja poaje. Quea yeno jjejojo jjashahuaba neineiquiani. Eya jiquio ecua yahue jama poani: Quijje eya poquiꞌyajo, ecuea epeejji cuana ijjiaꞌijjia ajja poaje, Eyacuiñajjijo ejjashahuaba neineiquijji, onijje emimi neineijji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Majoya Jesosaa huohui canaje pea ejjashahuabaquimeejji: —Eseyaya baacojja eseeꞌyohua bishe eyacuajo caca ajja. Cho. Baacojja etii enajo nequi seeꞌyani, caꞌaꞌama poꞌyani. Jjasajajeaquijeꞌyo. Bishe ihuijeꞌyo. Bishe eyacuajo ca ca baacojja eyacuaa cacaña. ");
INSERT INTO eseNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pea esohui huohui canaje jama baꞌa: —Ena sese cuatatanijo iya ajja meshimisi etiijo. Ena sese cuatata neineianijo, meshimisi caꞌaꞌama jjaajajeaqui majje ena sese jjashojeajeaquijeꞌyo. Cho, ena sese cuatatanijo meshimisi eyacua quea caꞌajo iya cani cuaa —jamaya Jesosaa huohui canaje ejjashahuaba meequijji onijje jjapeequi majje eyacua cabaꞌyahua, yahuajo jama pojjeama, etiiquianaja esohui jama pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Majoya Jodioja epojja ejomishocajjijo Jesosa o shajjaꞌajjajji cuana nijje ejiojjijje poquinaje. Que yiyejje poquije quea shoe poanaje. Quejo nequi anoso ai sejja canana majje oe pojji ijjia canaje, o shajjaꞌajjajjiya. ");
INSERT INTO eseNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Maya Paniseo cuaa ba canaje. Jamajjeya Jesosa nijje mimijajinaje jama baꞌa: —¡Bacue oe! Mi shajjaꞌajjajji poani cuaa chaco cani. Anoso ai sejja cani esejaya epojja ejomishocajjijo. Esejaya etiiquiana Moisesija etehueꞌyo jama poani baꞌa: “¡Aꞌa chacojji epojja ejomishocajjijo!” ");
INSERT INTO eseNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesosaa oya cuana acanaje jama baꞌa: —¿Aꞌa miquea ba jjima esohui etehueꞌyo emeshi mese Dabija, ojaya epeejji cuanaja peaꞌai? ");
INSERT INTO eseNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yahuajo nei nei Abiata Eyacuiñajji nijje emimijji etii poanijo, Dabija epeejji cuana quea shoe nee po majje Dabi Eyacuiñajjija equi yasijje dobiquia poa. Ijjia ca poa pahui, maya Eyacuiñajji yasijje quia ca poa cuaa o bihuiajji. Ojaya epeejji cuana ijjia mee ca poa peaꞌai. Jiquio ca oe Eyacuiñajji nijje mimianiya caꞌijjia cahua; pea cuanaja eꞌijjiajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Majoya Jesosa ojjaña nijje jama poanaje baꞌa: —Dejja, epona peaꞌai pana majje Eyacuiñajjiya oe epojja ejomishocajji acaꞌyonaje dejja cuana jomishocajji. Aꞌa jjashahuabaquijji jama baꞌa: “Epojja ejomishocajjijo eya jamatii anije”. ¡Cho, quea pame nee acue ma pojjajo! —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eya, ma ojjañaja Edoe Mese Emeshi Mese nei poani. Jamajjeya eyaya eyaye nei huohuije epojja ejomishocajjijo: ¡Quea pame nee nee acue! ¡Pea cuana quea jea nee acue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Majoya Jesosa Jodioja equi ejjachichaquijji yasijje poqui oꞌoya majje dobiquinaje. Jomajo dejja meshahuamaꞌyo epo aninaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jamajjeya Jesosa ba majje Paniseo cuana jama jjashahuabaquinaje baꞌa: —Esejaya etiiquiana jama poani baꞌa: “¡Aꞌa chacojji epojja ejomishocajjijo!” poani. Eꞌe pojjaꞌa Jesosa esejaya etiiquianaja esohui jama poaje, chaco ajja pojjaꞌa jjeya. Eꞌe pojjaꞌa oya chaco caje jjeya, epojja ejomishocajjijo; meshahuamaꞌyo epo pojjaꞌa jjameshahuanequi mee cajeꞌyo. ¡Cabaꞌajja sahua! —poanaje. Jesosa nijje mimijaji sa poanaje. Jamajjeya oya ba neinei canaje Paniseo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jamajjeya Jesosaa meshahuamaꞌyo epo iyaa canaje jama baꞌa: —¡Poecue e que! ¡Ojjaña cojja nei nequicue, eyiyesama neijo! ");
INSERT INTO eseNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Majoya oya nequisohuajo, Jesosa esohui jaahuanajji nijje, Paniseo cuana nijje jama poanaje baꞌa: —¿Yajja poani etiiquiana Moisesija esohui etehueꞌyo? ¿Aꞌa epojja ejomishocajjijo pea cuana quea pame acajji pojjaꞌa? ¿Aꞌa quea tai acajji pojjaꞌa? Jamajjeya ¿aꞌa emanojaa huaquia mee caꞌyojji epojja ejomishocajjijo? ¿Aꞌa mano mee cajji pojjaꞌa? —poanaje Jesosa. Jamatii Jesosa Paniseo cuanaja sajaꞌa jjima quea mimishi neija jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jamajjeya Jesosa ojjaña bajea majje quea quene nee nee poanaje. Ojjaña shajjamaꞌ poanijo oya quea yeno poanaje. Jamajjeya ohuaya meshahuamaꞌyo epo jama acanaje baꞌa: —¡Epeejji, miquea eme jeapisaꞌajjaꞌyo socue! —acanaje Jesosaa. Jamajjeya mejjajjaa emeꞌ jeapisa caꞌyonaje; pea mijijje jayojjaya poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jjeya nei Paniseo cuana esecue yasijje cuayaqui majje pea Jodio etii cuana nijje miminaje, emeshi mese Enodeja epeejji cuana nijje peaꞌai. Jama poanaje baꞌa: —¿Yajja amajje Jesosa quecua caꞌyojji soꞌo, de? —poanaje Paniseo cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Majoya Jesosa o shajjaꞌajjajji cuana nijje poquinaje. Janinea bae sahua huasijje poe oꞌoyanaje. Quea huiso nee nee onijje poquinaje Janinea meshijo baꞌeca cuana, Jodio meshijo baꞌeca cuana, ");
INSERT INTO eseNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jenosanenajo baꞌeca cuana, Idomea meshijo baꞌeca cuana, Jodana cuei ojje mijijje baꞌeca cuana, Tinojo baꞌeca, Sinonojo baꞌeca cuana peaꞌai. Jesosaa jjaajaqui mee caꞌyoqui shajjaꞌajja majje o que poeyanaje quea huiso nee nee, de. ");
INSERT INTO eseNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jamajjeya Jesosaa o shajjaꞌajjajji cuana huoojea canaje bishe jjequiya. Jama poanaje baꞌa: —¡Bishe jjequicue! Quea huiso nee nee nequicaa quishi ca chanaꞌ cuaa mo. Jamajjeya eyaya bishejo nequi majje ojjaña cuana sohuihuohuije. ");
INSERT INTO eseNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Eꞌe, yahuajo pishana Jesosaa quea huiso jjaajaqui mee caꞌyonaje. Jamajjeya quea huiso emano cuana Jesosa que jjachichaquinaje; mojoiya caꞌyonaje oja daqui napajji. Jama poanaje baꞌa: —Eꞌe, Jesosa daqui cuema napa majje jjaajaquijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jesosa ba majje eshahua cuana siasianaje. Niñepoqui cuana Jesosa cojja nei ecuiꞌoshajajo nequinaje o bihuiajji. Jama poanaje baꞌa: —Jesosa Quito, miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, oja Bacua Ejja quea pame nee —poanaje eshahua cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jamajjeya Jesosaa eshahua cuana tecueahuoojeacuayajea caꞌyonaje jama baꞌa: —¡Eshahua cuana, esohui oe caꞌacue! ¡Aꞌa ona huohuijji eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Majoya Jesosa jaasohuaquinaje eyiyo huasijje. Ojjaña ohua sa cani ohuaya iyaa canaje onijje epoquiꞌyojji. Jiquio dejja cuana o que poeyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Majoya ohuaya ome miji pea beca huisome, 12 huisome dejja babaca caꞌyonaje ojaya esohui huohuijji nei epojji. Oya cuana huohui canaje jama baꞌa: —Eyaya miquianaya babacanaje enijje eꞌanijji. Miquianaya huoojeaje ojjaña meshi yasijje ecuea esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesosaa oya cuana quea caꞌa po mee canaje eshahua cuana huoojeacuayajea meeꞌyojji, ojjaña emanojaa cuana huaquia meeꞌyojji, ejjaajaqui meeꞌyojji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesosaja huoojeaꞌyo esohui huohuijji ma bajjani baꞌa: Simohui, ma pea bajjani Peno; oja chahua Anesi; ");
INSERT INTO eseNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Semeneoja bacua ejja Jacobo, oja chahua Huani peaꞌai Jesosaa pea bajjani acaꞌyonaje Cueji bajjani, oja sohuijo ca ca Boaneje bajjani; ");
INSERT INTO eseNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Penipe; Matonome; Tomasi; Mateo, ma bejjo jjeshejji poani; Apeoja bacua ejja Satiaco; Simoni Senote; Taneo; ");
INSERT INTO eseNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jodasa Isicaniote, ma Jesosa iña meesahuajji poanaje dejja mimishija quecuaꞌyojji. Mahuiso Jesosaa babaca canaje ojaya esohui huohuijji epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Majoya Jesosa eyiyojo ani equi yasijje jaaoque oꞌoyanaje o shajjaꞌajjajji nei cuana nijje. Quea huiso nee nee o que jjachichaqui oꞌoyanaje. Quea huiso nee neejo Jesosa, o shajjaꞌajjajji cuana peaꞌai, ijjiaꞌijjia mee jjima acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma shajjaꞌajja majje ojaya enaese poeyanaje oja chahua cuana nijje Jesosa nahueya, Jesosa dojohua peaꞌai. Eꞌe, onaaya Jesosa niñeba canaje jama baꞌa: —Oya Jesosa niñe poquinaje —siajje poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Paniseo cuaa peaꞌai Jesosa niñeba canaje: —Eꞌe, Jesosa aje oe eyamiquecua pojjaꞌa. Ohuaya aje jja oe eshahua cuana huoojeacuayajea canaje Edosiquiana etii nijjeya, Satanasa bajjani, pea bajjani Meesemo nijjeya —poso acanaje Paniseo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Paniseo cuanaja ejjashahuabaquiꞌyojji quea tai Jesosaja eba poanaje. Jamajjeya oya cuana tecuea canaje jama baꞌa: —¡Shajjaꞌajjacue oe! ¿Aꞌa acuae jja Edosiquiaa, Satanasaa pea eshahua huoojeacuayajea came? ");
INSERT INTO eseNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chojja. Joya emeshi mese shajjaꞌajja sa po ajjajo, jjacuiaquianijo, dejja cuana ma meshijo baꞌe chamaꞌyo tii poajeꞌyo. Cuiñajjijo baꞌe cuana jamaya po peaꞌaije, chamaꞌyo tii poajeꞌyo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Huapa pojjeama cuana jjacuiaquianijo chamaꞌyo tii poajeꞌyo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jamaya peaꞌai Edosiquianaa, Satanasaa pea eshahua ehuoojeacuayaꞌyo jojjemo, chamaꞌyo tii poꞌyoqueaye —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Cuanaya bacue baꞌa: ¿Aꞌa dejja quea caꞌa nee jeyo jjima nequijo oja aquiana sii cajji? Chojja, o jeyo majje ojaya aquiana cuana sii caje cuaa. Jiquio ecua eꞌaquiana mese ebionei jeyo cani jama amajje eyaya eshahua cuana jeacuayajeaña —Jesosa poanaje peaꞌai—. ");
INSERT INTO eseNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jamajjeya eyaya miya eꞌe jojo nei huohuiaña: Eyacuiñajjiya ojjaña mimishi cuana, siajjepojji cuana peaꞌai cuijea cajeꞌyo. Eꞌe, eya ojjañaja Edoe Mese niñeba cajo cuaa, Eyacuiñajjiya ma mimishi cuijea cajeꞌyo peaꞌai, ojjaña mimishi cuana ohuaya cuijea cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jamatii Edojjoshahua Pamejo siajje poajo ca ca, Edojjoshahua Pame niñeba cajo ca ca, Eyacuiñajjija ma mimishi ecuijeaꞌyojji pojjeama tii tii. Jjeya ecuijeaꞌyojji pojjeama; quijje eya ecue Chii nijje eyajo ojjaña huoojeaꞌyojji poaje ecuijeaꞌyojji pojjeama tii tii poaje peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yahuajo Paniseo cuana Edojjoshahua Pamejo siajje poanaje jama baꞌa: —Jesosaa Edosiquiana nijjeya aje oe eshahua cuana dejjajo ani huoojeacuayajea cani —jamaya siajje poanijo, Jesosaa oya cuana tecuea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Majoya Jesosa mimianijo tii, ojaya enaese, oja chahua cuana peaꞌai poeyanaje. Esecuejo nequinaje. Onaaya Jesosa huohui canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","—Mique nae poeyanaje; esecuejo nequi, minijje emimijji —o pejjejo eꞌanioqueꞌaniya huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesosaa ojjaña ejjachichaquiꞌyo bajea majje jama acanaje baꞌa: —¿Ache acuae ecuea huapa pojjeama cuana soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","¡Bacue! Jiquio ecuea epeejji cuana ecuea huapa pojjeama cuana jama ecuea quea jea nee nee, ecuea ecue nae quea jea aña jayojja jama. ");
INSERT INTO eseNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eꞌe, ecue Chii eyajo ani; ojjaña joya ojaya ejjashahuabaquiꞌyojji jayojja jama baꞌyani, ojaya esohuijo jjashajjaꞌajjaquiani peaꞌai ecuea huapa pojjeama, ecue chahua, ecue jjoꞌi, ecuea enaese peaꞌai —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Majoya Jesosa equijo ani cuayaquinaje. Bae sahua huasijje poqui majje anioquenaje. Majoya o que jjachichaquinaje dejja cuana quea huiso nee nee. Jamajjeya bishe yasijje nequisohuaqui majje anioquenaje esohui huohuiya. Dejja cuana ca ca meshijajijo aninaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesosaa oya cuana sohuihuohui canaje quea huiso nee nee. Pea esohui ebameesahuajji huohui canaje ona jjashahuabaquijji. Jama acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—¡Bacue! Ebanajji poquinaje banaa. ");
INSERT INTO eseNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Esoꞌ jeaaja canijo, oe pojji esoꞌ oquequinaje ejiojji yasijje. Poeyanaje cuichojji cuana; ijjia canaje esoꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pea esoꞌ oquequinaje mei biajje. Meshi chamajo esoꞌ pohua cuajiꞌajjaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Quijje cuayanaje eshequi. Eshequi quea quiyo nee poajo, esoꞌ quiyomanoꞌyonaje. Esajja jocaꞌyajo manoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pea esoꞌ oquequinaje acuisha huasijje. Pohuaꞌyo majje jjonohua bebo caꞌyonaje. Tatajo nequi jjajja ajja poanaje; manoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pea esoꞌ ca ca oquequinaje meshi quea pame yasijje. Pohuaꞌyonaje esoꞌ cuana. Ejjajja quea pame nee nee poanaje. Oe esajo ejjajja iye huiso aninaje; pea esajo ejjajja quea huiso aninaje, pea esajo quea huiso nee nee aninaje. Sejja caꞌyonaje quea huiso nee. ");
INSERT INTO eseNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","¡Jamajjeya ecuea esohui shajjaꞌajjacue! ¡Jjashahuabaquicue! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Quijje pea cuana o shajjaꞌajjajji cuana nijje poeyanaje Jesosa que. Huohuiꞌajja canaje jama baꞌa: —Jesosa, ¿apiojji acuae miyaya esohui ebameesahuajji huohuiaña? Maya ecuanaja quea quehua pishana. ¡Ba meesahua socue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Oya cuana sajaꞌa canaje Jesosaa: —Miquianaya ca ca oe Eyacuiñajjiya ba meesahua cani eya ojjañaja Emeshi Mese nei poajeꞌyo. Yahuajo ba mee jjima poa. Pea cuana ca ca ba meesahua ajja. Jamajjeya eyaya esohui ebameesahuajji huohuinaje ona jjashahuabaquijji. ");
INSERT INTO eseNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jamatii ecuea esohui shajjaꞌajja majje oya cuana jjashahuabaqui ajja, jjashajjaꞌajjaqui ajja, de. Eꞌe, Eyacuiñajjija esohui huohuijji Isaia yahuajo nei nei jama poa baꞌa: “Shajjaꞌajja huichaꞌa huichaꞌa majje jamatii jjashajjaꞌajjaqui ajja poaje. Eyacuiñajjiya acani ba huichaꞌa huichaꞌa majje jamatii jjashahuabaqui ajja poaje. Ecuea esohui eba jojjemo, eshajjaꞌajja jojjemo jjabahuejjaquiꞌyome. Peaꞌai enijje ejjapeequiꞌyo jojjemo, eyaya mimishi cuijeaꞌyome”. Jamaya yahuajo nei nei tehue ca poa etiiquiana Isaiaa shajjamaꞌ cuanajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Majoya Jesosaa oya cuana jama acanaje baꞌa: —¿Aꞌa ma esohui ebameesahuajji miquianajaya quea quehua? ¿Jamajjeya achajja acuae oe miquianajaya eba poaje pea esohui ebameesahuajji? ¡Shajjaꞌajjacue! Eyaya miquianaya ba meesahuaje ecuea ehuohuiꞌyo ebanajjijo: ");
INSERT INTO eseNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jiquio ecua ebanajjiya esoꞌ jeaaja cani jayojja jama Eyacuiñajjija esohui huohuijjiya esohui huohui canaje ojjaña huasijje. Beca cuana ejiojji yasijje oquequi esoꞌ cuana cuichojjiya ijjiajeyo caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jamaya peaꞌai beca cuana ecuea esohui eya ojjañaja Emeshi Mese oe nei poaje shajjaꞌajja majje jamatii jjashahuabaqui ajja. Jamajjeya Edosiquiaa o que poe majje ecuea esohui pajea mee cani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Beca cuana esoꞌ mei biajje oquequinaje jayojja jama ecuea esohui shajjaꞌajja majje quea bihui nee enijje jjapeecuajiꞌajjaquiani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jamatii ecuea esohui jayojja jama baꞌe tiitii ajja. Esoꞌ mei biajje pohua esajja jocaꞌyajo manoꞌyani jayojja jama poani; pea cuaa oya napa cajje, Eyacuiñajji nijje jjapeepajeaquiꞌyani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Beca cuana esoꞌ acuisha nijje pohuani jama poani. Acuishaa bebo cajje jjajja ajja jayojja jamaya ecuea esohui shajjaꞌajja majje jjapee nishoquiani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Jamatii oya cuana quea bejjo nahue poanijo aquianajo quea huiso jjashahuabaquianijo, quea mete peaꞌai poanijo Eyacuiñajjijo chaco ajja. Esohui pajea cani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Esoꞌ meshi quea pame neejo pohua majje quea jjajja huiso poanaje jayojja jama ca ca beca cuana; ecue sohui shajjaꞌajja majje jjabahuejjaquiani; ecuea epeejji quea jaꞌa nee nee poani, pea cuana ejo jjabahuejjaqui meesahua cani; iye huiso pojjaꞌa, quea huiso pojjaꞌa, quea huiso nee nee pojjaꞌa —Jesosaa oya cuana acanaje. Mahuiso. ");
INSERT INTO eseNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Majoya Jesosaa pea esohui ebameesahuajji huohui canaje cuaquijijijo jama baꞌa: —¡Bacue! Cuaquijiji dedo majje eseyaya nequia ajja tepe quimejjejje. Ejaajji quimejjejje peaꞌai nequia ajja. Chojja, de. Acui ecaca biajje nequiaꞌaña equi jeajaꞌajji. ");
INSERT INTO eseNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jiquio ecua dedo majje cuaquijijiya eyajo nequiya ojjaña jeajaꞌa cani jama jayojja Eyacuiñajjiya ojjaña ecuea esohui onaya ba mee cajeꞌyo quijje. Eꞌe, ojjaña ecuea esohui miquianajaya eba jjeya, Eyacuiñajjiya quijje pea cuana ba mee cajeꞌyo. Quea jaꞌa nee poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Jamajjeya miquianaaya quea shajja jaꞌaa shajjaꞌajjacue! ¡Ecuea esohuijo jjashahuabaquicue! ");
INSERT INTO eseNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Majoya Jesosa ojjaña nijje jama poanaje peaꞌai baꞌa: —¡Ecuea esohui shajjaꞌajja majje ecuea esohui shahuaba neineicue; jama acue! Eꞌe jjashahuaba neineiquianijo, Eyacuiñajjiya miquianaya quea huiso nee nee ba meesahua caje. Oe pojji jjashahuabaquianijo ca ca oe pojji ba meesahua caje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jamajjeya joya Eyacuiñajjija esohui ba cani quea huiso pishana, quijje quea huiso nee ba mee cajeꞌyo. Joya ojaya esohui ba sa po ajja ca ca pajea cajeꞌyo. Mahuiso —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Majoya Jesosaa oya cuana huohui canaje pea esohui ebameesahuajji. Jama poanaje baꞌa: —Eyacuiñajjija esohui ejo ebanajjiya esoꞌ bana canaje jama. Esoꞌ ache bame nee quecua canaje quejo, anoso pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Majoya ojjaña echacojji cuana ecahuijaajo, epojjajo poꞌayequiequijo peaꞌai esoꞌ pohuani, tiiani peaꞌai. Jamatii ojaya ba jjima achajja shai esoꞌ tiiani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Eꞌe, meshi quea pame neejo bana esoꞌ jamatii pohuani, tiiani. Tii majje jjajjani. Majoya jamatii jahuani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jahuajo, eque meseya echacojji cuana huoojea cani anoso sejjaꞌyohua. Jiquio ecua esoꞌ tii majje quea jjajja huiso poani jayojja jama ecuea epeejji cuana jjeya oe pojji yani; jamatii quijje quea huiso nee nee poajeꞌyo. Majoya ojjaña jjachichaqui mee cajeꞌyo Eyacuiñajji cojja nei enequijji —jamaya Jesosaa huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Majoya Jesosaa pea esohui eba meesahuajji huohui canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Eyacuiñajjija esohui ojaya epeejji cuanajo jama peaꞌai baꞌa: Motasa bajjani esoꞌ bana cani equi quibojo. Jiquio esoꞌ che biso nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tii majjeya ca ca quea cui quemo nee poaje, apoꞌe cui quemajja. Jamajjeya cuichojji cuana poeyani motasa acui biajje cahuiya —jamaya Jesosaa huohui canaje ojjaña ba meejji quijje Eyacuiñajjija epeejji cuana quea huiso nee, quea caꞌa nee nee po mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Quea huiso nee pea esohui ebameejji Jesosaa huohui canaje Eyacuiñajjija esohui eba meesahuajji. Onaya quea jjashahuabaqui jaꞌa pishanajo mi huohui tiitii canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Esohui ebameesahuajjijo ca ca oe ojjaña sohuihuohui canaje Jesosaa. Majoya ona poquiꞌyajo ohuaya o shajjaꞌajjajji nei ba meesahua canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma pojjajoya siniajo Jesosaa o shajjaꞌajjajji cuana iyaa canaje; jama acanaje baꞌa: —Cuaꞌa, Janinea bae ojje miji yasijje ebesapoqui —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jamajjeya ojjaña cuana bae sahuajo ani equi yasijje huoojea majje o shajjaꞌajjajji cuana bishe ai yasijje nequisohuaquinaje Jesosa ani yasijje, ojje besapoquinaje. Pea cuana ca ca bishe sisi cuanajo besapoquinaje Jesosa quishishi. ");
INSERT INTO eseNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","O besapoquianijo beni quea quemo nee nee poeyanaje. Ena shajohua bishe nane canaje. Jeasohuajea canaje. Cuio canaje enaa. ");
INSERT INTO eseNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bishe ai yiyedojjojo Jesosa cahuijaanaje, ehuojjajaajji biajje jaa. O shajjaꞌajjajji cuaa quea mete po majje Jesosa ishe acanaje. Jama poanaje baꞌa: —Emeshi Mese Jesosa, ¡shequicue oe! ¡Coya aje se huiꞌiꞌya! —taaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Shequiꞌyo majje Jesosa nequisohuanaje. Beni tecuea canaje jama baꞌa: —Beni, jamaya, ¡nequioquequicue oe! —majoya bae ena nijje jama poanaje—; ¡aꞌa enashajo pojji! O jama mimime poajo, enashajo popajeaꞌyonaje. Ena shajomaꞌyo poanaje. Beni popajeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Majoya Jesosaa o shajjaꞌajjajji cuana jama acanaje baꞌa: —¿Apiojji acuae nequiana quea mete nee nee poani? ¿Aꞌa mi ejo eꞌe nei pojjeama poani? Jamajjeya meteani. ");
INSERT INTO eseNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jamajjeya oya cuana bishe aijo ani Jesosajo quea bihui nee poanaje. Ojee miminaje jama baꞌa: —¡Ache dejja shai jiquio quea sohui poja nee nee! Beniya, enashajo cuaa peaꞌaiya oja sohui shajjaꞌajja cani —ojjaña poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesosa o shajjaꞌajjajji cuana nijje besapoquinaje Janinea bae ojje miji yasijje, Jjanana meshi yasijje, Jenesane dejja cuanaja meshi yasijje. Jesosa bishe aijo ani baꞌeñaqui majje etaja huasijje nequisohuaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma meshijo dejja niñepoqui quea mase nee nequi. Eshahua quea huisohua oja eyami nequijji acaꞌyajje, ma dejja jjanijo emanoꞌyo saꞌ jaajo nequinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Majo tii oya baꞌeꞌyonaje jjanijo, ma emanoꞌyo huananobia cajjijo tii. Oya quea mase nee nee jjejojo jeyoꞌajja canaje cuaa cadenaa. Jjajeyo meequi ajja, quea caꞌa nee nee poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yahuajo onaaya ojaya emeꞌ, ejiojji peaꞌai jeyoꞌajja huichaꞌa huichaꞌa canaje cadenaa, jjonohua peaꞌai. Jamatii ohuaya cadena cuana jjequisejjajea canaje, sejjaquipiquipijea canaje. Onaaya oya jjabahuone meequi ajja, quea mase, quea caꞌa, de. ");
INSERT INTO eseNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mecajje, epojjajo peaꞌai oya eyiyo cuanajo, jjani cuanajo peaꞌai siasiaꞌaniꞌyonaje. Jjajehuijeaquiꞌaninaje meiya. ");
INSERT INTO eseNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jamajjeya oya niñepoqui Jesosa quea huesha nee ba majje o que jaaoquecuajinaje. Quea ajjajja jjejojo ecuiꞌoshajjajo nequinaje Jesosa bihuiajji. ");
INSERT INTO eseNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jamajjeya Jesosaa eshahua huoojeacuayajea caꞌyonaje; jama poanaje baꞌa: —¡Eshahua dejjajo nequi, cuayaquiꞌyocue! —Jesosaa acanaje. Eshahua taaa neineinaje jama baꞌa: —Jesosa, miya Eyacuiñajji quea caꞌa neeja Bacua Ejja. ¡Aꞌa jjeya eya quea nee nee po meejji! Eyacuiñajji huohuicue jama baꞌa: “Jjeya eshahua ecuea enapajji pojjeama” acue —eshahua poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","10","—¿Ae bajjani miya? —Jesosaa oya acanaje. —Ecuana quea huiso neejo Quea Shahua Huiso bajjani —sajaꞌa canaje niñepoquiya—. Che mo miyaya ecuana dejjajo nequi cuayaqui meeꞌyo majje ¡aꞌa quea huesha nee huoojeajji! —poanaje eshahua cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Quea chipi nee cuichi cuana quea huiso ijjiaꞌijjia nequi. ");
INSERT INTO eseNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jamajjeya eshahua cuaa Jesosa jama huohuime acanaje baꞌa: —Che ecuana dejjajo nequi huoojeacuayajea majje ¡cuichi cuana huasijje ecuana huoojeaꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Eꞌe, ¡poquicue cuichi cuana huasijje! ¡Dobiquicue! —Jesosa poanaje. Jamajjeya dejja niñepoqui jeananaꞌyo majje eshahua cuana cuichi cuana huasijje dobiquinaje, ojjaña. Dobiqui majje cuichi cuana cuajicuaji jaaoquequinananaje. Bae quea sahua doe nee nee yasijje cuichi cuana huiꞌiꞌyonaje, ojjaña, beca mil huisome. ");
INSERT INTO eseNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ba majje cuichi jaahuanajji cuana jjajjasoaquinaje. Cuajicuajipoquinaje cuiñajji yasijje huohui pohua. Ojjaña equi yasijje huohui capoquinaje eshahua cuanajo. Cuichi cuanajo, dejja niñepoquiꞌyo jjima po mee canajejo peaꞌai huohui canaje. Jamajjeya ojjaña cuana ma cuiñajjijo baꞌe poeyanaje Jesosa baa; dejja niñepoquiꞌyo jjima baa peaꞌai: —¿Ae shai poanaje, de? —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesosa que poe majje ojjañaa dejja niñepoquiꞌyo jjima ba canaje. Jjeya oya quea bei nequi, daquijji, quea pame nee jjashahuabaquiani. Eshahua cuana chamaꞌyo. Jamajjeya ojjaña cuana quea mete poanaje Jesosajo, ");
INSERT INTO eseNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","eshahua huoojeacuayajea mee caꞌyonajejo, cuichi cuana ehuiꞌiꞌyojojo peaꞌai. Jamajjeya cuichi jaahuanajji cuaa pea cuana huohui majamaja canaje niñepoquijo, Jesosaa eshahua huoojeacuayajea canajejo, cuichi ehuiꞌiꞌyojojo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ojjaña quea mete nee poanaje. Huohui canaje jama baꞌa: —¡Jesosa, pea meshi yasijje poqui socue oe! Quea mete ca iña mijo mi quea sohui poja nee nee jojoya —poanaje ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jamajjeya Jesosa bishe ai yasijje nequisohuaquinaje ojje ebesapoquiꞌyojji. Dejja ma niñepoqui poanaje onijje poqui sa poanaje, onijje eꞌanijji. ");
INSERT INTO eseNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jamatii Jesosaa oya jama acanaje baꞌa: —Chojja, ¡miquea equi yasijje poquicue! ¡Miquea huapa pojjeama cuana huohuicue ejo, Emeshi Mese neijo, ma miya ecuea quea boti neejo quea pame nee anaje huohuicue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jamajjeya ojaya equi yasijje poqui majje ohuaya Jesosajo huohui canaje. Ome Miji peaꞌai Cuiñajji yasijje huohui canaje peaꞌai. Ojaya esohui shajjaꞌajja majje ojjaña quea bihui nee poanaje: —¡Ache dejja quea caꞌa nee nee Jesosa! ¡Eshahua cuana huoojeacuayajea caꞌyonaje, de. Eꞌe e, dejja niñepoqui quea pame nee jjeya, de! —poanaje ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Majoya Jesosa o shajjaꞌajjajji cuana nijje bae ojje miji yasijje poqui oꞌoyanaje bishejje. Quea huiso cuana jjachichaqui oꞌoyanaje o que, Janinea bae sahuajo. ");
INSERT INTO eseNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jesosa ojjaña cuana nijje mimianijo, pea Jodio dejja o que poeyanaje Jaino bajjani, ma Jodioja ejjachichaquijji equi jaahuanajji poani. Ecuiꞌoshajjajo nequiya oya bihuia canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jama poanaje baꞌa: —Esohui huohuijji, ecuea ebacua piona quea mano nee nee jaa, beshahua nee poquijeyonaje. ¡Ecuea equi yasijje poecuajicue o napaꞌajjaa emeya! Jamajjeya oya huaquiajeꞌyo. Quea aja nee poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nequisohua majje Jesosa o shajjaꞌajjajji cuana nijje poquinaje Jaino nijje. Quea huiso cuana poquinaje onijje peaꞌai, ojjaña Jesosa nijje nequi canaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Poquije, oe eponaa Jesosa ba canaje. Oya quea mano, najji popajeaꞌyo ajja. Ome miji pea beca, 12 shequiajame na cuayapajeaquiꞌyo ajja poa. ");
INSERT INTO eseNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Quea huiso eshicuijji quiajji cuaa oya na cuayapajeaqui meeꞌyo jjima acanaje. Jamajjeya eshicuijji sosejje ojjaña ojaya ejjeshejji oe poanaje. Jamatii naꞌ huosa jjima tii, quea nee tii. Yahuajo quea mano pishana poanaje; jjeya ca ca quea mano nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesosajo shajjaꞌajja majje, ma Jesosaa ojjaña huaquia mee cani shajjaꞌajja majje oya poeyanaje o que. Quea huiso nequi dejja tejjee poeyanaje epona. ");
INSERT INTO eseNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jamaya oya jjashahuabaquinaje baꞌa: —Eya Jesosa daqui napa majje na huosajeꞌyo —jama jjashahuabaquimeya poanaje epona. ");
INSERT INTO eseNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jamajjeya Jesosaja daqui quehuajje napa canaje. Jjeyahua nei najji po pajeaꞌyonaje. Ma epona quea bihui nee jjashahuabaquinaje: —Eꞌe e jjeya nei eya na cuayapajeaquiꞌyonaje, apoa poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesosa epona nahuosa meeꞌyo jeahuajo jjashahuabaquinaje jama baꞌa: —Eꞌe nei, jjeyahua nei Eyacuiñajjiya aꞌya shai huaquia mee caꞌyonaje e daqui napaꞌajja cajo. Jjeyahua nei Jesosa jjabajeaquinaje. Ojjaña cuana ejjachichaqui nequi huohuiꞌajja canaje jama baꞌa: —¿Aya acuae ecuea daqui napaꞌajja canaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","O shajjaꞌajjajji cuana onijje jama poanaje baꞌa: —Jesosa, quea huiso nee nee ejjachichaqui nequi minijje. Jamajjeya ¿yajjajje shai miyaya huohuiꞌajjaña jama baꞌa: “¿Aya shai ecue daqui napaꞌajja canaje?” ");
INSERT INTO eseNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesosaa ca ca bajea neinei canaje epona ena huosaꞌyo ebajji. ");
INSERT INTO eseNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jamajjeya ma epona ojaya emanomeejji chamaꞌyo ba majje Jesosa que poquiꞌyonaje; Jesosa yajjajo piopionaje. Ecuiꞌoshajjajo nequiya Jesosa huohui canaje ohua naꞌ huosa mee caꞌyajje. Ojjaña huohui canaje eponaa. ");
INSERT INTO eseNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Majoya Jesosaa oya acanaje jama baꞌa: —¡She, quea bihui nee pocue! Miya quea jaꞌa jjashahuabaquinaje jama baꞌa: “Eꞌe jojo nei Jesosaa eya huaquia mee cajeꞌyo”. Jamajjeya eyaya miya huaquia meeꞌyonaje. ¡Quea quijijji jaji oe poꞌyocue! ¡Aꞌa manoshishi oꞌoyajji! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Majoya Jesosa epona nijje mimianijo tii, Jainoja epeejji poeyanaje. Jama poanaje baꞌa: —Jaino, miquea ebacuase manoꞌyonaje. Chamaꞌyo tii poꞌyonaje. ¡Jamajjeya esohui huohuijji aꞌa iyaajji equi yasijje o baa! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jiquio esohui shajjaꞌajja majje Jesosaa Jaino jama acanaje baꞌa: —¡Aꞌa quea yeno pojji! Jamaya jjashahuabaquicue baꞌa: “Jesosa quea caꞌa nee nee. Ohuaya ecuea ebacuase shequi mee cajeꞌyo eꞌe jojo nei” acue. ");
INSERT INTO eseNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Majoya Jesosaa pea cuana huoojea canaje jama baꞌa: —¡Aꞌa enijje poquijji! —poanaje. Jamajjeya Jesosa, Peno, Satiaco, oja chahua Huani ca ca oe Jaino nijje poquinaje oja equi yasijje, oja bacua baa. ");
INSERT INTO eseNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jainoja equi yasijje poqui majje ba cañaquinaje quea huiso dejja cuana, ponaña peaꞌai equijo nequi. Epona shoꞌi emanoꞌyojo ojee paꞌani. Ojjaña quea shajjaquijjo poani. Dehue mia cani emojeaꞌyojjijo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Equi yasijje dobiqui majje Jesosa jama poanaje baꞌa: —¿Yajjajje acuae pa neineiani, quea shajjaquijjo nee poani nequiana? Jiquio epona shoꞌi epoquijeyoꞌyo pojjeama. Oya cahuijaa. ");
INSERT INTO eseNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","—Chojja de, oya manoꞌyonaje, de; shequiꞌyo ajja —poanaje cuana. Ojjaña cuana esecue yasijje huoojeacuayajea majje Jesosa o shajjaꞌajjajji cuana nijje, ejeajji nijje, enaese nijje cuanaya epona shoꞌi jaa huasijje dobiquinaje pea equecuayijji yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Meꞌ iña majje epona shoꞌi oja sohuijo huohui canaje: —¡Tanitacomi! Ese Ejja esohuijo ca jama poanijje baꞌa: —¡Epona shoꞌi, nequisohuacue! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Meꞌ iña majje epona shoꞌi shequi mee caꞌyonaje. Jjeyahua nei oya nequisohua majje jeoꞌyonaje. Eꞌe, oya etii pishana, ahuemaꞌ ani, 12 shequiajame. Jamajjeya epona shoꞌi shequi mee caꞌyonaje ba majje ojjaña cuana jjajjasoaquinaje; jama poanaje baꞌa: —¡Eꞌe jojo nei Jesosa jjashequimeequiꞌyojji, de! Jiquio epona shoꞌi emanoꞌyojaa jjeya nei shequi mee caꞌyonaje, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesosaa ojjaña huohui canaje jama baꞌa: —Eꞌe, ¡jamatii aꞌa jjeya pea cuana huohuijji jiquio eya mique bacua shequi meeꞌyonajejo! Majoya Jesosa jama poanaje enaese nijje, ejeajji peaꞌai nijje baꞌa: —¡Miquea ebacua piona bobiacue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Majoya Jesosa jomajo ani poqui oꞌoyanaje ojaya cuiñajji yasijje, Nasanena huasijje. O shajjaꞌajjajji cuana nijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Epojja ejomishocajjijo Jodioja equi ejjachichaquijji yasijje poqui majje dobiquinaje. Esohui huohui canaje. Ojaya esohui shajjaꞌajja majje ojjaña cuana quea tecue nee poanaje, Nasanenajo baꞌeca cuana. Oya Jesosa Joseja jea poso acanaje cuaa. —¡De! ¿Yajjajje shai jiquio dejjaa Jesosaa esohui quea jaꞌa nee nee huohui cani? ¿Eyacuiñajji jayojjaya jjaajaqui mee caꞌyani emanojaa quea huiso nee, de? ");
INSERT INTO eseNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Oya aje oe acui cacajjija bacua ejja pojjaꞌa. Oja nae Mania bajjani, oja chahua cuana Jacobo, Jose, Simohui, Jonasa peaꞌai bajjani. Oja jjoꞌi cuana peaꞌai jiquiojo baꞌe. Jamajjeya quea quene poanaje Jesosa nijje; Joseja jea poso cajaa acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jamajjeya Jesosaa oya cuana jama acanaje baꞌa: —Eꞌe de, pea cuaa Eyacuiñajjija esohui huohuijji shajjaꞌajja cani. Jamatii ojaya cuiñajjijo ojaya huapa pojjeama cuana ca ca oe o shajjaꞌajja sa poꞌyo ajja. Oya jayojjaya miquianaya e shajjaꞌajja sa poꞌyo ajja. ");
INSERT INTO eseNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jamajjeya oya cuana shajjaꞌajja sa poꞌyo ajjajo, oya Eyacuiñajjija Bacua pojjeama posojo, Jesosaa oe pojji napaꞌajja cajje jjaajaqui mee caꞌyonaje. Ma dejjaa ajjima acani oe pojji nei acanaje Nasanenajo. ");
INSERT INTO eseNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jamajjeya Jesosa jjashahuabaquinaje jama baꞌa: —¿Yajjajje shai Nasanenajo baꞌeca cuana quea sapa caꞌa poani? Ejo eꞌe nei jjashahuabaqui ajja —poanaje. Jamajoya Jesosa o shajjaꞌajjajji cuana nijje poquinaje quea huiso cuiñajji sisi cuana huasijje esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Majoya Jesosaa o shajjaꞌajjajji 12 huisome iyaa canaje o que. Oya cuana quea caꞌa po mee canaje eshahua cuana huoojeacuayajeaꞌyojji, ojjaña emanojaa cuana huaquia meeꞌyojji, ejjaajaqui meeꞌyojji peaꞌai. Oya cuana becanejjijji peaꞌai huoojea canaje ojaya esohui shajjaꞌajjajji cuana pea cuiñajji cuana huasijje ojaya esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Huohui canaje jama baꞌa: —¡Jjeya aꞌa aquiana dojojji! ¡Oe acui ejjaquecuacaꞌaquijji dojocue, beca pojjeama! ¡Bashosoco bobi dojojji aꞌa dojojji! ¡Ejjeshejji, bobi peaꞌai aꞌa dojojji! ");
INSERT INTO eseNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","¡Ejiojji shejee oe huoshoꞌyocue! ¡Daqui oe nei, ma miquea eyamijo baꞌe nei oe dojocue, beca pojjeama! ");
INSERT INTO eseNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","¡Pea cuiñajji yasijje poqui majje saꞌajjacue oe dejja miquea epeejji epojji, joya bei bei! ¡Ojaya equijo anicue ma cuiñajjijo nequi majje! ");
INSERT INTO eseNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eꞌe pojjaꞌa beca equijo, beca cuiñajjijo miquea esohui shajjaꞌajja sa poꞌyo ajjajo, niñeba canijo peaꞌai, ¡oya cuana jeajeanaꞌyocue! Poquijeꞌyohua jama acue baꞌa: “Eyaya miquianaya cajaa ajeꞌyo, quea mimishi mi coma. Eyacuiñajjiya miya ba cani quea mimishi nee nee. Ohuaya miya quea nee nee po mee cajeꞌyo” acue —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jamajjeya Jesosa shajjaꞌajjajji cuana poquinaje. Ojjaña cuiñajji cuana huasijje esohui huohui canaje. Jama poanaje baꞌa: —¡Miquea mimishi cuanajo quea yeno pocue! ¡Mimishi pajeaꞌyocue Eyacuiñajjija epeejji epoꞌyojji! —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Quea huiso eshahua cuana dejja cuanajo nequi huoojeacuayajea caꞌyonaje. Quea huiso emanojaa cuana acuijjajja seiyiya shicui majje jjaajaqui mee caꞌyonaje, huaquia mee caꞌyonaje peaꞌai, Jesosa shajjaꞌajjajji cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesosa Janinea meshijo anijo, Janinea meshi meseya Enode Antipa bajjaniya shajjaꞌajja canaje onaja ehuohuiꞌyo ojo. Beca cuana Jesosa Huani shequi oꞌoyanaje poso acanaje jama baꞌa: —Eꞌe nei jiquio dejja aje oe Huani, ma ona besameejji poa. Eꞌe pojjaꞌa oya manoꞌyo majje shequi oꞌoyanaje. Jamajjeya ohuaya Eyacuiñajjiya jayojjaya acani, ma dejjaa ajjima acani —poanaje beca cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pea cuana ca ca jama poanaje baꞌa: —Chojja, oya etiiquiana Enia, ma yahuajo nei Eyacuiñajjija esohui huohuijji poanaje poe oꞌoyanaje. Pea cuana ca ca jama poanaje baꞌa: —Oya ca ca oe Eyacuiñajjija esohui huohuijji eyacua, yahuajo nei nei baꞌe Eyacuiñajjija esohui huohuijji jayojja jama. ");
INSERT INTO eseNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Enode Antipa ca ca onajaya ehuohuiꞌyo Jesosajo shajjaꞌajja majje quea mete nee jama poanaje baꞌa: —Eꞌe de, yahuajo ecuea esohuijo Huani sapa jajasejja ca poa. Oya shequi oꞌoyanaje eꞌe jojo nei. Jamajjeya Eyacuiñajjiya jayojjaya acani ma dejjaa ajjima acani; quea huiso huaquia mee cani —poanaje Enode. ");
INSERT INTO eseNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eꞌe, yahuajo emeshi mese Enode Antipaja edoe mese Penipeja ehuanase Enodiasi bajjani Huani nijje quea quene nee nee poa. Jamajjeya Enode Antipaya Huani iña mee ca poa; jeanobiajea mee ca poa. Enodiasiya aje oe oja yahue huei ca poa Enode nijje ebaꞌejji, ojaya esha mese nijje ebaꞌejji. ");
INSERT INTO eseNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jamajjeya Huaniya yahuajo Enode Antipa jama tecueame aca poa baꞌa: —¡Miyaya aje oe mique doeja, Penipeja ehuanase Enodiasi aꞌa huanaꞌyojji! Jamaya quea mimishi —Huaniya aca poa. ");
INSERT INTO eseNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jamajjeya ohua tecuea cajje quenequenea poa Enodiasi Huani nijje. Quecua sa aca poa. Jamatii quecua jjima; ");
INSERT INTO eseNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","oya Enode quea mete poanaje. Oya jjashahuabaquinaje Huani Eyacuiñajjija esohui huohuijji nei neijojo, ojaya epeejji nei poanaje. Jamajjeya nahue canaje Enodiasiya equecua ca poaje jjejojo. Huanija esohui shajjaꞌajja sa poa Enode Antipa, jamatii ojaya quea quehua. Huani equi ejjajeanobiaquijjijo jaa iyaa huichaꞌa huichaꞌa canaje esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jamatii quijje Enodiasiya Huani sapa jajasejja mee canaje. Jiquio jama poanaje baꞌa: Enodeya o cuaya poa pojjajo ojjaña ojaya epeejji cuana iyaa canaje ojee ijjiaꞌijjiaa, majamajaqui baa peaꞌai. Ojaya echaco meesahuajji, dejja etii cuana, sohuinano huoojeajji poani cuana peaꞌai, Janinea meshijo baꞌe dejja etii cuana peaꞌai quea huiso nee nee iyaa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ojjaña ijjiaꞌijjiaꞌanijo, Enodiasija bacuase peaꞌai oe nei majamaja nequinaje ojjañaja ebajji, quea bihui nee epo meejji. Enode Antipa quea bihui nee nee poa epona shoꞌijo. Jamajje onijje miminaje jama baꞌa: —¿Ae shai sa miya poani? ¡Huohuicue mo! Eyaya joya miya sañaya quiaje eꞌe jojo nei, she —acanaje Enodeya—. ");
INSERT INTO eseNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eꞌe jojo nei she coya miya saje aje mi quiaje; miya huohuiañaya ca mi ca quiaje, ecue meshi sejja aje mi quiaje miquea epojji —huohui neinei canaje Enodeya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jamajjeya epona shoꞌi poquinaje ojaya enaese Enodiasi huohuiꞌajjaa. —Eꞌe —oja nae poanaje—, eꞌe, ¡Huani sapa jajasejjajea meequicue she! ");
INSERT INTO eseNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Epona shoꞌi poe oꞌoyanaje Enode que. Huohui canaje jama baꞌa: —Huani, ma ona besameejji poani ejeanobiajaa. ¡Ojaya esapa jajasejjajeaꞌyo majje piatojo jjequicue jjeyahua nei! Maya eya sa poani. ");
INSERT INTO eseNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma shajjaꞌajja majje emeshi mese Enode quea ajjajja nee nee poanaje. Jamatii ojaya esohui epona shoꞌi nijje ojjaña ojaya epeejji cuanaa shajjaꞌajja canaje. Jamajjeya ojaya esohui pajea ajja, Enodeja. ");
INSERT INTO eseNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jamajjeya ohuaya sohuinano cuana huoojea canaje: —¡Epona shoꞌija esohui jayojja jama acue! ¡Huani ma ejeanobiajaa oe sapa jajasejjajeaquicue! ¡Jjequicue jjeyahua nei! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jjeyahua nei sohuinano cuana poquinaje Huani que. Huani sapajajasejjajea caꞌyonaje. Esapa jjequi canaje piatojo. Epona shoꞌi quia canaje. Majoya ohuaya Huanija esapa oja nae yasijje quia cañaquiꞌyonaje, epona shoꞌiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Majoya aje oe Huani shajjaꞌajjajji poani huohui canaje cuaa. Jamajjeya oya cuana poeyanaje o dojoꞌyohua, emojeaꞌyojji. Mojeaꞌyo majje papoquiꞌyonaje Jesosa huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Majoya quijje pishana Jesosaja huoojeaꞌyo cuana ojjaña cuiñajji yasijje esohui huohuiya poqui huacuaya poe oꞌoyanaje o que. Oya cuana huohui poñaquinaje ojjaña ohua acanaje, ojjaña ojaya esohui ma ohua huohui canaje peaꞌai huohui canaje Jesosa huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Quea huiso nee nee dejja poe majamajanijo ijjiaꞌijjia meemee ajja. Jamajjeya Jesosaa oya cuana acanaje: —¡Cuaꞌa, dejjama huasijje ejomishocaqui! Quea huiso nee nee ejjachichaqui nequi cuaa se ijjiaꞌijjia mee jjima acaje —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jamajjeya Jesosa o shajjaꞌajjajji nijje nequisohuaquinaje bishe ai yasijje. Besapoquinaje quima huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jamatii Jesosa besapoquije ba majje quea huiso dejja cuana cuiñajji cuanajo baꞌe ejiojjijje poqui canaje Jesosa baa. Poquicuajinaje ma Jesosa besapoquije yasijje. Ebionei jjaja onaya aniñaquinaje, Jesosa hui que añaquiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Quijje pishana Jesosa o shajjaꞌajjajji cuana nijje baꞌeñaquinaje. Bishe aijo ani nequisohuaquinaje etaja huasijje. Quea huiso nee nee cuana ba cañaquinaje. Onajo Jesosa quea yeno jjashahuabaquinaje. Eꞌe, oya cuana quea yeno, quea mano nee ñajjajja jaahuana jjima jayojjaya. Jamajjeya oya cuana sohuihuohui canaje quea huiso nee nee Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Siniajo Jesosa que poe majje o shajjaꞌajjajji cuaa huohui canaje jama baꞌa: —Jesosa, sinia coma, de. Chamaꞌ jiquiojo bobi, equi peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","¡Dejja cuana huoojeacue cuiñajji sisi cuana huasijje oja bobi jjesheya! ");
INSERT INTO eseNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Chojja. Caꞌaniahua cuana. ¡Bobiacue oe miquiaaya! —Jesosaa acanaje. —¿Yajja yajji? Ecuanaa bobi quea huiso nee nee jjeshe ajja. Quea nahue nee nee, de, 200 epojja echacojji sosejje. Eꞌe, quea huiso pojjajo chaco majje sosejje, pahui jjeshe cajji, ca ojjaña bobiajji. ");
INSERT INTO eseNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jamajjeya Jesosaa jama acanaje baꞌa: —¿Ache huiso pahui yani esejaya? ¡Pahui baquicue! Ba majje oya cuana jama poanaje baꞌa: —Jesosa, esejaya bobi oe pojji yani. Me oejje pahui, beca nahuoo sisi yani peaꞌai —poanaje o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesosa jama poanaje baꞌa: —Ojjaña cuana jama acue baꞌa: “¡Ojjaña anioquecue sipone biajje!” acue —Jesosaa acanaje—. ¡Ojee jjaꞌanichicha meequicue! ¡Anijji becabeca anioque meeme acue! ");
INSERT INTO eseNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jamajjeya quea huiso sipone yanijo, ojjaña cuana anioque mee canaje sipone biajje. Jomajo iye huiso anioquenaje, 50; quea huesha pishana iye huiso anioquenaje, 100. Jamaya anioque bamebamenaje cuana ojjaña, de. ");
INSERT INTO eseNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Majoya Jesosaa me oejje huiso pahui, nahuoo sisi becanejjijji peaꞌai jjeshe majje eyahuasijje jjabajeasohuaquinaje Eyacuiñajji nijje emimijji. Bobijo mimi majje pahui miji canaje. O shajjaꞌajjajji cuana quia mee canaje dejja cuana eꞌanioqueani yasijje. Nahuoo sisi peaꞌai miji majje quia mee canaje ojjaña huasijje. Quia capoquijeya quea huiso nee nee jjapanaqui poquipoquinaje bobi, de. ");
INSERT INTO eseNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jamajjeya ojjañaa ijjia neinei canaje. Quea jejje poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ojjaña jejje majje eshajjaꞌajjajji cuaa chicha caꞌyonaje bobi ojjañaja ijjiasejja. Jjepai ai yasijje iya caꞌyonaje. Quea huiso nee poanaje, 12 jjepai huisome quea cuata poanaje bobi eꞌijjiasejja. ");
INSERT INTO eseNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eꞌe, Jesosaa quea huiso nee nee bobia canaje, de, 5.000 dejja. ");
INSERT INTO eseNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jjeyahua nei siniajo Jesosaa o shajjaꞌajjajji cuana huoojea canaje. Jama acanaje baꞌa: —¡Bishe ai yasijje nequisohuaquicue! ¡Bae ojje miji yasijje besapoquicue Betesaida cuiñajji yasijje! Quijje eya poquije mi que, pea cuana huoojeaꞌyo majje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Majoya dejja cuana quea huiso cuana huoojeaꞌyo majje Jesosa eyiyo huasijje jaasohuaquinaje oe nei oja Chii nijje mimiya. ");
INSERT INTO eseNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mecajje Jesosa oe nei jomajo aninaje, eyiyojo. O shajjaꞌajjajji cuaa ca ca bishe ai quea huesha nee yo canaje, bae yiyesama huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jomajo ani Jesosaa oya cuana ba canaje, janobajjima nei yoyoꞌajja baꞌe. Eꞌe, beni quea quemo nee poeyanaje. Bishe cuiajea caꞌyonaje huacuaya. Enashajohua bishe janobajjima nei nane canaje, cuio canaje enaa. Mecashono quea apo nee nee poanaje. Jamatii Jesosa eyiyojo ani o que poquinaje ena biajje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesosa ena biajje jeojeojebeje ba majje o shajjaꞌajjajji cuana quea mete nee nee poanaje. Quea metejo taaanaje jama baꞌa: —¡Coya ae shai poeje baꞌa! —siasianaje—. ¡Coya eshahua, de! ");
INSERT INTO eseNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jamajjeya Jesosaa oya cuana huohui canaje jama baꞌa: —¡Aꞌa quea mete pojji! Eya jja iña jiquio, eshahua pojjeama. ¡Quea jaji nee pocue! ");
INSERT INTO eseNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Majoya Jesosa bishe ai yasijje aniajo, beni nequioquequiꞌyonaje. Jamajjeya ojjaña cuana bishe aijo aniya jjajjasoaquinaje. Quea jaji nee poꞌyonaje: —Eꞌe pojjaꞌa, eꞌe jojo nei, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eꞌe, Jesosaa ma dejjaja ba jjima acanaje; 5.000 dejja cuana bobia canaje me oejje pahuijo. Jamatii oya cuanaja eba pojjeama Jesosa quea caꞌa nee nee, ojjaña acani. Oya cuana ca ca quea jjashahuabaqui jaꞌa po jjima. ");
INSERT INTO eseNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Quijje pishana bae ojje miji yasijje, Jenesaneꞌ meshi yasijje besapoqui oꞌoyanaje Jesosa. Baꞌeñaquinaje o shajjaꞌajjajji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bishejo ani nequisohuaquinaje etaja huasijje. Dejja cuaa jomajo baꞌeya Jesosa ba canaje yahuajo. ");
INSERT INTO eseNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jamajjeya o ba oꞌoya majje ojjaña iyaaqui canaje Jesosa que epoecuajijji. Ojjaña emanojaaca cuana equipajaajjijo jaa Jesosa que ye canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jamajjeya Jesosa cuiñajji quea quemo huasijje, pea cuiñajji sisi cuana huasijje peaꞌai, equi cuana huasijje peaꞌai dobiqui yajo, dejja cuaa emanojaa cuana jjequi canaje o que, jjaajaqui meeꞌyohua. Huohui canaje cuaa jama baꞌa: —Jesosa, ojjaña emanojaaca cuana mique daqui che napaꞌajja meecue ehuaquiaꞌyojji, ejjaajaquiꞌyojji —acanaje. Ojjaña Jesosaja daqui napaꞌajja majje jjaajananaquiꞌyonaje, huaquiaꞌyonaje peaꞌai, de. ");
INSERT INTO eseNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Majoya Paniseo cuana, Jodio esohui huohuijji cuana peaꞌai Jenosanenajo baꞌe Jesosa que poeyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Poe majje o shajjaꞌajjajji cuana ba canaje ijjiaꞌijjiaꞌani emeꞌ shacua neinei jjimajo. Jamajjeya Jesosa tecuea canaje Jodio etii cuaa. Jama poanaje baꞌa: —Esohui huohuijji, ¿apiojji acuae mi mi shajjaꞌajjajji cuana emeꞌ shacua neinei jjimajo ijjiaꞌijjiani? —acanaje Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Eꞌe, ojjaña Jodio cuaa aje oe ijjia jjimahuajo emeꞌ shacua neinei cani; quea huiso shacuame acani, 7 huisome, ojaya etiiquiana cuanaja esohui jama. ");
INSERT INTO eseNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Equi aquiana jjeshejji yasijje bobi jjeshe majje emeꞌ shacua neinei cani ijjia jjimahuajo peaꞌai Jodio cuanaja etiiquianaja esohui jayojja jama. Quea huiso etiiquianaja esohui jayojja jama acani peaꞌai: piato cuana, oña cuana, caneco cuana jamaya topo neinei cani peaꞌai; meshimisi caꞌa quea quemo cuana, eꞌanioquejji cuana jamaya topo neinei cani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jamajjeya Paniseo cuana, Jodio etii cuana Jesosa nijje mimijajinaje: —Jesosa, ¿apiojji acuae mi mi shajjaꞌajjajji poanija esejaya etiiquianaja esohui jama po ajja? ¿Apiojji acuae ijjiaꞌijjia jjimahuajo emeꞌ shacua neinei ajja, de? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesosaa oya cuana quea tecue sajaꞌa canaje jama baꞌa: —¡Miquianaya ca mi ca oe jjadasiaquijji nei nei! Eyacuiñajjija esohui huohuijji Isaiaja esohui miquianajo eꞌe jojo nei poa. Eꞌe, yahuajo nei Eyacuiñajjiya Isaia tehue mee ca poa jama baꞌa: “Jiquio dejja cuaa eya bihuia nisho cani. Jamatii jjashajjaꞌajjaqui ajja. ");
INSERT INTO eseNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jamajjeya ecuea equi yasijje jjachichaquiani ejjachichajeaquijji. Ohuaya ojaya ejjashahuabaquiꞌyojji huohui cani, ecuea esohui pojjeama”. Jamaya Isaiaa yahuajo tehue ca poa miquianajo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","De, ¡yajja acuae nequiana poani soꞌo? ¿Apiojji acuaeya Eyacuiñajjija esohui pajeaꞌyaña etiiquianaja esohuijo? ");
INSERT INTO eseNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eꞌe, miquianaya jama poani baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yahuajo nei Eyacuiñajjiya Moisesi tehue mee ca poa oja sohui jama baꞌa: “¡Mique chii, miquea enaese etii peaꞌai jaahuanacue! Joya oja chii, oja nae peaꞌai cajaa acajo ¡cajajahuejjajea caꞌyahua cuaa, meiya!” Jamaya tehue mee caꞌya poa yahuajo nei. ");
INSERT INTO eseNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Miquianaaya ca ca huohui tai yaña jama baꞌa: “Dejja oja chii etii nijje, oja nae etii nijje pojjaꞌa camimiyahua jama baꞌa: “Eyaya miya ebaꞌe meesahuajji pojjeama. Chojja, eyaya ecuea aquiana Eyacuiñajji yasijje quiaña o bihuiajji”. Jamaya huohui taiyaña miquianaaya. ");
INSERT INTO eseNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jamajjeya oja chii etii, oja nae etii peaꞌai pajea meeyaña, miquianaaya. ");
INSERT INTO eseNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Eyacuiñajjija pea esohui quea huiso nee pajea meeꞌyo saꞌaña etiiquianaja esohui yajji nisho —Jesosaa Jodio etii acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jamajjeya Jesosaa ojjaña cuana iyaa majje huohui canaje jama baꞌa: —¡Shajjaꞌajjacue mo, jjabahuejja neineiquicue oe! ");
INSERT INTO eseNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bobi cuanajo, ojjaña aquiana enabajje dobiquianijo pojjeama miquianaya quea mimishi poani. Chojja. Quea jjashahuabaqui taijo, esohui quea tai miquea enabajje cuayaquianijo ca ca quea mimishi poani. Eyacuiñajjiya maya ba cani quea mimishi —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","—Eꞌe, ¡miquianaaya quea shajja jaꞌaa ecuea esohui shajjaꞌajja majje jama acue! ¡Jjashahuabaquicue oe! ");
INSERT INTO eseNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Majoya Jesosaa ojjaña cuana jeanana majje equi yasijje dobiquinaje o shajjaꞌajjajji cuana nijje. Dobiqui majje o shajjaꞌajjajji cuaa huohuiajja canaje: —Jesosa, ecuanajaya ca ca esohui quea quehua miquea. ¡Che mo oe ba meesahuacue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿Aꞌa ecuea esohui miquianajaya ba jjima peaꞌai? —Jesosa poanaje—. ¿Aꞌa miquea eba pojjeama? Emeꞌ shacua neinei jjimajo pojjeama miquianaya Eyacuiñajjiya quea mimishi ba cani. ");
INSERT INTO eseNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","¡Bacue! Ojjaña bobi, pea aquiana peaꞌai enabajje ijjiajea majje see ai yasijje dobiquiani. Quijje jamatii seejeajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Joya quea tai jjashahuabaquianiya ca ca esohui tai jeacuaya cani. Maaya oya quea tai po mee cani: Quea mimishi Eyacuiñajjiya oya ba cani. ");
INSERT INTO eseNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Eꞌe, ejjashahuabaquiꞌyojji quea taijo pea eponajo baꞌe sa poani, peaja yahuejo baꞌe sa poani, sii cani, siajje poani, pea quecua cani peaꞌai, ");
INSERT INTO eseNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","quehuajje cojjo cani, quea dejja tai poani, quea nishehui poani, ojjaña mimishi acani, ona dasiajji poani, quea mimishi pea nijje baꞌyani, pea jayojja baꞌe sa poani, mimijajiani peaꞌai. Jama poani baꞌa: “Eya oe nee quea pame nee” poani, eshoꞌi jayojja mimi naanaani, Eyacuiñajji niñeba cani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Eꞌe jojo nei ojjaña joya jama acani Eyacuiñajjiya ba cani quea mimishi, quea mimijjequijea; bobi ijjia cani emeꞌ topo neinei jjimajo pojjeama quea mimishi poani —jamaya Jesosaa o shajjaꞌajjajji cuana sajaꞌame acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Majoya Jesosa ma equijo ani poquinaje pea meshi yasijje. Tino pejjejo, Sinono peaꞌai pejjejo aninaje. Jjeya Jesosa mimi sa po ajja ojjaña cuana nijje. Jamajoya equi yasijje quehua dobiquinaje o shajjaꞌajjajji cuana nijje. Jamatii oya quehuajje ani meemee ajja; jjanequiquehuaqui meemee ajja. ");
INSERT INTO eseNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Eꞌe, jjeyahua nei oe eponaa shajjaꞌajja canaje Jesosa jomajo ani. Jamajjeya o que poeyanaje. Oya pea, Jodio epona pojjeama, Jieno pona pea meshijo baꞌe, Sinia meshijo, Penisiajo baꞌe. Ojaya ebacua piona huasijje eshahua yahuajo dobiquia poa. Jamajjeya enaese Jesosa que poe majje ecuiꞌoshajjajo nequinaje o bihuiajji, onijje emimi neineijji. Jama poanaje baꞌa: —Emeshi Mese nei, ¡ecuea ebacua piona jjaajaqui meeꞌyocue, quea mano nee nee jaa, quea niñe nee nee jaa! —enaese poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma enaese Jodio pojjeamajo, huapa jayojja. Jesosaa oya sajaꞌa canaje jama baꞌa: —¿Aꞌa cuae ecue bacuaja bobi jeajeaje iñahuehuaja eꞌijjiajji? ¿Aꞌa cuae jamaya quea pame? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Epona quea shoe jama jjejojo jama poanaje baꞌa: —Eꞌe, Emeshi Mese nei. ¡Jamatii o huonejjiya bobi ijjia canijo, eshaa oquequianijo ijjia cani iñahuehuaa! —acanaje enaeseya. ");
INSERT INTO eseNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jamajjeya Jesosa quea bihui nee poanaje: —Epona, miya ca ca oe quea jaꞌa nee, quea pame nee ejo jjashahuabaquiani. Jamajjeya eyaya miquea esohui jayojja jama jjeya nei ajeꞌyo. Miquea ebacua piona jjaajaqui meeꞌyonaje. Eyaya eshahua ojo nequi huoojeacuayajeaꞌyonaje. ¡Quea bihui poquicue miquea equi yasijje! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jamajjeya jjeya nei ma epona poquicuajiꞌyonaje oja equi yasijje. Ba cañaquiꞌyonaje oja bacua piona quea pame nee, eshahuamaꞌyo, ejaajji biajje quea bei aniꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jjeyahua nei Jesosa Tino pejjejo ani poquinaje. Sinono yejjenana majje Ome Miji peaꞌai Cuiñajji cuana yejjenana majje, Janinea bae yasijje poe oꞌoyanaje, ma Dejjaja Eyacuiñajji ba po jjimaja bae bajjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Majoya pea cuaa dejja shajjaqueba, mimiꞌajja peaꞌai ye canaje o que. Jama poanaje baꞌa: —Jesosa, jiquio dejja shajjaqueba, mimiꞌajja peaꞌai. ¡Oya che napaꞌajjacue emeya quea jaꞌa nee epojji! ");
INSERT INTO eseNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","—Eꞌe, —Jesosa poanaje. Jamajjeya ma dejja oe nei dojo canaje hueshaꞌama onijje mimiya, o huaquia meeꞌyohua. Ojaya eme sisi shajjaquebaja eshajja huejja huasijje jeanobia canaje. Majoya jjamecuichoqui majje ana napa canaje emeya. ");
INSERT INTO eseNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eyahuasijje jjabajeasohuaquinaje Eyacuiñajji nijje emimijji. Jjajjeanajeaquinaje jama baꞌa: —¡Quea jaꞌa pocue! —poanaje shajjaqueba nijje. Jesosaja mimijo: —¡Epata! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesosa mimi jeahuajo, ma dejjaa quea jaꞌa nee nee shajjaꞌajja caꞌyonaje. Miminaje quea jaꞌa nee. ");
INSERT INTO eseNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Majoya Jesosaa ojjaña cuana huohui canaje jama baꞌa: —Eꞌe, eyaya shajjaqueba jjashajjajaꞌaqui meeꞌyonaje, mimi meeꞌyonaje. ¡Jamatii pea cuana aꞌa jihuohuijji soꞌo! —Jesosaa jamaya ojjaña cuana huohui canaje. Jamatii oya cuaa huohui majamaja canaje ojjaña huasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Shajjaꞌajja majje ojjaña quea bihui nee jama poanaje baꞌa: —Eꞌe e, Jesosaa ojjaña acani quea pame nee nee. Eꞌe e, shajjaqueba jjashajjajaꞌaqui mee caꞌyonaje jjeya nei. Mimiꞌajja peaꞌai quea jaꞌa nee mimi mee caꞌyonaje —jamaya ojjañaa Jesosa bihuia canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Majoya quijje pishana quea huiso nee nee cuana poeyanaje. Jesosa que jjachichaqui oꞌoyanaje. Onijje ani tiitii canaje esohui shajjaꞌajjaa. Bobimaꞌ poanaje. Jamajjeya Jesosaa o shajjaꞌajjajji cuana iyaa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","O que poeyajo, huohui canaje jama baꞌa: —Jiquio dejja cuana enijje nequi pea beca peejjima cahuime. Ojaya bobi oe poanaje. Jamajjeya eya ojo quea yeno jjashahuabaquiani, bobimajo. ");
INSERT INTO eseNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Oja equi yasijje huoojea sa poꞌyo ajja, quea shoe nee nee; ejiojjijje poquianijo bobi yasijje po chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","O shajjaꞌajjajji cuanaa Jesosa sajaꞌa canaje: —Eꞌe. Jiquiojo chamaꞌ bobi, dejjamaꞌ. ¿Yajja yajji? Oya cuana quea huiso nee nee ebobiajji. ¿Achacua pahui ejjeshejji ojjaña bobiajji? —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Ache huiso pahui miquea yani? —Jesosaa huohuiꞌajja canaje. —Me oejje becanejjijji peaꞌai, 7 pahui yani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jamajjeya Jesosaa ojjaña ejjaꞌanichichaquiꞌyo ani cuana jama acanaje baꞌa: —¡Meshijo anioquecue! —acanaje. Majoya Jesosa ma 7 pahui jjeshe majje Eyacuiñajji oja Chii bihuia canaje bobijo. Majoya pahui miji canaje. O shajjaꞌajjajji cuana quia canaje. Majoya oya cuanaa dejja cuana huasijje quia canaje. Quia capoquije quea huiso nee nee jjapanaquipoquinaje, bobi. ");
INSERT INTO eseNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ojaya oe pojji nahuo sisi yaninaje peaꞌai. Oya jayojja Jesosaa nahuo sisi miji majje quia canaje o shajjaꞌajjajji cuana que ojjaña cuana huasijje equiajji. ");
INSERT INTO eseNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jamajjeya ojjaña cuaa ijjia canaje; quea jejje poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ijjia majje, mi ijjiajeyo majje bio caꞌyonaje jjepai ai yasijje, o shajjaꞌajjajji cuaa. Mepe caꞌyo majje quea huiso poanaje, 7 jjepaime. Jamatii quea huiso nee nee dejja cuana bobia canaje, 4.000 dejja. ");
INSERT INTO eseNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Majoya Jesosaa ojjaña cuana huoojea canaje oja equi cuana huasijje. Jesosa ca ca bishe ai yasijje nequisohuaquinaje o shajjaꞌajjajji cuana nijje. Besapoquinaje ojje, pea meshi yasijje Majadana meshi yasijje, pea bajjani Namanota meshi yasijje, ma Ena Taꞌa Huoi bajjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Majoya Paniseo cuana poeyanaje Jesosa que. Onijje mimicuiajeanobiajea sa poanijo jama anisho canaje baꞌa: —Esohui huohuijji Jesosa, ¿Aꞌa miya Eyacuiñajjija huoojeaꞌyo nei ojjaña jaahuanajji pojjaꞌa? ¡Ejjabaꞌajjaqui soꞌo! ¡Eyacuiñajjiya jayojja jama paname aꞌajjaꞌ eyajo ecuanaja ebajji! —huohui nisho canaje. Jamatii oya cuaa Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama poso acanaje pea Paniseo cuana: —Chojja, Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama. Jamajjeya Eyacuiñajjiya jayojja jama mi pana cajo, pajea cajeꞌyo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Paniseoja ejjashahuaba taiquijji Jesosaja eba poanaje. Jamajjeya quea yeno poanaje jama baꞌa: —Chojja. ¿Apiojji miquianaya Eyacuiñajjiya pana cani ba majamaja sa poani? Miquianaaya Eyacuiñajjija esohui cajaa aña. Jamajjeya miquea ba jjima ache shono ojaya ehuoojeaꞌyo ojjaña jaahuanajji poeyanaje. Jamajjeya Eyacuiñajjiya eya pea epana meeꞌyojji pojjeama miquea ebajji eya ojaya ehuoojeaꞌyo —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Paniseo cuana shajjamaꞌ poanijo, Jesosaa oya cuana jea canaꞌyonaje, jjabahuejjaqui ajjajojo. Besapoqui oꞌoyanaje ojje miji yasijje bishejje o shajjaꞌajjajji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Majoya bae ojje miji yasijje besapoquije Jesosa shajjaꞌajjajji poani cuana jjashahuabaquinaje. Jama poanaje baꞌa: —Eꞌe de, ecuanaa bobi pajeaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Majoya Jesosaa, Paniseoja ehuohui taijo jjashahuabaquianijo oya cuana huohui canaje: —¡Quea jaꞌa nee jjashahuabaquicue! Paniseoja, Enodeja epeejjija esohui pahui shejjee meejji jayojjajo miya quea tai po chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Oya cuana bobijo jjashahuabaquianijo Jesosaja esohui ejjashahuabaquimeejji onajaya quea quehua poanaje. Jamajjeya ojee mimimiminaje jama baꞌa: —Eꞌe pojjaꞌa Jesosa jama poanaje ecuanaja bobi ye jjimajo. ");
INSERT INTO eseNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ojaya esohui Jesosaja eba poanaje. Jamajjeya oya cuana jama acanaje baꞌa: —¿Apiojji acuae jja nequiana ojee mimimimiani bobijo? ¿Aꞌa jja eya miquianajaya ba jjima quea caꞌa nee nee? ");
INSERT INTO eseNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Aꞌa jja nequiana ejo jjashahuabaqui jjima tii? ¿Aꞌa jja nequiaa pajeaꞌyonaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eyaya me oejje pahui miji majje quea huiso dejja bobianaje, 5.000 dejja. Ijjiaꞌijjiajeyo majje acuae jjaya ¿ache jjepai huiso chichaꞌyonaje pahui? ¿Aꞌa ya pajeaꞌyonaje? —Jesosaa acanaje. —Quea huiso nee, 12 jjepaime —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Eꞌe. Oya jayojjaya me oejje beca pahui, 7 pahui, miji majje quea huiso dejja bobianaje, 4.000 dejja. ¿Majoya ojjañaa ijjiaꞌijjiajeyo majje miquianaaya ache jjepai huiso pahui chichaꞌyonaje soꞌo? —Quea huiso nee peaꞌai, 7 jjepaime quea cuio chichaꞌyonaje ecuaaya —sajaꞌame acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Eꞌe —Jesosa poanaje—. ¿Aꞌa jamatii miquianajaya ba jjima eya quea caꞌa nee nee mi bobiajji? ¿Aꞌa mi jjabahuejjaqui jjima? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Majoya Jesosa o shajjaꞌajjajji cuana nijje Betesaida huasijje baꞌeñaqui oꞌoyanaje, Jai Jaajji cuiñajji yasijje. Jomajo pea cuanaa cojjamaꞌ ye canaje Jesosa que. Jesosa huohui neinei canaje jama baꞌa: —Jesosa, jiquio dejja cojjamaꞌ. ¡Che jja oma quea cojja jaꞌa po meeꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesosaa cojjamaꞌ me iña majje me pejjejea canaje cuiñajji esecue yasijje. Jomajo Jesosaa emeꞌ cuicho majje cojja iñapepa canaje cuichohua. Oya napaꞌajja canaje emeya peaꞌai. Jama poanaje baꞌa: —¿Achajja acuaeya miyaya baña soꞌo, cha? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bajea majje cojjamaꞌ jama poanaje baꞌa: —Eyaya dejja cuana jeojeoqui baña, acui jayojja de, quea jama pishana, de —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Majoya Jesosaa ma dejja cojja napaꞌajja ca oꞌoyanaje emeya. Jesosaa cojja napaꞌajja ca oꞌoyajje, cojjamaa jjeyahua nei ba neinei canaje. Quea cojja jaꞌa nee nee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Majoya Jesosaa oya huoojea canaje oja equi yasijje. Jama poanaje baꞌa: —¡Epeejji, quea jaji nee poquiꞌyocue miquea equi yasijje! ¡Aꞌa jjeya cuiñajji yasijje poqui oꞌoyajji! ¡Eyaya miya quea cojja jaꞌa po meeꞌyonaje aꞌa jocuama huohuijji! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Majoya Jesosa o shajjaꞌajjajji cuana nijje Pinipo meshi yasijje poqui canaje. Sesanea huasijje poquijeya o shajjaꞌajjajji huohuiꞌajja canaje Jesosaa: —¿Dejja cuana acuae jja yajja poani ejo? —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Miya Huani, ma ona besameejji poa, shequi oꞌoyanaje poso ca jja mi ca acani beca cuaa. Pea cuana aje jja poani miya Enia, Eyacuiñajjija esohui huohuijji yahuajo nei nequia poa. Pea poani baꞌa miya pojjaꞌa pea esohui huohuijji yahuajo nei nequia poa pojjaꞌa. Oya cuana yahuajo nei manoꞌya poa shequi oꞌoyanaje poso ca jja mi ca acani cuaa —poanaje o shajjaꞌajjajji. ");
INSERT INTO eseNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—¿Miya acuae yajja poani ejo? ¿Aꞌya cuae iña? —Jesosa poanaje. —Miya ca ca Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji Quito bajjani —Simohuiya Jesosa sajaꞌa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jamajjeya Jesosaa oya cuana jama acanaje baꞌa: —Eꞌe, eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Jamatii ¡aꞌa jja oe jjeya huohuijji cuana! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Majoya Jesosaa o shajjaꞌajjajji cuana huohui coo canaje ojaya emanoꞌyojjijo: —Eya ojjañaja Edoe Mese quijje Jenosanena huasijje poquije. Jomajo Moisesija etehueꞌyo huohuijji cuaa, Jodio etii cuaa peaꞌai, Eyacuiñajji nijje emimijji etii cuaa peaꞌai eya quea huiso cuia cajeꞌyo. Quea nee nee poajeꞌyo eya. Quijje ya mo manojeꞌyo ohua meꞌ caca mee cajje. Jamatii pea beca peejjima cahuime po majje mo shequi mee caje oꞌoya ecue Chiiya —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jamajjeya Jesosaa jama huohui neineime acajje Peno quea yeno nee poanaje. Oya oe nei iyaa canaje, Penohua. Jama poanaje baꞌa: —Chojja, ecuea Emeshi Mese Jesosa, miya Eyacuiñajjiya jaahuana cajeꞌyo. Peaja aje mi oe ecuiajji pojjeama, peaja equecuaꞌyojji pojjeama jja mi, de. ");
INSERT INTO eseNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jamajjeya aje jja oe Jesosaa ojjaña o shajjaꞌajjajji cuana cojja ba neinei majje jama Peno tecueame acanaje baꞌa: —Peno, ¡aꞌa jamaya mimijji! Miya e dasiajji nisho epo jama mimiani. Miya Edosiquiana Satanasa jama mimiani. Jjashahuabaquiani quea tai, dejja jama; Eyacuiñajjija ejjashahuabaquiꞌyojji jama pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jamajjeya Jesosaa ojjaña o shajjaꞌajjajji, ojjaña pea cuana jomajo nequi peaꞌai iyaa canaje. Jama poanaje baꞌa: —¡Ojjaña joya enijje eꞌe jojo nei jjapeequiꞌyo sa poani Eyacuiñajjija ejjashahuabaquijji jayojja jama baꞌecue! E jayojjaya jja enijje capoquiahua, jamatii onaa napa cajje aje jja oe quea nee poajeꞌyo pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Eꞌe, ojjaña joya Eyacuiñajjija ejjashahuabaquijji jayojja jama baꞌeꞌyo sa po ajja baꞌe tiitii ajja enijje eyajo. Joya ecuea ejjashahuabaquijji jayojja jama baꞌeꞌyo sa poani ca ca baꞌe tiitiijeꞌyo enijje eyajo. ");
INSERT INTO eseNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Eꞌe pojjaꞌa dejja cuaa quea huiso nee nee aquiana ojaya yajji chicha caje. Jamatii oya cuana cuaqui yasijje jeajea cajo ojjaña ojaya aquiana cuana edojojji pojjeama. ¿Aꞌa ojjaña ojaya aquiana cuana Eyacuiñajji yasijje quia cajo o cuaquijo ani cuayaqui mee cajeꞌyo? ¿Aꞌa Eyacuiñajjiya oya cuana onijje eyajo baꞌe mee cajeꞌyo ma aquiana quea huiso nee nee sosejje? Chojja. ");
INSERT INTO eseNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Eyacuiñajji cajaa amajje eyajo ebaꞌejji pojjeama. Chojja, ejjeshejji pojjeama nequianajaya, aquiana quea huiso sosejje pojjeama, bejjo sosejje pojjeama ebaꞌe tiitiiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Eꞌe jojo nei jjeya ojjaña cuana Eyacuiñajji nijje jjapeequi ajja, ojjaña quea mimishi poani peaꞌai. Ecuea esohuijo quea bicho poanijo jama acani cuaa baꞌa: “Cho, eya Jesosa Quitoja epeejji pojjeama”. Jamajjeya eya ojjañaja Edoe Mese esohuidojojji pame cuana nijje poe oꞌoya majje ecue Chii jayojja quea pame nee nee ojjaña huoojeaꞌyojji poajeꞌyo. Jamajjeya eyaya ecue Chii eyajo ani huohuije jama baꞌa: “Cho, oya cuana ecuea epeejji pojjeama. Cajaa” eyaya aje —Jesosa poanaje—. Eꞌe, jjeya ejo quea bicho poanijo quijje eya quea bicho poajeꞌyo ojo, de. ");
INSERT INTO eseNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Majoya Jesosaa o shajjaꞌajjajji cuana jama acanaje baꞌa: —Eꞌe jojo nei beca cuaa jiquiojo nequiya jjaa mo ecojjaa ba caje ojjaña huoojeajji quea caꞌa nee nee. Jamaya mo ba caje manoꞌyo jjimahuaa. Beca cuanaja jjaja mo ba jjima poaje ojjaña huoojeajji; manojeꞌyo —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Quijje pishana me oejje pea emejje oe cahuime po majje Jesosa poquinaje o shajjaꞌajjajji nijje, pea beca peejjima dejja nijje, Peno nijje, Satiaco, oja chahua Huani nijje peaꞌai. Mahuiso dejja nijje poquinaje eyiyo huasijje quea huesha nee. Jocuama nequi oya Jesosa jjahuapaquiꞌyonaje. Jjahuapaqui majje quea cojja jiji nee poanaje eshequi jayojja poanaje, quea jeajahua nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Oja daqui quea oshe nee nee poanaje, quea jeajahua nee bo oshe jayojja. Daqui tajjajji jiquio meshijo aniya daqui tajja osheꞌyo ajja ojaya daqui jayojja. ");
INSERT INTO eseNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jamaya ojaya epeejjiya Jesosa ba canaje. Moisesi, Enia peaꞌai ma yahuajo nei baꞌya poa Jesosa nijje mimimimi nequi ba canaje peaꞌai. Miminequinaje Jesosa onaja mimishijo emanoꞌyojji jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jamajjeya Peno jjashahuabaqui jjimajo Jesosa nijje jama poanaje: —Eꞌe, Emeshi Mese Jesosa, jiquiojo ecuana canequiahua, quea pame nee. Pea beca peejjima equi sisi ecuaaya caꞌiyahua miquea, Moisesija, Eniaja peaꞌai ebaꞌejji. ");
INSERT INTO eseNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peno quea ajjajja jjejojo jama poanaje, jjashahuaba bamequi jjima jjejojo. Eꞌe, ojjaña quea ajjajja jjejojo yajja mimime epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Peno mimianijo tii bo quea oshe nee nee nequioquenaje. Queya canaje huoja. Shajjaꞌajja canaje Eyacuiñajji jama poani baꞌa: —Jiquio ecuea ecue Bacua Ejja quea jea nee nee. ¡Oya oe shajjaꞌajjacue! ");
INSERT INTO eseNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","O shajjaꞌajja majje quea mete nee nee poanaje Peno, Satiaco, Huani peaꞌai. Majoya bajea canaje Jesosa oe nei nequi; Enia, Moisesi peaꞌai chamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eyiyojo nequi jaaoquequijeꞌyo mimimimi jaaoqueꞌyonaje. Jesosaa ma ojjañaja Edoe Meseya jama acanaje baꞌa: —¡Ma miyaya eyiyojo banaje pea cuana aꞌa huohuijji jjeya! ¡Quijje eya emanoꞌyo jaa shequi oꞌoyajo oe pea cuana huohuicue! ");
INSERT INTO eseNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Oya cuanaa Jesosa shajjaꞌajja canaje. Huohui jjima nei nei poanaje. Jamatii ojee mimimiminaje jama baꞌa: —¿Yajjajje shai oya Jesosa jama poanaje baꞌa: “Eya emanoꞌyo jaa shequije oꞌoya”? Maya ecuanaja quea quehua —poanaje o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jamajjeya Jesosa huohuiꞌajja canaje: —Jesosa, Moisesija etehueꞌyo huohuijji poaniya jama acani baꞌa: “Enia oe ebionei meshi yasijje capoeꞌyahua Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji poe jjimahuajo”. ¿Yajjajje acuae jamaya acani oya cuaa? —poanaje Huani, Satiaco, Peno peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesosaa jama acanaje baꞌa: —Eꞌe jojo nei Enia jayojja jama oe dejja ebionei epoejji ojjaña cuana ejo eꞌe jojo nei ejjashahuabaqui meesahuajji. Eꞌe, Eyacuiñajjija esohui huohuijji yahuajo nei baꞌeya jama ejo tehue ca poa peaꞌai baꞌa: “Ojjañaja Edoe Mese quea nee nee po mee cajeꞌyo cuaa. Jodio cuanaja oya ba jjima poaje. Pea poso acaje. Jamajjeya cuia cajeꞌyo. Cajaa acajeꞌyo” jamaya yahuajo nei tehue ca poa ejo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eꞌe, Enia jama ca ca oe yahuajo pishana poeyanaje. Jamatii Jodio cuanaja oya ba jjima poanaje. Jamajjeya cuia caꞌyonaje. Jamaya yahuajo nei Eyacuiñajjija esohui huohuijji cuaa ojo tehue ca poa. Ma jayojja jama acanaje cuaa —jamaya Jesosaa Peno, Satiaco, Huani peaꞌai acanaje eyiyojo nequi jaaoquejeꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eyiyojo nequi jaaoqueꞌyo majje Jesosa shajjaꞌajjajji yasijje poeꞌyonaje. Ba cañaquinaje quea huiso cuana ejjachichaqui nequica. Moisesija etehueꞌyo huohuijji cuaa Jesosa shajjaꞌajjajji cuana mimicuiajeanobiajea cani. ");
INSERT INTO eseNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ojjaña ejjachichaquinequi Jesosa ba majje quea quijijji jaji nee poanaje. Cuajicuajinaje Jesosa bihuiaa jama baꞌa: —Jesosa, miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Majoya Jesosaa huohuiꞌajja canaje: —¿Ajeo acuae quiana jjamimicuiajea nobiajeaquiani? ¿Yajja poani soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Oe dejja Jesosa que poeyanaje. Huohui canaje jama baꞌa: —Emeshi Mese Jesosa, eyaya ecue bacua ejja yenaje mi que. Oya quea mano nee nee, quea niñe jjejojo mimi ajja peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Eshahuaa ojo nequiya oya naba huapa mee cani, jjaami yayequi mee cani peaꞌai. Niñepoqui jaabichajeaquiani meshi yasijje eseꞌ ijjiayai cani peaꞌai. Eyaya mi shajjaꞌajjajji cuana huasijje yenaje mi chamajo. Jamatii niñe poquipajea ajja —ejeajji poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesosaa ojjaña cuana jama acanaje baꞌa: —¡De! ¿Ache shono acuae jja nequiana ejo jjashahuabaquije eꞌe jojo nei? ¡Quea sapa caꞌa mi coma! ¿Ache cahui huiso minijje nequi majje miyaya eya bajeꞌyo Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji quea caꞌa nee nee? ¡Eshoꞌi e que jjequicue! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jamajjeya eshoꞌi jjequi canaje Jesosa que. Jesosa ba majje eshahuaa eshoꞌi janobajjima nei cacacaca mee canaje. Meshi yasijje jea majje oya jeacapoquipoquinaje. Naba huapanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesosaa ejeajji huohuiꞌajja canaje: —¿Ache shequiaja huisome jama poanaje oya? ");
INSERT INTO eseNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Jesosa, oya eshoꞌyahua jama po —poanaje ejeajji—. Eshahuaa oya dahuajea majamajaꞌajja canaje cuaqui yasijje, ena huasijje huiꞌi meeꞌajja caꞌyonaje cuanaya, o mano meeꞌyojji nisho. Jamatii ¡ecuanajo jjashahuabaquicue quea pame; ecuana jaahuanacue! ¿Aꞌa miyaya ecue bacua jjaajaqui meejeꞌyo pojjaꞌa? ");
INSERT INTO eseNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesosaa ejeajji sajaꞌa canaje: —Aꞌa huohuijji jama baꞌa: “¿Aꞌa pojjaꞌa miyaya oya jjaajaqui meejeꞌyo?” Eꞌe jojo nei jjashahuabaquicue jama baꞌa: “Eꞌe jojo nei Jesosa quea caꞌa nee nee; ojjaña acani. Ohuaya ecue bacua ejja jjaajaqui meejeꞌyo peaꞌai”. Jamaya jjashahuabaquianijo eꞌe jojo nei eyaya miquea ejjashahuabaquiꞌyojji jayojja jama ajeꞌyo. Miquea ebacua ejja jjaajaqui meejeꞌyo peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jamajjeya jjeyahua nei ejeajji jama poanaje baꞌa: —Esohui huohuijji Jesosa, eya mijo eꞌe jojo nei jjashahuabaquiani miya ejjaajaquimeeꞌyojji. ¡Miyaya eya jjabahuejja neineiqui meesahuacue! ");
INSERT INTO eseNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ojjaña cuana o que jjachicha cuajicuajiquiani ba majje Jesosaa o niñepoquimeejji poani huoojeacuayajea canaje: —¡Eshahua, o queba po meejji poani, mimiꞌajja po meeꞌyojji poani peaꞌai, cuayaquiꞌyocue oja yamijo nequi! ¡Aꞌa dobiqui oꞌoyajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesosaa huoojeajea cajeahua, eshahua siasia nananaje; eshoꞌi jjequiꞌihui mee majje cuayaquiꞌyonaje. Eshoꞌi emanoꞌyo jayojja jaa ba majje ojjaña jama poanaje baꞌa: —Oya manoꞌyonaje, poquijeyonaje, de. ");
INSERT INTO eseNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesosaa meꞌ iña cajje eshoꞌi nequisohuaꞌyonaje. Nequisohua majje quea aja nee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Quijje ojjaña cuana poqui majje Jesosa equi yasijje dobiquinaje o shajjaꞌajjajji cuana nijje. Oeya Jesosa huohuiꞌajja canaje: —Jesosa, ¿yajjajo acuae ecuaaya eshahua mi huoojeacuayajeaꞌajjaña? ");
INSERT INTO eseNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Eꞌe —Jesosa poanaje—, jiquio eshahua quea huoojeacuayajea camaja. Eyacuiñajji nijje mimi huichaꞌa huichaꞌa majje ojo jjashahuabaquiani ijjiaꞌijjia jjima po majje peaꞌai ca ca oe huoojeacuayajea meejeꞌyo miyaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oya cuana ma meshijo ani ojee poquinaje ojjaña Janinea meshi yasijje. Poquijeya Jesosaa o shajjaꞌajjajji ca ca oe sohuihuohui capoquinaje. Pea cuana sohuihuohui pajea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jamajjeya Jesosaa o shajjaꞌajjajji cuana huohui canaje jama baꞌa: —Eꞌe, quijje eya iña meesahuaje onaja equecuaꞌyojji. Quecua cajeꞌyo cuaa. Jamatii beca cahuime po majje mo shequi mee cajeꞌyo Eyacuiñajjiya. ");
INSERT INTO eseNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","O shajjaꞌajja majje quea yeno nee nee poanaje. Jamatii oya cuana quea mete poanaje ehuohuiꞌajjajji: —¿Yajjajo shai Jesosa manoꞌyome ca oya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji? —oya cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Majoya oya cuana Capenaoma huasijje poeꞌyonaje. Equi yasijje dobiquiꞌyo majje Jesosaa o shajjaꞌajjajji huohuiꞌajja canaje jama baꞌa: —Eseya ejiojjijje poejeꞌyo ¿ajeo acuae nequiana jjamimicuiajea nobiajeaquijebenaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jamatii oya cuanaja Jesosa sajaꞌa jjima. Quea bicho. Oya cuana poeje jjamimicuiajea nobiajeaquijebenaje jama baꞌa: —Jesosa quijje ona huoojeaꞌyojji poaje, eseya o jayojjaya poaje onijje ona huoojeaꞌyojji. ¿Aꞌya o pejjejo nequije, joya oja quea jea nee neeya? ");
INSERT INTO eseNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jamajjeya Jesosaa anioque majje o shajjaꞌajjajji 12 huisome iyaa canaje o que. Jama acanaje baꞌa: —¡Bacue! Miya e jayojja ona huoojeaꞌyojji po sa poanijo jama jjashahuabaquicue baꞌa: “Ojjaña ecuea quea boti nee. Cajaahuanaꞌyahua”. Jamaya poaje Eyacuiñajjiya miya ba caje quea pame nee ona huoojeaꞌyojji epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Majoya Jesosaa oe eshoꞌi nei iyaa majje ojjaña cojja nei nequia canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Bishami majje jama poanaje baꞌa: —¡Bacue! Ojjañaa joya enijje jjapeequianiya jiquio eshoꞌi quea jea ajji poaniya, eya peaꞌai quea jea acani. Oya jayojja ojjaña cuaa ecuea epeejji quea jea acani, ohuaya eya peaꞌai quea jea acani. Jamajje ecue Chii, e huoojeaꞌyojji quea jea acani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jamajjeya Huaniya Jesosa huohui canaje jama baꞌa: —Esohui huohuijji Jesosa, ecuaaya pea dejja banaje eshahua cuana huoojeacuayajea cani. Ma dejja poanaje jama baꞌa: “Eyaya eshahua huoojeacuayajeaña Jesosa nijjeya, ojaya epeejji poaniya”. Ma dejja ese nijje poqui ajjajo, oya tecueanaje jama baꞌa: “¿Apiojji? Chojja, miya ecuana nijje poqui ajja; ¡aꞌa eshahua huoojeacuayajeajji!” ecuaaya oya anaje —Huani poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jamajjeya Jesosa jama poanaje baꞌa: —¡Aꞌa oya tecueajji! Ohuaya enijjeya acani ma dejjaa ajjima acani. Jamajjeya, ohuaya eya niñeba jjima acaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ojjaña joya ese niñeba ajja esejaya epeejji nei poani. ");
INSERT INTO eseNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eꞌe jojo nei ojjañaa joya e shajjaꞌajjajji poani baꞌe meesahua cani, ena quia cani pojjaꞌa eya ojaya quea boti neejo, Eyacuiñajjiya quijje oya sosequia cajeꞌyo oya quea pame nee poanijo —Jesosaa o shajjaꞌajjajji cuana huohui canaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ecuea epeejji eyacua eshoꞌi nei jama. Joya o mimishi po meejji poani ca ca Eyacuiñajjiya quea nee nee po mee cajeꞌyo, de, quea nee tii tii. ¡Jamajjeya quea mimishi epo mee ca cuahuajje oe manoꞌyocue! Eꞌe, onaya mei enaajo yiipeca mee majje ¡bae quea doe yasijje jjajeaꞌoqueajea meequiꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","¡Jamajjeya aꞌa quea mimishi po meejji cuana! Jamajjeya miya emejo quea mimishi po sa po majje ¡emeꞌ ejajasejjajea jayojja jama acue mimishiꞌama epojji! Emeꞌ chamajo eyahuasijje poquiyajo Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji quea pame nee nee poajeꞌyo. Miquea beca emeꞌ yanijo pojjaꞌa quea mimishi tii poani ca ca cuaqui yasijje poquijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Quea tai nee nee, quea nee nee poajeꞌyo. Jomajo cuaqui jiji tiitiijeꞌyo; quijjoꞌyo ajja tii tii, de. Jamajjeya ¡mimishi pajeaꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Oya jayojjaya miya ejiojjiya quea mimishi po mee canijo, ¡ejiojji ejajasejjajea jayojja jama acue! Ejiojji chamajo eyahuasijje poquiyajo Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji quea pame nee nee poajeꞌyo. Miquea beca ejiojji yanijo pojjaꞌa quea mimishi tii poani ca ca cuaqui yasijje poquiyajo quea tai nee nee, quea nee nee poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Cuaqui jiji tiitiijeꞌyo; quijjoꞌyo ajja tii tii. Jama tii tii poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Cuanaya ecojjajo jjabaqui majje miya quea mimishi poani pojjaꞌa. ¡Jamajjeya ecojja ecajjajea jayojja jama acue! Cojjamaꞌ, mimishiꞌama miya eyahuasijje poquiyajo Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji quea pame nee nee poajeꞌyo. Cojjajji quea mimishi tii poani miya cuaqui yasijje poquijeꞌyo ca ca quea tai nee nee, quea nee nee poajeꞌyo tii tii. ¡Jamajjeya mimishi pajeaꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Cuaqui quijjoꞌyo ajja tii tii, de —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—Ojjaña ecuea epeejji poanija ebaꞌejji quea camaja poaje onaa tecuea cajje. Jamaya ecuea epeejji quea pame, quea caꞌa pocue jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jiquio ecua mei seseya, sane quea pame neeꞌya bobi shicuiajo ihuiꞌyo ajja jayojja jama ecuea epeejji quea pame nee baꞌeꞌyanijo, pea cuana o jayojja jama baꞌeje quea pame nee peaꞌai. Jamatii sane seseꞌama poajo, ¿aꞌa quea sese po meeje oꞌoya? Chojja, seseꞌamajo jeajeaꞌaña seya. ¡Jamajjeya mei sese quea pame jama pocue, sane jama! ¡Pea cuana quea pame nee baꞌe meesahuacue, ecue sohui jama! ¡Pea cuana nijje quea pame nee jjapeequicue! ¡Quea bei pocue peaꞌai! —jamaya Jesosaa o shajjaꞌajjajji cuana huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Majoya esohui huohui majje Jesosa Capenaomajo ani poꞌoquequinaje Jodea meshi yasijje, Jodana cuei ojje miji yasijje. Jomajo quea huiso nee nee o que jjachichaqui oꞌoyanaje. Jesosaa ojjaña cuana sohuihuohui canaje, ohuaya ojjaña meshi yasijje esohui huohui majamaja canaje jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Paniseo cuana ca ca o que poeyanaje jjadasiaquiya nisho. Jjashahuabaquinaje jama baꞌa: —Eꞌe pojjaꞌa Jesosa Moisesija etehueꞌyo jayojja jama pojjeama mimije. Jamajjeya ecuaaya oya tecueaje —poanaje. Poe majje Jesosa huohuiꞌajja canaje cuaa jama baꞌa: —Esohui huohuijji, ¿aꞌa cuae ehuanase huei cajji? ¿Yajjajo acuae ehuanase huei cajji soꞌo? ¿Achajja tehuemeya acuae oe Jodioja etiiquianaa aca poa? ");
INSERT INTO eseNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sajaꞌa canaje Jesosaa: —¿Yajja acuae Moisesija esohui etehueꞌyo poani soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Moisesiya jama tehueme aca poa baꞌa: “Hueiꞌyo majje yahueya ehueijeajji papeni etehueꞌyo caquia cahua oja huanase que. Majoya cahuoojea cahua” —poanaje Paniseo cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Eꞌe —Jesosa poanaje—, etiiquiana quea mimishi nee neeya jjejojoya Moisesiya huei meeꞌajja canaje. Quijje nei Moisesiya jamaya tehue ca poa; jamatii Eyacuiñajjiya jama pojjeama pana coo ca poa. ");
INSERT INTO eseNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yahuajo nei nei Eyacuiñajjiya pana coo ca poa yahue, epona peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Huohui ca poa ohuaya: “Jamajjeya yahue cajjabaꞌeshiñaquiahua ojaya ehuanase nijje ebaꞌejji”. ");
INSERT INTO eseNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Oya cuana beca; jamatii oe nei jayojja Eyacuiñajjiya oya ba cani; becanejjijji peaꞌai pojjeama; oe nei jayojjaya. Cuanaya Eyacuiñajjiya oe jayojja aca poa. ");
INSERT INTO eseNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","¡Jamajjeya aꞌa oe jea meejji! ¡Aꞌa hueijji nequiaa! ¡Jama tii tii oe nei oe acue! Jamaya Moisesiya yahuajo nei tehue ca poa peaꞌai —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Majoya o shajjaꞌajjajji cuanaa Jesosa nijje equi yasijje dobiqui majje ojaya esohuijo huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jamajjeya Jesosaa oya cuana jama acanaje baꞌa: —Eyaya miya huohuiaña eꞌe jojo nei ehuanase pea dejjaja sii jjima huei ca ajja. Dejja ehuanase hueijji epo pea epona ehuanaꞌyojji quea mimishi nee, epona siijji epo jama. Eyacuiñajjiya oya ba cani quea mimishi, pea cojjojji. ");
INSERT INTO eseNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Oya jayojja epona ojaya yahue ¡aꞌa huei meejji! Yahue hueiꞌyo majje pea dejjajo ejjahueaquijji quea mimishi nee poani, yahue siijji epo jama. Eyacuiñajjiya oya ba cani quea mimishi, pea cojjojji —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Majoya Jesosa que eshoꞌi nei cuana jjequi canaje cuaa. Huohui canaje: —Jesosa, ¡jiquio eshoꞌi nei sapa napaꞌajja majje Eyacuiñajji nijje mimicue ojaya ejaahuanajji! —poanaje. Jesosa shajjaꞌajjajji cuaa ca ca oya cuana tecuea canaje: —¡Aꞌa jja oe Jesosa que jjequi majajji eshoꞌiquiana! ¡Esohui oe cahuohui cahua! —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma ba majje Jesosa quea yeno nee poanaje. Etii cuana tecuea canaje jama baꞌa: —¡Eshoꞌiquiana e que capoeꞌyahua! ¡Aꞌa quea huesha nequi meejji! Eꞌe, ojjaña eshoꞌiquiana Eyacuiñajji nijje jjapeequi sa poani. Jamaya ecuea epeejji eshoꞌi jayojja eyaya jaahuana sa aña peaꞌai. Jamajjeya e que poquijeꞌyo; eya eyajo ojjaña huoojeaꞌyojji poaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jamajjeya eꞌe jojo nei eshoꞌi nei jayojja mi poꞌyajo ca ca enijje ebaꞌeꞌyojji pojjeama quijje eya ojjaña huoojeaꞌyojji poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Majoya eshoꞌi nei cuana bishami majje, sapa biajje emeꞌ huana majje Jesosa Eyacuiñajji nijje miminaje jiquio eshoꞌiquiana jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Majoya Jesosa o shajjaꞌajjajji cuana nijje poqui oꞌoyanaje Jodea meshi yasijje. Oe dejja o que cuajicuajijebenaje. Ecuiꞌoshajjajo nequi oya Jesosa nijje jama poanaje baꞌa: —Esohui huohuijji, miya ca ca oe quea pame nee nee. Eya huohuicue ¿achajja a mo eya poquijeꞌyo eyahuasijje ebaꞌe tiitiiꞌyojji Eyacuiñajji nijje? ¿Ae quea pame amajje eyahuasijje poqui caꞌyojji? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","O jjabahuejjaquijji Jesosaa huohui canaje: —Eꞌe, miyaya eya anaje jama baꞌa: “Miya ca ca oe quea pame nee”. Eyacuiñajji ca oe nei quea pame nee. Pea chamaꞌ o jayojja quea pame nee nee. ¡Jamajjeya eya shajjaꞌajja neineicue! ");
INSERT INTO eseNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¡Eyacuiñajji nijje baꞌe tiitiiꞌyo sa po majje ojaya etehueꞌyo jayojjaya jama oe baꞌecue tii tii! Ojaya esohui ma Moisesiya tehue ca poa miquea eba jama baꞌa: “¡Aꞌa pea quecuajji! ¡Aꞌa pea siijji! ¡Aꞌa sii pojji! ¡Aꞌa siajje pojji! ¡Aꞌa onaya dasiajji! ¡Mique chii, miquea enaese peaꞌai oe shajjaꞌajjacue!” —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Eꞌe, eyaya jamaya aña, jama tii tii eshoꞌyahuaa. ¿Pea acuae yajja po cajji eyajo ebaꞌe tiitiiꞌyojji? —jiquio dejjaa Jesosa huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesosaa oya ba neinei canaje, oya quea boti nee nee poanaje. Jamajjeya jama acanaje baꞌa: —Eꞌe, epeejji, miya quea pame nee nee Eyacuiñajji jayojja po sa po majje ¡poquicue; miquea aquiana cuana quiaquicue ejjeshejji sosejje! ¡Majoya ejjeshejji quiaꞌyocue aemaꞌ cuana huasijje! ¡Majoya poecue enijje epoꞌyojji! Jamajjeya eyajo Eyacuiñajjiya miya aquiana quea pame nee nee quea huiso nee quia cajeꞌyo quijje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesosaja esohui shajjaꞌajja majje ma dejja eshoꞌi pishana quea yeno poanaje; ojaya aquiana quea huiso nee nee yani jojoya quia sa poꞌyo ajja. Jamajjeya poquiꞌyonaje quea aquiana yeno jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jamajjeya Jesosaa ojjaña bajea majje o shajjaꞌajjajji cuana huohui canaje jama baꞌa: —Eꞌe, quea mimishiya jjejojoya aquiana quea huiso, meshi quea quemo pojjaꞌa nahue canijo beca cuana beshahua nei e que poqui ajja quijje, eya eyajo ojjaña huoojeaꞌyojji poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","O shajjaꞌajja majje jjashahuaba neineiquinaje oya cuana. Ojee miminaje. Jamajjeya Jesosaa jama acanaje baꞌa: —Ecuea epeejji cuana, eyaya eꞌe jojo nei huohuiaña jama peaꞌai baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ahuoja quii huejjajje ino jeanobiaña jama ¿aꞌa mapichi jeanobia cajji ahuoja quii huejjajje? Cho. Quea camaja coma. Jiquio ecua mapichi ahuoja quii huejjajje jeanobia cajji jojjemo dejja quea aquiana huiso nee nee dobiquiꞌyome eyahuasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","—¡De! Jamajjeya ¿aꞌya shai eyahuasijje dobiqui mee cajeꞌyo Eyacuiñajjiya? —oya cuana ojee mimimiminaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Cojja ba neinei canaje Jesosaa. Huohui ca oꞌoyanaje: —Dejjaa jama amee ajja tii. Eyacuiñajjiya oe nei ojjaña acani. (Eyahuasijje dobi meequi cani joya quea aquiana huiso nee peaꞌai) —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jamajjeya Peno jjashahuabaquinaje ma dejja quea aquiana huiso nee nee jeanaꞌyo sa po ajjajo. Huohuiꞌajja canaje: —Jesosa, ecuaaya ojjaña aquiana jeanaꞌyonaje minijje epoquiꞌyojji. Jamajjeya ¿aꞌa cuee ecuana eyahuasijje poquijeꞌyo? ¿Ae acuae ecuana quiaje soꞌo, de? —acanaje Penohua. ");
INSERT INTO eseNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Eꞌe jojo nei beca cuaa ecuea esohui jama asa poanijo aquiana cuana jiña cani. Ojaya equi, oja huapa pojjeama, oja chii, oja nae pojjaꞌa, oja bacua cuana pojjaꞌa jiña cani enijje jjapee neineiquiꞌyohua, ecuea esohui quea pame nee quea huesha huohuiya peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Jamajjeya eꞌe jojo nei Eyacuiñajjiya oya cuana quea huiso nee nee o jayojja quia cajeꞌyo equi, huapa pojjeama jayojja, echii mese jayojja cuana, enaese jayojja cuana, ebacua cuana jayojja jama peaꞌai. Mimishi cuaa ca ca oya cuana napa caje peaꞌai. Jamatii quijje oya cuana quea bihui nee nee baꞌe tiitii mee cajeꞌyo peaꞌai eyajo onijje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jamatii beca cuana jjeya ona huoojeajji poani eyajo ona huoojeaꞌyojji pojjeama poajeꞌyo. Joya jjeya ona huoojeajji pojjeama ca ca eyajo ona huoojeajji nei nei poajeꞌyo e jayojja —Jesosaa Peno acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Majoya Jenosanena huasijje poqui oꞌoyanaje. Jesosa ehui dojojji poquinaje. O shajjaꞌajjajji cuana, pea cuana o quishishijji poquiani peaꞌai quea mete jjashahuabaquinaje jama baꞌa: —Jenosanena huasijje poquiyajo, ¿yajja Jesosa acaje Jodio etii cuaa? ¡Quecua ca chanaꞌ, de! Jamajjeya Jesosaa o shajjaꞌajjajji cuana dojo canaje ejiojji sahua huasijje esohui huohuijji. Jama poanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—¡Shajjaꞌajja neineicue mo! Eya jiquio ojjañaja Edoe Mese. Eseya Jenosanena huasijje poquije. Jomajo mo Jodio etii cuana iña meesahuaje equecua meeꞌyojji. Eꞌe, Moisesija etehueꞌyo huohuijji, Eyacuiñajji nijje emimijji etii cuana peaꞌaiya eya iña mee caje. Taaa neineije cuana: “¡Oya quecuajeacue!” poaje. Jodio pojjeama cuana huasijje mo huoojea caje equecua meeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ejo soa neineije cuana; cuia cajeꞌyo mo cuaa huaca jee ejeapashajjajjaa; acui ecueataꞌapeejo me cacajea majje mo baꞌehuanasohuajea cajeꞌyo cuaa emanoꞌyojji. Jamatii mo beca cahuime po majje Eyacuiñajjiya shequi mee cajeꞌyo —Jesosaa huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Majoya Semeneoja bacua ejja Jacobo, Huani peaꞌai Jesosa que poeyanaje. Jama poanaje baꞌa: —Esohui huohuijji Jesosa, ¡che ecuanaja esohui mi nijje jama acue ecuanajo! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesosa onijje jama poanaje baꞌa: —Ecuea epeejji cuana, ¿ae sa poani miquianaya? ");
INSERT INTO eseNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Jesosa, ecuana mi pejjejo canequiꞌyahua quijje miya ojjaña huoojeaꞌyojji quea caꞌa nee nee poaje. Oe shani mijijje, pea ebianei mijijje canequiꞌyahua minijje ona huoojeaꞌyojji epojji. ¡Jamaya oe acue! —poanaje Jacobo. ");
INSERT INTO eseNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Chojja, miquianajaya ba jjima eya quea nee nee po mee cajeꞌyo cuaa. ¿Aꞌa miquiana e jayojja quea nee nee po majje quea caꞌa poajeꞌyo? Eya quecua cajeꞌyo peaꞌai cuaa. Enijje jjapee neineiquianijo miquianaya quecua cajeꞌyo peaꞌai pojjaꞌa cuaa. ¿Aꞌa jamatii miquianaya quea caꞌa poajeꞌyo? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Eꞌe —sajaꞌa canaje Jacobo, Huani peaꞌaiya—. Quea caꞌa poaje mi jayojja, jamatii quea nee nee po mee cajeꞌyo, jamatii quecua cajeꞌyo cuaa. —Eꞌe —Jesosa poanaje—, jamajjeya eꞌe jojo nei miquiana e jayojja quea nee nee po mee cajeꞌyo cuaa; e jayojja quea caꞌa nee nee poajeꞌyo onaa mano mee caꞌyajje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jamatii e ebianei mijijje, e shani mijijje peaꞌai eyajo eyaya miquianaya enequi meeꞌyojji pojjeama, enijje ona huoojeaꞌyojji poaje. Chojja, ecue Chii eyajo aniya yahuajo nei pea cuana babaca ca poa. Ohuaye nei nequia mee cajeꞌyo e ebianei mijijje, e shani mijijje peaꞌai eyajo quijje, eya ojjaña huoojeaꞌyojji poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesosa pejjejo nequi sa peaꞌai poanijo onijje ona huoojeaꞌyojji epojji, Jacobo, Huani nijje peaꞌai quea quene poanaje pea shajjaꞌajjajji cuana, ome mijijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jamajoya aje oe Jesosaa oya cuana iyaa canaje. Huohui canaje: —¡Aꞌa onijje quea quene pojji! Miquianajaya eba dejja cuana, Eyacuiñajjija epeejji pojjeama. Onajaya emeshi mese cuana, ona huoojeajji cuana peaꞌaiya pea cuana huoojea neinei cani; quea tecue nee nee poani, quea mase. ");
INSERT INTO eseNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","¡Aꞌa jamaya pojji miquianaya, ecuea epeejji cuana! ¡E jayojjaya po sa poanijo pea cuana baꞌe meesahuacue! ¡Jaahuanacue peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Joya ona huoojeaꞌyojji po sa poani ca ca echacojji sosemaꞌ jayojja capoahua. ");
INSERT INTO eseNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Eꞌe, ¡e jayojja jama pocue! Eya ojjañaja Emeshi Mese nei. Jamatii eya ca ca iña ojjañaja Edoe Mese eyajo ani poeyanaje ojjaña baꞌe meesahuaa; ojjañaja eya ebaꞌe meesahuajji pojjeama. Ojjañaja mimishi sosequiaꞌyojji mo manojeꞌyo, ojjaña cuaqui yasijje epoquiꞌyo poaje jjejojoya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jenosanena huasijje poquije Jesosa o shajjaꞌajjajji cuana nijje dobiquinananaje Jenico huasijje. Majoya quijje pishana poqui oꞌoyanaje ejiojjijje. Quea huiso nee nee poquinaje onijje cuana. Batimeohua, Timoteoja bacua ejjaa ejiojji sahuajje eꞌanioqueaniya shajjaꞌajja canaje Jesosa poeje. Oya cojjamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jamajjeya taaa neineinaje jama baꞌa: —Jesosa, miya emeshi mese Dabija osecua, ¡ejo jjashahuabaquicue quea yeno! —taaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","—¡Aꞌa oe taaa majajji! ¡Esohui oe caꞌacue! —acanaje cuaa. Jamatii taaa neineinaje cojjamaꞌ: —Jesosa, miya Eyacuiñajjija esohui jayojja jama poeyanaje, emeshi mese Dabija osecua. ¡Ejo jjashahuabaquicue! ");
INSERT INTO eseNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jamajjeya o shajjaꞌajja majje Jesosa nequiñaquinaje. Cojjamaꞌ iyaa mee canaje: —¡Oya cojjamaꞌ iyaacue! —poanaje. Jamajjeya cojjamaꞌ iyaa canaje cuaa: —¡Cojjamaꞌ, poecuajicue oe! Jesosaa miya iyaa cani. ¡Quea bihui nee oe pocue! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jamajjeya Batimeo nequisohua majje daqui nei jea canananaje, Jesosa que poquicuajinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Poeyajo Jesosaa oya huohuiꞌajja canaje: —¿Aꞌya soꞌo, Batimeo? ¿Ae sa poani miya? —Esohui huohuijji, ¡miyaya iña jjacojjabapojjaqui meeꞌyocue, ecuea ecojja quea jaꞌa epoꞌyojji! —poanaje Batimeo. ");
INSERT INTO eseNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Eꞌe, Batimeo —Jesosa poanaje—, miyaya eꞌe jojo nei ejo jjashahuabaquinaje eyaya miya jjacojjajaꞌaqui meejeꞌyo. Jamajjeya ¡quea bihui nee pocue! Jjeyahua nei Eyacuiñajjiya miya quea cojja jaꞌa po mee cajeꞌyo —Jesosa poanaje. Jjeya nei oya jjacojjabapojjaquiꞌyonaje. Jesosajo quea bihui nee nee poanaje jjacojjajaꞌaqui mee caꞌyajje. Jamajjeya Jesosa nijje poquiꞌyonaje, Batimeo. ");
INSERT INTO eseNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Majoya Jesosa Jenosanena huasijje poquije pea cuiñajjijo nequiñaquinaje Mepajejo, ma Betania pejjejo, acui yiyejo, Onimo eyiyo pejjejo. Nequiñaqui majje o shajjaꞌajjajji becanejjijji peaꞌai huoojea canaje Jesosaa jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—¡Poquicue miya Mepaje yasijje! ¡Dobiqui majje miyaya mapichi sisija bacua eshoꞌi ai ejeyo nequia nequi bañaquicue! Dejjaja o daasa biajje yahuajo eꞌanijji ajjima poa. ¡Ba majje pichocue; yecue e que! ");
INSERT INTO eseNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Onaa: “¿Apiojji miyaya mapichi sisija bacua pichoaña soꞌo?” acajje: “Ecuanaja Emeshi Mese sa poani. Ohuaya huacuaya huoojea caje oꞌoya jiquiacua” sajaꞌame acue. Jamajje: “Eꞌe, ocuae dojoꞌajja joya mapichija bacua” acaje dejjaa Mepajejo baꞌeya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jamajjeya oya cuana Jesosa shajjaꞌajjajji poquinaje Mepaje yasijje. Mapichi sisija bacua ejeyo nequia nequi ba cañaquinaje equi secue pejjejo. Ohuaya picho canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pea cuana jomajo nequi jama poanaje baꞌa: —¿Ae poani miya? ¿Apiojji mapichija bacua pichoaña soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jamajje Jesosa shajjaꞌajjajji cuaa sajaꞌa canaje: —Ecuea Emeshi Mese sa poani. —Eꞌe, ocuae dojoꞌajja joya mapichija bacua —acanaje Mepajejo baꞌe dejjaa. ");
INSERT INTO eseNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jamajjeya mapichi sisija bacua dojo canaje Jesosa que. Onajaya daqui ao cuana mapichi sisija edaasa biajje iya canaje Jesosa anisohuaquijji. Jesosa anisohuaquinaje ma mapichi eshoꞌi aija daasa biajje. Anioquenaje. Ejiojjijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ojjaña cuana ejjachichaqui nequica cuaa ojaya daqui ao cuana ejiojjijo jeapiihui canaje Jesosa jjayejjequijji. Pea cuaa acui iña jajasejja canaje. Huana yiyoyiyo canaje ejiojjijo peaꞌai quea huiso nee neeya. Jamaya yahuajo Jodio cuaa emeshi mese jaꞌajjequi canaje, cuiñajji yasijje poeyajo. ");
INSERT INTO eseNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ojjaña ehui dojojji poquiani, Jesosa quiquishijji peaꞌai taaa capoquinaje quea bihui nee nee: —¡Mi poeyajo ecuana quea bihui nee! Quea pame nee nee miya, Jesosa. ¡Eyacuiñajji eyajo aniya miya cajaahuana cahua! ");
INSERT INTO eseNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Eꞌe Jesosa, emeshi mese Dabi yahuajo baꞌe miquea etiiquiana. Miya ojjañaja Emeshi Mese nei poeyanaje. ¡Eyacuiñajji mi jaahuanajji cabihuia cahua ojjañaa! —taaame poa quea bihui nee nee jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Majoya Jesosa Jenosanena huasijje dobiquinaje ojjaña cuana nijje. Eyacuiñajjija equi yasijje poquinaje. Dobiqui majje ohuaya bajea canaje ojjaña. Majoya siniajo oya Betania huasijje poquinaje cahuiya; ome miji pea beca, 12 huisome o shajjaꞌajjajji poani nijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mecajjeahua oya cuana Betaniajo ani Jenosanena huasijje poe oꞌoyaje quea shoe poanaje Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ba canaje ejiojji sahuajo nequi acui etona jjajja jayojja. Acuijjajja baꞌajjaqui canaje. Chamaꞌ poanaje ejjajja. Eña oo pana nequiꞌyo, acuijjajja she pojjeama jiquio baꞌijo. ");
INSERT INTO eseNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jamajjeya Jesosaa huohui canaje: —¡Jamajje jamatii jjajjamaꞌ tii capoꞌyahua acui! Jamajjeya onajaya ejjajja eꞌijjiajji pojjeama tii. Jesosa shajjaꞌajjajji cuaa Jesosaja emimi shajjaꞌajja canaje peaꞌai. Jesosaa jama acanaje ojjaña jjabahuejjaqui meejji jama baꞌa: Jiquio acui jjajjamaꞌ jojoya Jesosaa tecuea canaje jayojja jama Eyacuiñajjiya Jodio cuana tecuea cajeꞌyo jjashajjaꞌajjaqui ajja jojoya. ");
INSERT INTO eseNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Majoya Jenosanena huasijje poe oꞌoya majje Jesosa ojaya epeejji cuana nijje Eyacuiñajjija equi yasijje poqui oꞌoyanaje. Dobiquinaje. Ba cañaquinaje quea huiso enequi, Eyacuiñajji nijje mimiani pojjeama. Chojja. Aquiana quia cani cuaa. Jamajjeya Jesosaa aquiana quiajji poani Eyacuiñajjija equijo nequi cuana huoojeacuayajea canaje; aquiana jjeshe poequi peaꞌai huoojeacuayajea canaje. Aquiana cuana huojjojeajea canaje; bejjo, pea bejjo sosejje quia cani cuanaja bejjo nequijji cuana jeapajjajea canaje; huiaꞌ quiajji peaꞌaija huiaꞌ nequijji cuana jeabichajea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ojjaña joya aquiana abojji huohui canaje: —¡Aꞌa jja oe aquiana yedobiajji jiquiacua! Eyacuiñajjija equi pejjejo ojjaña jjachichaquiani esohui shajjaꞌajjaa —tecueame acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jomajo Jesosaa jama acanaje peaꞌai baꞌa: —¡Aꞌa Eyacuiñajjija equijo aquiana quiajji! Eyacuiñajjija esohui jama poani baꞌa: “Ecuea equi ojjaña cuana ojjaña meshijo baꞌe Eyacuiñajji nijje emimijji equi”. Miquianaaya ca ca siipojji nequijji jayojja amee aña Eyacuiñajjija equi. ");
INSERT INTO eseNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ma shajjaꞌajja majje Eyacuiñajji nijje emimijji etii cuana, Moisesija etehueꞌyo huohuijji poani peaꞌai Jesosa nijje quea quene poanaje; oya Eyacuiñajjija huoojeaꞌyo pojjeama posojo o quecua sa acanaje. Jamatii Jesosa iña jjima poa, quea meteya jjejojo. Quea huiso cuana Jesosaja esohuijo quea bihui nee nee poanaje. Jamajjeya Jesosa ojjañaja quea nahue nee nee poanaje equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Quijje siniajo Jesosa o shajjaꞌajjajji cuana nijje Jenosanenajo ani poqui oꞌoyanaje Betania huasijje cahuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mecajjeahua nei Jenosanena huasijje poe oꞌoyanaje. Jesosa shajjaꞌajjajji poani cuaa ba canaje acui esajjaiꞌyo, ma Jesosaa tecuea canaje acui. ");
INSERT INTO eseNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ba majje Penohua niñeba caꞌyonaje. Jama poanaje baꞌa: —¡Esohui huohuijji Jesosa, bacue! ¡Miya tecueajje jjeya nei sajjaiꞌyonaje acui! ");
INSERT INTO eseNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Eꞌe —Jesosa poanaje—. ¡Miya Eyacuiñajjijo quea jaꞌa nee jjashahuabaquicue! Aꞌa jjashahuabaquijji jama baꞌa: “Eꞌe pojjaꞌa Eyacuiñajjija eya shajjaꞌajja jjima”. ");
INSERT INTO eseNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","24","Chojja, jjashahuabaquicue jama baꞌa: “Eyacuiñajjiya eꞌe jojo nei nei ecuea ehuohui onijje jama acajeꞌyo”. Jamaya miya jjashahuabaquiajo Eyacuiñajjiya miya sajaꞌa cajeꞌyo. Eꞌe, Eyacuiñajjiya miya e jayojja jama ameesahua cajeꞌyo peaꞌai ma dejjaa ajjima acani —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cuanaya miya Eyacuiñajji nijje mimianijo jiquiajja jjashahuabaquime pocue baꞌa: “Onaya enijje mimijajinaje quea tai. Jamatii eya ojaya mimishijo queneꞌama” jamaya pocue —Jesosa poanaje—. Jamaya jjashahuabaquianijo Eyacuiñajji miquea mimishijo queneꞌama poaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pea nijje quea quene tii tii poanijo ca ca Eyacuiñajjija eseja Chiija miquea mimishi ecuijeaꞌyojji pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Majoya oya cuana Jenosanena huasijje poe oꞌoya majje Eyacuiñajjija equi yasijje dobiqui oꞌoyanaje. Jesosaa esohui huohui canijo Jodio etii cuana, Eyacuiñajji nijje emimijji etii cuana, Moisesija etehueꞌyo huohuijji cuana peaꞌai o que poeyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesosa ojaya ba jjimajo huohuiꞌajja canaje: —¿Aya miya huoojea canaje jiquiacua? ¿Apiojji acuaeya esohui huohuiaña soꞌo? ¿Apiojji acuaeya aquiana quiajji poani huoojeacuayajeanaje oma mecajje? —onijje mimijajinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesosaa oya cuana acanaje: —Eꞌe, eyaya miya ebionei huohuiꞌajjaje. ");
INSERT INTO eseNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Aya Huani huoojea canaje enajje ona besa meeya? ¿Aꞌa Eyacuiñajjiya? ¿Aꞌa dejja cuaa pojjaꞌa? ¡Huohuicue mo! Eyaya majoya huohuije e huoojeaꞌyojji epo. ");
INSERT INTO eseNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Shajjaꞌajja majje Jodio cuana ojee mimimiminaje: —¿Yajja sajaꞌame yajji esejaya? Quea mete ojjaña dejja cuanajo. Ojjañaa ba cani Huani Eyacuiñajjiya huoojea canaje esohui huohuiya. Jamajjeya: “Dejja cuaa Huani huoojea canaje” eseya aje se cuia ca chanaꞌ. “Eyacuiñajjiya Huani huoojea canaje” eseya aje se oe jama acaje baꞌa: “Jamajjeya ¿apiojji miyaya Huani shajjaꞌajja jjima aña?” Jesosaa acaje —jamaya Jodio cuana miminage. ");
INSERT INTO eseNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jamajjeya jjashahuabaqui majje Jesosa huohui canaje Jodio cuaa: —Cuaꞌa, de. Ecuanaja ba jjima Huani huoojeaꞌyojji epo —anisho canaje. —Jamajjeya ecuea miya ehuohuijji pojjeama e huoojeaꞌyojji epo —Jesosaa acanaje ma Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesosaa ma Jodio etii cuana jama acanaje peaꞌai baꞌa: —¡Jiquio shajjaꞌajjacue esohui ejjashahuabaquijji! Jama poanaje baꞌa: Oe dejjaa emeshi meseya que quea quemo nee neejo bana canaje jjonojjajja oo pana, uva. Que peeyi canaje meija peeyi. Majoya que yiyesamajo mei cueehue iñaca canaje jjonojjajja na quishipashajji. Majoya mei iyasohua aoꞌao majje peehuana canaje. Iya canaje que jaahuanajji, quea huesha nee ojaya ebajji. Pea echacojji cuana iyaa canaje. Huohui canaje eque meseya: “¡Ecuea que jaahuanacue! Jaahuana sosejje quiajeꞌyo oya jjonojjajja quea huiso nee” poanaje. Majoya eque mese quea huesha poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Quijje jjonojjajja jahuajo, eque meseya o chacojji huoojea canaje que jaahuanajji que jjonojjajja jjequiya. Que jaahuanajji bañaqui majje huohui canaje jama baꞌa: “¡Che mo jjonojjajja joya eque meseja pa cadojoꞌyahua, de!” poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","—Que jaahuanajji cuaa quea mimishi jjejojo, jjonojjajja, uva quiaꞌyo jjima acanaje, joya eque meseja iyatepe mee. Jamajjeya o chacosahuajji poani iña canaje, cuia canaje. Huoojea caꞌyonaje jamatii, emejjee tii. ");
INSERT INTO eseNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eque meseya pea huoojea ca oꞌoyanaje o chacosahuajji. Jamatii yahuajo jama acanaje que jaahuanajji cuaa. Sapa cuiahuejjajeaꞌajja canaje, quea mimishi acanaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Quijje eque meseya pea huoojea, pea huoojea aꞌajja canaje. Jamatii que jaahuanajjiya jjonojjajja quia sa poꞌyo ajjaa jjejojo oya cuana iña canaje, cuiajea canaje, pea quecua canaje, pea sapa jajahuejjajea canaje meiya. ");
INSERT INTO eseNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Quijje yejje nei oja bacua ejja oe nei huoojea canaje que jaahuanajji baa: “¡Eꞌe, oya cuanaa ecue bacua ejja shajjaꞌajja caje!” poanaje eque mese. ");
INSERT INTO eseNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—Cho, oja bacua ejja poeje ba majje jama poanaje baꞌa: “Joya eque meseja bacua ejja poeje. Jjonojjajja yiye quijje ojaya poaje, ejeajji manoꞌyajo. ¡Cuaꞌa, ejjaquecuajeaqui oe! Jamajjeya que esejaya poajeꞌyo, de” poanaje que jaahuanajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—Jamajjeya aje oe ebacua ejja iña canaje, quecuajeaꞌyo majje jeajeaqui canaje quea huesha nee ma que jaahuanajji mimishi cuaa; eque mese botiꞌama acanaje cuaa. Mahuiso esohui —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jamajjeya joya eque meseya poe oꞌoya majje ¿yajja acajeꞌyo acuae jiquio que jaahuanajji quea mimishi cuana? Oya quea quene nee poajeꞌyo. Ma que jaahuanajji cuana quecuajea cajeꞌyo, de. Que quia cajeꞌyo pea cuana —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—Eꞌe —Jesosa poanaje peaꞌai—, ¿aꞌa miquea eba Eyacuiñajjija esohui etehueꞌyo yahuajo nei? Jama ejo poa baꞌa: “Oe equi yamajjana equi iyajji cajaa aca poa cuaa. Jamatii Eyacuiñajjiya ma eyamajjana equi yamajjana quea caꞌa nee nequi mee ca poa. ");
INSERT INTO eseNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jamajoya ojjaña ojaya epeejji cuanaa Eyacuiñajji bihuia cani”. Jamaya yahuajo nei aca poa ejo; eya ma eyamajjana equi iyajji jayojja jama quea caꞌa nee nee nequi —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesosaja esohui shajjaꞌajja majje Jodio cuana quea quene nee poanaje: —¡De! Ecuanajo oya mimiani, equi yamajjanajo pojjeama. Eseya que jaahuanajji quea mimishi jama peaꞌai ohuaya acani —poanaje Jodio cuana. Jamajjeya Jesosa iña sa acanaje ejeanobiajeajji. Jamatii iña jjima; quea mete poanaje. Ojjaña dejja echichaꞌyo nequicaꞌyo cuaa Jesosa Eyacuiñajjija esohui huohuijji nei nei ba cani. Ojjaña cuanaja quea nahue nee nee Jesosa eꞌiñajji. Jamajjeya Jodio etii cuanaja Jesosa iña jjima, poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Eꞌe, Jesosa mimije shajjaꞌajja majje Jodio edejja tii cuana quea quene nee poanaje. Jamajjeya Paniseo cuana, pea cuana Enodeja ehuohuiꞌyo quea boti nee poanaje peaꞌai huoojea canaje Jesosa que. Jama huohuime acanaje baꞌa: —¡Poquicue Jesosa dasiaa! ¡Esohui quea camaja nee huohuiꞌajjaquicue, ojaya yajja sajaꞌame yaꞌyojji! Jamajje Moisesija etehueꞌyo jayojja jama mi sajaꞌa cajo jeanobiajeajeꞌyo ecuaaya —poanaje Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jamajjeya Paniseo cuana poquinaje Enodeja epeejji cuana nijje Jesosa baa. Ba majje huohuiꞌajja nisho canaje jama baꞌa: —Esohui huohuijji, miyaya eꞌe jojo nei huohuiaña Eyacuiñajjija ejjashahuabaquijji. Miya edejja tii cuanajo jjashahuabaqui ajja, emeshi mese cuanajo peaꞌai meteꞌama. Jamajjeya quea jaꞌa nee huohuiaña. Jamajje mo che huohuicue: ¿Aꞌa bejjo quia cajji Shomano meshi mese Sesa bajjani yasijje? ¿Aꞌa cuaeya seya sosequiaje soꞌo Sesaja meshijo baꞌe sosejje; equiajji pojjeama pojjaꞌa esejaya? —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Jodio cuanaja ejjashahuabaquijji quea jaꞌa pojjeama Jesosaja eba poanaje. Jamajjeya: —¡Miquiana ca mi ca oe e dasiajji nisho cuana, epeejji nisho quea tai nee nee! ¿Apiojji eya dasia sa aña? ¡Jamatii oe bejjo esodojjo jjequicue ecuea ebajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jjequi canaje cuaa. Esodojjo ba majje Jesosaa huohuiꞌajja canaje: —¿Ae ecajjaꞌyo jiquio? ¿Ae bajjani etehueꞌyo? —Emeshi mese ecajjaꞌyo, Sesa —poanaje—. Ojaya bajjani etehueꞌyo yani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Eꞌe —poanaje Jesosa—. ¡Jamajjeya Sesaja bejjo quiaquicue ohua sa cajo! ¡Eyacuiñajji aꞌa pajeaꞌyojji; oya bihuiacue, shajjaꞌajjacue peaꞌai! Jesosa shajjaꞌajja majje ojjaña cuana quea mete nee poanaje: —Quea jjashahuabaqui jaꞌa nee nee oya Jesosa. Jjadasia meequi ajja —poanaje. Jamajjeya Jodio etii cuana poquinaje, Jesosa jea canaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma pojjajo tii beca Sanoseo cuana poeyanaje Jesosa baa. Sanoseo cuana aje oe jama poani baꞌa: —Manoꞌyo majje jama tii tii eshequi oꞌoyajji pojjeama quijje. Jesosa ca ca jama po ajja. Jamajjeya Jesosa dasia sa acanajejo jama anisho canaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Esohui huohuijji, Moisesiya jama tehue ca poa yahuajo nei nei baꞌa: “Dejja ejjahuanaqui bacuamaꞌ manoꞌyajo, oja chahuaa ehuanase equijjojea ani cahuana caꞌyahua oja oꞌija bacua jea jayojja jama epojji”. ¿Aꞌa eꞌe? ");
INSERT INTO eseNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jamajjeya jama poso baꞌa: Quea huiso edoe mese, me oejje pea beca, nequinaje. Edoe mese ebionei jjahuanaquinaje eponajo. Manoꞌyonaje bacuamaꞌ tii. ");
INSERT INTO eseNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oja chahuaa ehuanase equijjojea ani huana caꞌyonaje, bacuamaꞌ tii ani. Oya jayojja manoꞌyonaje bacuamaꞌ tii. Jamajjeya peaa echahua meseya huana ca oꞌoyanaje. Manoꞌyonaje bacuamaꞌ peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jamaya ojjaña edoe mese cuana manojeyoꞌyonaje bacuamaꞌ tii. Quijje ehuanase peaꞌai manoꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jamajjeya eshe oꞌoya po majje eyajo, ¿ajea ehuanase epona poaje, ache edoe meseja? Ojjaña echahua mese jjahueaꞌajjaꞌyo epo —Sanoseo cuaa acanaje Jesosa dasiajji nisho. ");
INSERT INTO eseNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesosaa jama acanaje baꞌa: —Chojja. Jamaya pojjeama. Miquea ba jjima Eyacuiñajjija esohui; oya quea caꞌa nee nee miquea ba jjima peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Eꞌe, shequi oꞌoya majje jjahuanaquiꞌyo ajja. Esohuidojojji eyajo ani jama poaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Eꞌe, yahuajo nei nei Eyacuiñajjiya Moisesi tehue mee ca poa miquea ebajji eꞌe jojo nei emanoꞌyo cuana eshe nequije oꞌoya eyajo. Eꞌe, Moisesi acui quepe jijiqui pejjejo nequi, Eyacuiñajjiya oya huohui ca poa jama baꞌa: “Eya ca ca iña Amajama jaahuanajji, Isaaca, Jacobo peaꞌai jaahuanajji”. Jamaya yahuajo nei nei Eyacuiñajjiya aca poa. ");
INSERT INTO eseNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¿Aꞌa Eyacuiñajjiya emanoꞌyo cuana meshijo emojeaꞌyojaa jaahuana cani? Cho. Ojaya epeejji cuana eshe nequi, manoꞌyo majje poquiꞌyo cuana peaꞌai jaahuana cani Eyacuiñajjiya, eshe oꞌoya epoꞌyo edojjoshahua jiquio ese mimianinaje. Jamajjeya eꞌe jojo nei emanoꞌyo cuana shequije oꞌoya, de. Miquianaya ca mi ca oe quea quehua jjashahuabaquiani —Jesosaa Sanoseo cuana acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisesija etehueꞌyo huohuijji jomajo nequi Jesosa shajjaꞌajja canaje quea jjashahuabaqui jaꞌa nee; Sanoseo cuana jjadasia meequi ajja. Jamajjeya Jesosa huohuiꞌajja canaje jama baꞌa: —Esohui huohuijji, yahuajo Moisesiya tehue ca poa Eyacuiñajjija esohui. ¿Ache esohui quea pame nee nee eꞌajji? ");
INSERT INTO eseNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesosaa oya acanaje: —Eꞌe, jiquio esohui quea pame nee jayojja jama acue baꞌa: “¡Isaeni cuana shajjaꞌajjacue! Eyacuiñajji ca ca oe Emeshi Mese nei. Oya oe nei enequi tii. Pea chamaꞌ Eyacuiñajji. ");
INSERT INTO eseNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jamajjeya ¡Eyacuiñajji miquianajaya Emeshi Mese quea jea nee nee acue! ¡Eꞌe, miquea huapa pojjeama cuana quea jea nee acue! ¡Quea jea nee neeya oe acue Eyacuiñajji! ¡Jamajje ojo jjashahuaba tiitiiquicue! ¡Oya shajjaꞌajja tiitiicue! ¡Ojaya epeejji quea jaꞌa nee nee acue peaꞌai!” ");
INSERT INTO eseNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jiquio esohui quea pame nee. Pea oya jayojja quea pame nee jama baꞌa: “¡Miquea huapa pojjeama jama quea jea neeya oe acue! ¡Ojjaña pea cuana quea jea nee nee acue peaꞌai!” Jamaya quea pame nee nee eꞌajji —Jesosa poanaje—. Pea chamaꞌ esohui jiquio jayojja quea pame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesosaja esohui shajjaꞌajja majjeya Moisesija etehueꞌyo huohuijji onijje jama poanaje baꞌa: —Esohui huohuijji Jesosa, miquea esohui eꞌe jojo nei. Eꞌe jojo nei Eyacuiñajji Emeshi Mese nei. Oya oe nei enequi tii, pea chamaꞌ Eyacuiñajji. ");
INSERT INTO eseNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jamajjeya Eyacuiñajji Emeshi Mese nei quea jea nee nee caꞌa cahua, ojo cajjashahuaba tiitiiquiahua, cashajjaꞌajja tiitii cahua, ojaya epeejji quea jaꞌa nee nee capoahua peaꞌai ojjaña. Oya jayojja pea cuana quea jea nee nee caꞌa cahua. Jamaya poanijo quea pame nee nee poani. Jodio etiiquiana cuana jayojja jama po majje ca ca quea pame pishana poani. Eꞌe, etiiquiana cuaa ca ca huo cuana, pea aquiana peaꞌai mei eꞌiyaꞌyo biajje dahua caninaje Eyacuiñajji quea bei po meejji mimishijo —poanaje Moisesija etehueꞌyo huohuijji. ");
INSERT INTO eseNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ojaya esohui quea jaꞌa nee shajjaꞌajja majje Jesosaa oya huohui canaje jama baꞌa: —Eꞌe, miya beshahua nei Eyacuiñajji sa neinei poani miquea Emeshi Mese nei epojji —acanaje. Jesosa quea jjashahuabaqui jaꞌa nee neejo jjadasia meequi ajja ba majje ojjaña Jodio etii cuana quea mete poanaje. Esohui quea camaja, yajja sohui esajaꞌame yajjijojo huohuiꞌajja pajea canaje o dasiajji nisho. ");
INSERT INTO eseNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jamajjeya ojjaña cuana ejjachichaqui nequi huohuiꞌajja canaje Jesosaa: —¿Yajja poani miquianaya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji Quitojo? ¿Ache etiiquianaja osecua oya, ajea bacua? ¿Yajjajje acuae Moisesija etehueꞌyo huohuijji cuaa huohui cani? Jama baꞌa: “Quito emeshi mese Dabija osecua, ma yahuajo baꞌya poaja” acani cuaa —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yahuajo nei Edojjoshahua Pameya emeshi mese Dabi tehue mee ca poa jama baꞌa: “Eyacuiñajjiya ecuea Emeshi Mese Quito jama aca poa: —¡Enijje anioquecue ebianei mijijje, ojjaña cuana huoojeaꞌyojji! Eyaya mi quecuajji nisho epo cuana jeabichajea jeyojeyojeꞌyo”. Jamaya huohui ca poa yahuajo Dabiya ejo. ");
INSERT INTO eseNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Eꞌe, Dabiya Eyacuiñajjija huoojeaꞌyo Quito aca poa: “Ecuea Emeshi Mese nei”. Jamajjeya Quito Dabija Emeshi Mese nei poani. Jamatii oya Dabija osecua peaꞌai —Jesosaa acanaje. Ojjaña cuaa ejjachichaqui nequiya Jesosaja esohui shajjaꞌajja canaje. Quea bihui nee poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Majoya Jesosaa ojjaña cuana huohui canaje jama baꞌa: —¡Jodio esohui huohuijji cuana jayojja jama aꞌa baꞌejji! Oya cuanaa daqui quea pame nee nee, quea ao nee huosho cani onajaya ebajji. Ejiojjijje poquiani ojjañaa aquiana quia cani yasijje anicuaa; pea cuaa jama bihuia cani baꞌa: “¡Esohui huohuijji, miya quea pame nee nee!” Jamaya aje oe ojaya quea boti nee, jiquio Jodio etii cuanaja, esohui huohuijji quea pame nee poso jjabaquiani —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jodioja equi ejjachichaquijjijo ebionei anioque sa poani, Eyacuiñajjija esohui huohuijji pejjejo, ojjaña nijje emimijji. “Eꞌe, oya cuana Eyacuiñajjija esohui huohuijji nei jayojja quea pame nee” epo meejji acani. Ojee ijjiaꞌijjianijo emeshi mese pejjejo anioqueani, ebionei eꞌijjiaꞌijjiajji. ");
INSERT INTO eseNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jamatii oya cuana aje oe siipojji; eꞌahuemanoja equi cuana sii cani. Majoya Eyacuiñajji nijje mimi nishoani quea huiso nee. Jamajoya Eyacuiñajjiya oya cuana cajaa acajeꞌyo. Quijje quea nee nee po mee cajeꞌyo, quea nee tii tii poajeꞌyo. Pea cuana ca ca quea nee po mee cajeꞌyo. Jamajjeya ¡aꞌa oya cuana jayojja jama ajji! —Jesosaa ojjaña cuana huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Majoya Jesosa Eyacuiñajjija equijo ejjeshejji iyajji pejjejo anioquenaje. Ba canaje dejjaa quea huiso poe majje ejjeshejji iyanobia cani ma acui ecaca huasijje Eyacuiñajji yasijje equiaꞌyojji. Joya quea aquiana huiso neeya iyanobia canaje quea huiso nee ejjeshejji. ");
INSERT INTO eseNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Majoya eꞌahuemano aemaꞌ poeyanaje. Ojaya ca ca esodojjo beca iyanobia canaje, sosemaꞌ pishana. ");
INSERT INTO eseNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jamatii oya ba majje Jesosaa o shajjaꞌajjajji cuana iyaa canaje. Jama poanaje baꞌa: —¡Bacue! Eꞌe jojo nei jiquio eꞌahuemanohua quea huiso nee nee jayojja quia caꞌyonaje. Pea cuaa oe pojji jayojja quia caꞌyonaje. Jamaya Eyacuiñajjiya oya ba cani. ");
INSERT INTO eseNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Eꞌe, pea cuana quea aquiana huiso nee nee. Oe pojji ojaya aquiana cuana quia canaje. Eꞌahuemano ca ca aemaꞌ nei nei. Ohuaya ojjaña ojaya ejjeshejji quia canaje; bobi jjeshejji yajji nisho quia canaje peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Majoya Jesosa Eyacuiñajjija equijo ani poquinaje. Poquianijo, o shajjaꞌajjajji cuaa oya huohui canaje jama baꞌa: —¡Bacue Eyacuiñajjija equi! Quea quemo, quea pame mei cuana —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—Eꞌe, ¿aꞌa jiquio equi quea pame nee baña? Eꞌe jojo nei quijje mei cuana cajjajeajea cajeꞌyo cuaa. Chamaꞌyo tii acajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Majoya Jesosa poquinaje quea huesha pishana, enataꞌa ojje miji yasijje. Eyiyo Onimo acui yiye yasijje jaasohuaquinaje. Anioquenaje. Jamajje o shajjaꞌajjajji cuaa, Penohua, Anesiya, Huaniya, Jacobohua peaꞌai oya huohuiꞌajja canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jesosa, ¿ache shono acuae mei cuana cajjajeajea cajeꞌyo cuaa soꞌo? ¿Aꞌya ba majje acuae ecuana jjabahuejjaquije soꞌo ojjaña jiquio meshi chamaꞌyo tii epojjijo? ");
INSERT INTO eseNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesosaa sajaꞌa canaje: —¡Jjashahuaba neineiquicue onajaya miya edasiajji pojjeama! ");
INSERT INTO eseNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Quea huiso siajjepojji cuana poeje, ecuea ehuoojeaꞌyo pojjeama: “Eyacuiñajjiya eya huoojea canaje, eya ca ca iña ojjaña jaahuanajji” jamaya siajje poaje. Quea huiso dasia cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Ojjaña jjaquecuaquiani, ojjaña meshi yasijje peaꞌai” huohui caje peaaya peaꞌai. ¡Jamatii aꞌa quea mete pojji! Jamaya poaje. Jamatii apoa pojjeama, oe po ajja jjima poaje soꞌo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Eꞌe, jjaquecuaqui cajeꞌyo cuana ojjaña meshi yasijje, ojjaña cuiñajji yasijje peaꞌai. Quea huiso emanomeejjiya mano mee cajeꞌyo; bobi yasijje po majje manojeꞌyo quea huiso; meshi huehuahuehuaje ojjaña meshi yasijje peaꞌai —Jesosa poanaje—. Eꞌe, jiquio ecua epona bacua neeani jama ebionei japashineijje neeani; quijje quea nee nee. Jamaya poaje e poe oꞌoya jjimahuajo. Quea nee pishana po majje quea nee nee poaje ojjaña cuana —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Majoya esohui huohuijji nisho cuaa miquianaya iña majje jeanobiajea cajeꞌyo. Cuiasejjajea caje equi ojee ejjachichaquijjijo peaꞌai. Enijje jjapeequianijo, pea cuaa miquianaya iña majje emeshi mese cuana huasijje dojo caje, ona huoojeajji cuana huasijje peaꞌai. Jamaya poajo, ¡ecuea esohui huohuicue ojaya eshajjaꞌajjajji, emeshi mese cuanaja eshajjaꞌajjajji! ");
INSERT INTO eseNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eꞌe jojo nei e poe oꞌoya jjimahuajo, ojjaña meshi cuana huasijje ecuea esohui quea pame nee cahuohuiqui cahua, ojjañaja eshajjaꞌajjajji. Majoya e poe oꞌoyajo, ojjaña oe poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jamajjeya miquianaya iña cajo emeshi mese yasijje edojojji, ¡aꞌa quea mete pojji! Aꞌa jjashahuabaquijji jama baꞌa: “¿Ae shai eyaya emeshi mese huohuije?” Edojjoshahua Pameya miquianaya sohuihuohui meesahua caje. Jamajjeya Edojjoshahua Pame mijo yaniya ohuaya esohui huohui caje ecuea ejjashahuabaquijji. ");
INSERT INTO eseNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Majoya pea cuana botiꞌama acajeꞌyo cuanaja. Jamajjeya eꞌoꞌi meseya oja chahua iña meesahua caje onaja equecuaꞌyojji; ejeajjiya oja bacua iña meesahua caje onajaya equecuaꞌyojji peaꞌai. Eshoꞌiquiana shajjamaꞌ po majje oja chii, ojaya enaese peaꞌai iña meesahua caje onajaya equecuaꞌyojji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Enijje jjapeequianijo miquianaya botiꞌama nei acaje ojjaña meshijo baꞌeca cuaa. Jamatii e poe oꞌoya jjimahuajo, enijje jjapeequipajeaꞌyo ajja tii ca ca Eyacuiñajji nijje baꞌe tiitii meejeꞌyo, enijje peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","—Eyacuiñajjija esohui huohuijjiya yahuajo nei nei jama aca poa baꞌa: “Quijje Eyacuiñajjija equijo nequije aquiana quea tai nee nee, ojjaña quea mete nee nee epo meejji”. Jamajjeya ma ba majje ma pojjajo tii ojjaña Jodio meshijo baꞌeca capoquicuajiahua eyiyo cuana huasijje. (¡Jiquio esohuijo jjashahuabaquicue quea jaꞌa epojji!) ");
INSERT INTO eseNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Joya equi huisa biajje chacochacoani ¡aꞌa equi yasijje dobiquinanajji aquiana cuana biohua edojojji! ");
INSERT INTO eseNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Joya quejo chacochacoqui peaꞌai ¡aꞌa equi yasijje poquinanajji daqui moojo! Eyiyo huasijje poquicuaji ajjajo manoꞌyo chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Epona cuana oꞌejji, bacua shoꞌijji peaꞌai quea yeno poaje; quea camaja equehua poquicuajijji poaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jamajjeya Eyacuiñajji nijje mimicue jama baꞌa: “Eyacuiñajji, ¡eenojo pojjeama capoahua ecuanaja epoquijji eyiyo cuana huasijje!” acue —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eꞌe, ma pojja cuanajo ojjaña quea mete nee nee, quea yeno nee nee poaje. Jamaya pojjeama yahuajo, meshi pana majje, jjeya nei peaꞌai, quijje peaꞌai; quea mete pishana, quea yeno pishana. Ma pojja quea camaja cuanajo ca ca quea yeno nee poaje ojjaña cuana —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eyacuiñajjiya oe pojji cahuijo quea camaja po mee cajeꞌyo; quea cahui huiso epoꞌyo jojjemo, ojjaña cuana manoꞌyome. Ojaya epeejji jaahuana canijo, ojaya quea nahue nee emano jeyojeyoꞌyojji, Eyacuiñajjiya oe pojji cahuijo quea camaja amee cajeꞌyo, quea cahui huiso pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Ma pojja cuanajo aꞌa shajjaꞌajjajji ona siajje poajo jama baꞌa: “¡Bacue oe, Eyacuiñajjija huoojeaꞌyo Quito jiquiacua poeꞌyonaje!” Jama poso, ¡aꞌa shajjaꞌajjajji! “¡Bacue oe, Quito jocuama pa poeyanaje!” jama onaa acajje ¡aꞌa shajjaꞌajjajji; aꞌa poquijji! ");
INSERT INTO eseNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Eꞌe, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji e jayojja nisho, Eyacuiñajjija esohui huohuijji nisho peaꞌai poeje quea huiso nee nee. Oya cuanaa ma pea dejjaa ajjima acani acajeꞌyo Eyacuiñajjija epeejji cuana dasiaꞌyojji nisho. Dasia cajeꞌyo quea huiso nee; ecuea epeejji nei peaꞌai beshahua nei eya pajea mee cajeꞌyo o jayojja epojji; cho, jjadasia meequi ajja. ");
INSERT INTO eseNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ecuea epeejji cuana, eyaya miya huohuinaje, quijje oya poeje ejjadasiaquijji. Jamajjeya ¡aꞌa oya cuana shajjaꞌajjajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Eꞌe—Jesosa poanaje—, quijje quea camaja nee nee po majje majoya eshequi quea apo poajeꞌyo. Baꞌi jijiꞌyo ajja poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Majameta cuana jjacajjaquiꞌyo majje jijioquejeꞌyo ojjaña peaꞌai. Majameta nequijji cuana huehuahuehuajeꞌyo janobajjima nei peaꞌai; yahuajo jayojja pojjeama poaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Majoya ojjañaa eya ba caje eyajo. Ba majje huohui caje jama baꞌa: “¡Bacue! Eꞌe jojo nei Jesosa ojjañaja Edoe Mese poejeꞌyo bo cuana biajje. Oya oe nei quea caꞌa nee nee, quea jeajahua nee nee peaꞌai” acaje cuaa —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Majoya eyaya esohuidojojji cuana huoojeajeꞌyo biacua, macua huasijje peaꞌai ojjaña meshi yasijje peaꞌai ecuea epeejji cuana jjequiya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jesosaa huohui canaje pea jama baꞌa: —Eꞌe, eyaya miquianaya esohui ejjashahuabaquimeejji huohuije iquena acuijo. Eseja meshijo acui iñaꞌyani ba majje eseya poani: “Eꞌe nei, nayaja poꞌyonaje. Jjeya eshequiaja popajeaꞌyonaje”. ");
INSERT INTO eseNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","—Ma jayojja jama eshequi, baꞌi quea misi, majameta eyajo jijijijioqueani ba majje jjashahuabaquicue jama baꞌa: “Eꞌe, jjeya nei apoa poaje. Jjeyahua nei esejaya Emeshi Mese nei Jesosa Quito poeje oꞌoya”. ");
INSERT INTO eseNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","—Eꞌe jojo nei ojjaña ma pojja cuanajo baꞌeca cuana mano jeyojeyoꞌyo jjimahuajo ojjaña apoa poajeꞌyo; eya ojjañaja Emeshi Mese nequijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Eꞌe, aquiana eyajo nequi chamaꞌ poajeꞌyo; ojjaña meshi chamaꞌyo tii poajeꞌyo peaꞌai. Jamatii ecuea esohui oe epoꞌyojji pojjeama; eꞌe jojo nei eyaya jamaya ajeꞌyo tii tii —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","¿Ache shono shai jamaya poaje, ojjaña apoa poajeꞌyo? Dejja cuanaja ba jjima; esohuidojojji cuanaja ba jjima peaꞌai; ecuea ehuohuijji pojjeama. Ecue Chiija eba ojaye nei. Ohuaye nei huohui cajeꞌyo ojjaña apoa epoꞌyojji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","—Jamajjeya ¡jjashahuabaqui tiitii anicue! Ache pojjajo eya ojjañaja Emeshi Mese nei poeje oꞌoya miquea eba pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jiquio jama poaje baꞌa: Eꞌequi mese poqui jjimahuajo echacojji cuana iyaa canaje. Huoojea canaje jama baꞌa: “¡Ecuea equi cuiñacue, miquianaaya! ¡Ecuea ehuohui mi yasijje jama chacocue peaꞌai! Quijje eya poeje oꞌoya” eꞌequi mese poanaje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jamajjeya ¡jjaꞌishoaꞌajjaqui ani tiitiicue! Eya miquianajaya eꞌequi mese jayojja; ache nei eshequi nequijo poeje oꞌoya miquianajaya ebajo ese. ¡Sinecua, mecashono, mecajjeahua cuana jjaꞌishoaꞌajjaqui anicue! ");
INSERT INTO eseNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Apoa pojjeama, ecahuijaa ba majje tecueañaje poe majje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jamaya eyaya ojjaña ecuea epeejji cuana huohuiaña peaꞌai: ¡Apoa epo anicue quiana! —jamaya Jesosaa sohuihuohui canaje Jenosanenajo, Onimo yiyejo. ");
INSERT INTO eseNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Eꞌe, ojjaña Jodio cuana ojee jjachichaqui oꞌoyanaje Jenosanena huasijje ojee ijjiaꞌijjiaa, quea bihui nee epojji, yahuajo nei esohuidojojjiya Ejito meshijo Jodioja bacua cuana cuiaꞌyo jjima aca poa niñebaꞌyojji. Beca cahuime ojee ijjia jjimahuajo, noe, pahui eshejjeemeejjimaꞌ ijjia jjimahuajo, Eyacuiñajji nijje emimijji etii cuana, Moisesija etehueꞌyo huohuijji cuana peaꞌai jjashahuabaquinaje Jesosa quecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ojee mimimiminaje jama baꞌa: —¡Jesosa quehua neijje iñacue, ojjaña Jodio cuana jjachichaqui jjimahuajo! ¡Oya iñacue jjeyahua nei, de! Quijje pishana ojjaña ojee ijjiaꞌijjianijo, ecuanajaya Jesosa eꞌiñajji pojjeama. Chojja, ojjaña Jodio cuana quea quene nee nee ecuana nijje po chanaꞌ —poanaje Jodio edejja tii cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesosa Betaniajo ani poquinaje Simonija equi yasijje. Poquinaje ijjiaꞌijjiaa. Yahuajo nei Simoni quea mano nee nee batata epoꞌyo quea tai poa, ma dejja cuaa jjajea meequiꞌyo jjima acani. Jesosaa oya yahuajo jjajeaqui mee caꞌyonaje batata epoꞌyo. Simonija equijo ojee ijjiaꞌijjianijo, oe epona Jesosa que poeyanaje. Tahuoo quea nahue nee neejo shiyeshiye ye canaje. Tahuoo naba capa majje Jesosa huojja sha canaje shiyeshiyeya, nardo bajjaniya. ");
INSERT INTO eseNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma ba majje beca cuana quea quene poanaje; epona tecuea canaje jama baꞌa: —¿Apiojji acuae miyaya jiquio shiyeshiyeya Jesosa sapa quehua shaña soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¡Quea nahue nee nee eshojeajeajji, oe shequiaja echacome jama sosejjeme, de! ¿Sha jjima yajjijo poso ca mi ca oe shiyeshiye dojo meenaje esodojjo quea huiso sosejje? Eꞌe, aemaꞌ cuana huasijje esodojjo equiajji poso —epona acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesosaa ca ca oya shajjaꞌajja majje jama acanaje baꞌa: —¿Apiojji acuaeya epona tecueaña soꞌo? ¡Aꞌa oya tecueajji! Eꞌe, eya ohuaya huojja sha canaje. Jamaya quea pame nee. ");
INSERT INTO eseNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Eꞌe, aemaꞌ cuana minijje po tiitiijeꞌyo. ¡Oya cuana jaahuanaꞌyocue quijje peaꞌai! Eya ca ca enequi tiitiijji pojjeama minijje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Epona e huojja sha jjimahuajo jjashahuabaquinaje jama baꞌa: “Eꞌe e, Jesosa manojeꞌyo. Mano jjimahuajo, eyaya oya huojja shaña shiyeshiyeya; onaja mojea jjimahua shaña poanaje epona” —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","—Jamajjeya quijje ojjaña meshijo ecuea esohui huohui majje jiquio eponajo huohui capoquipoquije peaꞌai jama baꞌa: “Oe eponaa Jesosa huojja sha canaje shiyeshiyeya, quea jea nee neejojo”. Jiquio eponajo huohui tiitii caje, eꞌe jojo nei —jamaya Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yaninaje quea huiso Jesosa shajjaꞌajjajji cuana, 12. Oe nei Jodasa Isicaniote bajjani poquinaje Eyacuiñajji nijje emimijji etii cuana huasijje. Jama poanaje baꞌa: —Eyaya miya Jesosa iña meesahuaje. ¿Ache sose huiso acuae mo ya oe sosequiaje soꞌo Jesosa iña meesahua sosejje? —poanaje Jodasa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oya cuanaa Jodasa sajaꞌa canaje quea bihui nee jama baꞌa: —Eꞌe, Jesosa iña meesahua sosejje miya sosequiajeꞌyo quea huiso —poanaje Jodio etii. Jamajjeya Jodasa jjashahuaba neineiqui aninaje: —¿Achajja iña meeme aje soꞌo? Cabaꞌajjaquisahua —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jodio cuana quea bihui ojee ijjiaꞌijjianinaje yohua shejo baꞌa esohuidojojjija yahuajo nei etiiquianaja bacua cuana cuiaꞌyo jjima ñajjajja naꞌ esecuejo eꞌiñapepa ba majje. Jamajjeya ebionei epojjajo eꞌijjiaꞌijjiajjijo, pahui quea caꞌa ijjia canijo, ñajjajja cuia cajjijo, Jesosa que poe majje o shajjaꞌajjajji cuaa huohuiꞌajja canaje jama baꞌa: —Jesosa, ¿ache equijo acuae seya pahui eshejjee meejjijo hua jjima ijjiaje soꞌo? ¡Ecuana huoojeacue aquiana iyajeaa, mi ishoajji! ");
INSERT INTO eseNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jamajjeya Jesosaa beca shajjaꞌajjajji huoojea canaje: —¡Poquicue Jenosanena huasijje! ¡Jomajo ecuea epeejji baquicue ena abo cani! ¡Onijje poquicue! ");
INSERT INTO eseNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Oya equi yasijje dobiquiyajo, ma equi mese nijje mimicue jama baꞌa: “Ecuana sohui huohuijji jama poanaje baꞌa: “Miquea equijo eyaya e shajjaꞌajjajji cuana nijjeya pahui caꞌa ijjiaje esohuidojojjiya etiiquianaja bacua ejja cuana cuiaꞌyo jjima poa shejo. ¿Ache equi quecuayijjijo ijjiaje soꞌo?” jamaya acue —Jesosaa acanaje—. ");
INSERT INTO eseNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Majoya equi meseya miya dojo caje eyahuasijje equi quecuayijji ai yasijje. Jomajo ojjaña aquiana apoa, ehuana bamebameꞌyo. ¡Jomajo bobi iyacue esejaya ojee eꞌijjiajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","O shajjaꞌajjajji beca poquinaje Jenosanena huasijje. Jomajo Jesosaja esohui jayojja jama ojjaña ba cañaquinaje. Bobi iyajea canaje pahui caꞌa ijjiajji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Majoya sinecua neijo Jesosa o shajjaꞌajjajji cuana nijje, 12 huisome nijje ma equi yasijje poquinaje. Dobiqui majje jaasohuaquinaje equi quecuayijji ai yasijje, equi jamacoo huasijje. Majoya ojjaña cuana anioquenaje bobi ijjiajji pejjejo ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ojee ijjiaꞌijjia anijo Jesosa jama poanaje baꞌa: —Eꞌe jojo nei jiquiojo aniya oe epeejji nisho enijje ijjiaꞌijjia ani. Ohuaya onaya cuana eya iña meesahua cajeꞌyo equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma shajjaꞌajja majje ojjaña cuana quea yeno nee nee poanaje. Pea mimiajo, pea poanaje jama baꞌa: —Ecuea Emeshi Mese, eya ca ca o jayojja pojjeama, eꞌe jojo nei —jamaya ojjaña miminaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Majoya Jesosa onijje jama poanaje baꞌa: —Eꞌe, miquianaya e shajjaꞌajjajjiya 12 huisome enijje yani; oe aje epeejji nisho, de. Eꞌe, maaya pahui shapeshipeshiani enijje; ohuaya eya onaya cuana iña meesahua cajeꞌyo onajaya equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Eꞌe, yahuajo nei Eyacuiñajjija esohui tehuejji cuaa esohui tehue ca poa jama baꞌa: “Quijje oe dejjaa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji onaya cuana iña meesahua cajeꞌyo equecuaꞌyojji”. Ma etehueꞌyo jama capoahua. Jamatii ma dejja, e iña meesahuajji epo quijje quea yeno nee poajeꞌyo. Jjashahuabaquije jama baꞌa: “¿Apiojji shai eya ecue naeya mejo ca poa? Eya ca ca nequi sa po ajja. Ecuea ejjashahuaba taiquijjijo manoꞌyo sa poani” oya poaje. Quijje oya quea nee nee po tiitiijeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Majoya ojee ijjiaꞌijjia anijo tii Jesosaa pahui caꞌa jjeshe canaje. Eyacuiñajji bihuia majje, pahui mijisisi majje quia canaje o shajjaꞌajjajji cuana. Jama poanaje baꞌa: —¡Ijjiacue! Jiquio ecuea eyami —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pahui ijjia majje caneco jjeshe canaje Jesosaa. Eyacuiñajji bihuia majje quia canaje ojjaña o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—¡Ishicue! Jiquio ecuea enaꞌ. Ecuea enaꞌ cuayaquiajo, eya manojeꞌyo. Jamajoya eyaya ojjañaja mimishi cuana cuijeajeꞌyo enijje jjapeequiajo, Eyacuiñajjija esohui eyacua jayojja jama ajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jjeya eyaya jiquio jjonojjajja na, uva na, eꞌishi oꞌoyajji pojjeama miquiana nijje; eya manojeꞌyo. Quijje nei poe oꞌoya majje eyaya jiquio ishije oꞌoya miquiana nijje. Eꞌe, eya poe oꞌoyajo, ecue Chiiya eya ojjaña huoojeaꞌyojji pomee cajeꞌyo, ojjañaa shajjaꞌajja caje —jamaya Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Majoya ojee sohuicuaya majje poquinaje eyiyo huasijje, Onimo jjajja meshi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ejiojjijje poquije Jesosaa o shajjaꞌajjajji cuana acanaje jama baꞌa: —Jiquio mecajje ojjaña miquianaya enijje jjapeequipajeajeꞌyo. Eꞌe, yahuajo Eyacuiñajjija esohui tehuejji cuaa ejo tehue ca poa jayojja jama poaje jama baꞌa: “Quijje eyaya ñajjajja cuiñajji jaahuana neinei ajja. Jamajjeya onaaya oya cuia cajeꞌyo. Ñajjajja cuiñajji chamajo, ñajjajja cuana jjajeaajajeaquinanajeꞌyo”. Jamaya yahuajo nei nei tehue ca poa ejo —Jesosaa acanaje—. Eꞌe, eya ñajjajja cuiñajji jayojja jama poaje. Eya manoꞌyo majje ecuea epeejji cuana ñajjajja cuana jayojja jama poaje; jjajeaajaquinanajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","—Jamatii Eyacuiñajjiya eya shequi mee ca oꞌoyajje eya poquije Janinea meshi yasijje. Jomajo aje mi poeyajo ishoañaquije —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Penohua Jesosa jama acanaje baꞌa: —Eꞌe pojjaꞌa pea cuana minijje jjapee tiitiiquiꞌyo ajja. Eya ca ca pea jayojja jama pojjeama. Eya jjapee tiitiiquijeꞌyo minijje —poanaje Peno. ");
INSERT INTO eseNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesosaa Peno jama acanaje baꞌa: —Eyaya miya eꞌe jojo nei huohuiaña, Peno, jiquio mecajje tii cachina yahue beca taaame po jjimahuajo, pea beca peejjima huohuiꞌajjame acajje, miya ejo po huichaꞌa huichaꞌaje jama baꞌa: “Chojja de, ecuea Jesosa ba jjima nei nei” miyaya sajaꞌame aje quea meteya jjejojo —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jamatii Penohua Jesosa acanaje: —Chojja, Jesosa. Eꞌe pojjaꞌa eya minijje jjapeequianijo, pea cuaa eya cuiajea cajeꞌyo. ¡Jamatii ecuea ca mi ca epajeaꞌyojji pojjeama! Oya jayojja pea cuaa acanaje peaꞌai: —Eꞌe, Jesosa, ecuanajaya ca mi ca epajeaꞌyojji pojjeama tii, jamatii onaa cuiajea cajeꞌyo pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Majoya Jesosa o shajjaꞌajjajji cuana nijje Jetesemani que yasijje poquinaje. Jesosa onijje miminaje jama baꞌa: —¡Anioquecue jiquiojo tii! Jocuama eya poquije ecue Chii nijje mimiya. ");
INSERT INTO eseNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jamajjeya Jesosaa Peno, Huani, Satiaco peaꞌai dojo canaje jocuama. Oya Jesosa jjashahuabaquinaje quea yeno nee nee. ");
INSERT INTO eseNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jamajjeya ojaya epeejji nijje jama poanaje baꞌa: —Quea yeno nee nee iña; manojeꞌyo iña, de. ¡Anioquecue enijje; aꞌa cahuijji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Majoya Jesosa cuama pishana poqui majje ecuiꞌoshajjajo nequinaje. Oja Chii nijje miminaje quea yeno nee jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Ecue Chii, miquea ejjashahuabaquiꞌyojji jayojja jama eyaya ajeꞌyo. Miyaya eya huoojeanaje ojjañaja mimishijo manoꞌyohua. Quea camaja nee nee ejo. ¿Aꞌa ya iña miyaya che onaaya quecua meeꞌyo jjima ajeꞌyo? ¿Aꞌa ya iña che iña meeꞌyo jjima ajeꞌyo? ¡Jamatii miquea ejjashahuabaquiꞌyojji jayojjaya jama acue! ¡Ecuea ejjashahuabaquiꞌyojji jayojja jama aꞌa ajji! —Jesosa jamaya miminaje oja Chii nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Majoya oya poqui oꞌoyanaje o shajjaꞌajjajji cuana huasijje. Ba cañaquiꞌyonaje ecahuijaa. Tecueꞌama Peno nijje jama poanaje baꞌa: —¿Aꞌa mi cahuijaa? ¿Aꞌa mi enijje cahui jjima che nequi jjima? ");
INSERT INTO eseNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Majoya Jesosaa ojjaña cuana acanaje: —¡Aꞌa cahuijji! ¡Eyacuiñajji nijje mimi majamajacue! Jamajoya pea cuaa miya quea mimishi epo meeꞌyojji pojjeama. Eꞌe, miquianaya enijje jjapeequi sa poani eꞌe jojo nei. Jamatii miya caꞌaꞌama; quea mimishi poaje oꞌoya pojjaꞌa —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Majoya Jesosa poqui oꞌoyanaje jocuama pishana oja Chii nijje mimi oꞌoyaa. Yahuajo jayojja mimi oꞌoyame poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Oja Chii nijje mimi oꞌoya majje Jesosa poqui oꞌoyanaje o shajjaꞌajjajji cuana huasijje. Ba caña oꞌoyanaje quea cojja jee mano poanajejojo cahui oꞌoyanaje. Jesosa ba majje oya cuana quea bicho poanaje onijje emimijji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jamajjeya oya cuana jea canana oꞌoyanaje, Jesosaa. Cuama pishana poqui oꞌoyanaje. Oja Chii nijje mimi oꞌoyanaje. Mimi oꞌoya majje poe oꞌoyanaje o shajjaꞌajjajji cuana que. Isheꞌacanaje: —¿Aꞌa miquianaya cahuijaa tii? ¿Aꞌa mi jomishocajaa? Apoa aje, de. Jjeyahua nei eya, ojjañaja Edoe Mese, mimishi cua iña meesahua cajeꞌyo cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Nequisohuacue! ¡Cuaꞌa, jjeya nei ecuea epeejji nisho poeje! ¡Joya aje Jodasa poeje baꞌa! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesosa mimianijo tii, Jodasa o que poeyanaje. Oya aje oe Jesosaja epeejji peaꞌai poanaje; pea 11 nijje nequinaje tii. Quea huiso nee nee dejja nijje Jodasa poeyanaje; yohuajji poeyanaje acuijji, baajji, mejejji peaꞌai poeyanaje. Jodio etii cuaa, Jodioja esohui huohuijjiya, Eyacuiñajji nijje emimijji etiiya peaꞌai ojjaña huoojea canaje Jesosa iñaa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jodasaa, Jesosa eꞌiña meejjiya, yahuajo jama huohuime acanaje baꞌa: —¡Bacue oe! Eyaya oe dejja ba majje cuiapashi nishoje. ¡Majoya oe miquianaaya iñacue; dojoꞌyocue! —Jodasaa yahuajo acanaje dejja cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jamajjeya Jodasa Jesosa que jjanequichipiquinaje: —Jesosa, ¡aꞌa mi ecuea Emeshi Mese nei jiquio! —amajje cuiapashi nisho canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma ba majje pea dejja cuaa Jesosa que poe majje iña canaje edojojji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesosa iña cajo oja epeejjiya onijje nequiya, Penohua, baa iña canaje. Onaja sapa jajapojojeajji nisho shajja jajasejjajea caꞌyonaje, Eyacuiñajji nijje emimijji etiija echacojji poanija eshajja. ");
INSERT INTO eseNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesosaa ojjaña dejja ejjachichaquiꞌyo nequi huohui canaje: —¿Apiojji miya poeyanaje baajji, acuijji, mejejji e iñaa? ¿Aꞌa cuae jja iña siipojji soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ojjaña pojjajo eya ojjaña cuana nijje nequinaje esohui huohuijji Eyacuiñajjija equijo. Jamatii eya miquianajaya iña jjima poanaje. ¿Apiojji mecajje poeyanaje e iñaa? Jamatii jamaya nequiana poani. Miquianaaya ca mi ca oe Eyacuiñajjija esohui huohuijjija etehueꞌyo yahuajo nei nei mijo jayojja jama quea tai aña. ");
INSERT INTO eseNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Majoya o shajjaꞌajjajji cuana mete majje cuajicuajinananaje; Jesosa jea canananaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Eya ca ca iña Macoso bajjani. Jesosa ocuenaje o pajea sa poꞌyo ajjaa jjejojo. Eya daquimaꞌ poanaje; oe daqui ao ejjacueabeboquijji poanaje. Majoya dejja mase cuaa eya iñaꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ohua iña cajje eyaya daqui ao jeajeanananaje, cuajicuajipoquinaje daquimaꞌ quea mete jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jamajjeya joya Jesosa iñajji cuaa oya dojo canaje Eyacuiñajji nijje emimijji etiija equi yasijje, Caipaja equi yasijje. Jocuama ojjaña Jodio cuana jjachichaquinaje, Jodio etii cuana, Moisesija etehueꞌyo huohuijji poani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Penohua ca ca equijje aca poquinaje Jesosa. Caipaja equi yasijje nequiñaquinaje. Dobiquinaje epeeyi dojjo huasijje. Jomajo Peno equi cuiñajji nijje cuaqui pejjejo jjayoqui nequinaje yajja Jesosa acaje cuaa ebajji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eyacuiñajji nijje emimijji etii, ojjaña Jodio etii cuana, Jodio esohui huohuijji poani peaꞌaiya ojee mimimiminaje Jesosajo, ojjaña ejjachichaqui nequiya, o quecuajeaꞌyo sa acani. Jamajjeya saꞌajja canaje dejja cuana Jesosa huohuijji nisho epo; Shomano meshi mese Pinato bajjani yasijje dojo majje Jesosa huohuijji nisho. Jamatii Jesosa huohuijji epo chamaꞌ poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Quea huiso dejjaa siajje acanaje. Jamatii oe siajjepojjija esohui pea siajjepojjija esohui jama pojjeama Jesosa mano meeꞌyojji. Chamaꞌ beca oya jayojja mimime epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Quijje yejje nei beca cuana poe majje Jesosa niñeba canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Eyaya oya shajjaꞌajjanaje. Jama poanaje Jesosa baꞌa: “Jiquio Eyacuiñajjija equi jeabichajea cajo, eyaya pea equi iyajeꞌyo pea beca peejjima cahuime. Jiquio equi dejjaja iya poanaje; pea ca ca dejjaa pojjeama iya cajeꞌyo” Jesosa poanaje —acanaje beca cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jamatii oya cuanaja esohui pea jayojja jama pojjeama poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Majoya Eyacuiñajji nijje emimijji etii ojjaña cojja nei nequisohua majje Jesosa huohuiꞌajja canaje: —¿Aꞌa pa miya jama poanaje baꞌa? ¿Jesosa, aꞌa cuae miyaya sajaꞌajeꞌyo soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jamatii Jesosa mimishiꞌama jjejojo mimipanajaji jjima poanaje. Jamajjeya Eyacuiñajji nijje emimijji etiiya oya huohui neinei canaje: —Jesosa, ¿aꞌa cuae mi Eyacuiñajjija Bacua Ejja nei, oja huoojeaꞌyo ojjaña jaahuanajji? ¡Huohuicue mo! ");
INSERT INTO eseNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jamajjeya Jesosaa acanaje: —Eꞌe, joya ecua miyaya aña jayojjaya eya, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Cuanaya eyaya miya eꞌe nei huohuiaña: Quijje miyaya eya baje ecue Chii nijje ebianeijje ani. Oya quea caꞌa nee nee enequi tii. Eya miquianaaya baje bo biajje poeje oꞌoya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma shajjajja majje Jodioja Eyacuiñajji nijje emimijji etii quea quene nee nee poanaje. Quea quene nee po majje ma dejja tiiya ojaya daqui, oja huosho baꞌe isajea canaje. Jodio dejja jamaya oja daqui isajea cani quea quene po majje. Ojjaña cuana huohui canaje: —¡De! ¡Aꞌa pea dejja iyaajji Jesosa huohuijji! Jamatii. ");
INSERT INTO eseNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Oya Jesosa miminaje jama baꞌa: “Eya Eyacuiñajjija Bacua Ejja”. Chojja. Siajjepojji. ¿Aꞌa cuae nequiaa shajjaꞌajjanaje oja sohui? ¿Jamajje yajja acuae seya aje soꞌo, Jesosa, de? —acanaje Jodio etiiya. —¡Oya oe manojea meeꞌyocue; quea tai ca esohui acani! —acanaje Jodio edejja tii cuaa, Jesosa Eyacuiñajjija Bacua Ejja pojjeama posojo. ");
INSERT INTO eseNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Majoya aje oe Jodio etiiya Jesosa cojja cuichojea ca poa. Cojja dodo majje ejjachichaquinequiya cuia canaje peaꞌai emeya. Cuia majje huohuiꞌajja canaje: —¡Miya Eyacuiñajjija huoojea nei jjabaqui majje jja ca oe huohui pocue! ¿Aya acue mi cuia cani soꞌo? ¡Jjashahuabaꞌajjaqui! —acanaje equi cuiñajji cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ojjaña cuaa Jesosa napa caqui Penohua ba canaje esecuejo nequiya. Oe epona echacojji ahuemaꞌ ani poeyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peno cuaqui pejjejo jjayoqui nequi ba canaje. Ba neinei majje huohui canaje jama baꞌa: —Eꞌe jojo nei miya Jesosa nijje aninaje, ma Nasanenajo baꞌe nijje —poanaje epona. ");
INSERT INTO eseNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—¡Chojja, ecuea oya ba jjima! ¿Ajeo acuae mi mimiani? —Peno siajje poanaje. Majoya Peno epeeyijo nequi cuayaquiꞌyonaje, quea mete jjejojo. Jjeyahua nei cachina yahua taaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Peno esecuejo enequiꞌyojo, epona shoꞌiya echacojjiya oya ba ca oꞌoyanaje. Ojjaña cuana huohui canaje: —Oya ca ca oma Jesosa nijje aninaje eꞌe jojo nei —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Chojja, ecuea oya ba jjima nei nei. Eya ojaya epeejji pojjeama —nisho po oꞌoyanaje quea mete jjejojo. Quijje pishana beca cuana Peno que ojee nequi jjanequichipiqui majje jama poanaje baꞌa: —Eꞌe jojo nei miya Jesosaja epeejji peaꞌai; pea cuana nijje nequinaje. Jamaya miquea emimi, Janinea meshijo baꞌe jayojja jama miya mimiani, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ojaya esohui shajjaꞌajja majje Peno quea mete nee poanaje; onijje mimipanajajinaje: —¡Siajje miya poani! Jiquio dejja ecuea ba jjima. Eya eꞌe jojo nei pojjeama poani jojjemo, Eyacuiñajjiya eya mano mee caꞌyome —Peno poanaje. Jamatii oya siajje poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Peno jamaya poajo chachina yahue taaa oꞌoyanaje. Cachina taaajo Peno jjashahuabaquiꞌyonaje ma Jesosaa yahuajo huohui canaje jama baꞌa: —Peno, cachina yahue beca taaame poajo miyaya eya ba jjima nisho aje; pea beca peejjima huohuime ajeꞌyo —yahuajo jamaya Jesosaa Peno acanaje. Ma shahuabaꞌyo majje Peno quea yeno nee nee poanaje. Pa neinei poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Majoya mecajjeahua nei Eyacuiñajji nijje emimijji etii cuana, Jodioja edejja tii cuana, Moisesija etehueꞌyo huohuijji poani, pea Jodio etii ejjachichaqui nequi cuana peaꞌai, 71 huisome jjachichaquinaje. Ojee jjachichaqui majje miminaje Jesosa quecuaꞌyojji: —¿Achajja amajje acuae seya Jesosa quecua meejeꞌyo soꞌo? —acanaje oya cuaa. Jamajjeya Jesosa me jeyo majje dojo canaje Shomano meshi mese Pinato bajjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jesosa ba majje Pinatohua huohuiꞌajja canaje jama baꞌa: —¿Aꞌya cuae mi soꞌo? ¿Aꞌa miya Jodioja Emeshi Mese nei poajeꞌyo? —Eꞌe, joya ecua miyaya aña jamaya epoꞌyojji eya —Jesosaa sajaꞌa canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eyacuiñajji nijje emimijji etii cuaa quea huiso siajje acanaje Pinato Jesosajo. Jamatii Jesosaa sajaꞌa jjima acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jamajjeya Pinatohua oya huohuiꞌajja canaje: —¿Yajjajje acuae mi mi jjasajaꞌaquiani soꞌo? ¿Aꞌa jje shajjaꞌajja jjima ojaya esohui mijo? Quea huiso nee miya niñeba cani Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesosa mimishiꞌama. Jamajjeya siajjepojji cuana o niñebajji sajaꞌa jjima acanaje. Jjasajaꞌaqui ajja nei nei ba majje Pinatohua niñeba caꞌyonaje: —¿Yajjajje acuae Jesosa mi jjasajaꞌaquiani soꞌo, de? —poanaje Pinato. ");
INSERT INTO eseNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Majoya Pinatohua niñeba caꞌyonaje jama baꞌa: —Jjeya nei Jodio cuana ojee ijjiaꞌijjiani esohuidojojjiya yahuajo nei ojaya etiiquianaja bacua cuana cuiaꞌyo jjima shejo. Ojjaña shequiaja jiquio shejo eyaya oe Jodio dejja ejeanobiajaa huoojeacuayajeajeꞌyo, ma Jodio cuaa sa cani, Jodio quea bihui epojji. Jamajjeya jiquio shejo eꞌe pojjaꞌa eyaya Jesosa pichojea meejeꞌyo, jjeyahua nei. ");
INSERT INTO eseNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pea yani, Mashamaꞌ bajjani, Shomano meshi mese quecua panajji epo. Oya dejja tai, ejeanobiajaa ona quecuaꞌyojji cuana nijje. Eꞌe pojjaꞌa eyaya Mashamaꞌ huoojeacuayajea meejeꞌyo —jamaya Pinato jjashahuabaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jjeyahua nei Jodio dejja cuana Pinato que poeyanaje. Huohui canaje jama baꞌa: —Emeshi mese Pinato, ¡jjeyahua nei huoojeacuayajeaꞌyocue oe Jodio dejja, ecuana quea bihui nee epojji! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pinato jama poanaje baꞌa: —Eꞌe, jjeyahua nei eyaya pichojeajeꞌyo oe Jodio dejja. ¿Ache acuae jja oe pichojeajeꞌyo soꞌo? Eꞌe pojjaꞌa eyaya Jodio cuanaja Emeshi Mese nei Jesosa bajjani pichojeajeꞌyo. ¿Aꞌa eꞌe? —poanaje Pinato. ");
INSERT INTO eseNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pinatoja eba poanaje Jodio etii quea quene nee poani pea cuaa Jesosa nijje jjapeequi majje Jodio etiiquianaja esohui pajea cani. Jamajjeya Jesosa iña mee canaje equecuajeaꞌyojji, Jodio etiiquiaa. Jamajjeya Pinatohua Jesosa pichojea mee sa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jamatii Eyacuiñajji nijje emimijji etiiya ojjaña Jodio ejjachichaqui nequi taaa mee canaje: —¡Mashamaꞌ oe huoojeacuayajeaꞌyocue! ¡Jesosa aꞌa pichojeaꞌyojji! —taaame poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—Jamajjeya ¿yajja acuae oe eyaya Jesosa Quito aje soꞌo, Jodio cuanaja Emeshi Mese nei ca pa coma? —Pinatohua huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jama taaame poanaje baꞌa: —¡Oya me cacajea meecue oe, acui ecueataꞌapeejo! ¡Acui cueataꞌapeejo baꞌehuanasohuajea meecue oe emanoꞌyojji! —taaa neineinaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Yajjajo acuae oya quecuajeꞌyo soꞌo? Oya mimishiꞌama. ¿Apiojji acuaeya jjaya quecuaꞌyo sa aña Jesosa? —Pinatohua huohuiꞌajja canaje. Jamatii taaa majamaja canaje Jodio cuana: —¡Jesosa oe me cacajea meecue oe; acui ecueataꞌapeejo baꞌehuanasohuajea meecue Jesosa, de! —jama taaameya poa Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jamajjeya Pinatohua ohua sa cajo Mashamaꞌ huoojeacuayajea mee caꞌyonaje. Jesosa ca ca huoojea canaje cuiasejjajea majje me cacajeaa emanoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jamajoya emeshi meseja sohuinano cuaa Jesosa dojo canaje emeshi mese chacochacoañani equi dojjo huasijje. Ojjaña sohuinano Jesosa que jjachichaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesosaja daqui oshe huijjiajea mee majje daqui huoꞌo nei huosho mee canaje emeshi mese nisho epojji. Acuisha sipi majje sapahuahuo iya canaje, emeshi mese jayojja nisho epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Majoya ecuiꞌoshajjajo nequinaje ojjaña, Jesosa bihuiajji nisho. Jama bihuia nishome acanaje baꞌa: —¡Miya Jodioja emeshi mese quea caꞌa nee! ¡Baꞌe tiitiiꞌyocue! —sajea nisho canaje cuaa Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Majoya oya sapa cuiapeꞌejea canaje acuiya. Cuia huichaꞌa huichaꞌa canaje. Jesosa cuichojea huichaꞌa huichaꞌa canaje oja yami yasijje. Ecuiꞌoshajjajo nequiya bihuia nisho canaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ojo soa neineiꞌyo majje daqui huoꞌo nei huijjiajeajea canaje; ojaya daqui quia ca oꞌoyanaje. Majoya Jesosa quea huesha dojo canaje me cacajeaa, baꞌehuanasohuajeaa peaꞌai, sohuinano cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jenosanenajo aniya sohuinanohua Jesosa dojo caje, ba cajjequinaje pea dejja Simoni bajjani, Simoni Sinene meshijo baꞌe poeꞌyo; oya Anejanoja ejeajji, oja chahua Shopoja ejeajji. Jamajjeya sohuinano cuaa Simoni acui ecueataꞌapee quea biquie dojo mee canaje Jesosa baꞌehuanasohuajeajji. ");
INSERT INTO eseNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jamaya oya poquinaje eyiyo bajjani Jonijota eyiyo huasijje, Ese Ejjaja esohuijo Esapa Jjii anijji bajjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Esapa Jjii anijji eyiyo huasijje jaasohuaquinaje cuana. Bañaqui majje Jesosa ishi meeꞌajja canaje cuaa acuijjajja na quea sese, pasejo ꞌia jayojja. Ishi meeꞌajja canaje quecua caꞌyajje neeꞌama epojji. Sio majje ishi jjima acanaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Majoya me cacajea caꞌyonaje; baꞌehuansohuajea caꞌyonaje daquimaꞌ. Baꞌehuanasohuajeyo majje oja daqui cuana chicha caꞌyonaje sohuinano cuaa. Iyachichaꞌyo majje, onaaya hueꞌe nisho majje daqui majjo caꞌyonaje ojaya pojji epoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eshequi poe pishanajo, onaaya Jesosa acui ecueataꞌapeejo baꞌehuanasohuajea canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Etehueꞌyo o baꞌe sapa biajje oja bajjani caca canaje, Jesosa bajjani, oya apiojji me cacajea caꞌyonaje huohui epoꞌyojji. Etehueꞌyo jama poa baꞌa: OYA JESOSA JODIOJA EMESHI MESE EPOꞌYOJJI ");
INSERT INTO eseNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesosa baꞌe pejjejo beca siipojji pea acui ecueataꞌapee cuanajo baꞌe huanasohuajea peaꞌai caꞌyonaje, Jesosaja ebianei mijijje, pea shani mijijje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Eꞌe, Eyacuiñajjija esohui huohuijjija etehueꞌyo yahuajo nei nei jayojja jama, jamaya acanaje baꞌa: “Ojjaña cuana jjashahuabaquije jamaya: —Oya dejja mimishi nijje nequinaje”. Yahuajo nei nei jamaya poa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pea dejja cuana ejiojjijje poquianiya Jesosa ba majje esapa jeacajjacajja canaje, soa huisahuisa nequinaje. Jama mimijajime poanaje baꞌa: —¿Aꞌa cuae oe miyaya Eyacuiñajjija mei equi iñajeabichajeaꞌyo majje pea equi iyaje oꞌoya soꞌo, pea beca peejjima cahuime? ¡Baꞌajja socue! ");
INSERT INTO eseNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ache baꞌajja; miya Eyacuiñajjija Bacua Ejja nei jjabaqui majje ca oe ¡acui ecueataꞌapeejo baꞌe nequioqueꞌajjaꞌyo socue, emanoꞌyojji pojjeama! —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Moisesija etehueꞌyo huohuijji, Eyacuiñajji nijje emimijji etii peaꞌai ojo soa neineinaje. Ojee mimimiminaje jama baꞌa: —¿Aꞌa Jesosa ojjaña jaahuanajji epoꞌyojji? Chojja, ona nahuejji pojjeama. Oya ca ca oma nequioqueꞌyo ajja, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jesosa niñeba canaje peaꞌai: —¿Aꞌa cuae jja oe miya Jodioja Emeshi Mese nei poajeꞌyo? ¡Jjabaꞌajjaqui socue! Miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji jjabaqui majje ¡acui ecueataꞌapeejo baꞌe ca oe nequioqueꞌajjaꞌyo socue jjeyahua nei, ecuanaja ebajji! Ba majje ecuaaya: “Miya eꞌe jojo nei Eyacuiñajjija Bacua Ejja poanaje” ajeꞌyo. Siipojji cuaa ma o pejjejo ebaꞌehuanasohuajea baꞌeya peaꞌai Jesosa jamaya niñebame acanaje quea huiso nee. ");
INSERT INTO eseNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Majoya eshequi biacojjajja nequijo shequimaꞌ jayojja poanaje; quea misi nee poanaje ojjaña meshi yasijje. Quijje sinecua eshequi jjajeapaaquiꞌyo majje jiji oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sinecua, quea misi poajo, Jesosa quea yeno neineijo taaa neineinaje: —¿Eli, eli, lama sabactani? —taaame poanaje—; ecue Chii, ecue Chii, ¿yajjajo acuae mo ya jeanaꞌyonaje soꞌo? —Jesosa poanaje Jodioja esohuijo. ");
INSERT INTO eseNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Shajjaꞌajja majje joya quea chipi nee nee nequi jama poanaje baꞌa: —¡Bacue oe! ¡Ohuaya etiiquiana Enia iyaa cani pojjaꞌa, ma yahuajo nei baꞌya poa Enia iyaa cani chi, de! —jama posoya acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jamajjeya oe dejja poquicuajinaje acuijjajja na sese jjequiya. Jjequi majje shajashaja iyanobia canaje ena ejjequi yasijje. Majoya bequiobo sajo quecuahuosho majje Jesosaja enaba huasijje huoo canaje, ojaya eꞌishijji nisho: —¡Ishoa socue! ¡Enia pojjaꞌa poeje o nahueya, o jjequioqueaꞌyohua! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jamatii, taaa neinei oꞌoya majje Jesosa manoꞌyonaje. Chamaꞌyo tii poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesosa manoꞌyajo tii, Eyacuiñajjija equijo daqui quea moo ebaꞌehuana baꞌe Eyacuiñajjiya eyajje jjaisajea meequi caꞌyonaje; biacuajje ebionei jjaisajeaqui meecoo canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ojjaña ba majje, Jesosa taaa neinei majje, manoꞌyonaje ba majje peaꞌai sohuinano huoojeajji poani, ma Jesosa nahuejji poani quea mete nee poanaje: —¡Eꞌe jojo nei de, oya Jesosa Eyacuiñajjija Bacua Ejja poanaje! —sohuinano poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Quea huesha nequiya epona cuaa peaꞌai Jesosa ebaꞌehuanasohuajea baꞌe ba cani. Oya cuana yahuajo Jesosa nijje Janinea meshijo ania poa. Onijje Jenosanena huasijje poeyanaje, oja bobi cuacua meesahuaa. Oya cuana ma bajjani baꞌa: Mania Madanena; Satiaco, oja chahua Jose peaꞌaija enaese Mania bajjani; Semeneoja ehuanase Sanome bajjani peaꞌai; pea epona cuana quea huiso peaꞌaiya ba canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Majoya sinenaje. Mecahuajje epojja ejomishocajji, quea bihui nee ojee eꞌijjiaꞌijjiajji peaꞌai. Jamajjeya acui ecueataꞌapeejo ebaꞌehuanasohua baꞌe meemee ajja. ");
INSERT INTO eseNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jamajjeya sinecua nei dejja Jose bajjani poeyanaje, pea Jose, Amatea meshijo baꞌe. Oya Jodio etii ejjachichaqui nequi cuana nijje nequi. Oya ojjañaja quea boti nee. Ohuaya Eyacuiñajji ojjaña huoojeaꞌyojji poaje ishoaꞌajja cani. Oya Jesosaja epeejji peaꞌai yahuajo. Jamajjeya oya meteꞌama po majje Pinato huasijje poquinaje Jesosajo huohuiya. Poeꞌyo majje ohuaya Pinato huohui cañaꞌyonaje: —Emeshi mese Pinato, Jesosa manoꞌyonaje. Eyaya oya jjequioqueajeꞌyo jjani yasijje ehuananobiaquiꞌyojji —poanaje Jose. ");
INSERT INTO eseNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Joseja esohui shajjaꞌajja majje Pinato jama poanaje baꞌa: —¡De! ¿Aꞌa oya Jesosa manocuajiꞌyonaje? Jamajjeya Pinatohua sohuinano huoojeajji poani, ma Jesosa me cacajeajji epo iyaa canaje. O poeyajo huohuiꞌajja canaje jama baꞌa: —¿Aꞌa eꞌe jojo nei Jesosa manocuajiꞌyonaje? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Eꞌe, oya manoꞌyonaje —poanaje. Jamajoya Pinatohua Jose huoojea canaje jama baꞌa: —Eꞌe, ¡Jesosa dojocue! ¡Mei jjani yasijje huananobiaquicue! ");
INSERT INTO eseNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jamajjeya daqui oshe quea ao nee jjeshe majje Jose poquinaje Jesosa acui ecueataꞌapeejo emanoꞌyo baꞌe yasijje. Jesosa emanoꞌyo baꞌe jjequioquea caꞌyonaje. Daqui oshe eyacua neijo bebo canaje. Dojo canaje mei jjani yasijje, ma oja jjeya nei tio huasijje. Huananobia caꞌyonaje. Majoya mei quea quemo nee jeacajjajjajea canaje mei jjani naba capaꞌyojji. Jesosa mei jjani dojjojo jaa capaꞌyo majje poquinaje Jose pea cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mania Madanena, Joseja enaese Mania bajjani peaꞌai mei jjani yasijje poeyanaje peaꞌai. Jomajo Jesosa jjani yasijje ehuananobiajaa ba canaje, epona cuaa. ");
INSERT INTO eseNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jodioja epojja ejomishocajji jjayejjequiajo, sinecua Mania Madanena, Jacoboja enaese Mania bajjaniya, Sanomeya peaꞌai shiyeshiye iña jjeshe canaje Jesosa shicuijji nisho. ");
INSERT INTO eseNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jamajjeya mecajjeahua nei jjajaꞌaꞌajjaqui jjimahuajo ebionei epojjajo, nomico pojjajo, oya cuana poquinaje jjani yasijje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bañaqui jjimahuajo mimimiminaje jama baꞌa: —¿Aya shai mei quea quemo jeacajjajjajea cajeꞌyo ese dobiquijji? Quea quemo nee nee mei. ");
INSERT INTO eseNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Epona cuana jjani yasijje poe majje ba cañaquinaje jjani huejja ecapajeaꞌyo nequi. ");
INSERT INTO eseNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jamajjeya jjani ai yasijje dobiquinaje. Dobiqui majje epona cuaa eshoꞌi ai ba canaje. Oja daqui quea oshe nee nee, quea ao nee. Jesosaja equipajaajji biajje ani ba canaje esohuidojojji ebianei mijijje ani. Jjeya ca ca Jesosa chamaꞌ. Ba majje epona cuana quea mete poanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jamaya oya epona cuana nijje poanaje baꞌa: —¡Aꞌa quea mete pojji! Miya ecuea eba. Eꞌe, miyaya Jesosa ma Nasanenajo baꞌya poa saꞌajjaꞌyo poequi, ma acui ecueataꞌapeejo manoꞌyonaje. Chamaꞌ oya jjeya jiquiojo. Shequi oꞌoyanaje ca jja coma. ¡Eꞌe, quiaꞌo jiquio baꞌajjahuaꞌyo socue! Jiquiojo jaanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jamajjeya ¡jjeyahua nei poquicuajicue oja epeejji huohuiya! ¡Jama huohuime acue baꞌa: “Jesosa pa shequiꞌyonaje” acue! “Oya jjeya nei Janinea meshi yasijje poquije miquiana poqui jjimahuajo” o shajjaꞌajjajji cuana huohuiquicue. ¡Peno oe huohuiñaquicue Jesosaja esohui ma ohuaya huohui canaje oe aꞌa pajeaꞌyojji! ¡Oya oe jocuama baquicue! —esohuidojojjiya epona cuana acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jamajjeya epona cuana jjani esecue yasijje cuayaquiꞌyo majje poquicuajicuajinaje. Quea mete neejo oya cuana piopionaje. Pea nijje mimi jjima Jesosajo. Cuajicuajinaje Jesosa shajjaꞌajjajji cuana esohuidojojjija esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Eꞌe, ebionei epojjajo, nomico pojjajo, Jesosa shequi oꞌoya majje, jjanequijaꞌaquiꞌyo majje peaꞌai, Mania Madanenaa ebionei oya ba caꞌyonaje. Oya Maniaja yahuajo eshahua quea huiso dobiquiyajo, Jesosaa eshahua cuana huoojeacuayajea caꞌyonaje me oejje pea beca huisome. ");
INSERT INTO eseNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Majoya Jesosa ba majje Maniaa o shajjaꞌajjajji cuana huasijje poquicuajinaje huohuiya. Jesosa emanoꞌyo tii jaa posojo, oya cuana pa neinei aninaje quea yeno. ");
INSERT INTO eseNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jamajjeya Maniyaa oya cuana huohui cañaquinaje Jesosa eshe oꞌoya: —Eyaya oya banaje eꞌe jojo nei —acanaje Maniaa. Jamatii Maniaja esohui shajjaꞌajja majje oya cuana jama poanaje baꞌa: —Eꞌe pojjaꞌa. Chojja, siajje miya poani, Mania —acanaje cuaa, Jesosa shequi oꞌoya ajja poso acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Majoya Jesosaja epeejji becanejjijji peaꞌai ejiojjijje poquijejo, Jesosa pea jayojjaya jjanequijaꞌaquinaje onijje. Jesosa ba jjima poanaje cuanaja. ");
INSERT INTO eseNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Quijje yejje nei oya eꞌe jojo nei Jesosa ba majje oya cuana poquinaje pea eshajjaꞌajjajji cuana huohuiya. Jamatii ojjaña jama poanaje baꞌa: —Eꞌe pojjaꞌa, de. Chojja de, oya manoꞌyo tii —ojjaña cuana poanaje, Jesosa shequi oꞌoya ajja poso acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Quijje Jesosa shajjaꞌajjajji cuana 11 huisome oe equijo ojee ijjiaꞌijjia anijo Jesosa onijje jjanequijaꞌaquiꞌyonaje. Oya cuana tecuea canaje jama baꞌa: —¿Apiojji acuae quiana quea sapa caꞌa poani? ¿Apiojji shajjaꞌajja jjima onajaya ehuohuiꞌyo eya eshe oꞌoya ba majje? ¡Bacue eya eꞌe jojo nei eshequiꞌyo, jjabahuejjaquicue! —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Majoya Jesosaa oya cuana jama acanaje baꞌa: —¡Poquicue ojjaña cuana huasijje, ma ojjaña meshijo baꞌe yasijje! ¡Ecuea esohui quea pame nee ebaꞌe tiitiiꞌyojjijo ba meequicue! ¡Enijje jjapeequi meequicue! ¡Enijje jjapeequiyajo enajo besa meecue! ");
INSERT INTO eseNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ojjaña joya enijje jjapeequiani Eyacuiñajjiya baꞌe tiitii mee cajeꞌyo. Enijje jjapeequiyajo, ¡ojjañaja ebajji onaaya oya cuana besa meequicue! Ojjaña joya enijje jjapeequiꞌyo ajja ca ca Eyacuiñajjiya quea nee nee po mee cajeꞌyo, quea mimishi poanajejojo. Jamajjeya Eyacuiñajjiya oya cuanaja mimishi cuanajo quea yeno po mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Ecuea epeejji cuana eyaya ameejeꞌyo ma dejjaa ajjima acani. Oya cuana eyaya quea caꞌa nee po meejeꞌyo, eshahua cuana dejjajo nequi huoojeacuayajea meejeꞌyo. Pea esohui ojaya cuanaja ba jjima mimi meeje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Peyo se najji ba jjima iña majje manoꞌyo jjima po meejeꞌyo eyaya. Ena pase nei nei paseꞌama poso ishijea majje, manoꞌyo jjima po meeje eyaya. Ecuea epeejji neiya emano biajje eme huana majje jiquio quea aja poaje; eyaya jjaajaqui meejeꞌyo, huaquia meejeꞌyo peaꞌai —Jesosaa o shajjaꞌajjajji cuana huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Majoya Emeshi Mese nei Jesosa pea cuana nijje mimiajo, oja Chiiya, Eyacuiñajjiya jjequisohua caꞌyonaje eyahuasijje. Jomajo oya Jesosa anioquenaje oja Chii ebianei mijijje onijje ojjaña huoojeaꞌyojji epojji. ");
INSERT INTO eseNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Majoya o shajjaꞌajjajji cuaa Jesosaja esohui huohuiqui canaje ojjaña cuana huasijje. Ojaya esohui jayojja jama Emeshi Mese nei Jesosaa oya cuana ameesahua canaje ma dejjaa ajjima acani ojjañaja ebajji ojaya esohui cuana eꞌe nei nei. Jamaya ojjaña ba mee canaje Jesosaa oya cuana huoojea canaje ojaya esohui huohuiya. Jesosaa eya Macoso bajjani jiquio esohui tehue mee canaje. Mahuiso. Apoa.");
INSERT INTO eseNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eyaya mi que tehuenaje Teopino achajja Jesosa ebajji. Quea dejja huisohua Jesosaja ehuohuiꞌyo cuanajo tehue sa aca cua, huohui mee sa aca cua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ojaya epeejji cuaa, ojaya esohui huohuijji cuaa, Jesosa ba neinei ca cua. Ohuaya ecuanaya huohui neinei ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jamajjeya eyaya catehueꞌyahua onaa huohui caꞌyoqui Jesosajo. Jjeya eyaya mi que tehuenaje, Teopino. Jiquio esohui eꞌe jojo nei Jesosajo. Eyaya shajjaꞌajja neineinaje onaa huohui caꞌyoqui Jesosajo. Majoya jjashahuaba neineiquinaje jiquio etehuejji, jamajjeya eꞌe jojo nei jiquio esohui. ");
INSERT INTO eseNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tehuenaje eyaya miquea Jesosa eba neineijji. Mi jjashahuaba neineiquijji eyaya tehuenaje, de. Jamajjeya ¡ba neineicue jiquio esohui ecue tehueꞌyo! ");
INSERT INTO eseNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yahuajo pishana Jodioja emeshi mese nequia cua. Yohua bajjani cua baꞌa: Enode. Ma eshequiajajo tiiya aje baꞌya cua Eyacuiñajji nijje mimiani yohua bajjani baꞌa: Sacania. Oya chacochacoania cua Eyacuiñajji nijje emimijji cuana nijje, ma dejja yohua bajjani nijje baꞌa: Abiase dejja cuana nijje. Oya cuana Eyacuiñajji nijje mimiania cua. Sacaniaja ehuanase yohua bajjani cua baꞌa: Isameni. Isamenija etiiquiana cuana Eyacuiñajji nijje mimiani peaꞌai cua. Anoni dejja bajjani cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sacania Eyacuiñajjija epeejji nei nei cua, oja huanase o jayojja nei neiya cua. Oya cuaa shajjaꞌajja neinei ca cua Eyacuiñajjija esohui. ");
INSERT INTO eseNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jamatii bacuamaꞌ cua; ojaya ehuanase jjamejoqui ajja neinei cua. Ehuanase epona tii cua; oya edejja tii peaꞌai cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Pea pojjajo Sacania jjachichaquia cua Eyacuiñajji nijje emimijji cuana nijje. Pea cuaa oya jama aca cua baꞌa: —Sacania, ¡jjeya jiquio pojjajo Eyacuiñajji nijje mimicue! ¡Jjeyahua nei mee nei dobiquicue Eyacuiñajjija equi yasijje, equi quecuayijji sisi yasijje! ¡Dobiqui majje acui shaa dahua huichachajeacue huichacha shiye epojji! ¡Ma ojjañaa aca cua jayojjaya oe acue! Dobiqui majje Sacaniaa jamaya aca cua Eyacuiñajjija equijo nequiya. ");
INSERT INTO eseNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Beca cuana aje oe esecuejo nequia cua Eyacuiñajji nijje emimijji peaꞌaiya. ");
INSERT INTO eseNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sacaniaa aje oe acui shaa quea shiye dahua huichachajea canequia cua acui shaa edahuajeajji biajje iya ani. Majoya aje oe Eyacuiñajjija esohuidojojji jjanequijaꞌaquia cua, edahuajeajji ebañei mijijje nequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sacania esohuidojojji ba majje piopio neineiꞌya cua esohuidojojji ba po jjima jjejojoya. ");
INSERT INTO eseNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Majoya aje oe esohuidojojjiya jama aca cua baꞌa: —Sacania, ¡aꞌa piopiojji! Miya Eyacuiñajji nijje mimi majamajanaje ebacua yajjijo. Jamajjeya miya Eyacuiñajjiya shajjaꞌajja canaje miquea esohui ebacua yajjijo. Miquea ehuanase aje oe jjamejoquije. Majoya ¡ebacua cuayajo Huani bajjani acue! ");
INSERT INTO eseNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Miya o cuayajo quea bihui nee nee cuaje. Pea dejja cuanaya quea bihui nee nee cuaje ebacua cuayajo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Oya Eyacuiñajjija epeejji nei nei cuaje, jamajjeya miquianaya quea bihui nee cuaje. Oya acuijjajja na sese ishi ajja cuaje, ecahuishi ishi ajja peaꞌai cuaje. Edojjoshahua Bameya jaahuana cajeꞌyo oya cuayajo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ohuaya Eyacuiñajjija esohui huohui bame bame caje. Jamajjeya quea huiso Jodio cuaa shajjaꞌajja caje Eyacuiñajjija esohui. Ohuaya jjapeequi mee cajeꞌyo quea huiso Jodio dejja cuana Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Huaniya ebionei esohui huohui caje, majoya aje Quitohua, Eyacuiñajjija huoojeaꞌyohua esohui huohui caje. Huani Enia jayojja cuaje. Enia ma etiiquiana cua; Eyacuiñajjija esohui huohuijji nei nei cua. Huani Eyacuiñajjija esohui huohui po nequije. Shajjamaꞌ cuana ohuaya sohuihuohui caje. Majoya shajjamaꞌ cuaa ojaya esohui shajjaꞌajja caje; jjapeequije Eyacuiñajji nijje. Ojaya esohui shajjaꞌajja majje Quitoja esohui shajjaꞌajja sa acaje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sacaniaa huohuiꞌajja ca cua esohuidojojji jama baꞌa: —De, ¿achajja acuae po cajji soꞌo? Oya ca iña edejja tii nojinoji aña, ecuea ehuanase epona tii peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Esohuidojojjiya jama tecueame aca cua baꞌa: —Eya bajjani Jamieni, eya Eyacuiñajjija esohuidojojji nei nei cueyanaje. Ohuaya eya huoojea canaje minijje mimiya. Ecuea esohui quea bame miyaya shajjaꞌajjanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Miya jjashajjaꞌajjaqui ajja cuanaje, jamajjeya miya mimi ajja cuaje. Huani cuayajo ca mi ca oe mimijeꞌyo. Ma ecua miya eyaya huohuinaje jayojjaya cuaje miya —jamaya cua esohuidojojji. Majoya aje Sacania mimi ajja po mee caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pea cuaa esecuejo nequia ishoaꞌajja ca nequia cua Sacania. Jama huohuiꞌajjame aca cua baꞌa: —¿Yajjajje shai Sacania eyiyedojjo tii nequi? ");
INSERT INTO eseNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Majoya Sacania esecue yasijje cuayaꞌyo majje mimiꞌyo ajja cua. Eme nei ca ca oe huo canequia cua Sacaniaa. Sohuimajojo jama aca cuaa cua baꞌa: —Ohuaya pojjaꞌa ba canaje esohuidojojji nei eyiyedojjo nequi, de. ");
INSERT INTO eseNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sacania Eyacuiñajjija equijo chacojeyo majje poquia cua oja equi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Quijje pishana Sacaniaa ehuanase bacua jea ca cua, oꞌejji po majje. Isameni me oejje baꞌime cuayaquiꞌyo jjima; ania cua oja equijo tii. Oya jjashahuabaquia cua jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Eyacuiñajjiya eya jjamejoqui meesahua canaje quea bihui epojji. Jjeya pea cuana mimijajiꞌyo ajja e bacuajjijo —jamaya Isameni cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Janinea meshijo oe epona ahuemaꞌani ania cua, Mania bajjani. Oya Nasanena cuiñajjijo ania cua. Isameni Maniaja enene mese cua. Isameni me oejje oe baꞌime oꞌejji anijo Eyacuiñajjiya ma esohuidojojji huoojea ca oꞌoya cua Mania que. Mania jjahuiaqui jjima cua; dejja ba po jjima ania cua. Oya ca jjahuiaqui sa cua dejja yohua bajjanijo baꞌa: Josejo. Joseja baba etiiquiana yohua bajjani cua baꞌa: Dabi. Dabi Jodio dejjaja emeshi mese yahuajo nei nei cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Esohuidojojji dobiquia cua Maniaja equi yasijje. Jama mimime cua onijje baꞌa: —Mania, yani eya. Eya Eyacuiñajjiya huoojea canaje mi que mimiya. Miya ca ca oe ohuaya bacaca canaje ejjamejoquijji. Eyacuiñajji miquea Emeshi Mese nei, miya ohuaya jaahuana cani —jamaya cua esohuidojojji. ");
INSERT INTO eseNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mania quea mete cuanaje esohuidojojjija esohuijo. Majoya oya jama jjashahuabaquime cua baꞌa: —¿Apiojji shai oya jama mimime cuani enijje? ");
INSERT INTO eseNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Esohuidojojjiya jama aca cua baꞌa: —Mania, ¡aꞌa quea mete pojji! Eyacuiñajjiya miya quea jea nee acani. ");
INSERT INTO eseNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jjeyahua nei miya oꞌejji anije, ebacuajje dejja cuaje. ¡Yohua bajjani acue baꞌa: Jesosa! ");
INSERT INTO eseNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Oya quea bame nee nee baꞌeje. Pea cuaa bajjani caje Eyacuiñajjija Bacua Ejja nei oya. Eyacuiñajjiya oya po mee cajeꞌyo ojjañaja Emeshi Mese nei epojji; Dabi emeshi mese jayojja oya cuaje. Jodio dejjaja Emeshi Mese po tiitiijeꞌyo —jamaya cua esohuidojojji. ");
INSERT INTO eseNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maniaa esohuidojojji huohuiꞌajja ca cua jama baꞌa: —¿Achajja jjamejoquime acuae po cajji soꞌo, ca dejja ba po jjima? ");
INSERT INTO eseNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Esohuidojojjiya jama aca cua baꞌa: —Edojjoshahua Bame nei mi que cueje. Bo jayojja mi que anioqueje. Eyacuiñajjiya miquea ebacua baꞌe mee caje. Jamajjeya miquea ebacua quea bame nee nee cuayaje oya Eyacuiñajjija Bacua jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ecuea esohui eꞌe jojo nei, mique nene Isameni eshoꞌyahua bacuamaꞌ tii cua. Jjeya ca ca oe jjamejoquinaje. Me oejje oe baꞌime ejjamejoqui ani. Jamajjeya ecuea esohui eꞌe jojo cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Eꞌe, Eyacuiñajjiya camajaꞌama po mee cajeꞌyo ojjaña —jamaya esohuidojojji cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jamajjeya Mania jama cua baꞌa: —Eya Eyacuiñajji nijje jjapee neineiqui sa cuani. Miquea esohui jayojja jama caꞌa cahua Eyacuiñajjiya —jamaya cuanaje Mania. Majoya esohuidojojji poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Quijje pishana Mania poquia cua eꞌaꞌi meseja equi yasijje, Isamenija equi yasijje. Jodea meshi bajjani yasijje poquicuajinaje, eyiyojo baꞌeca huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Isamenija equi yasijje dobiqui majje Mania jama cua baꞌa: —Eya mi que cueyanaje anicuaa. ");
INSERT INTO eseNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","O mimiajo Isamenija bacua teejo baꞌe moquiquia cua. Isameni quea bihui cua; Edojjoshahua Bameya mimi mee ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jamajjeya Isameni jjanobajjima nei mimia cua Mania nijje jama baꞌa: —Mania, miya Eyacuiñajjija quea jea nee nee pea epona jayojja jama pojjeama. Jamajjeya miquea ebacua teejo baꞌe ojaya quea jea nee nee peaꞌaiya. ");
INSERT INTO eseNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eꞌe, miya cueyanaje e que anicuaa, jamajjeya eya quea bihui nee cuani miya Eyacuiñajjija Bacua baꞌe meejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mi ecue equi yasijje dobiajo ecuea ebacua moquiquinaje teejo baꞌe. ");
INSERT INTO eseNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Eꞌe, miyaya Eyacuiñajjija esohui shajjaꞌajja neineinaje, jamajjeya jamaya acajeꞌyo —jama mimimeya Isameni cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Majoya aje Mania jama mimime cua baꞌa: —Jjeya eya quea bihui nee nee Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Eyacuiñajji ecuea Emeshi Mese nei cuani. Ohuaya ecuea mimishi cuijea caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jamatii eya epona, ahuemaꞌani. Eya baꞌe sa cuani Eyacuiñajjija yajjijo. ¿Yajjajo shai Eyacuiñajjiya eya bacaca canaje? Jamatii ojjaña cuana aje oe mimi tiitiijeꞌyo ejo jama baꞌa: “Mania quea bihui nee nee. Eyacuiñajjiya oya bacaca canaje”. ");
INSERT INTO eseNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Eyacuiñajji quea caꞌa nee nee. Jamajjeya eya ohuaya quea bame acanaje. Oya mimishiꞌama nei nei, quea bame nee nee baꞌe. ");
INSERT INTO eseNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eyacuiñajjiya ojaya epeejji cuana jaahuana cani. Eꞌe, ojjaña joya onijje jjapeequiani Eyacuiñajjiya jaahuana cani etiiquiana yahuajo nei baꞌya cua, eshoꞌiquiana jjeya nei baꞌyani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","52","Beca cuana onijje jjapeequi jjima ohuaya caꞌaꞌama po mee caꞌyani. Dejja mimishi cuana caꞌaꞌama po mee caꞌyani, emeshi mese mimishi cuana ohuaya caꞌaꞌama po mee caꞌyani. Ojaya epeejji ca ca oe ohuaya quea caꞌa po mee caꞌyani. ");
INSERT INTO eseNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ojjaña cuana oja esohuijo jjashajjaꞌajjaqui sa cuanijo ohuaya jjashajjaꞌajjaqui mee cajeꞌyo. Beca cuana ca ca oja esohuijo jjashajjaꞌajjaqui sa po ajjajo ohuaya jjashajjaꞌajjaqui mee jjima acajeꞌyo; jeajea cajeꞌyo cuaqui yasijje jjashajjaꞌajjaqui sa po ajjajojo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Eyacuiñajjiya Jodio dejja cuana jaahuana caje. Jamajjeya ohuaya oja Bacua Ejja huoojea caje Jodio dejja jaahuanajji epojji. Ohuaya pajeaꞌyo jjima acajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jamaya ohuaya esejaya etiiquiana Amajama jaahuana ca cua. Oja bacua cuana peaꞌai jaahuana ca cua. Oja osecua cuana jaahuana tiitii ca cua. Jjeya nei ohuaya eseya jaahuana cani peaꞌai —jama bihuiameya Maniaa Eyacuiñajji aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Majoya Mania pea beca peejjima baꞌime ania cua oja nene nijje. Majoya aje Mania poquiꞌya cua oja equi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Quijje Isamenija bacua cuaya cua; yahue cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ojaya huapa pojjeama cuana cueya cua oja bacua baa. Ojjaña Eyacuiñajji nijje quea bihui cua Isamenija ebacua cuayajo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Me oejje pea beca peejjima cahuime po majje ojjaña cue oꞌoya cua ebacua bajjaniya; oja cuiishasha jehuisejjajeaa peaꞌai. Ojjañaa bajjani sa aca cua ejeajjija bajjani. ");
INSERT INTO eseNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Isameniya ca jama aca cua baꞌa: —Chojja, ¡yohua bajjani oe acue baꞌa: Huani! ");
INSERT INTO eseNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pea cuaa jama aca cua baꞌa: —¿Apiojji acuaeya ma bajjani aje? Chamaꞌ aje jja che pea bajjani Huani. ");
INSERT INTO eseNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jamajjeya aje jja oe ojjañaa Sacania huohuiꞌajja ca cua: —¿Ae bajjani acuae jja cuaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Majoya Sacaniaa mimi ajja jjejojo jama tehueme aca cua baꞌa: —¡Huani bajjani oe acue! Ojjaña jama cua baꞌa: —Eꞌe, ¿apiojji shai? ");
INSERT INTO eseNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Majoya aje Sacania mimi mee ca oꞌoya cua Eyacuiñajjiya. Jamajjeya ohuaya Eyacuiñajji bihui ca oꞌoya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ojjaña cuana ca jja ca jama cua baꞌa: —De, Sacania mimiꞌya, de. Majoya ojjaña cuana poquia cua huohui pohua, ojjaña eyiyojo baꞌeca cuana huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ojjañaa shajjaꞌajja majje huohuiꞌajja ca cua jama baꞌa: —Eyacuiñajjiya jaahuana cani Sacaniaja bacua, Huani. Oya quea caꞌa nee nee cuaje; Eyacuiñajjiya quea bame nee nee baꞌe meesahua caje Huani. ");
INSERT INTO eseNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sacania Edojjoshahua Bameya sohuicuaya mee ca cua. Jama sohuicuayame po mee ca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Eseyaya oe Eyacuiñajji ejjabihuiaqui, ojjañaa. Oya esejaya Emeshi Mese nei, Jodio dejjaja Emeshi Mese nei, de. Ohuaya esejaya mimishi cuana cuijea caꞌyani. ");
INSERT INTO eseNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ohuaya Quito huoojea caje ese que. Ma ehuoojeaꞌyo Quito quea sohui poja nee nee cuajeꞌyo. Quitohua eseya quea caꞌa po mee cajeꞌyo. Ojaya etiiquiana Dabi emeshi mese cua yahuajo nei iye caꞌa caꞌa cua, Quito ca ca oe ojjañaja Emeshi Mese cuaje ese jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jamaya yahuajo tehue ca cua Eyacuiñajjija esohui huohuijji cuaa. Tehue majamaja ca cua Quitojo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jama tehueme aca cua baꞌa: “Yani dejja cuana ecuana nijje mimijaji neineiani. Ecuana botiꞌama cuani, cuiajea sa acani. Jamajjeya aje oe ecuanaya Eyacuiñajjiya jaahuana cani”. Jamaya esohui etehueꞌyo cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","—Eyacuiñajji yahuajo mimia cua ecuanaja etiiquiana nijje, Amajama nijje jama baꞌa: “Eyaya Quito huoojeajeꞌyo miquiana ojjaña jaahuanajji”. Jamaya aca cua ohuaya ojaya epajeaꞌyojji pojjeamajojo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Jamajjeya eseyaya Eyacuiñajji ejjabihuiaqui; Quitohua dejja mimishi cuanajo meteꞌama po mee cani. Eseya jaahuana cajeꞌyo. Quea bame baꞌe mee cajeꞌyo mimishiꞌama epoꞌyojji —jama sohuicuayameya Sacania cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Majoya Sacaniaa oja bacua jama aca cua baꞌa: —Miya ecue bacua oe nei. Miya Eyacuiñajjija esohui huohuijji cuajeꞌyo. Ohuaya miya huoojea caje ebionei. Huohuicue jama baꞌa: “¡Oya shajjaꞌajjacue! Oya Quito, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji cueje”. ");
INSERT INTO eseNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Huani, miyaya ojjaña cuana huohuicue jiquio esohui jama baꞌa: “Eyacuiñajjiya ojjaña cuanaja mimishi cuijea cajeꞌyo onijje jjapeequianija”. ");
INSERT INTO eseNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jamaya eseya Eyacuiñajjiya quea jea nee nee acajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jamajjeya ecuana meteꞌama cuaje onijje jjapeequi majje. Poquije eyahuasijje onijje ebaꞌe tiitiiꞌyojji. Ohuaya eseya quea bihui po mee cajeꞌyo —jamaya Sacania cua. ");
INSERT INTO eseNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Majoya ebacua tii majje quea caꞌa nee nee cua; Eyacuiñajjija epeejji nei nei cua. Oya oe nei baꞌya cua quimajo. Majo tiiya aje Huaniya esohui huohui ca cua Jodio dejja cuana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Huani cuaya cua shejo emeshi mese yohua bajjani cua baꞌa: Agosto Sesa. Emeshi meseya echacojji cuana huohui ca cua jama baꞌa: —¡Sicoquicue ecue meshijo baꞌe cuana! ¿Ache huiso baꞌajjaꞌyo socue? ¡Huohuicue ojjaña dejja cuana jama baꞌa: “¡Poquicue mi cuayacua meshi yasijje mique bajjani tehueya; jamaya emeshi mese cuanaje!” acue! —jamaya Sesaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Emeshi meseya Sesaa jama sico coome aca cua. Ma shejo tiiya pea emeshi mese Sineño bajjani cua; ojaya meshi Sania bajjani cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jamajjeya aje oe ojjaña poquia cua o cuaya cua meshi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Jose, Maniaja ejajiba cua. Jose Nasanenajo baꞌeja jajiba cua, Janinea meshijo. Oja etiiquiana Dabi cua, yahuajo Dabi baꞌya cua Benenajo, Jodea meshijo. Jamajjeya Jose poquia cua Benena huasijje emeshi meseja esohuijo oja bajjani tehue meeya. Jose, oja shiye nijje poquia cua. Quea huesha poquia cua. Mania ebacua cuayajeaꞌyo pana nei poquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Majoya aje Benena bañaqui majje Maniaja bacua cuayañaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Quea dejja huiso ania cua Benenajo jjabajjani tehue meequiya poqui. Jamajjeya chamaꞌ equi ejaachichajji cua. Jamajjeya aje oja bacua cuaya cua anaꞌai jaajji equijo. Ojaya ebacua cojjasobo cuaya cua jomajo. Cuayajo ohuaya bebo ca cua daqui oshejo. ");
INSERT INTO eseNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma mecajje aje Benenajo chipi nei pishana ñajjajja jaahuanajji cuana ñajjajja cuiña po aña cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Majoya aje esohuidojojji jjajaꞌaquia cua. Majoya aje oe o chipi nei jeajahuajahua ca cua esohuidojijjiya. Mete neineiꞌya cua ñajjajja jaahuanajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Esohuidojojji jama cua baꞌa: —¡Aꞌa quea mete pojji! Eyaya esohui quea bame nee huohuiaña ojjaña dejja cuana quea bihui nee po meejji. ");
INSERT INTO eseNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jjeya nei cuayanaje oe ebacua Dabija meshijo. Ma ebacua Eyacuiñajjija huoojeaꞌyo. Ohuaya miquianajaya mimishi cuijea cajeꞌyo; yohua bajjani cuaje baꞌa: Quito. ");
INSERT INTO eseNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","¡Miquianaya poquicue ebacua baa Benena huasijje! Jomajo aje anaꞌai jaajji equijo ebebo jaa oja nae nijjeya, oja chii Jose nijjeya peaꞌai —jamaya cua esohuidojojji. ");
INSERT INTO eseNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Majoya aje quea huiso esohuidojojji cuana jjajaꞌaquia cua. Sohuicuayanaje ojjaña esohuidojojji cuana Eyacuiñajji bihuiajji. Jama sohuicuayame cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Eyacuiñajji quea caꞌa nee nee. Eyajo baꞌe, quea ao nee nee. Eyacuiñajjiya ojjaña ojaya epeejji cuana ojjaña meshijo baꞌe quea bihui po mee caje”. ");
INSERT INTO eseNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Majoya esohuidojojji baꞌesohuaquiꞌya cua eyahuasijje. Ñajjajja jaahuanajji cuana jama mimime cua baꞌa: —De, cueꞌajjaa Benena huasijje. Ma esohuidojojjiya huohui canaje jayojjaya aje seya aje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Majoya poqui cuajicuajia cua ebacua saꞌajjaa. Majoya anaꞌai jaajji equijo jaa ba cañaquia cua ebacua, Mania, Jose peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Majoya ba majje huohuiꞌajja cañaquia cua esohuidojojjija esohuijo ebacuajo. Pea cuana huasijje huohui ca cua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Beca cuana shajjaꞌajja majje jjashahuabaquia cua ñajjajja jaahuanajji cuanaja esohuijo. Quea bame cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mania jjashahuabaquia cua peaꞌai. Pajeaꞌyo jjima aca cua ñajjajja jaahuanajji cuaa huohui canaje esohui. ");
INSERT INTO eseNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Majoya ñajjajja jaahuanajji cuana poquiꞌya cua ñajjajja jaahuanaꞌyohua. Poquijeꞌyohua Eyacuiñajji bihuia nei nei ca poquiꞌya cua. Esohui quea huiso sohuicuaya cua: —Esohuidojojjija esohui eꞌe jojo nei —cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Me oejje pea beca peejjima cahuime cuajo Jesosaja naeya oja chiiya peaꞌai bajjani canaje Jesosa. Ma esohuidojojjija esohui jayojja Mania jjamejoqui jjimahuajo bajjani ca cua. Jesosaja cuiishasha jehuisejjajea ca cua peaꞌai, ojjaña Jodioja ebacua jayojjaya jama aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Baꞌi oe cuajo Maniaa Joseya peaꞌai Jesosa dojo ca cua Eyacuiñajjija equi yasijje Jenosanena huasijje. Maniaa Eyacuiñajjija equi yasijje dobiqui jjimahuaa Moisesija etehueꞌyo jayojja aca cua. Majoya Jesosa dojodobiaqui canaje Eyacuiñajjija equi yasijje huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jamaya aca cua Moisesija etehueꞌyojo baꞌa: “¡Ebacua cojjasobo dejja huohuicue Eyacuiñajji yasijje! ");
INSERT INTO eseNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","¡Becanejjijji peaꞌai huiaꞌ quiacue Eyacuiñajji nijje mimiani yasijje equiyo jeyojeyoꞌyojji cuaqui pohui pojji epoꞌyojji! Jamaya miya ajo Eyacuiñajjiya mimishi cuijea cajeꞌyo. ¡Jamaya Eyacuiñajji sosequiajji acue!” Jamaya Moisesija etehueꞌyo cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oe Jodio etii Simeoni bajjani Jenosanenajo baꞌya cua. Oya Eyacuiñajjija epeejji nei quea bame nee nee cua. Ohuaya Quito ishoaꞌajja ca ania cua Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Jamatii jjashahuabaquiani Eyacuiñajjijo, jamajjeya Edojjoshahua Bame ojo nequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jamaya Edojjoshahua Bame onijje cua baꞌa: —Miya emanoꞌyojji pojjeama Eyacuiñajjija huoojeaꞌyo cue jjimahuajo. ");
INSERT INTO eseNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jamajjeya Edojjoshahua Bameya Simeoni poqui mee ca cua Eyacuiñajjija equi yasijje. Simeoniya Jose, Mania Jesosa bishamijji nequi ba ca cua Eyacuiñajjija equijo. ");
INSERT INTO eseNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoniya ebacua Jesosa aña majje ba ca cua. Eyacuiñajji bihuia ca cua Jesosa ohua ba mee cajje. Jama cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","—Eꞌe de, jjeya nei Eyacuiñajjiya huoojea canaje ma ohua huoojeapana ca cua; jamajjeya ohuaya eya ba mee canaje. Jjeya eya poquijeꞌyo Eyacuiñajji yasijje quea jaji nee ebaꞌe tiitiiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ojjaña meshijo baꞌe cuaa Jesosa ba caje, Eyacuiñajjija huoojeaꞌyo ojjañaja mimishi cuijeaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jesosaa ojjaña dejja cuana quea jjashahuabaqui jaꞌa nee po mee cajeꞌyo Eyacuiñajjija esohuijo. Jesosa Emeshi Mese nei epojjijojo, Jodio dejja cuana quea bihui cuajeꞌyo —jamaya Simeoni cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Majoya Jesosaja chii, enaese peaꞌai jjashahuabaquia cua Simeonija esohuijo jama baꞌa: —Eꞌe de, Simeonija esohui quea bame nee nee Jesosajo. ");
INSERT INTO eseNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Majoya aje Simeoniya Mania, Jose peaꞌai jama aca cua baꞌa: —Miquianaya aje Eyacuiñajjiya quea bame acajeꞌyo. Mique bacua quea caꞌa po mee caje. Jaahuana cajeꞌyo. Mania, miya Jesosaja enaese. Mique bacuaa Jodio cuana jjashahuabaqui mee cajeꞌyo Eyacuiñajjijo quea huiso nee. Beca dejja cuana jjapeequijeꞌyo Eyacuiñajji nijje. Beca cuaa cajaa acaje, jjapeequi sa po ajja Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mimijajije Jesosa nijje cuana. Oya quecua cajeꞌyo cuaa. Majoya aje oe miquianaya quea yeno cuaje ma cuanajoya —jamaya Simeoni cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jomajo oe epona tii ania cua; Ana bajjani. Eyacuiñajjija epeejji nei nei cua; Panoaneja bacua piona. Ojaya huapa pojjeama Asene bajjani cua. Yahuajo oya jjahuiaquia cua. Oja yahue nijje baꞌya cua me oejje beca, 7 shequiajame. Majoya aje ojaya yahue manoꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jamajjeya quea huiso nee nee shequiajame, 84 shequiajame ania cua. Etii nojinoji nei eꞌahuemanoꞌyo ania cua. Eyacuiñajjija equijo jjeya ani, cuayaqui ajja neinei ania cua. Jamatii mimiania cua Eyacuiñajji nijje, bihuiabihuia tiitiiania cua ojjaña pojjajo. ");
INSERT INTO eseNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anaa ba ca cua Jesosa. Quea bihui nee cua. Jamajje dejja cuana nijje mimia cua joya Eyacuiñajjija huoojeaꞌyo ishoaꞌajja po ani nijje jama baꞌa: —¡Eꞌe ee bacue jiquio ebacua, Jesosa Quito cuayanaje! Ohuaya quea bei baꞌe mee cajeꞌyo Jodio cuana. Ojjaña cuanaja Emeshi Mese nei cuajeꞌyo —jamaya Anaa aca cua cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ojjaña Moisesija etehueꞌyo acua ajeyoꞌyo majje Jose oja huanase nijje, Jesosa peaꞌai nijje poquia cua. Ma o ebionei baꞌya cua meshi yasijje poqui oꞌoya cua, Nasanena huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jomajo Jesosa tiia cua; quea caꞌa nee nee, quea jjashahuabaqui jaꞌa nee cuanaje. Eyacuiñajjiya oya jaahuana ca cua; quea bei nee nee ojo cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesosaja chii oja nae nijje poqui nequia cua Jenosanena huasijje pea Jodio cuana nijje ojjaña shequiajajo. Pascua pohua poquia cua Eyacuiñajji bihuiaa. Yahuajo nei Jodio etiiquianaja bacua cuana esohuidojojjiya cuiaꞌyo jjima aca cua shejo poquia cua ojjaña nijje ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesosa etii shacuimaꞌ nequi po majje, 12 shequiajame po majje poqui peaꞌaiya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oe semana Jenosanenajo aniya ojjaña cuaa Eyacuiñajji bihuia ca ania cua. Majoya Pascua jjayejjequiajo ojjaña cuana poqui caꞌya cua. Jesosa ca ca poquiꞌyo jjima cua. Jamatii ojaya enaeseja baꞌyo jjima cua, oja chiija peaꞌai. Jesosa pea cuana nijje pojebeꞌyani poso aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Majoya aje oe cahuime cuajo Jesosaja enaeseya niñeba caꞌya cua: —¿Aecue jiquio Jesosa soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","—Chamaꞌ ca ca Jesosa. ¿Achacua shai poquinaje? —jamaya pea cuana cua. Majoya aje huacuaya poqui oꞌoya cua Jenosanena huasijje Jesosa saꞌajjaꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Majoya pea beca peejjima cahuime epo ba caꞌya cua Jesosa Eyacuiñajjija equijo nequi. Jesosaa Eyacuiñajjija esohui huohuijji cuequi tii cuana huohuiꞌajja ca ania cua; Jesosa jjashajjaꞌajjaqui ania cua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ojjaña jjashahuaba neineiquinaje Jesosaja esohuijo: —Eꞌe de, Jesosa quea jaꞌa nee nee jjashahuabaquiani, de —pea cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Joseya Maniaa peaꞌai Jesosa ba majje mimia ca cua jama baꞌa: —¿Aꞌa mi quioya Jesosa? ¿Aꞌya acuae mi po nequinaje soꞌo? Ecuanajaya miya baꞌyo jjima nei nei cuanaje. Jamajjeya eya mijo quea yeno nee nee cuanaje, Jesosa. Jamajjeya ecuanaya saꞌajjasaꞌajjaꞌyoquinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesosaa jama aca cua baꞌa: —¿Apiojji acuae iña saꞌajjaꞌyaña soꞌo? ¿Aꞌa miquea ba jjima eya ecue Chiija equijo enequijji, Eyacuiñajjija equijo? ");
INSERT INTO eseNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jose Mania peaꞌai oja esohuijo jjabahuejjaqui jjima cua yajja cuani poso aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Majoya aje Jesosa oja chii nijje oja nae nijje Nasanena huasijje poqui oꞌoya cua, ma o baꞌe yasijje. Jamatii Jesosaa shajjaꞌajja ca cua Jose, Mania peaꞌai. Quea bihui baꞌya cua. Mania jjashahuabaquia cua Jesosaja esohuijo; pajeaꞌyo jjima aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesosa tiiya cua quea caꞌa nee nee; quea jaꞌa nee nee cua. Eyacuiñajji quea bihui nee cua Jesosajo; dejja cuana quea bihui cua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quijje nei mahuiso emeshi mese cuana cua baꞌa: Shomano dejja cuanaja emeshi mese Timeneo bajjani. Quea huiso shequiajame, 15 shequiajame nequijo Jodea meshija emeshi mese Ponisio Pinato bajjani nequinaje. Janinea meshija emeshi mese Enode bajjani cua. Oja doe etii Penipe bajjani cua. Oya Itoneaja emeshi mese cua, Taconiteja emeshi mese peaꞌai cua. Amininiaja emeshi mese Nisania bajjani cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Eyacuiñajji nijje mimiani etii Anasi bajjani cua. Pea ca Caipa bajjani cua. Jiquio emeshi mese cuana nequijo tiiya aje Huani Sacaniaja bacua ejja nequia cua meshi quimajo. Onijje mimi majje Eyacuiñajjiya Huani huoojea ca cua esohui huohuijji epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jamajjeya Huani poꞌayequie nequia cua Eyacuiñajjija esohui huohuiya Jodana cueijje. Ohuaya pea cuana jama huohuime aca cua baꞌa: —¡Jjashahuabaquicue Eyacuiñajjijo; miquea mimishi pajeaꞌyocue! ¡Miquea mimishijo quea yeno pocue! ¡Aꞌa mimishi maja sa poꞌyojji! Miya mimishi pajeaꞌyajo, aje Eyacuiñajjiya miquea mimishi cuijea cajeꞌyo. Eyaya miya besa meeje enajje pea cuanaja ebajji miya Eyacuiñajjija epeejji nei nei cuanijo. ");
INSERT INTO eseNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jamaya Isaiaa yahuajo nei Huanijo tehue ca cua. Isaia Eyacuiñajjija epeejji, esohui huohuijji cua. Oya etiiquiana nei nei cua. Jama tehuemeya aje yahuajo aca cua baꞌa: “Oe dejja quimajo nequi taaani jama baꞌa: ¡Acua pocue! ¡Jjashajjaꞌajjaquicue Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajjijo! ");
INSERT INTO eseNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Eyacuiñajjiya dejja quea mimishi cuana jeajea caje cuaqui yasijje jjashajjaꞌajjaqui ajjajojo. Ojjañaa joya Eyacuiñajjija esohui ojaya ehuoojeaꞌyo ojjaña jaahuanajjijo shajjaꞌajja cani ca ca quea bame nee cuajeꞌyo. Joya ecua ejiojji quea bame aca yani jama jayojja dejja cuana quea bame acajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ojjaña meshijo nequica dejjaa shajjaꞌajja caje Eyacuiñajjija esohui. Joya onijje jjapeequije Eyacuiñajjiya mimishi cuijea cajeꞌyo”. Jamaya cua Isaiaja etehueꞌyo Huanijo. ");
INSERT INTO eseNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Majoya dejja quea huiso cueya cua Huani que mimishi pajeaꞌyohua nisho, oja besa mee yohua nisho peaꞌaiya. Jamajjeya aje Huaniya jama tecueame aca cua baꞌa: —Miquianaya quea tai cuani. Peyo jayojja cuani. Miquianaaya ca jja ca mimishi pajea nishoꞌyaña. Miquianaya jjashahuaba taiquiani jama baꞌa: “Eyacuiñajjiya eya jeajea jjima acaje cuaqui yasijje Huanija enajje ebesa meejojo”. Jamatii miquianajaya ca jja ca oe mimishi pajeaꞌyo jjima nei nei. ¡Ebionei oe shajjaꞌajjacue Eyacuiñajjija esohui; majoya miquianajaya mimishi pajea neineiꞌyocue! Majoya oe enajje eyaya besa meejeꞌyo Eyacuiñajjija epeejji nei epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Miquianaya Eyacuiñajjija epeejji nei baꞌyanijo, mimishi epo becaꞌyojji pojjeama. ¡Jama jjashahuabaquimeya oe pocue enajje ebesaqui cuahuajje! Aꞌa mimijji jama baꞌa: “Ecuea etiiquiana Amajama cua. Oya Eyacuiñajjija epeejji nei cua, jamajjeya aje oe ecuanaya Eyacuiñajjija epeejji peaꞌai cuani”. Cho, miquianaya ca ca jjapeequi jjima Eyacuiñajji nijje. Miquianaya quea mimishi, de. Eyacuiñajji ojaya epeejji quea huiso sa cuani jojjemo Amajama jayojja epojji, ohuaya mei pana came. ");
INSERT INTO eseNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Miquianaya joya acui jjajjamaꞌ jayojja cuani. Jiquio ecua acui jjajjaꞌyo ajja jajajea caꞌyojji jayojja jama Eyacuiñajjiya dejja mimishi acajeꞌyo, jeajea cajeꞌyo cuaqui yasijje. Jamaya aje miquianaya acajeꞌyo mimishi pajeaꞌyo ajjajojo, onijje jjapeequi sa po ajjajojo. Beca cuana ca ca joya acui quea jjajja huiso jayojja cuani. Quea bame nee nee baꞌyani, Eyacuiñajji nijje jjapeequiani jjejojo. Quea bei baꞌyani pea cuana nijje, oya Eyacuiñajjiya quea jea nee nee acani jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Majoya aje dejja cuaa jama huohuiꞌajjame aca cua baꞌa: —¿Yajja acuae oe po cajji soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Huani jama cua baꞌa: —¡Joya miquea beca yanijo daqui quiacue daquimaꞌ cuana huasijje! ¡Miquea bobi yanijo ca bobimaꞌ cuana huasijje quiacue! ");
INSERT INTO eseNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Emeshi meseja bejjo chichajji cuani cuaa jama huohuiꞌajjame aca cua baꞌa: —Esohui huohuijji, ¿yajja acuae pajjaja po cajji soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Huani jama cua baꞌa: —¡Aꞌa quea mimishi pojji! ¡Aꞌa quea sose huiso ajji! ¡Joya emeshi meseja sosehuiso tiiya jjeshecue! —jamaya cua Huani. ");
INSERT INTO eseNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Majoya aje sohuinanohua jama huohuiꞌajjame aca cua baꞌa: —¿Yajja acuae ecuanaya cuajeꞌyo soꞌo? Huani jama cua baꞌa: —¡Aꞌa miquiaaya dejja cuana iñajji bejjo esiijji! ¡Aꞌa pea cuana nijje siajje pojji bejjo esiijji! ¡Miquianajaya bejjojo nei jjaja oe quea bihui pocue! —jamaya Huaniya sohuinano aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dejja cuaa Huani Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji poso aca cua oja esohui quea bame nee nee cua jojoya. ");
INSERT INTO eseNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Huani ca ca Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama cua. Oya jama cua baꞌa: —Eyaya miquianaya enajje besa meejeꞌyo Eyacuiñajjija epeejji jojoya. Eya ca ca Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama. Oya ca ca Quito bajjani quijje pishana cueje. Ohuaya miquiana que Eyacuiñajjija Edojjoshahua Bame dobiqui mee cajeꞌyo. Jamajjeya miya quea bame cuajeꞌyo. Mimishi cuana pajea sa poꞌyo ajjajo ca ca, jeajea cajeꞌyo cuaqui yasijje. Jamaya Quito oe nei quea caꞌa nequi. Eya ca ca iña quea caꞌa pishana nequi. Jamajjeya eya ca iña onijje nequi sa po ajja miquiana ani cojja nei. Quea bicho eya, de. ");
INSERT INTO eseNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Quito cueje ojaya epeejji nei chichaꞌyohua. Pea cuana ca ca cajaa ajea cajeꞌyo. Eꞌe, jiquio ecua seya anoso shaa jea majje equi yasijje iyaꞌyaña jama ojaya epeejji cuana acajeꞌyo Quitohua. Jiquio ecua seya anoso cuiahuojo majje shaa jeajeaña jayojja jama Quitohua ojaya epeejji pojjeama cuana jeajea cajeꞌyo cuaqui quijjoꞌyo ajja huasijje —jamaya Huaniya aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Huanija pea esohui jama cua baꞌa ojjaña cuanajo: —Eyacuiñajji ojjaña nijje jjapeequi sa cuani, jjeya nei. ");
INSERT INTO eseNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ojaya pea esohui jama cua baꞌa: —Esejaya emeshi mese, Enode bajjani quea mimishi nee nee cuanaje. Oja chahuaja, Penipeja huanase sii canaje oja huanase epoꞌyojji. Ma epona Enodiasi bajjani cuanaje —jamaya cua Huani. ");
INSERT INTO eseNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jamajjeya Enode ma esohui shajjaꞌajja majje quea quene nee nee cua. Iña mee ca cua Huani ejeanobiajeajji, Enodeya quea mimishi nee neeya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Huani jeanobiajea jjimahua poquia cua dejja ojjaña cuana nijje Jodana cuei yasijje enajje besa meeya. Jesosa peaꞌai poquia cua o que. Huaniya Jesosa besa mee caꞌya cua. Majoya Jesosa Eyacuiñajji nijje mimianijo, eyatahuatahua capajea ca cua. Edojjoshahua Bame huiaꞌ jama o sapa biajje cuabesa baꞌya cua. Japashineijje baꞌeoquea cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Majoya esohui shajjaꞌajja ca cua ojjañaa eyahuasijje. Eyacuiñajji Jesosa nijje jama mimime cua baꞌa: —Miya ecue Bacua Ejja nei, Jesosa. Eyaya miya quea jea nee aña. Eya mijo quea bihui nee nee —jamaya cua Eyacuiñajji. ");
INSERT INTO eseNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesosa Jodio dejja nei cua. Jesosaa 30 shequiajame tii majje esohui huohui coo ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ojaya etiiquiana cuana yohua bajjani cua baꞌa: Ebionei Jose nequia cua. Oya Jesosa tii meejji cua; Jesosaja chii jayojja cua. Jose ca Enija bacua ejja cua. Eni ca Mataꞌaja bacua ejja cua. Mataꞌa ca Nemija bacua ejja cua. Nemi ca Mequija bacua ejja cua. Mequi ca Janaja bacua ejja cua. Jana ca Joseja bacua ejja cua. Jose ca Matatija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matati ca Amosoja bacua ejja cua. Amoso ca Nahuomaja bacua ejja cua. Nahuoma ca Esinija bacua ejja cua. Esini ca Naquiaja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naquia ca Maataja bacua ejja cua. Maata ca Matatija bacua ejja cua. Matati ca Semeja bacua ejja cua. Seme ca Josequija bacua ejja cua. Josequi ca Jonaja bacua ejja cua. Jona ca Joanaja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joana ca Shesaja bacua ejja cua. Shesa ca Sonobabeja bacua ejja cua. Sonobabe ca Sanatija bacua ejja cua. Sanati ca Nenija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neni ca Mequija bacua ejja cua. Mequi ca Adija bacua ejja cua. Adi ca Cosamaja bacua ejja cua. Cosama ca Emanamaja bacua ejja cua. Emanama ca Esheja bacua ejja cua. Eshe ca Jesosaja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jesosa ca Enieseja bacua ejja cua. Eniese ca Jonimija bacua ejja cua. Jonimi ca Mataꞌaja bacua ejja cua. Mataꞌa ca Nemija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nemi ca Simeonija bacua ejja cua. Simeoni ca Jodaja bacua ejja cua. Joda ca Joseja bacua ejja cua. Jose ca Jonamija bacua ejja cua. Jonami ca Eniaquimija bacua ejja cua. Eniaquimi ca Meneaja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Menea ca Menaja bacua ejja cua. Mena ca Matataja bacua ejja cua. Matata ca Nataja bacua ejja cua. Nata ca Dabija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabi ca Isaija bacua ejja cua. Isaiꞌ ca Obedaja bacua ejja cua. Obeda ca Boosija bacua ejja cua. Boosi ca Sanaja bacua ejja cua. Sana ca Naasonija bacua ejja cua. Naasoni ca Aminidabija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminidabi ca Adimija bacua ejja cua. Adimi ca Ashinija bacua ejja cua. Ashini ca Eshaomija bacua ejja cua. Eshaomi ca Panesija bacua ejja cua. Panesi ca Jonaja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jona ca Jacoboja bacua ejja cua. Jacobo ca Isaacaja bacua ejja cua. Isaaca ca Amajamaja bacua ejja cua. Amajama ca Taneja bacua ejja cua. Tane ca Naconija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naconi ca Senocaja bacua ejja cua. Senoca Shacaoja bacua ejja cua. Shacao ca Penecaja bacua ejja cua. Peneca ca Emeneja bacua ejja cua. Emene ca Sanaja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sana ca Cainanija bacua ejja cua. Cainani ca Anajjadaja bacua ejja cua. Anajjada ca Semija bacua ejja cua. Semi ca Noeja bacua ejja cua. Noe ca Nemequeja bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nemeque ca Matosaneja bacua ejja cua. Matosane ca Enoqueja bacua ejja cua. Enoque ca Janedija bacua ejja cua. Janedi ca Majananeenija bacua ejja cua. Majananeeni ca Cainanija bacua ejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainani ca Enosija bacua ejja cua. Enosi ca Setija bacua ejja cua. Seti ca Adanaja bacua ejja cua. Adana ca Eyacuiñajjija pana cua. Oya ebionei dejja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesosa cueyanaje Jodana cuei yasijje Huanija besa meeya. Jomajo Edojjoshahua Bameya Jesosa dojo canaje quima huasijje. Majoya Edosiquiana etii Jesosa nijje miminaje oja emeshi mese nei epoꞌyojji nisho. ");
INSERT INTO eseNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jomajo nequia cua quea huiso nee cahuime, 40 cahuime ijjiaꞌijjia jjima cua. Majoya quea shoe nee nee jjabaquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Edosiquiana etiiya Jesosa jama huohuime aca cua baꞌa: —Miya Eyacuiñajjija Bacua jjabaqui majje ca oe ¡jiquio mei pahui pojji acue! ¡Pahui pojji amajje ijjiacue! ");
INSERT INTO eseNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesosa jama cua baꞌa: —Chojja de, eya miquea esohui shajjaꞌajja sa po ajja. Bacue, Eyacuiñajjija etehueꞌyo jama cuani baꞌa: “Dejja cuana bobijo caꞌa po majje pojjeama baꞌe tiitiijeꞌyo. Ojjaña Eyacuiñajjija esohui jayojja jama añajo ca se ca oe quea bame nee baꞌe tiitiijeꞌyo” —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Majoya aje Edosiquiana ettiya Jesosa dojo ca cua eyiyo aoꞌao huasijje. Majoya aje ba mee ca cua ojjaña meshi cuana; Jesosa cahuijo jayojja ba mee ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Edosiquiaa huohui ca oꞌoya cua jama baꞌa: —Eyaya miya quiaje jiquio meshi cuana, miya emeshi mese po meejeꞌyo. Eyaya ojjaña aquiana quiajeꞌyo. Ojjaña meshi cuana ecuea, jamajjeya eyaya quia sa cuanijo eyaya aje miquea yajji quiajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","¡Miyaya eya bihuiacue, shajjaꞌajjacue ecuea esohui! Majoya miya emeshi mese po meejeꞌyo eyaya —jama siajje ameya aca cua Edosiquiaa Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesosa jama cua baꞌa: —Chojja, ¡poquicue quea huesha, Edosiquiana! Eyacuiñajjija etehueꞌyo jama cuani baꞌa: “¡Eyacuiñajji oe nei bihuiacue; oya oe nei ojjañaja Emeshi Mese nei nequi! ¡Ojaya ehuohuiꞌyo jama oe acue!” —Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Majoya aje Edosiquiaa Jesosa dojo ca cua Jenosanena huasijje. Nequia cañaquia cua Eyacuiñajjija equi biajje. Majoya Edosiquiaa Jesosa jama aca cua baꞌa: —Miya Eyacuiñajjija Bacua Ejja nei jjabaqui majje ¡jiquiojo nequi tohuaaꞌajjaꞌyo socue meshi yasijje! ");
INSERT INTO eseNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Eyacuiñajjija etehueꞌyo jama cuani baꞌa: “Eyacuiñajjiya huoojea caje esohuidojojji cuana mi jaahuanaa. ");
INSERT INTO eseNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Oquequiajo ohuaya emeya miya iñajjequi cajeꞌyo. Jamajjeya miya ejjajiojji quecuasajaquijji pojjeama meijo”. Jamaya cuani, de —Edosiquiana cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesosaa jama aca cua baꞌa: —Chojja, miya jjashahuaba taiquiani, de. Eyacuiñajjija pea etehueꞌyo jama cuani baꞌa: “Aꞌa jamaya mimijji baꞌa: ¿Aꞌa Eyacuiñajjiya oja esohui eꞌe jojo nei acajeꞌyo? ¿Aꞌa eya jaahuana nei cajeꞌyo? Cabaꞌajjasahua. ¡Aꞌa pojji!” Jamaya yahuajo nei Moisesiya tehue ca cua —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Edosiquiana jjashahuabaqui jjima cua; pea esohui chamaꞌ cua Jesosa quea mimishi po meejji nisho. Jamajjeya Edosiquiana poquia cua. Majoya aje quijje cue oꞌoya cua o quea mimishi po meeꞌyohua nisho. ");
INSERT INTO eseNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Majoya Jesosa posohuaqui oꞌoya cua oja meshi yasijje, Janinea meshi yasijje. Edojjoshahua Bameya Jesosa quea caꞌa po mee ca cua. Jomajo dejja cuana mimia cua Jesosajo, ojjaña meshi yasijje mimia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jamatii Jesosa poꞌayequie nequia cua pea cuiñajji cuana huasijje Eyacuiñajjija esohui huohuiya Jodioja equi ejjachichaquijji cuana huasijje. Ojjaña dejja quea bihui cua onijje. Jama cuana cua baꞌa: —Eꞌe, ojaya esohui quea jaꞌa nee, quea bame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesosa poquia cua Nasanena huasijje, oya tiiꞌya cua jomajo tii. Ojjaña epojja ejomishocajjijo Jesosa dobiqui majamajanaje Jodioja equi ejjachichaquijji yasijje esohui huohuiya. Jamajjeya dobiqui majje oya nequisohua cua Eyacuiñajjija etehueꞌyo ajji. ");
INSERT INTO eseNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Oe dejjaa, etehueꞌyo jaahuanajjiya Jesosa quia ca cua etehueꞌyo. Yahuajo Isaiaja etehueꞌyo cua. Isaia Eyacuiñajjija epeejji nei, etiiquiana cua; Eyacuiñajjija esohui huohuijji cua. Jamajjeya ojaya etehueꞌyo eꞌe jojo nei cua. Eꞌe de, Jesosaa sheꞌa ca cua ma etehueꞌyo, jama ame aca cua jiquio esohui baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Edojjoshahua Bameya eya jjashahuabaqui mee cani. Ohuaya eya huoojea canaje jama baꞌa: —¡Huohuicue ecuea esohui bame dejja aemaꞌ cuana huasijje! ¡Huohuicue dejja ejeanobiajaa cuana huasijje ecuayaqui meeꞌyojji! ¡Huohuicue cojjamaꞌ cuana huasijje ejjacojja jaꞌa meequiꞌyojji! ¡Huohuicue pea dejja quea yeno baꞌe yasijje quea bihui ebaꞌe meejji! ");
INSERT INTO eseNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Huohuicue jiquio esohui: Emeshi Mese neiya ojjaña cuana quea bihui baꞌe mee sa acani”. Jamaya Isaiaa tehue ca cua yahuajo nei. ");
INSERT INTO eseNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Majoya Jesosaa etehueꞌyo cami caꞌyonaje; quia ca oꞌoya cua ma dejja huasijje. Jesosa anioquea cua huohui epojji. Ojjañaa oya ba caꞌya cua; ishoaꞌajja ca cua ojaya esohui ehuohuijji. ");
INSERT INTO eseNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ohuaya esohui huohui ca cua jama baꞌa: —Eꞌe, ma etehueꞌyo huohui cani ejo. Eya cueꞌyonaje ma dejja cuana huasijje esohui huohuiya. Eyaya miquianaya huohuiꞌajjaña jama baꞌa: Eyacuiñajjiya quea bihui baꞌe mee cajeꞌyo miquianaya —Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ojjaña Jesosajo quea bame mimia cua. Jjashahuabaquia cua ojjaña ojaya esohuijo. Pea cuana ca ca Jesosajo jama cua baꞌa: —Jesosaja esohui quea jaꞌa de, oya ca ca Joseja bacua nei, Eyacuiñajjija Bacua pojjeama —jamaya pea cuana cua Jesosa Eyacuiñajjija Bacua pojjeamajo poso. ");
INSERT INTO eseNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesosaa oya cuana tecuea ca cua jama baꞌa: —Miquianaya jamaya cuaje miquianajaya ejjashahuabaquijjijo baꞌa: “Ejjashicuiquijji, ¿yajjajje acuae jja miyaya mi jjashicuiꞌajjaquiani soꞌo?” ¿Aꞌa nequiana jamaya peaꞌai jjashahuabaquiani? Jama cuani baꞌa: “Ecuanaaya miya shajjaꞌajjanaje, Jesosa. Miyaya jjaajaqui meeꞌyonaje Capenaomajo baꞌe cuana. ¿Yajjajo acuaeya oe miquea meshijo baꞌe cuana jjaajaqui meeꞌyo jjima aña soꞌo?” ¿Aꞌa nequiana jamaya jjashahuabaquime cuani? —Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eꞌe jojo nei ecuea esohui, jamatii miquianaya Eyacuiñajjija esohui huohuijji mimianijo oja meshijo ojaya huapa pojjeama cuana ca ca jjashajjaꞌajjaqui sa po ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—Miquianajaya eba ma etiiquiana Enia bajjani. Yahuajo nei ohuaya huohui ca cua Eyacuiñajjija esohui. Beshahua nei pea beca peejjima shequiajame ena poꞌyo jjima cua. Bobi tii jjima cua ena chamajojo. Ojjaña quea shoe nee nee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yahuajo quea huiso Jodio eꞌahuemano ania cua. Jamatii oya cuana ca ca jjashajjaꞌajjaqui sa po ajja Eniaja esohuijo, Eyacuiñajjija ehuohuiꞌyojo. Jamajjeya Eyacuiñajjiya Enia huoojea ca cua pea meshi yasijje Sinono meshi yasijje, Saneta cuiñajji yasijje, Sinono eꞌahuemano que. Jomajo eꞌahuemanohua shajjaꞌajja ca cua Eyacuiñajjija esohui. Jamajjeya Enia bobia ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Miquianajaya eba pea etiiquiana Eyacuiñajjija esohui huohuijji Eniseo bajjani baꞌya cua Enia nijje. Quea huiso Jodio dejja batata epoꞌyo jomajo baꞌya cua. Jamatii Eniseoja esohui shajjaꞌajja sa po ajja. Jamajjeya jjaajaqui meeꞌyo jjima aca cua Eyacuiñajjiya. Pea meshijo baꞌe Sinia meshijo oe dejja Naamani bajjani batata epoꞌyo nequia cua; oya shajjaꞌajja sa cua Eyacuiñajjija esohui. Jamajjeya oya poquia cua Eniseo que, Eniseoja jjaajaqui meeꞌyohua. Ohuaya shajjaꞌajja ca cua ojaya esohui. Jamajjeya jjaajaqui mee caꞌya cua Eyacuiñajjiya. Jamaya miquianaya shajjamaꞌ cuani miquianajaya etiiquiana jayojja. Jjeya nei shajjaꞌajja sa po ajja Eyacuiñajjija esohui, jamajjeya jjaajaqui meeꞌyo jjima acaje Eyacuiñajjiya —Jesosa cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ojjaña cuana Jodioja equi ejjachichaquijjijo anica Jesosaja esohui shajjaꞌajja majje quenequene neineiꞌya cua Jesosa nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jesosa iña majje jeacuayajea ca cua esecue yasijje. Majoya poqui mee caꞌya cua eyiyo hui yasijje eꞌiñajeatohuaajeaꞌyojji nisho. ");
INSERT INTO eseNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jamatii Jesosa poquia cua, jjayejjequinana cua ona nequi yiyesamajjeya. ");
INSERT INTO eseNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pea pojjajo Jesosa poquia cua Capenaoma huasijje, Janinea meshi yasijje. Ejomishocajji pojjajo oya dobiquia cua Jodioja equi ejjachichaquijji yasijje esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ojjaña cuaa jama aca cua baꞌa: —De, Jesosaja esohui quea jaꞌa nee. Eꞌe jojo nei pojjaꞌa Eyacuiñajjiya oya huoojea canaje, de. Jamajjeya ojaya esohui shajjaꞌajja sa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oe dejja eshahua nijje tii ania cua Eyacuiñajjija equijo. Eshahuaa oya taaa sajasaja mee ca cua Jesosa que jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Eꞌe de, ¿apiojji shai miya ecuana que cueyanaje, Jesosa? Miya cueyanaje pojjaꞌa ecuana cuayaqui meeꞌyohua. Ecuanajaya miya eba, Jesosa. Miya Nasanenajo baꞌe, miya Eyacuiñajjija Bacua, miya mimishiꞌama, de —jamaya eshahua cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesosaa eshahua tecueajea ca cua jama baꞌa: —¡Aꞌa mimijji; cuayaquiꞌyocue jiquio dejjajo nequi! —Jesosa cua. Majoya eshahuaa ma dejja jeabichajea mee ca cua pea cuana pejjejo. Eshahua neeꞌama nei nei cuayaquiꞌyome cua ma dejjaja eyamijo nequi. ");
INSERT INTO eseNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ojjaña jjajjasohuaquia cua; mimia cua pea cuana nijje jama baꞌa: —Eꞌe de, Jesosa quea sohui poja nee nee; ojaya esohuijo eshahua cuayaquiꞌyonaje, de. ¿Yajjajje shai quea sohui poja nee nee? —jamaya cua ojjaña Jesosajo. ");
INSERT INTO eseNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jamaya pea cuaa huohui ca cua ojjaña cuiñajjijo baꞌe yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Majoya Jesosa cuayaquia cua Jodioja equi ejjachichaquijjijo ani. Cuayaqui majje poquia cua Simohuija equi yasijje. Dobiqui majje ba ca cua Simohuija ano. Simohuija ano quea mano jaa, quea quiyo nee nee jaa ba ca cua. Simohuiya Jesosa jama huohuiꞌajjame aca cua baꞌa: —Jesosa, ¿aꞌa miyaya boeca meejeꞌyo ecue ano, ecue huanaseja enaese? ");
INSERT INTO eseNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesosaa Simohuija ano jama aca cua baꞌa: —Eꞌe, jjeyahua nei mi quiyoquiyo pajeajeꞌyo —Jesosaa aca cua. Majoya aje epona tii quiyoquiyo pajeaꞌya cua. Boecananaꞌya cua. Majoya boecaꞌyo majje anisohuaꞌya cua. Anisohuaꞌyo majje bobi cuacua meesahua ca cua epona tiiya. ");
INSERT INTO eseNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Quijje pishana eshequi oquequiajo ojjaña emanojaa dojo ca cua Jesosa que jjaajaqui meeꞌyohua. Jesosaa emanojaa cuana emeya napa cajje jjaajaquiꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eshahua cuana peaꞌai cuayaqui mee caꞌya cua. Cuayaquiꞌyo majje eshahua cuana taaa cua jama baꞌa: —Jesosa, miya eꞌe jojo nei Eyacuiñajjija Bacua Ejja. Jesosa jama cua baꞌa: —¡Aꞌa enijje jama mimijji! Miquea eba eya, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Pea cuanaja eya ba jjima, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jjapojjaqui jeahuajo Jesosa oe nei poquia cua dejjama huasijje. Pea cuanaa saꞌajja ca nequia cua: —¿Aecue Jesosa? Quijje pishana ca ca ba caꞌya cuaa cua Jesosa. Mimia cua onijje jama baꞌa: —Jesosa, ¡nequicue ecuanaja cuiñajjijo! ¡Aꞌa poquijji pea cuiñajji yasijje! ");
INSERT INTO eseNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesosaa jama huohuime aca cua baꞌa: —Chojja, jiquio cuiñajjijo eya nequi ajja. Eyaya Eyacuiñajjija esohui cahuohuiquiahua pea cuiñajjijo baꞌe cuana huasijje. Jamajoya aje oe eya ecue Chiiya huoojea canaje ojaya esohui bame bame huohuijji pea cuana huasijje. Eyaya iyaaje dejja cuana jama baꞌa: “¡Jjashajjaꞌajja quicue oe! Eyacuiñajjiya miya quea jea nee nee acani, oya miquea Emeshi Mese nei po sa cuani; mi jaahuanajji nei nei po sa cuani. Ohuaya miya baꞌe bame mee sa acani. ¡Jamajjeya onijje jjapeequicue!” —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jamaya ohuaya esohui huohui ca ayequi nequia cua Jodioja equi ejjachichaquijji cuana huasijje, ojjaña meshi cuana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Oe pojjajo Jesosa Jenesane bae sahua meshijajijo ania cua. Pea cuana huasijje Eyacuiñajjija esohui huohui po ania cua. Quea huiso dejjaa ojaya esohui shajjaꞌajja sa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Quea dejja huisojojo shajjaꞌajja jjima aca cua pea dejja cuaa. Jamajjeya Jesosaa pea eꞌanijji saꞌajja ca cua ojjañaja eshajjaꞌajjajji. Majoya becanejjijji bishe ai ba ca cua bae sahuajo baꞌe. Ma bishe mese cuana nahuoo cuiashajajji shacuaꞌyo po nequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Oe bishe mese Simohui bajjani cua. Jesosa nequisohuaquia cua oja bishe yasijje. Jesosaa Simohui huohuiꞌajja ca cua jama baꞌa: —¡Quecuayiyejeacue ena bae pishana huasijje ojjañaja ecuea esohui eshajjaꞌajjajji! —Eꞌe —Simohui cua. Majoya bishe quecuayiyejea majje Jesosaa bishejo eꞌanioque aniya tii esohui huohui ca aña cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jesosaa esohui huohuijeyo majje Simohui jama aca cua baꞌa: —Simohui, ¡bishe yocue ena bae yiyesama huasijje! ¡Majoya jeacue nahuoo cuiashajajji! ");
INSERT INTO eseNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simohuiya jama aca cua baꞌa: —Esohui huohuijji, ecuana mecajje poquinaje nahuoo cuiashajaa nisho. Chamaꞌ de, chamaꞌ nahuoo cuanaje. Eyaya ca ca shajjaꞌajja sa aña miquea esohui, jamajjeya eyaya jeaje ena huasijje nahuoo cuiashajajji —jamaya Simohui cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Majoya yo ca cua ena bae yiyesama huasijje nahuoo cuiashajajji. Jea ca cua nahuoo cuiashajajji; quea huiso nee nee nahuoo dobiquia cua. Quecuaisajeaꞌajja ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Majoya Simohuiya ojaya epeejji cuana iyaa ca cua: —¡De, yacua oe yecue bishe pea, che nahuoo jjequijeasohuahuacue! Majoya pea bishe ye ca cua; cuio ca cua beca bishe nahuoohua. Beshahua nei bishe jaadobiquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma ba majjeya aje Simohui ecuiꞌoshajjajo nequia cua Jesosa pejjejo; jama cua baꞌa: —De, ecuea Emeshi Mese, eꞌe jojo nei miquea esohui, eya miquea esohuijo jjashahuaba taiquinaje, de. ¡Quea huesha nequicue Jesosa, eya quea mimishi cuanaje! —jamaya Simohui cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simohuija epeejji cuana jjajjasohuaquia cua nahuoo quea huiso ohua cuiashaja cajo. O jayojja jjajjasoaquime peaꞌaiya cua, de. ");
INSERT INTO eseNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Semeneoja bacua cuana Satiaco, Huani, Simohuija echacosahuajji cuani peaꞌaiya jjajjasohuaquia cua. Majoya Jesosaa Simohui jama aca cua baꞌa: —¡Aꞌa jjajjasoaquijji! Miquianaaya banaje ecuea esohui eꞌe jojo nei nahuoo cuiashajajjijo. Jjeyahua nei miquianaaya dejja quea huiso jjequije ecuea esohuijo ejjashajjaꞌajjaquijji, ecuea epeejji epojji —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Majoya cuaa bishe yo caꞌya cua etaja huasijje. Aquiana cuana jeanaꞌyo majje poquia cua Jesosa nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Oe pojjajo Jesosa ania cua pea cuiñajjijo. Cueꞌya cua oe dejja batata epoꞌyo. Ojjañaja oya botiꞌama cua, o jayojja epo cuani jjejojo. Oya Jesosa ba majje ecuiꞌoshajjajo nequia cua o bihuiajji. Jama huohuiꞌajjame aca cua baꞌa: —Emeshi Mese nei, miya sa cuanijo, ¿aꞌa mo che miyaya jjajeaqui meeꞌyome soꞌo? —aca cua ohuaya. ");
INSERT INTO eseNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Majoya Jesosaa napaꞌajja ca cua emeya, quea jeajojo huohui ca cua: —Eꞌe, eyaya miya jjajeaqui meejeꞌyo batata epoꞌyo. Quea boejea po meejeꞌyo. Jjajeaqui meeꞌyo majje chamaꞌyo cua ojaya batata epoꞌyo. Quea boejea ojaya ejee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Majoya Jesosaa jama huohuime aca cua baꞌa: —¡Aꞌa oe pea cuana huohuijji! ¡Eyacuiñajjija equi yasijje oe poquicue! ¡Jomajo huohuicue Eyacuiñajjija esohui huohuijji: “Jjajeaquiꞌyonaje mo” acue! ¡Moisesija etehueꞌyo jama oe acue! ¡Quiaquicue beca huiaꞌ, beca ijjiacajji peaꞌai, equiajji Eyacuiñajji bihuiajji, miya ojaya ejjajeaqui meeꞌyohua jjejojo! Majoya esohui huohuijji cuana jjabahuejjaquije miquea batata epoꞌyo chamaꞌyo cuanajejo. Majoya ojjaña jjabahuejjaquije miya quea bojea poꞌyonajejo —Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jamatii quea huiso dejjaa shajjaꞌajja ca cua Jesosaa jjajeaqui mee caꞌyani batata epoꞌyo. Ohuaya jjaajaqui mee caꞌyani emanojaa cuana. Jamajjeya quea dejja huiso nee cueyanaje shajjaꞌajjaa, jjaajaquiꞌyohua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jamatii Jesosa poqui nequia cua dejjama huasijje Eyacuiñajji nijje mimiya. ");
INSERT INTO eseNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Oe pojjajo Jesosa poquinaje onaja equi yasijje esohui huohuiya. Paniseo dejja cuana, Moisesija etehueꞌyo huohuijji cuana peaꞌai cueyanaje Eyacuiñajjija esohui shajjaꞌajjaa. Quea dejja huiso pea meshijo baꞌe cuana cueyanaje, Janinea meshijo baꞌe cuana. Jodea meshijo baꞌe cuana, Jenosanenajo baꞌe cuana peaꞌai cueyanaje. Jesosaa Eyacuiñajji nijjeya quea huiso emanojaa jjaajaqui mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jamajjeya pea dejjaa oe dejja jeoꞌajjajaa ye ca cua equi yasijje. Dojodobiaqui sa aca cua Jesosa que. ");
INSERT INTO eseNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dobiqui meemee ajja cuana cua quea dejja huisojojo. Jamajjeya aje dojosohua caꞌya cua equi jamacoo huasijje. Huejja ca cua eyiyesama neijje. Jesosa nequi cojja nei jeaꞌoquea ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesosaa ba ca cua dejja jeoꞌajjajaa ojaya epeejji peaꞌai. Jjashahuabaquia cua jama baꞌa: —Eꞌe de, jiquio dejja cuanaja eba eyaya jjaajaqui meejeꞌyo emanojaa cuana. Jamajjeya jeoꞌajjajaa huohui canaje jama baꞌa: —Eꞌe ecuea epeejji, jjeya miquea mimishi eyaya cuijeajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Majoya Paniseo cuana, Moisesija etehueꞌyo huohuijji cuana peaꞌai jjashahuaba taiquia cua; Jesosa Eyacuiñajjija Bacua pojjeama poso aca cua. Jama cua baꞌa: —Jesosa quea tai cuani, de. Oya Eyacuiñajji jama cuani. Oe nei Eyacuiñajjiya mimishi cuijea cajeꞌyo. Jesosaja ca ecuijeaꞌyojji pojjeama —poso aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesosaja eba ojaya jjashahuabaquijji cuana. Jamajjeya huohui ca cua jama baꞌa: —Miquianaya jjashahuaba taiquiani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ache esohui camajaꞌama soꞌo? Jiquio pojjaꞌa baꞌa: “¡Eyaya miquea mimishi cuijeajeꞌyo!” Pea esohui pojjaꞌa: “¡Nequisohuacue, poquiꞌajja socue!” ");
INSERT INTO eseNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Eꞌe de, eyaya huohuije jiquio dejja jeoꞌajjajaa huasijje jama baꞌa: “¡Nequisohuacue; miquea equipajaajji bebo majje poquiꞌyocue miquea equi yasijje!” Pea cuana huasijje Jesosa jama cua baꞌa: —¡Pea cuana shajjaꞌajjacue, ejjabahuejjaquijji! Eyaya ojjañaja Emeshi Mese nei cuani. Eyaya miquianajaya mimishi cuijea mee yaña ojjaña meshijo baꞌeja —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Majoya aje dejja ejjachichaqui nequijo jeoꞌajjajaa nequisohuaꞌya cua, poquiꞌya cua oja equi yasijje. Oya quea bihui cua Eyacuiñajji nijje, Jesosa nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pea cuaa Eyacuiñajji bihuia ca cua jama baꞌa: —Eꞌe, eseyaya banaje jiquio dejja jeoꞌajjajaa jjeya jeojeoꞌyoqui, mimishi cuijea caꞌyonaje peaꞌai, de. Ojjaña cuana Jesosa nijje quea bihui nee nee cuanaje jeoꞌajjajaa jjaajaqui mee caꞌyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Majoya Jesosa equijo ani cuayaquia cua. Poquijeya ohuaya ba canaje Nemi ona emeshi meseja esohuijo sosejjeshejji cuani ebaꞌejji sosejje. Oya equi sisi eꞌiyajo ani ejiojji cojja sahuajo. Oya siipojji, de, jamajjeya oya ojjañaja botiꞌama. Jesosaa oya ba majje jama aca cua baꞌa: —Nemi, ¡cueꞌajja; ecuea epeejji poꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jamajjeya Nemi nequisohua cua; ojaya aquiana jeajeanana majje poquia cua Jesosa nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Quijje pishana Nemiya iyaa ca cua ojaya epeejji cuana eꞌijjiaꞌijjiajji Jesosa nijje. Iyaa ca cua ona sosejjeshejji cuana, pea dejja cuana peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Paniseo dejja cuana Moisesija etehueꞌyo huohuijji cuana peaꞌaija botiꞌama cua ona sosejjeshejji cuana. Jjashahuaba taiquia cua jama baꞌa: —Quea mimishi Jesosa, o shajjaꞌajjajji cuana peaꞌai. ¿Yajjajje acuae dejja mimishi cuana nijje ijjiaꞌijjiani? Quea mimishi epojji pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesosaja eba ojaya ejjashahuabaquijji. Jamajjeya huohui ca cua jama baꞌa: —¿Aꞌa miquianajaya shajjaꞌajja jjima jiquio esohui pojjaꞌa? Jama baꞌa: “Dejja quea aja eshicuijji bajji yasijje poqui sa po ajja. Emanojaa ca eshicuijji bajji yasijje poquiani”. Jamaya miquianaya joya mimishiꞌama poso jjabaquiani. Jamajjeya miquianaya shajjaꞌajja sa po ajja ecuea esohui. Pea cuana ca quea mimishi nee neeya shajjaꞌajja cani ecuea esohui. Jamajjeya eya ijjiaꞌijjiani mimishi cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eya cueꞌyonaje dejja mimishi iyaaa. Dejja mimishiꞌama cuani poso iyaa sa po ajja iña. Dejja joya quea mimishi nee nee iyaaje mimishi pajea meeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Paniseo cuaa Moisesija etehueꞌyo huohuijji cuaa Jesosa huohuiꞌajja ca cua jama baꞌa: —Esejaya etiiquiana jamaya huohui cani baꞌa: “¡Aꞌa ijjiaꞌijjiajji jiquio pojjajo! ¡Aꞌa jjashahuabaquijji bobijo; jjashahuabaquicue Eyacuiñajjijo nei! ¡Mimicue onijje, quea yeno pocue!” jamaya esejaya etiiquiaa huohui cani. Huani shajjaꞌajjajji cuaa jamaya acani peaꞌai. Jesosa, mi shajjaꞌajjajji cuana ca ca ijjiaꞌijjiani tii. ¿Yajjajje shai? Quea mimishi cuani pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesosaa jama aca cua baꞌa: —E shajjaꞌajjajji cuana enijje ijjiaꞌijjiani. Ecuea eba nei nei Eyacuiñajjija esohui eꞌe jojo nei. Ma esohui huohuijji cuanaja esohui ecuanajaya jjeyahua eꞌajji pojjeama. Ejjahuanaquijji pojjajo ojjaña quea bihui cuani, ijjiaꞌijjiani, quea yeno pojjeama cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","O huanajji epo manoꞌyajo ojjaña quea yeno cuaje. Ma pojjajo ijjiaꞌijjia sa po ajja cuaje. Jjashahuabaquijeꞌyo emanoꞌyojo. Eya jiquio ecua yahue manoꞌyani jayojja cuaje. Jjeya ecuanaya quea bihui cuani ijjiaꞌijjiani. Eya quijje pishana manojeꞌyo. Majoya ecuea epeejji cuana quea yeno cuaje; ma pojjajoya bobi ijjia jjima acaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Majoya ohuaya ojaya esohui huohui ca cua ejjashahuabaquijji jama baꞌa: —Daqui eyacua isajea ca ajja daqui chii jacaꞌyojji. Chojja. Miquea daqui eyacua isajeaꞌyo majje daqui chii jacaꞌyojjiꞌyajo, daqui eyacua ehuoshoꞌyojji pojjeama. Daqui chii ejacaꞌyojji poqui ajja cuiñajji yasijje daqui chiijji jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Ecuea pea esohui jama cuani: Ijjiacajji jee eyacua monsa pojji acajji ena sese nequiajji. Ma ena seseya ejee eyacua shejjee mee cani. Majoya oe huana cani cuaa pea ena sese ejee chiijo cuiapojojea cajeꞌyo shejjee majje. ");
INSERT INTO eseNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jamajjeya huana cani cuaa ena sese monsa eyacuajo cuiapojojea jjima yajji. ");
INSERT INTO eseNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Jamaya ecue sohui eyacua cuani. ¡Miquianaya ecuea epeejji nei po sa cuanijo shajjaꞌajjacue ojjaña ecue sohui! Beca cuana shajjaꞌajja sa po ajja ecue sohui eyacuajojo. Jjashahuaba taiquiani, de. Etiiquianaja esohui ejee echii jayojja. ¡Jamajjeya ecue sohui oe shajjaꞌajjacue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Oe ejomishocajji pojjajo Jesosa o shajjaꞌajjajji cuana nijje poquia cua anoso ai nequi yiyesamajje. O shajjaꞌajjajji cuaa emeya sejja ca cua anoso eshe tii eꞌijjiajji quea shoeya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Majoya Paniseo cuaa Jesosa o shajjaꞌajjajji cuana ba ca cua. Jesosa nijje mimijajinaje jama baꞌa: —¿Yajjajo acuaeya epojja ejomishocajjijo anoso sejja mee yaña soꞌo? Moisesija etehueꞌyo jamaya cuani baꞌa: “¡Aꞌa chacojji ejomishocajji pojjajo!” ");
INSERT INTO eseNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesosaa jama aca cua baꞌa: —Miya quea sohui tai cuanaje; Eyacuiñajjija esohui nei pojjeama aña miquianaaya. Miquianaya jjashahuaba taiquiani, de. ¿Aꞌa miquea ba jjima pojjaꞌa ma etiiquiana, emeshi mese Dabi bajjani? Jama etehueꞌyo yani Dabijo baꞌa: Oya Eyacuiñajjija epeejji nei. Oe pojjajo oya oja epeejji cuana nijje poquije, ");
INSERT INTO eseNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","dobiquinana cua Eyacuiñajjija equi yasijje bobi saꞌajjaa quea shoe nee neejojo. Ma equijo ani pahui ijjia caꞌyonaje; quia caꞌyonaje ojaya epeejji cuana huasijje peaꞌai. Eyacuiñajjija etehueꞌyo jama cuani baꞌa: “Jiquio pahui Eyacuiñajji nijje mimianija eꞌijjiajjime”. Jamatii Dabi ca mimishiꞌama cuanaje. Oya poquianinaje Eyacuiñajjijo chacochaco neineiya. Jamaya aca cua Dabiya. ");
INSERT INTO eseNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ecuana Dabi jayojja cuani. Eya Eyacuiñajjijo chacochaco neineiani. Jamajjeya ecuaaya jiquio anoso ai sejjaña ejomishocajji pojjajo —Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pea ejomishocajji pojjajo Jesosa poquia cua Jodioja equi ejjachichaquijji yasijje esohui huohuiya. Oe dejja meshahuamaꞌyo epo ania cua jomajo. ");
INSERT INTO eseNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Paniseo dejja cuana, Moisesija etehueꞌyo huohuijji cuana jjashahuaba taiquia cua Jesosajo jama baꞌa: —Jesosa shajjamaꞌ jayojja ecuanaja esohuijo cuani. Ohuaya chaco caje ejomishicajji pojjajo pojjaꞌa; jjameshahuanequi mee cajeꞌyo dejja meshahuamaꞌyo epo. Jesosa jamaya shajjamaꞌ cuajo ecuaaya oya iñajeꞌyo edojojji ejeadobiajeajji. ");
INSERT INTO eseNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesosaja onajaya ejjashahuaba taiquijji eba cua. Jamajjeya ohuaya ma dejja meshahuamaꞌyo epo ani huohui ca cua jama baꞌa: —Meshahuamaꞌyo epo, ¡nequisohuacue ojjañaja ebajji! —Jesosaa aca cua. Jamajjeya oya nequisohua cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesosaa huohui ca cua pea cuana jama baꞌa: —Eyaya miquianaya huohuiꞌajjaje: ¿Ache quea bame epojji ejomishocajji pojjajo? Quea bame mi baꞌe mee cajji chi. Quea tai mi baꞌe mee cajji chi. Baꞌe mee cajji mi chi. Quecua caꞌyojji mi chi. ");
INSERT INTO eseNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jamajjeya ohuaya pea cuana huasijje ba majje ma dejja huohui ca cua jama baꞌa: —¡Eme jeapisaꞌajjaꞌyosocue! Majoya eme jeapisa caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Beca cuana quea quene nee nee cua. Jama mimimimia cua baꞌa: —Jesosa shajjamaꞌ nei nei cuani ecue esohuijo. Ohuaya jjameshahuanequi mee caꞌyonaje ejomishocajji pojjajo. ¿Yajja acuae seya Jesosa aje jjeyahua nei eꞌiñajji? —jamaya cua Jodio dejja cuana Jesosa iñajji nisho. ");
INSERT INTO eseNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Oe pojjajo Jesosa poquia cua eyiyo quibo huasijje mimiya Eyacuiñajji nijje. Ojjaña mecajje mimia cua onijje. ");
INSERT INTO eseNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eshequi jaasohuanijo, jjachichaquia cua o shajjaꞌajjajji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Oya cuana yohua bajjani cua baꞌa: Simohui, quijje Jesosaa oya pea bajjani Peno acaꞌya cua; Simohuija chahua yohua bajjani baꞌa: Anesi; pea o shajjaꞌajjajji ca yohua bajjani cua baꞌa: Jacobo, Huani, Penipe, Manotonome, ");
INSERT INTO eseNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomasi, Apeoja bacua bajjani Satiaco; Simoni, ojaya meshi quea boti nee nee cua, ");
INSERT INTO eseNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacoboja bacua Jode bajjani. Pea dejja yohua bajjani cua baꞌa: Jodasa Isicaniote, oya Jesosaja epeejji nisho cua. Mahuiso o shajjaꞌajjajji cuana eꞌe jojo nei cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Majoya Jesosa o shajjaꞌajjajji cuana nijje eyiyojo ani jaaoque oꞌoya cua. Jaaoque majje nequiꞌya cua meshi bame bamejo esohui huohuiya. Quea huiso Jesosaja pea e shajjaꞌajjajji cuana jomajo ania cua. Quea dejja huiso cueya cua, Jodea meshijo baꞌe cuana, Jenosanenajo baꞌe cuana, Tinojo baꞌe cuana, Sinonojo baꞌe cuana peaꞌai. Quea huesha baꞌe cuana cueya cua Jesosa shajjaꞌajjaa. ");
INSERT INTO eseNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ojjañaa shajjaꞌajjaꞌyo sa aca cua, jjaajaquiꞌyo sa cua peaꞌai. Pea cuanajo nequi eshahua cuayaqui mee caꞌya cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ojjañaa Jesosa napa sa aca cua pea jjaajaqui meeꞌyojjijojo. Jesosaa emeya napa cajje jjaajaqui caꞌyonaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Majoya Jesosaa ba majje o shajjaꞌajjajji cuana huohui ca cua jama baꞌa: —Beca cuana jjashahuabaquiani jama baꞌa: “Eꞌe de, eya quea mimishi nee. Eyacuiñajjiya ecuea mimishi cacuijea caꞌyahua”. Jamaya jjashahuabaquianijo Eyacuiñajjiya oya baꞌe tiitii mee cajeꞌyo onijje eyajo. ¡Oya cuana quea bihui nee capoꞌyahua! ");
INSERT INTO eseNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Ojaya epeejji cuana Eyacuiñajjija esohui jayojja jama a sa neinei cuanijo Eyacuiñajjiya oya cuana quea jaji nee nee baꞌe meesahua cajeꞌyo. ¡Quea bihui nee capoꞌyahua oya cuana! —Oja epeejji cuanaja mimishijo pa neineianijo Eyacuiñajjiya quea bihui nee po mee cajeꞌyo mimishi cuijea caꞌyajje. ");
INSERT INTO eseNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Eꞌe, ¡miquianaya ecuea epeejji cuana, quea bihui nee nee pocue! Dejja cuana miquiana nijje mimijajije, miquianaya dejja cuaa cuia caje peaꞌai, siajje minijje cuaje peaꞌai. Jamatii, miquianaya ecuea epeejji cuanijo, dejja cuaa mimishi po meeꞌyo sa acani. Eyacuiñajjiya ca ca miquianaya quea bihui nee po mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jamajjeya ¡jjeyahua nei quea bihui nee nee pocue! Eyacuiñajjiya miquianaya eyajo quia cajeꞌyo miquianajaya aquiana quea bame nee nee, quea huiso nee nee. Eꞌe, Eyacuiñajjija esohui huohuijji yahuajo nei nei baꞌya cua jamaya aca cua mimishi cuaa; napa ca cua peaꞌai. Jamajjeya ¡ona jayojja jama pocue, quea bei! ");
INSERT INTO eseNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Joyaya nequiana oe quea aquiana huiso jjejojo, Eyacuiñajjijo jjashahuabaqui jjima. ¡Bacue! ¡Jjeya miquianaya quea bihui nee nee jjabaquicue! Majoya aje mi oe quijje quea yeno nee nee cuajeꞌyo cuaqui yasijje poqui majje manoꞌyo majje. ");
INSERT INTO eseNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Eꞌe de, ¡joyaya nequiana oe bobijo jjashahuabaquiani jjejojo Eyacuiñajjijo jjashahuabaqui ajja bacue! ¡Jjeya miquianaya quea jejje jjejojo quea bei jjabaquicue! Majoya aje mi oe quijje quea shoe nee nee, quea yeno nee nee cuajeꞌyo. Bobimaꞌ nei cuaje cuaqui yasijje poquiꞌyo majje. —¡Joyaya mi oe quea bihui jjejojo soa ani jjabaquicue! Eyacuiñajjijo jjashahuabaqui ajja, quijje pa neineijeꞌyo; quea yeno nee nee cuajeꞌyo cuaqui yasijje poquiꞌyo majje. ");
INSERT INTO eseNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—¡Aꞌa oe esohui huohuijji nisho pojji, dejja quea bihui epo meejji nisho pojji! Ma ecua esohui huohuijji nisho etiiquiaa quea bihui po mee ca cua jama. Jama po majjeya aje mi oe quijje cuaqui yasijje poquiꞌyo majje quea yeno nee nee cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesosaa jama aca cua baꞌa: —¡Jjashajjaꞌajjaquicue oe! ¡Aꞌa oe ona botiꞌama pojji! ");
INSERT INTO eseNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","¡Quea boti aꞌyocue dejja minijje quea quene cuani! ¡Joya miquiana nijje mimijajianijo mimicue Eyacuiñajji nijje ojo! ");
INSERT INTO eseNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","¡Onaa shemo cuia cajje shemo mijipeajje cuia mee oꞌoyacue! ¡Onaa miquianajaya daqui jjequisejjajea cajo dojo meeꞌyocue miquianajaya pea daqui peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Onaa: “¡Aquiana che mo quiacue!” acajje, ¡quiacueya oe! Onaa miquianajaya aquiana sii cajo ¡aꞌa huohuiꞌajjaꞌyojji! ");
INSERT INTO eseNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Miquianaya mimiani pea cuana nijje jama baꞌa: “¡Enijje quea bame nee po tiitiiꞌyocue!” ¡Jamajjeya miquianaya pea cuana nijje quea bame nee po tiitiiꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Joya miquiana quea jea ajji cuani miquiaaya quea jea nee aña peaꞌai; miquiana nijje quea quene cuani ca ca miquianajaya botiꞌama. Dejja mimishi cuana aje oe jamaya cuani peaꞌai. ¡Aꞌa dejja mimishi jayojjaya pojji! ¡Ojjaña quea jea nee nee acue! ");
INSERT INTO eseNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Miquianaaya miquianajaya epeejji quea bame aña, pea cuana caya ca oe botiꞌama aña. Dejja mimishi cuaa aje oe jamaya acani peaꞌai, de. ¡Aꞌa dejja mimishi jayojja pojji; ojjaña quea bame acue! ");
INSERT INTO eseNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Miquianaaya joya jjaquiaquiꞌyojji yasijje quiaña. Joya jjaquiaquiꞌyo ajja huasijje quia jjima aña. Dejja mimishi cuana aje oe jamaya cuani peaꞌai. ¡Aꞌa dejja mimishi jayojja pojji! ¡Aꞌa quea dejja tai pojji! ¡Aꞌa quea nishehui pojji! ");
INSERT INTO eseNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","¡Miquianaaya miquianajaya epeejji pojjeama cuana quea jea nee aꞌyocue! Jamajjeya quea bame baꞌejeꞌyo. ¡Pea cuana miquianajaya aquiana dojo sa cuanijo oe pojji cahuime dojo meecue! ¡Miquianaya aꞌa jjashahuabaquijji miquianajaya aquianajo, miquianajaya bejjojo! ¡Eyacuiñajjijo oe jjashahuabaquicue! Majoya miquianaya ojaya epeejji nei cuajeꞌyo. Eyacuiñajjiya ojjaña cuanaya quea jea nee nee acani. Ojjaña dejja cuana, ojaya epeejji cuana, ojaya epeejji pojjeama cuanaya quea jea nee acani, de. ¡Jamaya oe pocue! ");
INSERT INTO eseNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Eꞌe de, esejaya Chii eyajo quea bame nee ani, ojjaña cuana Eyacuiñajjiya quea jea nee nee acani. ¡Eyacuiñajji jayojjaya jama po tiitiicue! ");
INSERT INTO eseNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesosaa jama aca cua baꞌa: —¡Aꞌa pea niñebajji! Jamaya Eyacuiñajjija botiꞌama. Miquianaya pea cuana niñebajji cuanijo, Eyacuiñajjiya miquianaya tecuea cajeꞌyo peaꞌai. Miquianaya pea nijje jjabeiquiꞌyajo Eyacuiñajjiya miquianajaya mimishi cuijea cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Miquianaaya pea cuana huasijje quea huiso nee quiajo, jamaya quea huiso nee nee miquianaya Eyacuiñajjiya oya huisoajjaya quia cajeꞌyo peaꞌai. Quea huiso nee nee cuaje, de. Oe pojji quiajo ca ca miquianaya Eyacuiñajjiya oya huisoajjaya quia cajeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesosaa pea esohui ejjashahuabaqui meejji jama aca cua baꞌa: —Eꞌe de, ¿aꞌa acuae oe cojjamaa pea cojjamaꞌ me pejjejea majje dojo caje soꞌo? Cho, eme pejjejeajji pojjeama, o peaꞌai oquejeaquije mei jjani yasijje, de. Cojjamaꞌ jayojja dejja mimishi pea dejja mimishiya dojo cajje cuaqui yasijje poquijeꞌyo onijje tii. ¡Aꞌa cojjamaꞌ jayojja pojji! ");
INSERT INTO eseNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Oe esohui huohuijji quea jaꞌa nee nee cuani. Ohua esohui huohui coo canijo, o shajjaꞌajjajji cuana quea jaꞌa pishana cuani. Jamatii ma eshajjaꞌajjajji quea jaꞌa cuaje ojaya esohui huohuijji shajjaꞌajja neinei majje. Jamajjeya ¡ecuea esohui shajjaꞌajja neineicue quea jaꞌa epojji! Jamajjeya miquianaaya quea jaꞌa nee huohuije pea cuana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—Jamajjeya ¡jjashahuaba bamebamequicue; aꞌa pea niñebajji! Jamatii miquianajaya epeejji cuana quea mimishi cuajo, niñebaña. ¡Aꞌa jamaya pojji! ¡Miyaya ebionei miquea mimishi cuana pajeaꞌyocue! ¡Majoya miyaya pea cuana mimishi pajea meesahuaꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Oya jayojja yani miquea epeejjija ecojjajo shabo mimishi jayojja. Jamajjeya miya jjashahuabaquiani miquea epeejjija ecojjajo nequi shabojo cuaya meeꞌyo sa aña jama baꞌa: “Epeejji, shabo biso neiya mi cojja dobi canaje. Ache baꞌajja; cahuijjiaꞌajjaꞌyosahua”. ¿Aꞌa acuae jja oe miya jjabaquiani acui cojjajji soꞌo? ¡Ebionei miquea cojjajo nequi acui huijjiaꞌyo socue! ¡Majoya miquea epeejjija shabo huijjiaꞌyocue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesosaa jama aca cua baꞌa: —Oe acui quea bame, ojaya ejjajja quea bame peaꞌai. Pea acui quea tai, jamajjeya ojaya ejjajja quea tai cuani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Oe acui ejjajja nei cuani, pea jjajjame pojjeama cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","¡Miquianaya oe jjashahuabaquicue, acui quea bame nee jayojja jama pocue! ¡Quea bame nee jjashahuabaquicue Eyacuiñajjijo! Majoya miquianaya quea bame baꞌejeꞌyo. ¡Aꞌa jjashahuaba taiquijji oe acui quea tai jayojja! Miquianaya jjashahuaba taiquiajo miquianajaya esohui quea tai cuajeꞌyo ma acuijjajja quea tai jayojjaya. ¡Jamatii jjashahuabaquicue Eyacuiñajjijo, ojaya esohuijo! ¡Quea bame baꞌe tiitiicue pea dejja cuana nijje! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesosaa pea esohui huohui ca cua jama baꞌa: —Miquianaaya eya huohui nishoaña jama baꞌa: “Emeshi Mese, eya shajjaꞌajja sa cuani miquea esohui”. Cho, ecuea esohuijo jjashajjaꞌajjaqui sa po ajja miquianaya —Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eyaya miquianaya huohuije beca dejjajo jama baꞌa: Oe dejjaa equi iya bamebame canaje jayojja jama miquianaya jjashajjaꞌajja neineiquiani ecue esohuijo. Dejjaa equi iya canaje quea bame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ohuaya tio canaje jjani emaco huasijje. Quea doe nee tio canaje. Majoya quea caꞌa nee nee nequinaje equi yamajjana. Jama acanaje ojaya equi. Equi iya majje ena quea quemo cueyanaje, beni quea quemo cueyanaje peaꞌai. Cuei jjayehuequiꞌyajo jaabichaquiꞌyo jjima equi cuanaje. Quea caꞌa iyame jojoya mi jaabichaquiꞌyonaje —Jesosa cua—. Jamaya ecuea esohui shajjaꞌajja majje miquianaya quea caꞌa cuaje ma equi jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Beca cuana jjashajjaꞌajjaqui ajja ecuea esohuijo jiquio ecua oe dejjaa iya tai canaje ojaya equi. Cuei sahuajo baꞌeꞌyonaje. Ohuaya tio canaje jjani sisi; doeꞌama. Ena quea quemo cuajo, beni quea quemo cuajo, cuei jjayehuequiꞌyajo ojaya equi jaabichaquiꞌyonaje; caꞌaꞌama equi cuanaje, de. Jamaya miquianaya caꞌaꞌama cuaje, ecuea esohuijo jjashajjaꞌajjaqui ajjajo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesosa dejja cuana nijje mimijeyo majje poquia cua Capenaoma cuiñajji yasijje. Oe Shomano esohuinano mese jomajo baꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ojo chacochacoani emanojaa cua. Beshahua nei poquijeyoa cua, de. Ma ojo chacochacoani quea bame chacochaco ania cua. Jamajjeya esohuinano meseya huaquia meeꞌyo sa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ohuaya shajjaꞌajja ca cua Jesosa yani, Jesosaa pea cuana jjaajaqui mee caꞌyani. Jamajjeya esohuinano mese jama jjashahuabaquime cua baꞌa: —¿Aꞌa Jesosaa ejo chacochacoani jjaajaqui mee cajeꞌyo? Cabaꞌajja. Jamajjeya ohuaya huoojea ca cua Jodio etii cuana Jesosa huohuiꞌajjaa. Oya jama cua baꞌa: —¡Poquicue; Jesosa huohuiꞌajjaquicue jiquiacua ecuejji! “¡Jjaajaqui meehuaꞌyocue ejo chacochacoani!” acue —jamaya cua esohuinano mese. ");
INSERT INTO eseNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Majoya aje Jodio etii cuana poquia cua Jesosa huohuiꞌajjaa. Huohuiꞌajja cañaquia cua esohuinano meseja esohui jama baꞌa: —Jesosa, esohuinano meseya ecuana mi que huoojea canaje, ¡ojo chacochacoani jjaajaqui meequiꞌyocue pa! Esohuinano meseya aje oe quea bame nee nee nequi. ");
INSERT INTO eseNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jodio dejja cuana ohuaya quea bame nee baꞌe meesahua cani. Ojaya ecuanaya quea boti nee nee, de. Ohuaya iya mee canaje equi ejjachichaquijji ecuanaja meshijo, de —jamaya cua Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Majoya aje Jesosa jama cua baꞌa: —Eꞌe, cuaꞌa. Majoya aje poquia cua esohuinano meseja equi yasijje. Equi chipi nei cuajo esohuinano meseya huoojea ca cua ojaya epeejji cuana Jesosa huohuiya. Jama aca cua baꞌa: —Jesosa, ¡aꞌa miya cuejji! Miquea esohui quea poja nee nee. Jamajjeya ¡ejo chacochacoani miya miquea esohuijo jjaajaqui meeꞌyocue! Eya esohuinano mese, jamajjeya miya pojjaꞌa dobiqui sa po ajja ecuea equi yasijje. Eya jjashahuabaquiani miya pojjaꞌa enijje mimi sa po ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jamajjeya eyaya ecuea epeejji huoojeanaje minijje mimiya. Jomajo mimicue miquea esohui nei jama baꞌa: “¡Ojo chacochacoani jjaajaquiꞌyocue!” Majoya jiquiojo ejo chacochacoani jjaajaquijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jamaya ecuea emeshi meseya huohui cajje eya poquijeꞌyo. Ecuea sohuinano cuana eya huoojeajje poquije. Pea sohuinano eyaya iyaajje cueje. Ecuea echacojji eyaya chaco meeajje chaco caje, de. Jamaya miya huohuiajje ecuea echacojji jjaajaquijeꞌyo —jamaya esohuinano mese huoojeameya aca cua Jesosa que. Jamajjeya ma ohua huoojea ca cua poquia cua, huohui cañaquia cua Jesosa esohuinano meseja esohuijo. ");
INSERT INTO eseNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesosaa shajjaꞌajja ca cua. Quea bihui cua esohuinano meseja esohuijo. Jesosaa huohui ca cua pea cuana onijje nequi, jama baꞌa: —De, ma esohuinano meseja eba eyaya jiquiojo tii ojo chacochacoani jjaajaqui meejeꞌyo ecuea esohuijo tiiya. Jodio dejja cuana jjashahuabaqui neinei jjima oya jayojja. Oya ca ca oe jjapee neineiquinaje Eyacuiñajji nijje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Majoya esohuinano meseja epeejji cuana poquia cua oja equi yasijje. Majoya aje dobiqui majje ejjaajaquiꞌyo ani ba cañaquiꞌya cua, Jesosaja esohuijo jjaajaquiꞌyo ani: —¡Eꞌe de, eꞌe jojo nei ojaya esohui quea poja nee nee, de! —jamaya cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Quijje pishana Jesosa poquia cua Naini yasijje. O shajjaꞌajjajji cuana, pea cuana peaꞌai poquia cua onijje. Quea huiso poquia cua, de. ");
INSERT INTO eseNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesosaa Naini yasijje poquijeya ba ca cua pea dejja cuaa ebacua ejja emanoꞌyo dojo caje ohuajeaa. Enaese pa neinei poquia cua. Oya quea yeno nee nee cua oe nei nei oja bacuajojo, eꞌahuemanoꞌyo jjejojoya. Quea dejja huiso nee onijje cueya cua ebacua ohuajea sahuaa. ");
INSERT INTO eseNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eꞌahuemanoꞌyohua Jesosa quea yeno po mee ca cua, de. Jesosaa majoya oya jama aca cua baꞌa: —¡Aꞌa pajji! Ohuaya shequi meeꞌyo sa aca cua oja bacua ejja. ");
INSERT INTO eseNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Majoya aje Jesosa poquia cua ebacua ejja emanoꞌyojaa huasijje. Majoya aje ma dejja cuana nequiñaquia cua Jesosa cueje ba majje. Jesosaa emano dojojji napa ca cua. Majoya Jesosaa emanoꞌyojaa jama mimiame aca cua baꞌa: —Eshoꞌi, ¡shequiꞌyocue jjeyahua nei! ");
INSERT INTO eseNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Majoya aje ma emanoꞌyojaa anisohuaꞌya cua. Mimiꞌya cua, de. Jesosaa oya jama huohuime aca cua baꞌa: —¡Poquiꞌyocue mique nae nijje! ");
INSERT INTO eseNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ojjaña aje majoya jama cua baꞌa: —¡De, eshoꞌi emano neineiꞌyojaa shequiꞌyonaje yaña, de! Eyacuiñajjiya oya shequi mee caꞌyonaje, de. Ohuaya Jesosa huoojea canaje ecuana huasijje. Eꞌe, oya quea sohui poja nee nee, quea bihui nee nee po mee caꞌyonaje ecuanaya. Eꞌe de, eꞌe jojo nei Jesosa, oya cueꞌyonaje ecuana baꞌe meesahuaa —jamaya ojjaña cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jodea meshijo baꞌe cuana, quea huesha baꞌe cuana, pea meshijo baꞌe cuana peaꞌai Jesosajo huohui cañaquia cuaa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Huani Eyacuiñajjija esohui huohuijjijojo ejeanobiajaa cua. Jamatii Huani ejeanobiajaajo o shajjaꞌajjajji cuaa Jesosaja esohui huohuiqui ca cua Huani que. ");
INSERT INTO eseNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Huaniya ma esohui shajjaꞌajja majje beca o shajjaꞌajjajji cuana huoojea ca cua Jesosa huohuiꞌajjaa. Jama huohuime aca cua baꞌa: —Huohuiꞌajjacue Jesosa jama baꞌa: “Jesosa, Eyacuiñajjiya ojjaña jaahuanajji huoojea cajeꞌyo ecuana huasijje. ¿Aꞌa miya ma ecuana jaahuanajji cuaniya? Eꞌe pojjaꞌa, pea pojjaꞌa ecuaaya ishoaꞌajjaje” jamaya acue —Huaniya aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Jamajjeya Huani shajjaꞌajjajji cuana poquia cua Jesosa huohuiꞌajjaa. Jesosa ba cañaquia cua emanojaa cuana jjaajaqui meeꞌyo cuequi. Eshahua cuana cuaya meequiꞌyo cuequi. Cojjamaꞌ cuana jjacojjajaꞌaqui meeꞌyo cuequi. Majoya oya cuaa huohuiꞌajja ca cua Huanija esohuijo. ");
INSERT INTO eseNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesosaa jama sajaꞌa ca cua baꞌa: —Eꞌe, ¡Huani oe huohuiquicue joya miquiaaya shajjaꞌajjanaje, joya miquiaaya banaje peaꞌai! Eꞌe, cojjamaꞌ cuana jjacojjajaꞌaqui meeꞌyonaje; jioꞌajja cuana jeo meeꞌyonaje; dejja batata epoꞌyo cuana jjajeaqui meeꞌyonaje; shajjaqueba jjashajjajaꞌaqui meeꞌyonaje; emanoꞌyo cuana shequi meeꞌyonaje. Esohui quea bame nee huohuinaje ojjaña dejja quea yeno huasijje Eyacuiñajjija epeejji epoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jamajjeya ¡huohuiquicue Huani que! Jama huohuiquime acue baꞌa: ¡Jjapee tiitiiquicue Eyacuiñajji nijje, enijje peaꞌai; quea jaꞌa nee baꞌecue! Jama miya ajje quea bihui po tiitiijeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Majoya aje Huani shajjaꞌajjajji cuana poqui oꞌoyanaje Huani que. Majoya o poquiꞌyajo, Jesosa pea cuana nijje Huanijo mimia cua: —Eꞌe de, yahuajo Huani quimajo aninaje. Miquianaya aje majoya o que poquinaje. ¿Aꞌya acuae jomajo banaje? ¿Aꞌya acuae miquianaya jjashahuabaquinaje Huanijo? ¿Aꞌa jjashahuabaquinaje Huani esohui huohuijji quea jaꞌa pojjeama? Chojja. ");
INSERT INTO eseNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Miquianaaya ¿ae banaje Huani que poqui majje? ¿Aꞌa dejjaja daqui quea nahue nee ehuosho baꞌe banaje? Chojja, dejjaa daqui quea nahue nee huosho cani equi quea quemojo baꞌeya. ");
INSERT INTO eseNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Achajja acuae Huani baꞌenaje? ¿Aꞌa miya jjashahuabaquinaje Huani Eyacuiñajjija esohui huohuijji nei nei? Eꞌe, de. Jamatii Eyacuiñajjija pea esohui huohuijjiya quea jaꞌa pishana huohui ca cua. Huaniya ca ca quea jaꞌa nee nee huohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yahuajo nei Eyacuiñajjija esohui etehueꞌyo Huanijo jama cua baꞌa: “Jiquio dejja ecuea esohui huohuijji nei cuani. Jamaya eya sa cuani. Eyaya oya huoojeaje ebionei mi hui dojojji. Ohuaya dejja cuana huasijje huohui caje miquea ecuejjijo”. Jamaya yahuajo nei nei Eyacuiñajjiya ojjaña ba mee canaje Huaniya e cue jjimahuajo, ejo jjabahuejjaqui mee caꞌyonaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ecuea pea ehuohui aꞌa pajeaꞌyojji jama baꞌa: Huani ma ona besameejji cua oe dejjaya quea bame nee nee pea cuana jayojja jama pojjeama. Jamatii quijje eya Emeshi Mese nei cuaje, ojjaña ecuea epeejji Huani jayojja jama cuajeꞌyo quea bame nee nee —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ojjaña dejja Huanija besamee Jesosaja esohui shajjaꞌajja majje quea bihui nee nee cua Eyacuiñajji nijje. Ojjaña dejja quea mimishi nee nee cuani cuaaya Eyacuiñajjija esohui shajjaꞌajja majje mimishi pajea caꞌya cua. Jamajjeya oya cuana Huanija ebesamee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Paniseo dejja cuaa Moisesija etehueꞌyo huohuijji cuaa peaꞌai ca ca Huanija esohui shajjaꞌajja jjima aca cua. Eyacuiñajjijo quea bihui pojjeama cua, Eyacuiñajjija epeejji nei po sa po ajja jjejojo. Jamajjeya Huani que enajje pohua poqui jjima cua, mimishi pajeaꞌyo sa po ajja jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Majoya aje Jesosa jama cua baꞌa: —Dejja cuana mimishi pajeaꞌyo sa po ajja ¿aꞌya jayojja cuani? ");
INSERT INTO eseNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Joya ecua eshoꞌiquiana quebanei jayojja jama cuani. Eshoꞌi cuana quebanei po majje joya pea que taaani jama cuaje pea nijje jjapeequi sa po ajja jjejojo. Jama jjamimihueꞌequime cuani baꞌa: “Eyaya dehue miaña mi quea bihui epojji nisho. Jamatii miya quea bihui po sa po ajja. Majoya eya pa nishoani, emanoꞌyojo pa ani jayojjaya mi quea bihui epojji nisho. Jamatii miya pa nisho ajja. Jamajjeya ecuea ba jjima eyaya miya achajja quea bihui po meeme aje. Miya niñepoqui jayojja cuani, jamajjeya quebanei po ajja” jamaya eshoꞌiquiana quebanei cuani —Jesosa cua—. Eꞌe de, jamaya dejja mimishi cuana jjeya cuani ma eshoꞌiquiana jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yahuajo pishana Huani cueꞌyonaje. Eyacuiñajji nijje mimi tiitiianijo bobi ijjia ajja cuanaje. Acuijjajja na sese ishi jjima aca cua. Ojjaña cuaa ca ca huohui canaje Huanijo jama baꞌa: “Huani ca jja ca niñepoqui nei”. ");
INSERT INTO eseNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Eya ca jja ca ijjiaꞌijjiani dejja mimishi cuana nijje. Oya cuana nijje mimimimiani. Jamatii beca cuana ejo siajje cuani jama baꞌa: “¡Bacue jiquio dejja Jesosa! Dejja mimishi cuana nijje jjapeequiani; bejjo chichajji cuana nijje peaꞌai jjapeequiani, de”. Jamajjeya beca cuana ca ca jjapeequi sa po ajja enijje, Huani nijje peaꞌai. Ecuea ba jjima achajja oya cuana eyaya quea bihui po meeme aje. Oya cuana eshoꞌiquiana quebanei po ani jayojja cuani, de. Niñepoqui jayojja cuani. Oya cuana mimijajiani Huani nijje, enijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eyacuiñajjija esohui eꞌe jojo nei. Jamaya ojjaña cuana oja esohuijo jjashajjaꞌajjaqui majje quea jaꞌa po mee caje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Oe Paniseo dejja yohua bajjani cua baꞌa: Simoni. Ohuaya Jesosa eꞌijjiaꞌijjiajji iyaa ca cua. Jamajjeya oja equi yasijje poquia cua ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jesosa ijjiaꞌijjia anijo oe epona dobiquia cua equi yasijjeya Jesosa baa. Ma epona quea mimishi baꞌya cua. Tahuoojo shiyeshiye ye ca cua, Jesosa ba majje. ");
INSERT INTO eseNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ojaya mimishijo quea yeno nee nee cua. Pa neinei ania cua. Ecojja naa shacua ca aña cua Jesosaja ejiojji. Ojaya esao aoꞌaohua cui ca aña cua. Jesosa quea jeajojo jiojji tojjo ca cua. Jesosaja ejiojji tojjo majje shiyeshiyeya jiojji sha ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma Simoniya epona ba ca cua; jjashahuaba taiquia cua jama baꞌa: —Jesosa Eyacuiñajjija esohui huohuijji nei pojjeama pojjaꞌa. Jamajjeya jiquio epona quea mimishi nee nee ohuaya mi huoojea cani. Eyacuiñajjija esohui huohuijji nei nijje mimishi cuana jjanequichipiqui ajja —jamaya eꞌacajeꞌyo poso Simoniya aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesosaja eba Simonija ejjashahuaba taiquijji. Majoya jama huohuime Jesosaa aca cua baꞌa: —Simoni, ecuea esohui mi que ehuohuijji yani. —¡Ocue mo huohuiꞌajja socue! —Simoni cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jamajjeya Jesosaa jama huohuime aca cua baꞌa: —Oe dejja quea bejjo huiso nee baꞌenaje. Majoya aje becanejjijji peaꞌai dejja poquinaje o que bejjo sosemaꞌ jjesheya, quijje esosequiaꞌyojji nisho. Oe dejjaa iye huiso jjeshe canaje 500. Pea dejjaa ca jjeshe canaje baꞌa oe pojji nei 50. ");
INSERT INTO eseNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma dejja cuanaja oya sosequiaꞌyo jjima tii cuanaje. Jamajjeya ma dejja quea bejjo huiso jjapeequi sa cuanaje bejjo jjeshejji cuanaje cuana nijje. Jamajjeya ejjeshejji epo cuanaja ebajjani cuijea caꞌyonaje jamatii bejjo sosequiaꞌyo jjimajo tiiya. Majoya oya cuana quea bihui poꞌyonaje bajjani cuijea caꞌyajje. Eꞌe, ¿ache dejja quea bihui nee nee cuanaje oja bejjo sosemaꞌyo tiijojo? Ma dejja quea huiso, 500 sosequia jjima pojjaꞌa. Pea dejja iye huiso, 50 sosequia jjima pojjaꞌa —jamaya huohuiꞌajja ca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni jama cua baꞌa: —Ma dejja quea huiso bejjo quia canaje, 500. Jesosaa jama aca cua baꞌa: —Eꞌe de, eꞌe jojo nei. ");
INSERT INTO eseNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jamaya jiquio epona eya mimishi cuijeaꞌyajje quea bihui nee cuani. Eya dobiquinaje miquea equi yasijje. Miya ca mi ca oe ecuea epeejji pojjeama cuanaje, Simoni. Jamatii beca cuana cueanijo equi meseya ojaya epeejji cuana jiojji topo cani. Jamaya miquea ajjima. Ma eponaa ca ca ecuea ejiojji topo canaje oja ecojja naa. Oja sao aoꞌaohua cui caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Eꞌe, miyaya ecuea epeejji pojjeama jjejojo mi shemo tojjonaje. Jiquio eponaa ca mo ca ejiojji tojjo tiitii canaje ojaya quea jea nee neejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Miyaya eya sha jjima anaje shiyeshiyejo ejjapeequijji. Jiquio eponaa ca ca ecue ejiojji sha canaje shiyeshiyeya ecuea epeejji nei sa cuaniya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eꞌe, jamajjeya eyaya miya huohuiaña jama baꞌa: Ma epona jjapeequi sa cuanaje Eyacuiñajji nijje. Jamajjeya aje oe ohuaya ecuea ejiojji topo canaje, quea shiye po mee canaje peaꞌai. Ma epona quea mimishi nee nee cuanaje. Jamajjeya eyaya, Eyacuiñajjiya peaꞌai oya mimishi cuijeaꞌyonaje quea jea nee neejojo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Majoya Jesosaa epona jama huohuime aca cua baꞌa: —Miquea mimishi cuana eyaya cuijeaꞌyonaje jjeya nei. ");
INSERT INTO eseNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pea dejja cuaa equijo ijjiaꞌijjia aniya Jesosajo jama huohuime aca cua baꞌa: De, ¿aꞌya acuae jja che mimishi cuijeaꞌyojji pome soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesosaja eba cuanaje ma dejja cuana mimi caꞌani. Jamajjeya ohuaya epona huohui ca cua jama baꞌa: —¡Miquea mimishi cuijeaꞌyonaje, jamajjeya quea bame baꞌeꞌyocue mimishiꞌama! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Majoya aje Jesosa pea cuiñajji yasijje poquia cua Eyacuiñajjija esohui huohuiya. O shajjaꞌajjajji nei cuana, 12 poquia cua onijje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Quea huiso epona cuana poquia cua Jesosa nijje, ma ohuaya yahuajo jjaajaqui mee caꞌyonaje, edosiquiana cuaya meequi caꞌyonaje peaꞌai. Oe epona Sosana bajjani; pea epona Mania Madanena bajjani cua. Maniaja 7 edosiquiana cuana Jesosaa cuaya meequi caꞌya cua. Pea epona Huana bajjani cua. Oya Cosaja ehuanase cua. Cosa emeshi meseja, Enode Antipaja echacojji cuana jaahuanajji cua. Quea huiso epona cuaa bobi jjeshe ca cua oja bejjojo Jesosa bobiajji, o shajjaꞌajjajji cuani cuana bobiajji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Quea dejja huiso nee nee poquia cua Jesosa shajjaꞌajjaa. Jjachichaquia cua Jesosa pejjejo. Jesosaa huohui ca cua jiquio esohui. Jama huohuime aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Oe dejja poquinaje que yasijje esoꞌ jeaajaa. Oe pojji esoꞌ jeaaja canaje ejiojji yasijje. Cuichojji cuaa ma esoꞌ ijjia caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pea esoꞌ jeaaja canaje meshi mei biajje ani yasijje. Majoya aje jeaaja cajje pohuaꞌajjaꞌyonaje. Majoya aje pohuaꞌajjaꞌyo majje shocanaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pea eso jeaaja cajje oquequinaje acuisha yiye yasijje. Majoya aje jeaaja cajje pohuaꞌyonaje. Majoya aje pohuaꞌyo majje acuishaa mano mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pea esoꞌ ca ca meshi bame bame yasijje jeaaja canaje. Majoya aje jeaaja cajje tiiꞌyonaje. Majoya aje tiiꞌyo majje quea jjajja huiso nee nee cuanaje, de. Eꞌe, mahuiso. ¡Shajjaꞌajjacue jiquio esohui; aꞌa shajjamaꞌ jayojja pojji! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Quijje o shajjaꞌajjajji cuana poquia cua Jesosa huohuaꞌajjaa. Jama huohuaꞌajjame aca cua baꞌa: —¿Yajjajje ma esohui quea quehua cuanaje ecuanaja? —jamaya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesosaa jama huohuime aca cua baꞌa: —Miquianaya Eyacuiñajjiya ba meesahua caje ojaya esohui eyacua. Beca cuana shajjamaꞌ cuani ca ca ohuaya eba meesahuajji pojjeama. Esohui eba meesahuajjijo huohuiaña beca cuana shajjamaꞌ cuanijojo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jamajjeya eyaya miquianaya huohuije quea jaꞌa epojji. Ma esoꞌ Eyacuiñajjija esohui jama cuani; meshi dejja jayojja cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Meshi ejiojji quea caꞌa huasijje esoꞌ oquequinaje, dejja shajjamaꞌ Eyacuiñajjija esohui shajjaꞌajja sa po ajja jayojja. Eyacuiñajjija esohui jjajaꞌaqui ajja quea sapa caꞌa jjejojo. Cuichojjiya esoꞌ ijjia cani jayojja jama Edosiquiana etiiya Eyacuiñajjija esohui pajea mee caꞌyani, jjajaꞌaqui mee jjima acani. Jamajjeya ohuaya dejja jjapeequi mee jjima acani Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Meshi mei biajje anijo esoꞌ pohuaꞌajjaꞌyani jama jayojjaya dejja cuaa Eyacuiñajjija esohui shajjaꞌajja cani. Ebioneiya aje ca Eyacuiñajji nijje jjapee nishoquianiya. Majoya aje pea cuana onijje mimijajiajo Eyacuiñajjija esohui pajea caꞌyani. Jjapeequi pajeaꞌyani Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pea dejja meshi acuisha yiyejji jayojja jama. Eyacuiñajjija esohui shajjaꞌajja cani. Ebioneiya aje ca oe shajjaꞌajja caniya Eyacuiñajji nijje jjapee nishoquiani. Majoya aje jjashahuabaquiꞌyani pea aquianajo quea mimishi epoꞌyojji. Jama jjashahuabaquiꞌyomeya cuani Eyacuiñajji epajeaꞌyojji. Eyacuiñajjija esohui ebajji nisho cuani. Ma esoꞌ acuishaa mano mee caꞌyani jayojjaya ejjashahuaba taiquijjiya acaꞌyani Eyacuiñajji nijje epo pajeaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pea dejja meshi quea bame nee nee jayojja cuani. Eyacuiñajjija esohui shajjaꞌajja neinei cani. Shajjaꞌajja neinei majje Eyacuiñajjija epeejji tii tii cuani. Ohuaya ojaya esohui ba neinei cani. Jjashahuaba bamebamequiani. Ma dejja cuana ecuea esohui ba neineijji epojji —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesosaa jiquio esohui jama huohuime aca cua baꞌa: —¿Aꞌa eseya eseja cuaquijijiya jeajaꞌa came eshajajo capa nequiya? Chojja. ¿Aꞌa eseya ejaajji quimejjejje nequiya jeajaꞌa came? Chojja, de. ¡Eseya quea jaꞌa po mee sa añajo ca eyajo nequiasohuacue ojjaña quea jaꞌa epojji! ");
INSERT INTO eseNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jama jayojjaya Eyacuiñajjiya ojjaña ecuea esohui onaaya ba mee cajeꞌyo quijje. Quea jaꞌa nee cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Miya ecuea esohui shajjaꞌajja sa cuanijo Eyacuiñajjiya miya quea jaꞌa nee nee po mee caje. Beca cuana ecuea esohui shajjaꞌajja sa po ajjajo ohuaya quea jaꞌa po mee jjima acaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Majoya Jesosaja enaese cueꞌya cua equi yasijje Jesosa baꞌyohua. Baꞌyo jjima cua ojaya, quea dejja huisojojo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oe dejjaa Jesosa jama huohuime aca cua baꞌa: —Mique naeya mi saꞌajja caꞌyoqui mique chahuaa peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jamaya Jesosa cua baꞌa: —Eꞌe de, ojjaña nei neiya Eyacuiñajjija esohui shajjaꞌajja neineijji cuani ecue nae nei nei cuani, ecue chahua nei nei cuani, Eyacuiñajjija epeejji nei nei cuanijojo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Oe pojjajo Jesosaa o shajjaꞌajjajji cuana jama aca cua baꞌa: —¡Cuaꞌa; bae ojje miji yasijje besa poquicue! ");
INSERT INTO eseNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jamajjeya bishe ai yasijje ojjaña ania cua. Jesosa onaa dojobesa cajje cahuia cua. Majoya aje quea ichi po majje beni quea quemo nee nee cueya cua. Enashajohua bishe nanejea ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oe dejjaa majoya Jesosa jama isheꞌame aca cua baꞌa: —Esohui huohuijji, ¡shequicue oe! Coya aje se huiꞌiꞌya. Majoya aje Jesosa shequijeanana cua onaa isheꞌa cajje. Majoya aje shequi majje mimia cua beni nijje, ena nijje peaꞌai. Majoya aje o mimiajo beni nequioquequia cua enashajo peaꞌai. Majoya aje enashajo po jjima jayojja poꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","O shajjaꞌajjajji jama mimimeya cua baꞌa: —De, Jesosa quea sohui poja nee nee, de. Miminaje beni nijje; beni po jjima jayojja po mee caꞌyonaje, de. Majoya aje Jesosaa jama aca cua baꞌa: —¿Yajjajje acuae jja nequiana metenaje soꞌo, de? Jjashahuabaqui jjima pojjaꞌa jja nequiana Eyacuiñajjijo, de —Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Majoya oya cuana baꞌeñaquia cua Jjanana meshi yasijje. Baꞌeñaquia cua pea ojje miji yasijje, Janinea baꞌe cojja nei besa poquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesosa bishejo ani etaja huasijje nequisohuaquiajo, oe dejja cueya cua. Ma dejja quea shahua huiso jjejojo niñepoqui cua. Daquimaꞌ nei nei cua; quimaꞌ peaꞌai. Oya emojeajaaca huasijje baꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Jamatii oya quea tai po mee canaje eshahuaa. Jamajjeya oya dejja cuaa jeyo ca cua cadenaa, poqui ajja epojji. Jamatii ca ca cadena jjasejjajeaqui mee ca cua eshahuaa. Poqui mee caꞌya cua ma quima huasijje, de. Ma dejjaa Jesosa ba neinei ca cua. Majoya aje Jesosa nequi cojja nei ecuiꞌoshajjajo nequioqueña cua. Majoya aje Jesosaa jama aca cua baꞌa: —¡Eshahua cuana, cuayaquiꞌyocue! Majoya ma dejja jama cua baꞌa: —De, miya Jesosa, Eyacuiñajjija Bacua Ejja eꞌe jojo nei. ¡Aꞌa mo miyaya jinapajji soꞌo! —jamaya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Majoya Jesosa jama cua baꞌa: —¿Ae bajjani acuae miya? —Eya Quea Shahua Huiso bajjani —jamaya cua ma dejja quea shahua huiso jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eshahua cuaa Jesosa jama huohuime aca cua baꞌa: —¡Aꞌa ecuana huoojeajji cuaqui yasijje! ");
INSERT INTO eseNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","¡Ecuana oe cuichi cuanaja yami yasijje dobiqui meeꞌyocue! —¡Eꞌe ocuae dobiꞌajjaqui socue! —jamaya aca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Majoya aje cuayaquiꞌya cua dejjaja eshahua cuana, dobiquiꞌya cua cuichi cuana huasijje. Majoya aje cuichi cuana emacojo nequi cuajicuaji jaaoquequinana cua bae yasijje; huiꞌiꞌya cua ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuichi huiꞌijeꞌyo ba majje cuichi jaahuanajji cuana poquia cua cuiñajji yasijje ojjaña huohuiya. Jama aca cua baꞌa: —De, Jesosaa eshahua cuana cuaya mee canaje dejja niñepoqui meejji po nequinaje. Dobiqui mee canaje ecuanaja cuichi yasijje, huiꞌiꞌyonaje ojjaña cuichi, de. Cuajicuajinananaje bae yasijje, huiꞌiꞌyonaje. ¡Chamaꞌyo tii, de! ");
INSERT INTO eseNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Majoya ojjaña dejja cueya cua ae Jesosa po ani baa. Onaaya cue majje ba ca cua ma dejja niñepoqui cuanaje Jesosa pejjejo ani. Ma daquimaꞌ cuanaje daquijji aniꞌyo ba caꞌya cua dejja cuaa; quea bei aniꞌyo ba caꞌya cua. Jesosa quea sohui poja nee neejo ojjaña quea mete poꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma niñepoqui bajji cuanajeya Jesosajo huohui ca nequiꞌya cua pea meshijo baꞌe yasijje jama baꞌa: —Jesosaa eshahua cuana cuaya meequi caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Ojjaña cuana ma meshijo baꞌe quea mete nee nee cua. Quea meteya jjejojo Jesosa huoojeajea caꞌya cua. Ma niñepoqui cuanajeya ca ca Jesosa jama huohuaꞌajjame aca cua baꞌa: —Jesosa, eya minijje poqui sa cuani. Jesosa jama cua baꞌa: —Chojja, ¡miya poquicue miquea huapa pojjeama cuana huasijje! ¡Huohuiquicue ojjaña ma mi Eyacuiñajjiya jama acanaje! —jamaya Jesosa cua. Majoya aje ma dejja poquia cua o baꞌe yasijje huohuiya. Huohui caꞌya cua Jesosaa eshahua cuayaqui mee caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Majoya aje Jesosa besajebeꞌya cua. Baꞌeñaꞌya cua ojaya meshi yasijje. Ojjaña cuanaja Jesosa quea boti nee cua. Ishoaꞌajja ca nequia cuaa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oe dejja Jaino bajjani Jodioja ejjachichaquijji equi jaahuanajji cua Cesanenajo. Oya cueya cua Jesosa que. O cojja nei ecuiꞌoshajjajo nequioqueña cua. Ohuaya Jesosa huohuaꞌajja ca cua ojaya equi yasijje epoquijji oja bacua piona jjaajaqui meeꞌyojji. Ojaya ebacua piona ahuemaꞌani quea mano nee nee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Oja bacua piona oe nei cua, de. Majoya aje Jesosa onijje poquia cua. Beshahua nei poqui jjima cua quea dejja huisojojo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Oe pea epona quea mano dejja quea huiso yiyesamajo nequi. Oya quea mano nee nee, ojaya enaꞌ cuayaqui nequia cua 12 shequiajame, de. Oya eshicuijji jjeshejji jjejojo bejjomaꞌyo cua. Eshicuijji quiajjija epona naꞌ cuaya pajea meequiꞌyo jjima cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesosa poquianijo ohuaya Jesosaja daqui cuesha iña ca cua. Ma daqui cuesha iña cajje aje najji popajea mee caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Majoya aje Jesosaa jama aca cua baꞌa: —¿Aya acuae mo iña canaje soꞌo? O shajjaꞌajjajjiya, Penohua jama aca cua baꞌa: —Cuaꞌa, de. Quea dejja huisohua jjejojo mi, ¿aya shai mi iña canaje Jesosa? Napa jjima ca mi ca ecuanaja —jamaya Jesosa aca cua Penohua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesosa jama cua baꞌa: —Cho, ecuea eba Eyacuiñajjiya aꞌya shai huaquia mee caꞌyonaje e daqui iña cajo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma epona Jesosaja esohui shajjaꞌajja majje piopio cua. Ojjaña nequijo piopiojea cua. Ecuiꞌoshajjajo nequioqueña cua Jesosa nequi yasijje. Ohuaya Jesosa jama huohuime aca cua baꞌa: —Eꞌe ee, Jesosa, eyaya nei miquea daqui cuesha iñanaje. Jjashahuabaqui majje che mi daqui iña majje enaꞌ huosa meeꞌyojji. Jamajjeya che eyaya jamaya miya anaje —jamaya ma epona cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Majoya Jesosa jama cua baꞌa: —¡Aꞌa quea mete pojji, she! Eyaya miya naꞌ huosa meeꞌyonaje, miya jjashahuaba neineiquinajejojo. ¡Poquicue, quea bihui poꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesosa epona nijje mimianijo tii Jainoja epeejji cueya cua Jaino que. Jama cua baꞌa: —Jaino, miquea ebacua piona manoꞌyonaje. Chamaꞌyo tii, de. ¡Aꞌa poqui meejji ma esohui huohuijji nei! ");
INSERT INTO eseNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesosaa ma esohui shajjaꞌajja majje jama huohuime aca cua baꞌa: —¡Aꞌa miya quea mete pojji! ¡Jjashahuaba neineiquicue oe Eyacuiñajjijo! Miquea bacua jjeya shequijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Majoya Jainoja equi yasijje poquiña cua. Jesosaa beca cuana dobiqui mee jjima aca cua equi yasijje. Peno, Satiaco, Huani ca ca oe dobiqui mee ca cua. Ma ebacuaja chii enaese peaꞌai dobiqui mee ca cua. Mahuiso dobiquia cua emanoꞌyojaa baa. ");
INSERT INTO eseNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dobiqui majje oya cuaa ba ca cua ojjaña paꞌani quea yeno nee nee jjejojo, ebacua emanoꞌyojaajo. Jesosaa jama huohuime aca cua baꞌa: —¡Aꞌa pajji! Ma epona shoꞌi manoꞌyo jjima, ecahuijaa. ");
INSERT INTO eseNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Majoya ojjaña soaꞌya cua. Ojjañaa jama aca cua baꞌa: —Chojja, mano neineiꞌyonaje jja coma, de —cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Majoya aje Jesosaa epona shoꞌija eme iña majje janobajjima nei mimia cua jama baꞌa: —¡Eshoꞌi, nequisohuacue! ");
INSERT INTO eseNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Majoya aje shequiꞌya cua, nequisohuaꞌya cua: —¡Quiacue oya bobi! —Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma eshoꞌija chii quea bihui poꞌya cua oja nae peaꞌai. Jesosa jama cua baꞌa: —¡Aꞌa huohuijji cuana jiquio eya mique bacua shequi meeꞌyonajejo! —jamaya Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jesosa jjachichaquia cua o shajjaꞌajjajji cuana nijje, 12 huisome nijje. Ohuaya jama huohuime aca cua baꞌa: —Eyaya miquianaya huoojeaña pea cuana huasijje esohui huohuiya, pea cuana jjaajaqui meeꞌyohua, eshahua cuayaqui meeꞌyohua peaꞌai. ¡Huohuicue jama pea cuana huasijje baꞌa: “Eyacuiñajji ojjaña huoojeajji cuajeꞌyo” acue! ");
INSERT INTO eseNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","¡Aemaꞌ oe poquicue! ¡Aꞌa acui ejjaquecuacaꞌaquijji dojojji; bashosoco peaꞌai aꞌa dojojji! ¡Aꞌa bobi, bejjo peaꞌai dojojji! ¡Ma miquea eyamijo baꞌe nei oe dojocue! ");
INSERT INTO eseNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","¡Poꞌayequi nequicue oe pea cuiñajji yasijje! ¡Miquianaya oe pea cuiñajji yasijje poqui majje miquianajaya epeejji epojji saꞌajjacue; ojaya equijo anicue! ");
INSERT INTO eseNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dejja cuaa pea cuiñajjijo baꞌeya miquianajaya esohui cajaa acajeꞌyo pojjaꞌa. ¡Huohuicue jja oe ma dejja cuana jama baꞌa: “Quea mimishi mi coma” acue! “Eyacuiñajjiya jja miya ba cani. Ohuaya jja miya quea nee nee po mee cajeꞌyo” acue. ¡Ma esohui jama huohui majjeya oe cuayaquiꞌyocue cuiñajjijo ani! ¡Majoya cuayaquiꞌyo majje miquianajaya ejiojjijo ani meshi pohui cuiaiyajajeanaꞌyocue oya cuana jjashajjaꞌajjaqui ajja cuanajejojo! ¡Jamajjeya oe pea cuiñajji yasijje poquicue! —jamaya Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jamajje o shajjaꞌajjajji cuana poꞌayequi nequia cua Jesosaja esohui huohuiya. Onaaya huohui ca cua Eyacuiñajjija esohui; jjaajaqui mee caꞌya cua emanojaa cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Emeshi meseya Enode Antipaa shajjaꞌajja ca cua peaja esohui Jesosajo. Pea cuaa Enode siajje aca cua jama baꞌa: —Huani ca jja ca Jesosaya cuanaje. Huani ca jja ca shequiꞌyonaje —pea cuana cua. Enode quea ajjajja nee nee cua Jesosa Huani poso jojoya. ");
INSERT INTO eseNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pea cuaa Enode siajje aca cua jama baꞌa: —Chojja, Jesosa ca jja ca Eniaya, ma etiiquiana shequi oꞌoyanajeya —posoya aca cua. Pea cuana jama siajje pomeya cua: —Jesosa pojjaꞌa pea etiiquiana shequi oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Enode majoya jama cua baꞌa: —Eyaya nei ca jjaja ca Huani sapasejjajea meenaje, Huani mano neineiꞌyonaje, ecuea jjaja eba, de. ¿Ajeo shai jjaja ojjaña mimiani? Ache jja eyaya cabaꞌajja sahua Jesosa —jamaya Enode cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Quijje o shajjaꞌajjajji cuana esohui huohuiya poqui cue oꞌoya cua; Jesosa que huohui poñaꞌya cua. Majoya Jesosa shajjaꞌajja majje oya cuana poquia cua Betesaina huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jomajo o ba majje ojjaña jjachichaquia cua Jesosa que. Ojjaña quea bihui cua Jesosaa Eyacuiñajjija esohui huohui caquijo. Jesosaa jama aca cua baꞌa: “Ojjaña joya mimishi pajeaꞌyojji cuani, onijje eꞌe nei jjapeequiani Eyacuiñajjiya jaahuana cajeꞌyo”. Ohuaya emanojaa cuana jjaajaqui mee caꞌya cua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jjasinecuaquiajo ojjaña quea shoe nee cua; ye jjima ojaya bobi cua. O shajjaꞌajjajji cuaa Jesosa jama huohuime aca cua baꞌa: —¡Huoojeacue ojjaña, bobi saꞌajjaa, ecahuijji saꞌajjaa peaꞌai! Beshahua nei esejaya bobi jiquiojo chamaꞌ baꞌa, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesosa jamaya cua: —Chojja, ¡miquianaaya oe bobi quiacue eꞌijjiajji! Jamaya oya cuana cua: —De, oe pojji bobi yani. Beca nahuoo sisi yani, me oejje pahui yani. ¿Aꞌa ecuanaya capoquiahua cuiñajji yasijje bobi jjequiya pojjaꞌa, ojjaña dejjaja bobi jjequiya; quea bobi huiso epojji? ");
INSERT INTO eseNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yani quea dejja huiso nee nee, 5.000 yani, de. Jesosaa jamaya aca cua baꞌa: —Chojja, ¡aꞌa poquijji, ojjaña cuana anioque meecue, jjaanichichaqui meecue pea jjocojo, 50 anioque meecue! ");
INSERT INTO eseNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Majoya aje o shajjaꞌajjajji cuaa dejja cuana jama aca cua baꞌa: —¡Anioquecue oe nequiana! ");
INSERT INTO eseNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Majoya acua po majje Jesosaa ma pahui nahuoo peaꞌai jjeshe ca cua oja emeya. Jjeshe majje eyahuasijje jjabajeasohuaquia cua Eyacuiñajji nijje emimijji. Ohuaya Eyacuiñajji bihuia ca cua bobi eꞌijjiajji. Majoya Jesosaa miji sisisisi ca cua pahui, nahuoo peaꞌai. Majoya ohuaya bobi quia ca cua o shajjaꞌajjajji cuana huasijje. Pea cuana huasijje quia ca cua o shajjaꞌajjajjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ijjiaꞌijjia majje ojjaña dejja cuana quea jejje cua, de. Ojjaña dejja cuana jejjeajo iya caꞌya cua pea eshajajo tiiya iya ca poquiꞌya cua; 12 shajame bobi eꞌijjiasejjaja ecuatajea cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Oe pojjajo Jesosa oe nei mimia cua Eyacuiñajji nijje. O shajjaꞌajjajji cuana onijje nequia cua quea huesha pishana. Jesosaa oya cuana huohuiꞌajja ca cua: —¿Yajja mimime dejja cuana ejo cuani? ");
INSERT INTO eseNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jamajjeya o shajjaꞌajjajji cuana jama cua baꞌa: —De, pea cuana ca jja ca mijo jama mimime cuani baꞌa: Miya ca pajja mi ca pea dejja cuaa Huani poso acani. Pea dejjaa ca pajja mi ca Enia poso acani, ma etiiquiana, de. Pea dejjaa ca pajja mi ca pea etiiquiana shequi oꞌoyanaje poso acani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—De, ¿miquianaya yajja cuani soꞌo? —cua Jesosa. Peno ca ca jama cua baꞌa: —Miya ca ca Eyacuiñajjija Bacua Ejja oe nei, oja huoojeaꞌyo ojjaña jaahuanajji epojji. Ecuea Emeshi Mese nei nei, de. Miya Quito bajjani ecuea Emeshi Mese nei nei jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Majoya Jesosaa Peno jama huohuime aca cua baꞌa: —Eꞌe de, eꞌe jojo nei. ¡Aꞌa huohuijji pea cuana, ecuea bajjani Quito, miquea Emeshi Mese nei! ");
INSERT INTO eseNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Eya Eyacuiñajjija huoojeaꞌyo. Eya quea nee nee acajeꞌyo cuaa. Beca cuaa eya cajaa acajeꞌyo, Jodio etii cuaa, Eyacuiñajji nijje mimiani etii cuaa, Moisesija etehueꞌyo huohuijjiya peaꞌai. Mano mee cajeꞌyo eya, de. Eya manoꞌyo majje pea beca peejjima cahuime po majje shequije oꞌoya —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Majoya aje o shajjaꞌajjajji cuana Jesosaa huohui ca cua jama baꞌa: —Ojjaña ca jja ca enijje eꞌe jojo nei jjapeequiꞌyo sa cuani, oya Eyacuiñajjija esohui jayojja cabaꞌyahua. Eꞌe, ¡e jayojjaya pocue; enijje poquiꞌyocue! Jamatii onaa napa cajje aje jja mi oe quea nee nee cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Eꞌe, ojjaña cuana ecuea esohui shajjaꞌajja sa po ajjajo baꞌe tiitii ajja enijje eyajo. Joya ecuea esohui shajjaꞌajjajji cuani ca ca baꞌe tiitiijeꞌyo enijje eyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eꞌe pojjaꞌa dejjaa quea huiso nee nee aquiana ojaya yajji chicha cani. Jamatii oya cuana cuaqui yasijje jea cajo ojjaña ojaya aquiana cuana edojojji pojjeama. ¿Aꞌa ojjaña ojaya aquiana cuana quea bame cuaje oya cuaqui yasijje poqui majje? Chojja, de. ¿Aꞌa aquiana sosejje cuayaqui mee cajeꞌyo cuaquijo ani? Chojja, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oe dejja pojjaꞌa: “Cajaa” cuani ejo, ecuea esohuijo peaꞌai. Jamajjeya eyaya cue oꞌoya majje oya cajaa ajeꞌyo peaꞌai. Eꞌe jojo nei eya ojjañaja Edoe Mese cueje oꞌoya. Quea jeajahua nee nee, quea caꞌa nee nee cuejeꞌyo. Eya esohuidojojji quea huiso nee nijje cueje oꞌoya, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eꞌe jojo nei miquianaaya jiquiojo nequiya manoꞌyo jjimahuaa Eyacuiñajjija epeejji nei quea huiso nee nee baje —jamaya aca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Quijje, jiquio esohui huohui majje oe nomico aniꞌyo Jesosa poquia cua eyiyo huasijje. Peno, Satiaco, Huani peaꞌai poquia cua onijje. Poquia cua Eyacuiñajji nijje mimiya. ");
INSERT INTO eseNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eyacuiñajji nijje mimi majje Jesosaja ecojja quea jiji nee nee cua eshequi jayojja. Ojaya daqui peaꞌai quea oshe nee nee, quea siyo nee nee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Beca dejja emanoꞌyo eyajje jjanequijaꞌaquiꞌya cua Jesosa nijje. Oya cuana mimia cua Jesosa nijje. Oe dejja Moisesi etiiquianaya cua. Pea ca Enia etiiquiana cua, ma yahuajo nei nei baꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Quea bame nee nee quea jiji nee nee miminequia cua Jesosa, Enia, Moisesi peaꞌai. Jesosa miminequia cua onaja mimishijo emanoꞌyojji jjejojo Jenosanenajo. Jama mimimea cua Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peno, Satiaco, Huani peaꞌai quea cojja mano cua. Majoya aje shequi neiꞌya cua, ba ca cua Jesosa, Enia, Moisesi peaꞌai; quea jiji nee nee nequi, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisesi Enia mimijeyo majje poqui oꞌoya cua eyahuasijje. Poquijeꞌyo ba majje Penohua Jesosa jama aca cua baꞌa: —De, Esohui huohuijji, quea bame nee nee ecuanaya jiquiojo ani. Pea beca peejjima equi ejjaꞌiyaqui, oe miquea, oe Moisesija, oe Eniaja —jamaya cua Peno jjashahuaba bamequi jjima jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peno mimianijo tii bo oshe nee neeya oya cuana quehua ca cua. Bo ba majje quea mete nee nee poꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Majoya Eyacuiñajjiya bo tejjeeya esohui huohui ca cua jama baꞌa: —Jiquio Jesosa ecue Bacua Ejja, ecuea quea jea nee nee, eya ojo quea bihui nee nee. ¡Oya oe oe neiya shajjaꞌajjacue! —jamaya aca cua bo tejjee Eyacuiñajjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ohuaya cuana ma esohui shajjaꞌajja majje ba caꞌya cua Jesosa oe nei nequi; pea cuana chamaꞌ. Peno, Huani, Satiaco peaꞌai mimiꞌyo jjima nequia cua. Pea o shajjaꞌajjajji cuana huohui jjima aca cua. Quijje nei nei ca huohui ca cua, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mecahuajje jjapojjaquiajo Jesosa eyiyojo nequi jaaoqueꞌya cua. Quea dejja huiso nee neeya Jesosa ishoaꞌajja ca nequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oe dejjaa janobajjima nei jama huohuime aca cua baꞌa: —¡Esohui huohuijji, bahuacue ecue bacua! Ecuea ebacua oe nei, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Eshahuaa napa cajje, taaani jeabichajea canaje meshi yasijje; huapani peaꞌai. Eshahuaa manojea meeꞌyo sa acani. Jamatii oya cuani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eyaya huohuiꞌajjanaje miquea eshajjaꞌajjajji cuana eshahua cuayaqui meeꞌyojji. Eshahua cuaya meequiꞌyo jjima acanaje mi shajjaꞌajjajji cuaa —jamaya aca cua niñepoquija ejeajjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesosaa ojjaña cuana jama aca cua baꞌa: —De; ¿ache shono acuae jja nequiana ejo jjashahuabaquije eꞌe jojo nei? ¡Quea sapa caꞌa mi coma! ¿Ache cahui huiso minijje nequi majje miyaya eya bajeꞌyo Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji quea caꞌa nee nee? —jama tecueameya Jesosaa aca cua. Majoya ma dejja Jesosaa huohui ca cua jama baꞌa: —¡Miquea ebacua jjequicue! ");
INSERT INTO eseNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Majoya eshoꞌi jjequi ca cua Jesosa que. Ye cajo eshahuaa eshoꞌi jeabichajea ca cua; niñepoquia cua. Jesosaa eshahua eshoꞌijo nequi cuaya meequi caꞌya cua. Eshoꞌi niñepoqui pajeaꞌya cua. Majoya aje Jesosaa ejeajji nijje eshoꞌi poqui mee caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ojjañaa ba majje jama aca cua baꞌa: —De, quea sohui poja nee Jesosa cuanaje. Eyacuiñajjiya Jesosa quea sohui poja nee po mee canaje. Ma eshoꞌi niñepoqui pajea meeꞌyo majje ojjañaa bihuia ca cua Jesosa, Eyacuiñajji peaꞌai. Ohua bihuia cajje Jesosaa o shajjaꞌajjajji cuana jama aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—¡Shajjaꞌajjacue jiquio esohui! ¡Aꞌa pajeaꞌyojji! Quijje dejja cuaa eya iña caje emano meeꞌyojji —jamaya cua Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","O shajjaꞌajjajji cuanaja ca quea quehua cua Jesosaja esohui. Eyacuiñajjiya quea quehua po mee caꞌya cua. Jamatii oya cuana quea mete cua ehuohuiꞌajjajji. ");
INSERT INTO eseNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesosa shajjaꞌajjajji cuana jjaniñebaqui ania cua. Jama cua baꞌa: —¿Ache oja eshajjaꞌajjajji acuae eyajo quea bame nee nee nequije soꞌo? Eya nei emeshi mese cuaje eyajo, pojjaꞌa, miya pojjeama. Pea aje oe jama cua baꞌa: —Chojja, eya, de. ");
INSERT INTO eseNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesosaa jama tecueame aca cua baꞌa: —Miquianaya jjashahuaba taiquiani. ¡Shajjaꞌajjacue oe! ");
INSERT INTO eseNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","¡Bacue jiquio eshoꞌi cuana, emeshi mese po sa po ajja! ¡Aꞌa emeshi mese po sa pojji! ¡Jamaya miquianaya pocue eshoꞌi jayojjaya! ¡Jjapeequicue jiquio ecua eshoꞌi cuana jayojja oe pocue, dejja quea bame nee nee epojji! Miquianaya ecuea epeejji nijje jjapeequi majje miya ecuea epeejji cuani, Eyacuiñajjija epeejji peaꞌai. Jamajjeya miquianaya eshoꞌi quea bame jayojja cuani, majoya miquianaya quea bame nee nee nequijeꞌyo eyajo —Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Majoya Huaniya Jesosa jama aca cua baꞌa: —Esohui huohuijji, ecuaa banaje oe dejja; ohuaya pea cuanaja eshahua cuana cuaya meequi caꞌyonaje miyaya jayojjaya. Miquea epeejji cuani pojjaꞌa, oya ca ca cue ajja tii ecuana nijje. Jamajjeya ecuaa oya jama huohuinaje baꞌa: “¡Aꞌa cuayaqui meeꞌyojji eshahua; miya ecuana nijje poqui ajja!” ");
INSERT INTO eseNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesosa jama cua baꞌa: —Cho, ¡aꞌa jama pojji! Oya ecuea epeejji nei cuani. Oya Edosiquianaja epeejji pojjeama cuani, jamajjeya oya ecuea epeejji cuani. Eꞌe, ma dejja quea bame cuani, oya quea tai pojjeama. Jamajjeya oya ecuanajaya epeejji cuani peaꞌai —jamaya cua Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Beshahua nei acua cua Jesosa emanoꞌyojji, eyahuasijje epoquiꞌyojji peaꞌai Eyacuiñajjija esohui jayojja yajji. Jamajjeya jjashahuabaqui majje oya poquia cua Jenosanena huasijje o shajjaꞌajjajji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Poquijeya Jesosaa beca o shajjaꞌajjajji cuana huoojea ca cua Samania meshi yasijje ecahuijji saꞌajjaa. ");
INSERT INTO eseNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jomajo Samania dejja jama cua baꞌa: —Chojja, ¡aꞌa miquianaya jiquiacua cuejji! Cajaa, miquianaya Jodio dejja jojoya, ecuanaja ca mi ca botiꞌama Jodio dejja cuana Jenosanena huasijje poqui majamajajjijojo Eyacuiñajji bihuiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Majoya ma esohui shajjaꞌajja majje Satiaco, Huani peaꞌai poquia cua Jesosa que huohui pohua. Oya cuana jama cua baꞌa: —Jesosa, Emeshi Mese nei, ecuaaya cuaqui oque mee sa aña ma esohui quea tai miminaje yasijje. ¿Aꞌa acuae quea bame jama epojji soꞌo, Jesosa? ");
INSERT INTO eseNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesosaa jama tecueame aca cua baꞌa: —Chojja, ¡aꞌa miquianaya jama jjashahuabaquime pojji! ");
INSERT INTO eseNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Majoya aje poquia cua pea cuiñajji yasijje cahuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ejiojjijje poquijeya, dejjaa Jesosa jama huohuime aca cua baꞌa: —Jesosa, Emeshi Mese nei, eya minijje jjapeequi sa cuani. Jamajjeya eya minijje eꞌe jojo nei poꞌayequi sa cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Majoya aje Jesosa jama cua baꞌa: —Eꞌe pojjaꞌa de, quea camaja cuaje. Eya ojjañaja Edoe Mese cuani. Jamatii ecuea equi chamaꞌ ejomishocajji. Samao ca ca jjanijo cahuijaa, cuichojji cuana ejajo cahuiani. Eya ca ca iña quimaꞌ ecahuijji. Jamatii beca cuanaja equi quea nahue cuani e botiꞌamajojo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pea pojjajo pea dejja Jesosaa jama huohuime aca cua baꞌa: —¡Jjeyahua nei enijje cuecue ecuea epeejji epojji! Ma dejja jama cua baꞌa: —Emeshi Mese, quijje pishana poquije minijje. Jjeya ecue chii etii nojinoji, manojeꞌyo pojjaꞌa. Eyaya camojea sahua manoꞌyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesosa jama cua baꞌa: —Chojja, pea cuaa Eyacuiñajjija epeejji pojjeama cuaa oe cacuiña cahua. Ohuaya cuaa camojea cahua manoꞌyajo. ¡Cuecue jjeyahua nei; enijje ejjahuohuiquiqui Eyacuiñajjija esohui pea cuana huasijje! ");
INSERT INTO eseNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pea dejjaa Jesosa jama huohuime aca cua baꞌa: —Emeshi Mese, eya poꞌayequi sa cuani minijje. Ebionei oe ecuea huapa pojjeama cuana cahuohuiquiꞌyo sahua jama baꞌa: “Poquia iña Jesosa nijje”. ");
INSERT INTO eseNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesosa jama cua baꞌa: —Chojja, ¡jjeya nei cuecue enijje! ¡Miya enijje jjapeequi sa cuanijo cuecue jjeyahua nei enijje! Miya cue sa po ajjajje miya bameꞌama cuaje Eyacuiñajjija epeejji epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Majoya Jesosaa dejja quea huiso jjequi tepe ca cua, 72 huisome. Ohuaya becanejjijji peaꞌai huoojea ca cua ojjaña meshi cuana huasijje joya o poqui sa cuani yasijjeya. ");
INSERT INTO eseNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ohuaya jama huohuime aca cua baꞌa: —Dejja cuana anoso quejo jahua jayojja jama, quea huiso nee nee. Ojjaña cuana ecuea esohui shajjaꞌajja sa cuani, oe pojji ca ca Eyacuiñajjija esohui huohuijji yani. Jamajjeya ¡mimicue Eyacuiñajji nijje quea huiso esohui huohuijji epojji, quea huiso anoso sejjaꞌyojji cuana jayojja epojji! ");
INSERT INTO eseNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Poquicue miquianaya ma dejja cuana quea mimishi nee nee nequi yasijje esohui huohuiya! Ma dejja cuanaya pojjaꞌa mimijajije minijje; baꞌajja. ");
INSERT INTO eseNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","¡Aꞌa bashosoco dojojji; bejjo, ejiojji shejee peaꞌai aꞌa dojojji! ¡Aꞌa pea nijje mimipoquijji; quea cueiji pashi nee oe poquicue! Quea huiso Eyaciñajjija esohui shajjaꞌajja sa cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Equi yasijje dobiqui majje jja ca oe equi mese huohuicue jama baꞌa: “Eyacuiñajjiya miya quea bei po mee caje”. ");
INSERT INTO eseNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma equi mese quea bei po sa cuanijo, Eyacuiñajjiya oya quea bei po mee caje. Pea equi meseya miya cajaa acanijo, Eyacuiñajjiya oya quea bei pojjeama acaje. ");
INSERT INTO eseNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","¡Miquianaja epeejji epojji saꞌajjacue; ojaya equijo tiiya anicue! ¡Ojaya bobi ijjia anicue ma cuiñajjijo ani majje! Equi meseya miya cabobia cahua Eyacuiñajjija esohui huohuiaña sosejje, ojaya echacojji jayojja cuani jojoya. ");
INSERT INTO eseNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pea cuiñajji yasijje poquiajo dejja cuaa miquianajaya esohui shajjaꞌajja sa cuanijo ohuaya miya bobia caje. ¡Jamajjeya ijjiaꞌijjiacue onijje! ");
INSERT INTO eseNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","¡Jjaajaqui meeꞌyocue emanojaa cuana! ¡Huohuicue oe oya Eyacuiñajjija esohui jama baꞌa: “Jjeya nei Eyacuiñajjiya miya oja epeejji po mee sa acani” acue! ");
INSERT INTO eseNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pea cuiñajji yasijje poquiajo dejja cuana ca ca miquea esohui shajjaꞌajja sa po ajja pojjaꞌa cuaje. ¡Ma dejjaya jja oe jama huohuime acue baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Miquianaaya cajaa aña Eyacuiñajjija esohui, jamajjeya ecuanaya pea dejja cuana huasijje poquije esohui huohuiya miquianaya shajjamaꞌ jojoya. Ecuana quea yeno cuani miquianaaya Eyacuiñajjija esohui cajaa anaje jojoya. Eꞌe de, ohuaya miquianaya huoojea cajeꞌyo cuaqui yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yahuajo Eyacuiñajjiya Sonoma cuiñajjijo baꞌe cuana aca cua jayojjaya miquianaya acajeꞌyo, quea nee nee po mee cajeꞌyo” jama huohuimeya acue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Majoya aje Jesosa tecuetecuea cua dejja shajjamaꞌ cuana nijje. Jama huohuime aca cua baꞌa: —Coya nequianaya quiyoꞌyo chanaꞌ, Conasijo baꞌe cuana, Betesainajo baꞌe cuana peaꞌai. Miquianaaya eya banaje, ecuea esohui shajjaꞌajjanaje peaꞌai. Jamatii miquianaya ca mi ca oe shajjamaꞌ nei nei cuani, de. Yahuajo Eyacuiñajjiya Tinojo baꞌe cuana Sinonojo baꞌe cuana peaꞌai quiyojea mee caꞌya cua quea mimishi nee neejojo. Ojaya cuanaja ca ca eya shahuaba jjima nei nei cua, de. Ohuaya eya eshahuaba jojjemo ecuea esohui eshajjaꞌajja jojjemo quea yeno nee nee poquiꞌaye ojaya mimishijo. Conasijo baꞌeja ca jjaja ca iña oe eshahuaba cuanaje, jamatii jjejojoya ca nequiana ca oe shajjamaꞌ nei nei cuanaje ecuea esohuijo, de. Betesainajo baꞌe jayojja ca mi ca oe cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jamajjeya Eyacuiñajjiya miquianaya huoojea cajeꞌyo cuaqui yasijje, quea nee nee nee cuajeꞌyo miquianaya. ");
INSERT INTO eseNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capenaomajo baꞌe cuana, miquianaya shajjamaꞌ neiya cuani peaꞌai. Jamajjeya aje jja miquianaya quiyojea peaꞌaijeꞌyoya. Miquianaya jama jjashahuabaquiani baꞌa: “Ecuana ca ca eyahuasijje poquijeꞌyo”. Cho, miquianaya poquije cuaqui yasijje ecue sohuijo shajjamaꞌ cuanijojo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Majoya aje Jesosaa o shajjaꞌajjajji cuana jama huohuime aca cua baꞌa: —Eꞌe de, miquianaya ecuea esohui huohuijji cuani. Miquianaaya ecuea esohui nei huohuiaña. Jamajjeya dejja cuaa miquianajaya esohui shajjaꞌajja canijo ecuea epeejji cuaje. Pea dejja cuana ca ca oe shajjaꞌajja sa po ajjajo ecuea epeejji pojjeama cuaje, Eyacuiñajjija epeejji pojjeama peaꞌai cuaje. Eꞌe de, mahuiso ecuea esohui —jamaya aca cua Jesosaa. Majoya aje ma dejja cuana iye huiso huoojea ca cua esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Majoya ma dejja cuana 72 huisome esohui huohui majje Jesosa que cue oꞌoya cua; quea bihui nee cua. Oya cuana jama cua baꞌa: —Jesosa, ecuea Emeshi Mese nei, ecuanaya quea sohui poja nee cuanaje; mi jayojja cuanaje. Ecuaaya miquea bajjanijo eshahua huoojeacuayaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesosa jama cua baꞌa: —Eꞌe de, ecuea eba. Eyaya Edosiquiana banaje oquequinaje eyajo nequi pojjejje jayojja, de. ");
INSERT INTO eseNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Eyaya miquianaya quea caꞌa po meenaje epoquijji. Peyohua, ajiya peaꞌai ijjia cajje miquianaya manoꞌyo jjima po meejeꞌyo eyaya. Edosiquiana miya quecua jjima ameejeꞌyo eyaya. ");
INSERT INTO eseNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Miquiaaya eshahua cuayaqui meeꞌyaña. ¡Aꞌa quea bihui nee pojji miquianaya quea sohui poja nee cuani! ¡Miquianaya ca oe quea bihui pocue miquianajaya bajjani tehue canaje Eyacuiñajjiya eyajo edobiqui meejji! Miquianaya poquije eyahuasijje Eyacuiñajji nijje baꞌeꞌyohua. ¡Jamajjeya ma esohuijoya quea bihui pocue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Majoya aje Edojjoshahua Bameya Jesosa quea bihui po mee ca cua. Jesosaa Eyacuiñajji jama huohuime aca cua baꞌa: —De, eya quea bihui nee cuani minijje. Eyacuiñajji, miya ecue Chii nei, miya Emeshi Mese nei cuani, ojjaña meshi cuanajo eyajo peaꞌai, de. Eꞌe, beca cuana jjashahuaba taiquiani jama baꞌa: “Ecuea quea jaꞌa nee esohui, jamajjeya eya Eyacuiñajjija esohui shajjaꞌajja sa po ajja”. Miyaya, Eyacuiñajjiya, oya cuana ba meesahua ajja oya cuana jjashahuaba taiquianijojo. Pea cuana ca ca miquea esohuijo eshoꞌiquiana jayojja jjabahuejjaqui sa cuani. Jamajjeya miyaya oya cuana quea jaꞌa po meejeꞌyo. Eꞌe ecue Chii, miyaya jamaya aña miquea ejjashahuabaquijji jama —Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Majoya Jesosaa pea cuana jama huohuime aca cua baꞌa: —Eyacuiñajji ecue Chii e huoojeaꞌyojji epo. Eya ojaya esohui huohuijji cuani. Ecue Chiija eyajo anija ecuea ejjashahuabaquijji ojaya eba nei nei, ojaye nei. Ecue Chiija ejjashahuabaquijji ecuea eba nei nei peaꞌai, ecuea nei. Eyaya ecuea epeejji ba meesahuaña quea jaꞌa nee ecue Chiija ejjashahuabaquijji —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Majoya aje o shajjaꞌajjajji cuana Jesosaa jama huohuime aca cua baꞌa: —¡Quea bihui pocue, miquianaaya Eyacuiñajjija ejjashahuabaquiꞌyojji bañajo! ");
INSERT INTO eseNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eꞌe jojo nei eyaya miquianaya huohuiaña jama baꞌa: Yahuajo quea huiso Eyacuiñajjija esohui huohuijji cuana, emeshi mese cuana peaꞌai Eyacuiñajjija ejjashahuabaquiꞌyojji ba nei nei sa cua. Ecuea esohui shajjaꞌajja nei nei sa cua peaꞌai. Jamatii onajaya eya ba jjima cua, shajjaꞌajja jjima cua ecuea esohui. Eꞌe, oya cuana shajjaꞌajja sa cua jiquio miquianaaya jjeya shajjaꞌajjaña —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oe Jodio dejja Moisesija etehueꞌyo huohuijji poquia cua Jesosa dasiaa nisho. Huohuiꞌajja ca cua jama baꞌa: —Jesosa, miya esohui huohuijji cuani, ¿yajja acuae po cajji Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesosa jama cua baꞌa: —¿Aꞌya acuae Moisesiya tehue ca cua? ¿Aꞌa pojjaꞌa miquea ma esohui ba jjima? ");
INSERT INTO eseNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—De, ecuea eba, eya Moisesija etehueꞌyo huohuijji nei nei cuani. Ojaya esohui jama cuani baꞌa: “¡Miyaya Eyacuiañajji quea jea nee nee acue! ¡Ojo nei oe jjashahuabaquicue; oya oe bihuiacue ojjaña pojjajo!” Pea etehueꞌyo jamaya cua baꞌa: “Eseya jjajaahuanaquiani. ¡Jama jaahuanameya oe acue mique doe cuana!” jama cua Moisesija etehueꞌyo yahuajo —jamaya cua ma esohui huohuijji. ");
INSERT INTO eseNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesosa jama cua baꞌa: —Eꞌe de, quea bame nee miquea esohui. ¡Ma esohui jayojjaya oe miyaya acue! Majoya aje miya Eyacuiñajji nijje eyajo baꞌe tiitiijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma esohui huohuijji Eyacuiñajji nijje, pea cuana nijje peaꞌai quea bihui nisho cua. Ojaya pea cuana botiꞌama cua. Jamajjeya ohuaya Jesosa edasiaꞌyojji nisho jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌya acuae ecue doe cuana? —ojaya ba jjima nisho cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jamajjeya Jesosaa esohui jama huohuime aca cua baꞌa: —Oe Jodio dejja baꞌenaje Jenosanenajo, poquinaje ejiojjijje Jenico huasijje. Ejiojjijje poquianijo siipojji cuana nequinaje ejiojjijo sii epojji. Siipojji cuaa dejja eshemaꞌ nei cuiahuejjajeame acanaje eꞌaquiana jjesheꞌyojji. Ojaya daqui sii caꞌyonaje, de. Siipojji cuaa ma dejja jea canaꞌyonaje, beshahua nei emanoꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Majoya oe Jodio dejjaa, Eyacuiñajji nijje mimiani dejjaa ma dejja ecuiajeajaajje yejje canananaje. Bajea canananajeya aje jja ca oe. Jjequi sohuasohuaꞌyo ajja jjaja cua. Poquia jjaja oe cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Quijje pea Jodio dejjaa yejje canananaje bajea canajeya aje jja ca oe peaꞌai. Oya Eyacuiñajjija equi jaahuanajji cua. Jjequi sohuasohuaꞌyo ajja jjaja cuanaje. Poquia jjaja oe cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Quijje aje jjaja oe Samania dejja cueyanaje. Samania cuanaja Jodio cuana botiꞌama. Jamatii jiquio Samania dejjaa Jodio dejja ecuiajeajaa ba canaje. ");
INSERT INTO eseNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ohuaya ba majje shicui canaje. Majoya aje iyasohua caꞌyonaje mona biajje, dojo canaje ejaachichajji equi yasijje. Majoya aje jaahuana canaje sosemaꞌ tii. ");
INSERT INTO eseNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pea cahuijo Samania dejjaa bejjo quia canaje equi mese yasijje, o cahuinaje sosejje. Jama huohuime aca cua baꞌa: “Eya poquije chacohua. Ma ecuiajeajaa dejja ca anije, ¡miyaya oya jaahuanacue! Maꞌaje bejjo o jaahuana sosejje. Quijje eya cueje oꞌoya mi sosequia oꞌoyaa” jamaya cuanaje Samania dejja —Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Majoya Jesosaa Moisesija etehueꞌyo huohuijji jama huohuime aca cua baꞌa: —Pea beca peejjima dejjaa ecuiajeajaa dejja ba canananaje. ¿Ache dejja acuae oja doe jayojja cuanaje? ");
INSERT INTO eseNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Ma o jjequisohuaꞌyojji cuanaje, Samania dejja ojaya doe jayojja cuanaje —jamaya oya cua. —Eꞌe de, eꞌe jojo nei. ¡Miyaya jamaya acue, pea cuana jama jaahuana meeya acue, mique doe jayojja acue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesosa o shajjaꞌajjajji cuana nijje Jenosanena huasijje poquije Mantaja equi yasijje dobiquinana cua ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mantaja shehue, Mania Jesosaja esohui shajjaꞌajja sa cua. Jamajjeya Jesosa chipi nei ania cua oja esohui shajjaꞌajja neineijji. ");
INSERT INTO eseNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mantaja cuacuacuacuaquija jjejojo Jesosaja esohui shajjaꞌajja jjima cua. Oya quea quene cua oja shehue nijje. Mantaa Jesosa jama huohuime aca cua baꞌa: —Jesosa, eya ecue shehueja cuacuasahua jjima. ¡Huoojeacue oya e cuacuasahuaa! ");
INSERT INTO eseNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesosa ca oe jama cua baꞌa: —Chojja, Manta, miquea ecuacuajjijo ca ca miña jjashahuabaquiani. Jamajjeya miya ecue esohuijo jjashahuabaqui jjima cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mania ca ca oe quea bame cuani, ohuaya ecuea esohui shajjaꞌajja neinei cani. ¡Mique shehue jayojja jama pocue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesosa pea pojjajo mimia cua Eyacuiñajji nijje. Majoya aje cojjacahuijeyo majje o shajjaꞌajjajjiya Jesosa jama huohuiꞌajjame aca cua baꞌa: —Emeshi Mese nei, ¡huohuicue iña miyaya achajja mimime acuae po cajji soꞌo! Yahuajo Huaniya ona besameejji cuanajeya o shajjaꞌajjajji cuana huohui ca cua achajja mimime epojji Eyacuiñajji nijje. ¡Jamaya huohuicue ecuanaya! ");
INSERT INTO eseNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Majoya aje Jesosaa jama aca cua baꞌa: —Jama mimimeya oe pocue Eyacuiñajji nijje baꞌa: Eyacuiñajji, miya ecue Chii nei nei. Miya oe nei nei ani, pea mi jayojja chamaꞌ. Ecuea eba nei nei miya mimishiꞌama nei nei. Miya ojjaña cuanaja Emeshi Mese nei cuani; ojjaña jaahuanajji cuani. Jamajjeya ojjaña cajjapeequiahua minijje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","¡Quiacue mo ecuea bobi ebaꞌejji! ");
INSERT INTO eseNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","¡Ecuanajaya mimishi cuana cuijeaꞌyocue! Eya queneꞌama pea cuana nijje; joya enijje quea mimishi cuani nijje. Jamajjeya ecuea mimishi cuanajo ¡aꞌa quene pojji peaꞌai! ¡Aꞌa ecuana quea mimishi po meejji! Acua. ¡Jamaya mimicue Eyacuiñajji nijje! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Majoya Jesosaa o shajjaꞌajjajji cuana pea esohui ejjashahuabaqui meejji jama huohuime aca cua baꞌa: —Miquianaya pojjaꞌa mee nei poquije miquea epeejjija equi yasijje mecashono nei. Miyaya huohuiñaquije jama baꞌa: “Jjeya nei ecuea epeejji cueꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Chamaꞌ bobi ecuea equijo, oya ca ca quea shoe, de. ¡Che mo bobi quiacue ecuea epeejji nijje ebobiajji!” jamaya cuaje miya pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Majoya oya jamaya cuaje baꞌa: “Chojja, de. Equiajji pojjeama mi, cahuijaa soꞌo ca ca iña, de. Caꞌaꞌyonaje oya aña ecuea esecuejjani ca mi quiajji”. ");
INSERT INTO eseNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Miyaya huohuiꞌajja majamajajje ca mi ca oe quia caje. Ojaya epeejjijojo pojjeama ca mi ca oe quia cani miya mi cahuime yajje —jamaya Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eꞌe de, eyaya huohuinaje maya esohui miquea ebajji achajja mimime Eyacuiñajji nijje epojji. ¡Miquianaaya huohui majamajacue esecuejo nequia jayojjaa! Majoya Eyacuiñajjiya miquianaya quia caje. ¡Aꞌa Eyacuiñajji nijje mimi pajeaꞌyojji ohuaya miya sajaꞌa cajeꞌyo! ");
INSERT INTO eseNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Eꞌe, ojjaña cuaa Eyacuiñajji huohuiꞌajja canijo, Eyacuiñajjiya oya cuana quia cajeꞌyo. Jamaya ma esohui epeejjijo, de. Oya poquinaje bobi saꞌajjaa, huohuiꞌajja majamaja canequinaje. Majoya aje bobi quia canaje. Jamaya aje Eyacuiñajjiya acaje miquianaa huohuiꞌajja majamajajje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Miquianaja bacuaa nahuoojo huohuiꞌajja cajje, ¿ae quiaje? Peyo pojjaꞌa. Chojja, miquianajaya equiajji pojjeama peyo, de. ");
INSERT INTO eseNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Miquianaja bacuaa cachinajjajo huohuiꞌajja cajje, ¿ae quiaje? Aji pojjaꞌa. Chojja, miquianajaya equiajji pojjeama, de. ");
INSERT INTO eseNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Miquianaya quea mimishi baꞌyani. Jamatii miquianaja bacua nijje quea bame cuani, Eyacuiñajji ca ca mimishiꞌama nei nei cuani. Ohuaya quea bame nee nee quia cani miquiaa huohuiꞌajjajje. Ohuaya miquiana huasijje Edojjoshahua Bame nei huoojea caje miquiaa huohuiꞌajjajje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Oe dejja mimiꞌajja nequia cua eshahua oja yamijo nequi jojo. Oya poquia cua Jesosa que. Jesosaa eshahua cuayaqui mee caꞌya cua. Ma dejja eshahua cuayaquiꞌyajo mimicooꞌya cua, de. Majoya aje ojjaña cuana jama cua baꞌa: —De, Jesosa quea sohui poja nee nee yaña. ");
INSERT INTO eseNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pea dejja cuanaya jama siajje pomeya cua baꞌa: —Edosiquiana etii nijjeya jjejojo, Jesosaa eshahua cuaya meequi caꞌyonaje, Edosiquiana etii Meesemo nijjeya. ");
INSERT INTO eseNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pea cuana jjashahuaba taiquia cua Jesosaja epeejji nisho epojji. Jesosa jama aca cuaa cua baꞌa: —Ecuanaa ajjima aña Eyacuiñajjiya miya ca ca ameesahua caje pojjaꞌa. ¡Jamajjeya ameeꞌajja socue oe! Majoya jama miya ajo, ecuanaa baje eꞌe jojo nei Eyacuiñajjiya miya huoojea canaje ecuana huasijje. Majoya aje oe ecuanaya jjapeequije minijje —jamaya cuana cua Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama posojo. ");
INSERT INTO eseNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesosaja eba onajaya ejjashahuaba taiquijji. Jamajoya aje Jesosaa jama tecueame oya cuana aca cua baꞌa: —¡Jjashajjaꞌajjaquicue oe! Joya emeshi mese ojo chacochacoani cuaa shajjaꞌajja sa po ajjajo, ojee jjaquecuaqui majje jjaquecua iyaiyaquijeꞌyo dejja cuana ma meshijo baꞌe; chamaꞌyo tii cuajeꞌyo. Huapa pojjeama cuana nijje jjacuiaquiajo chamaꞌ epeejji cuana cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jamaya peaꞌai Edosiquiana etiiya Satanasaa pea eshahua ehuoojeacuayaꞌyo jojjemo, dejja huoojeaꞌyojji pojjeama poꞌyoquiaye. Chojja, jama pojjeama ca coma. ");
INSERT INTO eseNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Aꞌaya eyaya Edosiquiana nijjeya niñe cuana, pea eshahua cuana peaꞌai huoojeacuayajeaña poso aña? Jamajjeya miquea epeejji cuanaa ¿ae nijje eshahua huoojeacuayajea cani? Eyacuiñajjiya asahua canijo, jamajjeya ojaya eba miquianaya ejo siajje cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eꞌe, Eyacuiñajji nijjeya eyaya eshahua huoojeacuayajea yaña. ¡Jamajjeya bacue eya eꞌe jojo nei Eyacuiñajji, Emeshi Mese oe nei jjeya cuani tii! ");
INSERT INTO eseNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","¡Bacue! ¿Aꞌa dejja quea caꞌa neeja equi yasijje dobiquijji oja aquiana siiya o jeyo jjima nequijo? Chojja, o jeyo majje ojaya aquiana cuana sii caje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jiquio ecua eꞌaquiana mese ebionei jeyo cani jama amajje eyaya eshahua cuana jeacuayajeaña. ");
INSERT INTO eseNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Miquianaya shajjaꞌajja sa po ajja ecuea esohui, jamajjeya ecuea epeejji nei pojjeama miquianaya cuani. Miquianaaya ecuea esohui pea cuana huasijje huohui sa po ajjajo, jamajjeya miquianaaya pea cuana quea mimishi po mee sa aña, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesosaa esohui ejjashahuabaqui meejji huohui ca cua jama baꞌa: —Eshahua dejjaja yamijo nequi cuayajeaquiꞌyo majje quea huesha poquinaje. Saꞌajja caꞌyonaje pea enequiꞌyojji. Jamatii baꞌyo jjima cuanaje. Eshahua poꞌayequiequinaje o nequijji saꞌajjaꞌyohua. Jamajjeya oya jjashahuabaquinaje jama baꞌa: “Eya poquije oꞌoya huacuaya ma e cuayaquinaje yasijjeya, ma ecuea equi jayojja huasijjeya”. ");
INSERT INTO eseNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jamajjeya oya dejja huasijjeya cue oꞌoyanaje. Ojaya yami yasijje dobiquiꞌyonaje Eyacuiñajjija epeejji pojjeama jojoya, ojaya eyami equi ecuiashaba jayojja jama, ehuana bamebame jayojja equi se ejjamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jamajjeya ma eshahua poquinaje pea eshahua cuana jjequiya onijje enequiꞌyojji ma dejjaja yamijo. Oya cuana quea mase nee nee cuanaje. Oe nei yahua ca ca quea mase pishana cuanaje. Majoya aje ojjaña dobiquiajo ma dejja quea yeno nee nee cuanaje. Yahuajo oe eshahua nequiahuajo ca ca quea yeno pishana cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesosa mimianijo oe epona ojjaña yiyesama neijo nequi sohuicuaya cua jama baꞌa: —Jesosa, Eyacuiñajjiya miquea enaese quea bihui capo mee caꞌyahua, ohuaya miya cuayajo tii mee canajejo. ");
INSERT INTO eseNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Majoya aje Jesosa jama cua baꞌa: —Eꞌe, quea bame pishana. Eyacuiñajjija esohui shajjaꞌajja nei nei majje ca ca oe quea bihui nee nee capoꞌyahua. Joya Eyacuiñajji nijje jjapeequi neinei majje quea bihui nee nee capoꞌyahua. ¡Jamaya pocue quea bihui nee nee epojji! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Quea dejja huiso nee nee ejjachichaqui nequia cua Jesosa nijje. Majoya Jesosaa esohui jama huohuime aca cua baꞌa: —Miquiaaya Eyacuiñajjija esohui cajaa anaje. Jamatii miquianaya ba oꞌoya sa cuani eyaya yahuajo anaje jayojja. Ecuea jamaya eꞌabecaꞌyojji pojjeama miquea ebajji eya Eyacuiñajjija huoojeaꞌyo. ¡Jjashahuabaquicue yahuajo nei Eyacuiñajjiya Jjona jaahuana ca cua jai aiꞌaija sei aijo baꞌe! ");
INSERT INTO eseNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jjona emanoꞌyo jayojja cua. Majoya shequi oꞌoyanaje jayojja cua pea beca peejjima cahuime po majje jaiya ojjajea caꞌya cua. Majoya dejja cuana Ninebe cuiñajjijo baꞌe yasijje poquia cua. Oya jjashahuabaquiꞌyo aña cua Jjona eshequi oꞌoya jayojjajo. Jjashahuaba bame nequia cua eꞌe jojo nei Eyacuiñajjiya Jjona huoojea ca cua oja esohui huohuiya. Eya Jjona jayojjaya cuaje, eya manoꞌyo majje mei jjanijo jaa shequije oꞌoya pea beca peejjima cahuime po majje, miquiana jjashahuabaquijji Eyacuiñajjiya eya huoojea canaje miquiana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Eꞌe, yahuajo Ninebejo baꞌe cuaa Jjonaja esohui shajjaꞌajja majje mimishi pajea caꞌya cua. Jjapeequia cua Eyacuiñajji nijje. Jjonaa esohui quea bame huohui ca cua. Jjeya eyaya miquianaya huohui bamebame yaña, de. Jamatii miquianaya ecuea esohui shajjaꞌajja sa po ajja. Jamajjeya Eyacuiñajjiya miquianaya jeajea cajeꞌyo cuaqui yasijje shajjamaꞌ jojoya. —Eꞌe, jamaya yahuajo cua baꞌa: Eeno cuejjijje emeshi mese pona cua. Oya quea huesha nee nee cueya cua Sanomoja esohui shajjaꞌajjaa. Sanomo quea jjashahuabaqui jaꞌa pishana cua. Eya ca iña quea jjashahuabaqui jaꞌa nee nee cuani. Jamatii miquianaya ecuea esohui shajjaꞌajja sa poꞌyo ajja. ¿Yajjajo acuae miquianaya ma epona jayojja mi poꞌajjani soꞌo? Jamajjeya Eyacuiñajjiya miquianaya jeajea cajeꞌyo cuaqui yasijje shajjamaꞌ jojoya, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesosa jama cua baꞌa: —¿Aꞌa miquianaya cuaquijiji dedo majje capanequiaña eshajaa? Chojja. ¿Aꞌa miquianaya enequia quehua nequiya jeajaꞌa came? Chojja. Eꞌe, eyajo nequiya jeajaꞌa cani. ");
INSERT INTO eseNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miquianajaya ecojja cuaquijiji jama, de. Miquianajaya ecojja quea jaꞌa cuanijo miquianaya poqui bameje. Miquianajaya ecojja jaꞌaꞌama cuanijo epoqui bamejji pojjeama. Jamaya miquianajaya ejjashahuabaquijjiya quea jaꞌa cuanijo, baꞌe bameje. Miquianaya jjashahuaba taiquianijo, miquianaya cuaquijiji enequia quehua jayojja cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","¡Jamajjeya ma cuaquijiji eyajo nequiasohua nequi jayojja jama jjashahuaba bamebamequimeya oe pocue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesosa mimipajeaꞌyajo oe Paniseo dejjaa Jesosa iyaa ca cua ijjiaꞌijjiaa ojaya equi yasijje. Jesosa dobiqui majje eꞌanijjijo anioquea cua. Oya jjametopo neineiqui jjima cua, Jodio etiiquiaa acani jayojja ajjima aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jamajjeya Paniseo dejjaa Jesosa ba majje jjashahuaba taiquia cua jama baꞌa: —Eꞌe de, Jesosa quea tai cuani, eme topo neinei ajja, etiiquiaa jayojja jama ajjima acani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesosaja eba onajaya ejjashahuabaquijji; jamajjeya jama tecueame aca cua baꞌa: —De, miquianaya, Paniseo dejja cuana jamatii esohui huohuijji nisho cuani, quea tai, de. Miquianaya joya caneco yiye topo jjimajo jayojja cuani. Jamaya miquianaaya dejja cuana jjashahuabaqui meeaña, miquianaya Eyacuiñajjija epeejji cuani poso acani dejja cuaa. Miquianaya ca mi ca ojaya epeejji pojjeama, ojaya miquianaya eba, de. Ojjañaa miquianaya quea bame cuani poso acani. Miquianaya ca ca quea tai nee nee cuani; jjashahuaba quehuaquiani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","41","Miquianaya Eyacuiñajjijo jjashahuaba nishoquiani, ojaya epeejji nisho cuani. Jamajjeya beca cuaa miquianaya quea bame baꞌe poso acani. Eyacuiñajjiya miquianaya quea bame nee jjashahuabaqui mee sa acani. Jamajjeya jja oe ¡onijje jjapeequicue eꞌe jojo nei epojji! Majoya aje miquianaya quea bame cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Eꞌe de, miquianaya Paniseo dejja cuana jjashahuaba taiquiani, de. ¡Aꞌa quea dejja tai pojji! Shajjaꞌajjaña ajeya ca oe Eyacuiñajjija esohui, ojjaña ojaya esohui aje jje oe shajjaꞌajja jjima cuani, eꞌe nei. ¡Miquianaaya ojjaña Eyacuiñajjija esohui shajjaꞌajja jeyojeyocue! ¡Huapa pojjeama cuana quea jea acue, Eyacuiñajjiya ojjaña cuana quea jea acani jayojja oe acue! Eꞌe de, ¡aꞌa pajeaꞌyojji quea jea ajji! Jamajjeya miquianaya quea bame cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Eꞌe de, miquianaya ca jja ca oe quea tai cuani, Paniseo dejja cuana. Jamatii miquianajaya equi ejjachichaquijjijo eꞌanijji quea bame saꞌajjaña. Pea nijjeya aje jja mi ca oe quea bame jayojjaya cuani, majoya aje jja mi oe pea cuaa quea bame poso acani. Miquianaya ca jja mi ca siajjepojji, de. Eꞌe, ejiojjijje peaꞌai miquianaya poꞌayequiequijo dejja cuanaja esohui shajjaꞌajja sa cuani jama baꞌa: “Paniseo dejja cuana ca jja ca quea bame nee nee, de”. Ma esohui ca jja ca eꞌe jojo nei pojjeama acani. ");
INSERT INTO eseNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Eꞌe miquianaya quea tai po majamajani. Miquianaya dejja equehua mojeaꞌyojaa jayojja, ma onajaya ba jjimajojo quishi cani jayojjaya cuani. Pea cuana jjashahuabaquiani ma meshi joya quea bame poso acani. Jamaya miquiana ma emojeaꞌyojaa jama cuani. Pea cuana jjashahuabaquiani miquiana quea bame, onajaya miquianaya ba jjima quea tai nee nee cuani. Miquianaya jjashahuabatai tiitiiquiani; quea bame pojjeama cuani —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oe Moisesija etehueꞌyo huohuijji cuani jama cua baꞌa: —Jesosa, miya pojjaꞌa ecuana nijjeya peaꞌai tecuetecueani. ");
INSERT INTO eseNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesosaa oya jama huohuime aca cua baꞌa: —Eꞌe jojo nei eyaya miquianaya tecueaña. Miquianaya Moisesija etehueꞌyo huohuijji nisho cuani peaꞌai, de. Miquiaaya pea cuana huasijje esohui quea camaja huohui nishoaña. Jamatii miquianaya ma esohui jayojja baꞌe ajja; ona asahua ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","—Eꞌe, miquianaya quea tai nee nee cuani, miquianaja etiiquiana jayojja, de. Miquianaja etiiquiaa Eyacuiñajjija esohui huohuijji quecua caꞌya cua jjashajjaꞌajjaqui ajjaa jjejojo. Jamatii miquianaaya cuiaꞌasha poquia tiitiiaña etiiquiaa quecua caꞌya cua shahuaba poquia tiitiijji, equecuaꞌyo sajaa quea pame epojji epajeaꞌyo cuani jjejojo. Jamajjeya miquianajaya etiiquiana jayojja jama jjashahuabaquime cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Eꞌe, Eyacuiñajjija eba, jamajjeya ohuaya jama huohuime aca cua yahuajo baꞌa: “Eyaya ecuea esohui huohuijji cuana, e shajjaꞌajjajji cuana huoojeaje pea cuana huasijje. Ecuea ehuoojeaꞌyo cuana beca cuaa quecua cajeꞌyo nei nei. Beca ca mimi panajajije onijje” jamaya Eyacuiñajji cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Eꞌe, miquianajaya etiiquiana huasijje huoojea ca cua Eyacuiñajjija huoojeaꞌyo cuana. Eꞌe, yahuajo miquianajaya etiiquiaa quecua caꞌya cua Eyacuiñajjija huoojeaꞌyo cuana, de. Yahuajo Eyacuiñajjija esohuijo tehue ca cua Abenijo. Miquianajaya etiiquiaa Cainiya Abeni cuiahuejjajea caꞌya cua. Majoya oya jayojjaya quea huiso cuiahuejjajea caꞌya cua Eyacuiñajjija esohui huohuijji cuana. Quijje yejje nei Eyacuiñajjija etehueꞌyojo tehue ca cua ojaya pea esohui huohuijjijo, Sacaniajo. Oya Eyacuiñajji nijje mimiani cuiahuejjajea caꞌya cua cuaa Eyacuiñajjija equijo, aquiana dahuajeajji pejjejo, de. Jamajjeya eyaya miya eꞌe jojo nei huohuiaña jama baꞌa: Jjeya nei Eyacuiñajjiya miquianaya quea nee nee po mee cajeꞌyo ojjaña etiiquianaja mimishi cuanajo, miquianaya etiiquiana jayojja cuani jojoya. ");
INSERT INTO eseNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Eꞌe jojo nei miquianaya, Moisesija etehueꞌyo huohuijji cuana quea tai nee cuani. Jamatii miquianaya ca mi ca oe esohui huohuijji nisho, siajjepojji. Eꞌe, miquianaya Eyacuiñajji nijje jjapeequi ajja nei. Pea cuana Eyacuiñajji nijje jjapeequi sa cuani, miquianaaya jjapeequi pajea meeyaña, de. Jamajoya miquianaya quea nee nee po mee cajeꞌyo quijje, de, quea nee tii tii cuajeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesosa mimipajeaꞌyajo Paniseo dejja cuana, Moisesija etehueꞌyo huohuijji cuana quea quene nee nee cua Jesosaja esohuijo. Oya cuana jjashahuaba taiquia cua. Ohuaya cuana Jesosa huohuiꞌajja neinei ca cua esohui quea tai ojaya yajji nisho, ejjajeanobiaquijji yasijje edojojji nisho. ");
INSERT INTO eseNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Quea dejja huiso nee nee ejjachichaqui nequia cua Jesosa shajjaꞌajjajji. Jjiojji quishi canequia cuaa cua quea dejja huisohua jjejojo. Jesosaa o shajjaꞌajjajji cuana jama huohuime aca cua baꞌa: —Paniseo dejja cuana jjashahuabatai majamajaquiani. Jamajjeya aje esohui huohuijji nisho cuani, Eyacuiñajjija epeejji nisho cuani, de. Coya mi o jayojja po chanaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Eyacuiñajjiya oya cuana ba cani ojaya epeejji nisho cuani. Ojaya ojjaña eba o jjashahuabaquiꞌyojji cuani cuana. Eyacuiñajjija eba ojjaña, de. Jamajjeya joya Eyacuiñajjiya quea jaꞌa po mee caje huiso tiiya, quehuaꞌama cuajeꞌyo tii ojjañaja ebajji. ");
INSERT INTO eseNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Eꞌe ecuea epeejji nei, ¡aꞌa quea mete pojji ojjaña cuanajo, eshahua cuanajo peaꞌai! Oya cuaa miquianaya quecua cajeꞌyo pojjaꞌa. Jamatii miquianajaya edojjoshahua mano jjima cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","¡Miquianaya jja oe jjashahuabaquicue Eyacuiñajjijo, de! Shajjamaꞌ cuajo ohuaya miquianaya mano meeꞌyo majje cuaqui yasijje jeajea cajeꞌyo miquea edojjoshahua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Eꞌe de, quea anohuii huiso nee nee yani. Anohuii beshahua nei sosemaꞌ quea huisojojo. Eyacuiñajjiya oya cuana pajeaꞌyo jjima acani. Ojaya eba ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ohuaya anohuii jaahuana cani, jamajjeya ohuaya miquianaya jaahuana neinei cani peaꞌaiya, de. Ojaya esico miquianajaya ehuojjaña. Jamajjeya ¡aꞌa pajeaꞌyojji miquianaya ohuaya nahue cani! Anohuii ohuaya nahue cani pishana —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesosa jama cua baꞌa: —Ecuea epeejji cuaa ejo huohui cani jama baꞌa: “Eꞌe, eya ca iña bichoꞌama Jesosajo. Eya ojaya epeejji nei nei, eꞌe jojo nei”. Jamajjeya eyaya Eyacuiñajjija esohuidojojji cuana o que huohuije jama baꞌa: “Eꞌe, oya cuana ecuea epeejji nei, eꞌe jojo nei”. ");
INSERT INTO eseNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pea cuana ca jja ca quea bicho cuani ejo. Jamajjeya oya cuaa huohui caje jama baꞌa: “Cho, eya Jesosaja epeejji pojjeama”. Jamajjeya eyaya Eyacuiñajjija esohuidojojji cuana huohuije jama baꞌa: “Cho, oya cuana ecuea epeejji pojjeama, cajaa” eyaya aje —Jesosa jamaya cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Beca cuaa eya niñeba cani; Eyacuiñajjiya maya mimishi cuijea sa acani. Peaa pojjaꞌa Edojjoshahua Bame niñeba cani, Eyacuiñajjija ca ca maya emimishi cuijeaꞌyojji pojjeama. Ma mimishi ani tiitiijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Pea cuaa miquianaya dojo caje esohuinano mese ani yasijje, Jodio dejja etii ani yasijje ecuea epeejjijojo. Miquianaya pojjaꞌa quea mete nee nee cuaje. Miquianaya jama jjashahuabaquije pojjaꞌa baꞌa: “¿Achajja shai huohuime acajji? ¿Achajja shai sajaꞌame aje?” ¡Aꞌa jamaya jjashahuabaquijji! ¡Meteꞌama nei onijje mimicue! ");
INSERT INTO eseNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Edojjoshahua Bameya miquianaya mimi bame meesahua caje esohuinano mese nijje. Quea bame cuaje miquianaya —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oe dejjaa Jesosa jama huohuime aca cua baꞌa: —Esohui huohuijji, ecuanaja chii manoꞌyonaje. Ecue oꞌija che eya bejjo esejja quiaꞌyo jjima ecue chiija quijjojea. Jamajjeya jama huohuiꞌajjame acue ecue oꞌi baꞌa: “Che pa ¡chahua bejjo esejja quiaꞌyocue!” acue —jamaya cuanaje oja chahua bejjo sa cuanijo. ");
INSERT INTO eseNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesosaa jama huohuime aca cua baꞌa: —Chojja de, ¿yajjajo acuae moya jama huohuiꞌajjame aña? Eya ca iña mique chiija quijjojea bejjo quiaꞌyohua cue pojjeama. Maya ecuea echacojji pojjeama, de. ");
INSERT INTO eseNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ojjaña dejja manojeꞌyo quea bejjo huiso cuana, aemaꞌ cuana peaꞌai. Miquea aquianaa miquea bejjohua miya baꞌe meesahua jjima acajeꞌyo, de. Jamajjeya ¡aꞌa aquiana bejjo peaꞌai sa majamajajji! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Majoya Jesosaa jiquio esohui ebajji huohui ca cua jama baꞌa: —Oe dejja quea bejjo huiso nee baꞌenaje. Anoso que quea huiso nee nee cuanaje. Sejjajeyoꞌyo majje quea huiso nee nee cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oya jama jjashahuabaquinaje baꞌa: “De, eya quea bihui nee, quea bejjo huiso nee nee cuaje. ¿Achejo shai eyaya anoso quea huiso nequiaje? ");
INSERT INTO eseNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Eyaya pojjaꞌa cajjajeajeajeꞌyo anoso nequijji, equi quea quemo nee nee iyajeꞌyo anoso quea huiso nee nee nequiajji, de. ");
INSERT INTO eseNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Majoya anoso iyajeyoꞌyo majje eya quea bihui cuaje, ecuea bejjo quea huiso nee nee cuaje. Quea shequija huiso nee nee eya chacochacoꞌyo jjima cuaje quea huiso jjejojo. Eyaya bobi quea huiso nee nee ijjiaje quea bihui epojji” jamaya cuanaje ma dejja. ");
INSERT INTO eseNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Majoya aje Eyacuiñajjiya ma mecajje huohui canaje jama baꞌa: “De, miya ca ca niñepoqui cuanaje. Miya jjeya nei manojeꞌyo. ¿Ajea acuae cuajeꞌyo miquea aquiana jiquio miya jaahuaña? Poquijeyojeꞌyo miya jiquio mecajje. Chamaꞌyo tii cuaje. Miquea aquiana, anoso, bejjo peaꞌai dojoꞌyo jjima cuaje. Miya aemaꞌ poquijeꞌyo cuaqui yasijje enijje jjapeequi jjima jjejojo” cuanaje Eyacuiñajji. Majoya aje manoꞌyonaje ma dejja; chamaꞌyo tii cuanaje —jamaya Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Eꞌe de, ma dejja jayojjaya miquianaya cuaje miya bejjojo jjashahuaba majamajaquianijo. Oe dejja jjashahuaba majamajaquiani ojaya bejjojo Eyacuiñajjijo oya jjashahuabaqui jjima cuani —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Majoya Jesosaa o shajjaꞌajjajji cuana jama huohuime aca cua baꞌa: —Eꞌe jojo nei eyaya miquianaya huohuiaña: ¡Aꞌa quea yeno jjashahuaba tiitiiquijji miquianajaya ebaꞌejjijo! Jama baꞌa: “Eꞌe pojjaꞌa eya bobimajo manojeꞌyo; bobi yasijje cuajeꞌyo. Ecuea daqui pojjaꞌa huiñajeꞌyo, daquimaꞌ nei nei eya cuajeꞌyo”. ¡Aꞌa jamaya jjashahuaba tiitiiquijji! ");
INSERT INTO eseNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","24","Eꞌe de, cuichojji cuana ca ca quea jaji nee baꞌe. Oya cuana ca ca chacochaco ajja, bobi chicha ajja equi yasijje quijje eꞌijjiaꞌyojji. Eseja Chiiya jja oya cuana jaahuana cani, de. Miquianaya ca ca oe ohuaya jaahuana neinei cani. ¡Jama jjashahuabaquimeya jja oe pocue ca quea bame ebaꞌejji, daquijo, bobijo! ");
INSERT INTO eseNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Aꞌa miya quea ao cuajeꞌyo jjashahuabaquime cuani? Chojja, jamatiiya cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jamajjeya oe ¡aꞌa aquianajo jjashahuaba tiitiiquijji! —Jesosa cua—. ¿Apiojji miquianaya jjashahuaba tiitiiquiani miquianajaya daquijo? ");
INSERT INTO eseNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","¡Bacue shasha tiiani! Shasha cuana chacochaco ajja; oja daqui cuana soco ajja. Jamatii quea bame nee nee nequiani. Jamaya Eyacuiñajjiya shasha pohua mee cani. Jodioja emeshi mese yahuajo nei nequia cua Sanomo bajjani. Ohuaya daqui quea nahue nee nee huosho ca cua. Jamatii oja daqui quea bame pishana cua, shasha ca ca oe quea bame nee nee cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Eꞌe, Eyacuiñajjiya shasha cuana pohua mee cani quea bame nee. Jjeya shasha cuana enequi; mecahuajje yaaꞌyani, jocaꞌyani; dahuajea cani cuaa pojjaꞌa, chamaꞌyo tii cuani. Jiquio ecua Eyacuiñajjiya shasha quea bame nee pohua mee cani jamaya ohuaya eꞌe jojo nei miquianaya baꞌe meesahua cajeꞌyo quea bame nee nee. Miquianaya ojaya quea boti nee nee cuani. Miquianaya jjashahuaba taiquiani jama baꞌa: “Eꞌe pojjaꞌa eseya jaahuana jjima Eyacuiñajjija”. Cho, ¡aꞌa jamaya jjashahuabaquijji! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Eꞌe, aꞌa jama peaꞌai jjashahuabaquime pojji baꞌa: “¿Aꞌya shai che ijjiaje? ¿Aꞌya shai che ishije; chama ena? ¿Aꞌya shai che ecuaa huoshoje?” ");
INSERT INTO eseNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ojjaña cuana Eyacuiñajjija epeejji pojjeama cuana aquianajo jjashahuabaquiani tii tii. Eyacuiñajjijo jjashahuabaqui ajja. Eꞌe jojo nei esejaya Chii eyajo ani miquianajaya aquianajo, ebaꞌejjijo jjashahuabaquiani. Ojaya eba ojjaña, de. Jamajjeya ohuaya miya jaahuana cani. ");
INSERT INTO eseNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","¡Aꞌa pea cuana jayojja pojji! ¡Jjashahuabaquicue oe Eyacuiñajjijo! ¡Onijje oe jjapee tiitiiquicue! ¡Ojaya esohuijo jjashajjaꞌajja tiitiiquicue! Jamaya jjashahuabaquianijo ohuaya miquiana huasijje aquiana ebaꞌe meejji quia cajeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Eꞌe ecuea epeejji cuana, ¡aꞌa quea mete pojji Eyacuiñajji nijje jjapeequi majje! Ohuaya miquianaya quea bihui po mee caje. Ohuaya miquianaya baꞌe tiitii mee cajeꞌyo eyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","¡Quiacue miquianaaya aquiana aemaꞌ cuana huasijje! Miquianaaya quia jjima ajje miquianajaya aquiana sii ca chanaꞌ; nojjo caꞌyo majje huiñajeꞌyo. ¡Jjeya Eyacuiñajjijo chacochaco neineicue! Eꞌe jojo nei ohuaya quijje miquianaya sosequia cajeꞌyo quea huiso nee nee eyajo. Miquianajaya esiijji pojjeama, miquianajaya epoꞌyo tii tii. ");
INSERT INTO eseNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eꞌe jojo nei miquianajaya aquiana equijo jaahuanaña, jamatii jjashahuabaquiani miquianajaya equijo. Miquianajaya aquiana ca ca eyajo jaahuanaña, jamatii jjashahuabaquiani eyajo ebaꞌeꞌyojjijo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jesosaa jama huohuime aca cua baꞌa: —Shajjaꞌajjacue jiquio esohui ehuohuiꞌyojo: Oe emeshi mese poquinaje cuiñajji yasijje. Ojo chacochacoani cuaa emeshi mese ishoaꞌajja canaje. Echacojjija ba jjima ache shono shai ojaya emeshi mese cueje oꞌoya. Jamajjeya daqui bame huosho canaje, cuaquijiji jijinequinaje peaꞌai. Cahui jjima cuanaje ishoaꞌishoanequi jjejojo. Emeshi mese cueꞌyajo, ojo chacochacoani cuaa dobiqui mee caꞌyonaje ojaya equi yasijje. Emeshi mese quea bihui cuanaje ohua ishoaꞌajja caꞌaninaje jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jamajjeya ojjaña ojee anioquenaje eꞌijjiaꞌijjiajji. Majoya aje ojee ijjiaꞌijjia majje ojaya echacojji cuana quea bihui nee nee cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jamaya oya cuana quea bame cuanaje ishoaꞌajja neinei canequinajejo. Mecajje, mecashono, epojjajo peaꞌai ishoaꞌajja canequinaje, de. ¡Jamaya miquianaya pocue! ¡Ejo jjaꞌishoaꞌajjaqui anicue! ");
INSERT INTO eseNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Eꞌe, jiquio jama cuaje baꞌa: Equi meseya siipojji ache shono cueje poso acani. Ojaya eba jojjemo, ohuaya ishoaꞌajja ca anime equi jaahuanajjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eya miquianajaya Edoe Mese, ¿ache nei eshequi nequijo eya miquiana que cueje oꞌoya ebajo ese? ¡Jamajjeya jjaꞌishoaꞌajjaqui anicue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Penohua Jesosa jama huohuiꞌajjame aca cua baꞌa: —Esohui huohuijji, ¿aꞌa jiquio esohui ecuanajaye nei ebajji? Ojjañaja ebajji pojjaꞌa ca coma. ");
INSERT INTO eseNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesosa jama cua baꞌa: —Eyaya huohuinaje jiquio esohui onaa shajjaꞌajja caje huiso tiija ejjashahuabaquijji. Shajjaꞌajjacue jama baꞌa: Oe emeshi mese poquinaje pea cuiñajji yasijje. Poqui jjimahuaa ojo chacochacoani huohui canaje pea ojaya echacojji bobiajji. Ojo chacochacoaniya emeshi meseja sohui shajjaꞌajja nei canaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Emeshi mese cueꞌyo majje quea bihui cuanaje ojo chacochacoani quea bame nee nee chacochaconajejojo. Jamajjeya emeshi meseya oya jama huohuime acanaje baꞌa: “¡Miyaya jjeya ojjaña ecuea aquiana cuana jaahuacue, miyaya ecuea esohui shajjaꞌajja neineinajejojo!” Jamajjeya ojo chacochacoani quea bihui cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pea ojo chacochacoani jjashahuabaqui jjima cuanaje. Jama jjashahuaba taiquime cuanaje baꞌa: “Ecuea emeshi mese quijje nei cuejeꞌyo, jamajjeya eya pea echacojji cuana huasijje bobi quia sa po ajja. Poquije ca iña ishiꞌishiya”. Majoya oya ojaya pea echacojji cuana nijje jjacuia majamajaqui nequinaje, huoo majamajanequi jjejojo. Oya chacochaco jjima cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Majoya aje oe ojaya emeshi mese cueꞌyonaje. Emeshi meseya ba cañaꞌyonaje ojo chacochacoani ehuoojaa. Majoya aje quea quene nee nee poñaꞌyo majje quecua cañaꞌyonaje shajjamaꞌjojo. Ohuaya jeajea canaje quea huesha. Jamaya Eyacuiñajjiya ojjaña mimishi cuana acajeꞌyo, huoojeajea cajeꞌyo cuaqui yasijje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Eꞌe de, echacomeejjija eba emeshi meseja esohui, oya ca ca shajjamaꞌ nei nei cuanaje. Jamajjeya aje oe emeshi meseya echacomeejji cuia cañaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pea echacomeejjija ca ca ba jjima nei emeshi meseja esohui cuanaje. Jamajjeya emeshi meseya echacomeejji oe pojji cuia meeme acanaje oja ba jjimajojo. Jamaya Eyacuiñajjija esohui eba nei nei epo cajjashajjaꞌajjaquiahua ojaya epeejji nei nei epojji. Shajjamaꞌ jojoya ca Eyacuiñajjiya cuaqui yasijje jeajea cajeꞌyo —jamaya aca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jamaya Jesosa cua baꞌa: —Eya cueyanaje ojjaña nijje jjapeequiya, beca cuana jjapeequije enijje, beca cuana ca ca enijje ejjapeequijji pojjeama. Jama huoojeameya eya acanaje Eyacuiñajjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Eya quea nee nee cuajeꞌyo, mano mee cajeꞌyo cuaa. Eya manocuajiꞌyo sa cuani ojjañaja mimishi cuana cuijeaꞌyojji sosejje. Quea camaja eya cuajeꞌyo, de. Manoꞌyo majje ca eya camajaꞌama cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¡Aꞌa jjashahuabaquijji eya cueyanaje ojjaña cuana ojjaña meshijo ojee quea bei baꞌe meeꞌyohua! Chojja, de. Pea cuana quea mase cuaje ecuea epeejji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Eꞌe, jamaya cuaje. Oe equijo baꞌe beca cuana ecuea epeejji nei, beca cuana ca ca ecuea epeejji pojjeama, Eyacuiñajjija epeejji nijje baꞌe sa po ajja oya. ");
INSERT INTO eseNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ebacua ejja esohui ba epo ejeajji nijje baꞌe sa po ajja ohua quea mimishi eꞌaca cuani jjejojo. Enaeseya oja bacua piona tecuea cani, ecuea epeejjijojo. Jamajjeya oja bacua piona onijje baꞌe sa po ajja. Yano mese osecuajana nijje mimijajiani o esohui ba epo jojoya. Jamajjeya osecuajana onijje baꞌe sa po ajja. Eꞌe, jamaya miquianajaya equijo cuaje —jamaya Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Majoya Jesosa jama cua baꞌa: —Mecajjeahua quea ichi nee nequijo, miquianaya jama cuani baꞌa: “Eꞌe de, quea ichi nequi, ena cuaje, de”. Eꞌe jojo nei ena cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Eꞌe de, jamaya peaꞌai miquianaya cuani baꞌa: “Eꞌe de, eeno jjayejjequiajo quiyo dobiꞌyani”. Eꞌe jojo nei quiyo dobiꞌyani. ");
INSERT INTO eseNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Miquianajaya eba ena cuanijo, quiyo dobi yanijo peaꞌai. Jamatii beshahua nei miquianaya ca jja ca oe jjashahuabaqui jjima e cueyanajejo. ¡Miquianaya jja oe jjashahuabaquicue Eyacuiñajjija esohuijo! Jamajjeya eya miquianaaya baje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—¿Aꞌa miquianajaya eba quea bame ebaꞌejji? Eꞌe pojjaꞌa, jamajjeya jjashahuabaquicue jiquio esohuijo jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Miquiana nijje oe dejja quea quene nee nee cuajo miquianajaya aquiana sosequia jjimajojo, ohuaya miquianaya dojo caje sohuinano huasijje. Jamajjeya ¡dojo jjimahuaa aquiana miquianaaya sosequiaꞌyocue! Miquiaa mi sosequiaꞌyajje ohuaya miquianaya dojo caje sohuinano huasijje ejeadobia meejji. Majoya miquianaya sohuinanohua jeadobia caje. ");
INSERT INTO eseNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eꞌe jojo nei ejeadobia tii jaaje. Ejeacuayaꞌyojji pojjeama miquiaa mi sosequiajje. Miquianaya sosequiajeyoꞌyajje ca mi ca oe jeacuaya cajeꞌyo. ¡Jiquio jayojjaya oe pocue! Jamajjeya ¡jjeya Eyacuiñajji nijje jjapeequicue miquianaya manoꞌyo jjimahua, cuaqui yasijje jea jjimahua peaꞌai! Jamajjeya miya cuaqui yasijje ejeadobiajji pojjeama —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Majoya pea cuana poquia cua Jesosa baa. Beca cuaa jama huohuiꞌajjame aca cua baꞌa: —De, jjeya nei Pinatohua, emeshi meseya Jodio dejja cuana quecua mee caꞌyonaje. Ma dejja cuana Janinea meshijo baꞌe poquinaje Jenosanena huasijje Eyacuiñajji bihuiaa. Eyacuiñajjija equi yasijje dobiqui majje ijjiacajji ehuoneꞌ cuana quecua canaje edahuajji. Eyacuiñajjija equijo nequi sohuinano cuaa dobiqui majje quecuajea caꞌyonaje. Hua canaje equecuaꞌyo cuanaja enaꞌ ijjiacajjija enajo, de. Quea mimishi nee nee cuanaje emeshi mese Pinato, de. ¿Aꞌa ma Jodio dejja cuana quecua caꞌyonaje quea mimishijojo? —jamaya poso aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesosa jama cua baꞌa: —Chojja, de. Miquianaya jjashahuaba taiquiani. Jodio dejja cuana quea mimishi cuani quecuaꞌyo jjima. ¿Yajja ajjaja oe pea cuana Jenosanenajo baꞌe mi manoꞌyonaje oya jayojjaya peaꞌai ca jja coma? ");
INSERT INTO eseNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jamajjeya miquianaya manoꞌyo majje peaꞌai Eyacuiñajji nijje jjapeequi jjima jjejojo cuaqui yasijje poquijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Eꞌe, Sinoe cuiñajjijo pea dejja cuana manoꞌyonaje. Equi quea ao nee nee iya canaje meshi edahua caꞌa. Meshi caꞌa jjaajajeaquiꞌyo majje dejja cuiamoꞌijea caꞌyonaje meshiya. Quea huiso nee nee, 18 dejja cuana manoꞌyonaje, de. ¿Aꞌa oya cuana quea mimishi nee neejo manoꞌyonaje poso aña? Chojja, de. ¿Yajja ajjaja oe pea cuana Jenosanenajo baꞌe mi manoꞌyonaje oya jayojjaya peaꞌai ca jja coma? Quea mimishi nee nee cuani; oya cuana eshe, de, manoꞌyo jjima. ");
INSERT INTO eseNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eyaya huohuije oꞌoya, miquianaya Eyacuiñajji nijje jjapeequi jjima po majje cuaqui yasijje poquijeꞌyo, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesosaa jiquio ehuohuiꞌyo jama huohuime aca cua baꞌa: —Oe dejja acuijjajja banajji epo poquinaje que yasijje. Acui tii majje jjajjamaꞌ cuanaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma dejjaa ojaya echacojji jama huohuime acanaje baꞌa: “De, pea beca peejjima shequiajame ca cuanaje ma acui. Jjajja ajja cuanaje. ¡Jajajeaꞌyocue; pea acui banaꞌyocue!” ");
INSERT INTO eseNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ojaya echacojjiya jama huohuime acanaje baꞌa: “Emeshi mese, ¡ishoaꞌajjacue oe eshequiajame! Eyaya jaahuana neineije soꞌo. Meshi tio majje anaꞌaija see meshi tejjee huanaje soꞌo. ");
INSERT INTO eseNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Acui eya jaahuana neineiajje quea jjajja huiso nee nee cuaje pojjaꞌa. Jjajjamaꞌ po oꞌoyajo oe cajajajeaꞌyahua” jamaya ojaya echacojji cuanaje —jamaya Jesosa cua—. Eꞌe, ma acui jjajjamaꞌ jayojja oe dejja jjapeequi jjima Eyacuiñajji nijje. Ma echacojjiya jjajja meesahua cani jama jayojja eyaya aña, dejja cuana jjapeequi meesahuaña Eyacuiñajji nijje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ejomishocajji pojjajo Jesosa poquia cua Jodioja ejjachichaquijji equi yasijje esohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Oe epona moꞌaa ania cua jomajo. Edosiquianaja jjamoꞌaaqui meeꞌyo cua yahuajo. Quea huiso nee nee, 18 eshequiajame epona ejjamoꞌaaquiꞌyo ania cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesosaa oya ba majje jama huohuiꞌajjame aca cua baꞌa: —¡Epona, cuecue! Eyaya miya jjadaasapiqui meejeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Majoya Jesosa que cueajo Jesosaa emeya napa cajje epi nei nequiꞌya cua. Ma eponaa Eyacuiñajji bihuia ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesosaa ma epona jjadaasapi meequi caꞌya cua ejomishocajji pojjajo. Majoya aje Jodioja ejjachichaquijji equi jaahuanajji Jesosa nijje quenequenea cua. Dejja cuana jama huohuime aca cua baꞌa: —Me oejje oe cahuime echacojji yani. ¡Ma pojja cuanajo cuecue ejjaajaquiꞌyojji! ¡Aꞌa ejomishocajji pojjajo Jesosaja jjaajaqui meeꞌyohua cuejji! ");
INSERT INTO eseNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesosaa ma esohui shajjaꞌajja majje jama tecueame aca cua baꞌa: —Chojja, ¡aꞌa jamaya mimijji! Miquianaya jama cuanaje baꞌa: “¡Aꞌa chacojji ejomishocajji pojjajo!” Miquianaya ca ca jiquio pojjajo chacochacoqui. Miquea anaꞌai ejomishocajji pojjajo ijjiaꞌijjia mee aña. Miyaya miquea anaꞌai ejeyo nequi pichojeaña ena ishi meequijji. ");
INSERT INTO eseNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eꞌe, jiquio epona mi jayojja, oe Jodio epona. Quea huiso nee nee, 18 eshequiajame Edosiquianaa jjamoꞌaaqui mee caꞌya cua, de. ¿Yajjajo acuaeya mi cuayajea meeꞌajjaquiꞌyaña soꞌo ejomishocajji pojjajo? ¿Aꞌa mi o jjapiqui meeꞌyo ajja jjejojo jama cuani? ¿Aꞌa miya jjashahuaba taiquiani jjejojo jama cuani? —jamaya cua Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesosaja esohui shajjaꞌajja majje o ñiñebajji cuana quea bicho poꞌya cua. Beca cuana ca quea bihui cua Jesosa nijje, ma epona jjapiqui mee caꞌyajo. Eꞌe de, Eyacuiñajjiya Jesosa quea sohui poja po mee caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Majoya Jesosaa jama huohuime aca cua baꞌa: —Ebionei Eyacuiñajji oe pojji dejjaja Emeshi Mese nei cuaje, quijje ca ca Eyacuiñajji ojjañaja Emeshi Mese nei cuaje, oya quea epeejji huiso cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eꞌe, oe motasa soꞌ biso nei tii majje acui quea quemo jayojja cuani, huapeje cui quemajja. Cuichojji motasa acuijo jaani. Ma esoꞌ biso nei jayojjaya Eyacuiñajjija epeejji cuani oe pojji jayojjaya cuani ebionei. Majoya quea huiso nee nee ojaya epeejji cuaje motasa acui jayojjaya —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Pea esohui ehuohuiꞌyo Jesosaa jama huohuime aca cua baꞌa: —Eyacuiñajji ojjañaja Emeshi Mese nei cuaje pahui shejjee yani jayojjaya. Jamaya oe epona pahui dahuajje cuanaje. Oe pojji nei eshejjee meejji iya canaje. Majoya aje ohuaya jeahuahuo canaje quea huiso pohuipohui pahui yajji. Majoya aje ojjaña shejjeeꞌyonaje pohuipohui. Majoya aje quea huiso pahui cuanaje. Jamaya Eyacuiñajjija epeejji pahui shejjee meejji jayojjaya cuani. Ebionei oe pojji epeejji cuana cuani, majoya aje pea cuana jjashahuabaqui mee cani Eyacuiñajjija epeejji epojji. Quea huiso nee nee po mee cani —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Majoya aje Jenosanena huasijje poquije, Jesosa pea cuiñajji cuana huasijje dobiqui poquia cua sohui huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jesosa aniñaqui jjimahuajo pea cuiñajjijo baꞌeya oya jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌa oe pojji Eyacuiñajjija epeejji cuana poquijeꞌyo eyahuasijje onijje baꞌeꞌyohua? Jesosa aje majoya jama cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Eꞌe de, yani oe esecuejjani biso nei edobiquijji eyahuasijje. Joya jjapeequi sa cuani enijje ma esecuejjani biso neijje dobiqui majje poquije eyahuasijje. Beca cuana ca ca poqui ajja eyahuasijje, enijje jjapeequi ajja jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eꞌe, eya oe equi mese jayojja. Equi meseya esecuejjani caꞌa caꞌyonaje, beca cuana edobiqui cuajejje. Majoya esecuejo tii nequijeaje. Oya cuana jama poꞌajja nequinaje baꞌa: “Equi mese, ¡caꞌapejocue ecuana edobiquijji!” Equi mese jama cuanaje baꞌa: “Chojja, ecuea miquianaya ba jjima, de”. ");
INSERT INTO eseNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Majoya oya cuana jama poꞌajja nequinaje baꞌa: “De, ecuanajaya miya eba, minijje ijjiaꞌijjianaje. Miyaya esohui huohuinaje ecuanaja meshijo”. ");
INSERT INTO eseNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Majoya aje oya jama cuanaje baꞌa: “Chojja, ecuea miquianaya ba jjima. ¡Poquicue quea huesha, quea mimishi nee nee mi ca cuanaje! Miquianaya ecuea epeejji cuana pojjeamajojo, dobiqui mee jjima aña”. ");
INSERT INTO eseNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eꞌe de, miquianaya ma dejja cuana esecuejo nequi tii tii jayojja cuani. Miquianaya dobiqui sajo pa neineijeꞌyo; miquianaya quea yeno nee nee cuajeꞌyo. Jamaya aje nequiana esecuejo nequi cuaje baꞌa: “Ecuea etiiquiana ca dobiquia cua, eꞌe jojo nei oya cuana Eyacuiñajjija epeejji cua. Oya bajjani cua baꞌa: Amajama, Isaaca, Jacobo, Eyacuiñajjija esohui huohuijji nei cuana peaꞌai. Jjeya Eyacuiñajji nijje nequi. Ecuana capoquiꞌyahua eyahuasijje”. Cho, miquianaya poqui ajja; quea yeno nee nee cuajeꞌyo. Shajjaꞌajja sa po ajja cuanaje ecuea esohui, Eyacuiñajjija esohui peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ojjaña dejja joya enijje jjapeequi jjima dobiqui ajja tii eyahuasijje. Ojjaña meshijo baꞌe Eyacuiñajji nijje jjapeequiani eyahuasijje poquijeꞌyo. Jomajo onijje ijjiaꞌijjiaje quea bihui epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Eꞌe, jjashahuabaquicue jiquio esohuijo jama baꞌa: Beca cuana jjeya ona huoojeaꞌyojji cuani eyajo ona huoojeaꞌyojji pojjeama cuajeꞌyo. Joya jjeya ona huoojeaꞌyojji pojjeama ca ca eyajo ona huoojeaꞌyojji nei nei cuajeꞌyo e jayojja —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Majoya aje Paniseo dejja cuana Jesosa que cueya cua onijje mimiya. Majoya aje oya cuana jama cua baꞌa: —¡Poquicuajicue oe, miya emeshi meseya, Enodeya, quecua sa acani! ");
INSERT INTO eseNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Majoya aje Jesosaa jama aca cua baꞌa: —Cho, ¡miquianaya jja ca oe poquicuajicue emeshi mese yasijje, Enode yasijje; oya dejja quea mase nee nee! Jjeya jiquio pojjajo, mecahuajje peaꞌai eyaya eshahua quea mase cuayaqui meeꞌyaña, emano cuana jaa jjaajaqui meeꞌyaña. Ma mecahuajje acua cuajeꞌyo ecuea echacojji; ¡jamaya Enode aquicue! ");
INSERT INTO eseNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Eꞌe jjeya ca iña poquijeꞌyo Jenosanena huasijje. Jomajo eya manojeꞌyo ma ecua Eyacuiñajjija esohui huohuijji cuana mano caꞌya cua huasijjeya. ");
INSERT INTO eseNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Majoya Jesosa quea yeno nee nee cua Jenosanenajo baꞌe cuanajo. Oya jama cua baꞌa: —Jodio cuana Jenosanenajo baꞌe, miquianaya ecuea quea jea nee nee. Jamajjeya eya miquianajo quea yeno cuani. Eꞌe, miquianaaya aje oe Eyacuiñajjija esohui huohuijji quecuaꞌya cua; ojaya ehuoojeaꞌyo cuana jajahuejjajeaꞌya cua meiya peaꞌai. ¡Bacue! Oe cachina enaeseya ebacua ejaahuanajji huojje cani. Jama jayojjaya eyaya miquianaya iyaa sa neineiaña e que ejaahuanajji. Jamatii miquianaya enijje jjapeequi sa po ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jamajjeya eya quea yeno nee nee miquianajo cuani. Miquianaaya Eyacuiñajji eya peaꞌai cajaa anaje. Jamajjeya ohuaya jaahuana ajja miquianajaya cuiñajji Jenosanena. Jamatii miquianaaya nei jaahuanaje; baꞌajja, quea camaja cuaje. Miquianaaya eya cajaa anaje, jamajjeya eba becaꞌyojji pojjeama mo nequianajaya. Miquiaaya eya cue oꞌoyajo jama aje baꞌa: “Miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Eyacuiñajjiya miya cajaahuana cahua quea bame” jamaya miquianaya cuaje quijje —jamaya Jesosa cua Jenosanenajo baꞌe cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Oe ejomishocajji pojjajo Paniseo dejja etiiya Jesosa iyaa ca cua ijjiaꞌijjiaa. Jamajjeya Jesosa poquia cua oja equi yasijje. Pea Paniseo dejja cuana Moisesija etehueꞌyo huohuijji cuana peaꞌai poquia cua oja equi yasijje ijjiaꞌijjiaa. Oya cuana Jesosajo jama jjashahuaba taiquime cua baꞌa: —Jesosaa pojjaꞌa oe jjaajaqui mee cajeꞌyo ejomishocajji pojjajo; baꞌajja. ");
INSERT INTO eseNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesosa pejjejo oe dejja quea mano nee, eshejjee tii tii nequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesosaa oya cuana jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌa ya che jjaajaqui meeꞌyome jiquio ejomishocajji pojjajo? Eꞌe pojjaꞌa, chojja pojjaꞌa. ¿Aꞌya acuae miquianaya jjashahuabaquiani soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Oya cuana mimi jjima nequia cua Jesosa bahuejjajji nisho. Majoya aje Jesosaa ma dejja eshejjee tii nequi napa ca cua emeya. Ma dejja shacuashacua mee caꞌya cua. Jesosaa oya jama huohuime aca cua baꞌa: —¡Poquicue miquea equi yasijje! ");
INSERT INTO eseNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Majoya Jesosaa Paniseo dejja cuana jama huohuime aca cua baꞌa: —Miquianaya chacochacoani ejomishocajji pojjajo. Bacue miquea ebacua, anaꞌai pojjaꞌa ejomishocajji pojjajo jjani quea doe yasijje oquequiajo, miquianaaya jjequisohuajeꞌyo. Jamaya miya chacochacoani ¿aꞌa eꞌe? Eꞌe jojo nei. Jama jayojjaya shacuashacua meeꞌyomeya eyaya anaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Paniseo dejja cuana jjashahuabaquiequi jjejojo, mimi jjima nequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Majoya Jesosaa Paniseo dejja cuana nijje ijjiaꞌijjiaa cueaniya ba ca cua Paniseo dejja cuana eꞌanijji bame bame saꞌajja cuequi. Ba majje jama huohuime aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Oe equi meseya miquianaya pojjaꞌa iyaa caje ijjiaꞌijjiaa. ¡Aꞌa eꞌanijji quea bame saꞌajjajji! ");
INSERT INTO eseNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Equi meseja epeejji nei cueje, caꞌaniꞌyahua ma eꞌanijji bame bamejo o pejjejo. Jamaya miquianaya nijje mimije baꞌa: “¡Nequisohuacue miya; poquicue pea eꞌanijji yasijje! Ecuea epeejji ca jiquiojo caꞌaniꞌyahua”. Quijjeyejjenei nequi eꞌanijjijo anioqueꞌyo majje quea bicho miya cuaje ojjañaa ba cajeꞌyo jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Eꞌe de, jamajjeya miquianaya iyaa cajje ijjiaꞌijjiaa, ¡anioquecue pea cuana nijje quijjeyejjenei nequi eꞌanijjijo! Majoya ma equi mese cueje mi que pojjaꞌa, jama huohuime acaje baꞌa: “¡Miya cuecue eꞌanijji bame yasijje e pejjejo!” Majoya pea cuaa ba caje miya anijji bamejo ani. Jamajjeya miquianaya quea bihui nee cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jamaya cuaje miquianaya. Eyacuiñajjija eba ojjaña jama cuani. Miquianaya jama jjashahuaba taiquime cuani baꞌa: “Eya che oe ese ejja quea bame nee nee cuani”. Cho, Eyacuiñajjija eba miya. Miquianaya jja oe jjashahuaba bamebamequicue jama baꞌa: “Eya ca iña pea cuana baꞌe meesahua sa cuani oya cuana quea bame epojji”. Majoya aje Eyacuiñajjiya miquianaya quea bame baꞌe meesahua caje. Majoya miquianaya dejja quea bame nee nee cuaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Majoya Jesosaa Paniseo dejja etii jama huohuime aca cua baꞌa: —Jamatii miquea bobi quea huiso anijo, miquea huapa pojjeama, miquea epeejji nei peaꞌai miyaya iyaaña ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jamajjeya miya ohuaya iyaa caje esosejjeya. ¡Aꞌa jama amajamajajji! ¡Iyaacue aemaꞌ cuana, jeoꞌajja cuana, poquideja cuana, cojjamaꞌ cuana iyaacue bobi ijjiaa peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ohuaya nequiana ca ca sosequia jjima miya acaje. Majoya miyaya ma jayojja ajo Eyacuiñajjiya miya quea bihui nee po mee caje. Quijje miya eyajo baꞌejeꞌyo Eyacuiñajji nijje. Majoya aje Eyacuiñajjiya miya eyajo sosequia cajeꞌyo quea huiso nee —jamaya aca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Oe dejjaa Jesosaja esohui shajjaꞌajja majje Jesosa jama huohuime aca cua baꞌa: —Ojjaña quea bihui cuaje eyajo ojee ijjiaꞌijjiani Eyacuiñajji nijje oja epeejji cuana nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesosaa jama huohuime aca cua baꞌa: —Eꞌe jojo nei, ca joya eyahuasijje poquijeꞌyo quea bihui nee cuaje. Jiquio esohui ehuohuiꞌyojo ca jama jjashahuabaquime pocue baꞌa: Oe emeshi meseja bobi quea huiso aninaje. Iyaa canaje dejja cuana quea huiso nee nee. ");
INSERT INTO eseNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bobi acua cuajo, huoojea canaje ojaya echacojji ona iyaaa. Iyaa canaje ojaya epeejji cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Oe epeejji jama cuanaje baꞌa: “De, eya poqui sa po ajja, jjeya jjeshenaje meshi, eya poquije ca iña meshi baa”. ");
INSERT INTO eseNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pea epeejji jama cuanaje baꞌa: “De, eya poqui sa po ajja peaꞌai, eyaya jjeshenaje me oejje huisome anaꞌai acuijo sheꞌanayijaca. Poquije ca iña anaꞌai jaahuanaa”. ");
INSERT INTO eseNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pea epeejji jama cuanaje baꞌa: “De, poqui sa po ajja ca iña; oya ca iña jjeya nei jjahuanaquiaña”. ");
INSERT INTO eseNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Echacojjiya oja meshi mese yasijje cueꞌyo majje huohui canaje ojjañaja esohui ma cue ajja cuanaje cuanaja. Majoya emeshi mese huohui cajje quea quene nee cuanaje. Huoojea ca oꞌoyanaje ojaya echacojji pea iyaaa. Jama cuanaje baꞌa: “¡Jjequicue jjeyahua nei pea cuana! ¡Iyaaquicue aemaꞌ cuana, jeoꞌajja cuana, poquideja cuana, cojjamaꞌ cuana peaꞌai ecuea equi yasijje bobi ijjiaa”. ");
INSERT INTO eseNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Majoya echacojji poquinaje pea jjequiya. Jjequi majje echacojjiya emeshi mese jama huohuime acanaje baꞌa: “Emeshi mese, eyaya pea cuana jjequinaje, eꞌanijji cuiñajeyo jjima cuanaje. Quea dejja huiso cue jjima, de”. ");
INSERT INTO eseNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jamajjeya emeshi mese jama cuanaje oꞌoya baꞌa: “¡Poqui oꞌoyacue quea huesha nee nee; pea cuana baꞌe yasijje iyaaquicue! ¡Cue meecue pea cuana: “Ecuea eꞌanijji cuiñajeyo jjima” acue! Ecuea equi cuio mee sa aña dejjaa. ");
INSERT INTO eseNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ecue epeejji cuana ca ca eyaya ebionei iyaaꞌajjanaje, jamatii enijje ijjiaꞌijjia jjima cuani” jamaya cuanaje emeshi mese —jamaya aca cua Jesosaa. Jamaya Eyacuiñajjiya dejja cuana quea huiso nee nee iyaaꞌajja cani, jamatii oe pojji poquiani onijje ijjiaꞌijjiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ojjañaa Jesosa equijje aca poquia cua. Majoya Jesosa jjabajeaquiꞌya cua. Ohuaya jama huohuime aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—¡Miquianaya enijje jjapee neineiqui sa cuani, eya oe quea jea nee nee acue! ¡Miquea huapa pojjeama oe pojji quea jea acue! Miquea enaese, mique chii cuana, mique huanase cuana, mique bacua cuana, mique doe, mique jjoꞌi jama, ¡quea jea nee ameya mo oe acue! ");
INSERT INTO eseNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Miquianaya enijje jjapeequiajo pea cuana miquiana nijje mimijajije. Eꞌe, jiquio ecua acui ecueataꞌapee quea camaja eꞌabojji jama jayojja enijje jjapeequiajo quea camaja cuaje. Eꞌe de, pea cuaa miquianaya cuia sa acaje, quecua sa acaje pojjaꞌa enijje jjapeepajeaquiꞌyo ajjajojo. Miquianaya ecuea epeejji nei po tiitiianijo jamajjeya eꞌe jojo nei miquianaya ecuea epeejji nei nei cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¡Ejo jjashahuaba neineiquicue enijje jjapeequi jjimahua, quea camaja epo cuahuajje! Miya quea nee, quea yeno pojjaꞌa cuaje enijje jjapeequi majje. Eꞌe jojo nei oe dejja equi iya jjimahuajo jjashahuabaquiani ma equi eꞌiyajji nishojo. ");
INSERT INTO eseNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Majoya ohuaya cajaa acanaje mi iya majje. Beca cuaa niñeba canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Eꞌe de, ma dejjaa iyaꞌajja canaje, jjashahuaba neineiqui jjima jjejojo mi iyajeyo canaje”. Eꞌe, jamaya enijje jjapeequi jjimahuajo ¡jjashahuaba neineiquicue ejjapee tiitiiquijji enijje! ");
INSERT INTO eseNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Eꞌe de, oe emeshi meseya pea emeshi mese nijje jjaquecuaqui mee sa acanaje. Ebionei ohuaya sico canaje ojaya sohuinano cuana. Ojaya yani 10 mil sohuinano cuana, quea huiso pishana. Pea emeshi meseja ca ca sohuinano 20 mil cuanaje, quea huiso nee nee, de. Jamajjeya ma emeshi mese oe pojji pishana sohuinanojo jjaquecuaqui mee jjimahua jjashahuaba neineiquinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Oya jama cuanaje baꞌa: “De, quea camaja, ecuea oe pojji sohuinano yani”. Jamajjeya emeshi meseya pea emeshi mese yasijje oe sohuinano huohui pohua huoojea canaje jjaquecuaqui mee sa po ajjaa jjejojo. Onijje jjapeequi sa cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eꞌe, jamaya miquianaya jjapeequi sa cuani enijje pojjaꞌa. ¡Jjashahuaba neineiquicue ejo jjapeequi jjimahua! Quea camaja cuaje enijje jjapeequi majje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesosaa pea esohui jama huohuime aca cua baꞌa: —Sane quea bame nee nee. Jamatii sane seseꞌama cua jjemo jeajea cajji. ");
INSERT INTO eseNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","¿Achacua jeajea cajji? Quea huesha nee nee. Eꞌe, quea huesha jea jjima ca ca meshi quea tai sane tejjee cuaje, saneya acui tii mee jjima acaje. Jamaya miquianaya enijje jjapeequiani, majoya jjapeepajeaquijeꞌyo pojjaꞌa. Miquianaaya eya pajeaꞌyo majje eyaya miquianaya jeajeajeꞌyo quea huesha nee nee sane jayojjaya. Jamajjeya ¡jjashahuaba neineiquicue enijje jjapeequi jjimahua! —jamaya Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dejja cuana emeshi meseja bejjo jjeshejji cuani poquia cua Jesosa que oja esohui shajjaꞌajjaa. Oya cuana jamatii quea mimishi nee nee cua. Pea dejja cuana quea mimishi nee nee poqui peaꞌaiya cua Jesosaja esohui shajjaꞌajjaa. ");
INSERT INTO eseNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Paniseo dejja cuana, Moisesija etehueꞌyo huohuijji cuana jjaniñebaqui aña cua pea cuana nijje jama Jesosajo po aña cua baꞌa: —De, Jesosa jjapeequiani dejja quea mimishi nee nee cuana nijje, ijjiaꞌijjia ani ona nijje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma esohui shajjaꞌajja majje Jesosaa esohui ejjashabaqui meejji jama aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Oe dejja yaninaje, ojaya ñajjajja cuana quea huiso nee, 100 huisome. Oe ñajjajja poquiquehuanaje. Dejja poquinaje ñajjajja saꞌajjaꞌyohua. Pea ñajjajja 99 huisome ojee ijjiaꞌijjiaqui jea canananaje. Saꞌajja neinei caꞌyoquinaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Majoya aje baꞌyo majje abo caꞌyonaje. Abo majje dojo caꞌyonaje o nequijji yasijje, quea jaji nee nee poꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ñajjajja meseya ojaya epeejji jama huohuime acanaje baꞌa: “Baꞌyonaje eyaya ecuea oe ñajjajja, de. Jjeya nei enequiꞌyo, eꞌe de, jjeya eseya quea bihui epoꞌyo”. ");
INSERT INTO eseNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Eꞌe, ñajjajja epoquiquehua oe dejja quea mimishi nee nee jama jayojja cuani. Eyacuiñajji ma ñajjajja mese jayojja cuani. Jamatii Eyacuiñajjiya dejja mimishi cuana sa cani ojaya epeejji epojji. Ohuaya dojo sa cuani ma dejja eyahuasijje. Eyacuiñajji quea bihui cuaje oe dejja mimishiya ojaya mimishi pajea caꞌyajo, Eyacuiñajji nijje jjapeequiajo. Ojjaña eyajo baꞌeca cuana quea bihui cuajeꞌyo ma dejja mimishi Eyacuiñajji nijje jjapeequiajo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesosaa pea esohui jama huohuime aca cua baꞌa: —Oe eponaja bejjo ome miji peaꞌai aninaje. Oe bejjo oquequehuajeaquinaje meshi yasijje equi yiyedojjojo tiiya. Jamatii saꞌajja neinei caꞌyoquinaje eponaa. Cuaquijijiya bejjo jeajaꞌaꞌajja caꞌyonequinaje. Majoya aje cuiashabaꞌajja caꞌyonaje. Majoya aje cuiashabaꞌyo majje ba caꞌyonaje bejjo. ");
INSERT INTO eseNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Majoya aje quea bihui poꞌyonaje bejjo ba majje ojaya epeejji cuana huohui caꞌyonaje jama baꞌa: “Eꞌe ee, eseya jjeya quea bihui epoꞌyo. Eyaya baꞌyonaje bejjo ma oquequehuajeaqui cuanaje” epona cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eꞌe, ma bejjo oe dejja jayojja cuani. Oya quea mimishi nee nee jjapeequi sa cuani Eyacuiñajji nijje; ojaya mimishi pajeaꞌyo sa cuani. Jiquio ecua epona bejjo ba majje quea bihui nee nee cuani jayojja Eyacuiñajji quea bihui cuani dejja mimishi onijje jjapeequiajo. Eyacuiñajjija esohuidojojji cuana eyajo baꞌe quea bihui nee nee cuaje oe dejja Eyacuiñajji nijje jjapeequiajo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pea esohui Jesosaa jama huohuime aca cua baꞌa: —Oe emeshi meseja becanejjijji peaꞌai ebacua ejja nequinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ebacua ejja shacuimaꞌ nequi epohua oja chii jama huohuiꞌajjame acanaje baꞌa: “Ecue chii, ¡bejjo mo quiaꞌyocue ecuea yajji; miya manoꞌyo jjimahua oe mo quiaꞌyocue!” Jamajjeya oja chii jama cuanaje baꞌa: “Eꞌe maꞌaje”. Ma echahua mesejame oja iya poquia quia caꞌyonaje echahua mese que. ");
INSERT INTO eseNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Majoya aje quijje pishana echahua meseya ojaya aquiana, meshi peaꞌai quia canaje bejjo sosejje. Ma bejjo sosejjeya poquinaje pea meshi yasijje quea huesha nee nee. Jomajo quea mimishi nee nee baꞌenaje, de. Ohuaya bejjo quia jeyojeyo caꞌyonaje huoo majamajajjiya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chamaꞌyo tii ojaya bejjo poꞌyonaje, quea shoe nee nee poꞌyonaje peaꞌai. Ma meshijo bobi chamaꞌyo tii cuanaje ejjeshejji, de. ");
INSERT INTO eseNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ohuaya oe dejjaja echacojji saꞌajja canaje. Oe dejjaa oya huoojea canaje cuichi nequi yasijje cuichi cuiñajji epojji. Majoya ohuaya cuichi cuiñaqui canaje. Chamaꞌyo tii ojaya bobi poꞌyonaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jamajjeya aje cuichija bobi ijjia sa cuanaje quea shoe nee nee jjejojo, bobi peaja quia jjima nei nei cuanaje jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Majoya aje jama jjashahuaba neineiquiꞌyome cuanaje baꞌa: “Eꞌe de, ecue chiija echacojji jomajo yani, bobi quea huiso yani jomajo, de. ¿Yajjajje shai eya jiquiojo quea shoe nee nee poꞌyo ani, de? ");
INSERT INTO eseNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eya capoquiꞌyahua ecue chiija equi yasijje. Eyaya oya jama huohuiñaquiꞌyome aje baꞌa: —Ecue chii, eya quea mimishi cuanaje minijje, Eyacuiñajji nijje peaꞌai —eyaya añaquijeꞌyo ecue chii. ");
INSERT INTO eseNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ecue chii enijje quea quene cuaje eya quea mimishi cuanajejojo. Ohuaya eya oja bacua pojjeama jayojja acaje. Jamajjeya mo eya ojaya echacojji capoꞌyahua. Eya quea shoe nee nee, aemaꞌ peaꞌai. Quea yeno nee nee eya cuani ecue mimishijo. Eꞌe de, jjeya nei eya poquijeꞌyo ecue chiija equi yasijje” jamaya jjashahuabaquinaje ma ebacua ejja. ");
INSERT INTO eseNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—Majoya aje poqui oꞌoyanaje oja chiija equi yasijje. Majoya oja chiiya oja bacua ejja ejiojjijje quea huesha cuejeꞌyo ba canaje. Jama cuanaje baꞌa: “Ecue bacua ejja pojjaꞌa joma cuejeꞌyo”. Oya majoya quea jaji nee nee poꞌyonaje oja bacua ejiojjijje cuejeꞌyo ba majje. Majoya aje oja bacua que poquinaje; emeya cuiapashi cajjequiꞌyonaje; shemo tojjo cajjequiꞌyonaje quea jeajojo. ");
INSERT INTO eseNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—Majoya aje ebacua ejjaa oja chii jama huohuime acanaje baꞌa: “Miya ecue chii nei nei, eya quea mimishi nee nee cuanaje minijje, Eyacuiñajji nijje peaꞌai, de. Miyaya pojjaꞌa eya niñebaña, jamajjeya pojjaꞌa eya miquea echacojji capoꞌyahua miquea ebacua pojjeama jayojja”. ");
INSERT INTO eseNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Oja chii jama cuanaje baꞌa: “Chojja, miya ecuea ebacua ejja nei, echacojji pojjeama”. Oja chiiya echacojji cuana jama huohuime acanaje baꞌa: “¡Yecue ecue bacua ejjaja daqui eyacua nei nei, oe emehuao peaꞌai, ejiojji shejee peaꞌaiya oe yecue! ");
INSERT INTO eseNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","¡Quecuacue oe anaꞌai esei esejaya ojee eꞌijjiajji! Jjeya eseya ojee ijjiaꞌijjiaje ecue bacua ejja cueꞌyonajejo. ");
INSERT INTO eseNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Eya jjeya quea bihui ecue bacua ejjajo; oya emanoꞌyo jayojja cuanaje, chamaꞌyo tii, jjeya ca cueꞌyonaje ecue bacua ejja, eshe de. Oya ca ca ecuaquishoꞌyo cuanaje, jiquio pojjajo ca eyaya baꞌyonaje ecue bacua ejja”. Majoya aje bobi acua amajje ojjaña ijjiaꞌijjianaje. ");
INSERT INTO eseNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Edoe mese chacochaco aninaje quejo; oja ba jjima echahua mese cueꞌyonaje. Quijje oya cueꞌyonaje oja equi yasijje. Shajjaꞌajja cañaꞌyonaje quea shajjaquijjo cuani ojjaña ijjiaꞌijjiani ojee. ");
INSERT INTO eseNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ohuaya oe eshoꞌi huohuiꞌajja canaje: “¿Aꞌya acuae po ca ani soꞌo?” ");
INSERT INTO eseNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jama eshoꞌiya acanaje baꞌa: “Mique chahua cueꞌyonaje quea aja nee nee, de. Mique chii quea bihui poꞌyonaje, de. Jamajjeya ojjaña ijjiaꞌijjia mee cani ojee quea bihuiꞌyohua jjejojo”. ");
INSERT INTO eseNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Majoya aje oja doe quea quene nee nee cuanaje, pea cuana nijje ijjiaꞌijjia sa po ajja cuanaje. Majoya oja chii cuayaquinaje edoe mese jjequidobiaa nisho. Dobiqui ajja cuanaje oja bacua ejja equenequene neineiꞌyo jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Majoya edoe mese oja chii nijje miminaje: “Eya chacochaco neiꞌyonaje ee nei, de. Quea shequiaja huiso nee nee. Eya mimishiꞌama nei cuanaje minijje; jamatii eyaya miquea esohui shajjaꞌajjanaje, de. Miyaya che ecue chivo shoꞌi cuia jjima anaje ecuea epeejji nijje ojee eꞌijjiajji. Miquea quea nahue cuanaje ejo, de. ");
INSERT INTO eseNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mique bacua ejja shoꞌi shajjamaꞌ cueꞌyajo ca jjaya ca oe che anaꞌai quecuaꞌyonaje. Oya quea mimishi nee nee cuanaje; pea epona cuana nijje jjacojjojeaqui nequiꞌyonaje miquea bejjo sosejje, de” jama cuanaje edoe mese. ");
INSERT INTO eseNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—Majoya oja chii jama cuanaje baꞌa: “Miya ecue bacua ejja quea bame nee, miya eyaya jaahuana neineiaña. Ojjaña aquiana ecuea, miquea epoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mique chahua cueꞌyajo ecuanaya quea bihui poꞌyonaje. Oya ca ca emanoꞌyo jayojja cuanaje. Oya cueꞌyonaje jjeya, eshe de. Oya ecuaquishoꞌyo jayojja cuanaje; jjeya nei ca ca eyaya oya baꞌyonaje” jamaya oja chiiya oja bacua ejja etii acanaje. Eꞌe de, mahuiso —jamaya Jesosa cua. Jamaya Eyacuiñajjiya quea jea ameya acaje dejja mimishi cuaa oja mimishi pajea caꞌyajo, onijje jjapeequiajo peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesosaa o shajjaꞌajjajji cuana jama huohuime aca cua baꞌa: —Oe emeshi mese quea bejjo huiso nee aninaje. Ohuaya shajjaꞌajja canaje ojaya echacomeejjiya sii cani ojaya aquiana. ");
INSERT INTO eseNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jamajjeya huohuiꞌajja canaje ojaya echacomeejji jama baꞌa: “Pea cuaa eya huohui canaje miya siipojji cuani. ¿Aꞌa cuae jja miya siipojji nei soꞌo? ¡Huohui poꞌajja socue! Jamajjeya miya ecuea echacomeejji nei pojjeama. ¡Yecue ma papenijo etehueꞌyo jaa ebajjani cuana! ");
INSERT INTO eseNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Majoya aje echacomeejji jjashahuabaquinaje jama baꞌa: “De, chamaꞌyo tii ca ecua echacojji cuajeꞌyo, ecuea emeshi meseya eya cajaa acaꞌyonaje, de. Eya jjeya quea aa mano echacochacojji, de. Eya ca iña eme huo sa po ajja quea bicho jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Eꞌe de, jjeya nei ca iña jjashahuabaquinaje pea dejja cuanaja sosequiaꞌyo jjimajo. Eyaya oe pojji sosejjeshejeꞌyo. Majoya eya ecuea emeshi meseya huoojea cajo pea cuaa baꞌe meesahua caje, enijje quea bihui cuaje. Eꞌe de, eyaya tehueje oꞌoya ojjaña echacojji cuanaja emeshi mese sosequia jjima; oe pojji ajeꞌyo” jamaya echacomeejji jjashahuabaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jamajjeya ohuaya pea dejja cuana iyaa canaje emimijji, ache huiso onajaya sosequiaꞌyo jjima ebajji. Ohuaya jama huohuiꞌajjame acanaje baꞌa: ¿Ache sose huiso acuae miquea sosequiaꞌyo jjima soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oe dejjaa jama sajaꞌame acanaje baꞌa: “Ecuea sosequiaꞌyo jjima mahuiso baꞌa: ecuea esei 100 natame, quea huiso nee nee eyaya jjeshenaje, de”. Majoya echacomeejji jama cuanaje baꞌa: “Eꞌe de, eꞌe jojo nei miquea papeni yani ecue tehue. Jjeya ca ca miquea sosequiaꞌyo jjima nequi 50 natame, jamaya eyaya tehueje oꞌoya pea papenijo oe pojji esosequiaꞌyojji”. ");
INSERT INTO eseNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Majoya ohuaya pea dejja acanaje jama baꞌa: “¿Ache huiso acuae miquea sosequiaꞌyo jjima soꞌo?” Oya jama cuanaje baꞌa: “Quea huiso nee nee, 100 natame anoso ai, de”. Echacomeejji jama cuanaje baꞌa: “Eꞌe de, jjeya ca ca papenijo tehueje oꞌoya 80 natame esosequiaꞌyojji” jamaya cuanaje echacomeejji dejja cuana nijje, onijje quea bei epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Eꞌe de, quijje pishana emeshi meseya ojaya echacomeejji ae po ani shai ba canaje. Ba majje jama cuanaje baꞌa: “Eꞌe de, ohuaya eya dasia canaje. Jamatii oya jjashahuaba neineiquiꞌyonaje. Oya quea epeejji huiso nee nee po sa cuanaje o baꞌe meesahuajji epojji”. Mahuisoya jiquio esohui —Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","¡Miquianaya ca ca jjashahuaba neineiquicue quea bame epojji pea cuana nijje! Jamajjeya miya Eyacuiñajjiya baꞌe meesahua caje. Majoya miquianaya manoꞌyajo, ohuaya dobiqui mee cajeꞌyo eyahuasijje ebaꞌe tiitiiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Miquianaaya jjeya oe pojji aquiana jaahuana neineiaña, miquianaya quea bame po majje quijje eyajo miquianaya quea huiso jaahuana neineijeꞌyo. Miquianaya oe pojji jjadasiaquiani quijje miquianaya jjadasiaquijji nei nei cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Miquianaya oe pojji aquiana jiquiojo jaahuana jjima aña, Eyacuiñajjiya miquianaya aquiana quia jjima acajeꞌyo eyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eꞌe de, miquianaya pea cuanaja aquiana jaahuana jjima añajo Eyacuiñajjiya miquianajaya aquiana quia jjima acajeꞌyo eyajo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Eꞌe de, ¡miquianaya jja ca oe Eyacuiñajjijo jjashahuaba majamajaquicue! ¡Oe nei neijo oe jjashahuabaquicue, aquianajo pojjeama! Jamaya oe Eyacuiñajji nijje jjapeequi sa cuanijo, ¡aꞌa aquianajo jjashahuabaqui majamajajji! —jamaya cua Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Paniseo dejja cuana ma esohui shajjaꞌajja majje mimijajia cua Jesosa nijje bejjo quea huiso sa cuanijo. ");
INSERT INTO eseNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jamajjeya aje Jesosaa jama tecueame aca cua baꞌa: —Miquianaya jjashahuaba taiquiani miquianaya oe dejjaya quea bame baꞌyani poso cuani. Dejja cuaa ca ca oe miquianaya quea bame poso acani. Miquianaaya dejja cuana dasiaña. Miquianaaya ca ca oe Eyacuiñajji dasia jjima aña, ojaya miquianaya eba nei nei, de. Miquianaya jama cuani botiꞌama. Eꞌe, joya miquianaaya quea bame poso aña Eyacuiñajjija botiꞌama —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Yahuajo nei nei Eyacuiñajjija esohui huohuijji cuaa huohui ca cua Moisesija etehueꞌyojo. Jama cua baꞌa: “Quijje Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji Emeshi Mese oe nei cueje”. Jjeya nei ca ca Huaniya enajo ona besameejji cuanaje huohui canaje Eyacuiñajjija pea esohui jama baꞌa: “Quito ojjañaja Emeshi Mese cueje jjeya nei”. Jamajjeya quea huiso nee nee dejja cuana jjapeequi sa cuani Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jamatii Eyacuiñajjija esohui eꞌe jojo nei cuani, quea bame cuani. Quijje ojjaña meshi cuana majameta cuana chamaꞌyo tii cuaje, de. Eyacuiñajjija esohui ca ca ma ani tiitiiꞌyome cuaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesosaa esohui jama huohuime aca cua baꞌa: —Oe dejjaja ehuanase huei cuani pea ehuanaꞌyojji jamaya pea cojjojji cuani. Oe dejja oe epona ehuei huanaꞌyo majje pea cojjojji cuani peaꞌai. Epona yahue hueijji cuani pea cojjojji peaꞌai cuani. Jamajjeya dejja cuaa ¡aꞌa ehuanase hueijji, eponaa peaꞌai aꞌa miquea yahue hueijji! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesosaa pea esohui jama huohuime aca cua baꞌa: —Oe dejja quea bejjo huiso nee nee cuanaje. Ojaya daqui quea bame nee; quea nahue nee nee oja jjeshe huosho caninaje. Bobi quea huiso aninaje ojaya equijo; ijjiaꞌijjia majamajanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pea dejja ca aemaꞌ cuanaje Nasano bajjani. Oya chiji nei nei poꞌyonaje; oya quea mano cuanaje. Jamatii Nasano dejja quea bejjo huisoja esecuejjani pejjejo aniñaquinequinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jamatii ojaya chiji iñahuehuaa sio canaje. Oya jama poꞌajja aninaje baꞌa: “¡Chemo bobi quiacue joya miquea ijjia shaa ani!” jamaya Nasano poꞌajja aninaje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nasano Eyacuiñajjija epeejji cuanaje, jamajjeya manoꞌyo majje Eyacuiñajji ani yasijje poquiꞌyonaje. Nasano aniꞌyonaje Amajama pejjejo, Jodioja etiiquiana pejjejo. Majoya aje ma dejja quea aquiana huiso manoꞌyonaje peaꞌai. Ohuajea canaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Oya Eyacuiñajjija epeejji pojjeama, jamajjeya emanoꞌyo ojjaña eshahuaja epeejji cuana poqui caquijje poquinaje cuaqui yasijje. Jomajo oya quea nee nee poꞌyoqui. Jomajo ohuaya Nasano, Amajama peaꞌai ba canaje eyajo quea huesha nee nee. ");
INSERT INTO eseNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oya jama taaame cuanaje baꞌa: “Amajama ecuea etiiquiana, ¡che oe ejo jjashahuabaquicue! Eya quea quiyo nee nee poꞌyoqui jiquiojo, de. ¡Che jjo yana chopeshihuacue! ¡Huoojeacue Nasano ecue yana chopeshiya eya quea naba taja nee nee acue!” jamaya ma dejja quea aquiana huiso cuaquijo nequi cuanaje Amajama nijje. Nasano ca oe poqui jjima cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Amajamaa eyajo jama huohuime acanaje baꞌa: “De, miyaya pajeaꞌyonaje pojjaꞌa. Miya esheahua quea aquiana huiso baꞌenaje meshijo. Jamatii Eyacuiñajji nijje jjapeequi jjima cuanaje. Nasano ca ca aemaꞌ quea mano poꞌyonaje peaꞌai. Oya ca ca Eyacuiñajjija epeejji cuanaje. Jamajjeya Eyacuiñajjiya oya quea jaji nee nequi mee caꞌyani. Miya ca mi ca oe quea yeno nequiꞌyo, quea quiyo nequiꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eyacuiñajjiya miya cue mee jjima acani ecuana nequi yasijje ojaya epeejji pojjeama cuanajejojo. Ecuana mi que poqui mee jjima acani peaꞌai” jamaya cuanaje Amajama. ");
INSERT INTO eseNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Ma dejjaya cuaqui dojjojo nequi jama taaame po nequinaje baꞌa: “¡Che jjo oe ecue huapa pojjeama meshijo baꞌe jjashahuabaqui meecue Eyacuiñajjijo! ¡Huoojeacue Nasano ecue chiija equi yasijje huohuiya! ");
INSERT INTO eseNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","¡Ecue chahua me oejje huiso tiiya jjashahuabaqui meecue Eyacuiñajjijo acue! Eyacuiñajji nijje cajjapeequiahua cuaqui yasijje mi cuejeꞌyo acue”. ");
INSERT INTO eseNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Majoya aje Amajama jama huohuime aca oꞌoyanaje baꞌa: “Yani aje jja ca Eyacuiñajjija esohui etehueꞌyo, Moisesiya tehue ca cua yahuajo nei nei. Pea cuaa tehue ca cua peaꞌai yahuajo nei nei, de. Ma esohui oya cuaa cashajjaꞌajja cahua. Esohui shajjaꞌajja majje poquiꞌyo ajja cuaqui yasijje, mi jayojja epoꞌyojji pojjeama” jamaya cuanaje Amajama. ");
INSERT INTO eseNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Majoya aje ma dejja cuaquijo nequi jama cua baꞌa: “Chojja de, oya cuana jjashajjaꞌajjaqui ajja. Ma esohui etehueꞌyojo jjashahuabaqui ajja. ¡Huoojeacue oe emanoꞌyojaa shequi oꞌoya esohui huohuiya! Majoya quea bame cuaje, de. Onaaya emanoꞌyojaa shequi oꞌoyajo ba majje jjashahuaba neineiquije Eyacuiñajjija esohuijo. Jjapeequijeꞌyo Eyacuiñajji nijje, de” cuanaje ma dejja cuaquijo nequi. ");
INSERT INTO eseNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Majoya aje Amajama jama cuanaje baꞌa: “Chojja de, jjashajjaꞌajjaqui ajja Moisesija etehueꞌyojo, Eyacuiñajjija esohuijo, jamaya ohuaya shajjaꞌajja jjima acaje emanoꞌyojaa shequi oꞌoya ca Eyacuiñajjija epeejji epojji. Chojja, eyaya oya emanoꞌyojaa huoojeaꞌyojji pojjeama esohui huohuiya” jamaya cuanaje Amajama eyajo nequi. Eꞌe de, mahuiso —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesosaa o shajjaꞌajjajji cuana jama huohuime aca cua baꞌa: —Jamatii pea cuaa ecuea epeejji eyacua quea mimishi po mee oꞌoya sa acani. Jamaya o cuajo Eyacuiñajji quea quene nee nee cuaje onijje. Ohuaya oya jeajea cajeꞌyo cuaqui yasijje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jamajjeya ¡ecuea epeejji quea mimishi epo mee cuahuajje oe manoꞌyocue! Eꞌe, ¡onaaya mei enaajo yiipeca mee majje bae quea doe yasijje jjajeaoquejea meequiꞌyocue! Jamajjeya ¡aꞌa quea mimishi po meeꞌyojji cuana! ");
INSERT INTO eseNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Eꞌe de, coya mi quea mimishi po oꞌoya chanaꞌ. Miquea epeejji quea mimishi po oꞌoyajo, ca oe jama huohuiquime acue baꞌa: “Miya quea mimishi cuanaje. ¡Aꞌa quea mimishi po oꞌoyajji!” Majoya oya pojjaꞌa jama cuaje baꞌa: “Eꞌe de, eya quea mimishi cuanaje, jjeya ca ca eya quea mimishi epoꞌyojji pojjeama minijje”. Jamajjeya ¡miquianaaya ma mimishijo aꞌa jjashahuaba majamajaquijji! ¡Jjapeequi oꞌoyacue onijje! ");
INSERT INTO eseNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eꞌe pojjaꞌa ca ca oya mimijaji majamajaje minijje, majoya oya quea yeno nee nee cuaje ojaya mimishijo. Jamajjeya ¡jamatii miquianaya oja mimishijo aꞌa jjashahuaba majamajaquijji! ¡Jjabeiqui oꞌoyacue onijje! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","O shajjaꞌajjajji cuaa Jesosa jama huohuime aca cua baꞌa: —¡Ecuanaya jjabahuejjaqui mee neineicue mijo eꞌe jojo nei ejjashahuabaquijji, mi jayojja ebaꞌejji! ");
INSERT INTO eseNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesosa jama cua baꞌa: —De, miquianajaya eya eba, eya miquea epeejji nei cuani. Eyaya miquianaya jjabahuejjaqui meenaje yahuajo. Miquianaya pojjaꞌa ca mi ca oe jjashajjaꞌajjaqui pishananaje. Miquianaya ejo eꞌe jojo nei jjashahuabaqui pishana majje Eyacuiñajjiya miquianaya amee cajeꞌyo ojjaña eyaya aña jayojja jama, ma dejjaa ajjima acani amee cajeꞌyo peaꞌai. Eꞌe, miquianaaya acui jama yajjemo baꞌa: ¡Acui, nequisohuacue; ena huasijje poquicue! Majoya acui nequisohua majje ena huasijje poquiꞌyome. Jamajjeya ¡miquianaya ejo eꞌe jojo nei jjashahuabaquicue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Jesosaa pea esohui jama huohuime aca cua baꞌa: —Oe echacojji chacojeyo majje cueꞌyonaje oja emeshi meseja equi yasijje. Jamatii hueahueanaje, oya ijjiaꞌijjia sa cuanaje, jomishocaꞌyo sa cuanaje. Oya jomishocaꞌyo jjima cuanaje; ijjiaꞌijjia jjima peaꞌai cuanaje. Ma emeshi meseya oya jama huohuime acanaje baꞌa: “¡Besaquicue, pea daqui huoshocue, ecuea bobi cuacuacue! ¡Majoya ecuea bobi yecue! ¡Eya ijjiajeyoajo majoya miquea yaꞌyojjiya cuacuaꞌyocue!” ");
INSERT INTO eseNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Aꞌa ma emeshi meseya oja echacojji huohui caje oya quea bame cuanaje? Chojja, ma echacojjiya jamatii shajjaꞌajja cani emeshi meseja esohui. ");
INSERT INTO eseNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jamaya miquianaya Eyacuiñajjija esohui shajjaꞌajja majje ¡aꞌa miquianaya quea bame cuani poso jjabaquijji! ¡Aꞌa jamaya jjashahuabaquijji nequiana! ¡Jamatii miquianaya jjashajjaꞌajjaquicue oja esohuijo, ma echacojjiya jamatii shajjaꞌajja canequinaje, emeshi meseja esohui jayojja jama acanaje! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Majoya Jesosaa Jenosanena huasijje poquijeya Janinea meshi yejje ca cua. Samania meshi sahuajje jjayejjequia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Majoya aje oe cuiñajji yasijje Jesosa dobiqui jjimahuajo, dejja batata epoꞌyo ome miji peaꞌai mimi sa cua Jesosa nijje. Jamatii nequinaje quea cuiñajji huesha pishana onaja jeajea batata epoꞌyojojo. Jamajjeya oya cuana nequia cua quea huesha. ");
INSERT INTO eseNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Onaaya Jesosa jama taaame aca cua baꞌa: —Jesosa, miya ecuanaja Emeshi Mese, ¡ecuanaya che batata epoꞌyo jjajeaqui meeꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesosaa oya cuana bajea majje jama huohuime aca cua baꞌa: —Eyaya miquiana jjajeaqui meejeꞌyo, ¡poquicue Eyacuiñajjija equi yasijje! Jama huohuime acue esohui huohuijji baꞌa: “De, bacue, yahuajo pishana ecuana batata epoꞌyo cua, jjeya ca ecuana quea yami bame nee neeꞌyo”. Majoya aje Jesosaa oya cuana jjajeaqui mee caꞌya cua. Majoya aje oya cuana poquije jjayamibamequiꞌya cua, quea bihui nee nee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oe dejja ca ca jjashahuabaquia cua Jesosa bihuiajji ojaya eyami ejjajeaqui meeꞌyojojo. Majoya aje quea bihui poꞌyo majje jjanojjaquia cua; Jesosa que cue oꞌoya cua. Jjanobajjima nei Eyacuiñajji bihuia ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ecuiꞌoshajjajo nequia cua Jesosa cojja nei; oya jama cua baꞌa: —Eꞌde, Jesosa, miyaya eya jjajeaqui meeꞌyonaje, eya quea yami bame po meeꞌyonaje. Miya quea sohui poja nee nee —jamaya ma batata epoꞌyo cua. Oya Samania dejja cua, Samania meshijo baꞌe, Jodio dejja pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Majoya aje Jesosaa ona nijje nequi jama huohuime aca cua baꞌa: —¿Aꞌa cuae ome miji peaꞌai jjajeaqui meeꞌyonaje? ¿Aecue beca cuana soꞌo? Oe nei ca ca oe cueꞌyonaje e bihuiaa, Eyacuiñajji bihuiaa peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ma dejja Jodio dejja pojjeama, Samania meshijo baꞌe; beshahua nei Eyacuiñajji ojaya ba jjima. Jodio dejja cuana Eyacuiñajjija epeejji nisho. Oya cuana quea yami bame nee poꞌyo sa cuanaje Eyacuiñajji bihuiajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Majoya Jesosaa ma dejja jama aca cua baꞌa: —¡Nequisohuacue; poquicue! Miyaya eya quea yami bame epoꞌyojji huohuiꞌajjanaje. Miya ejo eꞌe jojo nei jjashahuabaquinaje ecuea ejjajeaqui meeꞌyojji. Jamajjeya eyaya miya jjajeaqui meeꞌyonaje. Eꞌe jojo nei miya jjapeequinaje Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Paniseo dejja cuaa Jesosa jama huohuiꞌajjame aca cua baꞌa: —¿Ache shono Eyacuiñajjija huoojeaꞌyo ecuea Emeshi Mese nei epojji cueje? ¿Aꞌa ohuaya ojjaña emeshi mese cuana jeajea cajeꞌyo? Jesosa jama cua baꞌa: —Chojja, ma jayojja pojjeama, de. Ojaya emeshi mese cuana ejeabichajeajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pea cuana pojjaꞌa jama mimime cuaje baꞌa: “Eyacuiñajjija huoojeaꞌyo cueyanaje pea meshi yasijje”. Siajje ca cuani, Eyacuiñajjija huoojeaꞌyo yani jjeyahua nei, jaahuana cani ojaya epeejji cuana ojjaña Eyacuiñajji nijje jjapeequiajo. Oya Emeshi Mese cuani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","25","Majoya Jesosa o shajjaꞌajjajji cuana nijje jama mimime cua baꞌa: —Ecuea epeejji nei, jjeya Jodio dejja cuaa eya quecua sa acani. Majoya aje eyahuasijje eya poquijeꞌyo. Jiquio tii eya miquiana nijje nequi ajja. Miquianaaya ca ca eya nequi mee sa ajeꞌyo minijje. Cho, nequi ajja. Beca cuaa miquianaya jama acaje baꞌa: “Cueꞌyonaje aje Jesosa jiquiacua”. Pea ca jama cuaje baꞌa: “Jesosa yani jomajo”. ¡Aꞌa eya saꞌajjajji onaa siajje acajje! Eya jocuama poqui jjima. E cue oꞌoyajo pojjejje jayojja cuaje, jeajaꞌajeaje ojjaña meshi cuana. Majoya aje ojjaña meshijo baꞌe cuaa eya ba neinei cajeꞌyo. Eya meshi yasijje cueje oꞌoya ojjañaja Doe Mese epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Yahuajo Noe baꞌya cua. Oya dobiqui jjimahuajo bishe ai yasijje, pea dejja quea mimishi nee nee cua, jjashajjaꞌajjaqui sa po ajja Eyacuiñajjija esohuijo. Jamatii oya cuana ijjiaꞌijjia ania cua; ishiꞌishi nequia cua; jjahuanaqui nequia cua. Majoya aje Noe dobiquia cua bishe ai yasijje. Ma dejja cuana ca ca jamatii jjashahuabaqui sa po ajja Eyacuiñajjijo. Oya cuana jama jjashahuabaquime pojeaꞌajja aña cua baꞌa: “Eyacuiñajjiya eseya huiꞌi meeꞌyo jjima acaje”. Cho, majoya aje Eyacuiñajjiya ena quea quemo huoojea caꞌya cua; huiꞌi mee caꞌya cua ojjaña dejja cuana, de. Ma jayojjaya e cueyajo, dejja cuana jama cuaje. Quea mimishi tii tii po nequije. ");
INSERT INTO eseNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Eꞌe de, jamaya yahuajo Noti baꞌya cua tii. Dejja cuana quea mimishi nee nee cua. Jamatii ijjiaꞌijjia ania cua, ishiꞌishi nequia cua, jjeshejjeshe nequia cuanaya cua, quiaquia nequia cuanaya cua, banabana nequia cuanaya cua, equi iya cuanaya po nequia cua. Eꞌe de, Eyacuiñajjijo jjashahuabaqui sa po ajja nei nei cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma pojjajo Noti Sonoma cuiñajjijo baꞌe cuayaquiajo Eyacuiñajjiya ena cuani jayojja cuaqui oque mee ca cua Sonomajo. Ojjaña quiyo jeyojeyoꞌya cua; chamaꞌyo tii cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","—Jamaya ojjaña cuana Eyacuiñajjijo jjashahuabaqui jjima anijo, eya cueje oꞌoya. ");
INSERT INTO eseNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jamajjeya miquianaya pojjaꞌa quejo chacochacoqui e cue oꞌoyanijo, ¡aꞌa miquianajaya equi yasijje poquijji aquiana jjequiꞌyohua! ¡Aꞌa jjashahuabaquijji miquianajaya aquiana cuanajo! ");
INSERT INTO eseNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Aꞌa pajeaꞌyojji Notija ehuanase oja aquianajo jjashahuabaquia cua! Jamajjeya oya sane pojji po mee caꞌya cua Eyacuiñajjiya ojaya aquianajo jjashahuabaquiqui jojoya. Chamaꞌyo tii oya poꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jamaya miquianajaya aquianajo jjashahuabaqui majamaja anijo miquianaya Eyacuiñajjijo jjashahuabaqui jjima cuaje, de. Jamajjeya miquianaya chamaꞌyo tii cuajeꞌyo. Eꞌe de, miquianaya ca ca jjashahuabaqui majamaja ani Eyacuiñajjijo ojaya epeejji cuaje; baꞌe tiitiijeꞌyo onijje. ");
INSERT INTO eseNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—E cue oꞌoyajo becanejjijji peaꞌai cahuijaa, oe dojosohuaqui cajeꞌyo, pea ca jeajea canajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Beca epona quecuapasha cuequi oe dojosohuaqui cajeꞌyo, pea jeajea canajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Beca dejja quejo chacochaco nequi oe dojosohuaqui cajeꞌyo, pea ca jeajea canajeꞌyo Eyacuiñajjija esohuidojojjiya —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesosa o shajjaꞌajjajjiya jama huohuiꞌajjame aca cua baꞌa: —¿Achacua acuae maya cuaje soꞌo, Jesosa? Jesosa jama cua baꞌa: —Miquianaya eya baje joya ecua beꞌo eꞌihui yasijje oqueani jama —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesosaa o shajjaꞌajjajji cuana huohui ca cua emimi majamajajji Eyacuiñajji nijje. Ohuaya jama huohuime aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Oe cuiñajjijo oe sohuinano aninaje. Oya jjapeequi sa po ajja pea dejja nijje, Eyacuiñajji nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oya cuiñajjijo tiiya oe eꞌahuemano aninaje. Ma eꞌahuemanoja aquiana peaa sii caꞌyonaje. Jamajjeya oya poqui majamajanaje sohuinano huasijje. Jamajjeya ohuaya jama huohuiꞌajjame acanaje baꞌa: “¡Che iña yohua sahuacue ma aquiana onaa sii caꞌyonajejo!” Poqui majamajanaje sohuinano huasijje huohuiꞌajjaa. ");
INSERT INTO eseNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jamatii sohuinanohua sajaꞌa jjima acanaje, de. Eꞌahuemano pajeapajeaꞌyo ajja nei nei cuanaje huohui epo tiitiinequijji jjejojo. Sohuinano jama jjashahuabaquime cuanaje baꞌa: “Eꞌe de, ma eꞌahuemano pajeapajeaꞌyo ajja nei nei, cue majamajani ca coma. Ojaya esohui shajjaꞌajja sa po ajja nei nei ca iña. ");
INSERT INTO eseNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Eyaya aje ca oya yohua sahuajeya ma ca oe oya cueꞌyo jjima tii epojji”. ");
INSERT INTO eseNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jamajojoya aje oe yohua sahua canaje —jamaya Jesosa cua. —Sohuinano yohua sahua sa po ajja cuanaje. Jamatii ohua huohuiꞌajja majamaja cajje, ohuaya epona yohua sahua canaje. ");
INSERT INTO eseNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eꞌe de, Eyacuiñajjiya sohuinano jayojja pojjeama. Jamatii oya shajjaꞌajja sa cuani miquianajaya emimi. Majoya ohuaya miquianaya yohua sahua bamebame caje. Miquianaya ojjaña pojjajo mimi tiitiianijo, ohuaya miya shajjaꞌajja cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ohuaya miya yohua sahua cajeꞌyo. Eꞌe jojo nei ecuea esohui. Jamatii e cue oꞌoyajo, ¿ae cuaje dejja cuana? ¿Aꞌa oya cuana mimi majamaja nequije Eyacuiñajji nijje? Eꞌe pojjaꞌa. ¿Aꞌa jjapeequi tiitiinequije Eyacuiñajji nijje? Eꞌe pojjaꞌa, baꞌajja —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesosaa pea dejja cuana huohui ca cua ejjabahuejjaqui meejjijo. Ma dejja cuana jjashahuaba taiquia cua jama baꞌa: —Ecuanaya ca quea bame nee cuani, beca cuana ca ca bameꞌama baꞌyani. Jamajjeya ma dejja cuana Jesosaa jama huohuime aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Yaninaje beca dejja. Oe dejja Moisesija etehueꞌyo huohuijji nisho cua, oya Paniseo dejja cuanaje. Pea dejja emeshi meseja bejjo chichajji cuanaje. Oya cuana poquinaje Eyacuiñajjija equi yasijje bihuiaa, mimiya Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Paniseo dejja dobiqui majje nequiñaquinaje ojjañaja ebajji. Oya jjabajeasohuaqui majje Eyacuiñajji nijje mimi nishonaje ojjañaja eshajjaꞌajjajji jama baꞌa: “Eꞌe de, yani eya jiquiojo, eya quea bame nee nee cuani. Eya mimishiꞌama nei, siipojji pojjeama, eya pea cojjojji pojjeama, beca cuana ca quea mimishi nee cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Eꞌe de, eya miquea esohui shajjaꞌajja majje quea bame cuani; miquea esohui jayojja baꞌyani. Ecuea 10 bejjo yanijo, eyaya mi yasijje oe quiaña. Jamatii eyaya aña; quea bejjo huiso nee nee eyaya quiaña mi yasijje, Eyacuiñajji. Eya ma dejja bejjo chichajji jomajo nequi jayojja pojjeama, eya ca mimishiꞌama nei, oya ca ca quea mimishi nee nee, de. Eꞌe de, mahuiso Eyacuiñajji ecuea esohui” jama mimi nisho nequinaje onaja ebajji Paniseo dejja. ");
INSERT INTO eseNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Majoya ca ma dejja bejjo chichajji cuani jjashahuabaqui majje miminaje Eyacuiñajji nijje. Oya quea yeno cuanaje ojaya mimishijo. Ohuaya Eyacuiñajji mimishi cuana cuijea meeꞌyo sa acanaje. Jamajjeya jama mimime cuanaje baꞌa: “Eꞌe de Eyacuiñajji, eya yani, eya quea mimishi nee nee cuanaje. Jjeya eya quea mimishi po maja sa poꞌyo ajja. ¡Jjapeequi sa cuani minijje, jamajjeya cuijeaꞌyocue ecuea mimishi cuana! Eꞌe de, mahuiso ecuea esohui, Eyacuiñajji, acua” jamaya cuanaje ma dejja. —Eyacuiñajji nijje mimijeyo majje Paniseo dejja, bejjo chichajji cuani peaꞌai poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Paniseo dejjaja mimishi cuana cuijeaꞌyo jjima cuanaje quea bame nisho baꞌejajojo. Eyacuiñajjiya bejjo chichajji cuanija mimishi cuijea caꞌyonaje, o quea mimishi po maja sa po ajjajojo. Eꞌe de, miquianaya Paniseo dejja jayojja po chanaꞌ. ¡Miquianaya ca oe pea dejja jayojjaya pocue! Majoya aje mi jjapee tiitiiquijeꞌyo Eyacuiñajji nijje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dejja cuaa eshoꞌi cuana dojo ca cua Jesosa que. Jama huohuime aca cua baꞌa: —Jesosa, ¡miyaya ecuanajaya ebacua cuana napacue emeya! ¡Miyaya Eyacuiñajji huohuicue ecuanaja bacua jaahuanajji! —jamaya cua ejeajji cuana, enaese cuana peaꞌai. Jesosa shajjaꞌajjajji cuana quea quene cuanaje ma dejja cuana nijje. Jama cua baꞌa: —¡Aꞌa ye majamajajji miquianaja bacua Jesosa que! —jamaya cua o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesosaa ca ejeajji cuana enaese cuana peaꞌai jama huohuime aca cua baꞌa: —¡Yacua oe miquianajaya bacua cuana yecue! Eyacuiñajjija quea jea nee nee ebacua cuana, ecuea peaꞌai. Oya cuana quea bame cuani, ojaya epeejji nei cuani. Jamajjeya ¡ebacua cuana aꞌa poqui meejji! ¡Ebacua cuana e que cacueꞌyahua, de! ");
INSERT INTO eseNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","¡Miquianaya Eyacuiñajjijo jjashahuaba cuajiquicue jiquio ecua eshoꞌiquiana cuani jama! Jamajje e que poquijeꞌyo eya eyajo ojjaña huoojeaꞌyojji cuaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pea pojjajo oe dejja quea aquiana huiso poquia cua Jesosa huohuiꞌajjaa. Oya jama cua baꞌa: —Jesosa, miya quea bame cuani, ¿achajja acuae po cajji Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesosa jama cua baꞌa: —¿Yajjajo acuae moya quea bame aña soꞌo? Oe neiya ca jja ca oe Eyacuiñajji quea bame nee cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Miquea eba ojaya esohui. Jamajjeya miya baꞌe tii tii sa cuani onijje, jama shajjaꞌajjame ojaya esohui acue baꞌa: ¡Aꞌa pea cojjojji pojji! ¡Aꞌa dejja quecuajji! ¡Aꞌa sii pojji; aꞌa siajje pojji! ¡Miquea chii, miquea enaese peaꞌai shajjaꞌajjacue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma dejja quea aquiana huiso jama cua baꞌa: —Eꞌe de, jamaya eyaya anaje eshoꞌyahuaa, jama tii tii sohuaqui ca ca iña. Eya oe dejja quea bame nee, de. ");
INSERT INTO eseNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesosaa ojaya esohui shajjaꞌajja majje jama huohuime aca cua baꞌa: —Aꞌyo sahua oe pea yohuaꞌajja jjima soꞌo. ¡Ojjaña miquea aquiana cuana quia jeyojeyoꞌyocue! ¡Aquiana quiajeyoꞌyo majje miquea aquiana sosejje jjeshenaje bejjo quiacue joya aemaꞌ cuana huasijje! Majoya miya Eyacuiñajji nijje jjashahuaba neineiquije, ohuaya miya baꞌe tiitii mee cajeꞌyo eyajo. Miyaya bejjo aemaꞌ cuana huasijje quiajeyoꞌyo majje majoya miquea aquiana cuanajo jjashahuabaquiꞌyo ajja cuaje, Eyacuiñajjijo ca ca jjashahuabaquije. Majoya eyahuasijje poquiꞌyo majje aquiana quea bame nee nee cuaje miquea epojji. Eꞌe, ¡jamaya acue majoya cue oꞌoyacue enijje jjapeequiya! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma esohui shajjaꞌajja majje dejja quea aquiana huiso quea yeno poꞌya cua. Oya quia sa poꞌyo ajja cua quea bejjo huiso jjejojo, quea aquiana huiso nee nee jjejojo. Poquiꞌya cua; aquiana quiaꞌyo jjima aca cua. Jjapeequi jjima Eyacuiñajji nijje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesosa quea yeno cua ma dejja quea aquiana huiso poquije ba majje; jama cua baꞌa: —Oe dejja quea bejjo huiso anijo, quea camaja ejjapeequijji Eyacuiñajji nijje. Jamatii jjashahuabaquiani ojaya aquianajo; Eyacuiñajjijo ca ca jjashahuabaqui ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Oya cameno, mona aiꞌai jama, jjayejjequi jjima cuaje ahuoja quii huejjajje jayojja. Jamaya dejja quea aquiana huiso beshahua nei poqui jjima eyahuasijje cuaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pea cuaa ojaya esohui shajjaꞌajja majje Jesosa jama huohuiꞌajjame aca cua baꞌa: —Ojjaña cuana quea bejjo huiso sa cuani, de. ¿Ae shai che poquijeꞌyo eyahuasijje Eyacuiñajji nijje baꞌeꞌyohua? ");
INSERT INTO eseNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Eꞌe de, oe dejjaa oya eyahuasijje epoqui meejji pojjeama. Eyacuiñajjiya ca mi ca oe poqui mee cajeꞌyo eyahuasijje onijje ebaꞌe tiitiiꞌyojji —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Majoya aje Peno jama cua baꞌa: —De, ecuana poqui sa cuani eyahuasijje, jeajeanaꞌyonaje ecuea aquiana jiquio meshijo minijje epoquiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesosa jama cua baꞌa: —Eꞌe, ecuea eba. Miquianaaya ojjaña aquiana cuana jeajeanaꞌyonaje epoquijji enijje. Jamajjeya miquianaya manoꞌyajo, Eyacuiñajjiya miquianaya poqui mee cajeꞌyo eyahuasijje onijje ebaꞌe tiitiiꞌyojji. Eꞌe de, miquianaaya equi jeajeanaꞌyonaje, jamajjeya Eyacuiñajjiya miquianaya sosequia caje quea huiso nee nee. Quijje miquianaya manoꞌyajo Eyacuiñajjiya quea huiso nee nee eyajo quia cajeꞌyo. Miquianaaya jeanananaje miquianajaya huanase, ebacua, miquianajaya oꞌi, miquianajaya chii peaꞌai. Eyacuiñajjiya miquianaya huapa pojjeama jayojja quiame acaje mi jaahuanajji. Eyajo peaꞌai miquianaya jama quiameya acaje quea huiso nee nee. Jamaya acaje ohuaya joya ojaya aquiana jeanaꞌyojji cuani enijje chacochacohua —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesosaa oja 12 shajjaꞌajjajji nei cuana jjachichaqui mee caꞌya cua. Ohuaya jama huohuime aca cua baꞌa: —Eꞌe de, jjeya eseya poquije Jenosanena huasijje. Miquianajaya eba Eyacuiñajjija esohui yahuajo nei nei pea cuaa ejo tehue ca cua. Joya ecua onaja tehue jaa jamaya eya acajeꞌyo cuaa. Eya mano mee cajeꞌyo ojjañaja Edoe Mese cuanijojo. Jamajjeya eya Jenosanena huasijje poqui majje manojeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Eya pea cuaa iña majje dojo caje Jodio pojjeama huasijje. Oya cuanaja ba jjima Eyacuiñajji, de. Oya cuana mimijajije enijje; ejo soaje; cojja cuichojea caje cuaa mo. ");
INSERT INTO eseNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cuia caje mo emeya cuaa, de. Majoya aje mo mano mee cajeꞌyo peaꞌai cuaa. Eya mano neineijeꞌyo. Majoya pea beca peejjima cahuime po majje, eya ca iña shequije oꞌoya, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","O shajjaꞌajjajji cuana ca ca jjashahuabaqui jjima cua Jesosaja esohuijo. Oya cuana ba jjima, yajjajo ohua o manoꞌyojji huohui cani poso jjabaquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesosa Jenico cuiñajji chipi nei poquia cua. Oe dejja cojjamaꞌ chemo po aña cua ejiojji cojja sahuajo. ");
INSERT INTO eseNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cojjamaa shajjaꞌajja ca cua dejja quea huiso cueje, jamajjeya huohuiꞌajja ca cua: —¿Aꞌya mi soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pea cuana jama cua baꞌa: —Jesosa iquio cueje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Majoya aje jama taaame cua baꞌa: —Jesosa, miya Eyacuiñajjija huoojeaꞌyo cuani. Miya ma etiiquiana emeshi mese, Dabi jayojja cuani. Eya ca iña oe che cojjamaꞌ, de. ¡Che iña jjacojjajaꞌaqui meeꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ehui dojojji pea cuana poquije jama cua baꞌa: —De, ¡quea shajjaquijjo pajjaja coma aꞌa taaajji! Oya ca ca taaa oꞌoya cua; jama cua baꞌa: —Jesosa, ¡che iña yohua sahuacue, miya Eyacuiñajjija huoojeaꞌyo! ");
INSERT INTO eseNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesosa poquije tii nequiñaquia cua. Majoya aje oya jama cua baꞌa: —¡Cojjamaꞌ e que jjequicue! Yechipi cajo Jesosaa cojjamaꞌ jama huohuiꞌajjame aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Apiojji eya miyaya taaaña, cojjamaꞌ? —Jesosa, miya ecuea Emeshi Mese nei, mi que e jjacojjajaꞌaqui meeꞌyojji mi taaanaje —jamaya cua cojjamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Eꞌe de, ¡jjeya miya quea cojja jaꞌa poꞌyocue! Eyaya miya jjabapojjaqui meeꞌyonaje ejo eꞌe jojo nei jjashahuaba bamebamequinajejojo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Majoya aje quea cojja jaꞌa nee nee poꞌya cua. Oya Jesosa nijje poquia cua. Oya jama cua baꞌa: —Eꞌe de, Eyacuiñajji quea bame nee nee, de. Jesosaa ecuea ecojja quea jaꞌa po mee caꞌyonaje, de. Pea cuaa ma ba majjeya Eyacuiñajji bihuia ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesosaa Jenico yejje canana cua; quea dejja huiso jjachichaquia cua Jesosa bajji. ");
INSERT INTO eseNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oe dejja Saqueo bajjani cua. Ojjañaja eba Saqueo quea bejjo huiso nee nee cua. Oya bejjo chichajji cua emeshi meseja yajji. Oya ca jjadasiaquijji cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ohuaya ca ca Jesosa ba sa aca cua. Jamajjeya Saqueo poquia cua Jesosa baa pea cuana ejjachichaqui nequi yasijje. Quea chiꞌaa jjejojoya ca ca oe ojaya beshahua nei Jesosa ba jjima cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jamajjeya Saqueo cuajicuaji poquia cua, ejiojji cojja sahuajo nequi acui yasijje sohuaquiñaquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesosa jjayejjeꞌajjaquia cua acui aa biajje Saqueo anijje. Majoya aje ohuaya bajeasohua majje jama aca cua baꞌa: —Saqueo, ¡oqueꞌyocue! Jjeyahua nei iña poquije miquea equi yasijje aniya! ");
INSERT INTO eseNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Majoya aje oya nequioqueꞌya cua. Majoya aje nequioqueꞌyo majje poquia cua ojaya equi yasijje Jesosa nijje. Oya quea bihui cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pea cuaa ca ca niñeba ca cua Jesosa poquije ba majje; jama mimijajime cua baꞌa: —De, Jesosa Saqueo nijje poquinaje anicuaa, Saqueo quea mimishi nee nee, de. ");
INSERT INTO eseNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Majoya aje dobiquia cua Jesosa Saqueoja equi yasijje. Quijje pishana ijjiaꞌijjiajeyo majje Saqueo nequisohuaꞌya cua. Ohuaya Jesosa jama huohuime aca cua baꞌa: —Eꞌe de, jjeyahua eyaya aemaꞌ cuana huasijje bejjo quiaje esejja. Eya siipojji nei cuanaje, de. Jjeya ca iña siipo sa poꞌyo ajja. Jamaya eyaya aje baꞌa: Eyaya oe bejjo siinaje, eyaya quiajeꞌyo ebeca pee peaꞌai bejjo. Eya mimishi po sa poꞌyo ajja. Eꞌe jojo nei ecuea esohui jjeya. Siajje pojjeama cuani —jamaya Saqueo cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesosaa oya jama huohuime aca cua baꞌa: —Eꞌe de, miya Jodio dejja nei, jamatii miya Eyacuiñajji nijje jjapeequi jjima cuanaje. Jjeya ca ca miya eꞌe jojo nei jjapeequi sa cuani Eyacuiñajji nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Eꞌe, eya cueyanaje ojjaña jjapeequi meeya Eyacuiñajji nijje. Eyaya mi jayojja pea cuana ba sa aña —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesosaja esohui shajjaꞌajja majje pea cuaa jama aca cua baꞌa: —Jesosa, Jenosanena huasijje poqui majje miya ojjañaja Emeshi Mese cuaje, jjeya nei pojjaꞌa. Ecuana jamajjeya mijo quea bihui nee nee cuajeꞌyo —jamaya poso aca cua dejja cuaa. ");
INSERT INTO eseNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jamajjeya Jesosaa oe esohui ejjashahuaba quimeejjijo jama huohuime aca cua baꞌa: —Oe dejja emeshi mese epoꞌyojji pea meshi yasijje poquinaje. Majoya oya emeshi mese epojji bajjani caꞌyajje huacuaya cueꞌyonaje o nequinaje meshi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Poqui jjimahuaa ohuaya iyaa canaje ojaya ome miji peaꞌai echacojji cuana bejjo equiajji. Ojjaña oe ebashosocojo bejjo quea huiso quia canaje. Jama huohuime acanaje baꞌa: “Eꞌe de, jiquio bejjo eyaya miquianaya quiaña, aquiana jjeshejji. ¡Esose quea huisojo bejjo jjahuisoqui meecue! Eya cueꞌyo majje quea huiso bejjo bañajeꞌyo. Eya majoya quea bihui cuaje” jamaya cua ma emeshi mese poqui jjimahua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Majoya aje emeshi mese poquinaje pea meshi yasijje emeshi mese epojji ohua bajjani caꞌyajje. Oja meshijo nequi dejja cuanaja botiꞌama cua. Jamajjeya dejja cuaa oe dejja huohui pohua ma meshi yasijje huoojea ca cua. Jama huohuime aca cua baꞌa: “Ecuanajaya ma dejja emeshi mese cuajo botiꞌama cuaje”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Oya ca ca bajjani caꞌyajje emeshi mese cuanaje. Jamajjeya ma dejja huacuaya cue oꞌoya cua oja meshi yasijje. Cue oꞌoya majje iyaa mee ca cua ojaya echacojji cuana ehuohuiꞌajjajji, ache huiso bejjo chicha canaje ebajji. ");
INSERT INTO eseNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ebionei oe echacojji poquinaje o que. Jama cua baꞌa: “Emeshi mese, miquea bejjo quea huiso nee nee chichanaje. Miyaya eya oe bashosoco bejjo quianaje, jjeya ca ca yani ome miji peaꞌai bashosocome bejjo. Eyaya chaco neineinaje, de”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Emeshi meseya jama acanaje baꞌa: “Eꞌe de, miya oe echacojji quea bame nee cuanaje. Jjeyahua nei miya emeshi mese jayojja aje, ¡ome miji peaꞌai cuiñajji jaahuanacue, miyaya quea bame cuanajeya jjejojo!” ");
INSERT INTO eseNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Pea echacojji poquinaje emeshi mese que. Jama huohuime acanaje baꞌa: “Emeshi mese, miyaya bejjo oe bashosoco quianaje. Jjeya ca ca eyaya iyehuiso chichanaje me oejje bashosocome bejjo. Eꞌe de, eyaya chaco neineinaje peaꞌai”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jamajjeya emeshi mese jama cuanaje baꞌa: “Eꞌe de, miya quea bame cuanaje. Miya emeshi mese jayojja aje, ¡me oejje cuiñajji jaahuanacue!” ");
INSERT INTO eseNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Pea echacojji poquinaje o que. Oya jama cuanaje baꞌa: “Emeshi mese, maꞌaje miquea oe bashosoco bejjo. Quia jjimajje bejjo cuanaje. Eja sisijo bebo majje jaahuana neineinaje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Eꞌe de, miya etecueaje poso ca ca mi quianaje. Ecuea miya eba dejja quenequene cuajijji nei nei. Quea dejja taija jjejojo miquea aquiana quea huiso yani. Jamajjeya eya quea mete cuanaje miquea bejjo quiajji. Jamajjeya jaahuananaje miquea bejjo nei”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Majoya aje emeshi meseya oya tecuea canaje. Oya jama cuanaje baꞌa: “Siajje miya, de. Miquea ejjashahuaba taiquijji jayojja jama eyaya miya aje. Miya shajjamaꞌ cuanaje; jjahuisoqui mee jjimaya ecua bejjo anaje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¡Bacue, ecue bejjo oya huiso tii miyaya jaahuananaje! ¿Apiojji miyaya bejjo ejjeshejji jaajji equi yasijje mi iyaquinaje, ejjahuisoquijji? Miyaya chacochaco jjima cuanaje, de”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Emeshi mese oya cuana jomajo nequi jama huohuime acanaje baꞌa: “Eꞌe de, ¡jjequisejajeaꞌyocue ecue quia bejjo ma echacojji shajjamaꞌ cuanajeja! ¡Quiaꞌyocue ma ebionei echacojji cuanaje yasijje, ma quea huiso bejjo chichajji cuanaje yasijje!” jamaya emeshi meseya acanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Oya cuana jama cuanaje baꞌa: “Emeshi mese, miquea ebionei echacojji ca ca quea bejjo huiso cuani. Yani ojaya ome miji peaꞌai huisome, de”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Majoya aje emeshi meseya jama acanaje baꞌa: “¡Shajjaꞌajjacue ecuea esohui eꞌe jojo nei! Oe dejja chacochaco ani quea bame, shajjaꞌajja cani ecuea esohui, eyaya quiaje quea huiso nee nee. Oe dejja ca ca chacochaco ajja, shajjamaꞌ cuani, eyaya quia jjima aje. Iñajeꞌyo ojjaña ojaya aquiana o shajjamaꞌ jojoya. ");
INSERT INTO eseNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Eꞌe de, pea dejja cuanaja eya botiꞌama. Oya cuana eya emeshi mese epojji sa po ajja ca ca oya. ¡Ma dejja cuana yecue eque! E cojja nei nequia majje ¡quecuajeacue ojjañaja ebajji!” cuanaje ma emeshi mese, de —jamaya aca cua Jesosaa. Oya huohui ca cua ma esohui ojjañaja ebajji eseya cachacochacoꞌyahua Jesosaja yajjijo quea bame nee, eseya cajjashajjaꞌajjaquiꞌyahua ojaya esohuijo peaꞌai. Eseyaya quea huiso onijje cajjapeequi meeꞌyahua. Majoya Jesosa cue oꞌoya majje ojaya epeejji quea huiso cuaje. Majoya oya jama cuaje baꞌa: “Miquianaya quea bame cuanaje; jjapeequi meenaje quea huiso nee ecuea epeejji epojji. ¡Jamajjeya poquicue enijje eyahuasijje! Beca cuana ca ca jeajeaje cuaqui yasijje shajjamajojo, de”. ");
INSERT INTO eseNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Majoya Jesosa mimijeyo majje poquia cua Jenosanena huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Poquijeya ba cañaquia cua beca cuiñajji Mepaje, Betania peaꞌai. Ma cuiñajji cuana chipi neijo eyiyo nequi yohua bajjani baꞌa: Onimo. Majoya Jesosaa becanejjijji peaꞌai o shajjaꞌajjajji cuana huoojea ca cua. Jesosaa oya cuana jama huohuime aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—¡Poquicue jocuama ma cuiñajjijo chipi nei! ¡Bañaqui majje bacue mapichi eshoꞌi ai ejeyonequia nequi! ¡Ba majjeya oe pichocue! ¡Picho majje yecue! ¡Joya onaja eꞌanisohuaquijji ajjima nei nei oe yecue! ");
INSERT INTO eseNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Onaa: “¿Apiojji acuae ecuea mapichi pichojeaña soꞌo?” acajje, oe jama huohuime acue baꞌa: “¡Mapichi jjequicue!” Jesosa cuanaje. Oya pa mapichi sa cuani, de, acue. ");
INSERT INTO eseNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Majoya aje oya cuana poquia cua; bacañaquia cua mapichi. Majoya aje bañaqui majje pichojea ca cua ma ecua Jesosaa huohui ca cua jama pichojeameya aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Majoya aje emapichi mese cuaa ba ca cua, mapichi picho cuequi. Majoya aje ba majje emapichi meseya Jesosaja eshajjaꞌajjajji cuana jama huohuiꞌajjame aca cua baꞌa: —¿Apiojji acuaeya ecua mapichi pichojeaña soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oya cuana jama cua baꞌa: —Jesosaa sa canijojo ca ca ecuaaya pichojeaña. ");
INSERT INTO eseNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Majoya aje dojo ca cua Jesosa que. Daqui iya ca cua mapichija edaasa biajje. Majoya Jesosa anisohuaquia cua mapichija edaasa biajje; poquia cua Jenosanena huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesosa poquianijo jjachichaquia cua ojjaña dejja cuana ejiojji sahuajo. Onaaya daqui ao jjequi jeapiihui ca cua ejiojjijo Jesosa jaꞌajjequijji. Emeshi mese jama jaꞌajjequimeya acaninaje cuaa ohua ba cahuajje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eyiyo Onimojo ani jaaoque majje ojjaña Jesosaja epeejji cuana quea bihui nee nee cua. Sohuicuayaña cua jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Eyacuiñajji, miya quea bame nee nee. Miyaya Jesosa huoojeanaje ecuea Emeshi Mese epojji jjeya nei. Ecuana quea bihui nee nee. Ojjaña meshijo baꞌe cuana, eyajo baꞌe cuana peaꞌai quea bei cuani —jama sohuicuayameya cua cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Majoya Paniseo dejja cuaa quea dejja huiso pejjejo nequiya sohuicuayaqui shajjaꞌajja majje quea quene nee nee cua. Jamajjeya oya cuaa Jesosa jama huohuiꞌajjame aca cua baꞌa: —Jesosa, ¡miquea epeejji cuana huohuicue: “¡Aꞌa sohuicuayajji!” acue! —jamaya cua Paniseo dejja cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Majoya aje Jesosaa jama sajaꞌame aca cua baꞌa: —Chojja de, eyaya ecuea epeejji cuana: “¡Aꞌa sohuicuayajji!” ajo, mei sohuicuayaje, de. Ojjañaa jja ca oe jjeya cabihuia cahua Eyacuiñajji —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Quijje pishana Jenosanena bañaqui majje Jesosa pa neineiya cua Jenosanenajo baꞌe cuana ojaya esohuijo shajjamajojo. ");
INSERT INTO eseNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Oya jama mimimeya cua baꞌa: —Eya quea yeno nee nee jiquio cuiñajjijo baꞌeca cuanajo, oya cuana quea mimishi nee nee jojoya. Oya cuana mimishi cuana pajeaꞌyo sa po ajja nei nei, de. Jamajjeya aje jja oe quea nee nee cuajeꞌyo, ecuea epeejji po sa po ajja cuanajejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sohuinano cuana cueje o quecuaꞌyohua. Sohuinano cuana jjanequitoquijeꞌyo jiquio cuiñajjijo. Majoya oya cuana cuayaqui ajja nei nei cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Majoya aje oya cuana quecua jeyojeyo cajeꞌyo, chamaꞌyo tii acajeꞌyo. Equi cuana dahuajea jeyojeyo cajeꞌyo chamaꞌyo epoꞌyojji. Jamaya cuaje oya cuana ecuea esohuijo shajjamaꞌ cuanajejojo, eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji cajaa acanajejojo —jamaya cua Jesosa Jenosanenajo baꞌe cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Majoya Jesosa dobiquia cua Eyacuiñajjija equi yasijje. Dobiqui majje Jesosaa beca cuana aquiana quia cuequi ba ca cua. Ma ba majjeya quea quene nee nee cua. Majoya aje Jesosaa ma aquiana quia cuequi jeacuayajea ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ohuaya jama tecueame aca cua baꞌa: —Eyacuiñajjija etehueꞌyo jama cuani baꞌa: “Eyacuiñajjija equi onijje emimijji”. Aquiana quiajji pojjeama, ona siajje ajji pojjeama peaꞌai —jama tecuetecuemeya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ojjaña pojjajo Jesosaa esohui huohui ca nequia cua Eyacuiñajjija equijo. Jamatii Eyacuiñajji nijje mimiani etii cuaa, Moisesija etehueꞌyo huohuijji cuaa, emeshi meseya peaꞌaiya Jesosa saꞌajja ca cua equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jamajjeya esohui huohuijji cuana jama jjashahuabaquimeya cua baꞌa: —Quea camaja ca eꞌiñajji Jesosa equecuaꞌyojji, oya quea epeejji huiso nee nee aña. Shajjaꞌajja neinei cani ojaya esohui cuaa, de. ");
INSERT INTO eseNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Oe pojjajo Jesosaa esohui huohui ca cua Eyacuiñajjija equijo. Jesosa que cueya cua Eyacuiñajji nijje mimiani etii cuana, Moisesija etehueꞌyo huohuijji etii cuana Jodio etiiquiana peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Oya cuaa Jesosa jama huohuiꞌajjame aca cua baꞌa: —¿Aya acuae mi huoojea canaje esohui huohuiya soꞌo? —jamaya aca cuaa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesosa jama cua baꞌa: —Eyaya peaꞌai miquianaya huohuiꞌajjaje. ");
INSERT INTO eseNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Aya acuae Huani ma ona besameejji cuanaje huoojea canaje soꞌo? ¿Aꞌa Eyacuiñajjiya pojjaꞌa? ¿Aꞌa dejja cuaa pojjaꞌa? ¡Huohuiꞌajja socue mo! Majoya eyaya miquianaya huohuije ajea huoojea acuae eya. ");
INSERT INTO eseNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Oya cuana mimipanajajia cua. Majoya aje jama aca cua baꞌa: —¿Yajja sajaꞌame seya aje soꞌo? Eseya quea mete ojjaña dejja cuanajo, de. Eseya sajaꞌajje jama cuaje baꞌa: “Eyacuiñajjiya Huani huoojea canaje”. Majoya pojjaꞌa Jesosaa jama sajaꞌame acaje baꞌa: “¿Yajjajo miquiaaya cajaa Huanija esohui anaje soꞌo?” ");
INSERT INTO eseNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Eseya jama ajje baꞌa: “Dejja cuaa Huani huoojea canaje”. Ojjaña dejja cuaa se jaja caꞌyo chanaꞌ meiya, ojjaña dejja jjashahuabaquiani Eyacuiñajjiya Huani huoojea canajejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jamajjeya jjashahuabaqui majje Jodio cuaa Jesosa jama sajaꞌame aca cua baꞌa: —Cuaꞌa de. Ecuanajaya ba jjima nei. ¿Aya shai Huani huoojea canaje? —anisho ca cua quea meteya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Majoya Jesosa jama cua baꞌa: —Eꞌe de, jamajjeya ecuea miquianaya ehuohuijji pojjeama e huoojeajji epo —jamaya Jesosaa Jodio dejja cuana aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesosaa dejja cuana jama huohuime aca cua baꞌa: —¡Jiquio ejjashahuabaquiꞌyojji shajjaꞌajjacue! Oe eque meseya jjonojjajja bana canaje. Ojaya que quea quemo nee nee cuanaje; oopana jjono bana canaje. Ma jjono yohua bajjani cuanaje baꞌa: uva. Ma jjono cuana bana majje ohuaya echacojji cuana cuiña mee canaje. Ohuaya ejjajja cuiñajji cuana jama huohuime aca cua baꞌa: “Jjonojjajja jahuajeyajo miquianajaya yajji esejja acue. Pea esejja ca ca ecuea cuaje”. Majoya ojaya que cuiña mee majje quea huesha poquinaje quijje nei nei cueꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Quijje jjonojjajja jahuajo ohuaya ma pea meshijo baꞌe ojaya pea echacojji huoojea canaje jjonojjajja cuiñajji cuana huasijje. Ma echacojji jjonojjajja cuiñajji cuana huasijje poqui majje jama huohuiꞌajjame acañaquinaje baꞌa: “Eya eque meseya miquiana que huoojea canaje jjonojjajja esejja jjehuaꞌyohua. ¿Ache acuae pa eque meseja iya tepe mee?” Majoya ejjajja cuiñajji cuana quea dejja ta jjejojo quea quene cuanaje eque meseja huoojeajji nijje. Jama cuanaje baꞌa: “Cho, quia sa po ajja iña. Chamaꞌ ca jjaja ca oja, ecuea ca jjaja ca oe”. Majoya ejjajja cuiñajji cuaa echacojji cuiajea canaje. Cuiajea majje huoojeajea caꞌyonaje eque mese yasijje; jamatii poquiꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Majoya eque meseya pea echacojji huoojea ca oꞌoyanaje huacuayaya. Huohuiꞌajja cañaqui oꞌoyanaje jama baꞌa: “¿Ache acuae eque meseja jjonojjajja soꞌo?” Majoya quia sa po ajjaa jjejojo cuiajea ca oꞌoyanaje. Poqui oꞌoyanaje jamatiiya, de. ");
INSERT INTO eseNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eque meseya pea echacojji huoojea ca oꞌoyanaje huacuayaya. Eꞌe de, ma pea poqui majje jama huohuiꞌajjame acañaqui oꞌoyanaje baꞌa: “¿Ache acuae pajjaja eque meseja jjonojjajja soꞌo? Eyaya cadojoꞌyahua o que”. Majoya jjonojjajja cuiñajji cuana quenequene neineinaje onijje. Quecuajeaꞌajja canaje jjonojjajja cuiñajji cuaa. Poquiꞌyonaje echacojji jamatii eque mese yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—Majoya eque mese jjashahuabaquiꞌyonaje oja quejo. Oya jama cuanaje baꞌa: “¿Yajja acuae eyaya ajeꞌyo soꞌo? Ecue bacua ejja pojjaꞌa cahuoojeahua. Eꞌe, oya poqui majje ma jjonojjajja cuiñajji cuaa oya ba caje. O ba majje pojjaꞌa jjashajjaꞌajjaquije. Baꞌajja”. Majoya aje oja bacua ejja huoojea canaje jjonojjajja cuiñajji cuana huasijje. Jjonojjajja jjequiꞌyohua nisho huoojeaꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Majoya aje onaaya ebacua ba canaje. Jama cuanaje baꞌa: “Bacue, eque meseja ebacua ejja cueyanaje, de. Cuaꞌa ejjaquecuajeaqui oe eque mesenaꞌyojji” jama jjashahuaba taiquimeya cuanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jamajjeya jjonojjajja cuiñajji cuaa eque meseja bacua ejja quecua caꞌyonaje. Majoya aje quea huesha nee nee jeajea canaje —jamaya Jesosa cua—. ¿Yajja acuae eque meseya acajeꞌyo jjonojjajja cuiñajji cuana? ");
INSERT INTO eseNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eque mese poquije jjonojjajja cuiñajji cuana quecuajeaa oja bacua ejja quecuaꞌyo epo jojoya. Majoya aje pea dejja que cuiña meequi cajeꞌyo —jamaya Jesosa cua. Dejja cuana jama cua baꞌa: —De, jjonojjajja cuiñajji cuana quea mimishi nee nee, de. Chamaꞌ ca jjaja ca dejja cuajjama mimishi. ");
INSERT INTO eseNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesosaa cojja ba oneone ca cua ma dejja cuana. Majoya aje oya jama cua baꞌa: —Eꞌe de, yani jjaja, de. ¿Aꞌa jjaja miquianajaya ba jjima Eyacuiñajjija etehueꞌyo pojjaꞌa? Ba jjima pojjaꞌa jjajajje, jamajjeya aje mi eyaya jama huohuime aje baꞌa: Jamatii dejja cuaa oe equi iyajji, equi yamajjana quea caꞌa nee nee saꞌajja cani. Beca cuaa jeajea cani acui caꞌa quea bame pojjeama posojojo. Pea dejjaja eba nei nei acui yamajjana equi iyajji. Jama cuaje ma acui caꞌajo baꞌa: “Jiquio aje jja oe acui quea caꞌa nee nee baꞌa, de. Jamajjeya aje jja oe eyaya dojojeꞌyo quea bame nee nee jojoya”. Jamaya Eyacuiñajjiya eya babaca canaje Emeshi Mese nei quea bame nee nee epojji acui quea bame jayojja. ");
INSERT INTO eseNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Eꞌe de, miquianaaya ca ca eya cajaa aje, ma acui cajaa onaa acanaje jayojja. Ojjaña joya eya Emeshi Mese epojji cajaa acajo Eyacuiñajjiya jeajea cajeꞌyo cuaqui yasijje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesosaja esohui shajjaꞌajja majje Eyacuiñajji nijje mimiani etii cuana, Moisesija etehueꞌyo huohuijji cuana peaꞌai quea quene nee nee cua. Oya cuana jjajaꞌaqui majje jama mimimimime ojee cua baꞌa: —¡De! Aꞌa jja ca eseya jama acani, de. Oya mimiani eseya jjonojjajja cuiñajji cuana jayojja, de. Pea cuaa Jesosa cajaa acanaje jayojja eseyaya cajaa aje peaꞌai pa —jamaya ma Jodio dejja cuana cua. Jamajjeya Jodio dejja cuaa Jesosa iña sa aca cua ejeanobiajji nisho. Ojaya epeejji cuana quea huisojojo, Jesosa mi iña ca cuaa cua. Jama cua baꞌa: —De, eseya o iñajo dejja cuana quea quene nee nee cuaje ese nijje —jamaya cua Jodio dejja cuana; Jesosa iña jjima cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Majoya Eyacuiñajjija esohui huohuijji cuaa pea dejja cuana Jesosa iñajji nisho bejjo quia ca cua. Ma dejja cuana poquia cua Jesosa baa; dejja quea bame nisho cua. Huohuiꞌajja ca cua Jesosa ojaya yajja sajaꞌame yaꞌyojji nisho. Jamajjeya Moisesija etehueꞌyo jayojja jama mi sajaꞌa cajo dojo ca quiaye sohuinano huasijje jeanobiaa. ");
INSERT INTO eseNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma dejja quea bame nisho cuaa Jesosa jama huohuiꞌajjame aca cua baꞌa: —Jesosa, ecuanaja eba miyaya eꞌe jojo nei huohuiaña Eyacuiñajjija esohui nei. Miyaya baña dejja cuana oya jayojjaya cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¡Jamajjeya mo oe che huohuicue! ¿Aꞌa jamajjeya Eyacuiñajjija epeejji cuaa bejjo quia cajji emeshi meseja yajji? Quia ca ajja pojjaꞌa. ");
INSERT INTO eseNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesosaja eba cuanaje Jodio cuanaja ejjashahuabaquijji. Jamajjeya ohuaya jama huohuiꞌajjame aca cua baꞌa: —¿Apiojji acuae nequiaa iña dasia sa aña soꞌo? Miquianaya ca ca ecuea epeejji nisho cuani, de. ");
INSERT INTO eseNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","¡Jjequicue bejjo esodojjo ebajji, emeshi meseja epanaꞌyojji! Majoya oya cuaa oe bejjo jjequi ca cua. Jjequi cajo, Jesosaa jama huohuiꞌajjame aca cua baꞌa: —¿Bejjojo ae ecajjaꞌyo ani? ¿Ae bajjani tehuemeꞌya bejjo? —jamaya Jesosa cua. —Emeshi mese oja cajjaꞌyo, Sesa bajjani. ");
INSERT INTO eseNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Majoya aje Jesosa jama cua baꞌa: —Jamajjeya ¡Sesaja bejjo quiaquicue ohua sa cajo! ¡Eyacuiñajji aꞌa pajeaꞌyojji; oya bihuiacue; shajjaꞌajjacue peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma epeejji nisho cuana quea mete nee nee cua Jesosaja ojaya ejjashahuabaquijji ebajojo. Jamajjeya jama cuana cua baꞌa: —Quea jjashahuabaqui jaꞌa nee oya, Jesosa. Jjadasia meequi ajja, de —jamaya cua ma epeejji nisho cuana. Jamajjeya mimi oꞌoya sa po ajja Jesosa nijje. Jamajjeya Jesosa iña jjima cuanaja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma pojjajo tii Sanoseo dejja cuana poquia cua Jesosa huohuiꞌajjaa. Sanoseo dejja cuana jamatii jjashahuabaquia cua pea cuana manoꞌyo majje eshequi oꞌoyajji pojjeama. Jesosaja ca ca jama sohui huohuime ajjima cua. Jamajjeya Sanoseo dejja cuaa oya edasiajji nisho aca cua. Majoya aje jama huohuiꞌajjame aca cuaa cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Esohui huohuijji, Moisesiya jama tehueme aca cua yahuajo nei nei baꞌa: “Oe dejja jjahuanaquinaje. Majoya aje manoꞌya cua bacuamahua. Ojaya ehuanase quijjojea ca cua. Ahuemaꞌ aniꞌya cua jjamejoqui jjimahua quijjojea. Majoya aje ahuemanoꞌyajo oja chahuaa cahuana caꞌyahua, oja doeja bacua jea jayojja nei epojji”. ");
INSERT INTO eseNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jamajjeya jama cuaje pojjaꞌa baꞌa: Oe dejja quea doe huiso cua, me oejje pea becanejjijji peaꞌai nequia cua. Ma dejjaa epona huana ca cua. Majoya manoꞌya cua; bacuamahua quijjojea ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma dejjaja quijjojea ani echahua meseya huana ca oꞌoyanaje. Bacua jea jjimahua quijjojea ca oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Majoya pea echahua meseya huana ca oꞌoyanaje. Majoya pea echahua meseya huanaꞌajja ca poquiapoquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Majoya aje oya epona manoꞌyonaje yahueja quijjojea ani tiiya. Jjamejoqui ajja cuanaje, bacuamaꞌ nei nei tii pona cuanaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jamajjeya miquea esohui jama cuani eyajo shequi oꞌoya majje ¿ajea ehuanase jiquio cuaje eyajo; ache oja doeja? O huanacoojji epoja pojjaꞌa, pea echahua meseja pojjaꞌa; oja chahua cuana ahuiaꞌajjaꞌyo epo —jamaya cua Sanoseo dejja cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesosaa jama aca cua baꞌa: —De, miquianajaya ba jjima. Jiquio meshijo dejja cuana jjahuanaquiani; epona cuana jjahuiaquiani. ");
INSERT INTO eseNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jamajjeya jiquio meshijo Eyacuiñajjija epeejji manoꞌyo majje eyahuasijje poquijeꞌyo. Ejjahuanaquiꞌyojji pojjeama cuajeꞌyo eyajo; epona cuana peaꞌai ejjahuiaquiꞌyojji pojjeama cuajeꞌyo eyajo. Jjamejoqui ajja peaꞌai cuajeꞌyo eyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Manoꞌyo ajja cuaje jomajo; esohuidojojji jayojja jama cuajeꞌyo. Eyajo ojjaña Eyacuiñajjija ebacua cuajeꞌyo, eshequiꞌyo jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","¿Aꞌa miquea ba jjima dejja cuana ojjaña manoꞌyo majje shequije oꞌoya? Jamajjeya Eyacuiñajjiya yahuajo nei esohui tehue mee ca cua miquiana jjabahuejjaquijji. Moisesiya tehue ca cua yahuajo nei nei ma acui jijiqui ba majje. Eyacuiñajji mimia cua onijje jama baꞌa: “Eyaya miquea etiiquiana cuana jaahuanaña, Amajama, Isaaca, Jacobo peaꞌai ecuea epeejjijojo. Oya cuana enijje enequi tii tii”. ");
INSERT INTO eseNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eyacuiñajji emanoꞌyo cuana meshijo eꞌohuajeajaa jaahuanajji pojjeama cuani. Eshe nequi cuana, emanoꞌyo shequiꞌyo cuana peaꞌai eyajo ohuaya jaahuana cani ojaya epeejjijojo —jamaya aca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pea Moisesija etehueꞌyo huohuijji cuaa jama huohuime aca cua baꞌa: —Eꞌe de, quea jaꞌa nee nee miquea esohui, Jesosa. Quea bame nee nee, de. ");
INSERT INTO eseNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Majoya huohuiꞌajja becaꞌyo jjima tii aca cuaa cua quea meteya jjejojo, jjadasia meequi ajjajojo. ");
INSERT INTO eseNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesosaa oya cuana jama aca cua baꞌa: —Miquianaya jama jjashahuaba taiquime cuani baꞌa: “Jesosa Dabija osecua poso nequiaa aña. Jamajjeya oya Eyacuiñajjija Bacua pojjeama poso nequiaa aña” jamaya jjashahuaba taiquimeya nequiana cuani. Dabi emeshi mese yahuajo nei nei baꞌya cua. Eya ojaya eba nei nei, de. Ojaya eya eba dejjaja bacua ejja pojjeama, Eyacuiñajjija Bacua Ejja. ");
INSERT INTO eseNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Jamajjeya ohuaya esohuicuayajji tehue ca cua Salmojo; jama cua baꞌa: “Eyacuiñajjiya ecuea Emeshi Mese Quito jama huohuime acanaje baꞌa: —¡Enijje anioquecue ebañei mijijje ojjañaja Emeshi Mese epojji! ");
INSERT INTO eseNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Eyaya mi quecuaꞌyojji epo jeabichajea jeyojeyojeꞌyo. Majoya aje miyaya oya cuana jeajeajeꞌyo cuaqui yasijje cajaajojo —jamaya aca cua Eyacuiñajjiya”. Jamaya Dabiya ejo tehue ca cua yahuajo nei nei. ");
INSERT INTO eseNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jamajjeya Dabiya Quito oja Emeshi Mesejojo bajjani ca cua. Jamajjeya Quito Dabija osecua cua, ojaya Emeshi Mese nei. Eya jja iña iquio Quito, de, dejjaja bacua pojjeama; Eyacuiñajjija Bacua Ejja, jamajjeya eya ojjañaja Emeshi Mese nei —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Ojjañaa Jesosaja esohui shajjaꞌajja canijo, Jesosaa o shajjaꞌajjajji cuana jama aca cua baꞌa: —Coya mi oe Moisesija etehueꞌyo huohuijji jayojja po chanaꞌ. Oya cuana poꞌayequiequi daqui aojji ojjañaja quea bame ebajji nishoya. Oya cuana quea bihui cuani shajjaꞌajja majje ojjañaja esohui jama cuani baꞌa: “Ma esohui huohuijji quea bame cuani, oja daqui quea bame, oja esohui quea jaꞌa nee” jamaya shajjaꞌajja saya cuani ma esohui huohuijji cuana. ¡Eꞌe jojo nei pojjeama! Jodioja equi ejjachichajji yasijje dobiqui majje ebionei anioque sa cuani Eyacuiñajjija esohui huohuijji pejjejo. Eꞌijjiaꞌijjiajjijo peaꞌai anioque sa cuani equi mese pejjejo. Beca cuaa quea bame poso acani. ");
INSERT INTO eseNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eꞌahuemanoja aquiana sii cani o chaco sahuajji nisho po majje. Majoya oya cuana mimi nisho ani Eyacuiñajji nijje. Oya quea mimishi nee nee. Eyacuiñajjiya oya cuana jeajea cajeꞌyo cuaqui yasijje, onijje mimi nishojjijojo —jamaya cuana Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Eyacuiñajjija equijo, Jesosaa dejja cuana quea aquiana huiso nequi ba ca cua. Ma dejja cuaa bejjo iya ca cua ejjeshejji iyajji yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Majoya eꞌahuemano aemaꞌ nei neiya bejjo iya ca cua. Becanejjijji peaꞌai bejjo ojaya cua, oe pojji nei nei cua, de. Chamaꞌyo cua ojaya bejjo ohua iya cajje bejjo iyajji yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Majoya Jesosa jama cua baꞌa: —Eꞌe, jiquio eꞌahuemano quea bame cuanaje. Ohuaya ojjaña tii bejjo iya caꞌyonaje. Jamajjeya Eyacuiñajji quea bihui cuanaje onijje. ");
INSERT INTO eseNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Quea aquiana huiso nee nee cuaa ca ca oja quiabishi iya canaje. Quea bame pojjeama ca ca oya cuana. Ma eꞌahuemanohua iya canaje ojaya bejjo bobi jjeshejji nisho, de. Chamaꞌyo ojaya bejjo poꞌyonaje. Jamajjeya quea aquiana huiso nee nee cuana quea bame pojjeama cuanaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Beca cuana mimia cua Eyacuiñajjija equijo jama baꞌa: —¡De, bacue mei quea bame, aquiana quea bame ani Eyacuiñajjija equijo! Aquiana quea bame sosemaꞌ quia Eyacuiñajjija equi quea bame epojji. Majoya aje Jesosaa jama aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Eꞌe de, quijje pishana jiquio equi, aquiana peaꞌai chamaꞌyo tii acajeꞌyo, de. Ma mei bame cuana pea biajje eꞌiya sohuaꞌyojji pojjeama. Pea cuaa ma equi cajjajeajea cajeꞌyo —jamaya cua Jesosa Eyacuiñajjija equijo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Majoya o shajjaꞌajjajji cuaa jama huohuiꞌajjame aca cua baꞌa: —Jesosa ecuea esohui huohuijji, ¿ache shono acuae shai pea cuaa Eyacuiñajjija equi mei cuana cajjajeajea mee cajeꞌyo? ¿Yajja acuae acaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesosa jama cua baꞌa: —Ma Eyacuiñajjija equi quea bame cajjajeajeaꞌyo jjimahuajo, jamaya cuaje baꞌa: Quea huiso nee nee cueje e bajjani nisho po majje. Jama mimi nishome cuaje baꞌa: “Eya Jesosa Quito bajjani, de”. Pea jama cuaje baꞌa: “Eya jjeyahua nei cue oꞌoyanaje, eya Quito, Eyacuiñajjija huoojeaꞌyo”. ¡Aꞌa ojaya esohui shajjaꞌajjajji! Siajje ca cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Miquiaaya shajjaꞌajjaje pea meshijo baꞌe cuana jjaquecuaquiequi pea meshijo baꞌe cuana nijje. ¡Aꞌa miquianaya quea mete pojji! Jamatii acua pojjeama oe po ajja jjima cuaje soꞌo —Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dejja cuana jjaquecuaquijeꞌyo ojjaña meshijo baꞌe cuana, cuiñajjijo baꞌe cuana peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Quea huiso emano meejjiya mano mee cajeꞌyo. Ojjaña quea mete nee nee cuaje, de. Bobimaꞌ cuaje, manojeꞌyo quea dejja huiso cuana bobimajo. Meshi huehuahuehuaje ojjaña meshi yasijje peaꞌai, de. Ojjaña quea mete nee nee cuajeꞌyo eyatahuatahua huehuahuehuajo meshi huehuahuehuajo peaꞌai, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Jiquio jama po jjimahuajo beca cuaa miquianaya quea nee po mee cajeꞌyo ecuea epeejji cuanijojo. Oya cuanaja botiꞌama nee nee cuaje, de. Miquianaya iña majje dojo caje jeanobiajeaa Jodioja equi ejjachichaquijji cuana huasijje. Dojo caje miquianaya emeshi mese nequi cojja nei yasijje. Majoya ohuaya jama huohuiꞌajjame acaje baꞌa: “¿Aꞌa miquianaya Jesosaja epeejji nei?” Eꞌe jojo neijojo, miquianaya jeanobiajea caje. ");
INSERT INTO eseNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jama po majjeya ¡aꞌa quea mete pojji! Miquianaya ejo huohuije ma emeshi mese yasijje. Jamajjeya quea huiso emeshi mese cuaa shajjaꞌajja caje ecuea esohui Eyacuiñajjija esohui peaꞌai —jamaya Jesosa cua—. ");
INSERT INTO eseNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eꞌe, ¡aꞌa quea mete pojji ache esohui miquianaaya huohuijeꞌyo! ");
INSERT INTO eseNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eyaya nei miquianaya quea jaꞌa nee po meeje. Eyaya esohui huohui sahuaje ehuohuijji ejo. Ma pojjajo pea cuanaja miya esajaꞌajji pojjeama miquianajaya esohui quea jaꞌajojo. Miquianajaya esohui eꞌe jojo nei cuaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Miquianajaya huapa pojjeama cuaa, miquianajaya epeejji cuaa peaꞌaiya dojo caje ejjajeanobiajeaquijji equi yasijje miquianaya ecuea epeejjijojo. Ohuaya miquianaya quecua mee cajeꞌyo, de. ");
INSERT INTO eseNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ojjañaa miquianaya cajaa acajeꞌyo ecuea epeejji cuanijojo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Onaa cajaa acajje aꞌa jjashahuaba taiquijji jama baꞌa: “Eyacuiñajjiya ecuana pajea caꞌyonaje, de”. Cho, Eyacuiñajjiya miquianaya pajeaꞌyo jjima acajeꞌyo. Ohuaya ca ca miquianaya jaahuana cajeꞌyo ojaya epeejji cuanijojo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ojjaña jiquio jayojja cuajo, ¡aꞌa miquianaaya eya pajeaꞌyojji! Miquianaya jjapeequipajeaꞌyo ajjajo Eyacuiñajjiya miquianaya baꞌe tiitii mee cajeꞌyo eyajo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Miquianaaya sohuinano cuana Jenosanenajo ejjanequitoquiꞌyo nequi ba majje miquianajaya eba ma cuiñajjijo ani cajjajeajea cuajicuaji cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ojjaña Jodea meshijo baꞌe cuana capoquiꞌyahua eyiyo huasijje. Ojjaña Jenosanenajo baꞌe cuana cacuayaquiꞌyahua. Quea huesha baꞌe cuana, ¡aꞌa cueꞌyoquijji Jenosanena huasijje! Capoquiꞌyahua quea huesha nee, ma sohuinano cuaa equecua ca cuaje jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Eꞌe de, jamaya quea nee nee cuaje, Eyacuiñajjija esohui yahuajo tehue ca cua jama jayojjaya cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Epona cuana oꞌejji, bacua shoꞌijji peaꞌai quea yeno nee nee cuaje; quea camaja epoquicuajijji cuaje, de. Eyacuiñajjiya quea nee nee nee po mee caje Jenosanenajo baꞌe cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sohuinanohua beca Jodio dejja cuana yacua cajeꞌyo. Beca cuana ca ca iña majje jeyo caje. Jeyo majje dojo caje pea meshi quea huesha nee yasijje. Quea yeno nee nee cuaje, de. Sohuinano cuaa, Jodio dejja pojjeama cuaa Jenosanenajo equi ani cajjajeajeaꞌyo majje pea equi iya cajeꞌyo ebaꞌeꞌyojji. Majotiiya oya cuana baꞌejeꞌyo jiquio ecua Eyacuiñajjiya baꞌe mee cajeꞌyo. Ma shonoya aje oya cuana poquijeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Majoya aje Jesosaa jama aca cua cuana baꞌa: —E cue oꞌoya jjimahuajo ojjaña quea mete cuaje eshequi, baꞌi peaꞌai quea apo cuajo. Jijiꞌyo ajja cuaje, de. Majameta cuana jjacajjaquiꞌyo majje jijijijioqueje. Ba majje dejja cuana quea mete nee nee cuaje; piopio cajeꞌyo, de. Ena cuana quea shajjaquijjo cuaje enashajo quea quemo nee neejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mete cajeꞌyo majameta huehuahuehuajo. Dejja cuana shacamano cajeꞌyo meteꞌyo majje. Oya cuaa jama huohuiꞌajjame acaje baꞌa: “¿Yajja shai cuani soꞌo?” ");
INSERT INTO eseNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ojjaña cuaa eya ba caje. Eya ojjañaja Edoe Mese cuani cuejeꞌyo bo biajje. Quea caꞌa nee nee; quea sohui poja nee nee cuaje, de. Eꞌe, quea bame cuaje ma pojjajoya. ");
INSERT INTO eseNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","¡Miquianaaya jiquio ba majje nequisohuacue! ¡Jjabajeasohuaquicue! Eya cueje oꞌoya miquiana dojohua eyahuasijje ebaꞌeꞌyojji tii tii. Jamajjeya ¡quea bihui pocue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesosaa pea esohui jama huohuime aca cua cuana baꞌa: —Eꞌe de, ¡bacue ma acui, iquena bajjani! ¡Ojjaña acui cuana bacue! ");
INSERT INTO eseNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Esejaya meshijo acui iña yani ba majje eseya jama cuani baꞌa: “Eꞌe jojo nei nayaja poꞌyonaje”. ");
INSERT INTO eseNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","¡Jiquio ecua acui iña yani ba majje acuijjajjajo jjashahuabaquiani jayojja jama eyatahuatahua huehuahuehuani ba majje bacue eya cueje oꞌoya! ");
INSERT INTO eseNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Eꞌe jojo nei ojjaña ma pojja cuanajo baꞌe cuana mano jeyojeyoꞌyo jjimahuajo ojjaña acua cuajeꞌyo eya ojjañaja Emeshi Mese oe nequijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Eyatahuatahua, meshi peaꞌai chamaꞌyo cuajeꞌyo. Ecuea esohui ca ca ma ani tiitiime cuajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—¡Ishoaꞌajja anicue iña oe nequiaa! ¡Aꞌa jjashahuaba majamajaquianijji miquianajaya ebaꞌejjijo! ¡Miquianaya oe che jjashahuabaquicue e ecue oꞌoyajjijo! ");
INSERT INTO eseNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ibia ijjiameejji esheꞌaꞌani jjacamicuajiquiꞌyani jayojjaya jama cuecuajimeya eya cuaje. Eꞌe, ojjañaja eya ba jjima cuecuajije. ");
INSERT INTO eseNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jamajjeya oe ¡shajjaꞌajjacue ecuea esohui! ¡Aꞌa pajeaꞌyojji, quea camaja cuaje, de! Ojjaña cuana quea mete nee nee, quea nee nee peaꞌai cuaje, de. Jamajjeya ¡jjaꞌishoaꞌajja aniqui tiitiicue! ¡Miquianaya ecuea epeejji po tiitiicue! ¡Eyacuiñajji nijje mimiani tiitiicue quea caꞌa epojji! Eya cue oꞌoyajo miquianaya ecojja nei nequiñaquije. Eya miquianajaya Edoe Mese cuaje, jamajje miquianaya quea bihui cuaje, meteꞌama cuaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ojjaña pojjajo Jesosaa esohui huohui canequia cua Eyacuiñajjija equijo. Mecajje poqui nequia cua eyiyo Onimo huasijje cahuiya. ");
INSERT INTO eseNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mecajjeahua Jesosa cue oꞌoya nequia cua Eyacuiñajjija equi yasijje. Ojjaña dejja cue nequia cua oja esohui shajjaꞌajjaa. ");
INSERT INTO eseNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Majoya aje quijje pishana ojjaña Jodio dejja cuana jjachichaquia cua Jenosanena huasijje ejjashahuabaquijji yahuajo nei esohuidojojjiya cuia jjima oja bacua cuana aca cuajo. Ijjiaꞌijjia ca cua ojee pahui hua jjimajo, Jodio etiiquianaa jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma epojja cue jjimahuajo, Eyacuiñajji nijje mimiani etii cuana, Moisesija etehueꞌyo huohuijji etii cuana peaꞌai jjashahuaba taiqui nequia cua jama baꞌa: —¿Achajja iñame shai seya Jesosa aje? Eseya jjeya Jesosa iñajo ojjaña ejjachichaqui nequi cuana quea quene cuaje ese nijje —jamaya cua quea mete jjejojo Jesosaja epeejji cuanajo. Jamatii ca ca iña mee sa aca cua Jesosa equecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jodasa Jesosa shajjaꞌajjajji nisho cua. Ojaya pea bajjani cua baꞌa: Isicaniote. Beca cuanaja Jesosa iña jjimajojo, Edosiquiaa Jodasa jjashahuaba taiqui mee ca cua Jesosa iña meesahuajji. ");
INSERT INTO eseNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jamajjeya Jodasa poquia cua Eyacuiñajji nijje mimiani etii cuana que, Eyacuiñajjija equi jaahuanajji cuana peaꞌai ani yasijje huohui pohua. Jama huohuiñaquime aca cua baꞌa: —Ecuea eba Jesosa ma o oe nei poquiani yasijje. Eyaya miquianaya huohuijeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Majoya oya cuana quea bihui cua Jodasaja esohui shajjaꞌajja majje. Jamajjeya jama cua baꞌa: —Eꞌe de, ecuana miyaya ba meecue ma Jesosa oe nei poquiani yasijje. Majoya aje ecuanaaya miya sosequiaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Eꞌe de, eyaya aje mi iñasahua meejeꞌyo —Jodasa cua. Majoya ohuaya saꞌajja ca cua eꞌiña meeꞌyojji Jesosa dejjama huasijje poqui. ");
INSERT INTO eseNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Majoya ma epojjajo Jodio cuana ijjiaꞌijjianijo Eyacuiñajji nijje mimianiya oe ñajjajja yahue shoꞌi quea bame nee nee quecua caꞌya cua Eyacuiñajji bihuiajji. Jodio dejja cuaa pahui hua jjima ijjia ca ania cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jamajjeya aje Jesosaa Peno, Huani peaꞌai huoojea ca cua oe equi yasijje bobi jjequiya. ");
INSERT INTO eseNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","O shajjaꞌajjajji cuaa jama huohuiꞌajjame aca cua baꞌa: —Jesosa, ¿ache equijo acuae seya pahui hua jjima ijjiaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesosa jama cua baꞌa: —¡Jenosanena huasijje oe poquicue! Majoya aje miquiaaya baje oe dejja meshimisijo ena dojo caje. ¡O ba majje o cuaje jja nei nei poquicue o dobiquijeꞌyo huasijjeya! ");
INSERT INTO eseNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Majoya ma equi mese jama huohuiꞌajjame acue baꞌa: “Ecuea esohui huohuijji jama cuanaje baꞌa: —¿Ache equecuayijjijo acuae ecuana ijjiaꞌijjiaje e shajjaꞌajjajji cuana nijje soꞌo? Ecuana ijjia sa cuani pahui hua jjima, Eyacuiñajji bihuiajji”. ");
INSERT INTO eseNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Majoya aje mi huohui caje equi meseya equecuayijji quea quemo. ¡Majoya aquiana iyajeacue; bobi cuacuacue! —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Majoya aje oya cuana poquia cua; ba ca cua Jesosaja esohui jayojjaya. Majoya iya ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Majoya siñajo Jesosa o shajjaꞌajjajji cuana cueya cua ma equi yasijje. Dobiqui majje anioquea cua eꞌijjiaꞌijjiajji. ");
INSERT INTO eseNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Majoya Jesosa jama cua baꞌa: —Eya miquiana nijje oe yejje nei ijjiaꞌijjiajeꞌyo, onaa e quecua caꞌyo cuahuajje. ");
INSERT INTO eseNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eꞌe de, eya eꞌijjiaꞌijjia becaꞌyojji pojjeama miquiana nijje manoꞌyo majje. Jamajjeya quijje eyaya cue oꞌoya majje jiquio pahui ijjiaje oꞌoya ojjaña cuanaja Emeshi Mese neiya jjejojo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Majoya ohuaya caneco jjeshe ca cua. Emejo iñanequia majje mimia cua Eyacuiñajji nijje. Majoya aje ohuaya o shajjaꞌajjajji cuana aca cua jama baꞌa: —Maꞌaje, ¡jiquio jjonojjajja na ishicue; ishijeyocue oe! ");
INSERT INTO eseNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eꞌe de, eyaya ishi becaꞌyo jjima jjonojjajja na aje, Ecue Chiiya eya ojjaña huoojeaꞌyojji po mee cajeꞌyo; ojjañaa eya shajjaꞌajja cajeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Majoya aje pahui jjeshe ca cua. Pahui jjeshe majje oya mimia cua Eyacuiñajji nijje. Mimi majje pahui miji ca cua. Majoya aje miji majje quia ca cuana cua. Jama huohuime aca cua baꞌa: —Jiquio pahui ecuea eyami. Jjeya nei pishana eya manojeꞌyo, Eyacuiñajjija esohui jayojja cuaje miquianaja mimishi cuijeaꞌyojji. ¡Jamajjeya miquianaaya jiquio pahui ijjiacue; jamatii apoquiapoquiacue! Jiquiajja ijjia majje ¡miquianaya jjashahuabaquicue e manoꞌya cuajo! ");
INSERT INTO eseNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Majoya ijjiaꞌijjiajeyo majje Jesosaa caneco jjeshe ca oꞌoya cua. Jjeshe majje jama huohuime aca cua baꞌa: —Jiquio jjonojjajja na ecuea enaꞌ, de. Ecuea enaꞌ cuayaquiꞌyajo eya manojeꞌyo. Jamajjeya Eyacuiñajjiya cuijea cajeꞌyo tii ojjañaja mimishi cuana. Eyacuiñajjiya esohui eyacua quia cajeꞌyo baꞌa: “Ojaya epeejji cuanaja mimishi cuana cuijea mee cajeꞌyo tii ecuea enaꞌ cuayaquijeya”. ");
INSERT INTO eseNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Majoya aje Jesosa jama cua baꞌa: —Yani oe ese nijje e shajjaꞌajjajji nisho cuani; ijjiaꞌijjiani ese nijje, de. Maaya eya sohuinano cuana iña mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Eya manojeꞌyo, Eyacuiñajjija esohui jama cuanaje jojoya. Eꞌe de, ma e shajjaꞌajjajji nisho Eyacuiñajjiya quea nee nee po mee cajeꞌyo. Ohuaya ma e shajjaꞌajjajji jeajea cajeꞌyo cuaqui yasijje e ohua sohuinano cuana iña mee cajeꞌyojojo —jamaya aca cua Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Majoya aje o shajjaꞌajjajji cuana mimia cua jama baꞌa: —De, ¿aya shai jama acaje? —jama mimime o shajjaꞌajjajji cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","O shajjaꞌajjajji cuana mimipanajaji nequia cua. Oya cuana jama cua baꞌa: —¿Ache o shajjaꞌajjajji quea bame nee nee cuaje eyajo? ");
INSERT INTO eseNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesosaa jama huohuime aca cua baꞌa: —Miquianaya mimiani ecuea epeejji pojjeama jayojja, de. ¡Aꞌa jama jjashahuabaquijji! Jamatii miquianajaya eba emeshi mese cuana quea mase cuani ojaya echacojji cuana nijje. Jamatii ma echacojji cuaa shajjaꞌajja cani ojaya emeshi meseja esohui jayojja oya quea mase cuanijojo. Ojaya echacojji cuana quea bihui nisho cuani. ");
INSERT INTO eseNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","27","¡Miquianaya ma emeshi mese jayojja jama aꞌa pojji! ¡Eyajo emeshi mese jayojja quea bame nee nequi sa cuanijo pea cuana jjeya nei baꞌe meesahuacue! ¿Ache shai quea bame nee nee soꞌo? Emeshi mese, ojaya echacojji pojjaꞌa. Emeshi mese, de. Jamaya Eyacuiñajjija epeejji pojjeama jjashahuabaquiani. Ecuea epeejji cuana ca e jayojja cabaꞌyahua. Eyaya miquianaya baꞌe bame meesahuaña. Eya maseꞌama cuani miquiana nijje; miquiana chacosahuajji cuani eya, de. ¡Jamaya pocue e jayojjaya! Majoya quea bame cuaje —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Majoya Jesosaa o shajjaꞌajjajji cuana jama huohuime aca cua baꞌa: —Miquianaya jamatii poꞌayequiequinaje enijje. Jjapeequi tiitiinequinaje enijje, jamatii beca cuaa eseya cajaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Jamajojoya aje oe miquianaya Eyacuiñajjiya quea bame quia cani, e ohua acanaje jayojjaya. Eꞌe, ohuaya eya ojjaña dejja cuanaja Emeshi Mese nei po mee caꞌyonaje; jamaya eyaya miquianaya Jodio dejja cuanaja emeshi mese jayojja po meejeꞌyo eyajo. Jomajo eseya baꞌe tiitiijeꞌyo; quea bihui cuaje —jamaya aca cua Jesosaa o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Majoya Jesosa mimia cua Peno nijje. Penoja pea bajjani cua baꞌa: Simohui. Jama Jesosa cua baꞌa: —Simohui, shajjaꞌajjacue jiquio esohui baꞌa: Edosiquiaa miquianaya eya pajea meeꞌyo sa acani. Ohuaya miquianaya mimishi po meeꞌyo sa acani. ");
INSERT INTO eseNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Simohui, eya miminaje mijo Eyacuiñajji nijje. Miyaya eya cajaa jayojja aje. Majoya miya enijje jjapeequi neineije oꞌoya. Jamajjeya enijje jjapeequi oꞌoya majje ¡pea e shajjaꞌajjajji cuana jjapee tiitiiqui meesahuacue enijje! ");
INSERT INTO eseNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simohui jama cua baꞌa: —Ecuea Emeshi Mese nei, Jesosa, eya aje minijje tiiya poquije mi jeanobia caje yasijje mi jayojja peaꞌai manoꞌyome poꞌyohua. Ecuea aje mi epajeaꞌyojji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesosaa Peno jama aca cua baꞌa: —Peno, mecahuajje cachina yahue taaa jjimahuajo, miya jama siajje pome cuaje baꞌa: “Chojja, ecuea Jesosa ba jjima”. Pea beca peejjima siajje ameya aje miyaya —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Majoya aje Jesosaa o shajjaꞌajjajji cuana jama huohuiꞌajjame aca cua baꞌa: —Yahuajo pishana eyaya miquianaya huoojeanaje esohui huohuiya. Eyaya miquianaya huoojeanaje aemaꞌ jamatii bejjomaꞌ, bashosocomaꞌ, miquea ejiojjijo nei nequi dojonaje. Eyaya miquianaya jaahuananaje. ¿Aꞌa miquianaya quea shoe cuanaje? Chojja. Oya cuana jama cua baꞌa: —Eꞌe jojo nei, jaahuana neinajeya aje jja ca miyaya ecuana, de. ");
INSERT INTO eseNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Majoya aje Jesosa jama cua baꞌa: —Eꞌe de, jjeya ca ca beca cuaa eya quecua cajeꞌyo. Eya miquiana nijje nequi tii ajja jiquio meshijo, eya manoꞌyo majje. ¡Jamajjeya ca oe miquea bejjo dojocue; miquea bashosocojo biyocuatajeacue quea huesha epoquijji! ¡Jjequicue miquea equecuajji! Chamajo jjeshecue miquea daqui moo sosejje. ");
INSERT INTO eseNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eꞌe de, yahuajo Eyacuiñajjija etehueꞌyo ejo jama cua baꞌa: “Dejja mase cuanaja botiꞌama Eyacuiñajjija huoojeaꞌyo cuaje. Dejja mimishi jayojja acajeꞌyo. Jamajjeya quecua cajeꞌyo cuaa” jamaya acaje jjeyahua nei, de —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","O shajjaꞌajjajji cuana jama cua baꞌa: —Bacue, yani ecuanaja beca equecuajji. Ecuanaa sohuinano cuana quecuajeꞌyo, de. Jesosa jama cua baꞌa: —Miquianajaya ba jjima ecuea esohui, de. Mahuiso ecuea esohui —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Majoya Jesosa poquia cua Onimo eyiyo huasijje mimiya oja Chii nijje. Cuamaya oya poqui majamaja nequia cua mimiya Eyacuiñajji nijje. Onijje o shajjaꞌajjajji cuana poquia cua peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Majoya aje Jesosaa jama aca cua baꞌa: —¡Mimi majamajacue oe Eyacuiñajji nijje mimishiꞌama epojji! ");
INSERT INTO eseNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Majoya Jesosa poquia cua quea huesha pishana mimiya Eyacuiñajji nijje oe nei. Majoya oya ecuiꞌoshajjajo nequi majje mimia cua jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Eꞌe de, Eyacuiñajji, eya beshahua nei poqui sa po ajja acui ecueataꞌapee yasijje. Eya quea mete nee nee ojjañaja mimishi cuanajo, de. Ecue Chii, ecuea eba miyaya eya acui ecueataꞌapee yasijje poqui mee sa aña emanoꞌyojji ojjañaja mimishijo. Jamajjeya ¡quea caꞌa po meecue eya miquea ejjashahuabaquiꞌyojji jayojja jama eꞌajji! —jama mimimeya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Jesosa quea mano jjabaquia cua emanoꞌyojji jjejojo. Majoya mimi oꞌoya cua oja Chii nijje jjanobajjima nei. O janobajjima nei mimianijo, shishi majje enaꞌ jayojja oquequia cua meshi yasijje, de. Majoya aje esohuidojojji eyajje nequioquea cua Jesosa meteꞌama po meeya. Ohuaya majoya Jesosa quea nee caꞌa po mee ca cua; jama cua baꞌa: —¡Mique Chiija esohui jayojja jama acue! —jamaya aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Majoya Jesosa oja Chii nijje mimipajeaꞌyo majje oya poquia cua o shajjaꞌajjajji cuana huasijje. Ba ca cua oya cuana ecahuijaa quea yeno nee nee jjejojo, de. ");
INSERT INTO eseNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ohuaya oya cuana jama aca cua baꞌa: —¿Apiojji acuae miquianaya ecahuijaa soꞌo? ¡Anisohuacue jja oe; mimi majamajacue miquianaya Eyacuiñajji nijje! Jamajoya pea cuaa quea mimishi epo meeꞌyojji pojjeama —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesosa mimianijo tii Jodio etii cuana, sohuinano cuana, Eyacuiñajji nijje mimiani etii cuana peaꞌai cueya cua. Jodasa, Jesosa shajjaꞌajjajji nisho cueya cua o que. Oya ehui dojojji nei cueya cua. O eꞌiñajji jjanequichipiquia cua Jesosa nequi yasijje. Jjanequichipiqui majje shemo tojjo nisho ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Majoya aje Jesosaa jama aca cua baꞌa: —Jodasa, miyaya eya shemo tojjo nisho majje sohuinano cuana iña meeꞌyonaje. ¿Yajjajo Jodasa? —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Majoya o shajjaꞌajjajji cuaa ba majje Jesosa jama huohuiꞌajjame aca cua baꞌa: —Jesosa, ¿aꞌa ecuaaya sohuinano cuana jajajeaje? ");
INSERT INTO eseNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Majoya aje oe oja eshajjaꞌajjajjiya dejja esapa jajapojojeajji nisho eshajja jajasejjajea ca cua ebañei shajjajje. Eyacuiñajji nijje mimiani etiija echacojji cuanija eshajja, de. ");
INSERT INTO eseNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—Chojja, ¡aꞌa jja oe jajajji! —Jesosa cua. Majoya Jesosaa ma dejjaja eshajja ejajasejjajea emeya nequia caꞌya cua. Shajja jaja jjima jayojja shajja panaꞌyome aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Majoya Jesosaa dejja cuana jama huohuiꞌajjame aca cua baꞌa: —¿Apiojji miquianaya cueyanaje baajji, acuijji eꞌiñaa? ¿Aꞌa cuae jja iña siipojji soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eꞌe de, ojjaña pojjajo eya esohui huohui po nequinaje Eyacuiñajjija equijo. Miquianajaya eya iña jjima cuanaje ma equijo quea meteya jjejojo dejja cuanajo. Jjeya ca ca Edosiquiaa miquianaya iña mee canaje jiquio quejo dejjamajo. ");
INSERT INTO eseNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Majoya sohuinano cuaa Jesosa iñaꞌyo majje dojo ca cua Eyacuiñajji nijje mimiani etiija equi yasijje. Penohua ca ca quea huesha pishana quiquishi ca poquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Majoya pea sohuinano cuaa cuaqui dahuahuojje ca cua equi epeeyi dojjojo. Majoya anioquea cua cuaqui pejjejo ejjayoquijji. Peno peaꞌai anioquea cua ona nijje yajja Jesosa onaa acaje ebajji. ");
INSERT INTO eseNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Echacojji ahuemaꞌaniya Peno jjayoquiani ba majje cojja ba neinei ca cua. Ba majje pea cuana jama huohuime aca cua baꞌa: —Eꞌe, joya Jesosaja epeejji ani baꞌa —jamaya cua ahuemaꞌani. ");
INSERT INTO eseNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peno jama cua baꞌa: —Ecuea Jesosa ba jjima nei nei. ");
INSERT INTO eseNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Quijje pishana pea dejjaa Peno ba ca oꞌoya cua. Jama cua baꞌa: —Miya jja Jesosaja epeejji, o shajjaꞌajjajji cuani. —Chojja, ecuea Jesosa ba jjima nei nei —jamaya aca cua Penohua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Majoya quijje pishana peaa oya ba ca oꞌoya cua: —Eꞌe, oya jja Jesosaja epeejji nei nei. Oya jja Janinea meshijo baꞌe Jesosa jayojjaya. ");
INSERT INTO eseNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Majoya aje Peno jama cua baꞌa: —Chojja de, ¿ajeo ajja mi ca mimiani soꞌo? Peno miminequijo tii, oe cachina yahue taaa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma cachina taaajo Jesosa jjanequijea pajjaquia cua Peno bajji. Majoya aje Peno jjashahuabaquia cua Jesosaja ehuohuijo jama baꞌa: “Cachina yahue taaa jjimahuajo, pea beca peejjima siajje ameya aje miyaya, eya ba jjima nisho aje”. ");
INSERT INTO eseNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Majoya Peno cuayaquia cua. Pa neineiꞌya cua Jesosa ba jjima nisho epo jjejojo; quea yeno nee neeꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sohuinano cuaa Jesosa jaahuana ca nequia cua, cuaya meequiꞌyo jjima yajji. Majoya Jesosa niñeba ca cuaa cua, majoya Jesosa cuia ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Majoya cuia majje cojja japa ca cua. Cojja japa majje shemo cuiasejjajea ca cua. Shemo cuiasejjajea majje ohuaya cuaa Jesosa jama huohuiꞌajjame aca cua baꞌa: —¿Aya acuae mi cuia canaje soꞌo? ¡Jjashahuabaꞌajjaqui! ");
INSERT INTO eseNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Majoya sohuinano cuaa Jesosa niñebajea neinei caꞌya cua, mimijaji neineiꞌya cua onijje. ");
INSERT INTO eseNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jjapojjaquiajo Jodio etii cuana jjachichaquia cua. Ojjaña Jodio etii, Eyacuiñajji nijje mimiani etii, Moisesija etehueꞌyo huohuijji etii cuana, ojjaña ojee mimia cua Jesosajo. Majoya sohuinano cuaa Jesosa dojo ca cua Jodio etii cuana huasijje. Majoya aje etii cuaa Jesosa jama huohuiꞌajjame aca cua baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¡Huohuicue ecuanaya miquea ebajjani! ¿Aꞌa miquea ebajjani Quito, Eyacuiñajjija huoojeaꞌyo, pojjaꞌa? Jesosaa jama sajaꞌame aca cua baꞌa: —Eya “eꞌe” cuajo miquianaya jjashajjaꞌajjaqui ajja, de. ");
INSERT INTO eseNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Miquianaya eyaya huohuiꞌajjajje sajaꞌa jjima ajeꞌyo eya. Jamaya eya sajaꞌajje miquianajaya eya epichojeaꞌyojji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eꞌe, eya poquijeꞌyo jjeya nei pishana eyahuasijje Eyacuiñajji nijje ebañeijje aniꞌyohua. Jomajo ecue Chii quea sohui poja nee nee enequi tii tii —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Majoya aje Jesosa ojjañaa jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌa miya Eyacuiñajjija Bacua Ejja nei soꞌo? Jesosaa jama sajaꞌame aca cua baꞌa: —Eꞌe jojo nei miquiaaya esohui ejo aña. ");
INSERT INTO eseNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Majoya aje oya cuana jama mimijajime cua baꞌa: —¡De, pea dejja aꞌa iyaajji Jesosa huohuijji! Ecuana jjeya nei shajjaꞌajjanaje ojaya esohui. Ohuaya Eyacuiñajji niñeba canaje Eyacuiñajjija Bacua Ejjaa miame —jama mimijajimeya cua Jesosa nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Majoya ojjaña nequisohua majje poquia cua emeshi mese Pinato huasijje Jesosa dojohua. Pinato esohuinano mese cua, ojjaña emeshi mese cuanaja emeshi mese peaꞌai cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jesosa dojo majje Pinato cojja nei nequia ca cua Jodio etii cuaa. Onaaya Jesosa jama niñebame aca cua baꞌa: —Ecuaa jiquio dejja banaje. Mimitecuetecuequi ecuanaja meshijo. Oya jama cuanaje baꞌa: “¡Aꞌa bejjo quiajji emeshi mese sosequiajji!” Oya pa Eyacuiñajjija huoojeaꞌyo cuani; oya pa Jodioja emishi mese posa cuani, de —jamaya oya cuana siajje cua Jesosajo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Majoya Pinatohua Jesosa jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌa miya Jodioja emeshi mese cuani? Jesosaa jama sajaꞌame aca cua baꞌa: —Miyaya huohuiaña jayojjaya cuani eya. ");
INSERT INTO eseNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Majoya Pinatohua etii cuana jama huohuime aca cua baꞌa: —De, jiquio dejja jjashahuaba taiqui ajja, capichojeaꞌyahua jja, de. ");
INSERT INTO eseNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Oya cuana quea quene nee nee cua. Mimia cua janobajjima nei nei. Jama tecuetecueme cua baꞌa: —Oya ca ca jjashahuaba taiquinaje, de. Ohuaya esohui huohui ca ayequiequinaje ojjaña cuiñajji yasijje. Ebionei Janinea meshijo hohui canaje, jjeya Jodea meshijo huohui canaje jiquio cuiñajji cuana huasijje, jjeya nei peaꞌasi, de. Ojjaña quea quene nee nee, quea shajjaquijjo nee nee ohuaya po mee canaje cuana —jama siajje ameya aca cua Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pinatohua ona shajjaꞌajja majje jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌa jiquio dejja Janineajo baꞌe? ");
INSERT INTO eseNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Eꞌe —oya cuana cua. Pinatohua ma shajjaꞌajja majje Jesosa huojea ca cua Enode que, Janinea ameshi mese que. Enode Jenosanenajo ania cua anicuaa poqui. Jamajjeya Pinatohua Jesosa, Jodio etii cuana peaꞌai huoojea ca cua Enode que. ");
INSERT INTO eseNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Enode Jesosa ba majje jama cua baꞌa: —Eꞌe de, jjeya nei eyaya baña jiquio dejja Jesosa. Eyaya oya ba sa anaje ojaya esohui eshajjaꞌajjajji; emanoꞌyo cuana eshequi mee cajeꞌyo ba sa anaje peaꞌai —jamaya cua Enode. Oya ca ca Jesosaja epeejji po sa po ajja nei. ");
INSERT INTO eseNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Majoya Enodeya huohuiꞌajja majamaja ca nequia cua. Jesosaja oya Enode sohui sajaꞌa jjima cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jodio etii cuaa Jesosa niñeba neinei ca aña cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Majoya Enodeya, oja sohuinano cuaa Jesosa hueꞌe ca cua esoadojojji. Daqui quea sose huiso emeshi meseja jayojja Jesosa huosho mee ca cua emeshi mese nisho yajji. Majoya aje daqui huosho mee majje bihuia nisho ca cua. Majoya aje Jesosa huoojea ca oꞌoya cua cuaa Pinato que. ");
INSERT INTO eseNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma pojjajo Jesosa nijje mimijaji majje Enode Pinato nijje jjapeequinaje. Yahuajo Pinato Enodeja epeejji pojjeama cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Majoya aje Pinato jjachichaquia cua Jodio etii cuana nijje, Jenosanena emeshi mese cuana nijje, pea dejja cuana nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jama huohuime aca cua baꞌa: —Miquianaya ¿apoijji Jesosa yenaje soꞌo? Miquianaya jama cuanaje baꞌa: “Ohuaya ojjaña dejja cuana quea quene, quea shajjaquijjo po mee cani” poso anaje. Cho oya ca ca quea mimishi pojjeama cuani. E que miquiaaya yajo aje jja, eyaya Jesosa huohuiꞌajjanaje. Jjeya nei ecuea eba Jesosa, oya jjashahuaba taiqui ajja. Oya quea mimishi pojjeama. Joya ecua miquiaaya huohui yaña jama pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Enode jama cuanaje baꞌa: “Oya ca jja ca quea mimishi pojjeama, de”. Jamajjeya ohuaya Jesosa huoojea ca oꞌoyanaje e que. ¡Bacue! Eyaya Jesosa mano meeꞌyo jjima aje, capichojeaꞌyahua jja Jesosa, de. ");
INSERT INTO eseNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jamajjeya eyaya oya cuia meeje. Majoya aje cuia mee majje pichojea meejeꞌyo —jamaya cua Pinato. ");
INSERT INTO eseNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ojjaña eshequiaja Pascuajo Pinatohua oe ejeanobia nequi huoojeacuaya caꞌyaninaje, Jodio cuana quea bei epojji. Jamajjeya Pinato jama cua baꞌa: —Jesosa eyaya huoojeacuaya meejoꞌyo jiquio shejo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma esohui shajjaꞌajja majje ojjaña Jodio cuana quenequene neineiꞌya cua; taaa cua jama baꞌa: —Chojja, ¡Mashama ca oe huoojeacuayaꞌyocue! ¡Quecua meeꞌyocue Jesosa! ");
INSERT INTO eseNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mashama jeanobia ca cua yahuajo pishana, oya quea mase nee nee cua. Oya Shomano emeshi mese quecuapanajji epo; ona quecuaꞌyojji epo peaꞌai. Oya quea mimishi nee nee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pinatohua ca ca Jesosa huoojeacuayaꞌyo sa aca cua, jamajjeya jama mimome po oꞌoya cua baꞌa: —Cho, Jesosa ca ca oe huoojeacuaya meeꞌyo sa aña. ");
INSERT INTO eseNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ojaya esohui shajjaꞌajja majje ojjaña cuana janobajjima nei nei jama taaame cua baꞌa: —Chojja de, ¡Jesosa ca oe quecua meeꞌyocue jjeya nei! ¡Acui ecueataꞌapeejo oe baꞌehuanasohuajeacue! ");
INSERT INTO eseNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pinatohua jama huohuime aca oꞌoya cua baꞌa: —¿Apiojji shai miquianaaya oya mano meeꞌyo sa aña soꞌo? Oya ca jja ca quea mimishi pojjeama cuani. Eyaya oya cuia neinei meeꞌyo majje huoojeacuaya meejeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Majoya aje ojjaña cuana taaa oꞌoya cua jama baꞌa: —¡Baꞌehuanasohuajeacue oe acui ecueataꞌapeejo Jesosa! Ojjaña cuana taaa majamaja cua. Quenequene neineiya cua Pinato nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jamajjeya pinato jama jjashahuabaquime cua baꞌa: —Eꞌe de, eyaya Jesosa caquecua meejeaꞌyahua, dejja cuana enijje quea quene cuequijojo. Eyaya ca oe Mashama cahuoojeacuaya meeꞌyahua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Majoya aje pinatohua ma ecua ojjaña taaanaje jama jayojjaya aca cua. Jamajjeya ohuaya Mashama huoojeacuaya mee caꞌya cua; Jesosa ca ca oe huoojea ca cua acui ecuetaꞌapeejo emeꞌ cacajeajji emanoꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Majoya sohuinano cuaa Jesosa acui ecueataꞌapeejji dojo mee ca cua o baꞌehuanasohuajeajji. Jesosa saja ca cua acui quea biquieya jjejojo. Jamajjeya sohuinano cuaa oe dejja ma acui dojo mee ca cua. Oya Simoni bajjani cua; Sinene meshijo baꞌe cue cua. Jamajjeya Simoniya Jesosa quiquishijji dojo ca cua acui ecueataꞌapee abojji. ");
INSERT INTO eseNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ojjaña dejja cuana epona cuana peaꞌai pa poquia cua Jesosajo quea yeno jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesosaa epona cuana ba majje jama aca cua baꞌa: —Jenosanenajo baꞌe epona cuana, ¡aꞌa oe ejo pajji! ¡Miquianaja pa sa cuanijo pacue miquianajo miquianaja bacuajo peaꞌai! ");
INSERT INTO eseNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Quijje pishana quea camaja cuaje miquianajo. Miquianaaya jama huohuije baꞌa: “Oe epona bacuamaꞌ camajaꞌama baꞌyani”. Sohuinano cuana cueje jiquio cuiñajji yasijje miquiana quecuaa, chamaꞌyo tii cuaje miquianajaya bobi. Jamajjeya miquianajaya ebacua yanijo quea yeno nee nee cuaje. Ebacua cuana pa neineijeꞌyo bobimajo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dejja cuana quea yeno nee nee cuaje peaꞌai. Joya ecua atii manoꞌyo sa cuani jama miquianaya cuaje. Majoya miquianaya jjashahuabaquije jama baꞌa: “Eyiyo, ¡ecuana biajje oe jaabicha cuajicue ecuana cuia cuajiꞌyojji” jamaya miquianaya cuaje. Eꞌe epona cuana, miquianaya ani sa po ajja cuaje quea camaja baꞌe jjejojo. Jamajjeya ma pojjajo quea nee nee cuaje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jjeya nei sohuinano cuaa eya quecua cajeꞌyo. Maya ca ca oe quea tai pishana. Quijje ojjaña sohuinano cuaa miquianaya quecua jeyojeyo cajeꞌyo, maya quea tai nee nee cuajeꞌyo. Jamajjeya ¡aꞌa pajji ejo; miquianajoya jja oe pa neineicue! —jamaya Jesosaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Majoya sohuinano cuaa beca siipojji dojo ca cua Jesosa nijje ebaꞌehuanasohuajeajji. ");
INSERT INTO eseNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Majoya oya cuana poquia cua eyiyo Sapa Jjii bajjani yasijje. Bañaqui majje Jesosaja emeꞌ caca ca cua acui ecueataꞌapeejo; ejiojjijje peaꞌai caca ca cua. Cacajeyo majje nequiasohuajea ca cua. Ma becanejjijji peaꞌai siipojji pea acui ecuetaꞌapee cuanajo nequiasohuajea ca cua Jesosa pejjejo oe ebañei mijijje, pea shani mijijje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Acui ecueataꞌapeejo baꞌehuanasohuajea cajje Jesosa mimia cua Eyacuiñajji nijje ojjaña nequijo jama baꞌa: —Ecue Chii, ecue Chii jiquio dejja cuanaja ba jjima eꞌe jojo nei eya miquea Ebacua Ejja cuani. Jamajjeya ¡jiquio mimishi cuijeaꞌyocue! Majoya aje sohuinano cuaa Jesosaja daqui huijjiajeaꞌyo majje hueꞌe ca cua oja daqui yaꞌyojjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ojjaña dejjaa Jesosa ba ca nequia cua, Jodio etii cuaa peaꞌai. Niñeba ca cua Jesosa jama baꞌa: —Dee, ¿aꞌa Jesosa ojjaña jaahuanajji pojjeama cuanaje? Oya ona nahuejji pojjeama. Jamajjeya mi nequioqueꞌyani acui ecuetaꞌapeejo baꞌe. Oya Eyacuiñajjija Bacua Ejja jjabaqui majje jja ca oe jjeyahua neiya canequioqueꞌyahua —jama niñebameya Jodio etii cuaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sohuinano cuana mimijajia cua peaꞌai. Jesosa majoya quiaꞌajja ca cua jjonojjajja na sese eꞌishijji nisho. ");
INSERT INTO eseNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jama mimijajime cua baꞌa: —¡Miya Jodioja emeshi mese nei jjabaqui majje mee nei nequioqueꞌyocue acui ecuetaꞌapeejo baꞌe jjeyahua nei! ");
INSERT INTO eseNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesosa baꞌe sapa biajje oja bajjani etehueꞌyo caca ca cua jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oe siipojji pea acui ecueataꞌapeejo baꞌe mimijajia cua Jesosa nijje jama baꞌa: —¡Aꞌa cuae miya Eyacuiñajjija Bacua Ejja nei jjabaꞌajjaqui socue! ¡Ache oe nequioqueꞌajjaquiꞌyo socue; ecuanaya peaꞌai pajjaja oe che nequioque meequiꞌyoque! ");
INSERT INTO eseNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pea siipojjiya pea acui ecueataꞌapeejo baꞌeya ca ca ma esohui shajjaꞌajja majje tanacua ca cua jama baꞌa: —¡Aꞌa jjashahuaba taiquijji, de! ¿Aꞌa miya Eyacuiñajjijo jjashahuabaqui ajja nei nei? Jjeya se manojeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eseya mano mee caꞌyani sohuinano cuaa quea mimishi nee neejojo. Jesosa ca ca mimishiꞌama, de. ");
INSERT INTO eseNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Majoya aje ohuaya Jesosa jama aca cua baꞌa: —Jesosa, ¡miya eyahuasijje poquiꞌyo majje ejo che jjashahuaba bamequicue! ");
INSERT INTO eseNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Majoya Jesosaa jama aca cua baꞌa: —Eꞌe, jiquio pojjajo miya enijje eyahuasijje baꞌesohuaquijeꞌyo manoꞌyo majje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Majoya esheque biacojjajja nequijo, shequimaꞌpo mee caꞌya cua. Quea apo nee nee po mee caꞌya cua ojjaña meshi yasijje. Quijje nei jjapojjaqui mee caꞌya cua eshequi ejjanequijeapaaquijo. ");
INSERT INTO eseNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Eshequi quea apo nee nee poꞌyajo, Eyacuiñajjija equijo baꞌehuana baꞌe daqui moo nei jjaꞌisajeaquia cua eyiyesama neijje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Majoya aje Jesosa jjanobajjima nei taaa cua jama baꞌa: —Ecue Chii, ecue Chii eyaya mi que ecue dojjoshahua huoojeajeꞌyo. Jjeyahua mo poquijeyoje. Jama po majjeya poquijeya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sohuinano huoojeajji cuani meseya Jesosa manoꞌyajo, ba ca cua. Majoya jama cua baꞌa: —Eꞌe de, eꞌe jojo nei Jesosa mimishiꞌama nei nei cuanaje; oya Eyacuiñajjija Bacua Ejja cuanaje, de. ");
INSERT INTO eseNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ojjaña dejja o ba cuequi poquiꞌya cua. Eseꞌo cuiaqueyajea ca poquiꞌya cua quea yeno nee neeya jjejojo sapa cuana cuiapashijea ca poquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ojjaña Jesosaja epeejji cuana ca ca quea huesha nequia cua. Epona cuaa peaꞌai quea huesha aniya ba ca cua Jesosa onaa cuia caꞌyoqui acui ecueataꞌapeejo baꞌe. Ma epona cuana yahuajo nei jjapeequia cua Jesosa nijje, Janinea meshijo baꞌe. ");
INSERT INTO eseNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Oe dejja Jose bajjani quea aquiana huiso cua. Oya pea Jose, Amatea cuiñajjijo baꞌe. Oya jjapee tiitiiquia cua Jesosa nijje. Oya Jodio etii cua. Jesosa manoꞌyo jjimahuajo, oya Jodio etti cuana nijje jjachichaquia cua. Ohuaya beca etii cuana jama huohuime aca cua baꞌa: —Chojja de, eya ca iña Jesosa mano mee sa poꞌyo ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jamajjeya Jesosa manoꞌyajo Jose poquia cua Pinato que Jesosa epoquijeyo baꞌe huohuiꞌajjaa; jama aca cua baꞌa: —Eꞌe de, ¡Jesosa mo quiaꞌyoque! Oya ca ca mano neineiꞌyonaje. Eyaya oya dojojeꞌyo ecuea mei jjani yasijje ehuananobiaquiꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Majoya aje ohuaya Jesosa manoꞌyo baꞌe jjequioquea caꞌya cua acui ecuetaꞌapeejo baꞌe. Jjequioqueaꞌyo majje bebo caꞌya cua daqui oshe quea bojea nee neeya. Bebo majje mei jjani ai yasijje huananobiaa dojo ca cua manoꞌyo tii cuanaja ejaajji ajjima huasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sinecua nei, ejomishocajji epojja po jjimahuajo Jesosa huananobiaa dojo ca cua Joseya. ");
INSERT INTO eseNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Janinea meshijo baꞌe epona cuana Jose quishishi poquia cua mei jjani yasijje Jesosa emanoꞌyo baa. Jesosa mei jjanijo huana ca cua Joseya. Epona cuaa Jesosa emano neiꞌyojaa baqui ca cua shiyeshiyejo eshaquijji nisho. Majoya Joseya mei quea quemo jeacajjajja ca cua mei jjani naba capaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Majoya epona cuaa Jesosa jjanijo ehuananobia jaa ba majje shiyeshiyejo shaqui jjima aca cua. Jamajjeya poquiꞌya cua ocuayaya equi yasijjeya. Majoya acui shiye pohuipohui shiyeshiye acua aca cua Jesosaja eyami shaquijji nisho. Shaqui jjima aca cua ejomishocajji pojja jojoya. Jamatii Jodio dejja cuana ma pojjajoya chacochaco ajja cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mecajjeahua nei nei nomico pojjajo, epona cuana poqui oꞌoya cua Jesosa ba oꞌoyaa. Shiyeshiye acuaꞌya dojo ca cua jjani jaa huasijje, Jesosaja eyami shaa nisho ihui jjima epojji. ");
INSERT INTO eseNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Epona cuaa ba cañaquia cua mei jjani ecaꞌapejoꞌyo cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oya cuana dobiquia cua ma mei jjani dojjo huasijje Jesosa baa nisho. Dobiqui majje Jesosa chamaꞌ ba caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Majoya quea mete nee nee poꞌya cua Jesosa chamaꞌ ba majje. Ma meteꞌyoquiya aje eponaa beca esohuidojojji dejja jayojja ba ca cua o pejjejo nequi. Ojaya daqui quea oshe nee nee, quea siyo nee nee cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Epona cuana quea mete nee nee cua; ecojja cahui cua quea cojja sajaja jjejojo. Majoya aje esohuidojojjiya jama huohuime aca cua baꞌa: —¿Yajjajo acuaeya miquianaya saꞌajjaña Jesosa jiquiojo soꞌo? ¿Aꞌa emanoꞌyo poso? Chojja, oya shequiꞌyonaje. ¡Chamaꞌyo ca jja ca jiquiojo! ¡Oya ca jja ca eshe nequiꞌyo! ");
INSERT INTO eseNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¿Aꞌa jja miquianaaya Jesosaja esohui pajeaꞌyonaje ma ohua yahuajo huohui ca cua Janinea meshijo nequiahuaa? ");
INSERT INTO eseNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jesosa yahuajo pishana, manoꞌyo jjimahua, jama cua baꞌa: “Mimishi cuaa eya mano mee cajeꞌyo acui ecueataꞌapeejo. Pea beca peejjima cahuime po majje shequijeꞌyo” jamaya cua Jesosa manoꞌyo jjimahua. Jamajjeya ¡aꞌa quea mete pojji! —jamaya aca cua esohuidojojjiya. ");
INSERT INTO eseNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma esohui shajjaꞌajja majje epona cuaa Jesosaja esohui shahuaba caꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Majoya aje poqui cuajicuajiꞌya cua pea cuana huohuiꞌyohua. Huohui cañaquia cua o shajjaꞌajjajji cuana, ojjaña cuana peaꞌai Jesosa shequiꞌyonajejo. ");
INSERT INTO eseNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mania Madanena, pea Mania Jacoboja nae, Huana, pea epona cuana peaꞌai poquia cua huohui poꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","O shajjaꞌajjajji cuaa epona cuana ohua huohui cajje, jama aca cua baꞌa: —Epona cuana, siajje mi ca cuani Jesosa eshequiꞌyojo miame. Miquianajaya esohui shajjaꞌajja sa po ajja ca iña —jamaya cuaa aca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peno ca ca quea cuejipashi nei poquia cua mei jjani yasijje baꞌajjaꞌyohua. Bañaqui majje mei jjani yeꞌeꞌajja cañaquia cua ma Jesosa jaa cuajo. Ba ca cua o bebojji oe ani, oja jeajeanaꞌyo jja oe ania cua. —De, chamaꞌyo Jesosa yaña, de —jamaya Peno cua. Jamaya po majje poqui oꞌoya cua equi yasijje. Poquianijo oya jjashahuabaquia cua Jesosajo. Ojaya ba jjima; jamajjeya jama cua baꞌa: ¿Yajja shai poꞌyonaje Jesosa? —jamaya cua Peno. ");
INSERT INTO eseNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Oya pojjajo tii, becanejjijji peaꞌai o shajjaꞌajjajji cuana poquia cua Emao cuiñajji yasijje. Quea huesha pishana cua Jenosanena ebañaquijji. ");
INSERT INTO eseNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jesosa emanoꞌyo niñeba ca poquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","O mimi poquijejo Jesosa jjanequichipiquia cua onijje. Jjanequichipiqui majje onijje poquia cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesosa ba majje ba tai caꞌyonaje, pea dejja posoya aca cuaa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Majoya aje Jesosaa jama huohuiꞌajjame aca cua baꞌa: —¿Aꞌya cuae nequiaa ca niñeba poquiaje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Majoya Quiopasiya jama sajaꞌame aca cua baꞌa: —¿Aꞌa miquea eba ma onaa acanaje Jenosanenajo? ");
INSERT INTO eseNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Majoya aje jjaja Jesosa jama cua baꞌa: —¡Huohuiꞌajja socue mo yajja acuae mi cuanaje! Oya jama aca cuaa cua baꞌa: —Jesosa Nasanenajo baꞌe. Oya quea sohui poja nee nee cuanaje. Ohuaya Eyacuiñajjija esohui huohui canaje, de. Ojjaña dejja jjashahuabaquinaje ojaya esohuijo. ");
INSERT INTO eseNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Majoya Jodio etii cuaa, emeshi mese cuaa, Jesosa iña mee caꞌyonaje, acui ecueataꞌapeejo quecua mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ecuana jjashahuabaquinaje Jesosa Jodio dejja cuanaja emeshi mese epojjijo Eyacuiñajjija huoojeaꞌyo peaꞌaijo. Oya ca ca chamaꞌyo tii poꞌyonaje, de. Pea beca peejjima cahuime oya emanoꞌyojaa. ");
INSERT INTO eseNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jiquio pojjajo mecajjeahua nei nei epona cuana poquinaje mei jjani yasijje Jesosa shaa nisho. Jjajjasoaquinaje Jesosa chamaꞌyojojo. ");
INSERT INTO eseNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesosa emanoꞌyojaa baꞌyo jjima cuanaje, jamajjeya cue oꞌoyanaje huohui poꞌyohua. Majoya aje pa ponaa ohuaya esohuidojojji ani ba canaje jjani dojjojo ani. Jama huohuimeya aje pa pona majoya acanaje baꞌa: “Jesosa ca ca emanoꞌyo tii pojjeama jaa, shequiꞌyonaje ca coma” jamaya pa pona acanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Majoya epona cuaa huohui cajje poquinaje beca cuana mei jjani yasijje. Mei jjani bañaqui majje chamaꞌ Jesosa ba canaje. Ma ecua epona cuaa esohui acanaje jayojjaya cuanaje. Onajaya Jesosa eshequiꞌyo baꞌyo jjima tii cuanaje, de —jamaya mimia cua o shajjaꞌajjajji cuana. ");
INSERT INTO eseNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Majoya aje Jesosaa jama huohuime aca cua baꞌa: —Miquianaya jjashahuabaqui ajja Eyacuiñajjija esohuijo. ");
INSERT INTO eseNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Aꞌa miquianajaya ba jjima Eyacuiñajjija huoojeaꞌyo ebionei camanoquiꞌyahua? Majoya shequiꞌyo majje, eyahuasijje poqui majje Eyacuiñajji ebañeijje anioquejeꞌyo tii tii ojjañaja Emeshi Mese epoꞌyojji tii tii. Jamaya yahuajo tehue ca cua Eyacuiñajjija esohuijo. ¿Aꞌa miquiaaya pajeaꞌyonaje pojjaꞌa? —jamaya Jesosaa aca cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Majoya poquijeya Jesosaa oya cuana huohui ca poquia cua ojjaña Eyacuiñajjija esohui ojo. Ohuaya huohui coo ca cua Moisesija ojo oja tehue majoya pea esohui huohuijji cuanaja ojo oja tehue huohui ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Majoya Emao ba cañaquia cua. Majoya aje bañaqui majje Jesosa ca jjayejjeꞌajjaquinana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Majoya aje o shajjaꞌajjajji cuaa Jesosa jama aca cua baꞌa: —Siña coma, jjaapoquia coma. ¡Ecuana nijje oe cahui chichacue! —jamaya cuaa aca cua. Majoya Jesosa onijje dobiquia cua oe equi yasijje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Majoya aje anioquea cua eꞌijjiaꞌijjiajji. Majoya aje anioque majje Jesosaa pahui jjeshe ca cua. Pahui jjeshe majje Eyacuiñajji nijje mimia cua. Eyacuiñajji nijje mimi majje pahui miji ca cua. Majoya aje miji majje quia ca cuana cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pahui quia cajje Jesosa bahuejja caꞌya cuaa cua. Jama cua baꞌa: —Eꞌe de, aꞌa jja mi Jesosa, de. Eꞌe jojo nei miya shequiꞌyonaje, de —jamaya o shajjaꞌajjajji cuaa aca cua. Majoya aje Jesosa jjachamaquiꞌya cua, de. ");
INSERT INTO eseNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Majoya aje cuana jama mimime po ania cua baꞌa: —Eꞌe de, eꞌe jojo nei mi eyaya anaje yaña, de. Ecuea equijijji peyaanaje o shajjaꞌajja majje. Quea bihui nee eseya cuanaje Eyacuiñajjija esohui shajjaꞌajja majje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Majoya aje o shajjaꞌajjajji cuana ocuayaya cueꞌya cua Jenosanena huasijjeya mecajje tiiya. Bañaqui majje ba ca cua pea Jesosaja shajjaꞌajjajji cuana, 11 ejjachichaqui ani pea epeejji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pea cuaa majoya jama aca jjequia cua baꞌa: —Eꞌe jojo nei, de. Jesosa shequiꞌyonaje. Simohuija eba nei nei oya cuanaje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Majoya aje Emao huasijje poqui cuaa jama huohuime aca cua baꞌa: —Ecuana poquianijo Emao huasijje, oe dejja poquinaje ecuana nijje. Oya miminaje ecuana nijje, de. Majoya ecuana ijjiaꞌijjianaje ojee. Ohua pahui miji cajo ecuaaya oya bahuejjanaje Jesosa cuanaje, de. Oya ca ca shequiꞌyonaje, eꞌe jojo nei, de. ");
INSERT INTO eseNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jesosa jjapanaquia cua ona mimiani yiyesamajo. Jesosa jama cua baꞌa: —¡Yani eya, de! ¡Quea bei oe pocue nequiana! ");
INSERT INTO eseNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jesosa ba majje quea mete nee nee cua o shajjaꞌajjajji cuana eshahuajo poso. ");
INSERT INTO eseNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesosa majoya jama cua baꞌa: —¿Yajjajje acuae nequiana quea mete cuani soꞌo? ¿Apiojji miquianaya jjashahuaba quehuaquiani? ");
INSERT INTO eseNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Bacue mo oe! Ecuea eme jjoto huejja namoja quecua huejja yani, ejiojjijje peaꞌai, de. Eyami nei jja iña iquio, eshahua pojjeama. Eshahua ca jja ca yamimaꞌ, samaꞌ peaꞌai, de. ¡Napaꞌajja socue mo, ecuea eyami; ba neineiꞌajja socue mo! ");
INSERT INTO eseNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Majoya Jesosaa ojaya eme jaꞌa ca cua, ejiojji peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Onaaya ca Jesosa pojjeama poso aca cua quea bihui jjejojo. Jjashahuabajeaqui jjima cua. Jamajjeya Jesosaa oya cuana huohuiꞌajja ca cua ejjashahuaba meequijji jama baꞌa: —¡Bacue eya, eyami nei; che mo bobi quiacue nequiaa! Eya ca ca eshahua pojjeama, eshahua cuana ca ca ijjiaꞌijjia ajja. ");
INSERT INTO eseNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Majoya aje onaaya Jesosa nahuoo cuaquijo dahua quia ca cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesosaa nahuoo ijjia ca cua, ona cojja nei aniya. ");
INSERT INTO eseNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Majoya ohuaya jama aca cua baꞌa: —Eyaya manoꞌyo jjimahuaa miquianaya huohuinaje pea cuaa eya quecua mee cajeꞌyo. Majoya eya shequije oꞌoya. Jamaya Moisesija etehueꞌyojo, cua, Salmo etehueꞌyojo peaꞌai huohui ca cua ejo. Ojjaña Eyacuiñajjija esohui huohuijji cuaa ejo tehue ca cua peaꞌai —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Majoya Jesosaa huohui ca cua Eyacuiñajjija etehueꞌyo ona jjabahuejjaquijji. ");
INSERT INTO eseNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ohuaya jama aca cua baꞌa: —Jama tehuemeꞌya cua baꞌa: “Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji manojeꞌyo. Manoꞌyo majje shequijeꞌyo pea beca peejjima cahuime po majje. ");
INSERT INTO eseNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ojjaña cuaa ojjaña meshi yasijje cahuohui caꞌyahua Eyacuiñajjija esohui, ojaya epeejji epojji. Ebionei Jenosanenajo cahuohui coo caꞌyahua. Eyacuiñajji nijje cajjapeequiꞌyahua, mimishi cuana capajea caꞌyahua. Majoya pea cuiñajji cuana huasijje capoquiahua ojaya esohui huohuiya”. ");
INSERT INTO eseNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jjeya nei miquianaaya eya banaje, shajjaꞌajjanaje jiquio esohui. Jamajjeya ¡aꞌa pajeaꞌyojji; huohui tiitiicue! ");
INSERT INTO eseNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","¡Bacue oe, eyaya Edojjoshahua Bame huoojeaje miquiana huasijje, miquiana quea bame baꞌe meejji! Ecue Chiiya yahuajo huohui canajeya jjejojo Edojjoshahua Bame huoojeajeꞌyo eyaya. Jamajjeya ¡jiquiojo tii anicue! ¡Jenosanenajo tii ishoaꞌajjacue Edojjoshahua Bame nei cueje eyajo ani! Ohuaya miquianaya quea jjashahuabaqui jaꞌa po mee cajeꞌyo —jamaya Jesosa cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Majoya aje Jesosaa o shajjaꞌajjajjii cuana dojo ca cua Betania huasijje. Bañaqui majje Jesosaa eme jeasohua ca cua, jama mimime cua baꞌa: —¡Enijje jjapee neineiquicue! ¡Jjashahuabaquicue Eyacuiñajjijo miquianaya quea caꞌa epojji! ");
INSERT INTO eseNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Majoya aje Jesosa eyahuasijje poquiꞌya cua. ");
INSERT INTO eseNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Oya cuana Jesosajo quea bihui nee nee poꞌya cua. Majoya aje huacuayaya cueꞌya cua Jenosanena huasijje quea bihui nee nee. ");
INSERT INTO eseNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Majoya aje poqui majamaja nequia cua Eyacuiñajjija equi yasijje Eyacuiñajji bihuiaa. Eꞌe de, acua. Eyaya, Nocaa tehuejeyonaje. Mahuisoya.");
INSERT INTO eseNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yahuajo nei nei meshi, aquiana cuana, dejja peaꞌai pana jjimahuajo, Jesosa Quito yaña tiiya poa Eyacuiñajji nijje. Eꞌe, oya Eyacuiñajji nei neiya eꞌe jojo nei poa. ");
INSERT INTO eseNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Eꞌe, oya Eyacuiñajji nijje yaña poa yahuajo nei nei meshi cuana, ojjaña aquiana cuana pana jjimahuajo. ");
INSERT INTO eseNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eyacuiñajjiya oya pana mee caꞌya poa aquiana, meshi cuanaya, dejja, epona peaꞌai, ojjaña pana caꞌya poa Jesosa Quitohua. Ojjaña aquiana pana jjima jjemo, chamaꞌ pome. ");
INSERT INTO eseNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Eꞌe, oya, Jesosa Quito, yaña tiitiia poa. Ohuaya eseya Eyacuiñajji ba mee cani. Jamajjeya ohuaya baꞌe tiitii mee cani eseya cuana. Eyacuiñajjijo quea jaꞌa jjashahuabaqui mee cani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jamatii mecajje quea apo nee neejo cuaquijijiya jeajaꞌa cani. Jiquio ecua cuaquijiji mecajje jijinequiani jama jayojja Jesosaa dejja mimishi cuana quea jaꞌa nee jjashahuabaqui mee cani. Eshahuaa Jesosa Quito eseya jaahuana pajea mee sa acani. Chojja. Ohuaya ojaya epeejji cuana jaahuana tiitii cani. Eꞌe, oya cuaquijiji quijjoꞌyo ajja jama. ");
INSERT INTO eseNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oe dejja Jodea meshijo baꞌe Huani bajjani Eyacuiñajjiya huoojea canaje Jesosa Quitojo huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Eyacuiñajjiya Huani jama acanaje baꞌa: —¡Poquicue miya! Ojjaña huohuiquicue jama baꞌa: “Eyacuiñajjija huoojeaꞌyo ma cuaquijiji quijjoꞌyo ajja jayojja poeyani ojjaña cuana quea jaꞌa jjashahuabaqui meeya. Jamajjeya ¡onijje jjapeequicue!” Jamajjeya Eyacuiñajjiya Huani huoojea canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Oya Huani ma cuaquijiji jayojja jama pojjeama; oya ca ca oma oe poquinaje Jesosa Quitojo huohuiya, ma cuaquijiji jayojjajo huohuiya. ");
INSERT INTO eseNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Eyacuiñajjiya Jesosa huoojea canaje meshi yasijje. Ohuaya ojjaña cuana quea jaꞌa jjashahuabaqui mee caje Eyacuiñajjijo. ");
INSERT INTO eseNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Eꞌe, oya ma cuaquijiji jayojjaya poeyanaje dejja cuana nijje baꞌeya. Yahuajo ohuaya meshi cuana, dejja cuana peaꞌai pana caꞌya poa. Jamatii oya dejja cuanaja ba jjima ojjaña cuana panaꞌyojji epo. ");
INSERT INTO eseNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eꞌe, oya poeyanaje Jodea meshi yasijje, ojaya huapa pojjeama cuana huasijje. Jamatii oya cajaa acanaje beca cuaa: —¡Chojja, oya Eyacuiñajji bameejji pojjeama! —poso beca cuaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Beca cuaa ca ca Jesosa Quitoja esohui shajjaꞌajja canaje. Ojo jama acanaje baꞌa: —Eꞌe jojo nei oya Eyacuiñajji ese bameejji poani —acanaje beca cuaa. Jamaya jjashahuabaquianijo, Jesosaa oya cuana Eyacuiñajjija bacua cuana po mee canaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yahuajo eseja ejeajjiya eseya jea ca poa; eseja enaeseya eseya mejo ca poa. Jamajjeya eseya cuayani ese ejjaja bacua, Eyacuiñajjija bacua pojjeama. Eyacuiñajjiya ca ca eseya oja bacua a sa acanijo ohuaya ohuaye nei eseya oja bacua po mee cani. ");
INSERT INTO eseNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jamajjeya oya Eyacuiñajji ese ba meeya poeyanaje yamijji, ese cuana nijje baꞌeya. Ecuanaa oya banaje quea caꞌa nee nee. Oja Chiiya oya, oja Bacua Ejja oe nei quea caꞌa nee huoojea canaje meshi yasijje ese cuana jaahuana tiitiijji. Ohuaya ojjaña Eyacuiñajjija esohui eꞌe nei huohui canaje ojjaña huasijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Huaniya ojo huohui canaje. Majoya oya ba majje taaanaje jama baꞌa: —¡Bacue! Jjeya nei pea dejja quea pame nee poeje. Yahuajo nei nei e cuaya jjimahuajo oya yaña tiitiia poa Eyacuiñajji nijje. Jamajjeya oya quea caꞌa nee nee; eya quea caꞌa pishana —poanaje Huani. ");
INSERT INTO eseNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eꞌe, eseya shajjamaꞌ poani. Jamatii ohuaya ojjaña cuana quea jea nee nee atiitii cani quea pame nee nee. ");
INSERT INTO eseNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yahuajo nei nei esohui huohuijji Moisesiya esohui Eyacuiñajjija ehuohuiꞌyo cuana tehue majje ba mee caꞌya poa. Jesosa Quitohua, ma Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajjiya ca ca ojjaña cuana ba mee canaje Eyacuiñajjiya eseya cuana quea jea nee nee acani, ojaya esohui eꞌe nei ba mee cani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Eyacuiñajji Echii Ai jjacojja ba meequi ajja tii. Jamatii oja Bacua Ejja oe nei Eyacuiñajji nei peaꞌai, Eyacuiñajji nijje nequi, oja Chii nijje tii. Ohuaya eseya Eyacuiñajji ba mee cani, oja Chii. Huaniya, ma ona besameejji poaniya Betania cuiñajjijo, Jodana cuei ojje mijijje nequi, ojjaña cuana Eyacuiñajjijo besa mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jamajjeya Jenosanena cuiñajjijo baꞌeya Jodio dejja etii cuaa Huani que huoojea canaje Eyacuiñajji nijje emimijji cuana, Eyacuiñajjija equi jaahuanajji cuana peaꞌai. Huani ba majje huohuiꞌajja canaje: —¿Aꞌya cuae mi soꞌo? ¿Aꞌa miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji? ");
INSERT INTO eseNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","—Chojja —sajaꞌame acanaje Huaniya—, chojja, eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama. Eya ca ca iña Quito pojjeama —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—Jamajjeya ¿aꞌya cuae mi oe soꞌo? —huohuiꞌajja canaje—. ¿Aꞌa miya Enia, Eyacuiñajjija esohui huohuijji yahuajo baꞌya poa? —Chojja —sajaꞌame acanaje Huaniya—. Eya Enia pojjeama. Jamajjeya huohuiꞌajja ca oꞌoyanaje cuaa jama baꞌa: —Eꞌe. Yahuajo Moisesiya huohui ca poa Eyacuiñajjija pea esohui huohuijji nei poeje. ¿Aꞌa miya ma esohui huohuijji neiya? —Chojja —Huaniya acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jamajjeya Jodio cuaa Huani huohuiꞌajja ca oꞌoyanaje: —¿Aꞌya cuae mi oe? ¿Aꞌya cuae mi poani soꞌo, de? ¡Huohuicue mo oe! Jodio etii cuaa ecuana huoojea canaje mi baa. ¿Yajja huohuiñaquiꞌyome acuae oe aje o que poqui oꞌoya majje soꞌo? ");
INSERT INTO eseNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jamajjeya Huaniya sajaꞌa canaje jama baꞌa: —Yahuajo nei nei Eyacuiñajjija esohui huohuijjiya Isaiaa ejo huohui ca poa jama baꞌa: “Quijje esohui huohuijji poeje esohui huohuiya. Meshi quimajo huohui huichaꞌa huichaꞌa caje jama baꞌa: “Emeshi mese nei poeje. ¡Jamajjeya oe apoa pocuajicue! ¡Jamajje o poeyajo, ojaya esohui quea jaꞌa nee shajjaꞌajja neineiꞌyocue!” Jamaya acaꞌya poa Isaiaa yahuajo —Huani poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Jamajoya ma Jodio dejja cuanaa Huani huohuiꞌajja ca oꞌoyanaje: —¿Aꞌa eꞌe jojo nei miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama? ¿Aꞌa cuae mi Enia pojjeama, ma Eyacuiñajjija esohui huohuijji yahuajo baꞌya poa pojjeama soꞌo? ¿Aꞌa cuae mi Eyacuiñajjija pea esohui huohuijji nei, ma ecuanaja etiiquiaa ishoaꞌajja caninaje pojjeama soꞌo? ¿Achajjajo acuaeya oe miyaya ecuana, Jodio cuana, besa meeaña Eyacuiñajjijo soꞌo? —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Huaniya jama acanaje baꞌa: —Eyaya miquianaya Eyacuiñajjijo besa meeaña cuei enajo. Pea dejja jiquio tiijo nequi. Jjeya oya miquianajaya ba jjima. ");
INSERT INTO eseNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Oya quijje pishana miquianajaya eba poaje Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Oya ca ca oe nei quea caꞌa nee nee nequi. Eya ca iña quea caꞌa nee pishana. Jamajjeya aje oe eya Jesosa Quito cojja neijo nequi sa po ajja. Eya quea bicho, de. ");
INSERT INTO eseNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jamaya poanaje Huani Betaniajo, Jodana cuei ojje mijijje nequi, ojjaña cuana Eyacuiñajjijo besa mee canijo. ");
INSERT INTO eseNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Majoya mecahuajje Huaniya ojjaña huasijje esohui huohui ca oꞌoyanijo, Jesosa o que poeyanaje. Huaniya Jesosa ba majje ojjaña cuana huohui neinei canaje jama baꞌa: —¡Bacue oe, oya poeyani Jesosa, Eyacuiñajjija huoojeaꞌyo! Oya manojeꞌyo ojjaña cuanaja mimishi cuijeaꞌyojji. Eꞌe, Eyacuiñajji nijje emimijji cuaa ñajjajja cuia majje Eyacuiñajji yasijje dahua cani oya mimishi cuanajo queneꞌama epo meejji. Ñajjajja jayojja jama poajeꞌyo Jesosa; manojeꞌyo ojjaña cuanaja mimishi cuijea neineiꞌyojji —Huani poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eꞌe, yahuajo pishana eyaya miquianaya huohuinaje ojo jama baꞌa: Jjeya nei pea dejja quea pame nee nee poeje. Yahuajo nei nei e cuaya jjimahuajo oya yaña tiiya poa Eyacuiñajji nijje. Jamajjeya oya quea caꞌa nee nee; eya quea caꞌa pishana —Huani poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","33","—Eꞌe, yahuajo oya ecuea ba jjima poa. Jamatii Eyacuiñajjiya e huoojea jjimahuajo huohui canaje jama baꞌa: “¡Dejja cuana besa meecue enajje ejo! Besa meeañajo, miyaya baje oe dejja. Ecuea Edojjoshahua Pame huiaꞌ jama ma dejja sapa biajje cuabesa baꞌeje; jjapashineijje baꞌeoquejeꞌyo. Maya ecuea ecue Bacua Ejja, ecue huoojeaꞌyo. Ohuaya ojjaña miquiana que Edojjoshahua Pame dobiqui mee cajeꞌyo, miquiana quea jaꞌa nee nee ejjashahuabaqui meejji” eya acanaje Eyacuiñajjiya —Huani poanaje. —Eꞌe, eyaya eꞌe jojo nei banaje jama baꞌa: Eya Jesosa besa meeañajo, eyatahuatahua jjacaꞌapejoquinaje. Eyacuiñajjija Edojjoshahua Pame huiaꞌ jama o sapa biajje cuabesa baꞌenaje. Jjapashineijje baꞌeoquenaje. Jamajjeya jjeya oya ecuea eba nei nei, Jesosa. Yahuajo miquianajaya oya ba jjima. Jamajoya eya poeyanaje ojjaña Eyacuiñajjijo besa meeya. Miquianaya oya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji ba meeya eya poeyanaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jamajjeya eyaya miquianaya huohui neineiaña: Eꞌe jojo nei nei eyaya oya banaje. Jesosa ca ca oe eꞌe jojo nei Eyacuiñajjija Bacua Ejja oe nei —poanaje Huani Jodio cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Majoya mecahuajje Huaniya, ma ona besameejji poaniya jomajo, Jodana cuei sahuajo nequiya esohui huohui canaje oja epeejji nijje, becanejjijji peaꞌai nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesosa jjayejjequiani ba majje Huaniya oja epeejji cuana huohui canaje jama baꞌa: —¡Bacue Jesosa! Oya Eyacuiñajjija huoojeaꞌyo. Oya manojeꞌyo ojjaña cuanaja mimishi cuijeaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Huanija esohui Jesosajo shajjaꞌajja majje oja epeejji becanejjijji peaꞌai Jesosa nijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesosaa ejiojjijje poquijeya Huanija beca epeejji o quiquishijji poquije bajea canaje. Ba majje huohuiꞌajja canaje: —Epeejji cuana, ¿ajeo miya enijje poeyani? —Esohui huohuijji —sajaꞌa canaje—, ecuana poeyanaje mi baa; mi shajjaꞌajja sa poani. ¿Achejo baꞌe miya? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Eꞌe —Jesosa poanaje—, ¡ocue poeꞌajja! ¡Cuaꞌa, enijje poꞌyocue! Jamajjeya Jesosa nijje poquinaje equi yasijje, o baꞌe yasijje. Onijje aninaje ma pojjajo, eshequi oquequiajo; o shajjaꞌajjajji poꞌyonaje oya cuana, ma bajjani baꞌa: Anesi oja epeejji nijje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Eꞌe, Anesi pea dejja nijje Huanija ehuohui shajjaꞌajja majje Jesosa nijje poquinaje. Anesi ca ca Simohuija echahua mese, ma quijje bajjani canaje Penoja echahua mese. ");
INSERT INTO eseNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jamajjeya mecajjeahua nei Anesiya oja oꞌi saꞌajja canaje. Ba majje huohui canaje: —Oꞌi, eyaya Eyacuiñajjija huoojeaꞌyo ese jaahuanajji banaje, Jesosa Quito. ");
INSERT INTO eseNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Majoya Anesiya oja oꞌi Simohui bajjani Jesosa que dojo canaje. Simohui ba majje Jesosaa huohuiꞌajja canaje jama baꞌa: —Epeejji, miya ecuea eba. Miya Huanija bacua ejja, Simohui bajjani. Eyaya miya bajjanijeꞌyo ecuea esohuijo Sepa bajjani —poanaje. Jienoja esohuijo Peno bajjani canaje, Ese Ejjaja esohuijo Mei bajjani. ");
INSERT INTO eseNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Majoya mecahuajje, mecajjeahua nei Jesosa poquinaje Janinea meshi yasijje, Jodana cuei ojje miji yasijje. Poqui jeahuaa Penipe ba canaje. Ba majje iyaa canaje: —Penipe, ¡ocue poeꞌajja, enijje poꞌyocue; ecuea epeejji poꞌyocue! —Jesosaa acanaje; o que poquiajo ojaya epeejji pojji acaꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Penipe, Peno, Anesi peaꞌai ca ca oe Betesaida cuiñajjijo baꞌe. ");
INSERT INTO eseNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jamajjeya Penipeya oja epeejji Natanaeni saꞌajjaqui canaje. Ba majje huohui canaje: —Ecuea epeejji, ecuanaa Eyacuiñajjija huoojeaꞌyo ese jaahuanajji banaje. Ojo Eyacuiñajjija esohui huohuijjiya yahuajo nei nei baꞌya poaa, Moisesiya peaꞌaiya tehue ca poa, ma ojjaña Jodio cuaa ishoaꞌajja caniya. Oya Jesosa bajjani, Joseja bacua ejja, ma Nasanena cuiñajjijo baꞌenaje. Eyaya maya banaje, de —poanaje Penipe. ");
INSERT INTO eseNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—¿Aꞌa oya Nasanenajo baꞌenaje? Jomajo pa jjaja chamaꞌ dejja quea pame —poanaje Natanaeni. —Chojja —poanaje Penipe—, ¡poecue, oya bahuacue! ");
INSERT INTO eseNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jamajjeya oya cuana poquinaje Jesosa baa. Majoya Natanaeni poeje ba majje Jesosa onijje miminaje jama baꞌa: —Eꞌe Natanaeni, miya Jodio eꞌe jojo nei. Eyacuiñajji shajjaꞌajjajji poani. Miya ca ca oe siajje po ajja nei nei peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma shajjaꞌajja majje Natanaeni jama poanaje baꞌa: —¿Aꞌa eya miquea eba? ¿Ache shono acuaeya miyaya eya banaje soꞌo? —poanaje. —Natanaeni, miya ecuea eba yahuajo. Penipeja iyaa jjimahuajo, iquena acui yajjanajo ani eyaya miquea ejjashahuabaquijji banaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jamajjeya Natanaeniya acanaje: —Esohui huohuijji, eꞌe jojo nei miya Eyacuiñajjija Bacua Ejja oe nei poani tii. Eꞌe, ¡miya Jodio cuanaja Emeshi Mese nei! ");
INSERT INTO eseNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","51","Jesosaa oya huohui canaje: —Eyaya miya huohuinaje jama baꞌa: “Eyaya miya banaje iquena acui yajjanajo ani”. Jamajjeya ecuea esohui shajjaꞌajja majje miya jjashahuabaquinaje jama baꞌa: “Eꞌe jojo nei miya Eyacuiñajjija Bacua Ejja”. Jamajoya miyaya baje Eyacuiñajjiya eya ma dejjaja ba jjima amee cajeꞌyo. Cuanaya Eyacuiñajjija esohuidojojji cuana nequioqueje e jaahuanaa, ojjañaja Edoe Mese jaahuanaa. Jamaya miyaya bajeꞌyo, Natanaeni, enijje jjapeequianijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Majoya beca cahuime po majje oe dejja jjahuanaquinaje Canajo, Janinea meshijo. Ejjahuanaquijjijo quea huiso cuana iyaa canaje ojee ijjiaꞌijjiaa. Jesosaja enaese Mania iyaa canaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesosa o shajjaꞌajjajji cuana nijje poeyanaje peaꞌai jjahuanaquije baa, ojee ijjiaꞌijjiaa peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ojee ijjiaꞌijjia anijo, acuijjajja na ishijeyo canaje cuaa. Jamajjeya Jesosaja enaese onijje miminaje jama baꞌa: —Jesosa, bacue, acuijjajja na ishijeyo canaje cuaa. Oe poanaje. ¿Ae eꞌishiꞌyojji? ");
INSERT INTO eseNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ecue nae, ¿yajjajo acuae moya huohuiꞌajjaña acuijjajja najo? ¡Ishoa socue oe! Quijje pishana eyaya oya cuana asahuaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jamajjeya ojaya enaeseya echacojji cuana huohui canaje jama baꞌa: —¡Jesosaja esohui jayojjaya nequiaa oe acue! —poanaje Mania. ");
INSERT INTO eseNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jomajo me oejje oe, 6 meshimisi ena nequijji quea quemo nee nee, quea ao nee nee yani, 60 litros shojji. Ma meshimisijo ena nequia cani eme shacua huichaꞌa huichaꞌajji. Jamaya oya cuaa acanaje ijjiaꞌijjia jjimahuajo. ");
INSERT INTO eseNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jamajjeya Jesosaa echacojji cuana jama acanaje baꞌa: —¡Ena shocue meshimisi ai cuana huasijje! —poanaje. Echacojji cuana: —Eꞌe —poanaje. Meshimisi ai cuana huasijje ena sho canaje. Cuatajea mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jamajjeya cuatajea cajo, Jesosaa echacojji cuana jama acanaje baꞌa: —Eꞌe. ¡Jjeya oe pojji dojocue equi mese yasijje! Jamajjeya oe pojji dojo canaje eꞌishi meeꞌajjajji. ");
INSERT INTO eseNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma ena ishiꞌajja canaje equi meseya. Jamatii ojaya ba jjima jiquio eteohuejjajo nequi ena Jesosaa acuijjajja na pojji acanaje. Echacojji cuanaja eba ojaye nei Jesosaa eteohuejjajo nequi ena acuijjajja na pojji acaꞌya poa; pea cuanaja ba jjima. ");
INSERT INTO eseNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Jamajjeya equi meseya ishi majje joya ejjahuanaquijji iyaa canaje. Huohui canaje jama baꞌa: —Epeejji, jiquio acuijjajja na quea pame nee nee. Pea cuaa acuijjajja na quea pame, quea biquia nee ishi mee cani ebionei. Majoya ojjaña jejje majje acuijjajja na quea biquia pishana quia cani. Miyaya ca ca oe acuijjajja na quea biquia nee, quea pame nee nee quijje nei ishi meeaña —poanaje eꞌequi mese. ");
INSERT INTO eseNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jamaya acanaje Jesosaa Janinea meshijo, Canajo. Jamaya ohuaya ma dejjaa ajjima acani acoo canaje. Ba majje ojjaña cuana jama poanaje baꞌa: —Eꞌe jojo nei Jesosa quea caꞌa nee nee. Ohuaya ojjaña acani, ma dejjaa ajjima acani peaꞌai. O shajjaꞌajjajji cuana peaꞌai jama poanaje baꞌa: —Eꞌe jojo nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, Quito. ");
INSERT INTO eseNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Majoya Jesosa Capenaoma huasijje poquinaje. Oja nae, oja chahua cuana, ojaya epeejji cuana peaꞌai onijje poquinaje. Jomajo aninaje cuana oe pojji cahuime. ");
INSERT INTO eseNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Quijje pishana ojjaña Jodio cuana Jenosanena huasijje poquinaje quea bihui nee ojee ijjiaꞌijjiaa ma shejo baꞌa esohuidojojji cuaa yahuajo Ejito meshijo Jodioja ebacua cuana cuiaꞌyo jjima shejo. Ma epajeaꞌyojji pojjeamajo jjachichaquinaje. Jamajjeya Jesosa peaꞌai poquinaje Jenosanena huasijje. Poe majje Eyacuiñajjija equi yasijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dobiqui majje Jesosaa ba canaje quea huiso dejja cuaa aquiana quia cani; anaꞌai yahue cuana, ñajjajja cuana, huiaꞌ cuana peaꞌai quia cani. Bejjo pea bejjo sosejje quia caqui ba canaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ba majje Jesosaa jjono ecuiasejjajeajji iña canaje. Dejja aquiana quiajji cuana, ñajjajja cuana, anaꞌai cuana peaꞌai cuiahuoojeacuayajea canaje esecue yasijje, ojjaña. ");
INSERT INTO eseNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bejjo pea bejjo sosejje quiajji cuanaja bejjo nequijji cuana jeapajjajea canaje; bejjo jjahuojjojeajeaqui canaje. Huiaꞌ quiajji cuana Jesosaa huohui canaje jama baꞌa: —Jiquio equi ca ca ecue Chii nijje emimijji. Aquiana quiajji pojjeama equi. ¡Miquea aquiana cuana dojoꞌyocue esecue yasijje! ¡Aꞌa jja oe Eyacuiñajjija equi aquiana quiajji equi jayojja jama ajji! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma ba majje ecuana, Jesosaja epeejji cuana, ojee jjashahuabaquinaje jama baꞌa: —Eꞌe, Eyacuiñajjija esohui huohuijjiya yahuajo nei nei tehue ca poa jama baꞌa: “Ecue chii, eya jjashahuaba neineiquiani miquea equi jaahuanajji. Jamajjeya mimishi cuaa eya niñeba cani”. Jama tehuemeya aca poa yahuajo nei. Oya cuaa Jesosajo tehue ca poa, de —poanaje Jesosaja epeejji cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jamajjeya Jodio cuana Jesosa nijje quea quene poanaje, oya Eyacuiñajjija huoojeaꞌyo pojjeama posojo onijje mimijajinaje jama baꞌa: —¿Aya acuae mi huoojea canaje ecuana Eyacuiñajjija equijo anijo huoojeacuayajeaa? ¿Aꞌa cuae miya Eyacuiñajjija huoojeaꞌyo nei? ¡Cabaꞌajja sahua! !Ma dejjaa ajjima acani aꞌajja socue ecuanaja ebajji, Eyacuiñajjiya eꞌe jojo nei miya aꞌa huoojea canaje ebajji! ");
INSERT INTO eseNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesosaa oya cuana sajaꞌa canaje: —¡Bacue! Miquianaa jiquio equi jeabichajeaꞌyajo eyaya jiquio equi iyaje oꞌoya pea beca peejjima cahuime. ");
INSERT INTO eseNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Chojja, de —Jodio cuana poanaje—. Quea huiso nee nee, 46 shequiajame jiquio equi iya canaje cuaa. ¿Achajja acuae equi jeabichajea majje miyaya iyaje oꞌoya pea beca peejjima cahuime? ¡Chojja, de! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jamatii Jesosa Eyacuiñajjija equijo pojjeama miminaje; ojaya eyamijo jjashahuabaquiani. ");
INSERT INTO eseNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eꞌe, quijje Jodio cuaa Jesosa quecuaꞌyo majje, Eyacuiñajjiya oya shequi mee caje oꞌoya pea beca peejjima cahuimejo. Jamajje quijje Jesosa shequi oꞌoyajo, ecuana o shajjaꞌajjajji cuana jiquio esohuijo jjashahuabaquije. Jama poaje baꞌa: —Eꞌe de, Eyacuiñajjija esohui eꞌe nei; Jesosaja ehuohui peaꞌai eꞌe nei —poaje quijje. ");
INSERT INTO eseNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jamajjeya Jenosanena huasijje Jodio cuana ojee jjachichaquinaje. Quea bihui nee ijjiaꞌijjianaje esohuidojojjiya yahuajo nei Jodioja ebacua cuana cuiaꞌyo jjima shejo, ma pajeaꞌyo jjima yajji. Jesosa peaꞌai Jenosanenajo aninaje. Jomajo Jesosaa quea huiso ma dejjaa ajjima acani acanaje. Ba majje quea huiso cuana poanaje: —¡Eꞌe jojo nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji! —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Jamatii Jesosaja eba nei nei ojjaña dejja cuanaja ejjashahuabaquijji. Quea tai, epeejji eꞌe jojo nei pojjeama beca cuana. Jamajjeya ohuaya ojjaña quea jaꞌa nee huohui jjima jama baꞌa: —Eꞌe jojo nei eya ca iña jiquio Eyacuiñajjija Bacua Ejja —jamaya huohui jjima soꞌo Jesosaja. ");
INSERT INTO eseNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Majoya oe dejja Jesosa que poeyanaje, oya Nicodemo bajjani. Oya Jodio etii cuana nijje pea Jodio cuana huoojeajji poani, Paniseo dejja cuana jama jjashahuabaquime poani. ");
INSERT INTO eseNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Oya, Nicodemo Jesosa que poeyanaje mecajje quehuajje. Jama acanaje baꞌa: —Esohui huohuijji, Eyacuiñajjiya miya ameesahua cani ma dejjaa ajjima acani. Jamajjeya ecuanaja eba Eyacuiñajjiya miya huoojea canaje ecuana sohuihuohuiya. ");
INSERT INTO eseNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesosaa oya huohui canaje Eyacuiñajji nijje ebaꞌe tiitiiꞌyojjijo; jama poanaje baꞌa: —Nicodemo, eyaya miya eꞌe jojo nei huohuiaña: ¡Bacue! Jiquio ecua epona jjamejoqui majje bacua cuayani jayojja jama Eyacuiñajjiya miya cacuaya mee ca oꞌoyahua jiquio ecua eshoꞌi cuayani jama. Jamajjeya Eyacuiñajjiya miya ebacua shoꞌi jayojja jama acajeꞌyo, miya baꞌe tiitii mee cajeꞌyo onijje, ojjañaja Emeshi Mese nei nijje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Chojja de, ¿aꞌa cuae se dejja etii cuaya oꞌoyame soꞌo? —Nicodemohua acanaje—. ¿Aꞌa cuae eseja enaeseja yone yasijje baꞌedobiqui oꞌoya majje ebacua jama cuaya oꞌoyame soꞌo? Chojja, de —acanaje Nicodemohua. ");
INSERT INTO eseNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jamajjeya Jesosaa oya huohui ca oꞌoyanaje: —Nicodemo, eꞌe jojo nei ecuea ehuohui jama baꞌa: Jiquio ecua ebacua eshoꞌi cuayani jama Eyacuiñajjiya miya cacuaya mee ca oꞌoyahua. Joya Eyacuiñajji shajjaꞌajjajji poani enajo besa mee majje, Eyacuiñajjija Edojjoshahua Pameya oya quea pame jjashahuaba tiitiiqui mee majje peaꞌai miya pea jjashahuabaquime poajeꞌyo. Oya Eyacuiñajji nijje baꞌe tiitiijeꞌyo. Jamaya po ajjajo ca ca Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji pojjeama eyajo. ");
INSERT INTO eseNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Eꞌe Nicodemo, ojjaña cuana enaeseja mejo bacua cuayani yahueja jea, oja chii jayojja yamijji. Joya Eyacuiñajjija Edojjoshahua Pameya pea jjashahuabaquime po mee caꞌyani ca ca Eyacuiñajjija Edojjoshahua Pame onijje nequi —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Eyaya miya huohuinaje eꞌe jojo nei ebacua eshoꞌi cuayani jama Eyacuiñajjiya miya cacuaya mee ca oꞌoyahua. Jamatii aꞌa jama jjashahuabaquijji baꞌa: “Chojja de, ¿yajja epojji?” ");
INSERT INTO eseNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Miyaya beni shajjaꞌajjaña; beni baña peaꞌai acui iña dojo cani. Jamatii ache huesha beni poeani miquea ba jjima; achacua poquije miquea ba jjima peaꞌai. Jiquio ecua beni achacua poquije ba jjima jayojja jama miquea ba jjima peaꞌai ache shono, achejo pojjaꞌa Eyacuiñajjija Edojjoshahua Pameya dejja pea jjashahuabaquime po mee caꞌyani. Jamaya miquea eba pojjeama. Eꞌe, Eyacuiñajjiya miya cacuaya mee ca oꞌoyahua ebacua eshoꞌi cuayani jayojja jama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Eꞌe pojjaꞌa. ¿Achajja acuae ebacua eshoꞌi cuayani jayojja jama epojji soꞌo? —huohuiꞌajja canaje Nicodemohua. ");
INSERT INTO eseNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Nicodemo, miya Jodio esohui huohuijji; Eyacuiñajjija esohui yahuajo nei etehueꞌyo huohuijji. Jamajjeya ¿yajjajo miquea ba jjima ebacua eshoꞌi cuayani jayojja jama epojji ebaꞌejji pea baꞌeme epoꞌyojji? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Eyaya, Huaniya ma ona besameejji poaniya peaꞌai miya eꞌe jojo nei huohuiaña jama baꞌa: Ma ecuanaja eba poa huohuiaña pea baꞌeme epoꞌyojjijo; ma ecuaa yahuajo banaje peaꞌai huohuiaña. Jamatii miya, pea Jodio esohui huohuijji cuana peaꞌai ecuanaja esohuijo jama poani baꞌa: “Chojja, siajje oya cuana poani”. Eꞌe, miquianaaya ecuana siajjepojji poso aña —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eꞌe, eyaya miya huohuiaña ebacua eshoꞌi cuayani jayojja jama Eyacuiñajjija Edojjoshahua Pameya miya pea jjashahuabaquime po mee cajeꞌyo, Eyacuiñajji nijje ebaꞌe tiitiiꞌyojji. Jamatii ecuea esohui quea quehua miquea. Jamajjeya eyaya miya Eyacuiñajjija ejjashahuabaquiꞌyojji eyajo huohuiajo, ¿aꞌa ecuea esohui quea jaꞌa poaje miquea? Chojja, quea quehua poaje peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","¡Shajjaꞌajjacue ecuea esohui, Nicodemo! Dejja cuana eyahuasijje dobiquiꞌyo majje meshi yasijje epoe oꞌoyajji pojjeama ojjaña eyajo baꞌe huohuiya, Eyacuiñajjija ejjashahuabaquiꞌyojjijo peaꞌai epoe oꞌoyajji pojjeama huohuiya. Eya ma ojjañaja Edoe Mese eyajo baꞌeꞌyonaje. Eya eyajo baꞌe poeyanaje meshi yasijje. Jamajjeya eyaye nei baña ojjaña eyajo, Eyacuiñajjija ejjashahuabaquijji ecuea eba peaꞌai —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cuanaya eya, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji baꞌehuanasohuajea cajeꞌyo cuaa. Eꞌe, yahuajo nei nei meshi jabojo Moisesiya baa peyo jayojja acui aojo baꞌehuanasohua ca poa ojjañaja ebajji; ojjaña joya peyoja ijjia baa peyo jayojja ba cajo, Eyacuiñajjiya huaquia mee caꞌya poa. Jiquio ecua Moisesiya baa peyo jayojja baꞌehuanasohua ca poa jayojja jamaya quijje eya baꞌehuanasohuajea cajeꞌyo cuaa acui ecueataꞌapeejo ojjañaja mimishijo manoꞌyohua, mimishi cuijeaꞌyojji sosejje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jamajjeya Eyacuiñajjiya ojjaña baꞌe tiitii mee cajeꞌyo onijje, ca ejo jama jjashahuabaquiajo baꞌa: “Eꞌe jojo nei ohuaya ecuea mimishi cuijea neinei cajeꞌyo”. Eꞌe, enijje jjapeequiajo, Eyacuiñajjija quea nee nee epo meeꞌyojji pojjeama cuaquijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Eꞌe Nicodemo —Jesosa poanaje peaꞌai—, Eyacuiñajjiya ojjaña cuana ojjaña meshijo baꞌe quea jea nee nee acani. Jamajjeya eya, oja Bacua Ejja oe nei huoojea canaje ojjañaja mimishijo manoꞌyohua. Jamajjeya ojjaña joya eꞌe jojo nei enijje jjapeequiani Eyacuiñajjiya baꞌe tiitii mee cajeꞌyo onijje eyajo; quea nee nee epo tiitii meeꞌyojji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ecue Chiija eya huoojea jjima ojjaña tecueaa. Ecuea ejjashahuabaquiꞌyojji jama pojjeama baꞌa: “Ojjaña cuana quea mimishi nee poanijo, quea nee nee po meejeꞌyo; quea nee tii tii”. Chojja, Eyacuiñajjija eya, oja Bacua Ejja oe nei onijje eyajo baꞌya poa meshi yasijje huoojea ca poa. Ojjañaja mimishi cuijeaꞌyo majje enijje baꞌe tiitii meejeꞌyo —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jamajjeya ojjaña joya eꞌe jojo nei enijje jjapeequiani Eyacuiñajjiya huohui caje jama baꞌa: “Miquianaya ecue Bacua Ejjaja epeejji eꞌe jojo nei poanijo, mimishi cuijeajeꞌyo. Quea nee nee epo meeꞌyojji pojjeama cuaquijo” Eyacuiñajjiya acaje —Jesosa poanaje—. Pea cuana enijje jjapeequi ajjajo ca ca Eyacuiñajjiya yahuajo jama acaje baꞌa: “Miquianaya ecue Bacua Ejja oe nei nijje jjapeequi ajjajo cajaa ajeꞌyo, mimishi cuana cuijeaꞌyo jjima ajeꞌyo. Jamajjeya quea nee tii tii poajeꞌyo” Eyacuiñajjiya acaje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Eꞌe, Eyacuiñajjiya eya, oja Bacua Ejja huoojea canaje esohui eꞌe nei huohuiya, ojjaña cuana quea jjashahuabaqui jaꞌa nee po meeya. Eꞌe, eya cuaquijiji jayojja jama poanijo ojjaña quea jjashahuabaqui jaꞌa po meejeꞌyo. Jamatii quea huiso cuana ecuea esohui shajjaꞌajja sa po ajja, mimishi cuana ojaya quea boti neejojo. Quea mimishi nee baꞌe, de. Jamajoya Eyacuiñajjiya oya cuana cajaa acajeꞌyo. Quea nee tii tii poajeꞌyo cuaquijo. ");
INSERT INTO eseNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Quea mimishi baꞌeja botiꞌama Eyacuiñajjija esohui eꞌe nei; cajaa acani quea mimishi baꞌyaniya jjejojo. Jamajjeya enijje jjapeequi ajja. Quea mete jjashahuabaquiani jama baꞌa: “¡Jesosaa mo tecuea caje ecue mimishijo!” ");
INSERT INTO eseNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ojjaña joya quea pame nee baꞌeya ca ca Eyacuiñajjija esohui quea boti nee acani. Enijje jjapeequianijo, eyaya oya cuana quea jjashahuabaqui jaꞌa po meeaña. Jamajjeya oya cuana jama poani baꞌa: “Eꞌe, Eyacuiñajjiya eya quea pame baꞌe meesahua cani ojaya esohui jayojja” poani —Jesosaa Nicodemo huohui canaje. Majoya Jesosa Nicodemo nijje mimipajeanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Majoya Jesosa Jenosanenajo ani poquinaje o shajjaꞌajjajji cuana nijje Jodea meshi yasijje, pea cuiñajji cuana huasijje. Jomajo nequi cuana Jesosaa sohuihuohui canananaje. O shajjaꞌajjajjiya dejja cuana besa mee canananaje Eyacuiñajjijo. ");
INSERT INTO eseNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Huaniya jomajo dejja besa mee canaje peaꞌai Enoni cuiñajjijo, Sanima cuiñajji pejjejo peaꞌai ena quea doejo. Ojjaña pojjajo quea huiso dejja cuana, ponaña peaꞌai Huani que poquinaje. Eyacuiñajjijo enajo besa mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Eꞌe, ma pojjajo emeshi mese Enodeja Huani jeanobia jjima poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jamajjeya oe Jodio dejjaa Huanija epeejji cuana mimicuiajeanobia canaje. Jama poanaje baꞌa: —¿Ache dejjaa acuae mi Eyacuiñajjijo enajo besa mee majje eseya eꞌe jojo nei quea boejea po mee cajeꞌyo soꞌo? ¿Aꞌa Huaniya pojjaꞌa? ¿Aꞌa cuae peaa besa mee cajji, Jesosa shajjaꞌajjajjiya pojjaꞌa besa mee cajji? —Jodio poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jamajjeya Huani que poquinaje ojaya epeejji cuana, huohuiꞌajjaa jama baꞌa: —Esohui huohuijji, ma dejja joya yahuajo minijje nequinaje cuei ojje mijijje, ma ojo miyaya jama huohuinaje baꞌa: “Oya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji”, maaya jjeya o shajjaꞌajjajji nijje onaya besa mee cani; ojjaña cuana aje oe jjeya o que poquiani. Jesosaa quea huiso nee nee Eyacuiñajjijo besa mee cani. ¿Apiojji shai? —poanaje Huanija epeejji cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Huaniya oja epeejji cuana sajaꞌa canaje: —¡Aꞌa quea yeno pojji! Jamaya Eyacuiñajjiya oya pea cuana besa mee cani. Yahuajo quea huiso dejja e que poeyanaje; Eyacuiñajjiya oya cuana huoojea canaje. Jjeya ca ca ojjaña cuana Jesosa que poquiani; Eyacuiñajjiya oya cuana huoojea cani. ");
INSERT INTO eseNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Miquiaaya ecue sohui yahuajo shajjaꞌajjanaje. Jama poanaje baꞌa: “Eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama. Eyacuiñajjiya eya huoojea canaje ebionei Jesosajo huohuiya”. ");
INSERT INTO eseNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Eꞌe —Huani poanaje—, Jesosajo jama jjashahuabaquicue baꞌa: Ejjahuanaquijjijo, epona yahueja ehuanase poajeꞌyo. Jamatii yahueja epeejjiya poe majje jjahuanaquiequi ba cani. Yahue ojaya ehuanase nijje mimiani shajjaꞌajja majje quea bihui nee poani ojaya epeejji. Jiquio ecua yahueja epeejji o ba majje quea bihui nee poani jayojja jama eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji Jesosa bajjani ba coo majje quea bihui nee nee poani; eya Jesosaja epeejji. ");
INSERT INTO eseNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","¡Ojjaña cuaa oya cashajjaꞌajja tiitii cahua! Quijje ca ca ojjaña cuana e que poepajeajeꞌyo. Jamatii capoahua —poanaje Huani, ma ona besameejji poani. ");
INSERT INTO eseNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","¡Bacue! Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji eyajo tii ania poa, meshi yasijje poeyanaje. Jamajjeya oya ojjaña huoojeaꞌyojji poani tii; ohuaya eꞌe jojo nei Eyacuiñajjija ejjashahuabaquijji ba mee cani. Huani ca ca jiquiojo anija mejo, dejjaja jea. Jamajjeya aje oe dejja, oja chii jayojjaya. Dejja jama mimiani. Jamajjeya Eyacuiñajjija esohui oe pojji ba mee cani, Huaniya. ");
INSERT INTO eseNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji ca ca Eyacuiñajji nijje eyajo ania poa. Jamajjeya ohuaya jama huohui cani baꞌa: “Eyacuiñajjija ejjashahuabaquijji ecuea eba nei nei. Maya eyaya miya huohuiaña”. Jamatii ojaya esohui shajjaꞌajja sa po ajja beca cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ojjaña joya eꞌe jojo nei oya shajjaꞌajja sa poani ca ca jama poani baꞌa: “Eyacuiñajjija esohui eꞌe nei; ¡Cashajjaꞌajjaꞌyahua!” ");
INSERT INTO eseNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Eꞌe, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajjiya, Jesosaa Eyacuiñajjija esohui huohui cani eꞌe jojo nei. Eyacuiñajjija Edojjoshahua Pameya oya huohui meesahua cani; quea jaꞌa nee ameesahua cani tii tii. ");
INSERT INTO eseNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Eyacuiñajjiya oja Bacua Ejja quea jea nee nee acani tii. Jamajjeya oya jama poani Jesosa nijje: —Miya ecuea ecue Bacua Ejja quea jea nee nee. ¡Jamajjeya ojjaña huoojeaꞌyojji pocue tii, meshijo, eyajo peaꞌai! —poani Eyacuiñajji. ");
INSERT INTO eseNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jamajjeya ojjaña joya eꞌe jojo nei Jesosa nijje jjapeequiani, Eyacuiñajjija Bacua Ejja shajjaꞌajja cani peaꞌai onijje baꞌe tiitii mee cajeꞌyo eyajo. Ojjaña joya o shajjaꞌajja sa po ajja ca ca onijje ebaꞌe meeꞌyojji pojjeama. Eyacuiñajjiya oya cuana cajaa acajeꞌyo; quea nee nee poajeꞌyo tii cuaquijo. ");
INSERT INTO eseNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jamajje Jesosa Jodea meshijo ani quea huiso dejja cuana o shajjaꞌajjaa poeyanaje, Eyacuiñajjijo besa meeya peaꞌai. Jesosa nijje jjapeequinaje quea huiso nee nee. Majoya aje oe onaaya Jodio esohui huohuijji cuana, Paniseo cuana peaꞌai huohui canaje jama baꞌa: —Jesosaja epeejji cuana quea huiso nee nee; Huanija epeejji ca ca oe pojji —jamaya poanaje pea cuana. Ma shajjaꞌajja majje Paniseo cuana quea quene poanaje Jesosa nijje. Jjashahuabaquinaje jama baꞌa: —Ecuana quea huiso epeejji sa poani Jesosaja epeejji huisoajja —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jamatii Jesosa shajjaꞌajjajji cuaa Eyacuiñajjijo enajo besa mee canaje cuana, Jesosa que poeyajo. Jesosaja ca ca pea cuana Eyacuiñajjijo besa mee jjima.) ");
INSERT INTO eseNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jamajjeya Paniseo cuana onijje quea quene ba majje Jesosa Jodea meshijo ani poqui oꞌoyanaje Janinea meshi yasijje, ecuana nijje poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Janinea meshi yasijje ejiojjijje poquije Samania meshijo aniñaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samania meshijo ani poqui majje Sica cuiñajji pejjejo Jesosa jomishoca aninaje ena eteohuejja quea doe pejjejo. Jomajo yahuajo nei nei Jodio etiiquianaa Jacobohua ma meshijo que quia ca poa oja bacua ejja Jose. ");
INSERT INTO eseNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma quejo yahuajo nei nei Jacobohua teo mee ca poa ena eteohuejja quea doe nee nee. Jamajjeya Jesosa ma ena eteohuejja huasijje poeyanaje eshequi biacojjajja nequijo. Jesosa hueahuea majje anioquenaje ma ena eteohuejja pejjejo ejomishocajji. ");
INSERT INTO eseNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Anioque majje Jesosaa ecuana acanaje jama baꞌa: —¡Poquicue miquianaya Sica huasijje bobi jjesheya! Ecuana poquiajo oe Samania epona poeyanaje ena eteohuejja huasijje ena jjequisohuaa jjonojo. Jesosaa oya huohui canaje jama baꞌa: —Epona, ¡che mo ena quiacue eꞌishijji! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jodio cuanaja Samania cuana botiꞌama nei. Samania cuana nijje mimi ajja, ojee ijjiaꞌijjia ajja peaꞌai Jodio pojjeama jjejojo. Jamajjeya ohuaya Jesosa sajaꞌa canaje: —Miya Jodio dejja; eya ca ca Samania pona. Jamajjeya ¿apiojji miya enijje mimiani enajo, ena quiajji? —poanaje Samania pona. ");
INSERT INTO eseNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","—Eꞌe —Jesosa poanaje—, eya miquea ba jjima. Eyacuiñajjija ejjashahuabaquiꞌyojji quea pame nee miquea ba jjima peaꞌai. Maya miquea eba jojjemo miya enijje jama mimime pome baꞌa: “¡Che mo oe ena quiacue eꞌishijji!” Miya jama enijje emimi jojjemo eyaya miya quiame ena naba tajaꞌama epoꞌyojji tii tii —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Eꞌe pojjaꞌa —epona poanaje—, ena eteohuejja quea doe nee nee nequi. Miquea chamaꞌ ena ejjequisohuajji. Jamajje ¿achejo acuae ena nequi, ma ena ishi majje eya quea naba taja po maja ajja epojji? ");
INSERT INTO eseNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Esejaya etiiquianaa Jacobohua jiquio ena teohuejja mee ca poa yahuajo nei. Ohuaya oja bacua cuana, oja ñajjajja cuana, pea huo cuana peaꞌaiya ishi mee majamaja ca poa jiquio ena. Majoya ojjañaa ecuaaya jiquio ena ishi majamajaña. ¿Aꞌa cuae miquea pea ena eba? ¿Achejo nequi pea ena quea pame nee nee? Jacoboja ba jjima poa. Miya pojjaꞌa quea jjashahuabaqui jaꞌa nee nee. ¿Aꞌa Jacobo quea jjashahuabaqui jaꞌa pishana? —huohuiꞌajja canaje eponaa. ");
INSERT INTO eseNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Epona —Jesosaa huohui canaje—, ojjaña miquianaya jiquiacua poeyani ena ishiya. Jamatii ishi majje quea naba taja po oꞌoyani. ");
INSERT INTO eseNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Eyaya pea ena quiaje ojjañaja eꞌishijji. Ma ena ishi majje quea naba taja po oꞌoya ajja. Eꞌe, jjanijo ena oshe quea pame nee cuayani, huosaꞌyo ajja. Jiquio jayojjaya eyaya quiajeꞌyo. Jamajjeya eyaya miya baꞌe tiitii meejeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—¡Che iña maya pea ena quiacue eꞌishijji! —Samania ponaa Jesosa acanaje—. Jamajjeya eya quea naba taja po ajja oꞌoya poaje. Jamajjeya eya jiquio ena eteohuejja huasijje epoe oꞌoyajji pojjeama ena jjehuaa —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Eꞌe, ¡poquicue! ¡Miqueahue jjequicue! —Jesosa poanaje ma epona nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Chamaꞌ ecueahue —sajaꞌame acanaje eponaa. —Eꞌe jojo nei jjeya miquea yahue chamaꞌ —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ecuea eba jama baꞌa: Yahuajo miquea yahue cuana me oejje huisome poa, ojjaña jja miquea yahue ehuei poanaje. Jjeya miya pea dejjajo baꞌe, miquea yahue pojjeamajo. Jamajjeya miya eꞌe jojo nei poani: “Chama ecueahue” —Jesosaa acanaje Samania pona. ");
INSERT INTO eseNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Eꞌe jojo nei ojjaña miquea eba. Jamajjeya ecuea eba miya Eyacuiñajjija esohui huohuijji eꞌe jojo nei. ");
INSERT INTO eseNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ecuanaja etiiquianaa Eyacuiñajji bihuia ca poa jiquio Samania meshijo, eyiyo biajje. Miquianaya, Jodio cuana ca ca jama poani baꞌa: “Jenosanenajo ca ca oeya Eyacuiñajji bihuiajji, pea eyiyojo pojjeama” miquianaya poani —poanaje Samania pona. ");
INSERT INTO eseNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—¡Shajjaꞌajjacue mo, epona! —Jesosaa oya acanaje—. Quijje pishana miquianaaya Eyacuiñajji, esejaya Chii bihuiaje, ojjañaa. Jiquio eyiyo huasijje poe jjimaa, Jenosanena huasijje poqui jjimaa peaꞌai oya bihuiaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jjeya ojaya esohui jayojja jama pojjeama aje oe miquianaaya, Samania cuaa Eyacuiñajji bihuiaña. Oya miquianajaya ba jjima. Ecuanaa ca ca Eyacuiñajji bihuiaña ojaya esohui jayojja. Eya oja huoojeaꞌyo ojjaña mimishi cuijeaꞌyojji Jodio dejja. Jamajjeya Eyacuiñajji ecuanaja eba, Jodio cuanaja. ");
INSERT INTO eseNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jamajjeya jjeya nei ojjañaa esejaya Chii, Eyacuiñajji bihuiaje eꞌe jojo nei, ojo quea jaꞌa nee jjashahuabaquije. Eꞌe, Eyacuiñajji jama poani baꞌa: “Jamaya eya cabihuia cahua ojjañaa. Jamaya ecuea quea boti nee” poani. ");
INSERT INTO eseNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Eyacuiñajji yani tii tii eshe. Jamatii oya jjaba meequi ajja ecojjaa. Jamajjeya o bihuiajji epohua Eyacuiñajji cabihuia cahua eꞌe jojo nei, ojaya esohui jayojja jama quea jaꞌa nee ojo jjashahuabaquiani —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Eꞌe —poanaje epona—, ecuea eba quijje Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji poeje. Oya Quito bajjani poaje. Poe majje ohuaya ecuana quea jaꞌa nee ba mee caje Eyacuiñajjija esohui. ");
INSERT INTO eseNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Eya ca ca iña jiquio Eyacuiñajjija huoojeaꞌyoya Quito bajjani. Jjeya nei miya Quito nijje mimiani —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Majoya Jesosa shajjaꞌajjajji cuana bobi jjeshe majje poe oꞌoyanaje Jesosa que. Jesosa ba cañaꞌyonaje Samania pona nijje mimiani. Ba majje jjashahuabaquinaje jama baꞌa: —¿Apiojji shai Jesosa epona nijje mimiani? —jamatii huohuiꞌajja jjima: —Epona, ¿ajeo miya poeyanaje? —ajjima: —¿Jesosa, ajeo miya Samania epona nijje mimiani? —jamaya ecuana mimi jjima Jesosa nijje poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Majoya ena jjequijji ohua acani jea canananaje eponaa, poquicuajinaje Sica huasijje huohui pohua. ");
INSERT INTO eseNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ojjaña cuana huohui cañaquinaje jama baꞌa: —¡Poecuajicue oe! Oe dejja ena eteohuejja pejjejo ani; ohuaya ojjaña ecuea ebaꞌejji huohui caꞌyonaje. ¿Aꞌa oya pojjaꞌa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji? ¡Poeꞌajja! ¡Ejjabaꞌajjaquiqui! —poanaje epona. ");
INSERT INTO eseNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eponaa huohui cajje ojjaña Sicajo baꞌe poqui canaje Jesosa baa. ");
INSERT INTO eseNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ojjaña cuana poe jjimahuajo, ecuana, o shajjaꞌajjajjiya Jesosa nijje jama poanaje baꞌa: —Esohui huohuijji, ¡bobi oe ijjia socue! ");
INSERT INTO eseNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jamatii Jesosaa jama acanaje baꞌa: —Ecuea pea bobi yani ecuea eꞌijjiajji, ma miquea ba jjima. ");
INSERT INTO eseNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jamajjeya ecuana ojee miminaje: —¿Aꞌa pojjeama oya pea cuaa bobia canaje? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesosa ecuanaja esohui shajjaꞌajja majje jama poanaje baꞌa: —Bobi ijjia majje miquianaya quea bei poani. Ecue Chiiya eya huoojea canaje ojjaña jaahuanajji; ojjaña ojaya esohui ajeyoꞌyo majje eya quea bei poaje, bobi ijjia majje jayojjaya —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Miquianaya jama poani baꞌa: “Quijje anoso sejjajeꞌyo, ebeca pee peaꞌai baꞌime po majje. Eyaya ca ca miquianaya huohuiaña jama baꞌa: ¡Bacue! Jomajo quea huiso dejja cuana poeani. Anoso ejahua jayojjaya jama oya cuana poeani. Eꞌe, oya cuana Eyacuiñajjijo jjashahuabaquiani. Onijje jjapeequiꞌyo sa poani. ¡Jamajjeya enijje jjapeequi meesahuacue! ");
INSERT INTO eseNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Eꞌe, echacojji anoso quecuajji, anoso sejjajji peaꞌai eque meseya sosequia cajji. Jamajje ojjaña quea bihui nee poajeꞌyo —Jesosa poanaje—. Oya jayojjaya Eyacuiñajjiya acaje ojaya echacojji cuana. Joya esohui huohuicoojji cuana sosequia caje; joya pea cuana enijje jjapeequi meesahuajji poani peaꞌai sosequia caje. Enijje jjapeequiajo baꞌe tiitii meejeꞌyo enijje eyajo. Jamajjeya ojjaña cuana quea bihui nee nee poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Eꞌe, yahuajo jama poanaje cuana baꞌa: “Oe echacojjiya esoꞌ quecua majje quijje pea echacojjiya chicha cajeꞌyo”. Jjeya jamaya eꞌe jojo nei poani. ");
INSERT INTO eseNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jjeya eyaya miya huoojeaña anoso chichajji jama, ojjaña cuana enijje jjapeequi meesahuaa. Yahuajo Eyacuiñajjija esohui huohuijjiya oya cuana esohui ba mee canaje. Jamatii ojjaña cuana jjabahuejjaqui jjima. Jjeya miquianaaya esohui huohui oꞌoyajo, oya cuana ecuea epeejji eꞌe jojo nei poajeꞌyo —Jesosa poanaje ecuana nijje, o shajjaꞌajjajji cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Majoya quea huiso nee nee Samania cuana poeyanaje Jesosa que. Oya cuana Samania eponaja esohuijo jjashahuabaquiani. Ohuaya jama acanaje baꞌa: —Jiquio dejjaa ojjaña ecuea ebaꞌejji huohui caꞌyonaje. Eꞌe jojo nei jiquio dejja Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, Quito bajjani —epona poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jamajjeya Jesosa que poe majje Samania dejja cuana jama poanaje baꞌa: —Esohui huohuijji, ¡ecuana nijje che anicue! —Eꞌe, anije ecuana —Jesosa poanaje. Jamajje aninaje. Beca cahuime sohuihuohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jamajjeya Jesosaja esohui shajjaꞌajja majje ojjaña cuaa jama acanaje baꞌa: —¡Eꞌe jojo nei oya Quito! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Epona nijje jama poanaje: —Yahuajo miquea esohuijo ecuana beshahua nei jjashahuabaquinaje oya eꞌe jojo nei Quito. Jjeya ca ca oja sohui shajjaꞌajja majje ecuanaja eba nei nei Jesosa eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji; mimishi cuijea caꞌyajje aje se baꞌe tiitii mee cajeꞌyo eyajo —poanaje Samania dejja cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jamajjeya Samania meshijo beca cahuime ani majje Jesosa poqui oꞌoyanaje Janinea meshi yasijje, Cana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yahuajo Jesosaa ecuana, o shajjaꞌajjajji cuana jama acanaje baꞌa: —Eꞌe jojo nei pea cuaa Eyacuiñajjija esohui huohuijji shajjaꞌajja cani. Jamatii ojaya cuiñajjijo ojaya huapa pojjeama cuana ca ca oe jjashajjaꞌajjaqui sa poꞌyo ajja. Jamajjeya Jesosa jjeya Nasanena huasijje, ma o eshoꞌyahua baꞌya poa huasijje dobiqui jjima. ");
INSERT INTO eseNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jamatii Janinea meshijo ejiojjijje poquianijo, Janinea dejja cuana oya ba majje jama poanaje baꞌa: —Esohui huohuijji, mi poeꞌyajo ecuana quea bihui nee nee. Yahuajo ecuanaa miya banaje Jenosanena huasijje poqui. Eꞌe, esohuidojojji cuaa yahuajo Jodioja ebacua cuana cuiaꞌyo jjima shejo, Jenosanena huasijje ojee ijjiaꞌijjiaa poqui ecuaaya miya banaje. Miyaya quea huiso cuana jjaajaqui meeꞌyonaje, ma dejjaa ajjima acani anaje quea huiso peaꞌai. Eꞌe, miya Eyacuiñajjija esohui huohuijji nei nei —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jamajjeya Jesosa poqui oꞌoyanaje Cana huasijje, ma ohua yahuajo ejjahuanaquijjijo ena acuijjajja na pojji acaꞌya poa huasijje. Canajo Jesosa aninaje ecuana nijje, o shajjaꞌajjajji cuana nijje. Jamajjeya oe emeshi mese neija dejja huoojeasahuajjiya Jesosajo shajjaꞌajja canaje: —Jesosa Jodea meshijo yahuajo ani Janinea meshi yasijje poeꞌyonaje. Canajo jjeya nequi. ");
INSERT INTO eseNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Oja bacua ejja quea mano nee nee jaa quea huesha pishana, Capenaomajo jaa. Jamajjeya maya shajjaꞌajja majje Jesosa que poquicuajicuajinaje. Jama acanaje baꞌa: —Jesosa, ¡poecuajicue Capenaoma huasijje! ¡Ecue bacua ejja jjaajaqui meeꞌyocue! Quea mano nee nee jaa, beshahua nei poquijeyo jaa —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesosa ojjaña cuana nijje jama poanaje baꞌa: —Miquiana cuana Janinea meshijo baꞌe beshahua nei jjashajjaꞌajjaqui ajja. Eyaya ma dejjaa ajjima acani mi amajamajajo, miquianaya jjashahuabaqui ajja jama baꞌa: “Eꞌe jojo nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji” —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Esohui huohuijji Jesosa, jamatii —ejeajji poanaje—. ¡Poecuajicue oe, ecue bacua ejja epoquijeyo cuahuajo! ");
INSERT INTO eseNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Epeejji, ¡quea bihui poquicue miquea equi yasijje! Eyaya mique bacua ejja jjaajaqui meeꞌyonaje; apoa poanaje —Jesosaa emanojaaja ejeajji acanaje. Jesosaja esohui shajjaꞌajja majje ebacuaja ejeajji quea bihui nee poquinaje jjashahuabaquiani jama baꞌa: —Eꞌe jojo nei Jesosa quea sohui poja nee nee; ecue bacua ejja jjaajaqui mee caꞌyonaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ojaya equi yasijje poquianijo, oja chacojji cuana poeyanaje. O ba majje taaanaje: —¡Miquea ebacua ejja boecaꞌyonaje! Quea pame nee jjeya aniꞌyo. Huaquiaꞌyonaje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—Eꞌe —ejeajji poanaje—, jamaya quea pame nee. ¿Ache nei eshequi nequijo acuae apoa poanaje soꞌo? —Yahuajo apoa poanaje, omamecajje tii, eshequi ejjajeapaaquijo oya boecaꞌyonaje —poanaje echacojji cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","—Eꞌe nei —ejeajji jjashahuabaquinaje—, omamecajje tii eshequi ejjajeapaaquijo Jesosaa eya huohui canaje jama baꞌa: “Miquea ebacua ejja jjaajaquiꞌyonaje; apoa poanaje” —ejeajji poanaje. Jamajje equi yasijje dobiqui majje ojaya huapa pojjeama cuana nijje jama poanaje baꞌa: —Eꞌe, Jesosaa ecue bacua ejja jjaajaqui mee caꞌyonaje, boeca mee caꞌyonaje. ¡Oya ca ca oe Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji! —poanaje ebacuaja ejeajji. Jamajjeya ojjaña jama poanaje baꞌa: —Eꞌe jojo nei oya Jesosa. ");
INSERT INTO eseNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jamaya Janinea meshi yasijje poe oꞌoya majje Jesosaa Cana cuiñajjijo pea dejjaja ba jjima aca oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Majoya quijje ojjaña Jodio dejja cuana poqui oꞌoyanaje Jenosanena huasijje ojee ijjiaꞌijjiaa Eyacuiñajji bihuiaa. Jamajjeya ecuanaya Jesosa nijje, o shajjaꞌajjajji cuana nijje peaꞌai Jenosanena huasijje poqui oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jenosanena cuiñajji mei jiyojo Ñajjajja Dobiquijji esecue yani. Ma esecue pejjejo yani ena, bae sisi jama, ebesajji, Emeo esohuijo Metena ena bajjani. Ena sahuajo yani me oejje equi sisi. ");
INSERT INTO eseNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jomajo quea huiso emano cuana jaanaje: cojjamaꞌ cuana, jeoꞌajja cuana, jiojjijjajja cuana peaꞌai. Ohuaya esohuidojojji ishoaꞌajja cani; jama jjashahuabaquime poani baꞌa: —Eꞌe, Eyacuiñajjija esohuidojojjiya ena cajeaquejjo cahua. Jamajjeya eya ena huasijje nequidobiquiajo, jjaajaqui mee cajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Eꞌe, Jodio cuaa jama acanaje baꞌa: —Esohuidojojjiya quijje nei poe huichaꞌanijo ena jeaquejjo mee cani. Ena jeaquejjo cajo, ojjaña emano cuana ena huasijje canequidobi cuajiquiahua. Joya ebionei besajeꞌyo ca ca jjaajaqui mee cajeꞌyo, huaquia mee cajeꞌyo peaꞌai Eyacuiñajjiya —poanaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jamajjeya oe dejja jomajo jeoꞌajja jaanaje. Quea shequiaja huiso nee nee jaa poa, 38 shequiajame. ");
INSERT INTO eseNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesosaa poe majje ba canaje dejja emanojaa jeoꞌajja. Jesosaja eba ma dejja quea shequiaja huiso nee nee jaa poa. Jamajje oya huohuiꞌajja canaje: —¿Aꞌa miya jjaajaquiꞌyo sa poani? ¿Aꞌa miya jeo sa poani? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Eꞌe —emanojaaa sajaꞌa canaje—, jamatii chamaꞌ pea dejja e dojojji ena jeaquejjo poani yasijje e besa meeꞌyojji. Jamajjeya eya ebionei ebesaꞌyojji pojjeama. Eya jjapashineijje poquianijo, pea ebionei besacuajiquije —poanaje emanojaa, jeoꞌajja. ");
INSERT INTO eseNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesosaa oya jama acanaje baꞌa: —Epeejji, ¡nequisohuaꞌyocue oe! ¡Jeocue! ¡Miquea equi yasijje equipajaajji bebo majje dojoꞌyocue! ");
INSERT INTO eseNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jjeya nei jeoꞌajja jeocuajiꞌyonaje. Jamajje nequisohuaꞌyonaje; oja equi yasijje equipajaajji bebo majje dojo caꞌyonaje; jeopoquiꞌyonaje. Jesosaa oya jeo mee caꞌyonaje Jodioja epojja ejomishocajjijo. ");
INSERT INTO eseNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jamajjeya ma dejjaa equipajaajji dojo cani ba majje Jodio cuana quea tecue onijje poanaje: —¡De! ¿Apiojji acuae miyaya equipajaajji dojoaña soꞌo? ¡Jjeya epojja ejomishocajji, de! ¡Aquiana jjeya dojoca ajja! Jamaya eseja esohui huohuijji cuaa huohui cani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma dejja ejeoꞌyohua sajaꞌa canaje jama baꞌa: —Jamatii. Oe dejjaa eya jeo meeꞌyo majje jama acanaje baꞌa: “¡Poquicue miya; miquea equipajaajji bebo majje dojocue!” poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—Eꞌe pojjaꞌa —Jodio cuana poanaje—. “¡Miquea equipajaajji dojocue!” poanaje. ¿Ae bajjaniya acuae maya miya huohui canaje soꞌo? —huohuiꞌajja canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","—Cuaꞌa, de —sajaꞌame acanaje—. Ache dejjaa shai eya jeo mee caꞌyonaje. E jeo meeꞌyo majje oya pea dejja quea huiso nijje poquinaje —poanaje. (Eꞌe, dejja quea huiso nee nee jomajo ani.) ");
INSERT INTO eseNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Quijje pishana Jesosaa ma dejja oja jeo meeꞌyo ba caꞌyonaje Eyacuiñajjija equijo. Jama huohuime acanaje baꞌa: —Eꞌe epeejji, jjeya miya quea pame nee nequiꞌyo, quea aja nee nequi. Jamajjeya ¡aꞌa quea mimishi po oꞌoyajji! Quea mimishi po oꞌoya majje mi quea mano nee nee po oꞌoya chanaꞌ, quea tai nee nee; yahuajo jeo ajja, quea nee pishana poanaje —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesosa shajjaꞌajja majje poquiꞌyonaje Jodio cuana huasijje. Huohuiqui canaje jama baꞌa: —Eꞌe, Jesosa bajjaniya eya jeo mee caꞌyonaje —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jamajjeya jeoꞌajja poanajeya huohui cajje Jodio cuaa Jesosa niñeba canaje; quecuaꞌyo sa acanaje peaꞌai, Jesosaa jeoꞌajja cuana jeo mee caꞌyonaje epojja ejomishocajjijo. ");
INSERT INTO eseNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","—Ecue Chiiya quea pame nee acani tii tii epojja ejomishocajjijo peaꞌai —Jesosaa oya cuana sajaꞌa canaje—. Jamajjeya eyaya peaꞌai ecue Chiiya jayojjaya jama quea pame aña ojjaña pojjajo. ");
INSERT INTO eseNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jamajoya Jodio etii cuaa Jesosa quecua sa neinei acanaje. Jama huohui canaje baꞌa: —Esejaya etiiquiaa yahuajo esohui tehue ca poa jama baꞌa: “¡Epojja ejomishocajjijo aꞌa chacojji!” aca poa. Jodio cuaa Jesosa niñeba canaje jama peaꞌai baꞌa: —Oya, Jesosa etiiquianaja etehueꞌyo jama po ajja —poanaje. Yahuajo Jesosa Jodio nijje jama poanaje peaꞌai baꞌa: —Eyacuiñajji ecue Chii, de. —Chojja, de, Jesosa siajje poani —niñebame acanaje Jodio cuaa Jesosa. Jodio cuaa jama acanaje peaꞌai baꞌa: —Jesosa siajje poani jama baꞌa: “Eya Eyacuiñajji jayojjaya poani” siajje, de —jamaya Jodio cuaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jamajjeya Jesosaa ma Jodio etii cuana huohui canaje jama baꞌa: —Eyaya miquianaya eꞌe jojo nei huohuiaña jama baꞌa: Eyacuiñajjiya eya, oja Bacua Ejja oe nei huoojea canaje; eyaya ojaya esohui jayojja jama aña. Eyaya huohuiaña ecue Chiija ejjashahuabaquijji, ecuea ejjashahuabaquijji pojjeama. Ojjaña ecue Chiiya acani ecuea eba. Jamaya ca ca eyaya aña peaꞌai. Eꞌe, ojjaña ecue Chiiya acani eyaya aña peaꞌai, eya oja Bacua Ejjaa jjejojoya. ");
INSERT INTO eseNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eya ecue Chiija quea jea nee nee. Jamajjeya eya ba mee cani ojjaña joya ohua amee sa acani huiso tii. Eyaya ma dejjaa ajjima acani aña ba majje miquianaya jama poaje baꞌa: “Eꞌe nei, yahuajo jamaya ajjima cuanaja poa. Chamaꞌ pea Jesosa jayojja” poaje miquianaya. ");
INSERT INTO eseNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jamaya ecue Chiiya eya amee cajeꞌyo baꞌa: Ecue Chiiya emanoꞌyojaa shequi mee ca oꞌoyani jayojja jama eyaya baꞌe meeje oꞌoya, ojjaña ecue babacaꞌyo cuana peaꞌai —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ecue Chiija ehuohuijji pojjeama joya ojaya epeejji pojjeama, joya quea nee nee poajeꞌyo tii cuaquijo. Joya ojaya epeejji poani baꞌe tiitii mee cajeꞌyo onijje ehuohuijji pojjeama peaꞌai. Chojja, ohuaya jama huohuime acanaje baꞌa: “Ecue Bacua Ejjaa cahuohui cahua ecuea ejjashahuabaquiꞌyojji”. ");
INSERT INTO eseNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jamajjeya ojjaña joya ecue Chii shajjaꞌajjajji poaniya eya oja Bacua Ejja shajjaꞌajja cajeꞌyo peaꞌai. Ojjaña joya eya Eyacuiñajjija Bacua Ejja shajjaꞌajja sa poꞌyo ajja Eyacuiñajji, e huoojeaꞌyojji shajjaꞌajja sa poꞌyo ajja peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Eꞌe jojo nei nei ecuea ehuohui minijje jama baꞌa —Jesosa poanaje—: Ojjañaa joya ecue sohui shajjaꞌajja cani, e huoojeaꞌyojjija sohui eꞌe jojo nei shajjaꞌajjajji poani peaꞌai baꞌe tiitii meejeꞌyo enijje eyajo; cuaqui yasijje epoquiꞌyojji pojjeama. Chojja, oya cuana yahuajo eshahuaja epeejji poanajejo cuaqui yasijje poquiꞌyo quiaye. Jjeya ca ca baꞌe tiitii meejeꞌyo enijje, ecuea epeejji jojoya. ");
INSERT INTO eseNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","¡Shajjaꞌajjacue mo! —Jesosa poanaje—. Eꞌe jojo nei ojjaña shajjamaꞌ poani Eyacuiñajjiya ba cani emanoꞌyo jayojja, epoquijeyoꞌyo jayojja. Jamatii ehuohuiꞌyo ejo, Eyacuiñajjija Ebacua Ejjajo shajjaꞌajja cajeꞌyo. Ecuea esohui jayojja jama eꞌe jojo nei atiitii cajo, eyaya baꞌe tiitii meejeꞌyo enijje eyajo. ");
INSERT INTO eseNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Eꞌe, Eyacuiñajji ecue Chii yani tii tii, eshe. Jamajjeya ohuaya eya, oja Bacua Ejja huoojea canaje ojjaña joya onijje jjapeequiani baꞌe tiitii meeꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Cuanaya eya ojjañaja Edoe Mese poanijo Eyacuiñajjiya eya huoojea canaje jama baꞌa: “¡Miyaya huohuicue joya minijje jjapeequiani baꞌe tiitii meejeꞌyo minijje! ¡Huohuicue peaꞌai joya miquea epeejji pojjeamajo quea nee tii tii poajeꞌyo cuaquijo!” jamaya Eyacuiñajjiya eya acanaje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eꞌe, eꞌe jojo nei quijje ojjaña yahuajo emanoꞌyo cuana iyaa majje eyaya oya cuana shequi meeje oꞌoya —Jesosa poanaje—. Ecuea esohuijo ¡aꞌa jjashahuabaquijji jama baꞌa: “¿Yajja yajji? ¿Achajja shai ohuaya emanoꞌyo cuana shequi mee caje oꞌoya?” aꞌa jamaya pojji! ");
INSERT INTO eseNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Eꞌe jojo nei oya cuana eshe oꞌoya po mee majje ojjaña ecuea epeejji eyaya baꞌe tiitii meejeꞌyo enijje. Ojjaña shajjamaꞌ cuana ca ca shequi oꞌoya majje quea nee nee poajeꞌyo tii tii cuaquijo. ");
INSERT INTO eseNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eꞌe, Eyacuiñajjiya eya huoojea canaje ojjaña huasijje huohuiya jama baꞌa: “Joya ecuea epeejji cuana poani eyaya baꞌe tiitii meejeꞌyo enijje. Beca cuana ca ca ecuea epeejji pojjeamajo quea nee nee poajeꞌyo tii tii”. Eyacuiñajjiya e huoojea majje jama acanaje baꞌa: “¡Ojjaña ecuea ejjashahuabaquijji ojjaña cuana huohuiquicue!” acanaje. Eyaya ojaya esohui jayojja jama aña, ecuea ejjashahuabaquiꞌyojjijo pojjeama. Jamajoya eyaya Eyacuiñajjija ejjashahuabaquiꞌyojji jayojja jama añajo ecuea esohui ojjaña eꞌe jojo nei —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Majoya Jesosaa Jodio cuana huohui canaje jama baꞌa: —Miquianaya ejo jjashahuaba quehuaquiani jama baꞌa: “Jiquio dejjaa jama huohui cani baꞌa: —Eya ca iña iquio Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji —acani, de. Jamatii ohuaye neiya jama huohui canijo oya ecuanaja eshajjaꞌajjajji pojjeama” jjashahuaba quehuaquiani miquianaya —Jesosa poanaje—. Jamatii ecuea esohui eꞌe jojo nei. ");
INSERT INTO eseNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Eya ee nei pojjeama; eya ecue Chii nijje. Ohuaya ojjaña ba mee cani eya oja huoojeaꞌyo. Ecuea eba ojaya esohui ejo eꞌe jojo nei. ");
INSERT INTO eseNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yahuajo miquianaaya pea cuana huoojeanaje Huani que e huohuiꞌajjaa. Huaniya miquianaya eꞌe nei huohui canaje jama baꞌa: “Jesosa eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, oja Bacua Ejja oe nei” acanaje Huaniya, ma ona besameejji poaniya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","—Eyacuiñajjiya Huani huoojea canaje ejo huohuiya. Eyaya miquianaya huohui oꞌoyaña ma Huaniya ejo huohui canaje. Jamatii miquianajaya ejjashahuabaquiꞌyojji ejo quea jaꞌa pojjeamajojo eyaya miquianaya huohui oꞌoyaña. Miquianaaya Huanija esohui ejo eshajjaꞌajja jojjemo eyaya miquianajaya mimishi cuijeaꞌyome —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Cuaquijiji mecajje jijianiya quea jaꞌa ojjaña ba mee cani jayojja jama Huani poa. Ohuaya miquianaya quea jaꞌa nee ba mee canaje Eyacuiñajjija esohui ejo, ma yahuajo miquea ba jjima poa. Ebionei miquianajaya oja sohui ejo quea boti nee poanaje; jamatii quijje shajjaꞌajja sa poꞌyo ajja poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Eꞌe —Jesosa poanaje—, Huaniya ejo huohui canaje. Jamatii oya dejja. Pea yani, ecue Chii. Ecue Chiiya miquianaya ba mee cani eya oja huoojeaꞌyo. Eꞌe, ecue Chiiya eya ameesahua cani ma dejjaa ajjima acani. Ma ajeyoꞌyo majje miquianaya ba meeje eꞌe jojo nei eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ecue Chiiya miquianaya ba mee cani jama baꞌa: Ohuaya eꞌe jojo nei eya huoojea canaje. Jamatii miquianajaya oya ba jjima ecojjaja. Miquianajaya aje oe oja mimi shajjaꞌajja jjima peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ojaya esohui miquianajaya shajjaꞌajja jjima. Eya oja huoojeaꞌyo. Jamajjeya miquianaya ecue sohui shajjaꞌajja sa poꞌyo ajja peaꞌai —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eyacuiñajjija esohui yahuajo etehueꞌyo miquianaaya ba huichaꞌa huichaꞌaña, ba majamaja majje miquianaya ebaꞌe tiitiije poso jjabaquiani. Ma esohui etehueꞌyo yahuajo ejo tehue ca poa. ");
INSERT INTO eseNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Eyaya ca ca oe eyaye nei miya baꞌe tiitii meejeꞌyo; jamatii miquianaya enijje jjapeequi sa po ajja —Jesosaa Jodio cuana acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Eya dejja mimishi jama jjashahuabaqui ajja jama baꞌa: “Ojjaña dejja cuaa jamatii eya shajjaꞌajja cajeꞌyo” po ajja eya —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chojja, ecuea eba miquianajaya Eyacuiñajji quea jea nee pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eyacuiñajjiya, ecue Chiiya eya huoojea canaje. Jamatii miquianaya e shajjaꞌajja sa po ajja. Pea dejjaa Eyacuiñajjija huoojeaꞌyo nishohua huohui cani jama baꞌa: “Eya quea pame nee”. Ojaya esohui ca ca miquianaaya shajjaꞌajjaje; siajjepojji nijje miquianaya jjapeequije. ");
INSERT INTO eseNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Eyacuiñajji oe nei enequi tii tii. Jamatii miquianaaya ojaya esohui jayojja jama a sa poꞌyo ajja, jama jjashahuabaquime po ajja baꞌa: “Eyacuiñajjiya ejo jama cahuohui cahua baꞌa: —Eꞌe, miya ecuea epeejji quea pame nee —cahuohui cahua”. Chojja. Jamaya miquianaya jjashahuabaqui ajja —Jesosa poanaje—. Miquianaya jjashahuaba tiitiiquiani jama baꞌa: “Pea dejja cuana ejo jama camimiquiahua baꞌa: —Eꞌe, miya ca ca oe quea pame nee nee —capoahua onaya”. Jamajjeya miquianaya enijje jama po ajja baꞌa: “Jesosa, miya Quito, Eyacuiñajjija huoojea ojjaña jaahuanajji” enijje po ajja. Jamaya huohui sa po ajja miquianaya —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—¡Aꞌa eya ecue Chii ehuohuije poso pojji jama baꞌa: “Oya cuana e shajjaꞌajja sa poꞌyo ajja; quea mimishi nee nee” aꞌa eya ehuohuije poso pojji nequiana! —Jesosa poanaje—. Chojja, ecuea miquianaya ehuohuijji pojjeama. Miquianaya Moisesija etehueꞌyojo jjashahuabaquiani; jamatii ojaya esohui etehueꞌyo ajjimajo, Eyacuiñajjiya miquianaya jama acaje baꞌa: “¿Apiojji acuae quiana Moisesija etehueꞌyojo shajjamaꞌ poani? Miquianaya quea mimishi nee nee” quijje Eyacuiñajjiya nequiana acajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","—Eꞌe, Moisesiya ejo tehue ca poa. Jamajjeya miquianaaya oja tehue eꞌe jojo nei eshajjaꞌajja jojjemo enijje jjapeequiꞌyome. ");
INSERT INTO eseNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jamatii miquianaaya Moisesija esohui eshajjaꞌajja jojjemo, ojaya ehuohui etehueꞌyo eba peaꞌai jojjemo ecuea esohui shajjaꞌajjaꞌyome peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Majoya Jodio dejja cuana nijje mimi majje, quijje Jesosa o shajjaꞌajjajji nijje, ecuana nijje Jenosanenajo ani poquinaje Janinea bae yasijje, pea bajjani Timenia bae yasijje. Bishe aijo ojje miji yasijje besapoqui oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","Baꞌeñaqui majje eyiyo huasijje jaasohuaquinaje. Anioquenaje. Yahuajo Jesosaa quea huiso acanaje ma dejjaa ajjima acani; quea huiso emano cuana jjaajaqui mee caꞌyonaje, jjajeaqui mee caꞌyonaje peaꞌai. Jamajjeya o ba majje quea huiso nee nee poqui canaje jocuama, Jesosa baa. ");
INSERT INTO eseNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jamaya poanaje Jodio cuana Jenosanena huasijje poqui oꞌoyani ojee ijjiaꞌijjiaꞌyohua esohui dojojjiya Jodioja ebacua yahuajo cuiaꞌyo jjima shejo. Ma epajeaꞌyojji pojjeama jjachichaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Jamajjeya Jesosaa bajea canaje quea huiso nee nee poeje. Ba majje ohuaya Penipe huohuiꞌajja canaje: —Penipe, ¿achacua acuae seya che bobi jjesheje soꞌo dejja cuana quea huiso bobiajji? —Jesosaa acanaje, Penipeya yajja huohuiꞌajjame acaje ejjabaquijji. Jamatii Jesosaja eba poa Eyacuiñajjiya, oja Chiiya bobi pana cajeꞌyo dejja cuana bobiajji. ");
INSERT INTO eseNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Penipeya sajaꞌa canaje jama baꞌa: —¿Yajja yajji? ¿Ajeo ebobiajji? Oya cuana quea huiso nee nee aña, de. 200 esodojjo quea nahue ecuanaja yani jojjemo maya oe pojji bobi jjesheme ojjaña cuanaja ijjiajji —poanaje Penipe. ");
INSERT INTO eseNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Majoya aje oe o shajjaꞌajjajji Anesi, Simohui Penoja chahua jama poanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Oe eshoꞌiya ye canaje me oejje pahui, beca nahuoo sisi peaꞌai. Jamatii maya oe pojji nei nei, de; dejja cuana quea huiso nee nee ani jejje jjima poaje —poanaje Anesi. ");
INSERT INTO eseNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Majoya Jesosaa jama acanaje baꞌa: —¡Ojjaña cuana jama acue baꞌa: “¡Ojjaña anioquecue sipone biajje!” acue! —Jesosaa acanaje. Jamajje quea huiso sipone yanijo, ojjaña cuana anioque mee canaje sipone biajje. Quea huiso nee nee poanaje, 5.000 dejja; epona, eshoꞌi cuana peaꞌai sico jjima. ");
INSERT INTO eseNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Majoya Jesosaa pahui me oejje huiso jjeshe majje Eyacuiñajji bihuia canaje. Eyacuiñajji nijje bobijo mimi majje pahui tepe canaje; ecuana, o shajjaꞌajjajji cuana quia mee canaje dejja cuana eꞌanioquiani yasijje. Jamaya acanaje nahuoo sisi peaꞌai. Quia ca poquije quea huiso nee nee jjapanaqui poquipoquinaje bobi, de. Jamajjeya ojjaña cuaa ijjia neinei canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ojjaña jejjeajo, Jesosaa ecuana huohui canaje: —¡Chichacue bobi ojjañaja ijjiasejja! ¡Aꞌa jeanaꞌyojji! ");
INSERT INTO eseNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jamajjeya ecuanaa chichaꞌyonaje pahui ojjañaja ijjiasejja. Jjepai ai yasijje iyaꞌyonaje. Quea huiso poanaje, 12 jjepaime. Jamatii yahuajo me oejje, 5 pahui poanaje. Eꞌe, Eyacuiñajjiya jjapanaqui mee capoquipoquinaje quea huiso bobi, de. ");
INSERT INTO eseNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eꞌe, Jesosaa ma dejjaja ba jjima acanaje; 5.000 dejja cuana bobia canaje. Ma ba majje dejja quea huiso cuana ojee miminaje jama baꞌa: —Eꞌe jojo nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Yahuajo Eyacuiñajjiya ojo huohui mee ca poa jama baꞌa: “Quijje eyaya miquiana huasijje huoojeaje Quito, ojjaña jaahuanajji”. ¡Cuaꞌa, oya esejaya emeshi mese epojji ejjanequi meequi! —dejja cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Onajaya ejjashahuabaquijji ba majje Jesosaa ojjaña dejja cuana huoojea canaje equi cuana huasijje. Majoya oya quehua poquinaje. Eyiyo huasijje oe nei jaasohuaqui oꞌoyanaje oja Chii nijje mimiya. ");
INSERT INTO eseNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Eꞌe, sinecua, eyiyo huasijje poqui jjimahuajo Jesosaa ecuana, o shajjaꞌajjajji cuana huoojea canaje: —¡Bae ojje miji yasijje bishe aijo besapoquicue! Quijje eya poquije miquiana que —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jamajjeya bishe ai yasijje ani majje ecuaa yonaje. Besapoquiꞌajjanaje ojje miji yasijje epoquijji, Capenaoma huasijje. Mecajje quea apo nee poanaje. Jamatii Jesosa ecuana huasijje poe jjima poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Beni quea quemo nee nee poeyanaje. Enashajo quea quemo anicuayanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Quea huesha nee yoꞌajjanaje enabae yiyesama neijo. Jomajo ecuaaya banaje Jesosa. Eyiyojje ena biajje jeojeojebeje banaje. Jesosa ba majje ecuana quea ajjajja nee nee poanaje, oya eshahua poso anaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jamajjeya Jesosa ecuana nijje jama poanaje baꞌa: —¡Aꞌa quea mete pojji! Eya ca ca iña iquio, eshahua pojjeama —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jesosa shajjaꞌajja majje quea jaji nee poꞌyonaje ecuana. Bishe ai yasijje ani meeꞌyonaje. Jesosa aniꞌyajo, bishe ai bae ojje miji yasijje baꞌeñaquinaje, Capenaoma huasijje. Jomajo cahuinaje ecuana. ");
INSERT INTO eseNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mecahuajje ojjaña cuana, ma Jesosaa bobia canaje cuana jjachichaqui oꞌoyanaje bae sahua huasijje. Jama ojee miminaje baꞌa: —¿Achejo shai Jesosa? Oe bishe ejaanaje, de. Jamatii Jesosa o shajjaꞌajjajji cuana nijje besapoqui jjima, de, yaninaje eyiyojo tii —dejja cuaa acanaje. Ojjañaja ba jjima poanaje Jesosa ena biajje jeojeopoquije. ");
INSERT INTO eseNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Majoya pea bishe cuana Timenia cuiñajjijo ani poeyanaje. Baꞌeñaquinaje bae sahuajo, jomajo yahuajo Jesosaa Eyacuiñajji bihuia majje quea huiso cuana bobia canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jamajjeya ojjaña cuana Jesosa, o shajjaꞌajjajji cuana peaꞌai chamaꞌ ba majje bishe cuana huasijje anisohuaquinaje. Capenaoma huasijje besapoquinaje Jesosa saꞌajjaꞌyohua. ");
INSERT INTO eseNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ojje miji yasijje baꞌeñaqui majje oya cuaa Jesosa ba canaje. Ba majje huohuiꞌajja canaje: —Esohui huohuijji, ¿ache shono acuae mi jiquiacua poeyanaje soꞌo baꞌa? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesosaa oya cuana sajaꞌa canaje quea yeno jama baꞌa: —Miquianaya ejo jjashahuabaqui ajja jama baꞌa: “Eꞌe, Jesosa ma dejjaja ba jjima acanaje; jamajjeya oya eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji”. Chojja, miquianaya jama ejjashahuaba meequijji pojjeama. Bobijo ca ca miquianaaya eya saꞌajjaña, bobi quea huiso ijjia majje quea jejje poanajeya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","¡Aꞌa jjashahuaba tiitiiquijji bobijo, ebaꞌejjijo! Maya jjeya nei oe poani. Sho caje oꞌoya. ¡Ecuea esohuijo ca ca jjashahuabaquicue oe! —Jesosa poanaje—. Maya eꞌe jojo nei shajjaꞌajjajo, eyaya miya baꞌe tiitii meejeꞌyo enijje eyajo. Ecuea esohui pea bobi jayojja, ebaꞌe tiitii meeꞌyojji. Eꞌe, eyaya ojjañaja Edoe Meseya ma pea bobi ebaꞌe tiitii meeꞌyojji quiaje miquianaya, eya Eyacuiñajjija huoojeaꞌyohua jjejojo. Eyacuiñajjiya ecue Chiiya eya ma dejjaja ba jjima amee cani; pahui jjapana meequi canaje miquiana bobiajji. Jamajoya miquea eba eya oja huoojeaꞌyo ojjaña jaahuanajji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Majoya aje dejja cuaa Jesosa huohuiꞌajja canaje jama baꞌa: —¿Achajja acuae ecuaa Eyacuiñajjija esohui jayojjaya ajeꞌyo soꞌo? ¿Jamajjeya oya ecuana nijje quea bihui nee poajeꞌyo? ");
INSERT INTO eseNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesosaa oya cuana sajaꞌa canaje jama baꞌa: —Eꞌe jojo nei jama acue ejo baꞌa: “Eꞌe Jesosa, miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji” jamaya acue. Jamajjeya Eyacuiñajji quea bihui nee poajeꞌyo miquianajo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—Eꞌe pojjaꞌa —Jodio cuaa huohui canaje—. Jamajjeya ¡miyaya Eyacuiñajjiya jayojja jama acue dejjaa ajjima acani! Jamajjeya ecuanaja eba poaje miya eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. ¿Ae poaje miya? ¡Eyacuiñajji jayojja jama acue, Moisesiya aca poa jama oe acue! ");
INSERT INTO eseNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Eꞌe, yahuajo nei meshi jabojo Eyacuiñajjija esohui huohuijjiya Moisesiya esejaya etiiquiana bobi pahui jayojja quia ca poa ojjaña pojjajo. Yahuajo nei Eyacuiñajjiya Moisesi tehue mee ca poa jama baꞌa: “Eyacuiñajjiya Moisesija bobi pahui sisi jayojja eyajo oque mee ca poa meshi yasijje etiiquianaja eꞌijjiajji” jamaya tehue ca poa —Jodio cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Eyaya miya eꞌe nei huohuiaña —Jesosaa acanaje—, Moisesiya pojjeama etiiquiana quia canaje bobi. Ma eyajo aniya tii bobi oque mee canaje ecue Chiiya. Ohuaya jjeya miquianaya quia cani pea bobi ma eyajo ani meshi yasijje poeyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Eꞌe, jjeya nei Eyacuiñajjija bobi eyajo aninaje ohuaya huoojea cani ojjaña baꞌe tiitii meeꞌyojji —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Eꞌe, emeshi mese, ¡che ecuana jiquio bobi quiacue ojjaña pojjajo! —poanaje oya cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Eya ca ca iña jiquio bobi jayojja tiiya Eyacuiñajjija huoojeaꞌyo —Jesosa poanaje—, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, ojjaña baꞌe tiitii meeꞌyojji peaꞌai. Jamaya eya poani. Bobi ijjia majje miya quea yeno poaje oꞌoya, quea shoe po oꞌoya majje. Quea naba taja peaꞌai poaje oꞌoya. Enijje ejjapeequi jjemo, e eshajjaꞌajja jojjemo peaꞌai miquiana quea bihui tii poꞌyome, quea jejje tii jayojja nequi meeꞌyome —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Eyaya miquianaya huohuiaña jama baꞌa: Miquiaaya ecuea ma dejjaa ajjima acani quea huiso cuana banaje, pahui ecue pana ijjianajejo peaꞌai. Jamatii jjashahuabaquiani jama baꞌa: “Chojja, Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama, ojjaña baꞌe tiitii meeꞌyojji pojjeama peaꞌai” jamaya jjashahuabaquiani miquianaya, eya Quito pojjeama poso aña —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ojjaña joya ecue Chiiya ejo eꞌe nei jjashahuabaqui meesahua cani e que poejeꞌyo, enijje jjapeequijeꞌyo tii. E que poeyajo, ecuea miquianaya cajaa yajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Eꞌe, eya eyajo ani ecue Chiiya meshi yasijje huoojea canaje. Jamajjeya eyaya ojaya ejjashahuabaquiꞌyojji jayojja jama aña, ecuea ejjashahuabaquiꞌyojji jama pojjeama —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ecue Chiiya eya niñesheꞌa ca poa jama baꞌa: “Ojjaña joya eyaya minijje jjapeequi meesahuaña equiyoꞌyojji pojjeama. ¡Ojjaña oe baꞌe tiitii meeꞌyocue minijje! Quijje miya poe oꞌoya majje joya emanoꞌyo cuana oe shequi mee oꞌoyacue, ebaꞌe tiitiiꞌyojji” jama eya niñesheꞌameya ecue Chiiya aca poa —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eꞌe, ecue Chii jama sa poani baꞌa: Ojjaña joya eya Eyacuiñajjija Bacua ba majje, enijje jjapeequiajo, eyaya oya baꞌe tiitii meejeꞌyo enijje eyajo; joya emanoꞌyo cuana jaa peaꞌai shequi meeje oꞌoya quijje poe oꞌoya majje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Majoya Jodio cuaa Jesosajo niñeba canaje. Eꞌe, Jesosaa yahuajo jama acanaje baꞌa: —Eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji eyajo yahuajo ania poa. Ohuaya eya huoojea canaje meshi yasijje —acanaje yahuajo. ");
INSERT INTO eseNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jamajjeya Jodio cuaa Jesosa Joseja bacua ejja poso acanaje: —¡De! Oya Joseja bacua ejja pojjaꞌa jja coma. Oja chii, ojaya enaese peaꞌai ecuanaja eba. ¿Yajjajje oya jama poani baꞌa: “Eya yahuajo eyajo ania poa; eyajo ani meshi yasijje huoojea canaje ecue Chiiya”? ¿Yajjajje shai jama poanaje oya? Jodio cuana quea sapa caꞌa jjejojo, Jesosa Joseja jeajo poso ojaya esohui shajjaꞌajja sa poꞌyo ajja. ");
INSERT INTO eseNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","—¡Aꞌa eya niñebajji! —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Beca cuana jamatii enijje ejjapeequiꞌyojji pojjeama. Ecue Chiiya eya huoojea canaje. Joya ohuaya beca cuana ejo eꞌe jojo nei jjashahuabaqui meesahua cani enijje ejjapeequijji; oya cuana ca ca oe eyaya baꞌe tiitii meejeꞌyo enijje poe oꞌoya majje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Eꞌe, Eyacuiñajjija esohui huohuijji cuana yahuajo nei baꞌeya jama tehueme aca poa baꞌa: “Eyacuiñajjiya ojjaña dejja cuana, epona cuana peaꞌai oja sohui ba meesahua cajeꞌyo”. Jamaya tehueme aca poa. Jamajjeya ojjaña joya ecue Chii shajjaꞌajjajji poaniya, oja sohui jama acajeꞌyo. Jamaya amajje enijje jjapeequijeꞌyo peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","—Jamatii ojjaña cuanaja Eyacuiñajji ba jjima ecojjaja. Eya Eyacuiñajji nijje, ecue Chii nijje ania poa. Jamajjeya eyaya, eyaye nei, oya baña ecojjaa —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eꞌe jojo nei ojjaña joya ecue Chiiya enijje jjapeequi meeshahua cani eyaya baꞌe tiitii meejeꞌyo enijje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miquiaaya bobi ijjiaña ebaꞌejji. Jamajjeya eya bobi jayojjaya. Eyaya ecuea epeejji cuana baꞌe tiitii meejeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","¡Bacue! Yahuajo nei meshi jabojo Moisesiya miquianajaya etiiquiana bobi pahui sisi jayojja quia ca poa ojjaña pojjajo; jamatii manoꞌya poa ojjaña etiiquiana. ");
INSERT INTO eseNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eya miquiana nijje mimiani pea bobijo, ma Eyacuiñajji eyajo aniya huoojea canaje meshi yasijje. Maya ijjia majje ca ca manoꞌyo ajja tii tii poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eya ca ca iña pahui jayojjaya, Eyacuiñajjija huoojeaꞌyo. Eꞌe, eya yahuajo eyajo ani meshi yasijje poeyanaje dejja cuana baꞌe tiitii meeꞌyohua. Jamajjeya jiquio ecua bobi ijjia majje miquianaya baꞌyani jayojja jama eyaya dejja cuana baꞌe tiitii meejeꞌyo. Ojjaña joya enijje eꞌe jojo nei jjapeequiani baꞌe tiitiijeꞌyo enijje eyajo. Eyaya ojjaña cuana enijje baꞌe tiitii meeꞌyo sa aña. Jamajjeya eya manojeꞌyo ojjañaja mimishi cuijea meeꞌyojji. Jamajoya ecuea eyami ma pea pahui jayojja jama poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","—¡Chojja, de! —Jodio cuana ojee jjamimicuiajea nobiajeaquinaje—. ¿Yajja yajji ohuaya aje oe oja yami quia cajeꞌyo bobi jayojja ecuanaja eꞌijjiajji, de? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—Eyaya miya eꞌe jojo nei huohuiaña —Jesosa poanaje—. ¡Shajjaꞌajjacue! Miquiaaya ecue sohui mi shajjaꞌajjajo, enijje mi jjapeequiajo peaꞌai, enijje ebaꞌe tiitii meeꞌyojji pojjeama. Ecue sohui shajjaꞌajjañajo, ecue yami ijjiaña jama jayojja poani; enijje jjapeequianijo, ecuea enaꞌ ishiaña jama jayojja poani peaꞌai. ¡Jamaya pocue, ecuea epeejji poanijo! ");
INSERT INTO eseNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jamajjeya ecue sohui shajjaꞌajjajji cuana, ecuea epeejji nei nei cuana eyaya baꞌe tiitii meeaña; poe oꞌoya majje joya emanoꞌyo cuana jaa peaꞌai shequi meeje oꞌoya. ");
INSERT INTO eseNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","—¡Bacue! —Jesosa poanaje—. Miquiaaya bobi ijjiaña quea bihui nee ebaꞌejji. Jamaya eya manojeꞌyo miquiana quea bihui nee ebaꞌe tiitii meeꞌyojji. Miquiaaya ena oshe ishiaña naba tajaꞌama epojji. Jamaya ecuea enaꞌ cuayaquijeꞌyo miquiana quea boejea po meejji, cuaqui yasijje epoquijji pojjeama, enijje jjapee neineiquianijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","—Eꞌe —Jesosa poanaje—, jiquio ecua miquianaya quea jejje po majje quea bei nee poani jama jayojja eya miquiana cuanajo manoꞌyajo, miquianaya quea bei nee poajeꞌyo. Ecuea ecue enaꞌ cuayaquijeꞌyo miquianaja mimishi cuijeaꞌyojji, miquiana quea bei nee po meeꞌyojji. Jiquio ecua enaꞌ ishi majje quea bei poani jayojja jama quea bei nee poaje enijje jjapeequi majje. Jamajjeya joya e shajjaꞌajja neineijji poani enijje jjapeequiani; eya onijje jjapeequiani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eꞌe, Eyacuiñajji enequi tii eshe, ecue Chii e huoojeajji epo. Eya ecue Chiija ejjashahuabaquiꞌyojji jayojja jama poanijo, ohuaya eya baꞌe tiitii mee cani. Jamajjeya ojjaña joya enijje eꞌe jojo nei jjapeequiani eyaya baꞌe tiitii meejeꞌyo enijje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","59","Etiiquiana yahuajo nei nei bobi Moisesija quia ijjia majje jamatii manoꞌya poa. Eya ca ca iña jiquio pea pahui jayojja; eya eyajo ania poa, ecue Chiiya meshi yasijje huoojea canaje. Jamajjeya ojjaña joya enijje eꞌe jojo nei jjapeequiani eyaya baꞌe tiitii meejeꞌyo enijje eyajo —jamaya Jesosaa Jodio cuana sohuihuohui canaje Capenaomajo, Jodioja equi ojee ejjachichaquijjijo. ");
INSERT INTO eseNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesosaja esohui Capenaomajo shajjaꞌajja majje quea huiso dejja cuana ojee jjaniñebaquinaje jama baꞌa: —¡De! Jesosaja esohui quea tai nee nee, de; shajjaꞌajja maja sa poꞌyo ajja iña, ohua oja eyami eꞌijjia mee ca —poanaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Onajaya ejjashahuabaquijji Jesosaja eba poanaje. Jamajjeya quea huiso cuana oja esohuijo jjaniñebaquianijo, Jesosaa huohui canaje jama baꞌa: —Ecuea esohuijo ¿aꞌa miquiana quea tai jjashahuabaquiani? ¿Aꞌa mi enijje jjapeequi pajeajeꞌyo? ");
INSERT INTO eseNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Quijje eya ojjañaja Edoe Mese, ma yahuajo eyajo ania poa, jjequisohua caje oꞌoya iña eyahuasijje; jiquio meshijo enequi tiijji pojjeama iña. Jamajjeya aje mi oe ¿yajja jjashahuabaquiꞌyome acuae mi poajeꞌyo e jjequisohua caꞌyajo? —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Eyacuiñajjija Edojjoshahua Pameya pea ejjashahuabaquijji ba mee cani yahuajo jama pojjeama. Miquianaya ca ca jjashahuabaquiani bobijo, jiquio meshijo ebaꞌejjijo. Jamajjeya miya baꞌe tiitii mee ajja enijje. Eyaya ca ca huohuiaña Eyacuiñajjija ejjashahuabaquijji. Maaya miquianaya baꞌe tiitii mee cajeꞌyo, Eyacuiñajjija esohuijo jjashajjaꞌajjaquianijo. ");
INSERT INTO eseNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jamatii miquianaya quea huiso ejo jama poani baꞌa: “Mi shajjaꞌajja sa poꞌyo ajja iña; minijje jjapeequi sa poꞌyo ajja iña” miquianaya poani —Jesosa poanaje. Eꞌe, yahuajo nei Jesosaja eba poa jama baꞌa: “Quijje ecuea epeejji nishohua pea cuana eya iña meesahua cajeꞌyo onaja equecuaꞌyojji. Quijje quea huiso cuana enijje jjapeequi ajja poaje”. Jamaya Jesosaja eba. ");
INSERT INTO eseNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jamajjeya Jesosa jama poanaje peaꞌai baꞌa: —Jamajoya eyaya miquianaya yahuajo huohuinaje jama baꞌa: “Beca cuana jamatii enijje ejjapeequiꞌyojji pojjeama. Beca cuana joya ecue Chiiya ejo eꞌe jojo nei jjashahuabaqui mee cani ca ca oe enijje jjapeequijeꞌyo” eyaya yahuajo miquianaya anaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Majoya ma esohui shajjaꞌajja majje quea huiso dejja cuana Jesosa nijje poqui pajeaꞌyonaje, o shajjaꞌajjajji nisho cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jamajjeya Jesosaa ecuana, o shajjaꞌajjajji nei, 12 cuana huohuiꞌajja canaje: —¿Ae poaje miquianaya? ¿Aꞌa miya peaꞌai enijje jjapeequi sa poꞌyo ajja poaje? —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—Ecuea Emeshi Mese —Simohui Penohua Jesosa sajaꞌa canaje—, chamaꞌ pea mi jayojja. Miyaya ca ca oe esohui eꞌe jojo nei huohuiaña. Mi shajjaꞌajjajji caya ca oe baꞌe tiitii meejeꞌyo minijje tii. ");
INSERT INTO eseNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ecuana minijje eꞌe jojo nei jjapeequinaje. Ecuanaja eba miya eꞌe jojo nei oya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji quea pame nee nee —poanaje Peno. ");
INSERT INTO eseNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Eꞌe —Jesosa poanaje—. Eyaya miquianaya, 12 cuana babacaꞌyo majje iyaanaje; jamatii oe dejja minijje nequi ecuea epeejji nisho; oya eshahuaja epeejji poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesosa jjashahuabaquiani Jodasajo, ma Simohui Isicanioteja bacua ejjajo. Eꞌe, Jodasa Jesosa shajjaꞌajjajji 12 cuana nijje nequinaje. Jamatii quijje Jodasaa Jodio etii cuana Jesosa iña meeshahua canaje bejjo sosejje, onaja quecuaꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Majoya Jesosaa esohui huohui canananaje Janinea meshijo, Jodea meshijo pojjeama. Jodea meshijo Jodio etii cuaa equecua ca poaje jjejojoya mi poqui oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Quijje pishana ojjaña Jodio dejja cuana Jenosanena huasijje poqui oꞌoyanaje equi sisi iyaa, ojee quea bihui nee ijjiaꞌijjiaa bobi cuana chichajji shejo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jamajjeya Jesosaja echahua mese cuana onijje jama poanaje baꞌa: —¡Aꞌa jja oe jiquiojo Janinea meshijo tii ani tiitiijji! ¡Ecuana nijje Jodea meshi yasijje poqui oꞌoyacue! ¡Jocuama aje oe miyaya ma dejjaa ajjima acani aquicue, ojjaña mi shajjaꞌajjajji cuanaja ebajji! ");
INSERT INTO eseNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","¡Aꞌa quehuajje ajji cuiñajji sisijo! Jamaya po ajja cuana. ¡Jenosanenajo aquicue oe, ojjañaja ebajji! Eꞌe, jjeya jomajo ojjaña dejja cuana jjachichaquiani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jamaya huohui canaje oja chahua cuaa, Jesosa baꞌyo jjimahuajo, oya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama poso acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jamajjeya Jesosaa oja chahua cuana huohui canaje jama baꞌa: —Chojja, eya Jenosanena huasijje poqui oꞌoya jjima soꞌo. Eya jjeya miquiana nijje epoqui jojjemo ojjaña cuaa eya shajjaꞌajja jjima acame. Jamatii, ¡miquianaya poquiꞌyo sa po majje poquiꞌyocue! Jomajo dejja cuana mijo jjashahuabaqui ajja. ");
INSERT INTO eseNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Miquianaya ojjaña dejja jayojja jama jjashahuabaquianijo, mi quecua sa po ajja cuana. Eyaya ca ca onaya jama anaje baꞌa: “Miquianaya ojjaña quea mimishi poanijo, Eyacuiñajjija esohui jama po ajja” poanaje. Jamajjeya ojjaña ejo quea quene poani; quecua sa acani. ");
INSERT INTO eseNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","¡Jamajjeya miquianaya jjeya Jenosanena huasijje poquicue quea cahui huiso ojee ijjiaꞌijjiaa! Eya ca ca iña jjeya epoquiꞌyojji pojjeama. Eꞌe, jjeya nei miquiana nijje poquiꞌyajo eya shajjaꞌajja jjima acame cuaa —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jamaya huohui majje Jesosa Janinea meshijo aninaje soꞌo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jamatii oja chahua cuana Jenosanena huasijje poquiꞌyajo, quijje pishana Jesosa peaꞌai poquinaje. Ojjaña pea Jodio dejja cuana nijje pojjeama poquinaje; quehuajje Jenosanena huasijje poquinaje oe nei. ");
INSERT INTO eseNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ojee ijjiaꞌijjiaa jjachichaqui majje Jodio etii cuana Jesosaja epoeꞌyojjijo ishoa canaje quea quene. Huohuiꞌajja huichaꞌa huichaꞌa canaje jama baꞌa: —¿Aecue Jesosa? ¿Aꞌa cuae oya poeyanaje soꞌo? —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ojjaña cuana echichaꞌyo pea echichaꞌyo cuana nijje jjapashineijje maimai aninaje Jesosajo jama baꞌa: —Oya quea pame nee nee Jesosa. Siajjepojji pojjeama —beca cuana poanaje. —Chojja —pea poanaje—, ojjaña cuana se ca dasia cani Jesosaa. Eꞌe, oya Jesosa siajje poani jama baꞌa: “Eya ca ca iña Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji” poani —pea Jodio cuaa acanaje, Jesosaja esohui shajjaꞌajja sa po ajja jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jamatii Jodio etii cuanajo quea mete jjejojo joya Jesosa shajjaꞌajjajji epo mi mimi neineinaje; jjapashineijje ojo maimainaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jenosanenajo Jodio cuana ojee ijjiaꞌijjiani quea bihui nee quea huiso cahuime, 7 cahuime. Ojee ijjiaꞌijjianijo quijje pishana beca cahuime po majje Jesosa Eyacuiñajjija equi yasijje poquinaje. Equi shashajo ojjaña cuana sohuihuohui canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jesosaja esohui shajjaꞌajja majje Jodio etii cuana jama poanaje baꞌa: —¡De! Ojaya eba quea huiso. ¿Achajja shai? Chamaꞌ ojaya esohui huohuijji poanaje. Eshoꞌyahua oya dobiqui jjima de, esohui baa. ");
INSERT INTO eseNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesosaa oya cuana sajaꞌa canaje jama baꞌa: —Eyaya huohuiaña miquianaya ecuea esohui pojjeama. Eyacuiñajjiya eya huoojea canaje. Ohuaya eya huohui meesahua cani ojaya ejjashahuabaquijji. ");
INSERT INTO eseNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ojjañaa joya Eyacuiñajjija ejjashahuabaquijji jayojja jama baꞌeꞌyo sa poaniya ba caje eꞌe jojo nei eyaya huohuiaña Eyacuiñajjija ejjashahuabaquijji, ecuea ejjashahuabaquijji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Joya beca cuaa ojaya ejjashahuabaquijji huohui cani aje oe pea cuana quea bihui po meejji jama baꞌa: “Oya esohui huohuijji nei; ¡oya shajjaꞌajjacue!” Jamaya amee sa acani, pea esohui huohuijji cuaa. Pea jayojja jama pojjeama eya. Eyaya ca ca pea cuana bihuia mee sa aña ca ca, ecue Chii, e huoojeaꞌyojji epo oja sohui eꞌe nei huohuiañajo. Jamajjeya eya edasiajji pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¡Bacue! Yahuajo nei Moisesiya miquianajaya etiiquiana cuana huasijje quia caꞌya poa Eyacuiñajjija esohui etehueꞌyo, miquianajaya ebajji. Jamatii ma esohui etehueꞌyo jama baꞌe ajja miquianaya. Moisesija etehueꞌyo jayojja jama ebaꞌeꞌyo jojjemo e quecuaꞌyo sa po ajja pome —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ojjaña Jodio cuaa echichaꞌyo nequiya huohui canaje jama baꞌa: —¿Aya acuae mi quecuaꞌyo sa acani soꞌo? ¡Chojja, de, miya niñepoquiani pojjaꞌa jja mi coma! Mi quecua sa poꞌyo ajja ecuanaya —siajje poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesosaa oya cuana sajaꞌa canaje jama baꞌa: —Yahuajo eyaya ma dejjaa ajjima acani anaje miquea epojja ejomishocajjijo; oe dejja jeoꞌajja poa. Eyaya oya jeo meeꞌyonaje. Jamajjeya miquianaya ejo jama poanaje baꞌa: “Ohuaya aje oe epojja ejomishocajjijo acani; equipajaajji dojo mee cani peaꞌai. Jamaya quea tai. Jamaya pojjeama etiiquianaja ehuohuiꞌyo” miquianaya poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","¡Bacue! Yahuajo nei nei baꞌe etiiquianaa aca poa jayojja jama Moisesiya huohui ca poa jama baꞌa: “¡Mique bacua huoꞌo nei, eshoi nei cuiishasha biso nei jehuisejjajeacue!” aca poa. Jamajjeya miquiaaya ebacua 8 cahuime poajo cuiishasha biso nei jehuisejjajeaña, jamatii epojja ejomishocajjijoya. ");
INSERT INTO eseNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jamajjeya Moisesija etehueꞌyo jama poanijojo miquianajaya ebacua cuiishasha biso nei jehuisejjajeaña epojja ejomishocajjijo. Eꞌe, miquianaaya peaꞌai epojja ejomishocajjijo chacoaña. Jamajoya ¿apiojji acuae quiana enijje quea quene nee nee poani soꞌo dejja jeoꞌajja jeo meeꞌyonajejo epojja ejomishocajjijo? ");
INSERT INTO eseNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","¡Aꞌa nequiaa eya niñepoqui poso ajji! Quea jaꞌa nee nee jjashahuabaqui majje miquea ehuohui ejo eꞌe jojo nei poaje, quea pame —Jesosa poanaje Eyacuiñajjija equi pejjejo nequiya sohuihuohui canijo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Majoya quea huiso dejja cuana Jenosanenajo baꞌeca ojee miminaje jama baꞌa: —Jodio etii cuaa jiquio dejja quecua sa acani. ¿Aꞌa eꞌe? ");
INSERT INTO eseNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Bacue oe! Jjeya ohuaya ojjaña cuana sohuihuohui caqui. Jamatii oya iña jjima, mimi pajea mee jjima peaꞌai, de. ¿Eꞌe pojjaꞌa etii cuana jjashahuabaquiani che jama baꞌa: “Eꞌe pojjaꞌa oya Jesosa eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji”. Eꞌe pojjaꞌa, de. ");
INSERT INTO eseNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","¡De! Ecuanaja eba jiquio dejjaja baꞌejji; Quito poeyajo ca ca ojaya ebaꞌejji ba jjima poaje cuanaja —poanaje cuana, Jesosa Nasanenajo cuaya poso aca poa. ");
INSERT INTO eseNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Majoya Jesosaa Eyacuiñajjija equi pejjejo sohuihuohui huichaꞌa huichaꞌa canijo, oya cuana janobajjima nei sajaꞌa canaje: —Eꞌe, eya miquiaaya eba poso aña. Ecuea ebaꞌejji miquiaaya eba peaꞌai poso aña. Eya miquiana que jamatii poe jjima. Chojja, ecue Chiiya eya huoojea canaje. Ojaya esohui eꞌe nei. Oya miquianajaya ba jjima, de. ");
INSERT INTO eseNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Eya onijje ania poa; ohuaya eya huoojea canaje. Jamajjeya oya ecuea eba nei —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ma shajjaꞌajja majje Jodio etii cuana oya Jesosa Eyacuiñajjija Bacua Ejja pojjeama poso acanijo quea quene nee nee poanaje, iña sa acanaje. Jamatii iña jjima, jjeya iña mee jjima acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Quea huiso dejja ejjachichaqui nequiꞌyo cuana jjashahuabaquiani jama baꞌa: —Jesosa eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanaꞌyojji. Jama poanaje peaꞌai baꞌa: —Eꞌe nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Chamaꞌ pea dejja Jesosa jayojja epoe oꞌoyajji; ma dejjaa ajjima acani quea huiso acanaje ohuaye nei —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Paniseohua shajjaꞌajja canaje quea huiso dejja cuana jama poani baꞌa: “Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji”. Ma shajjaꞌajja majje Paniseo etii cuaa, Eyacuiñajji nijje emimijji etii cuaa peaꞌai Jodio sohuinano cuana huoojea canaje jama baꞌa: —¡Jesosa iñaquicue ejeanobiajji! —acanaje. Ma Jodio sohuinano Eyacuiñajjija equi cuiñajji poani. ");
INSERT INTO eseNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Majoya Jesosaa jama sohuihuohuime acanaje baꞌa: —Eya minijje nequi tiitii ajja. Ecue Chiiya eya huoojea ca poa. Quijje pishana eya poquije oꞌoya o que. ");
INSERT INTO eseNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Majoya eya saꞌajjajeꞌyo; jamatii eya miquianajaya ebaꞌyojji pojjeama. Poqui meemee ajja enijje e baꞌe yasijje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","—¿Achacua shai oya poquijeꞌyo, jocuama ecuana epoquiꞌyojji pojjeama pojjaꞌa? ¿Aꞌa oya pojjaꞌa poquije Jieno dejja cuana huasijje, Jodio cuana Jieno nijje baꞌe cuana jjabaꞌechejjequiani yasijje poquije pojjaꞌa, ojaya esohui huohuiya? —Jodio cuana ojee mimimiminaje Jesosajo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","—¿Ajeo shai Jesosa jama jjashahuabaquiani? —poanaje Jodio cuana—. “Miquiaaya eya saꞌajjajeꞌyo; jamatii miquianajaya eya ebaꞌyojji pojjeama. Poqui meemee ajja ma e baꞌe yasijje enijje” Jesosa poanaje, de —Jodio cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jenosanenajo Jodio cuana ojee ijjiaꞌijjianaje quea huiso cahuime, 7 cahuime bobi chichajji shejo. Ma pojja cuanajo quea bihui nee poanaje, yahuajo ijjiaꞌijjia jjimahuajo quea bihui pishana poa. Beshahua nei ijjiapajea caꞌyanijo, quea bihui nee nee poa. Jamajjeya beshahua nei ojee ijjiaꞌijjia pajeaꞌyanijo Eyacuiñajjija equi pejjejo Jesosa que jjachichaqui oꞌoyanaje. Jesosa taaanaje ojjaña huasijje jama baꞌa: —¡Ojjaña miquianaya quea naba taja jayojja poanijo, poecue e que, ecuea eꞌishijji ishiya! Enijje jjapeequi sa neinei poanijo quea naba taja jayojja jama poani; jamajjeya eyaya miquianaya baꞌe tiitii meejeꞌyo ecuea esohui eꞌe jojo nei shajjaꞌajjañajo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jiquio ecua ena eteohuejja cuayani tii tii jayojjaya, ojjaña ishi majje naba tajaꞌama poani jayojja jama ojjaña joya enijje jjapeequiani eyaya baꞌe tiitii meejeꞌyo. Majoya oya cuaa pea cuana enijje jjapeequi meesahua cajeꞌyo peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesosa jjashahuabaquiani jama baꞌa: —Edojjoshahua Pame poejeꞌyo. Dobiquijeꞌyo ecuea epeejji cuana huasijje. Enijje jjapeequi meesahua cajeꞌyo quea pame nee; jiquio ecua enaa caneco cuatajea cani jama jayojja quea cuata poaje Edojjoshahua Pame dobiquiajo. Jesosa jamaya poanaje Edojjoshahua Pame ojaya epeejji cuana huasijje dobiqui jjimahuajo. Quijje Jesosa emanoꞌyojaa shequi oꞌoya majje eyahuasijje jjequisohua caꞌyajo, ohuaya Edojjoshahua Pame huoojea caje ojaya epeejji cuana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesosaja esohui shajjaꞌajja majje quea huiso cuana jama poanaje baꞌa: —Eꞌe jojo nei Jesosa Eyacuiñajjija esohui huohuijji nei. Yahuajo nei Moisesiya tehue ca poa jama baꞌa: “Oya poeje Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji poe jjimahuajo” tehue ca poa —poanaje cuana; Jesosa esohui huohuijji poso acanaje, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji pojjeama poso acanaje beca cuaa. ");
INSERT INTO eseNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pea cuana ca ca jama poanaje baꞌa: —Chojja. ¡Oya ca ca oe Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji eꞌe jojo nei, de! Jamatii pea cuana poanaje: —Chojja, Jesosa Janinea meshijo baꞌe. Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji ca ca Janinea meshijo pojjeama cuayaje —acanaje cuaa, Jesosa Janinea meshijo Nasanenajo cuaya poso. ");
INSERT INTO eseNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Eyacuiñajjija esohui etehueꞌyo yahuajo jama poani baꞌa: “Dabi emeshi mese yahuajo baꞌya poa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji emeshi mese ojaya osecua poaje. Jamajjeya Dabija meshijo cuayaje, Benenajo, Jodea meshijo” —poanaje beca cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jamaya ojjaña Jodio dejja cuaa mimicuiajeanobia canaje Jesosajo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Beca cuaa Jesosa iña mee sa acanaje; jamatii jjaꞌiña meequi jjima poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jamajjeya sohuinano cuana, Eyacuiñajjija equi cuiñajji, ma Paniseohua yahuajo huoojea canaje Jesosa iñaa nisho Jesosa esohui huohui poequi baqui majje huacuaya poquiꞌyonaje Eyacuiñajji nijje emimijji etii yasijje, Paniseo cuana peaꞌai yasijje. Poeyajo, Sohuinano cuana tecuea canaje Jodio cuaa: —¿Apiojji acuae quianaja Jesosa iña jjima soꞌo? Ye jjima, de —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Chamaꞌ pea dejja Jesosa jayojja jama mimime. Pea dejja o jayojja mimi jjima; ojaya esohui quea pame nee nee, de —sohuinanohua sajaꞌame acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—¡De! Ohuaya aje mi oe dasia canaje peaꞌai —sohuinano tecueame acanaje Paniseo cuaa—. ");
INSERT INTO eseNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Aꞌa Jodio etii cuana, ecuana peaꞌai onijje jjapeequiani? ¿Aꞌa oya shajjaꞌajjaña peaꞌai ecuaa? Chojja, de —Paniseo cuaa acanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ojjaña jiquio dejja echichaꞌyo nequi ca ca Moisesija etehueꞌyo ba jjimajo, oya cuana Eyacuiñajjiya quea nee nee po mee cajeꞌyo cuaquijo —acanaje Paniseo cuaa, jjashahuaba taiquianiya jjejojo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, ma yahuajo Jesosa nijje miminaje mecajje Paniseo cuana nijje peaꞌai nequinaje. Jamajjeya ohuaya pea Paniseo cuana jama huohuiꞌajjame acanaje baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¡Bacue! Moisesija esohui etehueꞌyo yahuajo jiquio jama poanaje baꞌa: “¡Oe dejja niñeba jjimahuajo, oya iyaacue! Ohuaya huohui cajje, majoya miquianaaya bajeꞌyo oya quea mimishi pojjaꞌa, oya mimishiꞌama pojjaꞌa”. ¿Aꞌa eꞌe? —poanaje Nicodemo. ");
INSERT INTO eseNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Paniseo cuaa jja oya sajaꞌa canaje. Quea mimi tecue poanaje jama baꞌa: —¿Aꞌa miya peaꞌai Janinea dejja, Janinea meshijo baꞌe peaꞌai? ¡Eyacuiñajjija esohui ba neineicue! Chamaꞌ poaje Eyacuiñajjija esohui huohuijji Janinea meshijo baꞌecaja, pa —poanaje Paniseo cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Majoya, siniajo ijjiaꞌijjia pajea majje ojjaña cuana poquinaje equi cuana huasijje cahuiya. ");
INSERT INTO eseNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesosa ca ca eyiyo bajjani Onimo eyiyo huasijje poquinaje. Jomajo aninaje jiquio mecajje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mecajjeahua Jesosa poe oꞌoyanaje Eyacuiñajjija equi yasijje. Quea huiso nee nee cuana o que jjachichaqui oꞌoyanaje. Eyacuiñajjija equi pejjejo anioque majje Jesosaa sohuihuohui ca oꞌoyanaje ojjaña cuana huasijje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Majoya Paniseo cuaa, Moisesija etehueꞌyo huohuijji cuaa peaꞌai epona quea mimishi ye canaje. Pea cuaa oya ba canaje pea dejja oja yahue pojjeama nijje jaa, pa. Jamajjeya Paniseo cuaa huohui canaje epona jama baꞌa: —¡Jesosa nequi cojja nei nequicue! ");
INSERT INTO eseNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Majoya Paniseo cuaa Jesosa huohui canaje jama baꞌa: —Esohui huohuijji, jiquio epona quea mimishi nee poanaje. Pea dejja oja yahue pojjeama nijje jaanaje —acanaje cuaa—. ");
INSERT INTO eseNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisesiya yahuajo nei jama tehueme aca poa baꞌa: “¡Epona pea dejja oja yahue pojjeama nijje jaajo, jajahuejjajeacue meiya!” tehueme aca poa yahuajo nei. Jamajjeya, Jesosa, ¿yajja acuae miyaya epona aje soꞌo? —poanaje Paniseo cuana Moisesija etehueꞌyo jayojja ohua mi sajaꞌa cajje Jesosa eꞌiñaꞌyojji nisho jjashahuabaquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eꞌe, jjashahuabaquinaje jama baꞌa: —Eꞌe pojjaꞌa Jesosa Moisesija etehueꞌyo jayojja jama pojjeama mimije. Jamajjeya ecuana jama poaje: “Oya Jesosa ca ca oma siajjepojji; Moisesija esohui jayojja jama po ajja”. Jamatii Jesosaa oya cuana sajaꞌa jjima acanaje. Meshi pohuijo tehue canaje eme sisiya. ");
INSERT INTO eseNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Paniseo cuaa eponajo huohui majamajaꞌajja canaje. Jamajjeya Jesosaa Paniseo cuana cojja ba jeyojeyo neinei majje sajaꞌa canaje jama baꞌa: —¡Miquianaaya joya mimishiꞌama nei neiya ebionei mei jea coocue, jajahuejjajeacue pona! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mimi majje Jesosaa meshi pohuijo tehue ca oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesosaja esohui shajjaꞌajja majje Jodio dejja cuana oe cuayaqui, oe cuayaquiꞌyonaje esecue yasijje. Ebionei edejja tii ehui dojojji cuayaquiꞌya poa; o quishishijji joya etii pishana cuayaquinaje peaꞌai. Quea bicho ojjaña poanaje quea mimishi jjejojo. Epona jeana caꞌyonaje Jesosa cojja neijo nequi. ");
INSERT INTO eseNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jamajjeya Jesosaa nequisohua majje bajea canaje epona nequi; chamaꞌ Jodio etii cuana. Epona nijje jama poanaje baꞌa: —Epona, ¿ae acuae ma mi tecueajji epo? ¿Aꞌa mi mique mimishijo jajahuejjajeaꞌajja caꞌyonaje cuaa? —ba majje acanaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Esohui huohuijji, jajaꞌyo jjima mo Jodio etii cuanaja. Poquinaje oya cuana ojjaña —poanaje epona. —Eꞌe epona, ecuea miya ejajahuejjajeajji pojjeama peaꞌai. ¡Poquicue miya; mimishi pajeaꞌyocue! —Jesosa poanaje epona nijje. Majoya epona poquinaje quea bihui nee. ");
INSERT INTO eseNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Majoya epona nijje mimi majje Jesosaa sohuihuohui ca oꞌoyanaje ojjaña ejjachichaqui anica huasijje. Jama poanaje baꞌa: —Jamatii quea apo nee neeya, cuaquijijiya jeajaꞌa cani mecajje. Oya jayojjaya eya poani. Eyaya dejja cuana jamatii quea mimishi nee nee poa quea jaꞌa nee jjashahuabaqui meeaña Eyacuiñajjijo. Ojjaña joya ejo eꞌe jojo nei jjashahuabaquiani aje oe quea mimishi, quea apo peaꞌai baꞌe maja ajja. Eyaya oya cuana baꞌe tiitii meejeꞌyo enijje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jamajjeya pea Paniseo cuana Jesosa nijje mimijajinaje jama baꞌa: —¡De! Miyaya neiya huohuiaña jama baꞌa: “Eyaya dejja cuana baꞌe tiitii meejeꞌyo” poani. Miyaye nei jama huohuiañajo, ecuanaja miya eshajjaꞌajjajji pojjeama. Chojja, de. Moisesiya yahuajo nei jama huohui ca poa baꞌa: “¡Aꞌa oe dejjaja ehuohui shajjaꞌajjajji! ¡Becanejjijji peaꞌaiya huohui canijo oe shajjaꞌajjacue!” poa —poanaje Paniseo cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesosaa oya cuana acanaje jama baꞌa: —Eꞌe, eya neiya poanaje eyaya ecuea epeejji cuana baꞌe tiitii meeaña. Jamaya eꞌe jojo nei eyaya aña. Ecuea eba ecue Chii e huoojeajji epo. ¿Achacua eya poquije oꞌoya? Ecuea eba, de. Jamatii miquianajaya maya ba jjima. Jamajjeya ¡ecuea ehuohui ejo shajjaꞌajjacue! ¡Jamatii eyaye nei huohuiañajo shajjaꞌajjacue! ");
INSERT INTO eseNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dejja mimishi cuanaja ejjashahuabaquijji jama miquianaya ejo jjashahuabaquiani, quea quehua. Eya ca ca mi jayojja jama pojjeama. ");
INSERT INTO eseNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jamatii eyaya dejja cuanaja ebaꞌejji huohuiañajo, ecuea ehuohuiꞌyo eꞌe nei poani. Eꞌe, ecue Chiiya eya huoojea canaje. Ojaya ehuohui jayojja jama eyaya aña, ecuea ejjashahuabaquijjijo pojjeama. Eya ecue Chii nijje beca. Jamajjeya ecuanaja ehuohuiꞌyo dejja cuanajo eꞌe nei nei poani. ");
INSERT INTO eseNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Miquianajaya etiiquianaja Moisesija etehueꞌyo jama yahuajo poa baꞌa: “Becanejjijji peaꞌaiya oya jayojjaya huohui cajo ¡shajjaꞌajjacue, miquianaaya!” jamaya tehue ca poa. ");
INSERT INTO eseNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eyaya miya huohuiaña jama baꞌa: Eyaya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajjiya ecuea epeejji cuana baꞌe tiitii meejeꞌyo. Ecue Chiiya peaꞌai jama miya ba meesahua cani baꞌa: “Jesosa ecue huoojeaꞌyo” ecue Chii poani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jamajjeya Paniseo cuaa Jesosa huohuiꞌajja canaje jama baꞌa: —¿Achejo acuae mique Chii ani soꞌo? Jesosaa sajaꞌa canaje jama baꞌa: —Miquianajaya eya baꞌyo jjima; ecue Chii miquianajaya baꞌyo jjima peaꞌai. Eꞌe, eya miquianajaya eba jojjemo ecue Chii peaꞌai bame. ");
INSERT INTO eseNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jamaya Jesosaa sohuihuohui canaje Eyacuiñajjija equi pejjejo nequiya, Jodio etii cuana ojee chacochacoani pejjejo. Jamatii Jodio etii cuana Jesosaja esohui shajjaꞌajja majje iña jjima poanaje jjaꞌiña meequi ajjajojo. ");
INSERT INTO eseNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Majoya Jesosaa ojjaña cuana huohui canaje jama baꞌa: —Eya minijje nequi tii ajja; quijje pishana eya poquije oꞌoya. Quijje miquianaaya eya saꞌajja neineijeꞌyo miquea mimishi cuijeaꞌyojji, mi jaahuanajji peaꞌai. Jamatii miquianaya quea mimishi tii manojeꞌyojo, quea nee nee poajeꞌyo cuaquijo. Ma e poqui yani yasijje miquianaya epoquijji pojjeama —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jamajjeya Jodio etii cuana ojee huohuiꞌajja canaje jama baꞌa: —¿Yajjajje oya poquije? ¿Aꞌa oya jjayacuaquiꞌyo majje manoꞌyo sa poani pojjaꞌa? ¿Aꞌa jamajoya ohuaya jama acanaje baꞌa: “Ma e poqui yani yasijje miquianaya epoquijji pojjeama?” —acanaje Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesosa jama poanaje baꞌa: —Miquianaya meshijo baꞌe. Jamajjeya Edosiquiana jayojja jjashahuabaquime poani, quea tai. Eya ca ca iña eyajo baꞌe, Eyacuiñajji jayojja jama eya jjashahuabaquiani. ");
INSERT INTO eseNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jamajoya eyaya miya huohuinaje jama baꞌa: “Miquianaya quea mimishi tii manojeꞌyojo, quea nee nee tii poajeꞌyo cuaquijo”. Eyaya miquianaya huohuinaje eya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Jamatii miquianaya jjashajjaꞌajjaqui ajja. Jamajjeya miquianaya eꞌe jojo nei manojeꞌyo mimishi cuijeaꞌyo jjima tii. Quea nee nee poajeꞌyo tii tii cuaquijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—Eꞌe pojjaꞌa —Jodio etii cuana poanaje. ¿Aya acuae mi huoojea canaje soꞌo ecuana que? ¿Ajeo miya poeyanaje jiquiacua? —Jodio cuana poanaje. —¡De! Aje jja mi huohui huichaꞌa huichaꞌaꞌajjanaje yahuajo ehuohui coojji —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Miquianaya ecuea eba quea jjashahuabaqui tai, quea mimishi poani —Jesosaa Jodio cuana acanaje—. Jamajjeya eyaya miquianaya tecueaña. Miquianaaya niñebaña ecuea ehuohuiꞌyojo. Jamatii ecue Chiiya eya huoojea canaje; ojaya eba ojjaña; ojaya esohui eꞌe nei. Maya eyaya ojjaña cuana huasijje huohuiaña —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesosaja esohui oja Chiijo Jodio etii cuana ba sa po ajja. Oya cuana jjashahuabaquiani quea tai jama baꞌa: —Chojja, Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama —poso acanaje Jodio etii cuaa. ");
INSERT INTO eseNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jamajjeya Jesosaa huohui canaje jama baꞌa: —¡Bacue! Quijje eya, ojjañaja Edoe Mese miquianaaya baꞌehuanasohuajeajeꞌyo acui ecueataꞌapeejo. Majoya miquianajaya eba poaje jama baꞌa: “Jesosa eꞌe jojo nei Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji”. Eꞌe, ojaya esohui eyaya huohuiaña, ecue Chiija. Ecuea ejjashahuabaquiꞌyojji ca ca eyaya huohui jjima aña. ");
INSERT INTO eseNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ecue Chiiya eya huoojea canaje. Eyaya oya quea bihui po mee sa aña tii. Jamajjeya oya enijje yani tii tii, ohuaya eya jeananaꞌyo ajja —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Quea huiso Jodio cuana Jesosa shajjaꞌajja majje jama poanaje baꞌa: —Eꞌe jojo nei nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. Oja sohui eꞌe jojo nei —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jamajjeya quea huiso Jodio cuana Jesosa nijje jjapeequinaje. Oya cuana Jesosaa jama acanaje baꞌa: —Eꞌe, ecuea esohui jama baꞌyani tiijo miquianaya e shajjaꞌajjajji eꞌe jojo nei poani. ");
INSERT INTO eseNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jama poanijo ecuea esohui miquianajaya quea jaꞌa nee poajeꞌyo. Ecuea esohui eꞌe jojo nei poani, siajje pojjeama. Jamajjeya ecuea esohui ba neineiyajo, miquianajaya mimishi cuana pajea meejeꞌyo, Edosiquianaja yajjijo chaco meepajeajeꞌyo peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Majoya pea Jodio cuana Jesosa nijje jjapeequi ajjajo quea tecue jama poanaje baꞌa: —Chojja. Amajama ecuanaja etiiquiana, de. Jamajjeya pea cuanaja ecuana ehuoojeaꞌyojji pojjeama peaja yajjijo chacochacohua sosemaꞌ —siajje poanaje oya cuana—. ¿Yajjajje miya jama poanaje baꞌa: “Eyaya miquianaya chacochaco pajea meejeꞌyo peaja yajjijo?” —poanaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesosaa oya sajaꞌa canaje: —Eꞌe jojo nei ojjaña joya quea mimishi poani ca ca o huoojeaꞌyojji Edosiquiana bajjani jayojja jama poani tii, quea mimishi. Ojaya yajjijo chacopajea meemee ajja jama jayojjaya aña miquianaya, miquianajaya mimishi pajeaꞌyo ajjajo. ");
INSERT INTO eseNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","¡Bacue! Echacojji baꞌe tiitii ajja echacojji meseja equijo. Oja bacua ca ca oe onijje baꞌe tiitiijeꞌyo. Miquiana huoojeaꞌyojji Edosiquiana bajjani quea mimishi; ojaya yajjijo miquianaya sosemaꞌ chacochacoani. Jamajoya miquianaya baꞌe tiitii mee ajja Eyacuiñajji nijje. E shajjaꞌajjajji poani ca ca Eyacuiñajji nijje baꞌe tiitiijeꞌyo oja bacua jjejojoya. ");
INSERT INTO eseNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jamajoya eyaya, Eyacuiñajjija Bacua Ejjaa miquianaya mimishi pajea meesahuajeꞌyo. Jamajjeya miquianaya eꞌe jojo nei Edosiquianaja huoojeaꞌyo pojjeama poajeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Eꞌe, ecuea eba Amajama miquianajaya etiiquiana poa. Jamatii miquianaya ecuea esohui shajjaꞌajja sa poꞌyo ajja nei nei. Jamajjeya miquiaaya eya quecua sa aña. ");
INSERT INTO eseNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miquianaaya mi huoojeajji jayojja jama atiitiiaña quea tai. Oya Edosiquiana huoojeajji poani, Satanasa bajjaniya. Eyaya ca ca huohuiaña ojjaña ecue Chiija ejjashahuabaquijji quea pame —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Chojja —Jodio cuana po nishonaje—, Amajama ecuanaja etiiquiana. Ohuaya jayojja jama aña ecuanaa quea pame —poanaje. —Chojja —Jesosaa Jodio etii cuana sajaꞌame acanaje—. Amajama quea pame, miquianajaya etiiquiana mese poa; jamatii miquianaya o jayojja quea pame poꞌyo ajja. ¿Yajjajo acuae miquianaya o jayojja mi poꞌyani? ");
INSERT INTO eseNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eyaya Eyacuiñajjija esohui eꞌe nei huohuinajejo, miquianaya shajjaꞌajja sa po ajja. Jamajjeya eya miquianaaya quecua sa aña. Amajama ca ca jama poꞌyo ajja; quea pame nee oya. ");
INSERT INTO eseNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Miquianaaya aje oe mi huoojeajjija ehuohui quea tai jayojja jama atiitiiaña, Edosiquianaja ehuohui jama —Jesosa poanaje. Jamatii Jodio etii cuana quenequenenaje. Jama poanaje baꞌa: —Chojja, Eyacuiñajji eꞌe jojo nei ecuanaja Chii. Ecuana ojaya ebacua cuana quea pame poani, de —poanaje Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesosaa oya cuana huohui canaje jama baꞌa: —Eya Eyacuiñajji nijje ani poeyanaje jiquiacua, jiquio meshi yasijje. Eyacuiñajji miquianaja Chii pojjeamajo eya miquianaaya botiꞌama aña. Eꞌe, Eyacuiñajjiya eya huoojea canaje; eya jamatii poeꞌyo jjima. Chojja, ohuaya eya huoojea canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Apiojji acuae miquianaya ejo jjabahuejjaqui jjima? Miya ca mi ca oe e shajjaꞌajja sa poꞌyo ajja tii nequi. ");
INSERT INTO eseNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eꞌe, Edosiquiana huoojeajji poani mi huoojeajji poani; ojaya ejjashahuabaquijji jama atiitiiꞌyo sa poani miquianaya. Yahuajo nei nei oya ona quecua cooꞌyojji poa. Eyacuiñajjija esohui eꞌe nei jayojja jama ojaya ajjima peaꞌai poa; esohui ojaya botiꞌama nei nei poa. Oya siajje poani tii tii, siajjepojji nei nei. Oya ca ca oma siajje po coonaje; siajjepojji cuana huoojeajji poani. Ojjaña siajjepojji cuana ojaya epeejji cuana, Edosiquianaja epeejji. ");
INSERT INTO eseNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eyaya miquianaya Eyacuiñajjija esohui eꞌe nei huohuiaña. Jamatii miquianaaya eya shajjaꞌajja jjima aña. Edosiquiana jayojja miquianaya jjashahuabaquiani. ");
INSERT INTO eseNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Miquianaya ejo jama po ajja baꞌa: “Jesosa quea mimishi”. Chojja de. Jamajjeya eya esohui eꞌe nei huohuiañajo, ¿apiojji acuae ecue huohui shajjaꞌajja jjima tii aña soꞌo? —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","¡Bacue! Ojjaña Eyacuiñajjija epeejjiya oja sohui shajjaꞌajja cani tii. Miquianaya ca ca Eyacuiñajjija epeejji pojjeama jjejojo ojaya esohui shajjaꞌajja sa poꞌyo ajja tii —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Majoya Jodio etii cuaa quenequene majje jama acanaje baꞌa: —¡Miya ca mi ca oe Samania dejja tai, niñepoqui! ");
INSERT INTO eseNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Chojja —Jesosaa acanaje—, eya niñepoqui pojjeama. Ecue huohui ecue Chiijo eꞌe nei. Eyaya oya bihuiaña quea jaꞌa nee. Miquianaaya ca ca eya niñebaña —Jesosaa Jodio etii cuana acanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Eya onaya ejo mimi mee sa poꞌyo ajja jama baꞌa: “Jesosa quea pame nee, ¡oya bihuiacue!” Chojja, eyaya dejja jamaya epo meeꞌyojji pojjeama ejo. Ecue Chii ca ca ejo jjashahuabaquiani quea pame nee; eꞌe jojo nei ejo huohui cani ohuaya —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eyaya miquianaya eꞌe jojo nei huohuiaña jama baꞌa: Ojjaña joya e shajjaꞌajja neineijji poani baꞌe tiitii meejeꞌyo, oya cuana ca ca emanoꞌyojjijo meteꞌama poajeꞌyo peaꞌai —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Maya shajjaꞌajja majje Jodio cuaa Jesosa jama acanaje baꞌa: —Miquea ehuohui emanoꞌyojjijo ecuanaja eba miya eꞌe jojo nei niñepoqui poani eshahuaa napa canijo. ¡Bacue! Yahuajo ecuanaja etiiquiana Amajama manoꞌya poa. Eyacuiñajjija esohui huohuijji cuana yahuajo baꞌe manoꞌya poa peaꞌai. Jamatii jjeya miyaya huohuiaña jama baꞌa: “Ecuea esohui jayojja jama baꞌyanijo emanoꞌyojji pojjeama miquianaya cuana poaje”. ¡Dee! ");
INSERT INTO eseNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ecuanaja etiiquiana Amajama quea pame nee, quea caꞌa nee poa; jamatii oya manoꞌya poa. ¿Aꞌa miyaya ma Amajamaja ajjima ajeꞌyo? Jesosa, ¿aꞌa miyaya emanoꞌyo cuana shequi meejeꞌyo? Eyacuiñajjija esohui huohuijji cuana yahuajo nei baꞌe poquijeyoꞌya poa peaꞌai, de. ¿Aꞌa miya pea dejja jayojja jama pojjeama? ¿Aꞌa miyaya ojjaña baña quea jaꞌa nee? Chojja, siajje miya poani —Jodio cuana mimijaji majamajanaje Jesosa nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jamajjeyaya Jesosaa ojjaña cuana huohui canaje jama baꞌa: —Eya onaya ejo mimi mee sa poꞌyo ajja jama baꞌa: “Jesosa quea pame nee, ¡oya bihuiacue!” Chojja de, Eyacuiñajjiya, ecue Chiiya ca ca oe eya quea jea acani. Jamaya eyaya saña. Eꞌe, ecue Chiiya ejo jama huohui cani baꞌa: “Jiquio ecuea Ebacua Ejja quea pame nee nee, quea caꞌa nee nee; ¡oya shajjaꞌajjacue!” poani ecue Chii. Ecue Chiijo miquianaya jama siajje poani baꞌa: “Ecuana Eyacuiñajjija epeejji, oya ecuanaja eba”. ");
INSERT INTO eseNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Chojja de. Oya miquianajaya ba jjima, de. Miquianaya siajje poani. Eya ca ca siajje po ajja. Oya ecuea eba nei nei; eya siajjepojji pojjeama. Eyaya oya baña; ojaya esohui shajjaꞌajjaña; ojaya esohui jayojja jama poani tii tii. ");
INSERT INTO eseNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yahuajo nei miquianajaya etiiquiana Amajama quea bihui nee nee jjashahuabaquinaje ecuea epoeꞌyojjijo quijje nei. Eꞌe, Eyacuiñajjiya yahuajo Amajama ba mee ca poa jama baꞌa: Eya, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji quijje meshi yasijje poejeꞌyo. Ma ba majje quea bihui nee nee Amajama poa —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Majoya Jodio cuaa Jesosa jama acanaje baꞌa: —Chojja de, miya siajje poani, de. Miya eshoꞌi, 50 cuiꞌao sheme po jjima miya de. Amajama ca ca yahuajo nei nei baꞌya poa. Oya miquea ba jjima, de —poanaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—¡Shajjaꞌajjacue! —Jesosaa sajaꞌa canaje—. Eyaya miya eꞌe jojo nei huohuiaña: Amajama cuaya jjimahuajo tii eya yaña tiia poa. Eya ca iña Eyacuiñajji nei —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma shajjaꞌajja majje Jesosa siajje poani poso Jodio cuaa mei iña canaje o jajahuejjajeajji nisho. Jamatii Jesosa chamaꞌ poanaje. Jesosa quea huiso dejja tejjee nequijje quehua cuayaquinaje Eyacuiñajjija equi esecue jjani yasijje. Poquinaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Quijje pea pojjajo, ejomishocajji pojjajo Jesosa ecuana nijje, o shajjaꞌajjajji cuana nijje ejiojjijje poquijeya ohuaya ba canaje oe dejja cojjamaꞌ cuaya. ");
INSERT INTO eseNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ba majje ecuanaa Jesosa huohuiꞌajjanaje jama baꞌa: —Esohui huohuijji, ¿yajjajje acuae jiquio cojjamaꞌ cuayanaje soꞌo? ¿Aꞌa ojaya mimishijo pojjaꞌa? ¿Aꞌa oja chiija, oja naeja mimishijo pojjaꞌa? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Chojja —Jesosaa ecuana sajaꞌa canaje—, oya cojjamaꞌ cuaya poa ojaya mimishijo pojjeama, oja chii, oja nae cuanaja mimishijo pojjeama peaꞌai. Oya jamatii cojjamaꞌ cuaya mee ca poa. Jamajjeya eyaya oya jjabapojjaqui meejeꞌyo. Ba majje ojjaña cuaa bihuia caje: “Eꞌe, Eyacuiñajjiya Jesosa jjabapojjaqui mee canaje cojjamaꞌ; quea caꞌa nee oya, quea pame nee nee” acaje —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eyacuiñajjiya eya huoojea canaje o chacojji. Jamajjeya jjeya eya miquiana nijje nequianijo Eyacuiñajjijo chacoaña. Quijje eya miquiana nijje nequi ajja jiquiojo. Eyacuiñajjijo chaco majamaja majje eya manojeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Meshijo nequiya eyaya ojjaña cuana Eyacuiñajjija esohui ba meeaña. Eya cuaquijiji jayojja jama poani. Jiquio ecua cuaquijijiya jeajaꞌa canijo dejja cuana poquiquehua ajja mecajje quea apojo jama jayojja eyaya ojjaña cuana Eyacuiñajjijo quea jaꞌa jjashahuabaqui meeaña. ");
INSERT INTO eseNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jamaya mimi majje Jesosaa cuichojea canaje meshi pohui yasijje. Cojjamaja ecojja iñapepa canaje meshi choeya. ");
INSERT INTO eseNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Majoya cojjamaꞌ huohui canaje: —¡Poquicue miya; ecojja shacuaquicue ena eteohuejja huasijje, Sinoeꞌ bajjani yasijje! —poanaje. (Ma ena eteohuejja Ese Ejjaja esohuijo: Eyacuiñajjija huoojeaꞌyo ena bajjani.) Jamajjeya cojjamaꞌ poquinaje ena eteohuejja huasijje ecojja shacuaa. Ecojja shacua majje jjabapojjaquinaje. Equi yasijje poe oꞌoyanaje cojjajji. ");
INSERT INTO eseNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jamajjeya dejja cuaa o pejjejo baꞌecaa, pea cuaa yahuajo oya meme ani ba canajeya peaꞌai oya cojjajji ba caꞌyonaje. Baꞌyo majje ojee mimimiminaje jama baꞌa: —Jiquio dejja yahuajo cojjamaꞌ eꞌanioque ani meme ani eseyaya banaje. ¿Aꞌa eꞌe? —poanaje. —Eꞌe, oyaya jja coma —beca cuana poanaje. —Chojja, pea coma; cojjamaꞌ jayojja coma —pea cuana poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oya yahuajo cojjamaꞌ jama poanaje baꞌa: —Eꞌe, eya iquio ma yahuajo cojjamaꞌ cuaya poaya. Jjeya eya cojjajji —cojjamaꞌ poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—Eꞌe nei. ¿Yajjajje acuae mi cojjajjiꞌyo? ¿Yajja acuae mi poꞌyonaje? Jjeya miya cojjajjiꞌyo —jama huohuiꞌajja neineimeya acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ohuaya sajaꞌa canaje: —Jesosa bajjaniya mo cuichojea canaje meshi pohui tejjee. Ecuea ecojja iñapepa canaje meshi choeya. Majoya eya huoojea canaje Sinoeꞌ ena eteohuejja huasijje ecojja shacuaa. Jamajjeya eya poquinaje. Ecojja shacuaqui majje eya jjabapojjaquinaje —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Aꞌa eꞌe? —ojjaña cuana poanaje—. ¿Achacua acuae ani oya Jesosa jjeya soꞌo? —poanaje. —Cuaꞌa de, ecuea oya ba jjima ecojjaja —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jamajjeya pea mecahuajje o pejjejo baꞌe cuaa ma dejja yahuajo cojjamaꞌ cuaya poa jjequi canaje Paniseo cuanaja ebajji. ");
INSERT INTO eseNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesosaa meshi pohui ecuichojea ecojja huasijje iñapepa cajje jjabapojjaqui mee canaje epojja ejomishocajjijo. ");
INSERT INTO eseNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jamajjeya Paniseo cuaa ma ba majje huohuiꞌajja ca oꞌoyanaje jama baꞌa: —¿Yajjajje acuae mi cojjajjiꞌyo? ¿Yajja acuae mi poanaje soꞌo? —poanaje Paniseo cuana. —Jesosaa ecuea ecojja iñapepa canaje meshi choeya. Majoya ecojja shacuaqui majje eya jjabapojjaquinaje —poanaje ma dejja. ");
INSERT INTO eseNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jamatii beca Paniseo cuaa huohui canaje jama baꞌa: —Ma dejja Jesosa bajjaniya ca ca oe epojja ejomishocajjijo chaco cani, de —poanaje Paneseo cuana. Jamajjeya Jesosa Eyacuiñajjija huoojeaꞌyo pojjeama poso jjashahuabaquime poanaje. Pea Paniseohua jama acanaje baꞌa: —Chojja de, ohuaya cojjamaꞌ cuaya jjabapojjaqui mee canaje, pa. Jamaya pea cuana poanaje. Jamajjeya oya mimishiꞌama. Dejja mimishiya jamaya po meemeeꞌyo ajja —poanaje. Jamajjeya Jesosajo ojee jjamimicuiajea nobiajeaquinaje Paniseo cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jamajjeya oya cuaa ma dejja yahuajo cojjamaꞌ cuaya huohuiꞌajja ca oꞌoyanaje: —¿Yajja acuae mijo poanaje Jesosa soꞌo? Jesosaa miya jjabapojjaqui mee canaje, pa cuana poani. Jamajjeya ¿yajja acuae miya poani Jesosajo soꞌo? ¿Aꞌya cuae oya? —poanaje Paniseo cuana. —Jesosa Eyacuiñajjija esohui huohuijji eꞌe jojo nei —sajaꞌame acanaje cojjamaꞌ cuayaa. ");
INSERT INTO eseNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jamatii Jodio etii cuana jjashahuabaqui sa poꞌyo ajja jama baꞌa: —Oya cojjamaꞌ cuaya poa, jjabapojjaqui mee canaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jamajjeya oja chii, ojaya enaese peaꞌai iyaa canaje. Poeyajo, huohuiꞌajja canaje: —¿Aꞌa jiquio miquea ebacua ejja cojjamaꞌ cuaya poa? ¿Yajjajje acuae oya jjeya cojjajji? ¡Huohuicue ecuana! —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Echii mese jama poanaje baꞌa: —Eꞌe, jiquio ecuanaja ebacua ejja. Yahuajo oya cuaya poa cojjamaꞌ nei. ");
INSERT INTO eseNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","¿Yajjajje shai oya cojjajjiꞌyo jjeya? Ecuanajaya ba jjima. ¿Aya acuae oya jjabapojjaqui mee canaje soꞌo? Ecuanaja ba jjima. ¿Apiojji acuae iñaya nequiaa huohuiꞌajjaña? Oya oe huohuiꞌajja socue; oya etii, eshoꞌi pojjeama. ¡Ohuaya oe huohui cacue! —poanaje echii mese, enaese peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jamaya poanaje oya cuana, Jodio etii cuanajo quea mete jjejojoya. Eꞌe, Jodio etii yahuajo jama poanaje baꞌa: “Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji, ¡aꞌa jama huohuime ajji! Jama mimime poajo jja oe ecuaaya miquianaya Jodioja equi ojee ejjachichaquijjijo esecue yasijje huoojeacuayajeajeꞌyo” poanaje Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Quea mete poanaje oja chii, ojaya enaese cuana peaꞌai. Jamajoya oja chiiya, ojaya enaeseya Jodio etii cuana huohui canaje jama baꞌa: —¡Oya oe huohuiꞌajjacue! Oya eshoꞌi pojjeama, etii nojinoji. ");
INSERT INTO eseNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jamajjeya Jodio etii cuaa ma dejja cojjamaꞌ cuaya poa iyaa ca oꞌoyanaje ehuohuijji jama baꞌa: —¡Bacue! Ecuanaja eba jiquio dejja Jesosa quea mimishi. Jamajjeya Eyacuiñajji oe nei bihuiacue jama baꞌa: “Eyacuiñajji quea pame nee nee; jamajjeya eya ohuaya jjabapojjaqui mee canaje ohuaye nei” —Jodio etii cuaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Cojjamaꞌ cuayaa sajaꞌa canaje jama baꞌa: —Miquianaya: “Jesosa quea mimishi” poani. Oya quea mimishi poani jojjemo eya jjabaqui ajja tii pome. Ecuea eba nei nei eya cojjamaꞌ cuaya poa; eya jjeya cojjajjiꞌyo, oja jjabapojjaqui meeꞌyo —poanaje cojjamaꞌ. ");
INSERT INTO eseNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Majoya oya huohuiꞌajja ca oꞌoyanaje Jodio etii cuaa jama baꞌa: —¿Yajja acuae mijo poanaje Jesosa? ¿Yajja acuae mi cojja acaꞌyonaje soꞌo? —poanaje cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Eꞌe, eyaya miquianaya yahuajo huohuinaje Jesosa. Jamatii miquianaya jjashajjaꞌajjaqui ajja —oya poanaje—. ¿Apiojji acuaeya shajjaꞌajja oꞌoya sa aña soꞌo? ¿Eꞌe pojjaꞌa miquianaya o shajjaꞌajjajji poajeꞌyo? —poanaje cojjamaꞌ cuaya etii cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Majoya Jodio etii cuana onijje mimijajinaje jama baꞌa: —Miya ca mi ca oe Jesosaja epeejji. Ecuana ca ca oe Moisesija esohui shajjaꞌajjajji poani. ");
INSERT INTO eseNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ecuanaja eba eꞌe jojo nei Eyacuiñajji yahuajo nei Moisesi nijje mimia poa. ¿Jesosa shai ajea huoojea jiquiacua? Cuaꞌa de. Ba jjima ecuanaja —mimitecuetecueame poanaje Jodio etii. ");
INSERT INTO eseNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Eꞌe pojjaꞌa, de, —cojjamaꞌ cuayaa oya cuana acanaje—; ¿apiojji shai oya miquianajaya eba pojjeama soꞌo de? ¿Aꞌa miquianajaya ba jjima Jesosa huoojeajji epo? ¡Bacue oe! Eya ohuaya jjabapojjaqui mee canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eyacuiñajjiya ca ca dejja quea mimishija esohui eshajjaꞌajjajji pojjeama onijje mimianijo. Ohuaya dejja quea pameja esohui shajjaꞌajja cani, oja sohui jayojja jama poanijo. ");
INSERT INTO eseNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yahuajo nei, jjeya nei peaꞌai chamaꞌ pea dejja Jesosa jayojja. Eꞌe, eya yahuajo cojjamaꞌ cuaya poa. Jjeya eya ohuaya cojjajji po mee canaje. Yahuajo nei nei meshi pana cajeahuajo chamaꞌ dejja poa Jesosa jayojja. Jjeya nei peaꞌai chamaꞌ pea dejja Jesosa jama. Pea cuaa ohuaya jayojja jama aꞌajja. ");
INSERT INTO eseNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jesosa Eyacuiñajjija huoojea jjima poa jojjemo ohuaya ma dejjaa ajjima acani ajjima aca quiaye, eya jamatii anijea quiaye —poanaje cojjamaꞌ Jodio etii cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oja sohui quea pame shajjaꞌajja sa po ajjajojo Jodio etii cuana quea quene nee nee poanaje. Tecuea canaje jama baꞌa: —¡De! Miya quea mimishi nee nee jjejojo cojjamaꞌ cuaya poa; miya Eyacuiñajjija cajaa. ¿Aꞌa ecuaaya miya shajjaꞌajjaje? Chojja. ¡Poquicue miya! ¡Aꞌa jiquicua poe oꞌoyajji! ¡Ecuanaja ojee ejjachichaquijji equi yasijje aꞌa poe oꞌoya tiitiijji! —jamaya Jodio etii cuaa oya huoojeacuayajea canaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Majoya pea cuaa Jesosa huohuiqui canaje jama baꞌa: —Jodio etii cuaa cojjamaꞌ cajaa acanaje; Jodioja equi ojee ejjachichaquijji esecue yasijje huoojeacuayajea canaje, pa —poanaje. Jamajjeya Jesosaa oya saꞌajja canaje. Baꞌyo majje huohuiꞌajja canaje jama baꞌa: —¿Aꞌa miquea eba Eyacuiñajjija Bacua Ejja, Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji? —acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Esohui huohuijji, oya ecuea ba jjima. ¡Oya mo ba meecue! Onijje iña jjapeequiꞌyo sa poani —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Eya jja iña iquio, de —Jesosa poanaje—, ma Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji poani. Miya jjeyahua nei Eyacuiñajjija Bacua Ejja nijje mimiani. Eya jja iña iquio, de —Jesosaa acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Majoya ohuaya Jesosa bihuia canaje ecuiꞌoshajjajo nequi majje. Jama poanaje baꞌa: —Ecuea Emeshi Mese, ¡eya miquea epeejji nei nei! —poanaje dejja cojjamaꞌ oja jjabapojjaqui meeꞌyo. ");
INSERT INTO eseNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Eꞌe nei —Jesosa poanaje—, ecue Chiiya eya meshi yasijje huoojea canaje; huohui canaje jama baꞌa: “¡Baquicue! ¿Achajja shai ojjaña cuana jjashahuabaquiani mijo? ¡Baꞌajjaqui socue!” Eyacuiñajjiya aca poa eya. Jiquio ecua cojjamaꞌ jjabapojjaqui meeꞌyaña jayojjaya eyaya ojjaña joya yahuajo Eyacuiñajjija esohui ba po jjima ba meesahuajeꞌyo. Ojjaña joya Eyacuiñajjija esohui ba nisho epo ecuea Eyacuiñajjija esohui eba meejji pojjeama. Jamajjeya oya cuana cojjamaꞌ jayojja tii poaje —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Paniseo cuana jomajo nequi Jesosaja esohui shajjaꞌajja majje jama onijje poanaje baꞌa: —¿Aꞌa miya jjashahuabaquiani ecuanajo; Eyacuiñajjija esohui eba pojjeama ecuanajaya, jamajjeya cojjamaꞌ jayojja poani? —poanaje Jodio etii cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Eꞌe —Jesosaa sajaꞌa canaje—, miquianajaya Eyacuiñajjija esohui ba jjima nei nei jojjemo eyaya miquianaya ba meeꞌyome. Cojjamaꞌ jjabapojjaqui meenaje jama eyaya miquianaya ameeꞌyome. Eꞌe, eyaya miquianaya Eyacuiñajjija esohui ba meeꞌyome quea jaꞌa nee. Jamatii miquianaaya Eyacuiñajjija esohui ba neinei nishoañajo, Eyacuiñajjiya miquianaya tecuea cajeꞌyo; quea nee nee po mee cajeꞌyo cuaquijo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Majoya Jesosa ojjaña nijje jama poanaje peaꞌai baꞌa: —Ecuea esohui ejjashahuabaqui meejji ñajjajja cuiñajjijo jama baꞌa: Ñajjajja jaahuanajjiya ñajjajja cuana jiyojo cahui mee cani, ijjiacajji mase cuaa eꞌijjia ca poajejje. Ejaahuanajji jiyo esecue jjanijo jaani, esecue jjani queya cani. Siipojji cuana ca ca ñajjajja jiyojje nequisohua majje quehua dobiquiani. Oya cuana siipojji jjejojo esecuejje dobiqui ajja. ");
INSERT INTO eseNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ñajjajja jaahuanajji ca ca esecuejje dobiquiani, de. ");
INSERT INTO eseNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jiyo esecue cuiñajjiya esecue caꞌapejo cani ñajjajja cuiñajji dobiquijji. Dobiqui majje ejaahuanajjiya ojaya ñajjajja iyaa cani. Iyaa cajje o que poeyani. Ñajjajja jaahuanajji ehui dojojji poquiani esecue yasijje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cuayaqui majje ñajjajja cuana o quiquishijji poquiani. Eꞌe, ejaahuanajjija esohui ojaya ñajjajjaja eba, eshajjaꞌajjajji. Jamajjeya o quiquishijji poquiani. ");
INSERT INTO eseNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Peaa iyaa cajje ñajjajjaa shajjaꞌajja jjima acani; poe ajja. Jamajjeya oya ñajjajja poqui ajja pea nijje; ba jjimajo cuajicuajiquehuajeananani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesosaja sohui ejjashahuabaqui meejji ohuaya huohui canaje Jodio cuana huasijje. Jamatii ojaya, Jodio cuanaja quea quehua; jama acanaje baꞌa: —¿Ajeo acuae ca oya mimiani ecuana nijje? —poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jamajjeya Jesosaa oya cuana huohui ca oꞌoyanaje: —¡Bacue, oe! Eya, Jesosa esecue jjani jayojja jama poani. Ecuea epeejji dobiqui meesahuaña. ");
INSERT INTO eseNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ojjaña ejaahuanajji nisho cuana ca ca sii sa poani. Jiquio ecua ñajjajjaa peaja esohui ba jjimajo pea nijje poquiquehua ajja jama jayojja ecuea epeejji nei nei esohui huohuijji nishojo jjashajjaꞌajjaqui ajja —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eꞌe, eya esecue jjani jayojja poani; ojjañaa eya shajjaꞌajja canijo, enijje jjapeequianijo peaꞌai, eyaya oya cuana baꞌe tiitii meejeꞌyo enijje. Jiquio ecua ñajjajja jaahuanajjiya ojaya ñajjajja esecuejje dojocuayaqui cani bobi ijjiaa, jiyo huasijje jaahuana cani peaꞌai jayojja jama eyaya ecuea epeejji baꞌe meesahuaña quea pame nee, Eyacuiñajjija esohui jama —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Siipojji poeyani ñajjajja siiya, cuaquisho meeya peaꞌai, quecuaa peaꞌai. Jamaya esohui huohuijji nisho cuana siajje poani, sii cani, ecuea epeejji cuana poquiquehua mee cani eshahua nijje, de. Eya ca ca poeyanaje quea jaꞌa nee nee baꞌe meeya, pea ejjashahuabaquijjijo baꞌe meeya. ");
INSERT INTO eseNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Eꞌe, eya ñajjajja cuiñajji quea pame nee jayojja jama poani. Ñajjajja cuiñajjiya ojaya ñajjajja nahue neinei cani ijjiacajji maseya eꞌijjia ca poaje jjejojo. Oya jayojja eya manojeꞌyo ecuea epeejji cuana baꞌe tiitii meeꞌyojji. ");
INSERT INTO eseNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Echacojji ca ca eñajjajja mese pojjeama jjejojo ijjiacajji mase ba majje cuajicuajinanani; ñajjajja jeajea cananani. Jamajje ijjiacajji maseya ñajjajja cuana ijjia cani; poquiquehuajeanana mee cani peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ñajjajja cuana ojaya nahueꞌama. Echacojji cuajicuajijeananani, ojaya pojjeamajojo mi nahue cani —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","—Eya ca ca ñajjajja cuiñajji quea pame nee jayojja jama poani. Ecue Chiiya eya quea jea nee acani; oya ecuea quea jea nee peaꞌai. Oya jayojjaya eyaya ecuea epeejji cuana quea jea nee nee aña; eya ecuea epeejjija quea jea nee peaꞌai. ");
INSERT INTO eseNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jamajjeya eyaya oya cuana nahue neineiaña, ecuea epeejji cuana. Jamajjeya ojaya mimishi cuijeaꞌyojji eya manojeꞌyo ona baꞌe tiitii meeꞌyojji —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pea cuana yani peaꞌai, Jodio cuana pojjeama. Ohuaya peaꞌai ecuea esohui shajjaꞌajja cajeꞌyo. Ecuea epeejji poajeꞌyo peaꞌai. Eyaya oya cuana jjapeequi meesahuajeꞌyo peaꞌai. Jamajjeya ojjaña cuana ojee cajjapeequiahua; eya ca ca oe o jaahuanajji poajeꞌyo —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—Ecue Chiiya eya huoojea canaje ojjaña jaahuanaa. Jamajjeya ecuea epeejji baꞌe tiitii meeꞌyojji eya manojeꞌyo, ona nahuejo. Eꞌe, e quecuaꞌyojji yani. Jamatii eya quecua caꞌyajje shequije oꞌoya mo. Jamajjeya eya ecue Chiija quea jea nee nee. ");
INSERT INTO eseNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Eya quea caꞌa nee nee poani. Jamajjeya ecuea epeejjijo manoꞌyo sa poꞌyo ajja jojjemo pea cuaa eya equecuaꞌyojji pojjeama pome. Jamatii eya manojeꞌyo jama poani baꞌa: “Eꞌe, ecuea epeejjija mimishi cuijeaꞌyojji manoꞌyo sa poanijo eya manojeꞌyo”. Manoꞌyo majje eya shequije oꞌoya. Ecue Chiiya eya jamaya huoojeame aca poa —Jesosa poanaje Jodio cuana nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesosaja esohui shajjaꞌajja majje Jodio cuana ojee jjamimicuiajea nobiajeaquinaje jama baꞌa: ");
INSERT INTO eseNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—¡Oya Jesosa niñepoqui, de! ¡Oya quea jjashahuabaqui tai mimime poani! ¡Aꞌa oya shajjaꞌajjajji! —poanaje beca cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—Chojja, de oya niñepoqui pojjeama. Esohui quea pame nee nee huohui cani. Ohuaya ca ca oe cojjamaꞌ cuaya jjabapojjaqui mee caꞌyonaje. Jamaya po ajja niñepoqui cuana —poanaje pea cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Quijje eeno shejo ojjaña Jodio cuana Jenosanena huasijje ojee jjachichaqui oꞌoyanaje. Quea bihui nee poanaje ma shejo. Eꞌe, ma shejo yahuajo nei Eyacuiñajjija equi pea iya ca oꞌoya poa quea bame nee. Jamajjeya ma shejoya ma shahuaba tiitii capoquiani Eyacuiñajji bihuia capoqui tiitiiani. Cuaquijiji sisi dedo cani quea cahui huiso. ");
INSERT INTO eseNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma shejo Jesosa Eyacuiñajjija equi yasijje poqui oꞌoyanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Equi quibojo jeojeonequinaje. Jodio dejja cuana o que jjachichaquinaje. Jama huohuiꞌajjame acanaje baꞌa: —Jesosa, ¿apiojji miyaya ecuana huohui jjima? ¿Aꞌa miya Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji? ¡Ecuana eꞌe nei huohuicue quea jaꞌa nee! —poanaje Jodio cuana. ");
INSERT INTO eseNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesosaa oya cuana jama acanaje baꞌa: —Eꞌe, eyaya miquianaya huohui huichaꞌa huichaꞌanaje yahuajo. Jamatii jjashajjaꞌajjaqui ajja. Ecue Chiiya eya ma dejjaa ajjima acani ameesahua cani miquianajaya ebajji nisho eya oja huoojeaꞌyo ojjaña jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jamatii miquianaya jjashajjaꞌajjaqui sa po ajja ecuea epeejji pojjeama jjejojoya. Jamaya eyaya miquianaya huohuinaje baꞌa: “Ejaahuanajjija emimi ojaya ñajjajjaja eba; jamajjeya onijje poquiani”. ");
INSERT INTO eseNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Jama jayojjaya ecuea epeejji cuaa ecue sohui shajjaꞌajja cani, enijje poquiani tii peaꞌaiya. Eꞌe, ecuea epeejji cuana ecuea eba. ");
INSERT INTO eseNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eyaya oya cuana baꞌe tiitii meeaña. Jamajjeya oya cuana quea nee nee epo meeꞌyojji pojjeama cuaquijo, Eyacuiñajjiya. Eyaya ecuea epeejji cuana jaahuanañajo pea cuaa oya ecuaquisho meejji pojjeama eshahua nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ecue Chiiya, Eyacuiñajjiya ecuea epeejji cuana enijje jjapee meequi cani. Oya oe nei quea caꞌa nee nee; pea cuana caꞌaꞌama. Ohuaya oya cuana jaahuana canijo cuaquisho meemee ajja eshahua nijje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eꞌe jojo nei eya ecue Chii jayojjaya poani tii —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma shajjaꞌajja majje Jodio etii cuaa mei iña ca oꞌoyanaje Jesosa jajahuejjajeajji nisho. ");
INSERT INTO eseNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jamajjeya Jesosaa oya cuana acanaje: —Ecue Chiiya eya quea pame nee ma dejjaa ajjima acani amee cani. Jamajjeya ¿apiojji acuae iña jajahuejjajea sa aña soꞌo meiya? —huohuiꞌajjame acanaje Jesosaa. ");
INSERT INTO eseNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Chojja, mi jajahuejjajea sa po ajja ca ca ecuana miyaya ma dejjaa ajjima acani quea pame añajo. Miya siajje poanijo ca mi ca oe jajahuejjajeame. Miya aje mi dejja; jamajjeya ¿apiojji acuae oe miyaya jama huohuime aña baꞌa: “Eya Eyacuiñajji jayojja tiiya” poani? —Jodio etii cuaa Jesosa Eyacuiñajjija Bacua pojjeama poso tii acanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Majoya Jesosaa oya cuana jama acanaje baꞌa: —Miquianajaya eba Eyacuiñajjiya yahuajo nei nei tehue mee ca poa Jodio jaahuanajji cuanajo jama baꞌa: “Miquianaya Eyacuiñajji jayojja poani”. Jama tehuemeya aca poa yahuajo. ");
INSERT INTO eseNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jamajjeya ¡Eyacuiñajjija etehueꞌyo eꞌe nei shajjaꞌajja tiitiicue! Ma etehueꞌyojo ohuaya huohui ca poa Jodio esohui huohuijji Eyacuiñajji jayojjaya poa. ");
INSERT INTO eseNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jamajjeya eya ca ca oe ecue Chiiya babaca ca poa ojjaña jaahuanajji; eya eyajo ani huoojea ca poa meshi yasijje. Jamatii: “Eya Eyacuiñajjija Bacua Ejja” anajejo, miquianaaya eya tecueaña. Jama poani baꞌa: “Miya siajje poani Eyacuiñajji jayojja miame” poani miquianaya. ¿Apiojji jamaya poani? —Jesosa poanaje—. ");
INSERT INTO eseNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","¡Bacue! Eyaya ecue Chiiya acani jayojja aꞌajja jojjemo ¡aꞌa eya shajjaꞌajjame soꞌo! ");
INSERT INTO eseNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Miquianaya ecue esohui shajjaꞌajja sa po ajja; jamatii ecue Chiiya acani jayojja quea pame nee eya añajo, jjashahuabaquicue jama baꞌa: “Jesosa Eyacuiñajjija huoojeaꞌyo poani”. ¡Jamajoya jjabahuejjaquicue eꞌe jojo nei eya ecue Chii jayojjaya, de; oya e jayojjaya peaꞌai poani! —Jesosa poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jamatii Jodio cuaa Jesosa siajje poani poso acanaje. Jamajjeya ojee jama poanaje baꞌa: —¡Cuaꞌa, oya ejjaꞌiñaquiqui ejeanobiajji! —taaame poanaje. Jamatii Jesosa quea huiso nee nee dejja nequi tejjee quehuajje poquinaje, jjaꞌiña meequi jjima. ");
INSERT INTO eseNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Majoya Jesosa poqui oꞌoyanaje cuei Jodana ojje miji yasijje, ma yahuajo Huaniya ona besa mee ca poa huasijje. ");
INSERT INTO eseNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jomajo o anijo quea huiso dejja cuana o baa poeyanaje. Jjachichaqui majje jama ojee miminaje baꞌa: —Eꞌe, yahuajo Huaniya ajjima aca poa ma dejjaa ajjima acani; jamatii ojjaña ojaya ehuohuiꞌyo Jesosajo eꞌe nei poanaje —acanaje cuaa. ");
INSERT INTO eseNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jamajjeya ojjaña jomajo Jesosajo jama poanaje baꞌa: —Eꞌe jojo nei Jesosa Eyacuiñajjija huoojeaꞌyo ojjaña jaahuanajji. ");
INSERT INTO eseNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Pea cuiñajjijo Betania bajjanijo Jesosaja epeejji cuana baꞌenaje: Nasano, oja jjoꞌi cuana Manta, Mania peaꞌai. Maniaa Jesosa ojaya quea jea neejo quijje oya jiojji sha canaje shiyeshiyeya. Sha majje ejiojji cui caꞌyonaje ojaya esaohua, Maniaa. Jesosa Jodana cuei ojje mijijje anijo, Maniaja eno mese Nasano quea mano nee nee poanaje. ");
INSERT INTO eseNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jamajjeya ejjoꞌi mese cuaa pea huoojea canaje Jesosa que: —Nasano quea mano jaa. Jesosa ba majje jama huohuime acue baꞌa: “Emeshi Mese Jesosa, miquea epeejji Nasano quea mano nee nee jaa, poquijeyoje pojjaꞌ