﻿USE sofia;
DROP TABLE IF EXISTS sofia.eri_vpl;
CREATE TABLE eri_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES eri_vpl WRITE;
INSERT INTO eri_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Beha waha no Yesus Kristus nomo asagane unyinege bona lena. Yesus, no Devit nomo ganemuha, Devit, no Abraham nomo ganemuha. ");
INSERT INTO eri_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham no Aisak nomo umamu. Ono wainga Aisak no Jekop nomo umamu. Ono wainga Jekop no Juda nomo bemu gane bagu nebere amenege. ");
INSERT INTO eri_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ono wainga Juda no Peres Sera ngare neire amenere. Neire anyanere Tamar. Ono wainga Peres no Hesron nomo umamu. Ono wainga Hesron no Ram nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ono wainga Ram no Aminadap nomo umamu. Ono wainga Aminadap no Nason nomo umamu. Ono wainga Nason no Salmon nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ono wainga Salmon no Boas nomo umamu. Nomo anya Rahap. Ono wainga Boas no Obet nomo umamu. Nomo anya Rut. Ono wainga Obet no Jesi nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ono wainga Jesi no king Devit nomo umamu. Ono wainga Devit no Solomon nomo umamu. Solomon nomo anya no amina Uria nomo aita yafai. ");
INSERT INTO eri_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ono wainga Solomon no Rehoboam nomo umamu. Ono wainga Rehoboam no Abiya nomo umamu. Ono wainga Abiya no Asa nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ono wainga Asa no Jehosafat nomo umamu. Ono wainga Jehosafat no Jehoram nomo umamu. Ono wainga Jehoram no Usia nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ono wainga Usia no Jotam nomo umamu. Ono wainga Jotam no Ahas nomo umamu. Ono wainga Ahas no Hesekia nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ono wainga Hesekia no Manase nomo umamu. Ono wainga Manase no Emon nomo umamu. Ono wainga Emon no Josaia nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ono wainga Josaia no Jehoiakin nomo bemu gane bagu nebere amenege. Saini waha langa nere Israel goidu Babilon dagou mata langa yafane. ");
INSERT INTO eri_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nere goi Babilon dagou mata langa yafou hugu waribode, Jehoiakin no Sealtiel nomo umamu. Ono wainga Sealtiel no Serubabel nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ono gainga Serubabel no Abiut nomo umamu. Ono gainga Abiut no Eliakim nomo umamu. Eliakim no Asor nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ono gainga Asor no Sadok nomo umamu. Ono gainga Sadok no Akim nomo umamu. Ono gainga Akim no Eliut nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ono gainga Eliut no Eleasar nomo umamu. Ono gainga Eleasar no Matan nomo umamu. Ono gainga Matan no Jekop nomo umamu. ");
INSERT INTO eri_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ono wainga Jekop no Josep nomo umamu. Ono wainga Josep no Maria nomo au. Ono wainga Maria no Yesus bisi tuwai, nere Kristus tude. Fai waha Itou no nomo fai-aita bagu gidu hanigei nomo hangada tuwai. ");
INSERT INTO eri_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Onou waha bona nere Abraham nomo gane laha mai Devit langa heigai waha oruwa 14. Ono gainga nere Devit nomo gane oruwa, mai saini nere Babilon dagou mata langa goyane la edowai waha fere oruwa 14. ");
INSERT INTO eri_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kristus adadu bisi tuwane waha nomo aasa onou. Nomo anya Maria Josep tei nomo urisi kou wane. Ariya saini no Josep ngare teguruwei uwa la nere urane wa Maria no go bagu wai, Hauri Guuni we magana tuwai. ");
INSERT INTO eri_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Au Josep no, fanyimu hilobainga. No isai wa Maria gobagu, waha bona no awa tuwona onowai. Ariya no mayaumu tuwei nomo awadu, no neire teguruwei nomo urisi kou narane waha foinga huwari fasaka wona onowai. ");
INSERT INTO eri_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Saini Josep no waha bona ninau isidu agore inyi inyi gainga, Anyakaro nomo ensel ete no bagu medu letuwai, “Josep, ne Devit ganemuha fai, ne Maria, name aita dorofe yafei nomo adai umugau. No anyirau bagu wa Hauri Guuni we tuwai. ");
INSERT INTO eri_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","No fai magana bisonbona, ono wonga ne nomo unyi Yesus warau. Wa taate bona, no iinga nomo fai-aita bagu une uulu nagidu gidu hanigon bona.” ");
INSERT INTO eri_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ariya dada beha oruwa Anyakaro no beele ete profet hurau la lewai waha tigini heigena. Profet no onou lewai, ");
INSERT INTO eri_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Isagu! Iinga aita magana ete fai bagu inyei uwa la, no go bagudu bona, fai magana bisonbona. Ono wonga unyi, Immanuel tuwodbode.” Nomo hugu benou, “Itou no ere bagu yafana.” ");
INSERT INTO eri_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ariya Josep agore inyai waha, jaidu bona, no Maria, nomo aita yafei nomo bona tai. Anyakaro nomo ensel wewewou la letuwai waha, bolou oojodu bona onowai. ");
INSERT INTO eri_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ariya Josep no menanga te Maria ngare jiriweru uwa, onou golo gainga goi Maria no fai magana bisai. Ono wainga Josep no fai magana waha unyi Yesus warai. ");
INSERT INTO eri_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Yesus Betlehem taon Juda distrik la bisi tuwai, saini Herot no king yafa gainga. Maria no Yesus bisainga, iinga nere baatu lelegegou isou fai, ulate hoonga mayouha Jerusalem mayane. ");
INSERT INTO eri_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Maidu bode isoki wane, “Magana momodo no Juda nebere king, alanga yafana? Ere nomo baatu ulate hoonga mayoula uredu, unyi isouwei nomo boya maiyaha.” ");
INSERT INTO eri_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ono wanenga king Herot no waha isidu bona ninau baingaro isai. Onodu Jerusalem la fai-aita fere oruwanga ninanege baingaro isane. ");
INSERT INTO eri_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","“Onodu Herot no Israel nebere pris aroro, nuuni beele isou fai bagu oruwanga komomu nigidu isoki nigai, Itou no fai waha, nomo fai-aita bagu gidu hanigei nomo huuru tuwonga monbona beele agili mala karuwai, no matane adeha langa heigon bona?” ");
INSERT INTO eri_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ono wainga, nere ege gidu letuwane, “No Betlehem taon Judia la heigon bona. Profet no beele onou yeregai. ");
INSERT INTO eri_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ne Betlehem, Juda nebere oula la, nere Juda la taon unyinege aroro waha inyangaro mogonege adai taga nigau. Gai uwanga uwa. Taate bona, name fai ete no mora bagu heigon bona, onodu no yame gane Israel nebere oofa nigou yafonbona.’” ");
INSERT INTO eri_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Onodu Herot no beele beha isidu bona, no huwari beele huuru wainga ulate hoonga mayouha isou fai bagu goyai, nere maidu urodbode waha bona. Nere mayanenga no isokide nigai, taate saini la baatu waha heigai. ");
INSERT INTO eri_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Onodu no Betlehem huuru nigainga goigane lenigai, “Tere goidu danga tafadu magana waha kuru dewagu. Ariya, tere toroba tubonade wonga wa, tere ege gidu mai lehiyagu. Ono wadenga, ji fere goidu unyi isou wonboni nigai.” ");
INSERT INTO eri_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ariya nere king Herot nomo beele isi borodu nere goyane. Nere jala langa goi bode, baatu amina hoonga mayou la urane wahanga ege urane. Baatu no amugedu mani mata magana momodo inyai waha jangu la otowai. ");
INSERT INTO eri_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Saini nere baatu waha uredu bode, oo nere edega anyakaro wane. Huwanyanege edega wou anyakaro. ");
INSERT INTO eri_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nere manidu mata waha huwanya goidu bode nere magana waha, anya Maria ngare neriredu bode, nere afenege tuburu kutudu unyi isou bode, nebere olodo fausi isebudu toota ila tuwane. Nere gol bagu sanda bagu paura nomo butu agiya hilobainga heigemu gou bagu tuwane. ");
INSERT INTO eri_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wewewou la Itou no nere lenigai, tere Herot bagu adai goyagu. Ono wainga nere jala ete tedu bode, nebere matane minane. ");
INSERT INTO eri_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nere isou fai mini haragane, Josep ooru agore inyi bona wewedu, Anyakaro nomo ensel ete no bagu medu letuwai. Herot no magana waha dukotewei nomo bona kuru tuwonbona. Onou waha bona “ne jaidu, magana waha nomo anya ngare haniredu fagadu goi Isip la yafau. Yafagahe, iinga ji yage we lehinon boni.” ");
INSERT INTO eri_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ono wainga Josep jaidu bona, ooru waha langa magana nomo anyangare haniredu bona fagadu Isip goyai. ");
INSERT INTO eri_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Goidu wala yafa gainga, goi Herot umai. Dada heigai waha, Anyakaro nomo beele ete profet hurau langa lewai waha edomuwai. No onou lewai, “Ji yame idafe no Isip la yafana, ji no Isip awadu mayei nomo yaure tunanga mayaha.” ");
INSERT INTO eri_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ariya Herot no benou isai, nere hoonga mayouha isou fai yaawa tuwane, waha bona no houmu danga bagu mayai. Onodu no fai ila huuru nigainga goidu Betlehem taon bagu, nere matane jugu-jugu yafade waha bagu, nebere fai magana mene-mene haga orei nga feiyawei uwa waha oruwa dunege kote wanenga umeru wane. Herot no isou fai isokide nigai, taate saini la tigini baatu waha heigai, taate bona, no magana mene-mene anyanege gane saini waha la bisi nigane, waha dunege kotewane bona, no isou waha bagu. ");
INSERT INTO eri_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nere dada waha amina Itou nomo beele, profet Jeremaia hurau langa lewai waha edomuwai. ");
INSERT INTO eri_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Merou anyakaro bagu moone augam bagu Rama taon langa heigai. Wa Resel nomo magana umeru wane bona augam bagu merai, no fai-aita bagu huwanya tiginimu fuwei nomo awai. Wa taate bona, nomo magana oruwanga yafegu uwa.” ");
INSERT INTO eri_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Saini Herot umainga, ariya Isip langa Josep nomo wewewou la, Anyakaro nomo ensel no bagu heigai. ");
INSERT INTO eri_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Onodu ensel no Josep benou letuwai, “Ne jaidu name magana nomo anya ngare haniredu bonahe ege gidu Israel goyau, fai nere magana waha dukotewei nomo ono wane waha, nere oruwa umeru borowane.” ");
INSERT INTO eri_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ono wainga, Josep jaidu magana nomo anya ngare haniredu bona ege gidu Israel kantri la goyai. ");
INSERT INTO eri_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ariya Josep no onou isai, Arkelaus no umamu Herot nomo haumu taha, Judia nebere king yafana. Onou waha bona, Josep no haumu waha la goyei nomo umugai. Ariya Itou no Josep wewewou la letuwai. Ono wainga Josep no Galili distrik ulate langa goyai. ");
INSERT INTO eri_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","No goidu taon ete Nasaret ide wala yafai, onodu fanyimu waha langa no profet nebere beele edomuwai. “Nere no Nasaretha fai tuwodbode.” ");
INSERT INTO eri_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saini waha la, Jon yaage bisemu nigigou fai, no heigai. No Judia distrik langa, ha fai uwau la yafa bona, fai-aita bagu beele malalamudu lenigai. ");
INSERT INTO eri_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“No benou lenigai, tere huwanyatege ubulu wagu. Ha laluwa Itou nomo huuna la yafou amina mai jugu waha.” ");
INSERT INTO eri_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon no fai waha, Itou no profet Aisaia hurau la no bonadu lewai. No benou lewai, “Ha fai uwau la, fai ete hurau la yaurou ete benou heigai, Anyakaro nomo jala haiya fuwagu, ‘nomo jala tiginimu fuwagu.’” ");
INSERT INTO eri_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon no kolos kamel ululumu la atane waha tanigai, onodu no leeti ungu la tagugai. Ariya no da koisi ameme hu bagu nyigai. ");
INSERT INTO eri_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Saini waha langa, nere Jerusalem bagu Judia bagu matane Jordan yaage hinemu la inyide waha fai-aita bagu oruwanga, nere Jon bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nere maidu bode, nebere une malalamu ganenga Jon no Jordan yaage langa yaage bisemu nigaiha. ");
INSERT INTO eri_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ono bona Jon no Farisi bagu, Sadyusi bagu, yaage bisou tei nomo mayanenga nerigaiha. Onodu bona Jon no nere benou lenigai, “Tere maangi inyaba nomo magana,” Itou no tere bona houmu mayona wa, tere heile ada tigonbona. Faiwei letigaha, tere heige hara bonade, saini inyaba tere langa heigona onona waha feiya tuwagu ganga? ");
INSERT INTO eri_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tere huwanyatege ubuluwei matayaha wonga, wa tere tebere fanyitege langa, tere huwanyatege ubulu yaha wou waha malalamu wagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tere tage huwanyatege langa benou adai isagu, “Abraham no ere ebere asage fai.” Ji letigini, Itou no edo langa megebu otode beha waha, nere Abraham nomo asagane heigemu nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Safora nauge hugu langa amina haiyawaha inyina, nere nauge oruwanga hilou hilobainga ada heige-heigede waha, nere lalatidu bode eeya langa ayaru wogunga goyonbona. ");
INSERT INTO eri_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ji tere yaage langa yaage bisemu tigi-tigini, wa tere huwanyatege ubulu yaha waha nomo naani dorofe. Onou wa, fai no iinga ji mogofe maina waha, no nomo danga ji yame danga feiyawou. Ji no nomo afo osoko tanou, aule fuwei nomo ji fai hilou uwa. No tere yaage langa yaage bisemu tigoufe, no tere Hauri Guuni eeya bagu langa bisemu tigonbona. ");
INSERT INTO eri_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Fai no waha sawol owo langa yaasudu bona, wit langa tuturumu oruwanga elegedu ayaruna dorofe mayonbona. Onodu bona, no wit hilou waha wit mata langa komomu wonbona. Ono bona, tuturumu waha no eeya ada gare-garena waha langa biteru wonbona.” ");
INSERT INTO eri_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saini waha la, Yesus Galili awa tudu Jordan yaage langa, Jon owola yaage bisou tei nomo bona minai. ");
INSERT INTO eri_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Onou wa, Jon no karu tuwona ono bona letuwai, “Onou wa ji ne langa yaage bisou tonboni. Adadu boni ne ji langa mainaha?” ");
INSERT INTO eri_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ono wainga Yesus no gidu Jon letuwai, “Ono urona, elebe ji lehinini onou onowau. Fanyimu waha langa Itou no dada oruwanga ere onowei nomo gau tuwai waha edomuwei nomo.” Ono wainga Jon nomo bolou oojowai. ");
INSERT INTO eri_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus no yaage bisou tedu bona, fasadu onou yaage awa tudu digedu mayai. Ono gainga, ha laluwa helufawai, onodu Itou nomo hauri megainga urai wa neei ete buuna dorofe medu no langa yafai. ");
INSERT INTO eri_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ono gainga bolou ete ha laluwa langa benou lewai, “Beha yame magana. Ji no gaude de tuni. Ji no boni huwanyafe edegana.” ");
INSERT INTO eri_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Saini waha langa, Satan no Yesus wala-wala tuwei nomo bona, Hauri Guuni no Yesus haudu ha fai uwau langa manai. ");
INSERT INTO eri_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Onodu Yesus no da nyei uwa hoonga 40 ooru 40 yafai, iinga no huweli tuwai. ");
INSERT INTO eri_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ono gainga, wala-wala nigigou fai no bagu maidu letuwai, “Ne ngalenga Itou Idau wonga, ne lewahenga megebu beha edo ubuludu beret heigode.” ");
INSERT INTO eri_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ono wainga Yesus no beele benou gidu letuwai, Itou nomo buk langa beele benou bagu, nere fai-aita bagu da langanga agenege auma yafou ada tetede. Uwa. Nere Itou nomo beele oruwanga fere edo oojodu agenege auma yafou todbode. ");
INSERT INTO eri_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","No onou lewainga, Satan no haudu Jerusalem goyai Itou nomo taon langa, onodu no gai ouwe la tafa tuwai. ");
INSERT INTO eri_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Onodu Satan no onou letuwai, Ne ngalenga Itou Idau wonga, ne talagedu minau. Taate bona, Itou nomo buk langa beele benou bagu, no nomo ensel lenigonga nere ne edola oofa hinodbode, onodu nere owonege langa ne aule hinodbode, gamaji megebu ete afene waroga. ");
INSERT INTO eri_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ono wainga, Yesus letuwai, “Itou nomo buk ege onou lena, ‘Ne name Anyakaro Itou nomo danga adai wala-wala fuwau.’ ” ");
INSERT INTO eri_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ono wainga Satan no ege Yesus haudu garou ete gai ouwe langa manai. Onodu Satan no oula beha nomo kantri, danga oruwa bagu nebere dada hilou-hilou bagu abitimu tuwai. ");
INSERT INTO eri_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Onodu bona no Yesus benou letuwai, “Ne afene tuburu kutudu ji hauya hibonahe wonga wa, ji dada waha oruwa ne hinonboni.” ");
INSERT INTO eri_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ono wainga Yesus no letuwai, “Satan ne sinawau. Itou nomo buk lena, ‘ne Itou nomo huuna la yafau, name anyakaro, onodu no nogonga unyi isouwau.’” ");
INSERT INTO eri_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ono wainga Satan no awa tuwai. Ono gainga nere ensel medu bode Yesus hoyo tuwane. ");
INSERT INTO eri_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Saini Yesus no Jon dagou mata langa tafa tuwane waha beele isidu bona, no Galili distrik langa goyai. ");
INSERT INTO eri_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Onodu bona no Nasaret taon awadu goi Kaperneam taon langa yafai. Kaperneam no Galili yaage katiwou hinemu langa inyina, Sebulun Naptali bagu nebere oula la. ");
INSERT INTO eri_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Onodu fanyimu waha langa, Itou nomo beele ete profet Aisaia hurau langa benou lewai waha Yesus no edomuwai. ");
INSERT INTO eri_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nere Sebulun oulaha fai-aita bagu, nere Naptali oulaha fai-aita bagu nebere oula wa, jala anyakaro hiiri langa minou jugu la inyina. Onodu oula Jordan yaage ulate la inyina wa Galili distrik nebere. Distrik waha, fai-aita bagu kantri fere-fereha baingaro yafade, ");
INSERT INTO eri_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nere fai-aita bagu agugu langa yafade waha nere lala anyakaro amina urane. Nere fai-aita bagu agugu bagu langa yafade waha lala nere langa amina heigaiha.” ");
INSERT INTO eri_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Saini waha langa Yesus no beele lenigou hugu warai. No lewai, “Tere huwanyatege ubulu wagu, taate bona, ha laluwa nomo huuna la yafei nomo amina jugu waha.” ");
INSERT INTO eri_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus no Galili yaage katiwou mou langa golo bona, no fai nga nononga bemu ngare nerirai. No Saimon, nomo unyi ete nere lede, Pita, no nomo bemu Andru. Nere nga hagoma yaage katiwou langa ayawou haruwe tare. Nere moni kusewei nomo hoowe haruwe tetedere. ");
INSERT INTO eri_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ariya Yesus no nere nga benou lenirai, tere taga hidu mayaru. “Ji tere fai-aita bagu elege nigei nomo fanyimu waha abitimu tironboni.” ");
INSERT INTO eri_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ono wainga, nere fasayadu onou neire hagoma awaare inyi gainga no oojo tuware. ");
INSERT INTO eri_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus no ege menanga onou golodu goibona, no ege, fai nga nononga bemu ngare nerirai. Jems, no Sebedi idau, nomo bemu Jon ngare nerirai. Nere bot langa amenere Sebedi ngate yafane. Nere nebere hagoma korai wainga erere bode yafa ganenga, no yaure nirai. ");
INSERT INTO eri_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ono wainga nere fasayadu onou, amenere bot langa awa tudu Yesus oojo tuware. ");
INSERT INTO eri_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus goidu Galili distrik ulate langa oruwa golowai. Ono bona no fai-aita bagu nebere bori mata huwanya langa goidu isisiwou nigigai. No Itou nomo huuna langa yafei nomo hilou beele malalamudu lenigi bona, fai-aita genege gala taura bagu, dada inyaba oruwa nere genege gala inyabamu nagai waha jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ono wainga nere Siria prowins oruwa nebere aasa hai fuwane. Waha bode nere fai oruwa taura hugu fere-fere bagu, jimiri inyaba tetede waha bagu, nere fai hauri inyaba bagu, nere fai kusibu narige ganga mebodudu tererede waha bagu, nere fai ngedonege ume borowou waha bagu hanigedu mayane. Ono wanenga no ege jigemu nigai. ");
INSERT INTO eri_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ono wainga nere fai-aita bagu baingaro, Galili bagu, ulate Dekapolis distrikha bagu, Jerusalem bagu, Judia bagu, oula Jordan yaage ulate la inyina bagu, nere no oojo tugane. ");
INSERT INTO eri_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus no nere fai-aita toomaro nerigedu bona, no muju ete langa digedu manai. No manidu bona yafa gainga, nomo disaipel no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ono wanenga Yesus no nomo disaipel isisiwou benou nigai, ");
INSERT INTO eri_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nere fai-aita iside, nere Itou nomo onowou hilou bona tutu nigina waha, nere dabu edega wode. Ha laluwa nomo huuna langa yafou wa nere nebere. ");
INSERT INTO eri_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nere fai mere bode yafade waha, nere dabu edega wode. Itou no nere huwanyanege hiloumu nagon bona. ");
INSERT INTO eri_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nere fai-aita bagu nage unyinege ileide waha, nere edo edega wode. Itou no oula oruwa nere nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nere fai-aita bagu onowou hilobainga oojowei nomo gaude nigina, onowou wahanga la, fai ete no huweli danga bagu tuganga da nyei nomo gaude tuna, ono bona yaage nyomole tuna dorofe, wa nere edo edega wode. Wa Itou no gai edomude nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Fai-aita bagu nere fai ila bode aau narigena waha, nere edo edega wode. Itou no nere bona aau waronbona. ");
INSERT INTO eri_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nere fai-aita bagu huwanyanege jijiga uwau waha, nere edo edega wode. Nere Itou urodbode. ");
INSERT INTO eri_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nere fai-aita bagu honggoro guruwou, warawou bagu uwamude waha, nere edo edega wode. Nere Itou nomo magana nigodbode. ");
INSERT INTO eri_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nere fai-aita bagu onowou hilobainga ojo-ojode, hugu waha langa nere fai ila nebere ou elege bode wonga, nere edo edega wode. Ha laluwa nomo huuna langa yafou waha nere nebere. ");
INSERT INTO eri_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Tere ji yame fai-aita bagu yafagadenga, nere terige bode beele inyaba letigi bode, inyabamu tigi bode, yaawa beele hogo fere-fere huwanyatege wari bode wonga wa, tere edo edega wagu. ");
INSERT INTO eri_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tere huwanyatege dabu hilobainga inyi gonga edega dewagu, wa taate bona, tebere agou anyakaro ha laluwa langa itari tigina. Nere fai onowou inyaba hogo etenga wahanga profet nere tere amuge tigidu bode goyanenga ono nigane.” ");
INSERT INTO eri_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yesus no ege onou lena, tere oula beha nomo sol dorofe. Ariya sol nomo iisa usu wonga wa, ere ege adadu onowedenga sol nomo iisa heigona? Sol onouha waha nomo haruwe uwau. Fai nere ayarudunga afenege langa ilei-ileide. ");
INSERT INTO eri_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tere oula nomo lala dorofe. Isagu. Taon ete muju la otona, no huwariwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Onodu fere, fai nere nebere lama dugedu baket huuna la ada tafa-tafade. Uwa. Nere tewol ouwe la tafa-tafade. Ono ganenga fai oruwa mata la yafade waha lala nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Onounga, tebere lala fai-aita bagu agenege la lala wona. Ono wadenga nere fai-aita tere hilobainga onoya waha uredu bode, nere tebere Ametege ha laluwa la yafana waha, unyi isou wodbode.” ");
INSERT INTO eri_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesus no ege onou lena, “Tere ji meene waha, nuuni beele bagu profet nebere beele bagu uwamu wei nomo maiha wou adai isagu. Uwa. Ji uwamu wei nomo boni mei wa. Ji edomuwei nomo boni meene. ");
INSERT INTO eri_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ji tere ngalenga letigini. Saini ha laluwa oula bagu usuwou saini langa goi edo wona waha, nuuni beele nomo matau menakele ete ada yooso wonbona. Uwa. Yeregou matau mene-mene bagu, nuuni beele yeregou nomo naani mene-mene oruwanga inyonbona. Nuuni beele no onounga inyi gonga goi, dada oruwanga heige boro wonbona. ");
INSERT INTO eri_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Onou waha bona, fai ete nuuni beele ulate waha dada ewe dorofe urei mata wonga wa, no fai ila fere kuse nigonga, nere fere onounga onowod bode, ayria nuuni beele matau waha gai menakele, fai waha unyi ha laluwa nomo huuna langa yafou gai menakele inyonbona. Onou wa, fai no nuuni beele oojo bona fai-aita bagu oojowei nomo isisiwou nigona wa, no ha laluwa nomo huuna langa yafou la unyi gai anyakaro bagu. ");
INSERT INTO eri_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ji tere letigini, tere Itou nomo gauwou tigini ada oojodu, tebere fanyitege ada tiginimudu, nuuni beele nomo isou fai Farisi bagu nebere fanyinege tigini waha ada feiya debonade wonga wa, tere ha laluwa nomo huuna langa yafou huwanya ada goyagu ganga.” ");
INSERT INTO eri_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nere asage gane beele taane waha tere amina iseye, tere fai-aita bagu adai dunege kote wagu. Ariya fai ete no ilibumu ete dukote wona wa, no kot la heigon bona. ");
INSERT INTO eri_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ariya, ji benou letigini, fai no bemu bona honggoro bagu wonga wa, no kot la heigon bona. Ariya, fai no bemu beele inyaba letuwona wa, no amugou kaunsel la heigon bona. Ono wonga fai ete no bemu letuwona, ne dabu tayou tigini, fai waha no tigini eeya ha la goyonbona. ");
INSERT INTO eri_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Onou waha bona, ne name dada Itou eeya muru wari fuwei nomo alta la tamai bonahe wonga, ne name baine no ne bagu honggoro inyina waha bonahe ninate isau. ");
INSERT INTO eri_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ono waha bona, ne name eeya muru warou alta hinemu la tafadu bonahe. Ngasunga ne goyahenga baine ngare beele tiginimu waru. Tiginimu borodu, ariya elebe ne edo goidu name eeya muru warou Itou tuwau. ");
INSERT INTO eri_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ariya fai ete ne kot langa tafa hinei nomo ono wonga wa, tere jala gama kot haumu la goi bonadere, ne fasadu onou no ngare beele tiginimu waru. Gamaji fai waha no jas owola tafa hinoga, ono wonga jas no ne polis owonege tafa hinonga, nere dagou mata la tafa hinodbode. ");
INSERT INTO eri_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ji ngalenga lehinini, ne dagou mata langa yafa bonahe moni waha oruwa ejiya gahenga goi, haawe hanane langa edo wonbona. ");
INSERT INTO eri_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesus no ege onou lena, “Tere amina nere benou lewanenga iseye, tere fai-aita bagu longi fanyimu adai ono wagu. ");
INSERT INTO eri_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Waha boni ji tere benou letigini, Fai ete no aita ete ewe gau tubona feele tuwona wa, fai waha no amina huwanya la longi fanyimu ono waha. ");
INSERT INTO eri_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Onou waha bona, ne name agene magana owone hilou la waha no une tafei nomo kuse hinonga wonga, ne agene waha faasidu kaitau. Ono wau wa hilobainga, ne name geete gala matau no yaae wonga, ne une ada tafa bonahe, name geete gala oruwa eeya langa ada goyona. ");
INSERT INTO eri_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ariya owone hilou no ono hinonga une langa mebodu bonahe wonga, ne karudu kaitau. Ono wau wa hilobainga, ne name geete gala matau no yai wonga, ne une ada tafa bonahe wa, name geete gala oruwa eeya langa ada goyona.” ");
INSERT INTO eri_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesus no ege onou lena, “Amina nere benou legane ‘Fai ete no nomo oya awa tuwona wonga, no aita awa tuwou fefa ete tuwonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Onou wa, ji letigini, saini aita no longi fanyimu onowei uwa, au no awa tubona wonga, fai no aita waha ono tuwanga te guruwou fanyimu feiya waha. Taate bona, saini aita waha fai ete tena wa no longi fanyimu onona. Onou wa fai no aita amina au awa tuwai waha te bona wonga, no fere te guruwei nomo nuuni beele feiyadu longi tafana.” ");
INSERT INTO eri_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesus no ege benou lewai, “Beele ete nere asage gane taane waha tere iseyeha, waha benou. Saini ne ngalenga tigini ouwe langa bonahe, ‘ne adai yaawa wau. Onou waha bona, ne taate dada ete onowei nomo boni ne leni, ngalenga tigini ouwe langa bonahe wonga, ne tigini Anyakaro ago langa beele waha oojodu onowau.’ ");
INSERT INTO eri_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Onou wa, ji tere letigini, tere ngalenga tigini ouwe langa wou adai lewagu. Adainga adai. Tere beele ete dangamu wei nomo bonade ha laluwa unyi adai taagu, taate bona, ha laluwa no Itou nomo Sia King. ");
INSERT INTO eri_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ono bonade tere beele ete dangamu wei nomo bonade oula unyi adai taagu, taate bona, oula wa Itou afo jaula tafagou haumu. Ono bonade tere beele ete dangamu wei nomo Jerusalem unyi adai taagu, wa taate bona, Jerusalem wa King Anyakaro nomo taon. ");
INSERT INTO eri_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ono bonahe ne beele ete dangamu wei nomo ne name morane bonahe adai lewau, wa taate bona, ne morane langa tawane gala ete kaamba yo usuma yo ne heigemu wei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Onou waha bona tere, ‘Yoo’, ‘Uwa’, wahanga lewagu. Wa edo. Beele nere waha langa turi turide, beele waha Satan no heigemu wai.” ");
INSERT INTO eri_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesus no ege onou lena, “Nere amina onou lewane waha tere iseyeha, ‘Fai ete no ilibumu ago inyabamu fuwonga, ariya tere fere no ago inyabamu fuwagu. Onou wa, fai ete no ilibumu maa kote fuwonga, ariya tere fere no maa kote fuwagu.’ ");
INSERT INTO eri_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Onou wa, ji tere benou letigini, Fai no tere inyabamu tigina waha tere agou ege adai tuwagu. Uwa. Fai ete no ulagete bare wei mata wonga wa, ne ege ulagete ulate fere ubuludu tuwau. ");
INSERT INTO eri_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ono bonahe fai ete no name siot tei nomo bona kot langa tafa hinei mata wonga wa, name kolos ufalai fere onounga no tuwau. ");
INSERT INTO eri_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Onodu fai ete nomo udu auledu kilo mita etenga goyei nomo danga tafa hinonga wa, ne nomo udu aule fudu goi kilo mita nga langa edo wau. ");
INSERT INTO eri_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Onou wa, fai ete no dada ete bona isoki hinei mata wonga wa, ne tuwau. Ono bonahe fai ete no ne langa agou tei nomo onowei mata wonga wa, ne no adai moge tuwau.” ");
INSERT INTO eri_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesus no ege benou lena, “Nere amina beele benou lewane waha tere iseyeha, ‘Ne name ilibane gane gaude nigi bonahe, name honggoro fai bonahe huwanyate inyabawou.’ ");
INSERT INTO eri_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Onou wa ji tere benou letigini, tere tebere honggoro fai gaude nigagu, Ono bonade tere hauya wadenga Itou no fai nere onowou inyaba tere ono tigide waha bona aau waronbona. ");
INSERT INTO eri_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ono wagu wa, tere tebere ametege ha laluwa langa yafana waha, nomo magana yafagu ganga. No nomo hoonga ono ganga, nere fai inyaba bagu fai hilou bagu jaulanege ouwe langa mai-maina. Ono bona no yaage ono ganga, nere fai hilou bagu nere fai onowou tigini ada onode langa fere memena. ");
INSERT INTO eri_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Onou wa tere fai gaude tigide wahanga gau nigagu wa, tere agou adoha waha taagu ganga? Nere fai takis tegou fere onounga ono onode. ");
INSERT INTO eri_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Onodu tere tebere baitege gane wahanga kaiye nigi bonade wonga, tere fai ila taate dada langa feiya nigagu ganga? Nere haiden fere onounga ono onode. ");
INSERT INTO eri_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Onou waha bona, tere fai-aita bagu gai tigininga tigini yafagu, tebere Ametege ha laluwa langa gai tigininga tigini yafana dorofe.” ");
INSERT INTO eri_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus no ege benou lewai, “Tere ure dewagu. Tere fai agenege langa tere tebere onowou hilobainga waha ono wadenga nere urei nomo bonade adai ono wagu. Tere onou ono wagu wa, ha laluwa langa tere tebere agou Ametege la inyina waha ada taagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ne nere fai dadanege uwau waha dada nigon bonahe wonga, ne fai ete huuru tuwahenga amugedu goi bona, tauli buu bona nere fai ila bori mata huwanya la bagu, jala la bagu ono-onode onou adai onowau. Nere fai waha, fai-aita bagu yaawa nigi ganenga, fai waha hilobainga idu bode unyi isou-isoude. Ji tere ngalenga letigini, nere fai waha nebere agou amina taneha. ");
INSERT INTO eri_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Onou waha bona ne fai dadanege uwau waha hoyo nigei nomo wonga, ne name owone kenao no name owone hilou dada onona waha ada isona. ");
INSERT INTO eri_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Onou waha bona, ne name augami guruwou haruwe waha huwari inyonbona. Ono gahenga, ne name Amene no dada huwari inyi ganenga no ure-urena waha, agou ege gidu hinonbona.” ");
INSERT INTO eri_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Saini tere hauya bonade wonga, tere yaawagou fai ono onode dorofe adai ono wagu. Nere bori mata huwanya langa bagu, jala aro owo tuburu warou langa oto bode, nere fai nerigei nomo bode, hauyawei nomo gau nigi-nigina. Ji tere ngalenga letigini, nere waha nebere agou amina taneha. ");
INSERT INTO eri_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Onou wa, saini ne hauyawau ganga wonga, ne name jauli huwanya langa goidu bonahe jauli sesemudu, ne name Amene haumu huwari langa yafana waha hauya tuwau. Ono wahenga, ne name Amene no nere dada huwari inyi ganenga nerige-nerigena waha no agou gidu hinonbona. ");
INSERT INTO eri_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Onou waha bona, saini tere hauya wagu ganga wonga tere beele baingaro ewe auma adai lewagu. Nere haiden ono-onode dorofe. Nere benou iside, nere beele baingaro lewogunga Itou no nebere beele isi nagonbona. ");
INSERT INTO eri_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tere nere nebere onowou waha adai oojo wagu. Saini tere tebere Ametege, tere huratege faasudu isoki tuwegu uwa langa, no tere dada oruwanga boya tutu tigaha waha no amugedu isaha. ");
INSERT INTO eri_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Onou waha bona, “Tere benou hauya wagu, ‘Oo ebere Jijei, ne ha laluwa langa yafani, ne unyite guuni inyou. ");
INSERT INTO eri_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Name huuna la yafou wa tigini mayou. Ere oula la ne name gauwou oojo wei nomo, nere ha laluwa langa oojode dorofe. ");
INSERT INTO eri_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Elebe fati beha nomo da edomu higau. ");
INSERT INTO eri_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Onodu ne edo, ere ebere nyabuluwou uulu hagau, nere ila une la tafa higigane waha ere uulu nagiya dorofe. ");
INSERT INTO eri_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Onodu ne wala-walawou awa nigahe ere langa adai mayogu, onou wa ne edo dada inyabaha, ege gidu haigau.’ ");
INSERT INTO eri_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Isagu, Tere fai-aita bagu ila nebere nyabuluwou uulu nagi bonade wonga wa, tebere Ametege no ha laluwa langa yafana waha no fere tebere nyabuluwou uulu tagonbona. ");
INSERT INTO eri_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Onou waha bona tere fai-aita bagu ila nebere une ada uulu nagi bonade wonga wa, tere tebere Ametege ha laluwa langa yafana waha, no fere tere tebere une ada uulu tagonbona.” ");
INSERT INTO eri_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ariya tere urigei mata bonade wonga, tere yaawa gou fai dorofe hogotege adai inyabawou, nere hogonege kara wonga fai-aita bagu nere da uriganewou waha isi nigi-nigide. Ji tere ngalenga letigini nere nebere agou amina tane. ");
INSERT INTO eri_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Onou wa, ne urigei mata bonahe wonga, ne faronga morane langa tafadu bonahe hogone hugau. ");
INSERT INTO eri_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ono wahenga, fai ne da urige naha waha ada isode. Ne name Amene no huwari langa yafana waha no nogonga isonbona. Ono gahenga, ne name Amene no dada huwari inyi ganga ure-urena waha no ne agou hinonbona.” ");
INSERT INTO eri_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesus no ege benou lena, “Tere tebere dada hilou-hilou ha esene beha langa adai elegedu komomu wagu. Ha esene beha langa, mugumugu bagu ros bagu dada inyabamu-inyabumude. Nere yebu fai fere orei fasakadu bode yebu-yebude. ");
INSERT INTO eri_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Onou wa, tere tebere dada hilou-hilou waha ha laluwa langa komomu wagu. Ha laluwa langa mugumugu bagu ros bagu nere dada ada inyabamu inyabamude, nere yebu fai fere orei fasakadu ada yebu yebude. ");
INSERT INTO eri_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Haumu ne name dada hilou-hilou otode waha langa, ne name gauwou fere walanga inyonbona.” ");
INSERT INTO eri_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yesus no ege benou lena, “Agege no geege gala nomo lama. Ne agene hilou wonga, lala no geete gala oruwa langa edo wonbona. ");
INSERT INTO eri_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Onou wa, ne name agene magana no inyaba wonga, ne name geete gala oruwa agugu wonbona. Ariya lala ne huwanyate langa inyina waha, no agugu dorofe wonga, agugu waha no gai anyakaro wonbona.” ");
INSERT INTO eri_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesus no ege benou lena, “Fai etenga hoobu fai nga neire huuna langa yafei nomo edo uwa. No ete bona huwanya inyaba bona, ete gaude tuwonbona. No ete nomo beele isi bona, ete moge tuwonbona. Tere Itou nomo huuna la yafa bonade, moni nomo huuna langa fere yafei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesus no ege benou lena, “Onou waha boni ji tere letigini, tere tebere yafou waha bonade ninatege isi bonade, benou adai lewagu, ‘Ere taate nyoya yo? Ere yaage adoha nyoya yo?’ Ono bonade tere tebere getege gala bonade ninatege baingaro isi bonade benou adai lewagu, ‘Ere ogola adeha taguwoya?’ Agege auma no da feiya tuwou rute, onodu geege gala no ogola dada feiya nigou rute. ");
INSERT INTO eri_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tere neei nerigagu. Nere da ada tau-taude, ono bode nere elege komomudu bode higina langa ada logosi-logoside. Onou wa, tere tebere Ametege no ha laluwa langa yafana waha, no nere da nigi-nigina. Tere neei feiyade nigegu uwa rute. ");
INSERT INTO eri_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Onou wa, tebereha ete no hilou yafei nomo jala bona ninau baingaro isina, isou baingaro tena waha, no nomo ago auma yafou saini menenga turi fuwona rute? Uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Onou wa, tere taate boya kolos dada boya ninatege baingaro isiya? Tere nere kooko haga langa adadu heigede waha nerigagu. Nere ababiwou uwau. Nere ogola ada ati-atide. ");
INSERT INTO eri_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Onou wa, ji tere letigini, Amina King Solomon no mujari oruwanga hilou-hilou tanigai, onou wa kooko waha nomo mujari hilobainga no Solomon nomo mujari feiya tuwou. ");
INSERT INTO eri_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Elebe nere jigu waha kejiwe otode, iranga la fai nere jigu agidu bode, eeya langa ayaru wodbode. Onodu jigu ewe benou waha, Itou no mujari tutuna. Onou waha bona, tere fai-aita bagu huwanyatege ngalengawou menakele waha, tere tigini benou isagu, Itou no tere fere mujari tigonbona. ");
INSERT INTO eri_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tere ninatege baingaro isi bonade benou adai lewagu, ‘Ere taate dada nyoya yo? Ere yaage nyomole adoha nyoya yo?’ Uwa. ");
INSERT INTO eri_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nere haiden fai aooso bode dada waha oruwa kurudu golo‑golode. Onou wa, tebere Ametege ha laluwa langa yafana waha no amina isaha, tere dada waha oruwanga elegagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Waha bona tere ngasunga dada ono wagu ganga wa onou. Tere Itou awa tuwadenga tebere king yafona, onodu nomo fanyimu tigini waha taagu. Ono wadenga no dada ila waha fere oruwanga tere tigonbona. ");
INSERT INTO eri_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Onou waha bona, tere ira bonade ninatege inyanga adai isagu. Fati ira wa nogo nomo dada bona ninau isona bona. Fati etenga nomo ou no fati wahanga la usu wonbona.” ");
INSERT INTO eri_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesus no ege benou lena, “Tere ila nebere fanyinege adai haawe nagi bonade, nere fai inyabawou lewagu. Gamaji Itou no tere fere onounga ono tigoga. ");
INSERT INTO eri_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tere fai ila ono nigiya onou fenga, Itou no tebere onowou haawe tagonbona. Tere fai ila haawe nigi-nigiya, haawe wahanga la Itou no agou tigonbona. ");
INSERT INTO eri_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne taate boni name baine nomo ago magana langa, tuturumu menakele mene inyi ganga ure funaha, onou wa ne nage name agene magana langa, falanga anyakaro inyina waha boni ne ninate isei uwa yo? ");
INSERT INTO eri_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Onou wa, ne nage agene la falanga inyina wonga, name baine adadu letuwau ganga, ‘Baabo, ji tuturumu agene la inyina waha te kaite hanoni boni?’ ");
INSERT INTO eri_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ne yaawa wou fai, ne amugedu bonahe ne nage name agene magana langa falanga anyakaro inyina waha te kaitau. Onodu iinga gonga, ne edo feelede bonahe name baine nomo ago magana langa tuturumu waha te kaite fuwau. ");
INSERT INTO eri_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tere dada Itou hangada fuwou waha elegedu gauna adai nigagu, gamaji nere ubuludu maasi tigoguga. Ono bonade tebere kililoi hilou-hilou waha buuwa adai ayaru nagagu, gamaji nere afenege langa ilei woguga.” ");
INSERT INTO eri_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesus no ege benou lena, “Tere hauya bonade Itou dada tigei nomo isoki tuwadenga no tigonbona. Tere dada kuruwou haruwe te bonade tere uragu ganga. Tere jauli arasai katokato bonade, Itou no helufa tagonbona. ");
INSERT INTO eri_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nere fai oruwanga Itou hauya tude waha nere dada elege-elegede. Fai no dada kuru wou haruwe te-tena waha no dada ure-urena. Fai no jauli arasai katokato wonga, Itou no jauli helufa fuwonbona. ");
INSERT INTO eri_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Onou wa, tebereha magana ete nomo umamu beret bona isoki tuwonga, umamu megebu ete tuwona yo? Uwa. ");
INSERT INTO eri_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onodu magana no umamu hoowe tuwei nomo bona letuwei mata wonga, umamu no maangi inyaba ete tuwona rute? Waha fere uwa. ");
INSERT INTO eri_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tere amenege gane onowou inyaba baingaro ono onoya, onou wa tere idatege gane dada hilou-hilou nigei nomo isi deya. Onou waha bona tere isi dewagu, Ametege ha laluwa langa yafana waha, fai nere hauya tuwogunga dada hilobainga nigei nomo edega wonbona. ");
INSERT INTO eri_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Fanyimu oruwanga fai-aita bagu ila ono tigei nomo gauya waha, fanyimu wahanga tere fere ono nigagu. Beha waha nuuni beele nomo hugu, onodu profet nebere beele hugu.” ");
INSERT INTO eri_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesus no ege benou lena, jauli arasai menakale la goyagu. Yaaewei nomo haumu no anyakaro. Onodu jala haumu waha langa goyei nomo no gai budaro, onodu goyei nomo wa foinga. Nere fai-aita baingaro jala waha ojo-ojoyede. ");
INSERT INTO eri_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Onou wa, jauli arasai agege auma yafou tei nomo oojodu goyou wa gai menakele, onodu jala haumu waha langa oojodu goyei nomo darau. Fai-aita bagu etenga-etenga nere jala waha uredu oojo-oojode. ");
INSERT INTO eri_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesus no ege benou lena, “Tere yaawa profet bonade ure dewagu. Nere beele hilobainga la gelele tigi-tigide. Onou wa, nebere ninanege tigini no hilalamu tigidu inyabamu tigodbode. Nere gauna kui sipsip osoko tanide dorofe, nere edo sipsip hinenege goidu dobole nigodbode. ");
INSERT INTO eri_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tere nebere onowou uredu isagu ganga, nere yaawa profet yo, uwa. Adadu? Nere fai wain fatu maalu kudina bagu langa elege-elegede rute? Nere fai fik nauge nomo fatu, jiigu olelege bagu langa elege-elegede rute? Gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Onounga, nauge hilou-hilou oruwanga nere hilou hilobainga heige-heigede. Ono ganenga, nauge inyaba no hilou inyaba heige-heigena. ");
INSERT INTO eri_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nauge hilou no hilou inyaba heigei nomo edo uwa. Ono gonga, nauge inyaba no hilou hilobainga heigei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nere nauge oruwanga hilou hilobainga ada heige heigede waha, nere lalatidu eeya langa ayaru-ayarude. ");
INSERT INTO eri_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Onou waha bona, tere yaawa profet nere nage nebere onowou langa edo isi nigagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tere ninatege benou adai isagu, nere fai-aita bagu oruwanga, ‘Anyakaro, Anyakaro’, hide waha, nere ha laluwa nomo huuna langa yafou waha langa goyodbode. Uwa. Fai no yame Jijei no ha laluwa langa yafana waha nomo gauwou oojona, wahanga no yafou waha huwanya la goyonbona. ");
INSERT INTO eri_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Itou nomo kot fati anyakaro langa, fai-aita bagu baingaro nere benou lehiyodbode, ‘Anyakaro, Anyakaro, ere ne unyite langa profet haruwe tei. Ne unyite langa ere hauri inyaba so nigeye. Ne unyite langa ere dodokawou baingaro tafeye.’ ");
INSERT INTO eri_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ono wogunga saini waha langa ji nere beele benou malalamudu lenigon boni, ‘Ji tere boni menenga ada isini. Tere une tafagou fai, tere hina hayagu.’” ");
INSERT INTO eri_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesus no ege benou lena, “Ariya, fai no yame beele beha isidu bona oojona waha, no fai ete ninau hilobainga bagu, onodu no nomo mata megebu jaula langa tafana dorofe. ");
INSERT INTO eri_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yaage medu bona kuwei guriyena, ono ganga jagui danga bagu jaina, onodu nere dada waha mata nuu tude. Ariya mata waha ililiwei uwa, taate bona, mata waha nomo simen no minidu, megebu aroaro oula gamu langa otode waha bagu fada dewou. ");
INSERT INTO eri_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ariya fai no yame beele beha isidu bona ada oojona waha, no fai dabu tayou ete dorofe no mata ewe ulisi ouwe langa tafana. ");
INSERT INTO eri_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ono wainga yaage medu bona kuwei guriye bona, jagui danga bagu jayai. Nere dada waha mata nuu tuwanenga, mata waha ililidu, no gai mebodu dewai.” ");
INSERT INTO eri_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus no beele waha malalamudu le boro wainga, nere fai-aita bagu toomaro nomo isisiwou waha bode danga bagu horoto wane. ");
INSERT INTO eri_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Wa taate bona, no isisiwou nigai wa, nere nuuni beele nomo isou fai dorofe uwa. No isisiwou nigai wa fai unyi bagu dorofe. ");
INSERT INTO eri_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus no muju awadu heigedu mini gainga, fai-aita bagu toomaro no oojo tudu minane. ");
INSERT INTO eri_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ono ganenga fai ete no lepra taura bagu waha no Yesus bagu maidu bona, afo tuburu kutudu benou letuwai, “Anyakaro, ne gau hinei mata wonga, ji yame lepra taura jigemu hayahenga, ji Itou ago langa eege heigoni.” ");
INSERT INTO eri_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ono wainga Yesus no fai waha la owo tafa bona letuwai, “Ji gau hina. Ne eege heigau.” Ono wainga fasayadu onou, nomo lepra taura usu wainga no eege heigai. ");
INSERT INTO eri_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ono wainga Yesus no letuwai, “Ure dewau. Ne fai ete dada ne langa heigaha waha adai letuwau. Ne goidu bonahe gete gala pris abitimu nigi bonahe, ne toota amina Moses no lewai onou onowau. Ono wahenga fai nere name taura usu hinaha waha edo isodbode.” ");
INSERT INTO eri_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus no Kaperneam matane huwanya goi gainga, Romha 100 oota fai nebere kepten ete maidu Yesus danga bagu benou isoki tuwai, ");
INSERT INTO eri_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Anyakaro, yame haruwe magana ete taura tuwaha mata langa inyina, no gogala oruwa dalege borowaha, gogala jimiri anyakaro tuna.” ");
INSERT INTO eri_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ono wainga Yesus letuwai, “Ji goidu figini tuwehenga hilou heigon bona.” ");
INSERT INTO eri_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Onou wa kepten no gidu benou letuwai, “Anyakaro, ne yame mata langa mayei nomo ji fai hilou uwa. Ne ewe lewahenga, yame haruwe magana nomo taura jige tuwona. ");
INSERT INTO eri_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ji benou leni, wa taate boni, ji fere nere fai unyinege bagu waha nebere huuna langa yafa genenga nere ji oofa hihide. Ariya ji yage yame oota fai nere yame huuna langa yafade. Onou wa ji ete le tuwon boni, ‘Ne goyau,’ ono genenga no goi-goina. Ji ete letuwoni, ‘Ne mayau,’ ariya no maimaina. Saini ji yame haruwe magana letuwoni, ‘Ne haruwe beha tau,’ ono genenga no haruwe waha tetena.” ");
INSERT INTO eri_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus beele waha isidu bona horoto wai. Onodu nere fai oojo tuwane waha lenigai, “Ji ngalenga letigini, ji amina fai ete tere Israel gamanege langa fai beha nomo huwanya ngalengawou dorofe ete urei uwa. ");
INSERT INTO eri_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Ariya ji tere letigini, fai-aita bagu baingaro nebere kantri hoonga mayou la, hoonga minou la awadu mai Abraham wonga Isak wonga Jekop wonga ha laluwa nomo huuna la gaara da nyou la yafodbode. ");
INSERT INTO eri_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ariya nere fai-aita amina Itou no nomo huuna la yafei nomo hangada nigai wa, Itou no nere so nigonga ha agugula goyodbode. Haumu waha langa merou anyakaro bagu manege gidodo wodbode.” ");
INSERT INTO eri_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ariya Yesus no kepten waha benou letuwai, “Elebe ne goyau. Ne huwanyate ngalenga na onounga, dada edo ne la heigon bona.” Saini waha langa tigini, kepten nomo haruwe magana ege jigi tuwai. ");
INSERT INTO eri_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ariya Yesus no Pita nomo mata huwanya langa goidu bona, Pita oya nomo anya no kabali langa inyi gainga urai, taate bona no taura tubona gogala ngasu wai. ");
INSERT INTO eri_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ono wainga Yesus no nomo owo yaasu fuwainga, taura usu tuwai. Ono wainga no jaidu bona Yesus nomo da haiya fuwai. ");
INSERT INTO eri_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ariya esuwa nere fai-aita toomaro, hauri inyaba nere la inyane waha, hanigedu Yesus bagu mayane. Ono wanenga Yesus no lewainga nere hauri inyaba waha fai-aita bagu awa nigidu bode heige hara wane. Onodu no fai-aita bagu oruwanga nebere taura jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Onodu onowou waha langa, Itou no nomo beele Aisaia hurau langa heigemu wai waha edomu wai. No benou lewai, “No nogo we, ere ebere taura hogo fere-fere elegedu bona so nigainga hara wane.” ");
INSERT INTO eri_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus no fai-aita bagu toomaro kolili tudu oto ganenga nerigedu bona, nomo disaipel benou lenigai, “Ere yaage katiwou ulate langa goyoya.” ");
INSERT INTO eri_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ono wainga nuuni beele nomo isou fai ete maidu bona Yesus benou letuwai, “Isisiwou fai, matane oruwa la goyau wa, ji oojo hinidu goyon boni.” ");
INSERT INTO eri_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ono wainga Yesus no benou letuwai, “Gauna kui nere oula langa nebere u-u bagu, neei nere fere nebere toomu bagu. Ariya Fai Nomo Idau no agore inyei nomo haumu uwau.” ");
INSERT INTO eri_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Onodu fai ete no Yesus nomo disaipel ete, no Yesus benou letuwai, “Fai Anyakaro, ne awa hiyahenga ji goidu yame jijei u-u kurudu.” ");
INSERT INTO eri_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ono wainga Yesus no benou letuwai, “Buyona. Nere fai umeru wane waha, nere edo nere nage u-u kuru guru wode. Ne maidu ji oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ariya Yesus no bot digainga, nomo disaipel oojo tuwane. ");
INSERT INTO eri_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nere yaage kati wou gama langa goi bode, Yesus no agore inyai. Ono gainga jagui danga bagu jaidu bona hiiri bot kutau wona onowai. ");
INSERT INTO eri_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ono gainga nomo disaipel goidu aimu tubode letuwane, “Anyakaro, hoyo higau. Ere amina yai woya onoya.” ");
INSERT INTO eri_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ono wanenga Yesus lenigai, “Tere taate boya umugeya? Tebere huwanyatege ngalengawou gai menakele mene.” Onodu bona, no jaidu jagui hiiri ngare honggoro nirainga wanga nini helewai. ");
INSERT INTO eri_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ono wainga nere ninanege baingaro isidu bode lewane, “Taate fai benou, jagui yaage ngare nomo beele isare?” ");
INSERT INTO eri_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesus no Galili yaage katiwou ulate langa goi heigai, Gadara nebere oula langa. Ono wainga, fai nga nononga hauri inyaba bagu maidu toroba tuware. Nere haumu matmat langa onou yafadu bodere mai heigare. Nere gai kui deware, onou waha bona, nere fai-aita bagu jala waha langa golowei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ariya, nere danga bagu benou yaurare, “Ne Itou nomo Idau, ne ere adadu ono higau ganga? Iinga saini wei uwa, ne ere inyabamu higau ganga belanga mainaha yo?” ");
INSERT INTO eri_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Buuwa toomaro menanga baae langa da nyi bode oto waneha. ");
INSERT INTO eri_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ono ganenga hauri inyaba nere Yesus danga bagu benou yauredu letuwane. “Ne ere so higei mata bonahe wonga wa, ne ere awa higahenga, buuwa toomaro woha huwanyanege langa goyoya.” ");
INSERT INTO eri_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ono wanenga Yesus no lenigai, “Tere goyagu.” Ono wainga nere hauri inyaba, fai nga waha awa niridu bode, nere buuwa waha huwanyanege langa goyane. Ono wanenga buuwa waha oruwanga danga bagu gurarudu bode, ha inyaba ete langa minane. Onodu bode, nere yaage katiwou langa me taumerudu bode, yaage nyidu umeru waneha. ");
INSERT INTO eri_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nere buuwa oofa nigi gou fai waha uredu bode, nere heige hara wane. Nere goi taon langa heigedu bode, fai-aita bagu dada heigai waha lenigane. Onodu nere dada fai nga nononga hauri inyaba bagu langa heigai waha hai nagane. ");
INSERT INTO eri_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ono wanenga, nere taonha fai-aita bagu oruwanga Yesus bagu mayane. Onodu saini nere mai uredu bode, no nebere oula awadu ha fere langa goyei nomo bode beele danga bagu letuwane. ");
INSERT INTO eri_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus bot ete langa digedu bona yaage katiwou ulate la gidu, nomo matane hugu langa goyai. ");
INSERT INTO eri_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wa langa nere taura fai ete ngedemu oruwa ume borowou, kabali la inyi gainga auledu no bagu mayane. Ono wanenga Yesus no nerigai wa, nere huwanyanege ngalenga dewai, onodu bona no taura fai waha letuwai, magana, name huwanyate edo foinga inyona. Ji name une amina uulu boro haninaha. ");
INSERT INTO eri_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ono wainga nere nuuni beele nomo isou fai ila, Yesus nomo beele waha isidu bode, nere nage-nage benou leguruwane, “Fai beha no Itou nomo haumu taha.” ");
INSERT INTO eri_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ariya Yesus no nebere ninanege waha amina isidu bona lenigai, “Tere taate boya tebere huwanyatege la isou inyaba beha bagu? ");
INSERT INTO eri_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Beele adoha waha ji lewei nomo foinga? ‘Ji name une uulu hanini yo,’ uwa, Ji benou le woni wa edo rute, ‘Ne jaidu golo wau?’ ");
INSERT INTO eri_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ariya tere benou isagu ganga bona gau hina, Fai Nomo Idau no oula belanga danga bagu, no une uuluwei nomo edo.” Yesus no beele leborodu bona, igei wainga fai ngedemu ume borowai la goyai, onodu benou letuwai, “Ne jaidu name udu elegedu bonahe, name mata langa goyau.” ");
INSERT INTO eri_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ono wainga fai waha no jaidu bona nomo mata langa goyai. ");
INSERT INTO eri_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nere fai-aita bagu waha uredu bode umugane. Onodu bode nere Itou unyi isou wane, taate bona, no nere unyinege anyakaro bagu, danga bagu nigai. ");
INSERT INTO eri_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus no golodu goi bona, fai ete unyi Matiu, moni takis tegou matala yafa gainga urai. Onodu bona benou letuwai, “Ne jaidu bonahe taga hiyau.” Ono wainga Matiu jaidu bona, Yesus taga tuwai. ");
INSERT INTO eri_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Saini Yesus no mata la yafadu da nyi gainga, nere moni takis tegou fai bagu, nere une fai bagu baingaro mayane. Onodu nere Yesus nomo disaipel bagu gaara yafabode da nyane. ");
INSERT INTO eri_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ono wanenga, Farisi nere waha uredu bode, Yesus nomo disaipel isoki nigane, “Taate bona tebere isisiwou fai no takis tegou fai bagu, nere une fai bagu da nyi nyina?” ");
INSERT INTO eri_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus no beele waha isidu bona benou lewai, “Nere fai taura uwau waha dokta bagu ada goigoide. Uwa. Nere taura fai wahanga dokta bagu goigoide. ");
INSERT INTO eri_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tere goidu beele Itou nomo buk langa inyina waha langa isou taagu, tere eeya muru ewe wariya waha ji gaude hiyei uwa. ‘Tere ila hilou tafa nigei nomo boni gaude hina.’ ” Onodu Yesus no ege benou lewai, “Ji nere fai tigini waha yaure nigei nomo boni mayei uwa. Ji nere fai une tafade waha yaure nigei nomo boni mene.” ");
INSERT INTO eri_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Saini waha langa nere Jon nomo disaipel Yesus bagu maidu benou isoki tuwane, “Adadu bona ere Farisi bagu da urige urigeya, Ariya name disaipel nere nu da ada urige urigede?” ");
INSERT INTO eri_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ono wanenga Yesus no benou lenigai, “Fai ete no aita tonbona wonga, saini no ilibumu gane bagu yafa gonga, nere no bode huwanyanege ou wona rute? Uwa. Iinga nere fai waha haudu goyode la Sain waha lange no ilibumu gane bagu yafei uwa la, nere da urigodbode. ");
INSERT INTO eri_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Fai ete no ogola majigau eege ete teedu bona, saket asari koraiwou nomo yogodo ada erere-ererena. No onou onowei mata wona wa, saini nere saket waha huge gogunga ogola majigau eege waha no kojijidu goi menakele bona saket ege korai wonga, yogodo koraiwou anyakaro heigon bona. ");
INSERT INTO eri_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Onodu fai ete no wain yaage eege waha meme nomo osoko asari langa ada lolobo-lolobona. Nere onou onowei mata wode wa, meme osoko korai wonga wain yaage oula langa feu wonbona, ono wonga meme osoko fere inyaba wonbona. Onou waha bona nere wain yaage eege waha nere meme osoko eege langa lolobo lolobode. Ono ganenga nere ngadu hilobainga inyi-inyidere.” ");
INSERT INTO eri_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus no Jon nomo disaipel beele lenigi gainga, mora bagu ete maidu Yesus afo hugu la afo tuburu kutudu yafa bona letuwai, “Yame magana aita gai iingabe umaha. Onou wa, ne maidu no la owone tafahenga, no ege ago morawona.” ");
INSERT INTO eri_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ono wainga Yesus no jaidu bona oojo tudu goi gainga, nomo disaipel taga tuwane. ");
INSERT INTO eri_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ariya aita ete yafa gai, no saini oruwa ole taura bagu yafa gainga haga orei 12-onou goyai. Aita waha no Yesus mogola golodu hinemu la mayai, onodu no Yesus nomo kolos ufaro mutu yaasu wai. ");
INSERT INTO eri_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aita waha no nogo-nogo benou lewai, “Ji ewe nomo kolos langa owofe tafoni fere, ji ege jigi hiyonbona.” ");
INSERT INTO eri_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ono wainga Yesus no ubuludu aita waha urai. Onodu bona letuwai, “Yame magana aita, name huwanyate edo foinga inyona. Ne ji boni huwanyate ngalenga waha bona, ne ege hilou heigenaha.” Onou letugainga, saini wahanga la aita wa hilou wai. ");
INSERT INTO eri_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ariya Yesus no mora bagu waha nomo mata langa goi heigedu nere fai-aita bagu mere ganenga nerigai. Nere fai boreya bu gane, fai-aita bagu nere inyangaaro gududu wane. ");
INSERT INTO eri_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ono wanenga Yesus lenigai, “Tere heige hara wagu, Aita magana no umei uwa. No ewe agore inyina.” Ono wainga nere oruwa nanai tuwane. ");
INSERT INTO eri_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ono ganenga nere fai-aita bagu so niganenga malala goyane, ariya Yesus no gamu goidu bona aita magana waha owo yaasu wainga, no jayai. ");
INSERT INTO eri_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Onodu Yesus dada onowai waha nomo beele goidu distrik nomo ha-ha oruwa langa edo wai. ");
INSERT INTO eri_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus no matane waha awadu bona golodu goyai. Ono gainga fai nga agenere magana fosokowou no oojo tubodere benou yaurare, “Ne Devit nomo Idau, ne ere bonahe augami hinou.” ");
INSERT INTO eri_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","No mata huwanya langa goyainga, nere fai nga agenere magana fosokowou waha, no bagu mayare. Ono warenga, Yesus no nere benou isoki nirai, “Tere ji dada waha onowei nomo huwanyatere ngalenga na, yo?” Ono wainga nere letuware, “Yoo, Anyakaro. Ere huwanyare ngalenga na.” ");
INSERT INTO eri_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ono warenga, no owo nere nga agenere langa tafadu bona benou lewai, “Tere ji boyare huwanyatere ngalenga na. Onou bona, dada waha edo tere langa heigon bona.” ");
INSERT INTO eri_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ono wainga, nere neire agenere magana foko wai waha igei ware. Ono wainga Yesus no nere beele danga bagu benou lenirai, “Tere fai ete te adai letuwaderenga, dada tere langa heigaha beha isona.” ");
INSERT INTO eri_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Onowai wa, nere goidu bodere distrik ulate walaha oruwa fai-aita bagu Yesus no haruwe hilobainga tena waha nomo fanyimu hai nagane. ");
INSERT INTO eri_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Saini nere fai nga waha Yesus awa tudu goi garenga, nere fai-aita bagu fai ete hurau fosokowou, hauri inyaba no langa inyai waha haudu Yesus bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ono wanenga, Yesus no hauri inyaba so tuwainga hurau fosokowou waha no beele hayai. Ono wainga nere fai-aita bagu ninanege baingaro isidu bode nere lewane, “Amina kantri Israel langa dada benoha ete heigei uwa.” ");
INSERT INTO eri_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ono wane wa, Farisi nere lewane, “No hauri inyaba so nigina waha, no hauri inyaba nebere mora bagu nomo danga langa so nigi-nigina.” ");
INSERT INTO eri_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus no goidu matane bagu taon oruwanga la golowai. No fai-aita bagu nebere bori mata langa isisiwou nigai. No Itou nomo huuna langa yafei nomo hilou beele malalamudu lebona, nere taura hogo fere-fere oruwanga genege gala langa inyai waha jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","No fai-aita toomaro waha nerigedu bona augamide tuwai, wa taate bona, nere ninanege hilala dewainga nere tigini inyaba dedu yafane, nere sipsip nebere oofa nigou fai uwau dorofe. ");
INSERT INTO eri_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ono wanenga no nomo disaipel benou lenigai, “Haga langa da gai baingaro muumu waha, onou wa, elegei nomo haruwe fai bainga uwa. ");
INSERT INTO eri_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Onou waha bona tere haga umamu hauya tuwadenga, nomo haruwe fai huuru nigonga goidu bode, da komomu fuwod bode.” ");
INSERT INTO eri_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus no nomo disaipel 12 yaure nigainga mayanenga, nere hauri inyaba fai-aita bagu langa jiride waha so nigei nomo bagu fai-aita taura hogo fere-fere bagu oruwanga jigemu nigei nomo bona danga nigai. ");
INSERT INTO eri_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ariya nere aposel 12 nebere unyinege benou. Amugou wa Saimon, nomo unyi ete Pita. Ariya nomo bemu ete unyi Andru. Sebedi idau gane nga nononga, Jems, Jon ngare. ");
INSERT INTO eri_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip wainga Batolomyu wainga Tomas wainga Matyu, no takis tegou fai. Onodu Jems, no Alfius idau, onodu Tadius ");
INSERT INTO eri_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","onodu Saimon, no Selot nebereha ete, onodu Judas Iskariot, fai no waha iinga Yesus inyabamu tuwei nomo fai owonege langa tafa tuwai. ");
INSERT INTO eri_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus no fai 12 waha huuru nigainga goi ganen no beele benou lenigai, “Tere fai fereha langa adai goyagu. Ono bonade tere Samaria nebere taon huwanya langa adai goyagu. ");
INSERT INTO eri_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tere Israel nebere sipsip bagu goyagu, nere amina yai wane. ");
INSERT INTO eri_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tere goidu beele benou malalamudu lewagu, ‘Ha laluwa nomo huuna langa yafou waha amina mai jugu waha.’ ");
INSERT INTO eri_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tere goidu taura fai taura jigemu nigi bonade, nere fai umou jaimu nigi bonade, nere fai lepra bagu tiginimu nigagu. Ono bonade, nere hauri inyaba fai-aita bagu langa inyide waha so nigagu. Dada tere elegei wa, tere ewe elegei, waha nomo ejiyawou ete uwau. Onou waha bona tere fai-aita bagu ewe nigagu ganga. Tere waha nomo agou adai elegagu. ");
INSERT INTO eri_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Tere gol yo, silwa moni yo, kapa moni tebere olodo langa adai jiri wagu. ");
INSERT INTO eri_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Saini tere jala golo bonade, tere olodo adai aulagu. Onodu siot nga bagu su bagu golowou dumuga bagu adai elegedu golo wagu. Fai no haruwe tetena waha, nere no da dada tuwodbode. ");
INSERT INTO eri_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Tere taon ete yo, matane ete, huwanya langa goi bonade wonga, tere kuru dewagu ganga, matane waha nomo fai adeha no fai hilobainga onodu fai tigini. Onodu tere edo fai no waha ngate yafa gadenga goi tere matane waha awagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tere mata ete huwanya langa goi bonade wonga, tere mata waha nomo fai-aita bagu benou lenigagu, ‘Itou no edo tere hilou tafa tigonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nere mata waha nomo fai-aita bagu nere tere hatigei nomo edega bode wonga, tebere beele hilobainga waha nere langa edo inyonbona. Ariya nere tere hatigei nomo edega wegu uwa wonga, tebere beele hilobainga waha edo ege gidu taagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Fai ete no tere hatigedu nomo mata langa goyei uwa wonga, onodu no tebere beele isei uwa wonga, wa tere mata yo taon waha awagu ganga ono bonade, tere tebere afetege amuji utu wagu. ");
INSERT INTO eri_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ji tere ngalenga letigini, fati Itou no fai-aita bagu kot langa tafa nigei nomo hangada wai langa, ou fai-aita bagu taon beha nomo la heigona wa, ou Sodom Gomora bagu langa heigai waha gai feiya tuwou heigon bona.” ");
INSERT INTO eri_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesus no ege onou lena, “Isagu. Ji tere sipsip dorofe huuru tigi genenga nere gauna kui gamanege langa goiya. Onou waha bona tere maangi nebere onowou oojo wagu, ono bonade tere dada ono wagu ganga waha bonade ninatege amugedu isidedu. Tere neei ete buuna ide, nebere onowou oojo wagu, tere onowou inyaba ete onowei nomo bonade ninatege adai isagu. ");
INSERT INTO eri_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tere fai bonade oofade wagu. Nere nebere kaunsel langa tere kot langa tafa tigodbode, ono bode nere nebere bori mata huwanya langa tere gulati tigodbode. ");
INSERT INTO eri_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nere ji ilei hiyei nomo ninanege isi bode, nere tere hatigedu gabman king bagu langa heigod bode. Onou waha bona tere edo fai-aroro waha hilou beele malalamudu lenigagu, onodu nere haiden ila fere. ");
INSERT INTO eri_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Saini nere hatigedu bode kot langa mani bode wonga, tere adai umugedu isagu, ‘Ere taate beele lewoya? Ere beele adoha gidu lewoya?’ Uwa. Saini waha langa tigini Itou no tere beele tigini malalamudu lewei nomo waha abitimu tigonbona. ");
INSERT INTO eri_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Taate bona, tere tage we beele malalamudu ada lewagu ganga. Uwa. Tere tebere Ametege nomo Hauri we, tere huratege langa beele malalamudu lewon bona. ");
INSERT INTO eri_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Fai no nomo bemu kot langa tafa tudu, nomo bemu dukote wogunga umei nomo bona lenigon bona. Onodu nere amenege gane fere idanege gane onounga ono nigodbode. Ono gonga magana nere, nebere amenege anyanege gane honggoro nigi bode, fai ila nere dunege kotewei nomo bode lenigod bode. ");
INSERT INTO eri_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nere fai oruwanga tere bode huwanyanege inyaba dewod bode, taate bona, yame unyife no tere langa inyina. Onou wa, fai-aita bagu nere danga bagu yafa gogunga goi fati usuwou la edo wonga, Itou no ege gidu hanigon bona. ");
INSERT INTO eri_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Onou wa nere fai-aita bagu taon eteha, tere inyabamu tigei mata wonga wa, tere haradu bonade taon ete langa goyagu. Ji tere ngalenga letigini, Tere Israel nebere taon oruwa langa haruwe usumu wegu uwau inyi gonga, Fai Nomo Idau mayonbona. ");
INSERT INTO eri_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ariya sukul magana no, nomo isisiwou fai feiya tuwou uwa, Onounga, haruwe magana no nomo hoobu fai feiya tuwou uwa. ");
INSERT INTO eri_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Onou wa, sukul magana no nomo isisi tugou fai dorofenga heige bona wonga, wa edo. Haruwe magana no nomo hoobu fai dorofenga heige bona wonga fere, wa fere edonga. Ariya nere mata morou unyi Belsebul tuwane, onou waha bona ere isiya, nere nomo gane unyinege gai inyaba waha nigodbode.” ");
INSERT INTO eri_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesus no ege benou lena, “Fai nere tere inyabamu tigode onode waha, adai umuge nigagu. Dada oruwanga kutau wou inyina waha, malala heigod bode. Huwari beele oruwanga fai isodbode. ");
INSERT INTO eri_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Beele ji oru langa letigini waha, tere hoonga la malalamudu lewagu. Beele ji yayaji la letigini waha, tere mata tu ouwe la oto bonade, fai-aita bagu malalamudu lenigagu. ");
INSERT INTO eri_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tere, fai geege gala dukote wode onode waha adai umuge nigagu, onou wa tere tebere hauri ada dukote wode. Tere Itou nogonga umuge tuwagu. No edola ere geege gala anuge bagu, eeya ha langa inyabamu wonbona. ");
INSERT INTO eri_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Tere isiya, nere fai neei mene-mene nga nononga 10 toya langa ejiya-ejiyade. Onodu Ametege no neei waha oofa dedena. No awa bona wonga, nebereha ete oula langa meboduwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onodu tere moratege langa Itou no tawatege gala lelege borowai inyina, onodu no tere bona tigini isi dena. ");
INSERT INTO eri_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Onou waha bona tere adai umugagu, Tere neei mene-mene baingaro feiya nigeye.” ");
INSERT INTO eri_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ariya Yesus no ege onou lena, “Fai ete no fai-aita bagu benou lenigi-nigina, no ji yame fai yafana. Ji fere ji yame Jijei ha laluwa langa benou letuwon boni, fai beha no ji yame. ");
INSERT INTO eri_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ariya fai waha no fai-aita bagu benou lenigai fai waha no yame uwa, ji fere onounga ji yame Jijei ha laluwa langa letuwon boni, fai no waha ji yame uwa.” ");
INSERT INTO eri_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesus no ege onou lena, “Tere, ji oula langa oota oruwa usumuwei nomo maihawou adai isagu. Ji oota usumuwei nomo mei uwa. Ji oota kesebu temeneha. ");
INSERT INTO eri_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ji honggoro guruwou fanyimu heigemuwei nomo mene. Fai no nomo umamu honggoro guruwou langa tafa tugonga, aita magana no anya honggoro guruwou langa tafa tugonga, aita fai bagu no au nomo anya honggoro guruwou langa tafa tuwonbona. ");
INSERT INTO eri_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Fai no nomo ilibumu gane nage wanga nomo honggoro fai heigod bode. ");
INSERT INTO eri_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Fai no umamu yo anya yo gaude tubona, ji bona inyangaaro gaude tuwei uwa wonga, no ji yame ilibafe yafei nomo edo uwa. Onodu fai no nomo fai magana yo mago yo gaude tubona ji bona inyangaaro gaude tuwei uwa wonga, no ji yame ilibafe yafei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Onodu fai no nomo nauge abalakawou auledu ji ada oojo hina waha, no yame ilibafe ada yafona. ");
INSERT INTO eri_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Onodu fai no nogo nomo yafou hilobainga heigemuni wou isi bona wonga, nomo ago auma yafou yaae wonbona. Onou wa, fai no ji bona isidu nomo hilou yafou awa bona wonga, no ago auma yafou tigini tonbona.” ");
INSERT INTO eri_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesus no ege onou lena, “Fai no tere hatigedu figini tigina waha, no ji haifedu bona figini hina. Onodu fai no ji haifena waha, no Itou hauna, no ji huuru hiyainga meene. ");
INSERT INTO eri_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Fai ete no ninau isona, ‘Ji profet hoyo tuwoni boni,’ onodu bona no profet ete haudu mata langa maidu oofa tuwona wa, dada hilou-hilou profet nere elege elegede onounga Itou no fai waha tuwonbona. Onodu Fai no ninau isona, ‘Ji fai tigini waha hoyo tuwoni boni,’ onodu no fai tigini waha haudu mata langa oofa tuwona wa, dada hilou-hilou fai tigini waha elege elegede onounga fai waha no tonbona. ");
INSERT INTO eri_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ariya fai no ninau isona, ‘Ji Yesus nomo disaipel hoyo tuwoni boni,’ onodu yaage oto kap bagunga fai-aita bagu gamanege langa fai ewe ete no yame disaipel ilibumu tuwon bona, ariya ji ngalenga letigini, fai waha nomo agou ada uwa wona.” ");
INSERT INTO eri_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus no beele beha malalamudu lenigai borodu no nomo disaipel 12 isisiwou nigai ariya no matane waha awadu haumu waha nomo taonha fai-aita bagu isisiwou nigi bona Itou nomo beele malalamudu lenigai. ");
INSERT INTO eri_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon no dagou mata la yafa bona, Kristus no haruwe oruwa tena waha beele isidu bona, no nomo disaipel huuru nigainga Yesus bagu goyane. No disaipel ");
INSERT INTO eri_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yesus benou isoki tuwei nomo lenigai, “Ne fai beha Itou huuru hinei nomo beele agili mala karuwai yo, uwa ere edo ete itari tuwoya yo?” ");
INSERT INTO eri_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ono wanenga Yesus no ege gidu lenigai, “Tere goidu taate dada tere ureyaha, isiyaha waha Jon hai fuwagu. ");
INSERT INTO eri_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nere fai agenege fosokowou ege igeide, nere afenege inyaba wa ege golode. Nere fai genege gala lepra taura bagu waha, ege hilobainga heigede, Nere agenege kuli fosokowou wa beele iside. Nere fai umou waha ege agenege morana, onodu nere fai dadanege uwau waha hilou beele iside. ");
INSERT INTO eri_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Onodu fai nere ji yeriyedu bode huwanyanege ngalengawou ada meboduna waha, nere edo edega wode.” ");
INSERT INTO eri_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Saini Jon nomo disaipel goi borowanenga, ariya Yesus no fai-aita bagu Jon bona benou lenigai, “Saini tere haumu fai uwau langa goyei waha, tere taate uragu ganga goyei? Jagui baraku alelu gainga ureye yo? Uwa. ");
INSERT INTO eri_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tere goi taate dada ureye? Tere fai ete kolos hilou-hilou tani gainga rute uragu ganga goyei? Uwa. Fai nere kolos hilou-hilou tanide waha, nere king nebere mata langa yafa yafade. ");
INSERT INTO eri_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Onou wa tere taate boya goyei? Tere profet ete uragu ganga goyei yo? Wahanga. Ji tere letigini, profet beha no profet ila feiya nigou. ");
INSERT INTO eri_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Fai no wahanga bona Itou nomo buk langa benou lena, ‘Isagu. Ji yame beele malalamudu lewei nomo fai ete huuru tuwoni boni. No ne amuge hinidu bona goyonbona. No name jala tiginimu hanonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ji tere ngalenga letigini, Jon yaage bisemu nigigou no nere fai oruwa oula langa heigane waha feiya nigou. Onou wa fai no ha laluwa nomo huuna langa gai menakele yafana waha, no Jon feiya tuwou. ");
INSERT INTO eri_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Saini Jon yaage bisemu nigi gou beele malalamudu legai la hugu waridu mai elebe, nere warawei nomo fai danga bagu waha nere ha laluwa nomo huuna langa yafou tei nomo haruwe danga bagu taane, onodu nere warawou nomo onowou hugu fere-fere la ou baingaro tuwane. ");
INSERT INTO eri_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Onou waha bode nere profet oruwa, nuuni beele nomo buk fere, nere Itou nomo beele malalamudu leganenga goidu Jon nomo heigou saini langa edowai. ");
INSERT INTO eri_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Onou wa tere isagu ganga wonga, isagu. Itou nomo buk no onou lena, profet Elaija no tigini mayonbona, wa no Jon bona lena. ");
INSERT INTO eri_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Fai no ago kuli bagu wonga beele beha isi dewona. ");
INSERT INTO eri_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ji elebe saini beha nomo fai-aita bagu nebere fanyinege malalamudu lewoni wonga, wa ji ago tete beele adadu lewoni? Nere gaare mene-mene dorofe komowou haumu langa yafa bode gaare mene-mene ila benou yaure nigi-nigide, ");
INSERT INTO eri_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tere moone edo taagu ganga bona ere boreya buuya, ariya tere moone tei nomo awaya. Onodu ere au tarigou moone teya, ariya tere au tarige gonga merei nomo awaya.’ ” ");
INSERT INTO eri_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Onodu Yesus no ege onou lewai, “Jon no maidu bona no da inyanga nyei uwa, onodu wain nyei uwa. Ono wainga nere lewane, ‘Hauri inyaba no langa inyina.’ ");
INSERT INTO eri_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ariya Fai Nomo Idau no mayai, onodu bona no da nyi bona wain nyai, ono wainga nere lewane, ‘Uragu, no da baingaro nyi bona wain fere inyangaro nyina. No fai takis tegou bagu nere une fai bagu nebere ilibanege.’ Onou lelede, ariya Itou no nomo haruwe abitimu na wa, nomo isou no dada tigini.” ");
INSERT INTO eri_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Taon ila langa Yesus no dodokawou gai baingaro tafai, onowai wa nere huwanyanege ubulu wegu uwa. Ono wanenga saini waha langa Yesus no nere taon waha nomo fai-aita bagu honggoro nigai. ");
INSERT INTO eri_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","No lenigai, “Agetege gami, tere Korasin taonha fai-aita bagu. Agetege gami, tere Betsaida. Fai ete no taon Tair bagu Saidon bagu langa goidu tere gamatege langa dodokawou ji tafani benou tafei mata wage wa, nere Tair bagu Saidon bagu edola amina huwanyanege ubulu wagenga aau narigou kolos tanidu, nere une tafane waha abitimuwou eeya amuji langa yafage. ");
INSERT INTO eri_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Onou waha bona ji tere letigini, Itou fai-aita bagu kot la tafa nigona fati hangadawai langa, ou tere langa heigona wa ou Taia Saidon bagu langa heigai wa gai feiyade nigou. ");
INSERT INTO eri_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ariya tere Kaperneam, tere isou tigidu ha laluwa ouwe langa tamani tigode yo? Gai uwanga uwa. Tere gai esene langa fai umane nebere haumu langa minagu ganga. Ariya fai ete no taon Sodom langa minidu dodokawou ji tere gamatege langa tafene onou tafage wa, Sodom gai inyage. ");
INSERT INTO eri_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Onou wa ji tere letigini, Itou fai-aita bagu kot la tafa nigona fati hangadawai langa, ou tere langa heigona wa ou Sodom langa heigai waha gai feiya tuwou.” ");
INSERT INTO eri_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saini waha langa Yesus no benou lewai, “O Jijei, ne ha laluwa bagu oula bagu nomo Anyakaro, Ji ne hilobainga hinini, taate bona, ne dada beha fai ninanege hilou bagu isou hilou bagu huwarimu nigene, onodu ne fai magana mene-mene dorofe yafade wahanga abitimu nigene. ");
INSERT INTO eri_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo Jijei, ne name gau wounga oojodu onou ono wene.” ");
INSERT INTO eri_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Onodu Yesus no ege onou lewai, “Yame Jijei no dada oruwa ji owofe langa logosi borowai. Onodu fai ete no Idau bona ada isina. Jijei no nogonga isina. Onodu fai ete no Jijei bona ada isina. Idau no nogonga isina. Idau no nogonga fai nere Idau no nogo Umamu abitimu nigina waha, nere nagenga Jijei bode iside. ");
INSERT INTO eri_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tere fai haruwe anyakaro tedu boya ou anyakaro auleya waha, tere oruwa ji bagu mayagu, ono wadenga ji houwe tafou tigon boni. ");
INSERT INTO eri_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tere ji langa isou tedu yame beele huuna langa yafagu, tere falanga tedu nere bulmakao bonege langa tafa nagi geyenga dada kusede dorofe. Tere ji langa isou taagu, taate bona, ji nere fai foinga la ono nigi boni yage unyife esenemu-esenemuni. Onodu dada waha ou ada tigonga houwe tafagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Falanga ji tere botege langa tafani, waha aulei nomo foinga, onodu dada ji tere aulei nomo tigini waha, no ou uwau.” ");
INSERT INTO eri_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iinga, saini ete bori nomo fati la Yesus no wit haga gama la golowai. Ono gainga nomo disaipel huweli nigainga, wit fatu elegedu nyane. ");
INSERT INTO eri_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ono ganenga Farisi nere waha nerigedu bode Yesus benou letuwane, “Name disaipel fanyimu onode waha nerigau, Bori nomo fati la onou onowei nomo wa karuwou inyina.” ");
INSERT INTO eri_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ono wanenga Yesus no benou gidu lenigai, “Tere dada Devit no amina onowai waha nomo aasa lelegegu uwa rute? Saini no nomo ilibumu gane bagu huweli yafane waha boni ji leni, ");
INSERT INTO eri_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","onodu Devit no Itou nomo mata huwanya la goidu beret Itou hogo langa tafa ganenga inyi-inyina waha tainga, ilibumu gane bagu nyane. Beret waha nyei nomo karu nigou inyina. Pris nagenga nyei nomo edo. ");
INSERT INTO eri_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Onou wa tere beele beha nuuni beele nomo buk langa inyina waha fere lelegei uwa rute, wa pris nere tempel langa haruwe tetede waha, nere bori nomo fati langa edo haruwe wode rute? Nere bori fati nomo nuuni beele feiya-feiyade, onode wa nere nyabuluwou ete uwau. ");
INSERT INTO eri_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Onou waha boni ji letigini, dada beha langa inyina waha no tempel feiya tuwou. ");
INSERT INTO eri_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Onou wa tere beele beha nomo hugu Itou nomo buk langa inyina waha isi dewou wage wa, ‘Tere eeya muru ewe wariya waha ji gauwei uwa. Tere fai ila hilou tafa nigei nomo boni gaude hina,’ ariya tere fai nyabuluwou uwau waha ou langa adai tafa nigagu. ");
INSERT INTO eri_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Taate bona, Fai Nomo Idau no Bori mata nomo fati ofana.” ");
INSERT INTO eri_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus no haumu waha awadu bona goi taun ete langa heigai, onodu nebere bori mata huwanya goyai. ");
INSERT INTO eri_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ariya fai ete no owo ete umou, no walanga yafai. Fai ila nere Yesus kot langa tafa tuwodbode, waha nere no isoki tuwane, “Ere bori nomo fati langa taura fai jigemu nigei nomo edo yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ono wanenga Yesus lenigai, “Fai ete tere gama langa no sipsip ete bagu wonga, sipsip no waha bori nomo fati langa u-u ete langa mebodu bona wonga, tere isiya, fai waha no sipsip yaasudu kuse tuwonga mayonbona. ");
INSERT INTO eri_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Onou wa fai no sipsip gai feiyawou. Waha bona ere edo onowou hilou bori nomo fati langa onowei nomo.” ");
INSERT INTO eri_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Onodu bona no fai waha letuwai, “Name owone tiginimuwau.” Ono wainga no owo tiginimu wainga, nomo owo ulate dorofe ege hilou heigai. ");
INSERT INTO eri_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ono wainga Farisi nere jaidu mata awadu bode goi komodu nere Yesus dukote wogunga umei nomo jala kuru bode beele ngado wane. ");
INSERT INTO eri_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ono wane wa Yesus no Farisi nere no langa dada ono wodbode wa no isai, waha bona no taun waha awadu bona goyai. Ono gainga nere fai-aita bagu baingaro no oojo tuwane, ono wanenga nere fai-aita taura bagu waha oruwanga taura jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Onodu bona, Yesus no nomo beele fai ila adai malalamudu lenigei nomo bona karu nigai. ");
INSERT INTO eri_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Onowou waha langa, Itou no beele ete no profet Aisaia hurau langa lewai waha Yesus no edomuwai. No benou lewai, ");
INSERT INTO eri_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“No beha yame haruwe fai, ji yage hangada tuwene. Ji no gaude tuni, ji yame huwanyafe no bona edega dena. Ji yame Hauri no langa tafoni boni, Ono wehenga no onowou tigini nomo beele nere oula nomo fai-aita bagu malalamudu lenigon bona. ");
INSERT INTO eri_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","No honggorowou beele lebona bolou ada oto wonbona. No jala-jala beele legonga fai-aita bagu ada isodbode. ");
INSERT INTO eri_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Baraku danga uwau bona falusu wona onona, no tigini ada kouwona. No lama ada lala dena waha ada garemu wona. No gai buutu bona inyi gonga, no onowou gai tigini waha ono wonbona. ");
INSERT INTO eri_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Onodu fai-aita bagu fereha nere no bode huwanyanege ngalengadu itari tugogunga no hoyo nigonbona.” ");
INSERT INTO eri_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Saini waha langa fai ete hauri inyaba no langa inyi gainga haudu Yesus bagu mayane. Fai waha no ago magana hurau bagu fosokowou. Ono wanenga Yesus no jigemu tuwai, ono wainga fai waha no beele lebona ago igeiwai. ");
INSERT INTO eri_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ono wainga fai-aita bagu oruwanga horotodu lewane, “Fai beha no Devit Idau yo?” ");
INSERT INTO eri_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ono wane wa Farisi nere beele waha isidu bode lewane, “Fai no waha hauri inyaba Belsebul nomo danga langa so nigi-nigina, no hauri inyaba nebere mora bagu.” ");
INSERT INTO eri_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ono wane wa Yesus no nebere ninanege isai, onodu no benou lenigai, “Nere fai kantri etenga waha nomo nere foure ngadu wara wodere wa, ariya kantri waha no inyaba wonbona. Onou wa fai nere taun etenga nomo yo mata etenga nomo yo nere foure ngadu wara wodere wa, taun yo mata yo no danga bagu ada otowona. ");
INSERT INTO eri_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Onou dorofenga, Satan no Satan so tuwona wa, ere isoboya nomoha nere fofoura borowane. Adadu no danga bagu oto bona dada oofa wona? ");
INSERT INTO eri_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Onou wa ngalenga Belsebul no hoyo hi ganga ji hauri inyaba so nigini wonga, faiwei no tebere ilibatege gane hoyo nigidu, hauri inyaba so nigi-nigina? Onou waha bona tere tebere ilibatege gane wenga abitimu tigode, tebere beele wa tigini uwa. ");
INSERT INTO eri_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ariya Itou nomo hauri hoyo hi ganga ji nere hauri inyaba so nigini wonga wa, tere isagu ganga, Itou nomo huuna langa yafou waha tere langa amina mayaha. ");
INSERT INTO eri_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Fai ete no adadu la fai danga bagu nomo mata langa goidu bona nomo dada elegona? No ngasunga baklain langa fai danga bagu waha dagetudu bona. No onou onowei mata bona wonga, ariya no edo langa dada nomo mata langa otode waha elegon bona. ");
INSERT INTO eri_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Fai no yame ilibafe uwa waha no ji yame honggoro fai. Onodu fai no fai-aita bagu komomu nigei nomo ji hoyo hiyei uwa waha, no so nigi ganga heige hara-harade. ");
INSERT INTO eri_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Onou waha boni ji tere letigini, Itou no fai-aita oruwa nere une bagu beele inyaba lede bagu waha oruwa uulu nagon bona. Onou wa, fai no Hauri Guuni beele inyaba letuwona waha, Itou no fai waha nomo une ada uulu fuwonbona. ");
INSERT INTO eri_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Fai no Fai Nomo Idau beele inyaba letuwona wa, Itou no nomo une waha uulu fuwonbona. Ariya fai no Hauri Guuni beele inyaba letuwona waha, Itou no fai waha nomo une ada uulu fuwona elebeha goi iinga saini huunta la fere.” ");
INSERT INTO eri_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesus no ege onou lena, “Nauge hilou wonga wa, no nomo hilou fere hilobainga. Ariya nauge inyaba wonga wa, nomo hilou fere inyaba. Fai nere nomo hilou amugedu uredu bode, nere iside, nauge hilou yo uwa. ");
INSERT INTO eri_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tere fai inyaba, tere maangi inyaba dorofe. Tere adadu bonade haruwe hilou tei nomo edo? Ariya fai nomo ninau hogo ferete huwanya langa bolodu otona waha no malalamudu lena. ");
INSERT INTO eri_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Fai hilobainga no huwanya langa ninau hilobainga baingaro jiride. Onou waha bona no onowou hilobainga heigemu-heigemuna. Fai inyaba no ninau inyaba baingaro nomo huwanya langa jiride. Onou waha bona no onowou inyaba heigemu-heigemuna. ");
INSERT INTO eri_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Onou wa ji tere letigini, Itou no fai-aita bagu kot langa tafa nigonbona fati hangadawai langa, nere fai-aita bagu beele kejiwe lewane waha ninau isibona haawe nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ne name beele wenga, Itou ne fai tigini hinonbona. Onodu ne name beele wenga no ne fai inyaba hinonbona.” ");
INSERT INTO eri_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Saini waha langa nere nuuni beele isou fai ila bagu Farisi bagu nere Yesus letuwane, “Isisi higigou fai, ne Itou nomo haruwe teni waha nomo naani abitimuwou dorofe dodokawou ete tafahenga urei nomo boya gaude higina.” ");
INSERT INTO eri_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ono wanenga no beele ege gidu benou lenigai, “Saini beha nomo fai-aita bagu nere inyaba, nere Itou bode huwanyanege ada ngalengana. Saini oruwa nere naani urei nomo bode yaure-yaurede. Onode wa nere naani ete ada urode. Uwa. Naani etenga wahanga urodbode, wa profet Jona nomo naani. ");
INSERT INTO eri_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Onodu Jona no hoonga eei ooru eei hoowe anyakaro huwanya langa inyai, onounga Fai Nomo Idau no hoonga eei ooru eei oula gamu langa inyonbona. ");
INSERT INTO eri_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Saini Itou no fai-aita bagu kot la tafa nigei nomo fati hangadawai langa, nere Ninive fai kot langa oto bode elebe saini beha nomo fai-aita bagu nebere onowou inyaba malalamu nagodbode. Taate bona, Ninive nere Jona no beele malalamudu lewainga nere isidu bode, huwanyanege ubuluwai. Onou wa fai ete no tere gama langa yafana, waha no Jona feiya tuwou. ");
INSERT INTO eri_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Saini Itou no fai-aita bagu kot langa tafa nigi gonga, saotha kwin no kot langa oto bona nere fai-aita bagu saini elebe beha nomo nebere onowou inyaba malalamu nagonbona. Taate bona, kwin waha no oula gai gisa langa yafai, ono gainga Solomon no nomo isou hilobainga waha malalamudu legainga aagu tuwona mayai. Ariya fai ete no belanga yafana, no Solomon feiyade tuwou.” ");
INSERT INTO eri_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesus no ege onou lena, “Hauri inyaba no fai ete awa tuwaha wonga, no ha kara langa kejiwe goidu bona houwe tafei nomo haumu ete kuru wonbona. Onodu no haumu hilou ete ada toroba bona wonga, ");
INSERT INTO eri_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","no benou lewonbona, ‘Ono urona ji ege gidu mata amina yafene langa goyon boni.’ Onodu bona no goidu mata waha ewe inyi ganga, nere fiidu mujarimu wanenga uraha. ");
INSERT INTO eri_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Onou waha bona no goidu hauri inyaba 7 nere no onowou inyaba onowei nomo feiya tuwou waha hanigon bona. Ono wonga nere mata waha huwanya langa goidu yafodbode. Ngasunga fai waha no inyaba yafai, ariya elebe nomo yafou gai inyaba dewonbona. Onowou wahanga, nere fai-aita bagu saini beha nomo la heigonbona.” ");
INSERT INTO eri_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus no fai-aita bagu beele lenigi gainga, nomo anya bemu gane bagu maidu malala langa oto wane. Nere no bagu beele hayei nomo bode. ");
INSERT INTO eri_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ono wanenga fai ete no nerigedu bona Yesus letuwai, “Isau, name anyane baine gane bagu mayane malala arasai la otode, ne bagu beele hayei nomo bode lede.” ");
INSERT INTO eri_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ono wainga Yesus no fai waha ege gidu letuwai, “Faiwei no yame ngaai? Faiwei no yame baabo?” ");
INSERT INTO eri_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Onodu nomo disaipel owo jodu abiti nigi bona lenigai, “Nerigagu ji yame ngaai, baabo gane bagu. ");
INSERT INTO eri_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Taate bona, fai yo aita ji yame Jijei ha laluwa langa yafana waha nomo gauwou oojo-oojona wonga, no yame baabo, yame ogofe, yame ngaai.” ");
INSERT INTO eri_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Fati wahanga la, Yesus no mata awadu bona malala heigedu goyai. Onodu yaage katiwou mou langa yafai. ");
INSERT INTO eri_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ono gainga fai-aita bagu baingaro nere no bagu mayane. Ono wanenga no bot ete langa digedu bona yafa gainga, nere fai-aita bagu oruwanga laanga la oto wane. ");
INSERT INTO eri_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ono ganenga no muuji beele baingaro lenigai. No benou lenigai, “Isagu. Fai ete no wit fatu haga langa ayaruwai. ");
INSERT INTO eri_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","No ayaru bona goi ganga, wit fatu ila jala langa orososo wane. Ono wanenga nere neei medu bode nyane. ");
INSERT INTO eri_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ono ganenga wit fatu ila oula megebu bagu, onodu oula inyanga uwa waha langa orososowai. Onowai wa, oula no humutu uwa, onou waha bona no fasadu onou fuduwai. ");
INSERT INTO eri_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Onou wa, saini hoonga ouwe maibona wit waha bitonbona. Ono wonga wit bou uwau, waha bona no kakaregedu, umonbona. ");
INSERT INTO eri_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ono gainga wit fatu ila maalu kudina bagu gora langa orososowai. Ono wainga maalu kudina bagu heigedu bona kutauwai. ");
INSERT INTO eri_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ariya wit fatu ila nere oula hilou langa orososodu hilou heigai. Ila hilou 100 heigane, ila hilou 60 heigane, ila hilou 30 heigane. ");
INSERT INTO eri_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Fai no agokuli bagu wonga no beele beha isonbona.” ");
INSERT INTO eri_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iinga nere disaipel maidu Yesus benou isoki tuwane, “Ne taate boni nere fai-aita bagu beele muuji beele langa lenigini?” ");
INSERT INTO eri_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ono wanenga Yesus ege gidu lenigai, “Itou no awa tiganga tere ha laluwa nomo huuna langa yafei nomo huwari beele nomo hugu isi boroyaha. Ariya nere fai-aita bagu beha abitimu nigei uwa. ");
INSERT INTO eri_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Onou wa fai ete no dada ila bagu wonga wa, Itou no ege dada ila tuwon bona, ono wonga no baingaro wonbona. Ariya fai ete no dada uwau wonga wa, dada menakele yaasuna waha fere Itou no te kaiton bona. ");
INSERT INTO eri_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ji hugu waha boni muuji beele lenigini. Agenege igeide, ariya nere dada ete ada ure-urede. Nere agenege kuli tafade, onode wa nere beele ada isidu bode isou tede. ");
INSERT INTO eri_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nere fai-aita bagu waha bona, profet Aisaia nomo beele ete tigini heigena. No benou lewai, ‘Tere saini baingaro beele isagu ganga, ono wagu wa tere nomo hugu ada isagu ganga. Tere saini baingaro igei wagu ganga, ono wagu wa tere dada ete ada uragu ganga. ");
INSERT INTO eri_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nere fai-aita waha nebere huwanyanege sese waiha, onodu nere nebere agenege kuli beele isei nomo hogonyi nigina, onodu bode nere nebere agenege magana kutau waneha, gamaji agenege no dada ete uroga, ono gonga agenege kuli no beele isoga, ono gonga huwanyanege no beele hugu isidu, nere huwanyanege ubuludu ege gidu mayogunga, ji figini nigehenge ege hilobainga heigoguga bona.’ ");
INSERT INTO eri_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Onou wa tere edo edega wagu. Tere tebere agetege magana no dada ure-urena. Onodu tebere agetege kuli beele isisina. ");
INSERT INTO eri_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ji tere ngalenga letigini, amina nere profet baingaro Itou nomo fai tigini baingaro nere dada elebe tere ureya beha urei nomo bode gau anyakaro nigai. Ono wane wa, nere uregu uwa. Onodu nere beele tere isiya beha isei nomo gaude nigai, ono wane wa nere isegu uwa.” ");
INSERT INTO eri_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesus no ege onou lena, “Elebe tere fai no wit fatu haga langa ayaruna waha nomo muuji beele nomo hugu isagu. ");
INSERT INTO eri_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nere fai oruwanga ha laluwa nomo huuna langa yafei nomo hilou beele iside, onodu nere nomo hugu ada iside, nere wit fatu jala langa orososode dorofe, ono ganenga Satan no nere bagu maidu bona, fasadu onou beele Itou nere huwanyanege langa tawai waha faasidu ayaru-ayaruna. ");
INSERT INTO eri_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ariya wit fatu ila oula megebu bagu langa orososo wane, wa fai no beele isidu bona, no fasadu onou tedu bona edegana dorofe. ");
INSERT INTO eri_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Onona wa, beele no nomo boou uwau. No saini tutu menanga la oto-otona. Saini nere fai ila Itou nomo beele ilei fuwei mata bode wonga, nere fai waha oou tubode inyabamu tuwodbode, ono wode wa nomo huwanya ngalengawou waha fasadu inyaba wonbona. ");
INSERT INTO eri_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ariya wit fatu ila maalu kudina bagu gama langa orososo wane, wa fai no beele isina dorofe, onona wa no eseneha dada bona ninau baingaro isina, onodu bona no moni baingaro komomu wei nomo bona aoosona, ono ganga dada waha we Itou nomo beele kutau ganga no hilou ada heige-heigena. ");
INSERT INTO eri_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Onou wa, wit fatu oula hilou langa orososode waha, wa fai no beele isidu bona no nomo hugu isidena dorofe. No nomo hilou heige-heigena waha 100 yo 60 yo 30 onou.” ");
INSERT INTO eri_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus no ege muuji beele ete benou lenigai, “Ha laluwa nomo huuna la yafou wa, fai ete no nomo haga langa wit fatu hilobainga ayaruna dorofe. ");
INSERT INTO eri_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Onodu ooru la nere fai oruwa agore jiri boro gogunga, fai waha nomo honggoro fai maidu bona, jiigu inyaba wit gama la ayarudu, heige faga wonbona. ");
INSERT INTO eri_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ariya iinga wit waha no jaidu hilou heigei nomo ono gainga, nere jiigu inyaba waha fere wit gorala oto gane nerigane. ");
INSERT INTO eri_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Onodu bode nere haruwe magana goidu haga waha morou letuwane, ‘Oo Fai Anyakaro, ne wit fatu hilobainga name haga la ayaru wene wou iseye. Ono wene waha jiigu inyaba waha adadu heigane?’ ");
INSERT INTO eri_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ono wanenga no lenigai, ‘Honggoro fai ete we no dada waha onowai.’ No onou lenigainga nomo haruwe magana nere ka isoki tuwane, ‘Ere minidu boya jiigu inyaba waha guraru woya yo?’ ");
INSERT INTO eri_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ono wanenga no karu nigai, ‘Adai. Taate bona, gamaji tere jiigu inyaba waha guraru bonade wit ila guraru waguga. ");
INSERT INTO eri_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Onou waha bona, awadenga ngadu jayorunga goi nomo hilou elegei nomo fati la. Ariya nomo hilou elegei nomo fati langa, ji nere fai hilou elegei nomo waha lenigehenga, jiigu inyaba waha amugedu bode komomudu wele wodbode, onodu bode eeya la biteru wodbode. Ariya wit waha elege komomudu bonade, yame higina la logosi wodbode.’” ");
INSERT INTO eri_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus no ege muuji beele ete benou lenigai, “Itou nomo huuna la yafou no masted dorofe. Fai ete no masted fatu tedu bona nomo haga la tawon bona. ");
INSERT INTO eri_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masted fatu no, dada fatu ila oruwanga feiya nigou. No gai menakele mene. Ariya no anyakaro bona, haga la no sayori ila feiya nigou. No nauge dorofe jayonbona. Ono wonga neei nere maidu bode, nebere toomu nauge tuwa waha langa tafodbode.” ");
INSERT INTO eri_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus no ege muuji beele ete malalamudu benou lenigai, “Ha laluwa nomo huuna la yafou no yis dorofe. Aita ete yis waha tedu bona wit flawa dram anyakaro ete langa ubulumu wonga, iinga gonga flawa waha oruwanga ngasagona bona.” ");
INSERT INTO eri_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus no fai-aita bagu oruwa beele lenigai waha no muuji beele wahanga la lenigai. No beele ete te nomo kauni malala fouredu lenigei uwa. ");
INSERT INTO eri_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","No onou onowai waha no amina profet ete beele malalamudu lewai waha edomuwai. Profet no benou lewai, “Gai amina, saini oula heigai la mai elebe, dada hogo fere-fere huwari inyide waha nomo aasa, Ji tere muuji beele langa letigon boni.” ");
INSERT INTO eri_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ariya, Yesus no fai-aita bagu awa nigidu bona mata jauli huwanya langa goyai. Ono wainga nomo disaipel nere no bagu maidu bode letuwane, “Ne muuji beele langa jiigu inyaba haga langa heigai, waha nomo hugu ere lehigei nomo edo yo?” ");
INSERT INTO eri_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ono wanenga Yesus no ege gidu lenigai, “Fai no wit fatu hilobainga ayana waha, no Fai Nomo Idau. ");
INSERT INTO eri_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ariya haga waha no oula beha. Ariya wit fatu hilobainga waha nere fai-aita bagu ha laluwa nomo huuna langa yafade waha. Ariya jiigu inyaba waha, nere Satan nomo fai-aita bagu. ");
INSERT INTO eri_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Honggoro fai no jiigu fatu inyaba ayaru waha, wa no Satan. Da faasiwei nomo fati wa, oula beha usuwou nomo fati langa. Nere haruwe fai wa, nere ensel wenga. ");
INSERT INTO eri_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nere fai jiigu inyaba komomudu bode eeya langa biterude, onou dorofenga nere oula beha nomo fati usuwou langa onounga ono wodbode. ");
INSERT INTO eri_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Fai Nomo Idau no nomo ensel huuru nigonbona, ono wonga nere ha laluwa nomo huuna langa yafou langa dada inyaba oruwa fai huwanyanege ngalengawou inyabamu-inyabamude waha bagu, nere fai oruwa onowou inyaba ono-onode waha bagu so nigodbode. ");
INSERT INTO eri_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nere elege nigidu bode eeya anyakaro langa ayaru nigodbode. Ono wogunga, eeya waha langa nere meredu sooso bode manege gidodo wodbode. ");
INSERT INTO eri_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ono gogunga saini waha langa nere fai-aita bagu tigini waha nere Amenege nomo huuna langa yafou huwanya langa, hoonga dorofe lala wodbode. Fai no agokuli bagu wonga no beele beha isonbona.” ");
INSERT INTO eri_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus no ege onou lewai, “Ha laluwa nomo huuna langa yafou wa, moni bogis bagu haga ete langa huwarimu wane dorofe. Fai ete no uredu bona, no ege fere langa huwarimuwai. Onodu no inyangaaro edega bona, goidu nomo dada oruwanga hurudu bona haga waha ejiyawai.” ");
INSERT INTO eri_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus no ege onou lewai, “Ariya muuji beele ete benou. Ha laluwa nomo huuna la yafou no fai dadamu bagu ete kililoi hilou-hilou kuru nigina dorofe. ");
INSERT INTO eri_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Onodu saini no kililoi ete gai hilobainga ure bona wonga, no goidu nomo dada oruwanga huurudu bona, ariya no kililoi hilobainga waha ejiya wonbona.” ");
INSERT INTO eri_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus no ege onou lewai, “Muuji beele ete benou. Ha laluwa nomo huuna langa yafou wa, hagoma ete yaage katiwou langa aya wane minainga hoowe hogo fere-fere goyane dorofe. ");
INSERT INTO eri_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ono wanenga hagoma hoowe bolo wainga, nere kuse wanenga maa langa mayai. Onodu nere yafabode hoowe hilou-hilou elegedu bode haaya ila langa logosi wane. Ono bode hoowe inyaba waha elegedu ayaru wane. ");
INSERT INTO eri_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Oula beha nomo fati usuwou langa onounga ono wonbona. Nere ensel medu bode fai inyaba nere fai hilobainga gamanege langa yafade waha hanigod bode. ");
INSERT INTO eri_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Onodu bode elegedu eeya anyakaro langa ayaru nigogunga goyod bode. Ono wogunga eeya waha langa nere meredu sooso bode manege gidodo wodbode.” ");
INSERT INTO eri_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Onodu bona Yesus no disaipel benou isoki nigai, “Tere beele beha oruwa nomo hugu isiya yo?” Ono wainga nere letuwane, “Yoo.” ");
INSERT INTO eri_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ono wanenga no benou lenigai, “Onou waha bona nere nuuni beele isou fai oruwanga ha laluwa nomo huuna langa yafou nomo beele hugu isi borowane, ono wane wa nere mata anyakaro ete nomo umamu dorofe. No jauli ete nomo dada hilobainga hogo fere-fere otode langa goidu, dada eege bagu asari bagu elegedu malala heigai.” ");
INSERT INTO eri_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus no muuji beele beha malalamudu lenigi borodu bona, no matane waha awa tudu, ");
INSERT INTO eri_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","no nogo nomo matane hugu langa goyai. Onodu bona no Itou nomo beele fai-aita bagu nebere bori mata langa lenigai. Ono wainga nere horotodu bode lewane, “Fai beha isou waha alanga elegai? Adadu bona dodokawou waho no tafei nomo edo? ");
INSERT INTO eri_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ere isiya fai beha no kamda idau ete, nomo anya Maria, nomo bemu gane, Jems, Josep, Saimon, ono wainga Judas. ");
INSERT INTO eri_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nomo ogobumu gane oruwanga ere bagu yafaya. Adadu bona no dada beha oruwa onowei nomo edo?” ");
INSERT INTO eri_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nere onou ledu bode no bode huwanyanege inyabawai. Ono wanenga Yesus no lenigai, “Profet no matane oruwa langa unyi bagu. Ariya no nomo matane hugu langa, nomo mata langa tigini wa, no unyi uwau.” ");
INSERT INTO eri_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Onodu bona no matane waha langa dodokawou baingaro tafei uwa, taate bona, nere no bode huwanyanege ngalenga wegu uwa. ");
INSERT INTO eri_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saini waha langa gabman amugou Herot no dada Yesus onona waha nomo aasa isai, ");
INSERT INTO eri_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","onodu bona no nomo haruwe fai lenigai, “Fai behanga, no Jon yaage bisemu nigigou. No matmat langa ege jayai. Waha bona no dodokawou tafei nomo danga bagu.” ");
INSERT INTO eri_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Amina Herot no Herodias tai, no Filip woya, Herot bemu. Ono wainga Jon no Herot benou letuwai, “ne aita tene wa, edo uwa.” ");
INSERT INTO eri_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ono wainga, Herot no Jon taidu sen langa dage tudu bona, dagou mata langa tafa tuwai. ");
INSERT INTO eri_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot no Jon dukote wonga umei nomo onowai, onou wa, no fai-aita bagu umuge nigai, taate bona, nere ninanege benou isane, Jon no profet. ");
INSERT INTO eri_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Fati ete langa nere fai ila maidu Herot ngate da nyane, anya bisi tuwai waha nomo fati ninau isei nomo bona. Ono ganenga saini waha langa Herodias mago no nere gamanege langa moone uyai. Ono wainga Herot no gaude tuwai. ");
INSERT INTO eri_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ono wainga Herot no beele baara tawai, “Ngalenga tigini ouwe la, ne taate dada bonahe isoki hiyahenga wonga, ji ne hinonboni.” ");
INSERT INTO eri_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ono wainga Herodias aita waha nomo anya, no ninau tuwainga letuwai, “Ne Jon yaage bisemu nigigou fai, nomo mora haaya ete langa tafadu bonahe, te tamaidu hiyau.” ");
INSERT INTO eri_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King no beele waha isidu, huwanya ou tuwai. Ono wainga no beele danga bagu baara tawai waha bona ninau isidu, nere fai gaara yafadu da nyane waha agenege langa mayau tei nomo awai. Onodu bona no oota fai mago lewai onounga onowei nomo bona lenigai. ");
INSERT INTO eri_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Onodu bona, no fai ete dagou mata langa goidu oota fai lenigonga Jon bou karuwei nomo bona huuru tuwai. ");
INSERT INTO eri_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Onodu nere nomo mora haaya ete langa tafadu bode te tamaidu aita magana waha tuwane. Ono wanenga no tedu bona anya togoi fuwai. ");
INSERT INTO eri_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ono wanenga nere Jon nomo disaipel maidu bode Jon gogala tedu u-u kuru wane. Nere u-u kurudu bode, nere goidu Yesus letuwane. ");
INSERT INTO eri_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ono wanenga, Yesus no Jon dukote wane beele waha isidu bona, no matane waha awadu bona bot ete tedu, ha ulate fai uwau langa goyai. No nomo disaipel bagunga goyane. Ono wanenga nere fai-aita bagu baingaro isane, onodu bode nere taun awarudu bode, golodu no oojo tudu goyane. ");
INSERT INTO eri_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iinga Yesus no goi horiyedu bona nere fai-aita toomaro yafa ganenga nerigai. Onodu bona no nere bona aau warai, ono wainga no nere nebere taura fai taura jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ono wainga esuwa nomo disaipel maidu bode letuwane, “Ha beha fai uwau, saini amina usu waha. Onou waha bona ne fai-aita bagu huuru nigahenga goyode. Nere matane kejiwe langa goidu da ejiya wode.” ");
INSERT INTO eri_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ono wanenga Yesus no disaipel lenigai, “Nere taate bode goyode? Tere tage we nere da nigagu.” ");
INSERT INTO eri_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ono wainga nere letuwane, “Ere belanga da bainga uwa. Beret anyimu kouwou bagu, hoowe nga nononga wahanga inyide.” ");
INSERT INTO eri_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ono wanenga no lenigai, “Elegedu belanga tamai hayagu.” ");
INSERT INTO eri_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Onodu bona no fai-aita bagu jiigu langa yafei nomo lenigai. Onodu bona no beret anyimu kouwou bagu, hoowe nga nononga waha bagu elegedu bona, ha laluwa feele bona, Itou hilobainga tuwai. Onodu bona no beret lalatidu bona nere disaipel nigai. Ono wainga nere fai-aita bagu nigane, ");
INSERT INTO eri_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ono wanenga nere oruwa nyanenga ogonege digai. Onodu nere da matau-matau inyai waha elege komomudu bode kekele 12 jiriwane. ");
INSERT INTO eri_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nere fai 5,000 onou da nyane. Nere aita magana bagu lelege nigegu uwa. ");
INSERT INTO eri_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ariya Yesus no nere disaipel bot digedu amugedu yaage katiwou, ulate langa goyei nomo bona lenigai. Onodu no nogo yafa bona fai-aita bagu amugedu huuru nigonga goyei nomo bona onowai. ");
INSERT INTO eri_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","No fai-aita bagu huuru nigainga goi hara ganenga, no nogonga hauyawei nomo bona muju digedu ouwe langa manai. Esuwa hoonga mini gainga, no nogonga muju langa yafai. ");
INSERT INTO eri_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ono gainga bot amina goi baae wainga, jagui bot mutu fuu tubona, hiiri bot fekula tuwai. ");
INSERT INTO eri_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hamba wona jugu gainga, Yesus no yaage katiwou ouwe langa golobona maidu nere disaipel bagu heigai. ");
INSERT INTO eri_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ono wainga nere no yaage kati wou ouwe langa golo wainga uredu bode, nere umuge bode garabai narigai. Nere lewane, “Be barau ete.” Onodu bode nere umugedu bode inyangaaro hiri wane. ");
INSERT INTO eri_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ono wanenga fasadu onou Yesus no nere lenigai, “Tere danga bagu yafagu. Be ji wenga. Tere adai umugagu.” ");
INSERT INTO eri_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ono wainga Pita no ege gidu benou letuwai, “Anyakaro, be ne wonga wa, ne ji lehiyahenga ji edo yaage ouwe langa golodu ne bagu goyoni.” ");
INSERT INTO eri_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ono wainga Yesus no letuwai, “Ne mayau.” Ono wainga Pita no bot awadu bona, yaage ouwe langa golodu Yesus bagu goyai. ");
INSERT INTO eri_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ono wai wa, no jagui danga bagu uredu bona no umugai, onodu bona no menanga onou yaage gamu minidu, benou yaurai, “Anyakaro, ne ji hoyo hiyau.” ");
INSERT INTO eri_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ono wainga fasadu onou Yesus no owo ayadu Pita yaasu tubona letuwai, “Ne huwanyate ngalengawou menakele mene. Ne taate boni ninate nga baguni?” ");
INSERT INTO eri_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Onodu bodere nere bot langa digarenga jagui folowai. ");
INSERT INTO eri_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ono wainga nere fai bot langa yafane waha, nere no unyi isou bode, lewane “Ngalenga tigini ne Itou Nomo Idau.” ");
INSERT INTO eri_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Onodu bode nere yaage katiwou fadu bode goi Genesaret ulate langa horiyane. ");
INSERT INTO eri_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ono wanenga nere fai ulate waha-ha nere alai, wa Yesus. Onodu bode nere matane jugu-jugu oruwa langa beele huuru wane, ono wanenga nere taura fai oruwanga hanigedu no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Onodu bode nere Yesus danga bagu isoki tuwane, no taura fai awa nigonga nere owonege ayadu nomo kolos mutu la yaasuwei nomo bode. Ono wanenga nere oruwa onou ono wane waha nere ege hilou heigane. ");
INSERT INTO eri_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Saini waha langa, Farisi bagu nere nuuni beele isou fai bagu Jerusalem awadu bode Yesus bagu maidu bode isoki tuwane, ");
INSERT INTO eri_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Adadu bona name disaipel nere asage gane nuuni beele higane waha feiyade? Saini nere da nyode ono bode, owonege ada huge-hugede.” ");
INSERT INTO eri_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ono wanenga Yesus no beele ege benou lenigai, “Adadu bona tere tage tebere onowou oojo boya, tere Itou nomo nuuni beele waha feiyaya? ");
INSERT INTO eri_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Itou no lena, ‘Ne name amene anyane ngare neire huuna la yafa bonahe, neire beele oojowau,’ onodu ‘Fai no umamu yo, anya beele inyaba letuwona waha no umonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Onou wa tere benou le-leya, ‘Fai ete no umamu yo anya, hoyo tuwei nomo moni dada bagu, onou wa no leniron bona, “Ji Itou tuwei nomo amina hangadanaha.” ");
INSERT INTO eri_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ariya fai no waha, nomo umamu bona ninau isidu figini tuwei uwa.’ Onowou waha langa, tere Itou nomo beele ilei fu boya, tere onowou asatege gane langa tei waha isou-isouya. ");
INSERT INTO eri_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Tere fai yaawa hambawou. Profet Aisaia no tebere onowou tigini abiti tigai, saini no benou lewai langa, ");
INSERT INTO eri_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nere fai-aita bagu waha nere ji unyife nebere huranege langa isou-isoude, onode wa nebere isou huwanyanege bagu ji gai baae hiyou inyina. ");
INSERT INTO eri_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nere fai nebere nuuni beele wahanga malalamudu lebode, nere lede, “Beele beha Itou nomo beele.” Ono bode nere ji ewe unyife isou-isoude.’” ");
INSERT INTO eri_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Onodu bona Yesus no fai-aita bagu yaure nigainga no bagu mayanenga lenigai, “Tere agudu, ninatege isi dewagu. ");
INSERT INTO eri_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dada fai hurau gamu langa goina waha, no jijiga bagu ada tafa tuwona. Uwa. Onou wa dada hurau no malalamu na wahanga, no fai jijiga bagu tafa tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iinga nere disaipel maidu Yesus benou letuwane, “Ne isiniru, nere Farisi name beele waha isidu, huwanyanege inyabanaru?” ");
INSERT INTO eri_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ono wanenga Yesus no ege benou gidu lenigai, “Ji yame Jijei ha laluwa langa yafana waha, no haga bagu. Onodu dada oruwa no nogo tataru wei uwa waha, no nebere jijiruku oruwa fasi wonbona. ");
INSERT INTO eri_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tere nere fai waha bonade aau adai tarigou. Nere agenege fosokowou dorofe, nere ila jala abiti nigode onode. Onou wa, fai ago fosokowou ilibumu jala abiti tubona wonga, nere ngadu u-u langa minode bodere.” ");
INSERT INTO eri_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ono wainga Pita no Yesus benou isoki tuwai, “Ne muuji beele waha nomo hugu lewahenga, ere isoboya.” ");
INSERT INTO eri_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ono wainga Yesus no lewai, “Adadu? tere fere foo tigei uwa? ");
INSERT INTO eri_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tere ada rute isiya, dada oruwanga hawege langa goina waha, no huwanyage langa minina, ono ganga huwanyage no heelu ganga mata menekale la mini-minina. ");
INSERT INTO eri_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Onou wa, dada hurage no malalamuna wa, waha no ninage langa heigena. Onodu dada waha wenga fai ono tuganga jijigana. ");
INSERT INTO eri_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ji nere dada fai ninage langa heigena waha benou. Nere ninanege inyaba isidu, fai dukote wogunga umei nomo fanyimu, fai yo aita yo, te guruwou waha inyabamuwei nomo fanyimu, nere longi fanyimu, yebu nomo fanyimu onodu ila beele inyaba lenigou nomo fanyimu, kot langa yawa beele lewou nomo fanyimu. ");
INSERT INTO eri_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nere fanyimu waha fai ono tuganga Itou ago langa jijiga bagu heige-heigena. Onou wa, fai no da nyidu bona no amugedu owo ada hugena waha, no jijiga waha langa ada te-tena.” ");
INSERT INTO eri_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus no matane waha awadu ulate taon Tair, Saidon bagu la goyai. ");
INSERT INTO eri_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ono gainga Kenan aita ete no walanga yafa gai waha, no maidu bona yaurai. “Anyakaro, Devit Idau. Ne ji bonahe aau narou. Hauri inyaba yame aita magana inyabamu tudewaha.” ");
INSERT INTO eri_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ariya Yesus no bolou te tayei uwa. Ono wainga nomo disaipel nere maidu bode benou letuwane, “Aita waha gai yaurenga bona taga higina. Ne huuru tuwahe goyona.” ");
INSERT INTO eri_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ono wanenga, Yesus no ege gidu lenigai, “Itou no nere Israel fai-aita bagu wahanga, nere sipsip huwari wane waha hoyo nigei nomo bona huuru hiyai.” ");
INSERT INTO eri_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Onou lenigi gainga, aita waha no maidu bona Yesus hinemu la afo tuburu kutudu, du turigainga oula langa minainga letuwai, “Anyakaro, ne hoyo hiyau.” ");
INSERT INTO eri_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ono wainga Yesus no aita waha letuwai, “Gamaji ere magana mene-mene nebere da waha, elegedu gauna ayaru nagoya wa hilou uwa.” ");
INSERT INTO eri_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ono wainga aita waha ka Yesus letuwai, “Anyakaro, wa ne ngalenga leni. Onou wa, gauna nere da matau amenege gane nebere tebol huna langa orososo ganga eiegedu nyi-nyide.” ");
INSERT INTO eri_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ono wainga Yesus no beele waha isidu bona aita waha letuwai, “Aita, huwanyate ngalengawou anyakaro. Dada ne langa heigei nomo gauni waha edo heigona bona. Taate dada ne waha boni huwanyate ngalengana waha tiginimu hanona bona.” Ono gainga saini waha la tigini, nomo mago ege jige tuwai. ");
INSERT INTO eri_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Onodu Yesus no matane waha awadu bona golodu Galili yaage katiwou mou langa goyai. Onodu bona no muju langa digedu mani yafai. ");
INSERT INTO eri_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ono gainga, nere fai-aita bagu baingaro no bagu mayane. Ono bode nere fai afenege lalekawou bagu, nere agenege fosokowou bagu, nere ngedonege kobigou bagu, nere huranege fosokowou bagu, nere taura fai baingaro ila fere, nere Yesus afo hugu langa logosi wane. Ono wanenga no nere jigemu nigai. ");
INSERT INTO eri_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ono wainga nere fai-aita bagu ninanege baingaro isane. Wa taate bode, nere urane wa fai huranege fosokowou nere beele hayane, ono ganenga nere ngedonege kobigou wa tigini wai, ono gane fai afenege kaba tayou wa nere golowane. Ono ganenga nere agenege fosokowou wa, igei wane. Onou bode nere Israel nebere Itou unyi isou wane. ");
INSERT INTO eri_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus no nomo disaipel yaure nigainga mayanenga lenigai, Ji nere fai-aita beha boni augami hina. Nere Ji bagu fati eei oruwa da uwau yafane. Ji nere huweli huuru nigei nomo awani, gamaji jala gama golo bode huweli bona agenege gui woga. ");
INSERT INTO eri_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ono wainga nomo disaipel Yesus letuwane, “Haumu belanga fai uwau. Ere bereti alanga elegedu boya, nere fai baingaro benou waha nigedenga nyode?” ");
INSERT INTO eri_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ono wanenga Yesus isoki nigai. “Tere beret agonyi inyina?” Ono wainga “nere letuwane, ere beret 7, hoowe mene-mene ila bagu.” ");
INSERT INTO eri_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ono wanenga Yesus no fai-aita bagu waha lenigainga oruwa oula la yafane. ");
INSERT INTO eri_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Onodu bona no beret 7 waha hoowe bagu elegedu bona, Itou hauya tudu bona, lalatidu nomo disaipel nigai. Ono wainga nomo disaipel nere fai-aita bagu wese nagane. ");
INSERT INTO eri_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nere nyanenga ogonege bona, digai. Ono wanenga nere, da matau-matau awaru wane waha elegedu bode kekele 7 jiri wane. ");
INSERT INTO eri_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nere fai da nyane waha nere 4,000 onou, aita magana mene-mene bagu lelege nigegu uwa. ");
INSERT INTO eri_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Onodu bona Yesus no fai-aita bagu huuru nigainga hara gane no bot digedu bona, Magadan nebere ulate la goyai. ");
INSERT INTO eri_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi, Sadyusi bagu nere Yesus bagu madu, no wala-wala tuwei nomo bode ono wane. No dodoka ete tafonga, nere no Itou nomo haruwe tena wou, nomo naani dorofe abiti nigonga urode letuwane. ");
INSERT INTO eri_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ono wainga no beele ege gidu benou lenigai, “Esuwa la tere le-leya, ‘Ha ladena girina. Elebe saini hilou inyonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Onodu boya eringe la tere le-leya, ‘agau usuma ganga ha ladena girina. Waha bona elebe yaage jagui bagu tamayon bona’. Ngalenga, tere ha ladena nomo naani waha tigini uredu boya haawe dedeya. Onoya wa, tere elebe saini beha nomo naani uredu boya ada haawe dedeya. ");
INSERT INTO eri_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Elebe saini beha nomo fai-aita bagu nere inyaba, nere Itou bode huwanyanega ada ngalengana. Saini oruwa nere naani urei nomo yaure-yaurede. Onou wa, nere naani ete ada urode. Uwa. Naani etenga profet Jona langa urodbode.” Onodu Yesus no awa nigidu goyai. ");
INSERT INTO eri_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus nomo disaipel bagu yaage katiwou fadu goi ulate heigane, onou wa nere disaipel agenege kuli digainga beret te teeg uwa. ");
INSERT INTO eri_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ono wanenga Yesus no nere, lenigai “Tere oofade wagu. Tere Farisi bagu Sadyusi bagu nebere yis bonade ure dewagu.” ");
INSERT INTO eri_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ono wainga disapel nere nage-nage gamanege leguruwane, “No onou lena wa, taate bona ere beret elege tamayei uwa rute.” ");
INSERT INTO eri_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ono wai wa, Yesus no nere beele lewane waha no alai, waha bona no lenigai, “Tere fai huwanyatege ngalengawou menakele mene. Tere taate boya tere tage leya, ‘Ere beret uwau?’ ");
INSERT INTO eri_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tere fo tigei uwa rute? Nere fai 5,000 beret 5 nyane, ono wanenga tere kekele agonyi jiri weye waha boya ninatege isegu uwa rute? ");
INSERT INTO eri_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Onodu tere beret 7, nere fai 4,000 nyane, ono wanenga tere kekele agonyi jiri weye waha boya ninatege isegu uwa rute? ");
INSERT INTO eri_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ji tere beret boni letigei uwa waha, tere taate boya fo tigei uwa? Ji leni, tere Farisi bagu nere Sadyusi bagu nebere yis bonade oofade wagu.” ");
INSERT INTO eri_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ono wainga nere isane, no yis beret bitei nomo waha ure dewei nomo bona lewei uwa. No nere Farisi bagu Sadyusi bagu nebere beele ure dewei nomo bona lenigai. ");
INSERT INTO eri_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus no taon Sisaria Pilipai ulate langa goyai, onodu bona saini waha langa nomo disaipel isoki nigai, “Nere fai-aita bagu, Fai Nomo Idau bode, nere faiwei ide?” ");
INSERT INTO eri_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ono wainga nere letuwane, “Nere ila le-lede, ‘Ne Jon yaage bisemu nigigou fai.’ Ono ganenga nere ila le-lede, ne Elaija. Ono ganenga nere ila le-lede, ne Jeremaia yo, ne profet ete.” ");
INSERT INTO eri_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ono wanenga Yesus no nere isoki nigai, “Ariya tere tage ji boya faiwei iya?” ");
INSERT INTO eri_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ono wainga Saimon Pita no ege gidu letuwai, “Ne fai beha Itou nomo fai-aita bagu hanigei nomo hangada hinai. Ne Itou ago auma yafou Nomo Idau.” ");
INSERT INTO eri_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ono wainga Yesus no ege gidu letuwai, “Saimon, Jona idau ne dabu edega wau. Fai ete ha esene beha nomo, beele beha abitimu hinei uwa. Yame Jijei no ha laluwa langa yafana waha no abitimu hinai. ");
INSERT INTO eri_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Waha boni ji ne benou lehinini, Ne Pita, ji yame sios megebu waha jaula langa aton boni. Ono wehenga Umou nomo danga no ada ilei tuwona. ");
INSERT INTO eri_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ji ha laluwa nomo huuna langa yafou nomo ki ne hinonboni. Taate dada ne ha esene belanga dagahenga wonga, Itou no fere ha laluwa langa dagonbona. Onodu dada ne ha esene langa futu wahenga, Itou no fere ha laluwa langa futu wonbona.” ");
INSERT INTO eri_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Onodu Yesus no nomo disaipel nere no Kristus iwou waha, fai ete te adai lenigoguga bona, no beele danga bagu lenigai. ");
INSERT INTO eri_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Saini waha langa, Yesus no tigini Jerusalem goyei nomo bona nomo disaipel lenigou hugu warai, onodu no mora bagu, pris aroro bagu, nuuni beele isou fai bagu owonege langa tigini jimiri baingaro tonbona. Onodu no dukote wogunga umedu fati eei langa ege gidu jayonbona, waha lenigai. ");
INSERT INTO eri_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita no beele waha isidu bona, Yesus haudu gisa langa goidu honggoro tubona letuwai, “Anyakaro, gai uwanga uwa. Dada waha ne langa ada heigona.” ");
INSERT INTO eri_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ono wainga Yesus ubuludu Pita benou letuwai, “Satan, ne mogofe langa goyau. Ne jala karu hayau ganga ononi. Ne Itou ninau oojowei uwa. Ne fai nebere ninanegenga oojoni.” ");
INSERT INTO eri_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Onodu bona Yesus no nomo disaipel benou lenigai, “Fai ete no ji oojo hiyonbona wonga, no nomo gauwou oruwa ileidu bona, nomo nauge abalakawou auledu taga hiyonbona. ");
INSERT INTO eri_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Taate bona, fai ete no nogo nomo ago auma yafou yaasu wona wa, fai waha nomo ago auma yafou yaae wonbona. Ariya, fai ete no ji bona ninau isidu, nomo ago auma yafou awona wa, no iinga gai-gai ago auma yafou waha tonbona. ");
INSERT INTO eri_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ariya fai ete no oula beha nomo dada oruwa bagu yafa bona, nomo ago auma yafou waha awei uwa, onona wa, nere dada oruwa waha adadu hoyo tuwode? Fai waha nomo ago auma yafou ejiyawei nomo bona, taate agou tuwona? ");
INSERT INTO eri_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Fai Nomo Idau no Nomo Umamu nomo raara anyakaro la, nomo ensel bagu modbode. Saini waha langa, no fai-aita bagu nebere onowou waha agou onounga nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ji ngalenga letigini, nere fai ila otode beha, umeru wegu uwa yafa gogunga, Fai Nomo Idau King dorofe me gonga urod bode.” ");
INSERT INTO eri_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Fati 6 usu wainga Yesus no Pita, Jems, Jems bemu Jon, nere waha hanigedu bona, muju ete gai owe langa waha digedu manane. Walanga nere nagenga yafane. ");
INSERT INTO eri_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Saini nere igei ganenga, Yesus gogala ubuludu bona hogo fere ete heigai. Nomo hogo bala hoonga dorofe lalawai, ono bona nomo ogola dada waha gai kaambadu bona, lala dorofe heigai. ");
INSERT INTO eri_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nere Yesus nomo disaipel, Moses Elaija ngare maidu bodere Yesus ngate beele hai haigane nerigane. ");
INSERT INTO eri_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita no onou nerigedu bona, Yesus benou letuwai, “Anyakaro, ere belanga yafoya wa hilobainga. Ne gau bonahe wonga, Ji belanga youyou ei nononga, tatari wonboni, ete name, ete Moses nomo, ete Elaija nomo.” ");
INSERT INTO eri_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Saini Pita no onou legainga, agau ete lala danga bagu medu bona, kutau nigai. Ono gainga, agau waha huwanya langa, bolou ete benou lewai, “Beha waha yame Magana tigini, ji gaude tuboni no boni edegani. Tere nomo beele isagu.” ");
INSERT INTO eri_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Disaipel nere beele waha isidu bode, nere afenege tuburu kutudu, hogonege oula tudu inyangaro umugane. ");
INSERT INTO eri_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ono ganenga, Yesus no medu bona yaasu nigi bona lenigai, “Jayagu. Tere adai umugagu.” ");
INSERT INTO eri_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ono wainga nere jaidu bode igei wanenga manai wa, fai ete te walanga uregu uwa. Nere Yesus nogonga urane. ");
INSERT INTO eri_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Onodu bode, saini nere mujuha heigedu me bode, Yesus no beele danga bagu benou lenigai, “Tere dada ureyaha beha, fai ete te adai hai fuwagu. Tebere ninatege langa onou inyi gonga goi, Fai nomo Idau no umedu bona, ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ono wainga, disaipel nere benou isoki tuwane, “Taate bode nuuni beele isou fai nere le-lede, Elaija no amugedu mayonga?” ");
INSERT INTO eri_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ono wanenga no beele ege gidu benou lenigai, “wa ngalenga, Elaija ege maidu bona dada oruwa ege tiginimu wonbona. ");
INSERT INTO eri_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Onou wa ji tere letigini, Elaija no amina mayaha, fai nere no isi tuwegu uwa. Nere nage nebere gauwou wahanga oojo bode, nere onowou hogo fere-fere ono tude. Onounga nere Fai Nomo Idau fere onou ono tuwodbode.” ");
INSERT INTO eri_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesus no onou lewainga nere disaipel isane wa, no Jon Yaage Bisemu Nigigou Fai bona lena iwane. ");
INSERT INTO eri_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Onodu Yesus nomo disaipel ei bagu goidu fai-aita toomaro gamanege langa heigane, ono wanenga fai ete no Yesus bagu maidu bona afo tuburu kutudu, ");
INSERT INTO eri_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","lewai, “Anyakaro, ne yame idafe bonahe aau narou. No kusibu waridu bona, nomo gogala gai inyaba dewai. No saini baingaro eeya langa me taumai, ono bona saini baingaro yaage langa taumai. ");
INSERT INTO eri_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Onou wa, ji no haudu name disaipel bagu goinaha wa, nere no jigemu tuwei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ono wainga Yesus no lewai, “Tere fai huwanyatege ngalenga wegu uwau, onodu tere tebere ninatege fanyitege bagu tigini uwa. Ji tere bagu saini agonyi gai yafanga woni? Saini agonyi ji tebere ou auloni? Magana haudu belanga ji bagu mayau.” ");
INSERT INTO eri_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Onodu bona Yesus no hauri inyaba waha honggoro tuwai, ono wainga hauri inyaba magana waha awa tugainga, wanga taura usu tuwai. ");
INSERT INTO eri_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Iinga nere disaipel nagenga Yesus bagu maidu bode isoki tuwane, “Adadu bona ere hauri inyaba waha so tuwei nomo edo uwa?” ");
INSERT INTO eri_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ono wanenga no lenigai, “Tere tebere huwanyatege ngalengawou menakele mene, onou waha bona tere edo uwa. ");
INSERT INTO eri_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ji tere tigini letigini, tere tebere huwanyatege ngalengawou mastet nomo fatu dorofe wage wa, tere muju beha edo letuwagu ganga, ‘Ne jaidu bonahe ulate langa goyau,’ ono wadenga no goyonbona. Ono wadenga haruwe ete te, tere onowei nomo edo uwa ete uwau.” ");
INSERT INTO eri_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesus nomo disaipel bagu Galili distrik walanga komo wane, onodu Yesus no benou lenigai, “Nere Fai Nomo Idau fai owonege langa tafa tuwodbode, ");
INSERT INTO eri_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ono wogunga nere dukote wogunga umonbona. Onodu fati eei langa no ege gidu jayonbona.” Ono wainga nere disaipel beele waha isidu aau togo nagai. ");
INSERT INTO eri_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iinga, Yesus nomo disaipel bagu nere goidu Kaperneam taon langa heigane, ono wanenga, nere tempel nomo takis tegou fai nere Pita bagu heigedu bode, benou isoki tuwane, “Tere tebere isisi tigigou fai, no tempel nomo takis aya-ayana rute?” ");
INSERT INTO eri_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ono wanenga Pita lenigai, “Yoo.” Onodu no mata huwanya goidu, beele ete te lewei uwa inyi gainga, Yesus no benou isoki tuwai, “Saimon ne adadu isini? Nere oula beha nomo king nere takis hugu fere-fere elegede waha, fai ani nere takis waha ejiya-ejiyade? Nere nebere gane langa elege-elegede yo uwa, fai fereha nebere.” ");
INSERT INTO eri_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ono wainga Pita lewai, “Nere fai fere langa.” Ono wainga Yesus letuwai, “Onou waha bona, nere nebere ilibanege gane nere takis ayawei nomo haruwe uwau. ");
INSERT INTO eri_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Onou wa, gamaji ere ono nigedenga ere bode honggoro woguga. Ne yaage katiwou langa minidu hiima aya wau. Onodu bonahe ne hoowe amugou tedu bonahe hurau isebu wau, onodu ne moni ete huwanya langa inyi gonga urau ganga. Ne moni waha tedu bonahe nere nigau, ere eire takis edomuwei nomo bona.” ");
INSERT INTO eri_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Saini waha langa, nere disaipel Yesus bagu heigedu bode isoki tuwane, “Fai wei no ha laluwa nomo huuna langa yafou waha la, unyi gai anyakaro yafona?” ");
INSERT INTO eri_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ono wanenga, Yesus no magana menakele ete yaure tuwainga mayainga, nere gamanege langa otomu tuwai. ");
INSERT INTO eri_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Onodu bona no lewai, “Ji tere ngalenga letigini, tere ege ubuludu nere magana mene-mene dorofe heigei uwa wonga wa, tere ha laluwa nomo huuna langa yafou waha huwanya langa ada goyagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Fai no nogo ilei bona no magana menakele benoha heigona waha, fai waha no ha laluwa nomo huuna langa yafou waha langa unyi anyakaro bagu. ");
INSERT INTO eri_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Onodu fai ete no ji bona isidu no magana menakele ete benoha hoyo tubona wonga wa, no ji hoyo hina.” ");
INSERT INTO eri_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesus no ege benou lena, “Onou wa, fai ete no magana mene-mene ji bode huwanyanege ngalengade beha nebereha ete ono tuwonga, une langa meboduwei mata wonga wa, nere fai waha boou langa megebu anyakaro ete dagedu bode, hiiri langa aya tuwogunga minidu umona bona. ");
INSERT INTO eri_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Nere fai ha eseneha waha, nere fai une langa tafa nigi ganenga mebodude waha, nere agenege gami bagu. Ngalenga, onowou inyaba waha heigon bona. Onou wa, fai no une ono ganga heige na waha no agamu bagu. ");
INSERT INTO eri_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Onou waha bona, ne name owone yo afene no ne une tafei nomo kuse hinei mata wonga, ne karudu kaitau. Ono wahenga, hilobainga ne owone etenga yo, afene etenga inyona, onodu bonahe ne agene auma gai-gai yafou tau. Gamaji ne owone nga yo afene nga bagu inyonga, nere eeya ada gare-garena waha langa aya hinoguga. ");
INSERT INTO eri_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Onou waha bona, ne name agene magana no une tafei nomo ono hinei mata wonga, ne faasidu kaitau. Onou wa hilobainga ne agene magana etenga wonga, ne agene auma gai-gai yafou tau. Gamaji ne agene magana nga bagu wonga nere umou nomo eeya langa kaite hinoguga. ");
INSERT INTO eri_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Tere ure dewagu, gamaji tere ninatege benou isagu ganga, nere magana mene-mene waha ete nere gamanege langa dada ewe dorofe. Uwa. Ji tere letigini, ha laluwa nomo ensel nere, gai-gai yame Jijei ha laluwa langa yafana waha hogo langa oto-otode. ");
INSERT INTO eri_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yesus no ege benou lena, “Tere adadu isiya? Fai ete no nomo sipsip 100, onodu sipsip ete huwariwei mata wonga, no ada rute kuru wona? Uwa. No sipsip 99 muju langa awaru nigonga oto gogunga, no goidu sipsip etenga huwari wai, waha, kuru wonbona. ");
INSERT INTO eri_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ji tere ngalenga letigini, no kurudu toroba wei mata bona wonga, no edega dewonbona. Nere 99 huwari wegu uwa waha bona no edega-edegna. ");
INSERT INTO eri_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Onou dorofenga, tebere Ametege ha laluwa langa yafana waha no magana mene-mene waha nebereha ete huwariwei nomo bona no gau tuwei uwa.” ");
INSERT INTO eri_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus no ege benou lena, “Ne name baine no nyabuluwou ete ono hinei mata wonga, ne goyahenga tere tarenga yafa bonadere beele tiginimu waru. Ono wahenga no ne name beele isei mata wonga wa, ne name baine ege gidu hawau. ");
INSERT INTO eri_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ariya no ne name beele isei uwa wonga wa, ne ege fai etenga yo nga hanirahenga goyagu. Ono wahenga nere beele dangamu wode. ");
INSERT INTO eri_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Onou wa no nebere beele isei nomo awa bona wonga, ne sios nomo fai-aita bagu lenigau. Ono wahenga no nebere beele fere isei uwa wonga, ne urau ganga, wa no haiden takis tegou fai dorofe. ");
INSERT INTO eri_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ji tere ngalenga letigini, tere dada oruwanga oula langa dagadenga, Itou no ha laluwa langa dagona bona. Tere oula langa futu wadenga, Itou no ha laluwa langa futu wonbona. ");
INSERT INTO eri_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Onodu ji tere ege letigini, tebereha fai nga oula belanga dada ete bodere, huwanyanere etengadu, dada waha tei nomo hauyawei mata wodere wa, yame Jijei ha laluwa langa yafana waha no nere nironbona. ");
INSERT INTO eri_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Fai nga yo, eei nere ji unyife langa haumu ete langa komowei mata wode wa, ji yage nere gama langa yatani.” ");
INSERT INTO eri_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Saini waha langa Pita no Yesus bagu maidu isoki tuwai, “Anyakaro, ji yame baabo no ji inyabumu hina waha, Sain agonyi ji no nomo nyabulu wou ulu fuwoni? Saini 7 yo?” ");
INSERT INTO eri_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ono wainga Yesus no letuwai, “Ji ne saini 7 wahanga la nomo nyabulu wou uulu fuwei nomo lehinei uwa, ji lehinene, saini 77. ");
INSERT INTO eri_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Isagu. Ha laluwa nomo huuna la yafou no king ete dorofe, no gauna wa, nomo haruwe magana maidu no langa agou tiginimu wei nomo bona. ");
INSERT INTO eri_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","No agou waha tiginimu wei nomo bona hugu wari gainga, nere fai ete haudu no bagu magane. Fai waha nomo moni agou tiginimu wei nomo wa 10 milion kina. ");
INSERT INTO eri_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ariya haruwe magana no moni waha agou tafei nomo edo uwa, taate bona, no moni onouha waha gogala langa inyei uwa. Onou waha bona king no lenigonga nere fai waha nomo aita magana bagu huuru nigonga, nere fai ete nomo haruwe magana ewe heigod bode. Onodu nere nomo dada oruwanga huurudu moni tedu bode, nomo moni agou waha tiginimu wodbode. ");
INSERT INTO eri_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ono wainga haruwe magana no king hogo la afo tuburu kutudu yafa bona gelele tubona letuwai. ‘King ne ji bonahe augami hinonga, menanga onou itari hiyau. Ji moni ne la tene waha agou oruwa hinonboni.’ ");
INSERT INTO eri_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ono wainga, haruwe magana waha nomo mora bagu, no augami tuwainga awa tuwai, onodu nomo moni 10 milion kina agou fere uwamu fuwai. ");
INSERT INTO eri_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ono wainga haruwe magana waha malala heigedu bona, nomo haruwe ilibumu ete toroba tuwai. Ariya fai waha nomo moni agou no la inyina waha no 10 kinanga. Ariya fai waha no maidu bona, haruwe ilibumu dobole tudu, bou danga bagu yaasu bona letuwai, “Ne yame moni elegene waha nomo agou oruwa tiginimu wau.” ");
INSERT INTO eri_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ono wainga, haruwe magana wa, afo tuburu kutudu yafa bona, ilibumu gelele tubona letuwai, ‘Ne ji bonahe augami hinou. Onodu menanga onou itari higahe, ji name moni agou oruwa hinonboni,’ ");
INSERT INTO eri_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ono wainga fai waha no awai. Onodu bona no haruwe ilibumu dagou mata langa tafa tuwai, no walanga yafa bona nomo moni agou oruwanga tiginimu fuwonbona. ");
INSERT INTO eri_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Nere haruwe magana ilibumu gane ila onowou waha uredu bode, huwanyanege danga bagu inyabawai. Ono wainga nere goidu nebere mora bagu, haruwe magana fanyimu oruwa onowai waha bode letuwane. ");
INSERT INTO eri_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ono wanenga fai anyakaro no haruwe magana waha yaure tuwainga goyai, Onodu letuwai, ‘Ne haruwe magana inyaba. Ngasunga ne ji bagu maidu gelele hiyenenga ji name agou waha oruwa uwamu hanene. ");
INSERT INTO eri_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ji ne boni augami hiyai. Ariya ne taate boni name haruwe magana ilibane boni onounga augami hinei uwa?’ ");
INSERT INTO eri_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Onou letudu bona, fai anyakaro houmu mayainga fai waha dagou mata la tafa tuwai. No waanga yafa bona nomo moni agou waha oruwanga tiginimu fuwonbona. ");
INSERT INTO eri_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tere tebere huwanyatege la, ilibatege gane nebere onowou inyaba ada uulu nagi bonade wonga, Yame Jijei ha laluwa la yafana no fere, tere onounga ono tigonbona.” ");
INSERT INTO eri_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus no beele waha usumudu bona, no Galili distrik awadu Judia distrik Jordan yaage ulate langa goyai. ");
INSERT INTO eri_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ono wainga fai-aita bagu baingaro nere no oojo tuwane. Ono wanenga ulate walanga no nebere taura jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ono gainga Farisi mayane, nere maidu bode Yesus wala-wala tu urane. Onodu isoki tuwane, “Ere ebere nuuni beele fai no edo, nomo gauwou langa oya awa tuwona rute?” ");
INSERT INTO eri_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ono wanenga Yesus no ege gidu lenigai, “Tere beele Itou nomo buk langa inyina waha lelegei uwa rute? No benou lena, ‘Aminanga amina Itou no dada oruwanga tafai langa no fai-aita bagu tafa nigainga heigane. ");
INSERT INTO eri_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Onodu Itou lewai, “Onou waha bona, fai no anya umamu ngare awa niridu bona, no nomo oya ngare fadadere waha, nere genere gala etenga yafode bodere.” ’ ");
INSERT INTO eri_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Itou no onou lewai bona nere nga dorofe yaferu uwa. Nere genere gala etenga dorofe heigare. Waha bona Itou no amina beele bara tawai waha, fai ete adai fasakawou.” ");
INSERT INTO eri_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ono wainga, nere Farisi letuwane, “Adadu, Moses no ere nuuni beele higi bona benou lehigai, fai no edo aita so tuwei nomo pas yeregedu aita tuwonbona, onodu bona so tuwonga goyonbona?” ");
INSERT INTO eri_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ono wanenga Yesus no nere lenigai, “Tere feeto wou fai, onou waha bona, Moses no tere awa tigainga, tere tebere oyatege gane so nigeye. Gai aminanga, onowou waha uwau. ");
INSERT INTO eri_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ji tere onou letigon boni, fai ete nomo oya no longi tafei uwa, no woya so tudu bona, aita ete te bona wonga, fai waha no nogo longi tafaha.” ");
INSERT INTO eri_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ono wainga nere disaipel beele waha isidu Yesus letuwane. “Fai no woya ngare yafa bodere fanyimu waha onowei mata bona wa, buyona, fai waha no aita adai tona.” ");
INSERT INTO eri_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ono wanenga Yesus no benou lenigai, “Nere fai oruwanga beele beha ada todbode. Uwa. Itou no nere fai ilanga danga nigai. ");
INSERT INTO eri_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Isagu. Fai hogo fere-fere yafade, nere aita ada elege elegede. Ila anyanege gane bisi nigane la, genege gala inyabawai. Onodu ila fai nere magana karu nagane, onou waha bode, nere magana heigemu wei nomo edo uwa. Ono ganenga nere ila ha laluwa nomo huuna langa yafou waha, nomo haruwe tei nomo bode ninanege isi bode nere nage aita yo, fai tei nomo guuni tafane. Fai no beele beha tei nomo edo wonga, no edo tona.” ");
INSERT INTO eri_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Saini waha langa fai-aita bagu magana mene-mene hanigedu Yesus bagu mayane. Nere no moranege langa owo tafadu hauyawei nomo gau nigai. Ono wane wa disaipel nere fai-ait bagu honggoro nigane. ");
INSERT INTO eri_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ono wanenga Yesus no disaipel lenigai, “Tere magana mene-mene awa nigadenga ji bagu mayode. Tere nere adai karu nigagu. Uwa. Ha laluwa nomo huuna langa yafou waha fai magana mene-mene benoha waha nebere.” ");
INSERT INTO eri_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Onodu bona no moranege langa owo tafai. Onodu bona iinga no haumu waha awadu bona goyai. ");
INSERT INTO eri_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ariya fai ete no Yesus bagu maidu bona letuwai, “Isisiwou fai, ji taate onowou hilou tigini onodu boni, agefe auma gai-gai hilou yafou waha toni?” ");
INSERT INTO eri_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ono wainga Yesus no letuwai, “Ne taate boni, ji onowou hilou boni isoki hini? Etenga wahanga no hilou. Onou waha bona, ne tigini agene auma gai-gai hilou yafou tauga wonga, ne Itou nomo nuuni beele oruwa oojowau.” ");
INSERT INTO eri_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ono wainga fai waha no Yesus benou isoki tuwai, “Ne taate nuuni beele waha boni leni?” Ono wainga Yesus no letuwai, “Nuuni beele beha beele benou bagu, tere fai-aita ila adai dunege kote wadenga umode. ‘Tere fai-aita te guruwou waha longi adai tafagu. Tere adai yebu wagu. Tere fai ila yaawa beele langa kot langa adai tafa nigagu. ");
INSERT INTO eri_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tere tebere anyatege ametege gane huuna la yafa bonade nebere beele oojo wagu. Onodu ne nage boni gau hinina dorofe ilibane gane bonahe fere onou gaude hinou.’” ");
INSERT INTO eri_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ono wainga magana gila waha no Yesus letuwai, “Nuuni beele waha oruwanga ji oojo oojoni. Ji taate dada boni gai tutu hina yo?” ");
INSERT INTO eri_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ono wainga Yesus no letuwai, “Ne hilobainga tigini heigau ganga wonga, ne goidu bonahe ne name dada oruwanga huurudu bonahe moni tedu, fai dadanege uwau waha nigau. Ne onou onodu bonahe, ne ha laluwa langa dada hilobainga bagu yafau ganga. Ne maidu ji oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ono wainga, magana gila waha no beele waha isidu bona, huwanya ou tugainga goyai. Taate bona, no dada gai baingaro bagu. ");
INSERT INTO eri_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Onodu Yesus no nomo disaipel lenigai, “Ji ngalenga letigini, moni fai nere ha laluwa nomo huuna langa yafou waha la goyei nomo haruwe danga. ");
INSERT INTO eri_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ji tere ege letigini, Kamel no niili kolos erere gou nomo yogode langa goyei nomo haruwe danga uwa, moni fai no Itou nomo huuna langa yafou la goyona dorofe uwa.” ");
INSERT INTO eri_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ono wainga, nere disaipel beele waha isidu bode horoto dewane. Onodu bode nere lewane, “Onou wonga, faiwei no edo gai-gai ago auma yafou waha tonbona?” ");
INSERT INTO eri_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ono wanenga Yesus no nere tigini feele nigi bona lenigai, “Fai nere edo uwa. Onou wa, Itou no dada oruwa onowei nomo edo.” ");
INSERT INTO eri_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","No onou lenigainga, Pita no beele ege gidu benou letuwai, “Urau, ere dada oruwanga awarudu boya, ne oojo hiniya. Ere taate dada toya?” ");
INSERT INTO eri_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ono wainga Yesus no nere lenigai, “Ji ngalenga letigini, saini dada oruwanga ege heigei nomo saini langa, Fai Nomo Idau no unyi anyakaro bagu nomo sia king langa yafonbona, ono gonga saini waha langa, tere fai ji oojo hiya waha tere fere sia 12 waha langa yafa bonade, nere Israel nebere komowou 12 waha oofa nigagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Onodu nere fai-aita bagu oruwanga ji unyife bode ninanege isidu, nere nebere mata yo, bainege gane yo, ogonege gane yo, amenege gane yo, anyanege gane yo, idanege magenege gane bagu yo, haga yo, awaru wane waha, nere ege 100 todbode, onodu bode nere agenege auma gai-gai hilou yafou waha todbode. ");
INSERT INTO eri_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Onou wa, fai baingaro elebe amugou yafade waha, nere gai huunta yafadbode. Ono gogunga, fai baingaro elebe huunta yafade waha nere, amugou yafodbode.” ");
INSERT INTO eri_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus no ege benou lewai, “Fai nere amugou yafei nomo bona ji beele beha leni, taate bona, ha laluwa nomo huuna langa yafei nomo wa, fai ete no oula baingaro dorofe. Eringe amina no goidu, nomo wain haga la haruwe tei nomo bona, haruwe magana hanigon bona. ");
INSERT INTO eri_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nere haruwe magana fati waha la 1-kina tei nomo edo iwane, ono wanenga, mora bagu huuru nigainga nomo wain haga langa goidu haruwe taane. ");
INSERT INTO eri_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ono ganenga, 9 kilok onou fai anyakaro no kotowou haumu la minidu bona fai ila ewe oto ganenga nerigai. ");
INSERT INTO eri_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Onodu bona no nere waha fere onounga lenigai, ‘Tere manidu yame wain haga la haruwe taagu. Ono wadenga, ji tere haruwe teya waha nomo agou onounga tigon boni.’ ");
INSERT INTO eri_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ono wainga nere manane. Ono gane, 12 kilok langa, esuwa 3 kilok langa bagu, fai anyakaro no ege goidu bona onounga onowai. ");
INSERT INTO eri_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ariya 5 kilok esuwa langa onou, no ege golodu kotowou haumu la minidu bona, no fai ila ege walanga oto ganenga nerigedu bona nigai. ‘Taate boya tere ewe auma belanga hoonga oruwa otoya?’ ");
INSERT INTO eri_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ono wainga nere letuwane, ‘ere fai ete te nomo haruwe te fuwei nomo bona haigei uwa.’ Ono wanenga fai waha lenigai, ‘Tere fere edo goidu yame wain haga la haruwe taagu.’ ");
INSERT INTO eri_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Esuwa wainga, wain haga morou no nomo hoobu fai letuwai, ‘Nere haruwe fai yaure nigahenga mayogonga, nebere haruwe agou nigau, nere fai gai huunta hanigeyaha waha la hugu waridu, amugedu hanigeyaha waha langa usumuwau.’ ");
INSERT INTO eri_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ariya nere fai 5 kilok esuwa la haruwe hugu warane waha nere maidu 1kina-1kina taane. ");
INSERT INTO eri_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ono wainga, nere fai amugedu mai haruwe taane waha mayane, nere moni anyakaro tei nomo iwou isane. Ariya uwa. Nere fere oruwa moni 1kina-1kina onounga taane. ");
INSERT INTO eri_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nere moni taane waha uredu bode, haga morou honggoro tubode ");
INSERT INTO eri_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","benou letuwane. ‘Nere fai beha gai huunta mayane, onodu awa etenga haruwe taane, ono wanenga ne moni ere higinaha onounga nere niginaha. Ariya ere eringe aminaha haruwe danga bagu tegeye mai elebe, hoonga danga bagu uwe higaha.’ ");
INSERT INTO eri_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ono wanenga wain haga morou no haruwe magana nebereha ete letuwai, ne isau, Ji ne inyabamu hinei uwa. Ngasunga ere 1-kina tei nomo edo iwou lewere yo, uwa? ");
INSERT INTO eri_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne name haruwe agou tedu bonahe goyau. Ji yame gauwou langa, fai no gai huunta mayaha waha nomo haruwe agou onounga tunaha. ");
INSERT INTO eri_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wa yame dada. Ji yame gauwou oojodu boni, moni wese wei nomo edo uwa yo? Ji fai waha hilou tafa nigoni wonga, ne taate bona huwanyate inyaba wona? ");
INSERT INTO eri_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Onodu Yesus no lewai, “Onounga, fai nere gai huunta yafane waha, nere amugou yafodbode. Fai nere amugou yafane waha, nere gai huunta yafodbode.” ");
INSERT INTO eri_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus no golodu Jerusalem manai. No disaipel 12 wahanga hanigainga gaara mani bode, Yesus no benou lenigai, ");
INSERT INTO eri_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Isagu. Ere elebe Jerusalem maniya. Ono wedenga nere Fai Nomo Idau pris aroro bagu nuuni beele isou fai bagu owonege langa tafa tuwodbode. Onodu bode, nere kot langa tafa tudu bode, no dukote wogunga umei nomo bode beele agili mala karu wodbode. ");
INSERT INTO eri_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Onodu bode, nere fai fereha nigodbode, ono wogunga nere no memesi tubode, gula tubode, nauge abalakawou langa tutui la warod bode. Ono wogunga fati eei langa no ege jayonbona.” ");
INSERT INTO eri_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iinga Sebedi oya no nomo idau gane nga nononga waha gaara Yesus bagu mayane, onodu bona, no oula langa afo tuburu kutudu benou lewai, no Yesus dada ete bona isoki tuwonbona. ");
INSERT INTO eri_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ono wainga Yesus no benou isoki tuwai, “Ne taate dada gau hinina?” Ono wainga no letuwai, “Ne benou lewei nomo gaude hina, yame idafe gane nga beha name huuna langa yafou la, ne hinote langa yafod bodere, ete ne owone hilou langa, ete owone kenao langa.” ");
INSERT INTO eri_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ono wainga, Yesus no beele ege gidu benou letuwai, “Tere dada isokiya waha boya ada isideya. Tere kap ji nyoni waha langa, tere nyei nomo edo yo?” Ono wainga nere leware, “Ere edola.” ");
INSERT INTO eri_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ono warenga Yesus no lenirai, “Wa ngalenga, tere yame kap langa nyaaru ganga. Ariya faiwei no yame owofe hilou langa yo owofe kenao langa yafei nomo wa, ji yame dada uwa. Sia waha, yame Jijei no fai nebere amina haiya nagai.” ");
INSERT INTO eri_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Saini disaipel 10 nere beele waha isidu bode, nere bemu ngare bode honggoro wane. ");
INSERT INTO eri_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ono wane wa, Yesus no nere yaure nigainga no bagu mayanenga lenigai, “Tere alai, nere king fereha nebere fai-aita bagu oofade nigi-nigide. Onodu fai aroro nere fai-aita bagu nebere beele oojowei nomo bode danga tafa nigi-nigide. ");
INSERT INTO eri_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Onou wa, onowou waha tere gama langa adai inyou. Uwa. Fai no tere gama langa anyakaro yafonbona wonga, ngasunga no tere tebere haruwe magana yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Onodu fai no tere tebere amugou yafona wonga, no ngasunga tebere haruwe fai ewe dorofe yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Onou dorofenga, Fai Nomo Idau mai waha, fai nere no hoyo tuwei nomo bona mei uwa. No nere fai-aita bagu baingaro ejiya nigidu gidu hanigei nomo bona nomo ago auma nigai.” ");
INSERT INTO eri_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus nomo disaipel bagu Jeriko taon awadu goyane. Ono ganenga fai-aita bagu baingaro nere Yesus oojo tuwane. ");
INSERT INTO eri_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ono ganenga fai nga nononga agenere fosokowou, nere jala gisa langa yafare. Ono bodere nere Yesus golo waha maina iwou beele isidu bodere, nere inyangaaro yauredu leware, “Anyakaro, ne Devit Idau, ne ere bonahe augami hinou.” ");
INSERT INTO eri_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ono warenga fai-aita bagu nere huranere fosokowei nomo beele danga bagu lenirane. Ono ware nere belenere otonga bodere leware, “Anyakaro, ne Devit Idau, ne ere bonahe augami hinou.” ");
INSERT INTO eri_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ono warenga Yesus no otodu bona nere yaure niridu lenirai, “Tere adadu ono tirei nomo gau tirina?” ");
INSERT INTO eri_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ono wainga nere letuware, “Anyakaro, ne eire agere fokomu harei nomo gau hirina.” ");
INSERT INTO eri_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ono warenga Yesus no nere bona aau warainga, nomo owo neire agenere langa tafai, ono wainga saini wahanga la, nere agenere ege igei ware. Onodu bodere, nere no oojo tudu goyare. ");
INSERT INTO eri_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus no nomo disaipel ngate mai Jerusalem jugumudu bode, Betfage matane Oliv muju langa heigane. Onodu bode, Yesus no nomo disaipel nga huuru niridu, ");
INSERT INTO eri_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","benou lenirai, “Tere matane elebe ureya waha langa minaru. Tere mini bona derenga, donki ete dage tuwou nomo magana ngare oto gorunga nerirau ganga. Onodu malu futu fudu, haniredu ji bagu tamayaru. ");
INSERT INTO eri_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ono gaderenga, fai ete no beele ete letirei mata wonga wa, tere benou letuwaru, ‘Anyakaro no nere la haruwe bagu,’ Ono waderenga, no fasayadu onou huuru nironga mayod bodere.” ");
INSERT INTO eri_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dada beha amina profet lewai waha, edomuwei nomo bona heigai. ");
INSERT INTO eri_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tere Saion fai-aita bagu, beele beha malalamudu lenigagu. ‘Uragu. Tebere king amina maina. No fai unyi uwau dorofe maina, no donki ete jaula langa yafana. No donki magana gila ete la yafa ganga maina.’” ");
INSERT INTO eri_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ariya nere Yesus nomo disaipel goidu, Yesus lenirai onounga ono ware. ");
INSERT INTO eri_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nere goidu bodere, donki anya magana ngare haniredu mayare, onodu nere neire kolos donki jaulanere la jimaware. Ono warenga Yesus no ouwe langa yafai. ");
INSERT INTO eri_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ono gainga, fai baingaro nebere kolos uludu jala la jima wane. Ono gane nere ila nauge gala kokorudu, tamai jala la jima wane. ");
INSERT INTO eri_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ono bode, nere fai-aita bagu jala amugane waha bagu, nere fai-aita bagu ila huunta mayane waha bagu, nere yaure bode lewane, “Devit Idau bonade edega wagu. Fai waha no Anyakaro unyi la maina, Itou no edo fai waha figini tuwonbona, Itou unyi Gai Ouwe la Isou wagu.” ");
INSERT INTO eri_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus no Jerusalem huwanya goyainga, nere fai-aita bagu taonha oruwa uredu bode horoto wane, onodu nere nage-nage isoki guru wane, “Fai beha waha no faiwei tigini?” ");
INSERT INTO eri_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ono wanenga nere fai-aita bagu golo wane waha nere lewane, “No Yesus, no profet, Nasaret taon Galili prowinsha mayaha.” ");
INSERT INTO eri_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Onodu bona, Yesus no tempel orei huwanya langa goidu bona fai nere moni kusewei nomo haruwe taane waha aruwanga so nigai. Onodu bona no fai oruwanga nebere tebol moni hoole bode oto wane waha bagu, nere fai neei huuru bode otowane waha nebere sia bagu koresemudu ayaru nagai. ");
INSERT INTO eri_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Onodu bona no lenigai, “Itou nomo buk no benou lena, ‘Yame mata no hauyawei nomo mata inyonbona.’ Onou wa, tere ono tuyanga no yebu fai nebere huwariwei nomo haumu dorofe heigaha.” ");
INSERT INTO eri_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus no tempel mata huwanya langa yafa gainga, fai ila agenege fosokowou, ila afenege inyabawou, no bagu mayane, ono wanenga no jigemu nigai. ");
INSERT INTO eri_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ono-wai waha nere pris aroro bagu nuuni beele isou fai bagu no dodokawou tafa-wai waha urane, onodu bode nere magana mene-mene tempel haumu langa benou yaure ganenga isane, “Devit Idau bonade edega wagu.” Ono wanenga nere huwanyanege inyabawai, ");
INSERT INTO eri_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ono wainga nere Yesus isoki tuwane, “Ne nere beele lede waha isini yo?” Ono wanenga Yesus no lenigai, “Yoo, ji isini. Onou wa tere beele benou waha lelegegu uwa rute, ‘Nere magana mene-mene ne unyite isou-isoude.’ ” ");
INSERT INTO eri_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Onodu nere awa nigidu bona, taon arasai langa goidu, ooru waha langa no Betani langa yafai. ");
INSERT INTO eri_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Eringe amina Yesus no ege gidu taon mani bona no huweli tuwai. ");
INSERT INTO eri_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ono wainga no fik nauge ete jala gisa langa oto gainga urai. Onodu bona hugu langa goyai. No goidu bona urai wa no hilou uwau. Ewe gala galanga oto wai. Ono wainga no fik nauge waha benou letuwai, “Ne ege hilou ada heigau. Gai uwanga uwa.” Ono wainga fasadu onou fik nauge waha kakaregai. ");
INSERT INTO eri_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ono wainga nere disaipel waha uredu bode horoto wane. Onodu bode nere lewane, “Adadu bona fik nauge waha no fasadu kakaregaha?” ");
INSERT INTO eri_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ono wanenga Yesus no nebere beele waha ege gidu benou lenigai, “Ji tere ngalenga letigini, tere huwanyatege tigini ngalenga dedu bonade tere ninatege nga bagu uwa wonga, tere edo ji fik nauge ono tunaha dorofe ono wagu ganga. Onodu tere wahanga ada ono wagu. Uwa. Tere muju beha benou letubonade wonga, ‘Ne jaidu bonahe talagedu hiiri langa minau,’ ono wadenga no onou ono wonbona. ");
INSERT INTO eri_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Onodu tere huwanyatege ngalenga wonga hauya bonade wonga, tere dada oruwa tei nomo boya hauyaya waha, tere taagu ganga.” ");
INSERT INTO eri_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus no tempel nomo orei huwanya langa goidu bona, fai-aita bagu isisiwou nigai. Ono gainga nere pris aroro bagu, Israel nebere mora bagu, maidu bode isoki tuwane, “Ne unyite anyakaro bagu danga bagu alanga elegne boni, dada waha ononi? Onodu danga waha faiwei hinidu haruwe waha tei nomo le hinai?” ");
INSERT INTO eri_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ono wanenga Yesus no beele ege gidu lenigai, “Ji fere dada ete boni isoki tigonboni. Ono wehenga, tere yame beele tigini ege gidu le hiyei mata wadenga wa, ji fere faiwei no unyife anyakaro haruwe beha tei nomo le hiyai waha letigon boni. ");
INSERT INTO eri_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sain Jon no yaage bisemu nigai, no onowou waha alanga tai? Wa ha laluwa nomo dada yo, uwa fai neberenga dada?” Ono wainga nere beele waha isidu bode nere nage-nage leguruwane, “Ere benou lewoya, ‘Wa ha laluwa nomo dada iwoya wa,’ no benou isoki higon bona, ‘Onou wa tere taate boya no bona huwanyatege ngalenga wegu uwa?’ ");
INSERT INTO eri_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ariya ere benou leboya wonga, ‘Wa fai neberenga dada,’ iwoya wa, ere nere fai-aita bagu umuge nigoboya. Wa taate bona, nere oruwanga ninanege iside, Jon no profet.” ");
INSERT INTO eri_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Onou waha bode nere beele ege gidu Yesus letuwane, “Ere ada isiya.” Ono wanenga Yesus no lenigai, “Ji fere faiwei no unyife anyakaro hiyai waha ji ada letigon boni.” ");
INSERT INTO eri_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus no pris aroro bagu, mora bagu ege onou lenigai, “Ariya tere adadu isiya? Fai ete no nomo idau gane nga. No goidu bona idau motuwa benou letuwai, ‘Yame magana, ne elebe wain haga la goidu bonahe haruwe tau.’ ");
INSERT INTO eri_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ono wainga idau motuwa umamu letuwai, Jijei, ji awani, onodu iinga no ninau ege ubuludu wain haga la goyai. ");
INSERT INTO eri_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ariya umamu no ege idau menakele bagu goidu beele onounga letuwai, Ono wainga idau no umamu letuwai, ‘Yoo jijei,’ Ariya no wain hagala goyei uwa. ");
INSERT INTO eri_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ariya idau gane nga waha, faiwei no umamu bolou tigini oojowai?” Ono wainga nere lewane, magana motuwa waha. Ono wanenga Yesus no lenigai, “Ji tere ngalenga letigini, nere fai takis tegou bagu, nere aita longi tafa bode golo gou bagu, nere waha tere feiya tigidu bode nere amugedu Itou nomo huuna la yafou waha la yafodbode. ");
INSERT INTO eri_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Taate bona, Jon yaage bisemu nigi gou no tere bagu mayai waha no onowou hilobainga abitimu tigai. Ariya tere no boya huwanyatege ngalenga wegu uwa. Ariya nere takis tegou fai bagu, nere longi tafagou aita bagu, nere Jon yaage bisemu nigigou bode huwanyanege ngalenga wane. Ariya tere waha ureye, onodu tere ege ninatege ubuludu boya, no boya huwanyatege ngalenga wegu uwa.” ");
INSERT INTO eri_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus no fai aroro ege benou lenigai, “Tere muuji beele ete isagu. Fai ete no wain haga tedu bona orei atai. Onodu bona haga huwanya langa, no wain fatu ilei gonga furususuwei nomo u-u ete tenk dorofe konodu bona, no mata ete, nere fai walanga yafabode haga oofawei nomo bona tafai. Onodu no haga waha fai ila moni kusewei nomo owonege langa tafai. Onodu no matane ete baae langa goyai. ");
INSERT INTO eri_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ariya wain nauge hilou heigei nomo saini jugu gainga, no nomo haruwe magana huuru nigainga, nere no nomo wain hilou elege fuwei nomo bode wain haga langa goyane. ");
INSERT INTO eri_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ono wai wa, nere fai haga langa haruwe taane waha, nere no nomo haruwe magana hanigedu bode, ete wari bode, ete dukote wanenga ume gainga, ete megebu ayarudu warane. ");
INSERT INTO eri_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ono wanenga iinga, haga morou no haruwe magana ila huuru nigainga nere bagu goyane. No menanga baingaro huuru nigai, no amina huuru nigai waha feiya tuwou. Ono wainga nere fai haga langa haruwe taane waha, nere haruwe magana waha fere onounga ono nigane. ");
INSERT INTO eri_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ariya iinga haga morou no, nomo idau huuru tuwainga nere bagu minai. Onodu no lewai, ‘nere ji yame Idafe nomo bolou oojo wodbode.’ ");
INSERT INTO eri_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Onou wa, nere haruwe fai nomo Idau maigainga uredu bode, nere nage-nage benou leguruwane, ‘fai beha, no umamu nomo dada oruwanga elegon bona, awadenga ere dukotedu boya, ere haga beha toboya.’ ");
INSERT INTO eri_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Onodu bode, nere yaasu tudbode wain haga dui langa te kaite tuwanenga goyainga, dukote wane. ");
INSERT INTO eri_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ariya Yesus no nere isoki nigai, tere adadu isiya? Saini wain haga morou nogo mayona waha, no wain haga oofagou haruwe fai adadu ono nigonbona?” ");
INSERT INTO eri_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ono wainga nere letuwane, “No fai inyaba waha tigini, inyabamude nigonbona. Onodu bona no wain haga waha, fai ila nigonga oofa wodbode, onodu da faasi wei nomo saini langa, nere da komomudu bode, no tuwod bode.” ");
INSERT INTO eri_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Onodu Yesus no benou isoki nigai, “Tere Itou nomo buk langa beele matau inyina waha lelegegu uwa rute? Beele waha no benou, ‘Nere mata taugou fai, nere megebu inyaba idu bode te kaitane waha, elebe megebu waha no mata gulu langa mata orei dangamuwei nomo megebu amugou. Anyakaro no nogo dada waha ono wanga heiganga ureyaha, no gai hilobainga.’ ");
INSERT INTO eri_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Onou waha boni ji tere letigini, Itou no nomo huuna langa yafou waha tere owotege langa ngatege tedu bona, nere fai-aita ani nere Itou nomo huuna langa yafei nomo kauni heigemude waha nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Onodu fai no megebu waha jaula langa mebodu wona wa, no furususudu memejira kura wonbona. Onodu megebu waha no fai ete jaula langa meboduwei mata wonga wa, megebu waha no gai inyabamu de tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nere pris aroro bagu nere Farisi bagu, nere Yesus no muuji beele lewai waha isidu bode, no nere bona lena wou nere isane. ");
INSERT INTO eri_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Onou bode nere Yesus yaasu tuwei nomo gau nigai, ono wane wa, nere fai-aita bagu bode umugane, wa taate bona, fai-aita bagu nere isane, Yesus no profet. ");
INSERT INTO eri_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus no ege fai aroro muuji beele ete benou lenigai, ");
INSERT INTO eri_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ha laluwa nomo huuna la yafou no king ete nomo onowou dorofe. Nomo idau aita tona ono gonga, king no da anyakaro ajona bona. ");
INSERT INTO eri_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngasunga no fai ila, fai-aita ngare teguruwei nomo da anyakaro ajou langa yafei nomo ngado nigai. Onodu da nyei nomo fati waha langa, no haruwe magana fai nere waha hanigei nomo huuru nigai. Ono wainga nere mayei nomo awane. ");
INSERT INTO eri_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ono wanenga no ege nomo haruwe magana ila huuru nigi bona benou lenigai, ‘Tere goidu bonade fai ji ngado nigene waha benou lenigagu, “Tere isagu. Ji dada amina haiyanaha. Yame bulmakao madowa bagu, kaafa genege ngasagou ila bagu ere dunege kote boroyaha. Onodu dada oruwa haiya boronaha inyina. Waha bona tere fai-aita bagu te guruwou da waha la mayagu.” ’ ");
INSERT INTO eri_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ono wanenga haruwe magana goidu fai waha lenigane, ariya nere isei nomo awadu heige harawane. Fai ete nomo haga langa goyai, ete nomo moni haruwe tona goyai. ");
INSERT INTO eri_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ariya fai ila nere king nomo haruwe magana tatari nigidu danga bagu, narigedu dunege kote wanenga umeru wane. ");
INSERT INTO eri_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ono wanenga king no houmu mayainga, nomo oota fai huuru nigainga goidu bode, nere fai nomo haruwe magana dunege kotewane waha, dunege kotedu usumu nigane. Onodu matane biti nagane. ");
INSERT INTO eri_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Onodu bona king no nomo haruwe magana lenigai, ‘Fai-aita bagu te guruwei nomo ajou anyakaro haiya boro naha inyina, fai lenigene waha nere da beha langa mayei nomo fai hilou uwa. ");
INSERT INTO eri_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Onou waha bona, tere goidu jala hao oruwa la oto wagu, onodu fai oruwanga nerige bonade, lenigadenga maidu bode aita fai ngare te guruwou nomo ajou anyakaro la yafode.’ ");
INSERT INTO eri_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","No onou lenigainga, nere goidu bode jala hao oruwa la oto bode, fai baingaro, inyaba bagu hilou bagu komomu nigidu bode, leniganenga mayane. Nere waha maidu bode ajou anyakaro la yafanenga haumu bolowai. ");
INSERT INTO eri_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ono ganenga, king no fai waha nerigonbona gamu goyai. No fai waha fele-fele nigi bona, fai ete no fai-aita bagu te guruwou fati langa kolos hilou langa mujaride onou mujariwei uwa urai. ");
INSERT INTO eri_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Onodu king no fai waha isoki tuwai, ‘Eei, baabo ne adadu boni kolos hilou la mujariwei uwa gomu mainaha?’ Ono wainga, fai waha no king beele ete letuwei uwa. ");
INSERT INTO eri_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ono wainga king no haruwe magana lenigai, ‘Tere fai beha owo afo bagu maalu la dage tudu, malala agugu la kaite tuwagu. Agugu haumu waha langa nere merei nomo lali bode manege gidodo‑gidodode.’ ");
INSERT INTO eri_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Isagu, Itou no fai baingaro yaure nigi-nigina, ariya no fai etenga-etenga wahanga, nere huwanya mayei nomo hangada nigi-nigina.” ");
INSERT INTO eri_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi nere Yesus kot la tafa tuwei nomo jala kuru bode beele ngado wane. Nere Yesus yaawa tuwogunga, no beele ete nyabulu wonga, nere no nogo nomo beele langa no kot langa tafa tuwei nomo bode ninanege isane. ");
INSERT INTO eri_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Onodu bode, nere nebere disaipel bagu, Herot nomo fai ila bagu, huuru niganenga Yesus bagu goidu bode, benou letuwane, “Isisi higigou fai, ere isiya, ne beele ngalenga tigini legou. Ne ngalenga beele langa, fai-aita bagu Itou nomo onowou boni isisiwou nigi-nigini. Ne fai ete boni ada umuge umugeni. Uwa. Ne fai oruwa la, beele onounga leleni, edo nere unyinege bagu yo, nere unyinege uwau. ");
INSERT INTO eri_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Waha bona ne lehigau. Ne adadu isini? Ere edo Sisa takis tuwoya yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ariya, Yesus no nebere ninanege isou inyaba waha amina isai, onodu lenigai, “Tere yaawa wou fai, tere taate boya ji wala-wala hiya?” ");
INSERT INTO eri_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Onodu bona, no lenigai, “Tere takis tafa‑tafaya waha moni ete abitimu hiyadenga uroni.” Ono wainga, nere moni ete tamaidu tuwane. ");
INSERT INTO eri_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ono wanenga Yesus no isoki nigai, “Be faiwei nomo anu bagu, nomo unyi bagu inyina?” ");
INSERT INTO eri_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ono wainga nere letuwane, “Sisar nomo.” Ono wanenga Yesus no lenigai, “Ariya, Sisar nomo dada waha tere Sisar tuwagu. Itou nomo dada waha tere Itou tuwagu.” ");
INSERT INTO eri_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Onou lenigainga, nere beele waha isidu horoto wane. Onodu bode, nere Yesus awa tudu harawane. ");
INSERT INTO eri_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Fati wahanga la, nere Sadyusi Yesus bagu heigane. Nere fai waha le-lede, nere fai umeru wane waha ege ada jayode bode. Ariya nere Yesus benou isoki tuwane, ");
INSERT INTO eri_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Isisi gou fai, Moses no benou lewai, ‘Fai ete no magana uwau langa umei mata wonga, bemu no oyomu tedu bona nomo magana heigemu wonbona, ono wonga bemu nomo ganemuha fai ada usu wona.’ ");
INSERT INTO eri_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ariya amina nere bemu-bemu 7, ere gama langa yafane. Onodu amugou no aita tedu yafa bona no umaiha, ariya no magana uwau. Ono wainga nomo bemu no nomo oyomu tai. ");
INSERT INTO eri_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Onodu bemu mogo tagawou fere magana uwau langa umai, onodu ei fere onounga, goi 7 langa edo wai. ");
INSERT INTO eri_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nere oruwa umeru bore wanenga, gai huunta langa aita fere umaiha. ");
INSERT INTO eri_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ariya ne lewau. Saini nere fai umedu ege gidu jayane la, aita waha no nere bemu-bemu 7, waha langa faiwei nomo aita tigini yafonbona? Ne isini, nere oruwanga no te tuwane.” ");
INSERT INTO eri_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ono wanenga Yesus no beele ege gidu benou lenigai, “Tere hilou beele Itou nomo buk la inyina waha ada isiya. Onodu tere Itou nomo danga boya fere ada isiya. Onou waha boya tere beele le nyabulu ya. ");
INSERT INTO eri_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Saini fai umeru wane waha ege gidu jayode langa, nere fai-aita bagu ada te guru wode. Uwa. Nere ha laluwa nomo ensel dorofe yafodbode. ");
INSERT INTO eri_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Onou wa, fai umedu ege gidu jayei nomo beele waha, ji tere isoki tigon boni. Itou no beele tere bona lewai waha, tere lelegegu uwa rute? No benou lewai, ");
INSERT INTO eri_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ji Abraham nomo Itou, ji Aisak nomo Itou, ji Jekop nomo Itou.’ Itou no nere umou fai nebere Itou uwa. No fai agenege auma yafade waha nebere Itou.” ");
INSERT INTO eri_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ono wainga, nere fai-aita bagu waha isidu bode, nere nomo beele bode horoto wane. ");
INSERT INTO eri_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saini Farisi nere, Yesus Sadyusi beele langa huranege fosokomu nagaha iwou isidu, nere no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nere gama la, fai ete no nuuni beele nomo isou fai. No Yesus wala-wala tuwei nomo bona benou isoki tuwai, ");
INSERT INTO eri_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Isisiwou fai, nuuni beele adoha no amugou, onodu nuuni beele oruwa feiya nigou?” ");
INSERT INTO eri_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ono wainga Yesus no letuwai, “ ‘Tere Itou gau tuwagu, ere ebere Anyakaro. Tere tigini tebere huwanyatege langa, tebere hauri langa, tebere ninatege langa, gaude tuwagu.’ ");
INSERT INTO eri_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nuuni beele beha no anyakaro, onodu no gai tigini amugou. ");
INSERT INTO eri_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ariya, nuuni beele nga langa fere onounga. Waha benou, ‘Ne nage boni gau hinina dorofe ilibane gane bonahe fere gau hinou.’ ");
INSERT INTO eri_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nuuni beele nga beha, nere nuuni beele oruwa nebere, onodu profet nebere beele hugu.” ");
INSERT INTO eri_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi nere komodu yafa ganenga, Yesus no isoki nigai, ");
INSERT INTO eri_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tere fai Itou no nomo fai-aita bagu gidu hanigei nomo hangada tuwai waha boya adadu isiya? No faiwei idau?” Ono wainga nere benou letuwane, “Devit Idau.” ");
INSERT INTO eri_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ono wanenga, Yesus no benou isoki nigai, “Ariya, onou waha adadu bona Hauri Guuni no Devit ninau tuwainga Devit no fai waha ‘Anyakaro’ tuwai? Devit no benou lewai, ");
INSERT INTO eri_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anyakaro no yame Anyakaro benou letuwai, “Ne yame owofe hilou langa yafa gahenga, goidu saini ji name honggoro fai, name huuna langa logosi nigehe yafode langa edo wonbona.” ’ ");
INSERT INTO eri_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tere uragu. Devit no nogo fai waha yame Anyakaro iwai. Ariya adadu bona fai waha no Devit idau?” ");
INSERT INTO eri_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ono wainga nebereha ete no Yesus nomo beele ege gidu letuwei nomo edo uwa. Onodu, fati waha la hugu waridu, nere ege Yesus dada ete bode isoki tuwei nomo umugane. ");
INSERT INTO eri_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iinga, Yesus no fai-aita bagu nomo disaipel bagu, beele malalamudu lenigai. ");
INSERT INTO eri_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","No benou lewai, “Nere nuuni beele isou fai bagu, nere Farisi bagu, nere nuuni beele isisiwou tigi-tigide, Moses onowai dorofe. ");
INSERT INTO eri_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Onou waha bona, beele oruwanga nere letigide waha, tere isidu bonade oojo wagu. Ariya onowou nere ono-onode waha tere adai oojo wagu. Uwa. Nere beele baingaro le-lede, onodu nere nage ada oojo-oojode. ");
INSERT INTO eri_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nere dada ou bagu ngaradu bode, fai boilanege langa aulemu nigi ganenga, fai nere aulei nomo haruwe danga tetede dorofe. Onodu nere nage, menanga hoyo nigidu aulei nomo owonege ada nigi-nigide. ");
INSERT INTO eri_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nere dada oruwa ono-onode wa, nere ono wogunga fai nerigei nomo bode. Nere hauyawou wele aroro dage-dagede, onodu nebere kolos ufaroro mutu langa string ufalai dage dagede. ");
INSERT INTO eri_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nere ajou anyakaro langa, sia hilobainga waha tei nomo gaude nigi-nigina, onodu bori mata langa yafei nomo haumu fere onounga. ");
INSERT INTO eri_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nere fai-aita bagu komowou haumu langa kaiye nigei nomo gau nigi-nigina, onodu nere ‘Isisiwou fai nigei nomo bode, gaude nigi-nigina.’ ");
INSERT INTO eri_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Onou wa, nere fai tere ‘Isisiwou fai adai tigode.’ Uwa. Etenga nogonga no tere tebere isisi tigi gou fai, ono ganga tere oruwanga bemu-bemu yafaya. ");
INSERT INTO eri_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ono bonade, oula belanga fai ete te no tebere jijei adai tuwagu. Etenga mene ha laluwa langa yafana waha, no tebere Ametege. ");
INSERT INTO eri_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Onodu tere ‘Mora bagu,’ adai tigogu. Tere tebere mora bagu etenga nogonga wa, fai Itou nogo fai-aita bagu gidu hanigei nomo hangada tuwai. ");
INSERT INTO eri_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tebere fai Anyakaro no tebere haruwe fai yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Fai no nogo unyi isouna waha, no nomo unyi esene minona bona. Onodu fai nogo nomo unyi esenemuna waha, no unyi anyakaro tonbona.” ");
INSERT INTO eri_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Yesus no ege benou lewai, “Tere nuuni beele isou fai bagu, Farisi bagu, tere ure dewagu. Tere fai huratege nga bagu. Tere fai-aita bagu hogonege langa, ha laluwa nomo huuna langa yafou waha, jauli sesemu nagi-nagiya. Tere tage huwanya ada goi-goiya. Ariya nere fai-aita bagu huwanya goyode ono ganenga, tere nebere jala taa nagi-nagiya. ");
INSERT INTO eri_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tere nuuni beele isou fai bagu, Farisi bagu, ure dewagu. Tere huratege nga bagu. Tere fai etenga nogonga awa tuwadenga tebere disaipel heigei nomo boya, tere hiiri oruwa, oula oruwa langa golo-goloya. Saini no disaipel heiganga, tere no ono tugeyenga tere tage dorofe eeya ha langa goyei nomo fai dorofe heige heigena. Tere ono tugeyenga no onowou inyaba tere feiya tigou ono-onona. ");
INSERT INTO eri_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tere agetege fosokowou, tere fai jala abitimu nigagu ganga ono onoya, tere ure dewagu. Tere benou le-leya, ‘Fai no Itou nomo mata bona ledu, ngalenga tigini ouwe la iwona wa, wa dada ewe. Onou wa, fai no gol Itou nomo mata la inyina idu, ngalenga tigini ouwe la iwona wa, no tigini lewaha onou ono wonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tere dabu taidu agetege fosokowou, Taate dada no Itou ago la amugou? Gol yo, uwa, Itou nomo mata? Tere isiya, gol no Itou nomo mata langa inyina, wahanga ono tuganga gol no Itou nomo dada heige heigena. ");
INSERT INTO eri_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Onodu fere tere le-leya, ‘Fai no alta bona ledu, ngalenga tigini ouwe langa iwona wa, wa dada ewe. Onou wa, eeya muru wari fugou dada alta ouwe langa inyi gonga ngalenga tigini iwona wa, ariya, wa no tigini lewaha onou ono wonbona.’ ");
INSERT INTO eri_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tere agetege fosokowou, taate dada no Itou ago langa amugou? Eeya muru warou dada yo, uwa alta no amugou? Tere isiya, toota eeya muru warei nomo da dada alta langa otode, waha no ono ganga eeya muru warou no Itou nomo dada heigena. ");
INSERT INTO eri_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Onou waha bona fai no alta unyi te bona lena, ngalenga tigini ouwe la, onona wa no alta nomo beele bagu, dada oruwanga ouwe langa inyina waha bagu dangamuna. ");
INSERT INTO eri_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Onodu fai no Itou nomo mata waha unyi tedu bona lewona, ngalenga tigini ouwe langa, onona waha, no nomo beele Itou nomo mata bagu, Itou nogo mata langa yafana waha dangamuna. ");
INSERT INTO eri_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ariya, fai no ha laluwa unyi te bona lena, ngalenga tigini ouwela, wa no nomo beele Itou nomo sia langa, Itou nogo sia waha langa yafana waha dangamuna. ");
INSERT INTO eri_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tere nuuni beele isou fai bagu tere Farisi bagu, ure dewagu. Tere huratege nga bagu. Haga nomo sayori dada mene-mene oruwanga waha, tere matau 10 langa wesedu boya, etenga ulate waha Itou tutuya. Onou wa tere nuuni beele ulate anyakaro oruwa waha aweyeha, wa onou, fai haawe nigei nomo onowou tigini nomo beele bagu, augami guruwei nomo fanyimu bagu, onodu huwanyage ngalengawei nomo fanyimu. Hilobainga tere nuuni beele anyakaro waha oojowei nomo danga tafa boya, nuuni beele ila fere awegu uwa. ");
INSERT INTO eri_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tere fai agetege fosokowou, tere fai jala abitimu nigoya onoya, tere fai nomo oore langa kakadi menakele mene waha uredu, te kaitona onona dorofe. Onowai waha no kamel oore langa inyai waha urei uwa, no nyidu bona, tigini nyikulu-wai dorofe. ");
INSERT INTO eri_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tere nuuni beele isou fai bagu Farisi bagu, ure dewagu. Tere fai huratege nga bagu. Tere kap plet bagu aula la wahanga huge deya, ariya huwanya langa da dada tafaya waha tere tagenga boya isi boya, yebu fanyimu langa elege elegeya. ");
INSERT INTO eri_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ne Farisi, ne agene fosokowou. Ne kap huwanya amugedu hugau, ono wahenga nomo aula langa fere eege heigonbona. ");
INSERT INTO eri_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tere nuuni beele isou fai bagu, Farisi bagu, tere ure dewagu. Tere fai huratege nga bagu. Tere matmat gorenga kaamba langa kiyo wane dorofe. Malala langa nomo urou hilobainga, onou wa, huwanya langa fai umou ngedenege bagu, dada jijiga bagu oruwa bolowou inyina dorofe. ");
INSERT INTO eri_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tere fere onou dorofenga yafaya. Nere fai tebere getege gala uredu bode ninanege iside wa, tere fai tigini. Onou wa huwanyatege langa tere yaawa wou bagu, nuuni beele feiyawou nomo fanyimu bolo tigou.” ");
INSERT INTO eri_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesus no ege benou lewai, “Tere nuuni beele isou fai bagu, Farisi bagu, tere ure dewagu. Tere fai huratege nga bagu. Tere profet nebere matmat hilobainga tafa nagi-nagiya, onodu fai tigini nebere matmat mujarimu nagi-nagiya. ");
INSERT INTO eri_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Onodu boya tere leya, ‘Ere asaage gane nebere saini langa yafedege wa, ere hoyo nigidu profet dunege ada kote wedege.’ ");
INSERT INTO eri_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Beele waha langa tere tage benou abitiya, tere fai profet dunege kote wane waha nebere idanege gane dorofe. ");
INSERT INTO eri_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ariya, tere fasayadu goidu bonade tebere asatege gane nebere onowou inyaba edomu wagu. ");
INSERT INTO eri_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tere maangi inyaba. Itou no tere kot langa tafa tigonga tere umou ha langa goyagu ganga. Onodu tere adadu hilou yafagu? ");
INSERT INTO eri_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Onou waha bona tere isagu. Ji profet bagu, nere fai ninanege hilou bagu waha, nere nuuni beele isou fai bagu, huuru nigehenga tere bagu mayodbode. Ono wehenga, tere ila dunege kote wagu ganga, ila nauge abalakawou la narigagu ganga, ila tebere bori mata huwanya la tolo nigagu ganga. Ono bonade tebere taon la so nigadenga nere haradu taon fere langa goyodbode. ");
INSERT INTO eri_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Onou waha bona nere fai oruwanga, fai nere genege beele uwau oula belanga yafa ganenga dunege kote wanenga umeru wane waha, nebere nyabuluwou wa terenga la inyonbona. Abel langa hugu waridu mai Sekaraia, Berekia idau langa edo wai, fai waha no tere Itou nomo mata bagu, alta bagu gama langa dukote weyenga umai, onou bona tere tage onowou inyaba beha nomo ou aulagu ganga. ");
INSERT INTO eri_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ji ngalenga letigini, Onowou inyaba beha nomo agou inyaba oruwanga elebe fai-aita bagu yafaya saini beha langa heigonbona.” ");
INSERT INTO eri_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, ne profet dunege kote genenga umeru umerude, ono boni Itou no nomo haruwe fai, ne bagu huuru nigi ganga maide waha, hanigedu dunege kotewei nomo boni megebu aya nagi nagini. Saini baingaro ji name magana elegedu komomu nigei nomo ononi. Teewe anya nomo magana hadimu la kuromu nigina dorofe. Ariya tere awa awaya. ");
INSERT INTO eri_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Isagu. Elebe tebere matane inyabadu ewenga inyonbona. ");
INSERT INTO eri_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ariya ji benou letigini, Tere ji ege ada yeriyagu ganga, goi saini tere lewagu ganga, ‘Itou no edo, fai Anyakaro unyi langa maina waha figini tuwonbona.’” ");
INSERT INTO eri_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus no tempel awadu bona goyai. Ono gainga, nomo disaipel nere, no tempel mata abiti tuwei nomo bode, no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ono wane wa, no beele beha lenigai, “Tere mata hilou-hilou beha oruwanga ureya yo? Ji tere ngalenga letigini, nere megebu ete te, ada awo gonga megebu ete jaula langa inyonbona. Nere oruwanga koresedu bode, elegedu ayaru wogunga minona bona.” ");
INSERT INTO eri_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus no Oliv muju langa yafai, ono gainga nomo disaipel nere nagenga no bagu maidu bode isoki tuwane, “Ne ere lehigau, agoi nere dada waha heigod bode? Taate naani amugedu heigon bona, ono wonga ere isoboya, ne ege gidu mayoni ono genenga oula beha usu wona onona?” ");
INSERT INTO eri_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ono wanenga Yesus no ege gidu lenigai, “Tere ure dewagu. Gamaji fai ete yaawa tigoga. ");
INSERT INTO eri_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Taate bona fai baingaro nere maidu bode nere ji unyife te bode lewodbode, ‘Ji fai beha, Itou no fai-aita bagu ege gidu hanigei nomo beele agili mala karuwai waha.’ Ono bode nere fai-aita bagu baingaro yaawa nigodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tere oota anyakaro bolou aagu gadenga, oota anyakaro heigena iwou beele ananu isagu ganga. Tere ure dewagu. Tere adai horoto wagu. Dada waha tigini heigon bona, onou wa fati usuwou heigei uwa. ");
INSERT INTO eri_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Fai ila jaidu fai fereha bagu oota jaimu wodbode. Onodu king ete nomo fai jaidu, king ila nebere fai bagu oota jaimu wodbode. Ha ila langa nere maau saini anyakaro, ono gonga oula mimi monbona. ");
INSERT INTO eri_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dada beha nere, aita magana bisei nomo bode amugedu jimiri tede dorofe. ");
INSERT INTO eri_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Saini waha langa nere, tere jimiri bagu, ou bagu, tigei nomo bode hatigode bode, onodu dutege kote wogunga umeru wagu ganga. Ono wogunga nere fai-aita bagu oruwa, tere bode huwanyanege inyaba wodbode, taate bona, yame unyife tere langa inyina. ");
INSERT INTO eri_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ono gogunga saini waha langa, fai-aita bagu baingaro ji bode huwanyanege ngalenga wai waha ege awod bode, onodu nere nage-nage honggoro guru bode, nere nage honggoro fai owonege langa tafa guru wodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ono gogunga, yaawa profet baingaro nere jaidu bode, fai-aita bagu baingaro yaawa nigodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Onowou inyaba anyakaro heigonbona, onou waha bona, fai baingaro gaude guruwou fanyimu awodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Onou wa, fai-aita bagu nere danga tafadu yafa gogunga goi fati usuwou la heigona wa, Itou no ege gidu hanigon bona. ");
INSERT INTO eri_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ono wogunga, nere Itou nomo huuna langa yafou waha nomo hilou beele, ha-ha oruwa langa malalamudu legogunga, nere fai-aita bagu oruwanga edo isodbode, waha mogo langa fati usuwou heigon bona.” ");
INSERT INTO eri_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus no ege benou lewai, “Dada gai inyaba amina profet Daniel no lewai waha, Itou nogo nomo mata langa oto gonga uragu ganga.” Fai ete no beele beha lelegena waha, no isi dewou. ");
INSERT INTO eri_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Saini waha la, fai-aita bagu Judia distik langa yafade waha, nere edo haradu ha muju bagu la manode. ");
INSERT INTO eri_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Fai ete no nomo mata ouwe la yafa bona wonga, saini no heige bona nomo dada jauli la elegei nomo ninau adai isou. ");
INSERT INTO eri_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Fai ete no nomo haga la golona waha, no ege gidu matane maidu, nomo mata la kolos ufaro adai tou. ");
INSERT INTO eri_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Saini beha la, nere aita genege bagu waha, nere aita magana momodo eeme aare nigide waha agenege gami bagu. ");
INSERT INTO eri_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tere hauya wagu, onou ono bonade wonga, tere uliya saini la, Bori saini la, ada hara wagu. ");
INSERT INTO eri_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Saini waha langa ou anyakaro heigonbona. Saini oula eege langa maidu elebe langa ou onouha ete amiha heigei uwa. Onodu huunta langa fere ou onouha ege ada heigona. ");
INSERT INTO eri_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Onodu Itou no ou waha nomo saini ada tutumuwou wage, wa fai-aita bagu oruwanga yaae wage. Onou wa no fai-aita bagu amina hangada nigai waha bona ninau isai. Waha bona no saini waha tutumu wonbona. ");
INSERT INTO eri_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Saini waha langa, fai ete no tere letigon bona, ‘Uragu, fai Itou no nomo fai-aita hanigei nomo hangada tuwai waha, benu yafana’, o ‘wonu yafana. Ono wogunga’, tere nebere beele bonade huwanyatege adai ngalengawou. ");
INSERT INTO eri_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Taate bona, fai ila maidu bode, yaawa beele benou letigod bode, ‘Ji fai beha Itou nomo fai-aita bagu gidu hanigei nomo hangadawai,’ o ‘profet ete.’ Onodu nere dodokawou aroro tafa bode, dada hogo fere-fere ono wogunga heigon bona. Nere fai-aita bagu baingaro hilalamu nigei nomo ono wodbode, nere edo wonga wa, fai-aita bagu Itou nogo nomo hangada nigai fere hilalamu nigei nomo ono wodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Onou waha bonade tere isagu. Ji dada waha oruwa iinga huunta la heigon bona waha boni ji letigi borowene. ");
INSERT INTO eri_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Onou waha bona, nere benou letigi bode wonga, ‘Uragu. No ha ete fai uwau la yafana,’ ariya tere ha walanga adai goyagu. Onou wa, nere letigod bode, ‘Uragu. No mata waha huwanya langa yafana,’ ariya tere nebere beele waha bonade, huwanyatege adai ngalengawou. ");
INSERT INTO eri_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tere isiya, saini amili fililai na waha, nomo lala hoonga mayou la heigedu tigini laladu hoonga minou la mini-minina. Ariya Fai Nomo Idau mayona la, no onounga ono wonbona, ono gonga fai-aita bagu oruwanga urodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Haumu fai umeru wane waha, genege gala jiride langa mojenga maidu haumu wahanga la komo-komode.” ");
INSERT INTO eri_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesus no ege onou lewai, “Ou anyakaro nomo saini waha usu gonga, ariya fasayadu onou, hoonga agugu wonbona, ono gonga ole ada lala wonbona, ono gonga baatu taene awa tudu orososo wodbode, ono gonga taene nomo dada danga bagu inyide waha terere wodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Saini waha langa, Fai Nomo Idau nomo naani taene langa heigon bona, ono wonga nere oula nomo fai-aita bagu oruwanga merode bode. Ono bode, nere Fai Nomo Idau no danga anyakaro bagu, lala anyakaro bagu ha laluwa nomo agau ouwe langa yafadu me gonga urodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Onodu bona, no nomo ensel huuru nigonga, nere bigul bolou anyakaro bagu medu bode, fai-aita bagu no nomo bona hangada nigai waha komomu nigodbode. Nere goi oula mutu gai usuwou langa edodu bode, hanigedu mayodbode.” ");
INSERT INTO eri_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesus no ege onou lewai, “Tere dabu fik nauge langa isou taagu. Saini no nomo tuwa no yowo bagudu nomo gala ege fekuna wa tere alai, elebe hoonga hilou mayei nomo saini. ");
INSERT INTO eri_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Onou dorofenga, saini tere dada waha oruwanga heigonga ure bonade, ariya tere edo isagu ganga, Fai Nomo Idau mai jugu waha, arasai langa otona. ");
INSERT INTO eri_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ji tere ngalenga letigini, nere fai-aita bagu elebe saini beha nomo, nere umeru wegu uwa langa, dada waha oruwanga heigod bode. ");
INSERT INTO eri_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Taene oula bagu usu wonbona, ariya yame beele no ada usu wona.” ");
INSERT INTO eri_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Onou wa, fai ete te no fati waha, awa waha la, dada waha heigon bona waha isei uwa. Nere ensel ha laluwa langa ada iside. Idau fere no ada isina. Umamu nogonga no isina. ");
INSERT INTO eri_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Fanyimu nere Noa nomo saini langa ono wane, fanyimu onounga nere Fai Nomo Idau ege gidu mayei nomo langa ono wodbode. ");
INSERT INTO eri_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saini kuwei anyakaro heigei uwa inyi gainga, nere da nyi bode, yaage nyi bode, nere fai-aita bagu te guru ganenga, goi saini, Noa no waaga huwanya goyai la haawewai. ");
INSERT INTO eri_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dada waha nere la heigon bona nere isegu uwa, nere onounga yafa ganenga goi kuwei anyakaro heigedu bona, fai-aita bagu waha oruwa yosomu nigai. Onowou wahanga la, Fai Nomo Idau mayonbona la heigon bona. ");
INSERT INTO eri_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Fai nga nononga haga langa yafodbodere, ono gorunga Itou no ete hau bona ete awa tuwonga yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aita nga nononga wit flawa beret bitei nomo ubulu bodere yafa gorunga, Itou no ete hau bona, ete awa tuwonga yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Onou waha bona tere oofade wagu. Taate fati langa tebere Anyakaro mayona waha tere ada isiya. ");
INSERT INTO eri_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tere dada beha bonade ninatege isagu. Mata morou no, yebu fai ooru taate saini nomo mata langa mayei nomo amugedu isi bona wonga, no nomo mata oofa wonbona, no yebu fai awa tuwonga, nomo mata ada koraidu huwanya goyona. ");
INSERT INTO eri_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Onou waha bona, tere fere haiya wagu. Fai Nomo Idau no saini ete tere isei uwa langa no mayonbona.” ");
INSERT INTO eri_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Haruwe magana adoha no isou hilou bagu, onodu no haruwe hilou tetena? Haruwe magana onouha waha, nomo mora bagu haruwe magana ila oofa nigei nomo hangada tutuna, onodu nomo haruwe magana da nigei nomo saini tigini nomo mora bagu hangadawai onounga la nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Haruwe magana onouha waha, saini no haruwe te gonga nomo mora bagu ege gidu mai urona wa, no edo edega wona. ");
INSERT INTO eri_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ji tere ngalenga letigini, haruwe magana waha, mora bagu nomo dada oruwa oofawei nomo tafa tuwonga yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Onou wa, haruwe magana inyaba no nogo huwanya la ninau isonbona, ‘Anyakaro no fasadu ada mayonawou,’ ");
INSERT INTO eri_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","onodu no haruwe magana ilibumu gane narigou hugu wari bona, sipak fai ilibumu gane bagu da nyi bode yaage nyi gogunga. ");
INSERT INTO eri_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ariya fai anyakaro no fati ete la gidu mayonbona, saini no nomo haruwe magana haiyawei uwa la, onodu fati ete no isei uwa la. ");
INSERT INTO eri_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Onodu bona fai anyakaro no haruwe magana waha inyabamude tuwonbona, onodu no yaawagou fai bagu tafa tuwonga yafodbode. Wa nere fai huranege nga bagu. Haumu waha langa, nere mere bode manege gidodo wodbode.” ");
INSERT INTO eri_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Saini waha langa ha laluwa nomo huuna la yafou no aita magana 10 nebere aasa dorofe. Fai ete no aita eege tai, no mayonbona. Waha bona aita magana waha nere nebere lama elegedu, jalamu goyane. ");
INSERT INTO eri_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ariya aita magana anyimu kouwou ulate waha nere nyabulu wane, nere aita magana anyimu kouwou ete waha nere isou bagu. ");
INSERT INTO eri_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nere aita anyimu kouwou nyabulu wane waha, nere lama dada elegedu mayane, ariya hoyowou karasini ete yaasu wegu uwa. ");
INSERT INTO eri_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ariya nere aita anyimu kouwou isou bagu waha, nebere lama nomo karasini kuluma ete la lolobodu, lama bagu fadadu yaasu wane. ");
INSERT INTO eri_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ariya fai-aita iinga tai waha no fasadu mayei uwa, ono wainga nere aita oruwa agore nigainga nere agore jiri wane. ");
INSERT INTO eri_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ono ganenga ooru jege, fai ete benou yaurainga isane, ‘Fai, aita iinga tai waha amina maina. Tere mayagu, ere goidu boya jala gama toroba tudu boya haudu mayei nomo.’ ");
INSERT INTO eri_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ono wainga aita magana 10 waha oruwa jaidu bode, nebere lama dada haiya wane. ");
INSERT INTO eri_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ariya, nere aita nyabulu wane waha nere aita isou bagu waha benou lenigane, ‘Tere karasini menanga lolobo hagagu. Ere ebere lama gare wona onona.’ ");
INSERT INTO eri_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ono wanenga nere aita isou bagu waha nere aita isou uwau waha lenigane, ‘lama nomo karasini beha ere tere bagu lolobe guruwei nomo edo uwa. Onou waha bona, tere ege gidu goi tebere bonade situa la ejiya wagu.’ ");
INSERT INTO eri_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ono wanenga, aita anyimu kouwou nere nyabulu wane waha, karasini ejiyawei nomo bode situa la goi ganenga, Fai, aita iinga tai waha mayai. Ono wainga, nere aita anyimu kouwou isou bagu waha, nere haiya wane bode nere gaara mata huwanya langa goyane, fai aita ngare te guruwou neire ajou anyakaro la yafei nomo bode. Ono ganenga fai nere mata waha jauli sesemu wane. ");
INSERT INTO eri_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Iinga nere aita magana ila waha maidu lewane, ‘Anyakaro, anyakaro, ne jauli helufa hagau.’ ");
INSERT INTO eri_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ono wanenga no ege gidu lenigai, ‘Ji ngalenga letigini, ji tere boni ada isini.’” ");
INSERT INTO eri_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Onodu Yesus lewai, “Onou waha bona, tere oofa dewagu. Taate fati la, taate awa la tebere Anyakaro heigonbona tere ada isiya.” ");
INSERT INTO eri_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesus no ege benou lewai, “Ha laluwa nomo huuna la yafou no, fai ete matane bai langa golodu goyonbona dorofe. No nomo haruwe magana yaure nigainga mayane, ono wanenga no nomo dada nere owonege langa logosi wai, nere edo oofa fuwei nomo bona. ");
INSERT INTO eri_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","No haruwe magana etenga-etenga nebere onowou, nebere danga bona ninau isidu, no moni wese nagai. Fai ete no 5,000 kina tuwai, onodu ete 2,000 kina tuwai, ete 1,000 kina tuwai. No onou onodu bona no goyai. ");
INSERT INTO eri_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","No goi faga gainga, fasadu onou, fai no 5,000 kina tai waha langa, moni kusewei nomo haruwe tudu bona, no ege 5,000 kina ete heigemu wai. ");
INSERT INTO eri_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ono gainga, fai no 2,000 kina tai waha fere, no moni kusewei nomo haruwe tudu bona, ege 2,000 kina tai. ");
INSERT INTO eri_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ariya, fai no 1,000 kina tai waha, no oula konodu bona, nomo fai anyakaro nomo moni huwarimu fuwai. ");
INSERT INTO eri_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Saini ufaro goyainga, haruwe magana waha nebere fai anyakaro no ege gidu mayai. Onodu no moni nigai waha bona, nere bagu beele tiginimu wei nomo bona onowai. ");
INSERT INTO eri_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ono wainga, fai no 5,000 kina tai waha mayai, no moni 5,000 kina ege tai waha tamaidu bona letuwai, ‘Anyakaro, ne urau, ne 5,000 kina hiyene, ono wenenga ji moni kusewei nomo haruwe tudu boni, ege 5,000 kina tene.’ ");
INSERT INTO eri_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ono wainga, nomo fai anyakaro no letuwai, ‘Ne haruwe magana hilobainga, ne haruwe hilobainga tene. Ne name haruwe oofa dedeni. Ne dada mene-mene oofa dewene, onou waha bona, ne dada baingaro oofawei nomo ji gau hina. Ne maidu bonahe, ji bagu edega wau.’ ");
INSERT INTO eri_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ono gainga, “Fai no 2,000 kina tai waha no fere mayai, no maidu bona letuwai, ‘Fai anyakaro, ne urau, ne ji 2,000 kina hiyene, ono wenenga ji moni kusewou haruwe tudu boni, ji 2,000 kina ege tene.’ ");
INSERT INTO eri_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ono wainga nomo fai anyakaro no letuwai, ‘Ne haruwe magana hilobainga, ne haruwe hilobainga tene. Ne haruwe oofa dedeni. Ne dada menakele oofa dedeni, onou waha bona, ne dada baingaro oofawei nomo ji gaude hina. Ne maidu bonahe, ji bagu edega wau.’ ");
INSERT INTO eri_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ono gainga, fai no 1,000 kina tai waha, no fere maidu bona letuwai, ‘Fai anyakaro, ji alai, ne fai ngasu bagu, Ne haga langa da fai ila tataru wane waha, ne faasi-faasini. Onodu oula mutu ulate langa fai ete no da uwei ayaru wai langa, ne da waha langa elege-elegeni. ");
INSERT INTO eri_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Onou waha boni, ji umugedu name 1,000 kina waha oula langa huwarimu wene. Ne name moni benu.’ ");
INSERT INTO eri_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ono wainga nomo fai anyakaro no ege gidu letuwai, ‘Ne haruwe fai inyaba. Ne hogonyi narou. Ji haga nere fai ila da tataru ganenga faasi-faasini waha ne isi deni, onodu boni, ji da oula ulate fai ete no da uwei ayaruwai langa elege-elegeni. ");
INSERT INTO eri_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ariya, ne taate boni yame moni benk langa tafa hayei uwa? Ono wagenga saini, ji ege gidu maidu boni, ji edo langa yame moni nomo feuwou bagu teege. ");
INSERT INTO eri_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Waha bona tere 1,000 kina waha ngau tedu bonade, fai no 10,000 kina bagu waha tuwagu. ");
INSERT INTO eri_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wa taate bona, nere fai oruwa dada ila bagu, ji nere ege ila nigonboni. Ariya fai ete no dada uwau wonga, no dada menakele mene yaasuna waha, wa ji no ngaau tonboni. ");
INSERT INTO eri_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Onodu, haruwe magana inyaba waha tere no feta tuwadenga malala haumu agugu bagu langa goyona. Haumu waha langa nere meredu soso bode manege gidodo wodbode.’” ");
INSERT INTO eri_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesus no ege benou lewai, “Saini Fai nomo Idau no king dorofe, nomo ensel oruwa bagu gidu mayona waha, no nomo sia king la yafonbona. ");
INSERT INTO eri_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ono gonga, fai-aita bagu oruwa maidu bode no hogo la komo wodbode. Ono wogunga no fai-aita bagu oruwa haawe nga langa wesedu, fofoura nigonbona, fai kaafa oofa nigigou, sipsip ulate langa haawe nigidu meme ulate langa haawe nigina dorofe. ");
INSERT INTO eri_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","No sipsip owo hilou langa logosi nigi bona, meme owo kenau langa logosi nigonbona. ");
INSERT INTO eri_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Onodu bona, king no fai-aita bagu owo hilou la waha lenigon bona, ‘Tere ji yame Jijei nomo figiniwou bagu. No tere hilou tafa tigonbona. Saini oula iinga heige gainga, Jijei nomo huuna la yafou nogo amina haiyadu, hangada tagai waha, tere maidu taagu. ");
INSERT INTO eri_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Taate bona, amina ji huweli yafa genenga, tere da hiyei. Ji yaage nyomoli hiyainga, tere yaage hiyei. Ji yaao fai mayenenga, tere haifedu tebere mata la goyei. ");
INSERT INTO eri_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ji ogola uwau, wainga tere ogola hiyei. Ji taura inyi genenga, tere oofade hiyei. Ji dagou mata la yafa genenga, tere maidu yeriyei.’ ");
INSERT INTO eri_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nere fai-aita bagu genege beele uwau waha, nere Fai nomo Idau letuwod bode, ‘Anyakaro, agoi ne huweli hinainga, ere neriyedu da hineye? Agoi ne yaage nyomoli hinainga, ere ne yaage hineye? ");
INSERT INTO eri_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Agoi ne yaao fai mayenenga, ere hainedu boya ebere mata la goyeye? Agoi ne ogola uwau wainga, ere ogola hineye? ");
INSERT INTO eri_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Taate saini langa, ne taura bagu yo, ne dagou mata langa yafa gene, ere goidu neriyeye?’ ");
INSERT INTO eri_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ono wogunga king no benou lenigon bona, ‘Ji ngalenga letigini, tere dada oruwa yame baabo gane langa ete no menanga unyi uwau waha ono tuweye wa, tere ji ono hiyeye.’ ");
INSERT INTO eri_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Onodu king no nere fai-aita bagu owo kenao la waha lenigon bona, tere yaewou fai-aita, ‘Tere ji hogofe la heige haradu bonade eeya ada gare-garena la goyagu, eeya waha amina nere Satan nomo ensel bagu haiya nagane. ");
INSERT INTO eri_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Taate bona, amina ji huweli yafa genenga, tere ji da hiyegu uwa. Ji yaage nyomoli hiyainga, tere ji yaage hiyegu uwa. ");
INSERT INTO eri_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ji yaao fai mayene, ariya tere ji haifedu tebere mata la goyegu uwa. Ji ogola uwau wainga, tere ji ogola ete hiyegu uwa. Ji taura bagu, ji dagou mata langa yafene, tere maidu yeriyegu uwa.’ ");
INSERT INTO eri_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Onou wonga nere fere, beele onou gidu letuwod bode, ‘Anyakaro, agoi ere ne huweli hini gainga, yaage nyomoli hini gainga, ne ogola uwau yafa genenga, ne taura hini gainga, ne dagou mata la yafa genenga, ere ne figini hinei uwa? ");
INSERT INTO eri_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ono wogunga, king no nebere beele ege gidu benou lenigon bona, ‘Ji tere ngalenga letigini, tere dada nere fai-aita bagu menanga unyinege uwau beha langa, ono wegu uwa waha, tere ji langa fere ono wegu uwa.’ ");
INSERT INTO eri_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Onou waha bona nere fai-aita bagu waha, agou inyaba tei nomo bode goyodbode, agou inyaba waha, jimiri gai-gai te bode yafodbode. Ariya nere fai-aita bagu tigini waha, nere agenege auma gai-gai yafou waha todbode.” ");
INSERT INTO eri_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus no beele waha oruwa malalamudu lebordu bona, nomo disaipel benou lenigai, ");
INSERT INTO eri_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tere isiya, Fati Itou no Israel Awa Nigainga Yafa Dewane, waha Ninatege Isagu ganga, fati waha heigon bona fati ngaanga jiridere. Ono gonga, nere Fai Nomo Idau honggoro fai owonege langa tafa tuwogunga, nauge abalakawou langa tofiye tuwodbode.” ");
INSERT INTO eri_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Saini waha langa pris aroro bagu, Israel nebere mora bagu, pris anyakaro nomo unyi Kaiafas, nomo mata langa koto wane. ");
INSERT INTO eri_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Onodu bode, nere Yesus yaawa tudu taidu bode, dukote wogunga umei nomo jala kuru bode beele ngado wane. ");
INSERT INTO eri_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Onou wa nere lewane, “Ere dada waha bori nomo fati anyakaro langa ada onowoya. Gamaji nere fai-aita bagu uredu hounege mayonga oota jaimu woguga.” ");
INSERT INTO eri_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus no Betani matane Saimon nomo mata langa yafai, fai waha no amina kaba taura bagu. ");
INSERT INTO eri_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ono gainga, aita ete no megebu kuluma langa sanda hilobainga ete, nomo ejiyawou moni gai anyakaro, waha tedu bona Yesus bagu mayai. Onodu bona, saini Yesus no tewol langa yafa gainga, no sanda waha Yesus mora langa feuwai. ");
INSERT INTO eri_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ono wainga, nere disaipel waha uredu bode, huwanyanege inyabawai. Ono wainga nere lewane, “Taate bona sanda waha ewe heilena? ");
INSERT INTO eri_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ere sanda waha fai awa nagedenga ejiyawou wage, wa ere edo langa moni anyakaro tedu boya, nere fai dadanege uwau waha nigedege.” ");
INSERT INTO eri_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ono wanenga Yesus no nebere beele waha amina isai, onodu bona lenigai, “Tere taate boya aita beha ou tuya? No onowou hilobainga ono hiyaha. ");
INSERT INTO eri_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nere fai dadanege uwau waha, saini baingaro tere bagu yafodbode. Onou wa, ji nu tere bagu gai-gai ada yafon boni. ");
INSERT INTO eri_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aita no ji geefe gala langa sanda feuwai waha beha, no ji geefe gala matmat langa haiya bona ono waha. ");
INSERT INTO eri_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ji tere ngalenga letigini, nere oula oruwa langa goidu bode hilou beele beha malalamudu lewode langa, nere aita beha dada onowai waha fere lewodbode, ono bode nere no bode ninanege isodbode.” ");
INSERT INTO eri_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Saini waha langa nere disaipel 12 waha nebereha ete, nomo unyi Judas Iskariot, no pris aroro bagu goyai. ");
INSERT INTO eri_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Onodu benou isoki nigai, “Ji Yesus tere owotege langa tigi boni wonga, tere taate dada hiyagu ganga?” Ono wainga, nere silwa moni 30 onou tuwane. ");
INSERT INTO eri_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ono wanenga Judas no Yesus nere owonege langa nigonbona jala kuruwou hugu warai. ");
INSERT INTO eri_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Beret Yis Uwau Nomo Fati Anyakaro waha nomo fati amugou langa, nere disaipel Yesus bagu maidu bode letuwane, “Ere dada alanga haiyawei nomo gau hinina, ono wedenga, ne Itou no Israel Awa Nigainga Hilou Yafane waha nomo fati bona, ninate isei nomo da nyau ganga?” ");
INSERT INTO eri_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ono wanenga Yesus no fai ete bona ledu, lenigai, “Tere taon huwanya langa goidu, fai waha benou letuwagu, ‘Isisiwou fai lewaha, Yame saini amina jugu waha. Ji yame disaipel bagu name mata langa maidu Itou No Israel Awa Nigainga Hilou Yafane waha nomo da nyoboya.’ ” ");
INSERT INTO eri_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ono wainga disaipel nere Yesus lenigai onounga onodu bode, da haiya wane. ");
INSERT INTO eri_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ono wanenga esuwa Yesus no disaipel 12 bagu tewol langa yafane. ");
INSERT INTO eri_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nere da nyi bode yafa ganenga, no lewai, “Ji ngalenga letigini, tebereha ete no ji, honggoro fai owonege langa nigonbona.” ");
INSERT INTO eri_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ono wainga, disaipel nere beele waha isidu huwanyanege ou dewai, ono wainga nere etenga-etengadu benou isoki tuwou hugu warane, “Anyakaro, Ji boni leni yo?” ");
INSERT INTO eri_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ono wanenga no ege gidu benou lenigai, “Fai no ji honggoro fai owonege langa tafa hiyon bona wa, no tebereha ete ji ngare owo haaya langa tafaha waha. ");
INSERT INTO eri_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Fai Nomo Idau no umonbona, Itou nomo buk lewai onounga, no edo umonbona. Onou wa, fai no Fai Nomo Idau honggoro fai owonege langa nigina waha, no augami bagu. Fai waha nomo anya ada bisi tuwage wa hilobainga.” ");
INSERT INTO eri_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ono wainga Judas, fai waha no Yesus nere honggoro fai owonege langa nigonbona, no Yesus benou isoki tuwai, “Isisiwou fai ne ji boni leni yo?” Ono wainga Yesus no letuwai, “Ne leni onounga.” ");
INSERT INTO eri_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nere da nyi bode yafa ganenga, Yesus no beret ete tedu bona, Itou hilobainga tudu bona kokorudu disaipel nigai. Ono bona lewai, “Tere elegedu nyagu. Beha ji yame geefe gala.” ");
INSERT INTO eri_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Onodu no wain kap ete tedu bona, Itou hilobainga tudu nere nigi bona lewai, “Tere oruwanga kap beha langa nyagu. ");
INSERT INTO eri_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Beha ji yame ganefe beele agili mala karuwou. Ji fai-aita bagu baingaro nebere une uulu nagei nomo boni feuni. ");
INSERT INTO eri_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ji tere letigini, Ji ege wain ada nyoni, goi saini ji tere bagu gaara wain eege yame Jijei nomo huuna langa yafou waha huwanya langa nyonboni.” ");
INSERT INTO eri_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Onodu nere moone ete te-bode, taon awa tudu Oliv muju langa manane. ");
INSERT INTO eri_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Onodu Yesus nomo disaipel lenigai, “Ooru beha langa, dada ji langa heige gonga uredu, tere oruwanga huwanyatege ngalengawou mebodu wonbona, taate bona, Itou nomo buk langa beele benou bagu, ‘Ji oofa nigou fai dukote wehenga sipsip kejiwe heige hara wodbode.’ ");
INSERT INTO eri_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Onou wa, ji ege gidu maidu tere amuge tigidu boni, Galili langa goyon boni.” ");
INSERT INTO eri_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ono wainga Pita no ege benou letuwai, “Buyona, nere ila dada ne langa heigonga uredu, nebere huwanyanege ngalengawou oruwa mebodu wonga, ne awa hinei mata wogunga wa, ji ne ada awa hinoni.” ");
INSERT INTO eri_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ono wainga Yesus no letuwai, “Ji ne ngalenga lehinini, elebe ooru beha langa, saini teewe waregu uwa la, ne benou le ei wau ganga, ne ji boni alai uwa.” ");
INSERT INTO eri_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ono wainga Pita letuwai, “Ono urona, ji ne ngare ume boyare wonga wa edonga, ji benou ada lewoni, ji ne boni ada isini. Gai uwanga uwa.” Ono wainga nere disaipel oruwanga beele onounga lewane. ");
INSERT INTO eri_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus no nomo disaipel bagu haumu ete Getsemani ide walanga goyane. Onodu no benou lenigai, “Tere bela yafa gadenga, ji mani wolanga hauya won boni.” ");
INSERT INTO eri_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Onodu bona, no Pita wainga Sebedi idau gane nga nononga hanigedu bona manai. Ono bona no huwanya ou tuwai, onodu no gai inyaba isai. ");
INSERT INTO eri_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Onodu bona no lenigai, “Ji huwanyafe ou dena, ji umoni juguni. Tere belanga ji ngate yafa boya oofawei nomo.” ");
INSERT INTO eri_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Onodu, no menanga onou golodu goidu bona, mebodudu hogo oula tudu benou hauya wai, “Yame Jijei, Edo wonga wa, ne kap beha tedu ariri hayei nomo gau hina. Onou wa, ne yame gauwou adai oojowau. Uwa. Ne name gauwou wahanga oojowau.” ");
INSERT INTO eri_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Onodu Yesus no disaipel ei bagu medu, nere agore jiri ganenga nerigai. Onodu no Pita benou isoki tuwai, “Adadu? Tere ji bagu awa etenga oofawei nomo edo uwa yo? ");
INSERT INTO eri_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tere oofadu hauya bonade yafagu. Gamaji wala-wala tigou mayonga mebodu wagu ganga. Ngalenga, huwanyatege no dada onowei nomo gau tuna, onou wa, getege gala no danga uwau.” ");
INSERT INTO eri_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Onodu bona no ege mani nga wai, onodu benou hauyawai, “Yame Jijei, kap waha ji feiya hiyei nomo edo uwa, ji edo nyonboni wonga, ne name gauwou wahanga oojowau.” ");
INSERT INTO eri_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Onodu bona, no ege gidu me nerigai wa nere jiri gane, taate bona, nere agenege ou wainga agore jiri wane. ");
INSERT INTO eri_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Onodu bona no ege awa nigidu bona, mani hauya ei wai. No amugedu hauya wai onounga, ege hauya wai. ");
INSERT INTO eri_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iinga no disaipel bagu medu bona benou lenigai, “Tere agore jiri boya houwe tafaya yo? Isagu. Saini amina wai jugu waha nere elebe Fai Nomo Idau une fai owonege langa tafa tuwodbode. ");
INSERT INTO eri_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tere jayadenga goyoya. Uragu, fai ji nere owonege langa tafa hiyonbona amina mai jugu waha benu.” ");
INSERT INTO eri_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus no beele le gainga, Judas, no disaipel 12 waha nebereha ete, no mai gainga nere fai toomaro oota kesebu bagu nauge bagu yasadu bode no ngate mayane. Nere pris aroro bagu, fai-aita bagu nebere mora bagu, nere huuru niganenga mayane. ");
INSERT INTO eri_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Fai no waha Yesus nere owonege langa tafa tuwona waha, no naani ete bona benou lenigai, “Ji fai ete uumba tuwoni boni. Fai waha no Yesus. Tere no yaasu tuwagu.” ");
INSERT INTO eri_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Onodu bona, Judas no tigini Yesus bagu goidu bona letuwai, “Ooru hilobainga, Isisiwou fai.” Ono bona uumba tuwai. ");
INSERT INTO eri_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ono wainga Yesus no letuwai, “Baabo, dada ne onowau ganga mainaha waha edo, ne fasadu onowau.” Ono wainga fai nere maidu owonege ayadu bode, Yesus danga bagu yaasu tuwane. ");
INSERT INTO eri_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ariya, fai ete no Yesus ngare otoware waha, nomo oota kesebu mutu ufaro uludu tai. Onodu Pris mora bagu nomo haruwe magana warainga, oota kesebu ago kuli saludu kaitainga meboduwai. ");
INSERT INTO eri_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ono wainga Yesus no letuwai, “Ne name oota kesebu nomo haumu langa ege tanahe minona. Fai oruwa oota kesebu langa warade waha, nere oota kesebu inyabamu nigona bona. ");
INSERT INTO eri_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne ada isini rute, ji edo yame jijei isoki tuwegenga, no ensel baingaro, ami ago 12 feiya nigou, medu ji hoyo hiyage? ");
INSERT INTO eri_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Onou wa, ji onou onowei mata wehenga wa, beele Itou nomo buk langa inyina waha tigini ada heigoga. Itou nomo buk lena, dada waha ji langa tigini heigou.” ");
INSERT INTO eri_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Saini wahanga la, Yesus no fai waha lenigai, “Tere warawou fai yo uwa, yebu fai yo ete yaasu tuwagu ganga dorofe, oota kesebu bagu dumuga bagu elegedu ji yaasu hiyagu ganga maiyaha? Ji fati oruwa tempel nomo orei huwanya langa yafa boni fai-aita bagu isisiwou nigi-gene. Tere saini waha langa yaasu hiyei nomo edo uwa yo? ");
INSERT INTO eri_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dada oruwa heigai beha profet nere yeregane waha edomu-wai.” Ono wainga disaipel oruwanga Yesus awa tudu bode heige harawane. ");
INSERT INTO eri_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Fai nere Yesus yaasudu bode, haudu pris anyakaro Kaiafas nomo mata langa manane. Nere nuuni beele isou fai bagu, nere mora bagu, koto wane yafa gane. ");
INSERT INTO eri_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita no Yesus oojo tudu goyai, ariya no menanga onou baae langa otowai. No pris anyakaro nomo mata orei huwanya langa goidu bona, polis bagu yafane. No taate dada Yesus langa heigonga urei nomo bona. ");
INSERT INTO eri_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nere pris aroro bagu kaunsel oruwanga bagu, nere fai ila yaure niganenga maidu onowou ila, Yesus onowai waha, yaawa wou beele langa malalamudu lewane. No nyabuluwou ete tafai wonga, nere edo dukote wogunga umonbona, waha bode jala kurunga wane. ");
INSERT INTO eri_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ono ganenga, fai baingaro maidu bode yaawawou beele no gogala langa tafane. Ono wane wa, nere nyabuluwou ete no edo langa dukote wogunga umonbona waha te malalamudu lewegu uwa. Onou wa iinga fai nga nononga mayare ");
INSERT INTO eri_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","onodu leware, “Fai beha no lewai, ‘Ji edo tempel koresedu boni, fati eeinga la ege tawon boni.’ ” ");
INSERT INTO eri_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ono warenga, pris anyakaro no jaidu bona Yesus isoki tuwai, “Adadu, beele beha ne langa waride? Ne beele ete ege ada gidu lewau yo?” ");
INSERT INTO eri_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ono wainga, Yesus no beele ete lewei uwa. Ono wainga pris anyakaro no letuwai, “Ji Itou ago auma bagu unyi langa ne isoki hinini, elebe ne ngalenga tigini ouwela iwau. Ne fai beha Itou no nomo fai-aita bagu gidu hanigei nomo hangada hinai yo? Ne Itou Nomo Idau yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ono wainga Yesus no letuwai, “Ne amina lenaha onounga. Onou wa, ji tere letigini, iinga gonga tere Fai Nomo Idau no Itou danga anyakaro bagu owo hilou langa yafa gonga uragu ganga. Onodu bona, no ha laluwa nomo agau ouwe langa yafa gonga monbona.” ");
INSERT INTO eri_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ono wainga, pris anyakaro no beele waha bona horotodu, nomo kolos koraidu kaite bona lewai, “No Itou memesi beele letuna. Ere ege fai ila, fai beha nomo onowou malalamuwei nomo ada yaure nigoboya. Uwa. Gai iingabe Itou memesi tuwaha. ");
INSERT INTO eri_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tere, ere adadu ono tuwei nomo isiya?” Ono wainga nere ege gidu lewane, “No nyabuluwou bagu no edo umonbona.” ");
INSERT INTO eri_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Onodu nere Yesus hogo langa, bisinga tubode gula tuwane. Ono bode nere ila ulagu bare bode ");
INSERT INTO eri_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","letuwane, “Ne fai Itou hangada hinai, elebe ne profet beele lewau. Faiwei ne narina?” ");
INSERT INTO eri_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita no malala langa yafa gainga, mata nomo orei huwanya la. Haruwe aita ete golodu maidu bona letuwai, “Ne fere Yesus Galiliha gaara yafere.” ");
INSERT INTO eri_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ono wainga, Pita no unyi kakiri bona fai oruwanga agenege langa uwa iwai, “Ne beele leni beha ji alai uwa.” ");
INSERT INTO eri_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Onodu iinga no mata ete orei arasai la otona walanga goyai, Ono gainga haruwe aita ete no uredu bona, fai-aita bagu jugu langa yafane waha benou lenigai, “Fai beha no Yesus Nasaretha bagu yafagai.” ");
INSERT INTO eri_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ono wainga Pita no ege benou lewai, “Ngalenga ouwe langa, ji fai waha boni ada isini.” ");
INSERT INTO eri_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iinga menanga onou, nere fai jugu langa oto wane waha, maidu bode Pita letuwane, “Ngalenga tigini, ne nebereha ete. Name bolote ne malalamu hinaha.” ");
INSERT INTO eri_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ono wanenga Pita no beele danga bagu benou lewai, “Ngalenga tigini ouwe la, ji fai waha boni ada isini. Ji ngalenga lewei uwa wonga, Itou no edo inyabamu hiyonbona.” No leboro gainga, fasayadu onou teewe warai. ");
INSERT INTO eri_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ono wainga, Pita no beele Yesus letuwai waha bona ege ninau isai, “Saini teewe waregu uwa la, ne le eei wau ganga, ne ji boni ada isini wou.” Onodu Pita no malala heigedu bona inyangaaro merenga wai. ");
INSERT INTO eri_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hamba wainga, nere pris aroro bagu nere fai-aita bagu nebere mora bagu oruwanga Yesus dukote wogunga umei nomo beele lewane. ");
INSERT INTO eri_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Onodu bode iinga nere baklain langa dage tudu bode, haudu goi gabman anyakaro Pailot owo langa tafane. ");
INSERT INTO eri_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, fai waha no Yesus honggoro fai owonege langa tafai waha, no nerigai wa nere Yesus kot langa ilei tubode ou tuwane. Ono wanenga no ninau ege ubuludu bona moni silwa 30 nere pris aroro bagu nere mora bagu tuwane waha ege gidu togoi nagai. ");
INSERT INTO eri_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Onodu bona no lewai, “Ji une tafene. Fai ji tere owotege langa tigene waha no nyabuluwou te uwau. Tere no dukote wadenga umonbona.” Ono wainga nere letuwane, “Wa ere ebere dada uwa. Wa ne namenga dada.” ");
INSERT INTO eri_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ono wanenga, Judas no moni silwa tempel huwanya langa ayarudu bona, no goidu nogo maalu boou ayadu umai. ");
INSERT INTO eri_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ono wainga, nere pris aroro moni silwa waha elegedu bode nere lewane. “Moni beha fai dukotewou nomo agouwou. Waha bona ere tempel nomo moni bagu ada tafoboya.” ");
INSERT INTO eri_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Onodu bode, nere beele ngado wane, nere moni waha langa oula matau ete nere fai tauwe tafou nebere ejiya wane. Nere oula waha yaao fai nebere matmat inyei nomo ono wane. ");
INSERT INTO eri_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Onou waha bode, nere oula matau waha unyi tuwane wa, Ganenege Nomo Oula, nere fai unyi waha gai onounga lelede. ");
INSERT INTO eri_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Onou waha bona, beele ete amina profet Jeremaia hurau langa lewai waha tigini heigai. No benou lewai, “Nere silwa moni 30 waha taane. Israel nere ejiyawou wa, fai waha ejiya tuwou dorofe hangada wane. ");
INSERT INTO eri_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Onodu bode, nere moni waha langa fai tauwe tafou nebere oula ejiya wane Anyakaro lehiyai dorofe.” ");
INSERT INTO eri_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesus no gabman amugou Pailot hogo langa otowai, ono gainga Pailot no Yesus isoki tuwai, “Ne Juda nebere king yo?” Ono wainga Yesus letuwai, “Ne nage leni onounga.” ");
INSERT INTO eri_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ono gainga pris aroro bagu nere mora bagu, Yesus go bode beele baingaro lenga wane. Ono wane wa, no beele ete ege gidu lewei uwa. ");
INSERT INTO eri_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ono wainga, Pailot no ege isoki tuwai, “Ne nere beele oruwanga, ne geete langa tafangade waha ne isei uwa rute?” ");
INSERT INTO eri_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ono wainga, Yesus no Pailot beele ete ege gidu letuwei uwa. Ono wainga Pailot no ninau baingaro isai. ");
INSERT INTO eri_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Haga orei oruwa bori nomo fati anyakaro langa, gabman amugou no fai etenga dagou mata langaha awa tutuna. Nere fai-aita bagu nage we fai unyi tetede, ono ganenga Pailot no fai waha awa tuganga nere bagu goi-goina. ");
INSERT INTO eri_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saini waha langa, fai ete no gai inyaba dagou mata langa yafagai, nomo unyi Yesus Barabas. ");
INSERT INTO eri_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Onou waha bona, saini nere fai-aita bagu koto wanenga, Pailot no nere isoki nigai, “Tere ji faiwei awa tuwehenga tere bagu goyona? Yesus Barabas awa tuwoni yo, uwa Yesus, nere lede Itou no huuru tuwainga mai?” ");
INSERT INTO eri_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot no onou lewai, wa taate bona, no isai, nere Yesus bodenga huwanyanege inyaba wainga, nere no kot langa haudu goyane. ");
INSERT INTO eri_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Onodu fere, saini Pailot no jas nomo sia langa yafa gainga, nomo oya no beele benou huuru fuwai, “Ne fai tigini waha langa dada te adai onowau. Ooru ji wewewou ete langa urenaha, onodu ji ou anyakaro hiyaha.” ");
INSERT INTO eri_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nere pris aroro bagu nere mora bagu, fai-aita huwanyanege jaimu nagane, nere Pailot yauredu letuwogunga, no Barabas awa nagi bona, Yesus dukote wonga umei nomo bode. ");
INSERT INTO eri_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ono wanenga gabman amugou no ege isoki nigai, “Tere ji faiwei, nere fai nga waha gama langa ete awa tuwei nomo gau tigina?” Ono wainga, fai-aita bagu yauredu lewane, “Barabas.” ");
INSERT INTO eri_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Onodu Pailot no isoki nigai, “Ji Yesus, nere lede Itou huuru tuwainga mai waha adadu ono tuwoni?” Ono wainga nere oruwanga yauredu lewane, “Nauge abalakawou langa waragu.” ");
INSERT INTO eri_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ono wanenga Pailot no isoki nigai, “Taate bona? No taate nyabuluwou ete onowaha?” Ono wainga nere gai inyangaaro yauredu lewane, “Nauge abalakawou langa waragu.” ");
INSERT INTO eri_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailot no isai, nomo beele ada isode, onodu oota anyakaro jaimu wode ono wane. Ono wainga, no yaage menenga tedu bona, nere fai-aita bagu agenege langa owo hugai. Ono bona lewai, “Fai beha no umei mata wonga wa, ji yame une uwa. Wa tere tebere dadanga.” ");
INSERT INTO eri_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ono wainga, nere fai-aita bagu oruwanga ege gidu letuwane, “Une waha edo ere bagu, ebere magana langa inyonbona.” ");
INSERT INTO eri_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ono wanenga Pailot no Barabas awa tuwainga nere bagu goyai. Onodu no lewainga nomo oota fai Yesus gula wane. Iinga no Yesus oota fai owonege langa tafai, nere nauge abalakawou langa warodbode waha bona. ");
INSERT INTO eri_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ariya gabman amugou nomo oota fai nere, Yesus haudu bode gabman mata huwanya langa goyane, onodu nere oruwanga maidu hogo langa komo wane. ");
INSERT INTO eri_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Onodu bode nere nomo kolos uulu fudu, kolos giriwou ete tani fuwane. ");
INSERT INTO eri_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Onodu maalu kudina bagu elegedu king nomo teteri dorofe, atidu mora langa tanimu fuwane. Onodu bode dumuga ete nomo owo hilou langa tafa fuwane. Onodu afenege tuburu kutudu bode, memesi beele benou letuwane, “Kaiye, Juda nebere king.” ");
INSERT INTO eri_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Onodu nere bisinga tubode dumuga nere owo la tafane waha tedu, mora gula wane. ");
INSERT INTO eri_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nere no memesi tuwou waha nomo fanyimu oruwanga ono borodu bode, nere kolos tanimu fuwane waha uulu fudu, nomo kolos tigini waha ege tanimu fuwane. Onodu bode nauge abalakawou langa tofiye tuwei nomo haudu goyane. ");
INSERT INTO eri_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nere golodu goi bode, oota fai nere Sairini mataneha fai ete urane, nomo unyi Saimon. Onodu bode, nere no haudu tenene tuwanenga, Yesus nomo nauge abalakawou aule fuwai. ");
INSERT INTO eri_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nere goidu haumu ete la heigane, unyi Golgata. Unyi waha nomo hugu onou, “Mora ngedo nomo haumu.” Onodu haumu walanga ");
INSERT INTO eri_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","nere Yesus wain marasini iisa bagu inyaba waha ubulumuwou, no nyei nomo bode tuwane. Ono wanenga no nyi uredu awai, no nyei uwa. ");
INSERT INTO eri_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nere oota fai Yesus nauge abalakawou langa tofiye tudu bode, nere nage nomo kolos dada wesedu elegei nomo bode tuntani hiri wane. ");
INSERT INTO eri_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Onodu bode, nere haumu waanga yafa bode no oofa tuwane. ");
INSERT INTO eri_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nomo mora ouwe langa, beele nere no kot langa tafa tuwane waha yeregane. Nere benou yeregane, “Beha no Yesus, Juda nebere king.” ");
INSERT INTO eri_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesus tofiye tuwane hinomu langa, nere nga, yebu fai bagu, warawou fai bagu tofiye nirane, ete owo hilou langa, ete owo kenao langa. ");
INSERT INTO eri_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ono gainga, nere fai-aita goigoi maimai bode, memesi beele letuwane. Nere moranege aya bode, ");
INSERT INTO eri_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lewane, “Ne tempel korese kaitedu, fati eeinga la ege taugou fai, ne nage hoyowau. Ne ngalenga Itou Idau wonga, ne nauge abalakawou awadu bonahe heigau.” ");
INSERT INTO eri_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nere pris aroro bagu nuuni beele isou fai bagu nere mora bagu fere memesi beele benou lewane, ");
INSERT INTO eri_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“No fai ila hoyo nigai, onou wa, no nogo hoyo tuwei nomo edo uwa. No Israel nebere king wonga, no nauge abalakawou awadu heigdu monga, ere no boya huwanyage ngalenga wonbona. ");
INSERT INTO eri_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","No Itou bona huwanya ngalenga wainga lewai, ‘Ji Itou Nomo Idau.’ Wa edo, Itou no gau tuna wonga, elebe Itou no edo hoyo tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nere yebu fai nga, nauge abalakawou langa, Yesus hinomu la tofiye nirane waha fere, memesi beele onounga letuware. ");
INSERT INTO eri_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hoonga gama 12 kilok la, agugu oula oruwa kutauwai inyi gainga goi 3 kilok esuwa. ");
INSERT INTO eri_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Onodu, 3 kilok jugu gainga Yesus no inyangaaro benou yaurai, “Eli, Eli, lema sabaktani?” Beele waha nomo hugu benou, “Yame Itou, yame Itou, ne taate boni awa hini?” ");
INSERT INTO eri_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ono wainga fai ila jugu langa otowane waha, nere beele waha isidu bode lewane, “Fai wo Elaija yaure tuna.” ");
INSERT INTO eri_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Onodu nereha ete, fasadu onou guriyedu goi, spons tedu wain lowa bagu langa tafai. Saini, wain waha la bolo wainga, no dumuga ete mutu langa waridu bona, Yesus nyei nomo tuwai. ");
INSERT INTO eri_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ono gainga nere ila lewane, “Taringa adai, ere uredu boya. Elaija medu hoyo tuwona yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus no ege inyangaaro yauredu bona, no houwe tamai kaitedu bona, au uludu tai. ");
INSERT INTO eri_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ono gainga saini wahanga la, kolos anyakaro tempel huwanya la tofiyane waha, ouwe langa koraidu teme esene la kaitainga, nga heigai. Ono gainga oula mimi me gainga, megebu aroro fofoura wane. ");
INSERT INTO eri_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ono ganenga matmat haumu isebuwai, ono wainga nere Itou nomo fai-aita baingaro umeru wane waha, elebe nere agenege auma jayane. ");
INSERT INTO eri_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Onodu nere matmat awa tuwane. Iinga la, Yesus no ege gidu jayainga, nere Itou nomo taon huwanya langa goyane, ono wanenga fai baingaro nere nerigane. ");
INSERT INTO eri_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Oota fai nebere kapten, nomo oota fai bagu gaara oto bode Yesus oofa tuwane, nere oula mimi megainga, dada ila heigainga uredu bode, nere danga bagu umugane. Onodu bode lewane, “Ngalenga tigini, fai beha no Itou Nomo Idau.” ");
INSERT INTO eri_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nere aita fere baingaro yafane, nere Galili awa tudu Yesus hoyo tuwei nomo bode oojo tuwane. Nere aita waha, menenga onou baae langa igei bode otowane. ");
INSERT INTO eri_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nere gama langa ete Maria, taon Makdalaha. Onodu ete no Maria, Jems Josep ngare anyanere. Ono gainga ete wa Sebedi idau gane nga neire anyanere. ");
INSERT INTO eri_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Esuwa gainga, moni fai ete Arimatea taonha mayai, nomo unyi Josep. No fere Yesus nomo disaipel. ");
INSERT INTO eri_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","No Pailot bagu manidu bona, Yesus nomo gogala awa fuwonga tonbona isoki tuwai. Ono wainga Pailot no oota fai lenigainga, nere Yesus gogala Josep tuwane. ");
INSERT INTO eri_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ono wanenga Josep no Yesus gogala tedu bona, ogola kaamba jijiga uwau langa ngara tuwai. ");
INSERT INTO eri_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Onodu bona, no gogala tedu tamani nogo nomo matmat eege langa tani tuwai. Matmat waha megebu u-u ete, Josep no fai lenigainga kono wane. Onodu bona, Josep no megebu anyakaro ete ubelumu wainga goidu, u-u waha sesemuwai. No onou onodu bona goyai. ");
INSERT INTO eri_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ono gainga, Maria Makdalaha no Maria ete ngare yafare. Nere matmat hinemu langa igei bodere yafare. ");
INSERT INTO eri_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nere Juda nebere bori nomo dada haiyawei nomo fati usu wainga, fati ete langa, nere pris aroro bagu Farisi bagu goidu Pailot urane. ");
INSERT INTO eri_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Onodu nere benou letuwane, “Fai anyakaro, ere beele ete yaawa fai wa, saini no yafa bona lewai waha ninage isiya. No lewai, ‘Iinga fati eei langa, ji ege jayon boni.’ ");
INSERT INTO eri_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Onou waha bona, ne lenigahenga nere matmat nomo u-u waha fati eei langa sesemude wode. Gamaji nomo disaipel maidu, nomo gogala yebu tedu bode fai-aita bagu lenigoga, ‘No matmat langa ege jayaha.’ Ono wogunga, nebere yaawa beele eege waha, yaawa beele amina no nogo lewai waha feiya tuwou heigoga.” ");
INSERT INTO eri_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ono wanenga Pailot no nere lenigai, “Tere oota fai hanigedu, matmat waha oofawei nomo lenigagu. Tere goidu matmat waha danga bagu sesemuwei nomo, dada oruwanga tere gauya onounga ono wagu.” ");
INSERT INTO eri_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ono wainga nere goidu matmat sesemu wane. Onodu nere megebu matmat hao sesemuwou waha la ooga kidu matmat oofawei nomo oota fai logosi nigane. ");
INSERT INTO eri_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ariya Juda nebere bori usu wainga, bori ete nomo fati amugou la eringe amina, hoonga mayona ono gainga, Maria Makdalaha Maria ete ngare, nere matmat urodere goyare. ");
INSERT INTO eri_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ono garenga fasadu onou mimi anyakaro mai. Ono gainga, Anyakaro nomo ensel ha laluwa awadu medu bona, megebu u-u sese wou waha ubeludu gisa la tafadu bona, no megebu waha ouwe langa yafai. ");
INSERT INTO eri_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nomo hogo bala waha, agau dorofe lalawai, onodu nomo kolos waha, ais dorofe kaamba foowou. ");
INSERT INTO eri_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nere oota fai no umuge tubode, danga bagu tereredu, fai umeru wou dorofe jiri wane. ");
INSERT INTO eri_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ariya ensel no aita nga waha lenirai. “Tere adai umugaru. Ji isini, tere Yesus nauge abalakawou langa tofiye tuwane waha, kuru tudu maiyareha. ");
INSERT INTO eri_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","No belanga inyei uwa. No amina jayaha, amina nogo lewai dorofe. Tere maidu haumu no inyai waha uraru. ");
INSERT INTO eri_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tere fasadu goidu bonadere, nomo disaipel benou lenigaru, no matmat awadu ege gidu jayaha. Isagu. No tere amuge tigidu Galili goyaha, tere no walanga uragu ganga. Ji tere beele waha letigoni mainaha.” ");
INSERT INTO eri_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ono wainga nere aita nga waha umuge deware, ariya nere danga bagu edega ware, nere fasadu onou matmat awadu bodere, nomo disaipel lenigei nomo bodere gurarudu goyare. ");
INSERT INTO eri_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nere aita nga goi garenga, Yesus jala gama la toroba niridu bona lenirai, “Eringe hilobainga.” Ono wainga nere hinemu la goidu afo yaasu bodere, unyi isou ware. ");
INSERT INTO eri_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ono warenga Yesus benou lenirai, “Tere adai umugaru. Tere goidu bonadere, yame baabo gane leniga derenga, nere Galili la goyode. Nere haumu walanga yeriyode bode.” ");
INSERT INTO eri_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nere aita nga golodu goi garenga, nere oota fai ila matmat oofa wane waha nere taon huwanya goyane, nere goidu bode dada oruwanga heigai waha, nere pris aroro hai nagane. ");
INSERT INTO eri_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ono wanenga, pris aroro nere mora bagu gaara komo wane, onodu bode nere beele ete ngado wane. Onodu bode nere moni baingaro oota fai nigane, ");
INSERT INTO eri_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","onodu bode nere lenigane, “Tere benou lewagu, ‘Ere ooru agore jiri geyenga nomo disaipel maidu bode, no nomo gogala yebu wane.’ ");
INSERT INTO eri_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ono wadenga gabman amugou no beele waha isei mata wonga, ere edo no ngate beele tiginimu woboya, ono wedenga tere ou ete uwau.” ");
INSERT INTO eri_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ono wanenga nere oota fai moni waha taane, onodu bode nere fai aroro nebere beele waha oojo wane. Ono wanenga beele waha fududu Juda gama langa edowai, waha bona Juda nere beele waha gai onounga le gane mai elebe. ");
INSERT INTO eri_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nere disaipel 11, golodu Galili goyane, onodu nere muju, Yesus no lenigai waha langa mani heigane. ");
INSERT INTO eri_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Onodu nere Yesus uredu bode unyi isou wane. Ariya, nere ila ninanege nga-nga wane. ");
INSERT INTO eri_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ono ganenga, Yesus no nere hinenege la maidu bona benou lenigai, “Itou no ji dada oruwanga, ha laluwa nomo bagu oula nomo bagu oofawei nomo, danga bagu unyife anyakaro hiyaha. ");
INSERT INTO eri_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Onou waha bona, tere ha-ha oruwa la goidu bonade, fai-aita yame disaipel heigemu nigagu. Onodu, yaage bisemu nigagu, Jijei unyi langa, Idau unyi langa, Hauri Guuni unyi langa. ");
INSERT INTO eri_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ono bonade tere beele oruwa ji letigene waha, oojowei nomo bona isisiwou nigagu. Isagu. Ji fati oruwa langa, tere bagu yafa gehenga goi, ha oula bagu, usuwou la edo wonbona.” ");
INSERT INTO eri_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Beele beha, Itou Idau Yesus Kristus nomo hilou beele. ");
INSERT INTO eri_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hilou beele beha, profet Aisaia no yeregai onounga, no amugedu heigaiha, “Isau. Ji fai ete yame beele malalamudu lewei nomo boni, amuge hinidu, huuru tuwehenga goyonbona. Ono wehenga, no ne name jala haiya hanonbona. ");
INSERT INTO eri_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ha fai uwau langa, fai hurau ete no yauredu benou lewai, ‘Anyakaro nomo jala haiya fuwagu. Nomo jala tiginimu fuwagu.’” ");
INSERT INTO eri_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon yaage bisemu nigigou fai, no ha ete fai uwau langa heigaiha, no fai-aita bagu huwanyanege ubuludu bode, yaage bisou togonga, Itou no nebere une uulu nagonbona, waha bona beele malalamudu lenigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ono wainga, Judia bagu, Jerusalem fai-aita bagu oruwanga, nere Jon bagu goidu, nebere une uulu wanenga, Jon no nere Jordan yaage langa, yaage bisemu nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon no kolos Kamel osoko langa atane waha tagugai, no let ungu langa tagugai. Ariya, no dongamu nomo koisi ameme bagu nyigai. ");
INSERT INTO eri_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","No beele malalamudu, benou lewaiha, “Fai ete no ji mogofe maina waha, no nomo danga ji yame danga feiya tuwou. Onou waha bona, ji afefe tuburu kutudu boni no nomo su nomo maalu dagou waha, futu fuwei nomo ji fai hilou uwa. ");
INSERT INTO eri_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ji tere yaage langa, yaage bisemu tigi-tigini. Ariya, no tere Hauri Guuni langa, yaage bisemu tigonbona.” ");
INSERT INTO eri_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Saini waha langa, Yesus no Nasaret taon, Galili distrik awadu bona mayaiha. Ono wainga, Jon no Yesus Jordan yaage langa, yaage bisemu tuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ono wainga, Yesus no yaage awadu ouwe langa maidu bona, no fasayadu, ha laluwa helufa wainga uraiha, ono gainga, Hauri Guuni neei buuna dorofe no bagu mai. ");
INSERT INTO eri_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ono gainga, ha laluwa langa, fai belenege ete no benou yauredu lewai, “Ne yame magana, Ji ne gaude hinini. Ji yame huwanyafe ne bona edega dena.” ");
INSERT INTO eri_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Saini waha langa tigini, Hauri Guuni no Yesus huuru tuwainga, ha fai uwau langa goyaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Onodu Yesus no ha fai uwau langa fati 40 yafa gainga, Satan no wala-wala tuwaiha. No kaafa kui bagu yafa ganenga, ensel nere, no hoyo tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Saini nere, Jon dagou mata langa tafa tuwane yafa gainga, Yesus no Galili distrik langa mai heigedu bona, no Itou nomo hilou beele malalamudu lewaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","No benou lewai, “Itou no saini hangada wai waha, no amina heigaha, onodu Itou nomo huuna langa yafou waha, no mai jugu waha. Tere huwanyatege ubuludu bonade, hilou beele bonade, huwanyatege ngalengawou.” ");
INSERT INTO eri_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus no, Galili yaage katiwou mou langa golo bona, Saimon bemu Andru ngare neriraiha. Nere yaage katiwou langa, hagoma ayawou haruwe tare. Nere hoowe langa moni kusewei nomo haruwe tetedere. ");
INSERT INTO eri_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ono garenga, Yesus no benou lenirai, “Tere maidu ji oojo hiyaderenga, ji tere fai-aita bagu elege nigei nomo isisiwou tiron boni.” ");
INSERT INTO eri_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ono wainga, nere fasayadu bodere, hagoma dada waanga awaru ware oto gainga, nere goidu Yesus oojo tuwareha. ");
INSERT INTO eri_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Onodu Yesus no menanga onou golodu goi bona, Sebedi idau gane nga nononga, Jems Jon ngare nerirai. Nere bot langa yafa bodere, neire hagoma dada koraiwai waha erere bodere yafare. ");
INSERT INTO eri_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ono garenga, Yesus no nere yaure nirainga, nere amenere Sebedi haruwe fai bagu bot langa awa nigidu bodere, Yesus oojo tuwareha. ");
INSERT INTO eri_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus no fai ila bagu Kaperneam taon langa goyane. Onodu bode, saini nere Juda nebere bori nomo fati heigainga, Yesus no bori mata huwanya langa goidu, fai-aita bagu beele malalamudu lenigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ono wainga, fai-aita bagu nere Yesus nomo beele isidu bode, horoto dewaneha, taate bona, Yesus no fai-aita bagu isisiwou nigai wa, nere Nuuni beele isou fai ono-onode dorofe uwa. Yesus no fai unyi bagu dorofe, isisiwou nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Saini waha langa, fai ete no nebere bori mata huwanya langa yafai wa, hauri inyaba ete no langa inyai. Onodu no benou yaurai, ");
INSERT INTO eri_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus Nasaretha, ne ere adadu ono higau ganga mainaha? Ne ere inyabamu higau ganga rute mainaha? Ji ne isi hinini. Ne fai hilobainga tigini beha, ne Itou nogo langa mainaha.” ");
INSERT INTO eri_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ono wainga, Yesus no hauri inyaba waha honggoro tubona benou letuwai, “Ne hurate fosokodu bonahe, fai waha awa tuwau.” ");
INSERT INTO eri_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ono wainga, hauri inyaba fai waha waridu bunyu banyi tudu bona, inyangaro uidu, fai waha awa tuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ono wainga, nere fai-aita bagu oruwanga waha uredu bode, horoto wane. Onodu bode, nere nage-nage benou leguruwane, “Taate dada elebe beha heigena? Fai beha no beele eege ete malalamudu lena, onodu no beele lena waha, no fai unyi bagu dorofe. Onodu, saini no hauri inyaba beele lenigi ganga, nere nomo beele isi-iside.” ");
INSERT INTO eri_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ono wainga, Yesus no dada onowai waha nomo beele, fasayadu Galili distrik oruwanga la, golo boro waiha. ");
INSERT INTO eri_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus no fai ila bagu bori mata awadu bode malala heigedu, nere tigininga Andru Saimon ngare neire mata langa goyane. Ono ganenga, Jems Jon ngare fere, nere gaara goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon tangabumu aita, no kabalila agore inyaiha, taate bona, no taura tubona, gogala ngasu kuruwai. Ono wainga nere fasayadu onou Saimon tangabumu aita taura tuwai waha, Yesus letuwanenga isai. ");
INSERT INTO eri_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ono wanenga, Yesus no Saimon tangabumu aita bagu goidu bona, owo yaasudu jaimu tuwai. Ono wainga, Saimon tangabumu aita no taura jige tuwainga, nebere da haiya nagaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Esuwa hoonga mani joro gainga, nere taura fai baingaro hanigedu bode, Yesus bagu mayane. Fai-aita hauri inyaba bagu fere onounga, hanigedu bode mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nere taon wahaha fai-aita bagu oruwanga, mai mata waha jauli arasai hinomu langa komo waneha. ");
INSERT INTO eri_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ono wanenga, Yesus no fai-aita baingaro, taura hogo fere-fere bagu waha, nebere taura jigemu nagai. Ono bona, hauri inyaba baingaro so nigaiha. Hauri inyaba nere Yesus bode alai, waha bona, nere beele lewoguga bona, Yesus no nere karu nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Eringe hamba oruwa, Yesus no jaidu malala langa heigedu bona, haumu ete fai uwau langa goidu, walanga hauya bona yafaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ono gainga, iinga, Saimon no ilibumu gane bagu goidu, no kuru tuwane. ");
INSERT INTO eri_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nere goi toroba tudu bode, Yesus benou letuwane, “Nere fai-aita toomaro, ne kuru hinide.” ");
INSERT INTO eri_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ono wanenga, Yesus no benou lenigai, “Buyona, ere taon jugu-jugu inyide waha langa goyo boya. Ji nere fere beele malalamudu le nigon boni, taate bona, ji haruwe beha tei nomo boni meeneha.” ");
INSERT INTO eri_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Onodu, Yesus no Galili distrik oruwa langa kolilidu golo bona, nebere bori mata huwanya langa goidu, beele malalamudu leniginga bona, hauri inyaba so nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Fai ete no lepra taura bagu, maidu bona Yesus danga bagu isoki tuwai. Fai waha, no afo tuburu kutudu yafa bona, Yesus benou letuwai, “Ne gau hinei mata wonga, ne edo langa, ji figini hiyahenga, Itou ago langa eege heigon boni.” ");
INSERT INTO eri_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ono wainga, Yesus no fai waha bona danga bagu aau warainga, owo jaula langa tafa bona, benou letuwai, “Ji gau hina. Ne eege heigau.” ");
INSERT INTO eri_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ono wainga, fasayadu onou lepra taura, fai waha awa tuwainga, fai waha no eege heigaiha. ");
INSERT INTO eri_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ono wainga, Yesus no fai waha, fasayadu huuru tuwainga goi gainga, beele danga bagu ");
INSERT INTO eri_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","benou letuwai, “Ure dewau. Ne fai ete te, dada ne langa heigaha beha adai hai fuwau. Uwa. Ne goidu bonahe, name geete gala pris abitimu tuwau, onodu, ne name geete gala eege heigaha waha abitimuwou, Moses lewai onou eeya muru warau. Ono wahenga, nere fai-aita bagu ne name taura jige hinaha, iwou isodbode.” ");
INSERT INTO eri_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ariya, fai waha no goidu bona, dada oruwanga no gogala langa heigai waha, fai-aita bagu hai nagai. No aasa waha, ha-ha oruwa langa hai nagai. Onou bona, Yesus no nere fai-aita bagu agenege langa, taon ete huwanya goyei nomo edo uwa. No ewe dui langanga, ulate fai uwau langa yafai. Ono gainga, ha-ha fai-aita bagu oruwanga, no bagu mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Fati ila goyainga, Yesus no Kaperneam taon langa ege goyai. Ono wainga, fai-aita bagu nere Yesus mata langa yafana iwou beele isane. ");
INSERT INTO eri_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Onodu, fai-aita bagu baingaro mai komo wanenga mata bolowai. Mata jauli arasai hinomu langa fere, haumu ete te ewe inyei uwa. Ono wanenga, Yesus no beele malalamudu leniginga waiha. ");
INSERT INTO eri_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ono gainga, fai aise, nere taura fai ete nomo ngedemu oruwa ume borowou, auledu Yesus bagu mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Haumu fai bolo dewai, waha bona nere taura fai waha haudu Yesus hinomu langa goyei nomo edo uwa. Ono wainga, nere taura fai kabalila aledu bode, mata Yesus yafai waha nomo tu ouwe langa digedu manidu bode, mata tu langa yogode konu waneha. Onodu bode, taura fai waha kabali langa inyi gainga foinga awaya tuganenga mata huwanya Yesus yafai langa minaiha. ");
INSERT INTO eri_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ono wanenga, Yesus no nerigai wa nere huwanyanege ngalenga dewai, waha bona no taura fai waha benou letuwai, “Yame magana, ji ne name une oruwa uulu boro haninaha.” ");
INSERT INTO eri_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ono wainga, nuuni beele isou fai ila nere mata langa yafane waha, ninanege langa benou isane, ");
INSERT INTO eri_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Fai no beha, taate bona beele benou lena? No Itou nomo haumu tona onona. Fai ete te no une uuluwei nomo edo uwau. Wa Itou nomonga haruwe.” ");
INSERT INTO eri_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ono wanenga, Yesus no nomo huwanya langa nere ninanege onou isane waha, amina isai. Onodu bona, no benou isoki nigai, “Tere taate boya huwanyatege langa, ninatege onou isiya? ");
INSERT INTO eri_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Amu, beele adoha waha, ji fai waha letuwei nomo edo? Ji benou lewoni waha edo rute, ‘Ji name une uulu hanini,’ uwa, ji benou lewoni waha edo rute, ‘Ne jaidu name kabali tedu bonahe golowau?’ ");
INSERT INTO eri_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Onou wa, ji tere isagu ganga boni gau hina. Fai Nomo Idau, no oula beha langa no danga bagu, no edo langa une uulu wonbona.” Onodu, no fai ngedemu ume borowou waha igei tubona, benou letuwai, ");
INSERT INTO eri_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ji lehinini, ne jaidu name kabali tedu bonahe, name mata langa goyau.” ");
INSERT INTO eri_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ono wainga, fai waha no fai-aita bagu oruwanga agenege bagu jaidu bona, fasayadu nomo kabali tedu golodu goyaiha. Ono wainga, fai-aita bagu oruwanga waha uredu bode, horoto wane. Onodu, Itou unyi isou bode lewane, “Oo, ere amina dada benouha ete urei uwa. Gai uwanga uwa.” ");
INSERT INTO eri_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ariya, Yesus no ege Galili yaage katiwou laanga la golodu goyai. Ono gainga, fai-aita bagu baingaro no bagu mayane, ono wanenga Yesus no Itou nomo beele hai nagai. ");
INSERT INTO eri_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Onodu, no golodu goi bona, Alfius idau Livai, no takis tegou mata langa yafa gainga uraiha. Onodu bona, Yesus no Livai benou letuwai, “Ne ji oojo hiyau.” Ono wainga, Livai no jaidu Yesus oojo tuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesus no Livai nomo mata langa yafa bona da nyai. Ono gainga, takis tegou fai bagu, une fai bagu, nere baingaro Yesus nomo disaipel bagu, gaara Yesus ngate yafa bode da nyaneha. Nere fai onouha waha, baingaro nere gai-gai Yesus oojo tugane. ");
INSERT INTO eri_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nuuni beele isou fai ila nere Farisiha, Yesus no takis tegou fai bagu, une fai bagu, da nyi gainga urane. Onodu nere Yesus nomo disaipel benou isoki nigane, “Yesus no taate bona takis tegou fai bagu, une fai bagu, da nyi-nyina?” ");
INSERT INTO eri_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ono wanenga, Yesus no beele waha isidu bona, nuuni beele isou fai benou lenigai, “Nere fai taura uwau waha, Dokta bagu ada goi-goide. Uwa. Nere fai taura bagu wahanga, nere dokta bagu goi-goide. Onou dorofenga, ji fai hilou yaure nigei nomo boni mei uwa. Ji fai une tafagou waha, yaure nigei nomo boni meneha.” ");
INSERT INTO eri_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saini ete langa, Jon nomo disaipel, nere Farisi bagu, da urigane. Ono wanenga, fai ila maidu Yesus benou isoki tuwane, “Adadu, name disaipel nere da ada urigede, nere Jon nomo disaipel bagu, Farisi nebere disaipel bagu, nere da urige-urigede?” ");
INSERT INTO eri_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ono wanenga, Yesus no benou lenigai, “Fai ete no aita tona onona waha, saini no ilibumu gane bagu gai yafonga wa, nere nomo ilibumu gane da urigei nomo edo yo? Uwa. Fai no aita tona onona waha, no ilibumu gane bagu gai yafana, onou waha bona, nere da ada urigode. ");
INSERT INTO eri_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Onou wa, iinga saini nere fai waha haudu goiyo gunga, nere nomo ilibumu gane saini waha langa, nere da urigod bode. ");
INSERT INTO eri_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Fai ete no ogola majigao eege tedu bona, saket asari korai-wou waha, nomo jogode ada erere-ererena. No onou onowei mata wona wa, saini nere saket waha huge gogunga, ogola majigau eege waha kojijidu bona, saket asari waha ege korai wonbona. Ogola majigao eege waha we, no asari waha koraimu wonga, jogode gai anyakaro heigon bona. ");
INSERT INTO eri_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Onodu fere, fai ete no wain yaage eege waha, meme osoko asari langa ada lolobo-lolobona. No onou onowei mata wona wa, wain yaage eege waha, no meme osoko asari waha koraimu wonbona. Ono wonga, wain yaage meme osoko bagu arotenga, ngadu inyaba wodbodere. Onou waha bona, nere wain yaage eege waha, nere meme osoko eege langa lolobo wodbode.” ");
INSERT INTO eri_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juda nebere bori nomo fati ete langa, Yesus no wit haga gama langa golo waiha. Ono gainga, nomo disaipel nere fere no ngate gaara golowaneha, ono bode nere wit hilou ila elegane. ");
INSERT INTO eri_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ono wanenga, Farisi nere Yesus benou isoki tuwane, “Isau. Name disaipel, Bori nomo fati langa dada onowei nomo karuwou inyina waha, nere taate bode onou onode?” ");
INSERT INTO eri_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ono wanenga, no nebere beele ege gidu benou lenigai, “Tere amina Devit no dada adadu onowai waha nomo aasa, buk langa lelegegu uwa rute? Ji saini Devit, no nomo gane bagu nere da usu nigainga, huweli nigai waha boni leni. ");
INSERT INTO eri_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Saini waha langa, Abiatar no pris mora bagu yafa gainga, Devit no Itou nomo mata huwanya langa goidu bona, beret Itou hogo langa tafou waha tedu nyaiha. Beret waha karuwou inyina, pris nagenga nere beret waha nyei nomo edo. Onou wa Devit no nyai, ono bona ilibumu gane fere elegedu nigainga nyaneha. Tere beele waha, lelegegu uwa rute?” ");
INSERT INTO eri_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Onodu Yesus no ege benou lenigai, “Itou no fai-aita bagu Bori nomo fati hoyo tuwei nomo tafa nigei uwa. Bori nomo fati no fai-aita bagu hoyo nigei nomo bona tafaiha. ");
INSERT INTO eri_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Waha bona, Fai Nomo Idau no Bori nomo fati fere no oofana.” ");
INSERT INTO eri_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus no ege bori mata huwanya langa goyai. Ariya, fai ete owo ulate lalekawou, no bori mata huwanya langa yafaiha. ");
INSERT INTO eri_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ono wainga, fai nere Yesus danga bagu oofa tuwane, taate bona, nere isodbode, Yesus no Bori nomo fati langa, fai owo ulate lalekawou waha jigemu fuwona yo, uwa. No Bori nomo fati langa, fanyimu waha onowei mata wonga, nere Yesus kot langa tafa tuwodbode, ninanege isaneha. ");
INSERT INTO eri_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ono ganenga, Yesus no fai owo ulate lalekawou waha, benou letuwai, “Ne belanga mayau.” ");
INSERT INTO eri_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Onodu, no fai nere waha benou isoki nigai, “Ere Bori nomo fati langa onowou hilou onowei nomo edo yo, uwa ere onowou inyaba onowei nomo edo rute? Ere fai hoyo nigedenga hilou yafode yo, uwa ere edo dunege kote wedenga umeru wode?” Ono wainga nere beele ete gidu lewegu uwa. ");
INSERT INTO eri_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ono wanenga, Yesus no houmu mai gainga, ago wenga fele-fele nigai. No nerigai wa, nere huwanyanege fosokowai, waha bona no huwanya ou tuwai. Onodu, no fai owo lalekawou waha benou letuwai, “Ne owone tiginimuwau.” Ono wainga no owo tiginimu wainga, owo ege hilou waiha. ");
INSERT INTO eri_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ono wainga, Farisi nere waha uredu bode, fasayadu jaidu mata awadu bode, goidu Herot nomo gane bagu komowane. Nere jala adadu langa, Yesus dukote wogunga umonbona waha beele ngado wane. ");
INSERT INTO eri_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus no nomo disaipel bagu, matane waha awadu bode, Galili yaage katiwou la minane. Ono ganenga, fai-aita bagu toomaro Yesus oojo tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Fai-aita bagu baingaro, nere Galili distrik bagu, Judia distrik bagu, nere Jerusalem taonha, nere Idumea distrik bagu, nere oula Jordan yaage ulate langa inyina bagu, nere Tair, Saidon taonha bagu, nere Yesus no dada onona waha beele isidu bode, no bagu mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ono wanenga, Yesus no nomo disaipel lenigai, “Fai-aita bagu baingaro, gamaji nere mai kitikiti hi bode, inyangaro nu hiyoguga. Tere bot ete tamaidu haiya wadenga otowona, fai-aita bagu gai bolowei mata wogunga, ji walanga digon boni.” ");
INSERT INTO eri_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Amina Yesus no fai-aita bagu baingaro taura jigemu nagaiha, waha bona nere fai-aita taura bagu waha, nere nage owonege Yesus langa tafode onobode, nere nage-nage nu guru bode, no hinomu langa goyane. ");
INSERT INTO eri_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Onodu, saini hauri inyaba nere Yesus uredu bode, nere no langa afenege tuburu kutudu bode, yauredu benou le tutude, “Ne Itou Idau.” ");
INSERT INTO eri_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Onou wa Yesus no nogo faiwei waha nere no adai malalamu tuwogu bona danga bagu karu nigigai. ");
INSERT INTO eri_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus no muju ouwe langa manaiha. No fai ila no ngate yafei nomo bona hangada nigona manai. Onodu no fai waha yaure nigainga no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","No fai 12 no bagu yafei nomo bona hangada nigaiha, onodu bona no unyinege aposel warai. No huuru nigonga goidu bode Itou nomo beele malalamudu lewei nomo bona onowai, ");
INSERT INTO eri_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","onodu no hauri inyaba so nigei nomo danga waha nigei nomo ono waiha. ");
INSERT INTO eri_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yesus no fai 12 hangada nigai waha nebere unyinege benou, ete unyi Saimon, ariya Yesus no we unyi ete ubulumudu Pita tuwai. ");
INSERT INTO eri_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Onodu no Sebedi idau gane nga nononga Jems bemu Jon ngare fere hangada niraiha. Onodu no unyinere ubulumudu Boanerges niraiha. Unyinere waha nomo hugu benou, “Fai nere amili ayana dorofe.” ");
INSERT INTO eri_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Onodu nere ila fere hangada nigai waha nebere unyinege benou, Andru wainga Filip wainga, Batolomyu wainga, Matyu wainga, Tomas wainga, Alfius idau Jems wainga, Tadius wainga, Saimon, no Selot nebereha fai ete, ");
INSERT INTO eri_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ono wainga Judas Iskariot, fai waha no iinga fai nere Yesus inyabamu tuwodbode waha owonege langa tafa tuwonbona. ");
INSERT INTO eri_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus no mata langa goyai. Ono wainga nere fai-aita bagu toomaro ege maidu komo wane, ono wanenga Yesus no nomo disaipel bagu da nyei nomo saini uwau. ");
INSERT INTO eri_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nere Yesus nomo ganemu etenga, Yesus no dada onona waha beele isidu bode nere Yesus hawode mayaneha. Nere benou lewane, “No dabu tayaha.” ");
INSERT INTO eri_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nere nuuni beele isou fai ila Jerusalem langa yafagou waha medu, benou lewane, “Belsebul no bagu yafana. No hauri inyaba Belsebul nomo danga langa so nigi-nigina. No hauri inyaba nebere mora bagu.” ");
INSERT INTO eri_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ono wanenga Yesus no nere yaure nigainga mayanenga muuji beele ila lenigai. No benou lenigai, “Satan no adadu Satan so tuwonbona?” ");
INSERT INTO eri_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri etenga nomo fai nere foure ngadu nere nage wara wode wa, kantri waha no danga otowei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Onodu nere fai mata etenga langa yafade waha, nere foure ngadu bode nere nage wara wode wa, mata waha danga bagu otowei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Onodu Satan no nogo bona honggoro fai heigonga, nomo fai nere foure ngawei mata wode wa, no danga bagu otowei nomo edo uwa. No usu dewonbona. ");
INSERT INTO eri_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Fai ete te no fai danga bagu ete nomo mata huwanya langa goidu bona, dada ila ewe elegei nomo edo uwa. No amugedu fai danga bagu waha baklain langa dage tuwonbona. No onou onowei mata bona wonga, no edo langa fai danga bagu waha nomo mata langa dada elegonbona. ");
INSERT INTO eri_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ji ngalenga letigini, Itou no fai-aita bagu nebere une oruwanga, nere beele inyaba lede waha bagu oruwanga uulu nagona bona. ");
INSERT INTO eri_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ariya fai no Hauri Guuni beele inyaba letuwei mata wona wa, Itou no fai waha nomo une waha elebe bagu iinga huunta bagu no ada uulu fuwonbona. Une waha fai waha langa gai-gai inyonbona.” Yesus no onou lena, ");
INSERT INTO eri_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","taate bona, nere benou letuwane, “Hauri inyaba no langa inyina tuwane.” ");
INSERT INTO eri_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Saini waha langa Yesus anya no, Yesus bemu gane bagu mayaneha. Nere maidu bode malala langa oto bode, Yesus nere bagu mayei nomo bode, beele huuru fuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nere fai-aita toomaro Yesus kolili tudu yafabode benou letuwane, “Yesus ne isau. Ne name anyane baine gane bagu name ogone gane bagu mayane malala langa otobode ne yaure hinide.” ");
INSERT INTO eri_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ono wanenga Yesus no beele ege gidu benou lenigai, “Fai wei no yame ngai baabo gane bagu?” ");
INSERT INTO eri_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Onodu bona no fai-aita no kolili tudu yafane waha fele-fele nigi bona benou lenigai, “Ji yame ngai yame baabo gane bagu nerigagu. ");
INSERT INTO eri_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Fai yo, aita yo, no Itou nomo gauwou oojona waha, no yame baabo, no yame ogofe, no yame anyafe.” ");
INSERT INTO eri_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus no yaage katiwou mou langa fai-aita bagu isisiwou nigei nomo haruwe ege jaimuwai. Ono wainga fai-aita bagu baingaro no bagu mayaneha. Ono wanenga no bot ete yaage katiwou langa otowai waha langa digedu bona yafaiha. Ono gainga fai-aita bagu nere laanga, yaage mou la yafaneha. ");
INSERT INTO eri_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ono ganenga Yesus no beele baingaro muuji beele langa isisiwou nigai. No benou lenigaiha, ");
INSERT INTO eri_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tere isagu. Fai ete no haga langa goidu bona wit uwei ayaruna. ");
INSERT INTO eri_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","No wit uwei ayaru bona goi gainga, wit uwei ila jala langa orososo wane, ono wainga neei medu bode elegedu nyaneha. ");
INSERT INTO eri_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ariya wit uwei ila oula ulate megebu bagu, no oula inyanga uwa langa orososo wane. Onodu oula no gai gamu langa uwa, waha bona wit fasayadu hui fudu waneha. ");
INSERT INTO eri_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ono wainga saini hoonga ouwe maibona wit uweru nigaiha. Ono wainga wit nomo jijiruku uwau waha bona oruwanga kakaregedu bode umeru waneha. ");
INSERT INTO eri_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Onodu wit uwei ila maalu kudina bagu gama langa orososo waneha. Ono wanenga maalu kudina bagu mai kutau nigainga nere hilou heigegu uwa. ");
INSERT INTO eri_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ariya wit uwei ila nere oula hilobainga langa orososo wane waha nu, nere hui fududu goi arorodu hilou heigeru waneha. Wit ila hilou 30, ila 60, ila 100 heigeru waneha.” ");
INSERT INTO eri_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Onodu bona Yesus no nere benou lenigai, “Fai no agokuli bagu wonga no beele beha isona.” ");
INSERT INTO eri_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saini fai-aita toomaro heige hara ganenga, Yesus nomo disaipel 12, nere fai Yesus ngate gaara yafa yafade waha bagu, nere Yesus no muuji beele lenigai waha nomo hugu isodbode isoki tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ono wanenga Yesus no benou lenigai, “Itou nomo huuna langa yafou nomo huwari beele nomo hugu, Itou no amina abitimu tigaiha. Waha bona nere fai malala langa yafade waha nere beele oruwanga muuji beele langanga isi-iside. ");
INSERT INTO eri_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Onou waha bode, nere saini baingaro igei wode wa, nere dada ete ada urodbode. Onodu nere saini baingaro beele isodbode, ariya nere nomo hugu ada isodbode, gamaji nere huwanyanege ubulu wogunga Itou no nebere une uulu nagona bona.” ");
INSERT INTO eri_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Onodu Yesus no nomo disaipel lenigai, “Tere muuji beele waha nomo hugu ada isiya yo? Tere onou onoya waha muuji beele ila oruwa waha nomo beele hugu adadu isagu ganga? ");
INSERT INTO eri_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Fai da tauna, waha no Itou nomo beele tauna. ");
INSERT INTO eri_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ariya beele jala gama langa meboduna waha no, nere fai-aita bagu Itou nomo beele isi ganenga, Satan no fasayadu maidu bona, Itou no fai-aita bagu huwanyanege langa beele tauwai waha fasidu ayaruna dorofe. ");
INSERT INTO eri_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fai-aita bagu ila nere wit uwei oula ulate megebu bagu langa orososona dorofe. Nere beele isidu fasayadu tedu bode edega-edegade. ");
INSERT INTO eri_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ariya nere boou uwau. Nere saini tutunga yafa-yafade. Saini fai nere Itou nomo beele ilei fubode fai-aita bagu ou nigi bode inyabamu nigode wa, nere nebere huwanyanege ngalengawou fasayadu inyabana. ");
INSERT INTO eri_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Fai-aita bagu ila nere wit uwei maalu kudina bagu gama langa orososo wane dorofe. Nere fai-aita waha nere beele iside, ");
INSERT INTO eri_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","onode wa, nere oula beha nomo dada bode ninanege baingaro isi bode, moni baingaro komomuwei nomo bode aaoso bode dada hogo fere-fere bona agenege wari-warina. Dada benou waha no Itou nomo beele kutau ganga, hilou ada heige-heigena. ");
INSERT INTO eri_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ariya fai-aita bagu ila nere wit uwei oula hilou langa orososo wane dorofe. Nere Itou nomo beele isidu bode tedu yaasu wane, onodu nere hilou heigane. Nere ila hilou 30 heige ganenga ila hilou 60 heigane, ila nere hilou 100 heigeru wane.” ");
INSERT INTO eri_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus no nomo disaipel benou lenigai, “Fai nere lama tamaidu baket ete huwanya langa yo, kabali ete huuna langa tafa-tafade rute? Uwa. Nere lama tebol ouwe langa tafa-tafade. ");
INSERT INTO eri_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dada oruwanga huwari inyide waha, iinga malala heigode bode. Dada oruwanga fai kutau wane inyide waha, iinga malala heigode bode. ");
INSERT INTO eri_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Fai no agokuli bagu wonga beele beha isona.” ");
INSERT INTO eri_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Onodu no ege benou lenigai, “Beele tere isiya waha, tere ninatege iside wagu. Tere dada fai nigiya waha haawe onounga, Itou no fere agou nomo haawewou onounga tere tigon bona. Onodu no ila ege turi tagonbona. ");
INSERT INTO eri_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Fai ete no dada ila bagu wonga wa, Itou no ila ege tuwonbona. Onou wa fai no dada uwau wonga wa, Itou no fai dada menakele yaasuna waha ngau elegonbona.” ");
INSERT INTO eri_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus no ege benou lewai, “Itou nomo huuna langa yafou wa fai no da uwei oula langa ayaru bona goina dorofe. ");
INSERT INTO eri_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Onodu ooru ganga no agore inyi-inyina, hoonga ganga no jaidu bona nomo haruwe tebona golo-golona. Onodu da uwei waha hui fududu adadu goi arorode waha, fai no waha alai uwa. ");
INSERT INTO eri_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Oula nogo we ono ganga da uwei waha hui fududu bona, iinga hilou heige-heigena. Amugedu hui fududu goi gala bagudu bona iinga usari wari-warina, ono ganga usari waha huwanya langa hilou heige-heigena. ");
INSERT INTO eri_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Onodu muumu ganga, fai waha no kakaru-kakaruna, wa taate bona, da elegei nomo saini heigaha.” ");
INSERT INTO eri_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Onodu Yesus no ege benou lewai, “Ere Itou nomo huuna langa yafou waha taate dada dorofe iwoboya? Ere muuji beele langa adadu lewoya? ");
INSERT INTO eri_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","No sayori ete mastet ide waha nomo fatu dorofe. Mastet fatu no oula langa da ila nebere uwei dorofe uwa. Nomo fatu gai mene-mene. Nere fatu waha oula langa tau-taude. ");
INSERT INTO eri_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nere tau ganenga, no jaidu bona goi anyarodu sayori hogo fere-fere haga langa otode waha feiya nigi-nigina. Nomo tuwa aroro langa, neei nere edo maidu bode nomo tuwa langa nebere toomu haumu ooto langa tafodbode.” ");
INSERT INTO eri_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Saini Yesus no fai-aita bagu beele lenigi bona no beele baingaro muuji beele langa lenigai, no nebere ninanege isou haawe langa lenigaiha. ");
INSERT INTO eri_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","No beele ete te foomudu fai-aita bagu lenigei uwa. No muuji beele langanga, beele malalamudu lenigigai. Onodu, saini nomo disaipel bagu nagenga yafa bode, no beele waha nomo hugu oruwanga malalamudu lenigigai. ");
INSERT INTO eri_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Fati wahanga la esuwa, Yesus no nomo disaipel benou lenigai, “Ere yaage katiwou ulate langa goyei nomo nigai.” ");
INSERT INTO eri_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ono wainga nere fai-aita bagu toomaro waha awa nigidu bode, nere goidu bot Yesus no digedu yafai waha langa digedu bode Yesus haudu gaara goyane. Nere bot ila fere gaara goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nere goi ganenga jagui anyakaro jayaidu bona, hiiri korikori jaimu wainga, hiiri fekuladu bot huwanya la goi bolo wona onowai. ");
INSERT INTO eri_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ono gainga Yesus no bot hu langa mora si tafadu bona agore inyai. Ono gainga nere aimu tudu bode benou letuwane, “Isisi higou fai, ere yae woya juguya, ne ere umoya onoya waha aau menanga togo hanei uwa rute?” ");
INSERT INTO eri_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ono wanenga Yesus no jaidu bona jagui honggoro tuwai, onodu yaage benou letuwai, “Edonaha. Ne folowau! Ne umau!” Ono wainga jagui folo gainga, yaage menanga te fekulawei uwa. ");
INSERT INTO eri_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Onodu bona, nomo disaipel benou isoki nigai, “Tere taate boya umugeyaha? Tere huwanyatege ngalenga wegu uwa yo?” ");
INSERT INTO eri_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ono wainga nere danga bagu umugedu bode nere nage-nage benou leguruwane, “Fai beha no faiwei tigini, waha bona jagui yaage ngare no bolou isare?” ");
INSERT INTO eri_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus no nomo disaipel bagu Galili yaage katiwou fadu bode, goi ulate Gerasa nebere oula langa heiganeha. ");
INSERT INTO eri_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Onodu Yesus no bot awa tugainga, fai ete hauri inyaba bagu maidu toroba tuwai. Fai waha no haumu kejiwe matmat langa onou golodu bona mayaiha. ");
INSERT INTO eri_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","No haumu matmat langa inyi-inyina. Onodu fai ete te no dage tuwei nomo edo uwa, edo nere sen langa dage tuwodbode. ");
INSERT INTO eri_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Saini baingaro hankap langa, sen langa dage tunga wane, no hankap sen bagu kakatiridu ayaru nagigai. Fai waha no gai danga bagu, waha bona fai ete te no yaasu tuwei nomo edo uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","No gai-gai hoonga bagu ooru bagu matmat langa, muju ha langa yafagai. Ono bona no inyangaaro uidu nogo-nogo gogala megebu langa karugai. ");
INSERT INTO eri_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Fai waha no Yesus baae langa oto gainga uredu bona guriyedu maidu Yesus afo hugu langa afo tuburu kutudu yafaiha. ");
INSERT INTO eri_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Onodu no inyangaro ui bona Yesus benou letuwai, “Yesus ne Itou Gai Ouwe langa Idau, ne ji adadu ono hiyau ganga ononi? Ji Itou unyi langa ne danga bagu isoki hinini, ne ji adai inyabamu hiyau.” ");
INSERT INTO eri_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","No onou yauredu lewai, taate bona, Yesus no benou letuwai, “Ne hauri inyaba, ne fai waha tigini awa tuwau.” ");
INSERT INTO eri_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ono wainga Yesus no ege isoki tuwai, “Ne unyite faiwei?” Ono wainga letuwai, Ji unyife Oota fai. Wa taate bona ere toomaro. ");
INSERT INTO eri_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Onodu no Yesus danga bagu isoki tuwai wa, no hauri inyaba beha adai so nigonga oula beha awogu. ");
INSERT INTO eri_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Buuwa toomaro ete muju menakele ete hinomu langa da nyibode oto wane. ");
INSERT INTO eri_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ono ganenga hauri inyaba nere Yesus danga bagu benou isoki tuwane, “Ne ere huuru higahenga buuwa woha huwanyanege langa goyoya.” ");
INSERT INTO eri_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ono wanenga Yesus no awa nigainga goyane. Hauri inyaba nere fai waha awa tudu bode buuwa oto wane waha huwanyanege langa goyaneha. Ono wanenga buuwa nere danga bagu gurarudu ha inyaba langa minaneha. Onodu yaage katiwou langa orososodu bode yaage nyidu umeru waneha. Buuwa waha lelege nigou oruwanga 2,000 onou. ");
INSERT INTO eri_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ono wanenga buuwa oofa nigigou fai nere onou uredu bode, heige haradu goi taon langa ha fere-fere langa beele tafa bode golowaneha. Ono wanenga fai-aita bagu maidu bode taate dada tigini heigai waha uraneha. ");
INSERT INTO eri_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nere Yesus bagu heigedu bode fai waha amina hauri inyaba baingaro no langa inyane waha urane. Ono wane wa, elebe no ogola tagudu bona nomo ninau foowou yafa gainga urane. Nere fai-aita bagu, fai waha onou uredu bode umuganeha. ");
INSERT INTO eri_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ariya fai nere Yesus no dada ono gainga urane waha, nere ka fai-aita bagu hauri inyaba fai waha langa yafa ganenga, Yesus no so nigai waha aasa hai nagane. Ono bode, buuwa bode fere hai naganeha. ");
INSERT INTO eri_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ono wanenga, fai-aita bagu waha isidu bode, nere Yesus no nebere oula awa nagidu ha fere langa goyei nomo bode beele danga bagu lewaneha. ");
INSERT INTO eri_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ono wanenga Yesus no bot dige gainga, fai no amina hauri inyaba no langa inyane waha, no goidu bona Yesus danga bagu benou isoki tuwai, “Ne edo langa awa hiyahenga ne ngare goyoyare yo?” ");
INSERT INTO eri_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ono wainga Yesus no awai. No fai waha benou letuwai, “Ne name mata langa name ilibane gane bagu goyau. Onodu Anyakaro no ne bona aau warainga, ne hoyo hinei nomo dada oruwanga onowai waha hai nagau.” ");
INSERT INTO eri_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ono wainga fai waha no Dekapolis distrik oruwa langa goidu bona, Yesus no hoyo tuwei nomo bona dada oruwanga onowai waha, beele malalamudu hai nagai. Ono wainga fai-aita bagu oruwanga beele waha isidu bode, ninanege baingaro isaneha. ");
INSERT INTO eri_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus no ege bot digedu bona Galili yaage katiwou fadu ulate langa goyai. No goi ulate langa heigainga, fai-aita bagu, toomaro nomo beele isodbode mai kotowane. Ono wanenga, Yesus yaage katiwou hinomu langa otowai. ");
INSERT INTO eri_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ono gainga bori mata mora bagu ete unyi Jairus. No mai Yesus uredu bona goidu Yesus afo hugu langa afo tuburu kutudu yafai. ");
INSERT INTO eri_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Onodu no Yesus danga bagu benou isoki tuwai, “Yame aita magana menakele no umona onona. Plis, ne maidu owone no langa tafahenga, no ege hiloudu yafona.” ");
INSERT INTO eri_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ono wainga Yesus no ngare goyareha. Ono garenga fai-aita bagu toomaro no oojo tubode kitikiti tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Onodu aita ete yafagai, no ole taura gai onou gogala langa inyi gainga haga orei 12 goyai. ");
INSERT INTO eri_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aita waha no dokta baingaro nerigai, ono gainga nere gogala jimiri baingaro tuwane, no nere ejiya nigou langa moni oruwa ayaruwai. Ariya nomo taura menanga te jige tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aita waha no Yesus nomo aasa isai. Onodu no maidu bona fai-aita bagu baingaro oto ganenga, gamanege langa otowai. No Yesus mogo langa maidu jugu tudu bona, owo ayadu Yesus nomo kolos ufaro waha yaasuwai. ");
INSERT INTO eri_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aita waha no nogo-nogo benou lewai, “Ji ewe owofenga ayadu nomo kolos langa tafei mata woni wa, ji ege jige hiyonbona iwai.” ");
INSERT INTO eri_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Onodu aita waha no Yesus nomo kolos langa owo tafainga fasadu onou ganemu karadu kaitai, onodu gogala langa isai wa nomo taura faa tuwai. ");
INSERT INTO eri_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ono wainga Yesus no isai wa, no nomo danga ila awa tuwane. No ubuludu benou isoki wai, “Faiwei owo ayadu yame kolos yaasu hayaha?” ");
INSERT INTO eri_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ono wainga nomo disaipel benou letuwane, “Ne urau, fai-aita bagu toomaro ne kitikiti hinide. Waha bona ne taate boni leni, ‘faiwei ji langa owo tafana?’ ” ");
INSERT INTO eri_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ono wainga Yesus no faiwei nomo kolos yaasu fuwaha waha uronbona ago fere-fere igeiwai. ");
INSERT INTO eri_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ono wainga aita waha dada no langa heigai waha bona isidu umuge bona terere waiha. Onodu bona no maidu Yesus hinomu langa afo tuburu kutudu, dada oruwanga malalamudu lewaiha. ");
INSERT INTO eri_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ono wainga Yesus benou letuwai, “Yame magana, ne ji boni huwanyate ngalenga waha bona taura jige hinaha. Ne goyau, onodu huwanyate foinga inyou. Name taura edo usu hinonbona.” ");
INSERT INTO eri_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus no beele gai lebona oto gainga, bori mata mora bagu nomo mataha fai ila mayane. Onodu bori mata mora bagu benou letuwane, “Ne name magene umaha. Buyona ne isisi higou fai inyangaro ou adai tuwau.” ");
INSERT INTO eri_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ono wane wa, Yesus no nere maidu beele lewane waha aagu nigei uwa. No bori mata mora bagu benou letuwai, “Ne adai umugau. Ne huwanyatenga ngalengawou.” ");
INSERT INTO eri_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Onodu no fai-aita bagu adai taga tudu goyei nomo bona karu nigaiha. Ono wainga Pita, Jems, Jems bemu Jon, nere eei nagenga no ngate goyane. ");
INSERT INTO eri_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nere goi bori mata mora bagu nomo mata langa heigedu bode, Yesus no fai-aita bagu inyangaro gududu ganenga nerigai. Nere inyangaro merenga wane. ");
INSERT INTO eri_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Onodu bona no mata huwanya langa goidu benou lenigai, “Tere taate boya inyangaro mere boya gududuya? Aita magana beha no umei uwa. No ewe agore inyina.” ");
INSERT INTO eri_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ono wainga nere inyangaro nanai tuwane. Ono wanenga no fai-aita bagu oruwanga so nigainga malala heigane. Onodu aita magana waha umamu-anya ngare haniredu bona, nomo disaipel eei bagu aita magana inyai waha nomo jauli langa goyane. ");
INSERT INTO eri_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Onodu Yesus no aita magana waha owo yaasu bona benou letuwai, “Talita, kum.” Beele beha nomo hugu benou, “Aita menakele, ji lehinini, ne jayau.” ");
INSERT INTO eri_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ono wainga aita magana mena waha fasayadu jaidu golowaiha. Ono wainga nere waha uredu horoto wane. Aita magana mena waha nomo haga orei 12. ");
INSERT INTO eri_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ariya Yesus no beele danga bagu benou lenigai, “Tere dada heigaha beha fai ete te adai hai fuwagu.” Onodu aita magana waha da ila tuwogunga nyei nomo bona lenigaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus no matane waha awadu bona nomo matane hugu langa goyai. Ono wainga nomo disaipel no oojo tudu goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nere goidu bode Juda nebere bori nomo fati langa, Yesus no bori mata huwanya langa goidu bona Itou nomo hilou beele fai-aita bagu lenigai. Ono wainga fai-aita bagu baingaro nebereha ila Yesus nomo beele isidu bode horotodu benou lewane, “Fai beha no beele beha alanga taha? Isou no langa inyina beha, isou adoha? Onodu no adadu waha dodokawou hogo fere-fere tafana? ");
INSERT INTO eri_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ere alai, fai beha no kamda ete. No Maria idau, no Jems, Josep, Judas, Saimon ngate nebere bainege. No nomo ogobumu gane ere bagu gaara belanga yafaya.” Nere beele onou lebode Yesus bode huwanyanege inyabawai. ");
INSERT INTO eri_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ono wanenga Yesus no benou lenigai, “Profet no matane oruwa langa no unyi bagu. Ariya nogo nomo matane hugu langa, nomo ganemu etenga gamanege langa, nomo mata langa tigini, no unyi uwau.” ");
INSERT INTO eri_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Onodu no matane waha langa dodokawou ete tafei nomo edo uwa. No taura fai etenga-etenga wahanga owo jaulanege langa tafa bona taura ege jigemu nagaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Onodu no fai-aita bagu baingaro no bode huwanyanege ngalenga wegu uwa waha bona ninau baingaro isaiha. Onodu Yesus no goidu haumu waha langa matane-matane golo bona fai-aita bagu Itou nomo hilou beele hai nagaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","No nomo disaipel 12, yaure nigainga mayanenga, hauri inyaba nere fai-aita bagu langa inyide waha so nigei nomo bona danga nigai. Onodu nere nga-ngadu huuru nigainga goyane. ");
INSERT INTO eri_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Onodu no lenigai nere golowei nomo hoobu edo yaasu wode, ariya nere dada ila elegedu golowei nomo adai nigai. Nere beret bagu, nebere olodo dada bagu elegedu, moni poket langa jiridu golowei nomo adai nigai. ");
INSERT INTO eri_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nere su edo tanodbode, ariya nere siot nga bagu adai tanei nomo bona lenigai. ");
INSERT INTO eri_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Onodu nere benou lenigai, “Tere matane ete langa goi heigedu bonade, mata ete huwanya langa goyei mata bonade wonga, tere mata wahanga la yafadu goi saini tere matane waha awa tuwagu ganga. ");
INSERT INTO eri_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Onodu matane ila nere tere hatigedu nebere mata langa goyei nomo awa bode, tebere beele ada iso gonga wa, tere matane waha awa tuwagu. Onodu saini tere golo wagu ganga wonga, oula tuturumu afetege langa inyina waha utuwagu, ono wadenga nere nebere nyabuluwou fanyimu ono wane waha nere isodbode.” ");
INSERT INTO eri_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ono wainga Yesus nomo disaipel nere goidu bode, fai-aita bagu beele benou malalamudu lenigane, “Tere huwanyatege ubulu wagu.” ");
INSERT INTO eri_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Onodu bode nere hauri inyaba baingaro fai-aita bagu langa jiriwane waha so nigibode, taura fai baingaro faronga bisemu nigibode taura jigemu naganeha. ");
INSERT INTO eri_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herot no dada heigane waha beele isai, taate bona, ha-ha oruwa langa Yesus no unyi heigaiha. Nere fai-aita bagu ila Yesus bode benou lewane, “No Jon yaage bisemu nigigou matmat langa ege gidu jayaha. Waha bona no dodokawou waha tafei nomo danga bagu.” ");
INSERT INTO eri_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nere ila lewane, “No Elaija.” Ono ganenga ila lewane, “No profet, no nere profet aminaha waha dorofe.” ");
INSERT INTO eri_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ono wanenga Herot no waha isidu bona benou lewai, “Ji amina Jon bou karuwene waha no elebe ege jayaha.” ");
INSERT INTO eri_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Amina King Herot no bemu Filip oya Herodias ngau tai. Ono wainga Jon no Herot benou letuwai, “Ne baine Filip, oya ngau tenaha wa hilou uwa.” Ono wainga King Herot no fai ila huuru nigainga goidu bode Jon taidu tamai dagou mata langa sen langa dage tuwanenga yafai. ");
INSERT INTO eri_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias no Jon bona huwanya inyaba dewainga Jon dukotewei nomo onowai, ariya no edo uwa, ");
INSERT INTO eri_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","taate bona, King Herot no Jon umuge tuwai. Herot no isai, Jon no Itou ago langa no fai tigini onodu no fai hilobainga. Onou waha bona, Herot no Jon dagou mata langa yafa gainga no oofade tugai. Saini Herot no Jon nomo beele isidu, no ninau baingaro tebona no huwanya ou tugai. No Jon nomo beele isei nomo gaude tugai. ");
INSERT INTO eri_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Iinga la, Herodias no jala benou langa toroba waiha. King Herot no anya bisi tuwai waha nomo fati isisiwou da anyakaro ajaiha. No da waha fai aroro no gabman haruwe langa hoyo tude waha bagu, nere oota fai nebere ofisa bagu, nere Galili distrikha fai aroro bagu aji nagaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nere da nyibode yafa ganenga, Herodias mago no huwanya langa maidu bona moone uyai. Ono gainga Herot no fai no ngate da nyane waha bagu, nere Herodias mago nomo moone uyou waha uredu gaude nigaiha. Ono wainga King Herot no aita magana waha benou letuwai, “Ne taate dada gau hinonga ji hinon boni. Ne leweinga lewau, ono wahenga ji hinon boni.” ");
INSERT INTO eri_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Onodu Herot no beele danga bagu baara benou tawai, “Ngalenga ouwe langa, taate dada bonahe ji isoki hiyahe wonga, ji hinon boni. Ne ji yame kantri foure ngadu ulate hinei nomo le hiyei mata wahenga, ji onou ono wonboni.” ");
INSERT INTO eri_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ono wainga aita magana waha malala goidu bona anya benou isoki tuwai, “ji taate dada hiyei nomo bona letuwoni?” Ono wainga anya letuwai, “Ne Jon yaage bisemu nigigou fai nomo mora tedu tamai hinei nomo letuwau.” ");
INSERT INTO eri_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ono wainga aita magana waha fasayadu king bagu gidu goidu benou letuwai, “Gai elebenga la, Jon yaage bisemu nigigou fai nomo mora haaya ete langa tafadu hiyei nomo gau hina.” ");
INSERT INTO eri_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ono wainga King Herot no beele waha isidu bona no huwanya danga bagu ou tuwaiha. Onodu no beele baara danga bagu tawai waha bona ninau isidu bona, fai no ngate da nyibode yafane waha agenege langa mayau adai tou bona, no aita magana waha nomo beele feiya fuwei nomo awai. ");
INSERT INTO eri_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Onodu no fasayadu onou oota fai ete Jon mora tedu tamayei nomo bona huuru tuwai. Ono wainga oota fai waha no dagou mata langa goidu bona, Jon yaage bisemu nigigou fai boou karuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Onodu bona Jon mora haaya langa tafadu bona, tedu tamai aita magana waha tuwainga, aita magana waha tamaidu anya tuwai. ");
INSERT INTO eri_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ono wainga nere Jon nomo disaipel Herot no dada onowai waha beele isidu bode, maidu Jon nomo gogala tedu bode togoi matmat langa u-u tananeha. ");
INSERT INTO eri_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposel nere ege gidu maidu Yesus ngate komowaneha. Onodu bode nere haruwe taane waha bagu, nere fai-aita oruwanga beele lenigane waha aasa hayane. ");
INSERT INTO eri_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ono wane wa, nere fai-aita bagu baingaro goigoi maimai wanenga, Yesus no nomo aposel bagu da nyei nomo saini uwau. Ono wainga Yesus no aposel benou lenigai, “Ariya! Ere hagenga ha ete fai uwau langa goidu boya tere menanga houwe tafagu.” ");
INSERT INTO eri_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ono wainga nere nagenga bot tedu bode ha fai uwau langa goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ono wane wa fai-aita bagu baingaro nere goi ganenga nerigedu bode, nere ha adoha langa goide waha amina isi niganeha. Onodu bode nere taon waha nomo fai-aita bagu oruwanga gurarudu bode haumu Yesus no nomo disaipel bagu goyane waha langa amugedu goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ono wanenga, Yesus no bot langa goi horiyedu fai-aita bagu toomaro yafa ganenga nerigaiha. No nerigedu bona aau danga bagu warai, taate bona, nere sipsip nebere oofa nigou fai uwau dorofe. Onodu bona no beele baingaro lenigou hugu waraiha. ");
INSERT INTO eri_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Onodu iinga hoonga mini jorowona ono gainga, Yesus nomo disaipel maidu bode Yesus benou letuwane, “Ha beha langa fai uwau, hoonga amina minaha jorowona onona. ");
INSERT INTO eri_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hilobainga ne fai-aita bagu huuru nigahenga goyode. Nere goidu bode haumu fere-fere, matane langa nebere da dada ejiya wode.” ");
INSERT INTO eri_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ono wanenga Yesus no nomo disaipel beele ege benou gidu lenigai, “Tere we nere da nigadenga nyode.” Ono wainga nere Yesus isoki tuwane, “Ne ere moni 200 kina langa beret ejiyawei nomo gau hinina yo?” ");
INSERT INTO eri_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ono wanenga Yesus no ege gidu isoki nigai, “Tere beret agonyi inyina? Tere goidu uragu.” Ono wainga nere goi uredu bode maidu letuwane, “Ere beret anyimu kouwou, hoowe nga nononga bagu inyina.” ");
INSERT INTO eri_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ono wanenga Yesus no nomo disaipel lenigai, “Tere fai-aita bagu oruwanga lenigadenga jiigu hilobainga langa komo-komodu yafode.” ");
INSERT INTO eri_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ariya nere onou langa yafane wa, komowou ila fai 100, ila 50. ");
INSERT INTO eri_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ono ganenga Yesus no beret anyimu kouwou bagu hoowe nga nononga waha bagu elegai. Onodu no ha laluwa feele bona Itou hilobainga tuwai. Onodu bona beret kokorudu fai-aita bagu wese nagei nomo bona nomo disaipel nigaiha, onodu hoowe nga nononga waha fere onounga kokorudu fai-aita bagu oruwanga wese nagai. ");
INSERT INTO eri_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nere oruwanga nyanenga ogonege digaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Beret matau-matau, hoowe matau-matau bagu otowai waha nere elegedu komomudu bode, kekele 12 jiriwane. ");
INSERT INTO eri_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nere fai beret nyane waha oruwanga 5,000. ");
INSERT INTO eri_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ariya Yesus no nomo disaipel nere fasadu onodu bode, bot digedu yaage katiwou fadu ulate Betsaida matane langa amugedu goi gogunga, no nogo iinga fai-aita bagu huuru nigonga hara gogunga no goyonbona lenigaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","No fai-aita bagu huuru nigainga hara ganenga, ariya no hauya wonbona muju langa manaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gai esuwa langa, bot yaage katiwou gama langa oto gainga, Yesus nogonga laanga la yafaiha. ");
INSERT INTO eri_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ono bona no jagui bot mutu langa maibona bot nu tugainga nere koyawei nomo ababi ganenga nerigaiha. Onodu hamba wona ono gainga, Yesus no yaage katiwou jaula langa golodu nere bagu goyaiha. No feiya nigona onowai, ");
INSERT INTO eri_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ariya nomo disaipel, nere yaage katiwou jaula langa golo gainga urane, onodu nere yaage asa te ru iwane. Onodu nere umuge bode hiriwane. ");
INSERT INTO eri_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nere oruwanga uredu bode, danga bagu umugane. Ono wanenga, Yesus no fasayadu benou lenigai, “Tere danga bagu yafagu. Be jiwe. Tere adai umuge hiyagu.” ");
INSERT INTO eri_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Onodu bona no bot digainga gaara yafane, ono gainga jagui folowai. Ono wainga nere waha uredu bode horoto wane, ");
INSERT INTO eri_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","taate bode, saini Yesus no fai-aita bagu beret wese nagainga nyane waha nomo hugu nere ninanege fowei uwa. Nere ninanege gai onou fosokodu inyai. ");
INSERT INTO eri_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesus no nomo disaipel bagu yaage katiwou fadu goi Genesaret ulate langa horiyedu bode, bot dowaneha. ");
INSERT INTO eri_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nere bot awa tuganenga, fai-aita bagu Yesus uredu bode nere fasayadu bode isi tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Onodu bode nere matane ulate waha oruwa langa gurarudu golo bode fai-aita bagu lenigane. Ono wanenga nere fai-aita bagu Yesus no haumu adeha langa yafana waha isidu bode, nere taura fai kabali langa inyemu nigidu bode aule nigidu Yesus bagu goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Onodu Yesus no matane oruwa langa, taon oruwa langa, haumu fere-fere oruwanga no goi heigai langa, nere taura fai kotowou haumu langa logosi nigigane. Onodu bode nere Yesus danga bagu isoki tuwane, no taura fai awa nigonga nomo kolos mutu yaasu fuwei nomo bode. Ariya fai-aita bagu oruwanga onou ono wane waha, nere taura ege jige nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi nere nuuni beele isou fai ila bagu komodu bode, Jerusalem goidu Yesus uraneha. ");
INSERT INTO eri_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nere goidu bode Yesus nomo disaipel ila, nere owonege hugegu uwa, da nyi ganenga nerigane. ");
INSERT INTO eri_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi nere Juda oruwanga bagu, nere asanege gane nebere fanyinege oojo-oojode. Onou waha bode, nere owonege ada huge dewode wa nere da fasadu ada nyode. ");
INSERT INTO eri_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Saini nere maket langa goidu ege gidu maidu bode, yaage ada bisei mata wode wa, nere da ada nyode. Onodu nere asanege gane nebere onowou ila fere baingaro elegane waha oojo-oojode wa benou, nere kap bagu haaya bagu tauwe bagu kabali dada hugeru-hugerude. ");
INSERT INTO eri_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ariya Farisi bagu nuuni beele isou fai bagu nere Yesus benou isoki tuwane, “Ne name disaipel nere taate bode ere ebere asage gane nebere fanyinege ada oojo-oojode? Nere owonege jijiga bagu da nyide.” ");
INSERT INTO eri_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ono wanenga Yesus no benou lenigai, “Profet Aisaia no tere yaawawou fai bona no tigini isisi tigai. No beele benou yeregaiha, ‘Nere fai-aita bagu beha nere ewe huranege langanga unyife isoude, nebere huwanyanege ninanege bagu ji gai baae hidu inyina. ");
INSERT INTO eri_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nere ewe fai nebere nuuni beele wahanga malalamu bode lede, “Beha waha Itou nomo beele.” Ono bode nere ji unyife ewe isou-isoude.’ ");
INSERT INTO eri_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tere Itou nomo nuuni beele amina aweyeha, tere fai nebere onowou wahanga danga bagu yaasu yaasuya.” ");
INSERT INTO eri_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Onodu Yesus no ege benou lenigai, “Tere Itou nomo nuuni beele feiya boya tebere fanyitege wahanga oojowei nomo mai deweyeha. ");
INSERT INTO eri_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses no lewai, ‘Ne anyane amene ngare neire huuna langa yafa bonahe neire beele oojowau,’ onodu ‘fai no umamu yo anya yo beele inyaba letuwona wa, no umonbona.’ ");
INSERT INTO eri_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Onou wa tere benou leleya, ‘Fai ete no moni dada umamu yo anya yo hoyo tuwei nomo inyonbona, ariya no leniron bona, “Moni beha ji Itou tuwei nomo boni hangada naha inyina,” ");
INSERT INTO eri_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ariya fai waha no umamu anya ngare hoyo nirei nomo dada adai onowou.’ ");
INSERT INTO eri_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Onou waha bona tere onowou asatege gane langa tei waha oojo boya, Itou nomo beele ileiya. Ono boya tere fanyimu onouha waha baingaro ono-onoya.” ");
INSERT INTO eri_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus no fai-aita bagu ege yaure nigidu bona benou lenigai, “Tere oruwanga yame beele isidu bonade ninatege isi dewagu. ");
INSERT INTO eri_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dada fai ete langa malala inyidu, fai huwanya langa goyona waha no fai jijiga ada tuwonbona. ");
INSERT INTO eri_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dada fai huwanya langa inyidu malala langa heigena waha no fai jijiga tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Onodu Yesus no fai-aita bagu awa nigidu bona mata langa goyaiha. Ono gainga nomo disaipel nere no muuji beele lenigai waha nomo hugu isei nomo bode isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ono wanenga Yesus no benou lenigai, “Tere fere ninatege uwau yo? Dada oruwanga malala fai langa inyidu, fai huwanya langa goidu jijiga ada tuna waha tere alai uwa rute? ");
INSERT INTO eri_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ji benou lenaha, taate bona, dada onouha waha fai huwanya langa tigini ada mini minina. Uwa. No fai hewenege anya langa mini ganga, iinga nere hewenege yagu ganenga mata menekele la mini-minina.” Yesus no beele waha langa no benou lewai, “Da oruwanga Itou ago langa nere jijiga uwau.” ");
INSERT INTO eri_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Onodu Yesus no ege lewai, “Dada no fai huwanya langa inyidu bona, malala langa heigena waha no fai jijiga tutuna. ");
INSERT INTO eri_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ji dada hogo fere-fere fai ninau langa heigena waha boni leni, wa dada benou waha, Isou inyaba longi tafou, yebuwei nomo fanyimu, fai dunege kotewei nomo fanyimu bagu, ");
INSERT INTO eri_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","fai-aita te guruwou waha longi tafou, agenege warou, onowou inyaba, beele yaawawou, edegawou, huwanyage inyaba gonga ila beele inyaba lenigou, feeto bode dabu tayou fanyimu onowou. ");
INSERT INTO eri_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Onowou inyaba beha oruwanga fai huwanya langa inyidu malala heigena waha no Itou ago langa fai jijiga tutuna.” ");
INSERT INTO eri_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus no jaidu matane waha awadu bona ulate taon Tair langa goyaiha. Onodu no mata ete huwanya langa goyai, no fai ete te no walanga yafana iwou isei nomo awai. Onowai waha, no huwaridu yafei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aita ete Yesus walanga yafana iwou isaiha. Aita waha no nomo mago waha no hauri inyaba bagu. Aita waha no fasayadu maidu bona Yesus afo hugu langa afo tuburu kutudu yafai. ");
INSERT INTO eri_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aita waha no ha mata eteha. Aita waha no Fonisiaha, kantri Siria langa inyina. No mago hauri inyaba so fuwei nomo bona beele danga bagu Yesus isoki tuwai. ");
INSERT INTO eri_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ono wainga Yesus no benou letuwai, “Ere amugedu gaare mene-mene da nigidu. Gamaji ere gaare mene-mene nebere da elegedu gauna ayaru nagoga.” ");
INSERT INTO eri_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ono wainga aita waha no Yesus nomo beele ege gidu benou letuwai, “Anyakaro, gauna tebol huuna langa jiride, nere fere magana mene-mene nebere da tuturumu nyi-nyide.” ");
INSERT INTO eri_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ono wainga Yesus no aita waha letuwai, “Ne onou leni bona, ne dabu ege gidu goyau. Hauri inyaba ne name magene amina awa tuwaha.” ");
INSERT INTO eri_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ono wainga aita waha no ege gidu nomo mata langa goidu bona hauri inyaba nomo magana awa tuwainga, kabali langa inyi gainga uraiha. ");
INSERT INTO eri_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ariya Yesus no ege jaidu Tair ulate waha awadu Saidon taon nomo distrik langa goyaiha. No gai goidu Dekapolis ulate langa heigedu bona Galili yaage katiwou langa goi heigaiha. ");
INSERT INTO eri_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ono wainga fai ete agokuli fosokowou onodu munyagu ou bagu, no beele ledewei nomo edo uwa, nere haudu bode Yesus bagu mayaneha. Onodu Yesus no fai waha langa owo tafei nomo bode isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ono wanenga Yesus no fai-aita bagu awa nigidu, fai waha hawainga goidu nere narenga yafare. Onodu Yesus no fai waha agokuli nga langa owo jirou tafai. Onodu iinga nogo owo jirou langa mulugu bisingadu bona fai waha munyagu langa tafaiha. ");
INSERT INTO eri_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Onodu Yesus no ha laluwa feele tugainga merou mayainga hoouwe danga bagu tai. Ono bona fai waha benou letuwai, “Efata.” Waha nomo hugu benou, “Ne fokowau.” ");
INSERT INTO eri_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ono wainga fai waha agokuli fasayadu foko tubona, dada munyagu ou tuwai waha faa tuwainga beele ledewei nomo edo isaiha. ");
INSERT INTO eri_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Onodu Yesus no fai-aita bagu nere dada urane waha fai ete te adai hai fuwei nomo bona danga bagu karu nigaiha. Ariya uwa, nere beele waha malalamuwei nomo bode danga tafaneha. ");
INSERT INTO eri_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ono wanenga fai-aita bagu beele waha isidu bode horoto wane, onodu lewane, “No dada oruwanga onona waha dada hilobainga wahanga onona. No agenege kuli fokomu nagi ganga beele iside, fai huranege fosokowou beele lede.” ");
INSERT INTO eri_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Saini waha langa fai-aita bagu toomaro ege mai kotowane wa, nere da uwau. Ono wanenga Yesus no nomo disaipel yaure nigainga mayanenga, benou lenigai. ");
INSERT INTO eri_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ji nere fai-aita bagu beha boni aau yarina, nere ji ngate yafa geyenga fati ei oruwa usu waha, da uwau. ");
INSERT INTO eri_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nere huweli onou yafa gogunga ji nebere mata langa huuru nigoni wa, gamaji nere jala gama huweli bode agenege gui wonga orososo woguga. Nere ila ha baae langa golodu mayaneha.” ");
INSERT INTO eri_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ono wainga nomo disaipel beele ege gidu benou letuwane, “Haumu beha fai uwau. Onou waha bona ere beret alanga elegedu boya fai-aita bagu beha nigedenga nyode?” ");
INSERT INTO eri_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ono wanenga Yesus no nomo disaipel isoki nigai, “Tere beret agonyi inyina?” Ono wainga nere letuwane, “Ere beret 7 inyide.” ");
INSERT INTO eri_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ono wanenga Yesus no fai-aita bagu lenigainga oula langa yafane. Ono ganenga no beret 7 waha elegedu Itou hilobainga tudu bona, lalatidu bona nomo disaipel wese nagei nomo bona nigai. Ono wainga nomo disaipel nere fai-aita bagu wese naganeha. ");
INSERT INTO eri_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Onodu fere nere hoowe mene-mene etenga-etenga bagu. Yesus no hoowe waha fere Itou hilobainga tudu bona wese nagei nomo bona disaipel lenigai. ");
INSERT INTO eri_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Saini fai-aita bagu nyanenga ogonege digainga, da matau-matau awaru wane waha, elege komomudu bode kekele 7 jiri wane. ");
INSERT INTO eri_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nere fai-aita bagu waha lelege nigou 4,000 onou. Onodu Yesus no huuru nigainga hara ganenga, ");
INSERT INTO eri_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","no fasayadu bona nomo disaipel bagu bot digedu bode ulate Dalmanuta distrik langa goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi nere Yesus bagu maidu bode, beele langa warawou hugu tafane. Nere Yesus no Itou nomo haruwe tena waha abitimuwou dodoka ete naani dorofe tafon bona lewane. Nere ewe wala-wala tu urei nomo ono wane. ");
INSERT INTO eri_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ono wanenga Yesus no nomo hauri langa isai wa no ou tuwai, ono wainga benou lewai, “Saini beha nomo fai-aita bagu nere taate bode naani urei nomo yaurede? Ji tere ngalenga letigini, nere naani ete te ada urodbode, gai uwanga uwa.” ");
INSERT INTO eri_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Onodu no awa nigidu bona ege bot digedu, yaage katiwou ulate langa goyaiha. ");
INSERT INTO eri_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus nomo disaipel nere agenege digainga beret ila elegedu mayegu uwa. Nere beret gai etenga wahanga bot langa inyaiha. ");
INSERT INTO eri_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ono wainga Yesus no beele danga bagu benou lenigai, “Tere oofa dewagu. Tere Farisi nebere yis bagu Herot nomo yis bagu ure dewagu.” ");
INSERT INTO eri_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ono wainga Yesus nomo disaipel nere nage-nage gama langa benou leguru wane, “No beele onou lehigina waha taate bona, ere beret uwau rute.” ");
INSERT INTO eri_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ono wanenga Yesus no nomo disaipel beele onou lewane waha amina isi nigidu bona, benou lenigaiha, “Tere taate boya tere tagetage beele kejiwe benou leya, ‘Ere beret uwau guruya?’ Tere fo tigei uwa rute? Tere isou uwau rute? Tere agetege digaha yo? ");
INSERT INTO eri_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tere agetege bagu, onou wa tere dada nerigegu uwa yo? Tere agetege kuli bagu, onou wa tere beele isegu uwa yo? Tere ninatege hilala waiha yo? ");
INSERT INTO eri_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Saini ji beret anyimu kouwou, fai 5,000 lalatidu nigene nyanenga ogonege digainga beret matau-matau awaru wanenga otowai waha, tere kekele agonyi jiri weyeha yo?” Ono wainga nere letuwane, Kekele “12.” ");
INSERT INTO eri_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Saini ji beret 7, fai 4,000 lalatidu nigene nyanenga, matau-matau giwai waha, tere kekele agonyi jiri weyeha yo?” Ono wainga nere letuwane, “Kekele 7.” ");
INSERT INTO eri_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ono wanenga no lenigai, “Tere isegu uwa rute?” ");
INSERT INTO eri_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus no nomo disaipel bagu goi Betsaida matane langa heiganenga, fai ete ago fosokowou haudu bode no bagu mayaneha. Onodu nere Yesus no owo fai waha jaula langa tafei nomo bode letuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ono wanenga Yesus no fai waha owo yaasudu bona haudu matane gisa langa goyaiha. Onodu bona mulugu ago langa bisinga fudu bona, owo fai waha jaula langa tafa bona, benou isoki tuwai, “Ne dada ete ureni yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ono wainga fai waha igei bona Yesus benou letuwai, “Ji fai ila nerigeni, ariya ji nere nauge dorofe golodu goi ganenga nerigeni.” ");
INSERT INTO eri_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ono wainga Yesus no owo ege fai waha ago langa tafai. Ono wainga fai waha danga bagu igei wainga, ago hilou wainga, dada oruwanga foodu nerigaiha. ");
INSERT INTO eri_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ono wainga Yesus no fai waha huuru tuwainga nomo mata langa goi gainga, benou letuwai, “Ne matane huwanya langa adai goyau.” ");
INSERT INTO eri_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus no nomo disaipel bagu jaidu nere matane, Sisaria taon Filipai hinomu langa goyaneha. Nere goi bode jala langa Yesus no nomo disaipel benou isoki nigai, “Nere fai-aita bagu ji bode faiwei tigini hide yo?” ");
INSERT INTO eri_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ono wainga nere letuwane, “Nere ila Jon yaage bisemu nigigou fai ide. Ila lede, ne Elaija. Ono ganenga nere ila lede, ne profet ete.” ");
INSERT INTO eri_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ono wanenga Yesus no nere benou isoki nigai, “Ariya tere tage ji faiwei hiya yo?” Ono wainga Pita no Yesus nomo beele ege gidu benou letuwai, “Ne fai Itou nomo fai-aita bagu ege gidu hanigei nomo hangada hinai waha.” ");
INSERT INTO eri_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ono wainga Yesus no nogo faiwei waha nomo disaipel nere fai ete te adai letuwogu bona karu nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Onodu Yesus no nomo disaipel benou isisiwou nigai, “Fai Nomo Idau no jimiri baingaro tonbona, nere mora bagu, nere pris aroro, nere nuuni beele isou fai, nere no moge tubode dukote wogunga umonbona. Ono wogunga fati eei langa no ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus no beele beha malala foomudu lenigaiha. Ono wainga Pita no Yesus haudu gisa langa goidu bona honggoro tuwou hugu warai. ");
INSERT INTO eri_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ono wainga Yesus no ubuludu nomo disaipel feele nigi bona, Pita honggoro tubona benou letuwai, “Satan, ne mogofe langa goyau. Ne Itou nomo isou oojowei uwa. Ne fai nebere isounga oojoni.” ");
INSERT INTO eri_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Onodu Yesus no nomo disaipel bagu nere fai-aita bagu yaure nigainga mayanenga benou lenigai, “Fai ete no ji oojo hiyona wonga, nomo gauwou ilei bona nomo nauge abalakawou auledu oojo hiyona. ");
INSERT INTO eri_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wa taate bona, fai ete no nogo nomo ago auma yafou yaasu wona wa, no nomo ago auma yafou wa yae wonbona. Fai ete no ji bona bagu yame hilou beele bona bagu ninau isidu bona nomo ago auma yafou awona wa, no nomo ago auma yafou waha inyi dewonbona. ");
INSERT INTO eri_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Fai ete no oula nomo dada oruwanga elegedu, no nomo ago auma yafou yae wona wa, ariya dada waha oruwanga adadu hoyo tuwodbode? ");
INSERT INTO eri_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Fai waha no nomo ago auma yafou waha ege ejiyawou taate dada nigonbona? ");
INSERT INTO eri_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Elebe saini beha nomo fai-aita bagu nere Itou moge tubode, onowou inyaba hogo fere-fere onode. Onodu nebereha fai ete no ji bona, yame hilou beele bona bagu mayau tuwei mata wona wa, iinga huunta langa, Fai Nomo Idau no Umamu nomo lala anyakaro langa yafa gonga, Itou nomo ensel bagu mode saini waha langa, Fai Nomo Idau fere fai waha bona mayau tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Onodu Yesus no benou lenigai, “Ji tere ngalenga letigini, fai ila otode beha nere umeru wegu uwa langa Itou nomo huuna langa yafou no danga bagu heigonga urodbode.” ");
INSERT INTO eri_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Fati 6 usu wainga, Yesus no Pita wainga Jems wainga Jon, hanigedu muju ete gai ouwe langa manai. Onodu nere nagenga walanga yafane. Nere yafa bode igei ganenga, Yesus gogala ubuludu hogo ferete heigaiha. ");
INSERT INTO eri_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","No nomo ogola dada lala dorofe heigai, onodu gai kaamba foowou. Oulaha fai ete no ogola gai kaamba onouha ete heigemuwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ono gainga Elaija no Moses ngare heigarenga Yesus ngate beele hai ganenga Yesus nomo disaipel nerigane. ");
INSERT INTO eri_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita no waha uredu bona Yesus benou letuwai, “Isisi higou fai, ere belanga hilobainga yafaya. Ere edo youyou ei nononga tafoboya, ete name ete Moses nomo ete Elaija nomo tafoboya.” ");
INSERT INTO eri_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita no onou lewai, wa taate bona, nere danga bagu umugane, onodu Pita no taate beele lewei nomo foo tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ono gainga agau ete maidu kutau nigai. Ono wainga agau waha huwanya langa fai bolonege ete benou lewai, “Beha ji yame Idafe, Ji no gaude tuni. Tere nomo beele isagu.” ");
INSERT INTO eri_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ono wainga Yesus nomo disaipel fasayadu onou agenege fere-fere igeidu fai ete te uregu uwa. Yesus nogonga nere bagu yafa gainga uraneha. ");
INSERT INTO eri_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Onodu nere muju awadu heigedu mini bode, Yesus no benou lenigai, “Dada tere ureyaha beha fai ete te adai hai fuwadenga isona, goi saini Fai Nomo Idau no matmat awadu ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ono wainga nere beele waha yaasudu bode nere nage-nage benou leguruwane, “Matmat awadu ege jayei nomo beele beha, taate bona lena?” ");
INSERT INTO eri_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Onodu nere Yesus benou isoki tuwane, “Nere nuuni beele isou fai taate bode Elaija no mayonga wou onou lelede?” ");
INSERT INTO eri_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ono wanenga Yesus no ege gidu benou lenigai, “Beele beha no ngalenga. Elaija no ege gidu maidu bona, dada oruwanga ege tiginimu wonbona. Onou wa taate bona beele beha Itou nomo buk langa inyina, Fai Nomo Idau no jimiri baingaro tonga, fai nere no inyabamu tuwode yo? ");
INSERT INTO eri_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Onou wa ji tere benou letigini, Elaija no amina mayai. Ono wainga fai nere nebere gauwou oojo bode nere onowou hogo fere-fere ono tuwane. Itou nomo buk langa beele inyina dorofe.” ");
INSERT INTO eri_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus no nomo disaipel eei bagu goi disaipel ila waha bagu heigedu bode, fai-aita bagu toomaro nomo disaipel kolili nigidu oto ganenga, nuuni beele isou fai ila nere bagu beele langa wara ganenga nerigane. ");
INSERT INTO eri_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ono ganenga fai-aita bagu nere waha oruwanga Yesus mayainga uredu horoto wane, onodu gurarudu goidu Yesus kaiye tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ono wanenga Yesus no benou isoki nigai, “Tere taate boya nere bagu beele langa waraya?” ");
INSERT INTO eri_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ono wainga fai ete nere fai-aita bagu toomaro waha gamanege langa no beele ege gidu benou letuwai, “Isisi higou fai, hauri inyaba ete hurau fosokowou yame fai magana langa inyina, waha boni ji no haudu ne bagu mainaha. ");
INSERT INTO eri_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Saini baingaro hauri inyaba waha no danga bagu yaasu tudu bona, te kaite tuganga oula langa taumena. Ono ganga no mulugu kaamba maibona maa gidodo bona gogala oruwa dei-deina. Ji name disaipel nere hauri inyaba waha so tuwei nomo boni leniginaha, ariya nere edo uwa.” ");
INSERT INTO eri_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ono wainga Yesus no beele waha isidu bona fai-aita bagu benou lenigai, “Oo tere fai-aita bagu huwanyatege ngalengawou uwau, Ji saini agonyi gai tere bagu yafoni? Ji saini agonyi tebere ou auloni? Tere magana waha haudu ji bagu mayagu.” ");
INSERT INTO eri_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ono wainga nere magana waha haudu bode Yesus bagu goyanenga, hauri inyaba no Yesus uredu bona fasayadu magana waha inyangaaro nudu kaite tuwainga oula langa me taumedu ubadi gainga, mulugu kaamba-kaamba hurau langa mayaiha. ");
INSERT INTO eri_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ono wainga Yesus no magana waha umamu isoki tuwai, “Saini agonyi no benou ono bona yafaiha?” Ono wainga no Yesus benou letuwai, “Saini no menakele langa inyi gainga. ");
INSERT INTO eri_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Saini baingaro hauri inyaba waha no eeya langa aya tugai, yaage langa aya tugai, ono bona dukote wona onogai. Waha bona ne edo wonga, ere bonahe augami hinonga hoyo higau.” ");
INSERT INTO eri_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ono wainga Yesus no magana waha umamu benou letuwai, “Ne taate boni leni, ‘ne edo wonga?’ Ne huwanyate ngalenga wonga wa, ne dada oruwanga onowei nomo edo.” ");
INSERT INTO eri_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ono wainga fasadu onou magana waha umamu no inyangaaro yauredu benou lewai, “Ji huwanyafe ngalengana, ariya ji yame huwanyafe ngalengawou tutu. Ne hoyo hiyau.” ");
INSERT INTO eri_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus no fai-aita bagu toomaro gurarudu mai jugu niganenga nerigai. Onodu no hauri inyaba waha honggoro tubona benou letuwai, “Hauri inyaba hurate agene kuli bagu fosokowou, ji lehinini, ne magana beha awa tuwau. Ne ege no huwanya langa adai goyau.” ");
INSERT INTO eri_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ono wainga hauri waha inyangaaro yauredu, no magana waha inyangaaro onou nu tudu bona awa tudu heige fagawai. Ono wainga magana waha no umou dorofe inyai. Ono wainga fai-aita bagu baingaro uredu bode, “No umaha iwane.” ");
INSERT INTO eri_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Onou wa, Yesus no magana waha owo yaasudu bona, jaimu tuwainga jaidu otowaiha. ");
INSERT INTO eri_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iinga Yesus no mata langa goyainga, nomo disaipel nere nagenga yafa bode benou isoki tuwane, “Adadu waha ere hauri inyaba waha so tuwei nomo edo uwa?” ");
INSERT INTO eri_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ono wanenga no benou lenigai, “Hauyawei nomo fanyimu langanga hauri inyaba onouha waha so tuwei nomo edo.” Jala ete-ete la edo uwa. ");
INSERT INTO eri_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus no nomo disaipel bagu taon waha awadu bode golodu Galili distrik gama langa goyaneha. Onodu Yesus no walanga yafana iwou fai ete te isei nomo awaiha, ");
INSERT INTO eri_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","wa taate bona, no nomo disaipel isisiwou nigou haruwe tai. No benou lenigai, “Nere Fai Nomo Idau fai owonege langa tafa tuwodbode, Ono wogunga nere dukote wogunga umonbona. Nere dukote wogunga umedu, fati eei langa no ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ariya beele waha nomo hugu nere foo nigei uwa. Waha bode nere beele waha ege gidu isoki tuwei nomo umuganeha. ");
INSERT INTO eri_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ariya nere goi Kaperneam taon langa heigane. Onodu bode mata huwanya langa goidu, Yesus no nomo disaipel benou isoki nigai, “Tere jala langa golo boya taate beele leguruyaha?” ");
INSERT INTO eri_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ono wainga nere beele ete ege gidu letu weguwa. Wa taate bode, nere jala langa golo bode faiwei no nebere amugou yafonbona waha bode beele langa wara wane. ");
INSERT INTO eri_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ono wanenga Yesus no yafa bona nomo disaipel 12, yaure nigainga mayane. Nere mayanenga no benou lenigai, “Fai ete no amugou yafona wonga, no gai huunta yafonbona, no fai oruwa hoyo nigei nomo haruwe fai dorofe yafonbona.” ");
INSERT INTO eri_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Onodu no magana menakele ete haudu bona nere gamanege langa otomu tudu magana mena waha yaasu tubona benou lenigai, ");
INSERT INTO eri_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Fai ete ji bona isidu, magana ete magana beha dorofe hoyo tuwona wa, no ji hoyo hina. Onodu fai no ji hoyo hina waha no jiinga hoyo hiyei uwa. No Jijei ji huuru hiyainga mene waha, no hoyo tuna.” ");
INSERT INTO eri_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon no Yesus benou letuwai, “Isisi higou fai, fai ete ne unyite langa hauri inyaba so nigi ganga ureyaha. Ariya no ere oojo higei uwa. Onou waha bona ere no karu tuyaha.” ");
INSERT INTO eri_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ono wainga Yesus no Jon benou letuwai, “Tere adai karu tuwagu. Fai ete no ji unyife langa dodoka tafei mata wonga wa, no ji beele inyaba fasayadu ada lehiyon bona. ");
INSERT INTO eri_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Fai no ere ada honggoro higina waha, no ere ebere ilibage. ");
INSERT INTO eri_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Fai ete no tere terigedu bona benou isei mata wona, ‘Ji Kristus nomo fai hoyo nigon boni.’ Onodu no tere yaage kap langa tigona wa, ji tere ngalenga letigini, fai waha no nomo agou ada uwa wonbona.” ");
INSERT INTO eri_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yesus no ege benou lena, fai ete no magana mene-mene ji bode huwanyanege ngalengade waha, ono nigonga nere une langa metaumeruwei mata wode wa, hilobainga nere fai waha megebu anyakaro bou langa dagedu hiiri ogomu langa te kaite tuwogunga minidu umona. ");
INSERT INTO eri_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ne name owone ete no ono hinonga une langa meboduwei mata bonahe wonga wa, ne owone ete karudu kaitau. Ono wahenga hilobainga ne owone etenga inyonga, ne agene auma yafou tigini tau. Gamaji ne owone nga inyonga ne eeya ha, eeya ada gare-garena waha langa goyau ganga. ");
INSERT INTO eri_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Onodu ne name afene ono hinonga une tafei mata bonahe wonga wa, ne afene karudu kaitau. Ono wahenga hilobainga ne afene etenga inyonga ne agene auma gai-gai yafou tau. Gamaji ne afene nga bagu wonga nere eeya ha langa aya hinoguga. ");
INSERT INTO eri_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Onodu ne agene magana ete ono hinonga une tafei mata bonahe wonga, ne agene magana waha fasidu kaitau. Ono wahenga hilobainga, ne agene magana etenga wonga, ne Itou nomo huuna langa yafou huwanya langa goyau ganga. Gamaji ne agene magana nga bagu wonga, eeya ha langa aya hinoguga. ");
INSERT INTO eri_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Haumu waha langa, ‘maruma mene-mene genege gala nyi-nyide, nere ada usu wode. Ono ganga eeya genege gala bitina, waha fere ada usu wona.’ ");
INSERT INTO eri_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Nere Itou ago langa eege heigei nomo bode, eeya muru warou oruwa langa sol tafa-tafade. Onou dorofenga, eeya no fai oruwa langa heigonbona. ");
INSERT INTO eri_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol no dada hilobainga. Onou wa, sol nomo iisa usuwei mata wonga, tere ege adadu ono wadenga sol ege iisa bagu wona? Sol no kaafa dada ono nigiganga hilou inyi-inyina, onou dorofenga tere sol hilobainga dorofe heigedu yafou hilobainga baitege gane gamanege langa heigemu wagu.” ");
INSERT INTO eri_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus no jaidu bona haumu waha awadu, Jordan yaage ulate Judia distrik langa goyai. Ono wainga fai-aita bagu baingaro ege mai komo tuwane. Ono wanenga no nomo onowou oojo bona fai-aita bagu Itou nomo beele lenigaiha. ");
INSERT INTO eri_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ono gainga Farisi nere Yesus bagu maidu bode wala-wala tu urode ono wane. Nere benou isoki tuwane, “Ere ebere nuuni beele no fai-aita bagu te guruwou waha, fai no aita edo awa tuwona yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ono wanenga Yesus no nebere beele waha ege gidu benou lenigai, “Moses no nuuni beele adoha waha tigai?” ");
INSERT INTO eri_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ono wainga nere letuwane, “Moses no fai ete fai-aita ngare te guruwou waha karuwei nomo wonga, pepa ete yeregedu aita tudu bona awa tuwonga fagawei nomo edo iwai.” ");
INSERT INTO eri_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ono wane wa Yesus no benou lenigai, “Tere fetowou fai, waha bona Moses no nuuni beele beha yerege tagaiha. ");
INSERT INTO eri_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Isagu. ‘Gai amina langa, saini Itou no dada oruwanga tafa borodu bona, no fai-aita bagu tafa nigai, onodu no nomo nigainga fai-aita bagu heigane. ");
INSERT INTO eri_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Waha bona fai no umamu anya ngare awa niridu bona oya ngare fadadu yafa-yafadere, ");
INSERT INTO eri_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","onodu nere genere gala etenga heigare.’ Itou no onou lewai bona nere nga dorofe yaferu uwa, Nere genere gala etenga dorofe heigare. ");
INSERT INTO eri_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Waha bona dada Itou no amina dagai waha, fai no adai futu wona.” ");
INSERT INTO eri_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iinga Yesus no nomo disaipel bagu mata langa gidu goidu bode, no nomo disaipel fai-aita bagu te guruwou karude beele waha ege isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ono wanenga Yesus no benou lenigai, “Fai ete no oya awa tudu bona ege aita ete tei mata wona wa, no nomo oya inyabamu tudu bona longi fanyimu tafaha. ");
INSERT INTO eri_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Onou dorofenga aita ete no au awa tudu bona fai ete tei mata wona wa, no longi fanyimu tafaha.” ");
INSERT INTO eri_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ariya nere magana mene-mene hanigedu Yesus bagu mayane. Nere no owo magana mene-mene langa tafei nomo bode gau nigai. Ono wanenga Yesus nomo disaipel nere fai-aita bagu honggoro nigane. ");
INSERT INTO eri_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus no waha uredu bona huwanya inyaba wainga, nomo disaipel benou lenigai, “Tere magana mene-mene awa nigadenga ji bagu mayode. Tere adai karu nigagu. Itou nomo huuna langa yafou wa fai nere magana mene-mene benouha waha nebere. ");
INSERT INTO eri_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ji tere ngalenga letigini, fai ete no Itou nomo huuna langa yafou, nere magana mene-mene tetede dorofe ada tei mata wonga, Itou nomo huuna langa yafou waha huwanya langa ada goyonbona. Gai uwanga uwa.” ");
INSERT INTO eri_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Onodu Yesus no magana mene-mene owo langa yaasu nigi bona, owo jaulanege langa tafadu, Itou figini nigei nomo bona isoki tuwai. ");
INSERT INTO eri_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus no golodu goi gainga, fai ete guriyedu mai Yesus langa afo tuburu kutudu benou isoki tuwai, “Isisi higou fai hilobainga, ji adadu onodu boni agefe auma gai-gai yafou hilobainga waha toni?” ");
INSERT INTO eri_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ono wainga Yesus no fai waha benou letuwai, “Ne taate boni ji fai hilobainga hini? Itou no nogonga hilobainga. ");
INSERT INTO eri_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne nuuni beele langa beele iseneha, ‘Tere fai-aita bagu ila adai dunege kote wagu. Tere fai-aita bagu te guruwou waha longi fanyimu adai ono wagu. Tere dada adai yebu wagu. Tere fai-aita bagu ila yaawa nigou langa kot langa adai tafa nigagu. Tere fai ila yaawa nigidu nebere dada adai nganege elegagu. Tere ametege anyatege gane nebere huuna langa yafa bonade, belenege oojo wagu.’ ” ");
INSERT INTO eri_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ono wainga, fai waha no Yesus benou letuwai, “Isisi higou fai, saini ji menekeleha mai elebe langa, ji nuuni beele waha oruwanga oojoni.” ");
INSERT INTO eri_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ono wainga Yesus no fai waha fele-fele tudu gaude tuwai. Onodu fai waha benou letuwai, “Ne dada etenga boni gai tutu hinina. Ne goidu name dada huurudu bonahe, dada waha nomo moni tedu, fai dadanege uwau waha nigau. Ne onou ono bonahe wonga, ne ha laluwa langa dada hilobainga bagu. Ne maidu ji oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ono wainga fai waha no beele waha isidu bona, hogo karadu huwanya ou tugainga goyaiha. Wa taate bona, no dada baingaro bagu. ");
INSERT INTO eri_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ono wainga, Yesus no nomo disaipel feele nigi bona lenigai, “Nere fai dada baingaro bagu waha, Itou nomo huuna langa yafou waha huwanya goyei nomo darau.” ");
INSERT INTO eri_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ono wainga Yesus nomo disaipel nere Yesus nomo beele waha isidu bode horoto wane. Ono wanenga Yesus no beele ege gidu benou lenigai, “Yame magana gane, fai no Itou nomo huuna langa yafou waha huwanya langa goyei nomo haruwe danga. ");
INSERT INTO eri_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ariya Kamel no kolos ereregou nil jogodo langa goyei nomo wa, moni fai no Itou nomo huuna langa yafou waha huwanya la goyei nomo ababina dorofe uwa.” ");
INSERT INTO eri_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ono wainga Yesus nomo disaipel nere horotodu bode nere nage-nage benou leguruwane, “Onou wonga, faiwei no edo agenege auma gai-gai yafou waha tona?” ");
INSERT INTO eri_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ono wanenga Yesus no nomo disaipel tigini feele nigi bona benou lenigai, “Fai nere nagewe edo uwa. Itou no edo langa. Itou no dada oruwanga edo langa ono wonbona.” ");
INSERT INTO eri_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ono wainga Pita no Yesus beele ete benou letuwai, “Urau. Ere ebere dada oruwanga awaru yaha inyi ganga ne oojo hiniya.” ");
INSERT INTO eri_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ono wainga Yesus no lenigai, “Ji ngalenga letigini, fai oruwanga nere ji bode, hilou beele bode isidu, nebere mata awode yo, bainege gane yo, ogonege gane yo, anyanege-amenege gane yo, magana yo, haga yo, awarudu ji oojo hide wa, ");
INSERT INTO eri_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nere 100 ege elegod bode. Saini nere oula belanga gai yafode waha, Itou no dada baingaro nigonbona, amina nere dada ila bagu yafane waha feiya tuwou. Nere mata baingaro, bainege gane baingaro, ogonege gane baingaro, anyanege gane baingaro, magana baingaro, haga baingaro elegod bode. Onodu fere, fai ila onowou inyaba ono nigodbode. Onodu saini iinga huunta mayona langa, nere agenege auma gai-gai yafou waha todbode. ");
INSERT INTO eri_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Onou wa fai baingaro nere elebe amugou yafade waha, nere gai huunta yafodbode. Fai baingaro nere huunta yafade waha, nere amugou yafodbode.” ");
INSERT INTO eri_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus no nomo disaipel bagu jala golodu Jerusalem goyode onowane. Yesus no nere amuge nigidu goyaiha. Ono wainga nomo disaipel ninanege baingaro isane. Ono ganenga fai-aita bagu nere oojo nigane wa, nere umugane. Yesus no ege nomo disaipel 12 waha hanigedu bona, dada no langa heigon bona waha hai nagou hugu warai. ");
INSERT INTO eri_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesus no benou lenigai, “Isagu. Ere elebe Jerusalem goiya, ere goyedenga nere Fai Nomo Idau pris aroro bagu nuuni beele isou fai bagu owonege langa tafa tuwodbode. Onodu nere kot langa tafa tudu bode, dukote wogunga umonbona waha bode beele ngado wodbode. Onodu nere fai fereha nigodbode. ");
INSERT INTO eri_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ono wogunga fai nere waha memesi tubode bisinga tubode falagati uulu tudu, dukote wogunga umonbona. Ono wogunga fati eei langa no ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi idau gane nga nononga, Jems Jon ngare, nere Yesus bagu maidu bodere benou letuware, “Isisi higou fai, ere dada ete boyare isoki hino boyare, ne dada waha ono harau ganga boyare gau hirina.” ");
INSERT INTO eri_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ono warenga Yesus no benou isoki nirai, “Tere ji taate dada ono tarei nomo gau tirina?” ");
INSERT INTO eri_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ono wainga nere letuware, “Saini ne king anyakaro heigedu bonahe, ere gau yare ere gamarere langa ete, ne owone hilou langa yafa gonga ete ne owone kenao langa yafonbona.” ");
INSERT INTO eri_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ono warenga Yesus no benou lenirai, “Tere dada ji isoki hiyare beha boyare ada isi deyare. Dada kap langa elebe ji nyonboni waha tere nyei nomo edo yo? Yaage bisou elebe ji toni ononi beha tere tei nomo edo yo?” ");
INSERT INTO eri_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ono wainga nere letuware, “Ere edo langa.” Ono warenga Yesus no lenirai, “Ngalenga, kap elebe ji nyoni ononi beha langa tere fere nyaru ganga, onodu yaage bisou elebe ji toni ononi beha tere fere taru ganga. ");
INSERT INTO eri_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ariya faiwei no ji owofe hilou langa yafa gonga faiwei no ji owofe kenao langa yafonbona wa, ji yame haruwe uwa. Sia waha Itou no fai amina haiya nagai waha nere nebere.” ");
INSERT INTO eri_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Saini Yesus nomo disaipel 10 nere dada Jems no Jon ngare Yesus isoki tuware waha beele isidu, nere bode honggoro wane. ");
INSERT INTO eri_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ono wanenga Yesus no nere yaure nigainga mayanenga benou lenigai, “Tere isiya, fai nere fai-aita fereha gane nebere mora bagu dorofe yafade waha, nere nebere fai-aita bagu danga onou oofa nigi-nigide. Onodu fai-aita bagu nebere beele oojowei nomo danga tafa tafade. ");
INSERT INTO eri_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Onou wa, onowou waha tere gama langa adai inyou. Fai ete no tere gamatege langa anyakaro yafona wonga, no tebere haruwe fai yafonbona. ");
INSERT INTO eri_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Fai no tebere amugou fai yafona wonga, no fai oruwanga nebere haruwe fai ewe dorofe yafonbona. ");
INSERT INTO eri_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Taate bona, Fai Nomo Idau mai fere, fai-aita bagu no hoyo tuwou haruwe te fuwei nomo mei uwa. No nere hoyo nigei nomo mai, onodu no nogo nomo ago auma yafou nigidu fai-aita bagu baingaro ege ejiya nigai.” ");
INSERT INTO eri_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus no nomo disaipel bagu Jeriko taon langa mani heigane. Onodu Yesus no Jeriko awatudu manai. Ono gainga, nomo disaipel nere fai-aita toomaro bagu no ngate gaara golowaneha. Ono ganenga Timeus idau Bartimeus no jala hinemu langa yafai. Bartimeus no ago fosokowou, no fai-aita bagu moni dada bona malagau nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","No Yesus Nasaretha maina iwou beele isidu bona inyangaro yauredu benou lewai, “Yesus, ne Devit Idau, ne ji bonahe augami hinou.” ");
INSERT INTO eri_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ono wainga fai baingaro no honggoro tubode benou letuwane, “Ne hurate fosoko wau.” Ariya no gai onou hao korai bona yauredu benou lenga wai, “Devit Nomo Idau, ne ji bonahe augami hinou.” ");
INSERT INTO eri_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ono wainga Yesus no oto bona lewai, “Yaure tuwadenga mayona.” Ono wainga nere fai ago fosokowou yaure tudu benou letuwane, “Huwanyate edo danga wona. Ne jayau. No yaure hinina.” ");
INSERT INTO eri_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ono wanenga no nomo saket te kaitedu bona, fasayadu jaidu Yesus bagu goyai. ");
INSERT INTO eri_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ono wainga Yesus no isoki tuwai, “Ji ne adadu ono hinei nomo gau hinina?” Ono wainga fai ago fosokowou no Yesus benou letuwai, “Isisi higou fai, ji igei wonboni.” ");
INSERT INTO eri_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ono wainga Yesus no letuwai, “Ne dabu goyau, Ne name huwanyate ngalengawou waha wenga, ono hinanga hilou naha.” Ono wainga fasayadu onou, nomo ago hilou wainga igeiwai. Onodu no Yesus oojo tudu jala langa goyaiha. ");
INSERT INTO eri_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus no nomo disaipel bagu mani Jerusalem jugu tuwane, nere Oliv muju langa, matane Betfage Betani bagu langa heiganeha. Onodu Yesus no nomo disaipel nga nononga huuru niri bona ");
INSERT INTO eri_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","benou lenirai, “Tere matane ere elebe igei tuya woha langa goyaru. Tere goi bonadere fasadu onou donki gila ete maalu langa dowou oto gonga uraru ganga. Amina fai ete te jaula langa yafei uwa. Donki waha maalu futu fudu haudu tetemaru. ");
INSERT INTO eri_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ono gadere fai ete isoki tirona, ‘Tere taate boyare donki haudu goiyare iwonga,’ tere benou letuwaru, ‘Anyakaro no haruwe bagu, no ege fasadu huuru wonga mayonbona.’ ” ");
INSERT INTO eri_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ono wainga nere goidu, donki gila ete jala langa oto gainga urare. Fai nere donki waha mata ete hinemu langa arasai heigedu maigou langa do tuwane. Onodu nere maalu futu fuware. ");
INSERT INTO eri_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ono warenga fai ila jugu langa oto wane waha isoki nirane, “Tere donki adadu ono tuwaru ganga maalu futu fuyare?” ");
INSERT INTO eri_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ono warenga nere beele ege gidu benou lenigare, Yesus no lehiraha. Ono warenga nere donki edo tedu goyei nomo bode lenirane. ");
INSERT INTO eri_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ono warenga nere donki haudu bodere Yesus bagu mayareha. Onodu nere neire kolos ufaro uludu jaula langa jima warenga, Yesus no jaula langa yafaiha. ");
INSERT INTO eri_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Fai baingaro nebere kolos ufaroro uuludu bode jala langa jima waneha. Ono ganenga fai ila haga langa goidu nauge tuwa kakarudu bode tamai jala langa jima waneha. ");
INSERT INTO eri_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Fai-aita bagu ila amugane, ila huunta mayane, nere Yesus gamamu tudu mani bode, nere oruwanga hiri bode benou yauredu lewaneha, “Itou bonade edega wagu, fai Anyakaro unyi langa maina beha Itou no edo figini tuwonbona. ");
INSERT INTO eri_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","King elebe ere oofa higonbona beha Itou no edo figini tuwonbona, no king, ebere asage Devit nomo ganemuha maina. Itou unyi Gai Ouwe langa Isou wagu!” ");
INSERT INTO eri_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus no mani Jerusalem langa heigedu bona, tempel nomo orei huwanya langa goidu, dada oruwanga fele-fele nigi bona iladu golowaiha. Ariya hoonga amina minona ono gainga, no nomo disaipel 12 bagu ege gidu Betani goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Inyiba ete langa, nere Betani awadu mebode, Yesus no huweli tuwai. ");
INSERT INTO eri_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ono wainga no ago ayadu bona fik nauge ete no menanga baae langa gala fekuwai oto gainga urai. Onodu no fik nauge waha hilou ila nerigon bona hugu langa goyaiha. No goidu urai wa hilou uwau. No ewe galanga fekudu otowai, wa taate bona, fik nauge nomo hilou heigei nomo saini uwa. ");
INSERT INTO eri_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ono wainga Yesus no fik nauge benou letuwai, “Ne ege hilou ada heigaunga fai nyode. Gai uwanga uwa.” Ono wainga Yesus nomo disaipel nere beele waha isane. ");
INSERT INTO eri_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus no nomo disaipel bagu goi Jerusalem langa heigane. Onodu Yesus no tempel nomo orei huwanya langa goidu, fai moni kusewou haruwe te ganenga so nigou hugu warai. No fai moni hoole bode oto wane waha nebere tebol feudu ayaru nagi bona, fai neei huuru bode otowane waha nebere sia isoudu ayaru nagai. ");
INSERT INTO eri_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Onodu nere ege dada onouha waha elegedu tempel nomo orei huwanya langa adai golowogu bona karu nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Onodu no benou lenigai, “Itou nomo buk no beele benou bagu, ‘Ji yame Mata beha fai-aita bagu kantri oruwanga nere edo maidu bode, ji hauya hiyei nomo haumu inyonbona.’ Onou wa, tere ono tugeyenga no yebu fai nebere huwariwei nomo mata dorofe heigena.” ");
INSERT INTO eri_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pris aroro bagu nuuni beele isou fai bagu beele beha isidu bode Yesus adadu dukote wogunga umona waha bode jala kuruwou hugu warane. Nere onou ono wane, wa taate bona, nere umuge tuwane, fai-aita bagu oruwanga beele no lena waha bode horoto de-dede. ");
INSERT INTO eri_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Onodu esuwa langa, Yesus no nomo disaipel bagu Jerusalem awatudu goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Inyiba, ete langa eringe amina Yesus no nomo disaipel bagu golodu goibode, Yesus nomo disaipel nere fik nauge kakaregai oto gainga urane. No nomo gala bagu, jijiruku bagu oruwanga kakarege wane. ");
INSERT INTO eri_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Onodu Pita no Yesus beele lewai waha bona ninau isidu bona lewai, “Isisi higou fai, ne fik nauge woha urau, feyo ganga ne fik nauge woha no inyabawei nomo boni letunaha. Ononaha wa elebe no kakaregaha otona.” ");
INSERT INTO eri_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ono wainga Yesus no beele ege gidu benou lenigai, “Tere Itou bonade huwanyatege ngalengawou. ");
INSERT INTO eri_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Fai ete no edo muju beha letuwon bona, ‘Ne jaidu bonahe talagedu hiiri langa minau tuwonbona.’ Fai waha no huwanya nga bagu uwa, no dada tigini no lewaha onou heigei nomo huwanya ngalenga waha wonga, ji ngalenga letigini, dada waha tigini no lewaha onou heigonbona. ");
INSERT INTO eri_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tere hauya bonade dada ete tigini tei nomo huwanyatege onou ngalenga dewonga wa, tere dada waha taagu ganga, ariya ji letigini, dada waha tere leya onounga heigon bona. ");
INSERT INTO eri_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Saini tere jaidu otodu hauya bonade, fai ete no inyabamu tigai waha ninatege isei mata bonade wonga, tere nomo une uulu fuwagu. Ono wadenga tebere Ametege ha laluwa langa yafana waha no tebere une uulu tagonbona.” ");
INSERT INTO eri_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus no nomo disaipel bagu ege goi Jerusalem langa heigane. Onodu Yesus no tempel nomo orei huwanya gamu langa golo gainga, nere pris aroro bagu nuuni beele isou fai bagu nere mora bagu, nere Yesus bagu mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nere maidu benou isoki tuwane, “Ne unyite anyakaro bagu, danga bagu, alanga tedu boni dada benouha waha ononi? Faiwei no unyite anyakaro beha hinidu bona haruwe beha tei nomo bona lehinaiha?” ");
INSERT INTO eri_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ono wanenga Yesus lenigai, “Ji fere dada ete boni isoki tigon boni. Tere yame isokiwou beha ege gidu tigini lehibonade wonga, faiwei no ji haruwe beha tei nomo unyife anyakaro hiyai waha letigon boni. ");
INSERT INTO eri_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Saini Jon no fai yaage bisemu nigai waha, tere ha laluwa nomo dada iya yo, uwa, ewe fai neberenga dada iya? Tere ege gidu lehiyagu.” ");
INSERT INTO eri_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ono wainga nere nage-nage benou leguruwane, “Ere benou lewoya, ‘wa ha laluwa nomo dada,’ wa no lewon bona, ‘Ariya tere taate boya no boya huwanyatege ngalenga wegu uwa?’ ");
INSERT INTO eri_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Onou wa ere benou lewei mata woya, ‘Wa ewe fai neberenga dada’, beele waha fere edo uwa.” Onou leguruwane, wa taate bode, nere fai-aita bagu umuge nigane. Nere fai-aita bagu oruwanga iside Jon no profet tigini. ");
INSERT INTO eri_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Onou waha bode nere beele gidu Yesus benou letuwane, “Ere alai uwa.” Ono wanenga Yesus no benou lenigai, “Ji fere faiwei no haruwe beha tei nomo unyife anyakaro hiyai waha ada letigon boni.” ");
INSERT INTO eri_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus no Juda nebere fai aroro muuji beele ila benou lenigai, “Fai ete no wain haga ete tedu, orei atai. Onodu wain fatu ileidu bujajimu nigigou u-u ete tang dorofe konowai, onodu fai walanga jiri bode haga oofawei nomo mata ete tau nagai. Onodu no haga waha langa moni kusewei nomo fai ila owonege langa tafai. Onodu no nogo matane ete langa fagawai. ");
INSERT INTO eri_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ariya wain hilou muumu elegei nomo saini heigainga, no nomo haruwe magana ete huuru tuwainga fai wain haga langa haruwe tede waha bagu minai. No haga waha nomo wain hilou ila elege fuwei nomo gaudu bona huuru tuwai. ");
INSERT INTO eri_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","No mini heigainga wain haga langa haruwe tede fai nere jaidu bode haruwe magana waha waridu inyabamu tudu bode, so tuwanenga ewenga gidu goyai. ");
INSERT INTO eri_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ono wanenga wain haga morou no waha isidu bona ege haruwe magana ete huuru tuwainga goyai. Nere no waridu inyabamu tudu bode mora kono fuwane. ");
INSERT INTO eri_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ono wanenga no ege haruwe magana ete huuru tuwai. Nere fai waha dukote wanenga umai. Iinga huunta la no haruwe magana baingaro huuru nigainga nere bagu goyaneha. Ono wanenga ila narige bode ila dunege kote wanenga umeru waneha. ");
INSERT INTO eri_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ariya fai etenga nogonga yafai. Fai waha no nomo idau, no gaude tuna waha. Gai huunta la no nomo idau waha huuru tuwainga fai haga haruwe tede langa goyaiha. Umamu no isai wa, ‘Nere ji yame magana nomo beele isodbode iwai.’ ");
INSERT INTO eri_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ariya fai no nomo wain haga langa haruwe tede waha nere nage-nage beele benou ngado wane, ‘Fai beha no umamu nomo dada oruwanga elegon bona. Ariya ere dukote wedenga umonga, ere hage haga beha umamu heigei nomo.’ ");
INSERT INTO eri_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Onodu nere haga morou waha nomo idau haudu bode dukote wanenga umai. Onodu gogala tedu togoi haga dui langa kaitaneha. ");
INSERT INTO eri_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ariya wain haga morou no nere adadu ono nigonbona? Isagu. No maidu bona fai wain haga langa haruwe tede waha dunege kotewon bona. Onodu wain haga waha fai fereha ila owonege langa tafonbona. ");
INSERT INTO eri_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Tere beele matau Itou nomo buk langa yeregou inyina waha lelegegu uwa rute? Beele waha benou, ‘Megebu waha kamda nere inyaba iwou isane onodu nere tedu kaitane, elebe no mata nomo orei dangamuwou megebu amugou heigaha. ");
INSERT INTO eri_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anyakaro nogowe dada waha onowanga heigaha. Ono wanga ere ureyaha wa no gai hilobainga.’” ");
INSERT INTO eri_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Fai aroro nere iside, Yesus no beele nere langanga waronbona waha bona muuji beele beha lewai. Nere Yesus yaasu tuwei nomo gaude nigai, ariya nere fai-aita bagu bode umugane. Waha bode nere awa tudu goyane. ");
INSERT INTO eri_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fai aroro nere Farisi ila bagu Herot nomo fai ila bagu huuru niganenga Yesus bagu goyane. Nere Yesus yaawa tu wogunga, no beele ila tigini uwa waha lewonga, nere nomo beele lewou waha langa otodu kot langa tafa tuwode ono wane. ");
INSERT INTO eri_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nere Yesus bagu maidu benou letuwane, “Isisi higou fai, ere alai, ne beele ngalenga legou fai. Onodu ne fai ete boni ada umuge umugeni. Ne fai oruwanga beele hogo etenga lenigi-nigini, edo nere unyinege bagu yo, nere unyinege uwau. Ne beele ngalenga wahanga la fai-aita bagu Itou nomo fanyimu boni isisi nigi nigini. Ariya ne adadu isini? Ere Sisa takis edo tuwei nomo yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ariya Yesus no nebere beele yaawawou waha amina isidu, benou lenigai, “Tere taate boya wala-wala hiya? Tere moni ete tamayadenga uroni.” ");
INSERT INTO eri_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ono wainga nere moni ete tamaidu abitimu tuwane. Ono wanenga no isoki nigai, “Moni beha faiwei anu bagu nomo unyi bagu inyina?” Ono wainga nere letuwane, “Sisa nomo.” ");
INSERT INTO eri_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ono wanenga Yesus no benou lenigai, “Tere Sisa nomo dada waha Sisa tuwagu. Ariya dada Itou nomo waha tere Itou tuwagu.” Ono wainga nere nomo beele isidu horoto waneha. ");
INSERT INTO eri_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ariya Sadyusi nere Yesus bagu mayane. Nere fai waha lelede, fai umeru wane waha ege ada jayode bode. Ariya nere Yesus benou isoki tuwane, ");
INSERT INTO eri_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Isisi higou fai, Moses no beele ete benou yerege hagai. Fai ete no aita tedu oya ngare magana ete biseru uwau langa fai waha no umai, ariya oya no gai yafana, bemu no bemu umai waha oyomu tedu nomo magana heigemu fuwonga bemu nomo ganemuha fai ada usuwona. ");
INSERT INTO eri_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ariya saini ete langa fai bemubemu waha 7 nere yafane. Amugou waha no aita tai, onodu iinga huunta langa no umai, nere magana ete te biseru uwa. ");
INSERT INTO eri_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Waha bona bemu no oojo tuwou waha no bemu oyomu tai. Onodu no fere magana uwau langa umai. Ono wainga bemu eei waha fere no onounga onowai. ");
INSERT INTO eri_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nere fai bemubemu 7 waha oruwanga aita wahanga taneha, onodu nere magana ete te bisei uwa langa umeru wane. Ariya gai huunta langa, aita waha fere no umai. ");
INSERT INTO eri_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Iinga huunta langa, fai umeru wane waha ege gidu jayou langa, aita waha no fai adeha nomo aita tigini yafonbona? Ne isini, fai 7 nere te tuwanenga no nebere aita yafaiha.” ");
INSERT INTO eri_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ono wanenga Yesus no benou lenigai, “Tere hilou beele Itou nomo buk langa inyina waha ada isiya. Onodu tere Itou nomo danga fere ada isiya. Waha boya tere beele lenyabulu ya. ");
INSERT INTO eri_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Saini fai nere umeru wane waha, nere matmat awadu ege gidu jayode wa, nere fai-aita bagu waha ada te guru wode. Uwa. Nere ha laluwa nomo ensel dorofe yafodbode. ");
INSERT INTO eri_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Onou wa fai umane waha ege gidu jayei nomo beele waha, Moses nomo buk langa nauge menakele eeya uwena waha nomo aasa tere lelegegu uwa rute? Aasa waha langa Itou no Moses benou letuwai, ‘Ji Abraham nomo Itou, Ji Aisak nomo Itou, Ji Jekop nomo Itou.’ ");
INSERT INTO eri_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Itou no fai umou nebere Itou uwa. Itou no fai agenege auma yafade waha nebere Itou. Waha bona tebere beele gai nyabuluwou!” ");
INSERT INTO eri_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nuuni beele isou fai ete maidu bona, Sadyusi fai Yesus bagu beele langa wara ganenga isai. Onodu no isai wa Yesus no Sadyusi fai beele gai hilobainga gidu lenigai. Waha bona no Yesus isoki tuwai, “Nuuni beele adoha waha no nuuni beele oruwa feiya nigidu no gai amugou?” ");
INSERT INTO eri_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ono wainga Yesus no beele benou gidu letuwai, “Nuuni beele amugou waha nu beha, ‘Tere Israel, isi dewagu. Anyakaro no nogonga ebere Itou. ");
INSERT INTO eri_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tere Itou gaude tuwagu, no ebere Anyakaro, tebere huwanyatege langa, tebere anutege langa, tebere ninatege langa, tebere dangatege langa, gaude tuwagu.’ ");
INSERT INTO eri_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ariya nuuni beele ete waha oojo tuwou nu beha, ‘Ne nage boni gaude hinina dorofenga ilibane gane bonahe fere onou gaude hinou.’ Nuuni beele ete te no anyakaro onodu nuuni beele nga beha feiya nirei uwa.” ");
INSERT INTO eri_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ono wainga nuuni beele isou fai waha no Yesus benou letuwai, “Isisiwou fai, ne name beele hilobainga. Ngalenga. Itou no nogonga Anyakaro, Itou ete te yafei uwa. ");
INSERT INTO eri_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ere ebere huwanyage oruwa, isou oruwa, dangage oruwa no gaude tuwoboya. Onoboya ere hage boya gaude higina onounga fai ila fere onounga gaude nigoboya. Ere nuuni beele nga beha oojowei mata wedenga wa, onowou beha no eeya muru warou oruwa eeya langa biti geyenga oruwanga usigena waha, onodu Itou eeya muru warou hogo fere-fere tuya waha oruwa feiya nigou.” ");
INSERT INTO eri_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus no fai waha beele ege onou gidu lewainga isai wa, no fai isou hilou bagu dorofe, onodu Yesus no fai waha benou letuwai, “Ne Itou nomo huuna langa yafou wa ne baae tudu yafei uwa.” Ono wainga fai oruwanga umugedu bode ege Yesus dada ete bode isoki tuwei nomo awane. ");
INSERT INTO eri_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus no tempel nomo orei huwanya langa yafa bona fai-aita bagu beele benou lenigai, “Adadu bona nuuni beele isou fai nere benou lelede, Itou no nomo fai-aita bagu gidu hanigei nomo fai hangada tuwai wa no Devit idau? ");
INSERT INTO eri_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hauri Guuni nowe Devit ninau tuwainga benou lewai, ‘Anyakaro no yame Anyakaro benou letuwai, “Ne ji owofe hilou langa yafa gahenga goi ne name honggoro fai name huuna langa logosi nigehenga yafodbode.” ’ ");
INSERT INTO eri_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit no nogowe fai waha no nomo Anyakaro iwai. Ariya adadu bona fai waha no Devit idau?” Fai-aita bagu baingaro yafabode, nere Yesus nomo beele isei nomo edega wane. ");
INSERT INTO eri_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Onodu Yesus no fai-aita bagu isisiwou nigi bona benou lenigai, “Tere nuuni beele isou fai bonade ure dewagu. Nere kolos ufaroro tanidu kotowou haumu langa, fai-aita bagu agenege langa golo gogunga, fai-aita bagu kaiye nigei nomo gaude nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nere bori mata huwanya langa goidu haumu hilobainga, amugou waha tedu yafei nomo gaude nigi-nigina, onodu da nyou anyakaro langa nere sia amugou waha tei nomo gaude nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nere aita oyo yaawa nigi bode nebere mata yebu elege-elegede. Ono bode nere yaawawou hauya ufaro hauya-hauyade. Kot saini langa nere ou anyakaro todbode.” ");
INSERT INTO eri_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus no tempel nomo bogisi moni hinomu langa yafai. Ono bona fai-aita bagu maidu eeya muru warou bogisi langa tani ganenga nerigai. Fai moninege bagu waha baingaro nere moni baingaro tafane. ");
INSERT INTO eri_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ono ganenga aita oyo ete no dadamu uwau, au umaiha, no maidu bona moni mene-mene nga nononga 1 toea onou, ayaru wainga moni bogisi langa minai. ");
INSERT INTO eri_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ono wainga Yesus no nomo disaipel yaure nigainga mayanenga lenigai, “Ji tere ngalenga letigini, aita oyo dadamu uwau moni tafaha beha, no fai-aita bagu oruwanga moni tafane beha feiya nigou moni anyakaro tempel nomo moni bogisi langa tafaha. ");
INSERT INTO eri_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Fai-aita bagu beha oruwanga nere moni baingaro oto ganga, ulate wahanga moni bogisi langa ayawaneha. Ariya aita oyo beha no gai tutude tuwaha, no moni oruwanga aya boro waha. No da ejiyawei nomo moni ete te inyei uwa.” ");
INSERT INTO eri_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus no tempel nomo orei awadu golodu mini gainga, nomo disaipel ete benou letuwai, “Isisi higou fai, megebu aroro hilou-hilou bagu, mata hilou-hilou woha nerigau!” ");
INSERT INTO eri_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ono wainga Yesus no benou gidu letuwai, “Ne mata aroro woha nerigeni yo? Nere megebu woha awogunga etenga te jaula faama ada inyonbona. Uwa. Nere oruwanga koresedu ayaru wogunga orososo wodbode.” ");
INSERT INTO eri_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus no Oliv muju langa yafa bona tempel ulate langa oto gainga urai. Pita wainga Jems wainga Jon wainga Andru, nere nagenga Yesus bagu manane. Onodu benou isoki tuwane, ");
INSERT INTO eri_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ne lehigau, “taate saini langa dada beha waha heigon bona? Ere taate naani uredu ere isoboya, dada waha amina heigona juguna iwoboya?” ");
INSERT INTO eri_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ono wanenga Yesus no benou lenigai, “Tere ure dewagu. Gamaji fai ete yaawa tigoga. ");
INSERT INTO eri_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nere fai baingaro maidu bode ji unyife tebode benou lewodbode, ‘Ji yage ji fai waha.’ Onodu fai-aita bagu baingaro yaawa nigodbode. ");
INSERT INTO eri_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Iinga gonga saini oota bolou anyakaro isi bonade, oota anyakaro haumu ila langa heigena iwou beele ananu isi bonade adai horoto wagu. Dada waha no amugedu heigon bona, ariya fati usuwou saini iinga inyina. ");
INSERT INTO eri_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nere fai fereha ila jaidu fai fereha ila bagu oota jaimu wodbode. Ono gogunga King ila nebere fai nere King fereha nebere fai bagu oota jaimu wodbode. Ono gogunga ha ila langa oula mimi megonga, maau saini anyakaro heigon bona. Dada waha aita magana bisonbona, amugedu jimiri tena dorofe heigon bona. ");
INSERT INTO eri_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ariya saini waha langa tere tage ure dewagu. Nere nebere kaunsel langa, tere kot langa tafa tigodbode. Ono bode tere bori mata huwanya langa tarigod bode. Nere ji unyife ileiwei nomo ninanege, gabman bagu King bagu hogonege langa tafa tigodbode. Ono wogunga tere dabu hilou beele malalamudu lenigagu. ");
INSERT INTO eri_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nere fai oruwanga fai no hilou beele malalamudu lena waha amugedu isogunga. ");
INSERT INTO eri_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Saini nere tatari tigidu hatigedu kot langa manogunga tere umugedu benou adai isagu, ‘Ere taate beele lewoboya?’ Uwa. Saini waha langa tigini, beele oruwanga Itou nogo letigona waha, tere malalamudu lewagu. Wa taate bona, tere tagewe beele ada malalamudu lewagu ganga. Uwa. Hauri Guuni nowe malalamudu lewon bona. ");
INSERT INTO eri_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Fai no bemu gane kot langa tafa nigidu, nere dunege kotewei nomo bona fai lenigon bona. Nere amenege gane fere idanege gane onounga ono nigodbode. Idanege gane fere nere amenege anyanege gane bagu honggoro guru bode dunege kotewei nomo fai lenigod bode. ");
INSERT INTO eri_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Fai oruwanga tere bode huwanyanege inyaba dewonbona, wa taate bona, ji yame unyife tere langa inyina. Ariya fai-aita bagu danga tafadu yafa gogunga goi fati usuwou langa heigona wa, Itou no ege gidu hanigon bona.” ");
INSERT INTO eri_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus no ege benou lewai, “Dada gai inyaba haumu guuni langa oto gonga uragu ganga.” Fai beele beha lelegena waha no isi dewona. “Saini beha langa fai-aita bagu Judia distrik langa yafade waha nere haradu muju langa manogu. ");
INSERT INTO eri_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Fai ete no mata ouwe langa yafa bona wonga, saini no heige bona nomo dada elegei nomo jauli huwanya adai goyou. ");
INSERT INTO eri_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Fai no haga langa golona waha nomo kolos ufaro tei nomo bona ege gidu mata langa adai goyou. ");
INSERT INTO eri_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Saini beha langa nere aita genege bagu waha, aita magana eeme aare nigide waha agenege gami bagu. ");
INSERT INTO eri_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tere uliya saini langa dada waha tere langa adai heigou bonade hauya wagu. ");
INSERT INTO eri_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Saini waha langa ou gai anyakaro heigon bona. Saini hugu warou langa, Itou no dada oruwanga tafai langa mai elebe, ou onouha ete heigei uwa. Onodu iinga fere ou onouha ete ada heigon bona. ");
INSERT INTO eri_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Onodu Anyakaro no ou waha nomo saini ada tutumu wonga wa, fai-aita bagu oruwanga yae wodbode. Onou wa Anyakaro no fai-aita bagu no nomo bona amina hangada nigai. Waha bona no saini tutumu wonbona. ");
INSERT INTO eri_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Saini beha langa fai ete no benou letigei mata wonga, ‘Uragu, fai Itou nomo fai-aita bagu gidu elegei nomo hangada tuwai waha benu yafana,’ o ‘Uragu, no wolanga yafana,’ tere nebere beele bonade huwanyatege adai ngalengawou. ");
INSERT INTO eri_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Fai ila maidu bode benou yaawa tigodbode, ‘Ji fai beha Itou nomo fai-aita bagu gidu elegei nomo hangada hiyai’, o ‘Ji profet ete,’ onodu dodoka ila tafa bode dada hogo fere-fere heigemu wodbode. Ngalenga tigini, Nere edo wonga, fai-aita bagu Itou no nomo bona hangada nigai waha hilalamu nigodbode. ");
INSERT INTO eri_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Waha bona tere ure dewagu. Dada oruwanga heigon bona wa ji amina letiginaha.” ");
INSERT INTO eri_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesus no ege benou lewai, “Ou aroro waha nebere saini usuwonga, saini waha langa hoonga ago agugu wonga ole ada lala wonbona. ");
INSERT INTO eri_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ono gonga baatu ha ladena awa tudu orososo wodbode. Ha ladena nomo dada danga bagu-bagu oruwanga terere wonbona. ");
INSERT INTO eri_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Saini waha langa, Fai Nomo Idau no danga anyakaro bagu lala anyakaro bagu agau langa yafadu me gonga fai-aita bagu urodbode. ");
INSERT INTO eri_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Onodu saini waha langa, no nomo ensel huuru nigonga goidu bode, fai-aita bagu nogo nomo bona hangada nigai waha komomu nigodbode. No ha-ha oruwa langa elege bona goi oula taene bagu usuwou langa haawe wonbona.” ");
INSERT INTO eri_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus no ege benou lewai, “Tere Fik nauge langa isou edo langa taagu ganga. Saini fik nauge no tuwa langa gala rugugonga, wa tere isagu, elebe hoonga hilobainga mayona onona iwou isagu ganga. ");
INSERT INTO eri_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Onou dorofenga, dada waha heigonga wa tere edo langa isagu ganga, Fai Nomo Idau mayei nomo saini amina mai jugu waha, arasai langa inyina. ");
INSERT INTO eri_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ji ngalenga letigini. Elebe saini beha nomo fai-aita bagu yafade waha, umeru wegu uwa langa dada waha oruwanga heigod bode. ");
INSERT INTO eri_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Taena oula bagu nere usu wodbodere, ariya ji yame hilou beele ada usu wonbona.” ");
INSERT INTO eri_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus no ege benou lewai, “Onou wa, taate fati langa taate awa langa dada waha heigonbona waha, fai ete te no ada isina. Ha laluwa nomo ensel ada iside, Idau fere ada isina. Umamu nogonga isina. ");
INSERT INTO eri_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Tere ure dewagu. Tere oofa bonade yafagu, tere ada isi gadenga taate saini langa dada waha heigon bona. ");
INSERT INTO eri_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","No fai ete nomo mata awadu bona goidu ha fere langa golona dorofe. No nomo haruwe magana nomo dada oofa fuwei nomo lenigidu bona, no haruwe fere-fere wese nagai. Onodu no fai mata jauli arasai oofana waha no jauli arasai oofa dewei nomo bona letuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Waha bona tere oofa dewagu. Mata morou taate saini langa mayona waha tere alai uwa. No esuwa mayona yo, ooru jege mayona yo, teewe wari gonga mayona yo, uwa no eringe mayona yo, waha tere alai uwa. ");
INSERT INTO eri_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gamaji no fasayadu maidu bona tere agore jiri gadenga terigoga. ");
INSERT INTO eri_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Beele ji letigini beha, ji terenga letigei uwa, ji fai-aita bagu oruwanga lenigini. Tere oofade bonade yafagu.” ");
INSERT INTO eri_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Itou No Israel Awa Nigainga Hilou Yafane Waha Ninanege Isei Nomo Fati Anyakaro bagu, Beret Yis Uwau Nomo Fati Anyakaro bagu, heigon bona waha inyiba nga inyai. Ono gainga nere pris aroro bagu, nuuni beele isou fai bagu lewane, “Ere adadu onodu boya, ere edo langa Yesus yaawa tudu yaasudu dukote wedenga umona?” ");
INSERT INTO eri_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Onodu nere benou lewane, “Ere dada waha bori nomo fati anyakaro langa ada onowoya. Gamaji fai-aita bagu uredu honggoro dubode oota jaimu woguga.” ");
INSERT INTO eri_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus no Betani matane Saimon nomo mata langa yafai, Saimon no amina lepra taura bagu. Yesus no tebol langa yafa gainga, aita ete mayai. Aita waha no megebu kuluma hilobainga ete, sanda gai hilobainga nomo ejiyawou moni gai ouwela. No megebu kuluma waha boou langa koudu bona, sanda Yesus mora langa uwaiha. ");
INSERT INTO eri_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ono wainga fai ila yafane waha uredu bode, huwanyanege inyaba waiha. Onodu nere nage-nage benou leguruwane, “Aita woha taate bona sanda ewe heile waha? ");
INSERT INTO eri_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ere sanda waha fai awa nagedenga ejiyawei mata wage wa, ere edo 300 moni silwa onou tedu boya, fai dadanege uwau waha nigedege.” Onodu nere aita waha honggoro tuwane. ");
INSERT INTO eri_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ono wanenga Yesus no benou lenigai, “Tere aita beha awa tuwagu. Tere taate boya ou tuya? No fanyimu hilobainga ono hiyaha. ");
INSERT INTO eri_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nere fai dadanege uwau waha gai-gai tere bagu yafodbode. Taate saini tere hoyo nigei nomo gaude tigei mata wonga wa, tere edo hoyo nigagu. Ariya ji tere bagu gai-gai ada yafon boni. ");
INSERT INTO eri_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dada aita beha onowei nomo edo waha, no amina ono waha. No ji geefe gala langa sanda wari hayaha waha, no ji geefe gala matmat bona haiya hayaha. ");
INSERT INTO eri_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ji tere ngalenga letigini, ha-ha oruwanga la nere hilou beele malalamudu lebode golode waha, aita beha no dada onowai fere lewodbode, ono bode nere no bode ninanege isodbode.” ");
INSERT INTO eri_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Saini waha langa Yesus nomo disaipel 12 waha gama langa ete Judas Iskariot, no pris aroro hinenege goyaiha. No Yesus nere owonege langa tafa tuwonbona waha bona goyaiha. ");
INSERT INTO eri_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ono wainga nere waha isidu bode edega wane. Onodu nere Judas moni ila tuwei nomo bode beele baara tawane. Ono wanenga no Yesus nere owonege langa tafa tuwonbona waha jala kuruwou hugu warai. ");
INSERT INTO eri_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Beret Yis Uwau Nomo Fati Anyakaro waha nomo fati amugou heigai. Fati waha langa nere sipsip magana dukotedu, fati Anyakaro waha langa nyibode Itou No Israel Awa Nigainga, Hilou Yafane Waha Ninanege Isi-iside. Waha bona nere Yesus nomo disaipel Yesus benou letuwane, “Ne ere haumu alanga goidu dada haiya wedenga ne nyou anyakaro waha heigemuwei nomo gau hinina?” ");
INSERT INTO eri_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ono wanenga Yesus no disaipel nga nononga huuru nirainga goi garenga lenirai, “Tere taon huwanya langa goyaru. Onodu fai ete no tumutao anyakaro yaage bagu auledu mai jala la toroba tironga, tere fai waha oojo tuwaru. ");
INSERT INTO eri_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Saini no mata ete huwanya langa goyonga ure bonadere wonga, tere mata waha morou benou letuwaru, ‘Isisi higou fai lewaha, “Ji yame disaipel bagu Itou No Israel Awa Nigainga Hilou Yafane Waha, ninage isou da nyei nomo yame jauli alanga inyina?” ’ ");
INSERT INTO eri_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ono waderenga no jauli anyakaro ete ouwe langa inyina waha abitimu tirona bona, walanga tebol sia bagu haiyawou otode. Tere ebere da nyou jauli waha langa haiya waru.” ");
INSERT INTO eri_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ono wainga nomo disaipel nere goyare. Nere goi taon langa heigedu dada oruwanga Yesus no lenirai onounga oto gainga urare. Onodu nere da haiya wareha. ");
INSERT INTO eri_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Esuwa langa Yesus no nomo disaipel 12 bagu mayane. ");
INSERT INTO eri_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nere maidu, tebol langa yafadu da nyibode, Yesus no benou lenigai, “Ji tere ngalenga letigini, fai ete tere gama langa no ji honggoro fai owonege langa tafa hiyonbona. Fai waha no elebe ji ngare gaara da nyiyare.” ");
INSERT INTO eri_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Disaipel nere beele waha isidu bode huwanyanege ouwai, ono wainga nere etenga-etenga Yesus benou isoki tuwou hugu warane. “Ne ji boni leni yo?” ");
INSERT INTO eri_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ono wanenga Yesus no lenigai, “Fai waha no tere 12 waha gamatege langa ete. Fai waha no beret tedu ji ngare haaya huwanya langa tafaha. ");
INSERT INTO eri_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngalenga, Fai Nomo Idau No umonbona, Itou nomo beele lewai onou, no tigini umonbona. Ariya fai no, Fai Nomo Idau honggoro fai owonege langa tafa tuwaha waha no augami bagu. Fai waha no anya bisi tuwei uwa wage wa hilobainga.” ");
INSERT INTO eri_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nere yafadu da nyibode, Yesus no beret ete tedu Itou hilobainga tudu bona, lalatidu nomo disaipel nigai. Onodu benou lenigai, “Tere elegedu nyagu. Beha ji yame geefe gala.” ");
INSERT INTO eri_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Onodu no kap wain bagu ete tedu bona Itou hilobainga tudu, nigainga nere oruwanga waha langa nyane. ");
INSERT INTO eri_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Onodu Yesus no benou lenigai, “Beha ji yame ganefe beele agili mala karuwou. Ji fai-aita bagu baingaro hoyo nigei nomo feuni. ");
INSERT INTO eri_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ji tere ngalenga letigini, ji wain ege ada nyon boni, goi saini Itou nomo huuna langa yafou waha huwanya langa, ji wain eege waha nyon boni.” ");
INSERT INTO eri_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Onodu nere moone ete tebode, taon awa tudu Oliv muju langa mananeha. ");
INSERT INTO eri_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus no nomo disaipel benou lenigai, “Tere oruwanga tebere huwanyatege ngalengawou mebodu wonbona, taate bona, Itou nomo buk langa beele onou bagu, ‘Ji oofa nigou fai dukote wehenga, sipsip firigagadu hara wodbode.’ ");
INSERT INTO eri_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ariya ji ege gidu jaidu boni, tere amuge tigidu Galili langa goyon boni.” ");
INSERT INTO eri_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ono wainga Pita no letuwai, “Nere fai ila oruwanga huwanyanege ngalengawou edo mebodu wonga awa hinodbode, ji ne ada awa hinon boni.” ");
INSERT INTO eri_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ono wainga Yesus no benou letuwai, “Ji ngalenga lehinini, elebe ooru beha langa saini teewe wari ngawei uwa inyi gonga, ji ne boni ada isini iwou le eei wau ganga.” ");
INSERT INTO eri_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ariya Pita no beele danga bagu letuwai, “Edo ji ne ngare umoyare yo, ji ne boni ada isini iwou ada lewon boni. Gai uwanga uwa.” Ono wainga nomo disaipel oruwanga nere fere beele Pita no Yesus letuwai onounga lewaneha. ");
INSERT INTO eri_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesus no nomo disaipel bagu mani haumu ete Getsemani ide walanga heigane. Onodu Yesus no nomo disaipel benou lenigai, “Tere beenga yafagade, ji hauya won boni.” ");
INSERT INTO eri_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Onodu no Pita wainga Jems wainga Jon, nere hani gainga no ngate gaara manane. Walanga Yesus no aau togo fubona huwanya langa gai inyaba isaiha. ");
INSERT INTO eri_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Onodu lenigai, “Ji huwanyafe danga bagu ou bona, umou tamayaha jugu hina. Tere belanga yafa bonade oofa dewagu.” ");
INSERT INTO eri_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Onodu no menanga onou manidu bona, oula langa mebodudu hauyawai. Jala bagu wonga, saini inyaba waha feiya tuwei nomo bona gauwai. ");
INSERT INTO eri_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","No benou hauyawai, “Aba, Jijei, ne dada oruwanga onowei nomo edo. Ne kap beha ariri hayei nomo gau hina. Onou wa, ne ji yame gauwou adai oojowau. Ne name gau wounga oojowau.” ");
INSERT INTO eri_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Onodu Yesus no nomo disaipel eei bagu goidu, nere agore jiri ganenga nerigai. Onodu Pita benou isoki tuwai, “Saimon, ne agore inyini yo? Ne awa etenga oofadu yafei nomo edo uwa yo? ");
INSERT INTO eri_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tere hauya bonade oofadu yafagu. Gamaji wala-walawou tere langa heigonga orososo wagu ganga. Ngalenga, huwanyatege no dada onowei nomo gau tuna, ariya getege gala no danga uwau.” ");
INSERT INTO eri_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Onodu Yesus no ege gidu goidu bona, amugedu hauyawai onounga ege hauyawai. ");
INSERT INTO eri_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","No ege gidu nomo disaipel bagu goidu, nere agore jiri ganenga nerigaiha. Nere agore gai teme ilei nigai. Onodu saini no aimu nigainga, nere Yesus beele adadu letuwode waha fo nigei uwa. ");
INSERT INTO eri_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iinga Yesus no ege mai eei waiha, onodu nomo disaipel benou isoki nigai, “Tere gai agore jiri boya houwe tafaya yo? Boroyaha. Saini amina heigaha, elebe nere Fai Nomo Idau une fai owonege langa tafatude. ");
INSERT INTO eri_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tere jayadenga minoya. Uragu, fai no ji une fai owonege langa tafa hiyona waha, no amina mai heigaha.” ");
INSERT INTO eri_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus no beele lebona oto gainga, Yesus nomo disaipel 12 waha nere gamanegeha ete no Judas Iskariot, no fasayadu onou mayai. Fai toomaro nere oota kesebu bagu dumuga bagu yaasu dubode no ngate mayane. Nere pris aroro bagu mora aroro bagu nuuni beele isou fai bagu huuru niganenga mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Fai Yesus owonege langa tafonbona waha, no naani ete benou nigaiha. “Ji fai ete uumba tuwon boni, fai waha no Yesus. Tere no yaasu tudu bonade, oofade tubonade haudu goyagu.” ");
INSERT INTO eri_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas no mai heigedu bona, fasayadu Yesus bagu goidu benou letuwai, “Isisi higou fai.” Ono bona uumba tuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ono wainga Yesus nomo honggoro fai nere owonege ayadu bode Yesus yaasu tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ono wanenga Yesus nomo disaipel oto wane waha nebere gamanegeha ete, no nomo oota kesebu uludu tedu bona, pris mora bagu nomo haruwe magana waridu ago kuli saludu kaitainga meboduwai. ");
INSERT INTO eri_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ono wainga Yesus no benou lenigai, “Tere oota kesebu bagu dumuga dada bagu yaasudu ji haifagu ganga maiyaha waha, tere oota fai yo, yebu fai ete dage tuwagu ganga dorofe onoya yo? ");
INSERT INTO eri_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ji fati oruwa tere bagu tempel nomo orei huwanya langa yafa boni, fai-aita bagu isisiwou nigene. Saini waha langa tere taate boya ji yaasu hiyegu uwa? Ariya wa buyona. Hilou beele Itou nomo buk langa inyina waha no tigini heigon bona.” ");
INSERT INTO eri_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ono gainga Yesus nomo disaipel oruwanga Yesus awa tudu bode heige hara waneha. ");
INSERT INTO eri_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Magana gila ete no ogola kaamba tagudu bona Yesus oojo tudu mayaiha. Ono wainga nere no tayane, ");
INSERT INTO eri_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ono wane wa, no ogola kaamba waanga faradu aya nagi bona bilani heige faga waiha. ");
INSERT INTO eri_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pris aroro bagu, nere mora bagu, nuuni beele isou fai bagu, oruwanga pris nebere mora bagu nomo mata langa yafa ganenga, fai nere Yesus tayane waha haudu bode goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ono ganenga Pita no Yesus oojo tudu bona goyai, ariya no menanga onou baae langa otowaiha. No pris anyakaro nomo mata orei huwanya langa goyai. Onodu, no nere polis ngate yafa bona, eeya langa gogala ngasumu bona yafaiha. ");
INSERT INTO eri_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ono gainga pris aroro bagu kaunsel bagu fai ila yaure niganenga maidu bode, Yesus nomo onowou waha malalamudu lewaneha. Nere nomo nyabuluwou ete torobadu bode, edo langa dukote wogunga umei nomo bode ono waneha, Ariya nere nyabuluwou ete te toroba wegu uwa. ");
INSERT INTO eri_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Fai baingaro Yesus gogala langa beele yaawawou lenga waneha, ono wane wa, nere nebere beele gara-gara uwa. ");
INSERT INTO eri_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ono ganenga fai ila oto bode Yesus gogala langa beele yaawawou benou lewane, ");
INSERT INTO eri_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ere no benou lewainga iseye, ‘Ji yagewe tempel nere fai owonege langa tawane waha fasaka wonboni. Onodu iinga fati eei usuwou langa ji ete tawon boni, ariya ji owofe langa ada tawon boni.’ ” ");
INSERT INTO eri_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Beele beha lewane fere goidu hilala nigai, nomo beele bagu gara-gara uwa. ");
INSERT INTO eri_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ono wainga pris mora bagu no kaunsel agenege langa oto bona Yesus benou isoki tuwai, “Ne beele ete gidu lenigei nomo awani yo? Adadu bode beele beha ne gete gala langa wari ganenga maina?” ");
INSERT INTO eri_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ariya Yesus no hurau fosokodu, beele ete te gidu letuwei uwa. Ono wainga pris mora bagu no ege isoki tuwai, “Ne fai beha Itou no nomo fai-aita bagu gidu hanigei nomo hangada hinai yo? Ne Itou Gai Ouwe Langa Idau yo uwa?” ");
INSERT INTO eri_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ono wainga Yesus no letuwai, “Wa ji wenga. Tere Fai Nomo Idau no Itou danga anyakaro bagu nomo owo hilou langa yafa gonga uragu ganga. Onodu no ha laluwa nomo agau langa yafadu monbona.” ");
INSERT INTO eri_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ono wainga pris mora bagu beele waha isidu horotodu bona nogo nomo kolos koraidu kaite bona benou lewai, “Ere ege fai beha nomo onowou malalamu fuwei nomo fai ila ada yaure nigoboya. ");
INSERT INTO eri_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tere no Itou memesi beele letuwanga isiyaha. Tere adadu ono tuwei nomo isiya?” Ono wainga nere oruwanga lewane, “No nyabuluwou bagu, waha bona no umonbona.” ");
INSERT INTO eri_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Onodu fai ila no bisinga tuwou hugu waraneha. No ogola langa ago dagedu wari bode, benou letuwane, “Elebe ne profet beele lewau.” Ono ganenga polis haudu bode ulagu bare waneha. ");
INSERT INTO eri_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita no esene langa, mata nomo orei huwanya langa yafai. Ono gainga pris mora bagu nomo haruwe aita ete mayai, ");
INSERT INTO eri_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","no maidu Pita eeya langa gogala ngasumu bona yafa gainga urai. Onodu Pita tigini feele tubona benou letuwai, “Ne fere Yesus Nasaretha ngare yafene.” ");
INSERT INTO eri_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ono wainga Pita no uwa ibona benou lewai, “Ne beele leni beha ji tigini alai uwa.” Onodu no malala heigedu mata nomo jauli arasai hinomu langa goyaiha. Ono gainga teewe ete kokorokowai. ");
INSERT INTO eri_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ono wainga haruwe aita waha no ege Pita uredu bona no fai hinomu langa oto wane waha benou lenigai, “Fai beha no nebereha ete.” ");
INSERT INTO eri_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ono wainga Pita no ege, “Uwa” iwaiha. Ono gainga iinga menanga onou fai jugu langa otowane waha ege Pita benou letuwane, “Ngalenga tigini, ne fai beha nebere ilibanege ete. Ne Galili fainga.” ");
INSERT INTO eri_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ariya elebe, Pita no beele danga bagu lenigina, “Ngalenga tigini ouwe langa, tere fai waha boya leya waha ji ada isini.” Ji yaawa boni wonga, Itou no ji inyabamu hiyonbona. ");
INSERT INTO eri_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","No beele leboro wainga, fasayadu onou teewe wari nga waiha. Ono wainga Pita no beele Yesus letuwai waha bona ninau isai, “Saini teewe wari ngawei uwa inyi gonga, ne ji boni ada isini iwou le eei wau ganga tuwai.” Onodu bona Pita no inyangaro meraiha. ");
INSERT INTO eri_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gai eringe amina pris aroro bagu, nere mora bagu, nuuni beele isou fai bagu, kaunsel bagu, nere oruwanga beele ngado dedu dada ono wodbode waha koto wane. Onodu iinga nere Yesus baklain langa dage tudu bode, haudu togoi Pailot owo langa tafaneha. ");
INSERT INTO eri_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ono wanenga Pailot no Yesus benou isoki tuwai, “Ne Juda nebere King yo?” Ono wainga Yesus no beele gidu benou letuwai, “Ne nage leni onounga.” ");
INSERT INTO eri_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pris aroro nere Yesus go bode beele baingaro tafaneha, ");
INSERT INTO eri_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ono wanenga Pailot no ege benou isoki tuwai, “Ne beele ete ada gidu lewau yo? Nere beele baingaro ne gete bode tafane waha ne amina isinaha.” ");
INSERT INTO eri_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ariya Yesus no beele ete te gidu lewei uwa, ono wainga Pailot no ninau baingaro isaiha. ");
INSERT INTO eri_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Haga orei oruwa bori nomo fati anyakaro waha langa, Pailot no fai dagou mataha etenga awa tutuna. Fai-aita bagu nere nage fai dagou mata langa yafana waha unyi te ganenga, Pailot no fai waha awa tuganga nere bagu goi-goina. ");
INSERT INTO eri_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Saini waha langa, fai nere gabman bagu oota jaimudu bode, fai ila dunege kote wanenga umeru wane waha dagou mata langa logosi nigane. Nere gamanege langa fai waha ete unyi Barabas. ");
INSERT INTO eri_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ariya, fai-aita bagu mai heigedu bode, Pailot no amina ono nigigai waha onounga onowei nomo bona isoki tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ono wanenga Pailot no nebere beele benou gidu lenigai, “Tere Juda nebere King waha awa tuwehenga tere bagu goyei nomo gaude tigina yo?” ");
INSERT INTO eri_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailot no onou lewai, wa taate bona, no alai, pris aroro nere Yesus bode huwanyanege inyabawou wahanga la, nere no haudu bode kot langa goyane. ");
INSERT INTO eri_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pris aroro nere fai-aita bagu Pailot inyangaro jauredu letuwogunga Yesus adai awa tuwou. No Barabas awa tuwonga nere bagu mayei nomo bode huwanyanege jaimu naganeha. ");
INSERT INTO eri_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ono wanenga Pailot no ege benou isoki nigai, “onou wa, fai beha tere Juda nebere king tuya waha, ji adadu ono tuwei nomo gau tigina?” ");
INSERT INTO eri_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ono wainga nere ege yauredu benou letuwane, “Nauge abalakawou langa waragu.” ");
INSERT INTO eri_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ono wanenga Pailot no isoki nigai, “Taate bona? No taate nyabulu waha?” Ono wainga nere inyangaaro yauredu hiri bode lewane, “Nauge abalakawou langa waragu.” ");
INSERT INTO eri_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ono wanenga Pailot no fai-aita bagu edegamu nigona onowai. Onodu no Barabas awa tuwainga nere bagu goyai. Onodu no lewainga oota fai Yesus falagati uulu tuwane. Iinga no Yesus nauge abalakawou langa warei nomo bona, oota fai owonege langa tafai. ");
INSERT INTO eri_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Oota fai ila nere Yesus haudu gabman mata nomo orei huwanya langa goidu bode, oota fai oruwanga yaure niganenga mayaneha. ");
INSERT INTO eri_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nere kolos giriwou ete Yesus tanimu fuwaneha. Onodu nere maalu kudina bagu elegedu king nomo teteri dorofe atidu bode, mora langa tanimu fuwane. ");
INSERT INTO eri_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Onodu benou letuwane, “Juda nebere King, Kaiye!” ");
INSERT INTO eri_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ono bode hoobu ete tedu mora gulawane. Onodu bisinga tuwane. Onodu afenege tuburu kutudu fai unyinege anyakaro nigei nomo onoya dorofe ono wane. ");
INSERT INTO eri_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nere no memesi tuwou dada waha, oruwanga ono borodu bode, kolos giriwou waha uulu fuwane, onodu nogo nomo kolos waha ege tanimu fudu, nauge abalakawou langa tofiye tuwei nomo haudu goyaneha. ");
INSERT INTO eri_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Fai ete nomo unyi Saimon, no Sairini taonha, no maidu bona taon huwanya goyona onowai. Saimon no Aleksandria Rufus ngare amenere. Ono gainga oota fai nere haudu bode letuwanenga Yesus nomo nauge abalakawou aulai. ");
INSERT INTO eri_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nere Yesus haudu haumu ete langa goyane, unyi Golgata. Unyi waha nomo hugu benou, Moranege ngedo nomo haumu. ");
INSERT INTO eri_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nere wain marasin bagu ubulumu wane waha, Yesus tuwode ono wane. Ariya no nyei uwa. ");
INSERT INTO eri_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ono wainga, nere oota fai Yesus nauge abalakawou langa tofiye tuwane. Onodu, no nomo kolos dada oruwanga nere nage wesedu eleganeha. Nere faiwei no dada adoha tonbona waha, abitimuwou tuntani hiri waneha. ");
INSERT INTO eri_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nere eringe 9 kilok langa Yesus nauge abalakawou langa tofiye tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Onodu nere fai kot langa tafa nigidu bode, beele yerege yeregede haumu langa, nere beele benou yeregane, “Juda nebere king.” ");
INSERT INTO eri_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Yesus hinomu langa, fai nga nononga nauge abalakawou langa tofiye nirane, yebu fai bagu waragou fai bagu. Ete Yesus owo hilou langa, ete nomo owo kenao langa. ");
INSERT INTO eri_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ono wanenga fai-aita bagu goi-goi mai-mai bode, memesi beele letuwaneha. Nere moranege aya bode benou letuwane, “Ne tempel koresedu boni, fati eeinga langa tafagou. ");
INSERT INTO eri_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Elebe ne nagewe hoyowau. Ne nauge abalakawou awadu heigedu mau.” ");
INSERT INTO eri_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pris aroro bagu, nuuni beele isou fai bagu, nere fere memesi beele letuwaneha. Nere nage-nage benou leguruwane, “No fai ila hoyo nigai, ariya no nogo hoyo tuwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Fai beha Itou no nomo fai-aita bagu, gidu hanigei nomo hangada tuwai. Israel nebere King beha, no edo nauge abalakawou awadu heigedu monga uredu, huwanyage ngalenga wonbona.” Fai nga nononga Yesus hinomu langa, nauge abalakawou langa narirane waha, nere fere Yesus memesi beele letuwareha. ");
INSERT INTO eri_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hoonga gama 12 kilok langa, agugu oula oruwanga kutaudu inyi gainga goi 3 kilok esuwa langa heigai. ");
INSERT INTO eri_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 kilok esuwa, Yesus no inyangaaro yauredu benou lewai, “Elo-i, Elo-i, lama sabaktani?” Beele beha nomo hugu benou, “Yame Itou, Yame Itou, ne taate boni awa hinaha?” ");
INSERT INTO eri_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ono wainga fai ila jugu la otowane waha, beele waha isidu bode benou lewane, “Isagu, no Elaija yaure tuna.” ");
INSERT INTO eri_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Fai ete guriyedu goidu bona spons ete tedu wain langa tafai, wain spons langa bolo wainga dumuga ete langa dagedu, Yesus nyei nomo bona tuwaiha. Onodu fai waha lewai, “Itari gadenga, uredu boya. Elaija medu haudu teme tafa tuwona rute, uwa rute?” ");
INSERT INTO eri_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus no inyangaaro uidu bona umaiha. ");
INSERT INTO eri_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ono gainga ogola anyakaro tempel huwanya langa tofiyou waha, mutu ouwe langa koraidu teme esene langa kaitai. Ogola koraiwai waha nomo matau nga heigai. ");
INSERT INTO eri_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ono wainga, oota fai nebere kepten no Yesus hinomu langa oto bona, Yesus onou langa umainga uredu benou lewai, “Ngalenga tigini, fai beha no Itou Idau.” ");
INSERT INTO eri_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aita ila fere menanga baae langa igei bode oto wane. Nere waha nebere gamanege langa ete no Maria Makdala taonha. Maria ete waha no Jems jabumu Josep ngare neire anyanere. Ete waha no Salome. ");
INSERT INTO eri_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Saini Yesus no Galili langa yafa gainga, aita waha nere no oojo tubode hoyo tuwaneha. Aita ila fere baingaro yafane, nere Yesus oojo tuwanenga gaara Jerusalem mananeha. ");
INSERT INTO eri_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Esuwa gainga, Josep Arimatea taonha, no mayai. No kaunsel ete, onodu no fai-aita bagu agenege langa unyi hilobainga. No fere Itou nomo huuna langa yafou waha uronbona itari-itarina. Ira onou, Juda nebere Bori nomo fati heigon bona, ariya elebe onou waha dada haiyawei nomo saini. Waha bona Josep no gamu goidu, Pailot hogo langa umugou uwau oto bona, Yesus gogala awa fuwonga tonbona waha Pailot isoki tuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ono wainga Pailot ninau baingaro isai, onodu isoki tuwai, “No umaha yo?” Onodu oota fai nebere kepten yaure tuwainga mayainga isoki tuwai, “Yesus umaha yo uwa?” ");
INSERT INTO eri_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailot no kepten langa beele isidu bona, Josep no Yesus gogala edo tei nomo bona letuwaiha. ");
INSERT INTO eri_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ono wainga, Josep no kolos kaamba ufaro ejiyadu bona, Yesus gogala tedu temai. Onodu no kolos kaamba langa kuromu tudu bona, tedu togoi matmat ete langa tafa tuwaiha. Matmat waha megebu u-u ete fai nere nage kulu waneha. Onodu Josep no megebu ete ubelum wainga maidu u-u waha fosokowai. ");
INSERT INTO eri_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdalaha, no Maria, Josep anya ngare igei bodere oto garenga, nere Yesus gogala tedu togoi tafa tuganenga urare. ");
INSERT INTO eri_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juda nebere bori nomo Fati usu wainga, Maria Makdalaha wainga, Maria Jems Josep ngare anyanere wainga, Salome wainga, nere faronga bagu dada ila agiya hilou-hilou waha bagu ejiya wane. Nere goidu Yesus gogala langa bisemu wodbode ono wane. ");
INSERT INTO eri_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bori nomo fati amugou gai eringe amina, nere matmat langa goyane. ");
INSERT INTO eri_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nere goi bode, nere nage-nage benou leguruwane, “Faiwei ete no ere hoyo higidu megebu matmat u-u sesemu wane waha, ubeludu aririmu hagage yo?” ");
INSERT INTO eri_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Saini nere matmat langa maidu jugu bode igei wane wa, megebu matmat u-u sesemu wou walanga inyei uwa. Nere megebu waha ubelumudu aririmu wou urane. Megebu waha no gai anyakaro. ");
INSERT INTO eri_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nere maidu matmat huwanya langa goi bode, magana giila ete nomo kolos kaamba ufaro bagu, owo hilou langa yafa gainga uredu, horoto wane. ");
INSERT INTO eri_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ono wanenga no benou lenigai, “Tere adai horoto wagu. Ji isini, tere Yesus Nasaretha nauge abalakawou langa tofiye tuwane waha, kuru tuwagu ganga maiyaha. No amina jayaha. No belanga inyei uwa. Uragu, haumu belanga no tafa tuwaneha. ");
INSERT INTO eri_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Waha bona tere goidu nomo disaipel lenigi bonade, Pita fere letuwagu, ‘Yesus no tere amuge tigidu bona, Galili langa goina. Tere no amina letigai onou, goidu Galili walanga uragu ganga.’” ");
INSERT INTO eri_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ono wainga, aita nere malala maidu bode, matmat awadu hara waneha. Nere aau togo nagainga terere bode, fai ete te letu weguwa, nere umuganeha. ");
INSERT INTO eri_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus no eringe amina bori nomo fati amugou langa jayaiha. Onodu no Maria Magdalaha heigei uwa inyi gainga, no amugedu heigaiha. Yesus no amina aita waha langa hauri inyaba 7 so nigaiha. ");
INSERT INTO eri_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ono wainga, Maria Magdalaha no goidu bona, fai Yesus ngate gaara golowane waha lenigai. Fai waha nere aau togo nagainga mere bode yafane. ");
INSERT INTO eri_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria no benou lenigai, “Yesus no ago auma yafa gainga urenaha.” Ono wainga, nere nomo beele waha isidu, huwanyanege ngalengawei uwa. ");
INSERT INTO eri_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Iinga Yesus nomo disaipel nga nere taon awadu bodere golodu goyare. Ono garenga, Yesus no hogo ferete heigedu bona, goi nere bagu heigai. ");
INSERT INTO eri_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ono wainga nere goidu bodere, beele waha malalamudu Yesus nomo disaipel ila hai nagareha. Ono ware wa, nere neire beele waha bodere huwayange ngalenga weguwa. ");
INSERT INTO eri_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iinga Yesus nomo disaipel 11, nere da nyibode yafa ganenga, Yesus nere langa heigai. Onodu nere huwanyanege ngalengawou uwau bona honggoro nigai, onowai wa nere huwanyanege sese wainga, nere fai-aita bagu no gidu jayai waha bode lewane waha, nere huwanyanege ngalengawei uwa. ");
INSERT INTO eri_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Onodu no benou lenigai, “Tere ha-ha oruwa langa goidu hilou beele malalamudu fai-aita bagu oruwanga hai nagagu. ");
INSERT INTO eri_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Fai no huwanya ngalenga wonga yaage bisou tona waha, Itou no ege gidu hawonbona. Ariya fai no huwanya ngalengawei uwa waha, no kot langa yaae wonbona. ");
INSERT INTO eri_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Itou no dodokawou fai nere huwanyanege ngalengade waha owonege langa heigemu wonbona. Ji unyife langa hauri inyaba so nigibode, beele eege hogo fere-fere waha malalamudu lewodbode. ");
INSERT INTO eri_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nere maangi owonege langa yaasu wodbode. Onodu, nere dada fai dunege kotena waha nyei mata wode wa, dada waha nere ada inyabamu nigonbona. Onodu nere taura fai langa owonege tafabode wonga, taura fai taura ege jige nigona bona.” ");
INSERT INTO eri_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Anyakaro Yesus no beele malalamudu lenigi boro wainga, Itou no Yesus haudu ha laluwa langa manai. No Itou owo hilou langa yafana. ");
INSERT INTO eri_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ono wainga disaipel nere ha-ha oruwa langa goidu bode beele malalamudu lewaneha. Anyakaro no nere bagu haruwe tebona, no nebere beele dangamu nagi bona dodoka ila heigemuwai. ");
INSERT INTO eri_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Oo fai anyakaro Tiofilas, nere fai baingaro, amina dada Itou no ere gamage langa ono wainga heigai waha, nomo aasa yeregei nomo bode owonege isisi wane. ");
INSERT INTO eri_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nere hugu warou la fai nere dada agenege langa ure ganenga jayai waha nebere beele oojo wane. Nere fai waha, Itou nomo beele nomo haruwe fai dorofe yafa bode, aasa beha hai hagane. ");
INSERT INTO eri_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Onou waha boni, ji fere, ji aasa waha yeregedu boni, huuru hanonboni. Saini ufalai, ji nere dada waha oruwanga, nomo hugu boni isokide nigene. Elebe, ji dada amina heigai, onounga tigini yeregeni. ");
INSERT INTO eri_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ne lelegedu edola isi dewau ganga, beele beha, nere isisiwou hinane waha, no ngalenga tigini. ");
INSERT INTO eri_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saini Herot no Judia nebere king yafa gainga, pris ete yafai, nomo unyi Sekaraia. No pris Abiya, nomo ganeha ete. Nomo oya no Aron nomo ganemuha, aita waha unyi, Elisabet. ");
INSERT INTO eri_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nere Itou ago langa gai tigini yafare. Nere nuuni beele bagu, Anyakaro nomo beele oruwa oojo gare. Onodu, nere no ago langa nyabuluwou ete uwau. ");
INSERT INTO eri_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Onoware wa, nere magana uwau, taate bona, Elisabet no magana bisei nomo edo uwa. Onodu nere amina umura wareha. ");
INSERT INTO eri_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Saini ete langa, Sekaraia no nomo gane, nere goi pris haruwe taane. Ono gane, Sekaraia no fere Itou ago langa pris haruwe tai. ");
INSERT INTO eri_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ariya, nere Pris adoha no Anyakaro nomo mata huwanya langa goidu bona, eeya muru warou nomo agiya hilobainga bitonga heigei nomo waha, torobawei nomo bode nere tuntani aya wane. Ono wane wa, onowou waha langa, nere Sekaraia hangada tuwanenga, no eeya muru warei nomo bona mata waha huwanya goyai. ");
INSERT INTO eri_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ariya, saini eeya muru warei nomo la, nere fai-aita toomaro Itou nomo mata malala langa kotodu bode hauya bode yafane. ");
INSERT INTO eri_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ono gainga, Anyakaro nomo ensel ete Sekaraia bagu heigedu bona, eeya muru warei nomo buutu agiya hilobainga heigena waha, nomo alta ulate owo hilou langa oto gainga urai. ");
INSERT INTO eri_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","No ensel uredu horotodu bona, no umugai. ");
INSERT INTO eri_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ono wainga ensel no letuwai, “Sekaraia, ne adai umugau. Itou no ne name hauyawou, amina isaha. Name oyane Elisabet no fai magana bisonbona. Ono wonga, ne nomo unyi Jon warau. ");
INSERT INTO eri_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Name huwanyate hilobainga inyi gonga, ne edegawau ganga. Saini magana waha heigonga, nere fai-aita baingaro, no bode, edega wodbode, ");
INSERT INTO eri_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","taate bona, no anyakaro ago langa unyi anyakaro bagu. No wain bagu bia bagu ada nyona. Saini no anya huwanya langa inyi gonga, Hauri Guuni no bolo tuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","No Israelha fai-aita baingaro, huwanyanege ubulumu nagonga, nere nebere Anyakaro, Itou bagu goyodbode. ");
INSERT INTO eri_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","No Elaija nomo fanyimu bagu, nomo danga bagu tedu bona, no Anyakaro amuge tudu goyonbona. No nere amenege gane, idanege gane bagu, ono nigonga, nere huwanyanege etenga wodbode. Onodu, no fai beele feiyagou waha, nebere ninanege tiginumu nagonga, nere fai hilobainga nebere isou dorofe todbode. No fai haiya nigonga, nere Anyakaro mayei nomo, haiyadu bode yafodbode.” ");
INSERT INTO eri_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ono wainga Sekaraia no ensel letuwai, “ji ne name beele ngalenga waha adadu la isoni? Ji umuraniha, yame aita fere no umura waha.” ");
INSERT INTO eri_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ono wainga, ensel no ege gidu bona benou letuwai, “Ji Gebriel, ji Itou hogo langa oto-otoni. Itou, no nogowe ji huuru hiyanga, beele hilobainga beha, tedu boni ne lehinoni menaha. ");
INSERT INTO eri_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ariya ne isau. Ne yame beele boni huwanyate ngalengawei uwa, waha bona elebe ne name hurate fosoko wonga, ne beele ada hayauganga, goi saini dada waha oruwa heigonga, Ji yame beele beha tigini heigonbona, saini Itou hangadawai la.” ");
INSERT INTO eri_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ono gainga, nere fai-aita bagu, Sekaraia gai itari tubode ninanege baingaro isane, taate dada no langa heigainga saini ufaro Itou nomo mata jauli langa yafai. ");
INSERT INTO eri_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ono gane iinga, no mai heigai, onodu no nere beele lenigei nomo edo uwa. Ono wainga nere isane, no dada hogo fere ete Itou nomo mata jauli huwanya wala uraha. No beele, ewe owo langanga la lenigai. Nomo hurau nuu, onou fosokodu inyai. ");
INSERT INTO eri_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iinga Sekaraia no nomo haruwe nomo saini usu wainga, no ege gidu nomo matane goyai. ");
INSERT INTO eri_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ariya iinga, nomo oya Elisabet, no go bagu wai. Onodu, no Ole anyimu kouwou-oruwa, huwaridu yafai. Onodu bona lewai, ");
INSERT INTO eri_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Anyakaro no ji bona aau waranga, no ji yame mayau nere fai-aita bagu agenege langa, uulu hayei nomo bona no ji onou ono hiyaha, iwai.” ");
INSERT INTO eri_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet no go bagu ole 6 golo gainga, Itou no ensel Gebriel huuru tuwainga, Galili nomo taon ete unyi Nasaret langa minai. ");
INSERT INTO eri_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","No aita magana giila ete, no King Devit nomo ganemuha, waha nebere fai magana ete, unyi Josep tei nomo urisi kou wane waha, no bagu minai. Aita magana giila waha nomo unyi Maria. ");
INSERT INTO eri_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebriel no bagu minidu benou letuwai, “Oo aita, kaiye, Anyakaro no ne bagu yafa bona, figini hini bona, hilobainga tafa hinaha.” ");
INSERT INTO eri_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ono wainga, Maria no beele waha isidu bona, no horotodu ninau isai, “Beele beha taate beele benou?” ");
INSERT INTO eri_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ono wainga, ensel no letuwai, “Maria, ne adai umugau, Itou no ne bona huwanya hilobainga inyina. ");
INSERT INTO eri_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ne isau, ne gete bagudu bonahe, fai magana ete bisau ganga. Onodu nomo unyi Yesus warau. ");
INSERT INTO eri_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","No fai anyakaro yafonbona. Ono gonga, nere no Itou Gai Tigini Ouwe la nomo Idau tuwodbode. Ono gonga, Itou no king tafa tuwonga, nomo asa Devit dorofe yafonbona. ");
INSERT INTO eri_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","No Jekop nomo gane nebere king gai-gai yafonbona. Ono gonga nomo king haruwe waha, ada usuwon bona.” ");
INSERT INTO eri_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ono wainga, Maria, no ensel isoki tuwai, “Ji iinga fai tei uwa yafani. Onou bona, dada waha adadu la heigona leni?” ");
INSERT INTO eri_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ono wainga, ensel no beele ege gidu benou letuwai, “Hauri Guuni no ne bagu monbona, ono wonga Itou Gai ouwe la, nomo danga ne kuromu hinonbona. Ono wonga, iinga gonga ne magana bisau wa, no Itou nomo fai hilobainga tigini yafonbona. Ono gonga, nere no bona lewodbode, Itou Nomo Magana. ");
INSERT INTO eri_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ne isau, name awate Elisabet no umura waha. Onodu no go bagu waha, no fai magana bisonbona. Amina nere legane, no magana bisei nomo edo uwa. Ariya, elebe nomo ole 6 goyaha. ");
INSERT INTO eri_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Itou no dada ete, no ada onowei nomo ete uwau.” ");
INSERT INTO eri_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ono wainga, Maria no letuwai, “Ne isau, ji Anyakaro nomo haruwe aita. No edo ne lenaha onou langa ono hiyona.” Ono wainga, ensel no awa tudu bona manai. ");
INSERT INTO eri_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Saini waha langa, Maria no jaidu fasadu onou, Judia distrik nomo taon ete muju ha langa inyina, wala manai. ");
INSERT INTO eri_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Onodu Sekaraia nomo mata huwanya la goidu bona, Elisabet kaiye tuwai. ");
INSERT INTO eri_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ono wainga, Elisabet no Maria nomo kaiye tuwou waha isi gainga, magana Elisabet ogou langa inyai waha, no talagai. Ono wainga, Hauri Guuni no Elisabet bolo tuwainga, ");
INSERT INTO eri_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","inyangaaro yauredu lewai, “Itou no hilou tafa hini figiniwou ne hinai wa, figiniwou nere aita ila nigai wa feiyanigou. Onodu magana ne ogote langa inyina waha fere, no itou nomo figiniwou bagu. ");
INSERT INTO eri_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ji aita adoha bona, yame Anyakaro nomo anya no ji bagu mayaha? ");
INSERT INTO eri_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne isau, ji yame agefekuli, name kaiyewou isi ganga, magana ogofe langa inyaha no edega bona talagaha. ");
INSERT INTO eri_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ne huwanyate ngalengawai, onou waha bona ne dabu edega dewau. Anyakaro no ne lehinai onounga onowon bona, Elisabet no onou lewai.” ");
INSERT INTO eri_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria no benou lewai, “Ji yame huwanyafe, no Anyakaro unyi isouna. ");
INSERT INTO eri_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ono ganga, yame anufe no Itou bona edegana, no yame Hoyo hiyou, no ono higanga, ji yafa deni. ");
INSERT INTO eri_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Elebe bagu, iinga huunta langa fere, nere fai-aita oruwanga, nere Itou no ji edegawou anyakaro hiyai, waha lewodbode. Ji nomo haruwe aita, ji aita ewe, no ji bona aau warai. ");
INSERT INTO eri_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Itou danga anyakaro bagu, no Ji hoyo hiyei nomo bona dada hogo ferete onowai. Waha bona nomo unyi gunni inyina. ");
INSERT INTO eri_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","No fai-aita bagu, nomo huuna langa yafade waha bona, aau wari-warina. Onou dorofenga, nere fai-aita elebe yafade beha bagu, nere fai-aita, iinga huunta heigede la bagu, gai-gai inyi gonga goyonbona. ");
INSERT INTO eri_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nomo owo no haruwe danga bagu tai. Nere fai huwanyanege langa, nere nage unyinege isou bode ere tigini amugou ide waha, no nere so nigainga, kejiwe hara wodbode. ");
INSERT INTO eri_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","No king danga bagu ilei nigai. Onodu bona, no nere fai unyinege uwau waha, unyinege isouwai. ");
INSERT INTO eri_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","No nere fai huweli nigai waha, dada hilobainga baingaro nigai, ono wainga, nere ogonege digaiha. Ariya, nere fai dadanege bagu waha, no so nigainga ewenga goyane. ");
INSERT INTO eri_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","No nomo haruwe fai Israel hoyo tuwai, onodu no Abraham, ebere asage gane bagu, nebere magana iinga huunta la heigodbode waha bona aau waronbona beele baara tawai waha bona gai ninau isi-isina.” ");
INSERT INTO eri_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria no Elisabet ngare ole eei onou yafadu, iinga no ege gidu nomo matane goyai. ");
INSERT INTO eri_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet no nomo magana bisei nomo saini heigainga, no fai magana bisai. ");
INSERT INTO eri_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ono wainga, Elisabet nomo matane etenga bagu, nomo olobeta mutu etenga bagu, nere Anyakaro no bona aau wari dewai waha isidu, no ngate edega wane. ");
INSERT INTO eri_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Onodu, fati 8 langa nere magana gogala karu fuwei nomo bode mayane. Nere no unyi umamu jabumu Sekaraia warode ono wane. ");
INSERT INTO eri_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ono wane wa, nomo anya no lewai, “Uwa. Ere nomo unyi Jon waroboya iwai.” ");
INSERT INTO eri_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ono wainga, nere no letuwane, “Ne name asane gane unyinege onouha ete uwau tuwane.” ");
INSERT INTO eri_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Onodu bode, nere umamu owonege langa abiti tubode, no magana unyi faiwei warona waha bode isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ono wanenga Sekaraia no dada ete tamai fuwo gonga, yeregei nomo bona lenigai, onodu no onou yeregai, “Nomo unyi, Jon.” Ono wainga, nere ninanege baingaro isane. ");
INSERT INTO eri_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ono ganenga, fasayadu onou Sekaraia nomo hurau isebu wainga no ege beele lewei nomo edo. Ono wainga, no beele lebona Itou unyi isouwai. ");
INSERT INTO eri_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ono wainga, nere nomo matane etenga waha dada hogo ferete heigainga uredu nere umugane. Ono wainga, dada oruwa heigai waha nomo beele, Judia prowins nomo matane muju ha langa inyide waha, oruwa langa goi edowai. ");
INSERT INTO eri_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Fai oruwa nere beele waha isidu bode, ninanege baingaro isidu benou isoki wane, “Iinga magana waha no fai adoha heigonbona?” Anyakaro nomo danga no langa inyina waha, nere alai. ");
INSERT INTO eri_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon umamu Sekaraia no Hauri Guuni bolo tuwainga, no profet beele benou lewai, ");
INSERT INTO eri_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ere Israel ebere anyakaro, Itou unyi isouwei nomo. No medu bona, ere nomo fai-aita hoyo higidu, ege gidu haigaha. ");
INSERT INTO eri_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","No nomo haruwe magana Devit, nomo ganemuha fai danga bagu ere ege gidu haigei nomo bona tafa tuwai, ");
INSERT INTO eri_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","aminanga la, no nomo profet huranege la lewai onou. ");
INSERT INTO eri_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","No lewai, no ere ebere honggoro fai bagu, nere fai ere bode huwanyanege inyaba dede waha bagu, owonegeha ege gidu haigonbona. ");
INSERT INTO eri_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","No ebere asage gane bona aau warainga, hoyo nigai. No nomo beele agili mala karuwou aminaha waha bona ninau gai isi-isina. ");
INSERT INTO eri_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","No amina ebere asage Abraham letuwai, ngalenga tigini ouwe la. Elebe no amina lewai onou ere langa onowon bona. ");
INSERT INTO eri_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","No ere honggoro fai owonegeha ege gidu haigonbona, ere nomo haruwe edo yaasuwei nomo, ere ada umugo boya. ");
INSERT INTO eri_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Onou waha bona saini oruwa ere agege auma yafa boya, onowou tgini no gau tuna waha la golo gedenga, onowou hilou-hilou no gau tuna waha ere edo bolo higonbona. ");
INSERT INTO eri_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Oo yame magana, ne iinga lehinod bode, ne Itou Gai Ouwe la nomo profet hinodbode. Ne Anyakaro nomo yala haiya fu bonahe, amuge tudu goyau ganga. ");
INSERT INTO eri_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Ne nomo fai-aita bagu isisiwou nigahenga, nere isodbode, no nomo aau warou anyakaro langa, Itou no nere nebere une uulu nagi bona ege gidu hani gonbona. No ha laluwa nomo hamba huuru wonga ere langa medu, ");
INSERT INTO eri_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nere fai haumu agugu langa yafade waha, lala nigonbona. No ebere afege jala abitimu hagi gonga, ere huwanyage foinga inyou jala la golo woboya.” ");
INSERT INTO eri_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ariya, iinga magana waha no goi anyakarodu bona, no nomo hauri danga bagu heigai. Onodu no goi ha fai uwau langa yafa gainga goi saini no Israel agenege langa malala heigai. ");
INSERT INTO eri_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Saini waha la, Sisar Ogastus no nuuni beele ete tafai wa, nere fai-aita oruwanga nebere unyinege elegodbode. ");
INSERT INTO eri_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Saini waha langa, Kwirinius no Siria prowins nebere gabman amugou yafa gainga, nere onowou eege heigemudu, fai-aita unyinege elegane. ");
INSERT INTO eri_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Onou waha bona, nere fai-aita oruwa gabman unyinege elegei nomo bona nebere matane hugu la goi-goi wane. ");
INSERT INTO eri_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ariya, Josep no King Devit ganemuha, waha bona no Nasaret taon Galili langa jaidu bona, Judia King Devit nomo taon Betlehem ide, walanga goyai. ");
INSERT INTO eri_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","No nomo oya Maria ngare gabman unyinere elegei nomo bodere goyare. Saini waha langa, Maria no go bagu. ");
INSERT INTO eri_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nere goi Betlehem la yafagarenga, Maria no nomo magana bisei nomo saini heigai. ");
INSERT INTO eri_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ono wainga, no nomo magana amugou, fai magana bisai. Onodu ogola la dage tudu bona, bulumakao nebere da logosi gou bogisi la inyemu tuwainga inyai, taate bona, fai jirigou mata wa bolowai. ");
INSERT INTO eri_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Haumu waha langa, nere sipsip oofa nigou fai ila taon waha nomo dui langa yafa bode ooru la nebere sipsip oofa nigi gane. ");
INSERT INTO eri_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ono ganenga, Anyakaro nomo ensel no nere bagu mai. Ono gainga, Anyakaro nomo lala anyakaro medu bona, nere kolili nigai. Nere waha uredu bode, umuge dewane. ");
INSERT INTO eri_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ono wanenga, ensel no lenigai, “Tere adai umugagu. Tere isagu. Ji tere beele hilobainga teme taginaha, beele waha tere fai-aita oruwa, huwanyatege edega dewonbona. ");
INSERT INTO eri_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Elebe fati beha la, Devit nomo taon la, aita ete magana bisaha. Magana waha no tere oruwa ege gidu hatigon bona, no Anyakaro. Fai no waha, Itou no nomo fai-aita bagu ege gidu hanigei nomo hangada tuwai ");
INSERT INTO eri_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tere no benou uragu ganga. Magana momodo ete ogola la dage tudu bode, bulumakao nebere da logosi gou bogisi la inyemu tuwane inyina.” ");
INSERT INTO eri_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel no onou lenigi boro gainga, fasadu onou ensel baingaro nere ha laluwa nomo oota fai medu bode, ensel amugedu mai waha ngate otowane. Onodu nere Itou unyi benou isou wane, ");
INSERT INTO eri_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Itou gai tigini ouwe la yafana unyi isou wagu. Ha esene la fai-aita edo huwanyanege foinga inyona. Itou no huwanya hilobainga nigaha.” ");
INSERT INTO eri_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ariya, ensel nere awa nigidu, ha laluwa la gidu mani hara ganenga, sipsip oofa nigigou fai nere lewane, “Ariya, ere Betlehem goidu boya, dada heigaha waha uroya, Anyakaro no lehigaha waha.” ");
INSERT INTO eri_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Onodu, nere fasadu onou goidu Maria, Josep ngare yafagare nerirane, onodu bode nere Magana momodo no bulumakao nebere da logosi gou bogisi langa inyi gainga urane. ");
INSERT INTO eri_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nere uredu bode, nere beele ensel magana momodo waha bona lenigai waha malalamudu lewane. ");
INSERT INTO eri_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ono wainga, nere fai oruwa beele waha isidu bode, nere ninanege baingaro isane. ");
INSERT INTO eri_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ariya, Maria no beele waha oruwa huwanya la tafadu, ninau isi bona yafai. ");
INSERT INTO eri_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Onodu, nere sipsip oofa nigigou fai nere ege gidu minidu bode, Itou unyi isouwou haruwe tane. Nere dada oruwanga isidu, urane waha bona, Itou bode edega wane. Dada ensel no lenigai onounga tigini heigai. ");
INSERT INTO eri_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ariya, anya bisi tuwainga fati 8 usuwai langa, nere no gogala karu fu bode, unyi Yesus warane. No anya huwanya la heigei uwa inyi gainga, ensel no amina unyi waha warai. ");
INSERT INTO eri_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josep oya Maria ngare nere, Moses nomo nuuni beele lena waha nomo fanyimu oojodu, Itou ago langa jijiga uwau heigei nomo bodere nomo saini heigainga, nere magana waha anyakaro tuwei nomo bodere, Jerusalem goyare. ");
INSERT INTO eri_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nere Anyakaro nomo nuuni beele inyina waha oojo wodbodere, wa benou, “Nere fai magana motuwa anyanege bisi nigode wa, nere magana waha Anyakaro tuwodbode.” ");
INSERT INTO eri_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nere eeya muru warei nomo neei fere tamanare. Anyakaro nomo nuuni beele lena dorofe, “Buuna aroro nga nononga yo, oo lao buuna gila nga nononga.” ");
INSERT INTO eri_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Saini waha langa, fai ete Jerusalem la yafagai, nomo unyi Simion. No fanyimu tigini wahanga ono bona, Itou unyi isou gai. No Israel huwanyanege hilobainga inyei nomo bona, Itou fai hangadawai waha itari tuwai. Ariya, Hauri Guuni no Simion bagu yafai. ");
INSERT INTO eri_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Onou waha bona, Hauri Guuni no Simion amina letuwai, no fasadu ada umona. No amugedu, Anyakaro no fai, no nomo fai-aita bagu ege gidu hanigei nomo huuru tuwonga monbona beele baara tawai waha uronbona. ");
INSERT INTO eri_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Onou waha bona Hauri Guuni no huwanya jaimu fuwainga, no tempel huwanya la goyai. Ono gainga, umamu anya ngare nere fanyimu nuuni beele lena onou, ono tuwodbodere bona magana momodo Yesus haudu mayare. ");
INSERT INTO eri_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ono warenga, Simion no owoha ngau tedu bona yaasu tuwai. Ono bona, no Itou unyi benou isouwai, ");
INSERT INTO eri_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Anyakaro, ji name haruwe magana, elebe ne edo awa hiyahenga goyoni, ono wahenga, yame huwanyafe edo foinga inyona, amina ne lewene onou. ");
INSERT INTO eri_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ji yage agefe hugu la, ne dada ere ege gidu haigei nomo ono wene waha, ji urene. ");
INSERT INTO eri_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ne waha fai-aita oruwa agenege langa haiya weneha. ");
INSERT INTO eri_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wa lala ete, nere fai-aita fereha waha, lala nigonbona. Onodu no Israel unyinege anyakaro nigonbona, wa ne name fai-aita gane bagu.” ");
INSERT INTO eri_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesus nomo anya umamu ngare nere Simion, beele no bona lenirai waha bodere ninanere baingaro isare. ");
INSERT INTO eri_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ono garenga Simion no nere figiniwou nigai. Ono bona, no magana nomo anya Maria, benou letuwai, “Isau, Itou no magana beha hangada tuwai wa, nere Israelha fai baingaro, ono nigonga taumode bode, ono bona baingaro nere ege ono nigonga gidu yayodbode. No naani ete dorofe inyi gonga, nere fai baingaro no bode beele inyaba lewodbode. ");
INSERT INTO eri_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Onou waha bona, fai baingaro nebere ninanege huwari waha malala heigonbona. Ono gonga, ne fere oota kesebu mutu ufaro ete, name aau joru hanina dorofe yafau ganga.” ");
INSERT INTO eri_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ariya, profet aita ete yafai, nomo unyi Ana. No Fanyuel mago, no Aser nomo ganemuha. No gai umuranga, umura. Amina no fai tedu bona haga orei 7, nomo au ngare yafare. ");
INSERT INTO eri_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Iinga, no nomo au umainga, no ewe yafai. Ariya, elebe no nomo haga orei, 84. Ana no tempel ada awa gai. No da uridu bona, hauya bona yafagai. No hoonga bagu, ooru bagu, Itou nomo haruwe tegai. ");
INSERT INTO eri_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saini waha langa, no fere magana waha hinomu la maidu bona, Itou hilobainga tuwai. Onodu bona, no magana waha nomo beele malalamudu nere fai-aita oruwa, Itou no Jerusalemha fai-aita ege gidu hanigei nomo itaride waha lenigai. ");
INSERT INTO eri_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nere dada oruwanga, Anyakaro nomo nuuni beele lena onou ono borodu bode, nere ege gidu, Galili distrik nebere taon Nasaret langa minane. ");
INSERT INTO eri_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Onodu, magana no anyakarodu danga bagu heigai. No isou hilou-hilou baingaro, onodu Itou nomo aau warou no langa inyna. ");
INSERT INTO eri_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesus nomo umamu anya ngare nere haga orei oruwa langa Itou No Israel Awa Nigainga Hilou Yafane Waha Nomo Isi Nigou Fati Anyakaro waha urei nomo Jerusalem goi gare. ");
INSERT INTO eri_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus no nomo haga orei 12 usu wainga, nere fati anyakaro waha nomo fanyimu oojodu Jerusalem goyane. ");
INSERT INTO eri_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sain fati anyakaro waha nomo bori oruwa usu wainga, nere ege gidu matane goyane. Magana gila Yesus no gai Jerusalem waanga yafai. Ono gainga, nomo anya umamu ngare nere no gai walanga yafanawou iseru uwa. ");
INSERT INTO eri_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nere isare wa, no fai-aita ila bagu minide iware. Onodu bodere, nere fati ete oruwa goloware. Ariya iinga gainga, nere nomo ilibumu gane langa, nomo kadoi etenga bagu gamanege langa kuru tuware. ");
INSERT INTO eri_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nere no kuru tunga ware wa, nere no toroba tuweru uwa. Onou waha bodere, nere no kuru tuwei nomo bodere ege gidu Jerusalem goyare. ");
INSERT INTO eri_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nere fati eei oruwa, no kuru tuwou haruwe tare. Onodu bodere, iinga nere no tempel orei huwanya langa yafa gainga urare. No isisiwou fai gamanege langa yafai. No nebere beele aagu nagi bona, no nere isokiwou fere nigai. ");
INSERT INTO eri_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nere fai nomo beele isidu bode nomo isou bagu, no nebere beele ege gidu lenigai waha bode horoto wane. ");
INSERT INTO eri_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ariya, umamu anya ngare nere no uredu bodere horoto deware. Onodu bodere, nomo anya we no letuwai, “Yame magana, ne taate boni ere onou ono hirinaha? Ere name amene ngare, huwanyare oude hiranga, ne kuru hinou haruwe teenga yare.” ");
INSERT INTO eri_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ono wainga, no beele ege gidu benou lenirai, “Tere taate boyare ji kuru hiyou haruwe teyare? Ji yame Jijei nomo mata langa yafon boni, waha tere adaru isiyare?” ");
INSERT INTO eri_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ono wainga nere no beele onou lenirai waha nomo hugu alai uwa. ");
INSERT INTO eri_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Onodu bona, no nere bagu ege gidu gaara goidu Nasaret langa heigane, no gai-gai nere neire beele oojo gai. Ono wainga, nomo anya no beele waha oruwanga ninau langa tafadu yaasudu yafai. ");
INSERT INTO eri_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ono gainga, Yesus no goi anyakaro gainga, no nomo isou gai hilobainga heigai. Itou no gaude tugainga, fai fere no gau tuwane. ");
INSERT INTO eri_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ariya Sisar Taberius, no Rom nebere king yafa gainga, goi haga orei 15 la, Pontius Pailot no Judia distrik nebere gabman amugou yafai. Saini waha langa, Herot no Galili distrik oofagai. Ono gainga, nomo bemu Filip no Ituria distrik bagu, Trakonitis distrik bagu oofagai. Ono gainga, Lisanias no Abilene distrik oofagai. ");
INSERT INTO eri_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ono gainga, Anas no Kaiafas ngare nere Pris mora bagu yafare. Saini waha langa, Sekaraia idau Jon, no ha fai uwau langa yafa gainga, Itou no nomo beele Jon letuwai. ");
INSERT INTO eri_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ono wainga, Jon no haumu oruwa, Jordan yaage hinemu la inyide waha langa goidu bona, nere fai-aita huwanyanege ubuludu yaage bisou togunga, Itou no edo nebere une uulu nagei nomo bona, beele malalamudu lenigai. ");
INSERT INTO eri_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dada waha profet Aisaia nomo buk langa beele inyina dorofe heigai. “Ha fai uwau langa, fai ete bolou benou yauredu lewai, ‘Anyakaro nomo jala haiya fuwagu. Nomo jala tiginimu wagu. ");
INSERT INTO eri_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nere beberi oruwa kutau bode, muju aroro oruwa kakaru wogunga minona. Nere jala kobigou waha oruwa waro gunga tigini wode. Onodu jala oruwa inyaba waha, nere tiginimu dewode. ");
INSERT INTO eri_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ono wonga, nere fai-aita oulaha oruwanga, Itou no ere ege gidu haigei nomo haruwe tena waha urodbode.’” ");
INSERT INTO eri_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nere fai-aita baingaro, Jon owo langa yaage bisou tei nomo bode mayanenga no benou lenigai, “Tere maangi inyaba nomo magana gane, Itou no tere bona houmu mayaha bona, inyabamu tigonbona. Ariya, faiwei letigaha bona, saini inyaba tere langa heigona onona waha, feiyadu hara wagu ganga onoya? ");
INSERT INTO eri_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tere huwanyatege tigini ubulude bonade wonga, tere tebere fanyitege langa abitimu wagu ganga, tere amina huwanyatege ubulu yaha. Tere tage beele benou adai leguru wagu, ‘Abraham, no ebere asage amege bagu.’ Ji tere letigini, Itou no megebu beha waha, ono nigonga nere Abraham nomo magana asa gane bagu heigei nomo edo. ");
INSERT INTO eri_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Safora nauge hugu langa amina inyina, nauge oruwa hilou hilobainga ada heige-heigede waha, nere lalatidu bode elege eeya langa ayaru wogunga goyodbode.” ");
INSERT INTO eri_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nere fai-aita bagu, Jon nomo beele isidu, benou isoki tuwane, “Ere adadu ono woya?” ");
INSERT INTO eri_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ono wanenga, no beele ege gidu benou lenigai, “Fai no siot nga bagu wonga, no ete fai siot uwau waha tuwona. Fai no da bagu wonga, waha fere onounga ono wona.” ");
INSERT INTO eri_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nere takis tegou fai ila fere yaage bisou tei nomo bode mayane. Nere maidu benou isoki tuwane, “Isisi higigou fai, ere adadu ono woya?” ");
INSERT INTO eri_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ono wanenga, no benou lenigai, “Tere takis moni, gabman letigai onounga taagu, tere ege ila adai kuse wagu.” ");
INSERT INTO eri_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ono gainga, nere oota fai ila fere no isoki tuwane, “Ariya, ere adadu ono woya?” Ono wanenga no lenigai, “Tere, fai nebere moni yebuwei nomo bonade, kejiwe adai inyabamu nigagu. Onodu tere kot yaawa tudu nere moni nganege elegei nomo adai ono wagu. Tere benou isagu, tebere haruwe agou wa tere bagu edo langa.” ");
INSERT INTO eri_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Fai-aita bagu, nere dada waha uredu huwanyanege jayainga ninanege baingaro benou isane, “Jon no fai waha rute Itou nomo fai-aita bagu ege gidu hanigei nomo hangada tuwai iwane.” ");
INSERT INTO eri_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Onou waha bona, Jon no ege gidu bona lenigai, “Ji tere yaage langa yaage bisemu tigi-tigini. Iinga gonga fai ete mayonbona, no waha nomo danga, yame danga feiya tuwou. Onou waha boni, ji nomo su nomo maalu futu fuwei nomo fai hilou uwa. No tere Hauri Guuni langa, eeya langa yaage bisemu tigonbona. ");
INSERT INTO eri_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","No fai ete owo langa sawoli yaasudu maina dorofe maidu bona, nomo wit langa tuturumu oruwa fidedu bona nomo wit mata langa komom wonbona. Onodu nomo tuturumu waha no, eeya ada gare-garena waha langa biteruwon bona.” ");
INSERT INTO eri_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon no beele baingaro, ila fere, fai-aita bagu huwanyanege wari nagei nomo bona lenigai, onodu fanyimu waha langa, no hilou beele, fai-aita malalamudu lenigou haruwe tai. ");
INSERT INTO eri_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ariya, Jon no nebere gabman amugou Herot no nomo bemu nomo oya Herodias langa nyabuliwou ete onowai, onodu no fanyimu inyaba ila fere oruwanga onowai waha bona honggoro tuwai. ");
INSERT INTO eri_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ono wainga, Herot no nyabuliwou oruwanga onowai waha inyi gainga, no nyabuliwou ege ete turidu bona Jon dagou mata langa tafa tuwai. ");
INSERT INTO eri_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nere fai-aita bagu oruwanga yaage bisou tedu yafaganenga, Yesus no fere yaage bisou tai. No yaage bisou tedu hauya bona yafa gainga, ha laluwa helufa wainga, ");
INSERT INTO eri_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hauri Guuni no langa mai. Nere Hauri Guuni neei ete buuna dorofe, no mora langa megainga urane. Ono ganenga, ha laluwa langa bolou ete benou yauredu lewainga isane, “Ne yame Magana. Ji ne gaude hinini. Yame huwanyafe ne bona edegana.” ");
INSERT INTO eri_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus no nomo haga orei 30 onou langa no haruwe hugu warai. Nere fai-aita bagu isane, no Josep idau. Josep no Heli idau. ");
INSERT INTO eri_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli no Matat idau. Ono gainga, Matat no Livai idau. Livai no Melki idau. Melki no Janai idau. Janai no Josep idau. ");
INSERT INTO eri_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ono wainga, Josep no Matatias idau. Matatias no Amos idau. Amos no Nahum idau. Nahum no Esli idau. Ono wainga, Esli no Nagai idau. ");
INSERT INTO eri_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai no Mat idau. Mat no Matatias idau. Matatias no Semen idau. Semen no Josek idau. Ono wainga, Josek, no Joda idau. ");
INSERT INTO eri_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda no Joanan idau. Joanan no Resa idau. Resa no Serubabel idau. Serubabel no Sealtiel idau. Ono wainga, Sealtiel no Neri idau. ");
INSERT INTO eri_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri no Melki idau. Melki no Adi idau. Adi no Kosam idau. Kosam no Elmadam idau. Ono wainga, Elmadam no Er idau. ");
INSERT INTO eri_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er no Josua idau. Josua no Eliesar idau. Eliesar no Jorim idau. Jorim no Matat idau. Ono wainga, Matat no Livai idau. ");
INSERT INTO eri_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai no Simeon idau. Simeon no Juda idau. Juda no Josep idau. Josep no Jonam idau. Ono wainga, Jonam no Eliakim idau. ");
INSERT INTO eri_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim no Melea idau. Melea no Mena idau. Mena no Matata idau. Matata no Natan idau. Ono wainga, Natan no Devit idau. ");
INSERT INTO eri_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit no Jesi idau. Jesi no Obet idau. Obet no Boas idau. Boas no Salmon idau. Ono wainga, Salmon no Nason idau. ");
INSERT INTO eri_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason no Aminadap idau. Aminadap no Atmin idau. Atmin no Arni idau. Arni no Hesron idau. Hesron no Peres idau. Ono wainga, Peres no Juda idau. ");
INSERT INTO eri_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ono Juda no Jekop idau. Jekop no Aisak idau. Aisak no Abraham idau. Abraham no Tera idau. Ono wainga, Tera no Nahor idau. ");
INSERT INTO eri_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor no Seruk idau. Seruk no Reu idau. Reu no Pelek idau. Pelek no Eber idau. Ono wainga, Eber no Sela idau. ");
INSERT INTO eri_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela no Kainan idau. Kainan no Arpaksat idau. Arpaksat no Siem idau. Siem no Noa idau. Ono wainga, Noa no Lamek idau. ");
INSERT INTO eri_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek no Metusela idau. Metusela no Enok idau. Enok no Jaret idau. Jaret no Mahalalel idau. Ono wainga, Mahalalel no Kenan idau. ");
INSERT INTO eri_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan no Enos idau. Enos no Set idau. Set no Adam idau. Ono wainga, Adam no Itou idau. ");
INSERT INTO eri_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hauri Guuni Yesus bolo tuwainga, Yesus no Jordan yaage awadu bona ege gidu goyai. Ono wainga, Hauri Guuni no Yesus haudu bona, ha fai uwau langa goyai. ");
INSERT INTO eri_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ono wainga, no ha fai uwau walanga fati 40 yafa gainga, Satan no wala-wala tuwai. Saini waha langa, Yesus no da nyei uwa, waha bona no huweli tuwai. ");
INSERT INTO eri_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ono wainga Satan no letuwai, “Ne ngalenga Itou Idau wonga lewahenga megebu beha edo beret heigona.” ");
INSERT INTO eri_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ono wainga, Yesus no ege gidu benou letuwai, “Itou nomo buk langa beele benou bagu, ‘Da langanga, fai-aita bagu agenege auma yafou ada todbode.’” ");
INSERT INTO eri_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ono wainga, Satan no haudu bona, muju anyakaro ouwe langa manai, onodu fasadu onou, oula beha nomo kantri danga bagu oruwa abitimu tuwai. ");
INSERT INTO eri_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Onodu, Satan no Yesus letuwai, “Ji ne oula beha nomo kantri oruwa oofawei nomo danga hinon boni ono wehenga ne unyite gai anyakaro bagu yafau ganga. Dada oruwanga beha ji yame. Onodu ji fai ete tuwon boni wonga, ji edo tuwon boni. ");
INSERT INTO eri_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Onou waha bona, ne afene tuburu kutudu ji unyife isou bonahe wonga wa, dada beha oruwanga ne hinoni boni.” ");
INSERT INTO eri_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ono wainga, Yesus no beele ege gidu letuwai, “Itou nomo buk langa beele benou bagu, ‘Ne Itou nomo huuna la yafa bonahe, ne nomonga unyi isouwau, no name Anyakaro.’” ");
INSERT INTO eri_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ono wainga, Satan no Yesus haudu Jerusalem langa goidu bona, tempel gai ouwe la tafa tuwai. Onodu letuwai, “Ne ngalenga Itou Idau wonga wa, ne talagedu minau. ");
INSERT INTO eri_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Itou nomo buk langa beele benou lena. ‘No nomo ensel lenigonga, nere ne oofade hinodbode.’ ");
INSERT INTO eri_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Onodu ‘Ne nere owonege langa, aule hinodbode gamaji megebu ete afene waroga.’ ” ");
INSERT INTO eri_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ono wainga Yesus no ege gidu letuwai, “Itou nomo buk langa beele benou bagu, ‘Itou nomo danga adai wala-wala tuwau, name Anyakaro.’” ");
INSERT INTO eri_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ariya, Satan no wala-walawou hogo fere-fere tu borodu bona, no Yesus awa tuwai. Onodu no saini ete bona itarina. ");
INSERT INTO eri_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ariya, Hauri Guuni nomo danga langa, Yesus no ege gidu bona, Galili distrik langa manai. Ono wainga, nere fai-aita oruwa, haumu walanga yafane waha, nere Yesus Galili distrik la mayaha yafanawou isane. ");
INSERT INTO eri_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Saini oruwa, no fai-aita bagu nebere bori mata langa isisiwou nigigai. Ono gainga, fai-aita oruwanga nomo unyi isou wane. ");
INSERT INTO eri_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus no Nasaret goyai. Saini no menakele la, no taon waha langa golodu goi anyakarowai. Ariya, bori nomo fati langa, no gai-gai onogai onounga onowai. No bori mata huwanya la goidu, Itou nomo hilou beele lelegei nomo bona jaidu oto gainga, ");
INSERT INTO eri_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","nere profet Aisaia nomo buk waha tuwane. Ono wanenga, no isebudu bona, beele matau ete benou waha urai, ");
INSERT INTO eri_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anyakaro nomo hauri ji la maiha inyina, taate bona, Anyakaro no nogo we, Ji nere fai dadanege uwau waha, beele hilobainga togoi nagei nomo bona, no ji morafe langa faronga uudu bona hangada hiyai. No ji beele benou malalamudu lewei nomo huuru hiyai. Nere fai dagou mata la yafade waha, nere dagou mata awadu goyod heigode bode, nere fai agenege fosokowou waha, nere edo ege igei wodbode. Nere fai ila unyinege ilei bode inyabamu nigide waha, nebere ou uwamu nagei nomo boni huuru hiyainga meene. ");
INSERT INTO eri_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","No ji huuru hiyainga mene wa, ji beele benou malalamudu lewei nomo bona, Anyakaro no nomo fai-aita bagu hilou tafa nigei nomo saini amina heigaha.” ");
INSERT INTO eri_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Onodu, Yesus no buk kubodudu bona, fai no buk oofawei nomo haruwe bagu waha ege gidu tuwai, onodu no yafai. Ono gainga, nere fai-aita oruwanga, bori mata huwanya la yafane waha, nere agenege oruwa Yesus feele tuwane. ");
INSERT INTO eri_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ono ganenga, no benou lenigai, “Itou nomo buk beha nomo beele tere amina iseiha. Onowei waha, elebe iingabe no ngalenga tigini heigaha.” ");
INSERT INTO eri_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ono wainga, nere no unyi isou bode, no hilobainga beele malalamudu lewai waha bode ninanege baingaro isane. Onodu bode, nere lewane, “Fai beha no Josep idau waha ere isiya. Adadu bona no beele benoha waha edo lewona?” ");
INSERT INTO eri_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ono wanenga, Yesus no benou lenigai, “Onou wa, tere fai-aita bagu beele lede waha tedu, ji la malalamudu lewagu ganga, ‘Dokta, Ne nage name gete gala figiniwau.’ Onodu tere lewagu ganga, ‘Ne dada Kaperneam langa ono wene waha, nomo beele ere amina isei. Waha bona, elebe ne name matane hugu belanga dada onounga onowau.’” ");
INSERT INTO eri_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Onodu bona, Yesus no lenigai, “Ji tere ngalenga letigini, profet ete no nomo matane hugu langa, nere fai no nomo beele ada isi-iside. ");
INSERT INTO eri_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ji tere ngalenga letigini, Elaija nomo saini la, aita oyo baingaro Israel la yafane. Saini waha langa, ha taene no agao dangamude tuwai. Ono wainga, yaage uwau, inyeru inyi gainga goi haga orei eei ole 6 oruwa usuwai. Ono wainga, maau saini anyakaro ha-ha oruwa la heigai. ");
INSERT INTO eri_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ariya, Itou no Elaija huuru tuwainga Israel aita ete langa goyei uwa. No huuru tuwainga aita oyo ete Sarefat taon ulate Saidon taon anyakaro inyina wahanga la goyai. ");
INSERT INTO eri_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Onou dorofenga, profet Elisa nomo saini langa fere Israel walanga nere fai baingaro lepra taura bagu yafane. Ariya, nere gamanege langa, fai ete te taura jige tuwei uwa. Neman no kantri Siriaha, no nogonga.” ");
INSERT INTO eri_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nere fai oruwanga bori mata huwanya langa yafane waha, nere beele waha isidu bode, nere hounege danga bagu mayai. ");
INSERT INTO eri_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Onodu nere jaidu bode Yesus so tuwanenga, taon dui langa goyai. Nere nebere taon waha no muju ete ouwe langa inyina. Onodu nere no haudu bode, muju ouwe langa mani, beberi inyaba ete inyina la, tekaite tuwogunga, minona ono wane. ");
INSERT INTO eri_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ono wane wa, no awa nigidu nere gamanege langa golodu goidu heige fagawai. ");
INSERT INTO eri_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ariya, Yesus no Galili distrik nomo taon ete, Kaperneam langa minidu yafai. Onodu bona, Bori nomo fati oruwa langa, no fai-aita bagu isisiwou nigigai. ");
INSERT INTO eri_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ono gainga, fai-aita bagu nere nomo beele isidu bode, horoto wane, taate bona, no isisiwou nigigai wa, no fai unyi bagu dorofe. ");
INSERT INTO eri_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Saini ete, bori mata langa fai ete yafai, hauri inyaba no langa inyai. No inyangaaro yauredu bolou oto bona lewai, ");
INSERT INTO eri_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei, Yesus Nasaretha, ne ere adadu ono higau ganga mainaha? Ne ere inyabamu higau ganga rute mainaha? Ji ne isi hinini. Ne fai hilobainga tigini waha Itou nogo langa mainaha.” ");
INSERT INTO eri_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ono wainga, Yesus no hauri inyaba honggoro tubona letuwai, “Ne hurate fosokodu bonahe, fai waha awa tuwau.” Ono wainga hauri inyaba wa, no fai wa tekaite tuwainga, nere fai-aita bagu gamanege langa oula la meboduwai. Onodu iinga hauri inyaba no awa tubona, inyabamu tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ono wainga, fai-aita bagu oruwa horoto wane. Onodu bode, nere nage-nage benou leguru wane, “Magana, beele beha, taate beele benou? No hauri inyaba beele lenigina wa, no fai danga bagu, onodu fai unyi bagu dorofe lenigina. Ono ganga, nere nomo beele isidu bode, nere fai awa tudu bode goi-goide.” ");
INSERT INTO eri_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ono wanenga, Yesus dada onowai waha nomo aasa, distrik waha nomo haumu oruwa langa goi edowai. ");
INSERT INTO eri_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus no jaidu bori mata waha awadu bona, Saimon nomo mata huwanya goyai. Saimon nomo tangabumu aita no taura, ono bona no gogala danga bagu ngasuwai. Ono wainga, nere Yesus no hoyo tuwei nomo bona isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ono wanenga, no goidu hinemu langa oto bona, taura wa no aita waha awa tuwei nomo bona danga bagu ngira tuwai. Saini wahanga la, taura wa aita awa tuwainga, fasadu onou jaidu nebere da haiya nagai. ");
INSERT INTO eri_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hoonga minona ono gainga, nere fai nebere ilibanege gane taura hogo fere-fere bagu waha hanigedu bode Yesus bagu mayane. Ono wanenga, no nomo owo, nere fai-aita bagu waha oruwanga etenga-etenga nebere jaulanege langa tafainga, nebere taura jigi nigai. ");
INSERT INTO eri_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No hauri inyaba ono nigainga, nere fai-aita baingaro awa nigane. Saini nere awa nigidu hara bode, nere benou yaurane, “Ne Itou Idau.” Ono wanenga, no ngira nigidu bona, beele lewoguga bona karu nigai, taate bona, nere isane, fai beha no Itou hangada tuwai, no nomo fai-aita bagu ege gidu hanigei nomo bona. ");
INSERT INTO eri_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gai eringe amina, Yesus no taon waha awadu bona, no ha fai uwau ete langa goyai. Ono wainga, nere fai-aita bagu no kuru tuwane, onodu saini nere no toroba tuwane la, no adai awa nigidu goyei nomo bode karu tuwane. ");
INSERT INTO eri_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ono wanenga no benou lenigai, “Ji hilou beele Itou nomo huuna langa yafei nomo waha, taon ila langa fere malalamudu lenigon boni. Itou no ji haruwe waha onowei nomo bona, huuru hiyainga meene.” ");
INSERT INTO eri_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Onodu no hilou beele bori mata Judia distrik langa malalamudu lenigi bona golowai. ");
INSERT INTO eri_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Fati ete langa, Yesus no Genesaret yaage katiwou waha nomo laanga la otowai, ono gainga, nere fai-aita toomaro Itou nomo hilou beele isei nomo bode no hinemu la maidu kolili tudu oto wane. ");
INSERT INTO eri_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ono ganenga, no bot nga nononga yaage katiwou waha nomo laanga ulisi la huuru wane inyi gainga urai, wa hoowe elegegou fai nebere. Fai nere waha nebere bot awadu bode, nere hagoma hugou haruwe tane. ");
INSERT INTO eri_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ono ganenga, Yesus no goidu, bot ete la digai, wa Saimon nomo bot. Onodu bona, no Saimon bot digedu huuru wonga mou menenga awadu, manei nomo bona letuwai. Onodu Yesus no bot waha langa yafa bona, fai-aita bagu isisiwou nigai. ");
INSERT INTO eri_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Saini no beele lenigi borodu bona, no Saimon letuwai, “Ne bot koya wahenga gama la manonga, hoowe elegei nomo hagoma aya wahenga minona.” ");
INSERT INTO eri_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ono wainga, Saimon no ege gidu benou letuwai, “Fai Anyakaro, ere ooru la haruwe anyakaro tegeinga goi hamba waha, Ono yaha wa, ere hoowe ete tei uwa. Ariya wa edo, elebe ji ne name beele oojodu boni, hagoma aya woni boni,” tuwai. ");
INSERT INTO eri_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nere onou onodu bode hoowe baingaro elegane. Onodu hagoma korai wona onowai. ");
INSERT INTO eri_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ono wainga, nere neire ilibanere gane bot ete la yafane waha, mai hoyo nirei nomo yaure nigare. Nere mayanenga, bot nga oruwa, hoowe jiri wanenga bolowai, ono wainga bot kobo wodere onoware. ");
INSERT INTO eri_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ono wainga, Saimon Pita no waha uredu bona, no Yesus afo la waanga afo tuburu kutudu yafa bona letuwai, “Anyakaro, Ne awa hidu bonahe goyau. Ji une fai.” ");
INSERT INTO eri_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Onodu no hoowe oruwanga elegane waha uredu horotowai. ");
INSERT INTO eri_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nere Saimon nomo ilibumu gane nga, Sebedi idau gane, Jems, Jon ngare, nere fere horoto ware. Ono wanenga, Yesus no Saimon letuwai, “Ne adai umugau. Ne elebe hoowe elegou haruwe teni, iinga gonga ne fai-aita elege nigou haruwe tedu, ji la tamayau ganga.” ");
INSERT INTO eri_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Onodu nere koyadu mini horiyedu, nebere dada oruwa awarudu bode, Yesus oojo tuwane. ");
INSERT INTO eri_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saini ete la, Yesus no taon ete langa yafai, taon waha langa, fai ete no lepra taura gogala bolode tuwou yafagai. Saini waha langa, no Yesus uredu bona afo tuburu kutudu hogo oula tudu inyi bona, Yesus benou letuwai, “Anyakaro, ne gau hinonga wa, ne ji ono hiyahenga Itou ago langa eege heigoni.” ");
INSERT INTO eri_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ono wainga, Yesus no owo ayadu yaasu tubona letuwai, “Ji gau hina. Ne eege heigau.” Ono wainga, fasadu onou lepra taura fai waha awa tuwainga eege heigai. ");
INSERT INTO eri_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ono wainga, Yesus no beele danga bagu benou letuwai, “Ne fai ete dada ne langa heigaha beha adai hai fuwau. Ne goidu bonahe ne name getegala Pris abitimu tuwau. Onodu bonahe Moses lewai onou, ne getegala eege heigaha waha abitiwou, Itou eeya muru wari fuwau. Ono wahenga nere fai isodbode, ne taura jige hinahawou.” ");
INSERT INTO eri_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Onou wa, Yesus no dada oruwa onowai waha nomo beele hayou gai goingawai. Ono wainga, nere fai baingaro nomo beele isei nomo bagu, nebere taura jigemu nagei nomo bode, no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Onou wa, no saini baingaro fai-aita bagu awa nigidu, ha fai uwau langa goidu bona hauya gai. ");
INSERT INTO eri_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Fati ete langa Yesus no fai-aita bagu isisiwou nigi gainga, nere Farisi bagu, nuuni beele nomo isisi nigigou fai bagu yafane. Nere waha Galili distrik nomo matane oruwa langa Judia bagu Jerusalem taon bagu awadu mayane. Anyakaro nomo danga no Yesus langa inyi gainga no taura fai jigemu nigingawai. ");
INSERT INTO eri_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ono gainga nere fai ila, fai ete nomo ngedemu oruwa ume borowou waha, no kabali ete langa inyi gainga, auledu bode mata huwanya la togoi Yesus yafai hinemu langa tafa tuwode ono wane, ");
INSERT INTO eri_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ono wane wa, fai-aita baingaro bona haumu kitiwai. Onou bona, nere taura fai waha auledu huwanya goyei nomo jala uwa. Waha bona, nere Yesus yafai waha, mata tu ouwe langa manidu bode, mata tu ulate konu wane. Onodu bode, nere taura fai no kabali langa inyai waha, nere fai-aita bagu gamanege langa kabali bagu foinga-foinga awaya tuganenga minai. Onodu bode, nere no Yesus hogo langa tafa tuwanenga inyai. ");
INSERT INTO eri_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ono wanenga, Yesus no urai wa nere huwanyanege ngalenga dewainga, bona no lewai, “Baabo, ji name une amina uulu haninaha tuwai.” ");
INSERT INTO eri_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ono wainga, nere nuuni beele isou fai bagu, nere Farisi bagu, beele waha isidu bode, nere nage-nage beele baingaro benou leguru wane, “Fai beha no faiwei waha bona no Itou nomo haumu taha beele beha lena? Fai ete te no une uuluwei nomo edo uwa. Wa, Itou no nogonga nomo haruwe.” ");
INSERT INTO eri_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ono wanenga, Yesus no nere nebere ninanege amina isidu bona, no nere nebere beele ege gidu benou lenigai, “Tere taate boya huwanyatege langa ninatege waha bagu? ");
INSERT INTO eri_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Beele adoha waha ji lewei nomo edo? Benou lewoni waha edo rute, ‘Ji name une uulu haninaha,’ Uwa. Ji lewoni, ‘Ne jaidu bonahe golowau?’ ");
INSERT INTO eri_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Onou wa, ji tere benou isei nomo gau hina, Fai Nomo Idau no ha esene beha langa no danga bagu, onodu no une uulu nigei nomo edo.” Onodu no fai ngedemu oruwa umeru borowai waha feele tubona benou letuwai, “Ji ne lehinini, ne jaidu name kabali elegedu bonahe, name mata langa goyau.” ");
INSERT INTO eri_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ono wainga, saini wahanga la no jaidu, nere fai-aita bagu waha agenege langa no nomo kabali inyai waha elegedu bona, Itou unyi isou bona golodu nomo mata langa goyai. ");
INSERT INTO eri_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ono wainga nere fai-aita oruwa, dada waha uredu bode horoto dewane. Onodu nere Itou nomo danga anyakaro waha uredu, huwanyanege jayainga nere Itou unyi isou bode benou lewane, “Elebe ere dada hogo fere ete tigini heiganga ureyaha.” ");
INSERT INTO eri_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iinga Yesus no golodu goi bona, takis tegou fai ete nomo unyi Livai, no takis tegou mata langa yafa gainga urai. Onodu bona Yesus no letuwai, “Ne mai ji oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ono wainga no jaidu, nomo dada oruwa awaruwai oto gainga oojo tudu goyai. ");
INSERT INTO eri_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Onodu bona, Livai no Yesus nomo ajou anyakaro ete, nomo mata langa ajai. Ono wainga takis tegou fai baingaro bagu, nere fai baingaro ila fere gaara nere nga waha bagu yafa bode da nyane. ");
INSERT INTO eri_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ono ganenga, nere Farisi bagu, nere Farisi nebere nuuni beele isou fai bagu, nere Yesus nomo disaipel ngodo tai nigane. Nere lewane, “Tere taate boya nere takis tegou fai bagu, nere une tafagou fai bagu gaara da yaage bagu nyi-nyiya?” ");
INSERT INTO eri_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ono wanenga, Yesus no nere beele ege gidu benou lenigai, “Nere fai taura uwau waha, nere dokta bagu ada goi-goide. Uwa. Nere taura fai wahanga, nere dokta bagu goi-goide. ");
INSERT INTO eri_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ji nere fai tigini waha huwanyanege ubuluwei nomo bona, yaure nigei nomo mei uwa. Ji nere fai une bagu waha, huwanyanege ubuluwei nomo bona, yaure nigei nomo meene.” ");
INSERT INTO eri_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ariya fai nere Yesus benou letuwane, “Saini baingaro Jon nomo disaipel nere da urigedu bode hauya-hauyade. Nere Farisi nebere disaipel fere, nere onounga ono-onode. Ariya ne name disaipel nu nere da nyi bode, yaage nyi-nyide.” ");
INSERT INTO eri_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ono wanenga, Yesus no onou lenigai, “Onou wa, fai ete no aita tona onona waha, nomo ilibumu gane da nyei nomo karu nigagu rute, saini fai waha nogo nere bagu yafona la? Uwa. ");
INSERT INTO eri_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Onou wa iinga, saini nere fai waha haudu goyogunga, no ege ilibumu gane bagu ada yafona la, saini waha langa nere da urigodbode.” ");
INSERT INTO eri_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Onodu Yesus no muuji beele ete fere lenigai. Wa onou, “Fai ete no saket asari nomo yogode ererewei nomo bona, no saket eege nomo matau menakele ete koraidu tedu saket asari nomo jogode ada erere-ererena. No onou ono wona wa, no saket eege waha inyabamu wonbona, onodu fere, saket eege matau waha no saket asari waha dorofe uwa. ");
INSERT INTO eri_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Fai ete no meme osoko asari langa wain eege ada unyi-unyina. No onou ono bona wonga, meme osoko asari wa korai wonga, wain eege oula la feuwon bona. Ono wona wa, meme osoko fere inyaba wonbona. ");
INSERT INTO eri_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Onou waha bona, nere wain eege, meme osoko eege langa unyodbode. ");
INSERT INTO eri_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Fai no wain aminaha nyai wa, no wain eege waha ada gau-gauna. Onodu le-lena ‘Wain aminaha wa hilobainga.’” ");
INSERT INTO eri_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bori nomo fati ete langa, Yesus no nere wit haga gama langa golowai. Ono gainga, nomo disaipel nere wit nomo hilou elegedu bode, owonege langa nyunyai wanenga, osoko asainga nyane. ");
INSERT INTO eri_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Onogane, nere Farisi ila waha uredu bode lewane, “Fai nere bori nomo fati langa, fanyimu onou onowei nomo waha sesewou inyina, onou wa tere taate boya onou onoya?” ");
INSERT INTO eri_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ono wanenga, Yesus no lenigai, “Tere aasa Devit no dada onowai waha, tere lelegegu uwa rute? Ji leni be, saini no nomo ilibumu gane bagu, nere huweli nigai la, ");
INSERT INTO eri_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit no Itou nomo mata huwanya langa goidu bona, no beret Itou hogo langa tafa ganenga inyigou waha tai. Beret waha no gunni, nere Pris nagenga nyei nomo edo. Onou wa Devit no nyai, onodu bona no nomo ilibumu gane fere nigai. Tere aasa waha lelegegu uwa rute?” ");
INSERT INTO eri_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Onodu bona, Yesus no ege benou lenigai, “Fai Nomo Idau no bori nomo fati oofa na.” ");
INSERT INTO eri_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bori nomo fati ete langa, Yesus no bori mata huwanya langa goidu bona, nere fai-aita bagu beele lenigai. Ono gainga fai ete no yafai, no nomo owo hilou wa, lalekawai. ");
INSERT INTO eri_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ono gainga, nere nuuni beele isou fai bagu, nere Farisi bagu, nere Yesus oofade tuwane, taate bona, nere urodbode, no taura fai bori nomo fati langa jigemu nigona yo, uwa? Nere Yesus kot langa tafa tuwei nomo jala kuru bode ono wane. ");
INSERT INTO eri_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ono wane wa, Yesus no nebere ninanege amina isai. Onou waha bona, no fai, owo lalekawai waha letuwai, “Ne jaidu bonahe, belanga fai agenege langa otowau.” Ono wainga, no jaidu bona otowai. ");
INSERT INTO eri_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Onodu Yesus no nere onou lenigai, “Ji tere isoki tigon boni. Ere bori nomo fati langa fanyimu hilobainga edo onowoya yo, uwa, ere edo onowou inyaba onowoya? Ere nere fai hilobainga yafei nomo edo ono woya yo, uwa, ere fai inyabamu nigoya rute?” ");
INSERT INTO eri_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Onodu Yesus, no fai oruwanga feele nigi bona, no fai waha letuwai, “Ne owone tiginimu wau.” Ono wainga, fai waha no onou ono wainga, nomo owo ege hilouwai. ");
INSERT INTO eri_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ono wainga, nere nuuni beele isou fai Farisi bagu hounege danga bagu mayainga, nere nage-nage leguru wane, “Ere Yesus adadu ono tuwoya?” ");
INSERT INTO eri_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Saini waha langa, Yesus no hauya wona muju ete langa manidu bona, no ooru waha oruwa Itou hauya tugainga goi hambawai. ");
INSERT INTO eri_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Onodu hoonga mai gainga, no nomo disaipel yaure nigainga mayane. Ono wanenga, nere 12 hangada nigidu bona, unyinege Aposel warai. ");
INSERT INTO eri_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ete no unyi Saimon, no waha Yesus no unyi Pita tuwai. Onodu Andru fere hangada tuwai, no Saimon bemu, onodu Jems wainga Jon wainga Filip, Batolomyu ngare, ");
INSERT INTO eri_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","onodu Matyu wainga Tomas wainga, Jems no Alfius idau, ono wainga Saimon, fai waha no Selot nebereha ete, ");
INSERT INTO eri_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","onodu Judas, no Jems idau, ono wainga Judas Iskariot, fai no waha iinga gonga Yesus, nere honggoro fai owonege langa tafa tuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ariya saini Yesus no muju langa nomo disaipel bagu heigedu medu bode, no ha tigini ete langa, nomo disaipel toomaro gaara oto wane. Nere fai-aita toomaro Judia distrikha oruwanga, Jerusalem taonha bagu, nere laanga Tair, Saidon bagu taon jugunga la bagu, nere fere yafane. ");
INSERT INTO eri_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nere nomo beele isei nomo bagu, nebere taura jigemu nagei nomo bagu mayane. Ono wanenga, nere fai-aita bagu hauri inyaba inyabamu nigai waha, Yesus no nere ege jigemu nigai. ");
INSERT INTO eri_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ono wainga, nere fai-aita oruwanga no langa owonege tafode ono wane, taate bona, danga anyakaro no langa inyai, danga wahanga nere fai-aita oruwa no langa owonege tafa gane jige nigigai. ");
INSERT INTO eri_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Onodu bona, Yesus no nomo disaipel feele nigi bona benou lewai, “Tere fai dadatege uwau, tere dabu edega wagu. Itou nomo huuna langa yafou wa tere tebere. ");
INSERT INTO eri_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Tere fai elebe huweli yafaya waha, tere dabu edega wagu. Iinga gonga, tere da nyadenga ogotege digonbona. “Tere fai elebe mere boya yafaya waha, tere dabu edega wagu. Iinga gonga, tere nanai wagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Iinga gonga, fai tere Fai Nomo Idau oojo tugadenga, terige bode, huwanyanege inyaba dewodbode. Onodu bode, nere tere so tigi bode, beele inyaba letigodbode, nere tere unyitege dada gai inyaba dorofe urodbode. Saini nere dada waha oruwa heigo-gunga, tere dabu edega wagu. ");
INSERT INTO eri_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nere tere onou ono tigei mata wogunga, tere dabu edega bonade huwanyatege hilobainga dewona. Tere isagu. Tere tebere agou anyakaro ha laluwa langa itari tigina. Amina, nere nebere asanege gane nere profet onowou benou langa ono nigigane. ");
INSERT INTO eri_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Onou wa, tere fai moni bagu, tere ure dewagu. Tere huwanyatege hilobainga inyei nomo dada teyeha. ");
INSERT INTO eri_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Tere fai, elebe da nyigeinga ogotege digena waha tere ure dewagu. Iinga gonga tere huweli tigonbona. “Tere fai elebe nanaiya waha tere ure dewagu. Iinga gonga, tere mere gadenga agiyotege orososo wonbona. ");
INSERT INTO eri_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Onou wa, nere fai oruwanga tere unyitege isouwei mata wogunga, tere ure dewagu. Amina nere nebere asanege gane nere yaawa profet unyinege isou gane.” ");
INSERT INTO eri_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesus no ege onou lewai, “Ji tere fai yame beele isiya waha letigini, tere tebere honggoro fai gau nigi bonade, nere fai tere bode huwanyanege inyabade waha, tere onowou hilobainga ono nigagu. ");
INSERT INTO eri_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Onou wa, nere fai ila Itou tere inyabamu tigei nomo lebode wonga wa, tere Itou nere hilobainga ono nigei nomo isoki tuwagu. Ono bonade, tere Itou no fai inyabamu tigide waha aau warei nomo bona hauya tuwagu. ");
INSERT INTO eri_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Fai ete no ulagete barewei mata wonga, ne ulagete ulate fere awa fuwau. Fai ete no name saket tona ono wonga wa, ne name siot fere awa fuwau. ");
INSERT INTO eri_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Fai oruwa dada nigei nomo bode isoki hinei mata wogunga, ne nigau. Onodu, fai ete no name dada ete tei mata wonga, ne ege gidu hinei nomo beele danga bagu adai letuwau. ");
INSERT INTO eri_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Fanyimu oruwa nere fai tere langa onowei nomo gau tigina waha, tere fere fanyimu wahanga, nere langa ono wagu.” ");
INSERT INTO eri_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ariya, tere fai gau tigide wahanga, gau nigei mata wagu wa, faiwei isona tere fai-aita hilobainga? Nere une tafagou fai fere, nere fai gau nigide wahanga, gau nigi-nigide. ");
INSERT INTO eri_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ariya, tere nere fai fanyimu hilobainga ono tigi-tigide wahanga, fanyimu hilobainga ono nigagu wa, ariya fawei no isona, tere fai-aita bagu hilobainga? Nere une tafagou fai fere nere fanyimu wahanga ono-onode. ");
INSERT INTO eri_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ariya tere fai dada agou ege gidu edo langa tigodbode idu nigagu wa, fawei no isona tere fai-aita hilobainga? Nere une tafagou fai fere agou ege gidu nigei nomo bode, nere une tafagou fai ila nigi-nigide, wa taate bona, nere iside, nere waha nebere agou ege gidu warodbode. ");
INSERT INTO eri_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Onou waha bona, tere tebere honggoro fai gau nigi bonade, hilobainga tafa nigagu. Tere dada nere fai nigidu bonade, ege agou tigei nomo bonade ninatege adai isagu. Tere onou ono wagu wa, iinga huunta la tere agou gai anyakaro bagu, onodu tere Itou Gai Ouwe la nomo magana yafaguga. No fai hilobainga ada tutude waha bagu, nere fai inyaba fere hilou tafa nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Onou waha bona, tere fai bonade aau tarigou, tebere ametege ono-onona onounga ono wagu.” ");
INSERT INTO eri_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus no ege onou lewai, “Tere fai nebere onowou adai haawe nagi bonade lewagu, nere fai inyaba. Gamaji Itou no fere onounga ono tigoga. Tere fai nebere une uulu nagagu, ono wadenga, Itou no tere tebere une uulu tagonbona. ");
INSERT INTO eri_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tere fai ila dada nigagu, ono wadenga, Itou no tere dada tigonbona. No gai hilobainga haawe tagi bona, no jiri dedu, ilei wonga mini gonga, no inyangaro jiri wonga dada feu wona ono gonga, tere tigonbona. Haawe tere fai ila nigiya waha Itou no agou ege onounga gidu tigonbona.” ");
INSERT INTO eri_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus no muuji beele ete fere benou lenigai, “Fai ago inyaba ete, no fai ago inyaba ilibumu ete jala abitimu tuwei nomo edo rute? Uwa. Nere ngadunga mebodudu, u-u gamu minodbodere. ");
INSERT INTO eri_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sukul magana no, no nomo isisiwou fai feiya tuwou uwa. Saini no sukul urededu usumu wona la, ariya, no nomo isisiwou fai dorofe heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ne taate boni ilibane nomo ago magana la, tuturumu menakele mene waha ure funi. Ariya, ne nage name agene magana langa, nauge majigau anyakaro inyina waha boni ne ninate isei uwa ru? ");
INSERT INTO eri_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Onou wa, ne nage name agene magana langa, nauge majigau anyakaro inyi ganga urei uwa waha, adadu name baabo letuwau ganga, ‘Baabo, name agene magana langa tuturumu menakele mene inyina waha tekaite hanon boni?’ Ne yaawagou fai, ngasunga ne nage name agene magana langa nauge majigau anyakaro inyina waha tekaitedu bonahe. Onodu, iinga ne igeidu bonahe, baine nomo ago magana langa tuturumu menakele mene inyina waha tekaite fuwau. ");
INSERT INTO eri_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus, no ege onou lenigai, “Nauge hilobainga waha no hilou inyaba ada heige-heigena. Onounga, nauge inyaba no hilou hilobainga ada heige-heigena. ");
INSERT INTO eri_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nere fai ngasunga nauge nomo hilou uredu bode, nere isi-iside, be nauge hilobainga yo, inyaba. Nere fai fik nauge nomo fatu elegei nomo maalu kudina bagu langa ada goi-goide. Onodu, nere fai wain nomo fatu nauge inyaba kudina bagu langa ada elege-elegede. ");
INSERT INTO eri_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Fai hilobainga waha, no ninau hilobainga baingaro no huwanya langa inyina. Onou waha bona, no fanyimu hilobainga ono-onona. Fai inyaba no ninau inyaba baingaro no huwanya langa inyina. Onou waha bona, no fanyimu inyaba ono-onona. Ninage onouha huwanyage langa bolodu inyina waha, hurage no heigemu-heigemuna.” ");
INSERT INTO eri_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesus no nere ege onou lenigai, “Tere taate boya ji lehihiya, ‘Anyakaro, Anyakaro,’ Onodu tere yame beele ada oojo-oojoya? ");
INSERT INTO eri_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Fai ete no ji bagu maidu, yame beele isidu bona, no oojo wona wa, ji fai onouha nomo fanyimu bona edo letigon boni. ");
INSERT INTO eri_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Fai waha no fai ete mata tafona onona dorofe. Ariya, no amugedu u-u konu wonga minonga, no simen tafonga mini megebu aroro oula gamu langa inyide waha fadade tuwonbona. Onodu, iinga no mata waha ouwe langa otomu wonbona. Ono wonga, iinga gonga yaage kuwei medu bona mata waha nuu tuwona wa, no ada ilili wona, taate bona, fai waha no mata hilobainga danga bagu tawai. ");
INSERT INTO eri_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Onou wa, fai no yame beele isidu bona ada oojona waha, no fai ete mata oula ewe langa tauna dorofe. No amugedu simen oula gamu langa tafei uwa. Iinga, yaage kuwei mata waha me nuu tuwona wa, no fasadu ililidu mebodudu, inyaba dewonbona.” ");
INSERT INTO eri_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus no nere fai-aita bagu beele malalamudu lenigi borodu bona, no goi Kaperneam taon huwanya langa goyai. ");
INSERT INTO eri_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wa langa Rom nebere oota fai 100 nebere kepten ete yafai, no nomo haruwe magana ete bagu. No haruwe magana waha gaude tugai, saini waha langa haruwe magana waha no taura tuwainga umona juguwai. ");
INSERT INTO eri_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ono wainga, kepten no Yesus yafana waha beele isidu bona, no Juda mora bagu ila nere goi no letuwogunga maidu bona, nomo haruwe magana jigemu tuwei nomo huuru nigainga goyane. ");
INSERT INTO eri_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ono wainga, nere goi Yesus bagu heigedu bode, nere beele danga bagu le tuwane, “No fai hilobainga, onou waha bona ne no hoyo tuwei nomo edo. ");
INSERT INTO eri_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","No ere Juda gau higi-higina. No nogo we, ere ebere bori mata tau hagai.” ");
INSERT INTO eri_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ono wanenga, Yesus no nere bagu gaara goyai. No goidu mata jugu gainga, kepten no ilibumu gane ila huuru nigainga, beele Yesus bagu benou tedu mayane, “Anyakaro, ono urona, ne haruwe danga bagu teni. Ne yame mata langa mayei nomo ji fai hilou uwa. ");
INSERT INTO eri_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Onou waha bona ji isini, yage mai neriyei nomo ji fai hilou uwa. Waha bona ne ewe beelenga lewahenga, yame haruwe magana nomo taura jige tuwona. ");
INSERT INTO eri_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ji onou leni, taate bona, ji fere fai no unyi bagu oofa hina waha nomo huuna langa yafani. Onodu ji yage fere nere oota fai yame huuna langa yafade. Ariya ji ete letuwon boni, ‘Ne goyau,’ ono genenga no goi-goina. Onodu ji ete letuwon boni, ‘Ne mayau,’ ono genenga no mai-maina. Onodu ji yame haruwe magana letuwon boni, ‘Ne haruwe beha onowau,’ ono genenga no ono-onona.” ");
INSERT INTO eri_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ono wainga, Yesus no beele waha isidu bona, no fai waha nomo beele bona horotowai. Onodu bona, no ubuludu nere fai-aita toomaro no oojo tuwane waha benou lenigai, “Ji tere letigini, ji Israel nage langa fai ete huwanya ngalengawou benouha ete urei uwa.” ");
INSERT INTO eri_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ono wainga, kepten no fai huuru nigainga goyane waha, nere ege gidu mata langa mayane. Nere maidu haruwe magana wa nomo taura jige tuwainga urane. ");
INSERT INTO eri_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iinga menanga onou, Yesus no taon ete unyi Nain, waha langa manai. No nomo disaipel bagu, nere fai-aita bagu toomaro no ngate gaara manane. ");
INSERT INTO eri_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","No manidu bona, orei taon waha kalili tuwou nomo jauli arasae anyakaro jugu gainga, nere fai ila fai umou ete auledu malala mayane. Magana umai waha nomo anya no magana etenga wahanga. Ariya, aita waha nomo au fere umai. Nere taon waha nomo fai-aita toomaro, nere aita oyo waha ngate golo bode mayane. ");
INSERT INTO eri_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ono ganenga, Anyakaro no aita oyo waha uredu bona, no aau danga bagu warainga, aita oyo waha letuwai, “Ne adai merau.” ");
INSERT INTO eri_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Onodu bona, no goi kabali fai umou inyai waha jugudu bona, owo kabali waha la tafai. Ono wainga, nere fai kabali aulane waha, waanga oto wane. Ono ganenga, Yesus no magana giila umai waha letuwai, “Ji lehinini ne jayau.” ");
INSERT INTO eri_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ono wainga, magana giila umai waha, no ege ago morowai, onodu jaidu yafa bona beele hayou hugu warai. Ono wainga, Yesus no magana giila waha ege gidu nomo anya tuwai. ");
INSERT INTO eri_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ono wainga nere fai-aita oruwanga Itou nomo danga waha uredu bode, huwanyanege jayainga Itou unyi isou wane. Nere unyi isou bode lewane, “Profet anyakaro ete elebe amina ere gamagege la heigaha.” Ono bode lewane, “Itou no nomo fai-aita hoyo nigei nomo bona amina mayaha.” ");
INSERT INTO eri_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Onodu bode, nere fai-aita bagu Judia distrik nomo haumu oruwanga la, haumu ila kejiwe langa golodu goi bode nere Yesus dada onowai waha aasa hai nagi bode golo wane. ");
INSERT INTO eri_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon nomo disaipel nere dada oruwanga Yesus no onowai waha hai fuwane ");
INSERT INTO eri_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ono wainga Jon no nomo disaipel nga yaure niridu bona, no nere Anyakaro benou isoki tuwei nomo bodere huuru nirai, “Ne fai beha Itou no huuru hinonga maau ganga beele baara tawai yo, uwa ere fai ete ru itari tuwoboya?” ");
INSERT INTO eri_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Fai nga waha nere mai Yesus bagu heigedu bodere letuware, “Jon yaage bisemu nigigou fai, no ere ne isoki hinei nomo bona huuru hiraha, ‘Ne fai beha Itou no huuru hinonga maau ganga beele baara tawai yo uwa, ere fai ete ru itari tuwoboya?’” ");
INSERT INTO eri_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Saini waha langa, Yesus no fai-aita bagu baingaro taura hogo fere-fere bagu jigemu nigai. Ono bona hauri inyaba baingaro nere langa inyai waha so nigai. Nere agenege magana fosokowou baingaro ono nigainga igei wane. ");
INSERT INTO eri_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Onodu bona, Yesus no Jon nomo disaipel nga neire beele gidu benou lenirai, “Tere goidu bonadere, dada oruwanga elebe ureyare, isiyare waha Jon letuwaru. Nere fai agenege fosokowou, ege igeide nere fai afenege inyaba ege golode. Nere lepra fai nebere genege gala hilobainga heigaha, ono ganga nere fai agenege kuli fosokowou nere beele iside. Nere fai umou ege jaide, ono ganenga nere fai dadanege uwau nere hilou beele iside. ");
INSERT INTO eri_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nere fai ji yeriyedu nebere huwanyanege ngalengawou ada meboduna waha, nere dabu edega wode.” ");
INSERT INTO eri_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Saini fai nga nere Jon nomo beele tedu goi hara garenga, Yesus no fai-aita bagu Jon bona benou lenigai. “Saini tere amina ha fai uwau langa goyeye waha, tere taate uragu ganga goyei? Tere baraku jagui fugainga waha uragu ganga goyei yo? Uwa. ");
INSERT INTO eri_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tere taate uragu ganga goyei? Tere fai ete kolos hilobainga tanai waha uragu ganga rute goyei? Uwa. Nere fai kolos hilobainga bagu, genege gala nomo dada hilobainga bagu onouha waha, nere king nebere mata langa yafa-yafade. ");
INSERT INTO eri_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Onou wa, tere taate uragu ganga goyei? Tere goi profet ete ureye yo? Onounga ji letigini, tere goidu profet ete ureye. Ariya no waha, nere profet oruwa feiya nigou. ");
INSERT INTO eri_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Fai no wahanga bona, Itou nomo buk no benou lena, ‘Isagu. Ji fai ete huuru tuwehenga, no yame beele malalamudu lewei nomo bona, amuge hinidu goyonbona. No name jala haiya hanonbona.’ ");
INSERT INTO eri_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ariya, Yesus no ege turidu lewai, Ji letigini, Jon no fai oula langa yafade waha feiya nigou. Onou wa, fai no Itou nomo huuna langa gai menakele yafana waha no Jon feiya tuwou.” ");
INSERT INTO eri_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ono wainga nere fai-aita bagu, takis tegou fai bagu nere beele waha isidu bode lewane, “Itou nomo fanyimu wa ngalenga tigini.” Nere onou lewane wa taate bode, nere Jon owo langa yaage bisou taneha. ");
INSERT INTO eri_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ariya nere Farisi bagu, nuuni beele isou fai bagu, nere Jon owo langa yaage bisou teguwa. Onou waha bode, nere Itou no jala hilobainga abiti nigai waha moge tuwane. ");
INSERT INTO eri_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ono wanenga Yesus no lewai, “Ji nere fai-aita bagu saini beha nomo waha, nebere onowou malalamudu lewei nomo wonga, ji agotete beele adadu lenigoni? Nere fai adoha? ");
INSERT INTO eri_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nere magana mene-mene dorofe, komowou haumu langa yafa bode, magana mene-mene ila yauredu lenigide dorofe, ‘Tere moone uyei nomo bona ere boreya buya, ariya tere moone uyei nomo awaya. Ere aau tarigou moone teya, onoya wa tere merei nomo awaya.’” ");
INSERT INTO eri_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yesus no ege benou lewai, “Jon Yaage Bisemu Nigigou fai no maidu bona beret wain bagu nyei uwa. Ono wainga tere leweye, ‘Hauri inyaba no langa inyina.’ ");
INSERT INTO eri_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ariya elebe Fai Nomo Idau no mayaha, da nyi bona yaage nyi ganga tere le-leya, ‘Uragu, no da baingaro nyi bona wain baingaro nyigou fai. No takis tegou fai bagu une fai bagu nebere ilibanege.’ ");
INSERT INTO eri_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tere onou le-leya, ariya fai-aita bagu nere Itou nomo isou tede waha benou abitimu higide, nomo isou wa no dada tigini.” ");
INSERT INTO eri_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi fai ete no Yesus ngare da nyei nomo bona letuwai. Ono wainga, Yesus no Farisi fai waha nomo mata la goidu bona da nyai. ");
INSERT INTO eri_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ariya, taon waha la une hogo fere-fere tafagou aita ete yafagai. Aita waha Yesus no Farisi waha nomo mata la da nyinawou isai, onodu aita waha megebu kuluma sanda agiya hilobainga ete tedu bona, Farisi fai waha nomo mata la mayai. ");
INSERT INTO eri_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Onodu no goidu, Yesus mogo afo hugu la oto bona mere gainga, agiyomu minidu Yesus afo yokomu gainga, no nomo tawa gala waha la fiidu karamu fungawai. Aita waha no Yesus nomo afo uumba baingaro fubona sanda waha tedu bona, Yesus afo kiyo fuwai. ");
INSERT INTO eri_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ono gainga, Farisi fai no Yesus letuwainga nomo mata la mayai waha, no dada waha uredu ninau benou isai, “Fai beha no tigini profet wage wa, no aita owo tafadu yaasu tuna waha, nomo fanyimu bona fere isi tuwage. Aita beha no une tafagou aita.” ");
INSERT INTO eri_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus no fai waha nomo ninau isidu benou letuwai, “Saimon, Ji beele ete bagu ne lehinon boni.” Ono wainga Saimon no letuwai, “Isisi higigou fai, ne name beele malalamudu lewau.” ");
INSERT INTO eri_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ono wainga Yesus no lewai, “Fai nga nononga, nere fai ete la agou bagu. Fai ete no wan handret kina tai, fai ete no ten kinanga tai. ");
INSERT INTO eri_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ono ware wa, nere neire agou fai waha ege tuwei nomo edo uwa, onou waha bona fai wa no neire agou waha uwamu narai. Ariya ne isini, nere nga waha neireha ete faiwei no gau anyakaro tuwona?” ");
INSERT INTO eri_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ono wainga, Saimon no ege gidu bona benou letuwai, “Ji isini wa, fai no nomo agou anyakaro awa fuwai.” Ono wainga, Yesus no letuwai, “Name ninate wa tigini.” ");
INSERT INTO eri_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Onodu Yesus no ege ubuludu bona, aita waha igei tubona Saimon letuwa, “Ne aita beha ureni yo? Ji name mata huwanya la mainanga, ne yaage ete afefe hugei nomo hiyei uwa. Ariya, aita beha no nomo agiyomu la afefe huge hayaha. Onodu bona, no nomo tawa gala la afefe karamu hayaha. ");
INSERT INTO eri_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Saini ji name mata la mainaha waha, ne ji uumba hiyei uwa. Saini ji name mata huwanya maidu yafa genenga mai elebe langa aita no beha ji afefe uumba hainga waha. ");
INSERT INTO eri_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne morafe sanda bisemuwei uwa. Ariya aita beha no yame afefe la sanda kiyo hayaha. ");
INSERT INTO eri_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Onou waha boni ji lehinini, aita beha no ji gaude higanga ere urehaya, ere isiya, Itou no nomo une baingaro uulu fuwaha. Onou wa fai no une menekele tafanga Itou no uulu fuwaha. Ariya nomo gauwou menekele menenga.” ");
INSERT INTO eri_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Onodu bona Yesus no aita waha letuwai, “Ji name une uulu hani boronaha.” ");
INSERT INTO eri_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ono wainga, nere fai no ngate tewol la yafane waha, nere nage-nage benou leguruwou hugu warane, “Fai beha no faiwei bona no une uuluna?” ");
INSERT INTO eri_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ariya, Yesus no aita waha letuwai, “Name huwanyate ngalengawou waha we, elebe ne Itou bagu hilou yafani. Ne goidu bonahe huwanyate foinga inyou.” ");
INSERT INTO eri_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iinga menanga onou, Yesus no taon langa, nere matane langa bagu golo bona Itou nomo huuna langa yafou waha nomo hilou beele malalamudu nere fai-aita bagu lenigai. Nere disaipel 12, no gaara golodu goyane. ");
INSERT INTO eri_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ono gainga, nere aita ila Yesus no amina hauri inyaba so nagi bona nebere taura jigemu nagai waha, nere fere no ngate gaara golodu goyane. Ete wa Maria, nere no letutude, Maria taon Makdalaha. No waha amina Yesus no langa hauri inyaba 7 so nigai. ");
INSERT INTO eri_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ono gainga Joana Susana ngare, ono gainga nere aita baingaro ila fere, nere no ngate goyane. Joana no Kusa woya, no Herot nomo mata oofagou fai ete. Nere aita waha, Yesus nomo disaipel bagu nebere dada langa hoyo nigi gane. ");
INSERT INTO eri_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nere fai-aita taon oruwaha Yesus bagu mayane, nere fai-aita toomaro mai komo wanenga, no muuji beele ete beha lenigai. ");
INSERT INTO eri_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Fai ete no haga la maidu bona, wit fatu ayaru bona golowai. Saini no wit fatu waha ayaru bona goi gainga, wit fatu ila fai jala gologou la orososo wane. Ono wanenga, nere fai jala golo bode ilelu ganenga, neei maidu elegedu bode nyane. ");
INSERT INTO eri_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ariya wit fatu ila oula ulate megebu bagu la orososo wane. Onodu hui fudu wane, ariya oula waha no yaage uwau, onou waha bona, fasadu onou kakaregedu umeru wane. ");
INSERT INTO eri_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ariya, wit fatu ila maalu kudina bagu waha huwanya la orososo wane. Ono wanenga, maalu kudina bagu waha arotenga fududu maidu, maalu kudina bagu waha we jaidu bona wit kutauwai. ");
INSERT INTO eri_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ariya, wit fatu ila oula hilobainga la orososo wane, onodu hui fududu bode nere hilou baingaro wan handret, wan handret onou heigeru wane.” Yesus no muuji beele beha lenigi borodu bona, benou yauredu lenigai, “Fai no agokuli bagu wonga, no beele beha isona.” ");
INSERT INTO eri_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus nomo disaipel nere Yesus no muuji beele lenigai waha nomo hugu bode isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ono wanenga no lenigai, “Itou no nomo huuna la yafou nomo huwari beele inyina waha, tere awa tigainga nomo hugu amina isi boroweye. Ariya, nere fai-aita bagu ila nere ewe muuji beele wahanga iside. Onou waha bode, nere saini baingaro igei wode wa, nere dada ete te ada urode. Nere beele saini baingaro isodbode, ono wode wa, nere nomo hugu bode ada isode.” ");
INSERT INTO eri_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Muuji beele waha nomo hugu benou. Wit fatu waha no Itou nomo beele. ");
INSERT INTO eri_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ariya wit fatu ila jala la orososo wane waha benou, nere fai-aita bagu Itou nomo beele iside, ariya iinga wala-wala higigou fai Satan no maidu bona beele nebere huwanyanege langa inyina waha elegedu ayaruna. Satan no isina, ‘Gamaji nere Itou bode huwanyanege ngalenga wogunga, Itou no nere ege gidu hanigoga bona.’ ");
INSERT INTO eri_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ariya wit fatu ila oula megebu bagu la orososo wane waha, nere fai beele isidu, tedu bode edega wane. Wa nere wit fatu nomo bou oula gamu langa minei uwa dorofe, onou waha bona, nere nebere huwanyanege ngalengawou saini tutu menakele, onodu wala-walawou saini langa, nere kurutudu Itou awa tutude. ");
INSERT INTO eri_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ariya wit fatu ila maalu kudina bagu gama la orososo wane waha, nere fai Itou nomo beele isidu bode goidu dada nere langa heigena waha ninanege baingaro isi bode, moni dada bona bagu, ha esene beha nomo dada edegawei nomo waha kutau nigi ganga, Itou nomo beele tigini ada oojode. Nere da muumu dewei uwa dorofe. ");
INSERT INTO eri_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ariya, wit fatu oula hilobainga la orososo wane waha, nere fai beele isidu bode, nere beele waha gai yaasudu yafade dorofe. Nere huwanyanege tigini onodu hilobainga, nere danga bagu yafa bode, da hilou heigemu-heigemude.” ");
INSERT INTO eri_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ariya, Yesus no ege onou lewai, “Nere fai lama dugedu bode tauwe dada langa ada kutau-kutaude, kabali huuna langa ada tafa-tafade. Uwa. Nere tewol ouwe langa tafa ganenga, fai mata huwanya mai bode lala waha urobode. ");
INSERT INTO eri_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dada oruwanga huwari inyina waha, iinga gonga malala heigodbode. Onodu, dada oruwanga nere fai kutau wane inyina waha, iinga gonga nere malala heigodbode, ono wogonga fai nere isi nigodbode. ");
INSERT INTO eri_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tere urede bonade, beele isi dewagu ganga. Fai ete no dada ila bagu wonga wa, Itou no ege ila tuwonbona. Onou wa, fai ete no dada uwau wonga wa, Itou no isina, dada no yaasuna waha ngau elegonbona.” ");
INSERT INTO eri_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ariya saini waha langa, Yesus anya nomo bemu gane bagu, nere no urode mayane. Ono wane wa, nere fai-aita toomaro komo wanenga, anya bemu gane bagu nere no hinemu langa mayei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ono wanenga, nere fai ila Yesus letuwane, “Name ayane, baine gane bagu malala langa otode, nere ne neriyodbode.” ");
INSERT INTO eri_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ono wane wa, no nebere beele ege gidu benou lenigai, “Nere fai-aita bagu Itou nomo beele isidu bode oojode waha, nere yame ngai yame baife gane.” ");
INSERT INTO eri_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Fati ete langa Yesus no bot ete langa nomo disaipel bagu digane. Onodu no benou lenigai, “Ere yaage katiwou ulate langa goyoya.” Ono wainga nere goyane. ");
INSERT INTO eri_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bot no guriyedu goi gainga, Yesus no agore inyai. Ono gainga, jagui anyakaro ete yaage katiwou langa heigai, onodu yaage mai bot langa bolo wona ono gainga, nere yaae wode jugu wane. ");
INSERT INTO eri_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ono wainga, nere goi Yesus aimu tudu bode letuwane, “Fai anyakaro, Fai anyakaro, ere yaae woboya onoya.” Ono wanenga, no jaidu bona jagui bagu, hiiri anyakaro otowai waha bagu ngira nirai. Ono wainga, jagui bagu, hiiri anyakaro otowai waha bagu folo wainga, yaage ege goi manini heledu inyai. ");
INSERT INTO eri_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ono wainga, no benou isoki nigai, “Adadu? Tere tebere huwanyatege ngalengawou alanga inyina?” Ono wainga, nere haruwe anyakaro waha uredu umuge bode, ninanege baingaro isane. Ono bode, nere nage-nage benou leguruwane, “Fai beha no faiwei tigini? No jagui, hiiri ngare, beele danga bagu leniranga, nere ngadu nomo bolou oojo ware.” ");
INSERT INTO eri_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ariya Yesus nomo disaipel bagu goi Gerasa nebere langa heigane. Matane waha no Galili yaage katiwou ulate langa inyina. ");
INSERT INTO eri_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus no bot awadu laanga la heige gainga, taon wahaha fai ete no hauri inyaba bagu mai toroba tuwai. No saini ufaronga-ufaro ogola ada tagugai. No mata ete langa ada yafagai. No haumu matmat langa kejiwe yafagai. ");
INSERT INTO eri_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Fai waha no Yesus uredu ui bona Yesus afo hugu waanga, oula langa meboduwai. Onodu bona no inyangaaro uidu yaure bona lewai, “Yesus ne Itou Gai Ouwe la nomo Idau ne ji adadu ono hiyau ganga? Plis ne ji kejiwe adai ono hiyau.” ");
INSERT INTO eri_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","No onou yaurai wa taate bona, Yesus no hauri inyaba fai waha awa tuwei nomo bona amina letuwaiha. Fai nere no gai-gai oofa tubode, sen langa hankap langa dage tugane. Ono gane wa, no sen dada oruwa kakatiri gai. Onodu hauri inyaba waha no ono tugainga ha fai uwau langa goigai. ");
INSERT INTO eri_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ariya, Yesus no isoki tuwai, “Ne unyite faiwei?” Ono wainga no letuwai, “Ji unyife, Oota fai,” taate bona, hauri inyaba baingaro no huwanya langa goyane. ");
INSERT INTO eri_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ono wane wa, nere hauri inyaba waha inyangaaro yauredu, Yesus benou letuwane, “Ne ere so higahenga u-u anyakaro hugu uwau waha langa adai minoya.” ");
INSERT INTO eri_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Buuwa toomaro nere muju menakele jugunga la da nyi bode oto wane. Ono gane hauri inyaba nere danga bagu yauredu Yesus benou isoki tuwane, “Ne ere awa higahenga, nere buuwa woha huwanyanege langa goyoya.” Ono wanenga, Yesus no nere awa nigainga goyane. ");
INSERT INTO eri_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ono wainga, nere hauri inyaba waha fai wa awa tudu bode, nere buuwa huwanyanege langa goyane. Ono wanenga, nere buuwa toomaro waha danga bagu gurarudu bode ha inyaba ete langa minane. Onodu bode nere yaage katiwou langa taumerudu, yaage nyidu umeru waneha. ");
INSERT INTO eri_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ono wainga, buuwa oofagou fai nere dada waha heigainga uredu bode, nere heige harawane, beele waha taon langa ha fere-fere langa hai nagane. ");
INSERT INTO eri_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ono wanenga, nere fai-aita bagu taate dada tigini heigaha waha urei nomo mayane. Nere Yesus bagu heigedu bode, fai hauri inyaba awa tudu harawane waha urane. No ogola tagudu, ninau fo tuwainga, Yesus afo hugu langa yafai. Ono gainga, nere fai-aita bagu waha uredu bode umugane. ");
INSERT INTO eri_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Fai nere Yesus no fai waha langa taate dada heigemu wainga urane waha nere ila hai nagane, amina hauri inyaba fai waha langa yafane, ariya iinga la no hilou heigai. ");
INSERT INTO eri_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ariya, Gerasa distrikha fai-aita bagu oruwanga, nere Yesus no haruwe danga bagu tai waha bode ninanege isidu umuge dewane, onodu nere Yesus awa nigidu goyei nomo beele danga bagu letuwane. Ono wanenga, Yesus no bot digedu ege gidu goyai. ");
INSERT INTO eri_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ariya fai no ngasunga hauri inyaba awa tuwane waha no Yesus danga bagu benou isoki tuwai, “Ji ne ngare edo gaara goyo yare yo?” Ono wainga, Yesus no ege huuru tuwai gigainga benou letuwai, ");
INSERT INTO eri_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ne ege gidu name matane goidu bonahe, dada oruwanga Itou no ne hoyo hinei nomo onowai waha, fai-aita bagu oruwa malalamudu lenigau.” Ono wainga fai waha goidu bona, dada oruwanga Yesus no hoyo tuwei nomo onowai waha, nomo taon langa fai-aita bagu oruwanga beele waha malalamudu lenigai. ");
INSERT INTO eri_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ariya, Yesus no ege gidu yaage katiwou ulate langa goyainga, nere fai-aita bagu oruwanga no mayai waha bode edega wane, taate bona, nere oruwanga no itari tudu yafane. ");
INSERT INTO eri_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ono ganenga fai ete mai heigai, nomo unyi Jairus, no bori mata nomo mora bagu ete. No Yesus afo hugu langa afo tuburu kutudu bona Yesus no nomo mata langa goyei nomo bona danga bagu isoki tuwai. ");
INSERT INTO eri_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ariya, no magana etenga wahanga, magana waha no aita magana, nomo haga orei 12 onou. Waha no umona juguwai. Ono wainga, Yesus no golodu goigainga, nere fai-aita bagu toomaro gaara goi bode no kiti-kiti tuwane. ");
INSERT INTO eri_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ono ganenga aita ete yafai, no ole taura gai teenga bona haga orei 12 onou yafai. Fai ete te no nomo taura waha jigemu fuwei nomo uwau. ");
INSERT INTO eri_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Onodu aita waha no Yesus mogo la mai jugu tudu bona, owo ayadu Yesus nomo kolos ufaro mutu yaasu fuwai. No onou ono wainga, no nomo ganemu fasadu kara etengawai, onodu ege mei uwa. ");
INSERT INTO eri_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ono wainga Yesus no isokiwai, “Faiwei owo ji langa tafaha?” Ono wainga, nere oruwanga kakiri bode lewane, “Ji uwa, Ji uwa.” Ono wanenga, Pita no lewai, “Fai anyakaro, nere fai-aita toomaro ne kolili hinane oto bode kitimude hinide.” ");
INSERT INTO eri_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ono wanenga Yesus no lewai, “Ete no ji langa owo tafaha. Ono wanga, ji danga ila awa hidu goi ganga isinaha.” ");
INSERT INTO eri_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ono wainga, aita no isai, no huwari tuwei nomo edo uwa. Waha bona no terere bona mai Yesus hinemu langa afo tuburu kutudu, du koudu oula feelewai. Onodu bona, no fai-aita bagu oruwanga agenege langa no taate bona owo Yesus langa tafai waha bona lewai. Onodu no lewai, “Ji yame taura usu etenga waha.” ");
INSERT INTO eri_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ono wainga Yesus no letuwai, “Magana, ne ji boni huwanyate ngalenga waha, onou waha bona ne ege hilou heigenaha. Ne huwanyate edo foinga inyi gonga goyau.” ");
INSERT INTO eri_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus no beele lebona oto gainga, bori mata nomo mora bagu nomo mataha fai ete mayai. No maidu bona mora bagu letuwai, “Name magana amina umaha. Isisi higigou fai ou adai tuwau.” ");
INSERT INTO eri_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ono wainga, Yesus no beele waha isidu bona, beele ege gidu mora bagu benou letuwai, “Ne adai umugau. Ne huwanyate wahanga ngalenga wonga ne name magana no hilou wonbona.” ");
INSERT INTO eri_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Onodu bona, Yesus no mora bagu nomo mata langa goyai, nere fai-aita awa nigainga no ngate mata huwanya goyegu uwa. No Pita wainga, Jon wainga, Jems wainga, aita magana waha umamu anya ngare, nere wahanga hanigainga no ngate goyane. ");
INSERT INTO eri_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ariya nere fai-aita oruwa amugedu mata waha langa yafane wa, nere magana waha bode augami nigi gainga, nere mere bode yafane. Ono gane Yesus no lenigai, “Tere adai meragu. No umei uwa. No ewe agorenga inyina.” ");
INSERT INTO eri_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ono wainga, nere no inyangaaro nanai tuwane. Nere alai, magana wa no umaiha. ");
INSERT INTO eri_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ono wainga Yesus no aita magana waha owo yaasu bona, benou yauredu letuwai, “Magana, ne jayau.” ");
INSERT INTO eri_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ono wainga, aita magana waha nomo anu gidu mayainga, no fasadu onou jayai. Ono wainga, Yesus no nere magana aita waha da ila tuwei nomo bona lenigai. ");
INSERT INTO eri_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ono wainga, magana aita waha nomo umamu anya ngare horoto ware. Ono warenga no beele danga bagu benou lenirai, “Tere fai ete te dada heigaha beha bonadere adai letuwaru.” ");
INSERT INTO eri_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus no aposel 12 yaure nigainga mayanenga, hauri inyaba oruwa fai-aita bagu la yafane waha so nigi bode fai-aita taura hogo fere-fere bagu waha jigemu nigei nomo danga anyakaro unyinege bagu nigai. ");
INSERT INTO eri_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Onodu bona no Itou nomo huuna langa yafou waha nomo beele malalamudu lewei nomo, nere taura fai taura jigemu nigei nomo bona bagu huuru nigainga goyane. ");
INSERT INTO eri_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Onodu bona no benou lenigaiha, “Tere golowei nomo dada adai elegagu. Tere golowei nomo dumuga yo, olodo yo, beret yo, moni yo, adai elegagu. Onodu, tere siot nga bagu adai elegagu. ");
INSERT INTO eri_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tere matane ete la heigedu bonade, mata ete huwanya goyei mata bonade wonga, waha langa yafa gadenga, goi saini tere matane waha awagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ariya, tere taon ete nomo fai-aita bagu hatigedu bode nebere mata langa goyegu uwa wonga, wa tere taon waha awa tudu goyei nomo ono bonade, tere tebere afetege langa amuji inyina waha utu wagu. Ono wadenga nere nebere fanyinege inyaba ono wane waha bode isodbode.” ");
INSERT INTO eri_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ono wainga disaipel nere golodu, matane oruwa langa goyane. Ono bode nere ha oruwa langa hilou beele malalamudu lebode, taura fai taura jigemu nigane. ");
INSERT INTO eri_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gabman amugou Herot no dada oruwa Yesus onowai waha bona beele isidu ninau baingaro isai, taate bona, nere fai ila legane, “Jon no ege matmat langa jayaha.” ");
INSERT INTO eri_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ono gane nere ila legane, “Elaija heigaha.” Ono gane ila lewane, “Profet aminaha, nebereha ete no ege gidu jayaha.” ");
INSERT INTO eri_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ono wanenga Herot no lewai, “Ji Jon bou karuweneha. Ono wene wa, fai waha no faiwei tigini waha bona fai nere no haruwe fere-fere onona waha legane isini?” Onodu bona, no Yesus urona onowai. ");
INSERT INTO eri_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nere aposel ege gidu maidu bode dada oruwanga ono wane waha Yesus letuwane. Ono wanenga no hanigedu bona nere fai-aita bagu awa nigidu, nere nagenga taon ete nomo unyi Betsaida goyane. ");
INSERT INTO eri_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ono wanenga, iinga gainga saini fai-aita toomaro nere waha isidu bode, no oojo tudu goyane. Nere no bagu goyanenga, no nere goyane waha bona edegawai. No beele Itou nomo huuna langa yafou waha malalamudu lenigi bona, fai-aita bagu nebere taura jigemu nagai. ");
INSERT INTO eri_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gai esuwa, disaipel 12 nere no bagu maidu bode benou letuwane, “Ne fai‑aita bagu huuru nigahenga, matane langa, haumu fere-fere langa edo goidu jiri bode, nebere da kuru wode. Haumu ere yafaya beha fai uwau.” ");
INSERT INTO eri_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ono wane wa, Yesus no nomo disaipel lenigai, “Tere tage we nere da nigadenga nyodbode.” Ono wainga nere letuwane, “Ere da bainga uwa. Beret 5, hoowe nga nononga wahanga inyina. Ne ere, fai-aita toomaro beha oruwanga, nebere da goi ejiya nagei nomo rute gau hinina?” ");
INSERT INTO eri_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nere fai 5,000 onou yafade. Ono wanenga, Yesus no nomo disaipel lenigai, “Tere fai 50, 50 onou, fere-fere komomu nigidu lenigadenga yafode.” ");
INSERT INTO eri_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ono wainga nomo disaipel nere onou onodu bode, nere fai-aita bagu oruwanga leniganenga yafane. ");
INSERT INTO eri_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ono wanenga Yesus no beret 5, hoowe nga nononga waha bagu elegedu bona ha laluwa feele tubona, Itou hilobainga tudu bona kokorudu disaipel nigainga, nere fai-aita bagu wese nagane. ");
INSERT INTO eri_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ono wanenga nere oruwa nyanenga ogonege digai. Ono wainga da matau-matau gai inyainga, nere kekele 12 jiri wane. ");
INSERT INTO eri_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Fati ete la Yesus no nogonga hauya gainga, nomo disaipel nere no ngate yafane. Onodu no benou isoki nigai, “Nere fai-aita bagu ji bode faiwei tigini ide?” ");
INSERT INTO eri_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ono wainga nere benou gidu letuwane, “Nere ila lelede, ne Jon Yaage Bisemu Nigigou Fai. Nere ila lelede, ne Elaija. Ono ganenga nere ila lede, ‘Profet aminaha nebereha ete ege gidu jayaha.’ ” ");
INSERT INTO eri_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ono wanenga no isoki nigai, “Ariya, tere tage ji boya faiwei iya?” Ono wainga Pita no letuwai, “Ne fai waha Itou no huuru tuwonga medu nomo fai-aita bagu ege gidu hanigei nomo hangada tuwai waha.” ");
INSERT INTO eri_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ono wainga Yesus no nomo disaipel no faiwei waha fai ete adai letuwei nomo karu nigou beele danga bagu lenigai. ");
INSERT INTO eri_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Onodu bona no lenigai, “Fai Nomo Idau no jimiri baingaro tonbona. Nere mora aroro bagu, nuuni beele isou fai bagu, nere pris aroro bagu, no moge tubode, dukote wogunga umonbona. No umedu bona, fati eei la ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Onodu no disaipel oruwanga benou lenigai, “Fai ete no ji oojo hiyonbona wonga, no nogo nomo gauwou oruwanga awadu bona, no nomo nauge abalakawou fati oruwa auledu bona, oojo hiyonbona. ");
INSERT INTO eri_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ariya, fai ete no nogo nomo ago auma yafou waha yaasuwei mata bona wonga, wa no yaae wonbona. Onou wa, fai no ji bona ninau isidu, nomo ago auma yafou awa bona wonga, wa no nomo ago auma yafou waha hilobainga yafonbona. ");
INSERT INTO eri_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ariya, fai ete no oula nomo dada oruwanga elegedu, no nogo inyabadu yaae waha wonga, ariya dada waha oruwanga adadu hoyo tuwonbona? ");
INSERT INTO eri_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Onounga, fai ete no ji bona mayau tugonga, yame beele bona mayau tuwona wa, ariya iinga Fai Nomo Idau no nogo nomo lala anyakaro langa, umamu nomo lala anyakaro langa, Itou nomo ensel nebere lala langa yafa gonga mona wa, no fere fai waha bona mayau tuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ji tere ngalenga letigini, fai ila otoya beha, umeru wegu wa langa Itou nomo huuna la yafou waha mayonga uragu ganga.” ");
INSERT INTO eri_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus no beele lewai waha nomo fati 8 onou goyainga, no Pita wainga, Jon wainga, Jems wainga, hanigedu muju ouwe langa hauya wona manai. ");
INSERT INTO eri_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","No hauya bona yafa gainga, no nomo hogo ferete heigai, no nomo kolos gai kaamba, lala dorofe heigai. ");
INSERT INTO eri_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ono gainga, fai nga nononga no bagu beele hayare, wa Moses Elaija ngare. ");
INSERT INTO eri_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nere Itou nomo lalawou bagu heigedu bodere, Yesus no Jerusalem langa dada onodu bona, iinga no oula beha awadu manonbona waha bodere leware. ");
INSERT INTO eri_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita no ilibumu gane nga nononga waha bagu nere agore nigainga jiri wane. Ariya saini nere ege jayane la, nere lala Yesus fai nga nononga bagu oto wane la heigainga urane. ");
INSERT INTO eri_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Onodu saini fai nga waha Yesus awa tudu goyodere ono garenga, Pita no Yesus benou letuwai, “Isisi higou fai, ere belanga yafoya wa hilobainga. Ere youyou eei nononga tafoboya, ete name, ete Moses nomo, ete Elaija nomo.” Pita no beele lewai wa, no nogo beele waha fo tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita no beele waha legainga, agao ete medu nere kutau nigi gainga, nere waha uredu bode umugane. ");
INSERT INTO eri_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ono gainga, beele ete agao waha huwanya langa benou heigainga isane, “Beha waha yame Magana. No yame haruwe tei nomo bona ji no hangada tuweneha. Tere nomo beele isagu.” ");
INSERT INTO eri_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Saini beele lewai waha usu gainga, nere Yesus no nogonga oto gainga urane. Onodu nere muju la ege gidu medu, Yesus nomo disaipel nere dada urane waha fai ete te hai fuwegu uwa. ");
INSERT INTO eri_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Inyiba ete langa Yesus no nomo disaipel bagu nere mujuha heigedu meganenga, fai-aita toomaro maidu bode Yesus jala gama la toroba tuwane. ");
INSERT INTO eri_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Onodu fai ete nere gamanege langa benou yaurai, “Fai anyakaro, ji ne danga bagu isoki hinini, ne yame idafe edo ure hayau, ji yame idafe etenga wahanga. ");
INSERT INTO eri_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Saini baingaro hauri inyaba ete no bagu goi ganga, fasadu onou inyangaro uidu terere ganga, mulugu kaamba hurau langa heige-heigena. Ono bona nomo gogala inyabamude fubona fasadu ada awa tutuna. ");
INSERT INTO eri_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ji ne name disaipel nere hauri inyaba waha so tuwei nomo danga bagu lenigene. Ono wene wa, nere edo uwa.” ");
INSERT INTO eri_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ono wainga Yesus no beele ege gidu benou lewai, “Tere fai-aita bagu, tere huwanyatege ngalengawei uwa, tere tebere ninatege fanyitege bagu gai tigini uwa. Saini agonyi ji tere bagu yafa boni tebere ou aulenga woni? Name idate haudu mayau.” ");
INSERT INTO eri_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ono wainga saini magana wa golodu Yesus hinemu langa mai gainga, hauri inyaba no tekaite tuwainga mebodudu danga bagu tererewai. Ono wainga, Yesus no hauri inyaba wa nyira tudu, magana waha jigemu tudu bona haudu ege umamu tuwai. ");
INSERT INTO eri_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ono wainga, nere fai-aita oruwanga Itou nomo danga anyakaro waha uredu bode horoto dewane. Fai-aita bagu ninanege baingaro, Yesus no dada oruwanga onowai waha bode isi ganenega, Yesus no nomo disaipel lenigai, ");
INSERT INTO eri_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tere beele beha bonade, agetege kuli tafa dewagu. Nere Fai Nomo Idau fai owonege langa tafa tuwodbode.” ");
INSERT INTO eri_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ariya nomo disaipel nere beele waha nomo hugu isegu uwa. Beele waha nomo hugu no huwari inyai, waha bode nere fo de nigei uwa. Onodu nere isoki tuwei nomo bode umugane. ");
INSERT INTO eri_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Onodu saini ete langa, disaipel nere faiwei no nebere amugou, waha bode beele langa wara wane. ");
INSERT INTO eri_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ariya Yesus no nebere isou huwanyanege langa inyina waha no alai. Onou waha bona, no magana menakele mene haudu tamai hinemu langa otomu tuwainga otowai. ");
INSERT INTO eri_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ono bona no nomo disaipel benou lenigai, “Fai no ji bona isidu, magana menakele beha hoyo tuna wa, no ji hoyo hina. Onodu fai no ji hoyo hina wa, no jijei ji huuru hiyainga mene waha hoyo tuna. Fai no unyi uwau, no tere oruwa gamatege langa fai menakele, wa no amugou.” ");
INSERT INTO eri_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon no Yesus nomo beele isidu ege gidu benou lewai, “Fai anyakaro, ere fai ete ne unyite langa hauri inyaba so nigi ganga ureyaha. Onou wa, no ere oojo higei uwa. Onou waha bona, ere no karu tuyaha.” ");
INSERT INTO eri_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ono wainga Yesus no letuwai, “Tere no adai karu tuwagu. Fai no tere tebere honggoro fai uwa waha, no tere tebere ilibatege.” ");
INSERT INTO eri_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Itou no Yesus ege haudu ha laluwa langa manei nomo saini amina mai juguwai. Onou waha bona Yesus no Jerusalem goyei nomo bona ninau danga bagu isai. ");
INSERT INTO eri_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Onodu bona, no fai ila nomo dada haiyawei nomo bona amugedu huuru nigainga Samaria nebere matane ete langa goyane. ");
INSERT INTO eri_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ariya, nere matane fai walaha nere Yesus haudu nebere mata langa goyei nomo awane, taate bona no Jerusalem goyona bona waha nere isane. ");
INSERT INTO eri_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ono wanenga, nomo disaipel nga Jems Jon ngare, nere Samaria nebere fanyinege waha uredu bodere, Yesus isoki tuware, “Anyakaro, ne ere ha laluwa la, eeya yaure tuwederega medu, nere fai beha oruwanga usigeru nigei nomo gau hinina yo?” ");
INSERT INTO eri_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ono warenga, Yesus no ubuludu bona nyira nirai. ");
INSERT INTO eri_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Onodu bode, nere matane ete langa golodu goyane. ");
INSERT INTO eri_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesus no nomo disaipel gane bagu jala la golodu goi ganenga, fai ete no benou letuwai, “Matane oruwa la ne goyau wa, ji oojo hinonboni.” ");
INSERT INTO eri_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ono wainga Yesus no benou letuwai, “Nere gauna kui, oula la nere nebere u-u bagu, nere neei nebere toomu bagu, ariya Fai Nomo Idau no inyei nomo haumu uwau.” ");
INSERT INTO eri_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Onodu bona no fai ete letuwai, “Ne maidu bonahe ji oojo hiyau.” Ono wainga fai wa letuwai, “Oo Anyakaro, ne ngasunga ji awa hiyahenga goi yame jijei u-u tanidu.” ");
INSERT INTO eri_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ono wainga Yesus no letuwai buyona. “Nere fai umeru wane waha edo, nebere gane nage u-u tani guru wode. Ariya, ne goidu bonahe Itou nomo huuna la yafei nomo waha beele malalamudu lewau.” ");
INSERT INTO eri_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ono gainga fai ete Yesus letuwai, “Anyakaro, ji ne oojo hinonboni.” “Ariya ngasunga ne edo ji awa hiyahenga goidu boni, ji yame ilibafe gane walaee, nigoni yo?” ");
INSERT INTO eri_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ono wainga Yesus no benou letuwai, “Fai uluma yaasuna, ariya no gai-gai ubuludu mogo la igeina, onou wa no Itou nomo huuna la yafei nomo haruwe waha tei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iinga Anyakaro no ege fai 72 hangada nigidu bona, nere nga-ngadu huuru nigainga no amuge tudu goyane. No huuru nigainga, taon oruwa, matane oruwa langa, iinga no nogo goyonbona waha langa goyane. ");
INSERT INTO eri_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Onodu bona no lenigai, “Haga langa da gai baingaro muumu borowaha, elegei nomo haruwe fai bainga uwa. Onou waha bona tere haga Morou hauya tuwagu. Ono wadenga, no haruwe fai huuru nigonga goi nomo da komomu fuwodbode. ");
INSERT INTO eri_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Tere goyagu. Isagu. Ji tere sipsip magana dorofe huuru tigi genenga, gauna kui gamanege la goiya. ");
INSERT INTO eri_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tere moni fausi bagu yo, olodo yo, su yo, adai aulagu. Tere fai-aita bagu jala la toroba nigi bonade, adai kaiye nigagu. ");
INSERT INTO eri_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tere mata ete langa goyei mata bonade wonga wa, tere amugedu benou lewagu, ‘Nere mata beha nomo fai-aita bagu nebere huwanyanege edo foinga inyou.’ ");
INSERT INTO eri_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ono wadenga, fai ete no huwanya foinga inyina waha no mata waha langa yafei mata wonga wa, ariya tebere beele hilou waha, fai no waha langa inyonbona. Onou wa, fai ete onouha uwau wonga wa, tebere beele waha ege gidu tere tage bagu mayonbona. ");
INSERT INTO eri_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tere mata etenga wahanga la yafagu. Ono bonade tere da yaage bagu dada nere tigide waha nyagu, taate bona, fai no haruwe te-tena waha nomo agou no edola tonbona. Onou waha bona tere mata fere-fere la adai goyagu. ");
INSERT INTO eri_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Tere taon ete huwanya la goyadenga, nere hatigedu nebere mata langa goidu da wese tagode waha elegagu. ");
INSERT INTO eri_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tere taon waha langa taura fai taura jigemu nagagu. Ono bonade beele benou malalamudu lenigagu, ‘Itou nomo huuna langa yafou amina mai jugu tigaha.’ ");
INSERT INTO eri_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Onou wa, tere taon ete huwanya langa goyadenga nere hatigedu nebere mata langa goyegu uwa wonga wa, ariya tere goidu bonade taon waha nomo jala langa oto bonade lewagu, ");
INSERT INTO eri_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tebere taon beha nomo amuji afege langa fada waha wa ere utu boya benou abitimu tigiya, tere fanyimu onou langa onoyaha wa nyabuluwou. Onou bona tere isi dewagu. Itou nomo huuna langa yafou wa amina mai jugu waha.’ ");
INSERT INTO eri_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ji tere letigini, Itou no fai-aita bagu kot langa tafa nigei nomo fati hangadawai langa, ou taon beha nomo fai-aita bagu la heigona wa, no ou Sodom taonha fai-aita bagu la heigai wa feiya tuwou.” ");
INSERT INTO eri_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus no ege onou lewai, “Agetege gami bagu, tere Korasin taonha fai-aita bagu. Tere Betsaida, agetege gami bagu. Fai ete no goidu dodokawou ji tere gamatege langa tafene onou, Tair taon langa, Saidon taon la tafou wage wa, nere nebere une bona aau togo nagagenga, nere edola huwanyanege ubulu wagenga, augami kolos elege jiridu eeya amuji langa yafage. ");
INSERT INTO eri_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Onou wa, Itou no fai-aita bagu kot langa tafa nigei nomo fati hangadawai langa, ou tere langa heigona waha, ou nere Tair taon langa, Saidon taon langa heigai waha feiyade nigou. ");
INSERT INTO eri_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Onodu tere Kaperneam, tere isou tigogonga ha laluwa la manoya iiya yo? Uwanga, uwa. Tere gai esene la, umou fai nebere haumu la minagu ganga.” ");
INSERT INTO eri_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Onodu bona Yesus no nomo disaipel benou lenigai, “Fai no tere tebere beele isina waha, no yame beele isina. Ariya, fai no tere moge tigina waha, no ji moge hina. Fai no ji moge hina waha, no Itou moge tuna, no ji huuru hiyainga mene.” ");
INSERT INTO eri_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Iinga nere fai 72 Yesus huuru nigai waha, ege gidu maidu bode edega dewane. Onodu lewane, “Anyakaro, ere ne unyite la beele legeyenga, hauri inyaba fere ebere beele oojo waneha.” ");
INSERT INTO eri_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ono wanenga Yesus no lenigai, “Ji Satan ha laluwa awa tudu mebodu ganga biyai fililaiwou dorofe bolou ganga ure naha. ");
INSERT INTO eri_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tere isagu. Ji tere danga amina tigene, tere edo langa maangi bagu, aure malagu bagu fai inyabamu nigei nomo waha ilelu nigi bonade tebere honggoro fai Satan, nomo danga oruwa feiya waguga. Dada ete ada inyabamu tigona. ");
INSERT INTO eri_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ariya, tere edega bonade benou adai lewagu, ‘Nere hauri inyaba ebere beele oojo wane.’ Uwa, Itou no tebere unyitege ha laluwa nomo buk la yerege tagai waha bonade edega wagu.” ");
INSERT INTO eri_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Saini waha langa, Hauri Guuni no Yesus huwanya ono fuwainga edega wainga Yesus no benou lewai, “Jijei, ne ha laluwa bagu oula bagu nomo Anyakaro, ji ne hilobainga hinini, taate bona, ne dada beha nere fai isou bagu ninanege hilou bagu waha huwarimu nigidu fai magana mene-mene yafade dorofe wahanga abitimu nigene. Yo Jijei ne nage name gauwou wahanga oojodu ono wene.” ");
INSERT INTO eri_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Onodu Yesus no ege benou lewai, “Yame Jijei no amina dada oruwanga ji owofe langa tafai. Onodu fai ete te no Idau bona ada isina, Umamu no nogonga isina. Onodu fai ete te no Umamu bona ada isina. Idau nogonga isina onodu idau nogo we, nomo Umamu fai abitimu nigai, nere wahanga Umamu bode iside.” ");
INSERT INTO eri_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nere disaipel nagenga Yesus ngate yafa bode, no ubuludu feele nigi bona lenigai, “Nere fai dada tere ure-ureya waha urede wa, nere dabu edega wode. ");
INSERT INTO eri_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ji tere letigini, amina nere profet baingaro, king baingaro, nere dada elebe tere ureya beha urei nomo ono wane wa, nere uregu uwa. Onodu nere beele elebe tere isiya beha isei nomo ono wane wa, nere isegu uwa.” ");
INSERT INTO eri_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ariya, nuuni beele isou fai ete no jaidu bona Yesus wala‑wala tu urei nomo bona isoki tuwai. “Isisi higigou fai, ji adadu onodu boni agefe auma gai-gai yafou waha toni?” ");
INSERT INTO eri_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ono wainga Yesus no isoki tuwai, “Taate beele no nuuni beele langa inyina? Ne adadu lelege naha?” ");
INSERT INTO eri_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ono wainga, nuuni beele isou fai no ege gidu benou letuwai, “‘Tere Itou ebere Anyakaro gau tuwagu. Tebere huwanyatege langa, anutege langa, dangatege langa, ninatege oruwa langa no gaude tuwagu. Onodu, ne nage boni gau hinina onounga, ilibane gane bonahe gaude nigau.’ ” ");
INSERT INTO eri_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ono wainga Yesus no letuwai, “Ariya. Ne beele ege gidu tigini lenaha. Ne onou onodu bonahe agene auma yafou tau ganga.” ");
INSERT INTO eri_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ariya nuuni beele isou fai no Yesus fai waha isou hilou uwau adai tuwoga bona, no Yesus benou isoki tuwai, “Saini nuuni beele no yame illibafe bona lena waha, wa faiwei bona tigini lena?” ");
INSERT INTO eri_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ono wainga, Yesus no beele ege gidu benou letuwai, “Fai ete no Jerusalem awadu bona golodu Jeriko taon minai. Ono gainga nere yebu fai ila jala la huwaridu nomo dada oruwa ngau elegane, onodu no waridu inyabamude tuwane. Nere onou onodu bode, nere golodu goyane. Ono ganenga fai waha no jala langa inyai, no umona juguwai. ");
INSERT INTO eri_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ono gainga, saini wahanga la Pris ete no jala waha oojodu golodu minai. No minidu bona fai waha uredu jala gisa langa feiya tudu golodu minai. ");
INSERT INTO eri_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ono gainga Liwai ete fere haumu wahanga la mai heigai, onodu no fai waha uredu bona, no fere jala gisa langa feiya tudu golodu minai. ");
INSERT INTO eri_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ono gainga Samariaha fai ete no jala golodu medu fai waha langa heigai. No fai waha uredu, no bona aau danga bagu warai. ");
INSERT INTO eri_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ono wainga no hinomu langa goidu bona, faronga wain bagu nomo ju langa ugana fudu bona, dage fuwai. Onodu bona, no fai waha isou tudu bona nogo nomo donki jaula langa tafa tuwai yafa gainga haudu pasindia jirigou mata ete langa togoyai, onodu no oofade tuwai. ");
INSERT INTO eri_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ariya, inyiba ete langa no jirigou mata waha morou, moni silwa nga tuwai. Onodu bona letuwai, ‘Ne fai beha oofade tuwau. Ono bonahe, ne name moni ila ege no langa awa bonahe wonga, saini ji ege gidu mayoni la, agou ege hinonboni.’” ");
INSERT INTO eri_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Onodu Yesus no nuuni beele isou fai isoki tuwai, “Ne adadu isini? Nere fai eei waha gama langa, faiwei no nere yebu fai owonege langa inyaba tai waha, no gaude tuwai?” ");
INSERT INTO eri_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ono wainga, nuuni beele isou fai no lewai, “Fai no augami tuwainga hoyo tuwai waha.” Ono wainga Yesus no letuwai, “Ne goidu bonahe, fanyimu onounga onowau.” ");
INSERT INTO eri_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus no nomo disaipel bagu golodu goi bode, Yesus no matane ete huwanya langa goyai. Aita ete no matane wahaha, nomo unyi Marta, no Yesus haudu bona nomo mata langa goyai. ");
INSERT INTO eri_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta no bemu ete bagu, nomo unyi Maria. Maria no mai Anyakaro Yesus afo hugu langa yafa bona nomo beele aaguwai. ");
INSERT INTO eri_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ono gainga Marta no da dada haiya bona haruwe anyakaro te bona, ninau baingaro isai. Onou waha bona, Marta no Yesus bagu goidu letuwai, “Anyakaro, ji yame baabo no ji awa hiyaha, ji yagenga nyei nomo dada haiyani. Ne waha boni ninate isei uwa yo? Ne letuwahenga maidu hoyo hiyona.” ");
INSERT INTO eri_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ono wainga Anyakaro no beele ege gidu benou letuwai, “Marta, Marta, ne ninate baingaro isi boni, dada baingaro boni aosoni. ");
INSERT INTO eri_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ne dada etenga bonahenga ninate isau. Dada beha Maria tona onona waha, no dada hilobainga tigini, onou waha bona, no dada hilobainga tona onona waha, ere adai karu tuwoya.” ");
INSERT INTO eri_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesus no haumu ete langa hauya bona yafai. No hauya boro wainga nomo disaipel ete letuwai, “Anyakaro, ne ere hauyawei nomo isisiwou higau, amina Jon no nomo disaipel isisiwou nigai dorofe.” ");
INSERT INTO eri_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ono wainga Yesus no lenigai, “Saini tere hauya bonade, tere edo benou lewagu, ‘Jijei ne name unyite edo guuni inyou. Ne name huuna langa yafou, mayou. ");
INSERT INTO eri_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Onodu, fati oruwa ne do fati beha nomo da higau. ");
INSERT INTO eri_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Onodu ne edo ebere une uulu hagau, taate bona, nere ila une langa tafa higide waha, ere uulu nagi-nagiya. Onodu, ne wala-walawou awa nigahenga ere la adai heigogu.’” ");
INSERT INTO eri_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Onodu bona, Yesus no ege onou lenigai, “Tere gamatege langa tebereha ete no ilibumu ete bagu, no ooru gama langa goidu bona benou letuwona, ‘Baabo, ne beret eei hiyei nomo gau hina. ");
INSERT INTO eri_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ji yame ilibafe ete no jala la golo bona mai yame mata la heigaha. Ji no da tuwei nomo uwau.’ ");
INSERT INTO eri_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ono wonga fai mata jauli huwanya la yafana wa no beele ege gidu benou le wonbona, ‘Ne ji haruwe adai hiyau. Mata jauli amina sesemunaha. Ji yame magana gane bagu ere amina jiriya. Onou waha boni, ji jaidu ne dada hinei nomo edo uwa.’ ");
INSERT INTO eri_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ji tere le tigini, mata morou waha no jaidu nomo ilibumu dada bona tutu tuna waha tuwonbona. Ngalenga, no ilibafe hoyo tuni wou isi bona, benou ada ono wona. No hogonyi tuwonbona, ariya no ilibumu yaurenga wonga isidu no dada tuwona bona. ");
INSERT INTO eri_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Onou waha boni ji tere letigini, tere hauya bonade Itou dada tigei nomo isoki tuwadenga, no tere tigonbona. Tere dada kuru bonade wonga, tere uragu ganga. Tere jauli kato-kato wadenga, Itou no tere helufa tagonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nere fai oruwa Itou hauya tude waha, nere dada elege-elegede. Fai no dada kuruna waha, no toroba-torobana. Onodu, fai no jauli kato-kato wona waha, Itou no jauli helufa fuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ariya, tebereha ete nomo idau, no umamu hoowe bona isoki tuwonga, Umamu no maangi inyaba ete tedu tuwona yo? Uwa. ");
INSERT INTO eri_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oo, no teewe atu bona lewonga, no aure malagu ete tedu tuwona yo? Waha fere uwa. ");
INSERT INTO eri_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tere amenege gane, tere une baingaro tafa-tafaya, onoya wa, tere tebere magana dada hilobainga nigei nomo tere isideya. Onou waha bona, tere tigini onou isagu, Ametege ha laluwa langa yafana waha fai nere isoki tubode wonga, no Hauri Guuni nigei nomo edega wonbona.” ");
INSERT INTO eri_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesus no hauri inyaba fai ete la inyi bona, fai wa hurau fosokomu fuwai waha so tuwai. Ono wainga, hauri inyaba waha fai wa awa tudu heige faga gainga, fai hurau fosokowai waha no beele hayai. Ono wainga, nere fai-aita waha uredu bode horoto wane. ");
INSERT INTO eri_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Onodu fai ila lewane, “No hauri inyaba nebere mora bagu Belsebul, nomo danga langa hauri inyaba so nigi-nigina.” ");
INSERT INTO eri_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ono gainga nere fai ila Yesus wala-wala tuwei nomo bode, no dodokawou ete nani dorofe tafonga urei nomo isoki tuwane. Ono wonga nere waha uredu isodbode, no ngalenga Itou nomo haruwe tena. ");
INSERT INTO eri_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ono wanenga Yesus no nere nebere ninanege amina isai. Onodu bona no lenigai, “Nere fai kantri etengaha, foure ngadu wara wodere wa, ariya kantri waha no inyaba wonbona. Onounga, nere fai hugu etenga wahanga, nere gama la foure ngadu nere nage-nage wara wode wa, ariya nere bemu-bemu waha nebere yafou inyaba wonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ariya Satan no nomo gane, nere foure ngadu wara wode wa, no danga adoha waha langa dada oofa nigona? Onodu tere leya, ji Belsebul nomo danga langa hauri inyaba so nigini. ");
INSERT INTO eri_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Onou wa ngalenga, Belsebul no ji hoyo higanga, hauri inyaba so nigou wage, ariya faiwei no tebere gane hoyo nigi ganga, hauri inyaba so nigi-nigide? Onou waha bona, tebere gane nere nage we abitimu tigodbode, tebere beele waha no ngalenga uwa. ");
INSERT INTO eri_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ariya Itou no nogo we ji danga higanga hauri inyaba so nigini wonga, tere edo isagu, Itou nomo huuna langa yafou waha no tere langa amina mayaiha.” ");
INSERT INTO eri_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Onodu Yesus no lenigai, “Fai danga bagu ete no nomo oota kesebu dada yaasudu bona, no nomo mata oofa dewona wa, no nomo dada oruwa hilobainga inyonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ariya, fai ete no gai danga bagu, no maidu bona fai waha ngare waradu feiya tuwona wa, no nomo ganya dada, oota kesebu dada, fai wa danga tugai waha oruwa ngau elegonbona. Onodu no nomo dada orouwa nere fai ila wese nagonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Fai no yame ilibafe uwa waha, no yame honggoro fai. Ariya, fai no ji hoyo hidu fai-aita komomu nigei uwa waha, no nere so nigi ganga heige hara-harade.” ");
INSERT INTO eri_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus no ege onou lenigai, “Saini hauri inyaba no fai ete awa tudu fagana wa, no ha kara langa goidu bona houwe tafona bona haumu kuru-kuruna. Saini no haumu hilou ete te ada ure bona wonga, no lewonbona, ‘Ji ege gidu boni yame mata amina yafene waha la goyonboni.’ ");
INSERT INTO eri_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","No goidu bona mata no amina yafai waha urona wa, nere abiya kunudu kaitedu bode, mujarimu wogunga inyi gonga uronbona. ");
INSERT INTO eri_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Onou waha bona, no goidu bona ege hauri inyaba 7, nere fanyimu inyaba onowei nomo no feiyade tuwou. Nere waha goidu bode, mata waha huwanya langa yafodbode. Aminanga fai waha no inyaba yafai, ariya elebe no gai inyaba dewonbona.” ");
INSERT INTO eri_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus no saini fai-aita bagu toomaro yafa ganenga beele malalamudu lewai. Ono wainga aita ete nere gama la yafai waha benou yauredu lewai, “Aita ne bisi hinidu bona, eeme aare hinai waha no edo edega wona.” ");
INSERT INTO eri_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ono wainga Yesus no benou lewai, “Hilobainga, ere benou lewei nomo, fai nere Itou nomo beele isidu oojode waha, edo edega wode.” ");
INSERT INTO eri_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nere fai-aita bagu baingaro Yesus bagu mainga ganenga, no benou lenigai, “Nere fai-aita bagu elebe saini beha nomo wa, nere fai-aita inyaba. Nere ji Itou nomo haruwe teni waha abitimuwou dorofe dodokawou yo, naani ete yo tafehenga urodbode yaurede. Ariya, nere naani ete ada urodbode. Uwa. Nere naani etenga profet Jona nomo wahanga urodbode. ");
INSERT INTO eri_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Amina Itou no Jona naani dorofe nere Ninive taonha fai-aita bagu urei nomo abitimu nigai. Onou dorofenga, Itou no Fai Nomo Idau naani dorofe nere fai-aita bagu elebe saini beha nomo waha abitimu nigonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Itou no fai-aita bagu kot la tafa nigei nomo fati hangadawai la, saut ulateha kuin no kot la oto bona, nere fai-aita bagu saini elebe beha nomo waha nebere onowou inyaba malalamudu lewonbona. Wa taate bona, kuin waha no oula gai gisa mutu langa yafagai, no Solomon nomo isou hilobainga waha malalamudu legonga, isona bonadu mayai. Ariya fai ete no tere gamatege langa yafana wa, no Solomon tigini feiyade tuwou. ");
INSERT INTO eri_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Saini Itou no fai-aita bagu kot langa tafa nigona la, nere Ninive fai-aita bagu kot langa oto bode, nere saini elebe beha nomo fai-aita bagu nebere onowou inyaba waha malalamudu lewodbode. Wa taate bode, Ninive nere Jona beele lewainga isidu huwanyanege ubuluwai. Onou wa, fai ete elebe belanga yafana waha no Jona tigini feiyade tuwou.” ");
INSERT INTO eri_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus no ege onou lewai, “Nere fai lama dugedu bode kabali yogode mata huuna langa ada tafa-tafade, o baket huwanya langa ada tafa-tafade. Uwa. Nere lama tewol ouwe langa tafagane, nere fai mata huwanya mai bode, nere lama waha nomo lala ure-urede. ");
INSERT INTO eri_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Name agene wa, name gete gala nomo lama dorofe. Name agene hilobainga wonga wa, name gete galala oruwa edo wonbona. Ariya, ne name agene inyaba wonga wa, ne name gete gala oruwa agugu wonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Onou waha bona, ne oofa dewau. Gamaji lala ne huwanyate langa inyina waha no agugu woga. ");
INSERT INTO eri_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ne name gete gala oruwa lala bagudu nomo ulate agugu uwau wonga wa, ne name gete gala oruwa lala wonbona.” No lama nomo rara agege tena dorofe. ");
INSERT INTO eri_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus no beele malalamudu leboro wainga, Farisi ete no Yesus no ngare da nyei nomo bona isoki tuwai. Ono wainga, no mata huwanya langa goidu bona tewol langa yafai. ");
INSERT INTO eri_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ono wainga, Farisi waha no Yesus yaage bisei uwa goi da nyi bona yafa gainga uredu, no ninau baingaro isai. ");
INSERT INTO eri_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ono wainga Anyakaro no letuwai, “Tere Farisi, tere haaya kap bagu aula langa huge dedeya. Onoya wa, huwanyatege langa yebu fanyimu bagu, fanyimu inyaba bagu bolo tigou. ");
INSERT INTO eri_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tere fai dabu tayou! Fai no dada malala langa ono bona, huwanyanege langa ada rute ono-onona? ");
INSERT INTO eri_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Onou waha bona, tere dada huwanya langa inyina waha fai dada bode tutu nigina waha, hoyo nigagu. Ariya, tere onou ono bonade wonga, tere tebere dada oruwa eege inyonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Onou wa tere Farisi, tere ure dewagu. Tere haga nomo sayori mene-mene hako gala bagu oruwa fofoura 10 du boya, matau ulate Itou tutuya. Ariya, tere onou ono borodu boya, iinga tere onowou tigini bagu, onowou Itou gau tuwei nomo waha awa tutuya. Onou waha bona, tere onowou hilobainga waha onowei nomo danga tafa bonade, nuuni beele ila fere adai awa nigagu. ");
INSERT INTO eri_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tere Farisi, tere ure dewagu. Tere bori mata huwanya langa, haumu amugou langa tedu yafei nomo gau tigi-tigina, ono boya tere fai-aita bagu komowou haumu langa, kaiye tigei nomo gaude tigi-tigina. ");
INSERT INTO eri_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Tere ure dewagu. Tere matmat oula gamu langa huwaridu inyi ganga, nere fai ada isi bode jaula ouwe langa golo bode, Itou ago langa jijiga bagu heige-heigede dorofe.” ");
INSERT INTO eri_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ono wainga nuuni beele isou fai ete no beele waha isidu Yesus benou letuwai, “Isisi higigou fai, saini ne Farisi beele onou lenigini la, ne ere fere inyabamu higini.” ");
INSERT INTO eri_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ono wainga Yesus no lewai, “Tere nuuni beele isou fai, tere fere ure dewagu. Tere fanyimu onoya waha tere dada ou anyakaro bagu waha elegedu, fai nigi geinga nere aulei nomo du, ababide dorofe. Onodu tere tage nu owotege jirou ete te tafadu hoyo nigidu ou waha ada aule-auleya. ");
INSERT INTO eri_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Tere ure dewagu. Tere tebere asatege gane nere, profet dunege kote wanenga umeru wane. Ono wane wa, tere profet waha nebere matmat kono nagi-nagiya. ");
INSERT INTO eri_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fanyimu waha langa, tere fai abitimu nigiya wa, tebere asatege gane nere fanyimu waha edo ono wane iya. Wa taate bona, tebere asatege gane nere profet dunege kote wanenga umeru wane, tere nebere matmat kono nagiya. ");
INSERT INTO eri_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ariya, Itou nomo isou tigini hilobainga waha no onou lewaiha, ‘Ji nere profet bagu, aposel bagu huuru nigehenga, fai nere waha bagu goyodbode, ono wehenga nere fai waha nebereha ila inyabamu nigi bode dunege kote wogunga umeru wodbode.’ ");
INSERT INTO eri_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Onou waha bona amina hugu warou la, Itou no oula tafai langa mai elebe, nere fai profet dunege kote wanenga umeru wane waha, nomo eeya oruwanga, nere fai-aita bagu saini elebe yafade beha nomo la inyi gonga nere une waha nomo ou todbode. ");
INSERT INTO eri_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nere profet dunege kote wane, Abel langa hugu waridu mai Sekaraia langa edowai. Sekaraia no eeya muru wari fugou alta bagu, Itou nomo mata bagu gama langa dukote wanenga umai. Yo, ji letigini, fanyimu inyaba oruwa nomo agou inyaba waha, nere fai-aita bagu saini elebe yafade beha langa heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tere nuuni beele isou fai, tere ure dewagu. Tere haumu goidu isou tei nomo jauli hao nomo ki, tere faasidu kaiteye. Onodu tere tage haumu waha langa goyei nomo awaya. Onodu saini nere fai-aita ila huwanya goidu isou tode ono gane, tere nebere jala taa nagiya.” ");
INSERT INTO eri_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Onodu Yesus no mata yafai waha awa tugainga, iinga nere nuuni beele isou fai bagu, nere Farisi bagu, no bode huwanyanege inyaba dewainga, isokiwou hogo fere-fere isoki tuwane. ");
INSERT INTO eri_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nere yaawa tuwogunga, no beele ete lenyabulu wonga, kot langa tafa tuwei nomo bode ono wane. ");
INSERT INTO eri_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nere fai-aita bagu tausen baingaro mai komo wanenga, haumu bolo dewai, onodu nere nage-nage afenege langa ilelu guruwei nomo edo langa. Ono ganenga, Yesus no nomo disaipel amugedu beele malalamudu benou lenigai, “Tere Farisi nebere yis bonade ure dewagu. Wa ji nere nebere yaawawou fanyimu boni leni. ");
INSERT INTO eri_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dada oruwanga ngarawou inyina waha, malala heigonbona. Ono gonga, huwari beele oruwanga nere fai isodbode. ");
INSERT INTO eri_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Onou waha bona, beele oruwanga tere agugu langa leya waha, nere fai-aita bagu hoonga la isodbode. Beele oruwanga tere mata huwanya langa yayaji guruya waha, nere mata ouwe langa oto bode, fai-aita bagu malalamudu lenigodbode.” ");
INSERT INTO eri_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus no ege onou lewai, “Yame ilibafe gane, ji tere benou letigini. Nere fai tebere getege galanga, dukote ganenga umena waha bonade adai umugagu, onodu iinga gonga nere ege dada ete ada ono wode. ");
INSERT INTO eri_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ariya ji tere faiwei tigini umuge tuwagu ganga waha, foomudu letigon boni. Tere Itou umuge tuwagu. Itou no fai dukote wonga umonga, no fai waha tedu bona eeya ha langa aya tuwei nomo danga bagu. Ji ngalenga letigini, tere Itou bonadenga umugagu. ");
INSERT INTO eri_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tere isiya, nere fai neei mene-mene 5, 2-toya langa ejiya-ejiyade. Onode wa Itou no neei mene-mene waha nebereha ete bona ago ada dige-digena. ");
INSERT INTO eri_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Onodu fere, no tere tebere tawatege gala, moratege langa oruwanga lelege boro tagaiha, no tere bona tigini isidena, waha bona tere adai umugagu. Tere neei mene-mene baingaro feiya nigou.” ");
INSERT INTO eri_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ariya, Yesus no ege onou lenigai, “Ji tere letigini, fai ete no fai-aita bagu onou lenigonbona, no ji yame fai yafana, ono wonga Fai Nomo Idau fere Itou nomo ensel lenigonbona, fai waha no ji yage yame. ");
INSERT INTO eri_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Onou dorofenga, fai no nere fai-aita bagu onou lenigonbona, no ji yame ganeha fai uwa, ono wonga, ji fere Itou nomo ensel lenigoni wa, no yame uwa. ");
INSERT INTO eri_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Fai no Fai Nomo Idau beele inyaba letuwona wa, Itou no nomo une uulu fuwonbona. Ariya fai no Hauri Guuni beele inyaba le tuwona wa, Itou no une waha ada uulu fuwona. ");
INSERT INTO eri_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Saini nere hatigedu bode, bori mata la yo, gabman agenege la yo, fai unyinege bagu langa hatigedu goyo gunga wa, tere umuge bonade ninatege baingaro benou adai isagu, ‘Ere beele ege gidu adadu lenigoya?’ Ere taate beele lewoya? ");
INSERT INTO eri_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tigini saini wahanga la, Hauri Guuni no beele malalamudu lewei nomo abitimu tigona bona.” ");
INSERT INTO eri_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nere fai-aita toomaro waha gamanege langa, fai ete no Yesus benou letuwai, “Isisi higigou fai, ji yame baabo ngare eire amere umaiha. Waha bona ne yame baabo letuwahenga dada eire amere awai waha haawedu bona, ji ulate hiyei nomo gau hina.” ");
INSERT INTO eri_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ono wainga Yesus no isoki tuwai, “Adadu? Faiwei no teire jas dorofe heigedu bona, teire dada haawe tarei nomo bona hangada hiyai?” ");
INSERT INTO eri_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Onodu bona no fai-aita bagu lenigai, “Tere urede bonade oofa dewagu. Tere gamaji dada hogo fere-fere elegei nomo bonade agetege waroga. Ne edo nage name dada baingaro bagu, name dada baingaro waha la, ne agene auma yafou ada tau.” ");
INSERT INTO eri_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Onodu Yesus no muuji beele ete benou lenigai, “Moni fai ete waha, nomo haga langa da hilou baingaro heigai. ");
INSERT INTO eri_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ono wainga fai waha no ninau benou isai, ‘Ji elebe adadu onowon boni? Ji yame da oruwanga komomudu, logosiwei nomo mata uwau.’ ");
INSERT INTO eri_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Onodu bona no lewai, ‘Ji benou ono woni rute. Yame mata dada oruwanga koresedu boni, mata aroro tawon boni. Onodu boni ji yame wit bagu, yame dada hilou-hilou oruwanga, elege komomudu boni, mata waha langa logosiwon boni. ");
INSERT INTO eri_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Onodu ji yage boni benou lewon boni, ji fai heigenaha. Ji yame dada hilobainga inyi gonga, haga orei baingaro goyonbona. Ono gonga, ji houwe tafadu yafa boni, saini oruwa da anyakaro aji boni, edega boni yafon boni.’ ");
INSERT INTO eri_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ono wainga Itou no onou letuwai, ‘Ne fai dabu tayou tigini. Elebe ooru behanga la ne umau ganga. Ono wahenga dada oruwanga ne haiya wene otona waha, faiwei elegona?’” ");
INSERT INTO eri_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ono wainga Yesus no lewai, “Dada benou waha, fai nere nage nebere dada baingaro komomude la heigonbona. Onode wa, nere Itou ago langa dadanege uwau yafade.” ");
INSERT INTO eri_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ariya, Yesus no nomo disaipel onou lenigai, “Ji tere onou letigini, tere muuji beele waha isidu, tere tebere yafou bonade ninatege baingaro isidu, benou adai lewagu, ‘Ere taate nyoya?’ Onodu tere tebere getege gala boya ninatege isidu benou adai lewagu, ‘Ere taate ogola tagu woya?’ ");
INSERT INTO eri_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Agege auma yafou no da nyou langanga uwa. Gege gala no ogola dada feiya tuwou. ");
INSERT INTO eri_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tere kaloga bonade ninatege isagu. Nere da ada tau-taude, da ada komomu-komomude. Nere da mata uwau, nere dada logosiwei nomo fere mata uwau, Itou no nere da nigi-nigina. Ariya, tere fai-aita bagu neei feiyade nigou. ");
INSERT INTO eri_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ariya tebereha ete no yafa dewei nomo jala bona ninau baingaro isona waha langa, no nomo ago auma yafou ege menenga turi wona rute? Edo uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Onou wa, tere dada menakele onouha onowei nomo edo uwa waha, tere taate boya dada fere-fere boya ninatege baingaro isiya? ");
INSERT INTO eri_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tere kooko adadu heigede waha nerige dewagu. Nere haruwe danga ada tede. Nere ogola ada ati-atide. Onou wa ji tere letigini, amina King Solomon no nomo mujari oruwa hilou‑hilou mujarigai. Ariya kooko beha nebere mugari hilobainga waha Solomon nomo mujari feiya tuwou. ");
INSERT INTO eri_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ariya elebe jiigu dada kejiwe otode beha, iranga la fai karudu eeya langa ayaru wodbode. Ariya, jiigu ewe onouha waha, Itou no mujarimu-mujarimuna. Onou waha bona, tere fai-aita bagu huwanyatege ngalengawou menakele bagu, tere edo onou isi dewagu ganga, Itou no tere fere mugari tigonbona. ");
INSERT INTO eri_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Onou waha bona, tere aooso bonade benou adai lewagu, ere taate da nyoya yo, taate yaage nyoya yo, ibonade ninatege baingaro adai isagu. ");
INSERT INTO eri_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nere fai-aita bagu oula beha nomo oruwanga, nere dada waha torobawei nomo bode, ninanege baingaro isi-iside. Onou wa, tere tebere Ametege no amina isi tigaha, tere dada waha elegagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Onou bona tere Itou awa tuwadenga tebere king yafei nomo ninatege isagu. Ono wadenga, no tere dada waha fere tigonbona.” ");
INSERT INTO eri_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesus no ege onou lenigai, “Tere sipsip bainga uwa, tere adai umugagu. Tere tebere Ametege no tebere king yafa bona, no tere nomo huuna langa yafou tigei nomo bona amina lewaiha. ");
INSERT INTO eri_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tere fai awa nigadenga, tebere dada oruwanga ejiya wogunga, moni waha nere fai dada tutu nigina waha nigagu. Tere moni fausi ada inyaba wona waha taagu, onodu tebere dada hilou-hilou ha laluwa langa komomu wagu. Ha laluwa langa dada ada huwari-huwaride, yebu fai ada elege-elegede, mugumugu fere dada ada inyabamu-inyabamude. ");
INSERT INTO eri_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Haumu tere tebere dada hilou-hilou otode, haumu wahanga la tere tebere gauwou fere walanga inyonbona.” ");
INSERT INTO eri_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ariya, Yesus no ege onou lewai, “Tere tebere ogola tutumudu, leeti tagudu lama dugedu haiyadu yafagu. ");
INSERT INTO eri_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tere fai nebere fai anyakaro no fai-aita ngare te guruwou da ajou anyakaro awadu bona, ege gidu mai ganga itari tude dorofe yafagu. No maidu bona jauli kato-kato wonga, nere jauli fasayadu helufa fuwodbode. ");
INSERT INTO eri_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ariya, nere haruwe magana agore jiri wegu uwa inyi gonga, nebere fai anyakaro no mai nerigona wa, nere edo edega wode. Ji ngalenga letigini, fai anyakaro no nogo ogola tutumudu, leeti tagudu bona, tewol langa yafei nomo bona lenigonbona. Onodu no nogo we maidu da nigonbona. ");
INSERT INTO eri_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ariya, fai anyakaro no ooru jege yo, teewe hu bona wari gonga yo, maidu bona haruwe magana agore jiri wegu uwa inyi gonga nerigona wa, nere edo edega wode. ");
INSERT INTO eri_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ariya, tere dada beha bonade ninatege isagu. Mata morou no saini ada gonga yebu fai no nomo mata langa mayonbona waha no amugedu isei mata wonga wa, no yebu fai waha ada awa tuwonga maidu bona nomo mata koraidu huwanya goyona. ");
INSERT INTO eri_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Onou dorofenga, tere fere haiya wagu. Fai Nomo Idau no saini ete langa tere ada isi gadenga no mayonbona.” ");
INSERT INTO eri_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita no Yesus isoki tuwai, “Anyakaro, ne muuji beele lenaha beha, erenga boni lenaha yo, uwa, ne fai oruwanga boni lenaha?” ");
INSERT INTO eri_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ono wainga Anyakaro no letuwai, “Hoobu magana adeha no ninau hilobainga bagu haruwe te dedena? Anyakaro no hoobu onouha waha nomo haruwe magana oofa fuwei nomo bona, hangada tuwonbona, onodu no saini anyakaro hangadawai la, da wese nagonbona. ");
INSERT INTO eri_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Haruwe magana onouha waha saini no nomo fai anyakaro nomo haruwe te fugonga, no ege gidu mai urona la no edo edega dewona. ");
INSERT INTO eri_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ji tere ngalenga letigini, fai anyakaro no haruwe magana waha hangada tuwonga, no nomo dada oruwa oofa fuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ariya, haruwe magana waha no nomo huwanya la benou isei mata wona, ‘Yame fai anyakaro no fasadu ada mayona idu bona,’ haruwe magana ila bagu haruwe aita ila bagu narige bona da nyi bona, yaage nyidu sipak bona, golo gonga, ");
INSERT INTO eri_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","fati ete no haiyawei uwa saini no isei uwa langa, fai anyakaro no ege gidu mayonbona. Onodu haruwe magana waha inyabamude tudu bona, haudu togoi nere fai fetogou yafade waha bagu tafa tuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Haruwe magana no nomo fai anyakaro nomo gauwou oruwa, no isina, ariya no dada haiyawei uwa, onodu no nomo fai anyakaro nomo gauwou oojowei uwa. Waha bona, fai anyakaro no haruwe magana waha danga bagu gula tuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ariya, haruwe magana waha no nomo fai anyakaro nomo gauwou ada isina bona, no fanyimu gula tuwei nomo edo langa ono waha, wa nomo fai anyakaro no danga bagu ada gula tuwona. Nere fai dada baingaro elegede waha, nere agou ege baingaro giimu wodbode. Ariya fai-aita bagu nere fai ete owo langa dada baingaro tafa bode wonga, ariya nere ege agou baingaro nigei nomo letuwodbode.” ");
INSERT INTO eri_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus no ege onou lewai, “Ji oula langa eeya ayawei nomo meene, eeya beha no fasadu lalawei nomo gau deni. ");
INSERT INTO eri_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ji yaage bisou hogo fere ete tonboni. Elebe ji tei uwa inyina, onou waha bona, ji huwanyafe tigini ou dena. ");
INSERT INTO eri_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gamaji tere ninatege isagu ganga, ji oula langa oota oruwa usumuwei nomo boni meene. Uwa. Ji tere letigini, ji nere fai-aita bagu fofoura nigei nomo boni meene. ");
INSERT INTO eri_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Elebe bagu iinga huunta langa fere, nere baabo gane 5, nere mata etenga la yafei mata wode wa, nere foure nga wodbode. Onodu nere eei waha nere nga waha honggoro nirodbode, nere nga waha nere eei waha honggoro nigodbode. ");
INSERT INTO eri_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nere fourodbode, umamu no idau honggoro tuwonbona, idau no umamu honggoro tuwonbona. Ariya anya no mago honggoro tuwonbona, mago no anya honggoro tuwonbona. Fai ete buyumu aita honggoro tuwonbona, buyumu aita no au nomo anya honggoro tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus no nere fai-aita toomaro benou lenigai, “Tere agao ulate hoonga minou langa heige ganga uredu fasadu onou leleya, ‘Yaage mona onona.’ Ono geyenga ngalenga tigini, yaage memena. ");
INSERT INTO eri_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Onodu tere jagui danga bagu ulate saot nomo mai ganga uredu leleya, ‘Hoonga elebe ngaasu kuru wonbona iya.’ Ono geyenga ngalenga tigini, hoonga danga bagu oto-otona. ");
INSERT INTO eri_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tere yaawagou fai, tere oula taene bagu langa dada heigede waha, haawe nigei nomo isi dedeya. Onoya wa, tere taate boya elebe saini beha nomo onowou heigena waha, ada haawe ya?” ");
INSERT INTO eri_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesus no ege onou lenigai, “Tere taate boya tere tage ninatege ada isidedu, taate onowou no tigini waha ada haawe ya? ");
INSERT INTO eri_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ariya fai ete no kot langa tafa hinonga, tere golodu, kot haumu la mani bonadere, ne no ngare beele tiginimuwei nomo onowau. Gamaji no kuse hinidu jas langa goyoga, ono wonga jas no polis owonege la tafa hinoga, polis nere hainedu dagou mata langa tani hinoguga. ");
INSERT INTO eri_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ji ne ngalenga lehinini, ne dagou mata langa yafa bonahe moni haawe hanane waha oruwa ejiya wahenga edo wonbona.” ");
INSERT INTO eri_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesus no beele malalamudu le borowainga, ariya fai ila nere Pailot no nomo oota fai lenigainga, Galiliha fai ila Itou eeya muru wari fuwei nomo fati langa, dunege kote wanenga nebere ganenege feudu, toota nomo kaafa yaula langa feuwai. Waha nomo aasa Yesus hai fuwane. ");
INSERT INTO eri_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nere onou hai fuwanenga, Yesus no beele ege gidu benou lenigai, “Tere benou rute isiya, nere Galili fai waha nere Galili fai ila oruwa feiya nigidu une baingaro tafane, hugu waha bona nere la dada inyaba waha heigai iya yo? ");
INSERT INTO eri_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gai uwanga uwa. Ji tere ngalenga letigni, tere huwanyatege ubulu wegu uwa wonga, dada onouhanga tere oruwanga la heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nere fai 18 waha, amina Siloam mata ufaro koudu me ilei nigainga umeru wane waha, nebere une nere fai fereha Jerusalem langa yafade waha nebere une feiya nigou iya yo? ");
INSERT INTO eri_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gai uwanga uwa. Ji tere ngalenga letigini, tere huwanyatege ubulu wegu uwa wonga, dada onou onounga, tere oruwanga la heigonbona.” ");
INSERT INTO eri_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ariya, Yesus no muuji beele ete benou malalamudu lewai, “Fai ete no nomo wain haga la nauge fik ete tawai, iinga gainga, no fik nauge waha nomo hilou kurudu mayai. Ariya hilou ete te walanga inyi gainga urei uwa. ");
INSERT INTO eri_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ono wainga no maidu bona haga waha nomo haruwe fai benou letuwai, ‘Ne isau. Elebe haga orei eei oruwa ji fik nauge beha nomo hilou kuru boni mainaha, no hilou heigei uwa, onou bona ne nauge beha laudu kaitau. Taate bona no ewe oto bona oula nomo laluwa usumuna?’ ");
INSERT INTO eri_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ono wainga haruwe fai wa no ege gidu benou letuwai, ‘Fai Anyakaro, edo awa tuwahenga haga orei etenga behanga ege oto wonga. Ji oula, nauge waha hugu la konodu boni, bulumakao hewenege tamai logosi wonboni. ");
INSERT INTO eri_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ono wehenga, no haga orei ete la hilou edo heigona rute. Uwa wonga, ne edo laudu kaitau.’” ");
INSERT INTO eri_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bori nomo fati langa, Yesus no fai-aita bagu bori mata ete huwanya langa beele lenigai. ");
INSERT INTO eri_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ono gainga aita ete no yafai, no hauri inyaba ete no la inyai, ono bona no aita waha haga orei 18 oruwa taura tungawai. Onou waha bona, aita waha nomo muju kara no tiginidu otowei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus no aita waha uredu bona, yaure tuwainga mayainga benou letuwai, “Aita, ji name taura jigemu boro haninaha.” ");
INSERT INTO eri_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Onodu bona, no owo aita waha jaula langa tafainga, fasayadu onou no tiginidu oto bona Itou unyi isouwai. ");
INSERT INTO eri_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ono wainga bori mata waha nomo mora bagu no Yesus bona houmu mayai, taate bona, no bori nomo fati langa aita waha jigemu tuwai bona. Onodu mora bagu no fai-aita bagu benou lenigai, “Haruwe tei nomo fati 6 oruwa. Onou waha bona, tere fai no tebere taura uwamu tagei nomo wonga wa, tere haruwe fati langa mayagu. Tere fai tebere taura uwamu tagei nomo bonade, bori nomo fati langa adai isoki nigagu.” ");
INSERT INTO eri_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ariya ono wainga, Anyakaro no nomo beele ege gidu benou letuwai, “Tere yaawagou fai. Tere tebere beele bagu tere tebere fanyitege bagu hogo etenga uwa. Tere bori nomo fati langa, tere oruwa bulumakao nebere mata langa goidu boya, tebere bulumakao bagu, donki bagu, maalu futu nigidu, yaage nyei nomo hanigedu mini-miniya. ");
INSERT INTO eri_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Onou wa, aita beha no Abraham nomo mago ete. Satan no haga orei 18 oruwa, no dage tuwai. Onou waha, adadu? Ji dada no dage tuwai waha, bori nomo fati langa futu fuwei nomo edo uwa yo?” ");
INSERT INTO eri_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","No onou lewainga, nomo honggoro fai nere mayaude nigai. Ono ganenga, nere fai-aita bagu oruwanga no dada oruwa hilobainga tigini onowai waha bode edega wane. ");
INSERT INTO eri_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ariya, Yesus no beele ege benou lenigai, “Itou nomo huuna langa yafou waha no taate dada dorofe? Ji muuji beele adoha waha lewoni? ");
INSERT INTO eri_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","No sayori ete, nere mastet ide, waha nomo fatu dorofe. Fai ete, no mastet fatu tedu bona, no nomo haga langa tawai. Ono wainga, iinga mastet no anyakarodu bona nauge dorofe heigai. Ono wainga, neei nere maidu bode, nomo tuwa langa nebere tomu tafane.” ");
INSERT INTO eri_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus no ege onou lewai, “Ji Itou nomo huuna langa yafou waha nomo muuji beele adoha lewoni? ");
INSERT INTO eri_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","No yis dorofe. Aita ete no yis waha tedu bona dram anyakaro falawa bgau waha ubulumuwai. Ono wainga, iinga falaua waha oruwanga ngasagai.” ");
INSERT INTO eri_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ariya, Yesus no Jerusalem jala langa golodu bona goyai. No matane la bagu, taon la bagu goidu fai-aita bagu isisiwou nigai. ");
INSERT INTO eri_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ono gainga, fai ete no benou letuwai, “Anyakaro, Itou no fai etenga-etenga rute ege gidu hanigon bona?” Ono wainga, Yesus no onou lenigai, ");
INSERT INTO eri_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tere jauli menakele huwaya la goyei nomo danga tafagu. Ji tere letigini, fai baingaro goyei nomo ono wodbode, wa nere edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Iinga gonga, mata morou no jaidu bona, mata nomo jauli arasai sesemu wonbona. Ono wonga, tere maidu, malala langa oto bonade, jauli arasai kato-kato bonade benou yauragu ganga, ‘Anyakaro, jauli helufa hagau.’ Ono wadenga, no beele ege gidu benou letigon bona, ‘Ji tere ada isi tigini. Tere ha adiha.’ ");
INSERT INTO eri_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ono wonga, tere benou letuwagu ganga, ‘Ere ne gaara da nyi boya, yaage nyeyeha, ne ere ebere jala langa oto boni, isisiwou higene.’ ");
INSERT INTO eri_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ono wagu wa, no tere benou letigonbona, ‘Ji tere boni ada isini, tere fai ha adiha. Tere fai fanyimu inyaba onogou, tere oruwa belaha sina wagu.’ ");
INSERT INTO eri_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham wonga, Aisak wonga, Jekop wonga, nere profet oruwanga Itou nomo huuna langa yafou huwanya langa yafa gogunga nerigagu ganga, ariya tere tage nu so tigogunga malala la yafagu ganga. Onodu mere bonade, matege gidodo wagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ariya, nere fai-aita bagu nere nebere kantri ulate hoonga mayou langa, ulate hoonga minou langa, ulate not langa, ulate saot langaha, nere nebere kantri awadu bode mai Itou nomo yafou huuna langa waha da nyou langa yafodbode. ");
INSERT INTO eri_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ariya isagu. Nere fai ila elebe gai huunta tigini yafade waha, nere amugou heigodbode. Ariya nere fai ila elebe amugou yafade waha, nere gai huunta yafodbode.” ");
INSERT INTO eri_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saini waha langa tigini, Farisi ila maidu bode Yesus benou letuwane, “Herot ne dute kote wona onona, ne haumu beha awadu bonahe, haumu fere langa goyau.” ");
INSERT INTO eri_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ono wanenga, Yesus no benou lenigai, “Tere goidu bonade, gauna kui inyaba waha benou letuwagu, ‘Isau. Elebe ira bagu, ji hauri inyaba so nigi boni, nere taura fai, taura jigemu nagon boni. Onodu boni, fati eei langa ji yame haruwe usumu wonboni.’ ");
INSERT INTO eri_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ariya elebe bagu, ira, bagu, arafia bagu ji golodu goyon boni. Taate bona, profet no matane fere langa yafa gonga adai dukote wogu. Uwa. Nere Jerusalem langanga dukote wode. ");
INSERT INTO eri_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, ne profet dunege kote genenga umeru-umerude, onodu ne fai Itou ne bagu huuru nigi ganga mai gane hanigedu, dunege kotewei nomo boni megebu ayaru nagi-nagini. Ji saini baingaro ne name magana komomu nigoni ononi, teewe anya nomo magana hadimu langa kuromu nigina dorofe, ariya tere awa-awaya. ");
INSERT INTO eri_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Onou waha bona, tere isagu. Elebe tere tebere matane inyabadu bona, ewenga inyonbona. Ji tere ngalenga letigini, tere ji ege ada yeriyagu ganga, goi saini tere lewagu ganga, ‘Fai beha Anyakaro unyi langa maha, Itou no edo figini tuwonbona!’” ");
INSERT INTO eri_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bori nomo fati ete la, Yesus no Farisi nebere mora bagu ete nomo mata la goidu bona da nyai. Ono gainga nere oofade tuwane. ");
INSERT INTO eri_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ono gainga, fai ete no gogala gai nga sage dewou, no Yesus hinemu langa yafai. ");
INSERT INTO eri_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ono wainga, Yesus no fai waha uredu bona, no nuuni beele isou fai bagu, nere Farisi bagu isoki nigai, “Ere bori nomo fati langa taura fai jigemu nigei nomo edo yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ono wainga, nere huranege fosokodu beele ete gidu letuwegu uwa. Ono wanenga, no fai haudu nomo taura jigemu tudu bona, huuru tuwainga goyai. ");
INSERT INTO eri_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Onodu bona, no benou lenigai, “Tebereha ete no nomo idau yo, nomo bulumakao yo, Bori nomo fati langa mebodudu, yaage u-u langa minonga uredu, no fasadu la isou tuwonga ouwe langa mayona yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ono wainga nere beele waha ege gidu letuwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus no nere fai da waha nyode mayanenga nerigai wa, nere maidu bode sia amugou wahanga langa yafode ono wane. Ono wanenga, no muuji beele ete benou lenigai. ");
INSERT INTO eri_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Saini fai ete no nere fai-aita ngare te guruwou da ajou anyakaro langa goyei nomo bona yaure hinei mata wonga, ne goidu bonahe sia amugou langa adai yafau. Gamaji sia waha fai ete no unyi anyakaro bagu, no ne unyite feiyawou waha nomo hangada fuwoguga. ");
INSERT INTO eri_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ono wahenga iinga, fai no yaure hinanaga goi naha waha maidu bona lehinonbona, ‘Ne sia amugou waha, fai waha tuwau.’ Onou lehinonga, ne mayau danga bagu hini gonga, minidu haumu gai huunta la yafau ganga. ");
INSERT INTO eri_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Onou waha bona fai ete no, ne da nyei nomo yaure hinonga goi bonahe wonga wa, ne goidu haumu gai huunta la yafau. Ne onou ono wahenga, fai ne yaure hinanga goi naha waha maidu lehinonbona, ‘Baabo, ne maidu bonahe sia amugou langa yafau.’ No onou ono wonga, ne fai da gaara nyi boya yafaya waha oruwa agenege langa unyite anyakaro tau ganga. ");
INSERT INTO eri_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Fai no nogo nomo unyi isouna waha Itou no unyi esenemu fuwonbona. Ono gonga fai no nogo unyi esenemuna waha, Itou no unyi isou wonga ouwe manonbona.” ");
INSERT INTO eri_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ariya, Yesus no fai da nyou waha langa yaure tuwainga mayai waha letuwai, “Ne da ajou ete heigemuwei mata bonahe wonga wa, ne name ilibane gane bagu, baine gane bagu, name olobete mutu etenga bagu, nere name matane etenga moni baingaro bagu waha, adai yaure nigau. Gamaji iinga huunta la, nere yaure hinogonga, ne goi nebere mata langa da nyauga. Ono wahenga, nere name da agou hinoguga. ");
INSERT INTO eri_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Uwa. Ne da ajou anyakaro heigemuwei mata bonahe wonga wa, ne fai dadanege uwau bagu, fai genege gala inyaba bagu, fai afenege inyaba bagu, fai agenege fosokowou bagu, waha yaure nigau. ");
INSERT INTO eri_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nere fai onouha waha, nere ege name da agou hinei nomo edo uwa. Onou waha bona, ne edo edegawau, taate bona, iinga gonga, Itou no ne name da waha agou ege gidu hinonbona, saini nere fai tigini waha, ege matmat langa gidu jai gogunga.” ");
INSERT INTO eri_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Fai nebereha ete no Yesus ngare yafadu da nyare waha no beele waha isidu bona, Yesus benou letuwai, “Nere fai-aita bagu Itou nomo huuna langa yafou waha huwanya langa yafadu da nyode waha, nere edo edega wode.” ");
INSERT INTO eri_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ono wainga, Yesus no fai waha letuwai, “Fai ete no da ajou anyakaro heigemu wonbona waha bona, no fai baingaro ajou waha la mayei nomo bona yaure nigai. ");
INSERT INTO eri_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ariya, no fati hangadawai la, da ajou anyakaro waha heigemudu, no nomo haruwe magana huuru tuwainga, nere fai no amina yaure nigai waha nerigedu, benou lenigei nomo bona goyai, ‘Tere mayagu, dada oruwanga haiya boro waha inyina.’ ");
INSERT INTO eri_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ono wainga nere fai waha oruwanga, ajou waha la ada goyoboya wane. Fai ete no letuwai, ‘Ji haga ete amina ejiyanaha, onou waha boni, ji goi haga waha uron boni, agene gami ji ada mayoni.’ ");
INSERT INTO eri_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ono gainga ete letuwai, ‘Ji bulumakao 10, yame haruwe te hayei nomo boni ejiyanaha, onou waha boni, ji goidu haruwe abitimu nigi uronboni, agene gami, ji ada goyoni.’ ");
INSERT INTO eri_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ono gainga, fai ete letuwai, ‘Ji iingabe aita tenaha, onou waha boni ji ada goyoni.’ ");
INSERT INTO eri_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ariya, haruwe magana nebere beele waha elegedu, ege gidu nomo fai anyakaro bagu goyai. Ono wainga saini fai anyakaro no beele waha isidu bona, no houmu danga bagu mayainga, no nomo haruwe magana benou letuwai, ‘Ne fasadu taon beha nomo jala anyaroro la bagu, jala mene-mene oruwanga la goidu bonahe, nere fai dadanege uwau waha, nere fai genege gala inyaba waha, nere fai agenege fosokowou waha, nere fai afenege lalekawou waha oruwa hani gahenga, yame mata huwanya la mayagu tuwai.’ ");
INSERT INTO eri_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ono wainga, haruwe magana waha no onou ono borodu bona letuwai, ‘Fai anyakaro, ji ne lenaha onou amina ono borenaha, ononaha wa, mata bolowei uwa inyina.’ ");
INSERT INTO eri_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ono wainga, “Fai anyakaro nomo haruwe magana benou letuwai, ‘Ne taon awa tudu, jala anyaroro oruwa goidu haga nomo orei oojo bonahe, nere fai-aita nerigedu beele danga bagu yame da la mayei nomo bonahe lenigau. Ji yame mata fai bolowei nomo boni gau hina. ");
INSERT INTO eri_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ji tere letigini, nere fai oruwanga ji aminanga yaure nigene waha, nere yame da matau menakele mene ete, adanga ada tode.’” ");
INSERT INTO eri_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nere fai-aita toomaro Yesus ngate golo bode no ubuludu benou lenigai, ");
INSERT INTO eri_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Fai no ji bagu mayei mata bona, no nomo umamu bona anya bona oya bona nere magana bagu, bemu gane bagu, ogobumu gane bagu, onodu no nogo nomo yafou la fere, honggorowou uwau wonga wa, no ji yame disaipel yafei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Onodu, fai no nomo nauge abalakawou auledu ji ada oojo hina waha, no ji yame disaipel yafei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Onou wa, tebereha ete no mata ete nere fai jiri bode, nomo dada edola oofa fuwei nomo tau bona wonga, amugedu no yafadu bona, mata waha tawei nomo moni agonyi waha bona ninau isi dewonbona. No isonbona, nomo moni waha edola mata waha usumu wona yo, uwa. ");
INSERT INTO eri_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","No amugedu onou onowei uwa la simen tafadu mata waha ada usumuwei mata bona wonga, nere fai oruwanga uredu bode, fai waha memesi beele letuwodbode. ");
INSERT INTO eri_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nere lewodbode, ‘Fai mata jaimuwai waha no usumuwei nomo edo uwa.’ ");
INSERT INTO eri_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Onounga, king ete no goi king ete ngare wara wodere wonga, no ngasunga la yafadu ninau isidedu bona. No nogo nomo oota fai 10-tausenenga rute, ono ganga king ete no oota fai 20-tausen baguru maina. Onou waha bona, no amugedu isidedu bona, no king waha ngare waradu bodere, no edola so tuwona yo, uwa? ");
INSERT INTO eri_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ariya, no ninau isona wa no edo uwa, waha bona saini no nomo honggoro fai baae langa yafa gogunga, no fai ila huuru nigonga no bagu goidu bode, oota waha usumuwei nomo bode beele ngado urodbode. ");
INSERT INTO eri_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Onou dorofenga, tebereha ete no nomo dada oruwanga moge nigei uwa wonga wa, no ji yame disaipel yafei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ariya, Yesus no ege onou lewai, “Sol no dada hilobainga. Onou wa, sol no nomo iisa usuwonga, ere adadu ono wedenga sol waha no ege hilobainga heigona? ");
INSERT INTO eri_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol onouha waha da haga langa heigena waha hoyo tuwei nomo edo uwa. Onodu ere bulumakao hewenege bagu ubulumudu, haga langa tafei nomo edo uwa. Ere ewe onou elege ayaru-ayaruya. Fai no agokuli bagu waha no beele beha isona.” ");
INSERT INTO eri_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nere takis tegou fai bagu, nere une fai bagu, Yesus nomo beele aaguwei nomo bode, hinomu la mayane. ");
INSERT INTO eri_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ono wanenga, nere Farisi bagu, nere nuuni beele isou fai bagu, honggoro bode benou lewane, “Fai beha une tafagou fai bagu da gaara nyi-nyide.” ");
INSERT INTO eri_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ono wanenga, Yesus no muuji beele beha lenigai, ");
INSERT INTO eri_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Fai ete tere gama la no nomo sipsip 100, ariya ete huwariwei mata wonga, no sipsip 99 waha awa nigonga da nyi bode haumu ete la golo gogunga, no etenga huwariwai waha kurudu goi toroba dunga awonbona. ");
INSERT INTO eri_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Saini no sipsip waha torobadu bona, no isoudu te boila la inyemu tudu edega bona auledu matane gidu goyonbona. ");
INSERT INTO eri_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Saini no nomo mata langa heigedu bona, no nomo ilibumu gane bagu, nomo matane etenga bagu, yaure nigonga mai komo wogunga lenigonbona, ‘Tere ji ngate edegawei nomo! Ji yame sipsip ete huwariwai waha kurudu amina torobanaha.’” ");
INSERT INTO eri_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Onodu bona, Yesus no lewai, “Ji tere ngalenga letingi, edegawou onohanga ha laluwa la heige-heigena, saini une fai ete no huwanya ubuluna la. Ngalenga, nere fai 99, nere huwanyanege ubuluwei nomo haruwe uwau, wa nere aminaha tigini yafa gane maina, waha bode edega-edegade. Onou wa, une fai ete no huwanya ubuluwei mata wonga, edegawou anyakaro heige-heigena.” ");
INSERT INTO eri_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ariya, Yesus no ege onou lenigai, “Aita ete no nomo moni wan kina waha 10 oruwa, ete mata la huwariwei mata wonga, no adadu ono wonbona? No lama dugedu, mata abiya kunu bona igeidedu kurudu goi torobadu tonbona. ");
INSERT INTO eri_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Saini no moni huwariwai waha ege torobadu tona la, no nomo ilibumu gane bagu, nomo matane etenga bagu, yaure nigonga mai komo wogunga no lenigonbona, ‘Tere ji ngate edega woboya! Ji yame moni ete huwariwai waha, ji kurudu boni ege torobadu tenaha!’ ” ");
INSERT INTO eri_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Onodu Yesus no onou lenigai, “Ji tere ngalenga letigini, saini une fai ete huwanya ubuluna la, edegawou onohanga nere Itou nomo ensel gamanege langa heige-heigena.” ");
INSERT INTO eri_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus no ege benou lenigai, “Fai ete no nomo idau gane nga nononga. ");
INSERT INTO eri_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ariya, idau huuntaha wa, no umamu benou letuwai, ‘Jijei, ne name dada oruwa ere baabo ngare wese harau ganga waha, ji onou ninafe isini, ji yame bona wa, ne elebe wesedu hiyei nomo gau hina.’ Ono wainga umamu no nomo dada oruwanga, foure ngadu bona idau gane nga nononga wese narai. ");
INSERT INTO eri_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ono wainga udidiwei uwa, idau huuntaha wa no nomo dada oruwa komomudu bona, fai ila langa huuruwai. Onodu no moni tedu bona, goi matane ete baae langa yafai. No matane waha langa edegawou hogo fere-fere tafa bona yafa gainga, no nomo moni oruwanga usuwai. ");
INSERT INTO eri_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Saini no nomo moni oruwa usuwai langa, mau saini anyakaro matane waha langa heigai. Ono wainga no dada ete te uwau, ewenga yafai. ");
INSERT INTO eri_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Onou waha bona, no goidu bona matane wahaha fai ete la haruwe torobawai. Ono wainga fai wa no huuru tuwainga, nomo buuwa orei la oofa nigei nomo bona goyai. ");
INSERT INTO eri_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ariya, no buuwa sayori osoka nyi gane nerigedu bona no huweli usumuwei nomo bona ila elegedu nyei nomo inyangaro gau tuwai. Onou wa fai ete no huwanya huweli bona da te tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ariya nomo isou hilou mayainga lewai, ‘Ji yame jijei nomo haruwe magana nere da baingaro. Ariya, ji belanga huweli ma te boni yafani.’ ");
INSERT INTO eri_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Buyona, ji jaidu ege gidu boni yame jijei bagu goyonboni. Ji goidu benou letuwon boni, ‘Jijei, ji ne Itou ngare, une tafa tirene. ");
INSERT INTO eri_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Elebe ne ege ji yame magana hiyei nomo ji fai hilou uwa. Ne ji awa hiyahenga, ne name haruwe magana ete dorofe yafoni.’” ");
INSERT INTO eri_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","No onou ledu bona, jaidu umamu bagu goyai. “Saini no iinga baae la golowai mai gainga, umamu no ago ayadu bona idau mai gainga uredu, aau danga bagu warai. Onodu bona, no guriyedu goidu yaasu tudu, dobole tubona uumba tuwai. ");
INSERT INTO eri_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ono wainga, idau no umamu benou letuwai, ‘Jijei, ji ne Itou ngare une tafa tireneha. Onou waha bona, elebe ne ege ji yame magana hiyei nomo, ji fai hilou uwa.’ ");
INSERT INTO eri_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ono wainga umamu no nomo haruwe magana yaure nigainga mayanenga lenigai, ‘Tere yame kolos ufaro hilobainga waha fasadu tetamaidu bonade, tagumu tuwagu. Onodu owo jirou la ring ete tanimu fuwagu nigai. Onodu bonade, su afo langa tani fuwagu nigai. ");
INSERT INTO eri_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Onodu tere goi bulumakao magana ngasagou waha te tamaidu, dukote wadenga ajidu nyi boya edegawei nomo. ");
INSERT INTO eri_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Taate bona yame magana beha no umaiha, onowai waha no elebe ege ago auma yafou taha. No huwariwai waha, ere ege hauyaha.’ Onodu bode, nere da anyakaro ajidu nyi bode, edega bode yafane. ");
INSERT INTO eri_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ariya saini waha langa, nomo idau motuwa no haga la golowai. Iinga no ege gidu mai mata yugumu bona, no musik bolou aagu bona fai aita bagu moone uyi gane isai. ");
INSERT INTO eri_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Onodu bona, no haruwe magana ete yaure tuwainga mayainga isoki tuwai, ‘Nere taate adade?’ ");
INSERT INTO eri_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ono wainga, haruwe magana letuwai, ‘Name baine no ege gidu mayaha, onowanga, name amene no bulumakao magana ngasagou ete waraha, taate bona, umamu no uraha wa, idau no hilobainga la golodu ege gidu mayanga bona, no edegana.’ ");
INSERT INTO eri_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ono wainga, idau motuwa no beele waha isidu houmu mayainga, no mata huwanya la goyei nomo awai. Ono wainga, umamu no malala maidu bona idau houmu bodomu fuwei nomo beele hilou-hilou letungawai. ");
INSERT INTO eri_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ono wainga no umamu beele ege gidu benou letuwai, ‘Adadu? Haga orei baingaro, ji haruwe magana ete ewe dorofe, name haruwe onowei nomo bona haruwe tigini danga tegene. Ji name beele ete ada feiya gene. Ono wene waha, ne ji saini ete te, meme magana ete onou langa hiyenenga ji yame ilibafe gane bagu, edegawei uwa. ");
INSERT INTO eri_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ariya, ne name idate beha no, name dada oruwanga longi aita la usumu borowaiha. Waha no elebe ege gidu mayanga, ne edegamu tuwau ganga bulumakao magana gogala ngasagou waha dukotenaha.’ ");
INSERT INTO eri_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ono wainga, umamu no idau letuwai, ‘Yame magana, ne ji ngare saini oruwa yafa-yafayare. Onou waha bona, yame dada oruwa wa ne name. ");
INSERT INTO eri_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ariya, ere elebe huwanyage hilou inyi gonga, edegawei nomo, taate bona, name baine beha no umai waha elebe ege ago auma yafou taha. No huwariwai waha, elebe ere ege gidu hauyaha.’” ");
INSERT INTO eri_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus, no nomo disaipel benou lenigai, “Moni fai nomo hoobu fai ete yafai. Ono gainga, fai ila nere moni fai waha bagu maidu bode, hoobu fai go beele benou tafane, ‘Name hoobu fai no name dada ewe onou usumuna tuwane.’ ");
INSERT INTO eri_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ono wanenga, no hoobu fai yaure tuwainga mayainga letuwai, ‘Ji name onowou bona beele isinaha waha adadu? Ne goidu bonahe, yame dada oruwanga ne owone la inyina waha nomo beele yeregau. Ne ege hoobu fai ada yafau ganga tuwai.’ ");
INSERT INTO eri_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ono wainga, hoobu fai no nogo ninau benou isai, ‘Ji elebe adadu onowoni? Fai anyakaro no ji hoobu fai haruwe la, usumu hiyona onona. Ji fai ete la haruwe fai ewe heigedu, oula konuganawei nomo danga uwau. Onodu, ji fai ila moni dada boni malagau nigei nomo mayau hina. ");
INSERT INTO eri_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ariya, elebe ji taate dada onowon boni waha isini, ono wehenga saini anyakaro no ji hoobu fai haruwe langa usumu hiyona la, nere fai edo ji haifogunga, nebere mata langa goyo boya.’ ");
INSERT INTO eri_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Onodu bona, no fai etenga-etenga nere nomo anyakaro langa agou elegane waha, yaure nigainga, no bagu mayane. Ono wainga, fai ete no amugedu mai heigainga, hoobu fai no isoki tuwai, ‘Ne yame anyakaro langa name agou agonyi inyina?’ ");
INSERT INTO eri_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ono wainga no letuwai, ‘Ji yame agou, 100 wel dram.’ Ono wainga, hoobu fai no letuwai, ‘Ne pepa name agou yeregane waha tedu bonahe, fasayadu yafadu 50nga yeregau tuwai.’ ");
INSERT INTO eri_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ono gainga, iinga fai ete mai heigai, ono wainga hoobu fai no isoki tuwai, ‘Ne name agou agonyi inyina?’ Ono wainga no letuwai, ‘100 wit bek.’ Ono wainga hoobu fai no letuwai, ‘Ne name agou pepa la yeregane waha tedu bonahe, 80nga yeregau tuwai.’ ");
INSERT INTO eri_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ariya, iinga saini fai anyakaro no nomo hoobu fai dada onowai waha torobadu bona, no hoobu fai inyaba waha nomo unyi isouwai, taate bona, no fai ninau bagu dorofe onowou waha onowai. Nere fai oula beha nomo fanyimu oojode waha, nere nebere haruwe tei nomo jala fere-fere isi-iside, onodu nere fai lalawou nomo fanyimu oojogou waha, feiya nigou. ");
INSERT INTO eri_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ji tere letigini, tere oula beha nomo moni inyaba langa, fai-aita bagu hoyo nigadenga, nere tebere ilibatege gane heigodbode. Ono bode wonga wa, iinga saini moni yaasuwei nomo saini waha usu wonga, nere edo hatigedu bode, mata hilobainga gai-gai yafei nomo langa manodbode. ");
INSERT INTO eri_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Fai ete no dada menakele ete oofadena wa, no dada anyakaro fere oofade wonbona. Fai no dada mene-mene onowou tigini la ada onona waha, no dada aroro fere onowou tigini la ada ono wona. ");
INSERT INTO eri_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tere moni inyaba oula beha nomo oofa dewei nomo ada isiya waha, faiwei no dada tigini waha oofa dewei nomo tigona? ");
INSERT INTO eri_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tere fai ete nomo dada oofade fuwegu uwa wonga, faiwei no tere tage tebere dada tigona? ");
INSERT INTO eri_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Haruwe magana ete no hoobu fai nga neire haruwe magana yafei nomo edo uwa. No ete gau tubona, ete bona huwanya inyaba wonbona. No ete bolou oojo bona, ete moge tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ariya, Farisi nere moni gau nigigai. Onou waha bode, saini Yesus no beele beha oruwa lewainga isidu bode, nere memesi tuwane. ");
INSERT INTO eri_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ono wanenga, Yesus no lenigai, “Tere fai‑aita bagu benou isi tigei nomo gau tigina, tere fanyimu tigini wahanga ono-onoyawou. Ariya Itou no dada oruwa tere tebere huwanyatege langa huwari inyina waha, no isina. Dada fai nere hilobainga tigini iwou iside waha, Itou ago la no dada gai inyabanga inyaba. ");
INSERT INTO eri_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nuuni beele bagu, profet nebere beele bagu, inyi gainga mai Jon nomo saini langa edowai. Ono wainga Jon nomo saini la hugu waridu Itou nomo huuna langa yafou waha nomo hilou beele ha-ha oruwa langa heigai. Onou waha bona, nere fai-aita oruwa, nomo huuna langa yafou waha huwanya goyei nomo danga tetede. ");
INSERT INTO eri_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ha taene, oula bagu usu wonbona. Ariya, nuuni beele nomo matau menakele ete te ada usu wona.” ");
INSERT INTO eri_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yesus no ege onou lenigai, “Taate fai ete, no nomo oya awa tudu bona, no aita ete tona wa, no longi tafana. Ete fere, fai ete no aita ete nomo au amina awa tuwai waha tena wa, no fere longi tafana.” ");
INSERT INTO eri_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus no ege onou lewai, “Amina moni fai ete yafai, no saini oruwa siot hilou-hilou, kolos giriwou hilobainga waha tanigai. Ono bona no fati oruwa da hilou-hilou nyigai. ");
INSERT INTO eri_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ariya, moni fai waha nomo mata arasae yugumu la, fai dadamu uwau ete walanga inyigai. Fai dadamu uwau waha nomo unyi Lasarus, no moni fai waha nomo tewol huuna langa, da matau orososo gogunga edo la elegedu nyonbona waha ninau isidu, walanga inyigai. No gogala la ju baingaro gaane katigai, ono gainga gauna maidu bode ju waha hemuge fugane. ");
INSERT INTO eri_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ariya, iinga fai dadamu uwau waha no umainga, ensel nere haudu tamani tafa tuwanenga Abraham ngare yafare. Ono gainga, moni fai waha fere umainga u-u tanane. ");
INSERT INTO eri_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","No fai amina umane waha nebere haumu langa yafa bona jimiri anyakaro tai. No igei wainga manainga Abraham gai baae langa Lasarus ngare yafa garenga nerirai. ");
INSERT INTO eri_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Onodu moni fai no benou yaurai, ‘Jijei Abraham, ji bonahe aau naronga Lasarus letuwahenga, owo jirou yaage kobomudu tamai munyagefe la yokomu wonga, menenga oto wona tuwai. Ji eeya beha langa oto boni, jimiri gai danga bagu isini.’ ");
INSERT INTO eri_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ono wainga Abraham no letuwai, ‘Magana, ne dada ete beha bonahe ninate isau. Saini ne agene auma yafena la, ne dada hilobainga, hilobainga oruwa elegene. Ono gene, Lasarus no dada inyaba oruwa elegai. Ariya elebe haumu beha langa, no huwanya hilobainga inyi ganga, ne jimiri anyakaro teni. ");
INSERT INTO eri_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ariya dada ete fere, Itou no ere bagu tere bagu gamagege langa, no beberu anyakaro ete tafai inyina. Onou waha bona, fai belanga yafade nere beberu waha fadu ulate tere yafaya langa goyei nomo edo uwa. Nere fai walanga yafade fere nere beberu waha fadu bode, ulate belanga mayei nomo edo uwa.’ ");
INSERT INTO eri_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ono wainga, moni fai waha no Abraham letuwai, ‘Onou wonga jijei, ji ne isoki hinini, ne Lasarus edo huuru tuwahenga yame jijei nomo mata langa goyona. ");
INSERT INTO eri_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ji yame baabo gane 5 yafade. No goidu beele danga bagu lenigonga, nebere onowou tiginimu wode. Gamaji nere fere jimiri anyakaro tegou ha belanga mayoguga.’ ");
INSERT INTO eri_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ono wainga, Abraham no letuwai, ‘Name baine gane nere Moses nomo beele, profet nebere beele inyina waha edo lelegedu isode.’ ");
INSERT INTO eri_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ono wainga, moni fai waha no lewai, ‘Jijei Abraham, wa edo uwa. Umou fai ete no matmat la jaidu bona goi lenigonga wa, nere edo langa huwanyanege ubulu wodbode.’ ");
INSERT INTO eri_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ono wainga Abraham no benou letuwai, ‘Nere Moses nomo beele bagu profet nebere beele bagu ada iside wonga, edo nere fai umou matmatha ege jaidu beele lenigode, waha fere nere huwanyanege ada ngalenga wona.’” ");
INSERT INTO eri_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ariya, Yesus no nomo disaipel benou lenigai, “Dada hogo fere-fere nere fai-aita bagu ono nigonga une langa orososowei nomo waha heigonbona. Fai no, dada waha ono gonga heigona waha, no augami bagu. ");
INSERT INTO eri_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","No magana mene‑mene beha, nebereha ete ono tuwonga, no une langa metaumei mata wonga, hilobainga, nere fai waha boou langa megebu anyakaro ete dage fudu bode, hiiri langa tekaite tuwogunga minidu umona. Onou waha bona, tere tage bonade oofa dewagu. ");
INSERT INTO eri_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Name baine no une tafei mata wonga, ne nomo onowou tiginimuwei nomo letuwau. Ono wahenga, no huwanya ubuluwei mata wonga, ne nomo une uulu fuwau. ");
INSERT INTO eri_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","No fati etenga la ne une langa tafa hini 7-du bona, no ege ne bagu mai 7-du lehinona, ‘Ji aau yarina,’ hini bona wonga, ne nomo une uulu fuwau.” ");
INSERT INTO eri_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ariya, Aposel nere Anyakaro benou letuwane, “Ne ere ebere huwanyage ngalengawou ono wahenga gai anyakaro heigona.” ");
INSERT INTO eri_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ono wanenga, Anyakaro no lenigai, “Edo tere tebere huwanyatege ngalengawou menakele mene sayori fatu menekele mene mastet ide waha dorofe, tere edo langa nauge waha letuwagu ganga, ‘Name bou faasidu bonahe, mini hiiri langa otowau,’ ono wadenga, nauge no tere tebere bolotege oojo wonbona.” ");
INSERT INTO eri_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus no ege benou lewai, “Tere gama langa fai ete no nomo haruwe magana ete huuru tuwonga haga langa oula tale warei nomo yo, uwa, sipsip oofa nigei nomo yo goidu bona, saini no ege gidu mata langa mayona la, no nomo fai anyakaro no benou letuwona ru, ‘Ne fasayadu mai yafadu bonahe da nyau?’ ");
INSERT INTO eri_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Uwa. Fai Anyakaro no haruwe magana letuwon bona, ‘Ne ogola tagudu bonahe, yame da haiyadu, waridu tetamai hayau. Ji amugedu da nyidu boni, yaage nyehenga, iinga ne dabu da nyi bonahe yaage nyau.’ ");
INSERT INTO eri_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ono wonga, fai anyakaro no nomo haruwe magana nomo beele oojo fuwaha, waha bona no hilobainga tuwonbona yo? Uwa. ");
INSERT INTO eri_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onou dorofenga tere fere, Itou no letigai onounga tere dada oruwa ono borowei mata bonade wonga, tere lewagu, ‘Ere haruwe magana hilou uwa. Dada ere onoya waha, ere eberenga haruwe.’” ");
INSERT INTO eri_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus no Jerusalem jala oojodu goi bona Samaria distrik, Galili distrik bagu gama langa golodu manai. ");
INSERT INTO eri_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","No golodu mani matane ete la heige gainga, nere lepra taura bagu fai 10 mai no jala gama la toroba tuwane. Onodu nere baae la oto bode, ");
INSERT INTO eri_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","inyangaro benou yaurane, “Fai anyakaro Yesus, ne ere bonahe edo augami hinou.” ");
INSERT INTO eri_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ono wanenga, no nerigedu bona lenigai, “Tere goidu bonade, tebere getege gala Pris abitimu nigagu nigai.” Ono wainga, nere golodu goi ganenga nebere genege gala hilobainga heigai. ");
INSERT INTO eri_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ono wainga, fai ete nere gamanege langa, no nomo gogala urai wa, ege hilobainga heigai, ono wainga no ege gidu goyai. No inyangaro yaure bona, Itou unyi isouwai. ");
INSERT INTO eri_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","No goi Yesus bagu heigedu bona, Yesus afo hugu langa afo tuburu kutudu, hogo oula igei tubona Yesus hilobainga tuwai. Ariya no waha, Samariaha fai. ");
INSERT INTO eri_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ono wainga, Yesus no fai waha uredu bona lewai, “Ji isinaha, nere fai 10 genege gala hilobainga heigaha, nere fai 9 ila waha alanga yafade? ");
INSERT INTO eri_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Adadu, fai gidu mai Itou unyi isouwei nomo uwau rute? Fai beha no ha fereha, no nogonga Itou hilobainga tuwaha.” ");
INSERT INTO eri_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Onodu Yesus no fai waha benou letuwai, “Ne jaidu bonahe goyau. Ne name huwanyate ngalengawou waha la, ne ege hilou heigenaha.” ");
INSERT INTO eri_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi nere Yesus benou isoki tuwane, “Taate saini Itou nomo huuna la yafou waha heigonbona?” Ono wanenga, Yesus no nebere beele gidu benou lenigai, “Saini Itou nomo huuna la yafou heigona la, fai-aita bagu agenege langa, dada naani dorofe heigonga ada urode. ");
INSERT INTO eri_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ono wonga nere benou ada lewode, ‘Uragu, benu inyina,’ o ‘No ulate langa wonu inyina.’ Tere isagu. Itou nomo huuna la yafou waha tere gamatege la amina inyina.” ");
INSERT INTO eri_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Onodu bona, Yesus no nomo disaipel benou lenigai, “Iinga saini heigonga, tere Fai Nomo Idau gidu mayei nomo fati ete urei nomo bonade, gaude tigonbona. Ono wagu wa, tere ada uragu ganga. ");
INSERT INTO eri_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ono wadenga, nere benou letigodbode, ‘Uragu, no ulate wolanga yafana,’ o nere letigodbode, ‘No benu yafana.’ Ariya tere goidu bonade nere adai oojo nigagu. ");
INSERT INTO eri_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tere isiya, saini biyai fililaina waha no ha taene oruwa la laladu goi-goina. Onou dorofe, Fai Nomo Idau heigei nomo saini langa, nere fai-aita oruwanga urodbode. ");
INSERT INTO eri_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ariya ngasunga, no jimiri baingaro tonga, nere fai saini elebe beha nomo waha, nere no moge tuwodbode. ");
INSERT INTO eri_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Fanyimu nere Noa nomo saini langa ono wane onounga, Fai Nomo Idau mayei nomo saini langa fere onounga ono wodbode. ");
INSERT INTO eri_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nere da nyi bode, yaage nyi bode, aita fai bagu te guru bode yafa gane saini langa, Noa no waaga digedu huwanya goyai. Ono gainga, yaage kuwei anyakaro medu bona, nere fai-aita bagu oruwanga inyabamu nigai. ");
INSERT INTO eri_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ariya, Lot nomo saini langa fere, nere fai-aita bagu oruwanga onounga ono wane. Nere da nyi bode, yaage nyi bode, nere dada ejiyadu huuru bode, nere haga te bode, nere mata tau bode yafane. ");
INSERT INTO eri_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nere onou ono ganenga, Lot no Sodom awadu bona goi gainga fati wahanga la, eeya, megebu salfa bagu ha taene langa medu yaage dorofe fai-aita bagu oruwanga inyabamu nigai. ");
INSERT INTO eri_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ariya, Fai Nomo Idau malala heigei nomo fati langa onowou onounga heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Fati waha langa, fai ete no nomo mata ouwe langa yafei mata wona waha, no nomo dada jauli langa otode waha, elegei nomo bona adai goyou. Onou dorofenga, fai ete no haga langa golowei mata wona waha, no ege gidu mata langa adai mayona. ");
INSERT INTO eri_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tere Lot oya langa dada heigai bonade ninatege isagu. ");
INSERT INTO eri_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Fai ete no nogo nomo ago auma yafou yaasuwei mata bona wonga, no nomo ago auma yafou yae wonbona. Onou wa, fai ete no nomo ago auma yafou awa bona wonga, no nomo ago auma yafou hilobainga inyonbona. ");
INSERT INTO eri_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ji tere letigini, saini ooru la Fai Nomo Idau mayona wa, fai nga nononga kabali etenga la jiri gorunga, Itou no ete hau bona, ete awa tuwonga inyonbona. ");
INSERT INTO eri_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Aita nga nononga, nere beret bitei nomo wit falaua ubulumu gorunga, Itou no ete hau bona ete awa tuwonga yafonbona.” ");
INSERT INTO eri_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Disaipel nere beele waha isidu bode, Yesus benou isoki tuwane, “Anyakaro, dada waha alanga heigonbona?” Ono wanenga, Yesus no benou lenigai, “Haumu nere fai umane genege gala jiride langa, haumu wahanga la nere mojenga mai komo-komode.” ");
INSERT INTO eri_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ariya, Yesus no nomo disaipel muuji beele ete, nere gai-gai hauyawei nomo hogonyi adai nigou bona, no isisiwou nigai. ");
INSERT INTO eri_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","No benou lenigai, “Taon ete langa jas ete yafai. No Itou bona ada umugegai, fai bona fere ninau inyangaro ada isigai. ");
INSERT INTO eri_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ono gainga, aita oyo ete no taon waha langa yafagai. Saini oruwa no maidu bona, jas letugai, ‘Yame honggoro fai no ji inyabamu hiyona ono-onona. Ne ji kot langa hoyo hiyau.’ ");
INSERT INTO eri_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ono wainga jas no ngasunga hoyo tuwei nomo awai. Ariya, iinga la no ninau benou isai, ‘Ji Itou boni umugei uwa, ji nere fai boni ninafe inyanga isei uwa. ");
INSERT INTO eri_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Onou wa, aita oyo beha no gai-gai ji ou hiingana. Waha bona, ji edo kot langa hoyo tuwon boni. Gamaji no ji bagu gai-gai mainga wonga, ji no nomo beele oruwa isei nomo geefe hogonyi woga.’” ");
INSERT INTO eri_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ariya, Anyakaro no ege benou lewai, “Tere jas inyaba waha nomo beele isiyaha. ");
INSERT INTO eri_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Onou waha adadu? Itou no nere fai-aita bagu, nomo bona hangada nigai waha, nere hoonga ooru bagu oruwa mere tunga wode waha, Itou no nere ada hoyo nigona yo? No itari bona fasadu ada hoyo nigona yo? Uwa. ");
INSERT INTO eri_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ji letigini, no fasayadu hoyo nigonbona. Ariya, saini Fai Nomo Idau mayona langa, no fai-aita bagu oula langa yafade waha, huwanyanege ngalengade yo, uwa yo, waha uronbona.” ");
INSERT INTO eri_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nere fai ila ninanege iside, nere nage nere fai tigini, ariya nere fai ila nere dorofe tigini uwa. Ariya, Yesus no muuji beele nere fai benouha bona lenigai. ");
INSERT INTO eri_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nere fai nga nononga, hauyawei nomo bodere tempel la manare. Ete no Farisi, ete no takis tegou fai. ");
INSERT INTO eri_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ariya, Farisi waha oto bona, no nogo nomo huwanya langa benou hauyawai, ‘O Itou, ji nere fai ila dorofe uwa, waha boni ji ne hilobainga hinini. Nere yebu bode onowou tigini waha ada ono bode, aita fai bagu waha inyabamu nigi-nigide. Ariya, ji nu uwa. Ji takis tegou fai beha dorofe uwa. ");
INSERT INTO eri_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ji bori oruwa la, fati nga da urigei nomo hangada-hangadani. Onodu boni, dada oruwanga ji elegeni waha foure 10-du boni, ulate ete ne hini-hinini.’ ");
INSERT INTO eri_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ariya, fai takis tegou waha baae la oto bona, ha laluwa igei tuwei nomo awai. Onodu no nogo bura wari bona lewai, ‘Itou, ne ji bonahe aau narou, ji une fai.’” ");
INSERT INTO eri_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ono wainga Yesus no lenigai, “Ji tere letigini, Saini takis tegou fai waha, gidu nomo mata langa minai la, no nogonga Itou ago langa fai tigini heigai. Ariya fai ete waha no uwa. Taate bona, fai ourwa nere nage unyinege isou wode wa, Itou no nere unyinege esenemu nagonbona. Ariya, fai nere nage unyinege esenemude waha, Itou no nere unyinege isou nagonbona.” ");
INSERT INTO eri_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nere fai-aita bagu magana mene-mene hanigedu Yesus bagu mayane, nere magana mene-mene eeme aare nigide waha fere hanigedu mayane. Nere gau wane wa, no magana mene-mene jaulanege langa owo tafonbona. Ono wane wa, disaipel nere waha uredu bode, fai-aita bagu honggoro nigane. ");
INSERT INTO eri_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ono wanenga, Yesus no magana mene-mene yaure nigainga hinomu langa mayanenga, no nomo disaipel benou lenigai, “Tere magana mene-mene awa nigadenga, ji bagu mayode. Tere adai karu nigagu. Itou nomo huuna langa yafou waha, nere fai magana mene-mene benouha dorofe, waha nebere. ");
INSERT INTO eri_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ji tere ngalenga letigini, fai no Itou nomo huuna langa yafou nere magana mene-mene tede dorofe ada tebona wonga wa, no huwanya langa goyei nomo edo uwa. Gai uwanga uwa.” ");
INSERT INTO eri_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mora bagu ete no Yesus isoki tuwai, “Isisi higigou fai hilobainga, ji adadu onodu boni agefe auma gai-gai yafou hilobainga toni?” ");
INSERT INTO eri_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ono wainga, Yesus no letuwai, “Ne taate boni ji fai hilobainga hini? Itou no nogonga hilobainga. ");
INSERT INTO eri_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ne nuuni beele amina isene, ‘Tere fai-aita te guruya waha, longi adai tafagu. Tere fai-aita ila adai dunege kote wagu. Tere adai yebu wagu.’” Tere fai-aita bagu ila beele yaawawou la, kot langa adai tafa nigagu. Tere anyatege ametege gane nebere huuna la yafa bonade, nebere beele oojo wagu.’ ");
INSERT INTO eri_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ono wainga, mora bagu no benou letuwai, “Saini ji magana menakele la mai elebe, ji nuuni beele waha oruwa oojo wene.” ");
INSERT INTO eri_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ono wainga, Yesus no beele waha isidu bona mora bagu letuwai, “Ne dada etenga bona gai tutu hinina. Ne name dada oruwanga huurudu bonahe moni waha tedu, nere fai-aita dadanege uwau waha wese nagau. Ne onou ono bonahe wonga, ne ha laluwa la dada hilobainga tigini bagu. Onodu bonahe, ne mai ji oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Onowai wa, mora bagu no beele waha isidu bona, no huwanya ou dewai, taate bona, no dada baingaro bagu. ");
INSERT INTO eri_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus no mora bagu waha huwanya ou dewainga uredu bona benou lewai, “Nere fai dada baingaro waha, Itou nomo huuna langa yafou, waha huwanya la goyei nomo haruwe danga todbode. ");
INSERT INTO eri_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ariya, kamel no kolos ereregou niili yogodi langa goyei nomo wa ababiwou uwau. No moni fai, Itou nomo huuna langa yafou waha huwanya la goyei nomo ababina dorofe uwa.” ");
INSERT INTO eri_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ono wainga, nere fai beele waha isidu bode benou lewane, “Onou wa, faiwei no agege auma gai-gai hilobainga yafou waha edo langa tonbona?” ");
INSERT INTO eri_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ono wanenga, Yesus no lenigai, “Dada fai onowei nomo edo uwa waha, Itou no edo ono wonbona.” ");
INSERT INTO eri_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ono wainga Pita no lewai, “Isau. Ere ebere matane dada bagu awaruyaha ne oojo hiniya.” ");
INSERT INTO eri_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ono wainga Yesus no benou lenigai, “Ji tere ngalenga letigini, fai nere Itou nomo huuna langa yafou waha bode isidu, nere nebere mata bagu, oyanege gane bagu, bainege gane bagu, amenege anyanege gane bagu, magana bagu awa nigide waha, ");
INSERT INTO eri_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","saini nere oula beha langa yafa gogunga, Itou no dada elebe nere bagu inyina waha feiyadu baingaro nigonbona. Onodu saini iinga huunta heigona waha langa, nere agenege auma gai-gai hilobainga yafou waha todbode.” ");
INSERT INTO eri_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus no nomo disaipel 12, hanigedu bona lenigai, “Tere isagu. Elebe ere Jerusalem goyo boya. Nere profet amina beele oruwanga, Fai Nomo Idau langa dada heigonbona yeregane waha, elebe tigini heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nere no fai fereha owonege langa tafa tuwodbode. Ono wogunga, nere no memesi tubode, inyabamu tubode, bisinga tuwodbode. ");
INSERT INTO eri_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Onodu nere no gula tudu bode, dukote wogunga umonbona. Ono wogunga fati eei langa no ege gidu jayonbona.” ");
INSERT INTO eri_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ariya nomo disaipel nere beele waha nomo hugu ada iside. Taate bona, beele waha nomo hugu huwarimu nigainga, nere no beele lewai waha bode fo nigi dewei uwa. ");
INSERT INTO eri_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Saini Yesus no mai Jeriko taon jugu gainga, fai ete ago fosokowou no jala hinemu la yafa bona, fai-aita bagu moni dada bona malagau nigai. ");
INSERT INTO eri_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ono gainga, nere fai-aita toomaro golodu mai ganenga isidu bona, no fai benou isoki nigai, “Nere taate adade?” ");
INSERT INTO eri_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ono wainga, nere letuwane, “Yesus Nasaretha golowaha maina.” ");
INSERT INTO eri_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ono wanenga, no yauredu letuwai, “Yesus, ne Devit Idau, ne ji bonahe augamu hinou.” ");
INSERT INTO eri_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ono wainga, nere fai amugedu mayane waha, nere honggoro tubode letuwane, “Ne hurate fosokowau.” Ono gane uwa, fai waha no ege-ege yaurenga bona lengawai, “Ne Devit Idau, ne ji bonahe augami hinou.” ");
INSERT INTO eri_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ono wainga, Yesus no maidu oto bona, fai waha haudu no bagu mayei nomo bona lenigai. Saini no mai jugu tuwainga, Yesus no benou isoki tuwai, ");
INSERT INTO eri_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ji ne adadu ono hinei nomo gau hinina?” Ono wainga no letuwai, “Anyakaro, ji agefe igeiwei nomo gau hina.” ");
INSERT INTO eri_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ono wainga Yesus no letuwai, “Name agene edo hilou wona. Ne name huwanyate ngalengawou waha weenga, jigemu hinaha.” ");
INSERT INTO eri_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ono wainga fasadu onou, nomo ago jige tuwainga, no ege igeiwai. Onodu no Yesus oojo tudu goi bona, Itou unyi isouwai. Ono wainga, nere fai-aita bagu oruwanga waha uredu bode, nere fere Itou unyi isou wane. ");
INSERT INTO eri_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus no Jeriko taon huwanya langa goidu bona, no taon awa tuwonbona jala oojowai. ");
INSERT INTO eri_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ono gainga, fai ete unyi Sakius, no taon walanga yafai. No takis tegou fai nebere mora bagu, onodu no moni baingaro. ");
INSERT INTO eri_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","No Yesus fai adoha waha uronbona onowai. Ariya nere fai-aita bagu toomaro, no fai tutu mene. Waha bona no Yesus urei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Onou waha bona, no fai-aita bagu toomaro feiya nigidu bona, guriyedu mani fik nauge ete digai, onodu no Yesus edo langa uronbona. No isai, Yesus no jala onou langa golodu mayonbona. ");
INSERT INTO eri_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ono gainga, Yesus no golodu mani haumu walanga heige bonanga, no nauge ouwe langa igei wainga manainga letuwai, “Sakius, ne fasayadu heigedu mau. Elebe ji name mata langa yafon boni.” ");
INSERT INTO eri_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ono wainga, Sakius no fasayadu heigedu mai, no huwanya edega gainga Yesus hawainga nomo mata langa goyare. ");
INSERT INTO eri_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ono wainga, nere fai oruwanga waha uredu honggoro bode benou lewane, “No goyaha fai ete une tafagou nomo mata langa yafana.” ");
INSERT INTO eri_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nere mata langa yafa bode, Sakius no jaidu oto bona Anyakaro letuwai, “Anyakaro ne isau. Ji elebe yame dada oruwanga foure ngadu, matau ulate nere fai dadanege uwau waha nigon boni. Onodu ji fai ete yaawa tudu boni nomo dada ete yebu tei mata wene wonga wa, ji nomo dada agou aise tuwonboni.” ");
INSERT INTO eri_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ono wainga Yesus no benou letuwai, “Itou no nere fai-aita bagu mata beha nomo elebe ege gidu hanigaha. Fai beha fere, no Abraham idau. ");
INSERT INTO eri_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Fai Nomo Idau no fai nere yae wane waha, kuru nigidu ege gidu hanigei nomo mai.” ");
INSERT INTO eri_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nere fai-aita bagu Yesus beele lenigi gainga aagu bode yafa ganenga, no muuji beele ete fere lenigai, taate bona, no Jerusalem amina mani jugu tuwai. Ono wainga nere isane, elebenga Itou nomo huuna la yafou malala heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Onodu no benou lewai, “Fai anyakaro ete, nere king hangada tuwei nomo bona, matane ete baae langa goyonbona. Onodu no iinga ege nomo matane hugu langa gidu maidu, no nomo gane oofa nigonbona. ");
INSERT INTO eri_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ariya, saini no goyona ono bona, no nomo haruwe magana 10, yaure nigainga mayanenga, no 20 kina 20 kina wese nagai. Onodu benou lenigai, ‘Tere moni beha elegedu, haruwe tubonade yafa gadenga, ji ege gidu mayon boni.’ ");
INSERT INTO eri_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ono wainga nere fai nomo matane etenga waha no bode huwanyanege inyaba dewai. Onou waha bode, no goi faga gainga, nere fai ila huuru niganenga beele tedu, matane fai anyakaro goyai waha langa goyane. Nere goidu lewodbode, ‘Ere fai waha no ebere king yafei nomo awaya.’ ");
INSERT INTO eri_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ono wane uwa, nere fai waha hangada tuwanenga king heigai, iinga no ege gidu mayai. No maidu bona lenigai, ‘Nere haruwe magana ji amina moni wese nagene waha, yaure nigadenga mayode. Ono wogunga ji nere moni wese nagenenga nere haruwe tuwane waha, nomo profit fai etenga-etenga oruwanga agonyi heigemu wane waha ison boni.’ ");
INSERT INTO eri_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ono wainga, haruwe magana ete no amugedu mayai waha, no letuwai, ‘Anyakaro, ji ne name moni 20 kina hiyene waha haruwe tudu boni, ji profit 200 kina teneha.’ ");
INSERT INTO eri_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ono wainga, king no magana waha letuwai, ‘Ne haruwe magana hilobainga, waha boni ne haruwe te dewene. Ne dada menakele mene waha, ne oofa deweneha, onou waha bona, ji elebe ne taon 10, oofawei nomo hangada hinini.’ ");
INSERT INTO eri_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ono wainga, haruwe magana nga waha no maidu bona letuwai, ‘Anyakaro, ji ne name moni 20 kina hiyene waha la haruwe tudu boni, ji nomo profit 100 kina teneha.’ ");
INSERT INTO eri_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ono wainga king no letuwai, ‘Ji ne taon 5 oofawei nomo tafa hinini.’ ");
INSERT INTO eri_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ono wainga haruwe magana ete no maidu bona letuwai, ‘Anyakaro, name moni 20 kina hiyene wa, ji hankisip ete la ngaradu boni, huwarimu wene inyai waha benu, ");
INSERT INTO eri_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","taate bona, ji ne neriyeni wa, ne fai ngasu bagu. Dada fai ila tafa gane inyi ganga, ne te-teni. Ono boni, da fai ila tatarude waha fere, ne elege-elegeni. Onou waha boni, ji ne umuge hinene. ");
INSERT INTO eri_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ono wainga king no letuwai, ‘Ne haruwe magana inyabanga inyaba! Ne nage name beele lewou wahanga la, ji ne kot la tafa hinon boni. Ne ji fai ngasu baguwou ne isini, ji nere fai ila dada logoside waha elege-elegeni, onodu nere fai da tatarude waha fere elege-elegeni. ");
INSERT INTO eri_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ariya ne taate boni yame moni benk langa tafa hayei uwa, ono wagenga, ji ege gidu mai nomo profit ila bagu teege?’ ");
INSERT INTO eri_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Onodu no fai hinomu langa oto wane waha benou lenigai, ‘Tere no la moni 20 kina waha ngau tedu bonade, fai 200 kina bagu waha tuwagu.’ ");
INSERT INTO eri_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ono wainga, nere letuwane, ‘Fai Anyakaro, no amina 200 kina bagu waha.’ ");
INSERT INTO eri_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ono wanenga, no lenigai, ‘Ji tere letigini, nere fai oruwa dada ila bagu waha, ji nere ege ila nigonboni. Ariya, fai ete no dada uwau wonga, no dada menakele mene yaasuna waha, ji ngaau elegonboni. ");
INSERT INTO eri_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ariya yame honggoro fai nere ji nebere king yafei nomo awane waha, hanigedu belanga maidu bonade, ji agefe langa dunege kote wadenga umeru wode.’” ");
INSERT INTO eri_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus no muuji beele waha lenigi borodu bona, no ege nomo jala golowou hugu waridu bona, jala oojodu Jerusalem manai. ");
INSERT INTO eri_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesus no mani muju Oliv ide, matane Betfage Betani bagu jugu langa heigedu bona, disaipel nga nononga huuru niri bona ");
INSERT INTO eri_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","benou lenirai, “Tere matane inyina woha langa goyaru. Tere matane waha langa goidu bonadere, tere donki gila ete nere amina menanga te digedu yafegu uwa waha, do tuwogunga oto gonga uraru ganga. Tere nomo maalu futu fudu, haudu belanga tamayaru. ");
INSERT INTO eri_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ariya, fai ete no benou isoki tirei mata wonga, ‘Tere taate boyare donki maalu futu fuyare?’ Onou letironga, tere benou gidu letuwaru, ‘Anyakaro no langa haruwe bagu.’” ");
INSERT INTO eri_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Onodu Yesus no nere huuru nirainga goidu bodere, dada oruwanga no lenirai onounga urare. ");
INSERT INTO eri_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nere donki gila waha nomo maalu futu fugarenga, nere donki waha morou benou isoki nirane, “Tere taate boyare donki waha nomo maalu futu fuyare?” ");
INSERT INTO eri_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ono wanenga nere lenigare, “Anyakaro no langa haruwe bagu.” ");
INSERT INTO eri_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Onodu nere donki waha haudu Yesus tamai fuware. Onodu bodere nere neire kolos ufaro waha, donki jaula langa jimaware. Onodu nere Yesus hoyo tuganenga mani donki jaula ouwe langa yafai. ");
INSERT INTO eri_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","No donki jaula langa yafadu golodu goi gainga, nere fai-aita bagu nebere kolos ufaroro uludu bode, jala langa jima fuwane. ");
INSERT INTO eri_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Saini no mai jala ulate Oliv muju awa tudu minou jugumu gainga, nomo disaipel toomaro edegawou hugu warane. Nere dodokawou oruwanga urane waha bode ninanege isi bode, nere inyangaro yaure bode, Itou unyi isou wane. ");
INSERT INTO eri_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nere benou yauredu lewane, “Itou no edo king beha figini tuwonbona, no Anyakaro unyi langa maina. Itou Gai Ouwe langa yafana waha unyi isou wagu! No ere fai-aita bagu ono higi ganga huwanyage foinga inyina.” ");
INSERT INTO eri_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ono ganenga, nere Farisi ila fai-aita toomaro gamanege langa oto bode, Yesus benou letuwane, “Isisi higigou fai, ne name disaipel nere beha honggoro nigau. Nere beele onou adai lewogu.” ");
INSERT INTO eri_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ono wanenga Yesus no benou lenigai, “Ji tere letigini, nere huranege fosokowei mata wogunga wa, megebu nere nage yaure bode, Itou unyi isou wodbode.” ");
INSERT INTO eri_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus no Jerusalem heigei nomo jugu bona, no taon uredu mere tuwai. ");
INSERT INTO eri_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","No mere bona benou lewai, “Jerusalem, elebe fati behanga la ne dada edo langa ono hinonga hilobainga yafei nomo waha, isau ganga gau hina. Ariya, dada waha no huwari inyina, ne ada urau ganga. ");
INSERT INTO eri_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne isau. Iinga saini ete heigonga, name honggoro fai maidu bode, name orei anyakaro kolili bode, oula komomu gogunga ouwe langa manonbona. Onodu bode, nere haumu oruwa kolilidu, kati hinodbode. ");
INSERT INTO eri_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Onodu nere foure hinidu inyabamude hinodbode, ne name magana gane bagu name huuna langa yafaya waha. Ono bode, name megebu ete ada awogunga, megebu ilibumu jaula la inyona, taate bona, saini Itou no ne hoyo hinei nomo mayai waha, ne isei uwa.” ");
INSERT INTO eri_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ariya, Yesus no tempel orei huwanya la goidu bona, no fai moni kusewou haruwe te bode yafa ganenga so nigou hugu warai. ");
INSERT INTO eri_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","No benou lenigai, “Itou nomo buk no beele benou bagu, ‘Yame mata hauyawou mata inyonbona.’ Ariya tere ubulumu tuyanga goi yebu fai nebere huwarigou haumu dorofe heigaha.” ");
INSERT INTO eri_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Onodu Yesus no fati oruwa la, fai-aita bagu tempel nomo orei huwanya langa isisiwou nigigai. Ono gainga nere pris aroro bagu, nere nuuni beele isou fai bagu, nere fai-aita nebere mora bagu, nere Yesus dukotewei nomo jala kuruwou hugu warane. ");
INSERT INTO eri_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ono wane wa nere fai-aita bagu oruwanga nomo beele isei nomo danga tafane, ono wanenga mora bagu no dukotewei nomo jala ete uregu uwa. ");
INSERT INTO eri_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Fati ete langa Yesus no tempel nomo orei huwanya langa, fai-aita bagu hilou beele malalamudu lenigai. Ono gainga nere Pris aroro bagu, nere nuuni beele isou fai bagu, nere mora bagu, no bagu mayane. ");
INSERT INTO eri_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nere benou letuwane, “Ne lehigau, ne unyite anyakaro, danga beha bagu alanga tene, waha bona ne dada beha ononi? Faiwei ne unyinte anyakaro hinai?” ");
INSERT INTO eri_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ono wnenega no ege gidu lenigai, “Ji fere dada ete boni isoki tigon boni, tere lehiyagu, ");
INSERT INTO eri_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","saini Jon no fai yaage bisemu nigai waha tere isiya, dada waha no ha laluwa nomo yo, uwa, ewe fai neberenga dada?” ");
INSERT INTO eri_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ono wainga nere nage-nage leguru wane, “Ere benou lewoya wa, ‘Dada waha no ha laluwa nomo,’ wa no lehigoga, ‘Onou wa, tere taate boya Jon boya huwanyatege ngalenga wegu uwa?’ ");
INSERT INTO eri_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ariya ere benou letuwoya, ‘Wa ewe fai neberenga dada,’ fai oruwanga ere megebu ayaru hagoguga, taate bona, nere oruwa huwanyanege danga bagu ngalengana, Jon no profet.” ");
INSERT INTO eri_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Onou waha bode, nere Yesus nomo beele benou letuwane, “Ere Jon no fanyimu alanga tedu fai-aita bagu yaage bisemu nigai waha ere alai uwa.” ");
INSERT INTO eri_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ono wanenga Yesus no benou lenigai, “Ji fere onounga, ji haruwe teni beha faiwei unyife anyakaro hiyai waha ji ada letigon boni.” ");
INSERT INTO eri_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ariya, Yesus no fai-aita bagu muuji beele ete benou lenigai, “Fai ete no wain haga tedu bona wain tatarudu, wain haga waha nere fai ila haruwe tebode moni kusewei nomo owonege la tafai. Onodu no nogo goidu bona, saini ufaro matane ete baae langa yafai. ");
INSERT INTO eri_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ariya wain nauge nomo hilou heigou saini langa, no haruwe magana ete huuru tuwainga, nere fai nomo wain haga la haruwede waha bagu goyai. No haga waha nomo da ila tuwei nomo gauwai. Ono wainga, nere fai haga langa haruwe taane waha haruwe magana waha waridu bode, so tuwanenga ewenga goyai. ");
INSERT INTO eri_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ono wanenga no haruwe magana ete ege huuru tuwainga goyai. Ono wainga, waha fere onounga, nere waridu bode inyabamu tudu so tuwanenga, ewenga goyai. ");
INSERT INTO eri_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ono wanenga, no ege haruwe magana eei waha huuru tuwainga nere bagu goyai. Ono wainga nere waridu inyabamude tudu so wanenga malala heigai. ");
INSERT INTO eri_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ono wanenga, haga morou no lewai, ‘Ji elebe adadu onowoni? Ji yame magana gaude tuni waha, huuru tuwon boni. Ono wehenga, nere nomo beele edo isode rute.’ ");
INSERT INTO eri_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ono wainga nere fai haga haruwe taane waha, nomo idau mai gainga uredu, nere nage-nage benou leguru wane, ‘Fai woha, no iinga gonga nomo umamu nomo dada oruwanga elegonbona. Ere no dukote wedenga umonga, ere hage haga beha toboya.’ ");
INSERT INTO eri_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Onodu nere so wanenga haga dui langa goyainga dukote wanenga umai. “Ariya, tere adadu isiya, wain haga waha morou no fai waha adadu ono nigonbona? ");
INSERT INTO eri_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","No maidu bona fai haga langa haruwe tede waha dunege kote wonbona. Onodu wain haga waha fai ila nigonbona.” Ono wainga nere fai beele waha isidu bode lewane, “No onou adai onowou.” ");
INSERT INTO eri_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ono wanenga Yesus no feele nigi bona lenigai, “Nere taate bode Itou nomo buk langa beele beha yeregane inyina, ‘Megebu beha, nere kamda inyaba idu bode te kaitane waha, no elebe mata gulu dangamuwei nomo megebu amugou heigai?’ ");
INSERT INTO eri_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nere fai oruwanga megebu waha jaula langa taumeru wode wa, nere furususu wodbode. Ariya, megebu waha fai ete jaula langa meboduwei mata wonga, no gai inyabamude tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nere nuuni beele isou fai bagu, nere pris aroro bagu benou isane Yesus no muuji beele beha nere bona lewai. Onodu bode, saini wahanga la, nere Yesus yaasu tuwodbode ono wane. Ono wane wa, nere fai-aita bagu bode umugane. ");
INSERT INTO eri_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Onodu bode pris aroro bagu, nuuni beele isou fai bagu, nere Yesus oofade tuwane. Nere fai ila huwari Yesus nomo beele aaguwei nomo huuru niganenga mayane. Nere fai waha yaawawou, nere tigini Yesus nomo beele aaguwei nomo gaude nigai. Onodu nere yaawa tuwogunga no beele ete nere kot langa tafa tuwei nomo edo waha lewonga, nere edo langa gabman amugou owo langa tafa tuwogunga, no Yesus edo langa kot langa tafa tuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Onodu bode nere benou isoki tuwane, “Isisi higigou fai, ere isiya ne name beele tigini, ne fai-aita bagu beele tigini lenigi-nigini. Ne fai-aita oruwa, edo nere unyinege bagu, o nere unyinege uwau, ne beele hogo etenga wahanga lenigi-nigini. Ono boni ne beele ngalenga langanga, Itou nomo fanyimu bona, nere fai-aita bagu, isisiwou nigi-nigini. ");
INSERT INTO eri_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ariya, ne adadu isini? Ere Sisar takis edo tuwoya yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ono wane wa, Yesus no nebere yaawa beele waha amina isai. Onou waha bona, no lenigai, ");
INSERT INTO eri_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni ete abitimu hiyagu. Ariya anu beha, unyi bagu moni langa inyina waha, faiwei nomo?” Ono wainga nere letuwane, “Sisar nomo.” ");
INSERT INTO eri_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ono wanenga no lenigai, “Ariya, dada Sisar nomo waha, tere Sisar tuwagu. Dada Itou nomo waha, tere Itou tuwagu.” ");
INSERT INTO eri_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Onou waha bona saini no fai-aita bagu gaara yafa gogunga, nere yaawa tudu nomo beele ete tedu, nomo beele waha langa no kot langa tafa tuwei nomo edo uwa. Nere no beele ege gidu lenigai waha bode, horotodu huranege fosokodu yafane. ");
INSERT INTO eri_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi nebereha ila Yesus bagu mayane. Sadyusi nere waha benou le-lede, nere fai umane waha ege ada jayodbode. ");
INSERT INTO eri_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Nere fai waha Yesus benou letuwane, “Isisi higigou fai, Moses no beele ete benou yerege hagai. Fai ete no aita tedu bona iinga no magana bisei uwa langa umei mata wonga, no nomo bemu no bemu oyomu tedu bona nomo magana heigemu fuwonbona. ");
INSERT INTO eri_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ariya amina nere bemu, bemu 7 yafane. Motuwa no aita tedu bona, magana uwau langa no umai. ");
INSERT INTO eri_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ono wainga, nomo mogo taga tuwou no bemu oyomu tedu umai. ");
INSERT INTO eri_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ono wainga, bainege eei, no fere onounga onowai. Nere fai bemu, bemu 7 waha nere oruwanga aita waha tedu bode, nere magana uwau langa umeru borowane. ");
INSERT INTO eri_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ono wanenga, iinga aita waha fere no umai. ");
INSERT INTO eri_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ono wane waha nere fai umeru wane waha saini nere ege jayode langa, aita waha no faiwei nomo oya tigini yafona? Ne isini, nere fai 7 no te tuwanenga no nebere aita yafai.” ");
INSERT INTO eri_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ono wanenga, Yesus no lenigai, “Nere fai-aita bagu elebe saini beha nomo waha, nere te guru-gurude. ");
INSERT INTO eri_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ariya Itou no iinga huunta langa, nere fai-aita bagu ege jaidu bode no ngate agenege auma yafode waha nere ada te guru wode, ");
INSERT INTO eri_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","taate bona, nere ege ada umode. Itou no matmat langa amina jaimu nigai, waha bode nere nomo magana ensel dorofe yafodebode. ");
INSERT INTO eri_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ariya, Moses fere ere benou abitimu higai, nere fai umedu ege matmat la jai-jaide. Nauge menakele mene eeyawai waha nomo aasa langa no lena, ‘Anyakaro no Abraham nomo Itou, no Aisak nomo Itou, Jekop nomo Itou yafana.’ ");
INSERT INTO eri_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ariya, beele beha no benou abitimu higina, Itou no nere fai umeru wane waha nebere Itou uwa. No nere fai agenege auma yafade waha nebere Itou. No ago langa nere fai-aita oruwanga agenege auma yafade.” ");
INSERT INTO eri_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ono wainga, nere nuuni beele isou fai ila Yesus nomo beele waha isidu bode, benou letuwane, “Isisi higigou fai, ne name beele wa hilobainga.” ");
INSERT INTO eri_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Onodu fai nere Yesus beele ete ege isoki tuwei nomo umugane. ");
INSERT INTO eri_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ariya, Yesus no fai-aita bagu benou isoki nigai, “Adadu bona nere benou lelede, fai Itou no nomo fai-aita bagu ege gidu hanigei nomo hangada tuwai wa, Devit idau? ");
INSERT INTO eri_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ariya Buk Song langa, Devit no nogo benou lewai, ‘Anyakaro no yame Anyakaro benou letuwai, “Ne yame owofe hilou langa yafa gahenga goi ");
INSERT INTO eri_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ji name honggoro fai name huuna langa logosi nigehenga yafodbode.” ’ ");
INSERT INTO eri_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tere uragu. Devit no nogo fai waha yame Anyakarowou lewai. Ariya, adadu bona fai waha no Devit idau?” ");
INSERT INTO eri_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nere fai-aita bagu oruwanga, Yesus nomo beele aagu bode yafa gane, no nomo disaipel benou lenigai, ");
INSERT INTO eri_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tere nuuni beele isou fai bonade ure dewagu. Nere kolos ufaroro elege jiridu bode, golodu goyei nomo gaude nigi-nigina. Nere fai-aita bagu kotowou haumu langa kaiye nigei nomo gaude nigi-nigina. Nere bori mata huwanya la, haumu amugou langa yafei nomo gaude nigi-nigina, da ajou anyakaro langa nere sia amugou la yafei nomo gau nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nere aita oyo yaawa nigi bode, nebere mata yebu-yebude. Ono bode, nere yaawawou langa, hauyawou ufaro hauya-hauyade. Waha bona kot saini langa, nere ou gai anyakaro waha todbode.” ");
INSERT INTO eri_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ariya, Yesus no igei bona yafa gainga, nere moni fai maidu tempel nomo moni bogisi langa, nebere toota tafa ganenga nerigai. ");
INSERT INTO eri_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ono ganenga aita oyo ete no dadamu uwau, moni mene-mene nga nononga bogisi langa ayaru gainga urai. ");
INSERT INTO eri_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ono wainga, Yesus no lenigai, “Ji tere ngalenga letigini, aita oyo dadamu uwau, fai ume tuwai beha no moni anyakaro fai-aita bagu oruwanga feiya nigou aya waha nigai. ");
INSERT INTO eri_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nere fai-aita waha oruwanga moni baingaro inyai, ariya nere mataunga aya wane. Ariya aita waha no tutude tuwai, no moni da ejiyawei nomo yaasuwai waha, oruwanga aya borowai.” ");
INSERT INTO eri_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nere fai ila Itou tempel uredu bode benou lewane, “Nere megebu hilou-hilou elegedu toota hilobainga hogo fere-fere fai-aita bagu Itou tuwanenga nere mata waha mujarimu dewane.” Ono wanenga Yesus no lewai, ");
INSERT INTO eri_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ji dada elebe, tere ureya beha boni letigon boni. Saini heigonga nere megebu waha nomo ete te ada awa tuwogunga, megebu ete jaula la inyona. Uwa. Nere oruwanga koresedu ayaru wogunga orososo wodbode.” ");
INSERT INTO eri_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ono wainga fai nere Yesus isoki tuwane, “Isisi higigou fai, taate saini langa dada waha heigonbona? Taate naani ete amugedu heigonga, ere isei nomo edo, dada waha heigona juguna?” ");
INSERT INTO eri_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ono wanenga Yesus no lenigai, “Tere ure dewagu. Gamaji nere yaawa tigoguga. Taate bona, fai baingaro maidu bode, ji unyife te bode lewodbode, ji we ji fai waha. ‘Saini amina mai jugu waha.’ Ono wogunga tere goi nere adai oojo nigagu. ");
INSERT INTO eri_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Onodu iinga gonga, nere kantri oota anyakaro jaimudewou isidu, tere amugedu adai terere wagu. Nere dada waha amugedu heigodbode, ariya fati usuwou no fasadu ada heigona.” ");
INSERT INTO eri_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Onodu bona no ege benou lenigai, “Nere fai ila nere fai fereha-fereha bagu oota jaimu wodbode. Ono gogunga, king ila nebere fai nere king fereha-fereha nebere fai bagu oota jaimu wodbode. ");
INSERT INTO eri_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nere mimi aroro oula langa heigodbode. Ono gogunga, ha fere-fere langa maau anyakaro bagu, taura anyakaro bagu heigodbode. Ono gogunga taene langa tere naani anyaroro onodu dada hogo fere-fere heige gogunga uredu umugagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ariya, dada waha oruwa heigei uwa inyi gonga, nere yaasu tigidu bode inyabamu tigodbode. Onodu nere bori mata huwanya langa tere kot langa tafa tigidu bode, dagou mata langa tafa tigodbode. Nere ji unyife ileiwei nomo ninanege isidu, tere hatigedu king gabman bagu agenege langa togoi tafa tigogunga oto wagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ono wode waha, no edo tebere jala dorofe inyi gonga, nere hilou beele malalamudu lenigagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Onou waha bona tere fasadu, nere taate beele ege gidu lenigei nomo idu bonade, ninatege baingaro ada isagu, ");
INSERT INTO eri_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","taate bona, ji yage we beele tere huratege langa tafon boni, ono boni ji tere isou hilobainga tigon boni. Ono wehenga, nere kot langa tafa tigei nomo ono wode wa, nere beele ji letigini waha ada feetodu ilei wode. ");
INSERT INTO eri_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ametege anyatege gane, baitege gane, ganetege etenga, tebere ilibatege gane, nere fere tere honggoro fai owonege langa tafa tigodbode. Onodu bode nere tebere gane ila dunege kote wogunga umeru wodbode. ");
INSERT INTO eri_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ariya, nere fai oruwanga tere bode huwanyanege inyaba dewodbode, taate bona, yame unyife tere langa inyina. ");
INSERT INTO eri_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ono wode wa, tere tebere moratege langa tawatege gala ete te ada huwari wona. ");
INSERT INTO eri_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tere danga bagu yafadu bonade, tere tebere agetege auma yafou tedu, hilobainga yafagu.” ");
INSERT INTO eri_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Yesus no ege benou lewai, saini nere oota fai maidu bode Jerusalem kolili tudu inyi gogunga nerige bonade wa tere isagu, taon inyabawei nomo saini mayaha juguna. ");
INSERT INTO eri_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ono gogunga, saini waha langa nere fai-aita Judia distrik langa yafade waha, haradu bode muju langa manogu. Ono gogunga, nere fai Jerusalem huwanya langa yafade waha, nere taon awa tudu, haradu bode haumu fere langa goyogu. Ariya nere fai taon gisa langa yafade waha nere taon huwanya langa adai goyogu. ");
INSERT INTO eri_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Saini waha no Itou no nyabuluwou agou nigei nomo saini, onou waha bona, beele oruwa Itou nomo buk langa inyina waha no ngalenga tigini onou heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ariya saini waha langa, nere aita genege bagu, nere aita magana eeme aare nigide waha, nere agenege gami bagu. Taate bona, ou anyakaro tigini oula belanga heigonbona, ono gonga Itou nomo houmu mayou nere fai-aita waha jaulanege la monbona. ");
INSERT INTO eri_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Honggoro fai maidu dunege kote wogunga umeru wodbode. Onodu hanigedu togoi oula nomo kantri oruwa langa dagou mata langa tafa nigogunga yafodbode. Ono wogunga, fai fereha nere afenege Jerusalem ilei gogunga, goi Itou no fai fereha Jerusalem oofawei nomo hangada nigai waha usuwou langa, edo wonbona.” ");
INSERT INTO eri_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesus no ege benou lewai, “Saini waha langa, naani hogo fere-fere hoonga bagu, ole bagu, baatu bagu la heigonbona. Ono gonga, oula langa fai oruwa aau togode nagi gonga, hiiri kouwou nomo bolou anyakaro, hiiri la aagudu ninanege baingaro isi bode, danga bagu umugodbode. ");
INSERT INTO eri_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nere fai-aita baingaro, dada oula langa heigonbona waha bode ninanege isi bode, danga bagu umugedu agenege gui wonbona, taate bona, ha taene nomo dada danga bagu waha yoku wodbode. ");
INSERT INTO eri_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Saini waha langa, nere fai-aita bagu Fai Nomo Idau no agao ete la, nomo danga anyakaro, lala anyakaro bagu megonga urodbode. ");
INSERT INTO eri_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Onou waha bona, saini dada waha hugu waridu heige gonga, tere jaidu moratege isoudu bonade oto wagu, taate bona, Itou no tere ege gidu hatigei nomo saini amina mai jugu waha.” ");
INSERT INTO eri_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesus no muuji beele ete benou lenigai, “Tere fik nauge uredu, nauge ila fere nerigagu. ");
INSERT INTO eri_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Saini tere ure geyenga, no nomo gala ege rugu ganga tere isiya, inyeru saini heigona onona. ");
INSERT INTO eri_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Onounga, saini tere dada waha heigonga ure bonade wonga, tere isagu, Itou nomo huuna la yafei nomo saini amina mai jugu waha. ");
INSERT INTO eri_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ji tere ngalenga letigini, nere fai-aita elebe saini beha nomo oruwanga umeru wegu uwa langa, dada waha oruwa heigonbona. ");
INSERT INTO eri_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ha taene oula bagu goi usu wonbona, ariya yame beele no ada uwa wona.” ");
INSERT INTO eri_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ariya, Yesus no ege benou lewai, “Tere ure dewagu. Gamaji tere saini oruwa yaage kejiwe nyi bonade, sipak waguga. Ono bonade gamaji getege gala nomo dada bonadenga, ninatege baingaro isaguga. Ariya, onowou onouha kutau tigonga wa, Anyakaro nomo fati tere langa fasadu heigonbona, ");
INSERT INTO eri_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kaafa boloba langa goide dorofe, taate bona, fati waha no fai-aita bagu oruwa ha-ha oruwa langa yafade waha langa heigonabona. ");
INSERT INTO eri_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Onou waha bona, tere saini oruwa oofadu yafagu. Ono bonade, tere gai-gai Itou danga tigei nomo hauya tuwagu. Ono wagu wa, dada waha oruwa heigona wa, tere feiya bonade, Fai Nomo Idau ago langa oto wagu ganga.” ");
INSERT INTO eri_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ariya fati oruwa, Yesus no fai-aita bagu tempel nomo orei huwanya langa isisiwou nigigai. Ono bona ooru la no mani, muju ete Oliv ide walanga mata ete otogai, no walanga agore inyigai. ");
INSERT INTO eri_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ono gainga, nere fai-aita bagu oruwanga eringe amina jaidu bode, nomo beele aaguwei nomo bode tempel langa mani gane. ");
INSERT INTO eri_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ariya, Beret Yis Uwau ide waha Nomo Fati Anyakaro. Fati Itou No Israel Awa Nigainga Hilobainga Yafane waha Ninanege Isei Nomo Fati Anyakaro heigai. ");
INSERT INTO eri_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ono wainga, nere Pris aroro bagu, nere nuuni beele isou fai bagu, nere fai-aita bagu umuge nigidu, Yesus dukotewei nomo bode jala kuruwane. ");
INSERT INTO eri_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ono wanenga, Satan no Judas Iskariot tude waha, no huwanya langa goyai. No Yesus nomo disaipel 12 waha nebereha ete. ");
INSERT INTO eri_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","No goidu Pris aroro bagu, tempel nomo kepten bagu, jala kurudu Yesus nere owonege langa tafei nomo bona beele ngado wane. ");
INSERT INTO eri_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ono wainga, nere no urei nomo edega wane, onodu no moni ila tuwei nomo bode letuwane. ");
INSERT INTO eri_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ono wanenga, Judas no nebere beele waha bona edo nigai, onodu no Yesus nere owonege langa tafei nomo bona jala kurungawai. No saini ete nere fai-aita toomaro, Yesus ngate ada yafode waha itariwai. ");
INSERT INTO eri_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Beret Yis Uwau Nomo Fati Anyakaro heigai. Nere fati waha langa Itou No Israel Awa Nigainga, Hilobainga Yafane Waha Ninanege Isei nomo bode, sipsip magana waha ayei nomo dukote wodbode. ");
INSERT INTO eri_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Waha bona Yesus no Pita, Jon ngare huuru nirai goi garenga benou lenirai, “Tere goidu bonadere, fati anyakaro waha nomo, ebere da haiya waru nirai.” ");
INSERT INTO eri_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ono wainga, nere isoki tuware, “Ne gauni, ere goi haumu alanga haiya woyare?” ");
INSERT INTO eri_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ono warenga, no lenirai, “Tere isaru. Tere taon huwanya langa goi gaderenga, fai ete no yaage tauwe anyakaro langa aulona waha, jala la toroba tironbona. Ono wonga, tere fai waha oojo tudu mata huwanya no goyona waha langa goyaru. ");
INSERT INTO eri_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Onodu tere mata morou waha benou letuwaru, ‘Isisi higou fai no lehinaha, “Jauli adiha waha ji yame disaipel bagu Fati Itou No Israel Awa Nigainga Hilobainga Yafane waha ninage isou da nyoboya?” ’ ");
INSERT INTO eri_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ono waderenga, no jauli anyakaro ete ouwe langa inyina, tewol bagu, sia dada bagu, waha abitimu tironbona. Ono wonga, tere da jauli walanga haiyawaru.” ");
INSERT INTO eri_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ono wainga, nere goidu bodere, dada oruwanga Yesus no nere lenirai onou urare. Onodu bodere da haiya ware. ");
INSERT INTO eri_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Da nyou saini heige boro wainga, Yesus no tewol langa yafai, ono gainga nomo aposel no ngate gaara yafane. ");
INSERT INTO eri_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Onodu no benou lenigai, “Fati Itou No Israel Awa Nigainga Hilobainga Yafane Waha Ninage Isei Nomo Fati Anyakaro langa tere bagu da nyei nomo gaude hina. Onodu iinga gonga, ji jimiri aulon boni.” ");
INSERT INTO eri_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","“Ji tere letigini, ji da beha ege ada nyoni, goi saini dada beha Itou nomo huuna langa yafou la tigini heigonbona.” ");
INSERT INTO eri_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Onodu bona, no kap wain bagu ete tedu, Itou hilobainga tudu bona lenigai, “Tere beha tedu bonade, tere gamatege langa wese wagu. ");
INSERT INTO eri_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Taate bona, ji tere letigini, elebe bagu iinga bagu ji wain ege ada nyoni, goi saini Itou nomo huuna la yafou heigona la.” ");
INSERT INTO eri_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Onodu bona no beret ete tedu, Itou hilobainga tudu bona, no beret waha lalatidu no nomo disaipel nigai. Onodu bona lenigai, “Beha waha yame geefe gala, ji tere hoyo tigei nomo boni tigini. Tere onou ono bonade ji bonade ninatege isagu.” ");
INSERT INTO eri_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ariya, saini nere nyi boro wanenga, no kap wain bagu tedu bona, onounga onowai. Onodu lenigai, “Kap wain beha waha, beele bara tawou eege, ji yame ganefe langa ononaha, ji tere hoyo tigei nomo boni feuni. ");
INSERT INTO eri_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ariya uragu, fai no ji honggoro fai owonege langa tafa hiyonbona waha no ji ngare tewol langa yafayare. ");
INSERT INTO eri_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Fai Nomo Idau no jala amina Itou no hangada fuwai waha oojo wonbona. Onou wa, fai no honggoro fai owonege langa tafa tuwona waha no augami bagu.” ");
INSERT INTO eri_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Disaipel nere beele waha isidu bode, jaidu nere nage-nage benou isoki guruwane, “Faiwei no onou ono wonbona?” ");
INSERT INTO eri_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ariya, disaipel nere faiwei no nebere amugou, waha bode beele langa warawou hugu warane. ");
INSERT INTO eri_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ono wanenga, Yesus no benou lenigai, “Nere fai-aita fereha nebere king nere unyinege bagu, waha bona nere oofa nigi-nigide, onodu nere unyinege benou bagu, nere fai fanyimu hilobainga ono nigou. ");
INSERT INTO eri_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ariya tere onou adai ono wagu. Uwa. Fai no tere gamatege langa amugou yafana waha, no fai tigini huunta heigai dorofe yafona. Ariya, tebere mora bagu no tebere hoyo tigou haruwe fai dorofe yafona. ");
INSERT INTO eri_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Isagu. Faiwei no amugou? Fai no da nyi bona yafana waha yo, uwa haruwe magana no da uudu tamai funa waha? Fai no yafa bona da nyina, no waha wenga amugou. Ariya, ji tere gamatege langa hoyo tigei nomo haruwe fai dorofe yafani. ");
INSERT INTO eri_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ariya, saini dada ji wala-wala hiyei nomo heigane waha, tere ji awa hiyegu uwa, tere ji ngate yafei. ");
INSERT INTO eri_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yame Jijei no nomo huuna langa yafou waha hiyaiha, onou dorofenga, ji yame huuna langa yafou waha tigini. ");
INSERT INTO eri_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Onodu yame huuna la yafou langa, tere yame tewol langa yafa bonade da yaage bagu nyagu ganga. Ono bonade tere sia hilobainga langa yafa bonade, nere Israel 12 waha oofa nigagu ganga.” ");
INSERT INTO eri_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ariya Yesus no benou lewai, “Saimon, Saimon, ne isau. Satan no tere tebere huwanyatege ngalengawou wala-wala tagei nomo amina lewaiha, fai wit nomo tuturumu haawewei nomo ono-onode dorofe. ");
INSERT INTO eri_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Onou wa, ji ne name huwanyate ngalengawou adai taumoga bona, hoyo hinidu hauyanaha. Saini ne ubuludu ege gidu maidu, ne name baine gane dangamu nigau.” ");
INSERT INTO eri_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ono wainga, Pita no benou letuwai, “Anyakaro, ji ne ngare dagou mata langa goyei nomo haiyanaha yafani. Ji ne ngare umei nomo fere haiyanaha.” ");
INSERT INTO eri_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ono wainga, Yesus no letuwai, “Pita, ji ne lehinini elebe ooru beha langa teewe warei uwa inyi gonga, saini waha langa ne le eei wau ganga, ji no boni alai uwa.” ");
INSERT INTO eri_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesus no nomo disaipel lenigai, “Saini ji tere huuru tigenenga yame haruwe tei nomo goiyei la, tere tebere moni fausi bagu, olodo bagu su bagu auledu goyegu uwa. Saini waha langa, tere dada ete boya tutu tigai yo, uwa?” Ono wainga nere uwa tuwane. ");
INSERT INTO eri_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ono wanenga, no benou lenigai, “Onou wa, elebe fai no moni fausi bagu yo, olodo bagu yo, wa no edo tonbona. Ariya fai no oota kesebu uwau wonga wa, no nomo saket huurudu bona moni tedu oota kesebu ete ejiya wona. ");
INSERT INTO eri_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Taate bona, Itou nomo buk langa beele beha bagu, ‘Fai-aita bagu nere no fai inyaba ete dorofe urane.’ Onou bona ji tere letigini, fai-aita bagu nere onowou beha ji langa ono wodbode. Taate bona, dada oruwanga Itou nomo buk langa lena waha, ji langa onou tigini heigonbona.” ");
INSERT INTO eri_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ono wainga, nere letuwane, “Anyakaro, ne urau. Ere oota kesebu nga nononga benu inyina.” Ono wanenga no lenigai, “Wa edola.” ");
INSERT INTO eri_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ariya, Yesus no taon awadu bona Oliv muju langa manai, no gai-gai ono-onona onou. Ono gainga, nomo disaipel taga tuwane. ");
INSERT INTO eri_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","No mani, muju waha langa heigedu bona, nomo disaipel benou lenigai, “Wala-walawou tere la heigoga bona, tere hauya wagu nigai.” ");
INSERT INTO eri_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Onodu bona, nere awa nigidu menanga onou golodu baae langa goyai, fai megebu kaite ganenga goi meboduna, onou la. Onodu no afo tuburu kutudu bona, benou hauyawai, ");
INSERT INTO eri_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Jijei, ne gau hinei mata wonga, kap beha edo aririmu hayau. Ariya, ne ji yame gauwou adai oojowau. Uwa. Ne name gauwou wahanga oojowau.” ");
INSERT INTO eri_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ono gainga, ha laluwa nomo ensel ete medu bona, no dangamu tuwai. ");
INSERT INTO eri_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus no ou gai inyaba waha isidu bona, no ege danga bagu hauyawai. Ono gainga, nomo ngisiramu ganemu dorofe heigedu bona, oula langa orosowai. ");
INSERT INTO eri_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","No hauya borodu bona, no jaidu nomo disaipel bagu goyai. Onodu bona, nere agore jiri ganenga nerigai, taate bona nere huwanyanege ou dewai. ");
INSERT INTO eri_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Onodu, no lenigai, “Tere taate boya agore jiriya? Tere jaidu bonade, hauya wagu. Gamaji wala-walawou tere langa heigonga, tere taumagu ganga.” ");
INSERT INTO eri_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ariya Yesus no beele lebona oto gainga, nere fai toomaro mayane. Fai Judas tude waha no disaipel 12 waha nebereha ete, no amuge nigidu bona jala abitimu nigi gainga mayane. No Yesus uumba tuwonbona hinomu langa mayai. ");
INSERT INTO eri_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ono wainga, Yesus no benou isoki tuwai, “Judas, ne Fai Nomo Idau uumba tuwou langa, nere honggoro fai owonege la tafa tuwau ganga ninate isinaha yo?” ");
INSERT INTO eri_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ono wainga, disaipel nere Yesus ngate yafane waha, dada heigona ono gainga uredu bode letuwane, “Anyakaro, ne ere oota kesebu langa dunege kotewei nomo gau hinina yo?” ");
INSERT INTO eri_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ono ganenga, nebereha ete oota kesebu tedu bona Pris, ete nomo haruwe magana warainga ooto kesebu, nomo agokuli ulate owo hilou langa waha, saludu kaitainga meboduwai. ");
INSERT INTO eri_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ono wainga Yesus no waha uredu bona lewai, “Onowou waha awagu.” Onodu bona, no fai waha nomo agokuli langa owo tafainga, nomo agokuli ege hilobainga heigai. ");
INSERT INTO eri_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Onodu bona, Yesus no Pris aroro bagu, tempel nomo kepten bagu, nere mora bagu, no yaasu tuwodbode mayanenga lenigai, “Tere oota nomo kesebu bagu, dumuga bagu elegedu warawou fai yo yebu fai ete dorofe, yaasu tuwagu ganga maiyaha, onou yo? ");
INSERT INTO eri_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Fati oruwa, ji tere bagu tempel langa yafa gene, ariya tere owotege ji la tafegu uwa. Onou bona elebe saini beha tere tebere saini. Elebe agugu nomo danga, lalawou feiya tuwaha.” ");
INSERT INTO eri_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ariya Yesus no beele leboro wainga, nere yaasu tudu bode haudu minane. Nere no haudu bode, Pris mora bagu nomo mata huwanya langa goyane. Ono ganenga, Pita no nere oojo nigidu goyai, no menanga onou baae la otowai. ");
INSERT INTO eri_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ariya, fai ila nere mata waha nomo orei huwanya langa eeya ujidu bode yafane. Ono ganenga, Pita no nere ngate yafai. ");
INSERT INTO eri_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ono gainga, haruwe aita ete no eeya langa yafa gainga uredu bona, no tigini Pita feele tubona lewai, “Fai beha fere, no Yesus ngate yafa gane.” ");
INSERT INTO eri_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ono wainga Pita no kakiri bona lewai, “Aita, ji no boni ada isini.” ");
INSERT INTO eri_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iinga menanga onou, fai ete fere no Pita uredu bona lewai, “Ne fere, nebereha ete.” Ono wainga Pita no lewai, “Ji nomo disaipel uwa.” ");
INSERT INTO eri_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ono gainga, menanga awa etenga onou goyainga, fai ete no beele danga bagu benou lewai, “Ngalenga tigini, fai beha fere no Yesus ngate yafa gane. No Galiliha fainga.” ");
INSERT INTO eri_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ono wainga Pita no lewai, “Ne beele leni beha ji tigini alai uwa.” No onou legainga, fasadu onou teewe kokorokowai. ");
INSERT INTO eri_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ono wainga, Anyakaro no ubuludu bona, Pita feele tuwai. Ono wainga, Pita no beele Anyakaro letuwai waha bona ninau ege isai. No letuwai, “Elebe ooru beha langa, saini teewe warei uwa inyi gonga, ne ji unyife kakiri eei wau ganga. Ne lewau ganga, ji no boni alai uwa.” ");
INSERT INTO eri_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Onodu Pita no malala heigedu goidu inyangaaro merai. ");
INSERT INTO eri_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ariya nere fai Yesus yaasu tuwane waha, nere no memesi tubode warane. ");
INSERT INTO eri_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nere ago ogola langa dage fudu bode, benou isoki tuwane, “Elebe ne profet beele lewau. Faiwei ne narina?” ");
INSERT INTO eri_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ono bode, nere beele inyaba baingaro ila fere letuwane. ");
INSERT INTO eri_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Saini hoonga mai gainga, fai-aita bagu nebere mora bagu mai komo wane, ono gane nere nuuni beele isou fai fere mayanenga gaara komo wane. Onodu bode, nere Yesus haudu nebere kaunsel langa goidu letuwane, ");
INSERT INTO eri_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ne lehigau, ne beha Itou no nomo fai-aita bagu ege gidu hanigei nomo hangada hinai yo, uwa?” Ono wanenga no lenigai, “Ji tere letigei mata wehenga, tere huwanyatege ada ngalenga wona. ");
INSERT INTO eri_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ariya, ji tere beele ila boni isoki tigehenga wonga, tere yame beele ege gidu ada lewagu ganga. ");
INSERT INTO eri_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Onou wa, elebe bagu iinga huunta saini oruwa la, Fai Nomo Idau no Itou danga oruwa bagu, nomo owo hilou langa yafonbona.” ");
INSERT INTO eri_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ono wainga, nere oruwanga isoki tuwane, “Onou waha bona, ne nage ne Itou Idau yo?” Ono wanenga no lenigai, “Tere tage leyaha, wa ji wenga.” ");
INSERT INTO eri_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ono wainga nere lewane, “Ere fai beha nomo onowou malalamudu lewei nomo fai ada yaure nigoya. No nogo nomo hurau langa beele waha lewanga, ere amina isiyaha.” ");
INSERT INTO eri_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ariya, nere fai aroro waha oruwanga jaidu bode, Yesus haudu Pailot bagu goyane. ");
INSERT INTO eri_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Onodu nere hugu waridu kot benou letuwane, “Ere fai beha ureya wa, no ere ebere fai-aita bagu nebere fanyinege hilalamuna. No ere moni Sisar tuwei nomo karu higina. Ono bona no lelena, ji yage ji king waha, Itou nogo nomo fai-aita bagu ege gidu hanigei nomo hangada hiyai.” ");
INSERT INTO eri_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ono wanenga, Pailot no Yesus isoki tuwai, “Ne Juda nebere king yo?” Ono wainga Yesus no Pailot beele ege gidu letuwai, “Ne nage leni onounga.” ");
INSERT INTO eri_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ono wainga, Pailot no Pris aroro bagu, nere fai-aita bagu benou lenigai, “Ji nyabuluwou ete fai beha langa urei uwa.” ");
INSERT INTO eri_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ono wainga nere beele gai danga bagu benou lewane, “No fai-aita bagu isisiwou nigi bona, huwanyanege jaimu nagi bona, Judia nomo haumu oruwa langa golo-golona, Galili distrik langa hugu waridu me ebere taon langa edo-edona.” ");
INSERT INTO eri_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ono wanenga, Pailot no beele waha isidu bona, benou isoki nigai, “Fai beha no Galiliha yo?” ");
INSERT INTO eri_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Saini Pailot no isai wa, Yesus no oula ulate Herot oofana walaha mayai. Onou waha bona, Yesus no huuru tuwainga Herot bagu goyai. Saini waha langa, Herot no Jerusalem langa yafai. ");
INSERT INTO eri_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot no Yesus uredu bona danga bagu edegawai. No nomo beele amina isai, onodu saini ufaro no urona onowai. No Yesus dodokawou ete tafonga urei nomo bona onowai. ");
INSERT INTO eri_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Waha bona, Herot no Yesus dada baingaro bona isoki tuwai. Ono wainga Yesus no beele ete te ege gidu letuwei uwa. ");
INSERT INTO eri_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ono wainga, Pris aroro bagu, nuuni beele isou fai bagu, nere maidu hinomu langa oto bode, no go bode danga bagu kot wane. ");
INSERT INTO eri_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ono wanenga, Herot no nomo oota fai bagu, nere Yesus sei tubode, memesi tuwane. Onodu, nere kolos hilobainga ete tedu bode no tagumu tudu, ege huuru tuwanenga gidu Pailot bagu goyai. ");
INSERT INTO eri_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Amina Herot no Pailot ngare, nere gamanere langa honggoro inyigai. Ariya elebe saini beha langa, nere huwanyanere etenga heigare. ");
INSERT INTO eri_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ariya, Pailot no Pris aroro bagu, nere mora bagu, nere fai-aita bagu fere yaure nigainga mai komowane. ");
INSERT INTO eri_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ono wanenga no benou lenigai, “Tere fai beha haudu maidu boya lehiyei, no fai-aita bagu nebere onowou hilalamu nagina. Ariya saini tere yafei langa, ji dada waha boni isokide tuwene. Waha bona tere isagu. Ji fai beha nomo nyabuluwou ete torobawei uwa. Tere no kot langa tafa tuyaha waha, ji no dada waha nebereha ete, ono waha wou isei uwa. ");
INSERT INTO eri_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot no fere isou etenga onounga, waha bona, no fai beha huuru tuwanga ere bagu ege gidu mayaha. Isagu. Fai beha no nyabuluwou ete onowei uwa, onou bona, ji no edo umonbona wou lewei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Waha bona, ji no falagati uulu tudu awa tuwehenga goyonbona.” ");
INSERT INTO eri_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ono wainga nere fai-aita bagu oruwanga, inyangaaro yauredu benou lewane, “Fai waha dukote bonade, Banabas awa tuwadenga ere bagu mayona.” ");
INSERT INTO eri_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ariya Banabas no nebereha ete amina oota ete gabman bagu taon huwanya langa jaimudu, no fai dukote wainga umai. Onou bona nere dagou mata langa tafa tuwane. ");
INSERT INTO eri_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ariya Pailot no Yesus awa tuwonga goyonbona waha beele ege lenigai. ");
INSERT INTO eri_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ono wainga nere yauredu benou lewane, “Du kote wagu! Du kote wagu! Nauge abalakawou langa waragu!” ");
INSERT INTO eri_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ono wanenga, Pailot no ege le nigi eei wai, “Taate bona? No taate dada nyabulu waha? Ji nyabuluwou ete no dukote wedenga umei nomo torobawei uwa. Onou waha boni ji no falagati uulu tudu awa tuwehenga goyonbona.” ");
INSERT INTO eri_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ariya nere danga tafane, ono bode inyangaaro yaure tunga wane. Nere nebere bolonege waha we, Pailot nomo beele ileiwai. ");
INSERT INTO eri_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ono wanenga, Pailot no nere nebere beele oojodu Yesus edo umonbona lewai. ");
INSERT INTO eri_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Fai-aita bagu nere, fai no gabman bagu oota jaimudu fai dukote wainga Rom nere dagou mata langa tafa tuwane fai waha, Pailot no awa tuwei nomo yauredu letuwane. Ono wanenga, Pailot no awa tuwainga goyai. Onodu Pailot no nere nebere gauwou oojodu, Yesus nere oota fai owonege langa tafa tuwai. ");
INSERT INTO eri_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ariya oota fai nere Yesus haudu goi bode, Sairiniha fai ete unyi Saimon, no golodu mai taon huwanya goyona ono gainga uredu bode yaasu tuwane. Onodu nauge abalakawou tedu aulemu tuwanenga, Yesus mogo tagawai. ");
INSERT INTO eri_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ono gainga, nere fai-aita bagu toomaro no oojo tuwane. Nere aita toomaro no bode mere bode, gugurawou moone taane. ");
INSERT INTO eri_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ono ganenga Yesus no ubuludu bona, benou lenigai, “Tere Jerusalemha aita, tere ji bonade adai meragu. Tere tage bonade bagu, tebere magana gane bonade bagu meragu nigai. ");
INSERT INTO eri_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Isagu. Iinga gonga, saini ete heigonga nere benou lewodbode, ‘Nere aita gouda waha, nere aita magana bisegu uwa waha, nere aita menanga magana eeme nigegu uwa waha, nere edo edega wode.’ ");
INSERT INTO eri_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Saini waha langa nere muju benou lenigodbode, ‘Tere kutau higidu huwarimu higagu.’ ");
INSERT INTO eri_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ariya nere fanyimu waha elebe nauge yowo bagu beha langa ono wode wa, nere taate fanyimu waha, nauge kakarege borowai waha langa ono wode?” ");
INSERT INTO eri_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oota fai nere fai nga nononga, onowou inyaba ono ware waha fere, Yesus ngate gaara dunege kotewei nomo hanigedu goyane. ");
INSERT INTO eri_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nere goi haumu ete nere lede, Mora Nomo Ngedo walanga heigane. Onodu nere haumu walanga Yesus nauge abalakawou langa tofiye tuwane. Nere fai inyaba nga waha fere, nauge abalakawou langa tofiye nirane. Ete no Yesus owo hilou langa inyai, ete no nomo owo kenau langa inyai. ");
INSERT INTO eri_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ono wanenga, Yesus no lewai, “Jijei, ne nere nebere une edo uulu nagau. Nere dada onode beha bode ada iside.” Onodu oota fai nere nomo kolos dada wesedu nere nage elegodbode waha bode satu hiri wane. ");
INSERT INTO eri_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nere fai-aita bagu igeidu oto gane, mora bagu nere Yesus memesi beele benou letuwane, “No fai ila hoyo nigigai. Ariya, no ngalenga Itou nomo haruwe ono bona, nomo fai-aita bagu ege gidu hanigei nomo hangada tuwai wonga, edo no nogo we, nogo hoyo tuwona.” ");
INSERT INTO eri_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nere oota fai fere no memesi beele letuwane. Onodu hinomu langa maidu bode dada ete winiga ide waha tuwode ono wane. ");
INSERT INTO eri_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ono bode benou letuwane, “Ne ngalenga Juda nebere king wonga, ne nage we edo hoyowau.” ");
INSERT INTO eri_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Onodu, nere beele ete yeregedu Yesus mora nauge abalakawou langa dagane. Beele yeregane wa benou, “Fai beha Juda nebere King.” ");
INSERT INTO eri_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nere fai inyaba nga Yesus ngate nauge abalakawou la kongiyemu nirane waha nereha ete no Yesus memesi beele benou letuwai, “Ne Itou hangada hinou yo? Ono wonga wa, ne nage hoyo bonahe, ere hoyo hirau.” ");
INSERT INTO eri_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ono wainga, ilibumu no waha isidu bona, honggoro tubona letuwai, “No ou taha onounga, ne fere tenaha, ariya, ne Itou boni umugei uwa yo?” ");
INSERT INTO eri_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Onodu letuwai, “Nere ere duure kote wogunga umoyare wa, nere onowou tigini la ono wodbode. Ere ou teyare beha ere eire fanyire ono were waha tigini onou langa teyare. Ariya fai beha no une ete te tafei uwa.” ");
INSERT INTO eri_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Onodu fai waha no letuwai, “Yesus, saini ne king heige bonahe, ji bonahe ninate isau tuwai.” ");
INSERT INTO eri_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ono wainga, Yesus no fai waha letuwai, “Ji ngalenga lehinini, elebe ne ji ngare ha laluwa langa yafo boyare.” ");
INSERT INTO eri_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Elebe 12 kilok onou, hoonga ago agugudu oula oruwa kutaudu onou inyi gainga, goi 3 kilok esuwa, ");
INSERT INTO eri_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","taate bona, hoonga nomo lalawou saini waha langa gai usu dewai. Ono gainga, ogola anyakaro tempel waha la kungaledu inyai waha, gama langa korai ngawai. ");
INSERT INTO eri_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ono gainga, Yesus no danga bagu yauredu lewai, “Jijei, ji yame anufe ne owone langa tafani.” No onou ledu bona umai. ");
INSERT INTO eri_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ono wainga, oota fai nebere kepten no dada waha uredu no Itou unyi isouwai. Onodu bona no lewai, “Ngalenga tigini, fai beha no fai tigini, no nyabuluwei uwa.” ");
INSERT INTO eri_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ono gainga, nere fai-aita bagu oruwa igeiwei nomo mai komo wane waha, nere dada waha heige gainga uredu aau narige gainga, buranege wari bode ege gidu nebere mata-mata goyane. ");
INSERT INTO eri_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ono ganenga, nere Yesus nomo ilibumu gane oruwa, nere aita gaara, Galili langa jaidu no oojo tudu mayane waha, nere menanga onou baae la oto bode, dada waha oruwanga heige gainga urane. ");
INSERT INTO eri_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Fai ete yafai, nomo unyi Josep. No Juda nebere taon ete, nere lede Arimatea, no fai wahaha. No fai hilobainga onodu tigini, no kaunsel ete. ");
INSERT INTO eri_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Onou wa, no kaunsel ila nebere fanyinege, ninanege bagu bona, no huwanya etengawei uwa. No Itou nomo huuna langa yafou waha urei nomo itarigai. ");
INSERT INTO eri_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Fai no waha, Yesus gogala tei nomo bona goidu Pailot isoki tuwainga edo tuwai. ");
INSERT INTO eri_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ono wainga, no Yesus gogala tedu medu bona, ogola kaamba langa ngara tuwai, onodu matmat ete huwanya langa togoidu tafa tuwai, matmat waha megebu u-u fai nere kulu wane. Ono wane waha, amina nere fai ete te walanga tafa tuwegu uwa. ");
INSERT INTO eri_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ariya, fati waha Bori nomo dada haiyawei nomo fati. Bori nomo fati heigona juguwai. ");
INSERT INTO eri_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aita nere Galili awadu Yesus oojo tudu mayane waha, nere Josep oojo tuwanenga goidu bode, matmat waha urane. Onodu nere Josep no Yesus gogala adadu tafa tuwai waha fere urane. ");
INSERT INTO eri_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nere ure borodu bode, ege gidu nebere mata langa goidu marasini hogo fere ila bagu, faronga dada agiya hilobainga waha haiya wane. Onodu bode, Bori nomo fati langa, nuuni beele lena onou nere houwe tafane. ");
INSERT INTO eri_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bori nomo fati amugou langa, gai eringe amina nere aita matmat langa goyaneha. Nere marasini dada agiya hilobainga bagu, amina haiya wane waha elegedu goyane. ");
INSERT INTO eri_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nere goidu bode, nere fai megebu matmat u-u fosoko wane waha, matmat hao langa inyi gainga uregu uwa. Nere megebu waha ubelumudu kaitane. ");
INSERT INTO eri_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Onodu bode, nere matmat u-u huwanya langa goyane wa, nere Anyakaro Yesus nomo gogala uregu uwa. ");
INSERT INTO eri_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nere Yesus nomo gogala alanga inyina waha nere alai uwa, waha bode nere ninanege baingaro isi bode oto wane. Ono ganenga fai nga nononga, neire kolos gai lala dewou, nere hinenege langa oto garenga nerirane. ");
INSERT INTO eri_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Onodu bode, nere aita umugedu dunege turigedu esene langa igei wane. Ono gane nere fai nga waha aita benou lenigare, “Tere taate boya fai ago auma waha, nere fai umeru wane waha nebere haumu langa kuru tuya? ");
INSERT INTO eri_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","No belanga inyei uwa. No amina jayaha. Tere saini no Galili langa yafa bona beele letigai waha bonade ege ninatege isagu. ");
INSERT INTO eri_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","No benou letigai, nere Fai Nomo Idau une tafagou fai owonege langa tafa tuwodbode, ono wogunga nere nauge abalakawou langa waro gunga umonbona. Onodu fati eei langa no ege jayonbona.” ");
INSERT INTO eri_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ono warenga, nere Yesus no beele amina lewai waha bode ninanege isidu, ");
INSERT INTO eri_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","matmat awadu bode, ege gidu goyane. Nere goidu bode, Yesus nomo disaipel 11 bagu, nere fai-aita ila fere oruwa, dada waha oruwa hai nagane. ");
INSERT INTO eri_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ariya, aita nere beele tamaidu Aposel lenigane waha nere benou, Maria Makdala taonha, Joana wainga, Maria Jems anya wainga, nere aita ila gaara yafade waha bagu. ");
INSERT INTO eri_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ono wanenga Aposel nere waha isidu bode, aita nere beele ewe ananu lede iwane. Onodu nere aita waha nebere beele bode huwanyanege ngalenga wegu uwa. ");
INSERT INTO eri_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ono wanenga Pita no jaidu bona guriyedu matmat langa goyai. No goidu bona, matmat u-u langa oogudu igei wainga manainga, ogolanga inyi ganenga urai. Onodu bona, no ege gidu mata langa goidu dada heigai waha bona ninau baingaro isi bona yafai. ");
INSERT INTO eri_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nere aita matmat langa goyane, fati wahanga langa Yesus nomo disaipel nga nononga nere matane ete Emeus ide, waha langa golodu goyare. Matane waha no Jerusalem gai baae tuwou, 11 kilomita onou. ");
INSERT INTO eri_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nere jala langa golodu goi bodere, dada oruwanga heigai waha bodere hai bodere goyare. ");
INSERT INTO eri_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nere beele baingaro lebodere, nere nare-nare dada waha bodere isoki guruware, ono garenga Yesus no nogo nere hinenere wanga heigainga gaara golodu goyane. ");
INSERT INTO eri_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ariya dada ete nere agenere riya narainga, nere beha Yesus iwou foo nirei uwa. ");
INSERT INTO eri_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ono warenga Yesus no benou isoki nirai, “Tere taate dada boyare leboyare goiyare?” Ono wainga, nere tonodu oto garenga neire hogonere urou wa aau narirou bagu dorofe. ");
INSERT INTO eri_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Onodu neireha ete nomo unyi Kliopas, no beele ege gidu benou letuwai, “Nere fai baingaro matane fereha-fereha elebe nere Jerusalem langa yafade. Onode waha, ne nagenga rute dada Jerusalem langa elebe saini beha langa heigaha waha ne isei uwa rute?” ");
INSERT INTO eri_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ariya no onou letuwainga, Yesus isoki nirai, “Taate dada?” Ono wainga, nere benou letuware, “Ere dada Yesus Nasaretha langa heigaha waha boyare leyare.” No profet ete, no haruwe danga bagu te bona, no beele danga bagu Itou ago langa, nere fai‑aita bagu agenege langa legaiha. ");
INSERT INTO eri_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ariya nere pris aroro bagu, ebere mora bagu, nere no gabman owo langa tafa tuwane. Ono wanenga, gabman no dukotewei nomo lewainga, nere nauge abalakawou langa warane. ");
INSERT INTO eri_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ngasunga la, ere huwanyage benou ngalengawai, Yesus fai no waha, nere Israel fai-aita bagu ege gidu hanigei nomo bona, Itou no hangada tuwaiha. “Ege beele ete fere, Dada heigai waha, elebe nere Yesus dukote wane inyi ganga, fati eei goina. ");
INSERT INTO eri_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Elebe ereha aita ila nere horotomude higaneha. Nere eringe amina matmat langa goidu bode, ");
INSERT INTO eri_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yesus gogala inyi ganga uregu uwa. Onodu bode, nere ege gidu maidu benou lewaneha, ‘Ere ensel nerire yanga nere lewareha, “No ago auma yafana.” ’ ");
INSERT INTO eri_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Onodu, ere ebere ilibage gane ila fere, nere matmat langa goidu bode, nere aita beele lewane onounga inyi ganga uraneha. Ono wane wa, nere Yesus nogo uregu uwa inyina.” ");
INSERT INTO eri_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ono warenga, Yesus no benou lenirai, “Tere ninatere uwau, waha boyare, profet beele oruwanga lewane waha boyare huwanyatere ngalangawei nomo huwanyatere fasadu jayei uwa. ");
INSERT INTO eri_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Adadu? Tere Itou no fai waha huuru tuwonga medu bona, no nomo fai-aita bagu ege gidu hanigei nomo bona, no ngasunga, jimiri anyakaro tedu bona, iinga no unyi anyakaro Itou langa tonbona beele baara tawai waha tere alai uwa rute?” ");
INSERT INTO eri_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Onodu bona, no Moses nomo beele langa hugu waridu goi profet oruwanga nebere beele malalamudu lenirai, onodu Itou nomo beele hugu buk matau ila langa Yesus no nogo bona lena waha oruwanga isisiwou nirai. ");
INSERT INTO eri_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nere golodu goidu bode, nere matane yafodere goyare waha jugumu langa heigane. Onodu Yesus no gai golodu goyona dorofe onowai. ");
INSERT INTO eri_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ono wainga nere karu tubodere letuware, “Ne ere ngate yafei nomo. Hoonga amina minaha jorona, menanga onou agugu wonbona.” Ono warenga, no mata huwanya langa goyainga gaara yafane. ");
INSERT INTO eri_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iinga nere da nyode ono bode, Yesus no nere bagu yafai. Onodu bona, no beret tedu Itou hilobainga tudu bona laudu nere nirai. ");
INSERT INTO eri_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","No onou ono wainga, nere agenere fiyae wainga, nere no isi tuware. Ono warenga, fasayadu onou no ewe wanga huwari wainga, nere ege ureru uwa. ");
INSERT INTO eri_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Onodu nere nare-nare benou leguruware, “Ngalenga tigini, saini ere jala langa golo gerenga, no ere beele lehiri bona, no Itou nomo beele buk langa yeregane waha nomo hugu malalamudu lehiranga, ere eire huwanyare tigini jai dewaha.” ");
INSERT INTO eri_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ariya, nere onou legurudu bodere, fasadu onou jaidu ege gidu Jerusalem goyare. Onodu disaipel 11, nere ilibanege gane ila bagu komodu yafa ganenga nerigare. ");
INSERT INTO eri_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ono warenga, nere benou lenirane, “Ngalenga tigini, Anyakaro no ege gidu jayaha! Saimon no amina uraha!” ");
INSERT INTO eri_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ono wanenga, nere jala langa golo garenga, dada oruwanga nere langa heigai waha hai nagare. Onodu bodere leware, “Saini no beret laudu hiranga, ere no isi tuwereha.” ");
INSERT INTO eri_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yesus nomo disaipel nere beele gai le bode yafa ganenga, Yesus no nogo nere gama langa otowai. Ono bona benou lenigai, “Tere tebere huwanyatege edo foinga inyou.” ");
INSERT INTO eri_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ono wainga nere horotodu umugane. Nere ninanege benou isane, ere barau ete ureya iwane. ");
INSERT INTO eri_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ono wanenga, Yesus no benou lenigai, “Tere taate boya horotoya? Tere taate boya ninatege baingaro isiya? ");
INSERT INTO eri_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tere yame owofe afefe bagu uragu. Be ji wenga otoni. Gefe gala yaasudu bonade uragu. Nere fai anunege waha, nere mujanege ngedonege bagu ji langa inyina benou waha uwau.” ");
INSERT INTO eri_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","No onou lenigidu bona owo afo bagu abitimu nigai. ");
INSERT INTO eri_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ono wainga, nere edega dewane, ariya nere huwanyanege ngalengawei uwa. Onodu bode, nere ninanege baingaro isane. Ono wanenga, no benou lenigai, “Tere belanga da ila bagu yo?” ");
INSERT INTO eri_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ono wainga, nere hoowe bitane waha matau tuwanenga, ");
INSERT INTO eri_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","no tedu bona nyi gainga urane. ");
INSERT INTO eri_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ono wanenga, no benou lenigai, “Saini ji tere bagu yafa boni, ji tere benou letigene, dada oruwanga ji bode Moses nomo nuuni beele langa yeregane bagu, profet nebere buk langa yeregane bagu, Buk Song langa yeregane, dada waha oruwanga tigini heigonbona.” ");
INSERT INTO eri_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Onodu bona, no Itou nomo buk langa beele inyina waha nomo hugu isi dewei nomo bona hoyo nigai. ");
INSERT INTO eri_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Onodu bona, no benou lenigai, “Itou nomo buk langa beele benou bagu, Itou no nomo fai-aita ege gidu hanigei nomo fai hangada tuwai waha no jimiri tonbona, onodu fati eei langa no ege matmat langa gidu jayonbona. ");
INSERT INTO eri_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ono wonga, no unyi langa nere fai-aita oruwanga beele malalamudu lenigi gogunga, nere huwanyanege ubulu wogunga, Itou no nebere une uulu nagonbona. Tere haruwe waha Jerusalem langa hugu waragu, ");
INSERT INTO eri_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","onodu tere dada heigai waha bonade beele malalamudu lewagu. ");
INSERT INTO eri_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Isagu. Amina Jijei no tere Hauri Guuni tigei nomo bona beele baara tawai waha, menanga onou ji huuru wehenga tere bagu monbona. Tere taon beha langa yafa gadenga goi saini tere Itou nomo danga taagu ganga.” ");
INSERT INTO eri_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ariya, Yesus no nomo disaipel hanigedu goi Betani matane langa edowai. Onodu bona, no owo isoudu Itou no figini nigei nomo bona isoki tuwai. ");
INSERT INTO eri_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ariya, Yesus no nomo disaipel figiniwou nigi bonanga awa nigainga, Itou no haudu ha lalaluwa langa manai. ");
INSERT INTO eri_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ono wainga, nere afenege tuburu kutudu bode, unyi isouwane. Onodu nere edega bode ege gidu Jerusalem goyane. ");
INSERT INTO eri_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Onodu saini oruwa nere tempel langa yafa bode Itou unyi isou gane. ");
INSERT INTO eri_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gai aminanga amina, saini dada oruwa heigei uwa langa, Beele no inyai. Beele no Itou bagu inyai. Beele no nogo Itou. ");
INSERT INTO eri_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gai aminanga amina, Beele no Itou bagu inyai. ");
INSERT INTO eri_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Beele wahanga la, Itou no dada oruwanga heigemu wai. Dada ete-te jala fere langa heigei uwa. Dada oruwa heigai wa Beele wenga heigemuwai. ");
INSERT INTO eri_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ariya, ago auma no langa inyina waha, wa fai-aita bagu nebere lala. ");
INSERT INTO eri_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ariya, lala waha no agugu langa lala ganga, agugu no lala waha kutau tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ariya, fai ete heigai, nomo unyi Jon. Fai waha Itou no huuru tuwai. ");
INSERT INTO eri_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","No fai-aita bagu lala waha bona, beele malalamudu lenigei nomo bona mai. Ono wonga nere lala waha nomo beele isidu bode, huwanyanege ngalenga wona bona. ");
INSERT INTO eri_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon no nogo no lala waha uwa. No lala waha nomo beele malalamudu le wei nomo bona mai. ");
INSERT INTO eri_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ariya, lala waha no lala tigini, no nere fai-aita bagu oruwa lala nigi-nigina, no oula la monbona. ");
INSERT INTO eri_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ariya, Beele no oula la inyina. Beele wahanga la, Itou no oula tafai, ariya, nere fai-aita oulaha nere waha bona foo nigei uwa. ");
INSERT INTO eri_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Onodu no nogo nomo matane hugu langa goyai wa, no nomo gane tigini nere no hawegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ariya, nere fai-aita ila no hawane waha, nere no unyi bode huwanyanege ngalenga wane waha. Onou waha bona, nere Itou nomo magana edo heigei nomo bona unyinege anyakoro nigai. ");
INSERT INTO eri_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nere amenege anyanege gane nebere ganenege langa yo, genege gala nomo gauwou langa yo, fai nebere gauwou langa uwa. Itou nogowe ono nigainga nomo magana heigane. ");
INSERT INTO eri_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ariya, Beele no fai heigai, onodu no medu ere gamage la inyai. Ere nomo unyi anyakaro bagu, danga bagu ureye. Magana etenga wahanga nomo unyi anyakaro, no Jijei huuru tuwainga mai. No augamu guruwou bagu, fanyimu tigini bagu bolo tuwou. ");
INSERT INTO eri_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ariya, Jon no fai waha bona nere fai-aita bagu lenigidu bona benou yaurai, “Fai no waha boni, ji amina benou letigene, ‘Fai no ji mogofe maina waha, no ji amuge hiyou. Taate bona, ji heigei uwa la, no aminanga yafai.’” ");
INSERT INTO eri_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ariya, aau warou fai waha langa bolo dewou, no nomo aau warou waha la, ere oruwa figini higi dedena. ");
INSERT INTO eri_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wa ngalenga, Itou no nuuni beele ere Moses owo langa higainga tei. Ariya, Yesus Kristus langa ere augamu guruwou bagu, fanyimu tigini bagu tei. ");
INSERT INTO eri_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ariya, fai ete te Itou urei uwa. Gai uwanga uwa. Itou Nomo Idau etenga waha, no nogo Itou, no tigini Umamu hinomu la yafana, no wenga ere Itou abitimu higai. ");
INSERT INTO eri_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nere Juda, Pris Livai bagu huuru niganenga Jerusalem awadu bode mai Jon benou isoki tuwane, “Ne faiwei tigini?” ");
INSERT INTO eri_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ono wanenga, Jon no beele ete huwarimuwei uwa. No beele tigini malalamudu benou lenigai, “Itou fai-aita bagu gidu hanigei nomo fai hangadawai wa, ji fai waha uwa.” ");
INSERT INTO eri_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ono wainga, nere isoki tuwane, “Adadu? Ne Elaija yo?” Ono wanenga, no lenigai, “Ji no uwa.” Ono wainga, nere ege isoki tuwane, “Ne profet ere no itari tuya waha yo?” Ono wanenga, no lenigai, “Ji no uwa.” ");
INSERT INTO eri_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ono wainga, nere no ege isoki tuwane, “Ne faiwei tigini? Ere fai nere huuru higanenga meyaha waha, beele ete ege gidu lenigoboya. Ne nage bonahe adadu lewau ganga?” ");
INSERT INTO eri_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ono wanenga, Jon no benou lenigai, “Ji fai ete, bolou ha fai uwau la yauredu benou lewai waha, ‘Anyakaro nomo jala tiginimu fuwagu. Wa profet Aisaia no amina lewai onou.’” ");
INSERT INTO eri_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisi nere fai beha huuru niganenga mayane. ");
INSERT INTO eri_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nere Jon isoki tuwane, “Ne leni, ne Itou nomo fai-aita bagu gidu hanigei nomo hangada hinou fai waha uwa, ne Elaija uwa, onodu ne profet waha uwa, ariya ne taate boni fai-aita bagu yaage bisemu nigi-nigini?” ");
INSERT INTO eri_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ono wanenga, Jon, no nere lenigai, “Ji yaage la, yaage bisemu nigi-nigini. Ariya, fai ete no tere gamatege la ya waha, tere no boya ada isiya. ");
INSERT INTO eri_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Fai no waha, ji mogofe maina. Ariya, ji yage fai hilou uwa, ji no nomo afo osoko tanou waha, nomo maalu futu fuwei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon no beele waha, no Betani matane Jordan yaage ulate langa lenigai. Jon no haumu walanga, nere fai-aita bagu yaage bisemu nigigai. ");
INSERT INTO eri_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ariya inyi hamba, Jon no Yesus no bagu golodu mai gainga urai. Onodu Jon no lewai, “Uragu. No Woha Itou Nomo Sipsip Magana. No fai-aita bagu oulaha nebere une uulu nagona bona maina. ");
INSERT INTO eri_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ji fai wahanga boni, amina letigene, ‘Fai no ji mogofe maina waha, no ji amuge hiyou. Taate bona, ji heigei uwa la, no aminanga yafai’. ");
INSERT INTO eri_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ji yage no faiwei waha, ji no isi tuwei uwa. Ariya, ji nere Israel fai-aita bagu no isi tuwei nomo boni, ji maidu fai nere yaage langa, yaage bisemu nigene.” ");
INSERT INTO eri_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Onodu Jon no beele beha ege lenigai, “Ji Hauri Guuni, ha laluwa awadu nei ete buuna dorofe medu bona, no langa yafa ganga urenaha. ");
INSERT INTO eri_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ariya ji yage, ji no ada isi tugene. Itou no ji huuru hiyainga, nere fai-aita bagu yaage la, yaage bisemu nigei nomo boni meene waha, no we ji lehiyai, ‘Saini, Hauri Guuni no medu bona, fai ete la yafa gonga ure bonahe wonga, fai no wahanga, no fai-aita bagu Hauri Guuni langa yaage bisemu nigonbona.’ ");
INSERT INTO eri_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ariya, ji yage we, ji waha uredu beele malalamudu lewene. No beha waha, no Itou Nomo Idau.” ");
INSERT INTO eri_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ariya inyi hamba, Jon no ege walanga oto gainga, no nomo disaipel nga nononga, no ngate gaara oto wane. ");
INSERT INTO eri_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ono ganenga, Yesus no golodu goi gainga, Jon no uredu bona lewai, “Uragu. No woha Itou Nomo Sipsip Magana.” ");
INSERT INTO eri_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jon no onou lewainga, nomo disaipel nga waha isidu bodere, nere Yesus oojo tudu goyare. ");
INSERT INTO eri_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus no ubuludu bona, fai nga oojo tu garenga nerirai. Onodu bona, no benou isoki nirai, “Tere taate kuruyare?” Ono wainga nere isoki tuware, “Rabai, ne mata adeha langa yafani?” Ariya, “Rabai” nomo hugu wa, “Isisigou fai”. ");
INSERT INTO eri_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ono warenga Yesus no lenirai, “Tere maidu bonadere uraru!” Ono wainga nere goidu bodere, mata no yafana waha urare. Onodu fati waha la, nere no ngate yafane. Taate bona, hoonga ago amina esuwa 4-kilok onou. ");
INSERT INTO eri_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ariya nere fai nga, Jon beele lewainga isidu bodere, Yesus oojo tuware waha, ete nomo unyi Andru, no Saimon Pita bemu. ");
INSERT INTO eri_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","No Yesus awa tudu bona tigini goi no nomo bemu Saimon toroba tudu letuwai, “Ere Mesaia ureyaha.” Ariya, “Mesaia” nomo hugu benou, “Fai, Itou no nomo fai-aita bagu ege gidu hanigei nomo hangada tuwou”. ");
INSERT INTO eri_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Onodu Andru no Saimon haudu Yesus bagu goyai. Ono wainga, Yesus no Saimon uredu bona letuwai, “Ne Saimon, Jon nomo idau. Iinga gonga, nere unyite ‘Sifas’ hinodbode.” Ariya, “Sifas” no, “Pita” ide dorofe. Nomo hugu benou, “Megebu”. ");
INSERT INTO eri_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ariya, inyi haamba, Yesus no Galili goyonbona onowai. Ono bona, no Filip toroba tudu, benou letuwai, “Ne mai ji taga hiyau.” ");
INSERT INTO eri_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ariya Filip no Betsaida taonha, Andru, Pita ngare neire matane hugu. ");
INSERT INTO eri_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ariya, Filip no goidu Nataniel toroba tudu bona benou letuwai, “Moses no nuuni beele nomo buk langa amina no bona yeregai waha, nere profet fere nomo beele yeregane. Ere fai waha amina toroba tuyaha. No waha Yesus, Josep idau Nasaret taonha.” ");
INSERT INTO eri_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ono wainga, Nataniel no Filip isoki tuwai, “Dada hilobainga ete Nasaret taon langa edo la heigona rute?” Ono wainga, Filip no Nataniel letuwai, “Ne maidu bonahe urau.” ");
INSERT INTO eri_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Saini Yesus no Nataniel no bagu mayainga uredu bona, benou lewai, “Uragu. Fai maina beha, no Israel fai tigini. No langa yaawawou beele bagu yaawawou fanyimu ete inyei uwa!” ");
INSERT INTO eri_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ono wainga, Nataniel no Yesus isoki tuwai, “Ne adadu ji isi hinaha?” Ono wainga, Yesus no ege gidu benou letuwai, “Saini Filip no ne yaure hinei uwa langa, ne fik nauge hugu langa yafa genenga neriye naha.” ");
INSERT INTO eri_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ono wainga, Nataniel beele waha isidu Yesus letuwai, “Isisi higigou fai, ne Itou Idau. Ne Israel nebere King.” ");
INSERT INTO eri_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ono wainga, Yesus no Nataniel letuwai, “Ji ne benou lehininaha, ne fik nauge hugu langa yafa genenga neriyenaha. Hugu waha langa, ne ji boni huwanyate ngalengana.” “Ariya, iinga gonga ne dada aroro, dada beha feiya dewou urau ganga.” ");
INSERT INTO eri_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Onodu Yesus no lenigai, “Ji ngalenga letigini, iinga gonga ha laluwa helufa wonga, Itou nomo ensel nere Fai Nomo Idau bagu meyao maniyao gogunga nerigagu ganga.” ");
INSERT INTO eri_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yesus no Filip Nataniel ngare yaure nirai waha fati nga goyainga, Kana taon Galili distrik walanga, fai-aita ngare te guru ware. Ono garenga, Yesus anya, fai-aita ngare te guruwou waha urona goyai. ");
INSERT INTO eri_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ariya, Yesus no nomo disaipel gane bagu fere, fai-aita ngare te guruwou walanga yafei nomo yaure niganenga maidu bode walanga yafane. ");
INSERT INTO eri_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Iinga, nere wain usu nigainga, Yesus anya no Yesus letuwai, “Nere wain uwau.” ");
INSERT INTO eri_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ono wainga, Yesus no anya letuwai, “Ngai, wa ne name dada. Ji yame dada uwa. Ji yame saini iinga inyina.” ");
INSERT INTO eri_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ono wainga, Yesus nomo anya no nere haruwe fai lenigai, “No dada ete onowei nomo letigei mata wonga, tere no bolou oojo wagu.” ");
INSERT INTO eri_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ariya, mata waha langa megebu tumutao aroro 6 oruwa otowane. Tumutao waha, nere Juda nebere fanyinege langa yaage bisei nomo bona. Ariya, nere tumutau etenga-etenga, yaage unyei nomo wa, 100 lita onou. ");
INSERT INTO eri_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ono wainga, Yesus no haruwe fai lenigai, “Tere tumutau langa yaage unyagu.” Ono wainga nere yaage unyanenga, bolo ganawai. ");
INSERT INTO eri_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ono wanenga no lenigai, “Ila elegedu mani, da waha oofagou fai tuwagu.” Ono wainga, nere ila elegedu tamanane. ");
INSERT INTO eri_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yaage waha amina wain dorofe heigainga, da waha oofagou fai no yaage waha nyi urai, onodu nere wain waha alanga taane waha, no alai uwa. Nere haruwe fai, yaage unyane wahanga nere alai. Ono wainga, da oofagou fai no fai, aita tai waha yaure tuwai, ");
INSERT INTO eri_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","onodu no letuwai, “Nere fai oruwa, wain hilobainga waha amugedu fai nigi ganenga, nyi-nyide. Ariya, nere wain baingaro nyi boro ganenga iinga la, nere wain menenga inyaba waha nigi-nigide. Ariya ne nu, wain hilobainga waha awananga inyanga, iingabe tedu tamainaha.” ");
INSERT INTO eri_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ariya, dodokawou beha waha, Yesus no amugedu tafai. No Kana taon Galili distrik la tafai. Dodokawou beha no naani, no unyi anyakaro danga bagu waha abitimu nigai. Ono wainga nomo disaipel uredu bode, nere no bode huwayanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ariya, Yesus no Kana awatudu bona Kaperneam taon minai, no nomo anya wainga, no nomo bemu gane bagu, nomo disaipel gane bagu minidu bode, nere fati ila taon waha la yafane. ");
INSERT INTO eri_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ariya, Juda nebere bori nomo fati anyakaro ete heigona juguwai, wa Itou No Israel Awa Nigainga Hilobainga Yafane Waha Nomo Fati Anyakaro Waha Ninanege Isei nomo bona. Ono wainga, Yesus no Jerusalem goyai. ");
INSERT INTO eri_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No goidu bona, tempel orei huwanya walanga nere fai moni kusewei nomo bulumakao bagu, sipsip bagu, neei bagu huuru gane nerigai. Nere fai moni hoolewei nomo fere nebere tewol langa yafagane nerigai. ");
INSERT INTO eri_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Onodu bona, Yesus no baklain ete tedu bona gula nigei nomo bona atai. Onodu no fai oruwanga nebere bulumakao bagu, sipsip bagu, so nigainga tempel waha awadu heige harawane. Ono bona, no fai moni hoole bode yafane waha, nebere moni feudu ayaru nagi bona, tewol fere feum nagai. ");
INSERT INTO eri_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ariya, nere fai neei huurudu moni kusewei nomo haruwe taane waha lenigai, “Tere tebere neei elegedu bonade goyagu. Tere yame Jijei nomo mata waha adai ono wadenga, dada huurudu moni tegou mata dorofe heigona.” ");
INSERT INTO eri_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ono wainga, nomo disaipel no fanyimu onowai waha uredu bode, nere beele ete Itou nomo buk langa inyina waha bode ninanege isane. Beele wa benou “Ji yame mata gaudeni, onou waha bona, ji mata waha hilobainga inyi dewei nomo boni haruwe danga bagu teni.” ");
INSERT INTO eri_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ariya Juda nere Yesus no fanyimu onowai waha uredu bode, nere benou isoki tuwane. “Ne taate dodokawou ete naani dorofe abitimu higahenga, ere ne unyite anyakaro bagu bona, ne onowou beha ononahawou isoya?” ");
INSERT INTO eri_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ono wanenga, Yesus no lenigai, “Tere tempel beha koresemu wadenga, fati eei langa ji ege jaimu wonboni.” ");
INSERT INTO eri_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ono wainga, nere Juda letuwane, “Haga orei 46 onou, nere tempel beha atane. Ariya, adadu ne fati eei langa, mata beha ege jaimu wauganga boni leni?” ");
INSERT INTO eri_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ariya, Yesus no tempel bona lewai waha, wa no nogo gogala bona lenigai. ");
INSERT INTO eri_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Onowai wa, saini Itou no Yesus ege matmat la jaimu tuwainga, nomo disaipel nere no amina beele lewai waha bode ninanege isane. Onodu nere Itou nomo beele buk la inyina waha bagu, Yesus no beele lewai waha bagu bode huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Fati Anyakaro, Itou No Israel Awa Nigainga Hilobainga Yafane Waha Ninanege Isei Nomo fati la, Yesus no Jerusalem la yafai. Fai-aita bagu baingaro nere Yesus no dodoka yo, naani onou tafainga urane. Nere waha uredu bode, nomo unyi bode huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ariya, Yesus no nere bona huwanya ngalengawei uwa. ");
INSERT INTO eri_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","No fai oruwanga nebere fanyinege amina isai. Waha bona, no isou ete bona tutu tuwei uwa, onou bona, fai ete no nere fai fanyinege bona letuwei nomo edo uwa. No nogo nebere ninanege amina isaiha. ");
INSERT INTO eri_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ariya fai ete yafai, nomo unyi Nikodemus. No Farisi ete, onodu no Juda nebere mora bagu ete. ");
INSERT INTO eri_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Fai no waha, ooru ete langa Yesus bagu maidu bona letuwai, “Isisi higigou fai, ere isiya, Itou no ne huuru hinainga isisiwou fai dorofe meene. Itou no fai ete bagu ada yafonga wa, fai no dodokawou ne tafani benoha waha ada tafona.” ");
INSERT INTO eri_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ono wainga, Yesus no letuwai, “Ji ngalenga lehinini, fai no eege ada heigona waha, no Itou nomo huuna la yafou waha ada urona.” ");
INSERT INTO eri_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ono wainga, Nikodemus no Yesus benou isoki tuwai, “Adadu fai no umurawai waha, no edo langa eege heigona? Onou wa, no anya huwanya langa goyonga, anya ege bisi tuwei nomo edo yo?” ");
INSERT INTO eri_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ono wainga, Yesus no Nikodemus letuwai, “Ji ngalenga tigini lehinini, fai no yaage la bagu, Hauri Guuni la bagu, no eege heigei uwa wonga wa, no Itou nomo huuna la yafou waha huwanya la goyei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dada gege gala heigemuna waha, wa gege gala nomo. Ariya, dada Hauri Guuni heigemuna waha, wa hauri nomo. ");
INSERT INTO eri_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ji beele lehininaha waha bonahe adai horotowau, tere eege heigagu. ");
INSERT INTO eri_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ariya, jagui no nomo gauwou la fuudu, ha fere‑fere la goi-goina. Ariya, ne jagui nomo bolou isi-isini, ariya no alanga maina, alanga goina, waha ne ada urau. Onou waha bona, fai oruwanga nere Hauri Guuni langa eege heigede waha, nere fere onounga.” ");
INSERT INTO eri_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ono wainga, Nikodemus no isoki tuwai, “Dada ne leni waha, adadu la onou heigonbona?” ");
INSERT INTO eri_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ono wainga, Yesus no letuwai, “Ne Israel nebere isisi nigigou fai, adadu bona ne dada beha boni foo hinei uwa?” ");
INSERT INTO eri_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ji ngalenga lehinini, dada ere isiya waha boya ere le-leya. Ariya, dada ere amina ureye waha boya, ere beele malalamudu leleya. Ono geyenga, ere beele malalamudu leleya waha, tere moge tuya. ");
INSERT INTO eri_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ji oula beha nomo dada boni waha letigini, ariya, tere waha boya huwanyatege ngalenga wegu uwa. Onou waha ji ha laluwa nomo dada boni letigehenga, tere adadu huwanyatege ngalenga wona? ");
INSERT INTO eri_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ariya, fai ete-te no ha laluwa la manei uwa. Fai Nomo Idau, no nogonga ha laluwa awadu bona mai. ");
INSERT INTO eri_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Amina Moses no ha kara la, maangi ete tofiyai. Ariya nere Fai Nomo Idau fanyimu onounga la tofiye tuwodbode. ");
INSERT INTO eri_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Onou wa, nere fai, oruwanga no bode huwanyanege ngalengade waha, nere agenege auma gai-gai yafou waha todbode. ");
INSERT INTO eri_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Itou no nomo Idau etenganga yafai. Ariya, no nere fai-aita oruwa, oula beha la yafade waha gaude nigi du bona, no nomo Idau etenga waha, nigai. Wa taate bona, nere fai-aita bagu no bode huwanyanege ngalengade waha, adai yae wode. Nere agenege auma gai-gai yafou waha todbode. ");
INSERT INTO eri_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ariya, Itou no Idau huuru tuwainga mai waha, no fai-aita bagu oula langa yafade waha, jas dorofe haawe nigei nomo meei uwa. No Idau huuru tuwainga mai wa, no nere ege gidu hanigei nomo bona. ");
INSERT INTO eri_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ariya fai no Idau bona huwanya ngalengana waha, no kot uwau. Ariya, fai no Idau bona huwanya ngalengawei uwa waha, no kot langa oto wonbona. Taate bona, no Itou Idau etenga waha nomo unyi bona, no huwanya ngalengawei uwa. ");
INSERT INTO eri_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ariya, nebere kot nomo hugu benou. Lala no oula langa amina heigaiha, onou wa fai nere agugu waha gaude tude. Nere lala waha gauwegu uwa, taate bona, nere fai fanyimu inyaba waha onogou. ");
INSERT INTO eri_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nere fai oruwa, fanyimu inyaba onode waha, nere lala nomo honggoro fai. Nere nebere onowou inyaba waha malala heigei nomo awade, onodu nere lala langa ada mai-maide. ");
INSERT INTO eri_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ariya, fai no onowou tigini onona waha, no lala la mai maina. Ono ganga nere fai uredu bode lede, no Itou nomo danga langa haruwe taiha.” ");
INSERT INTO eri_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ariya iinga, Yesus no nomo disaipel bagu nere ulate Judia langa goyane. No nere bagu walanga yafa bona, fai-aita bagu yaage bisemu nigai. ");
INSERT INTO eri_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon no fere, nere fai-aita bagu Ainon matane, Salim matane jugunga la, yaage bisemu nigai. Matane waha langa nere yaage baingaro, waha bona nere fai-aita bagu, no la yaage bisou tei nomo bode mayane. ");
INSERT INTO eri_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Saini waha, Herot no Jon dagou mata langa tafa tuwei uwa la. ");
INSERT INTO eri_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ariya, Jon nomo disaipel nere Juda fai ete bagu, taate yaage bisou fanyimu waha oojodu Itou ago la jijiga uwau heigode, waha bode beele le wane. ");
INSERT INTO eri_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Onodu bode, nere Jon nomo disaipel, Jon bagu goidu bode letuwane, “Isisi higigou fai, fai waha no amina, ne bagu Jordan yaage ulate langa yafa gainga, ne no boni beele malalamudu lewene waha, no elebe fai-aita bagu yaage bisemu nigi ganga, nere oruwanga no bagu goide.” ");
INSERT INTO eri_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ono wanenga, Jon no beele ege gidu lenigai, “Fai ete no Itou ha laluwa la yafana waha, no dada ete tuwei uwa wonga, no nogo tei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Onodu bona no lenigai, “Ji amina beele lewene waha tere tage iseye. Ji ‘Fai Itou no nomo fai-aita ege gidu hanigei nomo hangada tuwai waha, ji fai waha uwa. Ariya Itou no ji no amuge tudu huuru hiyainga meene.’ ");
INSERT INTO eri_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Fai ete no aita tei mata wonga, aita waha no fai waha nomo oya. Ariya, fai waha nomo ilibumu no itari tudu oto bona, no aagu tuwon bona. Onodu bona, no ilibumu aita tai waha nomo bolou isei nomo bona, edega wonbona. Onou dorofenga, edegawou ji huwanyafe langa bolo waha. ");
INSERT INTO eri_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ariya, no nomo unyi anyakaro heige gonga, ji yame unyife esene monbona.” ");
INSERT INTO eri_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Fai no ouwe la yafadu mai waha, no dada oruwa bona feiya nigou. Fai no oula beha nomo wa, no oula beha nomo fanyimu ono-onona. Onou waha bona, no dada oula beha nomo waha bona le-lena. Fai no ha laluwa la mai waha, no dada oruwa bona feiya nigou. ");
INSERT INTO eri_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dada oruwa no uredu bona, isai waha, no waha bona beele malalamudu le-lena. Ono ganga, nere fai no beele malalamudu lena waha ete tedu yaasu wegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ariya fai no nomo beele waha tedu yaasuna wa, no huwanya ngalengawou abitimuna, “Itou no beele ngalenga le-lena.” ");
INSERT INTO eri_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Fai Itou no huuru tuwainga mai waha, no Itou nomo beele malalamudu le-lena. Taate bona, Itou no fai waha Hauri Guuni mataunga tuwei uwa. ");
INSERT INTO eri_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Umamu no Idau bona gaude tuna. Onou waha bona, no dada oruwanga no owo langa tafai. ");
INSERT INTO eri_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ariya, fai no Idau bona huwanya ngalengana waha, no gai-gai ago auma yafou waha bagu. Ariya, fai no Idau nomo beele ada oojona waha, no ago auma yafou waha ada tonbona. Uwa. Itou nomo houmu mayou waha, no la inyonbona. ");
INSERT INTO eri_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ariya, Farisi nere beele ete benou isane, Yesus no fai baingaro yaage bisemu niganga nomo disaipel heigane. Yesus no nomo disaipel lelege nigou wa, no Jon nomo disaipel feiyawou. Ariya Yesus no nogo fai yaage bisemu nigei uwa. No nomo disaipel nere wenga yaage bisemu nigane. Ariya Farisi nere fai baingaro Yesus nomo disaipel heigane iwou beele isane waha, Yesus no amina isai, onodu no Judia distrik awadu bona, ege gidu Galili distrik la goyai. ");
INSERT INTO eri_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ariya, jala no oojowai wa, Samaria distrik gamaladu goyai. ");
INSERT INTO eri_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Onou waha bona, no golodu goi Samaria nebere taon ete, nomo unyi Sikar la heigai. Sikar no oula Jekop nomo idau Josep tuwai, waha jugu tuwou. ");
INSERT INTO eri_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ariya, yaage u-u ete Jekop no konuwai waha, haumu walanga inyai. Ariya, Yesus no golodu mai gainga go kenye wainga, no goidu yaage u-u waha hinemu langa yafai. Ariya saini no yafai waha, hoonga ago 12-kilok onou. ");
INSERT INTO eri_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ono gainga Samaria aita ete no yaage u-u waha la, yaage unyona bona mayai. Ono wainga, Yesus no aita waha letuwai, “Yaage hiyahenga nyoni.” ");
INSERT INTO eri_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ono gainga nomo disaipel nere da ejiyawei nomo bode, taon la mananeha. ");
INSERT INTO eri_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ariya, Sameriaha aita waha no Yesus letuwai, “Ne Judaha, ji Sameria aita, taate boni ne lehini, ‘Yaage hiyahenga nyoni?’” No onou letuwai, wa taate bona, Juda nere Samaria bagu ada fada guru-gurude. ");
INSERT INTO eri_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ono wainga, Yesus no aita waha letuwai, “Ne Itou nomo toota bona isage wa, onodu ne fai no le hinaha, ‘Yaage tamayau ji yaage nyonboni hinaha waha isi tuwou wage wa, ariya ne letuwagenga,’ no yaage agenege auma nomo waha hinage.” ");
INSERT INTO eri_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ono wainga aita waha no letuwai, “Fai Anyakaro, ne Baket uwau. Yaage u-u beha no gai gamula. Onou waha bona, ne yaage agege auma nomo waha, alanga tau ganga? ");
INSERT INTO eri_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ere ebere asage Jekop, no yaage u-u beha ere higai. No nogo nomo idau gane bagu, nomo bulumakao bagu, nomo sipsip dada bagu, nere yaage u-u beha langa nyi gane. Ariya ne Jekop feiya tuwou yo?” ");
INSERT INTO eri_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ono wainga, Yesus no aita waha letuwai, “Nere fai oruwanga, yaage beha langa nyode waha, nere ege yaage nyomoli nigonbona. ");
INSERT INTO eri_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ariya, fai ete no ji we yaage tuwehenga nyona wa, no ege yaage nyomoli ada tuwonbona. Ariya yaage ji tuwoni wa, no huwanya langa yaage u-u la maina dorofe, mai bona no ago auma hilobainga gai-gai yafou waha tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ono wainga, aita waha no letuwai, “Fai Anyakaro, ne yaage waha hiyau. Ono wahenga, iinga ji yaage nyomoli ege ada hiyonga, ji yaage unyei nomo boni, ege belanga ada moni.” ");
INSERT INTO eri_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ono wainga, Yesus no letuwai, “Ne manidu, name amede yaure tudu bonahe, ege gidu belanga mau.” ");
INSERT INTO eri_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ono wainga, aita waha no Yesus letuwai, “Ji fai uwau.” Ono wainga, Yesus no letuwai, “Ne leni, Ji fai uwau iini wa, ne ngalenga leni. ");
INSERT INTO eri_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Taate bona, amina ne name fai 5. Ariya, fai 6 elebe ne ngare yafayare beha waha, wa ne name fai tigina uwa. Onou waha bona, ne beele leni beha tigini.” ");
INSERT INTO eri_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ono wainga, aita no letuwai, “Fai Anyakaro, elebe ji isini, ne profet ete. ");
INSERT INTO eri_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ebere asage gane nere muju beha langa komodu bode, Itou unyi isou gane. Ariya tere Juda le-leya, Itou unyi isouwei nomo haumu Jerusalem langanga inyina.” ");
INSERT INTO eri_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ono wainga Yesus no letuwai, “Aita, ne yame beele beha bonahe, huwanyate ngalengawou. Saini ete heigona onona waha, tere muju waha langa, Jijei unyi ada isou wagu ganga. Jerusalem langa fere no unyi ada isou wagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ariya, tere Samaria, dada tere ada isisiya waha unyi isou-isouya. Ariya, ere Juda dada ere isiya waha, unyi isou-isouya. Wa taate bona, Itou no nere fai-aita bagu ege gidu hanigei nomo haruwe waha, ere Juda amugedu hangada higai. ");
INSERT INTO eri_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ariya, saini heigona onona waha, no elebe amina heigaha, nere fai oruwanga Itou unyi tigini isouwei nomo wonga, nere Jijei unyi langa, Hauri Gunni nomo danga langa, fanyimu tigini langa, unyi isou wodbode. Jijei no fai nere onouha waha, no unyi isouwei nomo bona gaude tuna. ");
INSERT INTO eri_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Itou no Hauri. Onou waha bona, fai nere no unyi isou wodbode wonga, nere no nomo Hauri nomo danga langa, fanyimu tigini langa unyi isou wodbode.” ");
INSERT INTO eri_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ono wainga, aita no Yesus letuwai, “Ji isini, Mesaia no mayonbona, fai no waha Itou no nomo fai-aita ege gidu hanigei nomo bona hangada tuwai. Saini no mayona waha, no dada oruwa bona le higonbona.” ");
INSERT INTO eri_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ono wainga, Yesus no aita waha letuwai, “Wa ji benu, elebe ne ngare beele haiyare.” ");
INSERT INTO eri_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","No onou legainga, nomo disaipel ege gidu mane. Nere medu bode, no aita ete ngare beele haigare urane, onodu nere ninanege baingaro isane. Ariya, fai ete-te no benou isoki tuwei uwa, “Ne taate tau ganga?”, “Taate boni aita waha ngare beele haiyare?” ");
INSERT INTO eri_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ariya, aita waha nomo baket awadu bona, no ege gidu taon la manai. No manidu bona, fai-aita benou lenigai, ");
INSERT INTO eri_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tere medu bonade, fai ete no ji dada oruwanga amina ono wene waha lehiyaha, waha uragu. Fai no wahanga rute, Itou no huuru tuwonga monbona beele baara tawai?” ");
INSERT INTO eri_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ono wainga, nere taon awadu bode, Yesus bagu maane. ");
INSERT INTO eri_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Saini waha langa, nomo disaipel nere no letuwane, “Isisi higigou fai, ne da nyau.” ");
INSERT INTO eri_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ono wanenga, no benou lenigai, “Ji da bagu, tere ada isiya.” ");
INSERT INTO eri_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ono wainga, nomo disaipel, nere nage-nage leguruwane, “Fai eteru da tetamai fuwaha?” ");
INSERT INTO eri_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ono wanenga, Yesus no lenigai, “Itou no ji huuru hiyainga mene, onou bona ji yame da wa, ji no nomo gauwou oojo boni, haruwe no hiyai waha usumu wonboni. ");
INSERT INTO eri_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Tere benou leleya, ‘Da faasiwei nomo saini heigon bona ole aise inyina.’ Onou waha boni, ji letigini, tere haga oruwa la, fele-feledu bonade ure dewagu. Da oruwa, hilou bagu waha. ");
INSERT INTO eri_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Fai no da faasina waha, no nomo agou tedu bona, no agenege auma gai-gai hilobainga yafou waha nomo da komomuna. Onou waha bona, fai no da tauna waha, fai no da faasina waha, nere ngadunga, edo edega wodere. ");
INSERT INTO eri_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Onou waha bona, beele beha no ngalenga, ‘Fai ete no da tataru ganga, fai ete no nomo da faasi-faasina.’ ");
INSERT INTO eri_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ariya, ji tere da faasiwei nomo boni, haga tere walanga amina haruwe teegu uwa waha langa huuru tigene. Ono wenenga, tere huwanya la goidu boya, nere fai ila nebere haruwe ngisirau la, da hilou heigai waha tere faasi weye.” ");
INSERT INTO eri_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ariya, nere Samaria fai-aita baingaro taon wahaha nere aita waha nomo beele isidu bode, nere Yesus bode huwanyanege ngalengawai. Wa taate bona, aita waha no lewai, “No ji dada oruwa, amina ono wene waha, no lehi borowai.” ");
INSERT INTO eri_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Onodu bode, Sameria nere Yesus bagu maidu, Yesus nere bagu yafei nomo bode isoki tuwane. Ono wanenga, no fati nganononga matane waha langa yafai. ");
INSERT INTO eri_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ono gainga, nere fai-aita bagu baingaro, Yesus nogo nomo beele isidu bode, huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Onodu bode, nere aita waha letuwane, “Ere ne name beele wahanga isidu, fai beha boya huwanyage ngalengawei uwa. Ere hage we nogo nomo beele isidu boya, ere isiyaha wa ngalenga, fai no wahanga fai-aita oulaha bagu ege gidu hanigou fai.” ");
INSERT INTO eri_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ariya, Yesus no fati nga nere Samaria bagu yafadu, no matane waha awadu bona Galili distrik langa minai. ");
INSERT INTO eri_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus no nogo beele benou malalamudu lewai, “Profet nogo nomo matane hugu langa, no unyi uwau.” ");
INSERT INTO eri_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Onodu no goi Galili la heigainga, nere Galili fai-aita no goyai waha bode edega wane, taate bona, nere bori nomo fati anyakaro Jerusalem langa heigai waha langa manidu bode, no dada oruwanga saini waha langa onowai waha urane. ");
INSERT INTO eri_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ariya, Yesus no ege goi Kana taon, Galili distrik langa heigai. Taon waha langa, no amina yaage ubulumu wainga wain heigaiha. Saini waha langa, Kaperneam taon walanga, king ete no nomo ofisa ete yafai, no nomo idau no taura tuwai. ");
INSERT INTO eri_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Fai waha no beele onou isai, Yesus no Judia awadu, Galili la amina heigaha. Onodu no goidu bona, Yesus Kaperneam la medu nomo idau taura jigemu fuwei nomo bona isoki tuwai. Ariya magana waha no umonbona juguwai. ");
INSERT INTO eri_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ono wainga Yesus no fai waha letuwai, “Tere dodoka tafou hogo fere-fere ada urage wa, tere huwanyatege ada ngalenga wage.” ");
INSERT INTO eri_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ono wainga, king nomo ofisa no letuwai, “Anyakaro, ne fasadu mayahenga minoyare. Gamaji yame magana umoga.” ");
INSERT INTO eri_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ono wainga, Yesus no fai waha letuwai, “Ne minau. Name idate no ago auma yafonbona.” Ono wainga ofisa waha no Yesus nomo beele bona huwanya ngalenga wainga, no minai. ");
INSERT INTO eri_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","No golodu Kaperneam mini heigei uwa la, nomo haruwe magana maidu bode, no jala gama langa toroba tuwane. Onodu bode benou letuwane, “Name idate no ago auma yafana.” ");
INSERT INTO eri_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ono wanenga, no nomo idau taate aua la menanga onou jige tuwaha waha, isoki nigai. Ono wainga, nere letuwane, “Feyo esuwa, 1-kilok la nomo taura awa tuwaha.” ");
INSERT INTO eri_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ono wanenga, magana waha umamu no isai, aua waha langa tigini, Yesus no letuwai, “Name idate no ago auma yafona bona.” Onowai la, no huwanya ngalenga wainga, nomo gane fere oruwanga huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ariya dodoka beha elebe bagu tafa nga waha, saini Yesus no Judia awadu bona, Galili mai yafai langa. ");
INSERT INTO eri_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ariya, iinga gainga, nere Juda nebere bori nomo fati anyakaro ete heigai. Ono wainga, Yesus no Jerusalem manai. ");
INSERT INTO eri_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ariya Jerusalem langa orei anyakaro nomo jauli arasai nere le-lede, Sipsip Nebere Jauli, arasai waha hinomu langa, yaage u-u ete inyina. Yaage waha, nere Hibru le-lede, Betesda. Yaage u-u waha, nomo mou langa, faranda anyimu kouwou inyina. ");
INSERT INTO eri_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ariya, faranda waha langa, nere taura fai baingaro, yafane, nere agenege inyaba bagu, nere fai afenege inyaba bagu, nere fai ngedonege lalekawou bagu gaara yafane. ");
INSERT INTO eri_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ariya, fai ete no faranda waha langa yafagai, no taura waha bagu yafa gainga nomo haga orei 38 oruwa. ");
INSERT INTO eri_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ariya, Yesus no fai waha inyi gainga uredu bona no isai fai beha no taura saini ufaro inyai. Onodu bona, Yesus no isoki tuwai, “Ne gete gala ege hilobainga heigei nomo gau hinina yo?” ");
INSERT INTO eri_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ono wainga, taura fai waha no letuwai, “Fai Anyakaro, saini yaage u-u beha, no buliga ganga, ji fai ete-te haifedu, yaage u-u waha langa tafa hiyei nomo uwau. Ariya, ji yage minei nomo boni ononi uwa, nere fai ila ji feiya hidu mini-minide.” ");
INSERT INTO eri_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ono wainga, Yesus no letuwai, “Ne jaidu otodu bonahe, name udu elegedu goyau.” ");
INSERT INTO eri_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ono gainga, fasadu onou fai waha no nomo gogala hilobainga heigainga, no nomo udu elegedu bona goyai. Fati waha no Juda nebere bori nomo fati ete, ");
INSERT INTO eri_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ono wainga, saini nere Juda, fai waha uredu bode letuwane, “Elebe Bori nomo fati, onou waha bona, ne name udu elegedu golowei nomo karuwou inyina.” ");
INSERT INTO eri_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ono wanenga, no lenigai, “Fai no ji geefe gala hilomu hayaha waha, no we ji benou lehiyaha, ‘Ne name kabali tedu bonahe’ ” golowou. ");
INSERT INTO eri_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ono wainga, nere isoki tuwane, “Faiwei no, ‘Ne kabali tedu bonahe, golowei nomo le hinaha?’ ” ");
INSERT INTO eri_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ariya fai no hilobainga heigai waha, no ada isina, faiwei tigiri letuwai, taate bona, fai-aita baingaro matane waha langa golo ganenga, Yesus no goi hilalawai. ");
INSERT INTO eri_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Iinga gainga, Yesus no tempel orei huwanya la goidu fai waha yafa gainga uredu benou letuwai, “Isau. Elebe ne hilobainga heigenaha. Onou waha bona, ne ege une adai tafau. Gamaji oou ete, gai anyakaro ne langa heigoga.” ");
INSERT INTO eri_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ono wainga, fai waha, no goidu bona, nere Juda lenigai, “Fai no ji jigemu hiyai wa no Yesus wenga.” ");
INSERT INTO eri_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ono wainga, nere Juda Yesus inyabamu tuwou hugu warane. Taate bona, no dada onouha waha, no bori nomo fati langa onogai. ");
INSERT INTO eri_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ono wanenga, Yesus no nere lenigai, “Yame Jijei, no haruwe gai-gai teganga mai elebe. Ariya ji fere haruwe te-teni.” ");
INSERT INTO eri_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ono wainga, Juda nere no onou lewainga isidu bode, nere Yesus dukote wogunga, umei nomo bode gaude nigai. Taate bona, no bori nomo fati feiyawai wahanga uwa. No lewai, Itou no nomo umamu tigini. Beele no lewai waha langa, no nogo Itou dorofe heigai. ");
INSERT INTO eri_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ariya, Yesus no nere Juda gidu lenigai, “Ji tere ngalenga letigini, Idau no nogo nomo ninau langa dada ete ada onona. Umamu no ono ganga, Idau no waha ure bona, no onona. Onou waha bona, dada oruwanga, Umamu no onona waha, Idau fere no onona. ");
INSERT INTO eri_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Umamu no Idau bona gaude tuna, waha bona, no dada oruwanga nogo onona waha, Idau abitimu tu-tuna. Onodu ete fere wa, no haruwe aroro ila fere, onowai waha beha feiyawou abitimu tuwonbona. Ono wonga, tere waha bonade horoto wagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jijei no nere fai umou waha jaimu nigidu bona, agenege auma nigi-nigina. Onounga, Idau no fere, no nomo gauwou langa, nere fai agenege auma waha nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jijei no fai ete kot langa ada haawe tu-tuna. Kot haawe nigei nomo haruwe oruwa Idau tuwaiha. ");
INSERT INTO eri_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Onou waha bona, nere fai oruwanga Umamu unyi isoude dorofe, nere edo Idau unyi isou wodbode. Fai no Idau unyi ada isouna waha, no Umamu, Idau huuru tuwainga mai waha, unyi ada isou-isouna.” ");
INSERT INTO eri_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ji tere ngalenga letigini, fai no yame beele isidu bona, no Jijei ji huuru hiyainga meene waha bona, huwanya ngalenga wona wa, fai no waha, ago auma gai-gai yafou waha bagu. Onou waha bona, no kot uwau. No umou awa tuwai, elebe no ago auma yafana. ");
INSERT INTO eri_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ji tere ngalenga letigini, saini heigona onona waha, elebe heigaha. Onou waha bona, nere fai umou waha, nere Itou Idau nomo bolou isodbode. Ono gonga, nere fai-aita bagu isode waha, nere agenege auma todbode. ");
INSERT INTO eri_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jijei no ago auma waha bagu. Onodu no Idau danga tuwai, waha bona Idau nogo fere ago auma waha bagu. ");
INSERT INTO eri_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","No Fai nomo Idau. Onou waha bona, Umamu no, nere fai-aita bagu kot langa tafa nigidu, nebere onowou haawe nagei nomo bona unyi anyakaro tuwai. ");
INSERT INTO eri_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tere yame beele waha bonade, ninatege baingaro adai isagu. Saini heigona ono gonga, nere fai-aita oruwa matmat langa jiride waha idau nomo bolou isodbode. ");
INSERT INTO eri_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Onodu bode, nere matmat awadu, malala mayodbode. Nere fai-aita, onowou hilobainga ono wane waha, nere ege jaidu bode agenege auma yafodbode. Ariya, nere fai onowou inyaba ono wane waha, nere ege jaidu bode, kot la oto wodbode. Ono wogunga, kot no lenigon bona, tere yaae wagu ganga.” ");
INSERT INTO eri_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ariya, Yesus no ege onou lenigai, “Ji yage we, yame ninafe langa, dada ete onowei nomo edo uwa. Beele ji Jijei langa teni waha oojo boni, ji nere fai-aita nebere onowou haawe nigi‑nigini. Ariya, ji yame kot no tigini. Wa taate bona, ji yage yame gauwou oojowei uwa. Ji Jijei no huuru hiyainga meene waha, nomo gauwou oojoni. ");
INSERT INTO eri_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ariya, ji yagenga ji yame haruwe boni, yame onowou boni, ji beele lewoni wa, nere fai-aita beele ji malalamudu leni waha bode huwanyanege ada ngalenga wona. ");
INSERT INTO eri_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Onou wa fai ete yafana, no fere yame haruwe bona, yame onowou bona beele malalamudu lena wa ji isini, wa ngalenga tigini. ");
INSERT INTO eri_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","“Ariya, ji fai ete no yame beele dangamu hayei nomo edolawou ninafe isei uwa. Ariya, ji Itou no tere ege gidu hatigei nomo waha boni gau hina. Onou wa ji isini, amina tere fai ila, Jon la beele tei nomo boya, huuru nigeyenga goyane. Onou waha bona, tere beele Jon no yame haruwe bona, yame fanyife bona letigai waha, ninatege isagu ganga boni gau hina. Nomo beele waha no ngalenga tigini. ");
INSERT INTO eri_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon no lama dorofe no lala bona, nere fai-aita lala nigai. Ono gainga, tere saini tutu langa, nomo lala boya edega wei. ");
INSERT INTO eri_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ariya, dada Jon feiya tuwai waha, elebe no ji malalamu waha lehina. Wa haruwe oruwa Jijei no ji tedu boni, usumuwei nomo bona hiyai. Haruwe ji ononi waha, nere fai-aita bagu malalamu dedu lenigina, Jijei no ji huuru hiyainga mene. ");
INSERT INTO eri_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jijei no ji huuru hiyainga meene, onodu no nogo we ji bona beele malalamudu letigina. Ariya, tere nomo bolou menanga ete isegu uwa. Gai uwanga uwa. Tere no nomo hogo fere menanga ete uregu uwa. ");
INSERT INTO eri_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ariya, nomo beele fere tere la inyei uwa. Wa taate bona, fai Jijei no huuru tuwainga mai waha, tere nomo beele boya huwanyatege ngalenga wegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Ono boya tere benou isi-isiya, Itou nomo beele buk langa inyina waha, no tere agenege auma gai-gai hilobainga yafou waha tigi-tiginawou. Onou waha boya tere Itou nomo beele oruwa buk langa inyina waha lelege boya haawe-haaweya. Ariya Itou nomo buk tere ji bona lelena. ");
INSERT INTO eri_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ariya tere ji bagu maidu, agetege auma tei nomo awaya. ");
INSERT INTO eri_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ji nere fai langa, unyife anyakaro tei nomo boni beele waha lewei uwa. ");
INSERT INTO eri_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Onou wa, ji tere boni ji isini, tere huwanyatege langa tere Itou boya gauwou uwau. ");
INSERT INTO eri_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ji yame Jijei unyi langa meene. Ono wene wa, tere yame beele tei uwa. Ariya fai ete, nogo nomo unyi bona mayona wa, tere nomo beele, fasayadu taagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ariya, tere tebere gane langa, unyitege anyakaro te-teya. Onoya wa, unyige anyakaro Itou no nogonga higina waha, tere tei nomo awaya. Ariya tere fanyimu onouha ono bonade wonga, tere huwanyatege adadu ngalenga wagu ganga? ");
INSERT INTO eri_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ji tere Jijei ago langa, getege beele tafon boni wou adai isagu. Moses no wenga, tere getege beele tafonbona. Fai no tere hoyo tigon bona iya waha. ");
INSERT INTO eri_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tere Moses nomo beele boya huwanyatege ngalenga bonade wonga, tere yame beele bonade fere huwanyatege ngalenga wonbona. Taate bona, no beele yeregai wa, no ji bona beele malalamudu yeregai. ");
INSERT INTO eri_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ariya, tere no beele yeregai waha bonade, huwanyatege ngalenga wegu uwa wonga, wa, adadu tere yame beele bonade huwanyatege ngalenga wonbona?” ");
INSERT INTO eri_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ariya iinga gainga, Yesus no Galili yaage katiwou ulate langa goyai. Yaage katiwou waha nomo unyi ete, Taiberias ide. ");
INSERT INTO eri_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Onodu bona, no taura fai taura jigemu nagei nomo bona, dodoka baingaro tafainga, nere fai-aita toomaro urane. Onodu bode, nere no oojo tuwane. ");
INSERT INTO eri_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ono wanenga, Yesus no muju ouwe langa manidu bona, no nomo disaipel gane bagu gaara yafane. ");
INSERT INTO eri_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Saini waha langa, Juda nebere fati anyakaro higei nomo juguwai. Wa Fati Anyakaro Itou No Israel Awa Nigainga Hilobainga Yafane Waha Isei Nomo Fati. ");
INSERT INTO eri_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus, no fere-fere igedu bona, nere fai-aita toomaro, no bagu mai ganenga nerigai. Onodu bona, no Filip benou igosi tuwai, “Ere beret alanga ejiya wedenga, nere fai-aita beha, nyode?” ");
INSERT INTO eri_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ariya, no Filip nomo isou tonbona onou lewai. Ariya, Yesus no nogo dada adadu onowei nomo waha no amina isai. ");
INSERT INTO eri_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ono wainga, Filip no letuwai, “Ere beret, 200 kina nomo ejiya boya wonga, nere fai-aita matau menanga-menanga tei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ono wainga, nomo disaipel ete, wa Andru, no Saimon Pita nomo bemu, no waha we, Yesus letuwai, ");
INSERT INTO eri_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Fai magana ete yafana beha, no beret anyimu kouwou bali langa bitane bagu, hoowe nga bagu yaasuna. Ariya, nere fai-aita toomaro yafade beha waha, edo ada nigona.” ");
INSERT INTO eri_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ariya haumu walanga jigu baingaro bona, Yesus no nomo disaipel lenigai, tere nere fai-aita bagu lenigadenga yafode. Ono wainga nere leniganenga yafane waha nebere lelege nigou wa 5,000 onou. ");
INSERT INTO eri_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nere fai-aita yafanenga, Yesus no beret waha teedu bona, Itou hilobainga tudu bona, no beret waha wese nagai. Onodu bona, no hoowe nga waha, fere onounga onowai. No nere nigainga, nere nebere gauwou langa eledu bode nyane. ");
INSERT INTO eri_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nere nyidu edo wanenga, Yesus no nomo disaipel lenigai, “Tere da matau-matau otode waha, elege komomu wagu. Gamaji da matau ila heile woga.” ");
INSERT INTO eri_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ono wainga, nere beret anyimu kouwou waha, nyanenga ogonege digainga, matau awaru wane waha komomudu bode, kekele 12 oruwa jiri wane. ");
INSERT INTO eri_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ariya nere fai-aita, no dodoka waha tafainga uredu bode lewane, “Ngalenga tigini, Itou no amina profet no beha ha esene la huuru tuwonga mona lewai waha.” ");
INSERT INTO eri_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ariya, Yesus no beele waha lewanenga no isai. Nere mai no yaasu tudbode, nebere king tafa tuwogunga yafei nomo bona. Onou waha bona, no matane waha awadu bona, no nogonga ege gidu muju la manai. ");
INSERT INTO eri_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ariya esuwa gainga, nere Yesus nomo disaipel nere yaage katiwou la minane. ");
INSERT INTO eri_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nere yaage katiwou waha faadu, Kaperneam goyei nomo bode, nere waaga ete la digane. Ariya, Yesus no nere bagu mai heigei uwa inyi gainga, amina agugu wai. ");
INSERT INTO eri_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ono gainga, jagui anyakaro oto gainga, yaage fere fekula wai. ");
INSERT INTO eri_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ono gainga, nere bot koyadu goi, 5 yo, 6 kilomita onou goi ganenga, Yesus no yaage katiwou waha ouwe langa golodu, bot hinomu langa mai gainga urane. Onodu bode, nere umugane. ");
INSERT INTO eri_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ono wanenga, Yesus no lenigai, “Tere adai umugagu! Be ji wenga maini.” ");
INSERT INTO eri_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ono wainga, nere huwanyanege hilobainga langa, no haudu, bot huwanya langa tani tuwode ono ganenga, fasadu onou, bot goi ha nere goyode ono wane waha langa goi heigai. ");
INSERT INTO eri_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ariya, inyi hamba, nere fai-aita toomaro waha nere yaage katiwou waha ulate langa gai yafane. Nere isane, feyo ganga bot ete uwau, etenga wahanga inyaha. Ono waha wa, Yesus no nomo disaipel gane bagu bot waha langa gaara digei uwa. Nomo disaipel gane nere nagenga bot waha digedu bode goyane. ");
INSERT INTO eri_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ariya, Taiberiasha waaga ila, nere mai haumu Anyakaro no beret Itou hilobainga tuwainga nyane waha la, mai jugu wane. ");
INSERT INTO eri_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ono wanenga, nere fai-aita bagu urane wa, Yesus no nomo disaipel gane bagu walanga gaara yafeg uwa wainga, nere waaga ila-la digedu bode, Yesus, kuru tuwei nomo bode Kaperneam goyane. ");
INSERT INTO eri_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ariya, nere fai-aita, nere yaage katiwou ulate langa goi, Yesus toroba tudbode letuwane, “Isisi higou fai, ne belanga agoi mainaha?” ");
INSERT INTO eri_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ono wanenga, Yesus no nere lenigai, “Ji tere ngalenga letigini, tere dodokawou urei waha boya ninatege isidu, naani ji abitimu tigene waha boya tere kuru hiyegu uwa. Tere beret nyeyenga ogotege digai waha boyadu, tere maidu ji kuru hingaya. ");
INSERT INTO eri_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ariya, tere da inyaba-inyabade waha elegei nomo haruwe adai taagu. Tere da gai-gai inyonbona waha elegei nomo bonade haruwe taagu, wa agege auma gai-gai hilobainga yafou waha nomo da. Da onouha waha, Fai Nomo Idau nowe tigonbona. Jijei Itou no onou onowei nomo bona, no unyi anyakaro tuwaiha.” ");
INSERT INTO eri_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ono wainga, nere letuwane, “Ere adadu onodu boya, ere edo langa Itou nomo haruwe tefuwei nomo?” ");
INSERT INTO eri_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ono wanenga, Yesus no lenigai, “Itou nomo haruwe benou. Tere fai Itou no huuru tuwainga mai waha bonade, huwanyatege ngalengawou.” ");
INSERT INTO eri_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nere beele waha isidu benou isoki tuwane, “Ne taate dodokawou naani dorofe tafahenga, waha uredu boya, ere edo langa name beele boya huwanyage ngalenga wonbona? ");
INSERT INTO eri_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ebere asage gane nere ha fai uwau langa mana nyane, Itou nomo buk langa beele inyina dorofe, ‘No fai-aita bagu ha laluwa nomo beret nigainga nyane.’ ” ");
INSERT INTO eri_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ono wanenga, Yesus no lenigai, “Ji tere ngalenga letigini, Moses no tere ha laluwa nomo beret tigei uwa. Yame Jijei no ha laluwa nomo beret tigini waha, tere tigi-tigina. ");
INSERT INTO eri_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Beret Itou no tere tigina waha, no ha laluwa awadu medu, oulaha fai-aita bagu, agenege auma nigi-nigina.” ");
INSERT INTO eri_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ono wainga, nere no letuwane, “Anyakaro, ne beret waha ere gai-gai higau.” ");
INSERT INTO eri_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ono wanenga, Yesus no lenigai, “Ji yage ji agenege auma nomo beret. Fai no ji bagu mayona waha, no ege huweli ada tuwonbona. Fai no ji bona huwanya ngalenga wona waha, no yaage nyomoli ege ada tuwonbona. ");
INSERT INTO eri_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ariya ji tere letigene, tere ji yeriyeiha, ariya tere huwanyatege ngalengawei uwa. ");
INSERT INTO eri_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nere fai-aita oruwanga, yame Jijei no ji hiyai waha, nere ji bagu mayodbode. Fai no ji bagu mayona wa, ji no ada so tuwoni, gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ji yage yame gauwou oojowei nomo boni ha laluwa awadu meei uwa. Jijei no ji huuru hiyainga nomo gauwou oojowei nomo boni meene. ");
INSERT INTO eri_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ariya, Jijei no ji huuru hiyainga meene waha, nomo gauwou benou. Ji nere fai-aita no hiyai waha, nebereha ete awa tuwei nomo edo uwa. Fati usuwou langa, ji nere jaimu nigonboni. ");
INSERT INTO eri_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ji yame Jijei nomo gauwou benou, nere fai-aita oruwanga Idau uredu bode huwanyanege ngalengana waha, nere agenege auma gai-gai hilobainga yafou waha todbode. Onodu ji fati usuwou langa, jaimu nigonboni.” ");
INSERT INTO eri_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ariya, Yesus no lewai, “Ji yage ji beret beha, ha laluwa awadu mene.” Ono wainga, nere Juda no beele lewai waha isidu bode, nere honggoro bode beele baingaro lewane. ");
INSERT INTO eri_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nere lewane, “Fai beha no Yesus Josep idau. Ere nomo umamu anya ngare boya isiya. Ariya, adadu bona no elebe lena, ‘Ji ha laluwa awadu meeneha.’?” ");
INSERT INTO eri_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ono wanenga, Yesus no nere ege gidu lenigai, “Tere tage-tage gamatege langa beele baingaro adai leguru wagu. ");
INSERT INTO eri_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jijei no ji huuru hiyainga mene. Fai ete no nomo gauwou la ji bagu mayei nomo edo uwa. Jijei no fai waha huwanya jaimu fudu ji bagu haudu mayonbona. Ono wonga, fati usuwou langa, ji fai waha matmat langa jaimu tuwon boni. ");
INSERT INTO eri_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Beele profet nebere buk la inyina waha benou, ‘Itou no nere fai-aita oruwanga isisiwou nigonbona.’ Nere fai-aita oruwa Jijei nomo beele isidu, no langa isou tede waha, nere ji bagu mai-maide. ");
INSERT INTO eri_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ariya, fai ete-te no Jijei urei uwa. Fai no Itou ngare yafadu bona mai waha, no nogonga Jijei uraiha. ");
INSERT INTO eri_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ji tere ngalenga letigini, fai no ji bona huwanya ngalengana waha, no ago auma gai-gai hilobainga yafou waha bagu. ");
INSERT INTO eri_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ji yage, ji agenege auma nomo beret. ");
INSERT INTO eri_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ariya tebere asatege gane nere ha fai uwau langa mana nyane waha, amin umeru wane. ");
INSERT INTO eri_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ariya, beret no ha laluwa awadu mai waha, nere fai-aita bagu edo nyidu, nere ada umode. ");
INSERT INTO eri_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ariya, ji beret ago auma bagu beha, ha laluwa awadu boni meene. Fai ete no beret beha nyi bona wonga, no ago auma gai-gai yafou waha bagu. Ariya, beret ji no tuwoni waha, ji yage yame geefe gala. Ji nigoni waha, nere fai-aita oulaha edo langa agenege auma yafou waha todbode.” ");
INSERT INTO eri_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Juda nere beele waha isidu bode, nere nage‑nage gamanege langa, beele la wara wane. Ono bode nere lewane, “Adadu fai beha no nomo gogala ere higonga nyoya?” ");
INSERT INTO eri_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ono wanenga, Yesus no lenigai, “Ji tere ngalenga letigini, tere Fai Nomo Idau nomo gogala ganemu bagu, ada nyi bonade wonga, tere langa agetege auma waha ada inyonbona. ");
INSERT INTO eri_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ariya, fai no ji yame geefe gala ganefe bagu, nyina waha, no ago auma gai-gai hilobainga yafou waha bagu, onodu fati usuwou langa, ji no ege jaimu tuwon boni. ");
INSERT INTO eri_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Taate bona, ji yame geefe gala waha no da tigini, onodu ji yame ganefe waha no, nyei nomo dada tigini. ");
INSERT INTO eri_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ariya, fai no ji yame geefe gala bagu, ganefe bagu, nyina waha, no ji la yafana. Ono ganga, ji no la yafani. ");
INSERT INTO eri_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jijei ago auma bagu waha no ji huuru hiyainga meene, ji no nomo danga langa ji agefe auma yafani. Onounga, fai no ji nyi hi bona wonga, no ji yame danga langa no ago auma tonbona. ");
INSERT INTO eri_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ariya, beret behanga no ha laluwa awadu bona maiha. Beret beha no amina tere tebere asatege gane nyidu bode, inga nere umeru wane dorofe uwa. Fai no beret beha nyi bona wonga, no ago auma gai-gai yafonbona.” ");
INSERT INTO eri_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus no Kaperneam taon langa, bori mata huwanya la yafa bona, isisiwou beha nigonbona beele beha lenigai. ");
INSERT INTO eri_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ariya, nomo disaipel nere Yesus nomo beele waha isidu bode nebereha baingaro nere benou lewane, “Beele beha gai ou bagu. Faiwei no isei nomo edo?” ");
INSERT INTO eri_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ono ganenga, Yesus no nomo huwanya langa, nomo disaipel nere beele no lewai waha bode beele baingaro leganenga amina isai. Onodu bona, no isoki nigai, “Beele beha no tebere huwanyatege ngalengawou inyabamu tagaha yo? ");
INSERT INTO eri_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ariya, tere Fai Nomo Idau no ege gidu bona, haumu no amina yafai waha langa mani gonga uredu bonade, ariya tere adadu? ");
INSERT INTO eri_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hauri Guuni no we fai-aita bagu agenege auma nigi-nigina. Gege gala no menanga hoyo higei nomo edo uwa. Ariya, beele ji letigini beha no hauri onodu no ago auma bagu. ");
INSERT INTO eri_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ariya, fai ila tere gamatege langa, nere huwanyanege ngalenga wegu uwa.” Nere fai huwanyanege ngalenga wegu uwa waha Yesus no amina isi nigaiha. Onodu fai no honggoro fai owonege la tafa tuwona bona waha no amina isi tuwaiha. ");
INSERT INTO eri_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Onou bona Yesus no lewai, “Nere huwanyanege ngalengawei uwa, hugu waha bona ji letigeneha, ‘Jijei no fai ete danga tuwei uwa wonga wa, fai waha no ji bagu mayei nomo edo uwa.’” ");
INSERT INTO eri_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesus no beele waha malalamudu lenigi boro wainga, nomo disaipel baingaro, nere ege gidu goyane, nere ege no ngate gaara golo wegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ono wanenga, Yesus no nomo disaipel 12 waha isoki nigai, “Tere fere ji awa hidu goyagu ganga yo?” ");
INSERT INTO eri_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ono wainga, Saimon Pita no ege gidu benou letuwai, “Anyakaro, ere faiwei bagu goyoya? Ne name beele wahanga, ere agege auma gai-gai hilobainga yafou waha higi-higina. ");
INSERT INTO eri_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Onodu ere huwanyage ngalenga ganga tigini benou isiya, ne fai hilobainga tigini beha, Itou no nogo nomo bona hangada hinai.” ");
INSERT INTO eri_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ono wanenga, Yesus no ege gidu benou lenigai, “Adadu? Ji yage, tere disaipel 12 hangada tigeneha. Ariya, tere gamatege langa, ete waha no hauri inyaba dorofe.” ");
INSERT INTO eri_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wa, no Saimon Iskariot nomo idau Judas bona lewai. No disaipel 12 waha nebereha ete, ariya iinga gainga, no Yesus nere fai dukotewei nomo owonege langa tafa tuwai. ");
INSERT INTO eri_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ariya, iinga saini ila langa, Yesus no Galili distrik huwanya langanga golowai. No ege Judia distrik langa, goidu golowei nomo awai, taate bona, Juda nere no dukote wodbode ono wane. ");
INSERT INTO eri_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ono gainga, Juda nebere bori nomo fati aroro nere heigode jugu wane. Fati Aroro wa, Youyou Mata Langa Yafei Nomo Fati. ");
INSERT INTO eri_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Onou bona, nomo bemu gane benou letuwane, “Ne matane beha awadu Judia goyau, ono wahenga, name disaipel nere ne haruwe hogo fere-fere te-teni waha urodbode. ");
INSERT INTO eri_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Onou wa, fai ete no, fai isi tuwode wonga, no haruwe haumu huwari la ada ono-onona. Ne dada onouha onowau ganga wonga, ne malala otodu fai-aita oruwanga agenege langa onowau.” ");
INSERT INTO eri_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nomo bemu gane fere, nere no bode huwanyanege ngalengawei uwa, waha bona, nere onou letuwane. ");
INSERT INTO eri_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ono wanenga, Yesus no beele ege gidu lenigai, “Ji yame saini iinga heigei uwa inyina. Ariya, saini oruwa wa, tebere saini. ");
INSERT INTO eri_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nere fai-aita oulaha tere honggoro langa ada tafa tigodbode. Nere ji honggoro hiyodbode, taate bona, ji nere nebere fanyinege inyaba, waha boni beele malalamudu le‑leni. ");
INSERT INTO eri_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Onou waha bona, tere bori nomo fati aroro waha langa Jerusalem managu. Ji walanga ada manoni, taate bona, ji yame saini iinga heigei uwa inyina.” ");
INSERT INTO eri_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","No onou lenigidu bona, no Galili walanga itaridu yafai. ");
INSERT INTO eri_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ariya, saini nomo bemu gane mani hara ganenga, Yesus no fere, iinga huunta manai. Ariya, no fai adai uroguga bona no huwari manidu golowai. ");
INSERT INTO eri_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ono gainga, Juda nebere fai aroro nere, bori nomo fati aroro waha langa no kuru tunga wane, ono bode lewane, “Fai waha alanga yafana?” ");
INSERT INTO eri_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ono gane, nere fai-aita no bode beele baingaro, nere nage gamanege langa leguruwane. Nere ila lewane, “No fai hilobainga.” Ono ganenga, nere ila lewane, “Uwa, no fai-aita yaawa nigi-nigina.” ");
INSERT INTO eri_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ono bode, nere Juda nebere fai araro umuge nigi bode, fai ete no nomo onowou bona beele malala lewei uwa. ");
INSERT INTO eri_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ariya, fati aroro waha nomo fati gamala, Yesus no tempel nomo orei huwanya la goidu bona, nere fai-aita isisiwou nigai. ");
INSERT INTO eri_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ono wainga, nere Juda nomo beele waha isidu bode ninanege baingaro isi bode lewane, “Adadu bona fai beha no isou benouha bagu? No skul langa goyei uwa.” ");
INSERT INTO eri_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ono wanenga, Yesus no nere ege gidu benou lenigai, “Beele ji tere letigini beha, yame beele uwa. Wa Itou nomo beele, no ji huuru hiyainga meene. ");
INSERT INTO eri_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Onou waha bona, fai ete no Itou nomo beele oojowei nomo tigini gau tuwei mata wonga wa, no beele ji leni beha nomo hugu tigini isi dewonbona. Onodu bona, no isona bona, beele beha, Itou langa maina yo, uwa, ji yage yame ninafe langa heigena. ");
INSERT INTO eri_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ariya, fai no nogo nomo ninau langa beele lena wa, no nogo nomo unyi jaimu wona onona. Ariya fai no, fai huuru tuwainga mai waha nomo unyi isouwei nomo gau tuna waha, fai no waha fai tigini. No yaawawou fai uwau. ");
INSERT INTO eri_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Amina, Moses no nuuni beele tigaiha. Ariya, tere gamatege langa, fai ete no nuuni beele waha ada oojo-oojona. Onou waha bona, tere taate boya ji duufe kote wagu ganga onoya?” ");
INSERT INTO eri_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ono wainga, fai-aita nere ege gidu benou letuwane, “Hauri inyaba ete ne langa inyina rute. Faiwei ne dute kote wonga umau ganga leni?” ");
INSERT INTO eri_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ono wanenga, Yesus no ege gidu lenigai, “Ji haruwe etenga ono wenenga, tere oruwa ninatege baingaro isei. ");
INSERT INTO eri_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Onou wa isagu Moses no genege gala karu nagei nomo fanyimu waha tigaiha, ariya tere bori nomo fati langa fere, magana mene-mene genege gala karu nagi-nagiya. Ngalenga, Moses no nogo fanyimu waha heigemuwei uwa. Tere tebere asatege gane langa heigai. ");
INSERT INTO eri_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ariya, tere Moses nomo beele oojo dewagu ganga bori nomo fati langa magana genege gala karu nagi-nagia. Ariya ji bori nomo fati langa fai ete gogala jigemu tu dewehenga, tere taate boya ji bonade houtege mayonbona? ");
INSERT INTO eri_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tere agetege magana ewe langa, dada adai haawe wagu. Tere dada oruwanga, onowou ngalenga wahanga la haawe wagu.” ");
INSERT INTO eri_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ariya, nere Jerusalemha fai-aita ila, dada Yesus onowainga uredu bode lewane, “Adadu? Fai no behanga, nere fai araro no dukotewei nomo bode ono-onode. ");
INSERT INTO eri_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ariya uragu. No beele malala gamala lena, nere no beele ete letuwegu uwa. Nere iside rute, fai no beha Itou no fai-aita bagu gidu hanigei nomo beele baara tawai waha huuru tuwainga maai? ");
INSERT INTO eri_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ariya, ere fai beha nomo matane hugu ere isiya. Onou wa, saini fai Itou no huuru tuwonga monbona, beele baara tawai waha heigona la, fai ete no nomo matane hugu bona ada isona.” ");
INSERT INTO eri_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ariya, Yesus no tempel langa yafa bona, nere fai-aita beele malalamudu lenigai. Onodu no yauredu benou lewai, “Tere ji boya isiya, ji yame matane hugu boya isiyawou leya yo? Onou wa ji yage yame gauwou langa meei uwa. Jijei no ji huuru hiyainga meene. No nomo onouwou wa tigini. Ariya tere no boya ada isiya. ");
INSERT INTO eri_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ji no boni isini. Ji no ngare yafere, onodu no ji huuru hiyainga meene.” ");
INSERT INTO eri_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ono wainga nere beele waha isidu bode, no dagou mata langa tafa tuwodbode ono wane. Ariya, no nomo saini iinga heigei uwa inyina, onou waha bona, fai ete no langa owo tafei uwa. ");
INSERT INTO eri_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ariya, nere fai-aita baingaro no bode huwanyanege ngalenga wainga nere lewane, “Saini Itou no fai waha huuru tuwonbona beele baara tawai waha heigona la, no dodokawou baingaro fai beha onona waha feiya tuwou ono wona rute?” ");
INSERT INTO eri_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ariya, Yesus no dada onowai waha fai nere uredu bode, beele hogo fere-fere lewanenga Farisi nere isane. Onodu bode, nere Pris araro bagu, nere Farisi bagu, Yesus yaasu tuwei nomo bode, polis huuru niganenga mayane. ");
INSERT INTO eri_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ono wanenga, Yesus no lewai, “Ji tere bagu saini tutu mene yafon boni, onodu ji Jijei bagu ege gidu manon boni, no ji huuru hiyainga meene. ");
INSERT INTO eri_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ono wehenga, tere ji kuru hiyagu wa, tere ji ada yeriyagu ganga. Haumu ji yafoni waha langa, tere manei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ono wainga, Juda nere nage-nage benou leguru wane, “No alanga goyonga, ere no ada uroboya lena? No ebere gane nebere kantri Grik langa yafade la goidu bona isisiwou nigona rute? ");
INSERT INTO eri_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","No benou lewaha, ‘Tere ji kuru hiyagu wa, tere ji ada yeriyagu ganga.’ Ha ji yafoni waha langa, tere mayei nomo edo uwa. Waha nomo hugu adadu?” ");
INSERT INTO eri_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bori anyakaro waha nebere fati usuwou wa nere fati gai anyakaro tigini. Ariya fati waha langa, Yesus no oto bona yauredu lewai, “Fai ete no yaage nyomoli tuwonga wa, no edo ji bagu maidu bona yaage nyona. ");
INSERT INTO eri_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wa Itou nomo buk langa inyina dorofe. Fai no ji bona huwanya ngalengana wa, no yaage agenege auma nomo baingaro huwanya langa heigedu guriyena dorofe.” ");
INSERT INTO eri_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ariya, Yesus no Hauri Guuni bona lewai. Nere fai no bode huwanyanege ngalengade waha, nere Hauri Guuni todbode. Saini beha langa, Yesus no unyi anyakaro tei uwa inyina, waha bona Hauri Guuni no mei uwa inyina. ");
INSERT INTO eri_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ariya, nere fai-aita ila Yesus nomo beele isidu bode lewane, “Ngalenga tigini, fai beha no profet, Itou no amina huuru tuwonga oula langa mei nomo bona lewai waha.” ");
INSERT INTO eri_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ono wanenga, nere ila lewane, “No fai, Itou no nomo fai-aita ege gidu hanigei nomo hangada tuwai waha.” Ono ganenga, nere ila lewane, “Uwa. Fai Itou hangada tuwai waha no Galili langa ada heigona. ");
INSERT INTO eri_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Itou nomo buk no benou lena, fai waha no King Devit nomo ganemu la heigonbona. Onou waha bona, no Betlehem taon amina Devit yafai waha langa heigonbona.” ");
INSERT INTO eri_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Onodu, fai-aita nere Yesus bode isou fere-fere tedu nere foure nga wane. ");
INSERT INTO eri_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Onodu nere ila no dagou mata langa tafa tuwei nomo ono wane, ariya fai ete no langa owo tafei uwa. ");
INSERT INTO eri_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ariya, polis nere ege gidu bode, pris aroro bagu Farisi bagu langa goyane. Ono wanenga, nere isoki nigane, “Ada wanga tere no haudu mayegu uwa?” ");
INSERT INTO eri_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ono wanenga, polis nere ege gidu benou lenigane, “Fai ete amina, fai beha beele lena dorofe, ete lewei uwa.” ");
INSERT INTO eri_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Onou leniganenga, nere Farisi ege gidu benou lenigane, “Tere fere no yaawa tigaha rute? ");
INSERT INTO eri_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tere ere mora bagu, nere Farisi bagu, ebereha ete no bona huwanya ngalenga wanga ureyaha yo? Gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ariya, nere no bode huwanyanege ngalengana waha, wa nere fai-aita bagu nuuni beele ada iside waha. Itou no nere yaewei nomo leboro waiha.” ");
INSERT INTO eri_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus no amina Yesus bagu goyaiha, no waha nebereha ete. Onou bona, no benou lenigai, ");
INSERT INTO eri_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ere ebere nuuni beele no ere fai ete ewe auma kot langa tafa tuwei nomo lena yo? Uwa. Ngasunga ere no nomo beele aagudu boya, ere no taate dada onowai waha boya isi dewoboya.” ");
INSERT INTO eri_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ono wainga, nere nomo beele waha ege gidu benou letuwane, “Ne fere, ne Galiliha fai rute? Itou nomo buk langa beele inyina waha lelege dewau, onodu ne fere isau ganga, profet ete Galili walanga ada heigonbona.” ");
INSERT INTO eri_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ariya, nere fai oruwanga nebere mata-mata goyane, ");
INSERT INTO eri_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ono ganenga Yesus no Oliv muju langa manai. ");
INSERT INTO eri_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Onodu eringe amina, no ege tempel orei huwanya langa goyai. Ono wainga, nere fai-aita oruwanga, no bagu mayane. Ono wanenga, no yafa bona nere isisiwou nigai. ");
INSERT INTO eri_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ono gainga, nere nuuni beele isou fai bagu, nere Farisi bagu, aita ete no fai bagu, no longi tafa gainga uredu haudu mai fai-aita agenege langa tafa tuwanenga otowai. ");
INSERT INTO eri_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Onodu bode, nere Yesus letuwane, “Isisi higigou fai, aita beha no longi tafa gainga urane. ");
INSERT INTO eri_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Onou bona, nuuni beele langa Moses no benou lewai, aita benoha waha ere megebu ayarudu waredenga umonbona. Ariya, ne adadu leni?” ");
INSERT INTO eri_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nere no wala-wala tuwou beele waha letuwane, taate bona, no beele ete lewonga, nomo beele waha langa, no edo kot la tafa tuwei nomo bode, onowane. Ono wanenga, Yesus no oogudu bona, owo duma langa, oula la yeregai. ");
INSERT INTO eri_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ono gainga, nere ege-ege isoki tuwane. Ono wanenga, no jaidu oto bona lenigai, “Fai ete no tere gamatege langa, no une uwau wonga wa, fai no waha amugedu aita waha megebu ayadu warona.” ");
INSERT INTO eri_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Onodu bona, no ege oogudu oula la yeregai. ");
INSERT INTO eri_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ono wainga, nere fai beele waha isidu bode, nere oruwa etenga-etengadu haumu waha awa tuwane. Nere fai hilou-hilou, nere amugedu heige ganenga, nere ila iinga mogonege tagadu heigane. Ono wanenga, Yesus no nogonga gai ogudu yafa gainga aita waha no gai onou hogo langa otowai. ");
INSERT INTO eri_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ono gainga, Yesus no otodu bona, aita waha isoki tuwai, “Aita, fai nere waha alanga goyane? Fai ete ne kot la tafa hinei nomo uwau rute?” ");
INSERT INTO eri_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ono wainga, aita waha no letuwai, “Fai Anyakaro, fai ete uwau.” Ono wainga, Yesus no letuwai, “Ji fere, ne kot langa ada tafa hinoni. Ariya ne goyau, iinga une ege adai tafau.” ");
INSERT INTO eri_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ariya, Yesus no ege fai-aita bagu benou lenigai, “Ji yage ji oula nomo lala. Fai no ji oojo hi bona wonga, no agugu langa ada golowona. Uwa. No ago auma nomo lala bagu.” ");
INSERT INTO eri_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ono wainga, nere Farisi beele waha isidu bode, Yesus letuwane, “Ne nage name haruwe boni, name fanyite boni, beele le-leni. Onou waha bona, nere fai ne beele leni waha bode huwanyanege ada ngalenga wona.” ");
INSERT INTO eri_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ono wanenga, Yesus no beele ege gidu benou lenigai, “Wa ngalenga, ji yage yame fanyife boni beele le-leni. Onou wa, nere fai yame beele bode edo huwanyanege ngalenga wode, taate bona, ji haumu alanga jaidu meene waha ji isini, onodu ji haumu alanga goyon boni waha ji isini. Ariya, tere ji yame matane hugu waha tere ada isiya. Onou wa, ji alanga goini waha fere, tere alai uwa. ");
INSERT INTO eri_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tere fai oula nomo fanyimu langa haawe nigi-nigiya. Ariya, ji fai ete ada haawe tutuni. ");
INSERT INTO eri_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Onou wa, ji fai ete nomo onowou haawe fuwoni wonga, nere fai ji beele leni beha bode edo huwanyanege ngalenga wonbona, taate bona, ji yagenga no haawe tuwei uwa. Jijei no ji huuru hiyainga meene waha, no ji ngare haruwe yare. ");
INSERT INTO eri_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ariya, tere tebere nuuni beele langa, beele benou inyina. Fai nga nere beele hogo etenga leworunga wa, neire beele wa ngalenga. ");
INSERT INTO eri_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ji yage, ji yame haruwe boni, yame fanyife boni beele le-leni. Ono genenga, Jijei no ji huuru hiyainga meene waha, no fere ji yame haruwe bona, yame fanyife bona beele le-lena.” ");
INSERT INTO eri_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ono wainga, Farisi nere no isoki tuwane, “Ne Amene boni leni waha, no alanga yafana?” Ono wanenga, Yesus no ege gidu benou lenigai, “Tere ji boya alai uwa, waha boya tere yame Jijei boya fere, tere alai uwa. Tere ji boya alai wage wa, tere yame Jijei bona fere, tere alai tuwage.” ");
INSERT INTO eri_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ariya, Yesus no tempel huwanya langa tempel nomo moni logosigou jauli waha jugunga langa, no fai-aita bagu isisiwou nigi bona, beele waha lenigai. Ariya, fai ete-te no yaasu tuwei uwa, taate bona, no nomo saini heigei uwa inyina. ");
INSERT INTO eri_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus no fai-aita bagu ege onou lenigai, “Ji amina goini, tere ji ege ada yeriyagu ganga. Ariya, tere tebere une gai inyi gonga, tere umeru wagu ganga. Haumu ji goini waha langa, tere ada goyagu.” ");
INSERT INTO eri_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ono wainga, nere Juda beele waha isidu bode, nere nage-nage isoki guru wane. “Adadu bona no onou lena, ‘Tere haumu ji goini waha langa, tere ada goyagu ganga.’ Onou wa, no nogo dukotedu umonaru lena?” ");
INSERT INTO eri_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ono wanenga, Yesus no lenigai, “Tere fai-aita esene beha nomo. Ji ha ouweha. Onou waha bona, tere oula beha nomo. Ji oula beha nomo uwa. ");
INSERT INTO eri_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Onou waha boni, ji letiginaha, tere Ji Yage Ji Onou Yafagou waha bonade, huwanyatege ngalengawei uwa wonga, tere umeru wagu wa, tebere une gai inyonbona.” ");
INSERT INTO eri_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ono wainga, nere no isoki tuwane, “Ne faiwei?” Ono wanenga, Yesus no lenigai, “Ji faiwei waha ji amina letiginaha. ");
INSERT INTO eri_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ji tere tebere fanyitege boni, beele baingaro lewonboni. Onodu ji jas dorofe tebere fanyitege haawe tagonboni. Onodu fai no ji juuru hiyainga meene waha nomo onowou no ngalenga tigini. Onodu beele oruwa ji no langa isene waha, ji oula beha nomo fai-aita bagu malalamudu lenigini.” ");
INSERT INTO eri_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ono wainga, nere Yesus no Umamu bona lenawou nere foo nigei uwa, ");
INSERT INTO eri_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ono wanenga, no lenigai, “Saini tere Fai nomo Idau isou tubonade benou isagu ganga, Ji Yage Ji Onou Yafagou. Ono bonade, tere isagu ganga ji yage yame ninafe langa dada ete ada ononi. Uwa. Ji beele le-leni wa orunga ji yame Jijei no abitimu hiyai onounga leni. ");
INSERT INTO eri_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jijei no ji huuru hiyainga meene waha, no ji bagu yafana. No ji awa hiyainga ji yagenga yafei uwa. No awa hiyei uwa, taate bona, dada no gau tuna waha ji gai-gai ono-ononi.” ");
INSERT INTO eri_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ariya, Yesus no beele waha lewainga isidu bode, nere fai-aita bagu baingaro no bode huwanyanege ngalenga wane. ");
INSERT INTO eri_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ariya, Yesus no nere Juda no bode huwanyanege ngalenga wane waha lenigai, “Tere yame beele danga bagu yaasu bonade wonga, tere yame disaipel tigini yafagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Onodu tere beele ngalenga waha isadenga, beele ngalenga waha ono tigonga tere hilobainga yafagu ganga.” ");
INSERT INTO eri_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ono wainga, nere nomo beele waha ege gidu benou letuwane, “Ere Abraham nomo ganemuha. Ere saini ete-te, fai ete nomo haruwe magana ewe yafei uwa. Onou waha bona, adadu boni ne leni, ‘Tere hilobainga yafagu ganga higini?’” ");
INSERT INTO eri_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ono wanenga, Yesus no nebere beele ege gidu benou lenigai, “Ji tere ngalenga letigini, nere fai oruwanga une tafa-tafade waha, nere une nomo haruwe magana ewe yafade. ");
INSERT INTO eri_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ariya, nere haruwe magana ewe nere gai-gai mata langa ada yafa-yafade. Uwa. Magana no nogonga no gai-gai yafa-yafana. ");
INSERT INTO eri_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Onou wa, magana no tere ono tigonga hilobainga yafagu wa, tere gai hilobainga tigini yafagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Ji tere Abraham nomo ganemuha waha isini. Ariya, ji yame beele, tere huwanyatege langa inyei uwa. Onou waha bona, tere ji dufe kote wadenga, umei nomo onoya. ");
INSERT INTO eri_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ji dada oruwa, yame Jijei no amina abitimu hiyai waha malalamudu le-leni. Ariya, tere nu fanyimu tebere ametege gane langa elegeye waha ono-onoya.” ");
INSERT INTO eri_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ono wainga, Juda nere Yesus nomo beele waha isidu bode, nere ege gidu benou letuwane, “Ere ebere asage amege bagu Abraham.” Ono wanenga, Yesus no nere lenigai, “Tere ngalenga Abraham asa, idau gane wage wa, tere fanyimu Abraham no onogai onounga ono wage. ");
INSERT INTO eri_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ji beele ngalenga Itou langa isene waha, ji tere letigeneha. Ono wene waha, elebe tere ji dufe kote wadenga umei nomo onoya. Fanyimu onouha waha Abraham nomo uwa. ");
INSERT INTO eri_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tere ametege gane nebere fanyinege wahanga onoya.” Ono wainga nere letuwane, “Ere ebere anyage gane nere longi tafadu bode ere bisi higegu uwa. Ere ebere Amege etenga, wa Itou no nogonga.” ");
INSERT INTO eri_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ono wanenga, Yesus no nere lenigai, “Itou no ngalenga tebere Ametege wage wa, tere ji gau hiyage, taate bona, ji Itou ngare yafadu meene. Ji yage yame isou langa meei uwa. Itou no ji huuru hiyainga meene. ");
INSERT INTO eri_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Onou wa, tere taate boya yame beele boya foo tigi dewei uwa? Waha nomo hugu benou, tere yame beele isei nomo awaya. ");
INSERT INTO eri_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tere tebere ametege Satan, tere nomo idau gane. Onodu tere tebere ametege nomo gauwou oojo wagu ganga danga tafa-tafaya. Amina langa no fai dunege kotegou fai yafai. Ono bona, no fanyimu tigini waha ada oojogai, taate bona, fanyimu tigini waha no langa ada inyigai. No yaawawou beele waha nomo beele tigini dorofe. No yaawa beele legou fai, onodu no yaawa beele legou nomo umamu tigini. ");
INSERT INTO eri_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ariya, ji nu beele ngalenga waha malalamudu legenenga, tere yame beele waha boya huwanyatege ada ngalengana. ");
INSERT INTO eri_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tere isiya, ji une tafene iya yo? Tere onou isiya wonga, tere yame nyabuliwou waha malalamu hayagu. Ariya ji beele ngalenga waha, malalamudu lewehenga wa, tere taate boya yame beele waha bona huwanyatege ngalengawei uwa? ");
INSERT INTO eri_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nere Itou nomo magana gane waha, nere Itou nomo beele oruwa isi-iside. Ariya, tere Itou nomo magana gane uwa, waha boya, tere nomo beele ada isi-isiya.” ");
INSERT INTO eri_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ariya Juda nere, Yesus nomo beele ege gidu benou letuwane, “Ere leya, ne Samariaha fai hauri inyaba ete ne langa inyina wa ngalenga yo?” ");
INSERT INTO eri_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ono wanenga, Yesus no nere benou lenigai, “Hauri inyaba ete te ji langa inyei uwa. Ariya, ji yame Jijei unyinga isou genenga, tere ji unyife esenemuya. ");
INSERT INTO eri_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ji yage yame unyife isouwei nomo ada ono-ononi. Ji yame unyife isouwei nomo Fai ete bagu, onodu no jas. ");
INSERT INTO eri_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ariya, ji tere ngalenga letigini, fai ete no ji yame beele oojo bona wonga, no ada umonbona. Gai umanga uwa.” ");
INSERT INTO eri_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ariya, Juda nere Yesus benou letuwane, “Elebe ere isiya, hauri inyaba ete ne langa inyina. Abraham no umaiha, profet fere nere umeru waneha. Ariya ne leni, ‘Fai ete ji yame beele oojo debona wonga, no ada umonbona.’ ");
INSERT INTO eri_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Adadu? Ne ebere asage Abraham feiya tuwou yo? No umaiha. Nere profet fere umeru waneha. Onou bona ne isini, ne faiwei tigini?” ");
INSERT INTO eri_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ono wanenga, Yesus no nere ege gidu benou lenigai, “Ji yage unyife jaimu boni wonga, ji yame unyife waha no dada ewe. Ariya, yame Jijei no ji unyife jaimuna. Ono ganga tere leleya no tebere Itou. ");
INSERT INTO eri_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Onoyawa, tere no boya ada isiya. Ji nu, ji no boni alai. Onou waha boni, ji benou lewoni wa, ‘Ji no boni alai uwa.’ Ji tere dorofe yaawagou fai heigonboni. Ariya, ji no boni alai waha boni ji no nomo beele oojo de-deni. ");
INSERT INTO eri_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Tebere asatege Abraham, no ji yame saini waha urei nomo ninau isidu bona, no edega dewai. Onodu saini no ure borodu bona, no nomo huwanya hilobaingawai.” ");
INSERT INTO eri_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juda nere beele waha isidu bode, nere Yesus benou letuwane, “Ne name haga orei 50 wei uwa inyi gainga ne Abraham ureneha?” ");
INSERT INTO eri_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ono wanenga, Yesus no nere lenigai, “Ji tere ngalenga letigini, Abraham no heigei uwau langa, Ji Yage Ji Onou Yafagou.” ");
INSERT INTO eri_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesus no Juda onou lenigainga, nere megebu elegedu bode, no warode ono wane. Ono ganenga, no huwari tempel nomo orei huwanya awa tudu, malala heigai. ");
INSERT INTO eri_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus no golodu goi bona, fai ete ago magana fosokowou onounga anya bisi tuwai waha urai. ");
INSERT INTO eri_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ono wainga, nomo disaipel nere isoki tuwane, “Isisi higigou fai, faiwei no une tafainga, fai beha no ago magana fosokowou onounga anya bisi tuwaiha? Fai no beha nogo we une tafai yo, uwa no nomo umamu anya ngare une tafareha?” ");
INSERT INTO eri_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ono wanenga, Yesus no benou lenigai, “Fai beha no une tafei uwa, no nomo umamu anya ngare fere une taferu uwa. Dada beha heigai wa, nere fai-aita edo dada fai beha langa heigonga urei nomo bona, ono wonga Itou nomo haruwe edo nere langa malala heigona bona. ");
INSERT INTO eri_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Elebe hamba waha inyina, Itou no ji huuru hiyainga meene waha nomo haruwe te fuwei nomo. Ooru wonga, fai nere haruwe ete onowei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Saini ji oula beha langa yafani la, ji yage ji oula beha nomo lala.” ");
INSERT INTO eri_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesus no onou lenigidu bona, mulugu oula la bisingawai. Onodu mulugu oula bagu ubulumudu, oula waha fai ago fosokowou ago magana langa tafa fuwai. ");
INSERT INTO eri_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Onodu no letuwai, “Ne goidu bonahe, yaage u-u Siloam langa yaage bisau.” Unyi Siloam no beele beha dorofenga, “Nere huuru tuwanenga goyai.” Ono wainga, no goidu yaage bisai. Saini no ege gidu mayai langa, no ege dada nerige dewei nomo edo la. ");
INSERT INTO eri_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ono wainga, nere nomo matane etenga bagu, nere fai amina no yafa bona, fai-aita bagu moni dada tuwei nomo bona isoki nigi gainga, urane waha nere lewane, “Adadu? Fai behanga, no amina yafa bona fai moni dada bona isoki nigigai waha rute?” ");
INSERT INTO eri_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ono ganenga, nere ila lewane, “Ngalenga, no fai no waha.” Ono ganenga nere ila lewane, “Uwa, be fai ete, no fai waha dorofenga.” Ono ganenga, fai waha no nogo lenigai, “Be ji wenga.” ");
INSERT INTO eri_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ono wainga, nere isoki tuwane, “Ne adadu ono wenenga, name agene magana hilou waiha?” ");
INSERT INTO eri_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ono wanenga, no ege gidu benou lenigai, “Nere fai Yesus tude, no waha oula yaage bagu ubulumudu bona, agefe magana langa tafa hayaiha. Onodu bona, no lehiyai, ‘Ne goidu Siloam yaage u-u langa yaage bisau hiyai.’ Ono wainga ji goidu bisenenga, yame agefe magana hilou waiha, onou waha bona, ji dada edo nerige dewon boni.” ");
INSERT INTO eri_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ono wainga, nere isoki tuwane, “Fai waha no alanga yafana?” Ono wanenga no lenigai, “Ji ada isini.” ");
INSERT INTO eri_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ariya, nere fai amina ago magana fosokowai waha, haudu bode Farisi bagu goyane. ");
INSERT INTO eri_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Saini Yesus no oula buru ubulumudu bona, fai ago magana fosokowou isebu fuwai wa, no Bori nomo fati langa no onowai. ");
INSERT INTO eri_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ariya, nere Farisi no ege isoki tuwane, “Name agene magana waha, adadu hilou waiha?” Ono wanenga, no lenigai, “No ji agefe magana langa oula buru tafa hayainga, ji yaage bisene, elebe ji dada edo nirige dewon boni.” ");
INSERT INTO eri_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ono wainga, nere Farisi ila lewane, “Itou no fai beha huuru tuwainga meei uwa, taate bona, no Bori nomo nuuni beele ada oojo-oojona.” Ono wanenga, nere ila lewane, “Fai no une bagu waha, adadu no dodokawou benoha tafei nomo edo?” Onodu bode, nere foure nga wane. ");
INSERT INTO eri_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Onodu Farisi nere fai amina ago magana fosoko wainga yafai waha ege isoki tuwane, “Fai no ne agene jigemu hanai waha no fai adohawou isini?” Ono wanenga, no lenigai, “No waha profet ete.” ");
INSERT INTO eri_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wa ngalenga, amina fai waha no ago magana fosokowou, elebe no igeina. Ariya Juda nere huwanyanege ngalengawei uwa. Onou bode nere fai ago hilouwai waha, nomo umamu anya ngare yaure niranenga mayare. ");
INSERT INTO eri_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nere mayarenga, benou isoki nirane, “Magana beha, teire idatere yo? Saini no anya bisi tuwai langa, no ago magana fosokowou, tere onou leyare yo? Onou wa, adadu bona no elebe igeina?” ");
INSERT INTO eri_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ono wanenga, umamu anya ngare nere lenigare, “Ere isiyare, be eire idare. Saini anya bisi tuwai la, no ago magana fosokowou onounga heigai, waha fere ere isiyare. ");
INSERT INTO eri_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ariya elebe, no ago magana adadu langa hilou waha wa, ere ada isiyare. Faiwei no ago magana hilomu fuwaha waha fere, ere alai uwa. Tere no nogo isoki tuwagu. No anyakaro waha. Ono wadenga, no nogo bona nogo we lewon bona.” ");
INSERT INTO eri_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ariya, umamu anya ngare, nere Juda umuge nigi bodere onou leware. Juda nere beele agili mala ete benou karu wane, fai ete no benou lewonga wa, Yesus no Itou nomo fai-aita ege gidu hanigei nomo hangada tuwai, nere fai waha gaara bori urei nomo karu tuwodbode. ");
INSERT INTO eri_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hugu waha bodere, magana waha umamu anya ngare nere lenigare, “No anyakaro waha, onou waha bona, tere no nogo isoki tuwagu.” ");
INSERT INTO eri_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ono warenga, nere fai magana amina ago magana fosokowai waha, ege yaure tuwane. Onodu nere letuwane, “Ne Itou unyi isou bonahe, ne ngalenga beele lewei nomo wahanga danga bagu, beele baara tawau. Ne fai waha boni lenaha wa, ere isiya, no une tafagou fai.” ");
INSERT INTO eri_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ono wanenga, no lenigai, “No fai une tafagou yo, uwa yo, waha ji ada isini. Ji dada etenga wahanga boni, ji isini. Ji amina agefe magana fosokowou waha, elebe ji igeini.” ");
INSERT INTO eri_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ono wainga, nere isoki tuwane, “No adadu ono hinaha? No agene adadu isebu hanaha?” ");
INSERT INTO eri_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ono wanenga, no ege gidu lenigai, “Ji tere amina letiginaha, ariya tere beele waha isei nomo awaya. Tere taate boya ege-ege isagu ganga isoki hiya? Tere fere no nomo disaipel heigei nomo gau tigina rute?” ");
INSERT INTO eri_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ono wainga, nere Farisi no memesi beele benou letuwane, “Ne nagenga nomo disaipel. Ere nu Moses nomo disaipel. ");
INSERT INTO eri_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Itou no beele Moses tuwai waha, ere amina iseye. Ariya, fai beha alanga heigaha waha, ere ada isiya.” ");
INSERT INTO eri_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ariya, nere onou lewanenga, fai no amina ago magana fosokowai waha, no ege gidu lenigai, “Tere beele hogo ferete tigini leya. Fai waha ono wanga ji agefe igei naha waha tere leya, tere no boya ada isiya, no alanga heigaha. ");
INSERT INTO eri_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ere alai, Itou no fai une tafagou waha, nebere beele ada isi-isina. Ariya, fai no Itou unyi isou bona, no Itou nomo gauwou oojona waha, Itou no nomo beele isi isina. ");
INSERT INTO eri_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aminaha mai elebe, fai ete ago magana fosokowou onounga anya bisi tuwainga, iinga fai ete ago isebu fuwaihawou aasa ete inyei uwa. ");
INSERT INTO eri_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Itou no fai waha huuru tuwei uwa wage, no dada ete-te ada onowage.” ");
INSERT INTO eri_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Farisi nere beele waha isidu bode, nere beele ege gidu benou letuwane, “Adadu? Saini ne anyane bisi hinai la mai elebe, une nomo fanyimu waha tigini ne langa inyina. Waha ne ere isisiwou higau ganga ononi yo?” Onodu bode so tuwane. ");
INSERT INTO eri_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus no, nere fai waha so tuwanewou isidu bona, no goi kuru tudu bona toroba tuwai. Onodu bona isoki tuwai, “Ne Fai Nomo Idau boni huwanyate ngalengana yo?” ");
INSERT INTO eri_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ono wainga, fai waha no letuwai, “Fai anyakaro, Fai Nomo Idau waha faiwei? Ne lehiyahenga, ji no boni huwanyafe ngalenga wona bona.” ");
INSERT INTO eri_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ono wainga, Yesus no fai waha letuwai, “Ne no amina ureneha. Fai no waha, elebe ne ngare beele haiyare.” ");
INSERT INTO eri_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ono wainga, fai wa letuwai, “Anyakaro, ji huwanyafe ngalengana.” Onodu bona, no afo tuburu kutudu bona, Yesus unyi isouwai. ");
INSERT INTO eri_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Onodu Yesus no lewai, “Ji oula beha langa nere fai-aita bagu nebere onowou haawe nagei nomo meene. Onou waha bona, nere fai agenege magana fosokowou waha, nere igei wodbode. Nere fai agenege igeide waha, nere agenege magana fosokowou heigode bode.” ");
INSERT INTO eri_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ono wainga, Farisi ila nere Yesus hinomu langa otowane waha, beele waha isidu bode, no isoki tuwane, “Ne ere fere agege fosokowou higau ganga yo?” ");
INSERT INTO eri_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ono wanenga, Yesus no lenigai, “Tere tebere agetege magana fosokowou wonga, tere une langa nyabuliwou uwau. Ariya tere leya, ‘Ere agege igei-igeiya.’ Onou waha bona, tere tebere une gai inyina.” ");
INSERT INTO eri_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus no ege onou lewai, “Ji ngalenga tigini letigini, fai no sipsip nebere orei waha nomo arasai tigini langa ada goina, no fere langa orei digedu huwanya goina, fai onoha waha no yebu fai, onodu no ila nebere dada nganege elegegou fai. ");
INSERT INTO eri_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ariya, fai no orei arasai tigini langa huwanya goina waha, no sipsip oofa nigigou fai. ");
INSERT INTO eri_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Orei arasai oofagou fai, no fai waha orei arasai helufa fu-funa. Ono ganga, sipsip nere no bolou isi-iside. Onodu no nomo sipsip etenga‑etenga unyinege tedu bona, hanigedu malala la mai‑maina. ");
INSERT INTO eri_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","No nomo sipsip oruwa hanigedu malala la maidu bona, no nogo amugedu golodu goi-goina. Ono ganga, sipsip nomo bolou isi-iside, onou waha bode, nere no oojo tu‑tude. ");
INSERT INTO eri_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nere fai fere waha ada oojo tu-tude. Fai fere waha yaure nigi bona wonga, sipsip, no awa tudu hara wodbode, taate bode, nere fai ila bolonege ada isi-iside.” ");
INSERT INTO eri_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus no muuji beele beha lenigai, ariya no beele lenigai beha nomo hugu nere foo nigei uwa. ");
INSERT INTO eri_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ariya, Yesus no nere ege lenigai, “Ji tere ngalenga letigini, ji yage ji sipsip nebere arasai. ");
INSERT INTO eri_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nere fai oruwa, ji amuge hidu mayane wa, nere yebu fai onodu nere dada nganege elegou fai. Ono wane waha, sipsip nere waha nebere belenege oojo wegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ji yage ji arasai. Fai ete no ji langa maidu bona, no orei huwanya la goyona wa, Itou no fai waha ege gidu hawonbona. Ono wonga, no huwanya goi, malala mai bona, da tedu nyonbona. ");
INSERT INTO eri_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Yebu fai no dada ete bona ada mai-maina. No sipsip yebudu, dunege kotedu inyabamu nigei nomo bona mai-maina. Ariya ji meene wa, nere agenege auma tei nomo boni meene. Onodu agenege auma waha nere la bolowon bona. ");
INSERT INTO eri_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ji yage ji sipsip nebere oofa nigou fai hilobainga. Sipsip oofa nigou fai hilobainga no, nere sipsip hoyo nigei nomo bona, no nogo ago amuma yafou awa-awana. ");
INSERT INTO eri_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Fai no moni haruwenga tena waha, no sipsip oofa nigou fai tigini uwa, onodu no sipsip nebere amenege fere uwa, saini no gauna kui mayonga uredu bona, no sipsip awa nigidu faga wonbona. Ono gonga gauna kui no sipsip masi nigi bona so nigonga firigagadu hara wodbode. ");
INSERT INTO eri_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Fai waha no onou ono wonbona, taate bona, no moni bonanga haruwena. No sipsip bona tigini ninau isei uwa. ");
INSERT INTO eri_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ji yage ji sipsip nebere oofa nigou fai hilobainga. Ji yame sipsip ji isi nigini, ono genenga, yame sipsip nere ji bode isi hide, ");
INSERT INTO eri_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","wa Jijei no ji isi higanga, ji yame Jijei isi tuni dorofe. Ji nere sipsip waha hoyo nigei nomo boni agefe auma awon boni. ");
INSERT INTO eri_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ariya, ji yame sipsip ila, orei beha nomo uwa waha fere golode. Ji sipsip waha fere hanigedu mayon boni. Ono wehenga nere yame belefe isodbode. Ono wonga, nere sipsip ago etenga heigonga nebere oofa nigou fai fere etenga yafonbona. ");
INSERT INTO eri_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jijei no ji gaude hina, taate bona, ji yame agefe auma yafou waha awadu boni ji ege gidu tonboni. ");
INSERT INTO eri_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Fai ete no yame agefe auma yafou waha usumuwei nomo edo uwa. Ji yage yame gauwou langa, yame agefe auma yafou waha awon boni. Ji yage yame agefe auma yafou awei nomo danga edo langa, onodu ege gidu tei nomo ji danga edo langa. ");
INSERT INTO eri_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ono wainga, nere Juda beele waha isidu bode, nere ege foure nga wane. ");
INSERT INTO eri_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nere fai baingaro lewane, “Hauri inyaba no langa inyi ganga, no dabu taina. Taate boya, tere nomo beele isei nomo agetege kuli tafaya?” ");
INSERT INTO eri_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ono ganenga, nere ila lewane, “Beele beha waha, fai hauri inyaba bagu nomo beele uwa. Onou wa, hauri inyaba no nere fai agenege fosokowou waha edo langa hiloumu nagage yo?” ");
INSERT INTO eri_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ariya saini waha langa, bori nomo fati anyakaro Jerusalem langa heigai. Wa nere amina tempel waha, Itou nogo nomo mata heigei nomo hangada wane waha, ninanege isei nomo fati. Fati waha no uliya saini langa heige-heigena. ");
INSERT INTO eri_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ariya Yesus no tempel nomo orei huwanya langa, Solomon nomo faranda langa golowai. ");
INSERT INTO eri_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ono gainga, nere Juda maidu bode, no kolili tudu oto bode isoki tuwane, “Taate saini tigini ne faiwei waha foomu higau ganga? Ne fai wahanga Itou no nomo fai-aita ege gidu hanigei nomo hangada hinai wonga, ne tigini onou malala foomudu lehigau.” ");
INSERT INTO eri_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ono wanenga, Yesus no nere ege gidu benou lenigai, “Ji amina letigene, tere waha boya huwanyatege ngalengawei uwa. Haruwe oruwa, ji yame Jijei unyi langa teteni waha langa, ji faiwei waha abitimu tigina. ");
INSERT INTO eri_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ariya tere yame sipsip waha nebereha uwa. Onou waha boya, tere huwanyatege ada ngalengana. ");
INSERT INTO eri_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ji yame sipsip nere ji belefe isi-iside, ji nere boni isini, ono genenga, nere ji oojo hi-hide. ");
INSERT INTO eri_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ariya, ji nere agenege auma hilobainga gai-gai yafou waha nigini, onou bona, nere ada yaae wode. Gai uwanga uwa. Fai ete no ji owofe langa ngafe elegei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yame Jijei no nere ji hiyai. No amugou tigini onodu no dada oruwa feiya nigou. Onou waha bona, fai ete no yame Jijei owoha ngau elegei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jijei no ji ngare ere etenga.” ");
INSERT INTO eri_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Juda nere beele waha isidu bode, nere ege megebu elegedu no warogunga umei nomo ono wane. ");
INSERT INTO eri_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ono wanenga, Yesus no benou lenigai, “Ji yame Jijei nomo haruwe hilobainga baingaro abitimu tigene. Ariya tere haruwe adeha waha boya, ninatege isidu, ji megebu aya hayagu ganga onoya?” ");
INSERT INTO eri_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ono wainga, Juda nere beele gidu benou letuwane, “Ere haruwe hilobainga ete boya ninage isidu, ne megebu aya hanei nomo onowei uwa. Ere ne Itou nomo haumu tauganga ononaha, hugu waha boya ne megebu aya hanei nomo onoyaha. Ne fai ewe, ariya ne leni, ne nage ne Itou.” ");
INSERT INTO eri_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ono wanenga, Yesus no nebere beele waha gidu ege benou lenigai, “Tere tebere nuuni beele la, Itou nomo beele ete benou inyina, ‘Ji benou leni, “Tere itou.” ’ ");
INSERT INTO eri_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Amina Itou no beele waha malalamudu lenigidu, no fai nere bona lewai, nere Itou. Onodu beele Itou nomo buk langa inyina waha no ada ubulu-ubuluna. ");
INSERT INTO eri_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ariya Jijei no nogo we ji hangada hidu bona, oula belanga huuru hiyainga meene. Onou bona saini ji lewoni, ‘Ji Itou Idau,’ ariya tere taate bona lewagu ganga, ‘Ne Itou nomo haumu tau ganga ononi?’ ");
INSERT INTO eri_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Onodu ji yame Jijei nomo haruwe onowei uwa wonga, tere yame beele bonade huwanyatege adai ngalengawou. ");
INSERT INTO eri_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ariya, ji no nomo haruwe ono gehenga, tere yame beele bonade huwanyatege ngalengawei nomo awa bonade wonga, tere haruwe ji ononi beha langa huwanyatege ngalengawou. Onodu tere isou tedu bonade, ninatege benou isi dewagu ganga. Jijei no ji langa yafa ganga, ji Jijei langa yafani.” ");
INSERT INTO eri_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nere ege no yaasu tuwode ono wane wa, no feiya nigidu goyai. ");
INSERT INTO eri_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesus no ege gidu goi Jordan yaage fadu bona, haumu amina Jon no fai-aita bagu yaage bisemu nigai walanga heigedu, haumu waha langa yafai. ");
INSERT INTO eri_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ono gainga, nere fai-aita baingaro no bagu mayane. Onodu lewane, “Ngalenga, Jon no dodokawou ete-te nomo beele dangamuwou tafei uwa, ariya beele oruwa Jon no fai beha bona lewai waha, no tigini.” ");
INSERT INTO eri_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Onodu saini Yesus no haumu waha langa yafa gainga nere fai baingaro no bode huwanyanege ngalenga wai. ");
INSERT INTO eri_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Fai ete taura bagu, no Betani matane langa yafagai, nomo unyi Lasarus. Betani wa, Maria bemu Marta ngare neire matane. ");
INSERT INTO eri_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria no wahanga, amina Anyakaro afo sanda bisemu fuwai, onodu nomo tawa gala langa, karamu fuwaiha. Ariya, Lasarus fai waha no taura bagu, no Maria, Marta ngare ogonere. ");
INSERT INTO eri_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ono wainga, nere bemu ngare, Yesus beele benou huuru fuware, “Anyakaro, fai ne gaude tuni waha, no taura bagu.” ");
INSERT INTO eri_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ono warenga, Yesus no beele waha isidu bona, no benou lewai, “Taura waha fai umei nomo uwa. No fai-aita bagu ono nigonga nere Itou nomo danga uredu bode, Itou unyi anyakaro tuwodbode. Ono wogunga, jala wahanga la Itou Idau fere no unyi anyakaro tonbona.” ");
INSERT INTO eri_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus no Marta bemu Maria ngare, neire ogonere Lasarus ngate gaude nigai. ");
INSERT INTO eri_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ariya, saini Lasarus taura bagu waha beele isidu bona, no ege fati nga haumu no yafai waanga yafai. ");
INSERT INTO eri_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Onodu iinga gainga, no nomo disaipel lenigai, “Ere ege gidu Judia distrik la goyei nomo.” ");
INSERT INTO eri_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ono wainga, nomo disaipel nere letuwane, “Isisi higigou fai, iingabe nere Juda megebu ayarudu, narogunga umei nomo bode ono wane waha, ne ege walanga goyau ganga ononi yo?” ");
INSERT INTO eri_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ono wanenga, Yesus no nebere beele waha ege gidu benou lenigai, “Hoonga etenga, no nomo awa 12 uwau yo? Fai no hoonga golona wa, no ada metaumena, taate bona, no oula beha nomo lala ure-urena. ");
INSERT INTO eri_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ariya, fai no ooru la golona wa, no metaume-taumena, taate bona, no igeiwei nomo lala uwau.” ");
INSERT INTO eri_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus no onou lenigidu bona, iinga ege lenigai, “Ere ebere ilibage Lasarus no agore inyina. Ariya ji goidu boni, no aimu tuwon boni.” ");
INSERT INTO eri_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ono wainga, nomo disaipel nere beele waha isidu bode, benou letuwane, “Anyakaro, no agore inyona wa, no nomo taura usu wonga, no ege hilou wonbona.” ");
INSERT INTO eri_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ariya, Yesus no Lasarus umai bona lewai waha, nomo disaipel nere foo nigei uwa. Ono wainga, nere benou isane, no ewe agore inyina waha bona lena iwane. ");
INSERT INTO eri_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ono wanenga, iinga la no foomudu lenigai, “Lasarus no umaha. ");
INSERT INTO eri_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ariya ji tere boni ninafe isidu boni, saini waha langa ji no ngare yafei uwa boni edegani. Taate bona, waha no tere ono tigonga huwanyatege ngalenga wonbona. Ariya, ere elebe no bagu goyo boya.” ");
INSERT INTO eri_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ono wainga Tomas, no nomo unyi ete Didimus, no disaipel ilibumu gane lenigai, “Hiragu, ere oruwa goidu no ngate umei nomo.” ");
INSERT INTO eri_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ariya, Yesus no nomo disaipel bagu Betani matane heigei nomo jugumudu, no beele benou isai, Lasarus no matmat langa fati aise inyina. ");
INSERT INTO eri_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ariya, Betani no Jerusalem jugunga la, 3 kilo mita onouga, ");
INSERT INTO eri_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","waha bona, nere Juda fai-aita bagu baingaro, Marta, Maria ngare neire ogonere umai waha bode, huwanyanere hilou inyei nomo bona mayanenga gaara yafane. ");
INSERT INTO eri_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ono ganenga, Marta no Yesus golowaha mainawou beele isidu bona, no Maria mata langa awa tuwai yafa gainga, no golodu goi, Yesus jala gama toroba tuwai. ");
INSERT INTO eri_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Onodu bona Marta no Yesus letuwai, “Anyakaro, ne belanga yafou wage wa, yame ogofe no ada umage. ");
INSERT INTO eri_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Onou wa, elebe fere ji isini, ne Itou dada ete bona hauya tuwau wa, no hinonbona.” ");
INSERT INTO eri_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ono wainga, Yesus no Marta letuwai, “Name ogone, no ege jayonbona.” ");
INSERT INTO eri_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ono wainga, Marta no Yesus letuwai, “Ji isini, fati usuwou langa, no ege jayonbona, saini waha langa, nere fai-aita oruwa ege jayodbode.” ");
INSERT INTO eri_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ono wainga, Yesus no Marta letuwai, “Ege jayou wa ji wenga. Agenege auma wa fere, ji wenga. Fai no ji bona huwanya ngalengana waha, no edo umona, ariya no gai ago auma yafonbona. ");
INSERT INTO eri_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nere fai-aita bagu agenege auma yafa bode, nere ji bode huwanyanege ngalengade waha, nere ada umeru wode. Nere agenege auma gai-gai yafodbode. Ne waha boni huwanyate ngalengana yo?” ");
INSERT INTO eri_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ono wainga, Marta no Yesus letuwai, “Yo, Anyakaro. Ji huwanyafe ngalengana. Ne Itou Idau. Ne fai Itou no huuru tuwonga oula langa medu, nomo fai-aita bagu ege gidu hanigei nomo lewai waha.” ");
INSERT INTO eri_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ariya, Marta no Yesus onou letudu bona, no goi nomo bemu Maria yaure tuwai. Onodu bona, no Maria foinga agokuli la yayaji tu bona letuwai, “Isisi higigou fai, no mayaha yafa bona, ne yaure hinina.” ");
INSERT INTO eri_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ono wainga, Maria no beele waha isidu bona, no fasadu onou goi Yesus urei nomo bona jayai. ");
INSERT INTO eri_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ariya, Yesus no mai matane heigei uwa. No haumu Marta no amugedu goi toroba tuwai waanga gai yafai. ");
INSERT INTO eri_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ono gainga, nere Juda Maria ngate mata langa aau narige gainga yafane waha, nere Maria fasadu jaidu bona, malala heige gainga urane. Ono wainga, nere benou ninagege isane, no matmat la meron bona goina idu, nere no taga tudu bode goyane. ");
INSERT INTO eri_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Onodu Maria no goi haumu Yesus yafai waha langa heigedu bona, Yesus urai. Onodu bona, no Yesus afo hugu langa afo tuburu kutudu yafa bona, benou letuwai, “Anyakaro, ne belanga yafage wa, yame ogofe, no ada umage.” ");
INSERT INTO eri_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ariya, Yesus no Maria mere gainga, Juda no taga tudu mayane waha fere mere ganenga nerigai. Onodu bona, no aau danga bagu warainga, merona onowai. ");
INSERT INTO eri_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Onodu bona, no isoki nigai, “Tere no alanga u-u tani tuyaha?” Ono wainga, nere letuwane, “Anyakaro, ne maidu bonahe urau.” ");
INSERT INTO eri_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ono wanenga, Yesus no merai. ");
INSERT INTO eri_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ono wainga, Juda no merainga uredu bode, lewane, “Uragu. No fai beha gaude tugai.” ");
INSERT INTO eri_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ono wanenga, nere ila lewane, “Fai beha no fai agenege magana fosokowou waha hilomu nagaiha. Onowai wa, no taate bona, Lasarus adai umei nomo bona hoyo tuwei uwa?” ");
INSERT INTO eri_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ariya, Yesus no huwanya ou dewainga, no matmat langa mani heigai. Matmat waha no megebu u-u ete nere muju langa konu wane. Onodu bode u-u hao waha, nere megebu anyakaro ete la kutau wane. ");
INSERT INTO eri_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ono wane wa, Yesus no lenigai, “Megebu waha isebu wagu.” Ono wainga, Marta fai umaiha waha nomo ogobumu, no Yesus letuwai, “Anyakaro no umanga u-u taniya inyi ganga, elebe fati aise goina. Onou waha bona, no gogala agiya inyaba heigonbona.” ");
INSERT INTO eri_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ono wainga, Yesus no Marta letuwai, “Ji amina lehinene, ne huwanyate ngalenga wonga wa, ne Itou nomo danga anyakaro urau ganga.” ");
INSERT INTO eri_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ono wainga, nere megebu u-u sesemu wane waha isebu wane. Ono wanenga, Yesus no ouwe la igei bona, lewai, “Jijei, ji ne hilobainga hinini, taate boni, ne yame hauyawou amina isinaha. ");
INSERT INTO eri_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ji isini, saini oruwa yame hauyawou ne isi-isini. Ariya ji nere fai-aita bagu otode beha boni isidu beele beha lehinini. Ono wahenga, nere edo isode, ne ji huuru hiyenenga meene.” ");
INSERT INTO eri_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","No onou leborodu bona, inyangaro yaurai, “Lasarus, ne malala heigedu mayau!” ");
INSERT INTO eri_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ono wainga, Lasarus no ege jaidu bona, malala la heigedu mayai. Nomo afo owo bagu, hogo bagu, nere ogola la ngara tuwane waha oruwa mayai. Ono wainga, Yesus no lenigai, “Ogola futu fudu awa tuwadenga golowona.” ");
INSERT INTO eri_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nere Judaha fai baingaro, nere Maria ngate gaara aau narige gainga yafane waha nere Yesus no dada waha ono wainga uredu bode, nere no bode huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ariya nebereha ila Farisi bagu goidu bode, Yesus no dada onowai waha bode lenigane. ");
INSERT INTO eri_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ono wanenga, nere Pris aroro bagu, nere Farisi bagu, kaunsel yaure niganenga mai komo wanenga lenigane, “Fai waha dodokawou baingaro tafana waha boya, ere adadu ono woboya?” ");
INSERT INTO eri_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ere no awa tuwedenga, no fanyimu onounga ono wona wa, nere fai-aita baingaro, no bode huwanyanege ngalenga wodbode. Ono gogunga, Rom maidu bode, tempel inyabamu hagi bode, ebere gane fere inyabamu nigodbode. ");
INSERT INTO eri_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ono wa, haga orei beha langa, nere gamanege la Kaiafas no Pris mora bagu yafai, no waha lenigai, “Tere tigini ninatege uwau. ");
INSERT INTO eri_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tere onowou ete edola hoyo tigei nomo waha tere isegu uwa. Fai etenga, no nere fai-aita bagu hoyo nigei nomo bona umona wa, hilobainga. Gamaji ere ebere gane oruwa yooso woguga.” ");
INSERT INTO eri_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ariya, Kaiafas no beele waha nogo nomo ninau langa lewei uwa. Saini haga orei waha langa, no Pris mora bagu yafai, waha bona, Yesus no Juda hoyo nigidu umon bona, waha bona no profet beele lewai. ");
INSERT INTO eri_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ariya, Yesus no umona wa, nere Juda nagenga hoyo nigei nomo uwa. No Itou nomo magana gane oruwa fere-fere yafade waha, elegedu komomu nigonga, nere etenga heigei nomo bona umonbona. ");
INSERT INTO eri_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Onodu fati wahanga la, fai aroro nere no dukote wogunga umei nomo jala kuru bode beele ngadowou hugu warane. ");
INSERT INTO eri_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Onou waha bona, Yesus no ege nere Juda gamanege langa malala golowei uwa. No matane waha awadu bona, goi haumu fai uwau jugu la, taon ete unyi Efraim ide, walanga no nomo disaipel gane bagu arotenga yafane. ");
INSERT INTO eri_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Fati Anyakaro Itou No Israel Awa Nigainga Hilobainga Yafane Waha Ninanege Isei Nomo Fati waha, mai juguwai. Ono wainga, nere fai-aita bagu, matane fere-fereha, nebere une uludu Itou ago langa jijiga uwau heigei nomo bode, Jerusalem goyane. ");
INSERT INTO eri_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Onodu nere Yesus kuru tubode, tempel orei huwanya langa oto bode, nere nage-nage leguruwane, “Tere adadu isiya? No bori nomo fati anyakaro beha mai urona yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nere fai aroro Farisi bagu, nere fai-aita bagu beele amina benou lenigane. Fai ete no Yesus alanga yafana waha isi bona wonga, no nere isimu nigonga, nere edo no dagou mata langa tafa tuwodbode. ");
INSERT INTO eri_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ariya, bori nomo fati anyakaro waha heigei nomo fati 6 inyai. Saini waha langa, Yesus no Betani goyai. Betani wa Lasarus nomo matane. Fai no waha amina Yesus matmat langaha ege jaimu tuwainga jayai. ");
INSERT INTO eri_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ono wainga, nere Yesus edegamu tuwei nomo matane walanga da haiya fuwane. Marta no da uuwai, ono gainga Lasarus no nere fai Yesus ngate yafa bode da nyane waha bagu gaara yafane. ");
INSERT INTO eri_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ono ganenga, Maria no sanda hilobainga ete haf kilo nomo ejiyawou no moni gai anyakaro waha tetaimudu Yesus afo langa kiyo fuwai, onodu no nogo nomo tawa gala langa karamu fuwai. Sanda waha nomo agiya hilobainga waha, mata huwanya oruwa edomuwai. ");
INSERT INTO eri_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ono wainga, Yesus nomo disaipel ete, nomo unyi Judas Iskariot, no waha iinga Yesus honggoro fai owonege langa tafa tuwai, no waha lewai, ");
INSERT INTO eri_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ere sanda waha ada tedu huuru yanga, nere fai ejiya wagenga, ere moni silwa 300 tedu nere fai dadanege uwau waha nigedege?” ");
INSERT INTO eri_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas no fai dadanege uwau waha bona aau warainga lewei uwa. No yebu fai. No Yesus nomo disaipel bagu nebere moni bogisi oofawou haruwe tegai. Onodu nere moni tafagane, yebu elegegai. ");
INSERT INTO eri_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ariya, Yesus no Judas nomo beele waha isidu bona, no benou lenigai, “Aita beha awa tuwagu. No sanda beha edo yaasu gonga goi saini ji umehenga, nere ji u-u tani hiyode. ");
INSERT INTO eri_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nere fai dadanege uwau waha, nere tere bagu gai-gai yafodbode. Ji nu, tere bagu gai ada yafoni.” ");
INSERT INTO eri_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nere Juda baingaro, Yesus no Betani matane langa yafana waha nere isane, onodu nere no bagu mayane. Nere Yesus nonga urei nomo mayegu uwa. Yesus no amina Lasarus matmat langa ege jaumu tuwai waha, nere isane. Waha bode nere Lasarus fere urei nomo bode mayane. ");
INSERT INTO eri_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Onou waha bona, nere Pris aroro fere Lasarus dukote wogunga, umei nomo bode lewane, ");
INSERT INTO eri_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","taate bona, nere Juda baingaro Yesus dada Lasarus langa onowai waha bode ninanege isi bode, nere Pris aroro awa nigidu bode, nere Yesus bode huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Fai-aita toomaro nere bori nomo fati anyakaro waha, urei nomo bode Jerusalem langa maidu yafane. Ariya Yesus no Lasarus nomo mata langa da nyai waha, inyi hamba nere fai-aita bagu isane wa, Yesus Jerusalem langa heigona jugunawou. ");
INSERT INTO eri_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Onodu bode, nere matora gala elegedu bode, mini jala la toroba tuwane. Onodu benou yaurane, “Itou bonade edega wagu. Fai beha no Anyakaro unyi langa maina waha, Itou no edo figini tuwonbona. No Israel ebere king!” ");
INSERT INTO eri_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus no donki ete tedu bona digedu jaula langa yafai. Wa Itou nomo buk langa beele inyina dorofe: ");
INSERT INTO eri_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tere Saion taonha fai-aita bagu, tere adai umugagu. Uragu. Tebere king, no amina maina. No donki giila ete langa yafaha maina.” ");
INSERT INTO eri_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ngasunga, nomo disaipel nere beele waha nomo hugu nere isegu uwa. Ono wanenga iinga Itou no Yesus unyi anyakaro tuwainga, nere beele Itou nomo buk langa inyina waha isane, onodu no Yesus bona tigini lenawou isane. Onodu bode, nere ege dada no la ono wane waha bode ninanege isane. ");
INSERT INTO eri_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Saini Lasarus no umainga matmat langa u-u tanane inyi gainga, fai-aita baingaro nere Yesus bagu yafa ganenga, no Lasarus matmat langa yaure tudu bona ege jaumu tuwai waha urane. Onou waha bode, nere fai-aita bagu Yesus no dada onowai waha bode beele malalamu wane. ");
INSERT INTO eri_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ariya nere fai-aita bagu, no dodoka tafai waha bode beele isidu, nere mini jala gama toroba tuwane. ");
INSERT INTO eri_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Onodu Farisi nere uredu nere nage gamanege langa leguru wane, “Uragu. Dada waha ere onowei nomo onoya wa, elebe ada heigona. Nere fai-aita bagu oruwanga, no oojo tude.” ");
INSERT INTO eri_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bori urei nomo fati anyakaro waha langa, nere fai-aita bagu Itou unyi isouwei nomo bode, Jerusalem langa mayane waha nere gamanege langa, Grik ila fere gaara mayane. ");
INSERT INTO eri_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ariya, nere Grik fai waha Filip bagu mayane, no Betsaida taonha, Galili langa. Nere maidu bode, no benou letuwane, “Fai anyakaro, ere Yesus urei nomo boya gau higina.” ");
INSERT INTO eri_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ono wanenga, Filip no goi Andrew letuwai. Ono wainga, Andrew no Filip ngare goidu bodere, Yesus letuware. ");
INSERT INTO eri_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ono warenga, Yesus no beele ege gidu benou lenirai, “Fai Nomo Idau no unyi anyakaro tei nomo saini, elebe amina mai heigaha. ");
INSERT INTO eri_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ji tere ngalenga letigini, wit fatu no oula la ada mebodudu umona wa, no nogonga yafonbona. Ariya no ume bona wonga, no fududu bona hilou baingaro heigonbona. ");
INSERT INTO eri_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Fai ete no nogo nomo ago auma yafou waha bona gaude tuna waha, no nomo ago auma yafou waha yaae wonbona. Ariya fai no oula beha nomo ago auma yafou waha moge tuna wa, no nomo ago auma yafou waha danga bagu yaasu gonga goi saini oruwa langa edo wonbona. ");
INSERT INTO eri_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Fai ete ji yame haruwe te bona wonga, no ji oojo hiyonbona. Ono wonga, haumu ji yafani waha langa, ji yame haruwe fai fere ji ngare yafoboyare. Fai no ji yame haruwe te bona wonga, yame Jijei no fai waha unyi anyakaro tuwonbona.” ");
INSERT INTO eri_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesus no ege onou lewai, “Elebe ji huwanyafe ou ganga, ninafe baingaro isini. Onou waha bona, ji adadu lewoni? Ji benou lewoni rute, ‘Jijei ne saini inyaba beha adai awa tuwahenga ji la heigona?’ Uwa, ji onou adai lewoni. Ou nomo saini beha edo ji langa heigona. Hugu waha boninga ji meene. ");
INSERT INTO eri_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jijei, ne edo name unyite ono wahenga anyakaro heigona.” Yesus no onou leboro wainga, beele ete ha laluwa langa benou mai, “Ji unyife amina ononanga anyakaro waha, ji ege onou onowon boni.” ");
INSERT INTO eri_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ono gainga, nere fai-aita toomaro jugu langa otowane waha, nere beele waha isidu bode lewane, “Amili ayana wane.” Ono wanenga, nere ila lewane, “Ensel ete beele letuna iwane.” ");
INSERT INTO eri_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ono wanenga, Yesus no beele ege gidu benou lenigai, “Beele tere elebe isiyaha beha, no ji hoyo hiyei nomo lewei uwa. No tere hoyo tigei nomo lewaha. ");
INSERT INTO eri_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ariya, elebe Itou no oula beha nomo fai-aita bagu nebere onowou haawe nagonbona. Ono bona, fai mora bagu oula beha oofa na waha so tuwonbona. ");
INSERT INTO eri_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Elebe ji oula langa yafani, iinga gonga, nere ji isou hiyogunga, saini waha langa ji nere fai-aita bagu oruwanga kuse nigehenga, ji bagu mayodbode.” ");
INSERT INTO eri_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus no onou lewai wa, no nogo fanyimu adadu bona umonbona waha malalamudu lewai. ");
INSERT INTO eri_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ono wainga, nere fai-aita bagu, nomo beele ege gidu benou letuwane, “Ere Itou nomo nuuni beele langa, ere beele benou iseye, saini Itou no nomo fai-aita bagu ege gidu hanigei nomo fai hangada tuwai waha heigona wa, no gai-gai yafonbona. Ariya, adadu bona ne leni, ‘Nere Fai Nomo Idau isou tuwodbode?’ Fai Nomo Idau waha faiwei tigini?” ");
INSERT INTO eri_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ono wanenga, Yesus no lenigai, “Saini tutunga la, lala tere bagu inyonbona. Elebe tere lala bagu, onou waha bona, tere lala la golo wagu, gamaji agugu kutau tigoga. Fai no agugu langa golona waha, no alanga goina waha, no ada isina. ");
INSERT INTO eri_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Elebe lala no tere bagu gai inyina, onou waha bona, tere lala waha bonade huwanyatege ngalenga wonga, tere lala nomo magana heigagu ganga.” Ariya, Yesus no fai-aita bagu beele lenigi borodu bona, no heigedu goi huwari nigai. ");
INSERT INTO eri_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","No dodokawou naani dorofe baingaro tafainga nere urane waha, nere no bode huwanyanege ngalengawei uwa. ");
INSERT INTO eri_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Onou waha bona, profet Aisaia nomo beele waha tigini heigai. Aisaia no benou lewai, “Anyakaro, faiwei no ebere beele bona huwanya ngalengana? Onodu faiwei no, Anyakaro haruwe danga bagu elebe onona benou waha ono gainga urai?” ");
INSERT INTO eri_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Onou bona, nere Yesus bode huwanyanege ngalengawei nomo edo uwa. Waha nomo hugu wa, Aisaia no beele fere langa yeregai, no benou lewai, ");
INSERT INTO eri_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Itou no ono wainga nere agenege igeiwei nomo edo uwa, no ninanege ono wainga fosokowai, gamaji nebere agenege dada ete uredu, beele nomo hugu bona foo nigonga huwanyanege ubuludu ji bagu gidu mayogunga jigemu nigoga.” ");
INSERT INTO eri_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia no Yesus nomo unyi anyakaro, danga bagu waha uredu bona no Yesus bonanga beele waha lewai. ");
INSERT INTO eri_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ngalenga, nere mora bagu fere baingaro Yesus bode huwanyanege ngalenga wane. Ariya, nere Farisi umuge nigi bode, nere nebere huwanyanege ngalengawou waha malalamudu lewegu uwa. Nere umugane, taate bona, gamaji nere Juda ila bagu bori uroguga bode, Farisi nere karu nigode bode. ");
INSERT INTO eri_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nere Itou unyinege isouwei nomo gau nigei uwa. Nere fai unyinege isouwei nomo gau anyakaro nigi-nigina. ");
INSERT INTO eri_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus no beele danga bagu benou lewai, “Fai no ji bona huwanya ngalengana waha, no ji bonanga huwanya ngalengawei uwa. No Jijei, no ji huuru hiyainga meene waha bona huwanya ngalengana. ");
INSERT INTO eri_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Fai no ji yeriyena waha, no Jijei, no ji huuru hiyainga meene waha urena. ");
INSERT INTO eri_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nere fai oruwa ji bode huwanyanege ngalengade waha, nere agugu langa adai yafei nomo boni, ji lala dorofe ha esene belanga meene. ");
INSERT INTO eri_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ariya, fai ete no ji yame beele isidu bona, no ada oojo wona waha, ji haawe nigigou fai dorofe, ji no ada haawe tuwoni. Ji meene wa, ji nere fai ha eseneha nebere haawe nigigou fai dorofe yafei nomo boni meei uwa. Ji nere ege gidu hanigei nomo boni meene. ");
INSERT INTO eri_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ariya, fai no ji moge hibona, no yame beele tei uwa waha, no haawe tuwei nomo fai ete bagu. Saini fati beha nomo usuwou langa, beele ji lewene waha nogo we, no fai waha haawe tuwonbona. ");
INSERT INTO eri_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ji yage yame ninafe langa beele ete lewei uwa. Jijei no ji huuru hiyainga meene waha, no nogo we ji beele oruwanga malalamudu lewei nomo lehiyai waha leni. ");
INSERT INTO eri_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ji isini, yame Jijei nomo beele waha, no agenege auma gai-gai hilobainga yfaou waha heigemu-heigemuna. Onou bona, beele oruwa ji leni waha, Jijei no lehiyai, onounga leleni.” ");
INSERT INTO eri_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ariya, Fati Itou No Israel Awa Nigainga Hilobainga Yafane waha isi bode, kaafa nyei nomo fati waha iinga heigei uwa inyi gainga, Yesus no ha esene beha awadu, no umamu bagu manei nomo saini amina heigaha wou waha no isai. Onou bona, nere nomo fai-aita bagu ha esene belanga yafade waha bona, no gaude nigai. No onou gau niginga bona, goi saini no umaiha. ");
INSERT INTO eri_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Esuwa la tigini, Yesus no nomo disaipel gane bagu, nere da nyi bode yafagane, satan no Saimon Iskariot nomo idau Judas isou tuwai, no Yesus nere honggoro fai owonege langa tafa tuwei nomo bona. ");
INSERT INTO eri_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ono wainga, Yesus no isai wa, umamu no dada oruwanga no bura tafai. Onou bona no isai wa, Itou no huuru tuwainga mai bona, no ege gidu Itou bagu manonbona. ");
INSERT INTO eri_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Waha bona, Yesus no da awadu bona jayai. Onodu bona, no nomo kolos ufaro uuludu bona, no taola ete tedu bona ungu la dagai. ");
INSERT INTO eri_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Onodu bona, no yaage uuwainga haaya ete langa minainga, no nomo disaipel afenege huge nagi bona, no taola nomo ungu la dagai waha langa afenege fidu, karamu nagingawai. ");
INSERT INTO eri_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","No onou ono bona, Saimon Pita langa mayainga, Saimon Pita no isoki tuwai, “Anyakaro ne yame afefe huge hayau ganga ononi yo?” tuwai. ");
INSERT INTO eri_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ono wainga, Yesus no beele ege gidu benou letuwai, “Dada ji ononi beha, ne elebe foo hinei uwa. Iinga gonga ne foo hinon bona.” ");
INSERT INTO eri_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ono wainga Pita letuwai, “Ne yame afefe adainga adai huge hayau.” Ono wainga, Yesus no ege gidu letuwai, “Ji ne yaage ada bisemu hini boni wonga, ne ji ngare gaara yafei nomo edo uwa.” ");
INSERT INTO eri_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ono wainga, Saimon Pita no Yesus letuwai, “Anyakaro, onou wonga, ne yame afefenga adai huge hayau. Ne yame owofe, morafe bagu fere huge hayau.” ");
INSERT INTO eri_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ono wainga, Yesus no letuwai, “Fai no yaage amina bisaha waha, no ege-ege ada bisona. No afonga hugedu bona, eege heigon bona. Ariya tere amina eege heigeyaha. Onou wa, ji tere oruwa boni lewei uwa.” ");
INSERT INTO eri_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus no fai waha, no nere honggoro fai owonege langa tafa tuwon bona waha no amina isai. Onou waha bona, no nere lenigai, “Tere oruwanga eege heigegi uwa.” ");
INSERT INTO eri_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ariya, Yesus no nere afenege hugeru nagi borodu bona, no nomo kolos ufaro ege tetanidu bona yafai. Onodu bona, no nere benou isoki nigai, “Tere ji ono tiginaha waha nomo hugu bona, tere foo tigaha yo?” ");
INSERT INTO eri_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tere ji Isisi tigou fai hiboya, Anyakaro hiya. Tere onou leya wa hilobainga. Ji tebere Isisi tigou, ji tebere Anyakaro. ");
INSERT INTO eri_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ariya, ji tebere Isisi tigou fai, ji tebere Anyakaro, ji tere afetege hugeru taginaha. Onou bona, tere fere fai ila tebere gane waha nebere afenege hugeru nagagu. ");
INSERT INTO eri_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ji tere fanyimu abitimu tiginaha. Ariya, tere fere fanyimu ji elebe ono tiginaha onounga, ono wagu. ");
INSERT INTO eri_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ji tere ngalenga letigini: Haruwe magana no nomo fai anyakaro feiya tuwou uwa. Onounga, fai no haruwe ete langa goina waha, no fai haruwe langa huuru tuganga goina waha, feiya tuwou uwa. ");
INSERT INTO eri_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Elebe tere fanyimu ji ono tiginaha waha nomo hugu tigini waha tere isiyaha. Ariya, tere oojode bonade wonga, tere edo edega wagu! ");
INSERT INTO eri_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ji tere oruwanga boni lewei uwa. Ji nere fai, ji yame bonadu hangada nigene waha ji isini. Onodu ji isini wa, Itou nomo buk langa beele inyina wa, no tigini heigon bona. Beele waha no benou, ‘Fai no ji ngare beret nyiyare waha, no afo ji ilei hiyona isouna.’ ");
INSERT INTO eri_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dada waha heigei uwa inyi ganga, ji elebe waha bona amina letiginaha. Onou bona, iinga sain no heige boro wonga, tere huwanyatege edo benou ngalenga wona Ji Yage Ji Onou Yafagou. ");
INSERT INTO eri_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ji tere ngalenga letigini: Fai no haruwe fai ji huuru tugenega goina waha, no haudu oofade tuna wa, fai no waha ji haifedu oofade hina. Ariya, fai no ji haifena wa, no Itou no ji huuru hiyainga meene waha hauna.” ");
INSERT INTO eri_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus no lenigi borodu bona, no huwanya ouwai. Onodu bona no beele benou malalamudu lewai, “Ji tere ngalenga letigini: Tere gamatege langa ete, no ji haifedu bona, nere yame honggoro fai owonege langa tafa hiyonbona.” ");
INSERT INTO eri_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesus no onou lewainga nere nomo disaipel, nere nage-nage feele guruwane. Nere no faiwei bona lenawou waha, nere alai uwa. ");
INSERT INTO eri_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ono gane disaipel ete, Yesus no gaude tugai waha, no gai Yesus hinomu langa yafai. ");
INSERT INTO eri_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Onowai wa, Saimon Pita no fai waha dumala tubona letuwai, “Ne no isoki tuwau, no faiwei bona lena.” ");
INSERT INTO eri_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ono wainga, disaipel waha no, Yesus bura hinemu langa turigedu bona, isoki tuwai, “Anyakaro, ne faiwei boni leni yo?” ");
INSERT INTO eri_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ono wainga, Yesus no beele gidu benou letuwai, “Ji da matau, oore langa kobomudu boni tuwon boni. Ono woni wa, fai no waha wenga.” Onodu bona, no da matau oore langa kobomudu bona no Judas, Saimon Iskariot nomo idau tuwai. ");
INSERT INTO eri_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Onowai wa, Judas no da waha tainga, wala-wala gou fai Satan, no huwanya langa goyai. Ono wainga, Yesus no benou letuwai, “Dada ne onowau ganga waha, ne fasadu onowau.” ");
INSERT INTO eri_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ono wainga, nere fai oruwa tewol langa yafane waha, Yesus no Judas beele letugainga isane waha nomo hugu bode nere alai uwa. ");
INSERT INTO eri_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ariya, Judas no moni bogisi oofagai waha bode, nere ila ninanege isane, Yesus no Judas moni waha tedu bona, goi bori nomo fati anyakaro waha nomo dada ejiyawei nomo yo, uwa, nere fai dadanege uwau waha, dada nigei nomo bona letuna, iiwane. ");
INSERT INTO eri_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ariya, Judas no da matau waha te bonanga, no fasadu onou heigedu malala goyai. Ono gainga, ha amina aguguwai. ");
INSERT INTO eri_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ariya, Judas no heigedu malala goyainga, Yesus no lewai, “Elebe Fai Nomo Idau no unyi anyakaro tena. Ono ganga, Itou no Fai Nomo Idau langa, unyi anyakaro tena. ");
INSERT INTO eri_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Saini Itou no, no langa unyi anyakaro tona la, Itou no nogowe Fai Nomo Idau unyi anyakaro tuwonbona. No fasayadu, onou ono wonbona. ");
INSERT INTO eri_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yame magana gane, ji tere ngale saini tutu mene yafon boni. Ono wehenga, tere ji kuru hiyagu ganga. Ji nere Juda lenigene dorofenga, elebe ji tere fere onounga letigini. Ha ji goini waha langa, tere goyei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ariya elebe, ji tere nuuni beele eege te tigini wa benou tere etenga-etenga, nere ila gaude nigagu. Ji tere gaude tigini dorofe. ");
INSERT INTO eri_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Onou wa, tere etenga-etenga nere fai fereha ila yame gane waha, gaude nigi bonade wonga, ariya waha no nere fai-aita oruwa abitimu nigona wa, tere ji yame disaipel ganewou.” ");
INSERT INTO eri_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ariya, Saimon Pita no Yesus benou isoki tuwai, “Anyakaro, ne alanga goyau ganga?” Ono wainga, Yesus no beele ege gidu benou letuwai, “Ha ji goini waha langa, elebe ne oojo hidu waha langa goyei nomo edo uwa. Onou wa, iinga gonga nu, ne ji oojo hidu goyau ganga.” ");
INSERT INTO eri_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ono wainga, Pita no Yesus isoki tuwai, “Anyakaro, adadu bona elebe ji ne oojo hinei nomo edo uwa? Ji ne hoyo hinei nomo boni, ji edo yame agefe auma awonboni.” ");
INSERT INTO eri_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ono wainga, Yesus no beele ege gidu benou letuwai, “Ne isini, ne ji hoyo hiyei nomo boni, name agene auma edo awau ganga iini yo? Ji ne ngalenga tigini lehinini: Saini tewe kokoroko wei uwa inyi gonga, ne le eei wau ganga, ji no boni ada isiniwou.” ");
INSERT INTO eri_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ariya, Yesus no ege onou lewai, “Tere huwanyatege adai ou gonga, ninatege baingaro isagu. Tere Itou bonade huwanyatege ngalenga wagu. Ono bonade, tere ji bonade fere huwanyatege ngalenga wagu. ");
INSERT INTO eri_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ji yame Jijei nomo mata langa, no jauli baingaro inyina, onou bona ji tere tebere haumu haiya tagei nomo bona manini. Onou uwa wage wa, ji beele beha ada letigege. ");
INSERT INTO eri_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ji mani haumu haiya tagidu boni, ji ege gidu medu tere hatigehenga, manidu ji ngate yafei nomo. Onodu haumu ji yafani la waha langa, tere fere haumu waha langa, ji ngate yafei nomo. ");
INSERT INTO eri_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Onodu haumu ji manoni waha langa, manei nomo jala waha tere elebe amina isiyaha.” ");
INSERT INTO eri_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ono wainga, Tomas no Yesus letuwai, “Anyakaro, ne alanga goini waha ere alai uwa. Onou wa, ere adadu jala waha boya isei nomo edo?” ");
INSERT INTO eri_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ono wainga, Yesus no benou letuwai, “Ji yagenga, ji jala. Ji beele ngalenga nomo hugu. Ji agenege auma nomo hugu. Fai ete-te, no Jijei bagu jala fere la manei nomo edo uwa. No ji langa, no manonbona. ");
INSERT INTO eri_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tere ji boya amina isiyaha wonga, elebe tere yame Jijei bonade fere edola isi tuwagu ganga. Elebe tere no isi tuwei nomo hugu wariyaha. Onodu tere no amina ureyaha.” ");
INSERT INTO eri_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ono wainga Filip no Yesus benou letuwai, “Anyakaro, ne ere Jijei abitimu higau. Ono wahenga, waha no ebere gauwou ninage bagu edomu wonbona.” ");
INSERT INTO eri_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ono wainga Yesus no letuwai, “Filip, ji saini ufaro tere bagu yafene waha, ne ji bona foo hinei uwa yo? Fai no ji yeriyana waha, no Jijei urena. Adadu boni ne leni, ‘Ne Jijei abiti higau hini?’ ");
INSERT INTO eri_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ji Jijei langa yafa genenga, Jijei no ji langa yafana waha bona ne huwanyate ngalengawei uwa rute? Beele ji tere letigini waha, ji yage yame ninafe langa ada letigi-tigini. Uwa. Jijei ji langa yafana waha, no nomo haruwe ono-onona. ");
INSERT INTO eri_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tere beele beha bonade huwanyatege ngalengawou. Ji Jijei langa yafa genenga, Jijei no ji langa yafana. Onou uwa wonga wa, tere haruwe oruwa ji ononi waha bonade ninatege isadenga, waha no tebere huwanyatege ngalengawou jaimu tagonbona. ");
INSERT INTO eri_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Ji tere ngalenga letigini. Fai no ji bona huwanya ngalenga wona wa, no fere nere haruwe ji ononi onou ono wonbona. No haruwe aroro, haruwe ji ono wene waha feiya hiyou ono wonbona. Taate bona, ji Jijei bagu manini. ");
INSERT INTO eri_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Onodu, tere dada oruwa bona, ji unyife langa isoki wagu wa, ji ono wonboni. Ono wehenga, Jijei no nomo Idau langa, unyi anyakaro tonbona. ");
INSERT INTO eri_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dada oruwanga, tere ji unyife langa isoki wagu wa, ji ono wonboni.” ");
INSERT INTO eri_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ariya, Yesus no ege onou lewai, “Tere ji gaude hibonade wonga wa, tere yame beele oojo dewagu. ");
INSERT INTO eri_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ono wadenga, ji yame Jijei isoki tuwehenga, no tere dangamu tigei nomo hoyo tigou ete tigonbona. Ono wonga, no tere bagu gai-gai yafonbona. ");
INSERT INTO eri_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hoyo Tigou waha, no beele ngalenga nomo Hauri. Nere fai-aita bagu ha eseneha nere no ada tode. Nere no ureg uwa, onodu nere no bode ada isode. Ariya tere nu, no boya isiya. No tere bagu yafana, onodu no tere gamu langa yafonbona. ");
INSERT INTO eri_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ji tere awa tigehenga, magana amenege anyanege gane bagu uwau dorofe ada yafagu ganga. Uwa. Ji ege gidu tere bagu monboni. ");
INSERT INTO eri_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Saini menenga la, nere fai-aita bagu ha eseneha, nere ji ege ada yeriyode. Ariya tere nu, ji yeriyagu ganga. Ji agefe auma yafani, onou bona, tere fere agetege auma yafagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Fati waha langa tere isagu ganga, ji yame Jijei langa yafa genenga, tere ji la yafaya. Ono geyenga, ji tere langa yafani. ");
INSERT INTO eri_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Fai no yame nuuni beele tedu bona, no oojo dena wa, fai waha no ji bona gaude tuna. Onodu fai no ji gau hina wa, yame Jijei no fai waha gau tuwonbona. Ono gonga, ji fere no gau tuwon boni. Onodu ji yage we, yage no abitimu tuwon boni.” ");
INSERT INTO eri_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesus no onou lewainga, Judas ete, no Judas Iskariot uwa, no Yesus benou isoki tuwai, “Anyakaro, adadu bona ne nage ne ere abitimu higi boni, nere ha eseneha nomo fai-aita bagu nere, ne nage ne abitimu nigei nomo edo uwa?” ");
INSERT INTO eri_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ono wainga, Yesus no beele ege gidu benou letuwai, “Fai no ji bona gaude tuwona wa, no yame beele oojo dewonbona. Ono wonga, yame Jijei no fai waha bona gau wonbona. Ono wonga, ere no bagu maidu boyare, gai-gai no bagu yafo boyare. ");
INSERT INTO eri_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Fai no ji bona ada gaude tuna wa, no yame beele waha ada oojo de-dena. Beele tere isiya beha waha, ji yage yame beele uwa. Wa yame Jijei nomo beele, no ji huuru hiyainga meene waha. ");
INSERT INTO eri_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Saini ji tere bagu yafa boni, ji tere dada beha boni letigenaha. ");
INSERT INTO eri_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ariya, hoyo tigou tigini dangamu tigei nomo wa Hauri Guuni. Jijei no ji yame unyife langa huuru wonga monbona. No dada oruwa bona tere isisiwou tigonbona. Onodu bona, no tebere ninatege jaimu wonga, tere beele oruwa ji letigeneha waha bonade, ege ninatege isagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ji tere awa tigon boni, waha bona ji yame huwanyafe foinga inyou wa, tere tigini. Ariya ji yame huwanyafe foinga inyou tere tigini beha waha, nere fai-aita bagu ha eseneha waha, nere tigide dorofe uwa. Onou waha bona, tere huwanyatege ou gonga, ninatege baingaro isi bonade adai umugagu. ");
INSERT INTO eri_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ji beele beha letigenenga, tere amina iseyeha: ‘Ji tere awa tigidu manon boni. Onodu ji ege gidu tere bagu monboni.’ Tere ji gaude hibonade wonga wa, ariya waha no tere edo ono tigonga edega wagu ganga. Taate bona, ji Jijei bagu manon boni, Jijei no ji feiya hidu no amugou tigini. ");
INSERT INTO eri_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ariya, dada waha iinga heigei uwa inyi ganga, ji elebe waha bona amina letiginaha. Onou waha bona, iinga saini dada waha heigonga, tere huwanyatege edo ngalenga wona. ");
INSERT INTO eri_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ariya, ji tere bagu beele inyanga ada lewoni. Taate boni, ha esene beha ofagou fai mora bagu waha no amina maina. No ji dada ete ono hiyei nomo danga uwau, ");
INSERT INTO eri_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ariya ji gauni wa, nere fai-aita bagu ha eseneha edo isode wa ji Jijei gaude tu-tuni, onodu ji Jijei dada oruwa onowei nomo lehina waha, oojodu ono-ononi. Ariya tere jayadenga ere goyoya.” ");
INSERT INTO eri_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus no ege onou lewai, “Ji yage ji wain nauge tigini. Ono genenga, yame Jijei no wain haga morou. ");
INSERT INTO eri_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ji yame tuwafe oruwa langa hilou ada heigena waha, Jijei no karudu kaitena. Ariya, tuwa oruwa no hilou heigena waha, Jijei no gala dada inyabawou waha elege ayarudu bona fi-fina. Ono ganga, no eege heigedu hilou baingaro heige-heigena. ");
INSERT INTO eri_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tere amina eege heigeyaha. Beele ji letiginaha beha ono tiganga, tere eege heigeyaha. ");
INSERT INTO eri_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tere ji fada hiyadenga, ji tere fada tigon boni. Wain nomo tuwa no nauge langa fada tuwei uwa wonga wa, no hilou ada heigonbona. Onou dorofenga, tere ji langa fada wegu uwa wonga, wa tere fere hilou ada heigagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ji yage ji, wain nauge. Tere wain nauge nomo tuwa. Fai no ji langa fada ganga, ji no la fadani waha, no hilou baingaro heige-heigena. Tere ji awa hi bonade wonga, tere dada ete ada ono wagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Fai ete no ji langa ada fada bona wonga, wa, no nauge tuwa karudu kaitede dorofe onou ono tuwodbode. Ono wonga, no kakaregon bona. Onodu nere nauge tuwa waha, elege komomudu bode, eeya langa ayarudu bode, biteru gane usige-usigena. ");
INSERT INTO eri_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Tere ji fada hibonade wonga, yame beele no tere langa inyi gonga, tere edo tebere gauwou langa isoki gadenga, nere dada tere leya onounga heigon bona. ");
INSERT INTO eri_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tere hilou baingaro heigemudu, yame disaipel gane yafagu. Fanyimu waha langa yame Jijei no unyi anyakaro tonbona. ");
INSERT INTO eri_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jijei no ji gaude hi-hina, onounga ji fere tere gaude tigi-tigini. Saini oruwa, tere yame gauwou beha huwanya langa yafagu. ");
INSERT INTO eri_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tere yame nuuni beele oojode bonade wonga, tere yame gauwou waha huwanya langa yafagu ganga. Wa ji, yame Jijei nomo nuuni beele oojodedu, nomo aau warou huwanya langa yafani dorofe. ");
INSERT INTO eri_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ji gauni wa, ji yame edegawou waha edo tere langa inyonbona. Onodu edegawou waha, edo tere huwanyatege langa bolowon bona. Onou boni, ji beele beha tere letigini. ");
INSERT INTO eri_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ji yame nuuni beele wa benou: Ji tere boni gaude tigini dorofenga, tere etenga-etenga fere, nere ila gaude nigagu. ");
INSERT INTO eri_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Onou wa, fai ete no nomo ilibumu gane hoyo nigei nomo bona, no nogo nomo ago auma awona wa, no fai-aita ila gau nigou fanyimu ila waha tigini feiyade tuwou. ");
INSERT INTO eri_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Onou wa, ji tere letigini onou ono bonade wonga, tere ji yame ilibafe gane yafagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Haruwe magana no, dada no nomo fai anyakaro onona waha, no ada isina. Onou waha bona, ji tere ege ‘haruwe magana’ ada tigoni. Beele oruwanga yame Jijei langa isene waha, ji tere letigeneha. Onou waha boni, ji tere yame ilibafe gane tigini. ");
INSERT INTO eri_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Ji tere bagu yafei nomo bona, tere ji hangada hiyegu uwa. Tere ji yame gane yafei nomo bona, hangada tigene. Onodu ji tere haruwe tigini. Tere edo goidu hilou heigemu wadenga, tere tebere da edo hilobainga inyona. Onou waha bona, tere ji unyife langa, yame Jijei dada ete tigei nomo bona hauya tubonade isoki tuwagu wa, no tere tigonbona. ");
INSERT INTO eri_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ji tere nuuni beele benou tigini: Tere etenga-etenga, nere ila gaude nigagu.” ");
INSERT INTO eri_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Yesus no ege onou lewai, nere fai-aita bagu ha eseneha nere, tere honggoro fai tafa tigogunga wa, tere isagu nere waha amugedu, ji fere honggoro fai tafa hiyaneha. ");
INSERT INTO eri_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Onou wa, tere fai-aita ha esene beha nomo dorofe yafage wa, nere fai-aita ha eseneha waha, tere nebere gane dorofe bona, gaude tigage. Ariya, tere ha esene beha nomo fai uwa. Ji tere ha esene beha nomo fanyimu awei nomo bona amina hangada tigene. Onou bona, nere fai-aita bagu, ha esene beha nomo waha, nere honggoro fai tafa tigi-tigide. ");
INSERT INTO eri_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tere beele ji letigeneha waha bonade ninatege isi dewagu. ‘Haruwe magana, no nomo fai anyakaro feiya tuwou uwa.’ Onou wa, nere ji inyabamu hiyane wonga, tere fere onounga inyabamu tigodbode. Onou wa, nere yame beele oojo wane wonga, nere tere tebere beele fere oojo wodbode. ");
INSERT INTO eri_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ariya, nere Jijei no ji huuru hiyainga meene waha, nere no bode ada iside. Onou waha bode, nere fanyimu inyaba oruwa tere ono tigodbode, taate bona, nere isode wa tere yame ganewou. ");
INSERT INTO eri_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ariya ji ada medu boni, nere beele lenigege wa, wa nere nebere nyabuluwou nomo une te uwau. Onou bona, elebe nere nebere une huwarimuwei nomo jala te uwau. ");
INSERT INTO eri_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Fai no ji nomo honggoro fai tafa hina wa, no yame Jijei fere nomo honggoro fai tafa tuna. ");
INSERT INTO eri_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Onou wa, ji nere gamanege langa ada yafa boni, haruwe danga bagu fai ete amina onowei uwa waha ada onowege wa, nere nebere nyabuluwou waha nomo une uwau. Ariya nere yame haruwe waha nere amina urane. Ono wane wa, nere ji yame Jijei ngare bode nere eire honggoro fai heigane. ");
INSERT INTO eri_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ariya, nere fanyimu ono wane wa, nere nebere nuuni beele langa beele ete inyina waha, edomuwei nomo bona. Beele waha no onou, ‘Nere fai ji ewe auma honggoro fai tafa hiyane.’ ");
INSERT INTO eri_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ariya, Hauri tere dangamu tigei nomo waha, no Jijei bagu yafana, waha ji huuru tuwehenga, tere bagu monbona. Hauri waha no beele ngalenga nomo hauri. No medu bona, yame haruwe bagu, fanyife bagu bona fomudu lewonbona. ");
INSERT INTO eri_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ariya, tere fere beele malalamudu lewagu, taate bona, saini ji haruwe hugu warene laha mai elebe, tere ji bagu yafa geyenga mayai. ");
INSERT INTO eri_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ji tere huwanyatege ngalengawou adai awagu ganga boni, beele waha letigeneha. ");
INSERT INTO eri_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Onodu tere mayadenga nere ngate bori urei nomo bode karu tigodbode. Ono gonga, iinga saini heigonga, nere tere dutege kote wogunga umeru wagu ganga. Onodu nere ninanege isode wa, ‘Ere Itou nomo haruwe hilobainga,’ onoyawou. ");
INSERT INTO eri_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nere Jijei bode ada iside, nere ji bode fere ada iside. Onou waha bode, nere fanyimu waha ono wodbode. ");
INSERT INTO eri_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ariya, elebe ji nere dada heigodbode waha amina letiginaha. Onou waha bona, iinga sain fai nere fanyimu waha tere langa ono wogunga, tere beele ji letigini beha bonade ninatege isagu.” Ariya, Yesus no ege onou lewai, “Amina ji yage ji tere bagu yafene. Onou waha bona, ji nere dada beha boni letigei uwa. ");
INSERT INTO eri_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ariya, elebe ji Jijei bagu manini, no ji huuru hiyainga meene. Onou wa, tebereha ete no ji benou isoki hiyei uwa, ‘Ne alanga goini?’ ” ");
INSERT INTO eri_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ji beele beha letiginanga, elebe tere huwanyatege tigini ou waha. ");
INSERT INTO eri_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ariya, ji tere ngalenga letigini: Ji tere hoyo tigei nomo boni, awa tigidu manon boni. Ji manei uwa wonga wa, Hauri tere dangamu tigei nomo waha, no tere bagu ada monbona. Ji manoni wa, ji no huuru tuwehenga, tere bagu monbona. ");
INSERT INTO eri_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","No medu bona, no nere fai ha eseneha ono nigonga, nere une nomo hugu bagu, fanyimu tigini nomo hugu bagu, Itou nomo kot nomo hugu waha nere isi dewodbode. ");
INSERT INTO eri_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Une nomo hugu wa benou, nere ji bode huwanyanege ngalenga wegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Onodu, fanyimu tigini nomo hugu wa benou, ji Jijei bagu manon boni. Ono wehenga, tere ji ege ada yeriyagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Onodu, Itou nomo kot nomo hugu wa benou, ha esene beha oofagou nomo mora bagu wa, no kot langa mebodu waha. ");
INSERT INTO eri_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ji beele baingaro tere letigei nomo inyina, onou wa tere elebe ada taagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Onou wa, saini ngalenga beele nomo Hauri mona la, no tebere ninatege fokomu tagonga tere ngalenga beele oruwa isi dewagu ganga. No beele ete, nogo nomo ninau langa ada lewonbona. Beele no isai wahanga malalamudu lewonbona. Onodu bona, no dada iinga huunta langa heigonbona waha letigonbona. ");
INSERT INTO eri_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","No ji yame beele waha tedu bona, tere malalamudu letigonbona. Ono wonga, fanyimu waha langa, ji yame unyife anyakaro, danga bagu waha heigemu wonbona. ");
INSERT INTO eri_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jijei nomo dada oruwanga wa, ji yame. Onou waha boni ji leni: No ji yame beele tedu bona, tere malalamudu letigonbona.” ");
INSERT INTO eri_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ariya, Yesus no ege onou lewai, “Saini tutu mene la, tere ji ege ada yeriyagu ganga. Onodu, iinga saini menanga onou, tere ji ege yeriyagu ganga.” ");
INSERT INTO eri_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ono wainga, nere disaipel ila, nere nage gamanege la benou leguruwane, “No beele ere lehigaha waha, nomo hugu adadu? No lewaha, ‘Saini tutu mene la, tere ji ada yeriyagu ganga. Onodu, iinga ege saini menanga onou la, tere ji yeriyagu ganga.’ Onodu bona no lewai, ‘Waha nomo hugu wa benou, ji Jijei bagu manini.’ ” ");
INSERT INTO eri_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ono wainga, “Nere lewane, ‘no saini tutu mene’ bona lewaha, wa no taate dada? Ere beele no lewaha waha nomo hugu ere alai uwa.” ");
INSERT INTO eri_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ariya, Yesus no isai, nere no isoki tuwodbode. Onou waha bona no nere lenigai, “Ariya beele ji lenaha beha nomo hugu boya ru, tere tage-tage kejiwe onou isoki guruya? Ji benou lenaha, ‘Saini tutu mene la tere ji ada yeriyagu ganga. Onodu iinga ege saini menanga onou la tere ji ege yeriyagu ganga.’ ");
INSERT INTO eri_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ji tere ngalenga letigini. Tere inyangaro aau tarigou bagu meragu ganga. Ono gadenga, nere ha eseneha fai-aita bagu nere edega gogunga, tere huwanyatege ou wonbona. Ariya, tebere huwanyatege ou waha wa, ege ubuludu edegawou heigonbona. ");
INSERT INTO eri_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aita no magana bison bona waha no isina, nomo sain amina heigaha. Onou bona no huwanya ouna. Onodu saini no magana bisi borodu bona, no ege jimiri waha bona ninau ada isina. Uwa. No magana bisanga oula langa heigaha waha bonanga edegana. ");
INSERT INTO eri_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onou dorofenga, elebe tere huwanyatege ouna. Onou wa, ji iinga ege terigon boni. Ono wehenga tere huwanyatege edega wonbona. Onodu fai ete, no tebere huwanyatege edegawou waha, uwamu tagei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Onodu, saini waha langa, tere ji dada ete bona ada isoki hiyagu ganga. Ji tere ngalenga letigini. Tere dada ete bonade, yame unyife langa Jijei isoki tuwagu wa, no tere tigonbona. ");
INSERT INTO eri_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","“Amina, tere dada ete tei nomo boya, tere ji unyife langa isoki wegu uwa. Ariya, tere isokidu tere taagu ganga. Ono gonga, tebere huwanyatege no edegawou bolowon bona.” ");
INSERT INTO eri_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesus no ege onou lewaiha, “Ji beele letigene beha waha, ji muuji beele langa letigina. Iinga gonga ji ege muuji beele ada letigoni. Ji tere Jijei boni beele malala foomudu letigon boni. ");
INSERT INTO eri_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Saini waha langa, tere yame unyife langa hauya wagu ganga. Ariya, ji tere benou letigei uwa: Ji yage we, Jijei tere hoyo tigei nomo bona hauya tuwon boni. ");
INSERT INTO eri_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Uwa. Jijei no nogo we, tere bona gau tuna. Taate bona, tere ji gau hiyei, onodu tere ji Itou bagu yafadu meene waha boya, tere amina huwanyatege ngalenga weiha. ");
INSERT INTO eri_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Amina ji Jijei bagu yafadu, no awatudu boni ha esene langa meene. Ariya elebe ji ha esene beha awadu boni, ege gidu Jijei bagu manon boni.” ");
INSERT INTO eri_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ono wainga, nomo disaipel nere benou lewane, “Yo, elebe ne muuji beele lewei uwa, ne beele tigini malala foomunaha leni. ");
INSERT INTO eri_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Elebe ere isiya, ne fai isoki hinei uwa langa, ne nomo isokiwou waha amina isidu ne nomo isokiwou gidu letu-tuni. Ne dada oruwa boni ne amina isini. Onou bona, ere huwanyage ngalengana wa, ne Itou bagu yafadu meene.” ");
INSERT INTO eri_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ono wanenga, Yesus no nebere beele ege gidu benou lenigai, “Elebe tere huwanyatege ngalengaya yo?” ");
INSERT INTO eri_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Isagu. Saini elebe juguna, yo, no amina heigaha, nere tere etenga-etenga oruwa soka tigogunga, tebere matane langa kejiwe haara wagu ganga. Ono bonade, tere ji awa hiyadenga ji yagenga yafon boni. Onou wa, ji yagenga tigini ada yafoni. Taate bona, Jijei no ji bagu yafana. ");
INSERT INTO eri_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ji gauni wa, tere ji bagu fadadu, tebere huwanyatege foinga inyei nomo boni, ji tere beele beha letigini. Saini tere ha esene belanga yafagu wa, nere ou tere langa heigonbona. Onowona wa, tere tebere huwanyatege edo danga inyona! Ji ha esene beha nomo danga amina feiya weneha.” ");
INSERT INTO eri_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ariya, Yesus no nomo disaipel beele malalamudu lenigi borodu bona, no tararadu, ha laluwa ouwe la feele bona benou lewai, “Jijei, saini amina heigaha. Elebe ne name Idate edo unyi anyakaro tuwau. Ono wahenga Idate no edo, ne unyite anyakaro hinon bona. ");
INSERT INTO eri_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Taate bona, ne no unyi anyakaro amina tuweneha. Onou waha bona, no nere fai-aita oruwa nebere mora bagu yafei nomo bona hangada tuwene. Ono wene waha, no nere fai-aita, ne tuwene waha, no nere agenege auma edola nigon bona, wa agenege auma gai-gai hilobainga yafei nomo waha. ");
INSERT INTO eri_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ariya, agenege auma gai-gai hilobainga yafei nomo waha benou. Nere fai agenege auma yafou tane waha, nere ne bode iside. Ne nagenga ne ngalenga Itou. Onodu nere Yesus Kristus bode iside, wa ne huuru tuwenenga mai. ");
INSERT INTO eri_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Ji name unyite anyakaro bagu, name danga waha bagu, nere fai-aita ha esene belaha abitimu nigene. Haruwe ne ji onowei nomo boni hiyene waha, ji usumu wene. ");
INSERT INTO eri_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jijei, sain oula heigei uwau inyi gainga, ji unyife anyakaro bagu ne ngare yafere. Onou bona, elebe ji gauni wa, elebe ne unyife anyakaro waha ege hiyahenga, ji ne ngare yafo boyare. ");
INSERT INTO eri_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ji nere fai ha esene belaha ne ji hiyeneha waha, ji nere name unyite malalamudu lenigeneha. Nere waha, ne name fai, ne ji amina hiyeneha. Ono wene waha, nere name beele oojo dewane. ");
INSERT INTO eri_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Elebe nere iside, dada oruwa ne ji hiyeneha waha, ne langa mayai. ");
INSERT INTO eri_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Beele oruwa, ne ji hiyene waha, ji nere nigi borowene. Ono wenenga, nere tedu bode isina wa, ngalenga tigini, amina ji ne ngare yafere waha ji meene. Onodu bode, nere ne ji huuru hiyenenga meene waha bode, nere huwanyanege ngalenga wane. ");
INSERT INTO eri_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ji fai ha eseneha hoyo nigei nomo boni hauyawei uwa. Ji nere fai, ne ji hiyene waha hoyo nigei nomo boni hauyani. Taate bona, nere waha ne name gane. ");
INSERT INTO eri_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nere fai-aita oruwa ji yame waha, oruwa ne name. Ariya, nere fai-aita oruwa ne name waha, oruwa ji yame. Onodu saini nere fai-aita, yame gane waha nerigedu, nere yame unyife anyakaro bode isi-iside. ");
INSERT INTO eri_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ariya, elebe ji ne bagu mainaha, onou wa ji ege ha esene langa ada yafoni. Ariya, nere nu ha esene langa yafodbode. Jijei, ne guuni, fai ne dorofe ete uwau, ne edo name unyite nomo danga langa nere oofa nigau, wa unyite ne ji hiyene waha. Ono wahenga nere edo, ji ne ngare ere huwanyare tigini etenga yafayare onounga, nere fere huwanyanege tigini etengadu yafode. ");
INSERT INTO eri_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Saini ji nere bagu yafene la, ji ne name unyite nomo danga langa nere oofa nigi gene. Unyite waha, ne ji hiyene. Ji nere oofade nigene waha, nebereha ete no yaaewei uwa. Fai yaaewei nomo wa, fai etenga no yaaewai. Wa beele name buk langa inyina waha, tigini onou heigai. ");
INSERT INTO eri_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Elebe ji ne bagu maini. Ariya, saini ji ha esene belanga yafa boni, ji beele beha leni, wa yame edegawou edo nere huwanyanege langa bolodu inyonbona. ");
INSERT INTO eri_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Ne name beele ji nere amina nigi boronaha. Ono nanga, nere fai-aita bagu ha esene beha nomo nere honggoro fai tafa nigane. Taate bona, nere ji yame fai-aita bagu, nere ha esene beha nomo uwa. Wa ji fere, ji ha esene beha nomo uwa. ");
INSERT INTO eri_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ji nere ha esene belaha hanigedu goyei nomo boni isoki hinei uwa. Ji ne nere edo oofa nigau ganga boni hauya hinini, gamaji fai inyaba no inyabamu nigoga. ");
INSERT INTO eri_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ji ha esene beha nomo uwa. Onounga, nere fere ha esene beha nomo uwa. ");
INSERT INTO eri_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ne name beele wa oruwa ngalenga, onou boni ji gauni wa, ne name ngalenga beele waha ono wahenga, nere huwanyanege langa haruwe bona, nere ono nigonga name gane tigini heigode. ");
INSERT INTO eri_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Amina, ne ji guuru hiyenenga medu boni, nere fai-aita ha eseneha gamanege langa yafene. Onounga, ji fere nere fai ne hiyene waha, huuru nigene, nere goidu bode, nere fai-aita ha eseneha waha gamanege langa yafodbode. ");
INSERT INTO eri_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ariya nere hoyo nigei nomo bona, ji yame agefe auma oruwa ne hinini. Ono wonga, ngalenga tigini nere fai waha edo ne name gane tigini heigod bode. ");
INSERT INTO eri_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ariya, ji nere fai wahanga hoyo nigei nomo boni hauyawei uwa. Ji nere fai-aita nebere beele isidu bode, nere ji bode huwanyanege ngalenga wodbode, waha boni hauyani. ");
INSERT INTO eri_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ji nere fai waha oruwanga, huwanyanege etengadu yafei nomo bona gau hina. Jijei, wa ne ji langa yafa genenga, ji ne langa yafani dorofe. Onounga, ji nere ere nga langa yafei nomo gau hina. Ono wonga, nere fai-aita ha eseneha, nere huwanyanege edo ngalenga wode wa, ne ji huuru hiyenenga meeneha wou. ");
INSERT INTO eri_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne unyite anyakaro bagu, danga bagu, ji hiyene waha nere nigeneha. Onou bona, nere edo huwanyanege etengadu yafodbode. Wa ji ne ngare huwanyare etengadu yafayare dorofe. ");
INSERT INTO eri_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ji nere langa yafa genenga, ne ji langa yafani. Onodu fanyimu waha langa, ji nere huwanyanege gai tigini etengawei nomo boni gaude hina. Ono wogunga, nere fai-aita bagu, ha eseneha nere edo isode wa, ne ji huuru hiyenenga meene. Ariya, ne ji gau hiyene fanyimu onounga la, ne yame gane fere onounga gau nigau. ");
INSERT INTO eri_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Jijei, ji nere fai-aita bagu ne ji hiyeneha waha, nere edo ji ngate haumu ji yafani walanga yafei nomo boni gau hina. Ji nere yame lala anyakaro bagu, danga anyakaro bagu waha edo urei nomo boni gau hina. Saini oula heigei uwau langa, ne ji gau hidu boni, ne ji lala bagu unyife anyakaro bagu hiyeneha. ");
INSERT INTO eri_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Jijei tigini, nere fai-aita ha eseneha, nere ne bode ada iside. Ariya, ji nu ne boni isini. Nere yame gane nere, ne ji huuru hiyenenga meene waha nere iside. ");
INSERT INTO eri_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ji name unyite nere langa heigemu weneha. Ono wene waha, ji ege inyangaro heigemu wonboni. Ono wehenga, nere fai ila gau nigei nomo fanyimu waha todbode. Wa ne ji gau hini dorofe. Ono wonga, ji fere edo nere langa yafon boni.” ");
INSERT INTO eri_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ariya, Yesus no beele waha leborodu bona, no nomo disaipel gane bagu nere minidu, Kidron yaage faawane. Yaage waha ulate langa haga ete inyai. Onowai wa, Yesus no nomo disaipel gane bagu, nere mani haga waha huwanya la goyane. ");
INSERT INTO eri_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ariya Judas, fai no waha Yesus honggoro fai owonege langa tafa tuwon bona, waha no fere, haga waha bona no alai. Taate bona, saini baingaro Yesus no nomo disaipel gane bagu, nere haga walanga koto gane. ");
INSERT INTO eri_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Onou waha bona, Judas no nere oota fai bagu, Pris aroro Farisi bagu nebere Polis ila hanigainga haumu walanga mayane. Nere lama bagu, baa bagu, oota warawei nomo dada bagu yaasudu mayane. ");
INSERT INTO eri_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus no dada oruwa no langa heigon bona waha, no amina isai. Onou bona, no golodu goi nere jugu nigidu bona isoki nigai, “Tere faiwe kuru tuya?” ");
INSERT INTO eri_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ono wainga, nere nomo beele ege gidu benou letuwane, “Ere Yesus Nasaretha kuru tuwoya maiyaha.” Ono wanenga, Yesus no nere lenigai, “Be ji wenga.” Ariya Judas fai no waha, no Yesus nere nigonbona waha, nere gaara otowane. ");
INSERT INTO eri_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ono gane, saini Yesus no nere lenigai, “Be ji wenga,” ono wainga, nere ege mogonege la esuwadu goi oula la metaumeru wane. ");
INSERT INTO eri_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ono wanenga, no ege isoki nigai, “Tere faiwei kuru tuya?” Ono wainga, nere letuwane, “Yesus Nasaretha.” ");
INSERT INTO eri_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ono wanenga, Yesus no nere lenigai, “Ji amina letiginaha, be ji wenga. Onou wa, tere ji kuru hiya wonga, tere fai nere beha awa nigadenga goyode.” ");
INSERT INTO eri_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ariya, fanyimu waha langa, no beele amina lewai waha edomuwai. Beele no amina lewai wa benou: “Nere fai beha, ne ji hiyene waha, nebereha ete yaaewei uwa.” ");
INSERT INTO eri_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ariya, Saimon Pita, no oota nomo kesebu mutu ufaro ete tedu mayai waha uulu tedu bona, Pris mora bagu nomo haruwe magana waridu, nomo agokuli ulate, owo hilou langa waha, tigini saludu kaite fuwainga meboduwai. Haruwe magana waha nomo unyi, Markus. ");
INSERT INTO eri_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ono wainga, Yesus no Pita letuwai, “Ne name kesebu mutu ufaro, ege nomo osoko langa tanahenga minona.” Onodu bona letuwai, “Adadu? Ne isini, ji kaap Jijei hiyaha beha langa ada nyoni yo?” ");
INSERT INTO eri_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ariya, nere oota fai nebere ofisa amugou bagu, nere Juda nebere polis bagu, nere Yesus yaasu tudu bode, maalu langa dage tuwane. ");
INSERT INTO eri_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Onodu bode, nere ngasunga Anas bagu haudu goyane. Anas no kaiafas imabumu. Haga orei waha langa, Kaiafas no Pris mora bagu yafai. ");
INSERT INTO eri_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ariya fai no waha, no nere Juda benou lenigai: “Fai etenga, no nere fai-aita bagu oruwa nebere haumu tedu umona wa hilobainga.” ");
INSERT INTO eri_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ariya, Saimon Pita no disaipel ete ngare, nere Yesus oojo tudu goyare. Ono ware wa, Pris mora bagu, no disaipel ete waha bona no alai. Onou bona, no Yesus oojo tudu Pris mora nomo orei huwanya langa goyai. ");
INSERT INTO eri_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ono gainga, Pita no malala arasai hinomu langa otowai. Ono gainga, disaipel ete waha, no Pris mora bagu isi tuna waha no goidu bona, aita jauli arasai oofana waha letudu bona, no Pita haudu huwanya mayai. ");
INSERT INTO eri_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ono wainga, aita jauli arasai oofana waha, no Pita benou isoki tuwai, “Ne fere, ne fai waha nomo disaipel rute?” Ono wainga, Pita no kakiri bona, aita waha letuwai, “Eiye, ji nomo disaipel te uwa.” ");
INSERT INTO eri_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ariya, nere haruwe magana bagu, nere polis bagu, ha oto heige bona nere uliya nigainga, nere eeya ete ujidu bode, genege gala ngasumu bode otowane. Ono ganenga, Pita no fere eeya waha langa gogala ngasumu bona otowai. ");
INSERT INTO eri_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ariya, saini waha langa Pris mora bagu, no Yesus nere nomo disaipel bona bagu, beele no fai lenigigai waha bona bagu isoki tuwai. ");
INSERT INTO eri_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ono wainga, Yesus no beele ege gidu benou letuwai. “Ji nere fai-aita bagu, beele malala gama la lenigigene. Saini oruwa ji nere fai-aita bagu, bori mata langa, Itou Toota Tugou mata nomo orei huwanya langa, haumu nere Juda fai oruwa komo-komode waha langa isisiwou nigigene. Ji huwari haumu langa te, beele ada leni. ");
INSERT INTO eri_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Onouwa ne taate boni ji isoki hini? Ne nere fai-aita bagu, ji beele legenenga nere isaneha waha isoki nigau. Nere beele ji lewene waha, nere iside.” ");
INSERT INTO eri_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus no onou lewainga, polis ete walanga otowai waha, Yesus ulagu bare bona letuwai, “Adadu boni ne fanyimu onou langa, Pris mora bagu nomo beele ege gidu letuni?” ");
INSERT INTO eri_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ono wainga, Yesus no nomo beele ege gidu benou letuwai, “Ji beele ete, lenyabulu naha wonga, ne beele ji lenaha waha malalamudu lewau. Ariya, ji beele hilobainga lenaha wonga, ne taate boni ji ewe auma yarinaha?” ");
INSERT INTO eri_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Onowai wa Anas no Yesus huuru tuwainga Pris mora bagu Kaiafas langa goyai. Nere no maalu dagane waha fuutu fuwegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ariya, Saimon Pita no gogala ngasumu bona otowai. Ono gainga, nere no benou isoki tuwane, “Ne fere, ne nomo disaipel rute?” Ono wanenga, Pita no Yesus unyi kakiri bona ege lenigai, “Eiye, ji nomo disaipel uwa.” ");
INSERT INTO eri_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ono wainga, Pris mora bagu nomo haruwe magana ete, Pita no agokuli saludu kaite fuwai waha nomo ilibumu ete, no Pita letuwai, “Ne Yesus ngare, haga langa yafagere ji neriyene. Wa ngalenga yo?” ");
INSERT INTO eri_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ono wainga, Pita no ege lewai, “Eiye, ji uwa.” Ono gainga, saini waha langa tigini tewe kokorokowai. ");
INSERT INTO eri_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ariya gai eringe amina la, Juda nere Yesus haudu bode Kaiafas nomo mata awadu, nere gabman amugou nomo mata langa haudu goyane. Onodu nere isane, “Gamaji nere Itou ago langa Jijiga bagu heigedu, nere Itou no Israel Awa Nigainga, Hilobainga Yafane Waha Nomo Fati Isei Nomo kaafa waha ada nyoga iwane,” onodu nere nage gabman amugou nomo mata huwanya la goyegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nere malala la itaridu otowane, ono ganenga, Pailot no maidu bona benou isoki nigai, “Tere taate boya fai be kot la tafa tuwagu ganga onoya?” ");
INSERT INTO eri_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ono wainga, nere no letuwane, “Ere fai beha, no fanyimu inyaba ada onogou wage, ere no haudu ne bagu ada mayedege.” ");
INSERT INTO eri_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ono wanenga, Pailot no nere lenigai, “Tere no haudu bonade, togoi tere tage tebere nuuni beele inyina la onou kot langa tafa tuwagu.” Ono wainga Juda nere beele ege gidu benou letuwane, “Ere fai ete dukote wedenga umei nomo wa guuni.” ");
INSERT INTO eri_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Amina Yesus no fanyimu waha langa no umona bona lewai. Onou bona, dada heigai wa no nomo beele ono wonga tigini heigei nomo bona. ");
INSERT INTO eri_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ono wanenga, Pailot no ege gidu bona gabman mata jauli huwanya la goyai. No goidu bona, Yesus yaure tuwainga mayainga, no benou isoki tuwai, “Ne Juda nebere king yo?” ");
INSERT INTO eri_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ono wainga, Yesus no beele ege gidu benou letuwai, “Ne nage ninate isidu, ne beele beha lehini yo, uwa, fai ila we nere ji bode onou lehinane?” ");
INSERT INTO eri_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ono wainga, Pailot no beele ege gidu benou letuwai, “Adadu, ji Juda ete yo? Ne name gane wenga, nere Pris mora aroro bagu, nere ne hainedu ji la mayaneha. Ono wane wa, ne taate ada weneha?” ");
INSERT INTO eri_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ono wainga, Yesus no beele ege gidu benou lewai, “Ji yame agefe auma yafou wa, ha esene beha nomo uwa. Yame agefe auma no ha esene beha nomo wage wa, nere yame haruwe fai, nere edo langa wara wage. Ono wage wa, fai ete no ji nere Juda owonege langa tafa hiyei nomo edo adawage. Ariya, ji yame agefe auma yafou wa, no ha esene beha nomo uwa.” ");
INSERT INTO eri_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ono wainga, Pailot no isoki tuwai, “Onou waha bona, ne ngalenga king ete yo?” Ono wainga, Yesus no beele benou gidu letuwai, “Beele king bona wa, wa ne nage name beele. Yame ngai no ji bisi hiyainga, ji ha esene belanga haruwe etenga onowei nomo boni meene. Wa ngalenga beele waha malalamudu lewehenga, nere fai-aita bagu oruwa edo isei nomo bona. Nere fai-aita oruwa yame ngalenga beele oojode wa, nere yame beele iside.” ");
INSERT INTO eri_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ono wainga, Pailot no Yesus isoki tuwai, “Ngalenga beele wa, taate dada tigini?” Ariya, Pailot no onou leborodu bona, no ege malala heigedu, nere Juda bagu goyai. Onodu bona, no nere benou lenigai, “Ji no la une ete toroba wei uwa. ");
INSERT INTO eri_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Onou wa, tere fanyimu ji oojo-oojoni waha tere alai. Haga orei oruwa la, bori nomo fati anyakaro waha langa, ji tere awa tigigene tere fai ete dagou mata awadu malala heigei nomo bana hangada tutuya. Onou bona, ji Juda nebere king beha awa tuwehenga tere bagu goyei nomo gauya yo?” ");
INSERT INTO eri_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ono wainga, nere ege benou yauredu lewane, “No uwa! Ne Barabas awa tuwau!” Ariya, Barabas no wara bona yebugou fai ete. ");
INSERT INTO eri_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ariya, Pailot no lewainga, nere Yesus haudu bode, falagati tuwane. ");
INSERT INTO eri_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Onodu bode, nere oota fai maalu kudina bagu elegedu, king nomo teteri dorofe atidu bode, mora langa tamimu fuwane. Onodu bode, nere kolos giriwou ete tanimu tuwane. ");
INSERT INTO eri_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Onodu bode, nere mai jugumu tudu bode letuwane, “Kaiye, Juda nebere king!” Nere onou letudu bode, ulagu bare wane. ");
INSERT INTO eri_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ono wanenga, Pailot no ege heigedu, malala maidu bona nere fai-aita bagu benou lenigai, “Uragu, ji no haudu malala mayehenga tere edo isagu ganga, ji no langa nyabuluwou ete toroba fuwei uwa.” ");
INSERT INTO eri_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ono wainga, Yesus no malala la heigedu mayai. Nere teteri maalu kudina bagu langa atidu bode, no mora langa tanimu fuwane waha, onounga inyi gainga, kolos giriwou fere onounga inyai. Ono wainga, Pailot no nere lenigai, “Uragu. Fai waha benu.” ");
INSERT INTO eri_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ariya, nere Pris aroro bagu, nere polis bagu, nere no uredu bode yauredu benou lewane, “Dukote wagu! Dukote wagu! Nauge abalakawou langa tutui la waragu!” Ono wanenga, Pailot no benou lenigai, “Tere tage we no haudu bonade, nauge abalakawou langa tutui la waragu. Ji no langa nyabuluwou ete toroba wei uwa.” ");
INSERT INTO eri_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ono wainga Juda nere ege nomo beele gidu benou letuwane, “Ere ebere nuuni beele ete bagu. Nuuni beele waha no lena, fai waha no umonbona. Taate bona, no lewaiha, ‘Ji Itou nomo idau.’” ");
INSERT INTO eri_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ono wanenga, Pailot no beele waha isidu bona, no umuge dewai. ");
INSERT INTO eri_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Onodu bona, no ege gidu gabman nomo mata huwanya langa goidu bona, Yesus benou isoki tuwai, “Ne matane adiha?” Ono wainga, Yesus no beele ete ege gidu letuwei uwa. ");
INSERT INTO eri_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ono wainga, Pailot no letuwai, “Adadu ne yame beele ege gidu lehiyei nomo edo uwa yo? Ji ne awa hinehenga goyei nomo fere, ji danga waha bagu. Ji ne nauge abalakawou langa tutui la narei nomo fere, ji danga waha bagu. Ne waha boni ada isini rute?” ");
INSERT INTO eri_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ono wainga, Yesus no beele ege gidu benou letuwai, “Itou ouwe la, no ne danga hinei uwa wage wa, wa ne ji ilei hiyei nomo danga edo uwa. Onou waha bona, fai no ji ne owone langa tafa hiyaha waha, fai waha nomo une wa, ne name une feiya tudu gai anyakaro.” ");
INSERT INTO eri_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ono wainga, Pailot no beele waha isidu bona, no Yesus awa tuwonga goyei nomo bona jala kuruwai. Ono gainga, nere Juda ege benou yaurane, “Ne fai wa, awa tuwahenga, goi bona wonga, ne Sisa nomo ilibumu uwa. Fai no nogo bona lena, ji king iina wa, no Sisa nomo honggoro fai.” ");
INSERT INTO eri_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ono wanenga, Pailot no beele waha isidu bona, no Yesus haudu, malala langa togoyai. Onodu bona, no jas nomo sia langa yafai. Haumu waha nere lede, Plua Megebu. Hibru beele langa, nere Gabata iide. ");
INSERT INTO eri_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Fati waha no Itou Israel Awa Nigainga Hilobainga Yafane Waha, Nomo Fati Anyakaro waha Isei Nomo bona, da dada haiyawei nomo fati. Wa, hoonga ago 12-kilok onou, Pailot no nere Juda lenigai, “Tere tebere king uragu!” ");
INSERT INTO eri_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ono wainga, nere benou yaurane, “Haudu goyau! Haudu goi nauge abalakawou langa tutui la warau!” Ono wanenga, Pailot no nere isoki nigai, “Tere gauya wa, ji tere tebere king nauge abalakawou langa, tutui la wari tagoni yo?” Ono wainga, nere Pris aroro, nere beele ege gidu benou letuwane, “Ere king ete uwau. Sisa no nogonga!” ");
INSERT INTO eri_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ono wanenga, Pailot no nere edo, no nauge abalakawou langa, tutui la warei nomo bona, no Yesus nere owonege langa tafai. ");
INSERT INTO eri_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ariya, Yesus no nogo nomo nauge abalakawou aulainga nere haudu bode goyane. No taon waha awadu bona, oula mutu ete nere lede, Mora Nomo Ngedo iide, walanga goyai. Hibru nebere beele langa, nere Golgata iide. ");
INSERT INTO eri_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Haumu waha langa, nere no nauge abalakawou langa, tofiye tuwane. Onodu bode, nere fai nga fere no bagu tofiye nirane. Ete ulate langa, ete ulate langa. Ono garenga, Yesus no gamanere la inyai. ");
INSERT INTO eri_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Onodu fere, Pailot o lewainga, nere beele ete yeregedu bode, nauge abalakawou ouwe langa tafane. Beele yeregane waha no benou: “Yesus Nasaretha, Juda nebere king.” ");
INSERT INTO eri_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pailat no beele waha, Hibru beele langa, Rom beele langa, Grik beele langa yeregei nomo lenigai. Haumu nere Yesus nauge abalakawou langa tofiye tuwane wa, no taon jugunaga la. Onou bona, nere Juda baingaro, mai uredu bode beele waha lelegane. ");
INSERT INTO eri_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Onou bona, nere Juda nebere Pris aroro, nere Pailot benou letuwane, “Ne onou adai yeregau. Juda nebere kingwou. Ne beele benou yeregau, ‘Fai beha no lewaha, “Ji Juda nebere kingwou.” ’” ");
INSERT INTO eri_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ono wanenga, Pailot no nere lenigai, “ono urona. Beele ji amina yeregenaha onou edo inyona.” ");
INSERT INTO eri_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ariya, oota fai nere Yesus nauge abalakawou langa, tutui la wari borodu, iinga nere nomo kolos elegedu bode, matau aise langa korai wane. Onodu bode, oota fai nere matau etenga-etenga elegane. Onodu, nere nomo siot fere tedu bode urane wa, nere ogola majigau baingaro la, siot waha atei nomo bode erere wegu uwa. Nere ogola etenga langa atane. Siot waha no ererewou uwau. ");
INSERT INTO eri_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Onou waha bona, nere oota fai, nere benou lewane, “Ere siot beha ada korai woya. Ere faiwe no amugedu siot tona waha boya, tuntani aya woboya.” Ariya nere onou ono wane wa, fanyimu waha langa nere Itou nomo beele ete buk langa inyina waha edomu wane: “Beele waha no benou, nere yame kolos dada wesedu bode elegane. Onodu bode, nere fai hangada tuwogunga yame siot tei nomo bona, nere tuntani ayawane.” Nere oota fai we, nere fanyimu waha ono wane. ");
INSERT INTO eri_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ono ganenga, Yesus nomo anya, nomo bemu, Klopas oya Maria, Maria Makdala toanha, nere aita waha nere Yesus nomo nauge abalakawou hinemu langa otawane. ");
INSERT INTO eri_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ono ganenga, Yesus no nomo anya, disaipel ete no gaude tugai waha ngare, hinemu langa oto garenga nerirai. Onodu bona, Yesus no nomo anya benou letuwai, “Aita, fai beha no ne name idate.” ");
INSERT INTO eri_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Onodu bona, no disaipel, waha benou letuwai, “Aita beha waha, ne name anyane.” Ono wainga, saini waha langa hugu waridu, disaipel waha no Maria hawainga, nomo mata langa goidu bodere walanga oofa tugainga yafai. ");
INSERT INTO eri_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ariya, Yesus no isai, elebe no nomo haruwe oruwa usuna. Onou bona, no benou lewai, “Ji yaage nyomoli hina.” No beele waha ledu bona, beele ete Itou nomo buk langa inyina waha edomuwai. ");
INSERT INTO eri_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ariya tauwe ete wain yaage bagu jugu wanga inyai. Onou waha bode, nere spons ete tedu bode, wain waha langa kobomudu bode, hisop nauge nomo dumuga ete, nomo mutu langa dagedu bode, Yesus hurau langa tafane. ");
INSERT INTO eri_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ono wanenga, Yesus no wain waha nyi borodu bona, no lewai, “Elebe usuwaha.” No onou lebonanga, du turigedu nomo hauri awainga goyai. ");
INSERT INTO eri_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ariya fati waha, no bori nomo dada haiyawei nomo fati. Bori nomo fati waha no fati anyakaro tigini. Onou waha bode, Juda nere fai waha genege gala fati waha langa, gai nauge abalakawou langa inyei nomo bode nere awane. Onodu bode nere goi, Pailot nere fai nauge abalakawou langa inyide waha, afenege kokoru nagonga, fasadu umei nomo bode letuwane. Ono wonga, nere genege gala fasadu elegei nomo bona. ");
INSERT INTO eri_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ono wanenga, nere oota fai goidu bode, nere fai nga nononga nere nauge abalakawou langa, Yesus ngate gaara tutui langa narirane waha, afenere kokoru narane. ");
INSERT INTO eri_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Onodu bode, saini nere Yesus bagu maidu bode urane wa, no amina umai. Ono wainga, nere no afo kokoru fuwegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ono wane wa, oota fai ete no ganya langa, Yesus nomo jagirou la joruwai. Ono wainga, fasayadu nomo ganemu, yaage bagu feuwai. ");
INSERT INTO eri_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ariya, fai no dada urai waha bona beele amina malalamudu lewai. Onou waha bona, beele no malalamudu lewai wa, ngalenga. No nogo isina, wa ngalenga beele. Onou waha bona, tere edo huwanyatege ngalengawou. ");
INSERT INTO eri_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nere dada beha ono wainga, beele ete Itou nomo buk langa inyina waha, tigini heigai. Beele waha benou. “Nere no ngedemu ete ada koum fuwode.” ");
INSERT INTO eri_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ariya, beele ete, Itou nomo buk langa inyina wa benou. “Nere fai joru tuwane waha bode feele wodbode.” ");
INSERT INTO eri_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ariya, iinga Josep Arimateaha, no Yesus gogala tei nomo bona Pailot isoki tuwai. Josep, no Yesus nomo disaipel ete, ariya, no nere Juda umuge nigidu bona, no nomo huwanya ngalengawou waha, huwarimuwai. Ariya Pailot no edo tuwainga, no manidu bona Yesus gogala tai. ");
INSERT INTO eri_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ono gainga, Nikodemus fai no waha ngasunga ooru la mai Yesus urai waha, no fere mayai. No sanda ila agiya hilobainga, nere nauge nga nomo gaao, waha elegedu ubulumu wane waha, elegedu tamayai. Sanda waha nomo ou 30 kilogram onou. ");
INSERT INTO eri_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ono wainga, Josep Nikodemus ngare nere, Yesus gogala tedu bodere, sanda waha Yesus gogala la wari fuware, onodu ogola hilobainga la ngara tuware. Wa nere Juda fai ume gane, nebere genege gala la onode onounga onoware. ");
INSERT INTO eri_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Haumu nere oota fai Yesus nauge abalakawou langa, tofiye tuwane waha jugunga la, haga ete inyai. Onowai wa, haga waha langa, matmat eege ete inyai. Nere matmat waha langa, fai ete walanga u-u tanegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Fati waha nere Juda, nebere bori bode dada haiyawei nomo fati. Ariya, matmat waha no jugunga inyai. Onou waha bodere, nere Yesus nomo gogala auledu goi, u-u walanga tani tuware. ");
INSERT INTO eri_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ariya fati amugou, Bori eringe hamba dewei uwa, agugu oruwa Maria Makdalaha, no matmat langa goyai. No goidu bona, matmat langa megebu ete u-u hao sesemu wane waha, isebuwou inyi gainga urai. ");
INSERT INTO eri_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Onodu bona, no ege guriyedu goi Saimon Pita, disaipel ete, Yesus no gaude tugai waha ngare benou lenirai, “Nere Anyakaro nomo gogala matmat langaha tane. Onodu bode, nere alanga tafane waha, ere ada isiya.” ");
INSERT INTO eri_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ono wainga, Pita no Yesus nomo disaipel waha ngare, nere matane awadu bodere, matmat langa goyare. ");
INSERT INTO eri_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nere gaara gurarudu goi bodere, Yesus nomo disaipel ete wa, no ilibumu Pita feiya tudu bona, no amugedu goi matmat langa heigai. ");
INSERT INTO eri_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Onodu bona no oogudu, matmat huwanya langa feeledu bona, ogola hilobainga nere Yesus gogala ngara wane wahanga inyi gainga urai. Onowai wa, no huwanya goyei uwa. ");
INSERT INTO eri_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ono gainga Saimon Pita no iinga huunta maidu bona, no tigininga matmat u-u gamu goyai. No goidu bona, ogola inyi gainga urai. ");
INSERT INTO eri_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Onodu bona, no ogola ete nere Yesus mora langa dage fuwane waha, ila inyane waha bagu, arotenga inyigane urei uwa. Ogola waha no nogo fere, fai olilidu fere tafou dorofe inyi gainga urai. ");
INSERT INTO eri_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ono wainga, Yesus nomo disaipel ete, no amugedu bona matmat langa goi heigai waha, no fere matmat u-u gamu la goyai. No goidu bona, dada waha nerigedu bona, no huwanya ngalengawai. ");
INSERT INTO eri_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ariya, saini waha langa, nere beele Itou nomo buk langa inyina waha, nere foode nigei uwa. Wa Yesus no matmat langa ege gidu jayonbona waha. ");
INSERT INTO eri_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Onodu, nere disaipel nga wa, ege gidu matane goyare. ");
INSERT INTO eri_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ariya, Maria no matmat u-u waha hinomu langa mere bona, malala langa otowai. No onou merenga bona oogudu, matmat u-u gamu langa feelewai. ");
INSERT INTO eri_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Onodu bona, no ensel nganononga kolos kaamba bagu, Yesus nomo gogala amina inyai waha langa yafagare nerirai. Ete, no haumu mora inyai waha langa yafai. Ete, no haumu afo inyai waha langa yafai. ");
INSERT INTO eri_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Onodu bodere, nere Maria benou isoki tuware, “Aita, ne taate boni mereni?” Ono warenga no lenirai, “Nere yame Anyakaro taane. Nere tedu alanga tafa tuwane waha, ji alai uwa,” nirai. ");
INSERT INTO eri_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","No onou lenirisu bona, no ubuludu, Yesus oto gainga urai. Onowai wa, Maria no wa Yesus iiwou, no alai uwa. ");
INSERT INTO eri_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ono wainga, Yesus no benou isoki tuwai, “Aita, ne taate boni mereni? Ne faiwe kuruni?” Ono wainga, Maria no ninau isai, no haga beha oofagou fai iiwai. Onodu bona, no letuwai, “Fai anyakaro, ne tedu togoi haumu alanga tafa tunaha wonga, ne ji lehiyahenga, ji goidu no tonboni.” ");
INSERT INTO eri_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ono wainga, Yesus no lewai, “Maria.” Ono wainga, Maria no ubuludu, Hibru beele langa benou letuwai, “Rabonai”. Beele “Rabonai” wa, “Isisi higigou fai.” ");
INSERT INTO eri_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ono wainga, Yesus no benou letuwai, “Ne ji adai yaasu hiyau, taate bona, ji ouwe la yame Jijei bagu manei uwa inyina. Ariya ne yame baabo gane bagu goidu bonahe, benou lenigau, ji ouwe langa manon boni, ji yame Jijei bagu tebere ametege bagu la manini. Onodu ji yame Itou bagu, tebere Itou bagu la manini.” ");
INSERT INTO eri_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ono wainga, Maria Makdalaha no goidu bona, nere Yesus nomo disaipel benou lenigai, “Ji Anyakaro amina urenaha,” nigai. Onodu bona, beele Yesus no tuwai waha, no nere lenigai. ");
INSERT INTO eri_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ariya bori nomo fati amugou langa, esuwa hoonga mini gainga, nere Yesus nomo disaipel, nere Juda umuge nigidu bode, mata nere oruwa komodu yafane waha, nomo jauli arasai sesemudu bode, lok katamu wane. Onodu yafa gane, Yesus no nere gamanege langa heigedu otowai. Ono bona, no nere benou lenigai, “Tere tebere huwanyatege edo foinga inyou.” ");
INSERT INTO eri_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","No nere onou lenigidu bona, no owo jagirou bagu abitimu nigai. Ono wainga, nere disaipel Anyakaro uredu bode, nere huwanyanege edegawai. ");
INSERT INTO eri_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ono wanenga, Yesus no nere ege lenigai, “Tere tebere huwanyatege edo foinga inyou. Jijei, no ji huuru hiyanga menaha. Onounga, ji fere tere huuru tigehenga goyagu ganga.” ");
INSERT INTO eri_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","No onou lenigi bona, no nomo hao hauri nere langa fuu wainga goyai. Ono bona lenigai, “Tere Hauri Guuni taagu. ");
INSERT INTO eri_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Onou wa, tere fai nebere une uulu nagagu wa, nere nebere une usu wonbona. Ariya, tere fai nebere une ada uulu nagagu wa, nere nebere une gai inyonbona.” ");
INSERT INTO eri_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ariya saini, Yesus no nere disaipel bagu heigai waha langa, nere disaipel 12 waha nebereha ete, no nere bagu walanga yafei uwa. Wa Tomas, nomo unyi ete wa Didimus. ");
INSERT INTO eri_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Onowai wa, nere disaipel ila, nere no letuwane, “Ere Anyakaro amina ureyaha!” Ono wanenga, Tomas no nere benou lenigai: “Ji no nomo owo tutui langa warane haumu waha ada ure boni, ji yame owofe jirou huuru wehenga, tutui warou haumu langa ada goi bona, ji owofe huuru wehenga, nomo jagirou langa ada goi bona wonga, ji huwanyafe ada ngalenga wona. Gai uwanga uwa.” ");
INSERT INTO eri_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ono wainga, iinga fati 7 usu wainga, Yesus nomo disaipel nere ege mata waha huwanya langa yafane. Ariya, saini waha langa, Tomas, no fere nere gaara yafane. Nere jauli arasai oruwa sesemudu bode, lok katamu bore wane inyi gainga, Yesus no maidu nere gamanege langa otowai. Ono bona lenigai, “Tebere huwanyatege edo foinga inyou.” ");
INSERT INTO eri_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Onodu bona, no Tomas benou letuwai, “Ne maidu ne name owone jirou belanga tafadu bonahe, ji owofe urau. Onodu bonahe, ne name owone jirou huuru wahenga tigini jagirofe langa mayou. Onodu ne huwanyate ngalengawou nga bagu adaiwou. Ne huwanyate ngalengawou.” ");
INSERT INTO eri_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ono wainga, Tomas no beele ege gidu benou letuwai, “Ne yame Anyakaro, Ne yame Itou!” ");
INSERT INTO eri_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ono wainga, Yesus no benou letuwai, “Ne ji yeriyenaha bona, huwanyate ngalengana yo? Nere fai ji yeriyegu uwa langa, huwanyanege ngalengade waha, nere fai waha edo edega wode.” ");
INSERT INTO eri_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ariya, Yesus no dodokawou naani ila bagu baingaro, nere disaipel agenege langa tafai. Onowai wa, ji waha oruwanga buk beha langa yeregei uwa. ");
INSERT INTO eri_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Onou wa, beele ji yeregeni beha, tere Yesus no fai waha Itou nomo fai-aita bagu ege gidu hanigei nomo hangada tuwai waha bonade huwanyatege edo galenga wonbona. No Itou Idau. Onou waha bona tere huwanyatege ngalenga wonga wa, tere no nomo unyi langa, agetege auma taagu ganga. ");
INSERT INTO eri_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ariya iinga gainga, Yesus no ege Galili yaage katiwou jugunga la, nomo disaipel bagu heigai, yaage katiwou waha nomo unyi ete Taiberias. Ariya, no nogo bona abitimuwou nere beha bagu heigai. ");
INSERT INTO eri_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita wainga, Tomas, nomo unyi ete Didimus, no wainga, Nataniel, no kana taon Galili langa, Sebedi idau gane nga wainga, Yesus nomo disaipel nga, nere walanga gaara yafane. ");
INSERT INTO eri_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ono ganenga Saimon Pita no benou lenigai, “Ji goi hoowe kuru wonboni.” Ono wainga, nere letuwane, “Ere fere ne ngate gaara goyei nomo.” Onodu, nere bot ete digedu bode goyane. Ariya, ooru waha langa, nere hoowe ete tegu uwa. ");
INSERT INTO eri_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hamba oruwa hoonga mayona ono gainga, Yesus no laanga la oto gainga urane. Ariya disaipel nere no Yesus wou nere alai uwa. ");
INSERT INTO eri_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ono wanenga, Yesus no benou isoki nigai, “Yame magana gane, tere hoowe ila bagu yo?” Ono wainga, nere letuwane, “Uwae.” ");
INSERT INTO eri_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ono wanenga no lenigai, “Tere hagoma waaga ulate owotege hilou langa aya wagu, onodu bonade, tere ila elegagu ganga.” Ono wainga, nere hagoma aya wanenga minainga, nere hoowe baingaro elegane, nere hagoma waha kuse wogunga ouwe mayei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Saini waha langa Saimon Pita no nomo saket uuludu haruwe te gainga, Yesus no disaipel gaude tuna waha, Pita letuwai, “Be Anyakaro wenga.” Saini no beele “Be Anyakaro,” waha isidu bona, no ege nomo saket te tanidu, yaage langa talagedu minidu bona, logadu laanga la minai. ");
INSERT INTO eri_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ono gainga, nere disaipel ila, bot langa maidu bode, hagoma hoowe bagu guse wanenga mayai. Nere laanga ulisi baae langa oto wegu uwa. Nere 100 mita onou otowane. ");
INSERT INTO eri_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Onodu nere me horiyedu bode, eeya ete inyi gainga urane. Eeya walanga, hoowe ete inyai, ono gainga bret ete fere wanga inyi gainga urane. ");
INSERT INTO eri_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ono wanenga, Yesus no lenigai, “Hoowe tere elebe elegeyaha waha, ila elege tamayagu.” ");
INSERT INTO eri_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ono wainga, Saimon Pita no bot langa talagedu bona, hagoma kuse wainga, ulisi ouwe langa mayai. Nere hoowe aroro wa hagoma langa bolowane nebere lelegei nigou wa, 153 oruwa. Nere hoowe baingaro, ariya hagoma koraiwei uwa. ");
INSERT INTO eri_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ono wanenga, Yesus no benou lenigai, “Tere maidu nyagu.” Ono wainga, disaipel nere umugane, nebereha ete no benou isoki tuwei uwa, “Ne faiwei?” Nere amina isane, no anyakaro wenga. ");
INSERT INTO eri_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ono wanenga, Yesus no eeya hinemu la goidu, bret tedu bona nigai. Onodu hoowe fere tedu nigai. ");
INSERT INTO eri_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Beha waha, Yesus no matmat langa ege jaidu nere disaipel bagu heige eeiwai. ");
INSERT INTO eri_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ariya, Yesus no nomo disaipel gane bagu da nyi borodu, no Saimon Pita benou isoki tuwai, “Saimon, Jon idau, ne ji gaude hini waha, ne name gauwou nere fai woha nebere gauwou feiya nigou yo?” Ono wainga Pita no letuwai, “Yo, Anyakaro, ne isini, ji ne gau hinini.” Ono wainga, Yesus no letuwai, “Ne yame sipsip magana da dada langa, oofa nigi hayau.” ");
INSERT INTO eri_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Onodu bona, Yesus no ege isoki tu ngawai, “Saimon, Jon idau, ne ji gau hini yo, uwa?” Ono wainga, Pita no letuwai, “Yo, Anyakaro, ne isini, ji ne gau hinini,” Ono wainga Yesus no letuwai, “Ne yame sipsip da dada langa oofa nigi hayau.” ");
INSERT INTO eri_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Onodu bona, Yesus no ege isoki tu eeiwai, “Saimon, Jon idau, ne ji gau hini yo?” Ono wainga, Pita no Yesus isoki eei tuwai, “Ne ji gau hini yo?” Waha bona huwanya ouwai. Onodu bona, no Yesus benou letuwai, “Anyakaro, ne dada oruwa bona isini. Ji ne gau hinini waha ne isini.” Ono wainga, Yesus no letuwai, “Ne yame sipsip da dada langa oofa nigi hayau.” ");
INSERT INTO eri_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Ji ne ngalenga lehinini, saini ne giila yafa boni, ne nage name leeti tagudu boni, ne haumu goyau ganga langa goi-goini. Ariya saini, ne umuradu bonahe, ne owone isou gahenga, fai ete we ne leeti tagumu hinidu bona, no hainedu, haumu ne goyei nomo awani waha langa, hainedu goyon bona.” ");
INSERT INTO eri_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus, no beele lewai beha, no iinga gonga Pita no fanyimu adeha la umedu bona, Itou unyi isou wonbona waha isisiwai. Onodu bona, iinga no Pita letuwai, “Ne ji oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ariya, Pita no ubuludu bona disaipel, Yesus no gaude tuna waha, nere oojo niridu mai gainga urai. Fai no waha amina nere da nyi bode, no oogoudu bona mora Yesus bura hinemu la tafadu isoki tuwai, “Anyakaro, faiwei no ne honggoro fai owonege la tafa hinon bona?” ");
INSERT INTO eri_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ono wainga, Pita no fai waha uredu bona, Yesus isoki tuwai, “Anyakaro, fai beha no adadu?” ");
INSERT INTO eri_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ono wainga, Yesus no beele ege gidu benou letuwai, “Ji benou gau boni wonga, no edo yafa gonga goi saini ji ege gidu mayon boni, wa ne name dada yo? Ne oojo hiyau.” ");
INSERT INTO eri_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ono wainga, beele no bemu gane langa, benou golowai, “Disaipel waha no ada umonbona.” Ariya, Yesus no disaipel waha ada umonawou beele waha lewei uwa. No lewai, “Ji gau boni wonga, no gai yafa gonga ji ege gidu mayonboni, wa ne name dada, yo?” ");
INSERT INTO eri_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Disaipel no wahanga, elebe no dada waha bona beele malalamudu lebona, beele beha yeregena. Ariya ere isiya, beele no lena waha, beele ngalenga. ");
INSERT INTO eri_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ariya, Yesus no dada baingaro ila fere onowai. Onowai waha, nere buk langa beele dada etenga-etenga waha oruwa bode yeregage wa, ere ebere oula beha, ere buk waha logosiwei nomo haumu edo ada wage rute. ");
INSERT INTO eri_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiofilas, ji buk beha la amina yeregene, ji beele yeregene waha, dada oruwanga Yesus no onowai, no fai-aita bagu isisiwou oruwanga nigai, gai amina langa ");
INSERT INTO eri_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mai fati Itou no Yesus haudu ha laluwa la manai waha langa edowai. Dada waha no aposel hangada nigai langa heigai, onodu Hauri Guuni nomo danga la nere haruwe hugu fere-fere todbode lenigai. Onodu iinga huunta langa Itou no haudu ouwe la manai. ");
INSERT INTO eri_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ngasunga no jimiri tedu bona umedu, iinga no ege ago auma tedu, aposel bagu heigai. Onodu no ago auma yafana waha isi dewei nomo bona, dada baingaro onowai. Fati 40 oruwanga nere no urane, ono wanenga, no Itou nomo huuna langa yafou waha bona lenigai. ");
INSERT INTO eri_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Saini no nere bagu yafa bona, no benou lenigai, “Tere Jerusalem adai awa tuwagu. Dada Jijei no tere tigonbona lewai waha itari wagu, amina ji letigene waha. ");
INSERT INTO eri_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon no fai-aita bagu yaage langa yaage bisemu nigai. Ariya, elebe tere Hauri Guuni langa yaage bisou taagu ganga fati bainga inyei uwa.” ");
INSERT INTO eri_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Saini waha langa aposel nere arotenga komodu bode isoki tuwane, “Anyakaro, ne elebe saini beha langa, ne kantri Israel ono tuwahenga ege danga bagu heigonga, king no oofa tuwon bona yo uwa?” ");
INSERT INTO eri_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ono wanenga nebere beele benou gidu lenigai, “Jijei no saini bagu fati bagu hangadawai wa, tebere isei nomo dada uwa. No nogo dada waha oofana. ");
INSERT INTO eri_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Waha bona, iinga Hauri Guuni no medu tere langa yafa gonga, tere danga taagu ganga. Onodu Jerusalem langa, Judia nebere haumu oruwa langa, Samaria distrik langa, ji yame beele malalamudu lebonade goi ha-ha oruwa langa edomu wagu ganga.” ");
INSERT INTO eri_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesus no beele waha lenigi boro wainga, nere feele tudu oto ganenga, no ha laluwa langa manai. Ono gainga agau ete maidu kutau tuwainga, nere ege uregu uwa. ");
INSERT INTO eri_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","No mani faga gainga, nere gai onounga taene igei tudu oto ganenga, fai nga nere kolos kaamba bagu fasadu onou maidu nere gamanege langa oto ware. ");
INSERT INTO eri_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nere oto bodere leware, “Tere Galili fai, tere taate boya ewe onou taene igei tuyaha otoya? Yesus no, elebe Itou no hawanga tere awa tigidu ha laluwa langa manaha, elebe tere ure geinga no ha laluwa langa manaha, onowou wahanga la no ege gidu monbona.” ");
INSERT INTO eri_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ariya, aposel nere Oliv muju awadu, ege gidu Jerusalem goyane. Oliv muju waha no Jerusalem jugunga, no kilomita etenga onou. ");
INSERT INTO eri_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nere taon huwanya goidu, jauli ouwe langa, nere yafa yafade langa manane. Nere unyinege benou, Pita, Jon, Jems, Andru, Filip, Tomas, Batolomyu, Matiu, Jems Alfius idau, Saimon no Selotha fai ete, Judas Jems idau. ");
INSERT INTO eri_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nere fai beha oruwanga huwanyanege etengadu yafabode, komodu hauya hauyade. Ariya nere aita ila bagu, Yesus anya Maria, nere Yesus bemu gane, nere fere mai ganenga gaara hauya-hauyade. ");
INSERT INTO eri_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Saini waha langa, nere Yesus bode huwanyanege ngalengawou fai-aita bagu 120 oruwa. Ariya, Pita no nere gama langa jaidu beele benou malalamudu lewai, ");
INSERT INTO eri_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Yame baabo gane, amina Hauri Guuni no Devit ono tuwainga, no hurau langa beele ete benou heigemuwai, beele waha no Itou nomo buk langa inyina. No Judas bona lena, fai waha no fai nere Yesus yaasu tuwei nomo jala abitimu nigai. Ono wane waha, elebe Devit no lewai onou heigaha. ");
INSERT INTO eri_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Amina Judas no ere ngate golo geye. No haruwe ere teya benounga no tegai.” ");
INSERT INTO eri_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas, fai waha no moni waha, nomo onowou inyaba waha agou dorofe tai, onodu oula matau ete ejiyawai. Iinga no oula waha langa mebodudu hu ogou fuduwai. Ono wainga, hu anya oruwa oula la feuwai. ");
INSERT INTO eri_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ono wainga, iinga fai oruwanga Jerusalem langa yafane waha nere isane. Onodu nebere beele langa oula waha Akeldama ide. Unyi “Akeldama,” nomo hugu Oula Ganemu Bagu. ");
INSERT INTO eri_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ariya, Pita no ege benou lewai, “Beele beha Devit nomo Buk Song langa yeregane waha benou, ‘Haumu no yafai waha, edo ewe inyonbona. Ne fai ete te awa tuwahenga adai yafou.’ Ono ganga, buk waha nomo ulate langa no beele benou bagu, ‘No nomo haruwe waha fai ete edo tonbona.’ ");
INSERT INTO eri_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Waha boya, ere elebe Anyakaro Yesus no saini oruwanga ere ngate goigoi maimai gainga, fai nere ere gaara gologeye waha gamanege langa ete hangada tuwei nomo. ");
INSERT INTO eri_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Saini Jon no fai-aita bagu yaage bisemu nigou haruwe tegainga, Yesus no nomo haruwe hugu waridu mai fati Itou no Yesus hawainga ere awa higidu ha laluwa langa manai waha langa edowai. Ere fai no dada waha oruwanga urai waha hangada tuwedenga, no ere ngate gaara haruwe tebona, Yesus no gidu jayai waha bona beele malalamudu lewonbona.” ");
INSERT INTO eri_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita no onou lewainga, nere fai nga nononga hangada nirane. Fai ete no Josep, nere lede Barsabas, nomo unyi ete fere Jastus. Ariya, fai ete no Matias. ");
INSERT INTO eri_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Onodu nere benou hauya wane, “Anyakaro, fai oruwa nebere huwanyanege ne isini. Ne edo abitimu higau, ne faiwei tigini nere fai nga beha gama langa hangada tuwene, ");
INSERT INTO eri_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","no aposel heigedu Judas nomo haumu tonbona. Judas no haruwe beha awadu, no gai onou yafei nomo haumu waha langa goyai.” ");
INSERT INTO eri_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Onodu nere faiwei tigini haruwe beha teinomo bode, megebu ayaru wane, ono wanenga, Matias nomo megebu no heigai. Waha bode nere no aposel 11 waha bagu tafa tuwane. ");
INSERT INTO eri_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos Nomo Fati Anyakaro heigainga, fai-aita bagu Yesus bode huwanyanege ngalengawou waha mata ete langa arotenga komo wane. ");
INSERT INTO eri_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ono ganenga, fasadu onou bolou ete ha laluwa langa mai, no jagui danga bagu bolou dorofe, mata nere yafane waha langa bolowai. ");
INSERT INTO eri_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Onodu eeya dada dorofe heige gainga urane, nomo urou wa fai munyanege baingaro dorofe. Onodu munyanege waha fere-fere goidu nere oruwa langa yafane. ");
INSERT INTO eri_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ono wainga, Hauri Guuni fai-aita bagu waha oruwanga la bolo wainga, nebere beele langa beele hogo fere-fere lewou hugu warane. Hauri Guuni no ono wainga nere beele waha lewei nomo edo. ");
INSERT INTO eri_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Juda ila mai Jerusalem langa yafane, nere Itou unyi isougou fai, nere oula beha nomo kantri oruwa langa mayane. ");
INSERT INTO eri_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Saini bolou beha heigainga, fai-aita bagu baingaro isidu mai komo wane. Onodu fai-aita bagu Yesus bode huwanyanege ngalenga wane waha, beele leganenga agenege kuli tafane, onodu horoto wane, taate bona, nere fai-aita bagu etenga-etenga no nomo beele tigini legainga aagu wane. ");
INSERT INTO eri_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Onodu nere Juda waha horotodu bode lewane, “Nere fai-aita bagu beha oruwanga Galiliha rute. ");
INSERT INTO eri_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Adadu waha, ere etenga-etenga oruwanga, ere ebere beele tigini langa, beele leganenga isiya? ");
INSERT INTO eri_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ere fai kantri Partia bagu Midia bagu Elam bagu, ere fai Mesopotemia distrik langa yafaya waha bagu, Judia distrik bagu, Kapadosia prowins bagu, Pontus prowins bagu, Esia bagu, ");
INSERT INTO eri_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia distrik bagu, Pamfilia distrik bagu, onodu kantri Isip bagu, Libia distrik nebere ulate Sairini taon hinemu langa yafade bagu, ere kantri Romha fai belanga mayei yafaya waha. ");
INSERT INTO eri_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ere Juda bagu fai fereha bagu ebere bori taga tuweye, onodu ere Krit nuuyaha distrik Arebiaha fai bagu, nere nebere beele malalamudu lewane wa, Itou nomo haruwe danga bagu ebere beele langa leganenga ere oruwanga iseye.” ");
INSERT INTO eri_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Onodu nere oruwa horotodu, ninanege baingaro isane. Onodu nere nage-nage benou leguru wane, “Dada elebe heigaha beha, wa taate dada tigini?” ");
INSERT INTO eri_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ono wanenga, nere ila memesi beele benou lewane, “Nere wain auma baingaro nyidu sipak wane.” ");
INSERT INTO eri_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ariya Pita no aposel 11 waha bagu oto bode, inyangaro yauredu fai-aita bagu benou lenigai, “Tere Juda bagu, tere fai oruwanga maiyaha Jerusalem langa yafaya waha agetege kuli tafadu yame beele aagu wagu, onodu dada elebe ureya beha nomo hugu bonade isagu ganga. ");
INSERT INTO eri_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tere ninatege benou isiya, nere fai beha sipak wane iya yo? Gai uwanga uwa. Elebe 9 kilok eringe. ");
INSERT INTO eri_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dada elebe heigaha beha, no amina profet Joel no lewai waha. No benou lewai, ");
INSERT INTO eri_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Itou no lewai, “Fati usuwou jugu gonga, ji yame Hauri fai-aita bagu oruwa langa feu wonboni. Ono wehenga, tebere idatege gane magetege gane bagu profet dorofe ji yame beele malalamudu lewodbode. Onodu tere tebere magana giila nere dada wewewou dorofe nerigode bode, ono gogunga umura nere wewe wodbode. ");
INSERT INTO eri_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Saini waha langa, ji yame Hauri yame haruwe magana haruwe aita bagu langa feu wonboni, Ono wehenga, nere profet dorofe yame beele malalamudu lewodbode. ");
INSERT INTO eri_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ariya, Fati waha nomo naani dorofe, ji dada hogo fere ete taene ouwe langa heigemu boni, dodokawou ha esene langa tafonboni. Ganenege bagu eeya bagu buutu anyakaro heigonbona. ");
INSERT INTO eri_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Hoonga no agugu heigonbona, ole no ganenege dorofe giriwou heigonbona. Ono gonga iinga huunta la Anyakaro nomo Fati heigonbona, fati waha Anyakaro no nomo danga anyakaro lala bagu abitimu wonbona. ");
INSERT INTO eri_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Saini waha la fai-aita bagu oruwa Anyakaro hoyo nigei nomo bode yaurodbode, wa no ege gidu hani gonga hilou yafei nomo bode.” ’ Beele beha profet Joel malalamuwai. ");
INSERT INTO eri_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Tere Israel fai, yame beele bonade agetege kuli tafagu. Ji Yesus Nasaretha boni beele letigon boni. Haruwe danga bagu dodokawou hugu fere-fere Itou no tere gama langa fai waha owo langa heigemuwai waha tere tage isiya. Itou no onou onowai waha tere isagu ganga, no nogowe fai waha huuru tuwainga mayai. ");
INSERT INTO eri_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aminanga Itou no ninau isidu, ono wonbona beele baara tawai, onounga no fai waha owotege langa tafai. Onodu fai inyaba owonege langa tere nauge abalakawou langa tutui la waridu dukote weyenga umai. ");
INSERT INTO eri_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ariya Itou no fai waha ege jaimu tuwai, no umou nomo jimiri inyaba langa awa tuwainga inyei uwa, taate bona, umou no fai waha yaasu tuwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Amina Devit fere no bona benou lewai, ‘Saini oruwa Anyakaro no gai ji hinofe langa tigini yafa ganga ure-ureni. No hinofe langa yafa bona, danga hihina, waha bona dada ete te ji ono hiyonga horotodu umugei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Onou waha bona, ji huwanyafe gai hilobainga inyi ganga, ji edegawou beele leni. Itou no dada hilobainga ji langa ono wonbona waha itarini. ");
INSERT INTO eri_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ne ji ada awa hiyahenga umou fai nebere matane langa yafoni. Onodu ne fai ne name boni hangada wene waha awa tuwahenga matmat langa ada isi wonbona. ");
INSERT INTO eri_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ne agege auma yafei nomo jala amina abiti hiyene. Ne awa hiyahenga ji ne ngare yafo boyare, ne ono hiyahe ji gai edega dewonboni.’ Beele beha Devit no malalamudu lewai. ");
INSERT INTO eri_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Oo baabo gane, ji tere ebere asage Devit boni tigini malala fouredu letigonboni. No umainga, u-u tanane. Nomo matmat ere gamage langa inyi ganga mai elebe. ");
INSERT INTO eri_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ariya Devit no profet, waha bona no isai, Itou no ngalenga ouwe langa benou lewai, ‘Huunta la ne name ganeteha, magana ete ono tuwehe ne dorofe king heigonbona.’ ");
INSERT INTO eri_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Waha bona saini Devit no beele beha malalamudu lewai, Itou no fai waha awa tuwonga umou nebere haumu langa ada inyon bona, onodu Itou no awa tuwonga matmat langa ada isi wonbona, no nogo bona lewei uwa. Itou no dada ono wonbona waha Devit no amina isai, onodu no Itou nomo fai-aita bagu gidu hanigei nomo fai hangada tuwai waha no matmat langa ege gidu joyonbona lewai. ");
INSERT INTO eri_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ariya fai waha Yesus, Itou no matmat la amina jaimu tuwai. No iinga ege gidu jayainga ere oruwa ureye, dada ere ureye waha boya ere leleya. ");
INSERT INTO eri_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Onodu Yesus no amina ouwe la manai Itou owo hilou langa yafana. No amina Umamu Hauri Guuni tuwon bona lewai onounga, amina owo langa tai. Elebe tere uredu isiya dorofe no amina feuwai. ");
INSERT INTO eri_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yesus no ha laluwa ouwe la manai dorofe, Devit no manei uwa. Ariya Devit no lewai, ‘Anyakaro no yame Anyakaro benou letuwai, “Ne yame owofe hilou langa yafa gahe goi ");
INSERT INTO eri_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ji ne name honggoro fai name huuna langa logosi nigehe yafode langa edo wonbona.” ’ ");
INSERT INTO eri_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Onou waha bona tere Israel oruwanga benou isagu, Yesus no tere nauge abalakawou tutui langa wareyeha waha, Itou no Anyakaro hangada tuwai yafana, onodu no fai-aita bagu gidu hanigou fai.” ");
INSERT INTO eri_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ariya, fai-aita bagu nere Pita nomo beele isidu bode, beele waha huwanyanege wari dewai. Ono wainga nere Pita, aposel ila bagu isoki nigane, “Oo baabo gane, ere elebe adadu ono woya yo?” ");
INSERT INTO eri_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ono wanenga Pita no benou lenigai, “Tere etenga-etenga oruwa huwanyatege ubuludu bonade, Yesus Kristus nomo unyi langa yaage bisou taagu, ono wadenga Itou no tebere une uulu tagon bona. Tere onou ono wadenga, Itou no Hauri Guuni tigonbona. ");
INSERT INTO eri_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Amina Itou no tere bagu, tebere magana bagu, fai-aita bagu oruwa baae langa yafade waha bagu, Hauri Guuni tigon bona beele baara tawai. Itou, ebere Anyakaro, no fai-aita bagu oruwanga yaure nigina waha Hauri Guuni teinomo beele baara tawai.” ");
INSERT INTO eri_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Onodu Pita no beele ila fere baingaro malalamudu lenigi bona, beele danga bagu benou lenigai, “Ure dewagu. Tere oofa dewagu, gamaji tere fai fanyimu inyaba onode waha bagu, inyaba wagu ganga.” ");
INSERT INTO eri_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita nomo beele waha fai-aita bagu baingaro huwanyanege warainga, yaage bisou taane. Fati waha la fai-aita bagu 3,000 onou, nere fai-aita Yesus bode huwanyanege ngalengawou waha bagu huwanya mayane. ");
INSERT INTO eri_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Fai-aita bagu aposel nebere beele isei nomo, bainege gane hoyo nigei nomo, mai komodu da gaara nyei nomo, hauyawei nomo, danga tafane. ");
INSERT INTO eri_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Itou no aposel owonege langa dodokawou baingaro tafainga, fai-aita bagu oruwanga uredu bode, nere horotodu umugane. ");
INSERT INTO eri_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Fai oruwanga Yesus bode huwanyanege ngalenga wane waha, nere huwanyanege gai etengadu yafane. Onodu nere nebere dada oruwa urane wa, fai-aita bagu Yesus bode huwanyanege ngalengawou waha oruwanga nebere dorofe. ");
INSERT INTO eri_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nere nebere oula matau bagu, nebere dada bagu fai awa nagi ganenga ejiya gane, nere moni waha langa tedu bode, fai oruwanga da dada bode tutu nigai waha wese nagi gane. ");
INSERT INTO eri_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nere fati oruwanga tempel langa komo gane. Onodu nebere mata fere-fere langa da gaara nyigane. Nere huwanyanege hilou inyi gainga, edega bode gaara da nyigane. ");
INSERT INTO eri_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nere Itou unyi gai-gai isou gane, ono ganenga fai-aita bagu oruwanga nere bode huwanyanege hilobainga inyigai. Fati oruwanga Anyakaro no fai-aita bagu ila gidu hanige gai, onowou waha langa, fai-aita bagu Yesus bode huwanyanege ngalengawou waha baingarowai. ");
INSERT INTO eri_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Saini ete hauyawei nomo saini langa, 3 kilok esuwa, Pita no Jon ngare tempel langa manare. ");
INSERT INTO eri_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ono bodere fai ila nere fai ete afo lalekawou haudu mai ganenga nerigare. Fati oruwa nere fai waha auledu haudu tamai tempel waha nomo arasai nere lede Arasai Hilobainga, waha hinemu langa tafa tuganenga yafagai. Ono ganenga no fai-aita bagu tempel jauli goi ganenga moni dada bona malagau nigigai. Fai waha no afo inyaba onou anya huwanya langa heigai. ");
INSERT INTO eri_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Fai waha no Pita Jon ngare tempel huwanya langa goyodere ono garenga nerirai, onodu nere dada ila tuweru nomo isoki nirai. ");
INSERT INTO eri_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ono wainga Pita, Jon ngare danga bagu feele tuware, ono bodere Pita no letuwai, “Ne ere igei hirau.” ");
INSERT INTO eri_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ono wainga fai waha no danga bagu igei nirai, no nere langa dada ila elegon boni iwou isai. ");
INSERT INTO eri_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ono wainga Pita letuwai, “Ji moni uwau. Ariya dada ji langa inyina waha, hinon boni. Yesus Kristus Nasaretha unyi langa ji lehinini, ne jaidu golowau.” ");
INSERT INTO eri_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Onodu Pita no owo hilou la yaasu tudu hoyo tuwainga jayai. Ono wainga fasadu onou afo bagu afo tuburu bagu dangawai. ");
INSERT INTO eri_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ono wainga no talagedu jaidu otodu bona golowai. Onodu no tempel huwanya langa gaara goyane, no golo bona talage-talage bona Itou unyi isouwai. ");
INSERT INTO eri_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Fai-aita bagu oruwanga no Itou unyi isou bona golo gainga urane, ");
INSERT INTO eri_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ono wainga nere isane, fai behanga no saini oruwa tempel arasai nere lede, Arasai Hilobainga, hinemu langa yafa bona moni dada bona yaure nigi-nigina. No hilou wainga uredu bode, nere horotodu, aau togo nagai. ");
INSERT INTO eri_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Fai-aita bagu dada heigai waha bode beele isidu, nere horotodu bode, fai waha urode gurarudu mayane. Onodu fai waha Pita, Jon ngare dobole niridu tempel nomo waranda, nere lede, Solomon nomo waranda, waha langa oto gainga urane. ");
INSERT INTO eri_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita no waha uredu bona, fai-aita bagu benou lenigai, “Tere Israelha fai, tere taate boya dada heigaha beha boya horotoya? Tere taate boya ere danga bagu igei hiriya? Tere benou rute isiya, ere hare eire danga anyakaro, Itou ago langa ere hilobainga yafa yafayare, waha bona ere fai beha jigemu tuyareha golona iiya yo? Gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham nomo Itou, Aisak nomo Itou, Jekop nomo Itou, ere ebere asage gane nebere Itou, no nomo haruwe fai Yesus unyi gai anyakaro tuwaiha. Fai no wahanga tere honggoro fai owonege langa tafa tuweye. Onodu saini Pailot awa tuwona ono wainga, tere Yesus moge tudu boya, Pailot ewe adai awa tuwahe goyona iweye. ");
INSERT INTO eri_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Fai waha no Itou nomo huuna la tigini yafagai. No guuni, no fanyimu oruwanga tigini wahanga onogai, ariya tere no moge tuboya, tere Pailot fai ete no fai dunege kotegou waha awa tuwonga, tere bagu goyei nomo yauredu le tuweye. ");
INSERT INTO eri_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Fai amugou ere haigedu agege auma yafei nomo jala langa goyei nomo waha, tere dukote weyenga umai. Ariya Itou no ege matmat langa jaimu tuwai, ere hare waha urere, waha boyare beele malalamudu leyare. ");
INSERT INTO eri_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ere Yesus boyare huwanyare ngalengawai, Yesus unyi langanga fai tere isi tuya beha, no danga bagu heigaha. Yesus no wenga eire huwanyare ngalengawou jaimu harai, huwanyare ngalengawou waha we fai beha jigemu tu dewaha, waha elebe tere ureya. ");
INSERT INTO eri_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ngalenga, baabo gane, ji isini, tere tebere mora bagu gaara, tere ada isi deya waha boya tere Yesus fanyimu beha ono tuweye. ");
INSERT INTO eri_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ariya Itou no amina profet oruwanga huranege langa beele beha malalamudu lewai, fai beha no nomo fai-aita bagu gidu elegei nomo hangadawou fai, no jimiri aulona bona. Ariya elebe fanyimu waha langa tere onoweye, Itou no nomo beele waha edomuwai. ");
INSERT INTO eri_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Waha bonade, tebere isou inyaba waha awadu, huwanyatege ubulu wagu. Ono wadenga Itou no tebere une uulu tagonbona. ");
INSERT INTO eri_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tere onou ono bonade wonga, Anyakaro no danga eege tigon bona. Onodu fai no amina fai-aita bagu gidu hanigei nomo hangada tuwai waha, huuru tuwonga tere bagu monbona. Fai waha no Itou tere hoyo tigei nomo hangada tuwai, wa Yesus nogonga. ");
INSERT INTO eri_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Elebe no ha laluwa langa yafa bona, Itou dada oruwa eege heigemuwei nomo fati tafai waha itarina, amina la profet huranege langa lewai dorofe, no nogo nomo haruwe te fuwei nomo hangada tuwai. ");
INSERT INTO eri_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Amina Moses no benou lewai, ‘Itou, tebere Anyakaro, no tebere baitege ete hangada tuwonga, no profet ji yage dorofe heigonbona. No beele oruwanga letigonga, tere oojo wagu. ");
INSERT INTO eri_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ariya, fai oruwanga nere profet waha nomo beele isei nomo awa bode wonga, Itou no dunege kote wonga umeru wodbode. Nere ege Israel fai-aita bagu huwanya langa ada yafodbode.’ ");
INSERT INTO eri_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Profet oruwanga nere amina Itou nomo beele malalamudu lewane, profet Samuel langa hugu waridu profet ila iinga no mogo mayane waha, oruwa saini elebe heigaha beha bode lewane. ");
INSERT INTO eri_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Tere profet nebere magana gane yafaya, onodu tere Itou no dada tigei nomo beele baara tawai, saini no asatege gane bagu beele agili mala karu wane waha. No Abraham benou letuwai, ‘Ne name asane idate gane bagu langa fai-aita bagu oula beha nomo oruwanga figini nigonboni.’ ");
INSERT INTO eri_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ariya, Itou no nomo haruwe magana waha jaimu tuwai, onodu amugedu huuru tuwainga tere ladu mai, no tere oruwanga etenga-etenga figini tigi bona hoyo tigonga tebere onowou inyaba awagu ganga bona mai.” ");
INSERT INTO eri_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita no Jon ngare fai-aita bagu gai beele lenigi garenga, pris bagu Sadyusi bagu tempel oofagou nebere kepten bagu mai heigane. ");
INSERT INTO eri_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nere isane, nere fai-aita bagu beele benou malalamudu lenigidere, Yesus no matmat langa amina jayai, fai oruwanga umane fere nere jayode bode. Waha bode, nere bode danga bagu honggorodu ");
INSERT INTO eri_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","nere tatari niridu bode, kot langa tafa nirode ono wane. Ariya, hoonga mini kole wona onowai, ono wainga nere dagou mata langa tafa nirane yafa garenga goi hambawai. ");
INSERT INTO eri_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ono wane wa, fai-aita bagu baingaro nere beele waha amina isidu Yesus bode huwanyanege ngalengawai. Fai‑aita bagu no bode huwanyanege ngalengawai waha, nere 5,000 onou goi edowai. ");
INSERT INTO eri_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Inyiba ete la, Juda nebere fai aroro bagu, nere mora bagu, nuuni beele isou fai bagu, nere Jerusalem langa kotowane. ");
INSERT INTO eri_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pris mora bagu Anas wainga, Kaiafas wainga, Jon wainga, Aleksander wainga, pris mora bagu nere ilibanege gane oruwanga, nere gaara kotowane. ");
INSERT INTO eri_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Onodu Pita, Jon ngare nere agenege langa tafa niranenga oto garenga, benou isoki nirane, “Tere danga adoha tedu boyare, dada waha ono yareha? Tere faiwei unyi langa ono yareha?” ");
INSERT INTO eri_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hauri Guuni Pita huwanya langa bolowai, ono wainga Pita no benou lenigai, “Tere Israel nebere fai aroro, onodu tere mora bagu, ");
INSERT INTO eri_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tere elebe ere fai ete afo inyaba hoyo tuyareha waha boya isoki hiragu ganga onoya rute. Onodu tere waha isagu ganga, fai waha adadu hilou heigaha. ");
INSERT INTO eri_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ariya onou wonga, tere oruwanga isagu ganga, nere Israel fai fere oruwanga isodbode, Yesus Kristus Nasaretha unyi langa, fai afo inyaba beha hilou heigai elebe tere agetege langa otona. Tere Yesus nauge abalakawou langa wareye, ariya Itou no matmat langa ege jaimu tuwai. ");
INSERT INTO eri_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus no ‘megebu kamda tere inyaba idu boya tedu aririmu weye waha. Ariya elebe no megebu hilobainga mata nomo orei dangamuwei nomo heigaha.’ ");
INSERT INTO eri_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Fai ete te no ere ege gidu haigei nomo edo uwa. Yesus no nogonga unyi langa ere oula beha nomo fai-aita bagu oruwanga edo hilou yafei nomo. No nogonga Itou no ere gidu haigei nomo hangada tuwai.” ");
INSERT INTO eri_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Fai araro nere iside, Pita no Jon ngare nere sukul weru uwa. Nere fai ewe. Ariya nere nerirane wa, nere beele danga bagu lebodere nere umugeru uwa, waha bode nere ninanege baingaro isane. Onodu nere isane, amina nere Yesus ngate golo gane. ");
INSERT INTO eri_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Onodu nere fai waha urane, no gogala hilou wainga nere ngate gaara otowane. Waha bode nere beele ete gidu lenirei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Onodu fai aroro nere kaunsel mata awadu malala heigei nomo le nirane. Nere malala goi garenga, nere beele benou ngado wane, ");
INSERT INTO eri_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ere fai nga beha adadu ono nirei nomo? Nere dodokawou ete tafarenga, Jerusalem langa fai-aita bagu oruwanga waha isane. Ere huwarimuwei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ariya gamaji beele beha fai-aita bagu la gai goi baae woga. Waha boya ere beele danga leniroboya, nere ege unyi beha langa fai-aita bagu ila beele ada malalamudu lenigod bodere.” ");
INSERT INTO eri_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ariya nere Pita, Jon ngare yaure niridu, ege Yesus unyi la fai-aita bagu beele ete adai lenigei nomo karu nirane, onodu nere unyi beha fai-aita bagu isisiwou adai nigei nomo lenirane. ");
INSERT INTO eri_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ono wanenga Pita, Jon ngare beele ege gidu benou lenigare, “Tere Itou ago langa onowou adoha waha no tigini iwou isiya? Ere edo Itou nomo beele oojo woyare yo ere tebere beele oojo woboyare? Tere tagewe haawe wagu. ");
INSERT INTO eri_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ariya ere hurare fosokowei nomo edo uwa. Ere dada oruwanga urere, isere waha malalamudu lewoboyare.” ");
INSERT INTO eri_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ono warenga, kaunsel nere ege beele danga bagu ila lenirane onodu awa niranenga haraware, taate bona, nere fai-aita bagu bode umugane. Fai-aita bagu oruwanga dada beha Itou no onowai bode isidu no unyi isouwou haruwe taane. Waha bode fai aroro nere dada ete ono nirei nomo jala uwau. ");
INSERT INTO eri_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Fai nere dodokawou tafadu jigemu tuware waha, no krismas 40 feiyawai. ");
INSERT INTO eri_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kaunsel nere Pita, Jon ngare awa nirane, ono wanenga nere ege gidu neire fai-aita bagu huwanyanege ngalengawou waha bagu goidu, pris aroro bagu nere mora bagu nebere beele oruwanga hai nagare. ");
INSERT INTO eri_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nere isidu bode, nere oruwanga huwanyanege etengadu gaara Itou benou hauya tuwane, “Anyakaro, ne taene oula bagu hiiri bagu dada oruwanga walanga otode waha tafene. ");
INSERT INTO eri_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Amina ne name Hauri Guuni, ebere asage no name haruwe fai, Devit, beele ete letuwai. Ono wainga Devit no benou lewai, ‘Fai-aita bagu oruwanga taate bode danga bagu hounege maina? Nere fai-aita bagu beha taate bode fanyimu inyaba onowei nomo beele ewe ngadode? ");
INSERT INTO eri_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nere ha-ha oruwa nebere king nere warawei nomo haiya wane. Onodu mora araro nere Anyakaro unyi esenemu bode, fai no fai-aita bagu gidu hanigei nomo hangada tuwai waha unyi esenemuwei nomo gaara kotowane.’ ");
INSERT INTO eri_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ngalenga tigini, Herot no Pontius Pailot wainga, nere fai aita fereha bagu, nere Israel bagu, taon beha la Yesus ne nage name haruwe fai, amina ne name haruwe teinomo hangada tuwene waha unyi esenemuwei nomo gaara kotowane. ");
INSERT INTO eri_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Saini nere dada beha ono wane wa, nere name gauwou, ne name ninate wahanga oojo wane. Ne name danga la, dada waha tigini heigonbona amina langa ne beele agili mala karu wene. ");
INSERT INTO eri_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ariya Anyakaro, ne elebe nere beele oruwanga ere umugemu higou lede waha ninate isau ganga, ere ne name haruwe magana hoyo higau. Ono wahenga ere ada umugoya, ere name beele malalamudu lewei nomo danga tafoboya. ");
INSERT INTO eri_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ono bonahe ne edo owone taura fai langa tafahe, nebere taura ege jige nigona, ono bonahe Yesus unyi langa dodokawou hogo fere-fere tafau, wa ne nage name haruwe fai.” ");
INSERT INTO eri_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nere hauya boro wanenga, mata nere komodu yafane waha yokuwai. Ono wainga Hauri Guuni nere langa bolo wainga, nere Itou nomo beele malalamudu lewane. Nere beele danga bagu lebode umugegu uwa. ");
INSERT INTO eri_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Fai-aita bagu oruwanga nere Yesus bode huwanyanege ngalenga wane waha, nere huwanyanege etengadu nebere ninanege etenga inyai. Fai ete te no nomo dada ete uredu bona, no benou lewei uwa, “Dada beha yame tigini.” Uwa. Nere nebere dada oruwanga wa, nere oruwanga nebere. ");
INSERT INTO eri_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposel nere Anyakaro Yesus gidu jayai waha bode beele malalamudu lewou haruwe taane, onodu nere nebere beele no danga anyakaro bagu. Ariya Itou no fai-aita bagu waha hoyo nigei nomo gauwou anyakaro bagu, waha bona no figini de nigai. ");
INSERT INTO eri_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nere fai waha gamanege langa fai ete te, no da dada bona tutu tuwou uwau. Fai oruwanga nere oula bagu, mata bagu, nere fai ila langa huurudu bode waha langa moni elege gane. Onodu moni waha tamaidu, ");
INSERT INTO eri_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposel nigi gane. Ono ganenga aposel nere fai-aita bagu dada bode tutu nigigai waha wese nagi gane. ");
INSERT INTO eri_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ariya fai ete yafai, no unyi Josep. Aposel nere no unyi ete Barnabas tuwane. Unyi Barnabas waha beele beha dorofenga, “Huwanyanege dangamugou fai.” Barnabas no Livai fai ete, onodu no Saiprus nuuyaha. ");
INSERT INTO eri_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","No nomo oula matau ete fai ete langa huuruwai. Onodu moni tai waha, no tamaidu aposel nigai. ");
INSERT INTO eri_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ariya fai ete yafai, unyi Ananaias, nomo woya unyi Safaira. Ananaias no nomo oula matau ulate fai ete langa huuruwai. ");
INSERT INTO eri_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Onodu moni ulate nogo tai, Ananaias no nogo nomo bona tafainga inyai. Woya fere no waha alai. Onodu Ananaias no yaawadu moni oruwanga temou dorofe minidu aposel nigai. ");
INSERT INTO eri_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ono wainga Pita benou letuwai, “Ananaias, ne taate boni Satan awa tunanga huwanyate langa bolo waha, onodu Hauri Guuni yaawa tuwau ganga ononaha, ne name oula matau ulate nomo moni tedu ulate huwarimu naha? ");
INSERT INTO eri_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ne oula waha ne nage name gauwou langa huuru wene. Onodu moni tene waha fere ne name dada, ne taate dada onowau ganga wa edonga. Ne taate boni isou inyaba beha tenaha? Ne fai yaawa nigonboni wahanga iwou adai isau. Uwa. Ne Itou nogo yaawa tuwau ganga ononaha.” ");
INSERT INTO eri_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias no beele waha isidu, metaume bonanga fasadu onou umai. Ono wainga fai nere dada Ananaias langa heigai waha isidu, danga bagu umugane. ");
INSERT INTO eri_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ono wainga magana giila maidu nomo gogala ogola la dagedu bode, auledu togoi u-u kuru wane. ");
INSERT INTO eri_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aua eei usu wainga, Ananaias woya no gamu mayai. No dada nomo au langa heigai waha, no alai uwa. ");
INSERT INTO eri_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ono wainga Pita no benou letuwai, “Ne lehiyau, tere teire oula langa moni teyareha waha behanga yo?” Ono wainga aita letuwai, “Wa tigini. Behanga.” ");
INSERT INTO eri_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ono wainga Pita no benou letuwai, “Tere taate boyare Anyakaro nomo Hauri wala-wala tuwaru ganga beele ngado yareha? Isau. Nere fai name amede u-u kuruwane waha, mata arasai la golo wane gamu maide. Ne fere aule hinidu goyodbode.” ");
INSERT INTO eri_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ono wainga aita waha fasadu onou Pita afo hugu la taumedu umai. Ono wainga magana giila gamu maidu, aita waha umainga urane. Onodu nere auledu togoi nomo au hinemu la u-u kuru wane. ");
INSERT INTO eri_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ono wainga sios nomo fai-aita bagu oruwanga, fai-aita fereha bagu nere dada beha hei gainga beele isane waha, nere danga bagu onou umugane. ");
INSERT INTO eri_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposel nere fai-aita bagu gama la dodokawou hugu fere-fere tafane. Ono wanenga fai-aita bagu oruwanga Anyakaro bode huwanyanege ngalenga wainga, nere huwanyanege etengadu, tempel nomo orei huwanya la goidu, Solomon nomo waranda la komo gane. ");
INSERT INTO eri_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fai-aita bagu nere nebere komowou langa ada yafa gane waha, nere nage unyinege jaimu gane. Ariya fai-aita bagu waha nere umugedu, nere bagu ada goi komo gane. ");
INSERT INTO eri_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Fai-aita bagu baingaro nere Anyakaro bode huwanyanege ngalenga wainga, no nomo komowou langa gamu mayane. ");
INSERT INTO eri_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ariya, Aposel nere dodokawou tafa gane wa, fai-aita bagu nere isi nigi gane. Waha bode fai-aita bagu nere taura fai malala la hanigedu tamai jala Pita golodu mai gai la tagaga yo kabali jala hinemu langa jimadu inyemu nigi gane, taate bona, Pita hoonga la golodu mai gonga, hoonga nomo anu waha taura fai waha la goyei nomo gau nigigai. ");
INSERT INTO eri_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nere fai-aita bagu taon Jerusalem jugunga la, nere fere maidu aposel nerigane. Nere taura fai bagu, nere fai hauri inyaba inyabamu nigane waha bagu hanigedu mayane. Nere fai-aita bagu waha oruwanga hilou heigane. ");
INSERT INTO eri_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pris mora bagu nomo ilibumu gane, nere Sadyusi fai, nere aposel dada waha ono wanenga uredu bode huwanyanege danga bagu inyabawai. ");
INSERT INTO eri_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nere jaidu aposel yaasu nigidu dagou mata la tafa niganenga fai inyaba bagu gaara yafane. ");
INSERT INTO eri_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ono ganenga, ooru Anyakaro nomo ensel ete, dagou mata nomo jauli helufadu bona hanigedu malala mayai, onodu benou lenigai, ");
INSERT INTO eri_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tere tempel nomo orei huwanya la goidu oto bonade, auma yafei nomo onowou eege beha oruwanga fai-aita bagu hai nagagu.” ");
INSERT INTO eri_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ono wainga, aposel nere beele waha isidu, eringe amina tempel la goidu, fai-aita bagu beele malalamudu lenigou haruwe taane. Ono ganenga, pris mora bagu nomo ilibumu gane bagu nere kaunsel bagu, Israel nebere mora bagu oruwanga, yaure niganenga maidu komo wane. Onodu nere aposel hanigedu mayei nomo bode dagou mata la beele huuru wane. ");
INSERT INTO eri_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ariya polis nere dagou mata la goyane wa, aposel nere walanga yafa ganenga nerigegu uwa. Onodu bode nere ege gidu goidu fai aroro benou lenigane, ");
INSERT INTO eri_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ere dagou mata nomo jauli ureyaha, nere danga bagu sesemudu lok warane, jauli oofagou gat nere jauli oruwanga oofa bode otode. Ariya saini ere jauli helufa yaha waha, fai ete huwanya la yafa ganga urei uwa.” ");
INSERT INTO eri_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tempel oofagou fai nebere kepten no pris aroro bagu beele waha isidu, ninanege baingaro isane, onodu lewane, “Nere fai beha adadu yae wane?” ");
INSERT INTO eri_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ono wanenga, fai ete heigedu benou lenigai, “Isagu. Tere fai dagou mata la tafa nigiyaha waha, nere elebe tempel nomo orei huwanya la oto bode, fai-aita bagu beele lenigide.” ");
INSERT INTO eri_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ono wainga, kepten no polis bagu goidu aposel hanigedu mayane. Ariya, nere dada ete ono nigegu uwa. Nere umugane, gamaji fai-aita bagu megebu ayaru nagoguga bode. ");
INSERT INTO eri_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Polis nere aposel hanigedu tamai kaunsel agenege la tafa nigane. Ono wanenga pris mora bagu no benou lenigai, ");
INSERT INTO eri_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tere fai waha unyi langa fai-aita bagu beele adai malalamudu lenigei nomo danga bagu karu tigeye. Ono weye wa, tere beele gai malalamudu leya, Jerusalem haumu oruwa langa fai-aita bagu tebere beele amina isane. Onodu ere fai waha dukote weyenga umai iwou beele geege la tafagu ganga ono-onoya.” ");
INSERT INTO eri_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ariya, Pita no aposel ila bagu beele ege gidu benou lewane, “Ere Itou nomonga beele oojowei nomo. Ere fai nebere beele ada oojo woya. ");
INSERT INTO eri_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tere Yesus nauge ete la waridu dukote weyenga umai, ariya, ebere asage gane nebere Itou no ege jaimu tuwai. ");
INSERT INTO eri_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Itou no hau tamanidu owo hilou la tafa tuwai yafana. No ere jala abiti higi bona gidu haigou fai, onodu no Israel ebere huwanyage ubuluwei nomo hoyo higi bona, une uulu hagonbona. ");
INSERT INTO eri_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dada beha Itou no ono gainga ureye, waha boya ere beele malalamudu leleya. Hauri Guuni fere dada beha bona beele malalamudu lelena. Itou no fai-aita bagu bolou oojo wane waha Hauri Guuni nigai.” ");
INSERT INTO eri_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunsel nere Pita nomo beele waha isidu, hounege danga bagu mayainga, aposel dunege kote wode ono wane. ");
INSERT INTO eri_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ono ganenga kaunsel ete otowai. No Farisi fai ete, nomo unyi Gamaliel. No nuuni beele isisiwou fai, fai-aita bagu no unyi jaimu gane. No fai nere aposel hanigedu goi malala langa saini tutu mene yafei nomo lenigai. ");
INSERT INTO eri_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nere malala heiganenga Gamaliel no kaunsel ila benou lenigai, “Tere Israel fai, tere fai beha dada ete ono nigagu ganga wonga, hilobainga, tere ninatege isi dedu bonade. ");
INSERT INTO eri_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tere isiya, saini ufaro goyei uwa, Teudas no jaidu bona lewai, ‘Ji fai anyakaro, ji unyife bagu,’ Ono wainga, nere fai 400 jugunga la onou no oojo tuwane. Ono wanenga, gabman no dukote wainga umai, fai no bode huwanyanege ngalengawai waha, nere fere‑feredu harawane, ono wanenga nebere haruwe ewe usuwai. ");
INSERT INTO eri_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iinga, saini gabman no fai-aita bagu unyinege elegai langa, Galiliha Judas no jaidu bona, fai-aita bagu ila nebere ninanege jaimu nagai. Ono wainga nere no oojo tudu bode, gabman usumuwei nomo oota jaimu wane. Ono wanenga no dukote wanenga, fai oruwanga no bode huwanyanege ngalengawai waha, heige harawane. ");
INSERT INTO eri_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Onou waha boni ji elebe tere letigini, tere fai beha dada ete adai ono nigagu. Tere awa nigadenga yafode. Ariya, nere haruwe tede beha, fai nebere ninanege langa nga jaimuwei mata wogunga wa, no inyaba wonbona. ");
INSERT INTO eri_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ariya, Itou no nogo we haruwe waha jaimuwei mata wonga, tere karu nigei nomo edo uwa. Gamaji tere Itou bagu wara wagu ganga!” Ono wainga kaunsel nere Gamaliel nomo beele oojo wane. ");
INSERT INTO eri_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Onodu, nere aposel yaure niganenga mayanenga, nere narigei nomo bode fai lenigane. Onodu nere Yesus unyi langa, beele ege adai malalamudu lewei nomo bode karu nigane. Onodu awa niganenga goyane. ");
INSERT INTO eri_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ono wanenga, aposel nere kaunsel awa nigidu malala heigane. Onodu bode nere Yesus unyi bode edo mayau tedege iwou ninanege isidu, Itou bode edega wane. ");
INSERT INTO eri_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ariya, nere fati oruwa manidu bode tempel langa, fai-aita bagu nebere mata langa, isisi nigou haruwe tegane. Nere hilou beele malalamudu lewei nomo haruwe awegu uwa. Nere beele tigini foomudu benou lenigi gane, Yesus no fai beha Itou no nomo fai-aita bagu ege gidu hanigei nomo bona beele baara tawai waha huuru tuwainga mai. ");
INSERT INTO eri_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Saini waha langa disaipel baingaro heigane. Onodu disaipel nere Grik beele isi gane waha nere disaipel Aram beele isi gane waha bagu honggoro bagu. Nere benou lewane, “Fati oruwanga tere fai-aita bagu da dada bode tutu nigina waha hoyo nigi nigiya, tere ere ebere aita amenege gane umeru wane waha ada hoyo nigiya.” ");
INSERT INTO eri_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ono wanenga aposel 12 nere disaipel oruwanga yaure niganenga mayanenga benou lenigane, “Ere Itou nomo beele malalamudu lewou haruwe awadu, da wesewou haruwe teboya wonga, wa tigini uwa. ");
INSERT INTO eri_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Waha bona baabo gane, tere gama langa fai 7 kuru nigagu, nere fai-aita bagu gamanege langa unyinege hilobainga, Hauri Guuni nere langa bolowou, nere isou hilou bagu. Ono wadenga ere fai waha haruwe waha oofawei nomo logosi nigo boya. ");
INSERT INTO eri_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ariya ere hage, ere edo saini oruwa hauyawou haruwe teboya fai-aita bagu Itou nomo beele langa hoyo nigo boya.” ");
INSERT INTO eri_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ono wanenga, fai-aita bagu oruwanga aposel nebere beele waha gau nigai. Onodu nere Stiven hangada tuwane, fai no waha huwanya ngalengawou danga bagu, Hauri Guuni bolo tuwou. Onodu Filip wainga, Prokorus wainga, Nikanor wainga, Timon wainga, Parmenas wainga, Nikolas wainga, hangada nigane. Ariya Nikolas no Antiok fai, no Juda fai ete uwa, ariya no Juda nebere bori oojogai. ");
INSERT INTO eri_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Fai nere beha aposel agenege langa otomu nigane, ono wanenga aposel nere fai nere haruwe waha teinomo hangada nigi bode owonege jaulanege langa tafadu hauya wane. ");
INSERT INTO eri_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ariya Itou nomo beele ha-ha oruwa langa goyai, ono wainga fai-aita bagu baingaro nere Jerusalem langa disaipel heigeru wane. Onodu pris fere baingaro nere Itou nomo beele oojo bode, huwanyanege ngalengawai. ");
INSERT INTO eri_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ariya, Itou no Stiven danga bagu hoyo tubona danga tuwai, Waha bona Stiven no dodokawou anyaroro hogo fere-fere fai-aita bagu gamanege langa tafagai. ");
INSERT INTO eri_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ono gainga, fai ila jaidu bode Stiven ngate beele langa wara wane. Nere fai waha Juda nebere bori mata ete, nomo unyi friman bori mata ide, nere bori mata wahaha. Nere fai waha Sairini taonha, Aleksandria taonha bagu, nere Silisia prowins bagu, Esia prowinsha bagu. ");
INSERT INTO eri_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ono ganenga Hauri Guuni no Stiven isou hilobainga tuwai, waha bona nere fai waha Stiven nomo beele feiyawei nomo edo uwa. ");
INSERT INTO eri_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Onou waha bode nere fai ila huwari gelele nigi bode, yaawa beele benou lewei nomo lenigane, “Ere Stiven no Moses, Itou ngare bona beele inyaba legainga iseye.” ");
INSERT INTO eri_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nere beele waha langa fai-aita bagu, nere mora bagu, nere nuuni beele isou fai bagu hounege jaimu nagane. Ono wanenga nere goidu Stiven taidu bode, haudu kaunsel bagu goyane. ");
INSERT INTO eri_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Onodu nere fai ila no go bode yaawa beele lewei nomo otomu nigane. Nere fai waha benou lewane, “Saini oruwa fai beha Itou nomo mata bona nomo nuuni beele bona beele inyaba lelena. ");
INSERT INTO eri_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ere no benou lewainga iseye, ‘Yesus Nasaretha, fai waha no mata waha inyabamudu onowou amina Moses no lehigai waha ubulumu wonbona.’ ” ");
INSERT INTO eri_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ono wanenga nere fai oruwanga kaunsel langa yafane waha, nere Stiven danga bagu feele tubode, nere Stiven nomo hogo ensel ete nomo hogo dorofe lala gainga urane. ");
INSERT INTO eri_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ariya pris mora bagu no Stiven isoki tuwai, “Fai nere ne geete bode beele lede beha ngalenga yo, uwa?” ");
INSERT INTO eri_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ono wainga Stiven no benou lewai, “Baabo gane jijei gane, tere isagu. Saini ebere asage Abraham no Mesopotemia langa yafai, no taon Haran goyei uwau langa, ha laluwa nomo Itou no Itou danga anyakaro bagu, no Abraham bagu heigai. ");
INSERT INTO eri_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Onodu Itou no Abraham benou letuwai, ‘Ne name oula, name baine gane bagu awa nigidu bonahe, oula ete ji ne abitimu hinonboni waha langa goyau.’ ");
INSERT INTO eri_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ono wainga Abraham no Kaldia nebere oula awadu bona goi Haran langa yafai. Onodu saini nomo umamu umainga, Itou no huuru tuwainga maidu, oula elebe tere yafaya langa yafai. ");
INSERT INTO eri_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Itou no oula matau waha, menanga mita etenga onou, Abraham tuwei uwa, ono wage wa, oula waha no nogo nomo idau gane nebere tigini inyage. Ariya Itou no lewai, iinga huunta la no oula waha tuwon bona, ono wonga no nogo nomo magana gane bagu nebere tigini inyon bona. Saini Abraham no magana uwau langa, Itou no beele beha lewai. ");
INSERT INTO eri_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Itou no Abraham benou letuwai, ‘Ne name magana asane gane bagu goidu fai fereha nebere kantri langa yafodbode. Onodu nere haruwe magana ewe heigodbode, ono wogunga nere inyabamu nigi gogunga goi haga orei 400 langa edo wonbona. ");
INSERT INTO eri_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ariya iinga gonga, fai nere fanyimu onou langa ono nigane waha, kot la tafa nigonboni. Ono wehenga, iinga huunta la nebere magana gane nere kantri waha awadu bode maidu haumu beha langa, ji unyife isou wodbode.’ ");
INSERT INTO eri_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Onodu Itou no Abraham beele agili mala karu fuwai waha abitiwou Itou no gogala karu wonbona letuwai. Onodu huunta la Abraham no Aisak nomo umamu heigai, no bori etenga itaridu bona Aisak gogala karu fuwai. Aisak no Jekop nomo umamu heigai, Jekop no ebere asage gane 12 nebere amenege heigai. ");
INSERT INTO eri_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Asage gane nere beha, bainege Josep bode, huwanyanege inyaba wainga haruwe magana ewe dorofe fai ila owonege langa huuru tuwane. Ono wanenga fai nere waha haudu Isip goyane. Ariya Itou no bagu yafai. ");
INSERT INTO eri_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Itou no hoyo tudu bona nomo ou oruwa usumu fuwai. Ono wainga saini Josep no Isipha king ngare beele hayare langa, Itou no isou hilobainga tuwai, waha langa king no gau tuwai. Waha bona king no hangada tuwainga Isip nebere gabman amugou yafai, onodu no king nomo mata langa dada oruwanga oofawai. ");
INSERT INTO eri_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Huunta langa maau saini anyakaro Isip ha oruwa langa, Kenan ha-ha oruwa nebere oula langa heigai, ono wainga fai-aita bagu langa ou anyakaro inyai. Ono gainga asage gane nere da uwau yafane. ");
INSERT INTO eri_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ariya Jekop no Isip langa wit bagu iwou beele isai. Onodu no asage gane huuru nigainga agenege goobu walanga goyane. ");
INSERT INTO eri_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Onodu saini nere ege goi nga wane langa, Josep no bemu gane lenigai, ‘Ji Josep we’. Ono wainga iinga la king no fere Josep bemu gane bona isi nigai. ");
INSERT INTO eri_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ono wainga Josep no umamu Jekop, beele huuru fudu no nomo fai-aita bagu 75 onou, nere oruwanga no bagu mayei nomo yaure tuwai. ");
INSERT INTO eri_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ariya Jekop no Isip minai. Onodu iinga gainga no umai, ono wainga asage gane fere nere umeru wane. ");
INSERT INTO eri_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ono wanenga nebere genege gala auledu bode gidu goi Sekem taon langa, amina Abraham no Sekem langa Hamor idau gane moni silwa langa ejiya nigai matmat waha langa u-u kuru nigane. ");
INSERT INTO eri_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ariya Itou no amina Abraham beele baara tau fuwai waha edomuwei nomo saini hangada fuwai waha amina heigona juguwai. Onodu Israel fai-aita bagu Isip langa yafane waha nere goi baingaro wane. ");
INSERT INTO eri_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iinga huunta la fai ete no Isip nebere king heigai, no Josep bona alai uwa. ");
INSERT INTO eri_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King waha no ere ebere ilibage gane yaawa nigi bona fanyimu inyaba ono nigai. No nebere magana momodo ayaru nigo gonga, umeruwei nomo bona ono nigai. ");
INSERT INTO eri_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Saini waha langa Moses no anya bisi tuwai. No magana hilobainga, Itou no gau tuwai. No ole eei nononga umamu nomo mata langa oofa tuwane. ");
INSERT INTO eri_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Onodu iinga gainga no malala langa tafa tuwanenga, king mago no haudu bona nogo nomo magana tigini dorofe oofa tuwai. ");
INSERT INTO eri_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ono wainga Moses no Isip nebere isou hilobainga waha oruwanga isisiwou te borodu, no beele danga bagu lewei nomo haruwe danga bagu hogo fere-fere teinomo fai heigai. ");
INSERT INTO eri_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Saini Moses nomo haga orei 40 usu wainga, no nomo bemu gane Israel, goidu nerigei nomo bona ninau isai. ");
INSERT INTO eri_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Onodu no Isipha fai ete no Israelha fai ete inyabamu tugainga urai. Onodu no Israelha fai waha hoyo tudu bona Isipha fai waha nomo agou tuwai, no Isipha fai waha waridu dukote wainga umai. ");
INSERT INTO eri_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses no ninau benou isai, bemu gane Israel nere Itou no owo langa hoyohigon bona iwou isodbode. Ariya nere onou isegu uwa. ");
INSERT INTO eri_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Inyi hamba, Moses no Israel fai nga wara garenga nerirai. Onodu no neire wara wou usumu narona bona goidu lenirai, ‘Eei, tere bemu-bemu. Tere taate boyare tere tare inyabamu guru yare?’ ");
INSERT INTO eri_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ono wainga fai oota jaimuwai waha no Moses fetadu kaite tuwainga gidu goyai. Ono bona letuwai, ‘Faiwei ne hangada hinanga ebere jas mora bagu heige naha? ");
INSERT INTO eri_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Feyo ne Isipha ete dukote nanga umaha onounga, ne ji dufe kotewau ganga ononi?’ ");
INSERT INTO eri_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses no beele waha isidu bona, heige fagawai. No goidu Midian nebere oula langa yafai. Onodu iinga no aita tedu fai magana nga bisi nirai. ");
INSERT INTO eri_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ariya haga orei 40 usu wainga, ensel ete oula fai uwau, Sainai muju hinemu langa, Moses bagu heigai. Ensel no nauge menakele ete tuwa gamu langa eeya heige gainga gama waha langa yafai. ");
INSERT INTO eri_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses no uredu, dada heigai waha bona ninau baingaro isai. Onodu ure dewonbona jugu langa goyainga, Anyakaro no benou letuwai, ");
INSERT INTO eri_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ji name asane gane nebere Itou. Ji Abraham nomo Aisak nomo Jekop nomo Itou.’ Ono wainga Moses no horotodu bona, igeiwei nomo umugai. ");
INSERT INTO eri_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ono wainga Anyakaro no letuwai, ‘Ne name su uuluwau, oula ne otoni waha ji yage yame onodu no guuni. ");
INSERT INTO eri_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ji yame fai-aita bagu Isip langa fanyimu inyaba ono nigide waha, ji amina nerigenaha. Ji nere nebere merou amina isinaha, ji elebe nere Isip owonege langa nganege elegei nomo boni menaha. Onou waha bona ne jayau. Ji ne huuru hinehenga Isip goyau ganga.’ ");
INSERT INTO eri_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ngasunga Israel nere Moses fetadu kaite tubode benou letuwane, ‘Ne faiwei hangada hinanga ebere mora bagu jas heige naha?’ Ariya Moses, fai behanga no Itou no mora bagu dorofe gidu hanigei nomo huuru tuwai. Itou no ensel nauge menakele langa heigai waha owo langa dangamu tuwai. ");
INSERT INTO eri_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses no nere hanigedu Isip awadu goibode, dodokawou hogo fere-fere Isip langa, hiiri Girriwou langa, ha fai uwau langa tafangawai wa, haga orei 40 oruwanga. ");
INSERT INTO eri_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses no behanga Israel benou lenigai, ‘Itou no tebere baitege ete hangada tuwonga, no profet ji yage dorofe heigon bona.’ ");
INSERT INTO eri_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Iinga, ebere asage gane goidu ha fai uwau langa komo wanenga, Moses no behanga nere bagu yafai. Onodu no Sainai muju langa manainga, ensel no beele letuwai. No Itou nomo beele tai, beele waha no ago auma, onodu beele waha ere higai. ");
INSERT INTO eri_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ariya asage gane nere Moses nomo beele isei nomo awane. Uwa. Nere nomo beele feiya wane, onodu nere huwanyanege langa Isip ege gidu goyei nomo gau dewane. ");
INSERT INTO eri_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nere Aron benou letuwane, ‘Taate dada Moses langa heigaha waha ere alai uwa, fai no waha ere Isip langa haigedu mayai. Onou waha bona ne ebere itou ila ati hagahenga, nere edo langa amuge higidu jala langa haigedu goyodbode.’ ");
INSERT INTO eri_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Onodu saini waha langa nere bulumakao magana ete atidu bode, nere yaawa itou waha eeya muru wari tuwane. Onodu dada nere nage owonege langa atane waha bode edega wane. ");
INSERT INTO eri_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ono wanenga Itou no nere moge nigai, nere edo hoonga bagu ole bagu baatu dada onou unyinege isou wodbode, profet nebere buk langa beele inyina dorofe, ‘Tere Israel, saini tere haga orei 40 ha ulisi ewe langa yafa boya, bulumakao bagu sipsip bagu dunege kotedu boya eeya muru wareye waha, ji eeya muru wari hayei yo? Gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tere sel mata anyakaro auleye waha ji yame sel mata uwa. Wa yaawa itou Molek nomo. Onodu tere yaawa itou Refan nomo baatu anu fere auleye. Tere yaawa itou anunege atigana weye waha, tere edo unyinege isou wagu ganga boya. Onou waha bona ji tebere kantri langa so tigidu, huuru tigehenga goidu oula ulate kantri Babilon nebere langa yafagu ganga.’ ");
INSERT INTO eri_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Saini asage gane nere ha fai uwau langa yafane la, nere Itou nomo sel mata bagu. Mata waha langa Itou no nomo beele ngalenga waha heigemugai. Saini nere sel mata tafane wa, Itou no Moses letuwai onounga dada oruwanga ono wane, onodu nomo anu Moses urai, gai tigini onou tafane. ");
INSERT INTO eri_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iinga asage gane nebere magana waha, nere sel mata waha tedu bode, fai ila nebere oula tei nomo bode Josuwa ngate mayane. Ono wanenga Itou no ere asage gane hogonege langa nere waha so nigai. Onodu nere sel mata jaimu wanenga no oula waha langa yafa gainga mai King Devit nomo saini heigai, ");
INSERT INTO eri_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","fai no waha Itou figini tugai. Devit no Itou edo awa tuwonga Jekop asa gane mata hilou ete tau nagonga nere edo walanga goidu bode Itou unyi isouwei nomo hauyawai. ");
INSERT INTO eri_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ariya iinga, Solomon no mata waha tawai. ");
INSERT INTO eri_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ariya Itou Gai Ouwe langa no mata fai taude waha langa ada yafa yafana. No profet lewai dorofe, ");
INSERT INTO eri_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Anyakaro no benou lena, “Ha laluwa wa ji yame sia king, onodu oula no ji yame afefe jaula langa tafagou haumu. Waha bona tere mata adoha tafa hayagu ganga? Yame houwe tafou haumu alanga inyon bona? ");
INSERT INTO eri_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ji yage dada beha oruwanga ono wene.” ’ ");
INSERT INTO eri_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ariya Stiven no kaunsel ege benou lenigai, “Tere feeto gou fai. Tere haiden fai dorofe, tebere huwanyatege bagu ninatege bagu fosokowou. Onodu agetege kuli fosokowou, waha boya tere Itou nomo beele ada isi isiya. Tere asatege gane amina onogane dorofe, saini oruwa tere Hauri Guuni nomo beele feta tutuya. ");
INSERT INTO eri_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Amina profet faiwei yafa gainga, asatege gane nere onowou inyaba ete ono tuwegu uwa? Amina fai nere Fanyimu Tigini Onogou Fai no mayona bona iwane waha, nere dunege kote wanenga umeru wane. Ariya elebe fai beha no amina mayainga, tere honggoro fai owonege langa tafa tuweinga nere dukote wanenga umai. ");
INSERT INTO eri_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tere Itou nomo nuuni beele ensel owonege langa tei, ariya tere oojo wegu uwa.” ");
INSERT INTO eri_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaunsel nere Stiven nomo beele isidu, no bode hounege danga bagu mayainga manege gidodo wane. ");
INSERT INTO eri_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Onou wa Stiven no Hauri Guuni bolo tuwainga, no ha laluwa ouwe langa igeiwai. Onodu Itou nomo lala hilobainga mujari bagu ha laluwa langa urai, Ono bona Yesus no Itou owo hilou langa oto gainga urai. ");
INSERT INTO eri_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Onodu Stiven no benou lewai, “Isagu. Ha laluwa helufa waha, Fai Nomo Idau no Itou owo hilou langa oto ganga ureni.” ");
INSERT INTO eri_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ono wainga nere beele waha isidu bode inyangaro hiri bode, agenege kuli fosoko wane. Onodu nere arotenga jaidu gurarudu goidu bode Stiven yaasu tuwane. ");
INSERT INTO eri_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Onodu nere haudu taon dui langa goidu, dukote wodbode megebu ayaru fuwane. Fai nere amugedu no go bode beele tafane waha, nere nebere kolos ufaroro uuludu magana giila ete unyi Sol tude, no afo hugu langa logosi wanenga otowai. ");
INSERT INTO eri_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Saini nere Stiven megebu ayaru fu ganenga, Stiven no benou hauyawai, “Anyakaro Yesus, ne yame anufe tau.” ");
INSERT INTO eri_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Onodu no afo tuburu kutudu bona inyangaro yaurai, “Anyakaro, ne une beha agou adai gidu nigau.” Stiven no onou ledu bona, umai. ");
INSERT INTO eri_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol ago langa, Stiven onou langa ono tuwane wa tigini. Fati nere Stiven dukote wanenga umai langa, nere sios nomo fai-aita bagu Jerusalem langa yafa gane waha inyabamu nigou hugu warane. Ono wanenga sios nomo fai-aita bagu oruwanga heige haradu fere-feredu, Judia distrik bagu Samaria distrik bagu nebere ulate langa goyane. Ariya aposel nere Jerusalem langa gai yafane. ");
INSERT INTO eri_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nere fai ila onowou Itou no gau tuna waha oojo degane wa, nere Stiven u-u kuru wane, onodu no bode inyangaro merane. ");
INSERT INTO eri_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol no sios nomo fai-aita bagu inyabamu nigou haruwe tai. No nebere mata huwanya langa goidu bona fai-aita bagu hanigegai. Onodu kuse nigidu togoi dagou mata langa logosi nigigai. ");
INSERT INTO eri_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ariya nere fai-aita bagu ha-ha oruwa langa haradu fere-fere goyane waha, nere haumu nere yafane langa hilou beele malalamudu lewane. ");
INSERT INTO eri_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip no Samaria nebere taon ete langa goidu, Kristus nomo hilou beele lenigai. ");
INSERT INTO eri_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ono gainga fai-aita bagu baingaro nere Filip nomo beele isidu bode, no dodokawou tafai waha uredu, nomo beele isi dewodbode agenege kuli tafane. ");
INSERT INTO eri_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Hauri inyaba fai-aita bagu baingaro langa jiri wane waha, Filip no so nigainga hauri inyaba nere waha inyangaro uidu bode awa nigidu hara ganenga nerigane. Onodu fai ngedonege umeruwou yo afenege inyaba waha, ege jige nigai. ");
INSERT INTO eri_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ono wainga fai-aita bagu taon waha langa edegawou anyakaro heigai. ");
INSERT INTO eri_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Fai ete no taon waha langa yafagai, unyi Saimon. Amina no onowou hogo fere-fere nomo danga wadewou bagu mujari hogo fere-fere nomo danga dada abitimugai, Ono gainga Samaria fai-aita bagu uredu ninanege baingaro isi gane. No benou legai, “Ji fai anyakaro.” ");
INSERT INTO eri_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ono gainga nere fai aroro bagu fai-aita bagu ewe waha, oruwanga Saimon nomo beele isei nomo danga tafa gane. Nere legane, “Itou nomo danga beha, nere lede Danga Anyakaro, fai beha langa inyina.” ");
INSERT INTO eri_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nere nomo beele isei nomo danga tafane, taate bode, saini baingaro no dada hogo fere ete tigini ono gainga urane, onodu nere ninanege baingaro isane. ");
INSERT INTO eri_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ariya saini Filip no hilou beele Itou nomo huuna langa yafou waha bagu, Yesus Kristus nomo unyi bagu lenigainga, fai bagu aita bagu huwanyanege ngalenga wainga nere yaage bisou taane. ");
INSERT INTO eri_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon fere no huwanya ngalenga wainga yaage bisou tai. Onodu no Filip ngare golo bodere Filip no dodokawou aroro hogo fere-fere tafa gainga uredu, ninau baingaro isai. ");
INSERT INTO eri_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel nere Jerusalem langa yafa bode, Samaria nere Itou nomo beele taane waha isane. Onodu nere Pita, Jon ngare huuru niranenga goyare. ");
INSERT INTO eri_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nere goi heigedu, Itou no Samaria nere waha Hauri Guuni nigei nomo hauya ware, ");
INSERT INTO eri_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","taate bona, Hauri Guuni nere langa mei uwa inyi gainga. Nere Yesus unyi langa yaage bisounga taane. ");
INSERT INTO eri_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nere hauya borodu, ariya nere owonere moranege langa tafarenga, nere Hauri Guuni taane. ");
INSERT INTO eri_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon no aposel nga owonere nere moranege langa tafarenga nere Hauri Guuni tanenga nerigai. Onodu no moni tedu nere bagu maidu lenirai, ");
INSERT INTO eri_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Tere danga waha ji fere hiyaru. Ono waderenga, ji fere fai ete mora langa owofe tafehe wonga, no edo Hauri Guuni tonbona.” ");
INSERT INTO eri_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ono wainga Pita no Saimon letuwai, “Ne name moni ne nage ngare edo inyaba waru ganga! Dada Itou no toota dorofe higina waha, ne moni langa ejiyawei nomo edo ini yo? Gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne name huwanyate Itou ago langa tigini uwa. Waha bona Itou nomo haruwe ere teya beha langa ne gamu yafei nomo edo uwa. Gai uwanga uwa. ");
INSERT INTO eri_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ne huwanyate ubuludu bonahe ne name onowou inyaba waha moge tuwau. Onodu ne Anyakaro hauya tudu, ne name nyabuluwou isou inyaba huwanyate langa inyina waha usumu hanei nomo isoki tuwau. ");
INSERT INTO eri_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ji benou leni waha taate bona, ji neriyeni beha ne Itou nomo toota teinomo agene warina, ariya agene warou waha no marasin inyaba dorofe ninate inyabamu hani ganga ne une nomo dagou mata langa yafani.” ");
INSERT INTO eri_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ono wainga Saimon no beele ege gidu benou lenirai, “Tere Anyakaro hauya tuwa derenga no edo ji bona aau waronga, dada tere leyare waha ji langa ada heigona.” ");
INSERT INTO eri_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ariya aposel nga waha nere Anyakaro nomo beele malalamudu lebodere, Anyakaro no dada nere langa onowai waha fai-aita bagu hai nagare. Onodu iinga gainga nere Jerusalem gidu goyare. Saini nere golodu goi bodere, nere Samaria nebere matane baingaro langa hilou beele lenigare. ");
INSERT INTO eri_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Anyakaro nomo ensel ete Filip benou letuwai, “jaidu bonahe ulate saot langa goyau, ne goidu Jerusalem jala waha awadu ulate Gasa taon langa minau.” Jala waha ulate ha fai uwau langa inyina. ");
INSERT INTO eri_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ono wainga Filip no jaidu goyai. Jala waha langa no Afrika fai ete urai. No Afrika kantri langa kwin o kandasi nomo gabman nomo fai anyakaro ete, no kwin nomo moni dada oruwanga oofagai. No fai ete amaimu te fuwane. Fai waha no Jerusalem bori bona mayai, ");
INSERT INTO eri_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ariya no ege gidu goyona bona onowai. No nomo karis langa yafadu goi bona, profet Aisaia nomo buk lelegai. ");
INSERT INTO eri_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ono gainga Hauri Guuni no Filip letuwai, “Ne goidu karis woha hinomu langa golowau.” ");
INSERT INTO eri_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ono wainga Filip no guriyedu hinomu langa goidu, fai waha profet Asaia nomo buk lelege gainga isai. Onodu Filip no letuwai, “Ne beele lelegeni waha nomo hugu isini yo?” ");
INSERT INTO eri_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ono wainga fai waha no benou letuwai, “Fai ete te no beele beha nomo hugu lehiyei uwa wonga, ji adadu isei nomo edo?” Onodu no Filip letuwai, “Ne karis digedu mayahenga ji ngare yafoyare.” ");
INSERT INTO eri_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ariya no buk waha nomo ulate lelegai, no beele benou bagu, “No beele ete te lewei uwa. No sipsip dukote wode haudu togoide dorofe hurau fosokowai, onodu no sipsip magana ululumu karu fuwode onode dorofe. ");
INSERT INTO eri_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nere ileide tuwane, onodu nere beele tigini langa kot langa tafa tuwegu uwa. Onou waha bona fai nere aasa waha hai nagei nomo, no nomo magana gane ila yafegu uwa. Nere nomo ago auma yafou usumu fuwane, no ege oula langa yafei uwa.” ");
INSERT INTO eri_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Fai waha no beele waha lelege borodu, Filip benou isoki tuwai, “Ji ne isoki hinini. Profet no faiwei bona ledu, no beele beha lena? No nogo bona lena yo, uwa, no fai ete bona lena?” ");
INSERT INTO eri_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ono wainga Filip no fai waha beele malalamudu letuwai. Ngasunga fai no beele lelegai waha nomo hugu malalamudu letuwai, onodu huunta langa no beele ila Yesus nomo hilou beele waha hai fuwai. ");
INSERT INTO eri_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Nere jala langa gai golodu goi yaage ete langa heigare. Onodu fai waha no lewai, “Urau, yaage inyina. Dada ete jala karu waha bona ji yaage bisou ada toni yo?” ");
INSERT INTO eri_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ariya fai waha no lewainga draiva no hosi karis kusewane waha ono nigainga otowane. Ono wainga Filip no fai waha ngare yaage langa heigedu minare. Onodu Filip no fai waha yaage bisemu tuwai. ");
INSERT INTO eri_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Onodu nere yaage awadu digedu mai garenga, fasadu onou Anyakaro nomo Hauri Filip haudu fagawai, ono wainga fai waha no ege Filip urei uwa. Ariya fai waha no edega bona nomo jala oojodu minai. ");
INSERT INTO eri_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ariya Filip no urai wa no Asdot taon langa yafai, onodu no taon oruwa langa kejiwe golo bona Yesus nomo hilou beele lenigi bona goyai. Onodu huunta langa no Sisaria taon langa goi heigai. ");
INSERT INTO eri_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saini waha langa Sol no Anyakaro nomo disaipel inyabamu nigidu dunege kotewei nomo beele danga bagu lengawai. Waha bona no pris mora bagu langa goidu, ");
INSERT INTO eri_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Juda nebere bori mata Damaskus taon langa otode waha nebere mora bagu pas yerege nagei nomo bona isoki tuwai. Ono wainga pris mora bagu no pas yeregedu Sol tuwai. Pas waha langa nere beele benou bagu, “Sol no fai yo aita ila Yesus nomo jala oojowei mata bode wonga, no edo dagou mata langa logosi nigidu hanigedu Jerusalem mayona bona.” ");
INSERT INTO eri_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ariya Sol no Jerusalem awadu Damaskus goyai. Saini no Damaskus jugu tugainga, fasayadu onou ha laluwa nomo lala ete no bagu mai. Lala waha no gai danga bagu, ");
INSERT INTO eri_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ono wainga Sol no oula langa meboduwai. Onodu no fai ete bolou benou lewainga isai, “Sol, Sol, ne taate boni ji inyabamu hiingani?” ");
INSERT INTO eri_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ono wainga Sol no letuwai, “Anyakaro, ne faiwei?” Ono wainga no letuwai, “Ji Yesus we, ne ji inyabamu hiingani. ");
INSERT INTO eri_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ariya ne jaidu taon huwanya langa goyau. Iinga gonga fai ete no ne dada onowau ganga waha lehinon bona.” ");
INSERT INTO eri_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Fai nere Sol ngate goyane waha nere horotudu, beele lewegu uwa. Nere fai hurau langa beele legainga isane, ariya nere fai ete uregu uwa. ");
INSERT INTO eri_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ono wainga Sol no jaidu ago igeiwai, ariya no ago aguguwai. Ono wainga nere owo yaasudu bode haudu Damaskus huwanya goyane. ");
INSERT INTO eri_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","No fati eei yafai, no ago agugu onou inyai. Ono bona no da nyei uwa yaage nyei uwa. ");
INSERT INTO eri_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ariya Yesus nomo disaipel ete no Damaskus langa yafagai, nomo unyi Ananaias. Wewewou langa Anyakaro no unyi tai, “Ananaias.” Ono wainga letuwai, “Anyakaro, ji yafani” ");
INSERT INTO eri_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ono wainga Anyakaro no letuwai, “Ne jaidu bonahe jala beha langa goyau, nomo unyi Jala Tigini. Judas nomo mata langa fai ete bonahe isokiwau no taon Tarsusha, nomo unyi Sol. Elebe no hauya bona yafana. ");
INSERT INTO eri_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","No ago aguguwai, ariya no wewewou langa fai ete urai, nomo unyi Ananaias, no huwanya maidu bona ago ege igeiwei nomo bona owo jaula langa tafaiha.” ");
INSERT INTO eri_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ono wainga Ananaias ege gidu benou letuwai, “Anyakaro, fai baingaro nere fai waha bode lewanenga isene, nomo onowou inyaba hogo fere-fere ne name fai-aita bagu Jerusalem langa ono nigai. ");
INSERT INTO eri_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","No fai-aita bagu taon beha langa bori ure bode ne unyite langa hauyade waha, edo dagou mata langa logosi nigei nomo pris aroro langa beele edo iwou taiha.” ");
INSERT INTO eri_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ono wainga Anyakaro no benou letuwai, “Ne goyau. Elebe fai waha no yame haruwe fai heigaha. No fai-aita ila bagu king bagu, onodu nere Israel fere, nere bagu goidu ji unyife malalamudu lenigonbona hangada tunaha. ");
INSERT INTO eri_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Saini no ji unyife malalamudu legonga, ou bagu jimiri bagu hogo fere-fere abitimu tuwehenga no edo aulona bona.” ");
INSERT INTO eri_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ono wainga Ananaias no goyai. No mata jauli huwanya langa goidu bona, Sol jaula langa owo tafa bona letuwai, “Baabo Sol, Anyakaro Yesus no jala langa ne bagu heigai waha, elebe huuru hiyanga ne mainaha, ne edo ege igei gahe Hauri Guuni edo ne langa bolowonbona.” ");
INSERT INTO eri_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias no beele leboro gainga, Sol ago magana langa ago laala tafadu inyai waha, fasayadu onou ago awadu mebodu wainga no ege edo langa igeiwai. Ono wainga no jaidu bona yaage bisou tai. ");
INSERT INTO eri_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Onodu iinga gainga Sol no da nyi bona ege danga tai. ");
INSERT INTO eri_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Onodu iinga Sol no tigini Juda nebere bori mata langa goidu, no beele benou malalamudu lenigai, “Yesus no Itou Idau.” ");
INSERT INTO eri_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ono wainga fai oruwanga Sol nomo beele isidu horoto wane. Onodu benou lewane, “Fai no beha fai-aita bagu Yesus unyi langa bori urebode hauya gane waha inyabamu nigigai. No Jerusalem langa onou onowai waha, elebe no belanga dagou mata langa logosi nigidu pris aroro bagu hanigedu goyona bona waha mayaha.” ");
INSERT INTO eri_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ariya Sol nomo danga gai anyakaro heigai. Ono wainga Juda Damaskus langa yafane waha tigini benou foomudu lenigai, “Yesus no fai waha Itou no nomo fai-aita bagu gidu hanigei nomo hangada tuwai.” Juda nere Sol nomo beele isidu horotodu bode, nomo beele ileiwei nomo beele ete te lewegu uwa. ");
INSERT INTO eri_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fati baingaro goyainga, Juda nere Sol dukote wogunga umonbona waha komodu beele ngado wane. ");
INSERT INTO eri_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ono wanenga Sol no nere dada ono wodbode waha beele isai. Ariya Juda nere no dukote wogunga umonbona waha bode hoonga bagu ooru fere, taon nomo jauli arasai oruwanga oofa wane. ");
INSERT INTO eri_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ariya Sol nomo disaipel nere ooru Sol haudu bode orei anyakaro taon kolili tuwou waha ouwe langa haudu manane. Onodu letuwanenga no kekele anyakaro ete langa yafa gainga, nere maalu awa tuganenga taon malala langa minai. ");
INSERT INTO eri_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Iinga gainga Sol no Jerusalem goidu bona, no disaipel bagu komowei nomo bona onowai. Ono wainga nere oruwanga umuge tuwane, nere no disaipel heigai waha bode huwanyanege ngalenga wegu uwa. ");
INSERT INTO eri_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ariya Barnabas no we, Sol haudu aposel bagu goyai. Ono wainga Sol no Anyakaro jala langa urainga, Anyakaro no beele letuwai waha hai nagai. Ariya Sol no Damaskus langa Yesus unyi bona beele danga bagu lenigai waha fere, Barnabas no hai nagai. ");
INSERT INTO eri_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ono wainga Sol no nere bagu Jerusalem langa yafa bona, nere gaara gologane. No umugei uwa, no Anyakaro unyi lewei nomo haruwe danga bagu tai. ");
INSERT INTO eri_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","No Juda nere Grik beele isi gane waha bagu beele langa wara gane. Ono bode nere no dukote wogunga umei nomo bode jala kuruwou haruwe tegane. ");
INSERT INTO eri_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Saini baabo gane nere beele waha isidu, nere Sol haudu Sisaria taon langa minane, Onodu huuru tuwanenga Tarsus taon langa goyai. ");
INSERT INTO eri_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Waha bona Judia bagu Galili bagu Samaria bagu nebere haumu oruwa langa sios fai-aita bagu hilou yafane. Fai ila nere inyabamu nigegu uwa, sios no danga bagu heigai. Nere Anyakaro nomo huuna langa yafou waha fanyimu oojo ganenga, Hauri Guuni no nere huwanyanege dangamu nagai. Fai-aita bagu baingaro nere sios huwanya langa mayane. ");
INSERT INTO eri_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita no ha-ha oruwa langa golowai, onodu no Lida taon langa fere minidu Itou nomo fai-aita bagu Lida taon langa yafade waha bagu yafai. ");
INSERT INTO eri_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Haumu waha langa no fai ete urai, nomo unyi Ainias. No ngedemu oruwanga ume borowai, no kabali langa-nga haga orei 8 oruwa inyai. ");
INSERT INTO eri_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ono gainga Pita beno