﻿USE sofia;
DROP TABLE IF EXISTS sofia.epo_vpl;
CREATE TABLE epo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES epo_vpl WRITE;
INSERT INTO epo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","En la komenco Dio kreis la ĉielon kaj la teron. ");
INSERT INTO epo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kaj la tero estis senforma kaj dezerta, kaj mallumo estis super la abismo; kaj la spirito de Dio ŝvebis super la akvo. ");
INSERT INTO epo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kaj Dio diris: Estu lumo; kaj fariĝis lumo. ");
INSERT INTO epo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kaj Dio vidis la lumon, ke ĝi estas bona; kaj Dio apartigis la lumon de la mallumo. ");
INSERT INTO epo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kaj Dio nomis la lumon Tago, kaj la mallumon Li nomis Nokto. Kaj estis vespero, kaj estis mateno, unu tago. ");
INSERT INTO epo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kaj Dio diris: Estu firmaĵo inter la akvo, kaj ĝi apartigu akvon de akvo. ");
INSERT INTO epo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kaj Dio kreis la firmaĵon, kaj apartigis la akvon, kiu estas sub la firmaĵo, de la akvo, kiu estas super la firmaĵo; kaj fariĝis tiel. ");
INSERT INTO epo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kaj Dio nomis la firmaĵon Ĉielo. Kaj estis vespero, kaj estis mateno, la dua tago. ");
INSERT INTO epo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kaj Dio diris: Kolektiĝu la akvo de sub la ĉielo en unu lokon, kaj aperu la sekaĵo; kaj fariĝis tiel. ");
INSERT INTO epo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kaj Dio nomis la sekaĵon Tero, kaj la kolektiĝojn de la akvo Li nomis Maroj. Kaj Dio vidis, ke ĝi estas bona. ");
INSERT INTO epo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kaj Dio diris: Kreskigu la tero verdaĵon, herbon, kiu naskas semon, fruktarbon, kiu donas laŭ sia speco frukton, kies semo estas en ĝi mem, sur la tero; kaj fariĝis tiel. ");
INSERT INTO epo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kaj la tero elkreskigis verdaĵon, herbon, kiu naskas semon laŭ sia speco, kaj arbon, kiu donas frukton, kies semo estas en ĝi mem laŭ sia speco. Kaj Dio vidis, ke ĝi estas bona. ");
INSERT INTO epo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kaj estis vespero, kaj estis mateno, la tria tago. ");
INSERT INTO epo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kaj Dio diris: Estu lumaĵoj en la ĉiela firmaĵo, por apartigi la tagon de la nokto, kaj ili prezentu signojn, tempojn, tagojn, kaj jarojn; ");
INSERT INTO epo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","kaj ili estu lumaĵoj en la ĉiela firmaĵo, por lumi super la tero; kaj fariĝis tiel. ");
INSERT INTO epo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kaj Dio faris la du grandajn lumaĵojn: la pli grandan lumaĵon, por regi la tagon, kaj la malpli grandan lumaĵon, por regi la nokton, kaj la stelojn. ");
INSERT INTO epo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kaj Dio starigis ilin sur la ĉiela firmaĵo, por ke ili lumu sur la teron, ");
INSERT INTO epo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kaj por ke ili regu la tagon kaj la nokton kaj faru diferencon inter la lumo kaj la mallumo. Kaj Dio vidis, ke ĝi estas bona. ");
INSERT INTO epo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kaj estis vespero, kaj estis mateno, la kvara tago. ");
INSERT INTO epo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kaj Dio diris: La akvo aperigu moviĝantaĵojn, vivajn estaĵojn, kaj birdoj ekflugu super la tero, sub la ĉiela firmaĵo. ");
INSERT INTO epo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kaj Dio kreis la grandajn balenojn, kaj ĉiujn vivajn estaĵojn moviĝantajn, kiujn aperigis la akvo, laŭ ilia speco, kaj ĉiujn flugilhavajn birdojn laŭ ilia speco. Kaj Dio vidis, ke ĝi estas bona. ");
INSERT INTO epo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kaj Dio ilin benis, dirante: Fruktu kaj multiĝu, kaj plenigu la akvon en la maroj, kaj la birdoj multiĝu sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kaj estis vespero, kaj estis mateno, la kvina tago. ");
INSERT INTO epo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kaj Dio diris: La tero aperigu vivajn estaĵojn, laŭ ilia speco, brutojn kaj rampaĵojn kaj surterajn bestojn, laŭ ilia speco; kaj fariĝis tiel. ");
INSERT INTO epo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kaj Dio kreis la bestojn de la tero, laŭ ilia speco, kaj la brutojn, laŭ ilia speco, kaj ĉiujn rampaĵojn de la tero, laŭ ilia speco. Kaj Dio vidis, ke ĝi estas bona. ");
INSERT INTO epo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kaj Dio diris: Ni kreu homon laŭ Nia bildo, similan al Ni; kaj ili regu super la fiŝoj de la maro kaj super la birdoj de la ĉielo kaj super la brutoj, kaj super ĉiuj rampaĵoj, kiuj rampas sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kaj Dio kreis la homon laŭ Sia bildo, laŭ la bildo de Dio Li kreis lin; en formo de viro kaj virino Li kreis ilin. ");
INSERT INTO epo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kaj Dio benis ilin, kaj Dio diris al ili: Fruktu kaj multiĝu, kaj plenigu la teron kaj submetu ĝin al vi, kaj regu super la fiŝoj de la maro kaj super la birdoj de la ĉielo, kaj super ĉiuj bestoj, kiuj moviĝas sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kaj Dio diris: Jen Mi donis al vi ĉiujn herbojn, kiuj semas semon, kiuj troviĝas sur la tuta tero, kaj ĉiujn arbojn, kiuj havas en si arban frukton, kiu semas semon; tio estu por vi manĝaĵo. ");
INSERT INTO epo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kaj al ĉiuj bestoj de la tero kaj al ĉiuj birdoj de la ĉielo kaj al ĉiuj rampaĵoj sur la tero, kiuj havas en si vivan animon, la tutan verdan herbaĵon kiel manĝaĵon. Kaj fariĝis tiel. ");
INSERT INTO epo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kaj Dio rigardis ĉion, kion Li kreis, kaj vidis, ke ĝi estas tre bona. Kaj estis vespero, kaj estis mateno, la sesa tago. ");
INSERT INTO epo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kaj estis finitaj la ĉielo kaj la tero kaj ĉiuj iliaj apartenaĵoj. ");
INSERT INTO epo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kaj Dio finis en la sepa tago Sian laboron, kiun Li faris, kaj Li ripozis en la sepa tago de la tuta laboro, kiun Li faris. ");
INSERT INTO epo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kaj Dio benis la sepan tagon kaj sanktigis ĝin, ĉar en ĝi Li ripozis de Sia tuta laboro, kiun Li faris kreante. ");
INSERT INTO epo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tia estas la naskiĝo de la ĉielo kaj la tero, kiam ili estis kreitaj, kiam Dio la Eternulo faris la teron kaj la ĉielon. ");
INSERT INTO epo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kaj nenia kampa arbetaĵo ankoraŭ estis sur la tero, kaj nenia kampa herbo ankoraŭ kreskis, ĉar Dio la Eternulo ne pluvigis sur la teron, kaj ne ekzistis homo, por prilabori la teron. ");
INSERT INTO epo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Sed nebulo leviĝadis de la tero kaj donadis malsekecon al la tuta supraĵo de la tero. ");
INSERT INTO epo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kaj Dio la Eternulo kreis la homon el polvo de la tero, kaj Li enblovis en lian nazon spiron de vivo, kaj la homo fariĝis viva animo. ");
INSERT INTO epo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kaj Dio la Eternulo plantis ĝardenon en Eden en la Oriento, kaj Li metis tien la homon, kiun Li kreis. ");
INSERT INTO epo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kaj Dio la Eternulo elkreskigis el la tero ĉiun arbon ĉarman por la vido kaj bonan por la manĝo, kaj la arbon de vivo en la mezo de la ĝardeno, kaj la arbon de sciado pri bono kaj malbono. ");
INSERT INTO epo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kaj rivero eliras el Eden, por akvoprovizi la ĝardenon, kaj de tie ĝi dividiĝas kaj fariĝas kvar ĉefpartoj. ");
INSERT INTO epo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","La nomo de unu estas Piŝon; ĝi estas tiu, kiu ĉirkaŭas la tutan landon Ĥavila, kie estas la oro. ");
INSERT INTO epo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Kaj la oro de tiu lando estas bona; tie troviĝas bedelio kaj la ŝtono onikso. ");
INSERT INTO epo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kaj la nomo de la dua rivero estas Giĥon; ĝi estas tiu, kiu ĉirkaŭas la tutan landon Etiopujo. ");
INSERT INTO epo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kaj la nomo de la tria rivero estas Ĥidekel; ĝi estas tiu, kiu fluas antaŭ Asirio. Kaj la kvara rivero estas Eŭfrato. ");
INSERT INTO epo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kaj Dio la Eternulo prenis la homon kaj enloĝigis lin en la ĝardeno Edena, por ke li prilaboradu ĝin kaj gardu ĝin. ");
INSERT INTO epo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kaj Dio la Eternulo ordonis al la homo, dirante: De ĉiu arbo de la ĝardeno vi manĝu; ");
INSERT INTO epo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","sed de la arbo de sciado pri bono kaj malbono vi ne manĝu, ĉar en la tago, en kiu vi manĝos de ĝi, vi mortos. ");
INSERT INTO epo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kaj Dio la Eternulo diris: Ne estas bone, ke la homo estu sola; Mi kreos al li helpanton similan al li. ");
INSERT INTO epo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kaj Dio la Eternulo kreis el la tero ĉiujn bestojn de la kampo kaj ĉiujn birdojn de la ĉielo, kaj venigis ilin al la homo, por vidi, kiel li nomos ilin; kaj kiel la homo nomis ĉiun vivan estaĵon, tiel restis ĝia nomo. ");
INSERT INTO epo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kaj la homo donis nomojn al ĉiuj brutoj kaj al la birdoj de la ĉielo kaj al ĉiuj bestoj de la kampo; sed por la homo ne troviĝis helpanto simila al li. ");
INSERT INTO epo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kaj Dio la Eternulo faligis profundan dormon sur la homon, kaj ĉi tiu endormiĝis; kaj Li prenis unu el liaj ripoj kaj fermis la lokon per karno. ");
INSERT INTO epo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kaj Dio la Eternulo konstruis el la ripo, kiun Li prenis de la homo, virinon, kaj Li venigis ŝin al la homo. ");
INSERT INTO epo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kaj la homo diris: Jen nun ŝi estas osto el miaj ostoj kaj karno el mia karno; ŝi estu nomata Virino, ĉar el Viro ŝi estas prenita. ");
INSERT INTO epo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tial viro forlasos sian patron kaj sian patrinon, kaj aliĝos al sia edzino, kaj ili estos unu karno. ");
INSERT INTO epo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kaj ili ambaŭ estis nudaj, la homo kaj lia edzino, kaj ili ne hontis. ");
INSERT INTO epo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kaj la serpento estis pli ruza, ol ĉiuj kampaj bestoj, kiujn kreis Dio la Eternulo. Kaj ĝi diris al la virino: Ĉu Dio diris, ke vi ne manĝu de ĉiuj arboj de la ĝardeno? ");
INSERT INTO epo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kaj la virino diris al la serpento: La fruktojn de la arboj de la ĝardeno ni povas manĝi; ");
INSERT INTO epo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","sed pri la fruktoj de la arbo, kiu estas en la mezo de la ĝardeno, Dio diris: Ne manĝu ion de ili kaj ne tuŝu ilin, por ke vi ne mortu. ");
INSERT INTO epo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kaj la serpento diris al la virino: Ne, vi ne mortos; ");
INSERT INTO epo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","sed Dio scias, ke en la tago, en kiu vi manĝos ion de ili, malfermiĝos viaj okuloj kaj vi estos kiel Dio, vi scios bonon kaj malbonon. ");
INSERT INTO epo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kaj la virino vidis, ke la arbo estas bona por manĝi kaj ĝi estas ĉarma por la okuloj, kaj la arbo estas dezirinda por saĝiĝi; kaj ŝi prenis de ĝiaj fruktoj, kaj ŝi manĝis, kaj ŝi donis kune ankaŭ al sia edzo, kaj li manĝis. ");
INSERT INTO epo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kaj malfermiĝis la okuloj de ili ambaŭ, kaj ili sciiĝis, ke ili estas nudaj; kaj ili kunkudris foliojn de figarbo kaj faris al si zonaĵojn. ");
INSERT INTO epo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kaj ili aŭdis la voĉon de Dio la Eternulo, kiu marŝis en la ĝardeno dum la malvarmeto de la tago; kaj Adam kaj lia edzino kaŝiĝis de Dio la Eternulo inter la arboj de la ĝardeno. ");
INSERT INTO epo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kaj Dio la Eternulo vokis Adamon, kaj diris al li: Kie vi estas? ");
INSERT INTO epo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kaj tiu diris: Vian voĉon mi aŭdis en la ĝardeno, kaj mi ektimis, ĉar mi estas nuda; kaj mi kaŝis min. ");
INSERT INTO epo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kaj Dio diris: Kiu diris al vi, ke vi estas nuda? ĉu vi ne manĝis de la arbo, pri kiu Mi ordonis al vi, ke vi ne manĝu de ĝi? ");
INSERT INTO epo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kaj Adam diris: La edzino, kiun Vi donis al mi kiel kunulinon, ŝi donis al mi de la arbo, kaj mi manĝis. ");
INSERT INTO epo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kaj Dio la Eternulo diris al la virino: Kial vi tion faris? Kaj la virino diris: La serpento tromplogis min, kaj mi manĝis. ");
INSERT INTO epo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kaj Dio la Eternulo diris al la serpento: Ĉar vi tion faris, tial estu malbenita inter ĉiuj brutoj kaj inter ĉiuj bestoj de la kampo; sur via ventro vi irados kaj teron vi manĝados dum via tuta vivo. ");
INSERT INTO epo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kaj Mi metos malamikecon inter vi kaj la virino kaj inter via idaro kaj ŝia idaro; ĝi frapados vian kapon, kaj vi pikados ĝian kalkanon. ");
INSERT INTO epo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Al la virino Li diris: Mi multigos viajn suferojn dum via gravedeco; en doloro vi naskados infanojn; kaj al via viro vi vin tiros, kaj li regos super vi. ");
INSERT INTO epo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kaj al Adam Li diris: Ĉar vi obeis la voĉon de via edzino, kaj vi manĝis de la arbo, pri kiu Mi ordonis al vi, dirante, ke vi ne manĝu de ĝi, tial malbenita estu la tero pro vi; kun suferoj vi manĝados de ĝi dum via tuta vivo. ");
INSERT INTO epo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kaj dornojn kaj pikaĵojn ĝi kreskigos por vi, kaj vi manĝados herbojn de la kampo. ");
INSERT INTO epo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","En la ŝvito de via vizaĝo vi manĝados panon, ĝis vi revenos en la teron, el kiu vi estas prenita; ĉar vi estas polvo kaj refariĝos polvo. ");
INSERT INTO epo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kaj Adam donis al sia edzino la nomon Eva, ĉar ŝi estis patrino de ĉiuj vivantoj. ");
INSERT INTO epo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kaj Dio la Eternulo faris por Adam kaj por lia edzino vestojn el felo, kaj Li vestis ilin. ");
INSERT INTO epo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kaj Dio la Eternulo diris: Jen Adam fariĝis kiel unu el Ni, sciante bonon kaj malbonon; nun eble li etendos sian manon kaj prenos ankaŭ de la arbo de vivo kaj manĝos kaj vivos eterne. ");
INSERT INTO epo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kaj Dio la Eternulo eligis lin el la Edena ĝardeno, por ke li prilaboradu la teron, el kiu li estis prenita. ");
INSERT INTO epo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kaj Li elpelis Adamon, kaj lokis antaŭ la Edena ĝardeno la kerubon kaj la turniĝantan flaman glavon, por gardi la vojon al la arbo de vivo. ");
INSERT INTO epo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kaj Adam ekkonis Evan, sian edzinon, kaj ŝi gravediĝis, kaj ŝi naskis Kainon; kaj ŝi diris: Mi akiris homon de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kaj plue ŝi naskis lian fraton Habel. Kaj Habel fariĝis ŝafpaŝtisto, kaj Kain fariĝis terlaboristo. ");
INSERT INTO epo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kaj post ia tempo fariĝis, ke Kain alportis el la fruktoj de la tero donacoferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kaj Habel ankaŭ alportis el la unuenaskitoj de siaj ŝafoj kaj el ilia graso. Kaj la Eternulo atentis Habelon kaj lian donacoferon; ");
INSERT INTO epo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","sed Kainon kaj lian donacoferon Li ne atentis. Kaj Kain tre ekkoleris, kaj lia vizaĝo kliniĝis. ");
INSERT INTO epo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kaj la Eternulo diris al Kain: Kial vi koleras? kaj kial kliniĝis via vizaĝo? ");
INSERT INTO epo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ja se vi agos bone, vi estos forta; sed se vi agos malbone, la peko kuŝos ĉe la pordo, kaj vin ĝi aspiros, sed vi regu super ĝi. ");
INSERT INTO epo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaj Kain parolis kun sia frato Habel; kaj kiam ili estis sur la kampo, Kain leviĝis kontraŭ sian fraton Habel kaj mortigis lin. ");
INSERT INTO epo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kaj la Eternulo diris al Kain: Kie estas via frato Habel? Kaj tiu diris: Mi ne scias; ĉu mi estas gardisto de mia frato? ");
INSERT INTO epo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kaj Li diris: Kion vi faris? la voĉo de la sango de via frato krias al Mi de la tero. ");
INSERT INTO epo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kaj nun estu malbenita de sur la tero, kiu malfermis sian buŝon, por preni la sangon de via frato el via mano. ");
INSERT INTO epo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kiam vi prilaboros la teron, ĝi ne plu donos al vi sian forton; vaganto kaj forkuranto vi estos sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaj Kain diris al la Eternulo: Pli granda estas mia puno, ol kiom mi povos elporti. ");
INSERT INTO epo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Jen Vi forpelas min hodiaŭ de sur la tero, kaj mi devas min kaŝi de antaŭ Via vizaĝo, kaj mi estos vaganto kaj forkuranto sur la tero, kaj iu ajn, kiu min renkontos, mortigos min. ");
INSERT INTO epo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kaj la Eternulo diris al li: Sciu, ke al iu, kiu mortigos Kainon, estos venĝite sepoble. Kaj la Eternulo faris sur Kain signon, ke ne mortigu lin iu, kiu lin renkontos. ");
INSERT INTO epo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaj Kain foriris de antaŭ la Eternulo, kaj loĝiĝis en la lando Nod, oriente de Eden. ");
INSERT INTO epo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaj Kain ekkonis sian edzinon, kaj ŝi gravediĝis, kaj ŝi naskis Ĥanoĥon. Kaj li konstruis urbon, kaj li donis al la urbo nomon laŭ la nomo de sia filo: Ĥanoĥ. ");
INSERT INTO epo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kaj al Ĥanoĥ naskiĝis Irad, kaj al Irad naskiĝis Meĥujael, kaj al Meĥujael naskiĝis Metuŝael, kaj al Metuŝael naskiĝis Lemeĥ. ");
INSERT INTO epo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Kaj Lemeĥ prenis al si du edzinojn: unu havis la nomon Ada, kaj la dua havis la nomon Cila. ");
INSERT INTO epo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Kaj Ada naskis Jabalon; li estis la patro de tiuj, kiuj loĝas en tendoj kaj paŝtas brutojn. ");
INSERT INTO epo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kaj la nomo de lia frato estis Jubal; li estis la patro de ĉiuj, kiuj ludas harpon kaj fluton. ");
INSERT INTO epo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Cila ankaŭ naskis Tubal-Kainon, forĝanton de diversaj majstraĵoj el kupro kaj fero. Kaj la fratino de Tubal-Kain estis Naama. ");
INSERT INTO epo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kaj Lemeĥ diris al siaj edzinoj Ada kaj Cila: Aŭskultu mian voĉon, edzinoj de Lemeĥ, Atentu mian parolon! Ĉar viron mi mortigis por vundo al mi Kaj junulon por tubero al mi; ");
INSERT INTO epo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Se sepoble estos venĝite por Kain, Por Lemeĥ estos sepdek-sepoble. ");
INSERT INTO epo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kaj denove Adam ekkonis sian edzinon, kaj ŝi naskis filon, kaj donis al li la nomon Set: Ĉar Dio metis al mi alian semon anstataŭ Habel, kiun mortigis Kain. ");
INSERT INTO epo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kaj al Set ankaŭ naskiĝis filo, kaj li donis al li la nomon Enoŝ. Tiam oni komencis alvokadi la nomon de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Jen estas la libro de naskoj de Adam. Kiam Dio kreis la homon, Li faris lin laŭ la bildo de Dio; ");
INSERT INTO epo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","kiel viron kaj virinon Li kreis ilin, kaj Li benis ilin kaj donis al ili la nomon Homo en la tago de ilia naskiĝo. ");
INSERT INTO epo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kaj Adam vivis cent tridek jarojn, kaj al li naskiĝis filo laŭ lia bildo kaj simileco, kaj li donis al li la nomon Set. ");
INSERT INTO epo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Kaj Adam vivis, post kiam naskiĝis al li Set, okcent jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Kaj la tuta vivo, kiun travivis Adam, estis naŭcent tridek jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kaj Set vivis cent kvin jarojn, kaj naskiĝis al li Enoŝ. ");
INSERT INTO epo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Kaj Set vivis, post kiam naskiĝis al li Enoŝ, okcent sep jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kaj la tuta vivo de Set estis naŭcent dek du jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kaj Enoŝ vivis naŭdek jarojn, kaj naskiĝis al li Kenan. ");
INSERT INTO epo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kaj Enoŝ vivis, post kiam naskiĝis al li Kenan, okcent dek kvin jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kaj la tuta vivo de Enoŝ estis naŭcent kvin jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kaj Kenan vivis sepdek jarojn, kaj naskiĝis al li Mahalalel. ");
INSERT INTO epo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kaj Kenan vivis, post kiam naskiĝis al li Mahalalel, okcent kvardek jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kaj la tuta vivo de Kenan estis naŭcent dek jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kaj Mahalalel vivis sesdek kvin jarojn, kaj naskiĝis al li Jared. ");
INSERT INTO epo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kaj Mahalalel vivis, post kiam naskiĝis al li Jared, okcent tridek jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kaj la tuta vivo de Mahalalel estis okcent naŭdek kvin jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kaj Jared vivis cent sesdek du jarojn, kaj naskiĝis al li Ĥanoĥ. ");
INSERT INTO epo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kaj Jared vivis, post kiam naskiĝis al li Ĥanoĥ, okcent jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kaj la tuta vivo de Jared estis naŭcent sesdek du jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kaj Ĥanoĥ vivis sesdek kvin jarojn, kaj naskiĝis al li Metuŝelaĥ. ");
INSERT INTO epo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Kaj Ĥanoĥ iradis kun Dio, post kiam naskiĝis al li Metuŝelaĥ, tricent jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Kaj la tuta vivo de Ĥanoĥ estis tricent sesdek kvin jaroj. ");
INSERT INTO epo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Kaj Ĥanoĥ iradis kun Dio; kaj li malaperis, ĉar Dio lin prenis. ");
INSERT INTO epo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Kaj Metuŝelaĥ vivis cent okdek sep jarojn, kaj naskiĝis al li Lemeĥ. ");
INSERT INTO epo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kaj Metuŝelaĥ vivis, post kiam naskiĝis al li Lemeĥ, sepcent okdek du jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kaj la tuta vivo de Metuŝelaĥ estis naŭcent sesdek naŭ jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kaj Lemeĥ vivis cent okdek du jarojn, kaj naskiĝis al li filo. ");
INSERT INTO epo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kaj li donis al li la nomon Noa, dirante: Ĉi tiu konsolos nin en niaj faroj kaj en la laboroj de niaj manoj sur la tero, kiun la Eternulo malbenis. ");
INSERT INTO epo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Kaj Lemeĥ vivis, post kiam naskiĝis al li Noa, kvincent naŭdek kvin jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kaj la tuta vivo de Lemeĥ estis sepcent sepdek sep jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kaj Noa havis la aĝon de kvincent jaroj, kaj al Noa naskiĝis Ŝem, Ĥam, kaj Jafet. ");
INSERT INTO epo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kaj kiam la homoj komencis multiĝi sur la tero kaj al ili naskiĝis filinoj, ");
INSERT INTO epo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","tiam la filoj de Dio vidis la filinojn de la homoj, ke ili estas belaj; kaj ili prenis al si edzinojn el ĉiuj, kiujn ili elektis. ");
INSERT INTO epo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kaj la Eternulo diris: Ne regos Mia spirito inter la homoj eterne, pro iliaj pekoj, ĉar ili estas karno; ilia vivo estu cent dudek jaroj. ");
INSERT INTO epo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Gigantoj estis sur la tero en tiu tempo, eĉ post kiam la filoj de Dio venis al la filinoj de la homoj kaj ĉi tiuj naskis al ili. Tio estis la fortuloj, tre famaj de plej antikva tempo. ");
INSERT INTO epo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kaj la Eternulo vidis, ke granda estas la malboneco de la homoj sur la tero kaj ke ĉiuj pensoj kaj intencoj de iliaj koroj estas nur malbono en ĉiu tempo; ");
INSERT INTO epo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","tiam la Eternulo pentis, ke Li kreis la homon sur la tero, kaj Li afliktiĝis en Sia koro. ");
INSERT INTO epo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kaj la Eternulo diris: Mi ekstermos de sur la tero la homon, kiun Mi kreis, de la homo ĝis la brutoj, ĝis la rampaĵoj, kaj ĝis la birdoj de la ĉielo; ĉar Mi pentas, ke Mi ilin kreis. ");
INSERT INTO epo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Sed Noa akiris plaĉon en la okuloj de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Jen estas la historio de Noa: Noa estis homo virta kaj senmakula en sia generacio; kun Dio Noa iradis. ");
INSERT INTO epo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Kaj naskiĝis al Noa tri filoj: Ŝem, Ĥam, kaj Jafet. ");
INSERT INTO epo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Kaj la tero malvirtiĝis antaŭ Dio, kaj la tero pleniĝis de maljustaĵoj. ");
INSERT INTO epo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kaj Dio vidis la teron, ke ĝi malvirtiĝis, ĉar ĉiu karno malvirtigis sian vojon sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kaj Dio diris al Noa: La fino de ĉiu karno venis antaŭ Min, ĉar la tero pleniĝis de maljustaĵoj per ili, kaj jen Mi pereigos ilin kun la tero. ");
INSERT INTO epo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Faru al vi arkeon el ligno gofera; apartaĵojn faru en la arkeo, kaj ŝmiru ĝin per peĉo interne kaj ekstere. ");
INSERT INTO epo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kaj faru ĝin tiamaniere: tricent ulnoj estu la longo de la arkeo, kvindek ulnoj ĝia larĝo, kaj tridek ulnoj ĝia alto. ");
INSERT INTO epo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Fenestron faru en la arkeo, supre, kun la alto de unu ulno, kaj la pordon de la arkeo vi faros en la flanko; malsupran spacon, duan spacon, kaj trian spacon faru en ĝi. ");
INSERT INTO epo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kaj jen Mi venigos akvan diluvon sur la teron, por ekstermi ĉiun karnon, kiu havas en si spiriton de vivo sub la ĉielo; ĉio, kio estas sur la tero, pereos. ");
INSERT INTO epo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kaj Mi starigos Mian interligon kun vi; kaj vi eniros en la arkeon, vi kaj viaj filoj kaj via edzino kaj la edzinoj de viaj filoj kune kun vi. ");
INSERT INTO epo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kaj el ĉiuj vivaĵoj, el ĉiu karno, enkonduku po unu paro el ĉiuj en la arkeon, ke ili restu vivaj kun vi; virbesto kaj virinbesto ili estu. ");
INSERT INTO epo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","El la birdoj laŭ iliaj specoj, kaj el la brutoj laŭ iliaj specoj, el ĉiuj rampaĵoj de la tero laŭ iliaj specoj, po paro el ĉiuj eniru kun vi, por resti vivaj. ");
INSERT INTO epo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kaj vi prenu al vi el ĉiuj manĝaĵoj, kiuj estas manĝataj, kaj kolektu al vi; kaj ĝi estu por vi kaj por ili por manĝi. ");
INSERT INTO epo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kaj Noa tion faris; ĉion, kiel Dio al li ordonis, tiel li faris. ");
INSERT INTO epo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kaj la Eternulo diris al Noa: Eniru vi kaj via tuta familio en la arkeon, ĉar vin Mi vidis, ke vi estas virtulo antaŭ Mi en ĉi tiu generacio. ");
INSERT INTO epo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","El ĉiuj brutoj puraj prenu al vi po sep paroj, virbestojn kaj iliajn inojn; kaj el la brutoj, kiuj ne estas puraj, po du, virbeston kaj ĝian inon. ");
INSERT INTO epo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ankaŭ el la birdoj de la ĉielo po sep paroj, virbestojn kaj virinbestojn, por ke semo restu sur la tuta tero. ");
INSERT INTO epo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ĉar post sep tagoj Mi pluvigos sur la teron dum kvardek tagoj kaj kvardek noktoj, kaj Mi ekstermos de sur la tero ĉiujn ekzistaĵojn, kiujn Mi kreis. ");
INSERT INTO epo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kaj Noa faris ĉion, kion la Eternulo al li ordonis. ");
INSERT INTO epo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kaj Noa havis la aĝon de sescent jaroj, kiam la akva diluvo venis sur la teron. ");
INSERT INTO epo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kaj eniris Noa kaj liaj filoj kaj lia edzino kaj la edzinoj de liaj filoj kune kun li en la arkeon, pro la akvo de la diluvo. ");
INSERT INTO epo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","El la brutoj puraj, kaj el la brutoj, kiuj ne estas puraj, kaj el la birdoj, kaj el ĉiuj rampaĵoj sur la tero, ");
INSERT INTO epo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","po unu paro venis al Noa en la arkeon, virbesto kaj ino, kiel Dio ordonis al Noa. ");
INSERT INTO epo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kaj kiam pasis la sep tagoj, la diluva akvo venis sur la teron. ");
INSERT INTO epo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","En la sescenta jaro de la vivo de Noa, en la dua monato, en la dek-sepa tago de la monato, en tiu tago disfendiĝis ĉiuj fontoj de la granda abismo kaj la aperturoj de la ĉielo malfermiĝis. ");
INSERT INTO epo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kaj estis pluvo sur la tero dum kvardek tagoj kaj kvardek noktoj. ");
INSERT INTO epo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ĝuste en tiu tago eniris en la arkeon Noa, kaj Ŝem kaj Ĥam kaj Jafet, la filoj de Noa, kaj la edzino de Noa, kaj la tri edzinoj de liaj filoj kune kun ili; ");
INSERT INTO epo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ili, kaj ĉiuj bestoj laŭ siaj specoj, kaj ĉiuj brutoj laŭ siaj specoj, kaj ĉiuj rampaĵoj, kiuj rampas sur la tero, laŭ siaj specoj, kaj ĉiuj flugaĵoj laŭ siaj specoj, ĉiuj birdoj, ĉiuj flugilhavantoj. ");
INSERT INTO epo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Kaj eniris al Noa en la arkeon po du el ĉiu karno, kiu havas en si spiriton de vivo. ");
INSERT INTO epo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kaj la venintoj, virbesto kaj ino el ĉiu karno, eniris, kiel ordonis al ili Dio; kaj la Eternulo fermis post ili. ");
INSERT INTO epo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kaj estis diluvo dum kvardek tagoj sur la tero; kaj multiĝis la akvo kaj levis la arkeon, kaj ĝi estis alte super la tero. ");
INSERT INTO epo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kaj la akvo fortiĝis sur la tero, kaj la arkeo naĝis sur la supraĵo de la akvo. ");
INSERT INTO epo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kaj la akvo treege fortiĝis kaj tre multiĝis sur la tero; kaj kovriĝis ĉiuj altaj montoj, kiuj estas sub la ĉielo. ");
INSERT INTO epo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dek kvin ulnojn pli alte leviĝis la akvo kaj kovris la montojn. ");
INSERT INTO epo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kaj pereis ĉiu karno, kiu moviĝas sur la tero, la birdoj kaj la brutoj kaj la bestoj, kaj ĉiuj rampaĵoj, kiuj rampas sur la tero, kaj ĉiuj homoj. ");
INSERT INTO epo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ĉio, kio havis en si spiriton de vivo, el ĉio, kio estis sur la seka tero, mortis. ");
INSERT INTO epo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kaj ekstermiĝis ĉiuj ekzistaĵoj, kiuj estis sur la tero, de homo ĝis brutoj kaj rampaĵoj kaj birdoj de la ĉielo; ili ekstermiĝis de sur la tero; kaj restis nur Noa kaj kio estis kun li en la arkeo. ");
INSERT INTO epo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kaj la akvo okupis la teron dum cent kvindek tagoj. ");
INSERT INTO epo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kaj Dio rememoris Noan, kaj ĉiujn bestojn kaj ĉiujn brutojn, kiuj estis kun li en la arkeo; kaj Dio venigis venton sur la teron, kaj la akvo kvietiĝis. ");
INSERT INTO epo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kaj fermiĝis la fontoj de la abismo kaj la aperturoj de la ĉielo, kaj ĉesiĝis la pluvo el la ĉielo. ");
INSERT INTO epo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kaj iom post iom reforiĝis la akvo de sur la tero, kaj la akvo komencis malmultiĝi post la paso de cent kvindek tagoj. ");
INSERT INTO epo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kaj la arkeo haltis en la sepa monato, en la dek-sepa tago de la monato, sur la montoj Ararat. ");
INSERT INTO epo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kaj la akvo konstante malpliiĝadis ĝis la deka monato; en la unua tago de la deka monato montriĝis la suproj de la montoj. ");
INSERT INTO epo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kaj post kvardek tagoj Noa malfermis la fenestron de la arkeo, kiun li faris. ");
INSERT INTO epo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Kaj li ellasis korvon, kaj ĝi elflugis, forflugadis kaj revenadis, ĝis forsekiĝis la akvo sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kaj li ellasis de si kolombon, por vidi, ĉu jam malfortiĝis la akvo sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Sed la kolombo ne trovis ripozejon por siaj piedoj, kaj ĝi revenis al li en la arkeon, ĉar akvo estis sur la supraĵo de la tuta tero. Kaj li etendis sian manon kaj prenis la kolombon kaj envenigis ĝin al si en la arkeon. ");
INSERT INTO epo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Kaj li atendis ankoraŭ aliajn sep tagojn, kaj li denove ellasis la kolombon el la arkeo. ");
INSERT INTO epo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kaj revenis al li la kolombo en tempo vespera, kaj jen ĝi havis en sia buŝo deŝiritan folion de olivarbo; kaj Noa konvinkiĝis, ke la akvo malfortiĝis sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kaj li atendis ankoraŭ aliajn sep tagojn, kaj li ellasis la kolombon, kaj ĉi tiu jam ne plu revenis al li. ");
INSERT INTO epo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kaj en la sescent-unua jaro, en la unua tago de la unua monato, forsekiĝis la akvo sur la tero; kaj Noa malfermis la tegmenton de la arkeo, kaj li vidis, ke sekiĝis la supraĵo de la tero. ");
INSERT INTO epo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kaj en la dua monato, en la dudek-sepa tago de la monato, la tero elsekiĝis. ");
INSERT INTO epo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kaj Dio diris al Noa jene: ");
INSERT INTO epo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Eliru el la arkeo, vi kaj via edzino kaj viaj filoj kaj la edzinoj de viaj filoj kune kun vi; ");
INSERT INTO epo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ĉiujn bestojn, kiuj estas kun vi, el ĉiu karno, el la birdoj kaj brutoj, kaj el ĉiuj rampaĵoj, kiuj rampas sur la tero, elirigu kune kun vi; kaj ili moviĝu sur la tero kaj fruktu kaj multiĝu sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kaj eliris Noa kaj liaj filoj kaj lia edzino kaj la edzinoj de liaj filoj kune kun li. ");
INSERT INTO epo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ĉiuj bestoj, ĉiuj rampaĵoj, kaj ĉiuj birdoj, ĉio, kio moviĝas sur la tero, laŭ siaj familioj, eliris el la arkeo. ");
INSERT INTO epo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kaj Noa konstruis altaron al la Eternulo, kaj li prenis el ĉiuj puraj brutoj kaj el ĉiuj puraj birdoj kaj oferis bruloferojn sur la altaro. ");
INSERT INTO epo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kaj la Eternulo flaris la agrablan odoron, kaj la Eternulo diris en Sia koro: Mi ne plu malbenos la teron pro la homo, ĉar la penso de la homa koro estas malbona jam de lia juneco; kaj Mi ne batos plu ĉion vivantan, kiel Mi faris. ");
INSERT INTO epo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","De nun tiel longe, kiel la tero ekzistos, semado kaj rikoltado, malvarmo kaj varmo, somero kaj vintro, tago kaj nokto ne ĉesiĝos. ");
INSERT INTO epo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kaj Dio benis Noan kaj liajn filojn, kaj diris al ili: Fruktu kaj multiĝu, kaj plenigu la teron. ");
INSERT INTO epo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kaj ili timu vin kaj tremu antaŭ vi, ĉiuj bestoj de la tero kaj ĉiuj birdoj de la ĉielo, ĉio, kio moviĝas sur la tero, kaj ĉiuj fiŝoj de la maro; en viajn manojn ili estas transdonitaj. ");
INSERT INTO epo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ĉio, kio moviĝas kaj vivas, servu al vi kiel manĝaĵo; kiel verdan herbon, Mi donis al vi ĉion. ");
INSERT INTO epo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nur karnon kune kun ĝia animo, la sango, ne manĝu. ");
INSERT INTO epo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ankaŭ vian sangon kaj animon Mi repostulos, el la manoj de ĉiuj bestoj Mi ĝin repostulos, kaj el la manoj de homo, el la manoj de ĉiu homo pro lia frato Mi repostulos la animon de homo. ");
INSERT INTO epo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Se iu verŝos sangon de homo, lia sango ankaŭ estos verŝita de homo; ĉar laŭ la bildo de Dio estas farita la homo. ");
INSERT INTO epo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kaj vi fruktu kaj multiĝu, moviĝadu sur la tero kaj multiĝu sur ĝi. ");
INSERT INTO epo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kaj Dio diris al Noa kaj al liaj filoj kune kun li jene: ");
INSERT INTO epo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Jen Mi starigas Mian interligon kun vi kaj kun via idaro post vi; ");
INSERT INTO epo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kaj kun ĉiu viva ekzistaĵo, kiu estas kun vi, el birdoj, el brutoj, kaj el ĉiuj bestoj de la tero kun vi, el ĉiuj, kiuj eliris el la arkeo, kun ĉiuj bestoj de la tero. ");
INSERT INTO epo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kaj Mi starigas Mian interligon kun vi, ke ne ekstermiĝos plu ĉiu karno per akvo de diluvo, kaj ne estos plu diluvo, por pereigi la teron. ");
INSERT INTO epo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kaj Dio diris: Ĉi tio estas la signo de la interligo, kiun Mi metas inter Mi kaj inter vi kaj inter ĉiu viva ekzistaĵo, kiu estas kun vi, por eternaj generacioj: ");
INSERT INTO epo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mian arkon Mi metas en la nubon, kaj ĝi estu signo de la interligo inter Mi kaj la tero. ");
INSERT INTO epo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kaj kiam Mi venigos nubon super la teron, montriĝos la arko en la nubo; ");
INSERT INTO epo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kaj Mi rememoros Mian interligon, kiu ekzistas inter Mi kaj vi kaj ĉiu viva ekzistaĵo el ĉiu karno, kaj la akvo ne fariĝos plu diluvo, por pereigi ĉiun karnon. ");
INSERT INTO epo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kaj la arko estos en la nubo; kaj Mi ĝin vidos, por memori pri la eterna interligo inter Dio kaj ĉiu viva ekzistaĵo el ĉiu karno, kiu estas sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kaj Dio diris al Noa: Ĉi tio estas la signo de la interligo, kiun Mi starigis inter Mi kaj ĉiu karno, kiu estas sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kaj la filoj de Noa, kiuj eliris el la arkeo, estis: Ŝem, Ĥam, kaj Jafet; kaj Ĥam estis la patro de Kanaan. ");
INSERT INTO epo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tio estis la tri filoj de Noa; kaj de ili diskreskis la tuta loĝantaro de la tero. ");
INSERT INTO epo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Kaj Noa komencis terkultivan laboron kaj plantis vinberĝardenon. ");
INSERT INTO epo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kaj li trinkis el la vino kaj ebriiĝis, kaj nudiĝis en sia tendo. ");
INSERT INTO epo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kaj Ĥam, la patro de Kanaan, vidis la nudecon de sia patro, kaj li diris tion al siaj du fratoj ekstere. ");
INSERT INTO epo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kaj Ŝem kaj Jafet prenis la veston kaj metis ĝin sur siajn ŝultrojn, kaj iris dorsdirekte kaj kovris la nudecon de sia patro; kaj iliaj vizaĝoj estis turnitaj malantaŭen, kaj la nudecon de sia patro ili ne vidis. ");
INSERT INTO epo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kaj Noa vekiĝis de sia ebrieco, kaj li sciiĝis, kiel agis kun li lia pli juna filo. ");
INSERT INTO epo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kaj li diris: Malbenita estu Kanaan; Sklavo de sklavoj li estu ĉe siaj fratoj. ");
INSERT INTO epo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Glorata estu la Eternulo, la Dio de Ŝem; Kaj Kanaan estu sklavo al ili; ");
INSERT INTO epo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dio disvastigu Jafeton, Kaj li loĝu en la tendoj de Ŝem, Kaj Kanaan estu sklavo al ili. ");
INSERT INTO epo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kaj Noa vivis post la diluvo tricent kvindek jarojn. ");
INSERT INTO epo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kaj la tuta vivo de Noa estis naŭcent kvindek jaroj, kaj li mortis. ");
INSERT INTO epo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Jen estas la generaciaro de la filoj de Noa: Ŝem, Ĥam, kaj Jafet. Kaj naskiĝis al ili filoj post la diluvo. ");
INSERT INTO epo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","La filoj de Jafet: Gomer kaj Magog kaj Madaj kaj Javan kaj Tubal kaj Meŝeĥ kaj Tiras. ");
INSERT INTO epo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kaj la filoj de Gomer: Aŝkenaz kaj Rifat kaj Togarma. ");
INSERT INTO epo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Kaj la filoj de Javan: Eliŝa kaj Tarŝiŝ, Kitim kaj Dodanim. ");
INSERT INTO epo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","De ĉi tiuj dissemiĝis la insuloj da popoloj en siaj landoj, ĉiu laŭ sia lingvo, laŭ siaj gentoj kaj nacioj. ");
INSERT INTO epo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kaj la filoj de Ĥam: Kuŝ kaj Micraim kaj Put kaj Kanaan. ");
INSERT INTO epo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kaj la filoj de Kuŝ: Seba kaj Ĥavila kaj Sabta kaj Raama kaj Sabteĥa; kaj la filoj de Raama; Ŝeba kaj Dedan. ");
INSERT INTO epo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kaj Kuŝ naskigis Nimrodon, kiu komencis esti potenca sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Li estis potenca ĉasisto antaŭ la Eternulo; tial oni diras: Kiel Nimrod, potenca ĉasisto antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kaj la komenco de lia regno estis Babel kaj Ereĥ kaj Akad kaj Kalne en la lando Ŝinar. ");
INSERT INTO epo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","El ĉi tiu lando li eliris en Asirion kaj konstruis la urbojn Nineve kaj Reĥobot kaj Kalaĥ, ");
INSERT INTO epo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kaj Resen inter Nineve kaj Kalaĥ (ĝi estis la granda urbo). ");
INSERT INTO epo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kaj Micraim naskigis la Ludidojn kaj la Anamidojn kaj la Lehabidojn kaj la Naftuĥidojn ");
INSERT INTO epo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","kaj la Patrusidojn kaj la Kasluĥidojn (de kiuj devenis la Filiŝtoj) kaj la Kaftoridojn. ");
INSERT INTO epo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kaj de Kanaan naskiĝis Cidon, lia unuenaskito, kaj Ĥet, ");
INSERT INTO epo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","kaj la Jebusidoj kaj la Amoridoj kaj la Girgaŝidoj ");
INSERT INTO epo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","kaj la Ĥividoj kaj la Arkidoj kaj la Sinidoj ");
INSERT INTO epo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","kaj la Arvadidoj kaj la Cemaridoj kaj la Ĥamatidoj; kaj poste la gentoj Kanaanaj disiĝis. ");
INSERT INTO epo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kaj la limoj de la Kanaanidoj estis de Cidon ĝis Gerar kaj Gaza, ĝis Sodom kaj Gomora, Adma kaj Ceboim ĝis Laŝa. ");
INSERT INTO epo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Tio estas la filoj de Ĥam laŭ siaj gentoj kaj lingvoj, en siaj landoj kaj nacioj. ");
INSERT INTO epo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Naskiĝis infanoj ankaŭ al Ŝem, la patro de ĉiuj Eberidoj, pli maljuna frato de Jafet. ");
INSERT INTO epo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","La filoj de Ŝem: Elam kaj Aŝur kaj Arpaĥŝad kaj Lud kaj Aram. ");
INSERT INTO epo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Kaj la filoj de Aram: Uc kaj Ĥul kaj Geter kaj Maŝ. ");
INSERT INTO epo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Kaj al Arpaĥŝad naskiĝis Ŝelaĥ, kaj al Ŝelaĥ naskiĝis Eber. ");
INSERT INTO epo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kaj al Eber naskiĝis du filoj: la nomo de unu estis Peleg, ĉar dum lia vivo dividiĝis la tero; kaj la nomo de lia frato estis Joktan. ");
INSERT INTO epo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kaj al Joktan naskiĝis Almodad kaj Ŝelef kaj Ĥacarmavet kaj Jeraĥ ");
INSERT INTO epo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","kaj Hadoram kaj Uzal kaj Dikla ");
INSERT INTO epo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","kaj Obal kaj Abimael kaj Ŝeba ");
INSERT INTO epo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","kaj Ofir kaj Ĥavila kaj Jobab. Ĉiuj ĉi tiuj estis filoj de Joktan. ");
INSERT INTO epo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kaj ilia loĝloko estis de Meŝa ĝis Sefar, la orienta monto. ");
INSERT INTO epo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tio estas la filoj de Ŝem laŭ siaj gentoj kaj lingvoj, en siaj landoj, laŭ siaj nacioj. ");
INSERT INTO epo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Tio estas la gentoj de la filoj de Noa, laŭ siaj generacioj, en siaj nacioj; kaj de ili disiĝis la popoloj sur la tero post la diluvo. ");
INSERT INTO epo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sur la tuta tero estis unu lingvo kaj unu parolmaniero. ");
INSERT INTO epo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kaj kiam ili ekiris de la oriento, ili trovis valon en la lando Ŝinar kaj tie ekloĝis. ");
INSERT INTO epo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kaj ili diris unu al alia: Venu, ni faru brikojn kaj ni brulpretigu ilin per fajro. Kaj la brikoj fariĝis por ili ŝtonoj, kaj la bitumo fariĝis por ili kalko. ");
INSERT INTO epo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kaj ili diris: Venu, ni konstruu al ni urbon, kaj turon, kies supro atingos la ĉielon, kaj ni akiru al ni gloron, antaŭ ol ni disiĝos sur la supraĵo de la tuta tero. ");
INSERT INTO epo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kaj la Eternulo malleviĝis, por vidi la urbon kaj la turon, kiujn konstruis la homidoj. ");
INSERT INTO epo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kaj la Eternulo diris: Jen estas unu popolo, kaj unu lingvon ili ĉiuj havas; kaj jen, kion ili komencis fari, kaj ili ne estos malhelpataj en ĉio, kion ili decidis fari. ");
INSERT INTO epo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ni malleviĝu do, kaj Ni konfuzu tie ilian lingvon, por ke unu ne komprenu la parolon de alia. ");
INSERT INTO epo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kaj la Eternulo disigis ilin de tie sur la supraĵon de la tuta tero, kaj ili ĉesis konstrui la urbon. ");
INSERT INTO epo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tial oni donis al ĝi la nomon Babel, ĉar tie la Eternulo konfuzis la lingvon de la tuta tero kaj de tie la Eternulo disigis ilin sur la supraĵon de la tuta tero. ");
INSERT INTO epo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Jen estas la generaciaro de Ŝem: Ŝem havis la aĝon de cent jaroj, kaj naskiĝis al li Arpaĥŝad, du jarojn post la diluvo. ");
INSERT INTO epo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Kaj Ŝem vivis post la naskiĝo de Arpaĥŝad kvincent jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kaj Arpaĥŝad vivis tridek kvin jarojn, kaj naskiĝis al li Ŝelaĥ. ");
INSERT INTO epo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kaj Arpaĥŝad vivis post la naskiĝo de Ŝelaĥ kvarcent tri jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kaj Ŝelaĥ vivis tridek jarojn, kaj naskiĝis al li Eber. ");
INSERT INTO epo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kaj Ŝelaĥ vivis post la naskiĝo de Eber kvarcent tri jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kaj Eber vivis tridek kvar jarojn, kaj naskiĝis al li Peleg. ");
INSERT INTO epo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kaj Eber vivis post la naskiĝo de Peleg kvarcent tridek jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kaj Peleg vivis tridek jarojn, kaj naskiĝis al li Reu. ");
INSERT INTO epo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kaj Peleg vivis post la naskiĝo de Reu ducent naŭ jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kaj Reu vivis tridek du jarojn, kaj naskiĝis al li Serug. ");
INSERT INTO epo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kaj Reu vivis post la naskiĝo de Serug ducent sep jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kaj Serug vivis tridek jarojn, kaj naskiĝis al li Naĥor. ");
INSERT INTO epo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kaj Serug vivis post la naskiĝo de Naĥor ducent jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kaj Naĥor vivis dudek naŭ jarojn, kaj naskiĝis al li Teraĥ. ");
INSERT INTO epo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kaj Naĥor vivis post la naskiĝo de Teraĥ cent dek naŭ jarojn, kaj naskiĝis al li filoj kaj filinoj. ");
INSERT INTO epo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kaj Teraĥ vivis sepdek jarojn, kaj naskiĝis al li Abram, Naĥor, kaj Haran. ");
INSERT INTO epo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Kaj jen estas la generaciaro de Teraĥ: al Teraĥ naskiĝis Abram, Naĥor, kaj Haran; kaj al Haran naskiĝis Lot. ");
INSERT INTO epo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kaj Haran mortis antaŭ sia patro Teraĥ en sia lando de naskiĝo, en Ur la Ĥaldea. ");
INSERT INTO epo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kaj Abram kaj Naĥor prenis al si edzinojn; la nomo de la edzino de Abram estis Saraj, kaj la nomo de la edzino de Naĥor estis Milka, filino de Haran, kiu estis la patro de Milka kaj la patro de Jiska. ");
INSERT INTO epo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Kaj Saraj estis senfrukta kaj ne havis infanon. ");
INSERT INTO epo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kaj Teraĥ prenis sian filon Abram kaj sian nepon Lot, filo de Haran, kaj sian bofilinon Saraj, edzino de lia filo Abram; kaj ili eliris kune el Ur la Ĥaldea, por iri en la landon Kanaanan; kaj ili venis ĝis Ĥaran kaj enloĝiĝis tie. ");
INSERT INTO epo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Kaj Teraĥ atingis la aĝon de ducent kvin jaroj, kaj Teraĥ mortis en Ĥaran. ");
INSERT INTO epo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kaj la Eternulo diris al Abram: Iru el via lando, el inter via parencaro, kaj el la domo de via patro, al la lando, kiun Mi montros al vi. ");
INSERT INTO epo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kaj Mi faros vin granda popolo, kaj Mi benos vin kaj grandigos vian nomon, kaj vi estos beno. ");
INSERT INTO epo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kaj Mi benos viajn benantojn, kaj viajn malbenantojn Mi malbenos, kaj beniĝos per vi ĉiuj gentoj de la tero. ");
INSERT INTO epo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kaj Abram iris, kiel la Eternulo diris al li, kaj kun li iris Lot. Kaj Abram havis la aĝon de sepdek kvin jaroj, kiam li eliris el Ĥaran. ");
INSERT INTO epo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kaj Abram prenis sian edzinon Saraj kaj sian nevon Lot, kaj ilian tutan havon, kiun ili akiris, kaj la homojn, kiujn ili akiris en Ĥaran; kaj ili eliris, por iri al la lando Kanaana; kaj ili venis en la landon Kanaanan. ");
INSERT INTO epo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kaj Abram trapasis la landon ĝis la loko Ŝeĥem, ĝis la kverko More; kaj la Kanaanidoj tiam loĝis en la lando. ");
INSERT INTO epo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kaj la Eternulo aperis al Abram, kaj diris: Al via idaro Mi donos ĉi tiun teron. Kaj li konstruis tie altaron al la Eternulo, kiu aperis al li. ");
INSERT INTO epo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kaj de tie li transloĝiĝis al la monto, kiu estas oriente de Bet-El, kaj aranĝis sian tendon tiamaniere, ke Bet-El estis okcidente kaj Aj oriente; kaj li konstruis tie altaron al la Eternulo kaj preĝadis al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kaj Abram iris pluen, ĉiam pluen al sudo. ");
INSERT INTO epo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kaj estis malsato en la lando. Kaj Abram malsupreniris Egiptujon, por tie loĝi kelktempe, ĉar malfacila estis la malsato en la lando. ");
INSERT INTO epo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kaj kiam li estis jam proksime de Egiptujo, li diris al sia edzino Saraj: Mi scias ja, ke vi estas virino belaspekta; ");
INSERT INTO epo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","kaj kiam la Egiptoj vin vidos, ili diros: Tio estas lia edzino; kaj ili mortigos min, kaj vin ili lasos viva. ");
INSERT INTO epo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Diru do, ke vi estas mia fratino, por ke al mi estu bone pro vi kaj por ke mia animo restu viva pro vi. ");
INSERT INTO epo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kaj kiam Abram venis Egiptujon, la Egiptoj vidis, ke la virino estas tre bela; ");
INSERT INTO epo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","kaj vidis ŝin la eminentuloj de Faraono, kaj ili laŭdis ŝin al Faraono; kaj oni prenis la virinon en la domon de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kaj al Abram estis bone pro ŝi, kaj li havis ŝafojn kaj bovojn kaj azenojn kaj sklavojn kaj sklavinojn kaj azeninojn kaj kamelojn. ");
INSERT INTO epo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kaj la Eternulo punis per grandaj suferoj Faraonon kaj lian domon pro Saraj, la edzino de Abram. ");
INSERT INTO epo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kaj Faraono alvokis Abramon, kaj diris: Kion vi faris al mi? kial vi ne diris al mi, ke ŝi estas via edzino? ");
INSERT INTO epo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","kial vi diris: Ŝi estas mia fratino? Kaj mi prenis ŝin al mi kiel edzinon. Kaj nun jen estas via edzino; prenu kaj foriru. ");
INSERT INTO epo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kaj Faraono ordonis pri li al homoj, kaj ili forkondukis lin kaj lian edzinon kaj lian tutan havon. ");
INSERT INTO epo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kaj Abram supreniris el Egiptujo, li kaj lia edzino, kaj ĉio, kio estis kun li, kaj kun li ankaŭ Lot, direktante sin al sudo. ");
INSERT INTO epo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Kaj Abram estis tre riĉa je brutoj, arĝento, kaj oro. ");
INSERT INTO epo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kaj li daŭrigis sian migradon de sudo ĝis Bet-El, ĝis la loko, kie antaŭe estis lia tendo inter Bet-El kaj Aj, ");
INSERT INTO epo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","al la loko de la altaro, kiun li tie faris antaŭe; kaj Abram tie preĝis al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Kaj ankaŭ Lot, kiu iris kun Abram, havis ŝafojn kaj bovojn kaj tendojn. ");
INSERT INTO epo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kaj ne sufiĉis por ili la tero, ke ili loĝu kune, ĉar ilia havo estis granda kaj ili ne povis loĝi kune. ");
INSERT INTO epo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kaj estis malpaco inter la paŝtistoj de la brutaro de Abram kaj la paŝtistoj de la brutaro de Lot; kaj la Kanaanidoj kaj Perizidoj tiam loĝis en la lando. ");
INSERT INTO epo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kaj Abram diris al Lot: Ne estu malpaco inter mi kaj vi kaj inter miaj paŝtistoj kaj viaj paŝtistoj, ĉar ni estas fratoj. ");
INSERT INTO epo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","La tuta tero estas ja antaŭ vi; apartiĝu do de mi: se vi iros maldekstren, mi iros dekstren; se vi iros dekstren, mi iros maldekstren. ");
INSERT INTO epo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kaj Lot levis siajn okulojn kaj vidis, ke la tuta ĉirkaŭaĵo de Jordan, antaŭ ol la Eternulo pereigis Sodomon kaj Gomoran, tuta estas akvumata kiel ĝardeno de la Eternulo, kiel la lando Egipta, ĝis Coar. ");
INSERT INTO epo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kaj Lot elektis al si la tutan ĉirkaŭaĵon de Jordan; kaj Lot ekiris orienten; kaj ili apartiĝis unu de la alia: ");
INSERT INTO epo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram enloĝiĝis en la lando Kanaana, kaj Lot enloĝiĝis en la urboj de la ĉirkaŭaĵo kaj starigis siajn tendojn ĝis Sodom. ");
INSERT INTO epo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Kaj la loĝantoj de Sodom estis malbonaj kaj tre pekaj kontraŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Kaj la Eternulo diris al Abram, post kiam Lot apartiĝis de li: Levu viajn okulojn, kaj rigardu de la loko, sur kiu vi nun estas, norden kaj suden kaj orienten kaj okcidenten; ");
INSERT INTO epo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ĉar la tutan teron, kiun vi vidas, Mi donos al vi kaj al via idaro por eterne. ");
INSERT INTO epo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kaj Mi faros vian idaron kiel polvo de la tero; se iu povos kalkuli la polvon de la tero, li kalkulos ankaŭ vian idaron. ");
INSERT INTO epo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Leviĝu, trairu la landon laŭlonge kaj laŭlarĝe, ĉar al vi Mi ĝin donos. ");
INSERT INTO epo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kaj Abram forprenis sian tendon, kaj iris kaj ekloĝis en la arbareto Mamre, kiu estas en Ĥebron; kaj li konstruis tie altaron al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kaj estis en la tempo de Amrafel, reĝo de Ŝinar, Arjoĥ, reĝo de Elasar, Kedorlaomer, reĝo de Elam, kaj Tidal, reĝo de Gojim; ");
INSERT INTO epo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ili faris militon kontraŭ Bera, reĝo de Sodom, kaj Birŝa, reĝo de Gomora, Ŝinab, reĝo de Adma, kaj Ŝemeber, reĝo de Ceboim, kaj la reĝo de Bela, kiu estas Coar. ");
INSERT INTO epo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ĉiuj ĉi tiuj kunvenis en la valo Sidim, kiu nun estas la Sala Maro. ");
INSERT INTO epo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dek du jarojn ili servis al Kedorlaomer, kaj en la dek-tria ili ribeliĝis. ");
INSERT INTO epo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kaj en la dek-kvara jaro venis Kedorlaomer, kaj la reĝoj, kiuj estis kun li, kaj ili venkobatis la Rafaidojn en Aŝterot-Karnaim, kaj la Zuzidojn en Ham, kaj la Emidojn en Ŝave-Kirjataim, ");
INSERT INTO epo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","kaj la Ĥoridojn sur ilia monto Seir ĝis El-Paran, kiu estas ĉe la dezerto. ");
INSERT INTO epo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kaj ili reiris kaj venis al En-Miŝpat, kiu estas Kadeŝ, kaj venkobatis la tutan kampon de la Amalekidoj, kaj ankaŭ la Amoridojn, kiuj loĝis en Ĥacacon-Tamar. ");
INSERT INTO epo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kaj eliris la reĝo de Sodom kaj la reĝo de Gomora kaj la reĝo de Adma kaj la reĝo de Ceboim, kaj la reĝo de Bela, kiu estas Coar, kaj komencis batalon kontraŭ ili en la valo Sidim, ");
INSERT INTO epo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kontraŭ Kedorlaomer, reĝo de Elam, kaj Tidal, reĝo de Gojim, kaj Amrafel, reĝo de Ŝinar, kaj Arjoĥ, reĝo de Elasar; kvar reĝoj kontraŭ kvin. ");
INSERT INTO epo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kaj en la valo Sidim estis multe da bitumaj kavoj; kaj la reĝoj de Sodom kaj Gomora forkuris kaj falis tien, kaj la restintoj kuris sur la monton. ");
INSERT INTO epo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kaj ili prenis la tutan havon de Sodom kaj Gomora kaj ilian tutan manĝeblaĵon, kaj foriris. ");
INSERT INTO epo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ili prenis Loton, la nevon de Abram, kaj lian havon, ĉar li loĝis en Sodom, kaj ili foriris. ");
INSERT INTO epo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kaj venis forsaviĝinto kaj diris al Abram la Hebreo, kiu loĝis en la arbareto de Mamre la Amorido, frato de Eŝkol kaj frato de Aner, kiuj estis en interligo kun Abram. ");
INSERT INTO epo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kaj Abram aŭdis, ke lia frato estas kaptita, kaj li elkondukis siajn ekzercitojn, naskitajn en lia domo, tricent dek ok, kaj persekutis ĝis Dan. ");
INSERT INTO epo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kaj li dividis sin kontraŭ ili en la nokto, li kaj liaj domanoj, kaj venkobatis ilin, kaj persekutis ilin ĝis Ĥoba, kiu estas maldekstre de Damasko. ");
INSERT INTO epo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kaj li revenigis la tutan havon, kaj ankaŭ sian fraton Lot kaj lian havon li revenigis, kaj ankaŭ la virinojn kaj la popolon. ");
INSERT INTO epo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kaj la reĝo de Sodom eliris al li renkonte, kiam li revenis, venkinte Kedorlaomeron kaj la reĝojn, kiuj estis kun li, en la valon Ŝave, kiu estas Valo de la Reĝo. ");
INSERT INTO epo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kaj Melkicedek, reĝo de Salem, elportis panon kaj vinon. Li estis pastro de Dio Plejsupra. ");
INSERT INTO epo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kaj li benis lin kaj diris: Benata estu Abram de Dio Plejsupra, la Kreinto de la ĉielo kaj la tero; ");
INSERT INTO epo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","kaj benata estu Dio Plejsupra, kiu transdonis viajn malamikojn en viajn manojn. Kaj Abram donis al li dekonaĵon el ĉio. ");
INSERT INTO epo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kaj la reĝo de Sodom diris al Abram: Donu al mi la homojn, kaj la havon prenu al vi. ");
INSERT INTO epo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kaj Abram diris al la reĝo de Sodom: Mi levas mian manon al la Eternulo, Dio Plejsupra, la Kreinto de la ĉielo kaj la tero, ");
INSERT INTO epo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ke eĉ fadenon aŭ rimenon de ŝuo mi ne prenos el ĉio, kio apartenas al vi, por ke vi ne diru: Mi riĉigis Abramon; ");
INSERT INTO epo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","escepto estos nur tio, kion manĝis la junuloj, kaj la parto de la homoj, kiuj iris kun mi: Aner, Eŝkol, kaj Mamre; ili prenu sian parton. ");
INSERT INTO epo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Post tiuj fariĝoj la Eternulo diris al Abram en vizio jene: Ne timu, Abram, Mi estas via ŝildo; via rekompenco estas tre granda. ");
INSERT INTO epo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kaj Abram diris: Ho Eternulo, mia Sinjoro, kion Vi donos al mi? mi vagas ja seninfane, kaj la administranto de mia domo estas Eliezer el Damasko. ");
INSERT INTO epo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kaj Abram diris: Al mi Vi ne donis ja idaron, kaj jen mia domano estos mia heredanto. ");
INSERT INTO epo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kaj tiam la Eternulo diris al li jene: Ĉi tiu ne estos via heredanto; nur tiu, kiu eliros el via internaĵo, estos via heredanto. ");
INSERT INTO epo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kaj Li elirigis lin eksteren, kaj diris: Rigardu al la ĉielo kaj kalkulu la stelojn, se vi povas ilin kalkuli. Kaj Li diris al li: Tiel estos via idaro. ");
INSERT INTO epo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kaj li kredis al la Eternulo; kaj tio estis kalkulita al li kiel virto. ");
INSERT INTO epo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kaj Li diris al li: Mi estas la Eternulo, kiu elirigis vin el Ur la Ĥaldea, por doni al vi ĉi tiun landon kiel posedaĵon. ");
INSERT INTO epo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kaj li diris: Ho Eternulo, mia Sinjoro, per kio mi povas scii, ke mi ĝin posedos? ");
INSERT INTO epo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kaj Li diris al li: Prenu por Mi bovinon trijaran kaj kaprinon trijaran kaj ŝafon trijaran kaj turton kaj junan kolombon. ");
INSERT INTO epo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kaj li alportis al Li ĉion ĉi tion, kaj Li distranĉis ilin laŭ la mezo kaj metis ĉiujn partojn unu kontraŭ la alia, sed la birdojn Li ne distranĉis. ");
INSERT INTO epo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kaj la rabobirdoj malleviĝis sur la kadavrojn, sed Abram ilin forpelis. ");
INSERT INTO epo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ĉe la subiro de la suno profunda dormo falis sur Abramon; kaj jen timego pro la granda mallumo atakis lin. ");
INSERT INTO epo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kaj Li diris al Abram: Sciu, ke via idaro estos fremduloj en lando, kiu ne apartenos al ili; kaj oni sklavigos kaj turmentos ilin dum kvarcent jaroj. ");
INSERT INTO epo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tamen la popolon, ĉe kiu ili estos sklavoj, Mi juĝos; kaj poste ili eliros kun granda havo. ");
INSERT INTO epo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kaj vi foriros al viaj prapatroj en paco; vi estos entombigita en bona maljuneco. ");
INSERT INTO epo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kaj en la kvara generacio ili revenos ĉi tien; ĉar la krimoj de la Amoridoj ankoraŭ ne atingis plenecon. ");
INSERT INTO epo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kiam la suno subiris kaj fariĝis mallumo, subite forna fumo kaj fajra flamo trakuris inter tiuj distranĉitaĵoj. ");
INSERT INTO epo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","En tiu tago la Eternulo faris interligon kun Abram, dirante: Al via idaro Mi donos ĉi tiun landon, de la rivero de Egiptujo ĝis la granda rivero, la rivero Eŭfrato: ");
INSERT INTO epo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","la Kenidojn kaj la Kenizidojn kaj la Kadmonidojn ");
INSERT INTO epo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kaj la Ĥetidojn kaj la Perizidojn kaj la Rafaidojn ");
INSERT INTO epo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","kaj la Amoridojn kaj la Kanaanidojn kaj la Girgaŝidojn kaj la Jebusidojn. ");
INSERT INTO epo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Kaj Saraj, la edzino de Abram, ne naskis al li; sed ŝi havis sklavinon, Egiptinon, kies nomo estis Hagar. ");
INSERT INTO epo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kaj Saraj diris al Abram: Jen la Eternulo ŝlosis min, ke mi ne nasku; eniru do al mia sklavino, eble mi havos infanojn per ŝi. Kaj Abram obeis la voĉon de Saraj. ");
INSERT INTO epo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kaj Saraj, la edzino de Abram, prenis Hagaron la Egiptinon, sian sklavinon, kiam pasis dek jaroj de la tempo, kiam Abram ekloĝis en la lando Kanaana, kaj ŝi donis ŝin al sia edzo Abram kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kaj li venis al Hagar, kaj ŝi gravediĝis. Kaj ŝi vidis, ke ŝi gravediĝis, kaj tiam ŝia sinjorino senvaloriĝis en ŝiaj okuloj. ");
INSERT INTO epo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kaj Saraj diris al Abram: Vi estas maljusta kontraŭ mi; mi donis mian sklavinon en viajn brakojn, sed kiam ŝi vidis, ke ŝi gravediĝis, mi senvaloriĝis en ŝiaj okuloj; la Eternulo juĝu inter mi kaj vi. ");
INSERT INTO epo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kaj Abram diris al Saraj: Jen via sklavino estas en viaj manoj, faru kun ŝi ĉion, kio plaĉas al vi. Kaj Saraj komencis premi ŝin, kaj ŝi forkuris. ");
INSERT INTO epo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Kaj trovis ŝin anĝelo de la Eternulo ĉe akva fonto en la dezerto, ĉe la fonto sur la vojo al Ŝur. ");
INSERT INTO epo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kaj li diris: Hagar, sklavino de Saraj, de kie vi venas kaj kien vi iras? Kaj ŝi diris: De Saraj, mia sinjorino, mi forkuras. ");
INSERT INTO epo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kaj la anĝelo de la Eternulo diris al ŝi: Reiru al via sinjorino, kaj humiliĝu sub ŝiaj manoj. ");
INSERT INTO epo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kaj la anĝelo de la Eternulo diris al ŝi: Mi multigos vian idaron tiel, ke pro multeco oni ne povos ĝin kalkuli. ");
INSERT INTO epo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kaj la anĝelo de la Eternulo diris al ŝi: Jen vi estas graveda, kaj vi naskos filon; kaj vi donos al li la nomon Iŝmael, ĉar la Eternulo aŭdis vian suferon. ");
INSERT INTO epo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kaj li estos homo sovaĝa; lia mano estos kontraŭ ĉiuj, kaj la manoj de ĉiuj kontraŭ li, kaj li loĝos antaŭ ĉiuj siaj fratoj. ");
INSERT INTO epo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kaj la Eternulon, kiu parolis al ŝi, ŝi nomis: Dio-kiu-min-vidis; ĉar ŝi diris: Ĉi tie mi vidis Tiun, kiu min vidas; kaj ĉu mi poste vivas? ");
INSERT INTO epo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tial oni nomis tiun puton puto de la Vivanto-Vidanto; ĝi estas inter Kadeŝ kaj Bered. ");
INSERT INTO epo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kaj Hagar naskis al Abram filon; kaj Abram donis al sia filo, kiun naskis Hagar, la nomon Iŝmael. ");
INSERT INTO epo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Kaj Abram havis la aĝon de okdek ses jaroj, kiam Hagar naskis Iŝmaelon al Abram. ");
INSERT INTO epo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Kiam Abram havis la aĝon de naŭdek naŭ jaroj, aperis la Eternulo al Abram, kaj diris al li: Mi estas Dio la Plejpotenca; iradu antaŭ Mi kaj estu senpeka. ");
INSERT INTO epo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kaj Mi faros Mian interligon inter Mi kaj vi, kaj Mi multigos vin tre forte. ");
INSERT INTO epo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kaj Abram ĵetis sin vizaĝaltere, kaj Dio parolis al li, dirante: ");
INSERT INTO epo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Jen estas Mia interligo kun vi: vi estos patro de multe da popoloj. ");
INSERT INTO epo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kaj via nomo ne estos plu Abram, sed via nomo estos Abraham, ĉar Mi faris vin patro de multe da popoloj. ");
INSERT INTO epo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kaj Mi fruktigos vin tre multe, kaj Mi devenigos de vi popolojn, kaj reĝoj devenos de vi. ");
INSERT INTO epo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kaj Mi starigos Mian interligon inter Mi kaj vi kaj via idaro post vi en iliaj generacioj, eternan interligon, ke Mi estos Dio por vi kaj por via idaro post vi. ");
INSERT INTO epo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kaj Mi donos al vi kaj al via idaro post vi la landon, en kiu vi loĝas kiel fremdulo, la tutan landon Kanaanan, por eterna posedaĵo, kaj Mi estos Dio por ili. ");
INSERT INTO epo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kaj Dio diris al Abraham: Kaj vi gardu Mian interligon, vi kaj via idaro post vi en iliaj generacioj. ");
INSERT INTO epo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Jen estas Mia interligo, kiun vi devas gardi inter Mi kaj vi kaj via idaro post vi: ĉiu virseksulo ĉe vi estu cirkumcidata. ");
INSERT INTO epo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kaj cirkumcidu la karnon de via prepucio, kaj tio estu signo de interligo inter Mi kaj vi. ");
INSERT INTO epo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kaj en la aĝo de ok tagoj estu cirkumcidata ĉe vi en viaj generacioj ĉiu virseksulo naskita en la domo aŭ aĉetita per mono ĉe iu aligentulo, kiu ne estas el via idaro. ");
INSERT INTO epo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Cirkumcidata estu ĉiu naskita en via domo aŭ aĉetita per via mono, kaj Mia interligo estu sur via karno kiel interligo eterna. ");
INSERT INTO epo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kaj se estos prepucihava virseksulo, kiu ne cirkumcidos la karnon de sia prepucio, tiu animo ekstermiĝos el sia popolo: Mian interligon ĝi rompis. ");
INSERT INTO epo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kaj Dio diris al Abraham: Vian edzinon Saraj ne nomu Saraj, sed ŝia nomo estu Sara. ");
INSERT INTO epo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kaj Mi benos ŝin, kaj Mi donos de ŝi al vi filon; kaj Mi benos ŝin, kaj de ŝi devenos popoloj, reĝoj de popoloj devenos de ŝi. ");
INSERT INTO epo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kaj Abraham ĵetis sin vizaĝaltere, kaj ekridis, kaj diris en sia koro: Ĉu de homo centjara fariĝos nasko, kaj ĉu Sara la naŭdekjara naskos? ");
INSERT INTO epo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kaj Abraham diris al Dio: Ho, ke Iŝmael vivu antaŭ Vi! ");
INSERT INTO epo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kaj Dio diris: Efektive Sara, via edzino, naskos al vi filon, kaj vi donos al li la nomon Isaak; kaj Mi starigos Mian interligon kun li kiel interligon eternan por lia idaro post li. ");
INSERT INTO epo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ankaŭ pri Iŝmael Mi aŭdis vin: jen Mi benis lin, kaj Mi fruktigos lin kaj Mi multigos lin tre forte; dek du princoj naskiĝos de li, kaj Mi devenigos de li grandan popolon. ");
INSERT INTO epo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Sed Mian interligon Mi starigos kun Isaak, kiun naskos al vi Sara en ĉi tiu tempo en la venonta jaro. ");
INSERT INTO epo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kaj Li ĉesis paroli kun li, kaj Dio leviĝis for de Abraham. ");
INSERT INTO epo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kaj Abraham prenis sian filon Iŝmael kaj ĉiujn naskitajn en lia domo kaj ĉiujn aĉetitajn per lia mono, ĉiun virseksulon el la homoj de la domo de Abraham, kaj li cirkumcidis la karnon de ilia prepucio en tiu sama tago, kiel diris al li Dio. ");
INSERT INTO epo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Kaj Abraham havis la aĝon de naŭdek naŭ jaroj, kiam li cirkumcidis la karnon de sia prepucio. ");
INSERT INTO epo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Kaj lia filo Iŝmael havis la aĝon de dek tri jaroj, kiam la karno de lia prepucio estis cirkumcidita. ");
INSERT INTO epo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","En tiu sama tago estis cirkumciditaj Abraham kaj lia filo Iŝmael; ");
INSERT INTO epo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kaj ĉiuj liaj domanoj, kiuj naskiĝis en la domo aŭ estis aĉetitaj per mono ĉe aligentulo, estis cirkumciditaj kune kun li. ");
INSERT INTO epo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kaj aperis al li la Eternulo en la arbareto Mamre, kiam li sidis ĉe la pordo de la tendo dum la varmego de la tago. ");
INSERT INTO epo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kiam li levis siajn okulojn, li vidis, ke jen tri viroj staras antaŭ li. Ekvidinte, li kuris al ili renkonte de la pordo de la tendo kaj kliniĝis antaŭ ili ĝis la tero. ");
INSERT INTO epo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Kaj li diris: Mia sinjoro! se mi trovis plaĉon en viaj okuloj, ne pasu preter vian sklavon. ");
INSERT INTO epo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Oni alportos iom da akvo, kaj vi lavu viajn piedojn kaj ripozu sub la arbo. ");
INSERT INTO epo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kaj mi alportos pecon da pano, por ke vi fortigu viajn korojn; poste vi foriros; ĉar por tio vi pasis preter via sklavo. Kaj ili diris: Faru tiel, kiel vi diris. ");
INSERT INTO epo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kaj Abraham rapidis en la tendon al Sara, kaj diris: Rapide prenu tri mezurojn da plej bona faruno, knedu, kaj faru kukojn. ");
INSERT INTO epo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kaj ankaŭ al la bovoj Abraham kuris, kaj li prenis bovidon delikatan kaj bonan kaj donis al la junulo, kaj tiu rapide pretigis ĝin. ");
INSERT INTO epo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kaj li prenis buteron kaj lakton kaj la pretigitan bovidon kaj metis antaŭ ilin, kaj li staris apud ili sub la arbo, kaj ili manĝis. ");
INSERT INTO epo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kaj ili diris al li: Kie estas Sara, via edzino? Kaj li respondis: Jen ŝi estas en la tendo. ");
INSERT INTO epo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kaj Li diris: Mi revenos al vi en la sama jartempo, kaj tiam estos filo ĉe Sara, via edzino. Kaj Sara aŭskultis ĉe la pordo de la tendo, kiu estis malantaŭ Li. ");
INSERT INTO epo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Kaj Abraham kaj Sara estis maljunuloj de profunda aĝo; ĉe Sara ĉesiĝis la virinaj ordinaraĵoj. ");
INSERT INTO epo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kaj Sara ekridis interne, dirante: Ĉu kiam mi kadukiĝis, mi havus ankoraŭ volupton? kaj mia sinjoro estas ja maljuna! ");
INSERT INTO epo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kaj la Eternulo diris al Abraham: Kial do Sara ridas, dirante: Ĉu efektive mi naskos, kiam mi maljuniĝis? ");
INSERT INTO epo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ĉu por la Eternulo io estas malfacila? en la difinita tempo Mi revenos al vi en la venonta jaro, kaj Sara havos filon. ");
INSERT INTO epo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sed Sara malkonfesis, dirante: Mi ne ridis; ĉar ŝi timis. Sed Li diris: Ne, vi ridis. ");
INSERT INTO epo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kaj leviĝis de tie la viroj kaj direktiĝis al Sodom: kaj Abraham iris kun ili, por akompani ilin. ");
INSERT INTO epo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kaj la Eternulo diris: Ĉu mi kaŝos antaŭ Abraham, kion Mi faras? ");
INSERT INTO epo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham fariĝos ja popolo granda kaj potenca, kaj per li beniĝos ĉiuj popoloj de la tero. ");
INSERT INTO epo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ĉar Mi lin elektis, por ke li ordonu al siaj filoj kaj al sia domo post si, ke ili observu la vojon de la Eternulo, agante virte kaj juste; por ke la Eternulo plenumu pri Abraham, kion Li diris pri li. ");
INSERT INTO epo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kaj la Eternulo diris: Ĉar la kriado de Sodom kaj Gomora estas granda kaj ilia pekado estas tre peza, ");
INSERT INTO epo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","tial Mi malsupreniros, kaj rigardos, ĉu ili plene agas tiel, kiel estas la kriado, kiu venis al Mi, aŭ ne; Mi sciiĝos. ");
INSERT INTO epo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kaj la viroj turniĝis de tie kaj iris al Sodom; kaj Abraham staris ankoraŭ antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kaj Abraham alproksimiĝis, kaj diris: Ĉu Vi ankaŭ pereigos virtulon kune kun malvirtulo? ");
INSERT INTO epo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Eble ekzistas kvindek virtuloj en la urbo: ĉu Vi tiam pereigos kaj ne indulgos la lokon pro la kvindek virtuloj, kiuj estas en ĝi? ");
INSERT INTO epo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ne decas por Vi agi tiamaniere, ke Vi mortigu virtulon kune kun malvirtulo, ke virtulo estu kiel malvirtulo; ne decas por Vi, ke la Juĝanto de la tuta tero agu maljuste. ");
INSERT INTO epo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kaj la Eternulo diris: Se Mi trovos en Sodom kvindek virtulojn en la urbo, Mi indulgos la tutan lokon pro ili. ");
INSERT INTO epo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kaj Abraham respondis, dirante: Jen mi ekkuraĝis paroli al mia Sinjoro, kvankam mi estas polvo kaj cindro; ");
INSERT INTO epo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","eble al la kvindeko da virtuloj mankos kvin: ĉu Vi pereigos pro la kvin la tutan urbon? Kaj Li diris: Mi ne pereigos, se Mi trovos tie kvardek kvin. ");
INSERT INTO epo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kaj li plue parolis al Li kaj diris: Eble troviĝos tie kvardek? Kaj Li diris: Mi ne faros tion pro la kvardek. ");
INSERT INTO epo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kaj li diris: Ne koleru, mia Sinjoro, ke mi parolos plue: eble troviĝos tie tridek? Kaj Li diris: Mi ne faros, se Mi trovos tie tridek. ");
INSERT INTO epo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kaj li diris: Jen mi ekkuraĝis paroli al mia Sinjoro: eble troviĝos dudek? Kaj Li diris: Mi ne pereigos pro la dudek. ");
INSERT INTO epo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kaj li diris: Ne koleru, mia Sinjoro, ke mi parolos ankoraŭ nur unu fojon: eble troviĝos tie dek? Kaj Li diris: Mi ne pereigos pro la dek. ");
INSERT INTO epo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kaj la Eternulo foriris, kiam Li ĉesis paroli kun Abraham; kaj Abraham reiris al sia loko. ");
INSERT INTO epo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kaj la du anĝeloj venis Sodomon vespere, kaj Lot tiam sidis ĉe la pordego de Sodom. Kiam Lot ilin ekvidis, li leviĝis renkonte al ili kaj kliniĝis vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kaj li diris: Mi petas vin, sinjoroj, envenu en la domon de via sklavo kaj pasigu la nokton kaj lavu viajn piedojn, kaj vi leviĝos matene kaj iros vian vojon. Kaj ili diris: Ne, ni pasigos la nokton sur la strato. ");
INSERT INTO epo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kaj li tre petegis ilin, kaj ili direktis sin al li kaj envenis en lian domon; kaj li faris al ili festenon, kaj li bakis macojn, kaj ili manĝis. ");
INSERT INTO epo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Antaŭ ol ili kuŝiĝis, la homoj de la urbo, la homoj de Sodom, ĉirkaŭis la domon, de la junuloj ĝis la maljunuloj, la tuta popolo, de ĉiuj finoj. ");
INSERT INTO epo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kaj ili vokis Loton, kaj diris al li: Kie estas la viroj, kiuj venis al vi dum la nokto? elirigu ilin al ni, por ke ni ilin ekkonu. ");
INSERT INTO epo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kaj Lot eliris al ili antaŭ la sojlon, kaj la pordon li ŝlosis post si. ");
INSERT INTO epo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kaj li diris: Ho, miaj fratoj, ne agu malbone! ");
INSERT INTO epo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Jen mi havas du filinojn, kiuj ankoraŭ ne ekkonis viron; mi elirigos ilin al vi, kaj faru kun ili, kion vi deziras; nur al tiuj viroj nenion faru, ĉar por tio ili venis sub la ombron de mia tegmento. ");
INSERT INTO epo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sed ili diris: Iru for! Kaj ili diris plue: Vi venis ĉi tien kiel fremdulo, kaj vi volas juĝi! nun ni pli malbone agos kun vi, ol kun ili. Kaj ili tre insiste postulis de la viro, de Lot, kaj ili aliris, por elrompi la pordon. ");
INSERT INTO epo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tiam tiuj viroj etendis siajn manojn kaj envenigis Loton al si en la domon, kaj la pordon ili ŝlosis; ");
INSERT INTO epo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","kaj la homojn, kiuj estis antaŭ la sojlo de la domo, ili frapis per blindeco, de la malgrandaj ĝis la grandaj, tiel ke tiuj laciĝis, serĉante la pordon. ");
INSERT INTO epo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kaj la viroj diris al Lot: Kiun vi havas ĉi tie? bofilon, aŭ viajn filojn aŭ viajn filinojn, aŭ ĉiun ajn, kiun vi havas en la urbo, elirigu ilin el ĉi tiu loko; ");
INSERT INTO epo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ĉar ni ekstermos ĉi tiun lokon, ĉar granda fariĝis ilia kriado antaŭ la Eternulo, kaj la Eternulo sendis nin, por ĝin pereigi. ");
INSERT INTO epo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kaj Lot eliris, kaj parolis kun siaj bofiloj, prenontaj liajn filinojn, kaj diris: Leviĝu, eliru el ĉi tiu loko, ĉar la Eternulo pereigos la urbon. Sed liaj bofiloj rigardis lin kiel ŝercanton. ");
INSERT INTO epo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kiam leviĝis la matenruĝo, la anĝeloj rapidigis Loton, dirante: Leviĝu, prenu vian edzinon kaj ambaŭ viajn filinojn, kiuj ĉi tie troviĝas, por ke vi ne pereu pro la krimeco de la urbo. ");
INSERT INTO epo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Sed ĉar li malrapidis, tial la viroj kaptis lian manon kaj la manon de lia edzino kaj la manojn de liaj du filinoj, pro kompato de la Eternulo al li, kaj ili elirigis lin kaj metis lin ekster la urbon. ");
INSERT INTO epo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kaj kiam ili elkondukis lin eksteren, ili diris al li: Savu vin pro via animo; ne rigardu malantaŭen kaj haltu nenie en la tuta ĉirkaŭaĵo; sur la monton savu vin, por ke vi ne pereu. ");
INSERT INTO epo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kaj Lot diris al ili: Ho, ne, mia Sinjoro! ");
INSERT INTO epo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Jen Via sklavo plaĉis al Vi, kaj granda estas la favorkoreco, kiun Vi montris al mi, konservante la vivon al mia animo; sed mi ne povas savi min sur la monton, ĉar povus trafi min malfeliĉo kaj mi mortus. ");
INSERT INTO epo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Jen ĉi tiu urbo estas sufiĉe proksima, por kuri tien, kaj ĝi estas malgranda; mi savos min tien; ĝi estas ja malgranda; kaj mia animo restos viva. ");
INSERT INTO epo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kaj Li diris al li: Jen Mi komplezos al vi ankaŭ en ĉi tiu afero, kaj Mi ne renversos la urbon, pri kiu vi parolis. ");
INSERT INTO epo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Rapide savu vin tien, ĉar Mi nenion povas fari, ĝis vi venos tien. Tial tiu urbo ricevis la nomon Coar. ");
INSERT INTO epo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","La suno leviĝis super la teron, kiam Lot venis Coaron. ");
INSERT INTO epo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kaj la Eternulo pluvigis sur Sodomon kaj Gomoran sulfuron kaj fajron de la Eternulo el la ĉielo. ");
INSERT INTO epo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kaj Li ruinigis tiujn urbojn kaj la tutan ĉirkaŭaĵon kaj ĉiujn loĝantojn de la urboj kaj la kreskaĵojn de la tero. ");
INSERT INTO epo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kaj lia edzino ekrigardis malantaŭen, kaj ŝi fariĝis kolono el salo. ");
INSERT INTO epo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kaj matene Abraham leviĝis kaj iris al la loko, kie li estis starinta antaŭ la Eternulo; ");
INSERT INTO epo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","kaj li ekrigardis en la direkto al Sodom kaj Gomora kaj al la tuta lando de la ĉirkaŭaĵo, kaj li vidis, ke jen fumo leviĝas de la tero kiel fumo el forno. ");
INSERT INTO epo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kaj kiam Dio estis pereiganta la urbojn de la ĉirkaŭaĵo, Li rememoris pri Abraham, kaj Li elirigis Loton el la mezo de la ruinigado, kiam Li estis ruiniganta la urbojn, en kiuj loĝis Lot. ");
INSERT INTO epo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kaj Lot eliris el Coar kaj ekloĝis sur la monto, kaj liaj du filinoj kun li; ĉar li timis loĝi en Coar. Kaj li loĝis en kaverno, li kaj liaj du filinoj. ");
INSERT INTO epo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kaj la pli maljuna diris al la pli juna: Nia patro estas maljuna, kaj en la lando ne ekzistas viro, kiu envenus al ni laŭ la moro de la tuta tero; ");
INSERT INTO epo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","tial ni ebriigu nian patron per vino, kaj ni kuŝu kun li, por ke ni aperigu de nia patro idaron. ");
INSERT INTO epo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kaj ili ebriigis sian patron per vino en tiu nokto; kaj venis la pli maljuna kaj kuŝis kun sia patro; kaj li ne sciis, kiam ŝi kuŝiĝis kaj kiam ŝi leviĝis. ");
INSERT INTO epo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","La morgaŭan tagon la pli maljuna diris al la pli juna: Jen mi kuŝis hieraŭ kun mia patro; ni ebriigu lin per vino ankaŭ en ĉi tiu nokto, kaj vi venu, kuŝu kun li, por ke ni aperigu de nia patro idaron. ");
INSERT INTO epo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kaj ili ankaŭ en ĉi tiu nokto ebriigis sian patron per vino; kaj la pli juna iris kaj kuŝis kun li; kaj li ne sciis, kiam ŝi kuŝiĝis kaj kiam ŝi leviĝis. ");
INSERT INTO epo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kaj ambaŭ filinoj de Lot gravediĝis de sia patro. ");
INSERT INTO epo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kaj la pli maljuna naskis filon, kaj ŝi donis al li la nomon Moab; li estas la prapatro de la Moabidoj ĝis nun. ");
INSERT INTO epo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kaj la pli juna ankaŭ naskis filon, kaj ŝi donis al li la nomon Ben-Ami; li estas la prapatro de la Amonidoj ĝis nun. ");
INSERT INTO epo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kaj Abraham ekmigris de tie al la lando suda, kaj li ekloĝis inter Kadeŝ kaj Ŝur; kaj li loĝis kiel fremdulo en Gerar. ");
INSERT INTO epo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kaj Abraham diris pri sia edzino Sara: Ŝi estas mia fratino. Kaj Abimeleĥ, reĝo de Gerar, sendis kaj prenis Saran. ");
INSERT INTO epo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kaj Dio venis al Abimeleĥ nokte en la sonĝo, kaj diris al li: Vi mortos pro la virino, kiun vi prenis, ĉar ŝi estas edzino de edzo. ");
INSERT INTO epo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Sed Abimeleĥ ne alproksimiĝis al ŝi, kaj li diris: Mia Sinjoro! ĉu vi mortigos ankaŭ senkulpan popolon? ");
INSERT INTO epo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Li diris ja al mi: Ŝi estas mia fratino; kaj ŝi ankaŭ diris al mi: Li estas mia frato. En senkulpeco de mia koro kaj en pureco de miaj manoj mi faris tion. ");
INSERT INTO epo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kaj Dio diris al li en la sonĝo: Mi ankaŭ scias, ke en senkulpeco de via koro vi tion faris, kaj tial Mi detenis vin, ke vi ne peku kontraŭ Mi, tial Mi ne lasis, ke vi kuntuŝiĝu kun ŝi. ");
INSERT INTO epo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kaj nun redonu la edzinon al la edzo, ĉar li estas profeto, kaj li preĝos pri vi, kaj vi restos viva; sed se vi ne redonos, tiam sciu, ke vi mortos, vi kaj ĉiuj viaj. ");
INSERT INTO epo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kaj Abimeleĥ leviĝis frue matene, kaj li vokis ĉiujn siajn sklavojn kaj rakontis ĉion ĉi tion al iliaj oreloj; kaj la homoj tre ektimis. ");
INSERT INTO epo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kaj Abimeleĥ vokis Abrahamon, kaj diris al li: Kion vi faris al ni? kaj per kio mi pekis antaŭ vi, ke vi venigis sur min kaj sur mian regnon grandan pekon? aferojn, kiuj ne estas farataj, vi faris kontraŭ mi. ");
INSERT INTO epo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kaj Abimeleĥ diris al Abraham: Kion vi vidis, kiam vi faris tiun aferon? ");
INSERT INTO epo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kaj Abraham diris: Mi pensis, ke ne ekzistas timo antaŭ Dio en ĉi tiu loko, kaj ke oni mortigos min pro mia edzino. ");
INSERT INTO epo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Kaj efektive ŝi estas mia fratino, filino de mia patro, nur ne filino de mia patrino; kaj ŝi fariĝis mia edzino. ");
INSERT INTO epo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kaj kiam Dio elmigrigis min el la domo de mia patro, mi diris al ŝi: Faru al mi ĉi tiun komplezon, en kian ajn lokon ni venos, diru pri mi: Li estas mia frato. ");
INSERT INTO epo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kaj Abimeleĥ prenis ŝafojn kaj bovojn kaj sklavojn kaj sklavinojn kaj donis al Abraham, kaj li redonis al li lian edzinon Sara. ");
INSERT INTO epo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kaj Abimeleĥ diris: Jen mia lando estas antaŭ vi; kie plaĉas al vi, tie loĝiĝu. ");
INSERT INTO epo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kaj al Sara li diris: Jen mi donis mil arĝentajn monerojn al via frato; tio estu al vi kovro por la okuloj antaŭ ĉiuj, kiuj estas kun vi, kaj antaŭ ĉiuj vi estas pravigita. ");
INSERT INTO epo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kaj Abraham ekpreĝis al Dio; kaj Dio sanigis Abimeleĥon kaj lian edzinon kaj liajn sklavinojn, kaj ili komencis naski. ");
INSERT INTO epo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ĉar la Eternulo estis ŝlosinta ĉiujn uterojn en la domo de Abimeleĥ pro Sara, la edzino de Abraham. ");
INSERT INTO epo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Kaj la Eternulo rememoris Saran, kiel Li diris, kaj la Eternulo faris al Sara, kiel Li parolis. ");
INSERT INTO epo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kaj Sara gravediĝis kaj naskis al Abraham filon en lia maljuneco, en la difinita tempo, pri kiu Dio al li diris. ");
INSERT INTO epo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kaj Abraham donis al sia filo, kiu naskiĝis al li, kiun naskis al li Sara, la nomon Isaak. ");
INSERT INTO epo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kaj Abraham cirkumcidis sian filon Isaak, kiam tiu havis la aĝon de ok tagoj, kiel ordonis al li Dio. ");
INSERT INTO epo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Kaj Abraham havis la aĝon de cent jaroj, kiam naskiĝis al li lia filo Isaak. ");
INSERT INTO epo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kaj Sara diris: Ridindaĵon faris al mi Dio; ĉiu, kiu aŭdos, ridos pri mi. ");
INSERT INTO epo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kaj ŝi diris: Kiu dirus al Abraham, ke Sara mamnutros infanojn? ĉar mi naskis filon en lia maljuneco. ");
INSERT INTO epo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kaj la infano kreskis, kaj ĝi estis demamigita, kaj Abraham faris grandan festenon en la tago, en kiu Isaak estis demamigita. ");
INSERT INTO epo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kaj Sara vidis, ke la filo de Hagar la Egiptino, kiun ĉi tiu naskis al Abraham, mokas. ");
INSERT INTO epo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kaj ŝi diris al Abraham: Forpelu ĉi tiun sklavinon kaj ŝian filon; ĉar la filo de ĉi tiu sklavino ne heredos kun mia filo, kun Isaak. ");
INSERT INTO epo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kaj la afero forte malplaĉis al Abraham pro lia filo. ");
INSERT INTO epo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kaj Dio diris al Abraham: Ĝi ne malplaĉu al vi pro la knabo kaj pro via sklavino; pri ĉio, kion diros al vi Sara, obeu ŝian voĉon; ĉar per Isaak oni nomos vian idaron. ");
INSERT INTO epo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Sed ankaŭ el la filo de la sklavino Mi kreskigos popolon, ĉar li estas via semo. ");
INSERT INTO epo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kaj Abraham leviĝis frue matene, kaj prenis panon kaj felsakon kun akvo kaj donis al Hagar, metante ĝin sur ŝian ŝultron, ankaŭ la infanon, kaj foririgis ŝin; kaj ŝi iris, kaj ŝi erarvagis en la dezerto Beer-Ŝeba. ");
INSERT INTO epo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kaj konsumiĝis la akvo de la felsako, kaj ŝi ĵetis la infanon sub unu el la arbetaĵoj. ");
INSERT INTO epo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kaj ŝi iris kaj sidiĝis kontraŭe, en la malproksimeco de pafo el pafarko; ĉar ŝi diris: Mi ne povas rigardi la morton de la infano. Kaj ŝi sidiĝis kontraŭe, kaj ŝi komencis laŭte plori. ");
INSERT INTO epo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kaj Dio aŭdis la voĉon de la knabo; kaj anĝelo de Dio vokis Hagaron el la ĉielo, kaj diris al ŝi: Kio estas al vi, Hagar? ne timu, ĉar Dio aŭdis la voĉon de la knabo el la loko, kie li estas. ");
INSERT INTO epo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Leviĝu, prenu la knabon kaj tenu lin per via mano, ĉar grandan popolon Mi faros el li. ");
INSERT INTO epo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kaj Dio malfermis ŝiajn okulojn, kaj ŝi ekvidis puton kun akvo, kaj ŝi iris kaj plenigis la felsakon per akvo kaj trinkigis la knabon. ");
INSERT INTO epo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kaj Dio estis kun la knabo, kaj li grandiĝis kaj loĝis en la dezerto kaj fariĝis arkpafisto. ");
INSERT INTO epo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kaj li loĝis en la dezerto Paran; kaj lia patrino prenis al li edzinon el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kaj en tiu tempo Abimeleĥ kaj lia militestro Piĥol diris al Abraham jene: Dio estas kun vi en ĉio, kion vi faras; ");
INSERT INTO epo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","nun ĵuru do al mi per Dio, ke vi ne agos malfidele kun mi, nek kun mia filo, nek kun mia nepo; ke tiel same favorkore, kiel mi agis kun vi, vi agos kun mi, kaj kun la lando, en kiu vi loĝas kiel fremdulo. ");
INSERT INTO epo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kaj Abraham diris: Mi ĵuras. ");
INSERT INTO epo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kaj Abraham riproĉis Abimeleĥon pro la akva puto, kiun perforte forprenis la sklavoj de Abimeleĥ. ");
INSERT INTO epo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kaj Abimeleĥ diris: Mi ne scias, kiu faris tion, kaj ankaŭ vi ne diris al mi; mi eĉ ne aŭdis pri tio ĝis hodiaŭ. ");
INSERT INTO epo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kaj Abraham prenis ŝafojn kaj bovojn kaj donis al Abimeleĥ, kaj ili ambaŭ starigis inter si interligon. ");
INSERT INTO epo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Kaj Abraham starigis sep ŝafidojn aparte. ");
INSERT INTO epo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kaj Abimeleĥ diris al Abraham: Por kio estas tiuj sep ŝafidoj, kiujn vi starigis aparte? ");
INSERT INTO epo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Kaj tiu diris: Sep ŝafidojn prenu el mia mano, por ke ili estu por mi atesto, ke mi elfosis tiun puton. ");
INSERT INTO epo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tial tiu loko havas la nomon Beer-Ŝeba, ĉar tie ili ambaŭ ĵuris. ");
INSERT INTO epo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kaj ili starigis interligon en Beer-Ŝeba. Kaj Abimeleĥ kaj lia militestro Piĥol leviĝis kaj reiris en la landon de la Filiŝtoj. ");
INSERT INTO epo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kaj Abraham plantis tamariskon en Beer-Ŝeba, kaj preĝis tie al la Eternulo, la Dio eterna. ");
INSERT INTO epo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Kaj Abraham loĝis en la lando de la Filiŝtoj longan tempon. ");
INSERT INTO epo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Post tiuj okazintaĵoj Dio provis Abrahamon, kaj diris al li: Abraham! Kaj tiu respondis: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kaj Li diris: Prenu vian filon, vian solan, kiun vi amas, Isaakon, kaj iru en la landon Morija, kaj oferu lin tie kiel bruloferon sur unu el la montoj, kiun Mi montros al vi. ");
INSERT INTO epo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kaj Abraham leviĝis frue matene kaj selis sian azenon kaj prenis siajn du junulojn kun si kaj sian filon Isaak; kaj li fendis lignon por brulofero, kaj leviĝis kaj iris al tiu loko, pri kiu diris al li Dio. ");
INSERT INTO epo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","En la tria tago Abraham levis siajn okulojn kaj ekvidis la lokon de malproksime. ");
INSERT INTO epo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kaj Abraham diris al siaj junuloj: Restu ĉi tie kun la azeno, kaj mi kun la knabo iros tien, kaj ni adorkliniĝos kaj revenos al vi. ");
INSERT INTO epo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kaj Abraham prenis la lignon por la brulofero kaj metis ĝin sur sian filon Isaak, kaj li prenis en sian manon la fajron kaj la tranĉilon; kaj ili iris ambaŭ kune. ");
INSERT INTO epo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Kaj Isaak diris al sia patro Abraham: Mia patro! Kaj tiu respondis: Jen mi estas, mia filo. Kaj li diris: Jen estas la fajro kaj la ligno, sed kie estas la ŝafo por la brulofero? ");
INSERT INTO epo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kaj Abraham diris: Dio antaŭvidos al Si la ŝafon por la brulofero, mia filo. Kaj ili iris ambaŭ kune. ");
INSERT INTO epo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kaj ili venis al la loko, pri kiu diris al li Dio; kaj Abraham konstruis tie la altaron kaj surmetis la lignon, kaj ligis sian filon Isaak kaj metis lin sur la altaron super la ligno. ");
INSERT INTO epo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kaj Abraham etendis sian manon kaj prenis la tranĉilon, por buĉi sian filon. ");
INSERT INTO epo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kaj ekvokis al li anĝelo de la Eternulo el la ĉielo, kaj diris: Abraham, Abraham! Kaj li respondis: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kaj Tiu diris: Ne etendu vian manon sur la knabon, kaj faru al li nenion; ĉar nun Mi scias, ke vi timas Dion kaj vi ne indulgis pro Mi vian filon, la solan. ");
INSERT INTO epo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kaj Abraham levis siajn okulojn, kaj vidis, ke jen virŝafo malantaŭe implikiĝis per la kornoj en la arbetaĵoj. Kaj Abraham iris kaj prenis la virŝafon, kaj oferis ĝin kiel bruloferon anstataŭ sia filo. ");
INSERT INTO epo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kaj Abraham donis al tiu loko la nomon: La Eternulo Vidas; tial oni ankoraŭ nun diras: Sur la monto, kie la Eternulo aperas. ");
INSERT INTO epo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kaj denove anĝelo de la Eternulo vokis al Abraham el la ĉielo, ");
INSERT INTO epo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","kaj diris: Mi ĵuras per Mi, diras la Eternulo, ke ĉar vi faris tiun aferon kaj ne indulgis vian filon, la solan; ");
INSERT INTO epo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tial Mi benos vin kaj Mi multigos vian idaron simile al la steloj de la ĉielo kaj al la sablo sur la bordo de la maro; kaj via idaro posedos la pordegojn de siaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kaj beniĝos per via idaro ĉiuj popoloj de la tero, pro tio, ke vi obeis Mian voĉon. ");
INSERT INTO epo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kaj Abraham revenis al siaj junuloj, kaj ili leviĝis kaj iris kune al Beer-Ŝeba; kaj Abraham loĝis en Beer-Ŝeba. ");
INSERT INTO epo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Post tiuj okazintaĵoj oni sciigis al Abraham, dirante: Jen ankaŭ Milka naskis infanojn al via frato Naĥor: ");
INSERT INTO epo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","la unuenaskiton Uc, kaj lian fraton Buz, kaj Kemuelon, la patron de Aram; ");
INSERT INTO epo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","kaj Kesedon kaj Ĥazon kaj Pildaŝon kaj Jidlafon kaj Betuelon. ");
INSERT INTO epo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Kaj de Betuel naskiĝis Rebeka. Ĉi tiujn ok naskis Milka al Naĥor, la frato de Abraham. ");
INSERT INTO epo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kaj lia kromvirino, nome Reuma, ankaŭ naskis: Tebaĥon kaj Gaĥamon kaj Taĥaŝon kaj Maaĥan. ");
INSERT INTO epo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Kaj la vivo de Sara estis cent dudek sep jaroj; tiom estis la jaroj de la vivo de Sara. ");
INSERT INTO epo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kaj Sara mortis en Kirjat-Arba, kiu estas Ĥebron, en la lando Kanaana. Kaj Abraham venis, por funebri pri Sara kaj plori pri ŝi. ");
INSERT INTO epo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kaj Abraham leviĝis for de sia mortintino, kaj diris al la filoj de Ĥet jene: ");
INSERT INTO epo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Fremdulo kaj pasloĝanto mi estas ĉe vi; donu al mi posedotan lokon por tombo inter vi, por ke mi enterigu mian mortintinon, kiu estas antaŭ mi. ");
INSERT INTO epo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kaj la filoj de Ĥet respondis al Abraham, dirante al li: ");
INSERT INTO epo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Aŭskultu nin, nia sinjoro! vi estas princo de Dio inter ni; en la plej elektitaj niaj tomboj enterigu vian mortintinon; neniu el ni rifuzos al vi sian tomblokon, por enterigi vian mortintinon. ");
INSERT INTO epo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kaj Abraham leviĝis, kaj profunde kliniĝis antaŭ la popolo de la lando, antaŭ la filoj de Ĥet. ");
INSERT INTO epo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Kaj li diris al ili jene: Se plaĉas al vi, ke mi enterigu mian mortintinon, kiu estas antaŭ mi, tiam aŭskultu min kaj petu por mi Efronon, la filon de Coĥar, ");
INSERT INTO epo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ke li donu al mi la duoblan kavernon, kiun li havas en la fino de sia kampo; por plena sumo da mono li donu ĝin al mi inter vi por tomba posedaĵo. ");
INSERT INTO epo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kaj Efron sidis inter la filoj de Ĥet, kaj respondis Efron la Ĥetido al Abraham aŭdeble por la filoj de Ĥet, antaŭ ĉiuj, kiuj venis en la pordegon de lia urbo, dirante: ");
INSERT INTO epo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ne, mia sinjoro, aŭskultu min! la kampon mi donas al vi, kaj la kavernon, kiu estas sur ĝi, al vi mi donas, antaŭ la okuloj de la filoj de mia popolo mi donas ĝin al vi; enterigu vian mortintinon. ");
INSERT INTO epo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kaj Abraham profunde kliniĝis antaŭ la popolo de la lando. ");
INSERT INTO epo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Kaj li diris al Efron aŭdeble por la popolo de la lando jene: Mi petas, aŭskultu min: mi donas monon por la kampo; prenu de mi, kaj mi enterigos tie mian mortintinon. ");
INSERT INTO epo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kaj Efron respondis al Abraham, dirante al li: ");
INSERT INTO epo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mia sinjoro, aŭskultu min: la tero valoras kvarcent siklojn; sed kio ĝi estas inter mi kaj vi? enterigu vian mortintinon. ");
INSERT INTO epo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kaj Abraham aŭskultis Efronon, kaj Abraham pesis al Efron la monon, pri kiu li parolis aŭdeble por la filoj de Ĥet, kvarcent siklojn da arĝento, uzata en la komerco. ");
INSERT INTO epo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kaj la kampo de Efron kun la duobla kaverno, kiu estis antaŭ Mamre, la kampo kaj la kaverno sur ĝi kaj ĉiuj arboj sur la kampo, inter ĉiuj ĝiaj limoj ĉirkaŭe, fariĝis ");
INSERT INTO epo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","posedaĵo de Abraham antaŭ la okuloj de la filoj de Ĥet, de ĉiuj, kiuj venis en la pordegon de lia urbo. ");
INSERT INTO epo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kaj post tio Abraham enterigis sian edzinon Sara en la duobla kaverno de la kampo, antaŭ Mamre, kiu estas Ĥebron, en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kaj la kampo kaj la kaverno sur ĝi fariĝis tomba posedaĵo de Abraham, kiun li akiris de la filoj de Ĥet. ");
INSERT INTO epo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Kaj Abraham estis maljuna kaj en profunda aĝo. Kaj la Eternulo benis Abrahamon en ĉio. ");
INSERT INTO epo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kaj Abraham diris al sia sklavo, la administranto de lia domo, kiu regis ĉion, kio apartenis al li: Metu vian manon sub mian femuron; ");
INSERT INTO epo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","kaj mi ĵurigas vin per la Eternulo, la Dio de la ĉielo kaj la Dio de la tero, ke vi ne prenos edzinon por mia filo el la filinoj de la Kanaanidoj, inter kiuj mi loĝas; ");
INSERT INTO epo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","sed en mian landon kaj en mian patrujon vi iros kaj vi prenos edzinon por mia filo Isaak. ");
INSERT INTO epo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kaj la sklavo diris al li: Eble la virino ne volos iri kun mi en ĉi tiun landon; ĉu mi tiam devas revenigi vian filon en la landon, el kiu vi eliris? ");
INSERT INTO epo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kaj Abraham diris al li: Gardu vin, ne revenigu mian filon tien. ");
INSERT INTO epo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","La Eternulo, la Dio de la ĉielo, kiu prenis min el la domo de mia patro kaj el mia patrujo, kaj diris al mi kaj ĵuris al mi, dirante: Al via idaro Mi donos ĉi tiun landon — Li sendos Sian anĝelon antaŭ vi, kaj vi prenos edzinon por mia filo el tie. ");
INSERT INTO epo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kaj se la virino ne volos iri kun vi, tiam vi fariĝos libera de ĉi tiu mia ĵuro; nur mian filon ne revenigu tien. ");
INSERT INTO epo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kaj la sklavo metis sian manon sub la femuron de sia sinjoro Abraham kaj ĵuris al li pri tiu afero. ");
INSERT INTO epo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kaj la sklavo prenis dek kamelojn el la kameloj de sia sinjoro, kaj li iris; kaj ĉiaj bonaĵoj de lia sinjoro estis en liaj manoj. Kaj li leviĝis kaj iris Mezopotamion, al la urbo Naĥor. ");
INSERT INTO epo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kaj li genuigis la kamelojn ekstere de la urbo, ĉe puto kun akvo, en vespera tempo, en la tempo, kiam eliras la virinoj, por ĉerpi akvon. ");
INSERT INTO epo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kaj li diris: Ho Eternulo, Dio de mia sinjoro Abraham, sukcesigu min hodiaŭ kaj faru favorkoraĵon al mia sinjoro Abraham. ");
INSERT INTO epo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Jen mi staras apud la fonto da akvo, kaj la filinoj de la urbanoj eliras, por ĉerpi akvon; ");
INSERT INTO epo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","kaj la junulinon, al kiu mi diros: Volu klini vian kruĉon, ke mi trinku, kaj ŝi diros: Trinku, kaj mi trinkigos ankaŭ viajn kamelojn — ŝin Vi destinis por Via sklavo Isaak; kaj per tio mi sciiĝos, ke Vi faris favorkoraĵon al mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kaj antaŭ ol li finis paroli, jen eliras Rebeka, kiu estis naskita al Betuel, la filo de Milka, edzino de Naĥor, frato de Abraham; kaj ŝia kruĉo estis sur ŝia ŝultro. ");
INSERT INTO epo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Kaj la junulino estis tre belaspekta, virgulino, kiun ankoraŭ ne ekkonis viro. Kaj ŝi malsupreniris al la fonto kaj plenigis sian kruĉon kaj iris supren. ");
INSERT INTO epo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kaj la sklavo kuris al ŝi renkonte, kaj diris: Volu lasi min trinki iom da akvo el via kruĉo. ");
INSERT INTO epo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kaj ŝi diris: Trinku, mia sinjoro; kaj ŝi rapide mallevis la kruĉon sur sian manon, kaj ŝi donis al li trinki. ");
INSERT INTO epo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kaj kiam ŝi sufiĉe lin trinkigis, ŝi diris: Ankaŭ por viaj kameloj mi ĉerpos, ĝis ili finos trinki. ");
INSERT INTO epo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kaj rapide ŝi elverŝis el sia kruĉo en la trinkujon, kaj kuris denove al la puto, por ĉerpi por ĉiuj liaj kameloj. ");
INSERT INTO epo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kaj la viro admiris ŝin silente, por konvinkiĝi, ĉu la Eternulo prosperigis lian vojon aŭ ne. ");
INSERT INTO epo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kaj kiam la kameloj ĉesis trinki, tiam la viro prenis oran ringon, havantan la pezon de duono de siklo, kaj du braceletojn por ŝiaj manoj, havantajn la pezon de dek sikloj da oro. ");
INSERT INTO epo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kaj li diris: Kies filino vi estas? volu diri al mi; ĉu en la domo de via patro estas loko por ni, por tradormi la nokton? ");
INSERT INTO epo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kaj ŝi diris al li: Mi estas filino de Betuel, filo de Milka, kiun ŝi naskis al Naĥor. ");
INSERT INTO epo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kaj ŝi diris al li: Ankaŭ da pajlo kaj da furaĝo ni havas multe, kaj ankaŭ lokon, por ke vi tradormu la nokton. ");
INSERT INTO epo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kaj la viro kliniĝis kaj faris adoron al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kaj li diris: Glorata estu la Eternulo, la Dio de mia sinjoro Abraham, kiu ne lasis sen Sia favorkoreco kaj vereco mian sinjoron. Per la vojo, kiun mi iris, la Eternulo alkondukis min al la domo de la frato de mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kaj la junulino kuris, kaj rakontis tiujn aferojn en la domo de sia patrino. ");
INSERT INTO epo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Kaj Rebeka havis fraton, kiu estis nomata Laban. Kaj Laban kuris al la viro eksteren, al la fonto. ");
INSERT INTO epo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Kaj kiam li vidis la ringon kaj la braceletojn sur la manoj de sia fratino, kaj kiam li aŭdis la vortojn de sia fratino Rebeka, kiu diris: Tiel parolis kun mi tiu viro — tiam li iris al la viro, kaj jen tiu staras ĉe la kameloj apud la fonto. ");
INSERT INTO epo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kaj li diris: Venu, benita de la Eternulo; kial vi staras ekstere? mi pretigis la domon kaj ankaŭ lokon por la kameloj. ");
INSERT INTO epo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kaj li venigis la viron en la domon, kaj malligis la kamelojn, kaj donis pajlon kaj furaĝon al la kameloj, kaj akvon por lavi liajn piedojn, kaj la piedojn de la homoj, kiuj estis kun li. ");
INSERT INTO epo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kaj estis metita antaŭ li manĝo; sed li diris: Mi ne manĝos, antaŭ ol mi diros mian aferon. Kaj tiu diris: Parolu. ");
INSERT INTO epo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kaj li diris: Sklavo de Abraham mi estas. ");
INSERT INTO epo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Kaj la Eternulo forte benis mian sinjoron, kaj li fariĝis granda; kaj Li donis al li ŝafojn kaj bovojn kaj arĝenton kaj oron kaj sklavojn kaj sklavinojn kaj kamelojn kaj azenojn. ");
INSERT INTO epo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Kaj Sara, la edzino de mia sinjoro, naskis filon al mia sinjoro, kiam ŝi maljuniĝis; kaj li donis al li ĉion, kion li havis. ");
INSERT INTO epo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kaj mia sinjoro ĵurigis min, dirante: Ne prenu edzinon por mia filo el la filinoj de la Kanaanidoj, en kies lando mi loĝas. ");
INSERT INTO epo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nur al la domo de mia patro iru kaj al mia familio, kaj prenu edzinon por mia filo. ");
INSERT INTO epo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kaj mi diris al mia sinjoro: Eble la virino ne volos iri kun mi? ");
INSERT INTO epo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Kaj li diris al mi: La Eternulo, antaŭ kiu mi iradis, sendos Sian anĝelon kun vi kaj sukcesigos vian vojon; kaj vi prenos edzinon por mia filo el mia familio kaj el la domo de mia patro. ");
INSERT INTO epo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tiam vi estos libera de mia ĵuro, kiam vi venos al mia familio; kaj se ili ne donos al vi, vi estos libera de mia ĵuro. ");
INSERT INTO epo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kaj mi venis hodiaŭ al la fonto, kaj mi diris: Eternulo, Dio de mia sinjoro Abraham! ho, se Vi volus sukcesigi mian vojon, kiun mi nun iras! ");
INSERT INTO epo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Jen mi staras apud la fonto da akvo; la virgulino, kiu eliros, por ĉerpi, kaj al kiu mi diros: Lasu min trinki iom da akvo el via kruĉo, ");
INSERT INTO epo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kaj kiu diros al mi: Trinku vi, kaj ankaŭ por viaj kameloj mi ĉerpos — tio estas la virino, kiun la Eternulo destinis por la filo de mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Antaŭ ol mi finis paroli en mia koro, jen Rebeka eliras, kaj ŝia kruĉo estas sur ŝia ŝultro; kaj ŝi malsupreniris al la fonto kaj ĉerpis. Kaj mi diris al ŝi: Volu trinkigi min. ");
INSERT INTO epo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kaj rapide ŝi deprenis sian kruĉon de la ŝultro, kaj diris: Trinku, kaj ankaŭ viajn kamelojn mi trinkigos. Kaj mi trinkis, kaj ankaŭ la kamelojn ŝi trinkigis. ");
INSERT INTO epo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kaj mi demandis ŝin, kaj mi diris: Kies filino vi estas? Kaj ŝi diris: Filino de Betuel, filo de Naĥor, kiun naskis al li Milka. Kaj mi metis la ringon sur ŝian nazon kaj la braceletojn sur ŝiajn manojn. ");
INSERT INTO epo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kaj mi kliniĝis kaj faris adoron al la Eternulo, kaj mi gloris la Eternulon, la Dion de mia sinjoro Abraham, kiu kondukis min per ĝusta vojo, por ke mi prenu la filinon de la frato de mia sinjoro por lia filo. ");
INSERT INTO epo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kaj nun se vi volas fari favorkoraĵon kaj ĝustaĵon al mia sinjoro, diru al mi; kaj se ne, vi ankaŭ diru al mi, kaj mi turnos min dekstren aŭ maldekstren. ");
INSERT INTO epo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Tiam respondis Laban kaj Betuel, kaj diris: De la Eternulo venis ĉi tiu afero; ni ne povas diri al vi ion malbonan aŭ bonan. ");
INSERT INTO epo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Jen Rebeka estas antaŭ vi; prenu ŝin kaj iru, kaj ŝi estu edzino al la filo de via sinjoro, kiel diris la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kaj kiam la sklavo de Abraham aŭdis iliajn vortojn, li kliniĝis ĝis la tero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kaj la sklavo elprenis arĝentaĵojn kaj oraĵojn kaj vestojn kaj donis al Rebeka; kaj donacojn li donis al ŝia frato kaj al ŝia patrino. ");
INSERT INTO epo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kaj manĝis kaj trinkis li kaj la homoj, kiuj estis kun li, kaj ili tradormis tie la nokton. Kaj kiam ili leviĝis matene, li diris: Lasu min for al mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tiam ŝia frato kaj ŝia patrino diris: La junulino restu kun ni almenaŭ dek tagojn, poste vi iros. ");
INSERT INTO epo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kaj li diris al ili: Ne retenu min, ĉar la Eternulo sukcesigis mian vojon. Lasu min for, kaj mi iros al mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kaj ili diris: Ni vokos la junulinon, kaj ni demandos, kion ŝi diros. ");
INSERT INTO epo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kaj ili alvokis Rebekan, kaj diris al ŝi: Ĉu vi iros kun ĉi tiu viro? Kaj ŝi diris: Mi iros. ");
INSERT INTO epo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kaj ili forsendis sian fratinon Rebeka kaj ŝian nutrintinon kaj la sklavon de Abraham kaj liajn homojn. ");
INSERT INTO epo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kaj ili benis Rebekan, kaj diris al ŝi: Nia fratino! miloj da miloj elkresku el vi, kaj via idaro posedu la pordegojn de siaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kaj leviĝis Rebeka kaj ŝiaj servistinoj kaj sidiĝis sur la kameloj, kaj ili iris post tiu viro; kaj la sklavo prenis Rebekan kaj foriris. ");
INSERT INTO epo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kaj Isaak venis de la vojo, kiu kondukas al la puto de la Vivanto-Vidanto; li loĝis en la suda lando. ");
INSERT INTO epo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kaj Isaak eliris, por mediti sur la kampo, kiam komenciĝis vespero; kaj li levis siajn okulojn kaj vidis, ke jen venas kameloj. ");
INSERT INTO epo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kaj Rebeka levis siajn okulojn, kaj ŝi ekvidis Isaakon kaj desaltis de la kamelo. ");
INSERT INTO epo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Kaj ŝi diris al la sklavo: Kiu estas tiu viro, kiu iras sur la kampo renkonte al ni? Kaj la sklavo diris: Tio estas mia sinjoro. Kaj ŝi prenis la kovrotukon kaj kovris sin. ");
INSERT INTO epo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kaj la sklavo rakontis al Isaak ĉion, kion li faris. ");
INSERT INTO epo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kaj Isaak enkondukis ŝin en la tendon de sia patrino Sara; kaj li prenis Rebekan, kaj ŝi fariĝis lia edzino, kaj li ekamis ŝin. Kaj Isaak konsoliĝis pri sia patrino. ");
INSERT INTO epo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kaj Abraham prenis alian edzinon, kiu estis nomata Ketura. ");
INSERT INTO epo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kaj ŝi naskis al li Zimranon kaj Jokŝanon kaj Medanon kaj Midjanon kaj Jiŝbakon kaj Ŝuaĥon. ");
INSERT INTO epo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Kaj de Jokŝan naskiĝis Ŝeba kaj Dedan. Kaj la filoj de Dedan estis la Aŝuridoj, Letuŝidoj, kaj Leumidoj. ");
INSERT INTO epo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Kaj la filoj de Midjan estis Efa kaj Efer kaj Ĥanoĥ kaj Abida kaj Eldaa. Ĉiuj ĉi tiuj estis la filoj de Ketura. ");
INSERT INTO epo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Kaj Abraham fordonis ĉion, kion li havis, al Isaak. ");
INSERT INTO epo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kaj al la filoj de siaj kromvirinoj Abraham donis donacojn, kaj foririgis ilin de sia filo Isaak, ankoraŭ dum sia vivo, orienten, en landon orientan. ");
INSERT INTO epo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Kaj la nombro de la jaroj de vivo de Abraham, kiujn li travivis, estis cent sepdek kvin jaroj. ");
INSERT INTO epo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kaj Abraham konsumiĝis kaj mortis en bona maljuneco, profundaĝa kaj sata de vivo, kaj li alkolektiĝis al sia popolo. ");
INSERT INTO epo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kaj enterigis lin liaj filoj Isaak kaj Iŝmael en la duobla kaverno, kiu troviĝas antaŭ Mamre, sur la kampo de Efron, filo de Coĥar, la Ĥetido. ");
INSERT INTO epo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Sur la kampo, kiun aĉetis Abraham de la filoj de Ĥet, tie estas enterigitaj Abraham kaj lia edzino Sara. ");
INSERT INTO epo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kaj post la morto de Abraham Dio benis lian filon Isaak. Kaj Isaak loĝis ĉe la puto de la Vivanto-Vidanto. ");
INSERT INTO epo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Kaj jen estas la generaciaro de Iŝmael, filo de Abraham, kiun Hagar, la Egiptino, sklavino de Sara, naskis al Abraham; ");
INSERT INTO epo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","kaj jen estas la nomoj de la filoj de Iŝmael, laŭ iliaj nomoj kaj generacioj: Nebajot, la unuenaskita de Iŝmael, kaj Kedar kaj Adbeel kaj Mibsam ");
INSERT INTO epo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","kaj Miŝma kaj Duma kaj Masa, ");
INSERT INTO epo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ĥadad kaj Tema, Jetur, Nafiŝ, kaj Kedma. ");
INSERT INTO epo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Tio estas la filoj de Iŝmael, kaj tio estas iliaj nomoj en iliaj vilaĝoj kaj tendaroj, dek du princoj super siaj gentoj. ");
INSERT INTO epo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Kaj la daŭro de la vivo de Iŝmael estis cent tridek sep jaroj; kaj li konsumiĝis kaj mortis kaj alkolektiĝis al sia popolo. ");
INSERT INTO epo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Kaj ili loĝis de Ĥavila ĝis Ŝur, kiu estas antaŭ Egiptujo, sur la vojo al Asirio. Antaŭ ĉiuj siaj fratoj li loĝis. ");
INSERT INTO epo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Kaj jen estas la generaciaro de Isaak, filo de Abraham: de Abraham naskiĝis Isaak. ");
INSERT INTO epo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kaj Isaak havis la aĝon de kvardek jaroj, kiam li prenis kiel edzinon Rebekan, filinon de Betuel la Siriano, el Mezopotamio, fratinon de Laban la Siriano. ");
INSERT INTO epo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kaj Isaak preĝis al la Eternulo pri sia edzino, ĉar ŝi estis senfrukta; kaj la Eternulo cedis al lia preĝo, kaj lia edzino Rebeka gravediĝis. ");
INSERT INTO epo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kaj la infanoj interpuŝiĝis en ŝia interno, kaj ŝi diris: Se estas tiel, por kio do mi gravediĝis? Kaj ŝi iris, por demandi la Eternulon. ");
INSERT INTO epo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kaj la Eternulo diris al ŝi: Du popoloj estas en via ventro, Kaj du gentoj disapartiĝos el via interno; Kaj unu popolo estos pli forta ol la dua, Kaj la pli granda servos la malpli grandan. ");
INSERT INTO epo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kaj kiam venis la tempo, ke ŝi nasku, tiam montriĝis, ke ĝemeloj estas en ŝia ventro. ");
INSERT INTO epo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kaj la unua eliris ruĝa, li estis tuta kiel harkovrita felo; kaj oni donis al li la nomon Esav. ");
INSERT INTO epo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kaj poste eliris lia frato, tenante per la mano la kalkanon de Esav; kaj oni donis al li la nomon Jakob. Kaj Isaak havis la aĝon de sesdek jaroj, kiam ili naskiĝis. ");
INSERT INTO epo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kaj la knaboj grandiĝis; kaj Esav fariĝis lerta ĉasisto, kampisto, kaj Jakob fariĝis homo kvieta, sidanta en la tendo. ");
INSERT INTO epo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kaj Isaak amis Esavon, ĉar li manĝadis lian ĉasaĵon; sed Rebeka amis Jakobon. ");
INSERT INTO epo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kaj Jakob kuiris kuiraĵon; kaj Esav venis de la kampo kaj estis laca. ");
INSERT INTO epo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kaj Esav diris al Jakob: Donu al mi manĝi de ĉi tiu ruĝa kuiraĵo, ĉar mi estas laca. Tial oni donis al li la nomon Edom. ");
INSERT INTO epo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kaj Jakob diris: Vendu al mi hodiaŭ vian unuenaskitecon. ");
INSERT INTO epo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kaj Esav diris: Jen mi tuj mortos; por kio do mi bezonas la unuenaskitecon? ");
INSERT INTO epo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kaj Jakob diris: Ĵuru al mi hodiaŭ; kaj tiu ĵuris al li kaj vendis sian unuenaskitecon al Jakob. ");
INSERT INTO epo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kaj Jakob donis al Esav panon kaj kuiraĵon el lentoj, kaj li manĝis kaj trinkis, kaj leviĝis kaj foriris. Kaj Esav malŝatis la unuenaskitecon. ");
INSERT INTO epo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Estis malsato en la lando, krom la antaŭa malsato, kiu estis en la tempo de Abraham. Kaj Isaak iris al Abimeleĥ, la reĝo de la Filiŝtoj, en Gerar. ");
INSERT INTO epo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kaj la Eternulo aperis al li, kaj diris: Ne iru Egiptujon, loĝu en la lando, pri kiu Mi diros al vi. ");
INSERT INTO epo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Vivu kiel fremdulo en ĉi tiu lando, kaj Mi estos kun vi, kaj Mi benos vin; ĉar al vi kaj al via idaro Mi donos ĉiujn ĉi tiujn landojn, kaj Mi plenumos la ĵuron, kiun Mi ĵuris al via patro Abraham. ");
INSERT INTO epo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kaj Mi multigos vian idaron simile al la steloj de la ĉielo, kaj Mi donos al via idaro ĉiujn ĉi tiujn landojn, kaj beniĝos per via idaro ĉiuj popoloj de la tero; ");
INSERT INTO epo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","pro tio, ke Abraham obeis Mian voĉon, kaj plenumadis Miajn aranĝojn, Miajn leĝojn, kaj Miajn instruojn. ");
INSERT INTO epo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kaj Isaak ekloĝis en Gerar. ");
INSERT INTO epo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kaj kiam la homoj de tiu loko demandis pri lia edzino, li diris: Ŝi estas mia fratino; ĉar li timis diri: Mia edzino; por ke la homoj de la loko ne mortigu lin pro Rebeka, ĉar ŝi estis belaspekta. ");
INSERT INTO epo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Unu fojon, kiam li estis tie jam de longa tempo, Abimeleĥ, la reĝo de la Filiŝtoj, rigardis tra la fenestro, kaj vidis, ke Isaak amuziĝas kun sia edzino Rebeka. ");
INSERT INTO epo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tiam Abimeleĥ vokis Isaakon, kaj diris: Jen, ŝi estas ja via edzino; kial do vi diris: Ŝi estas mia fratino? Kaj Isaak diris al li: Ĉar mi pensis, ke eble mi mortos pro ŝi. ");
INSERT INTO epo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kaj Abimeleĥ diris: Kion do vi faris al ni! preskaŭ jam kuŝiĝis unu el la popolo kun via edzino, kaj vi venigus sur nin krimon. ");
INSERT INTO epo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kaj Abimeleĥ faris ordonon al la tuta popolo jene: Kiu tuŝos ĉi tiun viron aŭ lian edzinon, tiu mortos. ");
INSERT INTO epo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Kaj Isaak semis en tiu lando, kaj havis en tiu jaro centoble-mezuran rikolton; kaj la Eternulo lin benis. ");
INSERT INTO epo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kaj tiu homo grandiĝis kaj ĉiam pli kaj pli grandiĝadis, ĝis li fariĝis tre granda. ");
INSERT INTO epo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kaj li havis tre multe da brutoj malgrandaj kaj brutoj grandaj kaj grandan servistaron; kaj la Filiŝtoj enviis lin. ");
INSERT INTO epo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kaj ĉiujn putojn, kiujn elfosis la sklavoj de lia patro en la tempo de lia patro Abraham, la Filiŝtoj ŝtopis kaj plenigis ilin per tero. ");
INSERT INTO epo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tiam Abimeleĥ diris al Isaak: Foriru de ni, ĉar vi fariĝis multe pli forta ol ni. ");
INSERT INTO epo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kaj Isaak foriris de tie kaj aranĝis siajn tendojn en la valo de Gerar, kaj tie li ekloĝis. ");
INSERT INTO epo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kaj Isaak denove elfosis la akvoputojn, kiujn oni elfosis en la tempo de lia patro Abraham kaj la Filiŝtoj ŝtopis post la morto de Abraham; kaj li donis al ili tiujn samajn nomojn, kiujn donis al ili lia patro. ");
INSERT INTO epo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kaj la sklavoj de Isaak fosis en la valo kaj trovis tie puton kun freŝa akvo. ");
INSERT INTO epo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kaj disputis la paŝtistoj de Gerar kun la paŝtistoj de Isaak, dirante: Al ni apartenas la akvo. Kaj oni donis al la puto la nomon Esek, ĉar oni disputis pri ĝi. ");
INSERT INTO epo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kaj ili elfosis alian puton, kaj ankaŭ pri ĝi ili disputis; kaj oni donis al ĝi la nomon Sitna. ");
INSERT INTO epo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kaj ili foriĝis de tie kaj elfosis alian puton, kaj pri ĝi oni ne disputis. Kaj li donis al ĝi la nomon Reĥobot, dirante: Nun la Eternulo donis al ni vastan lokon, kaj ni multiĝos sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kaj de tie li formigris al Beer-Ŝeba. ");
INSERT INTO epo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kaj aperis al li la Eternulo en tiu nokto, kaj diris: Mi estas la Dio de via patro Abraham; ne timu, ĉar Mi estas kun vi, kaj Mi benos vin kaj Mi multigos vian idaron pro Abraham, Mia servanto. ");
INSERT INTO epo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kaj li konstruis tie altaron kaj preĝis al la Eternulo. Kaj li aranĝis tie sian tendon, kaj la sklavoj de Isaak elfosis tie puton. ");
INSERT INTO epo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kaj Abimeleĥ iris al li el Gerar, kaj ankaŭ lia amiko Aĥuzat kaj lia militestro Piĥol. ");
INSERT INTO epo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kaj Isaak diris al ili: Por kio vi venis al mi? vi min ja malamas kaj forpelis min de vi. ");
INSERT INTO epo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kaj ili diris: Ni vidis, ke la Eternulo estas kun vi; tial ni diris: Estu ĵuro inter ni, inter ni kaj vi, kaj ni faru interligon kun vi, ");
INSERT INTO epo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ke vi ne faru al ni malbonon, kiel ni vin ne tuŝis kaj kiel ni faris al vi nur bonon kaj lasis vin foriri en paco; vi estas nun benito de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kaj li faris por ili festenon, kaj ili manĝis kaj trinkis. ");
INSERT INTO epo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kaj ili leviĝis frue matene kaj ĵuris al si reciproke. Kaj Isaak lasis ilin foriri, kaj ili foriris de li en paco. ");
INSERT INTO epo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kaj en tiu tago venis la sklavoj de Isaak, kaj raportis al li pri la puto, kiun ili elfosis, kaj diris al li: Ni trovis akvon. ");
INSERT INTO epo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kaj li donis al ĝi la nomon Ŝiba; pro tio la nomo de la urbo estas Beer-Ŝeba ĝis hodiaŭ. ");
INSERT INTO epo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kiam Esav havis la aĝon de kvardek jaroj, li prenis kiel edzinojn Jehuditon, filinon de Beeri la Ĥetido, kaj Basmaton, filinon de Elon la Ĥetido. ");
INSERT INTO epo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Kaj ili multe ĉagrenis Isaakon kaj Rebekan. ");
INSERT INTO epo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kiam Isaak maljuniĝis kaj la vidado de liaj okuloj malakriĝis, li vokis Esavon, sian pli maljunan filon, kaj diris al li: Mia filo! Kaj tiu diris al li: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kaj li diris: Jen mi maljuniĝis; mi ne scias, kiam mi mortos; ");
INSERT INTO epo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","prenu do nun viajn armilojn, vian sagujon kaj vian pafarkon, kaj iru sur la kampon kaj ĉasu por mi ĉasaĵon; ");
INSERT INTO epo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","kaj faru por mi bongustan manĝaĵon, kian mi amas, kaj alportu al mi, kaj mi ĝin manĝos, por ke mia animo vin benu, antaŭ ol mi mortos. ");
INSERT INTO epo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Sed Rebeka aŭdis, kiam Isaak parolis al sia filo Esav. Kaj Esav iris sur la kampon, por ĉasi ĉasaĵon kaj alporti. ");
INSERT INTO epo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Kaj Rebeka diris al sia filo Jakob jene: Mi aŭdis, ke via patro diris al via frato Esav jene: ");
INSERT INTO epo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Alportu al mi ĉasaĵon kaj faru por mi bongustan manĝaĵon, kaj mi manĝos, kaj mi benos vin antaŭ la Eternulo antaŭ mia morto. ");
INSERT INTO epo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kaj nun, mia filo, aŭskultu mian voĉon, kion mi ordonas al vi: ");
INSERT INTO epo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","iru al la brutaro kaj alportu al mi de tie du bonajn kapridojn, kaj mi faros el ili bongustan manĝaĵon por via patro, kian li amas; ");
INSERT INTO epo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","kaj vi alportos al via patro, kaj li manĝos, por ke li benu vin antaŭ sia morto. ");
INSERT INTO epo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kaj Jakob diris al sia patrino Rebeka: Mia frato Esav estas ja homo harkovrita, kaj mi estas homo glata; ");
INSERT INTO epo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","eble mia patro min palpos, tiam mi estos en liaj okuloj kiel trompanto, kaj mi venigos sur min malbenon, sed ne benon. ");
INSERT INTO epo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kaj lia patrino diris al li: Sur mi estu tiu malbeno, mia filo; nur aŭskultu mian voĉon kaj iru, alportu al mi. ");
INSERT INTO epo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kaj li iris kaj prenis kaj alportis al sia patrino, kaj lia patrino faris bongustan manĝaĵon, kian amis lia patro. ");
INSERT INTO epo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kaj Rebeka prenis la luksajn vestojn de sia pli maljuna filo Esav, kiujn ŝi havis ĉe si en la domo, kaj ŝi vestis sian pli junan filon Jakob; ");
INSERT INTO epo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","kaj per la feloj de la kapridoj ŝi vestis liajn manojn kaj la glataĵon de lia kolo. ");
INSERT INTO epo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kaj ŝi donis la bongustan manĝaĵon kaj la panon, kiujn ŝi pretigis, en la manon de sia filo Jakob. ");
INSERT INTO epo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kaj li venis al sia patro, kaj diris: Mia patro! Kaj tiu diris: Jen mi estas; kiu vi estas, mia filo? ");
INSERT INTO epo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kaj Jakob diris al sia patro: Mi estas Esav, via unuenaskito; mi faris, kiel vi diris al mi; volu leviĝi, sidiĝu, kaj manĝu mian ĉasaĵon, por ke via animo min benu. ");
INSERT INTO epo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kaj Isaak diris al sia filo: Kiamaniere vi tiel rapide trovis, mia filo? Kaj tiu diris: Ĉar la Eternulo, via Dio, sendis al mi renkonte. ");
INSERT INTO epo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kaj Isaak diris al Jakob: Alproksimiĝu, kaj mi vin palpos, mia filo, ĉu tio estas vi, mia filo Esav, aŭ ne. ");
INSERT INTO epo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kaj Jakob alproksimiĝis al sia patro Isaak, kaj tiu lin palpis, kaj diris: La voĉo estas voĉo de Jakob, sed la manoj estas manoj de Esav. ");
INSERT INTO epo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kaj li ne rekonis lin, ĉar liaj manoj estis kiel la manoj de lia frato Esav, harkovritaj; kaj li benis lin. ");
INSERT INTO epo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kaj li diris: Ĉu tio estas vi, mia filo Esav? Kaj tiu diris: Mi. ");
INSERT INTO epo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kaj li diris: Alŝovu al mi, kaj mi manĝos la ĉasaĵon de mia filo, por ke mia animo vin benu. Kaj li alŝovis al li, kaj tiu manĝis; kaj li alportis al li vinon, kaj tiu trinkis. ");
INSERT INTO epo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kaj lia patro Isaak diris al li: Alproksimiĝu kaj kisu min, mia filo. ");
INSERT INTO epo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kaj li alproksimiĝis kaj kisis lin, kaj tiu flaris la odoron de liaj vestoj, kaj li benis lin, kaj diris: Vidu, la odoro de mia filo Estas kiel la odoro de kampo, kiun la Eternulo benis; ");
INSERT INTO epo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dio donu al vi roson ĉielan Kaj grason de la tero Kaj multe da greno kaj mosto. ");
INSERT INTO epo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Popoloj vin servu, Kaj gentoj kliniĝu antaŭ vi; Estu sinjoro super viaj fratoj, Kaj kliniĝu antaŭ vi la filoj de via patrino; Viaj malbenantoj estu malbenataj, Kaj viaj benantoj estu benataj. ");
INSERT INTO epo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kaj kiam Isaak finis beni Jakobon kaj apenaŭ Jakob eliris de antaŭ sia patro Isaak, lia frato Esav venis de sia ĉasado. ");
INSERT INTO epo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kaj ankaŭ li faris bongustan manĝaĵon kaj alportis al sia patro, kaj diris al sia patro: Leviĝu, mia patro, kaj manĝu la ĉasaĵon de via filo, por ke via animo min benu. ");
INSERT INTO epo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kaj lia patro Isaak diris al li: Kiu vi estas? Kaj li diris: Mi estas via unuenaskita filo Esav. ");
INSERT INTO epo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tiam Isaak ektremis per tre granda tremo, kaj diris: Kiu do estas tiu, kiu ĉasis ĉasaĵon kaj alportis al mi, kaj mi manĝis de ĉio, antaŭ ol vi venis, kaj mi benis lin? kaj li restos ja benita! ");
INSERT INTO epo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kiam Esav aŭdis la vortojn de sia patro, li ekkriis per tre granda kaj maldolĉa krio, kaj diris al sia patro: Benu ankaŭ min, ho mia patro! ");
INSERT INTO epo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kaj tiu diris: Via frato venis kun ruzo kaj prenis vian benon. ");
INSERT INTO epo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kaj li diris: Ĝuste do lia nomo estas Jakob, ĉar li submetis al mi la piedon jam du fojojn; mian unuenaskitecon li prenis, kaj jen li nun prenis mian benon! Kaj li diris: Ĉu vi ne rezervis por mi benon? ");
INSERT INTO epo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Kaj Isaak respondis kaj diris al Esav: Jen mi faris lin sinjoro super vi, kaj ĉiujn liajn fratojn mi donis al li kiel servantojn, kaj grenon kaj moston mi havigis al li; kion do mi faros por vi, mia filo? ");
INSERT INTO epo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kaj Esav diris al sia patro: Ĉu ĝi estas la sola beno, kiun vi havas? benu ankaŭ min, ho mia patro! Kaj Esav ekploris per laŭta voĉo. ");
INSERT INTO epo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kaj lia patro Isaak respondis kaj diris al li: Jen la graso de la tero estu en via loko de loĝado Kaj la ĉiela roso de supre; ");
INSERT INTO epo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kaj per via glavo vi vivos, kaj vian fraton vi servos; Sed kiam vi kontraŭbatalos, Vi deĵetos lian jugon de via kolo. ");
INSERT INTO epo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Kaj Esav ekmalamis Jakobon pro la beno, per kiu benis lin lia patro; kaj Esav diris en sia koro: Baldaŭ venos la tagoj de funebro pro mia patro, tiam mi mortigos mian fraton Jakob. ");
INSERT INTO epo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kaj oni raportis al Rebeka la vortojn de ŝia pli maljuna filo Esav; tiam ŝi sendis kaj vokis sian pli junan filon Jakob, kaj diris al li: Jen via frato Esav minacas mortigi vin; ");
INSERT INTO epo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","tial nun, mia filo, aŭskultu mian voĉon; kaj leviĝu, forkuru al mia frato Laban en Ĥaran; ");
INSERT INTO epo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","kaj loĝu ĉe li kelkan tempon, ĝis kvietiĝos la furiozo de via frato; ");
INSERT INTO epo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ĝis la kolero de via frato deturniĝos de vi, kaj li forgesos, kion vi faris al li. Tiam mi sendos kaj prenos vin de tie. Kial mi perdu vin ambaŭ en unu tago? ");
INSERT INTO epo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kaj Rebeka diris al Isaak: Tedis al mi la vivo pro la Ĥetidinoj; se Jakob prenos edzinon el ĉi tiuj Ĥetidinoj, el la filinoj de la lando, tiam por kio mi vivu? ");
INSERT INTO epo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tiam Isaak alvokis Jakobon kaj benis lin, kaj ordonis al li, dirante: Ne prenu edzinon el la filinoj Kanaanaj. ");
INSERT INTO epo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Leviĝu, iru Mezopotamion, al la domo de Betuel, la patro de via patrino, kaj prenu al vi el tie edzinon el la filinoj de Laban, la frato de via patrino. ");
INSERT INTO epo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kaj Dio la Plejpotenca benu vin kaj fruktigu vin kaj multigu vin, kaj kreskigu el vi amason da popoloj. ");
INSERT INTO epo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kaj Li donu al vi la benon de Abraham, al vi kaj al via idaro kune kun vi, por ke vi heredu la landon de via fremdeloĝado, kiun Dio donis al Abraham. ");
INSERT INTO epo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kaj Isaak forsendis Jakobon, kaj tiu iris Mezopotamion, al Laban, la filo de Betuel la Siriano, frato de Rebeka, patrino de Jakob kaj Esav. ");
INSERT INTO epo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kiam Esav vidis, ke Isaak benis Jakobon kaj sendis lin en Mezopotamion, por ke li prenu al si el tie edzinon, kaj ke, benante lin, li ordonis al li, dirante: Ne prenu edzinon el la filinoj Kanaanaj; ");
INSERT INTO epo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","kaj ke Jakob obeis sian patron kaj sian patrinon kaj iris Mezopotamion: ");
INSERT INTO epo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","tiam Esav vidis, ke ne plaĉas la filinoj Kanaanaj al lia patro Isaak. ");
INSERT INTO epo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kaj Esav iris al Iŝmael kaj prenis al si Maĥalaton, filinon de Iŝmael, filo de Abraham, fratinon de Nebajot, kiel edzinon krom siaj aliaj edzinoj. ");
INSERT INTO epo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kaj Jakob eliris el Beer-Ŝeba kaj iris en la direkto al Ĥaran. ");
INSERT INTO epo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Li venis al iu loko kaj restis tie, por pasigi la nokton, ĉar la suno subiris. Kaj li prenis unu el la ŝtonoj de tiu loko kaj metis ĝin sub sian kapon kaj kuŝiĝis en tiu loko. ");
INSERT INTO epo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kaj li sonĝis: jen ŝtuparo staras sur la tero, kaj ĝia supro atingas la ĉielon, kaj jen anĝeloj de Dio iras sur ĝi supren kaj malsupren. ");
INSERT INTO epo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kaj jen la Eternulo staras sur ĝi, kaj diras: Mi estas la Eternulo, la Dio de via patro Abraham kaj la Dio de Isaak; la teron, sur kiu vi kuŝas, Mi donos al vi kaj al via idaro. ");
INSERT INTO epo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kaj via idaro estos kiel la polvo de la tero, kaj vi disvastiĝos okcidenten kaj orienten kaj norden kaj suden, kaj beniĝos per vi kaj per via idaro ĉiuj gentoj de la tero. ");
INSERT INTO epo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kaj Mi estas kun vi, kaj Mi gardos vin ĉie, kien vi iros, kaj Mi revenigos vin sur ĉi tiun teron; ĉar Mi ne forlasos vin, ĝis Mi estos farinta tion, kion Mi diris al vi. ");
INSERT INTO epo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kaj Jakob vekiĝis el sia dormo, kaj li diris: Vere, la Eternulo estas en ĉi tiu loko, kaj mi ne sciis. ");
INSERT INTO epo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kaj li ektimis, kaj diris: Kiel timinda estas ĉi tiu loko! ĝi estas nenio alia ol domo de Dio, kaj ĉi tie estas la pordego de la ĉielo. ");
INSERT INTO epo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kaj Jakob leviĝis frue matene, kaj prenis la ŝtonon, kiun li estis metinta sub sian kapon, kaj starigis ĝin kiel monumenton, kaj verŝis oleon sur ĝian supron. ");
INSERT INTO epo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kaj li donis al tiu loko la nomon Bet-El; sed antaŭe la nomo de la urbo estis Luz. ");
INSERT INTO epo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kaj Jakob faris sanktan promeson, dirante: Se Dio estos kun mi, kaj gardos min sur ĉi tiu vojo, kiun mi iras, kaj donos al mi panon por manĝi kaj veston por porti sur mi, ");
INSERT INTO epo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kaj mi revenos en paco al la domo de mia patro, kaj la Eternulo estos por mi Dio: ");
INSERT INTO epo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","tiam ĉi tiu ŝtono, kiun mi starigis kiel monumenton, estos domo de Dio, kaj de ĉio, kion Vi donos al mi, mi oferos al Vi dekonon. ");
INSERT INTO epo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kaj Jakob levis siajn piedojn kaj iris al la lando de la orientanoj. ");
INSERT INTO epo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kaj li vidis: jen estas puto sur la kampo, kaj tri gregoj da ŝafoj kuŝas apud ĝi; ĉar el tiu puto oni trinkigadis la gregojn; kaj granda ŝtono estis sur la aperturo de la puto. ");
INSERT INTO epo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kaj kiam tie kunvenis ĉiuj gregoj, tiam oni deruladis la ŝtonon de sur la aperturo kaj trinkigadis la ŝafojn kaj denove remetadis la ŝtonon sur ĝian lokon, sur la aperturon de la puto. ");
INSERT INTO epo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kaj Jakob diris al ili: Fratoj miaj, ke kie vi estas? Kaj ili diris: Ni estas el Ĥaran. ");
INSERT INTO epo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kaj li diris al ili: Ĉu vi konas Labanon, filon de Naĥor? Kaj ili diris: Ni konas. ");
INSERT INTO epo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kaj li diris al ili: Ĉu li bone fartas? Kaj ili diris: Li fartas bone, kaj jen lia filino Raĥel venas kun la ŝafoj. ");
INSERT INTO epo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kaj li diris: De la tago restas ja ankoraŭ multe, ankoraŭ ne estas la tempo, por kolekti la gregojn; trinkigu la ŝafojn kaj iru, paŝtu. ");
INSERT INTO epo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kaj ili diris: Ni ne povas, ĝis kolektiĝos ĉiuj gregoj kaj oni derulos la ŝtonon de sur la aperturo de la puto kaj ni trinkigos la ŝafojn. ");
INSERT INTO epo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Dum li ankoraŭ parolis kun ili, venis Raĥel kun la ŝafoj de sia patro, ĉar ŝi paŝtis ilin. ");
INSERT INTO epo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kaj kiam Jakob ekvidis Raĥelon, la filinon de Laban, frato de lia patrino, kaj la ŝafojn de Laban, frato de lia patrino, tiam Jakob alproksimiĝis, derulis la ŝtonon de sur la aperturo de la puto, kaj trinkigis la ŝafojn de Laban, la frato de lia patrino. ");
INSERT INTO epo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kaj Jakob kisis Raĥelon kaj laŭte ekploris. ");
INSERT INTO epo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kaj Jakob diris al Raĥel, ke li estas parenco de ŝia patro kaj filo de Rebeka. Kaj ŝi kuris kaj diris al sia patro. ");
INSERT INTO epo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kaj kiam Laban aŭdis la sciigon pri Jakob, filo de lia fratino, li kuris al li renkonte kaj ĉirkaŭprenis lin kaj kisis lin kaj venigis lin en sian domon. Kaj tiu rakontis al Laban ĉion. ");
INSERT INTO epo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kaj Laban diris al li: Vi estas ja mia osto kaj mia karno! Kaj li loĝis ĉe li tutan monaton. ");
INSERT INTO epo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kaj Laban diris al Jakob: Ĉu pro tio, ke vi estas mia parenco, vi devas servi min senpage? diru al mi, kion mi devas pagi al vi? ");
INSERT INTO epo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Sed Laban havis du filinojn; la nomo de la pli maljuna estis Lea, kaj la nomo de la pli juna estis Raĥel. ");
INSERT INTO epo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","La okuloj de Lea estis malsanaj, sed Raĥel estis belforma kaj belvizaĝa. ");
INSERT INTO epo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Kaj Jakob ekamis Raĥelon, kaj diris: Mi servos vin sep jarojn pro Raĥel, via pli juna filino. ");
INSERT INTO epo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Tiam Laban diris: Pli bone estas, ke mi donu ŝin al vi, ol ke mi donu ŝin al alia viro; loĝu ĉe mi. ");
INSERT INTO epo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kaj Jakob servis pro Raĥel sep jarojn, kaj ili estis en liaj okuloj kiel kelke da tagoj, ĉar li amis ŝin. ");
INSERT INTO epo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kaj Jakob diris al Laban: Donu mian edzinon, ĉar finiĝis mia tempo, kaj mi envenos al ŝi. ");
INSERT INTO epo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kaj Laban kunvenigis ĉiujn homojn de tiu loko kaj faris festenon. ");
INSERT INTO epo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Sed vespere li prenis sian filinon Lea kaj enirigis ŝin al li; kaj tiu envenis al ŝi. ");
INSERT INTO epo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kaj Laban donis sian sklavinon Zilpa al Lea kiel sklavinon. ");
INSERT INTO epo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sed matene montriĝis, ke tio estas Lea. Tiam li diris al Laban: Kion do vi faris al mi! ĉu ne pro Raĥel mi servis vin? kial do vi min trompis? ");
INSERT INTO epo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tiam Laban diris: En nia loko ne estas moro, ke oni donu la pli junan antaŭ ol la pli maljunan. ");
INSERT INTO epo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Pasigu semajnon kun ĉi tiu, tiam mi donos al vi ankaŭ tiun, pro servo, kiun vi servos ĉe mi ankoraŭ aliajn sep jarojn. ");
INSERT INTO epo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kaj Jakob faris tiel kaj pasigis semajnon kun ĉi tiu. Kaj Laban donis al li sian filinon Raĥel kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Kaj Laban donis al sia filino Raĥel sian sklavinon Bilha kiel sklavinon. ");
INSERT INTO epo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kaj Jakob envenis ankaŭ al Raĥel, kaj li amis Raĥelon pli ol Lean, kaj li servis ĉe li ankoraŭ aliajn sep jarojn. ");
INSERT INTO epo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kiam la Eternulo vidis, ke Lea estas malamata, Li malŝlosis ŝian uteron; sed Raĥel estis senfrukta. ");
INSERT INTO epo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Kaj Lea gravediĝis kaj naskis filon, kaj ŝi donis al li la nomon Ruben, ĉar ŝi diris: La Eternulo vidis mian mizeron, kaj nun mia edzo min amos. ");
INSERT INTO epo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kaj ŝi denove gravediĝis kaj naskis filon. Kaj ŝi diris: La Eternulo aŭdis, ke mi estas malamata, tial Li donis al mi ankaŭ ĉi tiun; kaj ŝi donis al li la nomon Simeon. ");
INSERT INTO epo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kaj ŝi denove gravediĝis kaj naskis filon. Kaj ŝi diris: La nunan fojon mia edzo aliĝos al mi, ĉar mi naskis al li tri filojn; tial al li estis donita la nomo Levi. ");
INSERT INTO epo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kaj ŝi denove gravediĝis kaj naskis filon. Kaj ŝi diris: Nun mi dankos la Eternulon; tial ŝi donis al li la nomon Jehuda. Kaj ŝi ĉesis naski. ");
INSERT INTO epo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Kiam Raĥel vidis, ke ŝi ne naskas al Jakob, ŝi enviis sian fratinon, kaj ŝi diris al Jakob: Donu al mi infanojn, ĉar alie mi mortos. ");
INSERT INTO epo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kaj Jakob forte ekkoleris Raĥelon, kaj li diris: Ĉu mi anstataŭas Dion, kiu rifuzis al vi frukton de ventro? ");
INSERT INTO epo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kaj ŝi diris: Jen estas mia sklavino Bilha; envenu al ŝi, ke ŝi nasku sur miaj genuoj kaj ke mi ankaŭ ricevu filojn per ŝi. ");
INSERT INTO epo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kaj ŝi donis al li sian sklavinon Bilha kiel edzinon, kaj Jakob envenis al ŝi. ");
INSERT INTO epo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Kaj Bilha gravediĝis kaj naskis al Jakob filon. ");
INSERT INTO epo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kaj Raĥel diris: Dio min juĝis kaj aŭdis mian voĉon kaj donis al mi filon; tial ŝi donis al li la nomon Dan. ");
INSERT INTO epo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kaj Bilha, la sklavino de Raĥel, denove gravediĝis kaj naskis duan filon al Jakob. ");
INSERT INTO epo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tiam Raĥel diris: Per Dia lukto mi luktis kun mia fratino, kaj mi venkis; kaj ŝi donis al li la nomon Naftali. ");
INSERT INTO epo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kiam Lea vidis, ke ŝi ĉesis naski, ŝi prenis sian sklavinon Zilpa kaj donis ŝin al Jakob kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kaj Zilpa, la sklavino de Lea, naskis al Jakob filon. ");
INSERT INTO epo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Kaj Lea diris: Venis feliĉo! kaj ŝi donis al li la nomon Gad. ");
INSERT INTO epo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Kaj Zilpa, la sklavino de Lea, naskis duan filon al Jakob. ");
INSERT INTO epo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Kaj Lea diris: Por mia bono; ĉar la virinoj diros, ke estas al mi bone. Kaj ŝi donis al li la nomon Aŝer. ");
INSERT INTO epo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben iris en la tempo de rikoltado de tritiko kaj trovis mandragorojn sur la kampo, kaj li alportis ilin al sia patrino Lea. Kaj Raĥel diris al Lea: Donu al mi el la mandragoroj de via filo. ");
INSERT INTO epo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sed tiu diris al ŝi: Ĉu ne sufiĉas al vi, ke vi prenis mian edzon, kaj vi volas preni ankaŭ la mandragorojn de mia filo? Tiam Raĥel diris: Nu, li kuŝu kun vi ĉi tiun nokton por la mandragoroj de via filo. ");
INSERT INTO epo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kiam Jakob venis de la kampo vespere, Lea eliris al li renkonte, kaj diris: Al mi venu, ĉar mi aĉetis vin per la mandragoroj de mia filo. Kaj li kuŝis kun ŝi en tiu nokto. ");
INSERT INTO epo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kaj Dio aŭdis Lean, kaj ŝi gravediĝis kaj naskis al Jakob kvinan filon. ");
INSERT INTO epo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kaj Lea diris: Dio donis al mi rekompencon por tio, ke mi donis mian sklavinon al mia edzo; kaj ŝi donis al li la nomon Isaĥar. ");
INSERT INTO epo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kaj Lea denove gravediĝis kaj naskis sesan filon al Jakob. ");
INSERT INTO epo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kaj Lea diris: Havigis al mi Dio bonan havon; nun mia edzo loĝos ĉe mi, ĉar mi naskis al li ses filojn. Kaj ŝi donis al li la nomon Zebulun. ");
INSERT INTO epo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kaj poste ŝi naskis filinon, kaj ŝi donis al ŝi la nomon Dina. ");
INSERT INTO epo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kaj Dio rememoris Raĥelon, kaj Dio elaŭdis ŝin kaj malŝlosis ŝian uteron. ");
INSERT INTO epo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Kaj ŝi gravediĝis kaj naskis filon. Kaj ŝi diris: Dio forprenis mian malhonoron. ");
INSERT INTO epo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kaj ŝi donis al li la nomon Jozef, dirante: La Eternulo aldonos al mi alian filon. ");
INSERT INTO epo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kiam Raĥel naskis Jozefon, Jakob diris al Laban: Forliberigu min, kaj mi iros al mia loko kaj al mia lando. ");
INSERT INTO epo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Donu miajn edzinojn kaj miajn infanojn, pro kiuj mi servis vin, kaj mi iros; ĉar vi konas la servon, per kiu mi vin servis. ");
INSERT INTO epo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kaj Laban diris al li: Ho, se mi povus akiri vian favoron! mi spertis, ke la Eternulo benis min pro vi. ");
INSERT INTO epo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kaj li diris: Difinu, kian rekompencon mi ŝuldas al vi, kaj mi donos. ");
INSERT INTO epo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kaj tiu diris al li: Vi scias, kiel mi servis vin kaj kia fariĝis via brutaro ĉe mi; ");
INSERT INTO epo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ĉar malmulte vi havis antaŭ mi, sed nun ĝi multe vastiĝis; kaj la Eternulo benis vin post mia veno; kaj nun kiam mi laboros ankaŭ por mia domo? ");
INSERT INTO epo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kaj Laban diris: Kion mi donu al vi? Kaj Jakob diris: Donu al mi nenion; sed se vi faros al mi jenon, tiam mi denove paŝtos kaj gardos viajn ŝafojn: ");
INSERT INTO epo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","mi pasos hodiaŭ tra via tuta ŝafaro; apartigu el ĝi ĉiun ŝafon mikskoloran kaj makulitan kaj ĉiun bruton nigran inter la ŝafoj, kaj makulitan kaj mikskoloran inter la kaproj; kaj ili estu mia rekompenco. ");
INSERT INTO epo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kaj respondos por mi mia justeco en la morgaŭa tago, kiam vi venos vidi mian rekompencon; ĉiu el la kaproj, kiu ne estos mikskolora aŭ makulita, kaj ĉiu el la ŝafoj, kiu ne estos nigra, estu rigardata kiel ŝtelita de mi. ");
INSERT INTO epo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kaj Laban diris: Ĝi estu, kiel vi diris. ");
INSERT INTO epo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kaj li apartigis en tiu tago la virkaprojn striitajn kaj makulitajn kaj ĉiujn kaprinojn mikskolorajn kaj makulitajn, ĉiujn, kiuj havis sur si iom da blankaĵo, kaj ĉiujn nigrajn ŝafojn; kaj li transdonis ilin en la manojn de siaj filoj. ");
INSERT INTO epo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kaj li faris interspacon de tritaga irado inter si kaj Jakob. Kaj Jakob paŝtis la restintajn ŝafojn de Laban. ");
INSERT INTO epo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kaj Jakob prenis al si bastonojn el verdaj poploj, migdalarboj, kaj platanarboj, kaj senŝeligis sur ili blankajn striojn tiamaniere, ke la blankaĵo sur la bastonoj elmontriĝis. ");
INSERT INTO epo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kaj li metis la skrapitajn bastonojn antaŭ la ŝafoj en la akvotrinkigajn kanalojn, al kiuj la ŝafoj venadis por trinki, kaj ili gravediĝadis, kiam ili venadis trinki. ");
INSERT INTO epo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kaj la ŝafoj gravediĝis super la bastonoj, kaj ili naskis ŝafidojn striitajn, mikskolorajn, kaj makulitajn. ");
INSERT INTO epo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kaj la ŝafidojn Jakob apartigis, kaj li turnis la vizaĝojn de la brutoj kontraŭ la striitajn kaj kontraŭ la nigrajn brutojn de Laban; sed siajn brutarojn li apartigis kaj ne almiksis ilin al la brutoj de Laban. ");
INSERT INTO epo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ĉiufoje, kiam pasiiĝis brutoj fortaj, Jakob metis la bastonojn en la kanalojn antaŭ la okuloj de la brutoj, por ke ili pasiiĝu antaŭ la bastonoj; ");
INSERT INTO epo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","sed kiam la brutoj estis malfortaj, li ne metis. Tiamaniere la malfortaj fariĝis apartenaĵo de Laban, kaj la fortaj fariĝis apartenaĵo de Jakob. ");
INSERT INTO epo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kaj tiu homo fariĝis eksterordinare riĉa, kaj li havis multe da brutoj kaj sklavinojn kaj sklavojn kaj kamelojn kaj azenojn. ");
INSERT INTO epo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Li aŭdis, ke la filoj de Laban parolis jene: Jakob forprenis la tutan havon de nia patro, kaj el la havo de nia patro li akiris la tutan riĉecon. ");
INSERT INTO epo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kaj Jakob vidis laŭ la vizaĝo de Laban, ke li ne estas rilate al li tia, kia li estis hieraŭ kaj antaŭhieraŭ. ");
INSERT INTO epo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kaj la Eternulo diris al Jakob: Reiru en la landon de viaj patroj kaj en vian naskiĝlandon, kaj Mi estos kun vi. ");
INSERT INTO epo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tiam Jakob sendis kaj vokis Raĥelon kaj Lean sur la kampon al sia brutaro; ");
INSERT INTO epo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","kaj li diris al ili: Mi vidas laŭ la vizaĝo de via patro, ke li ne estas rilate al mi tia, kia li estis hieraŭ kaj antaŭhieraŭ; sed la Dio de mia patro estis kun mi. ");
INSERT INTO epo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Vi scias, ke per ĉiuj miaj fortoj mi servis vian patron. ");
INSERT INTO epo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Sed via patro trompis min kaj dekfoje ŝanĝis mian laborpagon; tamen Dio ne lasis lin fari al mi malbonon. ");
INSERT INTO epo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kiam li diris: Mikskoloraj estu via rekompenco — ĉiuj brutoj naskis idojn mikskolorajn; kaj kiam li diris: Striitaj estu via rekompenco — ĉiuj brutoj naskis striitajn. ");
INSERT INTO epo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tiamaniere Dio forprenis la brutojn de via patro kaj donis al mi. ");
INSERT INTO epo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","En la tempo, kiam la brutoj pasiiĝis, mi levis miajn okulojn kaj vidis en sonĝo, ke la virbestoj, kiuj leviĝis sur la brutojn, estas striitaj, mikskoloraj, kaj makulitaj. ");
INSERT INTO epo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kaj anĝelo de Dio diris al mi en la sonĝo: Jakob! kaj mi diris: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kaj li diris: Levu viajn okulojn kaj vidu: ĉiuj virbestoj, kiuj leviĝis sur la brutojn, estas striitaj, mikskoloraj, kaj makulitaj, ĉar Mi vidis ĉion, kion Laban faras al vi. ");
INSERT INTO epo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mi estas la Dio el Bet-El, kie vi verŝis oleon sur la monumenton kaj kie vi faris sanktan promeson al Mi. Nun leviĝu, eliru el ĉi tiu lando kaj reiru en la landon de via naskiĝo. ");
INSERT INTO epo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kaj Raĥel kaj Lea respondis kaj diris al li: Ĉu ni havas ankoraŭ parton kaj heredon en la domo de nia patro? ");
INSERT INTO epo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Li rigardas ja nin kiel fremdulinojn; ĉar li vendis nin kaj eĉ formanĝis nian monon. ");
INSERT INTO epo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ĉar la tuta riĉo, kiun Dio forprenis de nia patro, apartenas al ni kaj al niaj infanoj. Kaj nun ĉion, kion Dio al vi diris, faru. ");
INSERT INTO epo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jakob leviĝis, kaj metis siajn infanojn kaj siajn edzinojn sur la kamelojn. ");
INSERT INTO epo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Kaj li forkondukis sian tutan brutaron kaj sian tutan havon, kiun li akiris, sian propraĵon, kiun li akiris en Mezopotamio, por iri al sia patro Isaak en la landon Kanaanan. ");
INSERT INTO epo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban estis foririnta, por tondi siajn ŝafojn; tiam Raĥel ŝtelis la domajn diojn de sia patro. ");
INSERT INTO epo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakob trompis la atenton de Laban la Siriano, ne dirante al li, ke li forkuras. ");
INSERT INTO epo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kaj li rapide foriris kune kun ĉio, kion li havis. Kaj li transpasis la Riveron kaj direktiĝis al la monto Gilead. ");
INSERT INTO epo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Oni diris al Laban en la tria tago, ke Jakob forkuris. ");
INSERT INTO epo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tiam li prenis kun si siajn fratojn, kaj kuris post li distancon de sep tagoj kaj kuratingis lin sur la monto Gilead. ");
INSERT INTO epo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tiam Dio aperis al Laban la Siriano nokte en la sonĝo, kaj diris al li: Gardu vin, ke vi ne parolu kun Jakob bone nek malbone. ");
INSERT INTO epo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban kuratingis Jakobon. Jakob starigis sian tendon sur la monto, kaj Laban aranĝis siajn fratojn ankaŭ sur la monto Gilead. ");
INSERT INTO epo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kaj Laban diris al Jakob: Kion vi faris? vi trompis min kaj forkondukis miajn filinojn kvazaŭ militkaptitojn! ");
INSERT INTO epo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kial vi forkuris sekrete kaj kaŝe de mi, kaj ne diris al mi? Mi foririgus vin en gajeco kaj kun kantoj, kun tamburino kaj harpo. ");
INSERT INTO epo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Vi eĉ ne lasis min kisi miajn infanojn kaj filinojn! malsaĝe vi agis. ");
INSERT INTO epo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mi havas forton en mia mano, por fari al vi malbonon; sed la Dio de via patro hieraŭ diris al mi jene: Gardu vin, ke vi ne parolu kun Jakob bone aŭ malbone. ");
INSERT INTO epo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kaj se vi nun foriris, ĉar vi forte deziris esti en la domo de via patro, kial do vi ŝtelis miajn diojn? ");
INSERT INTO epo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tiam Jakob respondis kaj diris al Laban: Mi timis; mi pensis, ke eble vi forrabos de mi viajn filinojn. ");
INSERT INTO epo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Sed tiu, ĉe kiu vi trovos viajn diojn, mortu. En la ĉeesto de niaj parencoj serĉu ĉe mi tion, kio estas via, kaj prenu al vi. Jakob ne sciis, ke Raĥel ilin ŝtelis. ");
INSERT INTO epo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tiam Laban eniris en la tendon de Jakob kaj en la tendon de Lea kaj en la tendon de la du sklavinoj, kaj li ne trovis. Kaj li eliris el la tendo de Lea kaj eniris en la tendon de Raĥel. ");
INSERT INTO epo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Sed Raĥel prenis la domajn diojn kaj metis ilin sub la selon de la kamelo kaj sidiĝis sur ili. Kaj Laban palpe esploris la tutan tendon kaj ne trovis. ");
INSERT INTO epo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kaj ŝi diris al sia patro: Mia sinjoro ne koleru, ke mi ne povas stariĝi antaŭ vi, ĉar mi havas la virinan ordinaraĵon. Kaj li serĉis kaj ne trovis la domajn diojn. ");
INSERT INTO epo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kaj Jakob ekkoleris kaj disputis kun Laban. Kaj Jakob diris al Laban: Kia estas mia kulpo, kia estas mia peko, ke vi persekutas min? ");
INSERT INTO epo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Vi trapalpis ĉiujn miajn apartenaĵojn; kion vi trovis el la apartenaĵoj de via domo? elmetu ĉi tie antaŭ miaj parencoj kaj viaj, kaj ili juĝu inter ni ambaŭ. ");
INSERT INTO epo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Jam dudek jarojn mi estas ĉe vi; viaj ŝafoj kaj kaproj ne estis seninfanaj; la virŝafojn el via brutaro mi ne manĝis; ");
INSERT INTO epo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","kion sovaĝaj bestoj disŝiris, tion mi ne alportis al vi: ĝi estis mia malprofito; de mi vi postulis ĉion, kio estis ŝtelita en tago aŭ ŝtelita en nokto; ");
INSERT INTO epo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","dum la tago min konsumis la varmego, kaj dum la nokto la malvarmo; kaj dormo kuris for de miaj okuloj. ");
INSERT INTO epo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tiaj estis la dudek jaroj, dum kiuj mi servis vin en via domo, dek kvar jarojn pro viaj du filinoj kaj ses jarojn pro viaj brutoj; kaj vi ŝanĝis mian laborpagon dekfoje. ");
INSERT INTO epo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Se ne estus kun mi la Dio de mia patro, la Dio de Abraham kaj Timo de Isaak, vi nun foririgus min kun nenio. Mian mizeron kaj la laboron de miaj manoj vidis Dio kaj ĝustigis vin hieraŭ. ");
INSERT INTO epo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tiam Laban respondis kaj diris al Jakob: La filinoj estas miaj filinoj, kaj la infanoj estas miaj infanoj, kaj la brutoj estas miaj brutoj, kaj ĉio, kion vi vidas, estas mia; sed kion mi povas fari hodiaŭ al miaj filinoj, kaj al iliaj infanoj, kiujn ili naskis? ");
INSERT INTO epo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nun ni faru interligon, mi kaj vi, kaj ĝi estu atesto inter mi kaj vi. ");
INSERT INTO epo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tiam Jakob prenis ŝtonon kaj starigis ĝin kiel memorsignon. ");
INSERT INTO epo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Kaj Jakob diris al siaj parencoj: Kolektu ŝtonojn. Kaj ili prenis ŝtonojn kaj faris monteton; kaj ili manĝis tie sur la monteto. ");
INSERT INTO epo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Kaj Laban donis al ĝi la nomon Jegar-Sahaduta, sed Jakob donis al ĝi la nomon Galeed. ");
INSERT INTO epo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban diris: Ĉi tiu monteto estu nun atesto inter mi kaj vi; tial ĝi ricevis la nomon Galeed; ");
INSERT INTO epo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ankaŭ la nomon Micpa; ĉar li diris: Dio observu inter mi kaj vi, kiam ni malaperos unu de la alia. ");
INSERT INTO epo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Se vi agos malbone kontraŭ miaj filinoj kaj se vi prenos aliajn edzinojn krom miaj filinoj, tiam, se neniu estos ĉe ni, vidu, ke Dio estas atestanto inter mi kaj vi. ");
INSERT INTO epo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kaj Laban diris al Jakob: Jen estas ĉi tiu monteto, kaj jen estas la memorsigno, kiun mi starigis inter mi kaj vi; ");
INSERT INTO epo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","atesto estu ĉi tiu monteto, kaj atesto estu la memorsigno, ke mi ne transiros al vi trans ĉi tiun monteton kaj vi ne transiros al mi trans ĉi tiun monteton kaj trans la memorsignon por malbono. ");
INSERT INTO epo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","La Dio de Abraham kaj la Dio de Naĥor juĝu inter ni, la Dio de ilia patro. Kaj Jakob ĵuris al li per la Timo de sia patro Isaak. ");
INSERT INTO epo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kaj Jakob oferbuĉis oferon sur la monto, kaj li invitis siajn parencojn manĝi panon; kaj ili manĝis panon kaj tradormis la nokton sur la monto. ");
INSERT INTO epo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban leviĝis frue matene kaj kisis siajn infanojn kaj siajn filinojn kaj benis ilin, kaj foriris; kaj Laban reiris al sia loko. ");
INSERT INTO epo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kaj Jakob iris sian vojon. Kaj renkontiĝis kun li anĝeloj de Dio. ");
INSERT INTO epo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kaj Jakob diris, kiam li ilin vidis: Tio estas militistaro de Dio; kaj li donis al tiu loko la nomon Maĥanaim. ");
INSERT INTO epo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakob sendis antaŭ si senditojn al sia frato Esav, en la landon Seir, en la regionon de Edom. ");
INSERT INTO epo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kaj li ordonis al ili jene: Tiele diru al mia sinjoro Esav: Jen kion diris via sklavo Jakob: Mi loĝis ĉe Laban kaj restis tie ĝis nun. ");
INSERT INTO epo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mi havas bovojn kaj azenojn, ŝafojn kaj sklavojn kaj sklavinojn; kaj mi sendas, por sciigi mian sinjoron, por ke mi akiru vian favoron. ");
INSERT INTO epo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kaj la senditoj revenis al Jakob, kaj diris: Ni venis al via frato Esav; li iras renkonte al vi, kaj kvarcent homoj iras kune kun li. ");
INSERT INTO epo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Tiam Jakob tre ektimis kaj afliktiĝis. Kaj li dividis la homojn, kiuj estis kun li, kaj la ŝafojn kaj la bovojn kaj la kamelojn, en du taĉmentojn; ");
INSERT INTO epo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","kaj li diris: Se Esav venos al unu taĉmento kaj venkobatos ĝin, tiam la restinta taĉmento sin savos. ");
INSERT INTO epo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kaj Jakob diris: Dio de mia patro Abraham kaj Dio de mia patro Isaak, Eternulo, kiu diris al mi: Reiru en vian landon kaj en vian naskiĝlokon, kaj Mi faros al vi bonon; ");
INSERT INTO epo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","mi estas tro malgranda por ĉiuj favorkoraĵoj kaj por la tuta bonaĵo, kiun Vi faris al Via sklavo; ĉar kun mia bastono mi transiris ĉi tiun Jordanon, kaj nun mi havas du taĉmentojn. ");
INSERT INTO epo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Savu min de la mano de mia frato, de la mano de Esav; ĉar mi timas lin, ke li eble venos kaj mortigos ĉe mi patrinon kun la infanoj. ");
INSERT INTO epo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Vi diris ja: Mi faros al vi bonon, kaj Mi faros vian idaron tia, kia estas la apudmara sablo, kiun oni ne povas kalkuli pro multegeco. ");
INSERT INTO epo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kaj li pasigis tie la nokton. Kaj li prenis el tio, kion li havis sub la mano, donacon por sia frato Esav: ");
INSERT INTO epo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ducent kaprinojn kaj dudek virkaprojn, ducent ŝafinojn kaj dudek virŝafojn, ");
INSERT INTO epo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tridek mamnutrantajn kamelojn kun iliaj idoj, kvardek bovinojn kaj dek virbovojn, dudek azeninojn kaj dek azenidojn. ");
INSERT INTO epo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kaj li transdonis en la manojn de siaj sklavoj ĉiun gregon aparte, kaj li diris al siaj sklavoj: Iru antaŭ mi kaj lasu liberan interspacon inter unu grego kaj alia. ");
INSERT INTO epo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kaj al la unua li ordonis jene: Se vin renkontos mia frato Esav, kaj demandos vin: Kies vi estas? kaj kien vi iras? kaj al kiu apartenas tio, kio estas antaŭ vi? ");
INSERT INTO epo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tiam diru: Al via sklavo Jakob; ĝi estas donaco, sendata al mia sinjoro Esav, kaj jen li ankaŭ mem estas post ni. ");
INSERT INTO epo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kaj li ordonis ankaŭ al la dua, ankaŭ al la tria, ankaŭ al ĉiuj, kiuj iris post la gregoj, dirante: Tiamaniere parolu al Esav, kiam vi lin renkontos. ");
INSERT INTO epo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kaj diru: Jen ankaŭ via sklavo Jakob iras post ni. Ĉar li pensis: Mi pardonemigos lin per la donaco, kiu iras antaŭ mi, kaj poste mi vidos lian vizaĝon; eble li akceptos min favore. ");
INSERT INTO epo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kaj la donaco pasis antaŭ li; sed li pasigis tiun nokton en la tendaro. ");
INSERT INTO epo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kaj li leviĝis en tiu nokto, kaj prenis siajn du edzinojn kaj siajn du sklavinojn kaj siajn dek unu infanojn, kaj transpasis la vadejon de Jabok. ");
INSERT INTO epo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kaj li prenis ilin kaj transirigis ilin trans la riveron, kaj transigis tion, kion li havis. ");
INSERT INTO epo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kaj Jakob restis sola. Kaj iu luktis kun li ĝis la apero de la matenruĝo. ");
INSERT INTO epo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Vidinte, ke li ne povas lin venki, tiu tuŝis la artikon de lia femuro; kaj la femuro de Jakob elartikiĝis, dum li luktis kun tiu. ");
INSERT INTO epo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kaj tiu diris: Forliberigu min, ĉar leviĝis la matenruĝo. Sed li diris: Mi ne forliberigos vin, antaŭ ol vi min benos. ");
INSERT INTO epo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kaj tiu diris al li: Kia estas via nomo? Kaj li respondis: Jakob. ");
INSERT INTO epo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tiam tiu diris: Ne Jakob estu de nun via nomo, sed Izrael; ĉar vi luktis kun Dio kaj kun homoj, kaj vi venkis. ");
INSERT INTO epo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kaj Jakob demandis, dirante: Diru vian nomon. Sed tiu diris: Por kio vi demandas mian nomon? Kaj li benis lin tie. ");
INSERT INTO epo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kaj Jakob donis al tiu loko la nomon Penuel, dirante: Ĉar mi vidis Dion vizaĝon kontraŭ vizaĝo, kaj mia animo saviĝis. ");
INSERT INTO epo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","La suno leviĝis antaŭ li, kiam li trapasis Penuelon; kaj li lamis per sia femuro. ");
INSERT INTO epo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tial la Izraelidoj ne manĝas ĝis la nuna tempo la tendenon, kiu estas sur la artiko de la femuro, ĉar tiu tuŝis la femuran artikon de Jakob ĉe la tendeno. ");
INSERT INTO epo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakob levis siajn okulojn, kaj vidis, ke jen venas Esav kaj kun li kvarcent homoj. Tiam li dividis la infanojn de Lea kaj de Raĥel kaj de la du sklavinoj. ");
INSERT INTO epo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kaj li starigis la sklavinojn kaj iliajn infanojn antaŭe, Lean kun ŝiaj infanoj poste, kaj Raĥelon kun Jozef en la fino. ");
INSERT INTO epo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kaj li mem pasis preter ilin, kaj kliniĝis ĝis la tero sep fojojn, antaŭ ol li atingis sian fraton. ");
INSERT INTO epo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Sed Esav kuris al li renkonte kaj ĉirkaŭprenis lin, kaj ĵetis sin sur lian kolon kaj kisis lin; kaj ili ploris. ");
INSERT INTO epo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esav levis siajn okulojn kaj ekvidis la virinojn kaj la infanojn, kaj diris: Kiuj estas ĉe vi ĉi tiuj? Jakob respondis: La infanoj, kiujn Dio favore donis al via sklavo. ");
INSERT INTO epo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tiam alproksimiĝis la sklavinoj, ili kaj iliaj infanoj, kaj profunde kliniĝis. ");
INSERT INTO epo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Poste alproksimiĝis ankaŭ Lea kaj ŝiaj infanoj kaj kliniĝis; fine alproksimiĝis Jozef kaj Raĥel kaj kliniĝis. ");
INSERT INTO epo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Tiam Esav diris: Kio estas tiu tuta taĉmento, kiun mi renkontis? Kaj Jakob respondis: Por akiri la favoron de mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Sed Esav diris: Mi havas multe, mia frato; kio apartenas al vi, tio restu ĉe vi. ");
INSERT INTO epo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kaj Jakob diris: Ho ne! se mi akiris vian favoron, prenu mian donacon el mia mano; ĉar mi vidis vian vizaĝon, kvazaŭ mi vidus la vizaĝon de Dio, kaj vi montriĝis favora al mi. ");
INSERT INTO epo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Prenu mian benon, kiu estas alportita al vi; ĉar Dio favore donis al mi kaj mi havas ĉion. Kaj li insistis, kaj tiu prenis. ");
INSERT INTO epo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kaj Esav diris: Ni leviĝu kaj iru, kaj mi iros apud vi. ");
INSERT INTO epo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sed Jakob diris al li: Mia sinjoro scias, ke la infanoj estas malfortaj, kaj la ŝafoj kaj bovoj ĉe mi estas tro junaj; se oni pelos ilin dum unu tago, la brutaro mortos. ");
INSERT INTO epo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mia sinjoro iru antaŭ sia sklavo, kaj mi kondukos malrapide, kiel iros la brutoj, kiuj estas antaŭ mi, kaj kiel iros la infanoj, ĝis mi venos al mia sinjoro en Seir. ");
INSERT INTO epo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tiam Esav diris: Mi restigos ĉe vi iujn el la homoj, kiuj estas kun mi. Sed Jakob diris: Por kio? lasu min nur posedi la favoron de mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kaj en tiu tago Esav returne foriris sian vojon al Seir. ");
INSERT INTO epo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kaj Jakob ekiris al Sukot kaj konstruis al si domon, kaj por siaj brutoj li faris kabanojn; tial la loko ricevis la nomon Sukot. ");
INSERT INTO epo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Veninte el Mezopotamio, Jakob alvenis bonstate en la urbo de Ŝeĥem, kiu estas en la lando Kanaana; kaj li starigis sian tendaron antaŭ la urbo. ");
INSERT INTO epo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kaj la kampoparton, sur kiu li starigis sian tendon, li aĉetis el la manoj de la filoj de Ĥamor, la patro de Ŝeĥem, por cent kesitoj. ");
INSERT INTO epo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kaj li starigis tie altaron, kaj li nomis ĝin El, la Dio de Izrael. ");
INSERT INTO epo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, la filino de Lea, kiun ŝi naskis al Jakob, eliris, por vidi la filinojn de la lando. ");
INSERT INTO epo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kaj vidis ŝin Ŝeĥem, filo de Ĥamor la Ĥivido, princo de la lando, kaj li prenis ŝin kaj kuŝis kun ŝi kaj faris al ŝi perfortaĵon. ");
INSERT INTO epo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Kaj algluiĝis lia animo al Dina, la filino de Jakob, kaj li ekamis la junulinon kaj parolis al la koro de la junulino. ");
INSERT INTO epo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kaj Ŝeĥem diris al sia patro Ĥamor jene: Prenu por mi ĉi tiun knabinon kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakob aŭdis, ke li senhonorigis lian filinon Dina; sed liaj filoj estis kun liaj brutoj sur la kampo, tial Jakob silentis ĝis ilia veno. ");
INSERT INTO epo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kaj Ĥamor, la patro de Ŝeĥem, eliris al Jakob, por paroli kun li. ");
INSERT INTO epo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Sed la filoj de Jakob venis de la kampo. Kiam ili aŭdis, la viroj ĉagreniĝis kaj forte koleriĝis, ke li faris malnoblaĵon en Izrael, kuŝinte kun la filino de Jakob, kio ne devis esti farata. ");
INSERT INTO epo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ĥamor ekparolis al ili, dirante: Ŝeĥem, mia filo, deziregas per sia animo vian filinon; donu ŝin al li kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kaj boparenciĝu kun ni: viajn filinojn donu al ni, kaj niajn filinojn prenu al vi. ");
INSERT INTO epo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kaj loĝu kun ni, kaj la lando estos antaŭ vi; loĝu kaj faru negocojn kaj akiru posedaĵojn en ĝi. ");
INSERT INTO epo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kaj Ŝeĥem diris al ŝia patro kaj al ŝiaj fratoj: Estu favoraj al mi; kaj kion vi diros al mi, mi donos. ");
INSERT INTO epo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Postulu de mi tre grandan doton kaj donacojn, kaj mi donos, kion vi diros al mi; nur donu al mi la junulinon kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kaj la filoj de Jakob respondis al Ŝeĥem kaj al lia patro Ĥamor ruze, kaj parolis tiel pro tio, ke li senhonorigis ilian fratinon Dina; ");
INSERT INTO epo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","kaj ili diris al ili: Ni ne povas fari tion kaj doni nian fratinon al viro, kiu ne estas cirkumcidita; ĉar tio estus por ni hontindaĵo. ");
INSERT INTO epo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nur tiam ni donos al vi nian konsenton, se vi estos kiel ni kaj cirkumcidos ĉe vi ĉiun virseksulon. ");
INSERT INTO epo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tiam ni donos niajn filinojn al vi kaj viajn filinojn ni prenos al ni, kaj ni loĝos kun vi, kaj ni estos unu popolo. ");
INSERT INTO epo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Sed se vi ne konsentos lasi cirkumcidi vin, tiam ni prenos nian filinon kaj foriros. ");
INSERT INTO epo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ilia parolo plaĉis al Ĥamor, kaj al Ŝeĥem, la filo de Ĥamor. ");
INSERT INTO epo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kaj la junulo ne prokrastis fari la aferon, ĉar li deziris la filinon de Jakob; kaj li estis la plej honorata inter ĉiuj domanoj de sia patro. ");
INSERT INTO epo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kaj Ĥamor kaj lia filo Ŝeĥem venis al la pordego de sia urbo, kaj ekparolis al la loĝantoj de sia urbo, dirante: ");
INSERT INTO epo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Tiuj homoj estas pacaj kun ni; tial ili loĝu en la lando kaj faru en ĝi negocojn; la lando estas ja grandspaca por ili. Iliajn filinojn ni prenu al ni kiel edzinojn, kaj niajn filinojn ni donu al ili. ");
INSERT INTO epo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Sed nur en tia okazo tiuj homoj konsentas loĝi kun ni kaj esti unu popolo, se ni cirkumcidos ĉe ni ĉiun virseksulon, kiel ili estas cirkumciditaj. ");
INSERT INTO epo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ilia akiritaĵo kaj havaĵo kaj ĉiuj iliaj brutoj fariĝos ja niaj, se ni nur donos al ili nian konsenton kaj ili loĝos kun ni. ");
INSERT INTO epo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kaj obeis al Ĥamor kaj al lia filo Ŝeĥem ĉiuj elirantaj el la pordego de lia urbo; kaj cirkumcidiĝis ĉiuj virseksuloj, ĉiuj elirantaj el la pordego de lia urbo. ");
INSERT INTO epo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","En la tria tago, kiam ili estis malsanaj, du filoj de Jakob, Simeon kaj Levi, fratoj de Dina, prenis ĉiu sian glavon kaj venis sentime en la urbon kaj mortigis ĉiujn virseksulojn. ");
INSERT INTO epo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Kaj Ĥamoron kaj lian filon Ŝeĥem ili mortigis per glavo, kaj prenis Dinan el la domo de Ŝeĥem kaj eliris. ");
INSERT INTO epo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","La filoj de Jakob venis al la mortigitoj, kaj prirabis la urbon pro tio, ke ili senhonorigis ilian fratinon. ");
INSERT INTO epo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Iliajn ŝafojn kaj iliajn bovojn kaj iliajn azenojn, kaj ĉion, kio estis en la urbo, kaj tion, kio estis sur la kampo, ili prenis. ");
INSERT INTO epo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Kaj ilian tutan riĉon kaj ĉiujn iliajn infanojn kaj iliajn edzinojn ili malliberigis, kaj rabis ĉion, kio estis en la domoj. ");
INSERT INTO epo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tiam Jakob diris al Simeon kaj al Levi: Vi afliktis min kaj faris min malaminda por la loĝantoj de la lando, por la Kanaanidoj kaj Perizidoj. Mi havas ja malmulte da homoj; kiam ili kolektiĝos kontraŭ mi kaj venkobatos min, tiam estos ekstermita mi kaj mia domo. ");
INSERT INTO epo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Sed ili diris: Ĉu estas permesite agi kun nia fratino kiel kun publikulino? ");
INSERT INTO epo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kaj Dio diris al Jakob: Leviĝu, iru al Bet-El kaj loĝu tie; kaj faru tie altaron al Dio, kiu aperis al vi, kiam vi kuris de via frato Esav. ");
INSERT INTO epo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tiam Jakob diris al sia domanaro, kaj al ĉiuj, kiuj estis kun li: Forigu la fremdajn diojn, kiuj estas inter vi, kaj puriĝu kaj ŝanĝu viajn vestojn. ");
INSERT INTO epo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kaj ni leviĝu, kaj ni iru al Bet-El; kaj mi faros tie altaron al Dio, kiu atentis min en la tago de mia mizero, kaj estis kun mi sur la vojo, kiun mi iris. ");
INSERT INTO epo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kaj ili donis al Jakob ĉiujn fremdajn diojn, kiuj estis en iliaj manoj, kaj la ringojn, kiuj estis en iliaj oreloj; kaj Jakob enfosis ilin sub la kverko, kiu estis apud Ŝeĥem. ");
INSERT INTO epo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kaj ili ekiris. Kaj timo de Dio venis sur la urbojn, kiuj estis ĉirkaŭ ili, kaj ili ne persekutis la filojn de Jakob. ");
INSERT INTO epo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakob venis al la urbo Luz, kiu estas en la lando Kanaana kaj havas ankaŭ la nomon Bet-El, li kaj ĉiuj homoj, kiuj estis kun li. ");
INSERT INTO epo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Kaj li konstruis tie altaron, kaj donis al la loko la nomon El-Bet-El; ĉar tie aperis al li Dio, kiam li kuris de sia frato. ");
INSERT INTO epo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tiam mortis Debora, la mamnutrintino de Rebeka, kaj oni ŝin enterigis apud Bet-El, sub la kverko. Kaj tiu loko ricevis la nomon Alon-Baĥut. ");
INSERT INTO epo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kaj denove Dio aperis al Jakob, kiam li revenis el Mezopotamio, kaj benis lin. ");
INSERT INTO epo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kaj Dio diris al li: Via nomo estas Jakob; tamen ne plue estu nomata Jakob, sed Izrael estu via nomo. Kaj Li donis al li la nomon Izrael. ");
INSERT INTO epo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kaj Dio diris al li: Mi estas Dio la Plejpotenca; fruktu kaj multiĝu; popolo kaj popolaro fariĝos el vi, kaj reĝoj eliros el via lumbo. ");
INSERT INTO epo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kaj la landon, kiun Mi donis al Abraham kaj al Isaak, Mi donos al vi, kaj al via idaro post vi Mi donos la landon. ");
INSERT INTO epo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kaj Dio forleviĝis de li sur la loko, kie Li parolis kun li. ");
INSERT INTO epo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakob starigis monumenton sur la loko, kie Li parolis kun li, monumenton ŝtonan; kaj li verŝis sur ĝin verŝoferon kaj verŝis sur ĝin oleon. ");
INSERT INTO epo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kaj al la loko, kie Dio parolis kun li, Jakob donis la nomon Bet-El. ");
INSERT INTO epo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kaj ili forlasis Bet-Elon. Kiam restis ankoraŭ negranda interspaco, por veni al Efrata, Raĥel naskis, kaj ŝia akuŝiĝo estis malfacila. ");
INSERT INTO epo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Dum ŝia akuŝiĝa suferado la akuŝistino diris al ŝi: Ne timu, ĉar ankaŭ ĉi tiu ĉe vi estas filo. ");
INSERT INTO epo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Dum la elirado de ŝia animo, ĉar ŝi estis mortanta, ŝi donis al li la nomon Ben-Oni; sed lia patro donis al li la nomon Benjamen. ");
INSERT INTO epo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kaj Raĥel mortis, kaj oni enterigis ŝin sur la vojo al Efrata, kiu estas Bet-Leĥem. ");
INSERT INTO epo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kaj Jakob starigis monumenton super ŝia tombo. Tio estas la tomba monumento de Raĥel ĝis la nuna tago. ");
INSERT INTO epo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kaj Izrael formigris, kaj starigis sian tendon transe de la turo Eder. ");
INSERT INTO epo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","En la tempo, kiam Izrael loĝis en tiu lando, Ruben iris kaj kuŝis kun Bilha, la kromvirino de lia patro. Kaj pri tio aŭdis Izrael. La filoj de Jakob estis dek du: ");
INSERT INTO epo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","la filoj de Lea: Ruben, la unuenaskito de Jakob, kaj Simeon kaj Levi kaj Jehuda kaj Isaĥar kaj Zebulun; ");
INSERT INTO epo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","la filoj de Raĥel: Jozef kaj Benjamen; ");
INSERT INTO epo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","kaj la filoj de Bilha, sklavino de Raĥel: Dan kaj Naftali; ");
INSERT INTO epo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","kaj la filoj de Zilpa, sklavino de Lea: Gad kaj Aŝer. Tio estas la filoj de Jakob, kiuj naskiĝis al li en Mezopotamio. ");
INSERT INTO epo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kaj Jakob venis al sia patro Isaak en Mamre, al Kirjat-Arba (tio estas Ĥebron), kie vivis fremdule Abraham kaj Isaak. ");
INSERT INTO epo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaak havis la aĝon de cent okdek jaroj. ");
INSERT INTO epo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Kaj Isaak konsumiĝis kaj mortis kaj alkolektiĝis al sia popolo, estante maljuna kaj sata de vivo. Kaj lin enterigis liaj filoj Esav kaj Jakob. ");
INSERT INTO epo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Jen estas la generaciaro de Esav, kiu ankaŭ estas Edom. ");
INSERT INTO epo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esav prenis siajn edzinojn el la Kanaanidinoj: Adan, filinon de Elon la Ĥetido, kaj Oholibaman, filinon de Ana, filino de Cibeon la Ĥivido, ");
INSERT INTO epo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","kaj Basmaton, filinon de Iŝmael, fratinon de Nebajot. ");
INSERT INTO epo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Kaj Ada naskis al Esav Elifazon, kaj Basmat naskis Reuelon. ");
INSERT INTO epo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Kaj Oholibama naskis Jeuŝon kaj Jalamon kaj Koraĥon. Tio estas la filoj de Esav, kiuj naskiĝis al li en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kaj Esav prenis siajn edzinojn kaj siajn filojn kaj siajn filinojn kaj ĉiujn siajn domanojn kaj sian havon kaj ĉiujn siajn brutojn kaj sian tutan akiritaĵon, kiun li akiris en la lando Kanaana; kaj foriris en alian landon, for de sia frato Jakob. ");
INSERT INTO epo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ĉar ilia havo estis tiel granda, ke ili ne povis loĝi kune; kaj la lando, en kiu ili vivis fremdule, ne povis teni ilin pro la grandeco de iliaj brutaroj. ");
INSERT INTO epo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kaj Esav ekloĝis sur la monto Seir; Esav estas ankaŭ Edom. ");
INSERT INTO epo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Kaj jen estas la generaciaro de Esav, la patro de la Edomidoj, sur la monto Seir: ");
INSERT INTO epo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","jen estas la nomoj de la filoj de Esav: Elifaz, filo de Ada, edzino de Esav; Reuel, filo de Basmat, edzino de Esav. ");
INSERT INTO epo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Kaj la filoj de Elifaz estis: Teman, Omar, Cefo kaj Gatam kaj Kenaz. ");
INSERT INTO epo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Kaj Timna estis kromvirino de Elifaz, filo de Esav, kaj ŝi naskis al Elifaz Amalekon. Tio estas la filoj de Ada, edzino de Esav. ");
INSERT INTO epo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Kaj jen estas la filoj de Reuel: Naĥat kaj Zeraĥ, Ŝama kaj Miza. Tio estas la filoj de Basmat, edzino de Esav. ");
INSERT INTO epo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Kaj jen estas la filoj de Oholibama, filino de Ana, filino de Cibeon, edzino de Esav: ŝi naskis al Esav Jeuŝon kaj Jalamon kaj Koraĥon. ");
INSERT INTO epo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Jen estas la ĉefoj de la filoj de Esav: la filoj de Elifaz, unuenaskito de Esav: ĉefo Teman, ĉefo Omar, ĉefo Cefo, ĉefo Kenaz, ");
INSERT INTO epo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ĉefo Koraĥ, ĉefo Gatam, ĉefo Amalek. Tio estas la ĉefoj de Elifaz en la lando de Edom. Tio estas la filoj de Ada. ");
INSERT INTO epo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Kaj jen estas la filoj de Reuel, filo de Esav: ĉefo Naĥat, ĉefo Zeraĥ, ĉefo Ŝama, ĉefo Miza. Tio estas la ĉefoj de Reuel en la lando de Edom. Tio estas la filoj de Basmat, edzino de Esav. ");
INSERT INTO epo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Kaj jen estas la filoj de Oholibama, edzino de Esav: ĉefo Jeuŝ, ĉefo Jalam, ĉefo Koraĥ. Tio estas la ĉefoj de Oholibama, filino de Ana, edzino de Esav. ");
INSERT INTO epo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Tio estas la filoj de Esav, kaj tio estas iliaj ĉefoj. Tio estas Edom. ");
INSERT INTO epo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Jen estas la filoj de Seir la Ĥorido, kiuj loĝis en la lando: Lotan kaj Ŝobal kaj Cibeon kaj Ana ");
INSERT INTO epo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","kaj Diŝon kaj Ecer kaj Diŝan. Tio estas la ĉefoj de la Ĥoridoj, filoj de Seir, en la lando de Edom. ");
INSERT INTO epo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","La filoj de Lotan estis: Ĥori kaj Hemam; kaj la fratino de Lotan estis Timna. ");
INSERT INTO epo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kaj jen estas la filoj de Ŝobal: Alvan kaj Manaĥat kaj Ebal, Ŝefo kaj Onam. ");
INSERT INTO epo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kaj jen estas la infanoj de Cibeon: Aja kaj Ana. Tio estas tiu Ana, kiu trovis la varmajn akvojn en la dezerto, kiam li paŝtis la azenojn de sia patro Cibeon. ");
INSERT INTO epo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kaj jen estas la infanoj de Ana: Diŝon, kaj Oholibama, filino de Ana. ");
INSERT INTO epo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kaj jen estas la filoj de Diŝon: Ĥemdan kaj Eŝban kaj Jitran kaj Keran. ");
INSERT INTO epo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Jen estas la filoj de Ecer: Bilhan kaj Zaavan kaj Akan. ");
INSERT INTO epo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Jen estas la filoj de Diŝan: Uc kaj Aran. ");
INSERT INTO epo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Jen estas la ĉefoj de la Ĥoridoj: ĉefo Lotan, ĉefo Ŝobal, ĉefo Cibeon, ĉefo Ana, ");
INSERT INTO epo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ĉefo Diŝon, ĉefo Ecer, ĉefo Diŝan. Tio estas la ĉefoj de la Ĥoridoj, laŭ la ordo de ilia ĉefeco en la lando Seir. ");
INSERT INTO epo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kaj jen estas la reĝoj, kiuj reĝis en la lando de Edom, antaŭ ol aperis reĝoj ĉe la Izraelidoj: ");
INSERT INTO epo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","En Edom reĝis Bela, filo de Beor, kaj la nomo de lia urbo estis Dinhaba. ");
INSERT INTO epo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kiam Bela mortis, ekreĝis anstataŭ li Jobab, filo de Zeraĥ el Bocra. ");
INSERT INTO epo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kiam mortis Jobab, ekreĝis anstataŭ li Ĥuŝam el la lando de la Temananoj. ");
INSERT INTO epo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kiam mortis Ĥuŝam, ekreĝis anstataŭ li Hadad, filo de Bedad, kiu venkobatis la Midjanidojn sur la kampo de Moab; kaj la nomo de lia urbo estis Avit. ");
INSERT INTO epo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kiam mortis Hadad, ekreĝis anstataŭ li Samla el Masreka. ");
INSERT INTO epo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kiam mortis Samla, ekreĝis anstataŭ li Ŝaul el Reĥobot ĉe la Rivero. ");
INSERT INTO epo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kiam mortis Ŝaul, ekreĝis anstataŭ li Baal-Ĥanan, filo de Aĥbor. ");
INSERT INTO epo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kiam mortis Baal-Ĥanan, filo de Aĥbor, ekreĝis anstataŭ li Hadar; la nomo de lia urbo estis Pau, kaj la nomo de lia edzino estis Mehetabel, filino de Matred, filino de Me-Zahab. ");
INSERT INTO epo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Kaj jen estas la nomoj de la ĉefoj de Esav, laŭ iliaj gentoj, lokoj, kaj nomoj: ĉefo Timna, ĉefo Alva, ĉefo Jetet, ");
INSERT INTO epo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ĉefo Oholibama, ĉefo Ela, ĉefo Pinon, ");
INSERT INTO epo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ĉefo Kenaz, ĉefo Teman, ĉefo Mibcar, ");
INSERT INTO epo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ĉefo Magdiel, ĉefo Iram. Tio estas la ĉefoj de Edom, kiel ili loĝis en la lando, posedata de ili. Esav estis la patro de la Edomidoj. ");
INSERT INTO epo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakob loĝis en la lando, en kiu lia patro loĝis fremdule, en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jen estas la generaciaro de Jakob. Jozef, havante la aĝon de dek sep jaroj, paŝtis kune kun siaj fratoj la brutaron; li estis knabo kune kun la filoj de Bilha kaj la filoj de Zilpa, la edzinoj de lia patro; kaj malbonajn famojn pri ili Jozef raportadis al ilia patro. ");
INSERT INTO epo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Kaj Izrael amis Jozefon pli ol ĉiujn siajn filojn, ĉar li estis por li filo naskita en maljuneco; kaj li faris al li mikskoloran veston. ");
INSERT INTO epo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ĉar la fratoj vidis, ke lin ilia patro amas pli ol ĉiujn liajn fratojn, tial ili malamis lin kaj ne povis paroli kun li pace. ");
INSERT INTO epo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Jozef havis sonĝon, kaj li rakontis ĝin al siaj fratoj; tiam ili ekmalamis lin ankoraŭ pli. ");
INSERT INTO epo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Li diris al ili: Aŭskultu la sonĝon, kiun mi sonĝis: ");
INSERT INTO epo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ni ligis garbojn meze de la kampo; kaj jen mia garbo stariĝis kaj restis starante, kaj viaj garboj ĝin ĉirkaŭis kaj profunde kliniĝis antaŭ mia garbo. ");
INSERT INTO epo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tiam liaj fratoj diris al li: Ĉu vi estos reĝo super ni? aŭ ĉu vi regos super ni? Kaj ili ankoraŭ pli ekmalamis lin pro liaj sonĝoj kaj pro liaj vortoj. ");
INSERT INTO epo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kaj li sonĝis ankoraŭ alian sonĝon kaj rakontis ĝin al siaj fratoj, kaj diris: Mi sonĝis ankoraŭ unu sonĝon: jen la suno kaj la luno kaj dek unu steloj kliniĝas antaŭ mi. ");
INSERT INTO epo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kaj li rakontis al sia patro kaj al siaj fratoj; kaj lia patro faris al li riproĉon, kaj diris al li: Kion vi volas kun tiu sonĝo, kiun vi sonĝis? ĉu mi kaj via patrino kaj viaj fratoj venos, por kliniĝi antaŭ vi ĝis la tero? ");
INSERT INTO epo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kaj liaj fratoj lin enviis, sed lia patro konservis en la memoro la aferon. ");
INSERT INTO epo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Liaj fratoj iris paŝti la ŝafojn de sia patro en Ŝeĥem. ");
INSERT INTO epo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kaj Izrael diris al Jozef: Viaj fratoj paŝtas ja en Ŝeĥem; venu do, mi sendos vin al ili. Kaj tiu respondis al li: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kaj Izrael diris al li: Iru, rigardu, kiel fartas viaj fratoj kaj kiel fartas la ŝafoj, kaj alportu al mi respondon. Kaj li forsendis lin el la valo de Ĥebron, kaj tiu venis Ŝeĥemon. ");
INSERT INTO epo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Kaj iu viro trovis lin, kaj vidis, ke li erarvagas sur la kampo; kaj la viro demandis lin: Kion vi serĉas? ");
INSERT INTO epo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kaj li diris: Miajn fratojn mi serĉas; diru al mi, kie ili paŝtas. ");
INSERT INTO epo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kaj la viro diris: Ili foriris de ĉi tie; ĉar mi aŭdis, ke ili diris: Ni iru al Dotan. Kaj Jozef iris serĉi siajn fratojn, kaj trovis ilin en Dotan. ");
INSERT INTO epo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kaj ili ekvidis lin de malproksime; kaj antaŭ ol li alproksimiĝis al ili, naskiĝis en ili la malbona intenco mortigi lin. ");
INSERT INTO epo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kaj ili diris unu al alia: Jen tiu sonĝisto venas; ");
INSERT INTO epo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","nun ni iru kaj mortigu lin, kaj ni ĵetu lin en unu el la putoj, kaj ni diru, ke sovaĝa besto lin formanĝis; kaj ni vidos, kio fariĝos el liaj sonĝoj. ");
INSERT INTO epo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Sed tion aŭdis Ruben kaj savis lin el iliaj manoj, kaj diris: Ni ne mortigu lin. ");
INSERT INTO epo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kaj Ruben diris al ili: Ne verŝu sangon; ĵetu lin en ĉi tiun puton, kiu estas en la dezerto, sed manon ne metu sur lin. Ĉar li intencis savi lin el iliaj manoj kaj revenigi lin al sia patro. ");
INSERT INTO epo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kaj kiam Jozef venis al siaj fratoj, ili deprenis de li lian veston, la mikskoloran veston, kiu estis sur li; ");
INSERT INTO epo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","kaj ili prenis lin kaj ĵetis lin en la puton; sed la puto estis malplena, akvo ne estis en ĝi. ");
INSERT INTO epo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kiam ili sidiĝis, por manĝi panon, ili levis siajn okulojn, kaj ekvidis, ke jen karavano da Iŝmaelidoj venas el Gilead, kaj iliaj kameloj portas aromaĵojn kaj balzamon kaj mirhon; ili iras, direktante sin al Egiptujo. ");
INSERT INTO epo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kaj Jehuda diris al siaj fratoj: Kian profiton ni havos, se ni mortigos nian fraton kaj kaŝos lian sangon? ");
INSERT INTO epo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venu, ni vendos lin al la Iŝmaelidoj, por ke nia mano ne metiĝu sur lin; ĉar li estas nia frato, nia karno. Kaj liaj fratoj akceptis lian proponon. ");
INSERT INTO epo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kaj kiam la Midjanidoj, la komercistoj, preteriris, ili eltiris kaj levis Jozefon el la puto kaj vendis Jozefon al la Iŝmaelidoj por dudek arĝentaj moneroj; kaj tiuj forkondukis Jozefon al Egiptujo. ");
INSERT INTO epo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kiam Ruben revenis al la puto, li vidis, ke Jozef ne estas en la puto. Kaj li disŝiris siajn vestojn. ");
INSERT INTO epo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kaj li reiris al siaj fratoj, kaj diris: La knabo forestas, kaj kien mi nun iros? ");
INSERT INTO epo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kaj ili prenis la veston de Jozef kaj buĉis kapron kaj trempis la veston en la sango. ");
INSERT INTO epo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kaj ili sendis la mikskoloran veston kaj venigis ĝin al sia patro, kaj dirigis: Ĉi tion ni trovis; rigardu, ĉu ĝi estas la vesto de via filo aŭ ne. ");
INSERT INTO epo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kaj li rekonis ĝin, kaj diris: Ĝi estas la vesto de mia filo! sovaĝa besto lin formanĝis! disŝirita estas Jozef! ");
INSERT INTO epo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kaj Jakob disŝiris siajn vestojn kaj metis sakaĵon ĉirkaŭ sian lumbon kaj funebris pri sia filo multe da tagoj. ");
INSERT INTO epo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kaj ĉiuj liaj filoj kaj filinoj penis konsoli lin, sed li ne volis konsoliĝi, kaj diris: En funebro mi iros en Ŝeolon al mia filo. Tiel ploris pri li lia patro. ");
INSERT INTO epo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Sed la Midjanidoj vendis lin en Egiptujo al Potifar, kortegano de Faraono, estro de la korpogardistoj. ");
INSERT INTO epo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","En tiu tempo Jehuda apartiĝis for de siaj fratoj, kaj ekloĝis apud iu Adulamano, kiu estis nomata Ĥira. ");
INSERT INTO epo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kaj Jehuda vidis tie filinon de iu Kanaanido, nomata Ŝua, kaj li prenis ŝin kaj envenis al ŝi. ");
INSERT INTO epo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kaj ŝi gravediĝis kaj naskis filon; kaj li donis al li la nomon Er. ");
INSERT INTO epo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kaj ŝi denove gravediĝis kaj naskis filon, kaj ŝi donis al li la nomon Onan. ");
INSERT INTO epo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kaj ankoraŭ plue ŝi naskis filon, kaj donis al li la nomon Ŝela. Sed Jehuda estis en Kezib, kiam ŝi naskis tiun. ");
INSERT INTO epo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kaj Jehuda prenis edzinon por sia unuenaskito Er, kaj ŝia nomo estis Tamar. ");
INSERT INTO epo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Sed Er, la unuenaskito de Jehuda, estis malbona antaŭ la okuloj de la Eternulo, kaj la Eternulo lin mortigis. ");
INSERT INTO epo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tiam Jehuda diris al Onan: Envenu al la edzino de via frato, kaj boedziĝu kun ŝi kaj naskigu idaron al via frato. ");
INSERT INTO epo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Sed Onan sciis, ke ne por li estos la idaro; tial, envenante al la edzino de sia frato, li elverŝadis la semon sur la teron, por ne doni idaron al sia frato. ");
INSERT INTO epo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kaj malplaĉis al la Eternulo tio, kion li faris, kaj Li mortigis ankaŭ lin. ");
INSERT INTO epo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tiam Jehuda diris al sia bofilino Tamar: Restu kiel vidvino en la domo de via patro, ĝis grandiĝos mia filo Ŝela. Ĉar li timis, ke eble li ankaŭ mortos, kiel liaj fratoj. Kaj Tamar iris kaj ekloĝis en la domo de sia patro. ");
INSERT INTO epo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Pasis multe da tempo, kaj mortis la filino de Ŝua, la edzino de Jehuda. Kiam Jehuda konsoliĝis, li iris Timnan, al la tondantoj de liaj ŝafoj, li kaj lia amiko, Ĥira la Adulamano. ");
INSERT INTO epo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kaj oni sciigis al Tamar, dirante: Jen via bopatro iras Timnan, por tondi siajn ŝafojn. ");
INSERT INTO epo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tiam ŝi demetis de si siajn vestojn de vidvineco kaj kovris sin per kovrotuko kaj vualis sin, kaj sidiĝis apud la pordo de Enaim, kiu troviĝas sur la vojo al Timna. Ĉar ŝi vidis, ke Ŝela grandiĝis kaj ŝi ne estas donita al li kiel edzino. ");
INSERT INTO epo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kaj Jehuda ŝin vidis, kaj li pensis, ke ŝi estas publikulino, ĉar ŝi kovris sian vizaĝon. ");
INSERT INTO epo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kaj li turnis sin al ŝi ĉe la vojo, kaj diris: Lasu min enveni al vi. Ĉar li ne sciis, ke tio estas lia bofilino. Kaj ŝi diris: Kion vi donos al mi, se vi envenos al mi? ");
INSERT INTO epo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kaj li diris: Mi sendos al vi kapron el la brutaro. Sed ŝi diris: Donu al mi garantiaĵon, ĝis vi sendos. ");
INSERT INTO epo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kaj li diris: Kian garantiaĵon mi donu al vi? Ŝi diris: Vian sigelilon kaj vian ŝnureton, kaj vian bastonon, kiu estas en via mano. Kaj li donis al ŝi kaj envenis al ŝi, kaj ŝi gravediĝis de li. ");
INSERT INTO epo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kaj ŝi leviĝis kaj iris, kaj formetis de si sian kovrotukon kaj surmetis sur sin siajn vestojn de vidvineco. ");
INSERT INTO epo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kaj Jehuda sendis la kapron per sia amiko la Adulamano, por preni la garantiaĵon el la manoj de la virino; sed li ŝin ne trovis. ");
INSERT INTO epo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kaj li demandis la homojn de ŝia loko, dirante: Kie estas la publikulino, kiu sidis en Enaim ĉe la vojo? Kaj ili diris: Ĉi tie ne estis publikulino. ");
INSERT INTO epo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kaj li revenis al Jehuda, kaj diris: Mi ŝin ne trovis, kaj ankaŭ la homoj de la loko diris, ke tie ne estis publikulino. ");
INSERT INTO epo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tiam Jehuda diris: Ŝi prenu ĝin al si, por ke ni ne estu mokataj; mi sendis ja ĉi tiun kapron, sed vi ŝin ne trovis. ");
INSERT INTO epo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Post la paso de tri monatoj oni sciigis al Jehuda, dirante: Tamar, via bofilino, malĉastiĝis, kaj ŝi eĉ gravediĝis de malĉasteco. Tiam Jehuda diris: Elkonduku ŝin, kaj oni ŝin brulmortigu. ");
INSERT INTO epo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kiam oni ŝin kondukis, ŝi sendis, ke oni diru al ŝia bopatro: Mi gravediĝis de la viro, al kiu apartenas ĉi tio. Kaj ŝi diris: Rekonu, al kiu apartenas la sigelilo kaj la ŝnuretoj kaj ĉi tiu bastono. ");
INSERT INTO epo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kaj Jehuda rekonis, kaj li diris: Ŝi estas pli prava ol mi, ĉar mi ne donis ŝin al mia filo Ŝela. Kaj li ŝin ne plue konis. ");
INSERT INTO epo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kiam ŝi devis naski, montriĝis, ke ĝemeloj estas en ŝia ventro. ");
INSERT INTO epo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kaj kiam ŝi estis naskanta, elŝoviĝis la mano de unu infano; kaj la akuŝistino prenis kaj alligis al la mano ruĝan fadenon, dirante: Ĉi tiu eliris la unua. ");
INSERT INTO epo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Sed kiam li retiris sian manon, eliris lia frato. Kaj ŝi diris: Kial vi faris por vi traŝiron? Kaj oni donis al li la nomon Perec. ");
INSERT INTO epo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Poste eliris lia frato, kiu havis sur sia mano la ruĝan fadenon. Kaj oni donis al li la nomon Zeraĥ. ");
INSERT INTO epo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Jozef estis forkondukita en Egiptujon, kaj lin aĉetis Potifar, kortegano de Faraono, estro de la korpogardistoj, Egipto, el la manoj de la Iŝmaelidoj, kiuj venigis lin tien. ");
INSERT INTO epo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kaj la Eternulo estis kun Jozef, kaj li estis sukcesulo; kaj li estis en la domo de sia sinjoro, la Egipto. ");
INSERT INTO epo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kaj lia sinjoro vidis, ke la Eternulo estas kun li, kaj ke ĉion, kion li faras, la Eternulo sukcesigas en lia mano. ");
INSERT INTO epo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Kaj Jozef akiris lian favoron kaj servis lin; kaj li estrigis lin super sia domo, kaj transdonis en liajn manojn ĉion, kion li havis. ");
INSERT INTO epo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kaj de tiu tempo, kiam li estrigis lin super sia domo, kaj super ĉio, kion li havis, la Eternulo benis la domon de la Egipto pro Jozef, kaj la beno de la Eternulo estis super ĉio, kion li havis, en la domo kaj sur la kampo. ");
INSERT INTO epo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kaj li lasis ĉion, kion li havis, en la manoj de Jozef, kaj li sciis pri nenio, krom nur pri la pano, kiun li manĝis. Kaj Jozef estis gracia kaj bela. ");
INSERT INTO epo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Post kelka tempo la edzino de lia sinjoro ĵetis siajn rigardojn sur Jozefon, kaj diris: Kuŝiĝu kun mi. ");
INSERT INTO epo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Sed li rifuzis, kaj li diris al la edzino de sia sinjoro: Jen, mia sinjoro kontrolas ĉe mi nenion en la domo, kaj ĉion, kion li havas, li transdonis en miajn manojn; ");
INSERT INTO epo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","neniu en ĉi tiu domo estas pli granda ol mi, kaj li retenis de mi nenion, krom vi, ĉar vi estas lia edzino. Kiel do mi faros ĉi tiun grandan malbonagon kaj pekos antaŭ Dio? ");
INSERT INTO epo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Dum ŝi paroladis al Jozef ĉiutage kaj li ne volis obei ŝin kaj kuŝiĝi kun ŝi kaj esti kun ŝi, ");
INSERT INTO epo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","okazis unu tagon, ke li venis en la domon, por fari sian laboron, kaj neniu el la domanoj estis en la domo; ");
INSERT INTO epo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","tiam ŝi kaptis lin je lia vesto, dirante: Kuŝiĝu kun mi. Sed li lasis sian veston en ŝiaj manoj kaj forkuris for el la domo. ");
INSERT INTO epo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kaj kiam ŝi vidis, ke li lasis sian veston en ŝia mano kaj forkuris el la domo, ");
INSERT INTO epo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ŝi vokis siajn domanojn, kaj diris al ili: Rigardu, li venigis al ni Hebreon, por moki nin; ĉi tiu venis al mi, por kuŝiĝi kun mi; sed mi ekkriis per laŭta voĉo; ");
INSERT INTO epo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","kaj kiam li aŭdis, ke mi ekkriis per laŭta voĉo, li lasis sian veston ĉe mi kaj forkuris for el la domo. ");
INSERT INTO epo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kaj ŝi kuŝigis lian veston apud si, ĝis lia sinjoro venis en sian domon. ");
INSERT INTO epo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kaj ŝi rakontis al li tion saman, dirante: La sklavo, la Hebreo, kiun vi venigis al ni, venis al mi, por petoli kun mi; ");
INSERT INTO epo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","sed kiam mi laŭte ekkriis, li lasis sian veston ĉe mi kaj elkuris el la domo. ");
INSERT INTO epo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kiam lia sinjoro aŭdis la vortojn de sia edzino, kiujn ŝi diris al li, parolante: Tiel agis kun mi via sklavo — tiam li forte ekkoleris. ");
INSERT INTO epo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kaj la sinjoro de Jozef prenis lin kaj fordonis lin en malliberejon, en la lokon, kie la malliberuloj de la reĝo estis tenataj; kaj li estis tie en la malliberejo. ");
INSERT INTO epo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kaj la Eternulo estis kun Jozef kaj estis favorkora al li kaj havigis al li la favoron de la estro de la malliberejo. ");
INSERT INTO epo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kaj la estro de la malliberejo transdonis en la manojn de Jozef ĉiujn malliberulojn, kiuj estis en la malliberejo; kaj ĉio, kion ili tie faris, estis farata sub lia kontrolo. ");
INSERT INTO epo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","La estro de la malliberejo rigardis nenion, kio estis sub lia disponado, ĉar la Eternulo estis kun li; kaj ĉion, kion li faris, la Eternulo sukcesigis. ");
INSERT INTO epo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Post tiuj okazintaĵoj la vinisto de la reĝo de Egiptujo kaj la bakisto kulpiĝis antaŭ sia sinjoro, la reĝo de Egiptujo. ");
INSERT INTO epo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kaj Faraono koleriĝis kontraŭ siaj du korteganoj, kontraŭ la vinistestro kaj kontraŭ la bakistestro. ");
INSERT INTO epo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kaj li metis ilin sub gardon en la domon de la estro de la korpogardistoj, en la malliberejon, en la lokon, kie Jozef estis malliberigita. ");
INSERT INTO epo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kaj la estro de la korpogardistoj destinis por ili Jozefon, kaj li servis ilin. Kaj ili restis kelkan tempon en la malliberejo. ");
INSERT INTO epo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kaj ambaŭ sonĝis sonĝon, ĉiu sian apartan sonĝon en la sama nokto, ĉiu kun aparta signifo de la sonĝo, la vinisto kaj la bakisto de la reĝo de Egiptujo, kiuj estis tenataj en la malliberejo. ");
INSERT INTO epo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kiam Jozef venis al ili matene, li vidis, ke ili estas ĉagrenitaj. ");
INSERT INTO epo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kaj li demandis la korteganojn de Faraono, kiuj estis kun li en malliberejo en la domo de lia sinjoro, dirante: Kial viaj vizaĝoj estas ĉagrenitaj hodiaŭ? ");
INSERT INTO epo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kaj ili diris al li: Ni sonĝis sonĝon, sed estas ĉi tie neniu, kiu ĝin signifoklarigus. Kaj Jozef diris al ili: La signifoklarigoj apartenas ja al Dio; tamen rakontu al mi. ");
INSERT INTO epo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tiam la vinistestro rakontis sian sonĝon al Jozef, kaj diris al li: En mia sonĝo mi vidis antaŭ mi vinbertrunkon; ");
INSERT INTO epo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","la trunko havis tri branĉojn; apenaŭ ĝi ekfloris, tuj aperis sur ĝi beraroj kun maturaj beroj; ");
INSERT INTO epo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","kaj la pokalo de Faraono estis en mia mano; kaj mi prenis la berojn, kaj mi elpremis ilin en la pokalon de Faraono, kaj mi donis la pokalon en la manon de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kaj Jozef diris al li: Jen estas ĝia signifoklarigo: la tri branĉoj estas tri tagoj; ");
INSERT INTO epo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","post tri tagoj Faraono levos vian kapon kaj redonos al vi vian oficon, kaj vi donos la pokalon de Faraono en lian manon laŭ la maniero de antaŭe, kiam vi estis lia vinisto. ");
INSERT INTO epo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Sed memoru min, kiam estos bone al vi, kaj faru al mi favorkoraĵon kaj memorigu pri mi Faraonon kaj elirigu min el ĉi tiu domo. ");
INSERT INTO epo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ĉar oni ŝtelis min el la lando de la Hebreoj, kaj ankaŭ ĉi tie mi faris nenion, pro kio oni metis min en la malliberejon. ");
INSERT INTO epo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kiam la bakistestro vidis, ke la signifoklarigo estas bona, li diris al Jozef: Mi ankaŭ havis sonĝon; jen tri blankaj korboj estis sur mia kapo; ");
INSERT INTO epo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","kaj en la supra korbo estis ĉiaspecaj manĝaĵoj de Faraono, bakitaĵoj, kaj la birdoj manĝis ilin el la korbo sur mia kapo. ");
INSERT INTO epo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kaj Jozef respondis, dirante: Jen estas ĝia signifoklarigo: la tri korboj estas tri tagoj; ");
INSERT INTO epo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","post tri tagoj Faraono deprenos de vi vian kapon kaj pendigos vin sur arbo, kaj la birdoj formanĝos de vi vian karnon. ");
INSERT INTO epo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","En la tria tago, tago de naskiĝo de Faraono, li faris festenon por ĉiuj siaj servantoj; kaj li venigis la vinistestron kaj la bakistestron en la mezon de siaj servantoj. ");
INSERT INTO epo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kaj li redonis al la vinistestro lian oficon, kaj tiu donis la pokalon en la manon de Faraono; ");
INSERT INTO epo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","sed la bakistestron li pendigis, kiel sonĝoklarigis al ili Jozef. ");
INSERT INTO epo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kaj la vinistestro ne rememoris Jozefon, sed forgesis lin. ");
INSERT INTO epo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Post du jaroj Faraono havis sonĝon, ke jen li staras apud la Rivero. ");
INSERT INTO epo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kaj jen el la Rivero eliras sep bovinoj belaspektaj kaj grasaj, kaj ili paŝtiĝas en la kanejo. ");
INSERT INTO epo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kaj jen sep aliaj bovinoj eliras post ili el la Rivero, malbelaspektaj kaj malgrasaj, kaj ili stariĝas apud tiuj bovinoj sur la bordo de la Rivero. ");
INSERT INTO epo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kaj la bovinoj malbelaspektaj kaj malgrasaj formanĝis la sep bovinojn belaspektajn kaj grasajn. Kaj Faraono vekiĝis. ");
INSERT INTO epo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kaj li endormiĝis kaj denove havis sonĝon: jen sep spikoj leviĝas sur unu spiktrunko, dikaj kaj bonaj. ");
INSERT INTO epo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Sed jen sep spikoj, maldikaj kaj bruligitaj de la orienta vento, elkreskas post ili. ");
INSERT INTO epo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kaj la maldikaj spikoj englutis la sep spikojn dikajn kaj plenajn. Kaj Faraono vekiĝis, kaj vidis, ke tio estis sonĝo. ");
INSERT INTO epo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","En la mateno lia spirito afliktiĝis; kaj li sendis kaj vokigis ĉiujn sorĉistojn de Egiptujo kaj ĉiujn ĝiajn saĝulojn, kaj Faraono rakontis al ili sian sonĝon; sed neniu povis signifoklarigi ĝin al Faraono. ");
INSERT INTO epo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tiam la vinistestro ekparolis al Faraono, dirante: Miajn pekojn mi rememoras hodiaŭ. ");
INSERT INTO epo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraono koleris siajn sklavojn, kaj metis min en malliberejon en la domon de la estro de la korpogardistoj, min kaj la bakistestron. ");
INSERT INTO epo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kaj ni sonĝis sonĝon en unu nokto, mi kaj li; ĉiu havis sonĝon kun aparta signifo. ");
INSERT INTO epo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kaj tie estis kun ni Hebrea junulo, sklavo de la estro de la korpogardistoj; kaj ni rakontis al li, kaj li signifoklarigis al ni niajn sonĝojn, al ĉiu li klarigis laŭ lia sonĝo. ");
INSERT INTO epo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kaj kiel li klarigis al ni, tiel fariĝis: min oni revenigis al mia ofico, kaj lin oni pendigis. ");
INSERT INTO epo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tiam Faraono sendis alvoki Jozefon; kaj oni rapide eligis lin el la malliberejo, kaj li sin razis kaj ŝanĝis siajn vestojn kaj venis al Faraono. ");
INSERT INTO epo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kaj Faraono diris al Jozef: Mi sonĝis sonĝon, kaj neniu povas ĝin klarigi; sed pri vi mi aŭdis, ke kiam vi aŭdas sonĝon, vi tuj ĝin klarigas. ");
INSERT INTO epo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kaj Jozef respondis al Faraono, dirante: Ĝi ne dependas de mi; Dio respondos bonon al Faraono. ");
INSERT INTO epo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kaj Faraono diris al Jozef: Mi sonĝis, ke jen mi staras sur la bordo de la Rivero; ");
INSERT INTO epo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","kaj jen el la Rivero eliris sep bovinoj grasaj kaj belaspektaj kaj paŝtiĝis en la kanejo; ");
INSERT INTO epo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","sed jen sep aliaj bovinoj eliris post ili, maldikaj, tre malbonaspektaj kaj malgrasaj; tiajn malbelajn, kiel ili, mi ne vidis en la tuta Egipta lando; ");
INSERT INTO epo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","kaj la malgrasaj kaj malbelaj bovinoj formanĝis la sep antaŭajn grasajn bovinojn; ");
INSERT INTO epo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","kaj tiuj eniĝis en ilian internon, sed oni ne povis rimarki, ke ili eniĝis en ilian internon, kaj ilia aspekto estis tiel maldika, kiel antaŭe. Kaj mi vekiĝis. ");
INSERT INTO epo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kaj mi vidis en sonĝo: jen sep spikoj elkreskis sur unu spiktrunko, plenaj kaj bonaj; ");
INSERT INTO epo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","sed jen sep spikoj, maldikaj, malgrasaj, kaj bruligitaj de la orienta vento, elkreskis post ili; ");
INSERT INTO epo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","kaj la malgrasaj spikoj englutis la sep bonajn spikojn. Kaj mi rakontis al la sorĉistoj, sed neniu klarigis al mi. ");
INSERT INTO epo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tiam Jozef diris al Faraono: La sonĝo de Faraono estas unu; kion Dio estas faronta, Li diris al Faraono. ");
INSERT INTO epo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","La sep bonaj bovinoj estas sep jaroj, kaj la sep bonaj spikoj estas sep jaroj; ĝi estas unu sonĝo. ");
INSERT INTO epo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Kaj la sep bovinoj malgrasaj kaj malbelaj, kiuj eliris post ili, estas sep jaroj; kaj la sep spikoj, malplenaj kaj bruligitaj de la orienta vento, estos sep jaroj de malsato. ");
INSERT INTO epo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tio estas, pri kio mi diris al Faraono, ke kion Dio estas faronta, Li montris al Faraono. ");
INSERT INTO epo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Jen venos sep jaroj de granda abundeco en la tuta Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sed venos sep jaroj de malsato post ili; kaj forgesiĝos la tuta abundeco en la Egipta lando, kaj la malsato konsumos la teron. ");
INSERT INTO epo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kaj ne restos postesigno de la abundeco en la lando, pro tiu malsato, kiu venos poste, ĉar ĝi estos tre malfacila. ");
INSERT INTO epo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kaj se la sonĝo dufoje ripetiĝis al Faraono, tio montras, ke la afero estas firme decidita de Dio, kaj Dio rapidos plenumi tion. ");
INSERT INTO epo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Kaj nun Faraono elserĉu homon kompetentan kaj saĝan kaj estrigu lin super la Egipta lando; ");
INSERT INTO epo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faraono ordonu, ke li starigu observistojn en la lando kaj prenadu kvinonon de ĉiuj produktoj de la Egipta tero dum la sep jaroj de abundeco. ");
INSERT INTO epo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kaj oni kolektu la tutan manĝaĵon de tiuj venontaj bonaj jaroj, kaj oni amasigu manĝeblan grenon en la urboj sub la disponon de Faraono, kaj oni ĝin konservu. ");
INSERT INTO epo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kaj tiu manĝaĵo estos provizo por la lando por la sep jaroj de malsato, kiuj estos en la Egipta lando, por ke la lando ne pereu de malsato. ");
INSERT INTO epo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kaj tio plaĉis al Faraono kaj al ĉiuj liaj servantoj. ");
INSERT INTO epo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kaj Faraono diris al siaj servantoj: Ĉu ni povus trovi tian homon, kiel li, en kiu estas la spirito de Dio? ");
INSERT INTO epo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kaj Faraono diris al Jozef: Ĉar Dio sciigis al vi ĉion ĉi tion, ne ekzistas kompetentulo kaj saĝulo tia, kiel vi. ");
INSERT INTO epo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Vi estos super mia domo, kaj viajn vortojn obeos mia tuta popolo; nur per la trono mi estos pli alta ol vi. ");
INSERT INTO epo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kaj Faraono diris al Jozef: Vidu, mi estrigis vin super la tuta Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kaj Faraono deprenis sian ringon de sia mano kaj metis ĝin sur la manon de Jozef; kaj li vestis lin per bisinaj vestoj kaj metis oran ĉenon sur lian kolon. ");
INSERT INTO epo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kaj li veturigis lin sur sia dua ĉaro; kaj oni kriis antaŭ li: Genuiĝu! Kaj li estrigis lin super la tuta Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kaj Faraono diris al Jozef: Mi estas Faraono; sed sen via ordono neniu levos sian manon aŭ sian piedon en la tuta Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kaj Faraono donis al Jozef la nomon Cafnat-Paneaĥ, kaj li donis al li kiel edzinon Asnaton, filinon de Poti-Fera, pastro el On. Kaj Jozef komencis veturadon tra la Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jozef havis la aĝon de tridek jaroj, kiam li stariĝis antaŭ Faraono, la reĝo de Egiptujo. Kaj Jozef foriris de Faraono kaj trapasis la tutan Egiptan landon. ");
INSERT INTO epo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kaj la tero alportis en la sep jaroj de abundeco grandegajn amasojn da greno. ");
INSERT INTO epo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kaj li kolektis la tutan grenon de la sep jaroj, kiuj estis en la Egipta lando, kaj li metis la grenon en la urbojn; la grenon de ĉiuj kampoj, kiuj estis ĉirkaŭ iu urbo, li metis en ĝin. ");
INSERT INTO epo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kaj Jozef kolektis tre multe da greno, kiel la marborda sablo, ĝis li ĉesis kalkuli, ĉar oni ne plu povis kalkuli. ");
INSERT INTO epo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Antaŭ ol venis la jaroj de malsato, al Jozef naskiĝis du filoj, kiujn naskis al li Asnat, filino de Poti-Fera, pastro el On. ");
INSERT INTO epo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kaj al la unuenaskito Jozef donis la nomon Manase, ĉar, li diris, Dio forgesigis al mi ĉiujn miajn suferojn kaj la tutan domon de mia patro. ");
INSERT INTO epo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Kaj al la dua li donis la nomon Efraim, ĉar, li diris, Dio faris min fruktoporta en la lando de mia suferado. ");
INSERT INTO epo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kaj finiĝis la sep jaroj de abundeco, kiuj estis en la Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kaj komenciĝis la sep jaroj de malsato, kiel diris Jozef; kaj estis malsato en ĉiuj landoj, sed en la tuta lando Egipta estis pano. ");
INSERT INTO epo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kiam la tuta Egipta lando eksuferis malsaton, la popolo kriis al Faraono pri pano; tiam Faraono diris al ĉiuj Egiptoj: Iru al Jozef, kaj kion li diros al vi, tion faru. ");
INSERT INTO epo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La malsato estis en la tuta lando. Jozef malfermis ĉiujn grenejojn, kaj vendadis al la Egiptoj. Kaj la malsato estis tre granda en la Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kaj el ĉiuj landoj oni venadis Egiptujon, por aĉeti de Jozef, ĉar la malsato estis tre granda en ĉiuj landoj. ");
INSERT INTO epo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kiam Jakob sciiĝis, ke oni vendas grenon en Egiptujo, li diris al siaj filoj: Kion vi rigardas? ");
INSERT INTO epo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kaj li diris: Mi aŭdis, ke oni vendas grenon en Egiptujo; veturu do tien kaj aĉetu por ni tie grenon, por ke ni vivu kaj ne mortu. ");
INSERT INTO epo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kaj forveturis dek fratoj de Jozef, por aĉeti grenon en Egiptujo. ");
INSERT INTO epo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sed Benjamenon, la fraton de Jozef, Jakob ne sendis kun liaj fratoj; ĉar li timis, ke eble lin trafos malfeliĉo. ");
INSERT INTO epo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kaj la filoj de Izrael venis, por aĉeti grenon, kune kun aliaj venintoj; ĉar estis malsato en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Kaj Jozef estis la estro super la lando, kaj li estis la vendanto de la greno por la tuta popolo de la lando. Kaj la fratoj de Jozef venis kaj kliniĝis al li vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kiam Jozef ekvidis siajn fratojn, li rekonis ilin; sed li ŝajnigis sin fremda al ili kaj parolis kun ili malafable, kaj diris al ili: El kie vi venis? Kaj ili diris: El la lando Kanaana, por aĉeti manĝaĵon. ");
INSERT INTO epo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jozef rekonis siajn fratojn, sed ili lin ne rekonis. ");
INSERT INTO epo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kaj Jozef rememoris la sonĝojn, kiujn li sonĝis pri ili. Kaj li diris al ili: Vi estas spionoj: vi venis, por vidi la malfortajn lokojn de la lando. ");
INSERT INTO epo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kaj ili diris al li: Ne, mia sinjoro! viaj sklavoj venis, por aĉeti manĝaĵon. ");
INSERT INTO epo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ni ĉiuj estas filoj de unu homo; ni estas honestaj; viaj sklavoj neniam estis spionoj. ");
INSERT INTO epo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sed li diris al ili: Ne, vi venis, por vidi la malfortajn lokojn de la lando. ");
INSERT INTO epo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ili diris: Ni, viaj sklavoj, estas dek du fratoj, filoj de unu homo en la lando Kanaana; la plej juna estas nun kun nia patro, kaj unu malaperis. ");
INSERT INTO epo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kaj Jozef diris al ili: Estas tio, kion mi diris al vi, vi estas spionoj. ");
INSERT INTO epo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Per tio mi vin elprovos: mi ĵuras per la vivo de Faraono, ke vi foriros el ĉi tie nur tiam, kiam venos ĉi tien via plej juna frato. ");
INSERT INTO epo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sendu unu el vi, ke li alkonduku vian fraton; sed vi estos malliberigitaj, kaj oni esploros viajn vortojn, ĉu vi diris la veron; se ne, tiam mi ĵuras per la vivo de Faraono, ke vi estas spionoj. ");
INSERT INTO epo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kaj li metis ilin sub gardon por la daŭro de tri tagoj. ");
INSERT INTO epo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Kaj Jozef diris al ili en la tria tago: Tion faru, kaj vi restos vivaj, ĉar mi havas timon antaŭ Dio. ");
INSERT INTO epo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Se vi estas homoj honestaj, tiam unu el viaj fratoj restu malliberigita en la domo, en kiu oni vin gardas, kaj vi iru kaj forportu hejmen la grenon, kiun vi aĉetis kontraŭ la malsato. ");
INSERT INTO epo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sed vian plej junan fraton venigu al mi, por ke pruviĝu la vereco de viaj vortoj kaj por ke vi ne mortu. Kaj ili faris tiel. ");
INSERT INTO epo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kaj ili diris unu al alia: Vere ni estas kulpaj pro nia frato; ĉar ni vidis la suferadon de lia animo, kiam li petegis nin, sed ni ne aŭskultis; por tio venis sur nin ĉi tiu sufero. ");
INSERT INTO epo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kaj Ruben respondis al ili, dirante: Mi diris ja al vi: Ne peku rilate la infanon; sed vi ne obeis; nun lia sango estas repostulata. ");
INSERT INTO epo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Kaj ili ne sciis, ke Jozef komprenas; ĉar inter ili estis tradukanto. ");
INSERT INTO epo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kaj li deturnis sin de ili kaj ekploris; poste li denove returnis sin al ili kaj parolis kun ili, kaj li prenis el inter ili Simeonon kaj ligis lin antaŭ iliaj okuloj. ");
INSERT INTO epo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kaj Jozef ordonis plenigi iliajn sakojn per greno kaj redoni ilian monon al ĉiu en lian sakon kaj doni al ili manĝaĵon por la vojo. Tiel oni faris al ili. ");
INSERT INTO epo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kaj ili metis sian grenon sur siajn azenojn kaj foriris. ");
INSERT INTO epo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kaj unu el ili malfermis sian sakon, por doni furaĝon al sia azeno dum la nokta halto, kaj li ekvidis sian monon, kiu estis en la aperturo de lia sako. ");
INSERT INTO epo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kaj li diris al siaj fratoj: Mia mono estas redonita; jen ĝi estas en mia sako. Tiam konsterniĝis iliaj koroj, kaj kun tremo ili diris unuj al la aliaj: Kial Dio faris tion al ni? ");
INSERT INTO epo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kiam ili venis al sia patro Jakob en la landon Kanaanan, ili rakontis al li ĉion, kio okazis al ili, dirante: ");
INSERT INTO epo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","La homo, kiu estas sinjoro super tiu lando, parolis kun ni malafable, kaj diris, ke ni estas spionoj en la lando. ");
INSERT INTO epo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kaj ni diris al li: Ni estas homoj honestaj, ni neniam estis spionoj; ");
INSERT INTO epo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ni estas dek du fratoj, filoj de nia patro; unu malaperis, kaj la plej juna estas nun kun nia patro en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tiam diris al ni la homo, kiu estas sinjoro super la lando: Per tio mi konvinkiĝos, ke vi estas homoj honestaj: unu el viaj fratoj lasu ĉe mi, kaj la necesan grenon por via hejmo prenu kaj iru; ");
INSERT INTO epo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","kaj venigu al mi vian plej junan fraton; tiam mi scios, ke vi ne estas spionoj, ke vi estas honestaj homoj; vian fraton mi redonos al vi, kaj vi povos negoci en la lando. ");
INSERT INTO epo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kiam ili malplenigis siajn sakojn, montriĝis, ke ĉiu el ili havas sian ligaĵon da mono en sia sako. Kaj ili vidis siajn ligaĵojn da mono, ili kaj ilia patro, kaj ili timiĝis. ");
INSERT INTO epo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kaj ilia patro Jakob diris al ili: Vi min seninfanigis; Jozef forestas, kaj Simeon forestas, kaj Benjamenon vi volas forpreni! sur min ĉio falis! ");
INSERT INTO epo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tiam Ruben diris al sia patro jene: Miajn du filojn mortigu, se mi ne revenigos lin al vi; donu lin en mian manon, kaj mi revenigos lin al vi. ");
INSERT INTO epo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Sed li diris: Mia filo ne iros kun vi; ĉar lia frato mortis, kaj li sola restis. Se lin trafos malfeliĉo sur la vojo, kiun vi iros, tiam vi enirigos miajn grizajn harojn kun malĝojo en Ŝeolon. ");
INSERT INTO epo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","La malsato estis tre premanta en la lando. ");
INSERT INTO epo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kiam ili formanĝis la grenon, kiun ili venigis el Egiptujo, ilia patro diris al ili: Iru denove kaj aĉetu por ni iom da pano. ");
INSERT INTO epo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tiam Jehuda diris al li jene: Tiu homo tre severe diris al ni: Ne aperu antaŭ mi, se via frato ne estos kun vi. ");
INSERT INTO epo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Se vi sendos nian fraton kun ni, tiam ni iros kaj aĉetos por vi panon; ");
INSERT INTO epo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","sed se vi ne sendos, tiam ni ne iros; ĉar tiu homo diris al ni: Ne aperu antaŭ mi, se via frato ne estos kun vi. ");
INSERT INTO epo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kaj Izrael diris: Kial vi faris al mi tian malbonon, kaj diris al la homo, ke vi havas ankoraŭ fraton? ");
INSERT INTO epo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kaj ili diris: La homo severe demandis pri ni kaj pri nia familio, dirante: Ĉu via patro ankoraŭ vivas? ĉu vi havas fraton? Kaj ni respondis al li tiujn demandojn. Ĉu ni povis scii, ke li diros: Venigu vian fraton? ");
INSERT INTO epo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kaj Jehuda diris al sia patro Izrael: Sendu la knabon kun mi, tiam ni leviĝos kaj iros, por ke ni vivu kaj ne mortu, ni kaj vi kaj niaj infanoj. ");
INSERT INTO epo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mi garantios por li, el miaj manoj vi lin postulos. Se mi ne revenigos lin al vi kaj ne starigos antaŭ via vizaĝo, tiam mi estos kulpa antaŭ vi dum la tuta vivo. ");
INSERT INTO epo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Se ni ne prokrastus, ni jam du fojojn estus revenintaj. ");
INSERT INTO epo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tiam diris al ili ilia patro Izrael: Se estas tiel, tiam faru jene: prenu el la plej bonaj fruktoj de la lando en viajn vazojn, kaj alportu al la homo donacon: iom da balzamo kaj iom da mielo, aromaĵon kaj mirhon, pistakojn kaj migdalojn. ");
INSERT INTO epo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kaj da mono prenu duoblan sumon en viajn manojn, kaj la monon, kiu estis metita returne en la aperturojn de viaj sakoj, redonu per viaj manoj: eble okazis eraro. ");
INSERT INTO epo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kaj vian fraton prenu, kaj leviĝu kaj iru returne al tiu homo. ");
INSERT INTO epo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kaj Dio la Plejpotenca akirigu al vi kompaton de tiu homo, ke li resendu kun vi vian alian fraton kaj Benjamenon; sed mi, se mi seninfaniĝis, mi restu seninfana. ");
INSERT INTO epo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kaj la homoj prenis tiujn donacojn, kaj da mono ili prenis duoblan sumon en siajn manojn, kaj ankaŭ Benjamenon; kaj ili leviĝis kaj iris Egiptujon kaj stariĝis antaŭ Jozef. ");
INSERT INTO epo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kiam Jozef vidis kun ili Benjamenon, li diris al la estro de sia domo: Enkonduku tiujn homojn en la domon, kaj buĉu bruton kaj pretigu; ĉar kun mi manĝos tiuj homoj hodiaŭ tagmeze. ");
INSERT INTO epo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kaj la homo faris, kiel diris Jozef, kaj la homo enkondukis tiujn homojn en la domon de Jozef. ");
INSERT INTO epo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kaj tiuj homoj ektimis, kiam oni enkondukis ilin en la domon de Jozef, kaj ili diris: Pro la mono, kiu antaŭe estis metita returne en niajn sakojn, oni enkondukis nin, por ĵeti sur nin kalumnion kaj ataki nin, kaj preni nin kiel sklavojn kune kun niaj azenoj. ");
INSERT INTO epo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kaj ili aliris al la homo, kiu estis estro super la domo de Jozef, kaj ekparolis al li ĉe la pordo de la domo. ");
INSERT INTO epo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Kaj ili diris: Pardonu, nia sinjoro! ni estis venintaj, por aĉeti panon; ");
INSERT INTO epo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","sed kiam ni venis al la noktohaltejo kaj ni malfermis niajn sakojn, ni ekvidis, ke la mono de ĉiu el ni estas en la aperturo de lia sako, nia mono laŭ ĝia plena pezo; tial ni ĝin realportis per niaj manoj. ");
INSERT INTO epo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kaj alian monon ni alportis per niaj manoj, por aĉeti panon. Ni ne scias, kiu metis nian monon en niajn sakojn. ");
INSERT INTO epo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kaj li diris: Estu trankvilaj, ne timu. Via Dio kaj la Dio de via patro donis al vi trezoron en viajn sakojn; vian monon mi ricevis. Kaj li elkondukis al ili Simeonon. ");
INSERT INTO epo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kaj tiu homo enkondukis ilin en la domon de Jozef kaj donis akvon, kaj ili lavis siajn piedojn; kaj li donis manĝon al iliaj azenoj. ");
INSERT INTO epo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kaj ili pretigis la donacojn por la veno de Jozef tagmeze; ĉar ili aŭdis, ke tie ili manĝos panon. ");
INSERT INTO epo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kaj Jozef venis hejmen; kaj ili alportis al li en la domon la donacojn, kiujn ili havis en la manoj, kaj kliniĝis al li ĝis la tero. ");
INSERT INTO epo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kaj li demandis ilin pri ilia farto, kaj diris: Ĉu bone fartas via maljuna patro, pri kiu vi diris al mi? ĉu li vivas ankoraŭ? ");
INSERT INTO epo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kaj ili diris: Via sklavo nia patro fartas bone; li vivas ankoraŭ. Kaj ili kliniĝis kaj ĵetis sin antaŭ li sur la teron. ");
INSERT INTO epo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kaj li levis siajn okulojn, kaj ekvidis sian fraton Benjamen, la filon de lia patrino, kaj li diris: Ĉu tio estas via plej juna frato, pri kiu vi diris al mi? Kaj li diris: Dio vin favoru, mia filo. ");
INSERT INTO epo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kaj Jozef forrapidis, ĉar ekflamis lia interno pro lia frato kaj li volis plori. Kaj li eniris en internan ĉambron kaj ploris tie. ");
INSERT INTO epo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sed li lavis sian vizaĝon kaj eliris, kaj tenis sin forte, kaj diris: Surtabligu panon! ");
INSERT INTO epo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kaj oni surtabligis por li aparte, kaj por ili aparte, kaj por la Egiptoj, kiuj manĝis kun li, aparte; ĉar la Egiptoj ne povas manĝi panon kun Hebreoj: tio estas abomenindaĵo por ili. ");
INSERT INTO epo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kaj ili sidiĝis antaŭ li, pli maljuna laŭ sia maljuneco kaj pli juna laŭ sia juneco; kaj la homoj miris unu antaŭ alia. ");
INSERT INTO epo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kaj oni portis al ili manĝaĵon de lia tablo; sed la porcio de Benjamen estis kvinoble pli granda, ol la porcioj de ĉiuj. Kaj ili trinkis kaj ebriiĝis kun li. ");
INSERT INTO epo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kaj Jozef ordonis al la estro de sia domo jene: Plenigu la sakojn de tiuj homoj per greno tiom, kiom ili nur povas porti, kaj metu la monon de ĉiu en la aperturon de lia sako; ");
INSERT INTO epo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","kaj mian pokalon, la arĝentan pokalon, metu en la aperturon de la sako de la plej juna, kune kun la mono por lia greno. Kaj tiu faris, kiel Jozef diris. ");
INSERT INTO epo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kiam eklumis la mateno, oni forsendis la homojn, ilin kaj iliajn azenojn. ");
INSERT INTO epo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kiam ili eliris el la urbo kaj ankoraŭ ne estis malproksime, Jozef diris al la estro de sia domo: Leviĝu, kuru post tiuj homoj, kaj kiam vi atingos ilin, diru al ili: Kial vi pagis malbonon por bono? ");
INSERT INTO epo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ĝi estas ja tiu pokalo, el kiu trinkas mia sinjoro, kaj li ankaŭ aŭguras sur ĝi! vi agis malbone! ");
INSERT INTO epo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kaj li kuratingis ilin kaj diris al ili tiujn vortojn. ");
INSERT INTO epo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kaj ili diris al li: Kial mia sinjoro parolas tiajn vortojn? Dio gardu viajn sklavojn de farado de tia afero! ");
INSERT INTO epo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Jen la monon, kiun ni trovis en la aperturoj de niaj sakoj, ni realportis al vi el la lando Kanaana; kiel do ni ŝtelus el la domo de via sinjoro arĝenton aŭ oron? ");
INSERT INTO epo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tiu el viaj sklavoj, ĉe kiu oni ĝin trovos, mortu, kaj ankaŭ ni fariĝu sklavoj al mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kaj li diris: Ĝi estu laŭ viaj vortoj: tiu, ĉe kiu ĝi troviĝos, estu mia sklavo, sed vi estos senkulpaj. ");
INSERT INTO epo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kaj rapide ĉiu el ili mallevis sian sakon sur la teron, kaj ĉiu malfermis sian sakon. ");
INSERT INTO epo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kaj li serĉis; de la plej maljuna li komencis, kaj per la plej juna li finis. Kaj la pokalo troviĝis en la sako de Benjamen. ");
INSERT INTO epo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tiam ili disŝiris siajn vestojn, kaj ĉiu metis la ŝarĝon sur sian azenon, kaj ili reiris en la urbon. ");
INSERT INTO epo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kaj Jehuda kaj liaj fratoj venis en la domon de Jozef, kiu estis ankoraŭ tie, kaj ili ĵetis sin antaŭ li sur la teron. ");
INSERT INTO epo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kaj Jozef diris al ili: Kian aferon vi faris! ĉu vi ne scias, ke tia homo, kiel mi, facile divenos? ");
INSERT INTO epo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tiam Jehuda diris: Kion ni diru al mia sinjoro? kion ni parolu kaj per kio ni nin pravigu? Dio trovis la pekon de viaj sklavoj! jen ni estas sklavoj al mia sinjoro, ni kaj ankaŭ tiu, en kies manoj troviĝis la pokalo. ");
INSERT INTO epo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Sed li diris: Dio min gardu de tia faro! la homo, en kies mano troviĝis la pokalo, estos sklavo al mi, sed vi iru en paco al via patro. ");
INSERT INTO epo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tiam Jehuda aliris al li, kaj diris: Permesu, mia sinjoro, ke via sklavo diru vorton en la orelojn de mia sinjoro, kaj ne koleriĝu kontraŭ via sklavo, ĉar vi estas kiel Faraono. ");
INSERT INTO epo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mia sinjoro demandis siajn sklavojn, dirante: Ĉu vi havas patron aŭ fraton? ");
INSERT INTO epo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kaj ni diris al mia sinjoro: Ni havas maljunan patron, kaj malgrandan knabon, naskitan en lia maljuneco; kaj lia frato mortis, kaj li restis sola de sia patrino, kaj lia patro lin amas. ");
INSERT INTO epo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tiam vi diris al viaj sklavoj: Venigu lin al mi, ke mi lin rigardu. ");
INSERT INTO epo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Sed ni diris al mia sinjoro: La knabo ne povas forlasi sian patron; ĉar se li forlasos sian patron, tiu mortos. ");
INSERT INTO epo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tiam vi diris al viaj sklavoj: Se ne venos kun vi via plej juna frato, tiam ne aperu plu antaŭ mia vizaĝo. ");
INSERT INTO epo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kaj kiam ni venis al via sklavo nia patro, ni diris al li la vortojn de mia sinjoro. ");
INSERT INTO epo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nia patro diris: Reiru, aĉetu por ni iom da greno. ");
INSERT INTO epo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Sed ni diris: Ni ne povas iri; se estos kun ni nia plej juna frato, tiam ni iros; ĉar ni ne povas aperi antaŭ la vizaĝo de tiu homo, se nia plej juna frato ne estos kun ni. ");
INSERT INTO epo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tiam via sklavo nia patro diris al ni: Vi scias, ke mia edzino naskis al mi du; ");
INSERT INTO epo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","sed unu foriris de mi, kaj mi diris: Li estas disŝirita; kaj mi ne vidis lin ĝis nun; ");
INSERT INTO epo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","se vi ankaŭ ĉi tiun prenos de mi kaj lin trafos malfeliĉo, tiam vi enirigos miajn grizajn harojn kun malĝojo en Ŝeolon. ");
INSERT INTO epo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kaj nun se mi venos al via sklavo mia patro kaj ne estos kun ni la knabo, al kies animo estas alligita lia animo, ");
INSERT INTO epo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","tiam, ekvidinte, ke la knabo forestas, li mortos; kaj viaj sklavoj enirigos la grizajn harojn de via sklavo nia patro kun malĝojo en Ŝeolon. ");
INSERT INTO epo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ĉar mi, via sklavo, garantiis por la knabo antaŭ mia patro, dirante: Se mi ne revenigos lin al vi, mi estos kulpa antaŭ mia patro por ĉiam. ");
INSERT INTO epo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tial mi, via sklavo, restu anstataŭ la knabo kiel sklavo ĉe mia sinjoro, sed la knabo iru kun siaj fratoj. ");
INSERT INTO epo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ĉar kiel mi iros al mia patro, se la knabo ne estos kun mi? mi tiam vidus la malfeliĉon, kiu trafos mian patron. ");
INSERT INTO epo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tiam Jozef ne povis plu sin deteni antaŭ ĉiuj, kiuj staris ĉirkaŭ li, kaj li ekkriis: Elirigu ĉiujn for de mi. Kaj neniu restis ĉe li, kiam Jozef rekonigis sin al siaj fratoj. ");
INSERT INTO epo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kaj li laŭte ekploris, kaj aŭdis la Egiptoj, kaj aŭdis la domo de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kaj Jozef diris al siaj fratoj: Mi estas Jozef; ĉu mia patro vivas ankoraŭ? Sed liaj fratoj ne povis respondi al li, ĉar ili konfuziĝis antaŭ li. ");
INSERT INTO epo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kaj Jozef diris al siaj fratoj: Aliru do al mi. Kaj ili aliris. Kaj li diris: Mi estas Jozef, via frato, kiun vi vendis en Egiptujon. ");
INSERT INTO epo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Sed nun ne afliktiĝu, kaj ne bedaŭru, ke vi vendis min ĉi tien; ĉar por la savo de via vivo Dio sendis min antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ĉar nun jam du jarojn daŭras la malsato en la lando, sed ankoraŭ dum kvin jaroj ne estos plugado nek rikoltado. ");
INSERT INTO epo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kaj Dio sendis min antaŭ vi, por vin restigi sur la tero kaj por konservi vian vivon per granda savo. ");
INSERT INTO epo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Sciu do, ne vi sendis min ĉi tien, sed Dio; kaj Li faris min patro al Faraono, kaj sinjoro super lia tuta domo, kaj reganto super la tuta Egipta lando. ");
INSERT INTO epo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Iru rapide al mia patro, kaj diru al li: Tiele diris via filo Jozef: Dio faris min sinjoro super la tuta Egiptujo; venu al mi, ne prokrastu. ");
INSERT INTO epo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Vi loĝos en la lando Goŝen, kaj vi estos proksime de mi, vi kaj viaj filoj kaj la filoj de viaj filoj, kaj viaj ŝafoj kaj viaj bovoj, kaj ĉio, kion vi havas. ");
INSERT INTO epo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kaj mi nutros vin tie, ĉar ankoraŭ kvin jarojn daŭros la malsato; por ke ne mizeriĝu vi kaj via domo, kaj ĉio, kion vi havas. ");
INSERT INTO epo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kaj jen viaj okuloj nun vidas, kaj ankaŭ la okuloj de mia frato Benjamen, ke mia buŝo parolas al vi. ");
INSERT INTO epo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kaj rakontu al mia patro pri mia tuta gloro en Egiptujo, kaj ĉion, kion vi vidis; kaj rapide venigu mian patron ĉi tien. ");
INSERT INTO epo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kaj li ĵetis sin sur la kolon de sia frato Benjamen kaj ploris, kaj Benjamen ploris sur lia kolo. ");
INSERT INTO epo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kaj li kisis ĉiujn siajn fratojn kaj ploris super ili. Poste liaj fratoj ekparolis kun li. ");
INSERT INTO epo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kaj la famo venis en la domon de Faraono, ke venis la fratoj de Jozef. Kaj tio plaĉis al Faraono kaj al liaj servantoj. ");
INSERT INTO epo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kaj Faraono diris al Jozef: Diru al viaj fratoj: Faru tion, ŝarĝu viajn brutojn kaj iru en la landon Kanaanan; ");
INSERT INTO epo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","kaj prenu vian patron kaj viajn familiojn, kaj venu al mi; mi donos al vi ĉion bonan en la Egipta lando, kaj vi manĝos la grasaĵon de la lando. ");
INSERT INTO epo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kaj ordonu al ili jene: Prenu al vi el la Egipta lando veturilojn por viaj infanoj kaj virinoj, kaj kunprenu vian patron kaj venu. ");
INSERT INTO epo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kaj ne tro zorgu pri viaj aĵoj; ĉar ĉio bona en la Egipta lando estas al via dispono. ");
INSERT INTO epo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kaj la filoj de Izrael faris tiel. Kaj Jozef donis al ili veturilojn laŭ la ordono de Faraono, kaj li donis al ili provizojn por la vojo. ");
INSERT INTO epo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Al ĉiuj li donis novajn vestojn, sed al Benjamen li donis tricent arĝentajn monerojn kaj kvin novajn vestojn. ");
INSERT INTO epo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kaj por sia patro li sendis dek azenojn, ŝarĝitajn per bonaĵo el Egiptujo, kaj dek azeninojn, ŝarĝitajn per greno, pano, kaj manĝaĵo por lia patro por la vojo. ");
INSERT INTO epo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kaj li forsendis siajn fratojn, kaj ili iris. Kaj li diris al ili: Ne malpacu dum la vojo. ");
INSERT INTO epo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kaj ili eliris el Egiptujo kaj venis en la landon Kanaanan al sia patro Jakob. ");
INSERT INTO epo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kaj ili sciigis al li, dirante: Jozef vivas ankoraŭ, kaj li regas nun super la tuta Egipta lando. Kaj lia koro konfuziĝis, ĉar li ne kredis al ili. ");
INSERT INTO epo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kaj ili rediris al li ĉiujn vortojn de Jozef, kiujn li diris al ili; kaj li vidis la veturilojn, kiujn Jozef sendis, por veturigi lin, kaj tiam la spirito de ilia patro Jakob reviviĝis. ");
INSERT INTO epo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kaj Izrael diris: Sufiĉas, ke mia filo Jozef ankoraŭ vivas: mi iros kaj vidos lin, antaŭ ol mi mortos. ");
INSERT INTO epo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Izrael ekiris kun ĉio, kion li havis, kaj li venis en Beer-Ŝeban, kaj li alportis oferojn al la Dio de sia patro Isaak. ");
INSERT INTO epo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kaj Dio diris al Izrael en nokta vizio: Jakob! Jakob! Kaj tiu diris: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kaj Li diris: Mi estas Dio, la Dio de via patro. Ne timu iri Egiptujon, ĉar Mi tie faros vin granda popolo. ");
INSERT INTO epo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mi iros kun vi Egiptujon, kaj Mi ankaŭ revenigos vin; kaj Jozef metos sian manon sur viajn okulojn. ");
INSERT INTO epo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kaj Jakob leviĝis el Beer-Ŝeba; kaj la filoj de Izrael ekveturigis sian patron Jakob kaj siajn infanojn kaj siajn edzinojn sur la veturiloj, kiujn sendis Faraono, por alveturigi lin. ");
INSERT INTO epo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kaj ili prenis siajn brutojn, kaj sian havon, kiun ili akiris en la lando Kanaana, kaj venis Egiptujon, Jakob kaj lia tuta idaro kun li. ");
INSERT INTO epo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Siajn filojn kaj nepojn, siajn filinojn kaj nepinojn, kaj sian tutan idaron li venigis kun si en Egiptujon. ");
INSERT INTO epo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jen estas la nomoj de la filoj de Izrael, kiuj venis Egiptujon: Jakob kaj liaj filoj. La unuenaskito de Jabob, Ruben. ");
INSERT INTO epo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Kaj la filoj de Ruben: Ĥanoĥ kaj Palu kaj Ĥecron kaj Karmi. ");
INSERT INTO epo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Kaj la filoj de Simeon: Jemuel kaj Jamin kaj Ohad kaj Jaĥin kaj Coĥar, kaj Ŝaul, filo de Kanaanidino. ");
INSERT INTO epo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Kaj la filoj de Levi: Gerŝon, Kehat, kaj Merari. ");
INSERT INTO epo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Kaj la filoj de Jehuda: Er kaj Onan kaj Ŝela kaj Perec kaj Zeraĥ; sed Er kaj Onan mortis en la lando Kanaana. Kaj la filoj de Perec estis: Ĥecron kaj Ĥamul. ");
INSERT INTO epo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Kaj la filoj de Isaĥar: Tola kaj Puva kaj Job kaj Ŝimron. ");
INSERT INTO epo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Kaj la filoj de Zebulun: Sered kaj Elon kaj Jaĥleel. ");
INSERT INTO epo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tio estas la filoj de Lea, kiujn ŝi naskis al Jakob en Mezopotamio, kaj lia filino Dina. La nombro de ĉiuj animoj de liaj filoj kaj filinoj estis tridek tri. ");
INSERT INTO epo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kaj la filoj de Gad: Cifjon kaj Ĥagi, Ŝuni kaj Ecbon, Eri kaj Arod kaj Areli. ");
INSERT INTO epo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Kaj la filoj de Aŝer: Jimna kaj Jiŝva kaj Jiŝvi kaj Beria, kaj Seraĥ, ilia fratino; kaj la filoj de Beria: Ĥeber kaj Malkiel. ");
INSERT INTO epo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tio estas la filoj de Zilpa, kiun Laban donis al sia filino Lea; kaj ŝi naskis ilin al Jakob, dek ses animojn. ");
INSERT INTO epo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","La filoj de Raĥel, edzino de Jakob: Jozef kaj Benjamen. ");
INSERT INTO epo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kaj al Jozef en la lando Egipta naskiĝis Manase kaj Efraim, kiujn naskis al li Asnat, filino de Poti-Fera, pastro el On. ");
INSERT INTO epo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Kaj la filoj de Benjamen: Bela kaj Beĥer kaj Aŝbel, Gera kaj Naaman, Eĥi kaj Roŝ, Mupim kaj Ĥupim kaj Ard. ");
INSERT INTO epo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tio estas la filoj de Raĥel, kiuj naskiĝis al Jakob, kune dek kvar animoj. ");
INSERT INTO epo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Kaj la filoj de Dan: Ĥuŝim. ");
INSERT INTO epo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Kaj la filoj de Naftali: Jaĥceel kaj Guni kaj Jecer kaj Ŝilem. ");
INSERT INTO epo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tio estas la filoj de Bilha, kiun donis Laban al sia filino Raĥel; ŝi naskis ilin al Jakob, kune sep animojn. ");
INSERT INTO epo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","La nombro de ĉiuj animoj, kiuj venis kun Jakob en Egiptujon, kiuj eliris el lia lumbo, krom la edzinoj de la filoj de Jakob, estis sesdek ses. ");
INSERT INTO epo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kaj la filoj de Jozef, kiuj naskiĝis al li en Egiptujo, estis du animoj. La nombro de ĉiuj animoj de la domo de Jakob, kiuj venis Egiptujon, estis sepdek. ");
INSERT INTO epo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jehudan li sendis antaŭ si al Jozef, por ke li informu lin antaŭe pri Goŝen. Kaj ili venis en la landon Goŝen. ");
INSERT INTO epo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kaj Jozef jungis sian ĉaron kaj veturis renkonte al sia patro Izrael en la landon Goŝen. Kaj kiam li ekvidis lin, li ĵetis sin sur lian kolon kaj longe ploris sur lia kolo. ");
INSERT INTO epo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kaj Izrael diris al Jozef: Nun mi volonte mortos, vidinte vian vizaĝon, ĉar vi vivas ankoraŭ. ");
INSERT INTO epo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kaj Jozef diris al siaj fratoj kaj al la domo de sia patro: Mi iros kaj rakontos al Faraono, kaj diros al li: Miaj fratoj kaj la domo de mia patro, kiuj estis en la lando Kanaana, venis al mi; ");
INSERT INTO epo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","kaj tiuj homoj estas paŝtistoj, ĉar ili estas brutedukistoj; kaj siajn malgrandajn kaj grandajn brutojn, kaj ĉion, kion ili havas, ili kunportis. ");
INSERT INTO epo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kaj se Faraono vin alvokos, kaj diros: Kio estas via okupo? ");
INSERT INTO epo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tiam diru: Viaj sklavoj estis brutedukistoj de nia juneco ĝis nun, kiel ni, tiel ankaŭ niaj patroj; por ke vi enloĝiĝu en la lando Goŝen; ĉar ĉiu paŝtisto estas abomenindaĵo por la Egiptoj. ");
INSERT INTO epo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jozef venis kaj sciigis al Faraono, kaj diris: Mia patro kaj miaj fratoj kaj iliaj malgrandaj kaj grandaj brutoj, kaj ĉio, kio apartenas al ili, venis el la lando Kanaana, kaj nun ili estas en la lando Goŝen. ");
INSERT INTO epo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kaj el inter siaj fratoj li prenis kvin homojn kaj starigis ilin antaŭ Faraono. ");
INSERT INTO epo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kaj Faraono diris al liaj fratoj: Kio estas via okupo? Kaj ili diris al Faraono: Viaj sklavoj estas brutedukistoj, kiel ni, tiel ankaŭ niaj patroj. ");
INSERT INTO epo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kaj ili diris al Faraono: Ni venis, por loĝi en la lando; ĉar ne ekzistas paŝtaĵo por la brutoj de viaj sklavoj, ĉar forta estas la malsato en la lando Kanaana; permesu do, ke viaj sklavoj loĝu en la lando Goŝen. ");
INSERT INTO epo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tiam Faraono diris al Jozef jene: Via patro kaj viaj fratoj venis al vi; ");
INSERT INTO epo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","la lando Egipta estas antaŭ vi; en la plej bona loko de la lando loĝigu vian patron kaj viajn fratojn; ili loĝu en la lando Goŝen; kaj se vi scias, ke estas inter ili kapablaj homoj, faru ilin administrantoj de miaj brutoj. ");
INSERT INTO epo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kaj Jozef enkondukis sian patron Jakob kaj starigis lin antaŭ Faraono; kaj Jakob benis Faraonon. ");
INSERT INTO epo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraono diris al Jakob: Kian aĝon vi havas? ");
INSERT INTO epo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kaj Jakob diris al Faraono: La nombro de la jaroj de mia migrado estas cent tridek jaroj; malmultaj kaj malbonaj estis la jaroj de mia vivo, kaj ili ne atingis la nombron de la jaroj de la vivo de miaj patroj dum ilia migrado. ");
INSERT INTO epo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kaj Jakob benis Faraonon kaj foriris de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kaj Jozef enloĝigis sian patron kaj siajn fratojn, kaj donis al ili posedaĵon en la Egipta lando, en la lando Rameses, kiel Faraono ordonis. ");
INSERT INTO epo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kaj Jozef havigis panon al sia patro kaj al siaj fratoj kaj al la tuta domo de sia patro, laŭ la nombro de la infanoj. ");
INSERT INTO epo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ne estis pano sur la tuta tero, ĉar la malsato estis tre forta; kaj senfortiĝis de la malsato la lando Egipta kaj la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kaj Jozef kolektis la tutan monon, kiu troviĝis en la lando Egipta kaj en la lando Kanaana, pro la greno, kiun oni aĉetadis; kaj Jozef enportis la tutan monon en la domon de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kiam ne estis plu mono en la lando Egipta kaj en la lando Kanaana, ĉiuj Egiptoj venis al Jozef, kaj diris: Donu al ni panon; kial ni mortu antaŭ vi pro tio, ke ni jam ne havas monon? ");
INSERT INTO epo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tiam Jozef diris: Donu viajn brutojn; kaj mi donos al vi panon pro viaj brutoj, se vi jam ne havas monon. ");
INSERT INTO epo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kaj ili alkondukis siajn brutojn al Jozef; kaj Jozef donis al ili panon pro ĉevaloj, ŝafoj, bovoj, kaj azenoj, kaj li provizadis al ili panon pro ĉiuj iliaj brutoj en tiu jaro. ");
INSERT INTO epo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kiam finiĝis tiu jaro, ili venis al li en la dua jaro, kaj diris al li: Ni ne kaŝos antaŭ nia sinjoro, ke monon ni jam ne havas, kaj la brutoj estas ĉe nia sinjoro; nenio restis antaŭ nia sinjoro krom niaj korpoj kaj nia tero; ");
INSERT INTO epo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","kial ni pereu antaŭ viaj okuloj, ni kaj nia tero? aĉetu nin kaj nian teron pro la pano, kaj ni kaj nia tero estu sklavoj al Faraono; kaj donu semon, por ke ni vivu kaj ne mortu kaj la tero ne dezertiĝu. ");
INSERT INTO epo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kaj Jozef aĉetis la tutan Egiptan teron por Faraono; ĉar la Egiptoj vendis ĉiu sian kampon, ĉar forte premis ilin la malsato. Kaj la tero fariĝis propraĵo de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Kaj la popolon li transirigis en la urbojn, de unu fino de Egiptujo ĝis la alia. ");
INSERT INTO epo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nur la teron de la pastroj li ne aĉetis; ĉar la pastroj havis parton, difinitan de Faraono, kaj ili manĝadis sian parton, kiun donis al ili Faraono, tial ili ne vendis sian teron. ");
INSERT INTO epo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kaj Jozef diris al la popolo: Jen mi aĉetis vin hodiaŭ kaj vian teron por Faraono; jen mi donas al vi semon, kaj prisemu la teron. ");
INSERT INTO epo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kaj kiam vi havos rikolton, vi donos kvinonon al Faraono, kaj kvar partoj apartenos al vi, por prisemi la kampon kaj por manĝi, por vi, por ĉio, kio estas en viaj domoj, kaj por viaj infanoj. ");
INSERT INTO epo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kaj ili diris: Vi konservis nian vivon; ni akiru favoron de nia sinjoro, kaj ni estu sklavoj al Faraono. ");
INSERT INTO epo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kaj Jozef faris ĝin leĝo ĝis la hodiaŭa tago: de la tero Egipta kvinono de la produktoj apartenas al Faraono. Nur la tero de la pastroj ne fariĝis propraĵo de Faraono. ");
INSERT INTO epo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kaj Izrael ekloĝis en la lando Egipta, en la lando Goŝen; kaj ili posedis ĝin kaj fruktis kaj multiĝis forte. ");
INSERT INTO epo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kaj Jakob vivis en la lando Egipta dek sep jarojn. Kaj la daŭro de la vivo de Jakob estis cent kvardek sep jaroj. ");
INSERT INTO epo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kiam alproksimiĝis la tempo, kiam Izrael devis morti, li alvokis sian filon Jozef, kaj diris al li: Se mi akiris vian favoron, metu vian manon sub mian femuron kaj faru al mi favorkoraĵon kaj fidelaĵon, ne enterigu min en Egiptujo; ");
INSERT INTO epo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","sed mi kuŝu kun miaj patroj; elportu min el Egiptujo kaj entombigu min en ilia tombujo. Kaj tiu diris: Mi faros, kiel vi diris. ");
INSERT INTO epo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kaj li diris: Ĵuru al mi. Kaj tiu ĵuris. Kaj Izrael adorkliniĝis sur la kapa parto de la lito. ");
INSERT INTO epo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Post tiuj okazintaĵoj oni sciigis al Jozef: Jen, via patro estas malsana. Kaj li prenis kun si siajn du filojn, Manase kaj Efraim. ");
INSERT INTO epo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kaj oni sciigis al Jakob, dirante: Jen via filo Jozef venas al vi. Tiam Izrael streĉis siajn fortojn kaj sidiĝis sur la lito. ");
INSERT INTO epo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Kaj Jakob diris al Jozef: Dio la Plejpotenca aperis al mi en Luz, en la lando Kanaana, kaj benis min. ");
INSERT INTO epo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kaj Li diris al mi: Mi fruktigos vin kaj multigos vin kaj faros vin amaso da popoloj, kaj Mi donos ĉi tiun landon al via idaro post vi kiel eternan posedaĵon. ");
INSERT INTO epo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kaj nun viaj du filoj, kiuj naskiĝis al vi en la lando Egipta antaŭ mia alveno al vi en Egiptujon, estas miaj; Efraim kaj Manase estu al mi, kiel Ruben kaj Simeon. ");
INSERT INTO epo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Sed viaj infanoj, kiuj naskiĝos al vi post ili, estu viaj; per la nomo de siaj fratoj ili estos nomataj en sia hereda parto. ");
INSERT INTO epo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kiam mi venis el Mezopotamio, mortis ĉe mi Raĥel en la lando Kanaana, dum la vojo, kiam restis ankoraŭ iom da tero ĝis Efrata; kaj mi enterigis ŝin tie sur la vojo al Efrata, kiu estas nomata ankaŭ Bet-Leĥem. ");
INSERT INTO epo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kaj Izrael ekvidis la filojn de Jozef, kaj diris: Kiuj estas ĉi tiuj? ");
INSERT INTO epo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kaj Jozef diris al sia patro: Ili estas miaj filoj, kiujn donis al mi Dio ĉi tie. Kaj tiu diris: Alkonduku ilin al mi, kaj mi benos ilin. ");
INSERT INTO epo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","La okuloj de Izrael malfortiĝis de maljuneco, li ne povis bone vidi. Jozef alkondukis ilin al li, kaj li kisis ilin kaj ĉirkaŭprenis ilin. ");
INSERT INTO epo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Kaj Izrael diris al Jozef: Vidi vian vizaĝon mi ne esperis, kaj jen Dio vidigis al mi eĉ vian idaron. ");
INSERT INTO epo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kaj Jozef forigis ilin de liaj genuoj, kaj kliniĝis antaŭ li vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Kaj Jozef prenis ambaŭ, Efraimon per sia dekstra mano, kontraŭ la maldekstra de Izrael, kaj Manasen per sia maldekstra mano, kontraŭ la dekstra de Izrael, kaj alkondukis ilin al li. ");
INSERT INTO epo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Sed Izrael etendis sian dekstran manon kaj metis ĝin sur la kapon de Efraim, kvankam li estis la pli juna, kaj sian maldekstran sur la kapon de Manase; li intence tiel faris per siaj manoj, ĉar Manase estis la unuenaskito. ");
INSERT INTO epo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kaj li benis Jozefon, kaj diris: Dio, antaŭ kiu iradis miaj patroj Abraham kaj Isaak, Dio, kiu paŝtis min de mia naskiĝo ĝis la nuna tago, ");
INSERT INTO epo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","la anĝelo, kiu savis min de ĉia malbono — Li benu la knabojn; oni nomu ilin per mia nomo kaj per la nomo de miaj patroj Abraham kaj Isaak, kaj ili kresku kaj multiĝu sur la tero. ");
INSERT INTO epo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jozef vidis, ke lia patro metis sian dekstran manon sur la kapon de Efraim, kaj tio ne plaĉis al li; kaj li prenis la manon de sia patro, por deturni ĝin de la kapo de Efraim sur la kapon de Manase. ");
INSERT INTO epo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kaj Jozef diris al sia patro: Ne tiel, mia patro, ĉar ĉi tiu estas la unuenaskito; metu vian dekstran manon sur lian kapon. ");
INSERT INTO epo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Sed lia patro rifuzis, kaj diris: Mi scias, mia filo, mi scias; li ankaŭ fariĝos popolo kaj li ankaŭ fariĝos granda, sed lia pli juna frato estos pli granda ol li, kaj lia idaro estos multenombra inter la popoloj. ");
INSERT INTO epo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kaj li benis ilin en tiu tago, dirante: Per vi benados Izrael, dirante: Dio vin faru kiel Efraim kaj Manase. Kaj li metis Efraimon antaŭ Manase. ");
INSERT INTO epo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kaj Izrael diris al Jozef: Jen mi mortas; kaj Dio estos kun vi kaj revenigos vin en la landon de viaj patroj. ");
INSERT INTO epo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kaj mi donas al vi unu pecon da lando preferece antaŭ viaj fratoj, kiun mi prenis el la manoj de la Amoridoj per mia glavo kaj pafarko. ");
INSERT INTO epo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kaj Jakob alvokis siajn filojn, kaj diris: Kolektiĝu, kaj mi sciigos al vi, kio fariĝos al vi en la tempo venonta. ");
INSERT INTO epo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kunvenu kaj aŭskultu, filoj de Jakob, Kaj aŭskultu Izraelon, vian patron. ");
INSERT INTO epo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, vi estas mia unuenaskito, Mia forto kaj komenco de mia vireco, Supro de digno kaj supro de potenco; ");
INSERT INTO epo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Rapidema kiel akvo, vi ne staros plej alte, Ĉar vi supreniris sur la liton de via patro; Tiam vi malhonoris mian liton per la supreniro. ");
INSERT INTO epo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon kaj Levi, fratoj; Iloj kruelaj estas viaj glavoj, ");
INSERT INTO epo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","En ilian konsilon mia animo ne iru, Al ilia kunveno ne aliĝu mia honoro; Ĉar en sia kolero ili mortigis viron Kaj pro sia kaprico ili kripligis bovon. ");
INSERT INTO epo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Malbenita estu ilia kolero, ĉar ĝi estas forta, Kaj ilia furiozo, ĉar ĝi estas kruela. Mi dividos ilin en Jakob, Kaj mi disĵetos ilin en Izrael. ");
INSERT INTO epo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Jehuda, vin laŭdos viaj fratoj; Via mano estas sur la nuko de viaj malamikoj; Kliniĝos antaŭ vi la filoj de via patro. ");
INSERT INTO epo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juna leono estas Jehuda; De ĉasakiro, mia filo, vi leviĝis. Li genuiĝis, kuŝiĝis kiel leono kaj kiel leonino; Kiu lin levos? ");
INSERT INTO epo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ne forpreniĝos sceptro de Jehuda, Nek regbastono de inter liaj piedoj, Ĝis venos paco Kaj al li humiliĝos la popoloj. ");
INSERT INTO epo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Li alligas al la vinbertrunko sian azenidon Kaj al la delikata vinberbranĉo la filon de sia azenino; Li lavas en vino sian veston Kaj en sango de vinberoj sian mantelon. ");
INSERT INTO epo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Liaj okuloj estas ruĝaj de vino Kaj la dentoj blankaj de lakto. ");
INSERT INTO epo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun loĝos ĉe la bordo de maro, Ĉe albordiĝejo de ŝipoj, Kaj lia limo atingos Cidonon. ");
INSERT INTO epo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaĥar estas fortosta azeno; Li kuŝos inter la baraĵoj. ");
INSERT INTO epo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kaj li vidis, ke ripozo estas bona Kaj la tero estas agrabla; Kaj li klinis sian ŝultron por portado Kaj fariĝis laboristo por tributo. ");
INSERT INTO epo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan juĝos sian popolon, Kiel unu el la triboj de Izrael. ");
INSERT INTO epo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan estos serpento ĉe la vojo, Cerasto ĉe la irejo, Mordanto de kalkano de ĉevalo, Ke ĝia rajdanto falas malantaŭen. ");
INSERT INTO epo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Vian helpon mi esperas, ho Eternulo. ");
INSERT INTO epo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gadon premos amaso, Sed li repremos ĝin je la kalkano. ");
INSERT INTO epo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ĉe Aŝer estas grasa lia pano, Kaj li liverados frandaĵojn al reĝoj. ");
INSERT INTO epo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali estas belkura cervo; Li donas belajn parolojn. ");
INSERT INTO epo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Fruktoporta arbo estas Jozef, Fruktoporta arbo super fonto; La branĉoj etendiĝis super la muron. ");
INSERT INTO epo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ĉagrenis lin pafistoj Kaj pafis kaj malamikis kontraŭ li; ");
INSERT INTO epo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Sed forta restis lia pafarko Kaj elastaj estas liaj brakoj, Per la manoj de la Potenculo de Jakob, Per la Paŝtisto, la Roko de Izrael. ");
INSERT INTO epo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","La Dio de via patro donos al vi helpon, La Plejpotenculo benos vin Per benoj de la ĉielo supre, Per benoj de la abismo, kiu kuŝas malsupre, Per benoj de la mamoj kaj de la utero. ");
INSERT INTO epo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","La benoj de via patro estas pli fortaj, Ol la benoj de miaj gepatroj, Ĝis la limo de la eternaj altaĵoj. Ili estu sur la kapo de Jozef Kaj sur la verto de la elektito inter liaj fratoj. ");
INSERT INTO epo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamen estas lupo karnoŝira; Matene li manĝos ĉasakiron, Kaj vespere li dividos rabaĵon. ");
INSERT INTO epo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tio estas ĉiuj dek du triboj de Izrael; kaj tio estas, kion diris al ili ilia patro; kaj li benis ilin, ĉiun per aparta beno li benis. ");
INSERT INTO epo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kaj li ordonis al ili, kaj diris al ili: Mi alkolektiĝas al mia popolo; enterigu min apud miaj patroj en la kaverno, kiu troviĝas sur la kampo de Efron la Ĥetido, ");
INSERT INTO epo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","en la duobla kampa kaverno, kiu troviĝas antaŭ Mamre en la lando Kanaana kaj kiun Abraham aĉetis kune kun la kampo de Efron la Ĥetido kiel tomban posedaĵon. ");
INSERT INTO epo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tie oni enterigis Abrahamon kaj lian edzinon Sara, tie oni enterigis Isaakon kaj lian edzinon Rebeka, kaj tie mi enterigis Lean, ");
INSERT INTO epo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","sur la kampo kaj en la kaverno sur ĝi, kiuj estas aĉetitaj de el la filoj de Ĥet. ");
INSERT INTO epo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kaj Jakob finis la ordonadon al siaj filoj, kaj li kunigis siajn piedojn sur la lito, kaj mortis kaj alkolektiĝis al sia popolo. ");
INSERT INTO epo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tiam Jozef ĵetis sin sur la vizaĝon de sia patro, kaj ploris super li kaj kisis lin. ");
INSERT INTO epo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kaj Jozef ordonis al siaj servantoj kuracistoj, balzami lian patron; kaj la kuracistoj balzamis Izraelon. ");
INSERT INTO epo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kaj pasis super li kvardek tagoj; ĉar tiel longe daŭras la tagoj de balzamado. Kaj la Egiptoj ploris pri li sepdek tagojn. ");
INSERT INTO epo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kiam pasis la tagoj de lia priplorado, Jozef ekparolis al la domanoj de Faraono, dirante: Se mi akiris vian favoron, diru al Faraono jene: ");
INSERT INTO epo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mia patro ĵurigis min, dirante: Jen mi mortas; en mia tombo, kiun mi elfosis al mi en la lando Kanaana, tie vi min enterigu. Nun mi volus iri, enterigi mian patron, kaj reveni. ");
INSERT INTO epo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kaj Faraono diris: Iru kaj enterigu vian patron, kiel li ĵurigis vin. ");
INSERT INTO epo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kaj Jozef iris, por enterigi sian patron; kaj kun li iris ĉiuj servantoj de Faraono, la ĉefoj de lia domo kaj ĉiuj ĉefoj de la lando Egipta, ");
INSERT INTO epo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kaj la tuta domo de Jozef, kaj liaj fratoj kaj la domo de lia patro; nur siajn infanojn kaj siajn malgrandajn kaj grandajn brutojn ili restigis en la lando Goŝen. ");
INSERT INTO epo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kun ili iris ankaŭ ĉaroj kaj rajdantoj; kaj la anaro estis tre granda. ");
INSERT INTO epo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ili venis al la placo Atad, kiu estas transe de Jordan, kaj ili faris tie grandan kaj fortan priploradon; kaj li funebris pri sia patro dum sep tagoj. ");
INSERT INTO epo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kiam la loĝantoj de la lando Kanaana vidis la funebron sur la placo Atad, ili diris: Ĝi estas granda funebro ĉe la Egiptoj; tial la loko ricevis la nomon Abel-Micraim. Ĝi estas transe de Jordan. ");
INSERT INTO epo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kaj liaj infanoj faris kun li, kiel li ordonis al ili. ");
INSERT INTO epo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kaj liaj filoj forportis lin en la landon Kanaanan, kaj enterigis lin en la kampa duobla kaverno, kiun Abraham aĉetis kune kun la kampo kiel tomban posedaĵon de el Efron la Ĥetido, antaŭ Mamre. ");
INSERT INTO epo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kaj Jozef revenis Egiptujon, li kaj liaj fratoj, kaj ĉiuj, kiuj iris kun li, por enterigi lian patron, post kiam ili enterigis lian patron. ");
INSERT INTO epo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kiam la fratoj de Jozef vidis, ke ilia patro mortis, ili diris: Eble Jozef ekmalamos nin, kaj repagos al ni pro la tuta malbono, kiun ni faris al li? ");
INSERT INTO epo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tial ili sendis al Jozef, por diri al li: Via patro ordonis antaŭ sia morto jene: ");
INSERT INTO epo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Tiel diru al Jozef: Mi petas vin, pardonu la kulpon de viaj fratoj kaj ilian pekon, ĉar ili faris al vi malbonon. Nun pardonu do la kulpon de la sklavoj de la Dio de via patro. Kaj Jozef ploris, kiam ili parolis al li. ");
INSERT INTO epo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kaj iris liaj fratoj mem kaj ĵetis sin teren antaŭ li, kaj diris: Jen ni estas sklavoj al vi. ");
INSERT INTO epo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Sed Jozef diris al ili: Ne timu; ĉar ĉu mi estas anstataŭ Dio? ");
INSERT INTO epo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vi intencis fari al mi malbonon; sed Dio aranĝis de tio bonon, por fari tiel, kiel nun estas, por konservi la vivon de multe da homoj. ");
INSERT INTO epo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kaj nun ne timu; mi nutros vin kaj viajn infanojn. Kaj li konsolis ilin kaj parolis al ili kore. ");
INSERT INTO epo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Kaj Jozef loĝis en Egiptujo, li kaj la domo de lia patro; kaj Jozef vivis cent dek jarojn. ");
INSERT INTO epo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Kaj Jozef vidis ĉe Efraim infanojn ĝis la tria generacio; ankaŭ la infanoj de Maĥir, filo de Manase, naskiĝis sur la genuoj de Jozef. ");
INSERT INTO epo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kaj Jozef diris al siaj fratoj: Mi mortas, sed Dio rememoros vin, kaj elkondukos vin el ĉi tiu lando en la landon, pri kiu Li ĵuris al Abraham, Isaak, kaj Jakob. ");
INSERT INTO epo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kaj Jozef ĵurigis la filojn de Izrael, dirante: Kiam Dio rememoros vin, tiam elportu miajn ostojn el ĉi tie. ");
INSERT INTO epo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kaj Jozef mortis en la aĝo de cent dek jaroj; kaj oni balzamis lin kaj metis lin en ĉerkon en Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Jen estas la nomoj de la filoj de Izrael, kiuj venis Egiptujon kun Jakob; ĉiu venis kun siaj domanoj: ");
INSERT INTO epo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, kaj Jehuda; ");
INSERT INTO epo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaĥar, Zebulun, kaj Benjamen; ");
INSERT INTO epo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan kaj Naftali, Gad kaj Aŝer. ");
INSERT INTO epo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Kaj la nombro de ĉiuj animoj, kiuj eliris el la lumbo de Jakob, estis sepdek; kaj Jozef estis jam en Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kaj mortis Jozef kaj ĉiuj liaj fratoj kaj tiu tuta generacio. ");
INSERT INTO epo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kaj la Izraelidoj fruktis kaj diskreskis kaj multiĝis kaj treege fortiĝis, kaj la lando pleniĝis de ili. ");
INSERT INTO epo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Aperis en Egiptujo nova reĝo, kiu ne konis Jozefon. ");
INSERT INTO epo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kaj li diris al sia popolo: Jen la popolo de la Izraelidoj estas pli multenombra kaj pli forta ol ni; ");
INSERT INTO epo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ni uzu do ruzon kontraŭ ĝi, por ke ĝi ne multiĝu, ĉar se okazos milito, tiam ankaŭ tiu popolo aliĝos al niaj malamikoj kaj militos kontraŭ ni kaj foriros el la lando. ");
INSERT INTO epo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kaj oni metis super ilin laborestrojn, por premi ilin per malfacilaj laboroj. Kaj ili konstruis por Faraono provizejajn urbojn Pitom kaj Rameses. ");
INSERT INTO epo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Sed ju pli oni premis ilin, des pli ili multiĝis kaj kreskis; kaj la Izraelidoj fariĝis teruraĵo. ");
INSERT INTO epo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Kaj la Egiptoj laborigis la Izraelidojn kruele. ");
INSERT INTO epo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Kaj ili maldolĉigis al ili la vivon per malfacila laboro super argilo kaj brikoj, kaj per ĉia laboro sur la kampo, per ĉiaj laboroj, kiujn ili kruele metis sur ilin. ");
INSERT INTO epo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kaj la reĝo de Egiptujo parolis al la Hebreaj akuŝistinoj, el kiuj unu estis nomata Ŝifra kaj la dua estis nomata Pua. ");
INSERT INTO epo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Li diris: Kiam vi akuŝigos la Hebreinojn, rigardu la kuŝejon; se estas filo, mortigu lin, kaj se estas filino, lasu ŝin vivi. ");
INSERT INTO epo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Sed la akuŝistinoj timis Dion, kaj ili ne faris, kiel diris al ili la reĝo de Egiptujo; kaj ili lasis la vivon al la virseksaj infanoj. ");
INSERT INTO epo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kaj la reĝo de Egiptujo alvokis la akuŝistinojn, kaj diris al ili: Kial vi tion faras kaj lasas la vivon al la virseksaj infanoj? ");
INSERT INTO epo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tiam la akuŝistinoj diris al Faraono: Ne kiel la Egiptaj virinoj estas la Hebreinoj; ili estas viglaj: antaŭ ol venas al ili la akuŝistino, ili jam estas naskintaj. ");
INSERT INTO epo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kaj Dio faris bonon al la akuŝistinoj, kaj la popolo multiĝis kaj tre fortiĝis. ");
INSERT INTO epo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kaj ĉar la akuŝistinoj timis Dion, Li konstruis al ili domojn. ");
INSERT INTO epo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kaj Faraono ordonis al sia tuta popolo, dirante: Ĉiun filon, kiu naskiĝis, ĵetu en la Riveron, kaj ĉiun filinon lasu viva. ");
INSERT INTO epo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kaj iris unu homo el la domo de Levi kaj prenis edzinon Leviidinon. ");
INSERT INTO epo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kaj la virino gravediĝis, kaj naskis filon; kaj ŝi vidis, ke li estas bela, kaj ŝi kaŝis lin dum tri monatoj. ");
INSERT INTO epo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Sed ŝi ne povis plu kaŝi lin, tial ŝi prenis por li keston el kanoj kaj ĉirkaŭŝmiris ĝin per asfalto kaj peĉo, kaj metis tien la infanon kaj metis ĝin inter la kanojn sur la bordo de la Rivero. ");
INSERT INTO epo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kaj lia fratino stariĝis malproksime, por sciiĝi, kio fariĝos kun li. ");
INSERT INTO epo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kaj la filino de Faraono malsupreniris, por lavi sin en la Rivero, kaj ŝiaj servantinoj iradis sur la bordo de la Rivero. Ŝi ekvidis la keston meze de la kanoj, kaj ŝi sendis sian sklavinon, ke ŝi ĝin prenu. ");
INSERT INTO epo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ŝi malfermis, kaj ekvidis la infanon; ĝi estis knabeto, kiu ploris. Kaj ŝi kompatis lin, kaj diris: Ĝi estas el la Hebreaj infanoj. ");
INSERT INTO epo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tiam lia fratino diris al la filino de Faraono: Ĉu mi iru kaj voku al vi virinon nutrantinon el la Hebreinoj, ke ŝi nutru por vi la infanon? ");
INSERT INTO epo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kaj la filino de Faraono diris al ŝi: Iru. Kaj la knabino iris kaj vokis la patrinon de la infano. ");
INSERT INTO epo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kaj la filino de Faraono diris al ŝi: Prenu ĉi tiun infanon kaj nutru ĝin por mi, kaj mi pagos al vi. Kaj la virino prenis la infanon kaj nutris ĝin. ");
INSERT INTO epo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kiam la infano grandiĝis, ŝi alportis lin al la filino de Faraono, kaj li fariĝis filo por ŝi, kaj ŝi donis al li la nomon Moseo, dirante: El la akvo mi lin eltiris. ");
INSERT INTO epo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En la tempo, kiam Moseo estis jam granda, li eliris al siaj fratoj kaj vidis iliajn malfacilajn laborojn; kaj li vidis, ke Egipto batas iun Hebreon el liaj fratoj. ");
INSERT INTO epo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tiam li turnis sin unuflanken kaj aliflanken, kaj vidinte, ke estas neniu, mortigis la Egipton kaj kaŝis lin en la sablo. ");
INSERT INTO epo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kaj li eliris en la sekvanta tago, kaj vidis, ke du Hebreoj malpacas. Kaj li diris al la ofendanto: Kial vi batas vian proksimulon? ");
INSERT INTO epo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Kaj tiu diris: Kiu faris vin estro kaj juĝanto super ni? ĉu vi intencas mortigi min, kiel vi mortigis la Egipton? Tiam Moseo ektimis, kaj diris: Videble la afero fariĝis sciata. ");
INSERT INTO epo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kaj Faraono aŭdis pri tiu afero kaj deziris mortigi Moseon. Sed Moseo forkuris de Faraono kaj ekloĝis en la lando Midjana, kaj li loĝis apud puto. ");
INSERT INTO epo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","La pastro Midjana havis sep filinojn. Kaj ili venis kaj ĉerpis akvon kaj plenigis la trogojn, por trinkigi la ŝafojn de sia patro. ");
INSERT INTO epo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Sed venis la paŝtistoj kaj forpelis ilin. Tiam Moseo leviĝis kaj helpis ilin kaj trinkigis iliajn ŝafojn. ");
INSERT INTO epo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kiam ili venis al sia patro Reuel, li diris: Kial vi tiel baldaŭ venis hodiaŭ? ");
INSERT INTO epo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kaj ili diris: Iu Egipto savis nin el la manoj de la paŝtistoj, kaj li eĉ ĉerpis por ni kaj trinkigis la ŝafojn. ");
INSERT INTO epo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tiam li diris al siaj filinoj: Kie do li estas? kial vi forlasis tiun homon? voku lin, ke li manĝu panon. ");
INSERT INTO epo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Kaj Moseo konsentis loĝi ĉe tiu homo; kaj tiu donis sian filinon Cipora al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kaj ŝi naskis filon, kaj li donis al li la nomon Gerŝom, ĉar li diris: Fremdulo mi estis en lando fremda. ");
INSERT INTO epo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Post longa tempo mortis la reĝo de Egiptujo. Kaj la Izraelidoj ĝemis pro la laboroj kaj kriis, kaj ilia kriado pro la laboroj venis supren al Dio. ");
INSERT INTO epo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Kaj Dio aŭdis ilian ĝemadon, kaj Dio rememoris Sian interligon kun Abraham, Isaak, kaj Jakob. ");
INSERT INTO epo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Kaj Dio rigardis la Izraelidojn, kaj Dio rememoris ilin. ");
INSERT INTO epo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moseo paŝtis la ŝafojn de Jitro, sia bopatro, pastro Midjana. Kaj li forkondukis la ŝafojn en malproksiman parton de la dezerto kaj venis al la Dia monto Ĥoreb. ");
INSERT INTO epo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kaj aperis al li anĝelo de la Eternulo en flama fajro el la mezo de arbetaĵo. Kaj li vidis, ke jen la arbetaĵo brulas en la fajro, kaj tamen la arbetaĵo ne forbrulas. ");
INSERT INTO epo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kaj Moseo diris: Mi iros kaj rigardos tiun grandan fenomenon, kial la arbetaĵo ne forbrulas. ");
INSERT INTO epo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","La Eternulo vidis, ke li iras, por rigardi, kaj Dio vokis al li el la mezo de la arbetaĵo, kaj diris: Moseo, Moseo! Kaj tiu diris: Jen mi estas. ");
INSERT INTO epo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kaj Li diris: Ne alproksimiĝu ĉi tien; deprenu viajn ŝuojn de viaj piedoj, ĉar la loko, sur kiu vi staras, estas tero sankta. ");
INSERT INTO epo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ankoraŭ Li diris: Mi estas la Dio de via patro, la Dio de Abraham, la Dio de Isaak, kaj la Dio de Jakob. Kaj Moseo kovris sian vizaĝon, ĉar li timis rigardi Dion. ");
INSERT INTO epo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kaj la Eternulo diris: Mi vidis la mizeron de Mia popolo, kiu estas en Egiptujo, kaj Mi aŭdis ĝian kriadon kaŭze de ĝiaj premantoj; Mi scias ĝiajn suferojn. ");
INSERT INTO epo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kaj Mi malsupreniris, por savi ĝin el la manoj de la Egiptoj kaj elirigi ĝin el tiu lando en landon bonan kaj vastan, en landon, en kiu fluas lakto kaj mielo, sur la lokon de la Kanaanidoj kaj la Ĥetidoj kaj la Amoridoj kaj la Perizidoj kaj la Ĥividoj kaj la Jebusidoj. ");
INSERT INTO epo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nun la krioj de la Izraelidoj venis al Mi; kaj Mi vidis la turmentojn, per kiuj la Egiptoj turmentas ilin. ");
INSERT INTO epo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Iru do, Mi sendos vin al Faraono, kaj elkonduku Mian popolon la Izraelidojn el Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kaj Moseo diris al Dio: Kiu mi estas, ke mi iru al Faraono kaj mi elkonduku la Izraelidojn el Egiptujo? ");
INSERT INTO epo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kaj Li diris: Mi estos kun vi; kaj tio estu por vi signo, ke Mi vin sendis: kiam vi estos elkondukinta Mian popolon el Egiptujo, vi faros servon al Dio sur ĉi tiu monto. ");
INSERT INTO epo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kaj Moseo diris al Dio: Jen mi venos al la Izraelidoj, kaj diros al ili: La Dio de viaj patroj sendis min al vi; tiam ili diros al mi: Kia estas Lia nomo? Kion mi diru al ili? ");
INSERT INTO epo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kaj Dio diris al Moseo: MI ESTAS, KIU ESTAS. Kaj Li diris: Tiel diru al la Izraelidoj: La Estanto sendis min al vi. ");
INSERT INTO epo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kaj plue Dio diris al Moseo: Tiel diru al la Izraelidoj: La Eternulo, la Dio de viaj patroj, la Dio de Abraham, la Dio de Isaak, kaj la Dio de Jakob, sendis min al vi. Tia estas Mia nomo por eterne, kaj tia estas memoraĵo pri Mi por ĉiuj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Iru, kaj kunvenigu la ĉefojn de Izrael, kaj diru al ili: La Eternulo, la Dio de viaj patroj, aperis al mi, la Dio de Abraham, Isaak, kaj Jakob, kaj Li diris: Mi atentis vin, kaj tion, kio estas farita al vi en Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kaj Mi diris: Mi elirigos vin el la mizero de Egiptujo en la landon de la Kanaanidoj kaj la Ĥetidoj kaj la Amoridoj kaj la Perizidoj kaj la Ĥividoj kaj la Jebusidoj, en landon, en kiu fluas lakto kaj mielo. ");
INSERT INTO epo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Kaj ili aŭskultos vian voĉon, kaj vi venos, vi kaj la ĉefoj de Izrael, al la reĝo de Egiptujo, kaj vi diros al li: La Eternulo, la Dio de la Hebreoj, vokis nin; lasu do nin iri vojon de tri tagoj en la dezerton, por ke ni faru oferon al la Eternulo, nia Dio. ");
INSERT INTO epo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Sed Mi scias, ke la reĝo de Egiptujo ne permesos al vi iri, se ne devigos lin forta mano. ");
INSERT INTO epo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kaj Mi etendos Mian manon, kaj Mi batos Egiptujon per ĉiuj Miaj mirakloj, kiujn Mi faros meze de ĝi; kaj poste li lasos vin iri. ");
INSERT INTO epo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Kaj Mi donos al tiu popolo favoron de la Egiptoj; kaj kiam vi iros, vi ne iros kun malplenaj manoj. ");
INSERT INTO epo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ĉiu virino petos de sia najbarino kaj de sia samdomanino vazojn arĝentajn kaj vazojn orajn kaj vestojn; kaj vi metos tion sur viajn filojn kaj sur viajn filinojn, kaj vi senhavigos la Egiptojn. ");
INSERT INTO epo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moseo respondis kaj diris: Sed se ili ne kredos al mi kaj ne aŭskultos mian voĉon, kaj se ili diros: Ne aperis al vi la Eternulo? ");
INSERT INTO epo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kaj la Eternulo diris al li: Kion vi tie havas en via mano? Kaj li diris: Bastonon. ");
INSERT INTO epo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kaj Li diris: Ĵetu ĝin sur la teron. Kaj li ĵetis ĝin sur la teron, kaj ĝi fariĝis serpento; kaj Moseo forkuris de ĝi. ");
INSERT INTO epo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Sed la Eternulo diris al Moseo: Etendu vian manon, kaj kaptu ĝin je ĝia vosto (kaj li etendis sian manon kaj kaptis ĝin, kaj ĝi fariĝis bastono en lia mano), ");
INSERT INTO epo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","por ke ili kredu, ke aperis al vi la Eternulo, la Dio de iliaj patroj, la Dio de Abraham, la Dio de Isaak, kaj la Dio de Jakob. ");
INSERT INTO epo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kaj la Eternulo diris al li plue: Metu vian manon en vian sinon. Kaj li metis sian manon en sian sinon; kaj kiam li elprenis ĝin, jen lia mano estis leprokovrita kvazaŭ neĝo. ");
INSERT INTO epo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kaj Li diris: Remetu vian manon en vian sinon (kaj li remetis sian manon en sian sinon; kaj kiam li elprenis ĝin el sia sino, jen ĝi denove fariĝis kiel lia karno); ");
INSERT INTO epo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","kaj se ili ne kredos al vi kaj ne aŭskultos la voĉon de la unua signo, ili kredos al la voĉo de la alia signo. ");
INSERT INTO epo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kaj se ili ne kredos eĉ al ambaŭ tiuj signoj kaj ne aŭskultos vian voĉon, tiam prenu akvon el la Rivero kaj verŝu ĝin sur la sekan teron; kaj tiam la akvo, kiun vi prenis el la Rivero, fariĝos sango sur la seka tero. ");
INSERT INTO epo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Kaj Moseo diris al la Eternulo: Ho, mia Sinjoro, mi ne estas elokventa, nek de hieraŭ, nek de antaŭhieraŭ, nek de tiu tempo, kiam Vi komencis paroli al Via sklavo; ĉar mi havas nelertan buŝon kaj nelertan langon. ");
INSERT INTO epo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kaj la Eternulo diris al li: Kiu faris buŝon al la homo? aŭ kiu faras muta aŭ surda aŭ vidanta aŭ blinda? ĉu ne Mi, la Eternulo? ");
INSERT INTO epo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kaj nun iru, kaj Mi estos kun via buŝo, kaj Mi instruos vin, kion vi devas paroli. ");
INSERT INTO epo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Kaj li diris: Ho, mia Sinjoro, sendu iun alian. ");
INSERT INTO epo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tiam ekflamis la kolero de la Eternulo kontraŭ Moseo, kaj Li diris: Mi scias ja, ke via frato Aaron, la Levido, estas elokventa; kaj jen li eĉ iras al vi renkonte, kaj kiam li vidos vin, li ekĝojos en sia koro. ");
INSERT INTO epo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kaj vi parolos al li kaj metos la vortojn en lian buŝon; kaj Mi estos kun via buŝo kaj kun lia buŝo, kaj Mi instruos vin, kion vi devas fari. ");
INSERT INTO epo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Kaj li parolos por vi al la popolo; kaj li estos via buŝo, kaj vi estos por li anstataŭ Dio. ");
INSERT INTO epo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kaj ĉi tiun bastonon prenu en vian manon; per ĝi vi faros la signojn. ");
INSERT INTO epo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moseo iris kaj revenis al sia bopatro Jitro, kaj diris al li: Mi volas iri kaj reveni al miaj fratoj, kiuj estas en Egiptujo, kaj vidi, ĉu ili vivas ankoraŭ. Kaj Jitro diris al Moseo: Iru en paco. ");
INSERT INTO epo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Kaj la Eternulo diris al Moseo en Midjanujo: Iru, revenu Egiptujon; ĉar mortis ĉiuj homoj, kiuj volis vin mortigi. ");
INSERT INTO epo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tiam Moseo prenis sian edzinon kaj siajn filojn kaj sidigis ilin sur azeno, kaj ekiris al la lando Egipta. Kaj Moseo prenis la bastonon de Dio en sian manon. ");
INSERT INTO epo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kaj la Eternulo diris al Moseo: Kiam vi revenos Egiptujon, tiam rigardu, ĉiujn miraklojn, kiujn Mi donis en vian manon, faru antaŭ Faraono. Sed Mi malmoligos lian koron, kaj li ne permesos al la popolo foriri. ");
INSERT INTO epo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kaj vi diru al Faraono: Tiel diris la Eternulo: Mia filo unuenaskita estas Izrael; ");
INSERT INTO epo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","kaj Mi diras al vi: Permesu, ke Mia filo iru kaj faru al Mi servon; se vi ne permesos al li iri, tiam Mi mortigos vian unuenaskitan filon. ");
INSERT INTO epo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Sur la vojo, en la noktohaltejo, renkontis lin la Eternulo kaj volis mortigi lin; ");
INSERT INTO epo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","sed Cipora prenis akran ŝtonon, kaj detranĉis la prepucion de sia filo kaj ektuŝis liajn piedojn, kaj diris: Sanga fianĉo vi estas por mi. ");
INSERT INTO epo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tiam Li forlasis lin. Kaj ŝi diris: Sanga fianĉo per la cirkumcido. ");
INSERT INTO epo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Kaj la Eternulo diris al Aaron: Iru renkonte al Moseo en la dezerton. Kaj li iris kaj renkontis lin ĉe la monto de Dio, kaj kisis lin. ");
INSERT INTO epo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kaj Moseo diris al Aaron ĉiujn vortojn de la Eternulo, kiu sendis lin, kaj ĉiujn signojn, pri kiuj Li ordonis al li. ");
INSERT INTO epo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kaj iris Moseo kaj Aaron kaj kunvenigis ĉiujn ĉefojn de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Kaj Aaron diris ĉiujn vortojn, kiujn la Eternulo diris al Moseo, kaj li faris la signojn antaŭ la popolo. ");
INSERT INTO epo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Kaj la popolo kredis. Kaj ili aŭdis, ke la Eternulo rememoris la Izraelidojn kaj vidis ilian mizeron, kaj ili kliniĝis kaj faris adoron. ");
INSERT INTO epo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Poste venis Moseo kaj Aaron, kaj diris al Faraono: Tiel diris la Eternulo, la Dio de Izrael: Permesu, ke Mia popolo iru kaj faru al Mi feston en la dezerto. ");
INSERT INTO epo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Sed Faraono diris: Kiu estas la Eternulo, kies voĉon mi devas obei kaj lasi Izraelon iri? mi ne konas la Eternulon, kaj al Izrael mi ne permesos iri. ");
INSERT INTO epo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Kaj ili diris: La Dio de la Hebreoj vokis nin; permesu, ke ni iru vojon de tri tagoj en la dezerton kaj ni alportu oferon al la Eternulo, nia Dio, por ke Li ne frapu nin per pesto aŭ glavo. ");
INSERT INTO epo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Sed la reĝo de Egiptujo diris al ili: Kial vi, Moseo kaj Aaron, fortiras la popolon de ĝiaj laboroj? iru al viaj laboroj. ");
INSERT INTO epo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kaj Faraono diris: Jen multenombra estas nun la popolo de la lando, kaj vi volas liberigi ilin de iliaj laboroj! ");
INSERT INTO epo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kaj Faraono ordonis en tiu tago al la voktoj de la popolo kaj al ĝiaj kontrolistoj, dirante: ");
INSERT INTO epo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ne donu plu pajlon al la popolo por la farado de la brikoj, kiel ĝis nun; ili mem iru kaj kolektu al si pajlon. ");
INSERT INTO epo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Sed la nombron de la brikoj, kiun ili pretigas ĝis nun, postulu de ili, ne malgrandigu ĝin; ĉar ili vagas senlabore, tial ili krias: Ni iru kaj alportu oferon al nia Dio. ");
INSERT INTO epo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Oni devas premi tiujn homojn per la laboro, por ke ili estu okupitaj de ĝi kaj ne atentu mensogajn vortojn. ");
INSERT INTO epo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Tiam eliris la voktoj de la popolo kaj ĝiaj kontrolistoj, kaj diris al la popolo: Tiel diras Faraono: Mi ne donos al vi pajlon; ");
INSERT INTO epo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","iru mem, prenu al vi pajlon, kie vi trovos; sed el via laboro nenio estos deprenata. ");
INSERT INTO epo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tiam la popolo disiĝis en la tuta lando Egipta, por kolekti pecojn da pajlo. ");
INSERT INTO epo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kaj la voktoj insistadis, dirante: Pretigu vian ĉiutagan laboron, kiel tiam, kiam vi havis pajlon. ");
INSERT INTO epo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Kaj la kontrolistojn Izraelidojn, starigitajn super ili de la voktoj de Faraono, oni batadis, dirante: Kial vi ne pretigis vian ordonitan nombron da brikoj hieraŭ kaj hodiaŭ, kiel ĝis nun? ");
INSERT INTO epo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","La kontrolistoj Izraelidoj venis kaj kriis al Faraono, dirante: Kial vi agas tiel kun viaj sklavoj? ");
INSERT INTO epo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Pajlo ne estas donata al viaj sklavoj, kaj brikojn oni ordonas al ni fari; kaj nun viaj sklavoj estas batataj, kaj via popolo pekas. ");
INSERT INTO epo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Sed li diris: Mallaboruloj vi estas, mallaboruloj, tial vi diras: Ni iru, ni alportu oferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kaj nun iru, laboru, kaj pajlon oni ne donos al vi, kaj la difinitan nombron da brikoj liveru. ");
INSERT INTO epo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kaj la kontrolistoj Izraelidoj vidis, ke estas al ili malbone, ĉar estas dirite: Ne malgrandigu la ĉiutagan nombron de viaj brikoj. ");
INSERT INTO epo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ili renkontis Moseon kaj Aaronon, kiuj staris antaŭ ili, kiam ili eliris de Faraono. ");
INSERT INTO epo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kaj ili diris al tiuj: La Eternulo rigardu vin, kaj juĝu vin por tio, ke vi malbonodorigis nian odoron antaŭ Faraono kaj antaŭ liaj servantoj, kaj donis glavon en iliajn manojn, por mortigi nin. ");
INSERT INTO epo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tiam Moseo turnis sin al la Eternulo, kaj diris: Mia Sinjoro! kial Vi faris malbonon al tiu popolo? kial Vi sendis min? ");
INSERT INTO epo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","De tiu tempo, kiam mi venis al Faraono, por paroli en Via nomo, li fariĝis pli malbona kontraŭ tiu popolo, kaj Vi ne savis Vian popolon. ");
INSERT INTO epo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Sed la Eternulo diris al Moseo: Nun vi vidos, kion Mi faros al Faraono; ĉar pro mano forta li foririgos ilin kaj pro mano forta li elpelos ilin el sia lando. ");
INSERT INTO epo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kaj Dio ekparolis al Moseo kaj diris al li: Mi estas la ETERNULO. ");
INSERT INTO epo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mi aperis al Abraham, al Isaak, kaj al Jakob kiel Dio la Plejpotenca, sed Mian nomon ETERNULO Mi ne sciigis al ili. ");
INSERT INTO epo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mi starigis Mian interligon kun ili, ke Mi donos al ili la landon Kanaanan, la landon de ilia migrado, en kiu ili loĝis kiel fremduloj. ");
INSERT INTO epo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kaj Mi aŭdis la ĝemadon de la Izraelidoj, kiujn la Egiptoj premas per laboroj, kaj Mi rememoris Mian interligon. ");
INSERT INTO epo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Tial diru al la Izraelidoj: Mi estas la Eternulo, kaj Mi elirigos vin el sub la jugo de Egiptujo, kaj Mi liberigos vin el ilia sklaveco, kaj Mi savos vin per etendita brako kaj grandaj juĝoj. ");
INSERT INTO epo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kaj Mi prenos vin kiel Mian popolon, kaj Mi estos via Dio; kaj vi scios, ke Mi estas la Eternulo, via Dio, kiu elirigas vin el sub la jugo de Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kaj Mi venigos vin en la landon, pri kiu Mi, levinte Mian manon, promesis, ke Mi donos ĝin al Abraham, al Isaak, kaj al Jakob, kaj Mi donos ĝin al vi kiel posedaĵon, Mi, la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moseo parolis tiel al la Izraelidoj; sed ili ne aŭskultis Moseon pro malforteco de spirito kaj pro la malfacilaj laboroj. ");
INSERT INTO epo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Eniru, diru al Faraono, la reĝo de Egiptujo, ke li ellasu la Izraelidojn el sia lando. ");
INSERT INTO epo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moseo ekparolis antaŭ la Eternulo, dirante: Jen la Izraelidoj ne aŭskultas min, kiel do min aŭskultos Faraono? kaj mi havas nelertajn lipojn. ");
INSERT INTO epo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Sed la Eternulo ekparolis al Moseo kaj al Aaron, kaj donis al ili ordonojn por la Izraelidoj, kaj por Faraono, reĝo de Egiptujo, por elirigi la Izraelidojn el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Jen estas la ĉefoj de iliaj familioj: la filoj de Ruben, unuenaskito de Izrael: Ĥanoĥ kaj Palu, Ĥecron kaj Karmi. Tio estas la familioj de Ruben. ");
INSERT INTO epo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Kaj la filoj de Simeon: Jemuel kaj Jamin kaj Ohad kaj Jaĥin kaj Coĥar, kaj Ŝaul, filo de Kanaanidino. Tio estas la familioj de Simeon. ");
INSERT INTO epo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Kaj jen estas la nomoj de la filoj de Levi laŭ ilia naskiĝo: Gerŝon kaj Kehat kaj Merari. La daŭro de la vivo de Levi estis cent tridek sep jaroj. ");
INSERT INTO epo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","La filoj de Gerŝon: Libni kaj Ŝimei, kun iliaj familioj. ");
INSERT INTO epo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kaj la filoj de Kehat: Amram kaj Jichar kaj Ĥebron kaj Uziel. La daŭro de la vivo de Kehat estis cent tridek tri jaroj. ");
INSERT INTO epo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Kaj la filoj de Merari: Maĥli kaj Muŝi. Tio estas la familioj de Levi laŭ ilia naskiĝo. ");
INSERT INTO epo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram prenis al si sian onklinon Joĥebed kiel edzinon, kaj ŝi naskis al li Aaronon kaj Moseon. La daŭro de la vivo de Amram estis cent tridek sep jaroj. ");
INSERT INTO epo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Kaj la filoj de Jichar: Koraĥ kaj Nefeg kaj Ziĥri. ");
INSERT INTO epo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Kaj la filoj de Uziel: Miŝael kaj Elcafan kaj Sitri. ");
INSERT INTO epo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron prenis al si Eliŝeban, filinon de Aminadab kaj fratinon de Naĥŝon, kiel edzinon, kaj ŝi naskis al li Nadabon kaj Abihun, Eleazaron kaj Itamaron. ");
INSERT INTO epo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kaj la filoj de Koraĥ: Asir kaj Elkana kaj Abiasaf. Tio estas la familioj de la Koraĥidoj. ");
INSERT INTO epo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, la filo de Aaron, prenis al si edzinon el la filinoj de Putiel, kaj ŝi naskis al li Pineĥason. Tio estas la ĉefoj de la Leviidoj laŭ iliaj familioj. ");
INSERT INTO epo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Tio estas tiuj Aaron kaj Moseo, al kiuj la Eternulo diris: Elirigu la Izraelidojn el la lando Egipta laŭ iliaj taĉmentoj. ");
INSERT INTO epo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Tio estas ili, kiuj parolis al Faraono, reĝo de Egiptujo, por elirigi la Izraelidojn el Egiptujo; tio estas Moseo kaj Aaron. ");
INSERT INTO epo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","En tiu tago, kiam la Eternulo parolis al Moseo en la lando Egipta, ");
INSERT INTO epo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","la Eternulo diris al Moseo jene: Mi estas la Eternulo. Diru al Faraono, reĝo de Egiptujo, ĉion, kion Mi diras al vi. ");
INSERT INTO epo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kaj Moseo diris antaŭ la Eternulo: Jen mi havas nelertajn lipojn; kiel do Faraono min aŭskultos? ");
INSERT INTO epo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Sed la Eternulo diris al Moseo: Vidu, mi faris vin dio por Faraono; kaj via frato Aaron estos via profeto. ");
INSERT INTO epo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Vi parolos ĉion, kion Mi ordonos al vi; kaj via frato Aaron parolos al Faraono, ke li ellasu la Izraelidojn el sia lando. ");
INSERT INTO epo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Sed Mi malmoligos la koron de Faraono, kaj Mi multigos Miajn signojn kaj Miajn miraklojn en la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Kaj Faraono vin ne aŭskultos, kaj Mi metos Mian manon sur Egiptujon, kaj Mi elirigos Mian militistaron, Mian popolon, la Izraelidojn, el la lando Egipta per grandaj juĝoj. ");
INSERT INTO epo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kaj la Egiptoj sciiĝos, ke Mi estas la Eternulo, kiam Mi etendos Mian manon super la Egiptojn kaj elirigos la Izraelidojn el inter ili. ");
INSERT INTO epo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Kaj Moseo kaj Aaron faris, kiel ordonis al ili la Eternulo; tiel ili faris. ");
INSERT INTO epo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moseo havis la aĝon de okdek jaroj, kaj Aaron havis la aĝon de okdek tri jaroj, kiam ili parolis al Faraono. ");
INSERT INTO epo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Se Faraono diros al vi, ke vi faru miraklon, tiam diru al Aaron: Prenu vian bastonon kaj ĵetu ĝin antaŭ Faraonon; ĝi fariĝos serpento. ");
INSERT INTO epo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moseo kaj Aaron venis al Faraono, kaj faris tiel, kiel ordonis la Eternulo. Aaron ĵetis sian bastonon antaŭ Faraonon kaj antaŭ liajn servantojn, kaj ĝi fariĝis serpento. ");
INSERT INTO epo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Tiam ankaŭ Faraono alvokis la saĝulojn kaj sorĉistojn; kaj ankaŭ ili, la Egiptaj sorĉistoj, per siaj sorĉoj faris tiel. ");
INSERT INTO epo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ĉiu el ili ĵetis sian bastonon, kaj ili fariĝis serpentoj; sed la bastono de Aaron englutis iliajn bastonojn. ");
INSERT INTO epo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kaj malmoliĝis la koro de Faraono, kaj li ne aŭskultis ilin, kiel diris la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Tiam la Eternulo diris al Moseo: Obstina estas la koro de Faraono, li ne volas forliberigi la popolon. ");
INSERT INTO epo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Iru al Faraono matene; li eliros al la akvo; stariĝu renkonte al li sur la bordo de la rivero, kaj la bastonon, kiu transformiĝis en serpenton, prenu en vian manon. ");
INSERT INTO epo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kaj diru al li: La Eternulo, Dio de la Hebreoj, sendis min al vi, por diri: Permesu al Mia popolo iri kaj fari al Mi servon en la dezerto; sed jen vi ĝis nun ne obeis. ");
INSERT INTO epo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tiel diris la Eternulo: Per tio vi sciiĝos, ke Mi estas la Eternulo: jen per la bastono, kiu estas en mia mano, mi frapos la akvon, kiu estas en la rivero, kaj ĝi transformiĝos en sangon. ");
INSERT INTO epo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kaj la fiŝoj, kiuj estas en la rivero, mortos, kaj la rivero malbonodoros, kaj la Egiptoj abomenos trinki akvon el la rivero. ");
INSERT INTO epo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kaj la Eternulo diris al Moseo: Diru al Aaron: Prenu vian bastonon, kaj etendu vian manon super la akvojn de la Egiptoj, super iliajn riverojn, super iliajn torentojn kaj super iliajn lagojn kaj super ĉian kolektiĝon de iliaj akvoj, kaj ili fariĝu sango; kaj estu sango en la tuta lando Egipta, en la vazoj lignaj kaj en la vazoj ŝtonaj. ");
INSERT INTO epo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Kaj Moseo kaj Aaron faris tiel, kiel ordonis la Eternulo. Kaj li levis la bastonon, kaj frapis la akvon, kiu estis en la rivero, antaŭ la okuloj de Faraono kaj antaŭ la okuloj de liaj servantoj; kaj la tuta akvo, kiu estis en la rivero, transformiĝis en sangon. ");
INSERT INTO epo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kaj la fiŝoj, kiuj estis en la rivero, mortis, kaj la rivero fariĝis malbonodora, kaj la Egiptoj ne povis trinki akvon el la rivero; kaj estis sango en la tuta lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Sed tiel same faris la sorĉistoj de Egiptujo per siaj sorĉoj. Kaj malmoliĝis la koro de Faraono, kaj li ne aŭskultis ilin, kiel diris la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kaj Faraono turniĝis kaj eniris en sian domon, kaj lia koro ne atentis eĉ tion. ");
INSERT INTO epo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Kaj ĉiuj Egiptoj ekfosis ĉirkaŭ la rivero pro akvo por trinki, ĉar ili ne povis trinki la akvon el la rivero. ");
INSERT INTO epo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pasis sep tagoj, post kiam la Eternulo frapis la riveron. ");
INSERT INTO epo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kaj la Eternulo diris al Moseo: Iru al Faraono, kaj diru al li: Tiel diris la Eternulo: Permesu al Mia popolo iri, por ke ĝi faru servon al Mi. ");
INSERT INTO epo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kaj se vi ne volos permesi tion, jen Mi frapos vian tutan regionon per ranoj; ");
INSERT INTO epo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","kaj eksvarmos la rivero per ranoj, kaj ili elrampos kaj venos en vian domon kaj en vian dormoĉambron kaj sur vian liton kaj en la domojn de viaj servantoj kaj de via popolo kaj en viajn fornojn kaj en viajn pastujojn; ");
INSERT INTO epo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","kaj sur vin kaj sur vian popolon kaj sur ĉiujn viajn servantojn rampos la ranoj. ");
INSERT INTO epo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kaj la Eternulo diris al Moseo: Diru al Aaron: Etendu vian manon kun via bastono super la riverojn, super la torentojn, kaj super la lagojn, kaj elirigu la ranojn sur la landon Egiptan. ");
INSERT INTO epo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kaj Aaron etendis sian manon super la akvojn de Egiptujo, kaj la ranoj eliris kaj kovris la landon Egiptan. ");
INSERT INTO epo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tion saman faris la sorĉistoj per siaj sorĉoj, kaj ili elirigis la ranojn sur la landon Egiptan. ");
INSERT INTO epo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tiam Faraono alvokis Moseon kaj Aaronon, kaj diris: Preĝu al la Eternulo, ke Li forigu la ranojn for de mi kaj de mia popolo; tiam mi forliberigos la popolon, ke ĝi alportu oferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kaj Moseo diris al Faraono: Ordonu al mi, por kiu tempo mi devas preĝi pro vi kaj pro viaj servantoj kaj pro via popolo, ke malaperu la ranoj for de vi kaj el viaj domoj kaj nur en la rivero ili restu. ");
INSERT INTO epo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tiu diris: Por morgaŭ. Kaj li diris: Ĝi estu, kiel vi diris, por ke vi sciu, ke ekzistas neniu tia, kiel la Eternulo, nia Dio. ");
INSERT INTO epo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kaj foriĝos la ranoj for de vi kaj de viaj domoj kaj de viaj servantoj kaj de via popolo; nur en la rivero ili restos. ");
INSERT INTO epo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moseo kaj Aaron eliris for de Faraono, kaj Moseo ekvokis al la Eternulo pri la ranoj, kiujn li venigis sur Faraonon. ");
INSERT INTO epo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Kaj la Eternulo faris laŭ la vortoj de Moseo; kaj mortis la ranoj en la domoj, en la kortoj, kaj sur la kampoj. ");
INSERT INTO epo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kaj oni kunŝovelis ilin en multajn amasojn, kaj la lando malbonodoriĝis. ");
INSERT INTO epo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Sed kiam Faraono vidis, ke fariĝis faciliĝo, li malmoligis sian koron kaj ne aŭskultis ilin, kiel diris la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Tiam la Eternulo diris al Moseo: Diru al Aaron: Etendu vian bastonon, kaj frapu la polvon de la tero, kaj el ĝi fariĝos pikmuŝoj en la tuta lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ili faris tiel: Aaron etendis sian manon kun sia bastono kaj frapis la polvon de la tero, kaj aperis pikmuŝoj sur la homoj kaj la brutoj. La tuta polvo de la tero fariĝis pikmuŝoj en la tuta lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tiel faris la sorĉistoj per siaj sorĉoj, por elirigi pikmuŝojn, sed ili ne povis. Kaj la pikmuŝoj estis sur la homoj kaj sur la brutoj. ");
INSERT INTO epo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tiam la sorĉistoj diris al Faraono: Ĝi estas fingro de Dio. Sed la koro de Faraono restis obstina, kaj li ne aŭskultis ilin, kiel diris la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kaj la Eternulo diris al Moseo: Leviĝu frue matene, kaj stariĝu antaŭ Faraono, kiam li iros al la akvo, kaj diru al li: Tiel diris la Eternulo: Forliberigu Mian popolon, ke ĝi faru servon al Mi. ");
INSERT INTO epo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ĉar se vi ne forliberigos Mian popolon, jen Mi venigos sur vin kaj sur viajn servantojn kaj sur vian popolon kaj en viajn domojn fiinsektojn; kaj pleniĝos de la fiinsektoj la domoj de la Egiptoj, kaj ankaŭ la tero, sur kiu ili estas. ");
INSERT INTO epo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kaj Mi distingos en tiu tago la teron de Goŝen, sur kiu troviĝas Mia popolo, ke tie ne estu fiinsektoj; por ke vi sciiĝu, ke Mi estas la Eternulo meze de la tero. ");
INSERT INTO epo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kaj Mi faros apartigon inter Mia popolo kaj via popolo; morgaŭ okazos tiu signo. ");
INSERT INTO epo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kaj la Eternulo faris tiel, kaj aperis multego da fiinsektoj en la domo de Faraono kaj en la domoj de liaj servantoj kaj en la tuta lando Egipta; difektiĝis la tero kaŭze de la fiinsektoj. ");
INSERT INTO epo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tiam Faraono alvokis Moseon kaj Aaronon, kaj diris: Iru, alportu oferon al via Dio en la lando. ");
INSERT INTO epo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Sed Moseo diris: Ne estas oportune fari tiel; ĉar abomenindaĵo por la Egiptoj estus nia oferado al la Eternulo, nia Dio; se oferadon abomenindan por la Egiptoj ni faros antaŭ iliaj okuloj, ĉu ili tiam nin ne ŝtonmortigos? ");
INSERT INTO epo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Vojon de tri tagoj ni iros en la dezerton, kaj ni faros oferon al la Eternulo, nia Dio, kiel Li diros al ni. ");
INSERT INTO epo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tiam Faraono diris: Mi forliberigos vin, kaj vi faros oferon al la Eternulo, via Dio, en la dezerto; nur ne foriru malproksime; preĝu pro mi. ");
INSERT INTO epo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Kaj Moseo diris: Jen mi foriras de vi, kaj mi preĝos al la Eternulo, ke foriĝu la fiinsektoj for de Faraono, de liaj servantoj, kaj de lia popolo morgaŭ; sed Faraono ne plu trompu, ne forliberigante la popolon, por fari oferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moseo eliris for de Faraono kaj preĝis al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Kaj la Eternulo faris, kiel diris Moseo, kaj forigis la fiinsektojn for de Faraono, de liaj servantoj, kaj de lia popolo; ne restis eĉ unu. ");
INSERT INTO epo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Sed Faraono obstinigis sian koron ankaŭ ĉi tiun fojon, kaj ne forliberigis la popolon. ");
INSERT INTO epo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kaj la Eternulo diris al Moseo: Iru al Faraono, kaj diru al li: Tiel diris la Eternulo, Dio de la Hebreoj: Forliberigu Mian popolon, ke ĝi faru al Mi servon. ");
INSERT INTO epo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ĉar se vi ne volos forliberigi kaj vi plue ilin retenos, ");
INSERT INTO epo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","jen la mano de la Eternulo estos sur viaj brutoj, kiuj estas sur la kampo, sur la ĉevaloj, sur la azenoj, sur la kameloj, sur la bovoj, kaj sur la ŝafoj; estos sur ili tre forta pesto. ");
INSERT INTO epo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kaj la Eternulo faros apartigon inter la brutoj de la Izraelidoj kaj la brutoj de la Egiptoj; kaj el ĉio, kio apartenas al la Izraelidoj, mortos nenio. ");
INSERT INTO epo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Kaj la Eternulo difinis tempon, dirante: Morgaŭ la Eternulo faros tiun aferon en la lando. ");
INSERT INTO epo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kaj la Eternulo faris tion en la sekvanta tago, kaj mortis ĉiuj brutoj de la Egiptoj, sed el la brutoj de la Izraelidoj ne mortis eĉ unu. ");
INSERT INTO epo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraono sendis, kaj oni vidis, ke el la brutoj de la Izraelidoj ne mortis eĉ unu. Sed la koro de Faraono estis obstina, kaj li ne forliberigis la popolon. ");
INSERT INTO epo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Tiam la Eternulo diris al Moseo kaj al Aaron: Prenu al vi plenmanojn da cindro el la forno, kaj Moseo ĵetu ĝin al la ĉielo antaŭ la okuloj de Faraono. ");
INSERT INTO epo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Kaj ĝi fariĝos polvo super la tuta lando Egipta, kaj sur la homoj kaj sur la bestoj fariĝos el ĝi brulumaj abscesoj en la tuta lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kaj ili prenis cindron el la forno kaj stariĝis antaŭ Faraono, kaj Moseo ĵetis ĝin al la ĉielo, kaj aperis brulumaj abscesoj sur la homoj kaj sur la bestoj. ");
INSERT INTO epo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Kaj la sorĉistoj ne povis teni sin antaŭ Moseo pro la abscesoj, ĉar la abscesoj estis sur la sorĉistoj kaj sur ĉiuj Egiptoj. ");
INSERT INTO epo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Sed la Eternulo obstinigis la koron de Faraono, kaj li ne aŭskultis ilin, kiel diris la Eternulo al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tiam la Eternulo diris al Moseo: Leviĝu frue matene kaj stariĝu antaŭ Faraono, kaj diru al li: Tiel diris la Eternulo, Dio de la Hebreoj: Forliberigu Mian popolon, ke ĝi faru al Mi servon. ");
INSERT INTO epo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ĉar ĉi tiun fojon Mi sendos ĉiujn Miajn frapojn en vian koron kaj sur viajn servantojn kaj sur vian popolon, por ke vi sciu, ke ne ekzistas simila al Mi sur la tuta tero. ");
INSERT INTO epo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ĉar nun Mi etendus Mian manon kaj batus vin kaj vian popolon per pesto, kaj vi malaperus de la tero; ");
INSERT INTO epo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","sed nur por tio Mi vin konservis, ke Mi montru sur vi Mian forton, kaj por ke oni rakontu pri Mia nomo sur la tuta tero. ");
INSERT INTO epo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ankoraŭ vi retenas Mian popolon, kaj ne forliberigas ĝin. ");
INSERT INTO epo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Jen morgaŭ en ĉi tiu tempo Mi pluvigos tre grandan hajlon, tian, ke simila al ĝi ne estis en Egiptujo de post la tago de ĝia fondiĝo ĝis nun. ");
INSERT INTO epo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kaj nun sendu, kolektu viajn brutojn, kaj ĉion, kion vi havas sur la kampo; sur ĉiun homon kaj bruton, kiuj troviĝos sur la kampo kaj ne kolektiĝos en la domon, falos la hajlo, kaj ili mortos. ");
INSERT INTO epo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kiu el la servantoj de Faraono timis la vorton de la Eternulo, tiu rapide envenigis siajn sklavojn kaj brutojn en la domojn; ");
INSERT INTO epo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","sed kiu ne atentis la vorton de la Eternulo, tiu lasis siajn sklavojn kaj siajn brutojn sur la kampo. ");
INSERT INTO epo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kaj la Eternulo diris al Moseo: Etendu vian manon al la ĉielo, kaj venos hajlo en la tuta lando Egipta, sur la homojn kaj sur la brutojn kaj sur ĉiujn herbojn de la kampo en la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Kaj Moseo etendis sian bastonon al la ĉielo; kaj la Eternulo aperigis tondrojn kaj hajlon, kaj fajro iris sur la teron, kaj la Eternulo pluvigis hajlon sur la landon Egiptan. ");
INSERT INTO epo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Kaj estis hajlo, kaj fajro ekflamadis meze de la hajlo, en tiel forta grado, ke io simila neniam estis en la tuta lando Egipta de post la tempo, kiam en ĝi aperis popolo. ");
INSERT INTO epo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Kaj la hajlo batdifektis en la tuta lando Egipta ĉion, kio estis sur la kampo; homojn kaj brutojn kaj ĉiun herbon de la kampo batdifektis la hajlo, kaj ĉiujn arbojn de la kampo ĝi rompis. ");
INSERT INTO epo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nur en la lando Goŝen, kie estis la Izraelidoj, ne estis hajlo. ");
INSERT INTO epo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tiam Faraono sendis, kaj alvokis Moseon kaj Aaronon, kaj diris al ili: Mi pekis la nunan fojon; la Eternulo estas la pravulo, mi kaj mia popolo estas la malpravuloj. ");
INSERT INTO epo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Preĝu al la Eternulo, ke ĉesiĝu la tondroj de Dio kaj la hajlo; tiam mi forliberigos vin, kaj vi ne plu restos. ");
INSERT INTO epo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kaj Moseo diris al li: Kiam mi eliros el la urbo, mi etendos miajn manojn al la Eternulo; la tondroj ĉesiĝos kaj la hajlo ne plu estos, por ke vi sciiĝu, ke al la Eternulo apartenas la tero. ");
INSERT INTO epo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Sed mi scias, ke vi kaj viaj servantoj ankoraŭ ne timas Dion, la Eternulon. ");
INSERT INTO epo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","La lino kaj la hordeo estis batdifektitaj, ĉar la hordeo havis spikojn kaj la lino havis burĝonojn; ");
INSERT INTO epo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","sed la tritiko kaj la spelto ne estis batdifektitaj, ĉar ili estis malfrusezonaj. ");
INSERT INTO epo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moseo eliris de Faraono el la urbo kaj etendis siajn manojn al la Eternulo; tiam ĉesiĝis la tondroj kaj la hajlo, kaj pluvo ne plu verŝiĝis sur la teron. ");
INSERT INTO epo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kiam Faraono vidis, ke ĉesiĝis la pluvo kaj la hajlo kaj la tondroj, tiam li plue pekis kaj obstinigis sian koron, li kaj liaj servantoj. ");
INSERT INTO epo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","La koro de Faraono restis obstina, kaj li ne forliberigis la Izraelidojn, kiel diris la Eternulo per Moseo. ");
INSERT INTO epo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kaj la Eternulo diris al Moseo: Iru al Faraono, ĉar Mi obstinigis lian koron kaj la korojn de liaj servantoj, por ke Mi faru ĉi tiujn Miajn signojn inter ili; ");
INSERT INTO epo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kaj por ke vi rakontu al via filo kaj al via nepo, kion Mi plenumis sur la Egiptoj, kaj pri Miaj signoj, kiujn Mi faris inter ili; kaj por ke vi sciu, ke Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moseo kaj Aaron venis al Faraono, kaj diris al li: Tiel diris la Eternulo, Dio de la Hebreoj: Ĝis kiam vi rifuzos humiliĝi antaŭ Mi? forliberigu Mian popolon, ke ĝi faru al Mi servon. ");
INSERT INTO epo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ĉar se vi rifuzos forliberigi Mian popolon, jen Mi venigos morgaŭ akridojn en vian regionon; ");
INSERT INTO epo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","kaj ili kovros la supraĵon de la tero tiel, ke oni ne povos vidi la teron; kaj ili formanĝos ĉion, kio restis ĉe vi savita kontraŭ la hajlo, kaj ili ĉirkaŭmanĝos ĉiujn arbojn, kiuj kreskas ĉe vi sur la kampo; ");
INSERT INTO epo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","kaj ili plenigos viajn domojn kaj la domojn de ĉiuj viaj servantoj kaj la domojn de ĉiuj Egiptoj tiel, kiel ne vidis viaj patroj kaj viaj prapatroj de post la tago, kiam ili aperis sur la tero ĝis la nuna tago. Kaj li turniĝis kaj eliris for de Faraono. ");
INSERT INTO epo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tiam la servantoj de Faraono diris al li: Ĝis kiam tiu homo estos por ni suferilo? forliberigu tiujn homojn, por ke ili faru servon al la Eternulo, ilia Dio; ĉu vi ankoraŭ ne vidas, ke Egiptujo pereas? ");
INSERT INTO epo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kaj oni revenigis denove Moseon kaj Aaronon al Faraono, kaj ĉi tiu diris al ili: Iru, faru servon al la Eternulo, via Dio; sed kiuj estas la irontoj? ");
INSERT INTO epo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Tiam Moseo diris: Kun niaj junuloj kaj maljunuloj ni iros, kun niaj filoj kaj niaj filinoj, kun niaj ŝafoj kaj niaj bovoj ni iros, ĉar ni havas feston de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kaj li diris al ili: Tiel la Eternulo estu kun vi, se mi forliberigos vin kaj viajn infanojn! ĉu vi ne havas ian malbonan intencon? ");
INSERT INTO epo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ne; iru nur la viroj kaj faru servon al la Eternulo, ĉar tion vi petas. Kaj oni elpelis ilin for de Faraono. ");
INSERT INTO epo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tiam la Eternulo diris al Moseo: Etendu vian manon super la landon Egiptan pro la akridoj, ke ili venu sur la landon Egiptan, kaj formanĝu ĉiujn herbojn de la tero, ĉion, kion restigis la hajlo. ");
INSERT INTO epo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kaj Moseo etendis sian bastonon super la landon Egiptan, kaj la Eternulo direktis orientan venton sur la landon dum tiu tuta tago kaj dum la tuta nokto. Kiam fariĝis mateno, la orienta vento alportis la akridojn. ");
INSERT INTO epo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kaj la akridoj venis sur la tutan landon Egiptan kaj sidiĝis en la tuta Egipta regiono en tre granda amaso; antaŭ ili neniam estis akridaro simila al ili, kaj poste neniam estos tia. ");
INSERT INTO epo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kaj ili kovris la tutan supraĵon de la tero, kaj la tero fariĝis malluma; kaj ili formanĝis la tutan herbon de la kampo, kaj ĉiujn arbajn fruktojn, kiujn restigis la hajlo; kaj restis nenia verdaĵo sur la arboj aŭ inter la herboj de la kampo en la tuta lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tiam Faraono rapide alvokis Moseon kaj Aaronon, kaj diris: Mi pekis antaŭ la Eternulo, via Dio, kaj antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sed nun pardonu mian pekon nur ĉi tiun fojon, kaj preĝu al la Eternulo, via Dio, ke Li forigu de mi nur ĉi tiun morton. ");
INSERT INTO epo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kaj li eliris for de Faraono kaj preĝis al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Kaj la Eternulo venigis de la kontraŭa flanko venton okcidentan tre fortan, kaj ĝi levis la akridojn kaj ĵetis ilin en la Ruĝan Maron; ne restis eĉ unu akrido en la tuta Egipta regiono. ");
INSERT INTO epo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Sed la Eternulo obstinigis la koron de Faraono, kaj li ne forliberigis la Izraelidojn. ");
INSERT INTO epo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Tiam la Eternulo diris al Moseo: Etendu vian manon al la ĉielo, kaj fariĝos mallumo en la lando Egipta, palpebla mallumo. ");
INSERT INTO epo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kaj Moseo etendis sian manon al la ĉielo, kaj fariĝis densa mallumo en la tuta lando Egipta dum tri tagoj. ");
INSERT INTO epo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Oni ne vidis unu alian, kaj neniu leviĝis de sia loko dum tri tagoj; sed ĉiuj Izraelidoj havis lumon en siaj loĝejoj. ");
INSERT INTO epo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tiam Faraono alvokis Moseon, kaj diris: Iru, faru servon al la Eternulo; nur viaj ŝafoj kaj viaj bovoj restu; ankaŭ viaj infanoj iru kun vi. ");
INSERT INTO epo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Sed Moseo diris: Vi devas ankaŭ doni en niajn manojn oferojn kaj bruloferojn, kiujn ni alportos al la Eternulo, nia Dio. ");
INSERT INTO epo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ankaŭ niaj brutoj iros kun ni, ne restos eĉ unu hufo; ĉar el ili ni prenos, por fari servon al la Eternulo, nia Dio; kaj ni ne scias, per kio ni devas servi al la Eternulo, ĝis ni venos tien. ");
INSERT INTO epo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kaj la Eternulo obstinigis la koron de Faraono, kaj li ne volis forliberigi ilin. ");
INSERT INTO epo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Kaj Faraono diris al li: Iru for de mi! gardu vin, ke vi ne venu plu antaŭ mian vizaĝon; ĉar en la tago, en kiu vi venos antaŭ mian vizaĝon, vi mortos. ");
INSERT INTO epo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Tiam Moseo diris: Tiel vi diris; mi ne venos do plu antaŭ vian vizaĝon. ");
INSERT INTO epo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kaj la Eternulo diris al Moseo: Ankoraŭ unu punon Mi venigos sur Faraonon kaj sur Egiptujon; post tio li forliberigos vin el ĉi tie; kaj forliberigante, li tute elpelos vin el ĉi tie. ");
INSERT INTO epo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Diru nun al la popolo, ke ili petu ĉiu viro de sia proksimulo kaj ĉiu virino de sia proksimulino vazojn arĝentajn kaj vazojn orajn. ");
INSERT INTO epo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kaj la Eternulo donis al la popolo favoron ĉe la Egiptoj; kaj ankaŭ Moseo estis tre granda homo en la lando Egipta, en la okuloj de la servantoj de Faraono kaj en la okuloj de la popolo. ");
INSERT INTO epo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kaj Moseo diris: Tiel diris la Eternulo: En la mezo de la nokto Mi iros internen de Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Kaj mortos ĉiu unuenaskito en la lando Egipta, de la unuenaskito de Faraono, kiu sidas sur sia trono, ĝis la unuenaskito de la sklavino, kiu sidas malantaŭ la muelejo; kaj ĉiu unuenaskito el la brutoj. ");
INSERT INTO epo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kaj estos granda kriado en la tuta lando Egipta, tia, ke simila al ĝi neniam estis kaj neniam plu estos. ");
INSERT INTO epo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Sed ĉe ĉiuj Izraelidoj ne movos hundo sian langon, nek kontraŭ homon, nek kontraŭ bruton; por ke vi sciu, kiel la Eternulo faras apartigon inter la Egiptoj kaj la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Kaj venos ĉiuj viaj sklavoj al mi kaj terĵetiĝos antaŭ mi, dirante: Eliru vi kaj la tuta popolo, kiu vin sekvas. Post tio mi eliros. Kaj li eliris for de Faraono kun granda kolero. ");
INSERT INTO epo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Kaj la Eternulo diris al Moseo: Faraono vin ne aŭskultos; por ke multiĝu Miaj mirakloj en la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Kaj Moseo kaj Aaron faris ĉiujn tiujn miraklojn antaŭ Faraono; sed la Eternulo obstinigis la koron de Faraono, kaj li ne forliberigis la Izraelidojn el sia lando. ");
INSERT INTO epo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron en la lando Egipta, dirante: ");
INSERT INTO epo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ĉi tiu monato estu por vi komenco de la monatoj; la unua ĝi estu por vi inter la monatoj de la jaro. ");
INSERT INTO epo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Diru al la tuta komunumo de Izrael: En la deka tago de ĉi tiu monato prenu al si ŝafidon ĉiu patro de familio, po unu ŝafido por domo. ");
INSERT INTO epo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kaj se en la domo estas tro malmulte da personoj por tuta ŝafido, tiam li prenu kune kun sia najbaro plej proksima al lia domo; laŭ la nombro de la animoj, laŭ la kvanto de manĝado de ĉiu, ili kalkulu sin por la ŝafido. ");
INSERT INTO epo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","La ŝafido estu sendifekta, virseksa, havanta la aĝon de unu jaro; el la ŝafoj aŭ el la kaproj vi povas preni. ");
INSERT INTO epo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Konservu ĝin ĝis la dek-kvara tago de ĉi tiu monato; kaj la tuta komunumo de Izrael buĉu ĝin en la komenco de vespero. ");
INSERT INTO epo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kaj ili prenu iom el la sango, kaj ŝmiru sur ambaŭ fostoj kaj sur la supra sojlo de la domoj, en kiuj ili ĝin manĝos. ");
INSERT INTO epo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Kaj ili manĝu la viandon en tiu nokto, rostitan sur fajro; kaj macojn kun maldolĉaj herboj ili manĝu. ");
INSERT INTO epo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ne manĝu ĝin duonkrudan, nek kuiritan en akvo, sed nur rostitan sur fajro kun ĝiaj kapo, kruroj, kaj internaĵoj. ");
INSERT INTO epo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ne restigu iom el ĝi ĝis la mateno; kio restos el ĝi ĝis la mateno, tion bruligu per fajro. ");
INSERT INTO epo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Kaj tiele manĝu ĝin; via lumbo estu zonita, viaj ŝuoj sur viaj piedoj, kaj via bastono en via mano; kaj manĝu ĝin rapidante; ĝi estas Pasko de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Kaj Mi trairos la landon Egiptan en tiu nokto, kaj Mi batos ĉiun unuenaskiton en la lando Egipta, de la homoj ĝis la brutoj; kaj super ĉiuj dioj de Egiptujo Mi faros juĝon, Mi, la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Kaj la sango ĉe vi estos signo sur la domoj, en kiuj vi troviĝas; kiam Mi vidos la sangon, Mi pasos preter vi, kaj ne estos inter vi la eksterma puno, kiam Mi batos la landon Egiptan. ");
INSERT INTO epo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Kaj tiu tago estu por vi memoraĵo; kaj festu ĝin kiel feston de la Eternulo en viaj generacioj, kiel leĝon por eterne festu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Dum sep tagoj manĝu macojn; en la unua tago forigu la fermentaĵon el viaj domoj; ĉiu kiu manĝos fermentaĵon de la unua tago ĝis la sepa tago, ties animo estos ekstermita el Izrael. ");
INSERT INTO epo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Kaj en la unua tago faru al vi sanktan kunvenon, kaj en la sepa tago faru al vi sanktan kunvenon; nenia laboro estu farata en tiuj tagoj; nur kio estas necesa por manĝi por ĉiu, nur tio sola povas esti farata de vi. ");
INSERT INTO epo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kaj observu la ordonon pri la macoj, ĉar ĝuste en tiu tago Mi elkondukis viajn taĉmentojn el la lando Egipta; kaj observu tiun tagon en viaj generacioj kiel leĝon eternan. ");
INSERT INTO epo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","De post la vespero de la dek-kvara tago de la unua monato manĝu macojn ĝis la vespero de la dudek-unua tago de la monato. ");
INSERT INTO epo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dum sep tagoj fermentaĵo ne troviĝu en viaj domoj; ĉar kiu manĝos fermentaĵon, ties animo ekstermiĝos el la komunumo de Izrael, ĉu li estas fremdulo, aŭ ĉu li estas indiĝeno de la lando. ");
INSERT INTO epo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nenion fermentintan manĝu; en ĉiuj viaj loĝlokoj manĝu macojn. ");
INSERT INTO epo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moseo alvokis ĉiujn ĉefojn de Izrael, kaj diris al ili: Elektu kaj prenu al vi ŝafidojn laŭ viaj familioj, kaj buĉu la Paskon. ");
INSERT INTO epo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kaj prenu faskon da hisopo, kaj trempu ĝin en la sango, kiu estos en la pelvo, kaj tuŝu la supran sojlon kaj ambaŭ fostojn per la sango, kiu estos en la pelvo; kaj neniu el vi eliru el la pordo de sia domo ĝis la mateno. ");
INSERT INTO epo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kaj la Eternulo trairos, por puni la Egiptojn; kiam Li vidos la sangon sur la supra sojlo kaj ambaŭ fostoj, tiam la Eternulo preterpasos la pordon kaj ne permesos al la ekstermanto veni en viajn domojn por puni. ");
INSERT INTO epo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kaj observu ĉi tion kiel leĝon por vi kaj por viaj filoj eterne. ");
INSERT INTO epo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kaj kiam vi venos en la landon, kiun la Eternulo donos al vi, kiel Li diris, observu ĉi tiun servon. ");
INSERT INTO epo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kaj kiam diros al vi viaj filoj: Kion signifas ĉi tiu via servo? ");
INSERT INTO epo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","tiam diru: Ĝi estas ofero de Pasko al la Eternulo, kiu preterpasis la domojn de la Izraelidoj en Egiptujo, kiam Li punis la Egiptojn, sed niajn domojn savis. Kaj la popolo kliniĝis kaj faris adoron. ");
INSERT INTO epo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kaj la Izraelidoj iris, kaj faris, kiel ordonis la Eternulo al Moseo kaj Aaron; tiel ili faris. ");
INSERT INTO epo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kiam venis la noktomezo, la Eternulo batis ĉiujn unuenaskitojn en la lando Egipta, de la unuenaskito de Faraono, sidanta sur sia trono, ĝis la unuenaskito de malliberulo, sidanta en malliberejo; kaj ĉiujn unuenaskitojn el la brutoj. ");
INSERT INTO epo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tiam Faraono leviĝis en la nokto, li kaj ĉiuj liaj servantoj kaj ĉiuj Egiptoj; kaj fariĝis granda kriado en Egiptujo; ĉar ne estis domo, en kiu ne estis mortinto. ");
INSERT INTO epo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Kaj li alvokis Moseon kaj Aaronon en la nokto, kaj diris: Leviĝu, foriru el inter mia popolo, vi kaj la Izraelidoj; kaj iru, faru servon al la Eternulo, kiel vi diris. ");
INSERT INTO epo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ankaŭ viajn ŝafojn kaj viajn bovojn prenu, kiel vi diris, kaj iru; kaj benu ankaŭ min. ");
INSERT INTO epo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Kaj la Egiptoj urĝis sur la popolon, por pli rapide elirigi ilin el la lando; ĉar ili diris: Ni ĉiuj mortos. ");
INSERT INTO epo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kaj la popolo forportis sian paston, antaŭ ol ĝi fermentis; iliaj pastujoj, ligitaj en iliaj vestoj, estis sur iliaj ŝultroj. ");
INSERT INTO epo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Kaj la Izraelidoj faris, kiel diris Moseo; kaj ili petis de la Egiptoj vazojn arĝentajn kaj vazojn orajn kaj vestojn. ");
INSERT INTO epo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Kaj la Eternulo favorigis al la popolo la Egiptojn, kaj ĉi tiuj pruntedonis al ili; kaj ili multe prenis de la Egiptoj. ");
INSERT INTO epo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Kaj la Izraelidoj ekiris el Rameses al Sukot, en la nombro de ĉirkaŭ sescent mil piedirantaj viroj, krom la infanoj. ");
INSERT INTO epo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Kaj ankaŭ granda amaso da diversgentaj homoj eliris kun ili, kaj da ŝafoj kaj bovoj tre granda brutaro. ");
INSERT INTO epo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kaj el la pasto, kiun ili elportis el Egiptujo, ili bakis macajn platpanojn, ĉar ĝi ankoraŭ ne fermentis; ĉar ili estis elpelitaj el Egiptujo kaj ne povis prokrasti, kaj ili eĉ ne pretigis al si manĝaĵon. ");
INSERT INTO epo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","La daŭro de la tempo, kiun la Izraelidoj loĝis en Egiptujo, estis kvarcent tridek jaroj. ");
INSERT INTO epo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kiam finiĝis kvarcent tridek jaroj, ĝuste en la sama tago, ĉiuj taĉmentoj de la Eternulo eliris el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ĝi estas nokto dediĉata al la Eternulo, ĉar Li elkondukis ilin el la lando Egipta; ĝi estas tiu nokto, kiu estas dediĉata al la Eternulo de ĉiuj Izraelidoj en iliaj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Kaj la Eternulo diris al Moseo kaj Aaron: Ĉi tio estas la leĝo pri la Pasko: neniu fremdulo manĝu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Sed ĉiu sklavo, kiun iu aĉetis per mono, se vi cirkumcidis lin, tiam li povas manĝi ĝin. ");
INSERT INTO epo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pasloĝanto kaj dungito ne manĝu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","En unu domo ĝi estu manĝata; ne elportu el la domo iom el la viando eksteren, kaj oston en ĝi ne rompu. ");
INSERT INTO epo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","La tuta komunumo de Izrael faru ĝin. ");
INSERT INTO epo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kaj se enloĝiĝos ĉe vi aligentulo kaj li volos fari Paskon al la Eternulo, tiam cirkumcidu ĉe li ĉiujn virseksulojn, kaj tiam li povas prepari sin, por fari ĝin, kaj li estos kiel indiĝeno de la lando; sed neniu ne cirkumcidita manĝu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","La sama leĝo estu por la indiĝeno, kaj por la aligentulo, kiu enloĝiĝis inter vi. ");
INSERT INTO epo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Kaj ĉiuj Izraelidoj faris, kiel ordonis la Eternulo al Moseo kaj al Aaron; tiel ili faris. ");
INSERT INTO epo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","En tiu sama tago la Eternulo elkondukis la Izraelidojn el la lando Egipta laŭ iliaj taĉmentoj. ");
INSERT INTO epo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Dediĉu al Mi ĉiun unuenaskiton, kiu malfermas ĉiun uteron inter la Izraelidoj, el la homo kaj el la brutoj: al Mi li apartenas. ");
INSERT INTO epo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kaj Moseo diris al la popolo: Memoru ĉi tiun tagon, en kiu vi eliris el Egiptujo, el la domo de sklaveco; ĉar per forta mano la Eternulo elkondukis vin el tie; kaj ne manĝu fermentaĵon. ");
INSERT INTO epo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hodiaŭ vi eliras, en la monato Abib. ");
INSERT INTO epo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Kaj kiam la Eternulo venigos vin en la landon de la Kanaanidoj kaj la Ĥetidoj kaj la Amoridoj kaj la Ĥividoj kaj la Jebusidoj, pri kiu Li ĵuris al viaj patroj, ke Li donos al vi, en la landon, en kiu fluas lakto kaj mielo, tiam servu ĉi tiun servon en ĉi tiu monato. ");
INSERT INTO epo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Dum sep tagoj manĝu macojn, kaj en la sepa tago estu festo de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Macoj estu manĝataj dum la sep tagoj, kaj ne vidiĝu ĉe vi fermentaĵo kaj ne vidiĝu ĉe vi fermentinta pasto, en la tuta regiono, kiu apartenas al vi. ");
INSERT INTO epo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Kaj sciigu al via filo en tiu tago, dirante: Ĝi estas pro tio, kion la Eternulo faris al mi ĉe mia elirado el Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Kaj tio estu ĉe vi kiel signo sur via mano kaj kiel memorigaĵo inter viaj okuloj, por ke la instruo de la Eternulo estu en via buŝo; ĉar per forta mano la Eternulo elkondukis vin el Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Plenumu ĉi tiun leĝon en ĝia tempo en ĉiu jaro. ");
INSERT INTO epo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Kaj kiam la Eternulo venigos vin en la landon de la Kanaanidoj, kiel Li ĵuris al vi kaj al viaj patroj, kaj donos ĝin al vi, ");
INSERT INTO epo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","tiam transdonadu ĉiun utermalferminton al la Eternulo, kaj ĉiun unuenaskiton el la brutoj, virseksulon, al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kaj ĉiun unuenaskiton el la azenoj elaĉetu per ŝafido; kaj se vi ne elaĉetos, tiam rompu al ĝi la kolon; kaj ĉiun homan unuenaskiton inter viaj filoj elaĉetu. ");
INSERT INTO epo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kaj kiam via filo morgaŭ vin demandos, dirante: Kio tio estas? tiam diru al li: Per forta mano la Eternulo elkondukis nin el Egiptujo, el la domo de sklaveco; ");
INSERT INTO epo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","kaj kiam Faraono obstine rifuzis forliberigi nin, tiam la Eternulo mortigis ĉiun unuenaskiton en la lando Egipta, de la unuenaskito de homo ĝis la unuenaskito de bruto; tial mi oferas al la Eternulo ĉiun utermalfermintan virseksulon, kaj ĉiun unuenaskiton el miaj filoj mi elaĉetas. ");
INSERT INTO epo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kaj tio estu kiel signo sur via mano kaj kiel memorigaĵo inter viaj okuloj; ĉar per forta mano la Eternulo elkondukis nin el Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kiam Faraono forliberigis la popolon, Dio ne irigis ilin per la vojo de la lando Filiŝta, kiu estis proksima; ĉar Dio diris: Eble la popolo pentos, kiam ĝi ekvidos militon, kaj ĝi reiros Egiptujon. ");
INSERT INTO epo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kaj Dio kondukis la popolon ĉirkaŭire, per la vojo tra la dezerto, al la Ruĝa Maro. Kaj armitaj la Izraelidoj eliris el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Kaj Moseo prenis kun si la ostojn de Jozef, ĉar tiu ĵurigis la Izraelidojn, dirante: Kiam Dio rememoros vin, tiam elportu miajn ostojn el ĉi tie kun vi. ");
INSERT INTO epo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kaj ili elmoviĝis el Sukot, kaj starigis sian tendaron en Etam, en la fino de la dezerto. ");
INSERT INTO epo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kaj la Eternulo iradis antaŭ ili dum la tago en nuba kolono, por konduki ilin laŭ la ĝusta vojo, kaj dum la nokto en kolono fajra, por lumi al ili, ke ili povu iri tage kaj nokte. ");
INSERT INTO epo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ne foriĝadis de antaŭ la popolo la nuba kolono dum la tago nek la fajra kolono dum la nokto. ");
INSERT INTO epo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Diru al la Izraelidoj, ke ili iru returne, kaj starigu sian tendaron antaŭ Pi-Haĥirot, inter Migdol kaj la maro, apud Baal-Cefon; tie ili stariĝu tendare super la maro. ");
INSERT INTO epo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraono diros pri la Izraelidoj: Ili perdis la vojon en la lando, la dezerto ilin ŝlosis. ");
INSERT INTO epo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kaj Mi obstinigos la koron de Faraono, kaj li kuros post ili; kaj Mi gloriĝos per Faraono kaj per lia tuta militistaro, kaj la Egiptoj sciiĝos, ke Mi estas la Eternulo. Kaj ili faris tiel. ");
INSERT INTO epo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kiam oni diris al la reĝo de Egiptujo, ke la popolo forkuris, tiam la koro de Faraono kaj de liaj servantoj turniĝis kontraŭ la popolon, kaj ili diris: Kion ni faris, forliberiginte la Izraelidojn de servado al ni? ");
INSERT INTO epo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kaj li jungis sian ĉaron kaj prenis kun si sian popolon. ");
INSERT INTO epo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kaj li prenis sescent plej bonajn ĉarojn kaj ĉiujn ĉarojn de Egiptujo kaj la ĉefojn de la tuta militistaro. ");
INSERT INTO epo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Kaj la Eternulo obstinigis la koron de Faraono, la reĝo de Egiptujo, kaj li postkuris la Izraelidojn; sed la Izraelidojn elirigis mano alta. ");
INSERT INTO epo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","La Egiptoj postkuris ilin, kaj ĉiuj ĉevaloj kaj ĉaroj de Faraono kaj liaj rajdantoj kaj lia militistaro atingis ilin, kiam ili staris tendare super la maro, apud Pi-Haĥirot antaŭ Baal-Cefon. ");
INSERT INTO epo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kiam Faraono alproksimiĝis, tiam la Izraelidoj levis siajn okulojn, kaj ekvidis, ke jen la Egiptoj iras post ili; kaj ili tre ektimis, kaj la Izraelidoj ekkriis al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Kaj ili diris al Moseo: Ĉu ne ekzistis tomboj en Egiptujo, ke vi prenis nin, por morti en la dezerto? kion vi faris al ni, elkondukinte nin el Egiptujo? ");
INSERT INTO epo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tion ni diris ja al vi en Egiptujo: Lasu nin, kaj ni servu la Egiptojn; ĉar pli bone estus por ni servi la Egiptojn, ol morti en la dezerto. ");
INSERT INTO epo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tiam Moseo diris al la popolo: Ne timu; staru, kaj vidu la savon de la Eternulo, kiun Li faros al vi hodiaŭ; ĉar la Egiptojn, kiujn vi vidas hodiaŭ, vi eterne neniam plu vidos. ");
INSERT INTO epo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","La Eternulo militos por vi, kaj vi silentu. ");
INSERT INTO epo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kaj la Eternulo diris al Moseo: Kion vi krias al Mi? diru al la Izraelidoj, ke ili ekiru. ");
INSERT INTO epo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Kaj vi levu vian bastonon kaj etendu vian manon super la maron kaj disfendu ĝin, por ke la Izraelidoj iru tra la mezo de la maro sur seka tero. ");
INSERT INTO epo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kaj jen, Mi obstinigos la korojn de la Egiptoj, kaj ili iros post vi; kaj Mi gloriĝos per Faraono kaj per lia tuta militistaro, per liaj ĉaroj kaj liaj rajdantoj. ");
INSERT INTO epo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kaj la Egiptoj sciiĝos, ke Mi estas la Eternulo, kiam Mi gloriĝos per Faraono, per liaj ĉaroj kaj liaj rajdantoj. ");
INSERT INTO epo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kaj la Dia anĝelo, kiu iradis antaŭ la tendaro de la Izraelidoj, formoviĝis kaj ekiris post ili; kaj la nuba kolono formoviĝis de antaŭ ili kaj stariĝis post ili; ");
INSERT INTO epo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","kaj ĝi aperis inter la tendaro de la Egiptoj kaj la tendaro de la Izraelidoj, kaj ĝi estis nubo malluma, kaj lumis dum la nokto tiamaniere, ke unuj al la aliaj ne povis alproksimiĝi dum la tuta nokto. ");
INSERT INTO epo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kaj Moseo etendis sian manon super la maron; kaj la Eternulo pelis la maron per forta orienta vento dum la tuta nokto kaj faris la maron seka tero; kaj la akvo disfendiĝis. ");
INSERT INTO epo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kaj la Izraelidoj ekiris tra la mezo de la maro sur seka tero, kaj la akvo estis por ili muro dekstre kaj maldekstre. ");
INSERT INTO epo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Kaj la Egiptoj postkuris kaj venis post ili, ĉiuj ĉevaloj de Faraono, liaj ĉaroj kaj liaj rajdantoj, en la mezon de la maro. ");
INSERT INTO epo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kiam venis la matena gardotempo, la Eternulo ekrigardis la tendaron de la Egiptoj el la fajra kaj nuba kolono, kaj Li tumultigis la tendaron de la Egiptoj. ");
INSERT INTO epo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kaj Li depuŝis la radojn de iliaj ĉaroj kaj malrapidigis ilian iradon. Tiam la Egiptoj diris: Ni forkuru for de la Izraelidoj, ĉar la Eternulo militas por ili kontraŭ la Egiptoj. ");
INSERT INTO epo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kaj la Eternulo diris al Moseo: Etendu vian manon super la maron, por ke la akvo revenu sur la Egiptojn, sur iliajn ĉarojn kaj iliajn rajdantojn. ");
INSERT INTO epo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kaj Moseo etendis sian manon super la maron, kaj la maro revenis en la komenco de la mateno, sur sian lokon, kaj la Egiptoj kuris renkonte al ĝi. Kaj la Eternulo ĵetis la Egiptojn en la mezon de la maro. ");
INSERT INTO epo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kaj la akvo revenis, kaj kovris la ĉarojn kaj la rajdantojn de la tuta militistaro de Faraono, kiu venis post ili en la maron; ne restis el ili eĉ unu. ");
INSERT INTO epo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Sed la Izraelidoj iris sur seka tero tra la mezo de la maro, kaj la akvo estis por ili muro dekstre kaj maldekstre. ");
INSERT INTO epo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Kaj la Eternulo savis en tiu tago la Izraelidojn el la mano de la Egiptoj; kaj la Izraelidoj vidis la Egiptojn mortintaj sur la bordo de la maro. ");
INSERT INTO epo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kaj la Izraelidoj vidis la grandan manon, kiun la Eternulo aperigis sur la Egiptoj, kaj la popolo ektimis la Eternulon kaj ekkredis al la Eternulo kaj al Lia sklavo Moseo. ");
INSERT INTO epo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tiam Moseo kaj la Izraelidoj kantis ĉi tiun kanton al la Eternulo, kaj parolis jene: Mi kantos al la Eternulo, ĉar Li alte leviĝis; Ĉevalon kaj ĝian rajdanton Li ĵetis en la maron. ");
INSERT INTO epo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mia forto kaj glorkanto estas la Eternulo, Kaj Li estis por mi savo. Li estas mia Dio, kaj mi Lin gloros, La Dio de mia patro, kaj mi Lin altigos. ");
INSERT INTO epo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","La Eternulo estas viro de milito, Eternulo estas Lia nomo. ");
INSERT INTO epo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","La ĉarojn de Faraono kaj lian militistaron Li ĵetis en la maron; Kaj liaj elektitaj militestroj dronis en la Ruĝa Maro. ");
INSERT INTO epo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Abismoj ilin kovris; Ili falis en la profundojn kiel ŝtono. ");
INSERT INTO epo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Via dekstra mano, ho Eternulo, estas glora per forto, Via dekstra mano, ho Eternulo, disbatas malamikon. ");
INSERT INTO epo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Per Via granda majesto Vi frakasas Viajn kontraŭulojn; Vi sendas Vian koleron, kaj ĝi forbruligas ilin kiel pajlon. ");
INSERT INTO epo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","De Via kolera blovo montiĝis akvo, Amasigite stariĝis fluaĵo, Densiĝis abismoj en la mezo de la maro. ");
INSERT INTO epo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","La malamiko diris: Mi persekutos, Mi atingos, mi dividos militakiron; Satiĝos de ili mia animo; Mi eltiros mian glavon, ekstermos ilin mia mano. ");
INSERT INTO epo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Vi blovis per Via spirito, kaj ilin kovris la maro; Kiel plumbo ili iris al fundo en la akvo potenca. ");
INSERT INTO epo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kiu estas kiel Vi inter la dioj, ho Eternulo? Kiu estas kiel Vi, majesta en sankteco, Timinda kaj laŭdinda, faranta miraklojn? ");
INSERT INTO epo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Vi etendis Vian dekstran manon, Kaj ilin englutis la tero. ");
INSERT INTO epo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Vi kondukis kun Via favorkoreco tiun popolon, kiun Vi liberigis; Vi kondukis ĝin per Via forto al Via sankta loĝejo. ");
INSERT INTO epo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Aŭdis popoloj kaj ektremis; Teruro atakis la loĝantojn de Filiŝtujo. ");
INSERT INTO epo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tiam ektimis la ĉefoj de Edom; La potenculojn de Moab atakis tremo; Perdis la kuraĝon ĉiuj loĝantoj de Kanaan. ");
INSERT INTO epo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Falas sur ilin timo kaj teruro pro la grandeco de Via brako; Ili mutiĝas kiel ŝtono, ĝis pasas Via popolo, ho Eternulo, Ĝis pasas la popolo, kiun Vi akiris. ");
INSERT INTO epo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Vi venigos ilin, kaj plantos ilin Sur la monto de Via heredo, Sur la loko, ho Eternulo, kiun Vi faris Via sidejo, En la sanktejo, ho Sinjoro, kiun pretigis Viaj manoj. ");
INSERT INTO epo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","La Eternulo reĝos ĉiam kaj eterne. ");
INSERT INTO epo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ĉar la ĉevaloj de Faraono kun liaj ĉaroj kaj rajdantoj eniĝis en la maron, kaj la Eternulo turnis sur ilin la akvon de la maro; sed la Izraelidoj iris sur seka tero tra la mezo de la maro. ");
INSERT INTO epo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mirjam, la profetino, fratino de Aaron, prenis tamburinon en sian manon, kaj ĉiuj virinoj eliris post ŝi kun tamburinoj kaj dancante. ");
INSERT INTO epo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Kaj Mirjam antaŭkantis al ili: Kantu al la Eternulo, ĉar Li alte leviĝis; Ĉevalon kaj ĝian rajdanton Li ĵetis en la maron. ");
INSERT INTO epo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moseo ekkondukis la Izraelidojn for de la Ruĝa Maro, kaj ili eliris al la dezerto Ŝur; ili iris dum tri tagoj tra la dezerto kaj ne trovis akvon. ");
INSERT INTO epo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ili venis al Mara, sed ili ne povis trinki la akvon en Mara, ĉar ĝi estis maldolĉa; tial oni donis al la loko la nomon Mara. ");
INSERT INTO epo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kaj la popolo ekmurmuris kontraŭ Moseo, dirante: Kiam ni trinkos? ");
INSERT INTO epo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tiam li kriis al la Eternulo, kaj la Eternulo montris al li arbon, kaj li ĵetis ĝin en la akvon, kaj la akvo fariĝis dolĉa. Tie Li donis al ili leĝon kaj juĝon, kaj tie Li ilin elprovis. ");
INSERT INTO epo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kaj Li diris: Se vi aŭskultados la voĉon de la Eternulo, via Dio, kaj farados tion, kio plaĉas al Li, kaj vi atentados Liajn ordonojn kaj observados ĉiujn Liajn leĝojn, tiam Mi venigos sur vin neniun el tiuj malsanoj, kiujn Mi venigis sur la Egiptojn; ĉar Mi estas la Eternulo, via saniganto. ");
INSERT INTO epo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kaj ili venis al Elim; tie estis dek du fontoj de akvo, kaj sepdek daktilpalmoj. Kaj ili starigis tie sian tendaron ĉe la akvo. ");
INSERT INTO epo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ili elmoviĝis el Elim, kaj la tuta komunumo de la Izraelidoj venis en la dezerton Sin, kiu troviĝas inter Elim kaj Sinaj, en la dek-kvina tago de la dua monato, post sia eliro el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kaj la tuta komunumo de la Izraelidoj ekmurmuris kontraŭ Moseo kaj Aaron en la dezerto. ");
INSERT INTO epo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kaj la Izraelidoj diris al ili: Ho, ni dezirus morti per la mano de la Eternulo en la lando Egipta, sidante super la potoj kun viando, manĝante panon ĝissate! vi elkondukis nin en ĉi tiun dezerton, por mortigi ĉi tiun tutan komunumon per malsato. ");
INSERT INTO epo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tiam la Eternulo diris al Moseo: Jen Mi pluvigos por vi panon el la ĉielo; kaj la popolo eliru kaj kolektu ĉiutage tiom, kiom ĝi bezonas por la tago, por ke Mi esploru ĝin, ĉu ĝi sekvos Mian leĝon aŭ ne. ");
INSERT INTO epo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Sed en la sesa tago ili preparu tion, kion ili devas enporti, kaj tiam estos duobla porcio kompare kun tio, kion ili kolektas ĉiutage. ");
INSERT INTO epo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kaj Moseo kaj Aaron diris al ĉiuj Izraelidoj: Vespere vi sciiĝos, ke la Eternulo elkondukis vin el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Kaj matene vi vidos la gloron de la Eternulo; ĉar Li aŭdis vian murmuradon kontraŭ la Eternulo. Sed kio estas ni, ke vi murmuras kontraŭ ni? ");
INSERT INTO epo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kaj Moseo diris: La Eternulo donos al vi vespere viandon por manĝi kaj matene panon por satiĝi; ĉar la Eternulo aŭdis vian murmuradon, kiun vi murmuris kontraŭ Li. Sed ni, kio ni estas? ne kontraŭ ni estas via murmurado, sed kontraŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kaj Moseo diris al Aaron: Diru al la tuta komunumo de la Izraelidoj: Alproksimiĝu antaŭ la Eternulon, ĉar Li aŭdis vian murmuradon. ");
INSERT INTO epo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kaj dum Aaron estis parolanta al la tuta komunumo de la Izraelidoj, ili turniĝis al la dezerto, kaj jen la gloro de la Eternulo aperis en nubo. ");
INSERT INTO epo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Kaj la Eternulo parolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Mi aŭdis la murmuradon de la Izraelidoj; diru al ili jenon: En la komenco de la vespero vi manĝos viandon, kaj matene vi satiĝos per pano, kaj vi sciiĝos, ke Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kiam venis la vespero, alflugis koturnoj kaj kovris la tendaron, kaj matene estis tavolo da roso ĉirkaŭ la tendaro. ");
INSERT INTO epo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Kiam la tavolo da roso forleviĝis, tiam montriĝis, ke sur la supraĵo de la dezerto kuŝas io delikata, senŝela, delikata kiel prujno sur la tero. ");
INSERT INTO epo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kiam la Izraelidoj ekvidis, ili diris unuj al la aliaj: Kio ĝi estas? ĉar ili ne sciis, kio ĝi estas. Kaj Moseo diris al ili: Ĝi estas la pano, kiun la Eternulo donis al vi por manĝi. ");
INSERT INTO epo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Jen estas tio, kion ordonis la Eternulo: Kolektu ĝin ĉiu en tia kvanto, kiom li bezonas por manĝi; prenu po unu omero por ĉiu kapo, laŭ la nombro de viaj animoj, kiujn ĉiu havas en sia tendo. ");
INSERT INTO epo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Kaj tiel faris la Izraelidoj, kaj ili kolektis, unu pli, alia malpli. ");
INSERT INTO epo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kaj oni mezuris per omero; kaj kiu kolektis pli, ne havis superflue, kaj kiu kolektis malpli, ne havis mankon; ĉiu kolektis tiom, kiom li povis manĝi. ");
INSERT INTO epo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kaj Moseo diris al ili: Neniu restigu iom el ĝi ĝis la mateno. ");
INSERT INTO epo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Sed ili ne obeis Moseon, kaj kelkaj restigis iom el ĝi ĝis la mateno; kaj aperis en ĝi vermoj, kaj ĝi malbonodoriĝis; kaj Moseo ekkoleris ilin. ");
INSERT INTO epo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ili kolektadis ĝin ĉiumatene, ĉiu tiom, kiom li bezonis por manĝi; kaj kiam la suno fariĝis pli varma, tio fandiĝadis. ");
INSERT INTO epo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kiam venis la sesa tago, ili kolektis duoble da pano, po du omeroj por ĉiu; kaj ĉiuj ĉefoj de la komunumo venis kaj diris tion al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kaj li diris al ili: Jen estas, kion diris la Eternulo: ripozo de sankta sabato de la Eternulo estas morgaŭ; kion vi estas bakontaj, baku, kaj kion vi estas kuirontaj, kuiru; sed ĉion superfluan formetu, por ke ĝi estu konservata ĝis la mateno. ");
INSERT INTO epo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kaj ili formetis ĝin ĝis la mateno, kiel ordonis Moseo, kaj ĝi ne malbonodoriĝis, kaj vermoj ne aperis en ĝi. ");
INSERT INTO epo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kaj Moseo diris: Manĝu ĝin hodiaŭ, ĉar hodiaŭ estas sabato de la Eternulo; hodiaŭ vi ne trovos ĝin sur la kampo. ");
INSERT INTO epo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Dum ses tagoj kolektu ĝin, sed la sepa tago estas sabato, en tiu tago ĝi ne troviĝos. ");
INSERT INTO epo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","En la sepa tago eliris kelkaj el la popolo, por kolekti, sed ili ne trovis. ");
INSERT INTO epo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kaj la Eternulo diris al Moseo: Ĝis kiam vi rifuzos observi Miajn ordonojn kaj Mian instruon? ");
INSERT INTO epo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Rigardu, la Eternulo donis al vi la sabaton, tial Li donas al vi en la sesa tago panon por du tagoj; restu ĉiu hejme, neniu eliru for de sia loko en la sepa tago. ");
INSERT INTO epo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kaj la popolo ripozis en la sepa tago. ");
INSERT INTO epo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Kaj la domo de Izrael donis al ĝi la nomon manao; ĝi estis kiel la semo de koriandro, blanka, kaj ĝia gusto estis kiel blankpaneto kun mielo. ");
INSERT INTO epo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kaj Moseo diris: Jen estas tio, kion ordonis la Eternulo: Plenigu per ĝi omeron, ke ĝi estu konservata en viaj generacioj, por ke oni vidu la panon, kiun Mi manĝigis al vi en la dezerto, kiam Mi elkondukis vin el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kaj Moseo diris al Aaron: Prenu unu vazon kaj enmetu tien plenan omeron da manao kaj starigu ĝin antaŭ la Eternulo, por ke ĝi estu konservata en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kiel la Eternulo ordonis al Moseo, Aaron starigis ĝin antaŭ la Atesto, por konserviĝi. ");
INSERT INTO epo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Kaj la Izraelidoj manĝis la manaon dum kvardek jaroj, ĝis ili venis en landon loĝeblan; la manaon ili manĝis, ĝis ili venis al la limo de la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Kaj omero estas dekono de efo. ");
INSERT INTO epo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","La tuta komunumo de la Izraelidoj elmoviĝis el la dezerto Sin laŭ siaj tagvojoj, kiel ordonis la Eternulo; kaj ili starigis sian tendaron en Refidim, kaj la popolo ne havis akvon por trinki. ");
INSERT INTO epo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kaj la popolo malpacis kontraŭ Moseo, kaj ili diris: Donu al ni akvon por trinki. Kaj Moseo diris al ili: Kial vi malpacas kontraŭ mi? kial vi provas la Eternulon? ");
INSERT INTO epo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Sed la popolo tie suferis pro manko de akvo, kaj la popolo murmuris kontraŭ Moseo, kaj diris: Kial vi elkondukis nin el Egiptujo, por mortigi nin kaj niajn infanojn kaj niajn brutojn per soifo? ");
INSERT INTO epo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tiam Moseo kriis al la Eternulo, dirante: Kion mi faros kun ĉi tiu popolo? baldaŭ povas okazi, ke ili min ŝtonmortigos. ");
INSERT INTO epo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kaj la Eternulo diris al Moseo: Preteriru antaŭ la popolo, kaj prenu kun vi kelkajn el la ĉefoj de Izrael, kaj vian bastonon, per kiu vi frapis la riveron, prenu en vian manon, kaj iru. ");
INSERT INTO epo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Jen Mi staros antaŭ vi tie super roko sur Ĥoreb; kaj vi frapos la rokon, kaj eliros el ĝi akvo, kaj la popolo trinkos. Kaj Moseo faris tiel antaŭ la okuloj de la ĉefoj de Izrael. ");
INSERT INTO epo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kaj li donis al tiu loko la nomon Masa kaj Meriba, pro la malpaco de la Izraelidoj, kaj pro tio, ke ili provis la Eternulon, dirante: Ĉu la Eternulo estas inter ni, aŭ ne? ");
INSERT INTO epo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Venis la Amalekidoj, kaj ekmilitis kontraŭ la Izraelidoj en Refidim. ");
INSERT INTO epo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tiam Moseo diris al Josuo: Elektu al ni virojn, kaj eliru, batalu kontraŭ la Amalekidoj. Morgaŭ mi staros sur supro de monteto, kaj la Dian bastonon mi havos en mia mano. ");
INSERT INTO epo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kaj Josuo faris, kiel diris al li Moseo, kaj batalis kontraŭ la Amalekidoj; kaj Moseo, Aaron, kaj Ĥur supreniris sur la supron de la monteto. ");
INSERT INTO epo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kaj ĉiufoje, kiam Moseo levis sian manon, venkis Izrael; kaj kiam li mallevis sian manon, venkis Amalek. ");
INSERT INTO epo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Sed la manoj de Moseo estis pezaj; tial ili prenis ŝtonon kaj metis ĝin sub lin, kaj li sidiĝis sur ĝi; kaj Aaron kaj Ĥur subtenis liajn manojn, unu de unu flanko, la dua de la dua flanko; kaj liaj manoj estis en ĝusta teniĝo ĝis la subiro de la suno. ");
INSERT INTO epo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kaj Josuo senfortigis Amalekon kaj lian popolon per la glavo. ");
INSERT INTO epo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kaj la Eternulo diris al Moseo: Skribu ĉi tion por memoro en libron kaj enmetu ĉi tion en la orelojn de Josuo, ke Mi ekstermos la memoron pri Amalek sub la ĉielo. ");
INSERT INTO epo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moseo konstruis altaron, kaj donis al ĝi la nomon: La Eternulo mia Standardo. ");
INSERT INTO epo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ĉar li diris: Estas promesite per la altaro de la Eternulo, ke la Eternulo militos kontraŭ Amalek de generacio al generacio. ");
INSERT INTO epo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jitro, la Midjana pastro, la bopatro de Moseo, aŭdis ĉion, kion la Eternulo faris al Moseo kaj al Sia popolo Izrael, ke la Eternulo elkondukis Izraelon el Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kaj Jitro, la bopatro de Moseo, prenis Ciporan, la edzinon de Moseo, kiun tiu forlasis; ");
INSERT INTO epo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","kaj ŝiajn du filojn, el kiuj unu havis la nomon Gerŝom; ĉar la patro diris: Mi estis fremdulo en fremda lando; ");
INSERT INTO epo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","kaj la dua havis la nomon Eliezer, ĉar tiu diris: La Dio de mia patro helpis min, kaj savis min kontraŭ la glavo de Faraono. ");
INSERT INTO epo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Kaj Jitro, la bopatro de Moseo, kun liaj filoj kaj lia edzino venis al Moseo en la dezerton, kie li staris tendare ĉe la monto de Dio. ");
INSERT INTO epo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kaj li dirigis al Moseo: Mi, via bopatro Jitro, venas al vi, kaj ankaŭ via edzino kaj ŝiaj du filoj kun ŝi. ");
INSERT INTO epo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Tiam Moseo eliris renkonte al sia bopatro kaj profunde salutis lin kaj kisis lin, kaj ili demandis sin reciproke pri la farto kaj eniris en la tendon. ");
INSERT INTO epo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Kaj Moseo rakontis al sia bopatro ĉion, kion la Eternulo faris al Faraono kaj al la Egiptoj pro Izrael, kaj ĉiujn malfacilaĵojn, kiuj trafis ilin dum la vojo kaj el kiuj la Eternulo ilin savis. ");
INSERT INTO epo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jitro ĝojis je la tuta bono, kiun la Eternulo faris al Izrael, savinte lin el la mano de la Egiptoj. ");
INSERT INTO epo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Kaj Jitro diris: Benata estu la Eternulo, kiu savis vin el la manoj de la Egiptoj kaj el la mano de Faraono, kaj kiu savis la popolon el sub la mano de la Egiptoj. ");
INSERT INTO epo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nun mi scias, ke la Eternulo estas pli granda ol ĉiuj dioj; ĝi estas pro tio, ke tiuj malbonintencis kontraŭ ili. ");
INSERT INTO epo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Kaj Jitro, la bopatro de Moseo, alportis al Dio bruloferon kaj buĉoferojn; kaj Aaron kaj ĉiuj ĉefoj de Izrael venis, por manĝi panon kun la bopatro de Moseo antaŭ Dio. ");
INSERT INTO epo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","La sekvantan tagon Moseo sidiĝis, por juĝi la popolon; kaj la popolo staris antaŭ Moseo de la mateno ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kaj la bopatro de Moseo vidis ĉion, kion li faras por la popolo, kaj diris: Kio estas tio, kion vi faras al la popolo? kial vi sola sidas kaj la tuta popolo staras antaŭ vi de mateno ĝis vespero? ");
INSERT INTO epo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Tiam Moseo diris al sia bopatro: La popolo venas al mi, por demandi Dion. ");
INSERT INTO epo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kiam fariĝas inter ili ia afero, ili venas al mi; kaj mi juĝas inter unu kaj alia, kaj mi sciigas la leĝojn de Dio kaj Liajn instruojn. ");
INSERT INTO epo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Sed la bopatro de Moseo diris al li: Ne bona estas la afero, kiun vi faras. ");
INSERT INTO epo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Senfortiĝos vi kaj ĉi tiu popolo, kiu estas kun vi; ĉar la afero estas tro malfacila por vi; vi ne povas plenumi ĝin sola. ");
INSERT INTO epo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Aŭskultu mian voĉon, mi donos al vi konsilon, kaj Dio estos kun vi. Vi estu por la popolo perulo antaŭ Dio, kaj prezentu la aferojn al Dio. ");
INSERT INTO epo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Instruu al ili la leĝojn kaj instruojn, kaj montru al ili la vojon, kiun ili devas iri, kaj la farojn, kiujn ili devas fari. ");
INSERT INTO epo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kaj vi elserĉu inter la tuta popolo homojn bravajn, timantajn Dion, homojn veramajn, neprofitamajn; kaj starigu ilin super la popolo kiel milestrojn, centestrojn, kvindekestrojn, kaj dekestrojn. ");
INSERT INTO epo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Kaj ili juĝadu la popolon en ĉiu tempo; ĉiun grandan aferon ili venigu al vi, sed ĉiun malgrandan aferon juĝu ili; tiel fariĝos pli facile al vi, kaj ili portos kun vi. ");
INSERT INTO epo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Se vi tion faros kaj Dio al vi ordonos, tiam vi povos resti forta, kaj ankaŭ ĉi tiu tuta popolo venos al sia loko en paco. ");
INSERT INTO epo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moseo obeis la voĉon de sia bopatro, kaj faris ĉion, kion tiu diris. ");
INSERT INTO epo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Kaj Moseo elektis bravajn homojn inter la tuta Izrael, kaj faris ilin estroj super la popolo, milestroj, centestroj, kvindekestroj, kaj dekestroj. ");
INSERT INTO epo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Kaj ili juĝadis la popolon en ĉiu tempo; malfacilan aferon ili venigadis al Moseo, kaj ĉiun aferon malgrandan juĝadis ili. ");
INSERT INTO epo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kaj Moseo lasis sian bopatron foriri, kaj tiu iris en sian landon. ");
INSERT INTO epo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","En la tria monato post la eliro de la Izraelidoj el la lando Egipta, en tiu tago ili venis en la dezerton Sinaj. ");
INSERT INTO epo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ili eliris el Refidim, kaj venis en la dezerton Sinaj kaj starigis sian tendaron en la dezerto; kaj Izrael stariĝis tie tendare antaŭ la monto. ");
INSERT INTO epo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kaj Moseo supreniris al Dio; kaj la Eternulo vokis al li de la monto, dirante: Tiel diru al la domo de Jakob kaj sciigu al la filoj de Izrael: ");
INSERT INTO epo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vi vidis, kion Mi faris al la Egiptoj kaj kiel Mi portis vin sur aglaj flugiloj kaj venigis vin al Mi. ");
INSERT INTO epo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kaj nun se vi obeos Mian voĉon kaj observos Mian interligon, vi estos Mia amata propraĵo inter ĉiuj popoloj, ĉar al Mi apartenas la tuta tero. ");
INSERT INTO epo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kaj vi estos por Mi regno de pastroj kaj popolo sankta. Tio estas la vortoj, kiujn vi diru al la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moseo venis, kaj alvokis la ĉefojn de la popolo, kaj prezentis al ili ĉiujn tiujn vortojn, pri kiuj la Eternulo ordonis al li. ");
INSERT INTO epo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Kaj la tuta popolo respondis kune kaj diris: Ĉion, kion la Eternulo diris, ni faros. Kaj Moseo raportis la vortojn de la popolo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Kaj la Eternulo diris al Moseo: Jen Mi venos al vi en densa nubo, por ke la popolo aŭdu, kiam Mi parolos kun vi, kaj por ke ili kredu al vi eterne. Kaj Moseo sciigis la vortojn de la popolo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kaj la Eternulo diris al Moseo: Iru al la popolo kaj sanktigu ĝin hodiaŭ kaj morgaŭ, kaj ili lavu siajn vestojn. ");
INSERT INTO epo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kaj ili estu pretaj por la tria tago, ĉar en la tria tago la Eternulo malsupreniros antaŭ la okuloj de la tuta popolo sur la monton Sinaj. ");
INSERT INTO epo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kaj difinu limon por la popolo ĉirkaŭe, dirante: Gardu vin, ke vi ne supreniru sur la monton nek tuŝu ĝian bazon; ĉiu, kiu tuŝos la monton, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mano lin ne tuŝu, sed per ŝtonoj li estu mortigita, aŭ li estu pafmortigita; ĉu tio estos bruto, ĉu tio estos homo, li ne vivu. Kiam eksonos longa trumpetado, tiam ili povas supreniri sur la monton. ");
INSERT INTO epo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kaj Moseo malsupreniris de la monto al la popolo kaj sanktigis la popolon, kaj ili lavis siajn vestojn. ");
INSERT INTO epo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kaj li diris al la popolo: Estu pretaj por la tria tago; ne alproksimiĝu al virino. ");
INSERT INTO epo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","En la tria tago, tuj matene, komenciĝis tondroj kaj fulmoj, kaj densa nubo estis super la monto, kaj aŭdiĝis tre forta sonado de korno; kaj ektremis la tuta popolo, kiu estis en la tendaro. ");
INSERT INTO epo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kaj Moseo elirigis la popolon el la tendaro renkonte al Dio, kaj ili stariĝis antaŭ la bazo de la monto. ");
INSERT INTO epo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Kaj la monto Sinaj tuta fumiĝis kaŭze de tio, ke la Eternulo malsupreniris sur ĝin en fajro; kaj ĝia fumo leviĝadis kiel fumo el forno, kaj la tuta monto forte tremis. ");
INSERT INTO epo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kaj la sonado de la korno fariĝadis ĉiam pli kaj pli forta; Moseo paroladis, kaj Dio respondadis al li per voĉo. ");
INSERT INTO epo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Kaj la Eternulo malsupreniris sur la monton Sinaj, sur la supron de la monto; kaj la Eternulo vokis Moseon sur la supron de la monto, kaj Moseo supreniris. ");
INSERT INTO epo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kaj la Eternulo diris al Moseo: Iru malsupren, avertu la popolon, ke ili ne translimiĝu perforte al la Eternulo, por vidi, ĉar tiam multaj el ili falus. ");
INSERT INTO epo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Eĉ la pastroj, kiuj alproksimiĝos al la Eternulo, sanktigu sin, por ke la Eternulo ne frakasu ilin. ");
INSERT INTO epo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kaj Moseo diris al la Eternulo: La popolo ne povas supreniri sur la monton Sinaj, ĉar Vi avertis nin, dirante: Faru limon ĉirkaŭ la monto, kaj sanktigu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Sed la Eternulo diris al li: Iru malsupren, poste supreniru vi kaj Aaron kun vi; sed la pastroj kaj la popolo ne penu perforte supreniri al la Eternulo, por ke Li ne frakasu ilin. ");
INSERT INTO epo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kaj Moseo malsupreniris al la popolo kaj diris tion al ili. ");
INSERT INTO epo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kaj Dio diris ĉiujn sekvantajn vortojn: ");
INSERT INTO epo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Mi estas la Eternulo, via Dio, kiu elkondukis vin el la lando Egipta, el la domo de sklaveco. ");
INSERT INTO epo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ne ekzistu ĉe vi aliaj dioj antaŭ Mi. ");
INSERT INTO epo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ne faru al vi idolon, nek bildon de io, kio estas en la ĉielo supre aŭ sur la tero malsupre aŭ en la akvo sub la tero; ");
INSERT INTO epo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ne kliniĝu antaŭ ili kaj ne servu ilin; ĉar Mi, la Eternulo, via Dio, estas Dio severa, kiu la malbonagon de la patroj punas sur la idoj en la tria kaj kvara generacioj ĉe Miaj malamantoj, ");
INSERT INTO epo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","kaj kiu faras favorkoraĵon por miloj al Miaj amantoj kaj al la plenumantoj de Miaj ordonoj. ");
INSERT INTO epo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ne malbonuzu la nomon de la Eternulo, via Dio; ĉar la Eternulo ne lasos senpuna tiun, kiu malbonuzas Lian nomon. ");
INSERT INTO epo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Memoru pri la tago sabata, ke vi tenu ĝin sankta. ");
INSERT INTO epo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Dum ses tagoj laboru kaj faru ĉiujn viajn aferojn; ");
INSERT INTO epo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","sed la sepa tago estas sabato de la Eternulo, via Dio; faru nenian laboron, nek vi, nek via filo, nek via filino, nek via sklavo, nek via sklavino, nek via bruto, nek via fremdulo, kiu estas inter viaj pordegoj; ");
INSERT INTO epo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ĉar dum ses tagoj la Eternulo kreis la ĉielon kaj la teron, la maron, kaj ĉion, kio estas en ili, sed en la sepa tago Li ripozis. Tial la Eternulo benis la tagon sabatan kaj sanktigis ĝin. ");
INSERT INTO epo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Respektu vian patron kaj vian patrinon, por ke longe daŭru via vivo sur la tero, kiun la Eternulo, via Dio, donas al vi. ");
INSERT INTO epo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ne mortigu. ");
INSERT INTO epo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ne adultu. ");
INSERT INTO epo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ne ŝtelu. ");
INSERT INTO epo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ne parolu kontraŭ via proksimulo malveran ateston. ");
INSERT INTO epo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ne deziru la domon de via proksimulo; ne deziru la edzinon de via proksimulo, nek lian sklavon, nek lian sklavinon, nek lian bovon, nek lian azenon, nek ion, kio apartenas al via proksimulo. ");
INSERT INTO epo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kaj la tuta popolo vidis la tondrojn kaj la fulmojn kaj la sonadon de la korno kaj la fumiĝadon de la monto; kaj la popolo vidis, kaj retiriĝis kun teruro kaj stariĝis malproksime. ");
INSERT INTO epo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kaj ili diris al Moseo: Parolu vi kun ni, kaj ni aŭskultos, sed Dio ne parolu kun ni, por ke ni ne mortu. ");
INSERT INTO epo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kaj Moseo diris al la popolo: Ne timu; ĉar por vin elprovi venis Dio, kaj por ke la timo antaŭ Li estu antaŭ via vizaĝo, por ke vi ne peku. ");
INSERT INTO epo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kaj la popolo staris malproksime; sed Moseo alproksimiĝis al la mallumo, kie estis Dio. ");
INSERT INTO epo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kaj la Eternulo diris al Moseo: Tiel diru al la Izraelidoj: Vi vidis, kiel Mi parolis kun vi el la ĉielo. ");
INSERT INTO epo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ne faru antaŭ Mi diojn arĝentajn, kaj diojn orajn ne faru al vi. ");
INSERT INTO epo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Altaron el tero faru al Mi, kaj oferu sur ĝi viajn bruloferojn kaj pacoferojn, viajn ŝafojn kaj viajn bovojn; sur ĉiu loko, kie Mi memorigos Mian nomon, Mi venos al vi kaj benos vin. ");
INSERT INTO epo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kaj se vi faros al Mi altaron el ŝtonoj, ne konstruu ĝin el ŝtonoj hakitaj; ĉar se vi levos sur ĝin vian hakilon, vi ĝin malsanktigos. ");
INSERT INTO epo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kaj ne supreniru per ŝtupoj al Mia altaro, por ke ne malkovriĝu via nudeco antaŭ ĝi. ");
INSERT INTO epo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kaj jen estas la juĝoj, kiujn vi proponos al ili: ");
INSERT INTO epo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Se vi aĉetos sklavon Hebreon, li servu dum ses jaroj; sed en la sepa li eliru libera senpage. ");
INSERT INTO epo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Se li venis sola, li eliru sola; se li estas edzigita, tiam lia edzino eliru kune kun li. ");
INSERT INTO epo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Se lia sinjoro donis al li edzinon kaj ŝi naskis al li filojn aŭ filinojn, tiam la edzino kaj ŝiaj infanoj restu ĉe sia sinjoro, kaj li eliru sola. ");
INSERT INTO epo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Sed se la sklavo diros: Mi amas mian sinjoron, mian edzinon, kaj miajn infanojn, mi ne volas liberiĝi; ");
INSERT INTO epo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","tiam lia sinjoro alkonduku lin antaŭ la potenculojn kaj starigu lin apud la pordo aŭ apud la fosto, kaj lia sinjoro trapiku lian orelon per aleno, kaj li estu lia sklavo por ĉiam. ");
INSERT INTO epo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kaj se iu vendos sian filinon kiel sklavinon, ŝi ne eliru kiel eliras la sklavoj. ");
INSERT INTO epo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Se ŝi ne plaĉas al sia sinjoro, al kiu ŝi estis fordonita, tiam li donu al ŝi la eblon elaĉetiĝi; al fremda popolo ŝin vendi li ne havas la rajton, ĉar li kondutis ne honeste kontraŭ ŝi. ");
INSERT INTO epo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Se iu transdonos ŝin al sia filo, li agu kun ŝi laŭ la rajto de filinoj. ");
INSERT INTO epo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Se li prenos por li alian edzinon, tiam nutraĵo, vestoj, kaj edzina vivo ne devas esti rifuzataj al ŝi. ");
INSERT INTO epo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kaj se tiujn tri aferojn li ne faros por ŝi, tiam ŝi eliru senpage, sen elaĉeto. ");
INSERT INTO epo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Se iu batos homon kaj tiu mortos, li estu mortigita. ");
INSERT INTO epo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Sed se li ne agis malbonintence, nur Dio puŝis tiun sub lian manon, Mi difinas al vi lokon, kien li povas forkuri. ");
INSERT INTO epo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Sed se iu intence mortigis sian proksimulon per ruzo, tiam eĉ de Mia altaro forprenu lin, ke li mortu. ");
INSERT INTO epo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Kiu batas sian patron aŭ sian patrinon, tiu devas esti mortigita. ");
INSERT INTO epo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kaj se iu ŝtelas homon por vendi lin, aŭ oni trovas tiun en lia mano, li devas esti mortigita. ");
INSERT INTO epo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Kiu malbenas sian patron aŭ sian patrinon, tiu devas esti mortigita. ");
INSERT INTO epo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Se homoj kverelos, kaj unu batos la alian per ŝtono aŭ per pugno kaj tiu ne mortos, sed devos kuŝi en lito: ");
INSERT INTO epo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","se li leviĝos kaj irados ekstere per apogilo, tiam la batinto estu senkulpa; li nur kompensu al li lian malliberigitecon kaj zorgu pri lia kuracado. ");
INSERT INTO epo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Se iu batos sian sklavon aŭ sian sklavinon per bastono, kaj tiu mortos sub lia mano, tiam oni devas lin puni; ");
INSERT INTO epo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","sed se tiu restos viva dum unu aŭ du tagoj, tiam oni ne devas lin puni; ĉar tio estas lia mono. ");
INSERT INTO epo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Se viroj kverelos kaj frapos gravedan virinon, kaj ŝi abortos, sed ne fariĝos malfeliĉo, tiam oni punu lin per monpuno, kian metos sur lin la edzo de la virino, kaj li pagu ĝin laŭ decido de juĝantoj. ");
INSERT INTO epo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Sed se fariĝos malfeliĉo, tiam donu animon pro animo, ");
INSERT INTO epo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","okulon pro okulo, denton pro dento, manon pro mano, piedon pro piedo, ");
INSERT INTO epo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","bruldifekton pro bruldifekto, vundon pro vundo, kontuzon pro kontuzo. ");
INSERT INTO epo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kaj se iu batos okulon de sia sklavo aŭ de sia sklavino kaj difektos ĝin, tiam li forliberigu tiun kompense pro la okulo. ");
INSERT INTO epo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kaj se li elbatos denton de sia sklavo aŭ denton de sia sklavino, li forliberigu tiun kompense pro la dento. ");
INSERT INTO epo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Se bovo kornobatos viron aŭ virinon kaj tiu mortos, tiam oni ŝtonmortigu la bovon kaj ĝia viando ne estu manĝata, sed la mastro de la bovo restu senkulpa. ");
INSERT INTO epo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Sed se la bovo estis kornobatema antaŭe kaj oni tion sciigis al ĝia mastro kaj li ĝin ne gardis kaj ĝi mortigis viron aŭ virinon, tiam la bovon oni ŝtonmortigu kaj ĝian mastron oni mortigu. ");
INSERT INTO epo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Se oni metos sur lin elaĉeton, tiam li donu pro sia animo tian elaĉetan sumon, kia estos metita sur lin. ");
INSERT INTO epo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Se filo aŭ filino estos kornobatita, oni agu kun li en la sama maniero. ");
INSERT INTO epo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Se iun sklavon aŭ sklavinon kornobatos la bovo, tiam tridek sikloj da mono devas esti pagitaj al ties mastro kaj la bovo devas esti ŝtonmortigita. ");
INSERT INTO epo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Se iu malfermos kavon, aŭ elfosos kavon, kaj ne kovros ĝin, kaj falos tien bovo aŭ azeno, ");
INSERT INTO epo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","tiam la mastro de la kavo devas kompensi per mono al ĝia mastro, kaj la kadavro apartenu al li. ");
INSERT INTO epo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Se la bovo de iu homo kornobatos bovon de lia proksimulo tiel, ke ĝi mortos, tiam ili vendu la vivan bovon kaj dividu inter si egalparte la monon pro ĝi, kaj ankaŭ la kadavron ili dividu. ");
INSERT INTO epo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Sed se oni sciis, ke la bovo estis kornobatema antaŭe, kaj ĝia mastro ĝin ne gardis, tiam ili pagu bovon pro la bovo, kaj la kadavro apartenu al li. ");
INSERT INTO epo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Se iu ŝtelos bovon aŭ ŝafon kaj buĉos ĝin aŭ vendos ĝin, tiam li pagu kvin bovojn pro la bovo kaj kvar ŝafojn pro la ŝafo. ");
INSERT INTO epo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Se iu trovos ŝtelanton ĉe subfosado kaj batos lin kaj tiu mortos, tiam oni ne juĝu lin pro la sango. ");
INSERT INTO epo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Sed se lumis super li la suno, tiam oni juĝu lin pro la sango. La ŝtelinto pagu kompenson; se li ne havas, tiam oni lin vendu pro lia ŝtelo. ");
INSERT INTO epo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Se la ŝtelitaĵo, ĉu ĝi estas bovo, ĉu azeno, ĉu ŝafo, estos trovita en liaj manoj viva, tiam li kompensu duoble. ");
INSERT INTO epo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Se iu difektos kampon aŭ vinberejon, lasante sian bruton, ke ĝi difektu kampon de aliulo, tiam li devas pagi per plejbonaĵo el sia kampo kaj per plejbonaĵo el sia vinberejo. ");
INSERT INTO epo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Se eliros fajro kaj trafos dornojn kaj ekstermos garbojn aŭ starantan grenon aŭ kampon, tiam tiu kompensu, kiu kaŭzis la brulon. ");
INSERT INTO epo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Se iu donos al sia proksimulo monon aŭ uzataĵojn, por konservi, kaj ili estos ŝtelitaj el la domo de tiu homo, tiam, se la ŝtelinto estos trovita, li kompensu duoble. ");
INSERT INTO epo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Se la ŝtelinto ne estos trovita, tiam la mastro de la domo venu al la potenculoj, kaj ĵuru, ke li ne etendis sian manon sur la apartenaĵon de sia proksimulo. ");
INSERT INTO epo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Pri ĉiu maljustaĵo, ĉu ĝi estos pri bovo, ĉu pri azeno, ĉu pri ŝafo, ĉu pri vesto, pri ĉiu perditaĵo, pri kiu iu diros, ke ĝi estas lia, la afero de ambaŭ devas esti prezentita al la potenculoj; kiun la potenculoj trovos kulpa, tiu kompensu duoble al sia proksimulo. ");
INSERT INTO epo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Se iu donos al sia proksimulo azenon aŭ bovon aŭ ŝafon aŭ alian bruton, por konservi, kaj ĝi mortos aŭ estos difektita aŭ forkaptita, kaj neniu tion vidos, ");
INSERT INTO epo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","tiam ĵuro antaŭ la Eternulo estu inter ili, ke li ne etendis sian manon sur la apartenaĵon de sia proksimulo, kaj ĝia mastro ĝin prenos kaj li ne kompensos. ");
INSERT INTO epo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Sed se oni ĝin ŝtelos de li, tiam li devas kompensi al ĝia mastro. ");
INSERT INTO epo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Se ĝi estos disŝirita, li prezentu ateston, kaj la disŝiritaĵon li ne kompensos. ");
INSERT INTO epo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Se iu ĝin prenos prunte de sia proksimulo, kaj ĝi estos difektita aŭ mortos dum foresto de sia mastro, tiam li devas kompensi. ");
INSERT INTO epo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Se ĝia mastro estis apud ĝi, tiam li ne devas kompensi. Se ĝi estis dungita, li perdis sian dungomonon. ");
INSERT INTO epo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Se iu forlogos virgulinon, kiu ne estas fianĉinigita, kaj kuŝos kun ŝi, tiam li donu al ŝi doton kaj prenu ŝin al si kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Se ŝia patro ne volos doni ŝin al li, tiam li pagu tiom da mono, kiom virgulinoj ordinare ricevas dote. ");
INSERT INTO epo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Sorĉistinon ne lasu vivi. ");
INSERT INTO epo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ĉiu, kiu kuŝis kun bruto, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kiu alportas oferojn al dioj, krom al la Eternulo sole, tiu estu ekstermita. ");
INSERT INTO epo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Fremdulon ne ofendu, nek premu lin; ĉar fremduloj vi estis en la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Vidvinon kaj orfon ne premu. ");
INSERT INTO epo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Se vi ilin premos kaj ili krios al Mi, tiam Mi aŭdos ilian krion; ");
INSERT INTO epo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","kaj ekflamos Mia kolero, kaj Mi mortigos vin per glavo, kaj viaj edzinoj estos vidvinoj kaj viaj infanoj estos orfoj. ");
INSERT INTO epo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Se vi pruntedonos monon al iu el Mia popolo, al iu malriĉulo apud vi, ne estu por li premanto, ne metu sur lin procentojn. ");
INSERT INTO epo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Se vi prenos de via proksimulo veston kiel garantiaĵon, tiam antaŭ la subiro de la suno redonu ĝin al li; ");
INSERT INTO epo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ĉar ĝi estas lia sola kovro, ĝi estas la vesto por lia korpo; en kio li dormos? kaj kiam li krios al Mi, Mi aŭdos, ĉar Mi estas favorkora. ");
INSERT INTO epo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Potenculojn ne malbenu, kaj estron de via popolo ne insultu. ");
INSERT INTO epo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Vian abundon kaj sukon ne retenu; la unuenaskiton el viaj filoj vi devas doni al Mi. ");
INSERT INTO epo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tiel same agu kun via bovo kaj via ŝafo; sep tagojn ĝi restu kun sia patrino, en la oka tago donu ĝin al Mi. ");
INSERT INTO epo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Estu por Mi sanktaj homoj; kaj viandon, disŝiritan sur la kampo, ne manĝu; al hundo ĵetu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ne disvastigu malveran famon; ne kunigu vian manon kun malvirtulo, por esti atestanto de malbonago. ");
INSERT INTO epo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ne sekvu la amason por malbonaĵoj; kaj en juĝo ne kliniĝu al la opinio de la plimulto, por dekliniĝi de la vero. ");
INSERT INTO epo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ankaŭ malriĉulon ne favoru en lia juĝa afero. ");
INSERT INTO epo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Se vi renkontos bovon de via malamiko aŭ lian azenon erarvagantan, rekonduku ĝin al li. ");
INSERT INTO epo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Se vi vidos, ke azeno de via malamiko falis sub sia ŝarĝo, ne forlasu ĝin, sed alportu helpon kune kun li. ");
INSERT INTO epo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ne forklinu la rajton de via malriĉulo en lia juĝa afero. ");
INSERT INTO epo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","De mensogaĵo malproksimiĝu, kaj senkulpulon kaj virtulon ne mortigu; ĉar Mi ne pravigos maljustulon. ");
INSERT INTO epo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Donacojn ne akceptu; ĉar donacoj blindigas vidantojn kaj malĝustigas la aferojn de virtuloj. ");
INSERT INTO epo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Fremdulon ne premu; vi konas ja la animon de fremdulo, ĉar fremduloj vi estis en la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Dum ses jaroj prisemu vian teron kaj rikoltu ĝiajn produktaĵojn; ");
INSERT INTO epo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","sed en la sepa jaro ripozigu ĝin kaj ne tuŝu ĝin, por ke manĝu la malriĉuloj el via popolo, kaj la restaĵon manĝu la bestoj de la kampo. Tiel same agu kun via vinberejo kaj kun via olivarbejo. ");
INSERT INTO epo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Dum ses tagoj faru viajn laborojn, kaj en la sepa tago festu, por ke ripozu via bovo kaj via azeno kaj por ke refreŝiĝu la filo de via sklavino kaj la fremdulo. ");
INSERT INTO epo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Kaj ĉion, kion Mi diris al vi, observu; kaj la nomon de aliaj dioj ne citu, ĝi ne estu aŭdata el via buŝo. ");
INSERT INTO epo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tri fojojn festu al Mi dum la jaro. ");
INSERT INTO epo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","La feston de la macoj observu; dum sep tagoj manĝu macojn, kiel Mi ordonis al vi, en la difinita tempo en la monato Abib (ĉar en tiu tempo vi eliris el Egiptujo); kaj oni ne aperu antaŭ Mi kun malplenaj manoj; ");
INSERT INTO epo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ankaŭ la feston de la rikolto de la unuaj fruktoj de via laboro, de tio, kion vi semos sur la kampo; kaj la feston de kolekto en la fino de la jaro, kiam vi kolektos viajn laborfruktojn el la kampo. ");
INSERT INTO epo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Tri fojojn ĉiujare aperu ĉiuj viaj virseksuloj antaŭ la Sinjoro, la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ne verŝu sur fermentaĵon la sangon de Mia ofero; kaj la graso de Mia festofero ne restu ĝis mateno. ");
INSERT INTO epo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","La komencaĵon de la unuaj fruktoj de via tero alportu en la domon de la Eternulo, via Dio. Ne kuiru kapridon en la lakto de ĝia patrino. ");
INSERT INTO epo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Jen Mi sendas anĝelon antaŭ vi, por gardi vin sur la vojo, kaj por venigi vin al la loko, kiun Mi pretigis. ");
INSERT INTO epo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Gardu vin antaŭ lia vizaĝo kaj aŭskultu lian voĉon; ne incitu lin, ĉar li ne pardonos vian pekon; ĉar Mia nomo estas en li. ");
INSERT INTO epo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Sed se vi aŭskultos lian voĉon, kaj faros ĉion, kion Mi diros, tiam Mi malamikos kontraŭ viaj malamikoj kaj premos viajn premantojn. ");
INSERT INTO epo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Kiam Mia anĝelo iros antaŭ vi, kaj Mi venigos vin al la Amoridoj, la Ĥetidoj, la Perizidoj, la Kanaanidoj, la Ĥividoj, kaj la Jebusidoj, kaj Mi ilin ekstermos: ");
INSERT INTO epo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ne adoru iliajn diojn kaj ne servu ilin, kaj ne agu kiel ili agas, sed frakasu ilin kaj detruu iliajn statuojn. ");
INSERT INTO epo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Kaj servu la Eternulon, vian Dion, kaj Li benos vian panon kaj vian akvon; kaj Mi forigos malsanon el via mezo. ");
INSERT INTO epo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ne estos seninfana nek sennaska en via lando; la nombron de viaj tagoj Mi faros plena. ");
INSERT INTO epo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Mian teruron Mi sendos antaŭ vi, kaj Mi konfuzos ĉiun popolon, al kiu vi venos, kaj ĉiujn viajn malamikojn Mi turnos al vi dorse. ");
INSERT INTO epo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Kaj Mi sendos krabrojn antaŭ vi, kaj ili forpelos la Ĥividojn kaj la Kanaanidojn kaj la Ĥetidojn de antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mi ne forpelos ilin de antaŭ vi en unu jaro, por ke la tero ne fariĝu senhoma kaj por ke ne multiĝu kontraŭ vi la bestoj de la kampo. ");
INSERT INTO epo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Iom post iom Mi forpelos ilin de antaŭ vi, ĝis vi multiĝos kaj posedos la landon. ");
INSERT INTO epo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Kaj Mi faros viajn limojn de la Ruĝa Maro ĝis la Maro Filiŝta, kaj de la dezerto ĝis la Rivero; ĉar Mi transdonos en viajn manojn la loĝantojn de la lando, kaj vi forpelos ilin de antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ne faru interligon kun ili nek kun iliaj dioj. ");
INSERT INTO epo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ili ne loĝu en via lando, por ke ili ne pekigu vin kontraŭ Mi; se vi servos iliajn diojn, tio fariĝos kaptilo por vi. ");
INSERT INTO epo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kaj al Moseo Li diris: Supreniru al la Eternulo, vi kaj Aaron, Nadab kaj Abihu, kaj sepdek el la ĉefoj de Izrael, kaj faru adoron de malproksime. ");
INSERT INTO epo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Kaj Moseo sola alproksimiĝu al la Eternulo; sed ili ne alproksimiĝu, kaj la popolo ne supreniru kun li. ");
INSERT INTO epo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kaj Moseo venis kaj rakontis al la popolo ĉiujn vortojn de la Eternulo kaj ĉiujn leĝojn. Kaj la tuta popolo respondis per unu voĉo, kaj ili diris: Ĉion, kion diris la Eternulo, ni faros. ");
INSERT INTO epo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kaj Moseo skribis ĉiujn vortojn de la Eternulo, kaj li leviĝis frue matene kaj konstruis altaron sub la monto kaj dek du kolonojn laŭ la dek du triboj de Izrael. ");
INSERT INTO epo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Kaj li sendis junulojn el la Izraelidoj, kaj ili alportis bruloferojn kaj buĉis pacoferojn al la Eternulo, bovidojn. ");
INSERT INTO epo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moseo prenis duonon de la sango kaj enverŝis en pelvojn, kaj duonon de la sango li ŝprucigis sur la altaron. ");
INSERT INTO epo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kaj li prenis la libron de la interligo kaj laŭtlegis ĝin al la popolo, kaj ili diris: Ĉion, kion diris la Eternulo, ni faros kaj obeos. ");
INSERT INTO epo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kaj Moseo prenis la sangon kaj ŝprucigis sur la popolon, kaj diris: Jen estas sango de la interligo, kiun la Eternulo faris kun vi pri ĉiuj tiuj vortoj. ");
INSERT INTO epo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kaj supreniris Moseo kaj Aaron, Nadab kaj Abihu, kaj sepdek el la ĉefoj de Izrael. ");
INSERT INTO epo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Kaj ili vidis la Dion de Izrael; kaj sub Liaj piedoj estis io, kiel faritaĵo el brilanta safiro, kaj kiel la ĉielo mem, kiam ĝi estas klara. ");
INSERT INTO epo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Li ne etendis Sian manon kontraŭ la ĉefojn de Izrael; kaj ili vidis Dion, kaj manĝis kaj trinkis. ");
INSERT INTO epo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Kaj la Eternulo diris al Moseo: Supreniru al Mi sur la monton kaj estu tie; kaj Mi donos al vi ŝtonajn tabelojn, kaj la instruon kaj ordonojn, kiujn Mi skribis, por instrui ilin. ");
INSERT INTO epo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kaj leviĝis Moseo kaj lia servanto Josuo, kaj Moseo supreniris sur la monton de Dio. ");
INSERT INTO epo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kaj al la ĉefoj li diris: Restu ĉi tie, ĝis ni revenos al vi; kaj jen Aaron kaj Ĥur estas kun vi; kiu havas ian aferon, tiu venu al ili. ");
INSERT INTO epo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kaj Moseo supreniris sur la monton, kaj nubo kovris la monton. ");
INSERT INTO epo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kaj la majesto de la Eternulo loĝis sur la monto Sinaj, kaj la nubo ĝin kovris dum ses tagoj; kaj Li vokis Moseon en la sepa tago el interne de la nubo. ");
INSERT INTO epo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Kaj la aspekto de la majesto de la Eternulo estis kiel fajro flamanta sur la supro de la monto antaŭ la okuloj de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Kaj Moseo eniris en la mezon de la nubo, kaj supreniris sur la monton; kaj Moseo estis sur la monto dum kvardek tagoj kaj kvardek noktoj. ");
INSERT INTO epo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Diru al la Izraelidoj, ke ili alportu por Mi oferdonon; de ĉiu homo, kies koro deziros doni, prenu la oferdonon por Mi. ");
INSERT INTO epo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kaj jen estas la oferdono, kiun vi prenos de ili: oro kaj arĝento kaj kupro, ");
INSERT INTO epo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kaj blua teksaĵo kaj purpura kaj ruĝa, kaj bisino kaj kapra lano, ");
INSERT INTO epo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kaj virŝafaj feloj ruĝe kolorigitaj kaj antilopaj feloj, kaj akacia ligno, ");
INSERT INTO epo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oleo por lumigado, aromaĵoj por la sankta oleo kaj por la bonodoraj incensoj, ");
INSERT INTO epo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ŝtonoj oniksaj kaj ŝtonoj enkadrigeblaj por la efodo kaj por la surbrustaĵo. ");
INSERT INTO epo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Kaj ili faru por Mi sanktejon, por ke Mi loĝu inter ili. ");
INSERT INTO epo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Laŭ ĉio, kiel Mi montros al vi la bildon de la Loĝejo kaj la bildon de ĉiuj ĝiaj objektoj, tiel faru. ");
INSERT INTO epo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Kaj ili faru keston el akacia ligno; du ulnoj kaj duono estu ĝia longo, kaj unu ulno kaj duono ĝia larĝo, kaj unu ulno kaj duono ĝia alto. ");
INSERT INTO epo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kaj tegu ĝin per pura oro, interne kaj ekstere tegu ĝin, kaj faru sur ĝi oran kronon ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kaj fandu por ĝi kvar orajn ringojn, kaj alfortikigu ilin sur ĝiaj kvar anguloj: du ringojn sur unu ĝia flanko kaj du ringojn sur ĝia alia flanko. ");
INSERT INTO epo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kaj faru stangojn el akacia ligno kaj tegu ilin per oro. ");
INSERT INTO epo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kaj metu la stangojn en la ringojn sur la flankoj de la kesto, por porti la keston per ili. ");
INSERT INTO epo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","En la ringoj de la kesto devas esti la stangoj; ili ne estu prenataj for de ĝi. ");
INSERT INTO epo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kaj en la keston enmetu la Ateston, kiun Mi donos al vi. ");
INSERT INTO epo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kaj faru fermoplaton el pura oro; du ulnoj kaj duono estu ĝia longo, kaj unu ulno kaj duono ĝia larĝo. ");
INSERT INTO epo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kaj faru du kerubojn el oro; per forĝa laboro faru ilin ĉe la du randoj de la fermoplato. ");
INSERT INTO epo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Faru unu kerubon ĉe unu flanko kaj unu kerubon ĉe la alia flanko; elstarantaj el la fermoplato faru la kerubojn, sur ĝiaj du flankoj. ");
INSERT INTO epo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kaj la keruboj estu etendantaj siajn flugilojn supren, kovrante per siaj flugiloj la fermoplaton, kaj iliaj vizaĝoj estu unu kontraŭ la alia; al la fermoplato estu turnitaj la vizaĝoj de la keruboj. ");
INSERT INTO epo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kaj metu la fermoplaton sur la keston supre, kaj en la keston metu la ateston, kiun Mi donos al vi. ");
INSERT INTO epo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Kaj Mi aperados al vi tie, kaj Mi parolados kun vi super la fermoplato, el inter la du keruboj, kiuj estos super la kesto de atesto, pri ĉio, kion Mi ordonos al vi por la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Kaj faru tablon el akacia ligno; du ulnoj estu ĝia longo, kaj unu ulno ĝia larĝo, kaj unu ulno kaj duono ĝia alto. ");
INSERT INTO epo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kaj tegu ĝin per pura oro, kaj faru al ĝi oran kronon ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kaj faru ĉirkaŭ ĝi manlarĝan listelon, kaj faru oran kronon ĉirkaŭ la listelo. ");
INSERT INTO epo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kaj faru por ĝi kvar orajn ringojn, kaj alfortikigu la ringojn en la kvar anguloj, ĉe ĝiaj kvar piedoj. ");
INSERT INTO epo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Apud la listelo estu la ringoj, kiel ingoj por stangoj, por porti la tablon. ");
INSERT INTO epo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kaj faru la stangojn el akacia ligno, kaj tegu ilin per oro, ke per ili oni portu la tablon. ");
INSERT INTO epo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Kaj faru ĝiajn pladojn kaj ĝiajn kulerojn, kaj ĝiajn kalikojn kaj ĝiajn kruĉojn, per kiuj oni verŝos; el pura oro faru ilin. ");
INSERT INTO epo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kaj metu sur la tablon panon de propono antaŭ Mi ĉiam. ");
INSERT INTO epo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Kaj faru kandelabron el pura oro, per forĝa laboro estu farita la kandelabro; ĝia trunko kaj ĝiaj branĉoj, ĝiaj kalikoj, ĝiaj kapetoj, kaj ĝiaj floroj elstaru el ĝi. ");
INSERT INTO epo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kaj ses branĉoj devas elstari el ĝiaj flankoj: tri branĉoj de la kandelabro el unu flanko, kaj tri branĉoj de la kandelabro el la alia flanko; ");
INSERT INTO epo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","tri migdalformaj kalikoj, kapeto, kaj floro, sur unu branĉo, kaj tri migdalformaj kalikoj, kapeto, kaj floro, sur la alia branĉo; tiel sur la ses branĉoj, kiuj elstaras el la kandelabro. ");
INSERT INTO epo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kaj sur la kandelabro estu kvar migdalformaj kalikoj kun kapetoj kaj floroj. ");
INSERT INTO epo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kaj kapeto sub unu paro da branĉoj, kapeto sub la dua paro da branĉoj, kaj kapeto sub la tria paro da branĉoj; tiel por la ses branĉoj, kiuj elstaras el la kandelabro. ");
INSERT INTO epo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","La kapetoj kaj branĉoj devas elstari el ĝi; ĉio devas esti unu forĝita tutaĵo el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kaj faru por ĝi sep lucernojn; kaj starigu sur ĝi ĝiajn lucernojn, ke ili lumu sur ĝian antaŭan flankon. ");
INSERT INTO epo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kaj ĝiaj preniloj kaj cindrujoj estu el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","El kikaro da pura oro oni faru ĝin kaj ĉiujn tiujn apartenaĵojn. ");
INSERT INTO epo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kaj rigardu kaj faru laŭ ilia modelo, kiu estis montrita al vi sur la monto. ");
INSERT INTO epo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","La tabernaklon faru el dek tapiŝoj el tordita bisino, kaj el blua, purpura, kaj ruĝa teksaĵo; kerubojn artiste laboritajn faru sur ili. ");
INSERT INTO epo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longo de ĉiu tapiŝo estu dudek ok ulnoj, kaj la larĝo de ĉiu tapiŝo estu kvar ulnoj; unu mezuro estu por ĉiuj tapiŝoj. ");
INSERT INTO epo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kvin tapiŝoj estu kunigitaj unu kun la alia, kaj la kvin ceteraj tapiŝoj estu ankaŭ kunigitaj unu kun la alia. ");
INSERT INTO epo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kaj faru maŝojn el blua teksaĵo sur la rando de unu tapiŝo, sur la rando de la kuniĝo, kaj tiel same faru sur la rando de la ekstrema tapiŝo, sur la dua rando de kuniĝo. ");
INSERT INTO epo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kvindek maŝojn faru sur unu tapiŝo, kaj kvindek maŝojn faru sur la rando de tiu tapiŝo, sur kiu estas la dua flanko de la kuniĝo; la maŝoj devas esti reciproke aranĝitaj unu kontraŭ alia. ");
INSERT INTO epo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kaj faru kvindek orajn hoketojn, kaj kunigu la tapiŝojn unu kun la alia per la hoketoj, por ke la tabernaklo fariĝu unu tutaĵo. ");
INSERT INTO epo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kaj faru tapiŝojn el kapra lano kiel kovron super la tabernaklo; dek unu tiajn tapiŝojn faru. ");
INSERT INTO epo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longo de ĉiu tapiŝo estu tridek ulnoj, kaj la larĝo de ĉiu tapiŝo estu kvar ulnoj; unu mezuro estu por la dek unu tapiŝoj. ");
INSERT INTO epo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kaj kunigu kvin tapiŝojn aparte kaj ses tapiŝojn aparte, kaj la sesan tapiŝon faldu duige antaŭ la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kaj faru kvindek maŝojn sur la rando de la ekstrema tapiŝo, sur la rando de la kuniĝo, kaj kvindek maŝojn sur la rando de la dua kuniĝa tapiŝo. ");
INSERT INTO epo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kaj faru kvindek kuprajn hoketojn, kaj metu la hoketojn en la maŝojn, por ke vi kunigu la tendon kaj ĝi estu unu tutaĵo. ");
INSERT INTO epo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Kaj el la superflua pendanta parto de la tapiŝoj de la kovro, duono de la superflua tapiŝa parto superpendu super la malantaŭa flanko de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kaj po unu ulno ĉiuflanke el la superflua longo de la tapiŝoj superpendu super ambaŭ flankoj de la tabernaklo, por kovri ĝin. ");
INSERT INTO epo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kaj faru kovron por la tendo el ruĝaj virŝafaj feloj kaj ankoraŭ kovron el antilopaj feloj supre. ");
INSERT INTO epo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Kaj faru starantajn tabulojn por la tabernaklo el akacia ligno. ");
INSERT INTO epo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dek ulnoj estu la longo de ĉiu tabulo, kaj unu ulno kaj duono la larĝo de ĉiu tabulo. ");
INSERT INTO epo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Du pivotoj estu ĉe ĉiu tabulo, alĝustigitaj unu al la alia; tiel faru ĉe ĉiuj tabuloj de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kaj faru la tabulojn por la tabernaklo: dudek tabuloj staru sur la flanko suda. ");
INSERT INTO epo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kaj kvardek arĝentajn bazojn faru sub la dudek tabuloj: du bazojn sub ĉiu tabulo, por ĝiaj du pivotoj. ");
INSERT INTO epo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kaj sur la dua flanko de la tabernaklo, sur la flanko norda, estu dudek tabuloj, ");
INSERT INTO epo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","kaj kvardek arĝentaj bazoj por ili, po du bazoj sub ĉiu tabulo. ");
INSERT INTO epo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kaj sur la malantaŭa flanko de la tabernaklo, okcidente, faru ses tabulojn. ");
INSERT INTO epo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kaj du tabulojn faru en la anguloj de la tabernaklo sur la malantaŭa flanko. ");
INSERT INTO epo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ili estu kunigitaj malsupre kaj kunigitaj supre per unu ringo; tiel ĝi estu kun ili ambaŭ; por ambaŭ anguloj ili estu. ");
INSERT INTO epo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Tiel estu ok tabuloj, kaj ĉe ili dek ses arĝentaj bazoj, po du bazoj sub ĉiu tabulo. ");
INSERT INTO epo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Kaj faru riglilojn el akacia ligno, kvin por la tabuloj de unu flanko de la tabernaklo, ");
INSERT INTO epo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","kaj kvin riglilojn por la tabuloj de la dua flanko de la tabernaklo, kaj kvin riglilojn por la tabuloj de la malantaŭa flanko de la tabernaklo, okcidente. ");
INSERT INTO epo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kaj la meza riglilo meze de la tabuloj ŝoviĝu de unu fino ĝis la alia. ");
INSERT INTO epo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kaj la tabulojn tegu per oro, kaj iliajn ringojn, ingojn por la rigliloj, faru el oro, kaj la riglilojn tegu per oro. ");
INSERT INTO epo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Starigu la tabernaklon laŭ ĝia modelo, kiu estis montrita al vi sur la monto. ");
INSERT INTO epo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Kaj faru kurtenon el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino; artiste laboritaj keruboj estu faritaj sur ĝi. ");
INSERT INTO epo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kaj pendigu ĝin sur kvar akaciaj kolonoj, tegitaj per oro kaj havantaj orajn hokojn kaj arĝentajn bazojn. ");
INSERT INTO epo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kaj pendigu la kurtenon sub la hokoj, kaj enportu tien internen de la kurteno la keston de atesto; kaj la kurteno faru por vi apartigon inter la sanktejo kaj la plejsanktejo. ");
INSERT INTO epo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Kaj metu la fermoplaton sur la keston de atesto en la plejsanktejo. ");
INSERT INTO epo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kaj starigu la tablon ekster la kurteno, kaj la kandelabron kontraŭ la tablo, en la suda parto de la tabernaklo; la tablon starigu en la norda parto. ");
INSERT INTO epo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Kaj faru kovrotukon por la pordo de la tabernaklo, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino, kun brodaĵoj; ");
INSERT INTO epo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","kaj faru por la kovrotuko kvin kolonojn el akacia ligno, kaj tegu ilin per oro, kaj iliaj hoketoj estu el oro; kaj fandu por ili kvin kuprajn bazojn. ");
INSERT INTO epo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Kaj faru la altaron el akacia ligno, havantan la longon de kvin ulnoj kaj la larĝon de kvin ulnoj; kvarangula estu la altaro; kaj ĝia alto estu tri ulnoj. ");
INSERT INTO epo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kaj faru ĝiajn kornojn sur ĝiaj kvar anguloj; el ĝi elstaru ĝiaj kornoj; kaj tegu ĝin per kupro. ");
INSERT INTO epo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kaj faru por ĝi potojn por ĝia cindro kaj ŝovelilojn kaj kalikojn kaj forkojn kaj karbujojn; ĉiujn ĝiajn vazojn faru el kupro. ");
INSERT INTO epo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kaj faru por ĝi kradon en formo de kupra reto, kaj faru sur la reto kvar kuprajn ringojn sur ĝiaj kvar anguloj. ");
INSERT INTO epo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kaj metu ĝin sub la kornicon de la altaro, malsupren, tiel, ke la reto atingu ĝis la mezo de la altaro. ");
INSERT INTO epo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kaj faru stangojn por la altaro, stangojn el akacia ligno, kaj tegu ilin per kupro. ");
INSERT INTO epo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Kaj metu ĝiajn stangojn en ringojn, tiel, ke la stangoj estu ĉe ambaŭ flankoj de la altaro, kiam oni ĝin portos. ");
INSERT INTO epo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Interne malplena faru ĝin el tabuloj; kiel estis montrite al vi sur la monto, tiel oni faru. ");
INSERT INTO epo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Kaj faru korton por la tabernaklo; sur la flanko suda estu kurtenoj por la korto, el tordita bisino; unu flanko havu la longon de cent ulnoj; ");
INSERT INTO epo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","kaj ĝiaj dudek kolonoj kaj iliaj dudek bazoj estu el kupro; la hokoj de la kolonoj kaj iliaj ligiloj estu el arĝento. ");
INSERT INTO epo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Tiel same ankaŭ sur la norda flanko laŭlonge estu kurtenoj, havantaj la longon de cent ulnoj; kaj dudek kolonoj, kaj por ili dudek bazoj el kupro; la hokoj de la kolonoj kaj iliaj ligiloj estu el arĝento. ");
INSERT INTO epo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Sed laŭlarĝe de la korto, sur la flanko okcidenta, estu kurtenoj, havantaj la longon de kvindek ulnoj; dek kolonoj, kaj por ili dek bazoj. ");
INSERT INTO epo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kaj laŭlarĝe de la korto, sur la flanko orienta, estu kurtenoj, havantaj la longon de kvindek ulnoj. ");
INSERT INTO epo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kaj kurtenoj, havantaj la longon de dek kvin ulnoj, estu por unu latero; ankaŭ tri kolonoj, kaj por ili tri bazoj. ");
INSERT INTO epo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Kaj por la dua latero estu kurtenoj, havantaj la longon de dek kvin ulnoj; ankaŭ tri kolonoj, kaj por ili tri bazoj. ");
INSERT INTO epo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Kaj por la pordego de la korto estu kovrotuko, havanta la longon de dudek ulnoj, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino, kun brodaĵoj; kvar kolonoj, kaj por ili kvar bazoj. ");
INSERT INTO epo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ĉiuj kolonoj ĉirkaŭ la korto havu ligilojn el arĝento, hokojn el arĝento, kaj bazojn el kupro. ");
INSERT INTO epo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longo de la korto estu cent ulnoj, la larĝo ĉie kvindek, kaj la alto kvin ulnoj; ĉio estu farita el tordita bisino, kaj la bazoj estu el kupro. ");
INSERT INTO epo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ĉiuj vazoj de la tabernaklo, por ĉiuj servoj, kaj ĉiuj ĝiaj najloj kaj ĉiuj najloj de la korto, estu el kupro. ");
INSERT INTO epo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Kaj vi ordonu al la Izraelidoj, ke ili alportu al vi oleon olivan, puran, pistitan, por lumigado, por ke lucerno brulu ĉiam. ");
INSERT INTO epo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","En la tabernaklo de kunveno, ekstere de la kurteno, kiu pendas antaŭ la atesto, aranĝadu ĝin Aaron kaj liaj filoj de vespero ĝis mateno antaŭ la Eternulo. Tio estu eterna leĝo en la generacioj de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kaj vi alproksimigu al vi vian fraton Aaron kaj liajn filojn kun li el inter la Izraelidoj, por ke li estu Mia pastro: Aaron, kaj Nadab, Abihu, Eleazar, kaj Itamar, la filoj de Aaron. ");
INSERT INTO epo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kaj faru sanktajn vestojn por via frato Aaron, por honoro kaj ornamo. ");
INSERT INTO epo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kaj diru al ĉiuj, kiuj havas saĝan koron kaj kiujn Mi plenigis per spirito de saĝo, ke ili faru por Aaron vestojn, por sanktigi lin, ke li estu Mia pastro. ");
INSERT INTO epo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Kaj jen estas la vestoj, kiujn ili devas fari: surbrustaĵo, efodo, tuniko, ĥitono teksita, cidaro, kaj zono. Kaj ili faru sanktajn vestojn por via frato Aaron kaj por liaj filoj, ke li estu Mia pastro. ");
INSERT INTO epo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kaj ili prenu oron, kaj bluan, purpuran, kaj ruĝan teksaĵon, kaj bisinon. ");
INSERT INTO epo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Kaj ili faru la efodon el oro, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino, en artista maniero. ");
INSERT INTO epo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Du surŝultraĵojn kunigantajn ĝi havu sur siaj du finoj, por ke ĝi estu ligita. ");
INSERT INTO epo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kaj la ĉirkaŭliganta zono sur ĝi estu la sama laboraĵo, kiel ĝia kontinuaĵo, el oro, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino. ");
INSERT INTO epo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Kaj prenu du oniksajn ŝtonojn, kaj gravuru sur ili la nomojn de la filoj de Izrael: ");
INSERT INTO epo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ses el iliaj nomoj sur unu ŝtono kaj la ses ceterajn nomojn sur la dua ŝtono, laŭ la ordo de ilia naskiĝo. ");
INSERT INTO epo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Per laboro de gravuristoj, kiel sigelila gravurado, gravurigu sur la du ŝtonoj la nomojn de la filoj de Izrael; faru ilin ĉirkaŭataj per kadretoj el oro. ");
INSERT INTO epo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kaj metu la du ŝtonojn sur la surŝultraĵojn de la efodo, kiel ŝtonojn de memoro pri la filoj de Izrael; kaj Aaron portu iliajn nomojn antaŭ la Eternulo sur siaj du surŝultraĵoj por memoro. ");
INSERT INTO epo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kaj faru kadretojn el oro; ");
INSERT INTO epo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","kaj du ĉenetojn el pura oro; faru ilin kuniĝantaj per siaj finoj, plektitaj; kaj alfortikigu la plektitajn ĉenetojn al la kadretoj. ");
INSERT INTO epo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Kaj faru juĝan surbrustaĵon per artista laboro; simile al la laboro de la efodo faru ĝin; el oro, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino faru ĝin. ");
INSERT INTO epo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kvarangula ĝi estu kaj duobla; manstreĉo estu ĝia longo, kaj manstreĉo ĝia larĝo. ");
INSERT INTO epo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kaj enmetu en ĝin enmetaĵon el ŝtonoj en kvar vicoj. La ŝtonoj de vico: rubeno, topazo, kaj smeraldo estu la unua vico; ");
INSERT INTO epo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","kaj la dua vico: hiacinto, safiro, kaj jaspiso; ");
INSERT INTO epo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","kaj la tria vico: ligurio, agato, kaj ametisto; ");
INSERT INTO epo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","kaj la kvara vico: krizolito, kaj onikso, kaj berilo. En oraj kadretoj ili estu laŭ siaj vicoj. ");
INSERT INTO epo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kaj la ŝtonoj estu laŭ la nomoj de la filoj de Izrael; dek du, laŭ iliaj nomoj, gravuritaj sigelile, ĉiu kun sia nomo, por la dek du triboj. ");
INSERT INTO epo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Kaj faru al la surbrustaĵo plektitajn ĉenetojn, kuniĝantajn per siaj finoj, el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kaj faru por la surbrustaĵo du orajn ringojn, kaj alfortikigu la du ringojn al la du finoj de la surbrustaĵo. ");
INSERT INTO epo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kaj metu la du orajn plektitajn ĉenetojn en la du ringojn ĉe la finoj de la surbrustaĵo. ");
INSERT INTO epo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kaj la du finojn de la du plektitaj ĉenetoj enfortikigu en la du kadretojn, kaj alfortikigu ilin al la surŝultraĵoj de la efodo sur la antaŭa flanko. ");
INSERT INTO epo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kaj faru du orajn ringojn, kaj alfortikigu ilin al la du aliaj finoj de la surbrustaĵo, sur interna ĝia rando, direktita al la efodo. ");
INSERT INTO epo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kaj faru du orajn ringojn, kaj alfortikigu ilin al la du surŝultraĵoj de la efodo malsupre, sur la antaŭa flanko, ĉe ĝia kuniĝo, super la zono de la efodo. ");
INSERT INTO epo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kaj oni alligu la surbrustaĵon per ĝiaj ringoj al la ringoj de la efodo per laĉo el blua ŝtofo, por ke ĝi estu super la zono de la efodo kaj por ke la surbrustaĵo ne forŝoviĝu de sur la efodo. ");
INSERT INTO epo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Kaj Aaron portu la nomojn de la filoj de Izrael sur la juĝa surbrustaĵo sur sia koro, kiam li eniros en la sanktejon, por ĉiama memoro antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Kaj metu sur la juĝan surbrustaĵon la signojn de lumo kaj la signojn de justo, por ke ili estu sur la koro de Aaron, kiam li eniros antaŭ la Eternulon; kaj Aaron ĉiam portu la juĝon de la filoj de Izrael sur sia koro antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Kaj faru la tunikon de la efodo tutan el blua teksaĵo. ");
INSERT INTO epo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","La aperturo por la kapo estu en ĝia mezo; ĉirkaŭ la aperturo estu teksita bordero, kiel ĉe aperturo de ŝildo, por ke ĝi ne disŝiriĝu. ");
INSERT INTO epo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sur ĝia malsupra rando faru granatojn el blua, purpura, kaj ruĝa teksaĵo, ĉirkaŭe sur ĝia malsupra rando, kaj inter ili ĉirkaŭe orajn tintilojn. ");
INSERT INTO epo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ora tintilo kaj granato, ora tintilo kaj granato estu ĉirkaŭe sur la malsupra rando de la tuniko. ");
INSERT INTO epo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ĝi estu sur Aaron dum lia servado; por ke oni aŭdu sonon de li, kiam li eniros en la sanktejon antaŭ la Eternulon kaj kiam li eliros, kaj por ke li ne mortu. ");
INSERT INTO epo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Kaj faru tabuleton el pura oro, kaj gravuru sur ĝi en sigelila maniero: SANKTA AL LA ETERNULO. ");
INSERT INTO epo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kaj alfortikigu ĝin per laĉo el blua ŝtofo, ke ĝi estu sur la cidaro; sur la antaŭa flanko de la cidaro ĝi devas esti. ");
INSERT INTO epo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ĝi estu sur la frunto de Aaron; kaj Aaron portados la pekon kontraŭ la sanktaĵoj, kiujn sanktigos la Izraelidoj en ĉiuj siaj sanktaj donoj; kaj ĝi estos sur lia frunto ĉiam, por ke la Eternulo ilin favoru. ");
INSERT INTO epo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Kaj teksu la ĥitonon el bisino, kaj faru la cidaron el bisino, kaj faru broditan zonon. ");
INSERT INTO epo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Kaj por la filoj de Aaron faru ĥitonojn, kaj faru por ili zonojn, kaj mitrojn faru por ili, por honoro kaj ornamo. ");
INSERT INTO epo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Kaj vestu per ili vian fraton Aaron kaj liajn filojn kune kun li; kaj sanktoleu ilin kaj konsekru ilin kaj sanktigu ilin, por ke ili estu pastroj al Mi. ");
INSERT INTO epo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Kaj faru por ili linajn pantalonojn, por kovri la nudecon de ilia karno; de la lumbo ĝis la femuroj ili estu. ");
INSERT INTO epo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Kaj ili estu sur Aaron kaj sur liaj filoj, kiam ili eniros en la tabernaklon de kunveno, aŭ kiam ili alproksimiĝos al la altaro, por servi en la sanktejo; por ke ili ne faru pekon kaj ne mortu. Eterna leĝo ĝi estu por li kaj por lia idaro post li. ");
INSERT INTO epo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Kaj jen estas tio, kion vi devas fari al ili, por sanktigi ilin, ke ili estu pastroj al Mi: prenu unu virbovidon kaj du virŝafojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","kaj macan panon, kaj macajn kukojn, miksitajn kun oleo, kaj macajn flanojn, ŝmiritajn per oleo; el delikata tritika faruno faru ilin. ");
INSERT INTO epo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Kaj metu ilin en unu korbon, kaj venigu ilin en la korbo, kaj ankaŭ la bovidon kaj la du virŝafojn. ");
INSERT INTO epo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kaj Aaronon kaj liajn filojn alvenigu al la pordo de la tabernaklo de kunveno, kaj lavu ilin per akvo. ");
INSERT INTO epo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kaj prenu la vestojn, kaj metu sur Aaronon la ĥitonon kaj la tunikon de la efodo kaj la efodon kaj la surbrustaĵon, kaj zonu lin per la zono de la efodo. ");
INSERT INTO epo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kaj metu la cidaron sur lian kapon, kaj metu la sanktan kronon sur la cidaron. ");
INSERT INTO epo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kaj prenu la oleon de sanktoleado, kaj verŝu sur lian kapon kaj sanktoleu lin. ");
INSERT INTO epo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kaj liajn filojn alvenigu, kaj vestu ilin per la ĥitonoj. ");
INSERT INTO epo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kaj zonu ilin per zono, Aaronon kaj liajn filojn, kaj alligu sur ili mitrojn, por ke al ili apartenu la pastreco laŭ eterna leĝo; kaj konsekru Aaronon kaj liajn filojn. ");
INSERT INTO epo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Kaj alvenigu la bovidon antaŭ la tabernaklon de kunveno, kaj Aaron kaj liaj filoj metu siajn manojn sur la kapon de la bovido. ");
INSERT INTO epo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Kaj buĉu la bovidon antaŭ la Eternulo, ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kaj prenu iom el la sango de la bovido kaj metu per viaj fingroj sur la kornojn de la altaro, kaj la tutan ceteran sangon elverŝu ĉe la bazo de la altaro. ");
INSERT INTO epo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kaj prenu la tutan sebon, kiu kovras la internaĵon, kaj la reton de la hepato, kaj la du renojn, kaj la sebon, kiu estas sur ili, kaj incense bruligu ilin sur la altaro. ");
INSERT INTO epo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kaj la karnon de la bovido kaj ĝian felon kaj ĝian malpuraĵon forbruligu per fajro ekster la tendaro; ĝi estas pekofero. ");
INSERT INTO epo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Kaj unu virŝafon prenu, kaj Aaron kaj liaj filoj metu siajn manojn sur la kapon de la virŝafo. ");
INSERT INTO epo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kaj buĉu la virŝafon, kaj prenu ĝian sangon kaj aspergu la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kaj la virŝafon dishaku en partojn, kaj lavu ĝian internaĵon kaj ĝiajn krurojn, kaj metu ilin sur ĝiajn partojn kaj sur ĝian kapon. ");
INSERT INTO epo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kaj forbruligu la tutan virŝafon sur la altaro; ĝi estas brulofero por la Eternulo; agrabla odoraĵo, fajrofero por la Eternulo ĝi estas. ");
INSERT INTO epo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kaj prenu la duan virŝafon, kaj Aaron kaj liaj filoj metu siajn manojn sur la kapon de la virŝafo. ");
INSERT INTO epo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kaj buĉu la virŝafon, kaj prenu iom el ĝia sango kaj metu sur la malsupran randon de la dekstra orelo de Aaron kaj sur la malsupran randon de la dekstra orelo de liaj filoj kaj sur la dikan fingron de ilia dekstra mano kaj sur la dikan fingron de ilia dekstra piedo; kaj aspergu per la sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kaj prenu el la sango, kiu estos sur la altaro, kaj sanktan oleon, kaj aspergu Aaronon kaj liajn vestojn kaj liajn filojn kaj la vestojn de liaj filoj kune kun li; kaj sanktiĝos li kaj liaj vestoj kaj liaj filoj kaj la vestoj de liaj filoj kune kun li. ");
INSERT INTO epo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Kaj prenu de la virŝafo la sebon kaj la voston, kaj la sebon, kiu kovras la internaĵon, kaj la reton de la hepato, kaj la du renojn, kaj la sebon, kiu estas sur ili, kaj la dekstran femuron, ĉar tio estas virŝafo de konsekrado; ");
INSERT INTO epo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","kaj unu bulon da pano kaj unu kukon kun oleo kaj unu flanon, el la korbo kun macoj, kiu staras antaŭ la Eternulo; ");
INSERT INTO epo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","kaj metu ĉion sur la manojn de Aaron kaj sur la manojn de liaj filoj, kaj skuu tion kiel skuoferon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kaj prenu tion el iliaj manoj, kaj forbruligu ĝin sur la altaro kune kun la brulofero, kiel agrablan odoraĵon antaŭ la Eternulo; ĝi estas fajrofero por la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kaj prenu la brustaĵon de la virŝafo de konsekrado de Aaron, kaj skuu ĝin kiel skuoferon antaŭ la Eternulo; kaj tio estos via parto. ");
INSERT INTO epo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Kaj sanktigu la brustaĵon de skuado kaj la femuron de levado, kiuj estis skuitaj kaj levitaj el la virŝafo de konsekrado de Aaron kaj de liaj filoj; ");
INSERT INTO epo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","kaj tio estu por Aaron kaj por liaj filoj porĉiama destinitaĵo de la Izraelidoj; ĉar ĝi estas levofero, kaj levofero ĝi estu de la Izraelidoj, el iliaj pacoferoj ilia levofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Kaj la sanktaj vestoj de Aaron estu por liaj filoj post li, por ke ili estu sanktoleataj en ili kaj por ke ili estu konsekrataj en ili. ");
INSERT INTO epo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Dum sep tagoj portu ilin sur si tiu el liaj filoj, kiu estos pastro anstataŭ li, kaj kiu venos en la tabernaklon de kunveno, por servi en la sanktejo. ");
INSERT INTO epo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Kaj la virŝafon de konsekrado prenu, kaj kuiru ĝian viandon sur sankta loko. ");
INSERT INTO epo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kaj Aaron kaj liaj filoj manĝu la viandon de la virŝafo, kaj la panon, kiu estas en la korbo, ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kaj ili tion manĝu, ĉar per tio ili puriĝis, por ke ili estu konsekritaj kaj por ke ili estu sanktigitaj. Laiko tion ne manĝu, ĉar tio estas sankta. ");
INSERT INTO epo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Se el la viando de konsekrado kaj el la pano restos iom ĝis la mateno, tiam forbruligu la restaĵon per fajro; ĝi ne estu manĝata, ĉar ĝi estas sankta. ");
INSERT INTO epo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Kaj agu kun Aaron kaj kun liaj filoj tiel, kiel Mi ĉion ordonis al vi; dum sep tagoj konsekru ilin. ");
INSERT INTO epo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kaj propekan bovidon oferu ĉiutage por senpekiĝo; kaj senpekigu la altaron, oferante sur ĝi, kaj oleu ĝin, por ĝin sanktigi. ");
INSERT INTO epo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Dum sep tagoj senpekigu la altaron kaj sanktigu ĝin; kaj la altaro fariĝu plejsanktaĵo; ĉio, kio ektuŝos la altaron, fariĝos sankta. ");
INSERT INTO epo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Jen tio, kion vi metos sur la altaron: du jaraĝajn ŝafidojn ĉiutage, ĉiam; ");
INSERT INTO epo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","unu ŝafidon oferu matene, kaj la duan ŝafidon oferu ĉirkaŭ la vespero; ");
INSERT INTO epo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","kaj por unu ŝafido dekonon de efo da delikata faruno, miksita kun kvarono de hino da elpistita oleo, kaj kvaronon de hino da vino por verŝoferi. ");
INSERT INTO epo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","La duan ŝafidon oferu ĉirkaŭ la vespero; faru kun ĝi kiel kun la matena donofero kaj verŝofero, ke ĝi estu agrabla odoraĵo, fajrofero por la Eternulo, ");
INSERT INTO epo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ĉiama brulofero en viaj generacioj ĉe la pordo de la tabernaklo de kunveno antaŭ la Eternulo, kie Mi aperados antaŭ vi, por paroli tie kun vi. ");
INSERT INTO epo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Kaj Mi aperados tie antaŭ la Izraelidoj, kaj la loko sanktiĝos per Mia gloro. ");
INSERT INTO epo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Kaj Mi sanktigos la tabernaklon de kunveno kaj la altaron; kaj Aaronon kaj liajn filojn Mi sanktigos, por ke ili estu Miaj pastroj. ");
INSERT INTO epo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Kaj Mi loĝos inter la Izraelidoj, kaj Mi estos por ili Dio. ");
INSERT INTO epo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kaj ili sciu, ke Mi estas la Eternulo, ilia Dio, kiu elirigis ilin el la lando Egipta, por ke Mi loĝu inter ili, Mi, la Eternulo, ilia Dio. ");
INSERT INTO epo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Kaj faru altaron, por fumigi incenson; el akacia ligno faru ĝin. ");
INSERT INTO epo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Unu ulno estu ĝia longo, kaj unu ulno ĝia larĝo; ĝi estu kvarangula; kaj du ulnoj estu ĝia alto; kornoj elstaru el ĝi. ");
INSERT INTO epo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kaj tegu ĝin per pura oro, ĝian supran platon kaj ĝiajn flankojn ĉirkaŭe kaj ĝiajn kornojn; kaj faru al ĝi oran kronon ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kaj du orajn ringojn faru al ĝi sub ĝia krono, sur ĝiaj du lateroj; sur du flankoj faru ilin; kaj ili estu ingoj por stangoj, per kiuj oni portu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kaj faru la stangojn el akacia ligno, kaj tegu ilin per oro. ");
INSERT INTO epo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kaj starigu ĝin antaŭ la kurteno, kiu estas antaŭ la kesto de atesto, kontraŭ la fermoplato de la kesto de atesto, kie Mi aperados al vi. ");
INSERT INTO epo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kaj Aaron incensadu sur ĝi aroman incenson; ĉiumatene, kiam li ordigos la lucernojn, li incensu. ");
INSERT INTO epo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kaj kiam Aaron ekbruligos la lucernojn ĉirkaŭ vespero, li incensu; ĝi estu ĉiama incensado antaŭ la Eternulo en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ne alportu sur ĝi incenson alian, nek bruloferon nek donoferon, kaj verŝoferon ne verŝu sur ĝin. ");
INSERT INTO epo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kaj ĉiopardonan oferon Aaron alportos sur ĝiaj kornoj unu fojon en la jaro; el la sango de la ĉiopardona pekofero unu fojon en jaro li alportu sur ĝi ĉiopardonan oferon en viaj generacioj; tio estos plej granda sanktaĵo antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Kiam vi kalkulos la kapojn de la Izraelidoj, tiam ĉiu donu liberigan pagon por sia animo al la Eternulo, kiam ili estos kalkulataj; kaj tiam ne estos inter ili epidemio dum la kalkulado. ");
INSERT INTO epo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Jen kion devas doni ĉiu, kiu pasas la kalkulon: duonon de siklo laŭ la grandeco de la sankta siklo (siklo enhavas dudek gerojn); duono de siklo estu oferdono por la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ĉiu, kiu pasas la kalkulon, de la aĝo de dudek jaroj kaj pli, devas doni la oferdonon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","La riĉulo ne donu pli kaj la malriĉulo ne donu malpli ol duonon de siklo, donante la oferdonon por la Eternulo, por liberigi viajn animojn. ");
INSERT INTO epo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kaj prenu la monon de la liberigo de la Izraelidoj kaj uzu ĝin por la servado en la tabernaklo de kunveno, kaj tio estos por la Izraelidoj kiel memorigaĵo antaŭ la Eternulo, por liberigi viajn animojn. ");
INSERT INTO epo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Faru kupran lavujon kun kupra piedestalo, por lavado; kaj starigu ĝin inter la tabernaklo de kunveno kaj la altaro, kaj enverŝu tien akvon. ");
INSERT INTO epo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Kaj Aaron kaj liaj filoj lavu per ĝi siajn manojn kaj piedojn: ");
INSERT INTO epo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","kiam ili iros en la tabernaklon de kunveno, ili lavu sin per akvo, por ke ili ne mortu; aŭ kiam ili alproksimiĝos al la altaro, por servi, por incensi fajroferon al la Eternulo, ");
INSERT INTO epo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ili lavu siajn manojn kaj piedojn, por ke ili ne mortu; kaj tio estu por ili leĝo eterna, por li kaj por lia idaro en iliaj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Plue la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Prenu al vi plej bonajn aromaĵojn: da bonodora mirho kvincent siklojn, kaj da aroma cinamo duonon de tio, ducent kvindek, kaj da aroma kano ducent kvindek, ");
INSERT INTO epo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kaj da kasio kvincent siklojn laŭ la mezuro de la sankta siklo, kaj da olivoleo unu hinon. ");
INSERT INTO epo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kaj faru el tio oleon por sanktoleado, kunmetitan ŝmiraĵon laŭ la arto de la ŝmiraĵisto; ĝi estu oleo por sanktoleado. ");
INSERT INTO epo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kaj sanktoleu per ĝi la tabernaklon de kunveno kaj la keston de atesto, ");
INSERT INTO epo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","kaj la tablon kaj ĉiujn ĝiajn apartenaĵojn, kaj la kandelabron kaj ĝiajn apartenaĵojn, kaj la altaron de incensado, ");
INSERT INTO epo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kaj la altaron de bruloferoj kaj ĉiujn ĝiajn apartenaĵojn, kaj la lavujon kaj ĝian piedestalon. ");
INSERT INTO epo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kaj sanktigu ilin, ke ili fariĝu plejsanktaĵo; ĉiu, kiu ektuŝos ilin, sanktiĝos. ");
INSERT INTO epo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Kaj Aaronon kaj liajn filojn sanktoleu, kaj sanktigu ilin, ke ili estu Miaj pastroj. ");
INSERT INTO epo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kaj al la Izraelidoj diru jene: Tio estu por Mi oleo de sanktoleado en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Sur homan karnon ĝi ne estu verŝata, kaj laŭ ĝia konsisto ne faru ion similan; ĝi estas sankta, ĝi estu sankta por vi. ");
INSERT INTO epo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Se iu konsistigos ion similan kaj ŝmiros per ĝi laikon, li ekstermiĝu el sia popolo. ");
INSERT INTO epo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kaj la Eternulo diris al Moseo: Prenu al vi aromaĵon: balzamon kaj stakton kaj galbanon bonodoran kaj puran olibanon, po egalaj partoj el ĉio; ");
INSERT INTO epo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","kaj faru el tio incensaĵon kunmetitan laŭ la arto de la ŝmiraĵisto, bone frotmiksitan, puran, sanktan. ");
INSERT INTO epo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Kaj pistu el tio subtilan pulvoron, kaj metu iom el ĝi antaŭ la keston de atesto en la tabernaklo de kunveno, kie Mi aperados al vi; plejsanktaĵo ĝi estu por vi. ");
INSERT INTO epo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kaj laŭ la incensaĵo, kiun vi faros, ne faru al vi alian similan; sankta ĝi estu al vi por la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Se iu faros ion similan, por odorigi per ĝi, li ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Jen, Mi vokis per la nomo Becalelon, filon de Uri, filo de Ĥur, el la tribo de Jehuda; ");
INSERT INTO epo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","kaj Mi plenigis lin per Dia spirito, per saĝo kaj prudento kaj scio kaj ĉia arto, ");
INSERT INTO epo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","por pripensi ideojn, por labori el oro kaj el arĝento kaj el kupro, ");
INSERT INTO epo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kaj por ĉizi ŝtonojn por enkadrigo, kaj por ĉizi lignon, por fari ĉian laboron. ");
INSERT INTO epo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Kaj jen Mi donis al li kiel helpanton Oholiabon, filon de Aĥisamaĥ, el la tribo de Dan; kaj en la koron de ĉiu kompetentulo Mi enmetis saĝon, por ke ili faru ĉion, kion Mi ordonis al vi: ");
INSERT INTO epo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","la tabernaklon de kunveno kaj la keston de atesto kaj la fermoplaton sur ĝi kaj ĉiujn apartenaĵojn de la tabernaklo, ");
INSERT INTO epo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","kaj la tablon kaj ĝiajn apartenaĵojn kaj la puran kandelabron kaj ĉiujn ĝiajn apartenaĵojn kaj la altaron de incensado, ");
INSERT INTO epo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kaj la altaron de bruloferoj kaj ĉiujn ĝiajn apartenaĵojn kaj la lavujon kaj ĝian piedestalon, ");
INSERT INTO epo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","kaj la oficajn vestojn kaj la sanktajn vestojn por la pastro Aaron kaj la pastrajn vestojn de liaj filoj, ");
INSERT INTO epo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","kaj la sanktan oleon kaj la aroman incensaĵon por la sanktejo; ĉion konforme al tio, kiel Mi ordonis al vi, ili faros. ");
INSERT INTO epo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Diru al la Izraelidoj jene: Nepre observu Miajn sabatojn; ĉar tio estas signo inter Mi kaj vi en viaj generacioj, por ke vi sciu, ke Mi estas la Eternulo, kiu vin sanktigas. ");
INSERT INTO epo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kaj observu la sabaton, ĉar ĝi estas sankta por vi; kiu ĝin malsanktigos, tiu mortu; ĉar se iu faros en ĝi laboron, tiu animo ekstermiĝu el la mezo de sia popolo. ");
INSERT INTO epo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Dum ses tagoj oni faru laboron, sed la sepan tagon estas sabato de ripozo, sankta por la Eternulo; ĉiu, kiu faros laboron en la tago sabata, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kaj la Izraelidoj observu la sabaton, por fari la sabaton en siaj generacioj eterna interligo. ");
INSERT INTO epo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Inter Mi kaj la Izraelidoj ĝi estu signo por ĉiam; ĉar dum ses tagoj la Eternulo faris la ĉielon kaj la teron, sed en la sepa tago Li ĉesis kaj ripozis. ");
INSERT INTO epo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kaj, fininte paroli al li sur la monto Sinaj, la Eternulo donis al Moseo du tabelojn de atesto, tabelojn ŝtonajn, skribitajn per la fingro de Dio. ");
INSERT INTO epo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kiam la popolo vidis, ke Moseo longe ne malsuprenvenas de la monto, la popolo kolektiĝis antaŭ Aaron, kaj diris al li: Leviĝu, faru al ni diojn, kiuj irus antaŭ ni; ĉar pri tiu Moseo, la viro, kiu elkondukis nin el la lando Egipta, ni ne scias, kio fariĝis kun li. ");
INSERT INTO epo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Tiam diris al ili Aaron: Elprenu la orajn orelringojn, kiuj estas en la oreloj de viaj edzinoj, de viaj filoj, kaj de viaj filinoj, kaj alportu al mi. ");
INSERT INTO epo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kaj la tuta popolo elprenis la orajn orelringojn, kiuj estis en iliaj oreloj, kaj alportis al Aaron. ");
INSERT INTO epo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kaj li prenis tion el iliaj manoj kaj formis ĝin per ĉizilo kaj faris el ĝi fanditan bovidon. Kaj ili diris: Jen estas viaj dioj, ho Izrael, kiuj elirigis vin el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kiam Aaron tion vidis, li konstruis altaron antaŭ ĝi; kaj Aaron proklamis kaj diris: Morgaŭ estos festo de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kaj ili leviĝis frue la sekvantan tagon kaj oferis bruloferojn kaj alportis pacoferojn; kaj la popolo sidiĝis, por manĝi kaj trinki, kaj ili leviĝis, por ludi. ");
INSERT INTO epo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Tiam la Eternulo diris al Moseo: Iru, iru malsupren; ĉar malvirtiĝis via popolo, kiun vi elkondukis el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Rapide ili forflankiĝis de la vojo, kiun Mi ordonis al ili; ili faris al si fanditan bovidon kaj adorkliniĝis al ĝi kaj alportis al ĝi oferojn, kaj diris: Jen estas viaj dioj, ho Izrael, kiuj elirigis vin el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Kaj la Eternulo diris al Moseo: Mi vidas ĉi tiun popolon, ĝi estas popolo malmolnuka. ");
INSERT INTO epo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Lasu do Min, kaj ekflamos Mia kolero kontraŭ ilin, kaj Mi ilin ekstermos, kaj Mi faros vin granda popolo. ");
INSERT INTO epo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Sed Moseo ekpetegis la Eternulon, sian Dion, kaj diris: Por kio, ho Eternulo, Via kolero estas ekflamonta kontraŭ Vian popolon, kiun Vi elirigis el la lando Egipta per granda forto kaj per potenca mano? ");
INSERT INTO epo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Por kio la Egiptoj diru: Por malbono Li elirigis ilin, por mortigi ilin en la montoj kaj por ekstermi ilin de sur la tero? Forlasu Vian flaman koleron kaj fordecidu la malbonon kontraŭ Via popolo. ");
INSERT INTO epo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Rememoru Abrahamon, Isaakon, kaj Izraelon, Viajn sklavojn, al kiuj Vi ĵuris per Vi, kaj al kiuj Vi diris: Mi multigos vian semon kiel la steloj de la ĉielo, kaj la tutan tiun landon, pri kiu Mi parolis, Mi donos al viaj idoj, kaj ili posedos ĝin eterne. ");
INSERT INTO epo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kaj la Eternulo fordecidis la malbonon, pri kiu Li diris, ke Li faros ĝin al Sia popolo. ");
INSERT INTO epo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moseo sin returnis kaj malsupreniris de la monto, kaj la du tabeloj de atesto estis en liaj manoj, tabeloj, sur kiuj estis skribite ambaŭflanke; sur unu flanko kaj sur la alia estis skribite sur ili. ");
INSERT INTO epo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kaj la tabeloj estis faritaĵo de Dio, kaj la skribo estis skribo de Dio, gravurita sur la tabeloj. ");
INSERT INTO epo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kaj Josuo aŭdis la bruon de la popolo ĝojkrianta, kaj li diris al Moseo: Bruo de batalo estas en la tendaro. ");
INSERT INTO epo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Sed tiu diris: Tio ne estas kriado de venko, nek kriado de malvenko, sed bruon de kantantoj mi aŭdas. ");
INSERT INTO epo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Kiam li alproksimiĝis al la tendaro kaj ekvidis la bovidon kaj la dancadon, tiam ekflamis la kolero de Moseo, kaj li forĵetis el siaj manoj la tabelojn kaj disrompis ilin sub la monto. ");
INSERT INTO epo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kaj li prenis la bovidon, kiun ili faris, kaj disbruligis ĝin per fajro kaj disfrakasis ĝis pulvoreco kaj disŝutis sur akvo kaj trinkigis ĝin al la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kaj Moseo diris al Aaron: Kion faris al vi ĉi tiu poplo, ke vi venigis sur ĝin grandan pekon? ");
INSERT INTO epo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Kaj Aaron diris: Ne ekflamu la kolero de mia sinjoro; vi scias, ke la popolo havas inklinon al malbono; ");
INSERT INTO epo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ili diris al mi: Faru al ni diojn, kiuj irus antaŭ ni; ĉar pri tiu Moseo, la viro, kiu elkondukis nin el la lando Egipta, ni ne scias, kio fariĝis kun li. ");
INSERT INTO epo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kaj mi diris al ili: Kiu havas oron, tiu deprenu ĝin; kaj ili donis al mi, kaj mi ĵetis ĝin en fajron, kaj eliris ĉi tiu bovido. ");
INSERT INTO epo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ĉar Moseo vidis, ke la popolo estas sendisciplina, ĉar Aaron sendisciplinigis ĝin ĝis honto antaŭ la malamikoj, ");
INSERT INTO epo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","tial Moseo stariĝis ĉe la pordego de la tendaro, kaj diris: Kiu estas partiano de la Eternulo, tiu venu al mi. Kaj kolektiĝis al li ĉiuj idoj de Levi. ");
INSERT INTO epo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kaj li diris al ili: Tiel diris la Eternulo, la Dio de Izrael: Metu ĉiu sian glavon sur sian femuron, trairu tien kaj reen de pordego ĝis pordego tra la tendaro, kaj ĉiu mortigu sian fraton, sian amikon, sian proksimulon. ");
INSERT INTO epo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Kaj la idoj de Levi faris, kiel diris Moseo; kaj estis mortigitaj el la popolo en tiu tago ĉirkaŭ tri mil homoj. ");
INSERT INTO epo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kaj Moseo diris: Konsekru vin hodiaŭ al la Eternulo, ĉiu sur sia filo kaj sur sia frato, por ke estu donata al vi hodiaŭ beno. ");
INSERT INTO epo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","La sekvantan tagon Moseo diris al la popolo: Vi pekis per granda peko; nun mi supreniros al la Eternulo, eble mi akiros pardonon por via peko. ");
INSERT INTO epo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kaj Moseo revenis al la Eternulo, kaj diris: Ho ve! tiu popolo pekis per granda peko kaj faris al si orajn diojn; ");
INSERT INTO epo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","nun volu pardoni ilian pekon; kaj se ne, tiam volu elstreki min el Via libro, kiun Vi skribis. ");
INSERT INTO epo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Sed la Eternulo diris al Moseo; Kiu ajn pekis antaŭ Mi, tiun Mi elstrekos el Mia libro. ");
INSERT INTO epo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kaj nun iru, konduku la popolon tien, kien Mi diris al vi. Jen Mia anĝelo iros antaŭ vi; kaj en la tago de Mia rememorigado Mi rememorigos sur ili ilian pekon. ");
INSERT INTO epo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kaj la Eternulo frapis la popolon pro tio, ke ili faris la bovidon, kiun faris Aaron. ");
INSERT INTO epo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kaj la Eternulo diris al Moseo: Iru, eliru el ĉi tie, vi kaj la popolo, kiun vi elkondukis el la lando Egipta, al la lando, pri kiu Mi ĵuris al Abraham, al Isaak, kaj al Jakob, dirante: Al via idaro Mi ĝin donos. ");
INSERT INTO epo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Kaj Mi sendos antaŭ vi anĝelon, kaj Mi forpelos la Kanaanidojn, la Amoridojn kaj la Ĥetidojn kaj la Perizidojn, la Ĥividojn kaj la Jebusidojn. ");
INSERT INTO epo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Iru al lando, en kiu fluas lakto kaj mielo. Mi ne iros meze de vi; ĉar vi estas popolo malmolnuka, kaj Mi eble ekstermus vin dum la vojo. ");
INSERT INTO epo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kaj la popolo aŭdis tiun malbonan sciigon, kaj ili ekfunebris, kaj neniu metis sur sin siajn ornamaĵojn. ");
INSERT INTO epo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kaj la Eternulo diris al Moseo: Diru al la Izraelidoj: Vi estas popolo malmolnuka; se Mi nur unu momenton irus meze de vi, Mi vin ekstermus; nun demetu de vi viajn ornamaĵojn, kaj Mi rigardos, kion Mi faru kun vi. ");
INSERT INTO epo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kaj la Izraelidoj demetis de si siajn ornamaĵojn antaŭ la monto Ĥoreb. ");
INSERT INTO epo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moseo prenis la tabernaklon, kaj starigis ĝin ekster la tendaro, malproksime de la tendaro, kaj nomis ĝin Tabernaklo de Kunveno; kaj ĉiu, kiu volis peti la Eternulon, devis eliri al la tabernaklo de kunveno, kiu estis ekstere de la tendaro. ");
INSERT INTO epo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kaj kiam Moseo eliradis al la tabernaklo, la tuta popolo leviĝadis, kaj ĉiu stariĝadis ĉe la pordo de sia tendo kaj rigardadis post Moseo, ĝis li eniris en la tabernaklon. ");
INSERT INTO epo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kaj kiam Moseo eniradis en la tabernaklon, malleviĝadis nuba kolono kaj stariĝadis ĉe la pordo de la tabernaklo kaj paroladis kun Moseo. ");
INSERT INTO epo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kaj la tuta popolo vidadis la nuban kolonon, kiu staris ĉe la pordo de la tabernaklo; kaj la tuta popolo leviĝadis kaj adorkliniĝadis ĉiu ĉe la pordo de sia tendo. ");
INSERT INTO epo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kaj la Eternulo paroladis kun Moseo vizaĝon kontraŭ vizaĝo, kiel parolas homo kun sia amiko. Kaj kiam li reiradis en la tendaron, tiam lia servanto Josuo, filo de Nun, junulo, ne foriĝadis el la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kaj Moseo diris al la Eternulo: Vidu, Vi diras al mi: Konduku ĉi tiun popolon; kaj Vi ne sciigis al mi, kiun Vi sendos kun mi, kvankam Vi diris: Mi konas vin laŭ via nomo, kaj vi akiris Mian favoron. ");
INSERT INTO epo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nun, se mi akiris Vian favoron, volu sciigi al mi Vian vojon, por ke mi konu Vin, por akiri Vian favoron; kaj vidu, ke ĉi tiu popolo estas Via popolo. ");
INSERT INTO epo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Tiam Li diris: Mia vizaĝo iros antaŭe, kaj Mi donos al vi ripozon. ");
INSERT INTO epo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kaj li diris al Li: Se Via vizaĝo ne iros, tiam ne forkonduku nin de ĉi tie. ");
INSERT INTO epo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Per kio do montriĝos, ke mi kaj Via popolo akiris Vian favoron? ĉu ne per tio, ke Vi irados kun ni? tiam mi kaj Via popolo distingiĝos de ĉiu popolo, kiu estas sur la tero. ");
INSERT INTO epo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Kaj la Eternulo diris al Moseo: Ankaŭ tion, kion vi diris, Mi faros; ĉar vi akiris Mian favoron kaj Mi konas vin laŭ via nomo. ");
INSERT INTO epo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Kaj li diris: Volu montri al mi Vian gloron. ");
INSERT INTO epo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kaj Li diris: Mi preterpasigos antaŭ vi Mian tutan bonecon, kaj Mi alvokos la nomon de la Eternulo antaŭ vi; kaj Mi favorkoros tiun, kiun Mi favorkoros, kaj Mi kompatos tiun, kiun Mi kompatos. ");
INSERT INTO epo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kaj Li diris: Vi ne povas vidi Mian vizaĝon, ĉar ne povas homo vidi Min kaj resti viva. ");
INSERT INTO epo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kaj la Eternulo diris: Jen estas loko ĉe Mi; stariĝu sur la roko. ");
INSERT INTO epo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kaj kiam preteriros Mia gloro, Mi metos vin en fendon de la roko, kaj Mi ŝirmos vin per Mia mano, ĝis Mi pasos. ");
INSERT INTO epo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kaj kiam Mi formetos Mian manon, vi vidos Mian malantaŭan flankon, sed Mia vizaĝo ne estos videbla. ");
INSERT INTO epo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kaj la Eternulo diris al Moseo: Skulptu al vi du ŝtonajn tabelojn kiel la unuaj; kaj Mi skribos sur la tabeloj la vortojn, kiuj estis sur la unuaj tabeloj, kiujn vi rompis. ");
INSERT INTO epo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kaj estu preta por la mateno, kaj supreniru matene sur la monton Sinaj kaj stariĝu antaŭ Mi tie sur la pinto de la monto. ");
INSERT INTO epo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kaj neniu supreniru kun vi, kaj ankaŭ neniu montriĝu sur la tuta monto; eĉ ŝafo aŭ bovo ne paŝtiĝu antaŭ tiu monto. ");
INSERT INTO epo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kaj li skulptis du ŝtonajn tabelojn kiel la unuaj; kaj Moseo leviĝis frue matene kaj supreniris sur la monton Sinaj, kiel ordonis al li la Eternulo, kaj li prenis en siajn manojn la du ŝtonajn tabelojn. ");
INSERT INTO epo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kaj la Eternulo malleviĝis en nubo, kaj Moseo stariĝis apud Li tie kaj alvokis la nomon de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kaj la Eternulo preteriris antaŭ li, kaj li ekkriis: Eternulo, Eternulo, Dio indulgema kaj kompatema, multepacienca, favorkora, kaj verema; ");
INSERT INTO epo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","kiu konservas favorkorecon por miloj, pardonas kulpon kaj krimon kaj pekon, sed antaŭ kiu neniu estas senkulpa; kiu punas la kulpon de patroj sur filoj kaj nepoj, en la tria kaj kvara generacioj! ");
INSERT INTO epo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Kaj rapide Moseo kliniĝis ĝis la tero kaj faris adoron. ");
INSERT INTO epo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Kaj li diris: Ho, se mi akiris Vian favoron, mia Sinjoro, tiam mia Sinjoro volu iri en nia mezo, ĉar tio estas popolo malmolnuka; kaj pardonu niajn kulpojn kaj niajn pekojn kaj faru nin Via posedaĵo. ");
INSERT INTO epo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kaj Li diris: Jen Mi faros interligon; antaŭ via tuta popolo Mi faros miraklojn, kiuj neniam ekzistis sur la tuta tero nek ĉe iuj gentoj; kaj la tuta popolo, en kies mezo vi estas, vidos la faron de la Eternulo; ĉar terura estos tio, kion Mi faros por vi. ");
INSERT INTO epo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observu tion, kion Mi ordonas al vi hodiaŭ. Jen Mi forpelas antaŭ vi la Amoridojn kaj la Kanaanidojn kaj la Ĥetidojn kaj la Perizidojn kaj la Ĥividojn kaj la Jebusidojn. ");
INSERT INTO epo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Gardu vin, ke vi ne faru interligon kun la loĝantoj de la lando, en kiun vi venos, por ke tio ne fariĝu falilo inter vi; ");
INSERT INTO epo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","sed iliajn altarojn detruu kaj iliajn statuojn rompu kaj iliajn sanktajn stangojn dishaku. ");
INSERT INTO epo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ĉar vi ne devas adori alian dion; ĉar la Eternulo, koleremulo estas Lia nomo, estas Dio kolerema. ");
INSERT INTO epo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ne faru interligon kun la loĝantoj de la lando; ĉar, malĉastante kun siaj dioj kaj alportante oferojn al siaj dioj, ili eble vokos vin kaj vi manĝos de iliaj oferoj, ");
INSERT INTO epo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","kaj vi prenos iliajn filinojn por viaj filoj, kaj iliaj filinoj malĉastos por siaj dioj kaj malĉastigos viajn filojn por siaj dioj. ");
INSERT INTO epo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Diojn fanditajn ne faru al vi. ");
INSERT INTO epo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","La feston de macoj observu; dum sep tagoj manĝu macojn, kiel Mi ordonis al vi, en la difinita tempo de la monato Abib, ĉar en la monato Abib vi eliris el Egiptujo. ");
INSERT INTO epo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ĉio, kio malfermas unue la uteron, apartenas al mi; ĉiu virseksulo el viaj brutoj, kiu malfermas unue la uteron, bovo aŭ ŝafo. ");
INSERT INTO epo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Utermalferminton el azenoj elaĉetu per ŝafido: kaj se vi ne elaĉetos, tiam rompu al ĝi la kolon. La unuenaskiton el viaj filoj elaĉetu. Kaj oni ne montriĝu antaŭ Mi kun malplenaj manoj. ");
INSERT INTO epo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Dum ses tagoj laboru, kaj en la sepa tago ripozu; en la tempo de la plugado kaj de la rikoltado ripozu. ");
INSERT INTO epo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Kaj feston de semajnoj faru al vi en la komenco de la rikoltado de tritiko, kaj feston de kolektado de fruktoj en la fino de la jaro. ");
INSERT INTO epo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tri fojojn en la jaro ĉiuj viaj virseksuloj aperu antaŭ la Sinjoro, la Eternulo, Dio de Izrael. ");
INSERT INTO epo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ĉar Mi forpelos gentojn antaŭ vi kaj vastigos viajn limojn, kaj neniu deziros havi vian landon, kiam vi iros, por montriĝi antaŭ la Eternulo, via Dio, tri fojojn en la jaro. ");
INSERT INTO epo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ne buĉverŝu sur fermentintaĵon la sangon de Mia ofero, kaj ne devas resti ĝis mateno la ofero de la festo de Pasko. ");
INSERT INTO epo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","La komencaĵon de la unuaj produktoj de via tero alportu en la domon de la Eternulo, via Dio. Ne kuiru kapridon en la lakto de ĝia patrino. ");
INSERT INTO epo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kaj la Eternulo diris al Moseo: Skribu al vi ĉi tiujn vortojn, ĉar laŭ ĉi tiuj vortoj Mi faris interligon kun vi kaj kun Izrael. ");
INSERT INTO epo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Kaj li estis tie kun la Eternulo kvardek tagojn kaj kvardek noktojn; panon li ne manĝis kaj akvon li ne trinkis; kaj li skribis sur la tabeloj la vortojn de la interligo, la dek ordonojn. ");
INSERT INTO epo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kiam Moseo estis malsupreniranta de la monto Sinaj kaj la du tabeloj de atesto estis en la manoj de Moseo dum lia malsuprenirado de la monto, Moseo ne sciis, ke la haŭto de lia vizaĝo lumradiis pro tio, ke li parolis kun Li. ");
INSERT INTO epo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Kaj Aaron kaj ĉiuj Izraelidoj ekvidis Moseon, kaj jen la haŭto de lia vizaĝo lumradias; kaj ili timis alproksimiĝi al li. ");
INSERT INTO epo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Sed Moseo vokis ilin, kaj returniĝis al li Aaron kaj ĉiuj ĉefoj de la komunumo, kaj Moseo ekparolis al ili. ");
INSERT INTO epo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Poste alproksimiĝis ĉiuj Izraelidoj; kaj li ordonis al ili ĉion, kion diris al li la Eternulo sur la monto Sinaj. ");
INSERT INTO epo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kiam Moseo ĉesis paroli al ili, li metis sur sian vizaĝon kovrotukon. ");
INSERT INTO epo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kiam Moseo venadis antaŭ la Eternulon, por paroli kun Li, li formetadis la kovrotukon ĝis sia eliro; kaj elirinte, li diradis al la Izraelidoj tion, kio estis ordonita al li. ");
INSERT INTO epo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Kaj la Izraelidoj vidis, ke la haŭto de la vizaĝo de Moseo lumradias; kaj tiam Moseo denove metis la kovrotukon sur sian vizaĝon, ĝis li eniris, por paroli kun Li. ");
INSERT INTO epo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Kaj Moseo kunvenigis la tutan komunumon de la Izraelidoj, kaj diris al ili: Jen kion la Eternulo ordonis al vi fari: ");
INSERT INTO epo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Dum ses tagoj faru laboron, sed la sepa tago estu por vi sankta, sabato de ripozo al la Eternulo; ĉiu, kiu faros en ĝi laboron, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ne bruligu fajron en ĉiuj viaj loĝejoj en la tago sabata. ");
INSERT INTO epo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Kaj Moseo ekparolis al la tuta komunumo de la Izraelidoj, dirante: Jen kion ordonis la Eternulo: ");
INSERT INTO epo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Prenu inter vi oferdonon por la Eternulo: ĉiu memvole alportu la oferdonon por la Eternulo: oron kaj arĝenton kaj kupron, ");
INSERT INTO epo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kaj bluan teksaĵon kaj purpuran kaj ruĝan, kaj bisinon kaj kapran lanon, ");
INSERT INTO epo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kaj virŝafajn felojn ruĝe kolorigitajn, kaj antilopajn felojn, kaj akacian lignon, ");
INSERT INTO epo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","kaj oleon por lumigado, kaj aromaĵojn por la sankta oleo kaj por la bonodoraj incensoj, ");
INSERT INTO epo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kaj ŝtonojn oniksajn kaj ŝtonojn enkadrigeblajn por la efodo kaj por la surbrustaĵo. ");
INSERT INTO epo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Kaj ĉiu el vi, kiu estas kompetentulo, venu kaj faru ĉion, kion ordonis la Eternulo: ");
INSERT INTO epo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","la tabernaklon kaj ĝian tendon kaj ĝian kovron, ĝiajn hoketojn kaj ĝiajn tabulojn, ĝiajn riglilojn, ĝiajn kolonojn kaj ĝiajn bazojn; ");
INSERT INTO epo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","la keston kaj ĝiajn stangojn, la fermoplaton kaj la kurtenon; ");
INSERT INTO epo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la tablon kaj ĝiajn stangojn kaj ĉiujn ĝiajn apartenaĵojn kaj la panojn de propono; ");
INSERT INTO epo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kaj la kandelabron por lumigi kaj ĝiajn apartenaĵojn kaj ĝiajn lucernojn kaj la oleon por lumigi; ");
INSERT INTO epo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","kaj la altaron de incensado kaj ĝiajn stangojn kaj la sanktan oleon kaj la bonodoran incenson kaj la pordan kovrotukon antaŭ la pordo de la tabernaklo; ");
INSERT INTO epo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","la altaron de bruloferoj kaj ĝian kupran kradon, ĝiajn stangojn kaj ĉiujn ĝiajn apartenaĵojn, la lavujon kaj ĝian piedestalon; ");
INSERT INTO epo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","la kurtenojn de la korto, ĝiajn kolonojn kaj bazojn kaj la kovrotukon de la pordego de la korto; ");
INSERT INTO epo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","la najlojn de la tabernaklo kaj la najlojn de la korto kaj iliajn ŝnurojn; ");
INSERT INTO epo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","la oficajn vestojn por servado en la sanktejo, la sanktajn vestojn por la pastro Aaron kaj la pastrajn vestojn de liaj filoj. ");
INSERT INTO epo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kaj la tuta komunumo de la Izraelidoj eliris de antaŭ Moseo. ");
INSERT INTO epo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Kaj venis ĉiuj homoj, kiujn tiris la koro; kaj ĉiu, kiun inklinigis lia spirito, alportis la oferdonon por la Eternulo, por la aranĝo de la tabernaklo de kunveno kaj por ĝia tuta servado kaj por la sanktaj vestoj. ");
INSERT INTO epo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Kaj venis la viroj kaj la virinoj; ĉiuj, kiujn inklinigis la koro, alportis bukojn kaj orelringojn kaj ringojn kaj kolringojn, diversajn orajn objektojn; kaj ĉiu alportis oran oferdonon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kaj ĉiu, ĉe kiu troviĝis blua teksaĵo, aŭ purpura, aŭ ruĝa, aŭ bisino, aŭ kapra lano, aŭ ŝafaj feloj ruĝaj, aŭ antilopaj feloj, alportis. ");
INSERT INTO epo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ĉiu, kiu oferis arĝenton aŭ kupron, alportis la oferdonon por la Eternulo; kaj ĉiu, ĉe kiu troviĝis akacia ligno por ĉia bezono de la servado, alportis ĝin. ");
INSERT INTO epo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kaj ĉiu virino, kiu havis ian kompetentecon, ŝpinis kaj alportis ŝpinitan lanon bluan kaj purpuran kaj ruĝan kaj bisinon. ");
INSERT INTO epo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kaj ĉiuj virinoj, kiuj havis deziron kaj kompetentecon, ŝpinis kapran lanon. ");
INSERT INTO epo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Kaj la princoj alportis ŝtonojn oniksajn kaj ŝtonojn enkadrigeblajn por la efodo kaj por la surbrustaĵo, ");
INSERT INTO epo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","kaj la aromaĵon kaj la oleon por lumigi kaj por la sankta oleo kaj por la bonodoraj incensoj. ");
INSERT INTO epo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ĉiu viro kaj virino el la Izraelidoj, kiujn inklinigis ilia koro alporti por ĉia laboro, kiun la Eternulo per Moseo ordonis fari, alportis oferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kaj Moseo diris al la Izraelidoj: Jen, la Eternulo vokis per la nomo Becalelon, filon de Uri, filo de Ĥur, el la tribo de Jehuda; ");
INSERT INTO epo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","kaj Li plenigis lin per Dia spirito, per saĝo kaj prudento, kaj scio kaj per ĉia arto, ");
INSERT INTO epo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","por pripensi ideojn, por labori el oro kaj el arĝento kaj el kupro, ");
INSERT INTO epo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kaj por ĉizi ŝtonojn por enkadrigo, kaj por ĉizi lignon, por fari ĉian artistan laboron. ");
INSERT INTO epo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kaj Li donis al li la kapablon instrui, al li kaj al Oholiab, filo de Aĥisamaĥ, el la tribo de Dan. ");
INSERT INTO epo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Li plenigis ilin per kompetenteco por farado de ĉia majstra laboro, por ĉia talenta brodado sur teksaĵo blua kaj purpura kaj ruĝa kaj sur bisino, por teksado de ĉia laboraĵo kaj pripensado de ideoj. ");
INSERT INTO epo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kaj laboros Becalel kaj Oholiab kaj ĉiuj kompetentuloj, en kiujn la Eternulo enmetis saĝon kaj prudenton, por ke ili sciu fari ĉiun laboron por la servado en la sanktejo, laŭ ĉio, kion ordonis la Eternulo. ");
INSERT INTO epo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kaj Moseo alvokis Becalelon kaj Oholiabon, kaj ĉiun kompetentulon, al kiu la Eternulo enmetis saĝon en la koron, ĉiun, kiun tiris lia koro entrepreni la laboron kaj fari ĝin. ");
INSERT INTO epo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Kaj ili prenis de Moseo ĉiujn oferdonojn, kiujn alportis la Izraelidoj por la bezonoj de la servado en la sanktejo, por ellabori ilin. Kaj tiuj alportadis al li ankoraŭ plue oferdonojn ĉiumatene. ");
INSERT INTO epo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kaj venis ĉiuj saĝuloj, kiuj estis farantaj la tutan laboron por la sanktejo, ĉiu venis de sia laboro, kiun li faris. ");
INSERT INTO epo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Kaj ili diris al Moseo jene: La popolo alportas pli multe, ol bezonas la laboroj, kiujn la Eternulo ordonis fari. ");
INSERT INTO epo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Tiam Moseo ordonis, kaj oni elkriis en la tendaro jene: Neniu viro kaj neniu virino faru plue laboraĵon, por oferdoni al la sanktejo. Kaj la popolo ĉesis alporti. ");
INSERT INTO epo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Kaj la alportitaĵo estis sufiĉa por la tuta farota laboro, kaj eĉ superflua. ");
INSERT INTO epo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Kaj ĉiuj kompetentuloj inter tiuj, kiuj estis farantaj la laboron por la tabernaklo, faris dek tapiŝojn el tordita bisino kaj el blua, purpura, kaj ruĝa teksaĵo; kerubojn artiste laboritajn ili faris sur ili. ");
INSERT INTO epo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longo de ĉiu tapiŝo estis dudek ok ulnoj, kaj la larĝo de ĉiu tapiŝo estis kvar ulnoj; unu mezuro estis por ĉiuj tapiŝoj. ");
INSERT INTO epo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Kaj li kunigis kvin tapiŝojn unu kun la alia, kaj la kvin ceterajn ankaŭ unu kun la alia. ");
INSERT INTO epo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kaj li faris maŝojn el blua teksaĵo sur la rando de unu tapiŝo, sur la rando de la kuniĝo; tiel same li faris sur la rando de la ekstrema tapiŝo, sur la dua rando de kuniĝo. ");
INSERT INTO epo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Kvindek maŝojn li faris sur unu tapiŝo, kaj kvindek maŝojn li faris sur la rando de tiu tapiŝo, sur kiu estis la dua flanko de la kuniĝo; la maŝoj estis reciproke aranĝitaj unu kontraŭ alia. ");
INSERT INTO epo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Kaj li faris kvindek orajn hoketojn, kaj li kunigis la tapiŝojn unu kun la alia per la hoketoj; kaj la tabernaklo fariĝis unu tutaĵo. ");
INSERT INTO epo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Kaj li faris tapiŝojn el kapra lano kiel kovron super la tabernaklo; dek unu tiajn tapiŝojn li faris. ");
INSERT INTO epo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longo de ĉiu tapiŝo estis tridek ulnoj, kaj kvar ulnoj estis la larĝo de ĉiu tapiŝo; unu mezuro estis por la dek unu tapiŝoj. ");
INSERT INTO epo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kaj li kunigis kvin tapiŝojn aparte kaj la ceterajn ses tapiŝojn aparte. ");
INSERT INTO epo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Kaj li faris kvindek maŝojn sur la rando de la ekstrema tapiŝo, sur la rando de la kuniĝo, kaj kvindek maŝojn li faris sur la rando de la dua kuniĝa tapiŝo. ");
INSERT INTO epo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Kaj li faris kvindek kuprajn hoketojn, por kunigi la tendon, por ke ĝi estu unu tutaĵo. ");
INSERT INTO epo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kaj li faris kovron por la tendo el ruĝaj virŝafaj feloj kaj ankoraŭ kovron el antilopaj feloj supre. ");
INSERT INTO epo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Kaj li faris la tabulojn por la tabernaklo, starantajn, el akacia ligno. ");
INSERT INTO epo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dek ulnoj estis la longo de ĉiu tabulo, kaj unu ulno kaj duono la larĝo de ĉiu tabulo. ");
INSERT INTO epo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ĉiu tabulo havis du pivotojn, alĝustigitajn unu al la alia; tiel li faris ĉe ĉiuj tabuloj de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Kaj li faris la tabulojn por la tabernaklo; dudek tabulojn sur la flanko suda. ");
INSERT INTO epo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Kaj kvardek arĝentajn bazojn li faris sub la dudek tabuloj, du bazojn sub ĉiu tabulo, por ĝiaj du pivotoj. ");
INSERT INTO epo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kaj sur la dua flanko de la tabernaklo, sur la flanko norda, li faris dudek tabulojn, ");
INSERT INTO epo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","kaj kvardek arĝentajn bazojn por ili, du bazojn sub ĉiu tabulo. ");
INSERT INTO epo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kaj sur la malantaŭa flanko de la tabernaklo, okcidente, li faris ses tabulojn. ");
INSERT INTO epo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Kaj du tabulojn li faris en la anguloj de la tabernaklo sur la malantaŭa flanko. ");
INSERT INTO epo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kaj ili estis kunigitaj malsupre kaj kunigitaj supre per unu ringo; tiel li faris kun ambaŭ en la du anguloj. ");
INSERT INTO epo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kaj estis ok tabuloj, kaj ĉe ili dek ses arĝentaj bazoj, po du bazoj sub ĉiu tabulo. ");
INSERT INTO epo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Kaj li faris riglilojn el akacia ligno: kvin por la tabuloj de unu flanko de la tabernaklo, ");
INSERT INTO epo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","kaj kvin riglilojn por la tabuloj de la dua flanko de la tabernaklo, kaj kvin riglilojn por la tabuloj de la malantaŭa flanko de la tabernaklo, okcidente. ");
INSERT INTO epo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kaj li faris mezan riglilon, kiu ŝoviĝis meze de la tabuloj de unu fino ĝis la alia. ");
INSERT INTO epo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Kaj la tabulojn li tegis per oro, kaj iliajn ringojn, ingojn por la rigliloj, li faris el oro, kaj la riglilojn li tegis per oro. ");
INSERT INTO epo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Kaj li faris la kurtenon el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino; per artista laboro li faris sur ĝi kerubojn. ");
INSERT INTO epo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Kaj li faris por ĝi kvar kolonojn el akacia ligno, kaj li tegis ilin per oro, kaj iliaj hoketoj estis el oro; kaj li fandis por ili kvar arĝentajn bazojn. ");
INSERT INTO epo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kaj li faris kovrotukon por la pordo de la tabernaklo, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino, kun brodaĵoj; ");
INSERT INTO epo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","kaj kvin kolonojn por ĝi kun iliaj hoketoj; kaj li tegis iliajn kapojn kaj ligaĵojn per oro; kaj por ili kvin kuprajn bazojn. ");
INSERT INTO epo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Kaj Becalel faris la keston el akacia ligno; du ulnoj kaj duono estis ĝia longo, kaj unu ulno kaj duono ĝia larĝo, kaj unu ulno kaj duono ĝia alto. ");
INSERT INTO epo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kaj li tegis ĝin per pura oro interne kaj ekstere, kaj li faris al ĝi oran kronon ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Kaj li fandis por ĝi kvar orajn ringojn sur ĝiaj kvar anguloj: du ringojn sur unu ĝia flanko kaj du ringojn sur ĝia alia flanko. ");
INSERT INTO epo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kaj li faris stangojn el akacia ligno kaj tegis ilin per oro. ");
INSERT INTO epo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Kaj li metis la stangojn en la ringojn sur la flankoj de la kesto, por porti la keston. ");
INSERT INTO epo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Kaj li faris fermoplaton el pura oro; du ulnoj kaj duono estis ĝia longo, kaj unu ulno kaj duono ĝia larĝo. ");
INSERT INTO epo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kaj li faris du kerubojn el oro; per forĝa laboro li faris ilin, sur la du randoj de la fermoplato: ");
INSERT INTO epo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","unu kerubon ĉe unu flanko kaj la duan kerubon ĉe la dua flanko; elstarantaj el la fermoplato li faris la kerubojn, sur ĝiaj du flankoj. ");
INSERT INTO epo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kaj la keruboj estis etendantaj siajn flugilojn supren, kovrante per siaj flugiloj la fermoplaton, kaj iliaj vizaĝoj estis unu kontraŭ la alia; al la fermoplato estis turnitaj la vizaĝoj de la keruboj. ");
INSERT INTO epo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kaj li faris la tablon el akacia ligno; du ulnoj estis ĝia longo, kaj unu ulno ĝia larĝo, kaj unu ulno kaj duono ĝia alto. ");
INSERT INTO epo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kaj li tegis ĝin per pura oro, kaj li faris al ĝi oran kronon ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Kaj li faris ĉirkaŭ ĝi manlarĝan listelon, kaj li faris oran kronon ĉirkaŭ la listelo. ");
INSERT INTO epo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Kaj li fandis por ĝi kvar orajn ringojn, kaj li alfortikigis la ringojn sur la kvar anguloj, ĉe ĝiaj kvar piedoj. ");
INSERT INTO epo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Apud la listelo estis la ringoj, kiel ingoj por la stangoj, por porti la tablon. ");
INSERT INTO epo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Kaj li faris la stangojn el akacia ligno, kaj li tegis ilin per oro, por porti la tablon. ");
INSERT INTO epo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Kaj ankaŭ la vazojn por la tablo, ĝiajn pladojn kaj ĝiajn kulerojn, kaj ĝiajn kruĉojn kaj la kalikojn, per kiuj oni verŝas, li faris el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kaj li faris la kandelabron el pura oro, per forĝa laboro li faris la kandelabron; ĝia trunko kaj ĝiaj branĉoj, ĝiaj kalikoj, ĝiaj kapetoj, kaj ĝiaj floroj elstaris el ĝi. ");
INSERT INTO epo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kaj ses branĉoj elstaris el ĝiaj flankoj: tri branĉoj de la kandelabro el unu flanko, kaj tri branĉoj de la kandelabro el la dua flanko; ");
INSERT INTO epo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","tri migdalformaj kalikoj, kapeto, kaj floro estis sur unu branĉo, kaj tri migdalformaj kalikoj, kapeto, kaj floro sur la dua branĉo; tiel estis sur la ses branĉoj, kiuj elstaris el la kandelabro. ");
INSERT INTO epo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Kaj sur la kandelabro estis kvar migdalformaj kalikoj kun siaj kapetoj kaj floroj. ");
INSERT INTO epo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Kaj kapeto estis sub unu paro da branĉoj, kaj kapeto sub la dua paro da branĉoj, kaj kapeto sub la tria paro da branĉoj; tiel estis ĉe la ses branĉoj, kiuj elstaris el ĝi. ");
INSERT INTO epo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","La kapetoj kaj branĉoj elstaris el ĝi; ĉio estis unu forĝita tutaĵo el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Kaj li faris ĝiajn sep lucernojn kaj ĝiajn prenilojn kaj cindrujojn el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","El kikaro da pura oro li faris ĝin kaj ĉiujn ĝiajn apartenaĵojn. ");
INSERT INTO epo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kaj li faris la altaron por la incensado el akacia ligno; unu ulno estis ĝia longo, kaj unu ulno ĝia larĝo; kvarangula ĝi estis; du ulnoj estis ĝia alto; el ĝi elstaris ĝiaj kornoj. ");
INSERT INTO epo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kaj li tegis ĝin per pura oro, ĝian supran platon kaj ĝiajn muretojn ĉirkaŭe kaj ĝiajn kornojn; kaj li faris al ĝi oran kronon ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Kaj du orajn ringojn li faris al ĝi sub ĝia krono, sur ĝiaj du flankoj, kiel ingojn por stangoj, per kiuj oni portu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Kaj li faris la stangojn el akacia ligno kaj tegis ilin per oro. ");
INSERT INTO epo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Kaj li faris la oleon por la sanktoleado kaj la puran bonodoran incenson laŭ la arto de ŝmiraĵisto. ");
INSERT INTO epo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Kaj li faris la altaron por la bruloferoj el akacia ligno; kvin ulnoj estis ĝia longo, kaj kvin ulnoj ĝia larĝo; kvarangula ĝi estis; kaj tri ulnoj estis ĝia alto. ");
INSERT INTO epo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Kaj li faris ĝiajn kornojn sur ĝiaj kvar anguloj; el ĝi elstaris ĝiaj kornoj; kaj li tegis ĝin per kupro. ");
INSERT INTO epo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kaj li faris ĉiujn vazojn de la altaro; la potojn, la ŝovelilojn, la kalikojn, la forkojn, la karbujojn; ĉiujn ĝiajn vazojn li faris el kupro. ");
INSERT INTO epo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Kaj li faris por la altaro kradon en formo de kupra reto, sub ĝia kornico, malsupre, ĝis la mezo. ");
INSERT INTO epo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Kaj li fandis kvar ringojn en la kvar anguloj de la kupra krado, ke ili estu ingoj por la stangoj. ");
INSERT INTO epo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Kaj li faris la stangojn el akacia ligno kaj tegis ilin per kupro. ");
INSERT INTO epo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Kaj li metis la stangojn en la ringojn sur la flankoj de la altaro, por ke oni povu porti ĝin per ili; li faris ĝin interne malplena, el tabuloj. ");
INSERT INTO epo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kaj li faris la lavujon el kupro kaj ĝian piedestalon el kupro, el la speguloj de la virinoj, kiuj kolektiĝis amase antaŭ la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Kaj li faris la korton: sur la flanko suda estis la kurtenoj de la korto el tordita bisino, cent ulnoj, ");
INSERT INTO epo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","kaj al ili dudek kolonoj kun dudek kupraj bazoj; la hokoj de la kolonoj kaj iliaj ligaĵoj estis el arĝento. ");
INSERT INTO epo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kaj sur la norda flanko ankaŭ cent ulnoj, kaj al ili dudek kolonoj kaj dudek kupraj bazoj; la hokoj de la kolonoj kaj iliaj ligaĵoj estis el arĝento. ");
INSERT INTO epo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kaj sur la okcidenta flanko estis kurtenoj de kvindek ulnoj, kaj al ili dek kolonoj kun dek bazoj; la hokoj de la kolonoj kaj iliaj ligaĵoj estis el arĝento. ");
INSERT INTO epo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kaj sur la orienta flanko kvindek ulnoj. ");
INSERT INTO epo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kurtenoj de dek kvin ulnoj sur unu latero, kaj al tio tri kolonoj kun tri bazoj. ");
INSERT INTO epo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Kaj sur la dua latero, sur ambaŭ flankoj de la pordego de la korto estis kurtenoj po dek kvin ulnoj, kaj al ili po tri kolonoj kun tri bazoj. ");
INSERT INTO epo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ĉiuj kurtenoj de la korto ĉirkaŭe estis el tordita bisino. ");
INSERT INTO epo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Kaj la bazoj de la kolonoj estis el kupro, la hokoj de la kolonoj kaj iliaj ligaĵoj el arĝento, kaj iliaj kapoj estis tegitaj per arĝento, kaj ĉiuj kolonoj de la korto estis kunigitaj per arĝentaj ligaĵoj. ");
INSERT INTO epo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Kaj la kovrotuko de la pordego de la korto estis brodita laboraĵo el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino; kaj dudek ulnoj estis ĝia longo, kaj kvin ulnoj ĝia larĝo, laŭ la mezuro de la kurtenoj de la korto. ");
INSERT INTO epo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kaj al ĝi apartenis kvar kolonoj kun kvar kupraj bazoj; iliaj hokoj estis el arĝento, iliaj kapoj estis tegitaj per arĝento, kaj iliaj ligaĵoj estis el arĝento. ");
INSERT INTO epo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Kaj ĉiuj najloj en la tabernaklo kaj en la korto ĉirkaŭe estis el kupro. ");
INSERT INTO epo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Jen estas la kalkulo pri la tabernaklo, la tabernaklo de atesto, kiu estis kalkulita laŭ la ordono de Moseo, por la servo de la Levidoj, sub la kontrolo de Itamar, filo de la pastro Aaron. ");
INSERT INTO epo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Kaj Becalel, filo de Uri, filo de Ĥur, el la tribo de Jehuda, faris ĉion, kion ordonis la Eternulo al Moseo; ");
INSERT INTO epo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","kaj kun li Oholiab, filo de Aĥisamaĥ, el la tribo de Dan, artista skulptisto, teksisto, kaj brodisto sur blua, purpura, kaj ruĝa teksaĵo, kaj sur bisino. ");
INSERT INTO epo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","La tuta oro, kiu estis uzita por ĉiuj laboroj de la sanktejo, la oro, kiu estis alportita kiel oferdonoj, prezentis la kvanton de dudek naŭ kikaroj kaj sepcent tridek sikloj laŭ la mezuro de la sankta siklo. ");
INSERT INTO epo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Kaj la arĝento, akirita per la kalkulado de la komunumo, prezentis la kvanton de cent kikaroj kaj mil sepcent sepdek kvin sikloj laŭ la sankta siklo: ");
INSERT INTO epo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","po unu bek’o, tio estas po duono de siklo laŭ la sankta siklo, por ĉiu kapo, de ĉiuj, kiuj trapasis la kalkulon, kiuj havis la aĝon de dudek jaroj kaj pli, de sescent tri mil kvincent kvindek homoj. ");
INSERT INTO epo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Cent kikaroj da arĝento estis uzitaj por elfandi la bazojn de la sanktejo kaj la bazojn de la kurteno; cent bazoj el cent kikaroj, po unu kikaro por bazo. ");
INSERT INTO epo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kaj el mil sepcent sepdek kvin sikloj estis faritaj hokoj por la kolonoj kaj estis tegitaj iliaj kapoj kaj estis faritaj ligaĵoj inter ili. ");
INSERT INTO epo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Kaj da oferdonita kupro estis sepdek kikaroj kaj du mil kvarcent sikloj. ");
INSERT INTO epo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Kaj li faris el ĝi la bazojn por la pordo de la tabernaklo de kunveno kaj la kupran altaron kaj la kupran kradon por ĝi kaj ĉiujn apartenaĵojn de la altaro, ");
INSERT INTO epo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kaj la bazojn de la korto ĉirkaŭe kaj la bazojn de la pordego de la korto kaj ĉiujn najlojn de la tabernaklo kaj ĉiujn najlojn de la korto ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kaj el la blua, purpura, kaj ruĝa teksaĵo ili faris la oficajn vestojn por la servado en la sanktejo; kaj ili faris la sanktajn vestojn por Aaron, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Kaj ili faris la efodon el oro, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino. ");
INSERT INTO epo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Kaj ili batetendis foliojn da oro kaj tranĉis ilin en formo de fadenoj, por enteksi internen de la blua, purpura, kaj ruĝa teksaĵo kaj de la bisino per artista laboro. ");
INSERT INTO epo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Surŝultraĵojn kunigantajn ili faris al ĝi; sur siaj du finoj ĝi estis ligita. ");
INSERT INTO epo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kaj la ĉirkaŭliganta zono sur ĝi estis kontinuaĵo de ĝi, la sama laboraĵo, el oro, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Kaj ili faris la oniksajn ŝtonojn, ĉirkaŭe enkadrigitajn per oro, gravuritajn per sigelila gravurado laŭ la nomoj de la filoj de Izrael. ");
INSERT INTO epo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kaj li metis ilin sur la surŝultraĵojn de la efodo, kiel ŝtonojn de memoro pri la filoj de Izrael; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kaj ili faris la surbrustaĵon per artista laboro, simile al la laboro de la efodo, el oro, el blua, purpura, kaj ruĝa teksaĵo, kaj el tordita bisino. ");
INSERT INTO epo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ĝi estis kvarangula; ili faris la surbrustaĵon duobla; manstreĉo estis ĝia longo, kaj manstreĉo ĝia larĝo; ĝi estis duobla. ");
INSERT INTO epo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Kaj ili enmetis en ĝin kvar vicojn da ŝtonoj. La unua vico estis: rubeno, topazo, kaj smeraldo; ");
INSERT INTO epo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","kaj la dua vico: hiacinto, safiro, kaj jaspiso; ");
INSERT INTO epo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","kaj la tria vico: ligurio, agato, kaj ametisto; ");
INSERT INTO epo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","kaj la kvara vico: krizolito, onikso, kaj berilo. Ĉiuj vicoj estis en oraj kadretoj. ");
INSERT INTO epo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kaj la ŝtonoj estis laŭ la nomoj de la filoj de Izrael; dek du, laŭ iliaj nomoj, gravuritaj sigelile, ĉiu kun sia nomo, por la dek du triboj. ");
INSERT INTO epo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kaj ili faris al la surbrustaĵo plektitajn ĉenetojn, kuniĝantajn per siaj finoj, el pura oro. ");
INSERT INTO epo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Kaj ili faris du orajn kadretojn kaj du orajn ringojn, kaj alfortikigis la du ringojn al la du finoj de la surbrustaĵo. ");
INSERT INTO epo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Kaj ili metis la du orajn plektitajn ĉenetojn en la du ringojn ĉe la finoj de la surbrustaĵo. ");
INSERT INTO epo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Kaj la du finojn de la du plektitaj ĉenetoj ili alfortikigis al la du kadretoj, kaj alfortikigis ilin al la surŝultraĵoj de la efodo sur la antaŭa flanko. ");
INSERT INTO epo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kaj ili faris du orajn ringojn, kaj alfortikigis ilin al la du aliaj finoj de la surbrustaĵo, sur ĝia rando interna, direktita al la efodo. ");
INSERT INTO epo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kaj ili faris du orajn ringojn, kaj alfortikigis ilin al la du surŝultraĵoj de la efodo malsupre, sur la antaŭa flanko, ĉe ĝia kuniĝo, super la zono de la efodo. ");
INSERT INTO epo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kaj ili alligis la surbrustaĵon per ĝiaj ringoj al la ringoj de la efodo per laĉo el blua ŝtofo, por ke ĝi estu super la zono de la efodo kaj por ke la surbrustaĵo ne forŝoviĝu de sur la efodo; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Kaj li faris la tunikon por la efodo, teksitan, tutan el blua teksaĵo. ");
INSERT INTO epo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kaj la aperturo de la tuniko estis en la mezo, kiel aperturo de ŝildo; borderon havis la aperturo ĉirkaŭe, por ke ĝi ne disŝiriĝu. ");
INSERT INTO epo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kaj ili faris sur la malsupra rando de la tuniko granatojn el blua, purpura, kaj ruĝa ŝtofo, tordita. ");
INSERT INTO epo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Kaj ili faris tintilojn el pura oro, kaj metis la tintilojn mezen de la granatoj sur la malsupra rando de la tuniko, ĉirkaŭe inter la granatoj; ");
INSERT INTO epo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","tintilon kaj granaton, tintilon kaj granaton sur la malsupra rando de la tuniko, ĉirkaŭe, por la servado; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kaj ili faris la ĥitonon el bisino, teksitan, por Aaron kaj liaj filoj, ");
INSERT INTO epo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kaj la cidaron el bisino, kaj la ornamajn mitrojn el bisino, kaj la linajn pantalonojn el tordita bisino, ");
INSERT INTO epo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","kaj la zonon el tordita bisino kaj el blua, purpura, kaj ruĝa teksaĵo, broditan; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Kaj ili faris la tabuleton, la sanktan kronon, el pura oro, kaj ili skribis sur ĝi skribon gravuritan: SANKTA AL LA ETERNULO. ");
INSERT INTO epo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kaj ili alfortikigis al ĝi laĉon el blua ŝtofo, por alfortikigi al la cidaro supre; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tiel finiĝis la tuta laboro por la konstruaĵo de la tabernaklo de kunveno. Kaj la Izraelidoj faris konforme al ĉio, kion la Eternulo ordonis al Moseo; tiel ili faris. ");
INSERT INTO epo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Kaj ili alportis la konstruaĵon al Moseo, la tabernaklon kaj ĉiujn ĝiajn apartenaĵojn: hokojn, tabulojn, riglilojn, kolonojn, kaj bazojn; ");
INSERT INTO epo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kaj la kovron el ruĝaj virŝafaj feloj kaj la kovron el antilopaj feloj kaj la kurtenon; ");
INSERT INTO epo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","la keston de atesto kaj ĝiajn stangojn kaj la fermoplaton; ");
INSERT INTO epo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la tablon, ĉiujn ĝiajn apartenaĵojn, kaj la panon de propono; ");
INSERT INTO epo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","la puran kandelabron, ĝiajn lucernojn, la lucernojn vice starantajn, ĉiujn ĝiajn apartenaĵojn, kaj la oleon por lumigado; ");
INSERT INTO epo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kaj la oran altaron kaj la sanktan oleon kaj la bonodoran incenson kaj la kovrotukon por la pordo de la tabernaklo; ");
INSERT INTO epo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","la kupran altaron kaj la kupran kradon por ĝi, ĝiajn stangojn kaj ĉiujn ĝiajn apartenaĵojn, la lavujon kaj ĝian piedestalon; ");
INSERT INTO epo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","la kurtenojn de la korto, ĝiajn kolonojn kaj bazojn, la kovrotukon por la pordego de la korto, ĝiajn ŝnurojn kaj najlojn, kaj ĉion, kio apartenas al la servado en la konstruaĵo de la tabernaklo de kunveno; ");
INSERT INTO epo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","la oficajn vestojn por la servado en la sanktejo, la sanktajn vestojn por la pastro Aaron kaj la pastrajn vestojn por liaj filoj. ");
INSERT INTO epo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Konforme al ĉio, kion la Eternulo ordonis al Moseo, tiel la Izraelidoj faris la tutan laboron. ");
INSERT INTO epo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Kaj Moseo vidis la tutan laboron, li vidis, ke ili faris ĝin tute tiel, kiel la Eternulo ordonis; kaj Moseo benis ilin. ");
INSERT INTO epo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","En la unua monato, en la unua tago de la monato starigu la konstruaĵon de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kaj metu tien la keston de atesto kaj ŝirmu la keston per la kurteno. ");
INSERT INTO epo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kaj enportu la tablon kaj aranĝu sur ĝi ĝian aranĝotaĵon, kaj enportu la kandelabron kaj ekbruligu ĝiajn lucernojn. ");
INSERT INTO epo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Kaj starigu la oran altaron por la incensado antaŭ la kesto de atesto, kaj pendigu la kovrotukon ĉe la eniro de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kaj starigu la altaron de bruloferoj antaŭ la eniro en la konstruaĵon de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kaj starigu la lavujon inter la tabernaklo de kunveno kaj la altaro kaj enverŝu en ĝin akvon. ");
INSERT INTO epo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kaj aranĝu la korton ĉirkaŭe, kaj pendigu la kovrotukon ĉe la pordego de la korto. ");
INSERT INTO epo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Kaj prenu la sanktan oleon, kaj sanktoleu la loĝejon, kaj ĉion, kio estas en ĝi, kaj sanktigu ĝin kun ĉiuj ĝiaj apartenaĵoj, por ke ĝi estu sankta. ");
INSERT INTO epo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kaj sanktoleu la altaron de bruloferoj kun ĉiuj ĝiaj apartenaĵoj, kaj sanktigu la altaron, ke la altaro estu tre sankta. ");
INSERT INTO epo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kaj sanktoleu la lavujon kaj ĝian piedestalon, kaj sanktigu ĝin. ");
INSERT INTO epo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Kaj alkonduku Aaronon kaj liajn filojn al la eniro de la tabernaklo de kunveno, kaj lavu ilin per akvo. ");
INSERT INTO epo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kaj vestu Aaronon per la sanktaj vestoj kaj sanktoleu lin kaj sanktigu lin, ke li estu Mia pastro. ");
INSERT INTO epo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Kaj liajn filojn alkonduku, kaj vestu ilin per ĥitonoj. ");
INSERT INTO epo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Kaj sanktoleu ilin, kiel vi sanktoleis ilian patron, ke ili estu Miaj pastroj; kaj ilia sanktoleiteco estu por ili por eterna pastreco en iliaj generacioj. ");
INSERT INTO epo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Kaj Moseo faris konforme al ĉio, kion la Eternulo al li ordonis; tiel li faris. ");
INSERT INTO epo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","En la unua monato de la dua jaro, en la unua tago de la monato estis starigita la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kaj Moseo starigis la tabernaklon kaj metis ĝiajn bazojn kaj starigis ĝiajn tabulojn kaj aranĝis ĝiajn riglilojn kaj starigis ĝiajn kolonojn. ");
INSERT INTO epo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Kaj li etendis tendon super la tabernaklo kaj metis la kovron de la tendo sur ĝin supre, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Kaj li prenis kaj metis la ateston en la keston, kaj almetis la stangojn al la kesto kaj surmetis la fermoplaton sur la keston supre. ");
INSERT INTO epo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kaj li envenigis la keston en la tabernaklon, kaj pendigis la kurtenon kaj ŝirmis la keston de atesto, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Kaj li starigis la tablon en la tabernaklo de kunveno, en la norda parto de la tabernaklo, ekster la kurteno. ");
INSERT INTO epo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Kaj li aranĝis sur ĝi vicon da panoj antaŭ la Eternulo, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Kaj li starigis la kandelabron en la tabernaklo de kunveno kontraŭ la tablo, en la suda parto de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Kaj li ekbruligis la lucernojn antaŭ la Eternulo, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Kaj li starigis la oran altaron en la tabernaklo de kunveno antaŭ la kurteno. ");
INSERT INTO epo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Kaj li bruligis sur ĝi bonodoran incenson, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kaj li pendigis la kovrotukon ĉe la pordo de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Kaj la altaron de bruloferoj li starigis ĉe la eniro de la tabernaklo de kunveno, kaj li alportis sur ĝi la bruloferon kaj la farunoferon, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Kaj li starigis la lavujon inter la tabernaklo de kunveno kaj la altaro, kaj enverŝis tien akvon por sin lavi. ");
INSERT INTO epo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Kaj lavis per ĝi Moseo kaj Aaron kaj liaj filoj siajn manojn kaj siajn piedojn; ");
INSERT INTO epo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","kiam ili eniradis en la tabernaklon de kunveno kaj aliradis al la altaro, ili lavadis sin; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kaj li aranĝis la korton ĉirkaŭe de la tabernaklo kaj de la altaro, kaj li pendigis la kovrotukon ĉe la pordego de la korto. Tiamaniere Moseo finis la laboron. ");
INSERT INTO epo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kaj nubo kovris la tabernaklon de kunveno, kaj la majesto de la Eternulo plenigis la tabernaklon. ");
INSERT INTO epo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Kaj Moseo ne povis eniri en la tabernaklon de kunveno, ĉar kuŝis sur ĝi la nubo kaj la majesto de la Eternulo plenigis la tabernaklon. ");
INSERT INTO epo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kaj kiam la nubo leviĝadis de sur la tabernaklo, la Izraelidoj ekmarŝadis, por fari ĉiujn siajn marŝojn. ");
INSERT INTO epo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Sed se la nubo ne leviĝis, ili ne ekmarŝis ĝis la tago de ĝia leviĝo. ");
INSERT INTO epo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ĉar nubo de la Eternulo estis super la tabernaklo dum la tago, kaj fajro estis dum la nokto super ĝi, antaŭ la okuloj de ĉiuj Izraelidoj en ĉiuj iliaj marŝoj. ");
INSERT INTO epo_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","La Eternulo vokis Moseon, kaj ekparolis al li el la tabernaklo de kunveno, dirante: ");
INSERT INTO epo_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Parolu al la Izraelidoj, kaj diru al ili: Se iu el vi volas alporti oferon al la Eternulo, el la brutoj, el la bovoj, kaj el la ŝafoj alportu vian oferon. ");
INSERT INTO epo_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Se lia ofero estas brulofero el bovoj, li oferu virseksulon sendifektan; al la pordo de la tabernaklo de kunveno li alkonduku ĝin, por favorigi al si la Eternulon. ");
INSERT INTO epo_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Kaj li metu sian manon sur la kapon de la brulofero, kaj li akiros favoron kaj pekpardonon. ");
INSERT INTO epo_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kaj li buĉu la bovidon antaŭ la Eternulo; kaj la filoj de Aaron, la pastroj, alportu la sangon kaj aspergu per la sango ĉirkaŭe la altaron, kiu estas ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Kaj oni senfeligu la bruloferon kaj dishaku ĝin en pecojn. ");
INSERT INTO epo_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kaj la filoj de la pastro Aaron metu fajron sur la altaron kaj metu lignon sur la fajron. ");
INSERT INTO epo_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Kaj la filoj de Aaron, la pastroj, metu la pecojn, la kapon, kaj la grason, sur la lignon, kiu estas sur la fajro sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kaj la internaĵon kaj la krurojn oni lavu per akvo; kaj la pastro forbruligu ĉion sur la altaro kiel bruloferon; ĝi estas fajrofero, agrabla odoraĵo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kaj se lia ofero estas el la malgrandaj brutoj, el la ŝafoj aŭ el la kaproj, brulofero, li alportu ĝin virseksan, sendifektan. ");
INSERT INTO epo_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kaj li buĉu ĝin sur la norda flanko de la altaro antaŭ la Eternulo; kaj la filoj de Aaron, la pastroj, aspergu per ĝia sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kaj oni dishaku ĝin en pecojn, apartiginte la kapon kaj la grason, kaj la pastro metu ilin sur la lignon, kiu estas sur la fajro sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Kaj la internaĵon kaj la krurojn oni lavu per akvo; kaj la pastro ĉion alportu kaj forbruligu sur la altaro kiel bruloferon; ĝi estas fajrofero, agrabla odoraĵo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kaj se el la birdoj estas lia brulofero al la Eternulo, li alportu sian oferon el turtoj aŭ el kolombidoj. ");
INSERT INTO epo_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kaj la pastro alportu ĝin al la altaro kaj fortordu ĝian kapon kaj forbruligu ĝin sur la altaro kaj elfluigu ĝian sangon super la muro de la altaro. ");
INSERT INTO epo_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kaj ĝian kropon kun ĝiaj plumoj li forigu kaj ĵetu ĝin apud la altaron sur la orientan flankon en la cindrejon. ");
INSERT INTO epo_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kaj li disfendu ĝiajn flugilojn, sed ne derompu; kaj la pastro forbruligu ĝin sur la altaro, sur la ligno, kiu estas sur la fajro; ĝi estas brulofero, fajrofero, agrabla odoraĵo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Se iu alportos farunoferon al la Eternulo, lia ofero estu el delikata faruno, kaj li verŝu sur ĝin oleon kaj metu sur ĝin olibanon. ");
INSERT INTO epo_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Kaj li alportu ĝin al la filoj de Aaron, la pastroj; kaj la pastro prenu el ĝi plenmanon el la faruno kun la oleo kaj kun la olibano, kaj li ekbruligu tiun parton promemoran sur la altaro; ĝi estas fajrofero, agrabla odoraĵo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kaj la restaĵo el la farunofero estu por Aaron kaj por liaj filoj; plejsanktaĵo ĝi estas el la fajroferoj de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Se vi alportos farunoferon el io, kio estas bakita en forno, ĝi estu macokukoj el plej bona faruno, miksitaj kun oleo, kaj macoflanoj, ŝmiritaj per oleo. ");
INSERT INTO epo_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kaj se via ofero estos farunofero farita sur pato, ĝi estu el delikata faruno, miksita kun oleo, ne fermentinta. ");
INSERT INTO epo_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Dispecigu ĝin kaj verŝu sur ĝin oleon; ĝi estas farunofero. ");
INSERT INTO epo_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kaj se via ofero estos farunofero el kaserolo, ĝi estu farita el delikata faruno kun oleo. ");
INSERT INTO epo_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kaj alportu la farunoferon, kiu estas farita el ĝi, al la Eternulo, kaj prezentu ĝin al la pastro, kaj li alportu ĝin al la altaro. ");
INSERT INTO epo_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kaj la pastro prenos el la farunofero la parton promemoran kaj bruligos ĝin sur la altaro; ĝi estas fajrofero, agrabla odoraĵo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kaj la restaĵo el la farunofero estu por Aaron kaj por liaj filoj; ĝi estas plejsanktaĵo el la fajroferoj de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Nenia farunofero, kiun vi alportos al la Eternulo, estu farita el fermentintaĵo; ĉar nenion fermentintan kaj nenian mielon vi devas bruligi kiel fajroferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kiel oferon de unuaaĵoj vi povas alporti tion al la Eternulo, sed sur la altaron ili ne venu kiel agrabla odoraĵo. ");
INSERT INTO epo_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kaj ĉiun vian farunoferon salu per salo, kaj ne estigu vian farunoferon sen salo de interligo de via Dio; kun ĉiu via ofero alportu salon. ");
INSERT INTO epo_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Se vi alportos al la Eternulo farunoferon el la unuaj terproduktaĵoj, tiam spikojn, rostitajn sur fajro, grajnaĵon el freŝaj grajnoj alportu kiel farunoferon el viaj unuaj terproduktaĵoj. ");
INSERT INTO epo_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kaj verŝu sur ĝin oleon kaj metu sur ĝin olibanon; ĝi estas farunofero. ");
INSERT INTO epo_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kaj la pastro bruligos la promemoran parton el ĝia grajnaĵo kaj el ĝia oleo kun ĝia tuta olibano, kiel fajroferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Se lia ofero estas pacofero, se li alportas el la grandaj brutoj, ĉu ĝi estas virseksa, ĉu virinseksa, sendifektan li alportu ĝin antaŭ la Eternulon. ");
INSERT INTO epo_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kaj li metu sian manon sur la kapon de sia ofero kaj buĉu ĝin ĉe la pordo de la tabernaklo de kunveno; kaj la filoj de Aaron, la pastroj, aspergu per la sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kaj li alportu el la pacofero kiel fajroferon al la Eternulo la sebon, kiu kovras la internaĵojn, kaj la tutan sebon, kiu estas sur la internaĵoj, ");
INSERT INTO epo_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kaj ambaŭ renojn, kaj la sebon, kiu estas sur ili, kiu estas ĉe la lumbo, kaj la reton sur la hepato, kune kun la renoj li ĝin apartigu. ");
INSERT INTO epo_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kaj la filoj de Aaron forbruligu tion sur la altaro, kune kun la brulofero, kiu estas sur la ligno, sur la fajro; ĝi estas fajrofero, agrabla odoraĵo al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kaj se el la malgrandaj brutoj estas lia ofero, kiel pacofero al la Eternulo, ĉu ĝi estas virseksa, ĉu virinseksa, sendifektan li ĝin alportu. ");
INSERT INTO epo_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Se ŝafidon li alportas kiel sian oferon, li alportu ĝin antaŭ la Eternulon; ");
INSERT INTO epo_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","kaj li metu sian manon sur la kapon de sia ofero, kaj li buĉu ĝin antaŭ la tabernaklo de kunveno; kaj la filoj de Aaron aspergu per ĝia sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kaj li alportu el la pacofero kiel fajroferon al la Eternulo ĝian sebon, la tutan voston, detranĉitan ĉe la sakro, kaj la sebon, kiu kovras la internaĵojn, kaj la tutan sebon, kiu estas sur la internaĵoj, ");
INSERT INTO epo_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kaj ambaŭ renojn, kaj la sebon, kiu estas sur ili, kiu estas ĉe la lumbo, kaj la reton sur la hepato, kune kun la renoj li ĝin apartigu. ");
INSERT INTO epo_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kaj la pastro bruligu tion sur la altaro; ĝi estas manĝaĵo, fajrofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kaj se lia ofero estas kapro, li alportu ĝin antaŭ la Eternulon. ");
INSERT INTO epo_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Kaj li metu sian manon sur ĝian kapon, kaj li buĉu ĝin antaŭ la tabernaklo de kunveno; kaj la filoj de Aaron aspergu per ĝia sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kaj li alportu el ĝi ofere, kiel fajroferon al la Eternulo, la sebon, kiu kovras la internaĵojn, kaj la tutan sebon, kiu estas sur la internaĵoj, ");
INSERT INTO epo_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kaj ambaŭ renojn, kaj la sebon, kiu estas sur ili, kiu estas ĉe la lumbo, kaj la reton sur la hepato, kune kun la renoj li ĝin apartigu. ");
INSERT INTO epo_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kaj la pastro bruligu tion sur la altaro; ĝi estas manĝaĵo, fajrofero, agrabla odoraĵo; la tuta sebo estu por la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ĝi estu eterna leĝo por viaj generacioj en ĉiuj viaj loĝlokoj; sebon kaj sangon neniam manĝu. ");
INSERT INTO epo_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Diru al la Izraelidoj jene: Se iu pekos per eraro kontraŭ la ordonoj de la Eternulo, malpermesantaj fari diversajn aferojn, kaj li faros iun el ili; ");
INSERT INTO epo_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","se pastro sanktoleita pekos, ĵetante kulpon sur la popolon, tiam li alportu pro sia peko, kiun li pekis, bovidon sendifektan al la Eternulo, kiel oferon propekan. ");
INSERT INTO epo_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Li venigu la bovidon al la pordo de la tabernaklo de kunveno antaŭ la Eternulon, kaj li metu sian manon sur la kapon de la bovido, kaj li buĉu la bovidon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kaj la sanktoleita pastro prenu iom el la sango de la bovido kaj enportu ĝin en la tabernaklon de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kaj la pastro trempu sian fingron en la sango, kaj aspergu per la sango sepfoje antaŭ la Eternulo, antaŭ la kurteno de la sanktejo. ");
INSERT INTO epo_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Kaj la pastro metu iom el la sango sur la kornojn de la altaro de bonodora incenso antaŭ la Eternulo en la tabernaklo de kunveno, kaj la tutan ceteran sangon de la bovido li elverŝu ĉe la bazo de la altaro de bruloferoj, kiu estas ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Kaj la tutan sebon de la propeka bovido li forlevu el ĝi, la sebon, kiu kovras la internaĵojn, kaj la tutan sebon, kiu estas sur la internaĵoj, ");
INSERT INTO epo_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kaj ambaŭ renojn, kaj la sebon, kiu estas sur ili, kiu estas ĉe la lumbo, kaj la reton sur la hepato, kune kun la renoj li ĝin apartigu, ");
INSERT INTO epo_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","tiel same, kiel estas forlevata pacofero el bovo; kaj la pastro bruligu tion sur la altaro de bruloferoj. ");
INSERT INTO epo_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kaj la felon de la bovido kaj ĝian tutan viandon kun ĝia kapo kaj kruroj kaj ĝiajn internaĵojn kaj malpuraĵon, ");
INSERT INTO epo_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","la tutan bovidon li elportu ekster la tendaron sur puran lokon, kien oni ŝutas la cindron, kaj li forbruligu tion sur ligno per fajro; sur la cindrejo tio estu forbruligata. ");
INSERT INTO epo_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kaj se la tuta komunumo de la Izraelidoj pekos per eraro kaj la afero estos kaŝita antaŭ la okuloj de la anaro, kaj ili faros iun el la agoj, kiujn la Eternulo malpermesis, kaj ili fariĝos kulpaj; ");
INSERT INTO epo_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","kaj ili sciiĝos pri la peko, kiun ili pekis: tiam la anaro alportu bovidon kiel propekan oferon kaj venigu ĝin antaŭ la tabernaklon de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Kaj la plejaĝuloj de la komunumo metu siajn manojn sur la kapon de la bovido antaŭ la Eternulo, kaj oni buĉu la bovidon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Kaj la sanktoleita pastro enportu iom el la sango de la bovido en la tabernaklon de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Kaj la pastro trempu sian fingron en la sango, kaj aspergu sep fojojn antaŭ la Eternulo, antaŭ la kurteno. ");
INSERT INTO epo_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Kaj iom el la sango li metu sur la kornojn de la altaro, kiu estas antaŭ la Eternulo en la tabernaklo de kunveno, kaj la tutan ceteran sangon li elverŝu ĉe la bazo de la altaro de bruloferoj, kiu estas ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kaj ĝian tutan sebon li forlevu el ĝi kaj bruligu sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Kaj li faru kun la bovido; kiel li faris kun la propeka bovido, tiel li faru kun ĝi; kaj pekliberigos ilin la pastro, kaj estos pardonite al ili. ");
INSERT INTO epo_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kaj li elportu la bovidon ekster la tendaron, kaj forbruligu ĝin, kiel li forbruligis la unuan bovidon; ĝi estas propeka ofero de la komunumo. ");
INSERT INTO epo_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Se princo pekos, kaj per eraro faros iun el la agoj, kiujn la Eternulo, lia Dio, malpermesis fari, kaj li fariĝos kulpa; ");
INSERT INTO epo_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","kaj li sciiĝos pri sia peko, kiun li pekis: tiam li alportu kiel sian oferon virkapron sendifektan. ");
INSERT INTO epo_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kaj li metu sian manon sur la kapon de la kapro, kaj buĉu ĝin sur la loko, sur kiu estas buĉataj bruloferoj antaŭ la Eternulo; ĝi estas propeka ofero. ");
INSERT INTO epo_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kaj la pastro prenos iom el la sango de la propeka ofero per sia fingro, kaj li metos ĝin sur la kornojn de la altaro de bruloferoj, kaj la ceteran sangon li elverŝos ĉe la bazo de la altaro de bruloferoj. ");
INSERT INTO epo_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Kaj ĝian tutan sebon li bruligos sur la altaro, kiel la sebon de pacofero; kaj la pastro liberigos lin de lia peko, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Se iu el la popolo per eraro pekos, farante iun el la agoj, kiujn la Eternulo malpermesis, kaj li fariĝos kulpa; ");
INSERT INTO epo_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","kaj li sciiĝos pri sia peko, kiun li pekis: tiam li alportu kiel sian oferon kaprinon sendifektan pro sia peko, kiun li pekis. ");
INSERT INTO epo_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kaj li metu sian manon sur la kapon de la propeka ofero, kaj li buĉu la propekan oferon sur la loko de la bruloferoj. ");
INSERT INTO epo_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kaj la pastro prenos iom el ĝia sango per sia fingro kaj metos sur la kornojn de la altaro de bruloferoj, kaj la tutan ceteran sangon li elverŝos ĉe la bazo de la altaro. ");
INSERT INTO epo_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Kaj ĝian tutan sebon li apartigos, kiel estas apartigata la sebo de la pacoferoj, kaj la pastro bruligos ĝin sur la altaro, kiel agrablan odoraĵon al la Eternulo; kaj la pastro pekliberigos lin, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Se ŝafon li alportos kiel sian propekan oferon, li alportu virinseksan, sendifektan. ");
INSERT INTO epo_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kaj li metu sian manon sur la kapon de la propeka ofero, kaj buĉu ĝin kiel propekan oferon sur la loko, kie oni buĉas bruloferon. ");
INSERT INTO epo_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kaj la pastro prenos per sia fingro iom el la sango de la propeka ofero kaj metos ĝin sur la kornojn de la altaro de bruloferoj, kaj ĝian tutan ceteran sangon li elverŝos ĉe la bazo de la altaro. ");
INSERT INTO epo_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Kaj ĝian tutan sebon li apartigos, kiel estas apartigata la sebo de la ŝafo el la pacoferoj, kaj la pastro bruligos ĝin sur la altaro kun la fajroferoj al la Eternulo; kaj la pastro liberigos lin de la peko, kiun li pekis, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Se iu pekos per tio, ke li aŭdos ĵuron kaj estos atestanto, aŭ ke li vidos aŭ scios, sed ne sciigos kaj portos sur si la pekon; ");
INSERT INTO epo_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","aŭ se iu ektuŝos ion malpuran, aŭ kadavraĵon de malpura besto, aŭ kadavraĵon de malpura bruto, aŭ kadavraĵon de malpura rampaĵo, kaj li tion ne scios, kaj li malpuriĝos kaj kulpiĝos; ");
INSERT INTO epo_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","aŭ se iu ektuŝos malpuraĵon de homo, kia ajn estus tiu malpuraĵo, per kiu oni malpuriĝas, kaj li tion ne scios, kaj poste li sciiĝos, kaj li estos kulpa; ");
INSERT INTO epo_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","aŭ se iu per nesingarda buŝo ĵuros fari ion malbonan aŭ bonan, kion ajn homo elesprimas per ĵuro, kaj li tion ne rimarkos, kaj poste li sciiĝos, kaj li estos kulpa pri io el tiuj aferoj: ");
INSERT INTO epo_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","se iu estos kulpa pri io el tiuj aferoj, li faru konfeson pri tio, kion li pekis; ");
INSERT INTO epo_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","kaj pro sia peko, kiun li pekis, li alportu al la Eternulo kiel propekan oferon inon el la malgrandaj brutoj, ŝafinon aŭ kaprinon; kaj la pastro liberigos lin de lia peko. ");
INSERT INTO epo_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kaj se li ne estos sufiĉe bonstata, por alporti ŝafinon, li alportu pro sia peko, kiun li pekis, du turtojn aŭ du kolombidojn al la Eternulo, unu kiel propekan oferon, la duan kiel bruloferon. ");
INSERT INTO epo_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Li alportu ilin al la pastro, kaj ĉi tiu prezentos antaŭe tiun, kiu estos propeka ofero, kaj li tordorompos ĝian kapon ĉe la nuko, sed ne apartigos ĝin; ");
INSERT INTO epo_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","kaj li aspergos per la sango de la propeka ofero la muron de la altaro, kaj la restintan sangon li elpremos ĉe la bazo de la altaro; tio estas propeka ofero. ");
INSERT INTO epo_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kaj el la dua li faros bruloferon laŭ la reguloj; kaj la pastro liberigos lin de la peko, kiun li pekis, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Se li ne estos sufiĉe bonstata, por alporti du turtojn aŭ du kolombidojn, tiam li alportu kiel oferon pro sia peko dekonon de efo da delikata faruno, kiel propekan oferon; li ne verŝu sur ĝin oleon kaj ne metu sur ĝin olibanon, ĉar ĝi estas propeka ofero. ");
INSERT INTO epo_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kaj li alportu ĝin al la pastro, kaj la pastro prenos el ĝi plenmanon kiel memorparton kaj bruligos sur la altaro kun la fajroferoj al la Eternulo; ĝi estas propeka ofero. ");
INSERT INTO epo_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kaj la pastro liberigos lin de lia peko, kiun li pekis koncerne iun el tiuj aferoj, kaj estos pardonite al li; la restaĵo estu por la pastro, kiel farunofero. ");
INSERT INTO epo_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Se iu kulpiĝos, pekante per eraro kontraŭ la sanktaĵoj de la Eternulo, tiam li alportu kiel prokulpan oferon al la Eternulo virŝafon sendifektan el la malgrandaj brutoj, havantan laŭ via taksado la valoron de du sikloj, laŭ la sankta siklo; ĝi estu prokulpa ofero. ");
INSERT INTO epo_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kaj pro la sanktaĵo, kontraŭ kiu li pekis, li pagu, kaj li aldonu kvinonon de ĝia valoro kaj donu tion al la pastro; kaj la pastro pekliberigos lin per la prokulpa virŝafo, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kaj se iu pekos, farante iun el tiuj aferoj, kiujn la Eternulo malpermesis, sed li ne sciis kaj fariĝis kulpa, kaj li portos sur si sian pekon: ");
INSERT INTO epo_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","tiam li alportu virŝafon sendifektan el la malgrandaj brutoj, laŭ via taksado, kiel kulpoferon al la pastro; kaj la pastro pekliberigos lin koncerne lian eraron, kiun li faris ne sciante, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ĝi estas prokulpa ofero; li kulpiĝis antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Se iu pekos kaj krimos antaŭ la Eternulo, neante al sia proksimulo koncerne konfiditaĵon aŭ deponitaĵon aŭ rabitaĵon, aŭ se li trompe forprenos ion de sia proksimulo, ");
INSERT INTO epo_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","aŭ se li trovos perditaĵon kaj neos tion, aŭ se li ĵuros mensoge pri io, kion homo faras, kaj per tio pekas: ");
INSERT INTO epo_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","tiam, se li pekis kaj kulpiĝis, li redonu la rabitaĵon, kiun li rabis, aŭ tion, kion li trompe forprenis, aŭ la deponitaĵon, kiu estis deponita ĉe li, aŭ la perditaĵon, kiun li trovis; ");
INSERT INTO epo_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","aŭ ĉion, pri kio li mensoge ĵuris, li repagu per ĝia plena valoro kaj aldonu plie kvinonon de ĝi; al tiu, kies tio estas, li donu ĝin en la tago, kiam li alportas sian kulpoferon. ");
INSERT INTO epo_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Kaj kiel sian kulpoferon li alportu al la Eternulo sendifektan virŝafon el la malgrandaj brutoj, laŭ via taksado, kiel kulpoferon, por la pastro. ");
INSERT INTO epo_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kaj la pastro pekliberigos lin antaŭ la Eternulo, kaj estos pardonite al li pri ĉio, kion li faris kaj per kio li kulpiĝis. ");
INSERT INTO epo_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ordonu al Aaron kaj al liaj filoj, dirante: Jen estas la leĝo pri la brulofero: la brulofero restu sur la fajrujo sur la altaro dum tuta nokto, ĝis la mateno, kaj la fajro de la altaro restu brulanta sur ĝi. ");
INSERT INTO epo_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kaj la pastro metu sur sin sian linan veston, kaj siajn linajn pantalonojn li surmetu sur sian korpon, kaj li deprenu la cindron, kiun la fajro elbruligis el la brulofero sur la altaro, kaj li metu ĝin apud la altaron. ");
INSERT INTO epo_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Kaj li demetu siajn vestojn kaj metu sur sin aliajn vestojn kaj elportu la cindron ekster la tendaron sur puran lokon. ");
INSERT INTO epo_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kaj la fajro sur la altaro restu brulanta sur ĝi kaj ne estingiĝu; kaj la pastro bruligu sur ĝi lignon ĉiumatene, kaj aranĝu sur ĝi la bruloferon kaj bruligu sur ĝi la sebon de la pacoferoj. ");
INSERT INTO epo_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Eterna fajro brulu sur la altaro, ne estingiĝu. ");
INSERT INTO epo_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Kaj jen estas la leĝo pri la farunofero: la filoj de Aaron alportu ĝin antaŭ la Eternulon sur la antaŭan parton de la altaro. ");
INSERT INTO epo_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kaj la pastro prenu el ĝi plenmanon el la delikata faruno de la farunofero kaj el ĝia oleo, kaj la tutan olibanon, kiu estas sur la farunofero, kaj li bruligu sur la altaro kiel agrablan odoraĵon, memoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kaj la restaĵon el ĝi manĝu Aaron kaj liaj filoj; senfermente ili ĝin manĝu sur sankta loko, sur la korto de la tabernaklo de kunveno ili ĝin manĝu. ");
INSERT INTO epo_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ĝi ne estu bakata fermentinte; kiel ilian parton Mi donis ĝin el Miaj fajroferoj; ĝi estas plejsanktaĵo, simile al pekofero kaj kulpofero. ");
INSERT INTO epo_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ĉiu virseksulo el la Aaronidoj povas ĝin manĝi kiel eternan destinitaĵon en viaj generacioj el la fajroferoj de la Eternulo; ĉiu, kiu ektuŝos ilin, devos esti sankta. ");
INSERT INTO epo_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Jen estas la ofero de Aaron kaj liaj filoj, kiun ili alportos al la Eternulo en la tago de sia sanktoleateco: dekono de efo da delikata faruno kiel konstanta farunofero, unu duono matene kaj la dua duono vespere. ");
INSERT INTO epo_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Sur pato kun oleo ĝi devas esti preparita; bone bakitan alportu ĝin; en formo de dispecigita farunofero alportu ĝin kiel agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kaj la pastro, kiu el liaj filoj estos sanktoleita anstataŭ li, plenumos tion; ĝi estu eterna leĝo antaŭ la Eternulo; ĝi tuta devas esti forbruligata. ");
INSERT INTO epo_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kaj ĉiu farunofero de pastro estu forbruligata tuta; ĝi ne estu manĝata. ");
INSERT INTO epo_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Diru al Aaron kaj al liaj filoj jene: Jen estas la leĝo pri la pekofero: sur tiu loko, sur kiu estas buĉata la brulofero, oni buĉu la pekoferon antaŭ la Eternulo; plejsanktaĵo ĝi estas. ");
INSERT INTO epo_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","La pastro, kiu plenumas la pekoferon, manĝu ĝin; sur sankta loko ĝi estu manĝata, sur la korto de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ĉiu, kiu ektuŝos ĝian viandon, devas esti sankta; kaj se iu aspergos per ĝia sango la veston, li lavu la aspergitan pecon sur sankta loko. ");
INSERT INTO epo_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Kaj la argilan vazon, en kiu ĝi estis kuirita, oni disrompu; kaj se ĝi estis kuirita en kupra vazo, oni purigu ĉi tiun kaj lavu ĝin per akvo. ");
INSERT INTO epo_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ĉiu virseksulo el la pastroj povas ĝin manĝi; ĝi estas plejsanktaĵo. ");
INSERT INTO epo_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Sed ĉiu pekofero, el kies sango oni enportos en la tabernaklon de kunveno por pekliberigo en la sanktejo, ne estu manĝata: per fajro oni ĝin forbruligu. ");
INSERT INTO epo_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Kaj jen estas la leĝo pri la kulpofero: plejsanktaĵo ĝi estas. ");
INSERT INTO epo_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Sur la loko, sur kiu estas buĉata la brulofero, oni buĉu la kulpoferon, kaj per ĝia sango oni aspergu la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Kaj ĝian tutan sebon oni alportu el ĝi ofere, la voston, kaj la sebon, kiu kovras la internaĵojn, ");
INSERT INTO epo_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kaj ambaŭ renojn, kaj la sebon, kiu estas sur ili, kiu estas ĉe la lumbo, kaj la reton sur la hepato, kune kun la renoj oni ĝin apartigu. ");
INSERT INTO epo_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kaj la pastro bruligu ilin sur la altaro kiel fajroferon al la Eternulo; ĝi estas kulpofero. ");
INSERT INTO epo_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ĉiu virseksulo el la pastroj povas ĝin manĝi; sur sankta loko ĝi estu manĝata; ĝi estas plejsanktaĵo. ");
INSERT INTO epo_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Kiel por la pekofero, tiel ankaŭ por la kulpofero estu la sama leĝo; al la pastro, kiu pekliberigas per ĝi, al li ĝi apartenu. ");
INSERT INTO epo_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Al la pastro, kiu plenumas ies bruloferon, al tiu pastro apartenu la felo de la brulofero, kiun li plenumis. ");
INSERT INTO epo_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kaj ĉiu farunofero, kiu estas bakita en forno aŭ pretigita en kaserolo aŭ sur pato, apartenu al la pastro, kiu prezentis ĝin. ");
INSERT INTO epo_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kaj ĉiu farunofero, miksita kun oleo aŭ seka, apartenu al ĉiuj Aaronidoj, al ĉiuj egale. ");
INSERT INTO epo_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Kaj jen estas la leĝo pri la pacofero, kiu estas alportata al la Eternulo: ");
INSERT INTO epo_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","se iu ĝin alportas kiel dankon, li alportu kun la danka ofero nefermentintajn kukojn, miksitajn kun oleo, kaj nefermentintajn flanojn, ŝmiritajn per oleo, kaj el delikata faruno kukojn frititajn, miksitajn kun oleo. ");
INSERT INTO epo_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kune kun kukoj el pano fermentinta li alportu sian oferon, ĉe sia danka pacofero. ");
INSERT INTO epo_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Kaj li alportu unu el ili, el ĉiu ofero, kiel oferdonon al la Eternulo; al la pastro, kiu aspergas la sangon de la pacofero, ĝi apartenu. ");
INSERT INTO epo_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Kaj la viando de la danka pacofero estu manĝata en la tago de la oferado; oni ne devas restigi iom el ĝi ĝis la mateno. ");
INSERT INTO epo_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Sed se lia ofero estas sankta promeso aŭ memvola ofero, ĝi estu manĝata en la tago de la alportado de la ofero; kaj ankaŭ en la sekvanta tago oni povas manĝi tion, kio restis el ĝi. ");
INSERT INTO epo_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kaj kio restis el la viando de la ofero ĝis la tria tago, tio estu forbruligata per fajro. ");
INSERT INTO epo_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Se iu manĝos el la viando de sia pacofero en la tria tago, ĝi ne akiros plaĉon; kiu alportos ĝin, al tiu ĝi ne estos kalkulata; ĝi estos abomenindaĵo, kaj kiu ĝin manĝos, tiu havos pekon. ");
INSERT INTO epo_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","La viando, kiu ektuŝis ion malpuran, ne estu manĝata, oni ĝin forbruligu per fajro. La ceteran viandon povas manĝi ĉiu purulo. ");
INSERT INTO epo_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Se iu, havante sur si malpuraĵon, manĝos viandon el la pacofero, kiu estis destinita por la Eternulo, ties animo ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Se iu ektuŝos ion malpuran, ĉu malpuraĵon de homo, ĉu malpuran beston, ĉu ian malpuran abomenindaĵon, kaj manĝos el la viando de pacofero, kiu estis destinita por la Eternulo, ties animo ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Diru al la Izraelidoj jene: Sebon de bovo kaj de ŝafo kaj de kapro neniam manĝu. ");
INSERT INTO epo_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La sebon de kadavraĵo kaj la sebon de besto disŝirita oni povas uzi por ĉia laboro, sed manĝi ĝin vi ne devas. ");
INSERT INTO epo_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ĉar ĉiu, kiu manĝos sebon de brutoj, el kiuj oni alportas fajroferon al la Eternulo, la manĝinto ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kaj nenian sangon manĝu en ĉiuj viaj loĝejoj, nek el birdoj, nek el brutoj. ");
INSERT INTO epo_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ĉiu, kiu manĝos ian sangon, ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Diru al la Izraelidoj jene: Kiu alportas sian pacoferon al la Eternulo, tiu alportu mem al la Eternulo tion, kio apartenas el liaj pacoferoj; ");
INSERT INTO epo_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","propramane li alportu la fajroferon al la Eternulo; la sebon kune kun la brustaĵo li alportu; la brustaĵon, por skui ĝin kiel skuoferon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kaj la pastro bruligos la sebon sur la altaro, kaj la brustaĵo estos por Aaron kaj por liaj filoj. ");
INSERT INTO epo_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kaj la dekstran femuron el viaj pacoferoj donu kiel levoferon al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kiu el la Aaronidoj alportas la sangon de la pacoferoj kaj la sebon, al tiu apartenu la dekstra femuro kiel lia parto: ");
INSERT INTO epo_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ĉar la brustaĵon-skuoferon kaj la femuron-levoferon Mi prenis de la Izraelidoj el iliaj pacoferoj, kaj Mi donis ilin al la pastro Aaron kaj al liaj filoj kiel eternan destinitaĵon de la flanko de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Tio estas la sankta parto de Aaron kaj la sankta parto de liaj filoj el la fajroferoj de la Eternulo de post la tago, en kiu ili estis aligitaj, por esti pastroj al la Eternulo, ");
INSERT INTO epo_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","parto, kiun la Eternulo ordonis doni al ili de la Izraelidoj en la tago, en kiu Li sanktoleis ilin. Tio estas eterna leĝo en iliaj generacioj. ");
INSERT INTO epo_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Tio estas la leĝo pri la brulofero, pri la farunofero, pri la pekofero, pri la kulpofero, pri la ofero de konsekro, kaj pri la pacofero; ");
INSERT INTO epo_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","kiun la Eternulo donis al Moseo sur la monto Sinaj, kiam Li ordonis al la Izraelidoj en la dezerto Sinaja, ke ili alportadu siajn oferojn al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Prenu Aaronon kaj liajn filojn kune kun li kaj la vestojn kaj la sanktan oleon kaj bovidon por pekofero kaj du virŝafojn kaj korbon da macoj. ");
INSERT INTO epo_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kaj la tutan komunumon kunvenigu ĉe la eniro de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Kaj Moseo faris, kiel la Eternulo al li ordonis; kaj la komunumo kolektiĝis ĉe la eniro de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Kaj Moseo diris al la komunumo: Jen estas tio, kion la Eternulo ordonis fari. ");
INSERT INTO epo_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Kaj Moseo alvenigis Aaronon kaj liajn filojn, kaj li lavis ilin per akvo. ");
INSERT INTO epo_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Kaj li metis sur lin la ĥitonon kaj zonis lin per zono kaj vestis lin per la tuniko kaj metis sur lin la efodon kaj zonis lin per la zono de la efodo kaj alfortikigis per ĝi la efodon sur li. ");
INSERT INTO epo_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Kaj li metis sur lin la surbrustaĵon, kaj sur la surbrustaĵon la signojn de lumo kaj de justo. ");
INSERT INTO epo_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Kaj li metis la cidaron sur lian kapon, kaj sur la cidaron sur la antaŭa flanko li metis la oran tabuleton, la sanktan kronon, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kaj Moseo prenis la sanktan oleon, kaj sanktoleis la tabernaklon, kaj ĉion, kio estis en ĝi, kaj li sanktigis ilin. ");
INSERT INTO epo_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Kaj li aspergis per tio la altaron sep fojojn, kaj li sankteŝmiris la altaron kaj ĉiujn ĝiajn apartenaĵojn, kaj la lavujon kaj ĝian piedestalon, por sanktigi ilin. ");
INSERT INTO epo_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Kaj li verŝis iom el la sankta oleo sur la kapon de Aaron, kaj li ŝmiris lin, por sanktigi lin. ");
INSERT INTO epo_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kaj Moseo alvenigis la filojn de Aaron kaj vestis ilin per ĥitonoj kaj zonis ilin per zonoj kaj alligis sur ili mitrojn, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Kaj li alkondukis la propekan bovidon, kaj Aaron kaj liaj filoj metis siajn manojn sur la kapon de la propeka bovido. ");
INSERT INTO epo_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Kaj Moseo ĝin buĉis, kaj li prenis iom el la sango kaj metis per sia fingro sur la kornojn de la altaro ĉirkaŭe kaj pekliberigis la altaron; kaj la ceteran sangon li elverŝis ĉe la bazo de la altaro, kaj sanktigis ĉi tiun, por pekliberigi ĝin. ");
INSERT INTO epo_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Kaj li prenis la tutan sebon, kiu estis sur la internaĵoj, kaj la reton de la hepato, kaj ambaŭ renojn kaj ilian sebon, kaj Moseo bruligis tion sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kaj la bovidon kaj ĝian felon kaj ĝian karnon kaj ĝian malpuraĵon li forbruligis per fajro ekster la tendaro, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kaj li alkondukis la virŝafon de brulofero; kaj Aaron kaj liaj filoj metis siajn manojn sur la kapon de la virŝafo. ");
INSERT INTO epo_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Kaj Moseo ĝin buĉis, kaj aspergis per la sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Kaj la virŝafon li dishakis en partojn, kaj Moseo ekbruligis la kapon kaj la partojn kaj la grason. ");
INSERT INTO epo_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","La internaĵojn kaj la krurojn li lavis per akvo; kaj Moseo forbruligis la tutan ŝafon sur la altaro; ĝi estis brulofero por agrabla odoraĵo, fajrofero al la Eternulo, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kaj li alkondukis la duan virŝafon, la virŝafon de konsekrado; kaj Aaron kaj liaj filoj metis siajn manojn sur la kapon de la virŝafo. ");
INSERT INTO epo_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Kaj li ĝin buĉis, kaj Moseo prenis iom el ĝia sango kaj metis sur la malsupran randon de la dekstra orelo de Aaron kaj sur la dikan fingron de lia dekstra mano kaj sur la dikan fingron de lia dekstra piedo. ");
INSERT INTO epo_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Kaj li alkondukis la filojn de Aaron, kaj Moseo metis iom el la sango sur la malsupran randon de ilia dekstra orelo kaj sur la dikan fingron de ilia dekstra mano kaj sur la dikan fingron de ilia dekstra piedo; kaj Moseo aspergis per la sango la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Kaj li prenis la sebon kaj la voston, kaj la tutan sebon, kiu estis sur la internaĵoj, kaj la reton de la hepato, kaj ambaŭ renojn kaj ilian sebon, kaj la dekstran femuron. ");
INSERT INTO epo_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Kaj el la korbo da macoj, kiu estis antaŭ la Eternulo, li prenis unu macan kukon kaj unu kukon kun oleo kaj unu flanon, kaj metis ilin sur la sebojn kaj sur la dekstran femuron. ");
INSERT INTO epo_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Kaj li metis ĉion ĉi tion sur la manojn de Aaron kaj sur la manojn de liaj filoj, kaj li skuis tion kiel skuoferon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kaj Moseo prenis tion for de iliaj manoj kaj ekbruligis sur la altaro kune kun la brulofero: tio estis ofero de konsekrado, por agrabla odoraĵo; ĝi estis fajrofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Kaj Moseo prenis la brustaĵon kaj skuis ĝin kiel skuoferon antaŭ la Eternulo: de la ŝafo de konsekrado ĝi estis la destinita parto por Moseo, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kaj Moseo prenis iom el la sankta oleo, kaj el la sango, kiu estis sur la altaro, kaj aspergis Aaronon, liajn vestojn, liajn filojn, kaj la vestojn de liaj filoj kune kun li; kaj li sanktigis Aaronon, liajn vestojn, liajn filojn, kaj la vestojn de liaj filoj kune kun li. ");
INSERT INTO epo_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kaj Moseo diris al Aaron kaj al liaj filoj: Kuiru la viandon ĉe la pordo de la tabernaklo de kunveno; kaj tie manĝu ĝin, kaj ankaŭ la panon, kiu estas en la korbo de konsekrado, kiel mi ordonis, dirante: Aaron kaj liaj filoj ĝin manĝu. ");
INSERT INTO epo_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kaj la restaĵon el la viando kaj el la pano forbruligu per fajro. ");
INSERT INTO epo_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kaj for de la pordo de la tabernaklo de kunveno ne foriru dum sep tagoj, ĝis la tago, en kiu finiĝos la tempo de via konsekrado; ĉar sep tagojn daŭros via konsekrado. ");
INSERT INTO epo_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kiel estis farite hodiaŭ, tiel la Eternulo ordonis fari, por pekliberigi vin. ");
INSERT INTO epo_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kaj ĉe la pordo de la tabernaklo de kunveno restu tage kaj nokte dum sep tagoj, kaj vi observos la servadon al la Eternulo, por ke vi ne mortu; ĉar tiel estas ordonite al mi. ");
INSERT INTO epo_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Kaj Aaron kaj liaj filoj faris ĉion, kion la Eternulo ordonis per Moseo. ");
INSERT INTO epo_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","En la oka tago Moseo vokis Aaronon kaj liajn filojn kaj la plejaĝulojn de Izrael. ");
INSERT INTO epo_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Kaj li diris al Aaron: Prenu al vi junan bovidon por pekofero kaj virŝafon por brulofero, sendifektajn, kaj alkonduku ilin antaŭ la Eternulon. ");
INSERT INTO epo_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kaj al la Izraelidoj diru jene: Prenu virkapron por propeka ofero, kaj bovidon kaj ŝafidon jaraĝajn, sendifektajn, por brulofero, ");
INSERT INTO epo_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","kaj virbovon kaj virŝafon por pacofero, por fari oferon antaŭ la Eternulo, kaj farunoferon, miksitan kun oleo; ĉar hodiaŭ la Eternulo aperos antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Kaj ili alportis tion, kion ordonis Moseo, antaŭ la pordon de la tabernaklo de kunveno; kaj la tuta komunumo alproksimiĝis kaj stariĝis antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kaj Moseo diris: Jen estas tio, kion la Eternulo ordonis; faru, kaj tiam aperos antaŭ vi la majesto de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kaj Moseo diris al Aaron: Aliru al la altaro, kaj faru vian pekoferon kaj vian bruloferon kaj pekliberigu vin kaj la popolon, kaj faru la oferon de la popolo kaj pekliberigu ilin, kiel ordonis la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kaj Aaron aliris al la altaro, kaj buĉis la bovidon, kiu estis lia propeka ofero. ");
INSERT INTO epo_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Kaj la filoj de Aaron alportis al li la sangon, kaj li trempis sian fingron en la sango kaj ŝmiris la kornojn de la altaro, kaj la ceteran sangon li elverŝis ĉe la bazo de la altaro. ");
INSERT INTO epo_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Sed la sebon kaj la renojn kaj la reton de la hepato de la pekofero li bruligis sur la altaro, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Kaj la karnon kaj la felon li forbruligis per fajro ekster la tendaro. ");
INSERT INTO epo_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Kaj li buĉis la bruloferon, kaj la filoj de Aaron alportis al li la sangon, kaj li aspergis per ĝi la altaron ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Kaj la bruloferon ili alportis al li dispecigitan kaj la kapon, kaj li bruligis tion sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Kaj li lavis la internaĵojn kaj la krurojn kaj bruligis tion kun la brulofero sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Kaj li alportis la oferon de la popolo, kaj li prenis la propekan kapron de la popolo, kaj buĉis ĝin kaj faris el ĝi pekoferon kiel el la antaŭa. ");
INSERT INTO epo_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Kaj li alportis la bruloferon kaj agis kun ĝi laŭ la reguloj. ");
INSERT INTO epo_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kaj li alportis la farunoferon kaj prenis el ĝi plenmanon kaj bruligis tion sur la altaro krom la matena brulofero. ");
INSERT INTO epo_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Kaj li buĉis la bovon kaj la ŝafon kiel pacoferon de la popolo, kaj la filoj de Aaron alportis al li la sangon, kaj li aspergis per ĝi la altaron ĉirkaŭe; ");
INSERT INTO epo_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","kaj la sebojn de la bovo, kaj el la ŝafo la voston kaj la kovrantan sebon kaj la renojn kaj la reton de la hepato. ");
INSERT INTO epo_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Kaj ili metis la sebojn sur la brustaĵojn, kaj li ekbruligis la sebojn sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Kaj la brustaĵojn kaj la dekstran femuron Aaron skuis kiel skuoferon antaŭ la Eternulo, kiel Moseo ordonis. ");
INSERT INTO epo_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kaj Aaron levis siajn manojn al la popolo kaj benis ĝin; kaj li malsupreniris, plenuminte la pekoferon kaj la bruloferon kaj la pacoferon. ");
INSERT INTO epo_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Kaj Moseo kaj Aaron eniris en la tabernaklon de kunveno kaj eliris kaj benis la popolon. Kaj montriĝis la majesto de la Eternulo al la tuta popolo. ");
INSERT INTO epo_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Kaj eliris fajro el antaŭ la Eternulo kaj konsumis sur la altaro la bruloferon kaj la sebon; kaj la tuta popolo vidis, kaj ili ĝoje ekkriis kaj falis vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Kaj Nadab kaj Abihu, la filoj de Aaron, prenis ĉiu sian incensujon kaj metis en ĝin fajron kaj metis sur ĝin incenson kaj alportis antaŭ la Eternulon fajron fremdan, pri kiu Li ne ordonis al ili. ");
INSERT INTO epo_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tiam eliris fajro el antaŭ la Eternulo kaj forbruligis ilin, kaj ili mortis antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kaj Moseo diris al Aaron: Jen pri ĉi tio parolis la Eternulo, kiam Li diris: Per Miaj proksimuloj Mi sanktiĝos kaj antaŭ la tuta popolo Mi majestiĝos. Kaj Aaron silentis. ");
INSERT INTO epo_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Kaj Moseo alvokis Miŝaelon kaj Elcafanon, filojn de Uziel, onklo de Aaron, kaj li diris al ili: Aliru, elportu viajn fratojn el la sanktejo ekster la tendaron. ");
INSERT INTO epo_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Kaj ili aliris kaj elportis ilin en iliaj ĥitonoj ekster la tendaron, kiel diris Moseo. ");
INSERT INTO epo_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kaj Moseo diris al Aaron kaj al liaj filoj Eleazar kaj Itamar: Viajn kapojn ne nudigu kaj viajn vestojn ne disŝiru, por ke vi ne mortu kaj por ke Li ne koleru la tutan komunumon; sed viaj fratoj, la tuta domo de Izrael, priploru la brulon, kiun la Eternulo ekbruligis. ");
INSERT INTO epo_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kaj el la pordo de la tabernaklo de kunveno ne eliru, por ke vi ne mortu; ĉar la sankta oleo de la Eternulo estas sur vi. Kaj ili agis laŭ la vortoj de Moseo. ");
INSERT INTO epo_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kaj la Eternulo ekparolis al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Vinon kaj ebriigaĵon ne trinku, nek vi, nek viaj filoj kun vi, kiam vi iras en la tabernaklon de kunveno, por ke vi ne mortu. Tio estu eterna leĝo en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Por ke vi diferencigu inter sanktaĵo kaj ordinaraĵo kaj inter malpuraĵo kaj puraĵo; ");
INSERT INTO epo_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","kaj por ke vi instruu al la Izraelidoj ĉiujn leĝojn, kiujn eldiris al ili la Eternulo per Moseo. ");
INSERT INTO epo_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Kaj Moseo diris al Aaron, kaj al Eleazar kaj al Itamar, liaj restintaj filoj: Prenu la farunoferon, kiu restis el la fajroferoj de la Eternulo, kaj manĝu ĝin senfermente apud la altaro; ĉar ĝi estas plejsanktaĵo. ");
INSERT INTO epo_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kaj manĝu ĝin sur sankta loko; ĉar ĝi estas via destinitaĵo kaj la destinitaĵo de viaj filoj el la fajroferoj de la Eternulo; ĉar tiel estas ordonite al mi. ");
INSERT INTO epo_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Kaj la brustaĵon de skuado kaj la femuron de levado manĝu sur loko pura, vi kaj viaj filoj kaj viaj filinoj kune kun vi; ĉar ili estas donitaj kiel via destinitaĵo kaj destinitaĵo de viaj filoj el la pacoferoj de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","La femuron de levado kaj la brustaĵon de skuado ili alportu kun la fajroferoj el la sebo, por skui tion kiel skuoferon antaŭ la Eternulo; kaj tio estu por vi kaj por viaj filoj eterna destinitaĵo, kiel ordonis la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kaj la kapron propekan Moseo serĉis, sed montriĝis, ke ĝi estas forbruligita. Tiam li ekkoleris kontraŭ Eleazar kaj kontraŭ Itamar, la restintaj filoj de Aaron, kaj li diris: ");
INSERT INTO epo_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Kial vi ne manĝis la pekoferon sur loko sankta? ĝi estas ja plejsanktaĵo, kaj ĝi estas donita al vi, por forporti la pekon de la komunumo, por pekliberigi ilin antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Jen ĝia sango ne estas enportita en la internon de la sanktejo; vi devis manĝi ĝin en la sanktejo, kiel estas ordonite al mi. ");
INSERT INTO epo_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Kaj Aaron diris al Moseo: Jen hodiaŭ ili alportis sian pekoferon kaj sian bruloferon antaŭ la Eternulon, kaj okazis al mi tia afero; se mi manĝus hodiaŭ pekoferon, ĉu tio plaĉus al la Eternulo? ");
INSERT INTO epo_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Kaj Moseo tion aŭdis, kaj tio plaĉis al li. ");
INSERT INTO epo_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante al ili: ");
INSERT INTO epo_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Diru al la Izraelidoj jene: Tio estas la bestoj, kiujn vi povas manĝi el ĉiuj brutoj, kiuj estas sur la tero: ");
INSERT INTO epo_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ĉiun bruton, kiu havas disfenditajn hufojn kaj distranĉan sulkon sur la hufoj kaj kiu remaĉas maĉitaĵon, vi povas manĝi. ");
INSERT INTO epo_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nur ĉi tiujn ne manĝu el la remaĉantaj maĉitaĵon kaj el la havantaj disfenditajn hufojn: la kamelon, ĉar ĝi remaĉas maĉitaĵon, sed disfenditajn hufojn ĝi ne havas, malpura ĝi estas por vi; ");
INSERT INTO epo_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","kaj la hirakon, ĉar ĝi remaĉas maĉitaĵon, sed disfenditajn hufojn ĝi ne havas, malpura ĝi estas por vi; ");
INSERT INTO epo_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","kaj la leporon, ĉar ĝi remaĉas maĉitaĵon, sed disfenditajn hufojn ĝi ne havas, malpura ĝi estas por vi; ");
INSERT INTO epo_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","kaj la porkon, ĉar ĝi havas disfenditajn hufojn kaj distranĉan sulkon sur la hufoj, sed ĝi ne remaĉas maĉitaĵon, malpura ĝi estas por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ilian viandon ne manĝu kaj iliajn kadavrojn ne tuŝu, malpuraj ili estas por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Jenajn vi povas manĝi el ĉiuj bestoj, kiuj estas en la akvo: ĉiujn, kiuj havas naĝilojn kaj skvamojn en la akvo, en la maroj, kaj en la riveroj, ilin vi povas manĝi. ");
INSERT INTO epo_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Sed ĉiuj, kiuj ne havas naĝilojn kaj skvamojn, en la maroj kaj en la riveroj, el ĉio, kio moviĝas en la akvo, kaj el ĉiuj estaĵoj, kiuj vivas en la akvo, ili estas abomenindaĵo por vi; ");
INSERT INTO epo_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","kaj ili estu abomenindaĵo por vi, ilian viandon ne manĝu kaj iliajn kadavrojn abomenu. ");
INSERT INTO epo_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ĉio en la akvo, kio ne havas naĝilojn kaj skvamojn, estas abomenindaĵo por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Kaj ĉi tiujn abomenu inter la birdoj, ili ne estu manĝataj, ili estas abomenindaĵoj: la aglon kaj la gipaeton kaj la pandionon ");
INSERT INTO epo_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kaj la milvon kaj la falkon kun ĝia speco, ");
INSERT INTO epo_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ĉiun korvon kun ĝia speco, ");
INSERT INTO epo_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","kaj la struton kaj la strigon kaj la mevon kaj la akcipitron kun ĝia speco ");
INSERT INTO epo_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","kaj la noktuon kaj la mergulon kaj la ibison ");
INSERT INTO epo_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","kaj la cignon kaj la pelikanon kaj la perknopteron ");
INSERT INTO epo_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","kaj la cikonion kaj la ardeon kun ĝia speco kaj la upupon kaj la vesperton. ");
INSERT INTO epo_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ĉio moviĝanta, kio havas flugilojn kaj iras kvarpiede, estas abomenindaĵo por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nur tiujn vi povas manĝi el ĉiuj moviĝantoj, kiuj havas flugilojn kaj iras kvarpiede: tiujn, kiuj havas genuojn super la kruroj, por salti per ili sur la tero. ");
INSERT INTO epo_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","La jenajn el ili vi povas manĝi: la akridon kun ĝia speco kaj la cikadon kun ĝia speco kaj la grilon kun ĝia speco kaj la lokuston kun ĝia speco. ");
INSERT INTO epo_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Sed ĉiu alia moviĝanto, kiu havas flugilojn kaj kvar piedojn, estas abomenindaĵo por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Kaj per la jenaj vi fariĝos malpuraj; ĉiu, kiu ektuŝos ilian kadavron, estos malpura ĝis la vespero; ");
INSERT INTO epo_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","kaj ĉiu, kiu portos kadavraĵon de ili, lavu siajn vestojn, kaj li estos malpura ĝis la vespero: ");
INSERT INTO epo_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ĉiu bruto, kiu havas disfenditajn hufojn, sed ne havas distranĉan sulkon kaj ne remaĉas maĉitaĵon, estas malpura por vi; ĉiu, kiu ektuŝos ilin, estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Kaj el ĉiuj bestoj kvarpiedaj ĉiuj, kiuj iras sur siaj plandoj, estas malpuraj por vi; ĉiu, kiu ektuŝos ilian kadavron, estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Kaj kiu portos kadavraĵon de ili, lavu siajn vestojn, kaj li estos malpura ĝis la vespero: malpuraj ili estas por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Kaj jen, kio estas malpura por vi inter la rampaĵoj, kiuj rampas sur la tero: la talpo kaj la muso kaj la lacerto kun ĝia speco ");
INSERT INTO epo_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","kaj la geko kaj la monitoro kaj la uromastiko kaj la skinko kaj la ĥameleono. ");
INSERT INTO epo_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Tiuj estas la malpuraj por vi inter ĉiuj rampaĵoj; ĉiu, kiu ektuŝos ilin post ilia morto, estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kaj ĉio, sur kion falos io el ili malviva, estos malpura; ĉu ĝi estos ia ligna vazo, ĉu vesto, ĉu felo, ĉu sako, ĉu ia ilo, per kiu oni faras laboron — oni metu ĝin en akvon, kaj ĝi estos malpura ĝis la vespero, kaj tiam ĝi fariĝos pura. ");
INSERT INTO epo_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kaj se en ian argilan vazon io el ili falos internen, tiam ĉio, kio estas interne, fariĝos malpura; kaj la vazon rompu. ");
INSERT INTO epo_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ĉiu manĝaĵo, kiun oni manĝas, se ŝprucos sur ĝin tia akvo, fariĝos malpura; kaj ĉiu trinkaĵo, kiun oni trinkas, en tia vazo fariĝos malpura. ");
INSERT INTO epo_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kaj ĉio, sur kion falos io el ilia kadavraĵo, fariĝos malpura; se ĝi estos forno aŭ kaldrono, oni ĝin disrompu; malpuraj ili estas kaj malpuraj ili estu por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nur fonto kaj puto kaj akvejoj restos puraj. Kiu ektuŝos ilian kadavraĵon, fariĝos malpura. ");
INSERT INTO epo_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kaj se io el ilia kadavraĵo falos sur ian semeblan semon, kiu estas semota, ĝi restos pura. ");
INSERT INTO epo_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Sed se estos verŝita akvo sur la semon kaj io el ilia kadavraĵo falos sur ĝin, tiam ĝi estos malpura por vi. ");
INSERT INTO epo_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kaj se mortos ia bruto el tiuj, kiujn vi uzas por manĝi, tiam tiu, kiu ektuŝos ĝian kadavron, estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kaj tiu, kiu manĝos ion el ĝia kadavraĵo, lavu siajn vestojn, kaj li estos malpura ĝis la vespero; kaj tiu, kiu portos ĝian kadavron, lavu siajn vestojn, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ĉia rampaĵo, kiu rampas sur la tero, estas abomenindaĵo, ĝi ne estu manĝata. ");
INSERT INTO epo_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ĉio, kio rampas sur la ventro, kaj ĉio, kio iras sur kvar piedoj aŭ sur pli da piedoj, sed estas rampaĵo, kiu rampas sur la tero — ilin ne manĝu, ĉar ili estas abomenindaĵo. ");
INSERT INTO epo_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ne abomenindigu viajn animojn per iaj bestoj rampantaj, kaj ne malpuriĝu per ili, farante vin mem malpuraj. ");
INSERT INTO epo_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ĉar Mi, la Eternulo, estas via Dio; tial sanktigu vin kaj estu sanktaj, ĉar Mi estas sankta; kaj ne malpurigu viajn animojn per ia rampaĵo, kiu rampas sur la tero. ");
INSERT INTO epo_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ĉar Mi estas la Eternulo, kiu elkondukis vin el la lando Egipta, por esti Dio por vi; estu do sanktaj, ĉar Mi estas sankta. ");
INSERT INTO epo_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Tio estas la leĝo pri la brutoj kaj pri la birdoj, kaj pri ĉiuj bestoj, moviĝantaj en la akvo, kaj pri ĉiuj bestoj, kiuj rampas sur la tero, ");
INSERT INTO epo_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","por fari diferencon inter la malpuraĵo kaj puraĵo, kaj inter la bestoj, kiujn oni povas manĝi, kaj la bestoj, kiujn oni devas ne manĝi. ");
INSERT INTO epo_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Diru al la Izraelidoj jene: Se virino fruktigos semon kaj naskos knabeton, tiam ŝi estos malpura dum sep tagoj; kiel en la tagoj de sia monataĵa suferado ŝi estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Kaj en la oka tago oni cirkumcidu la karnon de lia prepucio. ");
INSERT INTO epo_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Tridek tri tagojn ŝi restu en la sango de sia puriĝo; nenion sanktan ŝi tuŝu kaj en la sanktejon ŝi ne venu, ĝis finiĝos la tagoj de ŝia puriĝo. ");
INSERT INTO epo_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Se ŝi naskos knabineton, tiam ŝi estu malpura dum du semajnoj kiel ĉe sia monataĵo, kaj sesdek ses tagojn ŝi restu en la sango de sia puriĝo. ");
INSERT INTO epo_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Kaj kiam finiĝos la tagoj de ŝia puriĝo post filo aŭ filino, ŝi alportu jaraĝan ŝafidon kiel bruloferon, kaj kolombidon aŭ turton kiel pekoferon, al la pordo de la tabernaklo de kunveno, al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kaj li tion alportos antaŭ la Eternulon kaj pekliberigos ŝin, kaj ŝi puriĝos de sia sangofluado. Tio estas la leĝo pri naskintino, ĉu de knabo, ĉu de knabino. ");
INSERT INTO epo_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kaj se ŝi ne estas sufiĉe bonstata, por alporti ŝafidon, tiam ŝi prenu du turtojn aŭ du kolombidojn, unu kiel bruloferon kaj la duan kiel pekoferon; kaj la pastro pekliberigos ŝin, kaj ŝi puriĝos. ");
INSERT INTO epo_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Se ĉe iu homo sur la haŭto de lia korpo aperos ŝvelaĵo aŭ pustulo aŭ makulo tiamaniere, ke sur la haŭto de lia korpo fariĝos kvazaŭ infektaĵo de lepro, tiam oni alkonduku lin al la pastro Aaron aŭ al unu el liaj filoj, la pastroj. ");
INSERT INTO epo_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kaj la pastro rigardos la infektaĵon sur la haŭto de la korpo, kaj se li vidos, ke la haroj sur la infektaĵo fariĝis blankaj kaj la infektaĵo aspektas pli profunda ol la haŭto de lia korpo, tiam ĝi estas infektaĵo de lepro; kaj la pastro ĝin pririgardos, kaj deklaros, ke ĝi estas malpura. ");
INSERT INTO epo_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kaj se ĝi estos blanka makulo sur la haŭto de lia korpo, sed ĝi ne aspektos pli profunda ol la haŭto, kaj la haroj sur ĝi ne fariĝis blankaj, tiam la pastro enŝlosu la infektiton por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Kaj la pastro rigardos lin en la sepa tago, kaj se li vidos, ke la infektaĵo restis en la antaŭa stato, kaj ke la infektaĵo ne disvastiĝis sur la haŭto, tiam la pastro enŝlosu lin por pluaj sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kaj la pastro rigardos lin en la plua sepa tago, kaj se li vidos, ke la infektaĵo fariĝis malpli rimarkebla kaj ĝi ne disvastiĝis sur la haŭto, tiam la pastro deklaru lin pura: ĝi estas likeno: li lavu siajn vestojn, kaj li estos pura. ");
INSERT INTO epo_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Sed se la likeno tre disvastiĝis sur la haŭto, post kiam li montris sin al la pastro, ke tiu deklaru lin pura, tiam li duan fojon devas sin montri al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kaj se la pastro vidos, ke la likeno disvastiĝis sur la haŭto, tiam la pastro deklaros lin malpura: ĝi estas lepro. ");
INSERT INTO epo_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Se sur iu homo estos infektaĵo de lepro, oni alkonduku lin al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kaj se la pastro vidos, ke estas blanka ŝvelaĵo sur la haŭto kaj ke de ĝi la haroj fariĝis blankaj kaj sur la ŝvelaĵo estas kruda karno, ");
INSERT INTO epo_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","tiam tio estas malnova lepro sur la haŭto de lia korpo; kaj la pastro deklaros lin malpura, ne enŝlosos lin; ĉar li estas malpura. ");
INSERT INTO epo_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Se la lepro disfloros sur la haŭto kaj la lepro kovros la tutan haŭton de la infektito, de lia kapo ĝis la piedoj, ĉion, kion povas vidi la okuloj de la pastro; ");
INSERT INTO epo_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kaj la pastro vidos, ke la lepro kovris lian tutan korpon, tiam li deklaros la infektaĵon pura: ĉio fariĝis blanka, tial ĝi estas pura. ");
INSERT INTO epo_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Sed en la tago, en kiu montriĝos sur li kruda karno, li estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kiam la pastro vidos la krudan karnon, li deklaros lin malpura; la kruda karno estas malpura: ĝi estas lepro. ");
INSERT INTO epo_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Tamen se la kruda karno ŝanĝiĝos kaj fariĝos blanka, tiam li venu al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kaj kiam la pastro lin rigardos, kaj vidos, ke la infektaĵo aliformiĝis en blankaĵon, tiam la pastro deklaros la infektaĵon pura; li estos pura. ");
INSERT INTO epo_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kaj se sur ies korpo estos absceso kaj resaniĝos, ");
INSERT INTO epo_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kaj sur la loko de la absceso estos blanka ŝvelaĵo aŭ ruĝete-blanka makulo, tiam li devas sin montri al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kaj la pastro rigardos, kaj se li vidos, ke ĝi aspektas pli profunda ol la haŭto kaj ĝiaj haroj fariĝis blankaj, tiam la pastro deklaros lin malpura: ĝi estas infektaĵo de lepro, ĝi ekfloris en la absceso. ");
INSERT INTO epo_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kaj se la pastro vidos, ke ne estas sur ĝi blankaj haroj kaj ĝi ne estas pli profunda ol la haŭto kaj ĝi estas ne tre rimarkebla, tiam la pastro enŝlosos lin por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Sed se ĝi disvastiĝos sur la haŭto, tiam la pastro deklaros lin malpura: tio estas infektaĵo. ");
INSERT INTO epo_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Se la makulo restos sur sia loko kaj ne disvastiĝos, ĝi estas brulumo de absceso; kaj la pastro deklaros ĝin pura. ");
INSERT INTO epo_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Aŭ se sur la haŭto de lia korpo estos brulvundo kaj sur la karno de la brulvundo aperos makulo ruĝete-blanka aŭ blanka, ");
INSERT INTO epo_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kaj la pastro ĝin rigardos, kaj vidos, ke la haroj sur la makulo fariĝis blankaj kaj ĝi aspektas pli profunda ol la haŭto, tiam ĝi estas lepro, kiu ekfloris sur la brulvundo; kaj la pastro deklaros ĝin malpura: ĝi estas infektaĵo de lepro. ");
INSERT INTO epo_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Se la pastro vidos, ke sur la makulo ne estas blankaj haroj kaj ĝi ne estas pli profunda ol la haŭto kaj ĝi estas malmulte rimarkebla, tiam la pastro enŝlosos lin por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Kaj la pastro lin rigardos en la sepa tago; se ĝi disvastiĝis sur la haŭto, tiam la pastro deklaros lin malpura: ĝi estas infektaĵo de lepro. ");
INSERT INTO epo_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Sed se la makulo restis sur sia loko kaj ne disvastiĝis sur la haŭto kaj estas malmulte rimarkebla, tiam ĝi estas ŝvelaĵo de la brulvundo; kaj la pastro deklaros lin pura, ĉar ĝi estas brulumo de la brulvundo. ");
INSERT INTO epo_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Se ĉe viro aŭ ĉe virino estos infektaĵo sur la kapo aŭ sur la barbo, ");
INSERT INTO epo_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kaj la pastro rigardos la infektaĵon, kaj vidos, ke ĝi aspektas pli profunda ol la haŭto kaj sur ĝi estas haroj flavetaj kaj maldikaj, tiam la pastro deklaros lin malpura: tio estas favo, tio estas lepro de la kapo aŭ de la barbo. ");
INSERT INTO epo_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Sed se la pastro rigardos la infektaĵon de la favo, kaj vidos, ke ĝi ne aspektas pli profunda ol la haŭto kaj ne estas sur ĝi nigraj haroj, tiam la pastro enŝlosos la favo-infektiton por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kaj la pastro rigardos la infektiton en la sepa tago, kaj se li vidos, ke la favo ne disvastiĝis kaj ne estas sur ĝi flavetaj haroj kaj la favaĵo ne aspektas pli profunda ol la haŭto, ");
INSERT INTO epo_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","tiam oni lin razu, sed la favaĵon oni ne razu; kaj la pastro enŝlosos la favulon denove por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Kaj la pastro rigardos la favulon en la sepa tago, kaj se li vidos, ke la favo ne disvastiĝis sur la haŭto kaj ĝi ne aspektas pli profunda ol la haŭto, tiam la pastro deklaros lin pura; kaj li lavu siajn vestojn, kaj li estos pura. ");
INSERT INTO epo_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Sed se la favo disvastiĝos sur la haŭto, post kiam li estis deklarita pura, ");
INSERT INTO epo_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kaj la pastro vidos, ke la favo disvastiĝis sur la haŭto, tiam la pastro ne serĉu flavetajn harojn: li estas malpura. ");
INSERT INTO epo_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Sed se la favo haltis en sia stato kaj nigraj haroj elkreskis sur ĝi, tiam la favo saniĝis; li estas pura, kaj la pastro deklaros lin pura. ");
INSERT INTO epo_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Se sur la haŭto de la korpo de iu viro aŭ virino aperos makuloj, makuloj blankaj, ");
INSERT INTO epo_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kaj la pastro rigardos, kaj vidos, ke sur la haŭto de ilia korpo la makuloj estas pale-blankaj, tiam ĝi estas likeno, kiu ekfloris sur la haŭto; li estas pura. ");
INSERT INTO epo_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Se ĉe iu elfalis la haroj sur la kapo, li estas senharulo; li estas pura. ");
INSERT INTO epo_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Se lia kapo senhariĝas sur la antaŭa parto, li estas kalvulo; li estas pura. ");
INSERT INTO epo_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Sed se sur la senharaĵo aŭ sur la kalvaĵo estos infektaĵo blanke-ruĝeta, tiam ĝi estas lepro, kiu ekfloris sur lia senharaĵo aŭ sur lia kalvaĵo. ");
INSERT INTO epo_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kaj la pastro lin rigardos, kaj se li vidos, ke la ŝvelaĵo de la infektaĵo estas blanke-ruĝeta sur lia senharaĵo aŭ sur lia kalvaĵo, kiel aspektas lepro sur la haŭto de la korpo, ");
INSERT INTO epo_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","tiam tio estas leprulo, li estas malpura; la pastro deklaru lin malpura: sur lia kapo estas lia infektaĵo. ");
INSERT INTO epo_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Kaj la vestojn de la leprulo, sur kiu estos tiu infektaĵo, oni devas disŝiri, kaj lia kapo devas esti nekovrita, kaj ĝis la lipoj li devas esti ĉirkaŭkovrita, kaj li devas kriadi: Malpura, malpura! ");
INSERT INTO epo_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","La tutan tempon, dum la infektaĵo estos sur li, li estu rigardata kiel malpura; malpura li estas; li estu izolita, ekster la tendaro estu lia loĝejo. ");
INSERT INTO epo_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Kaj se estos infektaĵo de lepro sur vesto lana aŭ sur vesto lina, ");
INSERT INTO epo_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ĉu sur la fundamentaĵo, ĉu sur la enteksitaĵo, el lino aŭ el lano, ĉu sur felo, ĉu sur ia felaĵo, ");
INSERT INTO epo_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kaj la infektaĵo estos verdeta aŭ ruĝeta sur la vesto aŭ sur la felo, sur la fundamentaĵo aŭ sur la enteksitaĵo aŭ sur la felaĵo, tiam ĝi estas infektaĵo de lepro, kaj oni devas montri ĝin al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kaj la pastro pririgardos la infektitaĵon kaj enŝlosos la infektitaĵon por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Kaj li rigardos la infektitaĵon en la sepa tago; se li vidos, ke la infektaĵo disvastiĝis sur la vesto, aŭ sur la fundamentaĵo, aŭ sur la enteksitaĵo, aŭ sur ia felaĵo, tiam la infektaĵo estas lepro pereiga; ĝi estas malpura. ");
INSERT INTO epo_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kaj oni forbruligu la veston aŭ la fundamentaĵon aŭ la enteksitaĵon el lano aŭ el lino aŭ ĉian felaĵon, sur kiu estos la infektaĵo; ĉar ĝi estas lepro pereiga, per fajro oni devas ĝin forbruligi. ");
INSERT INTO epo_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Sed se la pastro vidos, ke la infektaĵo ne disvastiĝis sur la vesto aŭ sur la fundamentaĵo aŭ sur la enteksitaĵo aŭ sur ia felaĵo, ");
INSERT INTO epo_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","tiam la pastro ordonos, ke oni lavu tion, sur kio estas la infektaĵo, kaj li enŝlosos ĝin denove por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Kaj la pastro rigardos la infektaĵon post la lavo, kaj se li vidos, ke la infektaĵo ne ŝanĝis sian aspekton kaj la infektaĵo ne disvastiĝis, tiam ĝi estas malpura, per fajro oni ĝin forbruligu; ĝi estas penetriĝintaĵo sur la antaŭa aŭ malantaŭa flanko. ");
INSERT INTO epo_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Sed se la pastro vidos, ke la infektaĵo fariĝis malpli rimarkebla post la lavo, tiam li deŝiru ĝin de la vesto aŭ de la felo aŭ de la fundamentaĵo aŭ de la enteksitaĵo. ");
INSERT INTO epo_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Se ĝi denove aperos sur la vesto aŭ sur la fundamentaĵo aŭ sur la enteksitaĵo aŭ sur ia felaĵo, tiam ĝi estas florantaĵo; per fajro oni forbruligu tion, sur kio estas la infektaĵo. ");
INSERT INTO epo_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Sed la veston aŭ la fundamentaĵon aŭ la enteksitaĵon aŭ ĉian felaĵon, de kiuj post la lavo foriĝos la infektaĵo, oni lavu duan fojon, kaj ĝi estos pura. ");
INSERT INTO epo_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Tio estas la leĝo pri la infektaĵo de lepro sur vesto lana aŭ lina, ĉu sur fundamentaĵo, ĉu sur enteksitaĵo, aŭ sur ia felaĵo, por deklari ĝin pura aŭ malpura. ");
INSERT INTO epo_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Jen estas la leĝo pri la leprulo, en la tago, kiam oni devos purigi lin: oni venigu lin al la pastro; ");
INSERT INTO epo_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kaj la pastro eliros ekster la tendaron, kaj la pastro rigardos, kaj se li vidos, ke la infektaĵo de la lepro saniĝis ĉe la leprulo, ");
INSERT INTO epo_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","tiam la pastro ordonos preni por la purigoto du birdojn vivajn, purajn, kaj cedran lignon kaj ruĝan ŝnureton kaj hisopon. ");
INSERT INTO epo_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kaj la pastro ordonos buĉi unu birdon super argila vazo, super fluakvo. ");
INSERT INTO epo_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Kaj la vivan birdon li prenos kaj ankaŭ la cedran lignon kaj la ruĝan ŝnureton kaj la hisopon, kaj li trempos ilin kune kun la viva birdo en la sango de la birdo buĉita super la fluakvo. ");
INSERT INTO epo_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Kaj li aspergos la purigaton je la lepro sep fojojn, kaj li deklaros lin pura, kaj li lasos la vivan birdon forflugi sur la kampon. ");
INSERT INTO epo_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Kaj la purigato lavos siajn vestojn kaj forrazos ĉiujn siajn harojn kaj banos sin en akvo, kaj li estos pura; kaj poste li iros en la tendaron kaj restos ekster sia tendo dum sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","En la sepa tago li forrazos ĉiujn siajn harojn, sian kapon kaj sian barbon kaj la brovojn de siaj okuloj, ĉiujn siajn harojn li forrazos, kaj li lavos siajn vestojn kaj banos sian korpon en akvo, kaj li fariĝos pura. ");
INSERT INTO epo_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Kaj en la oka tago li prenos du ŝafidojn sendifektajn kaj unu ŝafidinon sendifektan, jaraĝan, kaj tri dekonojn de efo da delikata faruno, miksita kun oleo, kiel farunoferon, kaj unu log’on da oleo. ");
INSERT INTO epo_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kaj la pastro puriganta starigos la homon purigatan kaj ilin antaŭ la Eternulo, ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kaj la pastro prenos unu el la ŝafidoj kaj alportos ĝin kiel kulpoferon kune kun la log’o da oleo, kaj skuos tion kiel skuoferon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kaj li buĉos la ŝafidon sur la loko, sur kiu oni buĉas pekoferon kaj bruloferon, sur la sankta loko; ĉar, kiel la pekofero, la kulpofero apartenas al la pastro; ĝi estas plejsanktaĵo. ");
INSERT INTO epo_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kaj la pastro prenos iom el la sango de la kulpofero, kaj la pastro metos tion sur la malsupran randon de la dekstra orelo de la purigato kaj sur la dikan fingron de lia dekstra mano kaj sur la dikan fingron de lia dekstra piedo. ");
INSERT INTO epo_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kaj la pastro prenos iom el la log’o da oleo kaj verŝos sur sian maldekstran manplaton. ");
INSERT INTO epo_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kaj la pastro trempos sian dekstran fingron en la oleo, kiu estos sur lia maldekstra manplato, kaj li aspergos per la oleo de sia fingro sep fojojn antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kaj el la restaĵo de la oleo, kiu estos sur lia manplato, la pastro metos iom sur la malsupran randon de la dekstra orelo de la purigato kaj sur la dikan fingron de lia dekstra mano kaj sur la dikan fingron de lia dekstra piedo, sur la sangon de la kulpofero. ");
INSERT INTO epo_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kaj la restaĵon de la oleo, kiu estos sur la manplato de la pastro, ĉi tiu metos sur la kapon de la purigato; kaj la pastro pekliberigos lin antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kaj la pastro plenumos la pekoferon, kaj li pekliberigos la purigaton koncerne lian malpurecon, kaj poste li buĉos la bruloferon. ");
INSERT INTO epo_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kaj la pastro metos la bruloferon kaj la farunoferon sur la altaron; kaj la pastro pekliberigos lin, kaj li estos pura. ");
INSERT INTO epo_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Se li estas malriĉa kaj ne havas sufiĉe da bonstato, tiam li prenu unu ŝafidon, kiel pekoferon-skuataĵon, por pekliberiĝi, kaj unu dekonon de efo da delikata faruno, miksita kun oleo, kiel farunoferon, kaj log’on da oleo; ");
INSERT INTO epo_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","kaj du turtojn aŭ du kolombidojn, kiel lia stato permesos, kaj unu el ili estos pekofero kaj la dua estos brulofero. ");
INSERT INTO epo_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Kaj li alportos ilin en la oka tago de sia purigado al la pastro, al la pordo de la tabernaklo de kunveno, antaŭ la Eternulon. ");
INSERT INTO epo_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kaj la pastro prenos la ŝafidon de la kulpofero kaj la log’on da oleo, kaj la pastro skuos ilin kiel skuoferon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kaj li buĉos la ŝafidon de la kulpofero, kaj la pastro prenos iom el la sango de la kulpofero kaj metos ĝin sur la malsupran randon de la dekstra orelo de la purigato kaj sur la dikan fingron de lia dekstra mano kaj sur la dikan fingron de lia dekstra piedo. ");
INSERT INTO epo_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kaj el la oleo la pastro verŝos sur sian maldekstran manplaton. ");
INSERT INTO epo_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Kaj la pastro aspergos per sia dekstra fingro, per la oleo, kiu estos sur lia maldekstra manplato, sep fojojn antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kaj la pastro metos iom el la oleo, kiu estos sur lia manplato, sur la malsupran randon de la dekstra orelo de la purigato kaj sur la dikan fingron de lia dekstra mano kaj sur la dikan fingron de lia dekstra piedo, sur la lokon de la sango de la kulpofero. ");
INSERT INTO epo_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Kaj la restaĵon de la oleo, kiu estos sur la manplato de la pastro, li metos sur la kapon de la purigato, por pekliberigi lin antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Kaj li faros el unu el la turtoj aŭ el la kolombidoj, laŭ la grado de lia bonstato, ");
INSERT INTO epo_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","kiom permesos lia bonstato — el unu li faros pekoferon kaj el la dua li faros bruloferon kune kun la farunofero; kaj la pastro pekliberigos la purigaton antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Tio estas la leĝo pri persono, kiu havas infektaĵon de lepro kaj kiu ne estas sufiĉe bonstata dum sia puriĝado. ");
INSERT INTO epo_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Kiam vi venos en la landon Kanaanan, kiun Mi donas al vi kiel posedaĵon, kaj Mi ĵetus infektaĵon de lepro sur iun domon en la lando, kiun vi posedos, ");
INSERT INTO epo_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","tiam tiu, al kiu apartenas la domo, devas veni, kaj diri al la pastro jene: Sur mia domo aperis io simila al infektaĵo. ");
INSERT INTO epo_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Tiam la pastro ordonos, ke oni malplenigu la domon, antaŭ ol venos la pastro, por rigardi la infektaĵon, por ke ne malpuriĝu ĉio, kio estas en la domo; kaj post tio eniros la pastro, por ĉirkaŭrigardi la domon. ");
INSERT INTO epo_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kaj li rigardos la infektaĵon, kaj se li vidos, ke estas infektaĵo sur la muroj de la domo, kavetoj verdetaj aŭ ruĝetaj, kaj ili aspektas pli profundaj ol la supraĵo de la muro, ");
INSERT INTO epo_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","tiam la pastro eliros el la domo antaŭ la pordon de la domo, kaj li ŝlosos la domon por sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Kaj revenos la pastro en la sepa tago kaj rigardos; kaj se li vidos, ke la infektaĵo disvastiĝis sur la muroj de la domo, ");
INSERT INTO epo_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","tiam la pastro ordonos, ke oni elrompu la ŝtonojn, sur kiuj estas la infektaĵo, kaj oni ĵetu ilin ekster la urbon, sur lokon malpuran. ");
INSERT INTO epo_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Kaj la domon oni priskrapu interne ĉirkaŭe, kaj la kalkaĵon, kiun oni deskrapis, oni ĵetu ekster la urbon, sur lokon malpuran. ");
INSERT INTO epo_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Kaj oni prenu aliajn ŝtonojn kaj enmetu ilin sur la lokon de tiuj ŝtonoj, kaj oni prenu alian kalkaĵon kaj kalku la domon. ");
INSERT INTO epo_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Se la infektaĵo reaperos kaj floros sur la domo, post kiam oni elrompis la ŝtonojn kaj ĉirkaŭskrapis la domon kaj kalkis, ");
INSERT INTO epo_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kaj la pastro venos, kaj vidos, ke la infektaĵo disvastiĝis sur la domo, tiam tio estas pereiga lepro sur la domo; ĝi estas malpura. ");
INSERT INTO epo_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Kaj oni detruu la domon, ĝiajn ŝtonojn kaj lignon kaj la tutan kalkaĵon de la domo, kaj oni elportu tion ekster la urbon, sur lokon malpuran. ");
INSERT INTO epo_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kaj kiu eniros en la domon, dum la tuta tempo, en kiu ĝi estos ŝlosita, tiu estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Kaj kiu dormis en tiu domo, tiu lavu siajn vestojn; kaj kiu manĝis en tiu domo, tiu lavu siajn vestojn. ");
INSERT INTO epo_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Sed se la pastro venos, kaj vidos, ke la infektaĵo ne disvastiĝis sur la domo, post kiam oni kalkis la domon, tiam la pastro deklaros la domon pura, ĉar la infektaĵo saniĝis. ");
INSERT INTO epo_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Tiam, por senpekigi la domon, li prenu du birdojn kaj cedran lignon kaj ruĝan ŝnureton kaj hisopon; ");
INSERT INTO epo_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","kaj li buĉu unu el la birdoj super argila vazo, super fluakvo; ");
INSERT INTO epo_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","kaj li prenu la cedran lignon kaj la hisopon kaj la ruĝan ŝnureton kaj la vivan birdon, kaj li trempu ilin en la sango de la birdo buĉita kaj en la fluakvo kaj aspergu la domon sep fojojn. ");
INSERT INTO epo_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Kaj li senpekigos la domon per la sango de la birdo kaj per la fluakvo kaj per la viva birdo kaj per la cedra ligno kaj per la hisopo kaj per la ruĝa ŝnureto. ");
INSERT INTO epo_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kaj li lasos la vivan birdon forflugi ekster la urbon, sur la kampon; kaj li pekliberigos la domon, kaj ĝi estos pura. ");
INSERT INTO epo_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Tio estas la leĝo pri ĉiu infektaĵo de lepro kaj pri favo, ");
INSERT INTO epo_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","kaj pri lepro sur vesto kaj sur domo, ");
INSERT INTO epo_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kaj pri ŝvelaĵo kaj pri likeno kaj pri makulo; ");
INSERT INTO epo_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","por instrui, kiam oni devas deklari malpura kaj kiam oni devas deklari pura. Tio estas la leĝo pri la lepro. ");
INSERT INTO epo_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Parolu al la Izraelidoj, kaj diru al ili: Ĉiu, kiu havos elfluon el sia korpo, estos malpura pro sia elfluo. ");
INSERT INTO epo_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kaj tia estos lia malpureco pro lia elfluo: kiam fluas el lia korpo lia elfluo aŭ kiam ŝtopiĝis lia korpo per lia elfluo, ĝi estas lia malpureco. ");
INSERT INTO epo_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ĉiu lito, sur kiu kuŝos tiu, kiu havas elfluon, estos malpura; kaj ĉiu objekto, sur kiu li sidos, estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kaj se iu ektuŝos lian liton, li lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Kaj se iu sidiĝos sur ia objekto, sur kiu sidis la elfluulo, li lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Kaj kiu ektuŝos la korpon de la elfluulo, tiu lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Se la elfluulo kraĉos sur purulon, tiam ĉi tiu lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kaj ĉiu veturilo, sur kiu veturis la elfluulo, estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kaj ĉiu, kiu ektuŝos ion, kio estis sub tiu, estos malpura ĝis la vespero; kaj kiu portos tion, tiu lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Kaj ĉiu, kiun ektuŝos la elfluulo, ne lavinte siajn manojn per akvo, lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Kaj argilan vazon, kiun ektuŝos la elfluulo, oni rompu; kaj ĉiun lignan vazon oni lavu per akvo. ");
INSERT INTO epo_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Kaj kiam la elfluulo puriĝos de sia elfluo, tiam li kalkulu al si sep tagojn de post la tago de sia puriĝo, kaj li lavu siajn vestojn kaj banu sian korpon en fluakvo, kaj li estos pura. ");
INSERT INTO epo_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Kaj en la oka tago li prenu al si du turtojn aŭ du kolombidojn, kaj li venu antaŭ la Eternulon al la pordo de la tabernaklo de kunveno kaj donu ilin al la pastro. ");
INSERT INTO epo_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kaj la pastro oferfaros ilin, unu kiel pekoferon kaj la duan kiel bruloferon; kaj la pastro pekliberigos lin antaŭ la Eternulo koncerne lian elfluon. ");
INSERT INTO epo_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Se ĉe iu okazos elfluo de la semo, tiam li banu en akvo sian tutan korpon, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kaj ĉiun veston kaj ĉiun felon, sur kiun elverŝiĝis semo, oni lavu per akvo, kaj ĝi estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kaj kiam kun virino kuŝis viro kun elverŝo de semo, tiam ili banu sin en akvo, kaj ili estos malpuraj ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kaj kiam virino havos elfluon, sango fluos el ŝia korpo, tiam ŝi dum sep tagoj restu en sia malpureco; kaj ĉiu, kiu ŝin ektuŝos, estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kaj ĉio, sur kio ŝi kuŝos dum sia malpureco, estos malpura; kaj ĉio, sur kio ŝi sidos, estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Kaj ĉiu, kiu ektuŝos ŝian liton, lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Kaj ĉiu, kiu ektuŝos ian objekton, sur kiu ŝi sidis, lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kaj se io estos sur la lito, aŭ sur objekto, sur kiu ŝi sidis, kaj iu tion ektuŝos, tiam li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kaj se viro kuŝos kun ŝi kaj ŝia malpureco estos sur li, tiam li estos malpura dum sep tagoj; kaj ĉiu kuŝejo, sur kiu li kuŝos, estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Se ĉe virino fluos ŝia sango dum multaj tagoj ne en la tempo de ŝia monataĵo, aŭ se ŝi havos elfluon krom sia monataĵo, tiam dum la tuta tempo de elfluado de ŝia malpuraĵo, simile kiel dum la tempo de ŝia monataĵo, ŝi estos malpura. ");
INSERT INTO epo_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ĉiu kuŝejo, sur kiu ŝi kuŝos dum la tuta tempo de sia elfluado, estos kiel la kuŝejo dum ŝia monataĵo; kaj ĉiu objekto, sur kiu ŝi sidos, estos malpura, simile al la malpureco dum ŝia monataĵo. ");
INSERT INTO epo_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Kaj ĉiu, kiu ektuŝos ilin, estos malpura; li lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Kaj kiam ŝi puriĝos de sia elfluo, tiam ŝi kalkulu al si sep tagojn, kaj poste ŝi estos pura. ");
INSERT INTO epo_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Kaj en la oka tago ŝi prenu al si du turtojn aŭ du kolombidojn, kaj ŝi alportu ilin al la pastro, al la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kaj la pastro oferfaros unu kiel pekoferon kaj la duan kiel bruloferon; kaj la pastro pekliberigos ŝin antaŭ la Eternulo koncerne la elfluon de ŝia malpureco. ");
INSERT INTO epo_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Tiel antaŭgardu la Izraelidojn kontraŭ ilia malpureco, por ke ili ne mortu en sia malpureco, malpurigante Mian loĝejon, kiu estas inter ili. ");
INSERT INTO epo_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Tio estas la leĝo pri la havanto de elfluo, kaj pri tiu, kiu havas elverŝiĝon de semo, per kio li fariĝas malpura; ");
INSERT INTO epo_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kaj pri malsanulino pro sia monataĵo; kaj pri havanto de elfluo, ĉu tio estas viro, ĉu virino; kaj pri viro, kiu kuŝos kun malpurulino. ");
INSERT INTO epo_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Kaj la Eternulo ekparolis al Moseo post la morto de la du filoj de Aaron, kiam ili venis antaŭ la Eternulon kaj mortis. ");
INSERT INTO epo_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Kaj la Eternulo diris al Moseo: Diru al via frato Aaron, ke li ne en ĉiu tempo eniru en la sanktejon malantaŭ la kurtenon, antaŭ la fermoplaton, kiu estas sur la kesto, por ke li ne mortu; ĉar en nubo Mi aperados super la fermoplato. ");
INSERT INTO epo_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Kun jeno Aaron venadu en la sanktejon: kun bovido por pekofero kaj kun virŝafo por brulofero. ");
INSERT INTO epo_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Sanktan linan ĥitonon li surmetu sur sin, kaj linaj pantalonoj estu sur lia korpo, kaj per lina zono li zonu sin, kaj linan cidaron li havu sur la kapo: tio estas sanktaj vestoj. Kaj li banu en akvo sian korpon kaj surmetu ilin sur sin. ");
INSERT INTO epo_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kaj de la komunumo de la Izraelidoj li prenu du kaprojn por pekofero kaj unu virŝafon por brulofero. ");
INSERT INTO epo_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Kaj Aaron alportos sian bovidon de pekofero, kaj pekliberigos sin kaj sian domon. ");
INSERT INTO epo_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Kaj li prenos la du kaprojn, kaj starigos ilin antaŭ la Eternulo, ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Kaj Aaron faros lotojn pri la du kaproj: unu loton por la Eternulo kaj la duan loton por Azazel. ");
INSERT INTO epo_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Kaj Aaron alportos la kapron, sur kiun falis la loto por la Eternulo, kaj li oferfaros ĝin kiel pekoferon. ");
INSERT INTO epo_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Kaj la kapron, sur kiun falis la loto por Azazel, li starigu vivan antaŭ la Eternulo, por fari super ĝi pekliberigon kaj forsendi ĝin al Azazel en la dezerton. ");
INSERT INTO epo_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Kaj Aaron alportos sian bovidon de pekofero, kaj pekliberigos sin kaj sian domon, kaj buĉos sian bovidon de pekofero. ");
INSERT INTO epo_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Kaj li prenos plenan incensujon da ardantaj karboj de la altaro, kiu staras antaŭ la Eternulo, kaj plenajn plenmanojn da bonodora pistita incenso, kaj li enportos tion malantaŭ la kurtenon. ");
INSERT INTO epo_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Kaj li metos la incenson sur la fajron antaŭ la Eternulon, kaj nubo de la incenso kovros la fermoplaton, kiu estas sur la kesto de atesto, por ke li ne mortu. ");
INSERT INTO epo_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kaj li prenos iom el la sango de la bovido kaj aspergos per sia fingro la antaŭan parton de la fermoplato, kaj antaŭ la fermoplato li aspergos sep fojojn per la sango, kiu estos sur lia fingro. ");
INSERT INTO epo_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Kaj li buĉos la pekoferan kapron de la popolo, kaj li enportos ĝian sangon malantaŭ la kurtenon, kaj agos kun ĝia sango tiel same, kiel li agis kun la sango de la bovido, kaj li aspergos per ĝi sur la fermoplaton kaj antaŭ la fermoplato. ");
INSERT INTO epo_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kaj li pekliberigos la sanktejon koncerne la malpuraĵojn de la Izraelidoj kaj iliajn krimojn, en ĉiuj iliaj pekoj; kaj tiel li agos kun la tabernaklo de kunveno, kiu estas inter ili, meze de iliaj malpuraĵoj. ");
INSERT INTO epo_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Neniu homo estu en la tabernaklo de kunveno, kiam li eniros, por pekliberigi la sanktejon, ĝis li eliros. Kaj li pekliberigos sin kaj sian domon kaj la tutan komunumon de Izrael. ");
INSERT INTO epo_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Kaj li eliros al la altaro, kiu estas antaŭ la Eternulo, kaj pekliberigos ĝin; kaj li prenos iom el la sango de la bovido kaj el la sango de la kapro, kaj metos ĝin sur la kornojn de la altaro ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Kaj li aspergos ĝin sep fojojn per la sango, kiu estas sur lia fingro, kaj li purigos ĝin kaj sanktigos ĝin de la malpuraĵoj de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Kiam li finos la pekliberigadon de la sanktejo kaj de la tabernaklo de kunveno kaj de la altaro, li alkondukos la vivan kapron; ");
INSERT INTO epo_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","kaj Aaron metos siajn ambaŭ manojn sur la kapon de la viva kapro kaj konfesos super ĝi ĉiujn malbonagojn de la Izraelidoj kaj ĉiujn iliajn krimojn kaj ĉiujn iliajn pekojn, kaj li metos ilin sur la kapon de la kapro kaj forsendos ĝin per speciala homo en la dezerton. ");
INSERT INTO epo_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kaj la kapro forportos sur si ĉiujn iliajn malbonagojn en landon senkomunikiĝan; kaj li foririgos la kapron en la dezerton. ");
INSERT INTO epo_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Kaj Aaron eniros en la tabernaklon de kunveno, kaj demetos de si la linajn vestojn, kiujn li surmetis, enirante en la sanktejon, kaj li restigos ilin tie. ");
INSERT INTO epo_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kaj li banos sian korpon en akvo sur sankta loko, kaj li surmetos sur sin siajn vestojn, kaj eliros kaj oferfaros sian bruloferon kaj la bruloferon de la popolo, kaj li pekliberigos sin kaj la popolon. ");
INSERT INTO epo_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Kaj la sebon de la pekofero li fumbruligu sur la altaro. ");
INSERT INTO epo_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Kaj tiu, kiu forkondukis la kapron por Azazel, lavu siajn vestojn kaj banu sian korpon en akvo, kaj poste li povas eniri en la tendaron. ");
INSERT INTO epo_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kaj la propekan bovidon kaj la propekan kapron, kies sango estis enportita, por pekliberigi la sanktejon, oni elportu ekster la tendaron, kaj oni forbruligu per fajro ilian felon kaj ilian karnon kaj ilian malpuraĵon. ");
INSERT INTO epo_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Kaj tiu, kiu forbruligis ilin, lavu siajn vestojn kaj banu sian korpon en akvo, kaj poste li povas eniri en la tendaron. ");
INSERT INTO epo_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Kaj tio estu por vi eterna leĝo: en la sepa monato, en la deka tago de la monato, premu viajn animojn, kaj faru nenian laboron, nek la indiĝeno, nek la fremdulo, kiu loĝas inter vi. ");
INSERT INTO epo_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ĉar en tiu tago oni vin pekliberigos, por purigi vin; de ĉiuj viaj pekoj antaŭ la Eternulo vi fariĝos puraj. ");
INSERT INTO epo_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Sabato de plena ripozo ĝi estu por vi; kaj premu viajn animojn; ĝi estu leĝo por eterne. ");
INSERT INTO epo_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Pekliberigos la pastro, kiu estas sanktoleita, kaj kiu estas konsekrita, por pastri anstataŭ sia patro; kaj li surmetos sur sin la linajn vestojn, la sanktajn vestojn. ");
INSERT INTO epo_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Kaj li pekliberigos la plej sanktan sanktejon kaj la tabernaklon de kunveno, kaj la altaron li pekliberigos; kaj la pastrojn kaj la tutan popolon de la komunumo li pekliberigos. ");
INSERT INTO epo_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Kaj tio estu por vi leĝo eterna: pekliberigi la Izraelidojn koncerne iliajn pekojn unu fojon en jaro. Kaj li faris, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Parolu al Aaron kaj al liaj filoj kaj al ĉiuj Izraelidoj, kaj diru al ili: Jen estas tio, kion la Eternulo ordonis: ");
INSERT INTO epo_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Se iu el la domo de Izrael buĉos bovon aŭ ŝafon aŭ kapron en la tendaro, aŭ se li buĉos ĝin ekster la tendaro, ");
INSERT INTO epo_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kaj ne alkondukos ĝin al la pordo de la tabernaklo de kunveno, por prezenti ĝin kiel oferon al la Eternulo, antaŭ la loĝejo de la Eternulo, tiam tiu homo estos kulpa pri sango: li verŝis sangon, kaj tiu homo ekstermiĝos el inter sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Por ke la Izraelidoj alkondukadu siajn buĉotojn, kiujn ili volas buĉi sur la kampo, kaj ili alkonduku ilin antaŭ la Eternulon, al la pordo de la tabernaklo de kunveno, al la pastro, kaj ili buĉu ilin kiel pacoferojn al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kaj la pastro aspergos per la sango la altaron de la Eternulo ĉe la pordo de la tabernaklo de kunveno, kaj li fumbruligos la sebon kiel agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ili ne buĉu plu siajn oferbrutojn al la demonoj, kiujn ili malĉaste adoras. Leĝo eterna tio estu por ili en iliaj generacioj. ");
INSERT INTO epo_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Kaj diru al ili: Se iu el la domo de Izrael, aŭ el la fremduloj, kiuj loĝas inter ili, alportos bruloferon aŭ simplan oferon, ");
INSERT INTO epo_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kaj ne alkondukos ĝin al la pordo de la tabernaklo de kunveno, por oferfari ĝin al la Eternulo, tiam tiu homo ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Se iu el la domo de Izrael, aŭ el la fremduloj, kiuj loĝas inter ili, manĝos ian sangon, tiam Mi turnos Mian vizaĝon kontraŭ tiun, kiu manĝis la sangon, kaj Mi ekstermos lin el inter lia popolo. ");
INSERT INTO epo_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ĉar la animo de korpo estas en la sango; kaj Mi destinis al vi ĉi tion por la altaro, por pekliberigi viajn animojn, ĉar la sango pekliberigas per la animo. ");
INSERT INTO epo_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Tial Mi diris al la Izraelidoj: Neniu el vi manĝu sangon, kaj ankaŭ la fremdulo, kiu loĝas inter vi, ne manĝu sangon. ");
INSERT INTO epo_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Se iu el la Izraelidoj, aŭ el la fremduloj, kiuj loĝas inter ili, ĉaskaptos beston aŭ birdon, kiun oni povas manĝi, tiam li elfluigu ĝian sangon kaj kovru ĝin per polvo. ");
INSERT INTO epo_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ĉar la animo de ĉiu korpo estas ĝia sango, en ĝia animo ĝi estas. Tial Mi diris al la Izraelidoj: La sangon de ia korpo ne manĝu, ĉar la animo de ĉiu korpo estas ĝia sango; ĉiu, kiu ĝin manĝos, ekstermiĝos. ");
INSERT INTO epo_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kaj ĉiu, kiu manĝos mortintaĵon aŭ disŝiritaĵon, ĉu li estas indiĝeno, ĉu fremdulo, lavu siajn vestojn kaj banu sin en akvo, kaj li estos malpura ĝis la vespero, kaj poste li estos pura. ");
INSERT INTO epo_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Sed se li ne lavos kaj sian korpon ne banos, li portos sur si sian malbonagon. ");
INSERT INTO epo_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Parolu al la Izraelidoj, kaj diru al ili: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Laŭ la agoj de la lando Egipta, en kiu vi loĝis, ne agu; kaj laŭ la agoj de la lando Kanaana, en kiun Mi venigas vin, ne agu; laŭ iliaj leĝoj ne kondutu. ");
INSERT INTO epo_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Miajn decidojn plenumu kaj Miajn leĝojn observu, por konduti laŭ ili: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Kaj observu Miajn leĝojn kaj Miajn decidojn, kiujn plenumante, la homo vivas per ili: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Neniu alproksimiĝu al iu sia korpoparencino, por malkovri nudecon: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","La nudecon de via patro kaj la nudecon de via patrino ne malkovru: ŝi estas via patrino, ne malkovru ŝian nudecon. ");
INSERT INTO epo_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","La nudecon de via patredzino ne malkovru: ĝi estas la nudeco de via patro. ");
INSERT INTO epo_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","La nudecon de via fratino, filino de via patro aŭ filino de via patrino, ĉu ŝi naskiĝis en la domo, ĉu ŝi naskiĝis ekstere, ne malkovru ilian nudecon. ");
INSERT INTO epo_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","La nudecon de filino de via filo aŭ de filino de via filino, ne malkovru ilian nudecon; ĉar tio estas via nudeco. ");
INSERT INTO epo_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","La nudecon de filino de via patredzino, kiu naskiĝis de via patro, ŝi estas via fratino, ne malkovru ŝian nudecon. ");
INSERT INTO epo_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","La nudecon de fratino de via patro ne malkovru: ŝi estas korpoparencino de via patro. ");
INSERT INTO epo_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","La nudecon de fratino de via patrino ne malkovru; ĉar ŝi estas korpoparencino de via patrino. ");
INSERT INTO epo_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","La nudecon de frato de via patro ne malkovru, al lia edzino ne alproksimiĝu: ŝi estas via onklino. ");
INSERT INTO epo_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","La nudecon de via bofilino ne malkovru: ŝi estas edzino de via filo, ne malkovru ŝian nudecon. ");
INSERT INTO epo_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","La nudecon de edzino de via frato ne malkovru: ĝi estas nudeco de via frato. ");
INSERT INTO epo_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","La nudecon de virino kaj de ŝia filino ne malkovru: filinon de ŝia filo kaj filinon de ŝia filino ne prenu, por malkovri ilian nudecon: ili estas korpoparencinoj; tio estas malĉasteco. ");
INSERT INTO epo_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kaj virinon kune kun ŝia fratino ne prenu kiel konkurantinon, por malkovri ŝian nudecon apud ŝi, dum ŝia vivo. ");
INSERT INTO epo_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Kaj al virino dum ŝia monata malpureco ne alproksimiĝu, por malkovri ŝian nudecon. ");
INSERT INTO epo_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kaj kun la edzino de via proksimulo ne kuŝu pro semo, malpuriĝante kun ŝi. ");
INSERT INTO epo_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Kaj el via idaro ne fordonu oferon al Moleĥ, kaj ne malhonoru la nomon de via Dio: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Kaj kun virseksulo ne kuŝu, kiel oni kuŝas kun virino: tio estas abomenaĵo. ");
INSERT INTO epo_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kaj kun nenia bruto kuŝu, malpuriĝante per ĝi; kaj virino ne stariĝu antaŭ bruto, por kuniĝi: tio estas fiaĵo. ");
INSERT INTO epo_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ne malpuriĝu per ĉio ĉi tio; ĉar per ĉio ĉi tio malpuriĝis la popoloj, kiujn Mi forpelas de antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Kaj malpuriĝis la tero, kaj Mi postulas respondon pri ĝia malbonagado, kaj la tero elĵetas siajn loĝantojn. ");
INSERT INTO epo_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Sed vi observu Miajn leĝojn kaj Miajn decidojn, kaj ne faru iujn el tiuj abomenaĵoj, nek la indiĝeno, nek la fremdulo, kiu loĝas inter vi ");
INSERT INTO epo_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(ĉar ĉiujn tiujn abomenaĵojn faris la homoj de tiu tero, kiuj loĝis antaŭ vi, kaj la tero malpuriĝis); ");
INSERT INTO epo_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","por ke la tero ne elĵetu ankaŭ vin, kiam vi malpurigos ĝin, kiel ĝi elĵetis la popolon, kiu estis antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ĉar se iu faros ion el ĉiuj tiuj abomenaĵoj, la farantoj ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Observu do Miajn ordonojn, por ke vi ne agu laŭ la abomenindaj leĝoj, laŭ kiuj oni agis antaŭ vi, kaj por ke vi ne malpuriĝu per ili: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Parolu al la tuta komunumo de la Izraelidoj, kaj diru al ili: Sanktaj estu, ĉar sankta estas Mi, la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ĉiu el vi timu sian patrinon kaj sian patron, kaj Miajn sabatojn observu: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ne turnu vin al idoloj, kaj diojn fanditajn ne faru al vi: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kaj kiam vi buĉos pacoferon al la Eternulo, buĉu ĝin, por akiri plaĉon. ");
INSERT INTO epo_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","En la tago de la oferado ĝi estu manĝata kaj en la morgaŭa tago; sed tion, kio restis ĝis la tria tago, oni forbruligu per fajro. ");
INSERT INTO epo_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Sed se oni ĝin manĝos en la tria tago, ĝi estos abomenaĵo, ĝi ne plaĉos. ");
INSERT INTO epo_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Kaj ĝia manĝinto portos sur si sian malbonagon, ĉar li malhonoris la sanktaĵon de la Eternulo; kaj tiu animo ekstermiĝos el sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kaj kiam vi rikoltos rikoltaĵon de via tero, ne rikoltu ĉion ĝis la rando de via kampo, kaj la restaĵon de via rikoltaĵo ne forkolektu. ");
INSERT INTO epo_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kaj vian vinberejon ne tute senberigu, kaj la falintajn berojn en via vinberejo ne forkolektu; por la malriĉulo kaj por la fremdulo restigu ilin: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ne ŝtelu, kaj ne mensogu, kaj ne trompu unu alian. ");
INSERT INTO epo_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kaj ne ĵuru per Mia nomo mensoge, malhonorante la nomon de via Dio: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ne premu vian proksimulon kaj ne rabu; la pago por dungito ne noktorestu ĉe vi ĝis mateno. ");
INSERT INTO epo_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ne malbenu surdulon, kaj antaŭ blindulo ne kuŝigu falilon; timu vian Dion: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ne faru maljustaĵon en la juĝado, ne estu partia por malriĉulo kaj ne estimu potenculon; juste juĝu vian proksimulon. ");
INSERT INTO epo_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ne disportu kalumniojn inter via popolo, ne staru kontraŭ la sango de via proksimulo: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ne malamu vian fraton en via koro; admonu vian proksimulon, por ke vi ne portu sur vi pekon pro li. ");
INSERT INTO epo_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ne faru venĝon kaj ne portu koleron kontraŭ la filoj de via popolo; amu vian proksimulon kiel vin mem: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Miajn leĝojn observu. Vian bruton ne parigu miksospece, vian kampon ne prisemu miksospece, kaj veston miksospecan el lano kaj lino ne surmetu sur vin. ");
INSERT INTO epo_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Se viro kuŝas kun virino pro semo, kaj ŝi estas sklavino, ordonita al viro, sed ankoraŭ ne elaĉetita aŭ ne ricevinta liberecon, tiam devas esti enketo, sed ili ne mortu, ĉar ŝi ne estis libera. ");
INSERT INTO epo_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Li alportu pro sia kulpo al la Eternulo antaŭ la pordon de la tabernaklo de kunveno virŝafon kiel pekoferon. ");
INSERT INTO epo_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kaj la pastro pekliberigos lin per la virŝafo de pekofero antaŭ la Eternulo koncerne la pekon, kiun li pekis, kaj pardonita estos al li la peko, kiun li pekis. ");
INSERT INTO epo_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kaj kiam vi venos en la landon kaj plantos ian arbon manĝodonan, tiam rigardu ĝiajn fruktojn kvazaŭ konsekritaj; dum tri jaroj ili estu por vi kvazaŭ konsekritaj, ili ne estu manĝataj. ");
INSERT INTO epo_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","En la kvara jaro ĉiuj ĝiaj fruktoj estu sanktaj, dankoferoj al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Sed en la kvina jaro vi povas manĝi ĝiajn fruktojn, kolektante por vi ĝiajn produktaĵojn: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ne manĝu kun sango; ne aŭguru kaj ne antaŭdiru sorĉe. ");
INSERT INTO epo_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ne ĉirkaŭtondu la flankojn de via kapo kaj ne fordifektu la flankojn de via barbo. ");
INSERT INTO epo_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Entranĉojn pro mortinto ne faru sur via korpo kaj skribon enpikitan ne faru sur vi: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ne senhonorigu vian filinon, prostituante ŝin; por ke la lando ne fariĝu prostituista kaj por ke la lando ne pleniĝu de malĉasteco. ");
INSERT INTO epo_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Miajn sabatojn gardu kaj Mian sanktejon respektu: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne turnu vin al magiistoj nek al sorĉistoj, ne provu malpuriĝi per ili: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Antaŭ grizulo stariĝu, kaj respektu la vizaĝon de maljunulo, kaj timu vian Dion: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kaj se ekloĝos ĉe vi fremdulo en via lando, ne premu lin. ");
INSERT INTO epo_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kiel indiĝeno el inter vi estu por vi la fremdulo, kiu ekloĝis ĉe vi, kaj amu lin kiel vin mem, ĉar fremduloj vi estis en la lando Egipta: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ne faru maljustaĵon en la juĝo, en la mezuro, en la peso, en la amplekso. ");
INSERT INTO epo_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Pesilo ĝusta, peziloj ĝustaj, efo ĝusta, kaj hino ĝusta estu ĉe vi: Mi estas la Eternulo, via Dio, kiu elkondukis vin el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kaj observu ĉiujn Miajn leĝojn kaj ĉiujn Miajn decidojn kaj plenumu ilin: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Al la Izraelidoj diru: Ĉiu el la Izraelidoj, kaj el la fremduloj, kiuj loĝas inter la Izraelidoj, kiu donos iun el siaj idoj al Moleĥ, mortu; la popolo de la lando mortigu lin per ŝtonoj. ");
INSERT INTO epo_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mi turnos Mian vizaĝon kontraŭ tiun homon, kaj Mi ekstermos lin el inter lia popolo pro tio, ke el siaj idoj li donis al Moleĥ, por malpurigi Mian sanktejon kaj malhonori Mian sanktan nomon. ");
INSERT INTO epo_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kaj se la popolo de la lando kovros siajn okulojn for de tiu homo, kiam li donos iun el siaj idoj al Moleĥ, kaj ne mortigos lin: ");
INSERT INTO epo_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","tiam Mi turnos Mian vizaĝon kontraŭ tiun homon kaj kontraŭ lian familion, kaj Mi ekstermos lin, kaj ĉiujn, kiuj malĉastos, imitante lin en la malĉastado por Moleĥ, el inter ilia popolo. ");
INSERT INTO epo_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Kaj se iu animo sin turnos al magiistoj kaj sorĉistoj, por malĉasti sub ilia gvido, tiam Mi turnos Mian vizaĝon kontraŭ tiun animon kaj ekstermos ĝin el inter ĝia popolo. ");
INSERT INTO epo_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Sanktigu vin kaj estu sanktaj, ĉar Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kaj observu Miajn leĝojn kaj plenumu ilin: Mi estas la Eternulo, kiu sanktigas vin. ");
INSERT INTO epo_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ĉiu, kiu malbenas sian patron aŭ sian patrinon, estu mortigita: sian patron kaj sian patrinon li malbenis, lia sango estu sur li. ");
INSERT INTO epo_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Kaj se iu adultis kun edzinigita virino, se iu adultis kun la edzino de sia proksimulo, estu mortigitaj la adultinto kaj la adultintino. ");
INSERT INTO epo_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Kaj se iu kuŝis kun la edzino de sia patro, li malkovris la nudecon de sia patro; ambaŭ ili estu mortigitaj, ilia sango estu sur ili. ");
INSERT INTO epo_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kaj se iu kuŝis kun sia bofilino, ili ambaŭ estu mortigitaj: abomenaĵon ili faris, ilia sango estu sur ili. ");
INSERT INTO epo_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kaj se iu kuŝis kun viro kiel kun virino, abomenaĵon ili ambaŭ faris: ili estu mortigitaj, ilia sango estu sur ili. ");
INSERT INTO epo_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kaj se iu prenis virinon kaj ŝian patrinon, tio estas malĉastegeco: per fajro oni forbruligu lin kaj ilin, por ke ne estu malĉasteco inter vi. ");
INSERT INTO epo_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kaj se iu kuŝis kun bruto, li estu mortigita, kaj ankaŭ la bruton mortigu. ");
INSERT INTO epo_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kaj se virino alproksimiĝis al ia bruto, por sekskuniĝi kun ĝi, tiam mortigu la virinon kaj la bruton: ili estu mortigitaj, ilia sango estu sur ili. ");
INSERT INTO epo_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kaj se iu prenis sian fratinon, filinon de sia patro aŭ filinon de sia patrino, kaj li vidis ŝian nudecon kaj ŝi vidis lian nudecon, tio estas maldecaĵo; kaj ili devas esti ekstermitaj antaŭ la okuloj de sia popolo: la nudecon de sia fratino li malkovris, li portu sian pekon. ");
INSERT INTO epo_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kaj se iu kuŝis kun virino dum ŝia malsano kaj malkovris ŝian nudecon, li vidatigis ŝian elfluejon kaj ŝi malkovris la elfluejon de sia sango: ili ambaŭ estu ekstermitaj el inter sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Kaj la nudecon de la fratino de via patrino kaj de la fratino de via patro ne malkovru; ĉar li nudigis sian korpoparencinon, ili portu sian pekon. ");
INSERT INTO epo_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kaj se iu kuŝis kun sia onklino, li malkovris la nudecon de sia onklo: ili portu sian pekon, ili mortos seninfanaj. ");
INSERT INTO epo_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Kaj se iu prenis la edzinon de sia frato, tio estas malpuraĵo: la nudecon de sia frato li malkovris, seninfanaj ili estos. ");
INSERT INTO epo_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Kaj observu ĉiujn Miajn leĝojn kaj ĉiujn Miajn decidojn kaj plenumu ilin, por ke ne elĵetu vin la lando, en kiun Mi kondukas vin, por tie loĝi. ");
INSERT INTO epo_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kaj ne agu laŭ la leĝoj de la popolo, kiun Mi forpelas de antaŭ vi, ĉar ĉion ĉi tion ili faris kaj Mi ekabomenis ilin. ");
INSERT INTO epo_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Kaj Mi diris al vi: Vi heredos ilian landon, kaj Mi ĝin donos al vi, por ke vi posedu ĝin, la landon, en kiu fluas lakto kaj mielo. Mi estas la Eternulo, via Dio, kiu distingis vin el inter la popoloj. ");
INSERT INTO epo_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kaj faru diferencon inter bruto pura kaj malpura kaj inter birdo malpura kaj pura; kaj ne malpurigu viajn animojn per bruto kaj per birdo, kaj per ĉio, kio moviĝas sur la tero, kion Mi apartigis por vi, ke vi rigardu ilin kiel malpurajn. ");
INSERT INTO epo_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kaj estu antaŭ Mi sanktaj, ĉar sankta estas Mi, la Eternulo, kaj Mi apartigis vin el inter la popoloj, por ke vi estu Miaj. ");
INSERT INTO epo_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Kaj viro aŭ virino, se ili estos magiistoj aŭ sorĉistoj, estu mortigitaj; per ŝtonoj oni ilin mortigu, ilia sango estu sur ili. ");
INSERT INTO epo_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Kaj la Eternulo diris al Moseo: Parolu al la pastroj, la Aaronidoj, kaj diru al ili: Neniu el ili malpurigu sin per mortinto en sia popolo; ");
INSERT INTO epo_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","krom nur per sia proksima parenco, per sia patrino, per sia patro, per sia filo, per sia filino, kaj per sia frato; ");
INSERT INTO epo_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kaj per sia fratino-virgulino, proksima al li, kiu ne estis edzinigita, per ŝi li povas sin malpurigi. ");
INSERT INTO epo_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Li ne malpurigu sin, kiel estro en sia popolo, malsanktigante sin. ");
INSERT INTO epo_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ili ne faru al si senharaĵon sur sia kapo, kaj la flankojn de sia barbo ili ne razu, kaj sur sia korpo ili ne faru entranĉojn. ");
INSERT INTO epo_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Sanktaj ili estu antaŭ sia Dio, kaj ili ne malsanktigu la nomon de sia Dio; ĉar la fajroferojn al la Eternulo, la panon al sia Dio ili alportas; tial ili estu sanktaj. ");
INSERT INTO epo_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Virinon malĉastan aŭ senhonorigitan ili ne prenu, kaj virinon, forpuŝitan de sia edzo, ili ne prenu; ĉar pastro estas sankta al sia Dio. ");
INSERT INTO epo_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tial tenu lin sankte, ĉar la panon de via Dio li alportas; sankta li estu por vi, ĉar sankta estas Mi, la Eternulo, kiu sanktigas vin. ");
INSERT INTO epo_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Se filino de pastro senhonoriĝis per malĉastado, ŝi senhonorigas sian patron: oni forbruligu ŝin per fajro. ");
INSERT INTO epo_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","La granda pastro inter siaj fratoj, tiu, sur kies kapon estas verŝita la sankta oleo, kaj kiu estas konsekrita, por porti la vestojn, ne devas nudigi sian kapon nek disŝiri siajn vestojn. ");
INSERT INTO epo_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Kaj al neniu mortinto li venu; eĉ per sia patro aŭ sia patrino li sin ne malpurigu. ");
INSERT INTO epo_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kaj el la sanktejo li ne eliru, kaj li ne malhonoru la sanktejon de sia Dio; ĉar sanktigo per la sankta oleo de lia Dio estas sur li: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Edzinon li prenu al si virgulinon. ");
INSERT INTO epo_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Vidvinon, forpuŝitinon, senhonorigitinon, aŭ malĉastulinon li ne prenu, sed nur virgulinon el sia popolo li prenu kiel edzinon. ");
INSERT INTO epo_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Kaj li ne senhonorigu sian semon en sia popolo, ĉar Mi estas la Eternulo, kiu lin sanktigas. ");
INSERT INTO epo_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Diru al Aaron jene: Se iu el via idaro en iliaj generacioj havos ian kriplaĵon, li ne alproksimiĝu, por alporti la panon de sia Dio. ");
INSERT INTO epo_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ĉar neniu, kiu havas ian kriplaĵon, alproksimiĝu: nek blindulo, nek lamulo, nek platnazulo, nek monstrulo, ");
INSERT INTO epo_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","nek homo, kiu havas rompitan kruron aŭ rompitan brakon, ");
INSERT INTO epo_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","nek ĝibulo, nek ftizulo, nek makulokululo, nek aknulo, nek favulo, nek herniulo. ");
INSERT INTO epo_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Neniu, kiu havas kriplaĵon el la idaro de Aaron la patro, alproksimiĝu, por alporti la fajroferojn de la Eternulo: li havas kriplaĵon, tial li ne alproksimiĝu, por alporti la panon de sia Dio. ");
INSERT INTO epo_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","La panon de sia Dio el la plejsanktaĵoj kaj el la sanktaĵoj li povas manĝi. ");
INSERT INTO epo_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Sed al la kurteno li ne aliru kaj al la altaro li ne alproksimiĝu, ĉar li havas kriplaĵon; por ke li ne malhonoru Miajn sanktejojn, ĉar Mi, la Eternulo, ilin sanktigas. ");
INSERT INTO epo_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Kaj Moseo tion diris al Aaron kaj al liaj filoj kaj al ĉiuj Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Diru al Aaron kaj al liaj filoj, ke ili agu singarde koncerne la sanktaĵojn de la Izraelidoj, kaj ili ne malhonoru Mian sanktan nomon en tio, kion ili konsekras al Mi: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Diru al ili: Se iu en viaj generacioj el via tuta idaro aliros al la sanktaĵoj, kiujn la Izraelidoj konsekras al la Eternulo, kaj li havos sur si malpuraĵon, tiam tiu animo ekstermiĝos de antaŭ Mi: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Se iu el la idaro de Aaron havos lepron aŭ elfluon, tiu ne manĝu la sanktaĵojn, ĝis li puriĝos. Kiu ektuŝis iun, kiu malpuriĝis per mortinto, aŭ kiu havas elfluon de semo; ");
INSERT INTO epo_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","aŭ kiu ektuŝis ian rampaĵon, per kiu li malpuriĝis, aŭ iun homon, de kiu li malpuriĝis per ia lia malpuraĵo; ");
INSERT INTO epo_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","tiu, ektuŝinte tion, estos malpura ĝis la vespero, kaj li ne manĝu la sanktaĵojn, antaŭ ol li estos lavinta sian korpon per akvo. ");
INSERT INTO epo_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Post la subiro de la suno li fariĝos pura, kaj tiam li povas manĝi la sanktaĵojn, ĉar tio estas lia manĝaĵo. ");
INSERT INTO epo_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Kadavraĵon kaj ion, kion disŝiris bestoj, li ne manĝu, por ke li ne malpuriĝu per tio: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Kaj ili observu Miajn ordonojn, por ke ili ne portu sur si pekon kaj ne mortu en ĝi, se ili tion malhonoros: Mi estas la Eternulo, kiu ilin sanktigas. ");
INSERT INTO epo_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kaj neniu laiko manĝu sanktaĵon; loĝanto ĉe pastro kaj ankaŭ dungito ne manĝu sanktaĵon. ");
INSERT INTO epo_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Se pastro aĉetis homon per sia mono, tiu povas manĝi tion; kaj tiuj, kiuj naskiĝis en lia domo, povas manĝi lian panon. ");
INSERT INTO epo_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Se filino de pastro edziniĝis kun viro laika, ŝi ne manĝu el la levataj sanktaĵoj. ");
INSERT INTO epo_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Sed se filino de pastro fariĝis vidvino aŭ eksedzino kaj ŝi ne havas infanojn, kaj ŝi revenis en la domon de sia patro, kiel ŝi estis en sia juneco, tiam ŝi povas manĝi la panon de sia patro; sed neniu laiko devas ĝin manĝi. ");
INSERT INTO epo_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Se iu manĝis sanktaĵon per eraro, li aldonu al ĝi kvinonon de la valoro kaj redonu al la pastro la sanktaĵon. ");
INSERT INTO epo_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ili ne malhonoru la sanktaĵojn de la Izraelidoj, kiujn ili oferlevas al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Kaj ili ne ŝarĝu sur sin la kulpon de la krimo, manĝante siajn sanktaĵojn; ĉar Mi estas la Eternulo, kiu ilin sanktigas. ");
INSERT INTO epo_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Parolu al Aaron kaj al liaj filoj kaj al ĉiuj Izraelidoj, kaj diru al ili: Se iu el la domo de Izrael aŭ el la fremduloj inter Izrael alportas sian oferon, ĉu ĝi estas promesitaĵo aŭ ĉu ĝi estas ofero memvola, kiun ili alportas al la Eternulo kiel bruloferon, ");
INSERT INTO epo_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","tiam, por ke vi akiru plaĉon, ĝi devas esti sendifekta, virseksa, el grandaj brutoj, el ŝafoj, aŭ el kaproj. ");
INSERT INTO epo_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Neniun beston, kiu havas difektaĵon, alportu, ĉar ĝi ne akirigos al vi plaĉon. ");
INSERT INTO epo_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kaj se iu alportas pacoferon al la Eternulo, por plenumi promeson aŭ memvole, el grandaj aŭ malgrandaj brutoj, ĝi estu sendifekta, por ke ĝi plaĉu; nenia difekto estu sur ĝi. ");
INSERT INTO epo_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Beston blindan aŭ difektitan aŭ kriplan aŭ absceshavan aŭ aknohavan aŭ favan ne alportu al la Eternulo; kaj ne donu ilin kiel fajroferon sur la altaron de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Bovon aŭ ŝafon, kiu havas tro longajn aŭ tro mallongajn membrojn, vi povas alporti kiel oferon memvolan, sed kiel promesita ofero ĝi ne akiros plaĉon. ");
INSERT INTO epo_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Beston, kiu havas testikon kunpremitan, disbatitan, deŝiritan, aŭ fortranĉitan, ne alportu al la Eternulo, kaj en via lando ne faru tion. ");
INSERT INTO epo_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kaj el la manoj de alilandulo ne alportu tiajn kiel panon de via Dio; ĉar kriplaĵo estas sur ili, difektaĵo estas sur ili: ili ne akiros al vi plaĉon. ");
INSERT INTO epo_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Kiam naskiĝos bovido aŭ ŝafido aŭ kaprido, tiam ĝi restu dum sep tagoj sub sia patrino, kaj de post la oka tago kaj plue ĝi povas akiri plaĉon kiel fajrofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sed nek bovon, nek ŝafon buĉu kun ĝia ido en unu tago. ");
INSERT INTO epo_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Se vi alportas dankoferon al la Eternulo, oferu ĝin tiel, ke ĝi akiru por vi plaĉon. ");
INSERT INTO epo_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","En la sama tago oni devas ĝin manĝi; ne lasu iom el ĝi ĝis la mateno: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Kaj observu Miajn ordonojn kaj plenumu ilin: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kaj ne malhonoru Mian sanktan nomon, kaj Mi estu sankta inter la Izraelidoj: Mi estas la Eternulo, kiu sanktigas vin, ");
INSERT INTO epo_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","kiu elkondukis vin el la lando Egipta, por esti por vi Dio. Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Parolu al la Izraelidoj, kaj diru al ili: La festoj de la Eternulo, kiujn vi nomos sanktaj kunvenoj, jen ili estas, Miaj festoj. ");
INSERT INTO epo_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Dum ses tagoj faru laboron; sed la sepan tagon estas sabato de ripozo, sankta kunveno, nenian laboron faru; ĝi estu sabato al la Eternulo en ĉiuj viaj loĝejoj. ");
INSERT INTO epo_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Jen estas la festoj de la Eternulo, sanktaj kunvenoj, kiujn vi kunvokados en ilia tempo: ");
INSERT INTO epo_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","en la unua monato, en la dek-kvara tago de la monato, ĉirkaŭ la vespero, estas Pasko al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Kaj en la dek-kvina tago de tiu monato estas la festo de macoj al la Eternulo; dum sep tagoj manĝu macojn. ");
INSERT INTO epo_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","En la unua tago estu ĉe vi sankta kunveno, faru nenian laboron. ");
INSERT INTO epo_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kaj alportadu fajroferojn al la Eternulo dum sep tagoj; en la sepa tago estu sankta kunveno, faru nenian laboron. ");
INSERT INTO epo_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Parolu al la Izraelidoj, kaj diru al ili: Kiam vi venos en la landon, kiun Mi donas al vi, kaj vi rikoltos ĝian rikolton, tiam alportu al la pastro la unuan garbon el via rikolto. ");
INSERT INTO epo_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kaj li skuos la garbon antaŭ la Eternulo, por ke vi akiru plaĉon; en la morgaŭa tago post la festo la pastro ĝin skuos. ");
INSERT INTO epo_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Kaj vi pretigu en la tago, kiam estos skuata via garbo, sendifektan ŝafidon jaraĝan kiel bruloferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Kaj kun ĝi, kiel farunoferon, du dekonojn de efo da delikata faruno, miksita kun oleo, kiel fajroferon al la Eternulo, kiel agrablan odoraĵon, kaj kun ĝi, kiel verŝoferon, kvaronon de hino da vino. ");
INSERT INTO epo_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kaj panon kaj rostitajn grajnojn kaj freŝajn grajnojn ne manĝu ĝis tiu tago mem, en kiu vi alportos la oferon al via Dio; ĝi estu eterna leĝo por viaj generacioj en ĉiuj viaj loĝejoj. ");
INSERT INTO epo_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Kaj kalkulu al vi de post la morgaŭa tago post la festo, de post la tago, en kiu vi alportis la garbon por skuado, sep plenajn semajnojn. ");
INSERT INTO epo_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ĝis la morgaŭa tago post la sepa semajno kalkulu kvindek tagojn, kaj tiam vi alportos novan farunoferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","El viaj loĝejoj alportu du panojn de skuofero; el du dekonoj de efo da delikata faruno ili estu; fermente ili estu bakitaj; tio estos unuaj produktoj por la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kaj alportu kune kun la panoj sep ŝafidojn sendifektajn jaraĝajn kaj unu bovidon kaj du virŝafojn; ili estu brulofero al la Eternulo; kaj kune kun ili farunoferon kaj verŝoferon, fajroferon, agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Pretigu ankaŭ unu kapron kiel pekoferon, kaj du jaraĝajn ŝafidojn kiel pacoferon. ");
INSERT INTO epo_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kaj la pastro skuu ilin kune kun la unuaproduktaj panoj kiel skuoferon antaŭ la Eternulo, kun la du ŝafidoj; ĝi estu sanktaĵo al la Eternulo por la pastro. ");
INSERT INTO epo_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Kaj proklamu en tiu tago: sankta kunveno estu ĉe vi, faru nenian laboron; tio estu eterna leĝo en ĉiuj viaj loĝejoj en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kaj kiam vi rikoltos la rikolton en via lando, ne rikoltu ĉion ĝis la rando de via kampo dum via rikoltado, kaj la postrestaĵon de via rikolto ne kolektu; por la malriĉulo kaj por la fremdulo lasu tion: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Diru al la Izraelidoj jene: En la sepa monato, en la unua tago de la monato, estu ĉe vi festo, memorigado per trumpetado, sankta kunveno. ");
INSERT INTO epo_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Faru nenian laboron; kaj alportu fajroferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Sed en la deka tago de tiu sepa monato estu tago de pekliberigo, sankta kunveno estu ĉe vi; kaj humiligu vian animon kaj alportu fajroferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Kaj faru nenian laboron en tiu tago, ĉar ĝi estas tago de pekliberigo, por pekliberigi vin antaŭ la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ĉiu animo, kiu ne humiligos sin en tiu tago, ekstermiĝos el inter sia popolo. ");
INSERT INTO epo_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Se iu animo faros ian laboron en tiu tago, Mi ekstermos tiun animon el inter ĝia popolo. ");
INSERT INTO epo_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Faru nenian laboron; ĝi estu eterna leĝo en viaj generacioj en ĉiuj viaj loĝejoj. ");
INSERT INTO epo_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Granda sabato ĝi estu por vi; kaj humiligu viajn animojn; vespere en la naŭa tago de la monato, de vespero ĝis vespero festu vian sabaton. ");
INSERT INTO epo_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Diru al la Izraelidoj jene: Komencante de la dek-kvina tago de tiu sepa monato estu festo de laŭboj dum sep tagoj al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","En la unua tago estu sankta kunveno, faru nenian laboron. ");
INSERT INTO epo_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Dum sep tagoj alportadu fajroferojn al la Eternulo; en la oka tago estu ĉe vi sankta kunveno, kaj alportu fajroferon al la Eternulo; ferma festo ĝi estas, faru nenian laboron. ");
INSERT INTO epo_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Tio estas la festoj de la Eternulo, kiujn vi nomos sanktaj kunvenoj, por alporti fajroferon al la Eternulo, bruloferon kaj farunoferon, buĉoferon kaj verŝoferojn, ĉiun en ĝia tago; ");
INSERT INTO epo_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","krom la sabatoj de la Eternulo kaj krom viaj donoj kaj krom ĉiuj viaj promesoj, kaj krom ĉiuj viaj memvolaj oferoj, kiujn vi donos al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Kaj en la dek-kvina tago de la sepa monato, kiam vi kolektos la produktaĵon de la tero, festu la feston de la Eternulo dum sep tagoj; en la unua tago estu festo kaj en la oka tago estu festo. ");
INSERT INTO epo_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Kaj prenu al vi en la unua tago fruktojn de belaj arboj, branĉojn de palmoj kaj branĉojn de densaj arboj kaj de apudriveraj salikoj; kaj gajigu vin antaŭ la Eternulo, via Dio, dum sep tagoj. ");
INSERT INTO epo_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kaj festu tiun feston de la Eternulo dum sep tagoj en la jaro; eterna leĝo tio estu en viaj generacioj; en la sepa monato festu ĝin. ");
INSERT INTO epo_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","En laŭboj loĝu dum sep tagoj, ĉiu indiĝeno en Izrael loĝu en laŭboj; ");
INSERT INTO epo_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","por ke sciu viaj generacioj, ke en laŭboj Mi loĝigis la Izraelidojn, kiam Mi elkondukis ilin el la lando Egipta: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kaj Moseo diris pri la festoj de la Eternulo al la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Ordonu al la Izraelidoj, ke ili alportadu al vi oleon olivan, puran, pistitan, por lumigado, por ke lucerno brulu ĉiam. ");
INSERT INTO epo_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ekster la kurteno de la atesto en la tabernaklo de kunveno Aaron ĝin ĉiam aranĝadu de vespero ĝis mateno antaŭ la Eternulo; tio estu eterna leĝo en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Sur la pure ora kandelabro li aranĝadu la lumojn antaŭ la Eternulo ĉiam. ");
INSERT INTO epo_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Kaj prenu delikatan farunon kaj baku el ĝi dek du panojn; el du dekonoj de efo estu ĉiu pano; ");
INSERT INTO epo_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","kaj aranĝu ilin en du vicoj, po ses en vico, sur la pure ora tablo antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kaj metu sur ĉiun vicon puran olibanon, kaj tio estos ĉe la pano memorofero, fajrofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","En ĉiu tago sabata oni ĉiam aranĝu tion antaŭ la Eternulo; de la Izraelidoj ĝi estu eterna interligo. ");
INSERT INTO epo_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Kaj ĝi estu por Aaron kaj por liaj filoj, kaj ili manĝu ĝin sur sankta loko, ĉar tio estas plejsanktaĵo por li el la fajroferoj de la Eternulo; tio estu eterna leĝo. ");
INSERT INTO epo_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Kaj eliris iu filo de virino Izraelida kaj de viro Egipta inter la Izraelidojn, kaj en la tendaro la filo de la Izraelidino ekkverelis kun Izraelido; ");
INSERT INTO epo_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","kaj la filo de la Izraelidino insultis la nomon de Dio kaj blasfemis; kaj oni venigis lin al Moseo. La nomo de lia patrino estis Ŝelomit, filino de Dibri el la tribo de Dan. ");
INSERT INTO epo_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Kaj oni metis lin en malliberejon, ĝis oni ricevos precizan decidon de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Elirigu la blasfeminton ekster la tendaron; kaj ĉiuj, kiuj aŭdis, metu siajn manojn sur lian kapon, kaj la tuta komunumo mortigu lin per ŝtonoj. ");
INSERT INTO epo_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Kaj al la Izraelidoj diru jene: Ĉiu, kiu blasfemos sian Dion, portos sian pekon. ");
INSERT INTO epo_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Kiu insultas la nomon de la Eternulo, tiu estu mortigita; per ŝtonoj mortigu lin la tuta komunumo. Ĉu fremdulo, ĉu indiĝeno, se li blasfemos la nomon de la Eternulo, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Se iu mortigos iun homon, oni lin mortigu. ");
INSERT INTO epo_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kiu mortigos bruton, tiu pagu pro ĝi: beston pro besto. ");
INSERT INTO epo_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Se iu faris difekton al sia proksimulo, oni faru al li tiel, kiel li faris: ");
INSERT INTO epo_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","rompon pro rompo, okulon pro okulo, denton pro dento; kian difekton li faris al homo, tian oni faru al li. ");
INSERT INTO epo_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kaj kiu mortigis bruton, pagu pro ĝi; sed kiu mortigis homon, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","La sama juĝo estu ĉe vi ĉu por fremdulo, ĉu por indiĝeno; ĉar Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Kaj Moseo diris al la Izraelidoj, kaj oni elirigis la blasfeminton ekster la tendaron kaj mortigis lin per ŝtonoj; kaj la Izraelidoj faris, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Kaj la Eternulo ekparolis al Moseo sur la monto Sinaj, dirante: ");
INSERT INTO epo_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Parolu al la Izraelidoj, kaj diru al ili: Kiam vi venos en la landon, kiun Mi donas al vi, tiam la tero ripozu sabaton al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Dum ses jaroj prisemu vian kampon kaj dum ses jaroj pritranĉu vian vinberĝardenon kaj kolektu iliajn produktaĵojn; ");
INSERT INTO epo_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","sed en la sepa jaro estu sabato de ripozo por la tero, sabato al la Eternulo: vian kampon ne prisemu kaj vian vinberĝardenon ne pritranĉu. ");
INSERT INTO epo_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kio mem elkreskos post via rikolto, tion ne rikoltu, kaj la vinberojn de viaj nepritranĉitaj branĉoj ne deprenu: tio estu jaro de ripozo por la tero. ");
INSERT INTO epo_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Kaj la produktaĵoj de la sabata tero estu manĝaĵo por vi ĉiuj: por vi, por via sklavo, por via sklavino, kaj por via dungito kaj por via kunloĝanto, kiuj loĝas ĉe vi. ");
INSERT INTO epo_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Kaj por via bruto kaj por la bestoj, kiuj estas sur via tero, ĉiuj ĝiaj produktaĵoj estu kiel manĝaĵo. ");
INSERT INTO epo_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Kaj kalkulu al vi sep sabatajn jarojn, sep fojojn po sep jaroj, ke vi havu en la sep sabataj jaroj kvardek naŭ jarojn. ");
INSERT INTO epo_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Kaj proklamu per trumpetado en la sepa monato, en la deka tago de la monato; en la tago de pekliberigo trumpetu en via tuta lando. ");
INSERT INTO epo_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kaj sanktigu la kvindekan jaron, kaj proklamu liberecon en la lando por ĉiuj ĝiaj loĝantoj: jubileo ĝi estu por vi; kaj revenu ĉiu al sia posedaĵo, kaj ĉiu revenu al sia familio. ");
INSERT INTO epo_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Jubileo ĝi estu por vi, la kvindeka jaro; ne semu, kaj ne rikoltu tion, kio mem elkreskis, kaj ne deprenu la berojn de la nepritranĉitaj vinberbranĉoj. ");
INSERT INTO epo_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ĉar jubileo ĝi estas, sankta ĝi estu por vi; de la kampo manĝu ĝiajn produktaĵojn. ");
INSERT INTO epo_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","En tiu jubilea jaro ĉiu revenu al sia posedaĵo. ");
INSERT INTO epo_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kaj se vi ion vendos al via proksimulo, aŭ se vi aĉetos el la manoj de via proksimulo, unu ne malprofitigu la alian. ");
INSERT INTO epo_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Laŭ la kalkulo de la jaroj post la jubileo aĉetu de via proksimulo; laŭ la kalkulo de la jaroj de produktado li vendu al vi. ");
INSERT INTO epo_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Laŭ la multeco de la jaroj pligrandigu la prezon, kaj ju pli malmultaj estas la jaroj, des pli malgrandigu la prezon; ĉar la nombron de la rikoltoj li vendas al vi. ");
INSERT INTO epo_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kaj ne malprofitigu unu la alian, kaj timu vian Dion; ĉar Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Kaj plenumu Miajn leĝojn, kaj Miajn decidojn observu kaj plenumu ilin, kaj tiam vi loĝos en la lando sendanĝere. ");
INSERT INTO epo_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Kaj la tero donados siajn fruktojn, kaj vi manĝados ĝissate, kaj vi loĝos sur ĝi sendanĝere. ");
INSERT INTO epo_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kaj se vi diros: Kion ni manĝos en la sepa jaro, kiam ni ne semos kaj ne enkolektos niajn produktaĵojn? ");
INSERT INTO epo_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mi sendos al vi Mian benon en la sesa jaro, kaj ĝi alportos produktaĵojn por tri jaroj. ");
INSERT INTO epo_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Kaj vi semos en la oka jaro, sed vi manĝos la produktaĵojn malnovajn ĝis la naŭa jaro; ĝis venos la rikolto de ĝiaj produktaĵoj, vi manĝos malnovajn. ");
INSERT INTO epo_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Kaj la tero ne estu vendata por ĉiam; ĉar al Mi apartenas la tero, ĉar vi estas fremduloj kaj pasloĝantoj ĉe Mi. ");
INSERT INTO epo_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Kaj sur la tuta tero de via posedado permesu liberigon de la tero. ");
INSERT INTO epo_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Se via frato malriĉiĝos kaj vendos ion de sia posedaĵo, sed venos reaĉetanto, lia proksima parenco, tiam li povu reaĉeti la venditaĵon de sia frato. ");
INSERT INTO epo_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kaj se iu ne trovos por si reaĉetanton, sed li mem fariĝos sufiĉe bonstata, kaj havos tiom, ke li povos reaĉeti, ");
INSERT INTO epo_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","tiam li kalkulu la jarojn de la venditeco, kaj la restaĵojn li redonu al tiu, al kiu li vendis; kaj li revenu al sia posedado. ");
INSERT INTO epo_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Sed se li ne havos sufiĉe, por redoni al li, tiam lia venditaĵo restu en la manoj de la aĉetinto ĝis la jubilea jaro; sed en la jubilea jaro ĝi foriru, kaj li revenu al sia posedado. ");
INSERT INTO epo_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kaj se iu vendos loĝeblan domon en urbo, kiun ĉirkaŭas muro, tiam ĝi estas reaĉetebla ĝis la fino de jaro post ĝia vendo; en la daŭro de jaro ĝi estas reaĉetebla. ");
INSERT INTO epo_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Sed se ĝi ne estos reaĉetita antaŭ la fino de tuta jaro, tiam la domo, kiu estas en urbo ĉirkaŭita de muro, restas por ĉiam ĉe ĝia aĉetinto en liaj generacioj; ĝi ne foriras en jaro jubilea. ");
INSERT INTO epo_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","La domoj en la vilaĝoj ne ĉirkaŭitaj de muro estu kalkulataj kiel kampo da tero; oni povas ilin reaĉeti, kaj en jubilea jaro ili foriras. ");
INSERT INTO epo_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Koncerne la urbojn de la Levidoj, la domojn en la urboj de ilia posedado, la Levidoj ĉiam havas la rajton de reaĉeto. ");
INSERT INTO epo_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Se iu elaĉetos ion de la Levidoj, tiam la vendita domo aŭ la urba posedaĵo foriras en la jubilea jaro; ĉar la domoj en la urboj de la Levidoj estas ilia posedaĵo inter la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Kaj la kampoj ĉirkaŭ iliaj urboj ne estu vendataj, ĉar tio estas ilia porĉiama posedaĵo. ");
INSERT INTO epo_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Se via frato malriĉiĝos kaj lia brako malfortiĝos apud vi, tiam subtenu lin; ĉu li estas fremdulo, ĉu pasloĝanto, li vivu kun vi. ");
INSERT INTO epo_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne prenu de li procentojn nek alkreskon, kaj timu vian Dion, ke via frato vivu kun vi. ");
INSERT INTO epo_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Donante al li monon, ne postulu de li procentojn, kaj donante al li manĝaĵon, ne postulu ĝian pligrandigon. ");
INSERT INTO epo_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mi estas la Eternulo, via Dio, kiu elkondukis vin el la lando Egipta, por doni al vi la landon Kanaanan, por esti via Dio. ");
INSERT INTO epo_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Kiam malriĉiĝos apud vi via frato kaj li estos vendita al vi, tiam ne ŝarĝu lin per laborado sklava; ");
INSERT INTO epo_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","kiel dungito, kiel pasloĝanto li estu ĉe vi; ĝis la jubilea jaro li servu ĉe vi; ");
INSERT INTO epo_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","kaj tiam li foriru de vi, li mem kaj ankaŭ liaj filoj kun li, kaj li revenu al sia familio kaj al la posedaĵo de siaj patroj. ");
INSERT INTO epo_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ĉar ili estas Miaj sklavoj, kiujn Mi elkondukis el la lando Egipta; ili ne estu vendataj, kiel oni vendas sklavojn. ");
INSERT INTO epo_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ne regu ilin kun krueleco, kaj timu vian Dion. ");
INSERT INTO epo_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Via sklavo kaj via sklavino, kiujn vi povas havi, devas esti el la popoloj, kiuj estas ĉirkaŭ vi; el ili aĉetu sklavon kaj sklavinon. ");
INSERT INTO epo_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ankaŭ el la idoj de la pasloĝantoj, kiuj fremdule loĝas ĉe vi, el ili vi povas aĉeti, kaj el iliaj familioj, kiuj estas ĉe vi kaj kiuj naskiĝis en via lando; ili povas esti via posedaĵo. ");
INSERT INTO epo_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Kaj vi povas transdoni ilin herede al viaj filoj post vi kiel porĉiaman posedaĵon; ilin vi povas uzi kiel sklavojn, sed super viaj fratoj, super Izraelidoj, ne regu unuj super aliaj kun krueleco. ");
INSERT INTO epo_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kaj se fremdulo aŭ pasloĝanto ĉe vi estos bonstata, kaj via frato malriĉiĝos antaŭ li kaj vendos sin al la fremdulo aŭ pasloĝanto ĉe vi aŭ al ido de familio de fremdulo: ");
INSERT INTO epo_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","post la vendo restas al li rajto de elaĉeto; iu el liaj fratoj elaĉetu lin. ");
INSERT INTO epo_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Aŭ lia onklo, aŭ filo de lia onklo elaĉetu lin, aŭ iu el lia parencaro, el lia familio elaĉetu lin; aŭ se lia stato sufiĉos, li mem sin elaĉetos. ");
INSERT INTO epo_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Kaj li faru prikalkulon kun sia aĉetinto, de la jaro, en kiu li sin vendis, ĝis la jaro jubilea; kaj la mono, pro kiu li vendis sin, devas esti redonita laŭ la nombro de la jaroj; kiel dungito li estu ĉe li. ");
INSERT INTO epo_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Se restas ankoraŭ multe da jaroj, tiam proporcie al ili li redonu elaĉeton pro si el la mono, pro kiu li estis aĉetita. ");
INSERT INTO epo_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Se restas malmulte da jaroj ĝis la jubilea jaro, tiam li kalkulu tion al li kaj proporcie al la jaroj li redonu pro si elaĉeton. ");
INSERT INTO epo_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kiel laŭjara dungito li estu ĉe li, kaj ĉi tiu ne regu lin kruele antaŭ viaj okuloj. ");
INSERT INTO epo_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kaj se li ne elaĉetiĝos tiamaniere, tiam li foriru en la jubilea jaro, li kune kun siaj infanoj. ");
INSERT INTO epo_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ĉar Miaj sklavoj estas la Izraelidoj; ili estas Miaj sklavoj, kiujn Mi elkondukis el la lando Egipta: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ne faru al vi idolojn, kaj figurojn kaj statuojn ne starigu ĉe vi, kaj ŝtonojn kun bildoj ne kuŝigu en via lando, por adorkliniĝi super ili: ĉar Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Miajn sabatojn observu, kaj Mian sanktejon respektegu: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Se vi agos laŭ Miaj leĝoj kaj observos Miajn ordonojn kaj plenumos ilin, ");
INSERT INTO epo_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","tiam Mi donos al vi pluvojn iliatempe, kaj la tero donos siajn produktaĵojn, kaj la kampa arbo donos siajn fruktojn. ");
INSERT INTO epo_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kaj la tempo de draŝado daŭros ĉe vi ĝis la enkolektado de la vinberoj, kaj la enkolektado de vinberoj daŭros ĝis la semado, kaj vi manĝos vian panon sate kaj vi loĝos sendanĝere en via lando. ");
INSERT INTO epo_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Kaj Mi donos pacon al via lando, kaj kiam vi kuŝos, neniu vin timigos; kaj Mi forigos la malbonajn bestojn el la lando, kaj glavo ne trapasos vian landon. ");
INSERT INTO epo_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kaj vi pelos viajn malamikojn, kaj ili falos antaŭ vi de glavo. ");
INSERT INTO epo_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Kaj kvin al vi pelos centon, kaj cent el vi pelos dekmilon; kaj viaj malamikoj falos antaŭ vi de glavo. ");
INSERT INTO epo_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Kaj Mi turnos Min al vi kaj kreskigos vin kaj multigos vin, kaj Mi fortikigos Mian interligon kun vi. ");
INSERT INTO epo_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kaj vi manĝos grenon malnovan pasintjaran, kaj vi elportos la malnovan pro la nova. ");
INSERT INTO epo_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Kaj Mi starigos Mian loĝejon inter vi, kaj Mia animo vin ne abomenos. ");
INSERT INTO epo_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Kaj Mi iros inter vi, kaj Mi estos via Dio, kaj vi estos Mia popolo. ");
INSERT INTO epo_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mi estas la Eternulo, via Dio, kiu elkondukis vin el la lando Egipta, por ke vi ne estu iliaj sklavoj; kaj Mi rompis la bastonojn de via jugo kaj ekirigis vin kun levita kapo. ");
INSERT INTO epo_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Sed se vi ne obeos Min kaj ne faros ĉiujn ĉi tiujn ordonojn; ");
INSERT INTO epo_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kaj se vi malestimos Miajn leĝojn kaj se via animo abomenos Miajn decidojn, kaj vi ne plenumos ĉiujn Miajn ordonojn, rompante Mian interligon: ");
INSERT INTO epo_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","tiam ankaŭ Mi faros al vi tion: Mi sendos sur vin teruron, maldikiĝon, kaj febron, kiuj konsumas la okulojn kaj senfortigas la animon; kaj vi semos viajn semojn vane, ilin manĝos viaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kaj Mi turnos Mian vizaĝon kontraŭ vin, kaj vi falos antaŭ viaj malamikoj, kaj regos vin viaj malamantoj, kaj vi kuros, kiam neniu pelos vin. ");
INSERT INTO epo_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Kaj se vi malgraŭ ĉi tio ne obeos Min, tiam Mi sepoble pligrandigos la punon pro viaj pekoj. ");
INSERT INTO epo_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kaj Mi rompos vian fieran obstinecon, kaj Mi faros vian ĉielon kiel fero kaj vian teron kiel kupro. ");
INSERT INTO epo_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Kaj vane konsumiĝos via forto; via tero ne donos siajn produktaĵojn, kaj la arboj de la tero ne donos siajn fruktojn. ");
INSERT INTO epo_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kaj se vi malgraŭ tio spitos Min kaj ne volos obei Min, tiam Mi aldonos sepoble da frapoj laŭ viaj pekoj. ");
INSERT INTO epo_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Kaj Mi venigos sur vin la sovaĝajn bestojn, kaj ili formanĝos viajn infanojn kaj ekstermos viajn brutojn kaj malmultigos vin tiel, ke viaj vojoj dezertiĝos. ");
INSERT INTO epo_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Se ankaŭ per tio vi ne humiliĝos, sed plue agos kontraŭ Mi: ");
INSERT INTO epo_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","tiam ankaŭ Mi agos kontraŭ vi, kaj Mi ankaŭ frapos vin sepoble pro viaj pekoj. ");
INSERT INTO epo_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kaj Mi venigos sur vin venĝan glavon, kiu venĝos pro la interligo; kaj vi kolektiĝos en viaj urboj, kaj Mi sendos peston en vian mezon, kaj vi estos fordonitaj en la manojn de la malamiko. ");
INSERT INTO epo_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kiam Mi rompos al vi la apogon de la pano, tiam dek virinoj bakos vian panon en unu forno kaj redonos vian panon pesante, kaj vi manĝos kaj ne satiĝos. ");
INSERT INTO epo_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kaj se vi malgraŭ tio ne obeos Min, kaj spitos Min: ");
INSERT INTO epo_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","tiam Mi iros kontraŭ vin kolere, kaj Mi punos vin sepoble pro viaj pekoj. ");
INSERT INTO epo_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kaj vi manĝos la karnon de viaj filoj, kaj la karnon de viaj filinoj vi manĝos. ");
INSERT INTO epo_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Kaj Mi detruos viajn altaĵojn kaj ruinigos viajn kolonojn de la suno, kaj Mi ĵetos viajn kadavrojn sur la rompitaĵojn de viaj idoloj, kaj Mia animo abomenos vin. ");
INSERT INTO epo_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kaj Mi faros el viaj urboj dezerton, kaj Mi ruinigos viajn sanktejojn, kaj Mi ne flaros viajn agrablajn odoraĵojn. ");
INSERT INTO epo_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Kaj Mi dezertigos la teron, ke miregos pri ĝi viaj malamikoj, kiuj ekloĝos sur ĝi. ");
INSERT INTO epo_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Kaj vin Mi disĵetos inter la popolojn, kaj Mi nudigos post vi glavon; kaj via tero estos dezerta kaj viaj urboj estos ruinigitaj. ");
INSERT INTO epo_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Tiam la tero ricevos kontentigon pri siaj sabatoj dum la tuta tempo de sia dezerteco, kiam vi estos en la lando de viaj malamikoj; tiam ripozos la tero kaj kontentigos sin pri siaj sabatoj. ");
INSERT INTO epo_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Dum la tuta tempo de dezerteco ĝi ripozos, kiom ĝi ne ripozis en viaj sabatoj, kiam vi loĝis sur ĝi. ");
INSERT INTO epo_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Kaj al la restintoj el vi Mi sendos timon en ilian koron en la lando de iliaj malamikoj; kaj pelos ilin brueto de falanta folio, kaj ili kuros, kiel oni kuras de glavo, kaj ili falos, kiam neniu ilin persekutos. ");
INSERT INTO epo_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Kaj ili falos unu sur alian, kiel de glavo, dum neniu ilin pelos; kaj vi ne havos forton por stari antaŭ viaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kaj vi pereos inter la popoloj, kaj formanĝos vin la lando de viaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Kaj la restintoj el vi senfortiĝos pro siaj pekoj en la landoj de viaj malamikoj, kaj ankaŭ pro la pekoj de siaj patroj ili senfortiĝos. ");
INSERT INTO epo_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Tiam ili konfesos sian kulpon kaj la kulpon de siaj patroj en la malbonagoj, kiujn ili faris kontraŭ Mi kaj pri kio ili spitis Min. ");
INSERT INTO epo_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Ankaŭ Mi iris kontraŭ ilin kaj envenigis ilin en la landon de iliaj malamikoj; kaj se tiam humiliĝos ilia koro ne cirkumcidita kaj se ili donos kontentigon pri siaj pekoj, ");
INSERT INTO epo_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","tiam Mi rememoros Mian interligon kun Jakob, kaj Mian interligon kun Isaak kaj Mian interligon kun Abraham Mi rememoros, kaj la landon Mi rememoros. ");
INSERT INTO epo_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","La lando estos forlasita de ili kaj ricevos kontentigon pri siaj sabatoj, kiam ĝi dezertiĝos post ili; kaj ili donos kontentigon pri siaj kulpoj, ĉar ili malrespektis Miajn decidojn kaj Miajn leĝojn ilia animo abomenis. ");
INSERT INTO epo_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Kaj tamen, kiam ili estos en la lando de siaj malamikoj, Mi ne malestimos ilin, kaj ne abomenos ilin tiom, por ekstermi ilin, por neniigi Mian interligon kun ili; ĉar Mi estas la Eternulo, ilia Dio. ");
INSERT INTO epo_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kaj Mi rememoros por ili la interligon kun la antaŭuloj, kiujn Mi elkondukis el la lando Egipta antaŭ la okuloj de la popoloj, por esti ilia Dio: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tio estas la leĝoj kaj decidoj kaj instruoj, kiujn starigis la Eternulo inter Si kaj la Izraelidoj sur la monto Sinaj per Moseo. ");
INSERT INTO epo_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Parolu al la Izraelidoj, kaj diru al ili: Se iu faros sanktan promeson dediĉi animon laŭ via taksado al la Eternulo, ");
INSERT INTO epo_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","tiam via taksado devas esti: pro virseksulo en la aĝo de dudek jaroj ĝis sesdek jaroj via taksado estu kvindek sikloj da arĝento laŭ la sankta siklo. ");
INSERT INTO epo_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kaj se tio estos virino, tiam via taksado estu tridek sikloj. ");
INSERT INTO epo_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kaj se tio estos aĝulo de kvin jaroj ĝis dudek jaroj, via taksado estu pro viro dudek sikloj kaj pro virino dek sikloj. ");
INSERT INTO epo_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Se tio estos aĝulo de unu monato ĝis kvin jaroj, tiam via taksado estu pro viro kvin sikloj da arĝento kaj pro virino via taksado estu tri sikloj da arĝento. ");
INSERT INTO epo_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kaj se en la aĝo de sesdek jaroj kaj pli, tiam, se tio estos viro, via taksado estu dek kvin sikloj kaj pro virino dek sikloj. ");
INSERT INTO epo_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kaj se li estas tro malriĉa por tia taksado, tiam oni starigu lin antaŭ la pastro kaj la pastro taksu lin: konforme al la bonhaveco de la promesinto la pastro lin taksu. ");
INSERT INTO epo_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Se tio estas bruto el tiaj, kiajn oni ofere alportas al la Eternulo, tiam ĉio, kio estas donita al la Eternulo, estu sankta. ");
INSERT INTO epo_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Oni ne devas ĝin ŝanĝi nek anstataŭigi ĝin, bonan per malbona aŭ malbonan per bona; se tamen iu anstataŭigos bruton per bruto, tiam ĝi kaj ankaŭ ĝia anstataŭigito fariĝu konsekrita. ");
INSERT INTO epo_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Se tio estas ia bruto malpura, el tiaj, kiajn oni ne alportas ofere al la Eternulo, tiam oni starigu la bruton antaŭ la pastro; ");
INSERT INTO epo_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","kaj la pastro taksos ĝin, ĉu ĝi estas bona, ĉu malbona; kiel taksos la pastro, tiel ĝi estu. ");
INSERT INTO epo_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Se la promesinto volos ĝin elaĉeti, li aldonu kvinonon al via takso. ");
INSERT INTO epo_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Se iu dediĉos sian domon kiel sanktaĵon al la Eternulo, tiam la pastro ĝin taksu, ĉu ĝi estas bona, ĉu malbona; kiel la pastro ĝin taksos, tiel ĝi restu. ");
INSERT INTO epo_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Sed se la dediĉinto volos elaĉeti sian domon, tiam li aldonu kvinonon de la mono de via takso, kaj ĝi restos lia. ");
INSERT INTO epo_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Se el sia posedata kampo iu dediĉos ion al la Eternulo, tiam via taksado devas esti proporcia al ĝia semitaĵo: pro semitaĵo en la kvanto de ĥomero da hordeo estu la takso kvindek sikloj da arĝento. ");
INSERT INTO epo_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Se de jubilea jaro li dediĉas sian kampon, tiam la afero restu laŭ via taksado. ");
INSERT INTO epo_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Sed se post la jubilea jaro li dediĉos sian kampon, tiam la pastro kalkulu al li la monon laŭ la jaroj, kiuj restas ĝis la jubilea jaro, kaj tion oni deprenu de via takso. ");
INSERT INTO epo_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Se la dediĉinto volos elaĉeti la kampon, tiam li aldonu kvinonon de la mono laŭ via taksado, kaj ĝi restos lia. ");
INSERT INTO epo_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Sed se li ne elaĉetos la kampon kaj la kampo estos vendita al alia homo, tiam ĝi ne estos plu elaĉetebla. ");
INSERT INTO epo_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kaj tiu kampo, kiam ĝi foriros en la jubilea jaro, estos konsekrita al la Eternulo, kiel kampo priĵurita: ĝi fariĝos posedaĵo de la pastro. ");
INSERT INTO epo_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kaj se iu dediĉos al la Eternulo kampon, kiun li aĉetis kaj kiu ne estas el la kampoj de lia hereda posedaĵo, ");
INSERT INTO epo_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","tiam la pastro kalkulu al li la takson ĝis la jubilea jaro, kaj li donu la takson en tiu tago, kiel konsekritaĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","En la jubilea jaro la kampo revenos al tiu, de kiu oni ĝin aĉetis, al kiu apartenas hereda posedado de tiu tero. ");
INSERT INTO epo_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ĉiu via taksado estu laŭ la sankta siklo: el dudek geroj konsistu la siklo. ");
INSERT INTO epo_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Nur unuenaskiton, kiu el la brutoj apartenas al la Eternulo pro sia unuenaskiteco, neniu dediĉu: ĉu ĝi estas bovo, ĉu ĝi estas ŝafo, ĝi apartenas al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Se ĝi estas bruto malpura, tiam oni devas elaĉeti ĝin laŭ via taksado kaj aldoni al la valoro kvinonon; se ĝi ne estos elaĉetita, oni vendu ĝin laŭ via taksado. ");
INSERT INTO epo_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nur ĉio konsekrita, kion iu konsekris al la Eternulo, el ĉio, kio apartenas al li, ĉu ĝi estas homo, ĉu bruto, ĉu posedata kampo, ne estu vendata nek elaĉetata. Ĉio konsekrita estas plejsanktaĵo de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ĉiu konsekrita, kiu estos konsekrita el la homoj, ne estu elaĉetita; li devas morti. ");
INSERT INTO epo_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Ĉiu dekonaĵo el la tero, el la semitaĵo de la tero, el la fruktoj de la arboj apartenas al la Eternulo; ĝi estas sanktaĵo de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Se iu volos elaĉeti ion el sia dekonaĵo, li aldonu al la valoro kvinonon. ");
INSERT INTO epo_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kaj ĉiu dekono el la bovoj kaj ŝafoj, el ĉio, kio pasas sub la bastono de paŝtanto, la deka estu konsekrita al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Oni ne devas esplori, ĉu ĝi estas bona aŭ malbona, kaj oni ĝin devas ne anstataŭigi; se iu ĝin anstataŭigos, tiam ĝi kaj ĝia anstataŭaĵo estu sanktaĵoj kaj ne estu elaĉetataj. ");
INSERT INTO epo_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Tio estas la ordonoj, kiujn la Eternulo ordonis al Moseo por la Izraelidoj sur la monto Sinaj. ");
INSERT INTO epo_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Kaj la Eternulo ekparolis al Moseo en la dezerto Sinaj en la tabernaklo de kunveno en la unua tago de la dua monato de la dua jaro post ilia eliro el la lando Egipta, dirante: ");
INSERT INTO epo_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Prikalkulu la tutan komunumon de la Izraelidoj laŭ iliaj familioj, laŭ iliaj patrodomoj, laŭ la nombro de la nomoj de ĉiuj virseksuloj laŭkape. ");
INSERT INTO epo_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","De la aĝuloj de dudek jaroj kaj pli, ĉiujn, kiuj taŭgas por milito en Izrael, prikalkulu ilin laŭ iliaj taĉmentoj, vi kaj Aaron. ");
INSERT INTO epo_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kaj kun vi estu po unu homo el ĉiu tribo, homo, kiu estas ĉefo en sia patrodomo. ");
INSERT INTO epo_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Kaj jen estas la nomoj de la viroj, kiuj staros kun vi: de Ruben staru Elicur, filo de Ŝedeur; ");
INSERT INTO epo_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","de Simeon, Ŝelumiel, filo de Curiŝadaj; ");
INSERT INTO epo_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","de Jehuda, Naĥŝon, filo de Aminadab; ");
INSERT INTO epo_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","de Isaĥar, Netanel, filo de Cuar; ");
INSERT INTO epo_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","de Zebulun, Eliab, filo de Ĥelon; ");
INSERT INTO epo_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","de la filoj de Jozef: de Efraim, Eliŝama, filo de Amihud; de Manase, Gamliel, filo de Pedacur; ");
INSERT INTO epo_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","de Benjamen, Abidan, filo de Gideoni; ");
INSERT INTO epo_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","de Dan, Aĥiezer, filo de Amiŝadaj; ");
INSERT INTO epo_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","de Aŝer, Pagiel, filo de Oĥran; ");
INSERT INTO epo_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","de Gad, Eljasaf, filo de Deuel; ");
INSERT INTO epo_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","de Naftali, Aĥira, filo de Enan. ");
INSERT INTO epo_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Tio estas la distingitoj el la komunumo, la estroj de la triboj de siaj patroj, la ĉefoj de la miloj de Izrael. ");
INSERT INTO epo_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Kaj Moseo kaj Aaron prenis tiujn virojn, cititajn laŭ iliaj nomoj. ");
INSERT INTO epo_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Kaj la tutan komunumon ili kunvenigis en la unua tago de la dua monato; kaj la kunvenintoj legitimis sin laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombroj de la nomoj, de la aĝuloj de dudek jaroj kaj pli, laŭkape, ");
INSERT INTO epo_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","kiel la Eternulo ordonis al Moseo. Kaj li prikalkulis ilin en la dezerto Sinaj. ");
INSERT INTO epo_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kaj montriĝis, ke la filoj de Ruben, la unuenaskito de Izrael, laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj laŭkape, ĉiuj virseksuloj en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","prezentis en la tribo de Ruben la nombron de kvardek ses mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","La filoj de Simeon laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, kalkulitaj laŭ la nombro da nomoj laŭkape, ĉiuj virseksuloj en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","prezentis en la tribo de Simeon la nombron de kvindek naŭ mil tricent. ");
INSERT INTO epo_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","La filoj de Gad laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","prezentis en la tribo de Gad la nombron de kvardek kvin mil sescent kvindek. ");
INSERT INTO epo_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","La filoj de Jehuda laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","prezentis en la tribo de Jehuda la nombron de sepdek kvar mil sescent. ");
INSERT INTO epo_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","La filoj de Isaĥar laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","prezentis en la tribo de Isaĥar la nombron de kvindek kvar mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","La filoj de Zebulun laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","prezentis en la tribo de Zebulun la nombron de kvindek sep mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","La filoj de Jozef, la filoj de Efraim laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","prezentis en la tribo de Efraim la nombron de kvardek mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","La filoj de Manase laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","prezentis en la tribo de Manase la nombron de tridek du mil ducent. ");
INSERT INTO epo_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","La filoj de Benjamen laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","prezentis en la tribo de Benjamen la nombron de tridek kvin mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","La filoj de Dan laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","prezentis en la tribo de Dan la nombron de sesdek du mil sepcent. ");
INSERT INTO epo_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","La filoj de Aŝer laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","prezentis en la tribo de Aŝer la nombron de kvardek unu mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","La filoj de Naftali laŭ sia deveno, laŭ siaj familioj, laŭ siaj patrodomoj, laŭ la nombro da nomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj, ");
INSERT INTO epo_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","prezentis en la tribo de Naftali la nombron de kvindek tri mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Tio estas la kalkulitoj, kiujn kalkulis Moseo kaj Aaron kaj la princoj de Izrael, dek du homoj, po unu el ĉiu patrodomo. ");
INSERT INTO epo_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Kaj la nombro de ĉiuj kalkulitoj el la Izraelidoj laŭ iliaj patrodomoj, en la aĝo de dudek jaroj kaj pli, ĉiuj militkapablaj en Izrael, ");
INSERT INTO epo_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","la nombro de ĉiuj kalkulitoj estis sescent tri mil kvincent kvindek. ");
INSERT INTO epo_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Sed la Levidoj laŭ sia patrodomo ne estis kalkulitaj inter ili. ");
INSERT INTO epo_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ĉar la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Nur la tribon de Levi ne prikalkulu, kaj ne metu ilian nombron mezen de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Sed vi komisiu al la Levidoj la tabernaklon de atesto kaj ĉiujn ĝiajn objektojn, kaj ĉion, kio apartenas al ĝi; ili portadu la tabernaklon kaj ĉiujn ĝiajn objektojn, kaj ili priservu ĝin, kaj ĉirkaŭ la tabernaklo ili starigu siajn tendojn. ");
INSERT INTO epo_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kaj kiam la tabernaklo devos forlasi sian lokon, tiam la Levidoj ĝin levu; kaj kiam la tabernaklo devos resti sur loko, tiam la Levidoj ĝin starigu; sed se laiko alproksimiĝos, li estu mortigita. ");
INSERT INTO epo_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Kaj la Izraelidoj aranĝos sin ĉiu en sia tendaro kaj ĉiu apud sia standardo, laŭ siaj taĉmentoj. ");
INSERT INTO epo_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Sed la Levidoj starigu siajn tendojn ĉirkaŭ la tabernaklo de atesto, por ke ne trafu kolero la komunumon de la Izraelidoj; kaj la Levidoj plenumos la gardadon de la tabernaklo de atesto. ");
INSERT INTO epo_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Kaj tiel faris la Izraelidoj; konforme al ĉio, kion la Eternulo ordonis al Moseo, tiel ili faris. ");
INSERT INTO epo_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","La Izraelidoj starigu siajn tendojn ĉiu apud sia standardo, apud la signoj de sia patrodomo; iom malproksime ĉirkaŭ la tabernaklo de kunveno ili starigu siajn tendojn. ");
INSERT INTO epo_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","En la antaŭa parto, oriente, staros tendare la standardo de la tendaro de Jehuda, laŭ iliaj taĉmentoj; kaj la princo de la Jehudaidoj estas Naĥŝon, filo de Aminadab; ");
INSERT INTO epo_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","kaj lia taĉmento kaj ĝiaj kalkulitoj estas sepdek kvar mil sescent. ");
INSERT INTO epo_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Apude staru la tribo de Isaĥar; kaj la princo de la Isaĥaridoj estas Netanel, filo de Cuar; ");
INSERT INTO epo_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvindek kvar mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Poste la tribo de Zebulun; kaj la princo de la Zebulunidoj estas Eliab, filo de Ĥelon; ");
INSERT INTO epo_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvindek sep mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ĉiuj kalkulitoj de la tendaro de Jehuda estas cent okdek ses mil kvarcent laŭ iliaj taĉmentoj; ili elmoviĝu la unuaj. ");
INSERT INTO epo_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","La standardo de la tendaro de Ruben estu sude, laŭ iliaj taĉmentoj; kaj la princo de la Rubenidoj estas Elicur, filo de Ŝedeur; ");
INSERT INTO epo_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvardek ses mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Apude staru la tribo de Simeon; kaj la princo de la Simeonidoj estas Ŝelumiel, filo de Curiŝadaj; ");
INSERT INTO epo_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvindek naŭ mil tricent. ");
INSERT INTO epo_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Poste la tribo de Gad; kaj la princo de la Gadidoj estas Eljasaf, filo de Deuel; ");
INSERT INTO epo_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvardek kvin mil sescent kvindek. ");
INSERT INTO epo_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ĉiuj kalkulitoj de la tendaro de Ruben estas cent kvindek unu mil kvarcent kvindek laŭ iliaj taĉmentoj; ili elmoviĝu la duaj. ");
INSERT INTO epo_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Poste elmoviĝu kun la tabernaklo de kunveno la tendaro de la Levidoj inter la tendaroj; kiel ili staros tendare, tiel ili elmoviĝu, ĉiu laŭ sia loko kun siaj standardoj. ");
INSERT INTO epo_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","La standardo de la tendaro de Efraim, laŭ iliaj taĉmentoj, estu okcidente; kaj la princo de la Efraimidoj estas Eliŝama, filo de Amihud; ");
INSERT INTO epo_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvardek mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Apude estu la tribo de Manase; kaj la princo de la Manaseidoj estas Gamliel, filo de Pedacur; ");
INSERT INTO epo_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","kaj lia taĉmento kaj ĝiaj kalkulitoj estas tridek du mil ducent. ");
INSERT INTO epo_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Poste la tribo de Benjamen; kaj la princo de la Benjamenidoj estas Abidan, filo de Gideoni; ");
INSERT INTO epo_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","kaj lia taĉmento kaj ĝiaj kalkulitoj estas tridek kvin mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ĉiuj kalkulitoj de la tendaro de Efraim estas cent ok mil cent laŭ iliaj taĉmentoj; ili elmoviĝu la triaj. ");
INSERT INTO epo_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","La standardo de la tendaro de Dan estu norde, laŭ iliaj taĉmentoj; kaj la princo de la Danidoj estas Aĥiezer, filo de Amiŝadaj; ");
INSERT INTO epo_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","kaj lia taĉmento kaj ĝiaj kalkulitoj estas sesdek du mil sepcent. ");
INSERT INTO epo_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Apude staru tendare la tribo de Aŝer; kaj la princo de la Aŝeridoj estas Pagiel, filo de Oĥran; ");
INSERT INTO epo_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvardek unu mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Poste la tribo de Naftali; kaj la princo de la Naftaliidoj estas Aĥira, filo de Enan; ");
INSERT INTO epo_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","kaj lia taĉmento kaj ĝiaj kalkulitoj estas kvindek tri mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ĉiuj kalkulitoj de la tendaro de Dan estas cent kvindek sep mil sescent; ili elmoviĝu la lastaj kun siaj standardoj. ");
INSERT INTO epo_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Tio estas la kalkulitoj de la Izraelidoj laŭ iliaj patrodomoj. Ĉiuj kalkulitoj de la tendaroj, laŭ iliaj taĉmentoj, estis sescent tri mil kvincent kvindek. ");
INSERT INTO epo_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Sed la Levidoj ne estis kalkulitaj inter la Izraelidoj; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Kaj la Izraelidoj faris konforme al ĉio, kion la Eternulo ordonis al Moseo: tiel ili stariĝis tendare kun siaj standardoj, kaj tiel ili elmoviĝadis, ĉiu laŭ sia familio, laŭ sia patrodomo. ");
INSERT INTO epo_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Kaj jen estas la genealogio de Aaron kaj Moseo en tiu tempo, kiam la Eternulo parolis al Moseo sur la monto Sinaj. ");
INSERT INTO epo_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Jen estas la nomoj de la filoj de Aaron: la unuenaskito Nadab, kaj Abihu, Eleazar, kaj Itamar. ");
INSERT INTO epo_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Tio estas la nomoj de la filoj de Aaron, la pastroj sanktoleitaj, kiujn li konsekris por pastri. ");
INSERT INTO epo_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Sed Nadab kaj Abihu mortis antaŭ la Eternulo, kiam ili oferalportis fremdan fajron antaŭ la Eternulon en la dezerto Sinaj; kaj filojn ili ne havis. Kaj pastris Eleazar kaj Itamar apud Aaron ilia patro. ");
INSERT INTO epo_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Alvenigu la tribon de Levi, kaj starigu ĝin antaŭ la pastro Aaron, ke ili servu lin. ");
INSERT INTO epo_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Kaj ili plenumu gardon koncerne lin kaj koncerne la tutan komunumon antaŭ la tabernaklo de kunveno, por servi la servojn de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Kaj ili gardu ĉiujn objektojn de la tabernaklo de kunveno kaj la gardotaĵon de la Izraelidoj, por servi la servojn de la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Kaj donu la Levidojn al Aaron kaj al liaj filoj; ili estu fordonitaj al li el la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Kaj Aaronon kaj liajn filojn oficialigu, ke ili plenumadu sian pastradon; se laiko en tion enmiksiĝos, li estu mortigita. ");
INSERT INTO epo_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Jen Mi prenis la Levidojn el inter la Izraelidoj anstataŭ ĉiuj unuenaskitoj utermalfermintoj el la Izraelidoj; la Levidoj estu do Miaj; ");
INSERT INTO epo_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ĉar al Mi apartenas ĉiuj unuenaskitoj; en la tago, en kiu Mi batis ĉiujn unuenaskitojn en la lando Egipta, Mi dediĉis al Mi ĉiujn unuenaskitojn en Izrael, de homo ĝis bruto; Miaj ili estu: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Kaj la Eternulo ekparolis al Moseo en la dezerto Sinaj, dirante: ");
INSERT INTO epo_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Prikalkulu la Levidojn laŭ iliaj patrodomoj, laŭ iliaj familioj; ĉiun virseksulon en la aĝo de unu monato kaj pli prikalkulu. ");
INSERT INTO epo_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Kaj Moseo prikalkulis ilin laŭ la diro de la Eternulo, kiel estis ordonite. ");
INSERT INTO epo_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Kaj jenaj estis la filoj de Levi laŭ iliaj nomoj: Gerŝon kaj Kehat kaj Merari. ");
INSERT INTO epo_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Kaj jen estas la nomoj de la filoj de Gerŝon laŭ iliaj familioj: Libni kaj Ŝimei. ");
INSERT INTO epo_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kaj la filoj de Kehat laŭ iliaj familioj: Amram kaj Jichar, Ĥebron kaj Uziel. ");
INSERT INTO epo_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Kaj la filoj de Merari laŭ iliaj familioj: Maĥli kaj Muŝi. Tio estas la familioj de Levi laŭ iliaj patrodomoj. ");
INSERT INTO epo_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Gerŝon la familio de la Libniidoj kaj la familio de la Ŝimeiidoj; tio estas la familioj de la Gerŝonidoj. ");
INSERT INTO epo_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Iliaj kalkulitoj laŭ la nombro de ĉiuj virseksuloj en la aĝo de unu monato kaj pli prezentas la nombron de sep mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","La familioj de la Gerŝonidoj devas havi siajn tendojn malantaŭ la tabernaklo, okcidente. ");
INSERT INTO epo_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Kaj la estro de la patrodomo de la Gerŝonidoj estas Eljasaf, filo de Lael. ");
INSERT INTO epo_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Kaj sub la gardado de la Gerŝonidoj en la tabernaklo de kunveno estas la tabernaklo, kaj la tendo, ĝiaj kovriloj, kaj la kovrotuko de la pordo de la tabernaklo de kunveno, ");
INSERT INTO epo_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","kaj la kurtenoj de la korto, kaj la kovrotuko de la pordo de la korto, kiu estas ĉirkaŭ la tabernaklo kaj ĉirkaŭ la altaro, kaj la ŝnuroj kun ĉiuj aranĝaĵoj. ");
INSERT INTO epo_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kaj de Kehat estas la familio de la Amramidoj kaj la familio de la Jicharidoj kaj la familio de la Ĥebronidoj kaj la familio de la Uzielidoj; tio estas la familioj de la Kehatidoj. ");
INSERT INTO epo_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Laŭ la nombro de ĉiuj virseksuloj en la aĝo de unu monato kaj pli ili estas ok mil sescent, plenumantaj gardadon de la sanktejo. ");
INSERT INTO epo_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","La familioj de la Kehatidoj devas havi siajn tendojn flanke de la tabernaklo, sude. ");
INSERT INTO epo_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kaj la estro de la patrodomo de la familioj de la Kehatidoj estas Elcafan, filo de Uziel. ");
INSERT INTO epo_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Kaj sub ilia gardado estu la kesto kaj la tablo kaj la kandelabro kaj la altaroj, kaj la sanktaj vazoj, per kiuj oni faras la servadon, kaj la kurteno kaj ĉiuj ĝiaj apartenaĵoj. ");
INSERT INTO epo_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Kaj la estro de la estroj de la Levidoj estas Eleazar, filo de la pastro Aaron; li kontrolas la plenumantojn de la gardado de la sanktejo. ");
INSERT INTO epo_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Merari estas la familio de la Maĥliidoj kaj la familio de la Muŝiidoj; tio estas la familioj de Merari. ");
INSERT INTO epo_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Kaj iliaj kalkulitoj laŭ la nombro de ĉiuj virseksuloj en la aĝo de unu monato kaj pli estas ses mil ducent. ");
INSERT INTO epo_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Kaj la estro de la patrodomo de la familioj de Merari estas Curiel, filo de Abiĥail; ili devas havi siajn tendojn flanke de la tabernaklo, norde. ");
INSERT INTO epo_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Kaj sub la kontrolo kaj gardado de la filoj de Merari estas la tabuloj de la tabernaklo kaj ĝiaj stangoj kaj ĝiaj kolonoj kaj ĝiaj bazoj kaj ĉiuj ĝiaj vazoj kaj ĝia tuta aranĝaĵo, ");
INSERT INTO epo_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","kaj la kolonoj de la korto ĉirkaŭe kaj iliaj bazoj kaj iliaj najloj kaj iliaj ŝnuroj. ");
INSERT INTO epo_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Kaj antaŭ la tabernaklo, en la antaŭa parto de la tabernaklo de kunveno, oriente, havos siajn tendojn Moseo kaj Aaron kaj liaj filoj, plenumante la gardadon de la sanktejo, por gardi la Izraelidojn; sed se laiko alproksimiĝos, li estu mortigita. ");
INSERT INTO epo_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ĉiuj kalkulitaj Levidoj, kiujn prikalkulis Moseo kaj Aaron laŭ la ordono de la Eternulo, laŭ iliaj familioj, ĉiuj virseksuloj en la aĝo de unu monato kaj pli, estis dudek du mil. ");
INSERT INTO epo_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Kaj la Eternulo diris al Moseo: Prikalkulu ĉiujn unuenaskitajn virseksulojn inter la Izraelidoj en la aĝo de unu monato kaj pli, kaj faru registron de iliaj nomoj. ");
INSERT INTO epo_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kaj prenu la Levidojn por Mi, kiu estas la Eternulo, anstataŭ ĉiuj unuenaskitoj el la Izraelidoj, kaj la brutojn de la Levidoj anstataŭ ĉiuj unuenaskitoj el la brutoj de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Kaj Moseo prikalkulis, kiel ordonis al li la Eternulo, ĉiujn unuenaskitojn el la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Kaj estis ĉiuj unuenaskitaj virseksuloj laŭ la nombro de la nomoj en la aĝo de unu monato kaj pli laŭ la kalkulo dudek du mil ducent sepdek tri. ");
INSERT INTO epo_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Prenu la Levidojn anstataŭ ĉiuj unuenaskitoj el la Izraelidoj, kaj la brutojn de la Levidoj anstataŭ iliaj brutoj, kaj la Levidoj apartenu al Mi: Mi estas la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kaj elaĉete pro la ducent sepdek tri, kiuj estas superfluaj kompare kun la nombro de la Levidoj el la unuenaskitoj el la Izraelidoj, ");
INSERT INTO epo_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","prenu po kvin sikloj pro ĉiu kapo, laŭ la sankta siklo prenu, po dudek geroj en siklo; ");
INSERT INTO epo_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","kaj donu la monon al Aaron kaj al liaj filoj, elaĉete pro la superfluaj inter ili. ");
INSERT INTO epo_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kaj Moseo prenis la monon de la elaĉeto de la superfluaj kompare kun tiuj, kiuj estis elaĉetitaj per la Levidoj. ");
INSERT INTO epo_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","De la unuenaskitoj de la Izraelidoj li prenis la monon, mil tricent sesdek kvin siklojn laŭ la sankta siklo. ");
INSERT INTO epo_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Kaj Moseo donis la monon de la elaĉetitoj al Aaron kaj al liaj filoj, laŭ la diro de la Eternulo, kiel ordonis la Eternulo al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Prikalkulu la filojn de Kehat el inter la Levidoj laŭ iliaj familioj, laŭ iliaj patrodomoj, ");
INSERT INTO epo_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","en la aĝo de tridek jaroj kaj pli, ĝis la aĝo de kvindek jaroj, ĉiujn kapablajn por servi, por fari laboron en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Tio estas la servado de la Kehatidoj en la tabernaklo de kunveno, en la plejsanktejo. ");
INSERT INTO epo_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Aaron kaj liaj filoj eniru, kiam la tendaro devos elmoviĝi, kaj ili deprenu la kovrantan kurtenon kaj kovru per ĝi la keston de atesto. ");
INSERT INTO epo_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Kaj ili metu sur ĝin tegon el antilopaj feloj, kaj ili sternu supre bluan tukon, kaj ili enmetu ĝiajn stangojn. ");
INSERT INTO epo_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Kaj sur la tablo de la panoj de propono ili sternu bluan tukon, kaj ili metu sur ĝin la pladojn kaj la kulerojn kaj la tasojn kaj la pokalojn de la verŝoferoj; kaj ĝia konstanta pano estu sur ĝi. ");
INSERT INTO epo_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Kaj ili sternu sur tio ruĝan tukon kaj kovru ĝin per tego el antilopaj feloj, kaj ili enmetu ĝiajn stangojn. ");
INSERT INTO epo_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Kaj ili prenu bluan tukon kaj kovru la kandelabron de lumigado kaj ĝiajn lucernojn kaj ĝiajn prenilojn kaj ĝiajn cindrujojn, kaj ĉiujn ĝiajn oleujojn, kiuj estas uzataj ĉe ĝi. ");
INSERT INTO epo_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kaj ili metu ĝin kaj ĉiujn ĝiajn apartenaĵojn en tegon el antilopaj feloj, kaj ili metu tion sur portilon. ");
INSERT INTO epo_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Kaj sur la ora altaro ili sternu bluan tukon kaj tegu ĝin per tego el antilopaj feloj, kaj ili enmetu ĝiajn stangojn. ");
INSERT INTO epo_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Kaj ili prenu ĉiujn objektojn de servado, per kiuj oni servas en la sanktejo, kaj ili metu tion en bluan tukon kaj tegu tion per tego el antilopaj feloj kaj metu sur portilon. ");
INSERT INTO epo_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kaj ili purigu la altaron de la cindro kaj sternu sur ĝi purpuran tukon. ");
INSERT INTO epo_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kaj ili metu sur ĝin ĉiujn ĝiajn objektojn, per kiuj oni servas sur ĝi, la karbujojn, la forkojn kaj la ŝovelilojn kaj la kalikojn, ĉiujn objektojn de la altaro, kaj ili sternu sur ĝi tegon el antilopaj feloj, kaj ili enmetu ĝiajn stangojn. ");
INSERT INTO epo_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Kiam Aaron kaj liaj filoj finos la kovradon de la sanktejo kaj de ĉiuj objektoj de la sanktejo ĉe la elmoviĝo de la tendaro, tiam venos la filoj de Kehat, por porti; sed ili ne ektuŝu la sanktaĵon, por ke ili ne mortu. Tio estas la portaĵo de la filoj de Kehat ĉe la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Sub la gardado de Eleazar, filo de la pastro Aaron, estas la oleo por la lumigado kaj la bonodoraj incensoj kaj la konstanta farunofero kaj la oleo de sanktigado, la gardado de la tuta tabernaklo, kaj de ĉio, kio estas en ĝi, de la sanktejo kaj de ĝiaj objektoj. ");
INSERT INTO epo_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Ne pereigu la tribon de la familioj Kehatidaj inter la Levidoj; ");
INSERT INTO epo_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","sed tion faru al ili, por ke ili vivu kaj ne mortu, kiam ili alproksimiĝos al la plejsanktejo: Aaron kaj liaj filoj eniru kaj starigu ilin ĉiun ĉe lia servo kaj ĉe lia portotaĵo; ");
INSERT INTO epo_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","sed ili ne aliru, por rigardi, kiel oni dismetas la sanktaĵojn, por ke ili ne mortu. ");
INSERT INTO epo_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Prikalkulu ankaŭ la filojn de Gerŝon laŭ iliaj patrodomoj, laŭ iliaj familioj. ");
INSERT INTO epo_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","De la havantaj la aĝon de tridek jaroj kaj pli ĝis la havantaj la aĝon de kvindek jaroj kalkulu ilin, ĉiujn, kiuj estas kapablaj por la servado, por plenumi laboron en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Tio estas la laboro de la familioj Gerŝonidaj, por servi kaj por porti: ");
INSERT INTO epo_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ili portu la tapiŝojn de la tabernaklo, kaj la tabernaklon de kunveno, ĝian kovrilon, kaj la tegon el la antilopaj feloj, kiu estas super ĝi supre, kaj la kovrotukon de la pordo de la tabernaklo de kunveno, ");
INSERT INTO epo_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","kaj la kurtenojn de la korto, kaj la kovrotukon de la pordego de la korto, kiu estas ĉirkaŭ la tabernaklo kaj ĉirkaŭ la altaro, kaj iliajn ŝnurojn kaj ĉiujn iliajn servajn objektojn; kaj ĉion, kion oni devas fari ĉe ili, ili faru. ");
INSERT INTO epo_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Laŭ la ordono de Aaron kaj de liaj filoj estu la tuta laborado de la Gerŝonidoj, koncerne ĉian ilian portadon kaj ĉian ilian laboradon; kaj metu sub ilian gardadon ĉion, kion ili portas. ");
INSERT INTO epo_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Tio estas la laboro de la familioj de la Gerŝonidoj en la tabernaklo de kunveno; kaj la kontrolon super ili havas Itamar, filo de la pastro Aaron. ");
INSERT INTO epo_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","La filojn de Merari prikalkulu laŭ iliaj familioj, laŭ ilia patrodomo. ");
INSERT INTO epo_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","De la havantaj la aĝon de tridek jaroj kaj pli ĝis la havantaj la aĝon de kvindek jaroj prikalkulu ilin, ĉiujn servokapablajn, por plenumi la laborojn de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Kaj jen estas la ofico de ilia portado ĉe ilia tuta laborado en la tabernaklo de kunveno: ili portu la tabulojn de la tabernaklo kaj ĝiajn riglilojn kaj ĝiajn kolonojn kaj ĝiajn bazojn; ");
INSERT INTO epo_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","kaj la kolonojn de la korto ĉirkaŭe kaj iliajn bazojn kaj la najlojn kaj la ŝnurojn kun ĉiuj iliaj apartenaĵoj kaj kun ĉiuj iliaj servobjektoj; kaj laŭnome prikalkulu ĉiujn objektojn, kiujn ili ofice devas porti. ");
INSERT INTO epo_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tio estas la laboro de la familioj de la Merariidoj ĉe ilia tuta laborado en la tabernaklo de kunveno, sub la kontrolo de Itamar, filo de la pastro Aaron. ");
INSERT INTO epo_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Kaj Moseo kaj Aaron kaj la estroj de la komunumo prikalkulis la Kehatidojn laŭ iliaj familioj kaj laŭ ilia patrodomo, ");
INSERT INTO epo_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","de la havantaj la aĝon de tridek jaroj kaj pli ĝis la havantaj la aĝon de kvindek jaroj, ĉiujn servokapablajn por la laborado en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Kaj ilia kalkulita nombro laŭ iliaj familioj estis du mil sepcent kvindek. ");
INSERT INTO epo_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Tio estas la kalkulitoj de la familioj Kehatidaj, de ĉiuj laborantoj en la tabernaklo de kunveno, kiujn prikalkulis Moseo kaj Aaron laŭ la diro de la Eternulo per Moseo. ");
INSERT INTO epo_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Kaj la kalkulitoj de la filoj de Gerŝon laŭ iliaj familioj kaj laŭ ilia patrodomo, ");
INSERT INTO epo_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","de la havantaj la aĝon de tridek jaroj kaj pli ĝis la havantaj la aĝon de kvindek jaroj, ĉiuj servokapablaj por la laborado en la tabernaklo de kunveno, ");
INSERT INTO epo_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ilia nombro laŭ iliaj familioj, laŭ ilia patrodomo, estis du mil sescent tridek. ");
INSERT INTO epo_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Tio estas la kalkulitoj de la familioj de la filoj de Gerŝon, de ĉiuj laborantoj en la tabernaklo de kunveno, kiujn prikalkulis Moseo kaj Aaron laŭ la ordono de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Kaj la kalkulitoj de la familioj de la filoj de Merari laŭ iliaj familioj, laŭ ilia patrodomo, ");
INSERT INTO epo_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","de la havantaj la aĝon de tridek jaroj kaj pli ĝis la havantaj la aĝon de kvindek jaroj, ĉiuj servokapablaj por la laborado en la tabernaklo de kunveno, ");
INSERT INTO epo_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ilia nombro laŭ iliaj familioj estis tri mil ducent. ");
INSERT INTO epo_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Tio estas la kalkulitoj de la familioj de la filoj de Merari, kiujn prikalkulis Moseo kaj Aaron laŭ la diro de la Eternulo per Moseo. ");
INSERT INTO epo_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ĉiuj kalkulitoj, kiujn prikalkulis Moseo kaj Aaron kaj la estroj de Izrael, la Levidoj laŭ iliaj familioj kaj laŭ ilia patrodomo, ");
INSERT INTO epo_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","de la havantaj la aĝon de tridek jaroj kaj pli ĝis la havantaj la aĝon de kvindek jaroj, ĉiuj servokapablaj por plenumi laboron kaj plenumi porton en la tabernaklo de kunveno, ");
INSERT INTO epo_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ilia nombro estis ok mil kvincent okdek. ");
INSERT INTO epo_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Laŭ la diro de la Eternulo per Moseo ili estis kalkulitaj, ĉiu laŭ sia laboro kaj portado, kalkulitaj, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Ordonu al la Izraelidoj, ke ili elsendu el la tendaro ĉiujn leprulojn, kaj ĉiujn, kiuj havas elfluon, kaj ĉiujn, kiuj malpuriĝis de mortinto. ");
INSERT INTO epo_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Kiel virojn, tiel ankaŭ virinojn elsendu, ekster la tendaron elsendu ilin, por ke ili ne malpurigu siajn tendarojn, inter kiuj Mi loĝas. ");
INSERT INTO epo_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Kaj la Izraelidoj faris tiel, kaj ili elsendis ilin ekster la tendaron; kiel diris la Eternulo al Moseo, tiel faris la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Diru al la Izraelidoj: Se viro aŭ virino faros ian pekon kontraŭ homo, farante per tio krimon kontraŭ la Eternulo, kaj tiu animo kulpiĝos, ");
INSERT INTO epo_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","tiam ili konfesu sian pekon, kiun ili faris, kaj ili kompensu sian kulpon plene kaj aldonu ĝian kvinonon, kaj donu al tiu, kontraŭ kiu ili kulpiĝis. ");
INSERT INTO epo_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Sed se tiu homo ne havas parencon, al kiu oni povus kompensi la kulpon, tiam la kompenso de la kulpo apartenas al la Eternulo, por la pastro, krom la virŝafo de pekliberigo, per kiu li estos pekliberigita. ");
INSERT INTO epo_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kaj ĉiu oferdono el ĉiuj sanktaĵoj de la Izraelidoj, kiujn ili alportas al la pastro, apartenas al li. ");
INSERT INTO epo_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kaj ĉies sanktigitaĵo al li apartenas. Se iu ion donas al la pastro, ĝi apartenu al li. ");
INSERT INTO epo_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Parolu al la Izraelidoj, kaj diru al ili: Se ies edzino forflankiĝos kaj pekos kontraŭ li, ");
INSERT INTO epo_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kaj iu viro kuŝos kun ŝi sekskuniĝe, kaj tio estos kaŝita antaŭ ŝia edzo, ĉar ŝi malpuriĝis kaŝe, kaj ne estos atestanto pri ŝi kaj ŝi ne estos kaptita; ");
INSERT INTO epo_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","sed atakos lin spirito de ĵaluzo kaj li ĵaluzos sian edzinon, kiam ŝi estos malpuriĝinta, aŭ atakos lin spirito de ĵaluzo kaj li ĵaluzos sian edzinon, kiam ŝi ne estos malpuriĝinta: ");
INSERT INTO epo_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","tiam la edzo alkonduku sian edzinon al la pastro, kaj alportu pro ŝi kiel oferon dekonon de efo da hordea faruno; li ne verŝu sur ĝin oleon kaj ne metu sur ĝin olibanon, ĉar tio estas farunofero de ĵaluzo, farunofero de memorigo, memorigante pri malbonago. ");
INSERT INTO epo_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kaj la pastro alproksimigos ŝin kaj starigos ŝin antaŭ la Eternulo; ");
INSERT INTO epo_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","kaj la pastro prenos sanktan akvon en argila vazo, kaj iom da tero, kiu estos sur la planko de la tabernaklo, la pastro prenos kaj ĵetos en la akvon. ");
INSERT INTO epo_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kaj la pastro starigos la virinon antaŭ la Eternulo kaj disliberigos la harojn sur la kapo de la virino kaj donos en ŝiajn manojn la farunoferon de la memorigo, tiun farunoferon de ĵaluzo, kaj en la mano de la pastro estos akvo maldolĉa, malbeniga. ");
INSERT INTO epo_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kaj la pastro ŝin ĵurligos, kaj diros al la virino: Se neniu viro kuŝis kun vi kaj se vi ne forflankiĝis per malpuriĝo kun alia viro anstataŭ via edzo, tiam restu sendifekta de ĉi tiu maldolĉa malbeniga akvo; ");
INSERT INTO epo_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","sed se vi forflankiĝis kun alia viro anstataŭ via edzo kaj se vi malpuriĝis kaj iu viro kuŝis kun vi krom via edzo — ");
INSERT INTO epo_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","la pastro ĵurligos la virinon per ĵuro de malbeno, kaj la pastro diros al la virino: Tiam la Eternulo fordonu vin al malbeno kaj al ĵuro inter via popolo, farante vian femuron maldikiĝinta kaj vian ventron ŝvelinta; ");
INSERT INTO epo_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","kaj ĉi tiu malbeniga akvo eniru en viajn internaĵojn, por ke ŝvelu via ventro kaj maldikiĝu via femuro. Kaj la virino diros: Amen, amen! ");
INSERT INTO epo_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Kaj la pastro enskribos tiun ĵurligon en libro kaj lavos ĝin per la maldolĉa akvo. ");
INSERT INTO epo_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Kaj li trinkigos al la virino la maldolĉan malbenigan akvon, kaj eniros en ŝin la malbeniga akvo por maldolĉo. ");
INSERT INTO epo_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kaj la pastro prenos el la mano de la virino la farunoferon de ĵaluzo, kaj li skuos la farunoferon antaŭ la Eternulo kaj portos ĝin al la altaro. ");
INSERT INTO epo_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kaj la pastro prenos plenmanon el la farunofero, ĝian parton de memorigo, kaj bruligos sur la altaro, kaj poste li trinkigos al la virino la akvon. ");
INSERT INTO epo_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kaj kiam li estos trinkiginta al ŝi la akvon, tiam, se ŝi malpuriĝis kaj pekis kontraŭ sia edzo, eniros en ŝin la malbeniga akvo por maldolĉo, kaj ŝvelos ŝia ventro kaj maldikiĝos ŝia femuro; kaj la virino fariĝos malbeno inter sia popolo. ");
INSERT INTO epo_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Sed se la virino ne malpuriĝis kaj ŝi estas pura, tiam ŝi restos sendifekta kaj povos naski infanojn. ");
INSERT INTO epo_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Tio estas la leĝo pri la ĵaluzo, kiam virino forflankiĝos kun alia viro anstataŭ sia edzo kaj malpuriĝos, ");
INSERT INTO epo_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","aŭ kiam viron atakos spirito de ĵaluzo kaj li ĵaluzos sian edzinon; tiam li starigu la edzinon antaŭ la Eternulo, kaj la pastro agu kun ŝi laŭ la tuta tiu leĝo. ");
INSERT INTO epo_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Kaj la edzo estos pura de kulpo, kaj la edzino portos sian pekon. ");
INSERT INTO epo_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Parolu al la Izraelidoj, kaj diru al ili: Se viro aŭ virino decidos fari sanktan promeson de konsekriĝo, por konsekri sin al la Eternulo, ");
INSERT INTO epo_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","tiam li devas deteni sin de vino kaj de ebriigaĵo, vinagron vinan kaj vinagron de ebriigaĵoj li ne devas trinki, kaj nenian trinkaĵon el vinberoj li devas trinki, kaj vinberojn freŝajn aŭ sekigitajn li ne devas manĝi. ");
INSERT INTO epo_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Dum la tuta tempo de sia konsekriteco li devas manĝi nenion, kio estas farita el vinberoj, de la kernoj ĝis la ŝelo. ");
INSERT INTO epo_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Dum la tuta tempo de la promesita konsekriteco razilo ne devas ektuŝi lian kapon; ĝis la finiĝo de la tempo, por kiu li konsekris sin al la Eternulo, li estas sankta; li lasu libere kreski la harojn de sia kapo. ");
INSERT INTO epo_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Dum la tuta tempo, por kiu li konsekris sin al la Eternulo, li ne aliru al mortinta korpo. ");
INSERT INTO epo_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ne ĉe sia patro, nek ĉe sia patrino, nek ĉe sia frato, nek ĉe sia fratino li malpuriĝu, se ili mortis; ĉar konsekro al lia Dio estas sur lia kapo. ");
INSERT INTO epo_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Dum la tuta tempo de sia konsekriteco li estas sankta al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kaj se iu mortos apud li subite, neatendite, kaj li malpurigos sian konsekritan kapon, li pritondu sian kapon en la tago de sia puriĝo, en la sepa tago li ĝin pritondu; ");
INSERT INTO epo_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","kaj en la oka tago li alportu du turtojn aŭ du kolombidojn al la pastro, al la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kaj la pastro faros el unu pekoferon kaj el la dua bruloferon, kaj li pekliberigos lin de tio, kion li pekis per la mortinta korpo, kaj li sanktigos lian kapon en tiu tago. ");
INSERT INTO epo_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Kaj li konsekros sin al la Eternulo por la tempo de sia konsekriteco, kaj li alportos jaraĝan ŝafidon kiel kulpoferon; kaj la tempo antaŭa perdos sian valoron, ĉar lia konsekriteco malpuriĝis. ");
INSERT INTO epo_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Kaj jen estas la leĝo pri la konsekrito: kiam finiĝos la tempo de lia konsekriteco, oni venigu lin al la pordo de la tabernaklo de kunveno; ");
INSERT INTO epo_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","kaj li alportu kiel oferon al la Eternulo unu jaraĝan ŝafidon sendifektan kiel bruloferon, kaj unu jaraĝan ŝafidinon sendifektan kiel pekoferon, kaj unu virŝafon sendifektan kiel pacoferon, ");
INSERT INTO epo_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","kaj korbon da macoj el delikata faruno, kukojn miksitajn kun oleo, kaj flanojn nefermentintajn, ŝmiritajn per oleo, kaj ilian farunoferon kaj verŝoferon. ");
INSERT INTO epo_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kaj la pastro prezentos tion antaŭ la Eternulon kaj faros lian pekoferon kaj lian bruloferon. ");
INSERT INTO epo_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kaj el la virŝafo li faros pacoferon al la Eternulo kune kun la korbo da macoj, kaj la pastro faros lian farunoferon kaj lian verŝoferon. ");
INSERT INTO epo_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Kaj la konsekrito pritondos ĉe la pordo de la tabernaklo de kunveno sian konsekritan kapon, kaj li prenos la harojn de sia konsekrita kapo, kaj metos sur la fajron, kiu estas sub la pacofero. ");
INSERT INTO epo_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Kaj la pastro prenos la kuiritan ŝultron de la virŝafo kaj unu nefermentintan kukon el la korbo kaj unu nefermentintan flanon, kaj li metos tion sur la manon de la konsekrito, kiam tiu estos pritondinta sian konsekritan kapon. ");
INSERT INTO epo_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Kaj la pastro skuos tion kiel skuoferon antaŭ la Eternulo; sanktigita ĝi estu por la pastro, krom la brustaĵo de skuado kaj la femuro de levado. Poste la konsekrito povas trinki vinon. ");
INSERT INTO epo_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Tio estas la leĝo pri konsekrito, kiu donis sanktan promeson; lia ofero apartenas al la Eternulo pro lia konsekriteco, krom tio, kion permesos al li lia bonhavo; konforme al sia promeso, kiun li promesis, li faru, laŭ la leĝo pri lia konsekriteco. ");
INSERT INTO epo_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Diru al Aaron kaj al liaj filoj jene: Tiamaniere benu la Izraelidojn; diru al ili: ");
INSERT INTO epo_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","La Eternulo vin benu kaj vin gardu; ");
INSERT INTO epo_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","La Eternulo lumu al vi per Sia vizaĝo kaj favorkoru vin; ");
INSERT INTO epo_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","La Eternulo turnu Sian vizaĝon al vi kaj donu al vi pacon. ");
INSERT INTO epo_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Tiel ili metu Mian nomon sur la Izraelidojn, kaj Mi ilin benos. ");
INSERT INTO epo_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","En la tago, kiam Moseo finis la starigadon de la tabernaklo, kiam li sanktoleis ĝin kaj sanktigis ĝin kaj ĉiujn ĝiajn apartenaĵojn kaj la altaron kaj ĉiujn ĝiajn apartenaĵojn kaj sanktoleis ilin kaj sanktigis ilin, ");
INSERT INTO epo_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","tiam alportis la estroj de Izrael, la ĉefoj de siaj patrodomoj, tiuj estroj de la triboj, tiuj, kiuj administris la kalkuladon — ");
INSERT INTO epo_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ili alportis siajn oferojn antaŭ la Eternulon, ses kovritajn veturilojn kaj dek du bovojn, po unu veturilo de du estroj kaj po unu bovo de ĉiu, kaj ili venigis tion antaŭ la tabernaklon. ");
INSERT INTO epo_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Prenu de ili, kaj tio estu por la plenumado de la laboroj ĉe la tabernaklo de kunveno; kaj donu tion al la Levidoj, al ĉiu laŭ la speco de lia laborado. ");
INSERT INTO epo_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Kaj Moseo prenis la veturilojn kaj la bovojn kaj donis ilin al la Levidoj. ");
INSERT INTO epo_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Du veturilojn kaj kvar bovojn li donis al la filoj de Gerŝon laŭ la speco de ilia laborado; ");
INSERT INTO epo_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","kaj kvar veturilojn kaj ok bovojn li donis al la filoj de Merari laŭ la speco de ilia laborado, sub la kontrolo de Itamar, filo de la pastro Aaron. ");
INSERT INTO epo_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Sed al la filoj de Kehat li ne donis, ĉar ili havis laboradon sanktan; sur la ŝultroj ili devis porti. ");
INSERT INTO epo_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kaj la estroj alportis oferojn por inaŭgura dono de la altaro, en la tago, en kiu ĝi estis sanktoleita; kaj la estroj alportis sian oferon antaŭ la altaron. ");
INSERT INTO epo_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kaj la Eternulo diris al Moseo: Po unu estro en tago ili alportu sian oferon por la inaŭguro de la altaro. ");
INSERT INTO epo_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","En la unua tago la alportanto de sia ofero estis Naĥŝon, filo de Aminadab, de la tribo de Jehuda. ");
INSERT INTO epo_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Kaj lia ofero estis: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Naĥŝon, filo de Aminadab. ");
INSERT INTO epo_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","En la dua tago alportis Natanel, filo de Cuar, estro de Isaĥar. ");
INSERT INTO epo_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Li alportis sian oferon, kiu estis: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Netanel, filo de Cuar. ");
INSERT INTO epo_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","En la tria tago — la estro de la Zebulunidoj, Eliab, filo de Ĥelon. ");
INSERT INTO epo_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Eliab, filo de Ĥelon. ");
INSERT INTO epo_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","En la kvara tago — la estro de la Rubenidoj, Elicur, filo de Ŝedeur. ");
INSERT INTO epo_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Elicur, filo de Ŝedeur. ");
INSERT INTO epo_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","En la kvina tago — la estro de la Simeonidoj, Ŝelumiel, filo de Curiŝadaj. ");
INSERT INTO epo_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Ŝelumiel, filo de Curiŝadaj. ");
INSERT INTO epo_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","En la sesa tago — la estro de la Gadidoj, Eljasaf, filo de Deuel. ");
INSERT INTO epo_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Eljasaf, filo de Deuel. ");
INSERT INTO epo_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","En la sepa tago — la estro de la Efraimidoj, Eliŝama, filo de Amihud. ");
INSERT INTO epo_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Eliŝama, filo de Amihud. ");
INSERT INTO epo_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","En la oka tago — la estro de la Manaseidoj, Gamliel, filo de Pedacur. ");
INSERT INTO epo_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Gamliel, filo de Pedacur. ");
INSERT INTO epo_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","En la naŭa tago — la estro de la Benjamenidoj, Abidan, filo de Gideoni. ");
INSERT INTO epo_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Abidan, filo de Gideoni. ");
INSERT INTO epo_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","En la deka tago — la estro de la Danidoj, Aĥiezer, filo de Amiŝadaj. ");
INSERT INTO epo_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Aĥiezer, filo de Amiŝadaj. ");
INSERT INTO epo_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","En la dek-unua tago — la estro de la Aŝeridoj, Pagiel, filo de Oĥran. ");
INSERT INTO epo_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Pagiel, filo de Oĥran. ");
INSERT INTO epo_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","En la dek-dua tago — la estro de la Naftaliidoj, Aĥira, filo de Enan. ");
INSERT INTO epo_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Lia ofero: unu arĝenta plado, havanta la pezon de cent tridek sikloj, unu arĝenta kaliko de sepdek sikloj, laŭ la sankta siklo, ambaŭ plenaj de delikata faruno, miksita kun oleo, por farunofero; ");
INSERT INTO epo_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","unu ora kulero deksikla, plena de incenso; ");
INSERT INTO epo_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","unu bovido, unu virŝafo, unu jaraĝa ŝafido por brulofero; ");
INSERT INTO epo_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","unu kapro por pekofero; ");
INSERT INTO epo_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","kaj por pacofero du bovoj, kvin virŝafoj, kvin virkaproj, kvin jaraĝaj ŝafidoj. Tio estis la ofero de Aĥira, filo de Enan. ");
INSERT INTO epo_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Tia estis la inaŭgura dono de la altaro, en la tago, en kiu ĝi estis sanktoleita, de la estroj de Izrael: dek du arĝentaj pladoj, dek du arĝentaj kalikoj, dek du oraj kuleroj; ");
INSERT INTO epo_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","po cent tridek sikloj da arĝento havis ĉiu plado, kaj po sepdek ĉiu kaliko; la tuta arĝento de tiuj vazoj estis du mil kvarcent sikloj laŭ la sankta siklo. ");
INSERT INTO epo_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Da oraj kuleroj plenaj de incenso estis dek du; po dek sikloj havis ĉiu kulero, laŭ la sankta siklo; la tuta oro de la kuleroj estis cent dudek sikloj. ");
INSERT INTO epo_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ĉiuj brutoj por brulofero estis: dek du bovidoj, dek du virŝafoj, dek du jaraĝaj ŝafidoj, kaj al ili farunoferoj; kaj dek du kaproj por pekofero. ");
INSERT INTO epo_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Kaj ĉiuj brutoj por pacofero estis: dudek kvar bovoj, sesdek virŝafoj, sesdek virkaproj, sesdek jaraĝaj ŝafidoj. Tio estis la inaŭgura dono de la altaro, post kiam ĝi estis sanktoleita. ");
INSERT INTO epo_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Kaj kiam Moseo eniris en la tabernaklon de kunveno, por paroli kun Li, li aŭdis la Voĉon, parolantan al li de super la fermoplato, kiu estas sur la kesto de atesto, inter la du keruboj; kaj estis parolate al li. ");
INSERT INTO epo_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Parolu al Aaron, kaj diru al li: Kiam vi ekbruligos la lucernojn, tiam sur la antaŭan flankon de la kandelabro lumu la sep lucernoj. ");
INSERT INTO epo_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Kaj Aaron tiel faris; sur la antaŭan flankon de la kandelabro li lumigis la lucernojn, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Kaj jen estas la aranĝo de la kandelabro: forĝita el oro, de ĝia trunko ĝis ĝiaj floroj, forĝita ĝi estis; laŭ la modelo, kiun montris la Eternulo al Moseo, tiel li faris la kandelabron. ");
INSERT INTO epo_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Prenu la Levidojn el inter la Izraelidoj kaj purigu ilin. ");
INSERT INTO epo_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Kaj tiel agu kun ili, por purigi ilin: aspergu ilin per akvo propeka, kaj ili prirazu sian tutan korpon kaj lavu siajn vestojn kaj purigu sin. ");
INSERT INTO epo_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kaj ili prenu bovidon kaj al ĝi farunoferon, delikatan farunon, miksitan kun oleo, kaj duan bovidon prenu por pekofero. ");
INSERT INTO epo_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Kaj venigu la Levidojn antaŭ la tabernaklon de kunveno, kaj kunvenigu la tutan komunumon de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Kaj alvenigu la Levidojn antaŭ la Eternulon, kaj la Izraelidoj metu siajn manojn sur la Levidojn. ");
INSERT INTO epo_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Kaj Aaron faru super la Levidoj skuon antaŭ la Eternulo en la nomo de la Izraelidoj, por ke ili komencu fari la servon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Kaj la Levidoj metu siajn manojn sur la kapojn de la bovidoj, kaj faru el unu pekoferon kaj el la dua bruloferon al la Eternulo, por pekliberigi la Levidojn. ");
INSERT INTO epo_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Kaj starigu la Levidojn antaŭ Aaron kaj antaŭ liaj filoj, kaj faru super ili skuon antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kaj tiel apartigu la Levidojn el inter la Izraelidoj, kaj la Levidoj apartenu al Mi. ");
INSERT INTO epo_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Kaj post tio la Levidoj eniros, por servi en la tabernaklo de kunveno, kiam vi estos puriginta ilin kaj plenuminta super ili la skuon. ");
INSERT INTO epo_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ĉar ili estas fordonitaj al Mi el inter la Izraelidoj; anstataŭ ĉiuj utermalfermintoj unuenaskitoj el ĉiuj Izraelidoj Mi prenis ilin por Mi. ");
INSERT INTO epo_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ĉar al Mi apartenas ĉiuj unuenaskitoj de la Izraelidoj, el la homoj kaj el la brutoj; en la tago, en kiu Mi batis ĉiujn unuenaskitojn en la lando Egipta, Mi sanktigis ilin por Mi. ");
INSERT INTO epo_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Kaj Mi prenis la Levidojn anstataŭ ĉiuj unuenaskitoj inter la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kaj Mi fordonis la Levidojn al Aaron kaj al liaj filoj el inter la Izraelidoj, por ke ili faru servon pro la Izraelidoj en la tabernaklo de kunveno kaj por pekliberigi la Izraelidojn; por ke ne trafu la Izraelidojn frapo, se la Izraelidoj alproksimiĝus al la sanktejo. ");
INSERT INTO epo_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Kaj Moseo kaj Aaron kaj la tuta komunumo de la Izraelidoj agis kun la Levidoj konforme al ĉio, kion la Eternulo ordonis al Moseo pri la Levidoj; tiel agis kun ili la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Kaj la Levidoj sin purigis kaj lavis siajn vestojn, kaj Aaron faris super ili skuon antaŭ la Eternulo, kaj Aaron pekliberigis ilin, por purigi ilin. ");
INSERT INTO epo_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Kaj post tio la Levidoj eniris, por plenumi sian servon en la tabernaklo de kunveno antaŭ Aaron kaj antaŭ liaj filoj; kiel la Eternulo ordonis al Moseo pri la Levidoj, tiel oni agis kun ili. ");
INSERT INTO epo_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Jen estas, kio koncernas la Levidojn: de la aĝo de dudek kvin jaroj kaj pli ili devas eniri en sian oficon pri la servado en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Kaj de la aĝo de kvindek jaroj ili retiriĝos el la ofico de la servado kaj ne servos plu. ");
INSERT INTO epo_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Tiam ili servos siajn fratojn en la tabernaklo de kunveno, plenumante gardadon, sed ne farante servadon. Tiel agu kun la Levidoj koncerne ilian oficon. ");
INSERT INTO epo_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Kaj la Eternulo ekparolis al Moseo en la dezerto Sinaj en la dua jaro post ilia eliro el la lando Egipta, en la unua monato, dirante: ");
INSERT INTO epo_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","La Izraelidoj faru la Paskon en la difinita tempo. ");
INSERT INTO epo_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","En la dek-kvara tago de ĉi tiu monato, ĉirkaŭ la vespero, faru ĝin en ĝia tempo; laŭ ĉiuj ĝiaj leĝoj kaj laŭ ĉiuj ĝiaj instrukcioj faru ĝin. ");
INSERT INTO epo_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kaj Moseo diris al la Izraelidoj, ke ili faru la Paskon. ");
INSERT INTO epo_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Kaj ili faris la Paskon en la unua monato, en la dek-kvara tago de la monato, ĉirkaŭ la vespero, en la dezerto Sinaj; konforme al ĉio, kion la Eternulo ordonis al Moseo, tiel faris la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Sed estis homoj, kiuj estis malpuraj pro ektuŝo de mortinta homo kaj ne povis fari la Paskon en tiu tago; ili venis antaŭ Moseon kaj Aaronon en tiu tago; ");
INSERT INTO epo_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","kaj tiuj homoj diris al li: Ni estas malpuraj pro ektuŝo de mortinta homo; kial ni estu esceptataj, ke ni ne alportu la oferon al la Eternulo en ĝia tempo inter la Izraelidoj? ");
INSERT INTO epo_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Kaj Moseo diris al ili: Staru; mi aŭskultos, kion la Eternulo ordonos koncerne vin. ");
INSERT INTO epo_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Parolu al la Izraelidoj, dirante: Se iu el vi aŭ el viaj estontaj generacioj estos malpura pro ektuŝo de mortinta homo, aŭ se iu estos en malproksima vojiro, tamen li faru Paskon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","En la dua monato, en la dek-kvara tago, ĉirkaŭ la vespero ili faru ĝin; kun macoj kaj maldolĉaj herboj ili ĝin manĝu. ");
INSERT INTO epo_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ili ne lasu iom el ĝi ĝis la mateno, kaj oston ili ne rompu en ĝi; laŭ ĉiuj ritoj de la Pasko ili faru ĝin. ");
INSERT INTO epo_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Sed se iu estas pura kaj ne troviĝas en vojiro kaj tamen ne faras la Paskon, ties animo ekstermiĝos el inter sia popolo, ĉar oferon al la Eternulo li ne alportis en ĝia tempo; sian pekon portos tiu homo. ");
INSERT INTO epo_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kaj se loĝos ĉe vi fremdulo, li ankaŭ faru Paskon al la Eternulo; laŭ la rito de la Pasko kaj laŭ ĝia regularo li faru: sama regularo estu por vi, kiel por la fremdulo, tiel por la indiĝeno. ");
INSERT INTO epo_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","En la tago, en kiu estis starigita la tabernaklo, nubo kovris la tabernaklon super la tendo de atesto, kaj vespere estis super la tabernaklo kvazaŭ aspekto de fajro ĝis la mateno. ");
INSERT INTO epo_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tiel estis ĉiam: nubo ĝin kovris, kaj fajra aspekto en la nokto. ");
INSERT INTO epo_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kaj kiam leviĝadis la nubo de super la tabernaklo, tuj poste elmoviĝadis la Izraelidoj; kaj sur la loko, kie haltadis la nubo, tie starigadis sian tendaron la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Laŭ la ordono de la Eternulo la Izraelidoj elmoviĝadis, kaj laŭ la ordono de la Eternulo ili starigadis sian tendaron; dum la tuta tempo, kiam la nubo restis super la tabernaklo, ili staradis tendare. ");
INSERT INTO epo_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kaj se la nubo restadis super la tabernaklo longan tempon, la Izraelidoj plenumadis la instrukcion de la Eternulo kaj ne elmoviĝadis. ");
INSERT INTO epo_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Iufoje la nubo restadis kelke da tagoj super la tabernaklo, sed ili laŭ la ordono de la Eternulo restadis tendare kaj laŭ la ordono de la Eternulo elmoviĝadis. ");
INSERT INTO epo_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Iufoje la nubo restadis de vespero ĝis mateno; tiam, kiam la nubo leviĝis matene, ili elmoviĝadis; iufoje tagon kaj nokton — kiam la nubo leviĝis, ili elmoviĝadis. ");
INSERT INTO epo_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Iufoje du tagojn aŭ monaton aŭ pli longan tempon — kiel longe la nubo super la tabernaklo restis super ĝi, la Izraelidoj restadis tendare kaj ne elmoviĝadis; sed kiam ĝi leviĝis, ili elmoviĝadis. ");
INSERT INTO epo_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Laŭ la ordono de la Eternulo ili restadis tendare, kaj laŭ la ordono de la Eternulo ili elmoviĝadis; ili plenumadis la instrukcion de la Eternulo, konforme al tio, kiel la Eternulo ordonis per Moseo. ");
INSERT INTO epo_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Faru al vi du arĝentajn trumpetojn, forĝitaj faru ilin; kaj ili servu al vi por kunvokado de la komunumo kaj por elmoviĝado de la tendaroj. ");
INSERT INTO epo_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kiam oni simple trumpetos per ili, tiam kolektiĝu al vi la tuta komunumo antaŭ la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kaj se oni trumpetos per unu el ili, tiam kolektiĝu al vi la princoj, la milestroj de Izrael. ");
INSERT INTO epo_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kaj kiam vi trumpetos tambursone, tiam elmoviĝu la tendaroj, kiuj staras oriente. ");
INSERT INTO epo_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kaj kiam vi trumpetos tambursone duan fojon, tiam elmoviĝu la tendaroj, kiuj staras sude; oni trumpetu tambursone, kiam ili devos elmoviĝi. ");
INSERT INTO epo_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Sed kiam oni devas kunvenigi la komunumon, tiam trumpetu simple, sed ne tambursone. ");
INSERT INTO epo_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Kaj la filoj de Aaron, la pastroj, trumpetu per la trumpetoj; tio estu por vi leĝo eterna en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kaj kiam vi komencos militon en via lando kontraŭ malamiko, kiu premas vin, tiam trumpetu tambursone per trumpetoj; kaj tiam vi estos rememoritaj antaŭ la Eternulo, via Dio, kaj vi estos helpitaj kontraŭ viaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Kaj en la tago de via ĝojo kaj en viaj festoj kaj en viaj novmonataj tagoj trumpetu per trumpetoj ĉe viaj bruloferoj kaj ĉe viaj pacoferoj; kaj tio estos memorigo pri vi antaŭ via Dio: Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","En la dua jaro, en la dua monato, en la dudeka tago de la monato, leviĝis la nubo de super la tabernaklo de atesto. ");
INSERT INTO epo_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Kaj elmoviĝis la Izraelidoj en sian vojiron el la dezerto Sinaj, kaj la nubo haltis en la dezerto Paran. ");
INSERT INTO epo_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Kaj ili elmoviĝis la unuan fojon konforme al la ordono de la Eternulo per Moseo. ");
INSERT INTO epo_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Kaj unue elmoviĝis la standardo de la tendaro de la Jehudaidoj laŭ iliaj taĉmentoj, kaj super ĝia taĉmento estis Naĥŝon, filo de Aminadab. ");
INSERT INTO epo_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Kaj super la taĉmento de la tribo de la Isaĥaridoj estis Netanel, filo de Cuar. ");
INSERT INTO epo_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Kaj super la taĉmento de la tribo de la Zebulunidoj estis Eliab, filo de Ĥelon. ");
INSERT INTO epo_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Kaj oni dismetis la tabernaklon, kaj elmoviĝis la filoj de Gerŝon kaj la filoj de Merari, portantaj la tabernaklon. ");
INSERT INTO epo_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kaj elmoviĝis la standardo de la tendaro de Ruben laŭ iliaj taĉmentoj, kaj super ĝia taĉmento estis Elicur, filo de Ŝedeur. ");
INSERT INTO epo_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Kaj super la taĉmento de la tribo de la Simeonidoj estis Ŝelumiel, filo de Curiŝadaj. ");
INSERT INTO epo_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Kaj super la taĉmento de la tribo de la Gadidoj estis Eljasaf, filo de Deuel. ");
INSERT INTO epo_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kaj elmoviĝis la Kehatidoj, portantaj la sanktaĵojn; sed oni starigis la tabernaklon antaŭ ilia alveno. ");
INSERT INTO epo_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kaj elmoviĝis la standardo de la tendaro de la Efraimidoj laŭ iliaj taĉmentoj, kaj super ĝia taĉmento estis Eliŝama, filo de Amihud. ");
INSERT INTO epo_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Kaj super la taĉmento de la tribo de la Manaseidoj estis Gamliel, filo de Pedacur. ");
INSERT INTO epo_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Kaj super la taĉmento de la tribo de la Benjamenidoj estis Abidan, filo de Gideoni. ");
INSERT INTO epo_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kaj elmoviĝis la standardo de la tendaro de la Danidoj, la finulo de ĉiuj tendaroj, laŭ iliaj taĉmentoj, kaj super ĝia taĉmento estis Aĥiezer, filo de Amiŝadaj. ");
INSERT INTO epo_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Kaj super la taĉmento de la tribo de la Aŝeridoj estis Pagiel, filo de Oĥran. ");
INSERT INTO epo_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Kaj super la taĉmento de la tribo de la Naftaliidoj estis Aĥira, filo de Enan. ");
INSERT INTO epo_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tiaj estis la marŝoj de la Izraelidoj laŭ iliaj taĉmentoj. Kaj ili elmoviĝis. ");
INSERT INTO epo_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Kaj Moseo diris al Ĥobab, filo de Reuel la Midjanido, la bopatro de Moseo: Ni vojiras al tiu loko, pri kiu la Eternulo diris: Ĝin Mi donos al vi; iru kun ni, kaj ni faros al vi bonon, ĉar la Eternulo promesis bonon al Izrael. ");
INSERT INTO epo_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Sed tiu diris al li: Mi ne iros, sed al mia lando kaj al mia parencaro mi iros. ");
INSERT INTO epo_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kaj li diris: Ho, ne forlasu nin; ĉar vi scias, kie ni povas starigi tendaron en la dezerto, kaj vi estos por ni kiel okuloj; ");
INSERT INTO epo_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","se vi iros kun ni, tiam la bonon, kiun la Eternulo faros al ni, ni faros al vi. ");
INSERT INTO epo_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Kaj ili ekvojiris for de la monto de la Eternulo vojon de tri tagoj; kaj la kesto de la interligo de la Eternulo iris antaŭ ili la tritagan vojon, por esplori por ili lokon de ripozo. ");
INSERT INTO epo_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kaj la nubo de la Eternulo estis super ili dum la tago, kiam ili iris el la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kaj ĉiufoje, kiam la kesto elmoviĝis, Moseo diradis: Leviĝu, ho Eternulo, kaj disĵetiĝu Viaj malamikoj, kaj forkuru Viaj malamantoj for de Via vizaĝo. ");
INSERT INTO epo_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Kaj kiam ĝi haltis, li diradis: Revenu, ho Eternulo, al la multegaj miloj de Izrael. ");
INSERT INTO epo_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Kaj la popolo komencis murmuri pri sia malfeliĉo al la oreloj de la Eternulo; kaj kiam la Eternulo tion aŭdis, Lia kolero ekflamis; kaj ekbrulis inter ili fajro de la Eternulo, kaj ĝi komencis ekstermadon en la rando de la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tiam la popolo ekkriis al Moseo, kaj Moseo preĝis al la Eternulo, kaj la fajro estingiĝis. ");
INSERT INTO epo_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Kaj li donis al tiu loko la nomon Tabera, ĉar brulis inter ili la fajro de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Kaj la aliĝinta popolamaso inter ili komencis aperigi kapricojn; kaj ankaŭ la Izraelidoj ekploris, kaj diris: Kiu manĝigos al ni viandon? ");
INSERT INTO epo_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ni memoras la fiŝojn, kiujn ni manĝis en Egiptujo senpage, la kukumojn kaj la melonojn kaj la poreojn kaj la bulbojn kaj la ajlojn. ");
INSERT INTO epo_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Kaj nun nia animo velkas; estas nenio krom ĉi tiu manao antaŭ niaj okuloj. ");
INSERT INTO epo_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Kaj la manao estis kiel semo de koriandro, kaj ĝia aspekto estis kiel la aspekto de bedelio. ");
INSERT INTO epo_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","La popolo disiradis kaj kolektadis kaj mueladis per muelŝtonoj aŭ pistadis en pistujo, kaj kuiradis en kaldrono kaj faradis el ĝi kukojn; kaj ĝia gusto estis kiel la gusto de oleaj kukoj. ");
INSERT INTO epo_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kaj kiam la roso faladis sur la tendaron en la nokto, tiam faladis sur ĝin ankaŭ la manao. ");
INSERT INTO epo_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moseo aŭdis, ke la popolo ploras en siaj familioj, ĉiu ĉe la pordo de sia tendo; kaj forte ekflamis la kolero de la Eternulo, kaj Moseon tio afliktis. ");
INSERT INTO epo_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Kaj Moseo diris al la Eternulo: Kial Vi faris malbonon al Via sklavo? kaj kial mi ne plaĉis al Vi, ke Vi metis la ŝarĝon de tiu tuta popolo sur min? ");
INSERT INTO epo_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ĉu mi embriigis tiun tutan popolon? aŭ ĉu mi ĝin naskis, ke Vi diris al mi: Portu ĝin sur via brusto, kiel portas nutristino suĉinfanon, en la landon, pri kiu Vi ĵuris al ĝiaj patroj? ");
INSERT INTO epo_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Kie mi prenos viandon, por doni al tiu tuta popolo? ĉar ili ploras antaŭ mi, dirante: Donu al ni viandon por manĝi. ");
INSERT INTO epo_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ne povas mi sola porti tiun tutan popolon, ĉar ĝi estas tro peza por mi. ");
INSERT INTO epo_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kaj se Vi tiel agas kun mi, tiam mortigu min, se mi plaĉas al Vi, por ke mi ne vidu mian malfeliĉon. ");
INSERT INTO epo_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Tiam la Eternulo diris al Moseo: Kolektu al Mi sepdek virojn el la plejaĝuloj de Izrael, pri kiuj vi scias, ke ili estas la plejaĝuloj de la popolo kaj ĝiaj gvidantoj, kaj prenu ilin al la tabernaklo de kunveno, ke ili stariĝu tie kun vi. ");
INSERT INTO epo_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Kaj Mi malleviĝos kaj parolos tie kun vi, kaj Mi deprenos iom de la spirito, kiu estas sur vi, kaj Mi metos sur ilin, por ke ili portu kun vi la ŝarĝon de la popolo kaj por ke vi ne portu sola. ");
INSERT INTO epo_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Kaj al la popolo diru: Prepariĝu por morgaŭ, kaj vi manĝos viandon; ĉar vi ploris al la oreloj de la Eternulo, dirante: Kiu manĝigos al ni viandon? bone estis al ni en Egiptujo — tial la Eternulo donos al vi viandon, kaj vi manĝos. ");
INSERT INTO epo_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ne dum unu tago vi manĝos, kaj ne dum du tagoj kaj ne dum kvin tagoj kaj ne dum dek tagoj kaj ne dum dudek tagoj; ");
INSERT INTO epo_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","sed dum tuta monato, ĝis ĝi eliros tra viaj nazotruoj kaj fariĝos al vi abomenaĵo, pro tio, ke vi malŝatis la Eternulon, kiu estas inter vi, kaj vi ploris antaŭ Li, dirante: Por kio ni eliris el Egiptujo? ");
INSERT INTO epo_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Kaj Moseo diris: El sescent mil piedirantoj konsistas la popolo, en kies mezo mi estas; kaj Vi diras: Mi donos al ili viandon, ke ili manĝos dum tuta monato! ");
INSERT INTO epo_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ĉu oni buĉu por ili ŝafojn kaj bovojn, por ke sufiĉu por ili? aŭ ĉu ĉiujn fiŝojn de la maro oni kolektu por ili, por ke sufiĉu por ili? ");
INSERT INTO epo_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Tiam la Eternulo diris al Moseo: Ĉu la brako de la Eternulo estas tro mallonga? nun vi vidos, ĉu plenumiĝos al vi Mia vorto, aŭ ne. ");
INSERT INTO epo_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kaj Moseo eliris, kaj transdiris al la popolo la vortojn de la Eternulo; kaj li kolektis sepdek virojn el la plejaĝuloj de la popolo, kaj li starigis ilin ĉirkaŭ la tabernaklo. ");
INSERT INTO epo_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Kaj la Eternulo malleviĝis en nubo kaj parolis kun li, kaj Li deprenis iom de la spirito, kiu estis sur li, kaj metis sur la sepdek virojn plejaĝulojn. Kaj kiam haltis sur ili la spirito, ili ekprofetis kaj ne ĉesis. ");
INSERT INTO epo_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Sed restis du viroj en la tendaro; la nomo de unu estis Eldad, kaj la nomo de la dua estis Medad; kaj suriris sur ilin la spirito — ĉar ili estis inter la enskribitaj, sed ne eliris al la tabernaklo — kaj ili ekprofetis en la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Tiam kuris junulo kaj raportis al Moseo, kaj diris: Eldad kaj Medad profetas en la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Kaj respondis Josuo, filo de Nun, kaj servanto de Moseo detempe de lia juneco, kaj diris: Mia sinjoro Moseo, malpermesu al ili. ");
INSERT INTO epo_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Sed Moseo diris al li: Ĉu vi ĵaluzas pri mi? estus dezirinde, ke la tuta popolo de la Eternulo fariĝu profetoj, se la Eternulo metus Sian spiriton sur ilin. ");
INSERT INTO epo_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Kaj revenis Moseo en la tendaron, li kaj la plejaĝuloj de Izrael. ");
INSERT INTO epo_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kaj vento elmoviĝis de la Eternulo, kaj alportis de la maro koturnojn kaj ĵetis ilin sur la tendaron, sur la spaco de unutaga irado sur unu flanko kaj sur la spaco de unutaga irado sur la dua flanko, ĉirkaŭ la tendaro kaj en denseco de du ulnoj super la tero. ");
INSERT INTO epo_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Kaj la popolo staris tiun tutan tagon kaj la tutan nokton kaj la tutan morgaŭan tagon kaj kolektis la koturnojn; kiu kolektis plej malmulte, kolektis dek ĥomerojn; kaj ili diskuŝigis ilin al si ĉirkaŭ la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kiam la viando estis ankoraŭ inter iliaj dentoj kaj ankoraŭ ne estis konsumita, ekflamis kontraŭ la popolo la kolero de la Eternulo, kaj la Eternulo frapis la popolon per tre granda frapo. ");
INSERT INTO epo_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kaj oni donis al tiu loko la nomon Kibrot-Hataava, ĉar tie oni enterigis la homojn, kiuj kapricis. ");
INSERT INTO epo_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Kibrot-Hataava la popolo ekvojiris al Ĥacerot kaj restis en Ĥacerot. ");
INSERT INTO epo_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Kaj ekparolis Mirjam kaj Aaron kontraŭ Moseo pro la edzino Etiopino, kiun li prenis; ĉar li prenis al si edzinon Etiopinon. ");
INSERT INTO epo_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kaj ili diris: Ĉu nur kun Moseo parolis la Eternulo? Li parolis ja ankaŭ kun ni. Kaj la Eternulo tion aŭdis. ");
INSERT INTO epo_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Sed Moseo estis homo tre modesta, pli ol ĉiuj homoj sur la tero. ");
INSERT INTO epo_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Kaj subite diris la Eternulo al Moseo kaj al Aaron kaj al Mirjam: Eliru vi tri al la tabernaklo de kunveno. Kaj ili eliris ĉiuj tri. ");
INSERT INTO epo_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kaj la Eternulo malleviĝis en nuba kolono kaj stariĝis ĉe la pordo de la tabernaklo, kaj Li vokis Aaronon kaj Mirjamon, kaj ili ambaŭ eliris. ");
INSERT INTO epo_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kaj Li diris: Aŭskultu Miajn vortojn: se iu el vi estas profeto de la Eternulo, Mi aperas al li en vizio, Mi parolas kun li en sonĝo; ");
INSERT INTO epo_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","sed ne tiel estas kun Mia sklavo Moseo: en Mia tuta domo li estas konfidato. ");
INSERT INTO epo_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Buŝon kontraŭ buŝo Mi parolas kun li, kaj malkaŝe, ne per enigmoj; kaj la bildon de la Eternulo li vidas. Kial vi ne timis paroli kontraŭ Mia sklavo Moseo? ");
INSERT INTO epo_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Kaj ekflamis la kolero de la Eternulo kontraŭ ili, kaj Li foriris. ");
INSERT INTO epo_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Kaj la nubo forturniĝis de super la tabernaklo, kaj jen Mirjam kovriĝis per lepro, kiel per neĝo. Kaj Aaron turniĝis al Mirjam, kaj li ekvidis, ke ŝi estas lepra. ");
INSERT INTO epo_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kaj Aaron diris al Moseo: Mi petas, mia sinjoro, ne kalkulu al ni kiel pekon, ke ni agis malsaĝe kaj ke ni pekis; ");
INSERT INTO epo_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ho, ŝi ne estu kiel malvivulo, ĉe kiu tuj post la eliro el la ventro de sia patrino forkonsumiĝis jam duono de la korpo. ");
INSERT INTO epo_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kaj Moseo ekkriis al la Eternulo, dirante: Mi petas Vin, ho Dio, sanigu ŝin. ");
INSERT INTO epo_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Kaj la Eternulo diris al Moseo: Se ŝia patro estus kraĉinta sur ŝian vizaĝon, ĉu ŝi tiam ne hontus sep tagojn? ŝi estu do enŝlosita dum sep tagoj ekster la tendaro, kaj poste ŝi revenu. ");
INSERT INTO epo_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kaj Mirjam estis enŝlosita ekster la tendaro dum sep tagoj; kaj la popolo ne elmoviĝis, ĝis Mirjam revenis. ");
INSERT INTO epo_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Poste la popolo ekvojiris de Ĥacerot kaj haltis tendare en la dezerto Paran. ");
INSERT INTO epo_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Sendu virojn, ke ili esplorrigardu la landon Kanaanan, kiun Mi donas al la Izraelidoj; po unu viro el ĉiu tribo de iliaj patroj sendu, ĉiu estu eminentulo inter ili. ");
INSERT INTO epo_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kaj Moseo sendis ilin el la dezerto Paran laŭ la ordono de la Eternulo; ĉiuj ili estis eminentuloj inter la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Kaj jen estas iliaj nomoj: el la tribo de Ruben, Ŝamua, filo de Zakur; ");
INSERT INTO epo_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","el la tribo de Simeon, Ŝafat, filo de Ĥori; ");
INSERT INTO epo_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","el la tribo de Jehuda, Kaleb, filo de Jefune; ");
INSERT INTO epo_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","el la tribo de Isaĥar, Jigal, filo de Jozef; ");
INSERT INTO epo_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","el la tribo de Efraim, Hoŝea, filo de Nun; ");
INSERT INTO epo_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","el la tribo de Benjamen, Palti, filo de Rafu; ");
INSERT INTO epo_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","el la tribo de Zebulun, Gadiel, filo de Sodi; ");
INSERT INTO epo_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","el la tribo de Jozef, el la tribo de Manase, Gadi, filo de Susi; ");
INSERT INTO epo_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","el la tribo de Dan, Amiel, filo de Gemali; ");
INSERT INTO epo_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","el la tribo de Aŝer, Setur, filo de Miĥael; ");
INSERT INTO epo_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","el la tribo de Naftali, Naĥbi, filo de Vofsi; ");
INSERT INTO epo_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","el la tribo de Gad, Geuel, filo de Maĥi. ");
INSERT INTO epo_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Tio estas la nomoj de la viroj, kiujn Moseo sendis, por esplorrigardi la landon. Kaj Moseo donis al Hoŝea, filo de Nun, la nomon Josuo. ");
INSERT INTO epo_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kaj Moseo sendis ilin, por esplorrigardi la landon Kanaanan, kaj diris al ili: Iru tien tra la Sudo kaj suriru sur la monton; ");
INSERT INTO epo_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","kaj rigardu la landon, kia ĝi estas; kaj la popolon, kiu loĝas en ĝi, ĉu ĝi estas forta aŭ malforta, ĉu ĝi estas malgrandnombra aŭ grandnombra; ");
INSERT INTO epo_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","kaj kia estas la tero, sur kiu ĝi sidas, ĉu ĝi estas bona aŭ malbona; kaj kiaj estas la urboj, en kiuj ĝi loĝas, ĉu en tendaroj aŭ en fortikaĵoj; ");
INSERT INTO epo_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","kaj kia estas la tero, ĉu ĝi estas grasa aŭ malgrasa, ĉu estas sur ĝi arboj aŭ ne estas; kaj estu kuraĝaj, kaj prenu iom el la fruktoj de la lando. Kaj tiam estis la tempo de maturiĝado de vinberoj. ");
INSERT INTO epo_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kaj ili iris kaj esplorrigardis la landon de la dezerto Cin ĝis Reĥob antaŭ Ĥamat. ");
INSERT INTO epo_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Kaj ili iris tra la Sudo, kaj venis ĝis Ĥebron, kie loĝis Aĥiman, Ŝeŝaj, kaj Talmaj, idoj de Anak. (Ĥebron estis konstruita sep jarojn antaŭ ol Coan de Egiptujo.) ");
INSERT INTO epo_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kaj ili venis ĝis la valo Eŝkol, kaj ili detranĉis tie branĉon kun unu peniko da vinberoj, kaj ili ekportis ĝin sur stango duope; ankaŭ iom da granatoj kaj da figoj. ");
INSERT INTO epo_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Al tiu loko oni donis la nomon Eŝkol, pro la peniko da vinberoj, kiun detranĉis tie la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kaj ili revenis post la esplorrigardo de la lando post kvardek tagoj. ");
INSERT INTO epo_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Kaj ili iris kaj venis al Moseo kaj al Aaron kaj al la tuta komunumo de la Izraelidoj en la dezerton Paran, en la lokon Kadeŝ, kaj donis al ili raporton kaj al la tuta komunumo kaj montris al ili la fruktojn de la lando. ");
INSERT INTO epo_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kaj ili rakontis al li, kaj diris: Ni venis en la landon, en kiun vi sendis nin, kaj efektive en ĝi fluas lakto kaj mielo, kaj jen estas ĝiaj fruktoj; ");
INSERT INTO epo_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","sed forta estas la popolo, kiu loĝas en la lando, kaj la urboj estas fortikigitaj, tre grandaj; kaj ankaŭ la idojn de Anak ni vidis tie. ");
INSERT INTO epo_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek loĝas en la suda parto de la lando, kaj la Ĥetidoj kaj Jebusidoj kaj Amoridoj loĝas sur la monto, kaj la Kanaanidoj loĝas apud la maro kaj sur la bordo de Jordan. ");
INSERT INTO epo_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaj Kaleb trankviligis la popolon antaŭ Moseo, kaj diris: Ni iros, kaj ni ekposedos ĝin, ĉar ni povas ĝin venki. ");
INSERT INTO epo_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Sed la viroj, kiuj iris kun li, diris: Ni ne povas iri al tiu popolo, ĉar ĝi estas pli forta ol ni. ");
INSERT INTO epo_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kaj pri la lando, kiun ili esplorrigardis, ili disvastigis inter la Izraelidoj malbonan famon, dirante: La lando, kiun ni trapasis por esplorrigardi ĝin, estas lando, kiu formanĝas siajn loĝantojn, kaj la tuta popolo, kiun ni vidis en ĝi, estas homoj grandkreskaj; ");
INSERT INTO epo_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","kaj tie ni vidis la gigantojn, la idojn de Anak el la gigantoj, kaj ni estis en niaj okuloj kiel lokustoj, kaj tiaj ni estis ankaŭ en iliaj okuloj. ");
INSERT INTO epo_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tiam tumultiĝis la tuta komunumo kaj ekkriis, kaj la popolo ploris en tiu nokto. ");
INSERT INTO epo_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Kaj ekmurmuris kontraŭ Moseo kaj kontraŭ Aaron ĉiuj Izraelidoj, kaj la tuta komunumo diris al ili: Ho, se ni estus mortintaj en la lando Egipta, aŭ se ni mortus en ĉi tiu dezerto! ");
INSERT INTO epo_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Kaj por kio la Eternulo irigas nin en tiun landon, por ke ni falu de glavo? niaj edzinoj kaj infanoj fariĝos militakiro. Ĉu ne estas pli bone, ke ni revenu Egiptujon? ");
INSERT INTO epo_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Kaj ili diris unu al alia: Ni starigu al ni estron, kaj ni reiru Egiptujon. ");
INSERT INTO epo_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tiam Moseo kaj Aaron ĵetiĝis vizaĝaltere antaŭ la tuta anaro de la komunumo de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Kaj Josuo, filo de Nun, kaj Kaleb, filo de Jefune, el tiuj, kiuj esplorrigardis la landon, disŝiris siajn vestojn, ");
INSERT INTO epo_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","kaj ili diris al la tuta komunumo de la Izraelidoj jene: La lando, kiun ni trapasis, por esplorrigardi ĝin, tiu lando estas tre, tre bona. ");
INSERT INTO epo_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Se la Eternulo estos favorkora al ni, Li venigos nin en tiun landon kaj donos ĝin al ni, tiun landon, en kiu fluas lakto kaj mielo. ");
INSERT INTO epo_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nur ne ribelu kontraŭ la Eternulo, kaj ne timu la popolon de la lando, ĉar nia manĝotaĵo ili estas; ilia ŝirmo foriĝis de ili, kaj la Eternulo estas kun ni; ne timu ilin. ");
INSERT INTO epo_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Kaj la tuta komunumo diris, ke oni mortigu ilin per ŝtonoj. Sed la majesto de la Eternulo aperis en la tabernaklo de kunveno antaŭ ĉiuj Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Kaj la Eternulo diris al Moseo: Ĝis kiam incitados Min ĉi tiu popolo? kaj ĝis kiam ĝi ne kredos al Mi, malgraŭ ĉiuj pruvosignoj, kiujn Mi faris meze de ĝi? ");
INSERT INTO epo_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mi frapos ĝin per pesto kaj ekstermos ĝin, kaj Mi faros el vi popolon pli grandan kaj pli fortan ol ĝi. ");
INSERT INTO epo_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Sed Moseo diris al la Eternulo: Aŭdos la Egiptoj, el inter kiuj Vi elkondukis ĉi tiun popolon per Via forto, ");
INSERT INTO epo_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","kaj ili diros al la loĝantoj de tiu lando, kiuj aŭdis, ke Vi, la Eternulo, estas meze de ĉi tiu popolo, kaj ke Vi, la Eternulo, montris Vin al ili okulon kontraŭ okulo, kaj ke Via nubo staras super ili, kaj ke Vi iras antaŭ ili dum la tago en nuba kolono kaj dum la nokto en kolono fajra; ");
INSERT INTO epo_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","se Vi ekstermos ĉi tiun popolon kiel unu homon, tiam la popoloj, kiuj aŭdis la famon pri Vi, dirus: ");
INSERT INTO epo_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Ĉar la Eternulo ne povis venigi ĉi tiun popolon en la landon, pri kiu Li ĵuris al ili, tial Li buĉis ilin en la dezerto. ");
INSERT INTO epo_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nun montriĝu do granda la forto de mia Sinjoro, laŭ la parolo, kiun Vi diris: ");
INSERT INTO epo_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","La Eternulo estas longepacienca kaj multe favorkora; Li pardonas kulpon kaj krimon, sed antaŭ Li neniu estas senkulpa; Li punas la kulpon de patroj sur filoj kaj nepoj, en la tria kaj kvara generacioj. ");
INSERT INTO epo_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ho, pardonu la kulpon de ĉi tiu popolo laŭ Via granda favorkoreco kaj kiel Vi pardonadis al ĉi tiu popolo de Egiptujo ĝis nun. ");
INSERT INTO epo_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Kaj la Eternulo diris: Mi pardonis konforme al via diro; ");
INSERT INTO epo_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","sed kiel Mi vivas kaj kiel de la gloro de la Eternulo estas plena la tuta tero, ");
INSERT INTO epo_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ĉiuj homoj, kiuj vidis Mian gloron kaj Miajn pruvosignojn, kiujn Mi faris en Egiptujo kaj en la dezerto, kaj provis Min jam dek fojojn kaj ne aŭskultis Mian voĉon, ");
INSERT INTO epo_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ne vidos la landon, pri kiu Mi ĵuris al iliaj patroj, kaj ĉiuj, kiuj incitis Min, ne vidos ĝin. ");
INSERT INTO epo_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Sed Mian sklavon Kaleb, ĉar estis en li spirito alia kaj li estis obeema al Mi, lin Mi venigos en la landon, en kiun li iris, kaj lia idaro heredos ĝin. ");
INSERT INTO epo_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Sed la Amalekidoj kaj Kanaanidoj loĝas en la valo; morgaŭ turnu vin kaj ekiru en la dezerton sur la vojo al la Ruĝa Maro. ");
INSERT INTO epo_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Ĝis kiam ĉi tiu malbona komunumo murmuros kontraŭ Mi? la murmuradon de la Izraelidoj, kiun ili murmuras kontraŭ Mi, Mi aŭdis. ");
INSERT INTO epo_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Diru al ili: Kiel Mi vivas, diras la Eternulo, kiel vi parolis al Miaj oreloj, tiel Mi faros al vi: ");
INSERT INTO epo_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","en ĉi tiu dezerto falos viaj kadavroj, kaj el ĉiuj viaj kalkulitoj, laŭ via tuta kalkulo, en la aĝo de dudek jaroj kaj pli, kiuj murmuris kontraŭ Mi, ");
INSERT INTO epo_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","neniu venos en la landon, pri kiu Mi levis Mian manon, ke Mi loĝigos vin en ĝi, neniu krom Kaleb, filo de Jefune, kaj Josuo, filo de Nun. ");
INSERT INTO epo_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Viajn infanojn, pri kiuj vi diris, ke ili fariĝos militakiro, Mi venigos tien, kaj ili ekkonos la landon, kiun vi malŝatis. ");
INSERT INTO epo_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Sed vi — viaj kadavroj falos en ĉi tiu dezerto. ");
INSERT INTO epo_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Kaj viaj filoj estos paŝtistoj en la dezerto dum kvardek jaroj, kaj portos vian malĉastecon, ĝis kiam viaj kadavroj konsumiĝos en la dezerto. ");
INSERT INTO epo_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Laŭ la nombro de la tagoj, dum kiuj vi esplorrigardis la landon, kvardek tagoj, po jaro pro ĉiu tago, vi portos la punon pro via malbonago dum kvardek jaroj, por ke vi ekkonu Mian malfavoron. ");
INSERT INTO epo_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mi, la Eternulo, tion diris: tion Mi faros al tiu tuta malbona komunumo, kiu ribelis kontraŭ Mi; en ĉi tiu dezerto ili pereos kaj ĉi tie ili mortos. ");
INSERT INTO epo_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Kaj la viroj, kiujn Moseo sendis, por esplorrigardi la landon, kaj kiuj revenis kaj murmurigis kontraŭ li la tutan komunumon, disvastigante malbonan famon pri la lando — ");
INSERT INTO epo_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","tiuj viroj, kiuj disvastigis malbonan famon pri la lando, mortis de pesto antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Sed Josuo, filo de Nun, kaj Kaleb, filo de Jefune, restis vivaj el tiuj viroj, kiuj iris, por esplorrigardi la landon. ");
INSERT INTO epo_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kaj Moseo diris tiujn vortojn al ĉiuj Izraelidoj, kaj la popolo tre malĝojis. ");
INSERT INTO epo_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kaj ili leviĝis frumatene, kaj iris sur la supron de la monto, dirante: Jen ni estas, kaj ni iru sur la lokon, pri kiu parolis la Eternulo; ĉar ni pekis. ");
INSERT INTO epo_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Sed Moseo diris: Por kio vi kontraŭagas al la vortoj de la Eternulo? tio ja ne sukcesos. ");
INSERT INTO epo_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne iru, ĉar la Eternulo ne estas inter vi; kaj ne estu frapataj antaŭ viaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ĉar la Amalekidoj kaj la Kanaanidoj estas tie antaŭ vi, kaj vi falos de glavo; ĉar pro tio, ke vi deturniĝis de la Eternulo, la Eternulo ne estos kun vi. ");
INSERT INTO epo_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Sed ili obstinis, kaj iris sur la supron de la monto; tamen la kesto de la interligo de la Eternulo kaj Moseo ne eliris el la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Kaj malsupreniris la Amalekidoj kaj la Kanaanidoj, kiuj loĝis sur la monto, kaj batis ilin kaj persekutis ilin ĝis Ĥorma. ");
INSERT INTO epo_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Parolu al la Izraelidoj, kaj diru al ili: Kiam vi venos en la landon de via loĝado, kiun Mi donas al vi, ");
INSERT INTO epo_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kaj vi faros fajroferon al la Eternulo, bruloferon aŭ buĉoferon, plenumante sanktan promeson aŭ farante memvolan oferon, aŭ en viaj festoj, por fari agrablan odoraĵon al la Eternulo el grandaj brutoj aŭ el malgrandaj: ");
INSERT INTO epo_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","tiam la oferdonanto devas alporti al la Eternulo farunoferon el dekono de efo da delikata faruno, miksita kun kvarono de hino da oleo; ");
INSERT INTO epo_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","kaj da vino por verŝofero kvaronon de hino aldonu al la brulofero aŭ al la buĉofero al ĉiu ŝafido. ");
INSERT INTO epo_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kaj ĉe ŝafo alportu farunoferon el du dekonoj de efo da delikata faruno, miksita kun triono de hino da oleo. ");
INSERT INTO epo_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Kaj da vino por verŝofero trionon de hino; alportu tion kiel agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kaj se bovidon vi alportos kiel bruloferon aŭ buĉoferon, por plenumi sanktan promeson, aŭ kiel pacoferon al la Eternulo, ");
INSERT INTO epo_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","tiam kun la bovido oni devas alporti farunoferon el tri dekonoj de efo da delikata faruno, miksita kun duono de hino da oleo; ");
INSERT INTO epo_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","kaj da vino por verŝofero alportu duonon de hino kiel fajroferon, agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tiel oni devas fari ĉe ĉiu bovo aŭ ĉe ĉiu ŝafo aŭ ĉe brutido el ŝafoj aŭ kaproj. ");
INSERT INTO epo_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Laŭ la nombro de la oferoj, kiujn vi faros, agu tiel ĉe ĉiu, laŭ ilia nombro. ");
INSERT INTO epo_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Ĉiu indiĝeno faru tion tiamaniere, alportante fajroferon, agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kaj se loĝas inter vi fremdulo aŭ kiu ajn estas inter vi en viaj generacioj, kaj li alportos fajroferon, agrablan odoraĵon al la Eternulo, tiam li faru tiel, kiel vi faras. ");
INSERT INTO epo_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Por la tuta komunumo devas esti unu leĝo, por vi kaj por la fremdulo inter vi; leĝo eterna en viaj generacioj, kiel por vi, tiel ankaŭ por la fremdulo, estu antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Unu leĝo kaj unu rajto estu por vi, kaj por la fremdulo, kiu loĝas kun vi. ");
INSERT INTO epo_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Parolu al la Izraelidoj, kaj diru al ili: Kiam vi venos en la landon, en kiun Mi vin kondukas, ");
INSERT INTO epo_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kaj vi manĝos la panon de tiu lando, tiam donu oferdonon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Kiel unuaaĵon el via pasto alportu oferdone kukon; kiel oferdonon el la grenejo, tiel oferdonu ĝin. ");
INSERT INTO epo_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","El la unuaaĵoj de via pasto donu al la Eternulo oferdonon en viaj generacioj. ");
INSERT INTO epo_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Kaj se vi eraros, kaj ne plenumos ĉiujn tiujn ordonojn, kiujn la Eternulo diris al Moseo, ");
INSERT INTO epo_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ĉion, kion la Eternulo ordonis al vi per Moseo, de la tago, en kiu la Eternulo ordonis, kaj plue, en viaj generacioj; ");
INSERT INTO epo_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","tiam se pro neatento de la komunumo estis farita la eraro, la tuta komunumo alportu unu bovidon kiel bruloferon, kiel agrablan odoraĵon al la Eternulo, kun ĝia farunofero kaj ĝia verŝofero laŭ la regularo, kaj unu kapron kiel pekoferon. ");
INSERT INTO epo_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kaj la pastro pekliberigos la tutan komunumon de la Izraelidoj, kaj estos pardonite al ili; ĉar tio estis eraro, kaj ili alportis sian oferon, fajroferon al la Eternulo, kaj sian pekoferon antaŭ la Eternulo pro sia peko. ");
INSERT INTO epo_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Kaj estos pardonite al la tuta komunumo de la Izraelidoj, kaj al la fremdulo, kiu loĝas inter ili; ĉar la tuta popolo eraris. ");
INSERT INTO epo_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kaj se unu homo pekos per eraro, tiam li alportu kaprinon jaraĝan kiel pekoferon. ");
INSERT INTO epo_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kaj la pastro pekliberigos la homon, kiu eraris, pekante per eraro antaŭ la Eternulo; li pekliberigos lin, kaj estos pardonite al li. ");
INSERT INTO epo_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Kiel por la indiĝeno el la Izraelidoj, tiel ankaŭ por la fremdulo, kiu loĝas inter ili, unu leĝo estu por vi por tiu, kiu eraris. ");
INSERT INTO epo_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Sed se iu faris ion per mano malhumila, ĉu li estas indiĝeno, ĉu fremdulo, li blasfemis kontraŭ la Eternulo; kaj ekstermiĝos tiu homo el inter sia popolo; ");
INSERT INTO epo_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ĉar la vorton de la Eternulo li malestimis kaj Lian ordonon li malobeis; ekstermiĝu tiu homo, lia peko estas sur li. ");
INSERT INTO epo_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Kiam la Izraelidoj estis en la dezerto, ili trovis homon, kiu kolektis lignon en tago sabata. ");
INSERT INTO epo_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Kaj tiuj, kiuj trovis lin, kiam li kolektis lignon, alkondukis lin al Moseo kaj al Aaron kaj al la tuta komunumo. ");
INSERT INTO epo_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Kaj oni metis lin en gardejon, ĉar ne estis ankoraŭ klarigite, kion oni devas fari al li. ");
INSERT INTO epo_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Kaj la Eternulo diris al Moseo: Tiu homo mortu; per ŝtonoj mortigu lin la tuta komunumo ekster la tendaro. ");
INSERT INTO epo_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kaj la tuta komunumo elkondukis lin ekster la tendaron kaj mortigis lin per ŝtonoj, kaj li mortis; kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Kaj la Eternulo diris al Moseo jene: ");
INSERT INTO epo_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Parolu al la Izraelidoj, kaj diru al ili, ke ili faru al si kvastojn sur la randoj de siaj vestoj en siaj generacioj, kaj ili enmetu en la kvaston de la rando fadenon bluan. ");
INSERT INTO epo_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Kaj ĝi estu por vi kvasto, kiun rigardante, vi rememoros ĉiujn ordonojn de la Eternulo kaj plenumos ilin kaj ne iros laŭ viaj koroj kaj viaj okuloj, kiujn vi malĉaste sekvadas; ");
INSERT INTO epo_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","por ke vi memoru kaj plenumu ĉiujn Miajn ordonojn kaj estu sanktaj antaŭ via Dio. ");
INSERT INTO epo_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mi estas la Eternulo, via Dio, kiu elkondukis vin el la lando Egipta, por ke Mi estu via Dio. Mi estas la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kaj entreprenis Koraĥ, filo de Jichar, filo de Kehat, ido de Levi, kaj Datan kaj Abiram, filoj de Eliab, kaj On, filo de Pelet, idoj de Ruben, ");
INSERT INTO epo_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","kaj stariĝis antaŭ Moseo, kaj kun ili el la Izraelidoj ducent kvindek viroj, estroj de la komunumo, vokataj al la kunvenoj; homoj eminentaj; ");
INSERT INTO epo_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","kaj ili kolektiĝis kontraŭ Moseo kaj kontraŭ Aaron, kaj diris al ili: Sufiĉe por vi! la tuta komunumo, ĉiuj estas ja sanktaj, kaj inter ili estas la Eternulo; kial do vi estrigas vin super la komunumo de la Eternulo? ");
INSERT INTO epo_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kaj Moseo tion aŭdis, kaj ĵetis sin vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Kaj li ekparolis al Koraĥ kaj al lia tuta anaro, dirante: Morgaŭ la Eternulo montros, kiu estas Lia kaj kiu estas sankta, por ke Li alproksimigu lin al Si; kaj kiun Li elektos, tiun Li alproksimigos al Si. ");
INSERT INTO epo_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Faru jenon: prenu al vi incensujojn, Koraĥ kaj lia tuta anaro, ");
INSERT INTO epo_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","kaj metu sur ilin fajron kaj metu sur ilin incenson antaŭ la Eternulo morgaŭ; kaj kiun la Eternulo elektos, tiu estos la sanktulo. Estas troe, ho Levidoj! ");
INSERT INTO epo_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Kaj Moseo diris al Koraĥ: Aŭskultu do, idoj de Levi: ");
INSERT INTO epo_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ĉu ne sufiĉas al vi, ke la Dio de la Izraelidoj distingis vin inter la komunumo de Izrael, por alproksimigi vin al Si, por ke vi plenumu la servojn en la tabernaklo de la Eternulo kaj por ke vi staru antaŭ la komunumo, por servi al ĝi? ");
INSERT INTO epo_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kaj Li alproksimigos vin kaj ĉiujn viajn fratojn, la idojn de Levi, kun vi; kaj nun vi postulas eĉ pastrecon! ");
INSERT INTO epo_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Tiamaniere vi kaj via tuta anaro ekribelis kontraŭ la Eternulo; sed kio estas Aaron, ke vi murmuras kontraŭ li? ");
INSERT INTO epo_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kaj Moseo sendis voki Datanon kaj Abiramon, filojn de Eliab; sed ili diris: Ni ne iros! ");
INSERT INTO epo_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ĉu ne sufiĉas, ke el lando, en kiu fluas lakto kaj mielo, vi elirigis nin, por pereigi nin en la dezerto? kaj vi volas ankoraŭ regi super ni? ");
INSERT INTO epo_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ja ne en landon, en kiu fluas lakto kaj mielo, vi venigis nin, kaj vi ne donis al ni posedaĵon el kampoj kaj vinberĝardenoj! ĉu vi volas blindigi la okulojn de ĉi tiuj homoj? ni ne iros. ");
INSERT INTO epo_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Kaj tio tre kolerigis Moseon, kaj li diris al la Eternulo: Ne turnu Vin al ilia ofero; eĉ unu azenon mi ne prenis de ili, kaj al neniu el ili mi faris ian malbonon. ");
INSERT INTO epo_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Kaj Moseo diris al Koraĥ: Vi kaj via tuta anaro estu antaŭ la Eternulo morgaŭ, vi kaj ili kaj Aaron. ");
INSERT INTO epo_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kaj prenu ĉiu sian incensujon kaj metu sur ĝin incenson, kaj alportu antaŭ la Eternulon ĉiu sian incensujon, ducent kvindek incensujojn; ankaŭ vi kaj Aaron, ĉiu sian incensujon. ");
INSERT INTO epo_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kaj ili prenis ĉiu sian incensujon kaj metis sur ĝin fajron kaj ŝutis sur ĝin incenson, kaj ili stariĝis ĉe la pordo de la tabernaklo de kunveno, ankaŭ Moseo kaj Aaron. ");
INSERT INTO epo_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kaj kunvenigis kontraŭ ili Koraĥ la tutan anaron ĉe la pordo de la tabernaklo de kunveno; kaj montriĝis la majesto de la Eternulo al la tuta komunumo. ");
INSERT INTO epo_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Apartiĝu de ĉi tiu anaro, kaj Mi ekstermos ilin en momento. ");
INSERT INTO epo_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Kaj ili ĵetis sin vizaĝaltere, kaj diris: Ho Dio, Dio de la spiritoj de ĉia karno! unu pekis, kaj Vi volas koleri la tutan komunumon? ");
INSERT INTO epo_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Diru al la komunumo jene: Foriru de ĉirkaŭ la loĝejo de Koraĥ, Datan, kaj Abiram. ");
INSERT INTO epo_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Kaj Moseo leviĝis kaj iris al Datan kaj Abiram, kaj post li iris la plejaĝuloj de Izrael. ");
INSERT INTO epo_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kaj li diris al la komunumo: Foriru do de la tendoj de tiuj malbonaj homoj, kaj tuŝu nenion, kio apartenas al ili, por ke vi ne pereu pro ĉiuj iliaj pekoj. ");
INSERT INTO epo_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kaj ili foriris de ĉirkaŭ la loĝejo de Koraĥ, Datan, kaj Abiram; sed Datan kaj Abiram eliris, kaj staris ĉe la pordo de siaj tendoj kune kun siaj edzinoj, filoj, kaj malgrandaj infanoj. ");
INSERT INTO epo_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Kaj Moseo diris: Per tio vi ekscios, ke la Eternulo sendis min, por fari ĉiujn tiujn aferojn, kaj ke mi ne faris laŭ mia koro: ");
INSERT INTO epo_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","se per la ordinara morto de ĉiuj homoj mortos ĉi tiuj, aŭ ilin trafos la sorto, kiu povas trafi ĉiun homon, tiam ne la Eternulo sendis min. ");
INSERT INTO epo_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Sed se novan aperon kreos la Eternulo, kaj la tero malfermos sian buŝon, kaj englutos ilin, kaj ĉion, kio apartenas al ili, kaj ili vivaj malsupreniros en Ŝeolon, tiam sciu, ke ĉi tiuj homoj blasfemis kontraŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Apenaŭ li finis paroli ĉion tion, disfendiĝis la tero, kiu estis sub ili; ");
INSERT INTO epo_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","kaj la tero malfermis sian buŝon kaj englutis ilin kaj iliajn domojn kaj ĉiujn homojn de Koraĥ kaj la tutan havon. ");
INSERT INTO epo_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Kaj ili, kaj ĉio, kio apartenis al ili, malsupreniris vivaj en Ŝeolon, kaj fermiĝis super ili la tero, kaj ili forpereis el inter la komunumo. ");
INSERT INTO epo_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Kaj ĉiuj Izraelidoj, kiuj estis ĉirkaŭ ili, forkuris ĉe ilia krio; ĉar ili diris: Ke nin ankaŭ la tero ne englutu. ");
INSERT INTO epo_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Kaj fajro eliris de la Eternulo, kaj ĝi forbruligis tiujn ducent kvindek homojn, kiuj alportis la incenson. ");
INSERT INTO epo_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Diru al Eleazar, filo de la pastro Aaron, ke li levu la incensujojn el la brulintaĵo, sed la fajron disĵetu malproksimen; ĉar sanktiĝis ");
INSERT INTO epo_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","la incensujoj de tiuj, kiuj per sia vivo pagis pro la peko; kaj oni faru el ili tavoletojn, por tegi la altaron; ĉar oni alportis ilin antaŭ la Eternulon, kaj ili sanktiĝis; kaj ili estu memoriga signo por la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Kaj Eleazar, la pastro, prenis la kuprajn incensujojn, kiujn alportis la bruligitaj, kaj tavoligis ilin, por tegi la altaron ");
INSERT INTO epo_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","memorige por la Izraelidoj, ke laiko, kiu ne estas el la idoj de Aaron, ne alproksimiĝu, por incensi antaŭ la Eternulo, por ke li ne fariĝu kiel Koraĥ kaj lia anaro, kiel diris la Eternulo al li per Moseo. ");
INSERT INTO epo_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Kaj en la sekvanta tago la tuta komunumo de la Izraelidoj ekmurmuris kontraŭ Moseo kaj kontraŭ Aaron, dirante: Vi mortigis la popolon de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Kaj kiam kolektiĝis la komunumo kontraŭ Moseo kaj kontraŭ Aaron, ili turniĝis al la tabernaklo de kunveno; kaj jen kovris ĝin la nubo kaj aperis la majesto de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Kaj eniris Moseo kaj Aaron en la antaŭan parton de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Foriĝu el inter ĉi tiu komunumo, kaj Mi pereigos ilin en momento. Sed ili ĵetiĝis vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kaj Moseo diris al Aaron: Prenu vian incensujon kaj metu sur ĝin fajron de la altaro kaj ŝutu sur ĝin incenson kaj iru rapide al la komunumo kaj pekliberigu ĝin; ĉar eliris kolero de antaŭ la Eternulo, komenciĝis la frapado. ");
INSERT INTO epo_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Tiam Aaron prenis, kiel diris Moseo, kaj kuris en la mezon de la komunumo; kaj jen komenciĝis jam la frapado en la popolo. Kaj li metis la incenson kaj pekliberigis la popolon. ");
INSERT INTO epo_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Li stariĝis inter la mortintoj kaj la vivantoj, kaj la frapado ĉesiĝis. ");
INSERT INTO epo_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Kaj la nombro de la mortintoj de la frapado estis dek kvar mil sepcent, krom tiuj, kiuj mortis pro Koraĥ. ");
INSERT INTO epo_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Kaj Aaron revenis al Moseo al la pordo de la tabernaklo de kunveno; kaj la frapado ĉesiĝis. ");
INSERT INTO epo_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Parolu al la Izraelidoj, kaj prenu de ili po unu bastono de ĉiu tribo, de ĉiuj iliaj triboj dek du bastonojn, kaj ĉies nomon skribu sur lia bastono. ");
INSERT INTO epo_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Sed la nomon de Aaron skribu sur la bastono de Levi; ĉar unu bastono devas esti de la estro de ilia tribo. ");
INSERT INTO epo_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Kaj kuŝigu ilin en la tabernaklo de kunveno antaŭ la kesto de atesto, kie Mi aperas al vi. ");
INSERT INTO epo_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kaj kiun viron Mi elektos, ties bastono ekfloros; kaj tiel Mi silentigos antaŭ Mi la murmuradon de la Izraelidoj, kiun ili murmuras kontraŭ vi. ");
INSERT INTO epo_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Kaj Moseo parolis al la Izraelidoj, kaj ĉiuj iliaj estroj donis al li po unu bastono de ĉiu tribo, laŭ iliaj triboj dek du bastonojn; kaj la bastono de Aaron estis inter iliaj bastonoj. ");
INSERT INTO epo_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Kaj Moseo kuŝigis la bastonojn antaŭ la Eternulo en la tabernaklo de atesto. ");
INSERT INTO epo_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Kaj en la sekvanta tago Moseo venis en la tabernaklon de atesto; kaj jen ekfloris la bastono de Aaron de la domo de Levi, kaj ĝi elirigis burĝonojn kaj donis florojn kaj maturigis migdalojn. ");
INSERT INTO epo_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Kaj Moseo elportis ĉiujn bastonojn de antaŭ la Eternulo al ĉiuj Izraelidoj; kaj ili vidis, kaj ĉiu prenis sian bastonon. ");
INSERT INTO epo_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Kaj la Eternulo diris al Moseo: Remetu la bastonon de Aaron antaŭ la keston de atesto, por ke ĝi estu gardata kiel memorsigno por la ribelemuloj, por ke ĉesiĝu ilia murmurado kontraŭ Mi, kaj por ke ili ne mortu. ");
INSERT INTO epo_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Kaj Moseo faris tion; kiel la Eternulo ordonis al li, tiel li faris. ");
INSERT INTO epo_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Kaj la Izraelidoj diris al Moseo: Jen ni mortas, ni pereas, ni ĉiuj pereas; ");
INSERT INTO epo_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ĉiu, kiu alproksimiĝas al la tabernaklo de la Eternulo, mortas; ĉu ni ĉiuj mortos? ");
INSERT INTO epo_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Kaj la Eternulo diris al Aaron: Vi kaj viaj filoj kaj la domo de via patro kune kun vi portos sur vi la kulpon pri la tabernaklo, kaj vi kaj viaj filoj kune kun vi portos la kulpon pri via pastrado. ");
INSERT INTO epo_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ankaŭ viajn fratojn, la tribon de Levi, la genton de via patro, alproksimigu al vi; ili aliĝu al vi kaj servu vin; kaj vi kune kun viaj filoj estos ĉe la tabernaklo de atesto. ");
INSERT INTO epo_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Kaj ili prizorgu la gardadon de vi kaj la gardadon de la tuta tabernaklo; nur al la objektoj de la sanktejo kaj al la altaro ili ne alproksimiĝu, por ke ili ne mortu, kiel ili, tiel ankaŭ vi. ");
INSERT INTO epo_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ili aliĝu al vi kaj plenumu la zorgadon pri la tabernaklo de kunveno, koncerne ĉiujn servojn en la tabernaklo; sed laiko ne alproksimiĝu al vi. ");
INSERT INTO epo_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Kaj plenumu la zorgadon pri la sanktejo kaj la zorgadon pri la altaro, por ke ne estu plu kolero kontraŭ la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Kaj Mi prenis viajn fratojn, la Levidojn, el inter la Izraelidoj; donace al vi ili estas donitaj por la Eternulo, por plenumi la servojn en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Kaj vi kune kun viaj filoj plenumu vian pastradon en ĉio, kio koncernas la altaron, kaj tion, kio estas malantaŭ la kurteno, kaj servu; kiel donacon Mi donas al vi la servadon de via pastrado; sed laiko, kiu alproksimiĝos, estu mortigita. ");
INSERT INTO epo_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Kaj la Eternulo diris al Aaron: Mi donis al vi la zorgadon pri Miaj oferdonoj: ĉion, kion konsekras la Izraelidoj, Mi donis al vi kaj al viaj filoj, kiel sanktan apartenaĵon per leĝo eterna. ");
INSERT INTO epo_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Jen kio apartenas al vi el la plejsanktaĵoj, el la bruligataĵo: ĉiu ilia ofero, kiel ĉiu ilia farunofero, tiel ankaŭ ĉiu ilia pekofero kaj ĉiu ilia kulpofero, kiun ili donos al Mi, estas plejsanktaĵo por vi kaj por viaj filoj. ");
INSERT INTO epo_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Sur la plej sankta loko manĝu tion; ĉiu virseksulo povas tion manĝi. Sankta ĝi estu por vi. ");
INSERT INTO epo_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Kaj jen kio apartenas al vi: iliaj donacataj oferdonoj el ĉiuj skuoferoj de la Izraelidoj; al vi Mi donis ilin kaj al viaj filoj kaj al viaj filinoj kune kun vi, per leĝo eterna; ĉiu pura en via domo povas tion manĝi. ");
INSERT INTO epo_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ĉion plej bonan el oleo kaj ĉion plej bonan el mosto kaj el greno, iliajn unuaaĵojn, kiujn ili donas al la Eternulo, Mi fordonis al vi. ");
INSERT INTO epo_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","La unuaj produktoj de ĉio, kio estas sur ilia tero, kiujn ili alportos al la Eternulo, apartenas al vi; ĉiu pura en via domo povas tion manĝi. ");
INSERT INTO epo_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Ĉio, kio estas konsekrita en Izrael, apartenas al vi. ");
INSERT INTO epo_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Ĉiu utermalferminto el ĉiuj vivaj estaĵoj, kiun ili alportas al la Eternulo, kiel el homoj, tiel ankaŭ el brutoj, apartenas al vi; tamen prenu elaĉeton pro unuenaskito el homoj, kaj ankaŭ pro unuenaskito el malpuraj brutoj prenu elaĉeton. ");
INSERT INTO epo_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ilia elaĉeto estas: post la aĝo de unu monato prenu elaĉeton laŭ via takso, kvin siklojn da arĝento laŭ la sankta siklo, kiu konsistas el dudek geroj. ");
INSERT INTO epo_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Nur pro unuenaskito el bovoj aŭ pro unuenaskito el ŝafoj aŭ pro unuenaskito el kaproj ne prenu elaĉeton: ili estas sanktaĵo; per ilia sango aspergu la altaron, kaj ilian sebon bruligu kiel fajroferon, agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Sed ilia viando apartenas al vi; kiel la brustaĵo de skuofero kaj la dekstra femuro, ĝi apartenas al vi. ");
INSERT INTO epo_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ĉiujn sanktajn oferdonojn, kiujn alportas la Izraelidoj al la Eternulo, Mi donis al vi kaj al viaj filoj kaj al viaj filinoj kune kun vi, per leĝo eterna. Tio estas interligo de salo por eterne antaŭ la Eternulo por vi kaj por via idaro kune kun vi. ");
INSERT INTO epo_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Kaj la Eternulo diris al Aaron: En ilia tero vi ne havos heredaĵon, kaj parton vi ne havos inter ili; Mi estas via parto kaj via heredaĵo meze de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Kaj al la filoj de Levi Mi donis kiel heredaĵon dekonaĵon de ĉio en Izrael, rekompence pro ilia servado, kiun ili faras, la servado en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kaj la Izraelidoj ne alproksimiĝu plu al la tabernaklo de kunveno, por ke ili ne portu pekon kaj ne mortu. ");
INSERT INTO epo_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Nur la Levidoj mem plenumu la servadon en la tabernaklo de kunveno kaj portu sur si ilian pekon; leĝo eterna tio estu en viaj generacioj; kaj inter la Izraelidoj ili ne havos posedaĵon. ");
INSERT INTO epo_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ĉar la dekonaĵon de la Izraelidoj, kiun ili alportos al la Eternulo oferdone, Mi donis al la Levidoj kiel posedaĵon; tial Mi diris al ili, ke inter la Izraelidoj ili ne havu posedaĵon. ");
INSERT INTO epo_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Al la Levidoj parolu, kaj diru al ili: Kiam vi prenos de la Izraelidoj la dekonaĵon, kiun Mi donas al vi de ili kiel posedaĵon, tiam levu el ĝi oferdonon por la Eternulo, dekonaĵon el la dekonaĵo. ");
INSERT INTO epo_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Kaj estos kalkulata al vi via oferdono, kiel greno el la garbejo kaj kiel abundaĵo el la vinpremejo. ");
INSERT INTO epo_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tiamaniere vi ankaŭ alportos oferdonon al la Eternulo el ĉiuj viaj dekonaĵoj, kiujn vi prenos de la Izraelidoj; kaj vi donos el ili la oferdonon, destinitan por la Eternulo, al la pastro Aaron. ");
INSERT INTO epo_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","El ĉiuj ricevataj donacoj alportu oferdonon al la Eternulo, el ĉio plej bona en ĝi ĝian parton konsekritan. ");
INSERT INTO epo_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Kaj diru al ili: Kiam vi alportos el tio la plej bonan parton, tiam ĝi estos kalkulata al la Levidoj kiel enspezo el la garbejo kaj kiel enspezo el la vinpremejo. ");
INSERT INTO epo_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Kaj vi povas tion manĝi sur ĉiu loko, vi kaj via domo; ĉar tio estas pago al vi pro via servado en la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kaj vi ne portos pri tio pekon, kiam vi alportos la plej bonan parton el tio; kaj vi ne malsanktigos la konsekritaĵon de la Izraelidoj, kaj vi ne mortos. ");
INSERT INTO epo_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Kaj la Eternulo ekparolis al Moseo kaj al Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Jen estas la instrukcio de la leĝo, kiun la Eternulo starigis, dirante: Diru al la Izraelidoj, ke ili venigu al vi bovinon ruĝan, sanan, kiu ne havas difekton kaj sur kiun ne estis metita jugo. ");
INSERT INTO epo_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Kaj donu ĝin al Eleazar, la pastro, kaj li elkonduku ĝin ekster la tendaron, kaj oni buĉu ĝin antaŭ li. ");
INSERT INTO epo_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kaj Eleazar, la pastro, prenu iom el ĝia sango per sia fingro kaj aspergu sep fojojn per ĝia sango en la direkto al la antaŭa parto de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kaj oni forbruligu la bovinon antaŭ liaj okuloj: ĝian felon kaj ĝian karnon kaj ĝian sangon kune kun ĝia sterko oni forbruligu. ");
INSERT INTO epo_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kaj la pastro prenu cedran lignon kaj hisopon kaj ruĝan lanon kaj ĵetu en la brulaĵon de la bovino. ");
INSERT INTO epo_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kaj la pastro lavu siajn vestojn kaj banu sian korpon en akvo, kaj poste li venu en la tendaron, kaj la pastro restos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Kaj tiu, kiu ĝin forbruligis, lavu siajn vestojn per akvo kaj banu sian korpon en akvo, kaj li restos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Kaj viro pura kolektu la cindron de la bovino kaj metu ĝin ekster la tendaro sur puran lokon, kaj ĝi estos konservata por la komunumo de la Izraelidoj por la akvo puriga: tio estas ofero propeka. ");
INSERT INTO epo_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Kaj la kolektinto de la cindro de la bovino lavu siajn vestojn, kaj li restos malpura ĝis la vespero. Tio estos leĝo eterna por la Izraelidoj, kaj por la fremduloj, kiuj loĝas inter ili. ");
INSERT INTO epo_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Kiu ektuŝis la kadavron de ia homo, tiu restos malpura dum sep tagoj; ");
INSERT INTO epo_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","li senpekigos sin per ĝi en la tria tago kaj en la sepa tago, kaj li fariĝos pura; kaj se li ne senpekigos sin en la tria tago kaj en la sepa tago, li ne fariĝos pura. ");
INSERT INTO epo_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ĉiu, kiu ektuŝis la kadavron de homo, kiu mortis, kaj ne senpekigos sin, tiu malpurigas la loĝejon de la Eternulo; kaj tiu homo ekstermiĝos el inter Izrael; ĉar li ne estas aspergita per puriga akvo, li estas malpura, lia malpureco estas ankoraŭ sur li. ");
INSERT INTO epo_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Jen estas la leĝo: se homo mortis en tendo, tiam ĉiu, kiu venas en la tendon, kaj ĉio, kio troviĝas en la tendo, estos malpura dum sep tagoj. ");
INSERT INTO epo_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Kaj ĉiu nefermita vazo, sur kiu ne estas kovrilo kun ŝnureto, estas malpura. ");
INSERT INTO epo_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Kaj ĉiu, kiu ektuŝis sur kampo glavmortigiton aŭ mortinton aŭ oston de homo aŭ tombon, estos malpura dum sep tagoj. ");
INSERT INTO epo_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Oni prenu por la malpurulo iom el la cindro de la bruligita pekofero kaj verŝu sur ĝin akvon vivan en vazon; ");
INSERT INTO epo_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","kaj viro pura prenu hisopon kaj trempu ĝin en akvo, kaj aspergu la tendon kaj ĉiujn vazojn, kaj la homojn, kiuj tie estis, kaj la tuŝinton de la osto aŭ de la mortigito aŭ de la mortinto aŭ de la tombo. ");
INSERT INTO epo_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Kaj la purulo aspergu la malpurulon en la tria tago kaj en la sepa tago kaj senpekigu lin en la sepa tago; kaj li lavu siajn vestojn kaj banu sin en akvo, kaj vespere li estos pura. ");
INSERT INTO epo_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Kaj se iu estos malpura kaj ne senpekigos sin, tiu ekstermiĝos el inter la komunumo, ĉar li malpurigis la sanktejon de la Eternulo: li ne estas aspergita per puriga akvo, li estas malpura. ");
INSERT INTO epo_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kaj tio estu por vi leĝo eterna. Kaj tiu, kiu aspergis per la puriga akvo, lavu siajn vestojn; kaj la ektuŝinto de la puriga akvo estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kaj ĉio, kion ektuŝos la malpurulo, estos malpura; kaj la homo, kiu ektuŝis, estos malpura ĝis la vespero. ");
INSERT INTO epo_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Kaj venis la Izraelidoj, la tuta komunumo, en la dezerton Cin en la unua monato; kaj la popolo ekloĝis en Kadeŝ, kaj tie mortis Mirjam kaj estis tie enterigita. ");
INSERT INTO epo_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Kaj ne estis akvo por la komunumo, kaj ili kolektiĝis kontraŭ Moseo kaj Aaron. ");
INSERT INTO epo_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kaj la popolo malpacis kontraŭ Moseo, kaj ili diris jene: Ho, kial ni ne mortis tiam, kiam mortis niaj fratoj antaŭ la Eternulo! ");
INSERT INTO epo_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Kaj kial vi venigis la komunumon de la Eternulo en ĉi tiun dezerton, por ke ni mortu ĉi tie kune kun niaj brutoj? ");
INSERT INTO epo_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kaj por kio vi elirigis nin el Egiptujo, por venigi nin al ĉi tiu malbona loko, kie oni ne povas semi, kie ne ekzistas figarboj nek vinberoj nek granatoj, kaj kie ne ekzistas akvo por trinki? ");
INSERT INTO epo_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tiam Moseo kaj Aaron iris de antaŭ la komunumo al la pordo de la tabernaklo de kunveno kaj ĵetiĝis vizaĝaltere, kaj la majesto de la Eternulo aperis al ili. ");
INSERT INTO epo_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Prenu la bastonon kaj kunvenigu la komunumon, vi kaj via frato Aaron, kaj parolu antaŭ iliaj okuloj al la roko, kaj ĝi donos sian akvon; kaj vi elirigos por ili akvon el la roko, kaj vi trinkigos la komunumon kaj ĝiajn brutojn. ");
INSERT INTO epo_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Kaj Moseo prenis la bastonon de antaŭ la Eternulo, kiel Li ordonis al li. ");
INSERT INTO epo_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Kaj Moseo kaj Aaron kunvenigis la komunumon antaŭ la rokon, kaj li diris al ili: Aŭskultu, ho ribeluloj, ĉu el ĉi tiu roko ni elirigu por vi akvon? ");
INSERT INTO epo_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Kaj Moseo levis sian manon kaj frapis la rokon per sia bastono du fojojn; kaj ekfluis multe da akvo, kaj trinkis la komunumo kaj ĝiaj brutoj. ");
INSERT INTO epo_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tiam la Eternulo diris al Moseo kaj al Aaron: Pro tio, ke vi ne kredis je Mi, por montri Min sankta en la okuloj de la Izraelidoj, tial vi ne venigos ĉi tiun komunumon en la landon, kiun Mi donas al ili. ");
INSERT INTO epo_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Tio estas la Akvo de Malpaco, ĉe kiu la Izraelidoj malpacis kontraŭ la Eternulo kaj per kiu Li montris Sin sankta al ili. ");
INSERT INTO epo_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Kaj Moseo sendis senditojn el Kadeŝ al la reĝo de Edom, por diri: Tiel diras via frato Izrael: Vi scias ĉiujn malfacilaĵojn, kiuj trafis nin; ");
INSERT INTO epo_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","niaj patroj foriris en Egiptujon, kaj ni loĝis en Egiptujo longan tempon, kaj la Egiptoj agis malbone kontraŭ ni kaj kontraŭ niaj patroj; ");
INSERT INTO epo_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","kaj ni ekkriis al la Eternulo, kaj Li aŭdis nian voĉon, kaj Li sendis anĝelon kaj elkondukis nin el Egiptujo; kaj jen ni estas en Kadeŝ, urbo ĉe la fino de viaj limoj; ");
INSERT INTO epo_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","permesu do al ni trairi vian landon; ni ne iros tra kampo nek tra vinberĝardeno, kaj ni ne trinkos akvon el la putoj; laŭ la ĉefa publika vojo ni iros, ni ne flankiĝos dekstren nek maldekstren, ĝis ni trapasos viajn limojn. ");
INSERT INTO epo_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Sed Edom diris al li: Vi ne trapasos min, alie mi eliros kun glavo renkonte al vi. ");
INSERT INTO epo_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Kaj la Izraelidoj diris al li: Laŭ la granda vojo ni iros; kaj se ni trinkos vian akvon, mi kaj miaj brutoj, mi pagos pro ĝi; nenio pli, sole per miaj piedoj mi trairos. ");
INSERT INTO epo_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Sed li diris: Ne trairu. Kaj Edom elpaŝis kontraŭ lin kun popolo multenombra kaj kun mano forta. ");
INSERT INTO epo_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Kaj Edom ne volis permesi al Izrael trapasi liajn limojn; kaj Izrael iris flanke de li. ");
INSERT INTO epo_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kaj ili elmoviĝis el Kadeŝ; kaj la Izraelidoj, la tuta komunumo, venis al la monto Hor. ");
INSERT INTO epo_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Kaj la Eternulo ekparolis al Moseo kaj al Aaron sur la monto Hor, ĉe la limo de la lando Edoma, dirante: ");
INSERT INTO epo_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron alkolektiĝu al sia popolo; ĉar pro tio, ke vi malobeis Mian ordonon ĉe la Akvo de Malpaco, li ne venos en la landon, kiun Mi donas al la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prenu Aaronon, kaj Eleazaron, lian filon, kaj suririgu ilin sur la monton Hor; ");
INSERT INTO epo_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","kaj deprenu de Aaron liajn vestojn, kaj surmetu ilin sur Eleazaron, lian filon; kaj Aaron alkolektiĝu al sia popolo kaj mortu tie. ");
INSERT INTO epo_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Kaj Moseo faris, kiel ordonis la Eternulo; kaj ili suriris sur la monton Hor antaŭ la okuloj de la tuta komunumo. ");
INSERT INTO epo_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Kaj Moseo deprenis de Aaron liajn vestojn, kaj surmetis ilin sur Eleazaron, lian filon. Kaj Aaron mortis tie sur la supro de la monto. Kaj Moseo kaj Eleazar malsupreniris de la monto. ");
INSERT INTO epo_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Kaj la tuta komunumo vidis, ke Aaron mortis, kaj la tuta domo de Izrael priploris Aaronon dum tridek tagoj. ");
INSERT INTO epo_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kaj la Kanaanido, la reĝo de Arad, kiu loĝis en la Sudo, aŭdis, ke Izrael venas per la vojo de Atarim; kaj li ekbatalis kontraŭ Izrael kaj kaptis kelkajn kiel militkaptitojn. ");
INSERT INTO epo_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Tiam Izrael faris sanktan promeson al la Eternulo, kaj diris: Se Vi donos ĉi tiun popolon en mian manon, tiam mi detruos iliajn urbojn. ");
INSERT INTO epo_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Kaj la Eternulo elaŭskultis la voĉon de Izrael kaj fordonis la Kanaanidojn; kaj oni pereigis ilin kaj iliajn urbojn kaj donis al la loko la nomon Ĥorma. ");
INSERT INTO epo_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Kaj ili elmoviĝis de la monto Hor laŭ la vojo al la Ruĝa Maro, por ĉirkaŭiri la landon de Edom. Kaj senkuraĝiĝis la animo de la popolo sur la vojo. ");
INSERT INTO epo_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Kaj la popolo ekparolis kontraŭ Dio kaj kontraŭ Moseo: Kial vi elkondukis nin el Egiptujo, por ke ni mortu en la dezerto? ĉar ekzistas nek pano nek akvo, kaj al nia animo naŭzas la mizera nutraĵo. ");
INSERT INTO epo_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Tiam la Eternulo sendis sur la popolon venenajn serpentojn, kaj ili mordis la popolon, kaj mortis multe da homoj el Izrael. ");
INSERT INTO epo_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Kaj la popolo venis al Moseo, kaj diris: Ni pekis, parolante kontraŭ la Eternulo kaj kontraŭ vi; preĝu al la Eternulo, ke Li forigu de ni la serpentojn. Kaj Moseo preĝis pri la popolo. ");
INSERT INTO epo_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Kaj la Eternulo diris al Moseo: Faru al vi serpenton kupran kaj metu ĝin sur stangon; kaj ĉiu mordita, kiu ekrigardos ĝin, restos viva. ");
INSERT INTO epo_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Kaj Moseo faris kupran serpenton kaj metis ĝin sur stangon; kaj se serpento mordis iun kaj ĉi tiu ekrigardis la kupran serpenton, li restis viva. ");
INSERT INTO epo_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Kaj la Izraelidoj elmoviĝis, kaj starigis sian tendaron en Obot. ");
INSERT INTO epo_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kaj ili elmoviĝis el Obot, kaj starigis sian tendaron en Ije-Abarim en la dezerto, kiu estas kontraŭ Moab, en la oriento. ");
INSERT INTO epo_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De tie ili elmoviĝis, kaj starigis sian tendaron en la valo de Zared. ");
INSERT INTO epo_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De tie ili elmoviĝis, kaj starigis sian tendaron apud tiu parto de Arnon en la dezerto, kiu estas ekster la limoj de la Amoridoj; ĉar Arnon estas la limo de Moab, inter Moab kaj la Amoridoj. ");
INSERT INTO epo_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Tial estas dirite en la Libro de la Militoj de la Eternulo: Vaheb en Sufa, Kaj la valoj de Arnon, ");
INSERT INTO epo_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Kaj la deklivo de la valoj, Kiu turniĝas al la kolonio Ar Kaj apogiĝas al la limo de Moab. ");
INSERT INTO epo_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kaj de tie al Beer; tio estas tiu puto, pri kiu la Eternulo diris al Moseo: Kunvenigu la popolon, kaj Mi donos al ili akvon. ");
INSERT INTO epo_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tiam kantis Izrael ĉi tiun kanton: Leviĝu, puto, ni kantu pri ĝi; ");
INSERT INTO epo_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Puto, kiun fosis princoj, Boris eminentuloj de la popolo, Per la sceptro, per siaj bastonoj. Kaj el tiu dezerto al Matana, ");
INSERT INTO epo_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kaj el Matana al Naĥaliel, kaj el Naĥaliel al Bamot, ");
INSERT INTO epo_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","kaj el Bamot al la valo, kiu estas sur la kampo de Moab, ĉe la supro de Pisga, kiu estas turnita al la dezerto. ");
INSERT INTO epo_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Kaj Izrael sendis senditojn al Siĥon, reĝo de la Amoridoj, por diri: ");
INSERT INTO epo_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Mi dezirus trairi vian landon; ni ne devojiĝos sur kampon aŭ en vinberĝardenon, ni ne trinkos akvon el puto; laŭ la ĉefa publika vojo ni iros, ĝis ni trapasos viajn limojn. ");
INSERT INTO epo_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sed Siĥon ne permesis al Izrael trapasi liajn limojn; kaj Siĥon kolektis sian tutan popolon kaj eliris kontraŭ Izraelon en la dezerton kaj venis ĝis Jahac kaj ekbatalis kontraŭ Izrael. ");
INSERT INTO epo_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kaj Izrael frapis lin per la glavo, kaj ekposedis lian landon de Arnon ĝis Jabok, ĝis la Amonidoj; ĉar forta estis la limo de la Amonidoj. ");
INSERT INTO epo_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Kaj Izrael prenis ĉiujn tiujn urbojn; kaj Izrael ekloĝis en ĉiuj urboj de la Amoridoj, en Ĥeŝbon kaj en ĉiuj ĝiaj dependantaĵoj. ");
INSERT INTO epo_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ĉar Ĥeŝbon estis la urbo de Siĥon, la reĝo de la Amoridoj, kaj li militis kontraŭ la antaŭa reĝo de Moab kaj prenis el lia mano lian tutan landon ĝis Arnon. ");
INSERT INTO epo_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Tial diras alegoriistoj: Iru Ĥeŝbonon; Konstruiĝu kaj fortikiĝu la urbo de Siĥon. ");
INSERT INTO epo_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ĉar fajro eliris el Ĥeŝbon, Flamo el la urbo de Siĥon; Ĝi formanĝis Ar-Moabon, La mastrojn de la altaĵoj de Arnon. ");
INSERT INTO epo_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ve al vi, Moab! Vi pereis, ho popolo de Kemoŝ! Li faris el siaj filoj forkurintojn Kaj el siaj filinoj kaptitinojn De la reĝo de la Amoridoj Siĥon. ");
INSERT INTO epo_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ni faligis ilin; pereis Ĥeŝbon ĝis Dibon; Kaj ni ruinigis ilin ĝis Nofaĥ, Kiu estas apud Medba. ");
INSERT INTO epo_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Kaj Izrael loĝis en la lando de la Amoridoj. ");
INSERT INTO epo_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Kaj Moseo sendis, por esplorrigardi Jazeron, kaj ili militakiris ĝiajn vilaĝojn, kaj forpelis la Amoridojn, kiuj tie estis. ");
INSERT INTO epo_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Kaj ili forturniĝis kaj ekiris laŭ la vojo al Baŝan. Tiam eliris al ili renkonte Og, la reĝo de Baŝan, li kaj lia tuta popolo, por batali ĉe Edrei. ");
INSERT INTO epo_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Kaj la Eternulo diris al Moseo: Ne timu lin, ĉar en vian manon Mi fordonos lin kaj lian tutan popolon kaj lian landon, kaj vi agos kun li, kiel vi agis kun Siĥon, la reĝo de la Amoridoj, kiu loĝis en Ĥeŝbon. ");
INSERT INTO epo_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Kaj ili venkobatis lin kaj liajn filojn kaj lian tutan popolon, ĝis neniu restis; kaj ili ekposedis lian landon. ");
INSERT INTO epo_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Kaj la Izraelidoj elmoviĝis, kaj haltis tendare en la stepoj de Moab, transe de Jordan, kontraŭ Jeriĥo. ");
INSERT INTO epo_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, filo de Cipor, vidis ĉion, kion Izrael faris al la Amoridoj. ");
INSERT INTO epo_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Kaj Moab tre timis tiun popolon, ĉar ĝi estis multenombra; kaj Moab ektremis antaŭ la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Kaj Moab diris al la ĉefoj de Midjan: Nun tiu popolo formanĝos nian tutan ĉirkaŭaĵon, kiel bovo formanĝas la herbon de la kampo. Kaj Balak, filo de Cipor, estis reĝo de Moab en tiu tempo. ");
INSERT INTO epo_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Kaj li sendis senditojn al Bileam, filo de Beor, en Petoron, kiu estis ĉe la Rivero, en la landon de sia popolo, por voki lin, kaj diri: Jen popolo eliris el Egiptujo, jen ĝi kovris la vizaĝon de la tero, kaj ĝi loĝas kontraŭ mi. ");
INSERT INTO epo_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Nun venu do, malbenu al mi tiun popolon, ĉar ĝi estas pli forta ol mi; eble tiam mi povos venkobati ĝin kaj elpeli ĝin el la lando; ĉar mi scias, ke kiun vi benas, tiu estas benita, kaj kiun vi malbenas, tiu estas malbenita. ");
INSERT INTO epo_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Kaj iris la plejaĝuloj de Moab kaj la plejaĝuloj de Midjan, havante en siaj manoj la donacojn pro la sorĉado, kaj ili venis al Bileam kaj diris al li la vortojn de Balak. ");
INSERT INTO epo_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Kaj li diris al ili: Tradormu ĉi tie la nokton, kaj mi donos al vi respondon, konforme al tio, kion diros al mi la Eternulo. Kaj la ĉefoj de Moab restis ĉe Bileam. ");
INSERT INTO epo_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Kaj Dio venis al Bileam, kaj diris: Kiuj estas tiuj viroj ĉe vi? ");
INSERT INTO epo_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Kaj Bileam diris al Dio: Balak, filo de Cipor, reĝo de Moab, sendis al mi, dirante: ");
INSERT INTO epo_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Jen estas la popolo, kiu eliris el Egiptujo, kaj ĝi kovris la vizaĝon de la tero; venu do, malbenu ĝin al mi, eble tiam mi povos batali kontraŭ ĝi kaj forpeli ĝin. ");
INSERT INTO epo_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Tiam Dio diris al Bileam: Ne iru kun ili; ne malbenu la popolon, ĉar ĝi estas benita. ");
INSERT INTO epo_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kaj Bileam leviĝis matene, kaj diris al la ĉefoj de Balak: Iru en vian landon, ĉar la Eternulo ne volas permesi al mi iri kun vi. ");
INSERT INTO epo_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kaj leviĝis la ĉefoj de Moab kaj venis al Balak, kaj diris: Bileam ne volas iri kun ni. ");
INSERT INTO epo_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak sendis plue ĉefojn, pli grandajn kaj pli eminentajn ol tiuj. ");
INSERT INTO epo_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Kaj ili venis al Bileam, kaj diris al li: Tiel diris Balak, filo de Cipor: Ne rifuzu do iri al mi; ");
INSERT INTO epo_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ĉar mi tre honoros vin, kaj ĉion, kion vi diros al mi, mi faros; venu do, malbenu al mi tiun popolon. ");
INSERT INTO epo_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Sed Bileam respondis kaj diris al la servantoj de Balak: Eĉ se Balak donos al mi sian plenan domon da arĝento kaj oro, mi ne povas malobei la ordonon de la Eternulo, mia Dio, farante ion malgrandan aŭ grandan. ");
INSERT INTO epo_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Tamen restu ĉi tie ankaŭ vi dum la nokto, kaj mi sciiĝos, kion plue diros al mi la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Kaj Dio venis al Bileam en la nokto, kaj diris al li: Se tiuj viroj venis, por voki vin, leviĝu, iru kun ili, sed faru nur tion, kion Mi diros al vi. ");
INSERT INTO epo_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Kaj Bileam leviĝis matene kaj selis sian azeninon kaj iris kun la ĉefoj de Moab. ");
INSERT INTO epo_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Kaj ekflamis la kolero de Dio pro tio, ke li iris; kaj anĝelo de la Eternulo stariĝis sur la vojo, por malhelpi lin. Li rajdis sur sia azenino, kaj du liaj junuloj estis kun li. ");
INSERT INTO epo_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kaj la azenino ekvidis la anĝelon de la Eternulo, starantan sur la vojo kun elingigita glavo en la mano, kaj la azenino forturniĝis de la vojo kaj iris sur la kampon; kaj Bileam ekbatis la azeninon, por returni ĝin sur la vojon. ");
INSERT INTO epo_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Tiam la anĝelo de la Eternulo stariĝis sur la vojeto inter vinberĝardenoj, kie estis barilo sur unu flanko kaj barilo sur la dua flanko. ");
INSERT INTO epo_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kaj la azenino ekvidis la anĝelon de la Eternulo, kaj alpremis sin al la muro kaj alpremis la piedon de Bileam al la muro; kaj li denove ĝin batis. ");
INSERT INTO epo_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Kaj la anĝelo de la Eternulo denove forlasis sian lokon, kaj stariĝis sur malvasta loko, kie oni ne povas flankeniri dekstren, nek maldekstren. ");
INSERT INTO epo_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kiam la azenino ekvidis la anĝelon de la Eternulo, ĝi kuŝiĝis sub Bileam. Kaj ekflamis la kolero de Bileam, kaj li batis la azeninon per la bastono. ");
INSERT INTO epo_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tiam la Eternulo malŝlosis la buŝon de la azenino, kaj ĝi diris al Bileam: Kion mi faris al vi, ke vi batis min jam tri fojojn? ");
INSERT INTO epo_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Kaj Bileam diris al la azenino: Ĉar vi mokis min; se mi havus glavon en mia mano, mi nun mortigus vin. ");
INSERT INTO epo_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kaj la azenino diris al Bileam: Ĉu mi ne estas via azenino, sur kiu vi rajdadis de longatempe ĝis la nuna tago? ĉu mi kutimis tiel fari al vi? Kaj li diris: Ne. ");
INSERT INTO epo_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Tiam la Eternulo malkovris la okulojn de Bileam, kaj li ekvidis la anĝelon de la Eternulo, starantan sur la vojo kun elingigita glavo en sia mano; kaj li kliniĝis, kaj ĵetiĝis vizaĝaltere. ");
INSERT INTO epo_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Kaj la anĝelo de la Eternulo diris al li: Kial vi batis vian azeninon jam tri fojojn? jen Mi eliris, por malhelpi, ĉar malbona estas via vojo antaŭ Mi. ");
INSERT INTO epo_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","La azenino ekvidis Min, kaj forturniĝis antaŭ Mi jam tri fojojn; se ĝi ne forturniĝus de Mi, tiam Mi vin mortigus kaj ĝin Mi lasus vivi. ");
INSERT INTO epo_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Tiam Bileam diris al la anĝelo de la Eternulo: Mi pekis, ĉar mi ne sciis, ke Vi staras kontraŭ mi sur la vojo; nun, se tio ne plaĉas al Vi, mi iros returne. ");
INSERT INTO epo_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Sed la anĝelo de la Eternulo diris al Bileam: Iru kun la viroj; sed nur tion, kion Mi diros al vi, vi diru. Kaj Bileam iris kun la ĉefoj de Balak. ");
INSERT INTO epo_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kiam Balak aŭdis, ke Bileam venis, li eliris renkonte al li ĝis tiu Moaba urbo, kiu troviĝas ĉe la limo apud Arnon, kiu estas ĉe la fino de la limo. ");
INSERT INTO epo_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Kaj Balak diris al Bileam: Mi sendis ja al vi, por voki vin; kial do vi ne iris al mi? ĉu efektive mi ne povas honori vin? ");
INSERT INTO epo_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Sed Bileam diris al Balak: Jen mi venis al vi; tamen ĉu mi povas ion diri al vi? kion Dio enmetos en mian buŝon, tion mi diros. ");
INSERT INTO epo_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Kaj Bileam iris kun Balak, kaj ili venis al Kirjat-Ĥucot. ");
INSERT INTO epo_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Kaj Balak buĉis bovojn kaj ŝafojn, kaj sendis al Bileam, kaj al la ĉefoj, kiuj estis kun li. ");
INSERT INTO epo_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","En la sekvanta mateno Balak prenis Bileamon kaj surkondukis lin sur la altaĵojn de Baal, kaj li ekvidis de tie la finan parton de la popolo. ");
INSERT INTO epo_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Kaj Bileam diris al Balak: Konstruu al mi ĉi tie sep altarojn, kaj pretigu al mi ĉi tie sep bovidojn kaj sep virŝafojn. ");
INSERT INTO epo_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Kaj Balak faris, kiel diris Bileam; kaj Balak kaj Bileam oferis po unu bovido kaj po unu virŝafo sur ĉiu altaro. ");
INSERT INTO epo_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kaj Bileam diris al Balak: Staru ĉe via brulofero, kaj mi iros; eble la Eternulo venos al mi renkonte, kaj kion Li montros al mi, tion mi diros al vi. Kaj li iris sur la altaĵon. ");
INSERT INTO epo_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Kaj Dio renkontiĝis al Bileam, kaj ĉi tiu diris al Li: La sep altarojn mi pretigis, kaj mi oferis po unu bovido kaj po unu virŝafo sur ĉiu altaro. ");
INSERT INTO epo_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Kaj la Eternulo enmetis vorton en la buŝon de Bileam, kaj diris: Reiru al Balak kaj parolu tiel. ");
INSERT INTO epo_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Kaj li revenis al tiu, kaj jen tiu staras ĉe sia brulofero, li kaj ĉiuj ĉefoj de Moab. ");
INSERT INTO epo_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Kaj li komencis sian inspiritaĵon, kaj diris: El Aram venigis min Balak, Reĝo de Moab, el la montoj orientaj: Venu, malbenu al mi Jakobon, Kaj venu, malbondiru kontraŭ Izrael. ");
INSERT INTO epo_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Kiel mi tiun malbenos, kiun ne malbenas Dio? Kiel mi tiun malbondiros, kiun ne malbondiras la Eternulo? ");
INSERT INTO epo_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","De la supro de rokoj mi vidas lin, Kaj de altaĵoj mi rigardas lin; Jen la popolo loĝas aparte Kaj ne estas kalkulata inter la nacioj. ");
INSERT INTO epo_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kiu kalkulis la polvon de Jakob Kaj la nombron de kvarono de Izrael? Mortu mia animo per la morto de justuloj, Kaj mia fino estu simila al ilia! ");
INSERT INTO epo_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Tiam Balak diris al Bileam: Kion vi faris al mi? por malbeni miajn malamikojn mi prenis vin, kaj jen vi ilin benas. ");
INSERT INTO epo_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Kaj li respondis kaj diris: Ĉu ne tion, kion la Eternulo metas en mian buŝon, mi devas precize diri? ");
INSERT INTO epo_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Kaj Balak diris al li: Venu do kun mi al alia loko, de kiu vi ilin vidos; nur ilian parton vi vidos, la tutan vi ilin ne vidos; kaj malbenu ilin al mi de tie. ");
INSERT INTO epo_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Kaj li prenis lin sur la kampon de ĉirkaŭrigardantoj, sur la supron de Pisga, kaj li konstruis sep altarojn kaj oferis po unu bovido kaj unu virŝafo sur ĉiu altaro. ");
INSERT INTO epo_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Kaj li diris al Balak: Staru ĉi tie ĉe via brulofero, kaj mi iros renkonte tien. ");
INSERT INTO epo_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Kaj la Eternulo renkontiĝis al Bileam kaj metis vorton en lian buŝon, kaj diris: Reiru al Balak kaj parolu tiel. ");
INSERT INTO epo_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Kaj li venis al li, kaj jen li staras ĉe sia brulofero, kaj kun li la ĉefoj de Moab. Kaj Balak diris al li: Kion parolis la Eternulo? ");
INSERT INTO epo_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kaj li komencis sian inspiritaĵon, kaj diris: Leviĝu, Balak, kaj aŭskultu; Atentu min, filo de Cipor. ");
INSERT INTO epo_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dio ne estas homo, ke Li mensogus, Kaj ne homido, ke Li pentus. Ĉu Li dirus kaj ne farus, Parolus kaj ne plenumus? ");
INSERT INTO epo_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Jen beno estas komisiita al mi; Li benas, kaj mi ne povas tion ŝanĝi. ");
INSERT INTO epo_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Li ne vidis pekon ĉe Jakob, Kaj Li ne rimarkis malpiecon ĉe Izrael; La Eternulo, lia Dio, estas kun li, Kaj reĝa aklamado estas ĉe li. ");
INSERT INTO epo_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dio, kiu elkondukis ilin el Egiptujo, Estas por ili kiel la forto de bubalo. ");
INSERT INTO epo_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ĉar ne ekzistas sorĉado en Jakob, Nek aŭgurado en Izrael; Siatempe estas dirate al Jakob kaj al Izrael, kion faras Dio. ");
INSERT INTO epo_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Jen la popolo stariĝas kiel leonino Kaj leviĝas kiel leono; Ĝi ne kuŝiĝos, antaŭ ol ĝi manĝos rabakiron Kaj antaŭ ol ĝi trinkos sangon de mortigitoj. ");
INSERT INTO epo_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Kaj Balak diris al Bileam: Nek per malbeno malbenu ilin, nek per beno benu ilin. ");
INSERT INTO epo_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Sed Bileam respondis kaj diris al Balak: Ĉu mi ne diris al vi, ke ĉion, kion diros la Eternulo, tion mi faros? ");
INSERT INTO epo_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kaj Balak diris al Bileam: Venu, mi prenos vin sur alian lokon; eble plaĉos al Dio, kaj vi malbenos ilin al mi de tie. ");
INSERT INTO epo_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kaj Balak prenis Bileamon sur la supron de Peor, kiu estas turnita al la dezerto. ");
INSERT INTO epo_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Kaj Bileam diris al Balak: Konstruu al mi ĉi tie sep altarojn, kaj pretigu al mi ĉi tie sep bovidojn kaj sep virŝafojn. ");
INSERT INTO epo_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Kaj Balak faris, kiel diris Bileam, kaj oferis po unu bovido kaj po unu virŝafo sur ĉiu altaro. ");
INSERT INTO epo_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ĉar Bileam vidis, ke al la Eternulo plaĉas beni Izraelon, li ne iris, kiel antaŭe, por aŭguri, sed li turnis sian vizaĝon al la dezerto. ");
INSERT INTO epo_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kaj Bileam levis siajn okulojn, kaj ekvidis Izraelon, starantan laŭ siaj triboj; kaj la spirito de Dio venis sur lin. ");
INSERT INTO epo_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Kaj li ekparolis sian inspiritaĵon, kaj diris: Parolas Bileam, filo de Beor, Kaj parolas viro kun malfermita okulo; ");
INSERT INTO epo_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Parolas tiu, kiu aŭdas la vortojn de Dio, Kaj kiu vidas la vizion de la Plejpotenculo; Li falas, sed malfermitaj estas liaj okuloj. ");
INSERT INTO epo_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Kiel belaj estas viaj tendoj, ho Jakob, Viaj loĝejoj, ho Izrael! ");
INSERT INTO epo_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Kiel valoj ili etendiĝas, Kiel ĝardenoj apud rivero, Kiel arboj aloaj, plantitaj de la Eternulo, Kiel cedroj apud akvo. ");
INSERT INTO epo_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Fluos akvo el liaj siteloj, Kaj lia semo estos ĉe multaj akvoj; Superos Agagon lia reĝo, Kaj altiĝos lia regno. ");
INSERT INTO epo_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dio, kiu elkondukis lin el Egiptujo, Estas por li kiel la forto de bubalo; Li formanĝas la popolojn, kiuj estas malamikaj al li, Kaj iliajn ostojn li frakasas Kaj per siaj sagoj disbatas. ");
INSERT INTO epo_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Li genuiĝis, li kuŝiĝis, Kiel leono kaj kiel leonino; Kiu lin levos? Viaj benantoj estas benataj, Kaj viaj malbenantoj estas malbenataj. ");
INSERT INTO epo_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tiam ekflamis la kolero de Balak kontraŭ Bileam, kaj li kunefrapis siajn manojn; kaj Balak diris al Bileam: Por malbeni miajn malamikojn mi vokis vin, kaj vi nun benis ilin jam tri fojojn! ");
INSERT INTO epo_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Kaj nun foriĝu sur vian lokon; mi intencis honori vin, sed jen la Eternulo senigis vin je la honoro. ");
INSERT INTO epo_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Kaj Bileam diris al Balak: Ĉu eĉ al viaj senditoj, kiujn vi sendis al mi, mi ne parolis jene: ");
INSERT INTO epo_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Se Balak eĉ donus al mi sian plenan domon da arĝento kaj oro, mi ne povus malobei la ordonon de la Eternulo, farante bonon aŭ malbonon laŭ mia deziro? kion diros la Eternulo, tion mi diros. ");
INSERT INTO epo_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Kaj nun mi iras al mia popolo; venu, mi sciigos al vi, kion faros tiu popolo al via popolo en la malproksima venonta tempo. ");
INSERT INTO epo_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Kaj li ekparolis sian inspiritaĵon, kaj diris: Parolas Bileam, filo de Beor, Kaj parolas viro kun malfermita okulo; ");
INSERT INTO epo_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Parolas tiu, kiu aŭdas la vortojn de Dio Kaj scias la penson de la Plejaltulo, Kaj kiu vidas la vizion de la Plejpotenculo; Li falas, sed malfermitaj estas liaj okuloj. ");
INSERT INTO epo_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mi vidas lin, sed ne nun; Mi rigardas lin, sed ne proksime. Eliros stelo el Jakob, Kaj leviĝos sceptro el Izrael, Detruos la randojn de Moab Kaj frakasos ĉiujn filojn de malordo. ");
INSERT INTO epo_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Kaj Edom estos submetito, Kaj Seir estos submetito de siaj malamikoj; Sed Izrael havos venkon. ");
INSERT INTO epo_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Kaj la reganto eliros el Jakob, Kaj li pereigos la restintojn el la urbo. ");
INSERT INTO epo_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Kaj li ekvidis Amalekon, kaj li ekparolis sian inspiritaĵon, kaj diris: La unua el la popoloj estis Amalek, Sed lia fino estos pereo. ");
INSERT INTO epo_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kaj li ekvidis la Kenidojn, kaj li ekparolis sian inspiritaĵon, kaj diris: Fortika estas via loĝejo, Kaj aranĝita sur roko estas via nesto; ");
INSERT INTO epo_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Sed ruinigita estos Kain, Baldaŭ Aŝur vin kaptos. ");
INSERT INTO epo_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kaj li ekparolis sian inspiritaĵon, kaj diris: Ve! kiu vivos, kiam Dio tion faros? ");
INSERT INTO epo_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kaj venos ŝipoj de la lando de la Kitidoj, Kaj ili humiligos Aŝuron kaj humiligos Eberon; Sed ankaŭ ili pereos. ");
INSERT INTO epo_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kaj Bileam leviĝis, kaj foriris kaj revenis al sia loko; kaj ankaŭ Balak iris sian vojon. ");
INSERT INTO epo_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Kaj Izrael loĝis en Ŝitim, kaj la popolo komencis malĉastadi kun la filinoj de Moab. ");
INSERT INTO epo_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Kaj ili invitadis la popolon al la oferoj de siaj dioj, kaj la popolo manĝadis kaj kliniĝadis antaŭ iliaj dioj. ");
INSERT INTO epo_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Kaj Izrael aliĝis al Baal-Peor; kaj ekflamis la kolero de la Eternulo kontraŭ Izrael. ");
INSERT INTO epo_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Kaj la Eternulo diris al Moseo: Prenu ĉiujn estrojn de la popolo kaj pendigu ilin al la Eternulo kontraŭ la suno, kaj deturniĝos de Izrael la furiozo de la kolero de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kaj Moseo diris al la juĝistoj de Izrael: Mortigu ĉiu siajn homojn, kiuj aliĝis al Baal-Peor. ");
INSERT INTO epo_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kaj jen iu el la Izraelidoj venis kaj alkondukis al siaj fratoj Midjanidinon antaŭ la okuloj de Moseo kaj antaŭ la okuloj de la tuta komunumo de Izrael, dum ili ploris ĉe la pordo de la tabernaklo de kunveno. ");
INSERT INTO epo_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kiam tion vidis Pineĥas, filo de Eleazar, la filo de la pastro Aaron, li leviĝis el inter la komunumo kaj prenis ponardegon en sian manon. ");
INSERT INTO epo_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Kaj li iris post la Izraelido en la dormejon, kaj trapikis ilin ambaŭ, la Izraelidon kaj la virinon tra ŝia ventro; kaj tiam ĉesiĝis la punfrapado de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Kaj la nombro de la mortintoj per la punfrapado estis dudek kvar mil. ");
INSERT INTO epo_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pineĥas, filo de Eleazar, la filo de la pastro Aaron, deturnis Mian koleregon de la Izraelidoj, ĉar li fervoris pri Mi inter ili, kaj Mi ne ekstermis la Izraelidojn en Mia severeco. ");
INSERT INTO epo_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Tial diru: Jen Mi donas al li Mian interligon pri paco; ");
INSERT INTO epo_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","kaj ĝi estu por li kaj por lia idaro post li interligo de eterna pastreco, pro tio, ke li fervoris pri sia Dio kaj pekliberigis la Izraelidojn. ");
INSERT INTO epo_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","La nomo de la mortigita Izraelido, kiu estis mortigita kune kun la Midjanidino, estis Zimri, filo de Salu, ĉefo de patrodomo el la Simeonidoj; ");
INSERT INTO epo_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","kaj la nomo de la mortigita Midjanidino estis Kozbi, filino de Cur, estro de la anoj de patrodomo en Midjan. ");
INSERT INTO epo_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Estu malamikoj al la Midjanidoj kaj batu ilin; ");
INSERT INTO epo_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ĉar ili estas malamikoj al vi per sia insido, kiun ili faris al vi per Peor, kaj per Kozbi, la filino de la Midjana estro, ilia fratino mortigita en la tago de la punfrapado pro Peor. ");
INSERT INTO epo_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Kaj post la punfrapado la Eternulo ekparolis al Moseo, kaj al Eleazar, filo de la pastro Aaron, dirante: ");
INSERT INTO epo_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Kalkulu la tutan komunumon de la Izraelidoj en la aĝo de dudek jaroj kaj pli, laŭ iliaj patrodomoj, ĉiujn militkapablajn en Izrael. ");
INSERT INTO epo_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Kaj ekparolis al ili Moseo kaj la pastro Eleazar sur la stepoj de Moab apud la Jeriĥa Jordan, dirante: ");
INSERT INTO epo_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Kalkulu la popolon en la aĝo de dudek jaroj kaj pli, kiel la Eternulo ordonis al Moseo kaj al la Izraelidoj, kiuj eliris el la lando Egipta. ");
INSERT INTO epo_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, la unuenaskito de Izrael. La filoj de Ruben: de Ĥanoĥ, la familio de la Ĥanoĥidoj; de Palu, la familio de la Paluidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","de Ĥecron, la familio de la Ĥecronidoj; de Karmi, la familio de la Karmiidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Tio estas la familioj de la Rubenidoj; kaj ilia nombro estas kvardek tri mil sepcent tridek. ");
INSERT INTO epo_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Kaj la filoj de Palu: Eliab. ");
INSERT INTO epo_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Kaj la filoj de Eliab: Nemuel kaj Datan kaj Abiram; tio estas tiuj Datan kaj Abiram, eminentuloj de la komunumo, kiuj ribelis kontraŭ Moseo kaj Aaron en la anaro de Koraĥ, kiam ili ribelis kontraŭ la Eternulo ");
INSERT INTO epo_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","kaj la tero malfermis sian buŝon kaj englutis ilin kaj Koraĥon ĉe la morto de la anaro, kiam la fajro ekstermis la ducent kvindek homojn, kaj ili fariĝis averto. ");
INSERT INTO epo_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Sed la filoj de Koraĥ ne mortis. ");
INSERT INTO epo_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","La filoj de Simeon laŭ iliaj familioj: de Nemuel, la familio de la Nemuelidoj; de Jamin, la familio de la Jaminidoj; de Jaĥin, la familio de la Jaĥinidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","de Zeraĥ, la familio de la Zeraĥidoj; de Ŝaul, la familio de la Ŝaulidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Tio estas la familioj de la Simeonidoj, dudek du mil ducent. ");
INSERT INTO epo_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","La filoj de Gad laŭ iliaj familioj: de Cefon, la familio de la Cefonidoj; de Ĥagi, la familio de la Ĥagiidoj; de Ŝuni, la familio de la Ŝuniidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","de Ozni, la familio de la Ozniidoj; de Eri, la familio de la Eriidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","de Arod, la familio de la Arodidoj; de Areli, la familio de la Areliidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Tio estas la familioj de la Gadidoj, laŭ ilia nombro kvardek mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","La filoj de Jehuda: Er kaj Onan; sed Er kaj Onan mortis en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Kaj la filoj de Jehuda laŭ iliaj familioj estis: de Ŝela, la familio de la Ŝelaidoj; de Perec, la familio de la Perecidoj; de Zeraĥ, la familio de la Zeraĥidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Kaj la filoj de Perec estis: de Ĥecron, la familio de la Ĥecronidoj; de Ĥamul, la familio de la Ĥamulidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Tio estas la familioj de Jehuda, laŭ ilia nombro sepdek ses mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","La filoj de Isaĥar laŭ iliaj familioj: de Tola, la familio de la Tolaidoj; de Puva, la familio de la Puvaidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","de Jaŝub, la familio de la Jaŝubidoj; de Ŝimron, la familio de la Ŝimronidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Tio estas la familioj de Isaĥar, laŭ ilia nombro sesdek kvar mil tricent. ");
INSERT INTO epo_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","La filoj de Zebulun laŭ iliaj familioj: de Sered, la familio de la Seredidoj; de Elon, la familio de la Elonidoj; de Jaĥleel, la familio de la Jaĥleelidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Tio estas la familioj de la Zebulunidoj, laŭ ilia nombro sesdek mil kvincent. ");
INSERT INTO epo_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","La filoj de Jozef laŭ iliaj familioj: Manase kaj Efraim. ");
INSERT INTO epo_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","La filoj de Manase: de Maĥir, la familio de la Maĥiridoj; kaj de Maĥir naskiĝis Gilead; de Gilead, la familio de la Gileadidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Jen estas la filoj de Gilead: de Iezer, la familio de la Iezeridoj; de Ĥelek, la familio de la Ĥelekidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","kaj de Asriel, la familio de la Asrielidoj; kaj de Ŝeĥem, la familio de la Ŝeĥemidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kaj de Ŝemida, la familio de la Ŝemidaidoj; kaj de Ĥefer, la familio de la Ĥeferidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Kaj Celofĥad, filo de Ĥefer, ne havis filojn, sed nur filinojn; kaj la nomoj de la filinoj de Celofĥad estis: Maĥla kaj Noa kaj Ĥogla kaj Milka kaj Tirca. ");
INSERT INTO epo_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Tio estas la familioj de Manase, laŭ ilia nombro kvindek du mil sepcent. ");
INSERT INTO epo_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Jen estas la filoj de Efraim laŭ iliaj familioj: de Ŝutelaĥ, la familio de la Ŝutelaĥidoj; de Beĥer, la familio de la Beĥeridoj; de Taĥan, la familio de la Taĥanidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Kaj jen estas la filoj de Ŝutelaĥ: de Eran, la familio de la Eranidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Tio estas la familioj de la filoj de Efraim, laŭ ilia nombro tridek du mil kvincent. Tio estas la filoj de Jozef laŭ iliaj familioj. ");
INSERT INTO epo_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","La filoj de Benjamen laŭ iliaj familioj: de Bela, la familio de la Belaidoj; de Aŝbel, la familio de la Aŝbelidoj; de Aĥiram, la familio de la Aĥiramidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","de Ŝefufam, la familio de la Ŝefufamidoj; de Ĥufam la familio de la Ĥufamidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Kaj la filoj de Bela estis: Ard kaj Naaman; de Ard, la familio de la Ardidoj; de Naaman, la familio de la Naamanidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Tio estas la filoj de Benjamen laŭ iliaj familioj, kaj ilia nombro estis kvardek kvin mil sescent. ");
INSERT INTO epo_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Jen estas la filoj de Dan laŭ iliaj familioj: de Ŝuĥam, la familio de la Ŝuĥamidoj. Tio estas la familioj de Dan laŭ iliaj familioj. ");
INSERT INTO epo_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ĉiuj familioj de la Ŝuĥamidoj prezentis la nombron de sesdek kvar mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","La filoj de Aŝer laŭ iliaj familioj: de Jimna, la familio de la Jimnaidoj; de Jiŝvi, la familio de la Jiŝviidoj; de Beria, la familio de la Beriaidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","De la filoj de Beria: de Ĥeber, la familio de la Ĥeberidoj; de Malkiel, la familio de la Malkielidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Kaj la nomo de la filino de Aŝer estis Seraĥ. ");
INSERT INTO epo_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Tio estas la familioj de la filoj de Aŝer, laŭ ilia nombro kvindek tri mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","La filoj de Naftali laŭ iliaj familioj: de Jaĥceel, la familio de la Jaĥceelidoj; de Guni, la familio de la Guniidoj; ");
INSERT INTO epo_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","de Jecer, la familio de la Jeceridoj; de Ŝilem la familio de la Ŝilemidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Tio estas la familioj de Naftali laŭ iliaj familioj, kaj ilia nombro estis kvardek kvin mil kvarcent. ");
INSERT INTO epo_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Tia estis la kalkulita nombro de la Izraelidoj: sescent unu mil sepcent tridek. ");
INSERT INTO epo_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Al tiuj estu dividita la tero kiel posedaĵo laŭ la nombro de la nomoj. ");
INSERT INTO epo_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Al la plinombra donu pli grandan posedaĵon, kaj al la malplinombra donu malpli grandan posedaĵon; al ĉiu laŭ lia nombro estu donita lia posedaĵo. ");
INSERT INTO epo_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Sed per loto oni dividu la teron; laŭ la nomo de siaj patraj triboj ili ricevu posedaĵon. ");
INSERT INTO epo_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Per la loto oni dividu al ĉiu lian posedaĵon, kiel al la plinombraj, tiel al la malplinombraj. ");
INSERT INTO epo_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Kaj jen estas la kalkulitoj de Levi laŭ iliaj familioj: de Gerŝon, la familio de la Gerŝonidoj; de Kehat, la familio de la Kehatidoj; de Merari, la familio de la Merariidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Jen estas la familioj de Levi: la familio de la Libniidoj, la familio de la Ĥebronidoj, la familio de la Maĥliidoj, la familio de la Muŝiidoj, la familio de la Koraĥidoj. Kaj de Kehat naskiĝis Amram. ");
INSERT INTO epo_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Kaj la nomo de la edzino de Amram estis Joĥebed, filino de Levi, kiu estis naskita al Levi en Egiptujo; kaj ŝi naskis al Amram Aaronon kaj Moseon kaj ilian fratinon Mirjam. ");
INSERT INTO epo_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Kaj al Aaron naskiĝis Nadab kaj Abihu kaj Eleazar kaj Itamar. ");
INSERT INTO epo_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Sed Nadab kaj Abihu mortis, kiam ili alportis fremdan fajron antaŭ la Eternulon. ");
INSERT INTO epo_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Kaj la nombro de iliaj kalkulitoj estis dudek tri mil, ĉiuj virseksuloj en la aĝo de pli ol unu monato; ĉar ili ne estis kalkulitaj kune kun la Izraelidoj, ĉar al ili ne estis donita posedaĵo inter la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Tio estas la nombro, kiun kalkulis Moseo kaj la pastro Eleazar, kiuj kalkulis la Izraelidojn sur la stepoj de Moab ĉe la Jeriĥa Jordan. ");
INSERT INTO epo_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Kaj inter ili estis neniu el tiuj, kiujn kalkulis Moseo kaj la pastro Aaron, kiam ili kalkulis la Izraelidojn en la dezerto Sinaj. ");
INSERT INTO epo_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ĉar la Eternulo diris pri ili: Ili mortos en la dezerto. Kaj restis el ili neniu, krom Kaleb, filo de Jefune, kaj Josuo, filo de Nun. ");
INSERT INTO epo_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Kaj aliris la filinoj de Celofĥad, filo de Ĥefer, filo de Gilead, filo de Maĥir, filo de Manase, el la familioj de Manase, filo de Jozef; kaj jen estas la nomoj de liaj filinoj: Maĥla kaj Noa kaj Ĥogla kaj Milka kaj Tirca; ");
INSERT INTO epo_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","kaj ili stariĝis antaŭ Moseo kaj antaŭ la pastro Eleazar kaj antaŭ la estroj kaj la tuta komunumo ĉe la pordo de la tabernaklo de kunveno, kaj diris: ");
INSERT INTO epo_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Nia patro mortis en la dezerto, kaj li ne estis inter la anaro, kiu ribelis kontraŭ la Eternulo en la anaro de Koraĥ; sed pro sia peko li mortis, kaj filojn li ne havis. ");
INSERT INTO epo_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Kial malaperu la nomo de nia patro el inter lia familio, ĉar li ne havis filon? Donu al ni posedaĵon inter la fratoj de nia patro. ");
INSERT INTO epo_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Kaj Moseo prezentis ilian aferon antaŭ la Eternulon. ");
INSERT INTO epo_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Kaj la Eternulo diris al Moseo jene: ");
INSERT INTO epo_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Prave parolas la filinoj de Celofĥad; efektive donu al ili heredan posedaĵon inter la fratoj de ilia patro, kaj transirigu la posedaĵon de ilia patro al ili. ");
INSERT INTO epo_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Kaj al la Izraelidoj diru jene: Se iu mortos, ne havante filon, tiam transirigu lian posedaĵon al lia filino; ");
INSERT INTO epo_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","kaj se li ne havas filinon, tiam donu lian posedaĵon al liaj fratoj; ");
INSERT INTO epo_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","kaj se li ne havas fratojn, donu lian posedaĵon al la fratoj de lia patro; ");
INSERT INTO epo_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","kaj se lia patro ne havas fratojn, donu lian posedaĵon al lia proksima parenco el lia familio, ke li heredu ĝin. Kaj tio estu por la Izraelidoj leĝa juro, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Kaj la Eternulo diris al Moseo: Supreniru sur ĉi tiun monton Abarim, kaj rigardu la landon, kiun Mi donis al la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Kaj kiam vi estos vidinta ĝin, vi alkolektiĝos al via popolo, vi ankaŭ, kiel alkolektiĝis via frato Aaron; ");
INSERT INTO epo_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ĉar vi malobeis Mian ordonon en la dezerto Cin, dum la malpaco de la komunumo, ke vi montru ĉe la akvo Mian sanktecon antaŭ iliaj okuloj — tiu Akvo de Malpaco ĉe Kadeŝ en la dezerto Cin. ");
INSERT INTO epo_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Kaj Moseo ekparolis al la Eternulo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","La Eternulo, Dio de la spiritoj de ĉiu karno, starigu super la komunumo viron, ");
INSERT INTO epo_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","kiu eliradus antaŭ ili kaj kiu eniradus antaŭ ili kaj kiu elkondukadus ilin kaj kiu enkondukadus ilin, por ke ne estu la komunumo de la Eternulo kiel ŝafoj, kiuj ne havas paŝtiston. ");
INSERT INTO epo_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Kaj la Eternulo diris al Moseo: Prenu al vi Josuon, filon de Nun, viron, kiu havas en si spiriton, kaj metu vian manon sur lin; ");
INSERT INTO epo_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","kaj starigu lin antaŭ Eleazar, la pastro, kaj antaŭ la tuta komunumo, kaj donu al li instrukciojn antaŭ iliaj okuloj; ");
INSERT INTO epo_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","kaj metu sur lin parton de via majesto, por ke aŭskultu lin la tuta komunumo de la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kaj li staru antaŭ la pastro Eleazar kaj demandu lin pri decido per la signoj de lumo antaŭ la Eternulo; laŭ lia vorto devas eliri kaj laŭ lia vorto devas eniri li kaj ĉiuj Izraelidoj kun li kaj la tuta komunumo. ");
INSERT INTO epo_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Kaj Moseo faris, kiel ordonis al li la Eternulo; kaj li prenis Josuon kaj starigis lin antaŭ la pastro Eleazar kaj antaŭ la tuta komunumo; ");
INSERT INTO epo_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","kaj li metis sur lin siajn manojn kaj donis al li instrukciojn, kiel la Eternulo parolis per Moseo. ");
INSERT INTO epo_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Ordonu al la Izraelidoj kaj diru al ili: Mian oferon, Mian panon, Miajn fajroferojn, Mian agrablan odoraĵon observu, por alportadi al Mi en ilia tempo. ");
INSERT INTO epo_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Kaj diru al ili: Jen estas la fajrofero, kiun vi devas alportadi al la Eternulo: ŝafidojn jaraĝajn sendifektajn po du en ĉiu tago, kiel konstantan bruloferon. ");
INSERT INTO epo_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Unu ŝafidon oferu matene, kaj la duan ŝafidon oferu ĉirkaŭ la vespero; ");
INSERT INTO epo_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","kaj dekonon de efo da delikata faruno kiel farunoferon, miksitan kun kvarono de hino da elpistita oleo. ");
INSERT INTO epo_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Tio estas la brulofero konstanta, kia estis farata ĉe la monto Sinaj, kiel agrabla odoraĵo, fajrofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Kaj ĝia verŝofero estu po kvarono de hino ĉe unu ŝafido; en la sanktejo vi devas verŝi la vinon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Kaj la duan ŝafidon oferu ĉirkaŭ la vespero; kun tia farunofero, kiel matene, kaj kun tia verŝofero faru fajroferon, agrablan odoraĵon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Sed en la tago sabata du ŝafidojn jaraĝajn sendifektajn kaj du dekonojn de efo da delikata faruno kiel farunoferon, miksitan kun oleo, kaj ĝian verŝoferon; ");
INSERT INTO epo_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","tio estas la brulofero de ĉiu sabato, krom la konstanta brulofero kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Kaj en viaj monatkomencoj alportu bruloferon al la Eternulo: du bovidojn kaj unu virŝafon, sep jaraĝajn sendifektajn ŝafidojn; ");
INSERT INTO epo_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","kaj tri dekonojn de efo da delikata faruno kiel farunoferon, miksitan kun oleo, por ĉiu bovido, kaj du dekonojn da delikata faruno kiel farunoferon, miksitan kun oleo, por la unu virŝafo; ");
INSERT INTO epo_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","kaj po unu dekono da delikata faruno kiel farunoferon, miksitan kun oleo, por ĉiu ŝafido; tio estas brulofero, agrabla odoraĵo, fajrofero al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Kaj iliaj verŝoferoj estu: duono de hino da vino por bovido, kaj triono de hino por virŝafo, kaj kvarono de hino por ŝafido. Tio estas ĉiumonata brulofero por ĉiuj monatoj de la jaro. ");
INSERT INTO epo_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Kaj unu virkapro, kiel pekofero al la Eternulo, krom la konstanta brulofero, estu oferata kune kun sia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Kaj en la unua monato, en la dek-kvara tago de la monato, estas Pasko al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Kaj en la dek-kvina tago de tiu monato estas festo; dum sep tagoj oni manĝu macojn. ");
INSERT INTO epo_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","En la unua tago estas sankta kunveno; faru nenian servan laboron; ");
INSERT INTO epo_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","kaj alportu fajroferon, bruloferon al la Eternulo: du bovidojn kaj unu virŝafon kaj sep jaraĝajn ŝafidojn; sendifektaj ili estu ĉe vi; ");
INSERT INTO epo_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","kaj kiel ilian farunoferon alportu delikatan farunon, miksitan kun oleo, tri dekonojn por bovido kaj du dekonojn por la virŝafo; ");
INSERT INTO epo_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","po unu dekono alportu por ĉiu el la sep ŝafidoj; ");
INSERT INTO epo_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","kaj unu virkapron, por pekliberigi vin. ");
INSERT INTO epo_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Krom la matena brulofero, kiu estas konstanta brulofero, alportu tion. ");
INSERT INTO epo_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Tiel faru en ĉiu el la sep tagoj; tio estas manĝaĵo, fajrofero, agrabla odoraĵo al la Eternulo; krom la konstanta brulofero oni tion alportu kune kun ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Kaj en la sepa tago estu ĉe vi sankta kunveno; faru nenian servan laboron. ");
INSERT INTO epo_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Kaj en la tago de la unuaj fruktoj, kiam vi alportos novan farunoferon al la Eternulo en via festo de semajnoj, estu ĉe vi sankta kunveno; faru nenian servan laboron; ");
INSERT INTO epo_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","kaj alportu bruloferon, kiel agrablan odoraĵon al la Eternulo: du bovidojn, unu virŝafon, sep jaraĝajn ŝafidojn; ");
INSERT INTO epo_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","kaj kiel ilian farunoferon delikatan farunon, miksitan kun oleo, tri dekonojn por ĉiu bovido, du dekonojn por la unu virŝafo; ");
INSERT INTO epo_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","po unu dekono por ĉiu el la sep ŝafidoj; ");
INSERT INTO epo_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","unu virkapron, por pekliberigi vin. ");
INSERT INTO epo_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Krom la konstanta brulofero kaj ĝia verŝofero alportu tion; sendifektaj ili estu ĉe vi kaj kun siaj verŝoferoj. ");
INSERT INTO epo_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Kaj en la sepa monato, en la unua tago de la monato, estu ĉe vi sankta kunveno; faru nenian servan laboron; tago de trumpetado ĝi estu por vi. ");
INSERT INTO epo_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Kaj alportu bruloferon, kiel agrablan odoraĵon al la Eternulo: unu bovidon, unu virŝafon, sep jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","kaj ilian farunoferon: delikatan farunon, miksitan kun oleo, tri dekonojn por la bovido, du dekonojn por la virŝafo; ");
INSERT INTO epo_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","kaj po unu dekono por ĉiu el la sep ŝafidoj; ");
INSERT INTO epo_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","kaj unu virkapron, kiel pekoferon, por pekliberigi vin; ");
INSERT INTO epo_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","krom la monata brulofero kaj ĝia farunofero kaj la konstanta brulofero kaj ĝia farunofero; kaj iliajn verŝoferojn laŭ ilia regularo; kiel agrablan odoraĵon, fajroferon al la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Kaj en la deka tago de tiu sepa monato estu ĉe vi sankta kunveno; kaj premu viajn animojn; faru nenian laboron; ");
INSERT INTO epo_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","kaj alportu bruloferon al la Eternulo, agrablan odoraĵon: unu bovidon, unu virŝafon, sep jaraĝajn ŝafidojn; sendifektaj ili estu ĉe vi; ");
INSERT INTO epo_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","kaj ilian farunoferon: delikatan farunon, miksitan kun oleo, tri dekonojn por la bovido, du dekonojn por la unu virŝafo; ");
INSERT INTO epo_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","po unu dekono por ĉiu el la sep ŝafidoj; ");
INSERT INTO epo_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","unu virkapron, kiel pekoferon, krom la pekofero de pekliberigo kaj la konstanta brulofero kaj ĝia farunofero kaj iliaj verŝoferoj. ");
INSERT INTO epo_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Kaj en la dek-kvina tago de la sepa monato estu ĉe vi sankta kunveno; faru nenian servan laboron, kaj festu feston al la Eternulo dum sep tagoj; ");
INSERT INTO epo_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","kaj alportu bruloferon, fajroferon, agrablan odoraĵon al la Eternulo: dek tri bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn, sendifektaj ili estu; ");
INSERT INTO epo_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","kaj ilian farunoferon: delikatan farunon, miksitan kun oleo, po tri dekonoj por ĉiu el la dek tri bovidoj, po du dekonoj por ĉiu el la du virŝafoj; ");
INSERT INTO epo_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","kaj po unu dekono por ĉiu el la dek kvar ŝafidoj; ");
INSERT INTO epo_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","kaj unu virkapron, kiel pekoferon, krom la konstanta brulofero, ĝia farunofero, kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Kaj en la dua tago: dek du bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","kaj ilian farunoferon kaj iliajn verŝoferojn por la bovidoj, por la virŝafoj, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","kaj unu virkapron, kiel pekoferon, krom la konstanta brulofero kaj ĝia farunofero kaj iliaj verŝoferoj. ");
INSERT INTO epo_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Kaj en la tria tago: dek unu bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","kaj ilian farunoferon kaj iliajn verŝoferojn por la bovidoj, por la virŝafoj, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","kaj unu virkapron pekoferan, krom la konstanta brulofero kaj ĝia farunofero kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Kaj en la kvara tago: dek bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ilian farunoferon kaj iliajn verŝoferojn por la bovidoj, por la virŝafoj, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","kaj unu virkapron pekoferan, krom la konstanta brulofero, ĝia farunofero, kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Kaj en la kvina tago: naŭ bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","kaj ilian farunoferon kaj iliajn verŝoferojn por la bovidoj, por la virŝafoj, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","kaj unu virkapron pekoferan, krom la konstanta brulofero kaj ĝia farunofero kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Kaj en la sesa tago: ok bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","kaj ilian farunoferon kaj iliajn verŝoferojn por la bovidoj, por la virŝafoj, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","kaj unu virkapron pekoferan, krom la konstanta brulofero, ĝia farunofero, kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Kaj en la sepa tago: sep bovidojn, du virŝafojn, dek kvar jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","kaj ilian farunoferon kaj iliajn verŝoferojn por la bovidoj, por la virŝafoj, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","kaj unu virkapron pekoferan, krom la konstanta brulofero, ĝia farunofero, kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","En la oka tago estu ĉe vi sankta kunveno; faru nenian servan laboron; ");
INSERT INTO epo_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","kaj alportu bruloferon, fajroferon, agrablan odoraĵon al la Eternulo; unu bovidon, unu virŝafon, sep jaraĝajn ŝafidojn sendifektajn; ");
INSERT INTO epo_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ilian farunoferon kaj iliajn verŝoferojn por la bovido, por la virŝafo, kaj por la ŝafidoj, laŭ ilia nombro, laŭ la regularo; ");
INSERT INTO epo_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","kaj unu virkapron pekoferan, krom la konstanta brulofero kaj ĝia farunofero kaj ĝia verŝofero. ");
INSERT INTO epo_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Tion faru al la Eternulo en viaj festoj, krom viaj sanktaj promesitaĵoj kaj viaj propravolaj donacoj, viaj bruloferoj kaj viaj farunoferoj kaj viaj verŝoferoj kaj viaj pacoferoj. ");
INSERT INTO epo_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Kaj Moseo raportis al la Izraelidoj konforme al ĉio, kion la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Kaj Moseo ekparolis al la tribestroj de la Izraelidoj, dirante: Jen kion ordonis la Eternulo: ");
INSERT INTO epo_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Se iu faros sanktan promeson al la Eternulo aŭ ĵuros ĵuron, ligante sian animon, li ne rompu sian vorton, sed konforme al ĉio, kio eliris el lia buŝo, li faru. ");
INSERT INTO epo_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Kaj se virino faros sanktan promeson al la Eternulo aŭ ligos sin en la domo de sia patro, en sia juneco, ");
INSERT INTO epo_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","kaj ŝia patro aŭdos ŝian promeson, kaj la ligon, kiun ŝi metas sur sian animon, kaj ŝia patro silentos pri tio; tiam valoras ĉiuj ŝiaj promesoj, kaj ĉiu ligo, kiun ŝi metis sur sian animon, valoras. ");
INSERT INTO epo_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Sed se ŝia patro malpermesos al ŝi en la tago, kiam li aŭdis, tiam ĉiuj ŝiaj promesoj kaj ĉiuj ŝiaj ligoj, per kiuj ŝi ligis sian animon, ne valoras; kaj la Eternulo pardonos al ŝi, ĉar ŝia patro malpermesis al ŝi. ");
INSERT INTO epo_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Se ŝi fariĝos edzino, kaj sur ŝi estos ŝiaj promesoj, aŭ vorto, kiu elglitis el ŝia buŝo kaj ligis ŝian animon, ");
INSERT INTO epo_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","kaj ŝia edzo aŭdos, kaj li silentos en la tago, kiam li aŭdis; tiam valoras ŝiaj promesoj, kaj ŝiaj ligoj, per kiuj ŝi ligis sian animon, valoras. ");
INSERT INTO epo_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Sed se en la tago, kiam ŝia edzo aŭdis, li malpermesas al ŝi, tiam li neniigas ŝian promeson, kiu estas sur ŝi, kaj tion, kio elglitis el ŝia buŝo kaj per kio ŝi ligis sian animon; kaj la Eternulo pardonos al ŝi. ");
INSERT INTO epo_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","La promeso de vidvino kaj de eksedzino, ĉio, per kio ŝi ligis sian animon, valoras sur ŝi. ");
INSERT INTO epo_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Se virino en la domo de sia edzo faris sanktan promeson aŭ per ĵuro metis ligon sur sian animon, ");
INSERT INTO epo_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","kaj ŝia edzo aŭdis kaj silentis, ne malpermesis al ŝi; tiam valoras ĉiuj ŝiaj promesoj, kaj ĉiu ligo, kiun ŝi metis sur sian animon, valoras. ");
INSERT INTO epo_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Sed se ŝia edzo neniigis ilin en la tago, kiam li aŭdis; tiam ĉio, kio eliris el ŝia buŝo, ŝiaj promesoj kaj la ligoj de ŝia animo, ne valoras: ŝia edzo ilin neniigis; kaj la Eternulo pardonos al ŝi. ");
INSERT INTO epo_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ĉiun promeson kaj ĉiun ligiĝon per ĵuro fari premon al sia animo ŝia edzo povas valorigi aŭ ŝia edzo povas neniigi. ");
INSERT INTO epo_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Se ŝia edzo silentis tagon por tago, tiam li valorigas ĉiujn ŝiajn promesojn, aŭ ĉiujn ligiĝojn, kiuj estas sur ŝi, li valorigas; ĉar li silentis en la tago, kiam li aŭdis. ");
INSERT INTO epo_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Kaj se li neniigis ilin, post kiam li aŭdis, tiam li prenis sur sin ŝian kulpon. ");
INSERT INTO epo_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Tio estas la leĝoj, kiujn la Eternulo donis al Moseo pri la rilatoj inter edzo kaj lia edzino, inter patro kaj lia filino en ŝia juneco en la domo de ŝia patro. ");
INSERT INTO epo_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Faru venĝon pro la Izraelidoj sur la Midjanidoj; kaj poste alkolektiĝu al via popolo. ");
INSERT INTO epo_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Kaj Moseo ekparolis al la popolo, dirante: Armu inter vi virojn por milito, ke ili iru kontraŭ Midjan, por fari venĝon de la Eternulo sur Midjan. ");
INSERT INTO epo_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Po mil el tribo, el ĉiuj triboj de Izrael, sendu en militon. ");
INSERT INTO epo_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Kaj oni eligis el la miloj de la Izraelidoj, po mil el ĉiu tribo, dek du mil armitojn por milito. ");
INSERT INTO epo_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Kaj Moseo sendis ilin, po mil el tribo, en militon, ilin kaj Pineĥason, filon de la pastro Eleazar, en militon, kaj la sanktaj vazoj kaj alarmaj trumpetoj estis en lia mano. ");
INSERT INTO epo_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Kaj ili militis kontraŭ Midjan, kiel la Eternulo ordonis al Moseo, kaj ili mortigis ĉiujn virseksulojn. ");
INSERT INTO epo_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Kaj la reĝojn de Midjan ili mortigis inter la aliaj mortigitoj: Evin, Rekemon, Curon, Ĥuron, kaj Reban, la kvin reĝojn de Midjan, kaj Bileamon, filon de Beor, ili mortigis per glavo. ");
INSERT INTO epo_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Kaj la Izraelidoj prenis en malliberecon la virinojn Midjanajn kaj iliajn infanojn; kaj ĉiujn iliajn brutojn kaj ilian tutan posedaĵon kaj havon ili rabis. ");
INSERT INTO epo_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Kaj ĉiujn iliajn urbojn en iliaj lokoj de loĝado kaj ĉiujn iliajn kastelojn ili forbruligis per fajro. ");
INSERT INTO epo_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Kaj ili prenis la tutan kaptitaĵon kaj rabitaĵon, kiel la homojn, tiel ankaŭ la brutojn. ");
INSERT INTO epo_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Kaj ili venigis al Moseo kaj al la pastro Eleazar kaj al la komunumo de la Izraelidoj la kaptitojn kaj la prenitaĵon kaj la rabitaĵon en la tendaron sur la stepoj de Moab apud la Jeriĥa Jordan. ");
INSERT INTO epo_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Kaj eliris Moseo kaj la pastro Eleazar kaj ĉiuj estroj de la komunumo renkonte al ili ekster la tendaron. ");
INSERT INTO epo_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Kaj Moseo ekkoleris kontraŭ la militestroj, la milestroj kaj centestroj, kiuj venis el la milito. ");
INSERT INTO epo_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Kaj Moseo diris al ili: Vi lasis vivi ĉiujn virinojn! ");
INSERT INTO epo_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Jen ili estis ja por la Izraelidoj, laŭ la vortoj de Bileam, instigo por deturniĝi de la Eternulo al Peor; kaj pro tio estis ja la punfrapado en la komunumo de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Kaj nun mortigu ĉiun virseksan infanon; kaj ĉiun virinon, kiu ekkonis viron sur kuŝejo de viro, mortigu. ");
INSERT INTO epo_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Sed ĉiun infanon virinseksan, kiu ne ekkonis kuŝejon de viro, lasu viva por vi. ");
INSERT INTO epo_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Kaj vi restu ekster la tendaro dum sep tagoj; ĉiu el vi kaj viaj kaptitoj, kiu mortigis homon, kaj ĉiu, kiu ektuŝis mortigiton, pekpurigu sin en la tria tago kaj en la sepa tago. ");
INSERT INTO epo_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Kaj ĉiun veston kaj ĉiun objekton el felo kaj ĉion faritan el kapra lano kaj ĉiun lignan vazon pekpurigu. ");
INSERT INTO epo_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Kaj la pastro Eleazar diris al la militistoj, kiuj iris en la militon: Tio estas la leĝa instrukcio, kiun la Eternulo ordonis al Moseo: ");
INSERT INTO epo_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Nur oron, arĝenton, kupron, feron, stanon, kaj plumbon, ");
INSERT INTO epo_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ĉion, kio povas iri en fajron, trairigu tra fajro, kaj ĝi estos pura, tamen per puriga akvo oni ĝin pekpurigu; ĉion, kio ne povas iri en fajron, trairigu tra akvo. ");
INSERT INTO epo_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Kaj lavu viajn vestojn en la sepa tago kaj fariĝu puraj, kaj poste vi povas veni en la tendaron. ");
INSERT INTO epo_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Kalkulu la kvanton de la prenita kaptitaĵo, kiel de la homoj, tiel ankaŭ de la brutoj, vi kaj la pastro Eleazar kaj la estroj de la familioj de la komunumo. ");
INSERT INTO epo_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Kaj dividu la prenitaĵon po duono inter tiuj, kiuj partoprenis en la milito kaj iris batali, kaj inter la tuta komunumo. ");
INSERT INTO epo_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kaj prenu imposton por la Eternulo de la militistoj, kiuj iris batali, po unu animo el kvincent, kiel el la homoj, tiel el la bovoj kaj el la azenoj kaj el la ŝafoj. ");
INSERT INTO epo_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Prenu tion el ilia duono, kaj donu al la pastro Eleazar, kiel oferdonon por la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kaj el la duono, apartenanta al la Izraelidoj, prenu po unu kaptito el kvindek, kiel el la homoj, tiel ankaŭ el la bovoj, el la azenoj, kaj el la ŝafoj, el ĉiuj brutoj, kaj donu ilin al la Levidoj, kiuj plenumas la oficojn en la tabernaklo de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Kaj faris Moseo kaj la pastro Eleazar, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Kaj la kvanto de la kaptitaĵo, krom la rabitaĵo, kiun rabis la militistoj, estis: da ŝafoj sescent sepdek kvin mil; ");
INSERT INTO epo_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","kaj da bovoj sepdek du mil; ");
INSERT INTO epo_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","kaj da azenoj sesdek unu mil; ");
INSERT INTO epo_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","kaj da homoj, el virinoj, kiuj ne ekkonis kuŝejon de viro, la nombro de ĉiuj estis tridek du mil. ");
INSERT INTO epo_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","La duono, la parto de tiuj, kiuj iris en la militon, estis: da ŝafoj tricent tridek sep mil kvincent; ");
INSERT INTO epo_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","kaj la tributo por la Eternulo estis el la ŝafoj sescent sepdek kvin; ");
INSERT INTO epo_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","kaj da bovoj estis tridek ses mil, kaj el ili la tributo al la Eternulo sepdek du; ");
INSERT INTO epo_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","kaj da azenoj estis tridek mil kvincent, kaj el ili la tributo al la Eternulo sesdek unu; ");
INSERT INTO epo_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","kaj da homoj estis dek ses mil, kaj el ili la tributo por la Eternulo tridek du animoj. ");
INSERT INTO epo_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Kaj Moseo donis la tributon, la oferdonon por la Eternulo, al la pastro Eleazar, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Kaj el la duono, apartenanta al la Izraelidoj, kiun apartigis Moseo de la viroj, kiuj militis ");
INSERT INTO epo_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(kaj la duono, apartenanta al la komunumo, estis: da ŝafoj tricent tridek sep mil kvincent, ");
INSERT INTO epo_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","kaj da bovoj tridek ses mil, ");
INSERT INTO epo_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","kaj da azenoj tridek mil kvincent, ");
INSERT INTO epo_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","kaj da homoj dek ses mil) — ");
INSERT INTO epo_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kaj Moseo prenis el la duono, apartenanta al la Izraelidoj, unu prenitaĵon el kvindek, kiel el la homoj, tiel ankaŭ el la brutoj, kaj li donis ilin al la Levidoj, kiuj plenumas oficojn en la tabernaklo de la Eternulo, kiel la Eternulo ordonis al Moseo. ");
INSERT INTO epo_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Kaj aliris al Moseo la estroj de la miloj da militistoj, la milestroj kaj la centestroj; ");
INSERT INTO epo_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","kaj ili diris al Moseo: Viaj servantoj kalkulis la militistojn, kiuj estis komisiitaj al ni, kaj mankas el ili neniu; ");
INSERT INTO epo_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","tial ni alportas oferon al la Eternulo, kion ĉiu el ni trovis, orajn vazojn, ĉenetojn, braceletojn, ringojn, orelornamojn, kaj kolringojn, por pekliberigi niajn animojn antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Kaj Moseo kaj la pastro Eleazar prenis de ili la oron en la formo de diversaj objektoj. ");
INSERT INTO epo_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Kaj la kvanto de la tuta oro oferdona, kiun ili oferdonis al la Eternulo, estis dek ses mil sepcent kvindek sikloj de la milestroj kaj de la centestroj. ");
INSERT INTO epo_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Ĉar la militistoj rabis ĉiu por si.) ");
INSERT INTO epo_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Kaj Moseo kaj la pastro Eleazar prenis la oron de la milestroj kaj centestroj, kaj alportis ĝin en la tabernaklon de kunveno, kiel memorigaĵon de la Izraelidoj antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","La filoj de Ruben kaj la filoj de Gad havis tre multe da brutaroj; kaj ili vidis, ke la lando Jazer kaj la lando Gilead estas lokoj bonaj por brutaroj. ");
INSERT INTO epo_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Kaj venis la filoj de Gad kaj la filoj de Ruben, kaj diris al Moseo kaj al la pastro Eleazar kaj al la estroj de la komunumo jene: ");
INSERT INTO epo_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot kaj Dibon kaj Jazer kaj Nimra kaj Ĥeŝbon kaj Eleale kaj Sibma kaj Nebo kaj Beon — ");
INSERT INTO epo_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","tiu lando, kiun la Eternulo venkobatis antaŭ la komunumo de Izrael — estas lando bona por brutaroj, kaj viaj servantoj havas brutarojn. ");
INSERT INTO epo_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Kaj ili diris: Se vi estas favoraj al ni, tiam tiu lando estu donata al viaj servantoj kiel posedaĵo; ne irigu nin trans Jordanon. ");
INSERT INTO epo_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Kaj Moseo diris al la filoj de Gad kaj al la filoj de Ruben: Ĉu viaj fratoj iru en la militon kaj vi sidos ĉi tie? ");
INSERT INTO epo_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Kaj kial vi deklinas la koron de la Izraelidoj de la transiro en la landon, kiun donas al ili la Eternulo? ");
INSERT INTO epo_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tiel agis viaj patroj, kiam mi sendis ilin el Kadeŝ-Barnea, por rigardi la landon. ");
INSERT INTO epo_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ili iris ĝis la valo Eŝkol kaj vidis la landon, kaj deklinis la koron de la Izraelidoj, ke ili ne iru en la landon, kiun donas al ili la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Kaj ekflamis en tiu tago la kolero de la Eternulo, kaj Li ĵuris, dirante: ");
INSERT INTO epo_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Tiuj homoj, kiuj eliris el Egiptujo, en la aĝo de dudek jaroj kaj pli, ne vidos la landon, pri kiu Mi ĵuris al Abraham, al Isaak, kaj al Jakob; ĉar ili ne sekvis Min; ");
INSERT INTO epo_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","krom Kaleb, filo de Jefune, la Kenizido, kaj Josuo, filo de Nun, ĉar ili sekvis Min. ");
INSERT INTO epo_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Kaj ekflamis la kolero de la Eternulo kontraŭ Izrael, kaj Li igis ilin vagadi en la dezerto dum kvardek jaroj, ĝis mortis la tuta generacio, kiu faris malbonon en la okuloj de la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Kaj jen vi leviĝis anstataŭ viaj patroj, nova generacio da pekuloj, por ankoraŭ plifortigi la flaman koleron de la Eternulo kontraŭ Izrael. ");
INSERT INTO epo_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Se vi deturniĝos de Li, tiam Li denove restigos ilin en la dezerto; kaj vi pereigos tiun tutan popolon. ");
INSERT INTO epo_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Kaj ili aliris al li, kaj diris: Baraĵojn por ŝafoj ni konstruos ĉi tie por niaj brutaroj kaj urbojn por niaj infanoj; ");
INSERT INTO epo_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","sed ni mem rapidos armitaj antaŭ la Izraelidoj, ĝis ni alkondukos ilin al iliaj lokoj; kaj niaj infanoj loĝos en la fortikigitaj urboj pro la loĝantoj de la lando. ");
INSERT INTO epo_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ni ne revenos al niaj domoj, ĝis la Izraelidoj ekposedos ĉiu sian posedaĵon. ");
INSERT INTO epo_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ni ne prenos kun ili posedaĵon transe de Jordan kaj plue; ĉar ni ricevos nian posedaĵon sur ĉi tiu orienta flanko de Jordan. ");
INSERT INTO epo_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Kaj Moseo diris al ili: Se vi tion faros, se vi iros armitaj antaŭ la Eternulo en la militon, ");
INSERT INTO epo_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","kaj ĉiu el vi armita transiros Jordanon antaŭ la Eternulo, ĝis Li forpelos Siajn malamikojn antaŭ Si, ");
INSERT INTO epo_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","kaj la lando estos militakirita antaŭ la Eternulo, tiam vi poste revenos, kaj vi estos senkulpaj antaŭ la Eternulo kaj antaŭ Izrael, kaj ĉi tiu lando estos via posedaĵo antaŭ la Eternulo. ");
INSERT INTO epo_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Sed se vi ne agos tiel, tiam vi pekos antaŭ la Eternulo, kaj vi suferos vian punon, kiu trafos vin. ");
INSERT INTO epo_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Konstruu al vi urbojn por viaj infanoj kaj baraĵojn por viaj ŝafoj; kaj faru tion, kio eliris el via buŝo. ");
INSERT INTO epo_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Kaj la filoj de Gad kaj la filoj de Ruben diris al Moseo jene: Viaj servantoj faros, kiel nia sinjoro ordonas. ");
INSERT INTO epo_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Niaj infanoj, niaj edzinoj, niaj brutaroj, kaj ĉiuj niaj brutoj estos ĉi tie, en la urboj de Gilead; ");
INSERT INTO epo_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","sed viaj servantoj, ĉiuj armitaj militiste, iros antaŭ la Eternulo en la militon, kiel nia sinjoro diras. ");
INSERT INTO epo_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Kaj Moseo ordonis pri ili al la pastro Eleazar, kaj al Josuo, filo de Nun, kaj al la estroj de la triboj de la Izraelidoj; ");
INSERT INTO epo_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","kaj Moseo diris al ili: Se la filoj de Gad kaj la filoj de Ruben transiros kun vi Jordanon, ĉiuj armitaj por la milito antaŭ la Eternulo, kaj la lando estos militakirita antaŭ vi, tiam donu al ili la landon Gilead kiel posedaĵon; ");
INSERT INTO epo_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","sed se ili ne transiros kun vi armitaj, tiam ili ricevos posedaĵon inter vi en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Kaj la filoj de Gad kaj la filoj de Ruben respondis, dirante: Kion la Eternulo diris al viaj servantoj, tion ni faros. ");
INSERT INTO epo_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ni transiros armitaj antaŭ la Eternulo en la landon Kanaanan, kaj nia hereda posedaĵo estos sur ĉi tiu flanko de Jordan. ");
INSERT INTO epo_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Kaj Moseo donis al ili, al la filoj de Gad kaj al la filoj de Ruben, kaj al duono de la tribo de Manase, filo de Jozef, la regnon de Siĥon, reĝo de la Amoridoj, kaj la regnon de Og, reĝo de Baŝan, la landon kun ĝiaj urboj laŭ la limoj de la urboj de la lando ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Kaj la filoj de Gad rekonstruis Dibonon kaj Ataroton kaj Aroeron ");
INSERT INTO epo_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","kaj Atrot-Ŝofanon kaj Jazeron kaj Jogbehan ");
INSERT INTO epo_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","kaj Bet-Nimran kaj Bet-Haranon, fortikigitajn urbojn, kaj baraĵojn por ŝafoj. ");
INSERT INTO epo_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Kaj la filoj de Ruben rekonstruis Ĥeŝbonon kaj Elealen kaj Kirjataimon, ");
INSERT INTO epo_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","kaj Nebon kaj Baal-Meonon, kies nomojn oni ŝanĝis, kaj Sibman; kaj ili donis nomojn al la urboj, kiujn ili konstruis. ");
INSERT INTO epo_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Kaj la filoj de Maĥir, filo de Manase, iris Gileadon kaj militakiris ĝin, kaj forpelis la Amoridojn, kiuj estis tie. ");
INSERT INTO epo_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Kaj Moseo donis Gileadon al Maĥir, filo de Manase, kaj tiu ekloĝis tie. ");
INSERT INTO epo_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Kaj Jair, filo de Manase, iris kaj militakiris iliajn vilaĝojn, kaj li donis al ili la nomon Vilaĝoj de Jair. ");
INSERT INTO epo_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Kaj Nobaĥ iris kaj militakiris Kenaton kaj ĝiajn vilaĝojn, kaj donis al ĝi la nomon Nobaĥ, laŭ sia nomo. ");
INSERT INTO epo_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Jen estas la iroj de la Izraelidoj, per kiuj ili eliris el la lando Egipta, laŭ siaj taĉmentoj, sub la kondukado de Moseo kaj Aaron. ");
INSERT INTO epo_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Kaj Moseo priskribis iliajn lokojn de eliro, laŭ ilia irado, konforme al la ordono de la Eternulo; kaj jen estas ilia irado laŭ iliaj lokoj de eliro: ");
INSERT INTO epo_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","el Rameses ili eliris en la unua monato, en la dek-kvina tago de la unua monato; en la dua tago de Pasko la Izraelidoj eliris kun forta mano antaŭ la okuloj de la tuta Egiptujo. ");
INSERT INTO epo_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Dume la Egiptoj estis enterigantaj ĉiujn unuenaskitojn, kiujn la Eternulo mortigis inter ili; kaj super iliaj dioj la Eternulo faris juĝon. ");
INSERT INTO epo_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Kaj la Izraelidoj eliris el Rameses kaj haltis tendare en Sukot. ");
INSERT INTO epo_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Kaj ili eliris el Sukot, kaj haltis tendare en Etam, kiu estas ĉe la rando de la dezerto. ");
INSERT INTO epo_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Kaj ili eliris el Etam, kaj turnis sin al Pi-Haĥirot, kiu estas kontraŭ Baal-Cefon, kaj ili haltis tendare antaŭ Migdol. ");
INSERT INTO epo_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Kaj ili eliris el Pi-Haĥirot kaj transiris meze de la maro en la dezerton, kaj ili iris tritagan vojon tra la dezerto Etam kaj haltis tendare en Mara. ");
INSERT INTO epo_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Kaj ili eliris el Mara kaj venis Elimon; en Elim estis dek du fontoj de akvo kaj sepdek daktilaj palmoj, kaj ili haltis tie tendare. ");
INSERT INTO epo_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Kaj ili eliris el Elim kaj haltis tendare ĉe la Ruĝa Maro. ");
INSERT INTO epo_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Kaj ili foriris de la Ruĝa Maro kaj haltis tendare en la dezerto Sin. ");
INSERT INTO epo_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Kaj ili foriris el la dezerto Sin kaj haltis tendare en Dofka. ");
INSERT INTO epo_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Kaj ili eliris el Dofka kaj haltis tendare en Aluŝ. ");
INSERT INTO epo_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Kaj ili eliris el Aluŝ kaj haltis tendare en Refidim, kaj tie ne estis akvo por la popolo por trinki. ");
INSERT INTO epo_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Kaj ili eliris el Refidim kaj haltis en la dezerto Sinaj. ");
INSERT INTO epo_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Kaj ili eliris el la dezerto Sinaj kaj haltis tendare en Kibrot-Hataava. ");
INSERT INTO epo_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kaj ili eliris el Kibrot-Hataava kaj haltis tendare en Ĥacerot. ");
INSERT INTO epo_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Kaj ili eliris el Ĥacerot kaj haltis tendare en Ritma. ");
INSERT INTO epo_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Kaj ili eliris el Ritma kaj haltis tendare en Rimon-Perec. ");
INSERT INTO epo_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Kaj ili eliris el Rimon-Perec kaj haltis tendare en Libna. ");
INSERT INTO epo_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Kaj ili eliris el Libna kaj haltis tendare en Risa. ");
INSERT INTO epo_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Kaj ili eliris el Risa kaj haltis tendare en Kehelata. ");
INSERT INTO epo_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kaj ili eliris el Kehelata kaj haltis tendare ĉe la monto Ŝefer. ");
INSERT INTO epo_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Kaj ili foriris de la monto Ŝefer kaj haltis tendare en Ĥarada. ");
INSERT INTO epo_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Kaj ili eliris el Ĥarada kaj haltis tendare en Makhelot. ");
INSERT INTO epo_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Kaj ili eliris el Makhelot kaj haltis tendare en Taĥat. ");
INSERT INTO epo_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Kaj ili eliris el Taĥat kaj haltis tendare en Teraĥ. ");
INSERT INTO epo_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Kaj ili eliris el Teraĥ kaj haltis tendare en Mitka. ");
INSERT INTO epo_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Kaj ili eliris el Mitka kaj haltis tendare en Ĥaŝmona. ");
INSERT INTO epo_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Kaj ili eliris el Ĥaŝmona kaj haltis tendare en Moserot. ");
INSERT INTO epo_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Kaj ili eliris el Moserot kaj haltis tendare en Bene-Jaakan. ");
INSERT INTO epo_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Kaj ili eliris el Bene-Jaakan kaj haltis tendare en Ĥor-Hagidgad. ");
INSERT INTO epo_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Kaj ili eliris el Ĥor-Hagidgad kaj haltis tendare en Jotbata. ");
INSERT INTO epo_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Kaj ili eliris el Jotbata kaj haltis tendare en Abrona. ");
INSERT INTO epo_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Kaj ili eliris el Abrona kaj haltis tendare en Ecjon-Geber. ");
INSERT INTO epo_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Kaj ili eliris el Ecjon-Geber kaj haltis tendare en la dezerto Cin (tio estas Kadeŝ). ");
INSERT INTO epo_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kaj ili eliris el Kadeŝ, kaj haltis tendare ĉe la monto Hor, ĉe la rando de la lando de Edom. ");
INSERT INTO epo_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kaj la pastro Aaron supreniris sur la monton Hor laŭ la ordono de la Eternulo, kaj mortis tie en la jaro kvardeka post la eliro de la Izraelidoj el la lando Egipta, en la kvina monato, en la unua tago de la monato. ");
INSERT INTO epo_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Kaj Aaron havis la aĝon de cent dudek tri jaroj, kiam li mortis sur la monto Hor. ");
INSERT INTO epo_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Kaj la Kanaanido, la reĝo de Arad, kiu loĝis en la sudo de la lando Kanaana, aŭdis, ke venas la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Kaj ili foriris de la monto Hor kaj haltis tendare en Calmona. ");
INSERT INTO epo_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Kaj ili eliris el Calmona kaj haltis tendare en Punon. ");
INSERT INTO epo_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Kaj ili eliris el Punon kaj haltis tendare en Obot. ");
INSERT INTO epo_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Kaj ili eliris el Obot, kaj haltis tendare en Ije-Abarim, ĉe la limo de Moab. ");
INSERT INTO epo_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Kaj ili eliris el Ije-Abarim kaj haltis tendare en Dibon-Gad. ");
INSERT INTO epo_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Kaj ili eliris el Dibon-Gad kaj haltis tendare en Almon-Diblataim. ");
INSERT INTO epo_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Kaj ili eliris el Almon-Diblataim, kaj haltis tendare ĉe la montoj Abarim, antaŭ Nebo. ");
INSERT INTO epo_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Kaj ili foriris de la montoj Abarim, kaj haltis tendare en la stepoj de Moab, ĉe la Jeriĥa Jordan. ");
INSERT INTO epo_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Kaj ili aranĝis sian tendaron ĉe Jordan, de Bet-Jeŝimot ĝis Abel-Ŝitim, en la stepoj de Moab. ");
INSERT INTO epo_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Kaj la Eternulo ekparolis al Moseo en la stepoj de Moab ĉe la Jeriĥa Jordan, dirante: ");
INSERT INTO epo_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Parolu al la Izraelidoj, kaj diru al ili: Kiam vi transiros Jordanon en la landon Kanaanan, ");
INSERT INTO epo_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","tiam forpelu de antaŭ vi ĉiujn loĝantojn de la lando, kaj detruu ĉiujn iliajn figurojn, kaj ĉiujn iliajn fanditajn bildojn detruu, kaj ĉiujn iliajn altaĵojn ekstermu; ");
INSERT INTO epo_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","kaj ekposedu la landon kaj ekloĝu en ĝi, ĉar al vi Mi donas la landon, ke vi posedu ĝin. ");
INSERT INTO epo_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Kaj dispartigu al vi la landon per loto konforme al viaj familioj; al la plinombra donu pli grandan posedaĵon, kaj al la malplinombra donu malpli grandan posedaĵon; kie al iu trafos la loto, tie estu lia posedaĵo; laŭ la triboj de viaj patroj prenu al vi posedaĵojn. ");
INSERT INTO epo_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Sed se vi ne forpelos de antaŭ vi la loĝantojn de la lando, tiam tiuj, kiujn vi restigos el ili, estos dornoj por viaj okuloj kaj pikiloj por viaj flankoj, kaj ili premos vin en la lando, en kiu vi loĝos. ");
INSERT INTO epo_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Kaj tiam tion, kion Mi intencis fari al ili, Mi faros al vi. ");
INSERT INTO epo_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Ordonu al la Izraelidoj, kaj diru al ili: Kiam vi venos en la landon Kanaanan, tiu lando fariĝu via posedaĵo, la lando Kanaana laŭ siaj limoj. ");
INSERT INTO epo_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","La rando suda estu por vi de la dezerto Cin, apud Edom, kaj la suda limo estu por vi de la fino de la Sala Maro oriente; ");
INSERT INTO epo_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","kaj la suda limo turniĝos ĉe vi al la altaĵo Akrabim kaj iros tra Cin, kaj ĝiaj elstaraĵoj iros suden ĝis Kadeŝ-Barnea kaj atingos ĝis Ĥacar-Adar kaj pasos tra Acmon; ");
INSERT INTO epo_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","kaj de Acmon la limo turniĝos al la Egipta torento, kaj ĝiaj elstaraĵoj estos ĝis la maro. ");
INSERT INTO epo_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Kaj por okcidenta limo estu por vi la Granda Maro kiel limo; tio estos por vi la limo okcidenta. ");
INSERT INTO epo_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Kaj tia estu por vi la limo norda: de la Granda Maro vi tiros ĝin al vi ĝis la monto Hor; ");
INSERT INTO epo_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","de la monto Hor tiru ĝin ĝis Ĥamat, kaj la elstaraĵoj de la limo iros al Cedad; ");
INSERT INTO epo_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","kaj la limo iros ĝis Zifron, kaj ĝiaj elstaraĵoj iros ĝis Ĥacar-Enan; tio estu por vi la limo norda. ");
INSERT INTO epo_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Kaj la limon orientan vi tiros al vi de Ĥacar-Enan ĝis Ŝefam; ");
INSERT INTO epo_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","de Ŝefam la limo iros ĝis Ribla, orienten de Ain; poste la limo iros malsupren kaj tuŝos la bordon de la maro Kineret oriente; ");
INSERT INTO epo_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","kaj pluen la limo iros ĝis Jordan, kaj ĝiaj elstaraĵoj estos ĝis la Sala Maro. Tia estos via lando laŭ ĝiaj limoj ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Kaj Moseo ordonis al la Izraelidoj, dirante: Tio estas la lando, kiun vi dividos inter vi per loto kaj kiun la Eternulo ordonis doni al naŭ triboj kaj al duontribo; ");
INSERT INTO epo_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ĉar la tribo de la Rubenidoj laŭ iliaj patrodomoj, kaj la tribo de la Gadidoj laŭ iliaj patrodomoj, kaj duono de la tribo de la Manaseidoj prenis sian parton; ");
INSERT INTO epo_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","la du triboj kaj la duontribo prenis sian parton transe de la Jeriĥa Jordan, oriente, sur la flanko de sunleviĝo. ");
INSERT INTO epo_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Jen estas la nomoj de la viroj, kiuj disdividos inter vi la landon: Eleazar, la pastro, kaj Josuo, filo de Nun. ");
INSERT INTO epo_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Kaj po unu estro el ĉiu tribo prenu por la dividado de la lando. ");
INSERT INTO epo_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Kaj jen estas la nomoj de la viroj: por la tribo de Jehuda, Kaleb, file de Jefune; ");
INSERT INTO epo_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","kaj por la tribo de la Simeonidoj, Ŝemuel, filo de Amihud; ");
INSERT INTO epo_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","por la tribo de Benjamen, Elidad, filo de Kislon; ");
INSERT INTO epo_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","kaj por la tribo de la Danidoj, la estro Buki, filo de Jogli; ");
INSERT INTO epo_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","por la filoj de Jozef: por la tribo de la Manaseidoj, la estro Ĥaniel, filo de Efod, ");
INSERT INTO epo_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","kaj por la tribo de la Efraimidoj, la estro Kemuel, filo de Ŝiftan; ");
INSERT INTO epo_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","kaj por la tribo de la Zebulunidoj, la estro Elicafan, filo de Parnaĥ; ");
INSERT INTO epo_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","kaj por la tribo de la Isaĥaridoj, la estro Paltiel, filo de Azan; ");
INSERT INTO epo_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","kaj por la tribo de la Aŝeridoj, la estro Aĥihud, filo de Ŝelomi; ");
INSERT INTO epo_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","kaj por la tribo de la Naftaliidoj, la estro Pedahel, filo de Amihud. ");
INSERT INTO epo_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Tio estas tiuj, al kiuj la Eternulo ordonis, ke ili disdonu la posedaĵojn al la Izraelidoj en la lando Kanaana. ");
INSERT INTO epo_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Kaj la Eternulo ekparolis al Moseo en la stepoj de Moab ĉe la Jeriĥa Jordan, dirante: ");
INSERT INTO epo_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Ordonu al la Izraelidoj, ke ili donu al la Levidoj el siaj posedaĵoj urbojn por loĝi; ankaŭ la kampojn ĉirkaŭ tiuj urboj donu al la Levidoj. ");
INSERT INTO epo_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Kaj la urboj estos por ili por loĝi, kaj la kampoj estos por iliaj brutoj kaj por ilia havo kaj por ĉiuj iliaj bezonoj de la vivo. ");
INSERT INTO epo_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Kaj la kampoj de tiuj urboj, kiujn vi donos al la Levidoj, devas etendiĝi mil ulnojn ekster la muroj de la urboj ĉirkaŭe. ");
INSERT INTO epo_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Kaj mezuru ekster la urbo sur la orienta flanko du mil ulnojn kaj sur la suda flanko du mil ulnojn kaj sur la okcidenta flanko du mil ulnojn kaj sur la norda flanko du mil ulnojn, kaj la urbo estos en la mezo; tiaj estu por ili la kampoj de la urboj. ");
INSERT INTO epo_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Kaj el la urboj, kiujn vi donos al la Levidoj, estos ses urboj de rifuĝo, en kiujn vi al mortiginto permesos forkuri; kaj krom tiuj donu kvardek du urbojn. ");
INSERT INTO epo_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","La nombro de ĉiuj urboj, kiujn vi devas doni al la Levidoj, estas kvardek ok urboj kune kun iliaj kampoj. ");
INSERT INTO epo_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","La urbojn, kiujn vi donos el la posedaĵoj de la Izraelidoj, de la plimultaj prenu pli multe kaj de la malplimultaj prenu malpli multe; ĉiu konforme al sia posedaĵo, kiun li ricevos, devas doni el siaj urboj al la Levidoj. ");
INSERT INTO epo_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Kaj la Eternulo ekparolis al Moseo, dirante: ");
INSERT INTO epo_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Parolu al la Izraelidoj, kaj diru al ili: Kiam vi transiros Jordanon en la landon Kanaanan, ");
INSERT INTO epo_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","tiam elektu al vi urbojn, kiuj estu ĉe vi urboj de rifuĝo, kien povas forkuri mortiginto, kiu mortigis homon senintence. ");
INSERT INTO epo_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Kaj tiuj urboj estos ĉe vi rifuĝejo kontraŭ venĝanto, por ke ne mortu la mortiginto, antaŭ ol li staros antaŭ la komunumo por juĝo. ");
INSERT INTO epo_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Kaj el la urboj, kiujn vi donos, ses urboj de rifuĝo estu ĉe vi. ");
INSERT INTO epo_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tri urbojn donu transe de Jordan kaj tri urbojn donu en la lando Kanaana; urboj de rifuĝo ili estu. ");
INSERT INTO epo_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Por la Izraelidoj kaj por la fremdulo kaj por la pasloĝanto inter ili estu tiuj ses urboj por rifuĝo, por ke forkuru tien ĉiu, kiu mortigis homon senintence. ");
INSERT INTO epo_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Sed se per fera objekto li batis lin kaj ĉi tiu mortis, tiam li estas mortiginto; la mortiginton oni devas mortigi. ");
INSERT INTO epo_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Kaj se li batis lin per mana ŝtono, de kiu oni povas morti, kaj ĉi tiu mortis, tiam li estas mortiginto; la mortiginton oni devas mortigi. ");
INSERT INTO epo_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Aŭ se li batis lin per mana objekto ligna, de kiu oni povas morti, kaj ĉi tiu mortis, tiam li estas mortiginto; la mortiginton oni devas mortigi. ");
INSERT INTO epo_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","La venĝanto de la sango mem povas mortigi la mortiginton; kiam li renkontos lin, li povas mortigi lin. ");
INSERT INTO epo_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Se iu puŝis iun pro malamo aŭ sin kaŝinte ĵetis ion sur lin kaj ĉi tiu mortis, ");
INSERT INTO epo_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","aŭ se li malamike per sia mano batis lin kaj ĉi tiu mortis, tiam oni devas mortigi la batinton: li estas mortiginto; la venĝanto de la sango povas mortigi la mortiginton, kiam li renkontos lin. ");
INSERT INTO epo_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Sed se per hazardo kaj ne pro malamikeco li puŝis lin, aŭ se li ĵetis sur lin ian objekton sen malbonintenco, ");
INSERT INTO epo_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","aŭ se ŝtonon, de kiu oni povas morti, li ĵetis sur lin ne vidante, kaj ĉi tiu mortis, sed li ne estis lia malamiko kaj ne deziris al li malbonon: ");
INSERT INTO epo_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tiam la komunumo devas juĝi inter la batinto kaj la venĝanto de la sango laŭ ĉi tiuj leĝoj; ");
INSERT INTO epo_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","kaj la komunumo devas savi la mortiginton el la mano de la venĝanto de la sango, kaj la komunumo revenigos lin en lian urbon de rifuĝo, kien li forkuris; kaj li devas loĝi tie ĝis la morto de la granda pastro, kiu estas oleita per sankta oleo. ");
INSERT INTO epo_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Sed se la mortiginto eliris el la limoj de sia urbo de rifuĝo, kien li forkuris, ");
INSERT INTO epo_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","kaj la venĝanto de la sango trovis lin ekster la limoj de lia urbo de rifuĝo kaj la venĝanto de la sango mortigis la mortiginton, tiam li ne estas kulpa pri la sango; ");
INSERT INTO epo_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ĉar en sia urbo de rifuĝo li devas resti ĝis la morto de la granda pastro, kaj post la morto de la granda pastro la mortiginto povas reveni sur la teron de sia posedaĵo. ");
INSERT INTO epo_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Kaj tio estu por vi leĝa regulo en viaj generacioj, en ĉiuj viaj lokoj de loĝado. ");
INSERT INTO epo_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ĉiun, kiu mortigis homon, tiun mortiginton oni devas mortigi, se raportis pri li atestantoj; sed unu atestanto ne sufiĉas, por kondamni homon al morto. ");
INSERT INTO epo_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Ne prenu elaĉeton pro animo de mortiginto, kiu estas malbonagulo mortiginda; oni devas lin mortigi. ");
INSERT INTO epo_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Kaj ne prenu elaĉeton pro homo, kiu forkuris en urbon de rifuĝo, ke li povu reveni kaj loĝi sur sia tero antaŭ la morto de la pastro. ");
INSERT INTO epo_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Kaj ne malhonoru la teron, sur kiu vi estos, ĉar sango malhonoras la teron, kaj nur per la sango de tiu, kiu verŝis sangon, la tero povas puriĝi de la sango, kiu estas verŝita sur ĝi. ");
INSERT INTO epo_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Kaj ne malpurigu la landon, en kiu vi loĝas kaj en kies mezo Mi restas; ĉar Mi, la Eternulo, restas inter la Izraelidoj. ");
INSERT INTO epo_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Kaj aliris la familiestroj de la familio de Gilead, filo de Maĥir, filo de Manase, el la familioj de la Jozefidoj, kaj ekparolis antaŭ Moseo kaj antaŭ la eminentuloj, la familiestroj de la Izraelidoj; ");
INSERT INTO epo_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","kaj ili diris: Al nia sinjoro la Eternulo ordonis disdoni la teron kiel posedaĵon per loto al la Izraelidoj, kaj al nia sinjoro la Eternulo ordonis doni la parton de nia frato Celofĥad al liaj filinoj. ");
INSERT INTO epo_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Sed se ili fariĝos edzinoj de iu el la filoj de alia tribo de la Izraelidoj, tiam ilia posedaĵo estos forprenita el la posedaĵo de niaj patroj, kaj aliĝos al la posedaĵo de tiu tribo, al kiu ili ekapartenos, kaj el nia lote ricevita posedaĵo ĝi estos forprenita. ");
INSERT INTO epo_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Kaj kiam eĉ estos jubilea jaro ĉe la Izraelidoj, ilia posedaĵo restos aligita al la posedaĵo de tiu tribo, al kiu ili apartenos; kaj el la posedaĵo de la tribo de niaj patroj ilia posedaĵo restos forprenita. ");
INSERT INTO epo_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Tiam Moseo donis ordonon al la Izraelidoj laŭ la instrukcio de la Eternulo, dirante: Prave parolas la tribo de la Jozefidoj. ");
INSERT INTO epo_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Jen kion ordonis la Eternulo koncerne la filinojn de Celofĥad: Ili povas fariĝi edzinoj de tiuj, kiuj plaĉos al ili, sed nur en familio el la tribo de siaj patroj ili edziniĝu; ");
INSERT INTO epo_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","por ke ne transiru hereda posedaĵo de la Izraelidoj el unu tribo en alian tribon, ĉar ĉiu el la Izraelidoj devas resti fortike ĉe la posedaĵo de la tribo de liaj patroj. ");
INSERT INTO epo_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Kaj ĉiu filino, kiu heredas posedaĵon en la triboj de la Izraelidoj, devas edziniĝi kun iu el la familioj de la tribo de ŝia patro, por ke la Izraelidoj heredu ĉiu la posedaĵon de siaj patroj; ");
INSERT INTO epo_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","kaj por ke posedaĵo ne transiru el unu tribo en alian tribon, sed ĉiu tribo de la Izraelidoj restu fortike ĉe sia posedaĵo. ");
INSERT INTO epo_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Kiel la Eternulo ordonis al Moseo, tiel faris la filinoj de Celofĥad; ");
INSERT INTO epo_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","kaj Maĥla, Tirca kaj Ĥogla kaj Milka kaj Noa, la filinoj de Celofĥad, edziniĝis kun filoj de siaj onkloj. ");
INSERT INTO epo_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","En la familioj de la filoj de Manase, filo de Jozef, ili edziniĝis, kaj ilia posedaĵo restis en la tribo de la familio de ilia patro. ");
INSERT INTO epo_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Tio estas la ordonoj kaj la leĝoj, kiujn la Eternulo donis per Moseo al la Izraelidoj en la stepoj de Moab, ĉe la Jeriĥa Jordan. ");
INSERT INTO epo_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Jen estas la vortoj, kiujn diris Moseo al la tuta Izrael transe de Jordan, en la dezerto, en la stepo antaŭ Suf, inter Paran kaj Tofel kaj Laban kaj Ĥacerot kaj Di-Zahab, ");
INSERT INTO epo_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","dek unu tagojn malproksime de Ĥoreb, sur la vojo de la monto Seir al Kadeŝ-Barnea. ");
INSERT INTO epo_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Tio estis en la kvardeka jaro, en la dek-unua monato, en la unua tago de la monato, Moseo parolis al la Izraelidoj konforme al ĉio, kion la Eternulo ordonis al li por ili. ");
INSERT INTO epo_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Post kiam li venkobatis Siĥonon, la reĝon de la Amoridoj, kiu loĝis en Ĥeŝbon, kaj Ogon, la reĝon de Baŝan, kiu loĝis en Aŝtarot kaj en Edrei; ");
INSERT INTO epo_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","transe de Jordan, en la lando de Moab, Moseo komencis klarigi ĉi tiun instruon, kaj diris: ");
INSERT INTO epo_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","La Eternulo, nia Dio, diris al ni sur Ĥoreb jene: Sufiĉe vi loĝis sur ĉi tiu monto; ");
INSERT INTO epo_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","turniĝu kaj elmoviĝu, kaj iru sur la monton de la Amoridoj kaj al ĉiuj iliaj najbaroj en la stepo, sur la monto kaj en la valo kaj en la sudo kaj sur la bordo de la maro, en la landon de la Kanaanidoj kaj sur Lebanonon, ĝis la granda rivero, la rivero Eŭfrato. ");
INSERT INTO epo_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Vidu, Mi donas al vi la landon; iru kaj ekposedu la landon, pri kiu la Eternulo ĵuris al viaj patroj, al Abraham, al Isaak, kaj al Jakob, ke Li donos ĝin al ili kaj al ilia idaro post ili. ");
INSERT INTO epo_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Kaj mi diris al vi en tiu tempo jene: Mi ne povas sola porti vin; ");
INSERT INTO epo_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","la Eternulo, via Dio, multigis vin, kaj jen vi estas nun multego, kiel la steloj de la ĉielo. ");
INSERT INTO epo_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","La Eternulo, la Dio de viaj patroj, multigu vin miloble kontraŭ via nuna nombro, kaj Li benu vin, kiel Li diris al vi! ");
INSERT INTO epo_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kiel mi povus sola porti la penadon por vi kaj vian ŝarĝon kaj viajn disputojn? ");
INSERT INTO epo_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Elektu al vi el viaj triboj virojn saĝajn kaj kompetentajn kaj konatajn, kaj mi starigos ilin, kiel viajn estrojn. ");
INSERT INTO epo_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Kaj vi respondis al mi kaj diris: Bona estas la afero, kiun vi proponis fari. ");
INSERT INTO epo_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Tiam mi prenis la ĉefojn de viaj triboj, virojn saĝajn kaj konatajn, kaj mi faris ilin estroj super vi, milestroj kaj centestroj kaj kvindekestroj kaj dekestroj kaj kontrolistoj en viaj triboj. ");
INSERT INTO epo_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Kaj mi ordonis al viaj juĝistoj en tiu tempo, dirante: Aŭskultu viajn fratojn kaj juĝu juste inter homo kaj lia frato kaj fremdulo. ");
INSERT INTO epo_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ne distingu vizaĝojn ĉe la juĝo; malgrandan kaj grandan egale aŭskultu; timu neniun, ĉar la juĝo estas afero de Dio; kaj aferon, kiu estos malfacila por vi, venigu al mi, kaj mi ĝin aŭskultos. ");
INSERT INTO epo_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Kaj mi donis al vi ordonon en tiu tempo pri ĉio, kion vi devas fari. ");
INSERT INTO epo_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Kaj ni foriris de Ĥoreb, kaj trairis tiun tutan grandan kaj teruran dezerton, kiun vi vidis, sur la vojo al la monto de la Amoridoj, kiel ordonis al ni la Eternulo, nia Dio; kaj ni venis al Kadeŝ-Barnea. ");
INSERT INTO epo_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Kaj mi diris al vi: Vi venis al la monto de la Amoridoj, kiun la Eternulo, nia Dio, donas al ni; ");
INSERT INTO epo_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","vidu, la Eternulo, via Dio, donas al vi la landon; iru, ekposedu ĝin, kiel diris al vi la Eternulo, la Dio de viaj patroj; ne timu kaj ne tremu. ");
INSERT INTO epo_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Sed vi ĉiuj aliris al mi, kaj diris: Ni sendu antaŭ ni virojn, ke ili esploru por ni la landon, kaj alportu al ni sciigon pri la vojo, per kiu ni devas iri, kaj pri la urboj, al kiuj ni devas veni. ");
INSERT INTO epo_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Kaj tio plaĉis al mi, kaj mi prenis el vi dek du virojn, po unu viro el tribo; ");
INSERT INTO epo_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","kaj ili iris kaj supreniris sur la monton, kaj venis al la valo Eŝkol kaj esplorrigardis ĝin. ");
INSERT INTO epo_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Kaj ili prenis en siajn manojn iom el la fruktoj de la lando kaj liveris al ni, kaj alportis al ni sciigon, kaj diris: Bona estas la lando, kiun la Eternulo, nia Dio, donas al ni. ");
INSERT INTO epo_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Sed vi ne volis iri, kaj vi malobeis la vortojn de la Eternulo, via Dio; ");
INSERT INTO epo_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","kaj vi murmuris en viaj tendoj, kaj diris: Pro la malamo de la Eternulo kontraŭ ni, Li elkondukis nin el la lando Egipta, por transdoni nin en la manon de la Amoridoj, por ke ili ekstermu nin; ");
INSERT INTO epo_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","kien ni iru? Niaj fratoj ektimigis nian koron, dirante: La popolo estas pli granda kaj pli altkreska ol ni, la urboj estas grandaj kaj fortikigitaj ĝis la ĉielo, kaj ankaŭ Anakidojn ni tie vidis. ");
INSERT INTO epo_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Kaj mi diris al vi: Ne tremu kaj ne timu ilin; ");
INSERT INTO epo_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","la Eternulo via Dio, kiu iras antaŭ vi, Li batalos por vi, simile al ĉio, kion Li faris por vi en Egiptujo antaŭ viaj okuloj, ");
INSERT INTO epo_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","kaj en la dezerto, kie, kiel vi vidis, la Eternulo, via Dio, portis vin, kiel homo portas sian filon, sur la tuta vojo, kiun vi iris, ĝis vi venis al ĉi tiu loko. ");
INSERT INTO epo_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Sed eĉ ĉe tio vi ne fidas la Eternulon, vian Dion, ");
INSERT INTO epo_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","kiu iras antaŭ vi sur la vojo, por serĉi por vi lokon, kie vi povus halti tendare, nokte en fajro, por montri al vi la vojon, kiun vi devas iri, kaj tage en nubo. ");
INSERT INTO epo_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Kaj la Eternulo aŭdis viajn vortojn, kaj Li ekkoleris kaj ĵuris, dirante: ");
INSERT INTO epo_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Neniu el ĉi tiuj homoj, el ĉi tiu malbona generacio, vidos la bonan landon, kiun Mi ĵuris doni al viaj patroj; ");
INSERT INTO epo_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","nur Kaleb, filo de Jefune, vidos ĝin; kaj pro tio, ke li sekvis la Eternulon, Mi donos al li kaj al liaj filoj la landon, kiun li trairis. ");
INSERT INTO epo_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Ankaŭ kontraŭ mi la Eternulo ekkoleris pro vi, dirante: Vi ankaŭ ne venos tien; ");
INSERT INTO epo_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Josuo, filo de Nun, kiu staras antaŭ vi, li venos tien; lin fortigu, ĉar li donos ĝin al Izrael kiel posedaĵon. ");
INSERT INTO epo_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Kaj viaj infanoj, pri kiuj vi diris, ke ili fariĝos militakiraĵo, kaj viaj filoj, kiuj nun ankoraŭ ne scias bonon nek malbonon, ili venos tien, kaj al ili Mi donos ĝin, kaj ili ekposedos ĝin. ");
INSERT INTO epo_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Sed vi turniĝu, kaj iru en la dezerton en la direkto al la Ruĝa Maro. ");
INSERT INTO epo_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Kaj vi respondis kaj diris al mi: Ni pekis antaŭ la Eternulo; ni iros kaj batalos, konforme al ĉio, kion ordonis al ni la Eternulo, nia Dio; kaj ĉiu el vi zonis sin per siaj bataliloj, kaj vi pretigis vin, por iri sur la monton. ");
INSERT INTO epo_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Sed la Eternulo diris al mi: Diru al ili: Ne iru kaj ne batalu, ĉar Mi ne estas inter vi; por ke vi ne estu frapitaj de viaj malamikoj. ");
INSERT INTO epo_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Kaj mi diris al vi, sed vi ne aŭskultis; kaj vi malobeis la vortojn de la Eternulo, kaj vi estis malhumilaj kaj iris sur la monton. ");
INSERT INTO epo_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Tiam eliris kontraŭ vin la Amoridoj, kiuj loĝis sur tiu monto, kaj ili pelis vin tiel, kiel faras la abeloj, kaj batis vin sur Seir ĝis Ĥorma. ");
INSERT INTO epo_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Kaj vi revenis kaj ploris antaŭ la Eternulo; sed la Eternulo ne aŭskultis vian voĉon kaj ne atentis vin. ");
INSERT INTO epo_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Kaj vi loĝis en Kadeŝ longan tempon, la tempon, dum kiu vi loĝis. ");
INSERT INTO epo_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Kaj ni turnis nin kaj elmoviĝis en la dezerton en la direkto al la Ruĝa Maro, kiel la Eternulo diris al mi; kaj ni ĉirkaŭiris la monton Seir dum longa tempo. ");
INSERT INTO epo_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Kaj la Eternulo diris al mi jene: ");
INSERT INTO epo_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Sufiĉe vi ĉirkaŭiris ĉi tiun monton; turnu vin norden; ");
INSERT INTO epo_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","kaj al la popolo donu tian ordonon: Vi preteriros la limon de viaj fratoj la Esavidoj, kiuj loĝas sur Seir, kaj ili timos vin; sed gardu vin forte. ");
INSERT INTO epo_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Ne komencu batalon kontraŭ ili, ĉar Mi ne donos al vi el ilia lando eĉ larĝecon de plando; ĉar al Esav Mi donis, kiel heredaĵon, la monton Seir. ");
INSERT INTO epo_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Manĝaĵon aĉetu de ili pro mono kaj manĝu; kaj eĉ akvon aĉetu de ili pro mono kaj trinku; ");
INSERT INTO epo_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ĉar la Eternulo, via Dio, benis vin en ĉiu faro de viaj manoj; Li gvidis vian iradon tra ĉi tiu granda dezerto; jen jam kvardek jarojn la Eternulo estas kun vi, kaj nenio mankis al vi. ");
INSERT INTO epo_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Kaj ni preteriris flanke de niaj fratoj la Esavidoj, kiuj loĝas sur Seir, flanke de la vojo stepa, de Elat kaj de Ecjon-Geber. Kaj ni turnis nin kaj iris laŭ la vojo al la dezerto de Moab. ");
INSERT INTO epo_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Kaj la Eternulo diris al mi: Ne faru malamikaĵon al Moab kaj ne komencu militon kontraŭ ili, ĉar Mi ne donos al vi heredaĵon el ilia lando; ĉar al la filoj de Lot Mi donis Aron kiel heredan posedaĵon. ");
INSERT INTO epo_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","La Emidoj antaŭe loĝis tie, popolo granda kaj grandnombra, kaj altkreska kiel la Anakidoj. ");
INSERT INTO epo_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Ankaŭ ilin oni kalkulis inter la Rafaidoj, kiel la Anakidojn; kaj la Moabidoj nomas ilin Emidoj. ");
INSERT INTO epo_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Kaj sur Seir loĝis antaŭe la Ĥoridoj; sed la Esavidoj forpelis ilin kaj ekstermis ilin de antaŭ si kaj ekloĝis sur ilia loko, kiel agis Izrael kun la lando de sia posedaĵo, kiun la Eternulo donis al ili.) ");
INSERT INTO epo_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Nun leviĝu kaj transiru la valon Zared. Kaj ni transiris la valon Zared. ");
INSERT INTO epo_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Kaj la tempo, dum kiu ni iris de Kadeŝ-Barnea, ĝis ni transiris la valon Zared, estis tridek ok jaroj, ĝis formortis el la tendaro la tuta generacio de militistoj, kiel ĵuris al ili la Eternulo. ");
INSERT INTO epo_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Kaj ankaŭ la mano de la Eternulo estis sur ili, por ekstermi ilin el inter la tendaro, ĝis ili ĉiuj formortis. ");
INSERT INTO epo_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Kaj kiam formortis ĉiuj militistoj el inter la popolo, ");
INSERT INTO epo_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","tiam la Eternulo ekparolis al mi, dirante: ");
INSERT INTO epo_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Vi iras nun preter la limo de Moab, preter Ar, ");
INSERT INTO epo_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","kaj vi alproksimiĝas al la Amonidoj; ne faru al ili malamikaĵon kaj ne batalu kontraŭ ili, ĉar Mi ne donos al vi heredaĵon el la lando de la Amonidoj; ĉar al la filoj de Lot Mi donis ĝin kiel heredan posedaĵon. ");
INSERT INTO epo_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Kiel landon de Rafaidoj oni rigardas ankaŭ ĝin; Rafaidoj loĝis en ĝi antaŭe; kaj la Amonidoj nomas ilin Zamzumoj; ");
INSERT INTO epo_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","tio estis popolo granda kaj grandnombra, kaj altkreska kiel la Anakidoj; sed la Eternulo ekstermis ilin antaŭ ili, kaj ili forpelis ilin kaj ekloĝis sur ilia loko; ");
INSERT INTO epo_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","kiel Li faris por la Esavidoj, kiuj loĝas sur Seir, antaŭ kiuj Li ekstermis la Ĥoridojn, kaj ili forpelis ilin kaj loĝis sur ilia loko ĝis la nuna tago. ");
INSERT INTO epo_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Kaj la Avidojn, kiuj loĝis en vilaĝoj ĝis Gaza, ekstermis la Kaftoridoj, kiuj eliris el Kaftor, kaj ili ekloĝis sur ilia loko.) ");
INSERT INTO epo_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Leviĝu, elmoviĝu kaj transiru la torenton Arnon; rigardu, Mi transdonas en vian manon Siĥonon, la reĝon de Ĥeŝbon, la Amoridon, kaj lian landon; komencu ekposedi kaj militu kontraŭ li. ");
INSERT INTO epo_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","De la nuna tago Mi komencos ĵetadi teruron kaj timon antaŭ vi sur la popolojn sub la tuta ĉielo; tiuj, kiuj aŭdos la famon pri vi, ektremos kaj ektimos antaŭ vi. ");
INSERT INTO epo_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Kaj mi sendis senditojn el la dezerto Kedemot al Siĥon, la reĝo de Ĥeŝbon, kun vortoj de paco, dirante: ");
INSERT INTO epo_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Mi dezirus iri tra via lando; mi iros nur laŭ la vojo, mi ne forflankiĝos dekstren nek maldekstren; ");
INSERT INTO epo_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","manĝaĵon vendu al mi pro mono, kaj mi manĝos, kaj akvon donu al mi pro mono, kaj mi trinkos: nur per miaj piedoj mi trairos — ");
INSERT INTO epo_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","kiel faris al mi la Esavidoj, kiuj loĝas sur Seir, kaj la Moabidoj, kiuj loĝas en Ar — ĝis mi transiros Jordanon en la landon, kiun la Eternulo, nia Dio, donas al ni. ");
INSERT INTO epo_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Sed ne volis Siĥon, la reĝo de Ĥeŝbon, tralasi nin, ĉar la Eternulo, via Dio, obstinigis lian spiriton kaj malcedemigis lian koron, por transdoni lin en vian manon, kiel nun. ");
INSERT INTO epo_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Kaj la Eternulo diris al mi: Rigardu, Mi komencas transdoni al vi Siĥonon kaj lian landon; komencu posedpreni lian landon. ");
INSERT INTO epo_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Kaj Siĥon eliris kontraŭ nin, li kaj lia tuta popolo, por batalo apud Jahac. ");
INSERT INTO epo_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Kaj transdonis lin la Eternulo, nia Dio, al ni, kaj ni venkobatis lin kaj liajn filojn kaj lian tutan popolon. ");
INSERT INTO epo_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Kaj ni militakiris en tiu tempo ĉiujn liajn urbojn, kaj ni ekstermis en ĉiu urbo la virojn kaj la virinojn kaj la infanojn, ni restigis neniun; ");
INSERT INTO epo_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","nur la brutojn ni prenis al ni, kiel militakiraĵon, kaj la rabaĵon el la urboj, kiujn ni militakiris. ");
INSERT INTO epo_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","De Aroer, kiu estas sur la bordo de la torento Arnon, kaj la urbo, kiu estas en la valo, ĝis Gilead ne estis urbo, kiu povus kontraŭstari al ni: ĉion transdonis al ni la Eternulo, nia Dio; ");
INSERT INTO epo_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","nur al la lando de la Amonidoj vi ne alproksimiĝis, al la tuta bordo de la torento Jabok, kaj al la urboj de la monto, kaj al ĉio, pri kio malpermesis la Eternulo, nia Dio. ");
INSERT INTO epo_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Kaj ni turnis nin kaj ekiris laŭ la vojo al Baŝan. Kaj eliris kontraŭ nin Og, la reĝo de Baŝan, li kaj lia tuta popolo, por batalo apud Edrei. ");
INSERT INTO epo_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Kaj la Eternulo diris al mi: Ne timu lin; ĉar en vian manon Mi transdonis lin kaj lian tutan popolon kaj lian landon, kaj vi faros al li, kiel vi faris al Siĥon, la reĝo de la Amoridoj, kiu loĝis en Ĥeŝbon. ");
INSERT INTO epo_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Kaj la Eternulo, nia Dio, transdonis en nian manon ankaŭ Ogon, la reĝon de Baŝan, kaj lian tutan popolon; kaj ni batis lin tiel, ke neniu restis ĉe li. ");
INSERT INTO epo_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Kaj ni militakiris tiam ĉiujn liajn urbojn; ne estis urbo, kiun ni ne prenis de ili: sesdek urbojn, la tutan distrikton de Argob, la regnon de Og la Baŝana. ");
INSERT INTO epo_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Ĉiuj tiuj urboj estis fortikigitaj per alta muro, per pordegoj kaj rigliloj, krom la tre multaj urboj ne fortikigitaj. ");
INSERT INTO epo_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Kaj ni ekstermis ilin, kiel ni faris al Siĥon, la reĝo de Ĥeŝbon, ni ekstermis en ĉiu urbo la virojn, la virinojn, kaj la infanojn; ");
INSERT INTO epo_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","sed ĉiujn brutojn kaj la rabaĵon el la urboj ni prenis al ni, kiel militakiraĵon. ");
INSERT INTO epo_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Kaj ni prenis tiam el la manoj de la du reĝoj de la Amoridoj la landon, kiu estas transe de Jordan, de la torento Arnon ĝis la monto Ĥermon ");
INSERT INTO epo_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","la Cidonanoj nomas Ĥermonon Sirjon, kaj la Amoridoj nomas ĝin Senir), ");
INSERT INTO epo_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ĉiujn urbojn sur la ebenaĵo, kaj la tutan Gileadon kaj la tutan Baŝanon ĝis Salĥa kaj Edrei, urboj de la regno de Og la Baŝana. ");
INSERT INTO epo_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Ĉar nur Og, la reĝo de Baŝan, estis restinta el la resto de la Rafaidoj. Jen estas lia lito, fera lito, jen ĝi estas en Raba de la Amonidoj: naŭ ulnoj estas ĝia longeco kaj kvar ulnoj estas ĝia larĝeco, laŭ la ulnoj de viro.) ");
INSERT INTO epo_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Kaj tiun landon ni ekposedis en tiu tempo: de Aroer, kiu estas apud la torento Arnon, kaj duonon de la monto Gilead kun ĝiaj urboj mi donis al la Rubenidoj kaj al la Gadidoj; ");
INSERT INTO epo_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","kaj la ceteran parton de Gilead kaj la tutan Baŝanon, la regnon de Og, mi donis al duono de la tribo de Manase, la tutan distrikton de Argob. (La tutan tiun Baŝanon oni nomas lando de Rafaidoj. ");
INSERT INTO epo_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jair, filo de Manase, prenis la tutan distrikton de Argob ĝis la limo de la Geŝuridoj kaj Maaĥatidoj, kaj li donis al Baŝan laŭ sia nomo la nomon Vilaĝoj de Jair, tiel estas ĝis nun.) ");
INSERT INTO epo_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Kaj al Maĥir mi donis Gileadon. ");
INSERT INTO epo_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Kaj al la Rubenidoj kaj al la Gadidoj mi donis de Gilead ĝis la torento Arnon, kun la mezo de la valo por limo; ankaŭ ĝis la torento Jabok, limo de la Amonidoj; ");
INSERT INTO epo_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","kaj la stepon, kun Jordan por limo, de Kineret ĝis la maro de la ebenaĵo, la Sala Maro, ĉe la bazo de Pisga en la oriento. ");
INSERT INTO epo_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Kaj mi faris al vi ordonon en tiu tempo, dirante: La Eternulo, via Dio, donis al vi ĉi tiun landon, por ke vi posedu ĝin; armitaj iru antaŭ viaj fratoj la Izraelidoj, ĉiuj militkapablaj. ");
INSERT INTO epo_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Nur viaj edzinoj kaj viaj infanoj kaj viaj brutaroj — mi scias, ke vi havas grandnombrajn brutarojn — restu en viaj urboj, kiujn mi donis al vi; ");
INSERT INTO epo_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ĝis la Eternulo donos ripozon al viaj fratoj, kiel al vi, kaj ili ankaŭ ekposedos la landon, kiun la Eternulo, via Dio, donas al ili transe de Jordan; tiam vi reiros ĉiu al sia posedaĵo, kiun mi donis al vi. ");
INSERT INTO epo_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Kaj al Josuo mi ordonis en tiu tempo, dirante: Viaj okuloj vidis ĉion, kion la Eternulo, via Dio, faris al tiuj du reĝoj; tiel la Eternulo faros al ĉiuj regnoj, kiujn vi trairos. ");
INSERT INTO epo_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ne timu ilin; ĉar la Eternulo, via Dio, batalas por vi. ");
INSERT INTO epo_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Kaj mi preĝis al la Eternulo en tiu tempo, dirante: ");
INSERT INTO epo_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Mia Sinjoro, ho Eternulo! Vi komencis montradi al Via servanto Vian grandecon kaj Vian fortan manon; ĉar kie estas dio en la ĉielo aŭ sur la tero, kiu povus fari simile al Viaj faroj kaj al Via potenco? ");
INSERT INTO epo_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Mi dezirus transiri kaj vidi tiun bonan landon, kiu estas transe de Jordan, tiun belan monton kaj Lebanonon. ");
INSERT INTO epo_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Sed la Eternulo ekkoleris kontraŭ mi pro vi kaj ne aŭskultis min; kaj la Eternulo diris al mi: Sufiĉe, ne parolu al Mi plu pri tio. ");
INSERT INTO epo_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Supreniru sur la supron de Pisga, kaj direktu viajn okulojn al okcidento kaj al nordo kaj al sudo kaj al oriento kaj rigardu per viaj okuloj; ĉar vi ne transiros ĉi tiun Jordanon. ");
INSERT INTO epo_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Kaj donu instrukciojn al Josuo kaj fortigu kaj kuraĝigu lin, ĉar li transiros antaŭ ĉi tiu popolo, kaj li posedigos al ili la landon, kiun vi vidos. ");
INSERT INTO epo_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Kaj ni restis en la valo, kontraŭ Bet-Peor. ");
INSERT INTO epo_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Kaj nun, ho Izrael, aŭskultu la leĝojn kaj la regulojn, kiujn mi instruas al vi, ke vi ilin plenumu, por ke vi vivu kaj venu kaj heredu la landon, kiun la Eternulo, la Dio de viaj patroj, donas al vi. ");
INSERT INTO epo_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ne aldonu al tio, kion mi ordonas al vi, kaj ne deprenu de ĝi; sed observu la ordonojn de la Eternulo, via Dio, kiujn mi ordonas al vi. ");
INSERT INTO epo_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Viaj okuloj vidis, kion la Eternulo faris pro Baal-Peor; ĉar ĉiun homon, kiu sekvis Baal-Peoron, la Eternulo, via Dio, ekstermis el inter vi; ");
INSERT INTO epo_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","sed vi, kiuj restis aliĝintaj al la Eternulo, via Dio, vi ĉiuj vivas hodiaŭ. ");
INSERT INTO epo_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Rigardu, mi instruis al vi leĝojn kaj regulojn, kiel ordonis al mi la Eternulo, mia Dio, ke vi agu tiel en la lando, en kiun vi venas, por ekposedi ĝin. ");
INSERT INTO epo_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Kaj observu kaj plenumu ilin; ĉar tio estas via saĝo kaj via prudento en la okuloj de la popoloj, kiuj aŭdos pri ĉiuj ĉi tiuj leĝoj, kaj diros: Efektive, popolo saĝa kaj prudenta estas tiu granda popolo. ");
INSERT INTO epo_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ĉar kie estas granda popolo, al kiu dioj estas tiel proksimaj, kiel la Eternulo, nia Dio, ĉiufoje, kiam ni vokas al Li? ");
INSERT INTO epo_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Kaj kie estas granda popolo, kiu havas leĝojn kaj regulojn justajn, kiel la tuta ĉi tiu instruo, kiun mi donas al vi hodiaŭ? ");
INSERT INTO epo_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Nur gardu vin kaj forte gardu vian animon, ke vi ne forgesu la aferojn, kiujn vidis viaj okuloj, kaj ke ili ne eliru el via koro dum via tuta vivo; kaj rakontu al viaj filoj kaj al la filoj de viaj filoj ");
INSERT INTO epo_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","pri la tago, en kiu vi staris antaŭ la Eternulo, via Dio, ĉe Ĥoreb, kiam la Eternulo diris al mi: Kunvenigu al Mi la popolon, kaj Mi aŭdigos al ili Miajn vortojn, per kiuj ili lernos timi Min dum la tuta tempo, kiun ili vivas sur la tero, kaj ili lernigos siajn filojn. ");
INSERT INTO epo_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Tiam vi alproksimiĝis kaj stariĝis ĉe la bazo de la monto, kaj la monto brulis per fajro ĝis la mezo de la ĉielo, en mallumo, nubo, kaj nebulo. ");
INSERT INTO epo_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Kaj la Eternulo parolis al vi el meze de la fajro; la voĉon de la vortoj vi aŭdis, sed figuron vi ne vidis, nur la voĉon. ");
INSERT INTO epo_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Kaj Li sciigis al vi Sian interligon, kiun Li ordonis al vi plenumi, la dek ordonojn; kaj Li skribis ilin sur du ŝtonaj tabeloj. ");
INSERT INTO epo_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Kaj al mi la Eternulo en tiu tempo ordonis instrui al vi la leĝojn kaj regulojn, por ke vi plenumadu ilin en la lando, en kiun vi iras, por ekposedi ĝin. ");
INSERT INTO epo_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Gardu do bone viajn animojn: ĉar vi vidis nenian figuron en tiu tago, kiam la Eternulo parolis al vi sur Ĥoreb el meze de la fajro; ");
INSERT INTO epo_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","vi do ne malĉastiĝu, kaj ne faru al vi ian skulptaĵon, bildon de ia idolo, figuron de viro aŭ virino, ");
INSERT INTO epo_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","figuron de ia bruto, kiu estas sur la tero, figuron de ia flugilhava birdo, kiu flugas sub la ĉielo, ");
INSERT INTO epo_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","figuron de io, kio rampas sur la tero, figuron de ia fiŝo, kiu estas en akvo, malsupre de la tero. ");
INSERT INTO epo_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Kaj, levinte viajn okulojn al la ĉielo kaj vidinte la sunon kaj la lunon kaj la stelojn kaj la tutan armeon de la ĉielo, ne forlogiĝu, kaj ne adorkliniĝu antaŭ ili kaj ne servu ilin, kiujn la Eternulo, via Dio, destinis por ĉiuj popoloj sub la tuta ĉielo. ");
INSERT INTO epo_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Kaj vin la Eternulo prenis, kaj elkondukis vin el la fera forno, el Egiptujo, por ke vi estu al Li popolo herede apartenanta, kiel nun. ");
INSERT INTO epo_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Kaj la Eternulo ekkoleris min pro vi, kaj ĵuris, ke mi ne transiros Jordanon, kaj mi ne venos en la bonan landon, kiun la Eternulo, via Dio, donas al vi kiel posedaĵon; ");
INSERT INTO epo_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ĉar mi mortos en ĉi tiu lando, mi ne transiros Jordanon, sed vi transiros kaj ekposedos tiun bonan landon. ");
INSERT INTO epo_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Gardu vin, ke vi ne forgesu la interligon de la Eternulo, via Dio, kiun Li faris kun vi, kaj ke vi ne faru al vi ian skulptaĵon, figuron de io, kiel ordonis al vi la Eternulo, via Dio. ");
INSERT INTO epo_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Ĉar la Eternulo, via Dio, estas fajro konsumanta, Dio severa. ");
INSERT INTO epo_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Se vi naskos filojn kaj filojn de filoj, kaj, longe vivinte sur la tero, vi malĉastiĝos kaj faros skulptitan figuron de io kaj faros malbonon antaŭ la okuloj de la Eternulo, via Dio, kolerigante Lin: ");
INSERT INTO epo_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","mi atestigas al vi hodiaŭ la ĉielon kaj la teron, ke vi rapide pereos de sur la tero, por kies ekposedo vi transiras Jordanon; ne longe vi loĝos sur ĝi, sed vi estos ekstermitaj. ");
INSERT INTO epo_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Kaj la Eternulo dissemos vin inter la popoloj, kaj vi restos en malgranda nombro inter la popoloj, al kiuj la Eternulo vin foririgos. ");
INSERT INTO epo_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Kaj vi servos tie al dioj, kiuj estas faritaĵo de homaj manoj, ligno kaj ŝtono, kiuj ne vidas kaj ne aŭdas kaj ne manĝas kaj ne flaras. ");
INSERT INTO epo_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Kaj vi serĉos el tie la Eternulon, vian Dion; kaj vi trovos, se vi serĉos Lin per via tuta koro kaj per via tuta animo. ");
INSERT INTO epo_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Kiam vi estos en mizero kaj kiam vin trafos ĉio ĉi tio en la malproksima venonta tempo, tiam vi revenos al la Eternulo, via Dio, kaj vi aŭskultos Lian voĉon; ");
INSERT INTO epo_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ĉar la Eternulo, via Dio, estas Dio kompatema; Li ne forlasos vin nek pereigos vin, kaj ne forgesos la interligon kun viaj patroj, pri kiu Li ĵuris al ili. ");
INSERT INTO epo_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ĉar demandu la tempojn antaŭajn, kiuj estis antaŭ vi de post tiu tago, en kiu la Eternulo kreis homon sur la tero, kaj de unu rando de la ĉielo ĝis la alia rando: Ĉu estis io, kiel ĉi tiu granda afero, aŭ ĉu oni aŭdis pri io simila? ");
INSERT INTO epo_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ĉu aŭdis la popolo la voĉon de Dio, parolantan el meze de fajro, kiel vi aŭdis, kaj restis vivanta? ");
INSERT INTO epo_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Aŭ ĉu provis ia dio iri kaj preni al si unu popolon el inter alia popolo per provoj, per signoj, kaj per mirakloj, kaj per milito kaj per forta mano kaj per etendita brako kaj per grandaj teruraĵoj, simile al ĉio, kion faris al vi la Eternulo, via Dio, en Egiptujo, antaŭ viaj okuloj? ");
INSERT INTO epo_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Al vi tio estis montrita, por ke vi sciu, ke la Eternulo estas Dio, ke ne ekzistas alia krom Li. ");
INSERT INTO epo_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","El la ĉielo Li aŭdigis al vi Sian voĉon, por instrui vin, kaj sur la tero Li montris al vi Sian grandan fajron, kaj Liajn vortojn vi aŭdis el meze de la fajro. ");
INSERT INTO epo_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Kaj ĉar Li amis viajn patrojn, tial Li elektis ilian idaron post ili, kaj elkondukis vin per Sia vizaĝo, per Sia granda forto el Egiptujo, ");
INSERT INTO epo_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","por forpeli de antaŭ vi popolojn, kiuj estas pli grandaj kaj pli fortaj ol vi, por envenigi vin kaj doni al vi ilian landon kiel posedaĵon, kiel nun. ");
INSERT INTO epo_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Sciu do nun kaj enmetu en vian koron, ke la Eternulo estas Dio en la ĉielo supre kaj sur la tero malsupre; ne ekzistas alia. ");
INSERT INTO epo_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Kaj observu Liajn leĝojn kaj Liajn ordonojn, kiujn mi ordonas al vi hodiaŭ, por ke estu bone al vi kaj al viaj filoj post vi, kaj por ke vi longe vivu sur la tero, kiun la Eternulo, via Dio, donas al vi por ĉiam. ");
INSERT INTO epo_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Tiam Moseo apartigis tri urbojn transe de Jordan, sur la flanko de sunleviĝo, ");
INSERT INTO epo_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","por ke tien forkuru mortiginto, kiu mortigis sian proksimulon senintence, ne estinte malamika al li de antaŭe, kaj forkurinte al unu el tiuj urboj, li restu viva: ");
INSERT INTO epo_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Becer en la dezerto, sur la ebenaĵo, por la Rubenidoj, kaj Ramot en Gilead por la Gadidoj, kaj Golan en Baŝan por la Manaseidoj. ");
INSERT INTO epo_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Kaj jen estas la instruo, kiun Moseo proponis al la Izraelidoj; ");
INSERT INTO epo_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","jen estas la atestoj kaj la leĝoj kaj la reguloj, kiujn Moseo eldiris al la Izraelidoj post ilia eliro