﻿USE sofia;
DROP TABLE IF EXISTS sofia.enq2_vpl;
CREATE TABLE enq2_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES enq2_vpl WRITE;
INSERT INTO enq2_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Pii dake Jisasa Kraisanya yumbange paliu epeami dupanya pepa pyapae doko. Jisasa baa Dapita ikiningi. Dapita baa Abraame ikiningi. ");
INSERT INTO enq2_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraameme Aisake mandea. Aisakeme Jekope mandea. Jekopeme Judapi, Judanya kaiminingipi dupa mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judame Peresapa, Serapa dolapo mandea. Dolaponya endangi doko Tama lenge. Peresame Esorone mandea. Esoroneme Ramo mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramoame Aminadape mandea. Aminadapeme Nasone mandea. Nasoneme Salomone mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomoneme Boasa mandea. Boasa endangi doko Reapa lenge. Boasame Obeta mandea. Obeta endangi doko Ruta lenge. Obetame Jesi mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesiame Kiŋi Dapita mandea. Kiŋi Dapitame Solomone mandea. Solomone endangi doko wamba Uria etanenge doko. ");
INSERT INTO enq2_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoneme Reoboame mandea. Reoboameme Abaija mandea. Abaijame Esa mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esame Jeosapata mandea. Jeosapatame Jorame mandea. Jorameme Usia mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiame Jotame mandea. Jotameme Easa mandea. Easame Esekia mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiame Manase mandea. Manaseame Emone mandea. Emoneme Josaeya mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaeyame Jekonaeyapi, Jekonaeyanya kaiminingipi dupa mandea. Dokopa Babilone tange amii dupame Israele dupa yanda pyoo ita miniami. Dopa petala, dokaita anjetala Babilone laminao peami. ");
INSERT INTO enq2_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dokaita anjetala Babilone laminao pateaminopa, Jekonaeyame Setele mandea. Seteleme Serubabele mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeleme Abiuta mandea. Abiutame Eliakimi mandea. Eliakimimi Asoa mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoame Sadoko mandea. Sadokome Akimi mandea. Akimimi Eliuta mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutame Eleasa mandea. Eleasame Matane mandea. Mataneme Jekope mandea. ");
INSERT INTO enq2_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopeme Josepe mandea. Josepe doko Maria akalingi. Mariame Jisasa mandea. Jisasa doko Kraisa lengema. ");
INSERT INTO enq2_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dopana, Abraame katea gii dokonya pituu, Dapita katea gii dokonya tuu lao, yumbange paliu epeami dupa 14 paleami. Dapita katea gii dokonya pituu, Israele dupa anjetala laminao Babilone peami gii dokonya tuu lao, yumbange paliu epeami dupa 14 paleami. Israele dupa anjetala Babilone laminao peami gii dokonya pituu, Kraisa doko mandea gii dokonya tuu lao, yumbange paliu epeami dupa 14-aka paleami-pyaa. ");
INSERT INTO enq2_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisasa Kraisa mandea doko dapa pyoo mandea: Jisasa endangi Maria doko Josepe nyetana latala, andaka joo lakuu petengemba. Dolapo enda akalipa lao pilya naeyambinopa, Maria wane tongota peteamo kandeami. Wane doko Oli Spiritame maiya. ");
INSERT INTO enq2_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Marianya akalingi Josepe doko akali tolatae dokonyana, endakali dupanya enombanya baame Maria elya pisala naeyatoo lao masia. Dopa lao masetala, baame enda doko endakalimi nakandena lao kaeyatoana lao masia. ");
INSERT INTO enq2_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dopa lao masoo kateamopa, Kamongonya enjele mende ipupala kombeame baa lamaiyoo, “Dapita ikiningi Josepe, Marianya inginya wane pilyamo doko Oli Spiritame maipyana, Maria baa embanya enda jina lao lanyalanya paka nakaeyape. ");
INSERT INTO enq2_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Baame wane ane mende mandita. Wane dokome baanya endakali dupa nyakamanya koo dupanya pyoo nyetana, embame baanya kenge doko Jisasa lape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Dupa pitaka pia dokome, Kamongome propeta mende-kisa lao pituu, “Salapape! Wanaku mapukae, akali tole napingi mende, wane tongota pitipala wane ane mende mandita. Wane dokonya kenge doko Emanuele latamina” lapae singi doko angi jia. (Emanuele dokonya tenge doko, Gote naima-pipa katenge.) ");
INSERT INTO enq2_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josepe paliu sakatatala, Kamongonya enjele dokome lamaiyali pyoo, Maria baa baanya enda jina lao lanyia. ");
INSERT INTO enq2_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Dopaka doko, baa enda dokopa yonge tole napiambinopa, baanya wane ane mupa doko mandea. Mandipiamopa Josepeme wane doko kenge Jisasa lea. ");
INSERT INTO enq2_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erote baa kiŋi katea gii dokopa, Jisasa baa yuu andake Judia, taono Betelema dokonya mandea. Mandipiamopa niki pyakaengesa tange akali masepae singi mendapu Jerusalema ipupala, endakali dupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juumanya kiŋi katapengena latae, wane ŋaŋa dokonya bui doko niki pyakaengesa-kaita katamupa naimame kandatala, baa mambo pyala epelyamanona, wane doko anja mandipae silyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dopa lelyamino lapae doko Kiŋi Eroteme sepala, baa masepae longo nyia. Jerusalema tange endakali dupa pitakame sepala, masepae longo nyiamiaka. ");
INSERT INTO enq2_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Israele dupanya prisa mupapi, Mosesanya loo mana nyepaepi, dupa pitaka Eroteme epena lao nyoo kambu pia. Kambu pyatala dokaita tipa pyoo, “Kraisa doko yuu andukunya mandipengepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Dopa leamopa dokaitame pii yanu pyao, “Goteme propeta mende-kisa pii mende lea doko dapa lao pepa pyapae silyamo: ‘Yuu Juda dokonya taono Betelema tange dupa, nyakamanya taono doko taono waka Juda silyamo dupanya pundipundi nasilyamo, etete daa. Nyakamanya mandipaenya mandipae dupanya isingi akali mende pyakalyeta dokome nambanya Israele endakali dupa setao katakatana’ lao pepa pyapae silyamo. Dokonya, Kraisa doko yuu Judia dokonya taono Betelema mandipengena” leami. ");
INSERT INTO enq2_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dopa lateaminopa, Eroteme niki pyakaengesa tange akali masepae singi dupa waa katao epena latala, bui doko gii andukupa katapyape lao pii nyalanya tipa pia. ");
INSERT INTO enq2_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dopa petala, dokaita Betelema pena latala lamaiyoo, “Nyakama pupala, wane doko kutakondape pyoo kutalapape. Kutao kandatala dokopa, nambame apata mambo pyala patona, langya ipupape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dopa lateamopa, kiŋi dokonya pii dupa sepala dokaita peami. Peaminopa, niki pyakaengesa-kaita wamba bui kateamopa kandeami dokoaka wambao pao, wane mandipae sia dokonya katea. ");
INSERT INTO enq2_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kateamopa dokaitame bui doko kandatala, etete eteke piami. ");
INSERT INTO enq2_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eteke pyao andaka kolandatala, wane doko baanya endangi Mariapa peteambino kandeami. Kandatala akali dupa luma lakapala, wane doko mambo piami. Mambo pyapala, dokaitanya nuu dupa tangupala, golopi, kena tunduma pingi pautapi, wele epe tunduma pipaepi, dupa baa opaa maiyami. ");
INSERT INTO enq2_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Maitiaminopa Goteme akali dokaita Erote kalyamo dokonya-kaita pilyala naena lao kombea pimaiya. Pimaitiamopa akali dokaita kaitini waka mendenya-kaita nyakamanya yuu dokonya pilyiami. ");
INSERT INTO enq2_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Akali dokaita pateaminopa, Kamongonya enjele mende kombeame ipupala Josepe lamaiyoo, “Eroteme wane doko pyao kumasotoo lao kutalanya pilyamona, emba sakatatala, wane dokopa, endangipa dolapo lanyoo paka Ijipi pupala, dokonya katape. Katatenopa, nambame emba pilya lato gii dokopa pilyetena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dopa lateamopa, kuka gii dokopaka Josepe sakatatala, wane dokopa, endangipa dolapo lanyoo Ijipi pea. ");
INSERT INTO enq2_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pupala Josepe Ijipi katao, Erote kumia gii dokonya tuu lea. Dopa piamo dokome, Kamongome propeta mende-kisa lao pituu, “Nambanya ikiningi doko Ijipi yuu doko yakinatala epena leona” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Niki pyakaengesa tange akali masepae singi dupame Erote baa minakasetala pumi-lumu lao masetala, baa etete imbu kaeya. Imbu kaeyapala baame bui doko gii andukupa kateape lao, akali dupa tipa piamo doko masia. Masetala Betelemapi, yuu dosa makisa singipi, dupanya pupala, wane ane ee kana laponya anatena patae dupa pitaka baanya amii dupame pyao kumasala pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Dopa pina lea dokome, propeta Jeremaeyame lao pituu, “Taono Rama dokonya Resolome baanya wane dupa kondo kaeyapala ee lao yamataka lao peteamopa, endakali dupame siami. Baanya wane dupa nakateaminosa, endakali mendeme baa yatae laa naena lao tuu piana” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erote kumateamopa, Josepe baa Ijipi katea dokonya, Kamongonya enjele mende kombeame ipupala baa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wane doko pyalanya kutiamino akali dupa kumatelyaminona, emba sakatatala, wane dokopa, endangipa dolapo lanyoo Israele yuu dokonya puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dopa lateamopa Josepe sakatatala, wane dokopa endangipa dolapo lanyoo Israele yuu dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dokopa Akelesame baanya takange Erotenya panda nyepala, Judia yuu dokonya kiŋi kalyamo lapae sepala, Josepe yuu dokonya paanya paka kaeya. Dokopa Josepe baa Judia nakatena lao Goteme kombeame lamaiya dokonya, baa Galali pea. ");
INSERT INTO enq2_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pupala taono Nasarete lenge dokonya katea. Dopa pia dokome, propeta dupame lao pituu, “Baa Nasarete tangena latamina” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gii dutupanya Jone kaimbu pingi doko Judia yuu dokonya, endakali napalenge mendasa ipao katapala, endakali dupa Gotenya pii doko lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kingdom kaiti-kisa singi doko tengesa ipatelyamona, nyakama mona kapilyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Propeta Aisaiyame Jone kaimbu pingi dokonya lao, lao pituu, “Endakali napalenge yuu mendenya akali mende katapala wii lao, ‘Kamongonya kaitini doko depa lakamaiyepape. Kaitini koeyapae dupa tolasakamaiyepape’ lao katatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jone baa yonge pee kamele itimi wasepaepi, matapu kao yanungimi wasepaepi, dupa pyoo katea. Baa paiyombapi, oni kakasa lyingipi, dupa nao katea. ");
INSERT INTO enq2_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalema tangepi, Judia tangepi, endaki Jodane mate dosale tangepi, dupa pitaka baa katea dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pupala dupanya koo dupa lao panata piaminopa, baame endaki Jodane dokonya dupa kaimbu pyata pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dokopa Parasipi, Sadyusipi longo mendapu kaimbu pyekena lao epeamino kandatala, baame dokaita lamaiyoo, “Nyakama koo kanopatonya mandipae! Gotenya imbu kaeyapae doko ipatana lao apimi nyakama langimusa paka epelyami? ");
INSERT INTO enq2_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Endakali mona kapilyetae dupame mana miningimali pyoo, nyakamame mana minalapape. ");
INSERT INTO enq2_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nyakamanya moname dapa lao masala naeyalapape: ‘Abraame naimanya yumbange dokonyana, naima yaka kalyamanona’ lao masala naeyalapape. Nambame nyakama langilyo: Goteme kana silyamo dakaita Abraamenya wane jina lapyaliaka. ");
INSERT INTO enq2_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Indupa Goteme wua doko ita tenge dokonya depa lanya setapelyamo. Dii epe manja naenge ita dupa pitaka pokapala, baame itatenya soo yangata. ");
INSERT INTO enq2_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nyakama mona kapilyalapale lao nambame endakimi kaimbu pyekelyo. Dopaka doko, akali mende nambanya maitanya epelyamo dokonya kyeto dokome namba ita minilyamo. Baanya moko pee dolapo nyoo minakamaiyanya, namba epe daa. Baame Oli Spiritame nyakama kaimbu pyakata. ");
INSERT INTO enq2_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Baanya yapenge sapolo doko kingimi minao epelyamo. Dokome wita angipi, imbupi pyasoo silyamo dupa yapatala, angi dupa nyoo setenge anda dokonya setapala, imbu dupa itate tao konjala naenge dokonya yangatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gii dokopa Jisasa Galali katao, Joneme kaimbu pyekena lao endaki Jodane mate dokonya epea. ");
INSERT INTO enq2_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Epeamopa, Joneme baa kaena lapuli lao masetala Jisasa lamaiyoo, “Embame nambanya kaimbu pyakapenge doko, nambame embanya kaimbu pyakatale lao epelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Nalimbame kalai tolatae pipenge dupa pitambano doko yakana, indupa pimbana pii” lea. Dokopa Joneme yakana latala, Jisasame leali pia. ");
INSERT INTO enq2_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisasa kaimbu nyepala, endaki ketae pyakalyulu petala kandeamopa, kaiti doko saa papa laloo petala, Gotenya Spirita doko yaka maiyolee joo lanao ipao baa-kisa petea. ");
INSERT INTO enq2_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dokopa kaiti-kisa katao pii mende lea dokome lao pituu, “Dake nambanya Ikiningi mona setenge, nambame etete auu kaenge dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gii dokopa Sataneme Jisasa makande pina lao, Spirita dokome Jisasa laminao endakali napalenge yuu mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pateamopa Jisasa baa yuu gii 40 kuka kotakapi loma soo nee nanao katea. Dopa pyoo katapala baa lopo kaeya. ");
INSERT INTO enq2_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dokopa makande pingi akali doko baa katea dokonya ipupala lamaiyoo, “Emba Gote Ikiningi-tamo doko, kana silyamo dakaita breta jina laa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “ ‘Breta nenge dokonya-kaita iki endakali dupa saka nakatenge. Goteme pii lelyamo dupa pitakanya-kaita endakali dupa saka katengena’ lao pepa pyapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dopa lateamopa, Sataneme baa laminao siti Gotenya latae Jerusalema dokonya pupala, lotuu anda nee nyetae dokonya etete ketae dokonya katena lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Dopa latala baame Jisasa lamaiyoo, “ ‘Goteme emba masetala, baanya enjele dupame emba nisina latana’ lao pepa pyapae silyamo. Pii mendenya apata dapa lao pepa pyapae silyamoaka: ‘Embanya mokopi mende kaname tukutame-latala, dupame emba kopyoo nyetamina’ lapae silyamo. Dopana, emba Gote Ikiningi-tamo doko, ketae dakenya katao isa mangau laa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dopa leamopa Jisasame baa lamaiyoo, “ ‘Embanya Kamongo Gote doko embame makande napipi’ lao pepa pyapae silyamoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dokopa Sataneme baa dee laminao, yuu manda etete ketae mendenya pupala, isa yuu dakenya kingdom dupapi, dupanya oapi epe muni andake pupengepi, dupa baa kandena lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kandena latala baame Jisasa lamaiyoo, “Emba luma lakapala namba mambo pyateno doko, kandelyeno dakaita pitaka nambame emba ditoana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dopa leamopa Jisasame baa lamaiyoo, “Gotenya pii dokonya dapa lao pepa pyapae silyamo: ‘Embanya Kamongo Gote doko embame mambo pyao, baanya iki kalai pyakamaiyoo katape’ lapae silyamona, Satane, embame namba yakinatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dopa lateamopa Sataneme Jisasa yakinatala pea. Dokopa enjele mendapu ipupala baa nisiami. ");
INSERT INTO enq2_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jone anjiami lapae doko Jisasame sepala, baa Galali pilyia. ");
INSERT INTO enq2_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pilyetala gii kuki Nasarete katapala, Kapename pao katea. Kapename doko Galali pete lembasa, akali tata Sebyulanepa, Napataliapa dolaponya yuu dokonya singi. ");
INSERT INTO enq2_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Propeta Aisaiyame lao pituu, “Akali tata Napataliapa, Sebyulanepa dolaponya yuu doko endaki Jodane omotena, Galali pete lembasa singi. Yuu dokonya akali tata waka dupa palengema. Dupame yuu iminjetaenya katao, tii pipae andake mende kandeami. Kuminginya pupu lapae dokonya katengema dupa-kisa tii pipae dokome tii pisiana” lapae singi doko Jisasa baa Kapename katea dokome angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gii dokonya pituu, Jisasame tee pyao endakali dupa pii lamaiyoo, “Kingdom kaiti-kisa singi doko tengesa ipatelyamona, nyakama mona kapilyalapa” lao katea. ");
INSERT INTO enq2_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisasa baa Galali pete lemba dokonya pupala kandeamopa, Saimone kenge mende Pita lenge dokopa, baanya kaiminingi Andruapa, dolapo pisa nyingimba dokonyana, umbene mende endaki pete dokonya pyandao pisa nyoo kateambi. ");
INSERT INTO enq2_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dokopa Jisasame dolapo lamaiyoo, “Nyakambame pisa nyingimbali pyoo, endakali nyalapale mana langitoo, namba watao ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dopa lalu piamopa, akali dolapome umbene dupa yakinatala, baa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisasa umbisale pupala kandeamopa, kaiminingi waka lapoma, Jemesa lenge dokopa, Jone lenge dokopa, dolapo nyakambanya takange Sebedi-pipa sipi andaka umbene tambuu peteambino kandatala, wii lea. ");
INSERT INTO enq2_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wii lalu piamopa, nyakambanya takangepa, sipi dokopa, dolapo yakinatala Jisasa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisasame Galali yuu doko pitakanya paeyao, dokaitanya lotuu anda dupanya mana lamaita, kingdom kaiti-kisa singi dokonya lao wai pii epe doko lamaita pia. Dokopa endakali yaina tata waka-waka dupame pyapae dupa pitaka baame mee jeta pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Baame pia dupa Siria yuu dupa pitakanya lao taeyami. Dopa piaminopa, endakali dupame endakali yaina tata waka-waka dupame pyapaepi, tanda andake nengemapi, imambu koo paletapi, mandipaeme nyingipi, papa tambutaepi, dupa pitaka laminao baa katea dokonya epeami. Dopa piaminopa, Jisasame yaina dupa mee jeta pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dokopa endakali kambu andake mendapu yuu Galaliapi, Dekapolisapi, Jerusalemapi, Judiapi, endaki Jodane omotenapi, dupanya katao ipupala Jisasa watao paeyami. ");
INSERT INTO enq2_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisasame endakali kambu longo dupa kandatala, baa lalyoo pao yuu manda mendenya pea. Pupala dokonya peteamopa, baanya disaipolo dupa epeami. ");
INSERT INTO enq2_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dokopa baame dokaita dapa lao mana lamaiya: ");
INSERT INTO enq2_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Endakali imambunya daa jepae dupa Goteme auu pisingi. Kingdom kaiti-kisa singi doko auu pisetae dupanya. ");
INSERT INTO enq2_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Endakali ee lao katengema dupa Goteme auu pisingi. Auu pisetae dupanya mona tambo lasakamaita. ");
INSERT INTO enq2_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Endakali anasale joo katengema dupa Goteme auu pisingi. Auu pisetae dupame isa yuu dake etete nyetami. ");
INSERT INTO enq2_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Mana tolatae dupa wata-minapu laka lao masetala, nee kaengema endakali dupa Goteme auu pisingi. Auu pisetae dupa mana tolatae dupame tumbatamopa katatami. ");
INSERT INTO enq2_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Endakali kondo kaeyao katengema dupa Goteme auu pisingi. Auu pisetae dupa Goteme kondo kaeyata. ");
INSERT INTO enq2_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Gote iki mona setao katengema endakali dupa Goteme auu pisingi. Auu pisetae dupame Gote kandatami. ");
INSERT INTO enq2_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Endakali mona setao katamana lao akema lengema dupa Goteme auu pisingi. Auu pisetae dupa Gotenya ikiningina latami. ");
INSERT INTO enq2_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Gotenya mana tolatae dupa minilyaminosa tanda nyingima endakali dupa Goteme auu pisingi. Kingdom kaiti-kisa singi doko auu pisetae dupanya. ");
INSERT INTO enq2_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nyakamame namba wata-minilyaminosa, endakali dupame nyakama pii koo lata, tanda dyoo koeyaseta, sambo pii tata dupa pitaka lata pilyaminopa, Goteme nyakama auu pisingi. ");
INSERT INTO enq2_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Endakali dupame nyakama tanda dyoo koeyasetaminopa, yole andake mende kaiti-kisa setekelyamona lao masetala, nyakama eteke pyao mona yaepao kalyepape. Propeta wamba kateami dupa dopaka pyoo tanda maiyoo koeyasiamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nyakama yuu dakenya sole jepae kalyamino. Sole dokonya tende patamo doko, nyakamame aipa petala dee tende pisetamipi? Sole tende patae dokome mende napingi. Doko kamaka soo nepatala, endakalimi moko katao nepengema. ");
INSERT INTO enq2_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nyakama yuu dakenya tii pyoo kalyamino. Yuu manda mendenya siti mende silya doko yalo pyoo nasingi. ");
INSERT INTO enq2_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Endakali dupame lama kaiyepala, penge mendeme sanga pyambala naengema. Endakali andaka pititami dupa pitaka tii pisina lao toko-kisa panao setengema. ");
INSERT INTO enq2_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dopaka pyoo, tii pipae nyakama-kisa silyamo doko endakali waka dupame kandena lao kalyepape. Dopa pitaminopa, nyakamanya kalai epe pitami dupa endakali dupame kandatala, nyakamanya Takange kaiti-kisa katenge doko kenge andake maitamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mosesanya loo dupapi, propeta dupame mana leami dupapi, dupa nambame nyoo nepalanya epeena lao masala naeyalapape. Dupa nambame nyoo nepalanya naepeo. Dupa angi jisalanya epeo. ");
INSERT INTO enq2_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nambame nyakama kiningi langilyo: Yuupa kaitipa dolapo etala naeyatamopa, Mosesanya loo dupanya kuki etete mendaipi mende alu napita. Dupa alu napyoo soaka pao, dupa pitaka pyoo etatamo gii dokonya tuu lata. ");
INSERT INTO enq2_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dopana, mana setapae datupanya kuki etete mende endakali mendeme yalatala, endakali waka dupame dopaka pyoo yalena lao mana lamaitamo doko, kingdom kaiti-kisa singi dokonya baa kenge nasingi, etete daana latami. Dopaka doko, endakali mendeme mana setapae datupa wata-minatala, endakali waka dupame dopaka pyoo wata-minina lao mana lamaitamo doko, kingdom kaiti-kisa singi dokonya baa kenge andake singina latami. ");
INSERT INTO enq2_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nambame nyakama langilyo: Mosesanya loo mana nyepaepi, Parasipi dupa ita minao nyakamame mana tolatae dupa minala naeyatamino doko, kingdom kaiti-kisa singi dokonya nyakama kolandala naeyatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ ‘Embame endakali pyao kumasala naeyape. Pyao kumaseta endakali doko-kisa tenge setapala tanda maipengena’ lao, wamba nyakamanya yumbange dupa lamaiyami doko nyakamame siami. ");
INSERT INTO enq2_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dopaka doko, nambame nyakama dapa langilyo: Akali mendeme baanya kaiminingi mende yapa imbu kaeyatamo doko, baa-kisa tenge setapala baa tanda maipenge. Akali mendeme baanya kaiminingi mende pii koo latamo doko, kote andake dokome baa-kisa tenge setapala baa tanda maipenge. Akali mendeme endakali mende kyakaengena latamo doko, baa itate tao katenge ele panda koo dokonya pupenge. ");
INSERT INTO enq2_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dopana, embame Gote kundi maiya alta tengesa patenopa, embanya kaiminingi mendeme emba imbu kaelyamona lao masepae epea-kandeno dokopa, ");
INSERT INTO enq2_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","embanya kundi maiyanya piti doko alta tengesa dosa setapala, wambao embanya kaiminingi doko katata dokonya pupala, pii lao tolasalapape. Tolasetala kundi doko maiya pilyepe. ");
INSERT INTO enq2_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Emba kotimi lata endakali doko-pipa kote laa pao pituu, kaitinisa embame yapa baanya mona auu pisakamaipi. Dopa napitino doko, baame emba laminao pao jasa doko maitamopa, jasa dokome emba yanda singi doko maita. Dokopa yanda singi dokome emba anjinya pyandata. ");
INSERT INTO enq2_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Anjetae paliu, koteme maipi latami dutupa maiyoo etatenopa, emba mokatamina lao nambame emba kiningi langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘Embame kepo kolala naeyape’ lapae singi doko nyakamame siami. ");
INSERT INTO enq2_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dopaka doko, nambame nyakama dapa langilyo: Akali mendeme enda mende lengeme kandatala, moname nyipu laka lao masilya dokome angi kepo kolelyamosa pingi. ");
INSERT INTO enq2_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dopana, embanya lenge tolaetename emba koo pyaale lao mapusia-kandeno doko, lukunya nepape. Embanya yongenya katenge dupanya mendai mende lukunya nepateno doko auu pita. Embanya yonge doko pitaka ele panda koo dokonya soo pyandatamo doko auu napita. ");
INSERT INTO enq2_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Embanya kingi tolaetename emba koo pyaale lao mapusia-kandeno doko, kepanya nepape. Embanya yongenya katenge dupanya mendai mende nepateno doko auu pita. Embanya yonge doko pitaka ele panda koo dokonya soo pyandatamo doko auu napitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘Akali mendeme baanya enda doko yakinao pituu, enda yakinenge pepa mende pyao maipengena’ lapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dopaka doko, nambame nyakama dapa langilyo: Akali mendenya enda dokome kepo kolala naelyamopa, akali dokome enda doko yakinelyamopa, enda doko akali waka mendenya pelya dokome, akali wambatae doko mambele enda doko kepo kolenge. Akali mendenya enda yakinatae mende akali mendeme nyilya dokome baa kepoaka kolengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ ‘Embanya pii dupa kyeto tasalanya, Kamongonya kenge doko latala, embame kiningi etete mende pitona late doko, kaeyala naeyao lateli pipi’ lao, wamba nyakamanya yumbange dupa lamaiyami doko nyakamame siami. ");
INSERT INTO enq2_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Dopaka doko, nambame nyakama dapa langilyo: Kaiti doko Gote petenge toko dokona, kaitinya kenge doko latala, kiningi etete mende pitona laa naeyape. Yuu dake Gotenya moko setenge toko dokona, yuu dakenya kenge doko latala, kiningi etete mende pitona laa naeyape. Jerusalema doko Kiŋi Andake dokonya siti dokona, Jerusalema kenge doko latala, kiningi etete mende pitona laa naeyape. Embanya pii late doko kyeto tasalanya, dopale mende kenge laa naeyape. Etete daa. ");
INSERT INTO enq2_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Embanya iti pumbuti mende kapo jina laa naeyate. Iti kapo mende pumbuti jina laa naeyateakana, embanya pii late doko kyeto tasalanya, embame langalu minatala kiningi etete mende pitona laa naeyape. ");
INSERT INTO enq2_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pii kyeto tasalanya waipa sinyoo pii lelyamino dupa koo akali dokome waipa sinyingina, embame mende pitona lateno doko, pitona iki lape. Mende napitona lateno doko, napitona ikiaka lape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘Akali mendeme embanya lenge lukutamopa, itingi lengeaka lukupi. Nenge longatamopa, itingi nengeaka longape’ lapae singi doko nyakamame siami. ");
INSERT INTO enq2_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dopaka doko, nambame nyakama dapa langilyo: Endakali mendeme emba-kisa koo mende pia-kandeno doko, pina kaeyape. Endakali mendeme embanya wakena tolaetena kingi kapeme pia-kandeno doko, yangitena apata pina maipi. ");
INSERT INTO enq2_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Endakali mendeme embanya yonge pee isa pingi doko nyotoo lao emba kotimi lea-kandeno dokopa, yonge pee kisa pingi doko apata baa maipi. ");
INSERT INTO enq2_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Akali mendeme emba pyalanya latala, pinju soo tengesa amasa pao mapa lea-kandeno dokopa, londatili pao mapape. ");
INSERT INTO enq2_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Endakali mendeme emba-kisa dopale mende tee latamopa, embame maipi. Endakali mendeme emba-kisa yanu tee latamopa, embame daa nalape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘Embanya patali maki dupa auu kaeyapala, embanya yandapipi dupa imbu kaeyape’ lapae singi doko nyakamame siami. ");
INSERT INTO enq2_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dopaka doko, nambame nyakama dapa langilyo: Nyakamanya yandapipi dupa auu kaeyalapape. Nyakama Goteme koeyasina latami endakali dupa pii epe lamaiyepape. Nyakama imbu kaeyatami endakali dupa auu pisalapape. Nyakama pii koo lao tanda dyoo koeyasetami dupanya loma sakamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dopa pitami dokome, nyakamanya Takange kaiti-kisa katenge dokonya nyakama ikiningi katatami. Baame endakali koopi, epepi dupa pitaka-kisa baanya niki doko tapina lenge. Baame endakali mana tolatae miningipi, mana koo miningipi dupa pitakanya lao aiyuu epena lenge. ");
INSERT INTO enq2_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyakama auu kaeyatami endakali dupaka nyakamame auu kaeyatamino doko, yole aipale mende nyetami? Takisa nyingi dupame dopaka napingimape? ");
INSERT INTO enq2_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nyakamanya kaita miningi dupaka nyakamame mambo pyao lanyetamino doko, mana aipale mendeme endakali waka dupa ita minatami? Takisa nyingi dupame dopaka napingimape? ");
INSERT INTO enq2_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nyakamanya Takange kaiti-kisa katenge doko etete tolataena, nyakama etete tolataeyaka kalyepape” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisasame lao pituu, “Endakali dupame kandena lao nyakamame endakali tipya dupa panao maitamino doko, nyakamanya Takange kaiti-kisa katenge dokome nyakama yole mende nanditana, kandao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mana tolatae miningi manemane pingima endakali dupame nyakama lalyimili lao masetala, lotuu andapi, taononya kaitini yakanepi, dupanya endakali daa jepae dupa panao maingima. Nambame nyakama kiningi langilyo: Dopa pingima endakali dupame nyakamanya yole doko nyepelyaminona, embame dopa napipi. ");
INSERT INTO enq2_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Embame endakali daa jepae dupa kingi tolaetename maiyoo pituu, kingi koeyatename nakandena lao yalo pyoo maipi. Dopa pitinopa, yalo pyoo pingi dupa kandenge, embanya Takange dokome emba yole mende panao ditana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Embame loma sete gii dokopa, endakali mana tolatae miningi manemane pingima dupame loma singimali pyoo sala naeyape. Dupame lotuu andapi, taononya kaitini kembopi dupanya katao, endakali dupame kandena lao loma simu laka lao masingima. Nambame nyakama kiningi langilyo: Dopa pingima endakali dupanya yole dupa nyepelyamino. ");
INSERT INTO enq2_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dopana, embame loma salanya, embanya palenge panda dokonya pupala, kaita pai lape. Dopa petala, embanya Takange yalo pyoo katenge doko loma sepe. Dopa pitinopa, yalo pyoo pingi dupa kandenge, embanya Takange dokome emba yole mende panao dita. ");
INSERT INTO enq2_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Akali tata waka dupame loma londe pyoo silyami dokonya, dokaitanya gote dupame sekelyaminona lao masetala, loma soo pituu pii lelyami dutupaka lati singima. Dopa pingimana, nyakamame loma soo pituu dopa napyepape. ");
INSERT INTO enq2_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nyakamame tee laa naelyaminopa, nyakamanya Takange dokome nyakama daa jilyamo dupa masingina, akali tata waka dupame loma singimali pyoo nyakamame loma sala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nyakamame dapa lao loma salapape: Naimanya Takange kaiti-kisa katenge, embanya kenge doko auu pyoo lapa lape. ");
INSERT INTO enq2_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Embanya kingdom doko epena lape. Kaiti-kisa embanya masingili pingima, dopaka pyoo isa yuu dakenya pyepa lape. ");
INSERT INTO enq2_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Indupa napenge nee dupa embame naima dipi. ");
INSERT INTO enq2_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Naima koo pingilyamino dupanya yanu dupa kaelyamanona, embame naimanya koo dupanya yanu dupa kaeyakape. ");
INSERT INTO enq2_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Koo pyepale lao makande pingi dupanya naima laminao napupi. Koo akali dokonya kinginya embame naima pyoo nyepe. Kingdom dokopi, kyeto dokopi, tii pipae dokopi, dutupa tanga-tangapi embanyaka. Doko kiningi. ");
INSERT INTO enq2_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nyakamame endakali dupanya koo dupa kame sakamaitamino doko, nyakamanya Takange kaiti-kisa katenge dokome nyakamanya koo dupa kame sakataka. ");
INSERT INTO enq2_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nyakamame endakali dupanya koo dupa kame sakamaiya naeyatamino doko, nyakamanya Takange dokome nyakamanya koo dupa kame sakala naeyatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nyakamame loma soo nee nanao katao, mana tolatae miningi manemane pingima dupame pingimali pyoo, enomba kumala naeyalapape. Dokaita nee nanao kalyamini-lamo lao endakali dupame kandena lao, dokaita enomba kumapae paengema. Dopa pingima endakali dupame nyakamanya yole doko nyepelyaminona lao nambame nyakama kiningi langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Emba loma soo nee nanao katatenopa, emba nee nanao kalyenona lao endakali waka dupame nakandenya, embanya Takange yalo pyoo katenge dokome iki kandena lao, embanya aiyomba weleme kai pyatala, embanya lenge-lyaapi wasa pyatala katape. Dopa pitinopa, yalo pyoo pingi dupa kandenge, embanya Takange dokome emba yole mende ditana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Isa yuu dakenya oapi epe setelyamino dupa neneme nao koeyasingi. Dupa kaa tao koengeaka. Pake nenge dupame anda kalupala pake nyingimakana, nyakamanya oapi epe dupa isa yuu dakenya setala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kaiti-kisa oapi epe setelyamino dupa neneme nao koeyasala naenge. Dupa kaa tao koeyala naengeaka. Pake nenge dupame anda kalupala pake nanyingimakana, nyakamanya oapi epe dupa kaiti-kisa setalapape. ");
INSERT INTO enq2_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nyakamanya oapi epe dupa setenge panda dokonyaka nyakamanya mona yukuu setengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lenge doko yongenya lama doko. Emba lenge mendai iki tao katateno doko, embanya yonge doko pitaka tii pipaeme tumbatamopa katate. ");
INSERT INTO enq2_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dopaka doko, emba lenge lapo tao katateno doko, embanya yonge doko pitaka iminjetaeme tumbatamopa katate. Emba-kisa tii pipae silyamo lao sekelyeno doko angi iminjetae-tamo doko, iminjetae doko etete andake mende setana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Endakali mendeme kamongo lapomanya kalai pyakamaiya naeyapenge. Lapomanya kalai pyakamaitamo doko, baame mende doko maka kaeyapala, mende doko auu kaeyata. Daa-tamo doko, mende doko mona setapala, mende doko maka kaeyata. Dopana, nyakamame Gotepa, munipa dolapo lapotanya kalai pyakamaiya naeyapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tenge dokonya nambame nyakama dapa langilyo: Nyakama auu pyoo katamana lao masetala, nyakamame neepi, endakipi dupa anja-tae namanape, yonge pee anja-tae pimanape lao masepae longo nyala naeyalapape. Lete katenge doko nee nenge dopale daa. Yonge doko yonge pee pingi dopale daaka. ");
INSERT INTO enq2_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nyakamame yaka ketae paenge dupa kanjepape. Dupame ee pokala naengema. Dupame nee mandyoo setenge anda dupanya nee nyoo setala naengemaka. Dopaka doko, nyakamanya Takange kaiti-kisa katenge dokome dupa nee maingi. Nyakamame yaka dupa ita minao kalya naelyamipi? ");
INSERT INTO enq2_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyakamanya mendeme auu pyoo katapuli lao masepae longo nyete dokome, embanya lete katenge dokonya yuu gii mendai waipa setepe? ");
INSERT INTO enq2_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aipuma nyakamame yonge pee anja-tae pimanape lao masepae longo nyilyami? Eenya palao dii dupa dopa pyoo andengena lao masalapape. Dupame kalai mende napingima. Yonge peepi mende wasala naengemaka. ");
INSERT INTO enq2_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dopaka doko, Solomoneme baanya yati tata epe dupa pitakame yati pia dupanya, palao dii auu pilyamo dopale mendeme baa yati napiana lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Palao taita kepao yangapenge, indupa dii pilyamo dupa Goteme yati pisingi. Dopa pingina, yongenya pipenge dupa Goteme nyakama ditana, aipuma nyakamame baa kuki tungi pilyami? ");
INSERT INTO enq2_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nyakamame neepi, endakipi dupa anja-tae namanape, yonge pee anja-tae pimanape lao masepae longo nyala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Akali tata waka dupame dopale dupa kutingima. Dopaka doko, nyakamanya Takange kaiti-kisa katenge dokome nyakama daa jilyamo dupa pitaka kandenge. ");
INSERT INTO enq2_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dopana, nyakamame Gotenya kingdom dokopa, baanya mana tolatae dokopa, dolapo wambao kutalapape. Dopa pitaminopa, nyakama nyepenge dupa pitaka baame dita. ");
INSERT INTO enq2_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Nyakamame taitanya lao masepae longo nyala naeyalapape. Taita kenda ipata dupa taita sepenge. Indupa kenda ipata dupa indupaka sepengena” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisasame lao pituu, “Nyakamame endakali dupa yapala naeyalapape. Dokopa Goteme nyakama yapala naeyataka. ");
INSERT INTO enq2_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nyakamame endakali mende-kisa tenge setatamili pyoaka, Goteme nyakama-kisa tenge setata. Nyakamame endakali mende yapatamino doko, makande mendai dokomeaka Goteme nyakama yapata. ");
INSERT INTO enq2_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Embanya lengenya ita lyoo andake sipya doko nakandao, aipuma embanya kaiminingi dokonya lengenya kuni yakane sipya doko kandakamailyi? ");
INSERT INTO enq2_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Embanya lengenya ita lyoo andake mende setamopa, aipa petala embanya kaiminingi doko lamaiyoo, ‘Embanya lengenya kuni yakane mende silyamona, nyakatoo kae’ late? ");
INSERT INTO enq2_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Emba mana tolatae miningi manemane pingi dokome, wambao embanya lengenya ita lyoo andake silyamo doko nyoo nepape. Dokopa emba lenge auu pyoo tao, embanya kaiminingi dokonya lengenya kuni yakane seta doko nyoo nepakamaiti. ");
INSERT INTO enq2_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nyakamame Gotenya latae dupa yana namaiyepape. Maitamino doko, yana dupame kapilyetala nyakama nao titi pyao nepatami. Nyakamanya mamaku epe dupa mena katatami dokonya pyale nalalapape. Pyale latamino doko, mena dupame moko katao longao nepatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Tee lelyami endakali dupa pitakame nyingima. Kutilyami endakali dupa pitakame kutao kandengema. Anda kaita gata-gata lelyami endakali dupa pitakanya anda kaita lumbakamaingi. Dopana, nyakamame tee lataminopa nyakama ditana, tee lapape. Kutataminopa kutao kandatamina, kutalapape. Anda kaita gata-gata lataminopa lumbakatana, anda kaita gata-gata lapape. ");
INSERT INTO enq2_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Embanya wane dokome breta natoo latamopa, embame kana mende nena lao maitipi? ");
INSERT INTO enq2_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pisa natoo latamopa, embame kanopato mende nena lao maitipi? ");
INSERT INTO enq2_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyakama koo pingima dupame nyakamanya wane dupa oapi epe maingi mana doko kandengema-tamo doko, nyakamanya Takange kaiti-kisa katenge dokome nyakama ita minao, baa-kisa tee latami endakali dupa oapi epe maipenge dupa maita. ");
INSERT INTO enq2_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mosesanya loo dupapi, propeta dupame mana leami dupapi, dupanya pii tenge angi doko dake: Endakali waka dupame nyakamanya pyakamili lao masetami dopaka pyoo, nyakamame endakali waka dupanya pyakamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Koenge panda dokonya penge lome kaita doko pee lapae. Kaitini dokonya endakali longo lekeleke natao pengema. Lete katenge panda dokonya penge lome kaita doko tambukinatae. Kaitini dokonya lekeleke tao pupenge. Endakali kukimi kaitini doko kutao kandengemana, nyakama lome kaita tambukinatae dokonya kolandalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sambo propeta dupanya mona andaka yana kapu jetae katatamopa, sipisipi yonge nyoo petala, nyakama katatami dokonya ipatamina, kandao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dokaitanya mana minatami dupa nyakamame kandatala, dupa dopale-lamo lao masetami. Ikililyambu kende dupanya getepe dii lyingipi, pande maku ita dupanya piki dii lyingi? ");
INSERT INTO enq2_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ita epe dupame dii koo namandenge. Ita koo dupame dii epe namandengeaka. Ita epe dupa pitakame dii epeaka mandenge. Ita koo dupa pitakame dii koaka mandenge. ");
INSERT INTO enq2_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dii epe namandenge ita dupa pitaka pokapala, itatenya soo yangenge. ");
INSERT INTO enq2_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dopana, sambo propeta dupanya mana minatami dupa nyakamame kandatala, dupa dopale-lamo lao masetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Namba lao, ‘Kamongo, Kamongo’ lengema endakali dupa pitaka kingdom kaiti-kisa singi dokonya kolandala naeyatami. Nambanya Takange kaiti-kisa katenge dokome masingili pingima endakali dupa iki kolandatami. ");
INSERT INTO enq2_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yuu etatamo gii dokopa, endakali longome namba langyoo, ‘Kamongo, Kamongo, naimame embanya kenge dokonya tanga dopale mende pitana lao pii lamaiyama. Naimame embanya kenge dokonya imambu koo longo mendapu watao piama. Naimame embanya kenge dokonya mirakolo longo mendapu piamakana’ latami. ");
INSERT INTO enq2_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dokopa nambame dokaita panao lamaiyoo, ‘Nambame nyakama etete nakandengena, nyakama Gotenya loo yalengema dupa namba yakinatala pupa’ latona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nambame pii langilyo datupa sepala wata-miningima endakali dupa pitaka, akali masepae epe palenge mendeme yuu kyeto mendenya anda piamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Baame yuu kyetonya muku minapala anda piamo dokonya, poo kyeto joo lata, aiyuu ipata, endaki lyoo ipata piamopa, anda doko takyala naeya. ");
INSERT INTO enq2_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nambame pii langilyo datupa sepala wata-minala naengema endakali dupa pitaka, akali masepae epe napalenge mendeme endaki keenya anda piamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Baame endaki keenya anda piamo dokonya, poo kyeto joo lata, aiyuu ipata, endaki lyoo ipata piamopa, anda doko pyao takia. Takiamo dokome, oapi dupa pitaka koeyana” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisasame mana lea dupa, Mosesanya loo mana nyepae dupame lengemali pyoo laa naenya, mana lapenge kyeto doko baa-kisa singi joo lea. Tenge dokonya, baame pii dutupa lao etapeamopa, endakali kambu dupame sepala paka kaeyao walu leami. ");
INSERT INTO enq2_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisasa baa yuu manda doko yakinatala lanao epeamopa, endakali kambu longome baa watao epeami. ");
INSERT INTO enq2_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dokopa akali kopetali mendeme Jisasa katea dosa ipao luma lakapala baa lamaiyoo, “Kamongo, embame nambanya yaina dake mee jetala, pyoo wasepae kalyale lao maseteno doko, yaina dake mee jakatenopa, namba pyoo wasepae kalyapona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dopa leamopa, Jisasame akali doko kingimi watandatala lao pituu, “Emba pyoo wasepae kalyale lao masetala, nambame embanya yaina doko mee jina lelyona” lea. Dopa lalu piamopa, akali dokonya kopetali doko etea. Etapeamopa baa pyoo wasepae katea. ");
INSERT INTO enq2_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dokopa Jisasame baa lamaiyoo, “Nambame embanya pyakalo doko mende lamaiya naenya, prisa dokome emba kandena puu. Pupala Mosesame mana seteali pyoo embame dopale mende Gote kundi maitinopa, endakali dupame embanya yaina doko etapya-lamo lao kandenana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jisasa Kapename pao pyakameamopa, amii 100 isingi mende ipupala baa lamaiyoo, “Akali Andake, nambanya kalai akali mende yainame tanda andake nao, takyepae andaka silyamona nisakatepe?” lao kyeto joo tee lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dopa leamopa Jisasame baa lamaiyoo, “Nambame baa saka nyala ipatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dokopa amii 100 isingi dokome baanya pii yanu pyakamaiyoo, “Akali Andake, namba akali koo mendena, emba nambanya andaka naipupi. Embame piimi iki latenopa, nambanya kalai akali doko saka paapomo. ");
INSERT INTO enq2_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aipuma dopa lelyo? Nambanya isingi akali dokonya namba pundipundi katenge. Amii mendapu nambanya pundipundi katengemaka. Nambame dupanya mende pena lelyopa, baa penge. Dupanya mende epena lelyopa, baa epenge. Nambanya kalai akali mendeme kalai mende pina lelyopa, kalai doko pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dopa leamopa, Jisasame pii doko sepala baa walu lea. Walu latala endakali baa watao epeami dupa lamaiyoo, “Nambame nyakama kiningi langilyo: Akali dakeme namba tungi pilyamoli pyoo, Israele mendeme namba tungi pyaminopa nambame nakandapu. ");
INSERT INTO enq2_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niki pyakaengesa tangepi, niki pambengesa tangepi, endakali longo dupa ipupala kingdom kaiti-kisa singi dokonya, Abraamepi, Aisakepi, Jekopepi dutupa-pipa nee nao pititamina lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dopaka doko, kingdom kaiti-kisa singi dokonya katatamina lao makande latae endakali dupa kamalya iminjetae dokonya watao pyata. Panda dokonya endakali dupa ee lao, nenge giti-gato lao nao katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dopa latala Jisasame amii 100 isingi doko lamaiyoo, “Nambame pyakalapeno lao masetala embame namba tungi pilyino dokonya-kaitaka pyaapomona puu” lea. Dopa lea gii dokopaka, baanya kalai akali doko saka pea. ");
INSERT INTO enq2_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisasa baa Pitanya andaka kolandeamopa, Pitanya enda imange doko yonge itaita piamopa yaina siamo kandea. ");
INSERT INTO enq2_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kandatala baame enda dokonya kinginya watandeamopa, yonge itaita pia doko mee jia. Mee jeteamopa enda doko sakatatala, Jisasa nee nyoo maiya. ");
INSERT INTO enq2_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yuu kuiyalanya piamopa, endakali mendapuame imambu koo paleta endakali longo mendapu laminao, Jisasa katea dokonya epeami. Dokopa Jisasame endakali dupa-kisa imambu koo palea dupa piimi watao pyata, yaina pyapae dupa pitaka mee jeta pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Baame dopa pia dokome, propeta Aisaiyame lao pituu, “Naimanya yaina tata waka-waka dupa baame nyoo nepekeana” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Endakali kambu longome Jisasa baa katao kakopeamino kandatala, baanya disaipolo dupa Jisasame endaki pete dokonya omotena pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dokopa Mosesanya loo mana nyepae mende Jisasa katea dokonya ipupala baa lamaiyoo, “Mana Lenge, emba paeyate dupanya nambame emba watao ipatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dopa leamopa Jisasame baa lamaiyoo, “Yana kapu dupanya palenge yuli dupa singi. Yaka ketae paenge dupanya palenge anda dupa katenge. Dopaka doko, Akalinya Ikiningi dokonya palenge panda mende nasingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dokopa baanya disaipolo dupanya mendeme baa lamaiyoo, “Kamongo, wambao nambanya takange malu petala patoo kae” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dopa leamopa Jisasame baa lamaiyoo, “Endakali kumapae dupame nyakamanya kumapae yango dupa malu pina emba kaeyapala, namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dopa latala Jisasa baa sipi mendenya pyakalyiamopa, baanya disaipolo dupame baa watao sipi dokonya pyakalyiami. ");
INSERT INTO enq2_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pyakalyetala peaminopa, poo yale mende lao sakatea dokome, endaki buli pyapala, tandyoo sipi dokonya kolandea. Dopaka doko, Jisasa baa luu palea. ");
INSERT INTO enq2_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Paleamopa disaipolo dupame baa pyale tatala lao pituu, “Kamongo, naima kumalamane-lamona, embame naima pyoo nyaa” leami. ");
INSERT INTO enq2_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dopa leaminopa Jisasame dokaita lamaiyoo, “Nyakama Gote kuki tungi pingima dupa, aipuma paka kaelyamipi?” lea. Dopa latala baa sakatatala, poo dokopa, endaki buli pia dokopa, dolapo kaena leamopa, kuki emapi mende napiambi. ");
INSERT INTO enq2_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dokopa akali dokaitame walu latala lao pituu, “Endakipa, poopa dolapome apata baanya pii lapyali pilyambino doko, akali dake aipa pipaepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Endaki pete omotena, Geregesa tange dupanya yuu dokonya Jisasa pao pyakameamopa, akali imambu koo paleta lapoma endakali malu katenge dupanya paliu ipao baa kandanyiambi. Akali dolapo etete kapu joo kalyambinosa, endakali mende kaitini dokonya-kaita napaengema. ");
INSERT INTO enq2_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Akali dolapome puu lao, lao pituu, “Gote Ikiningi Jisasa, embame naima aipa piti? Tanda andake dipenge gii seteamo doko ipa naeyamupa, embame naima wambao tanda andake dyaanya ae epelyepe?” leambi. ");
INSERT INTO enq2_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kuki omosale mena kambu mende imu nao kateami. ");
INSERT INTO enq2_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dokopa imambu koo dupame Jisasa kyeto joo tee lao, “Naima pupale lao pyao watate-tamo doko, mena dupa-kisa landa pyamana kae” leami. ");
INSERT INTO enq2_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dopa leaminopa Jisasame dupa lamaiyoo, “Pupa” lea. Dopa leamopa, imambu koo dupame akali dolapo yakinatala, mena dupa-kisa landa piami. Landa pyateaminopa, mena kambu doko papatale mendenya-kaita lanao alo pyao pupala, endaki pete dokonya mangatala kumiami. ");
INSERT INTO enq2_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dokopa mena setao kateami dupa paka siti dokonya pupala, imambu koo dupa palengema akali dolapo-kisa pia dupa pitaka endakali dupa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lamaitiaminopa, siti dokonya palengema endakali dupa pitakame Jisasa kandanyemana lao epeami. Ipupala dokaitame baa kandatala, dokaitanya yuu doko yakinatala pena lao kyeto joo leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisasa sipi dokonya pyakalyetala, endaki pete omotena, baanya siti dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pateamopa, akali mendapuame akali papa tambutae mende lapa toko dokonya soo baa katea dokonya epeami. Dokopa akali dokaitame tungi piamino doko Jisasame kandatala, papa tambutae doko lamaiyoo, “Nambanya ikiningi, embanya koo dupa kunao nepatae kalyenona, emba mona kenda nakaeyape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dopa leamopa, Mosesanya loo mana nyepae mendapuame nyakama-lapo lao pituu, “Akali dakeme Gote anda-anda semaiya naeyao lelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dopa lao masoo leamino dupa Jisasame kandatala dokaita lamaiyoo, “Aipuma nyakamanya moname koo dopale dupa masilyami? ");
INSERT INTO enq2_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pii dalaponya anduku mee petala lapenge? ‘Embanya koo dupa kunao nepatae kalyenona’ lapenge dokope, pande, ‘Emba sakatatala kaita pae’ lapenge doko? ");
INSERT INTO enq2_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Akalinya Ikiningi dokome isa yuu dakenya katao, endakalinya koo dupa kunao nepenge kyeto doko baa-kisa singi-lamo lao kanjepalena” lea. Dopa latala baame akali papa tambutae doko lamaiyoo, “Emba sakatatala, embanya lapa toko doko nyoo soo andaka puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dopa leamopa akali doko sakatatala andaka pea. ");
INSERT INTO enq2_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dopa piamo doko endakali kambu piami dupame kandatala, kyeto dopale dupa Goteme endakali dupa maiya-lamo lao walu lao paka kaeyapala, Gote mambo piami. ");
INSERT INTO enq2_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisasa baa yuu doko yakinatala pao pituu, akali Matyu lenge mende, takisa nyingi anda dokonya peteamo kandatala baa lamaiyoo, “Emba namba watao ipu” lea. Dokopa baa sakatatala Jisasa watao pea. ");
INSERT INTO enq2_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Maitakao Jisasa baanya disaipolo dupa-pipa Matyuanya andaka nee nao peteaminopa, dokonya takisa nyingipi, koo pingipi longo mendapu ipupala, apata nee nao peteami. ");
INSERT INTO enq2_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Peteaminopa Parasi dupame kandatala, Jisasanya disaipolo dupa lamaiyoo, “Nyakamanya mana lenge doko aipuma takisa nyingipi, koo pingipi dupa-pipa nee nao pilyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pii leamino doko sepala Jisasame dokaita lamaiyoo, “Endakali yaina napingi dupa dokosa yangyala naenge. Endakali yaina pyapae dupa dokosa yangingi. ");
INSERT INTO enq2_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‘Endakali dupame kundi iki dimi laka lao masala naelyo. Endakali dupa kondo kaeyami laka lao masilyona’ lapae singi dokonya tenge doko nyakamame pupala mana nyalapape. Nambame endakali tolatae dupa wii lao nyalanya naepeo. Endakali koo pingi dupa mona kapilyina lao, wii lao nyalanya epeona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gii dokopa Jonenya disaipolo dupa Jisasa katea dokonya ipupala baa lamaiyoo, “Naimapi, Parasipi dupame paa longosa loma soo nee nanao katengena, embanya disaipolo dupame aipuma dopa napingimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dopa leaminopa Jisasame dokaita lamaiyoo, “Akali mende enda kelyapala watapae pyao, baanya tata dupa-pipa kalyamo gii dokopa, baanya tata dupame ee lao katengemape? Gii doko palitamopa, akali enda kelyenge doko nyoo patataminopa, baanya tata dupame loma soo nee nanao katatami. ");
INSERT INTO enq2_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yonge pee atingi mende tii telyamopa, lapalapa kangupae enenge mendeme kii pimbala naenge. Kii pimbatamino doko, enenge doko inungunyeta dokome, atingi doko etete kanguu koeyaseta. ");
INSERT INTO enq2_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Endakali dupame waene enenge kamuu penge meme yanungimi wasepae atingi mendenya pyandala naengema. Kamuu pyandatamino doko, penge doko kanguu koeyasetamopa, waene dupa kai lao pata. Waene enenge doko penge enengenyaka kamuu pisilyaminopa, waenepa, pengepa dolapo lapota koeyala naengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisasame pii dutupa lamaiyoo kateamopa, isingi akali mende Jisasa katea dokonya ipao luma lakapala, baa lamaiyoo, “Nambanya wanenge doko epapu kumatelyamona, embame baa-kisa kingi setateno doko, baa lenge talapomona, kingi setala ipupoko” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dopa leamopa Jisasa sakatatala, baanya disaipolo dupa-pipa akali doko watao peami. ");
INSERT INTO enq2_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Dokopa enda mende yuu gii dii lao andaka nao paliu, ee kana 12 pitaka petenge dokome, Jisasanya yonge peenya iki watandatopa, baanya yaina doko etalapomona lao masia. Dopa lao masetala, Jisasanya maita-kaita ipupala, Jisasanya yonge pee punanya kingimi watandea. ");
INSERT INTO enq2_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dokopa Jisasa kapilyetala, enda doko kandatala baa lamaiyoo, “Wanenge, embame namba tungi pyapi dokome, embanya yaina doko etelyamona, emba mona kenda nakaeyape” lea. Dopa lea gii dokopaka, enda dokonya yaina doko etea. ");
INSERT INTO enq2_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dokopa isingi akali dokonya andaka Jisasa pao kolandatala kandeamopa, endakali mendapu kumanda pituu pulupapu pyao ee wee leaminopa, endakali kambu pyao peteami dupa yamataka lao ee leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ee leaminopa baame dokaita lamaiyoo, “Wanaku doko kumala naeyalamo. Baa luu palelyamona, nyakama pupa” lea. Dopa leamopa, endakali dupame baa lamba lao gii kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dokopa Jisasame endakali kambu doko kamaka watao pyalyetala, baa wanaku kumapae doko sia dokonya pea. Pupala wanaku doko kinginya minao sakatasiamopa, baa sakatea. ");
INSERT INTO enq2_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dopa pia dokonya atome doko yuu makisa singi dupa pitakanya lao taeyami. ");
INSERT INTO enq2_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisasa yuu doko yakinatala peamopa, akali lenge monda mendalapome wii lao, “Dapita Ikiningi, embame nalimba kondo kaeyapoko!” lao baa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisasa andaka kolandatala peteamopa, lenge monda dolapo baa petea dokonya epeambi. Epeambinopa Jisasame dolapo lamaiyoo, “Nyakamba nambame yaka nisalapenona lao masilyambipi?” lea. Dopa leamopa dolapome baa lamaiyoo, “Kamongo, embame kiningi nalimba nisalapenona” leambi. ");
INSERT INTO enq2_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dokopa Jisasame akali dolaponya lengenya watandatala lamaiyoo, “Nyakambame namba tungi pilyambino dokonya, nyakambanya masilyambinoli pilyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dopa leamopa akali dolaponya lenge dolapo auu pyoo teambi. Dokopa Jisasame akali dolapo kyeto joo lamaiyoo, “Nyakamba-kisa pilyamo dake endakali waka mendeme setana, lamaiya naeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dopaka doko, Jisasame pia dupa pitaka akali dolapome yuu makisa singi dupa pitakanya lao taeyambi. ");
INSERT INTO enq2_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Akali dolapo peambinopa, endakali mendapuame imambu koo paleta, akali muumaa mende laminao Jisasa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ipateaminopa, akali doko-kisa imambu koo palea doko Jisasame watao pyateamopa, muumaa doko pii lea. Pii leamopa, endakali kambu piami dupa walu latala lao pituu, “Israele yuu dakenya yuu mendaipi mende kalai dapale mende nakandeamana” leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dopaka doko, Parasi dupame lao pituu, “Imambu koo dupanya isingi dokonya pupu lapae dokome imambu koo dupa baame watao pilyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisasame sitipi, yuu yakanepi dupa pitakanya paeyao, dokaitanya lotuu anda dupanya mana lamaita, kingdom kaiti-kisa singi dokonya lao wai pii epe doko lamaita pia. Dokopa endakali yaina tata waka-waka dupame pyapae dupa pitaka baame mee jeta pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sipisipi setao katenge mende daa jilyamopa, sipisipi dupa nisepae nanyepala kenda soo katengemali pyoo, endakali kambu dupa kenda soo kateamino kandatala, Jisasame dokaita kondo kaeya. ");
INSERT INTO enq2_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kondo kaeyapala baanya disaipolo dupa lamaiyoo, “Nee longo wambu petamupa, kalai akali kuki kalyamino. ");
INSERT INTO enq2_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dopana, nee mandyoo mau pyapenge kalai akali mendapu peena lao, ee tange Kamongo doko kyeto joo loma salapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisasame baanya 12 disaipolo dutupa epena latala, dutupame imambu koo dupa watao pyao, endakali yaina tata waka-waka dupa pitakame pyapae dupa mee jakamaiyoo pina lao dutupa kyeto maiya. ");
INSERT INTO enq2_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Baanya 12 aposole dutupanya kenge dupa: wambao doko Saimone kenge mende Pita lenge dokopi, Pita kaiminingi Andruapi, Sebedi ikiningi Jemesapi, Jemesa kaiminingi Jone lenge dokopi, ");
INSERT INTO enq2_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipapi, Batalomyuapi, Tomasapi, takisa nyingi Matyuapi, Alopiusa ikiningi Jemesapi, Lebiusa kenge mende Tadiusa lenge dokopi, ");
INSERT INTO enq2_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kena tange Saimone lenge dokopi, yandapipi dupanya kinginya Jisasa maiya akali Judasa Iskariota lenge dokopi, dutupa. ");
INSERT INTO enq2_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisasame 12 aposole dutupa kalai pyaa pena latala lamaiyoo, “Akali tata waka dupanya yuupi, Samaria tange dupanya taonopi, dupanya nyakama napupape. ");
INSERT INTO enq2_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israele dupa sipisipi alu petae joo kalyamino dupanya pupape. ");
INSERT INTO enq2_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pao pituu, ‘Kingdom kaiti-kisa singi doko tengesa ipatelyamona’ lao nyakamame lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Endakali yaina pyapae dupa saka nyalapape. Kopetali dupa auu pisalapape. Imambu koo dupa watao pyalapape. Nyakamame sambala naeyao mee nyilyamino dokonya meaka maiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nyakamame golopi, silipapi, kopapi mende matapunya manja naeyao mee pupape. ");
INSERT INTO enq2_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Akali kalai pita dokome nee toma napenge. Dopana, nyakama kalai pyaa patami yuu dupanya, nokainapi, moko peepi, pangalipi, yonge pee isa pingi wakaowapi mende nyoo napupape. ");
INSERT INTO enq2_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nyakama taono-tamopi, yuu yakane-tamopi mendenya pupala, endakali tolatae epe mende kutao kandatala, doko-pipa iki katao etapala, pupenge gii dokonya baa yakinatala pupape. ");
INSERT INTO enq2_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nyakama anda dokonya kolandao pituu, mona yaepao kalyepape lao, anda dokonya palengema endakali dupa lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Anda dokonya palengema endakali dupame nyakama auu pyoo lanyetamino doko, nyakamanya mona yaepenge doko dupa-kisa sina kaeyalapape. Auu pyoo lanyala naeyatamino doko, nyakamanya mona yaepenge doko tange nyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yuu tange mendeme nyakama auu kaeyao lanyala naeyao, nyakamanya pii doko nasoaka pia-kandeno doko, andapi, taonopi dupa yakinatala pao pituu, nyakamanya mokonya yuu katata dupa lyanda lanya setapala pupape. ");
INSERT INTO enq2_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Goteme endakali dupa yapatamo gii dokopa Sodomopa, Gomorapa tange dupa tanda andake maitaka doko, nyakamame yuu lyanda lanya setatami taono dokonya tange dupa tanda eteteaka andake maitana lao nambame nyakama kiningi langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nyakama sipisipi jepae dupa nambame yana kapu dupanya kainanya pupa lelyo. Dopana, kanopato dupame waa katengemali pyoo, nyakamame waa katao kalyepape. Yaka maiyolee dupame ema napyoo, mende koeyasala naeyao petengemali pyoo nyakama kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Endakali dupame nyakama anjetala laminao pao, kanjole dupa-kisa kotimi lata, dokaitanya lotuu anda dupanya nyakama konjame pyata pitamina, endakali dopale dupa wandyoo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nyakamame namba watao paelyamino latala, endakali dupame nyakama laminao pupala kiŋipi, gapenapi dupanya enombanya katasetami. Dopa pitaminopa, nyakamame kandelyaminopi, silyaminopi dupa kiŋipi, gapenapi, akali tata wakapi dupa panao lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Endakali dupame nyakama anjetala laminao kote anda dupanya pataminopa, nyakamame aipa lao kote lamanape, pii aki lamanape lao masepae longo nyala naeyalapape. Kote lapenge gii dokopa nyakama pii lapenge dupa dita. ");
INSERT INTO enq2_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nyakamame pii latami dupa, nyakama tangeme masoo laa naeyatami. Nyakamanya Takangenya Spirita dokome ditamopa latami. ");
INSERT INTO enq2_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kaiminingi mendeme kaiminingi mende pyao kumasina lao anjoo maita. Takange dupame nyakamanya wane dupa dopaka pina lao anjoo maitami. Wane dupame nyakamanya endangi takangepi dupa yandapipi jetala, pyao kumasina lao maitamiaka. ");
INSERT INTO enq2_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nyakamame nambanya kenge doko lao panelyamino latala, endakali dupa pitakame nyakama imbu kaeyatami. Dopaka doko, endakali mende kyeto joo katao, baa etata gii dokonya tuu latamo doko, baa Goteme pyoo nyeta. ");
INSERT INTO enq2_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dopana, endakali dupame taono mendenya nyakama tanda dyoo koeyasiami-kandeno dokopa, nyakamame taono doko yakinatala mendenya paka pupape. Israele yuu dokonya taono dupa pitakanya nyakamame kalai pyoo etala naeyataminopa, Akalinya Ikiningi doko ipatana lao nambame nyakama kiningi langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mana nyingi dokome baanya mana lenge doko ita naminingi. Kalai akali dokome baanya akali andake doko ita naminingiaka. ");
INSERT INTO enq2_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mana nyingi doko baanya mana lenge dopale katatamo doko yaka. Kalai akali doko baanya akali andake dopale katatamo doko yakaka. Anda tange doko kenge Belesabulu maingima endakali dupame baanya tata dupa kenge etete koo mendapu maitamiakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Sanga pyatae silyamo dupa gii mendepa lopapae seta. Yame pyatae silyamo dupa gii mendepa lopapae setamopa, endakali dupame kandatami. Dopana, nyakamame endakali dupa paka nakaeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nambame yuu iminjimupa pii langilyo dupa, tii pitamopa nyakamame lamaiyepape. Pii kakateame langipupa kaleme silyamino dupa, nyakamame anda ketae dupanya katao wii lao lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yonge doko pyao kumasingima endakali dupame imambu doko kapa pao pyao kumasala naeyapengena, dupa nyakamame paka nakaeyalapape. Yongepa, imambupa lapota ele panda koo dokonya koeyasepenge akali doko nyakamame paka kaeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Muni konde mendaimi iki yaka pimbinakae lapoma salimi lengema. Dopaka doko, nyakamanya Takange dokome nakandelyamopa, yaka dupanya mendaipi mende yuunya isa pyakatala kumala naenge. ");
INSERT INTO enq2_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dopaka pyoo, nyakamanya aiyomba iti dupa pitaka mendai-mendai lao Goteme itaki pyapae. ");
INSERT INTO enq2_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dopana, yaka pimbinakae longo dupa nyakamame ita minao kalyaminona, paka nakaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Endakali mendeme baa namba tatana lao, endakali waka dupanya enombanya lao panatamo doko, baa namba tatakana lao, nambanya Takange kaiti-kisa katenge dokonya enombanya nambame lao panatoaka. ");
INSERT INTO enq2_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dopaka doko, endakali mendeme baa namba tata daana lao, endakali waka dupanya enombanya latamo doko, baa namba tata daakana lao, nambanya Takange kaiti-kisa katenge dokonya enombanya nambame latoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Endakali dupa isa yuu dakenya mona setao katena laanya namba epeena lao masala naeyalapape. Endakali dupa mona setao katena lao naepeo. Nambame konjuwa minao epeo. ");
INSERT INTO enq2_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ikiningipa takangepa wakale pyaloo pingipi, wanengepa endangipa wakale pyaloo pingipi, aeyangepa wakale pyaloo pingipi, mana doko nambame sakatasalanya epeo. ");
INSERT INTO enq2_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tenge dokonya, endakali mendenya tata etete dupame baa yandapipi jetami. ");
INSERT INTO enq2_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Endakali mendeme baanya endangipa, takangepa mende moname etete auu kaeyapala, yongeme iki namba auu kaeyatamo doko, baa kapa pao namba tata nakatata. Endakali mendeme baanya ikiningipi, wanengepi mende moname etete auu kaeyapala, yongeme iki namba auu kaeyatamo doko, baa kapa pao namba tata nakatataka. ");
INSERT INTO enq2_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Endakali mendeme baanya poko ita doko nyoo soo, namba watao naipatamo doko, baa kapa pao namba tata nakatataka. ");
INSERT INTO enq2_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Endakali mendeme baa lete katatoana lao masetala katapenge kaitini kutatamo dokome baanya lete katenge doko yakinata. Endakali mendeme namba masetala, baanya lete katenge doko yakinata dokome baanya lete katenge doko kandao nyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Endakali mendeme nyakama auu kaeyao lanyilya dokome, namba lanyilyamosaka pingi. Endakali mendeme namba auu kaeyao lanyilya dokome, namba puu lea Akali doko lanyilyamosaka pingi. ");
INSERT INTO enq2_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Propeta mende baa propeta-lamona latala endakali mendeme lanyetamo doko, propeta dupa Goteme yole pita dopaka pyoo baa yole pita. Endakali tolatae mende baa tolatae-lamona latala endakali mendeme lanyetamo doko, endakali tolatae dupa Goteme yole pita dopaka pyoo baa yole pita. ");
INSERT INTO enq2_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Endakali mendeme endakali anasale joo katengema datupanya mende nambanya disaipolo mende-lamona latala, endaki kii napae kapo mendai iki kamuu maita dokonya yole doko alu napyoo, sulu setana lao nambame nyakama kiningi langilyona” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisasame baanya 12 disaipolo dutupa mana lamaiyoo etapala, baa katea panda doko yakinatala, Israele dupanya siti waka singi dupanya mana lamaita, pii lamaita pyaanya pea. ");
INSERT INTO enq2_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Kraisame kalai dupa pilyamo lapae doko Jone anjetae paliu sepala, baanya disaipolo mendalapo Kraisa katea dokonya pupala, baa lamaina lao dolapo lamaiyoo, “Emba akali mende ipatana latae singi dokope, pande naimame akali waka mende malisemape?” lao tipa pyaa pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dolapo pupala tipa piambinopa Jisasame yanu pyao, “Nyakamba pilyetala, silyambinopi, kandelyambinopi dupa Jone lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lenge monda dupa lenge auu pyoo telyamino. Moko takyepae dupa kaita paelyamino. Kopetali dupa auu pisakamailyamo. Kaleketa dupame pii silyamino. Endakali kumapae dupa lenge tao kalyamino. Endakali daa jepae dupame sina lao wai pii epe doko lamailyamo. ");
INSERT INTO enq2_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dopana, namba mambele endakali mende isa pyakala naeyatamo doko, baa Goteme auu pisetae kalyamona lao Jone lamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jonenya disaipolo dolapo pilyeteambinopa, Jisasame endakali kambu dupa tee pyao Jonenya lao dapa lamaiya: “Nyakamame endakali napalenge yuu dokonya aki mende kanja peami? Kembo yokopi mende poome ema-ema piamo kanja peamipi, ");
INSERT INTO enq2_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","pande aki mende kanja peami? Akali mende yonge pee epe mendapuame yati petae kateamo kanja peamipi? Salapape! Akali yonge pee epe dupame yati petae dupa kiŋi dupanya andaka katengema. ");
INSERT INTO enq2_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dopa pingimana, nyakama peamino doko aki mende kanja peami? Propeta mende kanja peamipi? Kiningi propeta mendeaka kanja peamino doko, baa mee propeta mende daana lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Akali dokonya lao dapa lao pepa pyapae silyamo: ‘Salapape! Nambanya wai akali doko nambame wambao pena latopa, embanya kaitini doko depa lakatana’ lapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nambame nyakama kiningi langilyo: Endame mandipae endakali mendaipi mendeme Jone kaimbu pingi doko ita minao nakalyamo. Dopaka doko, endakali etete kenge nasingi mende, kingdom kaiti-kisa singi dokonya kalyamo dokome Jone ita minao kalyamo. ");
INSERT INTO enq2_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jone kaimbu pingi dokome pii lamaiyoo kateamo gii dokonya pituu, indupa tuu lao, endakali makongopae dupame kingdom kaiti-kisa singi doko nyakamanya kyetome yanda pyoo nyalanya pilyamino. ");
INSERT INTO enq2_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mosesanya loo dupapi, propeta dupame pii leami dupapi, dupa pitakame propesi pii leami dupa lao Jone kateamo gii dokonya tuu leami. ");
INSERT INTO enq2_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nambame pii lelyo datupa kiningi-lumuna lao masoo nyemana lao nyakamame masetamino doko, dake salapape: Ilaija ipatana lao pii pepa pyapae singi doko, Jone lao lapae singi. ");
INSERT INTO enq2_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nambame pii lelyo dutupa endakali kale katenge dupame sepenge. ");
INSERT INTO enq2_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Endakali indupa palelyamino dupa, aki mendepa nambame makande pyuu? Endakali dokaita wane kole dupa kamapu dupanya kambu pyatala, nyakamanya tole male pingima dupa wii lao lamaiyoo, ‘Naimame pulupapunya wee pyakamanopa, nyakamame danisa laa naeyalamino. Naimame kondo kaeyao ee wee lenge dupa lakamanopa, nyakamame ee laa naeyalaminona’ lengema dopale jilyamino. ");
INSERT INTO enq2_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jone ipupala, bretapi, waenepi dupa nanao kateamopa, endakali dupame lao pituu, ‘Imambu koo mende baa-kisa palelyamona’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Indupa Akalinya Ikiningi doko ipupala bretapi, waenepi dupa namupa, endakali dupame lao pituu, ‘Akali dake bretapi, waenepi dupa tiaka nakaeyao nao katao, koo pingipi, takisa nyingipi dupa kaita minao kalyamona’ lelyamino. Dopaka doko, masepae epe singi endakali dupame masepae epe doko dopalena lao panengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisasame mirakolo longo pia siti dupanya tange endakali dupa mona kapilyala naeyaminosa, baame tee pyao pyalanya lao, ");
INSERT INTO enq2_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasina tange dupa nyakama koeyatami. Betsaida tange dupa nyakama koeyatamiaka. Nyakamanya taono dupanya mirakolo pio dupa, Taeyapa, Saidonepa dolaponya pioli doko, siti dolaponya tange dupame yonge pee meme itimi wasepae dupa pyoo, kenai dupa aiyombanya pyasetala, wamba mona kapilyiamili. ");
INSERT INTO enq2_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Goteme endakali dupa yapatamo gii dokopa Taeyapa, Saidonepa tange dupa tanda andake maitaka doko, Goteme nyakama tanda eteteaka andake ditana lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nyakama Kapename tange dupa Goteme kaiti-kisa lanyoo patana lao masilyaminoaka doko, baame nyakama watao endakali kumapae dupa katengema panda dokonya pyandata. Nyakamanya yuu dupanya mirakolo pio dupa, Sodomo dokonya pioli doko, yuu doko koeyala naeyao indupapi sipyali. ");
INSERT INTO enq2_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Goteme endakali dupa yapatamo gii dokopa Sodomo tange dupa tanda andake maitaka doko, Goteme nyakama tanda eteteaka andake ditana lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gii dokopa Jisasame lao pituu, “Apane, emba yuupi, kaitipi dupa pitakanya Kamongo. Mana longo kandenge endakalipi, mana longo nyepaepi, dupame dapale dupa nakandena lao yalo petala, wane koo joo katenge endakali dupame kandena lao embame panasiino dokonya nambame emba yaka pilyino lelyo. ");
INSERT INTO enq2_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Apane, kiningi embame pitona lao auu kaengeme masiinoli pyoo pii. ");
INSERT INTO enq2_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nambanya Takange dokome dupa pitaka namba-kisa setea. Endakali mendeme Ikiningi doko masala naenge. Takange dokome iki masingi. Endakali mendeme Takange doko masala naengeaka. Ikiningi dokome iki masingi. Takange doko endakali mendeme masina lao Ikiningi dokome masetala panasilyamopa, endakali dokome Takange doko masingiaka. ");
INSERT INTO enq2_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nyakama kenda longo soo, popo tandapi nyoo kalyamino dupa koto nyingi doko ditona, namba kalyo dakenya ipupape. ");
INSERT INTO enq2_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Namba akali tambo lapae mende, anasale joo katengena, nyakamame nambanya kenda nyoo nepenge pyakende doko nyepala namba-kisa mana nyalapape. Dopa pitaminopa, nyakamanya imambu doko koto nyeta. ");
INSERT INTO enq2_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nambanya pyakende dokome kenda dupa mee petala sepenge. Nambanya kenda doko taowe lapaeyakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sambata gii mendenya Jisasa baanya disaipolo dupa-pipa wita ee mendenya-kaita peami. Dokopa baanya disaipolo dupa lopo kaeyapala, tee pyao wita dii dupa kii lao nyepapu tambao neami. ");
INSERT INTO enq2_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dopa piaminopa Parasi dupame kandatala Jisasa lamaiyoo, “Sambata gii dokonya loome napipenge latae singi doko embanya disaipolo dupame pilyaminona kanda” leami. ");
INSERT INTO enq2_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dokopa Jisasame dokaita lamaiyoo, “Dapitapi, baa-pipa kateamipi, dupa lopo kaeyapala, baame pia doko nyakamame itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dapita lotuu anda nee nyetae dokonya kolandatala, breta Gote opaa maitae, baapi, baa-pipa kateamipi, dupame nanapenge, prisa dupame iki napengena lao loome latae singi dupa nyepala neami. ");
INSERT INTO enq2_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Prisa dupame lotuu anda nee nyetae dokonya Sambata gii dokonya kalai pilyamino dokome, Sambata gii doko koeyasingimaka doko, dokaita-kisa tenge mende napengena lao Mosesanya loo dupanya pepa pyapae singi doko nyakamame itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mendita mendeme lotuu anda nee nyetae doko ita minao asa silyamona lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Endakali dupame kundi iki dimi laka lao masala naelyo. Endakali dupa kondo kaeyami laka lao masilyona’ lapae singi dokonya tenge doko nyakamame soo nyiamili doko, endakali tenge nakatenge dupa-kisa tenge setala naeyamili. ");
INSERT INTO enq2_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sambata dokonya Kamongo doko Akalinya Ikiningi dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Dokopa Jisasame ee doko yakinatala, dokaitanya lotuu anda dokonya pao kolandeamopa, ");
INSERT INTO enq2_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","andakote dokonya akali kingi yangi talyanga mende petea. Peteamopa, Parasi dupame Jisasa-kisa tenge setamana lao masetala, baa tipa pyoo, “Sambata gii dokonya endakalinya yaina dupa mee jakamaipengena lao loome latae singipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dopa leaminopa Jisasame dokaita lamaiyoo, “Sambata gii mendenya, embanya sipisipi mende yuli mendenya mangatamopa, tange kopyoo nanyetepe? ");
INSERT INTO enq2_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipisipi dupa endakalimi ita minao kalyamino. Dopana, Sambata gii dokonya kalai epe pipenge doko loome daa latae nasingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dopa latala baame akali doko lamaiyoo, “Embanya kingi doko tinoko” lea. Dokopa baanya kingi doko tinokeamopa, kingi doko auu petala kingi yangi epe dopaleaka jia. ");
INSERT INTO enq2_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dopa piamopa, Parasi dupame Jisasa aipa petala pyao kumasemape lao kamaka kolalyetala kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kambuiyamino kandatala, Jisasa baa yuu doko yakinatala pea. Dokopa endakali kambu andake mendapuame baa watao peami dupanya yaina pyapae dupa pitaka baame mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dokopa endakali dokaitame Jisasa baa akali dokona lao, lao panala naena lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dopa pia dokome, propeta Aisaiyame pii lea dake angi jia: ");
INSERT INTO enq2_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dake nambanya kalai akali, nambame baa yapao nyio doko. Baa nambanya mona setenge. Nambame baa etete auu kaenge. Nambanya Spirita doko baa-kisa palyetopa, baame mana tolatae dupa akali tata waka dupa-kisa lao panata. ");
INSERT INTO enq2_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Baame pii yanda pyoo laa naeyata. Baame pii puu lao laa naeyataka. Baame pii mende latamopa, endakali kaitinisa katatami dupame nasetami. ");
INSERT INTO enq2_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kembo maitange tambapae mende baame etete lakanyala naeyata. Ita langa konjalanya kii lao seta mende baame etete konjala naeyataka. Dopa pyoo katao, mana tolatae dokome koo dupa pitaka ita minina lata gii dokonya tuu lata. ");
INSERT INTO enq2_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Akali tata waka dupame baanya kenge dokonya tungi pyatala nee kaeyao malisoo katatamina” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Gii dokopa endakali mendapuame imambu koo paleta, akali lenge monda, muumaa mende laminao Jisasa katea dokonya epeami. Ipateaminopa, Jisasame akali doko auu piseteamopa, baa pii lao, lenge auu pyoo tao pia. ");
INSERT INTO enq2_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dokopa endakali kambu piami dupa pitaka walu latala lao pituu, “Akali dake Dapita Ikiningi dokope?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parasi dupame pii doko sepala lao pituu, “Imambu koo dupanya isingi Belesabulu dokonya pupu lapae dokome akali dakeme imambu koo dupa watao pilyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dopa leaminopa, dokaitanya masiami dupa Jisasame kandatala dokaita lamaiyoo, “Isa yuu dakenya kingdom mendenya endakali dupa pyaloo petala wakale pitamino doko, kingdom doko koeyata. Siti mendepi, anda mendenya palengepi, dupa yango-lapo pyaloo pitamino doko, dokaita kyeto joo nakatatami. ");
INSERT INTO enq2_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dopaka pyoo, Sataneme Satane yango watao pyatamo doko, baa tata dupa wakale pita. Dopa pitamopa, baanya kingdom doko aipa petala seta? ");
INSERT INTO enq2_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Belesabulu dokonya pupu lapae dokome imambu koo dupa nambame watao pingi-tamo doko, nyakamanya tata dupame apinya pupu lapae dokome imambu koo dupa watao pingima? Nyakamanya tata dupameaka nyakama yapatami. ");
INSERT INTO enq2_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gotenya Spirita dokonya kyeto dokome imambu koo dupa nambame watao pingi-tamo doko, Gotenya kingdom doko nyakama-kisa ipao silyamosa pingi. ");
INSERT INTO enq2_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Akali mendeme akali pupu lapae mendenya andaka kolandatala baa yaki pinya setala naeyatamo doko, baanya pinju dupa kapa pao nyetape? Daa, akali pupu lapae doko wambao kendeme yaki pinya setapala pinju dupa nyeta. ");
INSERT INTO enq2_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Namba nisala naenge endakali dokome namba yanda pingingi. Namba-pipa kambu pyala naenge endakali dokome endakali dupa tale pisingi. ");
INSERT INTO enq2_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tenge dokonya nambame nyakama langilyo: Endakali dupanya koo pingipi, lao nepengepi, dupa pitaka Goteme kunao nepakamaita. Dopaka doko, Spirita doko lao nepata endakali dokonya koo doko Goteme kunao nepakamaiya naeyata. ");
INSERT INTO enq2_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Akalinya Ikiningi doko pii koo lata endakali dokonya koo doko Goteme kunao nepakamaita. Dopaka doko, Oli Spirita doko pii koo lata endakali dokonya koo doko Goteme indupapi, tangapi kunao nepakamaiya naeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ita mendenya dii mandelya dupa kandatala, ita doko dopale-lamo lao masingi. Ita mende epe-tamo doko, dii mandita dupa epeaka. Ita mende koo-tamo doko, dii mandita dupa koaka. ");
INSERT INTO enq2_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyakama koo kanopatonya mandipae, koo pingima dupame aipa petala pii epe mende latami? Endakalinya monanya paliu tumbilya dokoaka kambunya pyakalyingi. ");
INSERT INTO enq2_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Endakali epe mendenya monanya epe palelya dokoaka kambunya pyakalyingi. Endakali koo mendenya monanya koo palelya dokoaka kambunya pyakalyingi. ");
INSERT INTO enq2_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nambame nyakama dapa langilyo: Goteme endakali dupa yapatamo gii dokopa, endakali dupame masala naeyao pii mendapu ambe lelyamino dupanyaka, Goteme aipuma leamipi lao tipa pitamopa, yanu pyao lamaitami. ");
INSERT INTO enq2_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Embanya pii late dokonyaka, Goteme emba-kisa tenge mende nasilyamona lata. Embanya pii late dokonyaka, Goteme emba-kisa tenge mende silyamona latana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gii dokopa Mosesanya loo mana nyepaepi, Parasipi mendapuame Jisasa lamaiyoo, “Mana Lenge, embame mirakolo mende pitinopa kandamu laka lao masilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Endakali koo pingipi, Gote yakinengepi dupame mirakolo mende kandamana nambame pii lelyamino. Dopa lelyaminoaka doko, propeta Jona-kisa mirakolo pia doko iki makande petae silyamona, mirakolo waka mende nakanjamino. ");
INSERT INTO enq2_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona baa kotaka gii tepo, kuka gii tepoaka, pisa andake mendenya ingi koko paleamoliaka pyoo, Akalinya Ikiningi doko, kotaka gii tepo, kuka gii tepoaka, yuu koko palita. ");
INSERT INTO enq2_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Joname akali Ninipe tange dupa Gotenya pii doko panao lamaiyamopa, dokaitame sepala mona kapilyiami. Salapape! Mendita mendeme Jona ita minao asa silyamo. Tenge dokonya, Goteme endakali dupa yapatamo gii dokopa, Ninipe tange dupa endakali indupa palelyamino dupa-pipa sakatatala, dupa tenge setapala tanda maipengena latami. ");
INSERT INTO enq2_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kuini enda kingi tolaetena tange dokome yuu londati-waka pituu, Solomonenya masepae epe dupanya pii dupa nyotoo lao epea. Salapape! Mendita mendeme Solomone ita minao asa silyamo. Tenge dokonya, Goteme endakali dupa yapatamo gii dokopa, kuini enda kingi tolaetena tange doko endakali indupa palelyamino dupa-pipa sakatatala, dupa tenge setapala tanda maipengena latana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Imambu koo mendeme endakali mende-kisa paliu pyakalyetala, endaki naepenge yuu dupanya koto nyoo katapenge panda kutao paenge. ");
INSERT INTO enq2_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kutao kaeyapala baame lao pituu, ‘Nambame anda wamba yakineo dokonya pilyotoo’ lenge. Dopa latala, imambu koo dokome pilyetala kandelyamopa, anda dokonya mende napaliu, kuni nasoo, auu pyoo wasetae katenge. ");
INSERT INTO enq2_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dokopa baa ita minao imambu etete koo kalange mendatupa lanyepala, anda dokonya kolandatala katengema. Dokopa, wamba akali doko kopeta katengeaka doko, imambu koo dutupa baa-kisa ipao palelyaminopa, baa eteteaka kopeta katenge. Endakali koo pingi indupa palelyamino dupa-kisa dopaka pitamopa, etete kopeta katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisasame endakali kambu dupa pii lamaiyoo kateamopa, baanya endangi dokopi, kaiminingipi dupame baa pii lamaimana lao kamaka kateami. ");
INSERT INTO enq2_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kateaminopa endakali mendeme Jisasa lamaiyoo, “Embanya endangi dokopi, kaiminingipi dupame emba pii langimana lao kamaka kalyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dopa leamopa Jisasame akali dokonya pii yanu pyakamaiyoo, “Nambanya endangi doko api? Nambanya kaiminingi dupa apitupape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dopa latala, baanya kingi kondeme baanya disaipolo dupa laitaka petae katao lao pituu, “Endakali pilyamino dakaita nambanya endangipi, kaiminingipina kanjepa. ");
INSERT INTO enq2_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nambanya Takange kaiti-kisa katenge dokonya masingili pingima endakali dupa nambanya kaiminingipi, pimalengepi, endangipina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yuu gii mendai dokonyaka Jisasa baa anda doko yakinatala, endaki pete lemba dokonya pao petea. ");
INSERT INTO enq2_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Peteamopa endakali longo mendapu ipao kambu piaminosa, baa sipi dokonya pyakalyetala petea. Dokopa endakali kambu doko pitaka endaki pete lemba dokonya kateami. ");
INSERT INTO enq2_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kateaminopa Jisasame pii longo mendapu kongalimi endakali dupa lamaiyoo, “Salapape! Ee pokenge mendeme baanya ee wai lyandala pea. ");
INSERT INTO enq2_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pupala lyandeamopa ee wai yangi dupa kaitininya pao sia. Sia dupa yaka dupa ipupala nao eteami. ");
INSERT INTO enq2_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ee wai yangi dupa kana-kisa yuu kuki singi dupanya pao sia. Sia dupa yuu kuki singi dokonya, pupae langa lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Langa leaka doko, pingi auu pyoo napiamosa, niki popo pyoo tea dokome dupa sapupala kumia. ");
INSERT INTO enq2_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ee wai yangi dupa lyiki tenge palenge dupanya pao sia. Sia dupa langa leaka doko, lyiki tambetambe andapala kui pyambea. ");
INSERT INTO enq2_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ee wai yangi dupa yuu epe dupanya pao sia. Sia dupa andao dii mandipala, yangimi dii 100 lao mandea. Yangimi dii 60 lao mandea. Yangimi dii 30 lao mandea. ");
INSERT INTO enq2_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nambame pii lelyo dutupa endakali kale katenge dupame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dokopa disaipolo dupa Jisasa katea dokonya ipupala baa lamaiyoo, “Embame kongaliaka lao endakali dupa pii lamailyino doko, aipuma lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dokopa baame dokaitanya pii yanu pyakamaiyoo, “Kingdom kaiti-kisa singi dokonya pii tenge yalo petae dupa masalapale lao nyakama ditilyamo. Dopaka doko, endakali waka dupame masina lao namaiya. ");
INSERT INTO enq2_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aipumape, longo lao singi endakali doko baa konda pyoo maita. Maitamopa baa-kisa longoaka seta. Dopaka doko, nasingi endakali doko-kisa kuki seta dutupa baa-kisa nasina lao tange nyokonyeta. ");
INSERT INTO enq2_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Endakali dupame lengeme kandelyaminoaka doko, tenge angi dupa kandao nyala naelyamino. Kaleme silyaminoaka doko, tenge angi dupa soo nyala naeyao, masala naeyaowaka pilyamino. Tenge dokonya, nambame endakali dupa kongaliaka lao lamaingi. ");
INSERT INTO enq2_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Endakali dopale dupanya lao propesi pii mende Aisaiyame lao pituu, ‘Nyakamame pii kaleme setamiaka doko, tenge angi doko soo nanyetami. Nyakamame lengeme kandatamiaka doko, tenge angi doko kandao nanyetami. Akali tata dakaitame angi doko lengeme kandata, kaleme sepa, moname maseta petala, mona kapilyala naeyamana latala, nyakamanya mona pyakilyoo, kaleme auu pyoo pii nasoo, lenge konjoo pilyamino. Mona kapilyimili doko, nambame dakaita auu pisipulina’ lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dopaka doko, nyakamame angi doko lengeme kandao, kaleme soaka pilyamino dokonya, nyakama Goteme auu pisetae. ");
INSERT INTO enq2_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nyakamame kandelyamino dupa, propetapi, endakali tolataepi, longo mendapuame kandamu laka lao masiamiaka doko, angi nakandeami. Pii nyakamame silyamino dupa simu laka lao masiamiaka doko, angi nasiamina lao nambame nyakama kiningi langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ee pokenge dokonya lao kongali lalo dokonya dii tambao langilyona salapape: ");
INSERT INTO enq2_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ee wai yangi kaitininya lyandeana lalo dokonya tenge doko dake: Endakali yangimi kingdom kaiti-kisa singi dokonya pii doko sepala tenge angi doko nanyilyaminopa, koo akali doko ipupala, pii Goteme endakali dupanya monanya ee wai joo lyandelya doko nyoo nepenge. ");
INSERT INTO enq2_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ee wai yangi kana-kisa yuu kuki singi dupanya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko sepala, auu kaeyao yapa nyepala, ");
INSERT INTO enq2_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","gii kuki mendatupa auu pyoo katengema. Dopaka doko, pii doko mambele kenda dupa epelyamopapi, endakali waka dupame dokaita tanda maiyoo koeyasilyaminopapi, pii doko dokaita-kisa pingi pyala naenge dokonyana, dokaita pupae isa pyakengema. ");
INSERT INTO enq2_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ee wai yangi lyiki tenge palenge dupanya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko singimaka doko, muni putiti kaenge mana dokome dokaita minakasilyamopa, yuu dakenya nee kaenge dupame pii doko kui pyapala, dupa-kisa dii namandenge. ");
INSERT INTO enq2_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ee wai yangi yuu epenya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko soo nyepala, yangimi dii 100 lao mandenge, yangimi dii 60 lao mandenge, yangimi dii 30 lao mandengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisasame kongali pii mende apata dokaita lamaiyoo, “Kingdom kaiti-kisa singi doko, akali mendeme baanya eenya wita wai epe lyandeamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Baanya endakali dupa pitaka palipiaminopa, akali dokonya yandapipi mende ipupala, wita wai lyandatae kaina dupanya koo tanu mendapu lyandatala pea. ");
INSERT INTO enq2_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maitakao wita dupa langa latala andao dii mandeamopa, koo tanu dupa apata langa latala katea. ");
INSERT INTO enq2_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dokopa ee tange dokonya kalai akali dupa baa katea dokonya ipupala baa lamaiyoo, ‘Akali Andake, embanya ee dokonya embame wita wai epe dupa lyandala naeyepe? Aipa petala ee dokonya koo tanu dupa kalyape?’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dopa leaminopa baame dokaita lamaiyoo, ‘Doko akali yandapipi mendeme lyandeana’ lea. Dopa leamopa kalai akali dupame baa lamaiyoo, ‘Naimame dupa yukuu kambu pyala pupale lao masilyipi?’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Dopa leaminopa baame dokaita lamaiyoo, ‘Daa, koo tanu dupa yukuatiti, wita dupa apata yukutamina, lapota pyasoo andena kaeyalapa. Wambu pita gii dokopa, nee mandyoo mau pingima dupa nambame lamaiyoo, “Koo tanu dupa itatenya soo yangapengena, nyakamame dupa wambao yukuu yaki pyepa. Dopa petala wita dupa nyoo kambu pyatala, nambanya nee setenge anda dokonya setalapa” latona’ leana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisasame kongali pii mende apata dokaita lamaiyoo, “Kingdom kaiti-kisa singi doko, akali mendeme masete dii mende nyepala, baanya eenya lyandeamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ee wai dupa pitakanya masete dii doko etete yakane. Dopaka doko, lyandataesa langa latala andao, ee wai pokatae waka dupa pitaka ita minatala, ita joo yale jingi. Yale jilyamopa, wangya dupanya yaka ketae paenge dupa ipao anda pingimana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisasame kongali pii mende apata dokaita lamaiyoo, “Kingdom kaiti-kisa singi doko, enda mendeme yisa mendalapo palao beke tepomanya pyasoo endaki minilyamopa, yisa dokome palao doko pitakanya taeyapala andasingi dopalena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisasame endakali kambu dupa pii lamaiya datupa pitaka kongaliaka lao lamaiya. Baame pii lamaiya dupanya mende mee lamaiya naeyao, kongaliaka lao lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Baame kongaliaka lao lamaiya dokome, propeta mendeme lao pituu, “Nambame pii dupa kongaliaka lao langito. Yuupa kaitipa dolapo tee pia dokonya pituu, indupa tuu lao, masepae yalo petae katenge dupa nambame lao panatona” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisasame endakali kambu dupa yakinatala, baa andaka kolandea. Dokopa baanya disaipolo dupa ipupala baa lamaiyoo, “Koo tanu eenya katenge dupanya lao kongali laleno dokonya tenge doko naima langi” leami. ");
INSERT INTO enq2_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dopa leaminopa baame dupanya pii yanu pyakamaiyoo, “Ee wai epe lyandeana lalo doko Akalinya Ikiningi doko. ");
INSERT INTO enq2_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ee doko isa yuu dake. Ee wai epe dupa kingdom kaiti-kisa singi dokonya ikiningi dupa. Koo tanu dupa Satanenya ikiningi dupa. ");
INSERT INTO enq2_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yandapipi mendeme koo tanu dupa lyandeana lalo doko Satane doko. Wambu pipenge gii doko yuu etapenge gii doko. Nee mandyoo mau pingima dupa enjele dupa. ");
INSERT INTO enq2_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Koo tanu dupa yukuu kambu pyatala, itatenya yangeamili pyoo, yuu etatamo gii dokopa, Satanenya ikiningi dupa yangata. ");
INSERT INTO enq2_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Akalinya Ikiningi dokome baanya enjele dupa epena latamopa, dupa ipupala, koo pina lao mapusingipi, Gotenya loo yalengepi, dupa baanya kingdom dokonya nakatena lao yapao nyepala, ");
INSERT INTO enq2_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","itate popo pyoo tao katenge panda dokonya soo pyandatami. Panda dokonya endakali dupa ee lao, nenge giti-gato lao nao katatami. ");
INSERT INTO enq2_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dokopa endakali tolatae dupa nyakamanya Takangenya kingdom dokonya tii pyoo niki joo tao katatami. Nambame pii lelyo dutupa endakali kale katenge dupame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kingdom kaiti-kisa singi doko dapale: Ee mendenya muni yalo petae kateamopa akali mendeme kandatala, sanga pyambea. Dopa petala baa auu kaeyao andaka pupala, baanya oapi singi dupa pitaka salimi latala, ee doko sambeana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kingdom kaiti-kisa singi doko dapaleaka: Akali bisinisa pingi mendeme mamaku epe mendapu sambalanya kutao paeya. ");
INSERT INTO enq2_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Akali dokome mamaku eteteaka epe, muni andake pupenge mende kutao kandatala, baa andaka pupala, baanya oapi singi dupa pitaka salimi latala, mamaku epe doko sambeana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kingdom kaiti-kisa singi doko dapaleaka: Umbene mende akali mendapuame endaki petenya pyandatala, pisa tata longo mendapu nyiami. ");
INSERT INTO enq2_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Umbene doko pisame tumbiamopa, pisa nyingi dupame pyalya lao lembasa nyepala, isa pituu yapeami. Yapapala epe dupa nyoo pengenya mandipala, koo dupa nepeami. ");
INSERT INTO enq2_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dopaka pyoo, yuu etatamo gii dokopa, enjele dupa ipupala, endakali koo pingi dupa endakali tolatae dupanya kainanya nakatena lao yapao nyepala, ");
INSERT INTO enq2_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","itate popo pyoo tao katenge panda dokonya soo pyandatami. Panda dokonya endakali dupa ee lao, nenge giti-gato lao nao katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dopa latala Jisasame baanya disaipolo dupa lamaiyoo, “Nyakamame pii datupanya tenge dupa nyilyamipi?” lea. Dopa leamopa dokaitame yanu pyao, “Kamongo, naimame nyilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dokopa baame dokaita lamaiyoo, “Mosesanya loo mana nyepae mendeme kingdom kaiti-kisa singi dokonya mana nyepala katenge doko, anda tange dopale. Anda tange dokome baanya andaka oapi enengepi, wambataepi, epe setenge dupame kalai pipenge jilyali pyoo minao kalai pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisasame kongali pii dutupa lamaiyoo etapala, baa yuu doko yakinatala, ");
INSERT INTO enq2_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","baanya yuu dokonya pea. Pupala endakali dupa nyakamanya lotuu anda dokonya mana lamaiyamopa, dupa walu lao paka kaeyapala lao pituu, “Akali dakeme masepae epepi, mirakolo pipenge kyetopi dupa anja-tae nyia? ");
INSERT INTO enq2_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Akali dake kapenda dokonya ikiningi doko daape? Baanya endangi doko Maria lenge doko daape? Baanya kaiminingi dupa Jemesapi, Josesapi, Saimonepi, Judasapi dutupa daape? ");
INSERT INTO enq2_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Baanya pimalenge dupa pitaka naima-pipa napilyamape? Baame pilyamo datupa pitakanya kyeto doko anja-tae nyiape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dopa latala dupame baa maka kaeyapala maita maiyami. Dokopa Jisasame dokaita lamaiyoo, “Propeta mende yuu waka dupanya kalyamopa, endakali dupame baa anda-anda semaingima. Dopaka doko, baanya yuu dokonya kalyamopa, baa tata dupame baa anda-anda semaiya naengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dupame baa tungi napiaminosa, baame mirakolo longo yuu dokonya napia. ");
INSERT INTO enq2_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jisasame pilyamo lapae dupa gii dokopa Galali isingi Eroteme sia. ");
INSERT INTO enq2_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sepala baanya kalai akali dupa lamaiyoo, “Akali doko baa Jone kaimbu pingi doko. Baa malunya sakatapya-lumu. Tenge dokonya, mirakolo pipenge kyeto dupa baa-kisa simupa kalai pyumuna” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Wamba Eroteme baanya kaiminingi Pilipa etanenge Erodiasa doko nyia. Dopa piamosa Joneme Erote lamaiyoo, “Embame enda doko nyilyino doko, loome daa latae singi doko yalelyenona” lao katea. Dopa lao kateamosa, Eroteme Jone minatala anjinya pyandea. ");
INSERT INTO enq2_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Anjinya pyandatala baame Jone pyao kumasotoo lao masiaka doko, endakali kambu dokome Jone baa propetana lao masiaminosa, paka kaeyapala yakinea. ");
INSERT INTO enq2_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Gii mendepa Erotenya mandenge gii doko kandao nyiaminopa, endakali peteami dupanya enombanya Erodiasa wanenge doko danisa lea. Danisa lea doko Eroteme auu kaeyapala, dopale mende dii latenopa, kiningi etete nambame dyaapona lao, baanya pii doko kyeto tasalanya, Gotenya kenge doko latala wanaku doko lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dokopa wanaku dokonya endangimi lena leali pyoo, baame lao pituu, “Jone kaimbu pingi dokonya aiyomba doko pelesa mendenya setapala namba dii” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dopa leamopa kiŋi doko mona kenda kaeyaka doko, endakali apata nee nao peteami dupanya enombanya, baanya pii dupa kyeto tasalanya Gotenya kenge doko latala, wanaku doko maitoana lea doko masetala, baame maina lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Baame Jonenya aiyomba doko kepao nyala anjetae andaka dokonya pena lea. Pena lateamopa, Jonenya aiyomba doko kepao nyepala, pelesa mendenya setapala, nyoo ipao wanaku doko maiya. Maitiamopa wanaku dokome nyepala, baanya endangi petea dokonya minao pea. ");
INSERT INTO enq2_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pateamopa Jonenya disaipolo dupa ipupala, baanya yonge doko nyoo malu piami. Malu petala, Jisasa katea dokonya pupala baa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lamaiyaminopa sepala, Jisasa baa yuu doko yakinatala, sipi mendenya pyakalyetala, baa iki endakali napalenge yuu mendenya pea. Baa pelyamo lapae doko sepala, endakali kambu dupame nyakamanya taono dupanya katao, baa watao kaitini peami. ");
INSERT INTO enq2_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisasa sipinya pituu isa pyakanatala, endakali kambu andake doko kateamino kandea. Kandatala baame endakali dokaita kondo kaeyapala, dokaitanya yaina pyapae dupa mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Niki landa piamopa, baanya disaipolo dupa baa katea dokonya ipupala baa lamaiyoo, “Endakali napalenge yuu dakenya indupa yuu kuiyalanya pilyamona, endakali kambu dapu taono yakane dupanya nyakama tange nee sambao nala pena laa” leami. ");
INSERT INTO enq2_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dopa leaminopa Jisasame lao pituu, “Daa, dakaita napena, nyakamame dakaita nee nena maiyepa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dopa leamopa dupame baa lamaiyoo, “Naimanya breta yungi-pipa, pisa lapo-pipa iki asa silyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dokopa baame lao pituu, “Dutupa nyoo ae ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dopa latala baame endakali kambu dupa tanu dupanya petena lea. Petena latala, breta yungi dutupapi, pisa lapo dolapopi, dutupa nyepala, kaiti-kisa kandalyetae katao yaka pilyino lea. Yaka pilyino latala, breta dutupa konjepala disaipolo dupa maiyamopa, disaipolo dupame endakali kambu dupa mokosoo maiyami. ");
INSERT INTO enq2_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Maitiaminopa dokaita pitakame nao tiaka kaeyapala, kakana sina kaeyami dupa disaipolo dupame nyoo baseketa 12 tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Enda wanepi dupa itaki napyao, akali tausene yungipi mendeme neami. ");
INSERT INTO enq2_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dokopa Jisasame endakali kambu dupa andaka pena latoo latala, disaipolo dupa sipi dokonya pyakalyetala, endaki pete omotena wambao pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Endakali kambu dupa pena latala, baa iki loma sala lalyoo yuu manda mendenya pea. Baa iki dokonya kateamopa, yuu kuiyala pea. ");
INSERT INTO enq2_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Disaipolo dupa sipi dokonya endaki pete kainanya peaminopa, poo yale mende laeyao lao ipupala, endaki doko buli pia dokome, sipi doko nyoo yangi pyasa-pyasa pia. ");
INSERT INTO enq2_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yuu yongao pukuiyamopa, Jisasa baa endaki pete ketae dokonya moko katao, disaipolo dupa sipinya peami dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Disaipolo dupame baa endaki pete dokonya moko katao epeamo kandatala, etete walu latala lao pituu, “Doko timango mende epelyamona” latala, paka kaeyao ae leami. ");
INSERT INTO enq2_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dopa lalu piaminopa Jisasame dokaita lamaiyoo, “Namba epelyona, nyakama mona paka nakaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dokopa Pitame baa lamaiyoo, “Kamongo, kiningi emba-tamo doko, embame namba endakinya moko katao ipu laa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dopa leamopa Jisasame, “Emba ipu” lea. Dopa leamosa, Pitame sipi doko yakinatala, Jisasa katea dokonya paanya, endakinya moko katao pea. ");
INSERT INTO enq2_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pao pituu kandeamopa, poo yale mende leamosa, baa paka kaeyapala, endakinya landa pyalanya petala, ae lao, “Kamongo, namba pyoo nyaa!” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dopa lalu piamopa, Jisasame yapa kingi pyale latala, Pita kii minao nyokonyetala baa lamaiyoo, “Embame aipuma namba kuki tungi pyatala, mona lapo palelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dopa latala dolapo sipi dokonya pyakalyiambinopa, poo doko yatu lea. ");
INSERT INTO enq2_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dopa piamopa, disaipolo sipinya peteami dupa tengesa ipupala baa mambo pyao, “Kiningi etete, emba Gote Ikiningi doko-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dokaita endaki pete dokonya omotena, yuu Genesarete dokonya pao pyakameami. ");
INSERT INTO enq2_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yuu dokonya tange akali dupame baa Jisasa-lamo lao kandatala, yuu dosa singi dupa pitakanya wai leaminopa, yaina pyapae dupa pitaka baa katea dokonya soo epeami. ");
INSERT INTO enq2_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ipupala, yaina pyapae dupame baanya yonge pee punanya iki watandena lao, yaina dupa soo epeami endakali dupame kyeto joo Jisasa tee leami. Dokopa Jisasa watandeami endakali dupa pitakanya yaina dupa mee jeta pia. ");
INSERT INTO enq2_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dokopa Mosesanya loo mana nyepaepi, Parasipi dupa Jerusalema katao, Jisasa katea dokonya ipupala lao pituu, ");
INSERT INTO enq2_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Embanya disaipolo dupa nee nalanya, kingi wasa napinya mee nelyamino doko, aipuma yumbangenya mana setapae dupa yalelyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dopa leaminopa Jisasame dupanya pii yanu pyakamaiyoo, “Nyakamanya mana wambatae dupa wata-minamana latala, aipuma nyakamame Gotenya mana setapae dupa yalelyami? ");
INSERT INTO enq2_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Goteme lao pituu, ‘Embanya endangipa takangepa dolapo anda-anda semaiyoo katape’ lea. Goteme pii mende apata lao pituu, ‘Endakali mendeme baanya endangi takangepi mende pii koo latamo doko, baa pyao kumasepengena’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dopa leaka doko nyakamame lao pituu: ‘Endakali mendeme baanya endangi takangepi mende lamaiyoo, “Nambame emba oapi dipenge dupa pitaka Gote maipengena latae silyamona” latamo doko yakana’ lengema. Dopa lelyamino dokome, baanya endangi takangepa dolapo anda-anda semaiya naena lao nyakamame daa lengema. ");
INSERT INTO enq2_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nyakamanya mana wambatae dupa wata-minamana latala, Gotenya mana setapae doko mee joo nepengema. ");
INSERT INTO enq2_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nyakama mana tolatae miningi manemane pingima dupa-pipa makande pyokondape pyoo Aisaiyame dapa lea: ");
INSERT INTO enq2_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Akali tata dakeme pii lelyamino dupame namba kalyo dokonya tengesa ipao anda-anda singingima. Dopaka doko, dokaitanya mona dupa etete waka palengema. ");
INSERT INTO enq2_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Endakalinya mana setapae dupa mana lelyamino dokome, dokaitame namba kiningi mambo pyala naengemana’ lapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dopa latala Jisasame endakali kambu doko baa katea dosa epena latala lamaiyoo, “Nyakamame pii dake sepala masokondape pyepape: ");
INSERT INTO enq2_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Endakali mendenya nenge-kaita dopale mende penge dokome baa kaimala pisala naenge. Endakali mendenya nenge-kaita dopale mende pyakalyilya dokome baa kaimala pisingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dokopa baanya disaipolo dupa ipupala baa lamaiyoo, “Parasi dupame embanya pii doko sepala imbu kaelyamino doko embame kandelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dopa leaminopa Jisasame yanu pyao, “Nambanya Takange kaiti-kisa katenge dokome ee waingi pokala naeyamo dupa pitaka pingitaka yukuta. ");
INSERT INTO enq2_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dopa pitana, nyakamame Parasi dupa katena kaeyalapape. Dokaita lenge monda dupame lenge monda yango kii miningima dopale. Lenge monda mendeme lenge monda yango mende kii minatamo doko, lapota yuli mendenya pyakatambina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dopa leamopa Pitame baa lamaiyoo, “Embame kongali laleno dokonya tenge doko naima langi” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dopa leamopa Jisasame lao pituu, “Nyakamame apata masala naelyamipi? ");
INSERT INTO enq2_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dopale mende nenge-kaita pelya doko inginya soo kamaka epenge doko nyakamame masala naelyamipi? ");
INSERT INTO enq2_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Endakali mendenya monanya palenge doko nenge-kaita pyakalyingi dokome baa kaimala pisingi. ");
INSERT INTO enq2_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Monanya paliu pyakalyingi dupa, masingi koopi, endakali pyao kumasingipi, kepo kolengepi, endapi akalipi nyelenyele paengepi, pake nengepi, endakali mende sambo lao kotimi lengepi, lao nepengepi, dupa. ");
INSERT INTO enq2_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mana dopale dupame endakali dupa kaimala pisingi. Dopaka doko, endakali mendeme kingi wasa napinya mee nee nelyamo dokome baa kaimala pisala naengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisasa baa yuu doko yakinatala, Taeyapa, Saidonepa dolaponya yuu sia dupanya pea. ");
INSERT INTO enq2_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Peamopa, Kenane tange enda mende yuu dokonya pituu ipupala, puu lao baa lamaiyoo, “Akali Andake, emba Dapita Ikiningi. Imambu koo mendeme nambanya wanenge doko etete koeyasilyamona, embame namba kondo kaeyapoko” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dopa leamopa Jisasame yanu pyao pii mende baa lamaiya naeya. Dokopa baanya disaipolo dupa ipupala kongo lao baa lamaiyoo, “Enda dakeme wii latae katao naima watao epelyamona, embame baa pena laa” leami. ");
INSERT INTO enq2_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dopa leaminopa Jisasame pii yanu pyao, “Israele dupa sipisipi alu petae joo kalyamino dupanya iki Goteme namba puu leana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dopa leamopa, enda doko ipao baa katea dosa luma lakapala, “Akali Andake, embame namba nisepoko” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dokopa Jisasame baa lamaiyoo, “Wanenya nee dupa nyepala, pyale lao yana dupa maitamopa auu napitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dopa leamopa enda dokome lao pituu, “Akali Andake, doko kiningiaka lelyeno doko, yana tange dokonya nee kuku kakanapi tokonya isa kopo lelya dupa yana dupame nyoo nengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dopa leamopa Jisasame baa lamaiyoo, “Enda, embame namba tungi pyakondape petala, nambame pyakalapenona lao masilyinoli pyekelyona” lea. Dopa lea gii dokopaka, baanya wanenge doko auu pia. ");
INSERT INTO enq2_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisasa baa yuu doko yakinatala, Galali pete lemba dokonya-kaita lalyoo manda mendenya pupala petea. ");
INSERT INTO enq2_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Peteamopa endakali kambu andake mendapuame endakali moko takyepaepi, lenge mondapi, muumaapi, kingi mokopi wuanga petaepi, waka yainame pyapaepi dupa nyoo ipao, Jisasanya moko setea dosa setapa piaminopa, baame yaina dupa pitaka mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dokopa muumaa dupame pii lao, kingi mokopi wuanga petae dupa tolao, moko takyepae dupa kaita paeyao, lenge monda dupa lenge auu pyoo tao piaminopa, endakali kambu dupame walu lao kandatala, Israelemanya Gote doko kenge minalyoo mambo piami. ");
INSERT INTO enq2_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dokopa Jisasame baanya disaipolo dupa epena latala lamaiyoo, “Endakali kambu dake yuu gii tepoma namba-pipa katamanopa, nee napenge nasilyamo dokonya, nambame dakaita kondo kaelyo. Nee nanao andaka pena lato doko, kaitinisa laowambe lapae setamina, mee napena lao masilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dopa leamopa baanya disaipolo dupame baa lamaiyoo, “Endakali napalenge yuu dakenya naimame breta anja-tae nyepala, endakali kambu andake dake nao tiaka kaena maimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dokopa Jisasame lao pituu, “Nyakamanya breta akipate silyape?” lea. Dopa leamopa dokaitame lao pituu, “Breta kalange-pipa, pisa yakane kuki mendatupa-pipa silyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dopa leaminopa, baame endakali kambu dupa isa petena lea. ");
INSERT INTO enq2_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dopa latala, breta kalange dutupapi, pisapi dutupa nyepala, Gote yaka pilyino latala konjia. Konjepala baanya disaipolo dupa maiyamopa, disaipolo dupame endakali kambu doko mokosoo maiyami. ");
INSERT INTO enq2_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Maiyaminopa, endakali dupa pitakame nao tiaka kaeteaminopa, konjepae kakana sina kaeyami dupa disaipolo dupame nyoo baseketa kalange tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Enda wanepi dupa itaki napyao, akali tausene kitomendeme neami. ");
INSERT INTO enq2_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Napeaminopa Jisasame endakali kambu dupa pena latala, baa sipi mendenya pyakalyetala, yuu Magadala dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dokopa Parasipi, Sadyusipi mendapu Jisasa katea dokonya ipupala, baa makande pyoo, kaiti-kisa-tae mirakolo mende kandamana pina leami. ");
INSERT INTO enq2_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Niki landa pilyamopa, kaiti kate pilya doko kandatala nyakamame lao pituu, ‘Taita paina pita-lamona’ lengema. ");
INSERT INTO enq2_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yuu yongelyamopa, nyakamame lao pituu, ‘Kaiti kate pyatala kopa longo silyamo dokonya, aiyuu ipapome-lamona’ lengema. Nyakamame kaiti doko kandatala, taita dopa pita-lamo lao dii tambao lengemaka doko, indupa gii dakepa pilyamo dupa nyakamame dii tambao kapa nalelyamino. ");
INSERT INTO enq2_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Endakali koo pingipi, Gote yakinengepi dupame mirakolo mende kandamana nambame pii lelyamino. Dopa lelyaminoaka doko, propeta Jona-kisa mirakolo pia doko iki makande petae silyamona, mirakolo waka mende nakanjaminona” lea. Dopa latala baame dupa yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Baanya disaipolo dupame breta nyoo napenya, kame sepala endaki pete dokonya omotena peami. ");
INSERT INTO enq2_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dokopa Jisasame dokaita lamaiyoo, “Parasipi, Sadyusipi dupanya yisa dupame nyakama koeyasetamina, kandao kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dopa leamopa nyakama-lapo laloo pyoo, “Naimame breta nyoo naipamano dokonya lelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Dopa leamino doko Jisasame kandatala dokaita lamaiyoo, “Nyakama Gote kuki tungi pingima dupame, aipuma breta nyoo naipamanona lao nyakama-lapo lelyami? ");
INSERT INTO enq2_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Indupapi nyakamame masala naelyamiakape? Nambame breta yungi dutupa akali tausene yungi dupanya konjakamaiyopa, nao kakana sina kaeyamino dupa nyakamame nyoo baseketa akipatenya tumbasiamape lao nyakamame masala naelyamipi? ");
INSERT INTO enq2_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nambame breta kalange dutupa akali tausene kitomende dupanya konjakamaiyopa, nao kakana sina kaeyamino dupa nyakamame nyoo baseketa akipatenya tumbasiamape lao masala naelyamiakape? ");
INSERT INTO enq2_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Parasipi, Sadyusipi dupanya yisa dupame nyakama koeyasetamina kandao kalyepapena lao langyo doko, bretanya lao nalalo doko, nyakamame aipa petala masala naelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dopa leamopa, yisa bretanya pyandenge dupame daa, Parasipi, Sadyusipi dupanya mana dupame nyakama koeyasetamina kandao kalyepape lalame-lamo lao disaipolo dupame masiami. ");
INSERT INTO enq2_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sisaria Pilipae dokonya yuu sia dupanya Jisasa pupala, baanya disaipolo dupa tipa pyoo, “Endakali dupame namba Akalinya Ikiningi doko apina lelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dokopa dokaitame lao pituu, “Yangimi emba Jone kaimbu pingi dokona lelyamino. Yangimi emba Ilaijana lelyamino. Yangimi emba Jeremaeya-tamopi, propeta wamba kateami dupanya mende-tamopi, mendena lelyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dopa leaminopa baame dokaita lamaiyoo, “Endakali dupame dopa lalumino doko, nyakamame namba apina lelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dopa leamopa Saimone Pitame yanu pyao, “Emba Kraisa, Gote kataowaka katenge dokonya Ikiningi dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Saimone, Jona ikiningi, Goteme emba auu pisetae. Embame pii lelyeno doko, endakali mendeme langya naelyamo. Nambanya Takange kaiti-kisa katenge dokome emba-kisa panasimupa lelyeno. ");
INSERT INTO enq2_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nambame emba dapa langilyo: Emba Pita. Nambanya siosa doko kana dake-kisa pitopa, endakali kumapae dupa katengema panda dokonya lome nyetae dokome siosa doko ita minala naeyata. ");
INSERT INTO enq2_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kingdom kaiti-kisa singi dokonya kii dupa nambame emba dito. Embame dopale mende isa yuu dakenya yaki pitino doko, kaiti-kisa yaki petaeyaka seta. Embame dopale mende isa yuu dakenya tata lateno doko, kaiti-kisa tata lataeyaka setana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dopa latala, Jisasa baa Kraisa dokona lao baanya disaipolo dupame endakali mende lamaiya naena lao kyeto joo daa lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gii dokopa Jisasame baanya disaipolo dupa tee pyao panao dapa lamaiya: “Namba Jerusalema pupenge. Patopa Juumanya isingi akalipi, prisa mupapi, Mosesanya loo mana nyepaepi, dupame namba tanda longo ditaminopa namba pyao kumasepenge. Kumasetataminopa, yuu gii tepo dokonya Goteme namba sakatasetana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dopa leamopa, Pitame Jisasa baa laminao umbisale pupala, tee pyao pyalanya lao, “Kamongo, embame lelyeno doko emba-kisa dopa napinana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dopa leamopa Jisasa kandapilyetala Pita lamaiyoo, “Satane, embame Gotenya masingili pyoo nalenya, endakalinya masingili pyoo lelyeno dokome nambanya kaita lyokekelyenona, embame namba yakinatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dopa latala Jisasame baanya disaipolo dupa lamaiyoo, “Endakali mendeme namba watao ipatoo lao maseta dokome baa tange kame sepala, baanya poko ita doko tange nyoo soo namba watao ipupenge. ");
INSERT INTO enq2_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Endakali mendeme baa lete katatoana lao masetala, baa tange pyoo nyalanya pitamo dokome baanya lete katenge doko yakinata. Dopaka doko, endakali mendeme namba masetala, baanya lete katenge doko yakinata dokome baanya lete katenge doko kandao nyeta. ");
INSERT INTO enq2_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Endakali mendeme yuunya oapi dupa pitaka nyoo setao katapala, baanya lete katenge doko yakinatamo doko, oapi dupame baa aipa petala niseta? Baanya lete katenge doko aki mendeme tange sambao nyeta? ");
INSERT INTO enq2_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Akalinya Ikiningi doko baanya enjele dupa-pipa, baanya Takangenya tii pipae andake dokonya ipata. Ipupala endakali mendai-mendaimi mana minatamili pyoo yole pita. ");
INSERT INTO enq2_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nambame nyakama kiningi langilyo: Endakali asa kalyamino dapuanya mendapu kumala naeyataminopa, Akalinya Ikiningi doko baanya kingdom doko-pipa ipatamopa kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yuu gii tokange pateamopa, Jisasame Pitapi, Jemesapi, Jemesa kaiminingi Jonepi, dutupa iki laminao, yuu manda ketae mendenya lalyoo pea. ");
INSERT INTO enq2_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pupala kateaminopa, dutupanya enombanya Jisasa baa waka jia. Baanya lenge-lyaapi doko tii pyoo niki tele pia. Baanya yonge pee dupa kyeo lea doko tii pipae jia. ");
INSERT INTO enq2_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dokopa Mosesapa, Ilaijapa dolapo baa-pipa pii lao kalyu piambinopa kandeami. ");
INSERT INTO enq2_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kandatala Pitame Jisasa lamaiyoo, “Kamongo, naima dakenya katamanopa auu pilyamona, embame yakana lao maseteno doko, naimame dakenya sele anda tepoma pimana. Mende embanya, mende Mosesanya, mende Ilaijanyana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dopa lao kateamopa, kopa tii pipae mende ipupala dutupa sanga pia. Dokopa pii mende kopa tambetambe epea dokome lao pituu, “Dake nambanya Ikiningi mona setenge, nambame etete auu kaenge dokona, nyakamame baanya pii doko sakamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dokopa disaipolo dutupame pii doko sepala, etete paka kaeyapala tombauli siami. ");
INSERT INTO enq2_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dopa piaminopa, Jisasa ipao dutupa watandatala lao pituu, “Nyakama paka nakaenya sakatalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dopa leamopa dutupame kandalyiaminopa, endakali waka mende nakatea. Jisasa baa iki kateamo kandeami. ");
INSERT INTO enq2_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yuu manda doko yakinatala lanao ipao pituu, Jisasame dutupa kyeto joo lamaiyoo, “Nyakamame kanjamino doko, Akalinya Ikiningi doko kumapala sakatatatamopa, endakali dupa lamaitamina, indupa endakali mende lamaiya naeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dokopa baanya disaipolo dutupame baa tipa pyoo, “Dopa-tamo doko, Mosesanya loo mana nyepae dupame aipuma Ilaija wambao ipupengena lengemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dopa leaminopa Jisasame dutupanya pii yanu pyakamaiyoo, “Kiningi, Ilaija wambao ipupenge. Ipupala baame dupa pitaka tolaseta. ");
INSERT INTO enq2_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Dopaka doko, Ilaija ipateana lao nambame nyakama langilyo. Baa ipupala kateamopa endakali dupame kandao nanyepala, dokaitanya masiaminoli pyoo baa tanda maiyami. Akalinya Ikiningi doko dopaka pyoo tanda maitamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dopa leamopa, Jone kaimbu pingi doko lao lelyamona lao disaipolo dupame masiami. ");
INSERT INTO enq2_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dutupa endakali kambu pyao kateami dokonya ipateaminopa, akali mende Jisasa katea dokonya ipao luma lakapala ");
INSERT INTO enq2_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","baa lamaiyoo, “Kamongo, nambanya wane dake mandipaeme nyilyamosa, baa tanda longo nao katenge. Paa longosa baa itatenya tapa, endakinya mangata pingina, embame baa kondo kaeyakapoko. ");
INSERT INTO enq2_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nambame baa laminao embanya disaipolo dupa katami dokonya ipupupa, dupame baa kapa pao auu pisala naeyalaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dopa leamopa Jisasame yanu pyao, “Nyakama mana epe minala naeyao, Gote tungi pyala naeyaowaka pingima dupa, namba nyakama-pipa katao pao gii andukupa yakinato? Nyakama nongo pilyamino doko andukupa tolataminopa lao nambame malisoo katao? Wane doko laminao asa ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Laminao ipateaminopa, Jisasame imambu koo doko pyalanya latala, wane doko yakinatala pena leamopa pea. Dopa lea gii dokopaka, wane doko auu pia. ");
INSERT INTO enq2_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maitakao Jisasa iki peteamopa, disaipolo dupa ipupala baa lamaiyoo, “Aipuma naimame imambu koo doko kapa pao watao pyala naeyalamape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dopa leaminopa Jisasame dokaita lamaiyoo, “Nyakamame Gote tungi napilyamino dokonya, imambu koo doko kapa pao watao pyala naeyalamino. Nambame nyakama kiningi langilyo: Nyakamanya Gote tungi pingi doko yakane masete dii dopalepi mende-pyali doko, nyakamame yuu manda dake lamaiyoo, ‘Emba asa pituu omosa puu’ laminopa, lamiliaka pipyali. Dokopa nyakamame dopale mende pyaanya kokala naeyamili. ");
INSERT INTO enq2_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dopaka doko, loma soo nee nanao katenge mana dokonya-kaita iki imambu koo dopale dupa watao pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisasa baanya disaipolo dupa-pipa Galali paeyao pituu baame dokaita lamaiyoo, “Akalinya Ikiningi doko akali dupanya kinginya maiyanya pilyamo. ");
INSERT INTO enq2_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Maitatamopa dupame baa pyao kumasetami. Kumasetataminopa yuu gii tepo dokonya, Goteme baa sakatasetana” lea. Dopa leamo doko sepala, disaipolo dupa mona etete kenda kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dokaita Kapename peaminopa, lotuu anda nee nyetae dokonya takisa nyingi dupa ipupala Pita lamaiyoo, “Nyakamanya mana lenge dokome lotuu anda nee nyetae dokonya takisa doko maingipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Dopa leaminopa Pitame yanu pyao, “Maingina” lea. Dopa latala, baa andaka kolandatala pii mende latala naeyamopa, Jisasame baa lamaiyoo, “Saimone, embame aipa lao masilyi? Yuu dakenya kiŋi dupame nyakamanya ikiningi dupa-kisa takisa nyingimape, pande endakali waka dupa-kisa takisa nyingimape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dokopa Pitame baa lamaiyoo, “Endakali waka dupa-kisa takisa nyingimana” lea. Dopa leamopa Jisasame baa lamaiyoo, “Dopa-tamo doko, kiŋi dupame nyakamanya ikiningi dupa-kisa takisa nanyingima. ");
INSERT INTO enq2_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dopaka doko, naimame akali dokaita kenda pisala naeyamana, emba endaki pete dokonya pupala, uku mende pyandape. Dokopa pisa wambao nyalapeno dokonya nenge-kaita angapu lakepala, muni konde mende palyamona nyepe. Nyepala, dokome lotuu anda nee nyetae dokonya nalimbanya takisa doko maipi” lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gii dokopa disaipolo dupa Jisasa katea dokonya ipupala baa lamaiyoo, “Kingdom kaiti-kisa singi dokonya api alyasale joo kalyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dopa leaminopa, Jisasame wane koo mende epena latala, dokaitanya kainanya katasetala ");
INSERT INTO enq2_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","dokaita lamaiyoo, “Nyakamanya mana dupa aloo petala, wane wanakupi koo joo nakatatamino doko, kingdom kaiti-kisa singi dokonya kolandala naeyatamina lao nambame nyakama kiningi langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Endakali mende baa anasale jetala, wane koo dapale joo kalyamo doko, baa kingdom kaiti-kisa singi dokonya alyasale joo katenge. ");
INSERT INTO enq2_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Endakali mendeme nambanya kenge dokonya wane koo dapale mende auu kaeyao lanyilya dokome, namba lanyilyamosaka pingi. ");
INSERT INTO enq2_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dopaka doko, namba tungi pingima wane koo datupanya mende endakali mendeme koo pina lao mapusetamo doko, baa tumbi-tambi napala kumina lao, wita dii indyepenge kana yale mende baanya mangenya kende katatala, solowata lumu mendasa soo pyandamili doko yaka jipyalina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Koo pina lao mapusingi tata longo dupa isa yuu dakenya silyamo dokonya isa yuu dake koeyata! Koo pina lao mapusingi tata longo dupa kiningi etete ipata. Ipataka doko, koo pina lao mapuseta akali doko baa koeyata! ");
INSERT INTO enq2_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Embanya kingi mokopi mendeme emba koo pyaale lao mapusia-kandeno doko, kepanya nepape. Moko kepanya nepatalapi, kingi kepanya nepatalapi, emba lete katenge dokonya kolandateno doko auu pita. Kingi lapotapi, moko lapotapi katao, itate tao kalyu katenge dokonya soo pyandatamo doko auu napita. ");
INSERT INTO enq2_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Embanya lenge mendeme emba koo pyaale lao mapusia-kandeno doko, lukunya nepape. Emba lenge mendai iki tao, lete katenge dokonya kolandateno doko auu pita. Emba lenge lapota tao, itate tao katenge, ele panda koo dokonya soo pyandatamo doko auu napitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Wane koo datupanya enjele dupame koteaka lao nambanya Takange kaiti-kisa katenge dokonya enomba kandengemana, nyakamame dupanya mendaipi mende kandanya palyala naeyalapape lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aipumape, Akalinya Ikiningi dokome endakali alu petae dupa pyoo nyalanya epea. ");
INSERT INTO enq2_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nyakamame aipa lao masilyami? Akali mendenya sipisipi 100 katata dokonya mendai alu pitamopa, baame aipa pita? Baame sipisipi 99 dutupa katena latala, mendai alu pita doko yuu manda dupanya pupala kutala naeyatape? ");
INSERT INTO enq2_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nambame nyakama kiningi langilyo: Sipisipi 99 alu napitami dutupa auu kaeyatamoaka doko, baame mendai doko kutao nyepala etete auu kaeyata. ");
INSERT INTO enq2_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dopaka pyoo, nyakamanya Takange kaiti-kisa katenge dokome wane koo datupanya mende alu napipya laka lao masingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Embanya kaiminingi mendeme emba koo pingitamo doko, baa katata dokonya emba pupala, nyakamba iki pitipala, baanya koo pita doko lao panasoo lamaipi. Lamaitinopa, baame embanya pii doko setamo doko, embanya kaiminingi doko pilyoo nyete. ");
INSERT INTO enq2_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Baame embanya pii doko nasetamo doko, pii pepa pyapae singili pyoo, nyakambanya pii latambi dupa sina, endakali mendai lapopi mende lanyepala baa dee lamaiya pupape. ");
INSERT INTO enq2_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Baame dutupanya pii nasetamo doko, embame siosanya endakali kambu pyatae dupa lamaipi. Baame siosanya apata pii nasetamo doko, baa akali tata wakapi, takisa nyingipi, dopale-lamo lao masalapape. ");
INSERT INTO enq2_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nambame nyakama kiningi langilyo: Nyakamame dopale mende isa yuu dakenya yaki pitamino doko, kaiti-kisa yaki petaeyaka seta. Nyakamame dopale mende isa yuu dakenya tata latamino doko, kaiti-kisa tata lataeyaka seta. ");
INSERT INTO enq2_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nambame dee nyakama dapa langilyo: Nyakamanya mendalapome isa yuu dakenya katao mona mendai palipala, nambanya Takange kaiti-kisa katenge dokome mende pyekena lao tee latambinopa, latambiliaka pyakata. ");
INSERT INTO enq2_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Endakali lapo tepopi mende nambanya kengenya kambu pyao pititami dokonya kainanya namba apata katatona” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dokopa Pita baa Jisasa katea dokonya ipupala baa lamaiyoo, “Kamongo, nambanya kaiminingi mendeme paa akipatesa koo pingitamopa, nambame baanya koo dupa kame sakamaipenge? Paa kalangesape, pande akipatesape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dopa leamopa Jisasame baa lamaiyoo, “Paa kalangesa iki daa. Paa 77 pyoo koo pita dupa kame sakamaipengena lao nambame emba langilyo. ");
INSERT INTO enq2_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Dopana, kingdom kaiti-kisa singi doko kiŋi mendeme baanya kalai akali dupa-kisa yanu maiyamo dupa yanu pyekena latoo lao masiamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kiŋi dokome tee pyao yanu dupa pyekena lao kateamopa, kalai akali yanu singi dupanya mende laminao epeami doko-kisa silipa muni tausene akalita yanu sia. ");
INSERT INTO enq2_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akali dokome yanu dupa kapa pao pyapenge nanjiamosa, kiŋi dokome akali dokopi, baanya enda wanepi, baanya oapipi dupa pitaka salimi latala, yanu dupa pyekena lao lamaina lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dopa leamopa, kalai akali dokome kiŋi dokonya enombanya luma lakapala, ‘Akali Andake, nambame embanya yanu dupa pitaka pyakatona, embame namba maka nakaenya malisepoko’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dopa leamopa, kalai akali dokonya akali andake dokome baa kondo kaeyapala, baanya yanu dupa kaeyapala kaeya. ");
INSERT INTO enq2_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Dopa peteamopa, kalai akali doko pupala, baanya kalai akali yango mende-kisa 100 silipa muni yanu sakamaingi doko kutao kandatala, mangenya puu lao minia. Minatae katao baa lamaiyoo, ‘Nambanya yanu dutupa pyaka’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dopa leamopa, kalai akali yango dokome baanya moko sia dosa luma lakapala baa lamaiyoo, ‘Nambame embanya yanu dupa pyakatona, embame namba maka nakaenya malisepoko’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dopa leamoaka doko baame daa latala, kalai akali yango dokome yanu dutupa etao pyatakala ipatana latala anjinya pyandea. ");
INSERT INTO enq2_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dokopa baanya kalai akali yango dupame piamo doko kandatala, dokaita mona etete kenda kaeyapala, dokaitanya akali andake doko pao lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lamaiyaminopa, kiŋi dokome kalai akali doko epena latala lamaiyoo, ‘Emba kalai akali koo-lamo! Nambame emba nisepoko lao tee lapino dokonya, nambanya yanu emba-kisa sipumu dutupa pitaka kaeyapala kaeyapu. ");
INSERT INTO enq2_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nambame emba kondo kaeyapu dopaka pyoo, embanya kalai akali yango doko kondo kaeyateno!’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dopa latala kiŋi doko imbu kaeyapala, kalai akali dokome yanu dutupa etao pyatakala ipatana latala, tanda maingima akali dupanya kinginya maiya. ");
INSERT INTO enq2_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dopana, nyakamanya kaiminingi mendeme koo pingita dupa monanya katao kame sakamaiya naeyatamino doko, nambanya Takange kaiti-kisa katenge dokome nyakama mendai-mendai dupanya koo pitami dupa kame sakala naeyatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisasame pii dutupa lao etapala, baa Galali yakinatala, Judia yuu dokonya endaki Jodane yangitena pea. ");
INSERT INTO enq2_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dokopa endakali kambu andake mendapuame baa watao epeaminopa, baame dokaitanya yaina dupa mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dopa piamopa Parasi dupa baa katea dokonya ipupala baa makande pyaanya tipa pyoo, “Akali mendeme baanya enda doko-kisa tenge mende setapala yakinatamo doko, loome daa latae singi doko yalatape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Tee pia dokopa, endakali wasingi dokome enda akalipa lao wasia. Wasepala baame lao pituu, ‘Tenge dokonya, akalimi baanya endangi takangepa dolapo yakinatala, baanya etanenge dokopa tole pyao pititambinopa, dolapo yonge mendai jetana’ leana lao pepa pyapae silyamo doko nyakamame itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Enda akalipa lao pilyambi gii dokonya pituu dolapo lapo joo napetenya, yonge mendai joo petengemba. Goteme nyoo pyasetae doko endakali mendeme wakale pyaloo napipengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dopa leamopa dokaitame baa lamaiyoo, “Dopa-tamo doko, Mosesame mana setea dokonya, ‘Akali mendeme baanya enda doko yakinao pituu, enda yakinenge pepa mende pyao maipengena’ lao aipuma seteape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dokopa baame dokaita lamaiyoo, “Nyakama tuu pyoo mona kana jiaminosa, Mosesame nyakamanya enda dupa yakinalapale lao kaeya. Dopaka doko, wamba tee pia dokopa, mana doko nasia. ");
INSERT INTO enq2_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dopana, nambame nyakama dapa langilyo: Akali mendenya enda doko kepo kolala naelyamopa, akali dokome enda doko yakinatala, waka mende nyilya dokome, akali doko kepo kolenge. Akali mendenya enda yakinatae mende akali mendeme nyilya dokome baa kepoaka kolengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dopa leamopa baanya disaipolo dupame baa lamaiyoo, “Enda akalipa lao petenge mana doko dopale-tamo doko, akali dupa enda nyala naeyao katataminopa, auu pita-lumuna” leami. ");
INSERT INTO enq2_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dopa leaminopa Jisasame dokaita lamaiyoo, “Akali pitakame kapa pao pii doko soo nyala naeyatami. Pii doko soo nyina lao Goteme maiyamo dupame iki soo nyetami. ");
INSERT INTO enq2_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Akali mendapu enda nanyepenge jepae mandeami dupa enda nanyoo katengema. Akali mendapu mamuni nyepae dupa enda nyala naengema. Akali mendapuame kingdom kaiti-kisa singi dokonya kalai doko pitoo lao masetala, enda nyala naengemaka. Dopana, pii doko soo nyepenge akali dupame soo nyina kaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jisasame wane wanakupi koo dupa-kisa kingi setapala loma sakamaina lao, endakali mendapuame baa katea dokonya laminao epeaminopa, disaipolo dupame endakali dupa pyalanya leami. ");
INSERT INTO enq2_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dokopa Jisasame lao pituu, “Kingdom kaiti-kisa singi doko wane wanakupi koo dapale dupanyana, dokaita epekena kaita lyokala naeyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dopa latala baame wane wanakupi koo dokaita-kisa kingi setapala baa pea. ");
INSERT INTO enq2_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wane patange mende Jisasa katea dokonya ipupala baa lamaiyoo, “Mana Lenge Epe, mana epe aipale mende minatala, lete etete katenge doko nambame nyotope?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dokopa Jisasame baa lamaiyoo, “Aipuma embame namba epe lelye? Endakali mende epe daa. Gote iki baa epe. Emba lete katenge doko nyotoo lao maseteno doko, mana setapae dupa wata-minape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dopa leamopa wane patange dokome baa lamaiyoo, “Mana setapae dupa andutupape?” lea. Dokopa Jisasame lao pituu, “Endakali pyao kumasala naeyape. Kepo kolala naeyape. Pake nala naeyape. Endakali mende sambo lao kotimi laa naeyape. ");
INSERT INTO enq2_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Embanya endangi takangepa dolapo anda-anda semaiyoo katape. Emba tange auu kaengeli pyoo, embanya patali maki dupa auu kaeyape lapae silyamo dupana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dokopa wane patange dokome baa lamaiyoo, “Namba wane kolesa pituu, mana setapae dutupa pitaka nambame wata-minio dopaka pyoo wata-minao kalyona, nambame aki mende apata pipengepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dopa leamopa Jisasame baa lamaiyoo, “Emba akali etete tolatae mende katapu laka lao maseteno doko, emba pupala, embanya oapi dupa salimi latala, endakali daa jepae dupa maipi. Maitinopa oapi epe dupa embanya kaiti-kisa sakata. Dopana, emba namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pii doko wane patange dokome sepala, baanya oapi etete longo setenge dokonyana, mona kenda kaeyapala, baa yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dokopa Jisasame disaipolo dupa lamaiyoo, “Nambame nyakama kiningi langilyo: Yuunya kamongo dupa kingdom kaiti-kisa singi dokonya kolandalanya lekeleke tatami. ");
INSERT INTO enq2_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pii mende apata nambame nyakama langilyo: Kamele mendeme kepo tii mendenya lekeleke tao kolandapyaliaka doko, yuunya kamongo mendeme Gotenya kingdom dokonya kolandalanya eteteaka lekeleke tatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dokopa baanya disaipolo dupame pii dutupa soo etete walu lao paka kaeyapala lao pituu, “Dopa-tamo doko, endakali api pyoo nyetape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dopa leaminopa, Jisasame dokaita kandatae katao lamaiyoo, “Kalai doko endakalimi kapa pao napipenge. Dopaka doko, Goteme dupa pitaka pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dopa leamopa Pitame yanu pyao, “Naimame dupa pitaka yakinatala emba watao epelyamano dokonya, naima aki mende nyetamape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dopa leamopa Jisasame dokaita lamaiyoo, “Nambame nyakama kiningi langilyo: Goteme yuupa kaitipa dolapo enenge jisetamo gii dokopa, Akalinya Ikiningi doko baanya kiŋi petenge toko dokonya tii pipae-pipa pitita. Gii dokopa nyakama namba watao paeyamino dupa kiŋi petenge toko 12 dutupanya pititami. Dokonya pituu, Israele tata 12 dutupanya pii lao tolasakamaitami. ");
INSERT INTO enq2_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Akali mendeme nambanya kenge doko masetala, baanya andapi, kaiminingipi, pimalengepi, takangepi, endangipi, endapi, wane wanakupi, eepi, dupa yakinatamo dokome wakao 100 lao nyeta. Baa lete etete katenge doko apata nyetaka. ");
INSERT INTO enq2_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dopaka doko, endakali longo enomba nyoo kalyamino dupa tanga maita-kaita katatami. Endakali longo maita-kaita kalyamino dupa tanga enomba nyoo katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisasame lao pituu, “Kingdom kaiti-kisa singi doko, ee tange mendeme yongama wamba sakatatala, baanya waene ee dokonya kalai pyekena lao, kalai akali mendapu lanyala peamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ee tange dokome kalai akali mendatupa lanyepala, yuu gii mendainya silipa muni mendaimi yole pitoana, waene ee dokonya kalai pyakala pena leamopa, dokaitame yaka-lumuna latala peami. ");
INSERT INTO enq2_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pateaminopa 9 kilokopi mendenya, ee tange doko maketanya pupala kandeamopa, akali waka mendatupa kalai mende napyoo mee kateami. ");
INSERT INTO enq2_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kateamino kandatala baame dokaita lamaiyoo, ‘Nambame nyakama yole pipenge dutupame pitoana, nyakama apata nambanya waene ee dokonya kalai pyakala pupa’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dopa lateamopa akali dupa kalai pyakamaiya peami. Dutupa pateaminopa, 12 kilokopi, 3 kilokopinya baa deaka maketanya pupala, dopaka pyoo kalai akali mendatupa lanyepala, waene ee dokonya kalai pyakala pena leaka. ");
INSERT INTO enq2_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Deaka 5 kilokopi mendenya pupala, baame akali mendatupa mee kateamino kandatala dokaita lamaiyoo, ‘Aipuma nyakama indupa gii dake pitaka dakenya mee kalyamipi?’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dopa leamopa dokaitame baa lamaiyoo, ‘Akali mendeme naima kalai nandipyanya, naima mee kalyamanona’ leami. Dokopa baame dokaita lamaiyoo, ‘Nyakama yole nyepengeli pyoo nyalaminona, nyakama apata nambanya waene ee dokonya kalai pyakala pupa’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Yuu kuiyalanya piamopa, waene ee tange dokome ee isakamaingi doko lamaiyoo, ‘Embame kalai akali dupa epena latala yole pipi. Yole pyoo pituu, kalai akali maita-pyao ipamino dupa wambao yole pima-pima pyoo, yongama wamba ipamino dupa yole pipi’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dokopa kalai akali 5 kilokonya kalai pyoo tee piami dupa ipupala, silipa muni mendai lao nyiami. ");
INSERT INTO enq2_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dopa pyoo nyiaminosa, kalai akali yongama wamba kalai pyoo tee piami dupame muni mendalapo apata wakao nyalamano lao masiami. Dopaka doko, dokaita apata silipa muni mendai laowaka nyiami. ");
INSERT INTO enq2_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dopa pyoo nyepala, dokaitame ee tange doko mumu leami. ");
INSERT INTO enq2_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Dopa latala ee tange doko lamaiyoo, ‘Kalai akali maita-pyao ipamino dokaitame awa mendai iki kalai pimino. Niki yale mende tamupa, naima indupa gii dake pitaka lekeleke tao kalai pyemano doko, embame dupa naima-pipa kapa-kapa lao yole pilyinona’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dopa leaminopa, ee tange dokome kalai akali dupanya mende lamaiyoo, ‘Kaimii, nambame emba minakasala naelyo. Emba silipa muni mendai nyatalena lapupa, nalimba pii lao yaki pyaa naeyalambape? ");
INSERT INTO enq2_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Emba yole pyoo dopaka pyoo, kalai akali maita-pyao ipamino dupa nambanya auu kaengeme yole pyoo. Nambanya muni dokome mendita mende pitoo lao masotoli pito doko, loo mende yalatope? Namba akali epe dokonya, emba mona koo palelyepe? Embanya yole doko nyoo puu’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dopana, maita-kaita kalyamino dupa tanga enomba nyoo katatami. Enomba nyoo kalyamino dupa tanga maita-kaita katatami. Aipumape, Goteme endakali longo epena lengeaka doko, baame endakali kuki yapao nyingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisasa baa lalyoo Jerusalema pao pituu, baanya 12 disaipolo dutupa iki laminao, umbisale pupala lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Salapape! Naima lalyoo Jerusalema pelyamano. Pupala katatamanopa, Akalinya Ikiningi doko prisa mupapi, Mosesanya loo mana nyepaepi, dupanya kinginya maitamopa, dupame baa pyao kumasepengena latami. ");
INSERT INTO enq2_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dopa latala, baa lamba lao, konjame pyao petala, poko itanya pyao yukuina lao, akali tata waka dupanya kinginya maitami. Dopaka doko, yuu gii tepo dokonya baa sakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gii dokopa, Sebedi ikiningi dolaponya endangi doko baanya ikiningi dolapo-pipa Jisasa katea dokonya ipupala, baanya enombanya endangi doko luma lakapala, baa-kisa mende tee lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dokopa Jisasame baa lamaiyoo, “Nambame embanya aipa pyakapili lao masilyipi?” lea. Dokopa enda dokome baa lamaiyoo, “Embanya kingdom dokonya, nambanya wane dalaponya mende embanya kingi tolaetena petena lakape. Mende embanya kingi koeyatena petena lakape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dopa leamopa Jisasame yanu pyao, “Nyakamame tee lelyamino doko masala naeyao tee lelyamino. Nambame kapo kenda paleta mendenya nalapo dokonya nyakambame kapa pao natambipi, pande nambame kaimbu kenda paleta mende nyalapo doko nyakambame kapa pao nyetambipi?” lea. Dopa leamopa dolapome baa lamaiyoo, “Nalimbame kapa pao dopa pitambana” leambi. ");
INSERT INTO enq2_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dopa leambinopa Jisasame dolapo lamaiyoo, “Kiningi, nambame kapo kenda paleta mendenya nalapo dokonya nyakambame natambiaka. Namba kaimbu kenda paleta mende nyalapo doko nyakambame nyetambiaka. Dopaka doko, nambanya kingi tolaetena petena lapenge dokopa, nambanya kingi koeyatena petena lapenge dokopa, dolapo nambanya kalai daa. Nambanya Takange dokome pititambina lao depa latae endakali dolapo pititambina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pii doko sepala, disaipolo akalita dutupame kaiminingi lapoma dolapo imbu kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dopa piaminopa, Jisasame disaipolo dutupa epena latala lao pituu, “Akali tata waka dupanya isingi akali dupame isoo katengema endakali dupa kandanya palyetala, dokaita alyasale joo katengema doko nyakamame kandengema. Akali tata waka dupanya akali andake dupame nyakamanya pii wata-minekena lao kandatae paengema doko nyakamame kandengemaka. ");
INSERT INTO enq2_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dopaka doko, nyakamanya kainanya mana dopale dupa naseta. Nyakamanya mende akali andake katapuli lao maseteno doko, baa nyakamanya kalai akali katapenge. ");
INSERT INTO enq2_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nyakamanya mende enomba nyoo katapuli lao maseteno doko, baa nyakamanya kendemane katapenge. ");
INSERT INTO enq2_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dopaka pyoo, Akalinya Ikiningi dokome baanya kalai pyekena lao naepea. Baame endakali dupanya kalai pyakamaiyoo, baa kumata dokome endakali longo sambao nyalanya epeana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dokaita Jeriko yakinatala peaminopa, endakali kambu andake mendeme baa watao peami. ");
INSERT INTO enq2_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dokopa akali lenge monda lapoma kaitini lemba dokonya peteambi. Jisasa ipao pelyamo leami doko akali dolapome sepala wii lao, “Kamongo, Dapita Ikiningi, embame nalimba kondo kaeyapoko!” leambi. ");
INSERT INTO enq2_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dopa leambinopa, endakali kambu dokome dolapo pii kaena lao pyalanya leami. Dopa leaminopapi, akali dolapome etete puu lao wii lao, “Kamongo, Dapita Ikiningi, embame nalimba kondo kaeyapoko!” leambi. ");
INSERT INTO enq2_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dopa leambinopa Jisasa katapala, akali dolapo epena latala lamaiyoo, “Nambame nyakambanya aipa pyakapili lao masilyambipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dokopa akali dolapome baa lamaiyoo, “Kamongo, nalimba lenge auu pyoo tambuli lao masilyambanona” leambi. ");
INSERT INTO enq2_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dopa leambinopa, Jisasame akali dolapo kondo kaeyapala, baanya kingimi dolaponya lengenya watandalu peteamopa, lapota auu pyoo lenge talu petala, baa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dokaita pao Jerusalema tengesa, Olipimanda dokonya taono Betepasa pyakalyetala, Jisasame disaipolo lapoma wambao pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Pena latala dolapo lamaiyoo, “Yuu yakane nyakambanya enombatena silyamo dokonya pupa. Pao pyakamalu pitambinopa, dongi matakai mende ŋaŋa-pipa anjetae katatamopa kanjambinona, nyakambame dolapo lapota tata lao minao ipupape. ");
INSERT INTO enq2_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Endakali mendeme nyakamba pii mende langia-kandeno dokopa, nyakambame lao pituu, ‘Kamongome kalai mende dongi dalapome pipenge jilyamona’ lapape. Dopa lalu pitambinopa, dongi dolapo minao ipupale lao baame kaeyalapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Pia dutupa pitaka pitana lao propeta mendeme lao pituu, “Saeyone wanenge dupa lamaiyoo, ‘Nyakamanya kiŋi doko dongi mendenya pituu, akali kenge nasingi mende joo nyakama kalyamino dokonya epelyamo. Baa dongi ŋaŋa mendenya pituu epelyamona kanjepa’ lao lamaiyepape” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dokopa disaipolo dolapo pupala Jisasame pina leamoli piambi. ");
INSERT INTO enq2_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dopa petala, akali dolapome dongi matakai doko ŋaŋa-pipa minao epeambi. Ipupala dolaponya yonge pee kisa pingi dolapo lyokanya dongi dolaponya maitanya setapeambinopa, Jisasa pyakalyetala petea. ");
INSERT INTO enq2_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pituu peamopa, endakali kambu andake dokome nyakamanya yonge pee kisa pingi dupa kaitini dokonya kuiyami. Yangi dupame ita wangya yakane dupa kepao nyepala kaitini dokonya kuiyamiaka. ");
INSERT INTO enq2_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dokopa endakali kambu dupa wambata maita pyata pyoo pao pituu, puu lao wii lao, “Dapita Ikiningi doko mambo pilyamano. Kamongonya kengenya epelyamo akali dake Goteme auu pisetae! Etete ketae kaiti-kisa katenge Gote doko mambo pilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisasa Jerusalema pyakameamopa, siti dokonya tange endakali dupa pitaka walu lao kyakapala lao pituu, “Akali dake apipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dopa leaminopa endakali kambu dupame lao pituu, “Akali dake baa Jisasa. Baa yuu Galali dokonya taono Nasarete tange propeta dokona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gotenya lotuu anda nee nyetae kamapu dokonya Jisasa pyakamatala, maketa setao kateamipi, sambao kateamipi, dupa pitaka watao pia. Dopa petala, muni aloo pingima dupanya tokopi, yaka maiyolee maketa setao petengema dupanya tokopi, dupa minatala kapilyia. ");
INSERT INTO enq2_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Dopa petala baame dokaita lamaiyoo, “ ‘Nambanya anda doko loma singi anda latamina’ lao pepa pyapae silyamo. Dopaka doko, nyakamame nambanya anda doko pake nenge dupanya yalo pingi panda jetelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisasa baa lotuu anda nee nyetae kamapu dokonya kateamopa, moko takyepaepi, lenge mondapi dupa epeami. Epeaminopa dokaitanya yaina dupa baame mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dopa piamopa, wane koo dupame lotuu anda nee nyetae kamapu dokonya katao puu lao wii lao, “Dapita Ikiningi doko mambo pilyamanona” leami. Dokopa pii leami dupa sepa, Jisasame kalai paka pipae pia dupa kandata petala, prisa mupapi, Mosesanya loo mana nyepaepi, dupa imbu kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Imbu kaeyapala dokaitame Jisasa lamaiyoo, “Wane koo dupame lelyamino dupa embame silyipi?” leami. Dopa leaminopa baame yanu pyao, “Nambame silyo. ‘Wane koopi, ŋaŋa andu nengepi, dupame kambumi emba mambo pyataminopa lao embame depa lanya seteena’ lao pepa pyapae singi doko nyakamame yuu mendaipi mende itaki napiamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dopa latala baame dokaita yakinatala, siti dokonya kamaka pyakalyetala, Betani pao palea. ");
INSERT INTO enq2_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yongama wamba, Jisasa Jerusalema pilyoo pituu, baa lopo kaeya. ");
INSERT INTO enq2_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dokopa piki ita mende kaitini lembasa kateamo kandatala, baa ita tenge dokonya pea. Pupala kandeamopa, ita doko dii nalyoo yoko iki pyoo katea. Dokopa baame piki ita doko lamaiyoo, “Tanga-tangapi embame dii mende dee namanditina” lea. Dopa lalu piamopa piki ita doko sapuiya. ");
INSERT INTO enq2_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sapuiyamo doko kandatala, disaipolo dupa walu leami. Walu latala lao pituu, “Piki ita dake aipa petala pupae lao sapuilyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame nyakama kiningi langilyo: Nyakama mona lapo palya naeyao Gote tungi pyatamino doko, nambame piki ita dake pilyoli pyoo nyakamame pitami. Nyakamame doko iki pyaa naeyatami. Nyakamame yuu manda dake lamaiyoo, ‘Emba sakatatala, solowatanya pyakala puu’ lataminopa, kiningi doko solowatanya pyakala pataka. ");
INSERT INTO enq2_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dopana, nyakamame Gote tungi pyatala, dopale mende dina lao loma setami dupa pitaka nyetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisasa lotuu anda nee nyetae kamapu dokonya pyakamatala, endakali dupa mana lamaiyoo katea. Dokopa prisa mupapi, Juumanya isingi akalipi, dupa ipupala baa tipa pyoo, “Embame kalai pilyino datupa, kyeto aipale mendeme pilyi? Kyeto doko apimi emba diape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame nyakama tipa mende pitoaka. Nyakamame yanu pyakatamino doko, nambame kalai datupa kyeto dopale mendeme pilyona lao nyakama langitoo: ");
INSERT INTO enq2_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Joneme kaimbu piamo doko, apimi pina leamopa pia? Kaiti-kisa katao Goteme pina leape, pande endakalimi pina leamipi?” lea. Dokopa dokaitame nyakama-lapo laloo pyoo, “ ‘Joneme kaimbu piamo doko, kaiti-kisa katao Goteme pina leana’ latamano doko, baame naima langyoo, ‘Aipuma nyakamame Jonenya pii doko kiningina lao masala naeyamipi?’ laapomo. ");
INSERT INTO enq2_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dopaka doko, endakali kambu pyao kalyamino dupa pitakame Jone baa propetana lao masingima dokonya, ‘Endakalimi pina leamina’ laanya naima paka pyumuna” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dopa latala dokaitame Jisasanya pii yanu pyakamaiyoo, “Naimame masala naelyamanona” leami. Dopa leaminopa Jisasame dokaita lamaiyoo, “Nambame kalai pilyo datupa kyeto dopale mendeme pilyona lao nyakama langya naeyatoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nyakamame aipa lao masilyami? Akali mendeme wane lapoma mandea. Takange dokome wane mupa doko lamaiyoo, ‘Indupa emba nambanya waene ee dokonya kalai pyaa puu’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dopa leamopa wane mupa dokome yanu pyao, ‘Namba napatoana’ lea. Dopa leamoaka doko, maitakao baa mona aloo petala pea. ");
INSERT INTO enq2_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dokopa takange doko wane kole doko katea dokonya pupala dopaka lamaiya. Dopa lamaiyamopa baame lao pituu, ‘Apane, namba patoana’ lea. Dopa leaka doko, baa angi napea. ");
INSERT INTO enq2_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Wane dolaponya andukumi takangenya masiali piape?” lea. Dokopa dokaitame baa lamaiyoo, “Wane mupa dokomena” leami. Dopa leaminopa Jisasame dokaita lamaiyoo, “Joneme mana tolatae dupa leamopa, nyakamame kiningina lao masala naeyami. Dopaka doko, takisa nyingipi, enda muni nyoo akali nyala paengepi, dupame Jonenya pii dupa kiningina lao masiaminopa, nyakamame kandeami. Dopaka doko nyakamame kandatala, nyakama mona aloo petala baanya pii dupa kiningina lao masala naeyami. Tenge dokonya, takisa nyingipi, enda muni nyoo akali nyala paengepi, dupa Gotenya kingdom dokonya wambao puminopa, nyakama napelyaminona lao nambame nyakama kiningi langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kongali pii mende apata lelyona salapape: Anda tange mendeme yuu mende kakopatala, waene ee pokea. Pokatala dii lyao waene ipange nyalanya dii dupa indyepenge yuli mende tombao wasia. Wasetala ee doko kandao isoo pitipenge anda ketae mende pia. Dopa petala baame waene dii mendatupa tange nyepengena lao, ee pokenge akali mendatupa lamaitala, ee doko isoo katekena lea. Dopa latala baa yuu londati mendenya pao katea. ");
INSERT INTO enq2_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Waene wambu pingi gii doko tengesa piamopa, baanya kalai akali mendapu ee isakamaingi dupa kateami dokonya pupala, waene dii baa nyepenge dupa lyao peekena lao nyala pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kalai akali dupa pateaminopa, ee isakamaingi dupame baanya kalai akali dupa minatala, mende pyao indyepa, mende pyao kumaseta, mende kaname pyapa piami. ");
INSERT INTO enq2_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dopa peteaminopa, ee tange dokome kalai akali longo mendapu apata pena leaka. Dokaita pateaminopa, ee isakamaingi dupame wamba peami dupa-kisa piamiliaka piami. ");
INSERT INTO enq2_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Maitakao baame lao pituu, ‘Nambanya ikiningi doko anda-anda semaiyaminona’ latala, baa pena lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pena lateamopa wane doko epeamo kandatala, ee isakamaingi dupame nyakama-lapo laloo pyoo, ‘Wane dakeme takangenya moeya dupa nyepengena, moeya dupa naima nyetamana, baa pyao kumasemana ipupa’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dopa latala, wane doko minatala waene ee dokonya kamalya pyale latala pyao kumasiami. ");
INSERT INTO enq2_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dopa piami dokonya, waene ee tange doko ipupala, ee isakamaingi dokaita aipa pitape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dopa leamopa dokaitame baa lamaiyoo, “Baame akali koo dokaita etete tanda maitala pyao kumaseta. Dopa petala, waene dii wambu pingi gii dokonya waene dii dupa lyao baa tange peakataminopa lao, waene ee doko akali waka mendapuame isoo katekena lao maitana” leami. ");
INSERT INTO enq2_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dopa leaminopa Jisasame dokaita lamaiyoo, “ ‘Anda pingi dupame anda pipenge kana mende koeyapae-lamo latala yakineami doko kana mupa jetelyamo. Kana mupa jetelyamo doko Kamongome pipya dokonya, naimame eteteaka auu kaeyao sanya kandelyamanona’ lao Gotenya pii pepa pyapae singi dupanya pyapae singi doko yuu mendaipi mende nyakamame itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nambame nyakama langilyo: Goteme baanya kingdom doko nyakamame isakala naeyalapale lao daa latala, kingdom dokonya dii mandena lao kalai pitami akali tata mendeme isoo katekena lao maita. ");
INSERT INTO enq2_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Endakali mende kana doko-kisa pyakatamo doko, kuli dupa lakao koeyata. Kana doko endakali mende-kisa ipao setamo doko, endakali doko indyoo koeyatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dokopa prisa mupapi, Parasipi dupame kongali pii dupa nyakama lao lalumuna lao sepala, ");
INSERT INTO enq2_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","baa anjemana lao kaitini kutiami. Kutiamiaka doko, endakali kambu dupame Jisasa baa propetana lao masiaminosa, paka kaeyapala kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Jisasame kongali pii mendapu deaka dokaita lamaiyoo, “Kingdom kaiti-kisa singi doko dapale: Kiŋi mendenya ikiningi doko enda kelyeamopa, takangeme nee andake mende yangakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yangatakamai kiŋi dokome endakali epena latae dupa baanya kalai akali dupame lanyala pena lea. Dopa lateamopa, dokaita pupala nee nala epena lao nee napenge latae dupa lamaiyaminopa, dokaita daa leami. ");
INSERT INTO enq2_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dopa leaminosa, baame kalai akali waka mendatupa pena latala lao pituu, ‘Endakali nee napenge latae dupa lamaiyoo, “Kao maipapi, kao andapaepi dupa pyapalamo. Dupa pitaka depa latae sepelyamona, nyakama nee nala ipupa” lapape’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dokopa kalai akali dupame dopa lamaiyamiaka doko, endakali nee napenge latae dupame pii nepatala, dokaitanya masiamili pyoo, mende baanya eenya pea, mende baanya bisinisa pyaa pea. ");
INSERT INTO enq2_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yangimi kalai akali dupa minatala, mana koo minao pyao kumasiami. ");
INSERT INTO enq2_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dopa piami doko kiŋi dokome sepala, baa imbu kaeya. Imbu kaeyapala baanya amii dupa pena leamopa, dupame baanya kalai akali pyao kumasiami endakali dupa pyao kumasetala, dupanya siti doko yangeami. ");
INSERT INTO enq2_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dokopa kiŋi dokome baanya kalai akali dupa lamaiyoo, ‘Nambanya nee andake doko depa latae sepelyamoaka doko, nee napenge latae endakali dupa kooma-lamo. ");
INSERT INTO enq2_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dopana, nyakama kaitini kembo dupanya pupala, endakali kandatami dupa pitaka nee andake dakenya nala epena lamaiyepape’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dopa lateamopa, kalai akali dokaita kaitini kembo dupanya pupala, endakali koopi, epepi kandeami dupa pitaka laminao ipao kambu piaminopa, nee andake napenge panda doko tumbia. ");
INSERT INTO enq2_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tumbao peteami dokonya kiŋi doko ipupala endakali dokaita kandeamopa, akali mende yonge pee enda kelyengesa pingi doko napyoo peteamo kandea. ");
INSERT INTO enq2_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kandatala kiŋi dokome baa lamaiyoo, ‘Kaimii, embanya yonge pee enda kelyengesa pingi doko napyene-lamo doko, emba aipa petala dakenya epepe?’ lea. Dopa leamopa akali dokome pii mende nalea. ");
INSERT INTO enq2_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dokopa kiŋi dokome baanya kalai akali dupa lamaiyoo, ‘Akali dakenya kingi mokopi dupa yaki petala, baa nyoo kamalya iminjetae dokonya pyale lapa. Panda dokonya endakali dupa ee lao, nenge giti-gato lao nao katatamina’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Salapape! Goteme endakali longo epena lengeaka doko, baame endakali kuki yapao nyingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dokopa Jisasame pii mende kopeta latamopa baa minamana latala, Parasi dupa pupala pii lao kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kambutala Parasi dupame nyakamanya disaipolo mendapupi, Erote tata mendapupi, dupa Jisasa katea dokonya pena leami. Akali dupa pupala baa lamaiyoo, “Mana Lenge, embame endakali mende mona setapala, mende maka kaeyala naenge. Endakali kenge singipi, nasingipi dupanya mendeme emba mende latamini-lao paka nakaeyao, kiningi pii doko lao, Gotenya mana dupa tolao mana lengena lao naimame masilyamano. ");
INSERT INTO enq2_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dopana, embame aipa lao masilyi? Sisa doko takisa maipengena lao loome latae singipi, nasingipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dopa leaminopa, Jisasame dokaitanya koo kalai pimana lao masiamino doko kandatala, baame lao pituu, “Nyakama mana tolatae miningi manemane pingima dupame aipuma namba makande pilyami? ");
INSERT INTO enq2_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisa maipenge muni konde mende nambame kandatoo panalapa” lea. Dokopa dokaitame muni konde mende nyoo ipateaminopa, ");
INSERT INTO enq2_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisasame dokaita lamaiyoo, “Muni konde dokonya apinya lenge-lyaapi, kengepi dupa kalyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dopa leamopa dokaitame baa lamaiyoo, “Sisanya kalyamona” leami. Dokopa baame dokaita lamaiyoo, “Sisanya dupa Sisa tange maiyakamaiyepape. Gotenya dupa Gote tange maiyakamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pii doko sepala, dokaita paka kaeyao walu latala, baa yakinatala peami. ");
INSERT INTO enq2_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Endakali kumapae dupa sakatala naeyatamina lengema, Sadyusi dupa gii dokopaka Jisasa katea dokonya ipupala baa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mana Lenge, Mosesame lao pituu, ‘Akali mendeme wane manja naeyao kumatamo doko, baanya kaiminingi dokome enda walyakae doko pisetala, kaiminingi dokonya lao wane manjakamaipengena’ lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dopana, kaiminingi kalange naima-pipa kateama. Kaiminingi mupa doko enda nyepala, wane manja naeyao baa kumia. Kumateamopa, kaiminingi lapo dokome enda walyakae doko pisetala, ");
INSERT INTO enq2_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","wane manja naeyaowaka baa kumia. Kaiminingi tepo dokome enda walyakae dokoaka pisetala, wane manja naeyaowaka baa kumia. Kaiminingi kalange dutupa pitakame enda walyakae dokoaka pisetala, wane manja naeyaowaka dutupa kumiami. ");
INSERT INTO enq2_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dutupa pitaka kumao ete dokonya, enda doko kumiaka. ");
INSERT INTO enq2_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kaiminingi kalange dutupa pitakame enda mendai dokoaka nyiamino dokonya, endakali kumapae dupa sakatatami gii dokopa enda doko apinya jetape?” lao tipa piami. ");
INSERT INTO enq2_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nyakamame Gotenya pii pepa pyapae singi doko masala naeyao, Gotenya kyeto doko masala naeyaowaka pingima dokonya, nyakamame kopeta lelyamino. ");
INSERT INTO enq2_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Endakali kumapae dupa sakatatami gii dokopa, akali dupa enda nyala naeyao, wanaku dupa akali nyala paa naeyao, Gotenya enjele kaiti-kisa katenge dupa katengemali pyoo katatami. ");
INSERT INTO enq2_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Endakali kumapae dupa sakatatami dokonya, Goteme nyakamanya pii lanya setekeamo dake itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Goteme lao pituu, ‘Abraamepi, Aisakepi, Jekopepi dutupanya Gote doko nambana’ lea. Gote baa kumapae dupanya Gote daa. Baa saka katenge dupanya Gotena” lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dopa leamopa, endakali kambu piami dupame Jisasanya mana leamo dupa sepala, walu lao paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisasame Sadyusi dupa pii nalena lao, etete auu pyoo yanu pyakamaiyamo sepala, Parasi dupa Jisasa katea dokonya ipao kambu piami. ");
INSERT INTO enq2_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Kambu piaminopa, looya mendeme Jisasa makande pyoo, “Mana Lenge, Mosesanya loo dupanya anduku etete andakepe?” lao tipa pia. ");
INSERT INTO enq2_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dokopa Jisasame baa lamaiyoo, “ ‘Embanya monapi, embanya imambupi, embanya masingipi, dutupa pitakame embanya Kamongo Gote doko auu kaeyape.’ ");
INSERT INTO enq2_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Loo doko etete andake-kisa mupa doko. ");
INSERT INTO enq2_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Loo lapo pyoo dake dopaleaka: ‘Emba tange auu kaengeli pyoo, embanya patali maki dupa auu kaeyape.’ ");
INSERT INTO enq2_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesanya loo dupapi, propeta dupame pepa piami dupapi, dupa pitaka loo lapoma dolaponya koko palelyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parasi dupa kambu pyatae kateaminopa Jisasame dokaita tipa pyoo, ");
INSERT INTO enq2_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nyakamame Kraisa doko apina lao masilyami? Baa apinya ikiningipi?” lea. Dopa leamopa dokaitame lao pituu, “Baa Dapitanya ikiningina” leami. ");
INSERT INTO enq2_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dopa leaminopa Jisasame dokaita lamaiyoo, “Spirita dokome masepae maiyamopa, Dapitame kaitini andukunya-kaita Kraisa doko Kamongona lea? ");
INSERT INTO enq2_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dapitame dapa lea: ‘Kamongome nambanya Kamongo doko lamaiyoo, “Emba nambanya kingi tolaetena piti. Dokonya pititinopa, nambame embanya yandapipi dupa embanya moko setenge toko jina latona” leana’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dapitame Kraisa doko Kamongona lea-lumu doko, kaitini andukunya-kaita Kraisa doko Dapitanya ikiningipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dopa lateamopa, endakali mendeme Jisasanya pii doko kapa pao yanu pyapenge nanjia. Gii dokonya pituu, endakali mendaipi mendeme baa pii mende dee tipa pyaanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisasame endakali kambu piamipi, baanya disaipolopi dupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mosesanya loo mana nyepaepi, Parasipi dupame Mosesanya panda nyoo mana lengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dopana, dupame wata-minalapape latami dupa pitaka nyakamame wata-minalapape. Dopaka doko, dupame mana lelyaminoli pyoo, nyakama tange wata-minala naengemana, dupanya mana minilyamino dupa nyakamame minala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kenda lekeleke tao sepenge dupa dupame yaki petala, endakali dupanya lataiyanya nyoo setakamaingima. Dopaka doko, nyakamanya kingi kondeme kukipi mende kenda dupa minao ema pimana lao masala naengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dokaitame kalai pilyami dupa pitaka endakali dupame kandamili lao masoo pingima. Dupame loma salanya pau andakele pyoo wasepae dupa pisoo paengema. Dokaitanya yonge pee kisa pingi dupanya punanya yati pipae londe pyoo anjinya pyandatae dupa pyoo paengemaka. ");
INSERT INTO enq2_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lotuu anda dupanya lotuu lelyamipi, nee andake nelyamipi, dupanya dokaita enomba nyoaka pitimu laka lao masingima. ");
INSERT INTO enq2_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Maketa dupanya endakali dupame dokaita mambo pyao kingi nyepa, ‘Mana Lenge’ lata pimi laka lao masingimaka. ");
INSERT INTO enq2_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Dopaka doko, Kraisa baa nyakamanya mana lenge mendai iki doko kalyamo. Nyakama dokonya kaiminingi kalyaminona, endakali dupame nyakama ‘Mana Lenge’ lena lao nakalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gote kaiti-kisa katenge doko iki nyakamanya Takangena, nyakamame isa yuu dakenya endakali mende ‘Takangena’ laa naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kraisa baa nyakamanya akali andake mendai iki doko kalyamona, endakali dupame nyakama ‘Akali Andake’ lena lao nakalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Endakali mende nyakamanya kalai akali katatamo doko, baa akali andake mende katatamosa pita. ");
INSERT INTO enq2_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Endakali mendeme baa tange kenge minalyetamo doko, Goteme baanya kenge doko minanata. Endakali mendeme baa tange kenge minanatamo doko, Goteme baanya kenge doko minalyeta. ");
INSERT INTO enq2_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Nyakamame enda walyakae dupa minakasetala, yuu andapi dupa nyingima. Endakali waka dupame nyakama epena lao masina latala, loma londe pyoo singima. Tenge dokonya, nyakama kenda etete andake nyetami. ");
INSERT INTO enq2_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Kingdom kaiti-kisa singi dokonya nyakama kolandala naengema dupame endakali mendapu kolandalanya pimi dupa kolandala naena lao kaita pai lelyamino. ");
INSERT INTO enq2_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Nyakamame endakali mende nyakamanya disaipolo nyemana lao kutao, solowata yangitena pata, yuu waka dupanya pata pingima. Kutao nyilyami endakali dokome nyakama ita minao, ele panda koo dokonya mana dupa minina lao mana lengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nyakama lenge monda dupame endakali waka kii miningima dupa koeyatami. Nyakamame dapa lengema: ‘Endakali mendeme baanya pii dupa kyeto tasalanya lotuu anda nee nyetae doko kenge latala, kiningi etete mende pitona latala napitamo doko yakaka. Dopaka doko, endakali mendeme baanya pii dupa kyeto tasalanya lotuu anda nee nyetae dokonya golome wasepae singi dupa kenge latala, kiningi etete mende pitona lata dokome kaeyala naeyao latali pipengena’ lengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nyakama kyakaenge lenge monda! Anduku etete andake? Golome wasepae dupape, pande golome wasepae dupa auu pisingi lotuu anda nee nyetae doko? ");
INSERT INTO enq2_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nyakamame dapa lengemaka: ‘Endakali mendeme baanya pii dupa kyeto tasalanya lotuu anda nee nyetae dokonya alta doko kenge latala, kiningi etete mende pitona latala napitamo doko yakaka. Dopaka doko, endakali mendeme baanya pii dupa kyeto tasalanya alta ketae dokonya opaa seta mende kenge latala, kiningi etete mende pitona lata dokome, kaeyala naeyao latali pipengena’ lengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nyakama kyakaenge lenge monda! Anduku etete andake? Opaa dupape, pande opaa dupa auu pisingi alta doko? ");
INSERT INTO enq2_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Endakali mendeme baanya pii dupa kyeto tasalanya alta doko kenge latala, kiningi etete mende pitona latamo doko, opaa alta ketae dokonya seta dupa apata lao lata. ");
INSERT INTO enq2_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Endakali mendeme baanya pii dupa kyeto tasalanya lotuu anda nee nyetae doko kenge latala, kiningi etete mende pitona lata dokome, lotuu anda nee nyetae dokonya katenge Gote doko apata lao lata. ");
INSERT INTO enq2_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Endakali mendeme baanya pii dupa kyeto tasalanya kaiti-kisa doko kenge latala, kiningi etete mende pitona lata dokome, Gote petenge toko dokopa, toko dokonya petenge Gote dokopa, dolapo apata lao lataka. ");
INSERT INTO enq2_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Nyakamame takaepi, mondaipi, itamaiyapi dupa malu akalita mokosoo setapala, dutupanya malu mendai Gote maingima. Dopa pingimaka doko, mana epeme endakali tolasingipi, kondo kaengepi, Gote tungi pingipi, loo andake dutupa nyakamame wata-minala naengema. Nyakamame loo dutupa wata-minao katao, loo waka dupa yakinala naeyapenge. ");
INSERT INTO enq2_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyakama lenge monda dupame endakali waka dupa kii miningima. Nyakamame kapo mendenya pongena mende koko silya doko nyoo nepatala, kamele mende nyoo nenge-kaita goe lengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Wakamanya oapi dupa tolao nyingi dokopa, mana koo miningi dokopa, dolapome nyakamanya mona andaka tumbatae kalyamopa, nyakamanya kapopi, pelesapi, ketaetena iki wasa pyatala, kokotena wasa napingima. ");
INSERT INTO enq2_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nyakama Parasi dupa lenge monda! Nyakamame wambao kapopi, pelesapi, dupa koko wasa pyapenge. Dopa pitaminopa, ketaetena wasa pyatae katata. ");
INSERT INTO enq2_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Endakali malunya ketae auu pilyamopa, malu koko endakali kuli akipi aiyame tumbatae katenge dopale nyakama kalyamino. ");
INSERT INTO enq2_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dopaleaka joo, nyakamanya yongeme mana tolatae minilyaminopa, endakali dupame nyakama tolataena lengema. Dopaka doko, nyakamanya mona andaka mana epe miningi manemane pingipi, loo yalengepi, dupa tumbatae kalyamo. ");
INSERT INTO enq2_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mosesanya loo mana nyepaepi, Parasipi, nyakama mana tolatae miningi manemane pingima dupa koeyatami. Propeta kumiami dupanya malunya nyakamame anda petakamai, endakali tolatae kumiami dupanya malu dupa yati pisingima. ");
INSERT INTO enq2_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dopa pyoo pituu nyakamame dapa lengema: ‘Naimanya yumbange kateami gii dokopa naima kateamali doko, yumbange dupame propeta dupa pyao kumasiaminopa, naimame yumbange dupa nisala naeyamalina’ lengema. ");
INSERT INTO enq2_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nyakamame dopa lelyamino dokome, nyakama propeta dupa pyao kumasiami akali dupanya mandipaena lao panelyamo. ");
INSERT INTO enq2_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dopana, nyakamanya yumbange dupame kalai piami doko nyakamame indupa pyoo etasalapape. ");
INSERT INTO enq2_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyakama koo kanopatonya mandipae! Goteme endakali dupa-kisa tenge setapala, ele panda koo dokonya watao pyandata doko nyakamame aipa petala wanditami? ");
INSERT INTO enq2_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nambame propetapi, masepae singi akalipi, mana nyepae akalipi dupa nyakamanya kainanya epena lato. Dopa latopa, yangi dupa nyakamame pyao kumasetami. Yangi dupa pyao poko itanya yukutami. Yangi dupa nyakamanya lotuu anda dupanya konjame pyatami. Yangi dupa nyakamame taono mendenya pituu, mendenya watao paeyao, tanda maiyoo koeyasetami. ");
INSERT INTO enq2_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nyakamame dopa pitami dokome, akali tolatae Abele pyao kumasiami gii dokonya pituu, lotuu anda nee nyetae dokopa, alta dokopa, dolaponya kainanya Berekaeya ikiningi Sakaraeya pyanya seteami gii dokonya tuu lao, akali tolatae pyao kumasiami dupa pitakanya taeyoko isa yuu dakenya kai lea dupa pitaka nyakama-kisa ipata. ");
INSERT INTO enq2_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dopana, nambame nyakama kiningi langilyo: Dokaitanya tenge dupa endakali indupa palelyamino dupa-kisa ipatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalema, Jerusalema! Embanya endakali dupame propeta dupa pyao kumasoo, epena latae endakali dupa kaname pyao kumasoaka katengema. Nambame embanya wane dupa nyoo kambu pyatala, yaka matakaiyame ŋaŋa dupa papa pundipundi yapu nengeli pitoo lao, paa longosa masiopa, dupame tanga leami. ");
INSERT INTO enq2_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Salapape! Nyakamanya anda doko kua kalyamo. ");
INSERT INTO enq2_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","‘Akali mende Kamongonya kengenya epelyamo doko Goteme auu pisetaena’ lao nyakamame latami gii dokopa, nyakamame namba kandatamina lao nambame nyakama langilyona” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisasa baa lotuu anda nee nyetae kamapu doko yakinatala peamopa, lotuu anda nee nyetae kamapu dokonya anda katenge dupa baame kandena lao baanya disaipolo dupame laitaka pyaanya epeami. ");
INSERT INTO enq2_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ipupala laitaka piaminopa Jisasame dokaita lamaiyoo, “Datupa pitaka kandelyamipi? Nambame nyakama kiningi langilyo: Datupa pitaka dopa petae katena lao kaeyala naenya kaluu nepataminopa, panda dakenya kana mendaipi mende namba-namba petae nakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisasa Olipimanda peteamopa, disaipolo dupa elyakalao ipupala baa lamaiyoo, “Embame lelyeno dutupa gii andukupa pita? Embame naima langi. Yuu etapenge gii dokopa, emba ipate gii dokopa, dolaponya kongali aipale mende pitape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Endakali mendeme nyakama minakasetana, kandao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aipumape, endakali longo mendapu nambanya kengenya ipupala lao pituu, ‘Namba Kraisa dokona’ lao endakali longo minakasetami. ");
INSERT INTO enq2_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dokopa yanda pilyamino lapaepi, yanda ingingi lapaepi, dupa sepala nyakama walu nalalapape. Dopale dupa pitaka ipupenge. Dopaka doko, yuu etapenge gii doko, dokopa ipa naeyata. ");
INSERT INTO enq2_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Akali tata mendeme akali tata mende yanda pimaita, kingdom mendeme kingdom mende yanda pimaita pitami. Yuu mendapuanya titiwali dupa minata, lopo andake dupa sepa, endakali longo-kisa yainame andinyeta pita. ");
INSERT INTO enq2_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dopa pita dupa pitaka, enda wane manjanya tee pyao maita pingi dopale. ");
INSERT INTO enq2_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Gii dokopa nyakama anjetala, tanda dyoo pyao kumasina lao maitami. Dopa pitaminopa, nyakamame nambanya kenge doko lao panelyamino latala, akali tata dupa pitakame nyakama imbu kaeyatami. ");
INSERT INTO enq2_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dokopa endakali longome namba tungi pingi doko yakinatala, nyakama-lapo imbu kaeyao pyaloo petala, yandapipi dupanya kinginya mende mai-mai pitami. ");
INSERT INTO enq2_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sambo propeta longo mendapu sakatatala, endakali longo kyakasetami. ");
INSERT INTO enq2_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Luiyao loo yalenge mana doko andatamopa, endakali longome endakali auu kaenge mana doko yakinatami. ");
INSERT INTO enq2_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dopa pitaminopapi, endakali mende kyeto joo katao, baa etata gii dokonya tuu latamo doko, baa pyoo nyeta. ");
INSERT INTO enq2_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kingdom kaiti-kisa singi dokonya lao wai pii epe doko yuu dupa pitakanya akali tata dupa pitaka lamaitataminopa, yuu etapenge gii doko ipatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Lotuu anda nee nyetae koeyasingi, myuku pipae mende ipatana lao propeta Danieleme lea doko, panda nee nyetae dokonya setamopa kandatami gii dokopa, endakali Judia katatami dupa yuu manda dupanya paka pupenge jeta.” (Pii dake itaki pyate dokome tenge doko kutao nyepe.) ");
INSERT INTO enq2_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“Gii dokopa endakali mende baanya anda ketae katata dokome, baanya oapi andakote seta dupa nyalanya isa pyakanala naeyapenge jeta. ");
INSERT INTO enq2_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Endakali mende eenya katata dokome, baanya yonge pee dupa nyalanya pilyala naeyapenge jetaka. ");
INSERT INTO enq2_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Enda wane tongotapi, enda wane andu nengepi, dupa gii dokopa etete kondo pita. ");
INSERT INTO enq2_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Poo lao aiyuu epenge gii mendenyapi, Sambata gii mendenyapi, paka napataminopana nyakama loma soo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kenda wamba epea dupa pitaka ita minao, gii dokopa kenda eteteaka andake mende ipata. Yuupa kaitipa dolapo tee pia dokonya pituu, indupa tuu lao, kenda etete andake dopale mende naepea. Tanga-tangapi kenda etete andake dopale mende naipataka. ");
INSERT INTO enq2_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yuu gii dutupa muu pisala naeyatamo doko, endakali mendaipi mende pyoo nyepae nakatata. Dopaka doko, endakali yapao nyepae dupa masetala, yuu gii dutupa muu piseta. ");
INSERT INTO enq2_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Gii dokopa Kraisa manemane pingimapi, sambo propetapi dupa ipupala, Gotenya yapao nyepae endakali dupa apata kyakasetamano nakandenya latala, mirakolo andakepi, kalai paka pipaepi, dupa pitami. Dopana, endakali mendeme nyakama langyoo, ‘Kraisa doko asa kalyamo kanjepa, amasa kalyamo kanjepa’ lea-kandeno doko, kiningi lelyamona lao masala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tanga pita dupa nambame nyakama wambao langilyona salapape. ");
INSERT INTO enq2_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","Yuu-wapaka pilyamopa, tii pipae doko niki pyakaengesa pituu, niki pambengesa tuu lenge dopaka pyoo, Akalinya Ikiningi doko ipata. Dopana, endakali mendeme nyakama langyoo, ‘Kraisa doko endakali napalenge yuu dokonya kalyamona, kanja pupa’ lea-kandeno doko, kanja napupape. Endakali mendeme nyakama langyoo, ‘Kraisa doko anda dakenya andakote pilyamona’ lea-kandeno doko, kiningi lelyamona lao masala naeyalapapeaka. ");
INSERT INTO enq2_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dopale mende kumapae silya dokonya yaka lakepame dupa kambu pingimana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisasame lao pituu, “Yuu gii dutupanya kenda andake dutupa ipao etalu pitamopa, niki doko iminjoo, kana doko tii napyoo, kaitinya bui dupa kondao isa ipao, kaitinya kyeto singi dupa ema-ema pyoaka pita. ");
INSERT INTO enq2_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dokopa Akalinya Ikiningi doko ipanya kongali mende kaitinya pitamopa, yuunya akali tata dupa pitakame kandatala, yako lao ee latami. Dokopa Akalinya Ikiningi doko baanya kyetopi, tii pipae andakepi dupanya pituu, kaitinya kopa-kisa ipatamopa kandatami. ");
INSERT INTO enq2_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dokopa trampeta mende puu lao pyatamopa, poo kitomende dutupapi, kaiti lembapi, dupanya baanya enjele dupa pupala, baanya endakali yapao nyepae dupa nyoo kambu pyekena latana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nyakamame piki ita dupanya mana dake nyalapape: Piki ita dupanya mange popo pilya dupa kandatala, paina pyaanya tengesa pilyamona lao nyakamame masingima. ");
INSERT INTO enq2_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dopana, lelyo dutupa pitaka pitamopa nyakamame kandatala, Akalinya Ikiningi doko lome kambunya ipao tengesa katapelyamona lao masalapape. ");
INSERT INTO enq2_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nambame nyakama kiningi langilyo: Endakali indupa palelyamino dupa kumao etala naeyataminopa, lelyo dutupa pitaka pita. ");
INSERT INTO enq2_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yuupa kaitipa dolapo alu pita. Dopaka doko, nambanya pii dupa alu napitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Dutupa pipenge yuu giipa, awapa dolapo endakali mendeme masala naenge. Enjele kaiti-kisa katengema dupame apata masala naengemaka. Nambanya Takange dokome iki masingi. ");
INSERT INTO enq2_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Akalinya Ikiningi doko ipanya pita gii dokopa, Noa katea gii dokopa pialiaka pita. ");
INSERT INTO enq2_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Endaki andake dokome pyala naeyamopa, endakali dupa nee endakipi nao, akali dupame enda nyoo, wanaku dupa akali nyala pao pyoo kateami. Dopa pyoo kateaminopa, Noa sipi andaka kolandea gii doko epea. ");
INSERT INTO enq2_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dupame aipa pitape lao masala naeyao kateaminopa, endaki andake doko ipupala, dokaita pitaka pyao soo pea. Dopa piana, endakali dupa dopaka pyoo katataminopa, Akalinya Ikiningi doko ipata. ");
INSERT INTO enq2_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ipatamo gii dokopa, akali lapoma eenya katatambinopa, dolaponya mende nyepala, mende doko katena kaeyata. ");
INSERT INTO enq2_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Enda lapomame palao wasalanya wita dii takyoo indyoo pititambinopa, dolaponya mende nyepala, mende doko petena kaeyata. ");
INSERT INTO enq2_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dopa pitana, nyakamanya Kamongo doko gii andukupa ipatape lao nyakamame masala naelyaminona, kandao isoo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dake masalapape: Anda tange mendeme pake nenge mende gii dokopa ipapomo lao masiali doko, baanya anda doko kandao isetala, kaluina lao kaeyala naeyali. ");
INSERT INTO enq2_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dopana, nyakama ambe katatami gii mendepa Akalinya Ikiningi doko ipatana, nyakama apata depa latae kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Akali andake mendeme kalai akali dupa akali mendeme isina latamopa, dokaita isoo katao, nee napenge gii dokonya nee mokosoo maiyoo katapenge kalai akali masepae epe palenge, pii sakamaingi doko baa api? ");
INSERT INTO enq2_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Baanya akali andake doko ipupala, kalai akali dokome dopa pyoo katata kandatala, baa auu piseta. ");
INSERT INTO enq2_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nambame nyakama kiningi langilyo: Akali andake dokome baanya oapi dupa pitaka kalai akali dokomeaka isakao katena lata. ");
INSERT INTO enq2_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dopaka doko, kalai akali dokome masepae koo nyepala, baanya moname masoo pituu, ‘Nambanya akali andake doko tanga-waka ipatana’ lao masetala, ");
INSERT INTO enq2_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tee pyao baanya kalai akali yango dupa pyapapu, bia nao kyakao paengema dupa-pipa neepi, biapi dupa nao katatamo doko, ");
INSERT INTO enq2_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kalai akali dokonya akali andake doko naipapomo lao masetala, ambe katata gii mendepa ipata. ");
INSERT INTO enq2_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ipupala akali andake dokome kalai akali koo doko kepapala, mana tolatae miningi manemane pingima dupa katatami panda dokonya katena lata. Panda dokonya endakali dupa ee lao, nenge giti-gato lao nao katatamina” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisasame lao pituu, “Kingdom kaiti-kisa singi doko dapale: Gii mendepa akali mendeme baanya enda watapae pyala ipatoo lateamopa, wanaku mapukae akalita mendatupame nyakamanya lama dupa minao baa kandanyemana latala peami. ");
INSERT INTO enq2_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wanaku mapukae dutupanya yungi masepae epe palenge. Yungi dutupa masepae epe napalenge. ");
INSERT INTO enq2_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wanaku masepae epe napalenge dutupame nyakamanya lama dupa minao pao pituu, wele wakao mendatupa kamuu namandeami. ");
INSERT INTO enq2_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wanaku masepae epe palenge dutupame nyakamanya lama dupa minao pao pituu, wele wakao mendatupa kamuu mandyoo peami. ");
INSERT INTO enq2_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Akali enda kelyea doko yapa naepeamosa, wanaku mapukae dutupa lemonguti latala luu paleami. ");
INSERT INTO enq2_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Palipiaminopa, kuka andatombe dokonya wii mende lea dokome lao pituu, ‘Akali enda kelyalamo doko ae epelyamona, nyakama kandanyalapale ipupa’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dopa leamopa, wanaku mapukae dutupa pitaka sakatatala, nyakamanya lama dupa depa leami. ");
INSERT INTO enq2_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dokopa wanaku masepae epe napalenge dutupame wanaku masepae epe palenge dutupa lamaiyoo, ‘Naimanya lama datupa konjalanya pilyamona, nyakamanya wele dupanya mendatupa naima dyepa’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dopa leaminopa, wanaku masepae epe palenge dutupame pii yanu pyakamaiyoo, ‘Wele datupame naimapi, nyakamapi pitaka kapa napapome-lamona, wele salimi lengema dupa-kisa nyakama waka sambala pupa’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dokopa wanaku dutupa wele sambala pateaminopa, akali enda kelyea doko epea. Epeamopa wanaku depa latae peteami dutupa baa-pipa enda watapae dokonya nee nalanya andakote kolandeami. Kolandateaminopa kaitini doko pai leami. ");
INSERT INTO enq2_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maitakao wanaku mapukae yangi dutupa ipupala lao pituu, ‘Kamongo, Kamongo, naimanya kaitini lumbakapoko’ leami. ");
INSERT INTO enq2_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dokopa baame yanu pyao, ‘Nambame nyakama kiningi langilyo: Nambame nyakama nakandengena’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dopana, Akalinya Ikiningi doko gii andukupa ipatape lao nyakamame masala naelyaminona, nyakama kandao isoo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Akalinya Ikiningi ipupenge doko, akali mende baa yuu londati mendakaita patoo latala, baanya kalai akali dupa wii lao nyepala, baanya oapi dupa pitaka kandao isoo katekena leamo dopale. ");
INSERT INTO enq2_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Baanya kalai akali dupame mana kandengemali pyoo kalai pyaamino lao akali dokome masetala, muni mendatupa mokosoo maiya. Mende silipa muni yungi maiya. Mende silipa muni lapoma maiya. Mende silipa muni mendai maiya. Maiyu petala baa paanya masia dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pateamopa silipa muni yungi nyia akali dokome pupala, muni dutupame minao kalai petala, silipa muni yungi konda pyoo nyia. ");
INSERT INTO enq2_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dopaka pyoo, silipa muni lapoma nyia akali dokome silipa muni lapoma konda pyoo nyiaka. ");
INSERT INTO enq2_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dopaka doko, silipa muni mendai nyia akali doko pupala, baanya akali andake dokonya muni doko yuu koko yuli pia. ");
INSERT INTO enq2_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yuu gii longo pateamopa, kalai akali dutupanya akali andake doko pilyetala, muni maiya dutupame aipa pyekeamipi lao kanjanya epea. ");
INSERT INTO enq2_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ipateamopa silipa muni yungi nyia akali dokome yungi konda pyoo minao ipupala lao pituu, ‘Akali Andake, embame namba silipa muni yungi diino dokonya, nambame yungi konda pyoo nyekeona kanda’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dopa leamopa, baanya akali andake dokome baa lamaiyoo, ‘Emba kalai akali epe dokome, nambame leoli pyoo yaka pyekee-lamo! Muni kuki dio dutupa leoli pyoo, embame auu pyoo isii-lamo dokonya, nambame emba longo isoo kata latoana, embapa nambapa mona setao katambana ipu’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dokopa silipa muni lapoma nyia akali doko apata ipupala lao pituu, ‘Akali Andake, embame namba silipa muni lapoma diino dokonya, nambame lapoma konda pyoo nyekeona kanda’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dopa leamopa, baanya akali andake dokome baa lamaiyoo, ‘Emba kalai akali epe dokome, nambame leoli pyoo yaka pyekee-lamo! Muni kuki dio dolapo leoli pyoo, embame auu pyoo isii-lamo dokonya, nambame emba longo isoo kata latoana, embapa nambapa mona setao katambana ipu’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Dokopa silipa muni mendai nyia akali doko apata ipupala lao pituu, ‘Akali Andake, emba akali tomba nelyenopa nambame kandenge. Embame wakamanya ee waingi pokatae dupanya nee yukuu mandenge. Wakamanya ee wai lyandatae dupanya dii lyao mandengeaka. ");
INSERT INTO enq2_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dopa pingi dokonya namba paka kaeyapala, embanya silipa muni doko nambame yuu koko yuli piona, muni doko dakena kanda’ lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dopa leamopa akali andake dokome baanya pii yanu pyakamaiyoo, ‘Emba kalai akali koo, maka-maka kaeyapae-lamo. Nambame wakamanya ee waingi pokatae dupanya nee yukuu mandyoo, wakamanya ee wai lyandatae dupanya dii lyao mandengeaka-lumu doko, ");
INSERT INTO enq2_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","wakao mendatupa apata nyema ipatenopa lao, nambanya muni doko beŋenya setakateno! ");
INSERT INTO enq2_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Silipa muni mendai baa-kisa silyamo doko nyepala, silipa muni akalita setelyamo akali doko maiyepa. ");
INSERT INTO enq2_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aipumape, longo lao singi endakali doko baa konda pyoo maita. Maitamopa baa-kisa longoaka seta. Dopaka doko, nasingi endakali doko-kisa kuki seta dutupa baa-kisa nasina lao tange nyokonyeta. ");
INSERT INTO enq2_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dopana, nyakamame kalai akali koo-lamo dake kamalya iminjetae dokonya soo pyale lapa. Panda dokonya endakali dupa ee lao, nenge giti-gato lao nao katatamina’ ” lea. ");
INSERT INTO enq2_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tanga Akalinya Ikiningi doko baanya tii pipae dokonya pituu, enjele Gotenya latae dupa pitaka-pipa ipata. Ipupala baanya kiŋi toko tii pipae dokonya pitita. ");
INSERT INTO enq2_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dokopa akali tata dupa pitaka baanya enombanya kambu pyatami. Dopa petataminopa, sipisipi setao katenge mendeme sipisipipi, memepi yapao wakale katasingili pyoo, baame endakali dupa yapao wakale kataseta. ");
INSERT INTO enq2_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dopa pyoo pituu, baame sipisipi dupa baanya kingi tolaetena katena lata. Meme dupa baanya kingi koeyatena katena lata. ");
INSERT INTO enq2_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dokopa kingi tolaetena katatami dokaita kiŋi dokome lamaiyoo, ‘Nambanya Takange dokome nyakama auu pisetae. Baanya kingdom doko nyakama ditona latala, yuupa kaitipa dolapo tee pia dokopa depa laanya setekea doko nyakama etete nyalapale ipupa. ");
INSERT INTO enq2_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aipumape, namba lopo kaeyopa, nyakamame namba nee diami. Endaki nanu kaeyopa, nyakamame namba endaki kamuu diami. Opone epeopa, nyakamame namba nyoo setao paleami. ");
INSERT INTO enq2_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yonge pee napyoo kateopa, nyakamame namba yonge pee diami. Yaina siopa, nyakamame namba kanja epeami. Anjetae paleopa, nyakamame namba kanja epeamina’ lata. ");
INSERT INTO enq2_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dopa latamopa, endakali tolatae dupame yanu pyao, ‘Kamongo, emba andukupa lopo kaeyenopa, naimame kandatala nee diama? Andukupa endaki nanu kaeyenopa, naimame emba endaki kamuu diama? ");
INSERT INTO enq2_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Andukupa opone epeenopa, naimame kandatala emba nyoo setao paleama? Andukupa yonge pee napyoo kateenopa, naimame emba yonge pee diama? ");
INSERT INTO enq2_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Andukupa yaina siinopapi, anjetae paleenopapi, naimame emba kanja epeamape?’ latami. ");
INSERT INTO enq2_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dopa lataminopa kiŋi dokome dokaitanya pii yanu pyakamaiyoo, ‘Nambame nyakama kiningi langilyo: Nambanya kaiminingi datupanya kenge nasingi mende nyakamame nisiamino dokome, namba nisiaminosaka piana’ lata. ");
INSERT INTO enq2_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Dopa latala baame kingi koeyatena katatami dokaita lamaiyoo, ‘Nyakama watao pyatae dupa namba yakinatala, Satanepi, baanya enjelepi dupanya itate tao kalyu katenge depa laanya setakamaiya dokonya pupa. ");
INSERT INTO enq2_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aipumape, namba lopo kaeyopa, nyakamame namba nee nandiami. Endaki nanu kaeyopa, nyakamame namba endaki kamuu nandiami. ");
INSERT INTO enq2_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Opone epeopa, nyakamame namba nyoo setao napaleami. Yonge pee napyoo kateopa, nyakamame namba yonge pee nandiami. Yaina siopapi, anjetae paleopapi, nyakamame namba kanja naepeamina’ lata. ");
INSERT INTO enq2_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dopa latamopa dokaitame yanu pyao, ‘Kamongo, andukupa emba lopo kaeyenopapi, endaki nanu kaeyenopapi, opone epeenopapi, yonge pee napyoo kateenopapi, yaina siinopapi, anjetae paleenopapi, naimame kandatala nisala naeyamape?’ latami. ");
INSERT INTO enq2_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dopa lataminopa kiŋi dokome dokaitanya pii yanu pyakamaiyoo, ‘Nambame nyakama kiningi langilyo: Nyakamame endakali datupanya kenge nasingi mende nisala naeyamino dokome, namba nisala naeyaminosaka piana’ lata. ");
INSERT INTO enq2_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Endakali kingi koeyatena katatami dokaita tanda nenge panda dokonya etao patami. Dopaka doko, endakali tolatae dupa lete etete katenge panda dokonya etao patamina” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisasame pii dupa pitaka lamaiyoo etapala, baanya disaipolo dupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Pasopa gii doko ipanya yuu gii lapoma silyamo doko nyakamame masilyamino. Gii dokopa Akalinya Ikiningi doko poko itanya pyao yukuina lao amii dupanya kinginya maitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Prisa mupapi, Mosesanya loo mana nyepaepi, Juumanya isingi akalipi, dupa prisa mupa Kaeyapasa lenge dokonya anda kamapu dokonya kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kambuu pituu, dokaitame Jisasa aipa petala waa katao anjoo nyepala pyao kumasemape lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kutapala lao pituu, “Endakali dupame pundu yaka lasetamina, nee andake napenge gii dokonya dopa napimanana” leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Yuu Betani dokonya akali kopetali Saimone lenge dokonya andaka Jisasa baa nee nao petea. Peteamopa enda mendeme penge mendenya wele tunduma pipaeme tumbatae, muni andake pupenge mende minao epea. Ipupala Jisasanya aiyombanya wele doko kai lakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Kai lakamaiyamo kandatala, Jisasanya disaipolo dupame imbu kaeyapala lao pituu, “Wele dake salimi lao muni andake nyepala, endakali daa jepae dupa maimualina, aipuma enda dakeme wele dake pyoo nepelyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dopa leamino doko kandatala Jisasame dokaita lamaiyoo, “Enda dakeme namba-kisa kalai epe mende pilyamona, aipuma nyakamame baanya mona kenda pisakamailyami? ");
INSERT INTO enq2_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Endakali daa jepae dupa koteaka lao nyakama-pipa katatami. Dopaka doko, namba nyakama-pipa gii longo mende kalya naeyalamano. ");
INSERT INTO enq2_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Enda dakeme wele tunduma pipae kai lakalamo dokome, nambanya yonge doko malu pipenge dokonya depa lasoo pyakalamo. ");
INSERT INTO enq2_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nambame nyakama kiningi langilyo: Wai pii epe dake lao panatami yuu dupa pitakanya, enda dakeme pyomo doko apata lamaitaminopa, endakali dupame baa masetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dokopa 12 disaipolo dutupanya mende, Judasa Iskariota lenge doko, baa prisa mupa dupa kateami dokonya pupala ");
INSERT INTO enq2_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","lao pituu, “Nambame Jisasa nyakamanya kinginya ditoo, nyakamame namba aki mende ditamipi?” lea. Dopa leamopa dokaitame baa silipa muni 30 maiyami. ");
INSERT INTO enq2_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gii dokonya pituu, Jisasa dokaitanya kinginya maiyanya Judasame kaitini kutao katea. ");
INSERT INTO enq2_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Breta Yisa Pyandala Naeyao Yangapae Nengema, yuu gii tee pyao dokonya, disaipolo dupa Jisasa katea dokonya ipupala baa lamaiyoo, “Pasopa nee doko emba natale, naimame anja depa lakamili lao masilyipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dopa leaminopa baame lao pituu, “Siti dokonya akali mende kalyamona, dokonya nyakama pupape. Pupala akali doko lamaiyoo, ‘Mana Lenge dokome baanya gii doko tengesa petelyamona, Pasopa nee doko baanya disaipolo dupa-pipa embanya andaka namana lelyamona’ lao lamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dokopa Jisasame leali petala, disaipolo dupame Pasopa nee doko depa leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yuu kuiyala peamopa, Jisasa baa 12 disaipolo dutupa-pipa nee nao peteami. ");
INSERT INTO enq2_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nee nao pituu baame dokaita lamaiyoo, “Nambame nyakama kiningi langilyo: Nyakamanya mendeme namba yandapipi dupanya kinginya maiyapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dopa leamopa, dokaita mona etete kenda kaeyapala baa tee pyao lamaiyoo, “Kamongo, embame lelyeno doko namba lao lelyepe?” laa-laa peami. ");
INSERT INTO enq2_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dopa leaminopa Jisasame yanu pyao, “Nee disanya kingimi poeyanyoo nao apata pilyamano dakenya mendeme namba yandapipi dupanya kinginya maiyapomo. ");
INSERT INTO enq2_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Akalinya Ikiningi doko kumala pupengena lao pepa pyapae singi dokonya, dopaka pyaapomo. Dopaka doko, Akalinya Ikiningi doko yandapipi dupanya kinginya maiyapomo akali doko baa koeyalapomo! Akali doko endangimi namandeali doko yaka jialina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dopa leamopa, yandapipi dupanya kinginya Jisasa maiya akali Judasa dokome baanya pii yanu pyakamaiyoo, “Mana Lenge, embame lelyeno doko namba lao lelyepe?” lea. Dopa leamopa Jisasame baa lamaiyoo, “Embame latelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dokaita nee nao pituu, Jisasame breta mende nyepala, Gote yaka pilyino latala konjia. Konjepala disaipolo dupa maiyoo pituu, “Dake nambanya yonge dokona, nyoo nalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Dopa latala baame kapo waene peteta mende nyepala, Gote yaka pilyino latala, dokaita maiyoo pituu, “Dake nambanya taeyoko doko. Taeyoko kai lelyo dakeme endakali longonya koo dupa kunao nepao, pii enenge mende lao yaki pinya setelyona, nyakama pitakame nyoo nalapa. ");
INSERT INTO enq2_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nambame nyakama langilyo: Namba dee waene nala naeyaowaka katao, nambanya Takangenya kingdom dokonya waene enenge doko nyakama-pipa natamana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dopa lateamopa, dokaitame wee mende latala kamaka pyakalyiami. Pyakalyetala dokaita Olipimanda peami. ");
INSERT INTO enq2_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dokopa Jisasame dokaita lamaiyoo, “Dapa lao pepa pyapae silyamo: ‘Nambame sipisipi setao katenge doko pyatopa, sipisipi dupa saa latamina’ lapae silyamo. Dopa lapae silyamo dokonya, indupa kuka gii dakepa, namba-kisa kenda ipapomo doko kandatala, nyakama pitaka isa pyakalamino. ");
INSERT INTO enq2_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dopaka doko, Goteme namba sakataseta. Dopa petatamopa, nyakama Galali paa naeyataminopa, namba wambao patona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dokopa Pitame Jisasa lamaiyoo, “Emba-kisa pita dupa kandatala yangi dupa pitaka isa pyakataminopa, tanga-tangapi namba isa pyakala naeyatona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dopa leamopa Jisasame baa lamaiyoo, “Nambame emba kiningi langilyo: Indupa kuka gii dakepa, yaka pauli pii ene laanya pitamopa, paa tepomasa embame namba nakandengena laapenona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dopa leamopa Pitame baa lamaiyoo, “Emba kumate dokonya namba apata kumapenge jetamopapi, nambame emba nakandengena laa naeyalapona” lea. Dokopa disaipolo dupa pitakame dopaka leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dopa lateaminopa, Jisasa baanya disaipolo dupa-pipa yuu Gesemani lenge dokonya peami. Pupala baame dupa lamaiyoo, “Namba omosale loma sala pelyona, nyakama asa pilyepa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dokopa Jisasame Pitapi, Sebedi ikiningi dolapopi, dutupa laminao pupala, baa tee pyao mona kenda kaeyapala masepae longo nyia. ");
INSERT INTO enq2_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dopa petala Jisasame dutupa lamaiyoo, “Nambanya mona doko etete kenda pipya dokome namba kumapenge julumuna, nyakama namba-pipa asa kandao isoo katamana kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dopa latala baa kuki umbisale pao, yuunya tombauli sepala loma soo pituu, “Apane, kapo kenda paleta mende nalapo dake embame nyoo nepakapenge jia-kandeno doko, nyoo nepakape. Dopaka doko, nambame masilyo dokonya-kaita napipi. Embame masilyino dokonya-kaita pipi” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dopa lao loma sepala epeamopa, disaipolo dutupa luu paliu siamino kandatala, baame Pita lamaiyoo, “Nyakamame awa mendai dokonya namba-pipa kapa pao kandao isoo nakatalamipi? ");
INSERT INTO enq2_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nyakamanya moname pyoani kaeyamupa, yongeme papa tambuilyamona, makande pipae dupanya nyakama isa pyakala naeyamana lao loma soo kandao isoo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dopa latala Jisasa paa lapo pyoo loma sala pea. Loma soo pituu, “Apane, kapo kenda paleta dake nambame kaeyala naeyao napenge-tamo doko, embame masilyino dokonya-kaita pina kaeyape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Loma sepala ipao kandeamopa, disaipolo dutupa lemonguti kaeyapala dee luu paliu siami. ");
INSERT INTO enq2_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Paliu sina latala, baa paa tepo pyoo loma sala pea. Pupala wamba loma sia dutupaka sia. ");
INSERT INTO enq2_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Loma sepala, baanya disaipolo dupa kateami dokonya ipupala dokaita lamaiyoo, “Nyakama koto nyoo luaka paliu silyamipi? Salapape! Gii doko ipatelyamo. Akalinya Ikiningi doko koo pingi endakali dupanya kinginya maiyapomona, naima mona sakatalapa. Namba yandapipi dupanya kinginya maiyapomo akali doko ipatelyamona kanjepa” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisasame dopa lao kateamopa, baanya 12 disaipolo dutupanya mende, Judasa lenge doko epea. Endakali kambu andake mende konjuwapi, kolyepepi dupa minao baa-pipa epeami. Dupa prisa mupapi, Juumanya isingi akalipi, dupame epena leaminosa epeami. ");
INSERT INTO enq2_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yandapipi dupanya kinginya Jisasa maiya akali dokome kongali mende pyaapona lao endakali baa-pipa epeami dupa lamaiyoo, “Nambame akali mende nunu pyaapo doko baana, nyakamame baa minalapape” lao wamba baame dokaita lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jisasa katea dokonya Judasa tolao pupala lao pituu, “Mana Lenge, kuakama!” lea. Dopa latala baa nunu pia. ");
INSERT INTO enq2_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dopa piamopa Jisasame baa lamaiyoo, “Kaimii, embame aipa pitoo latala epelyepe?” lea. Dokopa endakali kambu doko Jisasa katea dokonya ipupala, baa minatala anjiami. ");
INSERT INTO enq2_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anjiaminopa Jisasa-pipa kateami dupanya mendeme baanya konjuwa doko kolanyetala, prisa mupa dokonya kalai akali dokonya kale doko lyanya nepea. ");
INSERT INTO enq2_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dopa piamopa Jisasame baa lamaiyoo, “Embanya konjuwa doko palenge andanda dokonya mandi. Konjuwa miningi dupa konjuwameaka kumatami. ");
INSERT INTO enq2_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Indupa nambanya Takangeme namba nisina lao kyeto joo tee lalu pipupa, baame enjele 72 tausene ita minao etete longo epena lapyalina lao masala naelyepe? ");
INSERT INTO enq2_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Namba nisina lapuli doko, namba-kisa pipenge dupa dopa pipengena lao Gotenya pii pepa pyapae singi doko aipa petala angi jipyalipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Awa mendai dokonyaka Jisasame endakali kambu dupa lamaiyoo, “Pake nenge mende anjala epele lao nyakamame konjuwapi, kolyepepi dupa minao namba anjala epelyamipi? Nambame koteaka lao lotuu anda nee nyetae kamapu dokonya mana langyoo nyakama-pipa peteo dokopa, nyakamame namba anjala naeyami. ");
INSERT INTO enq2_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dopaka doko, propeta dupame pii pepa piami dupa angi jina lao datupa pitaka pilyamona” lea. Dokopa disaipolo dupa pitakame baa yakinatala paka peami. ");
INSERT INTO enq2_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dokopa Jisasa anjiami dupame baa laminao, prisa mupa Kaeyapasa katea dokonya peami. Panda dokonya Mosesanya loo mana nyepaepi, Juumanya isingi akalipi, dupa kambu pyao kateami. ");
INSERT INTO enq2_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dokopa Pita baa kuki londatili joo Jisasa watao pea. Pupala prisa mupa dokonya anda kamapu dokonya pyakamatala, piami dupa aipa pyoo, pyoo etasilyamipi lao kandatoo latala, yanda singi dupa-pipa petea. ");
INSERT INTO enq2_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Prisa mupapi, Juumanya isingi akalipi, kanjole kambuingi andake dokonya katenge dupa pitakapi, dupame Jisasa pyao kumasemana latala, akali mendapuame sambo-kisa setao Jisasa kotimi lena latala kutiami. ");
INSERT INTO enq2_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kutao nyiamiaka doko, dokaitame tenge angi mende kandao nanyiami. Akali longo mendapu ipupala, baa sambo-kisa setao kotimi leamiaka doko, baa-kisa tenge angi mende kandao nanyiami. ");
INSERT INTO enq2_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Etao dokonya akali lapoma ipupala lao pituu, “Akali dakeme, ‘Gotenya lotuu anda nee nyetae doko lakyepala, yuu gii tepomanya kapa pao waka mende pitona’ leana” lao, baa sambo-kisa setao kotimi leambi. ");
INSERT INTO enq2_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dokopa prisa mupa doko toeya katapala Jisasa lamaiyoo, “Pii lelyambino dupa yanu pyala naelyepe? Emba-kisa tenge setao pii lelyambino dupa sepala, embame aipa lao masilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dopa leamopa Jisasame pii mende nalea. Dokopa prisa mupa dokome baa lamaiyoo, “Gote kataowaka katenge dokome emba kandao kalyamona, embame pii tolao kiningi doko naima langi: Emba Gote Ikiningi Kraisa dokope?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dopa leamopa Jisasame baa lamaiyoo, “Embame latelyeno. Nambame nyakama dapa langilyo: Akalinya Ikiningi doko, Gote etete kyeto dokonya kingi tolaetena pituu, kaitinya kopa-kisa ipatamopa nyakamame kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dopa leamopa, prisa mupa dokome baanya yonge pee dupa tange minao lapyepala lao pituu, “Baame Gote anda-anda semaiya naeyao pii lelyamo! Aipuma endakali mendapuanya deaka pii nyemana? Baame Gote anda-anda semaiya naeyao pii lelyamo doko nyakamame indupa sepelyamino. ");
INSERT INTO enq2_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nyakamame aipa pimana lao masilyamipi?” lea. Dopa leamopa baanya pii yanu pyakamaiyoo, “Baa pyao kumasepengena” leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dopa latala, baanya lenge-lyaapinya sopokali tasinya piseta, kimiame pyapa piami. Dokopa akali mendapuame baa kingi kapeme pyao pituu, ");
INSERT INTO enq2_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Emba Kraisa daape! Emba pyalumu akali doko, dokona lao propesi piimi naima langi” leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita baa anda kamapu dokonya peteamopa, kalai wanaku mende ipupala baa lamaiyoo, “Emba apata Galali tange Jisasapa kateambina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dopa leamopa, Pitame endakali kateami dupanya enombanya tanga lao, “Embame pii lelyeno doko aki mende lelyepe lao nambame masala naelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dopa latala baa lome kambu dokonya peamopa, kalai wanaku waka mendeme baa kandatala, endakali dosa kateami dupa lamaiyoo, “Akali dake apata Nasarete tange Jisasa dokopa kateambina” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dokopa Pitame baanya pii dupa kyeto tasalanya, Gotenya kenge doko latala lao pituu, “Akali lelyeno doko namba nakandenge etete daana” lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gii kuki pateamopa, akali dosa kateami dupa ipupala Pita lamaiyoo, “Embanya pii dokome panalumuna, kiningi etete emba akali dutupanya mendeaka-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dopa leaminopa Pitame baanya pii dupa kyeto tasalanya Gotenya kenge doko latala lao pituu, “Akali doko namba nakandenge etete daana, sambo lato doko Goteme namba pinana” lea. Dopa lalu piamopa, yaka pauli pii mende lea. ");
INSERT INTO enq2_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dokopa Jisasame Pita lamaiya pii datupa Pitame masia: “Yaka pauli pii ene laanya pitamopa, paa tepomasa embame namba nakandengena laapenona” lea dutupa masetala, Pita kamaka pyakalyetala, ee lao putukia. ");
INSERT INTO enq2_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yongama wamba, prisa mupapi, Juumanya isingi akalipi, dupa pitakame Jisasa pyao kumasemana latala, pii lao kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lao kambutala dupame baa anjetala laminao pao Gapena Pondiasa Pailata maiyami. ");
INSERT INTO enq2_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisasa pyao kumasemana leamino doko kandatala, yandapipi dupanya kinginya Jisasa maiya akali Judasa doko mona aloo pia. Dopa petala, baame silipa muni 30 nyia dutupa minao pupala, prisa mupapi, Juumanya isingi akalipi, dupa tange maiyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Maiyakamaiyoo pituu dokaita lamaiyoo, “Akali tenge nakatenge mende nambame yandapipi dupanya kinginya maipu doko, nambame kopeta pipu-lamona” lea. Dopa leamopa dokaitame lao pituu, “Doko embanya kalai. Naimanya kalai mende daana” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dokopa Judasame muni dutupa lotuu anda nee nyetae dokonya pyale latala baa pea. Pupala baa tange mangenya kende katatala, yukutae katao kumia. ");
INSERT INTO enq2_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Prisa mupa dupame silipa muni dutupa nyepala lao pituu, “Endakali pyao kumasalanya muni datupame enge nyepae dokonya, lotuu anda nee nyetae dakenya muni singi dokonya setala naeyapengena lao loome latae singina” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dopa latala dupa pii lao kambutala, endakali opone kumatami dupa malu pipengena latala, akali yuu nongeaneme penge wasingi dokonya yuu doko muni dutupame sambeami. ");
INSERT INTO enq2_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tenge dokonya, yuu sambeami doko kenge Taeyoko Ee leami. Indupapi Taeyoko Ee lelyaminoaka. ");
INSERT INTO enq2_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Yuu doko sambeami dokome, propeta Jeremaeyame lao pituu, “Israele dupame akali mendai muni silipa 30 dutupame sambao nyepengena lao makande miniami dutupa nyiami. Nyepala Kamongome namba langiali pyoo, akali yuu nongeaneme penge wasingi dokonya yuu doko sambeamina” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasa baa gapena dokonya enombanya laminao pao katasiaminopa, gapena dokome baa tipa pyoo, “Emba Juumanya Kiŋi dokope?” lea. Dokopa Jisasame baa lamaiyoo, “Embame latelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dokopa prisa mupapi, Juumanya isingi akalipi, dupame Jisasa-kisa tenge seteaminopa, baame yanu pyao pii mende nalea. ");
INSERT INTO enq2_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dopa piamopa Pailatame baa lamaiyoo, “Emba-kisa tenge longo setao pii lelyamino dupa embame nasilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dokopa Jisasame pii leami dupanya mendaipi mende yanu pyala naeyamosa, gapena doko etete paka kaeya. ");
INSERT INTO enq2_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nee andake nenge gii doko epelyamopa, akali anjetae dupanya mende endakali kambu dokome mokokena lelyami doko gapena dokome mokata pyakamaingi. ");
INSERT INTO enq2_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Gii dokopa akali Barabasa lenge, pundunya kenge singi mende anjetae palea. ");
INSERT INTO enq2_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Prisa mupa dupame tilya nyepala Jisasa anjoo dimini-lamo lao Pailatame kandatala, baame endakali kambu doko lamaiyoo, “Nambame api mokokapili lao masilyami? Barabasape, pande Jisasa Kraisa lengema dokope?” lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dopa latala, Pailata baa kote singi toko dokonya peteamopa, baanya etanenge dokome pii peyao pituu, “Nambame akali tolatae dokonya lao kuakama kombea etete koo mende pyoo dokome, kenda andake mende pyumuna, embame baa mende napipi” lanya pea. ");
INSERT INTO enq2_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Barabasa mokokena, Jisasa pyao kumasina lapape lao prisa mupapi, Juumanya isingi akalipi, dupame endakali kambu dupa ingi tuu leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dopa leaminopa, gapena dokome endakali kambu dupa lamaiyoo, “Nambame akali lapoma dolaponya anduku nyakamanya mokokapili lao masilyamipi?” lea. Dopa leamopa dokaitame lao pituu, “Barabasana” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dokopa Pailatame dokaita lamaiyoo, “Dopa-tamo doko, nambame Jisasa Kraisa lengema doko aipa pyuape?” lea. Dopa leamopa dokaita pitakame lao pituu, “Baa poko itanya pyao yukuina laa!” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dopa leaminopa gapena dokome dokaita lamaiyoo, “Aipuma? Baame koo aki mende pipyape?” lea. Dopa leamopa dokaitame lao pituu, “Baa pyao yukuina laa!” lao eteteaka puu lao leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dopa leami dokome pundu andake mende sakatatamopa, Pailatame mende pyaa naeyalapo-lamo lao kandea. Kandatala baame endakali kambu dokonya enombanya endaki kamupae mendatupa nyepala, kingi wasa pyao pituu, “Akali dakenya taeyoko doko namba-kisa nakatenana, nyakama-kisa katena peekelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dopa leamopa endakali dupa pitakame baanya pii yanu pyakamaiyoo, “Baanya taeyoko doko naimapi, naimanya wanepi, dupa-kisa katenana!” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dokopa Pailatame Barabasa mokokamaiya. Dopa petala amii dupame Jisasa konjame pyapala pyao yukuina lao maiya. ");
INSERT INTO enq2_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dokopa gapenanya amii dupame Jisasa laminao, gapomane isingi akali andake doko petenge anda dokonya kolandatala, amii dupa pitaka baa katea dokonya ipao kambu piami. ");
INSERT INTO enq2_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dopa petala dupame Jisasanya yonge pee dupa lyokao nyepala, yonge pee kisa pingi kate pyapae mende baanya pyakamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dopa petala kende nenge-nenge katapae mende makipu petala, baanya aiyombanya pisetakamai, pangali mende baanya kingi tolaetena minasiami. Minasetala baanya enombanya luma lakapala lamba lao, “Juumanya Kiŋi doko, emba auu pyoo katape!” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dopa latala dupame baa sopokali tasinya pisetala, pangali doko nyepala aiyombanya pyapa piami. ");
INSERT INTO enq2_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dopa pyoo baa lamba latala, yonge pee pyakamaiyami doko lyokao nyepala, baanya pingi dupa pyakamaiyami. Dopa petala, baa pyao yukulanya laminao kamaka peami. ");
INSERT INTO enq2_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kamaka pyakalyiaminopa, Sairini tange akali Saimone lenge mende amii dupame kandanyetala, baa pyalanya latala, Jisasanya poko ita doko nyoo sakamaina leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sakamaiyamopa yuu Gologota lenge dokonya pao pyakalyiami. (Gologota dokonya tenge doko, Matena Kuli.) ");
INSERT INTO enq2_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dokopa dupame kapo waene peteta mendenya wele kaa pipae-pipa pyasetae mende Jisasa nena lao maiyaminopa, baame nao sepala, nanatoo lao masia. ");
INSERT INTO enq2_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dokopa amii dupame baa poko itanya pyao yukuiyami. Yukutala amii dupame baanya yonge pee dupa mokosoo nyemana latala laki piami. ");
INSERT INTO enq2_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dopa petala dupame Jisasa isoo dosa kandatae peteami. ");
INSERT INTO enq2_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisasa-kisa tenge seteami pii dake pepa pyatae poko ita ketae dokonya baanya aiyomba sia dosa yukuiyami: “Dake Jisasa, Juumanya Kiŋi dokona” latae katea. ");
INSERT INTO enq2_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pake nenge lapoma baa-pipa pyao yukuiyami. Mende doko baanya kingi tolaetena yukuiyami. Mende doko baanya kingi koeyatena yukuiyami. ");
INSERT INTO enq2_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jisasa pyao yukutae katea dokonya-kaita endakali paeyami dupame aiyomba wangatoto petapu lao nepao ");
INSERT INTO enq2_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lao pituu, “Embame lotuu anda nee nyetae doko lakyepala, yuu gii tepomanya waka mende pitona leeno akali dokae, emba tange pyoo nyepoko! Emba Gotenya Ikiningi-tamo doko, poko ita doko yakinatala isa ipupoko!” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mendai dopaka pyoo, prisa mupapi, Mosesanya loo mana nyepaepi, Juumanya isingi akalipi, dupame Jisasa lamba lao, ");
INSERT INTO enq2_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Baame endakali waka dupa pyoo nyipumuaka doko, baa tange kapa pao pyoo nyala naenge-lamo. Baa Israele dupanya Kiŋi-tamo doko, indupa baame poko ita doko yakinatala isa epena kae. Dokopa naimame kandatala baa tungi pyamana. ");
INSERT INTO enq2_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Baa Gotenya Ikiningina latala, Gote tungi pingi daape. Goteme baa nee kaenge-tamo doko, indupa baa pyoo nyina kae” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pake nenge baa-pipa pyao yukutae kateambi dolapome mendai dopaka pyoo baa lamba leambi. ");
INSERT INTO enq2_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kotaka 12 kiloko leamopa yuu doko pitaka kuiya doko, kuiyetaeyaka katao pao, alemandi 3 kilokonya tuu lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Alemandi 3 kilokopi mende leamopa, Jisasame puu lao wii lao, “Ilai, Ilai, lima sabatani?” lea. (Pii dokonya tenge doko, “Nambanya Gote, nambanya Gote, embame namba aipuma yakinelyepe?”) ");
INSERT INTO enq2_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dopa lea doko endakali dosa kateami dupanya mendapuame sepala lao pituu, “Akali dakeme Ilaija lao wii lelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dopa lalu piaminopa, akali mendeme alo pyao pao, koma jepae mende nyepala, waene kaa pipae mendenya pyandao waeneme tumbasetala, kolo itakuli mendenya tuku petala, Jisasa nena lao makapusia. ");
INSERT INTO enq2_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Endakali yangi dupame lao pituu, “Ilaijame baa pyoo nyala epelyape lao kandamana kae” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dokopa Jisasame eteteaka puu lao ae latala, baanya imambu doko yakinea. ");
INSERT INTO enq2_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dokopa lotuu anda nee nyetae dokonya panda nee nyetae dotena kame pinyoo lapalapa andake mendeme kame pinyetae katenge doko ketae pituu titi pyao isa tuu latala lapo pyoloo pia. Dopa piamopa, yuu doko titiwali minao, kana yale dupa pukutala saa laloo pia. ");
INSERT INTO enq2_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Endakali malu dupa pukuloo petala lumbiamopa, endakali Gotenya latae longo dupanya yonge malu petae kateami dupa sakatasia. ");
INSERT INTO enq2_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(Jisasa malunya sakatateamopa, endakali Gotenya latae dupanya malu dupa yakinatala, siti nee nyetae Jerusalema dokonya pupala, endakali longome kandena lao panasiami.) ");
INSERT INTO enq2_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Amii 100 isingi dokopi, baa-pipa Jisasa isoo kateamipi, dupame titiwali miniapi, waka mendapu piapi, dupa kandao etete paka kaeyapala lao pituu, “Kiningi etete, akali dake Gote Ikiningi-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Enda longo mendapu Galali pituu, Jisasa nisoo baa watao epeami dupa Jisasa pyao yukuiyami dosa kuki londatili pituu kandatae peteami. ");
INSERT INTO enq2_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Enda dutupanya mendatupa, Maria Magadala tange dokopi, Jemesapa, Josepepa dolaponya endangi Maria dokopi, Sebedi ikiningi dolaponya endangi dokopi, dutupa peteami. ");
INSERT INTO enq2_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yuu kuiyalanya piamopa, Jisasanya disaipolo mende, akali Arimatia tange kamongo Josepe lenge doko ");
INSERT INTO enq2_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pailata katea dokonya pupala, Jisasanya yonge doko dina lao tee lea. Dopa leamopa Pailatame nyina lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dokopa Josepeme Jisasanya yonge doko nyepala, lapalapa kaimala nakatenge, kyeo lapae mendeme yaki pia. ");
INSERT INTO enq2_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dopa petala, Josepe baa tange malu pitamina lao kananda enenge tumbinya setea dokonya Jisasanya yonge doko nyoo setea. Setapala kana yale mende kapilya mina-mina pyoo malu kambu doko piti petala, baa pea. ");
INSERT INTO enq2_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Dopa piamopa, Maria Magadala tange dokopa, Maria mende dokopa, dolapome malu dokonya yangitena pituu kandatae peteambi. ");
INSERT INTO enq2_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sambata depa lenge gii doko etapeamopa, yuu gii mende dokonya, prisa mupapi, Parasipi dupa Pailata petea dokonya ipao kambu piami. ");
INSERT INTO enq2_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Dopa petala dupame Pailata lamaiyoo, “Akali Andake, sambo lenge akali dokome saka katao pituu, baa yuu gii tepo dokonya sakatatona leamo doko naimame masilyamano. ");
INSERT INTO enq2_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dopana, baanya disaipolo dupame baanya yonge doko waa katao nyoo yalo petala, endakali dupa lamaiyoo, baa sakatapyana laamino. Dopa laamino dokome, wamba endakali dupa kyakasiamo doko ita minao, indupa eteteaka kyakasalaminona, malu doko isokondape pyoo isoo katao, yuu gii tepo dokonya tuu lena lape” leami. ");
INSERT INTO enq2_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dopa leaminopa Pailatame dokaita lamaiyoo, “Nyakamame amii mendatupa lanyoo pupala, nyakamame masetamili pyoo malu doko isokondape pyoo isoo katena lapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dokopa dokaita pupala, kaname malu piti piami doko piamili petae kalyape lao kandatamana latala, kongali pinya kateami. Dopa petala amii dupame malu doko isokondape pyoo isoo katena leami. ");
INSERT INTO enq2_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambata gii doko pateamopa, yuu yongalanya pia. Dokopa Maria Magadala tange dokopa, Maria mende dokopa, dolapo malu doko kanja peambi. ");
INSERT INTO enq2_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gii dokopa titiwali andake mende minatala, Kamongonya enjele mende kaiti-kisa katao isa ipupala, kana doko kapilya mina-mina pyoo nyoo kapya latala, dokonya ketae petea. ");
INSERT INTO enq2_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Baanya lenge-lyaapi doko yuu-wapaka pingili pia. Baanya yonge pee doko etete kyeo lao polepole pia. ");
INSERT INTO enq2_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dopa piamo kandatala, amii malu isoo kateami dupa walu lao paka kaeyami dokome, lombapae sepala kumapae joo siami. ");
INSERT INTO enq2_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dokopa enjele dokome enda dolapo lamaiyoo, “Paka nakaeyalapape. Jisasa pyao yukuiyamino doko nyakambame kutilyambinona lao nambame masilyo. ");
INSERT INTO enq2_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Baa sakatato leamoli pyoo sakatatalamo. Kamongo doko seteamino panda dakenya nasilyamona, kanja ipupa. ");
INSERT INTO enq2_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kandatala baanya disaipolo dupa kalyamino dokonya nyakamba yapa pupala, baa malunya sakatatala Galali wambao pelyamona, dokonya baa kanjaminona lamaiyepape. Nambame pii langya epo doko langitilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dopa leamopa enda dolapo paka kaeyambiaka doko, eteke kaeyapae andake mendeme tumbiamopa, malu doko yapa yakinatala, alo pyao disaipolo dupa lamaiya peambi. ");
INSERT INTO enq2_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Disaipolo dupa lamaiya peambinopa, Jisasame kaitinisa kandanyetala lao pituu, “Wanalapo, yongama etete!” lea. Dokopa enda dolapo pao Jisasanya mokonya kopetala mambo piambi. ");
INSERT INTO enq2_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dopa piambinopa Jisasame enda dolapo lamaiyoo, “Nyakamba paka nakaenya, nambanya kaiminingi dupa kalyamino dokonya pupala, dupa Galali pena lapape. Dupame dokonya namba kanjaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Enda dolapo peambinopa, malu isoo kateami amii dupanya mendapu siti dokonya pupala, pia dupa pitaka prisa mupa dupa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dokopa prisa mupapi, Juumanya isingi akalipi, dupame pii lao kambutala, amii dupa muni longo mendapu maiyami. ");
INSERT INTO enq2_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Maitala pii dapa lena lamaiyami: “Nyakama luu palipamanopa, Jisasanya disaipolo dupa kuka ipupala, baanya yonge doko waa katao nyoo pamini-lamona lapape. ");
INSERT INTO enq2_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gapena dokome pii dake setamo doko, baa auu kaena lao naimame baa pii lamaitamanopa, nyakama-kisa pundu mende naipapomona” leami. ");
INSERT INTO enq2_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dopa lateaminopa, amii dupame muni dutupa nyepala, lena leamiliaka pyoo lao taeyami. Pii doko lao Juu dupa-kisa taeyami doko, indupapi taeyapaeyaka silyamo. ");
INSERT INTO enq2_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Disaipolo 11 dutupa Galali pupala, Jisasame manda mendenya pena lea dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dokonya pao Jisasa kandatala, baa mambo piami. Dopaka doko, mendapu mona lapo paleami. ");
INSERT INTO enq2_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dokopa Jisasa baa dokaita kateami dokonya pupala lamaiyoo, “Yuupi, kaitipi dupa pitaka isepe lao Goteme kyeto doko namba ditia. ");
INSERT INTO enq2_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dopana, nyakama pupala, akali tata dupa pitaka nambanya disaipolo jina lao pii lamaiyepape. Lamaitala, Takange dokopi, Ikiningi dokopi, Oli Spirita dokopi, dutupanya kenge dokonya kaimbu pyatakamai, ");
INSERT INTO enq2_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nambame pyepape lao langio dupa pitaka wata-minina lao mana lamaiyepape. Salapape! Namba nyakama-pipaka katao, yuu etata gii doko kandao nyetamana” lea. Doko kiningi. ");
INSERT INTO enq2_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gote Ikiningi Jisasa Kraisanya wai pii epe doko tee piamo doko. ");
INSERT INTO enq2_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Propeta dupame pepa piami dokonya dapa lao pepa pyapae silyamo: “Salapape! Nambanya wai akali doko nambame wambao pena latopa, embanya kaitini doko depa lakata. ");
INSERT INTO enq2_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Akali doko endakali napalenge yuu mendenya katapala wii lao, ‘Kamongonya kaitini doko depa lakamaiyepape. Kaitini koeyapae dupa tolasakamaiyepape’ lao katatana” lapae singi. ");
INSERT INTO enq2_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dopa lapae singili pyoo, Jone kaimbu pingi doko endakali napalenge yuu mendenya katapala, endakali dupanya koo dupa Goteme kunao nepekena, mona kapilyina lao lamaitala, kaimbu pyakamaiyoo katea. ");
INSERT INTO enq2_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dokopa Judia yuu doko pitakanya tangepi, Jerusalema tangepi, dupa pitaka baa katea dokonya peami. Pupala dupanya koo dupa lao panata piaminopa, baame endaki Jodane dokonya dupa kaimbu pyata pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jone baa yonge pee kamele itimi wasepaepi, matapu kao yanungimi wasepaepi, dupa pyoo katea. Baa paiyombapi, oni kakasa lyingipi, dupa nao katea. ");
INSERT INTO enq2_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Baame endakali dupa lamaiyoo, “Akali mende nambanya maitanya epelyamo dokonya kyeto dokome namba ita minilyamo. Namba luma lakapala, baanya moko pee dolaponya kende tata lakamaiyanya, namba epe daa. ");
INSERT INTO enq2_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nambame nyakama endakimi kaimbu pyekelyo. Dopaka doko, baame Oli Spiritame nyakama kaimbu pyakatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gii dosa mendasa, Jisasa baa yuu Galali dokonya taono Nasarete katao epeamopa, endaki Jodane dokonya Joneme baa kaimbu pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Baa kaimbu nyepala, endaki ketae pyakalyulu petala kandeamopa, kaiti doko saa papa laloo petala, Spirita doko yaka maiyolee joo lanao ipao baa-kisa petea. ");
INSERT INTO enq2_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dokopa kaiti-kisa katao pii mende lea dokome lao pituu, “Emba nambanya Ikiningi mona setenge, nambame etete auu kaenge dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dopa lalu piamopa, Spirita dokome Jisasa baa endakali napalenge yuu mendenya pena lao pyasia. ");
INSERT INTO enq2_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pyaseteamopa baa pupala, endakali napalenge yuu, mena yanapi kapu katenge dokonya, yuu gii 40 katea. Katea gii dutupanya Sataneme baa makande pia. Dokopa enjele dupa ipupala Jisasa nisiami. ");
INSERT INTO enq2_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jone kaimbu pingi doko anjeteaminopa, Jisasa baa Galali pupala, Gotenya kingdom dokonya lao wai pii epe doko lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Goteme gii setea doko indupa ipao palipilyamo. Gotenya kingdom doko tengesa ipatelyamona, nyakama mona kapilyetala, wai pii epe doko kiningina lao masalapape” lao katea. ");
INSERT INTO enq2_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisasa baa Galali pete lemba dokonya pupala kandeamopa, Saimonepa, baanya kaiminingi Andruapa, dolapo pisa nyingimba dokonyana, umbene mende endaki pete dokonya pyandao pisa nyoo kateambi. ");
INSERT INTO enq2_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Dokopa Jisasame dolapo lamaiyoo, “Nyakambame pisa nyingimbali pyoo, endakali nyalapale mana langitoo, namba watao ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dopa lalu piamopa, akali dolapome umbene dupa yakinatala, baa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Umbisale pupala, Jisasame Sebedi ikiningi Jemesapa, kaiminingi Jonepa dolapo sipi andaka umbene tambuu peteambino kandea. ");
INSERT INTO enq2_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kanju petala baame dolapo wii lao nyia. Dokopa dolaponya takange Sebedi kalai akali dupa-pipa sipi dokonya yakinatala, dolapo Jisasa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisasa baa akali dutupa-pipa Kapename peami. Pupala Sambata gii dokonya lotuu anda dokonya kolandatala, Jisasame mana lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Baame mana lea dupa, Mosesanya loo mana nyepae dupame lengemali pyoo laa naenya, baa-kisa mana lapenge kyeto doko singi joo leamosa, endakali dupame sepala paka kaeyao walu leami. ");
INSERT INTO enq2_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dokopa akali imambu koo paleta mende lotuu andaka dokonya petea dokome wii lao, ");
INSERT INTO enq2_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasarete tange Jisasa, embame naima yakinatala puu. Emba Akali Gotenya Latae doko nambame kandengena, embame naima aipa pyaa epe? Naima koeyasala epepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dokopa Jisasame baa pyalanya lao, “Embanya nenge-kaita lyokatala, akali dake yakinatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dopa leamopa, imambu koo dokome akali doko minao walu lasetala, ae andake mende lao akali doko yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dokopa endakali dupa pitaka paka kaeyao walu latala, mende tipa pii-pii pyoo, “Dake aipa pilya? Mana enenge dake mana aipale mende? Baanya kyeto dokome, imambu koo dupame apata mende pina lelyamopa, lelyali pingima-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dokopa Galali makisa yuu singi dupa pitakanya Jisasanya lao pii doko pupae lao, lao taeyami. ");
INSERT INTO enq2_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisasapi, Jemesapi, Jonepi dutupa lotuu anda doko yakinalu petala, Saimonepa, Andruapanya andaka peami. ");
INSERT INTO enq2_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pao pyakamalu piaminopa, Saimonenya enda imange doko yonge itaita pimupa yaina silyamona lao Jisasa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lamaitiaminopa, Jisasa enda doko sia dokonya pupala, enda dokonya kinginya minatala baa sakatasia. Dokopa yonge itaita pia doko mee julu piamopa, enda dokome dokaita nee nyoo maiya. ");
INSERT INTO enq2_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Niki landa pyatala yuu kuiyalanya piamopa, endakali mendapuame yaina pyapaepi, imambu koo paletapi, dupa laminao baa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Endakali siti dokonya tange dupa pitaka anda kambu dokonya kambu piami. ");
INSERT INTO enq2_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dokopa yaina tata waka-wakame pyapae endakali longo dupa baame mee jeta, imambu koo longo dupa watao pyata pyakamaiya. Imambu koo dupame baa akali dokona lao kandengema dokonyana, dupame pii laa naena lao baame daa lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yuu ene yongalanya iminjetae kateamopa, Jisasa sakatao endakali napalenge yuu mendenya pupala, dokonya loma soo katea. ");
INSERT INTO enq2_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dokopa Saimonepi, endakali baa-pipa kateamipi, dupame baa kutao peami. ");
INSERT INTO enq2_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pao kandatala dupame baa lamaiyoo, “Endakali dupa pitakame emba kutilyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dopa leaminopa Jisasame dokaita lamaiyoo, “Nambame endakali dupa pitaka wai pii epe doko lamaipenge. Tenge dokonyaka namba epeona, taono yakane tengesa silyamo dupanya apata pii lamaitoo mua” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dopa latala baame Galali yuu doko pitakanya paeyao, dokaitanya lotuu anda dupanya pii lamaita, imambu koo dupa watao pyata pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Akali kopetali mendeme Jisasa katea dosa ipao luma lakapala, kyeto joo tee lao, “Embame nambanya yaina dake mee jetala, pyoo wasepae kalyale lao maseteno doko, yaina dake mee jakatenopa, namba pyoo wasepae kalyapona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dokopa Jisasame akali doko kondo kaeyapala, kingimi watandatala baa lamaiyoo, “Emba pyoo wasepae kalyale lao masetala, nambame embanya yaina doko mee jina lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dopa lalu piamopa, kopetali yaina dokome akali doko yakinea. Yakinateamopa baa pyoo wasepae katea. ");
INSERT INTO enq2_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dokopa akali dokome dapa nalena lao Jisasame kyeto joo lamaitala baa pena lalu pia: ");
INSERT INTO enq2_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nambame embanya pyakalo doko endakali mende lamaiya naenya, prisa dokome emba kandena puu. Pupala Mosesame mana seteali pyoo embame dopale mende Gote kundi maitinopa, endakali dupame emba pyoo wasepae kalyene-lamo lao kandenana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dopa leaka doko akali doko pupala, pia dupa pitaka tee pyao lao taeya. Dopa pia dokonya, Jisasa siti mendenya panao pupenge nanjiamosa, endakali napalenge yuu dupanya katea. Kateamopa, endakali dupa yuu dupa pitakanya katao baa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gii mendatupa pateamopa, Jisasa baa Kapename pilyia. Pilyeteamopa baa andaka kalyamo lapae doko siami. ");
INSERT INTO enq2_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sulu petala endakali longo ipao, andakotepi, anda kambupi dupanya tumbiaminosa panda nasia. Dokopa Jisasame dokaita wai pii epe doko lamaiyoo kateamopa, ");
INSERT INTO enq2_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","akali kitomendeme akali papa tambutae mende soo baa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ipupala kandeaminopa, endakali tumbia dokome andakote kolandapenge nanjiamosa, anda yame pyatae dokonya kaina dosa lopao kapya leami. Dopa petala, lapa toko dokonya kende katatala, papa tambutae doko paleta lanao pyandeami. ");
INSERT INTO enq2_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dokopa akali dutupame tungi piamino doko Jisasame kandatala, papa tambutae doko lamaiyoo, “Wane, embanya koo dupa kunao nepatae kalyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dopa leamopa, Mosesanya loo mana nyepae mendapu dosa peteami dupame nyakamanya moname masoo pituu, ");
INSERT INTO enq2_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Akali dakeme aipuma Gote anda-anda semaiya naeyao dopa lelya? Endakali mendeme endakalinya koo dupa kapa pao kunao nepala naenge. Goteme iki endakalinya koo dupa kunao nepengena” lao masiami. ");
INSERT INTO enq2_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dopa lao masiami dupa Jisasame kanju petala dokaita lamaiyoo, “Aipuma nyakamanya moname dopa lao masilyami? ");
INSERT INTO enq2_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Papa tambutae dake lamaiyoo, pii dalaponya anduku mee petala lapenge? ‘Embanya koo dupa kunao nepatae kalyenona’ lapenge dokope, pande, ‘Emba sakatatala, embanya lapa toko doko nyoo soo kaita pae’ lapenge doko? ");
INSERT INTO enq2_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Akalinya Ikiningi dokome isa yuu dakenya katao, endakalinya koo dupa kunao nepenge kyeto doko baa-kisa singi-lamo lao kanjepalena” lea. Dopa latala baame akali papa tambutae doko lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Emba sakatatala, embanya lapa toko doko nyoo soo andaka puu lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dopa lalu piamopa, endakali dokaitanya enombanya baa sakatatala, baanya lapa toko doko nyoo soo kamaka pea. Dopa piamopa, endakali dupa pitaka walu lao paka kaeyapala, Gote mambo pyao lao pituu, “Yuu mendaipi mende naimame dapale mende nakandeamana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisasa baa Galali pete lemba dokonya dee pea. Dokopa endakali kambu andake mende baa katea dokonya epeaminopa, baame dokaita mana lamaiyoo katea. ");
INSERT INTO enq2_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lamaitala baa kaita pao pituu, Alopiusa ikiningi Lipai baa takisa nyingi anda dokonya peteamo kandatala baa lamaiyoo, “Emba namba watao ipu” lea. Dokopa baa sakatatala Jisasa watao pea. ");
INSERT INTO enq2_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Maitakao Jisasa baanya disaipolo dupa-pipa Lipainya andaka nee nao peteaminopa, dokonya takisa nyingipi, koo pingipi longo mendapu Jisasa watao peami dupa apata nee nao peteami. ");
INSERT INTO enq2_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jisasa baa takisa nyingipi, koo pingipi dupa-pipa nee nao peteamo kandatala, Mosesanya loo mana nyepaepi, Parasipi dupame baanya disaipolo dupa lamaiyoo, “Baa aipuma takisa nyingipi, koo pingipi dupa-pipa nee endakipi nao pilyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pii leamino doko sepala Jisasame dokaita lamaiyoo, “Endakali yaina napingi dupa dokosa yangyala naenge. Endakali yaina pyapae dupa dokosa yangingi. Nambame endakali tolatae dupa wii lao nyalanya naepeo. Endakali koo pingi dupa mona kapilyina lao, wii lao nyalanya epeona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jonenya disaipolopi, Parasi dupanya disaipolopi, dupame loma soo nee nanao kateami. Dopa piaminopa, endakali mendapu ipupala Jisasa lamaiyoo, “Jonenya disaipolopi, Parasi dupanya disaipolopi, dupame loma soo nee nanao katapa pingimana, embanya disaipolo dupame aipuma dopa napingimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dopa leaminopa Jisasame dokaita lamaiyoo, “Akali mende enda kelyapala watapae pyao, baanya tata dupa-pipa kalyamo gii dokopa, baanya tata dupa nee nala naenya kaengemape? Daa, enda kelyelya akali doko baanya tata dupa-pipa kalyamo gii dokopa, watapae pyao nee nao katengema. ");
INSERT INTO enq2_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gii doko palitamopa, akali enda kelyenge doko nyoo patataminopa, baanya tata dupame loma soo nee nanao katatami. ");
INSERT INTO enq2_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Yonge pee atingi mende tii telyamopa, lapalapa kangupae enenge mendeme kii pimbala naenge. Kii pimbatamino doko, enenge doko inungunyeta dokome, atingi doko etete kanguu koeyaseta. ");
INSERT INTO enq2_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Endakali mendeme waene enenge kamuu, penge meme yanungimi wasepae atingi mendenya pyandala naenge. Kamuu pyandatamo doko, waene enenge doko bolo lata dokome, penge atingi doko kanguu koeyasetamopa, waene dupa kai lao pata. Dopana, waene enenge doko penge enengenyaka kamuu pisepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sambata gii mendenya Jisasa baanya disaipolo dupa-pipa wita ee mendenya-kaita peami. Dokopa baanya disaipolo dupame tee pyao wita dii dupa kii lao nyepa-nyepa pyoo peami. ");
INSERT INTO enq2_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dopa piaminopa Parasi dupame Jisasa lamaiyoo, “Sambata gii dokonya loome napipenge latae singi doko akali dakaitame aipuma pilyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dokopa Jisasame dokaita lamaiyoo, “Dapitapi, baa-pipa kateamipi, dupanya nee napenge mende nasiamopa lopo kaeyapala, baame pia doko yuu mendaipi mende nyakamame itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Prisa mupa Abiata katea gii dokopa, Dapita lotuu anda nee nyetae dokonya kolandatala, breta Gote opaa maitae, mee endakali dupame nanapenge, prisa dupame iki napengena lao loome latae singi dupa nyepala, baa-pipa kateami dupa maiyoo neana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Dopa latala baame dokaita lamaiyoo, “Goteme Sambata gii doko masetala endakali wasala naeya. Endakali masetala Goteme Sambata gii doko setea. ");
INSERT INTO enq2_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akalinya Ikiningi doko Sambata dokonya apata Kamongo kalyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisasa baa dee lotuu anda dokonya peamopa, andakote dokonya akali kingi yangi talyanga mende petea. ");
INSERT INTO enq2_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Peteamopa, Parasi dupame Jisasa-kisa tenge setamana lao masetala, Sambata gii dokonya kingi talyanga doko baame tolasakamailyape lao kandakondape petae peteami. ");
INSERT INTO enq2_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dokopa Jisasame kingi talyanga doko lamaiyoo, “Emba sakatatala, endakali pitakanya enombanya kalya ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dopa latala baame dokaita lamaiyoo, “Loome aipa lapae singi? Sambata gii dokonya kalai epe pipengepe, pande koo pipenge? Endakali nisepengepe, pande endakali pyao kumasepengepe?” lea. Dopa leamopa, dokaita ema napyoo ");
INSERT INTO enq2_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","mona kana jiaminosa, Jisasame imbu kaeyao dokaita kandayoko latala, akali doko lamaiyoo, “Embanya kingi doko tinoko” lea. Dokopa baanya kingi doko tinokeamopa, kingi doko auu petala kingi yangi epe dopaleaka jia. ");
INSERT INTO enq2_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dopa piamopa, Parasipi, Kiŋi Erote tatapi, dupame Jisasa aipa petala pyao kumasemape lao yapa kamaka kolalyetala kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Dopa piaminopa, Jisasa baanya disaipolo dupa-pipa yuu doko yakinatala, Galali pete dokonya peaminopa, Galali tange kambu andake mendeme baa watao peami. Dokopa Jisasame pilyamo lapae dupa sepala, Judia tangepi, Jerusalema tangepi, Idumia tangepi, endaki Jodane omotena tangepi, Taeyapa Saidonepa dolaponya makisa dosa tangepi, longo mendapu baa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Wamba baame endakali yaina pyapae longo mee jakamaiya dokonya, endakali yaina pyapae epeami dupa pitakame baa watandamana latala, tuu-tuu lao baa katao tambukinalanya piami. Dopa piaminosa, endakali kambu andake dokome baa katao tambukinala naena lao, sipi yakane mende disaipolo dupame depa lekena lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Imambu koo dupame baa kandeamili pyoo, baa katea dosa ipao tombauli sepala puu lao, lao pituu, “Emba Gote Ikiningina” lata piami. ");
INSERT INTO enq2_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dokopa imambu koo dupame Jisasa baa akali dokona lao, lao panala naena lao kyeto joo pyalanya lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisasa baa lalyoo yuu manda mendenya pupala, akali mendatupa baa watao epena lao masia dutupa epena leamopa, dokaita baa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Epeami dupanya akali 12 baa-pipa katamana lao yapao nyia. Yaina mee jingi dokopa, imambu koo dupa watao pingi dokopa, dolaponya kyeto doko dutupa maitala, wai pii epe doko lamaiya pena laanya yapao nyia. ");
INSERT INTO enq2_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yapao nyepala, Saimone baa kenge enenge Pita lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi ikiningi Jemesapa, Jemesa kaiminingi Jonepa dolapo kenge Bonagesa lea. (Bonagesa dokonya tenge doko, Kaiti toka lenge dokonya ikiningi.) ");
INSERT INTO enq2_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andruapi, Pilipapi, Batalomyuapi, Matyuapi, Tomasapi, Alopiusa ikiningi Jemesa lenge dokopi, Tadiusapi, Kena tange Saimone lenge dokopi, ");
INSERT INTO enq2_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yandapipi dupanya kinginya Jisasa maiya akali Judasa Iskariota lenge dokopi, dutupa apata baame yapao nyiaka. Yapao nyepeamopa, dokaita anda mendenya peami. ");
INSERT INTO enq2_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dokopa endakali dupa dee ipao kambu piaminosa, baanya disaipolo dupa-pipa Jisasa baa nee napenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Endakali dupame lao pituu, “Baa kyakelyamona” leami. Dopa leami doko baanya tata dupame sepala, baa kii minao lanyala epeami. ");
INSERT INTO enq2_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Epeaminopa Mosesanya loo mana nyepae, Jerusalema katao lanao epeami dupame lao pituu, “Baa-kisa Belesabulu palelyamona” leami. “Imambu koo dupanya isingi dokonya pupu lapae dokome imambu koo dupa baame watao pilyamona” leamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dopa leaminopa, baame dokaita epena latala kongalimi lamaiyoo, “Sataneme Satane yango aipa petala watao pyata? ");
INSERT INTO enq2_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Isa yuu dakenya kingdom mendenya endakali dupa pyaloo petala wakale pitamino doko, kingdom doko kyeto joo naseta. ");
INSERT INTO enq2_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Anda mendenya palenge dupa pyaloo pitamino doko, dokaita kyeto joo nakatatamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dopaka pyoo, Satane baa tange wakale pyaloo petala, yanda pingi-tamo doko, baa kyeto joo nakatenya, baa etata. ");
INSERT INTO enq2_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Akali mendeme akali pupu lapae mendenya andaka kolandatala, baanya pinju dupa pake nyalanya-tamo doko, wambao kendeme baa yaki pinya setapala pinju dupa nyeta. ");
INSERT INTO enq2_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nambame nyakama kiningi langilyo: Endakali dupanya koo pingipi, lao nepengepi dupa pitaka Goteme kunao nepakamaita. ");
INSERT INTO enq2_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dopaka doko, Oli Spirita doko lao nepata endakali dokonya koo doko Goteme kunao nepakamaiya naeyatamopa, tanga tangapi sulu setana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisasa-kisa imambu koo mende palelyamona leaminosa, baame dopa lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dokopa Jisasanya endangi dokopi, kaiminingipi dupa ipao katapala, baa kamaka epena lao endakali mendeme lanyala pena leami. ");
INSERT INTO enq2_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dokopa Jisasa pituu kakopeami endakali kambu dupame Jisasa lamaiyoo, “Embanya endangi dokopi, kaiminingipi, pimalengepi dupame emba kutao ipupala kamaka kalyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambanya endangipi, kaiminingipi dupa apitupape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dopa latala baa pituu kakopeami dupa kandayoko latala lao pituu, “Endakali pilyamino dakaita nambanya endangipi, kaiminingipina kanjepa. ");
INSERT INTO enq2_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gotenya masingili pingima endakali dupa nambanya kaiminingipi, pimalengepi, endangipina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisasame endaki pete lemba dokonya endakali dupa deaka tee pyao mana lamaiyoo kateamopa, endakali longo mendapu ipao baa katea dokonya kambu piami. Dopa piaminosa, endaki pete dokonya sipi sia dokonya baa pyakalyetala peteamopa, endakali kambu doko pitaka endaki pete lemba dokonya kateami. ");
INSERT INTO enq2_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kateaminopa Jisasame mana longo mendapu kongalimi endakali dupa lamaiya. Baanya mana lamaiya dokonya lao pituu, ");
INSERT INTO enq2_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Salapape! Ee pokenge mendeme baanya ee wai lyandala pea. ");
INSERT INTO enq2_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pupala lyandeamopa ee wai yangi dupa kaitininya pao sia. Sia dupa yaka dupa ipupala nao eteami. ");
INSERT INTO enq2_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ee wai yangi dupa kana-kisa yuu kuki singi dupanya pao sia. Sia dupa yuu kuki singi dokonya pupae langa lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Langa leaka doko, pingi auu pyoo napiamosa, niki popo pyoo tea dokome dupa sapupala kumia. ");
INSERT INTO enq2_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ee wai yangi dupa lyiki tenge palenge dupanya pao sia. Sia dupa langa leaka doko, lyiki tambetambe andapala kui pyambeamopa, dii namandea. ");
INSERT INTO enq2_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ee wai yangi dupa yuu epe dupanya pao sia. Sia dupa langa lao andapala dii mandea. Yangimi dii 30 lao mandea. Yangimi dii 60 lao mandea. Yangimi dii 100 lao mandeana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dopa latala baame lao pituu, “Nambame pii lelyo dutupa endakali kale katenge dupame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisasa baa iki kateamopa, 12 disaipolo dutupapi, endakali mendatupa tole kateamipi, dupa ipupala, kongali pii dokonya baa tipa piami. ");
INSERT INTO enq2_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dokopa baame dokaita lamaiyoo, “Gotenya kingdom dokonya pii tenge yalo petae doko masalapale lao nyakama ditilyamo. Dopaka doko, endakali kamalya katenge dupa kongaliaka lao lamailyo. ");
INSERT INTO enq2_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dupa mona kapilyetaminopa dupanya koo dupa Goteme kunao nepakamaitame-latala kongaliaka lao lamailyo. Dupame lengeme kandatamiaka doko, tenge angi doko kandao nanyoo, pii kaleme setamiaka doko, tenge angi doko soo nanyoaka pina lao kongaliaka lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dopa latala Jisasame dokaita lamaiyoo, “Nyakamame kongali pii lalo dakenya tenge doko nyala naelyamipi? Nyala naelyamino doko, aipa petala kongali pii waka dupa pitakanya tenge dupa soo nyetami? ");
INSERT INTO enq2_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ee pokenge dokome Gotenya pii doko ee wai joo lyandea. ");
INSERT INTO enq2_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ee wai yangi kaitininya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko sulu pilyaminopa, Satane doko ipupala, endakali dupanya monanya Goteme pii ee wai joo lyandelya doko nyoo nepenge. ");
INSERT INTO enq2_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ee wai yangi kana-kisa yuu kuki singi dupanya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko sepala, auu kaeyao yapa nyepala, ");
INSERT INTO enq2_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","gii kuki mendatupa auu pyoo katengema. Dopaka doko, pii doko mambele kenda dupa epelyamopapi, endakali waka dupame dokaita tanda maiyoo koeyasilyaminopapi, pii doko dokaita-kisa pingi pyala naenge dokonyana, dokaita pupae isa pyakengema. ");
INSERT INTO enq2_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ee wai yangi lyiki tenge palenge dupanya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko singimaka doko, ");
INSERT INTO enq2_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","muni putiti kaenge mana dokome dokaita minakasilyamopa, yuu dakenya nee kaengepi, oapi longo setapu laka lao masingipi, dupame pii doko kui pyapala, dokaita-kisa dii namandenge. ");
INSERT INTO enq2_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ee wai yangi yuu epenya lyandeana lalo dokonya tenge doko dake: Endakali yangimi pii doko soo nyepala, yangimi dii 30 lao mandenge, yangimi dii 60 lao mandenge, yangimi dii 100 lao mandengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dopa latala baame dokaita lamaiyoo, “Endakali mendeme lama kaiyepae mende nyepala, penge mendenya koko pyandengepe, pande palenge toko mendenya pundipundi setenge? Lama kaiyepae doko toko-kisa panao setala naengepe? ");
INSERT INTO enq2_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yame pyatae silyamo dupa pitaka gii mendepa lopapae seta. Yalo petae silyamo dupa pitaka gii mendepa panapae seta. ");
INSERT INTO enq2_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Endakali mende kale katenge-tamo doko, nambame pii lelyo dutupa baame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dopa latala baame dokaita lamaiyoo, “Nyakamame pii setamili pyoo Goteme nyakama pii langita. Pii setami endakali dupa baame pii mendatupa apata konda pyoo langita. Dopana, nyakamame pii silyamino dupanya tenge dupa masokondape pyepape. ");
INSERT INTO enq2_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aipumape, longo lao singi endakali doko baa konda pyoo maita. Nasingi endakali doko-kisa kuki seta dutupa baa-kisa nasina lao tange nyokonyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dokopa baame lao pituu, “Gotenya kingdom doko akali mendeme yuunya ee wai lyandenge dopale. ");
INSERT INTO enq2_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Baame lyandatala, kuka luu palipa, yongama sakatata pingi. Dokopa ee wai doko tange langa latala andenge. Dopa pilyamopa, aipa petala langa lao andelyape lao baame nakandenge. ");
INSERT INTO enq2_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yuu dokome tange pilyamopa, ee wai doko dii mandenge. Wambao ee wai doko langa lenge. Langa latala yoko pingi. Yoko petala mange dokonya dii lyoo wambu pingi. ");
INSERT INTO enq2_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dii dupa wambu petelyamopa, wambu pingi gii doko ipatelyamona lao masetala, ee pokenge dokome konjuwame dii dupa lyao mandengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dokopa baame lao pituu, “Naimame Gotenya kingdom doko aipalena lama? Aki mendepa makande pima? ");
INSERT INTO enq2_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gotenya kingdom doko masete dii dopale. Yuunya ee wai dupa pitakanya masete dii doko etete yakane. Dopaka doko, endakali mendeme masete dii doko yuunya lyandelyamopa, ");
INSERT INTO enq2_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","andao yale jetala, ee wai pokatae waka dupa pitaka ita miningi. Dokonya wangya dupa andake mandelyamopa, lumba nelya dupanya yaka ketae paenge dupame anda pipenge jingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kongali dopale longo mendapuame wai pii epe doko endakali dupame sepengeli pyoo baame lamaiyoo katea. ");
INSERT INTO enq2_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Baame pii lamaiya dupanya mende mee lamaiya naeyao, kongaliaka lao lamaiya. Dopaka doko, baanya disaipolo dupa-pipa iki katao, kongali dupa pitakanya tenge dupa dokaita lamaita pia. ");
INSERT INTO enq2_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gii dokopa yuu kuiyala epeamopa, Jisasame baanya disaipolo dupa lamaiyoo, “Naima endaki pete omotena mua” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dokopa dupame endakali kambu doko yakinatala, Jisasa petea sipi dokonya baa lanyoo peami. Sipi yakane waka mendatupa apata baa-pipa peamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Peaminopa poo yale mende lao sakatea dokome, endaki buli pyapala, tandyoo sipi dokonya kolandea. Dopa piamopa sipi doko endakimi tumbalanya pia. ");
INSERT INTO enq2_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dokopa Jisasa baa sipi dokonya maita-kaita sanda setapae mendenya luu paleamopa, disaipolo dupame baa pyale tatala lamaiyoo, “Mana Lenge, naima kumalamane-lamo doko, embame naima nee nakaelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dopa leaminopa Jisasa sakatatala, poo doko kaena latala, endaki buli pia doko lamaiyoo, “Emba yatu laa! Ema napinya mee saa!” leamopa, poo doko yatu lao, endaki doko emapi mende napyoaka pia. ");
INSERT INTO enq2_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dokopa baame dokaita lamaiyoo, “Aipuma nyakama paka kaelyami? Aipa petala nyakama Gote tungi napilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dopa leamopa, disaipolo dupa etete paka kaeyapala nyakama-lapo laloo pyoo, “Endakipa, poopa dolapome apata baanya pii lapyali pilyambino doko, akali dake api laa-kanjemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dokopa endaki pete omotena, Gadara tange dupanya yuu dokonya Jisasa baanya disaipolo dupa-pipa peami. ");
INSERT INTO enq2_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pao pyakamatala, Jisasa baa sipi doko yakinalu piamopa, akali imambu koo paleta mende endakali malu katenge dupanya paliu ipao baa kandanyia. ");
INSERT INTO enq2_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Akali doko endakali malu katenge dupanya palenge. Endakali mendeme sene kendepi mendeme baa anjala naeyapenge. ");
INSERT INTO enq2_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Paa longosa baa sene kendepi, anengapupi dupame anjeta pilyaminopa, baame sene kende dupa minao pindanya nepatala, anengapu dupa pindao yakane-yakane pingi. Dopa pilyamopa, endakali mendeme kapa pao baa minao lambapenge nanjingi. ");
INSERT INTO enq2_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kuka kotakapi, koteaka lao baa yuu mandapi, endakali malupi dupanya ae latae katao, baanya yonge doko tange kaname konjeta pingi. ");
INSERT INTO enq2_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisasa kuki londatili joo kateamopa, akali dokome kandatala, alo pyao ipupala, baa katea dosa luma lakea. ");
INSERT INTO enq2_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Luma lakeamopa Jisasame imambu koo doko lamaiyoo, “Imambu koo, embame akali dake yakinatala puu” lea. Dopa leamopa baame puu lao, lao pituu, “Gote Etete Ketae Katenge dokonya Ikiningi Jisasa, embame namba aipa piti? Namba tanda andake nanditoo lao Gotenya kenge dokonya embame kyeto joo laa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dopa leamopa Jisasame baa tipa pyoo, “Embanya kenge doko api lengepe?” lea. Dopa leamopa akali dokome yanu pyao, “Naima imambu koo longo kalyamano. Tenge dokonya, nambanya kenge doko Amii Longo lengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dokopa imambu koo baa-kisa palea dupa yuu doko yakinatala pena laa naena lao akali dokome Jisasa kyeto joo tee lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yuu dokonya manda kilikili mendenya mena kambu andake mende imu nao kateami. ");
INSERT INTO enq2_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dokopa imambu koo dupa pitakame Jisasa kyeto joo tee lao, “Naima mena dupa-kisa kolandamana, landa pyalapa lapoko” leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dopa lalu piaminopa, Jisasame dokaita mena dupa-kisa landa pina lea. Dokopa imambu koo dupame akali doko yakinatala, mena dupa-kisa landa piami. Landa pyateaminopa, mena kambu doko papatale mendenya-kaita lanao alo pyao pupala, endaki pete dokonya mangatala kumiami. (Mena kumiami dupa, tausene lapomapi mende.) ");
INSERT INTO enq2_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dokopa mena setao kateami dupa siti dokonyapi, yuu yakanepi, dupanya paka pupala, pia doko endakali dupa lamaiyami. Lamaitiaminopa endakali dupame piamo doko kanja epeami. ");
INSERT INTO enq2_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dupa Jisasa katea dokonya ipupala kandeaminopa, Amii longo lenge imambu koo doko palenge akali doko indupa yonge pee petala, mona paliu peteamo kandatala paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pia doko wambao lengeme kandeami endakali dupame imambu koo palea akali dokopi, menapi dupa-kisa pia dupa dopa pyomona lao lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lamaitiaminopa yuu tange dupame Jisasa baa dokaitanya yuu doko yakinatala pena lao tee pyao kyeto joo leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dokopa, Jisasa baa sipi dokonya pyakalyiamopa, imambu koo palea akali dokome baa Jisasa-pipa katambana buape lao kyeto joo tee lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dopa leamopa Jisasame daa latala baa lamaiyoo, “Emba andaka pupala, Kamongome emba kondo kaeyapala, embanya pyakalamo dupa emba tata dupa lamaipi” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dopa lamaitiamopa akali doko pupala, Jisasame baanya pyakamaiya dupa yuu Dekapolisa dokonya tee pyao lao paneamopa, endakali dupa pitaka walu leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisasa baa sipi dokonya, endaki pete dokonya yangitena pilyetala, endaki lemba dokonya kateamopa, endakali longo mendapu ipao kambu piami. ");
INSERT INTO enq2_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dokopa lotuu anda isingi akali dupanya mende, Jairusa lenge doko epea. Ipao Jisasa kandatala, baanya moko katea dosa tombauli sepala ");
INSERT INTO enq2_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kyeto joo tee lao, “Nambanya wanenge koo doko kumalanya pilyamona, embame baa-kisa kingi setateno doko, baanya yaina doko etapatamopa baa lenge talapomona, kingi setala ipupoko” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dokopa Jisasa baa-pipa peambinopa, endakali kambu andake mende baa watao pupala, katao tambukiniami. ");
INSERT INTO enq2_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dokopa enda mende yuu gii dii lao andaka nao paliu, ee kana 12 pitaka petenge doko kambu dokonya katea. ");
INSERT INTO enq2_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Enda dokome dokosa longo-kisa baanya muni sia dupa pitaka nepeaka doko, baanya yaina doko etala naeyamopa, baa tanda longo nao petea. ");
INSERT INTO enq2_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Jisasame pilyamo lapae dupa enda dokome sepala, Jisasanya yonge peenya iki watandatopa, baanya yaina doko etalapomona lao masia. Dopa lao masetala, endakali kambu dokonya-kaita Jisasanya maita-kaita ipupala, Jisasanya yonge pee punanya kingimi watandea. ");
INSERT INTO enq2_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Watandalu piamopa baanya yaina doko etea. Dokopa enda dokome baanya yaina doko etalumu lao baanya yonge dokome sia. ");
INSERT INTO enq2_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sulu piamopa, Jisasame baanya kyeto mendatupa puumu lao sepala, endakali kambu kateami dotena kapilyetala lao pituu, “Apimi nambanya yonge peenya watandelyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dopa leamopa baanya disaipolo dupame baa lamaiyoo, “Endakali kambu dakeme emba katao tambukinilyamino kandelyeno doko, aipuma embame, ‘Apimi namba watandelyape?’ lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dopa leaminopa, apimi pyaape lao kanjanya, Jisasame kandayoko lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dopa piamopa, enda dokome baa-kisa pia doko masetala, paka kaeyao walu lao ipao, Jisasa katea dosa tombauli sepala, baa-kisa pia dupa pitaka lao panao kiningi pii doko Jisasa lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dokopa Jisasame baa lamaiyoo, “Wanenge, embame namba tungi pyapi dokome, embanya yaina doko etelyamona, emba yaina etapae doko mona yaepatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dopa lao kateamopa, lotuu anda isingi Jairusanya andaka katenge akali mendapu ipupala Jairusa lamaiyoo, “Embanya wanenge doko kumatalamona, aipuma embame Mana Lenge doko kenda pisoo epena lelyepe” leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dopa leaminopa Jisasame pii doko sulu petala, lotuu anda isingi akali doko lamaiyoo, “Emba paka nakaenya, namba tungi pyape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dopa latala, endakali waka mende baa watao naepena latala, Pitapi, Jemesapi, Jemesa kaiminingi Jonepi dutupa-pipa iki peami. ");
INSERT INTO enq2_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pao lotuu anda isingi akali dokonya andaka pyakamatala Jisasame kandeamopa, endakali dupa yako lao ee laa-laa peami. ");
INSERT INTO enq2_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dokopa Jisasa andaka kolandatala dokaita lamaiyoo, “Aipuma nyakama yako lao ee laa-laa pelyami? Wanaku doko kumala naeyalamo. Baa luu palelyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dopa leamopa, endakali dupame baa lamba lao gii kaeyami. Dokopa baame dokaita watao kamaka pyalyetala, wanaku dokonya endangi dokopi, takange dokopi, disaipolo tepoma apata peami dutupapi, dutupa iki wanaku kumapae sia dokonya lanyoo pea. ");
INSERT INTO enq2_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pupala wanaku dokonya kinginya minatala baa lamaiyoo, “Talita kum” lea. (Pii dokonya tenge doko, “Wanaku, emba nambame sakata lelyo.”) ");
INSERT INTO enq2_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dopa lalu piamopa, wanaku ee kana 12 latae doko sakatatala kaita paeya. Paeyamo doko kandatala, endakali kateami dutupa etete paka kaeyao walu leami. ");
INSERT INTO enq2_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pia doko endakali dupame setamina, mende lamaiya naena lao Jisasame kyeto joo dutupa pyalanya lea. Dopa latala wanaku doko nee nena nyoo maina lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisasa yuu doko yakinatala baanya yuu dokonya peamopa, baanya disaipolo dupame baa watao peami. ");
INSERT INTO enq2_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pupala Sambata gii doko epeamopa, baame lotuu anda dokonya mana lamaiya. Lamaiyamopa pii siami endakali longo dupa walu lao paka kaeyapala lao pituu, “Akali dakeme pilyamo datupanya kyeto doko anja-tae nyia? Masepae epe baa maiya-lamo doko aipale mende? Mirakolo dopale dupa baame aipa pyoo pingi? ");
INSERT INTO enq2_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Akali dake kapenda doko daape? Baa Maria ikiningi, Jemesapi, Josesapi, Judasapi, Saimonepi dutupanya kaiminingi daape? Baanya pimalenge dupa ae naima-pipa napilyamape?” leami. Dopa latala dupame baa maka kaeyapala maita maiyami. ");
INSERT INTO enq2_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dokopa Jisasame dokaita lamaiyoo, “Propeta mende yuu waka dupanya kalyamopa, endakali dupame baa anda-anda semaingima. Dopaka doko, baanya yuu dokonya kalyamopa, baa tatapi, palupi dupame baa anda-anda semaiya naengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dokopa yuu dokonya baame mirakolo mende pipenge nanjiamosa, endakali kuki mendatupa-kisa iki kingi setao yaina dupa mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yuu dokonya tange endakali dupame baa tungi pyala naeyaminosa, baa walu lao paka kaeya. Maitakao Jisasa baa yuu yakane dupanya paeyao, endakali dupa mana lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mana lamaitala, Jisasame 12 aposole dutupa epena latala, dutupame imambu koo dupa watao pina lao kyeto maitala, dutupa lapo-lapo lao tee pyao pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Pena lao pituu dapa lamaiya: “Nyakama kaita paanya, munipi mende matapunya manja naeyao mee pupape. Nokainapi, bretapi mende nyoo napupape. Yonge pee isa pingi lapo lao pyoo napupapeaka. Pangali iki minao moko pee pyoo pupape” lao kyeto joo lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dopa latala baame dutupa lamaiyoo, “Nyakama kolandatami anda dokonya iki katao, taono doko yakinatami gii dokonya tuu lapape. ");
INSERT INTO enq2_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yuu tange dupame nyakama auu kaeyao lanyala naeyao, nyakamanya pii doko nasoaka piami-kandeno doko, endakali taono dokonya tange dupa-kisa tenge sipya-lamo lao kandena, yuu doko yakinatala patami dokopa, nyakamanya mokonya yuu katata dupa lyanda lanya setapala pupape. Goteme endakali dupa yapatamo gii dokopa, Sodomopa, Gomorapa dolaponya tange dupa tanda andake maitaka doko, taono dokonya tange dupa tanda eteteaka andake maitana lao nambame nyakama kiningi langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dopa lateamopa dutupa pupala, endakali dupa mona kapilyina lao wai pii epe doko lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pii lamaiyoo pituu, imambu koo longo mendapu watao pyata, endakali yaina pyapae longo dupa weleme kai pyata pyakamaiyami. Dopa piaminopa yaina dupa mee jia. ");
INSERT INTO enq2_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisasanya kenge doko lao taeyaminopa, Kiŋi Eroteme sepala lao pituu, “Jone kaimbu pingi doko malunya sakatapya-lumu. Tenge dokonya, mirakolo pipenge kyeto dupa baa-kisa simupa kalai pyumuna” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yangi dupame “Baa Ilaija-lamona” leaminopa, yangimi “Baa propeta wamba kateami dopale mende-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dopa leaminopa Eroteme pii doko sepala lao pituu, “Baa Jone, nambame aiyomba kepao nepeo doko, malunya sakatapya-lumuna” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Wamba Eroteme baanya kaiminingi Pilipa etanenge Erodiasa doko nyia. Dopa piamosa Joneme Erote lamaiyoo, “Embanya kaimininginya etanenge embame nyilyino doko, loome daa latae singi doko yalelyenona” lao katea. Dopa lao kateamosa, Erodiasame Jone imbu kaeyapala pyao kumasotoo lao masia. Dopa lao masiaka doko, Eroteme Jone doko akali tolatae, Gotenya latae mende-lamo lao kandatala, baa paka kaeyapala, auu pyoo isoo katea dokonyana, Erodiasame Jone pyao kumasotoo lao masia doko kapa napea. Eroteme Jonenya pii dupa sepala kalai longo peta pia. Baanya pii dupa auu kaeyao sepa piaka. Dopa petala Eroteme Erodiasa auu kaeyapae nyina lao masetala, Jone minatala anjinya pyandala pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Gii mendepa Erotenya mandenge gii doko epeamopa, baanya kalai akali andakepi, amii isingi mupapi, Galali tange akali andakepi, dupanya nee andake mende yangakamaiya. Gii dokopa Erodiasame kandeamopa, Jone pyapenge kaitini mende sia. ");
INSERT INTO enq2_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dokopa nee nao peteami dokonya Erodiasa wanenge doko ipao kolandatala danisa lea. Dopa piamopa, Erotepi, baa-pipa nee nao peteamipi, dupame auu kaeyao kandeami. Kandatala kiŋi dokome wanaku doko lamaiyoo, “Embame dopale mende namba-kisa tee latenopa, lateli pyoo nambame emba dyaapo. ");
INSERT INTO enq2_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nambanya kingdom doko kapa lao konjepala, embame yangi dii lateno doko dyaapoakana” lao, baanya pii doko kyeto tasalanya Gotenya kenge doko lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dopa leamopa, wanaku doko kamaka pyakalyetala baanya endangi doko lamaiyoo, “Aki mende dina lao nambame tee laowape?” lea. Dopa leamopa endangimi lao pituu, “Jone kaimbu pingi dokonya aiyomba doko dina lape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dopa lalu piamopa, wanaku doko alo pyao kiŋi doko petea dokonya pupala lao pituu, “Jone kaimbu pingi dokonya aiyomba doko pelesa mendenya setapala epapuaka dyaale lao masilyona dii” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dopa leamopa kiŋi doko etete mona kenda kaeyaka doko, endakali apata nee nao peteami dupanya enombanya, baanya pii dupa kyeto tasalanya Gotenya kenge doko latala, wanaku doko maitoana lea doko masetala, baanya pii doko aloo napitoo lao masia. ");
INSERT INTO enq2_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kiŋi dokome dopa lao masulu petala, yanda singi mendeme Jonenya aiyomba doko nyoo minao ipalena pena leamopa, ");
INSERT INTO enq2_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","baa anjetae andaka dokonya pupala, Jonenya aiyomba doko kepao nyia. Dopa petala, Jonenya aiyomba doko pelesa mendenya setapala, nyoo ipao wanaku doko maiya. Maitiamopa wanaku dokome nyepala, baanya endangi doko maiya. ");
INSERT INTO enq2_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dopa pia doko Jonenya disaipolo dupame sepala dupa epeami. Ipupala baanya yonge doko nyoo malu piami. ");
INSERT INTO enq2_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisasanya aposole dupa Jisasa katea dokonya ipao kambu pyatala, dokaitame kalai piamipi, mana leamipi, dupa pitaka baa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dokopa endakali longo mendapu pao-ipao piami dokome, Jisasapi, baanya disaipolopi, dupa nee napenge gii nasia. Dopa piamosa Jisasame dokaita lamaiyoo, “Naima iki endakali napalenge yuu mendenya kuki koto nyemana mona ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dopa lateamopa, dokaita iki sipi mendenya pyakalyetala, endakali napalenge yuu mendenya peami. ");
INSERT INTO enq2_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Peamino doko endakali dupame kandatala, dupanya longome baa Jisasa-lamo lao masiami. Dopa lao masetala, endakali dupa taono dupa pitakanya katao, kaitini alo pyatala wambao pao, baa sipinya pituu isa pyakanalanya pia dosa kambu piami. ");
INSERT INTO enq2_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisasa sipinya pituu isa pyakanatala, endakali kambu andake doko kateamino kandea. Dokaita sipisipi setao katenge mende nakatenge joo kateaminosa, baame dokaita kondo kaeyapala mana longo mendapu lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lamaiyoo kateamopa niki landa pyalanya pia. Dokopa baanya disaipolo dupa baa katea dokonya ipupala baa lamaiyoo, “Endakali napalenge yuu dakenya indupa yuu kuiyalanya pimupa, ");
INSERT INTO enq2_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","endakali dakaitanya nee napenge mende nasilyamona, embame dakaita yuu yakanepi, taono yakanepi, makisa silyamo dupanya nyakama tange nee sambao nala pena laa” leami. ");
INSERT INTO enq2_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dopa leaminopa baame pii yanu pyakamaiyoo, “Nyakamame dakaita nee nena maiyepa” lea. Dokopa baanya disaipolo dupame baa lamaiyoo, “Naima pupala, silipa muni 200-tame breta sambapala, endakali dakaita nena lao maimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dopa leaminopa baame dupa lamaiyoo, “Breta akipate silyape lao kanja pupa” lea. Dupame pao kandatala lao pituu, “Naimanya breta yungi-pipa, pisa lapo-pipa silyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dopa leaminopa, Jisasame endakali dupa pitaka tanu sakapae dupanya wakale-wakale kambu pyao petena lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Leali pyoo, kambu mende 50 lao pitipa, 100 lao pitipa piami. ");
INSERT INTO enq2_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dokopa Jisasame breta yungi dutupapi, pisa lapo dolapopi, dutupa nyepala, kaiti-kisa kandalyetae katao yaka pilyino latala, breta dutupa konjepala, baanya disaipolo dupame mokosoo endakali dupa maina lao maiya. Dopa petala baame pisa dolapo endakali dupa pitakanya konjakamaiyaka. ");
INSERT INTO enq2_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dopa peteamopa dokaita pitakame nao tiaka kaeyapala, ");
INSERT INTO enq2_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","breta pisapi konjepae kakana sia dupa disaipolo dupame nyoo baseketa 12 tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Breta neami akali dupa tausene yungimi neami. ");
INSERT INTO enq2_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nee nalu petala, Jisasame baanya disaipolo dupa sipi dokonya pyakalyetala endaki pete omotena, taono Betsaida dokonya wambao pena lea. Dopa latala, baame endakali kambu doko andaka pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Endakali dokaita pena lao yakinatala, baa loma sala lalyoo yuu manda mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yuu kuiyala peamopa, Jisasa baa iki yuu manda dokonya kateamopa, disaipolo dupa sipi dokonya pituu endaki pete dokonya kainanya peami. ");
INSERT INTO enq2_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dokopa poo yale mende laeyao lao epeamopa, dokaitame lekeleke tao endaki tandyoo peaminopa, Jisasame kandea. Kandatala yuu yongao pukuiyamopa, baa endaki pete ketae dokonya moko katao pupala, dokaita nyoo maita pyatoo lao masia. ");
INSERT INTO enq2_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Baa endaki pete dokonya moko katao epeamo kandatala, disaipolo dupa pitakame baa timango mende-lamo lao masetala, etete paka kaeyao ae leami. Dopa lalu piaminopa baame dokaita lamaiyoo, “Namba epelyona, nyakama mona paka nakaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dopa latala baa sipi dokonya pyakalyiamopa, poo doko yatu lea. Yatu leamo kandatala disaipolo dupa etete walu lao pakame kumiami. ");
INSERT INTO enq2_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dokaitanya mona kana jiami dokome, bretame mirakolo pia dokonya tenge doko masala naeyami. ");
INSERT INTO enq2_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dokaita endaki pete dokonya omotena, yuu Genesarete dokonya pao pyakamatala, sipi doko minanya seteami. ");
INSERT INTO enq2_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sipi dokonya pituu pyakaneaminopa, endakali dupame baa Jisasa-lamo lao yapa kandeami. ");
INSERT INTO enq2_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Endakali dupa pitaka alo pyao yuu dosa singi dupa pitakanya pupala, yaina pyapae dupa lapa tokonya soo baa kalyamo lapae siami yuu dokonya pata piami. ");
INSERT INTO enq2_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Taono yakanepi, sitipi, yuu yakanepi dupanya baa peali pyoo, yaina pyapae dupa lapa tokonya soo pupala, maketa kamapu dupanya setapa piami. Dopa petala, yaina pyapae dupame baanya yonge pee punanya iki watandena lao, yaina pyapae soo epeami endakali dupame kyeto joo tee leami. Dokopa Jisasa watandeami endakali dupa pitakanya yaina dupa mee jeta pia. ");
INSERT INTO enq2_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Parasipi, Juu pitakapi dupame nyakamanya yumbangenya mana setapae dupa wata-minao, nee nalanya kingi auu pyoo wasa pyakondape petala nee nengema. Dupame maketanya katao ipupala mee nee nala naenya, kingi wasa pyatalaka nee nengema. Mana singili pyoo, kapopi, sisopene pengepi, penge kopame wasepaepi, pituu nee nenge tokopi, dupa wasa pingimaka. Dee yumbangenya mana setapae waka longo mendapu miningimaka. Dopa pingima Parasipi, Mosesanya loo mana nyepae mendapu Jerusalema katao epeamipi, dupa Jisasa katea dokonya ipao kambu piami. Dokopa baanya disaipolo yangimi kingi wasa napyao, kingi kaimala pipaeme nee nyoo neaminosa, akali dupame kandatala kopeta pilyaminona leami. ");
INSERT INTO enq2_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dopa latala Parasipi, Mosesanya loo mana nyepaepi, dupame Jisasa tipa pyoo, “Embanya disaipolo dupa kingi wasa napinya mee nee nelyamino doko, aipuma yumbangenya mana setapae dupa wata-minala naelyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nyakama mana tolatae miningi manemane pingima dupa-pipa makande pyokondape pyoo Aisaiyame dapa lea: ‘Akali tata dakeme pii lelyamino dupame namba anda-anda singingima. Dopaka doko, dokaitanya mona dupa etete waka palengema. Endakalinya mana setapae dupa mana lelyamino dokome, dokaitame namba kiningi mambo pyala naengemana’ lao pepa pyapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nyakamame Gotenya mana setapae dupa nepatala, nyakamanya lotuu mana wambatae dupa wata-minao, kapopi, sisopene pengepi dupa wasa pingima. Dopa pyoo katao, nyakamame mana dopaleaka longo mendapu miningimana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dopa latala baame dokaita lamaiyoo, “Nyakamanya mana wambatae dupa wata-minamana latala, Gotenya mana setapae dupa nyakamame waa katao daa latala nepelyamino. ");
INSERT INTO enq2_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesame lao pituu, ‘Embanya endangipa takangepa dolapo anda-anda semaiyoo katape’ lea. Goteme pii mende apata lao pituu, ‘Endakali mendeme baanya endangi takangepi mende pii koo latamo doko, baa pyao kumasepengena’ lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","13","Dopa leaka doko nyakamame lao pituu, ‘Endakali mendeme baanya endangi takangepi mende lamaiyoo, “Nambame emba oapi dipenge dupa pitaka Gote maipengena latae silyamona” latamo doko yakana’ lengema. Dopa lelyamino dokome, baanya endangi takangepa dolapo nisepae mende namaina lao nyakamame daa lengema. Nyakamanya mana wambatae dupa wata-minamana latala, Gotenya pii doko mee joo nepengema. Dopa pyoo katao, nyakamame mana dopaleaka longo mendapu miningimana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dopa latala Jisasame endakali kambu doko pitaka baa katea dosa epena latala lamaiyoo, “Nambame pii lelyo dake sepala, nyakama pitakame masokondape pyepape: ");
INSERT INTO enq2_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kamaka singi mende endakali mende-kisa kolandelya dokome baa kaimala pisala naenge. Endakali mende-kisa koko palelya dupa kamaka pyakalyilya dokome baa kaimala pisingi. ");
INSERT INTO enq2_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Endakali mende kale katenge-tamo doko, nambame pii lelyo dutupa baame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Endakali kambu doko yakinatala Jisasa andaka pao peteamopa, baanya disaipolo dupame kongali lea dokonya tipa piami. ");
INSERT INTO enq2_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Tipa piaminopa baame dokaita lamaiyoo, “Nyakamame apata masala naelyamipi? Kamaka singi mende endakali mende-kisa kolandelya doko mona andaka napenya, inginya soo kamaka epenge. Dopa pilya dokome nee dupa pitaka auu pisilyamopa, endakali doko kaimala pisala naenge doko nyakamame masala naelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","Dopa latala baame lao pituu, “Endakali mendenya monanya palenge doko kamaka pyakalyingi dokome baa kaimala pisingi. Masingi koopi, kepo kolengepi, endapi akalipi nyelenyele paengepi, endakali pyao kumasingipi, ");
INSERT INTO enq2_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pake nengepi, popaita pingipi, koo pingipi, minakasingipi, yongenya pyoani kaenge mana koeyapae dupa miningipi, waka mendenya oapi seta dupa kandatala nyipu laka lao masingipi, lao nepengepi, alyasale joo kalyona lao masingipi, kyakaenge mana miningipi, ");
INSERT INTO enq2_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","koo dutupa pitaka monanya paliu kamaka pyakalyilya dokome endakali dupa kaimala pisingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisasa baa sakatatala, yuu doko yakinao Taeyapa, Saidonepa dolaponya yuu sia dupanya pea. Pupala baa anda mendenya kolandatala, elyakalao pititoo lao masiaka doko, baa yalo pipenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dokopa imambu koo paleta wanaku koo mendenya endangi dokome Jisasa anda dokonya pilyamo lapae sepala, anda dokonya pao kolandatala, Jisasanya moko setea dosa ipao luma lakea. ");
INSERT INTO enq2_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","(Enda doko baa Giriki pii lenge, Siropinisia tange mende.) Baanya wanenge doko-kisa imambu koo palenge doko Jisasame watao pyakamaina lao tee lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dopa leamopa Jisasame enda doko lamaiyoo, “Wanenya nee dupa nyepala, pyale lao yana dupa maitamopa auu napita. Dopana, wambao wanenya nee dupa tange nao tiaka kaena maipengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dopa leamopa enda dokome yanu pyao, “Akali Andake, doko kiningiaka lelyeno doko, wane dupame nee nelyaminopa, kuku kakanapi isa pelya dupa yana toko pundipundi kalyami dupame nyoo nengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dokopa Jisasame enda doko lamaiyoo, “Embame dopa lelyeno dokonya, imambu koo dokome embanya wanenge doko yakinatala patelyamona, emba andaka puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dokopa enda doko andaka pupala kandeamopa, imambu koo dokome baanya wanenge doko yakinatala pateamopa, baa tokonya paliu sia. ");
INSERT INTO enq2_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taeyapa, Saidonepa dolaponya yuu sia dupa yakinatala, Jisasa baa yuu Dekapolisa dokonya pyakamatala, Galali pete dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dokopa endakali mendapuame akali kaleketa muumaa mende laminao baa katea dokonya ipupala, akali doko-kisa kingi setena lao kyeto joo Jisasa tee leami. ");
INSERT INTO enq2_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dopa leaminopa endakali kambu doko yakinatala, Jisasame akali doko iki laminao umbisale pupala, baanya kingi konde dolapo akali dokonya kalekaita pyandea. Dopa petala Jisasame baanya kingi kondenya sopokali talyinya pisetala, muumaa dokonya kekenya watandea. ");
INSERT INTO enq2_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dopa petala akali doko kondo kaeyao, kaiti-kisa kandalyetae katao baa lamaiyoo, “Epataa” lea. (Pii dokonya tenge doko, “Lumba.”) ");
INSERT INTO enq2_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dopa lalu piamopa, akali dokonya kalekaita dolapo lumbapa, keke doko tolata piamopa, baa pii tolao lea. ");
INSERT INTO enq2_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dopa pia doko endakali kambu dokome endakali mende lamaiya naena lao Jisasame kyeto joo daa lea. Dopa leaka doko, dupame etete eteke pyao lao taeyami. ");
INSERT INTO enq2_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dokopa siamipi, kandeamipi endakali dupa eteteaka paka kaeyao walu latala lao pituu, “Baame kalai dupa pitaka auu pyoo pilyamo. Kaleketa dupame pii sina lata, muumaa dupame pii lena lata pilyamoakana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gii dosa mendasa endakali kambu andake mende kateami dokaitanya nee napenge mende nasia. Dopa piamosa, Jisasame baanya disaipolo dupa epena latala lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Endakali kambu dake yuu gii tepoma namba-pipa katamanopa, nee napenge nasilyamo dokonya, nambame dakaita kondo kaelyo. ");
INSERT INTO enq2_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yangi dupa yuu londati katao ipumina, nee nanao andaka pena lato doko, kaitinisa laowambe lapae setamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dopa leamopa baanya disaipolo dupame pii yanu pyakamaiyoo, “Endakali napalenge yuu dakenya naimame breta anja-tae nyepala, endakali dakaita nao tiaka kaena maimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dokopa baame disaipolo dupa tipa pyoo, “Nyakamanya breta akipate silyape?” lea. Dopa leamopa dokaitame lao pituu, “Kalange silyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dopa leaminopa, baame endakali kambu doko isa petena lea. Dopa latala, breta kalange dutupa nyepala, Gote yaka pilyino latala konjia. Konjepala baanya disaipolo dupame endakali dupa mokosoo maina lao maiya. Dokopa baanya disaipolo dupame endakali kambu doko mokosoo maiyami. ");
INSERT INTO enq2_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dokaitanya pisa yakane kuki mendatupa apata siaka. Jisasame Gote yaka pilyino latala dutupa apata mokosoo maina lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Maiyaminopa, endakali dokaitame nao tiaka kaeteaminopa, konjepae kakana sina kaeyami dupa disaipolo dupame nyoo baseketa kalange tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Akali nee neami dupa tausene kitomendepi mendeme neami. Napeaminopa Jisasame dokaita pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Endakali dokaita pena lalu petala, baanya disaipolo dupa-pipa sipi mendenya pyakalyetala, yuu Dalamanuta dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dokopa Parasi dupa ipupala, Jisasa-pipa tee pyao pii yanda piami. Dupame baa makande pyoo, kaiti-kisa-tae mirakolo mende kandamana pina leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dopa leaminopa Jisasa mona kenda kaeyapala lao pituu, “Aipuma endakali indupa palelyamino dupame mirakolo mende kandamana nambame pii lelyami? Nambame nyakama kiningi langilyo: Mirakolo mende nakanjaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dopa latala baame dokaita yakinatala, disaipolo dupa-pipa sipinya pyakalyetala, endaki pete dokonya omotena peami. ");
INSERT INTO enq2_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Disaipolo dupame breta nyoo napenya, kame sepala ipateaminopa, sipi dokonya breta mendai iki sia. ");
INSERT INTO enq2_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dokopa Jisasame dokaita kyeto joo lamaiyoo, “Parasipi, Erotepi dupanya yisa dupame nyakama koeyasetamina, kandao kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dopa leamopa nyakama-lapo laloo pyoo, “Naimanya breta nasilyamo dokonya lelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dopa leamino doko Jisasame kandatala dokaita lamaiyoo, “Nyakamame aipuma breta nasilyamo lao nyakama-lapo lelyami? Nyakama-kisa indupapi tatake pipae simupa masala naelyamipi? Nyakamanya mona kana jetaeyaka kalyape? ");
INSERT INTO enq2_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyakamanya lenge telyamo dokome angi kanja naelyamipi? Nyakamanya kale kalyamo dokome angi nasilyamipi? Nyakamame kame silyamipi? ");
INSERT INTO enq2_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nambame breta yungi dutupa akali tausene yungi dupanya konjakamaiyopa, nao kakana sina kaeyamino dupa nyakamame nyoo baseketa akipatenya tumbasiamipi?” lea. Dopa leamopa dokaitame baa lamaiyoo, “12 baseketanyana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dokopa Jisasame lao pituu, “Nambame breta kalange dutupa akali tausene kitomende dupanya konjakamaiyopa, nao kakana sina kaeyamino dupa nyakamame nyoo baseketa akipatenya tumbasiamipi?” lea. Dopa leamopa dokaitame lao pituu, “Baseketa kalangenyana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dopa leaminopa baame dokaita lamaiyoo, “Nyakamame aipa petala masala naelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Dokopa Jisasa taono Betsaida dokonya pea. Pupala kateamopa, endakali dupame akali lenge monda mende laminao Jisasa katea dokonya ipupala, Jisasame watandena lao kyeto joo tee leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dopa leaminopa, Jisasame lenge monda doko kinginya minatae katao, yuu yakane doko yakinatala peambi. Pupala Jisasame sopokali talyinya akali dokonya lenge dolaponya pisetala, akali doko-kisa baanya kingi setea. Dopa petala, akali dokome mende kandelyepe lao Jisasame baa tipa pia. ");
INSERT INTO enq2_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dokopa baame kandalyetala lao pituu, “Nambame endakali dupa kandapupa, ita jepae mendapu kaita paele pilyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dopa lateamopa, Jisasame akali dokonya lenge dolaponya baanya kingi setapala kandalyina lea. Dokopa, baanya lenge dolapo auu peteamopa, baame dupa pitaka auu pyoo kandea. ");
INSERT INTO enq2_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dopa piamopa Jisasame akali doko andaka pena latala lao pituu, “Emba taono yakane dokonya paa naeyape. Pyomo doko taono yakane dokonya tange endakali mende lamaiya naeyapeaka” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisasa baanya disaipolo dupa-pipa Sisaria Pilipae dokonya yuu yakane makisa singi dupanya peami. Pao pituu, kaitinisa Jisasame baanya disaipolo dupa tipa pyoo, “Endakali dupame namba apina lelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dokopa dokaitame pii yanu pyao, “Yangimi emba Jone kaimbu pingi dokona lelyamino. Yangimi emba Ilaijana lelyamino. Yangimi emba propeta wamba kateami dupanya mendena lelyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dopa leaminopa baame dokaita lamaiyoo, “Endakali dupame dopa lalumino doko, nyakamame namba apina lelyamipi?” lea. Dopa leamopa Pitame baanya pii yanu pyakamaiyoo, “Emba Kraisa dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dopa lateamopa, baa akali dokona lao endakali mende lamaiya naena lao kyeto joo daa lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dokopa Jisasame dokaita tee pyao mana lamaiyoo, “Akalinya Ikiningi doko tanda longo napenge. Juumanya isingi akalipi, prisa mupapi, Mosesanya loo mana nyepaepi dupame baa maita maitaminopa baa pyao kumasepenge. Kumasetataminopa yuu gii tepo dokonya baa sakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisasame pii dutupa lao paneamopa, Pitame baa laminao umbisale pupala, tee pyao pyalanya lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dopa leamopa Jisasa kapilyetala, baanya disaipolo dupa kandatala, Pita pyalanya lao, “Satane, embame Gotenya masingili pyoo nalenya, endakalinya masingili pyoo lelyenona, embame namba yakinatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dopa latala baame endakali kambu dokopi, baanya disaipolopi, dupa epena latala lamaiyoo, “Endakali mendeme namba watao ipatoo lao maseta dokome baa tange kame sepala, baanya poko ita doko tange nyoo soo namba watao ipupenge. ");
INSERT INTO enq2_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Endakali mendeme baa lete katatoana lao masetala, baa tange pyoo nyalanya pitamo dokome baanya lete katenge doko yakinata. Dopaka doko, endakali mendeme nambapa, wai pii epe dokopa, dolapo masetala, baanya lete katenge doko yakinata dokome baanya lete katenge doko pyoo nyeta. ");
INSERT INTO enq2_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Endakali mendeme yuunya oapi dupa pitaka nyoo setao katapala, baanya lete katenge doko yakinatamo doko, oapi dupame baa aipa petala niseta? ");
INSERT INTO enq2_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Baanya lete katenge doko aki mendeme tange sambao nyeta? ");
INSERT INTO enq2_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Endakali mendeme Gote yakinatala koo pyoo kalyamino dupanya kainanya katapala, nambapa, nambanya pii dokopa, dolapo lao panalanya elya kaeyatamo doko, Akalinya Ikiningi doko enjele Gotenya latae dupa-pipa, Takange dokonya tii pipae andake dokonya pituu ipatamo gii dokopa, Akalinya Ikiningi dokome endakali doko kandatala baa elya kaeyatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Dopa latala Jisasame dokaita lamaiyoo, “Nambame nyakama kiningi langilyo: Endakali asa kalyamino dapuanya mendapu kumala naeyataminopa, Gotenya kingdom doko kyeto doko-pipa panao ipatamopa kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yuu gii tokange pateamopa, Jisasame Pitapi, Jemesapi, Jonepi dutupa iki laminao, yuu manda ketae mendenya lalyoo pea. Pupala dokonya kateaminopa, dutupanya enombanya Jisasa baa waka jia. ");
INSERT INTO enq2_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Baanya yonge pee dupa etete kyeo lao polepole pia. Baanya yonge pee kyeo lea dopa pyoo, isa yuu dakenya endakali mendeme dopale mende kyeo lena lao wasa napingi. ");
INSERT INTO enq2_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dokopa Ilaijapa, Mosesapa dolapo Jisasa-pipa pii lao kalyu piambinopa kandeami. ");
INSERT INTO enq2_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kandatala Pitame Jisasa lamaiyoo, “Mana Lenge, naima dakenya katamanopa auu pilyamona, naimame sele anda tepoma pimana. Mende embanya, mende Mosesanya, mende Ilaijanyana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Dutupa etete paka kaeyapala, Pitame aipa laowape lao masala naeyao lea.) ");
INSERT INTO enq2_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dokopa kopa mende ipupala dutupa sanga pia. Dopa piamopa pii mende kopa tambetambe epea dokome lao pituu, “Dake nambanya Ikiningi mona setenge dokona, nyakamame baanya pii doko sakamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dopa lalu piamopa disaipolo tepoma dutupame kandayoko leaminopa, endakali waka mende nakatea. Jisasa baa iki kateamo kandeami. ");
INSERT INTO enq2_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yuu manda doko yakinatala lanao ipao pituu, nyakamame kanjamino doko, Akalinya Ikiningi doko kumapala sakatatatamopa, endakali dupa lamaitamina, indupa endakali mende lamaiya naena lao, Jisasame kyeto joo daa lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baame pii lea doko dutupa-kisa sina kaeyapala, kumapala sakatapengena lamo dokonya tenge doko aipa pyoo laape lao dutupa yango-lapo leami. ");
INSERT INTO enq2_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dokopa dutupame baa tipa pyoo, “Mosesanya loo mana nyepae dupame aipuma Ilaija wambao ipupengena lengemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dopa leaminopa baame dutupanya pii yanu pyakamaiyoo, “Kiningi, Ilaija wambao ipupenge. Ipupala baame dupa pitaka tolaseta. Dopa pitana, aipuma Akalinya Ikiningi doko maka kaeyapala, tanda longo maitamina lao pepa pyapae silya? ");
INSERT INTO enq2_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ilaija ipateana lao nambame nyakama langilyo. Pii pepa pyapae singili pyoo, baa ipupala kateamopa, endakali dupame masiaminoli pyoo baa tanda maiyamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Disaipolo yangi dupa kateami dokonya Jisasa ipupala kandeamopa, endakali kambu andake mendeme disaipolo dupa katao kakopeaminopa, Mosesanya loo mana nyepae mendapu katapala, disaipolo dupa-pipa pii yanda pyoo kateami. ");
INSERT INTO enq2_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Endakali kambu pyao kateami dupa pitakame Jisasa kanju petala walu leami. Dopa petala dokaita alo pyao pupala baa mambo pyao lanyiami. ");
INSERT INTO enq2_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dokopa Jisasame Mosesanya loo mana nyepae dupa tipa pyoo, “Nyakama aki mendenya pii longo lelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kambu dokonya katao endakali mendeme yanu pyao, “Mana Lenge, nambanya wane doko imambu koo mendeme muumaa jisingi. Tenge dokonya, emba katapi dakenya nambame baa laminao epo. ");
INSERT INTO enq2_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Imambu koo dokome baa minao lungu pilyamoli pyoo baa lombapae singi. Dopa pilyamopa, wane doko nenge-kaita kambapupaka mandyoo, nenge giti-gato lao, kingi mokopi tinokao tui lenge. Embanya disaipolo dupame imambu koo doko watao pyakamaina lao nambame lamaipupa, dupame kapa pao watao pyala naeyalaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Nyakama Gote tungi napingima dupa, namba nyakama-pipa katao pao gii andukupa yakinato? Nyakama nongo pilyamino doko andukupa tolataminopa lao nambame malisoo katao? Wane doko laminao asa ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dokopa wane doko laminao Jisasa katea dokonya epeaminopa, imambu koo dokome Jisasa kanju petala, wane doko walumane minao isa yuunya lombanya seteamopa, kapilya mina-mina pyoo nenge-kaita kambapupaka mandea. ");
INSERT INTO enq2_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dokopa Jisasame takange doko tipa pyoo, “Wane dake gii andukupa tee pyao dopa piape?” lea. Dopa leamopa baame yanu pyao, “Koosa tee pyao dopa pia. ");
INSERT INTO enq2_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Paa longosa imambu koo dokome baa soo itatenya yangata, endakinya soo pyandata pyoo kumasalanya pingina, embame dopale mende kapa pao piti-tamo doko, nalimba kondo kaeyao nisepoko” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dopa leamopa Jisasame baa lamaiyoo, “Embame kapa pao Gote tungi pyate-tamo doko, nambame nyakamba nisotoo. Gote tungi pingi endakali dokome kalai dupa pitaka kapa pao pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dopa lalu piamopa, wane dokonya takange dokome puu lao ee lao, “Kamongo, nambame Gote tungi pilyona, nambanya Gote tungi napingi mana doko yakinatoo nisepe” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dokopa endakali kambu mende yapa ipao Jisasa katao kakopeamino kandatala, baame imambu koo doko pyalanya lao, “Emba muumaa kaleketa jisingi imambu koo dokome wane dake yakinatala puu lelyona, emba baa-kisa dee naipupi” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dopa leamopa imambu koo dokome puu lao ae latala, wane doko minao etete walu lasetala, baa yakinatala pea. Dokopa wane doko kumapae joo siamopa, endakali longome lao pituu, “Baa kumatelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dokopa Jisasame wane dokonya kinginya minatala toeya katasiamopa, wane doko sakatao toeya katea. ");
INSERT INTO enq2_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dopa peteamopa, Jisasapi, baanya disaipolopi, dupa andaka peami. Dokopa baanya disaipolo dupame elyakalao baa tipa pyoo, “Aipuma naimame imambu koo doko kapa pao watao pyala naeyalamape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dopa leaminopa baame dokaita lamaiyoo, “Loma soo nee nanao katenge mana dokonya-kaita iki imambu koo dopale dupa watao pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisasa disaipolo dupa-pipa yuu doko yakinatala Galali-kaita peami. Peami doko endakali mendeme nakandena lao Jisasame masia. ");
INSERT INTO enq2_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tenge doko, Jisasame baanya disaipolo dupa mana lamaiyanya dopa lao masia. Baame lao pituu, “Akalinya Ikiningi doko akali dupanya kinginya maiyanya pilyamo. Maitatamopa dupame baa pyao kumasetami. Kumasetataminopa baa yuu gii tepo dokonya malunya sakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pii dokonya tenge doko disaipolo dupame nyala naeyapala, Jisasa tipa pyaanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jisasa Kapename pupala andaka pituu, baanya disaipolo dupa tipa pyoo, “Nyakamame kaitinisa aki mendenya lao, lao ipamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dopa leamopa, dokaitame nyakamanya api alyasale joo kalyape lao, nyakama-lapo kaitinisa pii yanda pyoo epeami dokonya ema napiami. ");
INSERT INTO enq2_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dokopa Jisasa isa pitipala, 12 disaipolo dutupa tengesale epena latala lamaiyoo, “Endakali mende enomba nyoo katapuli lao masetamo doko, baa maita-kaita katapala, endakali pitakanya kalai akali katapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dopa latala baame wane koo mende lanyepala, dutupanya kainanya katasia. Dopa petala baame wane doko kopinyetala dutupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Endakali mendeme nambanya kenge dokonya wane koo dapale mende auu kaeyao lanyilya dokome, namba lanyilyamosaka pingi. Endakali mendeme namba auu kaeyao lanyilya dokome namba iki lanyala naenge. Namba puu lea Akali doko lanyilyamosaka pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joneme Jisasa lamaiyoo, “Mana Lenge, embanya kenge dokonya akali naima-pipa napaenge mendeme imambu koo dupa watao pyamupa naimame kandatala, baa naima-pipa napaenge dokonyana kaena lamuana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dopa leamopa Jisasame baa lamaiyoo, “Nyakamame baa kaena nalalapape. Endakali mendeme nambanya kengenya kalai kyeto mende pita dokome, namba lao yapa pii koo nalata. ");
INSERT INTO enq2_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nyakama yanda pingyala naenge endakali dokome nyakama nisingi. ");
INSERT INTO enq2_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nyakama Kraisa tata-lamona latala, endakali mendeme nambanya kengenya kapo mendenya endaki kamuu nyakama dita dokonya yole doko alu napyoo, sulu setana lao nambame nyakama kiningi langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Namba tungi pingima wane koo dupanya mende endakali mendeme koo pina lao mapusetamo doko, wita dii indyepenge kana yale mende baanya mangenya kende katatala, solowata lumu mendasa soo pyandamili doko yaka jipyali. ");
INSERT INTO enq2_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Embanya kingi mendeme emba koo pyaale lao mapusia-kandeno doko, kepanya nepape. Emba kingi tundu katao, lete katenge dokonya kolandateno doko auu pita. Emba kingi lapota katao, itate konjala naenge, ele panda koo dokonya pateno doko auu napita. ");
INSERT INTO enq2_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ele panda koo dokonya, endakali dupanya yonge dupa nenge nene dupa kumala naenge. Itate tenge doko konjala naengeaka. ");
INSERT INTO enq2_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Embanya moko mendeme emba koo pyaale lao mapusia-kandeno doko, kepanya nepape. Emba moko tundu katao, lete katenge dokonya kolandateno doko auu pita. Emba moko lapota katao, itate konjala naenge, ele panda koo dokonya soo pyandatamo doko auu napita. ");
INSERT INTO enq2_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ele panda koo dokonya, endakali dupanya yonge dupa nenge nene dupa kumala naenge. Itate tenge doko konjala naengeaka. ");
INSERT INTO enq2_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Embanya lenge mendeme emba koo pyaale lao mapusia-kandeno doko, lukunya nepape. Emba lenge mendai iki tao, Gotenya kingdom dokonya kolandateno doko auu pita. Emba lenge lapota tao, itate tao katenge, ele panda koo dokonya soo pyandatamo doko auu napita. ");
INSERT INTO enq2_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ele panda koo dokonya, endakali dupanya yonge dupa nenge nene dupa kumala naenge. Itate tenge doko konjala naengeaka. ");
INSERT INTO enq2_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Soleme opaa dupa kuni nasina lao pyoo wasingili pyoo, itateme endakali dupa pitaka pyoo waseta. ");
INSERT INTO enq2_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sole doko epe. Dopaka doko, sole dokonya tende patamo doko, nyakamame aipa petala dee tende pisetami? Nyakama sole katatae joo katao, nyakama-lapo mona setao kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisasa baa yuu doko yakinatala, endaki Jodane yangitena-kaita pupala, Judia pyakamea. Dokopa endakali kambu mendapu baa katea dokonya deaka ipao kambu piami. Dopa piaminopa, baame mana lamaingiliaka pyoo, endakali dupa deaka mana lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lamaiyamopa Parasi mendapu baa katea dokonya ipupala baa makande pyaanya tipa pyoo, “Akali mendeme baanya enda doko yakinatamo doko, loome daa latae singi doko yalatape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nyakamame aipa pipengena lao Mosesame mana seteape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dokopa dokaitame lao pituu, “Akali mendeme baanya enda doko yakinalanya, enda yakinenge pepa mende pyao maitala yakinatamo doko yakana lao Mosesame mana setea-pyaana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nyakama tuu pyoo mona kana jiaminosa, Mosesame mana doko pepa pyanya setea. ");
INSERT INTO enq2_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dopaka doko, Goteme tee pyao dupa pitaka pyoo injetala, enda akalipa lao wasia. ");
INSERT INTO enq2_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tenge dokonya, akalimi baanya endangi takangepa dolapo yakinatala, baanya etanenge dokopa tole pyao pititambinopa, ");
INSERT INTO enq2_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","dolapo yonge mendai jeta. Enda akalipa lao pilyambi gii dokonya pituu dolapo lapo joo napetenya, yonge mendai joo petengemba. ");
INSERT INTO enq2_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Goteme nyoo pyasetae doko endakali mendeme wakale pyaloo napipengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dopa lateamopa, baanya disaipolo dupa andaka pupala, pii dokonya dee Jisasa tipa piami. ");
INSERT INTO enq2_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dokopa baame dokaita lamaiyoo, “Akali mendeme baanya enda doko yakinatala, enda waka mende nyilya dokome, baa kepo kolenge. ");
INSERT INTO enq2_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dopaka pyoo, enda mendeme baanya akalingi doko yakinatala, akali waka mendenya pelya dokome, baa kepoaka kolengena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jisasame wane wanakupi koo dupa watandena lao, endakali mendapuame baa katea dokonya laminao epeaminopa, disaipolo dupame endakali dupa pyalanya leami. ");
INSERT INTO enq2_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dokopa Jisasame kandatala dokaita imbu kaeyao lamaiyoo, “Gotenya kingdom doko wane wanakupi koo dapale dupanyana, dokaita epekena kaita lyokala naeyalapa. ");
INSERT INTO enq2_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nambame nyakama kiningi langilyo: Gotenya kingdom doko wane wanakupi koo mendeme nyingili pyoo, endakali mendeme nanyetamo doko, baa Gotenya kingdom dokonya kolandala naeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dopa latala baame wane wanakupi koo dupa kopinyetala, dupa-kisa kingi setao auu pisia. ");
INSERT INTO enq2_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dopa petala Jisasa paanya kaita nyiamopa, akali mende alo pyao ipao, baanya enomba dokonya luma lakapala baa tipa pyoo, “Mana Lenge Epe, lete etete katenge doko nambame aipa petala nyotope?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dokopa Jisasame baa lamaiyoo, “Aipuma embame namba epe lelye? Endakali mende epe daa. Gote iki baa epe. ");
INSERT INTO enq2_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mana setapae dupa embame masilyino: Kepo kolala naeyape. Endakali pyao kumasala naeyape. Pake nala naeyape. Endakali mende sambo lao kotimi laa naeyape. Endakali mendenya dopale mende sambo lao tolao nyakamaiya naeyape. Embanya endangi takangepa dolapo anda-anda semaiyoo katape lapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dokopa akali dokome baanya pii yanu pyakamaiyoo, “Mana Lenge, namba wane kolesa pituu, mana setapae dutupa pitaka nambame wata-minio dopaka pyoo wata-minao kalyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dopa leamopa, Jisasame akali doko kondo kaeyao kandatala baa lamaiyoo, “Emba mendai mende daa jilyamona, emba pupala, embanya oapi dupa pitaka salimi latala, endakali daa jepae dupa maipi. Maitinopa oapi epe dupa embanya kaiti-kisa sakata. Dopana, embanya poko ita doko nyoo soo namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dopa leamopa, baanya oapi etete longo singi dokonyana, mona kenda kaeyao enomba kumatala, Jisasa yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dokopa Jisasame kandayoko latala disaipolo dupa lamaiyoo, “Muni longo singi endakali dupa Gotenya kingdom dokonya kolandalanya etete lekeleke tatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pii dupa disaipolo dupame sepala, paka kaeyao walu leami. Dokopa Jisasame dokaita dee lamaiyoo, “Wane paluma, muni tungi pingima endakali dupa Gotenya kingdom dokonya kolandalanya etete lekeleke tatami. ");
INSERT INTO enq2_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamele mendeme kepo tii mendenya lekeleke tao kolandapyaliaka doko, yuunya kamongo mendeme Gotenya kingdom dokonya kolandalanya eteteaka lekeleke tatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dokopa disaipolo dupa eteteaka walu lao paka kaeyapala, nyakama-lapo mende lamai-lamai pyoo, “Dopa-tamo doko, endakali api pyoo nyetape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dopa leaminopa Jisasame dokaita kandatae katao lao pituu, “Kalai doko endakalimi kapa pao napipenge. Goteme iki pipenge. Aipumape, Goteme dupa pitaka pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dokopa Pitame baa lamaiyoo, “Naimame dupa pitaka yakinatala emba watao epelyamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Dopa leamopa Jisasame yanu pyao, “Nambame nyakama kiningi langilyo: Akali mendeme nambapa, wai pii epe dokopa, dolapo masetala, baanya andapi, kaiminingipi, pimalengepi, takangepi, endangipi, endapi, wane wanakupi, eepi, dupa yakinatamo dokome andapi, kaiminingipi, pimalengepi, endangipi, wane wanakupi, eepi, dupa wakao 100 lao baa indupa gii dakepa nyalapomo. Nyepatamopa, endakali mendapuame baa tanda maiyoo koeyasoo katatami. Yuu enenge ipata dokonya baa lete etete katenge doko nyetaka. ");
INSERT INTO enq2_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dopaka doko, endakali longo enomba nyoo kalyamino dupa tanga maita-kaita katatami. Endakali longo maita-kaita kalyamino dupa tanga enomba nyoo katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisasa disaipolo dupa-pipa lalyoo Jerusalema paanya peaminopa, Jisasa wambea. Dokopa disaipolo dupa walu leami. Walu latala, baa watao pao pituu paka kaeyami. Dopa piaminopa, baame 12 disaipolo dutupa lanyepala, baa-kisa pita dupa tee pyao dokaita lamaiyoo pituu, ");
INSERT INTO enq2_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Salapape! Naima lalyoo Jerusalema pelyamano. Pupala katatamanopa, Akalinya Ikiningi doko prisa mupapi, Mosesanya loo mana nyepaepi, dupanya kinginya maitamopa, dupame baa pyao kumasepengena latami. Dopa latala dupame baa akali tata waka dupanya kinginya maitaminopa, ");
INSERT INTO enq2_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","dokaitame baa lamba lao, konjame pyao, sopokalimi pyao petala, pyao kumasetami. Dopa petataminopa, yuu gii tepo dokonya baa sakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi ikiningi Jemesapa, Jonepa dolapo Jisasa katea dokonya ipupala baa lamaiyoo, “Mana Lenge, nalimbame emba-kisa dopale mende tee latambanopa, embame latamba dopaka pipi laka lao masilyambanona” leambi. ");
INSERT INTO enq2_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dopa leambinopa Jisasame dolapo lamaiyoo, “Nambame nyakambanya aipa pyakapili lao masilyambipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dokopa dolapome baa lamaiyoo, “Embanya tii pipae dokonya, nalimbanya mende embanya kingi tolaetena pilyepa lape. Mende embanya kingi koeyatena pilyepa lape” leambi. ");
INSERT INTO enq2_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dopa leambinopa Jisasame dolapo lamaiyoo, “Nyakambame tee lelyambino doko masala naeyao tee lelyambino. Nambame kapo kenda paleta mendenya nalapo dokonya nyakambame kapa pao natambipi, pande nambame kaimbu kenda paleta mende nyalapo doko nyakambame kapa pao nyetambipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dopa leamopa dolapome baa lamaiyoo, “Nalimbame kapa pao dopa pitambana” leambi. Dopa leambinopa Jisasame dolapo lamaiyoo, “Kiningi, nambame kapo kenda paleta mendenya nalapo dokonya nyakambame natambiaka. Namba kaimbu kenda paleta mende nyalapo doko nyakambame nyetambiaka. ");
INSERT INTO enq2_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Dopaka doko, nambanya kingi tolaetena petena lapenge dokopa, nambanya kingi koeyatena petena lapenge dokopa, dolapo nambanya kalai daa. Pititambina lao depa latae endakali dolapo pititambina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pii doko sepala, disaipolo akalita dutupame Jemesapa, Jonepa dolapo tee pyao imbu kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dopa piaminopa, Jisasame disaipolo dutupa epena latala lamaiyoo, “Akali tata waka dupanya isingi akali dupame isoo katengema endakali dupa kandanya palyetala, dokaita alyasale joo katengema doko nyakamame kandengema. Akali tata waka dupanya akali andake dupame nyakamanya pii wata-minekena lao kandatae paengema doko nyakamame kandengemaka. ");
INSERT INTO enq2_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dopaka doko, nyakamanya kainanya mana dopale dupa naseta. Nyakamanya mende akali andake katapuli lao maseteno doko, baa nyakamanya kalai akali katapenge. ");
INSERT INTO enq2_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nyakamanya mende enomba nyoo katapuli lao maseteno doko, baa endakali dupa pitakanya kendemane katapenge. ");
INSERT INTO enq2_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aipumape, Akalinya Ikiningi dokome baanya kalai pyekena lao naepea. Baame endakali dupanya kalai pyakamaiyoo, baa kumata dokome endakali longo sambao nyalanya epeana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dokopa dokaita Jeriko peami. Dokonya katao, Jisasapi, disaipolopi, endakali kambu andake mendepi, dupa Jeriko yakinatala peami. Pao pituu kandeaminopa, Timeusa ikiningi, lenge monda Batimeusa lenge doko kaitini lembanya muni akipi tee lao petea. ");
INSERT INTO enq2_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Peteamopa Nasarete tange Jisasa ipao pelyamo leamino doko sepala, baame tee pyao wii lao, “Dapita Ikiningi Jisasa, embame namba kondo kaeyapoko!” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dopa leamopa, endakali longome baa pii kaena lao pyalanya leami. Dopa leaminopapi, baame etete puu lao wii lao, “Dapita Ikiningi, embame namba kondo kaeyapoko!” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dopa leamopa Jisasa katapala, akali doko epena lamaiyepa lao endakali dosa kateami dupa lamaiya. Dopa leamopa, endakali dupame lenge monda doko lamaiyoo, “Emba ipu lelyamona, mona yaepao sakata” leami. ");
INSERT INTO enq2_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dokopa baanya yonge pee kisa pingi doko lyokanya pyale latala, baa sakatao Jisasa katea dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dokopa Jisasame baa lamaiyoo, “Nambame embanya aipa pyakapili lao masilyipi?” lea. Dokopa lenge monda dokome baa lamaiyoo, “Mana Lenge, namba lenge auu pyoo tao kandapu laka lao masilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dopa leamopa Jisasame baa lamaiyoo, “Embame namba tungi pilyino dokome, embanya lenge dolapo auu pisekelyamona puu” lea. Dopa lalu piamopa, baanya lenge dolapo auu pyoo talu petala, baa Jisasa watao pea. ");
INSERT INTO enq2_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dokaita pao Jerusalema tengesa, Olipimanda dokonya taono Betepasapa, Betaniapa dolaponya pyakalyetala, Jisasame baanya disaipolo lapoma wambao pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Pena latala dolapo lamaiyoo, “Yuu yakane nyakambanya enombatena silyamo dokonya pupa. Pao pyakamalu pitambinopa, dongi ŋaŋa, wamba endakali mende napetenge mende anjetae katatamopa kanjambinona, doko tata lao minao ipupape. ");
INSERT INTO enq2_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Endakali mendeme nyakamba langyoo, ‘Aipuma dopa pilyambipi?’ lea-kandeno dokopa, nyakambame lao pituu, ‘Kamongome kalai mende dongi dakeme pipenge jilyamona’ lapape. Dopa latambinopa, dongi doko minao ae yapa ipupale lao baame kaeyalapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dopa lateamopa dolapo pupala, dongi ŋaŋa doko kaitini lembanya anda kambu mendenya kamaka anjetae kateamo kandatala tata leambi. ");
INSERT INTO enq2_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tata leambinopa endakali dosa kateami dupanya mendapuame dolapo lamaiyoo, “Nyakambame dongi ŋaŋa doko aipuma tata lelyambipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dopa leaminopa, Jisasame lamaina leali pyoo dokaita lamaiyambinopa, nyoo pena kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dokopa akali dolapome dongi ŋaŋa doko minao Jisasa katea dokonya ipupala, dolaponya yonge pee kisa pingi dolapo lyokanya dongi ŋaŋa dokonya maitanya setapeambinopa, Jisasa dokonya ketae petea. ");
INSERT INTO enq2_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pituu peamopa, endakali longome nyakamanya yonge pee kisa pingi dupa kaitini dokonya kuiyami. Yangi dupame ita wangya, yoko longo katenge dupa kepao nyepala kaitini dokonya kuiyamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dokopa endakali dupa wambata maita pyata pyoo pao pituu, puu lao wii lao, “Gote mambo pilyamano! Kamongonya kengenya epelyamo akali dake Goteme auu pisetae! ");
INSERT INTO enq2_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kamongonya kengenya, naimanya yumbange Dapitanya kingdom epelyamo dake Goteme auu pisetae. Etete ketae kaiti-kisa katenge Gote doko mambo pilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dopa leaminopa Jisasa Jerusalema pupala, lotuu anda nee nyetae kamapu dokonya pyakamea. Pyakamatala dokonya sia dupa pitaka lengeme kandao aowali lao kateamopa niki landa pianya, baa 12 disaipolo dutupa-pipa taono Betani dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yuu gii mende dokonya, dokaita Betani yakinatala epeaminopa, Jisasa baa lopo kaeya. ");
INSERT INTO enq2_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dokopa piki ita mende yoko pyoo omosale kateamo baame kandatala, dii lyilyape lao kanja pea. Pupala kandeamopa, piki dii nalyingi gii dokonyana, ita doko dii nalyoo yoko iki pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dokopa Jisasame piki ita doko lamaiyoo, “Tanga-tangapi endakali mendeme embanya dii mende lyao nanatana” lea. Pii doko disaipolo dupame siami. ");
INSERT INTO enq2_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dokaita Jerusalema pupala, Jisasa baa lotuu anda nee nyetae kamapu dokonya pyakamatala, maketa setao kateamipi, sambao kateamipi, dupa tee pyao watao pia. Dopa petala, muni aloo pingima dupanya tokopi, yaka maiyolee maketa setao petengema dupanya tokopi, dupa minatala kapilyia. ");
INSERT INTO enq2_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dopa petala endakali mendeme oapi mende soo, lotuu anda nee nyetae kamapu dokonya-kaita poko napina lao daa lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dopa latala baame dokaita mana lamaiyoo, “ ‘Nambanya anda doko akali tata dupa pitakanya loma singi anda latamina’ lao pepa pyapae nasilyape? Dopaka doko, nyakamame nambanya anda doko pake nenge dupanya yalo pingi panda jetelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Endakali kambu kateami dupa pitakame mana leamo doko sepala walu lao paka kaeyami. Tenge dokonya, Mosesanya loo mana nyepaepi, prisa mupapi, dupame Jisasa paka kaeyapala, baa aipa petala pyao kumasemape lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yuu kuiyala peamopa, Jisasa baa siti doko yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yongama wamba, kaita dokonya pao pituu kandeaminopa, piki ita doko tengenya pituu sapuu pao, mangenya tuu latae katea. ");
INSERT INTO enq2_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dokopa Jisasame pii lea doko Pitame masetala baa lamaiyoo, “Mana Lenge, embame piki ita dake koena lapino doko sapupya-lamo kanda” lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dopa leamopa Jisasame dokaita lamaiyoo, “Nyakamame Gote tungi pyalapape. ");
INSERT INTO enq2_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nambame nyakama kiningi langilyo: Endakali mende mona lapo palya naenya, baanya pii latamoli pyoo kiningi pyaapomona lao masetala, yuu manda dake lamaiyoo, ‘Emba sakatatala, solowatanya pyakala puu’ latamopa, kiningi lataliaka pita. ");
INSERT INTO enq2_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Dopana, nambame nyakama dapa langilyo: Dopale mende dina lao nyakamame loma setami dupa pitaka nyepelyamanona lao masalapape. Dokopa dopale mende nyetami doko nyakamanya jeta. ");
INSERT INTO enq2_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nyakamame loma soo katao, endakali mende imbu kaelyona lao masepae epea-kandeno doko, nyakamanya Takange kaiti-kisa katenge dokome nyakamanya koo dupa kame sekena lao, endakali dokonya koo dupa nyakamame kameaka sakamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dopaka doko, nyakamame endakali dokonya koo dupa kame sakamaiya naeyatamino doko, nyakamanya Takange kaiti-kisa katenge dokome nyakamanya koo dupa kame sakala naeyatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Dokaita Jerusalema deaka ipupala, Jisasa baa lotuu anda nee nyetae kamapu dokonya paeya. Dokopa, prisa mupapi, Mosesanya loo mana nyepaepi, Juumanya isingi akalipi, dupa ipupala baa tipa pyoo, “Embame kalai pilyino datupa kyeto aipale mendeme pilyi? Kyeto doko apimi emba ditala pii lamupa pilyipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame nyakama tipa mende pitoakana, nyakamame yanu pyakalapape. Yanu pyakatamino doko, nambame kalai datupa kyeto dopale mendeme pilyona lao nyakama langitoo. ");
INSERT INTO enq2_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Joneme kaimbu piamo doko, kaiti-kisa katao Goteme pina leape, pande endakalimi pina leami? Nyakamame nambanya pii doko yanu pyakalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dokopa dokaitame nyakama-lapo laloo pyoo, “ ‘Kaiti-kisa katao Goteme pina leana’ latamano doko, baame lao pituu, ‘Aipuma nyakamame Jonenya pii doko kiningina lao masala naeyamipi?’ laapomo. ");
INSERT INTO enq2_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dopaka doko, endakalimi pina leamina lamape?” leami. Endakali dupa pitakame Jone baa kiningi propetana lao masingima dokonya, endakalimi pina leamina laanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Paka kaeyapala dokaitame Jisasanya pii yanu pyakamaiyoo, “Naimame masala naelyamanona” leami. Dopa leaminopa Jisasame dokaita lamaiyoo, “Nambame kalai pilyo datupa kyeto dopale mendeme pilyona lao nyakama langya naeyatoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisasame kongali pii mendapu dokaita tee pyao lamaiyoo, “Akali mendeme yuu mende kakopatala, waene ee pokea. Pokatala dii lyao nyepala waene ipange nyalanya dii dupa indyepenge yuli mende tombao wasia. Wasetala ee doko kandao isoo pitipenge anda ketae mende pia. Dopa petala ee pokenge akali mendatupa baame lamaitala, waene dii mendatupa tange nyepengena, ee doko isoo katekena lea. Dopa latala baa yuu londati mendakaita pao katea. ");
INSERT INTO enq2_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Waene wambu pingi gii doko epeamopa, baanya kalai akali mende ee isakamaingi dupa kateami dokonya pupala, waene dii mendapu lyao peekena lao nyala pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kalai akali doko pateamopa, ee isakamaingi dupame baa minatala pyao indiami. Dopa petala baa mee pena leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dokopa ee tange dokome kalai akali mende pena lea. Kalai akali doko pateamopa, ee isakamaingi dupame baa kaname aiyomba pyao lombapala, mana koo elya pipae mendapu baa-kisa minatala pena leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dokopa kalai akali mende apata pena lateamopa, doko pyao kumasiami. Dokopa baame kalai akali longo mendapu apata pena leamopa, yangi dupa pyao indyepala, yangi dupa pyao kumasiami. ");
INSERT INTO enq2_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ee tange dokonya ikiningi mendai iki, baanya mona setenge doko katea. Ee tange dokome lao pituu, ‘Nambanya ikiningi doko anda-anda semaiyaminona’ latala, etao dokonya baanya ikiningi doko ee isakamaingi dupa kateami dokonya pena lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wane doko epeamopa, ee isakamaingi dupame nyakama-lapo laloo pyoo, ‘Wane dakeme takangenya moeya dupa nyepengena, moeya dupa naimanya jetana, baa pyao kumasemana ipupa’ leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dopa latala, wane doko minatala pyao kumasiami. Pyao kumasetala, baa waene ee dokonya kamalya pyale leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dopa piami dokonya, waene ee tange dokome aipa pita? Baa ipupala, ee isakamaingi dupa pyao kumasetala, waene ee doko akali waka mendapuame isoo katekena lao maita. ");
INSERT INTO enq2_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","‘Anda pingi dupame anda pipenge kana mende koeyapae-lamo latala yakineami doko kana mupa jetelyamo. Kana mupa jetelyamo doko Kamongome pipya dokonya, naimame eteteaka auu kaeyao sanya kandelyamanona’ lao Gotenya pii pepa pyapae singi dokonya silyamo dake nyakamame itaki napiamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dokopa Juumanya isingi akali dupame kongali pii doko nyakama lao lalumuna lao sepala, baa anjemana lao kaitini kutiami. Kutiamiaka doko, endakali kambu doko paka kaeyapala, baa yakinatala peami. ");
INSERT INTO enq2_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jisasame pii mende kopeta latamo dokonya baa mangenya minamana latala, Parasi mendapupi, Erote tata mendapupi, dupa baa katea dokonya pena leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Akali dupa pupala baa lamaiyoo, “Mana Lenge, embame endakali mende mona setapala, mende maka kaeyala naenge. Endakali kenge singipi, nasingipi dupanya mendeme emba mende latamini-lao paka nakaeyao, kiningi pii doko lao, Gotenya mana dupa tolao mana lengena lao naimame masilyamano. Dopana, Sisa doko takisa maipengena lao loome latae singipi nasingi? ");
INSERT INTO enq2_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Naimame baa takisa maipengepe, daape?” leami. Dopa leaminopa, Jisasame dupa mana tolatae miningi manemane pilyamino lao kandatala dokaita lamaiyoo, “Aipuma nyakamame namba makande pilyami? Muni konde mende kandatoo, nyoo pealapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dokopa dokaitame muni konde mende nyoo maitiaminopa, baame dokaita lamaiyoo, “Muni konde dakenya apinya lenge-lyaapi, kengepi dupa kalyape?” lea. Dopa leamopa dokaitame baa lamaiyoo, “Sisanya kalyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Sisanya dupa Sisa tange maiyakamaiyepape. Gotenya dupa Gote tange maiyakamaiyepape” lea. Jisasame dopa leamopa dokaitame baa paka kaeyao walu leami. ");
INSERT INTO enq2_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Endakali kumapae dupa sakatala naeyatamina lengema, Sadyusi dupa Jisasa katea dokonya ipupala baa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mana Lenge, Mosesame naimanya mana mende dapa lao pepa pyanya setekea-pyaa: ‘Akali mendeme enda nyepala wane manja naeyao kumatamo doko, baanya kaiminingi dokome enda walyakae doko pisetala, kaiminingi dokonya lao wane manjakamaipengena’ laanya setekea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dopana, kaiminingi kalange kateami dutupanya kaiminingi mupa doko enda nyepala, wane manja naeyao baa kumia. ");
INSERT INTO enq2_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kumateamopa kaiminingi lapo dokome enda walyakae doko pisetala, wane manja naeyaowaka baa kumia. Kaiminingi tepo dokome enda walyakae dokoaka pisetala, wane manja naeyaowaka baa kumia. ");
INSERT INTO enq2_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kaiminingi kalange dutupa pitakame enda dokoaka pisetala, wane manja naeyaowaka dutupa kumiami. Dutupa pitaka kumao ete dokonya enda doko kumiaka. ");
INSERT INTO enq2_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kaiminingi kalange dutupa pitakame enda mendai dokoaka nyiami dokonya, endakali kumapae dupa sakatatami gii dokopa enda doko apinya jetape?” lao tipa piami. ");
INSERT INTO enq2_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nyakamame Gotenya pii pepa pyapae singi doko masala naeyao, Gotenya kyeto doko masala naeyaowaka pingima. Tenge dokonya nyakamame kopeta lelyamino. ");
INSERT INTO enq2_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Endakali kumapae dupa malunya sakatatami gii dokopa, akali dupa enda nyala naeyao, wanaku dupa akali nyala paa naeyao, enjele kaiti-kisa katenge dupa katengemali pyoo katatami. ");
INSERT INTO enq2_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","Ita saka mendenya ita yuli teana lao Mosesanya buku dokonya pepa pyapae singi doko itaki napiamipi? Atome dokonya Goteme Mosesa lamaiyoo, ‘Abraamepi, Aisakepi, Jekopepi dutupanya Gote doko nambana’ lea. Baa kumapae dupanya Gote daa. Baa saka katenge dupanya Gote. Dopana, Goteme endakali kumapae dupa sakatasala naeyatana lao nyakamame lelyamino doko etete kopeta lelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mosesanya loo mana nyepae dupanya mende ipao katea dokome Sadyusi dupame Jisasa pii yanda pimaiyami dupa sepa, Jisasame dokaitanya pii auu pyoo yanu pyakamaiya dupa sepaka pia. Dopa petala akali dokome Jisasa tipa pyoo, “Mana setapae dupa pitakanya anduku etete mupape?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Mana setapae dupa pitakanya etete mupa doko langitoo: ‘Nyakama Israele dupame salapape! Naimanya Kamongo Gote doko baa mendai iki kalyamo. ");
INSERT INTO enq2_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Embanya monapi, embanya imambupi, embanya masingipi, embanya kyetopi, dutupa pitakame embanya Kamongo Gote doko auu kaeyape.’ Mana setapae doko etete mupa doko. ");
INSERT INTO enq2_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mana setapae lapo pyoo dake dopaleaka: ‘Emba tange auu kaengeli pyoo, embanya patali maki dupa auu kaeyape.’ Mana setapae dolapo ita minao, mana setapae waka mende alyasale nasilyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dopa leamopa Mosesanya loo mana nyepae dokome baa lamaiyoo, “Mana Lenge, doko kiningi. Gote baa mendai iki kalyamona, waka mende nakalyamona lelyeno doko, embame kiningi lelyeno. ");
INSERT INTO enq2_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Monapi, masingipi, imambupi, kyetopi dutupa pitakame Gote auu kaenge dokopi, tange auu kaengeli pyoo patali maki dupa auu kaenge dokopi, mana setapae lapoma dolapome itatenya tao mulyina lao opaa yangengepi, kundi maingipi, dupa pitaka ita miningina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Akali dokome masetala auu pyoo yanu piamo doko Jisasame kandatala baa lamaiyoo, “Gotenya kingdom dokonya emba londatili nakalyenona” lea. Dopa lateamopa, endakali mendaipi mendeme baa pii mende dee tipa pyaanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisasame lotuu anda nee nyetae kamapu dokonya mana lao pituu, “Mosesanya loo mana nyepae dupame Kraisa doko Dapitanya ikiningina lengema doko, aipa pyoo kandatala lengema? ");
INSERT INTO enq2_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Oli Spiritame masepae maiyamopa Dapitame dapa lea: ‘Kamongome nambanya Kamongo doko lamaiyoo, “Emba nambanya kingi tolaetena piti. Dokonya pititinopa, nambame embanya yandapipi dupa embanya moko setenge toko jina latona” leana’ lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dapitame Kraisa doko Kamongona lea-lumu doko, kaitini andukunya-kaita Kraisa doko Dapitanya ikiningipi?” lea. Jisasame pii lea doko endakali kambu andake kateami dupame auu kaeyao siami. ");
INSERT INTO enq2_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dokopa Jisasame dokaita mana lamaiyoo pituu dapa lea: “Mosesanya loo mana nyepae dupa nyakamame wandyoo kalyepape. Dokaita yonge pee londe pyoo petala kaitini paeyalanya auu kaengema. Maketa dupanya endakali dupame dokaita mambo pyao kingi nyimi laka lao masingima. ");
INSERT INTO enq2_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lotuu anda dupanya toko enomba nyoo dupanya pitimu laka lao masingima. Nee andake nelyami dupanya enomba nyoo pitimu laka lao masingimaka. ");
INSERT INTO enq2_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dokaitame enda walyakae dupa minakasetala, yuu andapi dupa nyingima. Endakali waka dupame dokaita epena lao masina latala, loma londe pyoo singima. Akali dupa-kisa tenge setatamopa, dupa tanda etete andake nyetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dopa latala, lotuu anda nee nyetae dokonya opaa pyandenge penge dokonya Jisasa tengesa pitipala, endakali kambu dupame aipa pyoo muni pyandelyamipi lao kandatae petea. Dokopa yuunya kamongo longome muni longo lao pyandeami. ");
INSERT INTO enq2_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dopa piaminopa, enda walyakae daa jepae mende ipupala, muni konde etete yakane lapoma pyandea. ");
INSERT INTO enq2_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dokopa Jisasame baanya disaipolo dupa epena latala lamaiyoo, “Nambame nyakama kiningi langilyo: Opaa pyandenge penge dokonya enda walyakae daa jepae dakeme muni pyandalamo dokome, endakali waka dupame muni pyandalamino dupa pitaka ita minao pyandalamo. ");
INSERT INTO enq2_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Endakali dokaitame nyakamanya muni longo sipya dupanya kakana nyoo pyandalamino. Dopa piminopa, enda daa jepae dakeme baa tange napenge sipya dupa pitaka pyandalamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisasa baa lotuu anda nee nyetae kamapu doko yakinatala peamopa, baanya disaipolo dupanya mendeme baa lamaiyoo, “Mana Lenge, anda yale epe datupa kana yale auu petae dupame petae kalyamo kanda” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Anda yale epe petae kalyamo datupa kandelyepe? Datupa pitaka dopa petae katena lao kaeyala naenya kaluu nepataminopa, kana mendaipi mende namba-namba petae nakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisasa Olipimanda pituu, lotuu anda nee nyetae doko katenge dokaita-kaita kandamatae petea. Peteamopa Pitapi, Jemesapi, Jonepi, Andruapi dutupame elyakalao baa tipa pyoo, ");
INSERT INTO enq2_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Embame lelyeno dutupa gii andukupa pita? Embame naima langi. Dutupa pitaka pyaanya tengesa pitamopa, kongali aipale mende pitape?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dopa leaminopa Jisasame tee pyao dokaitanya pii yanu pyakamaiyoo, “Endakali mendeme nyakama minakasetana, kandao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aipumape, endakali longo mendapu nambanya kengenya ipupala lao pituu, ‘Namba akali dokona’ lao endakali longo minakasetami. ");
INSERT INTO enq2_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dokopa yanda pilyamino lapaepi, yanda ingingi lapaepi, dupa sepala nyakama walu nalalapape. Tenge doko, dopale dupa ipupenge. Dopaka doko, yuu etapenge gii doko, dokopa ipa naeyata. ");
INSERT INTO enq2_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Akali tata mendeme akali tata mende yanda pimaita, kingdom mendeme kingdom mende yanda pimaita pitami. Yuu mendapuanya titiwali dupa minata, lopo andake dupa sepa, pundu dupa ipata pita. Dopa pita dupa, enda wane manjanya tee pyao maita pingi dopale. ");
INSERT INTO enq2_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Endakali dupame nyakama anjetala laminao pao, kanjole dupa-kisa kotimi lata, lotuu anda dupanya nyakama pyao indyepa pitamina, kandao kalyepape. Nyakamame namba watao paelyamino latala, endakali dupame gapenapi, kiŋipi dupanya enombanya nyakama katasetami. Dopa pitaminopa, nyakamame kandelyaminopi, silyaminopi dupa akali dokaita panao lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wai pii epe doko wambao akali tata dupa pitaka lamaipenge. ");
INSERT INTO enq2_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Endakali dupame nyakama anjetala laminao kote anda dupanya pataminopa, nyakamame pii aipa lamanape lao wambao masepae longo nyala naeyalapape. Kote lapenge gii dokopa nyakama pii ditali pyoo lapape. Nyakamame pii latami dupa, nyakama tangeme masoo laa naeyatami. Oli Spiritame nyakama ditamopa latami. ");
INSERT INTO enq2_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kaiminingi mendeme kaiminingi mende pyao kumasina lao anjoo maita. Takange dupame nyakamanya wane dupa dopaka pina lao anjoo maitami. Wane dupame nyakamanya endangi takangepi dupa yandapipi jetala, pyao kumasina lao maitamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nyakamame nambanya kenge doko lao panelyamino latala, endakali dupa pitakame nyakama imbu kaeyatami. Dopaka doko, endakali mende kyeto joo katao, baa etata gii dokonya tuu latamo doko, baa pyoo nyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Lotuu anda nee nyetae koeyasingi, myuku pipae mende ipatana lao propeta Danieleme lea doko, nasepenge panda dokonya setamopa kandatami gii dokopa, endakali Judia katatami dupa yuu manda dupanya paka pupenge jeta.” (Pii dake itaki pyate dokome tenge doko kutao nyepe.) ");
INSERT INTO enq2_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Gii dokopa endakali mende baanya anda ketae katata dokome, baanya oapi andakote seta mende nyalanya isa pyakanala naeyapenge jeta. ");
INSERT INTO enq2_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Endakali mende eenya katata dokome, baanya yonge pee kisa pingi doko nyalanya pilyala naeyapenge jetaka. ");
INSERT INTO enq2_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Enda wane tongotapi, enda wane andu nengepi, dupa gii dokopa etete kondo pita. ");
INSERT INTO enq2_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Poo lao aiyuu epenge gii mendenya paka napataminopana nyakama loma soo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kenda wamba epea dupa pitaka ita minao, yuu gii dutupanya kenda andake mende ipata. Goteme yuupa kaitipa dolapo tee pyao wasia dokonya pituu, indupa tuu lao, kenda etete andake dopale mende naepea. Tanga-tangapi kenda etete andake dopale mende naipataka. ");
INSERT INTO enq2_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yuu gii dutupa Kamongome muu pisala naeyatamo doko, endakali mendaipi mende pyoo nyepae nakatata. Dopaka doko, baanya yapao nyepae dupa masetala, yuu gii dutupa muu piseta. ");
INSERT INTO enq2_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Gii dokopa Kraisa manemane pingimapi, sambo propetapi dupa ipupala, Gotenya yapao nyepae endakali dupa apata kyakasetamano nakandenya latala, mirakolo andakepi, kalai paka pipaepi, dupa pitami. Dopana, endakali mendeme nyakama langyoo, ‘Kraisa doko asa kalyamo kanjepa, amasa kalyamo kanjepa’ lea-kandeno doko, kiningi lelyamona lao masala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tanga pita dupa pitaka nambame nyakama wambao langilyona, kandao kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Kenda andake dutupa ipao etapatamopa, yuu gii dutupanya niki doko iminjoo, kana doko tii napyoo, kaitinya bui dupa kondao isa ipao, kaitinya kyeto singi dupa ema-ema pyoaka pita. ");
INSERT INTO enq2_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dokopa Akalinya Ikiningi doko baanya kyeto andakepi, tii pipaepi dupanya pituu, kopa tambetambe ipatamopa endakali dupame kandatami. ");
INSERT INTO enq2_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gii dokopa poo kitomende dutupapi, yuu lembapi, kaiti lembapi, dupanya baanya enjele dupa pupala, baanya endakali yapao nyepae dupa nyoo kambu pyekena latana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nyakamame piki ita dupanya mana dake nyalapape: Piki ita dupanya mange popo pilya dupa kandatala, paina pyaanya tengesa pilyamona lao nyakamame masingima. ");
INSERT INTO enq2_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Dopana, lelyo dutupa pitamopa nyakamame kandatala, Akalinya Ikiningi doko lome kambunya ipao tengesa katapelyamona lao masalapape. ");
INSERT INTO enq2_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nambame nyakama kiningi langilyo: Endakali indupa palelyamino dupa kumao etala naeyataminopa, lelyo dutupa pitaka pita. ");
INSERT INTO enq2_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yuupa kaitipa dolapo alu pita. Dopaka doko, nambanya pii dupa alu napitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Dutupa pipenge yuu giipa, awapa dolapo endakali mendeme masala naenge. Enjele kaiti-kisa katengema dupame apata masala naengemaka. Ikiningi dokome apata masala naengeaka. Takange dokome iki masingi. ");
INSERT INTO enq2_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dopana, gii doko andukupa ipatape lao nyakamame masala naelyaminona, nyakama loma soo kandao isoo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gii doko akali mendeme baanya anda doko yakinatala, yuu londati mendakaita pao kateamo dopale. Paanya pituu baanya kalai akali dupame anda doko isoo katekena latala, mendai-mendai lao kalai mokosoo maiya. Dopa petala, akali lome kambu isoo katenge dokome lome kambu doko isokondape pyoo isoo katekena latala, baa pea. ");
INSERT INTO enq2_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Dopana, anda tange doko yuu kuita-kuita ipatape, kuka andatombe ipatape, pauli pii latamopa ipatape, yongama wamba ipatape lao nyakamame masala naengema. Baa yapa pyakaeyalu petala, nyakama luu paliu setaminopa kandatana kandao isoo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","‘Kandao isoo kalyepape!’ lelyo pii mendai dokoaka endakali dupa pitaka lamailyona” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasopa gii dokopa, Breta Yisa Pyandala Naeyao Yangapae Nengema gii dokopa, dolapo ipanya yuu gii lapoma siamopa, prisa mupapi, Mosesanya loo mana nyepaepi, dupame Jisasa aipa petala waa katao anjoo nyepala pyao kumasemape lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kutapala lao pituu, “Endakali dupame pundu yaka lasetamina, nee andake napenge gii dokonya dopa napimanana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betani dokonya akali kopetali Saimone lenge dokonya andaka Jisasa baa nee nao petea. Peteamopa wele tunduma pipae, natame iki wele wasepae, muni andake pupenge mende pengenya paleta enda mendeme minao epea. Ipupala baame penge dokonya kambu doko tambapala, Jisasanya aiyombanya wele doko kai lakamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Kai lakamaiyamopa, endakali peteami dupanya mendapuame imbu kaeyapala nyakama-lapo laloo pyoo, “Wele dake salimi lao silipa muni 300 yalao nyepala, endakali daa jepae dupa maimualina, aipuma enda dakeme wele dake pyoo nepelyape?” leami. Dopa latala, enda doko maka kaeyapala pyalanya leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dopaka doko, Jisasame lao pituu, “Enda dakeme namba-kisa kalai epe mende pilyamona, pina kaeyalapa. Aipuma nyakamame baanya mona kenda pisakamailyami? ");
INSERT INTO enq2_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Endakali daa jepae dupa koteaka lao nyakama-pipa katatami. Nyakamame dokaita nisemana lao masetamili pyoo nisetami. Dopaka doko, namba nyakama-pipa gii longo mende kalya naeyalamano. ");
INSERT INTO enq2_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Enda dakeme pipenge jipya doko pyomo. Nambanya yonge doko malu pipenge dokonya depa lasoo, wele tunduma pipae doko baame namba-kisa kai lakalamo. ");
INSERT INTO enq2_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nambame nyakama kiningi langilyo: Wai pii epe dake lao panatami yuu dupa pitakanya, enda dakeme pyomo doko lamaitaminopa, endakali dupame baa masetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dokopa Judasa Iskariota doko, 12 disaipolo dutupanya mende dokome prisa mupa dupanya kinginya Jisasa maiyanya pea. ");
INSERT INTO enq2_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pao lamaitiamopa, dokaitame baanya pii doko sepala auu kaeyami. Auu kaeyapala muni mendatupa baa maimanana leami. Dokopa Jisasa dokaitanya kinginya maiyanya Judasame kaitini kutao katea. ");
INSERT INTO enq2_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Breta Yisa Pyandala Naeyao Yangapae Nengema, yuu gii tee pyao dokonya, sipisipi ŋaŋa mendapu pyapala, Pasopa gii doko masoo nengema. Dopa pingima gii doko epeamopa, Jisasanya disaipolo dupame baa lamaiyoo, “Pasopa nee doko emba natale, naimame anja depa lakamili lao masilyipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dopa leaminopa, baanya disaipolo dupanya lapoma pena latala lamaiyoo, “Nyakamba siti dokonya pupape. Patambinopa endaki kamuu singi akali mendeme nyakamba kandanyalapomona, doko watao pupape. ");
INSERT INTO enq2_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pupala baa andaka kolandata dokonya anda tange doko lamaiyoo, ‘Mana Lenge dokome baanya disaipolo dupa-pipa Pasopa nee doko namana, panda doko andusa silyape lelyamona’ lao lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dokopa baame anda ketae mendenya ruma andake, depa latae mende laitaka pyaapomona, dokonya nyakambame naimanya nee depa lapape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dopa lamaitiamopa, baanya disaipolo dolapo siti dokonya pao pyakamatala, Jisasame lealiaka petae siamo kandatala, Pasopa nee doko depa leambi. ");
INSERT INTO enq2_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yuu kuiyala peamopa, Jisasa baa 12 disaipolo dutupa-pipa epeami. ");
INSERT INTO enq2_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ipupala nee nao pituu, Jisasame dokaita lamaiyoo, “Nambame nyakama kiningi langilyo: Nee nao pilyamano dakenya mendeme namba yandapipi dupanya kinginya maiyapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dopa leamopa, dokaita tee pyao mona kenda kaeyapala baa lamaiyoo, “Embame lelyeno doko namba lao lelyepe?” laa-laa peami. ");
INSERT INTO enq2_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Breta disanya poeyanyoo nao pilyamano, nyakama 12 disaipolo datupanya mendeme namba yandapipi dupanya kinginya maiyapomo. ");
INSERT INTO enq2_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Akalinya Ikiningi doko kumala pupengena lao pepa pyapae singi dokonya, dopaka pyaapomo. Dopaka doko, Akalinya Ikiningi doko yandapipi dupanya kinginya maiyapomo akali doko baa koeyalapomo! Akali doko endangimi namandeali doko yaka jialina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dokaita nee nao pituu, Jisasame breta mende nyepala, Gote yaka pilyino latala konjia. Konjepala dutupa maiyoo pituu, “Dake nambanya yonge dokona, nyoo nalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dopa petala baame kapo waene peteta mende nyepala, Gote yaka pilyino latala dokaita maiya. Maiyamopa dokaita pitakame nyoo neami. ");
INSERT INTO enq2_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dokopa baame dokaita lamaiyoo, “Dake nambanya taeyoko doko. Taeyoko kai lelyo dakeme endakali longo nisoo, pii enenge mende lao yaki pinya setelyo. ");
INSERT INTO enq2_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nambame nyakama kiningi langilyo: Namba dee waene nala naeyaowaka katao, Gotenya kingdom dokonya waene enenge doko natona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dopa lateamopa, dokaitame wee mende latala kamaka pyakalyiami. Pyakalyetala dokaita Olipimanda peami. ");
INSERT INTO enq2_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dokopa Jisasame dokaita lamaiyoo, “Dapa lao pepa pyapae silyamo: ‘Nambame sipisipi setao katenge doko pyatopa, sipisipi dupa saa latamina’ lapae silyamo. Dopa lapae silyamo dokonya, indupa kuka gii dakepa, namba-kisa kenda ipapomo doko kandatala, nyakama pitaka isa pyakalamino. ");
INSERT INTO enq2_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dopaka doko, Goteme namba sakataseta. Dopa petatamopa, nyakama Galali paa naeyataminopa, namba wambao patona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dokopa Pitame Jisasa lamaiyoo, “Yangi dupa pitaka isa pyakataminopapi, namba isa pyakala naeyatona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dopa leamopa Jisasame baa lamaiyoo, “Nambame emba kiningi langilyo: Indupa kuka gii dakepa, yaka pauli pii lapo pyoo doko ene laanya pitamopa, paa tepomasa embame namba nakandengena laapenona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dokopa Pitame etete kyeto joo lao pituu, “Emba kumate dokonya namba apata kumapenge jetamopapi, nambame emba nakandengena laa naeyalapona” lea. Dokopa yangi dupa pitakame dopaka leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dokopa dokaita yuu Gesemani lenge dokonya peami. Pupala Jisasame baanya disaipolo dupa lamaiyoo, “Namba loma sala pelyona, nyakama asa pilyepa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Dopa latala baame Pitapi, Jemesapi, Jonepi dutupa laminao pupala, baa tee pyao mona etete kenda kaeyapala masepae longo nyia. Dokopa baame dutupa lamaiyoo, “Nambanya mona doko etete kenda pipya dokome namba kumapenge julumuna, nyakama asa kandao isoo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Dopa latala baa kuki umbisale pao, yuunya tombauli sepala, gii doko baa-kisa naipupenge jetamo doko, naepena lao loma sia. Loma soo pituu, “Apane, Apane, embame dupa pitaka pingi. Kapo kenda paleta dake embame nyoo nepakape. Dopaka doko, nambame masilyo dokonya-kaita napipi. Embame masilyino dokonya-kaita pipi” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dopa lao loma sepala epeamopa, disaipolo dutupa luu paliu siamino kandatala, baame Pita lamaiyoo, “Saimone, emba luu palelyepe? Embame awa mendai dokonya kapa pao kandao isoo nakatalepe? ");
INSERT INTO enq2_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nyakamanya moname pyoani kaeyamupa, yongeme papa tambuilyamona, makande pipae dupanya nyakama isa pyakala naeyamana lao loma soo kandao isoo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dopa latala baa dee pupala, wamba loma sia dutupaka sia. ");
INSERT INTO enq2_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sepala ipao kandeamopa, disaipolo dutupa lemonguti kaeyapala dee luu paliu siami. Dopa piami dokonya, baa aipa lamaimape lao masala naeyami. ");
INSERT INTO enq2_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Maitakao, paa tepo pyoo baa ipupala dokaita lamaiyoo, “Nyakama koto nyoo luaka paliu silyamipi? Nyakama yaka luu palipilyamino. Gii doko ipatelyamo. Akalinya Ikiningi doko koo pingi endakali dupanya kinginya maiyapomona, naima mona sakatalapa. Namba yandapipi dupanya kinginya maiyapomo akali doko ipatelyamona kanjepa” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisasame dopa lao kateamopa, baanya 12 disaipolo dutupanya mende, Judasa lenge doko ipu pia. Endakali kambu andake mende konjuwapi, kolyepepi dupa minao baa-pipa epeami. Dupa prisa mupapi, Mosesanya loo mana nyepaepi, Juumanya isingi akalipi, dupame epena leaminosa epeami. ");
INSERT INTO enq2_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yandapipi dupanya kinginya Jisasa maiya akali dokome kongali mende pyaapona lao endakali baa-pipa epeami dupa lamaiyoo, “Nambame akali mende nunu pyaapo doko baana, nyakamame baa minatala kandao isoo laminao pupape” lao wamba baame dokaita lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jisasa katea dokonya Judasa tolao pupala baa lamaiyoo, “Mana Lenge, Mana Lenge!” lea. Dopa latala baa nunu pia. ");
INSERT INTO enq2_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dopa piamopa dokaitame Jisasa minatala anjiami. ");
INSERT INTO enq2_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Anjiaminopa akali makisa kateami dupanya mendeme baanya konjuwa doko kolanyetala, prisa mupa dokonya kalai akali dokonya kale doko lyanya nepea. ");
INSERT INTO enq2_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dokopa Jisasame dokaita lamaiyoo, “Pake nenge mende anjala epele lao nyakamame konjuwapi, kolyepepi dupa minao namba anjala epelyamipi? ");
INSERT INTO enq2_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nambame koteaka lao lotuu anda nee nyetae kamapu dokonya mana langyoo nyakama-pipa kateo dokopa, nyakamame namba anjala naeyami. Dopaka doko, Gotenya pii pepa pyapae singi dupa angi jina lao datupa pilyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dokopa baa-pipa kateami dupa pitakame baa yakinatala paka peami. ");
INSERT INTO enq2_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wane patange mende yonge pee napyoo lapalapa iki petae, Jisasa watao pea doko, wane patange waka dosa kateami dupame anjalanya miniami. ");
INSERT INTO enq2_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Minateaminopa lapalapa doko kakonya yakinatala, baa papata paka pea. ");
INSERT INTO enq2_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dokopa Jisasa anjoo nyala epeami dupame Jisasa laminao, prisa mupa doko katea dokonya peami. Prisa mupapi, Juumanya isingi akalipi, Mosesanya loo mana nyepaepi, dupa prisa mupa dokonya andaka kambu pyatae kateami. ");
INSERT INTO enq2_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita baa kuki londatili joo Jisasa watao pea. Pupala prisa mupa dokonya anda kamapu dokonya pyakamatala, yanda singi dupa-pipa ita tea mendenya endo soo petea. ");
INSERT INTO enq2_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Prisa mupapi, kanjole kambuingi andake dokonya katenge dupa pitakapi, dupame Jisasa pyao kumasemana latala, akali mendapuame sambo-kisa setao Jisasa kotimi lena latala kutiami. Kutao nyiamiaka doko, dokaitame tenge angi mende kandao nanyiami. ");
INSERT INTO enq2_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Akali longo mendapuame baa sambo-kisa setao kotimi leamiaka doko, dokaitanya pii leami dupa mendai nanjia. ");
INSERT INTO enq2_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dokopa akali mendapu sakatatala baa sambo-kisa setao dapa leami: ");
INSERT INTO enq2_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Akali dakeme lao pituu, ‘Nambame lotuu anda nee nyetae, kingimi petae dake lakyepala, yuu gii tepomanya waka mende pito doko, endakali kingimi napipenge mende pitona’ leamopa naimame siamana” leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dopa leamiaka doko, dokaitanya pii leami dupa mendai nanjia. ");
INSERT INTO enq2_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dokopa prisa mupa doko dokaitanya kainanya toeya katapala Jisasa tipa pyoo, “Pii lelyamino dupa yanu pyala naelyepe? Emba-kisa tenge setao pii lelyamino dupa sepala, embame aipa lao masilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dopa leamopa Jisasame yanu pyao pii mende nalea. Dokopa prisa mupa dokome baa deaka tipa pyoo, “Emba Gote Auu Petae dokonya Ikiningi Kraisa dokope?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dokopa Jisasame lao pituu, “Doko namba. Akalinya Ikiningi doko Gote etete kyeto dokonya kingi tolaetena pituu, kaitinya kopa tambetambe ipatamopa nyakamame kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Dopa leamopa, prisa mupa dokome baanya yonge pee dupa tange minao lapyepala lao pituu, “Aipuma endakali mendapuanya deaka pii nyemana? Baame Gote anda-anda semaiya naeyao pii lelyamo doko nyakamame sepelyamino. Nyakamame aipa pimana lao masilyamipi?” lea. Dokopa dokaita pitakame baa-kisa tenge setapala, baa pyao kumasepengena leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dopa latala akali mendapuame baa sopokalimi tee pyao piami. Pyapala baanya lenge-lyaapi yaki petala, kimiame pyao pituu, “Emba pyalumu akali doko, dokona lao propesi piimi laa!” leami. Dokopa yanda singi kateami dupame baa kingi kapeme piami. ");
INSERT INTO enq2_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita baa anda kamapu dokonya peteamopa, prisa mupa dokonya kalai wanaku dupanya mende epea. ");
INSERT INTO enq2_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ipupala Pita endo soo peteamo doko kandakondape pyoo kandatala baa lamaiyoo, “Emba apata Nasarete tange Jisasapa kateambina” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dopa leamopa Pitame tanga lao, “Embame pii lelyeno doko aki mende lelyepe lao nambame masala naeyao, tenge doko soo nyala naeyaowaka pilyona” lea. Dopa latala baa lome kambu dokonya peamopa, yaka pauli pii mende lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dokopa kalai wanaku dokome baa dee kandatala akali kateami dupa tee pyao lamaiyoo, “Baa akali dutupanya mendena” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dopa leamopapi Pitame dee tanga lao, “Namba akali dutupanya mende daana” lea. Gii kuki pateamopa, akali dosa kateami dupame apata Pita lamaiyoo, “Galali tange dupame lengemali pyoo embame pii lenge-lamo doko emba Galali tange dokonyana, kiningi etete emba akali dutupanya mende-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dokopa Pitame baanya pii dupa kyeto tasalanya Gotenya kenge doko latala lao pituu, “Akali lelyamino doko namba nakandenge etete daana, sambo lato doko Goteme namba pinana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dopa leamopa yaka pauli pii lapo pyoo lea. Dokopa Jisasame Pita lamaiya pii datupa Pitame masia: “Yaka pauli pii lapo pyoo laanya pitamopa, paa tepomasa embame namba nakandengena laapenona” lea dutupa masetala, Pita ee lao putukia. ");
INSERT INTO enq2_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yongama wamba, prisa mupapi, Juumanya isingi akalipi, Mosesanya loo mana nyepaepi, kanjole kambuingi andake doko pitakapi, dupa pii lao kambuiyami. Lao kambutala, dupame Jisasa anjetala laminao pao Pailata maiyami. ");
INSERT INTO enq2_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Maitiaminopa Pailatame baa tipa pyoo, “Emba Juumanya Kiŋi dokope?” lea. Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Embame latelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dokopa prisa mupa dupame Jisasa-kisa tenge longo seteami. ");
INSERT INTO enq2_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dokopa Pailatame dee baa tipa pyoo, “Emba-kisa tenge longo setelyamino doko, embame piipi mende yanu pyao nalelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dopa leamopa, Jisasame dee pii mende yanu pyao naleamosa, Pailata walu lao paka kaeya. ");
INSERT INTO enq2_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nee andake nenge gii doko epelyamopa akali anjetae dupanya mende endakali dupame mokokena lelyami doko Pailatame mokata pyakamaingi. ");
INSERT INTO enq2_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wamba akali mendapuame gapomane yanda pimaitala, endakali mendapu pyao kumasiaminopa, dokaita anjinya pyandeami. Anjetae paleami dupanya mende Barabasa lenge. ");
INSERT INTO enq2_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Anjetae dupanya mende mokata pyakamaingi gii doko epeamopa, endakali kambu doko ipupala, akali mende mokokena lao puu lao Pailata-kisa tee leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Prisa mupa dupame tilya nyepala Jisasa anjoo dimini-lamo lao Pailatame kandatala, baame endakali kambu doko lamaiyoo, “Nambame Juumanya Kiŋi doko mokokapili lao nyakamame masilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dopa leaka doko, Jisasa daana, Barabasa mokokena lamana lao, prisa mupa dupame endakali kambu doko ingi tuu leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dokopa Pailatame dokaita dee lamaiyoo, “Juumanya Kiŋi lengema dake nambame aipa pyakapili lao nyakamame masilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dopa leamopa dupame dee puu lao, lao pituu, “Baa poko itanya pyao yuku!” leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Dopa leaminopa Pailatame dokaita lamaiyoo, “Aipuma? Baame koo aki mende pipyape?” lea. Dopa leaka doko dokaitame lao pituu, “Baa pyao yuku!” lao eteteaka puu lao leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dokopa Pailatame endakali kambu dupa auu kaeyamili lao masetala, Barabasa doko mokokamaiya. Dopa petala amii dupame Jisasa konjame pyapala pyao yukuina lao maiya. ");
INSERT INTO enq2_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dokopa amii dupame Jisasa laminao, gapomane isingi akali andake doko petenge anda dokonya kolandatala, amii dupa pitaka ipao kambu pina leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kambu pyatala, dupame yonge pee kala pepolo mende Jisasanya petakamai, kende nenge-nenge katapae mende nyoo makipu petala, baanya aiyombanya pisakamaiyami. ");
INSERT INTO enq2_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dopa petala dupame baa tee pyao lamba lao, “Juumanya Kiŋi doko, emba auu pyoo katape!” leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dopa latala dupame kyeo konjame aiyombanya pyapa, sopokali tasinya piseta, baa luma lakao mambo pyapa piami. ");
INSERT INTO enq2_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dopa pyoo baa lamba latala, yonge pee kala pepolo doko lyokao nyepala, baanya pingi dupa pyakamaiyami. Dopa petala, baa pyao yukulanya laminao kamaka peami. ");
INSERT INTO enq2_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dokopa Alekesandapa, Rupusapa dolaponya takange Saimone, yuu Sairini tange doko, yuu yakane mendenya katao siti dokonya epeamopa, amii dupame baa pyalanya latala, Jisasanya poko ita doko nyoo sakamaina leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sakamaiyamopa dupame Jisasa laminao, yuu Gologota dokonya pao pyakalyiami. (Gologota dokonya tenge doko, Matena Kuli.) ");
INSERT INTO enq2_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dokopa dupame kapo waene peteta mendenya wele tunduma pipae-pipa pyasetae mende Jisasa nena lao maiyaminopa, baame nanenya kaeya. ");
INSERT INTO enq2_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Kaeteamopa, yongama 9 kiloko dokonya Jisasa pyao poko itanya yukuiyami. Yukutala, apimi baanya yonge pee dupanya mende nyilyape lao kandamana latala, amii dupame laki pyatala mokosoo nyiami. ");
INSERT INTO enq2_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jisasa-kisa tenge seteami pii dake pepa pyatae poko ita ketae dokonya katea: “Juumanya Kiŋi dokona” latae katea. ");
INSERT INTO enq2_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pake nenge lapoma baa-pipa pyao yukuiyamiaka. Mende doko baanya kingi tolaetena yukuiyami. Mende doko baanya kingi koeyatena yukuiyami. ");
INSERT INTO enq2_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dopa piami dokome, “Loo yalenge akali dupa-pipa baa pyasoo itaki piamina” lao Gotenya pii pepa pyapae singi dokonya lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jisasa pyao yukutae katea dokonya-kaita endakali paeyami dupame aiyomba wangatoto petapu lao nepao lao pituu, “Embame lotuu anda nee nyetae doko lakyepala, yuu gii tepomanya waka mende pitona leeno akali dokae, ");
INSERT INTO enq2_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","emba tange pyoo nyoo, poko ita doko yakinatala isa ipupoko” leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mendai dopaka pyoo, prisa mupapi, Mosesanya loo mana nyepaepi, dupame Jisasa lamba lao, nyakama-lapo laloo pyoo, “Baame endakali waka dupa pyoo nyipumuaka doko, baa tange kapa pao pyoo nyala naenge-lamo. ");
INSERT INTO enq2_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kraisa dake, Israele dupanya Kiŋi dokona, indupa baa poko ita doko yakinatala isa epena kae. Dokopa naimame kandatala baa tungi pyamanana” leami. Dopa leaminopa, akali baa-pipa pyao yukutae kateambi dolapome baa lamba leambiaka. ");
INSERT INTO enq2_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kotaka 12 kiloko leamopa yuu doko pitaka kuiya doko, kuiyetaeyaka katao pao, alemandi 3 kilokonya tuu lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Alemandi 3 kiloko leamopa, Jisasame puu lao wii lao, “Iloi, Iloi, lima sabatani?” lea. (Pii dokonya tenge doko, “Nambanya Gote, nambanya Gote, embame namba aipuma yakinelyepe?”) ");
INSERT INTO enq2_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dopa lea doko endakali dosa kateami dupanya mendapuame sepala lao pituu, “Ilaija lao wii lelyamona salapape” leami. ");
INSERT INTO enq2_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dopa lateaminopa, akali mendeme alo pyao pao, koma jepae mende waene kaa pipae mendenya pyandao waeneme tumbasetala, kolo itakuli mendenya tuku petala, Jisasa nena lao makapusia. Dopa petala baame lao pituu, “Ilaijame baa kondao nyala epelyape lao kandamana kae” lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dokopa Jisasame eteteaka puu lao ae latala, baanya imambu doko yakinea. ");
INSERT INTO enq2_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dokopa lotuu anda nee nyetae dokonya panda nee nyetae dotena kame pinyoo lapalapa andake mendeme kame pinyetae katenge doko ketae pituu titi pyao isa tuu latala lapo pyoloo pia. ");
INSERT INTO enq2_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Amii 100 isingi mende, Jisasanya enomba-kaita katea dokome, Jisasa dopa pyoo ae latala baanya imambu doko yakineamo doko kandatala lao pituu, “Kiningi etete, akali dake Gote Ikiningi-lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Enda mendapu kuki londatili pituu kandatae peteami. Enda dutupanya mendatupa, Maria Magadala tange dokopi, wane maitakao mandipae Jemesapa, Josesapa dolaponya endangi Maria dokopi, Salomiapi, dutupa peteami. ");
INSERT INTO enq2_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisasa baa Galali yuu dokonya katea dokopa, enda dutupame baa nisetapu watao paeyami. Enda longo mendapu baa-pipa Jerusalema lalyoo epeami dupa dosa peteamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Yuu kuiyalanya piamopa, kanjole dokonya akali kenge epe singi, Arimatia tange Josepe lenge doko epea. Baa Gotenya kingdom doko malisoo katengeaka. Sambata depa lenge gii doko paleamopa, Josepe baa paka nakaeyao, Pailata katea dokonya pupala, Jisasanya yonge doko dina lao tee lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dopa leamopa Pailatame Jisasa kumatalame-lumu lao sepala walu lea. Walu latala baame amii 100 isingi doko epena latala, Jisasa kumatalape lao tipa pia. ");
INSERT INTO enq2_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Amii 100 isingi dokome Jisasa kiningi kumatalamona lao lamaitiamopa Pailatame sepala, Jisasanya yonge doko Josepeme kondao nyina lao yakana lea. ");
INSERT INTO enq2_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dokopa Josepeme lapalapa kyeo lapae mende sambapala, Jisasanya yonge doko kondao nyepala, lapalapa dokome yaki pia. Dopa petala, malu pipenge kana tumbinya setapae mendenya yonge doko nyoo setapala, kana mende kapilya mina-mina pyoo malu kambu doko piti pia. ");
INSERT INTO enq2_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jisasanya yonge doko nyoo setea panda doko Maria Magadala tange dokopa, Josesa endangi Maria dokopa, dolapome kandeambi. ");
INSERT INTO enq2_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sambata gii doko pateamopa, Maria Magadala tange dokopi, Jemesa endangi Maria dokopi, Salomiapi, dutupame Jisasanya yonge doko kai pyala mona latala, wele tunduma pipae mendapu sambeami. ");
INSERT INTO enq2_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande gii dokonya yongama wamba, niki pyakaeteamopa, enda dutupa malu dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pao pituu nyakama-lapo laloo pyoo, “Malu kambu dokonya kana piti petae doko apimi kapilya mina-mina pyoo nyoo nepakalapepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dopa lao pupala kandeaminopa, kana doko kapilya mina-mina pyoo nyoo kapya latae katea. (Kana doko etete yale mende.) ");
INSERT INTO enq2_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Enda dutupame malu dokonya kolandatala, wane patange, yonge pee londe kyeo lapae pingi mende kingi tolaetena peteamo kandatala, walu leami. ");
INSERT INTO enq2_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dopa piaminopa baame enda dutupa lamaiyoo, “Nyakama walu nalalapape. Nasarete tange Jisasa, poko itanya pyao yukuiyamino doko nyakamame kutilyamino. Baa sakatatalamo. Baa dakenya nasilyamona, baa seteamino panda dake kanjepa. ");
INSERT INTO enq2_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nyakama langiamoli pyoo baa wambao Galali pelyamona, dokonya baa kanjaminona, nyakama pupala, Pitapi, disaipolo mendatupa dutupapi, dutupa lamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dokopa enda dutupa walu lao paka kaeyapala, malu dokonya kamaka pyakalyetala, paka peami. Dutupa paka kaeyami dokonya, mende lamaiya naeyami. ");
INSERT INTO enq2_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande gii dokonya yongama wamba Jisasa malunya sakatatala, Maria Magadala tange, wamba imambu koo kalange paleta mende, Jisasame watao pyakamaiyamo dokome wambao kandena lao panea. ");
INSERT INTO enq2_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Panateamopa wamba Jisasa-pipa kateami endakali dupa ee lao yamataka lao peteami dokonya enda doko pupala, pia dupa dokaita lamaiya. ");
INSERT INTO enq2_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jisasa lenge tao katamupa kanjona lao enda dokome lamaiyamo doko sepala, dokaitame kiningi lelyamona lao masala naeyami. ");
INSERT INTO enq2_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Maitakao disaipolo lapoma yuu yakane mendenya-kaita paanya peambinopa, dolapome nakandena lao Jisasa baa waka jetala apata peami. ");
INSERT INTO enq2_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Disaipolo dolapo pupala, pia dupa disaipolo mendatupa dutupa lamaiyambinopa, kiningi lelyambinona lao dutupame masala naeyamiaka. ");
INSERT INTO enq2_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Maitakao 11 disaipolo dutupa nee nao peteaminopa, Jisasa baa dutupame kandena lao panea. Baa sakatatala paneamopa kandeami endakali dupame kiningi lelyaminona lao disaipolo dutupame masala naenya, tuu pyoo mona kana jiaminosa, Jisasame dutupa pyalanya lea. ");
INSERT INTO enq2_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dopa latala baame dutupa lamaiyoo, “Nyakamame yuu dupa pitakanya pupala, Gotenya wasepae dupa pitaka wai pii epe doko lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Endakali mendeme wai pii epe doko kiningina lao masetala kaimbu nyetamo doko, baa pyoo nyeta. Dopaka doko, endakali mendeme wai pii epe doko kiningina lao masala naeyatamo doko, baa-kisa tenge setapala tanda maita. ");
INSERT INTO enq2_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wai pii epe doko kiningina lao masetami endakali dupame mirakolo andake datupa pitami: Dupame nambanya kenge dokonya imambu koo dupa watao pyata, pii tata waka dupa lata, ");
INSERT INTO enq2_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kanopato dupa kingimi minata pitami. Tomakai dupa natamino doko, dokome dokaita koeyasala naeyata. Endakali yaina pyapae dupa-kisa kingi setataminopa, yaina dupa mee jeta pitana” lea. ");
INSERT INTO enq2_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kamongome dokaita pii lamaitiamopa, Goteme baa kaiti-kisa lanyepala, baanya kingi tolaetena petena lea. ");
INSERT INTO enq2_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dokopa disaipolo dupame yuu dupa pitakanya pupala, wai pii epe doko lamaiyami. Lamaiyoo pituu, Kamongo-pipa mirakolo dupa piami dokome, baanya wai pii epe doko kiningina lao panasia. Doko kiningi. ");
INSERT INTO enq2_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Akali etete epe Tiopilusa, Goteme naimanya kaina dakenya kalai andake mendapu pia. Kalai pia dupa pitaka tee pyao dokonya pituu lengeme kandeaminoli pyoo, Gotenya pii lapae dokonya kalai akali dupame atome langiami. Atome dupa sepala, endakali longome makande pyoo pepa pyanya seteami dupa pitaka nambame itaki pyao kandakondape pyoo kandapu. Kandatala tata-tata dupa pitaka pyoo epeamoliaka pyoo yapao nyepala, embame atome soo mana nyii dupa pitaka kiningina lao kyeto joo masetale lao, dupa pitaka tolatala pepa pyanya setekelyo. ");
INSERT INTO enq2_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erote baa Judia yuu dokonya kiŋi katea gii dokopa, prisa Sakaraeya lenge mende katea. Baa prisa tata Abaija dokonya mende. Baanya etanenge Elisabeta lenge doko, prisa Aronenya mandipaenya mandipae mende. ");
INSERT INTO enq2_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaraeyapa, Elisabetapa dolapo lapotame Kamongonya mana setapaepi, loopi dupa pitaka wata-minao paeyambinopa, endakali mendeme dolapo koelyambinona laa naeya. Dokopa Goteme kandatala dolapo tolataena lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabetanya ingi kyeto jia dokonya, baa wane manja naeyaowaka peteamopa, Sakaraeyapa lapota lyanga jiambi. ");
INSERT INTO enq2_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gii mendepa Sakaraeya tata prisa dupanya kalai pipenge gii doko epeamopa, Gotenya enombanya Sakaraeya baa prisa kalai pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Dokopa apimi Kamongonya anda nee nyetae dokonya pauta tunduma pingi dupa yangala pena lamanape lao kanjanya, prisa dupanya mana singili pyoo kana pyasiaminopa, kana doko Sakaraeya-kisa ipao katea. ");
INSERT INTO enq2_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pauta tunduma pingi dupa yangapenge gii dokonya Sakaraeyame yangala peamopa, endakali kambu andake mende kamaka loma soo kateami. ");
INSERT INTO enq2_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dokopa Sakaraeyame kandena lao, Kamongonya enjele mende tunduma pingi yangenge alta dokonya kingi tolaetena ipao katea. ");
INSERT INTO enq2_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaraeyame enjele doko kandatala baa walu lao paka kaeya. ");
INSERT INTO enq2_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dokopa enjele dokome baa lamaiyoo, “Sakaraeya, emba paka nakaeyape. Embame loma sipi doko Goteme sepelyamona, embanya enda Elisabeta dokome wane ane mende manditana, wane dokonya kenge doko Jone lape. ");
INSERT INTO enq2_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wane doko mandipatamopa, emba eteke pyao mona yaepao katatenopa, endakali longo eteke pyaowaka katatami. ");
INSERT INTO enq2_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aipumape, baa Kamongonya enomba dokonya akali andake mende katata. Baa bia waenepi dupa etete nanao katata. Baa endanginya ingi andaka pituu, Oli Spirita doko baa-kisa tumbatae ipata. ");
INSERT INTO enq2_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Baame Israele tata longo nyakamanya Kamongo Gote doko-kisa pilyina latamopa pilyetami. ");
INSERT INTO enq2_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ilaijanya spirita dokopa, kyeto dokopa dolapo Jone-kisa palitamopa, akali tata mende Kamongonya depa lakamaiyanya Jone baa wambao ipata. Baa ipata doko, takange dupame nyakamanya wane dupa mona setena lao baame nyoo pyasalanya ipata. Endakali tolatae dupanya masepae epe dokonya katena lao, tanga lenge endakali dupanya mona kapilyakamaiyanya ipatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dopa leamopa Sakaraeyame enjele doko lamaiyoo, “Nambanya enda dokopa nalimba lyanga joo etapaena, embame pii lelyeno doko aipa petala nambame kiningina lao masotoape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Dokopa enjele dokome baanya pii yanu pyakamaiyoo, “Namba Gabriele, Gotenya enombanya katenge doko. Wai pii epe dake nambame emba langya puu lamusa langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gii setea dokonya nambame pii lelyo datupa angi jeta. Dopaka doko, embame nambanya pii datupa kiningina lao masala naelyeno dokonya, emba indupa pituu, pii nalao muumaa jetaeyaka katao pao, pii lelyo datupa angi jeta gii dokonya tuu latena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dopa lao kateambinopa, endakali kamaka kateami dupame Sakaraeya baa aipuma gii nepao, lotuu anda nee nyetae dokonya kalyape lao masepae longo nyoo malisoo kateami. ");
INSERT INTO enq2_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kateaminopa Sakaraeya kamaka pyakalyetala, baa nenge-kaita lyokeamosa, baame endakali dokaita pii lamaiya naeyamopa, baame lotuu anda nee nyetae dokonya mendita mende lee manemaneme kanjome-lamo lao dokaitame masiami. Dokopa baa muumaa joo katao, kingimi makande-makande pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Maitakao Sakaraeyanya prisa kalai pia gii doko etapeamopa, baa andaka pea. ");
INSERT INTO enq2_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gii mendatupa pateamopa, baanya enda Elisabeta doko wane tongota petea. Baa kana yungi yalo pyoo pituu dapa lao masia: ");
INSERT INTO enq2_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kamongome namba kondo kaeyao kandelyamo gii datupanya, endakali dupanya enombanya namba elya nyingi doko nyoo nepakatoo latala, dake namba-kisa pipya-lamona” lao masia. ");
INSERT INTO enq2_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabeta doko wane kana tokange latae peteamopa, Goteme enjele Gabriele yuu Galali, taono Nasarete lenge dokonya, wanaku mapukae mende petea dokonya pena lea. Wanaku dokopa, akali Josepe lenge, Kiŋi Dapita tatanya mandipae dokopa, dolapo andaka joo lakuu petengemba. Wanaku mapukae dokonya kenge doko Maria lenge. ");
INSERT INTO enq2_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enjele doko Maria petea dokonya ipupala lao pituu, “Emba Goteme auu kaengena, emba auu pyoo pitipi. Kamongo doko emba-pipa kalyambino. Goteme emba auu pisimupa, enda waka dupa pitaka embame ita minilyinona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dokopa Mariame enjele doko kandatala, auu pyoo pitipi lea pii doko aipale mende lelyape lao tatake kaeyapala masepae longo nyia. ");
INSERT INTO enq2_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dokopa enjele dokome baa lamaiyoo, “Maria, Gotenya auu kaenge doko emba-kisa silyamona, paka nakaeyape. ");
INSERT INTO enq2_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sepe! Emba wane tongota pitipala, wane ane mende manditina, wane dokonya kenge doko embame Jisasa lape. ");
INSERT INTO enq2_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Baa akali andake mende katatamopa, baa Gote Etete Ketae Katenge dokonya Ikiningina latami. Wane dokonya yumbange Dapitanya kiŋi petenge toko doko Kamongo Goteme wane doko maita. ");
INSERT INTO enq2_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Maitatamopa, baame Jekope tata dupa isoaka katatamopa, baanya kingdom doko tanga-tangapi etala naeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dopa leamopa Mariame enjele doko lamaiyoo, “Namba wanaku mapukae, akali tole napingina, embame pii lelyeno doko aipa petala angi jetape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dokopa enjele dokome baanya pii yanu pyakamaiyoo, “Oli Spirita doko emba-kisa ipatamopa, Gote Etete Ketae Katenge dokonya kyeto dokome emba sanga pyalapomo. Tenge dokonya, wane manditi doko Gotenya Ikiningi Makande Latae dokona latami. ");
INSERT INTO enq2_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Embanya tata Elisabeta, baa ingi kyeto jetae, wane namandipengena lengema doko, enda wambakesa wane ane kana tokange latae tongota pilyamo. ");
INSERT INTO enq2_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Goteme dopale mende pyaanya kokala naenge dokonya, Elisabeta baa wane tongota pilyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dopa leamopa Mariame lao pituu, “Namba Kamongonya kalai wanakuna, embame pii lelyeno doko namba-kisa epekena yaka-lumuna” lea. Dopa lateamopa enjele dokome Maria yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gii dosa mendasa Maria sakatatala, baa nee kaeyao Juda yuu dokonya manda singi dupanya taono mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pao Sakaraeyanya andaka kolandatala, “Elisabeta, emba auu pyoo pitipi” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariame auu pyoo pitipi lea doko Elisabetame siamopa, baanya inginya wane petea doko mangalyia. Dokopa Oli Spirita doko Elisabeta-kisa tumbia. ");
INSERT INTO enq2_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dokopa Elisabetame puu lao dapa lea: “Goteme emba auu pisimupa, enda waka dupa pitaka embame ita minilyino. Wane mende embanya inginya pilyamo doko, Goteme auu pisetae wane mende pilyamo. ");
INSERT INTO enq2_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nambanya Kamongo dokonya endangi dokome namba enda epe api-kaita kanja epe? ");
INSERT INTO enq2_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Embame auu pyoo pitipi lelyeno pii doko nambanya kaleme sipupa, nambanya inginya wane pilyamo doko eteke pyao mangalyilyamo. ");
INSERT INTO enq2_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kamongonya pii emba langia dupa angi jetana lao masiino wanaku doko emba Goteme auu pisetaena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dokopa Mariame lao pituu, “Nambanya moname Kamongo baa andakena lao, lao panelyo. ");
INSERT INTO enq2_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nambanya pyoo nyingi Gote doko nambame masetala, nambanya spiritame auu kaelyo. ");
INSERT INTO enq2_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Namba baanya kalai wanaku, kenge nasingi doko baame kandatala kondo kaeya. Indupa pituu endakali paliu patami dupa pitakame namba Goteme auu pisetaena latami. ");
INSERT INTO enq2_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gote etete kyeto dokome namba-kisa kalai andake mendapu pia. Baanya kenge doko eteteaka andake dokonya, mee laa naeyapenge. ");
INSERT INTO enq2_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Indupapi, tangapi baa paka kaeyao, paliu pelyami endakali dupa baame kondo kaenge. ");
INSERT INTO enq2_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kalai kyeto mendapu baanya kingimi pia. Endakali mendapu alyasale joo kalyamanona lao moname masiami dupa baame kyakasia. ");
INSERT INTO enq2_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiŋi pupu lapae dupa nyakamanya kiŋi toko dupanya napetena lao baame watao pyapala, kenge nasingi endakali dupanya kenge dupa minalyia. ");
INSERT INTO enq2_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Endakali lopo kaeyami dupa tiaka kaena lao nee epe dupa maitala, yuunya kamongo dupa daa jina lao mee pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Baanya kondo kaenge mana doko tanga-tangapi kame sala naeyatona latala, baanya kalai akali Israele doko nisia. Naimanya yumbange Abraamepi, baanya mandipaenya mandipaepi, dupa nisotona leali pyoo nisiana” Mariame lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Dopa latala, Maria baa kana tepomapi mende Elisabetapa pitipala, baanya andaka pilyia. ");
INSERT INTO enq2_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeta wane mandipenge gii doko epeamopa, wane ane mende mandea. ");
INSERT INTO enq2_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kamongome baanya kondo kaenge andake doko Elisabeta-kisa panasalamo lapae doko Elisabetanya tatapi, patali makipi dupame sepala, Elisabeta-pipa auu kaeyapae nyiami. ");
INSERT INTO enq2_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wane doko yuu gii tukulapo leamopa, yanu kepakamaiyanya endakali dupa ipupala, wane doko takangenya kenge Sakaraeya lamana leami. ");
INSERT INTO enq2_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dopa leamiaka doko, wane dokonya endangi dokome lao pituu, “Daa, baa kenge Jone lamanana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dopa leamopa dokaitame Elisabeta lamaiyoo, “Embanya tata dupanya mende kenge Jone lenge mende nakatengena” leami. ");
INSERT INTO enq2_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dopa latala wane dokonya takange dokome wane doko kenge api latoo lao masilyipi lao kingimi makande pyoo tipa piami. ");
INSERT INTO enq2_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dopa piaminopa, baame pepa pyapenge kana pata mende dina leamopa maiyami. Maitiaminopa baame, “Wane dokonya kenge doko Jone” lao pyanya katea. Dokopa endakali dokaita walu leami. ");
INSERT INTO enq2_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Walu leaminopa, Sakaraeyanya nenge-kaita lumbata, baanya keke doko tolata pia. Dokopa baame Gote mambo pyao baa iki auu petaena lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dopa pia doko, dokaitanya patali maki dupa pitakame kandatala paka kaeyami. Dokopa Judia yuu manda dupa pitakanya endakali dupame pia dutupanya pii lao kateami. ");
INSERT INTO enq2_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lapae siami endakali dupa pitakame lao pituu, “Wane dake aipale mende katatape” lao, pia dutupa nyakamanya moname masoo kateami. Dokopa Kamongonya kyeto doko wane doko-kisa sia. ");
INSERT INTO enq2_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wane dokonya takange Sakaraeya doko-kisa Oli Spiritame tumbiamopa, baame propesi pii lao dapa lea: ");
INSERT INTO enq2_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israelemanya Kamongo Gote dokome baanya tata dupa kanja ipupala sambao nyiamo dokonya, baa iki auu petae. ");
INSERT INTO enq2_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","71","Naimanya yandapipipi, naima imbu kaengemapi, dupanya kinginya naima pyoo nyina lao, Goteme baanya kalai akali Dapita tata dokonya pyoo nyingi akali kyeto mende epekena lea. Propeta Gotenya latae wamba kateami dupa-kisa dopa pitona leali pyoo epena lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dopa piamo dokome, Goteme naimanya yumbange dupa kondo kaeyapala nisoo, baanya pii yaki pinya setea doko masetaeyaka katea. ");
INSERT INTO enq2_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Pii doko naimanya yumbange Abraame lamaiyoo pituu, Goteme baanya pii doko kyeto tasalanya, baanya kenge doko lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Baame naimanya yandapipi dupanya kinginya pyoo nyetamopa, naima kalyamano gii dupa pitakanya paka nakaeyao baanya kalai pyakamaiyoo, mana tolatae dupa minao, baanya latae katataminopa lao pii doko lao yaki pinya setea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dopana, wane emba Gote Etete Ketae Katenge dokonya propetana latami. Tenge doko, embame wambao pupala, Kamongonya kaitini dupa depa lakamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kamongome baanya tata dupanya koo dupa kunao nepakamaita dokome, baame dokaita pyoo nyetana lao dokaitame masina lao embame lamaiti. ");
INSERT INTO enq2_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gotenya kondo kaenge andake dokome niki doko kaiti ketae pituu naima-kisa tapyala epena leamopa, ");
INSERT INTO enq2_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","iminjetaepa, kumingi dokonya waiyengepa, dolaponya kalyamino endakali dupa tii pisia. Dopa piamo dokome naima laminao mona setenge kaitini dokonya peana” Sakaraeyame lea. ");
INSERT INTO enq2_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wane doko andapala, baanya spirita doko kyeto jiamopa, endakali napalenge yuu mendakaita katao pao, Israele dupame baa kandena lao panea gii dokonya tuu lea. ");
INSERT INTO enq2_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gii dutupanya Sisa Agusatusame yuu pitakanya endakali dupa pitaka pepanya kenge pyao setena lao loo mende pyapala, yuu dupa pitakanya pyasia. ");
INSERT INTO enq2_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuriniusa baa yuu Siria dokonya gapena kateamopa, kenge pepa pyao setenge loo dupanya, loo doko tee pyao pia. ");
INSERT INTO enq2_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dokopa endakali yuu wakanya katengema dupa pitaka nyakamanya taono dupanya kenge setala peami. ");
INSERT INTO enq2_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josepe baa Dapita tatanya mandipae dokonyana, yuu Galali dokonya taono Nasarete katao, Judia yuu dokonya Dapitanya taono Betelema lenge dokonya lalyoo peaka. ");
INSERT INTO enq2_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maria doko Josepe nyetana latala, andaka joo lakuu petengemba dokonyana, baa wane tongota peteamopa, kenge setambana lao apata peambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Pupala peteambinopa, Marianya wane mandipenge gii doko epea. Dokopa Mariame baanya wane mupa, ane doko mandea. Mandipala endakali opone palenge anda dupa tumbiamosa, lapalapame ambo pyapala, kao nee nenge panda dokonya setapala isoo petea. ");
INSERT INTO enq2_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kuka gii dokopa sipisipi setao katenge mendapu yuu dokonya makisa dosa nyakamanya sipisipi dupa isoo kamalya kateami. ");
INSERT INTO enq2_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kateaminopa, Kamongonya enjele mende ipupala akali dupa-pipa kalyu piamopa, Kamongonya tii pipae andake dokome dokaita-kisa tii piyoko lea. Tii piyoko leamo doko akali dupame kandatala etete pakame kumiami. ");
INSERT INTO enq2_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dopa piaminopa enjele dokome dokaita lamaiyoo, “Nyakama paka nakaeyalapape. Wai pii epe mende nambame nyakama langya epelyo dake endakali dupa pitakame sepala eteke andake pyatami: ");
INSERT INTO enq2_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nyakama pyoo nyepenge Kamongo Kraisa doko Dapitanya taono Betelema dokonya indupa kuku gii dakepa mandipilyamo. ");
INSERT INTO enq2_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pii lelyo dake kiningina lao masalapale lao kongali petae dake nyakamame kanjamino: Wane doko lapalapame ambo pyatae, kao nee nenge panda dokonya silyamo doko kanjaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dokopa kaiti-kisa katenge amii longo mendapu ipao enjele doko-pipa kalyu petala, Gote mambo pyao dapa leami: ");
INSERT INTO enq2_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ketae kaitinya Gote doko kenge andake maingi mana doko sina. Isa yuu dakenya mona setao katenge mana doko sina. Endakali dupanya kainanya auu kaenge mana doko sinakana” leami. ");
INSERT INTO enq2_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dopa latala enjele dupame akali dupa yakinatala kaiti-kisa pateaminopa, sipisipi setao katenge dupame nyakama-lapo lao pituu, “Mende pyomo lao Kamongome naima-kisa panasalamo doko kanja yapa Betelema mua” leami. ");
INSERT INTO enq2_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dopa latala dokaita nee kaeyao pupala, Mariapi, Josepepi, wane kao nee nenge panda dokonya sia dokopi, dutupa kutao kandeami. ");
INSERT INTO enq2_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kandatala enjele dokome wane dokonya lao pii lamaiyamopa siami doko lao paneami. ");
INSERT INTO enq2_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sipisipi setao katenge dupame lamaiyaminopa siami endakali dupa pitaka walu leami. ");
INSERT INTO enq2_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dopaka doko, Mariame pii dutupa pitaka baanya monanya nyoo mandipala masoo petea. ");
INSERT INTO enq2_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisipi setao katenge dupa pilyoo pituu, enjele dokome lamaiyamo siamipi, pao kandeamipi, dupa kiningi-lamona latala, Gote kenge andake maiyoo mambo pyao pilyiami. ");
INSERT INTO enq2_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yuu gii tukulapo leamopa, wane dokonya yanu kepakamaiya. Dokopa baanya kenge doko Jisasa leami. Wamba Marianya inginya wane doko napeteamopa, enjele mendeme kenge lena lea dokoaka leami. ");
INSERT INTO enq2_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Mosesanya loo dupanya dapa lao pepa pyapae singi: “Enda mendenya wane ane wambao mandita doko Kamongonya lataena lapape” latae singi. Dopa lao pepa pyapae singili pyoo, yonge wasa pyao nepapenge gii doko epeamopa, wane doko Kamongo maiyanya endangi takangepame mandyoo Jerusalema peambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kamongonya loo dupanya lapae singili pyoo, yaka waeyamupi, yaka maiyolee ŋaŋapi, dupanya lapoma kundi maimbana lao nyoo peambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Akali Simione lenge mende Jerusalema katenge. Akali doko baa tolatae, Gote mambo pingi mende. Israele dupanya mona tambo lasepenge gii doko baame malisoo kateamopa, Oli Spirita doko baa-kisa katea. ");
INSERT INTO enq2_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Baame Kamongonya Kraisa doko kandatala kumatana lao Oli Spiritame baa-kisa panasia. ");
INSERT INTO enq2_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Spirita dokome Simionenya mona sakatasiamopa, baa lotuu anda nee nyetae kamapu dokonya pea. Mosesanya loo dupame pyepape lapae singili pyoo wane Jisasa dokonya pipenge dupa pyakamaiyanya, baanya endangi takangepa dolapome lotuu anda nee nyetae kamapu dokonya baa mandyoo peambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dokopa Simioneme wane doko kopyoo nyepala, Gote iki baa auu petaena lao mambo pyao pituu, ");
INSERT INTO enq2_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Akali Andake, embame dopa pitona lao pii leeno doko petelyeno dokonya, namba embanya kalai akali doko mona yaepao kumatale lao indupa yakinalene-lamo. ");
INSERT INTO enq2_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Akali tata dupa pitakanya enomba dupanya, embanya pyoo nyingi depa leeno doko nambame lengeme kandatelyo. ");
INSERT INTO enq2_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pyoo nyingi doko emba tata Israele dupanya tii pipae dokome, embanya masingi doko panasoo, akali tata waka dupa tii pisetana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simioneme Jisasanya lao pii lea dupa Josepepa, Jisasanya endangipa, dolapome sepala walu leambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Dokopa Simioneme dutupa auu pisia. Auu pisetala baame Jisasanya endangi Maria lamaiyoo, “Sepe! Israele longo mendapu isa pyakata, sakatata pitaminopa lao wane dake makande latae. Baanya pii tanga lenge endakali longo mendapuanya masingi yalo petae katenge dupa panasetamopa lao, baa kongali joo makande lataeyaka. Dopa latae dokonya, embanya mona auwa doko konjuwame kapu katatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gii dokopa propeta enda wambake Ana lenge mende petea. Baa Asaa tata dokonya Panuele wanenge. Wamba baa mapukae pituu akali nyepala, baanya akalingipa ee kana kalange peteambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Akalingi kumateamopa, baa walyakae petea. Baa ee kana 84 lea. Baame lotuu anda nee nyetae kamapu doko yakinala naeyao, kuka kotakapi Gote mambo pyao, nee nanao loma soo petenge. ");
INSERT INTO enq2_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simioneme pii dutupa lea gii dokopaka, Ana baa ipupala, Kamongo yaka pilyino lea. Dopa latala, mokao nyepenge gii doko ipatana lao malisoo Jerusalema katengema endakali dupa baame wane dokonya lao pii lamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mariapa Josepepa dolapome Kamongonya loo wata-minao pipenge dupa pitaka pyoo etapala, yuu Galali dokonya, nyakamanya taono Nasarete dokonya pilyiami. ");
INSERT INTO enq2_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pilyetala Nasarete katao, wane doko andapala, baanya spirita doko kyeto jiamopa, Gotenya masepae epe doko wane doko-kisa tumbia. Dokopa Gotenya auu kaenge doko baa-kisa sia. ");
INSERT INTO enq2_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ee kana dii lao, Pasopa nee nenge gii doko epelyamopa, Jisasanya endangi takangepa dolapo Jerusalema pengemba. ");
INSERT INTO enq2_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisasa ee kana 12 leamopa, nee andake nenge gii dokonya mana singili pyoo, Jerusalema lalyoo peami. ");
INSERT INTO enq2_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nee andake nenge gii doko etapeamopa, endangi takangepa dolapo andaka pilyiambinopa, wane kole Jisasa baa Jerusalema katao kaeya. Katao kaeya doko Josepepa, Jisasanya endangipa dolapome kanja naenya, ");
INSERT INTO enq2_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","baa endakali dupa-pipa pao pilyamano lao masetala, yuu gii mendai nepao kaita peambi. Pupala dolaponya tatapi, kaita miningipi dupa-pipa wane doko ipao kalyamipi lao kutiambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kutao kaeyapala wane doko kutao Jerusalema pilyiambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yuu gii tepo pateamopa, lotuu anda nee nyetae kamapu dokonya wane doko mana lenge dupanya kainanya pituu, pii leami dupa sepapu, tipa peta pyoo peteamopa dolapome kandeambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Baame pii leamopa siami endakali dupame baa masepae epe paliu, endakali dupanya tipa pipae dupa auu pyoo yanu pilyamona lao masetala walu leami. ");
INSERT INTO enq2_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Baanya endangi takangepa dolapome baa kandatala walu leambiaka. Walu latala baanya endangi dokome baa lamaiyoo, “Mamee, embanya takangepa nalimbame mona etete kenda kaeyao emba kutao paeyambanopa, emba aipuma katao kaeyapipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dokopa Jisasame dolapo lamaiyoo, “Aipuma nyakambame namba kutao paeyambi? Nambanya Takangenya anda dakenya namba katapengena lao masala naeyambipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dopa leamopa, dolapome baanya pii lea dokonya tenge doko soo nanyiambi. ");
INSERT INTO enq2_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Baanya endangi takangepa dolapo-pipa baa lanao Nasarete pupala, dolaponya pundipundi katea. Dokopa pia dutupa pitaka baanya endangi dokome monanya nyoo mandyoo petea. ");
INSERT INTO enq2_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisasanya yongepi, masingipi dupa pitakanya baa auu pyoo andeamopa, Goteme auu kaeyao, endakalimi auwaka kaeyao piami. ");
INSERT INTO enq2_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taibiriusa dokome ee kana 15 pyoo isia gii dokopa, Pondiasa Pailata baa Judia yuu dokonya gapena katea. Gii dokopa Eroteme yuu Galali isiamopa, Erote kaiminingi Pilipame yuu Ituriapa, Trakonaitusapa dolapo isia. Dokopa Laisaniasame yuu Abilini isiamopa, ");
INSERT INTO enq2_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasapa, Kaeyapasapa dolapo prisa mupa kateambi. Gii dokopa Sakaraeya ikiningi Jone doko endakali napalenge yuu mendenya kateamopa, Gotenya pii doko baa-kisa epea. ");
INSERT INTO enq2_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ipateamopa Jone baa endaki Jodane duu dokonya makisa yuu singi dupa pitakanya pupala, endakali dupanya koo dupa Goteme kunao nepekena, mona kapilyetala kaimbu nyalapa lao pii lamaiyoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dopa lao katatana lao Propeta Aisaiyanya buku dokonya dapa lao pepa pyapae singi: “Endakali napalenge yuu mendenya akali mende katapala wii lao, ‘Kamongonya kaitini doko depa lakamaiyepape. Kaitini koeyapae dupa tolasakamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Endaki duu dupa puu pyoo, yuu manda andakepi yakanepi dupa amao isa setao, kaitini wuanga pipae dupa tolasoo, kaitini koeyapae dupa tolasoaka pitaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Gotenya pyoo nyingi doko endakali dupa pitakame kandatamina’ leana” lapae singi. ");
INSERT INTO enq2_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Endakali kambu mendapu kaimbu pyekena lao epeami dupa Joneme lamaiyoo, “Nyakama koo kanopatonya mandipae! Gotenya imbu kaeyapae doko ipatana lao apimi nyakama langimusa paka epelyami? ");
INSERT INTO enq2_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Endakali mona kapilyetae dupame mana miningimali pyoo, nyakamame mana minalapape. Nyakamanya moname tee pyao dapa lao masala naeyalapape: ‘Abraame naimanya yumbange dokonyana, naima yaka kalyamanona’ lao masala naeyalapape. Nambame nyakama langilyo: Goteme kana silyamo dakaita Abraamenya wane jina lapyaliaka. ");
INSERT INTO enq2_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Indupa Goteme wua doko ita tenge dokonya depa lanya setapelyamo. Dii epe manja naenge ita dupa pitaka pokapala, baame itatenya soo yangatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dopa leamopa endakali kambu dupame baa tipa pyoo, “Dopa-tamo doko, naimame aipa pimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dopa leaminopa Joneme dokaitanya pii yanu pyakamaiyoo, “Yonge pee lapoma seta dokome, naseta endakali doko maipi. Nee napenge seta dokome, nee naseta endakali doko maipiaka” lea. ");
INSERT INTO enq2_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takisa nyingi mendapu apata kaimbu pyekena lao epeami dupame baa lamaiyoo, “Mana Lenge, naimame aipa pimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dopa leaminopa baame dokaita lamaiyoo, “Takisa nyalapape latae dutupa iki nyepala, nyakamame mendatupa konda pyoo nyala naeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dokopa amii mendapuame baa tipa pyoo, “Naimame aipa pimape?” leami. Dopa leaminopa baame dokaita lamaiyoo, “Nyakamame endakali mende pyalanya pyoo muni pake nanyalapape. Nyakamame endakali mendapuanya muni nyalanya, sambo kote laa naeyalapape. Nyakamanya yole nyingi dutupa yakana lao masalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dokopa endakali dupa pitakanya moname Jone baa Kraisa dokope lao masoo kateaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joneme dokaita pitaka lamaiyoo, “Nambame nyakama endakimi kaimbu pyekelyo. Dopaka doko, akali mende nambanya maitanya epelyamo dokonya kyeto dokome namba ita minilyamo. Baanya moko pee dolaponya kende tata lakamaiyanya, namba epe daa. Baame Oli Spiritapa, itate kaiyepaepa dolapome nyakama kaimbu pyakata. ");
INSERT INTO enq2_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Baanya yapenge sapolo doko kingimi minao epelyamo. Dokome wita angipi, imbupi pyasoo silyamo dupa yapatala, angi dupa nyoo baanya setenge anda dokonya setapala, imbu dupa itate tao konjala naenge dokonya yangatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dopa latala, kaitini longonya endakali dupanya mona yaka lasoo, wai pii epe doko lamaiyoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yuu Galali doko isingi Erote dokome baanya kaimininginya etanenge Erodiasa doko nyia dokonyapi, waka mana koo minia dupanyapi, dupa pitakanya koelyenona lao paa longosa Joneme baa pyalanya lao katea. ");
INSERT INTO enq2_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Dopa lao kateamosa, Eroteme Jone anjinya pyandea. Dopa pia dokome, Erotenya mana koo miningi dupanya konda pia. ");
INSERT INTO enq2_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Eroteme Jone anjinya pyandala naeyamopa, endakali epeami dupa pitaka kaimbu pyakamaiyamo dokonya, Jisasa apata kaimbu pyakamaiyaka. Jisasa kaimbu nyepala loma soo kateamopa, kaiti doko saa papa laloo pia. ");
INSERT INTO enq2_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dopa piamopa, Oli Spirita doko yaka maiyolee yonge nyepala, lanao ipao Jisasa-kisa petea. Dokopa kaiti-kisa katao pii mende lea dokome lao pituu, “Emba nambanya Ikiningi mona setenge doko. Nambame emba etete auu kaengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisasa baa ee kana 30 leamopa, baanya kalai tee pia. Dopa piamopa, endakali dupame baa Josepenya ikiningina lao masiami. Josepe baa Eli ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli baa Matate ikiningi. Matate baa Lipai ikiningi. Lipai baa Melekai ikiningi. Melekai baa Janaa ikiningi. Janaa baa Josepe ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josepe baa Matataeyasa ikiningi. Matataeyasa baa Emosa ikiningi. Emosa baa Nauma ikiningi. Nauma baa Esalai ikiningi. Esalai baa Nagai ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai baa Meata ikiningi. Meata baa Matataeyasa ikiningi. Matataeyasa baa Semene ikiningi. Semene baa Josepe ikiningi. Josepe baa Juda ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Juda baa Joanane ikiningi. Joanane baa Resa ikiningi. Resa baa Serubabele ikiningi. Serubabele baa Setele ikiningi. Setele baa Nerai ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai baa Melekai ikiningi. Melekai baa Adai ikiningi. Adai baa Kosame ikiningi. Kosame baa Elemodame ikiningi. Elemodame baa Era ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era baa Josee ikiningi. Josee baa Eliesa ikiningi. Eliesa baa Jorimi ikiningi. Jorimi baa Matate ikiningi. Matate baa Lipai ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai baa Simione ikiningi. Simione baa Juda ikiningi. Juda baa Josepe ikiningi. Josepe baa Jonane ikiningi. Jonane baa Eliakimi ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimi baa Melea ikiningi. Melea baa Mainane ikiningi. Mainane baa Matata ikiningi. Matata baa Naitane ikiningi. Naitane baa Dapita ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dapita baa Jesi ikiningi. Jesi baa Obeta ikiningi. Obeta baa Boasa ikiningi. Boasa baa Salomone ikiningi. Salomone baa Nasone ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasone baa Aminadape ikiningi. Aminadape baa Ramo ikiningi. Ramo baa Esorone ikiningi. Esorone baa Peresa ikiningi. Peresa baa Juda ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda baa Jekope ikiningi. Jekope baa Aisake ikiningi. Aisake baa Abraame ikiningi. Abraame baa Tera ikiningi. Tera baa Neo ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neo baa Seruka ikiningi. Seruka baa Riu ikiningi. Riu baa Peleke ikiningi. Peleke baa Epa ikiningi. Epa baa Sela ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela baa Kenane ikiningi. Kenane baa Apakasada ikiningi. Apakasada baa Seme ikiningi. Seme baa Noa ikiningi. Noa baa Lameke ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameke baa Metuselaa ikiningi. Metuselaa baa Enoko ikiningi. Enoko baa Jareta ikiningi. Jareta baa Malalele ikiningi. Malalele baa Kenane ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane baa Enosa ikiningi. Enosa baa Sete ikiningi. Sete baa Adame ikiningi. Adame baa Gote ikiningi. ");
INSERT INTO enq2_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisasa-kisa Oli Spirita tumbateamopa, baa endaki Jodane yakinatala pilyia. Dokopa Spirita dokome baa laminao endakali napalenge yuu mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Endakali napalenge yuu dokonya Jisasa yuu gii 40 katea dutupanya Sataneme baa makande pia. Gii dutupanya Jisasa baa nee nanao katea. Gii dutupa eteamopa baa lopo kaeya. ");
INSERT INTO enq2_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dokopa Sataneme baa lamaiyoo, “Emba Gote Ikiningi-tamo doko, embame kana silyamo dake breta jina laa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “ ‘Breta nenge dokonya-kaita iki endakali dupa saka nakatenge. Gotenya pii dupa pitakanya-kaita endakali dupa saka katengena’ lao pepa pyapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dokopa Sataneme baa laminao yuu manda ketae mendenya pupala, isa yuu dakenya kingdom dupa pitaka lee mendai kandena lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Kandena latala Sataneme Jisasa lamaiyoo, “Datupa isingi kyetopi, datupanya oapi epe muni andake pupengepi, dupa pitaka namba ditae. Nambame mende maitoo lao masoto doko maipenge. Dopana, emba luma lakapala namba mambo pyateno doko, dupa pitaka emba ditopa embanya jalapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Gotenya pii dokonya dapa lao pepa pyapae silyamo: ‘Embanya Kamongo Gote doko embame mambo pyao, baanya iki kalai pyakamaiyoo katape’ lapae silyamona, Satane, embame namba yakinatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Dopa lateamopa, Sataneme baa laminao Jerusalema pupala, lotuu anda nee nyetae dokonya etete ketae dokonya katena lea. Dopa latala baame Jisasa lamaiyoo, “ ‘Goteme emba masetala, baanya enjele dupame emba isoo katena latana’ lao pepa pyapae silyamo. Pii mendenya apata dapa lao pepa pyapae silyamoaka: ‘Embanya mokopi mende kaname tukutame-latala, enjele dupame emba kopyoo nyetamina’ lapae silyamo. Dopana, emba Gote Ikiningi-tamo doko, ketae dakenya katao isa mangau laa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “ ‘Embanya Kamongo Gote doko embame makande napipi’ lapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dokopa Sataneme baanya makande dutupa pitaka pyoo etapala, gii epe mende ipatamopa dee makande pitona lao masetala, Sataneme Jisasa yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dokopa Spirita dokome Jisasa kyeto maiyamopa, baa Galali pilyetala katea. Kateamopa, baanya lao pii lapae doko yuu makisa singi dupa pitakanya taeya. ");
INSERT INTO enq2_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Baame dokaitanya lotuu anda dupanya mana lamaiyamopa, endakali pitakame baa mambo piami. ");
INSERT INTO enq2_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dokopa Jisasa baa katao andea taono Nasarete dokonya epea. Ipupala baanya mana singili pyoo, Sambata gii dokonya lotuu andaka pupala, Gotenya pii dupa itaki pyao lamaiyanya toeya katea. ");
INSERT INTO enq2_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dokopa propeta Aisaiyanya pii pepa pyapae dupa lakapae singi doko baa maiyaminopa, baame pepa yoko lakapae doko tata latala, pii pepa pyapae singi dake kutao kandatala itaki pyao lamaiya: ");
INSERT INTO enq2_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Kamongome wele kai lao nambanya aiyomba minani pyekea dokonya, Spirita doko namba-kisa kalyamo. Tenge dokonya, nambame endakali daa jepae dupa wai pii epe doko lamaita, mona kenda kaeyao katatami dupa tambo lasakamaita, endakali yandanya wakuu nyepala anjinya palyetae dupa mokao nyepa, lenge monda dupanya lenge auu pisakamaita, endakalimi kenda pisilyaminopa kendanya katengema dupa mokao nyepa, Kamongonya kondo kaenge ee kana doko dakena lao, lao panata pyaa puu leana” lao Jisasame itaki pyao lamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lamaitala, pepa yoko doko lakapala, buku isingi doko maiya. Maitala peteamopa, endakali lotuu andaka dokonya peteami dupa pitakame baa iki lengeme kandatae siami. ");
INSERT INTO enq2_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dokopa baame dokaita tee pyao lamaiyoo, “Nambame Gotenya pii pepa pyapae singi dokonya itaki pyao langipupa kaleme silyamino doko indupa angi jilyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dopa leamopa, kondo kaenge dokonya lao baanya pii lea dupa walu lao sepala, dokaita pitakame baa lalyiami. Dopa petala nyakama-lapo laloo pyoo, “Akali dake Josepe ikiningi doko daape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dokopa baame dokaita lamaiyoo, “Kongali pii dake nyakamame namba langyamino: ‘Dokosa, embanya yaina doko emba tange mee jaa’ laamino. Dopa latala nyakamame namba langyoo, ‘Yuu Kapename dokonya kalai pilyino lapae simano dopale dupa embanya yuu dakenya pii’ laamino. ");
INSERT INTO enq2_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nambame nyakama kiningi langilyo: Propeta mende baanya yuu dokonya kalyamopa, endakali dupame baa auu kaeyao lanyala naengema. ");
INSERT INTO enq2_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nambame nyakama kiningi langilyo: Wamba Ilaija katea gii dokopa, ee kana tepo-kisa, kana tokange kaiti doko pai latae kateamopa, aiyuu naepea. Dokopa yuu dupa pitakanya lopo andake mende sia. Gii dokopa, Israele yuu dokonya enda walyakae longo mendapu peteami. ");
INSERT INTO enq2_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Peteamiaka doko, Goteme Ilaija baa enda peteami dupanya mendenya pena laa naeya. Yuu Saidone dokonya taono Sarepata dokonya enda walyakae mende petea dokonya pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Propeta Elisa katea gii dokopa, Israele yuu dokonya endakali kopetali longo kateami dupanya mendenya kopetali doko auu pisakamaiya naeya. Siria tange akali Namane lenge dokonya kopetali doko iki auu pisakamaiyana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dokopa lotuu andaka peteami endakali dupa pitakame pii dutupa sepala etete imbu kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Imbu kaeyao sakatatala, Jisasa watao pyao dokaitanya taono doko yuu manda mendenya singi doko yakinatala, papatale mendenya Jisasa tuu lanya pyandalanya piami. ");
INSERT INTO enq2_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dopa piaminopa, Jisasa baa endakali kambu dokonya kainanya kolanyetala pea. ");
INSERT INTO enq2_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Galali yuu dokonya Kapename siti dokonya Jisasa lanao pupala, Sambata gii dokonya endakali dupa mana lamaiyoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Baame pii kyeto dupame mana leamosa, endakali dupame sepala paka kaeyao walu leami. ");
INSERT INTO enq2_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dokopa akali imambu koo paleta mende lotuu andaka dokonya petea dokome puu lao wii lao, ");
INSERT INTO enq2_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nasarete tange Jisasa, embame naima yakinatala puu. Emba Akali Gotenya Latae doko nambame kandengena, embame naima aipa pyaa epe? Embame naima koeyasala epepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dokopa Jisasame baa pyalanya lao, “Embanya nenge-kaita lyokatala, akali dake yakinatala puu” lea. Dopa leamopa, imambu koo dokome akali doko koeyasala naenya, endakali kaina dupanya nyoo lombanya setapala baa yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dokopa endakali dupa pitaka paka kaeyao walu latala, nyakama-lapo laloo pyoo, “Pupu lapaepa, kyetopa dolapome imambu koo dupa pena lelyamopa, dokaitame endakali dupa yakinatala pengema-lamo doko, akali dakenya pii doko aipale mende laa-kanjemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dokopa yuu dosa makisa singi dupa pitakanya Jisasanya lao pii doko lao taeyami. ");
INSERT INTO enq2_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dokopa Jisasa sakatatala, lotuu anda doko yakinatala, Saimonenya andaka pupala andakote kolandea. Andaka dokonya Saimonenya enda imange doko yonge etete itaita piamopa yaina sia. Dokopa Jisasame enda doko nisetepe lao baa tee leami. ");
INSERT INTO enq2_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dopa leaminopa Jisasame enda doko yaina sia dosa katapala, yonge itaita pia doko mee jina leamopa, yaina doko mee jia. Mee julu piamopa, enda doko sakatatala, dokaita nee nyoo maiya. ");
INSERT INTO enq2_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Niki landa piamopa, endakali mendapuame yaina tata waka-wakame pyapae endakali longo mendapu laminao baa katea dokonya epeami. Dokopa Jisasame endakali yaina pyapae dupa pitaka-kisa kingi setapa piamopa, yaina dupa mee jeta pia. ");
INSERT INTO enq2_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dopa piamopa, imambu koo mendapuame endakali dupanya longo yakinatala pao pituu, “Emba Gote Ikiningi Kraisa dokona” lao puu lao leami. Dokopa, imambu koo dupame baa Kraisa dokona lao kandengema dokonyana, dupame pii laa naena lao baame daa lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yongama wamba, Jisasa baa yuu doko yakinatala, endakali napalenge yuu mendenya pea. Pateamopa, endakali kambu dupame Jisasa kutao kandatala, baa katea dokonya epeami. Ipupala, baa dokaita-pipa katamana latala minanjalanya piami. ");
INSERT INTO enq2_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dopaka doko Jisasame dokaita lamaiyoo, “Gotenya kingdom dokonya wai pii epe doko taono waka dupa pitakanya apata lamaipenge. Tenge dokonyaka Goteme namba puu leana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dopa latala baame Galali yuu dokonya lotuu anda dupanya wai pii epe doko lamaiyoo paeya. ");
INSERT INTO enq2_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gii mendepa Jisasa baa endaki Genesarete pete lemba dokonya katea. Kateamopa endakali kambu mendeme Gotenya pii doko semana lao ipupala, baa katea dokonya tuu-tuu lao katao kakopeami. ");
INSERT INTO enq2_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dopa piaminopa, sipi lapoma endaki pete lemba dokonya siamopa Jisasame kandea. Pisa nyingi akali dupame sipi dolapo minanya setapala, nyakamanya umbene dupa wasa pyao kateami. ");
INSERT INTO enq2_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dokopa sipi dolaponya mende, Saimonenya dokonya Jisasa pyakalyia. Pyakalyetala, Saimoneme sipi doko tuu lanya omosale pyasina lea. Tuu lanya pyaseteamopa, Jisasa baa sipi dokonya pituu endakali kambu doko mana lamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mana lamaiyoo etapala baame Saimone lamaiyoo, “Nyakamame pisa nyalapale, sipi dake minao endaki lumu omosa pupala, nyakamanya umbene dupa pyandalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dopa leamopa Saimoneme baanya pii yanu pyakamaiyoo, “Akali Andake, naimame kuka gii doko pitaka lekeleke tao kalai pyemanoaka doko, pisa mendaipi mende nanyalamano. Dopaka doko, embame lelyeno dokonya, umbene doko pyandatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dopa latala, dokaitame Jisasame leali piaminopa, pisa etete longo palea dokome umbene doko lapyalanya pia. ");
INSERT INTO enq2_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dopa piamopa, dokaitanya kalai tole pingima dupa, sipi mende dokonya peami dokaitame nisala epena lao kiango piaminopa, dupa ipupala nisiami. Dokopa sipi dolapo lapotanya pisame tumbia. Pisa dupa kenda pia dokome sipi dolapo endakinya nyoo landa pyalanya pia. ");
INSERT INTO enq2_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Pisa etete longo nyiamino dupa kandatala Saimonepi, endakali baa-pipa kateamipi, dupa pitaka pakame kumiami. Saimonenya kalai tole pingimba, Sebedi ikiningi Jemesapa, Jonepa dolapome kandatala pakame kumiambiaka. Dokopa Jisasanya moko setea dosa Saimone Pitame tombauli sepala lao pituu, “Kamongo, namba akali koo pingina, embame namba yakinatala puu” lea. Dopa leamopa Jisasame Saimone lamaiyoo, “Embame pisa nyingili pyoo, indupa pituu endakali nyatalena, emba paka nakaeyape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dopa lateamopa, dokaitame sipi dolapo minao endaki lemba dokonya setapala, dupa pitaka yakinatala, baa watao peami. ");
INSERT INTO enq2_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisasa siti dupanya mendenya kateamopa, akali kopetalimi koeyapae mendeme Jisasa kandatala, baa katea dosa ipao tombauli sepala, kyeto joo tee lao, “Kamongo, embame nambanya yaina dake mee jetala, pyoo wasepae kalyale lao maseteno doko, yaina dake mee jakatenopa, namba pyoo wasepae kalyapona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dopa leamopa, Jisasame akali doko kingimi watandatala lao pituu, “Emba pyoo wasepae kalyale lao masetala, nambame embanya yaina doko mee jina lelyona” lea. Dopa lalu piamopa, akali dokonya kopetali dokome baa yakinea. ");
INSERT INTO enq2_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dokopa, pia doko akali dokome mende lamaiya naena latala, Jisasame baa lamaiyoo, “Prisa dokome emba kandena puu. Pupala Mosesame mana seteali pyoo embame dopale mende Gote kundi maitinopa, endakali dupame emba pyoo wasepae kalyene-lamo lao kandenana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dopa leaka doko, Jisasanya kalai pia dokonya pii doko etete longo pyoo lao taeyaminosa, endakali kambu longo mendapuame Jisasanya pii doko sala ipata piami. Dokaitanya yaina dupa baame mee jekena lao epeamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dopa piaminopa, Jisasa baa endakali napalenge yuu dupanya pupala loma sepa pia. ");
INSERT INTO enq2_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gii mendepa, Jisasame endakali dupa mana lamaiyoo kateamopa, Parasipi, Mosesanya loo mana lengepi dupa yuu Galaliapi, Judiapi, Jerusalemapi dupanya yuu yakane dupa pitakanya katao ipupala peteami. Dokopa yaina mee jingi, Kamongonya kyeto doko Jisasa-kisa sia. ");
INSERT INTO enq2_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dopa piamopa, akali mendapuame akali papa tambutae mende Jisasa andakote katea dosa setamana lao lapa tokonya soo epeami. ");
INSERT INTO enq2_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ipupala kandeaminopa, endakali tumbia dokome baa soo kolandapenge nanjiamosa, dokaitame anda ketae soo pyakalyiami. Pyakalyetala, lapa toko dokonya kende katatala, akali doko paleta yame pyatae dokonya-kaita Jisasa katea dokonya, endakali dupanya kainanya lanao pyandeami. ");
INSERT INTO enq2_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dokopa akali dokaitame tungi piamino doko Jisasame kandatala, papa tambutae doko lamaiyoo, “Wane, embanya koo dupa kunao nepatae kalyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dokopa Mosesanya loo mana nyepaepi, Parasipi dupame masoo pituu, “Gote anda-anda semaiya naeyao lelyamo akali dake baa api? Endakali mendeme endakalinya koo dupa kapa pao kunao nepala naenge. Goteme iki endakalinya koo dupa kunao nepengena” lao masiami. ");
INSERT INTO enq2_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dopa lao masiami dupa Jisasame kandatala dokaita lamaiyoo, “Aipuma nyakamanya moname dopa lao masilyami? ");
INSERT INTO enq2_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Pii dalaponya anduku mee petala lapenge? ‘Embanya koo dupa kunao nepatae kalyenona’ lapenge dokope, pande, ‘Emba sakatatala kaita pae’ lapenge doko? ");
INSERT INTO enq2_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Akalinya Ikiningi dokome isa yuu dakenya katao, endakalinya koo dupa kunao nepenge kyeto doko baa-kisa singi-lamo lao kanjepalena” lea. Dopa latala baame akali papa tambutae doko lamaiyoo, “Emba sakatatala, embanya lapa toko doko nyoo soo andaka puu lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dopa lalu piamopa, endakali dokaitanya enombanya baa sakatatala, baanya lapa toko doko nyoo soo, Gote mambo pyao andaka pea. ");
INSERT INTO enq2_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dopa piamopa, endakali dupa pitaka etete walu lao paka kaeyapala, Gote mambo pyao lao pituu, “Napingi mendapu pimupa indupa naimame kandelyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Maitakao Jisasa kamaka pyakalyetala pao pituu, takisa nyingi Lipai lenge mende takisa nyingi anda dokonya peteamo kandatala baa lamaiyoo, “Emba namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dokopa baa sakatatala, baanya oapi dupa pitaka yakinatala, Jisasa watao pea. ");
INSERT INTO enq2_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lipaiyame baanya andaka Jisasanya nee andake mende yangakamaiyamopa, takisa nyingipi, endakali wakapi longo mendapu apata nee nao peteami. ");
INSERT INTO enq2_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Peteaminopa, Mosesanya loo mana nyepaepi, Parasipi dupame mumu lao Jisasanya disaipolo dupa lamaiyoo, “Nyakama aipuma takisa nyingipi, koo pingipi dupa-pipa nee endakipi nao pilyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Endakali yaina napingi dupa dokosa yangyala naenge. Endakali yaina pyapae dupa dokosa yangingi. ");
INSERT INTO enq2_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nambame endakali tolatae dupa wii lao nyalanya naepeo. Endakali koo pingi dupa mona kapilyina lao, wii lao nyalanya epeona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dokopa akali dokaitame Jisasa lamaiyoo, “Jonenya disaipolo dupame paa longosa loma soo nee nanao katengema. Parasi dupanya disaipolo dupame dopaka pingimana, embanya disaipolo dupa aipuma nee endakipi nao katengemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dopa leaminopa baame dokaita lamaiyoo, “Akali mende enda kelyapala watapae pyao, baanya tata dupa-pipa kalyamo gii dokopa, baanya tata dupa nee nanena lao nyakamame kaita lyokamilipi? ");
INSERT INTO enq2_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gii doko palitamopa, akali enda kelyenge doko nyoo patataminopa, baanya tata dupame loma soo nee nanao katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dopa latala baame kongali pii mende lao pituu, “Yonge pee atingi mende tii telyamopa, yonge pee enenge mendenya kangunyetala kii pimbala naenge. Kii pimbamana lao yonge pee enenge dokonya kangunyetami dokome, yonge pee enenge doko koeyasetami. Yonge pee enenge kangupae doko yonge pee atingi dokonya kii pimbatamino doko, yonge pee enenge kangupae dokopa, yonge pee atingi dokopa, dolapo mendai dopaleaka nanjeta. ");
INSERT INTO enq2_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Endakali mendeme waene enenge kamuu, penge meme yanungimi wasepae atingi mendenya pyandala naenge. Kamuu pyandatamo doko, waene enenge doko bolo lata dokome, penge atingi doko kanguu koeyasetamopa, waene dupa kai lao pata. ");
INSERT INTO enq2_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dopana, waene enenge doko penge enengenyaka kamuu pisepenge. Dopa pilyaminopa, waenepa, pengepa dolapo lapota koeyala naenge. ");
INSERT INTO enq2_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Endakali mendeme waene wambatae doko nao sulu petala, waene enenge doko natoo lao masala naenge. Waene wambatae dokome waene enenge doko ita minao etete auu petaena lengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sambata gii andake lapo pyoo dokonya Jisasa baanya disaipolo dupa-pipa wita ee mendenya-kaita peami. Dokopa baanya disaipolo dupame wita dii dupa kii lao nyepapu, kingimi kuku minata pyoo, dii dupa nyoo neami. ");
INSERT INTO enq2_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dopa piaminopa Parasi mendapuame dokaita lamaiyoo, “Sambata gii dokonya loome napipenge latae singi doko nyakamame aipuma pilyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Dapitapi, baa-pipa kateamipi, dupa lopo kaeyapala, baame pia doko nyakamame itaki napiamipi? ");
INSERT INTO enq2_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dapita lotuu anda nee nyetae dokonya kolandatala, breta Gote opaa maitae, mee endakali dupame nanapenge, prisa dupame iki napengena lao loome latae singi dupa nyepala, baa-pipa kateami dupa maiyoo neana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dopa latala Jisasame dokaita lamaiyoo, “Akalinya Ikiningi doko Sambata dokonya apata Kamongo kalyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sambata gii mendenyaka Jisasa lotuu anda dokonya kolandatala, endakali dupa mana lamaiya. Lotuu andaka dokonya akali kingi tolaetena talyanga mende petea. ");
INSERT INTO enq2_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Peteamopa Mosesanya loo mana nyepaepi, Parasipi dupame Jisasa-kisa tenge setamana lao masetala, Sambata gii dokonya kingi talyanga doko baame tolasakamailyape lao kandakondape petae peteami. ");
INSERT INTO enq2_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dokaitanya masiami dupa Jisasame kandatala, baame kingi talyanga doko lamaiyoo, “Emba sakatatala, endakali pitakanya enombanya kalya ipu” lea. Dopa leamopa akali doko sakatatala ipao katea. ");
INSERT INTO enq2_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kateamopa Jisasame dokaita lamaiyoo, “Nambame nyakama tipa mende pitoo: Loome aipa lapae singi? Sambata gii dokonya kalai epe pipengepe, pande koo pipenge? Endakali nisepengepe, pande endakali pyao kumasepengepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dopa latala, baame endakali dupa pitaka kandayoko latala, akali doko lamaiyoo, “Embanya kingi doko tinoko” lea. Dokopa akali dokome Jisasame leali piamopa, baanya kingi doko auu petala kingi yangi epe dopaleaka jia. ");
INSERT INTO enq2_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dokopa Mosesanya loo mana nyepaepi, Parasipi dupa imbumi etete tii lapala, Jisasa doko aipa pimape lao nyakama-lapo leami. ");
INSERT INTO enq2_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gii dosa mendasa Jisasa loma salanya yuu manda mendenya pea. Pupala Gote loma soo katao yuu yongasia. ");
INSERT INTO enq2_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yuu yongateamopa, baanya disaipolo dupa epena latala, dokaitanya akali 12 yapao nyepala, kenge aposole maiya. ");
INSERT INTO enq2_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Akali yapao nyia dutupanya kenge dupa: Saimone, Jisasame kenge mende Pita lea dokopi, Pitanya kaiminingi Andru dokopi, Jemesapi, Jonepi, Pilipapi, Batalomyuapi, ");
INSERT INTO enq2_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyuapi, Tomasapi, Alopiusa ikiningi Jemesapi, Selote tata dokonya katenge Saimone lenge dokopi, ");
INSERT INTO enq2_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemesa ikiningi Judasapi, yandapipi dupanya kinginya Jisasa maiya akali Judasa Iskariota lenge dokopi, dutupa yapao nyia. ");
INSERT INTO enq2_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisasa baa akali dutupa-pipa lanao pupala, yuu lamalama mendenya katea. Dokopa baanya disaipolo longo mendapu kambu pyao epeaminopa, Judia yuu yakane dupa pitakanya tangepi, Jerusalema tangepi, Taeyapa Saidonepa dolaponya solowata lembanya tangepi, dupa kambu pyao Jisasanya pii doko salanya ipaowaka, dokaitanya yaina dupa mee jekena lao ipaowaka piami. ");
INSERT INTO enq2_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dokopa endakali kenda pisia imambu koo dupa Jisasame watao pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kyeto baa-kisa paliu pyakalyia dokome endakali yaina dupa pitaka mee jakamaiyamosa, endakali kambu pyao kateami dupa pitakame baa kingimi watandalanya piami. ");
INSERT INTO enq2_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dokopa Jisasame baanya disaipolo dupa lengeme kandatala dapa lea: “Nyakama daa jepae dupa Goteme auu pisingi. Baanya kingdom doko nyakamanya. ");
INSERT INTO enq2_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nyakama indupa lopo kaeyao kalyamino dupa Goteme auu pisingi. Tanga nyakama tiaka kaeyao katatami. “Nyakama indupa ee lao kalyamino dupa Goteme auu pisingi. Tanga nyakama gii kaeyao katatami. ");
INSERT INTO enq2_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nyakamame Akalinya Ikiningi doko wata-minilyaminosa, endakali dupame nyakama imbu kaeyao, maita dyoo, pii koo lao, kenge koo dyoo pilyamino dokopa, Goteme nyakama auu pisingi. ");
INSERT INTO enq2_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dopana, nyakama dopa pitami gii dokopa, yole andake mende kaiti-kisa setekelyamona, nyakama eteke pyao mona yaepao kalyepape. Dokaitanya yumbange dupame propeta dupa dopaka piami. ");
INSERT INTO enq2_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Dopaka doko, nyakama yuunya kamongo dupa koeyatami. Nyakamanya mona tambo lasepenge dupa nyepelyamino. ");
INSERT INTO enq2_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nyakama indupa nee tiaka kaeyao kalyamino dupa koeyatami. Tanga nyakama lopo kaeyao katatami. “Nyakama indupa gii kaeyao kalyamino dupa koeyatami. Tanga nyakama yamataka lao ee lao katatami. ");
INSERT INTO enq2_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Endakali dupa pitakame nyakama lao pii epe lataminopa nyakama koeyatami. Dokaitanya yumbange dupame sambo propeta dupa lao pii epeaka leamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nyakama nambanya pii silyamino dupa dapa langilyo: Nyakamanya yandapipi dupa auu kaeyalapape. Nyakama imbu kaeyatami endakali dupa auu pisalapape. ");
INSERT INTO enq2_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nyakama Goteme koeyasina latami endakali dupa pii epe lamaiyepape. Nyakama pii koo latami endakali dupanya loma sakamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Endakali mendeme embanya wakena yangitena kingi kapeme pia-kandeno doko, yangitena apata pina maipi. Endakali mendeme embanya yonge pee kisa pingi doko nyia-kandeno doko, embanya yonge pee isa pingi doko apata nyina kaeyape. ");
INSERT INTO enq2_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Endakali mendeme emba-kisa dopale mende tee latamopa, embame maipi. Endakali mendeme embanya oapi mende nyia-kandeno doko, embame peekena laa naeyape. ");
INSERT INTO enq2_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Endakali waka dupame nyakamanya pyakamili lao masetami dopaka pyoo, nyakamame endakali waka dupanya pyakamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nyakama auu kaeyatami endakali dupaka nyakamame auu kaeyatamino doko, yole aipale mende nyetami? Endakali koo pingi dupame dopaka pingima. ");
INSERT INTO enq2_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nyakama auu pisetami endakali dupaka nyakamame auu pisetamino doko, yole aipale mende nyetami? Endakali koo pingi dupame dopaka pingima. ");
INSERT INTO enq2_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nyakamame yanu pyapae nyemana lao masetala dopale mende maitamino doko, yole aipale mende nyetami? Endakali koo pingi dupame koo pingi yango dupa yanu maitami dutupaka yanu pyapae nyetamana lao masetala yanu maingima. ");
INSERT INTO enq2_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nyakamanya yandapipi dupa auu kaeyao nisalapape. Dupame dopale mende tee lataminopa nyakamame maitala, yanu pyekena laa naeyalapape. Gote Etete Ketae Katenge dokome endakali koo pingipi, yaka pilyino lao mambo napingipi, dupa nisoo katenge. Nyakamame dopaka pitaminopa, Goteme nyakama baanya ikiningina latala, yole andake mende dita. ");
INSERT INTO enq2_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nyakamanya Takange dokome endakali dupa kondo kaengena, nyakamame endakali dupa kondoaka kaeyao kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nyakamame endakali dupa yapala naeyalapape. Dokopa Goteme nyakama yapala naeyataka. Nyakamame endakali mende-kisa tenge setapala baa koeyasepengena laa naeyalapape. Dopa pitaminopa, Goteme nyakama-kisa tenge setapala nyakama koeyasepengena laa naeyataka. Endakali mendapuame nyakama koo pingitami dupa kame sakamaiyepape. Dopa pitaminopa, Goteme nyakamanya koo pitami dupa kameaka sakata. ");
INSERT INTO enq2_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nyakamanya oapi dupa endakali dupa maiyepape. Dopa pitaminopa, Goteme makande mendai dokomeaka nyakama dita. Baame eteteaka longo lyanda-lyanda lao tumbasetamopa, nyakama-kisa eteteaka tumbatala kai lao patana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dopa latala Jisasame kongali pii mende lamaiyoo, “Lenge monda mendeme lenge monda yango mende kii minao yaka patape? Dolapo lapota kii minatae yulinya pyakala naeyatambipi? ");
INSERT INTO enq2_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mana nyingi dokome baanya mana lenge doko ita naminingi. Mana nyingi dokome mana nyoo etapala, baanya mana lenge dopaleaka joo katata. ");
INSERT INTO enq2_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Embanya lengenya ita lyoo andake sipya doko nakandao, aipuma embanya kaiminingi dokonya lengenya kuni yakane sipya doko kandakamailyi? ");
INSERT INTO enq2_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Embanya lengenya ita lyoo andake mende seta doko kanja naeyao, aipa petala embanya kaiminingi doko lamaiyoo, ‘Kaimii, embanya lengenya kuni yakane mende silyamona, nyakatoo kae’ late? Emba mana tolatae miningi manemane pingi dokome, wambao embanya lengenya ita lyoo andake silyamo doko nyoo nepape. Dokopa emba lenge auu pyoo tao, embanya kaiminingi dokonya lengenya kuni yakane seta doko nyoo nepakamaitina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ita epe dupame dii koo namandenge. Ita koo dupame dii epe namandengeaka. ");
INSERT INTO enq2_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ita mendenya dii mandelya dupa kandatala, ita doko dopale-lamo lao masingi. Ikililyambu kende dupanya piki dii lyilyamopa, endakali mendeme lyao nanyingi. Lyiki kende dupanya getepe dii lyilyamopa, lyao nanyingiaka. ");
INSERT INTO enq2_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dopaleaka joo, endakali epe mendeme baanya monanya mana epe palelya dokoaka miningi. Endakali koo mendeme baanya monanya mana koo palelya dokoaka miningi. Endakalinya monanya paliu tumbilya dokoaka kambunya pyakalyingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nyakamame nambanya pii doko wata-minala naelyamino doko, aipuma namba ‘Kamongo, Kamongo’ lelyami? ");
INSERT INTO enq2_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Endakali mende namba kalyo dokonya ipupala, nambanya pii dupa sepala wata-miningi doko dopalena lao nambame nyakama laitaka pitoo: ");
INSERT INTO enq2_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Endakali doko baa, akali mendeme baanya anda pyaanya, yuu kyeto mendenya muku minapala anda piamo dopale. Anda peteamopa, endaki andake lyepala anda doko piamopa, yuu kyeto mendenya petae dokonyana, emapi mende napia. ");
INSERT INTO enq2_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dopaka doko, nambanya pii doko sepala wata-minala naenge endakali doko baa, akali mendeme anda muku mende yuu kyeto mendenya minala naenya, mee yuu-kisa anda piamo dopale. Anda peteamopa, endaki andake lyepala anda doko piamopa, anda doko takyulu pia. Takiamo dokome, oapi dupa pitaka koeyana” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Endakali dupame siaminopa, Jisasame baanya pii dutupa lamaiyoo etapala, baa Kapename pao pyakamea. ");
INSERT INTO enq2_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Siti dokonya amii 100 isingi mende katenge dokonya kalai akali yakinala naeyapenge mende kumapenge joo yaina sia. ");
INSERT INTO enq2_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dokopa Jisasanya lao pii lapae doko amii 100 isingi dokome sepala, baanya kalai akali doko saka nyakala epena lao, Juumanya isingi akali mendapuame Jisasa lamaiyakala pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Dopa lateamopa, dokaita Jisasa katea dokonya pupala, akali doko saka nyala epena latala kyeto joo lamaiyoo, “Amii 100 isingi dokome naima Israele dupa auu kaeyapala, naimanya lotuu anda doko pyekea. Baa akali epe mendena, embame baa nisepoko” lao tee leami. ");
INSERT INTO enq2_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dopa leaminopa Jisasa baa dokaita-pipa anda dokonya tengesa pao pyakameaminopa, amii 100 isingi dokome baanya kaita miningi mendapu-kisa dapa lao wai lea: “ ‘Akali Andake, namba akali koo dokonya emba maka kaeyatena, nambanya andaka naipupi. ");
INSERT INTO enq2_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tenge dokonyaka, namba emba kanja naipupengena lao masetala naepelyona, embame piimi iki latenopa, nambanya kalai akali doko saka paapomo. ");
INSERT INTO enq2_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aipuma dopa lelyo? Nambanya isingi akali dokonya namba pundipundi katenge. Amii mendapu nambanya pundipundi katengemaka. Nambame dupanya mende pena lelyopa, baa penge. Dupanya mende epena lelyopa, baa epenge. Nambanya kalai akali mendeme kalai mende pina lelyopa, kalai doko pingina’ lamona” lao Jisasa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dokopa Jisasame akali dokonya pii dutupa pitaka sepala walu lea. Dopa petala, endakali kambu mendeme baa watao epeami doko enomba maitala lamaiyoo, “Nambame nyakama langilyo: Akali dakeme namba tungi pilyamoli pyoo, Israele mendeme namba tungi pyaminopa nambame nakandapuna” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pena leamopa peami akali dupa pilyoo andaka epeaminopa, kalai akali yaina pyapae doko auu pyoo kateamo kandeami. ");
INSERT INTO enq2_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yuu gii mende dokonya Jisasa taono Naina lenge dokonya peamopa, baanya disaipolo dupanya longopi, endakali kambu andake mendepi, dupa apata peami. ");
INSERT INTO enq2_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Taono dokonya lome kambu dokonya tengesa pyakameaminopa, enda walyakae mendenya ikiningi mendai iki doko kumapeamopa, akali mendapuame malu pyaa paanya soo epeami. Dokopa taono dokonya tange endakali longo enda doko-pipa epeamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Epeaminopa Kamongome endangi doko kandatala kondo kaeya. Kondo kaeyapala baa lamaiyoo, “Emba ee kae” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dopa latala, baa pupala lapa-toko doko kingimi miniamopa, wane kumapae doko soo epeami akali dupame sakatae kateami. Dokopa Jisasame lao pituu, “Wane, emba sakata lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dopa leamopa wane kumapae doko sakatatala, tee pyao pii lao petea. Dopa piamopa Jisasame wane doko baanya endangi doko maiyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dokopa endakali dupa pitakame paka kaeyapala, Gote mambo pyao, “Propeta andake mende naimanya kainanya sakatatelyamo! Goteme baanya tata doko kanja ipatelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisasame pilyamo lapae doko Judiapi, yuu makisa singipi, dupa pitakanya lao taeyami. ");
INSERT INTO enq2_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jisasame pia dutupa pitaka Jonenya disaipolo dupame baa lamaiyaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Joneme baanya disaipolo dupanya lapoma epena lea. Ipateambinopa, Jisasa katea dokonya pupala, baa lamaina lao dolapo lamaiyoo, “Emba akali mende ipatana latae singi dokope, pande naimame akali waka mende malisemape?” lao tipa pyaa pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pena lateamopa, dolapome Jisasa katea dokonya pao pyakamatala baa lamaiyoo, “Jone kaimbu pingi dokome emba katapi dakenya wai pii mende minao nalimba pupa lamo. Wai pii doko, ‘Emba akali mende ipatana latae dokope, pande naimame akali waka mende malisemape’ lao tipa pyaa pupa lamona” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Gii dokopa endakali yaina tata waka-wakame pyapae longo Jisasame mee jakamaita, imambu koo paleta endakali longo auu pisakamaita, lenge monda longo lenge auu pyoo tena lata pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dokopa Jisasame Jonenya disaipolo dolaponya pii yanu pyakamaiyoo, “Nyakamba pilyetala, kandelyambinopi, silyambinopi dupa Jone lamaiyepape. Lenge monda dupa lenge auu pyoo telyamino. Moko takyepae dupa kaita paelyamino. Kopetali dupa auu pisakamailyamo. Kaleketa dupame pii silyamino. Endakali kumapae dupa lenge tao kalyamino. Endakali daa jepae dupame sina lao wai pii epe doko lamailyamo. ");
INSERT INTO enq2_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dopana, namba mambele endakali mende isa pyakala naeyatamo doko, baa Goteme auu pisetae kalyamona lao Jone lamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dokopa Jonenya pii minao epeambi dolapo pilyeteambinopa, Jisasame endakali kambu dupa tee pyao Jonenya lao dapa lamaiya: “Nyakamame endakali napalenge yuu dokonya aki mende kanja peami? Kembo yokopi mende poome ema-ema piamo kanja peamipi, ");
INSERT INTO enq2_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","pande aki mende kanja peami? Akali mende yonge pee epe mendapuame yati petae kateamo kanja peamipi? Salapape! Akali yonge pee epeme yati petae dupame, muni andake pupenge dupa sambapala, auu kaeyao kiŋi dupanya andaka katengema. ");
INSERT INTO enq2_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dopa pingimana, nyakama peamino doko aki mende kanja peami? Propeta mende kanja peamipi? Kiningi propeta mendeaka kanja peamino doko, baa mee propeta mende daana lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Akali dokonya lao dapa lao pepa pyapae silyamo: ‘Salapape! Nambanya wai akali doko nambame wambao pena latopa, embanya kaitini doko depa lakatana’ lapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nambame nyakama langilyo: Endame mandipae endakali dupanya propeta mendeme Jone kaimbu pingi doko ita minao nakalyamo. Dopaka doko, endakali etete kenge nasingi mende, Gotenya kingdom dokonya kalyamo dokome Jone ita minao kalyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Pii soo kateami endakali dupa pitakapi, takisa nyingipi, dupa wamba Joneme kaimbu pyakamaiya dokonya, dupame pii doko sepala, Gote baa tolatae-lumuna leami. ");
INSERT INTO enq2_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parasipi, looyapi dupame Jonenya kaimbu doko nyala naenya kaeyami. Kaeyami dokome, Gotenya kalai dokaita-kisa pitoo lao masia doko daa leami.) ");
INSERT INTO enq2_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Dokopa Jisasame lao pituu, “Endakali indupa palelyamino dupa, aki mendepa nambame makande pyuu? Dokaita endakali aipale laa-kanjema? ");
INSERT INTO enq2_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Endakali dokaita wane kole dupa kamapu dupanya pituu kambu lapo pyatala, wii laloo pyoo, ‘Naimame pulupapunya wee pyakamanopa, nyakamame danisa laa naeyalamino. Naimame kondo kaeyao ee wee lenge dupa lakamanopa, nyakamame ee laa naeyalaminona’ lengema dopale jilyamino. ");
INSERT INTO enq2_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Dopaka pyoo, Jone kaimbu pingi doko ipupala, bretapi, waenepi dupa nanao kateamopa, nyakamame lao pituu, ‘Imambu koo mende baa-kisa palelyamona’ leami. ");
INSERT INTO enq2_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Indupa Akalinya Ikiningi doko ipupala bretapi, waenepi dupa namupa, nyakamame lao pituu, ‘Akali dake bretapi, waenepi dupa tiaka nakaeyao nao katao, koo pingipi, takisa nyingipi dupa kaita minao kalyamona’ lelyamino. ");
INSERT INTO enq2_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dopaka doko, masepae epe singi endakali dupa pitakame masepae epe doko dopalena lao panengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parasi mendeme Jisasa baa nee nambana epena leamopa, Jisasa pao Parasi dokonya andaka kolandatala nee nalanya petea. ");
INSERT INTO enq2_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dokopa Jisasa baa Parasi dokonya andaka nee nalanya ipao pilyamo lapae doko enda koo pingi mende siti dokonya petenge dokome sia. Sepala enda dokome penge mendenya wele tunduma pipae mende minao epea. ");
INSERT INTO enq2_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ipupala Jisasanya moko setea dosa katapala ee leamosa, ee ipange epea dokome Jisasanya moko dolapo tee pyao tombe lakamaiya. Dopa petala, enda dokome baanya aiyomba itimi moko tombe lea dolapo kunao nepatapu nunu pia. Dopa petala, moko dolapo wele kai lao kai pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dopa pia doko Jisasa epena lea Parasi dokome kandatala masoo pituu, “Enda doko koo pingina, akali dake kiningi propeta-pyali doko, baa watandelyamo enda doko dopalena lao baame kandapyalina” lao masia. ");
INSERT INTO enq2_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Akali dokome masiamo doko Jisasame kandatala baa lamaiyoo, “Saimone, nambame pii mende emba langitoo” lea. Dopa leamopa Saimoneme baa lamaiyoo, “Mana Lenge, laa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dokopa Jisasame lao pituu, “Muni yanu maingi akali mendeme akali lapoma muni yanu maiya. Mende doko silipa muni 500 maiya. Mende doko silipa muni 50 maiya. ");
INSERT INTO enq2_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akali dolapome yanu dutupa pyapenge nanjiamo kandatala, yanu dutupa lapota-kisa sina kaeya. Dopa pia-lumu dokonya, akali dolaponya andukumi baa etete auu kaeyape lao embame namba langi” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dopa leamopa Saimoneme yanu pyao, “Yanu andake sina kaeya-lumu akali dokome etete auu kaeyana lao nambame masilyona” lea. Dokopa Jisasame baa lamaiyoo, “Embame tolao yapatala lelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dopa latala baame enda doko enomba maitae katao Saimone lamaiyoo, “Embame enda dake kandelyepe? Namba embanya andaka ipupupa, embame nambanya moko wasa pyatale lao endaki nandyeno doko, enda dakeme baanya ee ipangeme nambanya moko tombe lasetakala, baanya aiyomba itimi kunao nepakalamo. ");
INSERT INTO enq2_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Embame namba nunu pyoo lanyala naeyaleno doko, namba andaka kolandalo dokopa, enda dakeme nambanya moko nunu pyomo doko kaeyala naeyao petae silyamo. ");
INSERT INTO enq2_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Embame nambanya aiyombanya olipi ipangeme kai napyakaleno doko, enda dakeme nambanya moko dolapo wele tunduma pipae mendeme kai pyakalamo. ");
INSERT INTO enq2_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tenge dokonya nambame emba langilyo: Enda dakenya koo longo dupa kunao nepatae pilyamo dokonya, baa auu andake kaelyamo. Dopaka doko, endakali mendenya koo kuki kunao nepatae kalyamo dokome kukiaka auu kaengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dopa latala Jisasame enda doko lamaiyoo, “Embanya koo dupa kunao nepatae pilyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dokopa akali baa-pipa nee nao peteami dupame tee pyao nyakama-lapo laloo pyoo, “Endakalinya koo dupa kunao nepakamaingi akali dake api laa-kanjemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dokopa Jisasame enda doko lamaiyoo, “Embame namba tungi pilyino dokome emba pyoo nyepelyamona, mona yaepatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Maitakao Jisasa baa sitipi, yuu yakanepi dupanya paeyao, Gotenya kingdom dokonya lao wai pii epe doko endakali dupa panao lamaiya. Dokopa 12 disaipolo dutupa apata paeyami. ");
INSERT INTO enq2_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Enda mendapu imambu koo paleamopa Jisasame watao pyakamaiya dupapi, yaina pyapae mendapu mee jakamaiya dupapi, dupa apata paeyamiaka. Enda dupanya mende doko Maria Magadalini lenge doko. Enda doko-kisa imambu koo kalange paleamopa, Jisasame watao pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Erotenya anda isakamaingi, Susa lenge dokonya etanenge Joanaa dokopi, Susanapi, enda waka longo mendapupi, dupa apata paeyamiaka. Enda dokaitame munipi, oapipi dupame Jisasapi, 12 disaipolopi dutupa nisoo apata paeyami. ");
INSERT INTO enq2_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Endakali longo mendapu taono dupanya katao ipupala, Jisasa katea dokonya kambu piami. Dokopa Jisasame kongali pii mende lao pituu, ");
INSERT INTO enq2_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ee pokenge mendeme baanya ee wai lyandala pea. Pupala lyandeamopa, ee wai yangi dupa kaitininya pao siamopa, endakali paeyami dupame moko katao nepeami. Moko katao nepatae dupa yaka ketae paenge dupame nao eteami. ");
INSERT INTO enq2_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ee wai yangi dupa kana-kisa yuu kuki singi dupanya pao sia. Sia dupa langa leaka doko, yuu dokonya endaki napalenge dokonyana dupa sapupala kumia. ");
INSERT INTO enq2_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ee wai yangi dupa lyiki tenge palenge dupanya pao sia. Sia dupa langa leaka doko, lyiki tambetambe andapala kui pyambea. ");
INSERT INTO enq2_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ee wai yangi dupa yuu epe dupanya pao sia. Sia dupa andapala dii 100 laowaka mandeana” lea. Pii dutupa latala baame puu lao, lao pituu, “Nambame pii lelyo dutupa endakali kale katenge dupame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisasanya disaipolo dupame baa tipa pyoo, “Kongali pii dokonya tenge doko akipi?” leaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","baame lao pituu, “Gotenya kingdom dokonya pii tenge yalo petae dupa masalapale lao nyakama ditilyamo. Dopaka doko, nambame kongali piimi endakali waka dupa lamailyo. Dupame lengeme kandatamiaka doko, tenge angi doko kandao nanyoo, pii kaleme setamiaka doko, tenge angi doko soo nanyoaka, masala naeyaowaka pina lao kongaliaka lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jisasame dokaita lamaiyoo, “Ee wai lyandeana lao kongali lalo dokonya tenge doko dake: Ee wai doko Gotenya pii doko. ");
INSERT INTO enq2_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ee wai yangi kaitininya pao siana lalo dokonya tenge doko dake: Endakali yangimi Gotenya pii doko sepala tungi pyataminopa, Goteme pyoo nyetame-lao Satane doko ipupala, pii doko monanya nasina lao nyoo nepenge. ");
INSERT INTO enq2_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ee wai yangi kana-kisa yuu kuki singi dupanya pao siana lalo dokonya tenge doko dake: Endakali yangimi pii doko sepala, auu kaeyao nyepala, gii kuki mendatupanya kiningina lao masingima. Dopaka doko, makande pipae epelyamopa, pii doko dokaita-kisa pingi pyala naenge dokonyana, dokaita isa pyakengema. ");
INSERT INTO enq2_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ee wai yangi lyiki tenge palenge dupanya pao siana lalo dokonya tenge doko dake: Endakali yangimi pii doko singimaka doko, dokaita kaita paeyao, yuu dakenya nee kaengepi, munipi, yongenya auu kaengepi dupanya mona setelyami dokome, dokaita kui pyambatala, dii mandelyami dupa wambu napingi. ");
INSERT INTO enq2_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ee wai yangi yuu epenya pao siana lalo dokonya tenge doko dake: Endakali yangimi pii doko auu kaeyao sepala, tenge angi doko nyoo monanya mandipala, yakinala naeyao dii mandyoo katengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Endakali mendeme lama kaiyepala, penge mendeme sanga pyambala naenge. Palenge toko mendenya pundipundi setala naengeaka. Endakali andaka kolandatami dupame tii pita doko kandena lao toko-kisa panao setenge. ");
INSERT INTO enq2_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yame pyatae silyamo dupa pitaka gii mendepa lopapae seta. Yalo petae silyamo dupa pitaka gii mendepa panapae setamopa, endakali dupame kandatami. ");
INSERT INTO enq2_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Longo lao singi endakali doko, baa konda pyoo maita. Nasingi endakali mendeme baa-kisa kuki silyamona lao maseta dutupa tange nyokonyeta. Dopana, nyakamame pii silyamino dupa aipa pyoo silyamape lao soo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gii dokopa Jisasanya endangi dokopi, kaiminingipi dupame baa kanja epeami. Dopaka doko, endakali longo kateami dokome, baa katea dosa pupenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dokopa endakali mendeme Jisasa lamaiyoo, “Embanya endangi dokopi, kaiminingipi dupame emba kandamana lao ipao kamaka kalyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dokopa baame dokaita lamaiyoo, “Gotenya pii doko sepala wata-miningi endakali dupa nambanya endangipi, kaiminingipina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yuu gii mendepa Jisasa baanya disaipolo dupa-pipa sipi mendenya pyakalyetala, baame dokaita lamaiyoo, “Naima endaki pete omotena mua” lea. Dopa lateamopa, dokaita sipi dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dokopa Jisasa baa luu palea. Palipiamopa poo yale mende lea dokome, endaki buli pyapala, tandyoo ipao sipi doko tumbia. Dopa pia dokome endakali dupa mangapenge jia. ");
INSERT INTO enq2_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dokopa dokaitame Jisasa palea dokonya pao pyale tatala baa lamaiyoo, “Akali Andake, Akali Andake, naima kumalamane-lamona” leami. Dokopa baa sakatatala, poo dokopa, endaki buli pia dokopa, dolapo kaena leamopa, poo doko yatu lao, endaki doko ema napyoo pia. ");
INSERT INTO enq2_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dokopa Jisasame dokaita lamaiyoo, “Nyakamanya Gote tungi pingi doko aipa pyaape?” lea. Dokopa dokaita paka kaeyao walu latala, nyakama-lapo laloo pyoo, “Endakipa, poopa dolapome mende pina lelyamopa, baanya pii sakamaingimba-lamo doko, akali dake api laa-kanjemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dokaita sipinya pituu, Galali omotena, Gadara tange dupanya yuu dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pupala Jisasa sipi doko yakinatala lembanya pyakameamopa, siti dokonya tange akali, gii longo imambu koo paleta katenge mendeme ipao baa kandanyia. Akali doko yonge peepi mende napyoo, anda mendenya palya naenya, endakali malu dupanya palenge. ");
INSERT INTO enq2_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Endakali baa isingima dupame sene kendepi, anengapupi dupame paa longosa baa anjeta pilyaminopa, imambu koo dokome baa kyeto joo lyaa minilyamopa, sene kendepi, anengapupi dupa pindao nepatala, endakali napalenge yuu dupanya penge. Jisasame akali doko-kisa imambu koo palea doko lamaiyoo, “Embame akali dake yakinatala puu” lea. Dopa lateamopa akali dokome ae latala, Jisasa katea dosa ipao tombauli sepala puu lao, lao pituu, “Gote Etete Ketae Katenge dokonya Ikiningi Jisasa, embame namba aipa piti? Embame namba tanda nandipi” lao tee lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dopa leamopa Jisasame baa tipa pyoo, “Embanya kenge doko api lengepe?” lea. Dopa leamopa akali doko-kisa imambu koo longo paleta dokonyana, baame lao pituu, “Nambanya kenge doko Amii Longo lengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dokopa imambu koo dokaitame nyakama yuli koo, mendasa soo etala naenge dokonya watao pyandala naena lao kyeto joo tee leami. ");
INSERT INTO enq2_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yuu dokonya manda kilikili mendenya mena kambu andake mende imu nao kateami. Dokopa imambu koo dokaitame nyakama mena kalyamino dokaita-kisa landa pyamana kaena lao kyeto joo tee leami. Dopa leaminopa, mena dupa-kisa landa pina lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dokopa imambu koo dupame akali doko yakinatala, mena dupa-kisa landa piami. Landa pyateaminopa, mena kambu doko papatale mendenya-kaita lanao alo pyao pupala, endaki pete dokonya mangatala kumiami. ");
INSERT INTO enq2_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mena setao kateami dupame piamo doko kandatala, siti dokonyapi, yuu yakanepi, dupanya paka pupala, piamo dupa pitaka endakali dupa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dokopa piamo dupa kanjanya endakali dupa Jisasa katea dokonya epeami. Ipupala imambu koo dupame yakineami akali doko yonge pee petala, mona paliu Jisasanya moko setea dosa peteamo kandatala paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pia doko wambao lengeme kandeami endakali dupame imambu koo palea akali doko dopa pyoo auu pisalamo lao lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dokopa Gadara dokonya makisa yuu singi dupanya tange dupa pitaka etete pakame kumapala, Jisasa baa yuu doko yakinatala pena leami. Dopa leaminopa Jisasa sipi dokonya pyakalyetala pilyia. ");
INSERT INTO enq2_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dopa piamopa, imambu koo dupame yakineami akali dokome baa Jisasa-pipa katambana buape lao kyeto joo tee lea. Dopa leamopa Jisasame baa pena latala lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Emba andaka pilyetala, Goteme embanya pyakalamo dupa lao panape” lea. Dokopa akali dokome baanya siti doko pitakanya paeyao, Jisasame baanya pyakamaiya dupa lao panea. ");
INSERT INTO enq2_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Endakali kambu pyao kateami dupa pitakame Jisasa ipapomo lao malisoo kateami dokonya, baa pilyiamopa dokaitame auu kaeyao lanyiami. ");
INSERT INTO enq2_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Dokopa lotuu anda isingi akali Jairusa lenge mende epea. Akali dokonya wanenge mendai iki, ee kana 12 latae doko etete kumapenge jiamosa, baa Jisasanya moko katea dosa ipao tombauli sepala, Jisasa baanya andaka epena lao kyeto joo tee lea. Dokopa Jisasa baa Jairusanya andaka paanya peamopa, endakali kambu dupame baa katao tambukiniami. ");
INSERT INTO enq2_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dokopa enda mende yuu gii dii lao andaka nao paliu, ee kana 12 pitaka petenge doko kambu dokonya katea. Enda dokome baanya muni sia dupa pitaka dokosa longo-kisa nepeaka doko, dokosa dupanya mendeme baanya yaina doko etasakamaiya naeya. ");
INSERT INTO enq2_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Enda doko Jisasanya maita-kaita ipupala, Jisasanya yonge pee punanya kingimi watandea. Watandalu piamopa baanya yaina doko etea. ");
INSERT INTO enq2_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dokopa Jisasame lao pituu, “Apimi namba watandelyape?” lea. Dokopa endakali dupa pitakame baa watandala naelyamanona leaminopa, Pitapi, baa-pipa kateamipi dupame lao pituu, “Akali Andake, endakali kambu dakaitame emba katao kakopatala tambukinilyamino doko” leami. ");
INSERT INTO enq2_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dopa leaminopa Jisasame lao pituu, “Namba-kisa kyeto sipya doko pyakala puumu lao silyona, endakali mendeme namba kingimi watandalumuna” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dokopa enda dokome pyoo doko yalo pyoo pyaa naeyalone-lumu lao masetala, baa walu lao putiti piamopa, Jisasa katea dosa ipao tombauli sia. Dopa petala baame Jisasa kingimi watandea tenge dokopa, baanya yaina doko pupae etea dokopa, dolapo endakali dupa pitakanya enombanya lao panea. ");
INSERT INTO enq2_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dokopa Jisasame baa lamaiyoo, “Wanenge, emba mona kenda nakaeyape. Embame namba tungi pyapi dokome, embanya yaina doko etelyamona, emba mona yaepatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Dopa lao kateamopa, lotuu anda isingi Jairusanya andaka katenge akali mende ipupala Jairusa lamaiyoo, “Embanya wanenge doko kumatalamona, Mana Lenge doko embame kenda pisoo epena laa naenya kae” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dopa leamopa Jisasame pii doko sepala Jairusa lamaiyoo, “Emba paka nakaenya, namba tungi pyape. Dopa pitinopa embanya wanenge doko saka paapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","54","Dopa latala, baa Jairusanya andaka pupala kandeamopa, endakali dupa pitaka yamataka lao ee lao kumanda peteami. Dokopa Jisasame dokaita lamaiyoo, “Wanaku doko kumala naeyalamo. Baa luu palelyamona, nyakama ee kaeyalapa” lea. Dopa leamopa, dokaitame wanaku doko kumatalamona lao masetala, baa lamba lao gii kaeyami. Dokopa Jisasame endakali dupa pitaka kamaka katena latala, Pitapi, Jonepi, Jemesapi, wanaku dokonya endangi takangepa dolapopi, dutupa iki laminao andakote kolandea. Kolandatala Jisasame wanaku dokonya kinginya minatala puu lao, lao pituu, “Wanaku, emba sakata” lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dopa leamopa, wanaku dokonya imambu doko pilyiamopa, baa pupae sakatea. Sakatateamopa Jisasame wanaku doko nee nena nyoo maina lea. ");
INSERT INTO enq2_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dokopa wanaku dokonya endangi takangepa dolapo paka kaeyao walu leambi. Piamo doko endakali mende lamaiya naena lao Jisasame kyeto joo daa lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Dokopa Jisasame 12 aposole dutupa epena latala, dutupame imambu koo dupa pitaka watao pyao, endakali yaina pyapae dupa mee jakamaiyoo pina lao dutupa kyeto maiya. ");
INSERT INTO enq2_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Maitala Gotenya kingdom dokonya lao pii lamaiyoo, yaina pyapae dupa mee jakamaiyoo pina lao pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dopa latala baame dokaita lamaiyoo, “Nyakama kaita paanya, pangalipi, nokainapi, bretapi, munipi mende nyoo napupape. Yonge pee isa pingi lapo lao nyoo napupapeaka. ");
INSERT INTO enq2_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyakama kolandatami anda dokonya iki katao, taono doko yakinatami gii dokonya tuu lapape. ");
INSERT INTO enq2_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Endakali mendapuame nyakama auu kaeyao lanyala naeyami-kandeno doko, endakali taono dokonya tange dupa-kisa tenge sipya-lamo lao kandena, taono doko yakinatala patami dokopa, nyakamanya mokonya yuu katata dupa lyanda lanya setapala pupape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dopa lamaitiamopa disaipolo dutupame yuu yakane dupa pitakanya paeyao, wai pii epe doko lamaiyoo, yaina pyapae dupa mee jakamaiyoaka piami. ");
INSERT INTO enq2_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jisasame pia dutupa pitaka Galali isingi Eroteme sepala, aipa pilyape lao tatake kaeya. Aipumape, endakali yangimi Jone kaimbu pingi doko malunya sakatapya-lamona leaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yangimi Ilaija doko ipao kalyamona leami. Yangi dupame propeta wamba kateami dupanya mende malunya sakatapya-lamona leami. ");
INSERT INTO enq2_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dopa leaminopa Eroteme lao pituu, “Nambame Jonenya aiyomba kepao nepeo doko, indupa akali mendenya lao pii dopale dupa laminopa silyo doko apipi?” lea. Dopa latala, Jisasa doko kandatoo latala, baame kaitini kutia. ");
INSERT INTO enq2_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisasanya aposole dupa pilyetala, dokaitame kalai piami dupa pitaka Jisasa lamaiyami. Lamaitiaminopa baame dutupa iki laminao, taono Betsaida lenge dokonya makisa, endakali napalenge yuu mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Baa pelyamo lapae doko sepala, endakali kambu dupame baa watao epeami. Ipateaminopa Jisasame dupa auu kaeyao lanyepala, Gotenya kingdom dokonya lao pii lamaitala, endakali yaina pyapae dupa mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Alemandi jalanya tee piamopa, 12 disaipolo dutupa ipupala Jisasa lamaiyoo, “Naima endakali napalenge yuu dakenya kalyamano dokonya, endakali kambu dake anda kutatamipi, nee sambao natamipi pima taono yakanepi, yuu yakanepi, makisa silyamo dupanya pena laa” leami. ");
INSERT INTO enq2_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dopa leaminopa Jisasame dutupa lamaiyoo, “Nyakamame dakaita nee nena maiyepa” lea. Dopa leamopa dutupame lao pituu, “Naimanya breta yungi-pipa, pisa lapo-pipa iki silyamo doko, endakali dakaita pitakanya nee sambakamaiya pupale lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Akali tausene yungipi mende kateami dokonya dopa leami.) Dokopa Jisasame disaipolo dutupa lamaiyoo, “Endakali dakaita 50 laowapi mende kambu pyao petena lapa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Leali pyoo, disaipolo dutupame endakali dokaita pitaka isa petena leami. ");
INSERT INTO enq2_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dokopa Jisasame breta yungi dutupapi, pisa lapo dolapopi, dutupa nyepala, kaiti-kisa kandalyetae katao yaka pilyino lea. Yaka pilyino latala, breta dutupa konjepala, baanya disaipolo dupame mokosoo endakali kambu doko maina lao maiya. ");
INSERT INTO enq2_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Maitiaminopa dokaita pitakame nao tiaka kaeyapala, kakana sina kaeyami dupa disaipolo dutupame nyoo baseketa 12 tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jisasa baa iki loma soo kateamopa, disaipolo dupa baa-pipa kateami. Dokopa baame dokaita tipa pyoo, “Endakali kambu dupame namba apina lelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dokopa dokaitame pii yanu pyao, “Yangimi emba Jone kaimbu pingi dokona lelyamino. Yangimi emba Ilaijana lelyamino. Yangimi emba propeta wamba kateami dupanya mende malunya sakatatala kalyeno lelyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dopa leaminopa baame dokaita lamaiyoo, “Endakali dupame dopa lalumino doko, nyakamame namba apina lelyamipi?” lea. Dopa leamopa Pitame yanu pyao, “Emba Gotenya Kraisa dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dopa lateamopa, Jisasame baa akali dokona lao endakali mende lamaiya naena lao kyeto joo daa lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dopa latala baame dapa lea: “Juumanya isingi akalipi, prisa mupapi, Mosesanya loo mana nyepaepi, dupame Akalinya Ikiningi doko maita maitaminopa baa pyao kumasepenge. Dokopa Akalinya Ikiningi doko tanda longo nao kumapatamopa, yuu gii tepo dokonya baa sakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dopa latala baame endakali dupa pitaka lamaiyoo, “Endakali mendeme namba watao ipatoo lao maseta dokome baa tange kame sepala, baanya poko ita doko tange nyoo soo namba watao ipupenge. ");
INSERT INTO enq2_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Endakali mendeme baa lete katatoana lao masetala, baa tange pyoo nyalanya pitamo dokome baanya lete katenge doko yakinata. Dopaka doko, endakali mendeme namba masetala, baanya lete katenge doko yakinata dokome baanya lete katenge doko pyoo nyeta. ");
INSERT INTO enq2_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Endakali mendeme yuunya oapi dupa pitaka nyoo setao katapala, baa alu pyoapi, baanya lete katenge doko yakinaowapi pitamo doko, oapi dupame baa aipa petala niseta? ");
INSERT INTO enq2_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Endakali mendeme nambapa, nambanya pii dokopa, dolapo lao panalanya elya kaeyatamo doko, Akalinya Ikiningi doko enjele Gotenya latae dupa-pipa, baanya tii pipae dokopa, Takange dokonya tii pipae dokopa, dolaponya pituu ipatamo gii dokopa, Akalinya Ikiningi dokome endakali doko kandatala baa elya kaeyataka. ");
INSERT INTO enq2_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nambame nyakama kiningi langilyo: Endakali asa kalyamino dapuanya mendapu kumala naeyao, Gotenya kingdom doko kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisasame pii dutupa lateamopa, yuu gii tukulapo joo pea. Pateamopa Jisasame Pitapi, Jonepi, Jemesapi dutupa laminao, yuu manda mendenya loma sala lalyoo pea. ");
INSERT INTO enq2_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pupala Jisasa loma soo kateamopa, baanya lenge-lyaapi doko waka jetala, baanya yonge pee dupa etete kyeo lao polepole pia. ");
INSERT INTO enq2_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Dopa piamopa, akali lapoma tii pipae andake mendenya tambetambe ipao kalyu petala, Jisasa-pipa pii leami. Akali dolapo Mosesapa, Ilaijapa. Pii leami doko, gii kuki mendalapo patatamopa, Jisasa baa Jerusalema pupala yuu dake yakinapenge dokonya leami. ");
INSERT INTO enq2_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitapi, disaipolo lapoma baa-pipa kateambi dolapopi, dutupa lemonguti leami doko, lenge kimbu petala kandeaminopa, Jisasa waka joo tii piyoko lea dokonya, akali lapoma baa-pipa kateambinopa kandeami. ");
INSERT INTO enq2_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Akali dolapome Jisasa yakinalanya piambinopa, Pitame Jisasa lamaiyoo, “Akali Andake, naima dakenya katamanopa auu pilyamona, naimame sele anda tepoma pimana. Mende embanya, mende Mosesanya, mende Ilaijanyana” lea. (Pitame pii lea dokonya tenge doko masala naeyao lea.) ");
INSERT INTO enq2_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitame pii dutupa lao kateamopa, kopa mende ipupala dutupa sanga pia. Sanga piamopa, kopa tambetambe dokonya disaipolo dutupa katao pakame kumiami. ");
INSERT INTO enq2_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dokopa pii mende kopa tambetambe epea dokome lao pituu, “Dake nambanya Ikiningi mona setenge dokona, nyakamame baanya pii doko sakamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pii doko lao eteamopa, Jisasa baa iki kateamo kandeami. Dutupame kandeami dupa gii dutupanya endakali mende lamaiya naeyami. ");
INSERT INTO enq2_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yuu gii mende dokonya dutupa manda doko yakinatala lanao epeaminopa, endakali kambu andake mendeme Jisasa kandanyiami. ");
INSERT INTO enq2_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dokopa kambu dokonya katao akali mendeme wii lao, “Mana Lenge, wane dake nambanya mendai ikina, embame baa kandakapoko. ");
INSERT INTO enq2_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Imambu koo mendeme baa lungu pisulu pilyamopa, baa ae lenge. Imambu koo dokome baa minao walumane pyasilyamopa, baa kambapupaka mandyoo koenge. Koteaka lao imambu koo dokome yakinala naeyao baa koeyasingi. ");
INSERT INTO enq2_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Dopa pingi dokonya, embanya disaipolo dupame imambu koo doko watao pyakamaina lao nambame kyeto joo tee lapupa, dupame kapa pao watao pyala naeyalaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dopa leamopa Jisasame yanu pyao, “Nyakama mana epe minala naeyao, Gote tungi pyala naeyaowaka pingima dupa, namba nyakama-pipa katao pao gii andukupa yakinato? Nyakama nongo pilyamino doko andukupa tolataminopa lao nambame malisoo katao? Embanya wane doko laminao asa ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Laminao ipateamopa, imambu koo dokome wane doko lombanya setapala walumane pyasia. Dokopa Jisasame imambu koo doko watao pyapala, wane doko auu pisia. Auu pisetala baame wane doko takange maiyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dokopa endakali dupa pitakame Gote etete yale doko paka kaeyao walu leami. Jisasame pia dupa pitaka endakali dupa pitakame walu lao kandeaminopa, Jisasame baanya disaipolo dupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nyakamame pii datupa kaleme sokondape pyoo salapape: Akalinya Ikiningi doko akali dupanya kinginya maiyanya pilyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pii dokonya tenge doko disaipolo dupame nanyiami. Pii doko yalo petae katea dokonya, baame pii lea doko auu pyoo masala naeyapala, pii dokonya baa tipa pyaanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dokopa disaipolo dupame nyakamanya api alyasale joo kalyape lao nyakama-lapo pii yanda piami. ");
INSERT INTO enq2_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dokopa Jisasame dokaitanya moname masiamino dupa kandatala, wane koo mende lanyepala, baanya patalitena katasia. ");
INSERT INTO enq2_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dopa petala baame dokaita lamaiyoo, “Endakali mendeme nambanya kenge dokonya wane koo dake auu kaeyao lanyilya dokome, namba lanyilyamosaka pingi. Endakali mendeme namba auu kaeyao lanyilya dokome, namba puu lea Akali doko lanyilyamosaka pingi. Dopana, nyakama pitakanya kainanya etete anasale joo katata endakali doko, baa eteteaka alyasale joo katatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dokopa Joneme baa lamaiyoo, “Akali Andake, akali mendeme embanya kenge dokonya imambu koo dupa watao pyamupa naimame kandatala, baa naima-pipa napaenge dokonyana kaena lamuana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dopa leamopa Jisasame baa lamaiyoo, “Nyakamame baa kaena nalalapape. Naima yanda pingyala naenge endakali dokome naima nisingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisasa kaiti-kisa lanyoo pupenge gii doko tengesa piamopa, Jisasa baa Jerusalema patoo latala masepae kyeto nyia. ");
INSERT INTO enq2_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kyeto nyepala baame wai akali mendapu wambao pena lateamopa, dupame baanya panda depa lakamaiyanya, Samaria tange dupanya yuu yakane mendenya peami. ");
INSERT INTO enq2_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dopaka doko, Jisasa baa Jerusalema paanya epelyamo lapae sepala, yuu dokonya tange dupame baa auu kaeyao lanyala naeyami. ");
INSERT INTO enq2_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dopa piami doko baanya disaipolo Jemesapa, Jonepa dolapome kandatala Jisasa lamaiyoo, “Kamongo, Ilaijame piali pyoo, nalimbame kaiti-kisa katao itate kaiyepae mende isa epena latala, endakali dokaita yangao nepena lapale lao masilyipi?” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dopa leambinopa, Jisasame kapilyetala dolapo pyalanya lao dapa lea: “Spirita mende nyakamba-kisa palelyamo doko dopalena lao nyakambame masala naelyambino. ");
INSERT INTO enq2_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Akalinya Ikiningi dokome endakali koeyasotoo latala naepea. Endakali pyoo nyotoo latala epeana” lea. Dopa latala, dokaita yuu yakane waka mendenya peami. ");
INSERT INTO enq2_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dokaita kaitinisa peaminopa, akali mendeme Jisasa lamaiyoo, “Kamongo, emba paeyate dupanya nambame emba watao ipatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dopa leamopa Jisasame baa lamaiyoo, “Yana kapu dupanya palenge yuli dupa singi. Yaka ketae paenge dupanya palenge anda dupa katenge. Dopaka doko, Akalinya Ikiningi dokonya palenge panda mende nasingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dopa latala baame akali waka mende lamaiyoo, “Emba namba watao ipu” lea. Dopa leamopa akali dokome lao pituu, “Kamongo, wambao nambanya takange malu petala patoo kae” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dopa leamopa Jisasame baa lamaiyoo, “Endakali kumapae dupame nyakamanya kumapae yango dupa malu pina emba kaeyapala, Gotenya kingdom doko lao panala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dopa lateamopa akali waka mendeme lao pituu, “Kamongo, nambame emba watao ipatoana, wambao nambanya andaka palengema dupa lasa laa patoo kae” lea. ");
INSERT INTO enq2_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dokopa Jisasame baa lamaiyoo, “Yuu amao pituu maita-kaita kandalyingi dokome Gotenya kingdom dokonya kapa pao kalai napingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Maitakao Kamongome akali 70 makande latala, lapo-lapo lao taonopi, yuu baa patoo lao masiapi, dupa pitakanya wambao pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pena latala baame dokaita lamaiyoo, “Nee longo wambu petamupa, kalai akali kuki kalyamino. Dopana, nee mandyoo mau pyapenge kalai akali mendapu peena lao, ee tange Kamongo doko kyeto joo loma salapape. ");
INSERT INTO enq2_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nyakama sipisipi ŋaŋa jepae dupa nambame yana kapu dupanya kainanya pupa lelyona pupape. ");
INSERT INTO enq2_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nyakamame kaita paanya, munipi, nokainapi, moko peepi mende nyoo napupape. Endakali mende kaitinisa kandanyetala pii lamaiyoo lasa nalalapape. ");
INSERT INTO enq2_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nyakama anda mendenya kolandatami dokopa wambao lao pituu, ‘Mona yaepenge doko andaka dakenya sina’ lao lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mona yaepenge dokonya ikiningi mende andaka dokonya pititamo doko, nyakamanya mona yaepenge pii epe lamaitami doko baa-kisa seta. Mona yaepenge dokonya ikiningi mende napititamo doko, mona yaepenge pii epe lamaitami doko nyakama-kisa pilyeta. ");
INSERT INTO enq2_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nyakama anda lyaa dii laa naenya, lanyetami andaka dokonya iki kalyepape. Akali kalai pita dokome yole nyepengena, endakali dupame nyakama nee endakipi dupa ditamili pyoo nao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Taono mendenya pataminopa nyakama lanyiami-kandeno doko, endakali dokaitame nee mokosoo ditamili pyoo nalapape. ");
INSERT INTO enq2_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yuu dokonya endakali yaina pyapae dupa nyakamame mee jakamaiyepape. Dopa petala dokaita lamaiyoo, ‘Gotenya kingdom doko nyakama-kisa tengesa ipatelyamona’ lapape. ");
INSERT INTO enq2_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nyakama taono mendenya pataminopa, endakali dupame nyakama lanyala naeyami-kandeno doko, nyakama taono dokonya kaitini dupanya pupala dapa lapape: ");
INSERT INTO enq2_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nyakamanya taono dakenya-tae naimanya mokonya yuu katapya dupa kunao nepelyamano dokome, nyakama-kisa tenge silyamona lao panasilyamano. Dopaka doko, pii dake auu pyoo masalapape: Gotenya kingdom doko nyakama-kisa tengesa ipatelyamona’ lapape. ");
INSERT INTO enq2_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Goteme endakali dupa yapatamo gii dokopa Sodomo tange dupa tanda andake maitaka doko, nyakamanya mokonya yuu kunao nepatami taono dokonya tange dupa tanda eteteaka andake maitana lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasina tange dupa nyakama koeyatami. Betsaida tange dupa nyakama koeyatamiaka. Nyakamanya taono dupanya mirakolo pio dupa Taeyapa, Saidonepa dolaponya pioli doko, siti dolaponya tange dupame yonge pee meme itimi wasepae dupa pyoo, kenai dupa aiyombanya pyasetala, isa pitipala, wamba mona kapilyiamili. ");
INSERT INTO enq2_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Goteme endakali dupa yapatamo gii dokopa Taeyapa, Saidonepa tange dupa tanda andake maitaka doko, Goteme nyakama tanda eteteaka andake dita. ");
INSERT INTO enq2_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nyakama Kapename tange dupa Goteme kaiti-kisa lanyoo patana lao masilyaminoaka doko, baame nyakama watao endakali kumapae dupa katengema panda dokonya pyandatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dopa latala baanya disaipolo dupa lamaiyoo, “Endakali mendeme nyakamanya pii silya dokome, nambanya pii doko silyamosaka pingi. Endakali mendeme nyakama maita dilya dokome, namba maita dilyamosaka pingi. Dopa pilya dokome, namba puu lea Akali doko maita mailyamosaka pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Akali 70 dutupa eteke pyao pilyetala lao pituu, “Kamongo, embanya kenge doko naimame leamanopa, imambu koo dupame apata naimanya pii sepala, leamali piamina” leami. ");
INSERT INTO enq2_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dokopa baame dokaita lamaiyoo, “Nambame Satane doko yuu-wapaka pili lao kaiti-kisa katao isa pyakeamo kandeo. ");
INSERT INTO enq2_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Salapape! Nyakamame nene koopi, kanopatopi dupa-kisa moko katao, nyakamanya yandapipi dokonya pupu lapae dupa pitaka ita minao pitaminopa lao nambame nyakama kyeto dilyo. Dopana, dopale mendeme nyakama koeyasala naeyata. ");
INSERT INTO enq2_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Dopaka doko, imambu koo dupame nyakamanya pii dupa sekelyaminona lao eteke pyala naeyalapape. Nyakamanya kenge dupa kaiti-kisa pepa pyapae silyamo dokonya eteke pyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Gii dokopaka Spirita dokome Jisasanya mona yaepasiamopa, baame lao pituu, “Apane, emba yuupi, kaitipi dupa pitakanya Kamongo. Mana longo kandenge endakalipi, mana longo nyepaepi, dupame dapale dupa nakandena lao yalo petala, wane koo joo katenge endakali dupame kandena lao embame panasiino dokonya nambame emba yaka pilyino lelyo. Apane, kiningi embame pitona lao auu kaengeme masiinoli pyoo piina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dopa latala baanya disaipolo dupa enomba maitala dokaita lamaiyoo, “Nambanya Takange dokome dupa pitaka namba-kisa setea. Endakali mendeme Ikiningi doko apipi lao masala naenge. Takange dokome iki masingi. Endakali mendeme Takange doko apipi lao masala naengeaka. Ikiningi dokome iki masingi. Takange doko endakali mendeme masina lao Ikiningi dokome masetala panasilyamopa, endakali dokome Takange doko masingiakana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dopa latala baanya disaipolo dupa enomba maitala elyakalao dokaita lamaiyoo, “Nyakamame kandelyamino dupa endakali mendeme kandatamo doko, baa Goteme auu pisetae. ");
INSERT INTO enq2_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nyakamame kandelyamino dupa, propetapi, kiŋipi, longo mendapuame kandamu laka lao masiamiaka doko, angi nakandeami. Pii nyakamame silyamino dupa simu laka lao masiamiaka doko, angi nasiamina lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dokopa looya mendeme toeya katapala Jisasa makande pyoo, “Mana Lenge, lete etete katenge doko nambame aipa petala nyotope?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dokopa Jisasame baa lamaiyoo, “Mosesanya loo dupanya aipa lao pepa pyapae silya? Tenge aipale mende dokonya silyamopa embame itaki pyao kandengepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dopa leamopa baame yanu pyao, “Embanya monapi, embanya imambupi, embanya kyetopi, embanya masingipi, dutupa pitakame embanya Kamongo Gote doko auu kaeyape. Emba tange auu kaengeli pyoo, embanya patali maki dupa auu kaeyape lapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dokopa Jisasame baa lamaiyoo, “Pii doko tolao yanu pilyinona, embame dopaka pyoo katateno doko, emba lete katatena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dopa leamo sepala, akali dokome baa tange tolataepe lao sotoo latala Jisasa lamaiyoo, “Nambanya patali maki dupa apitupape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dokopa Jisasame yanu pyao, “Akali mende Jerusalema katao, Jeriko paanya lanao pea. Peamopa pake nenge mendapuame kaitinisa kandanyetala, baanya yonge pee dupa lyokao nyepala, baa pyao indyepala, kumapenge joo sina latala peami. ");
INSERT INTO enq2_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dopa petala pateaminopa, prisa mende kaitini dokonya lanao ipupala, akali pyapae sia doko kandatala, baa lemba pyatala pea. ");
INSERT INTO enq2_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pateamopa akali Lipai mende panda dokonya ipupala, akali pyapae sia doko kandatala, dopaka pyoo baa lemba pyatala pea. ");
INSERT INTO enq2_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pateamopa akali Samaria tange mende kaitini dokonya epea dokome akali pyapae sia doko kandatala kondo kaeya. ");
INSERT INTO enq2_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kondo kaeyapala akali pyapae sia dosa pupala, welepi, waenepi dupame pyapae dupanya kai latala yaki pyakamaiya. Dopa petala, baanya dongi maita dokonya akali doko setapala, mandyoo endakali opone palenge anda mendenya pao setapala isoo katea. ");
INSERT INTO enq2_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yuu gii mende dokonya baa paanya pituu, anda isoo katenge doko baame silipa muni lapoma maitala baa lamaiyoo, ‘Embame akali dake isoo katape. Namba pilyoto dokopa, embanya muni wakao akali dake-kisa nepate dutupa yanu pyakatona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dopana, embame aipa lao masilyi? Pake nenge dupame kandanyetala pyanya seteami doko, akali tepoma epeami dutupanya andukumi baanya patali maki joo nisia-lumu lao masilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dokopa looya dokome lao pituu, “Akali kondo kaeyapala nisia-lumu dokona” lea. Dopa leamopa Jisasame baa lamaiyoo, “Emba pupala dopaka pipi” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisasa baanya disaipolo dupa-pipa kaitini pao, yuu yakane mendenya pyakameaminopa, enda Mata lenge mendeme Jisasa baanya andaka epena lao andiki pyoo lanyia. ");
INSERT INTO enq2_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Lanyoo ipateamopa, Mata kakingi Maria lenge doko Jisasanya moko setea dosa pitipala, baanya pii lea doko soo petea. ");
INSERT INTO enq2_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pii soo peteamopa, Matame nee akipi depa lao kalai longo piamosa, baa mona lombea. Dokopa Jisasa petea dosa Mata pupala baa lamaiyoo, “Kamongo, nambame iki nee depa laale latala, nambanya kakingi dokome namba yakinelyamo doko embame nakandelyepe? Namba nisina lamai” lea. ");
INSERT INTO enq2_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Mata, Mata, embame dopale longo dupa nee kaeyao masepae longo nyilyino. ");
INSERT INTO enq2_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dopaka doko, mendai iki mende nee kaeyapenge jilyamo. Mariame epe mende yapao nyepala pilyamo doko mendeme nyoo nepakamaiya naeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gii mendepa Jisasa yuu mendasa loma soo katea. Loma soo etapeamopa, baanya disaipolo dupanya mendeme baa lamaiyoo, “Kamongo, Joneme baanya disaipolo dupa loma sina lao mana lamaiyana, embame naima loma semana mana langipoko” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dokopa baame dokaita lamaiyoo, “Nyakamame loma setami dokopa, dapa lao loma salapape: ‘Naimanya Takange kaiti-kisa katenge, embanya kenge doko auu pyoo lapa lape. Embanya kingdom doko epena lape. Kaiti-kisa embanya masingili pingima, dopaka pyoo isa yuu dakenya pyepa lape. ");
INSERT INTO enq2_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yuu gii dii lao nee napenge dupa embame naima dipi. ");
INSERT INTO enq2_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Naima koo pingilyamino dupanya yanu dupa kaelyamanona, embame naimanya koo dupanya yanu dupa kaeyakape. Koo pyepale lao makande pingi dupanya naima laminao napupi. Koo akali dokonya kinginya embame naima pyoo nyepe’ lao loma salapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Dopa latala baame dokaita lamaiyoo, “Nyakamanya mende embanya kaita miningi dokonya andaka kuka andatombe pupala baa lamaiyoo, ‘Nambanya kaita miningi mende kuakama ipumupa, nee nena lao maipenge mende nasilyamona, breta tepoma yanu dii’ lateno doko, ");
INSERT INTO enq2_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","baame andakote paliu yanu pyao, ‘Namba kaita pai lanyetala, wane-pipa palenge toko dokonya palipilyona, namba sakatatala mende nandyapona, namba kenda pisala nae’ lata. ");
INSERT INTO enq2_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nambame nyakama langilyo: Akali dokome emba baanya kaita miningi doko breta tee late dupa nanditoo lao masetamoaka doko, emba elya nakaeyao kaita doko tuu pyoo gata-gata laowaka katatenosa, baa sakatatala, emba dopale yangita dupa nyepala dita. ");
INSERT INTO enq2_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Nambame nyakama langilyo: Tee lelyami endakali dupa pitakame nyingima. Kutilyami endakali dupa pitakame kutao kandengema. Anda kaita gata-gata lelyami endakali dupa pitakanya anda kaita lumbakamaingi. Dopana, nyakamame tee lataminopa nyakama ditana, tee lapape. Kutataminopa kutao kandatamina, kutalapape. Anda kaita gata-gata lataminopa lumbakatana, anda kaita gata-gata lapape. ");
INSERT INTO enq2_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Embanya wane dokome breta natoo latamopa, emba takange dokome kana mende nena lao maitipi? Baame pisa natoo latamopa, embame kanopato mende nena lao maitipi? ");
INSERT INTO enq2_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Baame yaka tuku mende natoo latamopa, embame nene koo mende nena lao maitipi? ");
INSERT INTO enq2_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nyakama koo pingima dupame nyakamanya wane dupa oapi epe maingi mana doko kandengema-tamo doko, nyakamanya Takange kaiti-kisa katenge dokome nyakama ita minao, baa-kisa tee latami endakali dupa Oli Spirita doko maitana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gii mendepa muumaa jisingi, imambu koo mende Jisasame watao pyateamopa, akali muumaa doko pii leamosa, endakali kambu dupa paka kaeyao walu leami. ");
INSERT INTO enq2_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dokopa endakali yangimi lao pituu, “Imambu koo dupanya isingi, Belesabulu dokonya pupu lapae dokome imambu koo dupa baame watao pilyamona” leaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","yangi dupame Jisasa makande pyoo, kaiti-kisa-tae mirakolo mende kandamana pina leami. ");
INSERT INTO enq2_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dopa leaminopa, Jisasame dokaitanya masiamino dupa kandatala dokaita lamaiyoo, “Isa yuu dakenya kingdom mendenya endakali dupa pyaloo petala wakale pitamino doko, kingdom doko koeyata. Anda mendenya palenge dupa pyaloo pitamino doko, dokaita kyeto joo nakatatamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Namba Belesabulumi pupu lapae dimupa, imambu koo dupa watao pilyinona lao nyakamame lelyamino doko, Satane baa wakale pyaloo petala, yanda pingi-tamo doko, baanya kingdom doko aipa petala seta? ");
INSERT INTO enq2_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Belesabulu dokonya pupu lapae dokome imambu koo dupa nambame watao pingi-tamo doko, nyakamanya tata dupame apinya pupu lapae dokome imambu koo dupa watao pingima? Nyakamanya tata dupameaka nyakama yapatami. ");
INSERT INTO enq2_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gotenya kyeto dokome imambu koo dupa nambame watao pingi-tamo doko, Gotenya kingdom doko nyakama-kisa ipao silyamosa pingi. ");
INSERT INTO enq2_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Akali pupu lapae, yanda yandatepi longo setenge mendeme baanya yuu andapi dupa kandao isoo kalyamopa, baanya oapi dupa auu pyoo singi. ");
INSERT INTO enq2_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dopaka doko, akali etete pupu lapae mendeme akali doko pyao ita minatala, akali dokonya yanda yandatepi, konambipi, tungi pingi dupa nyoo patala, akali etete pupu lapae dokome baanya tata dupa mokosoo maingi. ");
INSERT INTO enq2_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Namba nisala naenge endakali dokome namba yanda pingingi. Namba-pipa kambu pyala naenge endakali dokome endakali dupa tale pisingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Imambu koo mendeme endakali mende-kisa paliu pyakalyetala, endaki naepenge yuu dupanya koto nyoo katapenge panda kutao paenge. Kutao kaeyapala baame lao pituu, ‘Nambame anda wamba yakineo dokonya pilyotoo’ lenge. ");
INSERT INTO enq2_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dopa latala, imambu koo dokome pilyetala kandelyamopa, anda doko kuni nasoo, auu pyoo wasetae katenge. ");
INSERT INTO enq2_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dokopa baa ita minao imambu etete koo kalange mendatupa lanyepala, anda dokonya kolandatala katengema. Dokopa, wamba akali doko kopeta katengeaka doko, imambu koo dutupa baa-kisa ipao palelyaminopa, baa etete kopeta katengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisasame pii dutupa lao kateamopa, endakali kambu dokonya enda mende katea dokome puu lao baa lamaiyoo, “Embanya endangi, emba mandipala andu dia doko, Goteme auu pisetaena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dopa leamopa Jisasame baa lamaiyoo, “Embame pii lelyeno doko dapa pyoo lapenge: Gotenya pii doko sepala wata-miningima dupa Goteme auu pisetae lapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jisasa katea dokonya endakali longo ipao kambu piaminopa, baame lao pituu, “Endakali indupa palelyamino dupa koo pingima. Dupame mirakolo mende kandamana nambame pii lelyaminoaka doko, propeta Jona-kisa mirakolo pia doko iki makande petae silyamona, mirakolo waka mende nakanjamino. ");
INSERT INTO enq2_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ninipe tange dupame kandena lao Jona-kisa mirakolo mende pia. Dopaka pyoo, endakali indupa palelyamino dupame kandena lao Akalinya Ikiningi doko-kisa mirakolo mende pitaka. ");
INSERT INTO enq2_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kuini enda kingi tolaetena tange dokome yuu londati-waka pituu, Solomonenya masepae epe dupanya pii dupa nyotoo lao epea. Salapape! Mendita mendeme Solomone ita minao asa silyamo. Tenge dokonya, Goteme endakali dupa yapatamo gii dokopa, kuini enda kingi tolaetena tange doko akali indupa palelyamino dupa-pipa sakatatala, dupa tenge setapala tanda maipengena lata. ");
INSERT INTO enq2_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Joname akali Ninipe tange dupa Gotenya pii doko panao lamaiyamopa, dokaitame sepala mona kapilyiami. Salapape! Mendita mendeme Jona ita minao asa silyamo. Tenge dokonya, Goteme endakali dupa yapatamo gii dokopa, Ninipe tange dupa endakali indupa palelyamino dupa-pipa sakatatala, dupa tenge setapala tanda maipengena latamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Endakali mendeme lama kaiyepala, panda yalo petae mendenya setala naenge. Baseketa mendenya koko setala naengeaka. Endakali andaka kolandatami dupame tii pita doko kandena lao toko-kisa panao setenge. ");
INSERT INTO enq2_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lenge doko yongenya lama doko. Dopana, emba lenge mendai iki tao katateno doko, embanya yonge doko pitaka tii pipaeme tumbatamopa katate. Dopaka doko, emba lenge lapo tao katateno doko, embanya yonge doko pitaka iminjetaeme tumbatamopa katate. ");
INSERT INTO enq2_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dopana, emba-kisa tii pipae silyamo doko iminjetana, kandao isoo katape. ");
INSERT INTO enq2_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Embanya yonge doko pitaka iminjetae nakatenya, tii pipaeme iki tumbatamopa katateno doko, lama kaiyepaeme emba tii pisingili pyoo, embanya yonge doko pitaka tii pisetana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisasa pii lao kateamopa, Parasi mendeme nee nambana lao epena lea. Dopa lateamopa, baa pao andaka kolandatala nee nalanya petea. ");
INSERT INTO enq2_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pitipala nee nalanya wambao kingi wasa pingi doko napiamopa, Parasi dokome kandatala walu lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dokopa Kamongome Parasi doko lamaiyoo, “Indupa nyakama Parasi dupame nyakamanya kapopi, pelesapi, ketaetena iki wasa pilyaminoaka doko, nyakamanya kokotena pake nenge dokopa, koo pingi dokopa, dolapome tumbatae kalyamo. ");
INSERT INTO enq2_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nyakama kyakaenge! Ketaetena wasiamo akali mendai dokomeaka kokotena apata wasala naeyape? ");
INSERT INTO enq2_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nyakamame mona katao endakali daa jepae dupa maiyepape. Dopa pitaminopa, nyakamanya oapi dupa pitaka kaimala napita. ");
INSERT INTO enq2_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nyakama Parasi dupa koeyatami. Nyakamame takaepi, itamaiyapi, sakaenge tata waka dupa pitakapi, dupa malu akalita mokosoo setapala, dutupanya malu mendai Gote maingima. Dopa pingimaka doko, mana epeme endakali tolasingi dokopa, Gote auu kaenge dokopa, dolapo nyakamame yakinengema. Nyakamame mana dolapo wata-minao katao, mana waka dupa yakinala naeyapenge. ");
INSERT INTO enq2_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nyakama Parasi dupa koeyatami. Lotuu anda dupanya nyakama enomba nyoaka pitimu laka lao masingima. Maketa dupanya endakali dupame nyakama mambo pyao kingi nyimi laka lao masingimaka. ");
INSERT INTO enq2_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mosesanya loo mana nyepaepi, Parasipi, dupa nyakama koeyatami. Endakali malu yuu koko yalo pyoo petae dopale joo nyakama kataminopa, endakali dupame nakandao ketae moko katao paelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dopa leamopa looya dupanya mendeme yanu pyao, “Mana Lenge, embame pii dutupa lapi dokome, naima apata pii koo lelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dokopa Jisasame lao pituu, “Nyakama looya dupa apata koeyatami. Kenda lekeleke tao sepenge dupa nyakamame endakali dupanya lataiyanya nyoo setakamaingima. Dopaka doko, nyakamanya kingi konde mendaipi mendeme kenda dupa watandala naengema. ");
INSERT INTO enq2_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nyakama koeyatami. Nyakamanya yumbange dupame propeta mendapu pyao kumasiami dupanya malunya nyakamame anda pyakamaingima. ");
INSERT INTO enq2_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dopa pilyami dokome, nyakamanya yumbange dupame piami dupa yaka piamina lao, lao panelyaminosa pingi. Nyakamanya yumbange dupame propeta dupa pyao kumaseteaminopa, malu dupanya nyakamame anda pyakamaingima. ");
INSERT INTO enq2_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tenge dokonyaka Gotenya masepae epe dokome dapa lea: ‘Nambame propetapi, aposolepi mendapu endakali dupanya kainanya pena latopa, endakali dupame yangi dupa pyao kumasetala, yangi dupa tanda maiyoo koeyasetamina’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Endakali indupa palelyamino dupame dopa pitami dokome, yuupa kaitipa dolapo tee pia dokonya pituu, propeta pyao kumasiami dupa pitakanya taeyoko kai lea dupanya tenge dupa endakali indupa palelyamino dupa-kisa ipata. ");
INSERT INTO enq2_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelenya taeyoko kai lea gii dokonya pituu, lotuu anda nee nyetae dokopa, alta dokopa, dolaponya kainanya kumia akali Sakaraeya dokonya taeyoko kai lea gii dokonya tuu lao, dokaitanya tenge dupa endakali indupa palelyamino dupa-kisa ipatana lao nambame nyakama kiningi langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nyakama looya dupa koeyatami. Masepae epe dokonya kii doko nyakamame nyokonyetelyamino. Masepae epe dokonya nyakama kolandala naenya, endakali kolandalanya pilyamino dupa nyakamame kaita lyokelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisasame pii dutupa dokaita lamaiyoo kateamopa, pii kopeta mende latamopa, baa-kisa tenge setamana latala, Mosesanya loo mana nyepaepi, Parasipi dupame pii longo lena lao tee pyao kyeto joo ingi tuu leami. ");
INSERT INTO enq2_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gii dokopa, endakali tausene longo ipao kambu piami dokome, endakalinya moko yango-kisa katao lombapae siami. Dokopa Jisasame tee pyao baanya disaipolo dupa lamaiyoo, “Parasi dupame mana tolatae miningi manemane pingima doko yisa palaonya taengeli pyoo nyakama-kisa taeyatana, kandao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sanga pyatae silyamo dupa pitaka gii mendepa lopapae seta. Yame pyatae silyamo dupa pitaka gii mendepa lopapae setamopa, endakali dupame kandatami. ");
INSERT INTO enq2_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nyakamame yuu iminjumupa pii lelyamino dupa pitaka, tii pitamopa endakali dupame setami. Andakote rumanya pituu pii kakateame lelyamino dupa, endakali dupame anda ketae katao wii lao latamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nambanya kaita miningi paluma, yonge doko pyao kumasingima endakali dupame mende apata kapa pao napipengena, dupa nyakamame paka nakaeyalapape. ");
INSERT INTO enq2_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Akali paka kaeyapenge doko, dokona lao nyakama laitaka pitoo: Yonge doko pyao kumasetala, ele panda koo dokonya pyandapenge kyeto singi akali doko nyakamame paka kaeyalapape. Kiningi, akali doko paka kaeyalapape lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Muni konde lapomame iki yaka pimbinakae yungi salimi lengema. Dopaka doko, yaka dupanya mendaipi mende Goteme kame nasingi. ");
INSERT INTO enq2_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dopaleaka joo, nyakamanya aiyomba iti dupa pitaka mendai-mendai lao Goteme itaki pyapae. Dopana, yaka pimbinakae longo dupa nyakamame ita minao kalyaminona, paka nakaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nambame nyakama langilyo: Endakali mendeme baa namba tatana lao, endakali waka dupanya enombanya lao panatamo doko, Akalinya Ikiningi dokome akali doko baa tatana lao, Gotenya enjele dupanya enombanya lao panataka. ");
INSERT INTO enq2_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dopaka doko, endakali mendeme baa namba tata daana lao, endakali waka dupanya enombanya latamo doko, Akalinya Ikiningi dokome akali doko baa tata daakana lao, Gotenya enjele dupanya enombanya lataka. ");
INSERT INTO enq2_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Akalinya Ikiningi doko pii koo lata endakali dokonya koo doko kunao nepakamaita. Dopaka doko, Oli Spirita doko lao nepata endakali dokonya koo doko kunao nepakamaiya naeyata. ");
INSERT INTO enq2_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Endakali dupame nyakama laminao lotuu andapi, isingi akalipi, gapomanepi dupanya pataminopa, nyakama tange kame pinyoo pii aipa lamanape, pii aki lamanape lao masepae longo nyala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kote lapenge gii dokopaka Oli Spiritame nyakama pii lapenge dutupa mana langitana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dokopa endakali kambu dokonya katea mendeme Jisasa lamaiyoo, “Mana Lenge, namba moeya nyepenge dupa mokosoo peekena lao nambanya kaiminingi doko lamaiyaka” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dokopa Jisasame baa lamaiyoo, “Wane, apimi namba nyakambanya pii tolasoo, oapi mokosingi akali kata leape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dopa latala Jisasame endakali dokaita lamaiyoo, “Endakali mendenya lete katenge doko baanya oapi longo setenge dopale daa. Dopana, popaita pingi mana dokome nyakama koeyasetana, kandao kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dopa latala baame kongali pii mende dapa lea: “Yuunya kamongo mendenya eenya nee longo andea. ");
INSERT INTO enq2_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Andeamopa baanya moname masoo pituu, ‘Nambanya nee mandyoo setapenge panda mende nasilyamo dokonya, nambame aipa pitoape?’ lao masia. ");
INSERT INTO enq2_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dopa lao masetala baame lao pituu, ‘Nambame dapa pitoo: Nambanya nee setenge anda dupa lakyepala andake pyoo pitoo. Dopa petala nambanya witapi, oapi epepi dupa pitaka nyoo dokonya setato. ");
INSERT INTO enq2_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Setapala nambanya imambu doko lamaiyoo, “Oapi longo setekelyo dupa ee kana longonya soaka pata. Dopana, emba koto nyoo, nee endakipi nao, eteke pyao katape” lamaitona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dopa leamopa Goteme baa lamaiyoo, ‘Emba akali kyakaenge! Indupa kuka gii dakenya embanya lete katenge doko peakalapeno. Peatakatenopa oapi longo nyoo setao kalyeno dupa pitaka endakali waka mendeme nyalapomona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Endakali mendeme baa tange iki masetala oapi longo nyoo setao katao, Gotenya kalai dupa nisala naeyata doko-kisa dopaka pitana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dopa latala Jisasame baanya disaipolo dupa lamaiyoo, “Tenge dokonya nambame nyakama dapa langilyo: Nyakama auu pyoo katamana lao masetala, nyakamame nee anja-tae namanape, yonge pee anja-tae pimanape lao masepae longo nyala naeyalapape. ");
INSERT INTO enq2_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Lete katenge doko nee nenge dopale daa. Yonge doko yonge pee pingi dopale daaka. ");
INSERT INTO enq2_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nyakamame yaka lakepame dupa masalapape. Dupame ee pokala naengema. Dupame nee mandyoo setala naengemaka. Dupanya nee setenge andapi, pandapi mende nasingi. Dopaka doko, Goteme dupa nee maingi. Nyakamame yaka dupa etete ita minao kalya naelyamipi? ");
INSERT INTO enq2_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nyakamanya mendeme auu pyoo katapuli lao masepae longo nyete dokome, embanya lete katenge dokonya yuu gii mendai waipa setepe? ");
INSERT INTO enq2_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nyakamame kalai yakane dopale mende napingima-tamo doko, aipuma dopale waka dupanya masepae longo nyilyami? ");
INSERT INTO enq2_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Palao dii dupa dopa pyoo andengena lao masalapape. Dupame kalai mende napingima. Yonge peepi mende wasala naengemaka. Dopaka doko, Solomoneme baanya yati tata epe dupa pitakame yati pia dupanya, palao dii auu pilyamo dopale mendeme baa yati napiana lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Palao taita kepao yangapenge, indupa dii pilyamo dupa Goteme yati pisingi. Dopa pingina, yongenya pipenge dupa Goteme nyakama ditana, aipuma nyakamame baa kuki tungi pilyami? ");
INSERT INTO enq2_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nyakama neepi, endakipi dupa anja-tae namanape lao kutala naeyao, masepae longo nyala naeyaowaka kalyepape. ");
INSERT INTO enq2_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Isa yuu dakenya akali tata waka dupame dopale dupa kutingima. Dopaka doko, nyakamanya Takange dokome nyakama daa jilyamo dupa kandenge. ");
INSERT INTO enq2_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dopana, nyakamame Gotenya kingdom doko kutalapape. Dopa pitaminopa, nyakama nyepenge dupa pitaka baame dita. ");
INSERT INTO enq2_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nyakamanya Takange dokome auu kaengeme baanya kingdom doko nyakama nambanya sipisipi ŋaŋa dupa ditoo lao masilyamona, paka nakaeyalapape. ");
INSERT INTO enq2_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nyakamanya oapi dupa salimi latala, endakali daa jepae dupa maiyepape. Dopa pitami dokome, nyakamanya munipi, oapi epepi, etala naenge dupa nuu atingi jala naeyata mendenya mandipala kaiti-kisa setataminosa pita. Yuu dokonya pake nenge mende tengesa naepenge. Dupa neneme nao koeyasala naengeaka. ");
INSERT INTO enq2_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nyakamanya oapi epe dupa setenge panda dokonyaka nyakamanya mona yukuu setengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nyakamanya kalai pyaanya yonge pee pingi doko lakao muu pyoo petala, lama dupa tao katena depa latae kalyepape. ");
INSERT INTO enq2_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Akali andake mende, enda watapae pyatami mendenya katao ipupala, anda kaita gata-gata latamopa, yapa lumbao nyalanya kalai akali mendapu depa latae katengemali pyoo nyakama depa latae kalyepape. ");
INSERT INTO enq2_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Akali andake doko ipupala kandatamopa, luu palya naeyao malisetae katatami kalai akali dupa baame auu piseta. Nambame nyakama kiningi langilyo: Baanya kalai pyaanya yonge pee pingi doko lakao muu pyoo petala, dokaita tokonya petena latala nee nena lao nyoo maita. ");
INSERT INTO enq2_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kuka andatombepi, yuu yongalanya pitamopapi, baa ipupala kandatamopa, luu palya naeyao baa malisetae katatami kalai akali dupa baame auu piseta. ");
INSERT INTO enq2_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dake masalapape: Anda tange mendeme pake nenge mende gii dokopa ipapomo lao masiali doko, baanya anda doko kandao isetala, kaluina lao kaeyala naeyali. ");
INSERT INTO enq2_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dopana, nyakama ambe katatami gii mendepa Akalinya Ikiningi doko ipatana, nyakama apata depa latae kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dokopa Pitame baa lamaiyoo, “Kamongo, embame kongali pii doko naima lao lelyepe, pande endakali pitaka lao lelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dopa leamopa Kamongome lao pituu, “Akali andake mendeme kalai akali dupa akali mendeme isina latamopa, dokaita isoo katao, nee napenge gii dokonya nee mokosoo maiyoo katapenge kalai akali masepae epe palenge, pii sakamaingi doko baa api? ");
INSERT INTO enq2_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Baanya akali andake doko ipupala, kalai akali dokome dopa pyoo katata kandatala, baa auu piseta. ");
INSERT INTO enq2_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nambame nyakama kiningi langilyo: Akali andake dokome baanya oapi dupa pitaka kalai akali dokomeaka isakao katena lata. ");
INSERT INTO enq2_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dopaka doko, kalai akali dokome baanya moname masoo pituu, ‘Nambanya akali andake doko tanga-waka ipatana’ lao masetala, tee pyao kalai wanakupi, kalai akali yangopi dupa pyapapu, neepi, biapi dupa nao kyakao katatamo doko, ");
INSERT INTO enq2_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kalai akali dokonya akali andake doko naipapomo lao masetala, ambe katata gii mendepa ipata. Ipupala akali andake dokome kalai akali koo doko kepapala, pii wata-minala naengema endakali dupa katatami panda dokonya katena lata. ");
INSERT INTO enq2_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kalai akali mendeme baanya akali andake dokonya maseta doko kandataka doko, kalai pyaanya depa nalao, akali andake dokonya masetali pyoo napyoaka pitamo doko, baa konjame longo lao pyao indyeta. ");
INSERT INTO enq2_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dopaka doko, kalai akali mendeme masala naeyao, kalai kopeta pita mendenya baa konjame longo lao pyao indyala naeyapenge-tamo doko, baa kukiaka pyao indyeta. Akali mende longo lao mailyamo doko, longo laowaka mokosoo peekena lenge. Akali mendeme longo lao isekena lao mailyamo doko, baa-kisa longo lao tee lengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nambame isa yuu dake tena lao ita kaiyoo palyala epeona, indupa kaiyoo palyetae katapya laka lao masilyo. ");
INSERT INTO enq2_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nambame kaimbu kenda paleta mende nyepenge doko ene ipumupa, mona etete kenda pilyamo. Kaimbu doko nyoo etato dokopa yaka jeta. ");
INSERT INTO enq2_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Endakali dupa isa yuu dakenya mona setao katena laanya namba epeena lao masilyamipi? Daa, wakale pyaloo pingi mana doko sakatasala epeona lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Indupa pituu, anda mendainya endakali yungi palengema dutupa wakale pyaloo pyaamino. Dokopa lapomame tepoma yanda pimaiyambino. Tepoma dutupame lapoma dolapo yanda pimaiyaminoaka. ");
INSERT INTO enq2_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dutupa wakale pyaloo petala, takange dokome baanya ikiningi doko yanda pimaitamopa, ikiningi dokome baanya takange doko yanda pimaiyapomo. Endangi dokome baanya wanenge doko yanda pimaitamopa, wanenge dokome baanya endangi doko yanda pimaiyapomo. Endangi dokome baanya aeyange doko yanda pimaitamopa, aeyange dokome baanya enda aeyange doko yanda pimaiyapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dopa latala pii dake apata endakali kambu doko lamaiyoo, “Niki landa pingitena kopa soo pyakalyilyamo kanju petala nyakamame lao pituu, ‘Aiyuu ipapome-lamona’ lelyamino doko, kiningiaka epenge. ");
INSERT INTO enq2_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Poo kyeto mende kingi tolaetena lelyamo kandatala nyakamame lao pituu, ‘Itaita pyoo paina pyaapome-lamona’ lelyamino doko, kiningiaka dopa pingi. ");
INSERT INTO enq2_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyakama kiningi kandenge manemane pipae dupame yuupa, kaitipa dolapo kandatala, taita dopa pita-lamo lao kandengemaka doko, indupa gii dakepa pilyamo dupa aipuma nyakamame dopa pilyamo lao nakandelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aipuma nyakamame auu pyoo masetala, mana tolatae dupa andukupi lao yapala naelyami? ");
INSERT INTO enq2_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Emba kotimi lata endakali doko-pipa pii lao tolasingi akali mendeme pii lao tolasekena lao pao pituu, kaitinisa embame baa auu pisepe. Dopa napitino doko, baame emba pyalya lao nyoo jasa doko maitamopa, jasa dokome emba yanda singi doko maita. Dokopa yanda singi dokome emba anjinya pyandata. ");
INSERT INTO enq2_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Anjetae paliu, koteme maipi latami dutupa maiyoo etatenopa, emba mokatamina lao nambame emba langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Galali tange mendapuame Gote kundi maiyoo kateaminopa, Pailatame dokaita pyao kumasina leana lao, gii dokopa akali kateami dupanya mendapuame Jisasa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dokopa Jisasame dokaita lamaiyoo, “Galali tange pyapae kumiamino dutupanya koo piamino dupame Galali tange waka dupanya koo piamino dupa ita miniamosa, kenda doko dokaita-kisa epeana lao masilyamipi? ");
INSERT INTO enq2_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Daa, dopa napiana, nyakama mona kapilyala naeyatamino doko, endakali dokaita kumao alu piaminoli pyoo, nyakama apata alu pitamiakana lao nambame nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yuu Siloame dokonya kandao isoo petenge anda ketae doko takyepala, endakali 18 pyambeamo dutupa kumiami. Endakali kumiamino dutupanya koo piamino dupame endakali yangi Jerusalema kateamino dupa pitakanya koo piamino dupa ita miniamosa pyambeana lao nyakamame masilyamipi? ");
INSERT INTO enq2_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Daa, dopa napiana, nyakama mona kapilyala naeyatamino doko, endakali dokaita kumao alu piaminoli pyoo, nyakama apata alu pitamiakana lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dokopa Jisasame kongali mende lao pituu, “Akali mendeme baanya waene ee dokonya piki ita mende pokea dokonya dii lyilyape lao kanja peamopa, dii mende nalyia. ");
INSERT INTO enq2_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dokopa baanya ee isakamaingi doko lamaiyoo, ‘Nambame piki ita dakenya dii lyao nyotoape lao ee kana tepo pitaka kanjangole pipupa, dii manja naelyamona, embame pokanya nepape. Yuu ipange dupa aipuma mee nyina kaeyambape?’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dopa leamopa ee isakamaingi dokome yanu pyao, ‘Akali Andake, nambame ita tenge dokonya amapala ninu mandyoo setatoo, ee kana mendai dake katena kae. ");
INSERT INTO enq2_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ee kana omonya dii nalyetamo doko, pokanya nepatena’ leana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sambata gii mendenya, lotuu anda mendenya Jisasame mana lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dokopa enda mende imambu koo mendeme ee kana 18 pitaka maita pongeamosa kapa pao etao tolapenge nanjiamopa petenge doko lotuu andaka dokonya petea. ");
INSERT INTO enq2_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Peteamo doko Jisasame kandatala epena lea. Ipateamopa baa lamaiyoo, “Enda, emba maita pongotae katenge doko tolasetekelyamona, emba mokao nyepae pilyinona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dopa latala baanya kingi dolapo enda doko-kisa seteamopa, baanya maita doko tolalu pia. Dopa peteamopa enda dokome Gote kenge andake maiya. ");
INSERT INTO enq2_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jisasame Sambata dokonya enda doko auu pisilyamona latala, lotuu anda isingi doko imbu kaeya. Dopa petala endakali kambu doko lamaiyoo, “Yuu gii tokange dutupanya kalai pipenge. Yuu gii dutupanya yaina dupa mee jekena ipupape. Sambata gii dokonya daana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dopa leamopa Kamongome baanya pii yanu pyakamaiyoo, “Nyakama mana tolatae miningi manemane pingima dupa pitakame Sambata gii dokonya nyakamanya kaowapi, dongipi mende nee nenge panda dokonya anjetae kalyamo doko tata latala, endaki nena lao laminao napengemape? ");
INSERT INTO enq2_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Enda dake Abraame wanenge mende, Sataneme ee kana 18 pitaka anjinya palyiamo doko Sambata gii dokonya mokao nanyepengepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dopa leamopa, baanya yandapipi dupa elya kaeyami. Dopa piaminopa, Jisasame kalai tii pipae pia dupa endakali kambu pyao kateami dupa pitakame kandatala eteke piami. ");
INSERT INTO enq2_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dokopa Jisasame lao pituu, “Gotenya kingdom doko aipale? Nambame aki mendepa makande pyuu? ");
INSERT INTO enq2_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Gotenya kingdom doko, akali mendeme masete dii mende nyepala, baanya eenya lyandeamo dopale. Masete doko andao ita joo yale jiamopa, wangya dupanya yaka ketae paenge dupame anda piamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Dopa latala baame deaka lao pituu, “Nambame Gotenya kingdom doko aki mendepa makande pyuu? ");
INSERT INTO enq2_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gotenya kingdom doko, enda mendeme yisa mendalapo palao beke tepomanya pyasoo endaki minilyamopa, yisa dokome palao doko pitakanya taeyapala andasingi dopalena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisasa Jerusalema pao pituu, taonopi, yuu yakanepi dupanya endakali dupa mana lamaiyoo pea. ");
INSERT INTO enq2_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Peamopa endakali mendeme baa lamaiyoo, “Kamongo, endakali pyoo nyepae dupa kuki iki katatamipi?” lea. Dokopa Jisasame endakali dokaita lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nambame nyakama langilyo: Endakali longome lome kaita tambukinatae dokonya kolandamana lao pitaminopa kapa kolandala naeyatamina, nyakamame lekeleke tao lome kaita tambukinatae dokonya kolandalapape. ");
INSERT INTO enq2_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Anda tange doko sakatatala kaita pai latatamopa, nyakama kamaka katapala, tee pyao anda kaita doko gata-gata lao, ‘Kamongo, Kamongo, naimanya anda kaita lumbakapoko’ latami. Dopa lataminopa baame nyakamanya pii yanu pyakao, ‘Nyakama anja tangepe lao nambame masala naelyona’ lata. ");
INSERT INTO enq2_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dopa latamopa nyakamame lao pituu, ‘Naimanya kaitini yakane dupanya embame naima mana langiinopa, emba naima-pipa nee endakipi dupa nao kateamano dokona’ latami. ");
INSERT INTO enq2_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dopa lataminopa anda tange dokome lao pituu, ‘Nambame nyakama langilyo: Nyakama anja tangepe lao nambame masala naelyona, nyakama koo pingima dupa namba yakinatala pupa’ latana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dopa latala Jisasame lao pituu, “Nyakama watao pyata panda dokonya katao kandataminopa, Abraamepi, Aisakepi, Jekopepi, propeta dupa pitakapi, dupa Gotenya kingdom dokonya katatami kandatala, nyakama ee lao, nenge giti-gato lao nao katatami. ");
INSERT INTO enq2_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Gii dokopa endakali niki pyakaengesa tangepi, niki pambengesa tangepi, kingi tolaetena tangepi, kingi koeyatena tangepi, dupa ipupala Gotenya kingdom dokonya nee nao pititami. ");
INSERT INTO enq2_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Salapape! Endakali mendapu maita-kaita kalyamino dupa tanga enomba nyoo katatami. Endakali mendapu enomba nyoo kalyamino dupa tanga maita-kaita katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Gii dokopaka Parasi mendapu ipupala Jisasa lamaiyoo, “Eroteme emba pyao kumasotoo lao masilyamona, yuu dake yakinatala puu” leami. ");
INSERT INTO enq2_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dopa leaminopa baame dokaita lamaiyoo, “Nyakamame yana kapu doko lamaiyoo, ‘Indupa taitapa nambame imambu koo dupa watao pyao, yaina paleta dupa auu pisoo katapala, yuu gii tepo dokonya nambanya kalai doko pyoo etato lelyamona’ lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Propeta mende yuu waka mendenya pyao kumasala naeyapenge, Jerusalemaka pyao kumasepengena, namba Jerusalema paanya indupapi, taitapi, dumapi dutupa kaita pupenge. ");
INSERT INTO enq2_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalema, Jerusalema! Embanya endakali dupame propeta dupa pyao kumasoo, epena latae endakali dupa kaname pyao kumasoaka katengema. Nambame embanya wane dupa nyoo kambu pyatala, yaka matakaiyame ŋaŋa dupa papa pundipundi yapu nengeli pitoo lao, paa longosa masiopa, dupame tanga leami. ");
INSERT INTO enq2_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Salapape! Nyakamanya anda doko kua kalyamo. ‘Akali mende Kamongonya kengenya epelyamo doko Goteme auu pisetaena’ lao nyakamame latami gii dokopa, nyakamame namba kandatamina lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sambata gii mendenya Jisasa baa Parasi dupanya isingi akali mendenya andaka pupala nee nao peteamopa, Jisasame aipa pilyape lao Parasi dupame isokondape piami. ");
INSERT INTO enq2_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dokopa Jisasanya enomba dokonya, akali yonge endaki pituu andao koeyapae mende ipupala katea. ");
INSERT INTO enq2_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dokopa Jisasame looyapi, Parasipi dupa lamaiyoo, “Sambata gii dupanya endakali yaina pyapae dupa mee jakamaiyepape lao loome latae silyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dopa leamopa dupame pii mende naleaminosa, Jisasame akali doko minatala, yaina doko mee jetakamai pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pateamopa Jisasame dokaita lamaiyoo, “Sambata gii mendenya, embanya wanepi, kaowapi mende endaki pete tombapae mendenya pyakatamopa, embame pupae pyalya lao nanyetepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dopa leamopa dokaitame baanya pii dutupa kapa pao yanu napiami. ");
INSERT INTO enq2_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nee nala epena leamopa epeami endakali dupame toko epe dupa yapao peteaminopa Jisasame kandatala, kongali dake dokaita lamaiya: ");
INSERT INTO enq2_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Akali mendeme enda watapae pyao nee andake depa lelyona nambana ipupi latamopa, emba ipupala toko epe mendenya napitipi. Aipumape, emba ipupi lata akali dokome akali andake alyasale mende apata epena lataka. Nyakamba lapota ipupape lata akali doko ipupala lao pituu, ‘Emba pilyino toko doko akali dake mai’ latamopa, emba elya sepala toko maita-kaita dupanya pilya patena, toko epe dupanya napitipi. ");
INSERT INTO enq2_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Akali mendeme nee nambana ipupi latamopa, emba pao etete maita-kaita pitipi. Dopa pitinopa, emba ipupi lata akali doko ipupala emba langyoo, ‘Kaimii, emba enomba nyoo pilya ipu’ lata. Dopa lata dokome, endakali nee nao tole pititami dupanya enombanya emba lalyetamosa pita. ");
INSERT INTO enq2_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dopana, endakali mendeme baa tange kenge minalyetamo doko, Goteme baanya kenge doko minanata. Endakali mendeme baa tange kenge minanatamo doko, Goteme baanya kenge doko minalyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dopa latala Jisasame baa nee nala epena lea akali doko lamaiyoo, “Embame nee yakane-tamopi, andake-tamopi mende yangatala, embanya kaita miningipi, embanya kaiminingipi, embanya tatapi, embanya patali maki yuunya kamongopi, dupame yanu pyao emba nee nala ipupi latamina, dupa nee nala epena laa naeyape. ");
INSERT INTO enq2_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Embame nee andake mende yangateno dokopa, endakali tipyapi, kingi talyangapi, moko takyepaepi, lenge mondapi dupa nala epena lape. ");
INSERT INTO enq2_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dopa pitino doko, Goteme emba auu piseta. Endakali dopale dupame kapa pao yanu pyakala naeyatamiaka doko, Goteme endakali tolatae dupa sakataseta gii dokopa, baame embanya yanu dupa pyakatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nee nao tole peteami dupanya mendeme Jisasame pii leamo dupa sepala baa lamaiyoo, “Gotenya kingdom dokonya nee nao pititami endakali dupa pitaka Goteme auu pisetae-lumuna” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dopa leamopa Jisasame baa lamaiyoo, “Akali mendeme nee andake mende yangatoo latala, endakali longo nee nala epena lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nee andake napenge gii doko epeamopa, baanya kalai akali mende pena latala lamaiyoo, ‘Indupa nee dupa pitaka depa latae silyamona, endakali epena latae dupa epena lanyala puu’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dokopa kalai akali dokome pao lamaitiamopa, epena latae endakali dupa pitakame naipamane-lumuna leami. Wambao dokome baa lamaiyoo, ‘Nambanya yuu mende sambapu doko kanja pupengena, namba naipatoana, yatae lelyona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mende dokome lao pituu, ‘Nambanya kao akalita sambapuna, dutupame kalai pina makande pyaa pelyona, namba naipatoana, yatae lelyona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mende dokome lao pituu, ‘Namba enda kelyapu dokonya kapa naipapo-lumuna’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dokopa kalai akali doko ipupala, leami dupa baanya akali andake doko lamaiya. Lamaitiamopa anda tange, akali andake doko imbu kaeyapala, baanya kalai akali doko lamaiyoo, ‘Emba alo pyao siti dokonya kaitini yalepi, yakanepi dupanya paeyao, endakali tipyapi, kingi talyangapi, moko takyepaepi, lenge mondapi dupa laminao andaka dakenya andakote ipupi’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Akali andake dokome leali petala, kalai akali dokome baa lamaiyoo, ‘Embame lapinoli petapupa, panda longo mee silyamoakana’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dokopa akali andake dokome kalai akali doko lamaiyoo, ‘Nambanya anda dake tumbinana, embame kaitini yalepi, kame kilikili kaitini yakanepi, dupanya endakali kandate dupa pitaka epena lao kyeto joo lamaipi. ");
INSERT INTO enq2_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Akali nee nala epena lapupa naipamino dupanya mendaipi mendeme nambanya nee andake dakenya nao sala naeyatana lao nambame nyakama langilyona’ leana” Jisasame lea. Dopa latala Jisasame lao pituu, “Goteme endakali longo epena lengeaka doko, baame endakali kuki yapao nyingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Endakali kambu andake mendapu Jisasa-pipa peamino dupa baame kandalyetala lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Akali mende namba katato dokonya ipupala, baanya endangi takangepa, enda wanepi, kaiminingi pimalengepi, baanya lete katengepi, dupa maita maiya naeyatamo doko, baa kapa pao nambanya disaipolo nakatata. ");
INSERT INTO enq2_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Endakali mendeme baanya poko ita doko soo, namba watao naipatamo doko, baa nambanya disaipolo nakatataka. ");
INSERT INTO enq2_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nyakamanya mendeme kandao isoo pitipenge anda ketae mende pyoo pyakalyotoo lao maseteno doko, wambao isa pitipala, anda doko pyoo etasepenge muni yaka silyape lao itaki pyala naeyatepe? ");
INSERT INTO enq2_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itaki pyala naeyateno doko, embame anda muku minapala kapa pao angi pyoo etasala naeyatenopa, kandatami endakali dupa pitakame tee pyao emba lamba lao, ");
INSERT INTO enq2_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Akali dakeme anda pyaanya tee pyatala, pyoo etasala naeya-lamona’ latami. ");
INSERT INTO enq2_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kiŋi mendeme kiŋi waka mende yanda pimaiya paanya pituu, kiŋi mende dokonya amii 20 tausene ipataminopa, baanya amii 10 tausene katatami dutupame kapa pao yanda pimaitala ita minalapope lao, wambao isa pitipala masokondape napitape? ");
INSERT INTO enq2_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Baame kapa napapomona lao masetamo doko, kiŋi mende doko londati katatamopa, yanda doko kaeyambana lao akema latala, akali mendapuame wai minao pena lata. ");
INSERT INTO enq2_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dopana, nyakamanya mendeme oapi setenge dupa pitaka yakinatala namba watao naipateno doko, emba kapa pao nambanya disaipolo nakatatena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Sole doko epe. Dopaka doko, sole dokonya tende patamo doko, aipa petala dee tende pisetami? Sole tende patae dokome yuu auu pisala naenge. Ninu wasala naengeaka. Dopa petae doko kamaka soo nepenge. Nambame pii lelyo dutupa endakali kale katenge dupame sepengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takisa nyingipi, koo pingipi dupa Jisasa katea dokonya pii salanya tengesa epeami. ");
INSERT INTO enq2_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dopa piaminopa Parasipi, Mosesanya loo mana nyepaepi, dupame mumu lao, “Akali dakeme endakali koo pingi dupa yaka ipaminona lao lanyetapu, dupa-pipa nee nao pilyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dopa leaminopa Jisasame kongalimi dokaita lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Akali mendenya sipisipi 100 katata dokonya mendai alu pitamopa, baame sipisipi 99 dutupa endakali napalenge yuu mendasa katasetala, mendai alu pita doko kutao pupala, kandao nyepalaka kaeyala naeyatape? ");
INSERT INTO enq2_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kutao nyepala, eteke pyao nyoo lataiyanya soo ");
INSERT INTO enq2_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","andaka ipupala, baanya kaita miningipi, patali makepi, dupa epena latala lamaiyoo, ‘Nambanya sipisipi mende alu pipumu doko kutapala kandao nyepelyona, nyakama namba-pipa eteke pyao katamana’ lata. ");
INSERT INTO enq2_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Dopaka pyoo, endakali tolatae, dee mona kapilyala naeyapenge 99 dutupa kalyaminopa, kaiti-kisa auu kaeyapae singiaka doko, endakali koo pingi mendai mona kapilyilyamopa, kaiti-kisa auu kaeyapae andake mende singina lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Enda mendenya silipa muni akalita setenge dokonya mendai alu pitamopa, baame lama kaiyepala, andaka potoma polao, kutakondape pyoo kutao muni doko nyepalaka kaeyala naeyatape? ");
INSERT INTO enq2_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kutao nyepala, baanya kaita miningipi, patali makepi, dupa epena latala lamaiyoo, ‘Nambanya silipa muni mende alu pipumu doko kutapala kandao nyepelyona, nyakama namba-pipa eteke pyao katamana’ lata. ");
INSERT INTO enq2_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Dopaka pyoo, endakali koo pingi mendai mona kapilyilyamopa, Gotenya enjele dupame auu kaeyapae andake nyingimana lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Dokopa Jisasame lao pituu, “Akali mendenya wane ane lapoma mandenge. ");
INSERT INTO enq2_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wane kole dokome baanya takange doko lamaiyoo, ‘Apane, embanya muni oapipi namba nyepenge dupa mokosoo dii’ lea. Dokopa takangeme baanya oapi dupa wane dolapo mokosoloo pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yuu gii kuki pateamopa, wane kole dokome baanya muni oapipi dupa pitaka nyoo, yuu londati mendenya pao katea. Dokonya katao baanya muni oapipi dupa luiyao pyoo nepea. ");
INSERT INTO enq2_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Baanya muni oapipi dupa pitaka pyoo nepao etapeamopa, baa katea yuu dokonya lopo andake mende sia. Dopa piamopa baa tee pyao daa jia. ");
INSERT INTO enq2_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Daa jiamosa, yuu dokonya tange akali mendenya kendemane katatoo lao pea. Pateamopa akali yuu dokonya tange dokome baanya mena dupa nee maiyoo kalya pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nee maiyoo kateamopa, mename tupaita imbu neami dupa baa nao tiaka kaeyapu laka lao masiamopa, mendeme baa nee namaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dokopa baame masepae nyepala lao pituu, ‘Nambanya takangenya kalai akali longo dupa nee kakana sina nao kataminopa, namba lopome kumilyo. ");
INSERT INTO enq2_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dokonya namba sakatatala, nambanya takange kalyamo dokonya pupala baa lamaiyoo, “Apane, embanya enombanyapi, kaiti-kisa katenge dokonya enombanyapi, nambame koeyatapu. ");
INSERT INTO enq2_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dokonya namba epe daana, indupa pituu namba embanya ikiningina laa naeyatale, namba embanya kalai akali dupanya mende joo kata lape” latoana’ lao masia. ");
INSERT INTO enq2_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dopa lao masetala, baa sakatatala baanya takange doko katea dokonya pea. Baa kuki omosale epeamopa, baanya takangeme kandatala kondo kaeya. Kondo kaeyapala, baa alo pyao pao wane doko mangenya kopinyetala nunu pia. ");
INSERT INTO enq2_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dokopa wane dokome baa lamaiyoo, ‘Apane, embanya enombanyapi, kaiti-kisa katenge dokonya enombanyapi, nambame koeyatapu. Dokonya namba epe daana, indupa pituu namba embanya ikiningina laa naeyape’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dopa leaka doko, takangeme baanya kalai akali dupa lamaiyoo, ‘Nyakamame yonge pee londe etete epe doko nyoo ipupala baanya pyakamaiyepa. Baanya kingi dokonya riŋi mende pisakamaiyepa. Baanya mokonya moko pee mende pyakamaiyepa. ");
INSERT INTO enq2_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Nambanya wane dake kumiamoaka doko, indupa saka katalame-lamo. Baa alu piamoaka doko, indupa kandao nyepelyona, naima nee nao mona yaepao katamana, kao ŋaŋa kendatae doko nyoo ipupala pyao yangakamaiyepa’ lea. Dokopa dokaita tee pyao mona yaepao kateami. ");
INSERT INTO enq2_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Dopa pyoo kateaminopa, akali dokonya ikiningi mupa doko eenya katao andaka tengesa epeamopa, musiki pyao, danisa lao kalyuiyamino sema epea. ");
INSERT INTO enq2_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ipupala baame kalai akali mende epena latala, aipuma dopa pyoo kalyamipi lao tipa pia. ");
INSERT INTO enq2_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dopa leamopa kalai akali dokome baa lamaiyoo, ‘Embanya kaiminingi doko ipamo. Baa kenda mende kandao nyala naeyao auu pyoo pilyimupa, embanya takange dokome baa lanyepala, kao ŋaŋa kendatae doko pyao yangakamaiyomona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dokopa wane mupa doko imbu kaeyapala andakote napatoo lao masia. Dopa lao masiamosa, baanya takange doko kamaka pyakalyetala, baa andakote epena lao pii andiki pyoo lamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dopaka doko, wane dokome baanya takange dokonya pii yanu pyakamaiyoo, ‘Embanya piipi mende nambame nepala naeyao, ee kana longo embanya kalai pyakao katenge. Dopa pyekelyopa, embame meme ŋaŋa mende nambanya kaita miningi dupa-pipa mona yaepao yangao nalapa lao yuu mendaipi mende nandingi. ");
INSERT INTO enq2_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dopaka doko, embanya ikiningi dakeme embanya oapi dupa pitaka enda muni nyoo akali nyala paenge dupa-kisa etasetakala ipumupa, embame kao ŋaŋa kendatae doko pyao yangakamaiyene-lamona!’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dokopa takangeme baa lamaiyoo, ‘Apea, emba nambapa koteaka lao tole katenge. Nambanya oapi dupa pitaka embanyaka silyamo. ");
INSERT INTO enq2_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Embanya kaiminingi kumiamoaka doko indupa saka kalyamo. Baa alu piamoaka doko indupa kandao nyepelyo. Tenge dokonya mona yaepao auu kaeyapae nyepenge jipyanya nyilyamanona’ leana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisasame baanya disaipolo dupa lamaiyoo, “Yuunya kamongo mendenya oapi dupa isakamaingi akali mende katea. Isakamaingi akali dokome muni akipi dupa pyoo nepa-nepa pyoo kalyamona lao, baa-kisa tenge setao pii mende minao yuunya kamongo doko katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ipupala lamaitiaminopa, yuunya kamongo dokome baanya oapi dupa isakamaingi akali doko epena latala lamaiyoo, ‘Emba-kisa tenge setaminopa silyo datupanya embame pii mende latepe? Indupa pituu embame nambanya oapi dupa isakala naeyalapenona, embanya isingi kalai doko dopa pyoo pipuna lao pepanya pyapala peape’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dopa leamopa isingi akali dokome dapa lao masia: ‘Nambanya akali andake dokome nambanya isingi kalai doko napyale lao namba watalumu. Ee amenge kalai doko pyaanya namba-kisa kyeto nasingi. Nambame mende-kisa tee laanya elya kaengena, nambame aipa pitoo? ");
INSERT INTO enq2_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nambanya isingi kalai doko tange nyetamopa, endakali mendapuame nyakamanya andaka dupanya namba lanyoo pataminopana, nambame kalai mende pitoana’ lao masia. ");
INSERT INTO enq2_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dopa lao masetala, baame yuunya kamongo dokonya yanu singi akali dupa mendai-mendai lao epena lea. Akali wambao epea doko lamaiyoo, ‘Nambanya akali andake dokonya emba-kisa yanu akipate silyape?’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dopa leamopa akali dokome lao pituu, ‘Namba-kisa wele jatamu 100 yanu silyamona’ lea. Dopa leamopa isingi akali dokome baa lamaiyoo, ‘Embanya yanu singi pepa dake nyepala, yapa isa pitipala, 50 silyamona lao pepa pyaa’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Maitakao akali mende epea doko lamaiyoo, ‘Emba-kisa yanu akipate silyape?’ lea. Dopa leamopa akali dokome lao pituu, ‘Namba-kisa wita beke 100 yanu silyamona’ lea. Dokopa isingi akali dokome baa lamaiyoo, ‘Embanya yanu singi pepa dake nyepala, 80 silyamona lao pepa pyaa’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Isingi akali koo doko waa katea dokonya, baanya akali andake dokome baa kenge minalyia. Yuu dakenya ikiningi dupame etete waa katao dokaitanya tata dupa-kisa mana miningima. Tii pipae dokonya ikiningi dupame dopaka pyoo waa nakatengema. ");
INSERT INTO enq2_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nambame nyakama langilyo: Nyakama kumataminopa, endakali kaita minao nyetami dupame sele anda kataowaka katenge dupanya nyakama lanyetamina, muni koo dupame endakali kaita minao nyalapape. ");
INSERT INTO enq2_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kuki mendalapo isina lelyamoli pyoo isingi endakali dokome, longo mendapu isina lelyamoli pyoo isingiaka. Kuki mendalapo isoo katao minakasingi endakali dokome, longo mendapu isoo katao minakasingiaka. ");
INSERT INTO enq2_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nyakamame yuunya muni dupa isalapape leali pyoo isala naeyatamino doko, muni angi dupa apimi isalapale lao dita? ");
INSERT INTO enq2_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nyakamame endakali waka mendenya oapi dupa isakalapape latali pyoo isakamaiya naeyatamino doko, oapi nyakamanya latae dupa apimi nyakama dita? ");
INSERT INTO enq2_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kalai akali mendeme kamongo lapomanya kalai pyakamaiya naeyapenge. Lapomanya kalai pyakamaitamo doko, baame mende doko maka kaeyapala, mende doko auu kaeyata. Daa-tamo doko, mende doko mona setapala, mende doko maka kaeyata. Dopana, nyakamame Gotepa, munipa dolapo lapotanya kalai pyakamaiya naeyapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parasi dupa muni putiti kaengema dokonyana, Jisasame pii lea dutupa pitaka sepala, baa lamba lao gii kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dokopa baame dokaita lamaiyoo, “Nyakama tolatae kalyamanona lao endakali dupanya enombanya lengema. Dopaka doko, Goteme nyakamanya mona dupa kandenge. Endakalinya enombanya auu petae-lamo lao lalyingima dupa Goteme kandatala myuku kaenge. ");
INSERT INTO enq2_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosesanya loo dupapi, propeta dupanya pii dupapi, dupa lamaiyoo pao, Jone kateamo gii dokonya tuu leami. Jone kateamo gii dokonya pituu, Gotenya kingdom dokonya wai pii epe doko lamaiminopa, endakali dupa pitakame kyeto joo Gotenya kingdom dokonya kolandelyamino. ");
INSERT INTO enq2_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yuupa kaitipa dolapo mee petala etapengeaka doko, Mosesanya loo dupanya mendaipi mende isa napata. ");
INSERT INTO enq2_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Akali mendeme baanya enda doko yakinatala, waka mende nyilya dokome baa kepo kolenge. Akali mendenya enda yakinatae mende akali mendeme nyilya dokome baa kepoaka kolengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Akali yuunya kamongo mendeme yonge pee kala pepolopi, lapalapa kyeo lapae epepi, dupa pyoo katao, koteaka lao nee etete epe dupa nao katea. ");
INSERT INTO enq2_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Akali tipya Lasarusa lenge, amungimi tete-tete pipae mende koteaka lao, yuunya kamongo dokonya lome kambu dokonya pituu sepa pilyamopa, ");
INSERT INTO enq2_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","yuunya kamongo dokonya nee nelya dupanya lombo, toko dokonya soo isa pelya dupa Lasarusame nao tiaka kaeyapu laka lao masingi. Dokopa yana dupame ipao amungi tete-tete dupanya pendo peta pingima. ");
INSERT INTO enq2_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Akali tipya doko kumateamopa, enjele dupame nyoo pupala, Abraame katea dosa katena leami. Dokopa yuunya kamongo doko apata kumateamopa malu piami. ");
INSERT INTO enq2_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Malu peteaminopa, baa endakali kumapae dupa katengema panda dokonya tanda andake nao katea. Dokonya katao kandalyiamopa, Lasarusa baa Abraame katea dosa, londati kateamo kandea. ");
INSERT INTO enq2_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kandatala baame wii lao, ‘Apane Abraame, namba ita yuli dakenya tao tanda andake nelyona, embame namba kondo kaeyapala, Lasarusame baanya kingi kondeme endaki mendalapo poeyanyetala, nambanya keke dake kii nasakala epena lamaiyakapoko’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dopa leamopa Abraameme lao pituu, ‘Wane, embame masepe: Emba yuunya kateeno dokopa, oapi epe dupa pitaka embame nyiinopa, Lasarusame koo dupa nyia. Dopaka doko, indupa panda dakenya baa mona yaepasimupa, emba tanda andake nyilyino. ");
INSERT INTO enq2_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dupa pitakanya mende doko dake: Naima kalyamano panda dakepa, nyakama kalyamino panda dokopa, dolaponya kainanya kundu andake mendeme lita pyakao petae kalyamo dokonya, endakali mendapuame aetena katao nyakama kalyamino dokonya pyakaeyamana lao masetami dupame kapa pyakaeyala naeyapenge. Omotena katao naima kalyamano dakenya pyakaeyala naeyapengeakana’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Dopa leamopa yuunya kamongo dokome lao pituu, ‘Apane, dopa-tamo doko, nambanya kaiminingi yungi dutupa namba tanda andake nao kalyo dakenya ipatamina kandao katena lao, Lasarusame nambanya takangenya andaka lamaiyakala pena laa’ lao kyeto joo tee lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dopa leamopa Abraameme baa lamaiyoo, ‘Mosesapi, propetapi dupanya pii pepa pyapae singi dupa silyamona, embanya kaiminingi dutupame pii dupa sepengena’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dopa leamopa yuunya kamongo dokome lao pituu, ‘Apane Abraame, doko kapa napapomo. Dopaka doko, akali mende malunya sakatatala, dutupa katatami dokonya pao lamaitamopa, mona kapilyalaminona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dokopa Abraameme baa lamaiyoo, ‘Mosesapi, propetapi dupanya pii dupa nasetamino doko, akali mende malunya sakatatamopapi, dokaitanya masingi doko aloo napitamiakana’ leana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisasame baanya disaipolo dupa lamaiyoo, “Koo pina lao mapusingi tata longo dupa kiningi etete ipata. Ipataka doko, koo pina lao mapuseta akali doko baa koeyata! ");
INSERT INTO enq2_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Namba tungi pingima wane koo datupanya mende akali dokome koo pina lao mapusetamo doko, wita indyepenge kana yale mende baanya mangenya kende katatala, solowata lumu mendasa soo pyandamili doko yaka jipyali. ");
INSERT INTO enq2_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nyakama tange kandao isoo kalyepape. Embanya kaiminingi mendeme emba koo pingitamo doko, baa pyalanya lape. Dopa latenopa baa mona kapilyia-kandeno doko, embame baanya koo dupa kame sakamaipi. ");
INSERT INTO enq2_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Akali dokome yuu gii mendai dokonya paa kalangesa emba koo pingitala, yuu gii mendai dokonyaka paa kalangesaka ipupala emba langyoo, ‘Namba mona kapilyilyona’ latamo doko, embame baanya koo dupa kame sakamaipi” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposole dupame Kamongo lamaiyoo, “Naimanya Gote tungi pingi doko andasakape” leami. ");
INSERT INTO enq2_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dopa leaminopa Kamongome lao pituu, “Nyakamanya Gote tungi pingi doko yakane masete dii dopalepi mende-pyali doko, nyakamame diwi ita dake lamaiyoo, ‘Emba pingitaka yukupala, solowatanya kalya puu’ laminopa lamiliaka pipyalina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nyakamanya mendenya kalai akali mende ee pokalanya yuu amao kataowapi, sipisipi setao kataowapi andaka ipatamopa, embame baa lamaiyoo, ‘Emba yapa ipao pitipala nee naa’ latepe? ");
INSERT INTO enq2_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Daa, embame baa lamaiyoo, ‘Nambanya nee depa latakala, embanya yonge pee kalai pyaanya pingi doko lakao muu pyoo petala, nee dupa minao ipupi. Namba nee endakipi nao pititopa, namba nisalanya emba malisetae katape’ laa naeyatepe? ");
INSERT INTO enq2_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Embame pina lelye dupa kalai akali dokome lelyenoli pyoo pilyamopa, embame baa yaka pilyino lengepe? Dopa laa naenge. ");
INSERT INTO enq2_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dopaka pyoo, Goteme pyepape latae dupa pitaka nyakamame petala dapa lapape: ‘Naima kalai akali koo. Naimame pyepape latae dutupaka pilyamanona’ lapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisasa Jerusalema paanya, Samariapa, Galaliapa dolaponya kaina dokonya-kaita pea. ");
INSERT INTO enq2_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Baa pao yuu yakane mendenya pyakameamopa, akali kopetali akalita mendatupame kuki omosale katao baa kandanyiami. ");
INSERT INTO enq2_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Kandanyetala dutupame wii lao, “Akali Andake Jisasa, embame naima kondo kaeyapoko” leami. ");
INSERT INTO enq2_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dopa leaminopa Jisasame dutupa kandatala lamaiyoo, “Prisa dupame nyakama kandena pupa” lea. Dokopa dutupa kaitinisa peaminopa, dutupanya kopetali dupa mee jia. ");
INSERT INTO enq2_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dokopa akali dutupanya mendeme baanya kopetali doko mee jalame-lamo lao kandatala, puu lao Gote mambo pyao pilyia. ");
INSERT INTO enq2_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pilyetala, Jisasanya moko setea dosa ipao tombauli sepala, yaka pilyino lea. (Akali doko baa Samaria tange mende.) ");
INSERT INTO enq2_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dokopa Jisasame lao pituu, “Akali akalita dutupanya kopetali dupa auu pyaa naeyalape? Akali tukutepo dutupa anja kalyami? ");
INSERT INTO enq2_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Akali tata waka dakeme iki Gote kenge andake maiyanya pilyalape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dopa latala Jisasame akali doko lamaiyoo, “Embame namba tungi pyapi dokome embanya kopetali yaina doko etelyamona, emba sakatatala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parasi mendapuame Gotenya kingdom doko andukupa ipatape lao Jisasa tipa piaminopa, baame dokaitanya pii yanu pyakamaiyoo, “Gotenya kingdom doko endakalimi kandapenge kongali mende-pipa naepelyamo. ");
INSERT INTO enq2_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Endakali dupame lao pituu, ‘Gotenya kingdom doko ae silyamo dakena kanjepa. Omo silyamo domona kanjepa’ laa naeyatami. Aipumape, Gotenya kingdom doko nyakamanya mona andaka kalyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dopa latala baame disaipolo dupa lamaiyoo, “Gii doko ipatamopa, Akalinya Ikiningi dokonya yuu gii dupanya mende kandamu laka lao masetamiaka doko, angi nakandatami. ");
INSERT INTO enq2_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dokopa endakali mendapuame nyakama langyoo, ‘Akalinya Ikiningi doko asa kalyamo kanja ipupa, omosa kalyamo kanja pupa’ lataminopa, nyakamame kutao kanja napupape. ");
INSERT INTO enq2_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yuu-wapaka pilyamopa, tii pipae doko kaitinya yangitena pituu, yangitena tuu lenge dopaka pyoo, Akalinya Ikiningi doko baanya gii dokonya ipatamopa dopaka pita. ");
INSERT INTO enq2_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dopaka doko, wambao Akalinya Ikiningi doko kaeyala naeyao tanda longo natamopa, endakali indupa palelyamino dupame baa maita maitami. ");
INSERT INTO enq2_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Akalinya Ikiningi doko ipanya pita gii dokopa, Noa katea gii dokopa pialiaka pita. ");
INSERT INTO enq2_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Endakali dupa nee endakipi nao, akali dupame enda nyoo, wanaku dupa akali nyala pao pyoo kateaminopa, Noa sipi andaka kolandea gii doko epea. Dokopa endaki andake doko ipupala, dokaita pitaka pyambatala koeyasia. ");
INSERT INTO enq2_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Dopaka pyoo, Lote katea gii dokopa, endakali dupa nee endakipi nao, oapi dupa sambao, salimi lao, ee pokao, anda pyoo kateami. ");
INSERT INTO enq2_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dopa pyoo kateaminopa, Lote baa Sodomo yuu doko yakinatala pateamopa, kaitinya katao itatepi, kana yuli tapetapi, dupa aiyuu joo ipupala, endakali dupa pitaka pyambatala koeyasia. ");
INSERT INTO enq2_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Akalinya Ikiningi doko panatamo gii dokopa, dopaka pita. ");
INSERT INTO enq2_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Gii dokopa endakali mende baanya anda ketae katata dokome, baanya oapi andakote seta dupa nyalanya isa pyakanala naeyapenge jeta. Endakali mende eenya katata doko, andaka pilyala naeyapenge jetaka. ");
INSERT INTO enq2_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nyakamame Lotenya enda doko masalapape. ");
INSERT INTO enq2_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Endakali mendeme baa lete katatoana lao masetala, katapenge kaitini kutatamo dokome baanya lete katenge doko yakinata. Dopaka doko, endakali mendeme baanya lete katenge doko yakinata dokome baanya lete katenge doko nyeta. ");
INSERT INTO enq2_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nambame nyakama langilyo: Kuka gii dokonya endakali lapoma toko mendainya palitambinopa, dolaponya mende nyepala, mende doko katena kaeyata. ");
INSERT INTO enq2_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Enda lapomame palao wasalanya wita dii takyoo indyoo tole pititambinopa, dolaponya mende nyepala, mende doko petena kaeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dopa leamopa disaipolo dupame baa lamaiyoo, “Kamongo, anja dopa pitape?” leami. Dokopa baame dokaita lamaiyoo, “Dopale mende kumapae silya dokonya yaka lakepame dupa kambu pingimana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisasanya disaipolo dupame maka nakaeyao, koteaka lao loma soo katena lao baame kongali pii mende dapa lao lamaiya: ");
INSERT INTO enq2_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Siti mendenya jasa mende katea dokome Gote paka nakaeyao, endakali dupa anda-anda semaiya naeyaowaka katea. ");
INSERT INTO enq2_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dokopa siti dokonya enda walyakae mende petea. Enda doko jasa katea dokonya ipupala lao pituu, ‘Nambanya yandapipi dokome namba kenda dilyamona tolasakapoko’ lao tondani pia. ");
INSERT INTO enq2_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tondani piamopa, jasa dokome tolasala naeyatoana, daa lao gii kuki mendalapo katea. Dopaka doko, maitakao jasa dokome dapa lao masia: ‘Nambame Gote paka nakaeyao, endakali dupa anda-anda semaiya naeyaowaka pingi doko, ");
INSERT INTO enq2_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","enda walyakae dakeme tondani pitamopa, namba etete maka kaeyalapo-lamona, baanya kenda doko tolasakamaitoana’ lao masiana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dopa latala Kamongome lao pituu, “Mana tolatae naminingi jasa dokome lea-lumu doko nyakamame auu pyoo masalapape. ");
INSERT INTO enq2_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gotenya yapao nyepae endakali dupame kuka kotakapi wii lao loma soo katataminopa, dupanya kenda dupa Goteme yapa tolasakamaiya naeyatape? Baame dupa yapa nisala naeyao, gii longo nepao malisoo katatape? ");
INSERT INTO enq2_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Dupanya kenda dupa baame yapa tolasakamaitana lao nambame nyakama langilyo. Dopaka doko, Akalinya Ikiningi doko ipatamo gii dokopa, Gote tungi pingi akipate isa yuu dakenya katatami kandatape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Endakali mendapuame nyakama tange tolataena lao mona andaka kyeto joo masetala, endakali waka dupa kandanya palyiaminosa, Jisasame dokaita kongali dake lamaiya: ");
INSERT INTO enq2_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Akali lapoma lotuu anda nee nyetae kamapu dokonya loma sala peambi. Mende doko Parasi. Mende doko takisa nyingi. ");
INSERT INTO enq2_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parasi dokome baa iki katao dapa lao loma sia: ‘Gote, namba pake nengepi, mana koo miningipi, kepo kolengepi, endakali waka dopale daa. Namba takisa nyingi kalyamo dapale daaka dokonyana, nambame emba yaka pilyino lelyo. ");
INSERT INTO enq2_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wiki mendainya yuu gii lapoma nambame loma soo nee nanao katenge. Nambame dopale nyilyo dupa pitaka malu akalita mokosoo setapala, dutupanya malu mendai emba dingina’ lao loma sia. ");
INSERT INTO enq2_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dokopa takisa nyingi dokome kaiti-kisa kandalyetae nakatatoo lao masetala, omosale katao, mona kenda kaeyao lao pituu, ‘Namba akali koo pingi mendena, Gote embame namba kondo kaeyape’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nambame nyakama langilyo: Takisa nyingi doko Goteme tolataena lateamopa baanya andaka lanao pea. Akali mende doko tolataena nalea. Endakali mendeme baa tange kenge minalyetamo doko, Goteme baanya kenge doko minanata. Dopaka doko, endakali mendeme baa tange kenge minanatamo doko, Goteme baanya kenge doko minalyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Endakali mendapuame wane ŋaŋa dupa apata Jisasame watandena lao kopyoo epeami. Dokopa disaipolo dupame kandatala, endakali dupa pyalanya leami. ");
INSERT INTO enq2_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dokopa Jisasame wane wanakupi koo dupa epena latala lao pituu, “Gotenya kingdom doko wane wanakupi koo dapale dupanyana, dokaita epekena kaita lyokala naeyalapa. ");
INSERT INTO enq2_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nambame nyakama kiningi langilyo: Gotenya kingdom doko wane wanakupi koo mendeme nyingili pyoo, endakali mendeme nanyetamo doko, baa Gotenya kingdom dokonya kolandala naeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Isingi akali mendeme Jisasa tipa pyoo, “Mana Lenge Epe, lete etete katenge doko nambame aipa petala nyotope?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dokopa Jisasame baa lamaiyoo, “Aipuma embame namba epe lelye? Endakali mende epe daa. Gote iki baa epe. ");
INSERT INTO enq2_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mana setapae dupa embame masilyino: Kepo kolala naeyape. Endakali pyao kumasala naeyape. Pake nala naeyape. Endakali mende sambo lao kotimi laa naeyape. Embanya endangi takangepa dolapo anda-anda semaiyoo katape lapae silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dokopa isingi akali dokome lao pituu, “Namba wane kolesa pituu, mana setapae dutupa pitaka nambame wata-minio dopaka pyoo wata-minao kalyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dopa leamopa Jisasame sepala akali doko lamaiyoo, “Emba mendai mende daa jilyamona, embanya oapi dupa pitaka salimi latala, endakali daa jepae dupa mokosoo maipi. Dopa pitinopa oapi epe dupa embanya kaiti-kisa sakata. Dopana, emba namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dopa leamopa isingi akali dokome sepala, baanya oapi etete longo setenge dokonyana, mona etete kenda kaeya. ");
INSERT INTO enq2_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Akali doko mona etete kenda kaeyamo kandatala, Jisasame lao pituu, “Muni longo singi endakali dupa Gotenya kingdom dokonya kolandalanya etete lekeleke tatami. ");
INSERT INTO enq2_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamele mendeme kepo tii mendenya lekeleke tao kolandapyaliaka doko, yuunya kamongo mendeme Gotenya kingdom dokonya kolandalanya eteteaka lekeleke tatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dopa leamopa siami endakali dupame lao pituu, “Dopa-tamo doko, endakali api pyoo nyetape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dopa leaminopa Jisasame lao pituu, “Endakalimi kapa pao napipenge dupa pitaka Goteme pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dokopa Pitame lao pituu, “Naimame dupa pitaka yakinatala emba watao epelyamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dopa leamopa Jisasame dokaita lamaiyoo, “Nambame nyakama kiningi langilyo: Akali mendeme Gotenya kingdom doko masetala, baanya andapi, endangi takangepi, kaiminingipi, endapi, wane wanakupi, dupa yakinatamo dokome, ");
INSERT INTO enq2_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","indupa gii dakepa wakao longo lao nyalapomo. Yuu enenge ipata dokonya baa lete etete katenge doko apata nyetakana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisasame 12 disaipolo dutupa lanyepala dokaita lamaiyoo, “Salapape! Naima lalyoo Jerusalema pelyamano. Pupala katatamanopa, Akalinya Ikiningi doko-kisa mendapu pitana lao propeta dupame pepa pyanya seteami dupa pitaka angi jeta. ");
INSERT INTO enq2_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Akalinya Ikiningi doko akali tata waka dupanya kinginya maitaminopa, dokaitame baa lamba lao, elya pisoo, sopokalimi pyatami. ");
INSERT INTO enq2_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Dopa petala, dokaitame baa konjame pyapala pyao kumasetataminopa, yuu gii tepo dokonya baa sakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pii dokonya tenge doko disaipolo dutupame nanyiami. Pii doko yalo petae katea dokonya, baame pii lea dupa auu pyoo masala naeyamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisasa baa Jeriko tengesa pyakameamopa, akali lenge monda mende muni tee lao kaitini lemba dokonya petea. ");
INSERT INTO enq2_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Peteamopa, endakali longo kaita ipao puiyamino sepala, doko aipa pilyape lao baame tipa pia. ");
INSERT INTO enq2_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dopa leamopa dokaitame baa lamaiyoo, “Nasarete tange Jisasa doko ipao pelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dokopa baame wii lao, “Dapita Ikiningi Jisasa, embame namba kondo kaeyapoko!” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dopa leamopa, endakali wambeami dupame baa pii kaena lao pyalanya leami. Dopa leaminopapi, baame etete puu lao wii lao, “Dapita Ikiningi, embame namba kondo kaeyapoko!” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dopa leamopa Jisasa katapala, akali doko laminao epena lea. Laminao tengesa ipateaminopa, Jisasame baa tipa pyoo, ");
INSERT INTO enq2_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nambame embanya aipa pyakapili lao masilyipi?” lea. Dokopa baame lao pituu, “Kamongo, namba lenge auu pyoo tao kandapu laka lao masilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dopa leamopa Jisasame baa lamaiyoo, “Embame namba tungi pilyino dokome, embanya lenge dolapo auu pisekelyamona, emba lenge auu pyoo taa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dopa lalu piamopa, baanya lenge dolapo auu pyoo talu petala, Jisasa watao pao pituu, Gote kenge andake maiyoo pea. Dokopa endakali dupa pitakame kandatala Gote mambo piami. ");
INSERT INTO enq2_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisasa baa Jeriko pyakamatala siti kaina dokonya-kaita pea. ");
INSERT INTO enq2_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Siti dokonya akali Sakiasa lenge mende katea. Akali doko baa takisa nyingi dupanya isingi mende. Baa oapi longo setenge. ");
INSERT INTO enq2_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Baame Jisasa doko apipi lao kandatoo latala kaitini kutiaka doko, endakali kambu mendeme Jisasa kakopao peaminopa, Sakiasa baa muu dokonyana, kapa pao Jisasa kandapenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dopa piamosa, baame Jisasa kaitini dokonya-kaita epelyamo lao kandatala, baa alo pyao wambatala, Jisasa kandatoo lao sikamoo ita mendenya kisia. ");
INSERT INTO enq2_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisasa baa ita tenge dosa ipao pituu, ulu kandalyetala, Sakiasa kandea. Kandatala baa lamaiyoo, “Sakiasa, namba indupa embanya andaka palipengena, emba yapa isa ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dopa leamopa baa pupae isa pyakanatala auu kaeyao Jisasa lanyia. ");
INSERT INTO enq2_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dopa piamo kandatala endakali dupa pitakame mumu lao, “Akali koo pingi dokonya andaka Jisasa palima pelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dokopa Sakiasa katapala Kamongo lamaiyoo, “Kamongo, embame sepe! Nambanya oapi dupa kapa-kapa lao mokosetala, endakali daa jepae dupa maitoo. Nambame endakali mende minakasetala, oapi mendapu nyio-tamo doko, dupa wakao palyoo kitomendeme yanu pyakamaitoana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dopa leamopa Jisasame baa lamaiyoo, “Akali dake baa Abraamenya ikiningiaka. Tenge dokonya, Gotenya pyoo nyingi doko indupa andaka dakenya ipatelyamo. ");
INSERT INTO enq2_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aipumape, Akalinya Ikiningi dokome endakali alu petae dupa kutao pyoo nyalanya epeana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisasa baa Jerusalema tengesa katea dokonya, endakali dupame baanya pii dupa sepala, Gotenya kingdom doko gii dokopaka panala ipanya pyumuna lao masiami. Dopa lao masiaminosa Jisasame kongali pii dake lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Baame lao pituu, “Akali kenge singi mendeme kiŋi nyepala pilyotona latala, yuu londati mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Paanya pituu, kalai akali akalita epena latala, silipa muni akalita mendai-mendai lao akali dutupa maiya. Maitala kalai akali dutupa lamaiyoo, ‘Namba ipatopa kaeyatamina, nyakamame bisinisa pyakao kalyepape’ latala baa pea. ");
INSERT INTO enq2_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pateamopa akali dokome isepenge endakali dokaitame baa imbu kaeyapala, ‘Akali doko baa naimanya kiŋi nakatena lao masilyamanona’ lao maitakao wai minao pena leami. ");
INSERT INTO enq2_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Baa kiŋi nyepala pilyiamopa, baanya kalai akali muni maiya dutupame bisinisa pyoo, wakao akipate nyekeamipi lao kandatoo latala, akali dokaita baa katea dokonya epena lena lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dokopa kalai akali wambao doko baanya akali andake dokonya enombanya ipupala lao pituu, ‘Akali Andake, embanya silipa muni mendai doko minao kalai petakala, wakao silipa muni akalita nyekeona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dopa leamopa baame kalai akali doko lamaiyoo, ‘Emba kalai akali epe dokome yaka pyekee-lamo! Nambame leoli pyoo embame muni kuki dutupa minao kalai pyekee-lamo dokonya, embame siti akalita isoo katape’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dopa lateamopa, kalai akali lapo pyoo doko ipupala lao pituu, ‘Akali Andake, embanya silipa muni mendai doko minao kalai petakala, wakao silipa muni yungi nyekeona’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dopa leamopa baame kalai akali doko lamaiyoo, ‘Embame siti yungi isoo katape’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Dopa lateamopa, kalai akali tepo pyoo doko ipupala lao pituu, ‘Akali Andake, emba akali tomba napae mende. Wakamanya dopale setapae dupa embame nyingi. Wakamanya nee pokatae dupanya embame mandenge. Tenge dokonya, nambame emba paka kaeyapala, embanya silipa muni mendai doko lapalapame yaki petala setekeona kanda’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dopa leamopa baame kalai akali doko lamaiyoo, ‘Emba kalai akali koo-lamo. Embanya pii lelyeno dutupameaka nambame emba-kisa tenge setatoo. Namba tomba napala, wakamanya dopale setapae dupa nyoo, wakamanya nee pokatae dupa mandyoo pilyopa embame kandenge-lumu doko, ");
INSERT INTO enq2_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","wakao mendatupa apata nyema ipatenopa lao, aipuma nambanya muni doko beŋenya setakala naeyepe?’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dopa latala baame akali tengesa kateami dupa lamaiyoo, ‘Silipa muni mendai baa-kisa silyamo doko nyepala, silipa muni akalita setelyamo akali doko maiyepa’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dopa leamopa dokaitame akali andake doko lamaiyoo, ‘Akali Andake, akali doko-kisa silipa muni akalita silyamona’ leami. ");
INSERT INTO enq2_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Dopa leaminopa akali andake dokome lao pituu, ‘Nambame nyakama langilyo: Longo lao singi endakali doko baa konda pyoo maita. Dopaka doko, nasingi endakali doko-kisa kuki seta dutupa baa-kisa nasina lao tange nyokonyeta. ");
INSERT INTO enq2_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nambanya yandapipi dupame namba kiŋi nakalyale lao masiamino dupa asa laminao ipupala, nambanya enombanya pyao kumasalapa’ leana” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisasame pii dutupa lao etapala baa wambao Jerusalema lalyoo paanya pea. ");
INSERT INTO enq2_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pao Olipimanda lenge dokonya taono Betepasapa, Betaniapa dolaponya tengesa pyakalyetala, baanya disaipolo lapoma wambao pena lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Pena latala dolapo lamaiyoo, “Yuu yakane nyakambanya enombatena silyamo dokonya pupa. Pao pyakamatambinopa, dongi ŋaŋa, paa mendaipi mende endakali napetenge mende anjetae katatamopa kanjambinona, doko tata lao minao dakenya ipupape. ");
INSERT INTO enq2_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Endakali mendeme tipa pyoo, ‘Aipuma dongi doko tata lelyambipi?’ lea-kandeno doko, nyakambame baa lamaiyoo, ‘Kamongome kalai mende dongi dakeme pipenge jilyamona’ lapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dopa lateamopa, pena lea akali dolapo pupala kandeambinopa, Jisasame leali petae katea. ");
INSERT INTO enq2_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Akali dolapome dongi ŋaŋa doko tata leambinopa, dongi tange dupame dolapo lamaiyoo, “Nyakambame dongi ŋaŋa doko aipuma tata lelyambipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dokopa akali dolapome lao pituu, “Dongi dakeme Kamongome kalai mende pipenge jilyamona” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dopa latala, akali dolapome dongi ŋaŋa doko minao Jisasa katea dokonya ipupala, dolaponya yonge pee kisa pingi dolapo lyokanya dongi maita dokonya setapala, Jisasa dokonya pisiami. ");
INSERT INTO enq2_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Baa pituu peamopa, endakali dupame nyakamanya yonge pee kisa pingi dupa kaitini dokonya kuiyami. ");
INSERT INTO enq2_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jisasa baa yuu Olipimanda dokonya lanao ipao Jerusalema tengesa pea. Dokopa baame mirakolo piamopa kandeami dupa pitaka baanya disaipolo kambu andake dokome masetala, eteke pyatala puu lao Gote mambo pyao tee piami. ");
INSERT INTO enq2_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mambo pyao lao pituu, “Kamongonya kengenya epelyamo kiŋi dake Goteme auu pisetae. Kaiti-kisa mona yaepenge doko setamopa, Gotenya kenge andake doko etete ketae kaitinya sinana” leami. ");
INSERT INTO enq2_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dokopa endakali kambu dokonya Parasi mendapu kateami dupame Jisasa lamaiyoo, “Mana Lenge, embanya disaipolo dupa pyalanya laa” leami. ");
INSERT INTO enq2_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Endakali dakaitame pii nalamili doko, kana dupame puu lao wii lamilina lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dopa latala, Jisasa Jerusalema tengesa pao pituu, baame siti doko kandatala, siti doko lao ee lao ");
INSERT INTO enq2_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","dapa lea: “Nyakamanya mona yaepao katenge mana dupa indupa nyakamanya gii dakepa kandami laka lao nambame masilyo. Dopaka doko, mana dupa nyakamame nakanjepale lao yalo petae kalyamo. ");
INSERT INTO enq2_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Goteme nyakama kanja epelyamo gii doko dakena lao nyakamame nakandelyamino dokonya, nyakamanya yandapipi dupa ipupala, nyakama kakopanya palyetala, kame pimbao, kaitini dupa pitaka lyokata gii doko ipata. Ipatamopa yandapipi dupame kamepi, anda kaname namba-namba pyoo petaepi, dupa pitaka kaluu nepatala, nyakamapi, nyakamanya wanepi, nyakamanya siti dokopi, dupa pitaka koeyasetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisasa lotuu anda nee nyetae kamapu dokonya pyakamatala, maketa setao kateamipi, sambao kateamipi, dupa tee pyao watao pia. ");
INSERT INTO enq2_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Watao pyao pituu, “ ‘Nambanya anda doko loma singi anda mendena’ lao pepa pyapae silyamo. Dopaka doko, nyakamame nambanya anda doko pake nenge dupanya yalo pingi panda jetelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Baame koteaka lao lotuu anda nee nyetae kamapu dokonya mana lamaiyoo kateamopa, prisa mupapi, Mosesanya loo mana nyepaepi, endakali dupanya isingi akalipi, dupame baa aipa petala pyao kumasemape lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kutiamiaka doko, endakali dupa pitakame Jisasanya pii doko semana lao etete auu kaeyaminosa, baa pyao kumasepenge kaitini mende kandao nanyiami. ");
INSERT INTO enq2_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gii dutupanya mendenya Jisasame lotuu anda nee nyetae kamapu dokonya endakali dupa mana lamaiyoo pituu, wai pii epe doko lao panao katea. Dokopa prisa mupapi, Mosesanya loo mana nyepaepi, isingi akalipi, dupa baa katea dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ipupala baa tipa pyoo, “Embame kalai pilyino datupa, kyeto aipale mendeme pilyi? Kyeto dia akali doko baa apipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame nyakama tipa mende pitoaka: Joneme kaimbu piamo doko, kaiti-kisa katao Goteme pina leape, pande endakalimi pina leami? Nyakamame namba langyepa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dokopa dokaitame nyakama-lapo laloo pyoo, “ ‘Kaiti-kisa katao Goteme pina leana’ latamano doko, baame lao pituu, ‘Aipuma nyakamame Jonenya pii doko kiningina lao masala naeyamipi?’ laapomo. ");
INSERT INTO enq2_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dopaka doko, endakali dupame Jone baa propetana lao kyeto joo masingima dokonya, ‘Endakalimi pina leamina’ naimame latamano doko, endakali dupa pitakame naima kaname pyao kumasetamina” leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dopa latala dokaitame Jonenya kaimbu pingi mana doko anja-tae nyiape lao masala naelyamanona lao yanu pyakamaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dokopa Jisasame dokaita lamaiyoo, “Nambame kalai pilyo datupa kyeto dopale mendeme pilyona lao nyakama langya naeyatoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dopa latala kongali pii dake endakali dupa lamaiyoo, “Akali mendeme waene ee mende pokea. Dopa petala baame waene dii mendatupa tange nyepengena lao, ee pokenge akali mendatupa lamaitala, ee doko isoo katekena lea. Dopa latala baa yuu londati mendenya gii longo pao katea. ");
INSERT INTO enq2_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Waene wambu pingi gii doko epeamopa, baanya kalai akali mende ee isakamaingi dupa kateami dokonya pupala, waene dii mendapu lyao peekena lao nyala pena lea. Kalai akali doko pateamopa, ee isakamaingi dupame baa pyao indyepala, mee pena leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dopa peteaminopa, ee tange dokome kalai akali mende apata pena leaka. Kalai akali doko pateamopa, ee isakamaingi dupame baa apata pyao indyepala, mana koo elya pipae mendapu baa-kisa minatala, mende naminao mee pena leamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dokopa ee tange dokome kalai akali mende tepo pyoo pena lateamopa, kalai akali doko apata pyao indyepala, kamalyatena pyale leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dokopa ee tange dokome lao pituu, ‘Nambame aipa pyuu? Nambanya ikiningi mona setenge doko kandatala, anda-anda semaitamino nakandenya, doko pena latoana’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dopa latala pena lateamopa wane doko epeamo kandatala, ee isakamaingi dupame nyakama-lapo laloo pyoo, ‘Wane dakeme takangenya moeya dupa nyepengena, moeya dupa naimanya jetana, baa pyao kumasemana ipupa’ leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dopa latala, wane doko waene ee dokonya kamalya pyale latala pyao kumasiami. Dopa piami dokonya, ee tange dokome ee isakamaingi dupa aipa pita? ");
INSERT INTO enq2_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Baa ipupala, ee isakamaingi dokaita pyao kumasetala, waene ee doko akali waka mendapuame isoo katekena lao maitana” lea. Dopa leamopa dokaitame sepala lao pituu, “Dopa napinana” leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dokopa Jisasame dokaita kandatae katao lao pituu, “ ‘Anda pingi dupame anda pipenge kana mende koeyapae-lamo latala yakineami doko kana mupa jetelyamona’ lao pepa pyapae silyamo dokonya tenge aipale mende palelya? ");
INSERT INTO enq2_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Endakali mende kana doko-kisa pyakatamo doko, kuli dupa lakao koeyata. Kana doko endakali mende-kisa ipao setamo doko, endakali doko indyoo koeyatakana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dokopa prisa mupapi, Mosesanya loo mana nyepaepi, dupame kongali doko nyakama lao lalumuna lao sepala gii dokopaka, baa anjemana lao kaitini kutiami. Dopaka doko, dokaita paka kaeyapala kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dokaitame Jisasa kandakondape pyoo kandatala, baame pii mende kopeta latamopa, baa minatala gapenanya pupu lapaepi, kyetopi dupanya maimana latala, akali mendapu kiningi mona paliu pele lao pupala, waa katao tipa pyaa pena leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","22","Dokopa akali dupame Jisasa tipa pyoo, “Mana Lenge, embame endakali mende mona setapala, mende maka kaeyala naenge. Embame kiningi pii doko lao, Gotenya pii manapi dupa tolao lengena lao naimame masilyamano. Dopana, Sisa doko naimame takisa maipengena lao loome latae singipi, nasingipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dopa leaminopa, dokaitame waa katao minakasalanya tipa piamino doko Jisasame kandatala dokaita lamaiyoo, “Aipuma nyakamame namba makande pilyami? ");
INSERT INTO enq2_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Muni konde mende kandatoo panasalapa. Muni dokonya apinya lenge-lyaapi, kengepi dupa kalyape?” lea. Dopa leamopa dokaitame pii yanu pyao, “Sisanya kalyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dokopa baame dokaita lamaiyoo, “Sisanya dupa Sisa tange maiyakamaiyepape. Gotenya dupa Gote tange maiyakamaiyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dokopa endakali dupanya enombanya baame pii lea dupanya baa kapa minapenge nanjia. Baame dokaitanya pii yanu pyakamaiyamo doko sepala, dokaita paka kaeyao walu latala, pii mende naleami. ");
INSERT INTO enq2_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Endakali kumapae dupa sakatala naeyatamina lengema, Sadyusi mendapu Jisasa katea dokonya ipupala baa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mana Lenge, Mosesame naimanya mana mende dapa lao pepa pyanya setekea-pyaa: ‘Akali mendeme enda nyepala wane manja naeyao kumatamo doko, baanya kaiminingi dokome enda walyakae doko pisetala, kaiminingi dokonya lao wane manjakamaipengena’ lao pepa pyanya setekea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dopana, wamba kaiminingi kalange kateami dutupanya kaiminingi mupa doko enda nyepala, wane manja naeyao baa kumia. ");
INSERT INTO enq2_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kumateamopa kaiminingi lapo dokome enda walyakae doko pisetala, wane manja naeyaowaka baa kumia. ");
INSERT INTO enq2_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kaiminingi tepo dokome enda walyakae dokoaka pisetala wane manja naeyaowaka baa kumia. Kaiminingi kalange dutupa pitakame enda walyakae doko pisetala, wane manja naeyaowaka dutupa kumiami. ");
INSERT INTO enq2_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dutupa pitaka kumao ete dokonya enda doko kumiaka. ");
INSERT INTO enq2_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kaiminingi kalange dutupa pitakame enda mendai dokoaka nyiami dokonya, endakali kumapae dupa sakatatami gii dokopa enda doko apinya jetape?” lao tipa piami. ");
INSERT INTO enq2_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Akali indupa palelyamino dupame enda nyoo, wanaku dupa akali nyala pao pilyamino. ");
INSERT INTO enq2_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dopaka doko, malunya sakatatala yuu enenge dokonya katapengena latae endakali dupa enda akalipa lao napititami. ");
INSERT INTO enq2_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Endakali dupa Goteme sakatasetamopa, enjele joo katao, baanya ikiningi wanengepi katatami. Tenge dokonya dupa dee kumala naeyatami. ");
INSERT INTO enq2_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ita saka mendenya ita yuli teana lao Mosesame pepa pia dokonya, Abraamepi, Aisakepi, Jekopepi dutupanya Gote doko baa Kamongo dokona leana lao pepa pia dokome, endakali kumapae dupa Goteme sakatasetana lao Mosesame apata lao panasetea. ");
INSERT INTO enq2_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Baa kumapae dupanya Gote daa. Baa saka katenge dupanya Gote. Gotenya enombanya endakali dupa pitaka saka kalyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dopa lateamopa, Mosesanya loo mana nyepae mendapuame pii yanu pyao, “Mana Lenge, embame pii auu pyoo lelyenona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gii dokonya pituu, dokaitame baa pii mende dee tipa pyaanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dokopa Jisasame dokaita lamaiyoo, “Endakali dupame Kraisa doko Dapitanya ikiningina lengema doko, aipa pyoo kandatala lengema? ");
INSERT INTO enq2_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wee buku dokonya Dapitame dapa lea: ‘Kamongome nambanya Kamongo doko lamaiyoo, “Emba nambanya kingi tolaetena piti. ");
INSERT INTO enq2_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Dokonya pititinopa, nambame embanya yandapipi dupa embanya moko setenge toko jina latona” leana’ lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dapitame Kraisa doko Kamongona lea-lumu doko, kaitini andukunya-kaita Kraisa doko Dapitanya ikiningipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Endakali dupa pitaka pii soo kateaminopa, Jisasame baanya disaipolo dupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mosesanya loo mana nyepae dupa nyakamame wandyoo kalyepape. Dokaita yonge pee londe pyoo petala kaitini paeyalanya auu kaengema. Maketa dupanya endakali dupame dokaita mambo pyao kingi nyimi laka lao masingima. Lotuu anda dupanya toko enomba nyoo dupanya pitimu laka lao masingima. Nee andake nelyami dupanya enomba nyoo pitimu laka lao masingimaka. ");
INSERT INTO enq2_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dokaitame enda walyakae dupa minakasetala, yuu andapi dupa nyingima. Endakali waka dupame dokaita epena lao masina latala, loma londe pyoo singima. Akali dupa-kisa tenge setatamopa, dupa tanda etete andake nyetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lotuu anda nee nyetae dokonya opaa pyandenge penge dokonya yuunya kamongo dupame muni pyandeaminopa, Jisasame kandamao kandea. ");
INSERT INTO enq2_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dokopa enda walyakae daa jepae mendeme muni konde yakane lapoma pyandeamo kandea. ");
INSERT INTO enq2_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kandatala baame lao pituu, “Nambame nyakama kiningi langilyo: Enda walyakae daa jepae dakeme muni pyandalamo dokome, endakali waka dupame muni pyandalamino dupa pitaka ita minao pyandalamo. ");
INSERT INTO enq2_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Endakali dokaitame nyakamanya muni longo sipya dupanya kakana nyoo Gote opaa maiyamino. Dopa piminopa, enda daa jepae dakeme baa tange napenge sipya dupa pitaka pyandalamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kana auu pipaepi, opaa maitaepi, dupame lotuu anda nee nyetae doko yati petae kalyamona lao endakali mendapuame leaminopa, Jisasame lao pituu, ");
INSERT INTO enq2_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gii doko ipatamopa, nyakamame kandelyamino datupa dopa petae katena lao kaeyala naenya kaluu nepataminopa, kana mendaipi mende namba-namba petae nakatatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dopa leamopa endakali dokaitame baa tipa pyoo, “Mana Lenge, embame lelyeno dutupa gii andukupa pita? Dutupa pyaanya tengesa pitamopa, kongali aipale mende pitape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dokopa Jisasame lao pituu, “Endakali mendeme nyakama minakasetana, kandao kalyepape. Aipumape, endakali longo mendapu nambanya kengenya ipupala lao pituu, ‘Namba akali dokona’ latami. ‘Gii doko tengesa ipatelyamona’ latamiaka. Dopa lataminopa, nyakamame dokaita watao napupape. ");
INSERT INTO enq2_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dokopa yanda andake mendapu pilyamino lapaepi, endakali dupame gapomane yanda pimailyamino lapaepi, dupa sepala nyakama paka nakaeyalapape. Dopale dupa wambao ipupenge. Dopaka doko, yuu etapenge gii doko, dokopa yapa naipatana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dopa latala baame dokaita lamaiyoo, “Akali tata mendeme akali tata mende yanda pimaita, kingdom mendeme kingdom mende yanda pimaita pitami. ");
INSERT INTO enq2_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yuu mendapuanya titiwali andake dupa minata, lopo andake dupa sepa, endakali longo-kisa yainame andinyeta pita. Kaiti-kisa katao makande paka pipaepi, mirakolo andakepi, dupa petae ipataka. ");
INSERT INTO enq2_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dopaka doko, dopale dupa pitaka ene pyaanya pitamopa, nyakamame nambanya kenge doko lao panelyamino latala, endakali dupame nyakama anjetala, tanda dyoo koeyasetala, lotuu andapi, anjingi andapi dupanya laminao patami. Laminao pupala, kiŋipi, gapenapi dupanya enombanya katasetami. ");
INSERT INTO enq2_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dopa pitami dokome, nyakamame kandelyaminopi, silyaminopi dupa lao panalapale lao kaitini mende setakatami. ");
INSERT INTO enq2_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Pii lapengepi, masepae epepi, dupa nambame nyakama ditopa, nyakamanya yandapipi dupanya mendaipi mendeme kapa pao nyakamanya pii tanga laa naeyao, nyakama ita minala naeyaowaka pitami. Dopana, nyakamame pii dupa aipa pyoo yanu pyamanape lao wambao mona kenda nakaeyalapape. ");
INSERT INTO enq2_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nyakamanya endangipi, takangepi, tatapi, kaita miningipi, kaiminingipi dupame nyakama yanda singi dupanya kinginya maitami. Dopa pitaminopa, dupame nyakamanya mendapu pyao kumasetami. ");
INSERT INTO enq2_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nyakamame nambanya kenge doko lao panelyamino latala, endakali dupa pitakame nyakama imbu kaeyatami. ");
INSERT INTO enq2_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Dopaka doko, nyakamanya aiyomba iti dupanya mendaipi mende alu napita. ");
INSERT INTO enq2_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nyakama kyeto joo katatami dokome, nyakamanya lete katenge doko nyetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nyakamame kandataminopa, amii kambu longo mendapuame Jerusalema kakopanya palyetami. Gii dokopa, Jerusalema koeyapenge doko tengesa petelyamona lao masalapape. ");
INSERT INTO enq2_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Koo dupanya yanu pyao Goteme tanda maipenge gii dokonyana, Gotenya pii pepa pyapae singi dupa pitaka angi jeta. Dopana, endakali Judia katatami dupa yuu manda dupanya paka pupenge jeta. Jerusalema katatami dupa siti doko yakinapenge jeta. Eenya katatami dupa Jerusalema pilyala naeyapenge jeta. ");
INSERT INTO enq2_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Gotenya imbu kaenge andake doko akali tata dake-kisa ipatamopa, yuu dakenya kenda etete andake ipata. Gii dokopa enda wane tongotapi, enda wane andu nengepi, dupa etete kondo pita. ");
INSERT INTO enq2_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dopa pitamopa, endakali yangi dupa konjuwame pyao kumasetala, yangi dupa anjetala laminao yuu waka dupanya patami. Gii dokopa, akali tata waka dupame Jerusalema moko katao nepao pao, dopa pyoo etatamina lao gii setapae dokonya tuu latamina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nikipi, kanapi, buipi dupanya kongali mendapu pita. Dokopa solowata andake dupa buli pyao, oo lao, lakao ipatamopa, yuu dakenya akali tata longo mendapu aipa pimape lao masala naeyapala pakame kumatami. ");
INSERT INTO enq2_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kaitinya kyeto singi dupa ema-ema pitamopa, kenda andake mendapu yuu dakenya ipatelyamona lao kandatala, endakali dupa mona andao, pakame lombapae setami. ");
INSERT INTO enq2_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dokopa Akalinya Ikiningi doko baanya kyetopi, tii pipae andakepi dupanya pituu, kopa mendenya tambetambe ipatamopa endakali dupame kandatami. ");
INSERT INTO enq2_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nambame lelyo datupa tee pyao ipatamopa, nyakama mokao nyepenge doko tengesa ipatelyamona lao masetala, nyakama toeya katapala kandalyetae kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dokopa Jisasame kongali mende dokaita lamaiyoo, “Nyakamame piki itapi, ita waka dupa pitakapi, dupa kanjepape. ");
INSERT INTO enq2_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ita dupanya mange popo pilya dupa kandatala, paina pyaanya tengesa pilyamona lao nyakamame masingima. ");
INSERT INTO enq2_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dopana, lelyo dutupa pitamopa nyakamame kandatala, Gotenya kingdom doko ipanya tengesa petelyamona lao masalapape. ");
INSERT INTO enq2_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nambame nyakama kiningi langilyo: Endakali indupa palelyamino dupa kumao etala naeyataminopa, lelyo dutupa pitaka pita. ");
INSERT INTO enq2_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yuupa kaitipa dolapo alu pita. Dopaka doko, nambanya pii dupa alu napitana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Yuu dakenya endakali palelyamino dupa pitaka-kisa gii doko ipata. Dopa pitana, yongenya koo pyoani kaengepi, bia nao kyakengepi, yuu dakenya nee kaeyapae singipi, dupanya-kaita nyakama isa pyakataminopa, kone makatae lokalyingili pyoo, gii doko nyakama-kisa lee mendai ipatana, kandao kalyepape. ");
INSERT INTO enq2_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Koteaka lao nyakama lenge tao kalyepape. Goteme nyakama epena lao masetamopa, pita dutupa pitakanya paka pupala, Akalinya Ikiningi dokonya enombanya katatamanopa lao loma soo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yuu gii dii lao, lotuu anda nee nyetae kamapu dokonya Jisasame mana lamaitapu, yuu kuiyala epeamopa, Olipimanda lenge dokonya pao palipa pia. ");
INSERT INTO enq2_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dopa piamopa, endakali dupa pitaka yongama wamba sakatatala, lotuu anda nee nyetae kamapu dokonya pii sala ipata piami. ");
INSERT INTO enq2_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Breta Yisa Pyandala Naeyao Yangapae Nengema, Pasopa lenge gii doko ipanya tengesa pia. ");
INSERT INTO enq2_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dokopa prisa mupapi, Mosesanya loo mana nyepaepi, dupame endakali dupa paka kaeyami dokonya, aipa petala Jisasa yalo pyoo pyao kumasemape lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dokopa 12 disaipolo dutupanya mende Judasa, kenge mende Iskariota lenge doko-kisa Satane ipao landa pia. ");
INSERT INTO enq2_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dokopa Judasa baa prisa mupapi, lotuu anda nee nyetae dokonya yanda singipi, dupa kateami dokonya pupala, baame aipa petala Jisasa nyakamanya kinginya ditoape leamopa dokaita-pipa pii leami. ");
INSERT INTO enq2_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pii latala dokaitame auu kaeyapala, muni mendatupa Judasa maimana lao pii yaki piami. ");
INSERT INTO enq2_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dopa petala, Judasame pii doko yakana latala, endakali kambu dupa nakatataminopa dokaitanya kinginya Jisasa maiyanya kaitini kutao katea. ");
INSERT INTO enq2_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Breta Yisa Pyandala Naeyao Yangapae Nengema gii dokonya, Pasopa gii doko kandao nyoo, sipisipi ŋaŋa pyao yangapenge gii doko epeamopa, ");
INSERT INTO enq2_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisasame Pitapa, Jonepa dolapo pena latala lamaiyoo, “Pasopa nee doko namana, depa laa pupa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dopa leamopa dolapome baa lamaiyoo, “Nalimbame anja depa lapale lao masilyipi?” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dokopa baame dolapo lamaiyoo, “Salapape! Nyakamba siti dokonya pyakamatambinopa, endaki kamuu singi akali mendeme nyakamba kandanyalapomona, doko watao pupape. Pupala, baa kolandata andaka dokonya nyakamba apata kolandatala, ");
INSERT INTO enq2_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nyakambame anda tange doko lamaiyoo, ‘Mana Lenge dokome baanya disaipolo dupa-pipa Pasopa nee doko namana, panda doko andusa silyape lelyamona’ lao lamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lamaitambinopa baame anda ketae mendenya ruma andake, depa latae mende laitaka pyaapomona, dokonya nyakambame nee doko depa lapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dolapo pupala, Jisasame lealiaka petae siamo kandatala, Pasopa nee doko depa leambi. ");
INSERT INTO enq2_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nee napenge awa doko epeamopa, Jisasa baa 12 aposole dutupa-pipa nee nao peteami. ");
INSERT INTO enq2_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Peteaminopa baame dutupa lamaiyoo, “Namba tanda andake ene nyalanya, Pasopa nee dake nyakama-pipa wambao natamana lao nee kaeyao masoo katapu. ");
INSERT INTO enq2_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dopana nambame nyakama langilyo: Pasopa nee mende namba nanaowaka katao, nee dokonya tenge angi doko Gotenya kingdom dokonya panatamopa natona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dopa latala baame kapo waene peteta mende nyepala, Gote yaka pilyino latala lao pituu, “Dake nyepala nyakamame kapa-kapa lao mokosoo nalapa. ");
INSERT INTO enq2_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nambame nyakama langilyo: Namba waene nala naeyaowaka katao, Gotenya kingdom doko ipatamo gii dokonya tuu latona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dopa latala baame breta mende nyepala, Gote yaka pilyino latala konjia. Konjepala dokaita maiyoo pituu dapa lea: “Dake nambanya yonge doko, nyakama nisoo setekelyona, nyakamame namba masoo nalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nee nao etapala, mendai dopaka pyoo baame kapo waene peteta mende nyepala lao pituu, “Kapo dakenya nambanya taeyoko pilyamo doko kai lekelyo dokome, pii enenge mende lao yaki pinya setelyo. ");
INSERT INTO enq2_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dopaka doko, namba yandapipi dupanya kinginya maiyapomo akali doko namba pilyo dakenya apata pilyambano. ");
INSERT INTO enq2_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Goteme masiamo dokonya-kaita Akalinya Ikiningi doko kiningi kumala pupenge. Dopaka doko, baa yandapipi dupanya kinginya maiyapomo akali doko koeyalapomona!” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pii doko sepala, “Apimi dopa pyaanya pilyamape?” lao tee pyao nyakama-lapo tipa pii-pii piami. ");
INSERT INTO enq2_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dokopa disaipolo dupame nyakamanya api alyasale joo kalyape lao nyakama-lapo pii yanda piami. ");
INSERT INTO enq2_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dokopa Jisasame dokaita lamaiyoo, “Akali tata waka dupanya kiŋi dupame nyakama alyasale joo katao, endakali isoo katengema dupa kyeto joo isingima. Akali tata waka dupanya isingi akali dupa kenge Nisingi Akali lengema. ");
INSERT INTO enq2_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dopaka doko, nyakamanya kainanya mana dopale dupa naseta. Nyakamanya mende alyasale joo katate doko, wane kole joo katapenge. Nyakamanya mende isingi akali katate doko, kalai akali joo katapenge. ");
INSERT INTO enq2_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Api alyasale joo kalya? Nee nao petenge doko alyasalepe, pande nee yangao setakamaingi doko alyasale? Nee nao petenge doko alyasale daape. Dopaka doko, namba nyakamanya kainanya kalai akali joo kalyo. ");
INSERT INTO enq2_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Namba-kisa makande pipae ipumupa, nyakama namba-pipa apata kalyamano. ");
INSERT INTO enq2_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dopana, nambanya Takangeme kingdom mende nambame isatale lao diamoli pyoo, kingdom mende nyakamame isalapale lao nambame dilyo. ");
INSERT INTO enq2_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nyakama nambanya nee setao nenge toko dokonya nee endakipi nao pitipa, kiŋi toko mendapuanya pituu Israele tata 12 dutupa yapata pitaminopa lao dilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Dokopa Kamongome Saimone Pita lamaiyoo, “Saimone, Saimone, embame sepe! Wita lyanda-lyanda lao angi imbupi yapengeli pyoo, Sataneme nyakama lyanda-lyanda lao yapalanya Gote-kisa tee latelyamo. ");
INSERT INTO enq2_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Embame namba tungi pingi doko yakinala naeyatale lao nambame embanya kyeto joo loma sekeo. Dopa pyekeona, emba mona kapilyete gii dokopa, embanya Kristene kaiminingi dupa kyeto jisepe” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dopa leamopa Pitame baa lamaiyoo, “Kamongo, emba anjetae patenopapi, kumala patenopapi, dupanya namba apata patambana lao depa latae kalyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dopa leamopa Jisasame lao pituu, “Pita, nambame emba langilyo: Indupa kuka gii dakepa, yaka pauli pii laa naeyatamopa, paa tepomasa embame namba nakandengena laapenona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dokopa Jisasame dokaita lamaiyoo, “Nyakama munipi, nokainapi, moko peepi mende namandyoo mee pupape leo dokopa, nyakama dopale mende daa jiape?” lea. Dokopa dokaitame lao pituu, “Naima dopale mende daa nanjiana” leami. ");
INSERT INTO enq2_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dokopa baame dokaita lamaiyoo, “Indupa nyakama-kisa munipi, nokainapi mende setamo doko, nyoo minalapape. Nyakamanya mende konjuwa daa jia-kandeno doko, embanya yonge pee kisa pingi doko salimi latala konjuwa mende sambape. ");
INSERT INTO enq2_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gotenya pii pepa pyapae singi dake namba-kisa angi jepenge: ‘Loo yalenge dupa-pipa baa apata nyoo palyoo itaki piamina’ lao pepa pyapae singi doko indupa namba-kisa kaeyala naeyao angi jilyamona lao nambame nyakama langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dokopa dokaitame lao pituu, “Kamongo, konjuwa lapoma asa silyamona kanda” leami. Dokopa baame dokaita lamaiyoo, “Yaka-lumuna kaeyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Dopa latala Jisasa siti doko yakinatala, Olipimanda pengeli pyoo peamopa, baanya disaipolo dupame baa watao peami. ");
INSERT INTO enq2_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Panda dokonya pao pyakalyetala, baame dokaita lamaiyoo, “Makande pipae dupa nyakama-kisa naepena lao loma salapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dopa latala baame dokaita yakinatala, omosale pao luma lakapala loma sia. ");
INSERT INTO enq2_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Loma soo pituu, “Apane, kapo kenda paleta mende nalapo dake embame nyoo nepakatoo lao masii-kandeno doko, nyoo nepakape. Dopaka doko, nambame masilyo dokonya-kaita napipi. Embame masilyino dokonya-kaita pipi” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dokopa kaitinya enjele mende ipao kalyu petala, baa kyeto maiya. ");
INSERT INTO enq2_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dopa piamopa, Jisasa baa mona etete kenda kaeyapala, kyeto joo loma siamopa, baanya enaputi dupa taeyoko joo dopo lao isa yuunya pea. ");
INSERT INTO enq2_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Baa loma soo etapala toeya katea. Toeya katapala ipao disaipolo dupa kandeamopa, dupa mona kenda kaeyapala luu paliu siami. ");
INSERT INTO enq2_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dokopa baame dokaita lamaiyoo, “Nyakama aipuma luu paliu silyami? Nyakama sakatatala, makande pipae dupa nyakama-kisa naepena lao loma salapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisasame dopa lao kateamopa, baanya 12 disaipolo dutupanya mende, Judasa lenge dokome endakali kambu mende laminao ipupala, Jisasa nunu pitoo lao baa katea tengesa dosa pea. ");
INSERT INTO enq2_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dokopa Jisasame baa lamaiyoo, “Judasa, embame nunu pilyino dokome Akalinya Ikiningi doko yandapipi dupanya kinginya mailyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Dopa leamopa, mende pyaapome-lamo lao Jisasa-pipa kateami dupame kandatala baa lamaiyoo, “Kamongo, naimame konjuwame pyamape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dopa latala akali dupanya mendeme prisa mupa dokonya kalai akali dokonya kale tolaetena konjuwame lyanya nepea. ");
INSERT INTO enq2_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dokopa Jisasame lao pituu, “Dopa napinya kaeyalapa!” lea. Dopa latala baame akali dokonya kale doko kingimi watandeamopa, katengeli pia. ");
INSERT INTO enq2_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dokopa Jisasame prisa mupapi, lotuu anda nee nyetae dokonya yanda singipi, Juumanya isingi akalipi, baa anjala epeami dupa lamaiyoo, “Pake nenge mende anjala epele lao nyakamame konjuwapi, kolyepepi dupa minao epelyamipi? ");
INSERT INTO enq2_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Koteaka lao namba nyakama-pipa lotuu anda nee nyetae kamapu dokonya kateamanopa, nyakamame namba anjala naeyami. Dopaka doko, iminjetaenya pupu lapae dokopa, awa dakepa, dolapo nyakamanyana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dokopa dokaitame Jisasa minatala laminao, prisa mupa dokonya andaka kolandeami. Dopa piaminopa, Pita baa kuki londatili joo watao pea. ");
INSERT INTO enq2_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pupala, anda kamapu kaina dokonya endakali mendapuame ita yangatala peteami dupa-pipa Pita apata petea. ");
INSERT INTO enq2_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dokopa itate tii pia dokonya Pita peteamopa, kalai wanaku mendeme baa kandakondape pyoo kandatala lao pituu, “Akali dake apata Jisasapa kateambina” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dopa leamopa Pitame tanga lao, “Wanaku, nambame akali doko nakandengena” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gii kuki pateamopa, akali mendeme Pita kandatala lao pituu, “Emba apata akali dutupanya mendena” lea. Dopa leamopa Pitame lao pituu, “Wane, namba dutupanya mende daana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Awa mendai joo pateamopa, akali mendeme lao pituu, “Akali dake apata Galali tange dokonyana, kiningi etete Jisasapa kateambina” lao kyeto joo lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dopa leamopa Pitame lao pituu, “Wane, embame pii lelyeno doko aki mende lelyepe lao nambame masala naelyona” lea. Dopa lalu piamopa, yaka pauli pii mende lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pauli pii doko lateamopa, Kamongo kapilyetala Pita kandakondape pia. Dopa piamopa, Kamongome Pita lamaiya pii datupa Pitame masia: “Yaka pauli pii ene laanya pitamopa, paa tepomasa embame namba nakandengena laapenona” lea dutupa masetala, ");
INSERT INTO enq2_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita kamaka pyakalyetala, ee lao putukia. ");
INSERT INTO enq2_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisasa isetae kateami akali dupame baa lamba latapu, pyao indyepa piami. ");
INSERT INTO enq2_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dokaitame baanya lenge-lyaapi yaki petala pyao pituu, “Emba pyalumu akali doko, dokona lao propesi piimi laa” leami. ");
INSERT INTO enq2_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dopa latala baa lao nepao, pii koo longo mendapu leamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yuu yongeamopa, prisa mupapi, Mosesanya loo mana nyepaepi, Juumanya isingi akali dupa kambuiyami. Kambuiyami dokonya Jisasa laminao pateaminopa, dokaitame lao pituu, ");
INSERT INTO enq2_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Emba Kraisa doko-tamo doko, naima langi” leami. Dokopa Jisasame dokaita lamaiyoo, “Nambame nyakama langipuli doko, nyakamame kiningina lao masala naeyamili. ");
INSERT INTO enq2_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nambame nyakama tipa mende pipuli doko, nyakamame yanu pyala naeyao, namba paale lao yakinala naeyamiliaka. ");
INSERT INTO enq2_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dopaka doko, indupa pituu Akalinya Ikiningi doko, Gote etete kyeto dokonya kingi tolaetena pilyapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dokopa dokaita pitakame lao pituu, “Dopa lelyeno doko, emba Gote Ikiningi dokope?” leami. Dokopa baame dokaita lamaiyoo, “Nyakamame namba dokona lao latelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dopa leamopa dokaitame lao pituu, “Baame pii lelyamo dutupa sepelyamano doko, aipuma endakali mendenya deaka pii nyemanape?” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dokopa akali kambuu peteami dupa pitaka sakatatala, Jisasa laminao Pailata katea dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pupala tee pyao baa-kisa tenge setao, “Akali dakeme naima tata dupanya kainanya pundu andake mende yaka lasoo, Sisa doko muni takisa namaiyepape lao kaita lyokata, baa Kraisa, kiŋi mendena lao baa tange lata piamopa naimame kandeamana” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dokopa Pailatame baa tipa pyoo, “Emba Juumanya Kiŋi dokope?” lea. Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Embame latelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dokopa Pailatame prisa mupapi, endakali kambu pyao kateamipi, dupa lamaiyoo, “Nambame akali dake-kisa tenge mende kandao nanyilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dokopa dokaitame kyeto joo lao pituu, “Akali dakeme Galali katao tee pyatala, Judia yuu yakane dupa pitakanya mana lamaiyoo, endakali dupa ingi tuu lasoo ipao, dakenya dopaka pilyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Galali leami doko Pailatame sepala, akali doko baa Galali tangepe lao tipa pia. ");
INSERT INTO enq2_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jisasa doko Eroteme yuu isingi dokonya tange mende-lumu lao Pailatame sepala, baa laminao Erote katea dokonya pena lea. Gii dokopa Erote baa Jerusalema katea. ");
INSERT INTO enq2_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wamba Eroteme Jisasanya lao pii longo mendapu sepala, mirakolo mende pitamopa kandapu laka lao masoo, gii longo nee kaeyao malisoo katea. Kateamopa, Jisasa epeamo kandatala etete auu kaeya. ");
INSERT INTO enq2_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Auu kaeyapala Eroteme Jisasa tipa longo mendapu piamopa, baame dupanya yanu pyao pii mende nalea. ");
INSERT INTO enq2_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Dokopa prisa mupapi, Mosesanya loo mana nyepaepi, dupa tengesa katapala, kyeto joo baa-kisa tenge seteami. ");
INSERT INTO enq2_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dopa piaminopa Erotepi, baanya amiipi dupame Jisasa-kisa mana koo mendapu minatapu, baa lamba leami. Lamba latala, Eroteme yonge pee etete auu petae mende Jisasanya petakamai, baa laminao Pailata katea dokonya pilyina lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wamba Pailatapa, Erotepa dolapo yandapipi joo katengembaka doko, gii dokopa tee pyao nyakamba mona seteambi. ");
INSERT INTO enq2_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dokopa Pailatame prisa mupapi, isingi akalipi, endakali dupapi, dupa ipao kambu pina latala ");
INSERT INTO enq2_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","dokaita lamaiyoo, “Akali dakeme pundu andake mende yaka lasalanya pilyamona lao nyakamame baa laminao nambanya enombanya ipamino. Dokopa baa-kisa tenge mende silyape lao nyakamanya enombanya nambame tipa pipupa, tenge angi mende kandao nanyolo. ");
INSERT INTO enq2_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dopa petala, nambame nyakama Erote kanja pupa lapupa, baame tenge angi mende kandao nanyalamoaka. Akali dake pyao kumasepenge koopi mende baame napia-lamo. ");
INSERT INTO enq2_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Dopana, nambame baa kende konjame pyapala yakinatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nee andake nenge gii doko epelyamoli pyoo, Pailatame akali anjetae dupanya mende mokata pyakamaingi. ");
INSERT INTO enq2_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Jerusalema dokonya akali Barabasa lenge mendeme wamba gapomane yanda pimaita, endakali pyao kumaseta petala anjetae palea. Endakali dupa pitakame puu lao, lao pituu, “Jisasa pyao kumasetala, Barabasa mokoka” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Dopa leaminopa Pailatame Jisasa mokapuli lao masetala, baa pyao kumasala naeyapengena lao deaka lamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dokopa dokaitame puu lao, lao pituu, “Baa poko itanya pyao yuku! Pyao yuku!” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dokopa Pailatame paa tepo pyoo dokaita lamaiyoo, “Aipuma? Baame koo aki mende pipya? Baa pyao kumasepenge tenge mende nambame kandao nanyilyona, baa kende konjame pyapala yakinatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dopa leaka doko, endakali dokaitapi, prisa mupapi dupame kongo lao, baa pyao yukuina lao, puu lao leami dokome, Pailatanya pii doko pyaanya isa palyiami. ");
INSERT INTO enq2_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Dopa piaminosa, dokaitanya leamili pina kaeyatoo lao Pailatame masia. ");
INSERT INTO enq2_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akali mendeme gapomane yanda pimaita, endakali pyao kumaseta piamosa anjinya pyandeami doko mokokena leamili pyoo Pailatame mokatala, Jisasa endakali dupanya masiamili pina lao amii dupa maiya. ");
INSERT INTO enq2_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dokopa amii dupame Jisasa pyao yukulanya laminao peaminopa, akali Sairini tange Saimone lenge doko yuu yakane mendenya katao epea. Epeamopa amii dupame baa minatala, poko ita doko baanya latainya nyoo sakamaitala, soo Jisasa watao pena leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dokopa enda mendapuame baa lao ee lao yamataka leami dupapi, endakali waka longo mendapupi, dupa kambu pyao baa watao peami. ");
INSERT INTO enq2_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dokopa Jisasame kapilyetala dokaita lamaiyoo, “Nyakama Jerusalema tange enda dupame namba lao ee nalenya, nyakama tangepi, nyakamanya wanepi dupa lao ee lapa. ");
INSERT INTO enq2_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aipumape, gii doko palitamopa endakali dupame lao pituu, ‘Enda ingi pyakilyetaepi, enda wane namandengepi, enda wane andu namaingipi, dupa Goteme auu pisetaena’ latami. ");
INSERT INTO enq2_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dokopa endakali dupame tee pyao yuu manda dupa lamaiyoo, ‘Nyakama tanapala naima pyala ipupa’ latami. Dopa latala, yuu manda yakane dupa lamaiyoo, ‘Naima sanga pyambala ipupa’ latamiaka. ");
INSERT INTO enq2_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ita saka doko-kisa dopa pilyamino doko, ita sapu doko-kisa aipa pitamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dokopa akali makongao koo pingi lapoma, Jisasa-pipa pyao yukulanya laminao peami. ");
INSERT INTO enq2_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Laminao pao yuu Matena Kuli lenge dokonya pyakalyetala, Jisasa baa akali makongao koo pingi lapoma dolapo-pipa pyao yukuiyami. Mende doko baanya kingi tolaetena pyao yukuiyami. Mende doko baanya kingi koeyatena pyao yukuiyami. ");
INSERT INTO enq2_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pyao yukuiyaminopa Jisasame lao pituu, “Apane, dakaitame masala naeyao pilyaminona, dupanya koo dupa kame sakamaipi” lea. Dokopa amii dupame baanya yonge pee dupa mokosoo nyemana latala laki piami. ");
INSERT INTO enq2_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gii dokopa, Juumanya isingi akalipi, endakali kandatae kateamipi, dupame Jisasa lamba lao, “Baame endakali waka dupa pyoo nyipyana, baa Gotenya yapao nyepae Kraisa-tamo doko, baa tange pyoo nyina kae” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Dokopa amii dupa tengesa ipupala, waene kaa pipae mende nena lao makapusoo pituu, baa lamba lao, ");
INSERT INTO enq2_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Emba Juumanya kiŋi-tamo doko, emba tange pyoo nyepoko” leami. ");
INSERT INTO enq2_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisasa yukutae katea poko ita ketae dokonya, Giriki piipi, Latene piipi, Ibru piipi dupame dapa lao pepa pyatae katea: “Dake Juumanya kiŋi dokona” latae katea. ");
INSERT INTO enq2_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Makongao koo pingi lapoma pyao yukuiyami dolaponya mendeme Jisasa lamba lao, “Emba Kraisa doko-tamo doko, emba tange pyoo nyoo, nalimba apata pyoo nyoaka pipoko” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dokopa makongao koo pingi mende dokome akali doko pyalanya lao, “Jisasa pyao yukupengena leamo pii mendai dokoaka emba-kisa latae silyamo doko, embame Gote paka nakaelyepe? ");
INSERT INTO enq2_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nalimbame koo piambano dokonya yole nyepenge doko tolao nyilyambano. Dopaka doko, akali dakeme koo mende napiana” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dopa latala baame Jisasa lamaiyoo, “Kamongo, embanya kingdom dokonya ipate gii dokopa namba masepe” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dokopa Jisasame baa lamaiyoo, “Nambame emba kiningi langilyo: Indupaka emba namba-pipa Gotenya yuu etete epe dokonya kalyambanona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Gii dokopa kotaka 12 kilokopi mende leamopa, yuu doko pitaka kuiya. Kuiya doko kuiyetaeyaka katao pao, alemandi 3 kilokonya tuu lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Gii dutupanya niki tii napia. Dokopa 3 kilokonya, lotuu anda nee nyetae dokonya panda nee nyetae dotena kame pinyoo lapalapa andake mendeme kame pinyetae katenge doko titi pyao lapo pyoloo pia. ");
INSERT INTO enq2_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dokopa Jisasame puu lao wii lao, “Apane, nambanya imambu doko embanya kinginya yakinelyona” lea. Dopa latala baanya imambu doko yakinea. ");
INSERT INTO enq2_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pia dupa pitaka amii 100 isingi dokome kandatala, Gote mambo pyao, “Kiningi etete, akali dake tolatae mende-lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kandamana lao endakali kambu pyatae kateami dupame piamo doko kandatala, mona kenda kaeyao andaka pilyiami. ");
INSERT INTO enq2_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Endakali Jisasa kandengema dupa pitakapi, enda Galali tange Jisasa watao epeamipi, dupa kuki londatili katapala, piami dupa pitaka kandatae kateami. ");
INSERT INTO enq2_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Akali Josepe lenge mende, Juumanya taono Arimatia dokonya tange doko katea. Baa Juumanya kanjole dupanya mende. Baa akali tolatae epe mende. Kanjole yangi dokaitame masiamipi, mana miniamipi dupanya baame yakana nalea. Baame Gotenya kingdom doko malisoo katenge. ");
INSERT INTO enq2_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Akali doko Pailata katea dokonya pupala, Jisasanya yonge doko dina lao tee lea. ");
INSERT INTO enq2_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dokopa Pailatame yakana lateamopa, Jisasanya yonge doko kondao nyepala, lapalapa kyeo lapae mendeme yaki petala, malu pipenge kana tumbinya setapae, endakali malu napiami mendenya nyoo setea. ");
INSERT INTO enq2_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Setea gii doko, Sambata depa lenge dokonya, Sambata gii doko ipanya tengesa pia. ");
INSERT INTO enq2_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Dokopa enda mendapu Galali pituu, Jisasa-pipa epeami dupame watao pupala, malu doko kandata, Jisasanya yonge doko dopa pyoo setelyamo lao kandataka piami. ");
INSERT INTO enq2_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dopa petala dokaita pilyetala, tunduma pingipi, welepi mendapu depa leami. Depa latala, Gotenya mana setapae dokome Sambatanya koto nyalapape latae singili pyoo koto nyiami. ");
INSERT INTO enq2_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Enda dutupapi, dutupa-pipa enda peteami dupapi, dupa Sande gii dokonya yongama wamba sakatatala, tunduma pingi mendapu depa lanya seteami dupa nyoo malu dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pupala kandeaminopa, malu kambu dokonya kana piti petae doko kapilya mina-mina pyoo nyoo kapya latae katea. ");
INSERT INTO enq2_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dokopa enda dutupa malu dokonya kolandatala kandeaminopa, Kamongo Jisasanya yonge doko nasia. ");
INSERT INTO enq2_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nasiamosa aipa pyaape lao etete tatake kaeyao kateaminopa, akali lapoma yonge pee etete kyeo lao polepole pipae pingi mendalapo ipao kalyu piambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dokopa enda dutupa paka kaeyapala yuu kandanatae kateaminopa, akali dolapome dokaita lamaiyoo, “Nyakamame aipuma akali saka katenge doko endakali kumapae setenge panda dakenya kutilyami? ");
INSERT INTO enq2_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Baa dakenya nasilyamo. Baa sakatatalamo. Baa Galali kateamo gii dokopa nyakama langyoo, ‘Akalinya Ikiningi doko endakali koo pingi dupanya kinginya maitaminopa, dupame kaeyala naeyao baa poko itanya pyao yukutami. Dopa petataminopa, yuu gii tepo dokonya baa kaeyala naeyao sakatatana’ leamo doko masalapa” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dopa leambinopa enda dutupame Jisasanya pii dupa masiami. ");
INSERT INTO enq2_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Masetala enda dutupa malu doko yakinatala pilyiami. Pilyetala, pia dupa 11 aposole dutupapi, endakali waka apata kateamipi, dupa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aposole dupa lamaiyami enda dutupa datupa: Magadala tange Maria dokopi, Joanaapi, Jemesa endangi Maria dokopi, dutupa-pipa enda mendapu peami dupapi, dutupa. ");
INSERT INTO enq2_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lamaiyaminopa siami endakali dupame mee lelyaminona lao masetala, kiningi lelyaminona lao masala naeyami. ");
INSERT INTO enq2_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dopaka doko, Pita sakatatala alo pyao malu dokonya pupala, elyo pyao kandeamopa, lapalapa kyeo lapae dupa iki siamo kandea. Kandatala andaka pilyoo pituu, pia dupanya moname longo lao masoo pea. ");
INSERT INTO enq2_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yuu gii dokopaka, disaipolo lapoma yuu yakane Emeasa lenge dokonya paanya peambi. Emeasa doko Jerusalema katao 11 kilomita joo singi. ");
INSERT INTO enq2_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Akali dolapome kaitinisa pao pituu, pia dupa pitakanya atome lao peambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Atome lao peambinopa, Jisasa ipao tengesa pyakaeyalu petala, akali dolapo-pipa peami. ");
INSERT INTO enq2_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dopaka doko, baa doko-lamo lao nakandena lao akali dolaponya lenge iminjia. ");
INSERT INTO enq2_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dokopa Jisasame dolapo lamaiyoo, “Nyakambame kenda kaeyao aki pii mende lao pelyambipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dopa leamopa, akali dolaponya mende, Kiliopasa lenge dokome baanya pii yanu pyakamaiyoo, “Endakali opone Jerusalema epeamino dupanya embame iki yuu gii datupanya pipumu dupa nakandapipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dopa leamopa baame dolapo lamaiyoo, “Dupa aki mendapupi?” lea. Dokopa akali dolapome baa lamaiyoo, “Nasarete tange Jisasa doko-kisa pipumu dupanya lelyambano. Akali doko baa propeta mende. Gotenya enombanyapi, endakali dupa pitakanya enombanyapi, baame kyeto joo kalai pyoo, pii lao pingi. ");
INSERT INTO enq2_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Baame Israele dupa mokao nyetana lao naimame nee kaeyao malisoo kateama. Dopaka doko, prisa mupapi, isingi akalipi dupame baa pyao kumasina lao tenge setapala amii dupa maiyaminopa, baa pyao yukuiyami. Dupa pitaka piamino dokonya pituu, indupa yuu gii dakeme tepo pilyamo. ");
INSERT INTO enq2_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pii mende doko, naima-pipa petenge enda mendapuame naima dapa lao walu lasalamino: Yongama wamba enda dupa malu dokonya pupala, ");
INSERT INTO enq2_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jisasanya yonge doko kutao nakanjamano lamino. Enda dupa pilyetala, lee manemaneme enjele mendalapome Jisasa kalyamona lambinopa, dupame salamanona lamino. ");
INSERT INTO enq2_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dokopa naima-pipa katenge dupanya mendapu malu dokonya pupala, enda dupame lamili petae simupa kanjamino. Dopaka doko Jisasa nakanjaminona” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dokopa Jisasame akali dolapo lamaiyoo, “Nyakamba masepae napalenge! Propeta dupame pii leami dupa pitaka kiningina lao nyakambame yapa masala naelyambino. ");
INSERT INTO enq2_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kraisa doko kaeyala naeyao dopa pyoo tanda nyepala, baanya tii pipae dokonya kolandatana lao masala naelyambipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dopa latala, Mosesapi, propetapi dupame pii pepa piami dupanya tee pyao, Gotenya pii pepa pyapae singi dupa pitakanya baa lao pyapae singi dupa dii tambao dolapo lamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Akali dolapo paanya peambi yuu yakane dokonya tengesa pyakameaminopa, Jisasa kaita londati mendenya paanya pele lao pea. ");
INSERT INTO enq2_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dopa piamopa, akali dolapome kyeto joo baa lamaiyoo, “Yuu kuiyalanya niki landa pyatelyamona, emba nalimba-pipa palimana kae” leambi. Dopa leambinosa, baa akali dolapo-pipa palimana lao andaka kolandea. ");
INSERT INTO enq2_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kolandatala akali dolapo-pipa nee nalanya peteaminopa, baame breta mende nyepala, Gote yaka pilyino latala konjia. Konjepala dolapo maiya. ");
INSERT INTO enq2_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dokopa akali dolaponya lenge tii peteamopa, baa doko-lamo lao kandeambi. Dokopa dolapome baa nakandena lao baa pyoo alu pia. ");
INSERT INTO enq2_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Alu peteamopa nyakamba-lapo laloo pyoo, “Kaitinisa baame Gotenya pii pepa pyapae singi dupa dii tambao nalimba langimupa, nalimbanya mona tii pyoo etete auu pyaa naeyalape” leambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Gii dokopa dolapo sakatatala Jerusalema pilyiambi. Pilyetala 11 disaipolo dutupapi, endakali waka Jisasa watao paengemapi, dupa kambu pyatae peteamino kandeambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Dokopa dokaitame akali dolapo lamaiyoo, “Kiningi etete, Kamongo baa malunya sakatatala, baa Saimoneme kandena lao panasalame-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dokopa akali lapo dolapome kaitinisa pia dupapi, breta konjiamopa Jisasa-lamo lao kandeambi dokopi, dutupa pitaka dokaita lamaiyambi. ");
INSERT INTO enq2_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pia dupanya pii lao peteaminopa, Jisasa dokaitanya kainanya ipao kalyu petala dokaita lamaiyoo, “Nyakama mona yaepao pilyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dopa leamopa, baa timangopi mende kandelyamanona lao dokaitame masetala, walu lao paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dokopa baame dokaita lamaiyoo, “Nyakama aipuma walu latala, namba kiningi Jisasa-lamona lao masala naelyami? ");
INSERT INTO enq2_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nambanya kingipi, mokopi dupa kandatala, nambaka kalyenona lao masalapape. Yongepi, kulipi nambanya palimupa kandelyamino dopale dupa spirita mendenya napalengena, namba minao kanjepa” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dopa latala baanya kingi mokopi dupa kandena lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dokopa dokaitame eteke pyao, kiningi kandelyamape, sambo kandelyamape lao walu lao peteaminopa, baame dokaita lamaiyoo, “Nee napenge mende dakenya silyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dokopa dokaitame pisa yangapae mendepa, oni andandanya paleta mendepa baa maiyaminopa, ");
INSERT INTO enq2_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","baame nyepala dokaitanya enombanya nea. ");
INSERT INTO enq2_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Napala baame dokaita lamaiyoo, “Namba nyakama-pipa kateamano gii dokopa, pii nyakama langio dupa dapa lao leo: Mosesanya loo dupanyapi, Propeta dupanyapi, Wee Buku dokonyapi, dupanya pii namba lao pepa pyapae singi dupa pitaka angi jepenge jilyamona leona” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dopa latala, Gotenya pii pepa pyapae singi dupanya tenge dupa masoo nyina lao, baame dokaitanya masingi tii pisakamaiya. ");
INSERT INTO enq2_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Dopa petala baame dokaita lamaiyoo, “Dapa lao pepa pyapae silyamo: Kraisa doko kaitini dakenya tanda nao kumapala, yuu gii tepo dokonya malunya sakatatana lapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Baanya kenge dokonya koo dupa kunao nepena lao mona kapilyingi mana doko, Jerusalema katao tee pyao lamaitala, akali tata dupa pitaka lamaiyoo patana lao pepa pyapae silyamoaka. ");
INSERT INTO enq2_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pipumu datupa kandatala, nyakamame lao panapenge. ");
INSERT INTO enq2_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Salapape! Nambanya Takangeme nyakama mende ditona lea doko nambame nyakama-kisa epena lato. Dopana, nyakama Jerusalemaka katao, ketae kaitinya kyeto singi doko nyakama-kisa ipatamo gii dokonya tuu lapape” lea. ");
INSERT INTO enq2_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dopa latala, baanya disaipolo dupa laminao Betani pea. Betani katao baanya kingi dolapo minalyetala, baame disaipolo dupa auu pisia. ");
INSERT INTO enq2_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Baame dokaita auu pisoo kateamopa, baa lanyoo kaiti-kisa pea. Dopa piamopa baame dokaita yakinea. ");
INSERT INTO enq2_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yakinatala pateamopa, dokaitame baa mambo pyapala, eteke andake mende pyao Jerusalema pilyiami. ");
INSERT INTO enq2_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pilyetala lotuu anda nee nyetae kamapu dokonya koteaka lao Gote baa auu petaena lao mambo pyao kateami. Doko kiningi. ");
INSERT INTO enq2_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yuupa kaitipa dolapo nasiamopa, Pii doko wambao katea-pyaa. Pii doko Gotepa tole kateambi-pyaa. Pii doko baa Gote. ");
INSERT INTO enq2_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yuupa kaitipa dolapo nasiamopa, Pii doko Gotepa tole kateambi-pyaa. ");
INSERT INTO enq2_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pii dokonya-kaita Goteme dupa pitaka ipao sina lea-pyaa. Silyamo dupa pitakanya mendaipi mende kaitini waka mendenya-kaita ipao nasia-pyaa. ");
INSERT INTO enq2_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lete katenge doko Pii doko-kisa sia-pyaa. Lete katenge dokome endakali dupa pitaka tii pisia-pyaa. ");
INSERT INTO enq2_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tii pipae dokome iminjetae dokonya tii pisilyamopa, iminjetae dokome tii pipae doko ita naminingi. ");
INSERT INTO enq2_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Goteme akali mende epena leamopa ipao katea. Akali dokonya kenge doko Jone lenge. ");
INSERT INTO enq2_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tii pisingi akali doko endakali dupa pitakame tungi pina lao, Joneme tii pipae doko lao panalanya epea. ");
INSERT INTO enq2_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jone baa tii pipae doko daa. Baame tii pipae doko lao panalanya epea. ");
INSERT INTO enq2_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Endakali pitaka tii pisingi tii pipae angi doko isa yuu dakenya ipatea. ");
INSERT INTO enq2_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Goteme baa minatala yuu doko pyoo injia-pyaa. Dopaka doko, tii pipae doko isa yuu dakenya kateamopa, isa yuu dakenya endakali dupame baa doko-lamo lao nakandeami. ");
INSERT INTO enq2_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Baanya yuu dokonya baa epeamopa, baanya tata dupame baa lanyala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dopaka doko, baa lanyepala baanya kenge dokonya tungi piami endakali dupa Goteme baanya wane jina lao baame yakana lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gotenya wane jiami doko, endakalinya taeyokopi, yongenya pyoani kaengepi, akalinya auu kaengepi, dupanya mendeme daa, Gotenya auu kaenge dokome dupa wane jina lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pii doko endakali jetala, baa naimanya kainanya katea. Kateamopa naimame baanya tii pipae doko kandeama. Takange Gotenya Ikiningi mendai iki doko-kisa tii pipae doko singi. Kondo kaenge dokopa, kiningi pii dokopa, dolapo Takange Gotenya Ikiningi mendai iki doko-kisa tumbao epeamopa kandeama. ");
INSERT INTO enq2_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joneme wii lao, “ ‘Akali nambanya maitanya epelyamo doko namba ipa naeyopa baa ipatea. Namba namandengesa baa katea-pyaana’ lapu doko akali dake lao lapuna” lao, lao panea. ");
INSERT INTO enq2_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Baa kondo kaengeme tumbatae dokome naima pitaka kaitini longonya auu pisilyamo. ");
INSERT INTO enq2_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Loo dupa Goteme Mosesa-kisa maiya-pyaa. Dopaka doko, kondo kaenge dokopa, kiningi pii dokopa, dolapo Jisasa Kraisa-kisa epea. ");
INSERT INTO enq2_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yuu mendaipi mende endakali mendeme Gote nakandea. Gotenya Ikiningi mendai iki, baa Takangepa tole katenge dokome Gote baa dopalena lao, lao panea. ");
INSERT INTO enq2_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juu dupame Jerusalema katao prisapi, Lipaipi mendapuame Jone baa apipi lao tipa pyoo sala pena leaminopa, Joneme lao panao, ");
INSERT INTO enq2_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“Namba Kraisa doko daana” lao yapae napyoo panao lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dopa leamopa dokaitame baa tipa pyoo, “Emba Kraisa doko daa-tamo doko, emba Ilaijape?” leami. Dopa leaminopa baame lao pituu, “Namba doko daana” lea. Dokopa dokaitame lao pituu, “Emba propeta mende ipatana latae dokope?” leami. Dopa leaminopa baame yanu pyao, “Namba doko daakana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dopa leamopa dokaitame baa lamaiyoo, “Emba api? Naima tipa pyoo sala ipupa lamino dupa lamaimana, emba apina lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dokopa baame lao pituu, “ ‘Akali mende endakali napalenge yuu dokonya katapala wii lao, “Kamongonya kaitini doko tolasakamaiyepape” lao katatana’ lao, propeta Aisaiyame leana lapae singi doko nambana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","(Jone tipa piami akali dokaita Parasi dupame epena leaminopa epeami.) ");
INSERT INTO enq2_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Dokaitame baa tipa pyoo, “Emba Kraisapi, Ilaijapi, propeta mende ipatana latae dokopi, dutupanya mende daa-lumu doko, embame aipuma endakali dupa kaimbu pingipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dokopa Joneme dokaitanya pii yanu pyakamaiyoo, “Nambame endakali dupa endakimi kaimbu pilyo. Dopaka doko, akali mende nyakamanya kainanya kalyamo doko nyakamame nakandengema. ");
INSERT INTO enq2_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nambanya maitanya akali epelyamo lelyo doko namba namandengesa baa wamba-waka katea-pyaa. Baanya moko pee dolaponya nambame kende tata lakamaiyanya, namba epe daana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Endaki Jodane omotena Joneme kaimbu pyao kateamo, yuu Betani dokonya dupa pia. ");
INSERT INTO enq2_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yuu gii mende dokonya, Jisasa epeamo kandatala Joneme lao pituu, “Isa yuu dakenya endakali dupa pitakanya koo dupa nyoo nepenge, Gotenya Sipisipi Ŋaŋa doko epelyamona kanjepa. ");
INSERT INTO enq2_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Akali doko lao nambame lao pituu, ‘Akali mende nambanya maitanya epelyamo doko namba ipa naeyopa baa ipatea. Namba namandengesa baa katea-pyaana’ lapu doko, akali dake lao lapu. ");
INSERT INTO enq2_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nambame baa akali doko-lamo lao nakandeo. Israele dupame baa akali doko-lamo lao kandena lao nambame endakimi kaimbu pyala epeona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dopa latala Joneme panao lao pituu, “Spirita doko kaiti-kisa katao, yaka maiyolee joo lanao ipao akali doko-kisa peteamo kandeo. ");
INSERT INTO enq2_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nambame baa akali dokona lao kanja naeyo. Dopaka doko, endakimi kaimbu pyakamaiya puu lea Akali dokome namba langyoo, ‘Spirita doko lanao ipao akali mende-kisa pititamopa kandate akali dokome endakali dupa Oli Spiritame kaimbu pyakamaitana’ lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nambame baa kandatala, akali doko Gote Ikiningi dokona lao, lao panelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yuu gii mende dokonya Jone baanya disaipolo lapoma-pipa dee ipao kateami. ");
INSERT INTO enq2_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kateaminopa Jisasa ipao peamo kandatala Joneme lao pituu, “Akali doko baa Gotenya Sipisipi Ŋaŋa dokona kanjepa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Baame leamo doko sepala, disaipolo dolapome Jisasa watao peambi. ");
INSERT INTO enq2_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dokopa Jisasa kapilyetala, akali dolapome baa watao epeambino kandatala lamaiyoo, “Nyakamba aki kutao epelyambipi?” lea. Dopa leamopa dolapome baa lamaiyoo, “Rabae, emba anja palengepe?” leambi. (Rabae dokonya tenge doko, Mana lenge.) ");
INSERT INTO enq2_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Dopa leambinopa baame dolapo lamaiyoo, “Kanja ipupa” lea. Dopa leamopa dolapo pupala, baanya palenge anda doko kandatala, alemandi 4 kilokopi mende leamosa, yuu gii doko baa-pipa kateami. ");
INSERT INTO enq2_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Joneme leamo doko sepala Jisasa watao peambi akali dolaponya mende doko, Saimone Pita kaiminingi Andru. ");
INSERT INTO enq2_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andruame wambao baanya kaiminingi Saimone kutao kandatala baa lamaiyoo, “Nalimbame Mesaeya doko kandatalambanona” lea. (Mesaeya dokonya tenge doko, Kraisa.) ");
INSERT INTO enq2_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dopa latala baame Saimone laminao Jisasa katea dokonya pea. Dokopa Jisasame baa kandatala lao pituu, “Emba Saimone, Jona ikiningi. Emba kenge Sipasa latamina” lea. (Sipasa dokonya tenge doko, Pita.) ");
INSERT INTO enq2_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yuu gii mende dokonya Jisasa baa Galali yuu dokonya patoo lao pea. Pupala, Pilipa kandao nyepala baa lamaiyoo, “Emba namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Pilipa baa Betsaida tange. Andruapa, Pitapa dolapo siti dokonyaka tange.) ");
INSERT INTO enq2_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipame Nataniele kandao nyepala baa lamaiyoo, “Mosesanya loo bukupi, propeta dupame pepa piamipi, dupanya akali mende ipatana lao pepa pyapae singi akali doko naimame kanjemano. Akali doko baa Nasarete tange Josepe ikiningi Jisasa dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dopa leamopa Natanieleme baa lamaiyoo, “Dopale epe mende Nasarete dokonya kapa pao pyakalyetape?” lea. Dokopa Pilipame baa lamaiyoo, “Kanja ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dopa lateamopa, Jisasa katea dokonya Nataniele epeamo kandatala, Jisasame baa lao dapa lea: “Endakali minakasala naenge, kiningi Israele dake kanjepa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dokopa Natanieleme baa lamaiyoo, “Aipa petala embame namba kandengepe?” lea. Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Pilipame emba ipu laa naeyamupa, emba piki ita tenge mendenya katapino kanjona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dokopa Natanieleme baanya pii yanu pyakamaiyoo, “Mana Lenge, emba Gote Ikiningi, Israelemanya kiŋi dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dokopa Jisasame baa lamaiyoo, “Nambame emba piki ita tenge dokonya katapinopa kanjona lelyo dokonya, embame namba tungi pilyipi? Nambame emba kanjona lelyo doko ita minao kalai etete andake mendapu kanjapenona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dopa latala Jisasame lao pituu, “Nambame nyakama etete kiningi langilyo: Kaiti doko lumbapae setamopa, Akalinya Ikiningi doko-kisa Gotenya enjele dupa lalyoo lanao pyoo katataminopa nyakamame kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pilipapa Natanielepa wii lao nyia dokonya pituu yuu gii lapo pateamopa tepo dokonya, yuu Galali taono Kena dokonya enda watapae piami mendenya Jisasa endangi doko petea. ");
INSERT INTO enq2_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisasapi, baanya disaipolopi, dupa apata enda watapae piami dokonya epena leaminopa pupala kateamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dokopa waene sia dupa nao etapeaminopa, Jisasanya endangi dokome Jisasa lamaiyoo, “Waene etalame-lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dopa leamopa Jisasame baa lamaiyoo, “Enda, nambanya gii doko ene epelyamona, doko nalimbanya kalai mendepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dokopa baanya endangi dokome kalai akali dupa lamaiyoo, “Nyakamame mende pyepa laapomona, baame latali pyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Endaki penge kaname wasepae tokange dosa sia. Penge dutupanya mendai-mendai lao endaki 100 litapi mende petenge. Penge dopale dupanya Juu dupame endaki kamuu pisetala, nyakamanya mana singili pyoo kaimala pyoo wasoo nepengema. ");
INSERT INTO enq2_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisasame kalai akali dokaita lamaiyoo, “Nyakamame penge datupanya endaki kamuu tumbasalapa” lea. Dokopa dokaitame endaki kamuu tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dopa peteaminopa baame dokaita lamaiyoo, “Indupa dokonya mendatupa kamuu nyepala nee isilyamo akali doko maiya pupa” lea. Dopa leamopa dokaitame maiya peami. ");
INSERT INTO enq2_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Maitiaminopa, nee isia akali dokome endaki doko nao siamopa waene jiamosa, baame anja-tae nyalamipi lao masala naeya. Dopaka doko, kalai akali endaki kamuu nyiami dupame masiami. Nee isia akali dokome enda watapae pia akali doko epena latala ");
INSERT INTO enq2_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lamaiyoo, “Endakali pitakame waene epe dupa wambao mokosoo maingima. Waene epe dupa longo lao napelyaminopa, maitakao koo dupa mokosoo maingima. Dopa pingimana, embame waene epe dake sina kaeyapala, epapu nyoo epelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yuu Galali taono Kena dokonya, Jisasame mirakolo pia dupa pitakanya mirakolo dake wambao pia. Dopa pia dokome, baanya tii pipae doko paneamosa, baanya disaipolo dupame baa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dokopa Jisasa baanya endangipi, kaiminingipi, disaipolopi, dupa-pipa lanao Kapename pupala, yuu gii kuki mendatupa dokonya kateami. ");
INSERT INTO enq2_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juumanya Pasopa nee nenge gii doko ipanya piamopa, Jisasa lalyoo Jerusalema pea. ");
INSERT INTO enq2_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pupala kandeamopa, lotuu anda nee nyetae kamapu dokonya kaowapi, sipisipipi, yaka maiyoleepi dupa maketa setao kateaminopa, muni aloo pingima dupame muni aloo pyoo nyakamanya toko dupanya peteami. ");
INSERT INTO enq2_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dopa piaminosa, Jisasame kende mendapu nyoo kambu pyatala, kende konja mende wasia. Wasepala kende konja dokome sipisipipi, kaowapi dupa pitaka konja palyoo nepatala, lotuu anda nee nyetae dokonya kamaka pena lao watao pia. Dopa petala, muni aloo pingima dupanya muni konde dupa kai lao nepatala, toko dupa nyoo kapilyia. ");
INSERT INTO enq2_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dopa petala yaka maiyolee salimi leami dupa lamaiyoo, “Nyakamame nambanya Takangenya anda dake maketa anda jala naenya, dokaita nyoo pupa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dokopa, pii pepa pyapae singi dokonya, “Gote, embanya anda doko nee kaenge dokome namba lyaa minatana” lapae singina lao baanya disaipolo dupame masiami. ");
INSERT INTO enq2_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisasame dopa pia dokonya Juu dupame baa lamaiyoo, “Embame pilyino datupa pipenge kyeto doko emba-kisa silyamona lao panasoo, mirakolo aipale mende naimame kanjepale lao pitipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Anda nee nyetae dake nyakamame kalunya nepataminopa, yuu gii tepomanya nambame dee katasotona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dopa leamopa Juu dupame lao pituu, “Anda nee nyetae dake pyoaka kateaminopa ee kana 46 peana, embame yuu gii tepo dutupanya iki katasetepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisasame anda nee nyetae lea doko, baanya yonge doko lao lea. ");
INSERT INTO enq2_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jisasa malunya sakatateamopa, baame pii lea dutupa baanya disaipolo dupame masiami. Gotenya pii pepa pyapae singipi, Jisasanya pii lea dutupapi, dupa kiningi-lamo lao masiamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pasopa nee nenge gii dokonya Jerusalema katao Jisasame mirakolo pia dupa endakali longome kandatala baanya kenge dokonya tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dopaka doko, Jisasame endakali dupa pitakanya masiami dupa kandatala, baame dupa tungi pyala naeya. ");
INSERT INTO enq2_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jisasame endakali pitaka kandao tii tenge dokonyana, endakali dupa dopalena lao endakali mendeme Jisasa lamaiya naeyapenge. ");
INSERT INTO enq2_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Akali Nikodimasa lenge, Parasi mende katea. Baa Juumanya isingi akali dupanya mende. ");
INSERT INTO enq2_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Akali doko kuka gii mendenya Jisasa petea dokonya ipupala baa lamaiyoo, “Mana Lenge, Gote doko endakali mende-pipa nakalyamopa, endakali dokome embame mirakolo pilyino dopale mende napingi. Tenge dokonya, embame naima mana langyale lao Goteme puu leana lao masilyamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Nambame emba etete kiningi langilyo: Endakali mende dee ŋaŋa joo manja naeyatamo doko, Gotenya kingdom doko baame kapa pao nakandatana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dokopa Nikodimasame baa lamaiyoo, “Endakali angi jepae mende aipa petala ŋaŋa joo mandita? Endakali angi jepae mende aipa petala endanginya inginya pilyetamopa, baa dee ŋaŋa joo endangimi manditape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dopa leamopa Jisasame yanu pyao, “Nambame emba etete kiningi langilyo: Endakipa Spiritapa dolapome endakali mende ŋaŋa joo manja naeyatamo doko, Gotenya Kingdom dokonya kapa pao kolandala naeyata. ");
INSERT INTO enq2_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Endakalimi mandenge doko endakaliaka mandenge. Spiritame mandenge doko spiritaka mandenge. ");
INSERT INTO enq2_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nyakama dee ŋaŋa joo mandipengena langilyo doko embame sepala walu nalape. ");
INSERT INTO enq2_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poo dokome poo lao patoo lao masilyali pyoo lao pelyamopa embame singi. Singiaka doko, anja pituu lelyape, anja lao pelyape lao nakandenge. Dopaleaka joo, Spirita dokome endakali mandyoo nyilyamo dupa aipa petala nyilyape lao embame nakandengena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dopa leamopa Nikodimasame yanu pyao, “Embame lelyeno dupa aipa petala dopa pitape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Dokopa Jisasame lao pituu, “Emba Israele dupanya mana lenge dokome pii dutupanya tenge dupa soo nanyilyipi? ");
INSERT INTO enq2_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nambame emba etete kiningi langilyo: Naimame masingipi, kandengepi dupa lao panamanopa, naimanya pii dupa nyakamame soo nanyilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nambame yuunya singi dupanya nyakama langipupa kiningina lao masala naelyamino doko, kaiti-kisa singi dupanya langitopa aipa petala kiningina lao masetami? ");
INSERT INTO enq2_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Endakali mende kaiti-kisa napea. Akalinya Ikiningi, kaiti-kisa katenge doko isa epeamo doko iki kaiti-kisa pea. ");
INSERT INTO enq2_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Endakali napalenge yuu dokonya kanopato aeneme wasepae doko Mosesame minalyiali pyoo, Akalinya Ikiningi doko kaeyala naeyao minalyetami. ");
INSERT INTO enq2_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Dopa pitaminopa, Akalinya Ikiningi doko tungi pyatami endakali dupa pitaka kumao alu napinya, lete etete katenge doko nyetami. ");
INSERT INTO enq2_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Goteme isa yuu dakenya endakali dupa pitaka auu kaeyamo dokome, baanya Ikiningi mendai iki doko maiya. Endakali mendeme Gotenya Ikiningi doko tungi pyatamo doko, baa kumao alu napinya, lete etete katenge doko nyetamopa lao maiya. ");
INSERT INTO enq2_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Isa yuu dakenya endakali dupa-kisa tenge setapala tanda maitamopa lao, Goteme baanya Ikiningi doko isa yuu dakenya epena laa naeya. Baanya Ikiningi dokome isa yuu dakenya endakali dupa pyoo nyina lao epena lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gote Ikiningi doko tungi pilya endakali doko-kisa tenge setapala baa yapala naenge. Baa tungi napilya endakali doko-kisa tenge setapala baa yapatae. Endakali dokome Gote Ikiningi mendai iki dokonya kenge doko tungi napingi dokonya, baa-kisa tenge setapala baa yapatae. ");
INSERT INTO enq2_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Goteme endakali dupa-kisa tenge setelyamo doko dake: Tii pipae doko isa yuu dakenya ipao kateamopa, endakali dupanya mana miniami dupa koo dokonyana, iminjetae doko auu kaeyapala tii pipae doko yakineami. ");
INSERT INTO enq2_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Endakali koo pingi dupa pitakame nyakamanya koo kalai dupa panakatame-latala, tii pipae doko maka kaeyapala lee pingima. ");
INSERT INTO enq2_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dopaka doko, kiningi pii dokome lelyali pingi endakali dupa Goteme nisimupa mana minilyaminona lao endakali dupame kandena lao, tii pipae dokonya panao epengemana” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Maitakao Jisasa baanya disaipolo dupa-pipa Judia yuu dokonya peami. Pupala yuu dokonya gii mendatupa katapala, baame endakali dupa kaimbu pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuu Salima makisa, yuu Aenone dokonya endaki longo epenge dokonyana, Joneme yuu dokonya kaimbu pyao kateamopa, endakali dupa ipao kaimbu nyepa piami. ");
INSERT INTO enq2_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jone anjala naeyaminopa kaimbu doko nyepa piami.) ");
INSERT INTO enq2_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kuni nasina lao pyoo wasoo nepenge mana dokonya Jonenya disaipolo dupa-pipa Juu mende-pipa pii yanda piami. ");
INSERT INTO enq2_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dokopa Jonenya disaipolo dupa Jone katea dokonya pupala baa lamaiyoo, “Mana Lenge, emba Jodane omotena katao, akali mendenya lao pii lao paneeno akali dokome kaimbu pyamupa, endakali dupa pitaka baa katapya dokonya pelyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dokopa Joneme pii yanu pyao, “Goteme kaiti-kisa katao dopale mende maiya naeyatamo doko, endakalimi nyala naeyatami. ");
INSERT INTO enq2_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Namba Kraisa doko daa. Kraisa doko ene epena laanya, Goteme namba wambao puu leana lao langio doko nyakamame lao panengema. ");
INSERT INTO enq2_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Akali enda kelyenge doko baanya enda kelyapae dokopa tole petengemba. Akali dokonya wane mona setenge dokome enda ene kelyapenge akali dokonya pii lelya doko sepala, baa eteke pingi. Dopaka pyoo namba indupa eteke andake pilyo. ");
INSERT INTO enq2_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Baa alyasale katatamopa, namba anasale katapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Akali kaiti-kisa katao epeamo dokome endakali dupa pitaka ita minao, baa ketae ulusa-waka. Yuu dakenya-tae endakali dupa yuunya endakali dokonyana, dupame yuunya pii dupaka lengema. Dopaka doko, akali kaiti ulunya katao epeamo dokome endakali dupa pitaka ita minao, baa ketae ulusa-waka. ");
INSERT INTO enq2_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Baame siapi, kandeapi dupa lao panelyamopa, endakali dupame soo nanyingima. ");
INSERT INTO enq2_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dopaka doko, akali dokonya pii doko soo nyilya endakali dokome, Goteme kiningi pii lengena lao kyeto joo masingi. ");
INSERT INTO enq2_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Goteme Spirita doko longo lao maingi. Dopa pingi dokonya, Goteme epena lea akali dokome Gotenya pii dupa endakali dupa lamaingi. ");
INSERT INTO enq2_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Takange Goteme baanya Ikiningi doko auu kaenge dokonya, dupa pitaka isina lao baanya Ikiningi dokonya kinginya setea. ");
INSERT INTO enq2_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gote Ikiningi mendai iki doko tungi pilya endakali dokome lete etete katenge doko nyingi. Dopaka doko, Gote Ikiningi dokonya pii doko nepata endakali dokome lete katenge doko nakandata. Gotenya imbu kaenge doko endakali doko-kisa dopa petae singi. ");
INSERT INTO enq2_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jisasame Jone ita minao endakali longo disaipolo nyepala, kaimbu pyakamailyamo lapae doko Parasi dupame silyaminona lao Jisasame masia. ");
INSERT INTO enq2_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jisasanya disaipolo dupame kaimbu pyakamaiyaminopa, angi Jisasame kaimbu mende pyakamaiya naeya.) ");
INSERT INTO enq2_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dopa lao masetala, baa Judia yakinatala Galali pea. ");
INSERT INTO enq2_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Baa Samaria-kaita pupenge jiamosa dokonya-kaita pea. ");
INSERT INTO enq2_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pupala yuu Samaria dokonya, taono Saikaa pao pyakamea. Taono Saikaa doko, Jekopeme baanya ikiningi Josepe yuu maiya dosa tengesa singi. ");
INSERT INTO enq2_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yuu dokonya Jekopenya endaki pete tombapae doko singi. Jisasa baa kaitini pao maka kaeyapala, kotaka etete dokonya endaki pete tombapae singi dosa petea. ");
INSERT INTO enq2_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Peteamopa Jisasanya disaipolo dupa nee sambala taononya peami. Pateaminopa Samaria tange enda mende endaki pete tombapae dokonya endaki kamuala epea. Epeamopa Jisasame enda doko lamaiyoo, “Endaki mendatupa natoo kamuu dii” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Juu dupame Samaria tange dupanya penge dupa wandingima. Tenge dokonya, Jisasame dopa leamopa Samaria enda dokome yanu pyao, “Emba Juu dokome aipuma namba Samaria enda dakeme endaki natoo kamuu dii lelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Goteme dopale mende emba mee ditoo lao masilyamo doko embame masala naelyeno. Akali endaki kamuu dii lelyamo doko apimi lelyape lao masala naelyenoaka. Masipili doko, akali dokome endaki lete katenge doko dina lao tee lapinopa dipyalina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dopa leamopa enda dokome baa lamaiyoo, “Akali Andake, endaki kamualanya embanya penge mende naminalene-lamo. Endaki pete tombapae dake koko-wakana, embame endaki lete katenge doko anja-tae nyete? ");
INSERT INTO enq2_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naimanya yumbange Jekopeme endaki pete tombapae dake naima dia-pyaa. Baapi, baanya wanepi, sipisipipi, kaowapi dupa endaki dakenyaka neami-pyaana, embame baa ita minao kalyona lelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Endaki pete tombapae dakenya natami endakali dupa pitaka dee endaki nanu kaeyatami. ");
INSERT INTO enq2_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dopaka doko, nambame endaki maitopa natami endakali dupa tanga-tangapi dee endaki nanu nakaeyatami. Endaki nambame maitopa natami endakali dupa-kisa endaki doko pituu tumbatala lyoo ipao, endakali dupa lete etete katenge doko maitana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dopa leamopa enda dokome baa lamaiyoo, “Akali Andake, namba endaki nanu nakaeyao, dakenya kamuala naipaowaka pitopana, embame endaki doko namba kamuu dii” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dokopa Jisasame enda doko lamaiyoo, “Embanya akalingi doko epena lanyala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dopa leamopa enda dokome yanu pyao, “Nambanya akalingi mende nakatengena” lea. Dokopa Jisasame baa lamaiyoo, “Embanya akalingi mende nakatengena lelyeno doko kiningi lelyeno. ");
INSERT INTO enq2_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wamba embame akali yungi nyii. Indupa akali pilyambino doko embanya akalingi daana, embame lelyeno doko kiningi lelyenona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dokopa enda dokome baa lamaiyoo, “Akali Andake, emba propeta mende-lamo lao nambame kandelyo. ");
INSERT INTO enq2_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naimanya yumbange dupame yuu manda dakenya katao Gote mambo piami-pyaa. Dopaka doko, endakali dupame Jerusalema katao mambo pyapengena lao nyakama Juu dupame lengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dopa leamopa Jisasame baa lamaiyoo, “Enda, nambanya pii lelyo dake kiningina lao embame masepe: Gii doko ipatamopa, manda dakenyapi, Jerusalemapi katao Takange doko mambo pyala naeyatami. ");
INSERT INTO enq2_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyakama Samaria dupame angi doko nakandao mambo pingima. Dopaka doko, endakali pyoo nyingi doko Juu dupa-kisa epelyamo dokonyana, naima Juu dupame angi doko kandao mambo pingi. ");
INSERT INTO enq2_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Takange doko angi mambo pingi endakali dupame Spirita dokopa, kiningi pii dokopa, dolapome Takange doko mambo pyapenge gii ipupenge doko indupa ipatelyamo. Endakali dopale dupame baa mambo pina lao Takange dokome kutao kalyamo. ");
INSERT INTO enq2_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gote baa spirita. Baa mambo pyatami dupame Spirita dokopa, kiningi pii dokopa, dolapome laminatambinopa mambo pyapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dokopa enda dokome Jisasa lamaiyoo, “Mesaeya doko ipatana lao nambame masilyo. Ipata gii dokopa, baame dupa pitaka naima panao langitana” lea. (Mesaeya doko Kraisa lengema.) ");
INSERT INTO enq2_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dokopa Jisasame enda doko lamaiyoo, “Embame Mesaeya lelyeno doko, emba-pipa pii lao pilyambino dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dopa lao peteambinopa, Jisasanya disaipolo dupa epeami. Ipupala, Jisasa enda dokopa pii lao pitalambini-lamo lao kandatala walu leami. Dopa petala dupanya mendaipi mendeme baa lamaiyoo, “Emba aki setao pitale? Aipuma enda dokopa pii lao pitalambipi?” lao tipa napiami. ");
INSERT INTO enq2_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dokopa enda dokome baanya endaki penge doko dosa setapala taononya pea. Pupala endakali dupa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nambame pyoo petenge dupa pitaka akali mendeme langyomona, baa Kraisa dokope lao kanja ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dopa leamopa endakali dupa taono doko yakinatala, Jisasa katea dokonya kanja peami. ");
INSERT INTO enq2_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Endakali dokaita ipa naeyaminopa, disaipolo dupame Jisasa lamaiyoo, “Mana Lenge, nee napoko” leami. ");
INSERT INTO enq2_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dopa leaminopa Jisasame dokaita lamaiyoo, “Nambanya nee napenge silyamo dupa nyakamame masala naelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dopa leamopa disaipolo dupame nyakama-lapo laloo pyoo, “Endakali mendeme baa nee nena lao maiya ipata aipape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dokopa Jisasame dokaita lamaiyoo, “Namba puu lea Akali dokonya masingili pyoo, kalai pyoo etasakamaipenge doko nambanya nee doko. ");
INSERT INTO enq2_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‘Kana kitomende patatamopa, nee dupa wambu pitamopa manditamana’ lao nyakamame lengema. Salapape! Nambame nyakama dapa langilyo: Indupa nee wambu pimupa mandipenge jilyamona, nyakama lenge tapala kanjepa. ");
INSERT INTO enq2_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Eenya nee wambu petae dupa mandyoo mau pingi doko baa yole nyoo, lete etete katenge dokonya dii dupa mandyoo mau pingi. Dopa pingi dokonya, ee pokenge dokopa, nee mandyoo mau pingi dokopa, dolapo lapota eteke pyapenge. ");
INSERT INTO enq2_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tenge dokonya, akali mendeme ee wai pokatelyamopa, akali waka mendeme mandyoo mau pingina lapae singi pii doko kiningi. ");
INSERT INTO enq2_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Akali waka mendapuame lekeleke tao ee pokeami dupanya dii dupa nyakamame mandyoo mau pyala pupa leo. Wakamanya kalai petae dupanya nyakamame dii dupa mandyoo mau piamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Enda doko taono dokonya pupala endakali dupa lamaiyoo, “Nambame pyoo petenge dupa pitaka akali mendeme langyomona” lao, lao paneamopa, endakali Samaria tange longome enda dokonya pii doko sepala, Jisasa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Dopa petala, Samaria tange dupa Jisasa katea dokonya pupala, baa nyakama-pipa katamana kaena lao kongo leaminosa, yuu gii lapoma baa dupa-pipa yuu dokonya kateami. ");
INSERT INTO enq2_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Dokopa endakali longome apata baanya pii doko sepala, baa tungi piamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Dopa petala endakali dupame enda doko lamaiyoo, “Embanya pii lapino doko iki naimame sepala baa tungi napilyamano. Indupa naimame baanya pii lapumu doko sepala, baa kiningi isa yuu dakenya endakali dupa pitaka Pyoo Nyepenge Kraisa doko-lamo lao masetala, baa tungi pilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisasa baa yuu gii lapoma Samaria katapala Galali pea. ");
INSERT INTO enq2_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Wamba Jisasame lao pituu, “Propeta mende baanya yuu dokonya kalyamopa, baa tata dupame baa anda-anda semaiya naengemana” lao, lao panea.) ");
INSERT INTO enq2_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nee andake nenge gii dokonya Galali tange dupa Jerusalema peaminopa, Jisasame kalai pia dupa pitaka kandeami dokonyana, baa pao Galali pyakameamopa, endakali dupame auu kaeyao lanyiami. ");
INSERT INTO enq2_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dokopa endaki waene jina lea yuu Galali, taono Kena dokonya Jisasa dee epea. Epeamopa kiŋi dokonya kalai akali mendenya ikiningi doko Kapename dokonya yaina sia. ");
INSERT INTO enq2_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wane doko kumapenge joo siamopa, Jisasa baa Judia katao Galali ipamo lapae doko gapomanenya kalai akali dokome sia. Sepala baa Jisasa katea dokonya pupala, wane dokonya yaina doko mee jakamaiya lanao epena lao tee lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dopa leamopa Jisasame baa lamaiyoo, “Nyakamame mirakolopi, kalai paka pipaepi, dupa kanja naeyatamino doko, namba tungi napyatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dopa leamopa, kiŋi dokonya kalai akali dokome Jisasa lamaiyoo, “Akali Andake, nambanya wane doko kumala naelyamo dokopa, nisakatale yapa lanao ipupoko” lea. ");
INSERT INTO enq2_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dokopa Jisasame baa lamaiyoo, “Embanya wane doko saka paapomona puu” lea. Dopa leamopa, akali dokome pii doko kiningina lao masetala baa andaka pea. ");
INSERT INTO enq2_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lanao peamopa, kaitinisa baanya kalai akali mendapuame kandanyetala baa lamaiyoo, “Embanya wane doko saka pupyana” leami. ");
INSERT INTO enq2_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dopa leaminopa baame dokaita tipa pyoo, “Kiloko andukunya saka pupyape?” lea. Dopa leamopa dokaitame baa lamaiyoo, “Kuaka kotaka, 1 kiloko dokonya yonge itaita pipumu dokome baa yakinapyana” leami. ");
INSERT INTO enq2_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“Embanya wane doko saka paapomona” lao Jisasame lamaiya gii etete dokonyaka baanya wane doko saka pupya-lumu lao takange dokome masia. Masetala baapi, baanya palupi, dupa pitakame Jisasa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisasa baa Judia katao Galali ipupala, mirakolo dakeme lapo pyoo pia. ");
INSERT INTO enq2_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gii mendatupa pateamopa, Juumanya nee andake nenge gii doko epeamopa, Jisasa lalyoo Jerusalema pea. ");
INSERT INTO enq2_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lome kambu Sipisipi lenge mende Jerusalema singi dokonya tengesa dosa, veranda yungi singi dutupanya kainanya endaki pete tombapae, Ibru pii lao Betesada lenge mende singi. ");
INSERT INTO enq2_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Endaki pete tombapae dokonya lembanya endakali lenge mondapi, moko takyepaepi, kingi talyangapi, dopale etete longo mendapu pituu, endaki doko buli pilyape lao kandatae petengema. ");
INSERT INTO enq2_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Gotenya enjele mende ipupala endaki doko minako pilyamopa, buli pilyali pyoo, yaina pyapae dupanya mende, wambao endaki pete dokonya pyakanelya dokonya yaina doko mee jakamaingi. ");
INSERT INTO enq2_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Akali mende ee kana 38 pitaka takyepae singi doko endaki pete lemba dokonya paliu sia. ");
INSERT INTO enq2_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Paliu siamopa Jisasame kandatala, akali doko wamba-waka yaina siana lao masia. Dopa lao masetala baa lamaiyoo, “Embanya yaina doko mee jipya laka lao masilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dopa leamopa akali yaina pyapae dokome baanya pii yanu pyakamaiyoo, “Akali Andake, endaki doko buli pilyamopa, endaki pete tombapae dokonya namba nyoo pyandapenge endakali mende nakatenge. Namba tangeme paanya pilyopa, waka mendeme namba nyoo maita pyatala wambao pyakanata pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dokopa Jisasame baa lamaiyoo, “Emba sakatatala, embanya lapa toko doko nyoo soo kaita pae” lea. ");
INSERT INTO enq2_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dopa lalu piamopa, akali dokonya yaina doko mee julu pia. Dopa peteamopa, baanya lapa toko doko nyoo soo kaita paeya. Yaina doko Sambata gii mendenya mee jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tenge dokonya, Juu dupame akali yaina pyapae mee jia doko lamaiyoo, “Indupa Sambata dakenya embanya lapa toko doko nyoo soo paelyeno doko, loome daa latae singi doko yalelyenona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Nambanya yaina mee jakalamo akali dokome namba langyoo, ‘Embanya lapa toko doko nyoo soo kaita pae’ lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dopa leamopa dokaitame baa tipa pyoo, “Embanya lapa toko doko nyoo soo kaita pae lame-lumu akali doko apipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Panda dokonya endakali longo kambu pyao kateami dupanya-kaita Jisasa baa elyakalao kolala pateamopa, akali yaina pyapae dokome baanya yaina doko akali apimi mee jakalape lao masala naeya. ");
INSERT INTO enq2_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Maitakao Jisasame lotuu anda nee nyetae kamapu dokonya akali doko kandao nyepala baa lamaiyoo, “Indupa embanya yaina doko mee jakalamona, kenda andakele mendeme emba koeyasetana, dee koo mende napipi” lea. ");
INSERT INTO enq2_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dokopa akali doko pupala, baanya yaina mee jakamaiya akali doko Jisasana lao Juu dupa lamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisasame Sambata dupanya kalai dopale dupa piamosa, Juu dupame tee pyao Jisasa tanda maiyoo koeyasetala, baa pyao kumasemana lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dopa piaminopa Jisasame dupa lamaiyoo, “Nambanya Takange dokome indupapi kalai pyoaka kalyamo dokonya, nambame apata kalai pyoaka kalyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dopa leamosa, Juu dupame baa pyao kumasemana lao kyeto joo kaitini kutiami. Baame Sambatanya loo doko yalea dokonya iki daa, Gote baanya Takangena lea dokome baa Gotepa mendai dopalena leamosa, baa pyao kumasemana lao kyeto joo kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dokopa Jisasame dokaita lamaiyoo, “Nambame nyakama etete kiningi langilyo: Takange dokome kalai mende pilyamopa, Ikiningi dokome kandenge dokoaka Ikiningi dokome pingi. Ikiningi dokome iki masoo kalai mende napingi. Tenge dokonya, Takange dokome kalai pingili pyoaka Ikiningi dokome pingi. ");
INSERT INTO enq2_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Takange dokome Ikiningi doko mona setenge dokonyana, baame kalai pingi dupa pitaka Ikiningi dokome kandena lao panasingi. Nyakamame walu lao kandataminopa lao, kalai etete andake mendapu Takange dokome Ikiningi doko-kisa panaseta. ");
INSERT INTO enq2_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Takange dokome endakali kumapae dupa sakatasetala lete katenge doko maingi. Dopaka pyoo, Ikiningi dokome endakali mende lete katenge doko maitoo lao masilyamo doko maingi. ");
INSERT INTO enq2_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Takange dokome endakali mende yapala naenge. Takange doko anda-anda semaingimali pyoo endakali dupa pitakame Ikiningi doko anda-anda semaina lao endakali dupa pitaka yapenge kalai doko Ikiningi doko maiya. Ikiningi doko anda-anda semaiya naengema endakali dupame baa epena lea Takange doko anda-anda semaiya naengemaka. ");
INSERT INTO enq2_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nambame nyakama etete kiningi langilyo: Nambanya pii doko sepala, namba puu lea Akali doko tungi pilya endakali dokome, kumingi doko yakinatala, lete etete katenge doko nyingi. Dopa pilya dokome, Goteme tenge setapala tanda maingi doko endakali dokome wandingi. ");
INSERT INTO enq2_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Nambame nyakama etete kiningi langilyo: Endakali kumapae dupame Gote Ikiningi dokonya pii dupa setamina latae gii doko indupa ipatelyamo. Baanya pii doko setami endakali dupa lete katatami. ");
INSERT INTO enq2_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Lete katenge Takange-kisa singi doko Ikiningi doko-kisa sina lao maiya. ");
INSERT INTO enq2_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Baa Akalinya Ikiningi dokonyana, endakali dupa pitaka yapena lao kyeto doko Ikiningi doko maiyaka. ");
INSERT INTO enq2_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nambame pii lelyo datupa sepala nyakama walu laa naeyalapape. Gii doko ipatamopa, endakali malu petae dupa pitakame Akalinya Ikiningi dokonya pii doko sepala, ");
INSERT INTO enq2_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","malu dupa yakinatala sakatao ipatami. Mana epe minao kateami endakali dupa lete katatami. Mana koo minao kateami endakali dupa-kisa tenge setapala tanda maita. ");
INSERT INTO enq2_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nambanya auu kaengeme kalai mende napingi. Nambanya auu kaengeme kalai mende pitoo latala nambame kaitini kutala naenge. Namba puu lea Takange dokome kalai pii lelyali pyoo, nambame pingi. Takangeme pii dupa namba langilyamopa, baanya pii dupa nambame sepala endakali dupa yapenge. Dopa pilyo dokome, nambame endakali dupa tolao yapenge. ");
INSERT INTO enq2_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Namba akali dokona lao namba tange iki lato doko, nambanya pii doko sambo jipyali. ");
INSERT INTO enq2_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dopaka doko, nambanya Takange dokome nambanya lao pii mende lelyamo doko, baame kiningi lelyamona lao nambame masingi. ");
INSERT INTO enq2_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyakamame endakali mendapu Jone kateamo dokonya pena leaminopa, baame kiningi pii doko lao panea. ");
INSERT INTO enq2_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Namba akali dokona lao endakalimi pii lao panelyami dupanya namba kyeto nyala naenge. Dopaka doko, nyakama pyoo nyetamopa lao nambame pii dutupa langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jone baa lama joo tao kateamopa, nyakama eteke pyao katamana lao masetala, gii kuki baanya tii pipae dokonya kateami. ");
INSERT INTO enq2_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dopaka doko, Joneme namba akali dokona lao pii leamo dupa nambame kalai pilyo dupame ita minilyamo. Nambanya Takange dokome kalai mendapu pyoo etatale lao namba dia dupa nambame pyoo kalyo. Dopa pyoo kalyo dokome, nambanya Takange dokome namba puu leana lao panelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yuu mendaipi mende Takange doko dopale-lamo lao nyakamame nakandeami. Baame pii leamopa nyakamame nasiamiaka. Dopaka doko, nambanya Takange, namba puu lea dokome namba akali dokona lao, lao panenge. ");
INSERT INTO enq2_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Baame isa yuu dakenya epena lea akali dokonya pii doko kiningina lao nyakamame masala naelyamino dokonya, baanya pii doko nyakama-kisa nasilyamo. ");
INSERT INTO enq2_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gotenya pii pepa pyapae singi dupanya-kaita nyakamame lete etete katenge doko nyetamape lao masetala, pii dutupaka aipa lao pepa pyapae silyape lao yapao katengema. Gotenya pii pepa pyapae silyamo dupame namba lao pepa pyapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Dopaka doko, nyakamame namba-kisa lete katenge doko nyala naepenya tuu pilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Namba endakalimi lalyina lao nakalyo. ");
INSERT INTO enq2_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gote auu kaenge doko nyakama-kisa nasilyamona lao nambame kandenge. ");
INSERT INTO enq2_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nambanya Takangenya kenge dokonya namba ipupupa, nyakamame namba maita dilyamino. Dopaka doko, endakali mende baa tangenya kenge dokonya ipatamopa, nyakamame baa lanyetami. ");
INSERT INTO enq2_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gote mendai iki dokome nyakama kenge andake dina lao kaitini kutala naenya, nyakama-lapo kenge andake mai-mai pyoo katengema dokome, aipa petala nyakamame namba tungi pyatami? ");
INSERT INTO enq2_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nambanya Takangenya enombanya nambame nyakama-kisa tenge setatena lao masala naeyalapape. Mosesame nyakama nisetana lao nee kaeyao malisoo kalyamino dokomeaka nyakama-kisa tenge setata. ");
INSERT INTO enq2_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesanya pepa pyapae silyamo dupame namba lao pepa pyapae silyamo. Pepa pyapae dupa kiningina lao nyakamame masimili doko, nambanya pii lelyo dupa kiningina lao masimiliaka. ");
INSERT INTO enq2_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dopaka doko, Mosesanya pepa pyapae silyamo dupa nyakamame kiningina lao masala naelyamino dokome, aipa petala nambanya pii dupa kiningina lao masetamipi?” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gii mendatupa pateamopa, Jisasa baa Galali pete, kenge mende Taibiriasa lenge dokonya omotena pea. ");
INSERT INTO enq2_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wamba Jisasame mirakolo dupa pyoo yaina pyapae dupa mee jakamaiyamopa, endakali kambu andake dokome kandeami dokonya, dupame baa watao peami. ");
INSERT INTO enq2_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dokopa Jisasa baa yuu manda mendenya lalyoo pupala, baanya disaipolo dupa-pipa dokonya petea. ");
INSERT INTO enq2_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Juumanya Pasopa nee andake napenge gii doko, dokopa tengesa pia.) ");
INSERT INTO enq2_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Baa petea dokonya endakali kambu andake mende epeamino kandatala, Jisasame Pilipa lamaiyoo, “Endakali dakaita breta nena anja-tae sambakamaimape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Baame dopa pitoana lao masetala, Pilipa makande pyoo pii dutupa lea.) ");
INSERT INTO enq2_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Dokopa Pilipame baanya pii yanu pyakamaiyoo, “Naimame silipa muni 200-tame breta sambapala endakali dakaita pitaka kuki lao nena maitamanopapi kapa napapome-lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jisasanya disaipolo dupanya mende, Andru lenge, Saimone Pita kaiminingi dokome Jisasa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wane mende pilyamo dakenya breta bali diimi wasepae yungi-pipa, pisa lapo-pipa silyamo. Dopaka doko, dutupame endakali longo dakaita aipa petala kapa patape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dokopa akali tausene yungipi mende kateami. Kateami panda dosa tanu longo kateamopa, Jisasame baanya disaipolo dupa lamaiyoo, “Endakali dupa isa petena lapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dopa latala Jisasame breta dutupa nyepala, Gote yaka pilyino latala, disaipolo dupa maiyamopa, disaipolo dupame endakali peteami dupa mokosoo maiyami. Dokopa baame pisa dolapo nyepala, dopaka pyoo Gote yaka pilyino latala, disaipolo dupa maiyamopa, disaipolo dupame endakali peteami dupa mokosoo maiyamiaka. Maiyaminopa endakali dokaitanya auu kaengeme nyiami. ");
INSERT INTO enq2_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nyepala endakali dokaitame nao tiaka kaeteaminopa, Jisasame baanya disaipolo dupa lamaiyoo, “Nee konjepae kakana sina kaelyamino dupa mee soo patana, nyakamame yapao nyoo mau pyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dokopa breta bali diimi wasepae yungi dutupanya endakali dokaitame nao kakana sina kaeyami dupa disaipolo dupame nyoo baseketa 12 tumbasiami. ");
INSERT INTO enq2_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dokopa Jisasame mirakolo pia doko endakali dokaitame kandatala lao pituu, “Propeta mende isa yuu dakenya ipatana latae doko kiningi akali dake-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Dopa latala, endakali dokaita ipao Jisasa minatala baa kyeto joo kiŋi kata laanya pilyamino lao kandatala, baa iki yuu manda mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yuu kuiyala epeamopa, Jisasanya disaipolo dupa lanao Galali pete dokonya peami. ");
INSERT INTO enq2_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Dokopa Jisasa naipao yuu iminjiamopa, dokaita sipi dokonya pyakalyetala endaki pete omotena, Kapename paanya peami. ");
INSERT INTO enq2_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Peaminopa poo yale mende lea dokome, endaki doko etete andake pyoo buli pia. ");
INSERT INTO enq2_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dokaita kilomita yungipi mende sipinya pateaminopa, Jisasa endaki pete dokonya moko katao sipi dokonya tengesa epeamopa, disaipolo dupame kandatala paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dopa piaminopa baame dokaita lamaiyoo, “Namba epelyona, nyakama paka nakaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dopa leamo sepala dokaitame baa sipinya epena lamana lao masiami. Dopa lao masiaminopa, sipi doko lee mendai pao yuu nyakama mona lao masiami dokonya pyakamalu pia. ");
INSERT INTO enq2_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yuu gii mende dokonya, endaki pete dokonya omotena kateami endakali kambu dupame kuaka sipi yakane mendai iki sipyana lao masiami. Sipi yakane dokonya disaipolo dupa iki pyakalyetala puminopa, Jisasa apata napumina lao masiamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kamongome breta nyepala yaka pilyino lateamopa neami panda dosa tengesa, sipi yakane mendapu Taibiriasa katao ipao siami. ");
INSERT INTO enq2_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Dokopa endakali kambu dokome Jisasapi, baanya disaipolopi, dupa yuu dokonya nakateamino kandatala, sipi dupanya pyakalyetala Jisasa kutao Kapename peami. ");
INSERT INTO enq2_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Endaki pete dokonya yangitena Jisasa kateamo kandatala, dokaitame baa lamaiyoo, “Mana Lenge, emba gii andukupa ae ipupipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame nyakama etete kiningi langilyo: Nambame mirakolo pipupa kandamino dokonya, nyakamame namba kutao naepelyamino. Nyakama breta nao tiaka kaeyamino dokonya, namba kutao epelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Takange Goteme Akalinya Ikiningi dokonya kalai pipenge dupa pitaka pina lao yakana latea. Dopa piana, nyakamame etapenge nee dupanya kalai napinya, lete etete katasingi nee, Akalinya Ikiningi dokome maingi dokonya kalai pyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dokopa dokaitame baa lamaiyoo, “Naimame Gotenya kalai aipale mende pyakamaipengepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Dopa leaminopa Jisasame yanu pyakamaiyoo, “Gotenya kalai pyakamaipenge doko, akali mende baame epena lea doko tungi pyapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Dokopa dokaitame baa lamaiyoo, “Endakali napalenge yuu dokonya naimanya yumbange dupa manaa nee doko neami-pyaa. Dopa piami dokonya dapa lao pepa pyapae singi: ‘Baame kaiti-kisa-tae breta doko endakali dupa nena lao maiya-pyaana’ lapae singi. Dopana, embame kalai aipale mende piti? Embame mirakolo aipale mende pitinopa naimame kandatala, pii lelyeno doko kiningina lao masemanape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dokopa Jisasame dokaita lamaiyoo, “Nambame nyakama etete kiningi langilyo: Kaiti-kisa-tae breta doko Mosesame nyakama nandia. Nambanya Takange dokome kaiti-kisa-tae breta angi doko nyakama dingi. ");
INSERT INTO enq2_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kaiti-kisa katao isa ipupala, yuu dakenya endakali dupa pitaka lete katenge maingi akali doko, Gotenya breta dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dokopa endakali dupame baa lamaiyoo, “Akali Andake, embame breta dokoaka koteaka lao naima dipi” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dopa leaminopa Jisasame dokaita lamaiyoo, “Lete katasingi breta doko nambana, endakali mende namba katato dokonya ipatamo doko, baa tanga-tangapi lopo kaeyala naeyata. Endakali mendeme namba tungi pyatamo doko, baa endaki nanu kaeyala naeyataka. ");
INSERT INTO enq2_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nambame kalai pipu dupa nyakamame kandatala, namba tungi napilyaminona lao langyo doko deaka langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dopaka doko, nambanya Takange dokome namba dita endakali dupa pitaka namba katato dokonya ipatami. Namba katato dokonya ipatami dupa nambame tanga-tangapi kamaka watao pyasala naeyato. ");
INSERT INTO enq2_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nambanya masingili pyoo pyaanya namba kaiti-kisa katao isa naepeo. Namba puu lea dokonya masingili pyoo pyaanya epeo. ");
INSERT INTO enq2_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nambanya Takange, namba puu lea dokonya masingili pyoo pipenge doko dake: Yuu etatamo gii dokopa, endakali namba ditae dupanya mendaipi mende alu napina lao, dupa pitaka nambame malunya sakatasepenge doko. ");
INSERT INTO enq2_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ikiningi doko kandatala tungi pyatami endakali dupa pitaka lete etete katataminopa lao namba puu lea Akali dokome masingi. Yuu etatamo gii dokopa nambame endakali dupa malunya sakatasotona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Breta kaiti-kisa katao isa epeamo doko nambana” Jisasame leamosa, Juu dupame baa mumu lao, ");
INSERT INTO enq2_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Akali dakenya endangi takangepa dolapo naimame nakandengepe? Baa Josepe ikiningi Jisasa daa kandamuape? Aipa petala baa kaiti-kisa katao isa epeona lelyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nyakama-lapo mumu kaeyalapa. ");
INSERT INTO enq2_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nambanya Takange, namba puu lea dokome namba katato dokonya lanyoo naipata endakali doko namba katato dokonya naipata. Baame lanyoo ipata endakali doko, yuu etatamo gii dokopa nambame sakatasoto. ");
INSERT INTO enq2_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘Endakali dupa pitaka Goteme mana lamaitana’ lao propeta dupame pepa piami dupanya pyapae silyamo. Takange dokome pii lamaitamopa sepala mana nyetami endakali dupa pitaka namba katato dokonya ipatami. ");
INSERT INTO enq2_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Endakali mendeme Takange doko kanja naeya. Gotepa tole katao isa epeamo akali dokome iki Takange doko kandea. ");
INSERT INTO enq2_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nambame nyakama etete kiningi langilyo: Namba tungi pingima endakali dupa-kisa lete etete katenge doko singi. ");
INSERT INTO enq2_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Lete katasingi breta doko namba. ");
INSERT INTO enq2_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Endakali napalenge yuu dokonya nyakamanya yumbange dupame manaa nee neamiaka doko, dokaita kumiami. ");
INSERT INTO enq2_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dopaka doko, breta kaiti-kisa katao isa epeamo dake natami endakali dupa kumala naeyatami. ");
INSERT INTO enq2_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Breta lete katasingi kaiti-kisa katao isa yuu dakenya epeamo doko namba. Endakali dupa lete katataminopa lao breta dilyo doko nambanya yonge dokona, endakali mendeme natamo doko, baa lete etete katatana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dopa leamopa, Juu dupame nyakama-lapo laloo pyoo, “Akali dakeme baanya yonge doko naima nalapale lao aipa petala ditape?” lao pii yanda piami. ");
INSERT INTO enq2_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dokopa Jisasame dokaita lamaiyoo, “Nambame nyakama etete kiningi langilyo: Akalinya Ikiningi dokonya yonge taeyokopa dolapo nyakamame nanatamino doko, lete katenge doko nyakama-kisa naseta. ");
INSERT INTO enq2_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nambanya yonge taeyokopa dolapo nao katengema endakali dupa-kisa lete etete katenge doko singi. Yuu etatamo gii dokopa, nambame dupa malunya sakatasoto. ");
INSERT INTO enq2_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nambanya yonge doko nee angi doko. Nambanya taeyoko doko endaki angi doko. ");
INSERT INTO enq2_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nambanya yonge taeyokopa dolapo nao katengema endakali dupanya mona andaka namba kalyopa, dupa nambanya mona andaka katengema. ");
INSERT INTO enq2_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kataowaka katenge Takange dokome namba puu lea. Nambanya Takange, namba puu leamo doko mambele namba lete kalyo. Mendai dopaka pyoo, nambanya yonge doko nao katatami endakali dupa namba mambele lete katatami. ");
INSERT INTO enq2_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wamba nyakamanya yumbange dupame manaa nee neaminoaka doko, dokaita kumiami. Breta kaiti-kisa katao isa epeamo doko dopale daa. Breta kaiti-kisa katao isa epeamo doko natami endakali dupa lete etete katatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisasame pii dutupa Kapename lotuu anda dokonya endakali dupa mana lamaiyoo lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisasame dopa lao mana lamaiyamopa, baanya disaipolo longome sepala lao pituu, “Pii dutupa tatake pipae-lumuna, apimi tenge dupa kapa pao soo nyetape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Baanya disaipolo dupame pii dutupanya mumu lelyamino lao Jisasame kandatala dokaita lamaiyoo, “Pii dutupame nyakama kenda pisilyape? ");
INSERT INTO enq2_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kenda pisetamo doko, Akalinya Ikiningi doko wamba katenge yuu dokonya ketae pyakalyetamopa, nyakamame kandatala aipa lao masetami? ");
INSERT INTO enq2_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spirita dokome endakali dupa lete katenge doko maingi. Endakalinya kyetome mende pyaa naenge. Nambame nyakama pii langilyo dupa, Spirita dokopa, lete katenge dokopa, dolapo langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dopaka doko, nyakamanya mendapuame namba tungi napilyaminona” lea. (Jisasame baanya kalai tee pia gii dokonya pituu, baa tungi napyatami endakali dupapi, baa yandapipi dupanya kinginya maita akali dokopi, dupa wambao kandatala baame dopa lea.) ");
INSERT INTO enq2_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jisasame lao pituu, “Nambanya Takange dokome yakana laa naeyatamo doko, namba katato dokonya endakali mende naipatana lao langyo doko, nyakamanya mendapuame namba tungi napyaminosa langyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Baame dopa leamosa, baanya disaipolo longome baa yakinatala, dee baa tole napiami. ");
INSERT INTO enq2_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dokopa Jisasame baanya 12 disaipolo dutupa lamaiyoo, “Nyakama apata namba yakinatala mona lao masilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dokopa Saimone Pitame baanya pii yanu pyakamaiyoo, “Kamongo, lete etete katasingi pii dupa emba-kisa silyamo doko, naima api-kisa mona? ");
INSERT INTO enq2_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Emba Kraisa, Gote kataowaka katenge dokonya Ikiningi dokona lao naimame masetala tungi pilyamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dopa leamopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame nyakama 12 disaipolo dutupa yapao nyio. Dopaka doko, nyakamanya mende imambu koo paleta petelyamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pii doko, 12 disaipolo dutupanya mendeme Jisasa yandapipi dupanya kinginya maitoo lao masia, Saimone ikiningi Judasa Iskariota doko lao lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Maitakao Juu dupame Jisasa pyao kumasalanya kaitini kutiaminosa, baa Judia paeyala naeyatoo lao masetala, yuu Galali dokonya iki paeyao katea. ");
INSERT INTO enq2_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dopa piamopa Juu dupa sele andanya paleami gii doko masoo nee andake nenge gii doko ipanya tengesa pia. ");
INSERT INTO enq2_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Dokopa Jisasanya kaiminingi dupame baa lamaiyoo, “Embanya disaipolo dupame apata embanya kalai pilyino dupa kandena, yuu dake yakinatala Judia puu. ");
INSERT INTO enq2_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aipumape, endakali mendeme baa panao katapuli lao masilya dokome kalai mende pilya doko yalo pyoo napingi. Dopana, embame kalai dutupa pitino doko, emba tange panasoo isa yuu dakenya endakali dupame kandena panao pipi” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Baanya kaiminingi dupame apata baa tungi napiami dokonya dopa leami.) ");
INSERT INTO enq2_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dokopa Jisasame dokaita lamaiyoo, “Nambanya gii doko ipa naelyamo. Dopaka doko, nyakamanya gii doko koteaka lao epelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Isa yuu dakenya endakali dupame nyakama imbu nakaeyapenge. Endakali dupame pingima dupa koo pingimana lao nambame panao lamaipusa, dupame namba imbu kaelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dopa pilyaminona, nyakama nee andake doko nala lalyoo pupa. Nambanya gii doko ipa naelyamo dokonya, indupa namba nee andake doko nala lalyoo napelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pii dutupa dokaita lamaitala, baa Galali yuu dokonya katao kaeya. ");
INSERT INTO enq2_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Baanya kaiminingi dupa nee andake doko nala Jerusalema pateaminopa, maita-pyao Jisasa baa endakali mendeme nakandena lao yalo pyoo peami dokonya peaka. ");
INSERT INTO enq2_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nee andake dokonya nao kateaminopa, Juu dupame Jisasa baa anja kalyape lao tipa pyoo kutiami. ");
INSERT INTO enq2_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kutiaminopa endakali kambu dupame Jisasanya lao kakateame pii longo leami. Yangi dupame baa akali epe mendena leaminopa, yangimi baame endakali kambu dupa minakasilyamona leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dopaka doko, endakali dupame Juu dupa paka kaeyami dokonya, endakali mendaipi mendeme baa akali dokona lao, panao laa naeya. ");
INSERT INTO enq2_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nee andake nenge gii dutupanya kainasa pyakameaminopa, Jisasa lotuu anda nee nyetae kamapu dokonya pupala, baame tee pyao mana lamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mana lamaiyamopa Juu dupa walu latala lao pituu, “Akali dake sukulu laa naengena, aipa petala mana longo dupa nyia laa-kanjemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dopa leaminopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Nambame mana langilyo dupa nambanya daa. Mana dupa namba puu lea Akali dokonya. ");
INSERT INTO enq2_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nambame mana lelyo dupa Goteme dimupa lelyepe, nambanya kyetome lelyepe lao, Gotenya masingili pyoo kalai pitoo lao maseta endakali dokome kandata. ");
INSERT INTO enq2_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Endakali mendeme baanya kyetome pii lelya dokome, baa tange kenge andake nyotoo lao lenge. Dopaka doko, endakali mendeme baa epena leamo akali doko kenge andake nyina lao kiningi pii lenge. Endakali doko-kisa mana koeyapae mende nasingi. ");
INSERT INTO enq2_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesame loo dupa nyakama nandiape? Loo dupa nyakama diaka doko, nyakamanya mendaipi mendeme Mosesanya loo dupa wata-minala naengema. Dopana, nyakamame aipuma namba pyao kumasepenge kaitini kutilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dopa leamopa endakali kambu dupame yanu pyao, “Emba pyao kumasepenge kaitini mende apimi kutilya? Emba-kisa imambu koo mende palelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dopa leaminopa Jisasame dokaita lamaiyoo, “Nambame kalai mendai pipu doko kandatala, nyakama pitaka walu lao paka kaelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yanu kepenge mana doko nyakamame wata-minalapale lao Mosesame setekea. (Mana doko kiningi Mosesame setala naeya. Nyakamanya yumbange dupame mana doko seteami.) Tenge dokonya, Sambata gii dokonya nyakamame wane ane dupa yanu kepengema. ");
INSERT INTO enq2_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosesanya loo dupa nyakamame yalala naeyamana lao masetala, Sambata gii dokonya wane ane dupa yanu kepengema. Dopa pingima doko, nambame Sambata gii dokonya akali mendenya yonge doko pitaka auu pisakamaipu doko, aipuma nyakamame namba imbu kaelyami? ");
INSERT INTO enq2_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nyakamanya lengeme kisa kandao yapala naenya, mana tolatae dokome yapalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Dokopa Jerusalema tange mendapuame lao pituu, “Pyao kumasalanya kutilyamino akali doko dake kandamuape? ");
INSERT INTO enq2_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Baame dakenya katao pii lao panao katamupa, Juumanya isingi akali dupame baa mende lamaiya naelyamino doko, baa Kraisa doko-lamona lao kiningi masetami aipa? ");
INSERT INTO enq2_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Naimame baa yuu dokonya tangena lao masilyamano. Dopaka doko, Kraisa doko ipatamopa, endakali mendaipi mendeme baa anja tangepe lao masala naeyatana” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dopa leaminopa, lotuu anda nee nyetae kamapu dokonya katao Jisasame puu lao dapa lao mana lea: “Namba yuu dosa tange, akali dokona lao nyakamame kandengema. Dopaka doko, namba tangeme ipatoo latala naepeo. Namba puu lea Akali kiningi pii lenge doko nyakamame nakandengema. ");
INSERT INTO enq2_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Namba baa-kisa katenge dokonyana, nambame baa kandenge. Baame namba isa yuu dakenya puu leamosa epeona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dopa leamosa Juumanya isingi akali dupame baa anjepenge kaitini kutiamiaka doko, baanya gii doko ipa naeya dokonya, endakali mendeme baa minala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dokopa endakali kambu kateami dokonya endakali longome baa tungi pyatala lao pituu, “Kraisa doko ipupala, akali dakeme mirakolo pilyamo dupa ita minao pitape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Endakali kambu dokome Jisasanya lao kakateame pii leaminopa, Parasi dupame siami. Sepala Parasipi, prisa mupapi dupame pii latala, Juumanya yanda singi mendapuame Jisasa anjoo nyala pena leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dokopa Jisasame lao pituu, “Namba nyakama-pipa gii kuki iki katapala, namba puu lea Akali doko kalyamo dokonya patoo. ");
INSERT INTO enq2_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nyakamame namba kutatamiaka doko, angi kanja naeyatami. Namba katato dokonya nyakama kapa pao naipatamiakana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dopa leamopa Juu dupame nyakama-lapo laloo pyoo, “Naimame nakanjepale lao baa anja paanya lelya? Naima tata mendapu yuu waka dupanya Giriki dupa-pipa kalyamino dupanya, Giriki dupa mana lamaiya paanya lelyape? ");
INSERT INTO enq2_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Naimame baa kutatamiaka doko angi kanja naeyatamina lelyamo pii dokopa, baa katato dokonya naima kapa pao naipatamina lelyamo pii dokopa, dolaponya tenge doko aipa pyoo lelyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nee andake nenge dokonya gii etao doko, gii andake mende. Gii dokonya Jisasa toeya katapala puu lao, lao pituu, “Endakali mende endaki nanu kaeyateno doko, namba kalyo dakenya endaki nala ipupi. ");
INSERT INTO enq2_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Endakali mendeme namba tungi pyatamo doko, Gotenya pii pepa pyapae singi dokonya lapae singili pyoo, ‘Endakali dokonya mona andaka pituu, lete katenge endaki doko lyoo ipatana’ ” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Baa tungi pyatami endakali dupa Spirita doko nyetamina lao masetala, baame lea doko Spirita doko lao lea. Gii dokopa Jisasa baa kenge andake nyepala naeya dokonya, Oli Spirita doko pyandala naeya. ");
INSERT INTO enq2_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisasame pii leamo doko sepala, endakali kambu kateami dokonya longome lao pituu, “Kiningi, akali dake Propeta ipatana latae doko-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Endakali yangi dupame lao pituu, “Baa Kraisa doko-lamona” leaminopa, yangimi lao pituu, “Dapitanya puu dokonya Kraisa doko ipatana lao Gotenya pii pepa pyapae singi dokonya pyapae singi. Baa Dapitanya taono Betelema dokonya manditana lao pepa pyapae singiaka. Dopa lao pepa pyapae singi doko, yuu Galali dokonya Kraisa doko kapa pao manditape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dopa latala, Jisasa mambele endakali kambu doko wakale pyaloo piami. ");
INSERT INTO enq2_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Endakali yangi dupame baa anjemana lao masiamiaka doko, dupanya mendaipi mendeme baa minala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dokopa prisa mupapi, Parasipi dupa peteami dokonya yanda singi dupa pilyiaminopa, dokaitame yanda singi dupa lamaiyoo, “Aipuma nyakamame Jisasa anjetala laminao naepelyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dokopa yanda singi dupame yanu pyao, “Akali dokome pii lelyamoli pyoo, yuu mendaipi mende endakali mendeme naleana” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dopa leaminopa Parasi dupame dokaitanya pii yanu pyakamaiyoo, “Baame nyakama apata minakaseta aipa? ");
INSERT INTO enq2_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Isingi akalipi, Parasipi dupanya mendaipi mendeme baa tungi pilyamipi? ");
INSERT INTO enq2_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Endakali kambu dakeme Mosesanya loo dupa masala naelyamino dokonya, Goteme dupa koeyasetana” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dopa leaminopa Parasi dupanya mende, Nikodimasa lenge doko, kuka gii mendenya Jisasa kanja pea dokome dokaita lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Endakali mendeme koo pita dupa auu pyoo kandao nyala naenya, baa koeyapya-lamona lapape lao naimanya loo dupanya lapae singipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dokopa dokaitame baanya pii yanu pyakamaiyoo, “Emba apata Galali tangepe? Galali tange propeta mende sakatao kateana lapae nasilyamona, pii pepa pyapae singi dupa itaki pyao kandape” leami. ");
INSERT INTO enq2_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dokopa endakali dupa pitaka mendai-mendai lao nyakamanya andaka peami. ");
INSERT INTO enq2_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Endakali dupa peaminopa Jisasa baa Olipimanda pea. ");
INSERT INTO enq2_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yongama wamba utunya baa lotuu anda nee nyetae kamapu dokonya deaka ipao katea. Dokopa Israele tata dupa pitaka epeaminopa, baa pitipala dupa mana lamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lamaiyoo peteamopa, enda mendeme kepo koleamopa endakali dupame kandao nyiami mende Mosesanya loo mana nyepaepi, Parasipi dupame laminao Jisasa petea dokonya ipupala, endakali kateami kaina dokonya katasiami. ");
INSERT INTO enq2_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Katasetala dupame Jisasa makande pyoo dapa lamaiyami: “Mana Lenge, enda dake kepo kolamupa kandao nyalamini-lamo. ");
INSERT INTO enq2_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesanya loo setapae dokome enda dopale dupa kaname pyao kumasalapape lapae singina, embame dokonya aipa lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jisasame kopeta mende latamopa baa-kisa tenge setamana latala baa makande pyoo dopa leami. Dopa leaminopa, Jisasame pii doko nasili pyoo baa pongatala, kingi kondeme yuunya pepa pia. ");
INSERT INTO enq2_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pepa piamopa, Parasipi, Mosesanya loo mana nyepaepi, dupame Jisasa tipaka pyoo kateaminosa, baa toeya katapala dokaita lamaiyoo, “Nyakamanya mende koo napingi dokome wambao kana mende pyale lao enda dake pyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dopa latala baa dee pongatala yuunya pepa pia. ");
INSERT INTO enq2_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dokopa Jisasanya pii dutupa sepala, dokaitanya moname nyakama koelyaminona leamosa, endakali angili dupa mendai-mendai lao wambao peaminopa, kole dupa watao peami. Pao etapeaminopa, enda doko iki Jisasa petea dosa katea. ");
INSERT INTO enq2_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dokopa Jisasa toeya katapala enda doko iki kateamo kandatala baa lamaiyoo, “Emba-kisa tenge setalamino endakali dokaita anja pami? Mendeme emba-kisa tenge setapala pyao kumasalanya nakalyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Dokopa enda dokome lao pituu, “Akali Andake, mende nakalyamona” lea. Dopa leamopa Jisasame lao pituu, “Nambame apata emba yapala naelyona, emba pupala dee koo mende napipi” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Dokopa Jisasame deaka dokaita lamaiyoo, “Yuu dake tii pisingi doko namba. Namba watao ipata endakali doko-kisa lete katenge tii pipae doko setamopa, iminjetae dokonya baa napaeyatana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dopa leamopa Parasi dupame baa lamaiyoo, “Emba dopalena lao emba tange lao panasilyino dokonya, embanya pii doko kiningina lao naimame nyala naelyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Namba katao epeo yuu doko nyakamame masala naeyao, namba pelyo yuu doko nyakamame masala naeyaowaka pilyamino. Dopaka doko namba katao epeo yuu doko nambame kandao, namba pelyo yuu doko nambame kandaowaka pingi. Dokonya namba dopalena lao namba tange lapuli doko, kiningi lapuli. ");
INSERT INTO enq2_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyakamame endakali ketae kandao yapengema. Nambame endakali mende yapala naenge. ");
INSERT INTO enq2_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Namba iki nakalyo. Nambanya Takange, namba puu lea dokopa namba tole kalyambano. Tenge dokonya, nambame endakali mende yapapuli doko tolao yapapuli. ");
INSERT INTO enq2_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nyakamanya loo dupanya dapa lao pepa pyapae singi: ‘Endakali lapomame pii mendai dokoaka lao panelyambino doko, pii doko kiningina’ lapae singi. ");
INSERT INTO enq2_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Namba dopalena lao namba tange lao panasipupa, nambanya Takange, namba puu lea dokome apata namba dopalena lao, lao panasilyamoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dokopa Parasi dupame baa lamaiyoo, “Embanya takange lelyeno doko anja kalyape?” leami. Dopa leaminopa Jisasame yanu pyao, “Nambapa, nambanya Takange dokopa nyakamame masala naengema. Namba akali doko-lamo lao nyakamame masimili doko, nambanya Takange doko apata masimiliakana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","(Lotuu anda nee nyetae kamapu dokonya opaa pyandenge penge doko singi dosa katao, Jisasame pii dutupa mana lamaiyoo lea. Baanya gii doko naepea dokonya, pii dutupa leamopa endakali mendaipi mendeme baa anjalanya minala naeyami.) ");
INSERT INTO enq2_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Dokopa Jisasame deaka dokaita lamaiyoo, “Nambame nyakama yakinatala pelyo. Namba pelyo dokonya nyakama kapa pao naipatami. Nyakamame namba kutapala, nyakamanya koo dupanya nyakama kumatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dokopa Juu dupame lao pituu, “ ‘Namba pelyo dokonya nyakama kapa pao naipatamina’ lelyamo doko, baa tange pyao kumasalanya lelyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dopa leaminopa baame dokaita lamaiyoo, “Namba kaiti ulunya-tae. Namba isa yuu dakenya tange daa. Nyakama isa yuu dakenya-tae. Tenge dokonya nyakama isa yuu dakenya tange. ");
INSERT INTO enq2_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Namba akali doko-lamo lao nyakamame masala naeyatamino doko, nyakamanya koo dupanya nyakama kumatami. Tenge dokonya, nyakamanya koo dupanya nyakama kumatamina lao nambame langyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dopa leamopa dokaitame baa lamaiyoo, “Emba apipi?” leami. Dokopa Jisasame dokaita lamaiyoo, “Namba akali dokona lao tee pyao langio dokoaka namba. ");
INSERT INTO enq2_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nyakama koelyaminona lao nambame yapao pii longo langipuliaka doko, namba puu lea Akali kiningi pii lenge dokome pii langiamopa sio dutupa iki, isa yuu dakenya endakali dupa nambame panao lamailyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","(Jisasame lea doko, Takange doko lao lelyamona lao dokaitame masala naeyami.) ");
INSERT INTO enq2_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dokopa Jisasame dokaita lamaiyoo, “Nyakamame Akalinya Ikiningi doko minalyetaminopa, nyakamame namba akali doko-lamo lao kandatami. Nambame kalai pilyo dupa nambanya kyetome napinya, nambanya Takange dokome namba mana leali pyoo pii dutupa lea-lamo lao nyakamame kandatamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Namba puu lea Takange dokonya auu kaenge kalai dupa nambame koteaka lao pingi. Dopa pingi dokonya, baame namba iki kalyale lao yakinala naenge. Nalimba tole katengena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pii dutupa leamopa endakali longome baa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dokopa Jisasame baa tungi pilyamano leami Juu dupa lamaiyoo, “Nyakamame nambanya pii doko wata-minao katatamino doko, nyakama nambanya disaipolo angi katatami. ");
INSERT INTO enq2_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dokopa nyakamame kiningi pii doko masetaminopa, kiningi pii dokome nyakama mokao nyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dokopa dokaitame baanya pii yanu pyakamaiyoo, “Naima Abraamenya puu dokonya mandipae dupa paa mendaipi mende endakali mendenya kendemane nakatengena, kiningi pii dokome naima mokao nyetana lao embame lelyeno doko, aipa pyoo lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dopa leaminopa Jisasame yanu pyakamaiyoo, “Nambame nyakama etete kiningi langilyo: Endakali koo pingi dupa pitaka koonyaka kendemane katengema. ");
INSERT INTO enq2_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kendemane mende baanya akali andake dokonya andaka etete nakatenge. Akali andake dokonya ikiningi doko andaka dokonya etete katenge. ");
INSERT INTO enq2_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dopana, Ikiningi dokome nyakama mokao nyetamo doko, kiningi etete nyakama mokao nyepaeyaka katatami. ");
INSERT INTO enq2_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nyakama Abraamenya puu dokonya mandipaena lao nambame masilyoaka doko, nambanya pii doko nyakama-kisa sepenge panda mende nasipya dokome, nyakamame namba pyao kumasepenge kaitini kutilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nambanya Takange doko-pipa tole katao kandeo dokoaka lelyo. Dopaka pyoo, nyakamanya takange doko-pipa tole katao kandeamino dokoaka pilyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dokopa dokaitame baanya pii yanu pyakamaiyoo, “Naimanya takange doko Abraamena” leami. Dopa leaminopa Jisasame dokaita lamaiyoo, “Nyakama Abraamenya wane-pyali doko, Abraameme pia dupa nyakamame pimili. ");
INSERT INTO enq2_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dopaka doko, nambame Gote-kisa kiningi pii sio dupa nyakama langipupa, indupa nyakamame namba pyao kumasepenge kaitini kutilyamino. Nyakamame pilyamino doko Abraameme napia. ");
INSERT INTO enq2_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyakamanya takange dokome pingi dupaka nyakamame pilyaminona” lea. Dokopa dokaitame baa lamaiyoo, “Naima mandinya nepatae mendapu nakalyamano. Naimanya Takange mendai iki doko Gotena” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dokopa Jisasame dokaita lamaiyoo, “Namba Gote-kisa katao ipupala yuu dakenya kalyo. Namba tangeme masoo naepeo. Baame namba puu leamopa epeo. Gote nyakamanya Takange-pyali doko, nyakamame namba auu kaeyamili. ");
INSERT INTO enq2_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nambame pii lelyo doko aipuma nyakamame soo nanyilyami? Nambanya pii doko nasimi dokome, nyakamame kapa pao tenge doko soo nyala naelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyakamanya takange doko Satane. Baa sambo piinya takange dokonyana, baa-kisa sambo pii iki singi. Baame pii lelyamo dokopa, sambo pii iki lenge. Tee pia dokonya pituu, baame endakali pyao kumasia. Baa-kisa kiningi pii doko nasingi dokonyana, baa kiningi pii dokonya nakatenge. Nyakamanya takange Satane dokome pingili pyoo nyakamame pimu laka lao masilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tenge dokonya, nambame kiningi pii doko langipupa, kiningi lelyenona lao nyakamame masala naelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nambame koo mende pipina lao nyakamanya mendeme lao tata latepe? Nambame kiningi pii lenge-tamo doko, aipuma kiningi lelyenona lao nyakamame masala naelyami? ");
INSERT INTO enq2_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Endakali Gote tata dupame Gotenya pii dupa singima. Nyakama Gote tata nakalyamino dokonya, baanya pii dupa nasilyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dokopa Juu dupame Jisasanya pii yanu pyakamaiyoo, “Naimame emba Samaria tangena lelyamano dokopa, emba-kisa imambu koo mende palelyamona lelyamano dokopa, dolapo kopeta lelyamape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Dopa leaminopa Jisasame yanu pyao, “Namba-kisa imambu koo mende napalelyamo. Nambanya Takange doko anda-anda semaiyoo katapupa, nyakamame namba anda-anda singyala naelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Namba tange kenge andake nyalanya kaitini kutao nakalyo. Akali mendeme namba kenge andake dyaanya pilyamo dokome endakali dupa tolao yapenge. ");
INSERT INTO enq2_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nambame nyakama etete kiningi langilyo: Endakali mendeme nambanya pii doko wata-minatamo doko, baa tanga-tangapi kumingi doko nakandatana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Dopa leamopa Juu dupame baa lamaiyoo, “Abraamepi, propetapi dupa kumiami-pyaa. Dopaka doko, endakali mendeme embanya pii doko wata-minatamo doko, baa tanga-tangapi kumingi doko nakandatana lelyeno doko, embame naimanya takange Abraamepi, propetapi kumiami dupa ita minao kalyepe? Indupa naimame emba-kisa imambu koo mende palelyamo lao kandelyamanona, emba tange apina lelyepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dopa leaminopa Jisasame yanu pyao, “Namba tange kenge andake nyoto doko, angi mende nanjeta. Nambanya Takange dokome namba kenge andake dingi. Baa lao nyakamame lao pituu, ‘Naimanya Gote dokona’ lengema. ");
INSERT INTO enq2_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nyakamame baa nakandengema. Dopaka doko, nambame baa kandenge. Nambame baa nakandengena lapuli doko, namba sambo lenge nyakama-yale jipuli. Dopaka doko, nambame baa kandenge dokonyana, baanya pii doko nambame wata-miningi. ");
INSERT INTO enq2_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nyakamanya takange Abraameme nambanya gii doko kandatona lao eteke pia. Baame gii doko kandatala auu kaeyana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dopa leamopa Juu dupame baa lamaiyoo, “Emba ee kana 50 latala naelyamo doko, embame aipa petala Abraame kandeepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dokopa Jisasame dokaita lamaiyoo, “Nambame nyakama etete kiningi langilyo: Abraame manja naengesa, namba wamba-waka kateo dokoaka katengena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dopa leamosa Juu dupame baa pyalanya kana nyiaminopa, Jisasa baa yalo pyoo, dokaitanya kaina dupanya-kaita lotuu anda nee nyetae kamapu doko yakinatala pea. ");
INSERT INTO enq2_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisasa baa kaitini pao pituu kandeamopa, endangimi lenge monda jetae mandea akali mende petea. ");
INSERT INTO enq2_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dokopa Jisasanya disaipolo dupame baa tipa pyoo, “Mana Lenge, apimi koo pia mambele akali dake lenge monda mandea? Baa tangeme koo pia mende mambelepe, pande baanya endangi takangepame koo piambi mende mambelepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Dopa leaminopa Jisasame yanu pyao, “Akali dakenyapi, baanya endangi takangepa dolaponyapi koo piami mende mambele daa. Goteme baanya kalai andake dupa akali dake-kisa panao pitamopa endakali dupame kandataminopa lao pia. ");
INSERT INTO enq2_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yuu kuilyamopa endakali mendeme kalai napingi. Tii pilyamo dakepa, namba puu lea Akali dokonya kalai dupa nambame yakinala naeyao pyakamaipenge. ");
INSERT INTO enq2_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Namba isa yuu dakenya kalyo dakepa, namba isa yuu dakenya tii pipae doko kalyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dopa latala baame sopokali talyinya yuunya setapala, yuu-pipa mandau minia. Mandau minatala akali lenge monda dokonya lenge dolaponya nyoo katasakamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dopa petala Jisasame akali doko lamaiyoo, “Endaki pete tombapae Siloamenya emba wasa pyala puu” lea. (Siloame dokonya tenge doko, Pena latae.) Dopa lateamopa, baa pupala dokonya wasa pia. Dokopa baanya lenge dolapo auu pyoo teamopa, baa andaka pea. ");
INSERT INTO enq2_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Peamopa baanya patali makepi, wamba baa lenge mondana lao kandengemapi, dupame lao pituu, “Akali dake muni akipi tee lao petenge doko laa-kanjemape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dopa leaminopa endakali mendapuame lao pituu, “Baa akali dokoakana” leami. Yangimi lao pituu, “Akali dake baa-yale etete mende-lamona” leami. Dopa leaminopa akali dokome lao pituu, “Namba akali lelyamino dokoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dokopa endakali dokaitame baa lamaiyoo, “Embanya lenge dolapo aipa petala auu pipyape?” lao tipa peta piami. ");
INSERT INTO enq2_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dokopa akali dokome yanu pyao, “Akali Jisasa lenge mendeme yuu mendatupa mandau minatala, nambanya lengenya katasetakala namba langyoo, ‘Endaki pete Siloamenya wasa pyala puu’ lamo. Dokopa namba pao wasa pyapapupa, namba lenge auu pyoo talona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dopa leamopa dokaitame baa lamaiyoo, “Akali doko anja kalyape?” leami. Dopa leaminopa baame lao pituu, “Namba masala naelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jisasame yuu mendatupa mandau minatala, akali lenge monda doko auu pisakamaiya doko, Sambata gii mendenya auu pisakamaiya. Akali doko Parasi dupa kateami dokonya laminao peami. ");
INSERT INTO enq2_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pateaminopa Parasi dupame baa tipa pyoo, “Embanya lenge dolapo aipa petala auu pyaape?” leami. Dokopa baame dokaita lamaiyoo, “Akali mendeme nambanya lengenya mandau katasakalamo. Dokopa nambanya lenge dolapo wasa pyapapupa lenge auu pyoo talona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dopa leamopa Parasi yangimi lao pituu, “Akali dokome Sambata loo doko wata-minala naeyalumuna, baa Goteme epena latae daa-lumuna” leami. Dokopa yangimi lao pituu, “Akali koo pingi mendeme aipa petala mirakolo dopale dupa pipyalipi?” leami. Dopa latala dokaita wakale pyaloo piami. ");
INSERT INTO enq2_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dopa petala dokaitame lenge monda doko deaka lamaiyoo, “Akali dokome embanya lenge dolapo auu pisakalame-lamo dokonya, embame baa lao aipa lelyepe?” leami. Dokopa baame lao pituu, “Akali doko baa propeta mende-lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lenge monda dokome auu pyoo kandeamo doko kandatala, wamba baa lenge mondana lao Juu dupame masala naeyami. Masala naeyapala, akali lenge auu pyoo tea dokonya endangi takangepa dolapo lanyoo epena leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Endangi takangepa dolapo ipateambinopa dokaitame tipa pyoo, “Akali dake nyakambanya ikiningi, wamba lenge monda jetae mandeambana lengemba dokope? Dokoaka-tamo doko, baa indupa aipa petala lenge auu pyoo telyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dokopa endangi takangepa dolapome dokaitanya pii yanu pyakamaiyoo, “Baa nalimbanya ikiningi, lenge monda jetae mandeamba dokoakana lao nalimbame masilyambano. ");
INSERT INTO enq2_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Indupa baa aipa petala lenge auu pyoo telyape, apimi lenge dolapo auu pisakamaiyape lao nalimba nakanjembano. Baa akali angina, tangeme laapomona, nyakamame baa tipa pyepa” leambi. ");
INSERT INTO enq2_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","(Endakali mendeme Jisasa baa Kraisa dokona lao, lao panatamo doko, baa lotuu anda dokonya watao pyatamana lao, Juu dupame wambao pii yaki peteami. Dopa peteami dokonya baanya endangi takangepa dolapome Juu dupa paka kaeyapala, “Baa akali angina, nyakamame baa tipa pyepa” leambi.) ");
INSERT INTO enq2_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dokopa dokaitame paa lapo pyoo lenge monda doko epena latala lamaiyoo, “Akali doko koo pingina lao naimame masilyamanona, embame Gote kenge andake maiyoo kiningi pii doko laa” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dopa leaminopa baame yanu pyao, “Baa koo pingipi, napingipi lao nambame masala naelyo. Mendai iki mende masilyo doko, wamba namba lenge monda kateo doko, indupa lenge auu pyoo tao kandelyo dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dokopa dokaitame deaka baa lamaiyoo, “Baame embanya aipa pyakala? Baame aipa petala embanya lenge dolapo auu pisakalape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Wamba nambame nyakama langitalo doko nasepala, aipuma nyakamame deaka semana lao masilyami? Nyakama apata baanya disaipolo katamana lao masilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dokopa dokaitame baa lao nepao, “Naima Mosesanya disaipolona, emba baanya disaipolo-lumu. ");
INSERT INTO enq2_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Goteme Mosesa pii lamaiya-pyaana lao naimame masilyamano. Dopaka doko, akali doko anja katao epeape lao naimame masala naelyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dopa leaminopa baame dokaitanya pii yanu pyakamaiyoo, “Anetupa, nyakamame lelyamino doko nambame sepala walu lelyo. Akali dokome nambanya lenge dolapo auu pisakalamo doko, nyakamame baa anja katao epeape lao masala naeyalumino. ");
INSERT INTO enq2_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Endakali koo pingi dupanya Goteme pii nasakamaingina lao naimame masilyamano. Dopaka doko, endakali mendeme Gote mambo pyao katao, baame lelyamoli pyoo katenge-tamo doko, Goteme baanya pii doko sakamaingi. ");
INSERT INTO enq2_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wamba-wambapi endangimi lenge monda jetae mandea endakali mendenya lenge akali mendeme auu pisakamaiya-pyaana lapae nasingi. ");
INSERT INTO enq2_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Goteme akali dake epena naleali doko, baame pilyamo dapale mende napipyalina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dokopa dokaitame baanya pii yanu pyakamaiyoo, “Emba koo sepeta mandipae etete koo dakeme naima mana lelyepe?” leami. Dopa latala baa watao kamaka pyasiami. ");
INSERT INTO enq2_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Akali doko watao kamaka pyasalamino lapae doko Jisasame sepala akali doko kutia. Kutao kandatala baa lamaiyoo, “Embame Gotenya Ikiningi doko tungi pilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dopa leamopa baame yanu pyao, “Akali Andake, embame namba langitinopa tungi pyatoo, Gotenya Ikiningi doko apipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Dokopa Jisasame baa lamaiyoo, “Embame baa kandataleno. Akali mendeme emba pii langimupa tole kalyambino doko baana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dokopa akali dokome lao pituu, “Kamongo, nambame emba tungi pilyona” lea. Dopa latala baame Jisasa mambo pia. ");
INSERT INTO enq2_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dokopa Jisasame lao pituu, “Namba isa yuu dakenya epeo doko, endakali lenge monda dupa lenge auu pyoo tapala kandena lao, lenge auu pyoo tenge dupa lenge monda jetala nakandena lao yapalanya epeona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Dokopa Parasi mendapu tengesa dosa kateami dupame pii dutupa sepala baa lamaiyoo, “Naima apata lenge mondape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dokopa Jisasame dokaita lamaiyoo, “Nyakama lenge monda-pyali doko, nyakama-kisa koo mende nasipyali. Dopaka doko, indupa nyakama lenge auu pyoo tao kandengena lelyamino dokonya, nyakamanya koo dupa nyakama-kisa silyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisasame lao pituu, “Nambame nyakama etete kiningi langilyo: Endakali mende sipisipi kamenya andakote ipanya, sipisipi lumbao nyingi kalomba dokonya-kaita naepenya, waka mendasa-kaita kisoo pyakanatamo doko, baa makongao, pake nao paenge mende. ");
INSERT INTO enq2_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dopaka doko, sipisipi lumbao nyingi kalomba dokonya-kaita epenge doko baa sipisipi setao katenge akali doko. ");
INSERT INTO enq2_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Akali doko epelyamopa, sipisipi epenge kalomba doko isoo katenge akali dokome baanya kaita lumbakamaingi. Dokopa sipisipi setao katenge doko ipupala, baanya sipisipi dupa kenge lao wii lelyamopa, dupame baanya pii doko sepala baa watengema. Watelyaminopa baame dupa laminao kamaka penge. ");
INSERT INTO enq2_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Baanya sipisipi dupa pitaka laminao kalomba dokonya kamaka pyakalyetala, baa wambao penge. Dopa pilyamopa, baanya sipisipi dupame baanya pii sepala, nyakamanya akali doko-lumu lao masetala, baa watao pengema. ");
INSERT INTO enq2_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dopaka doko, sipisipi dupame endakali waka mendenya pii sepala, endakali doko nyakama nakandenge mende-lumu lao masetala, baa watala naenya paka pengemana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisasame kongali doko dokaita lamaiyaka doko, pii lamaiya dokonya tenge doko dokaitame aipa pyoo lelyape lao soo nanyiami. ");
INSERT INTO enq2_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dopa piaminosa Jisasame deaka dokaita lamaiyoo, “Nambame nyakama etete kiningi langilyo: Sipisipi dupa kolandapenge kalomba doko namba. ");
INSERT INTO enq2_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Endakali wambao epeami dupa pake nengepi, makongopaepi dupa epeami. Epeamiaka doko, sipisipi dupame dokaitanya pii nasakamaiyami. ");
INSERT INTO enq2_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Namba kalomba doko. Endakali mende namba-kisa kolandatamo doko, baa Goteme pyoo nyeta. Baa namba-kisa kamaka pata, andakote ipata pyoo, nee nyoo nao katata. ");
INSERT INTO enq2_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pake nenge dokome sipisipi dupa pake nyepa, koeyaseta, pyao kumaseta pyaanya epenge. Dopaka doko, namba epeo doko, sipisipi dupa lete katenge doko nyepala, auu pyoo katataminopa lao epeo. ");
INSERT INTO enq2_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Namba sipisipi setao katenge epe doko. Sipisipi setao katenge epe dokome baanya sipisipi dupa kumala naena lao baa tange kame soo kumala penge. ");
INSERT INTO enq2_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dopaka doko, yole kalai pingi akali doko baa sipisipi setao katenge doko daa, baa sipisipi dupanya yumbange doko daaka dokonyana, yana kapu mende epelyamo kandatala, baame sipisipi dupa yakinatala paka penge. Paka patelyamopa, yana kapu dokome sipisipi dupa watambatala pyao nelyamopa, yangi dupa paka pyakao tale pingima. ");
INSERT INTO enq2_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yole kalai pingi akali dokome yolenya iki masoo kalai pingi. Dopa pilya dokome, sipisipi dupa nee nakaenya baa paka penge. ");
INSERT INTO enq2_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sipisipi setao katenge epe doko namba. Takange dokome namba kandelyamopa, nambame Takange doko kandenge. Mendai dopaka pyoo, nambanya sipisipi dupa namba tange kandelyopa, dupame namba kandengema. Tenge dokonya, nambanya sipisipi dupa kumala naena lao namba tange kame soo kumala penge. ");
INSERT INTO enq2_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nambanya sipisipi mendatupa kame dakenya nakalyamino dupa apata nambame lanyepenge. Lanyepatopa dupame nambanya pii setami. Dokopa sipisipi dupa pitaka tata mendai katataminopa, setao katenge mendaiyaka katata. ");
INSERT INTO enq2_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nambanya lete katenge doko yakinao kumapala dee tange nyotopa lao, namba tange kame soo kumala penge dokonya, nambanya Takange dokome namba auu kaenge. ");
INSERT INTO enq2_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Namba kumatale lao endakali mendeme nambanya lete katenge doko nyokonyala naeyata. Lete katenge doko kame soo kumala penge dokopa, pilyoo nyingi dokopa, dolaponya kyeto doko namba-kisa singi. Dopa pipi lea pii doko nambanya Takange-kisa nyiona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juu dupame pii dutupa sepala, nyakama-lapo deaka wakale pyaloo piami. ");
INSERT INTO enq2_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wakale pyaloo piami dupanya longome lao pituu, “Baa-kisa imambu koo mende palipya dokome baa kyakelyamona, aipuma nyakamame baanya pii sakamailyamipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yangimi lao pituu, “Pii epe dopale dupa imambu koo palenge dupame nalengema. Imambu koo palenge akali mendeme endakali lenge monda mende kapa pao lenge auu pyoo tena lengepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lotuu anda nee nyetae doko kaita lumbiami gii doko masoo, Jerusalema nee nengema gii doko poo lao aiyuu epenge gii dokonya epea. ");
INSERT INTO enq2_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dokopa Jerusalema lotuu anda nee nyetae kamapu dokonya veranda kaname petae Solomonenya lenge dokonya Jisasa baa paeya. ");
INSERT INTO enq2_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Dopa piamopa, Juu dupa ipao Jisasa kakopatala baa lamaiyoo, “Emba akali dokona lao gii andukupa naima panao langitopa lao yalo petae kalye? Emba Kraisa doko-tamo doko, embame naima tolao langi” leami. ");
INSERT INTO enq2_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dokopa Jisasame dokaitanya pii yanu pyakamaiyoo, “Namba akali dokona lao nyakama langipupa, kiningi lelyenona lao nyakamame masala naelyamino. Nambanya Takangenya kengenya kalai pilyo dupame namba akali dokona lao panasilyamo. ");
INSERT INTO enq2_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dopaka doko, nyakama nambanya sipisipi daa dokonyana, namba akali dokona lao nyakamame masala naelyamino. Nyakamame masala naeyalamino lao nambame nyakama langitapu. ");
INSERT INTO enq2_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nambanya sipisipi dupa namba tange kandenge. Dupame nambanya pii doko sepala namba watao epengema. ");
INSERT INTO enq2_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Epelyaminopa dupa tanga-tangapi kumao alu napitaminopa lao lete etete katenge doko nambame maingi. Maitae dupa nambanya kinginya mendeme nyokonyala naeyata. ");
INSERT INTO enq2_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nambanya Takange, sipisipi dupa namba dia dokome dupa pitaka ita miningi. Sipisipi namba ditae dupa nambanya Takangenya kinginya mendeme kapa pao nyokonyala naeyataka. ");
INSERT INTO enq2_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nambapa, nambanya Takangepa, nalimba mendaina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dokopa Juu dupame baa pyalanya dee kana nyiami. ");
INSERT INTO enq2_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dopa piaminopa Jisasame dokaita lamaiyoo, “Nambanya Takangeme kalai pyaale lao namba dia dupanya kalai epe longo mendapu nyakamame kanjepale lao pipu. Dupanya anduku nambame kopeta pipusa, nyakamame namba kaname pyalanya pilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dopa leamopa Juu dupame baanya pii yanu pyakamaiyoo, “Embame kalai epe mende pipino kandatala, naimame emba kaname pyalanya napilyamano. Emba yuunya akali dokome Gote anda-anda semaiya naeyao emba Gote kalyona lapinosa, naimame emba pyalanya pilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dopa leaminopa Jisasame dupanya pii yanu pyakamaiyoo, “ ‘Nyakama gote mendapu kalyaminona leana’ lao nyakamanya loo dupanya pepa pyapae nasingipi? ");
INSERT INTO enq2_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Gotenya pii pepa pyapae singi doko endakali mendeme kapa pao aloo napita. Gotenya pii wambao nyiami dupa gote mendapu kalyaminona lao baame lea-lumu doko, ");
INSERT INTO enq2_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","‘Namba Gote Ikiningina’ lapupa, aipuma nyakamame ‘Gote anda-anda semaiya naeyao lelyenona’ lelyami? Nambanya Takange dokome namba makande latala, isa yuu dakenya puu leamopa epeo. ");
INSERT INTO enq2_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Nambame pii lelyo dupa kiningina lao nyakamame masala naeyatamino doko, nambanya kalai pilyo dupa kanjepape. Nambanya Takangenya kalai dupa nambame napingi-tamo doko, nambame pii lelyo dupa kiningina lao masala naeyalapape. Dopaka doko, nambanya Takangenya kalai dupa nambame pingi-tamo doko, kalai dupa kandatala nambame pii lelyo dupa kiningina lao masalapape. Dokopa namba Takange dokonya mona andaka kalyopa, baa nambanya mona andaka katenge-lamo lao nyakamame kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dokopa dokaitame baa anjepenge kaitini kutiaminopa, dupa yakinatala baa pea. ");
INSERT INTO enq2_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pupala endaki Jodane yangitena, wamba Joneme endakali kaimbu pyakamaiyamo yuu dokonya katea. ");
INSERT INTO enq2_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dokopa endakali longo baa katea dokonya ipupala lao pituu, “Joneme mirakolo mende napiamoaka doko, baame akali dakenya lao pii leamo dupa pitaka kiningi-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dokopa endakali dosa kateami dupanya longome baa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yuu yakane Betani dokonya tange akali Lasarusa lenge doko yaina sia. Mariapa, baanya kakingi Matapa dolapo yuu dokonya tange. ");
INSERT INTO enq2_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maria dokome wele tunduma pipae mendeme Kamongonya moko kai pyatakamai, baanya aiyomba itimi moko tombe lea dupa kunao nepakamaiya enda dokoaka. Yaina sia akali Lasarusa lenge doko, enda dokonya pimalenge.) ");
INSERT INTO enq2_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasarusa baa yaina siamosa, pimalenge dolapome “Kamongo, embanya auu kaenge akali doko yaina silyamona” lao wai leambi. ");
INSERT INTO enq2_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisasame wai doko sepala lao pituu, “Yaina dokome baa kumasala naeyalapomo. Yaina dokonya-kaita Gotenya kenge andake doko baanya Ikiningi doko-kisa panasetamopa, baanya Ikiningi doko kenge andake nyetana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Matapi, baanya kakingi Mariapi, Lasarusapi dutupa Jisasame auu kaenge. ");
INSERT INTO enq2_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Baame Lasarusa yaina silyamo lapae doko sepala, baa katea yuu dokonya yuu gii lapoma apata katea. ");
INSERT INTO enq2_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Katapala baanya disaipolo dupa lamaiyoo, “Naima Judia yuu dokonya dee mua” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dopa leamopa disaipolo dupame baa lamaiyoo, “Mana Lenge, indupa Juu dupame emba kaname pyalanya kaitini kutilyamino doko, emba yuu dokonya deaka patepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Dokopa Jisasame yanu pyao, “Yongama pituu alemandi tuu lao, kiloko gii dutupa 12 awa daa kandamuape? Endakali mende kotaka paenge-tamo doko, baa isa yuu dakenya tii pipae dokonya kandao paelyamopa lombapae nasingi. ");
INSERT INTO enq2_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dopaka doko, endakali mende-kisa tii pipae doko nasilyamopa iminjetaenya paenge-tamo doko, baa lombapae singina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Baame pii dutupa latala dokaita lamaiyoo, “Naimanya mona setenge Lasarusa doko luu palelyamona, nambame baa pyale tala patoana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dokopa baanya disaipolo dupame lao pituu, “Kamongo, baa luu palitamo doko, baa yaka jalapomona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasarusa luu palelyamona Jisasame lea doko, baa kumatapyana lao lea. Dopaka doko, baa luu palimupa lelyape lao Jisasanya disaipolo dupame masiami. ");
INSERT INTO enq2_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dopa lao masiaminosa Jisasame dokaita panao lamaiyoo, “Lasarusa baa kumatapya. ");
INSERT INTO enq2_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nyakamame namba tungi pyalapale lao, Lasarusa kumapya dokonya namba nakatapu dokonya eteke pilyo. Dopaka doko, naima baa silyamo dokonya mua” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Akali Tomasa, kenge mende Pakao Mandipae lenge dokome disaipolo yangi dupa lamaiyoo, “Naima apata Jisasa-pipa kumamana mua” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisasa pao Betani pyakamatala, Lasarusa malu piami doko yuu gii kitomende patelyamo leamino sia. ");
INSERT INTO enq2_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","(Betani pituu Jerusalema doko 3 kilomitapi mende.) ");
INSERT INTO enq2_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Matapa, Mariapanya pimalenge doko kumia dokonya, enda dolapo-pipa enda waka mendapu kumanda peteami. Peteami dokonya, Juu longo ipao kumanda peteamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Peteaminopa, Jisasa epelyamo leamino Matame sepala, kaitinisa kandanyalanya peamopa, Maria baa andaka petea. ");
INSERT INTO enq2_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matame Jisasa kandanyetala baa lamaiyoo, “Kamongo, emba ae kateeli doko, nambanya pimalenge doko kumala naeyali. ");
INSERT INTO enq2_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dopaka doko, embame dopale mende Gote-kisa tee lateno doko, indupapi Goteme emba dyaapomona lao nambame masilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dopa leamopa Jisasame baa lamaiyoo, “Embanya pimalenge doko malunya sakatalapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dokopa Matame baa lamaiyoo, “Yuu etata gii dokopa, endakali kumapae dupa sakatataminopa, baa apata sakatatana lao nambame masilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dokopa Jisasame baa lamaiyoo, “Endakali kumapae dupa sakatasingi doko namba. Endakali dupa lete katasingi doko nambaka. Endakali mendeme namba tungi pyatamo doko, baa kumapalapi lete katata. ");
INSERT INTO enq2_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Namba tungi pyao katatami endakali dupa pitaka kumala naeyao kataowaka katatami. Embame pii doko kiningina lao masilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dokopa Matame Jisasa lamaiyoo, “Kiningi, Kamongo emba Gote Ikiningi, isa yuu dakenya akali ipatana latae Kraisa dokona lao nambame masilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","30","Matame pii dutupa latala andaka peamopa, Jisasa baa yuu yakane Betani dokonya apata paa naenya, Matame baa kandanyia panda dosa katao kaeya. Dokopa Matame baanya kakingi Maria epena latala elyakalao lamaiyoo, “Mana Lenge doko ae ipupala, emba ipu lelyamona” lea. Dokopa Mariame pii doko sepala, baa yapa sakatao Jisasa katea dokonya pea. ");
INSERT INTO enq2_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dokopa Juu mendapu Maria-pipa kumanda peteami dupame kandeaminopa, Maria baa yapa sakatatala kamaka peanya watao pao pituu, “Baa malunya ee laa pelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dokopa Maria baa Jisasa katea dokonya ipupala Jisasa kandea. Kandatala Jisasanya moko katea dosa pao luma lakapala baa lamaiyoo, “Kamongo, emba ae kateeli doko, nambanya pimalenge doko kumala naeyalina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Dopa latala Maria baa ee leamopa, baa-pipa epeami Juu dupa apata eaka leami. Jisasame ee leami dokaita kandatala, baa mona etete kenda kaeyapala, masepae longo nyia. ");
INSERT INTO enq2_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nyepala Jisasame lao pituu, “Nyakamame Lasarusa anja malu piamipi?” lea. Dopa leamopa dokaitame yanu pyao, “Kamongo, embame kanja ipu” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dopa leaminopa Jisasa baa ee lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ee leamosa Juu dupame lao pituu, “Akali doko baame etete auu kaenge-lamo kanjepa” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dopa leaminopa yangi dupame lao pituu, “Lenge monda mende lenge auu pyoo tena leamo akali dokome akali dake kumala naena lao nisala naeyapyalipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dopa leaminopa, Jisasa dee mona etete kenda kaeyapala, malu dokonya pea. (Malu doko kananda mendenya petala, kambu doko kana yale mendeme piti petae katea.) ");
INSERT INTO enq2_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dokopa Jisasame lao pituu, “Nyakamame kana doko nyoo kapya lapa” lea. Dopa leamopa, akali kumapae dokonya pimalenge Matame baa lamaiyoo, “Kamongo, baanya yonge doko malu petae katamupa yuu gii kitomende patapyana, indupa baanya yonge doko ai koeyapae pyalapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dokopa Jisasame baa lamaiyoo, “Embame namba tungi pyateno doko, Gotenya tii pipae doko kanjapenona lao nambame emba langya naeyalope?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dopa lateamopa, malu dokonya kambu piti piami kana doko nyoo kapya leami. Dopa peteaminopa, Jisasame kaiti-kisa kandalyetae katao lao pituu, “Apane, nambame loma silyo doko embame sekelyeno dokonya, nambame emba yaka pilyino lelyo. ");
INSERT INTO enq2_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nambanya loma silyo dupa embame koteaka lao sekengena lao nambame masilyo. Dopaka doko, embame namba puu lea-lamo lao endakali asa kalyamino dupame masina latala nambame dopa lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Dopa latala baame puu lao, lao pituu, “Lasarusa, emba kamaka pyakalya!” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dopa lateamopa akali kumapae doko kamaka pyakalyia. Baanya kingi mokopi dupa lapalapa kende yakane londe mendeme yaki piamili petae kateamopa, lapalapa kepapae mendeme lenge-lyaapi dolapo ambo piamili petae doko kamaka pyakalyia. Dopa piamopa Jisasame endakali dokaita lamaiyoo, “Baa pena, yaki dupa tata lao nepakamaiyepa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jisasame Lasarusa sakatasiamo kandatala, Maria kanja epeami Juu longo dupame Jisasa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dopaka doko, yangi Parasi dupa kateami dokonya pupala, Jisasame pia dupa lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Dokopa prisa mupapi, Parasipi dupame kanjole dupa nyoo kambu pyatala lamaiyoo, “Akali dokome mirakolo longo pilyamo dokonya, naimame aipa pima? ");
INSERT INTO enq2_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Baame dopaka pyoo katena kaeyatamano doko, endakali pitakame baa tungi pyalamino. Dopa pitaminopa, Roma tange amii dupa ipupala, naimanya panda dake kaluu nepao, naima tata dupa pyao koeyasoo pitamina” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dokopa akali dupanya mende, Kaeyapasa lenge doko, ee kana dokonya prisa mupa katea dokome dokaita lamaiyoo, “Nyakamame kukipi mende masala naelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Naima tata dupa pitaka kumala naena lao, akali mendai mendeme naimanya panda nyoo kumatamo dokome naima nisetana lao nyakamame masala naelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Pii doko baa tangeme masoo nalea. Baa ee kana dokonya prisa mupa katea dokomena, Juu tata dupa pitakanya panda nyoo Jisasa kumatana lao propesi pii lea.) ");
INSERT INTO enq2_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pii lea doko, Jisasa kumata dokome Juu tata dupa iki nisetana lao nalea. Baa kumata dokome Gotenya wane yuu waka dupanya katenge dupa nyoo pyasoo, kambu mendai jina latana lao lea. ");
INSERT INTO enq2_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaeyapasame lea gii dokonya pituu, kanjole dupame Jisasa pyao kumasemana lao kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dopa piaminosa, Jisasa baa Juu dupanya kainanya dee panao napaeya. Baa yuu doko yakinatala, taono Epraimi lenge mende, endakali napalenge yuu mendepa makisa singi dokonya baanya disaipolo dupa-pipa pupala kateami. ");
INSERT INTO enq2_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dokopa Juumanya Pasopa nee nenge gii doko tengesa piamopa, yuu yakane dupanya katao endakali longo kuni nasina lao pyoo wasalanya lalyoo Jerusalema peami. ");
INSERT INTO enq2_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pupala dupame Jisasa kutiami. Kutapala lotuu anda nee nyetae kamapu dokonya katao nyakama-lapo laloo pyoo, “Nyakamame aipa lao masilyami? Baa nee andake dakenya nala naipapepe?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","(Endakali mendeme Jisasa dosa kalyamo lao kandea-kandeno doko, baa anjemana langina lao prisa mupapi, Parasipi dupame kyeto joo wamba lateami.) ");
INSERT INTO enq2_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasopa gii doko ipanya, yuu gii tokange siamopa, akali malunya sakatasia Lasarusa doko katenge, yuu Betani dokonya Jisasa pea. ");
INSERT INTO enq2_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dokonya pateamopa endakali dupame Jisasanya nee yangakamaiyami. Matame nee dupa mokosiamopa, Jisasa-pipa nee nalanya peteami endakali dupanya Lasarusa baa apata peteami. ");
INSERT INTO enq2_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Peteaminopa, wele natame iki wasepae, tunduma pipaeme tumbatae, muni andake pupenge mende Mariame nyoo epea. Ipupala Jisasanya moko kai pyakamaiyamopa, wele dokonya tunduma epe dokome anda doko tumbia. Dokopa baanya aiyomba itimi Jisasanya moko tombe lea dupa kunao nepakamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dopa piamopa, Jisasanya disaipolo dupanya mende, Judasa Iskariota lenge, Jisasa anjoo yandapipi dupanya kinginya maitoo lao masia dokome lao pituu, ");
INSERT INTO enq2_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Wele dake salimi lao silipa muni 300 nyepala, endakali daa jepae dupa aipuma maiya naelyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Baame lea doko, endakali daa jepae dupa nee kaeyapala laa naeya. Baame muni bokosa doko isingi dokonyana, dupanya mendapu waa katao pake nyingi dokome dopa lea. ");
INSERT INTO enq2_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dokopa Jisasame lao pituu, “Enda dakeme weleme namba kai pyekelyamo dokome, namba malu pitami gii doko depa lao wele dake setao peteana, pina kaeyalapa. ");
INSERT INTO enq2_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Endakali daa jepae dupa koteaka lao nyakama-pipa katatami. Dopaka doko, namba nyakama-pipa gii longo mende kalya naeyalamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisasa Betani kalyamona lao masetala, Juu endakali kambu andake mendeme kanja epeami. Dokaitame Jisasa iki kanja ipa naeyami. Malunya sakatasia Lasarusa doko apataka kanja epeami. ");
INSERT INTO enq2_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jisasame Lasarusa malunya sakatasiamo doko kandatala, Juu longome prisa mupa dupa yakinatala Jisasa tungi piami. Dopa piaminosa, prisa mupa dupame Lasarusa apata pyao kumasemana lao kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yuu gii mende dokonya, nee andake nenge gii doko kanjanya, endakali longo ipao kambu pyao Jerusalema kateami dupame Jisasa baa epelyamo leamino siami. ");
INSERT INTO enq2_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sepala dokaitame pame yoko dupa nyoo minao, Jisasa kaitinisa kandanyemana lao peami. Pao pituu dokaitame puu lao, lao pituu, “Gote mambo pilyamano! Israelemanya kiŋi, Kamongonya kengenya epelyamo dake Goteme auu pisetaena” leami. ");
INSERT INTO enq2_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Pii pepa pyapae singi dokonya dapa lapae singi: “Nyakama Saeyone wanenge dupanya kiŋi doko dongi ŋaŋa mendenya pituu epelyamona, nyakama paka nakaeyao kanjepape” lapae singi. Dopa lapae singili pyoo, Jisasame dongi ŋaŋa mende nyepala, dokonya baa pituu pea. ");
INSERT INTO enq2_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dopa pitana lao pepa pyapae singi doko gii dokopa Jisasanya disaipolo dupame masala naeyami. Dopaka doko, maitakao Jisasa kenge andake nyepeamopa, baame pia dupa pitaka pitana lao pepa pyapae singili pyoo pia-lamo lao masiami. ");
INSERT INTO enq2_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisasame Lasarusa kamaka pyakalyina latala, baa malunya sakatasiamopa kandao kambu pyao kateami endakali longo dupame Jisasame pia doko lao taeyama peami. ");
INSERT INTO enq2_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jisasame mirakolo doko piana lao, lao taeyaminopa, endakali longome sepala, baa kandanyalanya kambu pyao peami. ");
INSERT INTO enq2_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dokopa Parasi dupame nyakama-lapo laloo pyoo, “Isa yuu dakenya endakali dupa pitakame baa watao pelyamino kanjepa. Naimame baa yanda pimaiyoo kalai pilyamano dupa dii namandelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nee andake nenge gii dokonya, endakali Gote mambo pyalanya lalyoo Jerusalema peami dokonya, Giriki mendapu apata peamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yuu Galali dokonya taono Betsaida tange akali Pilipa doko katea dokonya Giriki dokaita ipupala baa lamaiyoo, “Kaimii, naimame Jisasa kandamu laka lao masilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dopa leaminopa, Pilipa pupala Andru lamaiya. Dokopa Andruapa, Pilipapa dolapo lapotame Jisasa lamaiyambi. ");
INSERT INTO enq2_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Lamaiyambinopa Jisasame dolapo lamaiyoo, “Akalinya Ikiningi doko kenge andake nyepenge gii doko ipatelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nambame nyakamba etete kiningi langilyo: Wita dii mende isa yuunya kopo latala kumilya dokome langa latala dii longo mandenge. Dopaka doko, wita dii mende isa yuunya kopo latala kumala naelya doko dii mendai dokoaka iki singi. ");
INSERT INTO enq2_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dopana, endakali mendeme baanya lete katenge doko auu kaeyatamo dokome, baanya lete katenge doko yakinata. Dopaka doko, endakali mendeme isa yuu dakenya lete katenge doko maka kaeyatamo dokome, baanya lete etete katenge doko nyeta. ");
INSERT INTO enq2_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Endakali mendeme namba masetala, nambanya kalai pyakatoo lao masetamo dokome namba watao ipupenge. Dokopa namba katato dokonya nambanya kalai akali doko nambapa tole katatamba. Endakali mendeme nambanya kalai pyakatamo doko, Takange dokome baa kenge andake maitana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Indupa nambanya mona etete kenda pyumuna, nambame aipa lao? ‘Apane, namba-kisa kenda epelyamo dake embame nyoo nepakape’ laowape? Daa, nambame kenda dake nyoo salanya epeo. ");
INSERT INTO enq2_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dopana, Apane, emba tange kenge andake nyepe” lea. Dopa lateamopa pii mende kaiti-kisa katao lea dokome lao pituu, “Namba kenge andake nyepeona, deaka namba kenge andake nyalapona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pii doko endakali kambu dokome sepala, kaiti toka lalumuna leami. Dopa leaminopa yangi dupame lao pituu, “Enjele mendeme baa pii lamaiyumuna” leami. ");
INSERT INTO enq2_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dopa leaminopa Jisasame lao pituu, “Pii lelyamo doko, nambame satale lao nalelyamo. Nyakamame salapale lao lelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Isa yuu dakenya endakali dupa yapapenge gii doko indupa palipilyamo. Isa yuu dake isingi doko kamaka watao pyasepenge gii doko indupa palipilyamoaka. ");
INSERT INTO enq2_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Isa yuu dakenya katao namba minalyetaminopa, endakali dupa pitaka namba katato dokonya epena lao lanyotona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Baame lea doko, baa dopa pyoo kumata doko makande pyoo lea.) ");
INSERT INTO enq2_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dopa lateamopa endakali kambu dokome baa lamaiyoo, “Kraisa doko tanga-tangapi kataowaka katatana lao Mosesanya loo dupanya lapae singi doko naimame siama. Dopana, ‘Akalinya Ikiningi doko endakali dupame minalyepengena’ lelyeno doko embame aipa pyoo lelye? Akalinya Ikiningi doko apipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dopa leaminopa Jisasame dokaita lamaiyoo, “Tii pipae doko nyakama-pipa gii kuki mendatupa iki kalyaminona, iminjingi dokome nyakama ita minatana, tii pipae doko nyakama-pipa kalyamino dokopa, tii pipae dokonya paeyalapape. Endakali mende iminjetaenya paelya dokome, baa anja pelyope lao nakandenge. ");
INSERT INTO enq2_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nyakama tii pipae dokonya ikiningi katamana lao, tii pipae doko nyakama-pipa kalyamino dokopa baa tungi pyalapape” lea. Jisasame pii dutupa lao etapala, baame dokaita yakinao pupala, yalo pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Endakali dupanya enombanya Jisasame mirakolo longo mendapu piaka doko, dupame baa tungi napiami. ");
INSERT INTO enq2_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Propeta Aisaiyame lao pituu, “Kamongo, naimame pii lamaiyamano doko sepala apimi kiningi-lumuna lao masia? Kamongonya kyeto dokome panao kalai piamo dupa kandatala, apimi Goteme pyome-lamo lao kandeape?” lapae singi doko tungi napiami dokome angi jia. ");
INSERT INTO enq2_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Aisaiyame pii mende apata dapa lea-pyaa: “Endakali dokaitame lengeme kandata, moname maseta petala, mona kapilyetaminopa, Goteme dokaita auu pisotone-latala, dokaitanya lenge dupa iminjetala, dokaitanya mona dupa kana jisiana” lapae silyamo. Tenge dokonya, endakali dupame Jisasa tungi pyapenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiyame wamba-waka Kraisanya tii pipae doko kandatala, baa lao lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Endakali mendapuame Jisasa tungi napiamiaka doko, endakali longome Jisasa tungi piami. Juumanya isingi akali longome apata baa tungi piamiaka. Tungi piamiaka doko, Parasi dupame lotuu anda dupanya dokaita watao pyatamini-latala, Jisasa tungi pilyamanona lao, lao panala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tenge doko, Goteme dokaita lalyina lao masala naenya, endakalimi dokaita lalyina lao masiami. ");
INSERT INTO enq2_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisasame puu lao dapa lea: “Namba tungi pilya endakali dokome namba iki tungi pyala naenge. Namba puu lea Akali doko apata tungi pilyamosaka pingi. ");
INSERT INTO enq2_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Namba kandelya endakali dokome, namba puu lea Akali doko apata kandelyamosaka pingi. ");
INSERT INTO enq2_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Namba tungi pingima endakali dupa iminjetaenya nakatena lao, tii pisingi akali doko namba isa yuu dakenya epeo. ");
INSERT INTO enq2_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Namba isa yuu dakenya epeo doko, endakali dupa yapalanya naepeo. Nambame endakali dupa pyoo nyalanya epeo. Tenge dokonya, endakali mendeme nambanya pii dupa sepala wata-minala naeyatamo doko, nambame baa yapala naeyatoaka. ");
INSERT INTO enq2_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Endakali mendeme namba maita ditala, nambanya pii dupa auu kaeyao nasetamo doko, yuu etatamo gii dokopa, nambame pii lamaipu dupameaka baa yapata. ");
INSERT INTO enq2_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nambame pii lelyo dupa nambame masoo laa naelyo. Nambame pii lelyo dupa dopa pyoo lape lao namba puu lea Takange dokome leali pyoo nambame lelyo. ");
INSERT INTO enq2_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nambame pii lape lea dupame lete etete katasingina lao nambame masilyo. Dokonya nambame pii lelyo dupa nambanya Takange dokome namba langiali pyoo lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasopa nee andake nenge gii doko ipanya tengesa piamopa, isa yuu dake yakinatala Takange katenge dokonya pupenge gii doko ipatelyamona lao Jisasame masia. Dopa lao masetala, isa yuu dakenya tange, endakali Jisasanya latae dupa auu kaeya doko auu kaeyataeyaka katao pao baa kumia. ");
INSERT INTO enq2_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Alemandi nee nao peteaminopa, Saimone Iskariota ikiningi Judasa dokome yandapipi dupanya kinginya Jisasa maina lao, Sataneme baanya mona lungu petea. ");
INSERT INTO enq2_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Takangeme dupa pitaka baanya kinginya yakineana lao Jisasame masia. Baa Gote-kisa katao epeona, Gote katenge dokonya pilyotona lao masiaka. ");
INSERT INTO enq2_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dopa lao masetala, Jisasa nee nao pituu sakatatala, baanya yonge pee kisa pingi dupa lyokanya setea. Dopa petala baame tauwele mende nyepala matapu pia. ");
INSERT INTO enq2_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Petala baame endaki kai lao disa mendenya pisetala, tee pyao baanya disaipolo dupanya moko wasa pyatapu, tauwele matapu pia dokome kunao nepata pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dopa pyoo pao Saimone Pita petea dokonya pyakameamopa, Pitame baa lamaiyoo, “Kamongo, embame nambanya moko wasa pyakalanya pilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Nambame pilyo dake indupa embame masala naelyeno. Dopaka doko, tanga embame masetena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dokopa Pitame baa lamaiyoo, “Embame nambanya moko wasa napyakapengena, tanga-tangapi napyakatena” lea. Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Nambame embanya moko wasa napyakato doko, emba nambanya daana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dokopa Saimone Pitame baa lamaiyoo, “Kamongo, dopa-tamo doko, embame nambanya moko iki wasa pyakala naenya, kingipi aiyombapi dupa apata wasa pyaka” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dopa leamopa Jisasame baa lamaiyoo, “Endakali mende yonge pitaka wasa pyatae doko-kisa kuni nasingi dokonya, baa moko iki wasa pyapenge. Nyakama wasa pyatae kalyaminoaka doko, nyakama pitaka daana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","“Nyakama pitaka daana” lea doko, baa yandapipi dupanya kinginya maipenge akali doko, dokona lao masetala lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisasame baanya disaipolo dupanya moko wasa pyakamaiyoo etapala, baanya yonge pee kisa pingi dupa nyoo petala, baa isa petea. Isa pitipala baame dokaita lamaiyoo, “Nambame nyakamanya pyakalo dokonya tenge doko nyakamame masilyamipi? ");
INSERT INTO enq2_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyakamame namba Mana Lenge lata, Kamongo lata pilyamino doko namba dokoakana, nyakamame tolao lelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Namba nyakamanya Kamongo, Mana Lenge dokome nyakamanya moko wasa pyakato doko, nyakamame dopaka pyoo nyakama-lapo mendenya moko wasa pyaa-pyaa pyoo katapenge. ");
INSERT INTO enq2_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nyakamame mana mendai dokoaka minao katataminopa lao, nambame nyakamanya pyakalo dokome makande mende setao pyakalo. ");
INSERT INTO enq2_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nambame nyakama etete kiningi langilyo: Kalai akali mendeme baanya isingi akali doko ita naminingi. Wai minao penge endakali mendeme wai minao pena lenge endakali doko ita naminingiaka. ");
INSERT INTO enq2_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nambame pii langilyo dupa nyepala, nyakamame dopaka pyoo katatamino doko, Goteme nyakama auu piseta. ");
INSERT INTO enq2_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nambame pii lelyo doko nyakama pitaka lao laa naelyo. Nambame endakali yapao nyio dupa nambame masilyo. Dopaka doko, Gotenya pii pepa pyapae singi dokonya, ‘Namba-pipa breta nao peteambano dokome namba pyalanya baanya moko sandange minalyiana’ lapae singi doko angi jina lao lelyo. ");
INSERT INTO enq2_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Pii dutupa angi jetamopa, nyakamame namba akali doko-lamo lao masalapale lao, pii dutupa angi jala naeyamupa wambao nambame pii dutupa nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nambame nyakama etete kiningi langilyo: Nambame pena lelyo endakali dupa auu kaeyao lanyilya endakali dokome namba lanyilyamosaka pingi. Namba auu kaeyao lanyilya endakali dokome namba puu lea Akali doko lanyilyamosaka pingina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisasame pii dutupa latala, baa mona kenda kaeyapae etete andake mende nyepala lao panao, “Nambame nyakama etete kiningi langilyo: Nyakamanya mendeme namba yandapipi dupanya kinginya maiyapomona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dopa lateamopa, disaipolo dupame nyakamanya mende doko api lao lelyape lao tatake kaeyapala, mende kanda-kanda piami. ");
INSERT INTO enq2_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Dopa piaminopa Jisasanya disaipolo dupanya mende, baanya mona setenge doko, baa-kisa semai latae petea. ");
INSERT INTO enq2_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Peteamopa Saimone Pitame doko api lao lelyape lao, semai latae petea akali dokome tipa pina lao aiyombame makande pia. ");
INSERT INTO enq2_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dokopa Jisasa-kisa semai latae petea akali dokome Jisasa lamaiyoo, “Kamongo, doko apipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Dopa leamopa Jisasame yanu pyao, “Breta konjepae mende disanya supu silyamo dokonya poeyanyetala nambame maiyapo akali dokona” lea. Dopa latala baame breta konjepae mende disanya supu sia dokonya poeyanyetala, Saimone ikiningi Judasa Iskariota doko maiya. ");
INSERT INTO enq2_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dokopa Judasame breta konjepae doko nyiamopa, Satane baa-kisa landa pia. Dopa peteamopa Jisasame baa lamaiyoo, “Embame pyaanya pilyino doko yapa pii” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jisasame dopa lao Judasa lamaiya doko, nee nao peteami akali dupanya mendaipi mendeme aipa lao lelyape lao masala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judasame muni bokosa doko isingi dokonyana, nee andake napenge dokonya nee daa jeta mendapu sambala pena lelyape, pande endakali daa jepae dupa nisoo oapi mendapu maiya pena lelyape lao yangi dupame masiami. ");
INSERT INTO enq2_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Dopa lao masiaminopa, breta konjepae doko Judasame nyepala, yapa kamaka kolalyia. Yuu kuiyetae kateamopa baa kamaka kolalyia. ");
INSERT INTO enq2_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judasa kamaka kolalyeteamopa Jisasame lao pituu, “Indupa Akalinya Ikiningi doko kenge andake nyepelyamo. Akalinya Ikiningi doko-kisa Gote kenge andake nyepelyamoaka. ");
INSERT INTO enq2_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Akalinya Ikiningi doko-kisa Gote kenge andake nyepelyamo dokonya, Akalinya Ikiningi doko Gote-kisa katatamopa, Goteme baa indupaka kenge andake maiyapomo. ");
INSERT INTO enq2_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wane paluma, namba gii kuki mendatupa iki nyakama-pipa tole kalyamano. Namba patatopa nyakamame namba kutatamiaka doko, namba pelyo dokonya nyakama kapa pao naipatamina lao nambame Juu dupa lamaiyoliaka pyoo indupa nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mana enenge mende nambame nyakamanya setekelyo doko dake: Nyakama-lapo mende auu kae-kae pyoo kalyepape. Nambame nyakama auu kaelyoli pyoo, nyakama-lapo mende auu kae-kae pyoo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nyakama-lapo mende auu kae-kae pyoo katatamino doko, nyakama nambanya disaipolo-lamo lao endakali dupa pitakame masetamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dokopa Saimone Pitame Jisasa lamaiyoo, “Kamongo, emba anja pelyepe?” lea. Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Namba pelyo dokonya indupa embame kapa pao namba watao naipapeno. Dopaka doko, tanga embame namba watao ipatena” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dopa leamopa Pitame baa lamaiyoo, “Kamongo, aipuma indupa nambame kapa pao emba watao naipapo? Emba kumapenge dokonya namba alo pyoo kumatoana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Namba kumapenge dokonya kiningi emba alo pyoo kumatepe? Nambame emba etete kiningi langilyo: Yaka pauli pii laa naeyatamopa, paa tepomasa embame namba nakandengena laapenona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisasame lao pituu, “Nyakama mona kenda nakaeyalapape. Nyakamame Gote tungi pyalapape. Nyakamame namba tungi pyalapapeaka. ");
INSERT INTO enq2_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nambanya Takangenya anda dokonya ruma longo katengena, nambame nyakamanya panda depa lakala pelyo. Ruma longo nakatenge-pyali doko, ruma longo nakatengena lao nambame nyakama langipuli. ");
INSERT INTO enq2_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nambame nyakamanya panda mende depa lakala pelyo. Depa latakala namba katato dokonya nyakama apata katatamanopa lao lanyala ipato. ");
INSERT INTO enq2_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Namba pelyo panda dokopa, kaitini dokopa, dolapo nyakamame masilyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dopa leamopa Tomasame baa lamaiyoo, “Kamongo, emba anja pelyepe lao masala naelyamano dokonya, naimame aipa petala kaitini doko, dokona lao masetamape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dokopa Jisasame baa lamaiyoo, “Kaitini dokopi, kiningi pii dokopi, lete katenge dokopi, dutupa namba. Takange doko katenge dokonya paanya kaitini waka mendenya-kaita napenge. Namba-kisa iki penge. ");
INSERT INTO enq2_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nyakamame namba akali doko-lamo lao masimili doko, nyakamame nambanya Takange doko apata dokona lao masimiliaka. Indupa pituu nyakamame Takange doko kandatala baa doko-lamo lao masilyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dopa leamopa Pilipame baa lamaiyoo, “Kamongo, embame Takange doko naima laitaka pii. Laitaka pitino doko yakana lao naimame masalamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dokopa Jisasame Pilipa lamaiyoo, “Pilipa, namba nyakama-pipa gii longo-waka katamano doko, embame namba masala naelyepe? Namba akali doko-lamo lao kandelya endakali dokome Takange doko apata kandengeaka. Dopa pingina, embame aipa pyoo Takange doko laitaka pii lelye? ");
INSERT INTO enq2_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Takange doko nambanya mona andaka kalyamopa, namba Takange dokonya mona andaka katenge doko kiningina lao embame masala naelyepe? Nambame nyakama pii langilyo dupa, namba tangeme masoo langya naelyo. Nambanya mona andaka katenge Takange dokome baanya kalai dupa pilyamo. ");
INSERT INTO enq2_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Namba Takange dokonya mona andaka kalyopa, Takange doko nambanya mona andaka katengena lelyo doko, nyakamame kiningina lao masalapape. Daa-tamo doko, nambame kalai pilyo dupa kandatala, nambame pii lelyo dupa kiningina lao masalapape. ");
INSERT INTO enq2_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nambame nyakama etete kiningi langilyo: Nambame kalai pilyo dupa pitaka namba tungi pyatami endakali dupame pitami. Nambanya Takange doko katenge dokonya namba pelyo dokome, kalai pipupa kandamino dupa ita minao, nyakamame kalai etete andakele mendapu pitami. ");
INSERT INTO enq2_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nyakamame nambanya kenge dokonya mende pyaka lao tee latamino doko, Takange doko Ikiningi doko-kisa kenge andake nyina lao nambame pyakato. ");
INSERT INTO enq2_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dopana, nyakamame nambanya kenge dokonya mende pyaka lao tee latamino doko nambame pyakatona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nyakamame namba auu kaeyatamino doko, nambanya mana setapae dupa wata-minalapape. ");
INSERT INTO enq2_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dokopa nambame Takange doko-kisa tee lakatopa, baame nyakama Nisepenge mende nyakama-pipa kataowaka katataminopa lao dita. ");
INSERT INTO enq2_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nisepenge mende dita doko, kiningi pii lenge Spirita doko. Isa yuu dakenya endakali dupame Spirita doko kanja naeyao, masala naeyaowaka pingima dokonya, dupame Spirita doko kapa pao nyala naengema. Dopaka doko, Spirita doko nyakamanya mona andaka kalyamo doko, tangapi mona andaka kataowaka katata dokonya, nyakamame Spirita doko masingima. ");
INSERT INTO enq2_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nambame nyakama muiyene joo kalyepale lao yakinala naeyato. Namba nyakama katatami dokonya pilyoto. ");
INSERT INTO enq2_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Gii kuki mendatupa patatamopa, isa yuu dakenya endakali dupame namba kanja naeyalamino. Dopaka doko, nyakamame namba kanjamino. Namba lete katenge dokonya nyakama apata leteaka katatami. ");
INSERT INTO enq2_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gii dokopa, namba Takange dokonya mona andaka katenge-lamo lao nyakamame kandatami. Namba nyakamanya mona andaka kalyopa, nyakama nambanya mona andaka katenge-lamo lao kandatamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nambanya mana setapae dupa nyepala wata-minilya endakali dokome namba auu kaenge. Namba auu kaeyata endakali doko, nambanya Takange dokome baa auwaka kaeyata. Nambame baa auwaka kaeyapala, namba dopale-lamo lao baame kandena lao panasotona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dopa lateamopa Judasa Iskariotame daa, Judasa mende dokome Jisasa lamaiyoo, “Kamongo, embame aipuma naimame iki emba dopale-lamo lao kanjepale lao panasetala, isa yuu dakenya endakali dupame kandena lao panasala naeyatepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Namba auu kaeyata endakali dokome nambanya pii dupa wata-minata. Dopa pitamopa nambanya Takange dokome baa auu kaeyata. Dokopa nambanya Takange dokopa nalimba ipupala baanya mona andaka katatamba. ");
INSERT INTO enq2_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Namba auu nakaenge endakali dokome nambanya pii dupa wata-minala naenge. Nyakamame pii silyamino dupa nambanya pii daa, nambanya Takange namba puu lea dokonya. ");
INSERT INTO enq2_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Namba nyakama-pipa apata kalyamano dakepa, nambame pii datupa nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dopaka doko, nyakama Nisepenge Oli Spirita doko Takange dokome nambanya kengenya epena lata. Oli Spiritame dupa pitaka nyakama mana langyoo, pii langilyo dupa pitaka masalapale lao nyakamanya masingi tii pisakata. ");
INSERT INTO enq2_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nambanya mona yaepenge doko nyakama-kisa yakinelyo. Mona yaepenge nyakama dilyo doko isa yuu dakenya endakali dupame maingimali pyoo nandilyona, nyakama mona etete kenda kaeyao paka nakaeyalapape. ");
INSERT INTO enq2_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Nambame nyakama yakinatala pelyo. Pupala nyakama katatami dokonya pilyotona’ lapu doko nyakamame simi. Nyakamame kiningi namba auu kaengema-pyali doko, ‘Namba Takange kalyamo dokonya pelyona’ lapu doko sepala, nyakama eteke pyamili. Aipumape, nambanya Takange dokome namba ita miningi. ");
INSERT INTO enq2_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dutupa ene pyaanya pimupa wambao nambame nyakama langilyo. Dutupa pitamopa nyakamame kandatala namba tungi pyatami. ");
INSERT INTO enq2_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Isa yuu dakenya isingi akali doko epelyamo dokonya, namba gii longo nyakama-pipa pii lao kalya naeyalamano. Dopaka doko, baanya pupu lapae dokome namba ita minala naeyalapomo. ");
INSERT INTO enq2_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nambame Takange doko auu kaenge-lamo lao isa yuu dakenya endakali dupame kandena lao, Takange dokome lelyamoli pyoo nambame pingi. Dopana, naima panda dake yakinatala mona sakatalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisasame lao pituu, “Waene itange angi doko namba. Waene ee pokenge doko nambanya Takange doko. ");
INSERT INTO enq2_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Namba-kisa katao dii namandenge wangya dupa baame kepao nepata, dii mandenge wangya dupa auu pyoo dii longo mandena lao waseta pingi. ");
INSERT INTO enq2_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nambame pii langipu dupame nyakama wasoo auu pisetelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Itange-kisa nakatenge wangya dupame dii namandengema. Dopaka pyoo, nyakama nambanya mona andaka nakatatamino doko, nyakamame dii namanditamiaka. Dopana, nyakama nambanya mona andaka kalyepape. Dokopa namba nyakamanya mona andaka katato. ");
INSERT INTO enq2_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Waene itange doko namba. Wangya dupa nyakama. Nyakama nambanya mona andaka nakatatamino doko, nyakamame kapa pao mende napitami. Tenge dokonya, endakali mende nambanya mona andaka katatamo doko, namba baanya mona andaka katatopa, baame dii longo mandita. ");
INSERT INTO enq2_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Endakali mende namba-kisa nakatatamo doko, wangya kepao nepatae dupa sapuingili pyoo, baa saputa. Wangya sapupae dupa nyoo kambu pyatala itatenya tena lao yangengeli pyoo baa yangata. ");
INSERT INTO enq2_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nyakama nambanya mona andaka katatamino doko, nambanya pii dupa nyakamanya mona andaka seta. Dokopa nyakamanya mende pyekena lao Gote tee lataminopa baame latamiliaka pyakata. ");
INSERT INTO enq2_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nyakama dii longo mandyoo nambanya disaipolo katataminopa, nambanya Takange doko kenge andake nyeta. ");
INSERT INTO enq2_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nambanya Takange dokome namba auu kaengeli pyoo, nambame nyakama auu kaelyo. Dopana, nyakama nambanya auu kaenge dokonya kalyepape. ");
INSERT INTO enq2_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nambanya Takangenya mana setapae dupa wata-minao, baanya auu kaenge dokonya namba katenge. Dopa pingina, nyakamame nambanya mana setapae dupa wata-minao katatamino doko, nyakama nambanya auu kaenge dokonya katatami. ");
INSERT INTO enq2_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nambanya auu kaenge doko nyakama-kisa setamopa, nyakama etete eteke pyao kalyepale lao pii dutupa langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Nambanya mana setelyo doko dake: Nambame nyakama auu kaelyoli pyoo nyakama-lapo mende auu kae-kae pyoo kalyepape. ");
INSERT INTO enq2_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Endakali mendeme baanya kaita miningi dupa auu kaeyapala, dupanya panda nyoo baa kumilyamo dokome, auu kaenge mana waka dupa pitaka ita miningi. ");
INSERT INTO enq2_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dopana, nyakamame pyepale lao nambame mana setelyo dupa pitaka pyoo katatamino doko, nyakama nambanya kaita miningi katatami. ");
INSERT INTO enq2_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Akali andake mendeme kalai pilya dupa baanya kalai akali dokome kanja naenge. Dopaka doko, nambanya Takangeme namba pii langiamopa sio dupa pitaka panao nyakama langitio. Dopa pio dokonya, indupa nyakama nambanya kalai akali kalyaminona nalelyo. Nyakama nambanya kaita miningi kalyaminona lelyo. ");
INSERT INTO enq2_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nyakamame namba yapao nanyiami. Nyakama pupala dii koeyala naenge dupa manditaminopa lao nambame nyakama yapao nyepala makande leo. Takange doko-kisa nambanya kenge dokonya dopale mende nyakamame tee latami doko baame ditamopa lao nambame nyakama makande leo. ");
INSERT INTO enq2_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dopana, nyakama-lapo mende auu kae-kae pyoo kalyepale lao nambame mana datupa setelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Isa yuu dakenya endakali dupame nyakama imbu kaeyami-kandeno dokopa, dupame wamba namba imbu kaeyamiakana lao nyakamame masalapape. ");
INSERT INTO enq2_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nyakama isa yuu dakenya endakali-pyali doko, isa yuu dakenya endakali dupame nyakamanya tata-lamona lao masetala nyakama auu kaeyamili. Dopaka doko, nyakama isa yuu dakenya endakali daa. Nambame nyakama isa yuu dakenya-tae yapao nyio dokonyana, isa yuu dakenya endakali dupame nyakama imbu kaengema. ");
INSERT INTO enq2_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Kalai akali mendeme baanya akali andake doko ita naminingina’ lao nambame nyakama langyo doko nyakamame masalapape. Namba tanda dyoo koeyasingima endakali dupame nyakama apata tanda dyoo koeyasetamiaka. Nambanya pii dupa wata-miningima endakali dupame nyakamanya pii dupa apata wata-minatamiaka. ");
INSERT INTO enq2_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dopaka doko, namba puu lea Akali doko dokaitame nakandengema dokonyana, nyakama namba tata-lamo lao kandatala, nyakama-kisa mana koo dopale dupa minatami. ");
INSERT INTO enq2_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Namba ipupala dokaita pii lamaiya naeyoli doko, dokaita-kisa koo mende nasipyali. Dopaka doko, dokaitame masala naeyao koo piamana latamino doko kapa napata. ");
INSERT INTO enq2_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Namba imbu kaengema endakali dupame nambanya Takange doko apata imbuaka kaengema. ");
INSERT INTO enq2_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Endakali waka mendeme kalai kapa napipenge dupa nambame dokaitanya kainanya napioli doko, dokaita-kisa koo mende nasipyali. Dopaka doko, indupa dokaitame mirakolo dupa kandatala, nambapa, nambanya Takangepa, nalimba imbu kaelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘Namba-kisa tenge mende nasiamopa, mee imbu kaeyamina’ lao dokaitanya loo dupanya pepa pyapae singi doko angi jina lao nalimba imbu kaelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nyakama nisepenge, kiningi pii lenge, Takange-kisa katao pyakalyingi Spirita doko, Takange-kisa katao epena latopa ipupala, namba akali dokona lao, lao panata. ");
INSERT INTO enq2_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nambame kalai tee pyao pio gii dokonya pituu, indupa tuu lao, nyakama namba-pipa kalyamano. Tenge dokonya, namba akali dokona lao nyakamame lao panatamiakana” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisasame lao pituu, “Nyakama isa pyakala naeyalapale lao nambame pii dutupa langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","3","Endakali dupame nambapa, nambanya Takangepa, nalimba nakandengema dokonyana, dokaitame lotuu anda dupanya nyakama watao pyatami. Yangimi nyakama pyao kumasetala, Gote kundi maiyoo kalai epe mende pilyamanona lao masetami. Dopa pitami gii doko ene epelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tee pyao namba nyakama-pipa kateamano dokonya, pii langilyo datupa nambame nyakama langya naeyo. Dopaka doko, angi pita gii dokopa, dopa leana lao nyakamame masetaminopa lao indupa nambame nyakama pii datupa langilyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Namba puu lea Akali doko katenge dokonya indupa namba pelyona lapupa, nyakamanya mendaipi mendeme, ‘Emba anja pelyepe?’ lao tipa napilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Namba pelyona lao nyakama langilyo dokonya, nyakama etete mona kenda kaelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dopaka doko, nambame nyakama kiningi langilyo: Nambame nyakama yakinatala pelyo dokome nyakama nisepae nyalapale lao pelyo. Namba napupuli doko, nisepenge Spirita doko nyakama-kisa naipupyali. Dopaka doko, namba pupala, nisepenge Spirita doko epena lato. ");
INSERT INTO enq2_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","9","Yuunya endakali dupame namba tungi napilyamino dokonya, mana koopi, mana tolataepi, Goteme endakali dupa yapapengepi, dupa dopalena lao lelyamino doko kopeta lelyaminona lao Spirita doko ipupala lao panata. ");
INSERT INTO enq2_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nambanya Takange doko katenge dokonya patopa, nyakamame namba kanja naeyalamino dokonya, namba akali tolataena lao Spirita dokome lao panata. ");
INSERT INTO enq2_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Isa yuu dakenya isingi Satane doko Goteme yapatala tenge setapeana lao Spirita dokome lao panataka. ");
INSERT INTO enq2_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nambame nyakama pii longo mendapu langipengeaka doko, nyakamame indupa kapa pao soo nyala naeyalamino. ");
INSERT INTO enq2_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dopaka doko, Spirita kiningi pii lenge doko ipupala, kiningi pii dupa pitaka masalapale lao nyakamanya masingi doko tii piseta. Baame nyakama pii langita dupa baa tangeme masoo langya naeyata. Pii baame setapi, tanga pitapi, dupanya nyakama langita. ");
INSERT INTO enq2_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Spirita dokome namba-kisa pii nyepala panao nyakama langita. Dopa pita dokome namba kenge andake dita. ");
INSERT INTO enq2_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Takange dokonya singi dupa pitaka nambanya. Tenge dokonya nambame dapa lelyo: Spirita dokome namba-kisa pii nyepala nyakama panao langitana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Takange doko katenge dokonya namba pelyo. Tenge dokonya, gii kuki mendatupa patatamopa, nyakamame namba kanja naeyalamino. Gii kuki mendatupaka patatamopa, nyakamame namba kandatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dopa leamosa baanya disaipolo dupanya mendapuame nyakama-lapo laloo pyoo, “ ‘Gii kuki mendatupa patatamopa, nyakamame namba kanja naeyalamino. Gii kuki mendatupaka patatamopa, nyakamame namba kandatamina’ lelyamo dokopa, baa ‘Takange katenge dokonya pelyona’ lelyamo dokopa, dolapo baame aipa pyoo lelyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Dopa latala dee nyakama-lapo tipa pyoo, “ ‘Gii kuki mendatupana’ lelyamo doko, baame aipa pyoo lelyape lao naimame tenge doko soo nanyilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Dokopa Jisasame baa tipa pimana lao masiami doko kandatala dokaita lamaiyoo, “ ‘Gii kuki mendatupa patatamopa, nyakamame namba kanja naeyalamino. Gii kuki mendatupaka patatamopa, nyakamame namba kandatamina’ lelyo dokonya nambame aipa pyoo lelyape lao nyakama-lapo tipa pilyamipi? ");
INSERT INTO enq2_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nambame nyakama etete kiningi langilyo: Isa yuu dakenya endakali dupa eteke pyao mona yaepao katataminopa, nyakama yamataka lao ee lao katatami. Nyakama mona kenda kaeyao katatamiaka doko, tanga nyakama mona yaepao katatami. ");
INSERT INTO enq2_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Enda mende wane manjanya maita pilyamopa, baa tanda andake nenge. Dopa pingiaka doko, baame wane doko isa yuu dakenya mandinya setapala eteke pilya dokome, baa tanda nelya doko kame singi. ");
INSERT INTO enq2_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dopaleaka joo, indupa nyakama mona kenda kaeyao kalyamino. Dopaka doko, nambame nyakama dee kandatopa, nyakama eteke pyatami. Dopa pitaminopa, endakali mendeme nyakamanya eteke pingi doko nyokonyala naeyata. ");
INSERT INTO enq2_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Gii dokopa nyakamame namba-kisa dopale mende tee laa naeyatami. Takange doko-kisa nambanya kengenya dopale mende nyakamame tee lataminopa baame nyakama ditana lao nambame nyakama etete kiningi langilyo. ");
INSERT INTO enq2_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wamba pituu indupa tuu lao, nyakamame nambanya kenge dokonya dopale mende Takange doko-kisa tee laa naeyami. Dopana, indupa nyakamame tee lataminopa nyetamina, tee lapape. Tee lataminopa, nyakama etete eteke pyao katataminopa lao baame ditana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Wamba nambame nyakama pii langio dupa pitaka kongaliaka lao langio. Dopaka doko, gii mende ene epelyamo dokonya nambame kongaliaka lao langya naeyato. Takange dokonya lao tolao nyakama langito. ");
INSERT INTO enq2_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Gii dokopa nyakamame dopale mende Takange doko-kisa tee lataminopa, nambame nyakamanya kambu alo pyoo Takange doko lamaiyakatopa lao nalelyo. Nyakamame nambanya kenge dokonya baa-kisa tee lataminopa lao lelyo. ");
INSERT INTO enq2_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Namba Gote-kisa katao epea-lamo lao nyakamame masetala auu kaelyamino dokonya, Takange dokome nyakama auwaka kaelyamo. ");
INSERT INTO enq2_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Namba Takange-kisa katao isa yuu dakenya epeo. Indupa isa yuu dake yakinatala Takange katenge dokonya patoana” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dokopa baanya disaipolo dupame baa lamaiyoo, “Indupa embame kongali lao nalenya, tolao pii lelyeno. ");
INSERT INTO enq2_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Embame dupa pitaka kandenge dokonya, endakali mendeme emba tipa pyaa naelyamopa, embame wambao baanya tipa pipenge dupa kandenge. Tenge dokonya, kiningi emba Gote-kisa katao epea-lamo lao indupa naimame masilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dokopa Jisasame dokaita lamaiyoo, “Indupa nyakamame dopa lao masilyamipi? ");
INSERT INTO enq2_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Salapape! Nyakama mendai-mendai lao nyakamanya andaka dupanya pupale lao, pyao tale pisalamino gii doko indupa ipatelyamo. Nyakamame namba iki kalyale lao yakinatala paka paaminoaka doko, namba iki nakalyapo. Nambanya Takangepa tole kalyambano. ");
INSERT INTO enq2_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nyakama mona yaepao katataminopa lao nambame pii dutupa langilyo. Nyakama isa yuu dakenya katataminopa nyakama-kisa kenda dupa ipataka doko, nambame isa yuu dakenya pupu lapae doko ita minatelyona, nyakama mona kenda nakaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","2","Jisasame pii dutupa lao etapala, kaiti-kisa kandalyetae katao lao pituu, “Apane, embanya Ikiningi dokome endakali dupa pitaka isina lao, embame kyeto doko baa maiya. Embanya endakali baa maiyino dupa pitaka lete etete katenge doko maiyekena lao embanya kyeto doko baa maiyaka. Dopana, gii setapae doko ipatelyamona, embanya Ikiningi dokome emba kenge andake dina, embame baa kenge andakeaka maipi. ");
INSERT INTO enq2_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Emba Gote kiningi mendai iki dokopa, embame epena leeno Jisasa Kraisa dokopa, dolapo masingi doko lete etete katenge dopale. ");
INSERT INTO enq2_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Namba isa yuu dakenya katao, emba kenge andake ditio. Nambame kalai pyaale lao diino dupa pyoo etapeo. ");
INSERT INTO enq2_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Apane, yuupa kaitipa dolapo nasiamopa tii pipae nalimba-kisa siamo dokomeaka embanya enomba dokonya namba kenge andake dipi. ");
INSERT INTO enq2_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Embanya kenge andake doko nambame lao panao, isa yuu dakenya-tae endakali namba diino dupa lamaitio. Endakali embanya dokaita embame namba dii. Endakali dokaitame embanya pii doko wata-minao kalyamino. ");
INSERT INTO enq2_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Embame namba diino dupa pitaka emba-kisa katao epea-lamo lao indupa dokaitame kandatelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Embame pii lamaipi lao namba langiino dupa nambame dokaita lamaitio. Pii lamaiyo dupa dokaitame soo nyepala, kiningi embame namba puu lea-lamo lao masilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nambame loma silyo dake, isa yuu dakenya endakali dupanya loma sakamaiya naelyo. Embame endakali namba diino dupa embanyana lao masetala, nambame dupanya loma sakamailyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nambanya endakali dupa pitaka embanya. Embanya endakali dupa pitaka nambanya. Endakali namba diino dupame namba kenge andake dilyamino. ");
INSERT INTO enq2_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Apane, emba-kisa koo mende nasingi. Embame endakali namba diino dokaita isa yuu dakenya katena latala, namba isa yuu dake yakinao, emba kalyeno dokonya epelyo. Nalimba mendai jetae katenge dopaka pyoo, dokaita mendai jetaeyaka katena, embanya kenge namba diino dokome dokaita auu pyoo isepe. ");
INSERT INTO enq2_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Namba dokaita-pipa isa yuu dakenya katao, embanya kenge dokome endakali namba diino dokaita isoo katapu. Isoo katapupa dokaitanya mendaipi mende alu napipya. Dopaka doko, pii pepa pyapae singi doko angi jina lao, akali koeyatana latae doko iki alu pipya. ");
INSERT INTO enq2_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Indupa emba kalyeno dokonya namba epelyo. Nambanya eteke pingi doko dokaita-kisa tumbina lao, isa yuu dakenya katao pii datupa lelyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Endakali namba ditae dupa embanya pii doko lamaitio. Namba isa yuu dakenya-tae daa. Endakali namba ditae dupa isa yuu dakenya-tae daaka. Tenge dokonya, isa yuu dakenya endakali dupame dokaita imbu kaelyamino. ");
INSERT INTO enq2_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Endakali namba ditae dupa isa yuu dake yakinena, nyokonyatale lao loma sala naelyo. Endakali dokaita koo akali dokome koeyasatame-lao isoo kalyale lao loma silyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Namba isa yuu dakenya-tae daa. Endakali namba ditae dupa isa yuu dakenya-tae daaka. ");
INSERT INTO enq2_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Embanya pii doko kiningi. Embanya kiningi pii dokome endakali dokaita embanya latae katena lao pyoo wasina lape. ");
INSERT INTO enq2_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Embame namba isa yuu dakenya endakali dupanya kainanya puu leeno dopaka pyoo, nambame dokaita isa yuu dakenya endakali dupanya kainanya pena lateo. ");
INSERT INTO enq2_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Endakali namba ditae dokaita kiningi pii dokome pyoo wasetamopa, embanya latae katena lao, dokaita nisoo nambanya lete katenge doko emba dilyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nambame endakali dokaitanya iki loma sakamaiya naelyo. Endakali dokaitame pii lamaitami dupa sepala namba tungi pyatami endakali dupanya apata nambame loma sakamailyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dokaita mendai jetae katena lao loma sakamailyo. Apane, emba nambanya mona andaka kalyenopa, namba embanya mona andaka katenge dopaka pyoo, dokaita nalimba-pipa mendai jetae katena lao loma sakamailyo. Embame namba puu leenopa epea-lamo lao isa yuu dakenya endakali dupame masina lao dopa lao loma silyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nalimba mendai jetae katenge dopaka pyoo, dupa mendai jetaeyaka katena lao, embame tii pipae namba diino doko nambame dokaita maitio. ");
INSERT INTO enq2_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Dokaita etete mendai jetae katena lao, emba nambanya mona andaka katengeli pyoo namba dokaitanya mona andaka kata laale lao loma silyo. Embame namba auu kaengeli pyoo, endakali namba ditae dokaita embame auu kaenge-lamo lao, isa yuu dakenya endakali dupame kandatala, namba embame puu leenopa epea-lamo lao dokaitame masina lao loma silyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apane, yuupa kaitipa dolapo nasiamopa embame namba auu kaeyapala tii pipae diino doko endakali namba ditae dupame kandena, namba katato dokonya dokaita apata katatamana lao masilyo. ");
INSERT INTO enq2_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Apane, emba tolatae. Isa yuu dakenya endakali dupame emba masala naengemaka doko, nambame emba kandenge. Embame namba puu leenopa epea-lamo lao endakali namba ditae dokaitame kandengema. ");
INSERT INTO enq2_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nambame embanya kenge doko embanya endakali namba ditae dupa-kisa lao panasiona, tangapi embanya kenge doko lao panasoaka katato. Embame namba auu kaengeli pyoo, endakali namba ditae dupame endakali waka dupa auu kaeyao katataminopa lao, namba dokaitanya mona andaka katatoo latala, embanya kenge doko lao paneona” Jisasame lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisasame loma soo etapala, baanya disaipolo dupa-pipa Kidrone duu dokonya omotena, ee mende sia dokonya pao pyakameami. ");
INSERT INTO enq2_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Paa longosa Jisasa baanya disaipolo dupa-pipa ee dokonya kambu pyata pingima dokonyana, yandapipi dupanya kinginya Jisasa maiya akali Judasa dokome ee doko kandatae. ");
INSERT INTO enq2_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kandatae dokonyana, Judasame Roma tange amiipi, prisa mupa dupanya yanda singipi, Parasi dupanya yanda singipi, dupa lanyepala, lama kaiyapaepi, kipali kaiyapaepi, yanda yandatepi dupa minao epeami. ");
INSERT INTO enq2_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Epeaminopa Jisasame baa-kisa pyaamino dupa pitaka masetala, epeami dokonya tengesa pupala dokaita lamaiyoo, “Nyakamame api kutilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Dokopa dokaitame baanya pii yanu pyakamaiyoo, “Nasarete tange Jisasa doko kutilyamanona” leami. Dokopa Jisasame dokaita lamaiyoo, “Namba akali dokona” lea. (Yandapipi dupanya kinginya Jisasa maiya akali Judasa doko akali dokaita-pipa kateami.) ");
INSERT INTO enq2_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisasame “Namba akali dokona” leamopa, dokaita maita-konakoname pilyetala yuunya pyapae siami. ");
INSERT INTO enq2_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dopa piaminopa baame dee dokaita tipa pyoo, “Nyakamame api kutilyamipi?” lea. Dokopa dokaitame lao pituu, “Nasarete tange Jisasa doko kutilyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dopa leaminopa Jisasame lao pituu, “Akali kutilyamino doko nambana lao nyakama langitalo. Nyakamame namba kutatamino doko, akali datupa pena kaeyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jisasame wamba loma soo pituu, “Embame endakali namba ditae dupanya mendaipi mende alu pina lao yakinala naeyapuna” lea pii doko angi jina lao, “Akali datupa pena kaeyalapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dokopa Saimone Pitame konjuwa mende mandea doko kolanyetala, prisa mupa dokonya kalai akali dokonya kale tolaetena lyanya nepea. (Kalai akali dokonya kenge doko Malakusa lenge.) ");
INSERT INTO enq2_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dokopa Jisasame Pita lamaiyoo, “Nambanya Takangeme kenda paleta kapo mende namba dia doko nambame nala naeyapengepe? Embanya konjuwa doko palenge andanda dokonya mandi” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dokopa Roma tange amiipi, dupanya isingi mupa dokopi, Juu dupanya yanda singipi, dupame Jisasa minatala anjiami. ");
INSERT INTO enq2_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anjetala baa laminao wambao Anasa katea dokonya peami. Anasa doko baa Kaeyapasanya imange. Kaeyapasa baa ee kana dokonya prisa mupa katea. ");
INSERT INTO enq2_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Kaeyapasa dokome wamba Juu dupa lamaiyoo, “Naima tata dupa pitaka kumala naena lao, akali mendai mendeme naimanya panda nyoo kumatamo dokome naima nisetana” lea.) ");
INSERT INTO enq2_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Dokopa Saimone Pitapa, disaipolo mende dokopa, dolapome Jisasa watao peambi. Disaipolo mende doko prisa mupa dokome kandenge dokonyana, Jisasapa tole pao prisa mupa dokonya anda kamapu dokonya pyakameambi. ");
INSERT INTO enq2_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dokopa Pita baa kamaka lome kambu dokonya katea. Kateamopa prisa mupa dokome kandenge disaipolo doko kamaka pyakalyetala, kalai wanaku lome kambu isoo petenge dokome Pita laminao andakote epena lamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dokopa kalai wanaku lome kambu isoo petenge dokome Pita lamaiyoo, “Emba apata akali dokonya disaipolo dutupanya mende daape?” lea. Dokopa baame lao pituu, “Namba dutupanya mende daana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","(Kalai akalipi, Juu dupanya yanda singipi, dupa kupa kaeyapala, ita yangatala endo soo kateami dokonya Pita apata endo soo kateaka.) ");
INSERT INTO enq2_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dokopa prisa mupa dokome Jisasa tipa pyoo, “Embanya disaipolo dupa apitupape, embame aipa lao mana lengepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dokopa Jisasame baanya pii yanu pyakamaiyoo, “Juu dupa kambu pingi lotuu anda dupanyapi, lotuu anda nee nyetae kamapu dokonyapi, nambame koteaka lao mana lamaiyo. Nambame pii mende yalo pyoo naleo. Isa yuu dakenya endakali dupa pitakame sina lao nambame panao leo. ");
INSERT INTO enq2_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Dopana, aipuma embame namba tipa pilyi? Nambame pii lamaiyopa siami dupame dopa leana lao masilyaminona, embame dokaita tipa pyoo sepe” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dopa lateamopa Juumanya yanda singi dupanya mende, tengesa dosa katea dokome lao pituu, “Embame dopa lao prisa mupa dokonya pii yanu pyakamaingipi?” lea. Dopa latala baame Jisasanya lenge-lyaapinya kingi kapeme toka lao nyia. ");
INSERT INTO enq2_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dokopa Jisasame baa lamaiyoo, “Nambame pii kopeta mende lato doko, pii doko kopeta lalenona lao embame panao laa. Nambame pii tolao lato doko, aipuma embame namba pilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dopa lateamopa, Jisasa kendeme anjiamili petae doko Anasame prisa mupa Kaeyapasa katea dokonya pena lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimone Pita baa endo soo kateamopa, akali dosa kateami dupame baa lamaiyoo, “Emba baanya disaipolo dutupanya mende daape?” leami. Dopa leaminopa baame tanga lao, “Namba dutupanya mende daana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Prisa mupa dokonya kalai akali mende dosa katea doko Pitame kale lyanya nepea akali dokonya tata mende. Akali dokome Pita lamaiyoo, “Emba ee dokonya Jisasapa katambinopa nambame kanjo doko daape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dokopa Pitame dee tanga lao, “Namba doko daana” lea. Dopa lalu piamopa, yaka pauli pii mende lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yongama wamba Juumanya yanda singi dupame Kaeyapasa yakinatala, Jisasa lanyoo gapomanenya anda andake dokonya peami. Dokaita kaimala napitamopa, Pasopa nee doko natamana latala, gapomane anda dokonya kolandala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dopa piaminopa Pailatame kamaka pyakalyetala dokaita lamaiyoo, “Nyakamame baa-kisa tenge aipale mende setapala, kotimi laanya laminao epelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dopa leamopa dokaitame yanu pyao, “Akali dakeme koo napingi-pyali doko, naimame baa emba dyaa naipumalina” leami. ");
INSERT INTO enq2_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dokopa Pailatame dokaita lamaiyoo, “Nyakamame baa nyepala, nyakamanya loo dupanya-kaita baa kotimi lapa” lea. Dokopa Juu dupame baa lamaiyoo, “Gapomanenya loo dokome naimame endakali mende pyao kumasalapape lapae nasingina” leami. ");
INSERT INTO enq2_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Dopa leami dokome, Jisasame baa dopa pyoo kumatona lao wamba pii lea doko angi jalanya pia. ");
INSERT INTO enq2_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailata baa dee baanya andaka kolandatala, Jisasa epena latala lamaiyoo, “Emba Juumanya Kiŋi dokope?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dopa leamopa Jisasame baanya pii yanu pyakamaiyoo, “Embame lelyeno doko, emba tangeme masoo lelyepe, pande endakali mendapuame namba dokona lao langiminopa lelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dokopa Pailatame yanu pyao, “Namba Juu mendepe? Emba tatapi, prisa mupapi, dupame emba namba dyaa ipamino doko, embame aipa pipipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dopa leamopa Jisasame yanu pyao, “Nambanya kingdom doko isa yuu dakenya-tae daa. Nambanya kingdom doko isa yuu dakenya-tae-pyali doko, Juu dupanya kinginya namba namaina lao, nambanya kalai akali dupame yanda pimili. Dopaka doko, nambanya kingdom doko isa yuu dakenya-tae daana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dokopa Pailatame baa lamaiyoo, “Dopa-tamo doko, emba kiŋipi?” lea. Dokopa Jisasame yanu pyao, “Embame namba kiŋi lelyeno. Namba endangimi mandeamopa isa yuu dakenya epeo doko, kiningi pii doko lao panalanya epeo. Kiningi pii dokonya katengema endakali dupame nambanya pii doko singimana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dokopa Pailatame baa lamaiyoo, “Kiningi pii doko akipi?” lea. Dopa latala Pailata baa dee kamaka pyakalyetala Juu dupa lamaiyoo, “Nambame akali dake-kisa tenge mende kandao nanyilyo. ");
INSERT INTO enq2_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dopaka doko, nyakamanya mana singili pyoo, Pasopa gii dokonya nambame akali anjetae dupanya mende mokata pyekenge. Dopa pingili pyoo, nambame Juumanya Kiŋi doko mokokapili lao nyakamame masilyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dokopa endakali dupa pitakame puu lao, lao pituu, “Akali doko daana, Barabasa mokoka” leami. (Barabasa doko pake nao makongao paenge akali mende.) ");
INSERT INTO enq2_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dokopa Pailatame Jisasa pina leamopa, amii dupame Jisasa nyepala konjame piami. ");
INSERT INTO enq2_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dopa petala amii dupame kende nenge-nenge katapae mende nyoo makipu petala, Jisasanya aiyombanya pisakamaiyami. Dopa petala yonge pee kala pepolo mende pyakamaiyami. ");
INSERT INTO enq2_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Petakamai dokaitame lao pituu, “Juumanya Kiŋi doko, emba auu pyoo katape” latala, lenge-lyaapinya kingi kapeme toka lao nyepa piami. ");
INSERT INTO enq2_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Dopa peteaminopa Pailata deaka kamaka pyakalyetala dokaita lamaiyoo, “Nambame baa-kisa tenge mende kandao nanyelene-lamo lao, nyakamame kanjepale latala baa laminao kamaka epelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dopa lateamopa, Jisasanya aiyombanya kende nenge-nenge katapae mende makipu petala pisakamaiyami dokopa, yonge pee kala pepolo dokopa, dolapo petae baa kamaka pyakalyia. Dokopa Pailatame dokaita lamaiyoo, “Akali doko dakena kanjepa!” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dokopa prisa mupapi, Juumanya yanda singipi, dupame Jisasa kandatala puu lao, lao pituu, “Baa pyao yuku! Baa pyao yuku!” leami. Dopa leaminopa Pailatame dokaita lamaiyoo, “Nambame baa-kisa tenge mende kandao nanyilyona, nyakamame baa nyepala pyao yukulapa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dopa leamopa Juu dupame baanya pii yanu pyakamaiyoo, “Naimanya loo mende singi. Akali dakeme baa Gote Ikiningi kalyona lapumu dokonya, naimanya loo dokome lapae singili pyoo baa pyao kumasepengena” leami. ");
INSERT INTO enq2_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pii leami doko Pailatame sepala baa etete paka kaeya. ");
INSERT INTO enq2_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Paka kaeyapala baame Jisasa laminao deaka andaka kolandatala baa lamaiyoo, “Emba anja tangepe?” lea. Dopa leamopa Jisasame yanu pyao pii mende lamaiya naeya. ");
INSERT INTO enq2_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dokopa Pailatame baa lamaiyoo, “Embame pii mende namba langya naelyepe? Emba pyao yukupenge dokopa, mokapenge dokopa, dolaponya yakana lapenge kyeto doko namba-kisa singina lao masala naelyepe?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dopa leamopa Jisasame yanu pyao, “Yakana lapenge kyeto doko Akali Ketae Katenge dokome emba nandiali doko, embanya kyeto dokome namba mende napipili. Dopana, namba anjoo emba dyomo akali dokome emba ita minao koo etete andake mende pyomona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dopa lea gii dokonya pituu, Pailatame baa mokalanya kaitini kutia. Dopa piamopa Juu dupame puu lao, lao pituu, “Embame akali dake mokateno doko, emba Roma tange gapomane andake Sisa dokonya mona setenge daa! Endakali mendeme baa tange kiŋi kalyona lelyamo doko Sisa dokonya yandapipi jilyamosa pingina” leami. ");
INSERT INTO enq2_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dopa leamino doko Pailatame sepala, Jisasa laminao kamaka pyakalyetala, Kana Patame Semene Minatae, Ibru pii lao Gabata lengema dokonya kote singi toko dokonya baa pao petea. ");
INSERT INTO enq2_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","(Gii doko Pasopa nee depa lenge gii dokonya 12 kilokopi mendenya.) Dokopa Pailatame Juu dupa lamaiyoo, “Dake nyakamanya kiŋi dokona kanjepa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dopa leamopa dokaitame puu lao, lao pituu, “Baa kamalya nyoo pyakalyalapa! Nyoo pyakalyetala pyao yukulapa!” leami. Dokopa Pailatame dokaita lamaiyoo, “Nambame nyakamanya kiŋi doko pyao yukuwape?” lea. Dopa leamopa prisa mupa dupame yanu pyao, “Naimanya kiŋi waka mende nakatenge. Sisa doko iki naimanya kiŋi katengena” leami. ");
INSERT INTO enq2_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dopa leaminosa Jisasa pyao yukuina lao Pailatame amii dupanya kinginya maiya. Maitiamopa amii dupame Jisasa laminao peami. ");
INSERT INTO enq2_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Laminao peaminopa, Jisasame poko ita baa yukutae katapenge doko tange soo yuu Matena Kuli lenge dokonya pea. (Matena Kuli doko Ibru pii lao Gologota lengema.) ");
INSERT INTO enq2_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yuu dokonya Jisasa pyao yukutala, akali lapoma apata baa-pipa pyao yukuiyamiaka. Mende doko baanya kingi tolaetena yukutala, mende doko baanya kingi koeyatena yukuiyami. ");
INSERT INTO enq2_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","“Jisasa Nasarete Tange, Juu Dupanya Kiŋi Dokona” lao, Pailatame pepa pyatae doko Jisasanya poko ita ketae dokonya yukuiyami. ");
INSERT INTO enq2_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pepa doko Ibru piipi, Giriki piipi, Latene piipi lao pepa pyanya katea. Jisasa pyao yukutae katea panda doko Jerusalema tengesa dokonyana, Juu longome pepa pyatae katea doko itaki pyao kandeami. ");
INSERT INTO enq2_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dokopa Juu dupanya prisa mupa dupame Pailata lamaiyoo, “Baa Juu dupanya kiŋina lao embame pepa pyalene-lamo doko kaeyapala, baa tangeme Juu dupanya kiŋina lapyana lao pepa pyaa” leami. ");
INSERT INTO enq2_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dokopa Pailatame yanu pyao, “Pepa nambame pyalo doko alo napyapona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Amii dupame Jisasa pyao yukutala, baanya yonge pee dupa malu kitomende pyatala, amii dupa malu mendai-mendai lao nyiami. Baanya yonge pee isa pingi doko, piyoko lapae tambuala naenge mende. ");
INSERT INTO enq2_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dopa petae dokonyana, amii dupame nyakama-lapo lao pituu, “Naimame yonge pee dake kanguala naenya, apimi nyilyape lao kandamana laki pyama” leami. Dopa piami dokome, Gotenya pii pepa pyapae singi dokonya, “Nambanya yonge pee dupa dokaita mokosoo nyiami. Nambanya yonge pee dupa dokaita mokosoo nyalanya laki piamina” lapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisasa poko itanya yukutae katea tengesa dosa baanya endangi dokopi, endanginya kakingi dokopi, Kolopasa etanenge Maria dokopi, Magadala tange Maria dokopi, dutupa kateami. ");
INSERT INTO enq2_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisasame baanya endangi dokopa, baanya disaipolo mona setenge dokopa, dolapo tengesa dosa kateambino kandatala, baanya endangi lamaiyoo, “Enda, wane doko indupa embanya ikiningina” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dopa latala baanya disaipolo mona setenge doko lamaiyoo, “Enda doko indupa embanya endangina” lea. Gii dokonya pituu, disaipolo dokome enda doko isalanya andaka laminao pea. ");
INSERT INTO enq2_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Dokopa Jisasame baanya kalai pipenge dutupa pitaka pyoo etapelyo lao kandatala, Gotenya pii pepa pyapae singi doko angi jina lao, baame lao pituu: “Namba endaki nanu pyumuna” lea. ");
INSERT INTO enq2_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dokopa, penge mendenya waene kaa pipae tumbatae dosa sia mendenya dokaitame koma jepae mende pyandao waene kaa pipaeme tumbasetala, isope itange mendenya tuku petala, Jisasa nena lao makapusiami. ");
INSERT INTO enq2_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Dopa piaminopa, Jisasame waene kaa pipae doko napala lao pituu, “Nambanya kalai pipenge dupa pitaka pyoo etapelyona” lea. Dopa latala baanya mange doko tukunatala, baanya imambu doko yakinea. ");
INSERT INTO enq2_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yuu gii mende doko Sambata gii andake mende ipupenge dokonya, Sambata doko depa lapenge gii palea. Sambata gii dokopa akali dutupanya yonge dupa poko itanya yukutae nakatena, moko pyao lakapala kondao isa nyemana lao Juumanya isingi akali dupame Pailata tee leami. ");
INSERT INTO enq2_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dokopa amii dupa ipupala, Jisasa-pipa apata pyao yukuiyami akali dolaponya wambao dokonya moko dolapo pyao lakapala, mende dokonya moko dolapo pyao lakeami. ");
INSERT INTO enq2_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dopa petala, Jisasa yukutae katea dokonya ipupala kandeaminopa, baa wamba kumatala sianya, baanya moko dolapo pyao lakala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dokopa amii mendeme Jisasanya patali dokonya yandateme kapu katao nyia. Kapu katao yukunyulu pia dokonya-kaita taeyokopa endakipa lyia. ");
INSERT INTO enq2_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Dopa piamopa kandea akali dokome dopa piana lao panao pepa pilyamo. Baanya pii panao pepa pilyamo doko kiningi. Baame pii lelyamo doko kiningi lelyona lao baame masilyamo. Baanya pii doko kiningina lao nyakamame masalapale lao pepa dake pilyamo. ");
INSERT INTO enq2_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jisasanya kuli pyao lakala naeyami dokome, “Baanya kuli mendaipi mende pyao lakala naeyatamina” lao Gotenya pii pepa pyapae singi doko angi jia. ");
INSERT INTO enq2_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Gotenya pii pepa pyapae singi dokonya mendeme lao pituu, “Dokaitame kapu katao piami akali doko kandao katatamina” lapae singi doko angi jiaka. ");
INSERT INTO enq2_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Arimatia tange Josepe lenge doko baa Jisasanya disaipoloaka doko, Juu dupa paka kaeyapala, yalo pyoo Jisasa watao paeya. Akali dokome Jisasanya yonge doko dina lao Pailata tee leamopa Pailatame nyina lea. Dokopa Josepeme Jisasanya yonge doko kondao nyala pea. ");
INSERT INTO enq2_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Dokopa Nikodimasa lenge, kuka mendenya wamba Jisasa petea dokonya pea akali dokome wele tunduma pipaepi, aloa ipangepimi wasepae, 35 kiloapi mende soo, Jisasanya yonge doko nyala peaka. ");
INSERT INTO enq2_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Akali dolapome Jisasanya yonge doko nyepala, Juu dupame endakali malu pyaanya depa lengemali pyoo, tunduma pingi dupame kai pyatala lapalapa kyeo lapae mendapuame yaki piambi. ");
INSERT INTO enq2_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisasa pyao yukuiyami panda dosa ee mende sia. Ee dokonya kananda tumbyepae enenge mende sia. Kananda dokonya endakali mende wamba malu napiami. ");
INSERT INTO enq2_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juumanya Sambata depa lenge gii doko paleamosa, malu pipenge kananda tumbyepae tengesa sia dokonya akali dolapome Jisasanya yonge doko nyoo seteambi. ");
INSERT INTO enq2_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande yongama wamba utu dokonya, Maria Magadala tange doko Jisasa malu doko kanja pea. Pupala kandeamopa, malu kambu dokonya kaname piti petae doko nyoo kapya latae siamo kandea. ");
INSERT INTO enq2_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kandatala baa alo pyao pao Saimone Pitapa, disaipolo mende Jisasanya mona setenge dokopa, dolapo lamaiyoo, “Kamongo doko malunya lopao nyalamini-lamo doko, nyoo anja setalamipi lao naimame masala naelyamanona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dopa lateamopa Pitapa, disaipolo mende dokopa, dolapo sakatatala malu dokonya peambi. ");
INSERT INTO enq2_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Disaipolo dolapo alo pyao malu dokonya tole peambinopa, disaipolo mende dokome Pita nyoo maita pyatala, baa wambao malu dokonya pyakamea. ");
INSERT INTO enq2_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pyakamatala baa angi kolandala naenya elyo pyao kandeamopa, lapalapa kyeo lapae dupa tata lapae sia. ");
INSERT INTO enq2_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimone Pita maitanya epea ipao malu dokonya andakote kolandatala kandeamopa, lapalapa kyeo lapae dupa tata lapae sia. ");
INSERT INTO enq2_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lapalapa kepapae mende Jisasanya aiyomba yaki pyakamaiyami doko lapalapa yangi dupa-pipa pyasoo nasia. Doko waka mendasa lakapae sia. ");
INSERT INTO enq2_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dokopa disaipolo mende malunya wambao pea dokome apata malunya kolandao kandatala, kiningi Jisasa baa sakatalame-lamo lao masia. ");
INSERT INTO enq2_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Jisasa baa kumapala sakatapengena lao Gotenya pii pepa pyapae singi dupa disaipolo dolapome gii dokopa masala naeyambi.) ");
INSERT INTO enq2_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dopa petala disaipolo dolapo nyakambanya andaka pilyiambi. ");
INSERT INTO enq2_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Dokopa akali dolapo pilyiambinopa, Maria baa malu kambu dosa kamaka ee lao katea. Ee lao katao pongatala malunya elyo pyao kandea. ");
INSERT INTO enq2_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kandeamopa, enjele lapoma yonge pee kyeo lapae pingi mendalapo peteambino kandea. Mende doko Jisasanya aiyomba seteami panda dokonya peteamopa, mende doko moko seteami panda dokonya petea. ");
INSERT INTO enq2_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dokopa enjele dolapome Maria lamaiyoo, “Enda, emba aipuma ee lelyepe?” leambi. Dokopa baame enjele dolapo lamaiyoo, “Nambanya Kamongonya yonge doko nyalamini-lamo doko, nyoo anja setalamipi lao namba masala naelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dopa latala, baa kapilyetala Jisasa kateamo kandea. Dopaka doko, akali doko Jisasa-lamo lao nakandea. ");
INSERT INTO enq2_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dokopa Jisasame baa lamaiyoo, “Enda, emba aipuma ee lelye? Emba api kutilyipi?” lea. Dopa leamopa, akali doko ee isingi doko-lamo lao masetala Mariame baa lamaiyoo, “Akali Andake, embame akali dokonya yonge doko nyoo mendasa setateno doko, nambame baanya yonge doko nyoo patoo, embame dosa setalona lao namba langipoko” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dopa leamopa Jisasame baa lamaiyoo, “Maria!” lea. Dokopa Mariame Jisasa enomba maitala lao pituu, “Rabonai!” lea. (Rabonai dokonya tenge doko, Mana lenge.) ");
INSERT INTO enq2_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dokopa Jisasame baa lamaiyoo, “Nambanya Takange doko katenge ulunya patala naelyona, embame namba minatae sala naenya, emba pupala nambanya kaiminingi dupa lamaiyoo, ‘Nambanya Takange doko, nyakamanya Takangeaka, nambanya Gote doko, nyakamanya Goteaka doko katenge ulunya pelyo’ lelyamona lao lamaiyakala puu” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dokopa Maria Magadala tange doko pupala, Kamongo kanjona lao disaipolo dupa lamaiya. Dopa latala, Jisasame pii lamaina lea dutupa dokaita lamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sande dokonya niki landa piamopa disaipolo dupa kambu pyatae peteami. Juu dupa paka kaeyapala, kaitini dupa loko pyanyetala peteami. Peteami kaina dokonya Jisasa ipao kalyu pia. Kalyu petala dokaita lamaiyoo, “Nyakama mona yaepao pilyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Dopa latala baanya kingi kombepi, patali kombepi, dupa disaipolo dupame kandena lea. Dokopa disaipolo dupame baa Kamongo doko-lamo lao kandatala auu kaeyami. ");
INSERT INTO enq2_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dokopa Jisasame dokaita dee lamaiyoo, “Nyakama mona yaepao pilyepape. Takangeme namba puu lea dopaka pyoo, nambame nyakama pupa lelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dopa latala baame dokaita-kisa poo lanya pisetala lamaiyoo, “Oli Spirita doko nyakama nyalapa. ");
INSERT INTO enq2_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nyakamame endakali mendenya koo dupa kame sakamaitamino doko, koo dupa kame setaeyaka katata. Nyakamame endakali mendenya koo dupa pyakilyina kaeyatamino doko, pyakilyetaeyaka katatana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisasa epea dokopa, 12 disaipolo dutupanya Tomasa, kenge mende Pakao Mandipae lenge doko disaipolo dupa-pipa napeteami. ");
INSERT INTO enq2_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Maitakao Tomasa epeamopa disaipolo yangi dupame baa lamaiyoo, “Naimame Kamongo kanjemanona” leami. Dokopa baame dokaita lamaiyoo, “Baanya kinginya ŋili kombe dupa nambame kandatala, nambanya kingi kondeme dupa minao, baanya patali doko nambanya kingi kondeme minaowaka napito doko, nambame kiningi-lumu lao masala naeyatona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yuu gii tukulapo pateamopa, Jisasanya disaipolo dupa andakote peteami. Gii dokopa Tomasa apata peteami. Anda kaitini dupa loko pyanyetae kateaka doko, Jisasa ipao dokaitanya kaina dokonya kalyu petala lao pituu, “Nyakama mona yaepao pilyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dopa latala baame Tomasa lamaiyoo, “Embanya kingi kondeme nambanya kinginya kombe dupa minao kanda. Embanya kingimi nambanya patali kombe doko mina. Minatala embame kiningina lao masepe. Sambona lao masala naeyape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dokopa Tomasame baanya pii yanu pyakamaiyoo, “Emba nambanya Kamongo, nambanya Gote dokona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dopa leamopa Jisasame baa lamaiyoo, “Embame kandelyeno dokonya namba tungi pilyipi? Namba nakandao tungi pilyamino endakali dupa Goteme auu pisetae kalyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisasame baanya disaipolo dupanya enombanya mirakolo longo mendapu pia dupa pitaka buku dakenya pepa pyapae nasilyamo. ");
INSERT INTO enq2_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dopaka doko, Jisasa doko Gote Ikiningi Kraisa doko-lamo lao nyakamame baa tungi pyatala, baanya kenge dokonya lete katenge doko nyetaminopa lao, mirakolo datupa pepa dakenya pyapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Maitakao Taibiriasa pete lemba dokonya disaipolo dupame dee kandena lao Jisasa baa dapa pyoo panea. ");
INSERT INTO enq2_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimone Pitapi, Tomasa kenge mende Pakao Mandipae lenge dokopi, Galali yuu dokonya taono Kena tange Nataniele lenge dokopi, Sebedi ikiningi dolapopi, Jisasanya disaipolo dupanya mendalapopi, dutupa tole kateami. ");
INSERT INTO enq2_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dokopa Saimone Pitame disaipolo yangi dutupa lamaiyoo, “Namba pisa nyala pelyona” lea. Dopa leamopa disaipolo dutupame baa lamaiyoo, “Naima apata mua” leami. Dopa latala, dutupa sipi dokonya pupae pyakalyetala peami. Dopaka doko, kuka gii dokonya pisa mende nyala naeyami. ");
INSERT INTO enq2_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yuu yongeamopa, Jisasa baa endaki pete lemba dokonya katea. Dokopa disaipolo dupame doko Jisasa-lamo lao nakandeami. ");
INSERT INTO enq2_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dokopa Jisasame wii lao disaipolo dutupa lamaiyoo, “Wane paluma, napenge pisa mendatupa nyakamame nyalamipi?” lea. Dopa leamopa disaipolo dutupame baanya pii yanu pyakamaiyoo, “Nanyalamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dopa leaminopa baame dutupa lamaiyoo, “Nyakamame sipi dokonya kingi tolaetena umbene doko endakinya pyandataminopa pisa nyalaminona pyandalapa” lea. Dokopa umbene doko endakinya pyandeaminopa, pisa longome umbene doko tumbia dokome, pyalya lao nyoo sipinya setapenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dokopa Jisasanya mona setenge disaipolo dokome Pita lamaiyoo, “Baa Kamongo doko-lamona” lea. “Baa Kamongo doko-lamona” lea doko Saimone Pitame sepala, baanya yonge pee kisa pingi lyokanya setea doko nyoo petala, endaki pete dokonya mangau lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dopaka doko, disaipolo yangi dutupame sipi yakane dokonya pituu kandeaminopa, endaki lemba doko londati nasia. Tengesa 100 mita joo siamosa, dutupame pisa paleta umbene doko pyalya lao endaki pete dokonya lembasa peami. ");
INSERT INTO enq2_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Endaki lemba dokonya pupala kandeaminopa, itate tao langa sia dokonya pisa mende yangatae kateamopa, breta mendatupa dosa sia. ");
INSERT INTO enq2_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dokopa Jisasame dokaita lamaiyoo, “Pisa epapu nyalamino dupanya mendatupa nyoo ipupa” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dopa lateamopa Saimone Pita sipi dokonya pyakalyetala, pisa paleta umbene doko pyalya lao nyoo lembasa ipupala kandeamopa, pisa andake 153 palea. Paleamopa umbene doko tumbiaka doko, umbene doko lapyala naeya. ");
INSERT INTO enq2_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dokopa Jisasame disaipolo dutupa lamaiyoo, “Nee nala ipupa” lea. Dopa leamopa disaipolo dutupame baa Kamongo doko-lamo lao kandatala, dutupanya mendeme, “Emba apipi?” lao tipa pyaanya paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dokopa Jisasa ipupala breta doko nyoo dutupa maitala, pisa doko dopaka pyoo nyoo maiya. ");
INSERT INTO enq2_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisasa baa malunya sakatatala, baanya disaipolo dupame kandena lao dakeme paa tepo pyoo panea. ");
INSERT INTO enq2_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nee nao etapala Jisasame Saimone Pita lamaiyoo, “Jona ikiningi Saimone, datupame namba auu kaengema doko ita minao embame namba moname kiningi auu kaelyepe?” lea. Dopa leamopa Pitame baa lamaiyoo, “Kamongo, nambame emba kiningi auu kaelyopa embame kandengena” lea. Dokopa Jisasame baa lamaiyoo, “Embame nambanya sipisipi ŋaŋa dupa nee maiyakape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dopa latala paa lapo pyoo baame Pita lamaiyoo, “Jona ikiningi Saimone, embame namba moname kiningi auu kaelyepe?” lea. Dopa leamopa Pitame baa lamaiyoo, “Kamongo, nambame emba kiningi auu kaelyopa embame kandengena” lea. Dokopa Jisasame baa lamaiyoo, “Embame nambanya sipisipi dupa auu pyoo setao katakape” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dopa latala paa tepo pyoo baame Pita lamaiyoo, “Jona ikiningi Saimone, embame namba auu kaelyepe?” lea. “Embame namba auu kaelyepe?” lao paa tepo pyoo Jisasame tipa piamosa, Pita baa mona kenda kaeyapala Jisasa lamaiyoo, “Kamongo, embame dupa pitaka kandenge dokome, nambame emba kiningi auu kaelyopa embame kandengena” lea. Dokopa Jisasame baa lamaiyoo, “Embame nambanya sipisipi dupa nee maiyakape. ");
INSERT INTO enq2_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nambame emba etete kiningi langilyo: Wamba emba wane kole kateeno dokopa, emba tange yonge pee dupa nyoo petala, patoo lao masiino dupanya pee. Dopaka doko, emba lyanga jete gii dokopa, embanya kingi dolapo tinokotenopa, endakali waka mendeme embanya yonge pee doko nyoo petakala, emba napatoo lao masete panda dokonya laminao patana” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Dopa lea dokome Pita dopa pyoo kumapala, Gotenya kenge doko minalyetana lao makande pyoo lea. Pii dutupa latala Jisasame Pita lamaiyoo, “Emba namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Wamba nee nao peteami gii dokopa, Jisasanya mona setenge disaipolo doko Jisasa-kisa semai latae pituu, “Kamongo, emba apimi yandapipi dupanya kinginya maiyepepe” lea disaipolo dokome Jisasapa Pitapa dolapo watao epeamopa, Pitame kapilyetala kandea. ");
INSERT INTO enq2_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kandatala Pitame Jisasa lamaiyoo, “Kamongo, akali dake aipa pitape?” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Dokopa Jisasame Pita lamaiyoo, “Nambanya auu kaengeme baa lenge tao katao, namba dee ipato gii dokonya tuu latana lao masoto doko embanya kalai mende daana, emba namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dopa leamosa, disaipolo doko kumala naeyata-lamona lao pii doko Kristene kaiminingi dupanya kainanya lao taeyami. Dopaka doko, disaipolo doko kumala naeyatana lao Jisasame baa lamaiya naeya. “Nambanya auu kaengeme baa lenge tao katao, namba dee ipato gii dokonya tuu latana lao masoto doko embanya kalai mende daana” lao baa lamaiya. ");
INSERT INTO enq2_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pia dupa pitaka disaipolo pepa pia-lamo dakeme kandatala dopa piana lao panao baame pepa dake pia. Baame panao pepa pia dutupa kiningina lao naimame masilyamano. ");
INSERT INTO enq2_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisasame kalai longo mendapu apata piaka. Kalai piamo dupa pitaka mendai-mendai lao bukunya pepa piamili doko, buku eteteaka longo-waka simupa, isa yuu dakenya setapenge panda nasipyalina lao nambame masilyo. Doko kiningi. ");
INSERT INTO enq2_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Kaimii Tiopilusa, Jisasame tee pyao kalai pia dokonya pituu, baanya aposole yapao nyepae dupa dopa pyoo katena lao Oli Spirita doko-kisa lamaitiamopa Goteme baa kaiti-kisa lanyoo pea gii dokonya tuu lao, Jisasame kalai piapi, mana leapi, dupanya lao nambame buku wambao dokonya pepa pio. ");
INSERT INTO enq2_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisasa baa tanda nao kumapala, baa kiningi sakatao lete kalyona lao baanya aposole dupame kandena lao, kaitini longo mendapuanya-kaita yuu gii 40 dutupanya aposole dupa kateami dokonya ipatapu, Gotenya kingdom dokonya lao pii lamaita pia. ");
INSERT INTO enq2_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Jisasa baanya disaipolo dupa-pipa katea dokopa, baanya Takangeme mende ditona lea doko nyakama ditana, Jerusalema yakinala naeyao malisoo kalyepape latala lao pituu, “Joneme endakali dupa endakimi kaimbu pyakamaiya. Dopaka doko, gii kuki mendatupa patatamopa, Oli Spiritame nyakama kaimbu pyakatana lao nambame nyakama langiopa siamina” lea. ");
INSERT INTO enq2_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dokopa disaipolo dupa Jisasa-pipa tole katao baa tipa pyoo, “Kamongo, embame indupa gii dakepa, Israelemanya kingdom doko tange isina lao nyoo maiyakamaitipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dokopa baame dokaita lamaiyoo, “Takange dokome gii mendapu baanya kyeto dokome setenge dupa gii dokopa ipatana lao nyakamame masoo nyepenge daa. ");
INSERT INTO enq2_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dopaka doko, Oli Spirita doko nyakama-kisa ipatamopa nyakama kyeto nyepala, Jerusalemapi, Judia yuu doko pitakanyapi, Samaria yuu doko pitakanyapi, yuu soo etengepi, dupanya pupala, nambanya lao pii lao panatamina” lea. ");
INSERT INTO enq2_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Dokopa disaipolo dupame lengeme kandatae kateaminopa, baa lanyoo kaiti-kisa pea. Peamopa kopa mendeme baa sanga pia. ");
INSERT INTO enq2_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sanga piamopa, dokaita kaiti-kisa kandalyetaeyaka kateaminopa, akali yonge pee kyeo lapae pingi mendalapo dosa kalyu piambi. ");
INSERT INTO enq2_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kalyu petala dokaita lamaiyoo, “Nyakama akali Galali tange dupame aipuma kaiti-kisa kandalyetaeyaka kalyami? Jisasa doko lanyoo kaiti-kisa pumupa kanjamino, dopaka pyoo baa ipatana” leambi. ");
INSERT INTO enq2_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dopa lateambinopa dokaita Olipimanda lenge dokonya katao Jerusalema pilyiami. Olipimanda doko Jerusalema tengesa singi. Olipimanda pituu Jerusalema pupenge doko, Sambatanya kaita paena lapae singi dopale. ");
INSERT INTO enq2_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalema pyakamatala anda namba pyoo petae ketae mendenya dokaita paliu kateami dokonya peami. Akali dutupa datupa: Pitapi, Jemesapi, Jonepi, Andruapi, Pilipapi, Tomasapi, Batalomyuapi, Matyuapi, Alopiusa ikiningi Jemesapi, Selote tata dokonya katenge Saimonepi, Jemesa ikiningi Judasapi, dutupa. ");
INSERT INTO enq2_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Akali dutupa mona mendai paliu, koteaka lao Goteme nisina lao tee lao loma soo peteami. Peteami dokonya enda mendapupi, Jisasa endangi Mariapi, Jisasanya kaiminingipi, dupa apata peteami. ");
INSERT INTO enq2_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gii dutupanya kambu pyatae dokonya disaipolo 120 joapi mende peteami. Peteami kaina dokonya Pitame toeya katapala dapa lea: ");
INSERT INTO enq2_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kaimii paluma, Jisasa anjala epeamino akali dokaita laminao epeamo akali Judasa doko lao, wamba Oli Spiritame Dapitanya kambunya pii mende lea-pyaana lao, Gotenya pii pepa pyapae singi dokonya singi doko angi jepenge jia. ");
INSERT INTO enq2_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasa doko naima aposole itaki pyapae dutupanya mende, kalai pilyamano dakenya baame apata pina lao makande lateana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judasa dokome koo kalai pia dokonya muni yole nyia dutupame yuu mende sambea. Yuu dokonya baa aiyombame pyakeamosa, kainanya toka latala, ingi dupa pitaka polao kamaka epea. ");
INSERT INTO enq2_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Atome doko Jerusalema katengema endakali dupa pitakame sepae dokonya, nyakamanya piimi yuu doko kenge Akeledama leami. Akeledama dokonya tenge doko Taeyoko Ee.) ");
INSERT INTO enq2_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pitame lao pituu, “Wee Buku dokonya dapa lao pepa pyapae silyamo: ‘Baanya anda dokonya akali mende kalya naeyatamopa, kua katenana’ lapae silyamo. Pii mende dapa lao pepa pyapae silyamoaka: ‘Akali waka mendeme baanya isingi kalai dokonya panda nyina’ lapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Dopa lapae silyamo dokonya, akali mendeme naima nisoo, Kamongo Jisasa malunya sakateana lao pii doko panao lao katapenge jilyamo. Akali doko, Joneme endakali dupanya kaimbu pyakamaiyoo kateamo gii dokonya pituu, Jisasa naima-pipa kateamanopa baa lanyoo kaiti-kisa peamo dokonya tuu lao, naima-pipa paeyamano akali dupanya mende katena lapengena” lea. ");
INSERT INTO enq2_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dopa lateamopa dokaitame Josepe Basabasa, kenge mende Jasatusa lenge dokopa, Matiasa lenge dokopa, dolapo makande laanya yapao nyiami. ");
INSERT INTO enq2_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Dopa petala loma soo pituu, “Kamongo, embame endakali pitakanya mona kandenge. Judasame aposole kalai doko yakinatala, baa pupenge panda dokonya patea. Embame akali dalaponya mende Judasanya panda nyoo aposole kalai doko pina lao yapao nyepate doko embame naima-kisa panasepe” lao loma siami. ");
INSERT INTO enq2_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dokaitame loma sepala, api-kisa kalyape lao kandamana latala kana pyasiaminopa, kana doko Matiasa-kisa ipao katea. Dopa pia dokome, baa 11 aposole dutupanya konda pia. ");
INSERT INTO enq2_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pendekosa gii doko epeamopa, disaipolo Jisasa tungi pingi dupa pitaka mona mendai paliu anda mendainya kambu pyao peteami. ");
INSERT INTO enq2_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Peteaminopa poo kyeto mende lengeli pyoo, kaiti-kisa katao mende lee mendai uu lao ipao anda doko pitaka tumbia. ");
INSERT INTO enq2_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dokopa ita yuli, keke jepae mendapu pyakaeyalu petala, dokaita-kisa mendai-mendai lao peteami. ");
INSERT INTO enq2_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Endakali dokaita-kisa Oli Spirita doko tumbiamopa, Oli Spiritame maiyali pyoo dokaitame tee pyao pii tata waka dupa leami. ");
INSERT INTO enq2_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gii dutupanya kantri dupa pitakanya tange, Gote mambo pingima Juu mendapu Jerusalema kateami. ");
INSERT INTO enq2_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Poo dokome uu leamo doko sepala, endakali dokaita ipao kambu piami. Dokopa endakali kambu piami dokaitanya pii lengemali pyoo disaipolo dupame leamino sepala, aipa petala lelyamipi lao endakali kambu piami dupa tatake kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Endakali dokaita pitakame walu lao paka kaeyapala nyakama-lapo laloo pyoo, “Pii lelyamino dakaita Galali tange daa kandamuape? ");
INSERT INTO enq2_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naima mandeami yuu dupanya pii lengeli pyoo dakaitame laminopa silyamano doko, aipa petala lelyami? ");
INSERT INTO enq2_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Naima Patia tangepi, Midia tangepi, Elame tangepi, Mesopotemia tangepi, Judia tangepi, Kapadosia tangepi, Pontusa tangepi, Esia tangepi, ");
INSERT INTO enq2_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prisia tangepi, Pampilia tangepi, Ijipi tangepi, Libia dokonya Sairini makisa dosa tangepi, yuu dakenya tisa katenge Roma tangepi, Juupi, Juu dupanya lotuu mana miningipi, ");
INSERT INTO enq2_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Krita tangepi, Arabia tangepi, dupa kalyamano. Naimame simanopa, Gotenya kalai andake pia dupa naimanya pii lengeli pyoo lelyaminona” leami. ");
INSERT INTO enq2_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Doko aipa pilyape lao tatake kaeyao walu latala, nyakama-lapo laloo pyoo, “Dakenya tenge doko aki palelyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dopa leaminopa akali yangimi lamba lao, “Endakali dokaita waene enenge longo nalamini-lamona” leami. ");
INSERT INTO enq2_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dokopa Pita baa 11 aposole dutupa-pipa katapala, puu lao endakali dupa lamaiyoo, “Pilyamo dupa pitakanya tenge dupa masalapale nambame langitoo, nyakama akali Judia tangepi, Jerusalema dakenya katengepi, dupa pitakame nambanya pii dupa auu pyoo salapape. ");
INSERT INTO enq2_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Endakali dakaita kyakelyaminona lao nyakamame masilyaminoaka doko, kyakala naelyamino. Indupa yongama gii 9 kiloko lelyamo. ");
INSERT INTO enq2_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Goteme pii mende propeta Joele-kisa lea-pyaana lao pepa pyapae singi dokoaka pilyamo dake. Goteme Joele-kisa lao pituu, ‘Yuu gii etalanya pitamopa, nambanya Spirita doko endakali dupa pitaka-kisa kai lato. Dopa pitopa nyakamanya ikiningipi, wanengepi dupame propesi pii latami. Nyakamanya wane patange dupame lee manemaneme kandatami. Nyakamanya akali lyanga dupame kombeame kandatami. ");
INSERT INTO enq2_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gii dokopa nambanya kalai endapi, kalai akalipi dupa-kisa apata nambanya Spirita doko kai latopa, dupame propesi pii latamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dokopa nambame ketae kaitinya kalai paka pipae mendapu pito. Isa yuu dakenya kalai paka pipae datupa pitoaka: Taeyokopi, ita yulipi, itate kena kopa jepaepi, dupa epena lato. ");
INSERT INTO enq2_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kamongonya gii andake tii pipae doko ene ipanya pitamopa, niki doko iminjetala, kana doko taeyoko pyoo kate pyata. ");
INSERT INTO enq2_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Gii dokopa Kamongome nisina lao baanya kenge doko latami endakali dupa pitaka Goteme pyoo nyetana’ lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nyakama Israele dupame pii datupa salapape: Goteme nyakamanya kainanya kalai kyetopi, kalai paka pipaepi, mirakolopi, dupa Nasarete tange Jisasa doko-kisa piamo dokome, Jisasa baa akali dokona lao panasiamo doko nyakamame masilyamino. ");
INSERT INTO enq2_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tanga pita kandenge Gote dokome dopa pitana lao masiali pyoo, nyakamame Jisasa anjiami. Dopa petala, nyakamame baa pyao kumasemana latala, loo yalenge akali mendapuanya kinginya maiyaminopa, dupame baa pyao yukuiyami. ");
INSERT INTO enq2_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dopa piaminoaka doko, kuminginya pupu lapae dokome kapa pao baa minatae nasepenge dokonyana, kumapala tanda nyingi dupanya nakatena lao Goteme baa malunya sakatasia. ");
INSERT INTO enq2_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","26","Tenge dokonya Dapitame Jisasa lao dapa lea-pyaa: ‘Kamongo doko koteaka lao nambanya enomba dokonya kateamopa kandeo. Dopale mendeme namba walu lasala naena lao, baa nambanya kingi tolaetena kalyamo. Tenge dokonya, nambame baanya nisepae dupa nee kaeyao malisoo katao, nambanya mona andaka auu kaeyao, nambanya kambumi baa mambo pyao kalyo. ");
INSERT INTO enq2_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Embame nambanya lete katenge doko endakali kumapae dupa katengema panda dokonya sina lao kaeyala naeyate. Embanya Akali Makande Latae dokonya yonge doko malunya tamuatale lao kaeyala naeyateaka. ");
INSERT INTO enq2_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Embame lete katenge kaitini dupa namba laitaka petee. Emba koteaka lao namba-pipa katatambanopa, namba-kisa auu kaeyapae andake tumbatana’ Dapitame lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Kaimii paluma, naimanya yumbange Dapita kumiamopa, malu piami dokonya malu doko indupapi petae ae kalyamona lao nambame paka nakaeyao nyakama langilyo. ");
INSERT INTO enq2_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dapitanya mandipaenya mandipae Kraisa doko Dapitanya kiŋi toko dokonya pititamopa lao, Goteme baanya pii doko kyeto tasoo lea doko Dapitame masia-pyaa. Dapita baa propeta dokonyana, ");
INSERT INTO enq2_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","dopa pitana lao wambao kandatala, Kraisa doko malunya sakatatana lao pii dutupa lea-pyaa. Kraisanya lete katenge doko endakali kumapae dupa katengema panda dokonya sina lao kaeyala naeyatamopa, baanya yonge doko malunya tamuala naeyatakana lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jisasa dokoaka Goteme malunya sakatasiamopa kandeama dupa pitakame lao panelyamano. ");
INSERT INTO enq2_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Goteme baanya kingi tolaetena katena lao Jisasa baa kaiti-kisa lanyoo pea. Dopa petala Takange Goteme Oli Spirita maitona lea doko Jisasame nyepala kai lamupa, indupa nyakamame kandaowaka, soaka pilyamino dake. ");
INSERT INTO enq2_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dapita baa kaiti-kisa lanyoo napeaka doko, baame pii dake lea-pyaa: ‘Kamongome nambanya Kamongo doko lamaiyoo, “Emba nambanya kingi tolaetena piti. ");
INSERT INTO enq2_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Dokonya pititinopa, nambame embanya yandapipi dupa embanya moko setenge toko jina latona” leana’ lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nyakama Israele dupa pitakame pii dake auu pyoo sepala, kiningi-lumu lao masokondape pyoo masalapape: Nyakamame pyao yukuiyamino akali Jisasa doko, Goteme Kamongo katao, Kraisa katao pina leana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitame pii lea doko siaminopa, pii dokome endakali dupanya monanya pyao miniamosa, dokaitame Pitapi, aposole yangipi dupa lamaiyoo, “Kaimii paluma, naima aipa pimape?” leami. ");
INSERT INTO enq2_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dopa leaminopa Pitame dokaita lamaiyoo, “Nyakama pitaka Oli Spirita doko Goteme mee ditamopa nyalapalena, nyakama mona kapilyetala nyakamanya koo dupa kunao nepekena, Jisasa Kraisanya kenge dokonya kaimbu nyalapa. ");
INSERT INTO enq2_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Goteme Oli Spirita doko ditona lao pii lanya setea doko nyakamapi, nyakamanya wanepi, yuu etete londati tangepi, naimanya Kamongo Gote dokome wii lao nyeta endakali dupa pitakanya lao lanya setea-pyaana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitame pii longo mendapuame endakali dupa mona sakatasoo lao panao, “Endakali koeyapae indupa palelyamino dupa-pipa nyakama apata koeyatamina, nyakamame dokaita wandyoo kalyepape” lao kyeto joo lea. ");
INSERT INTO enq2_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Baanya pii doko auu kaeyao siami dupa kaimbu nyiami. Yuu gii dokopa endakali tausene tepomapi mende Jisasa tungi pingi endakali dupanya konda piami. ");
INSERT INTO enq2_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Dopa petala, endakali dokaitame yakinala naeyao aposole dupa-kisa pii mana nyoo, mona setao katao, breta konjoo nao, loma soo, pyasoo kateami. ");
INSERT INTO enq2_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposole dupame kalai paka pipaepi, mirakolopi, longo mendapu piaminopa kandatala, endakali dupa pitaka walu lao paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Dokopa Jisasa tungi pingima endakali dupa pitaka koteaka lao kambu pyatapu, dokaitanya oapi dupa pitaka andange lao setao kateami. ");
INSERT INTO enq2_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dopa pyoo katao, dokaitanya oapipi, yuupi dupa salimi latala muni nyiami dupa endakali daa jia dupa pitaka mokosoo maiyoo kateami. ");
INSERT INTO enq2_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dokaita lotuu anda nee nyetae kamapu dokonya koteaka lao ipao kambu pyatapu, andaka dupanya pupala breta konjoo nao, mona lapo napaliu, mona yaepao kateami. ");
INSERT INTO enq2_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dopa pyoo katao dokaitame Gote mambo piaminopa, endakali dupa pitakame dokaita auu kaeyami. Kamongome koteaka lao endakali longo pyoo nyepa piamopa, dokaita siosa dokonya konda peta piami. ");
INSERT INTO enq2_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Loma singi gii, alemandi 3 kiloko dokonya Pitapa, Jonepa lalyoo, lotuu anda nee nyetae kamapu dokonya peambi. ");
INSERT INTO enq2_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dokopa, akali mende endangimi mandea gii dokonya pituu, moko takyepae mende kamapu dokonya pisalanya soo epeami. Lotuu anda nee nyetae kamapu dokonya pyakamelyami endakali dupa-kisa baame muni akipi tee lena lao, akali mendapuame baa lotuu anda nee nyetae lome kambu, Auu Pipae lenge dokonya koteaka lao soo ipao pisingima. ");
INSERT INTO enq2_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Akali dokome Pitapa, Jonepa lotuu anda nee nyetae kamapu dokonya pyakamalanya piambino kandatala, muni dina lao tee lea. ");
INSERT INTO enq2_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tee leamopa, Pitapa Jonepame akali doko kandatae sepala, Pitame lao pituu, “Embame nalimba kanda” lea. ");
INSERT INTO enq2_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dokopa dolapome baa mende ditambinopa nyotoana lao masetala kandakondape pyoo kandatae sia. ");
INSERT INTO enq2_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dokopa Pitame lao pituu, “Namba-kisa golopi, silipapi dupanya mende nasilyamo. Dopaka doko, namba-kisa mende silyamo doko emba ditoo: Nasarete tange Jisasa Kraisanya kenge dokonya emba sakatatala kaita puu” lea. ");
INSERT INTO enq2_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dopa latala, akali dokonya kingi tolaetena minalyetala toeya katasulu piamopa, baanya mokopi, moko lengepi dupa kyeto jakamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Dopa piamopa, baa yapa sakatao toeya katapala, tee pyao kaita paeya. Baa akali dolapo-pipa lotuu anda nee nyetae kamapu dokonya apata pao pituu, baame mangau lao Gote mambo pia. ");
INSERT INTO enq2_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Akali dokome Gote mambo pyao kaita peamopa, endakali dupa pitakame kandatala, ");
INSERT INTO enq2_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","akali doko lotuu anda nee nyetae lome kambu, Auu Pipae lenge dokonya pitipala muni akipi tee lao petenge doko-lamo lao masiami. Baa-kisa petae epeamo doko kandatala, dokaita etete walu lao paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Akali moko auu pyakamaiya dokome Pitapa, Jonepa kii minatae katao peamopa, endakali dupa pitakame kandatala walu lao paka kaeyami. Dopa petala, lotuu anda nee nyetae dokonya veranda, Solomonenya lenge dokonya endakali dupa pitakame alo pyao kanja epeami. ");
INSERT INTO enq2_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kanja epeamino doko Pitame kandatala endakali dupa lamaiyoo, “Nalimbanya kyetopi, Gotenya mana dokonya katengepi, mendeme akali dake kaita paena lambipi lao masetala, nyakama akali Israele dupame aipuma walu latala nalimba kandatae silyami? ");
INSERT INTO enq2_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraamepi, Aisakepi, Jekopepi, naimanya yumbangepi, dupanya Gote dokome baanya kalai akali Jisasa doko kenge andake maiya. Jisasa doko nyakamame anjoo Pailata maiyaminopa, baame mokatoo lao masia. Dopa lao masiamopa, Pailatanya enomba dokonya nyakamame Jisasa daa leami. ");
INSERT INTO enq2_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dopa leami dokome, Gotenya Makande Latae, Akali Tolatae doko nyakamame daa leami. Dopa latala, akali pyao kumasingi mende mokokena lao Pailata tee leami. ");
INSERT INTO enq2_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dopa latala, akali lete katengenya tenge doko nyakamame pyao kumasiami. Pyao kumasiamino akali doko Goteme malunya sakatasia. Sakatasia doko nalimbame lengeme kandatala dokonya lao, nalimbame lao panao kalyambano. ");
INSERT INTO enq2_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nalimbame Jisasanya kenge doko tungi pyambu dokome, nyakamame kandengema akali dake Jisasanya kenge dokome auu pisalamo. Jisasa tungi pingi dokonya-kaita nyakama pitakanya enombanya akali dake auu pyaa-kao pyomo. ");
INSERT INTO enq2_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Kaimii paluma, nyakamanya isingi akalipi, nyakamapimi Jisasa-kisa piamino doko, masala naeyao piamina lao nambame masilyo. ");
INSERT INTO enq2_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dopaka doko, Kraisa doko tanda andake nyetana lao, wamba-waka Goteme baanya propeta dupa pitaka-kisa lealiaka pyoo angi jina lea. ");
INSERT INTO enq2_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Dopa piana, Goteme nyakamanya koo dupa kunao nepekena, nyakama mona kapilyetala, baa kalyamo dokonya pupape. Dokopa nyakama kyeto nyoo auu kaeyapae kalyepale lao, nyakamanya lao makande lekea Jisasa Kraisa doko epena latamopa, Kamongonya enomba dokonya katao baa ipata. ");
INSERT INTO enq2_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Goteme dupa pitaka enenge joo eteteaka auu pisotona lao, wamba-waka baanya propeta makande latae dupa pitaka-kisa pii lanya setea-pyaa. Dupa pitaka enenge jiseta gii doko malisoo, Kraisa baa kaiti-kisa katapenge. ");
INSERT INTO enq2_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosesame naimanya yumbange dupa lamaiyoo, ‘Naimanya Kamongo Goteme namba propeta makande leamoli pyoo, nyakamanya kaiminingi dupanya mende propeta makande lakata. Makande lakata akali dokome pii langita dupa pitaka nyakamame sakamaiyepape. ");
INSERT INTO enq2_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Propeta dokonya pii sakamaiya naeyatami endakali dupa pitaka Goteme baanya tata dupa-pipa nakatena lao pyao nepatana’ lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Propeta Samuelepi, propeta maitakao kateamipi, dupame apata gii datupanya pilyamo dupa pitana lao leamiaka-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nyakama propeta dupanya mandipaenya mandipae dupa kalyamino. Goteme Abraame lamaiyoo, ‘Embanya mandipaenya mandipae mende-kisa yuunya akali tata palitami dupa pitaka nisepae nyetamina’ lea-pyaa. Goteme nyakama apata masetala, naimanya yumbange dupa-kisa pii doko lao yaki pinya setea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyakamanya koo dupanya nyakama mendai-mendai lao mona kapilyalapale lao Goteme nyakama nisetala, auu pisotopa lao baanya kalai akali Jisasa doko nyakama-kisa wambao epena leana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitapa Jonepame endakali dupa pii lamaiyoo kateambinopa, prisapi, lotuu anda nee nyetae dokonya yanda singi mupa dokopi, Sadyusipi dupa epeami. ");
INSERT INTO enq2_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ipupala kandeaminopa, Pitapa Jonepame endakali dupa mana lamaiyoo, “Jisasa malunya sakateana, endakali dupa malunya sakatatamiakana” leambinosa, dokaita etete imbu kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Imbu kaeyapala akali dolapo minatala anjiami. Dokopa yuu kuiyala peamosa, taita kotimi latamana latala anjetae palenge anda dokonya anjinya palyiami. ");
INSERT INTO enq2_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Dopaka doko, Pitanya pii siami dupanya endakali longome pii doko kiningina lao masetala, Jisasa tungi piami. Jisasa tungi piami akali dupanya kindi doko tausene yungipi mende jia. ");
INSERT INTO enq2_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yuu gii mende dokonya Juu dupanya isingi akalipi, Juu dupanya akali angipi, Mosesanya loo mana nyepaepi, dupa Jerusalema kambu piami. ");
INSERT INTO enq2_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kambu dokonya prisa mupa Anasapi, Kaeyapasapi, Jonepi, Alekesandapi, prisa mupa dokonya tata dupa pitakapi, dupa peteami. ");
INSERT INTO enq2_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Peteami kaina dokonya Pitapa Jonepa nyoo katasetala dokaitame tipa pyoo, “Kyeto aipale mendemepi, kenge aipale mendemepi, nyakambame dake pimbipi?” leami. ");
INSERT INTO enq2_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Dopa leaminopa, Pita-kisa Oli Spiritame tumbiamopa baame dokaita lamaiyoo, “Akali moko takyepae dake-kisa kalai epe mende pipya dokonya, nyakama Juu dupanya isingi akalipi, Israele dupanya akali angipi, dupame indupa nalimba nyoo katasetala, baa aipa petala auu pipyape lao tipa pilyamino doko, ");
INSERT INTO enq2_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nyakamapi, Israele dupa pitakamepi pii dake sepala masalapape: Nasarete tange Jisasa Kraisa, nyakamame poko itanya pyao yukuiyamino doko, Goteme malunya sakatasiamo dokonya kenge dokome akali dakenya moko dolapo auu petamupa, baa nyakamanya enombanya kalyamo. ");
INSERT INTO enq2_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nyakama anda pingima dupame anda pipenge kana mende koeyapae-lamo latala yakineami doko, kana mupa jetelyamo. Kana mupa jetelyamo doko baa Jisasa. ");
INSERT INTO enq2_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Endakali waka mendenya kengenya Goteme naima pyoo nyala naenge. Jisasanya kenge dokonya iki Goteme naima pyoo nyingina” lea. ");
INSERT INTO enq2_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dokopa Pitapa Jonepa sukulu nalenge dolapome paka nakaeyao pii leambi doko akali dokaitame kandatala walu lao paka kaeyami. Paka kaeyapala, akali dolapo Jisasa-pipa kateamina lao masiami. ");
INSERT INTO enq2_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Akali moko auu pyakamaiya doko akali dolapo-pipa kateamino kandatala, Pitanya pii doko tanga lao, dokaitame pii mende lapenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dopa piamosa, akali dolapo kambu pingi anda dokonya kamaka pyakalyina latala, nyakama-lapo lao pituu, ");
INSERT INTO enq2_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Akali dolapome mirakolo andake doko pimbinopa, Jerusalema katengema dupa pitakame kandamino dokonya, sambona lao tanga laa naeyamana, naimame akali dolapo aipa pima? ");
INSERT INTO enq2_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mirakolo pimbino doko lao taeyala naena, akali dolapome Jisasanya kenge dokonya endakali mende dee pii lamaiya naena lao kyeto joo pyalanya lamana” leami. ");
INSERT INTO enq2_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dokopa akali dolapo epena latala, Jisasanya kenge dokonya pii manapi etete kukipi mende lamaiya naena lao daa leami. ");
INSERT INTO enq2_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dopa leaminopa, Pitapa Jonepame dokaitanya pii yanu pyakamaiyoo, “Nalimbame nyakamanya pii doko sepala wata-minatambano doko Goteme yakana lao masilyape, pande baanya pii doko sepala wata-minatambano doko yakana lao masilyape lao nyakamame yapalapa. ");
INSERT INTO enq2_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nalimbame kandeambapi, siambapi dupanya nenge-kaita piti petala, kapa pao mee kalya naeyalambanona” leambi. ");
INSERT INTO enq2_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Akali moko takyepae auu pisakamaiyambi doko ee kana 40 yalatae. Tenge dokonya, baa auu pisakamaiyambinona lao endakali dupame masetala, Gote mambo piami. Mambo piaminosa, akali dolapo tanda maipenge kaitini mende kandao nanyepala, deaka kyeto joo pyalanya latala pena kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dokaitame Pitapa Jonepa pena kaeteaminopa, dolapo nyakambanya Kristene yango dupa kateami dokonya pilyetala, prisa mupapi, isingi akalipi dupame pii leami dupa pitaka lamaiyambi. ");
INSERT INTO enq2_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lamaiyambinopa sepala dokaita pitaka mona mendai paliu, Gote kenge minalyoo dapa lao loma siami: “Akali Andake, yuupi, kaitipi, endakipi, dupanya singipi, dupa pitaka pyoo wasingi Gote doko emba. ");
INSERT INTO enq2_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Embanya kalai akali Dapita-kisa embame dapa lee-pyaa: ‘Aipuma akali tata waka dupame pyamana lao etete imbu kaelyami? Angi nanjepenge kyakaenge dupanya aipuma depa lelyami? ");
INSERT INTO enq2_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yuunya kiŋipi, yuunya isingi akalipi, dupa kambu pyatala, Kamongopa, baanya Akali Makande Latae dokopa, dolapo yanda pimaiyanya pilyaminona’ lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Erotepi, Pondiasa Pailatapi, akali tata wakapi, Israelepi, dupame embanya kalai akali, aiyomba minani pyoo makande latae Jisasa doko pyamana lao kiningi kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dopa pitamina lao, embanya kyetopi, masepae epepi dupame wamba depa lee dokonya-kaitaka piami. ");
INSERT INTO enq2_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dopana, indupa naima pyalanya pilyamino doko Kamongo embame kandape. Naima embanya kalai akali dupame etete paka nakaeyao, embanya pii doko lamaiyakamana kyeto dipi. ");
INSERT INTO enq2_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Embanya kalai akali makande latae Jisasanya kenge dokonya yaina mee jepengepi, mirakolo pipengepi, kalai paka pipae dupa pipengepi, dupanya Kamongo embanya kingi doko panasepe” lao loma siami. ");
INSERT INTO enq2_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Loma sepeaminopa, kambu pyao peteami anda doko ema-ema pia. Dokopa Oli Spiritame dokaita pitaka-kisa tumbateamopa, paka nakaeyao Gotenya pii doko lamaiyami. ");
INSERT INTO enq2_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisasa tungi pingima endakali dupa pitaka gii dokopa mona mendai paliu, mendeme dopale mende baanya ikina laa naenya, dokaitanya oapipi dupa pitaka andange setao kateami. ");
INSERT INTO enq2_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Dopa pyoo katao, Kamongo Jisasa malunya sakateana lao, aposole dupame kyeto joo lao paneaminopa, Gotenya kondo kaenge andake doko dokaita pitaka-kisa sia. ");
INSERT INTO enq2_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Endakali mendenya yuu andapi sia dupa salimi latala, muni nyiami dupa nyoo ipupala, aposole dupanya moko seteami dosa setapa piami. Dokopa aposole dupame nyepala, endakali daa jia dupa pitaka mokosoo maiyami. Dopa piami dokome, dupanya kainanya endakali daa jingi mende nakatea. ");
INSERT INTO enq2_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Gii dokopa akali Lipai, Saiprusa tange Josesa lenge mende katea. Aposole dupame baa kenge Banabasa leami. (Banabasa dokonya tenge doko, Mona sakatasakamaingi akali.) ");
INSERT INTO enq2_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Banabasame baanya yuu mende salimi latala, muni nyia dutupa nyoo ipupala, aposole dupanya moko seteami dosa setea. ");
INSERT INTO enq2_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Akali Ananiasa lenge mendepa, baanya etanenge Sapaita lenge dokopa, dolapome yuu mende salimi latala muni nyiambi. ");
INSERT INTO enq2_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dolapo pii mendai latala, muni nyiambi dokonya yangi tange nyoo andaka setapala, yangi Ananiasame mandyoo pupala, aposole dupanya moko seteami dosa setea. ");
INSERT INTO enq2_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dopa peteamopa Pitame baa lamaiyoo, “Ananiasa, embame aipuma Satane ipao monanya tumbina kaeyapala, yuu salimi latala muni nyipi dokonya mendatupa tange nyepala, Oli Spirita doko sambo lamaiye? ");
INSERT INTO enq2_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Embanya yuu doko salimi laa naengesa, yuu doko embanya daa kandamuape? Yuu dokonya muni nyipi dutupa, embanyaka daa kandamuape? Aipuma embame koo doko pitoana lao moname masipi? Embame pipi-lamo dokome, endakali mende sambo lamaiya naeyapi. Gote sambo lamaipina” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasame pii dutupa sulu pituu, baa lombapae sepala kumalu pia. Kumalamo lapae siami endakali dupa pitaka etete paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dokopa wane patange mendapu ipupala, baanya yonge doko nyoo yaki petala, soo malu pyaa peami. ");
INSERT INTO enq2_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Maitakao, awa tepomapi mende pateamopa, Ananiasanya etanenge dokome Ananiasa kumalamo lao masala naeyao ipupala andaka kolandea. ");
INSERT INTO enq2_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kolandateamopa Pitame baa lamaiyoo, “Embame namba langi. Nyakambanya yuu doko salimi latala muni datupaka nyimbipi?” lea. Dopa leamopa enda dokome lao pituu, “Kiningi, dutupaka nyimbana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dokopa Pitame baa lamaiyoo, “Nyakambame aipuma pii mendai latala, Kamongonya Spirita doko makande pimbi? Embanya akalingi malu pyaa pamino dupa anda kambusa ipatelyaminona, dupame emba apata kamaka soo paaminoakana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pitame dopa lalu piamopa, enda doko Pitanya moko setea dosa lombapae sepala kumaluaka pia. Dokopa wane patange dupa andakote ipupala, kumapae siamo doko kandatala, nyoo kamaka pupala, akalingi malu petae katea dosaka malu piami. ");
INSERT INTO enq2_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dopa pyomo lapae doko sepala, siosa dokopi, endakali wakapi, dupa pitaka etete paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Paa longosa aposole dupame mirakolopi, kalai paka pipaepi, dupa endakali dupanya kainanya piami. Dopa piaminopa, lotuu anda nee nyetae dokonya, veranda Solomonenya lenge dokonya Jisasa tungi pingima dupa pitaka kambu pyata piami. ");
INSERT INTO enq2_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dokopa Jisasa tungi napingima dupame Jisasa tungi pingima dupanya kenge minalyiamiaka doko, Jisasa tungi napingima dupa paka kaeyapala, dokaita konda napiami. ");
INSERT INTO enq2_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dopaka doko, endapi, akalipi longome Kamongo tungi piaminopa, kindi doko etete andake jia. ");
INSERT INTO enq2_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pita ipao patamopa baanya waiyenge dokome yaina pyapae dupa yalena lao masetala, endakali dupame yaina pyapae dupa soo ipupala, palenge tokopi, metapi dupanya kaitini lemba dupanya setapa piami. ");
INSERT INTO enq2_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalema tengesa taono yakane singi dupanya, endakali yaina pyapaepi, imambu koome kenda pisetaepi, dupa endakali longo mendapuame soo ipao kambu piaminopa, dupa pitaka auu piseta pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dokopa prisa mupa dokopi, baa-pipa katenge kambu yakane Sadyusi lenge dokopi, dupa pitakame aposole dupa etete tilya nyiami. ");
INSERT INTO enq2_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tilya nyepala dupame aposole dupa anjetala, siti dokonya anjetae palenge anda dokonya pyandeami. ");
INSERT INTO enq2_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dopa peteaminopa, kuakama Kamongonya enjele mende ipupala, anjetae palenge anda dokonya kaita dupa lumbapala, aposole dupa laminao kamaka pyakalyia. Laminao pyakalyetala dokaita lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nyakama lotuu anda nee nyetae kamapu dokonya pupala, lete katapenge dokonya pii dupa pitaka endakali dupa lamaiyoo kalyepape” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pii leamo doko sepala, yongama wamba aposole dupa lotuu anda nee nyetae kamapu dokonya pupala, endakali dupa mana lamaiyoo kateami. Dokopa prisa mupa dokopi, baanya tole katengepi, dupame kanjolepi, Israelemanya isingi akalipi, dupa pitaka epena latala kambu piami. Kambu piamino dokonya aposole dupa laminao epena latala, lanyala pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dokopa anjetae palenge anda dokonya yanda singi dupa ipao pyakaeyaminopa, aposole dupa anjetae napaleaminosa, kutao kaeyapala, kambuiyami dokonya pilyetala dapa leami: ");
INSERT INTO enq2_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Anjetae palenge anda dokonya naima pupala kandamanopa, yanda singi dupa kataminopa, kaita dupa loko pyakondape pyatae katalamo. Dopa petae katamupa, naimame kaita dupa lumbapala andakote kolandao kandamanopa, mende napalyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dopa leamino pii dutupa sepala, pyome-lamo doko aipa pyaanya pyaape lao lotuu anda nee nyetae dokonya yanda singi mupa dokopi, prisa mupapi, dupa tatake kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dokopa akali mende ipupala dokaita lamaiyoo, “Salapape! Akali mendapu nyakamame anjinya pyandamino dupame lotuu anda nee nyetae kamapu dokonya endakali dupa mana lamaiyoo kalyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dokopa, yanda singi mupa dokopi, yanda singi baame isingipi, dupa lotuu anda nee nyetae dokonya pupala aposole dupa laminao epeami. Endakali dupame nyakama kaname pyatamini-lao masetala, pata-pata lao laminao epeami. ");
INSERT INTO enq2_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ipupala kanjole dupanya enombanya katasiaminopa, prisa mupa dokome aposole dupa tipa pyoo, ");
INSERT INTO enq2_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Akali dokonya kenge dokonya nyakamame mana lamaiya naeyalapape lao naimame daa laa naeyamuape? Daa lamuano doko nepatala, nyakamanya mana lelyamino doko lao, Jerusalema yuu dakenya taeyatalamino dokome, akali dokonya taeyoko doko naima-kisa katena lamana lao masetala lelyaminona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dopa leamopa Pitapi, aposole yangipi dupame baanya pii yanu pyakamaiyoo, “Naimame endakalinya pii wata-minala naeyapenge. Gotenya pii doko wata-minapenge. ");
INSERT INTO enq2_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nyakamame poko itanya pyao yukuiyaminopa kumiamo akali Jisasa doko naimanya yumbange dupanya Gote dokome sakatasia. ");
INSERT INTO enq2_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israele tata dupa mona kapilyetaminopa, dupanya koo dupa kunao nepakamaitopa lao Goteme baa sakatasetala, kaiti-kisa lanyoo pea. Pupala baanya kingi tolaetena Isingi Akalipa, Pyoo Nyingi Akalipa petena lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Goteme Jisasa-kisa piamo dupa pitaka naimame lao panelyamano. Goteme lelyali pingima endakali dupa maiyamo, Oli Spirita doko apata naima-pipa katao lao panelyamanona” leami. ");
INSERT INTO enq2_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pii leami doko sepala dokaita imbu kaeyapala, aposole dupa pyao kumasemana lao masiami. ");
INSERT INTO enq2_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dopa lao masiaminopa, Mosesanya loo dupanya mana lelyamopa anda-anda semaingima, Gamaliele lenge, Parasi mende kanjole kambu piami dokonya toeya katapala, aposole dutupa lanyoo gii kuki mende kamaka kalya pena lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dopa latala baame kanjole dupa lamaiyoo, “Nyakama Israele dupame akali dutupa mende pimana lao masilyamino doko, masokondape petala pyepape. ");
INSERT INTO enq2_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wambale dosa akali Teudasa lenge mendeme baa akali andake mende kalyona lao kateamopa, akali 400-api mendeme baa konda piami. Teudasa pyao kumaseteaminopa, baa watao paeyamino endakali dupa pitaka tale peteaminopa, kalai piamino dupa etea. ");
INSERT INTO enq2_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dopa peteamopa, maitakao gapomaneme endakali dupanya kenge pepa pyao setena leamo gii dokopa, akali Galali tange Judasa lenge dokome endakali longo nyoo kambu pyatala, gapomane yanda pimaiya. Dokopa baa apata pyao kumaseteaminopa, baa watao paeyamino endakali dupa pitaka tale piamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Dopa piana, indupa nambame nyakama dapa langilyo: Akali kamaka kalyamino dutupame kalai pilyaminopi, pimana lao masilyaminopi, dupa endakalinya-tamo doko, isa paapomo. Kalai dupa Gotenya-tamo doko, nyakamame kapa pao isa pyandala naeyalamino. Dopana, aopyoo latala nyakamame Gote yanda pimaitamina, akali dutupa mende napinya katena kaeyalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dopa lateamopa, kanjole dupame baanya pii doko sakamaiyami. Sepala kanjole dupame aposole dupa andakote epena latala, konjame pyao indiami. Dopa petala, dokaitame Jisasanya kenge dokonya pii mende laa naena lao daa latala, pena kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jisasanya kenge doko lao panamanopa, kanjole dupame nyakama kenge koo dimi. Dopa piminopa, Goteme yaka lapya-lamona lao aposole dupame masetala, kanjole dupa yakinatala eteke pyao peami. ");
INSERT INTO enq2_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pupala lotuu anda nee nyetae kamapu dokonyapi, anda mendenya tuu lata-lata pyoo, yuu gii dii lao dokaitame Jisasa baa Kraisa dokona lao wai pii epe doko kaeyala naeyao mana lamaiyoo kateami. ");
INSERT INTO enq2_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Gii dosa disaipolo dupa longo jia. Dokopa, yuu gii dii lao nee mokosiami dokonya Giriki pii lenge dupanya enda walyakae dupa Ibru pii lenge dupame auu pyoo nee namaiyaminosa, Giriki pii lenge dupame mumu leami. ");
INSERT INTO enq2_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dopa leaminopa, aposole 12 dutupame disaipolo dupa pitaka epena lao kambu pyatala dapa leami: “Naimame nee mokosoo katamana latala, Gotenya wai pii epe lamaipenge doko yakinatamano doko auu napita. ");
INSERT INTO enq2_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dopana, kaimii paluma, nyakamanya akali kenge epe singi, masepae epe palenge, Spirita dokome tumbatae kalange makande lapa. Akali dutupame nee mokosingi kalai doko isoo katena lamana. ");
INSERT INTO enq2_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dokopa naimame yakinala naeyao loma soo katao, Gotenya pii doko lamaiyoo katamanana” leami. ");
INSERT INTO enq2_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dopa leaminopa, endakali kambu pyatae peteami dupa pitakame pii dutupa sepala auu kaeyami. Auu kaeyapala, aposole dupame leamiliaka pyoo, Jisasa tungi pingi, Oli Spiritame tumbatae akali Stipene lenge doko yapao nyiami. Dopa petala Pilipapi, Prokolasapi, Nikanoapi, Timonepi, Pamenasapi, Juu dupanya lotuu mana dupa miningi Antioko tange Nikolasapi, dutupa apata yapao nyiamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Akali dutupa aposole dupanya enombanya laminao epeaminopa, aposole dupame dutupa-kisa kingi setao loma sakamaiyami. ");
INSERT INTO enq2_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jerusalema dokonya Gotenya pii doko lao taeyaminopa, disaipolo dupa etete longo jema-jema pia. Dokopa prisa longo mendapuame Jisasa tungi pyatala, baanya pii dupa wata-minao kateami. ");
INSERT INTO enq2_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gotenya kondo kaengepi, kyetopi dupa Stipene-kisa tumbiamopa, kalai paka pipae andakepi, mirakolopi, dupa endakali dupanya enombanya pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Dokopa lotuu anda kenge Akali Mokopae lenge dokonya katengemapi, Sairini tangepi, Alekesandria tangepi, Silisia tangepi, Esia tangepi, mendapu sakatatala, Stipene-pipa pii yanda piami. ");
INSERT INTO enq2_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dopa piamiaka doko, Gotenya Spirita dokome Stipene masepae epe maiyamopa, pii tenge andake palipae mendapu lea. Dokopa akali dokaitame kapa pao baa ita minapenge nanjia. ");
INSERT INTO enq2_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Dopa piamosa, dokaitame waa katao endakali mendatupame dapa lena leami: “Naimame simanopa akali dakeme Mosesapa, Gotepa dolapo lao nepapyana” lena leami. ");
INSERT INTO enq2_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Lena leamili pyoo lateaminopa, dokaitame isingi akalipi, Mosesanya loo mana nyepaepi, mee endakalipi, dupa ingi tuu lasiami. Dopa piaminosa, dupame Stipene anjetala laminao, kanjole dupa-kisa peami. ");
INSERT INTO enq2_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pupala sambo lenge akali mendapu lanyepala sambo lena leaminopa, dupame dapa leami: “Panda nee nyetae dakepa, Mosesanya loo dupapi, dupa kaeyala naeyao akali dakeme lao nepenge. ");
INSERT INTO enq2_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Naimame simanopa baame dapa lapya: ‘Nasarete tange Jisasa dokome panda dake koeyasoo nepatala, Mosesame naimanya mana setekeamo dupa aloo pitana’ lapyana” leami. ");
INSERT INTO enq2_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dokopa kanjole peteami dupa pitakame Stipene kandakondape pyoo kandeaminopa, baanya lenge-lyaapi doko enjele mendenya lenge-lyaapi jia. ");
INSERT INTO enq2_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dokopa prisa mupa dokome Stipene lamaiyoo, “Emba-kisa tenge setao pii lelyamino datupa kiningipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dokopa Stipeneme lao pituu, “Kaimii palupi, apane palupi, nyakamame salapape. Naimanya yumbange Abraame baa Arane yuu dokonya ene paanya, Mesopotemia kateamopa, Gote etete tii pipae doko baa katea dokonya ipao panea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dopa petala Abraame lamaiyoo, ‘Embanya yuupi, embanya tatapi, dupa yakinao yuu mende nambame laitaka pito dokonya pupi’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Dopa lateamopa, Abraame baa Kalidia dupanya yuu doko yakinatala pao, Arane katea. Siti dokonya baanya takange kumateamopa, Goteme baa laminao nyakama indupa kalyamino yuu dakenya epea. ");
INSERT INTO enq2_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Goteme yuu kukipi mendalapo Abraamenya jina lao baa maiya naeya. Gii dokopa, Abraame baa wane manja naeyao kateaka doko, Goteme baapi, baanya mandipaenya mandipaepi, dupa yuu dake dupanya jina lao kiningi maitona lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Goteme dapa lea: ‘Abraamenya mandipaenya mandipae dupa wakamanya yuu mendenya tisa katatami. Dokopa ee kana 400 dutupanya dokaita kendemane katataminopa, yuu tange dupame dokaita koeyasetami. ");
INSERT INTO enq2_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dopa petataminopa, dokaita kendemane nyiami akali tata dupa koo piamina latala, nambame dupa-kisa tenge setapala tanda maito. Dopa petatopa, Abraamenya mandipaenya mandipae dupa yuu doko yakinao yuu dakenya ipupala, namba mambo pyatamina’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dopa latala Goteme Abraame-kisa pii mende lao yaki pia dokome wane dupanya yanu kepakamaina lea. Dokonya Abraameme Aisake mandipala yuu gii tukulapo leamopa, wane dokonya yanu kepakamaiya. Maitakao Aisakeme Jekope mandea. Jekopeme naimanya yumbange 12 dutupa mandea. ");
INSERT INTO enq2_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Naimanya yumbange dupame Josepe tilya nyepala, kendemane katena latala salimi leaminopa, baa sambao nyoo Ijipi peami. Nyoo peamiaka doko, Gote baa-pipa tole katea. ");
INSERT INTO enq2_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kenda andake mendapu Josepe-kisa epea dupa pitakanya Goteme baa nisia. Ijipi yuu dokonya kiŋi Pero dokonya enombanya Goteme Josepe kondo kaeyao, masepae epe maiya. Dopa piamopa, Ijipi yuu dokopi, Peroanya yuu andapi, enda wanepi, dupa pitaka isoo katekena lao, Peroame Josepe baa gapena makande lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Gii dokopa, Ijipi yuu doko pitakapi, Kenane yuu doko pitakapi, lopo andake mende sia dokome, endakali dupa tanda andake nyiami. Dokopa nee daa jiamopa, naimanya yumbange dupame nee kutiami. ");
INSERT INTO enq2_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kutiaminopa Ijipi yuu dokonya wita silyamo lapae doko Jekopeme sepala, wambao naimanya yumbange dupame sambala pena lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dopa petala lapo pyoo peaminopa, Josepeme baa dokaitanya kaiminingi dokona lao, lao panea. Dokopa Peroame dokaita Josepe tata-lamo lao kandao nyia. ");
INSERT INTO enq2_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dokopa Josepeme baanya takange Jekopepi, baanya takangenya palu dupa pyasoo 75 dutupa pitakapi, dutupa lanyoo Ijipi epena lao wai lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dokopa Jekope baa Ijipi yuu dokonya lanao pupala, dokonya katao baa kumia. Naimanya yumbange dupa dopaka pyoo yuu dokonya katao kumiamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Maitakao dupanya yonge dupa nyoo Sekeme pilyetala, Abraameme kananda mende Sekeme takange Amo dokonya wane dupa-kisa silipa muni mendatupame sambao nyia dokonya malu piami. ");
INSERT INTO enq2_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Goteme mende pitona lao Abraame lamaiya pii doko kyeto tasoo angi jalanya tengesa piamopa, Jekope tata Ijipi kateami dupa longo jia. ");
INSERT INTO enq2_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Maitakao, Josepe baa apipi lao masala naenge, kiŋi waka mendeme Ijipi yuu doko isoo katea. ");
INSERT INTO enq2_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kiŋi dokome wane ŋaŋa dupa nakatena lao masetala, naima tata dupa-kisa mana etete koo dupa minao, naimanya yumbange dupame wane ŋaŋa dupa mandyoo nepena lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Gii dokopa wane Mosesa doko endangimi mandea. Wane doko baa Gotenya enombanya kalya-akali mende. Baanya endangimi baa andu maiyoo, kana tepo dutupanya baanya takangenya andaka isia. ");
INSERT INTO enq2_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kana tepo dutupa pateamopa, wane Mosesa doko nyoo kamaka seteamopa, Pero wanenge dokome kandao nyepala baanya ikiningi joo isia. ");
INSERT INTO enq2_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Dokopa Ijipi tange dupanya mana dupa pitaka sukulu lamaiyaminopa, Mosesame nyoo etea. Etapala baame kyeto joo pii lao, pupu lao kalai pyoo katea. ");
INSERT INTO enq2_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Dopa pyoo kateamopa Mosesa baa ee kana 40 lea. Dokopa baa tata Israele dupa nee kaeyapala kanja patoo lao moname masia. ");
INSERT INTO enq2_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dopa lao masetala peamopa, Ijipi tange mendeme Israele mende pyao indiamo kandea. Kandatala akali kenda nyia doko nisoo, Ijipi tange doko pyao kumasia. ");
INSERT INTO enq2_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Goteme baa minatala, baanya kaiminingi dupa pyoo nyalanya pilyamo lao masilyaminona lao Mosesame masia. Dopaka doko, dokaitame dopa lao masala naeyami. ");
INSERT INTO enq2_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yuu gii mende dokonya, Israele mendalapo pyao piambino Mosesame kandatala, dolapo mona setao katena latoo latala lamaiyoo, ‘Wanelapo, nyakamba kaiminingina, aipuma mende pyaa-pyaa pilyambipi?’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dopa leamopa, pyao tee pia akali dokome Mosesa tuu lanya nepatala lao pituu, ‘Emba apimi isingi akali makande latala, naimanya kote singi akali kata lapya? ");
INSERT INTO enq2_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kuaka embame akali Ijipi tange mende pyao kumasipinoli pyoo, namba apata pyao kumasalanya pilyipi?’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pii dutupa Mosesame sepala, baa paka pupala, yuu Midiane dokonya baa tisa katea. Dokonya katao wane ane lapoma mandea. ");
INSERT INTO enq2_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ee kana 40 pateamopa, Sinai manda tengesa dosa, endakali napalenge yuu dokonya, Kamongonya enjele mende Mosesame kandena lao ita saka mendenya ita yuli paeya dokonya-kaita ipao panea. ");
INSERT INTO enq2_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ita yuli paeya doko Mosesame kandatala, mona andapala tengesa kanja pea. Dokopa Kamongonya pii mende epea dokome Mosesa lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Embanya yumbange Abraamepi, Aisakepi, Jekopepi dutupanya Gote doko nambana’ lea. Dopa leamopa, Mosesame pii doko sepala walu andake lea dokome kanjanya paka kaeya. ");
INSERT INTO enq2_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dokopa Kamongome baa lamaiyoo, ‘Emba kalyeno yuu dutupa nee nyetaena, embanya moko pee pilyino dolapo lyokao seta. ");
INSERT INTO enq2_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nambanya endakali Ijipi kalyamino dupa tanda andake nyiminopa, nambanya lengeme kandapu. Dokaitanya ee lamino doko nambame sipuaka. Dokonya nambanya endakali dupa pyoo nyotoo latala isa epelyo. Dopa pilyona, emba Ijipi paale lao pyandatoo, emba ipu’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Israele dupame Mosesa dokoaka lamaiyoo, ‘Emba apimi isingi akali makande latala, naimanya kote singi akali kata lapyape’ latala yakineami. Goteme Mosesa doko isingi akalipa, pyoo nyingi akalipa katena lao makande latala, enjele mende ita balo dokonya panena lea dokonya kinginya pena lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dopa leamopa, baa Ijipi pupala Israele dupa laminao, Ijipi yakinatala kamaka epea. Ijipi yuu dokonyapi, Retsi dokonyapi, endakali napalenge yuu dokonyapi, baame kalai paka pipaepi, mirakolopi, dupa pyoo, ee kana 40 dutupanya laminao pea. ");
INSERT INTO enq2_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosesa mendai dokomeaka Israele dupa lamaiyoo, ‘Naimanya Kamongo Goteme namba propeta makande leamoli pyoo, nyakamanya kaiminingi dupanya mende propeta makande lakatana’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosesa dokomeaka Israele dupa laminao pupala, kambu pyao endakali napalenge yuu dokonya katea. Kateamopa, wamba Sinai manda dokonya Mosesapi, naimanya yumbangepi, dupa pii lamaiya enjele doko apata katao, lete katenge pii mende naima dina lao Mosesa maiyamopa nyia. ");
INSERT INTO enq2_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mosesame pii lamaiya dupa naimanya yumbange dupame nasinya, baa yakinatala Ijipi pilyemana lao moname masiami. ");
INSERT INTO enq2_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dopa lao masetala dokaitame Arone lamaiyoo, ‘Ijipi yuu dokonya katao naima laminao epeamo Mosesa doko aipa pipyape lao masala naelyamanona, naima isoo laminao paeyatami gote mendapu embame wasaka’ leami. ");
INSERT INTO enq2_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Gii dokopa kao ŋaŋa mende gotena lao kingimi wasepala, doko kundi maiyoo eteke pyao kateami. ");
INSERT INTO enq2_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dopa piaminopa, Goteme dokaita yakinao maita maitala, nikipi, kanapi, buipi, kaiti-kisa katenge dupa mambo pina kaeya. Dopa pia doko, propeta dupanya bukunya dapa lao pepa pyapae silyamo: ‘Endakali napalenge yuu dokonya ee kana 40 dutupanya nyakama Israele dupame sipisipi akipi kundi maiyoo kateamino dupa, namba diamipi? ");
INSERT INTO enq2_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nyakamame gote mendalapo mambo pyamana lao wasiami. Mende doko Moloko, mende doko Repane. Molokonya sele anda dokopa, Repanenya bui dokopa, dolapo soo paeyami. Dopa piaminosa, nyakama anjetala laminao Babilone omotena-kaita palitaminopa lao nambame nyoo pena latona’ lapae silyamo. ");
INSERT INTO enq2_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Goteme baanya pii lao yaki petae singi sele anda doko dopa pyoo pipengena lao makande minapae doko Mosesa kandena leamopa, baame kandatala lealiaka pyoo anda doko pia. Sele anda doko endakali napalenge yuu dokonya naimanya yumbange dupame soo paeyami. ");
INSERT INTO enq2_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Maita-pyao naimanya yumbange dupame sele anda doko dokaitanya yumbange dupa-kisa nyepala soo Josua-pipa yuu dakenya epeami. Epeaminopa Goteme akali tata waka dupa watao pyapala, yuu doko nyoo naimanya yumbange dupa maiya. Dopa piamopa, sele anda doko yuu dokonyaka katao, Kiŋi Dapita katea gii dokonya tuu lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dokopa Kiŋi Dapita baa Goteme auu kaeyamopa katao, Jekopenya Gote doko katapenge anda mende baame pyakamaitoo lao masia. Dopa lao masetala, baame anda doko pyakaowape lao Gote tipa pia. ");
INSERT INTO enq2_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dopaka doko, Gotenya anda angi doko Kiŋi Solomoneme pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Gote Etete Ketae Katenge doko anda nee nyetae, endakali kingimi petae dupanya nakatenge. Kamongome propeta mende-kisa dapa lea: ");
INSERT INTO enq2_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Kaiti doko nambanya kiŋi petenge toko doko. Isa yuu dake nambanya moko setenge doko. Dopana, namba koto nyatale lao anda aipale mende, panda anja nyakamame pyakatami? Nambanya kingimi dupa pitaka pyoo wasala naeyope?’ lea-pyaa. ");
INSERT INTO enq2_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Dopana, nyakama tuu-tuu pipae, monapi, kalepi dupa kaka nasingi pyakilyetae! Nyakamame koteaka lao Oli Spiritanya pii doko tanga lelyamino. Nyakamanya yumbange dupame piami dopaka nyakamame pilyamino. ");
INSERT INTO enq2_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyakamanya yumbange dupame propeta anduku tanda maiyoo koeyasala naenya kaeyami? Akali Tolatae mende ipatana lao, wamba lao paneami propeta dupa pyao kumasiami-pyaa. Akali Tolatae doko nyakamame enge nyepala pyao kumasiamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Loo dupa enjele mendapuame Mosesa maiyami-pyaana lao nyakamame masilyaminoaka doko, loo dupa nyakamame wata-minala naelyaminona” Stipeneme lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stipeneme pii lea dutupa kanjole dokaitame sepala, dokaita imbumi mona kaa piamopa, nenge giti-gato lao neami. ");
INSERT INTO enq2_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Dopa piaminopa, Stipene baa Oli Spiritame tumbatae dokome kaiti-kisa kandalyetae kateamopa, Gotenya tii pipae andake dokopa, Jisasa baa Gotenya kingi tolaetena katea dokopa, dolapo kandea. ");
INSERT INTO enq2_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kandatala baame lao pituu, “Salapape! Kaiti doko saa papa laloo pimupa, Akalinya Ikiningi doko Gotenya kingi tolaetena katamupa nambame kandelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dopa leamopa, dokaitanya kale dupa piti petala, ae latae katao alo pyao pupala Stipene miniami. ");
INSERT INTO enq2_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Minatala baa siti dokonya kamaka watao pyasetala kaname piami. Stipene pina lao tenge seteami dupanya yonge pee kisa pingi dupa lyokanya, wane patange Solo lenge mende katea dokonya moko setea dosa seteami. ");
INSERT INTO enq2_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dokaitame Stipene baa kaname pyao kateaminopa, Stipeneme loma soo pituu, “Kamongo Jisasa, nambanya imambu doko nyaa” lea. ");
INSERT INTO enq2_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dopa latala, baa luma lakapala puu lao, lao pituu, “Kamongo, dakaitame koo pilyamino dakenya embame yanu pyala naeyape” lea. Dopa latala baa kumia. ");
INSERT INTO enq2_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Dokaitame Stipene pyao kumasiaminopa, doko yaka pilyaminona lao Solome masoo katea. Yuu gii dokonya, siosa Jerusalema katenge doko tanda andake maiyoo koeyasiaminopa, siosa dokonya petenge dupa boko pyapala Judiapi, Samariapi dupanya tale piami. Dopa piaminopa, aposole dupa iki Jerusalema kateami. Dokopa Gote mambo pingi akali mendapuame Stipene nyoo malu petala, kumanda peteami. ");
INSERT INTO enq2_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Dokopa Solome siosa doko koeyasoo, anda dii lao kolandao, endapi akalipi Jisasa tungi pingima dupa pyalya lao nyoo, anjetae palenge anda dupanya nyoo pyandao paeya. ");
INSERT INTO enq2_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Dokopa endakali tale piami dupa peamili pyoo, wai pii epe doko lamaiyoo taeyami. ");
INSERT INTO enq2_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Dopa piaminopa, Pilipa baa lanao Samaria yuu dokonya siti mendenya pupala, Jisasa baa Kraisa dokona lao lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Endakali longo-kisa imambu koo paleami dupa Pilipame pena leamopa, endakali dupa yakinatala pao pituu, puu lao ae latala pata piami. Endakali papa tambutaepi, moko takyepaepi, longo mendapu baame auu pisakamaiyaka. Dokopa baame mirakolo pia dupa endakali kambu dupame kandatala, baanya pii lea dupa sokondape pyoo siami. ");
INSERT INTO enq2_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sepala siti dokonya paleami endakali dupa eteke andake piami. ");
INSERT INTO enq2_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wamba siti dokonya akali Saimone lenge mendeme baa akali andake kalyona lao, Samaria tange dupa paka pisoo nemango lao katea. ");
INSERT INTO enq2_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Dopa lao kateamopa endakali tipyapi, akali andakepi, dupame baanya pii doko sokondape pyoo sepala lao pituu, “Akali dake Gotenya kyeto andake doko-lamona” lao kateami. ");
INSERT INTO enq2_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Akali dokome wamba-waka pituu nemango leamopa, endakali kambu dupame kandatala, paka kaeyao walu latala baa wateami. ");
INSERT INTO enq2_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dopaka doko, Gotenya kingdom dokonyapi, Jisasa Kraisanya kenge dokonyapi lao Pilipame wai pii epe doko lamaiyamopa, endapi akalipi dupame pii doko kiningi-lumu lao sepala kaimbu nyiami. ");
INSERT INTO enq2_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dokopa Saimoneme apata kiningi-lumu lao sepala, baa kaimbu nyiaka. Nyepala Pilipa paeya yuu dupa pitakanya baame watao paeya. Paeyamopa mirakolo andakepi, kalai paka pipaepi, dupa Pilipame piamo kandatala, Saimone baa paka kaeyao walu lao katea. ");
INSERT INTO enq2_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Gotenya pii doko Samaria tange dupame soo nyepelyamino lapae doko aposole Jerusalema kateami dupame sepala, Pitapa Jonepa Samaria tange dupa kanja pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Samaria tange dupa Jisasa Kraisanya kenge dokonya iki kaimbu nyiami dokonya, Oli Spirita doko dupanya mende-kisa ipatala naeya. Dopa pia dokonya, Pitapa Jonepa lanao pupala, Oli Spirita doko Samaria tange dupa-kisa epena lao loma sakamaiyambi. ");
INSERT INTO enq2_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Loma sepala aiyombanya kingi setakamaiyambinopa, Oli Spirita doko dupa-kisa epea. ");
INSERT INTO enq2_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Aposole dolapome aiyombanya kingi setakamaiyambi endakali dupa-kisa Oli Spirita doko epeamo Saimoneme kandatala, muni mendatupa nyepala minao epea. Ipupala baame dolapo lamaiyoo, “Nyakambame pilyambinoli pyoo nambame endakali mendenya aiyombanya kingi setakamaitopa, Oli Spirita doko endakali doko-kisa epena, nyakambame kyeto doko namba dyepale, nyakamba muni datupa ditoana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dopa leamopa Pitame baa lamaiyoo, “Epe mende Goteme mee dingi doko munimi kapa pao sambapengena lao embame masilyino dokonya, embanya silipa muni dupa-pipa emba koeyalapeno. ");
INSERT INTO enq2_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gotenya enombanya emba mona tolatae palya naelyeno dokonya, kalai pilyamano dakenya emba apata pyaa naeyalapeno. ");
INSERT INTO enq2_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Nambame kandapupa embanya masingi koo dokome emba maka pisala-kao pisetae katapinopa, mana koo dokome emba kakopai nyepelyamo. Dopana, embanya moname koo pipu laka lao masilyino doko Goteme kunao nepakata nakandenya, embanya koo pilyino dake yakinao mona kapilyetala, kyeto joo Gote loma sepe” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dokopa Saimoneme yanu pyao, “Nyakambame lelyambino dupanya mende namba-kisa napina, Kamongome namba nisina lao kyeto joo loma sakalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pitapa Jonepame Kamongonya pii doko panao lamaiyoo etapala Jerusalema pilyiambi. Pilyoo pituu, Samaria tange dupanya yuu yakane longo mendapuanya wai pii epe doko lamaita-lamaita pyoo peambi. ");
INSERT INTO enq2_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dokopa Kamongonya enjele mendeme Pilipa lamaiyoo, “Emba sakatatala, Jerusalema katao Gasa paanya penge kaitini dokonya lanao puu” lea. (Gasa paanya penge kaitini dokonya endakali napalengema.) ");
INSERT INTO enq2_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dokopa Pilipa sakatatala kaitini dokonya pea. Peamopa, Itiopia gapomane dokonya kalai akali kenge singi mende, Jerusalema lotuu lao katao pilyoo pea. Akali dokome kuini enda Kendasa lenge dokonya muni isakamaingi. ");
INSERT INTO enq2_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Akali doko baanya pituu paenge karisa dokonya andaka pilyoo pituu, propeta Aisaiyanya buku doko itaki pyao pea. ");
INSERT INTO enq2_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Peamopa Spirita dokome Pilipa lamaiyoo, “Pituu paenge karisa mende pelyamo dokonya emba tengesa puu” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dopa leamopa Pilipame alo pyao pao, pituu paenge karisa doko watanyia. Watanyetala baame siamopa, pituu paenge karisa dokonya petea akali dokome propeta Aisaiyanya buku doko itaki pyaluiyanya, Pilipame baa lamaiyoo, “Embame pii itaki pilyino dokonya tenge dupa soo nyilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dokopa akali dokome lao pituu, “Endakali mendeme tenge dupa namba langya naeyatamopa, nambame aipa petala soo nyotope?” lea. Dopa latala Pilipa apata pitimbana pyakalyina lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Dokopa baa pupala kandeamopa, Gotenya pii pepa pyapae singi itaki pia doko dake: “Sipisipi pyamana lao lanyoo pengeli pyoo, baa lanyoo peami. Sipisipi ŋaŋa mende iti tokakamaingisa ema napingili pyoo, baame piipi mende nalao ema napia. ");
INSERT INTO enq2_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mana tolatae minao baanya kote doko sakamaiya naenya, baa koeyasoo elya pisiami. Dopa petala baa yuu dakenya nakatena lao etasiami. Dopa piami dokonya, baanya mandipaenya mandipae dupa dakaitana lao, endakali mendeme atome laa naeyatana” lapae silyamo doko itaki pia. ");
INSERT INTO enq2_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dokopa gapomanenya kalai akali dokome Pilipa lamaiyoo, “Nambame emba tipa mende pilyo. Propeta dokome pii dake baa tange lao leape, pande endakali waka mende lao leape” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dopa leamopa, pii pepa pyapae singi dokonya tenge doko tee pyao dii tambao, Jisasanya lao wai pii epe doko Pilipame baa lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kaitinisa pao pituu, endaki pete mende siamo kandeambi. Kandatala gapomanenya kalai akali dokome lao pituu, “Endaki pete mende silyamo dake kanda. Namba kaimbu nyepenge dokonya aki mendeme pyalya minilyape?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dopa latala gapomanenya kalai akali dokome pituu paenge karisa doko sina lea. Dokopa Pilipapa, gapomanenya kalai akali dokopa, dolapo lapota endaki pete dokonya pyakanatala, Pilipame baa kaimbu pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kaimbu pyatakamai endaki doko yakinatala pyakalyiambinopa, Kamongonya Spirita dokome Pilipa nyokonyulu piamopa, gapomanenya kalai akali dokome baa dee nakandea. Dokopa gapomanenya kalai akali doko auu kaeyapaeme tumbiamopa andaka pea. ");
INSERT INTO enq2_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipa baa taono Asotusa dokonya kalyu katao tanda lea. Dopa petala baa taono dupa pitakanya paeyao, wai pii epe doko lamaiyoo Sisaria pyakamea. ");
INSERT INTO enq2_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Solome Kamongonya disaipolo dupa paka pisetala, pyao kumasotoo lao masia doko yakinala naeya. Kraisa watao paenge kaitini dokonya endapi akalipi mende paeyataminopa, Solome kandao nyoto doko, dupa anjoo nyepala laminao Jerusalema ipatoo lao masia. Dopa lao masetala, prisa mupa dokome yakana latae pepa mende pyao, lotuu anda Damasakasa katenge dupanya pyasina lao Solome tee lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tee lao nyepala Solo baa pao Damasakasa tengesa pyakameamopa, kaiti-kisa katao tii pipae yale mendeme yuu mendai ipao baa-kisa tii piyoko lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Dopa pia dokome, baa isa lombapae sia. Soo pituu siamopa pii mende lea dokome baa lamaiyoo, “Solo, Solo, embame aipuma namba tanda dyoo koeyasilyipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Dopa leamopa Solome lao pituu, “Kamongo, emba apipi?” lea. Dokopa Kamongome lao pituu, “Namba Jisasa, embame tanda dyoo koeyasoo kalyeno doko. ");
INSERT INTO enq2_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Dopana, emba sakatatala siti dokonya puu. Patenopa embame kalai yakinala naeyao pipenge dutupa akali mendeme emba langyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dopa leamopa, pii laluiyamo doko Solo-pipa peami akali dupame siami. Dopaka doko, endakali mende kanja naeyapala dokaita pii mende naleami. ");
INSERT INTO enq2_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dokopa Solo baa yuunya siamopa minao sakatasiami. Dokopa baame lenge auu pyoo tao endakali mende kandapenge nanjiamosa, baa kii minao Damasakasa peami. ");
INSERT INTO enq2_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yuu gii tepo baanya lenge dolapo iminjetae kateamopa, neepi endakipi mende nanea. ");
INSERT INTO enq2_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Gii dokopa disaipolo Ananiasa lenge mende Damasakasa katea. Akali dokome lee manemaneme kandeamopa, Kamongome baa lamaiyoo, “Ananiasa!” lea. Dopa leamopa Ananiasame lao pituu, “Kamongo, nambame embanya pii doko salanya depa latae asa kalyona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dokopa Kamongome baa lamaiyoo, “Sepe! Tasusa tange akali Solo lenge mende, Judasanya andaka loma soo pilyamona, emba sakatatala, kaitini Tolatae lenge dokonya pupala, Solo anja kalyape lao tipa pyoo kutape. ");
INSERT INTO enq2_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Baanya lenge dolapo auu pina lao, akali Ananiasa lenge mende ipupala, baa-kisa kingi setamupa Solome lee manemaneme kanjomona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dopa leamopa Ananiasame yanu pyao, “Kamongo, Jerusalema dokonya endakali embanya latae dupa-kisa akali dokome mana koo longo dupa minilyamo lapae sipu. ");
INSERT INTO enq2_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Embanya kenge doko lao loma setami endakali dupa akali dokome anjotoo lao, prisa mupa dupa-kisa pepa mende nyepala ipupyana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","16","Dopa leamopa Kamongome baa lamaiyoo, “Israele tatapi, akali tata wakapi, kiŋipi dupa nambanya wai pii epe doko akali dokome lamaiyakala pena lao yapao nyio. Dopana, nambanya kenge dokonya baa tanda longo napenge latae dupa laitaka pitoo, emba baa pilyamo dokonya puu” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dopa leamopa Ananiasa baa pao anda dokonya kolandatala, baanya kingi dolapo Solo-kisa setapala baa lamaiyoo, “Kaimii Solo, emba kaitinisa epeenopa kanjale lao panea Kamongo dokomeaka emba dee lenge auu pyoo tapala, Oli Spirita doko tumbao nyatale lao namba ipu lamona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Dopa lalu piamopa, baanya lenge dolaponya pisanya grile jepae mendapu sia dupa kopo leamopa, baa dee lenge auu pyoo tao kandea. Baa lenge auu pyoo tapala sakatao kateamopa kaimbu pyakamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Dopa peteamopa, baa nee napala kyeto nyia. Kyeto nyepala Solo baa disaipolo dupa-pipa yuu gii mendatupa Damasakasa kateami. ");
INSERT INTO enq2_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kateaminopa Solome nee kaeyao lotuu anda dupanya pupala, Kraisa doko Gote Ikiningi dokona lao pii lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lamaiyamopa siami endakali dupa pitakame walu latala lao pituu, “Jisasanya kenge dokonya loma soo katengema endakali dupa akali dakeme wamba Jerusalema katao koeyasiamo dokoaka daa kandamuape? Indupa baa ae ipupala, Kristene dupa anjoo laminao, prisa mupa dupa-kisa paanya napilyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dopa leamiaka doko, Solo baa kyeto nyala-kao nyepala, Jisasa baa Kraisa dokona lao dii tambao lamaiyokondape pyoo lamaiyamopa, Damasakasa paleami Juu dupame baanya pii dokonya tanga lapenge kaitini mende nasia. ");
INSERT INTO enq2_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yuu gii longo pateamopa, Juu dupame Solo pyao kumasemana latala kambuiyami. ");
INSERT INTO enq2_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kambutala baa pyamana lao, siti dokonya lome kambu dupanya kuka kotakapi anga pilyamino lapae doko Solome sia. ");
INSERT INTO enq2_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dokopa disaipolo dupame kuka gii mendenya baa baseketa mendenya mandipala, dokonya kende katatala, kende dokonya minatae katao, siti kaname kame petae dokonya windo mendenya-kaita yakinama-yakinama pyoo kamalyatena isa pyandeami. ");
INSERT INTO enq2_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dopa peteaminopa Solo baa Jerusalema pupala, disaipolo dupa-pipa apata katamana lao piamopa, dokaita pitakame baa disaipolo mende daana lao masetala paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dopa piaminopa Banabasame Solo laminao, aposole dupa kateami dokonya pea. Pupala, Solome Kamongo doko kaitinisa kandeapi, Kamongome baa pii lamaiyapi, Damasakasa katao baa paka nakaeyao Jisasanya kenge doko lao paneapi, dutupa Banabasame dokaita lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Lamaitiamopa, Solo baa aposole dupa-pipa Jerusalema dokonya paeyao, Kamongo Jisasanya kenge dokonya paka nakaeyao pii dupa panao lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Baame Giriki pii lenge Juu dupa-pipa pii lata, pii dokonya atete peta pyoo kateamopa, dupame baa pyao kumasemana lao kaitini kutiami. ");
INSERT INTO enq2_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dopa pilyamino lapae doko Kristene kaiminingi dupame sepala, Solo laminao lanao Sisaria peami. Dokonya katao baa Tasusa pena lao mapeami. ");
INSERT INTO enq2_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Siosa Judia katengepi, Galali katengepi, Samaria katengepi, dupa pitaka-kisa kenda mende naepeamopa, Kamongo paka kaeyao kateami. Dokopa Oli Spiritame dokaita kyeto maiyamopa, Jisasa tungi piami endakali dupanya kindi doko andama-andama pia. ");
INSERT INTO enq2_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita baa yuu mendenya pata-pata pyoo pao, Lida yuu dokonya endakali Gotenya latae dupa kateami dokonya pyakanea. ");
INSERT INTO enq2_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pyakanatala yuu dokonya akali papa tambutae Ainiasa lenge mende kandea. Akali doko ee kana tukulapo pitaka metanya iki paliu singi. ");
INSERT INTO enq2_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitame akali doko lamaiyoo, “Ainiasa, Jisasa Kraisame embanya yaina doko mee jekelyamona, emba sakatatala embanya meta doko lakao yaki pii” lea. Dopa lalu piamopa baa sakatea. ");
INSERT INTO enq2_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dokopa Lida tangepi, Sarone tangepi, dupa pitakame Ainiasa kandatala, mona kapilyetala, Kamongo tungi piami. ");
INSERT INTO enq2_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa dokonya disaipolo enda Tabita lenge mende petea. (Baa Giriki piimi Dokasa lengema.) Baame koteaka lao oapi dupa endakali daa jepae dupa maiyoo, mana epe minao petea. ");
INSERT INTO enq2_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pita baa Lida katea gii dosa mendasa, enda doko yaina nyepala kumia. Kumateamopa baanya yonge doko wasa pyapala, nyoo anda namba pyoo petae ketae dokonya ruma mendenya seteami. ");
INSERT INTO enq2_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida yuu doko Jopa tengesa singi dokonya Pita baa kalyamo lapae doko disaipolo dupame sepala, malisala naeyao, baa yapa epena lao akali lapomame wai minao pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Akali dolapo pupala wai doko lamaitiambinopa, Pita sakatatala akali dolapo-pipa Jopa peami. Pao pyakameaminopa, Pita lanyoo anda ketae ruma dokonya peami. Pateaminopa, enda walyakae dokaitame Pita baa katea dosa ee lao katao, yonge pee isa pingipi, kisa pingipi, Dokasame saka pituu wasia dupa baa kandena leami. ");
INSERT INTO enq2_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pitame oapi dupa kandatala, dokaita pitaka kamaka pena latala, baa luma lakapala loma sia. Loma sepala, enda kumapae dokonya yonge sia doko lengeme kandatala lao pituu, “Tabita, emba sakata” lea. Dopa leamopa enda doko lenge tapala, Pita kandatala, baa sakatao petea. ");
INSERT INTO enq2_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Dokopa Pitame enda doko kinginya minao toeya katasetala, endakali Gotenya lataepi, enda walyakaeyapi, dupa epena latala, enda lenge tao sakatea doko dokaitame kandena lea. ");
INSERT INTO enq2_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pitame pia doko Jopa tange dupa pitakame siami. Siami dupanya longome Kamongo tungi piami. ");
INSERT INTO enq2_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Dokopa akali Saimone lenge, kao yanu taka lapae pyoo wasingi doko-pipa Pita baa yuu gii longo Jopa kateambi. ");
INSERT INTO enq2_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria dokonya akali Koniliasa lenge mende katea. Akali dokome amii kambu Itali tange lenge doko isingi. ");
INSERT INTO enq2_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Baapi, baanya palupi, dupame Gote paka kaeyao lotuu lao katengema. Baame endakali daa jepae dupa longo lao nisetapu, koteaka lao Gote loma soo katenge. ");
INSERT INTO enq2_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gii mendepa, alemandi 3 kilokopi mendenya, baame lee manemaneme kanja-kao kandeamopa, Gotenya enjele mende ipupala baa lamaiyoo, “Koniliasa!” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dokopa baa paka kaeyao kandatae sepala lao pituu, “Akali Andake, embame aipa latoo lao lelyepe?” lea. Dopa leamopa enjele dokome baa lamaiyoo, “Embanya loma singipi, endakali daa jepae dupa nisingipi, dupa baa opaa dilyinona lao Goteme masetae kalyamo. ");
INSERT INTO enq2_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Dopa pilyamona, indupa embame akali mendatupa Jopa pena latala, Saimone, kenge mende Pita lenge doko lanyoo epena lape. ");
INSERT INTO enq2_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Baa kao yanu taka lapae pyoo wasingi akali Saimoneaka lenge mendepa tole kalyambino. Akali dokonya anda doko solowata lemba dokonya katengena” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Enjele pii lamaiya doko pateamopa, kalai akali lapomapi, Gote paka kaeyao Koniliasanya kalai pyakamaiyoo katenge amii mendepi, dutupa Koniliasame epena lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Dutupa ipateaminopa, enjele dokome lamaiya dupa pitaka Koniliasame akali dutupa lamaitala, Jopa pena lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yuu gii mende dokonya, kotaka etete dokonya, akali dutupa kaitini pao Jopa siti dokonya tengesa pyakameami. Dokopa Pita baa loma sala anda-kisa pyakalyia. ");
INSERT INTO enq2_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dokonya pituu baa lopo kaeyapala, nee napuli lao masia. Dokopa nee depa leaminopa, baame lee manemaneme kandena lao Kamongome baanya masepae doko etao nyia. ");
INSERT INTO enq2_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dokopa baame kandeamopa, kaiti doko saa papa laloo petala, lapalapa jepae yale mende, denge kitomende dutupanya kende katatae doko minatae katao, isa yuunya setala epea. ");
INSERT INTO enq2_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lapalapa dokonya moko kitomende katenge endakalimi miningipi, kakasa katengepi, kanopatopi, yaka ketae paengepi, dupa pitaka paleamo kandea. ");
INSERT INTO enq2_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dokopa pii mende epea dokome baa lamaiyoo, “Pita, emba sakatatala dokaita pyao naa” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dopa leamopa Pitame lao pituu, “Kamongo, loome nanapenge latae singi nee mende paa mendaipi mende naneona, nambame nanalapo daana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dopa leamopa, paa lapo pyoo pii mende epea dokome baa lamaiyoo, “Goteme dopale auu pisetae dupa embame nanapengena laa naeyape” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lee manemaneme kandea mendai dokoaka paa tepomasa kandateamopa, lapalapa denge kitomende katapae doko kaiti-kisa nyokonyia. ");
INSERT INTO enq2_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pitame lee manemaneme kandea dokonya tenge doko aipalepe lao tatake kaeyao peteamopa, Koniliasame pena lea akali dutupame Saimonenya anda doko anja kalyape lao tipa pyoo sepala, ipao lome kambu dokonya kateami. ");
INSERT INTO enq2_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dokonya katao dutupame wii lao, “Saimone kenge mende Pita lenge doko anda dakenya pilyape?” leami. ");
INSERT INTO enq2_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Pitame lee manemaneme kandea doko masoaka peteamopa, Spirita dokome baa lamaiyoo, “Nambame akali mendatupa epena lapupa, emba kutao epelyaminona, emba mona lapo palya naeyao, tole pupale sakatatala isa pyakana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dokopa Pita isa pyakanatala akali dutupa lamaiyoo, “Nyakamame kutilyamino akali doko nambana, tenge aipuma kutao epelyamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dopa leamopa dutupame baa lamaiyoo, “Amii 100 isoo katenge Koniliasa lenge dokome naima pupa lapya. Akali doko etete tolatae, Gote paka kaenge mende. Juu dupa pitakame baa akali epena lengema. Dopana, emba Koniliasanya andaka ipupala, embanya pii lamaiti dupa baame sina lao Gotenya enjele mendeme baa lamaipyana” leami. ");
INSERT INTO enq2_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dopa lateaminopa, Pitame akali dutupa andaka epena latala kuka gii dokonya tole paleami. Paliu yuu gii mende dokonya Pitapi, akali dutupapi, dupa Kristene kaiminingi Jopa tange mendatupa-pipa Koniliasanya andaka paanya peami. ");
INSERT INTO enq2_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pao kaitinisa palipala Sisaria pyakameami. Akali dokaita ipamino lao Koniliasame masetala, baanya tatapi, kaita miningipi dupa epena latala, kambu pyao malisoo katea. ");
INSERT INTO enq2_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita baa Koniliasanya andaka pyakameamopa, Pitanya moko katea dosa Koniliasa luma lakapala baa mambo pia. ");
INSERT INTO enq2_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dopa piamopa, Pitame baa minao toeya katasetala lao pituu, “Namba mee endakali mendeakana, emba sakata” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pii lama-lama andaka kolandeambinopa, endakali longo kambu pyao peteamino Pitame kandea. ");
INSERT INTO enq2_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kandatala baame dokaita lamaiyoo, “Akali tata waka dupa-pipa kambu pyao pilya naeyao, dupanya andaka yalya kandao napilyepape lao, Juumanya loo dupame lapae singi doko nyakamame kandengema. Dopaka doko, nambame endakali mende kaimala pipaena latala wandyala naeyapengena lao Goteme namba kanjale lao panasipya. ");
INSERT INTO enq2_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Namba ipupi lao wai lamino dokonya, tanga nalao ae ipao kalyo dakena, aipuma namba lanyala epena lamipi?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dopa leamopa Koniliasame lao pituu, “Alembolya namba nee nanao loma soo pituu gii lelyamo dakenyaka tuu leo. Dokopa 3 kiloko dokonya, namba andaka loma soo peteopa, akali yonge pee etete kyeo lapae pingi mende nambanya enombanya kalyu pia. ");
INSERT INTO enq2_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akali dokome namba langyoo, ‘Koniliasa, embanya loma sipino doko Goteme sepelyamo. Embame endakali daa jepae dupa nisingi dupa Goteme kandatala masetae kalyamo. ");
INSERT INTO enq2_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dopana, embame akali mendatupa Jopa pena latala, Saimone kenge mende Pita lenge doko lanyoo epena lape. Baa kao yanu taka lapae pyoo wasingi akali Saimoneaka lenge mendenya andaka kalyamo. Akali dokonya anda doko solowata lembanya katenge. Pita ipupala nyakama pii langitana’ enjele dokome lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Dopa lalu piamopa, nambame emba lanyala epena leona, emba yaka epelyeno. Goteme lape lao emba langiali pyoo piipi, manapi dupa indupa latenopa, naima pitakame semana lao Gotenya enombanya asa pilyamanona” Koniliasame lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dokopa Pitame lao pituu, “Goteme endakali mende mona setapala, mende maka kaeyala naenge-lamo lao nambame indupa kiningi kandelyo. ");
INSERT INTO enq2_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Akali tata dupa pitakanya, endakali mendeme Gote paka kaeyapala, mana tolatae minao katenge doko Goteme auu kaenge. ");
INSERT INTO enq2_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Goteme pii mende Israele tata dupa-kisa epena lea doko nyakamame masilyamino. Dupa pitakanya Kamongo Jisasa Kraisame pia dokonya-kaita, Goteme endakali dupa mona setao katamana lao wai pii epe doko lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Joneme endakali dupa kaimbu nyina lao kateamo gii dokonya pituu, indupa tuu lao, Galali katao tee pyatala, Judia yuu dupa pitakanya pii mende lao taeyamino doko nyakamame masilyamino. ");
INSERT INTO enq2_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pii doko dake: Nasarete tange Jisasa doko Goteme Oli Spiritapa, kyetopa dolapome aiyomba minani petala, Gote baa apata kateambi dokonya, Jisasame yuu dupa pitakanya paeyao kalai epe pyoo, Sataneme kenda pisetae endakali dupa auu pisia doko nyakamame masilyamino. ");
INSERT INTO enq2_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jerusalemapi, Juumanya yuupi, dupanya Jisasame pia dupa pitakapi, baa poko itanya pyao yukuiyamipi, dupa naimame kandeama dupa lao panao kalyamano. ");
INSERT INTO enq2_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jisasa pyao kumaseteaminopa, Goteme yuu gii tepo dokonya Jisasa malunya sakatasetala, endakali mendapuame baa kandena lao panasia. ");
INSERT INTO enq2_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Panasia doko Juu tata dupa pitaka-kisa panasala naeya. Goteme kandatamina lao naima wamba yapao nyia dupa-kisa panasia. Panasia doko, baa malunya sakatateamopa kandatala apata katao nee endakipi nao kateama dupa-kisa panasia. ");
INSERT INTO enq2_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Endakali dupa wai pii epe doko lamaiyoo pituu, endakali kumapaepi, sakapi dupa yapena lao Jisasa baa Goteme makande lateana lao, naimame panao endakali dupa lamaiyepape lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wamba propeta dupa pitakame lao panao, Jisasa tungi pyatami endakali dupa pitakanya koo dupa baanya kenge dokonya Goteme kunao nepakamaitana leami-pyaana” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitame pii dutupa lao kateamopa, pii siami endakali dupa pitaka-kisa Oli Spirita doko epea. ");
INSERT INTO enq2_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Dokopa dokaitame Gote kenge andake maiyoo pii tata waka dupa leami. Dopa leamino sepala, akali tata waka dupa-kisa apata Goteme Oli Spirita kai lamupa nyilyaminona lao masetala, Jisasa tungi pingi Juu mendapu Pita-pipa epeami dupa walu leami. Dopa piaminopa Pitame lao pituu, ");
INSERT INTO enq2_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Naima Oli Spirita doko nyiamanoliaka pyoo nyilyamino endakali dakaita endakimi kaimbu pyakamaitamanopa, apimi daa latape?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dopa latala Kamongonya kenge dokonya dokaita kaimbu pyakamaina lea. Kaimbu pyatakamaiyaminopa, dokaitame Pita baa nyakama-pipa yuu gii mendatupa apata katamana kaena leami. ");
INSERT INTO enq2_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Akali tata waka dupame Gotenya pii doko nyepelyamino lapae doko aposolepi, Kristene kaiminingipi, Judia kateami dupame siami. ");
INSERT INTO enq2_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dokopa Pita lalyoo Jerusalema pateamopa, akali yanu kepapae Kristene mendapuame baa pyalanya lao, ");
INSERT INTO enq2_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Yanu kepala naenge akali dupanya andaka kolandatala, emba dupa-pipa nee nao petee-pyaana” leami. ");
INSERT INTO enq2_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dopa leaminopa, pia dupa pitaka piali pyoo Pitame dokaita tee pyao lamaiyoo, ");
INSERT INTO enq2_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jopa siti dokonya anda mendenya namba loma soo peteopa, lee manemaneme kanjale lao, Kamongome nambanya masepae doko etao nyia. Dokopa nambame kandeopa, kaiti-kisa katao lapalapa jepae yale mende, denge kitomende dutupanya minatae katao, namba peteo dokonya isa epea. ");
INSERT INTO enq2_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Lapalapa dokonya palea dupa kandakondape pyoo kandeopa, moko kitomende katenge endakalimi miningipi, kakasa katengepi, kanopatopi, yaka ketae paengepi, dupa palea. ");
INSERT INTO enq2_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dokopa pii mende namba langyoo lea doko siopa, ‘Pita, emba sakatatala dokaita pyao naa’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dopa leamopa nambame lao pituu, ‘Kamongo, loome nanapenge latae singi nee mende paa mendaipi mende nambanya nenge-kaita napeana, nambame nanalapo daana’ leo. ");
INSERT INTO enq2_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dopa leopa, paa lapo pyoo kaiti-kisa katao pii mende epea dokome namba langyoo, ‘Goteme dopale auu pisetae dupa embame nanapengena laa naeyape’ lea. ");
INSERT INTO enq2_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lee manemaneme kandeo mendai dokoaka paa tepomasa kandateopa, dupa pitaka kaiti-kisa nyokonyia. ");
INSERT INTO enq2_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Gii etete dokopaka, akali tepoma Sisaria katao epena lao amii isingi mendeme leamopa, namba kateo anda dokonya epeami. ");
INSERT INTO enq2_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dokopa mona lapo palya naeyao, akali dutupa-pipa pupape lao Oli Spiritame namba langia. Langitiamopa, Kristene kaiminingi tokange datupa-pipa pupala, amii isingi dokonya andaka kolandeama. ");
INSERT INTO enq2_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kolandateamanopa akali dokome naima langyoo, ‘Enjele mende nambanya andaka kateamopa kandeo. Enjele dokome namba langyoo, “Akali mendatupa Jopa pena latala, akali Saimone, kenge mende Pita lenge doko lanyoo epena lape. ");
INSERT INTO enq2_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Akali dokome wai pii mende emba langita dokome, embapi, embanya andaka palengemapi, dupa pitaka pyoo nyetana” leana’ lao baame naima langia. ");
INSERT INTO enq2_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Dokopa, nambame tee pyao pii leopa, Oli Spirita doko tee pyao naima-kisa epeamoliaka pyoo dokaita-kisa epea. ");
INSERT INTO enq2_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wamba Kamongome lao pituu, ‘Joneme endakali dupa endakimi kaimbu pyakamaiya. Dopaka doko, Oli Spiritame nyakama kaimbu pyakatana’ leamo pii doko, gii dokopa nambame masio. ");
INSERT INTO enq2_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kamongo Jisasa Kraisa doko naimame tungi piamanopa, Goteme epe mende naima mee diamo, mendai dokoaka dokaita mee maiyana, namba api-kaita Goteme dopa napipengena lao kaita lyokatope?” lea. ");
INSERT INTO enq2_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Dopa leamo sepala dokaitame pii mende lapenge nanjiamosa, Gote mambo pyao pituu, “Akali tata waka dupa mona kapilyetala, lete katenge doko nyina lao, Goteme kaitini mende setapya-lumuna” leami. ");
INSERT INTO enq2_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stipene pyao kumasetala, Kristene dupa apata tanda maiyoo koeyasiaminosa, dokaita tale petala, Ponisiapi, Saiprusapi, Antiokopi dupanya peami. Pupala Gotenya pii doko akali tata waka dupa lamaiya naenya, Juu dupa iki lamaiyoo kateami. ");
INSERT INTO enq2_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Dopaka doko, akali Saiprusa tangepi, Sairini tangepi, mendapu Antioko pupala, akali tata waka, Giriki pii lenge dupa Kamongo Jisasanya lao wai pii epe doko tee pyao lamaiyamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dokopa Kamongome dokaita kyeto maiyamopa, endakali longo mona kapilyetala Jisasa tungi piami. ");
INSERT INTO enq2_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tungi pilyamino lapae doko siosa Jerusalema katenge dokome sepala, Banabasa baa Antioko pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabasa baa Antioko pupala kandeamopa, Gotenya kondo kaenge doko Kristene dupa-kisa siamo kandatala, baa auu kaeya. Auu kaeyapala, endakali dupame Kamongo doko yakinala naeyao kyeto joo tungi pyao katena lao baame pii lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Oli Spirita dokopa, Jisasa tungi pingi mana dokopa, dolapome Banabasa baa tumbatae, akali epe mende kateamopa, endakali kambu andake mende mona kapilyetala, Kamongo tungi piami. ");
INSERT INTO enq2_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Maitakao Banabasame Solo kutao Tasusa pea. ");
INSERT INTO enq2_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kutao kandatala, baa laminao Antioko pilyia. Dopa petala, akali dolapo ee kana mende etao siosa Antioko katea dokonya Kristene dupa-pipa katao, Gotenya pii doko endakali kambu andake mende mana lamaiyoo kateambi. Antioko dokonya disaipolo dupa tee pyao kenge Kristene leami. ");
INSERT INTO enq2_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Gii dosa mendasa propeta mendapu Jerusalema katao Antioko lanao epeami. ");
INSERT INTO enq2_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Propeta epeami dupanya mende, Agabusa lenge doko Spirita dokome masepae maiyamopa, baa toeya katapala lao pituu, “Yuu dupa pitakanya lopo andake mende setana” lea. (Agabusanya pii lea doko Kolodiusa Sisame isoo katea gii dokopa angi jia.) ");
INSERT INTO enq2_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Dokopa disaipolo Antioko kateami dupame nyakama-kisa setali pyoo, Kristene kaiminingi Judia kateami dupa nisoo maimanana leami. ");
INSERT INTO enq2_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Maimanana leami dupa nyoo kambu pyatala, Banabasapa Solopame nyoo, Jerusalema siosa dokonya isingi akali dupa maiya pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Gii dosa mendasa Kiŋi Eroteme siosa dokonya endakali mendapu tanda maiyoo koeyasotoo latala anjia. ");
INSERT INTO enq2_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dopa petala baame Jone kaiminingi Jemesa konjuwame pyao kumasina lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pyao kumasina lea doko Juu dupame auu kaeyaminopa Eroteme kandatala, Breta Yisa Pyandala Naeyao Yangapae Nengema gii dokonya, Pita apata anjoo nyala pena lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dokopa Pita anjoo nyepala, anjetae palenge anda dokonya pyandea. Pyandatala, Pasopa gii doko patatamopa, endakalinya enombanya Pita kotimi latopa latala, amii kambu kitomende dutupanya, amii kitomende laowaka katao baa isoo katena lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Dokopa anjetae palenge anda dokonya Pita isoo kateaminopa, Goteme Pita nisina lao siosa dokome loma setae katao siami. ");
INSERT INTO enq2_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Eroteme Pita baa taita kote laa epena latona lao masiamopa, kuka gii dokopaka, Pita baa sene kende lapomame anjetae luu paleamopa, yangi-yangipa dolaponya amii lapomame isoo kateambi. Dopa piambinopa, amii mendapuame anda kambu doko isoo kateamiaka. ");
INSERT INTO enq2_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dokopa Kamongonya enjele mende Pita palea dokonya kalyu piamopa, baa palea panda doko tii pia. Dopa piamopa, enjele dokome Pitanya patali dosa pyapala baa lamaiyoo, “Emba yapa sakata” lea. Dopa leamopa, baanya kinginya sene kendeme anjiami dolapo isa kopo lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dopa peteamopa enjele dokome Pita lamaiyoo, “Embanya yonge pee doko lakao muu pyoo petala, moko pee dolapo nyoo pii” lea. Dopa leamopa Pitame leali pia. Dopa peteamopa enjele dokome Pita lamaiyoo, “Embanya yonge pee kisa pingi doko nyoo petala, namba watao ipu” lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Dokopa Pita enjele doko watao kamaka pea. Pao pituu, enjele dokome pia doko lee manemaneme kandelyope lao masia. ");
INSERT INTO enq2_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pitapa enjele dokopa peambi doko pao, amii wambao isoo katenge dupa yakinatala, lapo pyoo isoo katenge dupa apata yakineambiaka. Dopa petala siti dokonya paanya penge lome kambu aeneme petae dokonya pyakameambinopa, lome kambu pai latae doko tangeme lumbia. Dopa piamopa, enjele dokopa Pitapa kamaka pyakalyetala, kaitini kembo mende nyulu piambinopa, enjele dokome Pita yakinatala alu pia. ");
INSERT INTO enq2_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dopa peteamopa, Pitame masepae nyepala lao pituu, “Erotenya kinginya namba koeyasina lao Juu dupame masiminoaka doko, Kamongome baanya enjele mendeme namba nisala epena lame-lamo lao indupa nambame kiningi kandelyona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Dopa latala akali Jone, kenge mende Make lenge dokonya endangi Marianya andaka endakali longo mendapu kambu pyao loma soo peteami dokonya Pita baa pea. ");
INSERT INTO enq2_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pupala Pitame lome kambu doko gata-gata leamopa, kalai wanaku Roda lenge mendeme lumbala epea. ");
INSERT INTO enq2_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pitanya pii laluiyamo sepala, Roda baa eteke pyapala kaita doko lumbala naenya, alo pyao andaka kolandatala endakali dupa lamaiyoo, “Pita baa lome kambusa kalyamona” lea. ");
INSERT INTO enq2_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Dopa leamopa endakali peteami dupame wanaku doko lamaiyoo, “Emba kyakao lelyenona” leami. Dopa leaminopa, wanaku dokome kiningi etete Pita baa kalyamona lapeta siamosa dokaitame lao pituu, “Doko Pitanya enjele doko kalyumuna” leami. ");
INSERT INTO enq2_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Dopa leaminopa, Pitame lome kambu doko gata-gata laowaka kateamosa, dokaitame kaitini lumbateaminopa, Pita kateamo kandatala walu lao paka kaeyami. ");
INSERT INTO enq2_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dokopa endakali dupa pii nalena lao Pitame baanya kingimi makande pia. Dopa petala, baa anjetae palenge anda dokonya Kamongome mokao nyepala, kamaka laminao epea dokonya atome doko dokaita lamaiya. Lamaitala baame lao pituu, “Pii lelyo dupa nyakamame Jemesapi, Kristene kaiminingipi, dupa lamaiyepape” lea. Dopa latala baa yuu waka mendenya pea. ");
INSERT INTO enq2_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yongama amii dupame kandateaminopa Pita napaleamosa, aipa pyaape lao etete walu leami. ");
INSERT INTO enq2_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Dokopa Eroteme Pita kutakondape pyoo kutina lea. Kutao kaepeaminopa, Eroteme Pita isoo kateami amii dupa tipa pyoo sepala, dupa kamaka lanyoo pupala pyao kumasina lea. Dopa latala, Erote baa Judia yakinatala, lanao Sisaria pupala, gii mendatupa dokonya katea. ");
INSERT INTO enq2_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Taeya tangepi, Saidone tangepi, dupa Eroteme etete imbu kaeya. Dopa piamosa, dokaita Kiŋi Erotenya yuu dokonya-tae nee nengema dokonyana, endakali dupa pii mendai lao kambutala Erote pii lamaiya epeami. Ipao kiŋinya palenge anda isingi akali Balasatusa lenge doko andiki petala, pii epe mendapu lamaiya pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Gii nyepae mendenya Eroteme kiŋinya yati pingi dupa petala, kiŋi petenge toko dokonya pituu, endakali dupa pii andake mende lamaiya. ");
INSERT INTO enq2_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dokopa endakali dupame puu lao, lao pituu, “Pii lelyamo dake endakali mendeme nalelyamo. Baa gote mendeme lelyamona” leami. ");
INSERT INTO enq2_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Dopa leaminopa, Eroteme Gote kenge andake maiya naeyamosa, Kamongonya enjele mendeme baa yuu mendai koeyasulu pia. Dopa piamosa, baa pipyame nao kumasia. ");
INSERT INTO enq2_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Dopa peteamopa, Gotenya pii doko mende lamai-lamai pyoo lao taeyami. ");
INSERT INTO enq2_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Gii dokopa muni akipi Banabasapa Solopame maiya pena leami dupa maitala, Jone kenge mende Make lenge doko lanyoo Jerusalema pilyiambi. ");
INSERT INTO enq2_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Siosa Antioko katea dokonya propetapi, mana lengepi, mendapu kateami dupanya kenge dupa: Banabasapi, Simione kenge mende Niga lenge dokopi, Sairini tange Lusiusapi, Galali isingi Erotepa tole katenge Manaenepi, Solopi, dutupa kateami. ");
INSERT INTO enq2_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Akali dutupame nee nanao Kamongo mambo pyao kateaminopa, Oli Spiritame dutupa lamaiyoo, “Banabasapa Solopa dolapome nambanya kalai pyekena lao nambame wii lao nyioli pyoo kalai pyekena, nyakamame dolapo aiyomba minani pyakalapape” lea. ");
INSERT INTO enq2_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Dopa leamosa, dokaitame gii mendatupa apata nee nanao loma soo katapala, akali dolapo aiyomba minani petakamai pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Oli Spiritame Solopa, Banabasapa pena leamopa, lanao Selusia peambi. Pupala sipi mendenya pituu Saiprusa peambi. ");
INSERT INTO enq2_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saiprusa yuu dokonya taono Salamisa dokonya pao pyakamatala, Juumanya lotuu anda dupanya Gotenya pii doko lao panao kateambi. Dokopa Joneme akali dolapo nisoo kalai pia. ");
INSERT INTO enq2_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Dupa Saiprusa ailene dokonya katao, ailene dokonya yangitena Paposa dokonya peami. Taono dokonya Juumanya nemango akali, sambo propeta Bar-Jisasa lenge mende kandeami. ");
INSERT INTO enq2_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yuu dokonya gapena, Sejiusa Paulusa lenge dokopa akali doko tole katengemba. Sejiusa Paulusa doko baa masepae epe singi akali mende. Baame Gotenya pii doko sotoo lao masetala, Banabasapa Solopa epena lao lanyala pena lea. ");
INSERT INTO enq2_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Dopaka doko, nemango akali Bar-Jisasa, Giriki piimi kenge mende Elimasa lenge dokome gapena doko Jisasa tungi napina latala, akali dolapo kaita lyokea. ");
INSERT INTO enq2_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dokopa Solo, kenge mende Polo lenge doko Oli Spiritame tumbiamopa, baame Elimasa kandatae katao ");
INSERT INTO enq2_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","dapa lea: “Emba Satanenya mandipae dokome mana tolatae dupa pitaka yanda pimaingi. Luingi manapi, endakali minakasingi manapi, dupa emba-kisa tumbatae. Emba dopa petae dokome Kamongonya kaitini tolatae dupa tanga-tangapi koeyasoaka katate-lamo! ");
INSERT INTO enq2_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Indupa Kamongonya imbu kaenge doko emba-kisa ipupala, embanya lenge dolapo iminjetamopa, niki doko nakandao gii mendatupa kalyapenona” lea. Dopa lalu piamopa, baanya lenge dolapo kopame sanga pyatala iminjia. Dopa piamopa baa tomalya-tomane pyoo, endakali mendeme kii minina lao kutia. ");
INSERT INTO enq2_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Dopa piamo doko gapena dokome kandatala, Kamongonya mana dupa dopale-lamo lao walu lao paka kaeyapala, baa Jisasa tungi pia. ");
INSERT INTO enq2_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Dokopa Polopi, endakali baa-pipa paeyamipi, dokaita taono Paposa doko yakinatala, sipi mendenya pituu, yuu Pampilia dokonya Pega siti dokonya peami. Dokonya katao Joneme akali dokaita yakinatala baa Jerusalema pilyia. ");
INSERT INTO enq2_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dokopa yangi dokaita Pega yakinatala, yuu Pisidia dokonya Antioko siti dokonya peami. Pupala Sambata gii dokonya dokaita lotuu anda mendenya kolandatala peteami. ");
INSERT INTO enq2_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Dokopa lotuu anda isingi akali dupame Mosesanya loo bukupi, propeta dupanya bukupi, dupa itaki pyao kandatala, Polopi, baa-pipa epeamipi, dupa lamaiya pena latala lamaiyoo, “Kaimii paluma, nyakamame endakali dakaita kyeto maiyoo lamaipenge pii mende setamo doko lamaiyepa” lelyaminona lao lamaiya pena leami. ");
INSERT INTO enq2_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dopa lamaitiaminopa Polo toeya katapala, baanya kingimi endakali dupa pii nalena lao makande petala lamaiyoo, “Nyakama Israelepi, nyakama akali tata waka Gote paka kaengepi, dupame salapape. ");
INSERT INTO enq2_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelemanya Gote dokome naimanya yumbange dupa yapao nyia-pyaa. Yapao nyepae dokaita Ijipi yuu dokonya tisa kateaminopa, Goteme dokaita akali tata andake jisia. Dopa petala, baanya kyeto dokome dokaita Ijipi yakinena latala lanyoo pea. ");
INSERT INTO enq2_vpl VALUES ("AC13_18","074_13_18"