﻿USE sofia;
DROP TABLE IF EXISTS sofia.engylt_vpl;
CREATE TABLE engylt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engylt_vpl WRITE;
INSERT INTO engylt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the beginning of God's preparing the heavens and the earth — ");
INSERT INTO engylt_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","the earth hath existed waste and void, and darkness is on the face of the deep, and the Spirit of God fluttering on the face of the waters, ");
INSERT INTO engylt_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","and God saith, 'Let light be;' and light is. ");
INSERT INTO engylt_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","And God seeth the light that it is good, and God separateth between the light and the darkness, ");
INSERT INTO engylt_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","and God calleth to the light 'Day,' and to the darkness He hath called 'Night;' and there is an evening, and there is a morning — day one. ");
INSERT INTO engylt_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","And God saith, 'Let an expanse be in the midst of the waters, and let it be separating between waters and waters.' ");
INSERT INTO engylt_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","And God maketh the expanse, and it separateth between the waters which are under the expanse, and the waters which are above the expanse: and it is so. ");
INSERT INTO engylt_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","And God calleth to the expanse 'Heavens;' and there is an evening, and there is a morning — day second. ");
INSERT INTO engylt_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","And God saith, 'Let the waters under the heavens be collected unto one place, and let the dry land be seen:' and it is so. ");
INSERT INTO engylt_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","And God calleth to the dry land 'Earth,' and to the collection of the waters He hath called 'Seas;' and God seeth that it is good. ");
INSERT INTO engylt_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","And God saith, 'Let the earth yield tender grass, herb sowing seed, fruit-tree (whose seed is in itself) making fruit after its kind, on the earth:' and it is so. ");
INSERT INTO engylt_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","And the earth bringeth forth tender grass, herb sowing seed after its kind, and tree making fruit (whose seed is in itself) after its kind; and God seeth that it is good; ");
INSERT INTO engylt_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","and there is an evening, and there is a morning — day third. ");
INSERT INTO engylt_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","And God saith, 'Let luminaries be in the expanse of the heavens, to make a separation between the day and the night, then they have been for signs, and for seasons, and for days and years, ");
INSERT INTO engylt_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","and they have been for luminaries in the expanse of the heavens to give light upon the earth:' and it is so. ");
INSERT INTO engylt_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","And God maketh the two great luminaries, the great luminary for the rule of the day, and the small luminary — and the stars — for the rule of the night; ");
INSERT INTO engylt_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","and God giveth them in the expanse of the heavens to give light upon the earth, ");
INSERT INTO engylt_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","and to rule over day and over night, and to make a separation between the light and the darkness; and God seeth that it is good; ");
INSERT INTO engylt_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","and there is an evening, and there is a morning — day fourth. ");
INSERT INTO engylt_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","And God saith, 'Let the waters teem with the teeming living creature, and fowl let fly on the earth on the face of the expanse of the heavens.' ");
INSERT INTO engylt_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","And God prepareth the great monsters, and every living creature that is creeping, which the waters have teemed with, after their kind, and every fowl with wing, after its kind, and God seeth that it is good. ");
INSERT INTO engylt_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","And God blesseth them, saying, 'Be fruitful, and multiply, and fill the waters in the seas, and the fowl let multiply in the earth:' ");
INSERT INTO engylt_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","and there is an evening, and there is a morning — day fifth. ");
INSERT INTO engylt_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","And God saith, 'Let the earth bring forth the living creature after its kind, cattle and creeping thing, and beast of the earth after its kind:' and it is so. ");
INSERT INTO engylt_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","And God maketh the beast of the earth after its kind, and the cattle after their kind, and every creeping thing of the ground after its kind, and God seeth that it is good. ");
INSERT INTO engylt_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","And God saith, 'Let Us make man in Our image, according to Our likeness, and let them rule over fish of the sea, and over fowl of the heavens, and over cattle, and over all the earth, and over every creeping thing that is creeping on the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","And God prepareth the man in His image; in the image of God He prepared him, a male and a female He prepared them. ");
INSERT INTO engylt_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","And God blesseth them, and God saith to them, 'Be fruitful, and multiply, and fill the earth, and subdue it, and rule over fish of the sea, and over fowl of the heavens, and over every living thing that is creeping upon the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","And God saith, 'Lo, I have given to you every herb sowing seed, which is upon the face of all the earth, and every tree in which is the fruit of a tree sowing seed, to you it is for food; ");
INSERT INTO engylt_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","and to every beast of the earth, and to every fowl of the heavens, and to every creeping thing on the earth, in which is breath of life, every green herb is for food:' and it is so. ");
INSERT INTO engylt_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","And God seeth all that He hath done, and lo, very good; and there is an evening, and there is a morning — day the sixth. ");
INSERT INTO engylt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","And the heavens and the earth are completed, and all their host; ");
INSERT INTO engylt_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","and God completeth by the seventh day His work which He hath made, and ceaseth by the seventh day from all His work which He hath made. ");
INSERT INTO engylt_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","And God blesseth the seventh day, and sanctifieth it, for in it He hath ceased from all His work which God had prepared for making. ");
INSERT INTO engylt_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","These are births of the heavens and of the earth in their being prepared, in the day of Jehovah God's making earth and heavens; ");
INSERT INTO engylt_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","and no shrub of the field is yet in the earth, and no herb of the field yet sprouteth, for Jehovah God hath not rained upon the earth, and a man there is not to serve the ground, ");
INSERT INTO engylt_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","and a mist goeth up from the earth, and hath watered the whole face of the ground. ");
INSERT INTO engylt_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","And Jehovah God formeth the man — dust from the ground, and breatheth into his nostrils breath of life, and the man becometh a living creature. ");
INSERT INTO engylt_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","And Jehovah God planteth a garden in Eden, at the east, and He setteth there the man whom He hath formed; ");
INSERT INTO engylt_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","and Jehovah God causeth to sprout from the ground every tree desirable for appearance, and good for food, and the tree of life in the midst of the garden, and the tree of knowledge of good and evil. ");
INSERT INTO engylt_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","And a river is going out from Eden to water the garden, and from thence it is parted, and hath become four chief rivers; ");
INSERT INTO engylt_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","the name of the one is Pison, it is that which is surrounding the whole land of the Havilah where the gold is, ");
INSERT INTO engylt_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","and the gold of that land is good, there is the bdolach and the shoham stone; ");
INSERT INTO engylt_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","and the name of the second river is Gibon, it is that which is surrounding the whole land of Cush; ");
INSERT INTO engylt_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","and the name of the third river is Hiddekel, it is that which is going east of Asshur; and the fourth river is Phrat. ");
INSERT INTO engylt_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","And Jehovah God taketh the man, and causeth him to rest in the garden of Eden, to serve it, and to keep it. ");
INSERT INTO engylt_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","And Jehovah God layeth a charge on the man, saying, 'Of every tree of the garden eating thou dost eat; ");
INSERT INTO engylt_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","and of the tree of knowledge of good and evil, thou dost not eat of it, for in the day of thine eating of it — dying thou dost die.' ");
INSERT INTO engylt_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","And Jehovah God saith, 'Not good for the man to be alone, I do make to him an helper — as his counterpart.' ");
INSERT INTO engylt_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","And Jehovah God formeth from the ground every beast of the field, and every fowl of the heavens, and bringeth in unto the man, to see what he doth call it; and whatever the man calleth a living creature, that is its name. ");
INSERT INTO engylt_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","And the man calleth names to all the cattle, and to fowl of the heavens, and to every beast of the field; and to man hath not been found an helper — as his counterpart. ");
INSERT INTO engylt_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","And Jehovah God causeth a deep sleep to fall upon the man, and he sleepeth, and He taketh one of his ribs, and closeth up flesh in its stead. ");
INSERT INTO engylt_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","And Jehovah God buildeth up the rib which He hath taken out of the man into a woman, and bringeth her in unto the man; ");
INSERT INTO engylt_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","and the man saith, 'This is the proper step! bone of my bone, and flesh of my flesh!' for this it is called Woman, for from a man hath this been taken; ");
INSERT INTO engylt_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","therefore doth a man leave his father and his mother, and hath cleaved unto his wife, and they have become one flesh. ");
INSERT INTO engylt_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","And they are both of them naked, the man and his wife, and they are not ashamed of themselves. ");
INSERT INTO engylt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","And the serpent hath been subtile above every beast of the field which Jehovah God hath made, and he saith unto the woman, 'Is it true that God hath said, Ye do not eat of every tree of the garden?' ");
INSERT INTO engylt_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","And the woman saith unto the serpent, 'Of the fruit of the trees of the garden we do eat, ");
INSERT INTO engylt_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","and of the fruit of the tree which is in the midst of the garden God hath said, Ye do not eat of it, nor touch it, lest ye die.' ");
INSERT INTO engylt_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","And the serpent saith unto the woman, 'Dying, ye do not die, ");
INSERT INTO engylt_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","for God doth know that in the day of your eating of it — your eyes have been opened, and ye have been as God, knowing good and evil.' ");
INSERT INTO engylt_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","And the woman seeth that the tree is good for food, and that it is pleasant to the eyes, and the tree is desirable to make one wise, and she taketh of its fruit and eateth, and giveth also to her husband with her, and he doth eat; ");
INSERT INTO engylt_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","and the eyes of them both are opened, and they know that they are naked, and they sew fig-leaves, and make to themselves girdles. ");
INSERT INTO engylt_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","And they hear the sound of Jehovah God walking up and down in the garden at the breeze of the day, and the man and his wife hide themselves from the face of Jehovah God in the midst of the trees of the garden. ");
INSERT INTO engylt_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","And Jehovah God calleth unto the man, and saith to him, 'Where art thou?' ");
INSERT INTO engylt_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","and he saith, 'Thy sound I have heard in the garden, and I am afraid, for I am naked, and I hide myself.' ");
INSERT INTO engylt_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","And He saith, 'Who hath declared to thee that thou art naked? of the tree of which I have commanded thee not to eat, hast thou eaten?' ");
INSERT INTO engylt_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","and the man saith, 'The woman whom Thou didst place with me — she hath given to me of the tree — and I do eat.' ");
INSERT INTO engylt_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","And Jehovah God saith to the woman, 'What is this thou hast done?' and the woman saith, 'The serpent hath caused me to forget — and I do eat.' ");
INSERT INTO engylt_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","And Jehovah God saith unto the serpent, 'Because thou hast done this, cursed art thou above all the cattle, and above every beast of the field: on thy belly dost thou go, and dust thou dost eat, all days of thy life; ");
INSERT INTO engylt_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","and enmity I put between thee and the woman, and between thy seed and her seed; he doth bruise thee — the head, and thou dost bruise him — the heel.' ");
INSERT INTO engylt_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Unto the woman He said, 'Multiplying I multiply thy sorrow and thy conception, in sorrow dost thou bear children, and toward thy husband is thy desire, and he doth rule over thee.' ");
INSERT INTO engylt_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","And to the man He said, 'Because thou hast hearkened to the voice of thy wife, and dost eat of the tree concerning which I have charged thee, saying, Thou dost not eat of it, cursed is the ground on thine account; in sorrow thou dost eat of it all days of thy life, ");
INSERT INTO engylt_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","and thorn and bramble it doth bring forth to thee, and thou hast eaten the herb of the field; ");
INSERT INTO engylt_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","by the sweat of thy face thou dost eat bread till thy return unto the ground, for out of it hast thou been taken, for dust thou art, and unto dust thou turnest back.' ");
INSERT INTO engylt_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","And the man calleth his wife's name Eve: for she hath been mother of all living. ");
INSERT INTO engylt_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","And Jehovah God doth make to the man and to his wife coats of skin, and doth clothe them. ");
INSERT INTO engylt_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","And Jehovah God saith, 'Lo, the man was as one of Us, as to the knowledge of good and evil; and now, lest he send forth his hand, and have taken also of the tree of life, and eaten, and lived to the age,' — ");
INSERT INTO engylt_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Jehovah God sendeth him forth from the garden of Eden to serve the ground from which he hath been taken; ");
INSERT INTO engylt_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","yea, he casteth out the man, and causeth to dwell at the east of the garden of Eden the cherubs and the flame of the sword which is turning itself round to guard the way of the tree of life. ");
INSERT INTO engylt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","And the man knew Eve his wife, and she conceiveth and beareth Cain, and saith, 'I have gotten a man by Jehovah;' ");
INSERT INTO engylt_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","and she addeth to bear his brother, even Abel. And Abel is feeding a flock, and Cain hath been servant of the ground. ");
INSERT INTO engylt_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","And it cometh to pass at the end of days that Cain bringeth from the fruit of the ground a present to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","and Abel, he hath brought, he also, from the female firstlings of his flock, even from their fat ones; and Jehovah looketh unto Abel and unto his present, ");
INSERT INTO engylt_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","and unto Cain and unto his present He hath not looked; and it is very displeasing to Cain, and his countenance is fallen. ");
INSERT INTO engylt_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","And Jehovah saith unto Cain, 'Why hast thou displeasure? and why hath thy countenance fallen? ");
INSERT INTO engylt_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Is there not, if thou dost well, acceptance? and if thou dost not well, at the opening a sin-offering is crouching, and unto thee its desire, and thou rulest over it.' ");
INSERT INTO engylt_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","And Cain saith unto Abel his brother, 'Let us go into the field;' and it cometh to pass in their being in the field, that Cain riseth up against Abel his brother, and slayeth him. ");
INSERT INTO engylt_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","And Jehovah saith unto Cain, 'Where is Abel thy brother?' and he saith, 'I have not known; my brother's keeper — I?' ");
INSERT INTO engylt_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","And He saith, 'What hast thou done? the voice of thy brother's blood is crying unto Me from the ground; ");
INSERT INTO engylt_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","and now, cursed art thou from the ground, which hath opened her mouth to receive the blood of thy brother from thy hand; ");
INSERT INTO engylt_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","when thou tillest the ground, it doth not add to give its strength to thee — a wanderer, even a trembling one, thou art in the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","And Cain saith unto Jehovah, 'Greater is my punishment than to be borne; ");
INSERT INTO engylt_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","lo, Thou hast driven me to-day from off the face of the ground, and from Thy face I am hid; and I have been a wanderer, even a trembling one, in the earth, and it hath been — every one finding me doth slay me.' ");
INSERT INTO engylt_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","And Jehovah saith to him, 'Therefore — of any slayer of Cain sevenfold it is required;' and Jehovah setteth to Cain a token that none finding him doth slay him. ");
INSERT INTO engylt_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","And Cain goeth out from before Jehovah, and dwelleth in the land, moving about east of Eden; ");
INSERT INTO engylt_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","and Cain knoweth his wife, and she conceiveth, and beareth Enoch; and he is building a city, and he calleth the name of the city, according to the name of his son — Enoch. ");
INSERT INTO engylt_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","And born to Enoch is Irad; and Irad hath begotten Mehujael; and Mehujael hath begotten Methusael; and Methusael hath begotten Lamech. ");
INSERT INTO engylt_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","And Lamech taketh to himself two wives, the name of the one Adah, and the name of the second Zillah. ");
INSERT INTO engylt_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","And Adah beareth Jabal, he hath been father of those inhabiting tents and purchased possessions; ");
INSERT INTO engylt_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","and the name of his brother is Jubal, he hath been father of every one handling harp and organ. ");
INSERT INTO engylt_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","And Zillah she also bare Tubal-Cain, an instructor of every artificer in brass and iron; and a sister of Tubal-Cain is Naamah. ");
INSERT INTO engylt_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","And Lamech saith to his wives: — 'Adah and Zillah, hear my voice; Wives of Lamech, give ear to my saying: For a man I have slain for my wound, Even a young man for my hurt; ");
INSERT INTO engylt_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","For sevenfold is required for Cain, And for Lamech seventy and sevenfold.' ");
INSERT INTO engylt_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","And Adam again knoweth his wife, and she beareth a son, and calleth his name Seth, 'for God hath appointed for me another seed instead of Abel:' for Cain had slain him. ");
INSERT INTO engylt_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","And to Seth, to him also a son hath been born, and he calleth his name Enos; then a beginning was made of preaching in the name of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is an account of the births of Adam: In the day of God's preparing man, in the likeness of God He hath made him; ");
INSERT INTO engylt_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","a male and a female He hath prepared them, and He blesseth them, and calleth their name Man, in the day of their being prepared. ");
INSERT INTO engylt_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","And Adam liveth an hundred and thirty years, and begetteth a son in his likeness, according to his image, and calleth his name Seth. ");
INSERT INTO engylt_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","And the days of Adam after his begetting Seth are eight hundred years, and he begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","And all the days of Adam which he lived are nine hundred and thirty years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","And Seth liveth an hundred and five years, and begetteth Enos. ");
INSERT INTO engylt_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","And Seth liveth after his begetting Enos eight hundred and seven years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","And all the days of Seth are nine hundred and twelve years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","And Enos liveth ninety years, and begetteth Cainan. ");
INSERT INTO engylt_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","And Enos liveth after his begetting Cainan eight hundred and fifteen years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","And all the days of Enos are nine hundred and five years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","And Cainan liveth seventy years, and begetteth Mahalaleel. ");
INSERT INTO engylt_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","And Cainan liveth after his begetting Mahalaleel eight hundred and forty years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","And all the days of Cainan are nine hundred and ten years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","And Mahalaleel liveth five and sixty years, and begetteth Jared. ");
INSERT INTO engylt_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","And Mahalaleel liveth after his begetting Jared eight hundred and thirty years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","And all the days of Mahalaleel are eight hundred and ninety and five years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","And Jared liveth an hundred and sixty and two years, and begetteth Enoch. ");
INSERT INTO engylt_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","And Jared liveth after his begetting Enoch eight hundred years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","And all the days of Jared are nine hundred and sixty and two years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","And Enoch liveth five and sixty years, and begetteth Methuselah. ");
INSERT INTO engylt_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","And Enoch walketh habitually with God after his begetting Methuselah three hundred years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","And all the days of Enoch are three hundred and sixty and five years. ");
INSERT INTO engylt_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","And Enoch walketh habitually with God, and he is not, for God hath taken him. ");
INSERT INTO engylt_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","And Methuselah liveth an hundred and eighty and seven years, and begetteth Lamech. ");
INSERT INTO engylt_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","And Methuselah liveth after his begetting Lamech seven hundred and eighty and two years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","And all the days of Methuselah are nine hundred and sixty and nine years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","And Lamech liveth an hundred and eighty and two years, and begetteth a son, ");
INSERT INTO engylt_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","and calleth his name Noah, saying, 'This one doth comfort us concerning our work, and concerning the labour of our hands, because of the ground which Jehovah hath cursed.' ");
INSERT INTO engylt_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","And Lamech liveth after his begetting Noah five hundred and ninety and five years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","And all the days of Lamech are seven hundred and seventy and seven years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","And Noah is a son of five hundred years, and Noah begetteth Shem, Ham, and Japheth. ");
INSERT INTO engylt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","And it cometh to pass that mankind have begun to multiply on the face of the ground, and daughters have been born to them, ");
INSERT INTO engylt_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","and sons of God see the daughters of men that they are fair, and they take to themselves women of all whom they have chosen. ");
INSERT INTO engylt_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","And Jehovah saith, 'My Spirit doth not strive in man — to the age; in their erring they are flesh:' and his days have been an hundred and twenty years. ");
INSERT INTO engylt_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","The fallen ones were in the earth in those days, and even afterwards when sons of God come in unto daughters of men, and they have borne to them — they are the heroes, who, from of old, are the men of name. ");
INSERT INTO engylt_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","And Jehovah seeth that abundant is the wickedness of man in the earth, and every imagination of the thoughts of his heart only evil all the day; ");
INSERT INTO engylt_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","and Jehovah repenteth that He hath made man in the earth, and He grieveth Himself — unto His heart. ");
INSERT INTO engylt_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","And Jehovah saith, 'I wipe away man whom I have prepared from off the face of the ground, from man unto beast, unto creeping thing, and unto fowl of the heavens, for I have repented that I have made them.' ");
INSERT INTO engylt_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","And Noah found grace in the eyes of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","These are births of Noah: Noah is a righteous man; perfect he hath been among his generations; with God hath Noah walked habitually. ");
INSERT INTO engylt_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","And Noah begetteth three sons, Shem, Ham, and Japheth. ");
INSERT INTO engylt_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","And the earth is corrupt before God, and the earth is filled with violence. ");
INSERT INTO engylt_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","And God seeth the earth, and lo, it hath been corrupted, for all flesh hath corrupted its way on the earth. ");
INSERT INTO engylt_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","And God said to Noah, 'An end of all flesh hath come before Me, for the earth hath been full of violence from their presence; and lo, I am destroying them with the earth. ");
INSERT INTO engylt_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","'Make for thyself an ark of gopher-wood; rooms dost thou make with the ark, and thou hast covered it within and without with cypress; ");
INSERT INTO engylt_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","and this is that which thou dost with it: three hundred cubits is the length of the ark, fifty cubits its breadth, and thirty cubits its height; ");
INSERT INTO engylt_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","a window dost thou make for the ark, and unto a cubit thou dost restrain it from above; and the opening of the ark thou dost put in its side, — lower, second, and third stories dost thou make it. ");
INSERT INTO engylt_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","'And I, lo, I am bringing in the deluge of waters on the earth to destroy all flesh, in which is a living spirit, from under the heavens; all that is in the earth doth expire. ");
INSERT INTO engylt_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","'And I have established My covenant with thee, and thou hast come in unto the ark, thou, and thy sons, and thy wife, and thy son's wives with thee; ");
INSERT INTO engylt_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","and of all that liveth, of all flesh, two of every sort thou dost bring in unto the ark, to keep alive with thee; male and female are they. ");
INSERT INTO engylt_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Of the fowl after its kind, and of the cattle after their kind, of every creeping thing of the ground after its kind, two of every sort they come in unto thee, to keep alive. ");
INSERT INTO engylt_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","'And thou, take to thyself of all food that is eaten; and thou hast gathered unto thyself, and it hath been to thee and to them for food.' ");
INSERT INTO engylt_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","And Noah doth according to all that God hath commanded him; so hath he done. ");
INSERT INTO engylt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","And Jehovah saith to Noah, 'Come in, thou and all thy house, unto the ark, for thee I have seen righteous before Me in this generation; ");
INSERT INTO engylt_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","of all the clean beasts thou dost take to thee seven pairs, a male and its female; and of the beasts which are not clean two, a male and its female; ");
INSERT INTO engylt_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","also, of fowl of the heavens seven pairs, a male and a female, to keep alive seed on the face of all the earth; ");
INSERT INTO engylt_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","for after other seven days I am sending rain on the earth forty days and forty nights, and have wiped away all the substance that I have made from off the face of the ground.' ");
INSERT INTO engylt_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","And Noah doth according to all that Jehovah hath commanded him: ");
INSERT INTO engylt_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","and Noah is a son of six hundred years, and the deluge of waters hath been upon the earth. ");
INSERT INTO engylt_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","And Noah goeth in, and his sons, and his wife, and his sons' wives with him, unto the ark, from the presence of the waters of the deluge; ");
INSERT INTO engylt_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","of the clean beasts and of the beasts that are not clean, and of the fowl, and of every thing that is creeping upon the ground, ");
INSERT INTO engylt_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","two by two they have come in unto Noah, unto the ark, a male and a female, as God hath commanded Noah. ");
INSERT INTO engylt_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","And it cometh to pass, after the seventh of the days, that waters of the deluge have been on the earth. ");
INSERT INTO engylt_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of the life of Noah, in the second month, in the seventeenth day of the month, in this day have been broken up all fountains of the great deep, and the net-work of the heavens hath been opened, ");
INSERT INTO engylt_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","and the shower is on the earth forty days and forty nights. ");
INSERT INTO engylt_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","In this self-same day went in Noah, and Shem, and Ham, and Japheth, sons of Noah, and Noah's wife and the three wives of his sons with them, unto the ark; ");
INSERT INTO engylt_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","they, and every living creature after its kind, and every beast after its kind, and every creeping thing that is creeping on the earth after its kind, and every fowl after its kind, every bird — every wing. ");
INSERT INTO engylt_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","And they come in unto Noah, unto the ark, two by two of all the flesh in which is a living spirit; ");
INSERT INTO engylt_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","and they that are coming in, male and female of all flesh, have come in as God hath commanded him, and Jehovah doth close it for him. ");
INSERT INTO engylt_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","And the deluge is forty days on the earth, and the waters multiply, and lift up the ark, and it is raised up from off the earth; ");
INSERT INTO engylt_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","and the waters are mighty, and multiply exceedingly upon the earth; and the ark goeth on the face of the waters. ");
INSERT INTO engylt_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","And the waters have been very very mighty on the earth, and covered are all the high mountains which are under the whole heavens; ");
INSERT INTO engylt_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","fifteen cubits upwards have the waters become mighty, and the mountains are covered; ");
INSERT INTO engylt_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","and expire doth all flesh that is moving on the earth, among fowl, and among cattle, and among beasts, and among all the teeming things which are teeming on the earth, and all mankind; ");
INSERT INTO engylt_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","all in whose nostrils is breath of a living spirit — of all that is in the dry land — have died. ");
INSERT INTO engylt_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","And wiped away is all the substance that is on the face of the ground, from man unto beast, unto creeping thing, and unto fowl of the heavens; yea, they are wiped away from the earth, and only Noah is left, and those who are with him in the ark; ");
INSERT INTO engylt_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","and the waters are mighty on the earth a hundred and fifty days. ");
INSERT INTO engylt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","And God remembereth Noah, and every living thing, and all the cattle which are with him in the ark, and God causeth a wind to pass over the earth, and the waters subside, ");
INSERT INTO engylt_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","and closed are the fountains of the deep and the net-work of the heavens, and restrained is the shower from the heavens. ");
INSERT INTO engylt_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","And turn back do the waters from off the earth, going on and returning; and the waters are lacking at the end of a hundred and fifty days. ");
INSERT INTO engylt_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","And the ark resteth, in the seventh month, in the seventeenth day of the month, on mountains of Ararat; ");
INSERT INTO engylt_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","and the waters have been going and becoming lacking till the tenth month; in the tenth month, on the first of the month, appeared the heads of the mountains. ");
INSERT INTO engylt_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","And it cometh to pass, at the end of forty days, that Noah openeth the window of the ark which he made, ");
INSERT INTO engylt_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","and he sendeth forth the raven, and it goeth out, going out and turning back till the drying of the waters from off the earth. ");
INSERT INTO engylt_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","And he sendeth forth the dove from him to see whether the waters have been lightened from off the face of the ground, ");
INSERT INTO engylt_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","and the dove hath not found rest for the sole of her foot, and she turneth back unto him, unto the ark, for waters are on the face of all the earth, and he putteth out his hand, and taketh her, and bringeth her in unto him, unto the ark. ");
INSERT INTO engylt_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","And he stayeth yet other seven days, and addeth to send forth the dove from the ark; ");
INSERT INTO engylt_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","and the dove cometh in unto him at even-time, and lo, an olive leaf torn off in her mouth; and Noah knoweth that the waters have been lightened from off the earth. ");
INSERT INTO engylt_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","And he stayeth yet other seven days, and sendeth forth the dove, and it added not to turn back unto him any more. ");
INSERT INTO engylt_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","And it cometh to pass in the six hundredth and first year, in the first month, in the first of the month, the waters have been dried from off the earth; and Noah turneth aside the covering of the ark, and looketh, and lo, the face of the ground hath been dried. ");
INSERT INTO engylt_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","And in the second month, in the seven and twentieth day of the month, the earth hath become dry. ");
INSERT INTO engylt_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","And God speaketh unto Noah, saying, 'Go out from the ark, thou, and thy wife, and thy sons, and thy sons' wives with thee; ");
INSERT INTO engylt_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","every living thing that is with thee, of all flesh, among fowl, and among cattle, and among every creeping thing which is creeping on the earth, bring out with thee; ");
INSERT INTO engylt_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","and they have teemed in the earth, and been fruitful, and have multiplied on the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","And Noah goeth out, and his sons, and his wife, and his sons' wives with him; ");
INSERT INTO engylt_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","every beast, every creeping thing, and every fowl; every creeping thing on the earth, after their families, have gone out from the ark. ");
INSERT INTO engylt_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","And Noah buildeth an altar to Jehovah, and taketh of every clean beast, and of every clean fowl, and causeth burnt-offerings to ascend on the altar; ");
INSERT INTO engylt_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","and Jehovah smelleth the sweet fragrance, and Jehovah saith unto His heart, 'I continue not to disesteem any more the ground because of man, though the imagination of the heart of man is evil from his youth; and I continue not to smite any more all living, as I have done; ");
INSERT INTO engylt_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","during all days of the earth, seed-time and harvest, and cold and heat, and summer and winter, and day and night, do not cease.' ");
INSERT INTO engylt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","And God blesseth Noah, and his sons, and saith to them, 'Be fruitful, and multiply, and fill the earth; ");
INSERT INTO engylt_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","and your fear and your dread is on every beast of the earth, and on every fowl of the heavens, on all that creepeth on the ground, and on all fishes of the sea — into your hand they have been given. ");
INSERT INTO engylt_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every creeping thing that is alive, to you it is for food; as the green herb I have given to you the whole; ");
INSERT INTO engylt_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","only flesh in its life — its blood — ye do not eat. ");
INSERT INTO engylt_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","'And only your blood for your lives do I require; from the hand of every living thing I require it, and from the hand of man, from the hand of every man's brother I require the life of man; ");
INSERT INTO engylt_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","whoso sheddeth man's blood, by man is his blood shed: for in the image of God hath He made man. ");
INSERT INTO engylt_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","And ye, be fruitful and multiply, teem in the earth, and multiply in it.' ");
INSERT INTO engylt_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","And God speaketh unto Noah, and unto his sons with him, saying, ");
INSERT INTO engylt_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","'And I, lo, I am establishing My covenant with you, and with your seed after you, ");
INSERT INTO engylt_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with every living creature which is with you, among fowl, among cattle, and among every beast of the earth with you, from all who are going out of the ark — to every beast of the earth. ");
INSERT INTO engylt_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","And I have established My covenant with you, and all flesh is not any more cut off by waters of a deluge, and there is not any more a deluge to destroy the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And God saith, 'This is a token of the covenant which I am giving between Me and you, and every living creature that is with you, to generations age-during; ");
INSERT INTO engylt_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","My bow I have given in the cloud, and it hath been for a token of a covenant between Me and the earth; ");
INSERT INTO engylt_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","and it hath come to pass (in My sending a cloud over the earth) that the bow hath been seen in the cloud, ");
INSERT INTO engylt_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","and I have remembered My covenant which is between Me and you, and every living creature among all flesh, and the waters become no more a deluge to destroy all flesh; ");
INSERT INTO engylt_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","and the bow hath been in the cloud, and I have seen it — to remember the covenant age-during between God and every living creature among all flesh which is on the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","And God saith unto Noah, 'This is a token of the covenant which I have established between Me and all flesh that is upon the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","And the sons of Noah who are going out of the ark are Shem, and Ham, and Japheth; and Ham is father of Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three are sons of Noah, and from these hath all the earth been overspread. ");
INSERT INTO engylt_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","And Noah remaineth a man of the ground, and planteth a vineyard, ");
INSERT INTO engylt_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","and drinketh of the wine, and is drunken, and uncovereth himself in the midst of the tent. ");
INSERT INTO engylt_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","And Ham, father of Canaan, seeth the nakedness of his father, and declareth to his two brethren without. ");
INSERT INTO engylt_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","And Shem taketh — Japheth also — the garment, and they place on the shoulder of them both, and go backward, and cover the nakedness of their father; and their faces are backward, and their father's nakedness they have not seen. ");
INSERT INTO engylt_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","And Noah awaketh from his wine, and knoweth that which his young son hath done to him, ");
INSERT INTO engylt_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","and saith: 'Cursed is Canaan, Servant of servants he is to his brethren.' ");
INSERT INTO engylt_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","And he saith: 'Blessed of Jehovah my God is Shem, And Canaan is servant to him. ");
INSERT INTO engylt_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God doth give beauty to Japheth, And he dwelleth in tents of Shem, And Canaan is servant to him.' ");
INSERT INTO engylt_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","And Noah liveth after the deluge three hundred and fifty years; ");
INSERT INTO engylt_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","and all the days of Noah are nine hundred and fifty years, and he dieth. ");
INSERT INTO engylt_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","And these are births of the sons of Noah, Shem, Ham, and Japheth; and born to them are sons after the deluge. ");
INSERT INTO engylt_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","'Sons of Japheth are Gomer, and Magog, and Madai, and Javan, and Tubal, and Meshech, and Tiras. ");
INSERT INTO engylt_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","And sons of Gomer are Ashkenaz, and Riphath, and Togarmah. ");
INSERT INTO engylt_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","And sons of Javan are Elishah, and Tarshish, Kittim, and Dodanim. ");
INSERT INTO engylt_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","By these have the isles of the nations been parted in their lands, each by his tongue, by their families, in their nations. ");
INSERT INTO engylt_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","And sons of Ham are Cush, and Mitzraim, and Phut, and Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","And sons of Cush are Seba, and Havilah, and Sabtah, and Raamah, and Sabtechah; and sons of Raamah are Sheba and Dedan. ");
INSERT INTO engylt_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","And Cush hath begotten Nimrod; ");
INSERT INTO engylt_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","he hath begun to be a hero in the land; he hath been a hero in hunting before Jehovah; therefore it is said, 'As Nimrod the hero in hunting before Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","And the first part of his kingdom is Babel, and Erech, and Accad, and Calneh, in the land of Shinar; ");
INSERT INTO engylt_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","from that land he hath gone out to Asshur, and buildeth Nineveh, even the broad places of the city, and Calah, ");
INSERT INTO engylt_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen, between Nineveh and Calah; it is the great city. ");
INSERT INTO engylt_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","And Mitzraim hath begotten the Ludim, and the Anamim, and the Lehabim, and the Naphtuhim, ");
INSERT INTO engylt_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","and the Pathrusim, and the Casluhim, (whence have come out Philistim,) and the Caphtorim. ");
INSERT INTO engylt_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","And Canaan hath begotten Sidon his first-born, and Heth, ");
INSERT INTO engylt_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","and the Jebusite, and the Amorite, and the Girgashite, ");
INSERT INTO engylt_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","and the Hivite, and the Arkite, and the Sinite, ");
INSERT INTO engylt_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","and the Arvadite, and the Zemarite, and the Hamathite; and afterwards have the families of the Canaanite been scattered. ");
INSERT INTO engylt_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","And the border of the Canaanite is from Sidon, in thy coming towards Gerar, unto Gaza; in thy coming towards Sodom, and Gomorrah, and Admah, and Zeboim, unto Lasha. ");
INSERT INTO engylt_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These are sons of Ham, by their families, by their tongues, in their lands, in their nations. ");
INSERT INTO engylt_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","As to Shem, father of all sons of Eber, brother of Japheth the elder, he hath also begotten: ");
INSERT INTO engylt_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sons of Shem are Elam, and Asshur, and Arphaxad, and Lud, and Aram. ");
INSERT INTO engylt_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","And sons of Aram are Uz, and Hul, and Gether, and Mash. ");
INSERT INTO engylt_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","And Arphaxad hath begotten Salah, and Salah hath begotten Eber. ");
INSERT INTO engylt_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","And to Eber have two sons been born; the name of the one is Peleg (for in his days hath the earth been divided,) and his brother's name is Joktan. ");
INSERT INTO engylt_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","And Joktan hath begotten Almodad, and Sheleph, and Hazarmaveth, and Jerah, ");
INSERT INTO engylt_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","and Hadoram, and Uzal, and Diklah, ");
INSERT INTO engylt_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","and Obal, and Abimael, and Sheba, ");
INSERT INTO engylt_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","and Ophir, and Havilah, and Jobab; all these are sons of Joktan; ");
INSERT INTO engylt_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","and their dwelling is from Mesha, in thy coming towards Sephar, a mount of the east. ");
INSERT INTO engylt_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are sons of Shem, by their families, by their tongues, in their lands, by their nations. ");
INSERT INTO engylt_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These are families of the sons of Noah, by their births, in their nations, and by these have the nations been parted in the earth after the deluge. ");
INSERT INTO engylt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","And the whole earth is of one pronunciation, and of the same words, ");
INSERT INTO engylt_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","and it cometh to pass, in their journeying from the east, that they find a valley in the land of Shinar, and dwell there; ");
INSERT INTO engylt_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","and they say each one to his neighbour, 'Give help, let us make bricks, and burn them thoroughly:' and the brick is to them for stone, and the bitumen hath been to them for mortar. ");
INSERT INTO engylt_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","And they say, 'Give help, let us build for ourselves a city and tower, and its head in the heavens, and make for ourselves a name, lest we be scattered over the face of all the earth.' ");
INSERT INTO engylt_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","And Jehovah cometh down to see the city and the tower which the sons of men have builded; ");
INSERT INTO engylt_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","and Jehovah saith, 'Lo, the people is one, and one pronunciation is to them all, and this it hath dreamed of doing; and now, nothing is restrained from them of that which they have purposed to do. ");
INSERT INTO engylt_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Give help, let us go down, and mingle there their pronunciation, so that a man doth not understand the pronunciation of his companion.' ");
INSERT INTO engylt_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","And Jehovah doth scatter them from thence over the face of all the earth, and they cease to build the city; ");
INSERT INTO engylt_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","therefore hath one called its name Babel, for there hath Jehovah mingled the pronunciation of all the earth, and from thence hath Jehovah scattered them over the face of all the earth. ");
INSERT INTO engylt_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","These are births of Shem: Shem is a son of an hundred years, and begetteth Arphaxad two years after the deluge. ");
INSERT INTO engylt_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And Shem liveth after his begetting Arphaxad five hundred years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","And Arphaxad hath lived five and thirty years, and begetteth Salah. ");
INSERT INTO engylt_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And Arphaxad liveth after his begetting Salah four hundred and three years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","And Salah hath lived thirty years, and begetteth Eber. ");
INSERT INTO engylt_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And Salah liveth after his begetting Eber four hundred and three years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","And Eber liveth four and thirty years, and begetteth Peleg. ");
INSERT INTO engylt_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And Eber liveth after his begetting Peleg four hundred and thirty years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","And Peleg liveth thirty years, and begetteth Reu. ");
INSERT INTO engylt_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And Peleg liveth after his begetting Reu two hundred and nine years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","And Reu liveth two and thirty years, and begetteth Serug. ");
INSERT INTO engylt_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And Reu liveth after his begetting Serug two hundred and seven years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","And Serug liveth thirty years, and begetteth Nahor. ");
INSERT INTO engylt_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And Serug liveth after his begetting Nahor two hundred years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","And Nahor liveth nine and twenty years, and begetteth Terah. ");
INSERT INTO engylt_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And Nahor liveth after his begetting Terah an hundred and nineteen years, and begetteth sons and daughters. ");
INSERT INTO engylt_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","And Terah liveth seventy years, and begetteth Abram, Nahor, and Haran. ");
INSERT INTO engylt_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","And these are births of Terah: Terah hath begotten Abram, Nahor, and Haran; and Haran hath begotten Lot; ");
INSERT INTO engylt_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","and Haran dieth in the presence of Terah his father, in the land of his birth, in Ur of the Chaldees. ");
INSERT INTO engylt_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","And Abram and Nahor take to themselves wives; the name of Abram's wife is Sarai, and the name of Nahor's wife is Milcah, daughter of Haran, father of Milcah, and father of Iscah. ");
INSERT INTO engylt_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","And Sarai is barren — she hath no child. ");
INSERT INTO engylt_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","And Terah taketh Abram his son, and Lot, son of Haran, his son's son, and Sarai his daughter-in-law, wife of Abram his son, and they go out with them from Ur of the Chaldees, to go towards the land of Canaan; and they come unto Charan, and dwell there. ");
INSERT INTO engylt_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","And the days of Terah are two hundred and five years, and Terah dieth in Charan. ");
INSERT INTO engylt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","And Jehovah saith unto Abram, 'Go for thyself, from thy land, and from thy kindred, and from the house of thy father, unto the land which I shew thee. ");
INSERT INTO engylt_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","And I make thee become a great nation, and bless thee, and make thy name great; and be thou a blessing. ");
INSERT INTO engylt_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","And I bless those blessing thee, and him who is disesteeming thee I curse, and blessed in thee have been all families of the ground.' ");
INSERT INTO engylt_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","And Abram goeth on, as Jehovah hath spoken unto him, and Lot goeth with him, and Abram is a son of five and seventy years in his going out from Charan. ");
INSERT INTO engylt_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","And Abram taketh Sarai his wife, and Lot his brother's son, and all their substance that they have gained, and the persons that they have obtained in Charan; and they go out to go towards the land of Canaan; and they come in to the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","And Abram passeth over into the land, unto the place Shechem, unto the oak of Moreh; and the Canaanite is then in the land. ");
INSERT INTO engylt_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","And Jehovah appeareth unto Abram, and saith, 'To thy seed I give this land;' and he buildeth there an altar to Jehovah, who hath appeared unto him. ");
INSERT INTO engylt_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","And he removeth from thence towards a mountain at the east of Beth-El, and stretcheth out the tent (Beth-El at the west, and Hai at the east), and he buildeth there an altar to Jehovah, and preacheth in the name of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","And Abram journeyeth, going on and journeying towards the south. ");
INSERT INTO engylt_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","And there is a famine in the land, and Abram goeth down towards Egypt to sojourn there, for the famine is grievous in the land; ");
INSERT INTO engylt_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","and it cometh to pass as he hath drawn near to enter Egypt, that he saith unto Sarai his wife, 'Lo, I pray thee, I have known that thou art a woman of beautiful appearance; ");
INSERT INTO engylt_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","and it hath come to pass that the Egyptians see thee, and they have said, 'This is his wife,' and they have slain me, and thee they keep alive: ");
INSERT INTO engylt_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","say, I pray thee, thou art my sister, so that it is well with me because of thee, and my soul hath lived for thy sake.' ");
INSERT INTO engylt_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And it cometh to pass, at the entering of Abram into Egypt, that the Egyptians see the woman that she is exceeding fair; ");
INSERT INTO engylt_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","and princes of Pharaoh see her, and praise her unto Pharaoh, and the woman is taken to Pharaoh's house; ");
INSERT INTO engylt_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","and to Abram he hath done good because of her, and he hath sheep and oxen, and he-asses, and men-servants, and handmaids, and she-asses, and camels. ");
INSERT INTO engylt_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","And Jehovah plagueth Pharaoh and his house — great plagues — for the matter of Sarai, Abram's wife. ");
INSERT INTO engylt_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","And Pharaoh calleth for Abram, and saith, 'What is this thou hast done to me? why hast thou not declared to me that she is thy wife? ");
INSERT INTO engylt_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why hast thou said, She is my sister, and I take her to myself for a wife? and now, lo, thy wife, take and go.' ");
INSERT INTO engylt_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","And Pharaoh chargeth men concerning him, and they send him away, and his wife, an all that he hath. ");
INSERT INTO engylt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","And Abram goeth up from Egypt (he and his wife, and all that he hath, and Lot with him) towards the south; ");
INSERT INTO engylt_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","and Abram is exceedingly wealthy in cattle, in silver, and in gold. ");
INSERT INTO engylt_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","And he goeth on his journeyings from the south, even unto Bethel, unto the place where his tent had been at the commencement, between Bethel and Hai — ");
INSERT INTO engylt_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","unto the place of the altar which he made there at the first, and there doth Abram preach in the name of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","And also to Lot, who is going with Abram, there hath been sheep and oxen and tents; ");
INSERT INTO engylt_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","and the land hath not suffered them to dwell together, for their substance hath been much, and they have not been able to dwell together; ");
INSERT INTO engylt_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","and there is a strife between those feeding Abram's cattle and those feeding Lot's cattle; and the Canaanite and the Perizzite are then dwelling in the land. ");
INSERT INTO engylt_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","And Abram saith unto Lot, 'Let there not, I pray thee, be strife between me and thee, and between my shepherds and thy shepherds, for we are men — brethren. ");
INSERT INTO engylt_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not all the land before thee? be parted, I pray thee, from me; if to the left, then I to the right; and if to the right, then I to the left.' ");
INSERT INTO engylt_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","And Lot lifteth up his eyes, and seeth the whole circuit of the Jordan that it is all a watered country (before Jehovah's destroying Sodom and Gomorrah, as Jehovah's garden, as the land of Egypt,) in thy coming toward Zoar, ");
INSERT INTO engylt_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","and Lot chooseth for himself the whole circuit of the Jordan; and Lot journeyeth from the east, and they are parted — a man from his companion; ");
INSERT INTO engylt_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram hath dwelt in the land of Canaan, and Lot hath dwelt in the cities of the circuit, and tenteth unto Sodom; ");
INSERT INTO engylt_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","and the men of Sodom are evil, and sinners before Jehovah exceedingly. ");
INSERT INTO engylt_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","And Jehovah said unto Abram, after Lot's being parted from him, 'Lift up, I pray thee, thine eyes, and look from the place where thou art, northward, and southward, and eastward, and westward; ");
INSERT INTO engylt_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","for the whole of the land which thou are seeing, to thee I give it, and to thy seed — to the age. ");
INSERT INTO engylt_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","And I have set thy seed as dust of the earth, so that, if one is able to number the dust of the earth, even thy seed is numbered; ");
INSERT INTO engylt_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","rise, go up and down through the land, to its length, and to its breadth, for to thee I give it.' ");
INSERT INTO engylt_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","And Abram tenteth, and cometh, and dwelleth among the oaks of Mamre, which are in Hebron, and buildeth there an altar to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","And it cometh to pass in the days of Amraphel king of Shinar, Arioch king of Ellasar, Chedorlaomer king of Elam, and Tidal king of Goyim, ");
INSERT INTO engylt_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","they have made war with Bera king of Sodom, and with Birsha king of Gomorrah, Shinab king of Admah, and Shemeber king of Zeboim, and the king of Bela, which is Zoar. ");
INSERT INTO engylt_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these have been joined together unto the valley of Siddim, which is the Salt Sea; ");
INSERT INTO engylt_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","twelve years they served Chedorlaomer, and the thirteenth year they rebelled. ");
INSERT INTO engylt_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","And in the fourteenth year came Chedorlaomer, and the kings who are with him, and they smite the Rephaim in Ashteroth Karnaim, and the Zuzim in Ham, and the Emim in Shaveh Kiriathaim, ");
INSERT INTO engylt_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horites in their mount Seir, unto El-Paran, which is by the wilderness; ");
INSERT INTO engylt_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","and they turn back and come in unto En-Mishpat, which is Kadesh, and smite the whole field of the Amalekite, and also the Amorite who is dwelling in Hazezon-Tamar. ");
INSERT INTO engylt_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","And the king of Sodom goeth out, and the king of Gomorrah, and the king of Admah, and the king of Zeboim, and the king of Bela, which is Zoar; and they set the battle in array with them in the valley of Siddim, ");
INSERT INTO engylt_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","with Chedorlaomer king of Elam, and Tidal king of Goyim, and Amraphel king of Shinar, and Arioch king of Ellasar; four kings with the five. ");
INSERT INTO engylt_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","And the valley of Siddim is full of bitumen-pits; and the kings of Sodom and Gomorrah flee, and fall there, and those left have fled to the mountain. ");
INSERT INTO engylt_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","And they take the whole substance of Sodom and Gomorrah, and the whole of their food, and go away; ");
INSERT INTO engylt_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","and they take Lot, Abram's brother's son (seeing he is dwelling in Sodom), and his substance, and go away. ");
INSERT INTO engylt_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","And one who is escaping cometh and declareth to Abram the Hebrew, and he is dwelling among the oaks of Mamre the Amorite, brother of Eshcol, and brother of Aner, and they are Abram's allies. ");
INSERT INTO engylt_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","And Abram heareth that his brother hath been taken captive, and he draweth out his trained domestics, three hundred and eighteen, and pursueth unto Dan. ");
INSERT INTO engylt_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","And he divideth himself against them by night, he and his servants, and smiteth them, and pursueth them unto Hobah, which is at the left of Damascus; ");
INSERT INTO engylt_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","and he bringeth back the whole of the substance, and also Lot his brother and his substance hath he brought back, and also the women and the people. ");
INSERT INTO engylt_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","And the king of Sodom goeth out to meet him (after his turning back from the smiting of Chedorlaomer, and of the kings who are with him), unto the valley of Shaveh, which is the king's valley. ");
INSERT INTO engylt_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","And Melchizedek king of Salem hath brought out bread and wine, and he is priest of God Most High; ");
INSERT INTO engylt_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","and he blesseth him, and saith, 'Blessed is Abram to God Most High, possessing heaven and earth; ");
INSERT INTO engylt_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","and blessed is God Most High, who hath delivered thine adversaries into thy hand;' and he giveth to him a tenth of all. ");
INSERT INTO engylt_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","And the king of Sodom saith unto Abram, 'Give to me the persons, and the substance take to thyself,' ");
INSERT INTO engylt_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","and Abram saith unto the king of Sodom, 'I have lifted up my hand unto Jehovah, God Most High, possessing heaven and earth — ");
INSERT INTO engylt_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","from a thread even unto a shoe-latchet I take not of anything which thou hast, that thou say not, I — I have made Abram rich; ");
INSERT INTO engylt_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","save only that which the young men have eaten, and the portion of the men who have gone with me — Aner, Eshcol, and Mamre — they take their portion.' ");
INSERT INTO engylt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things hath the word of Jehovah been unto Abram in a vision, saying, 'Fear not, Abram, I am a shield to thee, thy reward is exceeding great.' ");
INSERT INTO engylt_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","And Abram saith, 'Lord Jehovah, what dost Thou give to me, and I am going childless? and an acquired son in my house is Demmesek Eliezer.' ");
INSERT INTO engylt_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","And Abram saith, 'Lo, to me Thou hast not given seed, and lo, a domestic doth heir me.' ");
INSERT INTO engylt_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","And lo, the word of Jehovah is unto him, saying, 'This one doth not heir thee; but he who cometh out from thy bowels, he doth heir thee;' ");
INSERT INTO engylt_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","and He bringeth him out without, and saith, 'Look attentively, I pray thee, towards the heavens, and count the stars, if thou art able to count them;' and He saith to him, 'Thus is thy seed.' ");
INSERT INTO engylt_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","And he hath believed in Jehovah, and He reckoneth it to him — righteousness. ");
INSERT INTO engylt_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","And He saith unto him, 'I am Jehovah who brought thee out from Ur of the Chaldees, to give to thee this land to possess it;' ");
INSERT INTO engylt_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","and he saith, 'Lord Jehovah, whereby do I know that I possess it?' ");
INSERT INTO engylt_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","And He saith unto him, 'Take for Me a heifer of three years, and a she-goat of three years, and a ram of three years, and a turtle-dove, and a young bird;' ");
INSERT INTO engylt_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","and he taketh to him all these, and separateth them in the midst, and putteth each piece over against its fellow, but the bird he hath not divided; ");
INSERT INTO engylt_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","and the ravenous birds come down upon the carcases, and Abram causeth them to turn back. ");
INSERT INTO engylt_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","And the sun is about to go in, and deep sleep hath fallen upon Abram, and lo, a terror of great darkness is falling upon him; ");
INSERT INTO engylt_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","and He saith to Abram, 'knowing — know that thy seed is a sojourner in a land not theirs, and they have served them, and they have afflicted them four hundred years, ");
INSERT INTO engylt_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","and the nation also whom they serve I judge, and after this they go out with great substance; ");
INSERT INTO engylt_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","and thou — thou comest in unto thy fathers in peace; thou art buried in a good old age; ");
INSERT INTO engylt_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","and the fourth generation doth turn back hither, for the iniquity of the Amorite is not yet complete.' ");
INSERT INTO engylt_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","And it cometh to pass — the sun hath gone in, and thick darkness hath been — and lo, a furnace of smoke, and a lamp of fire, which hath passed over between those pieces. ");
INSERT INTO engylt_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In that day hath Jehovah made with Abram a covenant, saying, 'To thy seed I have given this land, from the river of Egypt unto the great river, the river Phrat, ");
INSERT INTO engylt_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","with the Kenite, and the Kenizzite, and the Kadmonite, ");
INSERT INTO engylt_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","and the Hittite, and the Perizzite, and the Rephaim, ");
INSERT INTO engylt_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","and the Amorite, and the Canaanite, and the Girgashite, and the Jebusite.' ");
INSERT INTO engylt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","And Sarai, Abram's wife, hath not borne to him, and she hath an handmaid, an Egyptian, and her name is Hagar; ");
INSERT INTO engylt_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","and Sarai saith unto Abram, 'Lo, I pray thee, Jehovah hath restrained me from bearing, go in, I pray thee, unto my handmaid; perhaps I am built up from her;' and Abram hearkeneth to the voice of Sarai. ");
INSERT INTO engylt_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","And Sarai, Abram's wife, taketh Hagar the Egyptian, her handmaid, at the end of the tenth year of Abram's dwelling in the land of Canaan, and giveth her to Abram her husband, to him for a wife, ");
INSERT INTO engylt_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","and he goeth in unto Hagar, and she conceiveth, and she seeth that she hath conceived, and her mistress is lightly esteemed in her eyes. ");
INSERT INTO engylt_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","And Sarai saith unto Abram, 'My violence is for thee; I — I have given mine handmaid into thy bosom, and she seeth that she hath conceived, and I am lightly esteemed in her eyes; Jehovah doth judge between me and thee.' ");
INSERT INTO engylt_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","And Abram saith unto Sarai, 'Lo, thine handmaid is in thine hand, do to her that which is good in thine eyes;' and Sarai afflicted her, and she fleeth from her presence. ");
INSERT INTO engylt_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","And a messenger of Jehovah findeth her by the fountain of water in the wilderness, by the fountain in the way to Shur, ");
INSERT INTO engylt_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","and he saith, 'Hagar, Sarai's handmaid, whence hast thou come, and whither dost thou go?' and she saith, 'From the presence of Sarai, my mistress, I am fleeing.' ");
INSERT INTO engylt_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","And the messenger of Jehovah saith to her, 'Turn back unto thy mistress, and humble thyself under her hands;' ");
INSERT INTO engylt_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","and the messenger of Jehovah saith to her, 'Multiplying I multiply thy seed, and it is not numbered from multitude;' ");
INSERT INTO engylt_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","and the messenger of Jehovah saith to her, 'Behold thou art conceiving, and bearing a son, and hast called his name Ishmael, for Jehovah hath hearkened unto thine affliction; ");
INSERT INTO engylt_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","and he is a wild-ass man, his hand against every one, and every one's hand against him — and before the face of all his brethren he dwelleth.' ");
INSERT INTO engylt_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","And she calleth the name of Jehovah who is speaking unto her, 'Thou art, O God, my beholder;' for she said, 'Even here have I looked behind my beholder?' ");
INSERT INTO engylt_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","therefore hath one called the well, 'The well of the Living One, my beholder;' lo, between Kadesh and Bered. ");
INSERT INTO engylt_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","And Hagar beareth to Abram a son; and Abram calleth the name of his son, whom Hagar hath borne, Ishmael; ");
INSERT INTO engylt_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","and Abram is a son of eighty and six years in Hagar's bearing Ishmael to Abram. ");
INSERT INTO engylt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","And Abram is a son of ninety and nine years, and Jehovah appeareth unto Abram, and saith unto him, 'I am God Almighty, walk habitually before Me, and be thou perfect; ");
INSERT INTO engylt_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","and I give My covenant between Me and thee, and multiply thee very exceedingly.' ");
INSERT INTO engylt_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","And Abram falleth upon his face, and God speaketh with him, saying, ");
INSERT INTO engylt_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","'I — lo, My covenant is with thee, and thou hast become father of a multitude of nations; ");
INSERT INTO engylt_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","and thy name is no more called Abram, but thy name hath been Abraham, for father of a multitude of nations have I made thee; ");
INSERT INTO engylt_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","and I have made thee exceeding fruitful, and made thee become nations, and kings go out from thee. ");
INSERT INTO engylt_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","'And I have established My covenant between Me and thee, and thy seed after thee, to their generations, for a covenant age-during, to become God to thee, and to thy seed after thee; ");
INSERT INTO engylt_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","and I have given to thee, and to thy seed after thee, the land of thy sojournings, the whole land of Canaan, for a possession age-during, and I have become their God.' ");
INSERT INTO engylt_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","And God saith unto Abraham, 'And thou dost keep My covenant, thou and thy seed after thee, to their generations; ");
INSERT INTO engylt_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","this is My covenant which ye keep between Me and you, and thy seed after thee: Every male of you is to be circumcised; ");
INSERT INTO engylt_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","and ye have circumcised the flesh of your foreskin, and it hath become a token of a covenant between Me and you. ");
INSERT INTO engylt_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","'And a son of eight days is circumcised by you; every male to your generations, born in the house, or bought with money from any son of a stranger, who is not of thy seed; ");
INSERT INTO engylt_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","he is certainly circumcised who is born in thine house, or bought with thy money; and My covenant hath become in your flesh a covenant age-during; ");
INSERT INTO engylt_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","and an uncircumcised one, a male, the flesh of whose foreskin is not circumcised, even that person hath been cut off from his people; My covenant he hath broken.' ");
INSERT INTO engylt_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","And God saith unto Abraham, 'Sarai thy wife — thou dost not call her name Sarai, for Sarah is her name; ");
INSERT INTO engylt_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","and I have blessed her, and have also given to thee a son from her; and I have blessed her, and she hath become nations — kings of peoples are from her.' ");
INSERT INTO engylt_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","And Abraham falleth upon his face, and laugheth, and saith in his heart, 'To the son of an hundred years is one born? or doth Sarah — daughter of ninety years — bear?' ");
INSERT INTO engylt_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","And Abraham saith unto God, 'O that Ishmael may live before Thee;' ");
INSERT INTO engylt_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","and God saith, 'Sarah thy wife is certainly bearing a son to thee, and thou hast called his name Isaac, and I have established My covenant with him, for a covenant age-during, to his seed after him. ");
INSERT INTO engylt_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As to Ishmael, I have heard thee; lo, I have blessed him, and made him fruitful, and multiplied him, very exceedingly; twelve princes doth he beget, and I have made him become a great nation; ");
INSERT INTO engylt_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","and My covenant I establish with Isaac, whom Sarah doth bear to thee at this appointed time in the next year;' ");
INSERT INTO engylt_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","and He finisheth speaking with him, and God goeth up from Abraham. ");
INSERT INTO engylt_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","And Abraham taketh Ishmael his son, and all those born in his house, and all those bought with his money — every male among the men of Abraham's house — and circumciseth the flesh of their foreskin, in this self-same day, as God hath spoken with him. ");
INSERT INTO engylt_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","And Abraham is a son of ninety and nine years in the flesh of his foreskin being circumcised; ");
INSERT INTO engylt_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","and Ishmael his son is a son of thirteen years in the flesh of his foreskin being circumcised; ");
INSERT INTO engylt_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","in this self-same day hath Abraham been circumcised, and Ishmael his son; ");
INSERT INTO engylt_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","and all the men of his house — born in the house, and bought with money from the son of a stranger — have been circumcised with him. ");
INSERT INTO engylt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","And Jehovah appeareth unto him among the oaks of Mamre, and he is sitting at the opening of the tent, about the heat of the day; ");
INSERT INTO engylt_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","and he lifteth up his eyes and looketh, and lo, three men standing by him, and he seeth, and runneth to meet them from the opening of the tent, and boweth himself towards the earth, ");
INSERT INTO engylt_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","And he saith, 'My Lord, if, I pray thee, I have found grace in thine eyes, do not, I pray thee, pass on from thy servant; ");
INSERT INTO engylt_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","let, I pray thee, a little water be accepted, and wash your feet, and recline under the tree; ");
INSERT INTO engylt_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","and I bring a piece of bread, and support ye your heart; afterwards pass on, for therefore have ye passed over unto your servant;' and they say, 'So mayest thou do as thou has spoken.' ");
INSERT INTO engylt_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","And Abraham hasteth towards the tent, unto Sarah, and saith, 'Hasten three measures of flour-meal, knead, and make cakes;' ");
INSERT INTO engylt_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","and Abraham ran unto the herd, and taketh a son of the herd, tender and good, and giveth unto the young man, and he hasteth to prepare it; ");
INSERT INTO engylt_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","and he taketh butter and milk, and the son of the herd which he hath prepared, and setteth before them; and he is standing by them under the tree, and they do eat. ");
INSERT INTO engylt_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","And they say unto him, 'Where is Sarah thy wife?' and he saith, 'Lo — in the tent;' ");
INSERT INTO engylt_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","and he saith, 'returning I return unto thee, about the time of life, and lo, to Sarah thy wife a son.' ");
INSERT INTO engylt_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","And Sarah is hearkening at the opening of the tent, which is behind him; ");
INSERT INTO engylt_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","and Abraham and Sarah are aged, entering into days — the way of women hath ceased to be to Sarah; ");
INSERT INTO engylt_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","and Sarah laugheth in her heart, saying, 'After I have waxed old I have had pleasure! — my lord also is old!' ");
INSERT INTO engylt_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","And Jehovah saith unto Abraham, 'Why is this? Sarah hath laughed, saying, Is it true really — I bear — and I am aged? Is any thing too wonderful for Jehovah? at the appointed time I return unto thee, about the time of life, and Sarah hath a son.' ");
INSERT INTO engylt_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","And Sarah denieth, saying, 'I did not laugh;' for she hath been afraid; and He saith, 'Nay, but thou didst laugh.' ");
INSERT INTO engylt_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","And the men rise from thence, and look on the face of Sodom, and Abraham is going with them to send them away; ");
INSERT INTO engylt_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","and Jehovah said, 'Am I concealing from Abraham that which I am doing, ");
INSERT INTO engylt_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","and Abraham certainly becometh a nation great and mighty, and blessed in him have been all nations of the earth? ");
INSERT INTO engylt_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","for I have known him, that he commandeth his children, and his house after him (and they have kept the way of Jehovah), to do righteousness and judgment, that Jehovah may bring on Abraham that which He hath spoken concerning him.' ");
INSERT INTO engylt_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","And Jehovah saith, 'The cry of Sodom and Gomorrah — because great; and their sin — because exceeding grievous: ");
INSERT INTO engylt_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I go down now, and see whether according to its cry which is coming unto Me they have done completely — and if not — I know;' ");
INSERT INTO engylt_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","and the men turn from thence, and go towards Sodom; and Abraham is yet standing before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","And Abraham draweth nigh and saith, 'Dost Thou also consume righteous with wicked? ");
INSERT INTO engylt_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","peradventure there are fifty righteous in the midst of the city; dost Thou also consume, and not bear with the place for the sake of the fifty — the righteous who are in its midst? ");
INSERT INTO engylt_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Far be it from Thee to do according to this thing, to put to death the righteous with the wicked; that it hath been — as the righteous so the wicked — far be it from Thee; doth the Judge of all the earth not do justice?' ");
INSERT INTO engylt_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","And Jehovah saith, 'If I find in Sodom fifty righteous in the midst of the city, then have I borne with all the place for their sake.' ");
INSERT INTO engylt_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","And Abraham answereth and saith, 'Lo, I pray thee, I have willed to speak unto the Lord, and I — dust and ashes; ");
INSERT INTO engylt_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","peradventure there are lacking five of the fifty righteous — dost Thou destroy for five the whole of the city?' and He saith, 'I destroy it not, if I find there forty and five.' ");
INSERT INTO engylt_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","And he addeth again to speak unto Him and saith, 'Peradventure there are found there forty?' and He saith, 'I do it not, because of the forty.' ");
INSERT INTO engylt_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","And he saith, 'Let it not be, I Pray thee, displeasing to the Lord, and I speak: peradventure there are found there thirty?' and He saith, 'I do it not, if I find there thirty.' ");
INSERT INTO engylt_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","And he saith, 'Lo, I pray thee, I have willed to speak unto the Lord: peradventure there are found there twenty?' and He saith, 'I do not destroy it, because of the twenty.' ");
INSERT INTO engylt_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","And he saith, 'Let it not be, I pray Thee, displeasing to the Lord, and I speak only this time: peradventure there are found there ten?' and He saith, 'I do not destroy it, because of the ten.' ");
INSERT INTO engylt_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","And Jehovah goeth on, when He hath finished speaking unto Abraham, and Abraham hath turned back to his place. ");
INSERT INTO engylt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","And two of the messengers come towards Sodom at even, and Lot is sitting at the gate of Sodom, and Lot seeth, and riseth to meet them, and boweth himself — face to the earth, ");
INSERT INTO engylt_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","and he saith, 'Lo, I pray you, my lords, turn aside, I pray you, unto the house of your servant, and lodge, and wash your feet — then ye have risen early and gone on your way;' and they say, 'Nay, but in the broad place we do lodge.' ");
INSERT INTO engylt_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","And he presseth on them greatly, and they turn aside unto him, and come in unto his house; and he maketh for them a banquet, and hath baked unleavened things; and they do eat. ");
INSERT INTO engylt_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Before they lie down, the men of the city — men of Sodom — have come round about against the house, from young even unto aged, all the people from the extremity; ");
INSERT INTO engylt_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","and they call unto Lot and say to him, 'Where are the men who have come in unto thee to-night? bring them out unto us, and we know them.' ");
INSERT INTO engylt_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","And Lot goeth out unto them, to the opening, and the door hath shut behind him, ");
INSERT INTO engylt_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","and saith, 'Do not, I pray you, my brethren, do evil; ");
INSERT INTO engylt_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","lo, I pray you, I have two daughters, who have not known any one; let me, I pray you, bring them out unto you, and do to them as is good in your eyes; only to these men do not anything, for therefore have they come in within the shadow of my roof.' ");
INSERT INTO engylt_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","And they say, 'Come nigh hither;' they say also, 'This one hath come in to sojourn, and he certainly judgeth! now, we do evil to thee more than to them;' and they press against the man, against Lot greatly, and come nigh to break the door. ");
INSERT INTO engylt_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","And the men put forth their hand, and bring in Lot unto them, into the house, and have shut the door; ");
INSERT INTO engylt_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","and the men who are at the opening of the house they have smitten with blindness, from small even unto great, and they weary themselves to find the opening. ");
INSERT INTO engylt_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","And the men say unto Lot, 'Whom hast thou here still? son-in-law, thy sons also, and thy daughters, and all whom thou hast in the city, bring out from this place; ");
INSERT INTO engylt_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","for we are destroying this place, for their cry hath been great before the face of Jehovah, and Jehovah doth send us to destroy it.' ");
INSERT INTO engylt_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","And Lot goeth out, and speaketh unto his sons-in-law, those taking his daughters, and saith, 'Rise, go out from this place, for Jehovah is destroying the city;' and he is as one mocking in the eyes of his sons-in-law. ");
INSERT INTO engylt_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","And when the dawn hath ascended, then the messengers press upon Lot, saying, 'Rise, take thy wife, and thy two daughters who are found present, lest thou be consumed in the iniquity of the city.' ");
INSERT INTO engylt_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","And he lingereth, and the men lay hold on his hand, and on the hand of his wife, and on the hand of his two daughters, through the mercy of Jehovah unto him, and they bring him out, and cause him to rest without the city. ");
INSERT INTO engylt_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","And it cometh to pass when he hath brought them out without, that he saith, 'Escape for thy life; look not expectingly behind thee, nor stand thou in all the circuit; to the mountain escape, lest thou be consumed.' ");
INSERT INTO engylt_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","And Lot saith unto them, 'Not so, I pray thee, my lord; ");
INSERT INTO engylt_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","lo, I pray thee, thy servant hath found grace in thine eyes, and thou dost make great thy kindness which thou hast done with me by saving my life, and I am unable to escape to the mountain, lest the evil cleave to me, and I have died; ");
INSERT INTO engylt_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","lo, I pray thee, this city is near to flee thither, and it is little; let me escape, I pray thee, thither, (is it not little?) and my soul doth live.' ");
INSERT INTO engylt_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","And he saith unto him, 'Lo, I have accepted thy face also for this thing, without overthrowing the city for which thou hast spoken; ");
INSERT INTO engylt_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","haste, escape thither, for I am not able to do anything till thine entering thither;' therefore hath he calleth the name of the city Zoar. ");
INSERT INTO engylt_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun hath gone out on the earth, and Lot hath entered into Zoar, ");
INSERT INTO engylt_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","and Jehovah hath rained upon Sodom and upon Gomorrah brimstone and fire from Jehovah, from the heavens; ");
INSERT INTO engylt_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","and He overthroweth these cities, and all the circuit, and all the inhabitants of the cities, and that which is shooting up from the ground. ");
INSERT INTO engylt_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","And his wife looketh expectingly from behind him, and she is — a pillar of salt! ");
INSERT INTO engylt_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","And Abraham riseth early in the morning, unto the place where he hath stood before the face of Jehovah; ");
INSERT INTO engylt_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","and he looketh on the face of Sodom and Gomorrah, and on all the face of the land of the circuit, and seeth, and lo, the smoke of the land went up as smoke of the furnace. ");
INSERT INTO engylt_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","And it cometh to pass, in God's destroying the cities of the circuit, that God remembereth Abraham, and sendeth Lot out of the midst of the overthrow in the overthrowing of the cities in which Lot dwelt. ");
INSERT INTO engylt_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","And Lot goeth up out of Zoar, and dwelleth in the mountain, and his two daughters with him, for he hath been afraid of dwelling in Zoar, and he dwelleth in a cave, he and his two daughters. ");
INSERT INTO engylt_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","And the first-born saith unto the younger, 'Our father is old, and a man there is not in the earth to come in unto us, as is the way of all the earth; ");
INSERT INTO engylt_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","come, we cause our father to drink wine, and lie with him, and preserve from our father — a seed.' ");
INSERT INTO engylt_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","And they cause their father to drink wine on that night; and the first-born goeth in, and lieth with her father, and he hath not known in her lying down, or in her rising up. ");
INSERT INTO engylt_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","And it cometh to pass, on the morrow, that the first-born saith unto the younger, 'Lo, I have lain yesterday-night with my father: we cause him to drink wine also to-night, and go thou in, lie with him, and we preserve from our father — a seed.' ");
INSERT INTO engylt_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","And they cause their father to drink wine on that night also, and the younger riseth and lieth with him, and he hath not known in her lying down, or in her rising up. ");
INSERT INTO engylt_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","And the two daughters of Lot conceive from their father, ");
INSERT INTO engylt_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","and the first-born beareth a son, and calleth his name Moab; he is father of Moab unto this day; ");
INSERT INTO engylt_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","as to the younger, she also hath born a son, and calleth his name Ben-Ammi: he is father of the Beni-Ammon unto this day. ");
INSERT INTO engylt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","And Abraham journeyeth from thence toward the land of the south, and dwelleth between Kadesh and Shur, and sojourneth in Gerar; ");
INSERT INTO engylt_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","and Abraham saith concerning Sarah his wife, 'She is my sister;' and Abimelech king of Gerar sendeth and taketh Sarah. ");
INSERT INTO engylt_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","And God cometh in unto Abimelech in a dream of the night, and saith to him, 'Lo, thou art a dead man, because of the woman whom thou hast taken — and she married to a husband.' ");
INSERT INTO engylt_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","And Abimelech hath not drawn near unto her, and he saith, 'Lord, also a righteous nation dost thou slay? ");
INSERT INTO engylt_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","hath not he himself said to me, She is my sister! and she, even she herself, said, He is my brother; in the integrity of my heart, and in the innocency of my hands, I have done this.' ");
INSERT INTO engylt_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","And God saith unto him in the dream, 'Yea, I — I have known that in the integrity of thy heart thou hast done this, and I withhold thee, even I, from sinning against Me, therefore I have not suffered thee to come against her; ");
INSERT INTO engylt_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","and now send back the man's wife, for he is inspired, and he doth pray for thee, and live thou; and if thou do not send back, know that dying thou dost die, thou, and all that thou hast.' ");
INSERT INTO engylt_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","And Abimelech riseth early in the morning, and calleth for all his servants, and speaketh all these words in their ears; and the men fear exceedingly; ");
INSERT INTO engylt_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","and Abimelech calleth for Abraham, and saith to him, 'What hast thou done to us? and what have I sinned against thee, that thou hast brought upon me, and upon my kingdom, a great sin? works which are not done thou hast done with me.' ");
INSERT INTO engylt_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelech also saith unto Abraham, 'What hast thou seen that thou hast done this thing?' ");
INSERT INTO engylt_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","And Abraham saith, 'Because I said, 'Surely the fear of God is not in this place, and they have slain me for the sake of my wife; ");
INSERT INTO engylt_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","and also, truly she is my sister, daughter of my father, only not daughter of my mother, and she becometh my wife; ");
INSERT INTO engylt_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","and it cometh to pass, when God hath caused me to wander from my father's house, that I say to her, This is thy kindness which thou dost with me: at every place whither we come, say of me, He is my brother.' ");
INSERT INTO engylt_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","And Abimelech taketh sheep and oxen, and servants and handmaids, and giveth to Abraham, and sendeth back to him Sarah his wife; ");
INSERT INTO engylt_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","and Abimelech saith, 'Lo, my land is before thee, where it is good in thine eyes, dwell;' ");
INSERT INTO engylt_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","and to Sarah he hath said, 'Lo, I have given a thousand silverlings to thy brother; lo, it is to thee a covering of eyes, to all who are with thee;' and by all this she is reasoned with. ");
INSERT INTO engylt_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","And Abraham prayeth unto God, and God healeth Abimelech and his wife, and his handmaids, and they bear: ");
INSERT INTO engylt_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","for Jehovah restraining had restrained every womb of the house of Abimelech, because of Sarah, Abraham's wife. ");
INSERT INTO engylt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","And Jehovah hath looked after Sarah as He hath said, and Jehovah doth to Sarah as He hath spoken; ");
INSERT INTO engylt_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","and Sarah conceiveth, and beareth a son to Abraham, to his old age, at the appointed time that God hath spoken of with him; ");
INSERT INTO engylt_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","and Abraham calleth the name of his son who is born to him, whom Sarah hath born to him — Isaac; ");
INSERT INTO engylt_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","and Abraham circumciseth Isaac his son, being a son of eight days, as God hath commanded him. ");
INSERT INTO engylt_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","And Abraham is a son of a hundred years in Isaac his son being born to him, ");
INSERT INTO engylt_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","and Sarah saith, 'God hath made laughter for me; every one who is hearing laugheth for me.' ");
INSERT INTO engylt_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She saith also, 'Who hath said to Abraham, Sarah hath suckled sons, that I have born a son for his old age?' ");
INSERT INTO engylt_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","And the lad groweth, and is weaned, and Abraham maketh a great banquet in the day of Isaac's being weaned; ");
INSERT INTO engylt_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","and Sarah seeth the son of Hagar the Egyptian, whom she hath borne to Abraham, mocking, ");
INSERT INTO engylt_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","and she saith to Abraham, 'Cast out this handmaid and her son; for the son of this handmaid hath no possession with my son — with Isaac.' ");
INSERT INTO engylt_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","And the thing is very wrong in the eyes of Abraham, for his son's sake; ");
INSERT INTO engylt_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","and God saith unto Abraham, 'Let it not be wrong in thine eyes because of the youth, and because of thy handmaid: all that Sarah saith unto thee — hearken to her voice, for in Isaac is a seed called to thee. ");
INSERT INTO engylt_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","As to the son of the handmaid also, for a nation I set him, because he is thy seed.' ");
INSERT INTO engylt_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","And Abraham riseth early in the morning, and taketh bread, and a bottle of water, and giveth unto Hagar (placing it on her shoulder), also the lad, and sendeth her out; and she goeth on, and goeth astray in the wilderness of Beer-Sheba; ");
INSERT INTO engylt_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","and the water is consumed from the bottle, and she placeth the lad under one of the shrubs. ");
INSERT INTO engylt_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","And she goeth and sitteth by herself over-against, afar off, about a bow-shot, for she said, 'Let me not look on the death of the lad;' and she sitteth over-against, and lifteth up her voice, and weepeth. ");
INSERT INTO engylt_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","And God heareth the voice of the youth; and the messenger of God calleth unto Hagar from the heavens, and saith to her, 'What to thee, Hagar? fear not; for God hath hearkened unto the voice of the youth where he is; ");
INSERT INTO engylt_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","rise, lift up the youth, and lay hold on him with thy hand, for for a great nation I set him.' ");
INSERT INTO engylt_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","And God openeth her eyes, and she seeth a well of water, and she goeth and filleth the bottle with water, and causeth the youth to drink; ");
INSERT INTO engylt_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","and God is with the youth, and he groweth, and dwelleth in the wilderness, and is an archer; ");
INSERT INTO engylt_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","and he dwelleth in the wilderness of Paran, and his mother taketh for him a wife from the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","And it cometh to pass at that time that Abimelech speaketh — Phichol also, head of his host — unto Abraham, saying, 'God is with thee in all that thou art doing; ");
INSERT INTO engylt_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","and now, swear to me by God here: thou dost not lie to me, or to my continuator, or to my successor; according to the kindness which I have done with thee thou dost with me, and with the land in which thou hast sojourned.' ");
INSERT INTO engylt_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","And Abraham saith, 'I — I do swear.' ");
INSERT INTO engylt_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","And Abraham reasoned with Abimelech concerning the matter of a well of water which Abimelech's servants have taken violently away, ");
INSERT INTO engylt_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","and Abimelech saith, 'I have not known who hath done this thing, and even thou didst not declare to me, and I also, I have not heard save to-day.' ");
INSERT INTO engylt_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","And Abraham taketh sheep and oxen, and giveth to Abimelech, and they make, both of them, a covenant; ");
INSERT INTO engylt_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","and Abraham setteth seven Lambs of the flock by themselves. ");
INSERT INTO engylt_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","And Abimelech saith unto Abraham, 'What are they — these seven lambs which thou hast set by themselves?' ");
INSERT INTO engylt_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","And he saith, 'For — the seven lambs thou dost accept from my hand, so that it becometh a witness for me that I have digged this well;' ");
INSERT INTO engylt_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","therefore hath he called that place 'Beer-Sheba,' for there have both of them sworn. ");
INSERT INTO engylt_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","And they make a covenant in Beer-Sheba, and Abimelech riseth — Phichol also, head of his host — and they turn back unto the land of the Philistines; ");
INSERT INTO engylt_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","and Abraham planteth a tamarisk in Beer-Sheba, and preacheth there in the name of Jehovah, God age-during; ");
INSERT INTO engylt_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","and Abraham sojourneth in the land of the Philistines many days. ");
INSERT INTO engylt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","And it cometh to pass after these things that God hath tried Abraham, and saith unto him, 'Abraham;' and he saith, 'Here am I.' ");
INSERT INTO engylt_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","And He saith, 'Take, I pray thee, thy son, thine only one, whom thou hast loved, even Isaac, and go for thyself unto the land of Moriah, and cause him to ascend there for a burnt-offering on one of the mountains of which I speak unto thee.' ");
INSERT INTO engylt_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","And Abraham riseth early in the morning, and saddleth his ass, and taketh two of his young men with him, and Isaac his son, and he cleaveth the wood of the burnt-offering, and riseth and goeth unto the place of which God hath spoken to him. ");
INSERT INTO engylt_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","On the third day — Abraham lifteth up his eyes, and seeth the place from afar; ");
INSERT INTO engylt_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","and Abraham saith unto his young men, 'Remain by yourselves here with the ass, and I and the youth go yonder and worship, and turn back unto you.' ");
INSERT INTO engylt_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","And Abraham taketh the wood of the burnt-offering, and placeth on Isaac his son, and he taketh in his hand the fire, and the knife; and they go on both of them together. ");
INSERT INTO engylt_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","And Isaac speaketh unto Abraham his father, and saith, 'My father,' and he saith, 'Here am I, my son.' And he saith, 'Lo, the fire and the wood, and where the lamb for a burnt-offering?' ");
INSERT INTO engylt_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","and Abraham saith, 'God doth provide for Himself the lamb for a burnt-offering, my son;' and they go on both of them together. ");
INSERT INTO engylt_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","And they come in unto the place of which God hath spoken to him, and there Abraham buildeth the altar, and arrangeth the wood, and bindeth Isaac his son, and placeth him upon the altar above the wood; ");
INSERT INTO engylt_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","and Abraham putteth forth his hand, and taketh the knife — to slaughter his son. ");
INSERT INTO engylt_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","And the messenger of Jehovah calleth unto him from the heavens, and saith, 'Abraham, Abraham;' and he saith, 'Here am I;' ");
INSERT INTO engylt_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","and He saith, 'Put not forth thine hand unto the youth, nor do anything to him, for now I have known that thou art fearing God, and hast not withheld thy son, thine only one, from Me.' ");
INSERT INTO engylt_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","And Abraham lifteth up his eyes, and looketh, and lo, a ram behind, seized in a thicket by its horns; and Abraham goeth, and taketh the ram, and causeth it to ascend for a burnt-offering instead of his son; ");
INSERT INTO engylt_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","and Abraham calleth the name of that place 'Jehovah-Jireh,' because it is said this day in the mount, 'Jehovah doth provide.' ");
INSERT INTO engylt_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","And the messenger of Jehovah calleth unto Abraham a second time from the heavens, ");
INSERT INTO engylt_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","and saith, 'By Myself I have sworn — the affirmation of Jehovah — that because thou hast done this thing, and hast not withheld thy son, thine only one — ");
INSERT INTO engylt_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","that blessing I bless thee, and multiplying I multiply thy seed as stars of the heavens, and as sand which is on the sea-shore; and thy seed doth possess the gate of his enemies; ");
INSERT INTO engylt_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","and blessed themselves in thy seed have all nations of the earth, because that thou hast hearkened to My voice.' ");
INSERT INTO engylt_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","And Abraham turneth back unto his young men, and they rise and go together unto Beer-Sheba; and Abraham dwelleth in Beer-Sheba. ");
INSERT INTO engylt_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","And it cometh to pass after these things that it is declared to Abraham, saying, 'Lo, Milcah hath borne, even she, sons to Nahor thy brother: ");
INSERT INTO engylt_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Huz his first-born, and Buz his brother; and Kemuel father of Aram, ");
INSERT INTO engylt_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","and Chesed, and Hazo, and Pildash, and Jidlaph, and Bethuel; ");
INSERT INTO engylt_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","and Bethuel hath begotten Rebekah;' these eight hath Milcah borne to Nahor, Abraham's brother; ");
INSERT INTO engylt_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","and his concubine, whose name is Reumah, she also hath borne Tebah, and Gaham, and Tahash, and Maachah. ");
INSERT INTO engylt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","And the life of Sarah is a hundred and twenty and seven years — years of the life of Sarah; ");
INSERT INTO engylt_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","and Sarah dieth in Kirjath-Arba, which is Hebron, in the land of Caanan, and Abraham goeth in to mourn for Sarah, and to bewail her. ");
INSERT INTO engylt_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","And Abraham riseth up from the presence of his dead, and speaketh unto the sons of Heth, saying, ");
INSERT INTO engylt_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","'A sojourner and a settler I am with you; give to me a possession of a burying-place with you, and I bury my dead from before me.' ");
INSERT INTO engylt_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","And the sons of Heth answer Abraham, saying to him, ");
INSERT INTO engylt_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","'Hear us, my lord; a prince of God art thou in our midst; in the choice of our burying-places bury thy dead: none of us his burying-place doth withhold from thee, from burying thy dead.' ");
INSERT INTO engylt_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","And Abraham riseth and boweth himself to the people of the land, to the sons of Heth, ");
INSERT INTO engylt_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","and he speaketh with them, saying, 'If it is your desire to bury my dead from before me, hear me, and meet for me with Ephron, son of Zoar; ");
INSERT INTO engylt_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","and he giveth to me the cave of Machpelah, which he hath, which is in the extremity of his field; for full money doth he give it to me, in your midst, for a possession of a burying-place.' ");
INSERT INTO engylt_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","And Ephron is sitting in the midst of the sons of Heth, and Ephron the Hittite answereth Abraham in the ears of the sons of Heth, of all those entering the gate of his city, saying, ");
INSERT INTO engylt_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","'Nay, my lord, hear me: the field I have given to thee, and the cave that is in it, to thee I have given it; before the eyes of the sons of my people I have given it to thee — bury thy dead.' ");
INSERT INTO engylt_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","And Abraham boweth himself before the people of the land, ");
INSERT INTO engylt_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","and speaketh unto Ephron in the ears of the people of the land, saying, 'Only — if thou wouldest hear me — I have given the money of the field — accept from me, and I bury my dead there.' ");
INSERT INTO engylt_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","And Ephron answereth Abraham, saying to him, ");
INSERT INTO engylt_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","'My lord, hear me: the land — four hundred shekels of silver; between me and thee, what is it? — thy dead bury.' ");
INSERT INTO engylt_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","And Abraham hearkeneth unto Ephron, and Abraham weigheth to Ephron the silver which he hath spoken of in the ears of the sons of Heth, four hundred silver shekels, passing with the merchant. ");
INSERT INTO engylt_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","And established are the field of Ephron, which is in Machpelah, which is before Mamre, the field and the cave which is in it, and all the trees which are in the field, which are in all its border round about, ");
INSERT INTO engylt_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","to Abraham by purchase, before the eyes of the sons of Heth, among all entering the gate of his city. ");
INSERT INTO engylt_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","And after this hath Abraham buried Sarah his wife at the cave of the field of Machpelah before Mamre (which is Hebron), in the land of Canaan; ");
INSERT INTO engylt_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","and established are the field, and the cave which is in it, to Abraham for a possession of a burying-place, from the sons of Heth. ");
INSERT INTO engylt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","And Abraham is old, he hath entered into days, and Jehovah hath blessed Abraham in all things; ");
INSERT INTO engylt_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","and Abraham saith unto his servant, the eldest of his house, who is ruling over all that he hath, 'Put, I pray thee, thy hand under my thigh, ");
INSERT INTO engylt_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","and I cause thee to swear by Jehovah, God of the heavens, and God of the earth, that thou dost not take a wife for my son from the daughters of the Canaanite, in the midst of whom I am dwelling; ");
INSERT INTO engylt_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","but unto my land and unto my kindred dost thou go, and hast taken a wife for my son, for Isaac.' ");
INSERT INTO engylt_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","And the servant saith unto him, 'It may be the woman is not willing to come after me unto this land; do I at all cause thy son to turn back unto the land from whence thou camest out?' ");
INSERT INTO engylt_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","And Abraham saith unto him, 'Take heed to thyself, lest thou cause my son to turn back thither; ");
INSERT INTO engylt_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehovah, God of the heavens, who hath taken me from the house of my father, and from the land of my birth, and who hath spoken to me, and who hath sworn to me, saying, To thy seed I give this land, He doth send His messenger before thee, and thou hast taken a wife for my son from thence; ");
INSERT INTO engylt_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","and if the woman be not willing to come after thee, then thou hast been acquitted from this mine oath: only my son thou dost not cause to turn back thither.' ");
INSERT INTO engylt_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","And the servant putteth his hand under the thigh of Abraham his lord, and sweareth to him concerning this matter. ");
INSERT INTO engylt_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","And the servant taketh ten camels of the camels of his lord and goeth, also of all the goods of his lord in his hand, and he riseth, and goeth unto Aram-Naharaim, unto the city of Nahor; ");
INSERT INTO engylt_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","and he causeth the camels to kneel at the outside of the city, at the well of water, at even-time, at the time of the coming out of the women who draw water. ");
INSERT INTO engylt_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","And he saith, 'Jehovah, God of my lord Abraham, cause to meet, I pray Thee, before me this day — (and do kindness with my lord Abraham; ");
INSERT INTO engylt_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","lo, I am standing by the fountain of water, and daughters of the men of the city are coming out to draw water; ");
INSERT INTO engylt_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","and it hath been, the young person unto whom I say, Incline, I pray thee, thy pitcher, and I drink, and she hath said, Drink, and I water also thy camels) — her Thou hast decided for Thy servant, for Isaac; and by it I know that Thou hast done kindness with my lord.' ");
INSERT INTO engylt_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","And it cometh to pass, before he hath finished speaking, that lo, Rebekah (who was born to Bethuel, son of Milcah, wife of Nahor, brother of Abraham) is coming out, and her pitcher on her shoulder, ");
INSERT INTO engylt_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","and the young person is of very good appearance, a virgin, and a man hath not known her; and she goeth down to the fountain, and filleth her pitcher, and cometh up. ");
INSERT INTO engylt_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","And the servant runneth to meet her, and saith, 'Let me swallow, I pray thee, a little water from thy pitcher;' ");
INSERT INTO engylt_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","and she saith, 'Drink, my lord;' and she hasteth, and letteth down her pitcher upon her hand, and giveth him drink. ");
INSERT INTO engylt_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","And she finisheth giving him drink, and saith, 'Also for thy camels I draw till they have finished drinking;' ");
INSERT INTO engylt_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","and she hasteth, and emptieth her pitcher into the drinking-trough, and runneth again unto the well to draw, and draweth for all his camels. ");
INSERT INTO engylt_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","And the man, wondering at her, remaineth silent, to know whether Jehovah hath made his way prosperous or not. ");
INSERT INTO engylt_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","And it cometh to pass when the camels have finished drinking, that the man taketh a golden ring (whose weight is a bekah), and two bracelets for her hands (whose weight is ten bekahs of gold), ");
INSERT INTO engylt_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","and saith, 'Whose daughter art thou? declare to me, I pray thee, is the house of thy father a place for us to lodge in?' ");
INSERT INTO engylt_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","And she saith unto him, 'I am daughter of Bethuel, son of Milcah, whom she hath borne to Nahor.' ");
INSERT INTO engylt_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","She saith also unto him, 'Both straw and provender are abundant with us, also a place to lodge in.' ");
INSERT INTO engylt_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","And the man boweth, and doth obeisance to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","and saith, 'Blessed is Jehovah, God of my lord Abraham, who hath not left off His kindness and His truth with my lord; — I being in the way, Jehovah hath led me to the house of my lord's brethren.' ");
INSERT INTO engylt_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","And the young person runneth, and declareth to the house of her mother according to these words. ");
INSERT INTO engylt_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","And Rebekah hath a brother, and his name is Laban, and Laban runneth unto the man who is without, unto the fountain; ");
INSERT INTO engylt_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","yea, it cometh to pass, when he seeth the ring, and the bracelets on the hands of his sister, and when he heareth the words of Rebekah his sister, saying, 'Thus hath the man spoken unto me,' that he cometh in unto the man, and lo, he is standing by the camels by the fountain. ");
INSERT INTO engylt_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","And he saith, 'Come in, O blessed one of Jehovah, why standest thou without, and I — I have prepared the house and place for the camels!' ");
INSERT INTO engylt_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","And he bringeth in the man into the house, and looseth the camels, and giveth straw and provender for the camels, and water to wash his feet, and the feet of the men who are with him: ");
INSERT INTO engylt_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","and setteth before him to eat; but he saith, 'I do not eat till I have spoken my word;' and he saith, 'Speak.' ");
INSERT INTO engylt_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","And he saith, 'I am Abraham's servant; ");
INSERT INTO engylt_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","and Jehovah hath blessed my lord exceedingly, and he is great; and He giveth to him flock, and herd, and silver, and gold, and men-servants, and maid-servants, and camels, and asses; ");
INSERT INTO engylt_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","and Sarah, my lord's wife, beareth a son to my lord, after she hath been aged, and he giveth to him all that he hath. ");
INSERT INTO engylt_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","'And my lord causeth me to swear, saying, Thou dost not take a wife to my son from the daughters of the Canaanite, in whose land I am dwelling. ");
INSERT INTO engylt_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","If not — unto the house of my father thou dost go, and unto my family, and thou hast taken a wife for my son. ");
INSERT INTO engylt_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","'And I say unto my lord, It may be the woman doth not come after me; ");
INSERT INTO engylt_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","and he saith unto me, Jehovah, before whom I have walked habitually, doth send His messenger with thee, and hath prospered thy way, and thou hast taken a wife for my son from my family, and from the house of my father; ");
INSERT INTO engylt_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","then art thou acquitted from my oath, when thou comest unto my family, and if they give not one to thee; then thou hast been acquitted from my oath. ");
INSERT INTO engylt_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","'And I come to-day unto the fountain, and I say, Jehovah, God of my lord Abraham, if Thou art, I pray Thee, making prosperous my way in which I am going — ");
INSERT INTO engylt_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","(lo, I am standing by the fountain of water), then the virgin who is coming out to draw, and I have said unto her, Let me drink, I pray thee, a little water from thy pitcher, ");
INSERT INTO engylt_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","and she hath said unto me, Both drink thou, and also for thy camels I draw — she is the woman whom Jehovah hath decided for my lord's son. ");
INSERT INTO engylt_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","'Before I finish speaking unto my heart, then lo, Rebekah is coming out, and her pitcher on her shoulder, and she goeth down to the fountain, and draweth; and I say unto her, Let me drink, I pray thee, ");
INSERT INTO engylt_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","and she hasteth and letteth down her pitcher from off her and saith, Drink, and thy camels also I water; and I drink, and the camels also she hath watered. ");
INSERT INTO engylt_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","'And I ask her, and say, Whose daughter art thou? and she saith, Daughter of Bethuel, son of Nahor, whom Milcah hath borne to him, and I put the ring on her nose, and the bracelets on her hands, ");
INSERT INTO engylt_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","and I bow, and do obeisance before Jehovah, and I bless Jehovah, God of my lord Abraham, who hath led me in the true way to receive the daughter of my lord's brother for his son. ");
INSERT INTO engylt_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","'And now, if ye are dealing kindly and truly with my lord, declare to me; and if not, declare to me; and I turn unto the right or unto the left.' ");
INSERT INTO engylt_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","And Laban answereth — Bethuel also — and they say, 'The thing hath gone out from Jehovah; we are not able to speak unto thee bad or good; ");
INSERT INTO engylt_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","lo, Rebekah is before thee, take and go, and she is a wife to thy lord's son, as Jehovah hath spoken.' ");
INSERT INTO engylt_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","And it cometh to pass, when the servant of Abraham hath heard their words, that he boweth himself towards the earth before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","and the servant taketh out vessels of silver, and vessels of gold, and garments, and giveth to Rebekah; precious things also he hath given to her brother and to her mother. ");
INSERT INTO engylt_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","And they eat and drink, he and the men who are with him, and lodge all night; and they rise in the morning, and he saith, 'Send me to my lord;' ");
INSERT INTO engylt_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","and her brother saith — her mother also — 'Let the young person abide with us a week or ten days, afterwards doth she go.' ");
INSERT INTO engylt_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","And he saith unto them, 'Do not delay me, seeing Jehovah hath prospered my way; send me away, and I go to my lord;' ");
INSERT INTO engylt_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","and they say, 'Let us call for the young person, and ask at her mouth;' ");
INSERT INTO engylt_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","and they call for Rebekah, and say unto her, 'Dost thou go with this man?' and she saith, 'I go.' ");
INSERT INTO engylt_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","And they send away Rebekah their sister, and her nurse, and Abraham's servant, and his men; ");
INSERT INTO engylt_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","and they bless Rebekah, and say to her, 'Thou art our sister; become thou thousands of myriads, and thy seed doth possess the gate of those hating it.' ");
INSERT INTO engylt_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","And Rebekah and her young women arise, and ride on the camels, and go after the man; and the servant taketh Rebekah and goeth. ");
INSERT INTO engylt_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","And Isaac hath come in from the entrance of the Well of the Living One, my Beholder; and he is dwelling in the land of the south, ");
INSERT INTO engylt_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","and Isaac goeth out to meditate in the field, at the turning of the evening, and he lifteth up his eyes, and looketh, and lo, camels are coming. ");
INSERT INTO engylt_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","And Rebekah lifteth up her eyes, and seeth Isaac, and alighteth from off the camel; ");
INSERT INTO engylt_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","and she saith unto the servant, 'Who is this man who is walking in the field to meet us?' and the servant saith, 'It is my lord;' and she taketh the veil, and covereth herself. ");
INSERT INTO engylt_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","And the servant recounteth to Isaac all the things that he hath done, ");
INSERT INTO engylt_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","and Isaac bringeth her in unto the tent of Sarah his mother, and he taketh Rebekah, and she becometh his wife, and he loveth her, and Isaac is comforted after the death of his mother. ");
INSERT INTO engylt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","And Abraham addeth and taketh a wife, and her name is Keturah; ");
INSERT INTO engylt_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","and she beareth to him Zimran, and Jokshan, and Medan, and Midian, and Ishbak, and Shuah. ");
INSERT INTO engylt_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","And Jokshan hath begotten Sheba and Dedan; and the sons of Dedan were Asshurim, and Letushim, and Leummim; ");
INSERT INTO engylt_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","and the sons of Midian are Ephah, and Epher, and Hanoch, and Abidah, and Eldaah: all these are sons of Keturah. ");
INSERT INTO engylt_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","And Abraham giveth all that he hath to Isaac; ");
INSERT INTO engylt_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","and to the sons of the concubines whom Abraham hath, Abraham hath given gifts, and sendeth them away from Isaac his son (in his being yet alive) eastward, unto the east country. ");
INSERT INTO engylt_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","And these are the days of the years of the life of Abraham, which he lived, a hundred and seventy and five years; ");
INSERT INTO engylt_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","and Abraham expireth, and dieth in a good old age, aged and satisfied, and is gathered unto his people. ");
INSERT INTO engylt_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","And Isaac and Ishmael his sons bury him at the cave of Machpelah, at the field of Ephron, son of Zoar the Hittite, which is before Mamre — ");
INSERT INTO engylt_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","the field which Abraham bought from the sons of Heth — there hath Abraham been buried, and Sarah his wife. ");
INSERT INTO engylt_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","And it cometh to pass after the death of Abraham, that God blesseth Isaac his son; and Isaac dwelleth by the Well of the Living One, my Beholder. ");
INSERT INTO engylt_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","And these are births of Ishmael, Abraham's son, whom Hagar the Egyptian, Sarah's handmaid, hath borne to Abraham; ");
INSERT INTO engylt_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","and these are the names of the sons of Ishmael, by their names, according to their births: first-born of Ishmael, Nebajoth; and Kedar, and Adbeel, and Mibsam, ");
INSERT INTO engylt_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","and Mishma, and Dumah, and Massa, ");
INSERT INTO engylt_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, and Tema, Jetur, Naphish, and Kedemah: ");
INSERT INTO engylt_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","these are sons of Ishmael, and these their names, by their villages, and by their towers; twelve princes according to their peoples. ");
INSERT INTO engylt_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","And these are the years of the life of Ishmael, a hundred and thirty and seven years; and he expireth, and dieth, and is gathered unto his people; ");
INSERT INTO engylt_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","and they tabernacle from Havilah unto Shur, which is before Egypt, in thy going towards Asshur; in the presence of all his brethren hath he fallen. ");
INSERT INTO engylt_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","And these are births of Isaac, Abraham's son: Abraham hath begotten Isaac; ");
INSERT INTO engylt_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","and Isaac is a son of forty years in his taking Rebekah, daughter of Bethuel the Aramaean, from Padan-Aram, sister of Laban the Aramaean, to him for a wife. ");
INSERT INTO engylt_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","And Isaac maketh entreaty to Jehovah before his wife, for she is barren: and Jehovah is entreated of him, and Rebekah his wife conceiveth, ");
INSERT INTO engylt_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","and the children struggle together within her, and she saith, 'If it is right — why am I thus?' and she goeth to seek Jehovah. ");
INSERT INTO engylt_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","And Jehovah saith to her, 'Two nations are in thy womb, and two peoples from thy bowels are parted; and the one people than the other people is stronger; and the elder doth serve the younger.' ");
INSERT INTO engylt_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","And her days to bear are fulfilled, and lo, twins are in her womb; ");
INSERT INTO engylt_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","and the first cometh out all red as a hairy robe, and they call his name Esau; ");
INSERT INTO engylt_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","and afterwards hath his brother come out, and his hand is taking hold on Esau's heel, and one calleth his name Jacob; and Isaac is a son of sixty years in her bearing them. ");
INSERT INTO engylt_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","And the youths grew, and Esau is a man acquainted with hunting, a man of the field; and Jacob is a plain man, inhabiting tents; ");
INSERT INTO engylt_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","and Isaac loveth Esau, for his hunting is in his mouth; and Rebekah is loving Jacob. ");
INSERT INTO engylt_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","And Jacob boileth pottage, and Esau cometh in from the field, and he is weary; ");
INSERT INTO engylt_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","and Esau saith unto Jacob, 'Let me eat, I pray thee, some of this red red thing, for I am weary;' therefore hath one called his name Edom Red; ");
INSERT INTO engylt_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","and Jacob saith, 'Sell to-day thy birthright to me.' ");
INSERT INTO engylt_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","And Esau saith, 'Lo, I am going to die, and what is this to me — birthright?' ");
INSERT INTO engylt_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","and Jacob saith, 'Swear to me to-day:' and he sweareth to him, and selleth his birthright to Jacob; ");
INSERT INTO engylt_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","and Jacob hath given to Esau bread and pottage of lentiles, and he eateth, and drinketh, and riseth, and goeth; and Esau despiseth the birthright. ");
INSERT INTO engylt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","And there is a famine in the land, besides the first famine which was in the days of Abraham, and Isaac goeth unto Abimelech king of the Philistines, to Gerar. ");
INSERT INTO engylt_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","And Jehovah appeareth unto him, and saith, 'Go not down towards Egypt, tabernacle in the land concerning which I speak unto thee, ");
INSERT INTO engylt_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","sojourn in this land, and I am with thee, and bless thee, for to thee and to thy seed I give all these lands, and I have established the oath which I have sworn to Abraham thy father; ");
INSERT INTO engylt_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","and I have multiplied thy seed as stars of the heavens, and I have given to thy seed all these lands; and blessed themselves in thy seed have all nations of the earth; ");
INSERT INTO engylt_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","because that Abraham hath hearkened to My voice, and keepeth My charge, My commands, My statutes, and My laws.' ");
INSERT INTO engylt_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","And Isaac dwelleth in Gerar; ");
INSERT INTO engylt_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","and men of the place ask him of his wife, and he saith, 'She is my sister:' for he hath been afraid to say, 'My wife — lest the men of the place kill me for Rebekah, for she is of good appearance.' ");
INSERT INTO engylt_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","And it cometh to pass, when the days have been prolonged to him there, that Abimelech king of the Philistines looketh through the window, and seeth, and lo, Isaac is playing with Rebekah his wife. ");
INSERT INTO engylt_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","And Abimelech calleth for Isaac, and saith, 'Lo, she is surely thy wife; and how hast thou said, She is my sister?' and Isaac saith unto him, 'Because I said, Lest I die for her.' ");
INSERT INTO engylt_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","And Abimelech saith, 'What is this thou hast done to us? as a little thing one of the people had lain with thy wife, and thou hadst brought upon us guilt;' ");
INSERT INTO engylt_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","and Abimelech commandeth all the people, saying, 'He who cometh against this man or against his wife, dying doth die.' ");
INSERT INTO engylt_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","And Isaac soweth in that land, and findeth in that year a hundredfold, and Jehovah blesseth him; ");
INSERT INTO engylt_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","and the man is great, and goeth on, going on and becoming great, till that he hath been very great, ");
INSERT INTO engylt_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","and he hath possession of a flock, and possession of a herd, and an abundant service; and the Philistines envy him, ");
INSERT INTO engylt_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","and all the wells which his father's servants digged in the days of Abraham his father, the Philistines have stopped them, and fill them with dust. ");
INSERT INTO engylt_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","And Abimelech saith unto Isaac, 'Go from us; for thou hast become much mightier than we;' ");
INSERT INTO engylt_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","and Isaac goeth from thence, and encampeth in the valley of Gerar, and dwelleth there; ");
INSERT INTO engylt_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","and Isaac turneth back, and diggeth the wells of water which they digged in the days of Abraham his father, which the Philistines do stop after the death of Abraham, and he calleth to them names according to the names which his father called them. ");
INSERT INTO engylt_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","And Isaac's servants dig in the valley, and find there a well of living water, ");
INSERT INTO engylt_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","and shepherds of Gerar strive with shepherds of Isaac, saying, 'The water is ours;' and he calleth the name of the well 'Strife,' because they have striven habitually with him; ");
INSERT INTO engylt_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","and they dig another well, and they strive also for it, and he calleth its name 'Hatred.' ");
INSERT INTO engylt_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","And he removeth from thence, and diggeth another well, and they have not striven for it, and he calleth its name Enlargements, and saith, 'For — now hath Jehovah given enlargement to us, and we have been fruitful in the land.' ");
INSERT INTO engylt_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","And he goeth up from thence to Beer-Sheba, ");
INSERT INTO engylt_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","and Jehovah appeareth unto him during that night, and saith, 'I am the God of Abraham thy father, fear not, for I am with thee, and have blessed thee, and have multiplied thy seed, because of Abraham My servant;' ");
INSERT INTO engylt_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","and he buildeth there an altar, and preacheth in the name of Jehovah, and stretcheth out there his tent, and there Isaac's servants dig a well. ");
INSERT INTO engylt_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","And Abimelech hath gone unto him from Gerar, and Ahuzzath his friend, and Phichol head of his host; ");
INSERT INTO engylt_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","and Isaac saith unto them, 'Wherefore have ye come unto me, and ye have hated me, and ye send me away from you?' ");
INSERT INTO engylt_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","And they say, 'We have certainly seen that Jehovah hath been with thee, and we say, 'Let there be, we pray thee, an oath between us, between us and thee, and let us make a covenant with thee; ");
INSERT INTO engylt_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","do not evil with us, as we have not touched thee, and as we have only done good with thee, and send thee away in peace; thou art now blessed of Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","And he maketh for them a banquet, and they eat and drink, ");
INSERT INTO engylt_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","and rise early in the morning, and swear one to another, and Isaac sendeth them away, and they go from him in peace. ");
INSERT INTO engylt_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","And it cometh to pass during that day that Isaac's servants come and declare to him concerning the circumstances of the well which they have digged, and say to him, 'We have found water;' ");
INSERT INTO engylt_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","and he calleth it Shebah, oath, therefore the name of the city is Beer-Sheba, well of the oath, unto this day. ");
INSERT INTO engylt_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","And Esau is a son of forty years, and he taketh a wife, Judith, daughter of Beeri the Hittite, and Bashemath, daughter of Elon the Hittite, ");
INSERT INTO engylt_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","and they are a bitterness of spirit to Isaac and to Rebekah. ");
INSERT INTO engylt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","And it cometh to pass that Isaac is aged, and his eyes are too dim for seeing, and he calleth Esau his elder son, and saith unto him, 'My son;' and he saith unto him, 'Here am I.' ");
INSERT INTO engylt_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","And he saith, 'Lo, I pray thee, I have become aged, I have not known the day of my death; ");
INSERT INTO engylt_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","and now, take up, I pray thee, thy instruments, thy quiver, and thy bow, and go out to the field, and hunt for me provision, ");
INSERT INTO engylt_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","and make for me tasteful things, such as I have loved, and bring in to me, and I do eat, so that my soul doth bless thee before I die.' ");
INSERT INTO engylt_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","And Rebekah is hearkening while Isaac is speaking unto Esau his son; and Esau goeth to the field to hunt provision — to bring in; ");
INSERT INTO engylt_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","and Rebekah hath spoken unto Jacob her son, saying, 'Lo, I have heard thy father speaking unto Esau thy brother, saying, ");
INSERT INTO engylt_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Bring for me provision, and make for me tasteful things, and I do eat, and bless thee before Jehovah before my death. ");
INSERT INTO engylt_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","'And now, my son, hearken to my voice, to that which I am commanding thee: ");
INSERT INTO engylt_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go, I pray thee, unto the flock, and take for me from thence two good kids of the goats, and I make them tasteful things for thy father, such as he hath loved; ");
INSERT INTO engylt_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","and thou hast taken in to thy father, and he hath eaten, so that his soul doth bless thee before his death. ");
INSERT INTO engylt_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","And Jacob saith unto Rebekah his mother, 'Lo, Esau my brother is a hairy man, and I a smooth man, ");
INSERT INTO engylt_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","it may be my father doth feel me, and I have been in his eyes as a deceiver, and have brought upon me disesteem, and not a blessing;' ");
INSERT INTO engylt_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","and his mother saith to him, 'On me thy disesteem, my son; only hearken to my voice, and go, take for me.' ");
INSERT INTO engylt_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","And he goeth, and taketh, and bringeth to his mother, and his mother maketh tasteful things, such as his father hath loved; ");
INSERT INTO engylt_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","and Rebekah taketh the desirable garments of Esau her elder son, which are with her in the house, and doth put on Jacob her younger son; ");
INSERT INTO engylt_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","and the skins of the kids of the goats she hath put on his hands, and on the smooth of his neck, ");
INSERT INTO engylt_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","and she giveth the tasteful things, and the bread which she hath made, into the hand of Jacob her son. ");
INSERT INTO engylt_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","And he cometh in unto his father, and saith, 'My father;' and he saith, 'Here am I; who art thou, my son?' ");
INSERT INTO engylt_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","And Jacob saith unto his father, 'I am Esau thy first-born; I have done as thou hast spoken unto me; rise, I pray thee, sit, and eat of my provision, so that thy soul doth bless me.' ");
INSERT INTO engylt_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","And Isaac saith unto his son, 'What is this thou hast hasted to find, my son?' and he saith, 'That which Jehovah thy God hath caused to come before me.' ");
INSERT INTO engylt_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","And Isaac saith unto Jacob, 'Come nigh, I pray thee, and I feel thee, my son, whether thou art he, my son Esau, or not.' ");
INSERT INTO engylt_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","And Jacob cometh nigh unto Isaac his father, and he feeleth him, and saith, 'The voice is the voice of Jacob, and the hands hands of Esau.' ");
INSERT INTO engylt_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","And he hath not discerned him, for his hands have been hairy, as the hands of Esau his brother, and he blesseth him, ");
INSERT INTO engylt_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","and saith, 'Thou art he — my son Esau?' and he saith, 'I am.' ");
INSERT INTO engylt_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","And he saith, 'Bring nigh to me, and I do eat of my son's provision, so that my soul doth bless thee;' and he bringeth nigh to him, and he eateth; and he bringeth to him wine, and he drinketh. ");
INSERT INTO engylt_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","And Isaac his father saith to him, 'Come nigh, I pray thee, and kiss me, my son;' ");
INSERT INTO engylt_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","and he cometh nigh, and kisseth him, and he smelleth the fragrance of his garments, and blesseth him, and saith, 'See, the fragrance of my son is as the fragrance of a field which Jehovah hath blessed; ");
INSERT INTO engylt_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","and God doth give to thee of the dew of heaven, and of the fatness of the earth, and abundance of corn and wine; ");
INSERT INTO engylt_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","peoples serve thee, and nations bow themselves to thee, be thou mighty over thy brethren, and the sons of thy mother bow themselves to thee; those who curse thee are cursed, and those who bless thee are blessed.' ");
INSERT INTO engylt_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","And it cometh to pass, as Isaac hath finished blessing Jacob, and Jacob is only just going out from the presence of Isaac his father, that Esau his brother hath come in from his hunting; ");
INSERT INTO engylt_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","and he also maketh tasteful things, and bringeth to his father, and saith to his father, 'Let my father arise, and eat of his son's provision, so that thy soul doth bless me.' ");
INSERT INTO engylt_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","And Isaac his father saith to him, 'Who art thou?' and he saith, 'I am thy son, thy first-born, Esau;' ");
INSERT INTO engylt_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","and Isaac trembleth a very great trembling, and saith, 'Who, now, is he who hath provided provision, and bringeth in to me, and I eat of all before thou comest in, and I bless him? — yea, blessed is he.' ");
INSERT INTO engylt_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heareth the words of his father, then he crieth a very great and bitter cry, and saith to his father, 'Bless me, me also, O my father;' ");
INSERT INTO engylt_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","and he saith, 'Thy brother hath come with subtilty, and taketh thy blessing.' ");
INSERT INTO engylt_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","And he saith, 'Is it because one called his name Jacob that he doth take me by the heel these two times? my birthright he hath taken; and lo, now, he hath taken my blessing;' he saith also, 'Hast thou not kept back a blessing for me?' ");
INSERT INTO engylt_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","And Isaac answereth and saith to Esau, 'Lo, a mighty one have I set him over thee, and all his brethren have I given to him for servants, and with corn and wine have I sustained him; and for thee now, what shall I do, my son?' ");
INSERT INTO engylt_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","And Esau saith unto his father, 'One blessing hast thou my father? bless me, me also, O my father;' and Esau lifteth up his voice, and weepeth. ");
INSERT INTO engylt_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","And Isaac his father answereth and saith unto him, 'Lo, of the fatness of the earth is thy dwelling, and of the dew of the heavens from above; ");
INSERT INTO engylt_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","and by thy sword dost thou live, and thy brother dost thou serve; and it hath come to pass when thou rulest, that thou hast broken his yoke from off thy neck.' ");
INSERT INTO engylt_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","And Esau hateth Jacob, because of the blessing with which his father blessed him, and Esau saith in his heart, 'The days of mourning for my father draw near, and I slay Jacob my brother.' ");
INSERT INTO engylt_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","And the words of Esau her elder son are declared to Rebekah, and she sendeth and calleth for Jacob her younger son, and saith unto him, 'Lo, Esau thy brother is comforting himself in regard to thee — to slay thee; ");
INSERT INTO engylt_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","and now, my son, hearken to my voice, and rise, flee for thyself unto Laban my brother, to Haran, ");
INSERT INTO engylt_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","and thou hast dwelt with him some days, till thy brother's fury turn back, ");
INSERT INTO engylt_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","till thy brother's anger turn back from thee, and he hath forgotten that which thou hast done to him, and I have sent and taken thee from thence; why am I bereaved even of you both the same day?' ");
INSERT INTO engylt_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","And Rebekah saith unto Isaac, 'I have been disgusted with my life because of the presence of the daughters of Heth; if Jacob take a wife of the daughters of Heth, like these — from the daughters of the land — why do I live?' ");
INSERT INTO engylt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","And Isaac calleth unto Jacob, and blesseth him, and commandeth him, and saith to him, 'Thou dost not take a wife of the daughters of Caanan; ");
INSERT INTO engylt_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","rise, go to Padan-Aram, to the house of Bethuel, thy mother's father, and take for thyself from thence a wife, of the daughters of Laban, thy mother's brother; ");
INSERT INTO engylt_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","and God Almighty doth bless thee, and make thee fruitful, and multiply thee, and thou hast become an assembly of peoples; ");
INSERT INTO engylt_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","and He doth give to thee the blessing of Abraham, to thee and to thy seed with thee, to cause thee to possess the land of thy sojournings, which God gave to Abraham.' ");
INSERT INTO engylt_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","And Isaac sendeth away Jacob, and he goeth to Padan-Aram, unto Laban, son of Bethuel the Aramaean, brother of Rebekah, mother of Jacob and Esau. ");
INSERT INTO engylt_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","And Esau seeth that Isaac hath blessed Jacob, and hath sent him to Padan-Aram to take to himself from thence a wife — in his blessing him that he layeth a charge upon him, saying, Thou dost not take a wife from the daughters of Canaan — ");
INSERT INTO engylt_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","that Jacob hearkeneth unto his father and unto his mother, and goeth to Padan-Aram — ");
INSERT INTO engylt_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","and Esau seeth that the daughters of Canaan are evil in the eyes of Isaac his father, ");
INSERT INTO engylt_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","and Esau goeth unto Ishmael, and taketh Mahalath, daughter of Ishmael, Abraham's son, sister of Nebajoth, unto his wives, to himself, for a wife. ");
INSERT INTO engylt_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","And Jacob goeth out from Beer-Sheba, and goeth toward Haran, ");
INSERT INTO engylt_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","and he toucheth at a certain place, and lodgeth there, for the sun hath gone in, and he taketh of the stones of the place, and maketh them his pillows, and lieth down in that place. ");
INSERT INTO engylt_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","And he dreameth, and lo, a ladder set up on the earth, and its head is touching the heavens; and lo, messengers of God are going up and coming down by it; ");
INSERT INTO engylt_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","and lo, Jehovah is standing upon it, and He saith, 'I am Jehovah, God of Abraham thy father, and God of Isaac; the land on which thou art lying, to thee I give it, and to thy seed; ");
INSERT INTO engylt_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","and thy seed hath been as the dust of the land, and thou hast broken forth westward, and eastward, and northward, and southward, and all families of the ground have been blessed in thee and in thy seed. ");
INSERT INTO engylt_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","'And lo, I am with thee, and have kept thee whithersoever thou goest, and have caused thee to turn back unto this ground; for I leave thee not till that I have surely done that which I have spoken to thee.' ");
INSERT INTO engylt_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","And Jacob awaketh out of his sleep, and saith, 'Surely Jehovah is in this place, and I knew not;' ");
INSERT INTO engylt_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","and he feareth, and saith, 'How fearful is this place; this is nothing but a house of God, and this a gate of the heavens.' ");
INSERT INTO engylt_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","And Jacob riseth early in the morning, and taketh the stone which he hath made his pillows, and maketh it a standing pillar, and poureth oil upon its top, ");
INSERT INTO engylt_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","and he calleth the name of that place Bethel, house of God, and yet, Luz is the name of the city at the first. ");
INSERT INTO engylt_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","And Jacob voweth a vow, saying, 'Seeing God is with me, and hath kept me in this way which I am going, and hath given to me bread to eat, and a garment to put on — ");
INSERT INTO engylt_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","when I have turned back in peace unto the house of my father, and Jehovah hath become my God, ");
INSERT INTO engylt_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","then this stone which I have made a standing pillar is a house of God, and all that Thou dost give to me — tithing I tithe to Thee.' ");
INSERT INTO engylt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","And Jacob lifteth up his feet, and goeth towards the land of the sons of the east; ");
INSERT INTO engylt_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","and he looketh, and lo, a well in the field, and lo, there three droves of a flock crouching by it, for from that well they water the droves, and the great stone is on the mouth of the well. ");
INSERT INTO engylt_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","(When thither have all the droves been gathered, and they have rolled the stone from off the mouth of the well, and have watered the flock, then they have turned back the stone on the mouth of the well to its place.) ");
INSERT INTO engylt_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","And Jacob saith to them, 'My brethren, from whence are ye?' and they say, 'We are from Haran.' ");
INSERT INTO engylt_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","And he saith to them, 'Have ye known Laban, son of Nahor?' and they say, 'We have known.' ");
INSERT INTO engylt_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","And he saith to them, 'Hath he peace?' and they say, 'Peace; and lo, Rachel his daughter is coming with the flock.' ");
INSERT INTO engylt_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","And he saith, 'Lo, the day is still great, it is not time for the cattle to be gathered; water ye the flock, and go, delight yourselves.' ");
INSERT INTO engylt_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","And they say, 'We are not able, till that all the droves be gathered together, and they have rolled away the stone from the mouth of the well, and we have watered the flock.' ");
INSERT INTO engylt_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","He is yet speaking with them, and Rachel hath come with the flock which her father hath, for she is shepherdess; ");
INSERT INTO engylt_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","and it cometh to pass when Jacob hath seen Rachel, daughter of Laban his mother's brother, and the flock of Laban his mother's brother, that Jacob cometh nigh and rolleth the stone from off the mouth of the well, and watereth the flock of Laban his mother's brother. ");
INSERT INTO engylt_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","And Jacob kisseth Rachel, and lifteth up his voice, and weepeth, ");
INSERT INTO engylt_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","and Jacob declareth to Rachel that he is her father's brother, and that he is Rebekah's son, and she runneth and declareth to her father. ");
INSERT INTO engylt_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","And it cometh to pass, when Laban heareth the report of Jacob his sister's son, that he runneth to meet him, and embraceth him, and kisseth him, and bringeth him in unto his house; and he recounteth to Laban all these things, ");
INSERT INTO engylt_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","and Laban saith to him, 'Only my bone and my flesh art thou;' and he dwelleth with him a month of days. ");
INSERT INTO engylt_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","And Laban saith to Jacob, 'Is it because thou art my brother that thou hast served me for nought? declare to me what is thy hire.' ");
INSERT INTO engylt_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","And Laban hath two daughters, the name of the elder is Leah, and the name of the younger Rachel, ");
INSERT INTO engylt_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","and the eyes of Leah are tender, and Rachel hath been fair of form and fair of appearance. ");
INSERT INTO engylt_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","And Jacob loveth Rachel, and saith, 'I serve thee seven years for Rachel thy younger daughter:' ");
INSERT INTO engylt_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","and Laban saith, 'It is better for me to give her to thee than to give her to another man; dwell with me;' ");
INSERT INTO engylt_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","and Jacob serveth for Rachel seven years; and they are in his eyes as some days, because of his loving her. ");
INSERT INTO engylt_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","And Jacob saith unto Laban, 'Give up my wife, for my days have been fulfilled, and I go in unto her;' ");
INSERT INTO engylt_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","and Laban gathereth all the men of the place, and maketh a banquet. ");
INSERT INTO engylt_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","And it cometh to pass in the evening, that he taketh Leah, his daughter, and bringeth her in unto him, and he goeth in unto her; ");
INSERT INTO engylt_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","and Laban giveth to her Zilpah, his maid-servant, to Leah his daughter, a maid-servant. ");
INSERT INTO engylt_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","And it cometh to pass in the morning, that lo, it is Leah; and he saith unto Laban, 'What is this thou hast done to me? for Rachel have I not served with thee? and why hast thou deceived me?' ");
INSERT INTO engylt_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","And Laban saith, 'It is not done so in our place, to give the younger before the first-born; ");
INSERT INTO engylt_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","fulfil the week of this one, and we give to thee also this one, for the service which thou dost serve with me yet seven other years.' ");
INSERT INTO engylt_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","And Jacob doth so, and fulfilleth the week of this one, and he giveth to him Rachel his daughter, to him for a wife; ");
INSERT INTO engylt_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","and Laban giveth to Rachel his daughter Bilhah his maid-servant, for a maid-servant to her. ");
INSERT INTO engylt_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","And he goeth in also unto Rachel, and he also loveth Rachel more than Leah; and he serveth with him yet seven other years. ");
INSERT INTO engylt_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","And Jehovah seeth that Leah is the hated one, and He openeth her womb, and Rachel is barren; ");
INSERT INTO engylt_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","and Leah conceiveth, and beareth a son, and calleth his name Reuben, for she said, 'Because Jehovah hath looked on mine affliction; because now doth my husband love me.' ");
INSERT INTO engylt_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","And she conceiveth again, and beareth a son, and saith, 'Because Jehovah hath heard that I am the hated one, He also giveth to me even this one;' and she calleth his name Simeon. ");
INSERT INTO engylt_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","And she conceiveth again, and beareth a son, and saith, 'Now is the time, my husband is joined unto me, because I have born to him three sons,' therefore hath one called his name Levi. ");
INSERT INTO engylt_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","And she conceiveth again, and beareth a son, and saith this time, 'I praise Jehovah;' therefore hath she called his name Judah; and she ceaseth from bearing. ");
INSERT INTO engylt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","And Rachel seeth that she hath not borne to Jacob, and Rachel is envious of her sister, and saith unto Jacob, 'Give me sons, and if there is none — I die.' ");
INSERT INTO engylt_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","And Jacob's anger burneth against Rachel, and he saith, 'Am I in stead of God who hath withheld from thee the fruit of the womb?' ");
INSERT INTO engylt_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","And she saith, 'Lo, my handmaid Bilhah, go in unto her, and she doth bear on my knees, and I am built up, even I, from her;' ");
INSERT INTO engylt_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","and she giveth to him Bilhah her maid-servant for a wife, and Jacob goeth in unto her; ");
INSERT INTO engylt_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","and Bilhah conceiveth, and beareth to Jacob a son, ");
INSERT INTO engylt_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","and Rachel saith, 'God hath decided for me, and also hath hearkened to my voice, and giveth to me a son;' therefore hath she called his name Dan. ");
INSERT INTO engylt_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","And Bilhah, Rachel's maid-servant, conceiveth again, and beareth a second son to Jacob, ");
INSERT INTO engylt_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","and Rachel saith, 'With wrestlings of God I have wrestled with my sister, yea, I have prevailed;' and she calleth his name Napthali. ");
INSERT INTO engylt_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","And Leah seeth that she hath ceased from bearing, and she taketh Zilpah her maid-servant, and giveth her to Jacob for a wife; ");
INSERT INTO engylt_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","and Zilpah, Leah's maid-servant, beareth to Jacob a son, ");
INSERT INTO engylt_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","and Leah saith, 'A troop is coming;' and she calleth his name Gad. ");
INSERT INTO engylt_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","And Zilpah, Leah's maid-servant, beareth a second son to Jacob, ");
INSERT INTO engylt_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","and Leah saith, 'Because of my happiness, for daughters have pronounced me happy;' and she calleth his name Asher. ");
INSERT INTO engylt_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","And Reuben goeth in the days of wheat-harvest, and findeth love-apples in the field, and bringeth them in unto Leah, his mother, and Rachel saith unto Leah, 'Give to me, I pray thee, of the love-apples of thy son.' ");
INSERT INTO engylt_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","And she saith to her, 'Is thy taking my husband a little thing, that thou hast taken also the love-apples of my son?' and Rachel saith, 'Therefore doth he lie with thee to-night, for thy son's love-apples.' ");
INSERT INTO engylt_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","And Jacob cometh in from the field at evening; and Leah goeth to meet him, and saith, 'Unto me dost thou come in, for hiring I have hired thee with my son's love-apples;' and he lieth with her during that night. ");
INSERT INTO engylt_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","And God hearkeneth unto Leah, and she conceiveth, and beareth to Jacob a son, a fifth, ");
INSERT INTO engylt_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","and Leah saith, 'God hath given my hire, because I have given my maid-servant to my husband;' and she calleth his name Issachar. ");
INSERT INTO engylt_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","And conceive again doth Leah, and she beareth a sixth son to Jacob, ");
INSERT INTO engylt_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","and Leah saith, 'God hath endowed me — a good dowry; this time doth my husband dwell with me, for I have borne to him six sons;' and she calleth his name Zebulun; ");
INSERT INTO engylt_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","and afterwards hath she born a daughter, and calleth her name Dinah. ");
INSERT INTO engylt_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","And God remembereth Rachel, and God hearkeneth unto her, and openeth her womb, ");
INSERT INTO engylt_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","and she conceiveth and beareth a son, and saith, 'God hath gathered up my reproach;' ");
INSERT INTO engylt_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","and she calleth his name Joseph, saying, 'Jehovah is adding to me another son.' ");
INSERT INTO engylt_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","And it cometh to pass, when Rachel hath borne Joseph, that Jacob saith unto Laban, 'Send me away, and I go unto my place, and to my land; ");
INSERT INTO engylt_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","give up my wives and my children, for whom I have served thee, and I go; for thou — thou hast known my service which I have served thee.' ");
INSERT INTO engylt_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","And Laban saith unto him, 'If, I pray thee, I have found grace in thine eyes — I have observed diligently that Jehovah doth bless me for thy sake.' ");
INSERT INTO engylt_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","He saith also, 'Define thy hire to me, and I give.' ");
INSERT INTO engylt_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","And he saith unto him, 'Thou — thou hast known that which I have served thee in, and that which thy substance was with me; ");
INSERT INTO engylt_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","for it is little which thou hast had at my appearance, and it breaketh forth into a multitude, and Jehovah blesseth thee at my coming; and now, when do I make, I also, for mine own house?' ");
INSERT INTO engylt_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","And he saith, 'What do I give to thee?' And Jacob saith, 'Thou dost not give me anything; if thou do for me this thing, I turn back; I have delight; thy flock I watch; ");
INSERT INTO engylt_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I pass through all thy flock to-day to turn aside from thence every sheep speckled and spotted, and every brown sheep among the lambs, and speckled and spotted among the goats — and it hath been my hire; ");
INSERT INTO engylt_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","and my righteousness hath answered for me in the day to come, when it cometh in for my hire before thy face; — every one which is not speckled and spotted among my goats, and brown among my lambs — it is stolen with me.' ");
INSERT INTO engylt_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","And Laban saith, 'Lo, O that it were according to thy word;' ");
INSERT INTO engylt_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","and he turneth aside during that day the ring-streaked and the spotted he-goats, and all the speckled and the spotted she-goats, every one that hath white in it, and every brown one among the lambs, and he giveth into the hand of his sons, ");
INSERT INTO engylt_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","and setteth a journey of three days between himself and Jacob; and Jacob is feeding the rest of the flock of Laban. ");
INSERT INTO engylt_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","And Jacob taketh to himself a rod of fresh poplar, and of the hazel and chesnut, and doth peel in them white peelings, making bare the white that is on the rods, ");
INSERT INTO engylt_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","and setteth up the rods which he hath peeled in the gutters in the watering troughs (when the flock cometh in to drink), over-against the flock, that they may conceive in their coming in to drink; ");
INSERT INTO engylt_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","and the flocks conceive at the rods, and the flock beareth ring-streaked, speckled, and spotted ones. ");
INSERT INTO engylt_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","And the lambs hath Jacob parted, and he putteth the face of the flock towards the ring-streaked, also all the brown in the flock of Laban, and he setteth his own droves by themselves, and hath not set them near Laban's flock. ");
INSERT INTO engylt_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","And it hath come to pass whenever the strong ones of the flock conceive, that Jacob set the rods before the eyes of the flock in the gutters, to cause them to conceive by the rods, ");
INSERT INTO engylt_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","and when the flock is feeble, he doth not set them; and the feeble ones have been Laban's, and the strong ones Jacob's. ");
INSERT INTO engylt_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","And the man increaseth very exceedingly, and hath many flocks, and maid-servants, and men-servants, and camels, and asses. ");
INSERT INTO engylt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","And he heareth the words of Laban's sons, saying, 'Jacob hath taken all that our father hath; yea, from that which our father hath, he hath made all this honour;' ");
INSERT INTO engylt_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","and Jacob seeth the face of Laban, and lo, it is not with him as heretofore. ");
INSERT INTO engylt_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","And Jehovah saith unto Jacob, 'Turn back unto the land of thy fathers, and to thy kindred, and I am with thee.' ");
INSERT INTO engylt_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","And Jacob sendeth and calleth for Rachel and for Leah to the field unto his flock; ");
INSERT INTO engylt_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","and saith to them, 'I am beholding your father's face — that it is not towards me as heretofore, and the God of my father hath been with me, ");
INSERT INTO engylt_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","and ye — ye have known that with all my power I have served your father, ");
INSERT INTO engylt_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","and your father hath played upon me, and hath changed my hire ten times; and God hath not suffered him to do evil with me. ");
INSERT INTO engylt_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","'If he say thus: The speckled are thy hire, then bare all the flock speckled ones; and if he say thus: The ring-streaked are thy hire, then bare all the flock ring-streaked; ");
INSERT INTO engylt_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","and God taketh away the substance of your father, and doth give to me. ");
INSERT INTO engylt_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","'And it cometh to pass at the time of the flock conceiving, that I lift up mine eyes and see in a dream, and lo, the he-goats, which are going up on the flock, are ring-streaked, speckled, and grisled; ");
INSERT INTO engylt_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","and the messenger of God saith unto me in the dream, Jacob, and I say, Here am I. ");
INSERT INTO engylt_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","'And He saith, Lift up, I pray thee, thine eyes, and see — all the he-goats which are going up on the flock are ring-streaked, speckled, and grisled, for I have seen all that Laban is doing to thee; ");
INSERT INTO engylt_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Bethel where thou hast anointed a standing pillar, where thou hast vowed a vow to me; now, arise, go out from this land, and turn back unto the land of thy birth.' ");
INSERT INTO engylt_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","And Rachel answereth — Leah also — and saith to him, 'Have we yet a portion and inheritance in the house of our father? ");
INSERT INTO engylt_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","have we not been reckoned strangers to him? for he hath sold us, and he also utterly consumeth our money; ");
INSERT INTO engylt_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","for all the wealth which God hath taken away from our father, it is ours, and our children's; and now, all that God hath said unto thee — do.' ");
INSERT INTO engylt_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","And Jacob riseth, and lifteth up his sons and his wives on the camels, ");
INSERT INTO engylt_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","and leadeth all his cattle, and all his substance which he hath acquired, the cattle of his getting, which he hath acquired in Padan-Aram, to go unto Isaac his father, to the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","And Laban hath gone to shear his flock, and Rachel stealeth the teraphim which her father hath; ");
INSERT INTO engylt_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","and Jacob deceiveth the heart of Laban the Aramaean, because he hath not declared to him that he is fleeing; ");
INSERT INTO engylt_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","and he fleeth, he and all that he hath, and riseth, and passeth over the River, and setteth his face toward the mount of Gilead. ");
INSERT INTO engylt_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","And it is told to Laban on the third day that Jacob hath fled, ");
INSERT INTO engylt_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","and he taketh his brethren with him, and pursueth after him a journey of seven days, and overtaketh him in the mount of Gilead. ");
INSERT INTO engylt_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","And God cometh in unto Laban the Aramaean in a dream of the night, and saith to him, 'Take heed to thyself lest thou speak with Jacob from good unto evil.' ");
INSERT INTO engylt_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","And Laban overtaketh Jacob; and Jacob hath fixed his tent in the mount; and Laban with his brethren have fixed theirs in the mount of Gilead. ");
INSERT INTO engylt_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","And Laban saith to Jacob, 'What hast thou done that thou dost deceive my heart, and lead away my daughters as captives of the sword? ");
INSERT INTO engylt_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why hast thou hidden thyself to flee, and deceivest me, and hast not declared to me, and I send thee away with joy and with songs, with tabret and with harp, ");
INSERT INTO engylt_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","and hast not suffered me to kiss my sons and my daughters? — now thou hast acted foolishly in doing so; ");
INSERT INTO engylt_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","my hand is to God to do evil with you, but the God of your father yesternight hath spoken unto me, saying, Take heed to thyself from speaking with Jacob from good unto evil. ");
INSERT INTO engylt_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","'And now, thou hast certainly gone, because thou hast been very desirous for the house of thy father; why hast thou stolen my gods?' ");
INSERT INTO engylt_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","And Jacob answereth and saith to Laban, 'Because I was afraid, for I said, Lest thou take violently away thy daughters from me; ");
INSERT INTO engylt_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","with whomsoever thou findest thy gods — he doth not live; before our brethren discern for thyself what is with me, and take to thyself:' and Jacob hath not known that Rachel hath stolen them. ");
INSERT INTO engylt_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","And Laban goeth into the tent of Jacob, and into the tent of Leah, and into the tent of the two handmaidens, and hath not found; and he goeth out from the tent of Leah, and goeth into the tent of Rachel. ");
INSERT INTO engylt_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","And Rachel hath taken the teraphim, and putteth them in the furniture of the camel, and sitteth upon them; and Laban feeleth all the tent, and hath not found; ");
INSERT INTO engylt_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","and she saith unto her father, 'Let it not be displeasing in the eyes of my lord that I am not able to rise at thy presence, for the way of women is on me;' and he searcheth, and hath not found the teraphim. ");
INSERT INTO engylt_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","And it is displeasing to Jacob, and he striveth with Laban; and Jacob answereth and saith to Laban, 'What is my transgression? what my sin, that thou hast burned after me? ");
INSERT INTO engylt_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","for thou hast felt all my vessels: what hast thou found of all the vessels of thy house? set here before my brethren, and thy brethren, and they decide between us both. ");
INSERT INTO engylt_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","'These twenty years I am with thee: thy ewes and thy she-goats have not miscarried, and the rams of thy flock I have not eaten; ");
INSERT INTO engylt_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","the torn I have not brought in unto thee — I, I repay it — from my hand thou dost seek it; I have been deceived by day, and I have been deceived by night; ");
INSERT INTO engylt_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","I have been thus: in the day consumed me hath drought, and frost by night, and wander doth my sleep from mine eyes. ");
INSERT INTO engylt_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","'This is to me twenty years in thy house: I have served thee fourteen years for thy two daughters, and six years for thy flock; and thou changest my hire ten times; ");
INSERT INTO engylt_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","unless the God of my father, the God of Abraham, and the Fear of Isaac, had been for me, surely now empty thou hadst sent me away; mine affliction and the labour of my hands hath God seen, and reproveth yesternight.' ");
INSERT INTO engylt_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","And Laban answereth and saith unto Jacob, 'The daughters are my daughters, and the sons my sons, and the flock my flock, and all that thou art seeing is mine; and to my daughters — what do I to these to-day, or to their sons whom they have born? ");
INSERT INTO engylt_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","and now, come, let us make a covenant, I and thou, and it hath been for a witness between me and thee.' ");
INSERT INTO engylt_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","And Jacob taketh a stone, and lifteth it up for a standing pillar; ");
INSERT INTO engylt_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","and Jacob saith to his brethren, 'Gather stones,' and they take stones, and make a heap; and they eat there on the heap; ");
INSERT INTO engylt_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","and Laban calleth it Jegar-Sahadutha; and Jacob hath called it Galeed. ");
INSERT INTO engylt_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","And Laban saith, 'This heap is witness between me and thee to-day;' therefore hath he called its name Galeed; ");
INSERT INTO engylt_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mizpah also, for he said, 'Jehovah doth watch between me and thee, for we are hidden one from another; ");
INSERT INTO engylt_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","if thou afflict my daughters, or take wives beside my daughters — there is no man with us — see, God is witness between me and thee.' ");
INSERT INTO engylt_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","And Laban saith to Jacob, 'Lo, this heap, and lo, the standing pillar which I have cast between me and thee; ");
INSERT INTO engylt_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","this heap is witness, and the standing pillar is witness, that I do not pass over this heap unto thee, and that thou dost not pass over this heap and this standing pillar unto me — for evil; ");
INSERT INTO engylt_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","the God of Abraham and the God of Nahor, doth judge between us — the God of their father,' and Jacob sweareth by the Fear of his father Isaac. ");
INSERT INTO engylt_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","And Jacob sacrificeth a sacrifice in the mount, and calleth to his brethren to eat bread, and they eat bread, and lodge in the mount; ");
INSERT INTO engylt_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","and Laban riseth early in the morning, and kisseth his sons and his daughters, and blesseth them; and Laban goeth on, and turneth back to his place. ");
INSERT INTO engylt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","And Jacob hath gone on his way, and messengers of God come upon him; ");
INSERT INTO engylt_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","and Jacob saith, when he hath seen them, 'This is the camp of God;' and he calleth the name of that place 'Two Camps.' ");
INSERT INTO engylt_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","And Jacob sendeth messengers before him unto Esau his brother, towards the land of Seir, the field of Edom, ");
INSERT INTO engylt_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","and commandeth them, saying, 'Thus do ye say to my lord, to Esau: Thus said thy servant Jacob, With Laban I have sojourned, and I tarry until now; ");
INSERT INTO engylt_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","and I have ox, and ass, flock, and man-servant, and maid-servant, and I send to declare to my lord, to find grace in his eyes.' ");
INSERT INTO engylt_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","And the messengers turn back unto Jacob, saying, 'We came in unto thy brother, unto Esau, and he also is coming to meet thee, and four hundred men with him;' ");
INSERT INTO engylt_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","and Jacob feareth exceedingly, and is distressed, and he divideth the people who are with him, and the flock, and the herd, and the camels, into two camps, ");
INSERT INTO engylt_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","and saith, 'If Esau come in unto the one camp, and have smitten it — then the camp which is left hath been for an escape.' ");
INSERT INTO engylt_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","And Jacob saith, 'God of my father Abraham, and God of my father Isaac, Jehovah who saith unto me, Turn back to thy land, and to thy kindred, and I do good with thee: ");
INSERT INTO engylt_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I have been unworthy of all the kind acts, and of all the truth which Thou hast done with thy servant — for, with my staff I passed over this Jordan, and now I have become two camps. ");
INSERT INTO engylt_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","'Deliver me, I pray Thee, from the hand of my brother, from the hand of Esau: for I am fearing him, less he come and have smitten me — mother beside sons; ");
INSERT INTO engylt_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","and Thou — Thou hast said, I certainly do good with thee, and have set thy seed as the sand of the sea, which is not numbered because of the multitude.' ");
INSERT INTO engylt_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","And he lodgeth there during that night, and taketh from that which is coming into his hand, a present for Esau his brother: ");
INSERT INTO engylt_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","she-goats two hundred, and he-goats twenty, ewes two hundred, and rams twenty, ");
INSERT INTO engylt_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","suckling camels and their young ones thirty, cows forty, and bullocks ten, she-asses twenty, and foals ten; ");
INSERT INTO engylt_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","and he giveth into the hand of his servants, every drove by itself, and saith unto his servants, 'Pass over before me, and a space ye do put between drove and drove.' ");
INSERT INTO engylt_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","And he commandeth the first, saying, 'When Esau my brother meeteth thee, and hath asked thee, saying, Whose art thou? and whither goest thou? and whose are these before thee? ");
INSERT INTO engylt_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","then thou hast said, Thy servant Jacob's: it is a present sent to my lord, to Esau; and lo, he also is behind us.' ");
INSERT INTO engylt_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","And he commandeth also the second, also the third, also all who are going after the droves, saying, 'According to this manner do ye speak unto Esau in your finding him, ");
INSERT INTO engylt_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","and ye have said also, Lo, thy servant Jacob is behind us;' for he said, 'I pacify his face with the present which is going before me, and afterwards I see his face; it may be he lifteth up my face;' ");
INSERT INTO engylt_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","and the present passeth over before his face, and he hath lodged during that night in the camp. ");
INSERT INTO engylt_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","And he riseth in that night, and taketh his two wives, and his two maid-servants, and his eleven children, and passeth over the passage of Jabbok; ");
INSERT INTO engylt_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","and he taketh them, and causeth them to pass over the brook, and he causeth that which he hath to pass over. ");
INSERT INTO engylt_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","And Jacob is left alone, and one wrestleth with him till the ascending of the dawn; ");
INSERT INTO engylt_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","and he seeth that he is not able for him, and he cometh against the hollow of his thigh, and the hollow of Jacob's thigh is disjointed in his wrestling with him; ");
INSERT INTO engylt_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","and he saith, 'Send me away, for the dawn hath ascended:' and he saith, 'I send thee not away, except thou hast blessed me.' ");
INSERT INTO engylt_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","And he saith unto him, 'What is thy name?' and he saith, 'Jacob.' ");
INSERT INTO engylt_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","And he saith, 'Thy name is no more called Jacob, but Israel; for thou hast been a prince with God and with men, and dost prevail.' ");
INSERT INTO engylt_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","And Jacob asketh, and saith, 'Declare, I pray thee, thy name;' and he saith, 'Why is this, thou askest for My name?' and He blesseth him there. ");
INSERT INTO engylt_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","And Jacob calleth the name of the place Peniel: for 'I have seen God face unto face, and my life is delivered;' ");
INSERT INTO engylt_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","and the sun riseth on him when he hath passed over Penuel, and he is halting on his thigh; ");
INSERT INTO engylt_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","therefore the sons of Israel do not eat the sinew which shrank, which is on the hollow of the thigh, unto this day, because He came against the hollow of Jacob's thigh, against the sinew which shrank. ");
INSERT INTO engylt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","And Jacob lifteth up his eyes, and looketh, and lo, Esau is coming, and with him four hundred men; and he divideth the children unto Leah, and unto Rachel, and unto the two maid-servants; ");
INSERT INTO engylt_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","and he setteth the maid-servants and their children first, and Leah and her children behind, and Rachel and Joseph last. ");
INSERT INTO engylt_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","And he himself passed over before them, and boweth himself to the earth seven times, until his drawing nigh unto his brother, ");
INSERT INTO engylt_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","and Esau runneth to meet him, and embraceth him, and falleth on his neck, and kisseth him, and they weep; ");
INSERT INTO engylt_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","and he lifteth up his eyes, and seeth the women and the children, and saith, 'What are these to thee?' And he saith, 'The children with whom God hath favoured thy servant.' ");
INSERT INTO engylt_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","And the maid-servants draw nigh, they and their children, and bow themselves; ");
INSERT INTO engylt_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","and Leah also draweth nigh, and her children, and they bow themselves; and afterwards Joseph hath drawn nigh with Rachel, and they bow themselves. ");
INSERT INTO engylt_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","And he saith, 'What to thee is all this camp which I have met?' and he saith, 'To find grace in the eyes of my lord.' ");
INSERT INTO engylt_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","And Esau saith, 'I have abundance, my brother, let it be to thyself that which thou hast.' ");
INSERT INTO engylt_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","And Jacob saith, 'Nay, I pray thee, if, I pray thee, I have found grace in thine eyes, then thou hast received my present from my hand, because that I have seen thy face, as the seeing of the face of God, and thou art pleased with me; ");
INSERT INTO engylt_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","receive, I pray thee, my blessing, which is brought to thee, because God hath favoured me, and because I have all things;' and he presseth on him, and he receiveth, ");
INSERT INTO engylt_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","and saith, 'Let us journey and go on, and I go on before thee.' ");
INSERT INTO engylt_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","And he saith unto him, 'My lord knoweth that the children are tender, and the suckling flock and the herd are with me; when they have beaten them one day, then hath all the flock died. ");
INSERT INTO engylt_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Let my lord, I pray thee, pass over before his servant, and I — I lead on gently, according to the foot of the work which is before me, and to the foot of the children, until that I come unto my lord, to Seir.' ");
INSERT INTO engylt_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","And Esau saith, 'Let me, I pray thee, place with thee some of the people who are with me;' and he said, 'Why is this? I find grace in the eyes of my lord.' ");
INSERT INTO engylt_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","And turn back on that day doth Esau on his way to Seir; ");
INSERT INTO engylt_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","and Jacob hath journeyed to Succoth, and buildeth to himself a house, and for his cattle hath made booths, therefore hath he called the name of the place Succoth. ");
INSERT INTO engylt_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","And Jacob cometh in to Shalem, a city of Shechem, which is in the land of Canaan, in his coming from Padan-Aram, and encampeth before the city, ");
INSERT INTO engylt_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","and he buyeth the portion of the field where he hath stretched out his tent, from the hand of the sons of Hamor, father of Shechem, for a hundred kesitah; ");
INSERT INTO engylt_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","and he setteth up there an altar, and proclaimeth at it God — the God of Israel. ");
INSERT INTO engylt_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","And Dinah, daughter of Leah, whom she hath borne to Jacob, goeth out to look on the daughters of the land, ");
INSERT INTO engylt_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","and Shechem, son of Hamor the Hivite, a prince of the land, seeth her, and taketh her, and lieth with her, and humbleth her; ");
INSERT INTO engylt_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","and his soul cleaveth to Dinah, daughter of Jacob, and he loveth the young person, and speaketh unto the heart of the young person. ");
INSERT INTO engylt_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","And Shechem speaketh unto Hamor his father, saying, 'Take for me this damsel for a wife.' ");
INSERT INTO engylt_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","And Jacob hath heard that he hath defiled Dinah his daughter, and his sons were with his cattle in the field, and Jacob kept silent till their coming. ");
INSERT INTO engylt_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","And Hamor, father of Shechem, goeth out unto Jacob to speak with him; ");
INSERT INTO engylt_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","and the sons of Jacob came in from the field when they heard, and the men grieve themselves, and it is very displeasing to them, for folly he hath done against Israel, to lie with the daughter of Jacob — and so it is not done. ");
INSERT INTO engylt_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","And Hamor speaketh with them, saying, 'Shechem, my son, his soul hath cleaved to your daughter; give her, I pray you, to him for a wife, ");
INSERT INTO engylt_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","and join ye in marriage with us; your daughters ye give to us, and our daughters ye take to yourselves, ");
INSERT INTO engylt_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","and with us ye dwell, and the land is before you; dwell ye and trade in it, and have possessions in it.' ");
INSERT INTO engylt_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","And Shechem saith unto her father, and unto her brethren, 'Let me find grace in your eyes, and that which ye say unto me, I give; ");
INSERT INTO engylt_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","multiply on me exceedingly dowry and gift, and I give as ye say unto me, and give to me the young person for a wife.' ");
INSERT INTO engylt_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","And the sons of Jacob answer Shechem and Hamor his father deceitfully, and they speak (because he defiled Dinah their sister), ");
INSERT INTO engylt_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","and say unto them, 'We are not able to do this thing, to give our sister to one who hath a foreskin: for it is a reproach to us. ");
INSERT INTO engylt_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","'Only for this we consent to you; if ye be as we, to have every male of you circumcised, ");
INSERT INTO engylt_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","then we have given our daughters to you, and your daughters we take to ourselves, and we have dwelt with you, and have become one people; ");
INSERT INTO engylt_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","and if ye hearken not unto us to be circumcised, then we have taken our daughter, and have gone.' ");
INSERT INTO engylt_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","And their words are good in the eyes of Hamor, and in the eyes of Shechem, Hamor's son; ");
INSERT INTO engylt_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","and the young man delayed not to do the thing, for he had delight in Jacob's daughter, and he is honourable above all the house of his father. ");
INSERT INTO engylt_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","And Hamor cometh — Shechem his son also — unto the gate of their city, and they speak unto the men of their city, saying, ");
INSERT INTO engylt_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","'These men are peaceable with us; then let them dwell in the land, and trade in it; and the land, lo, is wide before them; their daughters let us take to ourselves for wives, and our daughters give to them. ");
INSERT INTO engylt_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","'Only for this do the men consent to us, to dwell with us, to become one people, in every male of us being circumcised, as they are circumcised; ");
INSERT INTO engylt_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","their cattle, and their substance, and all their beasts — are they not ours? only let us consent to them, and they dwell with us.' ");
INSERT INTO engylt_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","And unto Hamor, and unto Shechem his son, hearken do all those going out of the gate of his city, and every male is circumcised, all those going out of the gate of his city. ");
INSERT INTO engylt_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","And it cometh to pass, on the third day, in their being pained, that two of the sons of Jacob, Simeon and Levi, Dinah's brethren, take each his sword, and come in against the city confidently, and slay every male; ");
INSERT INTO engylt_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","and Hamor, and Shechem his son, they have slain by the mouth of the sword, and they take Dinah out of Shechem's house, and go out. ");
INSERT INTO engylt_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob's sons have come in upon the wounded, and they spoil the city, because they had defiled their sister; ");
INSERT INTO engylt_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","their flock and their herd, and their asses, and that which is in the city, and that which is in the field, have they taken; ");
INSERT INTO engylt_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","and all their wealth, and all their infants, and their wives they have taken captive, and they spoil also all that is in the house. ");
INSERT INTO engylt_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","And Jacob saith unto Simeon and unto Levi, 'Ye have troubled me, by causing me to stink among the inhabitants of the land, among the Canaanite, and among the Perizzite: and I am few in number, and they have been gathered against me, and have smitten me, and I have been destroyed, I and my house.' ");
INSERT INTO engylt_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","And they say, 'As a harlot doth he make our sister?' ");
INSERT INTO engylt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","And God saith unto Jacob, 'Rise, go up to Bethel, and dwell there, and make there an altar to God, who appeared unto thee in thy fleeing from the face of Esau thy brother.' ");
INSERT INTO engylt_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","And Jacob saith unto his household, and unto all who are with him, 'Turn aside the gods of the stranger which are in your midst, and cleanse yourselves, and change your garments; ");
INSERT INTO engylt_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","and we rise, and go up to Bethel, and I make there an altar to God, who is answering me in the day of my distress, and is with me in the way that I have gone.' ");
INSERT INTO engylt_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","And they give unto Jacob all the gods of the stranger that are in their hand, and the rings that are in their ears, and Jacob hideth them under the oak which is by Shechem; ");
INSERT INTO engylt_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","and they journey, and the terror of God is on the cities which are round about them, and they have not pursued after the sons of Jacob. ");
INSERT INTO engylt_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","And Jacob cometh in to Luz which is in the land of Canaan (it is Bethel), he and all the people who are with him, ");
INSERT INTO engylt_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","and he buildeth there an altar, and proclaimeth at the place the God of Bethel: for there had God been revealed unto him, in his fleeing from the face of his brother. ");
INSERT INTO engylt_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","And Deborah, Rebekah's nurse, dieth, and she is buried at the lower part of Bethel, under the oak, and he calleth its name 'Oak of weeping.' ");
INSERT INTO engylt_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","And God appeareth unto Jacob again, in his coming from Padan-Aram, and blesseth him; ");
INSERT INTO engylt_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","and God saith to him, 'Thy name is Jacob: thy name is no more called Jacob, but Israel is thy name;' and He calleth his name Israel. ");
INSERT INTO engylt_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","And God saith to him, 'I am God Almighty; be fruitful and multiply, a nation and an assembly of nations is from thee, and kings from thy loins go out; ");
INSERT INTO engylt_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","and the land which I have given to Abraham and to Isaac — to thee I give it, yea to thy seed after thee I give the land.' ");
INSERT INTO engylt_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","And God goeth up from him, in the place where He hath spoken with him. ");
INSERT INTO engylt_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","And Jacob setteth up a standing pillar in the place where He hath spoken with him, a standing pillar of stone, and he poureth on it an oblation, and he poureth on it oil; ");
INSERT INTO engylt_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","and Jacob calleth the name of the place where God spake with him Bethel. ");
INSERT INTO engylt_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","And they journey from Bethel, and there is yet a kibrath of land before entering Ephratha, and Rachel beareth, and is sharply pained in her bearing; ");
INSERT INTO engylt_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","and it cometh to pass, in her being sharply pained in her bearing, that the midwife saith to her, 'Fear not, for this also is a son for thee.' ");
INSERT INTO engylt_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","And it cometh to pass in the going out of her soul (for she died), that she calleth his name Ben-Oni; and his father called him Benjamin; ");
INSERT INTO engylt_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","and Rachel dieth, and is buried in the way to Ephratha, which is Bethlehem, ");
INSERT INTO engylt_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","and Jacob setteth up a standing pillar over her grave; which is the standing pillar of Rachel's grave unto this day. ");
INSERT INTO engylt_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","And Israel journeyeth, and stretcheth out his tent beyond the tower of Edar; ");
INSERT INTO engylt_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","and it cometh to pass in Israel's dwelling in that land, that Reuben goeth, and lieth with Bilhah his father's concubine; and Israel heareth. ");
INSERT INTO engylt_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","And the sons of Jacob are twelve. Sons of Leah: Jacob's first-born Reuben, and Simeon, and Levi, and Judah, and Issachar, and Zebulun. ");
INSERT INTO engylt_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Sons of Rachel: Joseph and Benjamin. ");
INSERT INTO engylt_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","And sons of Bilhah, Rachel's maid-servant: Dan and Naphtali. ");
INSERT INTO engylt_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","And sons of Zilpah, Leah's maid-servant: Gad and Asher. These are sons of Jacob, who have been born to him in Padan-Aram. ");
INSERT INTO engylt_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","And Jacob cometh unto Isaac his father, at Mamre, the city of Arba (which is Hebron), where Abraham and Isaac have sojourned. ");
INSERT INTO engylt_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","And the days of Isaac are a hundred and eighty years, ");
INSERT INTO engylt_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","and Isaac expireth, and dieth, and is gathered unto his people, aged and satisfied with days; and bury him do Esau and Jacob his sons. ");
INSERT INTO engylt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","And these are births of Esau, who is Edom. ");
INSERT INTO engylt_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau hath taken his wives from the daughters of Canaan: Adah daughter of Elon the Hittite, and Aholibamah daughter of Anah, daughter of Zibeon the Hivite, ");
INSERT INTO engylt_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","and Bashemath daughter of Ishmael, sister of Nebajoth. ");
INSERT INTO engylt_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","And Adah beareth to Esau, Eliphaz; and Bashemath hath born Reuel; ");
INSERT INTO engylt_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","and Aholibamah hath born Jeush, and Jaalam, and Korah. These are sons of Esau, who were born to him in the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","And Esau taketh his wives, and his sons, and his daughters, and all the persons of his house, and his cattle, and all his beasts, and all his substance which he hath acquired in the land of Canaan, and goeth into the country from the face of Jacob his brother; ");
INSERT INTO engylt_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","for their substance was more abundant than to dwell together, and the land of their sojournings was not able to bear them because of their cattle; ");
INSERT INTO engylt_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","and Esau dwelleth in mount Seir: Esau is Edom. ");
INSERT INTO engylt_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","And these are births of Esau, father of Edom, in mount Seir. ");
INSERT INTO engylt_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These are the names of the sons of Esau: Eliphaz son of Adah, wife of Esau; Reuel son of Bashemath, wife of Esau. ");
INSERT INTO engylt_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","And the sons of Eliphaz are Teman, Omar, Zepho, and Gatam, and Kenaz; ");
INSERT INTO engylt_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","and Timnath hath been concubine to Eliphaz son of Esau, and she beareth to Eliphaz, Amalek; these are sons of Adah wife of Esau. ");
INSERT INTO engylt_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","And these are sons of Reuel: Nahath and Zerah, Shammah and Mizzah; these were sons of Bashemath wife of Esau. ");
INSERT INTO engylt_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","And these have been the sons of Aholibamah daughter of Anah, daughter of Zibeon, wife of Esau; and she beareth to Esau, Jeush and Jaalam and Korah. ");
INSERT INTO engylt_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These are chiefs of the sons of Esau: sons of Eliphaz, first-born of Esau: chief Teman, chief Omar, chief Zepho, chief Kenaz, ");
INSERT INTO engylt_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","chief Korah, chief Gatam, chief Amalek; these are chiefs of Eliphaz, in the land of Edom; these are sons of Adah. ");
INSERT INTO engylt_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","And these are sons of Reuel son of Esau: chief Nahath, chief Zerah, chief Shammah, chief Mizzah; these are chiefs of Reuel, in the land of Edom; these are sons of Bashemath wife of Esau. ");
INSERT INTO engylt_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","And these are sons of Aholibamah wife of Esau: chief Jeush, chief Jaalam, chief Korah; these are chiefs of Aholibamah daughter of Anah, wife of Esau. ");
INSERT INTO engylt_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These are sons of Esau (who is Edom), and these their chiefs. ");
INSERT INTO engylt_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These are sons of Seir the Horite, the inhabitants of the land: Lotan, and Shobal, and Zibeon, and Anah, ");
INSERT INTO engylt_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","and Dishon, and Ezer, and Dishan; these are chiefs of the Horites, sons of Seir, in the land of Edom. ");
INSERT INTO engylt_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","And the sons of Lotan are Hori and Heman; and a sister of Lotan is Timna. ");
INSERT INTO engylt_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","And these are sons of Shobal: Alvan and Manahath, and Ebal, Shepho and Onam. ");
INSERT INTO engylt_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","And these are sons of Zibeon, both Ajah and Anah: it is Anah that hath found the Imim in the wilderness, in his feeding the asses of Zibeon his father. ");
INSERT INTO engylt_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","And these are sons of Anah: Dishon, and Aholibamah daughter of Anah. ");
INSERT INTO engylt_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","And these are sons of Dishon: Hemdan, and Eshban, and Ithran, and Cheran. ");
INSERT INTO engylt_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These are sons of Ezer: Bilhan, and Zaavan, and Akan. ");
INSERT INTO engylt_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These are sons of Dishan: Uz and Aran. ");
INSERT INTO engylt_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are chiefs of the Horite: chief Lotan, chief Shobal, chief Zibeon, chief Anah, ");
INSERT INTO engylt_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","chief Dishon, chief Ezer, chief Dishan: these are chiefs of the Horite in reference to their chiefs in the land of Seir. ");
INSERT INTO engylt_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","And these are the kings who have reigned in the land of Edom before the reigning of a king over the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","And Bela son of Beor reigneth in Edom, and the name of his city is Dinhabah; ");
INSERT INTO engylt_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","and Bela dieth, and reign in his stead doth Jobab son of Zerah from Bozrah; ");
INSERT INTO engylt_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","and Jobab dieth, and reign in his stead doth Husham from the land of the Temanite. ");
INSERT INTO engylt_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","And Husham dieth, and reign in his stead doth Hadad son of Bedad (who smiteth Midian in the field of Moab), and the name of his city is Avith; ");
INSERT INTO engylt_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","and Hadad dieth, and reign in his stead doth Samlah of Masrekah; ");
INSERT INTO engylt_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","and Samlah dieth, and reign in his stead doth Saul from Rehoboth of the River; ");
INSERT INTO engylt_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","and Saul dieth, and reign in his stead doth Baal-hanan son of Achbor; ");
INSERT INTO engylt_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","and Baal-hanan son of Achbor dieth, and reign in his stead doth Hadar, and the name of his city is Pau; and his wife's name is Mehetabel daughter of Matred, daughter of Me-zahab. ");
INSERT INTO engylt_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","And these are the names of the chiefs of Esau, according to their families, according to their places, by their names: chief Timnah, chief Alvah, chief Jetheth, ");
INSERT INTO engylt_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","chief Aholibamah, chief Elah, chief Pinon, ");
INSERT INTO engylt_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","chief Kenaz, chief Teman, chief Mibzar, ");
INSERT INTO engylt_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","chief Magdiel, chief Iram: these are chiefs of Edom, in reference to their dwellings, in the land of their possession; he is Esau father of Edom. ");
INSERT INTO engylt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","And Jacob dwelleth in the land of his father's sojournings — in the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","These are births of Jacob: Joseph, a son of seventeen years, hath been enjoying himself with his brethren among the flock, (and he is a youth,) with the sons of Bilhah, and with the sons of Zilpah, his father's wives, and Joseph bringeth in an account of their evil unto their father. ");
INSERT INTO engylt_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","And Israel hath loved Joseph more than any of his sons, for he is a son of his old age, and hath made for him a long coat; ");
INSERT INTO engylt_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","and his brethren see that their father hath loved him more than any of his brethren, and they hate him, and have not been able to speak to him peaceably. ");
INSERT INTO engylt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","And Joseph dreameth a dream, and declareth to his brethren, and they add still more to hate him. ");
INSERT INTO engylt_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","And he saith unto them, 'Hear ye, I pray you, this dream which I have dreamed: ");
INSERT INTO engylt_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","that, lo, we are binding bundles in the midst of the field, and lo, my bundle hath arisen, and hath also stood up, and lo, your bundles are round about, and bow themselves to my bundle.' ");
INSERT INTO engylt_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","And his brethren say to him, 'Dost thou certainly reign over us? dost thou certainly rule over us?' and they add still more to hate him, for his dreams, and for his words. ");
INSERT INTO engylt_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","And he dreameth yet another dream, and recounteth it to his brethren, and saith, 'Lo, I have dreamed a dream again, and lo, the sun and the moon, and eleven stars, are bowing themselves to me.' ");
INSERT INTO engylt_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","And he recounteth unto his father, and unto his brethren; and his father pusheth against him, and saith to him, 'What is this dream which thou hast dreamt? do we certainly come — I, and thy mother, and thy brethren — to bow ourselves to thee, to the earth?' ");
INSERT INTO engylt_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","and his brethren are zealous against him, and his father hath watched the matter. ");
INSERT INTO engylt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","And his brethren go to feed the flock of their father in Shechem, ");
INSERT INTO engylt_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","and Israel saith unto Joseph, 'Are not thy brethren feeding in Shechem? come, and I send thee unto them;' and he saith to him, 'Here am I;' ");
INSERT INTO engylt_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","and he saith to him, 'Go, I pray thee, see the peace of thy brethren, and the peace of the flock, and bring me back word;' and he sendeth him from the valley of Hebron, and he cometh to Shechem. ");
INSERT INTO engylt_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","And a man findeth him, and lo, he is wandering in the field, and the man asketh him, saying, 'What seekest thou?' ");
INSERT INTO engylt_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","and he saith, 'My brethren I am seeking, declare to me, I pray thee, where they are feeding?' ");
INSERT INTO engylt_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","And the man saith, 'They have journeyed from this, for I have heard some saying, Let us go to Dothan,' and Joseph goeth after his brethren, and findeth them in Dothan. ");
INSERT INTO engylt_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","And they see him from afar, even before he draweth near unto them, and they conspire against him to put him to death. ");
INSERT INTO engylt_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","And they say one unto another, 'Lo, this man of the dreams cometh; ");
INSERT INTO engylt_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","and now, come, and we slay him, and cast him into one of the pits, and have said, An evil beast hath devoured him; and we see what his dreams are.' ");
INSERT INTO engylt_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","And Reuben heareth, and delivereth him out of their hand, and saith, 'Let us not smite the life;' ");
INSERT INTO engylt_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","and Reuben saith unto them, 'Shed no blood; cast him into this pit which is in the wilderness, and put not forth a hand upon him,' — in order to deliver him out of their hand, to bring him back unto his father. ");
INSERT INTO engylt_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","And it cometh to pass, when Joseph hath come unto his brethren, that they strip Joseph of his coat, the long coat which is upon him, ");
INSERT INTO engylt_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","and take him and cast him into the pit, and the pit is empty, there is no water in it. ");
INSERT INTO engylt_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","And they sit down to eat bread, and they lift up their eyes, and look, and lo, a company of Ishmaelites coming from Gilead, and their camels bearing spices, and balm, and myrrh, going to take them down to Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","And Judah saith unto his brethren, 'What gain when we slay our brother, and have concealed his blood? ");
INSERT INTO engylt_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, and we sell him to the Ishmaelites, and our hands are not on him, for he is our brother — our flesh;' and his brethren hearken. ");
INSERT INTO engylt_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","And Midianite merchantmen pass by and they draw out and bring up Joseph out of the pit, and sell Joseph to the Ishmaelites for twenty silverlings, and they bring Joseph into Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","And Reuben returneth unto the pit, and lo, Joseph is not in the pit, and he rendeth his garments, ");
INSERT INTO engylt_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","and he returneth unto his brethren, and saith, 'The lad is not, and I — whither am I going?' ");
INSERT INTO engylt_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","And they take the coat of Joseph, and slaughter a kid of the goats, and dip the coat in the blood, ");
INSERT INTO engylt_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","and send the long coat, and they bring it in unto their father, and say, 'This have we found; discern, we pray thee, whether it is thy son's coat or not?' ");
INSERT INTO engylt_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","And he discerneth it, and saith, 'My son's coat! an evil beast hath devoured him; torn — torn is Joseph!' ");
INSERT INTO engylt_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","And Jacob rendeth his raiment, and putteth sackcloth on his loins, and becometh a mourner for his son many days, ");
INSERT INTO engylt_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","and all his sons and all his daughters rise to comfort him, and he refuseth to comfort himself, and saith, 'For — I go down mourning unto my son, to Sheol,' and his father weepeth for him. ");
INSERT INTO engylt_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","And the Medanites have sold him unto Egypt, to Potiphar, a eunuch of Pharaoh, head of the executioners. ");
INSERT INTO engylt_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","And it cometh to pass, at that time, that Judah goeth down from his brethren, and turneth aside unto a man, an Adullamite, whose name is Hirah; ");
INSERT INTO engylt_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","and Judah seeth there the daughter of a man, a Canaanite, whose name is Shuah, and taketh her, and goeth in unto her. ");
INSERT INTO engylt_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","And she conceiveth, and beareth a son, and he calleth his name Er; ");
INSERT INTO engylt_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","and she conceiveth again, and beareth a son, and calleth his name Onan; ");
INSERT INTO engylt_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","and she addeth again, and beareth a son, and calleth his name Shelah; and he was in Chezib in her bearing him. ");
INSERT INTO engylt_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","And Judah taketh a wife for Er, his first-born, and her name is Tamar; ");
INSERT INTO engylt_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","and Er, Judah's first-born, is evil in the eyes of Jehovah, and Jehovah doth put him to death. ");
INSERT INTO engylt_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","And Judah saith to Onan, 'Go in unto the wife of thy brother, and marry her, and raise up seed to thy brother;' ");
INSERT INTO engylt_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","and Onan knoweth that the seed is not reckoned his; and it hath come to pass, if he hath gone in unto his brother's wife, that he hath destroyed it to the earth, so as not to give seed to his brother; ");
INSERT INTO engylt_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","and that which he hath done is evil in the eyes of Jehovah, and He putteth him also to death. ");
INSERT INTO engylt_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","And Judah saith to Tamar his daughter-in-law, 'Abide a widow at thy father's house, till Shelah my son groweth up;' for he said, 'Lest he die — even he — like his brethren;' and Tamar goeth and dwelleth at her father's house. ");
INSERT INTO engylt_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","And the days are multiplied, and the daughter of Shuah, Judah's wife, dieth; and Judah is comforted, and goeth up unto his sheep-shearers, he and Hirah his friend the Adullamite, to Timnath. ");
INSERT INTO engylt_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","And it is declared to Tamar, saying, 'Lo, thy husband's father is going up to Timnath to shear his flock;' ");
INSERT INTO engylt_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","and she turneth aside the garments of her widowhood from off her, and covereth herself with a vail, and wrappeth herself up, and sitteth in the opening of Enayim, which is by the way to Timnath, for she hath seen that Shelah hath grown up, and she hath not been given to him for a wife. ");
INSERT INTO engylt_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","And Judah seeth her, and reckoneth her for a harlot, for she hath covered her face, ");
INSERT INTO engylt_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","and he turneth aside unto her by the way, and saith, 'Come, I pray thee, let me come in unto thee,' (for he hath not known that she is his daughter-in-law); and she saith, 'What dost thou give to me, that thou mayest come in unto me?' ");
INSERT INTO engylt_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","and he saith, 'I — I send a kid of the goats from the flock.' And she saith, 'Dost thou give a pledge till thou send it?' ");
INSERT INTO engylt_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","and he saith, 'What is the pledge that I give to thee?' and she saith, 'Thy seal, and thy ribbon, and thy staff which is in thy hand;' and he giveth to her, and goeth in unto her, and she conceiveth to him; ");
INSERT INTO engylt_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","and she riseth, and goeth, and turneth aside her vail from off her, and putteth on the garments of her widowhood. ");
INSERT INTO engylt_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","And Judah sendeth the kid of the goats by the hand of his friend the Adullamite, to receive the pledge from the hand of the woman, and he hath not found her. ");
INSERT INTO engylt_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","And he asketh the men of her place, saying, 'Where is the separated one — she in Enayim, by the way?' and they say, 'There hath not been in this place a separated one.' ");
INSERT INTO engylt_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","And he turneth back unto Judah, and saith, 'I have not found her; and the men of the place also have said, There hath not been in this place a separated one,' ");
INSERT INTO engylt_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","and Judah saith, 'Let her take to herself, lest we become despised; lo, I sent this kid, and thou hast not found her.' ");
INSERT INTO engylt_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","And it cometh to pass about three months after, that it is declared to Judah, saying, 'Tamar thy daughter-in-law hath committed fornication; and also, lo, she hath conceived by fornication:' and Judah saith, 'Bring her out — and she is burnt.' ");
INSERT INTO engylt_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","She is brought out, and she hath sent unto her husband's father, saying, 'To a man whose these are, I am pregnant;' and she saith, 'Discern, I pray thee, whose are these — the seal, and the ribbons, and the staff.' ");
INSERT INTO engylt_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","And Judah discerneth and saith, 'She hath been more righteous than I, because that I did not give her to Shelah my son;' and he hath not added to know her again. ");
INSERT INTO engylt_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","And it cometh to pass in the time of her bearing, that lo, twins are in her womb; ");
INSERT INTO engylt_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","and it cometh to pass in her bearing, that one giveth out a hand, and the midwife taketh and bindeth on his hand a scarlet thread, saying, 'This hath come out first.' ");
INSERT INTO engylt_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","And it cometh to pass as he draweth back his hand, that lo, his brother hath come out, and she saith, 'What! thou hast broken forth — on thee is the breach;' and he calleth his name Pharez; ");
INSERT INTO engylt_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","and afterwards hath his brother come out, on whose hand is the scarlet thread, and he calleth his name Zarah. ");
INSERT INTO engylt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","And Joseph hath been brought down to Egypt, and Potiphar, a eunuch of Pharaoh, head of the executioners, an Egyptian man, buyeth him out of the hands of the Ishmaelites who have brought him thither. ");
INSERT INTO engylt_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","And Jehovah is with Joseph, and he is a prosperous man, and he is in the house of his lord the Egyptian, ");
INSERT INTO engylt_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","and his lord seeth that Jehovah is with him, and all that he is doing Jehovah is causing to prosper in his hand, ");
INSERT INTO engylt_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","and Joseph findeth grace in his eyes and serveth him, and he appointeth him over his house, and all that he hath he hath given into his hand. ");
INSERT INTO engylt_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","And it cometh to pass from the time that he hath appointed him over his house, and over all that he hath, that Jehovah blesseth the house of the Egyptian for Joseph's sake, and the blessing of Jehovah is on all that he hath, in the house, and in the field; ");
INSERT INTO engylt_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","and he leaveth all that he hath in the hand of Joseph, and he hath not known anything that he hath, except the bread which he is eating. And Joseph is of a fair form, and of a fair appearance. ");
INSERT INTO engylt_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","And it cometh to pass after these things, that his lord's wife lifteth up her eyes unto Joseph, and saith, 'Lie with me;' ");
INSERT INTO engylt_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","and he refuseth, and saith unto his lord's wife, 'Lo, my lord hath not known what is with me in the house, and all that he hath he hath given into my hand; ");
INSERT INTO engylt_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","none is greater in this house than I, and he hath not withheld from me anything, except thee, because thou art his wife; and how shall I do this great evil? — then have I sinned against God.' ");
INSERT INTO engylt_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","And it cometh to pass at her speaking unto Joseph day by day, that he hath not hearkened unto her, to lie near her, to be with her; ");
INSERT INTO engylt_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","and it cometh to pass about this day, that he goeth into the house to do his work, and there is none of the men of the house there in the house, ");
INSERT INTO engylt_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","and she catcheth him by his garment, saying, 'Lie with me;' and he leaveth his garment in her hand, and fleeth, and goeth without. ");
INSERT INTO engylt_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","And it cometh to pass when she seeth that he hath left his garment in her hand, and fleeth without, ");
INSERT INTO engylt_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","that she calleth for the men of her house, and speaketh to them, saying, 'See, he hath brought in to us a man, a Hebrew, to play with us; he hath come in unto me, to lie with me, and I call with a loud voice, ");
INSERT INTO engylt_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","and it cometh to pass, when he heareth that I have lifted up my voice and call, that he leaveth his garment near me, and fleeth, and goeth without.' ");
INSERT INTO engylt_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","And she placeth his garment near her, until the coming in of his lord unto his house. ");
INSERT INTO engylt_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","And she speaketh unto him according to these words, saying, 'The Hebrew servant whom thou hast brought unto us, hath come in unto me to play with me; ");
INSERT INTO engylt_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","and it cometh to pass, when I lift my voice and call, that he leaveth his garment near me, and fleeth without.' ");
INSERT INTO engylt_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","And it cometh to pass when his lord heareth the words of his wife, which she hath spoken unto him, saying, 'According to these things hath thy servant done to me,' that his anger burneth; ");
INSERT INTO engylt_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","and Joseph's lord taketh him, and putteth him unto the round-house, a place where the king's prisoners are bound; and he is there in the round-house. ");
INSERT INTO engylt_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","And Jehovah is with Joseph, and stretcheth out kindness unto him, and putteth his grace in the eyes of the chief of the round-house; ");
INSERT INTO engylt_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","and the chief of the round-house giveth into the hand of Joseph all the prisoners who are in the round-house, and of all that they are doing there, he hath been doer; ");
INSERT INTO engylt_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","the chief of the round-house seeth not anything under his hand, because Jehovah is with him, and that which he is doing Jehovah is causing to prosper. ");
INSERT INTO engylt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","And it cometh to pass, after these things — the butler of the king of Egypt and the baker have sinned against their lord, against the king of Egypt; ");
INSERT INTO engylt_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","and Pharaoh is wroth against his two eunuchs, against the chief of the butlers, and against the chief of the bakers, ");
INSERT INTO engylt_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","and giveth them in charge in the house of the chief of the executioners, unto the round-house, the place where Joseph is a prisoner, ");
INSERT INTO engylt_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","and the chief of the executioners chargeth Joseph with them, and he serveth them; and they are days in charge. ");
INSERT INTO engylt_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","And they dream a dream both of them, each his dream in one night, each according to the interpretation of his dream, the butler and the baker whom the king of Egypt hath, who are prisoners in the round-house. ");
INSERT INTO engylt_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","And Joseph cometh in unto them in the morning, and seeth them, and lo, they are morose; ");
INSERT INTO engylt_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","and he asketh Pharaoh's eunuchs who are with him in charge in the house of his lord, saying, 'Wherefore are your faces sad to-day?' ");
INSERT INTO engylt_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","And they say unto him, 'A dream we have dreamed, and there is no interpreter of it;' and Joseph saith unto them, 'Are not interpretations with God? recount, I pray you, to me.' ");
INSERT INTO engylt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","And the chief of the butlers recounteth his dream to Joseph, and saith to him, 'In my dream, then lo, a vine is before me! ");
INSERT INTO engylt_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","and in the vine are three branches, and it is as it were flourishing; gone up hath its blossom, its clusters have ripened grapes; ");
INSERT INTO engylt_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","and Pharaoh's cup is in my hand, and I take the grapes and press them into the cup of Pharaoh, and I give the cup into the hand of Pharaoh.' ");
INSERT INTO engylt_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","And Joseph saith to him, 'This is its interpretation: the three branches are three days; ");
INSERT INTO engylt_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","yet, within three days doth Pharaoh lift up thy head, and hath put thee back on thy station, and thou hast given the cup of Pharaoh into his hand, according to the former custom when thou wast his butler. ");
INSERT INTO engylt_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","'Surely if thou hast remembered me with thee, when it is well with thee, and hast done (I pray thee) kindness with me, and hast made mention of me unto Pharaoh, then hast thou brought me out from this house, ");
INSERT INTO engylt_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","for I was really stolen from the land of the Hebrews; and here also have I done nothing that they have put me in the pit.' ");
INSERT INTO engylt_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","And the chief of the bakers seeth that he hath interpreted good, and he saith unto Joseph, 'I also am in a dream, and lo, three baskets of white bread are on my head, ");
INSERT INTO engylt_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","and in the uppermost basket are of all kinds of Pharaoh's food, work of a baker; and the birds are eating them out of the basket, from off my head.' ");
INSERT INTO engylt_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","And Joseph answereth and saith, 'This is its interpretation: the three baskets are three days; ");
INSERT INTO engylt_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","yet, within three days doth Pharaoh lift up thy head from off thee, and hath hanged thee on a tree, and the birds have eaten thy flesh from off thee.' ");
INSERT INTO engylt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","And it cometh to pass, on the third day, Pharaoh's birthday, that he maketh a banquet to all his servants, and lifteth up the head of the chief of the butlers, and the head of the chief of the bakers among his servants, ");
INSERT INTO engylt_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","and he putteth back the chief of the butlers to his butlership, and he giveth the cup into the hand of Pharaoh; ");
INSERT INTO engylt_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","and the chief of the bakers he hath hanged, as Joseph hath interpreted to them; ");
INSERT INTO engylt_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","and the chief of the butlers hath not remembered Joseph, but forgetteth him. ");
INSERT INTO engylt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","And it cometh to pass, at the end of two years of days that Pharaoh is dreaming, and lo, he is standing by the River, ");
INSERT INTO engylt_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","and lo, from the River coming up are seven kine, of fair appearance, and fat in flesh, and they feed among the reeds; ");
INSERT INTO engylt_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","and lo, seven other kine are coming up after them out of the River, of bad appearance, and lean in flesh, and they stand near the kine on the edge of the River, ");
INSERT INTO engylt_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","and the kine of bad appearance and lean in flesh eat up the seven kine of fair appearance, and fat — and Pharaoh awaketh. ");
INSERT INTO engylt_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","And he sleepeth, and dreameth a second time, and lo, seven ears are coming up on one stalk, fat and good, ");
INSERT INTO engylt_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","and lo, seven ears, thin, and blasted with an east wind, are springing up after them; ");
INSERT INTO engylt_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","and the thin ears swallow the seven fat and full ears — and Pharaoh awaketh, and lo, a dream. ");
INSERT INTO engylt_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","And it cometh to pass in the morning, that his spirit is moved, and he sendeth and calleth all the scribes of Egypt, and all its wise men, and Pharaoh recounteth to them his dream, and there is no interpreter of them to Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","And the chief of the butlers speaketh with Pharaoh, saying, 'My sin I mention this day: ");
INSERT INTO engylt_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh hath been wroth against his servants, and giveth me into charge in the house of the chief of the executioners, me and the chief of the bakers; ");
INSERT INTO engylt_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","and we dream a dream in one night, I and he, each according to the interpretation of his dream we have dreamed. ");
INSERT INTO engylt_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","And there is with us a youth, a Hebrew, servant to the chief of the executioners, and we recount to him, and he interpreteth to us our dreams, to each according to his dream hath he interpreted, ");
INSERT INTO engylt_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","and it cometh to pass, as he hath interpreted to us so it hath been, me he put back on my station, and him he hanged.' ");
INSERT INTO engylt_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","And Pharaoh sendeth and calleth Joseph, and they cause him to run out of the pit, and he shaveth, and changeth his garments, and cometh in unto Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","And Pharaoh saith unto Joseph, 'A dream I have dreamed, and there is no interpreter of it, and I — I have heard concerning thee, saying, Thou understandest a dream to interpret it,' ");
INSERT INTO engylt_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","and Joseph answereth Pharaoh, saying, 'Without me — God doth answer Pharaoh with peace.' ");
INSERT INTO engylt_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","And Pharaoh speaketh unto Joseph: 'In my dream, lo, I am standing by the edge of the River, ");
INSERT INTO engylt_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","and lo, out of the River coming up are seven kine, fat in flesh, and of fair form, and they feed among the reeds; ");
INSERT INTO engylt_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","and lo, seven other kine are coming up after them, thin, and of very bad form, and lean in flesh; I have not seen like these in all the land of Egypt for badness. ");
INSERT INTO engylt_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","'And the lean and the bad kine eat up the first seven fat kine, ");
INSERT INTO engylt_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","and they come in unto their midst, and it hath not been known that they have come in unto their midst, and their appearance is bad as at the commencement; and I awake. ");
INSERT INTO engylt_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","'And I see in my dream, and lo, seven ears are coming up on one stalk, full and good; ");
INSERT INTO engylt_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","and lo, seven ears, withered, thin, blasted with an east wind, are springing up after them; ");
INSERT INTO engylt_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","and the thin ears swallow the seven good ears; and I tell unto the scribes, and there is none declaring to me.' ");
INSERT INTO engylt_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","And Joseph saith unto Pharaoh, 'The dream of Pharaoh is one: that which God is doing he hath declared to Pharaoh; ");
INSERT INTO engylt_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","the seven good kine are seven years, and the seven good ears are seven years, the dream is one; ");
INSERT INTO engylt_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","and the seven thin and bad kine which are coming up after them are seven years, and the seven empty ears, blasted with an east wind, are seven years of famine; ");
INSERT INTO engylt_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","this is the thing which I have spoken unto Pharaoh: That which God is doing, he hath shewn Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","'Lo, seven years are coming of great abundance in all the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","and seven years of famine have arisen after them, and all the plenty is forgotten in the land of Egypt, and the famine hath finished the land, ");
INSERT INTO engylt_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","and the plenty is not known in the land because of that famine afterwards, for it is very grievous. ");
INSERT INTO engylt_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","'And because of the repeating of the dream unto Pharaoh twice, surely the thing is established by God, and God is hastening to do it. ");
INSERT INTO engylt_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","'And now, let Pharaoh provide a man, intelligent and wise, and set him over the land of Egypt; ");
INSERT INTO engylt_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","let Pharaoh make and appoint overseers over the land, and receive a fifth of the land of Egypt in the seven years of plenty, ");
INSERT INTO engylt_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","and they gather all the food of these good years that are coming, and heap up corn under the hand of Pharaoh — food in the cities; and they have kept it, ");
INSERT INTO engylt_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","and the food hath been for a store for the land, for the seven years of famine which are in the land of Egypt; and the land is cut off by the famine.' ");
INSERT INTO engylt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","And the thing is good in the eyes of Pharaoh, and in the eyes of all his servants, ");
INSERT INTO engylt_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","and Pharaoh saith unto his servants, 'Do we find like this, a man in whom the spirit of God is?' ");
INSERT INTO engylt_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","and Pharaoh saith unto Joseph, 'After God's causing thee to know all this, there is none intelligent and wise as thou; ");
INSERT INTO engylt_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","thou — thou art over my house, and at thy mouth do all my people kiss; only in the throne I am greater than thou.' ");
INSERT INTO engylt_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","And Pharaoh saith unto Joseph, 'See, I have put thee over all the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","And Pharaoh turneth aside his seal-ring from off his hand, and putteth it on the hand of Joseph, and clotheth him with garments of fine linen, and placeth a chain of gold on his neck, ");
INSERT INTO engylt_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","and causeth him to ride in the second chariot which he hath, and they proclaim before him, 'Bow the knee!' and — to put him over all the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","And Pharaoh saith unto Joseph, 'I am Pharaoh, and without thee a man doth not lift up his hand and his foot in all the land of Egypt;' ");
INSERT INTO engylt_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","and Pharaoh calleth Joseph's name Zaphnath-Paaneah, and he giveth to him Asenath daughter of Poti-Pherah, priest of On, for a wife, and Joseph goeth out over the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","And Joseph is a son of thirty years in his standing before Pharaoh king of Egypt, and Joseph goeth out from the presence of Pharaoh, and passeth over through all the land of Egypt; ");
INSERT INTO engylt_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","and the land maketh in the seven years of plenty by handfuls. ");
INSERT INTO engylt_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","And he gathereth all the food of the seven years which have been in the land of Egypt, and putteth food in the cities; the food of the field which is round about each city hath he put in its midst; ");
INSERT INTO engylt_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","and Joseph gathereth corn as sand of the sea, multiplying exceedingly, until that he hath ceased to number, for there is no number. ");
INSERT INTO engylt_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","And to Joseph were born two sons before the year of famine cometh, whom Asenath daughter of Poti-Pherah, priest of On, hath borne to him, ");
INSERT INTO engylt_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","and Joseph calleth the name of the first-born Manasseh: 'for, God hath made me to forget all my labour, and all the house of my father;' ");
INSERT INTO engylt_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","and the name of the second he hath called Ephraim: 'for, God hath caused me to be fruitful in the land of mine affliction.' ");
INSERT INTO engylt_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","And the seven years of plenty are completed which have been in the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","and the seven years of famine begin to come, as Joseph said, and famine is in all the lands, but in all the land of Egypt hath been bread; ");
INSERT INTO engylt_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","and all the land of Egypt is famished, and the people crieth unto Pharaoh for bread, and Pharaoh saith to all the Egyptians, 'Go unto Joseph; that which he saith to you — do.' ");
INSERT INTO engylt_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","And the famine has been over all the face of the land, and Joseph openeth all places which have corn in them, and selleth to the Egyptians; and the famine is severe in the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","and all the earth hath come to Egypt, to buy, unto Joseph, for the famine was severe in all the earth. ");
INSERT INTO engylt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","And Jacob seeth that there is corn in Egypt, and Jacob saith to his sons, 'Why do you look at each other?' ");
INSERT INTO engylt_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","he saith also, 'Lo, I have heard that there is corn in Egypt, go down thither, and buy for us from thence, and we live and do not die;' ");
INSERT INTO engylt_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","and the ten brethren of Joseph go down to buy corn in Egypt, ");
INSERT INTO engylt_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","and Benjamin, Joseph's brother, Jacob hath not sent with his brethren, for he said, 'Lest mischief meet him.' ");
INSERT INTO engylt_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","And the sons of Israel come to buy in the midst of those coming, for the famine hath been in the land of Canaan, ");
INSERT INTO engylt_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","and Joseph is the ruler over the land, he who is selling to all the people of the land, and Joseph's brethren come and bow themselves to him — face to the earth. ");
INSERT INTO engylt_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","And Joseph seeth his brethren, and discerneth them, and maketh himself strange unto them, and speaketh with them sharp things, and saith unto them, 'From whence have ye come?' and they say, 'From the land of Canaan — to buy food.' ");
INSERT INTO engylt_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","And Joseph discerneth his brethren, but they have not discerned him, ");
INSERT INTO engylt_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","and Joseph remembereth the dreams which he dreamed of them, and saith unto them, 'Ye are spies; to see the nakedness of the land ye have come.' ");
INSERT INTO engylt_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","And they say unto him, 'No, my lord, but thy servants have come to buy food; ");
INSERT INTO engylt_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","we are all of us sons of one man, we are right men; thy servants have not been spies;' ");
INSERT INTO engylt_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","and he saith unto them, 'No, but the nakedness of the land ye have come to see;' ");
INSERT INTO engylt_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","and they say, 'Thy servants are twelve brethren; we are sons of one man in the land of Canaan, and lo, the young one is with our father to-day, and the one is not.' ");
INSERT INTO engylt_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","And Joseph saith unto them, 'This is that which I have spoken unto you, saying, Ye are spies, ");
INSERT INTO engylt_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","by this ye are proved: Pharaoh liveth! if ye go out from this — except by your young brother coming hither; ");
INSERT INTO engylt_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","send one of you, and let him bring your brother, and ye, remain ye bound, and let your words be proved, whether truth be with you: and if not — Pharaoh liveth! surely ye are spies;' ");
INSERT INTO engylt_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","and he removeth them unto charge three days. ");
INSERT INTO engylt_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","And Joseph saith unto them on the third day, 'This do and live; God I fear! ");
INSERT INTO engylt_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","if ye are right men, let one of your brethren be bound in the house of your ward, and ye, go, carry in corn for the famine of your houses, ");
INSERT INTO engylt_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","and your young brother ye bring unto me, and your words are established, and ye die not;' and they do so. ");
INSERT INTO engylt_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","And they say one unto another, 'Verily we are guilty concerning our brother, because we saw the distress of his soul, in his making supplication unto us, and we did not hearken: therefore hath this distress come upon us.' ");
INSERT INTO engylt_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","And Reuben answereth them, saying, 'Spake I not unto you, saying, Sin not against the lad? and ye hearkened not; and his blood also, lo, it is required.' ");
INSERT INTO engylt_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","And they have not known that Joseph understandeth, for the interpreter is between them; ");
INSERT INTO engylt_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","and he turneth round from them, and weepeth, and turneth back unto them, and speaketh unto them, and taketh from them Simeon, and bindeth him before their eyes. ");
INSERT INTO engylt_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","And Joseph commandeth, and they fill their vessels with corn, also to put back the money of each unto his sack, and to give to them provision for the way; and one doth to them so. ");
INSERT INTO engylt_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","And they lift up their corn upon their asses, and go from thence, ");
INSERT INTO engylt_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","and the one openeth his sack to give provender to his ass at a lodging-place, and he seeth his money, and lo, it is in the mouth of his bag, ");
INSERT INTO engylt_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","and he saith unto his brethren, 'My money hath been put back, and also, lo, in my bag:' and their heart goeth out, and they tremble, one to another saying, 'What is this God hath done to us!' ");
INSERT INTO engylt_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","And they come in unto Jacob their father, to the land of Canaan, and they declare to him all the things meeting them, saying, ");
INSERT INTO engylt_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","'The man, the lord of the land, hath spoken with us sharp things, and maketh us as spies of the land; ");
INSERT INTO engylt_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","and we say unto him, We are right men, we have not been spies, ");
INSERT INTO engylt_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","we are twelve brethren, sons of our father, the one is not, and the young one is to-day with our father in the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","'And the man, the lord of the land, saith unto us, By this I know that ye are right men — one of your brethren leave with me, and for the famine of your houses take ye and go, ");
INSERT INTO engylt_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","and bring your young brother unto me, and I know that ye are not spies, but ye are right men; your brother I give to you, and ye trade with the land.' ");
INSERT INTO engylt_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","And it cometh to pass, they are emptying their sacks, and lo, the bundle of each man's silver is in his sack, and they see their bundles of silver, they and their father, and are afraid; ");
INSERT INTO engylt_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","and Jacob their father saith unto them, 'Me ye have bereaved; Joseph is not, and Simeon is not, and Benjamin ye take — against me have been all these.' ");
INSERT INTO engylt_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","And Reuben speaketh unto his father, saying, 'My two sons thou dost put to death, if I bring him not in unto thee; give him into my hand, and I — I bring him back unto thee;' ");
INSERT INTO engylt_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","and he saith, 'My son doth not go down with you, for his brother is dead, and he by himself is left; when mischief hath met him in the way in which ye go, then ye have brought down my grey hairs in sorrow to sheol.' ");
INSERT INTO engylt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","And the famine is severe in the land; ");
INSERT INTO engylt_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","and it cometh to pass, when they have finished eating the corn which they brought from Egypt, that their father saith unto them, 'Turn back, buy for us a little food.' ");
INSERT INTO engylt_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","And Judah speaketh unto him, saying, 'The man protesting protested to us, saying, Ye do not see my face without your brother being with you; ");
INSERT INTO engylt_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","if thou art sending our brother with us, we go down, and buy for thee food, ");
INSERT INTO engylt_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","and if thou art not sending — we do not go down, for the man said unto us, Ye do not see my face without your brother being with you.' ");
INSERT INTO engylt_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","And Israel saith, 'Why did ye evil to me, by declaring to the man that ye had yet a brother?' ");
INSERT INTO engylt_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","and they say, 'The man asked diligently concerning us, and concerning our kindred, saying, Is your father yet alive? have ye a brother? and we declare to him according to the tenor of these things; do we certainly know that he will say, Bring down your brother?' ");
INSERT INTO engylt_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","And Judah saith unto Israel his father, 'Send the youth with me, and we arise, and go, and live, and do not die, both we, and thou, and our infants. ");
INSERT INTO engylt_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I — I am surety for him, from my hand thou dost require him; if I have not brought him in unto thee, and set him before thee — then I have sinned against thee all the days; ");
INSERT INTO engylt_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","for if we had not lingered, surely now we had returned these two times.' ");
INSERT INTO engylt_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","And Israel their father saith unto them, 'If so, now, this do: take of the praised thing of the land in your vessels, and take down to the man a present, a little balm, and a little honey, spices and myrrh, nuts and almonds; ");
INSERT INTO engylt_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","and double money take in your hand, even the money which is brought back in the mouth of your bags, ye take back in your hand, it may be it is an oversight. ");
INSERT INTO engylt_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","'And take your brother, and rise, turn back unto the man; ");
INSERT INTO engylt_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","and God Almighty give to you mercies before the man, so that he hath sent to you your other brother and Benjamin; and I, when I am bereaved — I am bereaved.' ");
INSERT INTO engylt_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","And the men take this present, double money also they have taken in their hand, and Benjamin; and they rise, and go down to Egypt, and stand before Joseph; ");
INSERT INTO engylt_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","and Joseph seeth Benjamin with them, and saith to him who is over his house, 'Bring the men into the house, and slaughter an animal, and make ready, for with me do the men eat at noon.' ");
INSERT INTO engylt_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","And the man doth as Joseph hath said, and the man bringeth in the men into the house of Joseph, ");
INSERT INTO engylt_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","and the men are afraid because they have been brought into the house of Joseph, and they say, 'For the matter of the money which was put back in our bags at the commencement are we brought in — to roll himself upon us, and to throw himself on us, and to take us for servants — our asses also.' ");
INSERT INTO engylt_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","And they come nigh unto the man who is over the house of Joseph, and speak unto him at the opening of the house, ");
INSERT INTO engylt_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","and say, 'O, my lord, we really come down at the commencement to buy food; ");
INSERT INTO engylt_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","and it cometh to pass, when we have come in unto the lodging-place, and open our bags, that lo, each one's money is in the mouth of his bag, our money in its weight, and we bring it back in our hand; ");
INSERT INTO engylt_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","and other money have we brought down in our hand to buy food; we have not known who put our money in our bags.' ");
INSERT INTO engylt_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","And he saith, 'Peace to you, fear not: your God and the God of your father hath given to you hidden treasure in your bags, your money came unto me;' and he bringeth out Simeon unto them. ");
INSERT INTO engylt_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","And the man bringeth in the men into Joseph's house, and giveth water, and they wash their feet; and he giveth provender for their asses, ");
INSERT INTO engylt_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","and they prepare the present until the coming of Joseph at noon, for they have heard that there they do eat bread. ");
INSERT INTO engylt_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","And Joseph cometh into the house, and they bring to him the present which is in their hand, into the house, and bow themselves to him, to the earth; ");
INSERT INTO engylt_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","and he asketh of them of peace, and saith, 'Is your father well? the aged man of whom ye have spoken, is he yet alive?' ");
INSERT INTO engylt_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","and they say, 'Thy servant our father is well, he is yet alive;' and they bow, and do obeisance. ");
INSERT INTO engylt_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","And he lifteth up his eyes, and seeth Benjamin his brother, his mother's son, and saith, 'Is this your young brother, of whom ye have spoken unto me?' and he saith, 'God favour thee, my son.' ");
INSERT INTO engylt_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","And Joseph hasteth, for his bowels have been moved for his brother, and he seeketh to weep, and entereth the inner chamber, and weepeth there; ");
INSERT INTO engylt_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","and he washeth his face, and goeth out, and refraineth himself, and saith, 'Place bread.' ");
INSERT INTO engylt_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","And they place for him by himself, and for them by themselves, and for the Egyptians who are eating with him by themselves: for the Egyptians are unable to eat bread with the Hebrews, for it is an abomination to the Egyptians. ");
INSERT INTO engylt_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","And they sit before him, the first-born according to his birthright, and the young one according to his youth, and the men wonder one at another; ");
INSERT INTO engylt_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","and he lifteth up gifts from before him unto them, and the gift of Benjamin is five hands more than the gifts of all of them; and they drink, yea, they drink abundantly with him. ");
INSERT INTO engylt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","And he commandeth him who is over his house, saying, 'Fill the bags of the men with food, as they are able to bear, and put the money of each in the mouth of his bag; ");
INSERT INTO engylt_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","and my cup, the silver cup, thou dost put in the mouth of the bag of the young one, and his corn-money;' and he doth according to the word of Joseph which he hath spoken. ");
INSERT INTO engylt_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","The morning is bright, and the men have been sent away, they and their asses — ");
INSERT INTO engylt_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","they have gone out of the city — they have not gone far off — and Joseph hath said to him who is over his house, 'Rise, pursue after the men; and thou hast overtaken them, and thou hast said unto them, Why have ye recompensed evil for good? ");
INSERT INTO engylt_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is not this that with which my lord drinketh? and he observeth diligently with it; ye have done evil in that which ye have done.' ");
INSERT INTO engylt_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","And he overtaketh them, and speaketh unto them these words, ");
INSERT INTO engylt_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","and they say unto him, 'Why doth my lord speak according to these words? far be it from thy servants to do according to this word; ");
INSERT INTO engylt_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","lo, the money which we found in the mouth of our bags we brought back unto thee from the land of Canaan, and how do we steal from the house of thy lord silver or gold? ");
INSERT INTO engylt_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","with whomsoever of thy servants it is found, he hath died, and we also are to my lord for servants.' ");
INSERT INTO engylt_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","And he saith, 'Now, also, according to your words, so it is; he with whom it is found becometh my servant, and ye are acquitted;' ");
INSERT INTO engylt_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","and they hasten and take down each his bag to the earth, and each openeth his bag; ");
INSERT INTO engylt_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","and he searcheth — at the eldest he hath begun, and at the youngest he hath completed — and the cup is found in the bag of Benjamin; ");
INSERT INTO engylt_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","and they rend their garments, and each ladeth his ass, and they turn back to the city. ");
INSERT INTO engylt_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","And Judah — his brethren also — cometh in unto the house of Joseph, and he is yet there, and they fall before him to the earth; ");
INSERT INTO engylt_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","and Joseph saith to them, 'What is this deed that ye have done? have ye not known that a man like me doth diligently observe?' ");
INSERT INTO engylt_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","And Judah saith, 'What do we say to my lord? what do we speak? and what — do we justify ourselves? God hath found out the iniquity of thy servants; lo, we are servants to my lord, both we, and he in whose hand the cup hath been found;' ");
INSERT INTO engylt_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","and he saith, 'Far be it from me to do this; the man in whose hand the cup hath been found, he becometh my servant; and ye, go ye up in peace unto your father.' ");
INSERT INTO engylt_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","And Judah cometh nigh unto him, and saith, 'O, my lord, let thy servant speak, I pray thee, a word in the ears of my lord, and let not thine anger burn against thy servant — for thou art as Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord hath asked his servants, saying, Have ye a father or brother? ");
INSERT INTO engylt_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","and we say unto my lord, We have a father, an aged one, and a child of old age, a little one; and his brother died, and he is left alone of his mother, and his father hath loved him. ");
INSERT INTO engylt_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","'And thou sayest unto thy servants, Bring him down unto me, and I set mine eye upon him; ");
INSERT INTO engylt_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","and we say unto my lord, The youth is not able to leave his father, when he hath left his father, then he hath died; ");
INSERT INTO engylt_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","and thou sayest unto thy servants, If your young brother come not down with you, ye add not to see my face. ");
INSERT INTO engylt_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","'And it cometh to pass, that we have come up unto thy servant my father, that we declare to him the words of my lord; ");
INSERT INTO engylt_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","and our father saith, Turn back, buy for us a little food, ");
INSERT INTO engylt_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","and we say, We are not able to go down; if our young brother is with us, then we have gone down; for we are not able to see the man's face, and our young brother not with us. ");
INSERT INTO engylt_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","'And thy servant my father saith unto us, Ye — ye have known that two did my wife bare to me, ");
INSERT INTO engylt_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","and the one goeth out from me, and I say, Surely he is torn — torn! and I have not seen him since; ");
INSERT INTO engylt_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","when ye have taken also this from my presence, and mischief hath met him, then ye have brought down my grey hairs with evil to sheol. ");
INSERT INTO engylt_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","'And now, at my coming in unto thy servant my father, and the youth not with us (and his soul is bound up in his soul), ");
INSERT INTO engylt_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","then it hath come to pass when he seeth that the youth is not, that he hath died, and thy servants have brought down the grey hairs of thy servant our father with sorrow to sheol; ");
INSERT INTO engylt_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","for thy servant obtained the youth by surety from my father, saying, If I bring him not in unto thee — then I have sinned against my father all the days. ");
INSERT INTO engylt_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","'And now, let thy servant, I pray thee, abide instead of the youth a servant to my lord, and the youth goeth up with his brethren, ");
INSERT INTO engylt_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","for how do I go up unto my father, and the youth not with me? lest I look on the evil which doth find my father.' ");
INSERT INTO engylt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","And Joseph hath not been able to refrain himself before all those standing by him, and he calleth, 'Put out every man from me;' and no man hath stood with him when Joseph maketh himself known unto his brethren, ");
INSERT INTO engylt_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","and he giveth forth his voice in weeping, and the Egyptians hear, and the house of Pharaoh heareth. ");
INSERT INTO engylt_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","And Joseph saith unto his brethren, 'I am Joseph, is my father yet alive?' and his brethren have not been able to answer him, for they have been troubled at his presence. ");
INSERT INTO engylt_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","And Joseph saith unto his brethren, 'Come nigh unto me, I pray you,' and they come nigh; and he saith, 'I am Joseph, your brother, whom ye sold into Egypt; ");
INSERT INTO engylt_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","and now, be not grieved, nor let it be displeasing in your eyes that ye sold me hither, for to preserve life hath God sent me before you. ");
INSERT INTO engylt_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","'Because these two years the famine is in the heart of the land, and yet are five years, in which there is neither ploughing nor harvest; ");
INSERT INTO engylt_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","and God sendeth me before you, to place of you a remnant in the land, and to give life to you by a great escape; ");
INSERT INTO engylt_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","and now, ye — ye have not sent me hither, but God, and He doth set me for a father to Pharaoh, and for lord to all his house, and ruler over all the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","'Haste, and go up unto my father, then ye have said to him, Thus said Joseph thy son, God hath set me for lord to all Egypt; come down unto me, stay not, ");
INSERT INTO engylt_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","and thou hast dwelt in the land of Goshen, and been near unto me, thou and thy sons, and thy son's sons, and thy flock, and thy herd, and all that thou hast, ");
INSERT INTO engylt_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","and I have nourished thee there — for yet are five years of famine — lest thou become poor, thou and thy household, and all that thou hast. ");
INSERT INTO engylt_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","'And lo, your eyes are seeing, and the eyes of my brother Benjamin, that it is my mouth which is speaking unto you; ");
INSERT INTO engylt_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","and ye have declared to my father all my honour in Egypt, and all that ye have seen, and ye have hasted, and have brought down my father hither.' ");
INSERT INTO engylt_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","And he falleth on the neck of Benjamin his brother, and weepeth, and Benjamin hath wept on his neck; ");
INSERT INTO engylt_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","and he kisseth all his brethren, and weepeth over them; and afterwards have his brethren spoken with him. ");
INSERT INTO engylt_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","And the sound hath been heard in the house of Pharaoh, saying, 'Come have the brethren of Joseph;' and it is good in the eyes of Pharaoh, and in the eyes of his servants, ");
INSERT INTO engylt_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","and Pharaoh saith unto Joseph, 'Say unto thy brethren, This do ye: lade your beasts, and go, enter ye the land of Canaan, ");
INSERT INTO engylt_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","and take your father, and your households, and come unto me, and I give to you the good of the land of Egypt, and eat ye the fat of the land. ");
INSERT INTO engylt_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","'Yea, thou — thou hast been commanded: this do ye, take for yourselves out of the land of Egypt, waggons for your infants, and for your wives, and ye have brought your father, and come; ");
INSERT INTO engylt_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","and your eye hath no pity on your vessels, for the good of all the land of Egypt is yours.' ");
INSERT INTO engylt_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","And the sons of Israel do so, and Joseph giveth waggons to them by the command of Pharaoh, and he giveth to them provision for the way; ");
INSERT INTO engylt_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","to all of them hath he given — to each changes of garments, and to Benjamin he hath given three hundred silverlings, and five changes of garments; ");
INSERT INTO engylt_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","and to his father he hath sent thus: ten asses bearing of the good things of Egypt, and ten she-asses bearing corn and bread, even food for his father for the way. ");
INSERT INTO engylt_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","And he sendeth his brethren away, and they go; and he saith unto them, 'Be not angry in the way.' ");
INSERT INTO engylt_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","And they go up out of Egypt, and come in to the land of Canaan, unto Jacob their father, ");
INSERT INTO engylt_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","and they declare to him, saying, 'Joseph is yet alive,' and that he is ruler over all the land of Egypt; and his heart ceaseth, for he hath not given credence to them. ");
INSERT INTO engylt_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","And they speak unto him all the words of Joseph, which he hath spoken unto them, and he seeth the waggons which Joseph hath sent to bear him away, and live doth the spirit of Jacob their father; ");
INSERT INTO engylt_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","and Israel saith, 'Enough! Joseph my son is yet alive; I go and see him before I die.' ");
INSERT INTO engylt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","And Israel journeyeth, and all that he hath, and cometh in to Beer-Sheba, and sacrificeth sacrifices to the God of his father Isaac; ");
INSERT INTO engylt_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","and God speaketh to Israel in visions of the night, and saith, 'Jacob, Jacob;' and he saith, 'Here am I.' ");
INSERT INTO engylt_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","And He saith, 'I am God, God of thy father, be not afraid of going down to Egypt, for for a great nation I set thee there; ");
INSERT INTO engylt_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I — I go down with thee to Egypt, and I — I also certainly bring thee up, and Joseph doth put his hand on thine eyes.' ");
INSERT INTO engylt_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","And Jacob riseth from Beer-Sheba, and the sons of Israel bear away Jacob their father, And their infants, and their wives, in the waggons which Pharaoh hath sent to bear him, ");
INSERT INTO engylt_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","and they take their cattle, and their goods which they have acquired in the land of Canaan, and come into Egypt — Jacob, and all his seed with him, ");
INSERT INTO engylt_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","his sons, and his sons' sons with him, his daughters, and his sons' daughters, yea, all his seed he brought with him into Egypt. ");
INSERT INTO engylt_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","And these are the names of the sons of Israel who are coming into Egypt: Jacob and his sons, Jacob's first-born, Reuben. ");
INSERT INTO engylt_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","And sons of Reuben: Hanoch, and Phallu, and Hezron, and Carmi. ");
INSERT INTO engylt_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","And sons of Simeon: Jemuel, and Jamin, and Ohad, and Jachin, and Zohar, and Shaul son of the Canaanitess. ");
INSERT INTO engylt_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","And sons of Levi: Gershon, Kohath, and Merari. ");
INSERT INTO engylt_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","And sons of Judah: Er, and Onan, and Shelah, and Pharez, and Zarah, (and Er and Onan die in the land of Canaan.) And sons of Pharez are Hezron and Hamul. ");
INSERT INTO engylt_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","And sons of Issachar: Tola, and Phuvah, and Job, and Shimron. ");
INSERT INTO engylt_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","And sons of Zebulun: Sered, and Elon, and Jahleel. ");
INSERT INTO engylt_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These are sons of Leah whom she bare to Jacob in Padan-Aram, and Dinah his daughter; all the persons of his sons and his daughters are thirty and three. ");
INSERT INTO engylt_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","And sons of Gad: Ziphion, and Haggi, Shuni, and Ezbon, Eri, and Arodi, and Areli. ");
INSERT INTO engylt_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","And sons of Asher: Jimnah, and Ishuah, and Isui, and Beriah, and Serah their sister. And sons of Beriah: Heber and Malchiel. ");
INSERT INTO engylt_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are sons of Zilpah, whom Laban gave to Leah his daughter, and she beareth these to Jacob — sixteen persons. ");
INSERT INTO engylt_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Sons of Rachel, Jacob's wife: Joseph and Benjamin. ");
INSERT INTO engylt_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","And born to Joseph in the land of Egypt (whom Asenath daughter of Poti-Pherah, priest of On, hath borne to him) are Manasseh and Ephraim. ");
INSERT INTO engylt_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","And sons of Benjamin: Belah, and Becher, and Ashbel, Gera, and Naaman, Ehi, and Rosh, Muppim, and Huppim, and Ard. ");
INSERT INTO engylt_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These are sons of Rachel, who were born to Jacob; all the persons are fourteen. ");
INSERT INTO engylt_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","And sons of Dan: Hushim. ");
INSERT INTO engylt_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","And sons of Naphtali: Jahzeel, and Guni, and Jezer, and Shillem. ");
INSERT INTO engylt_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These are sons of Bilhah, whom Laban gave to Rachel his daughter; and she beareth these to Jacob — all the persons are seven. ");
INSERT INTO engylt_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All the persons who are coming to Jacob to Egypt, coming out of his thigh, apart from the wives of Jacob's sons, all the persons are sixty and six. ");
INSERT INTO engylt_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","And the sons of Joseph who have been born to him in Egypt are two persons. All the persons of the house of Jacob who are coming into Egypt are seventy. ");
INSERT INTO engylt_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","And Judah he hath sent before him unto Joseph, to direct before him to Goshen, and they come into the land of Goshen; ");
INSERT INTO engylt_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","and Joseph harnesseth his chariot, and goeth up to meet Israel his father, to Goshen, and appeareth unto him, and falleth on his neck, and weepeth on his neck again; ");
INSERT INTO engylt_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","and Israel saith unto Joseph, 'Let me die this time, after my seeing thy face, for thou art yet alive.' ");
INSERT INTO engylt_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","And Joseph saith unto his brethren, and unto the house of his father, 'I go up, and declare to Pharaoh, and say unto him, My brethren, and the house of my father who are in the land of Canaan have come in unto me; ");
INSERT INTO engylt_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","and the men are feeders of a flock, for they have been men of cattle; and their flock, and their herd, and all that they have, they have brought.' ");
INSERT INTO engylt_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","'And it hath come to pass when Pharaoh calleth for you, and hath said, What are your works? ");
INSERT INTO engylt_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","that ye have said, Thy servants have been men of cattle from our youth, even until now, both we and our fathers, — in order that ye may dwell in the land of Goshen, for the abomination of the Egyptians is every one feeding a flock.' ");
INSERT INTO engylt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","And Joseph cometh, and declareth to Pharaoh, and saith, 'My father, and my brethren, and their flock, and their herd, and all they have, have come from the land of Canaan, and lo, they are in the land of Goshen.' ");
INSERT INTO engylt_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","And out of his brethren he hath taken five men, and setteth them before Pharaoh; ");
INSERT INTO engylt_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","and Pharaoh saith unto his brethren, 'What are your works?' and they say unto Pharaoh, 'Thy servants are feeders of a flock, both we and our fathers;' ");
INSERT INTO engylt_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","and they say unto Pharaoh, 'To sojourn in the land we have come, for there is no pasture for the flock which thy servants have, for grievous is the famine in the land of Canaan; and now, let thy servants, we pray thee, dwell in the land of Goshen.' ");
INSERT INTO engylt_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","And Pharaoh speaketh unto Joseph, saying, 'Thy father and thy brethren have come unto thee: ");
INSERT INTO engylt_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","the land of Egypt is before thee; in the best of the land cause thy father and thy brethren to dwell — they dwell in the land of Goshen, and if thou hast known, and there are among them men of ability, then thou hast set them heads over the cattle I have.' ");
INSERT INTO engylt_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","And Joseph bringeth in Jacob his father, and causeth him to stand before Pharaoh; and Jacob blesseth Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","And Pharaoh saith unto Jacob, 'How many are the days of the years of thy life?' ");
INSERT INTO engylt_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","And Jacob saith unto Pharaoh, 'The days of the years of my sojournings are an hundred and thirty years; few and evil have been the days of the years of my life, and they have not reached the days of the years of the life of my fathers, in the days of their sojournings.' ");
INSERT INTO engylt_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","And Jacob blesseth Pharaoh, and goeth out from before Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","And Joseph settleth his father and his brethren, and giveth to them a possession in the land of Egypt, in the best of the land, in the land of Rameses, as Pharaoh commanded; ");
INSERT INTO engylt_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","and Joseph nourisheth his father, and his brethren, and all the house of his father with bread, according to the mouth of the infants. ");
INSERT INTO engylt_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","And there is no bread in all the land, for the famine is very grievous, and the land of Egypt and the land of Canaan are feeble because of the famine; ");
INSERT INTO engylt_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","and Joseph gathereth all the silver that is found in the land of Egypt, and in the land of Canaan, for the corn that they are buying, and Joseph bringeth the silver into the house of Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","And the silver is consumed out of the land of Egypt, and out of the land of Canaan, and all the Egyptians come in unto Joseph, saying, 'Give to us bread — why do we die before thee, though the money hath ceased?' ");
INSERT INTO engylt_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","and Joseph saith, 'Give your cattle; and I give to you for your cattle, if the money hath ceased.' ");
INSERT INTO engylt_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","And they bring in their cattle unto Joseph, and Joseph giveth to them bread, for the horses, and for the cattle of the flock, and for the cattle of the herd, and for the asses; and he tendeth them with bread, for all their cattle, during that year. ");
INSERT INTO engylt_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","And that year is finished, and they come in unto him on the second year, and say to him, 'We do not hide from my lord, that since the money hath been finished, and possession of the cattle is unto my lord, there hath not been left before my lord save our bodies, and our ground; ");
INSERT INTO engylt_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","why do we die before thine eyes, both we and our ground? buy us and our ground for bread, and we and our ground are servants to Pharaoh; and give seed, and we live, and die not, and the ground is not desolate.' ");
INSERT INTO engylt_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","And Joseph buyeth all the ground of Egypt for Pharaoh, for the Egyptians have sold each his field, for the famine hath been severe upon them, and the land becometh Pharaoh's; ");
INSERT INTO engylt_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","as to the people he hath removed them to cities from the one end of the border of Egypt even unto its other end. ");
INSERT INTO engylt_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Only the ground of the priests he hath not bought, for the priests have a portion from Pharaoh, and they have eaten their portion which Pharaoh hath given to them, therefore they have not sold their ground. ");
INSERT INTO engylt_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","And Joseph saith unto the people, 'Lo, I have bought you to-day and your ground for Pharaoh; lo, seed for you, and ye have sown the ground, ");
INSERT INTO engylt_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","and it hath come to pass in the increases, that ye have given a fifth to Pharaoh, and four of the parts are for yourselves, for seed of the field, and for your food, and for those who are in your houses, and for food for your infants.' ");
INSERT INTO engylt_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","And they say, 'Thou hast revived us; we find grace in the eyes of my lord, and have been servants to Pharaoh;' ");
INSERT INTO engylt_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","and Joseph setteth it for a statute unto this day, concerning the ground of Egypt, that Pharaoh hath a fifth; only the ground of the priests alone hath not become Pharaoh's. ");
INSERT INTO engylt_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","And Israel dwelleth in the land of Egypt, in the land of Goshen, and they have possession in it, and are fruitful, and multiply exceedingly; ");
INSERT INTO engylt_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","and Jacob liveth in the land of Egypt seventeen years, and the days of Jacob, the years of his life, are an hundred and forty and seven years. ");
INSERT INTO engylt_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","And the days of Israel are near to die, and he calleth for his son, for Joseph, and saith to him, 'If, I pray thee, I have found grace in thine eyes, put, I pray thee, thy hand under my thigh, and thou hast done with me kindness and truth; bury me not, I pray thee, in Egypt, ");
INSERT INTO engylt_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","and I have lain with my fathers, and thou hast borne me out of Egypt, and buried me in their burying-place.' And he saith, 'I — I do according to thy word;' ");
INSERT INTO engylt_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","and he saith, 'Swear to me;' and he sweareth to him, and Israel boweth himself on the head of the bed. ");
INSERT INTO engylt_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","And it cometh to pass, after these things, that one saith to Joseph, 'Lo, thy father is sick;' and he taketh his two sons with him, Manasseh and Ephraim. ");
INSERT INTO engylt_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","And one declareth to Jacob, and saith, 'Lo, thy son Joseph is coming unto thee;' and Israel doth strengthen himself, and sit upon the bed. ");
INSERT INTO engylt_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","And Jacob saith unto Joseph, 'God Almighty hath appeared unto me, in Luz, in the land of Canaan, and blesseth me, ");
INSERT INTO engylt_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","and saith unto me, Lo, I am making thee fruitful, and have multiplied thee, and given thee for an assembly of peoples, and given this land to thy seed after thee, a possession age-during. ");
INSERT INTO engylt_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","'And now, thy two sons, who are born to thee in the land of Egypt, before my coming unto thee to Egypt, mine they are; Ephraim and Manasseh, as Reuben and Simeon they are mine; ");
INSERT INTO engylt_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","and thy family which thou hast begotten after them are thine; by the name of their brethren they are called in their inheritance. ");
INSERT INTO engylt_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","'And I — in my coming in from Padan-Aram Rachel hath died by me in the land of Canaan, in the way, while yet a kibrath of land to enter Ephrata, and I bury her there in the way of Ephrata, which is Bethlehem.' ");
INSERT INTO engylt_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","And Israel seeth the sons of Joseph, and saith, 'Who are these?' ");
INSERT INTO engylt_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","and Joseph saith unto his father, 'They are my sons, whom God hath given to me in this place;' and he saith, 'Bring them, I pray thee, unto me, and I bless them.' ");
INSERT INTO engylt_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","And the eyes of Israel have been heavy from age, he is unable to see; and he bringeth them nigh unto him, and he kisseth them, and cleaveth to them; ");
INSERT INTO engylt_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","and Israel saith unto Joseph, 'To see thy face I had not thought, and lo, God hath shewed me also thy seed.' ");
INSERT INTO engylt_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","And Joseph bringeth them out from between his knees, and boweth himself on his face to the earth; ");
INSERT INTO engylt_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","and Joseph taketh them both, Ephraim in his right hand towards Israel's left, and Manasseh in his left towards Israel's right, and bringeth them nigh to him. ");
INSERT INTO engylt_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","And Israel putteth out his right hand, and placeth it upon the head of Ephraim, who is the younger, and his left hand upon the head of Manasseh; he hath guided his hands wisely, for Manasseh is the first-born. ");
INSERT INTO engylt_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","And he blesseth Joseph, and saith, 'God, before whom my fathers Abraham and Isaac walked habitually: God who is feeding me from my being unto this day: ");
INSERT INTO engylt_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","the Messenger who is redeeming me from all evil doth bless the youths, and my name is called upon them, and the name of my fathers Abraham and Isaac; and they increase into a multitude in the midst of the land.' ");
INSERT INTO engylt_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","And Joseph seeth that his father setteth his right hand on the head of Ephraim, and it is wrong in his eyes, and he supporteth the hand of his father to turn it aside from off the head of Ephraim to the head of Manasseh; ");
INSERT INTO engylt_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","and Joseph saith unto his father, 'Not so, my father, for this is the first-born; set thy right hand on his head.' ");
INSERT INTO engylt_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","And his father refuseth, and saith, 'I have known, my son, I have known; he also becometh a people, and he also is great, and yet, his young brother is greater than he, and his seed is the fulness of the nations;' ");
INSERT INTO engylt_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","and he blesseth them in that day, saying, 'By thee doth Israel bless, saying, God set thee as Ephraim and as Manasseh;' and he setteth Ephraim before Manasseh. ");
INSERT INTO engylt_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","And Israel saith unto Joseph, 'Lo, I am dying, and God hath been with you, and hath brought you back unto the land of your fathers; ");
INSERT INTO engylt_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","and I — I have given to thee one portion above thy brethren, which I have taken out of the hand of the Amorite by my sword and by my bow.' ");
INSERT INTO engylt_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","And Jacob calleth unto his sons and saith, 'Be gathered together, and I declare to you that which doth happen with you in the latter end of the days. ");
INSERT INTO engylt_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","'Be assembled, and hear, sons of Jacob, And hearken unto Israel your father. ");
INSERT INTO engylt_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben! my first-born thou, My power, and beginning of my strength, The abundance of exaltation, And the abundance of strength; ");
INSERT INTO engylt_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Unstable as water, thou art not abundant; For thou hast gone up thy father's bed; Then thou hast polluted: My couch he went up! ");
INSERT INTO engylt_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi are brethren! Instruments of violence — their espousals! ");
INSERT INTO engylt_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Into their secret, come not, O my soul! Unto their assembly be not united, O mine honour; For in their anger they slew a man, And in their self-will eradicated a prince. ");
INSERT INTO engylt_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cursed is their anger, for it is fierce, And their wrath, for it is sharp; I divide them in Jacob, And I scatter them in Israel. ");
INSERT INTO engylt_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah! thou — thy brethren praise thee! Thy hand is on the neck of thine enemies, Sons of thy father bow themselves to thee. ");
INSERT INTO engylt_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","A lion's whelp is Judah, For prey, my son, thou hast gone up; He hath bent, he hath crouched as a lion, And as a lioness; who causeth him to arise? ");
INSERT INTO engylt_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The sceptre turneth not aside from Judah, And a lawgiver from between his feet, Till his Seed come; And his is the obedience of peoples. ");
INSERT INTO engylt_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Binding to the vine his ass, And to the choice vine the colt of his ass, He hath washed in wine his clothing, And in the blood of grapes his covering; ");
INSERT INTO engylt_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Red are eyes with wine, And white are teeth with milk! ");
INSERT INTO engylt_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun at a haven of the seas doth dwell, And he is for a haven of ships; And his side is unto Zidon. ");
INSERT INTO engylt_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issacher is a strong ass, Crouching between the two folds; ");
INSERT INTO engylt_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","And he seeth rest that it is good, And the land that it is pleasant, And he inclineth his shoulder to bear, And is to tribute a servant. ");
INSERT INTO engylt_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan doth judge his people, As one of the tribes of Israel; ");
INSERT INTO engylt_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan is a serpent by the way, An adder by the path, Which is biting the horse's heels, And its rider falleth backward. ");
INSERT INTO engylt_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","For Thy salvation I have waited, Jehovah! ");
INSERT INTO engylt_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! a troop assaulteth him, But he assaulteth last. ");
INSERT INTO engylt_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Out of Asher his bread is fat; And he giveth dainties of a king. ");
INSERT INTO engylt_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a hind sent away, Who is giving beauteous young ones. ");
INSERT INTO engylt_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is a fruitful son; A fruitful son by a fountain, Daughters step over the wall; ");
INSERT INTO engylt_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","And embitter him — yea, they have striven, Yea, hate him do archers; ");
INSERT INTO engylt_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","And his bow abideth in strength, And strengthened are the arms of his hands By the hands of the Mighty One of Jacob, Whence is a shepherd, a son of Israel. ");
INSERT INTO engylt_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","By the God of thy father who helpeth thee, And the Mighty One who blesseth thee, Blessings of the heavens from above, Blessings of the deep lying under, Blessings of breasts and womb; — ");
INSERT INTO engylt_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Thy father's blessings have been mighty Above the blessings of my progenitors, Unto the limit of the heights age-during They are for the head of Joseph, And for the crown of the one Separate from his brethren. ");
INSERT INTO engylt_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin! a wolf teareth; In the morning he eateth prey, And at evening he apportioneth spoil.' ");
INSERT INTO engylt_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","All these are the twelve tribes of Israel, and this is that which their father hath spoken unto them, and he blesseth them; each according to his blessing he hath blessed them. ");
INSERT INTO engylt_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","And he commandeth them, and saith unto them, 'I am being gathered unto my people; bury me by my fathers, at the cave which is in the field of Ephron the Hittite; ");
INSERT INTO engylt_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in the cave which is in the field of Machpelah, which is on the front of Mamre, in the land of Canaan, which Abraham bought with the field from Ephron the Hittite for a possession of a burying-place; ");
INSERT INTO engylt_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","(there they buried Abraham and Sarah his wife; there they buried Isaac and Rebekah his wife; and there I buried Leah); ");
INSERT INTO engylt_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","the purchase of the field and of the cave which is in it, is from Sons of Heth.' ");
INSERT INTO engylt_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","And Jacob finisheth commanding his sons, and gathereth up his feet unto the bed, and expireth, and is gathered unto his people. ");
INSERT INTO engylt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","And Joseph falleth on his father's face, and weepeth over him, and kisseth him; ");
INSERT INTO engylt_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","and Joseph commandeth his servants, the physicians, to embalm his father, and the physicians embalm Israel; ");
INSERT INTO engylt_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","and they fulfil for him forty days, for so they fulfil the days of the embalmed, and the Egyptians weep for him seventy days. ");
INSERT INTO engylt_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","And the days of his weeping pass away, and Joseph speaketh unto the house of Pharaoh, saying, 'If, I pray you, I have found grace in your eyes, speak, I pray you, in the ears of Pharaoh, saying, ");
INSERT INTO engylt_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","My father caused me to swear, saying, Lo, I am dying; in my burying-place which I have prepared for myself in the land of Canaan, there dost thou bury me; and now, let me go up, I pray thee, and bury my father, and return;' ");
INSERT INTO engylt_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","and Pharaoh saith, 'Go up and bury thy father, as he caused thee to swear.' ");
INSERT INTO engylt_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","And Joseph goeth up to bury his father, and go up with him do all the servants of Pharaoh, elders of his house, and all the elders of the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","and all the house of Joseph, and his brethren, and the house of his father; only their infants, and their flock, and their herd, have they left in the land of Goshen; ");
INSERT INTO engylt_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","and there go up with him both chariot and horsemen, and the camp is very great. ");
INSERT INTO engylt_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","And they come unto the threshing-floor of Atad, which is beyond the Jordan, and they lament there, a lamentation great and very grievous; and he maketh for his father a mourning seven days, ");
INSERT INTO engylt_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","and the inhabitant of the land, the Canaanite, see the mourning in the threshing-floor of Atad, and say, 'A grievous mourning is this to the Egyptians;' therefore hath one called its name 'The mourning of the Egyptians,' which is beyond the Jordan. ");
INSERT INTO engylt_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","And his sons do to him so as he commanded them, ");
INSERT INTO engylt_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","and his sons bear him away to the land of Canaan, and bury him in the cave of the field of Machpelah, which Abraham bought with the field for a possession of a burying-place, from Ephron the Hittite, on the front of Mamre. ");
INSERT INTO engylt_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","And Joseph turneth back to Egypt, he and his brethren, and all who are going up with him to bury his father, after his burying his father. ");
INSERT INTO engylt_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","And the brethren of Joseph see that their father is dead, and say, 'Peradventure Joseph doth hate us, and doth certainly return to us all the evil which we did with him.' ");
INSERT INTO engylt_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","And they give a charge for Joseph, saying, 'Thy father commanded before his death, saying, ");
INSERT INTO engylt_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Thus ye do say to Joseph, I pray thee, bear, I pray thee, with the transgression of thy brethren, and their sin, for they have done thee evil; and now, bear, we pray thee, with the transgression of the servants of the God of thy father;' and Joseph weepeth in their speaking unto him. ");
INSERT INTO engylt_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","And his brethren also go and fall before him, and say, 'Lo, we are to thee for servants.' ");
INSERT INTO engylt_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","And Joseph saith unto them, 'Fear not, for am I in the place of God? ");
INSERT INTO engylt_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, ye devised against me evil — God devised it for good, in order to do as at this day, to keep alive a numerous people; ");
INSERT INTO engylt_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","and now, fear not: I do nourish you and your infants;' and he comforteth them, and speaketh unto their heart. ");
INSERT INTO engylt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","And Joseph dwelleth in Egypt, he and the house of his father, and Joseph liveth a hundred and ten years, ");
INSERT INTO engylt_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","and Joseph looketh on Ephraim's sons of the third generation; sons also of Machir, son of Manasseh, have been born on the knees of Joseph. ");
INSERT INTO engylt_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","And Joseph saith unto his brethren, 'I am dying, and God doth certainly inspect you, and hath caused you to go up from this land, unto the land which He hath sworn to Abraham, to Isaac, and to Jacob.' ");
INSERT INTO engylt_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","And Joseph causeth the sons of Israel to swear, saying, 'God doth certainly inspect you, and ye have brought up my bones from this place.' ");
INSERT INTO engylt_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","And Joseph dieth, a son of an hundred and ten years, and they embalm him, and he is put into a coffin in Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","And these are the names of the sons of Israel who are coming into Egypt with Jacob; a man and his household have they come; ");
INSERT INTO engylt_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah, ");
INSERT INTO engylt_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin, ");
INSERT INTO engylt_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, and Naphtali, Gad, and Asher. ");
INSERT INTO engylt_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","And all the persons coming out of the thigh of Jacob are seventy persons; as to Joseph, he was in Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","And Joseph dieth, and all his brethren, and all that generation; ");
INSERT INTO engylt_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","and the sons of Israel have been fruitful, and they teem, and multiply, and are very very mighty, and the land is filled with them. ");
INSERT INTO engylt_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","And there riseth a new king over Egypt, who hath not known Joseph, ");
INSERT INTO engylt_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","and he saith unto his people, 'Lo, the people of the sons of Israel is more numerous and mighty than we; ");
INSERT INTO engylt_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","give help! let us act wisely concerning it, lest it multiply, and it hath come to pass, when war happeneth, that it hath been joined, even it, unto those hating us, and hath fought against us, and hath gone out up of the land.' ");
INSERT INTO engylt_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","And they set over it princes of tribute, so as to afflict it with their burdens, and it buildeth store-cities for Pharaoh, Pithom and Raamses; ");
INSERT INTO engylt_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","and as they afflict it, so it multiplieth, and so it breaketh forth, and they are vexed because of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","and the Egyptians cause the sons of Israel to serve with rigour, ");
INSERT INTO engylt_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","and make their lives bitter in hard service, in clay, and in brick, and in every kind of service in the field; all their service in which they have served is with rigour. ");
INSERT INTO engylt_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","And the king of Egypt speaketh to the midwives, the Hebrewesses, (of whom the name of the one is Shiphrah, and the name of the second Puah), ");
INSERT INTO engylt_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","and saith, 'When ye cause the Hebrew women to bear, and have looked on the children; if it is a son — then ye have put him to death; and if it is a daughter — then she hath lived.' ");
INSERT INTO engylt_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","And the midwives fear God, and have not done as the king of Egypt hath spoken unto them, and keep the lads alive; ");
INSERT INTO engylt_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","and the king of Egypt calleth for the midwives, and saith to them, 'Wherefore have ye done this thing, and keep the lads alive?' ");
INSERT INTO engylt_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","And the midwives say unto Pharaoh, 'Because the Hebrew women are not as the Egyptian women, for they are lively; before the midwife cometh in unto them — they have borne!' ");
INSERT INTO engylt_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","And God doth good to the midwives, and the people multiply, and are very mighty; ");
INSERT INTO engylt_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","and it cometh to pass, because the midwives have feared God, that He maketh for them households; ");
INSERT INTO engylt_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","and Pharaoh layeth a charge on all his people, saying, 'Every son who is born — into the River ye do cast him, and every daughter ye do keep alive.' ");
INSERT INTO engylt_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","And there goeth a man of the house of Levi, and he taketh the daughter of Levi, ");
INSERT INTO engylt_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","and the woman conceiveth, and beareth a son, and she seeth him that he is fair, and she hideth him three months, ");
INSERT INTO engylt_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","and she hath not been able any more to hide him, and she taketh for him an ark of rushes, and daubeth it with bitumen and with pitch, and putteth the lad in it, and putteth it in the weeds by the edge of the River; ");
INSERT INTO engylt_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","and his sister stationeth herself afar off, to know what is done to him. ");
INSERT INTO engylt_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","And a daughter of Pharaoh cometh down to bathe at the River, and her damsels are walking by the side of the River, and she seeth the ark in the midst of the weeds, and sendeth her handmaid, and she taketh it, ");
INSERT INTO engylt_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","and openeth, and seeth him — the lad, and lo, a child weeping! and she hath pity on him, and saith, 'This is one of the Hebrews' children.' ");
INSERT INTO engylt_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","And his sister saith unto the daughter of Pharaoh, 'Do I go? when I have called for thee a suckling woman of the Hebrews, then she doth suckle the lad for thee;' ");
INSERT INTO engylt_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","and the daughter of Pharaoh saith to her, 'Go;' and the virgin goeth, and calleth the mother of the lad, ");
INSERT INTO engylt_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","and the daughter of Pharaoh saith to her, 'Take this lad away, and suckle him for me, and I — I give thy hire;' and the woman taketh the lad, and suckleth him. ");
INSERT INTO engylt_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","And the lad groweth, and she bringeth him in to the daughter of Pharaoh, and he is to her for a son, and she calleth his name Moses, and saith, 'Because — from the water I have drawn him.' ");
INSERT INTO engylt_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","And it cometh to pass, in those days, that Moses is grown, and he goeth out unto his brethren, and looketh on their burdens, and seeth a man, an Egyptian, smiting a man, a Hebrew, one of his brethren, ");
INSERT INTO engylt_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","and he turneth hither and thither, and seeth that there is no man, and smiteth the Egyptian, and hideth him in the sand. ");
INSERT INTO engylt_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","And he goeth out on the second day, and lo, two men, Hebrews, striving! and he saith to the wrong-doer, 'Why dost thou smite thy neighbour?' ");
INSERT INTO engylt_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","and he saith, 'Who set thee for a head and a judge over us? to slay me art thou saying it, as thou hast slain the Egyptian?' and Moses feareth, and saith, 'Surely the thing hath been known.' ");
INSERT INTO engylt_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","And Pharaoh heareth of this thing, and seeketh to slay Moses, and Moses fleeth from the face of Pharaoh, and dwelleth in the land of Midian, and dwelleth by the well. ");
INSERT INTO engylt_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","And to a priest of Midian are seven daughters, and they come and draw, and fill the troughs, to water the flock of their father, ");
INSERT INTO engylt_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","and the shepherds come and drive them away, and Moses ariseth, and saveth them, and watereth their flock. ");
INSERT INTO engylt_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","And they come in to Reuel their father, and he saith, 'Wherefore have ye hastened to come in to-day?' ");
INSERT INTO engylt_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","and they say, 'A man, an Egyptian, hath delivered us out of the hand of the shepherds, and also hath diligently drawn for us, and watereth the flock;' ");
INSERT INTO engylt_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","and he saith unto his daughters, 'And where is he? why is this? — ye left the man! call for him, and he doth eat bread.' ");
INSERT INTO engylt_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","And Moses is willing to dwell with the man, and he giveth Zipporah his daughter to Moses, ");
INSERT INTO engylt_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","and she beareth a son, and he calleth his name Gershom, for he said, 'A sojourner I have been in a strange land.' ");
INSERT INTO engylt_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","And it cometh to pass during these many days, that the king of Egypt dieth, and the sons of Israel sigh because of the service, and cry, and their cry goeth up unto God, because of the service; ");
INSERT INTO engylt_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","and God heareth their groaning, and God remembereth His covenant with Abraham, with Isaac, and with Jacob; ");
INSERT INTO engylt_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","and God seeth the sons of Israel, and God knoweth. ");
INSERT INTO engylt_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","And Moses hath been feeding the flock of Jethro his father-in-law, priest of Midian, and he leadeth the flock behind the wilderness, and cometh in unto the mount of God, to Horeb; ");
INSERT INTO engylt_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","and there appeareth unto him a messenger of Jehovah in a flame of fire, out of the midst of the bush, and he seeth, and lo, the bush is burning with fire, and the bush is not consumed. ");
INSERT INTO engylt_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","And Moses saith, 'Let me turn aside, I pray thee, and I see this great appearance; wherefore is the bush not burned?' ");
INSERT INTO engylt_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","and Jehovah seeth that he hath turned aside to see, and God calleth unto him out of the midst of the bush, and saith, 'Moses, Moses;' and he saith, 'Here am I.' ");
INSERT INTO engylt_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","And He saith, 'Come not near hither: cast thy shoes from off thy feet, for the place on which thou art standing is holy ground.' ");
INSERT INTO engylt_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","He saith also, 'I am the God of thy father, God of Abraham, God of Isaac, and God of Jacob;' and Moses hideth his face, for he is afraid to look towards God. ");
INSERT INTO engylt_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","And Jehovah saith, 'I have certainly seen the affliction of My people who are in Egypt, and their cry I have heard, because of its exactors, for I have known its pains; ");
INSERT INTO engylt_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","and I go down to deliver it out of the hand of the Egyptians, and to cause it to go up out of the land, unto a land good and broad, unto a land flowing with milk and honey — unto the place of the Canaanite, and the Hittite, and the Amorite, and the Perizzite, and the Hivite, and the Jebusite. ");
INSERT INTO engylt_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","'And now, lo, the cry of the sons of Israel hath come in unto Me, and I have also seen the oppression with which the Egyptians are oppressing them, ");
INSERT INTO engylt_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","and now, come, and I send thee unto Pharaoh, and bring thou out My people, the sons of Israel, out of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","And Moses saith unto God, 'Who am I, that I go unto Pharaoh, and that I bring out the sons of Israel from Egypt?' ");
INSERT INTO engylt_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","and He saith, 'Because I am with thee, and this is to thee the sign that I have sent thee: in thy bringing out the people from Egypt — ye do serve God on this mount.' ");
INSERT INTO engylt_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","And Moses saith unto God, 'Lo, I am coming unto the sons of Israel, and have said to them, The God of your fathers hath sent me unto you, and they have said to me, What is His name? what do I say unto them?' ");
INSERT INTO engylt_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","And God saith unto Moses, 'I AM THAT WHICH I AM;' He saith also, 'Thus dost thou say to the sons of Israel, I AM hath sent me unto you.' ");
INSERT INTO engylt_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","And God saith again unto Moses, 'Thus dost thou say unto the sons of Israel, Jehovah, God of your fathers, God of Abraham, God of Isaac, and God of Jacob, hath sent me unto you; this is My name — to the age, and this My memorial, to generation — generation. ");
INSERT INTO engylt_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","'Go, and thou hast gathered the elders of Israel, and hast said unto them: Jehovah, God of your fathers, hath appeareth unto me, God of Abraham, Isaac, and Jacob, saying, I have certainly inspected you, and that which is done to you in Egypt; ");
INSERT INTO engylt_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","and I say, I bring you up out of the affliction of Egypt, unto the land of the Canaanite, and the Hittite, and the Amorite, and the Perizzite, and the Hivite, and the Jebusite, unto a land flowing with milk and honey. ");
INSERT INTO engylt_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","'And they have hearkened to thy voice, and thou hast entered, thou and the elders of Israel, unto the king of Egypt, and ye have said unto him, Jehovah, God of the Hebrews, hath met with us; and now, let us go, we pray thee, a journey of three days into the wilderness, and we sacrifice to Jehovah our God. ");
INSERT INTO engylt_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","'And I — I have known that the king of Egypt doth not permit you to go, unless by a strong hand, ");
INSERT INTO engylt_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","and I have put forth My hand, and have smitten Egypt with all My wonders, which I do in its midst — and afterwards he doth send you away. ");
INSERT INTO engylt_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","'And I have given the grace of this people in the eyes of the Egyptians, and it hath come to pass, when ye go, ye go not empty; ");
INSERT INTO engylt_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","and every woman hath asked from her neighbour, and from her who is sojourning in her house, vessels of silver, and vessels of gold, and garments, and ye have put them on your sons and on your daughters, and have spoiled the Egyptians.' ");
INSERT INTO engylt_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","And Moses answereth and saith, 'And, if they do not give credence to me, nor hearken to my voice, and say, Jehovah hath not appeared unto thee?' ");
INSERT INTO engylt_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","And Jehovah saith unto him, 'What is this in thy hand?' and he saith, 'A rod;' ");
INSERT INTO engylt_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","and He saith, 'Cast it to the earth;' and he casteth it to the earth, and it becometh a serpent — and Moses fleeth from its presence. ");
INSERT INTO engylt_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","And Jehovah saith unto Moses, 'Put forth thy hand, and lay hold on the tail of it;' and he putteth forth his hand, and layeth hold on it, and it becometh a rod in his hand — ");
INSERT INTO engylt_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","' — so that they believe that Jehovah, God of their fathers, hath appeared unto thee, God of Abraham, God of Isaac, and God of Jacob.' ");
INSERT INTO engylt_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","And Jehovah saith to him again, 'Put in, I pray thee, thy hand into thy bosom;' and he putteth in his hand into his bosom, and he bringeth it out, and lo, his hand is leprous as snow; ");
INSERT INTO engylt_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","and He saith, 'Put back thy hand unto thy bosom;' and he putteth back his hand unto his bosom, and he bringeth it out from his bosom, and lo, it hath turned back as his flesh — ");
INSERT INTO engylt_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","' — and it hath come to pass, if they do not give credence to thee, and hearken not to the voice of the first sign, that they have given credence to the voice of the latter sign. ");
INSERT INTO engylt_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","'And it hath come to pass, if they do not give credence even to these two signs, nor hearken to thy voice, that thou hast taken of the waters of the River, and hast poured on the dry land, and the waters which thou takest from the River have been, yea, they have become — blood on the dry land.' ");
INSERT INTO engylt_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","And Moses saith unto Jehovah, 'O, my Lord, I am not a man of words, either yesterday, or before, or since Thy speaking unto Thy servant, for I am slow of mouth, and slow of tongue.' ");
INSERT INTO engylt_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","And Jehovah saith unto him, 'Who appointed a mouth for man? or who appointeth the dumb, or deaf, or open, or blind? is it not I, Jehovah? ");
INSERT INTO engylt_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","and now, go, and I — I am with thy mouth, and have directed thee that which thou speakest;' ");
INSERT INTO engylt_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","and he saith, 'O, my Lord, send, I pray thee, by the hand Thou dost send.' ");
INSERT INTO engylt_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","And the anger of Jehovah burneth against Moses, and He saith, 'Is not Aaron the Levite thy brother? I have known that he speaketh well, and also, lo, he is coming out to meet thee; when he hath seen thee, then he hath rejoiced in his heart, ");
INSERT INTO engylt_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","and thou hast spoken unto him, and hast set the words in his mouth, and I — I am with thy mouth, and with his mouth, and have directed you that which ye do; ");
INSERT INTO engylt_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","and he, he hath spoken for thee unto the people, and it hath come to pass, he — he is to thee for a mouth, and thou — thou art to him for God; ");
INSERT INTO engylt_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","and this rod thou dost take in thy hand, with which thou doest the signs.' ");
INSERT INTO engylt_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","And Moses goeth and turneth back unto Jethro his father-in-law, and saith to him, 'Let me go, I pray thee, and I turn back unto my brethren who are in Egypt, and I see whether they are yet alive.' And Jethro saith to Moses, 'Go in peace.' ");
INSERT INTO engylt_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","And Jehovah saith unto Moses in Midian, 'Go, turn back to Egypt, for all the men have died who seek thy life;' ");
INSERT INTO engylt_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","and Moses taketh his wife, and his sons, and causeth them to ride on the ass, and turneth back to the land of Egypt, and Moses taketh the rod of God in his hand. ");
INSERT INTO engylt_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","And Jehovah saith unto Moses, 'In thy going to turn back to Egypt, see — all the wonders which I have put in thy hand — that thou hast done them before Pharaoh, and I — I strengthen his heart, and he doth not send the people away; ");
INSERT INTO engylt_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","and thou hast said unto Pharaoh, Thus said Jehovah, My son, My first-born is Israel, ");
INSERT INTO engylt_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","and I say unto thee, Send away My son, and he doth serve Me; and — thou dost refuse to send him away — lo, I am slaying thy son, thy first-born.' ");
INSERT INTO engylt_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","And it cometh to pass in the way, in a lodging place, that Jehovah meeteth him, and seeketh to put him to death; ");
INSERT INTO engylt_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","and Zipporah taketh a flint, and cutteth off the foreskin of her son, and causeth it to touch his feet, and saith, 'Surely a bridegroom of blood art thou to me;' ");
INSERT INTO engylt_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","and He desisteth from him: then she said, 'A bridegroom of blood,' in reference to the circumcision. ");
INSERT INTO engylt_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","And Jehovah saith unto Aaron, 'Go to meet Moses into the wilderness;' and he goeth, and meeteth him in the mount of God, and kisseth him, ");
INSERT INTO engylt_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","and Moses declareth to Aaron all the words of Jehovah with which He hath sent him, and all the signs with which He hath charged him. ");
INSERT INTO engylt_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","And Moses goeth — Aaron also — and they gather all the elders of the sons of Israel, ");
INSERT INTO engylt_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","and Aaron speaketh all the words which Jehovah hath spoken unto Moses, and doth the signs before the eyes of the people; ");
INSERT INTO engylt_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","and the people believe when they hear that Jehovah hath looked after the sons of Israel, and that He hath seen their affliction; and they bow and do obeisance. ");
INSERT INTO engylt_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","And afterwards have Moses and Aaron entered, and they say unto Pharaoh, 'Thus said Jehovah, God of Israel, Send My people away, and they keep a feast to Me in the wilderness;' ");
INSERT INTO engylt_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","and Pharaoh saith, 'Who is Jehovah, that I hearken to His voice, to send Israel away? I have not known Jehovah, and Israel also I do not send away.' ");
INSERT INTO engylt_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","And they say, 'The God of the Hebrews hath met with us, let us go, we pray thee, a journey of three days into the wilderness, and we sacrifice to Jehovah our God, lest He meet us with pestilence or with sword.' ");
INSERT INTO engylt_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","And the king of Egypt saith unto them, 'Why, Moses and Aaron, do ye free the people from its works? go to your burdens.' ");
INSERT INTO engylt_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaoh also saith, 'Lo, numerous now is the people of the land, and ye have caused them to cease from their burdens!' ");
INSERT INTO engylt_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","And Pharaoh commandeth, on that day, the exactors among the people and its authorities, saying, ");
INSERT INTO engylt_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","'Ye do not add to give straw to the people for the making of the bricks, as heretofore — they go and have gathered straw for themselves; ");
INSERT INTO engylt_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","and the proper quantity of the bricks which they are making heretofore ye do put on them, ye do not diminish from it, for they are remiss, therefore they are crying, saying, Let us go, let us sacrifice to our God; ");
INSERT INTO engylt_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","let the service be heavy on the men, and let them work at it, and not be dazzled by lying words.' ");
INSERT INTO engylt_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","And the exactors of the people, and its authorities, go out, and speak unto the people, saying, 'Thus said Pharaoh, I do not give you straw, ");
INSERT INTO engylt_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ye — go ye, take for yourselves straw where ye find it, for there is nothing of your service diminished.' ");
INSERT INTO engylt_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","And the people is scattered over all the land of Egypt, to gather stubble for straw, ");
INSERT INTO engylt_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","and the exactors are making haste, saying, 'Complete your works, the matter of a day in its day, as when there is straw.' ");
INSERT INTO engylt_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","And the authorities of the sons of Israel, whom the exactors of Pharaoh have placed over them, are beaten, saying, 'Wherefore have ye not completed your portion in making brick as heretofore, both yesterday and to-day?' ");
INSERT INTO engylt_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","And the authorities of the sons of Israel come in and cry unto Pharaoh, saying, 'Why dost thou thus to thy servants? ");
INSERT INTO engylt_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Straw is not given to thy servants, and they are saying to us, Make bricks, and lo, thy servants are smitten — and thy people hath sinned.' ");
INSERT INTO engylt_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","And he saith, 'Remiss — ye are remiss, therefore ye are saying, Let us go, let us sacrifice to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","and now, go, serve; and straw is not given to you, and the measure of bricks ye do give.' ");
INSERT INTO engylt_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","And the authorities of the sons of Israel see them in affliction, saying, 'Ye do not diminish from your bricks; the matter of a day in its day.' ");
INSERT INTO engylt_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","And they meet Moses and Aaron standing to meet them, in their coming out from Pharaoh, ");
INSERT INTO engylt_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","and say unto them, 'Jehovah look upon you, and judge, because ye have caused our fragrance to stink in the eyes of Pharaoh, and in the eyes of his servants — to give a sword into their hand to slay us.' ");
INSERT INTO engylt_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","And Moses turneth back unto Jehovah, and saith, 'Lord, why hast Thou done evil to this people? why is this? — Thou hast sent me! ");
INSERT INTO engylt_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","and since I have come unto Pharaoh, to speak in Thy name, he hath done evil to this people, and Thou hast not at all delivered Thy people.' ");
INSERT INTO engylt_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","And Jehovah saith unto Moses, 'Now dost thou see that which I do to Pharaoh, for with a strong hand he doth send them away, yea, with a strong hand he doth cast them out of his land.' ");
INSERT INTO engylt_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","And God speaketh unto Moses, and saith unto him, 'I am Jehovah, ");
INSERT INTO engylt_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","and I appear unto Abraham, unto Isaac, and unto Jacob, as God Almighty; as to My name Jehovah, I have not been known to them; ");
INSERT INTO engylt_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","and also I have established My covenant with them, to give to them the land of Canaan, the land of their sojournings, wherein they have sojourned; ");
INSERT INTO engylt_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","and also I have heard the groaning of the sons of Israel, whom the Egyptians are causing to serve, and I remember My covenant. ");
INSERT INTO engylt_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","'Therefore say to the sons of Israel, I am Jehovah, and I have brought you out from under the burdens of the Egyptians, and have delivered you from their service, and have redeemed you by a stretched-out arm, and by great judgments, ");
INSERT INTO engylt_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","and have taken you to Me for a people, and I have been to you for God, and ye have known that I am Jehovah your God, who is bringing you out from under the burdens of the Egyptians; ");
INSERT INTO engylt_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","and I have brought you in unto the land which I have lifted up My hand to give it to Abraham, to Isaac, and to Jacob, and have given it to you — a possession; I am Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","And Moses speaketh so unto the sons of Israel, and they hearkened not unto Moses, for anguish of spirit, and for harsh service. ");
INSERT INTO engylt_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","'Go in, speak unto Pharaoh king of Egypt, and he doth send the sons of Israel out of his land; ");
INSERT INTO engylt_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","and Moses speaketh before Jehovah, saying, 'Lo, the sons of Israel have not hearkened unto me, and how doth Pharaoh hear me, and I of uncircumcised lips?' ");
INSERT INTO engylt_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","And Jehovah speaketh unto Moses, and unto Aaron, and chargeth them for the sons of Israel, and for Pharaoh king of Egypt, to bring out the sons of Israel from the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are heads of the house of their fathers: Sons of Reuben first-born of Israel are Hanoch, and Phallu, Hezron, and Carmi: these are families of Reuben. ");
INSERT INTO engylt_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","And sons of Simeon are Jemuel, and Jamin, and Ohad, and Jachin, and Zohar, and Shaul, son of the Canaanitess: these are families of Simeon. ");
INSERT INTO engylt_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","And these are the names of the sons of Levi, as to their births: Gershon, and Kohath, and Merari: and the years of the life of Levi are a hundred and thirty and seven years. ");
INSERT INTO engylt_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon are Libni, and Shimi, as to their families. ");
INSERT INTO engylt_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","And the sons of Kohath are Amram, and Izhar, and Hebron, and Uzziel: and the years of the life of Kohath are a hundred and thirty and three years. ");
INSERT INTO engylt_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","And the sons of Merari are Mahli and Mushi: these are families of Levi, as to their births. ");
INSERT INTO engylt_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","And Amram taketh Jochebed his aunt to himself for a wife, and she beareth to him Aaron and Moses: and the years of the life of Amram are a hundred and thirty and seven years. ");
INSERT INTO engylt_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","And sons of Izhar are Korah, and Nepheg, and Zichri. ");
INSERT INTO engylt_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","And sons of Uzziel are Mishael, and Elzaphan, and Sithri. ");
INSERT INTO engylt_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","And Aaron taketh Elisheba daughter of Amminadab, sister of Naashon, to himself for a wife, and she beareth to him Nadab, and Abihu, Eleazar, and Ithamar. ");
INSERT INTO engylt_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","And sons of Korah are Assir, and Elkanah, and Abiasaph: these are families of the Korhite. ");
INSERT INTO engylt_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","And Eleazar, Aaron's son, hath taken to him one of the daughters of Putiel for a wife to himself, and she beareth to him Phinehas: these are heads of the fathers of the Levites, as to their families. ");
INSERT INTO engylt_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","This is Aaron — and Moses — to whom Jehovah said, 'Bring ye out the sons of Israel from the land of Egypt, by their hosts;' ");
INSERT INTO engylt_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","these are they who are speaking unto Pharaoh king of Egypt, to bring out the sons of Israel from Egypt, this is Moses — and Aaron. ");
INSERT INTO engylt_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","And it cometh to pass in the day of Jehovah's speaking unto Moses in the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","that Jehovah speaketh unto Moses, saying, 'I am Jehovah, speak unto Pharaoh king of Egypt all that I am speaking unto thee.' ");
INSERT INTO engylt_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","And Moses saith before Jehovah, 'Lo, I am of uncircumcised lips, and how doth Pharaoh hearken unto me?' ");
INSERT INTO engylt_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","And Jehovah saith unto Moses, 'See, I have given thee a god to Pharaoh, and Aaron thy brother is thy prophet; ");
INSERT INTO engylt_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","thou — thou dost speak all that I command thee, and Aaron thy brother doth speak unto Pharaoh, and he hath sent the sons of Israel out of his land. ");
INSERT INTO engylt_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","'And I harden the heart of Pharaoh, and have multiplied My signs and My wonders in the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","and Pharaoh doth not hearken, and I have put My hand on Egypt, and have brought out My hosts, My people, the sons of Israel, from the land of Egypt by great judgments; ");
INSERT INTO engylt_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","and the Egyptians have known that I am Jehovah, in My stretching out My hand against Egypt; and I have brought out the sons of Israel from their midst.' ");
INSERT INTO engylt_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","And Moses doth — Aaron also — as Jehovah commanded them; so have they done; ");
INSERT INTO engylt_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","and Moses is a son of eighty years, and Aaron is a son of eighty and three years, in their speaking unto Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","And Jehovah speaketh unto Moses and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","'When Pharaoh speaketh unto you, saying, Give for yourselves a wonder; then thou hast said unto Aaron, Take thy rod, and cast before Pharaoh — it becometh a monster.' ");
INSERT INTO engylt_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","And Moses goeth in — Aaron also — unto Pharaoh, and they do so as Jehovah hath commanded; and Aaron casteth his rod before Pharaoh, and before his servants, and it becometh a monster. ");
INSERT INTO engylt_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","And Pharaoh also calleth for wise men, and for sorcerers; and the scribes of Egypt, they also, with their flashings, do so, ");
INSERT INTO engylt_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","and they cast down each his rod, and they become monsters, and the rod of Aaron swalloweth their rods; ");
INSERT INTO engylt_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","and the heart of Pharaoh is strong, and he hath not hearkened unto them, as Jehovah hath spoken. ");
INSERT INTO engylt_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","And Jehovah saith unto Moses, 'The heart of Pharaoh hath been hard, he hath refused to send the people away; ");
INSERT INTO engylt_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","go unto Pharaoh in the morning, lo, he is going out to the water, and thou hast stood to meet him by the edge of the River, and the rod which was turned to a serpent thou dost take in thy hand, ");
INSERT INTO engylt_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","and thou hast said unto him: Jehovah, God of the Hebrews, hath sent me unto thee, saying, Send My people away, and they serve Me in the wilderness; and lo, thou hast not hearkened hitherto. ");
INSERT INTO engylt_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","'Thus said Jehovah: By this thou knowest that I am Jehovah; lo, I am smiting with the rod which is in my hand, on the waters which are in the River, and they have been turned to blood, ");
INSERT INTO engylt_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","and the fish that are in the River die, and the River hath stank, and the Egyptians have been wearied of drinking waters from the River.' ");
INSERT INTO engylt_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","And Jehovah saith unto Moses, 'Say unto Aaron, Take thy rod, and stretch out thy hand against the waters of Egypt, against their streams, against their rivers, and against their ponds, and against all their collections of waters; and they are blood — and there hath been blood in all the land of Egypt, both in vessels of wood, and in those of stone.' ");
INSERT INTO engylt_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","And Moses and Aaron do so, as Jehovah hath commanded, and he lifteth up his hand with the rod, and smiteth the waters which are in the River, before the eyes of Pharaoh, and before the eyes of his servants, and all the waters which are in the River are turned to blood, ");
INSERT INTO engylt_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","and the fish which is in the River hath died, and the River stinketh, and the Egyptians have not been able to drink water from the River; and the blood is in all the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","And the scribes of Egypt do so with their flashings, and the heart of Pharaoh is strong, and he hath not hearkened unto them, as Jehovah hath spoken, ");
INSERT INTO engylt_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","and Pharaoh turneth and goeth in unto his house, and hath not set his heart even to this; ");
INSERT INTO engylt_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","and all the Egyptians seek water round about the river to drink, for they have not been able to drink of the waters of the River. ");
INSERT INTO engylt_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","And seven days are completed after Jehovah's smiting the River, ");
INSERT INTO engylt_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","And Jehovah saith unto Moses, 'Go in unto Pharaoh: and thou hast said unto him, Thus said Jehovah, Send My people away, and they serve Me; ");
INSERT INTO engylt_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","and if thou art refusing to send away, lo, I am smiting all thy border with frogs; ");
INSERT INTO engylt_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","and the River hath teemed with frogs, and they have gone up and gone into thy house, and into the inner-chamber of thy bed, and on thy couch, and into the house of thy servants, and among thy people, and into thine ovens, and into thy kneading-troughs; ");
INSERT INTO engylt_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","yea, on thee, and on thy people, and on all thy servants do the frogs go up.' ");
INSERT INTO engylt_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","And Jehovah saith unto Moses, 'Say unto Aaron, Stretch out thy hand, with thy rod, against the streams, against the rivers, and against the ponds, and cause the frogs to come up against the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","And Aaron stretcheth out his hand against the waters of Egypt, and the frog cometh up, and covereth the land of Egypt; ");
INSERT INTO engylt_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","and the scribes do so with their flashings, and cause the frogs to come up against the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","And Pharaoh calleth for Moses and for Aaron, and saith, 'Make supplication unto Jehovah, that he turn aside the frogs from me, and from my people, and I send the people away, and they sacrifice to Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","And Moses saith to Pharaoh, 'Beautify thyself over me; when do I make supplication for thee, and for thy servants, and for thy people, to cut off the frogs from thee and from thy houses — only in the River they do remain?' ");
INSERT INTO engylt_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","and he saith, 'To-morrow.' And he saith, According to thy word it is, so that thou knowest that there is none like Jehovah our God, ");
INSERT INTO engylt_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","and the frogs have turned aside from thee, and from thy houses, and from thy servants, and from thy people; only in the River they do remain.' ");
INSERT INTO engylt_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","And Moses — Aaron also — goeth out from Pharaoh, and Moses crieth unto Jehovah, concerning the matter of the frogs which He hath set on Pharaoh; ");
INSERT INTO engylt_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","and Jehovah doth according to the word of Moses, and the frogs die out of the houses, out of the courts, and out of the fields, ");
INSERT INTO engylt_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","and they heap them up together, and the land stinketh. ");
INSERT INTO engylt_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","And Pharaoh seeth that there hath been a respite, and he hath hardened his heart, and hath not hearkened unto them, as Jehovah hath spoken. ");
INSERT INTO engylt_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","And Jehovah saith unto Moses, 'Say unto Aaron, Stretch out thy rod, and smite the dust of the land, and it hath become gnats in all the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","And they do so, and Aaron stretcheth out his hand with his rod, and smiteth the dust of the land, and the gnats are on man and on beast; all the dust of the land hath been gnats in all the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","And the scribes do so with their flashings, to bring out the gnats, and they have not been able, and the gnats are on man and on beast; ");
INSERT INTO engylt_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","and the scribes say unto Pharaoh, 'It is the finger of God;' and the heart of Pharaoh is strong, and he hath not hearkened unto them, as Jehovah hath spoken. ");
INSERT INTO engylt_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","And Jehovah saith unto Moses, 'Rise early in the morning, and station thyself before Pharaoh, lo, he is going out to the waters, and thou hast said unto him, Thus said Jehovah, Send My people away, and they serve Me; ");
INSERT INTO engylt_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","for, if thou art not sending My people away, lo, I am sending against thee, and against thy servants, and against thy people, and against thy houses, the beetle, and the houses of the Egyptians have been full of the beetle, and also the ground on which they are. ");
INSERT INTO engylt_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","'And I have separated in that day the land of Goshen, in which My people are staying, that the beetle is not there, so that thou knowest that I am Jehovah in the midst of the land, ");
INSERT INTO engylt_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","and I have put a division between My people and thy people: to-morrow is this sign.' ");
INSERT INTO engylt_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","And Jehovah doth so, and the grievous beetle entereth the house of Pharaoh, and the house of his servants, and in all the land of Egypt the land is corrupted from the presence of the beetle. ");
INSERT INTO engylt_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","And Pharaoh calleth unto Moses and to Aaron, and saith, 'Go, sacrifice to your God in the land;' ");
INSERT INTO engylt_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","and Moses saith, 'Not right to do so, for the abomination of the Egyptians we do sacrifice to Jehovah our God; lo, we sacrifice the abomination of the Egyptians before their eyes — and they do not stone us! ");
INSERT INTO engylt_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","A journey of three days we go into the wilderness, and have sacrificed to Jehovah our God, as He saith unto us.' ");
INSERT INTO engylt_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","And Pharaoh saith, 'I send you away, and ye have sacrificed to Jehovah your God in the wilderness, only go not very far off; make ye supplication for me;' ");
INSERT INTO engylt_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","and Moses saith, 'Lo, I am going out from thee, and have made supplication unto Jehovah, and the beetle hath turned aside from Pharaoh, from his servants, and from his people — to-morrow, only let not Pharaoh add to deceive — in not sending the people away to sacrifice to Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","And Moses goeth out from Pharaoh, and maketh supplication unto Jehovah, ");
INSERT INTO engylt_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","and Jehovah doth according to the word of Moses, and turneth aside the beetle from Pharaoh, from his servants, and from his people — there hath not been left one; ");
INSERT INTO engylt_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","and Pharaoh hardeneth his heart also at this time, and hath not sent the people away. ");
INSERT INTO engylt_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","And Jehovah saith unto Moses, 'Go in unto Pharaoh, and thou hast spoken unto him, Thus said Jehovah, God of the Hebrews, Send My people away, and they serve me, ");
INSERT INTO engylt_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","for, if thou art refusing to send away, and art still keeping hold upon them, ");
INSERT INTO engylt_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","lo, the hand of Jehovah is on thy cattle which are in the field, on horses, on asses, on camels, on herd, and on flock — a pestilence very grievous. ");
INSERT INTO engylt_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","'And Jehovah hath separated between the cattle of Israel and the cattle of Egypt, and there doth not die a thing of all the sons of Israel's; ");
INSERT INTO engylt_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","and Jehovah setteth an appointed time, saying, To-morrow doth Jehovah do this thing in the land.' ");
INSERT INTO engylt_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","And Jehovah doth this thing on the morrow, and all the cattle of Egypt die, and of the cattle of the sons of Israel not one hath died; ");
INSERT INTO engylt_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","and Pharaoh sendeth, and lo, not even one of the cattle of Israel hath died, and the heart of Pharaoh is hard, and he hath not sent the people away. ");
INSERT INTO engylt_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","And Jehovah saith unto Moses and unto Aaron, 'Take to you the fulness of your hands of soot of a furnace, and Moses hath sprinkled it towards the heavens, before the eyes of Pharaoh, ");
INSERT INTO engylt_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","and it hath become small dust over all the land of Egypt, and it hath become on man and on cattle a boil breaking forth with blains, in all the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","And they take the soot of the furnace, and stand before Pharaoh, and Moses sprinkleth it towards the heavens, and it is a boil with blains, breaking forth, on man and on beast; ");
INSERT INTO engylt_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","and the scribes have not been able to stand before Moses, because of the boil, for the boil hath been on the scribes, and on all the Egyptians. ");
INSERT INTO engylt_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","And Jehovah strengtheneth the heart of Pharaoh, and he hath not hearkened unto them, as Jehovah hath spoken unto Moses. ");
INSERT INTO engylt_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","And Jehovah saith unto Moses, 'Rise early in the morning, and station thyself before Pharaoh, and thou hast said unto him, Thus said Jehovah, God of the Hebrews, Send My people away, and they serve Me, ");
INSERT INTO engylt_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","for, at this time I am sending all My plagues unto thy heart, and on thy servants, and on thy people, so that thou knowest that there is none like Me in all the earth, ");
INSERT INTO engylt_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","for now I have put forth My hand, and I smite thee, and thy people, with pestilence, and thou art hidden from the earth. ");
INSERT INTO engylt_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","'And yet for this I have caused thee to stand, so as to show thee My power, and for the sake of declaring My Name in all the earth; ");
INSERT INTO engylt_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","still thou art exalting thyself against My people — so as not to send them away; ");
INSERT INTO engylt_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","lo, I am raining about this time to-morrow hail very grievous, such as hath not been in Egypt, even from the day of its being founded, even until now. ");
INSERT INTO engylt_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","'And, now, send, strengthen thy cattle and all that thou hast in the field; every man and beast which is found in the field, and is not gathered into the house — come down on them hath the hail, and they have died.' ");
INSERT INTO engylt_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","He who is fearing the word of Jehovah among the servants of Pharaoh hath caused his servants and his cattle to flee unto the houses; ");
INSERT INTO engylt_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","and he who hath not set his heart unto the word of Jehovah leaveth his servants and his cattle in the field. ");
INSERT INTO engylt_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","And Jehovah saith unto Moses, 'Stretch forth thy hand towards the heavens, and there is hail in all the land of Egypt, on man, and on beast, and on every herb of the field in the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","And Moses stretcheth out his rod towards the heavens, and Jehovah hath given voices and hail, and fire goeth towards the earth, and Jehovah raineth hail on the land of Egypt, ");
INSERT INTO engylt_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","and there is hail, and fire catching itself in the midst of the hail, very grievous, such as hath not been in all the land of Egypt since it hath become a nation. ");
INSERT INTO engylt_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","And the hail smiteth in all the land of Egypt all that is in the field, from man even unto beast, and every herb of the field hath the hail smitten, and every tree of the field it hath broken; ");
INSERT INTO engylt_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","only in the land of Goshen, where the sons of Israel are, there hath been no hail. ");
INSERT INTO engylt_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","And Pharaoh sendeth, and calleth for Moses and for Aaron, and saith unto them, 'I have sinned this time, Jehovah is the Righteous, and I and my people are the Wicked, ");
INSERT INTO engylt_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","make ye supplication unto Jehovah, and plead that there be no voices of God and hail, and I send you away, and ye add not to remain.' ");
INSERT INTO engylt_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","And Moses saith unto him, 'At my going out of the city, I spread my palms unto Jehovah — the voices cease, and the hail is not any more, so that thou knowest that the earth is Jehovah's; ");
INSERT INTO engylt_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","but thou and thy servants — I have known that ye are not yet afraid of the face of Jehovah God.' ");
INSERT INTO engylt_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","And the flax and the barley have been smitten, for the barley is budding, and the flax forming flowers, ");
INSERT INTO engylt_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","and the wheat and the rye have not been smitten, for they are late. ");
INSERT INTO engylt_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","And Moses goeth out from Pharaoh, from the city, and spreadeth his hands unto Jehovah, and the voices and the hail cease, and rain hath not been poured out to the earth; ");
INSERT INTO engylt_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","and Pharaoh seeth that the rain hath ceased, and the hail and the voices, and he continueth to sin, and hardeneth his heart, he and his servants; ");
INSERT INTO engylt_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","and the heart of Pharaoh is strong, and he hath not sent the sons of Israel away, as Jehovah hath spoken by the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","And Jehovah saith unto Moses, 'Go in unto Pharaoh, for I have declared hard his heart, and the heart of his servants, so that I set these My signs in their midst, ");
INSERT INTO engylt_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","and so that thou recountest in the ears of thy son, and of thy son's son, that which I have done in Egypt, and My signs which I have set among them, and ye have known that I am Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","And Moses cometh in — Aaron also — unto Pharaoh, and they say unto him, 'Thus said Jehovah, God of the Hebrews, Until when hast thou refused to be humbled at My presence? send My people away, and they serve Me, ");
INSERT INTO engylt_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","for if thou art refusing to send My people away, lo, I am bringing in to-morrow the locust into thy border, ");
INSERT INTO engylt_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","and it hath covered the eye of the land, and none is able to see the land, and it hath eaten the remnant of that which is escaped, which is left to you from the hail, and it hath eaten every tree which is springing for you out of the field; ");
INSERT INTO engylt_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","and they have filled thy houses, and the houses of all thy servants, and the houses of all the Egyptians, which neither thy fathers nor thy father's fathers have seen, since the day of their being on the ground unto this day,' — and he turneth and goeth out from Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","And the servants of Pharaoh say unto him, 'Until when doth this one become a snare to us? send the men away, and they serve Jehovah their God; knowest thou not yet that Egypt hath perished?' ");
INSERT INTO engylt_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","And Moses is brought back — Aaron also — unto Pharaoh, and he saith unto them, 'Go, serve Jehovah your God; — who and who are those going?' ");
INSERT INTO engylt_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","And Moses saith, 'With our young ones, and with our aged ones, we go, with our sons, and with our daughters, with our flock, and our herd, we go, for we have a festival to Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","And he saith unto them, 'Be it so, Jehovah be with you when I send you and your infants away; see — for evil is before your faces; ");
INSERT INTO engylt_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","not so! go now, ye who are men, and serve Jehovah, for that ye are seeking;' and one casteth them out from the presence of Pharaoh. ");
INSERT INTO engylt_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","And Jehovah saith unto Moses, 'Stretch out thy hand against the land of Egypt for the locust, and it goeth up against the land of Egypt, and doth eat every herb of the land — all that the hail hath left.' ");
INSERT INTO engylt_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","And Moses stretcheth out his rod against the land of Egypt, and Jehovah hath led an east wind over the land all that day, and all the night; the morning hath been, and the east wind hath lifted up the locust. ");
INSERT INTO engylt_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","And the locust goeth up against all the land of Egypt, and resteth in all the border of Egypt — very grievous: before it there hath not been such a locust as it, and after it there is none such; ");
INSERT INTO engylt_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","and it covereth the eye of all the land, and the land is darkened; and it eateth every herb of the land, and all the fruit of the trees which the hail hath left, and there hath not been left any green thing in the trees, or in the herb of the field, in all the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","And Pharaoh hasteth to call for Moses and for Aaron, and saith, 'I have sinned against Jehovah your God, and against you, ");
INSERT INTO engylt_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","and now, bear with, I pray you, my sin, only this time, and make ye supplication to Jehovah your God, that He turn aside from off me only this death.' ");
INSERT INTO engylt_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","And he goeth out from Pharaoh, and maketh supplication unto Jehovah, ");
INSERT INTO engylt_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","and Jehovah turneth a very strong sea wind, and it lifteth up the locust, and bloweth it into the Red Sea — there hath not been left one locust in all the border of Egypt; ");
INSERT INTO engylt_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","and Jehovah strengtheneth the heart of Pharaoh, and he hath not sent the sons of Israel away. ");
INSERT INTO engylt_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","And Jehovah saith unto Moses, 'Stretch out thy hand towards the heavens, and there is darkness over the land of Egypt, and the darkness is felt.' ");
INSERT INTO engylt_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","And Moses stretcheth out his hand towards the heavens, and there is darkness — thick darkness in all the land of Egypt three days; ");
INSERT INTO engylt_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","they have not seen one another, and none hath risen from his place three days; and to all the sons of Israel there hath been light in their dwellings.' ");
INSERT INTO engylt_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","And Pharaoh calleth unto Moses and saith, 'Go ye, serve Jehovah, only your flock and your herd are stayed, your infants also go with you;' ");
INSERT INTO engylt_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","and Moses saith, 'Thou also dost give in our hand sacrifices and burnt-offerings, and we have prepared for Jehovah our God; ");
INSERT INTO engylt_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","and also our cattle doth go with us, there is not left a hoof, for from it we do take to serve Jehovah our God; and we — we know not how we do serve Jehovah till our going thither.' ");
INSERT INTO engylt_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","And Jehovah strengtheneth the heart of Pharaoh, and he hath not been willing to send them away; ");
INSERT INTO engylt_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","and Pharaoh saith to him, 'Go from me, take heed to thyself, add not to see my face, for in the day thou seest my face thou diest;' ");
INSERT INTO engylt_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","and Moses saith, 'Rightly hast thou spoken, I add not any more to see thy face.' ");
INSERT INTO engylt_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","And Jehovah saith unto Moses, 'One plague more I do bring in on Pharaoh, and on Egypt, afterwards he doth send you away from this; when he is sending you away, he surely casteth you out altogether from this place; ");
INSERT INTO engylt_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","speak, I pray thee, in the ears of the people, and they ask — each man from his neighbour, and each woman from her neighbour, vessels of silver, and vessels of gold.' ");
INSERT INTO engylt_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","And Jehovah giveth the grace of the people in the eyes of the Egyptians; also the man Moses is very great in the land of Egypt, in the eyes of the servants of Pharaoh, and in the eyes of the people. ");
INSERT INTO engylt_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","And Moses saith, 'Thus said Jehovah, About midnight I am going out into the midst of Egypt, ");
INSERT INTO engylt_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","and every first-born in the land of Egypt hath died, from the first-born of Pharaoh who is sitting on his throne, unto the first-born of the maid-servant who is behind the millstones, and all the first-born of beasts; ");
INSERT INTO engylt_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","and there hath been a great cry in all the land of Egypt, such as there hath not been, and such as there is not again. ");
INSERT INTO engylt_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","'And against all the sons of Israel a dog sharpeneth not its tongue, from man even unto beast, so that ye know that Jehovah doth make a separation between the Egyptians and Israel; ");
INSERT INTO engylt_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","and all these thy servants have come down unto me, and bowed themselves to me, saying, Go out, thou and all the people who are at thy feet; and afterwards I do go out;' — and he goeth out from Pharaoh in the heat of anger. ");
INSERT INTO engylt_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","And Jehovah saith unto Moses, 'Pharaoh doth not hearken unto you, so as to multiply My wonders in the land of Egypt;' ");
INSERT INTO engylt_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","and Moses and Aaron have done all these wonders before Pharaoh, and Jehovah strengtheneth Pharaoh's heart, and he hath not sent the sons of Israel out of his land. ");
INSERT INTO engylt_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","And Jehovah speaketh unto Moses and unto Aaron, in the land of Egypt, saying, ");
INSERT INTO engylt_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","'This month is to you the chief of months — it is the first to you of the months of the year; ");
INSERT INTO engylt_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","speak ye unto all the company of Israel, saying, In the tenth of this month — they take to them each man a lamb for the house of the fathers, a lamb for a house. ");
INSERT INTO engylt_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","'(And if the household be too few for a lamb, then hath he taken, he and his neighbour who is near unto his house, for the number of persons, each according to his eating ye do count for the lamb,) ");
INSERT INTO engylt_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","a lamb, a perfect one, a male, a son of a year, let be to you; from the sheep or from the goats ye do take it. ");
INSERT INTO engylt_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","'And it hath become a charge to you, until the fourteenth day of this month, and the whole assembly of the company of Israel have slaughtered it between the evenings; ");
INSERT INTO engylt_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","and they have taken of the blood, and have put on the two side-posts, and on the lintel over the houses in which they eat it. ");
INSERT INTO engylt_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","'And they have eaten the flesh in this night, roast with fire; with unleavened things and bitters they do eat it; ");
INSERT INTO engylt_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ye do not eat of it raw, or boiled at all in water, but roast with fire, its head with its legs, and with its inwards; ");
INSERT INTO engylt_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","and ye do not leave of it till morning, and that which is remaining of it till morning with fire ye do burn. ");
INSERT INTO engylt_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","'And thus ye do eat it: your loins girded, your sandals on your feet, and your staff in your hand, and ye have eaten it in haste; it is Jehovah's passover, ");
INSERT INTO engylt_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","and I have passed over through the land of Egypt during this night, and have smitten every first-born in the land of Egypt, from man even unto beast, and on all the gods of Egypt I do judgments; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","'And the blood hath become a sign for you on the houses where ye are, and I have seen the blood, and have passed over you, and a plague is not on you for destruction in My smiting in the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","'And this day hath become to you a memorial, and ye have kept it a feast to Jehovah to your generations; — a statute age-during; ye keep it a feast. ");
INSERT INTO engylt_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Seven days ye eat unleavened things; only — in the first day ye cause leaven to cease out of your houses; for any one eating anything fermented from the first day till the seventh day, even that person hath been cut off from Israel. ");
INSERT INTO engylt_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","'And in the first day is a holy convocation, and in the seventh day ye have a holy convocation; any work is not done in them, only that which is eaten by any person — it alone is done by you, ");
INSERT INTO engylt_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","and ye have observed the unleavened things, for in this self-same day I have brought out your hosts from the land of Egypt, and ye have observed this day to your generations — a statute age-during. ");
INSERT INTO engylt_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","'In the first month, in the fourteenth day of the month, in the evening, ye do eat unleavened things until the one and twentieth day of the month, at evening; ");
INSERT INTO engylt_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","seven days leaven is not found in your houses, for any one eating anything fermented — that person hath been cut off from the company of Israel, among the sojourners or among the natives of the land; ");
INSERT INTO engylt_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","anything fermented ye do not eat, in all your dwellings ye do eat unleavened things.' ");
INSERT INTO engylt_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","And Moses calleth for all the elders of Israel, and saith unto them, 'Draw out and take for yourselves from the flock, for your families, and slaughter the passover-sacrifice; ");
INSERT INTO engylt_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","and ye have taken a bunch of hyssop, and have dipped it in the blood which is in the basin, and have struck it on the lintel, and on the two side-posts, from the blood which is in the basin, and ye, ye go not out each from the opening of his house till morning. ");
INSERT INTO engylt_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","'And Jehovah hath passed on to smite the Egyptians, and hath seen the blood on the lintel, and on the two side-posts, and Jehovah hath passed over the opening, and doth not permit the destruction to come into your houses to smite. ");
INSERT INTO engylt_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","'And ye have observed this thing, for a statute to thee, and to thy sons — unto the age; ");
INSERT INTO engylt_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","and it hath been, when ye come in unto the land which Jehovah giveth to you, as He hath spoken, that ye have kept this service; ");
INSERT INTO engylt_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","and it hath come to pass when your sons say unto you, What is this service ye have? ");
INSERT INTO engylt_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","that ye have said, A sacrifice of passover it is to Jehovah, who passed over the houses of the sons of Israel in Egypt, in His smiting the Egyptians, and our houses He delivered.' ");
INSERT INTO engylt_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","And the people bow and do obeisance, and the sons of Israel go and do as Jehovah commanded Moses and Aaron; so have they done. ");
INSERT INTO engylt_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","And it cometh to pass, at midnight, that Jehovah hath smitten every first-born in the land of Egypt, from the first-born of Pharaoh who is sitting on his throne, unto the first-born of the captive who is in the prison-house, and every first-born of beasts. ");
INSERT INTO engylt_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","And Pharaoh riseth by night, he and all his servants, and all the Egyptians, and there is a great cry in Egypt, for there is not a house where there is not one dead, ");
INSERT INTO engylt_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","and he calleth for Moses and for Aaron by night, and saith, 'Rise, go out from the midst of my people, both ye and the sons of Israel, and go, serve Jehovah according to your word; ");
INSERT INTO engylt_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","both your flock and your herd take ye, as ye have spoken, and go; then ye have blessed also me.' ");
INSERT INTO engylt_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","And the Egyptians are urgent on the people, hasting to send them away out of the land, for they said, 'We are all dead;' ");
INSERT INTO engylt_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","and the people taketh up its dough before it is fermented, their kneading-troughs are bound up in their garments on their shoulder. ");
INSERT INTO engylt_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","And the sons of Israel have done according to the word of Moses, and they ask from the Egyptians vessels of silver and vessels of gold, and garments; ");
INSERT INTO engylt_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","and Jehovah hath given the grace of the people in the eyes of the Egyptians, and they cause them to ask, and they spoil the Egyptians. ");
INSERT INTO engylt_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","And the sons of Israel journey from Rameses to Succoth, about six hundred thousand men on foot, apart from infants; ");
INSERT INTO engylt_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","and a great rabble also hath gone up with them, and flock and herd — very much cattle. ");
INSERT INTO engylt_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","And they bake with the dough which they have brought out from Egypt unleavened cakes, for it hath not fermented; for they have been cast out of Egypt, and have not been able to delay, and also provision they have not made for themselves. ");
INSERT INTO engylt_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","And the dwelling of the sons of Israel which they have dwelt in Egypt is four hundred and thirty years; ");
INSERT INTO engylt_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","and it cometh to pass, at the end of four hundred and thirty years — yea, it cometh to pass in this self-same day — all the hosts of Jehovah have gone out from the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","A night of watchings it is to Jehovah, to bring them out from the land of Egypt; it is this night to Jehovah of watchings to all the sons of Israel to their generations. ");
INSERT INTO engylt_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","And Jehovah saith unto Moses and Aaron, 'This is a statute of the passover; Any son of a stranger doth not eat of it; ");
INSERT INTO engylt_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","and any man's servant, the purchase of money, when thou hast circumcised him — then he doth eat of it; ");
INSERT INTO engylt_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","a settler or hired servant doth not eat of it; ");
INSERT INTO engylt_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","in one house it is eaten, thou dost not carry out of the house any of the flesh without, and a bone ye do not break of it; ");
INSERT INTO engylt_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","all the company of Israel do keep it. ");
INSERT INTO engylt_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","'And when a sojourner sojourneth with thee, and hath made a passover to Jehovah, every male of his is to be circumcised, and then he doth come near to keep it, and he hath been as a native of the land, but any uncircumcised one doth not eat of it; ");
INSERT INTO engylt_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","one law is to a native, and to a sojourner who is sojourning in your midst.' ");
INSERT INTO engylt_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","And all the sons of Israel do as Jehovah commanded Moses and Aaron; so have they done. ");
INSERT INTO engylt_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","And it cometh to pass in this self-same day, Jehovah hath brought out the sons of Israel from the land of Egypt, by their hosts. ");
INSERT INTO engylt_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","'Sanctify to Me every first-born, opening any womb among the sons of Israel, among man and among beast; it is Mine.' ");
INSERT INTO engylt_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","And Moses saith unto the people, 'Remember this day in which ye have gone out from Egypt, from the house of servants, for by strength of hand hath Jehovah brought you out from this, and any thing fermented is not eaten; ");
INSERT INTO engylt_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","To-day ye are going out, in the month of Abib. ");
INSERT INTO engylt_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","'And it hath been, when Jehovah bringeth thee in unto the land of the Canaanite, and of the Hittite, and of the Amorite, and of the Hivite, and of the Jebusite, which He hath sworn to thy fathers to give to thee, a land flowing with milk and honey, that thou hast done this service in this month. ");
INSERT INTO engylt_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","'Seven days thou dost eat unleavened things, and in the seventh day is a feast to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","unleavened things are eaten the seven days, and any thing fermented is not seen with thee; yea, leaven is not seen with thee in all thy border. ");
INSERT INTO engylt_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","'And thou hast declared to thy son in that day, saying, 'It is because of what Jehovah did to me, in my going out from Egypt, ");
INSERT INTO engylt_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","and it hath been to thee for a sign on thy hand, and for a memorial between thine eyes, so that the law of Jehovah is in thy mouth, for by a strong hand hath Jehovah brought thee out from Egypt; ");
INSERT INTO engylt_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","and thou hast kept this statute at its appointed season from days to days. ");
INSERT INTO engylt_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","'And it hath been, when Jehovah bringeth thee in unto the land of the Canaanite, as He hath sworn to thee and to thy fathers, and hath given it to thee, ");
INSERT INTO engylt_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","that thou hast caused every one opening a womb to pass over to Jehovah, and every firstling — the increase of beasts which thou hast: the males are Jehovah's. ");
INSERT INTO engylt_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","'And every firstling of an ass thou dost ransom with a lamb, and if thou dost not ransom it, then thou hast beheaded it: and every first-born of man among thy sons thou dost ransom. ");
INSERT INTO engylt_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","'And it hath been, when thy son asketh thee hereafter, saying, What is this? that thou hast said unto him, By strength of hand hath Jehovah brought us out from Egypt, from a house of servants; ");
INSERT INTO engylt_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","yea, it cometh to pass, when Pharaoh hath been pained to send us away, that Jehovah doth slay every first-born in the land of Egypt, from the first-born of man even unto the first-born of beast; therefore I am sacrificing to Jehovah all opening a womb who are males, and every first-born of my sons I ransom; ");
INSERT INTO engylt_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","and it hath been for a token on thy hand, and for frontlets between thine eyes, for by strength of hand hath Jehovah brought us out of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","And it cometh to pass in Pharaoh's sending the people away, that God hath not led them the way of the land of the Philistines, for it is near; for God said, 'Lest the people repent in their seeing war, and have turned back towards Egypt;' ");
INSERT INTO engylt_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","and God turneth round the people the way of the wilderness of the Red Sea, and by fifties have the sons of Israel gone up from the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","And Moses taketh the bones of Joseph with him, for he certainly caused the sons of Israel to swear, saying, 'God doth certainly inspect you, and ye have brought up my bones from this with you.' ");
INSERT INTO engylt_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","And they journey from Succoth, and encamp in Etham at the extremity of the wilderness, ");
INSERT INTO engylt_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","and Jehovah is going before them by day in a pillar of a cloud, to lead them in the way, and by night in a pillar of fire, to give light to them, to go by day and by night; ");
INSERT INTO engylt_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","He removeth not the pillar of the cloud by day, and the pillar of the fire by night, from before the people. ");
INSERT INTO engylt_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","'Speak unto the sons of Israel, and they turn back and encamp before Pi-Hahiroth, between Migdol and the sea, before Baal-Zephon; over-against it ye do encamp by the sea, ");
INSERT INTO engylt_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","and Pharaoh hath said of the sons of Israel, They are entangled in the land, the wilderness hath shut upon them; ");
INSERT INTO engylt_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","and I have strengthened the heart of Pharaoh, and he hath pursued after them, and I am honoured on Pharaoh, and on all his force, and the Egyptians have known that I am Jehovah;' and they do so. ");
INSERT INTO engylt_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","And it is declared to the king of Egypt that the people hath fled, and the heart of Pharaoh and of his servants is turned against the people, and they say, 'What is this we have done? that we have sent Israel away from our service.' ");
INSERT INTO engylt_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","And he harnesseth his chariot, and his people he hath taken with him, ");
INSERT INTO engylt_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","and he taketh six hundred chosen chariots, even all the chariots of Egypt, and captains over them all; ");
INSERT INTO engylt_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","and Jehovah strengtheneth the heart of Pharaoh king of Egypt, and he pursueth after the sons of Israel, and the sons of Israel are going out with a high hand, ");
INSERT INTO engylt_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","and the Egyptians pursue after them, and all the chariot horses of Pharaoh, and his horsemen, and his force, overtake them, encamping by the sea, by Pi-Hahiroth, before Baal-Zephon. ");
INSERT INTO engylt_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","And Pharaoh hath drawn near, and the sons of Israel lift up their eyes, and lo, the Egyptians are journeying after them, and they fear exceedingly, and the sons of Israel cry unto Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","And they say unto Moses, 'Because there are no graves in Egypt, hast thou taken us away to die in a wilderness? what is this thou hast done to us — to bring us out from Egypt? ");
INSERT INTO engylt_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Is not this the word which we spake unto thee in Egypt, saying, Cease from us, and we serve the Egyptians; for better for us to serve the Egyptians than to die in a wilderness?' ");
INSERT INTO engylt_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","And Moses saith unto the people, 'Fear not, station yourselves, and see the salvation of Jehovah, which He doth for you to-day; for, as ye have seen the Egyptians to-day, ye add no more to see them — to the age; ");
INSERT INTO engylt_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jehovah doth fight for you, and ye keep silent.' ");
INSERT INTO engylt_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","And Jehovah saith unto Moses, 'What? thou criest unto Me — speak unto the sons of Israel, and they journey; ");
INSERT INTO engylt_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","and thou, lift up thy rod, and stretch out thy hand towards the sea, and cleave it, and the sons of Israel go into the midst of the sea on dry land. ");
INSERT INTO engylt_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","'And I — lo, I am strengthening the heart of the Egyptians, and they go in after them, and I am honoured on Pharaoh, and on all his force, on his chariots, and on his horsemen; ");
INSERT INTO engylt_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","and the Egyptians have known that I am Jehovah, in My being honoured on Pharaoh, on his chariots, and on his horsemen.' ");
INSERT INTO engylt_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","And the messenger of God, who is going before the camp of Israel, journeyeth and goeth at their rear; and the pillar of the cloud journeyeth from their front, and standeth at their rear, ");
INSERT INTO engylt_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","and cometh in between the camp of the Egyptians and the camp of Israel, and the cloud and the darkness are, and he enlighteneth the night, and the one hath not drawn near unto the other all the night. ");
INSERT INTO engylt_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","And Moses stretcheth out his hand towards the sea, and Jehovah causeth the sea to go on by a strong east wind all the night, and maketh the sea become dry ground, and the waters are cleaved, ");
INSERT INTO engylt_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","and the sons of Israel go into the midst of the sea, on dry land, and the waters are to them a wall, on their right and on their left. ");
INSERT INTO engylt_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","And the Egyptians pursue, and go in after them (all the horses of Pharaoh, his chariots, and his horsemen) unto the midst of the sea, ");
INSERT INTO engylt_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","and it cometh to pass, in the morning watch, that Jehovah looketh unto the camp of the Egyptians through the pillar of fire and of the cloud, and troubleth the camp of the Egyptians, ");
INSERT INTO engylt_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","and turneth aside the wheels of their chariots, and they lead them with difficulty, and the Egyptians say, 'Let us flee from the face of Israel, for Jehovah is fighting for them against the Egyptians.' ");
INSERT INTO engylt_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","And Jehovah saith unto Moses, 'Stretch out thy hand toward the sea, and the waters turn back on the Egyptians, on their chariots, and on their horsemen.' ");
INSERT INTO engylt_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","And Moses stretcheth out his hand towards the sea, and the sea turneth back, at the turning of the morning, to its perennial flow, and the Egyptians are fleeing at its coming, and Jehovah shaketh off the Egyptians in the midst of the sea, ");
INSERT INTO engylt_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","and the waters turn back, and cover the chariots and the horsemen, even all the force of Pharaoh, who are coming in after them into the sea — there hath not been left of them even one. ");
INSERT INTO engylt_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","And the sons of Israel have gone on dry land in the midst of the sea, and the waters are to them a wall, on their right and on their left; ");
INSERT INTO engylt_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","and Jehovah saveth Israel in that day out of the hand of the Egyptians, and Israel seeth the Egyptians dead on the sea-shore, ");
INSERT INTO engylt_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","and Israel seeth the great hand with which Jehovah hath wrought against the Egyptians, and the people fear Jehovah, and remain stedfast in Jehovah, and in Moses His servant. ");
INSERT INTO engylt_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then singeth Moses and the sons of Israel this song to Jehovah, and they speak, saying: — 'I sing to Jehovah, For triumphing He hath triumphed; The horse and its rider He hath thrown into the sea. ");
INSERT INTO engylt_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","My strength and song is JAH, And He is become my salvation: This is my God, and I glorify Him; God of my father, and I exalt Him. ");
INSERT INTO engylt_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jehovah is a man of battle; Jehovah is His name. ");
INSERT INTO engylt_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Chariots of Pharaoh and his force He hath cast into the sea; And the choice of his captains Have sunk in the Red Sea! ");
INSERT INTO engylt_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The depths do cover them; They went down into the depths as a stone. ");
INSERT INTO engylt_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Thy right hand, O Jehovah, Is become honourable in power; Thy right hand, O Jehovah, Doth crush an enemy. ");
INSERT INTO engylt_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","And in the abundance of Thine excellency Thou throwest down Thy withstanders, Thou sendest forth Thy wrath — It consumeth them as stubble. ");
INSERT INTO engylt_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","And by the spirit of Thine anger Have waters been heaped together; Stood as a heap have flowings; Congealed have been depths In the heart of a sea. ");
INSERT INTO engylt_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The enemy said, I pursue, I overtake; I apportion spoil; Filled is my soul with them; I draw out my sword; My hand destroyeth them: — ");
INSERT INTO engylt_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Thou hast blown with Thy wind The sea hath covered them; They sank as lead in mighty waters. ");
INSERT INTO engylt_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who is like Thee among the gods, O Jehovah? Who is like Thee — honourable in holiness — Fearful in praises — doing wonders? ");
INSERT INTO engylt_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Thou hast stretched out Thy right hand — Earth swalloweth them! ");
INSERT INTO engylt_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Thou hast led forth in Thy kindness The people whom Thou hast redeemed. Thou hast led on in Thy strength Unto Thy holy habitation. ");
INSERT INTO engylt_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Peoples have heard, they are troubled; Pain hath seized inhabitants of Philistia. ");
INSERT INTO engylt_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then have chiefs of Edom been troubled: Mighty ones of Moab — Trembling doth seize them! Melted have all inhabitants of Canaan! ");
INSERT INTO engylt_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Fall on them doth terror and dread; By the greatness of Thine arm They are still as a stone, Till Thy people pass over, O Jehovah; Till the people pass over Whom Thou hast purchased. ");
INSERT INTO engylt_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Thou dost bring them in, And dost plant them In a mountain of Thine inheritance, A fixed place for Thy dwelling Thou hast made, O Jehovah; A sanctuary, O Lord, Thy hands have established; ");
INSERT INTO engylt_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jehovah reigneth — to the age, and for ever!' ");
INSERT INTO engylt_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For the horse of Pharaoh hath gone in with his chariots and with his horsemen into the sea, and Jehovah turneth back on them the waters of the sea, and the sons of Israel have gone on dry land in the midst of the sea. ");
INSERT INTO engylt_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","And Miriam the inspired one, sister of Aaron, taketh the timbrel in her hand, and all the women go out after her, with timbrels and with choruses; ");
INSERT INTO engylt_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","and Miriam answereth to them: — 'Sing ye to Jehovah, For Triumphing He hath triumphed; The horse and its rider He hath thrown into the sea!' ");
INSERT INTO engylt_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","And Moses causeth Israel to journey from the Red Sea, and they go out unto the wilderness of Shur, and they go three days in the wilderness, and have not found water, ");
INSERT INTO engylt_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","and they come in to Marah, and have not been able to drink the waters of Marah, for they are bitter; therefore hath one called its name Marah. ");
INSERT INTO engylt_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","And the people murmur against Moses, saying, 'What do we drink?' ");
INSERT INTO engylt_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","and he crieth unto Jehovah, and Jehovah sheweth him a tree, and he casteth unto the waters, and the waters become sweet. There He hath made for them a statute, and an ordinance, and there He hath tried them, ");
INSERT INTO engylt_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","and He saith, 'If thou dost really hearken to the voice of Jehovah thy God, and dost that which is right in His eyes, and hast hearkened to His commands, and kept all His statutes: none of the sickness which I laid on the Egyptians do I lay on thee, for I, Jehovah, am healing thee. ");
INSERT INTO engylt_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","And they come to Elim, and there are twelve fountains of water, and seventy palm trees; and they encamp there by the waters. ");
INSERT INTO engylt_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","And they journey from Elim, and all the company of the sons of Israel come in unto the wilderness of Sin, which is between Elim and Sinai, on the fifteenth day of the second month of their going out from the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","And all the company of the sons of Israel murmur against Moses and against Aaron in the wilderness; ");
INSERT INTO engylt_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","and the sons of Israel say unto them, 'Oh that we had died by the hand of Jehovah in the land of Egypt, in our sitting by the flesh-pot, in our eating bread to satiety — for ye have brought us out unto this wilderness to put all this assembly to death with hunger.' ");
INSERT INTO engylt_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","And Jehovah saith unto Moses, 'Lo, I am raining to you bread from the heavens — and the people have gone out and gathered the matter of a day in its day — so that I try them whether they walk in My law, or not; ");
INSERT INTO engylt_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","and it hath been on the sixth day, that they have prepared that which they bring in, and it hath been double above that which they gather day by day.' ");
INSERT INTO engylt_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","And Moses saith — Aaron also — unto all the sons of Israel, 'Evening — and ye have known that Jehovah hath brought you out from the land of Egypt; ");
INSERT INTO engylt_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","and morning — and ye have seen the honour of Jehovah, in His hearing your murmurings against Jehovah, and what are we, that ye murmur against us?' ");
INSERT INTO engylt_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","And Moses saith, 'In Jehovah's giving to you in the evening flesh to eat, and bread in the morning to satiety — in Jehovah's hearing your murmurings, which ye are murmuring against Him, and what are we? your murmurings are not against us, but against Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","And Moses saith unto Aaron, 'Say unto all the company of the sons of Israel, Come ye near before Jehovah, for He hath heard your murmurings;' ");
INSERT INTO engylt_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","and it cometh to pass, when Aaron is speaking unto all the company of the sons of Israel, that they turn towards the wilderness, and lo, the honour of Jehovah is seen in the cloud. ");
INSERT INTO engylt_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","'I have heard the murmurings of the sons of Israel; speak unto them, saying, Between the evenings ye eat flesh, and in the morning ye are satisfied with bread, and ye have known that I am Jehovah your God.' ");
INSERT INTO engylt_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","And it cometh to pass in the evening, that the quail cometh up, and covereth the camp, and in the morning there hath been the lying of dew round about the camp, ");
INSERT INTO engylt_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","and the lying of the dew goeth up, and lo, on the face of the wilderness a thin, bare thing, thin as hoar-frost on the earth. ");
INSERT INTO engylt_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","And the sons of Israel see, and say one unto another, 'What is it?' for they have not known what it is; and Moses saith unto them, 'It is the bread which Jehovah hath given to you for food. ");
INSERT INTO engylt_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","'This is the thing which Jehovah hath commanded: Gather of it each according to his eating, an omer for a poll; and the number of your persons, take ye each for those in his tent.' ");
INSERT INTO engylt_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","And the sons of Israel do so, and they gather, he who is gathering much, and he who is gathering little; ");
INSERT INTO engylt_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","and they measure with an omer, and he who is gathering much hath nothing over, and he who is gathering little hath no lack, each according to his eating they have gathered. ");
INSERT INTO engylt_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","And Moses saith unto them, 'Let no man leave of it till morning;' ");
INSERT INTO engylt_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","and they have not hearkened unto Moses, and some of them do leave of it till morning, and it bringeth up worms and stinketh; and Moses is wroth with them. ");
INSERT INTO engylt_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","And they gather it morning by morning, each according to his eating; when the sun hath been warm, then it hath melted. ");
INSERT INTO engylt_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","And it cometh to pass on the sixth day, they have gathered a second bread, two omers for one, and all the princes of the company come in, and declare to Moses. ");
INSERT INTO engylt_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","And he saith unto them, 'It is that which Jehovah hath spoken of; a rest — a holy sabbath to Jehovah — is to-morrow; that which ye bake, bake; and that which ye boil, boil; and all that is over, let rest for yourselves in charge till the morning.' ");
INSERT INTO engylt_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","And they let it rest until the morning, as Moses hath commanded, and it hath not stank, and a worm hath not been in it. ");
INSERT INTO engylt_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","And Moses saith, 'Eat it to-day, for to-day is a sabbath to Jehovah; to-day ye find it not in the field: ");
INSERT INTO engylt_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","six days ye do gather it, and in the seventh day — the sabbath — in it there is none.' ");
INSERT INTO engylt_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","And it cometh to pass on the seventh day, some of the people have gone out to gather, and have not found. ");
INSERT INTO engylt_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","And Jehovah saith unto Moses, 'How long have ye refused to keep My commands, and My laws? ");
INSERT INTO engylt_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","see, because Jehovah hath given to you the sabbath, therefore He is giving to you on the sixth day bread of two days; abide ye each in his place, no one doth go out from his place on the seventh day.' ");
INSERT INTO engylt_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","And the people rest on the seventh day, ");
INSERT INTO engylt_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","and the house of Israel call its name Manna, and it is as coriander seed, white; and its taste is as a cake with honey. ");
INSERT INTO engylt_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","And Moses saith, 'This is the thing which Jehovah hath commanded: Fill the omer with it, for a charge for your generations, so that they see the bread which I have caused you to eat in the wilderness, in My bringing you out from the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","And Moses saith unto Aaron, 'Take one pot, and put there the fulness of the omer of manna, and let it rest before Jehovah, for a charge for your generations;' ");
INSERT INTO engylt_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","as Jehovah hath given commandment unto Moses, so doth Aaron let it rest before the Testimony, for a charge. ");
INSERT INTO engylt_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","And the sons of Israel have eaten the manna forty years, until their coming in unto the land to be inhabited; the manna they have eaten till their coming in unto the extremity of the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","and the omer is a tenth of the ephah. ");
INSERT INTO engylt_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","And all the company of the sons of Israel journey from the wilderness of Sin, on their journeyings, by the command of Jehovah, and encamp in Rephidim, and there is no water for the people to drink; ");
INSERT INTO engylt_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","and the people strive with Moses, and say, 'Give us water, and we drink.' And Moses saith to them, 'What? — ye strive with me, what? — ye try Jehovah?' ");
INSERT INTO engylt_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","and the people thirst there for water, and the people murmur against Moses, and say, 'Why is this? — thou hast brought us up out of Egypt, to put us to death, also our sons and our cattle, with thirst.' ");
INSERT INTO engylt_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","And Moses crieth to Jehovah, saying, 'What do I to this people? yet a little, and they have stoned me.' ");
INSERT INTO engylt_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","And Jehovah saith unto Moses, 'Pass over before the people, and take with thee of the elders of Israel, and thy rod with which thou hast smitten the River take in thy hand, and thou hast gone: ");
INSERT INTO engylt_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Lo, I am standing before thee there on the rock in Horeb, and thou hast smitten on the rock, and waters have come out from it, and the people have drunk.' And Moses doth so before the eyes of the elders of Israel, ");
INSERT INTO engylt_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","and he calleth the name of the place Massah, and Meribah, because of the 'strife' of the sons of Israel, and because of their 'trying' Jehovah, saying, 'Is Jehovah in our midst or not?' ");
INSERT INTO engylt_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","And Amalek cometh, and fighteth with Israel in Rephidim, ");
INSERT INTO engylt_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","and Moses saith unto Joshua, 'Choose for us men, and go out, fight with Amalek: to-morrow I am standing on the top of the hill, and the rod of God in my hand.' ");
INSERT INTO engylt_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","And Joshua doth as Moses hath said to him, to fight with Amalek, and Moses, Aaron, and Hur, have gone up to the top of the height; ");
INSERT INTO engylt_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","and it hath come to pass, when Moses lifteth up his hand, that Israel hath been mighty, and when he letteth his hands rest, that Amalek hath been mighty. ");
INSERT INTO engylt_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","And the hands of Moses are heavy, and they take a stone, and set it under him, and he sitteth on it: and Aaron and Hur have taken hold on his hands, on this side one, and on that one, and his hands are stedfast till the going in of the sun; ");
INSERT INTO engylt_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","and Joshua weakeneth Amalek and his people by the mouth of the sword. ");
INSERT INTO engylt_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","And Jehovah saith unto Moses, 'Write this, a memorial in a Book, and set it in the ears of Joshua, that I do utterly wipe away the remembrance of Amalek from under the heavens;' ");
INSERT INTO engylt_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","and Moses buildeth an altar, and calleth its name Jehovah-Nissi, ");
INSERT INTO engylt_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","and saith, 'Because a hand is on the throne of Jah, war is to Jehovah with Amalek from generation — generation.' ");
INSERT INTO engylt_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","And Jethro priest of Midian, father-in-law of Moses, heareth all that God hath done for Moses, and for Israel his people, that Jehovah hath brought out Israel from Egypt, ");
INSERT INTO engylt_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","and Jethro, father-in-law of Moses, taketh Zipporah, wife of Moses, besides her parents, ");
INSERT INTO engylt_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","and her two sons, of whom the name of the one is Gershom, for he said, 'a sojourner I have been in a strange land:' ");
INSERT INTO engylt_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","and the name of the other is Eliezer, for, 'the God of my father is for my help, and doth deliver me from the sword of Pharaoh.' ");
INSERT INTO engylt_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","And Jethro, father-in-law of Moses, cometh, and his sons, and his wife, unto Moses, unto the wilderness where he is encamping — the mount of God; ");
INSERT INTO engylt_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","and he saith unto Moses, 'I, thy father-in-law, Jethro, am coming unto thee, and thy wife, and her two sons with her.' ");
INSERT INTO engylt_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","And Moses goeth out to meet his father-in-law, and boweth himself, and kisseth him, and they ask one at another of welfare, and come into the tent; ");
INSERT INTO engylt_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","and Moses recounteth to his father-in-law all that Jehovah hath done to Pharaoh, and to the Egyptians, on account of Israel, all the travail which hath found them in the way, and Jehovah doth deliver them. ");
INSERT INTO engylt_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","And Jethro rejoiceth for all the good which Jehovah hath done to Israel, whom He hath delivered from the hand of the Egyptians; ");
INSERT INTO engylt_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","and Jethro saith, 'Blessed is Jehovah, who hath delivered you from the hand of the Egyptians, and from the hand of Pharaoh — who hath delivered this people from under the hand of the Egyptians; ");
INSERT INTO engylt_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","now I have known that Jehovah is greater than all the gods, for in the thing they have acted proudly — He is above them!' ");
INSERT INTO engylt_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","And Jethro, father-in-law of Moses, taketh a burnt-offering and sacrifices for God; and Aaron cometh in, and all the elders of Israel, to eat bread with the father-in-law of Moses, before God. ");
INSERT INTO engylt_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","And it cometh to pass on the morrow, that Moses sitteth to judge the people, and the people stand before Moses, from the morning unto the evening; ");
INSERT INTO engylt_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","and the father-in-law of Moses seeth all that he is doing to the people, and saith, 'What is this thing which thou art doing to the people? wherefore art thou sitting by thyself, and all the people standing by thee from morning till evening?' ");
INSERT INTO engylt_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","And Moses saith to his father-in-law, 'Because the people come unto me to seek God; ");
INSERT INTO engylt_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","when they have a matter, it hath come unto me, and I have judged between a man and his neighbour, and made known the statutes of God, and His laws.' ");
INSERT INTO engylt_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","And the father-in-law of Moses saith unto him, 'The thing which thou art doing is not good; ");
INSERT INTO engylt_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","thou dost surely wear away, both thou, and this people which is with thee, for the thing is too heavy for thee, thou art not able to do it by thyself. ");
INSERT INTO engylt_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","'Now, hearken to my voice, I counsel thee, and God is with thee: be thou for the people over-against God, and thou hast brought in the things unto God; ");
INSERT INTO engylt_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","and thou hast warned them concerning the statutes and the laws, and hast made known to them the way in which they go, and the work which they do. ");
INSERT INTO engylt_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","'And thou — thou dost provide out of all the people men of ability, fearing God, men of truth, hating dishonest gain, and hast placed these over them, heads of thousands, heads of hundreds, heads of fifties, and heads of tens, ");
INSERT INTO engylt_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","and they have judged the people at all times; and it hath come to pass, every great matter they bring in unto thee, and every small matter they judge themselves; and lighten it from off thyself, and they have borne with thee. ");
INSERT INTO engylt_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If thou dost this thing, and God hath commanded thee, then thou hast been able to stand, and all this people also goeth in unto its place in peace.' ");
INSERT INTO engylt_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","And Moses hearkeneth to the voice of his father-in-law, and doth all that he said, ");
INSERT INTO engylt_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","and Moses chooseth men of ability out of all Israel, and maketh them chiefs over the people, heads of thousands, heads of hundreds, heads of fifties, and heads of tens, ");
INSERT INTO engylt_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","and they have judged the people at all times; the hard matter they bring in unto Moses, and every small matter they judge themselves. ");
INSERT INTO engylt_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","And Moses sendeth his father-in-law away, and he goeth away unto his own land. ");
INSERT INTO engylt_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month of the going out of the sons of Israel from the land of Egypt, in this day they have come into the wilderness of Sinai, ");
INSERT INTO engylt_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","and they journey from Rephidim, and enter the wilderness of Sinai, and encamp in the wilderness; and Israel encampeth there before the mount. ");
INSERT INTO engylt_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","And Moses hath gone up unto God, and Jehovah calleth unto him out of the mount, saying, 'Thus dost thou say to the house of Jacob, and declare to the sons of Israel, ");
INSERT INTO engylt_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ye — ye have seen that which I have done to the Egyptians, and I bear you on eagles' wings, and bring you in unto Myself. ");
INSERT INTO engylt_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","'And now, if ye really hearken to My voice, then ye have kept My covenant, and been to Me a peculiar treasure more than all the peoples, for all the earth is Mine; ");
INSERT INTO engylt_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","and ye — ye are to Me a kingdom of priests and a holy nation: these are the words which thou dost speak unto the sons of Israel.' ");
INSERT INTO engylt_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","And Moses cometh, and calleth for the elders of the people, and setteth before them all these words which Jehovah hath commanded him; ");
INSERT INTO engylt_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","and all the people answer together and say, 'All that Jehovah hath spoken we do;' and Moses returneth the words of the people unto Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","And Jehovah saith unto Moses, 'Lo, I am coming unto thee in the thickness of the cloud, so that the people hear in My speaking with thee, and also believe in thee to the age;' and Moses declareth the words of the people unto Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","And Jehovah saith unto Moses, 'Go unto the people; and thou hast sanctified them to-day and to-morrow, and they have washed their garments, ");
INSERT INTO engylt_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","and have been prepared for the third day; for on the third day doth Jehovah come down before the eyes of all the people, on mount Sinai. ");
INSERT INTO engylt_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","'And thou hast made a border for the people round about, saying, Take heed to yourselves, going up into the mount, or coming against its extremity; whoever is coming against the mount is certainly put to death; ");
INSERT INTO engylt_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","a hand cometh not against him, for he is certainly stoned or shot through, whether beast or man it liveth not; in the drawing out of the jubilee cornet they go up into the mount.' ");
INSERT INTO engylt_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","And Moses cometh down from the mount unto the people, and sanctifieth the people, and they wash their garments; ");
INSERT INTO engylt_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","and he saith unto the people, 'Be ye prepared for the third day, come not nigh unto a woman.' ");
INSERT INTO engylt_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","And it cometh to pass, on the third day, while it is morning, that there are voices, and lightnings, and a heavy cloud, on the mount, and the sound of a trumpet very strong; and all the people who are in the camp do tremble. ");
INSERT INTO engylt_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","And Moses bringeth out the people to meet God from the camp, and they station themselves at the lower part of the mount, ");
INSERT INTO engylt_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","and mount Sinai is wholly a smoke from the presence of Jehovah, who hath come down on it in fire, and its smoke goeth up as smoke of the furnace, and the whole mount trembleth exceedingly; ");
INSERT INTO engylt_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","and the sound of the trumpet is going on, and very strong; Moses speaketh, and God doth answer him with a voice. ");
INSERT INTO engylt_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","And Jehovah cometh down on mount Sinai, unto the top of the mount, and Jehovah calleth for Moses unto the top of the mount, and Moses goeth up. ");
INSERT INTO engylt_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","And Jehovah saith unto Moses, 'Go down, protest to the people, lest they break through unto Jehovah to see, and many of them have fallen; ");
INSERT INTO engylt_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","and also the priests who are coming nigh unto Jehovah do sanctify themselves, lest Jehovah break forth on them.' ");
INSERT INTO engylt_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","And Moses saith unto Jehovah, 'The people is unable to come up unto mount Sinai, for Thou — Thou hast protested to us, saying, Make a border for the mount, then thou hast sanctified it.' ");
INSERT INTO engylt_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","And Jehovah saith unto him, 'Go, descend, then thou hast come up, thou, and Aaron with thee; and the priests and the people do not break through, to come up unto Jehovah, lest He break forth upon them.' ");
INSERT INTO engylt_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","And Moses goeth down unto the people, and saith unto them: — ");
INSERT INTO engylt_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","'And God speaketh all these words, saying, ");
INSERT INTO engylt_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","I am Jehovah thy God, who hath brought thee out of the land of Egypt, out of a house of servants. ");
INSERT INTO engylt_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","'Thou hast no other Gods before Me. ");
INSERT INTO engylt_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","'Thou dost not make to thyself a graven image, or any likeness which is in the heavens above, or which is in the earth beneath, or which is in the waters under the earth. ");
INSERT INTO engylt_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Thou dost not bow thyself to them, nor serve them: for I, Jehovah thy God, am a zealous God, charging iniquity of fathers on sons, on the third generation, and on the fourth, of those hating Me, ");
INSERT INTO engylt_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","and doing kindness to thousands, of those loving Me and keeping My commands. ");
INSERT INTO engylt_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","'Thou dost not take up the name of Jehovah thy God for a vain thing, for Jehovah acquitteth not him who taketh up His name for a vain thing. ");
INSERT INTO engylt_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","'Remember the Sabbath-day to sanctify it; ");
INSERT INTO engylt_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","six days thou dost labour, and hast done all thy work, ");
INSERT INTO engylt_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","and the seventh day is a Sabbath to Jehovah thy God; thou dost not do any work, thou, and thy son, and thy daughter, thy man-servant, and thy handmaid, and thy cattle, and thy sojourner who is within thy gates, — ");
INSERT INTO engylt_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","for six days hath Jehovah made the heavens and the earth, the sea, and all that is in them, and resteth in the seventh day; therefore hath Jehovah blessed the Sabbath-day, and doth sanctify it. ");
INSERT INTO engylt_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","'Honour thy father and thy mother, so that thy days are prolonged on the ground which Jehovah thy God is giving to thee. ");
INSERT INTO engylt_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","'Thou dost not murder. ");
INSERT INTO engylt_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","'Thou dost not commit adultery. ");
INSERT INTO engylt_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","'Thou dost not steal. ");
INSERT INTO engylt_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","'Thou dost not answer against thy neighbour a false testimony. ");
INSERT INTO engylt_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","'Thou dost not desire the house of thy neighbour, thou dost not desire the wife of thy neighbour, or his man-servant, or his handmaid, or his ox, or his ass, or anything which is thy neighbour's.' ");
INSERT INTO engylt_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","And all the people are seeing the voices, and the flames, and the sound of the trumpet, and the mount smoking; and the people see, and move, and stand afar off, ");
INSERT INTO engylt_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","and say unto Moses, 'Speak thou with us, and we hear, and let not God speak with us, lest we die.' ");
INSERT INTO engylt_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","And Moses saith unto the people, 'Fear not, for to try you hath God come, and in order that His fear may be before your faces — that ye sin not.' ");
INSERT INTO engylt_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","And the people stand afar off, and Moses hath drawn nigh unto the thick darkness where God is. ");
INSERT INTO engylt_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","And Jehovah saith unto Moses, 'Thus dost thou say unto the sons of Israel: Ye — ye have seen that from the heavens I have spoken with you; ");
INSERT INTO engylt_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ye do not make with Me gods of silver, even gods of gold ye do not make to yourselves. ");
INSERT INTO engylt_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","'An altar of earth thou dost make for Me, and thou hast sacrificed on it thy burnt-offerings and thy peace-offerings, thy flock and thy herd; in every place where I cause My name to be remembered I come in unto thee, and have blessed thee. ");
INSERT INTO engylt_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","'And if an altar of stones thou dost make to Me, thou dost not build them of hewn work; when thy tool thou hast waved over it, then thou dost pollute it; ");
INSERT INTO engylt_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","neither dost thou go up by steps on Mine altar, that thy nakedness be not revealed upon it. ");
INSERT INTO engylt_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","'And these are the judgments which thou dost set before them: ");
INSERT INTO engylt_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","'When thou buyest a Hebrew servant — six years he doth serve, and in the seventh he goeth out as a freeman for nought; ");
INSERT INTO engylt_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","if by himself he cometh in, by himself he goeth out; if he is owner of a wife, then his wife hath gone out with him; ");
INSERT INTO engylt_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","if his lord give to him a wife, and she hath borne to him sons or daughters — the wife and her children are her lord's, and he goeth out by himself. ");
INSERT INTO engylt_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","'And if the servant really say: I have loved my lord, my wife, and my sons — I do not go out free; ");
INSERT INTO engylt_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then hath his lord brought him nigh unto God, and hath brought him nigh unto the door, or unto the side-post, and his lord hath bored his ear with an awl, and he hath served him — to the age. ");
INSERT INTO engylt_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","'And when a man selleth his daughter for a handmaid, she doth not go out according to the going out of the men-servants; ");
INSERT INTO engylt_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","if evil in the eyes of her lord, so that he hath not betrothed her, then he hath let her be ransomed; to a strange people he hath not power to sell her, in his dealing treacherously with her. ");
INSERT INTO engylt_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","'And if to his son he betroth her, according to the right of daughters he doth to her. ");
INSERT INTO engylt_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","'If another woman he take for him, her food, her covering, and her habitation, he doth not withdraw; ");
INSERT INTO engylt_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","and if these three he do not to her, then she hath gone out for nought, without money. ");
INSERT INTO engylt_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","'He who smiteth a man so that he hath died, is certainly put to death; ");
INSERT INTO engylt_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","as to him who hath not laid wait, and God hath brought to his hand, I have even set for thee a place whither he doth flee. ");
INSERT INTO engylt_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","'And when a man doth presume against his neighbour to slay him with subtilty, from Mine altar thou dost take him to die. ");
INSERT INTO engylt_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","'And he who smiteth his father or his mother is certainly put to death. ");
INSERT INTO engylt_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","'And he who stealeth a man, and hath sold him, and he hath been found in his hand, is certainly put to death. ");
INSERT INTO engylt_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","'And he who is reviling his father or his mother is certainly put to death. ");
INSERT INTO engylt_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","'And when men contend, and a man hath smitten his neighbour with a stone, or with the fist, and he die not, but hath fallen on the bed; ");
INSERT INTO engylt_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","if he rise, and hath gone up and down without on his staff, then hath the smiter been acquitted; only his cessation he giveth, and he is thoroughly healed. ");
INSERT INTO engylt_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","'And when a man smiteth his man-servant or his handmaid, with a rod, and he hath died under his hand — he is certainly avenged; ");
INSERT INTO engylt_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","only if he remain a day, or two days, he is not avenged, for he is his money. ");
INSERT INTO engylt_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","'And when men strive, and have smitten a pregnant woman, and her children have come out, and there is no mischief, he is certainly fined, as the husband of the woman doth lay upon him, and he hath given through the judges; ");
INSERT INTO engylt_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","and if there is mischief, then thou hast given life for life, ");
INSERT INTO engylt_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eye for eye, tooth for tooth, hand for hand, foot for foot, ");
INSERT INTO engylt_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","burning for burning, wound for wound, stripe for stripe. ");
INSERT INTO engylt_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","'And when a man smiteth the eye of his man-servant, or the eye of his handmaid, and hath destroyed it, as a freeman he doth send him away for his eye; ");
INSERT INTO engylt_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","and if a tooth of his man-servant or a tooth of his handmaid he knock out, as a freeman he doth send him away for his tooth. ");
INSERT INTO engylt_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","'And when an ox doth gore man or woman, and they have died, the ox is certainly stoned, and his flesh is not eaten, and the owner of the ox is acquitted; ");
INSERT INTO engylt_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","and if the ox is one accustomed to gore heretofore, and it hath been testified to its owner, and he doth not watch it, and it hath put to death a man or woman, the ox is stoned, and its owner also is put to death. ");
INSERT INTO engylt_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","'If atonement is laid upon him, then he hath given the ransom of his life, according to all that is laid upon him; ");
INSERT INTO engylt_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","whether it gore a son or gore a daughter, according to this judgment it is done to him. ");
INSERT INTO engylt_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","'If the ox gore a man-servant or a handmaid, thirty silver shekels he doth give to their lord, and the ox is stoned. ");
INSERT INTO engylt_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","'And when a man doth open a pit, or when a man doth dig a pit, and doth not cover it, and an ox or ass hath fallen thither, — ");
INSERT INTO engylt_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","the owner of the pit doth repay, money he doth give back to its owner, and the dead is his. ");
INSERT INTO engylt_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","'And when a man's ox doth smite the ox of his neighbour, and it hath died, then they have sold the living ox, and halved its money, and also the dead one they do halve; ");
INSERT INTO engylt_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","or, it hath been known that the ox is one accustomed to gore heretofore, and its owner doth not watch it, he certainly repayeth ox for ox, and the dead is his. ");
INSERT INTO engylt_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","'When a man doth steal an ox or sheep, and hath slaughtered it or sold it, five of the herd he doth repay for the ox, and four of the flock for the sheep. ");
INSERT INTO engylt_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","'If in the breaking through, the thief is found, and he hath been smitten, and hath died, there is no blood for him; ");
INSERT INTO engylt_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","if the sun hath risen upon him, blood is for him, he doth certainly repay; if he have nothing, then he hath been sold for his theft; ");
INSERT INTO engylt_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","if the theft is certainly found in his hand alive, whether ox, or ass, or sheep — double he repayeth. ");
INSERT INTO engylt_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","'When a man depastureth a field or vineyard, and hath sent out his beast, and it hath pastured in the field of another, of the best of his field, and the best of his vineyard, he doth repay. ");
INSERT INTO engylt_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","'When fire goeth forth, and hath found thorns, and a stack, or the standing corn, or the field, hath been consumed, he who causeth the burning doth certainly repay. ");
INSERT INTO engylt_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","'When a man doth give unto his neighbour silver, or vessels to keep, and it hath been stolen out of the man's house; if the thief is found, he repayeth double. ");
INSERT INTO engylt_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","'If the thief is not found, then the master of the house hath been brought near unto God, whether he hath not put forth his hand against the work of his neighbour; ");
INSERT INTO engylt_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","for every matter of transgression, for ox, for ass, for sheep, for raiment, for any lost thing of which it is said that it is his; unto God cometh the matter of them both; he whom God doth condemn, he repayeth double to his neighbour. ");
INSERT INTO engylt_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","'When a man doth give unto his neighbour an ass, or ox, or sheep, or any beast to keep, and it hath died, or hath been hurt, or taken captive, none seeing — ");
INSERT INTO engylt_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","an oath of Jehovah is between them both, that he hath not put forth his hand against the work of his neighbour, and its owner hath accepted, and he doth not repay; ");
INSERT INTO engylt_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","but if it is certainly stolen from him, he doth repay to its owner; ");
INSERT INTO engylt_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","if it is certainly torn, he bringeth it in — a witness; the torn thing he doth not repay. ");
INSERT INTO engylt_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","'And when a man doth ask anything from his neighbour, and it hath been hurt or hath died — its owner not being with it — he doth certainly repay; ");
INSERT INTO engylt_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","if its owner is with it, he doth not repay, — if it is a hired thing, it hath come for its hire. ");
INSERT INTO engylt_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","'And when a man doth entice a virgin who is not betrothed, and hath lain with her, he doth certainly endow her to himself for a wife; ");
INSERT INTO engylt_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","if her father utterly refuse to give her to him, money he doth weigh out according to the dowry of virgins. ");
INSERT INTO engylt_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","'A witch thou dost not keep alive. ");
INSERT INTO engylt_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","'Whoever lieth with a beast is certainly put to death. ");
INSERT INTO engylt_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","'He who is sacrificing to a god, save to Jehovah alone, is devoted. ");
INSERT INTO engylt_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","'And a sojourner thou dost not oppress, nor crush him, for sojourners ye have been in the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","'Any widow or orphan ye do not afflict; ");
INSERT INTO engylt_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","if thou dost really afflict him, surely if he at all cry unto Me, I certainly hear his cry; ");
INSERT INTO engylt_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","and Mine anger hath burned, and I have slain you by the sword, and your wives have been widows, and your sons orphans. ");
INSERT INTO engylt_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","'If thou dost lend My poor people with thee money, thou art not to him as a usurer; thou dost not lay on him usury; ");
INSERT INTO engylt_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","if thou dost at all take in pledge the garment of thy neighbour, during the going in of the sun thou dost return it to him: ");
INSERT INTO engylt_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","for it alone is his covering, it is his garment for his skin; wherein doth he lie down? and it hath come to pass, when he doth cry unto Me, that I have heard, for I am gracious. ");
INSERT INTO engylt_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","'God thou dost not revile, and a prince among thy people thou dost not curse. ");
INSERT INTO engylt_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","'Thy fulness and thy liquids thou dost not delay; the first-born of thy sons thou dost give to Me; ");
INSERT INTO engylt_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","so thou dost to thine ox, to thy sheep; seven days it is with its dam, on the eighth day thou dost give it to Me. ");
INSERT INTO engylt_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","'And ye are holy men to Me, and flesh torn in the field ye do not eat, to a dog ye do cast it. ");
INSERT INTO engylt_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","'Thou dost not lift up a vain report; thou dost not put thy hand with a wicked man to be a violent witness. ");
INSERT INTO engylt_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","'Thou art not after many to evil, nor dost thou testify concerning a strife, to turn aside after many to cause others to turn aside; ");
INSERT INTO engylt_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","and a poor man thou dost not honour in his strife. ");
INSERT INTO engylt_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","'When thou meetest thine enemy's ox or his ass going astray, thou dost certainly turn it back to him; ");
INSERT INTO engylt_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","when thou seest the ass of him who is hating thee crouching under its burden, then thou hast ceased from leaving it to it — thou dost certainly leave it with him. ");
INSERT INTO engylt_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","'Thou dost not turn aside the judgment of thy needy one in his strife; ");
INSERT INTO engylt_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","from a false matter thou dost keep far off, and an innocent and righteous man thou dost not slay; for I do not justify a wicked man. ");
INSERT INTO engylt_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","'And a bribe thou dost not take; for the bribe bindeth the open -eyed, and perverteth the words of the righteous. ");
INSERT INTO engylt_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","'And a sojourner thou dost not oppress, and ye — ye have known the soul of the sojourner, for sojourners ye have been in the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","'And six years thou dost sow thy land, and hast gathered its increase; ");
INSERT INTO engylt_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","and the seventh thou dost release it, and hast left it, and the needy of thy people have eaten, and their leaving doth the beast of the field eat; so dost thou to thy vineyard — to thine olive-yard. ");
INSERT INTO engylt_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","'Six days thou dost do thy work, and on the seventh day thou dost rest, so that thine ox and thine ass doth rest, and the son of thine handmaid and the sojourner is refreshed; ");
INSERT INTO engylt_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","and in all that which I have said unto you ye do take heed; and the name of other gods ye do not mention; it is not heard on thy mouth. ");
INSERT INTO engylt_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","'Three times thou dost keep a feast to Me in a year; ");
INSERT INTO engylt_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","the Feast of Unleavened things thou dost keep; seven days thou dost eat unleavened things, as I have commanded thee, at the time appointed in the month of Abib; for in it thou hast come forth out of Egypt, and ye do not appear in My presence empty; ");
INSERT INTO engylt_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","and the Feast of Harvest, the first fruits of thy works which thou sowest in the field; and the Feast of the In-Gathering, in the outgoing of the year, in thy gathering thy works out of the field. ");
INSERT INTO engylt_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","'Three times in a year do all thy males appear before the face of the Lord Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","'Thou dost not sacrifice on a fermented thing the blood of My sacrifice, and the fat of My festival doth not remain till morning; ");
INSERT INTO engylt_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","the beginning of the first-fruits of thy ground thou dost bring into the house of Jehovah thy God; thou dost not boil a kid in its mother's milk. ");
INSERT INTO engylt_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","'Lo, I am sending a messenger before thee to keep thee in the way, and to bring thee in unto the place which I have prepared; ");
INSERT INTO engylt_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","be watchful because of his presence, and hearken to his voice, rebel not against him, for he beareth not with your transgression, for My name is in his heart; ");
INSERT INTO engylt_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","for, if thou diligently hearken to his voice, and hast done all that which I speak, then I have been at enmity with thine enemies, and have distressed those distressing thee. ");
INSERT INTO engylt_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","'For My messenger goeth before thee, and hath brought thee in unto the Amorite, and the Hittite, and the Perizzite, and the Canaanite, the Hivite, and the Jebusite, and I have cut them off. ");
INSERT INTO engylt_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","'Thou dost not bow thyself to their gods, nor serve them, nor do according to their doings, but dost utterly devote them, and thoroughly break their standing pillars. ");
INSERT INTO engylt_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","'And ye have served Jehovah your God, and He hath blessed thy bread and thy water, and I have turned aside sickness from thine heart; ");
INSERT INTO engylt_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","there is not a miscarrying and barren one in thy land; the number of thy days I fulfil: ");
INSERT INTO engylt_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","My terror I send before thee, and I have put to death all the people among whom thou comest, and I have given the neck of all thine enemies unto thee. ");
INSERT INTO engylt_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","'And I have sent the hornet before thee, and it hath cast out the Hivite, the Canaanite, and the Hittite, from before thee; ");
INSERT INTO engylt_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I cast them not out from before thee in one year, lest the land be a desolation, and the beast of the field hath multiplied against thee; ");
INSERT INTO engylt_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","little by little I cast them out from before thee, till thou art fruitful, and hast inherited the land. ");
INSERT INTO engylt_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","'And I have set thy border from the Red Sea, even unto the sea of the Philistines, and from the wilderness unto the River: for I give into your hand the inhabitants of the land, and thou hast cast them out from before thee; ");
INSERT INTO engylt_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","thou dost not make a covenant with them, and with their gods; ");
INSERT INTO engylt_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","they do not dwell in thy land, lest they cause thee to sin against Me when thou servest their gods, when it becometh a snare to thee.' ");
INSERT INTO engylt_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","And unto Moses He said, 'Come up unto Jehovah, thou, and Aaron, Nadab, and Abihu, and seventy of the elders of Israel, and ye have bowed yourselves afar off;' ");
INSERT INTO engylt_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","and Moses hath drawn nigh by himself unto Jehovah; and they draw not nigh, and the people go not up with him. ");
INSERT INTO engylt_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","And Moses cometh in, and recounteth to the people all the words of Jehovah, and all the judgments, and all the people answer — one voice, and say, 'All the words which Jehovah hath spoken we do.' ");
INSERT INTO engylt_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","And Moses writeth all the words of Jehovah, and riseth early in the morning, and buildeth an altar under the hill, and twelve standing pillars for the twelve tribes of Israel; ");
INSERT INTO engylt_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","and he sendeth the youths of the sons of Israel, and they cause burnt-offerings to ascend, and sacrifice sacrifices of peace-offerings to Jehovah — calves. ");
INSERT INTO engylt_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","And Moses taketh half of the blood, and putteth in basins, and half of the blood hath he sprinkled on the altar; ");
INSERT INTO engylt_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","and he taketh the Book of the Covenant, and proclaimeth in the ears of the people, and they say, 'All that which Jehovah hath spoken we do, and obey.' ");
INSERT INTO engylt_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","And Moses taketh the blood, and sprinkleth on the people, and saith, 'Lo, the blood of the covenant which Jehovah hath made with you, concerning all these things.' ");
INSERT INTO engylt_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","And Moses goeth up, Aaron also, Nadab and Abihu, and seventy of the elders of Israel, ");
INSERT INTO engylt_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","and they see the God of Israel, and under His feet is as the white work of the sapphire, and as the substance of the heavens for purity; ");
INSERT INTO engylt_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","and unto those of the sons of Israel who are near He hath not put forth His hand, and they see God, and eat and drink. ");
INSERT INTO engylt_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","And Jehovah saith unto Moses, 'Come up unto Me to the mount, and be there, and I give to thee the tables of stone, and the law, and the command, which I have written to direct them.' ");
INSERT INTO engylt_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","And Moses riseth — Joshua his minister also — and Moses goeth up unto the mount of God; ");
INSERT INTO engylt_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","and unto the elders he hath said, 'Abide ye for us in this place, until that we turn back unto you, and lo, Aaron and Hur are with you — he who hath matters doth come nigh unto them.' ");
INSERT INTO engylt_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","And Moses goeth up unto the mount, and the cloud covereth the mount; ");
INSERT INTO engylt_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","and the honour of Jehovah doth tabernacle on mount Sinai, and the cloud covereth it six days, and He calleth unto Moses on the seventh day from the midst of the cloud. ");
INSERT INTO engylt_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","And the appearance of the honour of Jehovah is as a consuming fire on the top of the mount, before the eyes of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","and Moses goeth into the midst of the cloud, and goeth up unto the mount, and Moses is on the mount forty days and forty nights. ");
INSERT INTO engylt_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","'Speak unto the sons of Israel, and they take for Me a heave-offering; from every man whose heart impelleth him ye do take My heave-offering. ");
INSERT INTO engylt_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","'And this is the heave-offering which ye take from them; gold, and silver, and brass, ");
INSERT INTO engylt_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","and blue, and purple, and scarlet, and linen, and goats' hair, ");
INSERT INTO engylt_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","and rams' skins made red, and badgers' skins, and shittim wood, ");
INSERT INTO engylt_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oil for the light, spices for the anointing oil, and for the perfume of the spices, ");
INSERT INTO engylt_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","shoham stones, and stones for setting for an ephod, and for a breastplate. ");
INSERT INTO engylt_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","'And they have made for Me a sanctuary, and I have tabernacled in their midst; ");
INSERT INTO engylt_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","according to all that which I am shewing thee, the pattern of the tabernacle, and the pattern of all its vessels, even so ye do make it. ");
INSERT INTO engylt_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","'And they have made an ark of shittim wood; two cubits and a half its length, and a cubit and a half its breadth, and a cubit and a half its height; ");
INSERT INTO engylt_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","and thou hast overlaid it with pure gold, within and without thou dost overlay it, and thou hast made on it a ring of gold round about. ");
INSERT INTO engylt_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","'And thou hast cast for it four rings of gold, and hast put them on its four feet, even two rings on its one side, and two rings on its second side; ");
INSERT INTO engylt_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","and thou hast made staves of shittim wood, and hast overlaid them with gold, ");
INSERT INTO engylt_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","and hast brought the staves into the rings on the sides of the ark, to bear the ark by them, ");
INSERT INTO engylt_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","in the rings of the ark are the staves, they are not turned aside from it; ");
INSERT INTO engylt_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","and thou hast put unto the ark the testimony which I give unto thee. ");
INSERT INTO engylt_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","'And thou hast made a mercy-seat of pure gold, two cubits and a half its length, and a cubit and a half its breadth; ");
INSERT INTO engylt_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","and thou hast made two cherubs of gold, beaten work dost thou make them, at the two ends of the mercy-seat; ");
INSERT INTO engylt_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","and make thou one cherub at the end on this side, and one cherub at the end on that; at the mercy-seat ye do make the cherubs on its two ends. ");
INSERT INTO engylt_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","'And the cherubs have been spreading out wings on high, covering the mercy-seat over with their wings, and their faces are one towards another — towards the mercy-seat are the faces of the cherubs. ");
INSERT INTO engylt_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","'And thou hast put the mercy-seat on the ark above, and unto the ark thou dost put the testimony which I give unto thee; ");
INSERT INTO engylt_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","and I have met with thee there, and have spoken with thee from off the mercy-seat (from between the two cherubs, which are on the ark of the testimony) all that which I command thee concerning the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","'And thou hast made a table of shittim wood, two cubits its length, and a cubit its breadth, and a cubit and a half its height, ");
INSERT INTO engylt_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","and hast overlaid it with pure gold, and hast made for it a crown of gold round about, ");
INSERT INTO engylt_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","and hast made for it a border of a handbreadth round about, and hast made a crown of gold to its border round about. ");
INSERT INTO engylt_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","'And thou hast made to it four rings of gold, and hast put the rings on the four corners, which are to its four feet; ");
INSERT INTO engylt_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","over-against the border are the rings for places for staves to bear the table; ");
INSERT INTO engylt_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","and thou hast made the staves of shittim wood, and hast overlaid them with gold, and the table hath been borne with them; ");
INSERT INTO engylt_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","and thou hast made its dishes, and its bowls, and its covers, and its cups, with which they pour out; of pure gold thou dost make them; ");
INSERT INTO engylt_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","and thou hast put on the table bread of the presence before Me continually. ");
INSERT INTO engylt_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","'And thou hast made a candlestick of pure gold, of beaten work is the candlestick made; its base, and its branch, its calyxes, its knops, and its flowers are of the same; ");
INSERT INTO engylt_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","and six branches are coming out of its sides, three branches of the candlestick out of the one side, and three branches of the candlestick out of the second side; ");
INSERT INTO engylt_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","three calyxes made like almonds in the one branch, a knop and a flower, and three calyxes made like almonds in one branch, a knop and a flower; so for the six branches which are coming out from the candlestick. ");
INSERT INTO engylt_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","'And in the candlestick are four calyxes made like almonds, its knops and its flowers; ");
INSERT INTO engylt_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","and a knop under two branches of the same, and a knop under two branches of the same, and a knop under two branches of the same, are to the six branches which are coming out of the candlestick; ");
INSERT INTO engylt_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","their knops and their branches are of the same, all of it one beaten work of pure gold; ");
INSERT INTO engylt_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","and thou hast made its seven lamps, and one hath caused its lights to go up, and it hath given light over-against its front. ");
INSERT INTO engylt_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","'And its snuffers and its snuff dishes are of pure gold; ");
INSERT INTO engylt_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","of a talent of pure gold he doth make it, with all these vessels. ");
INSERT INTO engylt_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","And see thou and do them by their pattern which thou art shewn in the mount. ");
INSERT INTO engylt_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","'And thou dost make the tabernacle: ten curtains of twined linen, and blue, and purple, and scarlet; with cherubs, work of a designer, thou dost make them; ");
INSERT INTO engylt_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","the length of the one curtain is eight and twenty by the cubit, and the breadth of the one curtain four by the cubit, one measure is to all the curtains; ");
INSERT INTO engylt_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","five of the curtains are joining one unto another, and five curtains are joining one to another. ");
INSERT INTO engylt_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","'And thou hast made loops of blue upon the edge of the one curtain, at the end in the joining; and so thou makest in the edge of the outermost curtain, in the joining of the second. ");
INSERT INTO engylt_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","fifty loops thou dost make in the one curtain, and fifty loops thou dost make in the edge of the curtain which is in the joining of the second, causing the loops to take hold one unto another; ");
INSERT INTO engylt_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","and thou hast made fifty hooks of gold, and hast joined the curtains one to another by the hooks, and the tabernacle hath been one. ");
INSERT INTO engylt_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","'And thou hast made curtains of goats' hair, for a tent over the tabernacle; thou dost make eleven curtains: ");
INSERT INTO engylt_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","the length of the one curtain is thirty by the cubit, and the breadth of the one curtain four by the cubit; one measure is to the eleven curtains; ");
INSERT INTO engylt_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","and thou hast joined the five curtains apart, and the six curtains apart, and hast doubled the six curtains over-against the front of the tent. ");
INSERT INTO engylt_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","'And thou hast made fifty loops on the edge of the one curtain, the outermost in the joining, and fifty loops on the edge of the curtain which is joining the second; ");
INSERT INTO engylt_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","and thou hast made fifty hooks of brass, and hast brought in the hooks into the loops, and hast joined the tent, and it hath been one. ");
INSERT INTO engylt_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","'And the superfluity in the curtains of the tent — the half of the curtain which is superfluous — hath spread over the hinder part of the tabernacle; ");
INSERT INTO engylt_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","and the cubit on this side, and the cubit on that, in the superfluity in the length of the curtains of the tent, is spread out over the sides of the tabernacle, on this and on that, to cover it; ");
INSERT INTO engylt_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","and thou hast made a covering for the tent, of rams' skins made red, and a covering of badgers' skins above. ");
INSERT INTO engylt_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","'And thou hast made the boards for the tabernacle, of shittim wood, standing up; ");
INSERT INTO engylt_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ten cubits is the length of the board, and a cubit and a half the breadth of the one board; ");
INSERT INTO engylt_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","two handles are to the one board, joined one unto another; so thou dost make for all the boards of the tabernacle; ");
INSERT INTO engylt_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","and thou hast made the boards of the tabernacle: twenty boards for the south side southward; ");
INSERT INTO engylt_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","and forty sockets of silver thou dost make under the twenty boards, two sockets under the one board for its two handles, and two sockets under the other board for its two handles. ");
INSERT INTO engylt_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","'And for the second side of the tabernacle, for the north side, are twenty boards, ");
INSERT INTO engylt_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","and their forty sockets of silver, two sockets under the one board, and two sockets under another board. ");
INSERT INTO engylt_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","And for the sides of the tabernacle westward, thou dost make six boards. ");
INSERT INTO engylt_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","And two boards thou dost make for the corners of the tabernacle in the two sides. ");
INSERT INTO engylt_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","And they are pairs beneath, and together they are pairs above its head unto the one ring; so is it for them both, they are for the two corners. ");
INSERT INTO engylt_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","And they have been eight boards, and their sockets of silver are sixteen sockets, two sockets under the one board, and two sockets under another board. ");
INSERT INTO engylt_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","'And thou hast made bars of shittim wood: five for the boards of the one side of the tabernacle, ");
INSERT INTO engylt_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","and five bars for the boards of the second side of the tabernacle, and five bars for the boards of the side of the tabernacle at the two sides, westward; ");
INSERT INTO engylt_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","and one hath caused the middle bar in the midst of the boards to reach from end unto end; ");
INSERT INTO engylt_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","and the boards thou dost overlay with gold, and their rings thou dost make of gold places for bars, and hast overlaid their bars with gold; ");
INSERT INTO engylt_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","and thou hast raised up the tabernacle according to its fashion which thou hast been shewn in the mount. ");
INSERT INTO engylt_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","'And thou hast made a vail of blue, and purple, and scarlet, and twined linen, work of a designer; he maketh it with cherubs; ");
INSERT INTO engylt_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","and thou hast put it on four pillars of shittim wood, overlaid with gold, their pegs are of gold, on four sockets of silver. ");
INSERT INTO engylt_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","'And thou hast put the vail under the hooks, and hast brought in thither within the vail the ark of the testimony; and the vail hath made a separation for you between the holy and the holy of holies. ");
INSERT INTO engylt_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","'And thou hast put the mercy-seat on the ark of the testimony, in the holy of holies. ");
INSERT INTO engylt_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","'And thou hast set the table at the outside of the vail, and the candlestick over-against the table on the side of the tabernacle southward, and the table thou dost put on the north side. ");
INSERT INTO engylt_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","'And thou hast made a covering for the opening of the tent, blue, and purple, and scarlet, and twined linen, work of an embroiderer; ");
INSERT INTO engylt_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","and thou hast made for the covering five pillars of shittim wood, and hast overlaid them with gold, their pegs are of gold, and thou hast cast for them five sockets of brass. ");
INSERT INTO engylt_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","'And thou hast made the altar of shittim wood, five cubits the length, and five cubits the breadth — the altar is square — and three cubits its height. ");
INSERT INTO engylt_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","And thou hast made its horns on its four corners, its horns are of the same, and thou hast overlaid it with brass. ");
INSERT INTO engylt_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","And thou hast made its pots to remove its ashes, and its shovels, and its bowls, and its forks, and its fire-pans, even all its vessels thou dost make of brass. ");
INSERT INTO engylt_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","'And thou hast made for it a grate of net-work of brass, and hast made on the net four rings of brass on its four extremities, ");
INSERT INTO engylt_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","and hast put it under the compass of the altar beneath, and the net hath been unto the middle of the altar. ");
INSERT INTO engylt_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","'And thou hast made staves for the altar, staves of shittim wood, and hast overlaid them with brass. ");
INSERT INTO engylt_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","And the staves have been brought into the rings, and the staves have been on the two sides of the altar in bearing it. ");
INSERT INTO engylt_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hollow with boards thou dost make it, as it hath been shewed thee in the mount, so do they make it. ");
INSERT INTO engylt_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","'And thou hast made the court of the tabernacle: for the south side southward, hangings for the court of twined linen, a hundred by the cubit is the length for the one side, ");
INSERT INTO engylt_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","and its twenty pillars and their twenty sockets are of brass, the pegs of the pillars and their fillets are of silver; ");
INSERT INTO engylt_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","and so for the north side in length, hangings of a hundred cubits in length, and its twenty pillars and their twenty sockets are of brass, the pegs of the pillars and their fillets are of silver. ");
INSERT INTO engylt_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","'And for the breadth of the court at the west side are hangings of fifty cubits, their pillars ten, and their sockets ten. ");
INSERT INTO engylt_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","And for the breadth of the court at the east side, eastward, are fifty cubits. ");
INSERT INTO engylt_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","And the hangings at the side are fifteen cubits, their pillars three, and their sockets three. ");
INSERT INTO engylt_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","And at the second side are hangings fifteen cubits, their pillars three, and their sockets three. ");
INSERT INTO engylt_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","'And for the gate of the court a covering of twenty cubits, blue, and purple, and scarlet, and twined linen, work of an embroiderer; their pillars four, their sockets four. ");
INSERT INTO engylt_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the pillars of the court round about are filleted with silver, their pegs are silver, and their sockets brass. ");
INSERT INTO engylt_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","'The length of the court is a hundred by the cubit, and the breadth fifty by fifty, and the height five cubits, of twined linen, and their sockets are brass, ");
INSERT INTO engylt_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","even all the vessels of the tabernacle, in all its service, and all its pins, and all the pins of the court, are brass. ");
INSERT INTO engylt_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","'And thou — thou dost command the sons of Israel, and they bring unto thee pure beaten olive oil for the light, to cause the lamp to go up continually; ");
INSERT INTO engylt_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","in the tent of meeting, at the outside of the vail, which is over the testimony, doth Aaron — his sons also — arrange it from evening till morning before Jehovah — a statute age-during to their generations, from the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","'And thou, bring thou near unto thee Aaron thy brother, and his sons with him, from the midst of the sons of Israel, for his being priest to Me, even Aaron, Nadab, and Abihu, Eleazar and Ithamar, sons of Aaron; ");
INSERT INTO engylt_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","and thou hast made holy garments for Aaron thy brother, for honour and for beauty; ");
INSERT INTO engylt_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","and thou — thou dost speak unto all the wise of heart, whom I have filled with a spirit of wisdom, and they have made the garments of Aaron to sanctify him for his being priest to Me. ");
INSERT INTO engylt_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","'And these are the garments which they make: a breastplate, and an ephod, and an upper robe, and an embroidered coat, a mitre, and a girdle; yea, they have made holy garments for Aaron thy brother, and for his sons, for his being priest to Me. ");
INSERT INTO engylt_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","'And they take the gold, and the blue, and the purple, and the scarlet, and the linen, ");
INSERT INTO engylt_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","and have made the ephod of gold, blue, and purple, and scarlet, and twined linen, work of a designer; ");
INSERT INTO engylt_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","it hath two shoulders joining at its two ends, and it is joined. ");
INSERT INTO engylt_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","'And the girdle of his ephod which is on him, according to its work, is of the same, of gold, blue, and purple, and scarlet, and twined linen. ");
INSERT INTO engylt_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","'And thou hast taken the two shoham stones, and hast opened on them the names of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","six of their names on the one stone, and the names of the remaining six on the second stone, according to their births; ");
INSERT INTO engylt_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","the work of an engraver in stone, openings of a signet, thou dost open the two stones by the names of the sons of Israel; turned round, embroidered with gold, thou dost make them. ");
INSERT INTO engylt_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","'And thou hast set the two stones on the shoulders of the ephod — stones of memorial to the sons of Israel — and Aaron hath borne their names before Jehovah, on his two shoulders, for a memorial. ");
INSERT INTO engylt_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","'And thou hast made embroidered things of gold, ");
INSERT INTO engylt_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","and two chains of pure gold, wreathed work thou dost make them, work of thick bands, and thou hast put the thick chains on the embroidered things. ");
INSERT INTO engylt_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","'And thou hast made a breastplate of judgment, work of a designer; according to the work of the ephod thou dost make it; of gold, blue, and purple, and scarlet, and twined linen thou dost make it; ");
INSERT INTO engylt_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","it is square, doubled, a span its length, and a span its breadth. ");
INSERT INTO engylt_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","'And thou hast set in it settings of stone, four rows of stone; a row of sardius, topaz, and carbuncle is the first row; ");
INSERT INTO engylt_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","and the second row is emerald, sapphire, and diamond; ");
INSERT INTO engylt_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","and the third row is opal, agate, and amethyst; ");
INSERT INTO engylt_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","and the fourth row is beryl, and onyx, and jasper; embroidered with gold are they in their settings, ");
INSERT INTO engylt_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","and the stones are according to the names of the sons of Israel, twelve, according to their names, openings of a signet, each by his name are they for the twelve tribes. ");
INSERT INTO engylt_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","'And thou hast made on the breastplate wreathed chains, work of thick bands, of pure gold; ");
INSERT INTO engylt_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","and thou hast made on the breastplate two rings of gold, and hast put the two rings on the two ends of the breastplate; ");
INSERT INTO engylt_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","and thou hast put the two thick bands of gold on the two rings at the ends of the breastplate; ");
INSERT INTO engylt_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","and the two ends of the two thick bands thou dost put on the two embroidered things, and thou hast put them on the shoulders of the ephod over-against its face. ");
INSERT INTO engylt_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","'And thou hast made two rings of gold, and hast set them on the two ends of the breastplate, on its border, which is over-against the ephod within; ");
INSERT INTO engylt_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","and thou hast made two rings of gold, and hast put them on the two shoulders of the ephod, beneath, over-against its front, over-against its joining, above the girdle of the ephod, ");
INSERT INTO engylt_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","and they bind the breastplate by its rings unto the rings of the ephod with a ribbon of blue, to be above the girdle of the ephod, and the breastplate is not loosed from the ephod. ");
INSERT INTO engylt_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","'And Aaron hath borne the names of the sons of Israel in the breastplate of judgment, on his heart, in his going in unto the sanctuary, for a memorial before Jehovah continually. ");
INSERT INTO engylt_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","'And thou hast put unto the breastplate of judgment the Lights and the Perfections, and they have been on the heart of Aaron, in his going in before Jehovah, and Aaron hath borne the judgment of the sons of Israel on his heart before Jehovah continually. ");
INSERT INTO engylt_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","'And thou hast made the upper robe of the ephod completely of blue, ");
INSERT INTO engylt_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","and the opening for its head hath been in its midst, a border is to its opening round about, work of a weaver, as the opening of a habergeon there is to it; it is not rent. ");
INSERT INTO engylt_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","'And thou hast made on its hem pomegranates of blue, and purple, and scarlet, on its hem round about, and bells of gold in their midst round about; ");
INSERT INTO engylt_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","a bell of gold and a pomegranate, a bell of gold and a pomegranate are on the hems of the upper robe round about. ");
INSERT INTO engylt_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","'And it hath been on Aaron to minister in, and its sound hath been heard in his coming in unto the sanctuary before Jehovah, and in his going out, and he doth not die. ");
INSERT INTO engylt_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","'And thou hast made a flower of pure gold, and hast opened on it — openings of a signet — 'Holy to Jehovah;' ");
INSERT INTO engylt_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","and thou hast put it on a blue ribbon, and it hath been on the mitre — over-against the front of the mitre it is; ");
INSERT INTO engylt_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","and it hath been on the forehead of Aaron, and Aaron hath borne the iniquity of the holy things which the sons of Israel do hallow, even all their holy gifts; and it hath been on his forehead continually for a pleasing thing for them before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","'And thou hast embroidered the coat of linen, and hast made a mitre of linen, and a girdle thou dost make — work of an embroiderer. ");
INSERT INTO engylt_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","'And for the sons of Aaron thou dost make coats, and thou hast made for them girdles, yea, bonnets thou dost make for them, for honour and for beauty; ");
INSERT INTO engylt_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","and thou hast clothed Aaron thy brother with them, and his sons with him, and hast anointed them, and hast consecrated their hand, and hast sanctified them, and they have been priests to Me. ");
INSERT INTO engylt_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","'And make thou for them linen trousers to cover the naked flesh: they are from the loins even unto the thighs; ");
INSERT INTO engylt_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","and they have been on Aaron and on his sons, in their going in unto the tent of meeting, or in their drawing nigh unto the altar to minister in the sanctuary, and they do not bear iniquity nor have they died; a statute age-during to him, and to his seed after him. ");
INSERT INTO engylt_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","'And this is the thing which thou dost to them, to hallow them, for being priests to Me: Take one bullock, a son of the herd, and two rams, perfect ones, ");
INSERT INTO engylt_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","and bread unleavened, and cakes unleavened anointed with oil, of fine wheaten flour thou dost make them, ");
INSERT INTO engylt_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","and thou hast put them on one basket, and hast brought them near in the basket, also the bullock and the two rams. ");
INSERT INTO engylt_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","'And Aaron and his sons thou dost bring near unto the opening of the tent of meeting, and hast bathed them with water; ");
INSERT INTO engylt_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","and thou hast taken the garments, and hast clothed Aaron with the coat, and the upper robe of the ephod, and the ephod, and the breastplate, and hast girded him with the girdle of the ephod, ");
INSERT INTO engylt_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","and hast set the mitre on his head, and hast put the holy crown on the mitre, ");
INSERT INTO engylt_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","and hast taken the anointing oil, and hast poured it on his head, and hast anointed him. ");
INSERT INTO engylt_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","'And his sons thou dost bring near, and hast clothed them with coats, ");
INSERT INTO engylt_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","and hast girded them with a girdle (Aaron and his sons), and hast bound on them bonnets; and the priesthood hath been theirs by a statute age-during, and thou hast consecrated the hand of Aaron, and the hand of his sons, ");
INSERT INTO engylt_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","and hast brought near the bullock before the tent of meeting, and Aaron hath laid — his sons also — their hands on the head of the bullock. ");
INSERT INTO engylt_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","'And thou hast slaughtered the bullock before Jehovah, at the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","and hast taken of the blood of the bullock, and hast put it on the horns of the altar with thy finger, and all the blood thou dost pour out at the foundation of the altar; ");
INSERT INTO engylt_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","and thou hast taken all the fat which is covering the inwards, and the redundance on the liver, and the two kidneys, and the fat which is on them, and hast made perfume on the altar; ");
INSERT INTO engylt_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","and the flesh of the bullock, and his skin, and his dung, thou dost burn with fire at the outside of the camp; it is a sin-offering. ");
INSERT INTO engylt_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","'And the one ram thou dost take, and Aaron and his sons have laid their hands on the head of the ram, ");
INSERT INTO engylt_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","and thou hast slaughtered the ram, and hast taken its blood, and hast sprinkled it on the altar round about, ");
INSERT INTO engylt_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","and the ram thou dost cut into its pieces, and hast washed its inwards, and its legs, and hast put them on its pieces, and on its head; ");
INSERT INTO engylt_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","and thou hast made perfume with the whole ram on the altar. It is a burnt-offering to Jehovah, a sweet fragrance; a fire-offering it is to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","'And thou hast taken the second ram, and Aaron hath laid — his sons also — their hands on the head of the ram, ");
INSERT INTO engylt_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","and thou hast slaughtered the ram, and hast taken of its blood, and hast put on the tip of the right ear of Aaron, and on the tip of the right ear of his sons, and on the thumb of their right hand, and on the great toe of their right foot, and hast sprinkled the blood on the altar round about; ");
INSERT INTO engylt_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","and thou hast taken of the blood which is on the altar, and of the anointing oil, and hast sprinkled on Aaron, and on his garments, and on his sons, and on the garments of his sons with him, and he hath been hallowed, he, and his garments, and his sons, and the garments of his sons with him. ");
INSERT INTO engylt_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","'And thou hast taken from the ram the fat, and the fat tail, and the fat which is covering the inwards, and the redundance on the liver, and the two kidneys, and the fat which is on them, and the right leg, for it is a ram of consecration, ");
INSERT INTO engylt_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","and one round cake of bread, and one cake of oiled bread, and one thin cake out of the basket of the unleavened things which is before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","'And thou hast set the whole on the hands of Aaron, and on the hands of his sons, and hast waved them — a wave-offering before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","and thou hast taken them out of their hand, and hast made perfume on the altar beside the burnt-offering, for sweet fragrance before Jehovah; a fire-offering it is to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","'And thou hast taken the breast from the ram of the consecration which is for Aaron, and hast waved it — a wave-offering before Jehovah, and it hath become thy portion; ");
INSERT INTO engylt_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","and thou hast sanctified the breast of the wave-offering, and the leg of the heave-offering, which hath been waved, and which hath been lifted up from the ram of the consecration, of that which is for Aaron, and of that which is for his sons; ");
INSERT INTO engylt_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","and it hath been for Aaron and for his sons, by a statute age-during from the sons of Israel, for it is a heave-offering; and it is a heave offering from the sons of Israel, from the sacrifices of their peace-offerings — their heave-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","'And the holy garments which are Aaron's, are for his sons after him, to be anointed in them, and to consecrate in them their hand; ");
INSERT INTO engylt_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","seven days doth the priest in his stead (of his sons) put them on, when he goeth in unto the tent of meeting, to minister in the sanctuary. ");
INSERT INTO engylt_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","'And the ram of the consecration thou dost take, and hast boiled its flesh in the holy place; ");
INSERT INTO engylt_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","and Aaron hath eaten — his sons also — the flesh of the ram, and the bread which is in the basket, at the opening of the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","and they have eaten those things by which there is atonement to consecrate their hand, to sanctify them; and a stranger doth not eat — for they are holy; ");
INSERT INTO engylt_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","and if there be left of the flesh of the consecration or of the bread till the morning, then thou hast burned that which is left with fire; it is not eaten, for it is holy. ");
INSERT INTO engylt_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","'And thou hast done thus to Aaron and to his sons, according to all that I have commanded thee; seven days thou dost consecrate their hand; ");
INSERT INTO engylt_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","and a bullock, a sin-offering, thou dost prepare daily for the atonements, and thou hast atoned for the altar, in thy making atonement on it, and hast anointed it to sanctify it; ");
INSERT INTO engylt_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","seven days thou dost make atonement for the altar, and hast sanctified it, and the altar hath been most holy; all that is coming against the altar is holy. ");
INSERT INTO engylt_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","'And this is that which thou dost prepare on the altar; two lambs, sons of a year, daily continually; ");
INSERT INTO engylt_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","the one lamb thou dost prepare in the morning, and the second lamb thou dost prepare between the evenings; ");
INSERT INTO engylt_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","and a tenth deal of fine flour, mixed with beaten oil, a fourth part of a hin, and a libation, a fourth part of a hin, of wine, is for the one lamb. ");
INSERT INTO engylt_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","'And the second lamb thou dost prepare between the evenings; according to the present of the morning, and according to its libation, thou dost prepare for it, for sweet fragrance, a fire-offering, to Jehovah: — ");
INSERT INTO engylt_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","a continual burnt-offering for your generations, at the opening of the tent of meeting, before Jehovah, whither I am met with you, to speak unto thee there, ");
INSERT INTO engylt_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","and I have met there with the sons of Israel, and it hath been sanctified by My honour. ");
INSERT INTO engylt_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","'And I have sanctified the tent of meeting, and the altar, and Aaron and his sons I sanctify for being priests to Me, ");
INSERT INTO engylt_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","and I have tabernacled in the midst of the sons of Israel, and have become their God, ");
INSERT INTO engylt_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","and they have known that I am Jehovah their God, who hath brought them out of the land of Egypt, that I may tabernacle in their midst; I am Jehovah their God. ");
INSERT INTO engylt_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","'And thou hast made an altar for making perfume; of shittim wood thou dost make it; ");
INSERT INTO engylt_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","a cubit its length, and a cubit its breadth, (it is square), and two cubits its height; its horns are of the same. ");
INSERT INTO engylt_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","'And thou hast overlaid it with pure gold, its top, and its sides round about, and its horns; and thou hast made to it a crown of gold round about; ");
INSERT INTO engylt_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","and two rings of gold thou dost make to it under its crown; on its two ribs thou dost make them, on its two sides, and they have become places for staves, to bear it with them. ");
INSERT INTO engylt_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","'And thou hast made the staves of shittim wood, and hast overlaid them with gold; ");
INSERT INTO engylt_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","and thou hast put it before the vail, which is by the ark of the testimony, before the mercy-seat which is over the testimony, whither I am met with thee. ");
INSERT INTO engylt_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","'And Aaron hath made perfume on it, perfume of spices, morning by morning; in his making the lamps right he doth perfume it, ");
INSERT INTO engylt_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","and in Aaron's causing the lamps to go up between the evenings, he doth perfume it; a continual perfume before Jehovah to your generations. ");
INSERT INTO engylt_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","'Ye do not cause strange perfume to go up upon it, and burnt-offering, and present, and libation ye do not pour out on it; ");
INSERT INTO engylt_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","and Aaron hath made atonement on its horns, once in a year, by the blood of the sin-offering of atonements; once in a year doth he make atonement for it, to your generations; it is most holy to Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","'When thou takest up the sum of the sons of Israel for their numbers, then they have given each an atonement for his soul to Jehovah in their being numbered, and there is no plague among them in their being numbered. ");
INSERT INTO engylt_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","'This they do give, every one passing over unto those numbered, half a shekel, by the shekel of the sanctuary (the shekel is twenty gerahs); half a shekel is the heave-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","every one passing over unto those numbered, from a son of twenty years and upwards, doth give the heave-offering of Jehovah; ");
INSERT INTO engylt_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","the rich doth not multiply, and the poor doth not diminish from the half-shekel, to give the heave-offering of Jehovah, to make atonement for your souls. ");
INSERT INTO engylt_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","'And thou hast taken the atonement-money from the sons of Israel, and hast given it for the service of the tent of meeting; and it hath been to the sons of Israel for a memorial before Jehovah, to make atonement for your souls.' ");
INSERT INTO engylt_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","'And thou hast made a laver of brass (and its base of brass), for washing; and thou hast put it between the tent of meeting and the altar, and hast put water there; ");
INSERT INTO engylt_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","and Aaron and his sons have washed at it their hands and their feet, ");
INSERT INTO engylt_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","in their going in unto the tent of meeting they wash with water, and die not; or in their drawing nigh unto the altar to minister, to perfume a fire-offering to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","then they have washed their hands and their feet, and they die not, and it hath been to them a statute age-during, to him and to his seed to their generations.' ");
INSERT INTO engylt_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","'And thou, take to thyself principal spices, wild honey five hundred shekels; and spice-cinnamon, the half of that, two hundred and fifty; and spice-cane two hundred and fifty; ");
INSERT INTO engylt_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","and cassia five hundred, by the shekel of the sanctuary, and olive oil a hin; ");
INSERT INTO engylt_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","and thou hast made it a holy anointing oil, a compound mixture, work of a compounder; it is a holy anointing oil. ");
INSERT INTO engylt_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","'And thou hast anointed with it the tent of meeting, and the ark of the testimony, ");
INSERT INTO engylt_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","and the table and all its vessels, and the candlestick and its vessels, and the altar of perfume, ");
INSERT INTO engylt_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","and the altar of burnt-offering and all its vessels, and the laver and its base; ");
INSERT INTO engylt_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","and thou hast sanctified them, and they have been most holy; all that is coming against them is holy; ");
INSERT INTO engylt_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","and Aaron and his sons thou dost anoint, and hast sanctified them for being priests to Me. ");
INSERT INTO engylt_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","'And unto the sons of Israel thou dost speak, saying, A holy anointing oil is this to Me, to your generations; ");
INSERT INTO engylt_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","on flesh of man it is not poured, and with its proper proportion ye make none like it; it is holy; it is holy to you; ");
INSERT INTO engylt_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","a man who compoundeth any like it, or who putteth of it on a stranger — hath even been cut off from his people.' ");
INSERT INTO engylt_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","And Jehovah saith unto Moses, 'Take to thee spices, stacte, and onycha, and galbanum, spices and pure frankincense; they are part for part; ");
INSERT INTO engylt_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","and thou hast made it a perfume, a compound, work of a compounder, salted, pure, holy; ");
INSERT INTO engylt_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","and thou hast beaten some of it small, and hast put of it before the testimony, in the tent of meeting, whither I am met with thee; most holy it is to you. ");
INSERT INTO engylt_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","'As to the perfume which thou makest, with its proper proportion ye do not make to yourselves, holy it is to thee to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","a man who maketh any like it — to be refreshed by it — hath even been cut off from his people.' ");
INSERT INTO engylt_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","'See, I have called by name Bezaleel, son of Uri, son of Hur, of the tribe of Judah, ");
INSERT INTO engylt_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","and I fill him with the Spirit of God, in wisdom, and in understanding, and in knowledge, and in all work, ");
INSERT INTO engylt_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","to devise devices to work in gold, and in silver, and in brass, ");
INSERT INTO engylt_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","and in graving of stone for settings, and in graving of wood to work in all work. ");
INSERT INTO engylt_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","'And I, lo, I have given with him Aholiab, son of Ahisamach, of the tribe of Dan, and in the heart of every wise-hearted one I have given wisdom, and they have made all that which I have commanded thee. ");
INSERT INTO engylt_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","'The tent of meeting, and the ark of testimony, and the mercy-seat which is on it, and all the vessels of the tent, ");
INSERT INTO engylt_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","and the table and its vessels, and the pure candlestick and all its vessels, and the altar of the perfume, ");
INSERT INTO engylt_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","and the altar of the burnt-offering and all its vessels, and the laver and its base, ");
INSERT INTO engylt_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","and the coloured garments, and the holy garments for Aaron the priest, and the garments of his sons, for acting as priests in; ");
INSERT INTO engylt_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","and the anointing oil, and the perfume of the spices for the sanctuary; according to all that I have commanded thee — they do.' ");
INSERT INTO engylt_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","'And thou, speak unto the sons of Israel, saying, Only, My sabbaths ye do keep, for it is a sign between Me and you, to your generations, to know that I, Jehovah, am sanctifying you; ");
INSERT INTO engylt_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","and ye have kept the sabbath, for it is holy to you, he who is polluting it is certainly put to death — for any who doeth work in it — that person hath even been cut off from the midst of his people. ");
INSERT INTO engylt_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","'Six days is work done, and in the seventh day is a sabbath of holy rest to Jehovah; any who doeth work in the sabbath-day is certainly put to death, ");
INSERT INTO engylt_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","and the sons of Israel have observed the sabbath; to keep the sabbath to their generations is a covenant age-during, ");
INSERT INTO engylt_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","between Me and the sons of Israel it is a sign — to the age; for six days Jehovah made the heavens and the earth, and in the seventh day He hath ceased, and is refreshed.' ");
INSERT INTO engylt_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","And He giveth unto Moses, when He finisheth speaking with him in mount Sinai, two tables of the testimony, tables of stone, written by the finger of God. ");
INSERT INTO engylt_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","And the people see that Moses is delaying to come down from the mount, and the people assemble against Aaron, and say unto him, 'Rise, make for us gods who go before us, for this Moses — the man who brought us up out of the land of Egypt — we have not known what hath happened to him.' ");
INSERT INTO engylt_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","And Aaron saith unto them, 'Break off the rings of gold which are in the ears of your wives, your sons, and your daughters, and bring in unto me;' ");
INSERT INTO engylt_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","and all the people themselves break off the rings of gold which are in their ears, and bring in unto Aaron, ");
INSERT INTO engylt_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","and he receiveth from their hand, and doth fashion it with a graving tool, and doth make it a molten calf, and they say, 'These thy gods, O Israel, who brought thee up out of the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","And Aaron seeth, and buildeth an altar before it, and Aaron calleth, and saith, 'A festival to Jehovah — to-morrow;' ");
INSERT INTO engylt_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","and they rise early on the morrow, and cause burnt-offerings to ascend, and bring nigh peace-offerings; and the people sit down to eat and to drink, and rise up to play. ");
INSERT INTO engylt_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","And Jehovah saith unto Moses, 'Go, descend, for thy people whom thou hast brought up out of the land of Egypt hath done corruptly, ");
INSERT INTO engylt_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","they have turned aside hastily from the way that I have commanded them; they have made for themselves a molten calf, and bow themselves to it, and sacrifice to it, and say, These thy gods, O Israel, who brought thee up out of the land of Egypt.' ");
INSERT INTO engylt_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","And Jehovah saith unto Moses, 'I have seen this people, and lo, it is a stiff-necked people; ");
INSERT INTO engylt_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","and now, let Me alone, and My anger doth burn against them, and I consume them, and I make thee become a great nation.' ");
INSERT INTO engylt_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","And Moses appeaseth the face of Jehovah his God, and saith, 'Why, O Jehovah, doth Thine anger burn against Thy people, whom Thou hast brought forth out of the land of Egypt with great power and with a strong hand? ");
INSERT INTO engylt_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","why do the Egyptians speak, saying, For evil He brought them out to slay them among mountains, and to consume them from off the face of the ground? turn back from the heat of Thine anger, and repent of the evil against Thy people. ");
INSERT INTO engylt_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","'Be mindful of Abraham, of Isaac, and of Israel, Thy servants, to whom Thou hast sworn by Thyself, and unto whom Thou speakest: I multiply your seed as stars of the heavens, and all this land, as I have said, I give to your seed, and they have inherited to the age;' ");
INSERT INTO engylt_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","and Jehovah repenteth of the evil which He hath spoken of doing to His people. ");
INSERT INTO engylt_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","And Moses turneth, and goeth down from the mount, and the two tables of the testimony are in his hand, tables written on both their sides, on this and on that are they written; ");
INSERT INTO engylt_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","and the tables are the work of God, and the writing is the writing of God, graven on the tables. ");
INSERT INTO engylt_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","And Joshua heareth the voice of the people in their shouting, and saith unto Moses, 'A noise of battle in the camp!' ");
INSERT INTO engylt_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","and he saith, 'It is not the voice of the crying of might, nor is it the voice of the crying of weakness — a voice of singing I am hearing.' ");
INSERT INTO engylt_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","And it cometh to pass, when he hath drawn near unto the camp, that he seeth the calf, and the dancing, and the anger of Moses burneth, and he casteth out of his hands the tables, and breaketh them under the mount; ");
INSERT INTO engylt_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","and he taketh the calf which they have made, and burneth it with fire, and grindeth until it is small, and scattereth on the face of the waters, and causeth the sons of Israel to drink. ");
INSERT INTO engylt_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","And Moses saith unto Aaron, 'What hath this people done to thee, that thou hast brought in upon it a great sin?' ");
INSERT INTO engylt_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","and Aaron saith, 'Let not the anger of my lord burn; thou — thou hast known the people that it is in evil; ");
INSERT INTO engylt_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","and they say to me, Make for us gods, who go before us, for this Moses — the man who brought us up out of the land of Egypt — we have not known what hath happened to him; ");
INSERT INTO engylt_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","and I say to them, Whoso hath gold, let them break it off, and they give to me, and I cast it into the fire, and this calf cometh out.' ");
INSERT INTO engylt_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","And Moses seeth the people that it is unbridled, for Aaron hath made it unbridled for contempt among its withstanders, ");
INSERT INTO engylt_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","and Moses standeth in the gate of the camp, and saith, 'Who is for Jehovah? — unto me!' and all the sons of Levi are gathered unto him; ");
INSERT INTO engylt_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","and he saith to them, 'Thus said Jehovah, God of Israel, Put each his sword by his thigh, pass over and turn back from gate to gate through the camp, and slay each his brother, and each his friend, and each his relation.' ");
INSERT INTO engylt_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","And the sons of Levi do according to the word of Moses, and there fall of the people on that day about three thousand men, ");
INSERT INTO engylt_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","and Moses saith, 'Consecrate your hand to-day to Jehovah, for a man is against his son, and against his brother, so as to bring on you to-day a blessing.' ");
INSERT INTO engylt_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","And it cometh to pass, on the morrow, that Moses saith unto the people, 'Ye — ye have sinned a great sin, and now I go up unto Jehovah, if so be I atone for your sin.' ");
INSERT INTO engylt_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","And Moses turneth back unto Jehovah, and saith, 'Oh this people hath sinned a great sin, that they make to themselves a god of gold; ");
INSERT INTO engylt_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","and now, if Thou takest away their sin — and if not — blot me, I pray thee, out of Thy book which Thou hast written.' ");
INSERT INTO engylt_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","And Jehovah saith unto Moses, 'Whoso hath sinned against Me — I blot him out of My book; ");
INSERT INTO engylt_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","and now, go, lead the people whithersoever I have spoken to thee of; lo, My messenger goeth before thee, and in the day of my charging — then I have charged upon them their sin.' ");
INSERT INTO engylt_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","And Jehovah plagueth the people, because they made the calf which Aaron made. ");
INSERT INTO engylt_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","And Jehovah speaketh unto Moses, 'Go, ascend from this place, thou and the people, whom thou hast brought up out of the land of Egypt, unto the land which I have sworn to Abraham, to Isaac, and to Jacob, saying, To thy seed I give it,' ");
INSERT INTO engylt_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","(and I have sent before thee a messenger, and have cast out the Canaanite, the Amorite, and the Hittite, and the Perizzite, the Hivite, and the Jebusite,) ");
INSERT INTO engylt_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","unto a land flowing with milk and honey, for I do not go up in thy midst, for thou art a stiff-necked people — lest I consume thee in the way.' ");
INSERT INTO engylt_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","And the people hear this sad thing, and mourn; and none put his ornaments on him. ");
INSERT INTO engylt_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","And Jehovah saith unto Moses, 'Say unto the sons of Israel, Ye are a stiff-necked people; one moment — I come up into thy midst, and have consumed thee; and now, put down thine ornaments from off thee, and I know what I do to thee;' ");
INSERT INTO engylt_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","and the sons of Israel take off their ornaments at mount Horeb. ");
INSERT INTO engylt_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","And Moses taketh the tent, and hath stretched it out at the outside of the camp, afar off from the camp, and hath called it, 'Tent of Meeting;' and it hath come to pass, every one seeking Jehovah goeth out unto the tent of meeting, which is at the outside of the camp. ");
INSERT INTO engylt_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","And it hath come to pass, at the going out of Moses unto the tent, all the people rise, and have stood, each at the opening of his tent, and have looked expectingly after Moses, until his going into the tent. ");
INSERT INTO engylt_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","And it hath come to pass, at the going in of Moses to the tent, the pillar of the cloud cometh down, and hath stood at the opening of the tent, and He hath spoken with Moses; ");
INSERT INTO engylt_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","and all the people have seen the pillar of the cloud standing at the opening of the tent, and all the people have risen and bowed themselves, each at the opening of his tent. ");
INSERT INTO engylt_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","And Jehovah hath spoken unto Moses face unto face, as a man speaketh unto his friend; and he hath turned back unto the camp, and his minister Joshua, son of Nun, a youth, departeth not out of the tent. ");
INSERT INTO engylt_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","And Moses saith unto Jehovah, 'See, Thou art saying unto me, Bring up this people, and Thou hast not caused me to know whom Thou dost send with me; and Thou hast said, I have known thee by name, and also thou hast found grace in Mine eyes. ");
INSERT INTO engylt_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","'And now, if, I pray Thee, I have found grace in Thine eyes, cause me to know, I pray Thee, Thy way, and I know Thee, so that I find grace in Thine eyes, and consider that this nation is Thy people;' ");
INSERT INTO engylt_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","and He saith, 'My presence doth go, and I have given rest to thee.' ");
INSERT INTO engylt_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","And he saith unto Him, 'If Thy presence is not going — take us not up from this place; ");
INSERT INTO engylt_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","and in what is it known now, that I have found grace in Thine eyes — I and Thy people — is it not in Thy going with us? and we have been distinguished — I and Thy people — from all the people who are on the face of the ground.' ");
INSERT INTO engylt_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","And Jehovah saith unto Moses, 'Even this thing which thou hast spoken I do; for thou hast found grace in Mine eyes, and I know thee by name.' ");
INSERT INTO engylt_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","And he saith, 'Shew me, I pray Thee, Thine honour;' ");
INSERT INTO engylt_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","and He saith, 'I cause all My goodness to pass before thy face, and have called concerning the Name of Jehovah before thee, and favoured him whom I favour, and loved him whom I love.' ");
INSERT INTO engylt_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","He saith also, 'Thou art unable to see My face, for man doth not see Me, and live;' ");
INSERT INTO engylt_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Jehovah also saith, 'Lo, a place is by Me, and thou hast stood on the rock, ");
INSERT INTO engylt_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","and it hath come to pass, in the passing by of Mine honour, that I have set thee in a cleft of the rock, and spread out My hands over thee, until My passing by, ");
INSERT INTO engylt_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","and I have turned aside My hands, and thou hast seen My back parts, and My face is not seen.' ");
INSERT INTO engylt_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","And Jehovah saith unto Moses, 'Hew for thyself two tables of stone like the first, and I have written on the tables the words which were on the first tables which thou hast broken; ");
INSERT INTO engylt_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","and be prepared at morning, and thou hast come up in the morning unto mount Sinai, and hast stood before Me there, on the top of the mount, ");
INSERT INTO engylt_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","and no man cometh up with thee, and also no man is seen in all the mount, also the flock and the herd do not feed over-against that mount.' ");
INSERT INTO engylt_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","And he heweth two tables of stone like the first, and Moses riseth early in the morning, and goeth up unto mount Sinai, as Jehovah commanded him, and he taketh in his hand two tables of stone. ");
INSERT INTO engylt_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","And Jehovah cometh down in a cloud, and stationeth Himself with him there, and calleth in the Name of Jehovah, ");
INSERT INTO engylt_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","and Jehovah passeth over before his face, and calleth: 'Jehovah, Jehovah God, merciful and gracious, slow to anger, and abundant in kindness and truth, ");
INSERT INTO engylt_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","keeping kindness for thousands, taking away iniquity, and transgression, and sin, and not entirely acquitting, charging iniquity of fathers on children, and on children's children, on a third generation, and on a fourth.' ");
INSERT INTO engylt_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","And Moses hasteth, and boweth to the earth, and doth obeisance, ");
INSERT INTO engylt_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","and saith, 'If, I pray Thee, I have found grace in Thine eyes, O my Lord, let my Lord, I pray Thee, go in our midst (for it is a stiff-necked people), and thou hast forgiven our iniquity and our sin, and hast inherited us.' ");
INSERT INTO engylt_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","And He saith, 'Lo, I am making a covenant: before all thy people I do wonders, which have not been done in all the earth, or in any nation, and all the people in whose midst thou art have seen the work of Jehovah, for it is fearful that which I am doing with thee. ");
INSERT INTO engylt_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","'Observe for thyself that which I am commanding thee to-day: lo, I am casting out from before thee the Amorite, and the Canaanite, and the Hittite, and the Perizzite, and the Hivite, and the Jebusite; ");
INSERT INTO engylt_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","take heed to thyself, lest thou make a covenant with the inhabitant of the land into which thou art going, lest it become a snare in thy midst; ");
INSERT INTO engylt_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","for their altars ye break down, and their standing pillars ye shiver, and its shrines ye cut down; ");
INSERT INTO engylt_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","for ye do not bow yourselves to another god — for Jehovah, whose name is Zealous, is a zealous God. ");
INSERT INTO engylt_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","'Lest thou make a covenant with the inhabitant of the land, and they have gone a-whoring after their gods, and have sacrificed to their gods, and one hath called to thee, and thou hast eaten of his sacrifice, ");
INSERT INTO engylt_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","and thou hast taken of their daughters to thy sons, and their daughters have gone a-whoring after their gods, and have caused thy sons to go a-whoring after their gods; ");
INSERT INTO engylt_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","a molten god thou dost not make to thyself. ");
INSERT INTO engylt_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","'The feast of unleavened things thou dost keep; seven days thou dost eat unleavened things, as I have commanded thee, at an appointed time, the month of Abib: for in the month of Abib thou didst come out from Egypt. ");
INSERT INTO engylt_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","'All opening a womb are Mine, and every firstling of thy cattle born a male, ox or sheep; ");
INSERT INTO engylt_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","and the firstling of an ass thou dost ransom with a lamb; and if thou dost not ransom, then thou hast beheaded it; every first-born of thy sons thou dost ransom, and they do not appear before Me empty. ");
INSERT INTO engylt_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","'Six days thou dost work, and on the seventh day thou dost rest; in ploughing-time and in harvest thou dost rest. ");
INSERT INTO engylt_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","'And a feast of weeks thou dost observe for thyself; first-fruits of wheat-harvest; and the feast of in-gathering, at the revolution of the year. ");
INSERT INTO engylt_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","'Three times in a year do all thy males appear before the Lord Jehovah, God of Israel; ");
INSERT INTO engylt_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","for I dispossess nations from before thee, and have enlarged thy border, and no man doth desire thy land in thy going up to appear before Jehovah thy God three times in a year. ");
INSERT INTO engylt_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","'Thou dost not slaughter with a fermented thing the blood of My sacrifice; and the sacrifice of the feast of the passover doth not remain till morning: ");
INSERT INTO engylt_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","the first of the first-fruits of the land thou dost bring into the house of Jehovah thy God; thou dost not boil a kid in its mother's milk.' ");
INSERT INTO engylt_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","And Jehovah saith unto Moses, 'Write for thyself these words, for, according to the tenor of these words I have made with thee a covenant, and with Israel.' ");
INSERT INTO engylt_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","And he is there with Jehovah forty days and forty nights; bread he hath not eaten, and water he hath not drunk; and he writeth on the tables the matters of the covenant — the ten matters. ");
INSERT INTO engylt_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","And it cometh to pass, when Moses is coming down from mount Sinai (and the two tables of the testimony are in the hand of Moses in his coming down from the mount), that Moses hath not known that the skin of his face hath shone in His speaking with him, ");
INSERT INTO engylt_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","and Aaron seeth — all the sons of Israel also — Moses, and lo, the skin of his face hath shone, and they are afraid of coming nigh unto him. ");
INSERT INTO engylt_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","And Moses calleth unto them, and Aaron and all the princes in the company return unto him, and Moses speaketh unto them; ");
INSERT INTO engylt_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","and afterwards have all the sons of Israel come nigh, and he chargeth them with all that Jehovah hath spoken with him in mount Sinai. ");
INSERT INTO engylt_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","And Moses finisheth speaking with them, and putteth on his face a vail; ");
INSERT INTO engylt_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","and in the going in of Moses before Jehovah to speak with Him, he turneth aside the vail until his coming out; and he hath come out and hath spoken unto the sons of Israel that which he is commanded; ");
INSERT INTO engylt_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","and the sons of Israel have seen the face of Moses that the skin of the face of Moses hath shone, and Moses hath put back the vail on his face until his going in to speak with Him. ");
INSERT INTO engylt_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","And Moses assembleth all the company of the sons of Israel, and saith unto them, 'These are the things which Jehovah hath commanded — to do them: ");
INSERT INTO engylt_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Six days is work done, and on the seventh day there is to you a holy day, a sabbath of rest to Jehovah; any who doeth work in it is put to death; ");
INSERT INTO engylt_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ye do not burn a fire in any of your dwellings on the sabbath-day.' ");
INSERT INTO engylt_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","And Moses speaketh unto all the company of the sons of Israel, saying, 'This is the thing which Jehovah hath commanded, saying, ");
INSERT INTO engylt_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Take ye from among you a heave-offering to Jehovah; every one whose heart is willing doth bring it, — the heave-offering of Jehovah, — gold, and silver, and brass, ");
INSERT INTO engylt_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","and blue, and purple, and scarlet, and linen, and goats' hair, ");
INSERT INTO engylt_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","and rams' skins made red, and badgers' skins, and shittim wood, ");
INSERT INTO engylt_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","and oil for the light, and spices for the anointing oil, and for the spice perfume, ");
INSERT INTO engylt_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","and shoham stones, and stones for settings, for an ephod, and for a breastplate. ");
INSERT INTO engylt_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","'And all the wise-hearted among you come in, and make all that Jehovah hath commanded: ");
INSERT INTO engylt_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","'The tabernacle, its tent, and its covering, its hooks, and its boards, its bars, its pillars, and its sockets, ");
INSERT INTO engylt_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","'The ark and its staves, the mercy-seat, and the vail of the covering, ");
INSERT INTO engylt_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","'The table and its staves, and all its vessels, and the bread of the presence, ");
INSERT INTO engylt_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","'And the candlestick for the light, and its vessels, and its lamps, and the oil for the light, ");
INSERT INTO engylt_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","'And the altar of perfume, and its staves, and the anointing oil, and the spice perfume, and the covering of the opening at the opening of the tabernacle, ");
INSERT INTO engylt_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","'The altar of burnt-offering and the brazen grate which it hath, its staves, and all its vessels, the laver and its base, ");
INSERT INTO engylt_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","'The hangings of the court, its pillars, and their sockets, and the covering of the gate of the court, ");
INSERT INTO engylt_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","'The pins of the tabernacle, and the pins of the court, and their cords, ");
INSERT INTO engylt_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","'The coloured garments, to do service in the sanctuary, the holy garments for Aaron the priest, and the garments of his sons to act as priest in.' ");
INSERT INTO engylt_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","And all the company of the sons of Israel go out from the presence of Moses, ");
INSERT INTO engylt_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","and they come in — every man whom his heart hath lifted up, and every one whom his spirit hath made willing — they have brought in the heave-offering of Jehovah for the work of the tent of meeting, and for all its service, and for the holy garments. ");
INSERT INTO engylt_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","And they come in — the men with the women — every willing-hearted one — they have brought in nose-ring, and ear-ring, and seal-ring, and necklace, all golden goods, even every one who hath waved a wave-offering of gold to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","And every man with whom hath been found blue, and purple, and scarlet, and linen, and goats' hair, and rams' skins made red, and badgers' skins, have brought them in; ");
INSERT INTO engylt_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","every one lifting up a heave-offering of silver and brass have brought in the heave-offering of Jehovah; and every one with whom hath been found shittim wood for any work of the service brought it in. ");
INSERT INTO engylt_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","And every wise-hearted woman hath spun with her hands, and they bring in yarn, the blue, and the purple, the scarlet, and the linen; ");
INSERT INTO engylt_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","and all the women whose heart hath lifted them up in wisdom, have spun the goats' hair. ");
INSERT INTO engylt_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","And the princes have brought in the shoham stones, and the stones for settings, for the ephod, and for the breastplate, ");
INSERT INTO engylt_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","and the spices, and the oil for the light, and for the anointing oil, and for the spice perfume; ");
INSERT INTO engylt_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","every man and woman (whom their heart hath made willing to bring in for all the work which Jehovah commanded to be done by the hand of Moses) of the sons of Israel brought in a willing-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","And Moses saith unto the sons of Israel, 'See, Jehovah hath called by name Bezaleel, son of Uri, son of Hur, of the tribe of Judah, ");
INSERT INTO engylt_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","and He doth fill him with the Spirit of God, in wisdom, in understanding, and in knowledge, and in all work, ");
INSERT INTO engylt_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","even to devise devices to work in gold, and in silver, and in brass, ");
INSERT INTO engylt_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","and in graving of stones for settings, and in graving of wood to work in any work of design. ");
INSERT INTO engylt_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","'And to direct He hath put in his heart, he and Aholiab, son of Ahisamach, of the tribe of Dan; ");
INSERT INTO engylt_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He hath filled them with wisdom of heart to do every work, of engraver, and designer, and embroiderer (in blue, and in purple, in scarlet, and in linen), and weaver, who do any work, and of designers of designs. ");
INSERT INTO engylt_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","And Bezaleel, and Aholiab, and every wise-hearted man, in whom Jehovah hath given wisdom and understanding to know to do every work of the service of the sanctuary, have done according to all that Jehovah commanded. ");
INSERT INTO engylt_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","And Moses calleth unto Bezaleel, and unto Aholiab, and unto every wise-hearted man in whose heart Jehovah hath given wisdom, every one whom his heart lifted up, to come near unto the work to do it. ");
INSERT INTO engylt_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","And they take from before Moses all the heave-offering which the sons of Israel have brought in for the work of the service of the sanctuary to do it; and still they have brought in unto him a willing-offering morning by morning. ");
INSERT INTO engylt_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","And all the wise men, who are doing all the work of the sanctuary, come each from his work which they are doing, ");
INSERT INTO engylt_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","and speak unto Moses, saying, 'The people are multiplying to bring in more than sufficient for the service of the work which Jehovah commanded to make.' ");
INSERT INTO engylt_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","And Moses commandeth, and they cause a voice to pass over through the camp, saying, 'Let not man or woman make any more work for the heave-offering of the sanctuary;' and the people are restrained from bringing, ");
INSERT INTO engylt_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","and the work hath been sufficient for them, for all the work, to do it, and to leave. ");
INSERT INTO engylt_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","And all the wise-hearted ones among the doers of the work make the tabernacle; ten curtains of twined linen, and blue, and purple, and scarlet, with cherubs, work of a designer, he hath made them. ");
INSERT INTO engylt_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","The length of the one curtain is eight and twenty by the cubit, and the breadth of the one curtain four by the cubit; one measure is to all the curtains. ");
INSERT INTO engylt_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","And he joineth the five curtains one unto another, and the other five curtains he hath joined one unto another; ");
INSERT INTO engylt_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","and he maketh loops of blue on the edge of the one curtain, at the end, in the joining; so he hath made in the edge of the outmost curtain, in the joining of the second; ");
INSERT INTO engylt_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","fifty loops he hath made in the one curtain, and fifty loops hath he made in the end of the curtain which is in the joining of the second; the loops are taking hold one on another. ");
INSERT INTO engylt_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","And he maketh fifty hooks of gold, and joineth the curtains one unto another by the hooks, and the tabernacle is one. ");
INSERT INTO engylt_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","And he maketh curtains of goats' hair for a tent over the tabernacle; eleven curtains he hath made them; ");
INSERT INTO engylt_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","the length of the one curtain is thirty by the cubit, and the breadth of the one curtain is four cubits; one measure is to the eleven curtains; ");
INSERT INTO engylt_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","and he joineth the five curtains apart, and the six curtains apart. ");
INSERT INTO engylt_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","And he maketh fifty loops on the outer edge of the curtain, in the joining; and fifty loops he hath made on the edge of the curtain which is joining the second; ");
INSERT INTO engylt_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","and he maketh fifty hooks of brass to join the tent — to be one; ");
INSERT INTO engylt_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","and he maketh a covering for the tent of rams' skins made red, and a covering of badgers' skins above. ");
INSERT INTO engylt_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","And he maketh the boards for the tabernacle of shittim wood, standing up; ");
INSERT INTO engylt_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ten cubits is the length of the one board, and a cubit and a half the breadth of the one board; ");
INSERT INTO engylt_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","two handles are to the one board, joined one unto another; so he hath made for all the boards of the tabernacle. ");
INSERT INTO engylt_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","And he maketh the boards for the tabernacle; twenty boards for the south side southward; ");
INSERT INTO engylt_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","and forty sockets of silver he hath made under the twenty boards, two sockets under the one board for its two handles, and two sockets under the other board for its two handles. ");
INSERT INTO engylt_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","And for the second side of the tabernacle, for the north side, he hath made twenty boards, ");
INSERT INTO engylt_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","and their forty sockets of silver, two sockets under the one board, and two sockets under the other board; ");
INSERT INTO engylt_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","and for the sides of the tabernacle, westward, hath he made six boards; ");
INSERT INTO engylt_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","and two boards hath he made for the corners of the tabernacle, in the two sides; ");
INSERT INTO engylt_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","and they have been twins below, and together they are twins at its head, at the one ring; so he hath done to both of them at the two corners; ");
INSERT INTO engylt_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","and there have been eight boards; and their sockets of silver are sixteen sockets, two sockets under the one board. ");
INSERT INTO engylt_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","And he maketh bars of shittim wood, five for the boards of the one side of the tabernacle, ");
INSERT INTO engylt_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","and five bars for the boards of the second side of the tabernacle, and five bars for the boards of the tabernacle, for the sides westward; ");
INSERT INTO engylt_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","and he maketh the middle bar to enter into the midst of the boards from end to end; ");
INSERT INTO engylt_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","and the boards he hath overlaid with gold, and their rings he hath made of gold, places for bars, and he overlayeth the bars with gold. ");
INSERT INTO engylt_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","And he maketh the vail of blue, and purple, and scarlet, and twined linen, work of a designer he hath made it, with cherubs; ");
INSERT INTO engylt_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","and he maketh for it four pillars of shittim wood, and overlayeth them with gold; their pegs are of gold; and he casteth for them four sockets of silver. ");
INSERT INTO engylt_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","And he maketh a covering for the opening of the tent, of blue, and purple, and scarlet, and twined linen, work of an embroiderer, ");
INSERT INTO engylt_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","also its five pillars, and their pegs; and he overlaid their tops and their fillets with gold, and their five sockets are brass. ");
INSERT INTO engylt_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","And Bezaleel maketh the ark of shittim wood, two cubits and a half its length, and a cubit and a half its breadth, and a cubit and a half its height; ");
INSERT INTO engylt_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","and he overlayeth it with pure gold within and without, and maketh for it a wreath of gold round about; ");
INSERT INTO engylt_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","and he casteth for it four rings of gold, on its four feet, even two rings on its one side, and two rings on its second side; ");
INSERT INTO engylt_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","and he maketh staves of shittim wood, and overlayeth them with gold, ");
INSERT INTO engylt_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","and he bringeth in the staves into the rings, by the sides of the ark, to bear the ark. ");
INSERT INTO engylt_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","And he maketh a mercy-seat of pure gold, two cubits and a half its length, and a cubit and a half its breadth; ");
INSERT INTO engylt_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","and he maketh two cherubs of gold, of beaten work he hath made them, at the two ends of the mercy-seat; ");
INSERT INTO engylt_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","one cherub at the end on this side, and one cherub at the end on that, out of the mercy-seat he hath made the cherubs, at its two ends; ");
INSERT INTO engylt_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","and the cherubs are spreading out wings on high, covering over the mercy-seat with their wings, and their faces are one towards another; towards the mercy-seat have the faces of the cherubs been. ");
INSERT INTO engylt_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","And he maketh the table of shittim wood; two cubits its length, and a cubit its breadth, and a cubit and a half its height, ");
INSERT INTO engylt_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","and overlayeth it with pure gold, and maketh for it a wreath of gold round about. ");
INSERT INTO engylt_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","And he maketh for it a border of a handbreadth round about, and maketh a wreath of gold for its border round about; ");
INSERT INTO engylt_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","and he casteth for it four rings of gold, and putteth the rings on the four corners which are to its four feet; ");
INSERT INTO engylt_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","over-against the border have the rings been, places for staves to bear the table. ");
INSERT INTO engylt_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","And he maketh the staves of shittim wood, and overlayeth them with gold, to bear the table; ");
INSERT INTO engylt_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","and he maketh the vessels which are upon the table, its dishes, and its bowls, and its cups, and the cups by which they pour out, of pure gold. ");
INSERT INTO engylt_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","And he maketh the candlestick of pure gold; of beaten work he hath made the candlestick, its base, and its branch, its calyxes, its knops, and its flowers, have been of the same; ");
INSERT INTO engylt_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","and six branches are coming out of its sides, three branches of the candlestick out of its one side, and three branches of the candlestick out of its second side; ");
INSERT INTO engylt_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","three calyxes, made like almonds, in the one branch, a knop and a flower; and three calyxes, made like almonds, in another branch, a knop and a flower; so to the six branches which are coming out of the candlestick. ");
INSERT INTO engylt_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","And in the candlestick are four calyxes, made like almonds, its knops, and its flowers, ");
INSERT INTO engylt_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","and a knop under the two branches of the same, and a knop under the two branches of the same, and a knop under the two branches of the same, are to the six branches which are coming out of it; ");
INSERT INTO engylt_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","their knops and their branches have been of the same; all of it one beaten work of pure gold. ");
INSERT INTO engylt_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","And he maketh its seven lamps, and its snuffers, and its snuff-dishes, of pure gold; ");
INSERT INTO engylt_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","of a talent of pure gold he hath made it, and all its vessels. ");
INSERT INTO engylt_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","And he maketh the perfume-altar of shittim wood; a cubit its length, and a cubit its breadth (square), and two cubits its height; its horns have been of the same; ");
INSERT INTO engylt_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","and he overlayeth it with pure gold, its top and its sides round about, and its horns; and he maketh for it a wreath of gold round about; ");
INSERT INTO engylt_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","and two rings of gold he hath made for it under its wreath, at its two corners, at its two sides, for places for staves to bear it with them. ");
INSERT INTO engylt_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","And he maketh the staves of shittim wood, and overlayeth them with gold; ");
INSERT INTO engylt_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","and he maketh the holy anointing oil, and the pure spice-perfume — work of a compounder. ");
INSERT INTO engylt_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","And he maketh the altar of burnt-offering of shittim wood, five cubits its length, and five cubits its breadth (square), and three cubits its height; ");
INSERT INTO engylt_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","and he maketh its horns on its four corners; its horns have been of the same; and he overlayeth it with brass; ");
INSERT INTO engylt_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","and he maketh all the vessels of the altar, the pots, and the shovels, and the sprinkling-pans, the forks, and the fire-pans; all its vessels he hath made of brass. ");
INSERT INTO engylt_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","And he maketh for the altar a brazen grate of net-work, under its border beneath, unto its midst; ");
INSERT INTO engylt_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","and he casteth four rings for the four ends of the brazen grate — places for bars; ");
INSERT INTO engylt_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","and he maketh the staves of shittim wood, and overlayeth them with brass; ");
INSERT INTO engylt_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","and he bringeth in the staves into the rings on the sides of the altar, to bear it with them; hollow with boards he made it. ");
INSERT INTO engylt_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","And he maketh the laver of brass, and its base of brass, with the looking-glasses of the women assembling, who have assembled at the opening of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","And he maketh the court; at the south side southward, the hangings of the court of twined linen, a hundred by the cubit, ");
INSERT INTO engylt_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","their pillars are twenty, and their brazen sockets twenty, the pegs of the pillars and their fillets are silver; ");
INSERT INTO engylt_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","and at the north side, a hundred by the cubit, their pillars are twenty, and their sockets of brass twenty; the pegs of the pillars and their fillets are silver; ");
INSERT INTO engylt_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","and at the west side are hangings, fifty by the cubit; their pillars are ten, and their sockets ten; the pegs of the pillars and their fillets are silver; ");
INSERT INTO engylt_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","and at the east side eastward fifty cubits. ");
INSERT INTO engylt_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","The hangings on the side are fifteen cubits, their pillars three, and their sockets three, ");
INSERT INTO engylt_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","and at the second side at the gate of the court, on this and on that, are hangings, fifteen cubits, their pillars three, and their sockets three; ");
INSERT INTO engylt_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","all the hangings of the court round about are of twined linen, ");
INSERT INTO engylt_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","and the sockets for the pillars of brass, the pegs of the pillars and their fillets of silver, and the overlaying of their tops of silver, and all the pillars of the court are filleted with silver. ");
INSERT INTO engylt_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","And the covering of the gate of the court is the work of an embroiderer, of blue, and purple, and scarlet, and twined linen; and twenty cubits is the length, and the height with the breadth five cubits, over-against the hangings of the court; ");
INSERT INTO engylt_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","and their pillars are four, and their sockets of brass four, their pegs are of silver, and the overlaying of their tops and their fillets are of silver; ");
INSERT INTO engylt_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","and all the pins for the tabernacle, and for the court round about, are of brass. ");
INSERT INTO engylt_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","These are the numberings of the tabernacle (the tabernacle of testimony), which hath been numbered by the command of Moses, the service of the Levites, by the hand of Ithamar son of Aaron the priest. ");
INSERT INTO engylt_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","And Bezaleel son of Uri, son of Hur, of the tribe of Judah, hath made all that Jehovah commanded Moses; ");
INSERT INTO engylt_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","and with him is Aholiab son of Ahisamach, of the tribe of Dan, an engraver, and designer, and embroiderer in blue, and in purple, and in scarlet, and in linen. ");
INSERT INTO engylt_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the gold which is prepared for the work in all the work of the sanctuary (and it is the gold of the wave-offering) is twenty and nine talents, and seven hundred and thirty shekels, by the shekel of the sanctuary. ");
INSERT INTO engylt_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","And the silver of those numbered of the company is a hundred talents, and a thousand and seven hundred and five and seventy shekels, by the shekel of the sanctuary; ");
INSERT INTO engylt_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","a bekah for a poll (half a shekel, by the shekel of the sanctuary,) for every one who is passing over unto those numbered, from a son of twenty years and upwards, for six hundred thousand, and three thousand, and five hundred and fifty. ");
INSERT INTO engylt_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","And a hundred talents of silver are to cast the sockets of the sanctuary, and the sockets of the vail; a hundred sockets for the hundred talents, a talent for a socket; ");
INSERT INTO engylt_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","and the thousand and seven hundred and five and seventy he hath made pegs for the pillars, and overlaid their tops, and filleted them. ");
INSERT INTO engylt_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","And the brass of the wave-offering is seventy talents, and two thousand and four hundred shekels; ");
INSERT INTO engylt_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","and he maketh with it the sockets of the opening of the tent of meeting, and the brazen altar, and the brazen grate which it hath, and all the vessels of the altar, ");
INSERT INTO engylt_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","and the sockets of the court round about, and the sockets of the gate of the court, and all the pins of the tabernacle, and all the pins of the court round about. ");
INSERT INTO engylt_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","And of the blue, and the purple, and the scarlet, they made coloured garments, to minister in the sanctuary; and they make the holy garments which are for Aaron, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","And he maketh the ephod, of gold, blue, and purple, and scarlet, and twined linen, ");
INSERT INTO engylt_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","and they expand the plates of gold, and have cut off wires to work in the midst of the blue, and in the midst of the purple, and in the midst of the scarlet, and in the midst of the linen — work of a designer; ");
INSERT INTO engylt_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","shoulder-pieces they have made for it, joining; at its two ends it is joined. ");
INSERT INTO engylt_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","And the girdle of his ephod which is on it is of the same, according to its work, of gold, blue, and purple, and scarlet, and twined linen, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","And they prepare the shoham stones, set, embroidered with gold, opened with openings of a signet, by the names of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","and he setteth them on the shoulders of the ephod — stones of memorial for the sons of Israel, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","And he maketh the breastplate, work of a designer, like the work of the ephod, of gold, blue, and purple, and scarlet, and twined linen; ");
INSERT INTO engylt_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","it hath been square; double they have made the breastplate, a span its length, and a span its breadth, doubled. ");
INSERT INTO engylt_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","And they fill in it four rows of stones; a row of a sardius, a topaz, and a carbuncle is the one row; ");
INSERT INTO engylt_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","and the second row an emerald, a sapphire, and a diamond; ");
INSERT INTO engylt_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","and the third row an opal, an agate, and an amethyst; ");
INSERT INTO engylt_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","and the fourth row a beryl, an onyx, and a jasper — set, embroidered with gold, in their settings. ");
INSERT INTO engylt_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","And the stones, according to the names of the sons of Israel, are twelve, according to their names, openings of a signet, each according to his name, for the twelve tribes. ");
INSERT INTO engylt_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","And they make on the breastplate wreathed chains, work of thick bands, of pure gold; ");
INSERT INTO engylt_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","and they make two embroidered things of gold, and two rings of gold, and put the two rings on the two ends of the breastplate, ");
INSERT INTO engylt_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","and they put the two thick bands of gold on the two rings on the ends of the breastplate; ");
INSERT INTO engylt_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","and the two ends of the two thick bands they have put on the two embroidered things, and they put them on the shoulders of the ephod, over-against its front. ");
INSERT INTO engylt_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","And they make two rings of gold, and set them on the two ends of the breastplate, on its border, which is on the side of the ephod within; ");
INSERT INTO engylt_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","and they make two rings of gold, and put them on the two shoulders of the ephod below, over-against its front, over-against its joining, above the girdle of the ephod; ");
INSERT INTO engylt_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","and they bind the breastplate by its rings unto the rings of the ephod, with a ribbon of blue, to be above the girdle of the ephod, and the breastplate is not loosed from off the ephod, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","And he maketh the upper robe of the ephod, work of a weaver, completely of blue; ");
INSERT INTO engylt_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","and the opening of the upper robe is in its midst, as the opening of a habergeon, a border is to its opening round about, it is not rent; ");
INSERT INTO engylt_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","and they make on the hems of the upper robe pomegranates of blue, and purple, and scarlet, twined. ");
INSERT INTO engylt_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","And they make bells of pure gold, and put the bells in the midst of the pomegranates, on the hems of the upper robe, round about, in the midst of the pomegranates; ");
INSERT INTO engylt_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","a bell and a pomegranate, a bell and a pomegranate, are on the hems of the upper robe, round about, to minister in, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","And they make the coats of linen, work of a weaver, for Aaron and for his sons, ");
INSERT INTO engylt_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","and the mitre of linen, and the beautiful bonnets of linen, and the linen trousers, of twined linen, ");
INSERT INTO engylt_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","and the girdle of twined linen, and blue, and purple, and scarlet, work of an embroiderer, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","And they make the flower of the holy crown of pure gold, and write on it a writing, openings of a signet, 'Holy to Jehovah;' ");
INSERT INTO engylt_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","and they put on it a ribbon of blue, to put it on the mitre above, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","And all the service of the tabernacle of the tent of meeting is completed; and the sons of Israel do according to all that Jehovah hath commanded Moses; so they have done. ");
INSERT INTO engylt_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","And they bring in the tabernacle unto Moses, the tent, and all its vessels, its hooks, its boards, its bars, and its pillars, and its sockets; ");
INSERT INTO engylt_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","and the covering of rams' skins, which are made red, and the covering of badgers' skins, and the vail of the covering; ");
INSERT INTO engylt_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the ark of the testimony and its staves, and the mercy-seat; ");
INSERT INTO engylt_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","the table, all its vessels, and the bread of the presence; ");
INSERT INTO engylt_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the pure candlestick, its lamps, the lamps of arrangement, and all its vessels, and the oil for the light. ");
INSERT INTO engylt_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","And the golden altar, and the anointing oil, and the spice-perfume, and the covering of the opening of the tent; ");
INSERT INTO engylt_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the brazen altar and the brazen grate which it hath, its staves, and all its vessels, the laver and its base. ");
INSERT INTO engylt_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","The hangings of the court, its pillars, and its sockets; and the covering for the gate of the court, its cords, and its pins; and all the vessels of the service of the tabernacle, for the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","the coloured clothes to minister in the sanctuary, the holy garments for Aaron the priest, and the garments of his sons, to act as priest in. ");
INSERT INTO engylt_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","According to all that Jehovah hath commanded Moses, so have the sons of Israel done all the service; ");
INSERT INTO engylt_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","and Moses seeth all the work, and lo, they have done it as Jehovah hath commanded; so they have done. And Moses doth bless them. ");
INSERT INTO engylt_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","'On the first day of the month, in the first month, thou dost raise up the tabernacle of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","and hast set there the ark of the testimony, and hast covered over the ark with the vail, ");
INSERT INTO engylt_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","and hast brought in the table, and set its arrangement in order, and hast brought in the candlestick, and caused its lamps to go up. ");
INSERT INTO engylt_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","'And thou hast put the golden altar for perfume before the ark of the testimony, and hast put the covering of the opening to the tabernacle, ");
INSERT INTO engylt_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","and hast put the altar of the burnt-offering before the opening of the tabernacle of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","and hast put the laver between the tent of meeting and the altar, and hast put water there. ");
INSERT INTO engylt_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","'And thou hast set the court round about, and hast placed the covering of the gate of the court, ");
INSERT INTO engylt_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","and hast taken the anointing oil, and anointed the tabernacle, and all that is in it, and hallowed it, and all its vessels, and it hath been holy; ");
INSERT INTO engylt_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","and thou hast anointed the altar of the burnt-offering, and all its vessels, and sanctified the altar, and the altar hath been most holy; ");
INSERT INTO engylt_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","and thou hast anointed the laver and its base, and sanctified it. ");
INSERT INTO engylt_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","'And thou hast brought near Aaron and his sons unto the opening of the tent of meeting, and hast bathed them with water; ");
INSERT INTO engylt_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","and thou hast clothed Aaron with the holy garments, and anointed him, and sanctified him, and he hath acted as priest to Me. ");
INSERT INTO engylt_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","'And his sons thou dost bring near, and hast clothed them with coats, ");
INSERT INTO engylt_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","and anointed them as thou hast anointed their father, and they have acted as priests to Me, and their anointing hath been to be to them for a priesthood age-during, to their generations.' ");
INSERT INTO engylt_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","And Moses doth according to all that Jehovah hath commanded him; so he hath done. ");
INSERT INTO engylt_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","And it cometh to pass, in the first month, in the second year, in the first of the month, the tabernacle hath been raised up; ");
INSERT INTO engylt_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","and Moses raiseth up the tabernacle, and setteth its sockets, and placeth its boards, and placeth its bars, and raiseth its pillars, ");
INSERT INTO engylt_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","and spreadeth the tent over the tabernacle, and putteth the covering of the tent upon it above, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","And he taketh and putteth the testimony unto the ark, and setteth the staves on the ark, and putteth the mercy-seat on the ark above; ");
INSERT INTO engylt_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","and bringeth in the ark unto the tabernacle, and placeth the vail of the covering, and covereth over the ark of the testimony, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","And he putteth the table in the tent of meeting, on the side of the tabernacle northward, at the outside of the vail, ");
INSERT INTO engylt_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","and setteth in order upon it the arrangement of bread, before Jehovah, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","And he putteth the candlestick in the tent of meeting, over-against the table, on the side of the tabernacle southward, ");
INSERT INTO engylt_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","and causeth the lamps to go up before Jehovah, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","And he setteth the golden altar in the tent of meeting, before the vail, ");
INSERT INTO engylt_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and maketh perfume on it — spice-perfume — as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","And he setteth the covering of the opening to the tabernacle, ");
INSERT INTO engylt_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","and the altar of the burnt-offering he hath set at the opening of the tabernacle of the tent of meeting, and causeth the burnt-offering to go up upon it, and the present, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","And he putteth the laver between the tent of meeting and the altar, and putteth water there for washing, ");
INSERT INTO engylt_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","and Moses and Aaron and his sons have washed their hands and their feet at the same; ");
INSERT INTO engylt_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","in their going in unto the tent of meeting, and in their drawing near unto the altar, they wash, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","And he raiseth up the court round about the tabernacle, and about the altar, and placeth the covering of the gate of the court; and Moses completeth the work. ");
INSERT INTO engylt_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","And the cloud covereth the tent of meeting, and the honour of Jehovah hath filled the tabernacle; ");
INSERT INTO engylt_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","and Moses hath not been able to go in unto the tent of meeting, for the cloud hath tabernacled on it, and the honour of Jehovah hath filled the tabernacle. ");
INSERT INTO engylt_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","And in the going up of the cloud from off the tabernacle the sons of Israel journey in all their journeys; ");
INSERT INTO engylt_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","and if the cloud go not up then they journey not, until the day of its going up: ");
INSERT INTO engylt_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","for the cloud of Jehovah is on the tabernacle by day, and fire is in it by night, before the eyes of all the house of Israel in all their journeys. ");
INSERT INTO engylt_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","And Jehovah calleth unto Moses, and speaketh unto him out of the tent of meeting, saying, ");
INSERT INTO engylt_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","'Speak unto the sons of Israel, and thou hast said unto them, Any man of you when he doth bring near an offering to Jehovah, out of the cattle — out of the herd, or out of the flock — ye do bring near your offering. ");
INSERT INTO engylt_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","'If his offering is a burnt-offering out of the herd — a male, a perfect one, he doth bring near, unto the opening of the tent of meeting he doth bring it near, at his pleasure, before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","and he hath laid his hand on the head of the burnt-offering, and it hath been accepted for him to make atonement for him; ");
INSERT INTO engylt_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","and he hath slaughtered the son of the herd before Jehovah; and sons of Aaron, the priests, have brought the blood near, and sprinkled the blood on the altar round about, which is at the opening of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","'And he hath stripped the burnt-offering, and hath cut it into its pieces; ");
INSERT INTO engylt_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","and the sons of Aaron the priest have put fire on the altar, and arranged wood on the fire; ");
INSERT INTO engylt_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","and sons of Aaron, the priests, have arranged the pieces, with the head and the fat, on the wood, which is on the fire, which is on the altar; ");
INSERT INTO engylt_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","and its inwards and its legs he doth wash with water; and the priest hath made perfume with the whole on the altar, a burnt-offering, a fire-offering of sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","'And if his offering is out of the flock — out of the sheep or out of the goats — for a burnt-offering, a male, a perfect one, he doth bring near, ");
INSERT INTO engylt_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","and he hath slaughtered it by the side of the altar northward, before Jehovah; and sons of Aaron, the priests, have sprinkled its blood on the altar round about; ");
INSERT INTO engylt_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","and he hath cut it into its pieces, and its head and its fat, and the priest hath arranged them on the wood, which is on the fire, which is on the altar; ");
INSERT INTO engylt_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","and the inwards and the legs he doth wash with water, and the priest hath brought the whole near, and hath made perfume on the altar; it is a burnt-offering, a fire-offering of sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","'And if his offering is a burnt-offering out of the fowl to Jehovah, than he hath brought near his offering out of the turtle-doves or out of the young pigeons, ");
INSERT INTO engylt_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","and the priest hath brought it near unto the altar, and hath wrung off its head, and hath made perfume on the altar, and its blood hath been wrung out by the side of the altar; ");
INSERT INTO engylt_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","and he hath turned aside its crop with its feathers, and hath cast it near the altar, eastward, unto the place of ashes; ");
INSERT INTO engylt_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","and he hath cleaved it with its wings (he doth not separate it), and the priest hath made it a perfume on the altar, on the wood, which is on the fire; it is a burnt-offering, a fire-offering of sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","'And when a person bringeth near an offering, a present to Jehovah, of flour is his offering, and he hath poured on it oil, and hath put on it frankincense; ");
INSERT INTO engylt_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","and he hath brought it in unto the sons of Aaron, the priests, and he hath taken from thence the fulness of his hand of its flour and of its oil, besides all its frankincense, and the priest hath made perfume with its memorial on the altar, a fire-offering of sweet fragrance to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","and the remnant of the present is for Aaron and for his sons, most holy, of the fire-offerings of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","'And when thou bringest near an offering, a present baked in an oven, it is of unleavened cakes of flour mixed with oil, or thin unleavened cakes anointed with oil. ");
INSERT INTO engylt_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","'And if thine offering is a present made on the girdel, it is of flour, mixed with oil, unleavened; ");
INSERT INTO engylt_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","divide thou it into parts, and thou hast poured on it oil; it is a present. ");
INSERT INTO engylt_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","'And if thine offering is a present made on the frying-pan, of flour with oil it is made, ");
INSERT INTO engylt_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","and thou hast brought in the present which is made of these to Jehovah, and one hath brought it near unto the priest, and he hath brought it nigh unto the altar, ");
INSERT INTO engylt_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","and the priest hath lifted up from the present its memorial, and hath made perfume on the altar, a fire-offering of sweet fragrance to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","and the remnant of the present is for Aaron and for his sons, most holy, of the fire-offerings of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No present which ye bring near to Jehovah is made fermented, for with any leaven or any honey ye perfume no fire-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","'An offering of first -fruits — ye bring them near to Jehovah, but on the altar they go not up, for sweet fragrance. ");
INSERT INTO engylt_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","And every offering — thy present — with salt thou dost season, and thou dost not let the salt of the covenant of thy God cease from thy present; with all thine offerings thou dost bring near salt. ");
INSERT INTO engylt_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","'And if thou bring near a present of first-ripe fruits to Jehovah, — of green ears, roasted with fire, beaten out corn of a fruitful field thou dost bring near the present of thy first-ripe fruits, ");
INSERT INTO engylt_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","and thou hast put on it oil, and laid on it frankincense, it is a present; ");
INSERT INTO engylt_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","and the priest hath made perfume with its memorial from its beaten out corn, and from its oil, besides all its frankincense — a fire-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","'And if his offering is a sacrifice of peace-offerings, if out of the herd he is bringing near, whether male or female, a perfect one he doth bring near before Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","and he hath laid his hand on the head of his offering, and hath slaughtered it at the opening of the tent of meeting, and sons of Aaron, the priests, have sprinkled the blood on the altar round about. ");
INSERT INTO engylt_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","'And he hath brought near from the sacrifice of the peace-offerings a fire-offering to Jehovah, the fat which is covering the inwards, and all the fat which is on the inwards, ");
INSERT INTO engylt_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","and the two kidneys, and the fat which is on them, which is on the flanks, and the redundance above the liver, (beside the kidneys he doth turn it aside), ");
INSERT INTO engylt_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","and sons of Aaron have made it a perfume on the altar, on the burnt-offering which is on the wood, which is on the fire — a fire-offering of sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","'And if his offering is out of the flock for a sacrifice of peace-offerings to Jehovah, male or female, a perfect one he doth bring near; ");
INSERT INTO engylt_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","if a sheep he is bringing near for his offering, then he hath brought it near before Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","and hath laid his hand on the head of his offering, and hath slaughtered it before the tent of meeting, and sons of Aaron have sprinkled its blood on the altar round about. ");
INSERT INTO engylt_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","'And he hath brought near from the sacrifice of the peace-offerings a fire-offering to Jehovah, its fat, the whole fat tail (over-against the bone he doth turn it aside), and the fat which is covering the inwards, and all the fat which is on the inwards, ");
INSERT INTO engylt_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","and the two kidneys, and the fat which is on them, which is on the flanks, and the redundance above the liver, (beside the kidneys he doth turn it aside), ");
INSERT INTO engylt_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","and the priest hath made it a perfume on the altar — bread of a fire-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","'And if his offering is a goat, then he hath brought it near before Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","and hath laid his hand on its head, and hath slaughtered it before the tent of meeting, and sons of Aaron have sprinkled its blood on the altar round about; ");
INSERT INTO engylt_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","and he hath brought near from it his offering, a fire-offering to Jehovah, the fat which is covering the inwards, and all the fat which is on the inwards, ");
INSERT INTO engylt_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","and the two kidneys, and the fat which is upon them, which is on the flanks, and the redundance above the liver, (beside the kidneys he doth turn it aside), ");
INSERT INTO engylt_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","and the priest hath made them a perfume on the altar — bread of a fire-offering, for sweet fragrance; all the fat is Jehovah's. ");
INSERT INTO engylt_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","'A statute age-during to your generations in all your dwellings: any fat or any blood ye do not eat.' ");
INSERT INTO engylt_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","'Speak unto the sons of Israel, saying, When a person doth sin through ignorance against any of the commands of Jehovah regarding things which are not to be done, and hath done something against one of these — ");
INSERT INTO engylt_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","'If the priest who is anointed doth sin according to the guilt of the people, then he hath brought near for his sin which he hath sinned a bullock, a son of the herd, a perfect one, to Jehovah, for a sin-offering, ");
INSERT INTO engylt_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","and he hath brought in the bullock unto the opening of the tent of meeting before Jehovah, and hath laid his hand on the head of the bullock, and hath slaughtered the bullock before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","'And the priest who is anointed hath taken of the blood of the bullock, and hath brought it in unto the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","and the priest hath dipped his finger in the blood, and sprinkled of the blood seven times before Jehovah, at the front of the vail of the sanctuary; ");
INSERT INTO engylt_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","and the priest hath put of the blood on the horns of the altar of spice-perfume before Jehovah, which is in the tent of meeting, and all the blood of the bullock he doth pour out at the foundation of the altar of the burnt-offering, which is at the opening of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","'And all the fat of the bullock of the sin-offering he doth lift up from it, the fat which is covering over the inwards, and all the fat which is on the inwards, ");
INSERT INTO engylt_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","and the two kidneys, and the fat which is on them, which is on the flanks, and the redundance above the liver, (beside the kidneys he doth turn it aside), ");
INSERT INTO engylt_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","as it is lifted up from the ox of the sacrifice of the peace-offerings; and the priest hath made them a perfume on the altar of the burnt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","'And the skin of the bullock, and all its flesh, besides its head, and besides its legs, and its inwards, and its dung — ");
INSERT INTO engylt_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","he hath even brought out the whole bullock unto the outside of the camp, unto a clean place, unto the place of the pouring out of the ashes, and he hath burnt it on the wood with fire; beside the place of the pouring out of the ashes it is burnt. ");
INSERT INTO engylt_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","'And if the whole company of Israel err ignorantly, and the thing hath been hidden from the eyes of the assembly, and they have done something against one of all the commands of Jehovah concerning things which are not to be done, and have been guilty; ");
INSERT INTO engylt_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","when the sin which they have sinned concerning it hath been known, then have the assembly brought near a bullock, a son of the herd, for a sin-offering, and they have brought it in before the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","and the elders of the company have laid their hands on the head of the bullock, before Jehovah, and one hath slaughtered the bullock before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","'And the priest who is anointed hath brought in of the blood of the bullock unto the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","and the priest hath dipped his finger in the blood, and hath sprinkled seven times before Jehovah at the front of the vail, ");
INSERT INTO engylt_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","and some of the blood he doth put on the horns of the altar which is before Jehovah, which is in the tent of meeting; and all the blood he doth pour out at the foundation of the altar of the burnt-offering, which is at the opening of the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","and all its fat he doth lift up from it, and hath made perfume on the altar. ");
INSERT INTO engylt_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","'And he hath done to the bullock as he hath done to the bullock of the sin-offering, so he doth to it; and the priest hath made atonement for them, and it hath been forgiven them; ");
INSERT INTO engylt_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","and he hath brought out the bullock unto the outside of the camp, and hath burned it as he hath burned the first bullock; it is a sin-offering of the assembly. ");
INSERT INTO engylt_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","'When a prince doth sin, and hath done something against one of all the commands of Jehovah his God regarding things which are not to be done, through ignorance, and hath been guilty — ");
INSERT INTO engylt_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","or his sin wherein he hath sinned hath been made known unto him, then he hath brought in his offering, a kid of the goats, a male, a perfect one, ");
INSERT INTO engylt_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","and he hath laid his hand on the head of the goat, and hath slaughtered it in the place where he doth slaughter the burnt-offering before Jehovah; it is a sin-offering. ");
INSERT INTO engylt_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","'And the priest hath taken of the blood of the sin-offering with his finger, and hath put on the horns of the altar of the burnt-offering, and its blood he doth pour out at the foundation of the altar of the burnt-offering, ");
INSERT INTO engylt_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","and with all its fat he doth make perfume on the altar, as the fat of the sacrifice of the peace-offerings; and the priest hath made atonement for him because of his sin, and it hath been forgiven him. ");
INSERT INTO engylt_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","'And if any person of the people of the land sin through ignorance, by his doing something against one of the commands of Jehovah regarding things which are not to be done, and hath been guilty — ");
INSERT INTO engylt_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","or his sin which he hath sinned hath been made known unto him, then he hath brought in his offering, a kid of the goats, a perfect one, a female, for his sin which he hath sinned, ");
INSERT INTO engylt_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","and he hath laid his hand on the head of the sin-offering, and hath slaughtered the sin-offering in the place of the burnt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","'And the priest hath taken of its blood with his finger, and hath put on the horns of the altar of the burnt-offering, and all its blood he doth pour out at the foundation of the altar, ");
INSERT INTO engylt_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","and all its fat he doth turn aside, as the fat hath been turned aside from off the sacrifice of the peace-offerings, and the priest hath made perfume on the altar, for sweet fragrance to Jehovah; and the priest hath made atonement for him, and it hath been forgiven him. ");
INSERT INTO engylt_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","'And if he bring in a sheep for his offering, for a sin-offering, a female, a perfect one, he doth bring in, ");
INSERT INTO engylt_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","and he hath laid his hand on the head of the sin-offering, and hath slaughtered it for a sin-offering in the place where he slaughtereth the burnt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","'And the priest hath taken of the blood of the sin-offering with his finger, and hath put on the horns of the altar of the burnt-offering, and all its blood he poureth out at the foundation of the altar, ");
INSERT INTO engylt_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","and all its fat he turneth aside, as the fat of the sheep is turned aside from the sacrifice of the peace-offerings, and the priest hath made them a perfume on the altar, according to the fire-offerings of Jehovah, and the priest hath made atonement for him, for his sin which he hath sinned, and it hath been forgiven him. ");
INSERT INTO engylt_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","'And when a person doth sin, and hath heard the voice of an oath, and he is witness, or hath seen, or hath known — if he declare not, then he hath borne his iniquity: ");
INSERT INTO engylt_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","'Or when a person cometh against any thing unclean, or against a carcase of an unclean beast, or against a carcase of unclean cattle, or against a carcase of an unclean teeming creature, and it hath been hidden from him, and he unclean, and guilty; ");
INSERT INTO engylt_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","'Or when he cometh against uncleanness of man, even any of his uncleanness whereby he is unclean, and it hath been hidden from him, and he hath known, and hath been guilty: ");
INSERT INTO engylt_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","'Or when a person sweareth, speaking wrongfully with the lips to do evil, or to do good, even anything which man speaketh wrongfully with an oath, and it hath been hid from him; — when he hath known then he hath been guilty of one of these; ");
INSERT INTO engylt_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","'And it hath been when he is guilty of one of these, that he hath confessed concerning that which he hath sinned, ");
INSERT INTO engylt_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","and hath brought in his guilt-offering to Jehovah for his sin which he hath sinned, a female out of the flock, a lamb, or a kid of the goats, for a sin-offering, and the priest hath made atonement for him, because of his sin. ");
INSERT INTO engylt_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","'And if his hand reach not to the sufficiency of a lamb, then he hath brought in his guilt-offering — he who hath sinned — two turtle-doves or two young pigeons to Jehovah, one for a sin-offering, and one for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","and he hath brought them in unto the priest, and hath brought near that which is for a sin-offering first, and hath wrung off its head from its neck, and doth not separate it, ");
INSERT INTO engylt_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","and he hath sprinkled of the blood of the sin-offering on the side of the altar, and that which is left of the blood is wrung out at the foundation of the altar; it is a sin-offering. ");
INSERT INTO engylt_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","'And the second he maketh a burnt-offering, according to the ordinance, and the priest hath made atonement for him, because of his sin which he hath sinned, and it hath been forgiven him. ");
INSERT INTO engylt_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","'And if his hand reach not to two turtle-doves, or to two young pigeons, then he hath brought in his offering — he who hath sinned — a tenth of an ephah of flour for a sin-offering; he putteth no oil on it, nor doth he put on it frankincense, for it is a sin-offering, ");
INSERT INTO engylt_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","and he hath brought it in unto the priest, and the priest hath taken a handful from it — the fulness of his hand — its memorial — and hath made perfume on the altar, according to the fire-offerings of Jehovah; it is a sin-offering. ");
INSERT INTO engylt_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","'And the priest hath made atonement for him, for his sin which he hath sinned against one of these, and it hath been forgiven him, and the remnant hath been to the priest, like the present.' ");
INSERT INTO engylt_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","'When a person committeth a trespass, and hath sinned through ignorance against the holy things of Jehovah, then he hath brought in his guilt-offering to Jehovah, a ram, a perfect one, out of the flock, at thy valuation in silver — shekels by the shekel of the sanctuary — for a guilt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","'And that which he hath sinned against the holy thing he repayeth, and its fifth is adding to it, and hath given it to the priest, and the priest maketh atonement for him with the ram of the guilt-offering, and it hath been forgiven him. ");
INSERT INTO engylt_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","'And when any person sinneth, and hath done something against one of all the commands of Jehovah regarding things which are not to be done, and hath not known, and he hath been guilty, and hath borne his iniquity, ");
INSERT INTO engylt_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","'Then he hath brought in a ram, a perfect one, out of the flock, at thy valuation, for a guilt-offering, unto the priest; and the priest hath made atonement for him, for his ignorance in which he hath erred and he hath not known, and it hath been forgiven him; ");
INSERT INTO engylt_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","it is a guilt-offering; he hath been certainly guilty before Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","'When any person doth sin, and hath committed a trespass against Jehovah, and hath lied to his fellow concerning a deposit, or concerning fellowship, or concerning violent robbery, or hath oppressed his fellow; ");
INSERT INTO engylt_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","or hath found a lost thing, and hath lied concerning it, and hath sworn to a falsehood, concerning one of all these which man doth, sinning in them: ");
INSERT INTO engylt_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","'Then it hath been, when he sinneth, and hath been guilty, that he hath returned the plunder which he hath taken violently away, or the thing which he hath got by oppression, or the deposit which hath been deposited with him, or the lost thing which he hath found; ");
INSERT INTO engylt_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","or all that concerning which he sweareth falsely, he hath even repaid it in its principal, and its fifth he is adding to it; to him whose it is he giveth it in the day of his guilt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","'And his guilt-offering he bringeth in to Jehovah, a ram, a perfect one, out of the flock, at thy estimation, for a guilt-offering, unto the priest, ");
INSERT INTO engylt_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","and the priest hath made atonement for him before Jehovah, and it hath been forgiven him, concerning one thing of all that he doth, by being guilty therein.' ");
INSERT INTO engylt_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","'Command Aaron and his sons, saying, This is a law of the burnt-offering (it is the burnt-offering, because of the burning on the altar all the night unto the morning, and the fire of the altar is burning on it,) ");
INSERT INTO engylt_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","that the priest hath put on his long robe of fine linen, and his fine linen trousers he doth put on his flesh, and hath lifted up the ashes which the fire consumeth with the burnt-offering on the altar, and hath put them near the altar; ");
INSERT INTO engylt_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","and he hath stripped off his garments, and hath put on other garments, and hath brought out the ashes unto the outside of the camp, unto a clean place. ");
INSERT INTO engylt_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","'And the fire on the altar is burning on it, it is not quenched, and the priest hath burned on it wood morning by morning, and hath arranged on it the burnt-offering, and hath made perfume on it with the fat of the peace-offerings; ");
INSERT INTO engylt_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","fire is continually burning on the altar, it is not quenched. ");
INSERT INTO engylt_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","'And this is a law of the present: sons of Aaron have brought it near before Jehovah unto the front of the altar, ");
INSERT INTO engylt_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","and one hath lifted up of it with his hand from the flour of the present, and from its oil, and all the frankincense which is on the present, and hath made perfume on the altar, sweet fragrance — its memorial to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","'And the remnant of it do Aaron and his sons eat; with unleavened things it is eaten, in the holy place, in the court of the tent of meeting they do eat it. ");
INSERT INTO engylt_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It is not baken with any thing fermented, their portion I have given it, out of My fire-offerings; it is most holy, like the sin-offering, and like the guilt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Every male among the sons of Aaron doth eat it — a statute age-during to your generations, out of the fire-offerings of Jehovah: all that cometh against them is holy.' ");
INSERT INTO engylt_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","'This is an offering of Aaron and of his sons, which they bring near to Jehovah in the day of his being anointed; a tenth of the ephah of flour for a continual present, half of it in the morning, and half of it in the evening; ");
INSERT INTO engylt_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","on a girdel with oil it is made — fried thou dost bring it in; baked pieces of the present thou dost bring near, a sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","'And the priest who is anointed in his stead, from among his sons, doth make it, — a statute age-during of Jehovah: it is completely perfumed; ");
INSERT INTO engylt_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","and every present of a priest is a whole burnt-offering; it is not eaten.' ");
INSERT INTO engylt_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","'Speak unto Aaron and unto his sons, saying, This is a law of the sin-offering: in the place where the burnt-offering is slaughtered is the sin-offering slaughtered before Jehovah; it is most holy. ");
INSERT INTO engylt_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","'The priest who is making atonement with it doth eat it, in the holy place it is eaten, in the court of the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","all that cometh against its flesh is holy, and when any of its blood is sprinkled on the garment, that on which it is sprinkled thou dost wash in the holy place; ");
INSERT INTO engylt_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","and an earthen vessel in which it is boiled is broken, and if in a brass vessel it is boiled, then it is scoured and rinsed with water. ");
INSERT INTO engylt_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","'Every male among the priests doth eat it — it is most holy; ");
INSERT INTO engylt_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","and no sin-offering, any of whose blood is brought in unto the tent of meeting to make atonement in the sanctuary is eaten; with fire it is burnt. ");
INSERT INTO engylt_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","'And this is a law of the guilt-offering: it is most holy; ");
INSERT INTO engylt_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","in the place where they slaughter the burnt-offering they do slaughter the guilt-offering, and its blood one doth sprinkle on the altar round about, ");
INSERT INTO engylt_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","and all its fat he bringeth near out of it, the fat tail, and the fat which is covering the inwards, ");
INSERT INTO engylt_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","and the two kidneys, and the fat which is on them, which is on the flanks, and the redundance above the liver (beside the kidneys he doth turn it aside); ");
INSERT INTO engylt_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","and the priest hath made them a perfume on the altar, a fire-offering to Jehovah; it is a guilt-offering. ");
INSERT INTO engylt_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","'Every male among the priests doth eat it; in the holy place it is eaten — it is most holy; ");
INSERT INTO engylt_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","as is a sin-offering, so is a guilt-offering; one law is for them; the priest who maketh atonement by it — it is his. ");
INSERT INTO engylt_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","'And the priest who is bringing near any man's burnt-offering, the skin of the burnt-offering which he hath brought near, it is the priest's, his own; ");
INSERT INTO engylt_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","and every present which is baked in an oven, and every one done in a frying-pan, and on a girdel, is the priest's who is bringing it near; it is his; ");
INSERT INTO engylt_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","and every present, mixed with oil or dry, is for all the sons of Aaron — one as another. ");
INSERT INTO engylt_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","'And this is a law of the sacrifice of the peace-offerings which one bringeth near to Jehovah: ");
INSERT INTO engylt_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","if for a thank-offering he bring it near, then he hath brought near with the sacrifice of thank-offering unleavened cakes mixed with oil, and thin unleavened cakes anointed with oil, and of fried flour cakes mixed with oil; ");
INSERT INTO engylt_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","besides the cakes, fermented bread he doth bring near with his offering, besides the sacrifice of thank-offering of his peace-offerings; ");
INSERT INTO engylt_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","and he hath brought near out of it one of the whole offering — a heave-offering to Jehovah; to the priest who is sprinkling the blood of the peace-offerings — it is his; ");
INSERT INTO engylt_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","as to the flesh of the sacrifice of the thank-offering of his peace-offerings, in the day of his offering it is eaten; he doth not leave of it till morning. ");
INSERT INTO engylt_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","'And if the sacrifice of his offering is a vow or free-will offering, in the day of his bringing near his sacrifice it is eaten; and on the morrow also the remnant of it is eaten; ");
INSERT INTO engylt_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","and the remnant of the flesh of the sacrifice on the third day with fire is burnt; ");
INSERT INTO engylt_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","and if any of the flesh of the sacrifice of his peace-offerings be really eaten on the third day, it is not pleasing; for him who is bringing it near it is not reckoned; it is an abominable thing, and the person who is eating of it his iniquity doth bear. ");
INSERT INTO engylt_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","'And the flesh which cometh against any unclean thing is not eaten; with fire it is burnt; as to the flesh, every clean one doth eat of the flesh; ");
INSERT INTO engylt_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","and the person who eateth of the flesh of the sacrifice of the peace-offerings which are Jehovah's, and his uncleanness upon him, even that person hath been cut off from his people. ");
INSERT INTO engylt_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","'And when a person cometh against any thing unclean, of the uncleanness of man, or of the uncleanness of beasts, or of any unclean teeming creature, and hath eaten of the flesh of the sacrifice of the peace-offerings which are Jehovah's, even that person hath been cut off from his people.' ");
INSERT INTO engylt_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","'Speak unto the sons of Israel, saying, Any fat of ox and sheep and goat ye do not eat; ");
INSERT INTO engylt_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","and the fat of a carcase, and the fat of a torn thing is prepared for any work, but ye do certainly not eat it; ");
INSERT INTO engylt_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","for whoever eateth the fat of the beast, of which one bringeth near a fire-offering to Jehovah, even the person who eateth hath been cut off from his people. ");
INSERT INTO engylt_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","'And any blood ye do not eat in all your dwellings, of fowl, or of beast; ");
INSERT INTO engylt_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","any person who eateth any blood, even that person hath been cut off from his people.' ");
INSERT INTO engylt_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","'Speak unto the sons of Israel, saying, He who is bringing near the sacrifice of his peace-offerings to Jehovah doth bring in his offering to Jehovah from the sacrifice of his peace-offerings; ");
INSERT INTO engylt_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","his own hands do bring in the fire-offerings of Jehovah, the fat beside the breast, it he doth bring in with the breast, to wave it — a wave-offering before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","'And the priest hath made perfume with the fat on the altar, and the breast hath been Aaron's and his sons; ");
INSERT INTO engylt_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","and the right leg ye do make a heave-offering to the priest of the sacrifices of your peace-offerings; ");
INSERT INTO engylt_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","he of the sons of Aaron who is bringing near the blood of the peace-offerings, and the fat, his is the right leg for a portion. ");
INSERT INTO engylt_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","'For the breast of the wave-offering, and the leg of the heave-offering, I have taken from the sons of Israel, from the sacrifices of their peace-offerings, and I give them to Aaron the priest, and to his sons, by a statute age-during, from the sons of Israel.' ");
INSERT INTO engylt_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the anointing of Aaron, and the anointing of his sons out of the fire-offerings of Jehovah, in the day he hath brought them near to act as priest to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","which Jehovah hath commanded to give to them in the day of His anointing them, from the sons of Israel — a statute age-during to their generations. ");
INSERT INTO engylt_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the law for burnt-offering, for present, and for sin-offering, and for guilt-offering, and for consecrations, and for a sacrifice of the peace-offerings, ");
INSERT INTO engylt_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","which Jehovah hath commanded Moses in Mount Sinai, in the day of his commanding the sons of Israel to bring near their offerings to Jehovah, in the wilderness of Sinai. ");
INSERT INTO engylt_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","'Take Aaron and his sons with him, and the garments, and the anointing oil, and the bullock of the sin-offering, and the two rams, and the basket of unleavened things, ");
INSERT INTO engylt_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","and all the company assemble thou unto the opening of the tent of meeting.' ");
INSERT INTO engylt_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","And Moses doth as Jehovah hath commanded him, and the company is assembled unto the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","and Moses saith unto the company, 'This is the thing which Jehovah hath commanded to do.' ");
INSERT INTO engylt_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","And Moses bringeth near Aaron and his sons, and doth bathe them with water, ");
INSERT INTO engylt_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","and doth put on him the coat, and doth gird him with the girdle, and doth clothe him with the upper robe, and doth put on him the ephod, and doth gird him with the girdle of the ephod, and doth bind it to him with it, ");
INSERT INTO engylt_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","and doth put on him the breastplate, and doth put unto the breastplate the Lights and the Perfections, ");
INSERT INTO engylt_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","and doth put the mitre on his head, and doth put on the mitre, over-against its front, the golden flower of the holy crown, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","And Moses taketh the anointing oil, and anointeth the tabernacle, and all that is in it, and sanctifieth them; ");
INSERT INTO engylt_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","and he sprinkleth of it on the altar seven times, and anointeth the altar, and all its vessels, and the laver, and its base, to sanctify them; ");
INSERT INTO engylt_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","and he poureth of the anointing oil on the head of Aaron, and anointeth him to sanctify him. ");
INSERT INTO engylt_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","And Moses bringeth near the sons of Aaron, and doth clothe them with coats, and girdeth them with girdles, and bindeth for them turbans, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","And he bringeth nigh the bullock of the sin-offering, and Aaron layeth — his sons also — their hands on the head of the bullock of the sin-offering, ");
INSERT INTO engylt_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","and one slaughtereth, and Moses taketh the blood, and putteth on the horns of the altar round about with his finger, and cleanseth the altar, and the blood he hath poured out at the foundation of the altar, and sanctifieth it, to make atonement upon it. ");
INSERT INTO engylt_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","And he taketh all the fat that is on the inwards, and the redundance above the liver, and the two kidneys, and their fat, and Moses maketh Perfume on the altar, ");
INSERT INTO engylt_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","and the bullock, and its skin, and its flesh, and its dung, he hath burnt with fire, at the outside of the camp, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","And he bringeth near the ram of the burnt-offering, and Aaron and his sons lay their hands on the head of the ram, ");
INSERT INTO engylt_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","and one slaughtereth, and Moses sprinkleth the blood on the altar round about; ");
INSERT INTO engylt_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","and the ram he hath cut into its pieces, and Moses maketh perfume with the head, and the pieces, and the fat, ");
INSERT INTO engylt_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","and the inwards and the legs he hath washed with water, and Moses maketh perfume with the whole ram on the altar; it is a burnt-offering, for sweet fragrance; it is a fire-offering to Jehovah, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","And he bringeth near the second ram, a ram of the consecrations, and Aaron and his sons lay their hands on the head of the ram, ");
INSERT INTO engylt_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","and one slaughtereth, and Moses taketh of its blood, and putteth on the tip of the right ear of Aaron, and on the thumb of his right hand, and on the great toe of his right foot; ");
INSERT INTO engylt_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","and he bringeth near the sons of Aaron, and Moses putteth of the blood on the tip of their right ear, and on the thumb of their right hand, and on the great toe of their right foot. And Moses sprinkleth the blood on the altar round about, ");
INSERT INTO engylt_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","and taketh the fat, and the fat tail, and all the fat that is on the inwards, and the redundance above the liver, and the two kidneys, and their fat, and the right leg; ");
INSERT INTO engylt_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","and out of the basket of unleavened things, which is before Jehovah, he hath taken one unleavened cake, and one cake of oiled bread, and one thin cake, and putteth them on the fat, and on the right leg; ");
INSERT INTO engylt_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","and putteth the whole on the hands of Aaron, and on the hands of his sons, and waveth them — a wave-offering before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","And Moses taketh them from off their hands, and maketh perfume on the altar, on the burnt-offering, they are consecrations for sweet fragrance; it is a fire-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","and Moses taketh the breast, and waveth it — a wave-offering before Jehovah; of the ram of the consecrations it hath been to Moses for a portion, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","And Moses taketh of the anointing oil, and of the blood which is on the altar, and sprinkleth on Aaron, on his garments, and on his sons, and on the garments of his sons with him, and he sanctifieth Aaron, his garments, and his sons, and the garments of his sons with him. ");
INSERT INTO engylt_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","And Moses saith unto Aaron, and unto his sons, 'Boil ye the flesh at the opening of the tent of meeting, and there ye do eat it and the bread which is in the basket of the consecrations, as I have commanded, saying, Aaron and his sons do eat it. ");
INSERT INTO engylt_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","'And the remnant of the flesh and of the bread with fire ye burn; ");
INSERT INTO engylt_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","and from the opening of the tent of meeting ye go not out seven days, till the day of the fulness, the days of your consecration — for seven days he doth consecrate your hand; ");
INSERT INTO engylt_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","as he hath done on this day, Jehovah hath commanded to do, to make atonement for you; ");
INSERT INTO engylt_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","and at the opening of the tent of meeting ye abide, by day and by night seven days, and ye have kept the charge of Jehovah, and die not, for so I have been commanded.' ");
INSERT INTO engylt_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","And Aaron doth — his sons also — all the things which Jehovah hath commanded by the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","And it cometh to pass on the eighth day, Moses hath called for Aaron and for his sons, and for the elders of Israel, ");
INSERT INTO engylt_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","and he saith unto Aaron, 'Take to thyself a calf, a son of the herd, for a sin-offering, and a ram for a burnt-offering, perfect ones, and bring near before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","'And unto the sons of Israel thou dost speak, saying, Take ye a kid of the goats for a sin-offering, and a calf, and a lamb, sons of a year, perfect ones, for a burnt-offering, ");
INSERT INTO engylt_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","and a bullock and a ram for peace-offerings, to sacrifice before Jehovah, and a present mixed with oil; for to-day Jehovah hath appeared unto you.' ");
INSERT INTO engylt_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","And they take that which Moses hath commanded unto the front of the tent of meeting, and all the company draw near and stand before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","and Moses saith, 'This is the thing which Jehovah hath commanded; do it, and the honour of Jehovah doth appear unto you.' ");
INSERT INTO engylt_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","And Moses saith unto Aaron, 'Draw near unto the altar, and make thy sin-offering, and thy burnt-offering, and make atonement for thyself, and for the people, and make the offering of the people, and make atonement for them, as Jehovah hath commanded.' ");
INSERT INTO engylt_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","And Aaron draweth near unto the altar, and slaughtereth the calf of the sin-offering, which is for himself; ");
INSERT INTO engylt_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","and the sons of Aaron bring the blood near unto him, and he dippeth his finger in the blood, and putteth it on the horns of the altar, and the blood he hath poured out at the foundation of the altar; ");
INSERT INTO engylt_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","and the fat, and the kidneys, and the redundance of the liver, of the sin-offering, he hath made a perfume on the altar, as Jehovah hath commanded Moses; ");
INSERT INTO engylt_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","and the flesh and the skin he hath burnt with fire, at the outside of the camp. ");
INSERT INTO engylt_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","And he slaughtereth the burnt-offering, and the sons of Aaron have presented unto him the blood, and he sprinkleth it on the altar round about; ");
INSERT INTO engylt_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","and the burnt-offering they have presented unto him, by its pieces, and the head, and he maketh perfume on the altar; ");
INSERT INTO engylt_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","and he washeth the inwards and the legs, and maketh perfume for the burnt-offering on the altar. ");
INSERT INTO engylt_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","And he bringeth near the offering of the people, and taketh the goat of the sin-offering which is for the people, and slaughtered it, and maketh it a sin-offering, like the first; ");
INSERT INTO engylt_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","and he bringeth near the burnt-offering, and maketh it, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","and he bringeth near the present, and filleth his palm with it, and maketh perfume on the altar, apart from the burnt-offering of the morning. ");
INSERT INTO engylt_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","And he slaughtereth the bullock and the ram, a sacrifice of the peace-offerings, which are for the people, and sons of Aaron present the blood unto him (and he sprinkleth it on the altar round about), ");
INSERT INTO engylt_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","and the fat of the bullock, and of the ram, the fat tail, and the covering of the inwards, and the kidneys, and the redundance above the liver, ");
INSERT INTO engylt_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","and they set the fat on the breasts, and he maketh perfume with the fat on the altar; ");
INSERT INTO engylt_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","and the breasts, and the right leg hath Aaron waved — a wave-offering before Jehovah, as He hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","And Aaron lifteth up his hand towards the people, and blesseth them, and cometh down from making the sin-offering, and the burnt-offering, and the peace-offerings. ");
INSERT INTO engylt_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","And Moses goeth in — Aaron also — unto the tent of meeting, and they come out, and bless the people, and the honour of Jehovah appeareth unto all the people; ");
INSERT INTO engylt_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","and fire cometh out from before Jehovah, and consumeth on the altar the burnt-offering, and the fat; and all the people see, and cry aloud, and fall on their faces. ");
INSERT INTO engylt_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","And the sons of Aaron, Nadab and Abihu, take each his censer, and put in them fire, and put on it perfume, and bring near before Jehovah strange fire, which He hath not commanded them; ");
INSERT INTO engylt_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","and fire goeth out from before Jehovah, and consumeth them, and they die before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","And Moses saith unto Aaron, 'It is that which Jehovah hath spoken, saying, By those drawing near to Me I am sanctified, and in the face of all the people I am honoured;' and Aaron is silent. ");
INSERT INTO engylt_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","And Moses calleth unto Mishael and unto Elzaphan, sons of Uzziel, uncle of Aaron, and saith unto them, 'Come near, bear your brethren from the front of the sanctuary unto the outside of the camp;' ");
INSERT INTO engylt_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","and they come near, and bear them in their coats unto the outside of the camp, as Moses hath spoken. ");
INSERT INTO engylt_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","And Moses saith unto Aaron, and to Eleazar, and to Ithamar his sons, 'Your heads ye do not uncover, and your garments ye do not rend, that ye die not, and on all the company He be wroth; as to your brethren, the whole house of Israel, they bewail the burning which Jehovah hath kindled; ");
INSERT INTO engylt_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","and from the opening of the tent of meeting ye do not go out, lest ye die, for the anointing oil of Jehovah is upon you;' and they do according to the word of Moses. ");
INSERT INTO engylt_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","And Jehovah speaketh unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","'Wine and strong drink thou dost not drink, thou, and thy sons with thee, in your going in unto the tent of meeting, and ye die not — a statute age-during to your generations; ");
INSERT INTO engylt_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","so as to make a separation between the holy and the common, and between the unclean and the pure; ");
INSERT INTO engylt_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","and to teach the sons of Israel all the statutes which Jehovah hath spoken unto them by the hand of Moses.' ");
INSERT INTO engylt_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","And Moses speaketh unto Aaron, and unto Eleazar, and unto Ithamar his sons, who are left, 'Take ye the present that is left from the fire-offerings of Jehovah, and eat it unleavened near the altar, for it is most holy, ");
INSERT INTO engylt_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","and ye have eaten it in the holy place, for it is thy portion, and the portion of thy sons, from the fire-offerings of Jehovah; for so I have been commanded. ");
INSERT INTO engylt_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","'And the breast of the wave-offering, and the leg of the heave-offering, ye do eat in a clean place, thou, and thy sons, and thy daughters with thee; for thy portion and the portion of thy sons they have been given, out of the sacrifices of peace-offerings of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","the leg of the heave-offering, and breast of the wave-offering, besides fire-offerings of the fat, they do bring in to wave a wave-offering before Jehovah, and it hath been to thee, and to thy sons with thee, by a statute age-during, as Jehovah hath commanded.' ");
INSERT INTO engylt_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","And the goat of the sin-offering hath Moses diligently sought, and lo, it is burnt, and he is wroth against Eleazar, and against Ithamar, sons of Aaron, who are left, saying, ");
INSERT INTO engylt_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","'Wherefore have ye not eaten the sin-offering in the holy place, for it is most holy — and it He hath given to you to take away the iniquity of the company, to make atonement for them before Jehovah? ");
INSERT INTO engylt_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","lo, its blood hath not been brought in unto the holy place within; eating ye do eat it in the holy place, as I have commanded.' ");
INSERT INTO engylt_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","And Aaron speaketh unto Moses, 'Lo, to-day they have brought near their sin-offering and their burnt-offering before Jehovah; and things like these meet me, yet I have eaten a sin-offering to-day; is it good in the eyes of Jehovah?' ");
INSERT INTO engylt_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","And Moses hearkeneth, and it is good in his eyes. ");
INSERT INTO engylt_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","And Jehovah speaketh unto Moses and unto Aaron, saying unto them, ");
INSERT INTO engylt_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","'Speak unto the sons of Israel, saying, This is the beast which ye do eat out of all the beasts which are on the earth: ");
INSERT INTO engylt_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","any dividing a hoof, and cleaving the cleft of the hoofs, bringing up the cud, among the beasts, it ye do eat. ");
INSERT INTO engylt_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","'Only, this ye do not eat — of those bringing up the cud, and of those dividing the hoof — the camel, though it is bringing up the cud, yet the hoof not dividing — it is unclean to you; ");
INSERT INTO engylt_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","and the rabbit, though it is bringing up the cud, yet the hoof it divideth not — unclean it is to you; ");
INSERT INTO engylt_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","and the hare, though it is bringing up the cud, yet the hoof hath not divided — unclean it is to you; ");
INSERT INTO engylt_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","and the sow, though it is dividing the hoof, and cleaving the cleft of the hoof, yet the cud it bringeth not up — unclean it is to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","'Of their flesh ye do not eat, and against their carcase ye do not come — unclean they are to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","'This ye do eat of all which are in the waters; any one that hath fins and scales in the waters, in the seas, and in the brooks, them ye do eat; ");
INSERT INTO engylt_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","and any one that hath not fins and scales in the seas, and in the brooks, of any teeming creature of the waters, and of any creature which liveth, which is in the waters — an abomination they are to you; ");
INSERT INTO engylt_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","yea, an abomination they are to you; of their flesh ye do not eat, and their carcase ye abominate. ");
INSERT INTO engylt_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","'Any one that hath not fins and scales in the waters — an abomination it is to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","'And these ye do abominate of the fowl; they are not eaten, an abomination they are: the eagle, and the ossifrage, and the ospray, ");
INSERT INTO engylt_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","and the vulture, and the kite after its kind, ");
INSERT INTO engylt_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","every raven after its kind, ");
INSERT INTO engylt_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","and the owl, and the night-hawk, and the cuckoo, and the hawk after its kind, ");
INSERT INTO engylt_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","and the little owl, and the cormorant, and the great owl, ");
INSERT INTO engylt_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","and the swan, and the pelican, and the gier eagle, ");
INSERT INTO engylt_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","and the stork, the heron after its kind, and the lapwing, and the bat. ");
INSERT INTO engylt_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","'Every teeming creature which is flying, which is going on four — an abomination it is to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","'Only — this ye do eat of any teeming thing which is flying, which is going on four, which hath legs above its feet, to move with them on the earth; ");
INSERT INTO engylt_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","these of them ye do eat: the locust after its kind, and the bald locust after its kind, and the beetle after its kind, and the grasshopper after its kind; ");
INSERT INTO engylt_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","and every teeming thing which is flying, which hath four feet — an abomination it is to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","'And by these ye are made unclean, any one who is coming against their carcase is unclean till the evening; ");
INSERT INTO engylt_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","and anyone who is lifting up aught of their carcase doth wash his garments, and hath been unclean till the evening: — ");
INSERT INTO engylt_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","even every beast which is dividing the hoof, and is not cloven-footed, and the cud is not bringing up — unclean they are to you; any one who is coming against them is unclean. ");
INSERT INTO engylt_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","'And any one going on its paws, among all the beasts which are going on four — unclean they are to you; any one who is coming against their carcase is unclean until the evening; ");
INSERT INTO engylt_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","and he who is lifting up their carcase doth wash his garments, and hath been unclean until the evening — unclean they are to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","'And this is to you the unclean among the teeming things which are teeming on the earth: the weasel, and the mouse, and the tortoise after its kind, ");
INSERT INTO engylt_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","and the ferret, and the chameleon, and the lizard, and the snail, and the mole; ");
INSERT INTO engylt_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","these are the unclean to you among all which are teeming; any one who is coming against them in their death is unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","'And anything on which any one of them falleth, in their death, is unclean, of any vessel of wood or garment or skin or sack, any vessel in which work is done is brought into water, and hath been unclean till the evening, then it hath been clean; ");
INSERT INTO engylt_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","and any earthen vessel, into the midst of which any one of them falleth, all that is in its midst is unclean, and it ye do break. ");
INSERT INTO engylt_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","'Of all the food which is eaten, that on which cometh such water, is unclean, and all drink which is drunk in any such vessel is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","and anything on which any of their carcase falleth is unclean (oven or double pots), it is broken down, unclean they are, yea, unclean they are to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","'Only — a fountain or pit, a collection of water, is clean, but that which is coming against their carcase is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","and when any of their carcase falleth on any sown seed which is sown — it is clean; ");
INSERT INTO engylt_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","and when water is put on the seed, and any of its carcase hath fallen on it — unclean it is to you. ");
INSERT INTO engylt_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","'And when any of the beasts which are to you for food dieth, he who is coming against its carcase is unclean till the evening; ");
INSERT INTO engylt_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","and he who is eating of its carcase doth wash his garments, and hath been unclean till the evening; and he who is lifting up its carcase doth wash his garments, and hath been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","'And every teeming thing which is teeming on the earth is an abomination, it is not eaten; ");
INSERT INTO engylt_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","any thing going on the belly, and any going on four, unto every multiplier of feet, to every teeming thing which is teeming on the earth — ye do not eat them, for they are an abomination; ");
INSERT INTO engylt_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ye do not make yourselves abominable with any teeming thing which is teeming, nor do ye make yourselves unclean with them, so that ye have been unclean thereby. ");
INSERT INTO engylt_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","'For I am Jehovah your God, and ye have sanctified yourselves, and ye have been holy, for I am holy; and ye do not defile your persons with any teeming thing which is creeping on the earth; ");
INSERT INTO engylt_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","for I am Jehovah who am bringing you up out of the land of Egypt to become your God; and ye have been holy, for I am holy. ");
INSERT INTO engylt_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","'This is a law of the beasts, and of the fowl, and of every living creature which is moving in the waters, and of every creature which is teeming on the earth, ");
INSERT INTO engylt_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","to make separation between the unclean and the pure, and between the beast that is eaten, and the beast that is not eaten.' ");
INSERT INTO engylt_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","'Speak unto the sons of Israel, saying, A woman when she giveth seed, and hath born a male, then she hath been unclean seven days, according to the days of separation for her sickness she is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","and in the eighth day is the flesh of his foreskin circumcised; ");
INSERT INTO engylt_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","and thirty and three days she doth abide in the blood of her cleansing; against any holy thing she doth not come, and unto the sanctuary she doth not go in, till the fulness of the days of her cleansing. ");
INSERT INTO engylt_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","'And if a female she bear, then she hath been unclean two weeks, as in her separation; and sixty and six days she doth abide for the blood of her cleansing. ");
INSERT INTO engylt_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","'And in the fulness of the days of her cleansing for son or for daughter she doth bring in a lamb, a son of a year, for a burnt-offering, and a young pigeon or a turtle-dove for a sin-offering, unto the opening of the tent of meeting, unto the priest; ");
INSERT INTO engylt_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","and he hath brought it near before Jehovah, and hath made atonement for her, and she hath been cleansed from the fountain of her blood; this is the law of her who is bearing, in regard to a male or to a female. ");
INSERT INTO engylt_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","'And if her hand find not the sufficiency of a sheep, then she hath taken two turtle-doves, or two young pigeons, one for a burnt-offering, and one for a sin-offering, and the priest hath made atonement for her, and she hath been cleansed.' ");
INSERT INTO engylt_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","'When a man hath in the skin of his flesh a rising, or scab, or bright spot, and it hath become in the skin of his flesh a leprous plague, then he hath been brought in unto Aaron the priest, or unto one of his sons the priests; ");
INSERT INTO engylt_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","and the priest hath seen the plague in the skin of the flesh, and the hair in the plague hath turned white, and the appearance of the plague is deeper than the skin of his flesh — it is a plague of leprosy, and the priest hath seen him, and hath pronounced him unclean. ");
INSERT INTO engylt_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","'And if the bright spot is white in the skin of his flesh, and its appearance is not deeper than the skin, and its hair hath not turned white, then hath the priest shut up him who hath the plague seven days. ");
INSERT INTO engylt_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","'And the priest hath seen him on the seventh day, and lo, the plague hath stood in his eyes, the plague hath not spread in the skin, and the priest hath shut him up a second seven days. ");
INSERT INTO engylt_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","'And the priest hath seen him on the second seventh day, and lo, the plague is become weak, and the plague hath not spread in the skin — and the priest hath pronounced him clean, it is a scab, and he hath washed his garments, and hath been clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","'And if the scab spread greatly in the skin, after his being seen by the priest for his cleansing, then he hath been seen a second time by the priest; ");
INSERT INTO engylt_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","and the priest hath seen, and lo, the scab hath spread in the skin, and the priest hath pronounced him unclean; it is leprosy. ");
INSERT INTO engylt_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","'When a plague of leprosy is in a man, then he hath been brought in unto the priest, ");
INSERT INTO engylt_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","and the priest hath seen, and lo, a white rising in the skin, and it hath turned the hair white, and a quickening of raw flesh is in the rising, — ");
INSERT INTO engylt_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","an old leprosy it is in the skin of his flesh, and the priest hath pronounced him unclean; he doth not shut him up, for he is unclean. ");
INSERT INTO engylt_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","'And if the leprosy break out greatly in the skin, and the leprosy hath covered all the skin of him who hath the plague, from his head even unto his feet, to all that appeareth to the eyes of the priest, ");
INSERT INTO engylt_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","then hath the priest seen, and lo, the leprosy hath covered all his flesh, and he hath pronounced him who hath the plague clean; it hath all turned white; he is clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","'And in the day of raw flesh being seen in him he is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","and the priest hath seen the raw flesh, and hath pronounced him unclean; the raw flesh is unclean, it is leprosy. ");
INSERT INTO engylt_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Or when the raw flesh turneth back, and hath been turned to white, then he hath come in unto the priest, ");
INSERT INTO engylt_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","and the priest hath seen him, and lo, the plague hath been turned to white, and the priest hath pronounced clean him who hath the plague; he is clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","'And when flesh hath in it, in its skin, an ulcer, and it hath been healed, ");
INSERT INTO engylt_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","and there hath been in the place of the ulcer a white rising, or a bright white spot, very red, then it hath been seen by the priest, ");
INSERT INTO engylt_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","and the priest hath seen, and lo, its appearance is lower than the skin, and its hair hath turned white, and the priest hath pronounced him unclean; it is a plague of leprosy — in an ulcer it hath broken out. ");
INSERT INTO engylt_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","'And if the priest see it, and lo, there is no white hair in it, and it is not lower than the skin, and is become weak, then hath the priest shut him up seven days; ");
INSERT INTO engylt_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","and if it spread greatly in the skin, then hath the priest pronounced him unclean, it is a plague; ");
INSERT INTO engylt_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","and if in its place the bright spot stay — it hath not spread — it is an inflammation of the ulcer; and the priest hath pronounced him clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","'Or when flesh hath in its skin a fiery burning, and the quickening of the burning, the bright white spot, hath been very red or white, ");
INSERT INTO engylt_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","and the priest hath seen it, and lo, the hair hath turned white in the bright spot, and its appearance is deeper than the skin; leprosy it is, in the burning it hath broken out, and the priest hath pronounced him unclean; it is a plague of leprosy. ");
INSERT INTO engylt_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","'And if the priest see it, and lo, there is no white hair on the bright spot, and it is not lower than the skin, and it is become weak, then the priest hath shut him up seven days; ");
INSERT INTO engylt_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","and the priest hath seen him on the seventh day, if it spread greatly in the skin, then the priest hath pronounced him unclean; a plague of leprosy it is. ");
INSERT INTO engylt_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","'And if the bright spot stay in its place, it hath not spread in the skin, and is become weak; a rising of the burning it is, and the priest hath pronounced him clean; for it is inflammation of the burning. ");
INSERT INTO engylt_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","'And when a man (or a woman) hath in him a plague in the head or in the beard, ");
INSERT INTO engylt_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","then hath the priest seen the plague, and lo, its appearance is deeper than the skin, and in it a thin shining hair, and the priest hath pronounced him unclean; it is a scall — it is a leprosy of the head or of the beard. ");
INSERT INTO engylt_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","'And when the priest seeth the plague of the scall, and lo, its appearance is not deeper than the skin, and there is no black hair in it, then hath the priest shut up him who hath the plague of the scall seven days. ");
INSERT INTO engylt_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","'And the priest hath seen the plague on the seventh day, and lo, the scall hath not spread, and a shining hair hath not been in it, and the appearance of the scall is not deeper than the skin, ");
INSERT INTO engylt_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","then he hath shaved himself, but the scall he doth not shave; and the priest hath shut up him who hath the scall a second seven days. ");
INSERT INTO engylt_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","And the priest hath seen the scall on the seventh day, and lo, the scall hath not spread in the skin, and its appearance is not deeper than the skin, and the priest hath pronounced him clean, and he hath washed his garments, and hath been clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","'And if the scall spread greatly in the skin after his cleansing, ");
INSERT INTO engylt_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","and the priest hath seen him, and lo, the scall hath spread in the skin, the priest seeketh not for the shining hair, he is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","and if in his eyes the scall hath stayed, and black hair hath sprung up in it, the scall hath been healed — he is clean — and the priest hath pronounced him clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","'And when a man or woman hath in the skin of their flesh bright spots, white bright spots, ");
INSERT INTO engylt_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","and the priest hath seen, and lo, in the skin of their flesh white weak bright spots, it is a freckled spot broken out in the skin; he is clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","'And when a man's head is polished, he is bald, he is clean; ");
INSERT INTO engylt_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","and if from the corner of his face his head is polished, he is bald of the forehead; he is clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","'And when there is in the bald back of the head, or in the bald forehead, a very red white plague, it is a leprosy breaking out in the bald back of the head, or in the bald forehead; ");
INSERT INTO engylt_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","and the priest hath seen him, and lo, the rising of the very red white plague in the bald back of the head, or in the bald forehead, is as the appearance of leprosy, in the skin of the flesh, ");
INSERT INTO engylt_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he is a leprous man, he is unclean; the priest doth pronounce him utterly unclean; his plague is in his head. ");
INSERT INTO engylt_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","'As to the leper in whom is the plague, his garments are rent, and his head is uncovered, and he covereth over the upper lip, and 'Unclean! unclean!' he calleth; ");
INSERT INTO engylt_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","all the days that the plague is in him he is unclean; he is unclean, alone he doth dwell, at the outside of the camp is his dwelling. ");
INSERT INTO engylt_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","'And when there is in any garment a plague of leprosy, — in a garment of wool, or in a garment of linen, ");
INSERT INTO engylt_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","or in the warp, or in the woof, of linen or of wool, or in a skin, or in any work of skin, ");
INSERT INTO engylt_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","and the plague hath been very green or very red in the garment, or in the skin, or in the warp, or in the woof, or in any vessel of skin, it is a plague of leprosy, and it hath been shewn the priest. ");
INSERT INTO engylt_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","'And the priest hath seen the plague, and hath shut up that which hath the plague, seven days; ");
INSERT INTO engylt_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","and he hath seen the plague on the seventh day, and the plague hath spread in the garment, or in the warp, or in the woof, or in the skin, of all that is made of skin for work; the plague is a fretting leprosy, it is unclean. ");
INSERT INTO engylt_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","'And he hath burnt the garment, or the warp, or the woof, in wool or in linen, or any vessel of skin in which the plague is; for it is a fretting leprosy; with fire it is burnt. ");
INSERT INTO engylt_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","'And if the priest see, and lo, the plague hath not spread in the garment, or in the warp, or in the woof, or in any vessel of skin, ");
INSERT INTO engylt_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","then hath the priest commanded, and they have washed that in which the plague is, and he hath shut it up a second seven days. ");
INSERT INTO engylt_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","And the priest hath seen that which hath the plague after it hath been washed, and lo, the plague hath not changed its aspect, and the plague hath not spread, — it is unclean; with fire thou dost burn it; it is a fretting in its back-part or in its front-part. ");
INSERT INTO engylt_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","'And if the priest hath seen, and lo, the plague is become weak after it hath been washed, then he hath rent it out of the garment, or out of the skin, or out of the warp, or out of the woof; ");
INSERT INTO engylt_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","and if it still be seen in the garment, or in the warp, or in the woof, or in any vessel of skin, it is a fretting; with fire thou dost burn it — that in which the plague is. ");
INSERT INTO engylt_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","'And the garment, or the warp, or the woof, or any vessel of skin which thou dost wash when the plague hath turned aside from them, then it hath been washed a second time, and hath been clean. ");
INSERT INTO engylt_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","'This is the law of a plague of leprosy in a garment of wool or of linen, or of the warp or of the woof, or of any vessel of skin, to pronounce it clean or to pronounce it unclean.' ");
INSERT INTO engylt_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","'This is a law of the leper, in the day of his cleansing, that he hath been brought in unto the priest, ");
INSERT INTO engylt_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","and the priest hath gone out unto the outside of the camp, and the priest hath seen, and lo, the plague of leprosy hath ceased from the leper, ");
INSERT INTO engylt_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","and the priest hath commanded, and he hath taken for him who is to be cleansed, two clean living birds, and cedar wood, and scarlet, and hyssop. ");
INSERT INTO engylt_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","'And the priest hath commanded, and he hath slaughtered the one bird upon an earthen vessel, over running water; ");
INSERT INTO engylt_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","as to the living bird, he taketh it, and the cedar wood, and the scarlet, and the hyssop, and hath dipped them and the living bird in the blood of the slaughtered bird, over the running water, ");
INSERT INTO engylt_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","and he hath sprinkled on him who is to be cleansed from the leprosy seven times, and hath pronounced him clean, and hath sent out the living bird on the face of the field. ");
INSERT INTO engylt_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","'And he who is to be cleansed hath washed his garments, and hath shaved all his hair, and hath bathed with water, and hath been clean, and afterwards he doth come in unto the camp, and hath dwelt at the outside of his tent seven days. ");
INSERT INTO engylt_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","'And it hath been, on the seventh day — he shaveth all his hair, his head, and his beard, and his eyebrows, even all his hair he doth shave, and he hath washed his garments, and hath bathed his flesh with water, and hath been clean. ");
INSERT INTO engylt_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","'And on the eighth day he taketh two lambs, perfect ones, and one ewe-lamb, daughter of a year, a perfect one, and three tenth deals of flour for a present, mixed with oil, and one log of oil. ");
INSERT INTO engylt_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","'And the priest who is cleansing hath caused the man who is to be cleansed to stand with them before Jehovah, at the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","and the priest hath taken the one he-lamb, and hath brought it near for a guilt-offering, also the log of oil, and hath waved them — a wave offering before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","'And he hath slaughtered the lamb in the place where he slaughtereth the sin-offering and the burnt-offering, in the holy place; for like the sin-offering the guilt-offering is to the priest; it is most holy. ");
INSERT INTO engylt_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","'And the priest hath taken of the blood of the guilt-offering, and the priest hath put on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the great toe of his right foot; ");
INSERT INTO engylt_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","and the priest hath taken of the log of oil, and hath poured on the left palm of the priest, ");
INSERT INTO engylt_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","and the priest hath dipped his right finger in the oil which is on his left palm, and hath sprinkled of the oil with his finger seven times before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","'And of the residue of the oil which is on his palm, the priest putteth on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the great toe of his right foot, on the blood of the guilt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","and the remnant of the oil which is on the palm of the priest, he putteth on the head of him who is to be cleansed, and the priest hath made atonement for him before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","'And the priest hath made the sin-offering, and hath made atonement for him who is to be cleansed from his uncleanness, and afterwards he doth slaughter the burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","and the priest hath caused the burnt-offering to ascend, also the present, on the altar, and the priest hath made atonement for him, and he hath been clean. ");
INSERT INTO engylt_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","'And if he is poor, and his hand is not reaching these things, then he hath taken one lamb — a guilt-offering, for a wave-offering, to make atonement for him, and one-tenth deal of flour mixed with oil for a present, and a log of oil, ");
INSERT INTO engylt_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two turtle-doves, or two young pigeons, which his hand reacheth to, and one hath been a sin-offering, and the one a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","and he hath brought them in on the eighth day for his cleansing unto the priest, unto the opening of the tent of meeting, before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","'And the priest hath taken the lamb of the guilt-offering, and the log of oil, and the priest hath waved them — a wave-offering before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","and he hath slaughtered the lamb of the guilt-offering, and the priest hath taken of the blood of the guilt-offering, and hath put on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the great toe of his right foot; ");
INSERT INTO engylt_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","and the priest doth pour of the oil on the left palm of the priest; ");
INSERT INTO engylt_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and the priest hath sprinkled with his right finger of the oil which is on his left palm, seven times before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","'And the priest hath put of the oil which is on his palm, on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the great toe of his right foot, on the place of the blood of the guilt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","and the remnant of the oil which is on the palm of the priest he doth put on the head of him who is to be cleansed, to make atonement for him, before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","'And he hath made the one of the turtle-doves, or of the young pigeons (from that which his hand reacheth to, ");
INSERT INTO engylt_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","even that which his hand reacheth to), the one a sin-offering, and the one a burnt offering, besides the present, and the priest hath made atonement for him who is to be cleansed before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is a law of him in whom is a plague of leprosy, whose hand reacheth not to his cleansing.' ");
INSERT INTO engylt_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","'When ye come in unto the land of Canaan, which I am giving to you for a possession, and I have put a plague of leprosy in a house in the land of your possession; ");
INSERT INTO engylt_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","then hath he whose the house is come in and declared to the priest, saying, As a plague hath appeared to me in the house; ");
INSERT INTO engylt_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","and the priest hath commanded, and they have prepared the house before the priest cometh in to see the plague (that all which is in the house be not unclean), and afterwards doth the priest come in to see the house; ");
INSERT INTO engylt_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","and he hath seen the plague, and lo, the plague is in the walls of the house, hollow strakes, very green or very red, and their appearance is lower than the wall, ");
INSERT INTO engylt_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","and the priest hath gone out of the house unto the opening of the house, and hath shut up the house seven days. ");
INSERT INTO engylt_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","'And the priest hath turned back on the seventh day, and hath seen, and lo, the plague hath spread in the walls of the house, ");
INSERT INTO engylt_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","and the priest hath commanded, and they have drawn out the stones in which the plague is, and have cast them unto the outside of the city, unto an unclean place; ");
INSERT INTO engylt_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","and the house he doth cause to be scraped within round about, and they have poured out the clay which they have scraped off, at the outside of the city, at an unclean place; ");
INSERT INTO engylt_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","and they have taken other stones, and brought them in unto the place of the stones, and other clay he taketh and hath daubed the house. ");
INSERT INTO engylt_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","'And if the plague return, and hath broken out in the house, after he hath drawn out the stones, and after the scraping of the house, and after the daubing; ");
INSERT INTO engylt_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","then hath the priest come in and seen, and lo, the plague hath spread in the house; it is a fretting leprosy in the house; it is unclean. ");
INSERT INTO engylt_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","'And he hath broken down the house, its stones, and its wood, and all the clay of the house, and he hath brought them forth unto the outside of the city, unto an unclean place. ");
INSERT INTO engylt_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","'And he who is going in unto the house all the days he hath shut it up, is unclean till the evening; ");
INSERT INTO engylt_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","and he who is lying in the house doth wash his garments; and he who is eating in the house doth wash his garments. ");
INSERT INTO engylt_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","'And if the priest certainly come in, and hath seen, and lo, the plague hath not spread in the house after the daubing of the house, then hath the priest pronounced the house clean, for the plague hath been healed. ");
INSERT INTO engylt_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","'And he hath taken for the cleansing of the house two birds, and cedar wood, and scarlet, and hyssop; ");
INSERT INTO engylt_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","and he hath slaughtered the one bird upon an earthen vessel, over running water; ");
INSERT INTO engylt_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","and he hath taken the cedar wood, and the hyssop, and the scarlet, and the living bird, and hath dipped them in the blood of the slaughtered bird, and in the running water, and hath sprinkled upon the house seven times. ");
INSERT INTO engylt_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","'And he hath cleansed the house with the blood of the bird, and with the running water, and with the living bird, and with the cedar wood, and with the hyssop, and with the scarlet; ");
INSERT INTO engylt_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","and he hath sent away the living bird unto the outside of the city unto the face of the field, and hath made atonement for the house, and it hath been clean. ");
INSERT INTO engylt_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","'This is the law for every plague of the leprosy and for scall, ");
INSERT INTO engylt_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","and for leprosy of a garment, and of a house, ");
INSERT INTO engylt_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","and for a rising, and for a scab, and for a bright spot, — ");
INSERT INTO engylt_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","to direct in the day of being unclean, and in the day of being clean; this is the law of the leprosy.' ");
INSERT INTO engylt_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","'Speak unto the sons of Israel, and ye have said unto them, When there is an issue out of the flesh of any man, for his issue he is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","and this is his uncleanness in his issue — his flesh hath run with his issue, or his flesh hath stopped from his issue; it is his uncleanness. ");
INSERT INTO engylt_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","'All the bed on which he lieth who hath the issue is unclean, and all the vessel on which he sitteth is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","and any one who cometh against his bed doth wash his garments, and hath bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","'And he who is sitting on the vessel on which he sitteth who hath the issue, doth wash his garments, and hath bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","'And he who is coming against the flesh of him who hath the issue, doth wash his garments, and hath bathed with water, and hath been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","'And when he who hath the issue spitteth on him who is clean, then he hath washed his garments, and hath bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","'And all the saddle on which he rideth who hath the issue is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","and any one who is coming against anything which is under him is unclean till the evening, and he who is bearing them doth wash his garments, and hath bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","'And anyone against whom he cometh who hath the issue (and his hands hath not rinsed with water) hath even washed his garments, and bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","'And the earthen vessel which he who hath the issue cometh against is broken; and every wooden vessel is rinsed with water. ");
INSERT INTO engylt_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","'And when he who hath the issue is clean from his issue, then he hath numbered to himself seven days for his cleansing, and hath washed his garments, and hath bathed his flesh with running water, and been clean. ");
INSERT INTO engylt_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","'And on the eighth day he taketh to himself two turtle-doves, or two young pigeons, and hath come in before Jehovah unto the opening of the tent of meeting, and hath given them unto the priest; ");
INSERT INTO engylt_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","and the priest hath made them, one a sin-offering, and the one a burnt-offering; and the priest hath made atonement for him before Jehovah, because of his issue. ");
INSERT INTO engylt_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","'And when a man's seed of copulation goeth out from him, then he hath bathed with water all his flesh, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","'And any garment, or any skin on which there is seed of copulation, hath also been washed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","'And a woman with whom a man lieth with seed of copulation, they also have bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","'And when a woman hath an issue — blood is her issue in her flesh — seven days she is in her separation, and any one who is coming against her is unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","'And anything on which she lieth in her separation is unclean, and anything on which she sitteth is unclean; ");
INSERT INTO engylt_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","and any one who is coming against her bed doth wash his garments, and hath bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","'And any one who is coming against any vessel on which she sitteth doth wash his garments, and hath washed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","'And if it is on the bed, or on the vessel on which she is sitting, in his coming against it, he is unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","'And if a man really lie with her, and her separation is on him, then he hath been unclean seven days, and all the bed on which he lieth is unclean. ");
INSERT INTO engylt_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","'And when a woman's issue of blood floweth many days within the time of her separation, or when it floweth over her separation — all the days of the issue of her uncleanness are as the days of her separation; she is unclean. ");
INSERT INTO engylt_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","'All the bed on which she lieth all the days of her issue is as the bed of her separation to her, and all the vessel on which she sitteth is unclean as the uncleanness of her separation; ");
INSERT INTO engylt_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","and any one who is coming against them is unclean, and hath washed his garments, and hath bathed with water, and been unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","'And if she hath been clean from her issue, then she hath numbered to herself seven days, and afterwards she is clean; ");
INSERT INTO engylt_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","and on the eighth day she taketh to herself two turtle-doves, or two young pigeons, and hath brought them in unto the priest, unto the opening of the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","and the priest hath made the one a sin-offering, and the one a burnt-offering, and the priest hath made atonement for her before Jehovah, because of the issue of her uncleanness. ");
INSERT INTO engylt_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","'And ye have separated the sons of Israel from their uncleanness, and they die not in their uncleanness, in their defiling My tabernacle which is in their midst. ");
INSERT INTO engylt_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","'This is the law of him who hath an issue, and of him whose seed of copulation goeth out from him, for uncleanness thereby, ");
INSERT INTO engylt_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","and of her who is sick in her separation, and of him who hath an issue, the issue of a male or of a female, and of a man who lieth with an unclean woman.' ");
INSERT INTO engylt_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","And Jehovah speaketh unto Moses, after the death of the two sons of Aaron, in their drawing near before Jehovah, and they die; ");
INSERT INTO engylt_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","yea, Jehovah saith unto Moses, 'Speak unto Aaron thy brother, and he cometh not in at all times unto the sanctuary within the vail, unto the front of the mercy-seat, which is upon the ark, and he dieth not, for in a cloud I am seen upon the mercy-seat. ");
INSERT INTO engylt_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","'With this doth Aaron come in unto the sanctuary; with a bullock, a son of the herd, for a sin-offering, and a ram for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","a holy linen coat he putteth on, and linen trousers are on his flesh, and with a linen girdle he girdeth himself, and with a linen mitre he wrappeth himself up; they are holy garments; and he hath bathed with water his flesh, and hath put them on. ");
INSERT INTO engylt_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","'And from the company of the sons of Israel he taketh two kids of the goats for a sin-offering, and one ram for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","and Aaron hath brought near the bullock of the sin-offering which is his own, and hath made atonement for himself, and for his house; ");
INSERT INTO engylt_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","and he hath taken the two goats, and hath caused them to stand before Jehovah, at the opening of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","'And Aaron hath given lots over the two goats, one lot for Jehovah, and one lot for a goat of departure; ");
INSERT INTO engylt_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","and Aaron hath brought near the goat on which the lot for Jehovah hath gone up, and hath made it a sin-offering. ");
INSERT INTO engylt_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","'And the goat on which the lot for a goat of departure hath gone up is caused to stand living before Jehovah to make atonement by it, to send it away for a goat of departure into the wilderness. ");
INSERT INTO engylt_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","'And Aaron hath brought near the bullock of the sin-offering which is his own, and hath made atonement for himself, and for his house, and hath slaughtered the bullock of the sin-offering which is his own, ");
INSERT INTO engylt_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","and hath taken the fulness of the censer of burning coals of fire from off the altar, from before Jehovah, and the fulness of his hands of thin spice-perfume, and hath brought it within the vail; ");
INSERT INTO engylt_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","and he hath put the perfume on the fire before Jehovah, and the cloud of the perfume hath covered the mercy-seat which is on the testimony, and he dieth not. ");
INSERT INTO engylt_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","'And he hath taken of the blood of the bullock, and hath sprinkled with his finger on the front of the mercy-seat eastward; even at the front of the mercy-seat he doth sprinkle seven times of the blood with his finger. ");
INSERT INTO engylt_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","'And he hath slaughtered the goat of the sin-offering which is the people's, and hath brought in its blood unto the inside of the vail, and hath done with its blood as he hath done with the blood of the bullock, and hath sprinkled it on the mercy-seat, and at the front of the mercy-seat, ");
INSERT INTO engylt_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","and he hath made atonement for the sanctuary because of the uncleanness of the sons of Israel, and because of their transgressions in all their sins; and so he doth for the tent of meeting which is tabernacling with them in the midst of their uncleannesses. ");
INSERT INTO engylt_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","'And no man is in the tent of meeting in his going in to make atonement in the sanctuary, till his coming out; and he hath made atonement for himself, and for his house, and for all the assembly of Israel. ");
INSERT INTO engylt_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","'And he hath gone out unto the altar which is before Jehovah, and hath made atonement for it; and he hath taken of the blood of the bullock, and of the blood of the goat, and hath put on the horns of the altar round about; ");
INSERT INTO engylt_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","and he hath sprinkled on it of the blood with his finger seven times, and hath cleansed it, and hath hallowed it from the uncleannesses of the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","'And he hath ceased from making atonement for the sanctuary, and the tent of meeting, and the altar, and hath brought near the living goat; ");
INSERT INTO engylt_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","and Aaron hath laid his two hands on the head of the living goat, and hath confessed over it all the iniquities of the sons of Israel, and all their transgressions in all their sins, and hath put them on the head of the goat, and hath sent it away by the hand of a fit man into the wilderness; ");
INSERT INTO engylt_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","and the goat hath borne on him all their iniquities unto a land of separation. 'And he hath sent the goat away into the wilderness, ");
INSERT INTO engylt_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","and Aaron hath come in unto the tent of meeting, and hath stripped off the linen garments which he had put on in his going in unto the sanctuary, and hath placed them there; ");
INSERT INTO engylt_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","and he hath bathed his flesh with water in the holy place, and hath put on his garments, and hath come out, and hath made his burnt-offering, and the burnt-offering of the people, and hath made atonement for himself and for the people; ");
INSERT INTO engylt_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","and with the fat of the sin-offering he doth make perfume on the altar. ");
INSERT INTO engylt_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","'And he who is sending away the goat for a goat of departure doth wash his garments, and hath bathed his flesh with water, and afterwards he cometh in unto the camp. ");
INSERT INTO engylt_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","'And the bullock of the sin-offering, and the goat of the sin-offering, whose blood hath been brought in to make atonement in the sanctuary, doth one bring out unto the outside of the camp, and they have burnt with fire their skins, and their flesh, and their dung; ");
INSERT INTO engylt_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","and he who is burning them doth wash his garments, and hath bathed his flesh with water, and afterwards he cometh in unto the camp. ");
INSERT INTO engylt_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","'And it hath been to you for a statute age-during, in the seventh month, in the tenth of the month, ye humble yourselves, and do no work — the native, and the sojourner who is sojourning in your midst; ");
INSERT INTO engylt_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","for on this day he maketh atonement for you, to cleanse you; from all your sins before Jehovah ye are clean; ");
INSERT INTO engylt_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","it is to you a sabbath of rest, and ye have humbled yourselves — a statute age-during. ");
INSERT INTO engylt_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","'And the priest whom he doth anoint, and whose hand he doth consecrate to act as priest instead of his father, hath made atonement, and hath put on the linen garments, the holy garments; ");
INSERT INTO engylt_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","and he hath made atonement for the holy sanctuary; and for the tent of meeting, even for the altar he doth make atonement; yea, for the priests, and for all the people of the assembly he maketh atonement. ");
INSERT INTO engylt_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","'And this hath been to you for a statute age-during, to make atonement for the sons of Israel, because of all their sins, once in a year;' and he doth as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","'Speak unto Aaron, and unto his sons, and unto all the sons of Israel; and thou hast said unto them, This is the thing which Jehovah hath commanded, saying, ");
INSERT INTO engylt_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Any man of the house of Israel who slaughtereth ox, or lamb, or goat, in the camp, or who slaughtereth at the outside of the camp, ");
INSERT INTO engylt_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","and unto the opening of the tent of meeting hath not brought it in to bring near an offering to Jehovah before the tabernacle of Jehovah, blood is reckoned to that man — blood he hath shed — and that man hath been cut off from the midst of his people; ");
INSERT INTO engylt_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","so that the sons of Israel do bring in their sacrifices which they are sacrificing on the face of the field, yea, they have brought them in to Jehovah, unto the opening of the tent of meeting, unto the priest, and they have sacrificed sacrifices of peace-offerings to Jehovah with them. ");
INSERT INTO engylt_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","'And the priest hath sprinkled the blood upon the altar of Jehovah, at the opening of the tent of meeting, and hath made perfume with the fat for sweet fragrance to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","and they sacrifice not any more their sacrifices to goats after which they are going a-whoring; a statute age-during is this to them, to their generations. ");
INSERT INTO engylt_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","'And unto them thou sayest: Any man of the house of Israel, or of the sojourners, who sojourneth in your midst, who causeth burnt-offering or sacrifice to ascend, ");
INSERT INTO engylt_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","and unto the opening of the tent of meeting doth not bring it in to make it to Jehovah — that man hath been cut off from his people. ");
INSERT INTO engylt_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","'And any man of the house of Israel, or of the sojourners, who is sojourning in your midst, who eateth any blood, I have even set My face against the person who is eating the blood, and have cut him off from the midst of his people; ");
INSERT INTO engylt_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","for the life of the flesh is in the blood, and I have given it to you on the altar, to make atonement for your souls; for it is the blood which maketh atonement for the soul. ");
INSERT INTO engylt_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","'Therefore I have said to the sons of Israel, No person among you doth eat blood, and the sojourner who is sojourning in your midst doth not eat blood; ");
INSERT INTO engylt_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","and any man of the sons of Israel, or of the sojourners, who is sojourning in your midst, who hunteth venison, beast or fowl, which is eaten — hath even poured out its blood, and hath covered it with dust; ");
INSERT INTO engylt_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","for it is the life of all flesh, its blood is for its life; and I say to the sons of Israel, Blood of any flesh ye do not eat, for the life of all flesh is its blood; any one eating it is cut off. ");
INSERT INTO engylt_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","'And any person who eateth a carcase or torn thing, among natives or among sojourners — hath both washed his garments, and hath bathed with water, and hath been unclean until the evening — then he hath been clean; ");
INSERT INTO engylt_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","and if he wash not, and his flesh bathe not — then he hath borne his iniquity.' ");
INSERT INTO engylt_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","'Speak unto the sons of Israel, and thou hast said unto them, I am Jehovah your God; ");
INSERT INTO engylt_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","according to the work of the land of Egypt in which ye have dwelt ye do not, and according to the work of the land of Canaan whither I am bringing you in, ye do not, and in their statutes ye walk not. ");
INSERT INTO engylt_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","'My judgments ye do, and My statutes ye keep, to walk in them; I am Jehovah your God; ");
INSERT INTO engylt_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","and ye have kept My statutes and My judgments which man doth and liveth in them; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","'None of you unto any relation of his flesh doth draw near to uncover nakedness; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","'The nakedness of thy father and the nakedness of thy mother thou dost not uncover, she is thy mother; thou dost not uncover her nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","'The nakedness of the wife of thy father thou dost not uncover; it is the nakedness of thy father. ");
INSERT INTO engylt_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","'The nakedness of thy sister, daughter of thy father, or daughter of thy mother, born at home or born without; thou dost not uncover their nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","'The nakedness of thy son's daughter, or of thy daughter's daughter: thou dost not uncover their nakedness; for theirs is thy nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","'The nakedness of a daughter of thy father's wife, begotten of thy father, she is thy sister; thou dost not uncover her nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","'The nakedness of a sister of thy father thou dost not uncover; she is a relation of thy father. ");
INSERT INTO engylt_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","'The nakedness of thy mother's sister thou dost not uncover; for she is thy mother's relation. ");
INSERT INTO engylt_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","'The nakedness of thy father's brother thou dost not uncover; unto his wife thou dost not draw near; she is thine aunt. ");
INSERT INTO engylt_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","'The nakedness of thy daughter-in-law thou dost not uncover; she is thy son's wife; thou dost not uncover her nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","'The nakedness of thy brother's wife thou dost not uncover; it is thy brother's nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","'The nakedness of a woman and her daughter thou dost not uncover; her son's daughter, and her daughter's daughter thou dost not take to uncover her nakedness; they are her relations; it is wickedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","'And a woman unto another thou dost not take, to be an adversary, to uncover her nakedness beside her, in her life. ");
INSERT INTO engylt_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","'And unto a woman in the separation of her uncleanness thou dost not draw near to uncover her nakedness. ");
INSERT INTO engylt_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","'And unto the wife of thy fellow thou dost not give thy seed of copulation, for uncleanness with her. ");
INSERT INTO engylt_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","'And of thy seed thou dost not give to pass over to the Molech; nor dost thou pollute the name of thy God; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","'And with a male thou dost not lie as one lieth with a woman; abomination it is. ");
INSERT INTO engylt_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","'And with any beast thou dost not give thy copulation, for uncleanness with it; and a woman doth not stand before a beast to lie down with it; confusion it is. ");
INSERT INTO engylt_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","'Ye are not defiled with all these, for with all these have the nations been defiled which I am sending away from before you; ");
INSERT INTO engylt_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","and the land is defiled, and I charge its iniquity upon it, and the land vomiteth out its inhabitants: ");
INSERT INTO engylt_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","and ye — ye have kept My statutes and My judgments, and do not any of all these abominations, the native and the sojourner who is sojourning in your midst, ");
INSERT INTO engylt_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(for all these abominations have the men of the land done who are before you, and the land is defiled), ");
INSERT INTO engylt_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","and the land doth not vomit you out in your defiling it, as it hath vomited out the nation which is before you; ");
INSERT INTO engylt_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","for any one who doth any of all these abominations — even the persons who are doing so, have been cut off from the midst of their people; ");
INSERT INTO engylt_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","and ye have kept My charge, so as not to do any of the abominable statutes which have been done before you, and ye do not defile yourselves with them; I am Jehovah your God.' ");
INSERT INTO engylt_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","'Speak unto all the company of the sons of Israel, and thou hast said unto them, Ye are holy, for holy am I, Jehovah, your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","'Each his mother and his father ye do fear, and My sabbaths ye do keep; I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","'Ye do not turn unto the idols, and a molten god ye do not make to yourselves; I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","'And when ye sacrifice a sacrifice of peace-offerings to Jehovah, at your pleasure ye do sacrifice it; ");
INSERT INTO engylt_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","in the day of your sacrificing it is eaten, and on the morrow, and that which is left unto the third day with fire is burnt, ");
INSERT INTO engylt_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","and if it be really eaten on the third day, it is an abomination, it is not pleasing, ");
INSERT INTO engylt_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","and he who is eating it his iniquity doth bear, for the holy thing of Jehovah he hath polluted, and that person hath been cut off from his people. ");
INSERT INTO engylt_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","'And in your reaping the harvest of your land ye do not completely reap the corner of thy field, and the gleaning of thy harvest thou dost not gather, ");
INSERT INTO engylt_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","and thy vineyard thou dost not glean, even the omitted part of thy vineyard thou dost not gather, to the poor and to the sojourner thou dost leave them; I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","'Ye do not steal, nor feign, nor lie one against his fellow. ");
INSERT INTO engylt_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","'And ye do not swear by My name to falsehood, or thou hast polluted the name of thy God; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","'Thou dost not oppress thy neighbour, nor take plunder; the wages of the hireling doth not remain with thee till morning. ");
INSERT INTO engylt_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","'Thou dost not revile the deaf; and before the blind thou dost not put a stumbling block; and thou hast been afraid of thy God; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","'Ye do not do perversity in judgment; thou dost not lift up the face of the poor, nor honour the face of the great; in righteousness thou dost judge thy fellow. ");
INSERT INTO engylt_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","'Thou dost not go slandering among thy people; thou dost not stand against the blood of thy neighbour; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","'Thou dost not hate thy brother in thy heart; thou dost certainly reprove thy fellow, and not suffer sin on him. ");
INSERT INTO engylt_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","'Thou dost not take vengeance, nor watch the sons of thy people; and thou hast had love to thy neighbour as thyself; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","'My statutes ye do keep: thy cattle thou dost not cause to gender with diverse kinds; thy field thou dost not sow with diverse kinds, and a garment of diverse kinds, shaatnez, doth not go up upon thee. ");
INSERT INTO engylt_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","'And when a man lieth with a woman with seed of copulation, and she a maid-servant, betrothed to a man, and not really ransomed, or freedom hath not been given to her, an investigation there is; they are not put to death, for she is not free. ");
INSERT INTO engylt_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","'And he hath brought in his guilt-offering to Jehovah, unto the opening of the tent of meeting, a ram for a guilt-offering, ");
INSERT INTO engylt_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","and the priest hath made atonement for him with the ram of the guilt-offering before Jehovah, for his sin which he hath sinned, and it hath been forgiven him because of his sin which he hath sinned. ");
INSERT INTO engylt_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","'And when ye come in unto the land, and have planted all kinds of trees for food, then ye have reckoned as uncircumcised its fruit, three years it is to you uncircumcised, it is not eaten, ");
INSERT INTO engylt_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","and in the fourth year all its fruit is holy — praises for Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","And in the fifth year ye do eat its fruit — to add to you its increase; I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","'Ye do not eat with the blood; ye do not enchant, nor observe clouds. ");
INSERT INTO engylt_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","'Ye do not round the corner of your head, nor destroy the corner of thy beard. ");
INSERT INTO engylt_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","'And a cutting for the soul ye do not put in your flesh; and a writing, a cross-mark, ye do not put on you; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","'Thou dost not pollute thy daughter to cause her to go a-whoring, that the land go not a-whoring, and the land hath been full of wickedness. ");
INSERT INTO engylt_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","'My sabbaths ye do keep, and My sanctuary ye do reverence; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","'Ye do not turn unto those having familiar spirits; and unto wizards ye do not seek, for uncleanness by them; I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","'At the presence of grey hairs thou dost rise up, and thou hast honoured the presence of an old man, and hast been afraid of thy God; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","'And when a sojourner sojourneth with thee in your land, thou dost not oppress him; ");
INSERT INTO engylt_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","as a native among you is the sojourner to you who is sojourning with you, and thou hast had love to him as to thyself, for sojourners ye have been in the land of Egypt; I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","'Ye do not do perversity in judgment, in mete-yard, in weight, or in liquid measure; ");
INSERT INTO engylt_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","righteous balances, righteous weights, a righteous ephah, and a righteous hin ye have; I am Jehovah your God, who hath brought you out from the land of Egypt; ");
INSERT INTO engylt_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","and ye have observed all my statutes, and all my judgments, and have done them; I am Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","'And unto the sons of Israel thou dost say, Any man of the sons of Israel, and of the sojourners who is sojourning in Israel, who giveth of his seed to the Molech, is certainly put to death; the people of the land do stone him with stones; ");
INSERT INTO engylt_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","and I — I set My face against that man, and have cut him off from the midst of his people, for of his seed he hath given to the Molech, so as to defile My sanctuary, and to pollute My holy name. ");
INSERT INTO engylt_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","'And if the people of the land really hide their eyes from that man, in his giving of his seed to the Molech, so as not to put him to death, ");
INSERT INTO engylt_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","then I have set My face against that man, and against his family, and have cut him off, and all who are going a-whoring after him, even going a-whoring after the Molech, from the midst of their people. ");
INSERT INTO engylt_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","'And the person who turneth unto those having familiar spirits, and unto the wizards, to go a-whoring after them, I have even set My face against that person, and cut him off from the midst of his people. ");
INSERT INTO engylt_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","'And ye have sanctified yourselves, and ye have been holy, for I am Jehovah your God; ");
INSERT INTO engylt_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","and ye have kept My statutes and have done them; I am Jehovah, sanctifying you. ");
INSERT INTO engylt_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","'For any man who revileth his father and his mother is certainly put to death; his father and his mother he hath reviled: his blood is on him. ");
INSERT INTO engylt_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","'And a man who committeth adultery with a man's wife — who committeth adultery with the wife of his neighbour — the adulterer and the adulteress are surely put to death. ");
INSERT INTO engylt_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","'And a man who lieth with his father's wife — the nakedness of his father he hath uncovered — both of them are certainly put to death; their blood is on them. ");
INSERT INTO engylt_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","'And a man who lieth with his daughter-in-law — both of them are certainly put to death; confusion they have made; their blood is on them. ");
INSERT INTO engylt_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","'And a man who lieth with a male as one lieth with a woman; abomination both of them have done; they are certainly put to death; their blood is on them. ");
INSERT INTO engylt_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","'And a man who taketh the woman and her mother — it is wickedness; with fire they burn him and them, and there is no wickedness in your midst. ");
INSERT INTO engylt_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","'And a man who giveth his lying with a beast is certainly put to death, and the beast ye do slay. ");
INSERT INTO engylt_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","'And a woman who draweth near unto any beast to lie with it — thou hast even slain the woman and the beast; they are certainly put to death; their blood is on them. ");
INSERT INTO engylt_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","'And a man who taketh his sister, a daughter of his father or daughter of his mother, and he hath seen her nakedness, and she seeth his nakedness: it is a shame; and they have been cut off before the eyes of the sons of their people; the nakedness of his sister he hath uncovered; his iniquity he beareth. ");
INSERT INTO engylt_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","'And a man who lieth with a sick woman, and hath uncovered her nakedness, her fountain he hath made bare, and she hath uncovered the fountain of her blood, — even both of them have been cut off from the midst of their people. ");
INSERT INTO engylt_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","'And the nakedness of thy mother's sister, and of thy father's sister, thou dost not uncover; because his relation he hath made bare; their iniquity they bear. ");
INSERT INTO engylt_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","'And a man who lieth with his aunt, the nakedness of his uncle he hath uncovered; their sin they bear; childless they die. ");
INSERT INTO engylt_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","'And a man who taketh his brother's wife — it is impurity; the nakedness of his brother he hath uncovered; childless they are. ");
INSERT INTO engylt_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","'And ye have kept all My statutes, and all My judgments, and have done them, and the land vomiteth you not out whither I am bringing you in to dwell in it; ");
INSERT INTO engylt_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","and ye walk not in the statutes of the nation which I am sending away from before you, for all these they have done, and I am wearied with them; ");
INSERT INTO engylt_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","and I say to you, Ye — ye do possess their ground, and I — I give it to you to possess it, a land flowing with milk and honey; I am Jehovah your God, who hath separated you from the peoples. ");
INSERT INTO engylt_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","'And ye have made separation between the pure beasts and the unclean, and between the unclean fowl and the pure, and ye do not make yourselves abominable by beast or by fowl, or by anything which creepeth on the ground which I have separated to you for unclean; ");
INSERT INTO engylt_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","and ye have been holy to Me; for holy am I, Jehovah; and I separate you from the peoples to become Mine. ");
INSERT INTO engylt_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","'And a man or woman — when there is in them a familiar spirit, or who are wizards — are certainly put to death; with stones they stone them; their blood is on them.' ");
INSERT INTO engylt_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","And Jehovah saith unto Moses, 'Speak unto the priests, sons of Aaron, and thou hast said unto them, For any person a priest is not defiled among his people, ");
INSERT INTO engylt_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","except for his relation who is near unto him — for his mother, and for his father, and for his son, and for his daughter, and for his brother. ");
INSERT INTO engylt_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","and for his sister, the virgin, who is near unto him, who hath not been to a man; for her he is defiled. ");
INSERT INTO engylt_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","'A master priest doth not defile himself among his people — to pollute himself; ");
INSERT INTO engylt_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","they do not make baldness on their head, and the corner of their beard they do not shave, and in their flesh they do not make a cutting; ");
INSERT INTO engylt_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","they are holy to their God, and they pollute not the name of their God, for the fire-offerings of Jehovah, bread of their God, they are bringing near, and have been holy. ");
INSERT INTO engylt_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","'A woman, a harlot, or polluted, they do not take, and a woman cast out from her husband they do not take, for he is holy to his God; ");
INSERT INTO engylt_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","and thou hast sanctified him, for the bread of thy God he is bringing near; he is holy to thee; for holy am I, Jehovah, sanctifying you. ");
INSERT INTO engylt_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","'And a daughter of any priest when she polluteth herself by going a-whoring — her father she is polluting; with fire she is burnt. ");
INSERT INTO engylt_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","'And the high priest of his brethren, on whose head is poured the anointing oil, and hath consecrated his hand to put on the garments, his head doth not uncover, nor rend his garments, ");
INSERT INTO engylt_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","nor beside any dead person doth he come; for his father and for his mother he doth not defile himself; ");
INSERT INTO engylt_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","nor from the sanctuary doth he go out, nor doth he pollute the sanctuary of his God, for the separation of the anointing oil of his God is on him; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","'And he taketh a wife in her virginity; ");
INSERT INTO engylt_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","widow, or cast out, or polluted one — a harlot — these he doth not take, but a virgin of his own people he doth take for a wife, ");
INSERT INTO engylt_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","and he doth not pollute his seed among his people; for I am Jehovah, sanctifying him.' ");
INSERT INTO engylt_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","'Speak unto Aaron, saying, No man of thy seed to their generations in whom there is blemish doth draw near to bring near the bread of his God, ");
INSERT INTO engylt_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","for no man in whom is blemish doth draw near — a man blind, or lame or dwarfed, or enlarged, ");
INSERT INTO engylt_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","or a man in whom there is a breach in the foot, or a breach in the hand, ");
INSERT INTO engylt_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","or hump-backed, or a dwarf, or with a mixture in his eye, or a scurvy person, or scabbed, or broken-testicled. ");
INSERT INTO engylt_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","'No man in whom is blemish (of the seed of Aaron the priest) doth come nigh to bring near the fire-offerings of Jehovah; blemish is in him; the bread of his God he doth not come nigh to bring near. ");
INSERT INTO engylt_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","'Bread of his God — of the most holy things, and of the holy things — he doth eat; ");
INSERT INTO engylt_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","only, unto the vail he doth not enter, and unto the altar he doth not draw nigh; for blemish is in him; and he doth not pollute My sanctuaries; for I am Jehovah, sanctifying them.' ");
INSERT INTO engylt_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","And Moses speaketh unto Aaron, and unto his sons, and unto all the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","'Speak unto Aaron, and unto his sons, and they are separated from the holy things of the sons of Israel, and they pollute not My holy name in what they are hallowing to Me; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","'Say unto them, To your generations, any man who draweth near, out of all your seed, unto the holy things which the sons of Israel do sanctify to Jehovah, and his uncleanness on him — even that person hath been cut off from before Me; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","'Any man of the seed of Aaron, and is leprous or hath an issue — of the holy things he doth not eat till that he is clean; and he who is coming against any uncleanness of a person, or a man whose seed of copulation goeth out from him, ");
INSERT INTO engylt_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or a man who cometh against any teeming thing which is unclean to him, or against a man who is unclean to him, even any of his uncleanness — ");
INSERT INTO engylt_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","the person who cometh against it — hath even been unclean till the evening, and doth not eat of the holy things, but hath bathed his flesh with water, ");
INSERT INTO engylt_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","and the sun hath gone in, and he hath been clean, and afterwards he doth eat of the holy things, for it is his food; ");
INSERT INTO engylt_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","a carcase or torn thing he doth not eat, for uncleanness thereby; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","'And they have kept My charge, and bear no sin for it, that they have died for it when they pollute it; I am Jehovah sanctifying them. ");
INSERT INTO engylt_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","'And no stranger doth eat of the holy thing; a settler of a priest and an hireling doth not eat of the holy thing; ");
INSERT INTO engylt_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","and when a priest buyeth a person, the purchase of his money, he doth eat of it, also one born in his house; they do eat of his bread. ");
INSERT INTO engylt_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","'And a priest's daughter, when she is a strange man's, — she, of the heave-offering of the holy things doth not eat; ");
INSERT INTO engylt_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","and a priest's daughter, when she is a widow, or cast out, and hath no seed, and hath turned back unto the house of her father, as in her youth, of her father's bread she doth eat; but no stranger doth eat of it. ");
INSERT INTO engylt_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","'And when a man doth eat of a holy thing through ignorance, then he hath added its fifth part to it, and hath given it to the priest, with the holy thing; ");
INSERT INTO engylt_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","and they do not pollute the holy things of the sons of Israel — that which they lift up to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","nor have caused them to bear the iniquity of the guilt-offering in their eating their holy things; for I am Jehovah, sanctifying them.' ");
INSERT INTO engylt_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","'Speak unto Aaron, and unto his sons, and unto all the sons of Israel, and thou hast said unto them, Any man of the house of Israel, or of the sojourners in Israel, who bringeth near his offering, of all his vows, or of all his willing offerings which they bring near to Jehovah for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","at your pleasure a perfect one, a male of the herd, of the sheep or of the goats; ");
INSERT INTO engylt_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","nothing in which is blemish do ye bring near, for it is not for a pleasing thing for you. ");
INSERT INTO engylt_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","'And when a man bringeth near a sacrifice of peace-offerings to Jehovah, to complete a vow, or for a willing-offering, of the herd or of the flock, it is perfect for a pleasing thing: no blemish is in it; ");
INSERT INTO engylt_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","blind, or broken, or maimed, or having a wen, or scurvy, or scabbed — ye do not bring these near to Jehovah, and a fire-offering ye do not make of them on the altar to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","'As to an ox or a sheep enlarged or dwarfed — a willing-offering ye do make it, but for a vow it is not pleasing. ");
INSERT INTO engylt_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","As to a bruised, or beaten, or enlarged, or cut thing — ye do not bring it near to Jehovah; even in your land ye do not do it. ");
INSERT INTO engylt_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","And from the hand of a son of a stranger ye do not bring near the bread of your God, of any of these, for their corruption is in them; blemish is in them; they are not pleasing for you.' ");
INSERT INTO engylt_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","'When ox or lamb or goat is born, and it hath been seven days under its dam, then from the eighth day and henceforth, it is pleasing for an offering, a fire-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","but an ox or sheep — it and its young one, ye do not slaughter in one day. ");
INSERT INTO engylt_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","'And when ye sacrifice a sacrifice of thanksgiving to Jehovah, at your pleasure ye do sacrifice, ");
INSERT INTO engylt_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","on that day it is eaten, ye do not leave of it till morning; I am Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","and ye have kept my commands, and have done them; I am Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","and ye do not pollute My holy name, and I have been hallowed in the midst of the sons of Israel; I am Jehovah, sanctifying you, ");
INSERT INTO engylt_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","who am bringing you up out of the land of Egypt, to become your God; I am Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","'Speak unto the sons of Israel, and thou hast said unto them, Appointed seasons of Jehovah, which ye proclaim, holy convocations, are these: they are My appointed seasons: ");
INSERT INTO engylt_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","six days is work done, and in the seventh day is a sabbath of rest, a holy convocation; ye do no work; it is a sabbath to Jehovah in all your dwellings. ");
INSERT INTO engylt_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","'These are appointed seasons of Jehovah, holy convocations, which ye proclaim in their appointed seasons: ");
INSERT INTO engylt_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","in the first month, on the fourteenth of the month, between the evenings, is the passover to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","and on the fifteenth day of this month is the feast of unleavened things to Jehovah; seven days unleavened things ye do eat; ");
INSERT INTO engylt_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","on the first day ye have a holy convocation, ye do no servile work; ");
INSERT INTO engylt_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","and ye have brought near a fire-offering to Jehovah seven days; in the seventh day is a holy convocation; ye do no servile work.' ");
INSERT INTO engylt_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","'Speak unto the sons of Israel, and thou hast said unto them, When ye come in unto the land which I am giving to you, and have reaped its harvest, and have brought in the sheaf, the beginning of your harvest unto the priest, ");
INSERT INTO engylt_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","then he hath waved the sheaf before Jehovah for your acceptance; on the morrow of the sabbath doth the priest wave it. ");
INSERT INTO engylt_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","'And ye have prepared in the day of your waving the sheaf a lamb, a perfect one, a son of a year, for a burnt-offering to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","and its present two tenth deals of flour mixed with oil, a fire-offering to Jehovah, a sweet fragrance, and its drink-offering, wine, a fourth of the hin. ");
INSERT INTO engylt_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","'And bread and roasted corn and full ears ye do not eat until this self-same day, until your bringing in the offering of your God — a statute age-during to your generations, in all your dwellings. ");
INSERT INTO engylt_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","'And ye have numbered to you from the morrow of the sabbath, from the day of your bringing in the sheaf of the wave-offering: they are seven perfect sabbaths; ");
INSERT INTO engylt_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","unto the morrow of the seventh sabbath ye do number fifty days, and ye have brought near a new present to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","out of your dwellings ye bring in bread of a wave-offering, two loaves, of two tenth deals of flour they are, with yeast they are baken, first -fruits to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","'And ye have brought near, besides the bread, seven lambs, perfect ones, sons of a year, and one bullock, a son of the herd, and two rams; they are a burnt-offering to Jehovah, with their present and their libations, a fire-offering of sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","'And ye have prepared one kid of the goats for a sin-offering, and two lambs, sons of a year, for a sacrifice of peace-offerings, ");
INSERT INTO engylt_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","and the priest hath waved them, besides the bread of the first -fruits — a wave-offering before Jehovah, besides the two lambs; they are holy to Jehovah for the priest; ");
INSERT INTO engylt_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","and ye have proclaimed on this self-same day: a holy convocation is to you, ye do no servile work — a statute age-during in all your dwellings, to your generations. ");
INSERT INTO engylt_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","'And in your reaping the harvest of your land thou dost not complete the corner of thy field in thy reaping, and the gleaning of thy harvest thou dost not gather, to the poor and to the sojourner thou dost leave them; I Jehovah am your God.' ");
INSERT INTO engylt_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","'Speak unto the sons of Israel, saying, In the seventh month, on the first of the month, ye have a sabbath, a memorial of shouting, a holy convocation; ");
INSERT INTO engylt_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ye do no servile work, and ye have brought near a fire-offering to Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","'Only — on the tenth of this seventh month is a day of atonements; ye have a holy convocation, and ye have humbled yourselves, and have brought near a fire-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","and ye do no work in this self-same day, for it is a day of atonements, to make atonement for you, before Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","'For any person who is not humbled in this self-same day hath even been cut off from his people; ");
INSERT INTO engylt_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","and any person who doth any work in this self-same day I have even destroyed that person from the midst of his people; ");
INSERT INTO engylt_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ye do no work — a statute age-during to your generations in all your dwellings. ");
INSERT INTO engylt_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It is a sabbath of rest to you, and ye have humbled yourselves in the ninth of the month at even; from evening till evening ye do keep your sabbath.' ");
INSERT INTO engylt_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","'Speak unto the sons of Israel, saying, In the fifteenth day of this seventh month is a feast of booths seven days to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","on the first day is a holy convocation, ye do no servile work, ");
INSERT INTO engylt_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","seven days ye bring near a fire-offering to Jehovah, on the eighth day ye have a holy convocation, and ye have brought near a fire-offering to Jehovah; it is a restraint, ye do no servile work. ");
INSERT INTO engylt_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","'These are appointed seasons of Jehovah, which ye proclaim holy convocations, to bring near a fire-offering to Jehovah, a burnt-offering, and a present, a sacrifice, and libations, a thing of a day in its day, ");
INSERT INTO engylt_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","apart from the sabbaths of Jehovah, and apart from your gifts, and apart from all your vows, and apart from all your willing-offerings, which ye give to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","'Only — in the fifteenth day of the seventh month, in your gathering the increase of the land, ye do keep the feast of Jehovah seven days; on the first day is a sabbath, and on the eighth day a sabbath; ");
INSERT INTO engylt_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","and ye have taken to yourselves on the first day the fruit of beautiful trees, branches of palms, and boughs of thick trees, and willows of a brook, and have rejoiced before Jehovah your God seven days. ");
INSERT INTO engylt_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","'And ye have kept it a feast to Jehovah, seven days in a year — a statute age-during to your generations; in the seventh month ye keep it a feast. ");
INSERT INTO engylt_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","'In booths ye dwell seven days; all who are natives in Israel dwell in booths, ");
INSERT INTO engylt_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","so that your generations do know that in booths I caused the sons of Israel to dwell; in my bringing them out of the land of Egypt; I, Jehovah, am your God.' ");
INSERT INTO engylt_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","And Moses speaketh concerning the appointed seasons of Jehovah unto the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","'Command the sons of Israel, and they bring unto thee pure olive oil, beaten, for the lamp, to cause a light to go up continually; ");
INSERT INTO engylt_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","at the outside of the vail of the testimony in the tent of meeting doth Aaron arrange it from evening till morning before Jehovah continually — a statute age-during to your generations; ");
INSERT INTO engylt_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","by the pure candlestick he doth arrange the lights before Jehovah continually. ");
INSERT INTO engylt_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","'And thou hast taken flour, and hast baked twelve cakes with it, two tenth deals are in the one cake, ");
INSERT INTO engylt_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","and thou hast set them two ranks (six in the rank) on the pure table before Jehovah, ");
INSERT INTO engylt_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","and thou hast put on the rank pure frankincense, and it hath been to the bread for a memorial, a fire-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","'On each sabbath-day he arrangeth it before Jehovah continually, from the sons of Israel — a covenant age-during; ");
INSERT INTO engylt_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","and it hath been to Aaron, and to his sons, and they have eaten it in the holy place, for it is most holy to him, from the fire-offerings of Jehovah — a statute age-during.' ");
INSERT INTO engylt_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","And a son of an Israelitish woman goeth out (and he is son of an Egyptian man), in the midst of the sons of Israel, and strive in the camp do the son of the Israelitish woman and a man of Israel, ");
INSERT INTO engylt_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","and the son of the Israelitish woman execrateth the Name, and revileth; and they bring him in unto Moses; and his mother's name is Shelomith daughter of Dibri, of the tribe of Dan; ");
INSERT INTO engylt_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","and he causeth him to rest in charge — to explain to them by the mouth of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","'Bring out the reviler unto the outside of the camp; and all those hearing have laid their hands on his head, and all the company have stoned him. ");
INSERT INTO engylt_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","'And unto the sons of Israel thou dost speak, saying, When any man revileth his God — then he hath borne his sin; ");
INSERT INTO engylt_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","and he who is execrating the name of Jehovah is certainly put to death; all the company do certainly cast stones at him; as a sojourner so a native, in his execrating the Name, is put to death. ");
INSERT INTO engylt_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","'And when a man smiteth any soul of man, he is certainly put to death. ");
INSERT INTO engylt_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","'And he who smiteth a beast repayeth it, body for body. ");
INSERT INTO engylt_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","'And when a man putteth a blemish in his fellow, as he hath done so it is done to him; ");
INSERT INTO engylt_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","breach for breach, eye for eye, tooth for tooth; as he putteth a blemish in a man so it is done in him. ");
INSERT INTO engylt_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","'And he who smiteth a beast repayeth it, and he who smiteth the life of man is put to death; ");
INSERT INTO engylt_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","one judgment is to you; as a sojourner so is a native; for I am Jehovah your God.' ");
INSERT INTO engylt_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","And Moses speaketh unto the sons of Israel, and they bring out the reviler unto the outside of the camp, and stone him with stones; and the sons of Israel have done as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","And Jehovah speaketh unto Moses, in mount Sinai, saying, ");
INSERT INTO engylt_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","'Speak unto the sons of Israel, and thou hast said unto them, When ye come in unto the land which I am giving to you, then hath the land kept a sabbath to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","'Six years thou dost sow thy field, and six years thou dost prune thy vineyard, and hast gathered its increase, ");
INSERT INTO engylt_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","and in the seventh year a sabbath of rest is to the land, a sabbath to Jehovah; thy field thou dost not sow, and thy vineyard thou dost not prune; ");
INSERT INTO engylt_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","the spontaneous growth of thy harvest thou dost not reap, and the grapes of thy separated thing thou dost not gather, a year of rest it is to the land. ");
INSERT INTO engylt_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","'And the sabbath of the land hath been to you for food, to thee, and to thy man-servant, and to thy handmaid, and to thy hireling, and to thy settler, who are sojourning with thee; ");
INSERT INTO engylt_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","and to thy cattle, and to the beast which is in thy land, is all thine increase for food. ");
INSERT INTO engylt_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","'And thou hast numbered to thee seven sabbaths of years, seven years seven times, and the days of the seven sabbaths of years have been to thee nine and forty years, ");
INSERT INTO engylt_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","and thou hast caused a trumpet of shouting to pass over in the seventh month, in the tenth of the month; in the day of the atonements ye do cause a trumpet to pass over through all your land; ");
INSERT INTO engylt_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","and ye have hallowed the year, the fiftieth year; and ye have proclaimed liberty in the land to all its inhabitants; a jubilee it is to you; and ye have turned back each unto his possession; yea, each unto his family ye do turn back. ");
INSERT INTO engylt_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","'A jubilee it is, the fiftieth year, a year it is to you; ye sow not, nor reap its spontaneous growth, nor gather its separated things; ");
INSERT INTO engylt_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","for a jubilee it is, holy it is to you; out of the field ye eat its increase; ");
INSERT INTO engylt_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","in the year of this jubilee ye turn back each unto his possession. ");
INSERT INTO engylt_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","'And when thou sellest anything to thy fellow, or buyest from the hand of thy fellow, ye do not oppress one another; ");
INSERT INTO engylt_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","by the number of years after the jubilee thou dost buy from thy fellow; by the number of the years of increase he doth sell to thee; ");
INSERT INTO engylt_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","according to the multitude of the years thou dost multiply its price, and according to the fewness of the years thou dost diminish its price; for a number of increases he is selling to thee; ");
INSERT INTO engylt_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","and ye do not oppress one another, and thou hast been afraid of thy God; for I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","'And ye have done My statutes, and My judgments ye keep, and have done them, and ye have dwelt on the land confidently, ");
INSERT INTO engylt_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","and the land hath given its fruit, and ye have eaten to satiety, and have dwelt confidently on it. ");
INSERT INTO engylt_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","'And when ye say, What do we eat in the seventh year, lo, we do not sow, nor gather our increase? ");
INSERT INTO engylt_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","then I have commanded My blessing on you in the sixth year, and it hath made the increase for three years; ");
INSERT INTO engylt_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","and ye have sown the eighth year, and have eaten of the old increase; until the ninth year, until the coming in of its increase, ye do eat the old. ");
INSERT INTO engylt_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","'And the land is not sold — to extinction, for the land is Mine, for sojourners and settlers are ye with Me; ");
INSERT INTO engylt_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","and in all the land of your possession a redemption ye do give to the land. ");
INSERT INTO engylt_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","'When thy brother becometh poor, and hath sold his possession, then hath his redeemer who is near unto him come, and he hath redeemed the sold thing of his brother; ");
INSERT INTO engylt_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","and when a man hath no redeemer, and his own hand hath attained, and he hath found as sufficient for its redemption, ");
INSERT INTO engylt_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","then he hath reckoned the years of its sale, and hath given back that which is over to the man to whom he sold it, and he hath returned to his possession. ");
INSERT INTO engylt_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","'And if his hand hath not found sufficiency to give back to him, then hath his sold thing been in the hand of him who buyeth it till the year of jubilee; and it hath gone out in the jubilee, and he hath returned to his possession. ");
INSERT INTO engylt_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","'And when a man selleth a dwelling-house in a walled city, then hath his right of redemption been until the completion of a year from its selling; days — is his right of redemption; ");
INSERT INTO engylt_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","and if it is not redeemed until the fulness to him of a perfect year, then hath the house which is in a walled city been established to extinction to the buyer of it, to his generations; it goeth not out in the jubilee; ");
INSERT INTO engylt_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","and a house of the villages which have no wall round about, on the field of the country is reckoned; redemption is to it, and in the jubilee it goeth out. ");
INSERT INTO engylt_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","'As to cities of the Levites — houses of the cities of their possession — redemption age-during is to the Levites; ");
INSERT INTO engylt_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","as to him who redeemeth from the Levites, both the sale of a house and the city of his possession have gone out in the jubilee, for the houses of the cities of the Levites are their possession in the midst of the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","And a field, a suburb of their cities, is not sold; for a possession age-during it is to them. ");
INSERT INTO engylt_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","'And when thy brother is become poor, and his hand hath failed with thee, then thou hast kept hold on him, sojourner and settler, and he hath lived with thee; ");
INSERT INTO engylt_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","thou takest no usury from him, or increase; and thou hast been afraid of thy God; and thy brother hath lived with thee; ");
INSERT INTO engylt_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","thy money thou givest not to him in usury, and for increase thou givest not thy food; ");
INSERT INTO engylt_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am Jehovah your God, who hath brought you out of the land of Egypt, to give to you the land of Canaan, to become your God. ");
INSERT INTO engylt_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","'And when thy brother becometh poor with thee, and he hath been sold to thee, thou dost not lay on him servile service; ");
INSERT INTO engylt_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","as an hireling, as a settler, he is with thee, till the year of the jubilee he doth serve with thee, — ");
INSERT INTO engylt_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","then he hath gone out from thee, he and his sons with him, and hath turned back unto his family; even unto the possession of his fathers he doth turn back. ");
INSERT INTO engylt_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","'For they are My servants, whom I have brought out from the land of Egypt: they are not sold with the sale of a servant; ");
INSERT INTO engylt_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","thou rulest not over him with rigour, and thou hast been afraid of thy God. ");
INSERT INTO engylt_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","'And thy man-servant and thy handmaid whom thou hast are of the nations who are round about you; of them ye buy man-servant and handmaid, ");
INSERT INTO engylt_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","and also of the sons of the settlers who are sojourning with you, of them ye buy, and of their families who are with you, which they have begotten in your land, and they have been to you for a possession; ");
INSERT INTO engylt_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","and ye have taken them for inheritance to your sons after you, to occupy for a possession; to the age ye lay service upon them, but upon your brethren, the sons of Israel, one with another, thou dost not rule over him with rigour. ");
INSERT INTO engylt_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","'And when the hand of a sojourner or settler with thee attaineth riches, and thy brother with him hath become poor, and he hath been sold to a sojourner, a settler with thee, or to the root of the family of a sojourner, ");
INSERT INTO engylt_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","after he hath been sold, there is a right of redemption to him; one of his brethren doth redeem him, ");
INSERT INTO engylt_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","or his uncle, or a son of his uncle, doth redeem him, or any of the relations of his flesh, of his family, doth redeem him, or — his own hand hath attained — then he hath been redeemed. ");
INSERT INTO engylt_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","'And he hath reckoned with his buyer from the year of his being sold to him till the year of jubilee, and the money of his sale hath been by the number of years; as the days of an hireling it is with him. ");
INSERT INTO engylt_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","'If yet many years, according to them he giveth back his redemption money, from the money of his purchase. ");
INSERT INTO engylt_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","'And if few are left of the years till the year of jubilee, then he hath reckoned with him, according to his years he doth give back his redemption money; ");
INSERT INTO engylt_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","as an hireling, year by year, he is with him, and he doth not rule him with rigour before thine eyes. ");
INSERT INTO engylt_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","'And if he is not redeemed in these years, then he hath gone out in the year of jubilee, he and his sons with him. ");
INSERT INTO engylt_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For to Me are the sons of Israel servants; My servants they are, whom I have brought out of the land of Egypt; I, Jehovah, am your God. ");
INSERT INTO engylt_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","'Ye do not make to yourselves idols; and graven image or standing image ye do not set up to yourselves; and a stone of imagery ye do not put in your land, to bow yourselves to it; for I am Jehovah your God. ");
INSERT INTO engylt_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","'My sabbaths ye do keep, and My sanctuary ye do reverence; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","'If in My statutes ye walk, and My commands ye keep, and have done them, ");
INSERT INTO engylt_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","then I have given your rains in their season, and the land hath given her produce, and the tree of the field doth give its fruit; ");
INSERT INTO engylt_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","and reached to you hath the threshing, the gathering, and the gathering doth reach the sowing -time; and ye have eaten your bread to satiety, and have dwelt confidently in your land. ");
INSERT INTO engylt_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","'And I have given peace in the land, and ye have lain down, and there is none causing trembling; and I have caused evil beasts to cease out of the land, and the sword doth not pass over into your land. ");
INSERT INTO engylt_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","'And ye have pursued your enemies, and they have fallen before you by the sword; ");
INSERT INTO engylt_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","and five of you have pursued a hundred, and a hundred of you do pursue a myriad; and your enemies have fallen before you by the sword. ");
INSERT INTO engylt_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","'And I have turned unto you, and have made you fruitful, and have multiplied you, and have established My covenant with you; ");
INSERT INTO engylt_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","and ye have eaten old store, and the old because of the new ye bring out. ");
INSERT INTO engylt_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","'And I have given My tabernacle in your midst, and My soul doth not loathe you; ");
INSERT INTO engylt_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","and I have walked habitually in your midst, and have become your God, and ye — ye are become My people; ");
INSERT INTO engylt_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am Jehovah your God, who have brought you out of the land of the Egyptians, from being their servants; and I break the bars of your yoke, and cause you to go erect. ");
INSERT INTO engylt_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","'And if ye do not hearken to Me, and do not all these commands; ");
INSERT INTO engylt_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","and if at My statutes ye kick, and if My judgments your soul loathe, so as not to do all My commands — to your breaking My covenant — ");
INSERT INTO engylt_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","I also do this to you, and I have appointed over you trouble, the consumption, and the burning fever, consuming eyes, and causing pain of soul; and your seed in vain ye have sowed, and your enemies have eaten it; ");
INSERT INTO engylt_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","and I have set My face against you, and ye have been smitten before your enemies; and those hating you have ruled over you, and ye have fled, and there is none pursuing you. ");
INSERT INTO engylt_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","'And if unto these ye hearken not to Me, — then I have added to chastise you seven times for your sins; ");
INSERT INTO engylt_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","and I have broken the pride of your strength, and have made your heavens as iron, and your earth as brass; ");
INSERT INTO engylt_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","and consumed hath been your strength in vain, and your land doth not give her produce, and the tree of the land doth not give its fruit. ");
INSERT INTO engylt_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","'And if ye walk with Me in opposition, and are not willing to hearken to Me, then I have added to you a plague seven times, according to your sins, ");
INSERT INTO engylt_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","and sent against you the beast of the field, and it hath bereaved you; and I have cut off your cattle, and have made you few, and your ways have been desolate. ");
INSERT INTO engylt_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","'And if by these ye are not instructed by Me, and have walked with Me in opposition, ");
INSERT INTO engylt_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","then I have walked — I also — with you in opposition, and have smitten you, even I, seven times for your sins; ");
INSERT INTO engylt_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","and I have brought in on you a sword, executing the vengeance of a covenant; and ye have been gathered unto your cities, and I have sent pestilence into your midst, and ye have been given into the hand of an enemy. ");
INSERT INTO engylt_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","'In My breaking to you the staff of bread, then ten women have baked your bread in one oven, and have given back your bread by weight; and ye have eaten, and are not satisfied. ");
INSERT INTO engylt_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","'And if for this ye hearken not to Me, and have walked with Me in opposition, ");
INSERT INTO engylt_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","then I have walked with you in the fury of opposition, and have chastised you, even I, seven times for your sins. ");
INSERT INTO engylt_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","'And ye have eaten the flesh of your sons; even flesh of your daughters ye do eat. ");
INSERT INTO engylt_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","And I have destroyed your high places, and cut down your images, and have put your carcases on the carcases of your idols, and My soul hath loathed you; ");
INSERT INTO engylt_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","and I have made your cities a waste, and have made desolate your sanctuaries, and I smell not at your sweet fragrances; ");
INSERT INTO engylt_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","and I have made desolate the land, and your enemies, who are dwelling in it, have been astonished at it. ");
INSERT INTO engylt_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","And you I scatter among nations, and have drawn out after you a sword, and your land hath been a desolation, and your cities are a waste. ");
INSERT INTO engylt_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","'Then doth the land enjoy its sabbaths — all the days of the desolation, and ye in the land of your enemies — then doth the land rest, and hath enjoyed its sabbaths; ");
INSERT INTO engylt_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","all the days of the desolation it resteth that which it hath not rested in your sabbaths in your dwelling on it. ");
INSERT INTO engylt_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","'And those who are left of you — I have also brought a faintness into their heart in the lands of their enemies, and the sound of a leaf driven away hath pursued them, and they have fled — flight from a sword — and they have fallen, and there is none pursuing. ");
INSERT INTO engylt_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","And they have stumbled one on another, as from the face of a sword, and there is none pursuing, and ye have no standing before your enemies, ");
INSERT INTO engylt_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","and ye have perished among the nations, and the land of your enemies hath consumed you. ");
INSERT INTO engylt_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","'And those who are left of you — they consume away in their iniquity, in the lands of your enemies; and also in the iniquities of their fathers, with them they consume away. ");
INSERT INTO engylt_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","'And — they have confessed their iniquity, and the iniquity of their fathers, in their trespass which they have trespassed against Me, and also, that they have walked with Me, in opposition, ");
INSERT INTO engylt_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","also I walk to them in opposition, and have brought them into the land of their enemies — or then their uncircumcised heart is humbled, and then they accept the punishment of their iniquity, — ");
INSERT INTO engylt_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","then I have remembered My covenant with Jacob, and also My covenant with Isaac, and also My covenant with Abraham I remember, and the land I remember. ");
INSERT INTO engylt_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","'And — the land is left of them, and doth enjoy its sabbaths, in the desolation without them, and they accept the punishment of their iniquity, because, even because, against My judgments they have kicked, and My statutes hath their soul loathed, ");
INSERT INTO engylt_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","and also even this, in their being in the land of their enemies, I have not rejected them, nor have I loathed them, to consume them, to break My covenant with them; for I am Jehovah their God; — ");
INSERT INTO engylt_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","then I have remembered for them the covenant of the ancestors, whom I brought forth out of the land of Egypt before the eyes of the nations to become their God; I am Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the statutes, and the judgments, and the laws, which Jehovah hath given between Him and the sons of Israel, in mount Sinai, by the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","'Speak unto the sons of Israel, and thou hast said unto them, When a man maketh a wonderful vow, by thy valuation the persons are Jehovah's. ");
INSERT INTO engylt_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","When thy valuation hath been of the male from a son of twenty years even unto a son of sixty years, then hath been thy valuation fifty shekels of silver by the shekel of the sanctuary. ");
INSERT INTO engylt_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","And if it is a female — then hath thy valuation been thirty shekels; ");
INSERT INTO engylt_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","and if from a son of five years even unto a son of twenty years — then hath thy valuation been of the male twenty shekels, and for the female, ten shekels; ");
INSERT INTO engylt_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","and if from a son of a month even unto a son of five years — then hath thy valuation been of the male five shekels of silver, and for the female thy valuation is three shekels of silver; ");
INSERT INTO engylt_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","and if from a son of sixty years and above — if a male, then hath thy valuation been fifteen shekels, and for a female, ten shekels. ");
INSERT INTO engylt_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","'And if he is poorer than thy valuation, then he hath presented himself before the priest, and the priest hath valued him; according to that which the hand of him who is vowing doth reach doth the priest value him. ");
INSERT INTO engylt_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","'And if it is a beast of which they bring near an offering to Jehovah, all that one giveth of it to Jehovah is holy; ");
INSERT INTO engylt_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","he doth not change it nor exchange it, a good for a bad, or a bad for a good; and if he really change beast for beast, — then it hath been — it and its exchange is holy. ");
INSERT INTO engylt_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","'And if it is any unclean beast of which they do not bring near an offering to Jehovah, then he hath presented the beast before the priest, ");
INSERT INTO engylt_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","and the priest hath valued it; whether good or bad, according to thy valuation, O priest, so it is; ");
INSERT INTO engylt_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","and if he really redeem it, then he hath added its fifth to thy valuation. ");
INSERT INTO engylt_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","'And when a man sanctifieth his house, a holy thing to Jehovah, then hath the priest valued it, whether good or bad; as the priest doth value it so it standeth; ");
INSERT INTO engylt_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","and if he who is sanctifying doth redeem his house, then he hath added a fifth of the money of thy valuation to it, and it hath become his. ");
INSERT INTO engylt_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","'And if of the field of his possession a man sanctify to Jehovah, then hath thy valuation been according to its seed; a homer of barley-seed at fifty shekels of silver; ");
INSERT INTO engylt_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","if from the year of the jubilee he sanctify his field, according to thy valuation it standeth; ");
INSERT INTO engylt_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","and if after the jubilee he sanctify his field, then hath the priest reckoned to him the money according to the years which are left, unto the year of the jubilee, and it hath been abated from thy valuation. ");
INSERT INTO engylt_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","'And if he really redeem the field — he who is sanctifying it — then he hath added a fifth of the money of thy valuation to it, and it hath been established to him; ");
INSERT INTO engylt_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","and if he do not redeem the field, or if he hath sold the field to another man, it is not redeemed any more; ");
INSERT INTO engylt_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","and the field hath been, in its going out in the jubilee, holy to Jehovah as a field which is devoted; to the priest is its possession. ");
INSERT INTO engylt_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","'And if the field of his purchase (which is not of the fields of his possession) one sanctify to Jehovah — ");
INSERT INTO engylt_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","then hath the priest reckoned to him the amount of thy valuation unto the year of jubilee, and he hath given thy valuation in that day — a holy thing to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","in the year of the jubilee the field returneth to him from whom he bought it, to him whose is the possession of the land. ");
INSERT INTO engylt_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","And all thy valuation is by the shekel of the sanctuary: twenty gerahs is the shekel. ");
INSERT INTO engylt_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","'Only, a firstling which is Jehovah's firstling among beasts — no man doth sanctify it, whether ox or sheep; it is Jehovah's. ");
INSERT INTO engylt_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","And if among the unclean beasts, then he hath ransomed it at thy valuation, and he hath added its fifth to it; and if it is not redeemed, then it hath been sold at thy valuation. ");
INSERT INTO engylt_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","'Only, no devoted thing which a man devoteth to Jehovah, of all that he hath, of man, and beast, and of the field of his possession, is sold or redeemed; every devoted thing is most holy to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","'No devoted thing, which is devoted of man, is ransomed, it is surely put to death. ");
INSERT INTO engylt_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","And all tithe of the land, of the seed of the land, of the fruit of the tree, is Jehovah's — holy to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","'And if a man really redeem any of his tithe, its fifth he addeth to it. ");
INSERT INTO engylt_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","'And all the tithe of the herd and of the flock — all that passeth by under the rod — the tenth is holy to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","he enquireth not between good and bad, nor doth he change it; and if he really change it — then it hath been — it and its exchange is holy; it is not redeemed.' ");
INSERT INTO engylt_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commands which Jehovah hath commanded Moses for the sons of Israel, in mount Sinai. ");
INSERT INTO engylt_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","And Jehovah speaketh unto Moses in the wilderness of Sinai, in the tent of meeting, on the first of the second month, in the second year of their going out of the land of Egypt, saying: ");
INSERT INTO engylt_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","'Take ye up the sum of all the company of the sons of Israel by their families, by the house of their fathers, in the number of names — every male by their polls; ");
INSERT INTO engylt_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","from a son of twenty years and upward, every one going out to the host in Israel, ye do number them by their hosts, thou and Aaron; ");
INSERT INTO engylt_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","and with you there is a man for a tribe, each is a head to the house of his fathers. ");
INSERT INTO engylt_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","'And these are the names of the men who stand with you: 'For Reuben — Elizur son of Shedeur. ");
INSERT INTO engylt_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","'For Simeon — Shelumiel son of Zurishaddai. ");
INSERT INTO engylt_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","'For Judah — Nahshon son of Amminadab. ");
INSERT INTO engylt_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","'For Issachar — Nathaneel son of Zuar. ");
INSERT INTO engylt_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","'For Zebulun — Eliab son of Helon. ");
INSERT INTO engylt_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","'For the sons of Joseph — for Ephraim: Elishama son of Ammihud: for Manasseh — Gamaliel son of Pedahzur. ");
INSERT INTO engylt_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","'For Benjamin — Abidan son of Gideoni. ");
INSERT INTO engylt_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","'For Dan — Ahiezer son of Ammishaddai. ");
INSERT INTO engylt_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","'For Asher — Pagiel son of Ocran. ");
INSERT INTO engylt_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","'For Gad — Eliasaph son of Deuel. ");
INSERT INTO engylt_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","'For Naphtali — Ahira son of Enan.' ");
INSERT INTO engylt_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These are those called of the company, princes of the tribes of their fathers; they are heads of the thousands of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","And Moses taketh — Aaron also — these men, who were defined by name, ");
INSERT INTO engylt_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","and all the company they assembled on the first of the second month, and they declare their births, by their families, by the house of their fathers, in the number of names from a son of twenty years and upward, by their polls, ");
INSERT INTO engylt_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","as Jehovah hath commanded Moses; and he numbereth them in the wilderness of Sinai. ");
INSERT INTO engylt_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","And the sons of Reuben, Israel's first-born — their births, by their families, by the house of their fathers, in the number of names, by their polls, every male from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","their numbered ones, for the tribe of Reuben, are six and forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Of the sons of Simeon — their births, by their families, by the house of their fathers, its numbered ones in the number of names, by their polls, every male from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","their numbered ones, for the tribe of Simeon, are nine and fifty thousand and three hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Of the sons of Gad — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","their numbered ones, for the tribe of Gad, are five and forty thousand and six hundred and fifty. ");
INSERT INTO engylt_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Of the sons of Judah — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","their numbered ones, for the tribe of Judah, are four and seventy thousand and six hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Of the sons of Issachar — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","their numbered ones, for the tribe of Issachar, are four and fifty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Of the sons of Zebulun — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","their numbered ones, for the tribe of Zebulun, are seven and fifty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Of the sons of Joseph — of the sons of Ephraim — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","their numbered ones, for the tribe of Ephraim, are forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Of the sons of Manasseh — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","their numbered ones, for the tribe of Manasseh, are two and thirty thousand and two hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Of the sons of Benjamin — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","their numbered ones, for the tribe of Benjamin, are five and thirty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Of the sons of Dan — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","their numbered ones, for the tribe of Dan, are two and sixty thousand and seven hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Of the sons of Asher — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","their numbered ones, for the tribe of Asher, are one and forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Of the sons of Naphtali — their births, by their families, by the house of their fathers, in the number of names, from a son of twenty years and upward, every one going out to the host — ");
INSERT INTO engylt_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","their numbered ones, for the tribe of Naphtali, are three and fifty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These are those numbered, whom Moses numbered — Aaron also, and the princes of Israel, twelve men — each for the house of his fathers, they have been. ");
INSERT INTO engylt_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","And they are, all those numbered of the sons of Israel, by the house of their fathers, from a son of twenty years and upward, every one going out to the host in Israel, ");
INSERT INTO engylt_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","yea, all those numbered are six hundred thousand, and three thousand, and five hundred and fifty. ");
INSERT INTO engylt_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","And the Levites, for the tribe of their fathers, have not numbered themselves in their midst, ");
INSERT INTO engylt_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","seeing Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","'Only, the tribe of Levi thou dost not number, and their sum thou dost not take up in the midst of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","and thou, appoint the Levites over the tabernacle of the testimony, and over all its vessels, and over all that it hath; they bear the tabernacle, and all its vessels, and they serve it; and round about the tabernacle they encamp. ");
INSERT INTO engylt_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","'And in the journeying of the tabernacle, the Levites take it down, and in the encamping of the tabernacle, the Levites raise it up; and the stranger who is coming near is put to death.' ");
INSERT INTO engylt_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","And the sons of Israel have encamped, each by his camp, and each by his standard, by their hosts; ");
INSERT INTO engylt_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","and the Levites encamp round about the tabernacle of the testimony; and there is no wrath on the company of the sons of Israel, and the Levites have kept the charge of the tabernacle of the testimony. ");
INSERT INTO engylt_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","And the sons of Israel do according to all that Jehovah hath commanded Moses; so they have done. ");
INSERT INTO engylt_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","'Each by his standard, with ensigns of the house of their fathers, do the sons of Israel encamp; over-against round about the tent of meeting they encamp.' ");
INSERT INTO engylt_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","And those encamping eastward towards the sun-rising, are of the standard of the camp of Judah, by their hosts; and the prince of the sons of Judah is Nahshon, son of Amminadab; ");
INSERT INTO engylt_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","and his host, and their numbered ones, are four and seventy thousand and six hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","And those encamping by him are of the tribe of Issachar; and the prince of the sons of Issachar is Nethaneel son of Zuar; ");
INSERT INTO engylt_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","and his host, and its numbered ones, are four and fifty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","The tribe of Zebulun; and the prince of the sons of Zebulun is Eliab son of Helon; ");
INSERT INTO engylt_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","and his host, and its numbered ones, are seven and fifty thousand and four hundred; ");
INSERT INTO engylt_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","all those numbered of the camp of Judah are a hundred thousand, and eighty thousand, and six thousand, and four hundred, by their hosts; they journey first. ");
INSERT INTO engylt_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","The standard of the camp of Reuben is southward, by their hosts; and the prince of the sons of Reuben is Elizur son of Shedeur; ");
INSERT INTO engylt_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","and his host, and its numbered ones, are six and forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","And those encamping by him are of the tribe of Simeon; and the prince of the sons of Simeon is Shelumiel son of Zurishaddai; ");
INSERT INTO engylt_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","and his host, and their numbered ones, are nine and fifty thousand and three hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","And the tribe of Gad; and the prince of the sons of Gad is Eliasaph son of Reuel; ");
INSERT INTO engylt_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","and his host, and their numbered ones, are five and forty thousand and six hundred and fifty. ");
INSERT INTO engylt_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","All those numbered of the camp of Reuben are a hundred thousand, and one and fifty thousand, and four hundred and fifty, by their hosts; and they journey second. ");
INSERT INTO engylt_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","And the tent of meeting — the camp of the Levites — hath journeyed in the midst of the camps; as they encamp so they journey, each at his station by their standards. ");
INSERT INTO engylt_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","The standard of the camp of Ephraim, by their hosts, is westward; and the prince of the sons of Ephraim is Elishama son of Ammihud; ");
INSERT INTO engylt_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","and his host, and their numbered ones, are forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","And by him is the tribe of Manasseh; and the prince of the sons of Manasseh is Gamaliel son of Pedahzur; ");
INSERT INTO engylt_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","and his host, and their numbered ones, are two and thirty thousand, and two hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","And the tribe of Benjamin; and the prince of the sons of Benjamin is Abidan son of Gideoni; ");
INSERT INTO engylt_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","and his host, and their numbered ones, are five and thirty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","All those numbered of the camp of Ephraim are a hundred thousand, and eight thousand, and a hundred, by their hosts; and they journey third. ");
INSERT INTO engylt_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","The standard of the camp of Dan is northward, by their hosts; and the prince of the sons of Dan is Ahiezer son of Ammishaddai; ");
INSERT INTO engylt_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","and his host, and their numbered ones, are two and sixty thousand and seven hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","And those encamping by him are of the tribe of Asher; and the prince of the sons of Asher is Pagiel son of Ocran; ");
INSERT INTO engylt_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","and his host, and their numbered ones, are one and forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","And the tribe of Naphtali; and the prince of the sons of Naphtali is Ahira son of Enan; ");
INSERT INTO engylt_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","and his host, and their numbered ones, are three and fifty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","All those numbered of the camp of Dan are a hundred thousand, and seven and fifty thousand, and six hundred; at the rear they journey, by their standards. ");
INSERT INTO engylt_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are those numbered of the sons of Israel by the house of their fathers; all those numbered of the camps by their hosts are six hundred thousand, and three thousand, and five hundred and fifty. ");
INSERT INTO engylt_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","And the Levites have not numbered themselves in the midst of the sons of Israel, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","And the sons of Israel do according to all that Jehovah hath commanded Moses; so they have encamped by their standards, and so they have journeyed; each by his families, by the house of his fathers. ");
INSERT INTO engylt_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","And these are births of Aaron and Moses, in the day of Jehovah's speaking with Moses in mount Sinai. ");
INSERT INTO engylt_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","And these are the names of the sons of Aaron: the first-born Nadab, and Abihu, Eleazar, and Ithamar; ");
INSERT INTO engylt_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","these are the names of the sons of Aaron, the anointed priests, whose hand he hath consecrated for acting as priest. ");
INSERT INTO engylt_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","And Nadab dieth — Abihu also — before Jehovah, in their bringing near strange fire before Jehovah, in the wilderness of Sinai, and sons they had not; and Eleazar — Ithamar also — acteth as priest in the presence of Aaron their father. ");
INSERT INTO engylt_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","'Bring near the tribe of Levi, and thou hast caused it to stand before Aaron the priest, and they have served him, ");
INSERT INTO engylt_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","and kept his charge, and the charge of all the company before the tent of meeting, to do the service of the tabernacle; ");
INSERT INTO engylt_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","and they have kept all the vessels of the tent of meeting, and the charge of the sons of Israel, to do the service of the tabernacle; ");
INSERT INTO engylt_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","and thou hast given the Levites to Aaron and to his sons; they are surely given to him out of the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","'And Aaron and his sons thou dost appoint, and they have kept their priesthood, and the stranger who cometh near is put to death.' ");
INSERT INTO engylt_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","'And I, lo, I have taken the Levites from the midst of the sons of Israel instead of every first-born opening a womb among the sons of Israel, and the Levites have been Mine; ");
INSERT INTO engylt_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","for Mine is every first-born, in the day of My smiting every first-born in the land of Egypt I have sanctified to Myself every first-born in Israel, from man unto beast; Mine they are; I am Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","And Jehovah speaketh unto Moses in the wilderness of Sinai, saying, ");
INSERT INTO engylt_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","'Number the sons of Levi by the house of their fathers, by their families; every male from a son of a month and upward thou dost number them.' ");
INSERT INTO engylt_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","And Moses numbereth them according to the command of Jehovah, as he hath been commanded. ");
INSERT INTO engylt_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","And these are sons of Levi by their names: Gershon, and Kohath, and Merari. ");
INSERT INTO engylt_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","And these are the names of the sons of Gershon by their families: Libni and Shimei. ");
INSERT INTO engylt_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","And the sons of Kohath, by their families, are Amram and Izhar, Hebron and Uzziel. ");
INSERT INTO engylt_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","And the sons of Merari by their families are Mahli and Mushi; these are the families of the Levites, by the house of their fathers. ");
INSERT INTO engylt_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Of Gershon is the family of the Libnite, and the family of the Shimite; these are the families of the Gershonite. ");
INSERT INTO engylt_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Their numbered ones, in number, every male from a son of a month and upward, their numbered ones are seven thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The families of the Gershonite, behind the tabernacle, do encamp westward. ");
INSERT INTO engylt_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","And the prince of a father's house for the Gershonite is Eliasaph son of Lael. ");
INSERT INTO engylt_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","And the charge of the sons of Gershon in the tent of meeting is the tabernacle, and the tent, its covering, and the vail at the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","and the hangings of the court, and the vail at the opening of the court, which is by the tabernacle and by the altar round about, and its cords, to all its service. ");
INSERT INTO engylt_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","And of Kohath is the family of the Amramite, and the family of the Izharite, and the family of the Hebronite, and the family of the Uzzielite; these are families of the Kohathite. ");
INSERT INTO engylt_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","In number, all the males, from a son of a month and upward, are eight thousand and six hundred, keeping the charge of the sanctuary. ");
INSERT INTO engylt_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The families of the sons of Kohath encamp by the side of the tabernacle southward. ");
INSERT INTO engylt_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","And the prince of a father's house for the families of the Kohathite is Elizaphan son of Uzziel. ");
INSERT INTO engylt_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","And their charge is the ark, and the table, and the candlestick, and the altars, and the vessels of the sanctuary with which they serve, and the vail, and all its service. ");
INSERT INTO engylt_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","And to the prince of the princes of the Levites, Eleazar son of Aaron the priest, is the oversight of the keepers of the charge of the sanctuary. ");
INSERT INTO engylt_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Of Merari is the family of the Mahlite, and the family of the Mushite; these are the families of Merari. ");
INSERT INTO engylt_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","And their numbered ones, in number, all the males from a son of a month and upward, are six thousand and two hundred. ");
INSERT INTO engylt_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","And the prince of a father's house for the families of Merari is Zuriel son of Abihail; by the side of the tabernacle they encamp northward. ");
INSERT INTO engylt_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","And the oversight — the charge of the sons of Merari — is the boards of the tabernacle, and its bars, and its pillars, and its sockets, and all its vessels, and all its service, ");
INSERT INTO engylt_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","and the pillars of the court round about, and their sockets, and their pins, and their cords. ");
INSERT INTO engylt_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","And those encamping before the tabernacle eastward, before the tent of meeting, at the east, are Moses and Aaron, and his sons, keeping the charge of the sanctuary for the charge of the sons of Israel, and the stranger who cometh near is put to death. ");
INSERT INTO engylt_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","All those numbered of the Levites whom Moses numbered — Aaron also — by the command of Jehovah, by their families, every male from a son of a month and upward, are two and twenty thousand. ");
INSERT INTO engylt_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","And Jehovah saith unto Moses, 'Number every first-born male of the sons of Israel from a son of a month and upward, and take up the number of their names; ");
INSERT INTO engylt_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","and thou hast taken the Levites for Me (I am Jehovah), instead of every first-born among the sons of Israel, and the cattle of the Levites instead of every firstling among the cattle of the sons of Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","And Moses numbereth, as Jehovah hath commanded him, all the first-born among the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","And all the first-born — male — by the number of names, from a son of a month and upward, of their numbered ones, are two and twenty thousand two hundred and seventy and three. ");
INSERT INTO engylt_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","'Take the Levites instead of every first-born among the sons of Israel, and the cattle of the Levites instead of their cattle; and the Levites have been Mine; I am Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","'And from those ransomed of the two hundred and seventy and three (who are more than the Levites) of the first-born of the sons of Israel, ");
INSERT INTO engylt_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","thou hast even taken five shekels a-piece by the poll — by the shekel of the sanctuary thou takest; twenty gerahs the shekel is; ");
INSERT INTO engylt_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","and thou hast given the money to Aaron, and to his sons, whereby those over and above are ransomed.' ");
INSERT INTO engylt_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","And Moses taketh the ransom money from those over and above those ransomed by the Levites; ");
INSERT INTO engylt_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","from the first-born of the sons of Israel he hath taken the money, a thousand and three hundred and sixty and five — by the shekel of the sanctuary; ");
INSERT INTO engylt_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","and Moses giveth the money of those ransomed to Aaron, and to his sons, according to the command of Jehovah, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","'Take up the sum of the sons of Kohath from the midst of the sons of Levi, by their families, by the house of their fathers; ");
INSERT INTO engylt_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","from a son of thirty years and upward, even till a son of fifty years, every one going in to the host, to do work in the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","'This is the service of the sons of Kohath in the tent of meeting, the holy of holies: ");
INSERT INTO engylt_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","that Aaron and his sons have come in, in the journeying of the camp, and have taken down the vail of the hanging, and have covered with it the ark of the testimony; ");
INSERT INTO engylt_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","and have put on it a covering of badger skin, and have spread a garment completely of blue above, and have placed its staves. ");
INSERT INTO engylt_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","'And on the table of the presence they spread a garment of blue, and have put on it the dishes, and the spoons, and the bowls, and the cups of the libation, and the bread of continuity is on it, ");
INSERT INTO engylt_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","and they have spread over them a garment of scarlet, and have covered it with a covering of badger skin, and have placed its staves, ");
INSERT INTO engylt_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","and have taken a garment of blue, and have covered the candlestick of the lamp, and its lights, and its snuffers, and its snuff-dishes, and all its oil vessels wherewith they minister to it; ");
INSERT INTO engylt_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","and they have put it and all its vessels unto a covering of badger skin, and have put it on the bar. ");
INSERT INTO engylt_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","'And on the golden altar they spread a garment of blue, and have covered it with a covering of badger skin, and have placed its staves; ");
INSERT INTO engylt_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","and have taken all the vessels of ministry wherewith they minister in the sanctuary, and have put them unto a garment of blue, and have covered them with a covering of badger skin, and have put them on the bar, ");
INSERT INTO engylt_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","and have removed the ashes of the altar, and have spread over it a garment of purple; ");
INSERT INTO engylt_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","and have put on it all its vessels wherewith they minister about it, the censers, the hooks, and the shovels, and the bowls, all the vessels of the altar, and have spread on it a covering of badger skin, and have placed its staves: ");
INSERT INTO engylt_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","'And Aaron hath finished — his sons also — covering the sanctuary, and all the vessels of the sanctuary, in the journeying of the camp, and afterwards do the sons of Kohath come in to bear it, and they do not come unto the holy thing, that they have died; these things are the burden of the sons of Kohath in the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","'And the oversight of Eleazar, son of Aaron the priest, is the oil of the lamp, and the spice-perfume, and the present of continuity, and the anointing oil, the oversight of all the tabernacle, and of all that is in it, in the sanctuary, and in its vessels.' ");
INSERT INTO engylt_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","And Jehovah speaketh unto Moses and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","'Ye do not cut off the tribe of the families of the Kohathite from the midst of the Levites; ");
INSERT INTO engylt_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","but this do to them, and they have lived, and do not die in their drawing nigh the holy of holies: — Aaron and his sons go in, and have set them, each man to his service, and unto his burden, ");
INSERT INTO engylt_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","and they go not in to see when the holy thing is swallowed, that they have died.' ");
INSERT INTO engylt_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","'Take up the sum of the sons of Gershon also by the house of their fathers, by their families; ");
INSERT INTO engylt_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","from a son of thirty years and upward, till a son of fifty years thou dost number them, every one who is going in to serve the host, to do the service in the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","'This is the service of the families of the Gershonite, to serve — and for burden, ");
INSERT INTO engylt_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","and they have borne the curtains of the tabernacle, and the tent of meeting, its covering, and the covering of the badger skin which is on it above, and the vail at the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","and the hangings of the court, and the vail at the opening of the gate of the court which is by the tabernacle, and by the altar round about, and their cords, and all the vessels of their service, and all that is made for them — and they have served. ");
INSERT INTO engylt_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","'By the command of Aaron and his sons is all the service of the sons of the Gershonite in all their burden, and in all their service; and ye have laid a charge on them concerning the charge of all their burden. ");
INSERT INTO engylt_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the service of the families of the sons of the Gershonite in the tent of meeting; and their charge is under the hand of Ithamar son of Aaron the priest. ");
INSERT INTO engylt_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","'The sons of Merari, by their families, by the house of their fathers, thou dost number them; ");
INSERT INTO engylt_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","from a son of thirty years and upward even unto a son of fifty years thou dost number them, every one who is going in to the host, to do the service of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","'And this is the charge of their burden, of all their service in the tent of meeting; the boards of the tabernacle, and its bars, and its pillars, and its sockets, ");
INSERT INTO engylt_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","and the pillars of the court round about, and their sockets, and their pins, and their cords, of all their vessels, and of all their service; and by name ye do number the vessels of the charge of their burden. ");
INSERT INTO engylt_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","'This is the service of the families of the sons of Merari, for all their service, in the tent of meeting, by the hand of Ithamar son of Aaron the priest.' ");
INSERT INTO engylt_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","And Moses numbereth — Aaron also, and the princes of the company — the sons of the Kohathite, by their families, and by the house of their fathers, ");
INSERT INTO engylt_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","from a son of thirty years and upward even unto a son of fifty years, every one who is going in to the host, for service in the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","and their numbered ones, by their families, are two thousand seven hundred and fifty. ");
INSERT INTO engylt_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","These are those numbered of the families of the Kohathite, every one who is serving in the tent of meeting, whom Moses and Aaron numbered, by the command of Jehovah, by the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","And those numbered of the sons of Gershon, by their families, and by the house of their fathers, ");
INSERT INTO engylt_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","from a son of thirty years and upward even unto a son of fifty years, every one who is going in to the host, for service in the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","even their numbered ones, by their families, by the house of their fathers, are two thousand and six hundred and thirty. ");
INSERT INTO engylt_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","These are those numbered of the families of the sons of Gershon, every one who is serving in the tent of meeting, whom Moses and Aaron numbered by the command of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","And those numbered of the families of the sons of Merari, by their families, by the house of their fathers, ");
INSERT INTO engylt_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","from a son of thirty years and upward even unto a son of fifty years, every one who is going in to the host, for service in the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","even their numbered ones, by their families, are three thousand and two hundred. ");
INSERT INTO engylt_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","These are those numbered of the families of the sons of Merari, whom Moses and Aaron numbered, by the command of Jehovah, by the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","All those numbered, whom Moses numbered — Aaron also, and the princes of Israel — of the Levites, by their families, and by the house of their fathers, ");
INSERT INTO engylt_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","from a son of thirty years and upward even unto a son of fifty years, every one who is going in to do the work of the service, even the service of burden in the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","even their numbered ones are eight thousand and five hundred and eighty; ");
INSERT INTO engylt_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","by the command of Jehovah hath one numbered them, by the hand of Moses, each man by his service, and by his burden, with his numbered ones, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","'Command the sons of Israel, and they send out of the camp every leper, and every one with an issue, and every one defiled by a body; ");
INSERT INTO engylt_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","from male unto female ye do send out; unto the outside of the camp ye do send them; and they defile not their camps in the midst of which I do tabernacle.' ");
INSERT INTO engylt_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","And the sons of Israel do so, and they send them out unto the outside of the camp; as Jehovah hath spoken unto Moses so have the sons of Israel done. ");
INSERT INTO engylt_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","'Speak unto the sons of Israel, Man or woman, when they do any of the sins of man, by committing a trespass against Jehovah, and that person is guilty, ");
INSERT INTO engylt_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","and they have confessed their sin which they have done, then he hath restored his guilt in its principal, and its fifth is adding to it, and hath given it to him in reference to whom he hath been guilty. ");
INSERT INTO engylt_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","'And if the man have no redeemer to restore the guilt to, the guilt which is restored is Jehovah's, the priest's, apart from the ram of the atonements, whereby he maketh atonement for him. ");
INSERT INTO engylt_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","'And every heave-offering of all the holy things of the sons of Israel, which they bring near to the priest, becometh his; ");
INSERT INTO engylt_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","and any man's hallowed things become his; that which any man giveth to the priest becometh his.' ");
INSERT INTO engylt_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","'Speak unto the sons of Israel, and thou hast said unto them, When any man's wife turneth aside, and hath committed against him a trespass, ");
INSERT INTO engylt_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","and a man hath lain with her with the seed of copulation, and it hath been hid from the eyes of her husband, and concealed, and she hath been defiled, and there is no witness against her, and she hath not been caught, ");
INSERT INTO engylt_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","and a spirit of jealousy hath passed over him, and he hath been jealous of his wife, and she hath been defiled; — or, a spirit of jealousy hath passed over him, and he hath been jealous of his wife, and she hath not been defiled — ");
INSERT INTO engylt_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","'Then hath the man brought in his wife unto the priest, and he hath brought in her offering for her, a tenth of the ephah of barley meal, he doth not pour on it oil, nor doth he put on it frankincense, for it is a present of jealousy, a present of memorial, causing remembrance of iniquity. ");
INSERT INTO engylt_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","'And the priest hath brought her near, and hath caused her to stand before Jehovah, ");
INSERT INTO engylt_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","and the priest hath taken holy water in an earthen vessel, and of the dust which is on the floor of the tabernacle doth the priest take, and hath put it into the water, ");
INSERT INTO engylt_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","and the priest hath caused the woman to stand before Jehovah, and hath uncovered the woman's head, and hath given into her hands the present of the memorial, it is a present of jealousy, and in the hand of the priest are the bitter waters which cause the curse. ");
INSERT INTO engylt_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","'And the priest hath caused her to swear, and hath said unto the woman, If no man hath lain with thee, and if thou hast not turned aside to uncleanness under thy husband, be free from these bitter waters which cause the curse; ");
INSERT INTO engylt_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","and thou, if thou hast turned aside under thy husband, and if thou hast been defiled, and any man doth give his copulation to thee besides thy husband — ");
INSERT INTO engylt_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(then the priest hath caused the woman to swear with an oath of execration, and the priest hath said to the woman) — Jehovah doth give thee for an execration, and for a curse, in the midst of thy people, in Jehovah's giving thy thigh to fall, and thy belly to swell, ");
INSERT INTO engylt_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","and these waters which cause the curse have gone into thy bowels, to cause the belly to swell, and the thigh to fall; and the woman hath said, Amen, Amen. ");
INSERT INTO engylt_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","'And the priest hath written these execrations in a book, and hath blotted them out with the bitter waters, ");
INSERT INTO engylt_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","and hath caused the woman to drink the bitter waters which cause the curse, and the waters which cause the curse have entered into her for bitter things. ");
INSERT INTO engylt_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","'And the priest hath taken out of the hand of the woman the present of jealousy, and hath waved the present before Jehovah, and hath brought it near unto the altar; ");
INSERT INTO engylt_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","and the priest hath taken a handful of the present, its memorial, and hath made perfume on the altar, and afterwards doth cause the woman to drink the water: ");
INSERT INTO engylt_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","yea, he hath caused her to drink the water, and it hath come to pass, if she hath been defiled, and doth commit a trespass against her husband, that the waters which cause the curse have gone into her for bitter things, and her belly hath swelled, and her thigh hath fallen, and the woman hath become an execration in the midst of her people. ");
INSERT INTO engylt_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","'And if the woman hath not been defiled, and is clean, then she hath been acquitted, and hath been sown with seed. ");
INSERT INTO engylt_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","'This is the law of jealousies, when a wife turneth aside under her husband, and hath been defiled, ");
INSERT INTO engylt_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when a spirit of jealousy passeth over a man, and he hath been jealous of his wife, then he hath caused the woman to stand before Jehovah, and the priest hath done to her all this law, ");
INSERT INTO engylt_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","and the man hath been acquitted from iniquity, and that woman doth bear her iniquity.' ");
INSERT INTO engylt_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","'Speak unto the sons of Israel, and thou hast said unto them, When a man or woman doeth singularly, by vowing a vow of a Nazarite, to be separate to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","from wine and strong drink he doth keep separate; vinegar of wine, and vinegar of strong drink he doth not drink, and any juice of grapes he doth not drink, and grapes moist or dry he doth not eat; ");
INSERT INTO engylt_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","all days of his separation, of anything which is made of the wine-vine, from kernels even unto husk, he doth not eat. ");
INSERT INTO engylt_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","'All days of the vow of his separation a razor doth not pass over his head; till the fulness of the days which he doth separate to Jehovah he is holy; grown up hath the upper part of the hair of his head. ");
INSERT INTO engylt_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","'All days of his keeping separate to Jehovah, near a dead person he doth not go; ");
INSERT INTO engylt_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","for his father, or for his mother, for his brother, or for his sister — he is not unclean for them at their death, for the separation of his God is on his head; ");
INSERT INTO engylt_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","all days of his separation he is holy to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","'And when the dead dieth beside him in an instant, suddenly, and he hath defiled the head of his separation, then he hath shaved his head in the day of his cleansing; on the seventh day he doth shave it, ");
INSERT INTO engylt_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","and on the eighth day he bringeth in two turtle-doves or two young pigeons unto the priest, unto the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","and the priest hath prepared one for a sin-offering, and one for a burnt-offering, and hath made atonement for him, because of that which he hath sinned by the body, and he hath hallowed his head on that day; ");
INSERT INTO engylt_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","and he hath separated to Jehovah the days of his separation, and he hath brought in a lamb, a son of a year, for a guilt-offering, and the former days are fallen, for his separation hath been defiled. ");
INSERT INTO engylt_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","'And this is the law of the Nazarite; in the day of the fulness of the days of his separation doth one bring him in unto the opening of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","and he hath brought near his offering to Jehovah, one he-lamb, a son of a year, a perfect one, for a burnt-offering, and one she-lamb, a daughter of a year, a perfect one, for a sin-offering, and one ram, a perfect one, for peace-offerings, ");
INSERT INTO engylt_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","and a basket of unleavened things of flour, cakes mixed with oil, and thin cakes of unleavened things anointed with oil, and their present, and their libations. ");
INSERT INTO engylt_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","'And the priest hath brought them near before Jehovah, and hath made his sin-offering and his burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","and the ram he maketh a sacrifice of peace-offerings to Jehovah, besides the basket of unleavened things; and the priest hath made its present and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","'And the Nazarite hath shaved (at the opening of the tent of meeting) the head of his separation, and hath taken the hair of the head of his separation, and hath put it on the fire which is under the sacrifice of the peace-offerings. ");
INSERT INTO engylt_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","'And the priest hath taken the boiled shoulder from the ram, and one unleavened cake out of the basket, and one thin unleavened cake, and hath put on the palms of the Nazarite after his shaving his separation; ");
INSERT INTO engylt_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","and the priest hath waved them, a wave-offering before Jehovah; it is holy to the priest, besides the breast of the wave-offering, and besides the leg of the heave-offering; and afterwards doth the Nazarite drink wine. ");
INSERT INTO engylt_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","'This is the law of the Nazarite, who voweth his offering to Jehovah for his separation, apart from that which his hand attaineth; according to his vow which he voweth so he doth by the law of his separation.' ");
INSERT INTO engylt_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","'Speak unto Aaron, and unto his sons, saying, Thus ye do bless the sons of Israel, saying to them, ");
INSERT INTO engylt_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","'Jehovah bless thee and keep thee; ");
INSERT INTO engylt_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","'Jehovah cause His face to shine upon thee, and favour thee; ");
INSERT INTO engylt_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","'Jehovah lift up His countenance upon thee, and appoint for thee — peace. ");
INSERT INTO engylt_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","'And they have put My name upon the sons of Israel, and I — I do bless them.' ");
INSERT INTO engylt_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","And it cometh to pass on the day of Moses' finishing setting up the tabernacle, that he anointeth it, and sanctifieth it, and all its vessels, and the altar, and all its vessels, and he anointeth them, and sanctifieth them, ");
INSERT INTO engylt_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","and the princes of Israel (heads of the house of their fathers, they are princes of the tribes, they who are standing over those numbered) bring near, ");
INSERT INTO engylt_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","yea, they bring their offering before Jehovah, six waggons covered, and twelve oxen — a waggon for two of the princes, and an ox for one — and they bring them near before the tabernacle. ");
INSERT INTO engylt_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","'Receive from them, and they have been to do the service of the tent of meeting, and thou hast given them unto the Levites, each according to his service.' ");
INSERT INTO engylt_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","And Moses taketh the waggons and the oxen, and giveth them unto the Levites. ");
INSERT INTO engylt_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","The two of the waggons and the four of the oxen he hath given to the sons of Gershon, according to their service, ");
INSERT INTO engylt_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","and the four of the waggons and the eight of the oxen he hath given to the sons of Merari, according to their service, by the hand of Ithamar son of Aaron the priest; ");
INSERT INTO engylt_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","and to the sons of Kohath he hath not given, for the service of the sanctuary is on them: on the shoulder they bear. ");
INSERT INTO engylt_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","And the princes bring near the dedication of the altar in the day of its being anointed; yea, the princes bring near their offering before the altar. ");
INSERT INTO engylt_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","And Jehovah saith unto Moses, 'One prince a day — one prince a day — do they bring near their offering for the dedication of the altar.' ");
INSERT INTO engylt_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","And he who is bringing near on the first day his offering is Nahshon son of Amminadab, of the tribe of Judah. ");
INSERT INTO engylt_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","And his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary; both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Nahshon son of Amminadab. ");
INSERT INTO engylt_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day hath Nethaneel son of Zuar, prince of Issachar, brought near. ");
INSERT INTO engylt_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He hath brought near his offering, one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Nethaneel son of Zuar. ");
INSERT INTO engylt_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day, the prince of the sons of Zebulun, Eliab son of Helon; — ");
INSERT INTO engylt_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Eliab son of Helon. ");
INSERT INTO engylt_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day, Elizur, son of Shedeur, prince of the sons of Reuben; — ");
INSERT INTO engylt_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Elizur son of Shedeur. ");
INSERT INTO engylt_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day, the prince of the sons of Simeon, Shelumiel son of Zurishaddai; — ");
INSERT INTO engylt_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Shelumiel son of Zurishaddai. ");
INSERT INTO engylt_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day, the prince of the sons of Gad, Eliasaph son of Deuel; — ");
INSERT INTO engylt_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Eliasaph son of Deuel. ");
INSERT INTO engylt_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day, the prince of the sons of Ephraim, Elishama son of Ammihud; — ");
INSERT INTO engylt_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Elishama son of Ammihud. ");
INSERT INTO engylt_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day, the prince of the sons of Manasseh, Gamaliel son of Pedahzur; — ");
INSERT INTO engylt_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Gamaliel son of Pedahzur. ");
INSERT INTO engylt_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day, the prince of the sons of Benjamin, Abidan son of Gideoni; — ");
INSERT INTO engylt_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","one kid of the goats for a sin-offering: ");
INSERT INTO engylt_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Abidan son of Gideoni. ");
INSERT INTO engylt_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day, the prince of the sons of Dan, Ahiezer son of Ammishaddai; — ");
INSERT INTO engylt_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Ahiezer son of Ammishaddai. ");
INSERT INTO engylt_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day, the prince of the sons of Asher, Pagiel son of Ocran; — ");
INSERT INTO engylt_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Pagiel son of Ocran. ");
INSERT INTO engylt_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day, the prince of the sons of Naphtali, Ahira son of Enan; — ");
INSERT INTO engylt_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","his offering is one silver dish, its weight a hundred and thirty shekels; one silver bowl of seventy shekels, by the shekel of the sanctuary, both of them full of flour mixed with oil, for a present; ");
INSERT INTO engylt_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","one golden spoon of ten shekels, full of perfume; ");
INSERT INTO engylt_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","one bullock, a son of the herd, one ram, one lamb, a son of a year, for a burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","one kid of the goats for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","and for a sacrifice of the peace-offerings two oxen, five rams, five he-goats, five lambs, sons of a year; this is the offering of Ahira son of Enan. ");
INSERT INTO engylt_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","This is the dedication of the altar, in the day of its being anointed, by the princes of Israel: twelve silver dishes, twelve silver bowls, twelve golden spoons; ");
INSERT INTO engylt_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","a hundred and thirty shekels each silver dish, and each bowl seventy; all the silver of the vessels is two thousand and four hundred shekels, by the shekel of the sanctuary. ");
INSERT INTO engylt_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Golden spoons are twelve, full of perfume; ten shekels each spoon, by the shekel of the sanctuary; all the gold of the spoons is a hundred and twenty shekels; ");
INSERT INTO engylt_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","all the oxen for burnt-offering are twelve bullocks, rams twelve, lambs, sons of a year twelve, and their present; and kids of the goats twelve, for sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","and all the oxen for the sacrifice of the peace-offerings are twenty and four bullocks, rams sixty, he-goats sixty, lambs, sons of a year, sixty; this is the dedication of the altar, in the day of its being anointed. ");
INSERT INTO engylt_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","And in the going in of Moses unto the tent of meeting to speak with Him — he doth even hear the voice speaking unto him from off the mercy-seat which is upon the ark of the testimony, from between the two cherubs; and He speaketh unto him. ");
INSERT INTO engylt_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","'Speak unto Aaron, and thou hast said unto him, In thy causing the lights to go up, over-against the face of the candlestick do the seven lights give light.' ");
INSERT INTO engylt_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","And Aaron doth so; over-against the face of the candlestick he hath caused its lights to go up, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","And this is the work of the candlestick: beaten work of gold; unto its thigh, unto its flower it is beaten work; as the appearance which Jehovah shewed Moses, so he hath made the candlestick. ");
INSERT INTO engylt_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","'Take the Levites from the midst of the sons of Israel, and thou hast cleansed them. ");
INSERT INTO engylt_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","'And thus thou dost to them to cleanse them: sprinkle upon them waters of atonement, and they have caused a razor to pass over all their flesh, and have washed their garments, and cleansed themselves, ");
INSERT INTO engylt_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","and have taken a bullock, a son of the herd, and its present, flour mixed with oil, — and a second bullock a son of the herd thou dost take for a sin-offering, ");
INSERT INTO engylt_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","and thou hast brought near the Levites before the tent of meeting, and thou hast assembled the whole company of the sons of Israel, ");
INSERT INTO engylt_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","and thou hast brought near the Levites before Jehovah, and the sons of Israel have laid their hands on the Levites, ");
INSERT INTO engylt_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","and Aaron hath waved the Levites — a wave-offering before Jehovah, from the sons of Israel, and they have been — for doing the service of Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","'And the Levites lay their hands on the head of the bullocks, and make thou the one a sin-offering, and the one a burnt-offering to Jehovah, to atone for the Levites, ");
INSERT INTO engylt_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","and thou hast caused the Levites to stand before Aaron, and before his sons, and hast waved them — a wave-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","and thou hast separated the Levites from the midst of the sons of Israel, and the Levites have become Mine; ");
INSERT INTO engylt_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","and afterwards do the Levites come in to serve the tent of meeting, and thou hast cleansed them, and hast waved them — a wave-offering. ");
INSERT INTO engylt_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","'For they are certainly given to Me out of the midst of the sons of Israel, instead of him who openeth any womb — the first-born of all — from the sons of Israel I have taken them to Myself; ");
INSERT INTO engylt_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","for Mine is every first-born among the sons of Israel, among man and among beast; in the day of my smiting every first-born in the land of Egypt I sanctified them for Myself; ");
INSERT INTO engylt_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","and I take the Levites instead of every first-born among the sons of Israel: ");
INSERT INTO engylt_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","'And I give the Levites gifts to Aaron and to his sons, from the midst of the sons of Israel, to do the service of the sons of Israel in the tent of meeting, and to make atonement for the sons of Israel, and there is no plague among the sons of Israel in the sons of Israel's drawing nigh unto the sanctuary.' ");
INSERT INTO engylt_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","And Moses doth — Aaron also, and all the company of the sons of Israel — to the Levites according to all that Jehovah hath commanded Moses concerning the Levites; so have the sons of Israel done to them. ");
INSERT INTO engylt_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","And the Levites cleanse themselves, and wash their garments, and Aaron waveth them a wave-offering before Jehovah, and Aaron maketh atonement for them to cleanse them, ");
INSERT INTO engylt_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","and afterwards have the Levites gone in to do their service in the tent of meeting, before Aaron and before his sons; as Jehovah hath commanded Moses concerning the Levites, so they have done to them. ");
INSERT INTO engylt_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","'This is that which is the Levites': from a son of five and twenty years and upward he doth go in to serve the host in the service of the tent of meeting, ");
INSERT INTO engylt_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","and from a son of fifty years he doth return from the host of the service, and doth not serve any more, ");
INSERT INTO engylt_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","and he hath ministered with his brethren in the tent of meeting, to keep the charge, and doth not do service; thus thou dost to the Levites concerning their charge.' ");
INSERT INTO engylt_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","And Jehovah speaketh unto Moses, in the wilderness of Sinai, in the second year of their going out of the land of Egypt, in the first month, saying, ");
INSERT INTO engylt_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","'Also, the sons of Israel prepare the passover in its appointed season; ");
INSERT INTO engylt_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","in the fourteenth day of this month between the evenings ye prepare it in its appointed season; according to all its statutes, and according to all its ordinances ye prepare it.' ");
INSERT INTO engylt_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","And Moses speaketh unto the sons of Israel to prepare the passover, ");
INSERT INTO engylt_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","and they prepare the passover in the first month, on the fourteenth day of the month, between the evenings, in the wilderness of Sinai; according to all that Jehovah hath commanded Moses, so have the sons of Israel done. ");
INSERT INTO engylt_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","And there are men who have been defiled by the body of a man, and they have not been able to prepare the passover on that day, and they come near before Moses, and before Aaron, on that day, ");
INSERT INTO engylt_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","and those men say unto him, 'We are defiled by the body of a man; why are we withheld so as not to bring near the offering of Jehovah in its appointed season, in the midst of the sons of Israel?' ");
INSERT INTO engylt_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","And Moses saith unto them, 'Stand ye, and I hear what Jehovah hath commanded concerning you.' ");
INSERT INTO engylt_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","'Speak unto the sons of Israel, saying, Though any man is unclean by a body or in a distant journey (of you or of your generations), yet he hath prepared a passover to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","in the second month, on the fourteenth day, between the evenings they prepare it; with unleavened and bitter things they eat it; ");
INSERT INTO engylt_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","they do not leave of till morning; and a bone they do not break in it: according to all the statute of the passover they prepare it. ");
INSERT INTO engylt_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","'And the man who is clean, and hath not been on a journey, and hath ceased to prepare the passover, even that person hath been cut off from his people; because the offering of Jehovah he hath not brought near, in its appointed season, that man doth bear his sin. ");
INSERT INTO engylt_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","'And when a sojourner sojourneth with you, then he hath prepared a passover to Jehovah, according to the statute of the passover, and according to its ordinance, so he doth; one statute is to you, even to a sojourner, and to a native of the land.' ");
INSERT INTO engylt_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","And in the day of the raising up of the tabernacle hath the cloud covered the tabernacle, even the tent of the testimony; and in the evening there is on the tabernacle as an appearance of fire till morning; ");
INSERT INTO engylt_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","so it is continually; the cloud covereth it, also the appearance of fire by night. ");
INSERT INTO engylt_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","And according to the going up of the cloud from off the tent and afterwards do the sons of Israel journey; and in the place where the cloud doth tabernacle, there do the sons of Israel encamp; ");
INSERT INTO engylt_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","by the command of Jehovah the sons of Israel journey, and by the command of Jehovah they encamp; all the days that the cloud doth tabernacle over the tabernacle they encamp. ");
INSERT INTO engylt_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","And in the cloud prolonging itself over the tabernacle many days, then have the sons of Israel kept the charge of Jehovah, and journey not, ");
INSERT INTO engylt_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","and so when the cloud is a number of days over the tabernacle; by the command of Jehovah they encamp, and by the command of Jehovah they journey. ");
INSERT INTO engylt_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","And so when the cloud is from evening till morning, when the cloud hath gone up in the morning, then they have journeyed; whether by day or by night, when the cloud hath gone up, then they have journeyed. ");
INSERT INTO engylt_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Whether two days, or a month, or days, in the cloud prolonging itself over the tabernacle, to tabernacle over it, the sons of Israel encamp, and journey not; and in its being lifted up they journey; ");
INSERT INTO engylt_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","by the command of Jehovah they encamp, and by the command of Jehovah they journey; the charge of Jehovah they have kept, by the command of Jehovah in the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","'Make to thee two trumpets of silver; beaten work thou dost make them, and they have been to thee for the convocation of the company, and for the journeying of the camps; ");
INSERT INTO engylt_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","and they have blown with them, and all the company have met together unto thee, unto the opening of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","And if with one they blow, then have the princes, heads of the thousands of Israel, met together unto thee; ");
INSERT INTO engylt_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","'And ye have blown — a shout, and the camps which are encamping eastward have journeyed. ");
INSERT INTO engylt_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","'And ye have blown — a second shout, and the camps which are encamping southward have journeyed; a shout they blow for their journeys. ");
INSERT INTO engylt_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","'And in the assembling of the assembly ye blow, and do not shout; ");
INSERT INTO engylt_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","and sons of Aaron, the priests, blow with the trumpets; and they have been to you for a statute age-during to your generations. ");
INSERT INTO engylt_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","'And when ye go into battle in your land against the adversary who is distressing you, then ye have shouted with the trumpets, and ye have been remembered before Jehovah your God, and ye have been saved from your enemies. ");
INSERT INTO engylt_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","'And in the day of your gladness, and in your appointed seasons, and in the beginnings of your months, ye have blown also with the trumpets over your burnt-offerings, and over the sacrifices of your peace-offerings, and they have been to you for a memorial before your God; I, Jehovah, am your God.' ");
INSERT INTO engylt_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","And it cometh to pass — in the second year, in the second month, in the twentieth of the month — the cloud hath gone up from off the tabernacle of the testimony, ");
INSERT INTO engylt_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","and the sons of Israel journey in their journeyings from the wilderness of Sinai, and the cloud doth tabernacle in the wilderness of Paran; ");
INSERT INTO engylt_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","and they journey at first, by the command of Jehovah, in the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","And the standard of the camp of the sons of Judah journeyeth in the first place, by their hosts, and over its host is Nahshon son of Amminadab. ");
INSERT INTO engylt_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","And over the host of the tribe of the sons of Issachar is Nathaneel son of Zuar. ");
INSERT INTO engylt_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","And over the host of the tribe of the sons of Zebulun is Eliab son of Helon; ");
INSERT INTO engylt_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","And the tabernacle hath been taken down, and the sons of Gershon and the sons of Merari have journeyed, bearing the tabernacle. ");
INSERT INTO engylt_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","And the standard of the camp of Reuben hath journeyed, by their hosts, and over its host is Elizur son of Shedeur. ");
INSERT INTO engylt_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","And over the host of the tribe of the sons of Simeon is Shelumiel son of Zurishaddai. ");
INSERT INTO engylt_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","And over the host of the tribe of the sons of Gad is Eliasaph son of Deuel; ");
INSERT INTO engylt_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","And the Kohathites have journeyed, bearing the tabernacle, and the others have raised up the tabernacle until their coming in. ");
INSERT INTO engylt_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","And the standard of the camp of the sons of Ephraim hath journeyed, by their hosts, and over its host is Elishama son of Ammihud. ");
INSERT INTO engylt_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","And over the host of the tribe of the sons of Manasseh is Gamalial son of Pedahzur. ");
INSERT INTO engylt_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","And over the host of the tribe of the sons of Benjamin is Abidan son of Gideoni. ");
INSERT INTO engylt_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","And the standard of the camp of the sons of Dan hath journeyed (rearward to all the camps), by their hosts, and over its host is Ahiezer son of Ammishaddai. ");
INSERT INTO engylt_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","And over the host of the tribe of the sons of Asher is Pagiel son of Ocran. ");
INSERT INTO engylt_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","And over the host of the tribe of the sons of Naphtali is Ahira son of Enan. ");
INSERT INTO engylt_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","These are journeyings of the sons of Israel by their hosts — and they journey. ");
INSERT INTO engylt_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","And Moses saith to Hobab son of Raguel the Midianite, father-in-law of Moses, 'We are journeying unto the place of which Jehovah hath said, I give it to you; go with us, and we have done good to thee; for Jehovah hath spoken good concerning Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","And he saith unto him, 'I do not go; but unto my land and unto my kindred do I go.' ");
INSERT INTO engylt_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","And he saith, 'I pray thee, forsake us not, because thou hast known our encamping in the wilderness, and thou hast been to us for eyes; ");
INSERT INTO engylt_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","and it hath come to pass when thou goest with us, yea, it hath come to pass — that good which Jehovah doth kindly with us — it we have done kindly to thee.' ");
INSERT INTO engylt_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","And they journey from the mount of Jehovah a journey of three days; and the ark of the covenant of Jehovah is journeying before them the journey of three days, to spy out for them a resting-place; ");
INSERT INTO engylt_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","and the cloud of Jehovah is on them by day, in their journeying from the camp. ");
INSERT INTO engylt_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","And it cometh to pass in the journeying of the ark, that Moses saith, 'Rise, O Jehovah, and Thine enemies are scattered, and those hating Thee flee from Thy presence.' ");
INSERT INTO engylt_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And in its resting he saith, 'Return, O Jehovah, to the myriads, the thousands of Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","And the people is evil, as those sighing habitually in the ears of Jehovah, and Jehovah heareth, and His anger burneth, and the fire of Jehovah burneth among them, and consumeth in the extremity of the camp. ");
INSERT INTO engylt_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","And the people cry unto Moses, and Moses prayeth unto Jehovah, and the fire is quenched; ");
INSERT INTO engylt_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","and he calleth the name of that place Taberah, for the fire of Jehovah hath 'burned' among them. ");
INSERT INTO engylt_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","And the rabble who are in its midst have lusted greatly, and the sons of Israel also turn back and weep, and say, 'Who doth give us flesh? ");
INSERT INTO engylt_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We have remembered the fish which we do eat in Egypt for nought, the cucumbers, and the melons, and the leeks, and the onions, and the garlick; ");
INSERT INTO engylt_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","and now our soul is dry, there is not anything, save the manna, before our eyes.' ");
INSERT INTO engylt_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","And the manna is as coriander seed, and its aspect as the aspect of bdolach; ");
INSERT INTO engylt_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","the people have turned aside and gathered it, and ground it with millstones, or beat it in a mortar, and boiled it in a pan, and made it cakes, and its taste hath been as the taste of the moisture of oil. ");
INSERT INTO engylt_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","And in the descending of the dew on the camp by night, the manna descendeth upon it. ");
INSERT INTO engylt_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","And Moses heareth the people weeping by its families, each at the opening of his tent, and the anger of Jehovah burneth exceedingly, and in the eyes of Moses it is evil. ");
INSERT INTO engylt_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","And Moses saith unto Jehovah, 'Why hast Thou done evil to Thy servant? and why have I not found grace in Thine eyes — to put the burden of all this people upon me? ");
INSERT INTO engylt_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","I — have I conceived all this people? I — have I begotten it, that Thou sayest unto me, Carry it in thy bosom as the nursing father beareth the suckling, unto the ground which Thou hast sworn to its fathers? ");
INSERT INTO engylt_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Whence have I flesh to give to all this people? for they weep unto me, saying, Give to us flesh, and we eat. ");
INSERT INTO engylt_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I am not able — I alone — to bear all this people, for it is too heavy for me; ");
INSERT INTO engylt_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","and if thus Thou art doing to me — slay me, I pray Thee; slay, if I have found grace in thine eyes, and let me not look on mine affliction.' ");
INSERT INTO engylt_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","And Jehovah saith unto Moses, 'Gather to Me seventy men of the elders of Israel, whom thou hast known that they are elders of the people, and its authorities; and thou hast taken them unto the tent of meeting, and they have stationed themselves there with thee, ");
INSERT INTO engylt_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","and I have come down and spoken with thee there, and have kept back of the Spirit which is upon thee, and have put on them, and they have borne with thee some of the burden of the people, and thou dost not bear it thyself alone. ");
INSERT INTO engylt_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","'And unto the people thou dost say, Sanctify yourselves for to-morrow, and ye have eaten flesh (for ye have wept in the ears of Jehovah, saying, Who doth give us flesh? for we had good in Egypt) — and Jehovah hath given to you flesh, and ye have eaten. ");
INSERT INTO engylt_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ye do not eat one day, nor two days, nor five days, nor ten days, nor twenty days; — ");
INSERT INTO engylt_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","unto a month of days, till that it come out from your nostrils, and it hath become to you an abomination; because that ye have loathed Jehovah, who is in your midst, and weep before Him, saying, Why is this? — we have come out of Egypt!' ");
INSERT INTO engylt_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","And Moses saith, 'Six hundred thousand footmen are the people in whose midst I am; and Thou, Thou hast said, Flesh I give to them, and they have eaten, a month of days! ");
INSERT INTO engylt_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Is flock and herd slaughtered for them, that one hath found for them? — are all the fishes of the sea gathered for them — that one hath found for them?' ");
INSERT INTO engylt_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","And Jehovah saith unto Moses, 'Is the hand of Jehovah become short? now thou dost see whether My word meeteth thee or not.' ");
INSERT INTO engylt_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","And Moses goeth out, and speaketh unto the people the words of Jehovah, and gathereth seventy men of the elders of the people, and causeth them to stand round about the tent, ");
INSERT INTO engylt_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","and Jehovah cometh down in the cloud, and speaketh unto him, and keepeth back of the Spirit which is on him, and putteth on the seventy men of the elders; and it cometh to pass at the resting of the Spirit on them, that they prophesy, and do not cease. ");
INSERT INTO engylt_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","And two of the men are left in the camp, the name of the one is Eldad, and the name of the second Medad, and the spirit resteth upon them, (and they are among those written, and have not gone out to the tent), and they prophesy in the camp; ");
INSERT INTO engylt_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","and the young man runneth, and declareth to Moses, and saith, 'Eldad and Medad are prophesying in the camp.' ");
INSERT INTO engylt_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","And Joshua son of Nun, minister of Moses, one of his young men, answereth and saith, 'My lord Moses, restrain them.' ");
INSERT INTO engylt_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","And Moses saith to him, 'Art thou zealous for me? O that all Jehovah's people were prophets! that Jehovah would put His Spirit upon them!' ");
INSERT INTO engylt_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","And Moses is gathered unto the camp, he and the elders of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","And a spirit hath journeyed from Jehovah, and cutteth off quails from the sea, and leaveth by the camp, as a day's journey here, and as a day's journey there, round about the camp, and about two cubits, on the face of the land. ");
INSERT INTO engylt_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","And the people rise all that day, and all the night, and all the day after, and gather the quails — he who hath least hath gathered ten homers — and they spread them out for themselves round about the camp. ");
INSERT INTO engylt_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","The flesh is yet between their teeth — it is not yet cut off — and the anger of Jehovah hath burned among the people, and Jehovah smiteth among the people — a very great smiting; ");
INSERT INTO engylt_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","and one calleth the name of that place Kibroth-Hattaavah, for there they have buried the people who lust. ");
INSERT INTO engylt_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From Kibroth-Hattaavah have the people journeyed to Hazeroth, and they are in Hazeroth. ");
INSERT INTO engylt_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","And Miriam speaketh — Aaron also — against Moses concerning the circumstance of the Cushite woman whom he had taken: for a Cushite woman he had taken; ");
INSERT INTO engylt_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","and they say, 'Only by Moses hath Jehovah spoken? also by us hath he not spoken?' and Jehovah heareth. ");
INSERT INTO engylt_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","And the man Moses is very humble, more than any of the men who are on the face of the ground. ");
INSERT INTO engylt_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","And Jehovah saith suddenly unto Moses, and unto Aaron, and unto Miriam, 'Come out ye three unto the tent of meeting;' and they three come out. ");
INSERT INTO engylt_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","And Jehovah cometh down in the pillar of the cloud, and standeth at the opening of the tent, and calleth Aaron and Miriam, and they come out both of them. ");
INSERT INTO engylt_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","And He saith, 'Hear, I pray you, My words: If your prophet is of Jehovah — in an appearance unto him I make Myself known; in a dream I speak with him; ");
INSERT INTO engylt_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","not so My servant Moses; in all My house he is stedfast; ");
INSERT INTO engylt_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","mouth unto mouth I speak with him, and by an appearance, and not in riddles; and the form of Jehovah he beholdeth attentively; and wherefore have ye not been afraid to speak against My servant — against Moses?' ");
INSERT INTO engylt_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","And the anger of Jehovah burneth against them, and He goeth on, ");
INSERT INTO engylt_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","and the cloud hath turned aside from off the tent, and lo, Miriam is leprous as snow; and Aaron turneth unto Miriam, and lo, leprous! ");
INSERT INTO engylt_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","And Aaron saith unto Moses, 'O, my lord, I pray thee, lay not upon us sin in which we have been foolish, and in which we have sinned; ");
INSERT INTO engylt_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","let her not, I pray thee, be as one dead, when in his coming out from the womb of his mother — the half of his flesh is consumed.' ");
INSERT INTO engylt_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","And Moses crieth unto Jehovah, saying, 'O God, I pray Thee, give, I pray Thee, healing to her.' ");
INSERT INTO engylt_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","And Jehovah saith unto Moses, 'And her father had but spat in her face — is she not ashamed seven days? she is shut out seven days at the outside of the camp, and afterwards she is gathered.' ");
INSERT INTO engylt_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","And Miriam is shut out at the outside of the camp seven days, and the people hath not journeyed till Miriam is gathered; ");
INSERT INTO engylt_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","and afterwards have the people journeyed from Hazeroth, and they encamp in the wilderness of Paran. ");
INSERT INTO engylt_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","'Send for thee men, and they spy the land of Canaan, which I am giving to the sons of Israel; one man, one man for the tribe of his fathers ye do send, every one a prince among them.' ");
INSERT INTO engylt_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","And Moses sendeth them from the wilderness of Paran by the command of Jehovah; all of them are men, heads of the sons of Israel they are, ");
INSERT INTO engylt_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","and these their names: For the tribe of Reuben, Shammua son of Zaccur. ");
INSERT INTO engylt_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","For the tribe of Simeon, Shaphat son of Hori. ");
INSERT INTO engylt_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","For the tribe of Judah, Caleb son of Jephunneh. ");
INSERT INTO engylt_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","For the tribe of Issachar, Igal son of Joseph. ");
INSERT INTO engylt_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","For the tribe of Ephraim, Oshea, son of Nun. ");
INSERT INTO engylt_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","For the tribe of Benjamin, Palti son of Raphu. ");
INSERT INTO engylt_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","For the tribe of Zebulun, Gaddiel son of Sodi. ");
INSERT INTO engylt_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","For the tribe of Joseph, (for the tribe of Manasseh,) Gaddi son of Susi. ");
INSERT INTO engylt_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","For the tribe of Dan, Ammiel son of Gemalli. ");
INSERT INTO engylt_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","For the tribe of Asher, Sethur son of Michael. ");
INSERT INTO engylt_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","For the tribe of Naphtali, Nahbi son of Vopshi. ");
INSERT INTO engylt_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","For the tribe of Gad, Geuel son of Machi. ");
INSERT INTO engylt_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the names of the men whom Moses hath sent to spy the land; and Moses calleth Hoshea son of Nun, Jehoshua. ");
INSERT INTO engylt_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","And Moses sendeth them to spy the land of Canaan, and saith unto them, 'Go ye up this way into the south, and ye have gone up the mountain, ");
INSERT INTO engylt_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","and have seen the land what it is, and the people which is dwelling on it, whether it is strong or feeble; whether it is few or many; ");
INSERT INTO engylt_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","and what the land is in which it is dwelling, whether it is good or bad; and what are the cities in which it is dwelling, whether in camps or in fortresses; ");
INSERT INTO engylt_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","And what the land is, whether it is fat or lean; whether there is wood in it or not; and ye have strengthened yourselves, and have taken of the fruit of the land;' and the days are days of the first-fruits of grapes. ");
INSERT INTO engylt_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","And they go up and spy the land, from the wilderness of Zin unto Rehob at the going in to Hamath; ");
INSERT INTO engylt_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","and they go up by the south, and come in unto Hebron, and there are Ahiman, Sheshai, and Talmai, children of Anak (and Hebron was built seven years before Zoan in Egypt), ");
INSERT INTO engylt_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","and they come in unto the brook of Eshcol, and cut down thence a branch and one cluster of grapes, and they bear it on a staff by two, also some of the pomegranates, and of the figs. ");
INSERT INTO engylt_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place hath one called Brook of Eshcol, because of the cluster which the sons of Israel cut from thence. ");
INSERT INTO engylt_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","And they turn back from spying the land at the end of forty days. ");
INSERT INTO engylt_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","And they go and come in unto Moses, and unto Aaron, and unto all the company of the sons of Israel, unto the wilderness of Paran, to Kadesh; and they bring them and all the company back word, and shew them the fruit of the land. ");
INSERT INTO engylt_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","And they recount to him, and say, 'We came in unto the land whither thou hast sent us, and also it is flowing with milk and honey — and this is its fruit; ");
INSERT INTO engylt_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","only, surely the people which is dwelling in the land is strong; and the cities are fenced, very great; and also children of Anak we have seen there. ");
INSERT INTO engylt_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek is dwelling in the land of the south, and the Hittite, and the Jebusite, and the Amorite is dwelling in the hill country, and the Canaanite is dwelling by the sea, and by the side of the Jordan.' ");
INSERT INTO engylt_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","And Caleb stilleth the people concerning Moses, and saith, 'Let us certainly go up — and we have possessed it; for we are thoroughly able for it.' ");
INSERT INTO engylt_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","And the men who have gone up with him said, 'We are not able to go up against the people, for it is stronger than we;' ");
INSERT INTO engylt_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","and they bring out an evil account of the land which they have spied unto the sons of Israel, saying, 'The land into which we passed over to spy it, is a land eating up its inhabitants; and all the people whom we saw in its midst are men of stature; ");
INSERT INTO engylt_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","and there we saw the Nephilim, sons of Anak, of the Nephilim; and we are in our own eyes as grasshoppers; and so we were in their eyes.' ");
INSERT INTO engylt_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","And all the company lifteth up and give forth their voice, and the people weep during that night; ");
INSERT INTO engylt_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","and all the sons of Israel murmur against Moses, and against Aaron, and all the company say unto them, 'O that we had died in the land of Egypt, or in this wilderness, O that we had died! ");
INSERT INTO engylt_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","and why is Jehovah bringing us in unto this land to fall by the sword? our wives and our infants are become a prey; is it not good for us to turn back to Egypt?' ");
INSERT INTO engylt_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","And they say one unto another, 'Let us appoint a head, and turn back to Egypt.' ");
INSERT INTO engylt_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","And Moses falleth — Aaron also — on their faces, before all the assembly of the company of the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","And Joshua son of Nun, and Caleb son of Jephunneh, of those spying the land, have rent their garments, ");
INSERT INTO engylt_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","and they speak unto all the company of the sons of Israel, saying, 'The land into which we have passed over to spy it, is a very very good land; ");
INSERT INTO engylt_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","if Jehovah hath delighted in us, then He hath brought us in unto this land, and hath given it to us, a land which is flowing with milk and honey; ");
INSERT INTO engylt_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","only, against Jehovah rebel not ye: and ye, fear not ye the people of the land, for our bread they are; their defence hath turned aside from off them, and Jehovah is with us; fear them not.' ");
INSERT INTO engylt_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","And all the company say to stone them with stones, and the honour of Jehovah hath appeared in the tent of meeting unto all the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","And Jehovah saith unto Moses, 'Until when doth this people despise Me? and until when do they not believe in Me, for all the signs which I have done in its midst? ");
INSERT INTO engylt_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I smite it with pestilence, and dispossess it, and make thee become a nation greater and mightier than it.' ");
INSERT INTO engylt_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","And Moses saith unto Jehovah, 'Then have the Egyptians heard! for Thou hast brought up with Thy power this people out of their midst, ");
INSERT INTO engylt_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","and they have said it unto the inhabitant of this land, they have heard that Thou, Jehovah, art in the midst of this people, that eye to eye Thou art seen — O Jehovah, and Thy cloud is standing over them, — and in a pillar of cloud Thou art going before them by day, and in a pillar of fire by night. ");
INSERT INTO engylt_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","'And Thou hast put to death this people as one man, and the nations who have heard Thy fame have spoken, saying, ");
INSERT INTO engylt_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","From Jehovah's want of ability to bring in this people unto the land which He hath sworn to them — He doth slaughter them in the wilderness. ");
INSERT INTO engylt_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","'And now, let, I pray Thee, the power of my Lord be great, as Thou hast spoken, saying: ");
INSERT INTO engylt_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Jehovah is slow to anger, and of great kindness; bearing away iniquity and transgression, and not entirely acquitting, charging iniquity of fathers on sons, on a third generation, and on a fourth; — ");
INSERT INTO engylt_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","forgive, I pray Thee, the iniquity of this people, according to the greatness of Thy kindness, and as Thou hast borne with this people from Egypt, even until now.' ");
INSERT INTO engylt_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","And Jehovah saith, 'I have forgiven, according to thy word; ");
INSERT INTO engylt_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","and yet, I live — and it is filled — the whole earth — with the honour of Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","for all the men who are seeing My honour, and My signs, which I have done in Egypt, and in the wilderness, and try Me these ten times, and have not hearkened to My voice — ");
INSERT INTO engylt_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","they see not the land which I have sworn to their fathers, yea, none of those despising Me see it; ");
INSERT INTO engylt_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","and My servant Caleb, because there hath been another spirit with him, and he is fully after Me — I have brought him in unto the land whither he hath entered, and his seed doth possess it. ");
INSERT INTO engylt_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","'And the Amalekite and the Canaanite are dwelling in the valley; to-morrow turn ye and journey for yourselves into the wilderness — the way of the Red Sea.' ");
INSERT INTO engylt_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","'Until when hath this evil company that which they are murmuring against Me? the murmurings of the sons of Israel, which they are murmuring against Me, I have heard; ");
INSERT INTO engylt_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","say unto them, I live — an affirmation of Jehovah — if, as ye have spoken in Mine ears — so I do not to you; ");
INSERT INTO engylt_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","in this wilderness do your carcases fall, even all your numbered ones, to all your number, from a son of twenty years and upward, who have murmured against Me; ");
INSERT INTO engylt_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ye — ye come not in unto the land which I have lifted up My hand to cause you to tabernacle in it, except Caleb son of Jephunneh, and Joshua son of Nun. ");
INSERT INTO engylt_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","'As to your infants — of whom ye have said, A spoil they are become — I have even brought them in, and they have known the land which ye have kicked against; ");
INSERT INTO engylt_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","as to you — your carcases do fall in this wilderness, ");
INSERT INTO engylt_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","and your sons are evil in the wilderness forty years, and have borne your whoredoms till your carcases are consumed in the wilderness; ");
INSERT INTO engylt_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","by the number of the days in which ye spied the land, forty days, — a day for a year, a day for a year — ye do bear your iniquities, forty years, and ye have known my breaking off; ");
INSERT INTO engylt_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I am Jehovah, I have spoken; if I do not this to all this evil company who are meeting against me; — in this wilderness they are consumed, and there they die.' ");
INSERT INTO engylt_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","And the men whom Moses hath sent to spy the land, and they turn back and cause all the company to murmur against him, by bringing out an evil account concerning the land, ");
INSERT INTO engylt_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","even the men bringing out an evil account of the land die by the plague before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","and Joshua son of Nun, and Caleb son of Jephunneh, have lived of those men who go to spy out the land. ");
INSERT INTO engylt_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","And Moses speaketh these words unto all the sons of Israel, and the people mourn exceedingly, ");
INSERT INTO engylt_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","and they rise early in the morning, and go up unto the top of the mountain, saying, 'Here we are, and we have come up unto the place which Jehovah hath spoken of, for we have sinned.' ");
INSERT INTO engylt_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","And Moses saith, 'Why is this? — ye are transgressing the command of Jehovah, and it doth not prosper; ");
INSERT INTO engylt_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","go not up, for Jehovah is not in your midst, and ye are not smitten before your enemies; ");
INSERT INTO engylt_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","for the Amalekite and the Canaanite are there before you, and ye have fallen by the sword, because that ye have turned back from after Jehovah, and Jehovah is not with you.' ");
INSERT INTO engylt_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","And they presume to go up unto the top of the mountain, and the ark of the covenant of Jehovah and Moses have not departed out of the midst of the camp. ");
INSERT INTO engylt_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","And the Amalekite and the Canaanite who are dwelling in that mountain come down and smite them, and beat them down — unto Hormah. ");
INSERT INTO engylt_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","'Speak unto the sons of Israel, and thou hast said unto them, When ye come in unto the land of your dwellings, which I am giving to you, ");
INSERT INTO engylt_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","then ye have prepared a fire-offering to Jehovah, a burnt-offering, or a sacrifice, at separating a vow or free-will-offering, or in your appointed things, to make a sweet fragrance to Jehovah, out of the herd, or out of the flock. ");
INSERT INTO engylt_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","'And he who is bringing near his offering to Jehovah hath brought near a present of flour, a tenth deal, mixed with a fourth of the hin of oil; ");
INSERT INTO engylt_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","and wine for a libation, a fourth of the hin thou dost prepare for the burnt-offering or for a sacrifice, for the one lamb; ");
INSERT INTO engylt_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","or for a ram thou dost prepare a present of flour, two-tenth deals, mixed with oil, a third of the hin; ");
INSERT INTO engylt_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","and wine for a libation, a third part of the hin, thou dost bring near — a sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","'And when thou makest a son of the herd a burnt-offering or a sacrifice, at separating a vow or peace-offerings to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","then he hath brought near for the son of the herd a present of flour, three-tenth deals, mixed with oil, a half of the hin; ");
INSERT INTO engylt_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","and wine thou bringest near for a libation, a half of the hin — a fire-offering of sweet fragrance to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","thus it is done for the one ox, or for the one ram, or for a lamb of the sheep or of the goats. ");
INSERT INTO engylt_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","'According to the number that ye prepare, so ye do to each, according to their number; ");
INSERT INTO engylt_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","every native doth thus with these, at bringing near a fire-offering of sweet fragrance to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","and when a sojourner sojourneth with you, or whoso is in your midst to your generations, and he hath made a fire-offering of sweet fragrance to Jehovah, as ye do so he doth. ");
INSERT INTO engylt_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","'One statute is for you of the congregation and for the sojourner who is sojourning, a statute age-during to your generations: as ye are so is the sojourner before Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","one law and one ordinance is to you and to the sojourner who is sojourning with you.' ");
INSERT INTO engylt_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","'Speak unto the sons of Israel, and thou hast said unto them, In your coming in unto the land whither I am bringing you in, ");
INSERT INTO engylt_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","then it hath been, in your eating of the bread of the land, ye heave up a heave-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","the beginning of your dough a cake ye heave up — a heave-offering; as the heave-offering of a threshing-floor, so ye do heave it. ");
INSERT INTO engylt_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Of the beginning of your dough ye do give to Jehovah a heave-offering — to your generations. ");
INSERT INTO engylt_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","'And when ye err, and do not all these commands which Jehovah hath spoken unto Moses, ");
INSERT INTO engylt_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","the whole that Jehovah hath charged upon you by the hand of Moses, from the day that Jehovah hath commanded, and henceforth, to your generations, ");
INSERT INTO engylt_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","then it hath been, if from the eyes of the company it hath been done in ignorance, that all the company have prepared one bullock, a son of the herd, for a burnt-offering, for sweet fragrance to Jehovah, and its present, and its libation, according to the ordinance, and one kid of the goats for a sin-offering. ");
INSERT INTO engylt_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","'And the priest hath made atonement for all the company of the sons of Israel, and it hath been forgiven them, for it is ignorance, and they — they have brought in their offering, a fire-offering to Jehovah, even their sin-offering before Jehovah for their ignorance; ");
INSERT INTO engylt_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","and it hath been forgiven to all the company of the sons of Israel, and to the sojourner who is sojourning in their midst; for to all the company it is done in ignorance. ");
INSERT INTO engylt_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","'And if one person sin in ignorance, then he hath brought near a she-goat, daughter of a year, for a sin-offering; ");
INSERT INTO engylt_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","and the priest hath made atonement for the person who is erring, in his sinning in ignorance before Jehovah, by making atonement for him, and it hath been forgiven him; ");
INSERT INTO engylt_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","for the native among the sons of Israel, and for the sojourner who is sojourning in their midst — one law is to you, for him who is doing anything through ignorance. ");
INSERT INTO engylt_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","'And the person who doth aught with a high hand — of the native or of the sojourner — Jehovah he is reviling, and that person hath been cut off from the midst of his people; ");
INSERT INTO engylt_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","because the word of Jehovah he despised, and His command hath broken — that person is certainly cut off; his iniquity is on him.' ");
INSERT INTO engylt_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","And the sons of Israel are in the wilderness, and they find a man gathering wood on the sabbath-day, ");
INSERT INTO engylt_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","and those finding him gathering wood bring him near unto Moses, and unto Aaron, and unto all the company, ");
INSERT INTO engylt_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","and they place him in ward, for it is not explained what is to be done to him. ");
INSERT INTO engylt_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","And Jehovah saith unto Moses, 'The man is certainly put to death, all the company stoning him with stones, at the outside of the camp.' ");
INSERT INTO engylt_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","And all the company bring him out unto the outside of the camp, and stone him with stones, and he dieth, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","'Speak unto the sons of Israel, and thou hast said unto them, and they have made for themselves fringes on the skirts of their garments, to their generations, and they have put on the fringe of the skirt a ribbon of blue, ");
INSERT INTO engylt_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","and it hath been to you for a fringe, and ye have seen it, and have remembered all the commands of Jehovah, and have done them, and ye search not after your heart, and after your eyes, after which ye are going a-whoring; ");
INSERT INTO engylt_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","so that ye remember and have done all My commands, and ye have been holy to your God; ");
INSERT INTO engylt_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am Jehovah your God, who hath brought you out from the land of Egypt to become your God; I, Jehovah, am your God.' ");
INSERT INTO engylt_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","And Korah, son of Izhar, son of Kohath, son of Levi, taketh both Dathan and Abiram sons of Eliab, and On son of Peleth, sons of Reuben, ");
INSERT INTO engylt_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","and they rise up before Moses, with men of the sons of Israel, two hundred and fifty, princes of the company, called of the convention, men of name, ");
INSERT INTO engylt_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","and they are assembled against Moses and against Aaron, and say unto them, 'Enough of you! for all the company — all of them are holy, and in their midst is Jehovah; and wherefore do ye lift yourselves up above the assembly of Jehovah?' ");
INSERT INTO engylt_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","And Moses heareth, and falleth on his face, ");
INSERT INTO engylt_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","and he speaketh unto Korah, and unto all his company, saying, 'Morning! — and Jehovah is knowing those who are his, and him who is holy, and hath brought near unto Him; even him whom He doth fix on He bringeth near unto Him. ");
INSERT INTO engylt_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","This do: take to yourselves censers, Korah, and all his company, ");
INSERT INTO engylt_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","and put in them fire, and put on them perfume, before Jehovah to-morrow, and it hath been, the man whom Jehovah chooseth, he is the holy one; — enough of you, sons of Levi.' ");
INSERT INTO engylt_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","And Moses saith unto Korah, 'Hear ye, I pray you, sons of Levi; ");
INSERT INTO engylt_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","is it little to you that the God of Israel hath separated you from the company of Israel to bring you near unto Himself, to do the service of the tabernacle of Jehovah, and to stand before the company to serve them? — ");
INSERT INTO engylt_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","yea, He doth bring thee near, and all thy brethren the sons of Levi with thee — and ye have sought also the priesthood! ");
INSERT INTO engylt_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Therefore, thou and all thy company who are met are against Jehovah; and Aaron, what is he, that ye murmur against him?' ");
INSERT INTO engylt_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","And Moses sendeth to call for Dathan and for Abiram sons of Eliab, and they say, 'We do not come up; ");
INSERT INTO engylt_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","is it little that thou hast brought us up out of a land flowing with milk and honey to put us to death in a wilderness that thou also certainly makest thyself prince over us? ");
INSERT INTO engylt_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Yea, unto a land flowing with milk and honey thou hast not brought us in, nor dost thou give to us an inheritance of field and vineyard; the eyes of these men dost thou pick out? we do not come up.' ");
INSERT INTO engylt_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","And it is very displeasing to Moses, and he saith unto Jehovah, 'Turn not Thou unto their present; not one ass from them have I taken, nor have I afflicted one of them.' ");
INSERT INTO engylt_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","And Moses saith unto Korah, 'Thou and all thy company, be ye before Jehovah, thou, and they, and Aaron, to-morrow; ");
INSERT INTO engylt_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","and take ye each his censer, and ye have put on them perfume, and brought near before Jehovah, each his censer, two hundred and fifty censers; and thou and Aaron, each his censer.' ");
INSERT INTO engylt_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","And they take each his censer, and put on them fire, and lay on them perfume, and they stand at the opening of the tent of meeting, with Moses and Aaron. ");
INSERT INTO engylt_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","And Korah assembleth against them all the company unto the opening of the tent of meeting, and the honour of Jehovah is seen by all the company. ");
INSERT INTO engylt_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","And Jehovah speaketh unto Moses and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","'Be ye separated from the midst of this company, and I consume them in a moment;' ");
INSERT INTO engylt_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","and they fall on their faces, and say, 'God, God of the spirits of all flesh — the one man sinneth, and against all the company Thou art wroth!' ");
INSERT INTO engylt_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","'Speak unto the company, saying, Go ye up from round about the tabernacle of Korah, Dathan, and Abiram.' ");
INSERT INTO engylt_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","And Moses riseth, and goeth unto Dathan and Abiram, and the elders of Israel go after him, ");
INSERT INTO engylt_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","and he speaketh unto the company, saying, 'Turn aside, I pray you, from the tents of these wicked men, and come not against anything that they have, lest ye be consumed in all their sins.' ");
INSERT INTO engylt_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","And they go up from the tabernacle of Korah, Dathan and Abiram, from round about, and Dathan, and Abiram have come out, standing at the opening of their tents, and their wives, and their sons, and their infants. ");
INSERT INTO engylt_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","And Moses saith, 'By this ye do know that Jehovah hath sent me to do all these works, that they are not from my own heart; ");
INSERT INTO engylt_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","if according to the death of all men these die — or the charge of all men is charged upon them — Jehovah hath not sent me; ");
INSERT INTO engylt_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","and if a strange thing Jehovah do, and the ground hath opened her mouth and swallowed them, and all that they have, and they have gone down alive to Sheol — then ye have known that these men have despised Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","And it cometh to pass at his finishing speaking all these words, that the ground which is under them cleaveth, ");
INSERT INTO engylt_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","and the earth openeth her mouth, and swalloweth them, and their houses, and all the men who are for Korah, and all the goods, ");
INSERT INTO engylt_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","and they go down, they, and all that they have, alive to Sheol, and the earth closeth over them, and they perish from the midst of the assembly; ");
INSERT INTO engylt_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","and all Israel who are round about them have fled at their voice, for they said, 'Lest the earth swallow us;' ");
INSERT INTO engylt_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","and fire hath come out from Jehovah, and consumeth the two hundred and fifty men bringing near the perfume. ");
INSERT INTO engylt_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","'Say unto Eleazar son of Aaron the priest, and he lifteth up the censers from the midst of the burning, and the fire scatter thou yonder, for they have been hallowed, ");
INSERT INTO engylt_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","even the censers of these sinners against their own souls; and they have made them spread-out plates, a covering for the altar, for they have brought them near before Jehovah, and they are hallowed; and they are become a sign to the sons of Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","And Eleazar the priest taketh the brazen censers which they who are burnt had brought near, and they spread them out, a covering for the altar — ");
INSERT INTO engylt_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","a memorial to the sons of Israel, so that a stranger who is not of the seed of Aaron doth not draw near to make a perfume before Jehovah, and is not as Korah, and as his company, — as Jehovah hath spoken by the hand of Moses to him. ");
INSERT INTO engylt_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","And all the company of the sons of Israel murmur, on the morrow, against Moses and against Aaron, saying, 'Ye — ye have put to death the people of Jehovah.' ");
INSERT INTO engylt_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","And it cometh to pass, in the company being assembled against Moses and against Aaron, that they turn towards the tent of meeting, and lo, the cloud hath covered it, and the honour of Jehovah is seen; ");
INSERT INTO engylt_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","and Moses cometh — Aaron also — unto the front of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","'Get you up from the midst of this company, and I consume them in a moment;' and they fall on their faces, ");
INSERT INTO engylt_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","and Moses saith unto Aaron, 'Take the censer, and put on it fire from off the altar, and place perfume, and go, hasten unto the company, and make atonement for them, for the wrath hath gone out from the presence of Jehovah — the plague hath begun.' ");
INSERT INTO engylt_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","And Aaron taketh as Moses hath spoken, and runneth unto the midst of the assembly, and lo, the plague hath begun among the people; and he giveth the perfume, and maketh atonement for the people, ");
INSERT INTO engylt_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","and standeth between the dead and the living, and the plague is restrained; ");
INSERT INTO engylt_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","and those who die by the plague are fourteen thousand and seven hundred, apart from those who die for the matter of Korah; ");
INSERT INTO engylt_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","and Aaron turneth back unto Moses, unto the opening of the tent of meeting, and the plague hath been restrained. ");
INSERT INTO engylt_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","'Speak unto the sons of Israel, and take from them each a rod, for a father's house, from all their princes, for the house of their fathers, twelve rods; the name of each thou dost write on his rod, ");
INSERT INTO engylt_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","and Aaron's name thou dost write on the tribe of Levi; for one rod is for the head of their fathers' house: ");
INSERT INTO engylt_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","and thou hast placed them in the tent of meeting, before the testimony, where I meet with you. ");
INSERT INTO engylt_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","'And it hath come to pass, the man's rod on whom I fix doth flourish, and I have caused to cease from off me the murmurings of the sons of Israel, which they are murmuring against you.' ");
INSERT INTO engylt_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","And Moses speaketh unto the sons of Israel, and all their princes give unto him one rod for a prince, one rod for a prince, for their fathers' house, twelve rods, and the rod of Aaron is in the midst of their rods; ");
INSERT INTO engylt_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","and Moses placeth the rods before Jehovah, in the tent of the testimony. ");
INSERT INTO engylt_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","And it cometh to pass, on the morrow, that Moses goeth in unto the tent of the testimony, and lo, the rod of Aaron hath flourished for the house of Levi, and is bringing out flourishing, and doth blossom blossoms, and doth produce almonds; ");
INSERT INTO engylt_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","and Moses bringeth out all the rods from before Jehovah, unto all the sons of Israel, and they look, and take each his rod. ");
INSERT INTO engylt_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","And Jehovah saith unto Moses, 'Put back the rod of Aaron, before the testimony, for a charge, for a sign to the sons of rebellion, and thou dost remove their murmurings from off me, and they do not die;' ");
INSERT INTO engylt_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","and Moses doth as Jehovah hath commanded him; so he hath done. ");
INSERT INTO engylt_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","And the sons of Israel speak unto Moses, saying, 'Lo, we have expired; we have perished; we have all of us perished; ");
INSERT INTO engylt_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","any who is at all drawing near unto the tabernacle of Jehovah dieth; have we not been consumed — to expire?' ");
INSERT INTO engylt_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","And Jehovah saith unto Aaron, 'Thou, and thy sons, and the house of thy father with thee, do bear the iniquity of the sanctuary; and thou, and thy sons with thee, do bear the iniquity of your priesthood; ");
INSERT INTO engylt_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","and also thy brethren, the tribe of Levi, the tribe of thy father, bring near with thee, and they are joined unto thee, and serve thee, even thou and thy sons with thee, before the tent of the testimony. ");
INSERT INTO engylt_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","'And they have kept thy charge, and the charge of all the tent; only, unto the vessels of the sanctuary and unto the altar they do not come near, and they die not, either they or you; ");
INSERT INTO engylt_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","and they have been joined unto thee, and have kept the charge of the tent of meeting, for all the service of the tent; and a stranger doth not come near unto you; ");
INSERT INTO engylt_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","and ye have kept the charge of the sanctuary, and the charge of the altar, and there is no more wrath against the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","'And I, lo, I have taken your brethren the Levites from the midst of the sons of Israel; to you a gift they are given by Jehovah, to do the service of the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","and thou, and thy sons with thee, do keep your priesthood, for everything of the altar, and within the vail, and ye have served; a service of gift I make your priesthood; and the stranger who is coming near is put to death.' ");
INSERT INTO engylt_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","And Jehovah speaketh unto Aaron: 'And I, lo, I have given to thee the charge of My heave-offerings, of all the hallowed things of the sons of Israel — to thee I have given them for the anointing, and to thy sons, by a statute age-during. ");
INSERT INTO engylt_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","This is thine of the most holy things, from the fire: all their offering, to all their present, and to all their sin-offering, and to all their guilt-offering, which they give back to Me, is most holy to thee, and to thy sons; ");
INSERT INTO engylt_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","in the holy of holies thou dost eat it; every male doth eat it; holy it is to thee. ");
INSERT INTO engylt_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","'And this is thine: the heave-offering of their gift, to all the wave-offerings of the sons of Israel, to thee I have given them, and to thy sons, and to thy daughters with thee, by a statute age-during; every clean one in thy house doth eat it; ");
INSERT INTO engylt_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","all the best of the oil, and all the best of the new wine, and wheat — their first -fruits which they give to Jehovah — to thee I have given them. ");
INSERT INTO engylt_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","'The first-fruits of all that is in their land, which they bring in to Jehovah, are thine; every clean one in thy house doth eat it; ");
INSERT INTO engylt_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","every devoted thing in Israel is thine, ");
INSERT INTO engylt_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","every one opening a womb of all flesh which they bring near to Jehovah, among man and among beast, is thine; only, thou dost certainly ransom the first-born of man, and the firstling of the unclean beast thou dost ransom. ");
INSERT INTO engylt_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","'And their ransomed ones from a son of a month, thou dost ransom with thy valuation, of silver, five shekels, by the shekel of the sanctuary, twenty gerahs it is. ");
INSERT INTO engylt_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","'Only, the firstling of a cow, or the firstling of a sheep, or the firstling of a goat, thou dost not ransom, holy they are: their blood thou dost sprinkle on the altar, and of their fat thou makest perfume, a fire-offering of sweet fragrance to Jehovah, ");
INSERT INTO engylt_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","and their flesh is thine, as the breast of the wave-offering, and as the right leg, it is thine; ");
INSERT INTO engylt_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","all the heave-offerings of the holy things which the sons of Israel lift up to Jehovah I have given to thee and to thy sons, and to thy daughters with thee, by a statute age-during, a covenant of salt, age-during it is before Jehovah, to thee and to thy seed with thee.' ");
INSERT INTO engylt_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","And Jehovah saith unto Aaron, 'In their land thou dost not inherit, and a portion thou hast not in their midst: I am thy portion, and thine inheritance in the midst of the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","and to the sons of Levi, lo, I have given all the tenth in Israel for inheritance in exchange for their service which they are serving — the service of the tent of meeting. ");
INSERT INTO engylt_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","'And the sons of Israel come no more near unto the tent of meeting, to bear sin, to die, ");
INSERT INTO engylt_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","and the Levites have done the service of the tent of meeting, and they — they bear their iniquity; a statute age-during to your generations, that in the midst of the sons of Israel they have no inheritance; ");
INSERT INTO engylt_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","but the tithe of the sons of Israel which they lift up to Jehovah, a heave-offering, I have given to the Levites for inheritance; therefore I have said of them, In the midst of the sons of Israel they have no inheritance.' ");
INSERT INTO engylt_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","'And unto the Levites thou dost speak; and thou hast said unto them, When ye take from the sons of Israel the tithe which I have given to you from them, for your inheritance, then ye have lifted up from it the heave-offering of Jehovah, a tithe of the tithe; ");
INSERT INTO engylt_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","and your heave-offering hath been reckoned to you as corn from the threshing-floor, and as fulness from the wine-vat; ");
INSERT INTO engylt_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","so ye do lift up — ye also — the heave-offering of Jehovah from all your tithes which ye receive from the sons of Israel; and ye have given from it the heave-offering of Jehovah to Aaron the priest; ");
INSERT INTO engylt_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","out of all your gifts ye do lift up the whole heave-offering of Jehovah; out of all its fat, — its hallowed part — out of it. ");
INSERT INTO engylt_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","'And thou hast said unto them, In your lifting up its fat out of it, then it hath been reckoned to the Levites, as increase of a threshing-floor, and as increase of a wine-vat; ");
INSERT INTO engylt_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","and ye have eaten it in every place, ye and your households, for it is your hire in exchange for your service in the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","and ye bear no sin for it, in your lifting up its fat out of it, and the holy things of the sons of Israel ye do not pollute, and ye die not.' ");
INSERT INTO engylt_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","And Jehovah speaketh unto Moses, and unto Aaron, saying, ");
INSERT INTO engylt_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","'This is a statute of the law which Jehovah hath commanded, saying, Speak unto the sons of Israel, and they bring unto thee a red cow, a perfect one, in which there is no blemish, on which no yoke hath gone up; ");
INSERT INTO engylt_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","and ye have given it unto Eleazar the priest, and he hath brought it out unto the outside of the camp, and hath slaughtered it before him. ");
INSERT INTO engylt_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","'And Eleazar the priest hath taken of its blood with his finger, and hath sprinkled over-against the front of the tent of meeting of her blood seven times; ");
INSERT INTO engylt_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","and one hath burnt the cow before his eyes; her skin, and her flesh, and her blood, besides her dung, he doth burn; ");
INSERT INTO engylt_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","and the priest hath taken cedar wood, and hyssop, and scarlet, and hath cast unto the midst of the burning of the cow; ");
INSERT INTO engylt_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","and the priest hath washed his garments, and hath bathed his flesh with water, and afterwards doth come in unto the camp, and the priest is unclean till the evening; ");
INSERT INTO engylt_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","and he who is burning it doth wash his garments with water, and hath bathed his flesh with water, and is unclean till the evening. ");
INSERT INTO engylt_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","'And a clean man hath gathered the ashes of the cow, and hath placed at the outside of the camp, in a clean place, and it hath become to the company of the sons of Israel a charge for waters of separation — it is a cleansing; ");
INSERT INTO engylt_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","and he who is gathering the ashes of the heifer hath washed his garments, and is unclean till the evening; and it hath been to the sons of Israel, and to the sojourner who is sojourning in their midst, for a statute age-during. ");
INSERT INTO engylt_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","'He who is coming against the dead body of any man — is unclean seven days; ");
INSERT INTO engylt_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","he doth cleanse himself for it on the third day, and on the seventh day he is clean; and if he cleanse not himself on the third day, then on the seventh day he is not clean. ");
INSERT INTO engylt_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Any one who is coming against the dead, against the body of man who dieth, and cleanseth not himself — the tabernacle of Jehovah he hath defiled, and that person hath been cut off from Israel, for water of separation is not sprinkled upon him; he is unclean; his uncleanness is still upon him. ");
INSERT INTO engylt_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","'This is the law, when a man dieth in a tent: every one who is coming in unto the tent, and all that is in the tent, is unclean seven days; ");
INSERT INTO engylt_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","and every open vessel which hath no covering of thread upon it is unclean. ");
INSERT INTO engylt_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","'And every one who cometh, on the face of the field, against the pierced of a sword, or against the dead, or against a bone of man, or against a grave, is unclean seven days; ");
INSERT INTO engylt_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","and they have taken for the unclean person of the ashes of the burning of the cleansing, and he hath put upon it running water unto a vessel; ");
INSERT INTO engylt_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","and a clean person hath taken hyssop, and hath dipped it in water, and hath sprinkled on the tent, and on all the vessels, and on the persons who have been there, and on him who is coming against a bone, or against one pierced, or against the dead, or against a grave. ");
INSERT INTO engylt_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","'And the clean hath sprinkled it on the unclean on the third day, and on the seventh day, and hath cleansed him on the seventh day, and he hath washed his garments, and hath bathed with water, and hath been clean in the evening. ");
INSERT INTO engylt_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","'And the man who is unclean, and doth not cleanse himself, even that person hath been cut off from the midst of the assembly; for the sanctuary of Jehovah he hath defiled; water of separation is not sprinkled upon him; he is unclean. ");
INSERT INTO engylt_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","'And it hath been to them for a statute age-during, that he who is sprinkling the water of separation doth wash his garments, and he who is coming against the water of separation is unclean till the evening, ");
INSERT INTO engylt_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","and all against which the unclean person cometh is unclean, and the person who is coming against it is unclean till the evening.' ");
INSERT INTO engylt_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","And the sons of Israel come in, — all the company — to the wilderness of Zin, in the first month, and the people abide in Kadesh, and Miriam dieth there, and is buried there. ");
INSERT INTO engylt_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","And there hath been no water for the company, and they are assembled against Moses, and against Aaron, ");
INSERT INTO engylt_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","and the people strive with Moses, and speak, saying, 'And oh that we had expired when our brethren expired before Jehovah! ");
INSERT INTO engylt_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","and why have ye brought in the assembly of Jehovah unto this wilderness to die there, we and our beasts? ");
INSERT INTO engylt_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","and why hast thou brought us up out of Egypt to bring us in unto this evil place? no place of seed, and fig, and vine, and pomegranate; and water there is none to drink. ");
INSERT INTO engylt_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","And Moses and Aaron go in from the presence of the assembly unto the opening of the tent of meeting, and fall on their faces, and the honour of Jehovah is seen by them. ");
INSERT INTO engylt_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","'Take the rod, and assemble the company, thou and Aaron thy brother; and ye have spoken unto the rock before their eyes, and it hath given its water, and thou hast brought out to them water from the rock, and hast watered the company, and their beasts.' ");
INSERT INTO engylt_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","And Moses taketh the rod from before Jehovah, as He hath commanded him, ");
INSERT INTO engylt_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","and Moses and Aaron assemble the assembly unto the front of the rock, and he saith to them, 'Hear, I pray you, O rebels, from this rock do we bring out to you water?' ");
INSERT INTO engylt_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","and Moses lifteth up his hand, and smiteth the rock with his rod twice; and much water cometh out, and the company drink, also their beasts. ");
INSERT INTO engylt_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","And Jehovah saith unto Moses, and unto Aaron, 'Because ye have not believed in Me to sanctify Me before the eyes of the sons of Israel, therefore ye do not bring in this assembly unto the land which I have given to them.' ");
INSERT INTO engylt_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These are waters of Meribah, because the sons of Israel have 'striven' with Jehovah, and He is sanctified upon them. ");
INSERT INTO engylt_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","And Moses sendeth messengers from Kadesh unto the king of Edom, 'Thus said thy brother Israel, Thou — thou hast known all the travail which hath found us; ");
INSERT INTO engylt_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","that our fathers go down to Egypt, and we dwell in Egypt many days, and the Egyptians do evil to us and to our fathers; ");
INSERT INTO engylt_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","and we cry unto Jehovah, and He heareth our voice, and sendeth a messenger, and is bringing us out of Egypt; and lo, we are in Kadesh, a city in the extremity of thy border. ");
INSERT INTO engylt_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Let us pass over, we pray thee, through thy land; we pass not over through a field, or through a vineyard, nor do we drink waters of a well; the way of the king we go, we turn not aside — right or left — till that we pass over thy border.' ");
INSERT INTO engylt_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","And Edom saith unto him, 'Thou dost not pass over through me, lest with sword I come out to meet thee.' ");
INSERT INTO engylt_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","And the sons of Israel say unto him, 'In the highway we go, and if of thy waters we drink — I and my cattle — then I have given their price; only (it is nothing) on my feet I pass over.' ");
INSERT INTO engylt_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","And he saith, 'Thou dost not pass over;' and Edom cometh out to meet him with much people, and with a strong hand; ");
INSERT INTO engylt_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","and Edom refuseth to suffer Israel to pass over through his border, and Israel turneth aside from off him. ");
INSERT INTO engylt_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","And the sons of Israel, the whole company, journey from Kadesh, and come in unto mount Hor, ");
INSERT INTO engylt_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","and Jehovah speaketh unto Moses and unto Aaron in mount Hor, on the border of the land of Edom, saying, ");
INSERT INTO engylt_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","'Aaron is gathered unto his people, for he doth not go in unto the land which I have given to the sons of Israel, because that ye provoked My mouth at the waters of Meribah. ");
INSERT INTO engylt_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","'Take Aaron and Eleazar his son, and cause them to go up mount Hor, ");
INSERT INTO engylt_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","and strip Aaron of his garments, and thou hast clothed with them Eleazar his son, and Aaron is gathered, and doth die there.' ");
INSERT INTO engylt_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","And Moses doth as Jehovah hath commanded, and they go up unto mount Hor before the eyes of all the company, ");
INSERT INTO engylt_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","and Moses strippeth Aaron of his garments, and clotheth with them Eleazar his son, and Aaron dieth there on the top of the mount; and Moses cometh down — Eleazar also — from the mount, ");
INSERT INTO engylt_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","and all the company see that Aaron hath expired, and they bewail Aaron thirty days — all the house of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","And the Canaanite — king Arad — dwelling in the south, heareth that Israel hath come the way of the Atharim, and he fighteth against Israel, and taketh some of them captive. ");
INSERT INTO engylt_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","And Israel voweth a vow to Jehovah, and saith, 'If Thou dost certainly give this people into my hand, then I have devoted their cities;' ");
INSERT INTO engylt_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","and Jehovah hearkeneth to the voice of Israel, and giveth up the Canaanite, and he devoteth them and their cities, and calleth the name of the place Hormah. ");
INSERT INTO engylt_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","And they journey from mount Hor, the way of the Red Sea, to compass the land of Edom, and the soul of the people is short in the way, ");
INSERT INTO engylt_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","and the people speak against God, and against Moses, 'Why hast thou brought us up out of Egypt to die in a wilderness? for there is no bread, and there is no water, and our soul hath been weary of this light bread.' ");
INSERT INTO engylt_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","And Jehovah sendeth among the people the burning serpents, and they bite the people, and much people of Israel die; ");
INSERT INTO engylt_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","and the people come in unto Moses and say, 'We have sinned, for we have spoken against Jehovah, and against thee; pray unto Jehovah, and He doth turn aside from us the serpent;' and Moses prayeth in behalf of the people. ");
INSERT INTO engylt_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","And Jehovah saith unto Moses, 'Make for thee a burning serpent, and set it on an ensign; and it hath been, every one who is bitten and hath seen it — he hath lived. ");
INSERT INTO engylt_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","And Moses maketh a serpent of brass, and setteth it on the ensign, and it hath been, if the serpent hath bitten any man, and he hath looked expectingly unto the serpent of brass — he hath lived. ");
INSERT INTO engylt_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","And the sons of Israel journey, and encamp in Oboth. ");
INSERT INTO engylt_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","And they journey from Oboth, and encamp in Ije-Abarim, in the wilderness that is on the front of Moab, at the rising of the sun. ");
INSERT INTO engylt_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","From thence they have journeyed, and encamp in the valley of Zared. ");
INSERT INTO engylt_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From thence they have journeyed, and encamp beyond Arnon, which is in the wilderness which is coming out of the border of the Amorite, for Arnon is the border of Moab, between Moab and the Amorite; ");
INSERT INTO engylt_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","therefore it is said in a book, 'The wars of Jehovah,' — 'Waheb in Suphah, And the brooks of Arnon; ");
INSERT INTO engylt_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","And the spring of the brooks, Which turned aside to the dwelling of Ar, And hath leaned to the border of Moab.' ");
INSERT INTO engylt_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","And from thence they journeyed to Beer; it is the well concerning which Jehovah said to Moses, 'Gather the people, and I give to them — water.' ");
INSERT INTO engylt_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then singeth Israel this song, concerning the well — they have answered to it: ");
INSERT INTO engylt_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","'A well — digged it have princes, Prepared it have nobles of the people, With the lawgiver, with their staves.' And from the wilderness they journeyed to Mattanah, ");
INSERT INTO engylt_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","and from Mattanah to Nahaliel, and from Nahaliel to Bamoth, ");
INSERT INTO engylt_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","and from Bamoth in the valley which is in the field of Moab to the top of Pisgah, which hath looked on the front of the wilderness. ");
INSERT INTO engylt_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","And Israel sendeth messengers unto Sihon king of the Amorite, saying, ");
INSERT INTO engylt_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","'Let me pass through thy land, we do not turn aside into a field, or into a vineyard, we do not drink waters of a well; in the king's way we go, till that we pass over thy border.' ");
INSERT INTO engylt_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","And Sihon hath not suffered Israel to pass through his border, and Sihon gathereth all his people, and cometh out to meet Israel into the wilderness, and cometh in to Jahaz, and fighteth against Israel. ");
INSERT INTO engylt_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","And Israel smiteth him by the mouth of the sword, and possesseth his land from Arnon unto Jabbok — unto the sons of Ammon; for the border of the sons of Ammon is strong. ");
INSERT INTO engylt_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","And Israel taketh all these cities, and Israel dwelleth in all the cities of the Amorite, in Heshbon, and in all its villages; ");
INSERT INTO engylt_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","for Heshbon is a city of Sihon king of the Amorite, and he hath fought against the former king of Moab, and taketh all his land out of his hand, unto Arnon; ");
INSERT INTO engylt_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","therefore those using similes say — 'Enter ye Heshbon, Let the city of Sihon be built and ready, ");
INSERT INTO engylt_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For fire hath gone out from Heshbon, A flame from the city of Sihon, It hath consumed Ar of Moab, Owners of the high places of Arnon. ");
INSERT INTO engylt_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to thee, O Moab, Thou hast perished, O people of Chemosh, He hath given his sons who escape — Also his daughters — Into captivity, to a king of the Amorite — Sihon! ");
INSERT INTO engylt_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","And we shoot them, Perished hath Heshbon unto Dibon, And we make desolate unto Nophah, Which is unto Medeba.' ");
INSERT INTO engylt_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","And Israel dwelleth in the land of the Amorite, ");
INSERT INTO engylt_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","and Moses sendeth to spy out Jaazer, and they capture its villages, and dispossess the Amorite who is there, ");
INSERT INTO engylt_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","and turn and go up the way of Bashan, and Og king of Bashan cometh out to meet them, he and all his people, to battle, at Edrei. ");
INSERT INTO engylt_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","And Jehovah saith unto Moses, 'Fear him not, for into thy hand I have given him, and all his people, and his land, and thou hast done to him as thou hast done to Sihon king of the Amorite, who is dwelling in Heshbon.' ");
INSERT INTO engylt_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","And they smite him, and his sons, and all his people, until he hath not left to him a remnant, and they possess his land. ");
INSERT INTO engylt_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","And the sons of Israel journey and encamp in the plains of Moab, beyond the Jordan, by Jericho. ");
INSERT INTO engylt_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","And Balak son of Zippor seeth all that Israel hath done to the Amorite, ");
INSERT INTO engylt_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","and Moab is exceedingly afraid of the presence of the people, for it is numerous; and Moab is vexed by the presence of the sons of Israel, ");
INSERT INTO engylt_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","and Moab saith unto the elders of Midian, 'Now doth the assembly lick up all that is round about us, as the ox licketh up the green thing of the field.' And Balak son of Zippor is king of Moab at that time, ");
INSERT INTO engylt_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","and he sendeth messengers unto Balaam son of Beor, to Pethor, which is by the River of the land of the sons of his people, to call for him, saying, 'Lo, a people hath come out of Egypt; lo, it hath covered the eye of the land, and it is abiding over-against me; ");
INSERT INTO engylt_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","and now, come, I pray thee, curse for me this people, for it is mightier than I; it may be I prevail — we smite it — and I cast it out from the land; for I have known — that which thou blessest is blessed, and that which thou cursest is cursed.' ");
INSERT INTO engylt_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","And the elders of Moab and the elders of Midian go, and divinations in their hand, and they come in unto Balaam, and speak unto him the words of Balak, ");
INSERT INTO engylt_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","and he saith unto them, 'Lodge here to-night, and I have brought you back word, as Jehovah speaketh unto me;' and the princes of Moab abide with Balaam. ");
INSERT INTO engylt_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","And God cometh in unto Balaam, and saith, 'Who are these men with thee?' ");
INSERT INTO engylt_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","And Balaam saith unto God, 'Balak, son of Zippor, king of Moab, hath sent unto me: ");
INSERT INTO engylt_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Lo, the people that is coming out from Egypt and covereth the eye of the land, — now come, pierce it for me; it may be I am able to fight against it, and have cast it out;' ");
INSERT INTO engylt_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","and God saith unto Balaam, 'Thou dost not go with them; thou dost not curse the people; for it is blessed.' ");
INSERT INTO engylt_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","And Balaam riseth in the morning, and saith unto the princes of Balak, 'Go unto your land, for Jehovah is refusing to suffer me to go with you;' ");
INSERT INTO engylt_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","and the princes of Moab rise, and come in unto Balak, and say, 'Balaam is refusing to come with us.' ");
INSERT INTO engylt_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","And Balak addeth yet to send princes, more numerous and honoured than these, ");
INSERT INTO engylt_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","and they come in unto Balaam, and say to him, 'Thus said Balak son of Zippor, Be not, I pray thee, withheld from coming unto me, ");
INSERT INTO engylt_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","for very greatly I honour thee, and all that thou sayest unto me I do; and come, I pray thee, pierce for me this people.' ");
INSERT INTO engylt_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","And Balaam answereth and saith unto the servants of Balak, 'If Balak doth give to me the fulness of his house of silver and gold, I am not able to pass over the command of Jehovah my God, to do a little or a great thing; ");
INSERT INTO engylt_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","and, now, abide, I pray you, in this place, you also, to-night; and I know what Jehovah is adding to speak with me.' ");
INSERT INTO engylt_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","And God cometh in unto Balaam, by night, and saith to him, 'If to call for thee the men have come, rise, go with them, and only the thing which I speak unto thee — it thou dost do.' ");
INSERT INTO engylt_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","And Balaam riseth in the morning, and saddleth his ass, and goeth with the princes of Moab, ");
INSERT INTO engylt_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","and the anger of God burneth because he is going, and a messenger of Jehovah stationeth himself in the way for an adversary to him, and he is riding on his ass, and two of his servants are with him, ");
INSERT INTO engylt_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","and the ass seeth the messenger of Jehovah standing in the way, and his drawn sword in his hand, and the ass turneth aside out of the way, and goeth into a field, and Balaam smiteth the ass to turn it aside into the way. ");
INSERT INTO engylt_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","And the messenger of Jehovah standeth in a narrow path of the vineyards — a wall on this side and a wall on that — ");
INSERT INTO engylt_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","and the ass seeth the messenger of Jehovah, and is pressed unto the wall, and presseth Balaam's foot unto the wall, and he addeth to smite her; ");
INSERT INTO engylt_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","and the messenger of Jehovah addeth to pass over, and standeth in a strait place where there is no way to turn aside — right or left — ");
INSERT INTO engylt_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","and the ass seeth the messenger of Jehovah, and croucheth under Balaam, and the anger of Balaam burneth, and he smiteth the ass with a staff. ");
INSERT INTO engylt_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","And Jehovah openeth the mouth of the ass, and she saith to Balaam, 'What have I done to thee that thou hast smitten me these three times?' ");
INSERT INTO engylt_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","and Balaam saith to the ass, 'Because thou hast rolled thyself against me; oh that there were a sword in my hand, for now I had slain thee;' ");
INSERT INTO engylt_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","and the ass saith unto Balaam, 'Am not I thine ass, upon which thou hast ridden since I was thine unto this day? have I at all been accustomed to do to thee thus?' and he saith, 'No.' ");
INSERT INTO engylt_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","And Jehovah uncovereth the eyes of Balaam, and he seeth the messenger of Jehovah standing in the way, and his drawn sword in his hand, and he boweth and doth obeisance, to his face; ");
INSERT INTO engylt_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","and the messenger of Jehovah saith unto him, 'Wherefore hast thou smitten thine ass these three times? lo, I — I have come out for an adversary, for thy way hath been perverse before me, ");
INSERT INTO engylt_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","and the ass seeth me, and turneth aside at my presence these three times; unless she had turned aside from my presence, surely now also, thee I had slain, and her kept alive.' ");
INSERT INTO engylt_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","And Balaam saith unto the messenger of Jehovah, 'I have sinned, for I did not know that thou art standing to meet me in the way; and now, if evil in thine eyes — I turn back by myself.' ");
INSERT INTO engylt_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","And the messenger of Jehovah saith unto Balaam, 'Go with the men; and only the word which I speak unto thee — it thou dost speak;' and Balaam goeth with the princes of Balak. ");
INSERT INTO engylt_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","And Balak heareth that Balaam hath come, and goeth out to meet him, unto a city of Moab, which is on the border of Arnon, which is in the extremity of the border; ");
INSERT INTO engylt_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","and Balak saith unto Balaam, 'Did I not diligently sent unto thee to call for thee? why didst thou not come unto me? am I not truly able to honour thee?' ");
INSERT INTO engylt_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","And Balaam saith unto Balak, 'Lo, I have come unto thee; now — am I at all able to speak anything? the word which God setteth in my mouth — it I do speak.' ");
INSERT INTO engylt_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","And Balaam goeth with Balak, and they come to Kirjath-Huzoth, ");
INSERT INTO engylt_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","and Balak sacrificeth oxen and sheep, and sendeth to Balaam, and to the princes who are with him; ");
INSERT INTO engylt_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","and it cometh to pass in the morning, that Balak taketh Balaam, and causeth him to go up the high places of Baal, and he seeth from thence the extremity of the people. ");
INSERT INTO engylt_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","And Balaam saith unto Balak, 'Build for me in this place seven altars, and make ready for me in this place seven bullocks and seven rams.' ");
INSERT INTO engylt_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","And Balak doth as Balaam hath spoken, and Balak — Balaam also — offereth a bullock and a ram on the altar, ");
INSERT INTO engylt_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","and Balaam saith to Balak, 'Station thyself by thy burnt-offering and I go on, it may be Jehovah doth come to meet me, and the thing which He sheweth me — I have declared to thee;' and he goeth to a high place. ");
INSERT INTO engylt_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","And God cometh unto Balaam, and he saith unto Him, 'The seven altars I have arranged, and I offer a bullock and a ram on the altar;' ");
INSERT INTO engylt_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","and Jehovah putteth a word in the mouth of Balaam, and saith, 'Turn back unto Balak, and thus thou dost speak.' ");
INSERT INTO engylt_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","And he turneth back unto him, and lo, he is standing by his burnt-offering, he and all the princes of Moab. ");
INSERT INTO engylt_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","And he taketh up his simile, and saith: 'From Aram he doth lead me — Balak king of Moab; From mountains of the east: Come — curse for me Jacob, And come — be indignant with Israel. ");
INSERT INTO engylt_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","What — do I pierce? — God hath not pierced! And what — am I indignant? — Jehovah hath not been indignant! ");
INSERT INTO engylt_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For from the top of rocks I see it, And from heights I behold it; Lo a people! alone it doth tabernacle, And among nations doth not reckon itself. ");
INSERT INTO engylt_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who hath counted the dust of Jacob, And the number of the fourth of Israel? Let me die the death of upright ones, And let my last end be like his!' ");
INSERT INTO engylt_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","And Balak saith unto Balaam, 'What hast thou done to me? to pierce mine enemies I have taken thee — and lo, thou hast certainly blessed;' ");
INSERT INTO engylt_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","and he answereth and saith, 'That which Jehovah doth put in my mouth — it do I not take heed to speak?' ");
INSERT INTO engylt_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","And Balak saith unto him, 'Come, I pray thee, with me unto another place, whence thou dost see it, only its extremity thou dost see, and all of it thou dost not see, and pierce it for me thence;' ");
INSERT INTO engylt_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","and he taketh him to the field of Zophim, unto the top of Pisgah, and buildeth seven altars, and offereth a bullock and a ram on the altar. ");
INSERT INTO engylt_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","And he saith unto Balak, 'Station thyself here by thy burnt-offering, and I — I meet Him there;' ");
INSERT INTO engylt_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","and Jehovah cometh unto Balaam, and setteth a word in his mouth, and saith, 'Turn back unto Balak, and thus thou dost speak.' ");
INSERT INTO engylt_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","And he cometh unto him, and lo, he is standing by his burnt-offering, and the princes of Moab with him, and Balak saith to him: 'What hath Jehovah spoken?' ");
INSERT INTO engylt_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","And he taketh up his simile, and saith: 'Rise, Balak, and hear; Give ear unto me, son of Zippor! ");
INSERT INTO engylt_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man — and lieth, And a son of man — and repenteth! Hath He said — and doth He not do it? And spoken — and doth He not confirm it? ");
INSERT INTO engylt_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Lo, to bless I have received: Yea, He blesseth, and I can not reverse it. ");
INSERT INTO engylt_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He hath not beheld iniquity in Jacob, Nor hath He seen perverseness in Israel; Jehovah his God is with him, And a shout of a king is in him. ");
INSERT INTO engylt_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God is bringing them out from Egypt, As the swiftness of a Reem is to him; ");
INSERT INTO engylt_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","For no enchantment is against Jacob, Nor divination against Israel, At the time it is said of Jacob and Israel, What hath God wrought! ");
INSERT INTO engylt_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Lo, the people as a lioness riseth, And as a lion he lifteth himself up, He lieth not down till he eateth prey, And blood of pierced ones doth drink.' ");
INSERT INTO engylt_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","And Balak saith unto Balaam, 'Neither pierce it at all, nor bless it at all;' ");
INSERT INTO engylt_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","and Balaam answereth and saith unto Balak, 'Have I not spoken unto thee, saying, All that Jehovah speaketh — it I do?' ");
INSERT INTO engylt_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","And Balak saith unto Balaam, 'Come, I pray thee, I take thee unto another place; it may be it is right in the eyes of God — to pierce it for me from thence.' ");
INSERT INTO engylt_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","And Balak taketh Balaam to the top of Peor, which is looking on the front of the wilderness, ");
INSERT INTO engylt_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","and Balaam saith unto Balak, 'Build for me in this place seven altars, and make ready for me in this place seven bullocks and seven rams;' ");
INSERT INTO engylt_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","and Balak doth as Balaam said, and he offereth a bullock and a ram on an altar. ");
INSERT INTO engylt_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","And Balaam seeth that it is good in the eyes of Jehovah to bless Israel, and he hath not gone as time by time to meet enchantments, and he setteth towards the wilderness his face; ");
INSERT INTO engylt_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","and Balaam lifteth up his eyes, and seeth Israel tabernacling, by its tribes, and the Spirit of God is upon him, ");
INSERT INTO engylt_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","and he taketh up his simile, and saith: 'An affirmation of Balaam son of Beor — And an affirmation of the man whose eyes are shut — ");
INSERT INTO engylt_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","An affirmation of him who is hearing sayings of God — Who a vision of the Almighty seeth, Falling — and eyes uncovered: ");
INSERT INTO engylt_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How good have been thy tents, O Jacob, Thy tabernacles, O Israel; ");
INSERT INTO engylt_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","As valleys they have been stretched out, As gardens by a river; As aloes Jehovah hath planted, As cedars by waters; ");
INSERT INTO engylt_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","He maketh water flow from his buckets, And his seed is in many waters; And higher than Agag is his king, And exalted is his kingdom. ");
INSERT INTO engylt_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God is bringing him out of Egypt; As the swiftness of a Reem is to him, He eateth up nations his adversaries, And their bones he breaketh, And with his arrows he smiteth, ");
INSERT INTO engylt_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He hath bent, he hath lain down as a lion, And as a lioness: who doth raise him up? He who is blessing thee is blessed, And he who is cursing thee is cursed.' ");
INSERT INTO engylt_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","And the anger of Balak burneth against Balaam, and he striketh his hands; and Balak saith unto Balaam, 'To pierce mine enemies I called thee, and lo, thou hast certainly blessed — these three times; ");
INSERT INTO engylt_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","and now, flee for thyself unto thy place; I have said, I do greatly honour thee, and lo, Jehovah hath kept thee back from honour.' ");
INSERT INTO engylt_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","And Balaam saith unto Balak, 'Did I not also unto thy messengers whom thou hast sent unto me, speak, saying, ");
INSERT INTO engylt_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","If Balak doth give to me the fulness of his house of silver and gold, I am not able to pass over the command of Jehovah, to do good or evil of mine own heart — that which Jehovah speaketh — it I speak? ");
INSERT INTO engylt_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","and, now, lo, I am going to my people; come, I counsel thee concerning that which this people doth to thy people, in the latter end of the days.' ");
INSERT INTO engylt_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","And he taketh up his simile, and saith: 'An affirmation of Balaam son of Beor — And an affirmation of the man whose eyes are shut — ");
INSERT INTO engylt_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","An affirmation of him who is hearing sayings of God — And knowing knowledge of the Most High; A vision of the Almighty he seeth, Falling — and eyes uncovered: ");
INSERT INTO engylt_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see it, but not now; I behold it, but not near; A star hath proceeded from Jacob, And a sceptre hath risen from Israel, And hath smitten corners of Moab, And hath destroyed all sons of Sheth. ");
INSERT INTO engylt_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","And Edom hath been a possession, And Seir hath been a possession, for its enemies, And Israel is doing valiantly; ");
INSERT INTO engylt_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","And one doth rule out of Jacob, And hath destroyed a remnant from Ar.' ");
INSERT INTO engylt_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","And he seeth Amalek, and taketh up his simile, and saith: 'A beginning of the Goyim is Amalek; And his latter end — for ever he perisheth.' ");
INSERT INTO engylt_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","And he seeth the Kenite, and taketh up his simile, and saith: 'Enduring is thy dwelling, And setting in a rock thy nest, ");
INSERT INTO engylt_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","But the Kenite is for a burning; Till when doth Asshur keep thee captive?' ");
INSERT INTO engylt_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","And he taketh up his simile, and saith: 'Alas! who doth live when God doth this? ");
INSERT INTO engylt_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","And — ships are from the side of Chittim, And they have humbled Asshur, And they have humbled Eber, And it also for ever is perishing.' ");
INSERT INTO engylt_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","And Balaam riseth, and goeth, and turneth back to his place, and Balak also hath gone on his way. ");
INSERT INTO engylt_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","And Israel dwelleth in Shittim, and the people begin to go a-whoring unto daughters of Moab, ");
INSERT INTO engylt_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","and they call for the people to the sacrifices of their gods, and the people eat, and bow themselves to their gods, ");
INSERT INTO engylt_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","and Israel is joined to Baal-Peor, and the anger of Jehovah burneth against Israel. ");
INSERT INTO engylt_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","And Jehovah saith unto Moses, 'Take all the chiefs of the people, and hang them before Jehovah — over-against the sun; and the fierceness of the anger of Jehovah doth turn back from Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","And Moses saith unto the judges of Israel, 'Slay ye each his men who are joined to Baal-Peor.' ");
INSERT INTO engylt_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","And lo, a man of the sons of Israel hath come, and bringeth in unto his brethren the Midianitess, before the eyes of Moses, and before the eyes of all the company of the sons of Israel, who are weeping at the opening of the tent of meeting; ");
INSERT INTO engylt_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","and Phinehas, son of Eleazar, son of Aaron, the priest, seeth, and riseth from the midst of the company, and taketh a javelin in his hand, ");
INSERT INTO engylt_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","and goeth in after the man of Israel unto the hollow place, and pierceth them both, the man of Israel and the woman — unto her belly, and the plague is restrained from the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","and the dead by the plague are four and twenty thousand. ");
INSERT INTO engylt_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","'Phinehas, son of Eleazar, son of Aaron the priest, hath turned back My fury from the sons of Israel, by his being zealous with My zeal in their midst, and I have not consumed the sons of Israel in My zeal. ");
INSERT INTO engylt_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","'Therefore say, Lo, I am giving to him My covenant of peace, ");
INSERT INTO engylt_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","and it hath been to him and to his seed after him a covenant of a priesthood age-during, because that he hath been zealous for his God, and doth make atonement for the sons of Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","And the name of the man of Israel who is smitten, who hath been smitten with the Midianitess, is Zimri son of Salu, prince of the house of a father of the Simeonite; ");
INSERT INTO engylt_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","and the name of the woman who is smitten, the Midianitess, is Cozbi daughter of Zur, head of a people — of the house of a father in Midian is he. ");
INSERT INTO engylt_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","'Distress the Midianites, and ye have smitten them, ");
INSERT INTO engylt_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","for they are adversaries to you with their frauds, with which they have acted fraudulently to you, concerning the matter of Peor, and concerning the matter of Cozbi, daughter of a prince of Midian, their sister, who is smitten in the day of the plague for the matter of Peor.' ");
INSERT INTO engylt_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","And it cometh to pass, after the plague, that Jehovah speaketh unto Moses, and unto Eleazar son of Aaron the priest, saying, ");
INSERT INTO engylt_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","'Take up the sum of all the company of the sons of Israel, from a son of twenty years and upward, by the house of their fathers, every one going out to the host in Israel.' ");
INSERT INTO engylt_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","And Moses speaketh — Eleazar the priest also — with them, in the plains of Moab, by Jordan, near Jericho, saying, ");
INSERT INTO engylt_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","'From a son of twenty years and upward,' as Jehovah hath commanded Moses and the sons of Israel who are coming out from the land of Egypt. ");
INSERT INTO engylt_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben, first-born of Israel — sons of Reuben: of Hanoch is the family of the Hanochite; of Pallu the family of the Palluite; ");
INSERT INTO engylt_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","of Hezron the family of the Hezronite; of Carmi the family of the Carmite. ");
INSERT INTO engylt_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These are families of the Reubenite, and their numbered ones are three and forty thousand and seven hundred and thirty. ");
INSERT INTO engylt_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","And the son of Pallu is Eliab; ");
INSERT INTO engylt_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","and the sons of Eliab are Nemuel and Dathan and Abiram; this is that Dathan and Abiram, called ones of the company, who have striven against Moses and against Aaron in the company of Korah, in their striving against Jehovah, ");
INSERT INTO engylt_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","and the earth openeth her mouth, and swalloweth them and Korah, in the death of the company, in the fire consuming the two hundred and fifty men, and they become a sign; ");
INSERT INTO engylt_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","and the sons of Korah died not. ");
INSERT INTO engylt_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Sons of Simeon by their families: of Nemuel is the family of the Nemuelite; of Jamin the family of the Jaminite; of Jachin the family of the Jachinite; ");
INSERT INTO engylt_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","of Zerah the family of the Zarhite; of Shaul the family of the Shaulite. ");
INSERT INTO engylt_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These are families of the Simeonite, two and twenty thousand and two hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Sons of Gad by their families: of Zephon is the family of the Zephonite; of Haggi the family of the Haggite; of Shuni the family of the Shunite; ");
INSERT INTO engylt_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","of Ozni the family of the Oznite; of Eri the family of the Erite: ");
INSERT INTO engylt_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","of Arod the family of the Arodite; of Areli the family of the Arelite. ");
INSERT INTO engylt_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These are families of the sons of Gad, by their numbered ones, forty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Sons of Judah are Er and Onan; and Er dieth — Onan also — in the land of Canaan. ");
INSERT INTO engylt_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","And sons of Judah, by their families, are: of Shelah the family of the Shelanite; of Pharez the family of the Pharzite; of Zerah the family of the Zarhite; ");
INSERT INTO engylt_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","and sons of Pharez are: of Hezron the family of the Hezronite; of Hamul the family of the Hamulite. ");
INSERT INTO engylt_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These are families of Judah, by their numbered ones, six and seventy thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Sons of Issachar by their families; of Tola is the family of the Tolaite; of Pua the family of the Punite; ");
INSERT INTO engylt_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","of Jashub the family of the Jashubite; of Shimron the family of the Shimronite. ");
INSERT INTO engylt_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These are families of Issachar, by their numbered ones, four and sixty thousand and three hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sons of Zebulun by their families: of Sered is the family of the Sardite; of Elon the family of the Elonite; of Jahleel the family of the Jahleelite. ");
INSERT INTO engylt_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These are families of the Zebulunite by their numbered ones, sixty thousand and five hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Sons of Joseph by their families are Manasseh and Ephraim. ");
INSERT INTO engylt_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Sons of Manasseh: of Machir is the family of the Machirite; and Machir hath begotten Gilead; of Gilead is the family of the Gileadite. ");
INSERT INTO engylt_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These are sons of Gilead: of Jeezer is the family of the Jeezerite; of Helek the family of the Helekite; ");
INSERT INTO engylt_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","and of Asriel the family of the Asrielite; and of Shechem the family of the Shechemite; ");
INSERT INTO engylt_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","and of Shemida the family of the Shemidaite; and of Hepher the family of the Hepherite. ");
INSERT INTO engylt_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","And Zelophehad son of Hepher had no sons but daughters, and the names of the daughters of Zelophehad are Mahlah, and Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engylt_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These are families of Manasseh, and their numbered ones are two and fifty thousand and seven hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These are sons of Ephraim by their families: of Shuthelah is the family of the Shuthelhite; of Becher the family of the Bachrite; of Tahan the family of the Tahanite. ");
INSERT INTO engylt_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","And these are sons of Shuthelah: of Eran the family of the Eranite. ");
INSERT INTO engylt_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These are families of the sons of Ephraim, by their numbered ones, two and thirty thousand and five hundred. These are sons of Joseph by their families. ");
INSERT INTO engylt_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Sons of Benjamin by their families: of Bela is the family of the Belaite; of Ashbel the family of the Ashbelite; of Ahiram the family of the Ahiramite; ");
INSERT INTO engylt_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","of Shupham the family of the Shuphamite; of Hupham the family of the Huphamite. ");
INSERT INTO engylt_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","And sons of Bela are Ard and Naaman: of Ard is the family of the Ardite: of Naaman the family of the Naamite. ");
INSERT INTO engylt_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These are sons of Benjamin by their families, and their numbered ones are five and forty thousand and six hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These are sons of Dan by their families: of Shuham is the family of the Shuhamite; these are families of Dan by their families; ");
INSERT INTO engylt_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","all the families of the Shuhamite, by their numbered ones, are four and sixty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Sons of Asher by their families: of Jimna is the family of the Jimnite; of Jesui the family of the Jesuite; of Beriah the family of the Beriite. ");
INSERT INTO engylt_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Of sons of Beriah: of Heber is the family of the Heberite; of Malchiel the family of the Malchielite. ");
INSERT INTO engylt_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","And the name of the daughter of Asher is Sarah. ");
INSERT INTO engylt_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These are families of the sons of Asher, by their numbered ones, three and fifty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Sons of Naphtali by their families: of Jahzeel is the family of the Jahzeelite; of Guni the family of the Gunite; ");
INSERT INTO engylt_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","of Jezer the family of the Jezerite; of Shillem the family of the Shillemite. ");
INSERT INTO engylt_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These are families of Naphtali by their families, and their numbered ones are five and forty thousand and four hundred. ");
INSERT INTO engylt_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","These are numbered ones of the sons of Israel, six hundred thousand, and a thousand, seven hundred and thirty. ");
INSERT INTO engylt_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","'To these is the land apportioned by inheritance, by the number of names; ");
INSERT INTO engylt_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","to the many thou dost increase their inheritance, and to the few thou dost diminish their inheritance; to each according to his numbered ones is given his inheritance. ");
INSERT INTO engylt_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","'Only by lot is the land apportioned, by the names of the tribes of their fathers they inherit; ");
INSERT INTO engylt_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","according to the lot is their inheritance apportioned between many and few.' ");
INSERT INTO engylt_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","And these are numbered ones of the Levite by their families: of Gershon is the family of the Gershonite; of Kohath the family of the Kohathite; of Merari the family of the Merarite. ");
INSERT INTO engylt_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are families of the Levite: the family of the Libnite, the family of the Hebronite, the family of the Mahlite, the family of the Mushite, the family of the Korathite. And Kohath hath begotten Amram, ");
INSERT INTO engylt_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","and the name of Amram's wife is Jochebed, daughter of Levi, whom one hath born to Levi in Egypt; and she beareth to Amram Aaron, and Moses, and Miriam their sister. ");
INSERT INTO engylt_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","And born to Aaron Nadab and Abihu, Eleazar and Ithamar; ");
INSERT INTO engylt_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","and Nadab dieth — Abihu also — in their bringing near strange fire before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","And their numbered ones are three and twenty thousand, every male from a son of a month and upwards, for they have not numbered themselves in the midst of the sons of Israel; for an inheritance hath not been given to them in the midst of the sons of Israel. ");
INSERT INTO engylt_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These are those numbered by Moses and Eleazar the priest, who have numbered the sons of Israel in the plains of Moab, by Jordan, near Jericho; ");
INSERT INTO engylt_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","and among these there hath not been a man of those numbered by Moses, and Aaron the priest, who numbered the sons of Israel in the wilderness of Sinai, ");
INSERT INTO engylt_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","for Jehovah said of them, 'They do certainly die in the wilderness;' and there hath not been left of them a man save Caleb son of Jephunneh, and Joshua son of Nun. ");
INSERT INTO engylt_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","And daughters of Zelophehad son of Hepher, son of Gilead, son of Machir, son of Manasseh, of the families of Manasseh son of Joseph, draw near — and these are the names of his daughters, Mahlah, Noah, and Hoglah, and Milcah, and Tirzah — ");
INSERT INTO engylt_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","and stand before Moses, and before Eleazar the priest, and before the princes, and all the company, at the opening of the tent of meeting, saying: ");
INSERT INTO engylt_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","'Our father died in the wilderness, and he — he was not in the midst of the company who were met together against Jehovah in the company of Korah, but for his own sin he died, and had no sons; ");
INSERT INTO engylt_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","why is the name of our father withdrawn from the midst of his family because he hath no son? give to us a possession in the midst of the brethren of our father;' ");
INSERT INTO engylt_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","and Moses bringeth near their cause before Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","'Rightly are the daughters of Zelophehad speaking; thou dost certainly give to them a possession of an inheritance in the midst of their father's brethren, and hast caused to pass over the inheritance of their father to them. ");
INSERT INTO engylt_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","'And unto the sons of Israel thou dost speak, saying, When a man dieth, and hath no son, then ye have caused his inheritance to pass over to his daughter; ");
INSERT INTO engylt_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","and if he have no daughter, then ye have given his inheritance to his brethren; ");
INSERT INTO engylt_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","and if he have no brethren, then ye have given his inheritance to his father's brethren; ");
INSERT INTO engylt_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","and if his father have no brethren, then ye have given his inheritance to his relation who is near unto him of his family, and he hath possessed it;' and it hath been to the sons of Israel for a statute of judgment, as Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","And Jehovah saith unto Moses, 'Go up unto this mount Abarim, and see the land which I have given to the sons of Israel; ");
INSERT INTO engylt_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","and thou hast seen it, and thou hast been gathered unto thy people, also thou, as Aaron thy brother hath been gathered, ");
INSERT INTO engylt_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","because ye provoked My mouth in the wilderness of Zin, in the strife of the company — to sanctify Me at the waters before their eyes;' they are waters of Meribah, in Kadesh, in the wilderness of Zin. ");
INSERT INTO engylt_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","And Moses speaketh unto Jehovah, saying, ");
INSERT INTO engylt_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","'Jehovah — God of the spirits of all flesh — appoint a man over the company, ");
INSERT INTO engylt_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","who goeth out before them, and who cometh in before them, and who taketh them out, and who bringeth them in, and the company of Jehovah is not as sheep which have no shepherd.' ");
INSERT INTO engylt_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","And Jehovah saith unto Moses, 'Take to thee Joshua son of Nun, a man in whom is the Spirit, and thou hast laid thine hand upon him, ");
INSERT INTO engylt_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","and hast caused him to stand before Eleazar the priest, and before all the company, and hast charged him before their eyes, ");
INSERT INTO engylt_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","and hast put of thine honour upon him, so that all the company of the sons of Israel do hearken. ");
INSERT INTO engylt_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","'And before Eleazar the priest he standeth, and he hath asked for him by the judgment of the Lights before Jehovah; at His word they go out, and at His word they come in; he, and all the sons of Israel with him, even all the company.' ");
INSERT INTO engylt_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","And Moses doth as Jehovah hath commanded him, and taketh Joshua, and causeth him to stand before Eleazar the priest, and before all the company, ");
INSERT INTO engylt_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","and layeth his hands upon him, and chargeth him, as Jehovah hath spoken by the hand of Moses. ");
INSERT INTO engylt_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","'Command the sons of Israel, and thou hast said unto them, My offering, My bread for My fire-offerings, My sweet fragrance, ye take heed to bring near to Me in its appointed season. ");
INSERT INTO engylt_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","'And thou hast said to them, This is the fire-offering which ye bring near to Jehovah: two lambs, sons of a year, perfect ones, daily, a continual burnt-offering; ");
INSERT INTO engylt_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","the one lamb thou preparest in the morning, and the second lamb thou preparest between the evenings; ");
INSERT INTO engylt_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","and a tenth of the ephah of flour for a present, mixed with beaten oil, a fourth of the hin; ");
INSERT INTO engylt_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","a continual burnt-offering, which was made in mount Sinai, for sweet fragrance, a fire-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","and its libation, a fourth of the hin for the one lamb; in the sanctuary cause thou a libation of strong drink to be poured out to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","'And the second lamb thou dost prepare between the evenings; as the present of the morning, and as its libation thou preparest — a fire-offering, a sweet fragrance to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","'And on the sabbath-day, two lambs, sons of a year, perfect ones, and two-tenth deals of flour, a present, mixed with oil, and its libation; ");
INSERT INTO engylt_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","the burnt-offering of the sabbath in its sabbath, besides the continual burnt-offering and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","'And in the beginnings of your months ye bring near a burnt-offering to Jehovah: two bullocks, sons of the herd, and one ram, seven lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","and three-tenth deals of flour, a present, mixed with oil, for the one bullock, and two-tenth deals of flour, a present, mixed with oil, for the one ram; ");
INSERT INTO engylt_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","and a several tenth deal of flour, a present, mixed with oil, for the one lamb; a burnt-offering, a sweet fragrance, a fire-offering to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","and their libations are a half of the hin to a bullock, and a third of the hin to a ram, and a fourth of the hin to a lamb, of wine; this is the burnt-offering of every month for the months of the year; ");
INSERT INTO engylt_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","and one kid of the goats for a sin-offering to Jehovah; besides the continual burnt-offering it is prepared, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","'And in the first month, in the fourteenth day of the month, is the passover to Jehovah; ");
INSERT INTO engylt_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","and in the fifteenth day of this month is a festival, seven days unleavened food is eaten; ");
INSERT INTO engylt_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","in the first day is an holy convocation, ye do no servile work, ");
INSERT INTO engylt_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","and ye have brought near a fire-offering, a burnt-offering to Jehovah: two bullocks, sons of the herd, and one ram, and seven lambs, sons of a year, perfect ones they are for you; ");
INSERT INTO engylt_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","and their present, flour mixed with oil, three-tenth deals for a bullock, and two-tenth deals for a ram ye do prepare; ");
INSERT INTO engylt_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","a several tenth deal thou preparest for the one lamb, for the seven lambs, ");
INSERT INTO engylt_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","and one goat, a sin-offering, to make atonement for you. ");
INSERT INTO engylt_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","'Apart from the burnt-offering of the morning, which is for the continual burnt-offering, ye prepare these; ");
INSERT INTO engylt_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","according to these ye prepare daily, seven days, bread of a fire-offering, a sweet fragrance, to Jehovah; besides the continual burnt-offering it is prepared, and its libation; ");
INSERT INTO engylt_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","and on the seventh day a holy convocation ye have, ye do no servile work. ");
INSERT INTO engylt_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","'And in the day of the first-fruits, in your bringing near a new present to Jehovah, in your weeks, a holy convocation ye have; ye do no servile work; ");
INSERT INTO engylt_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","and ye have brought near a burnt-offering for sweet fragrance to Jehovah: two bullocks, sons of the herd, one ram, seven lambs, sons of a year, ");
INSERT INTO engylt_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","and their present, flour mixed with oil, three-tenth deals to the one bullock, two-tenth deals to the one ram, ");
INSERT INTO engylt_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","a several tenth deal to the one lamb, for the seven lambs; ");
INSERT INTO engylt_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","one kid of the goats to make atonement for you; ");
INSERT INTO engylt_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","apart from the continual burnt-offering and its present ye prepare them (perfect ones they are for you) and their libations. ");
INSERT INTO engylt_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","'And in the seventh month, in the first of the month, a holy convocation ye have, ye do no servile work; a day of shouting it is to you; ");
INSERT INTO engylt_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","and ye have prepared a burnt-offering, for sweet fragrance to Jehovah: one bullock, a son of the herd, one ram, seven lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","and their present, flour mixed with oil, three-tenth deals for the bullock, two-tenth deals for the ram, ");
INSERT INTO engylt_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and one-tenth deal for the one lamb, for the seven lambs; ");
INSERT INTO engylt_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","and one kid of the goats, a sin-offering, to make atonement for you; ");
INSERT INTO engylt_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","apart from the burnt-offering of the month, and its present, and the continual burnt-offering, and its present, and their libations, according to their ordinance, for sweet fragrance, a fire-offering to Jehovah. ");
INSERT INTO engylt_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","'And on the tenth of this seventh month a holy convocation ye have, and ye have humbled your souls; ye do no work; ");
INSERT INTO engylt_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","and ye have brought near a burnt-offering to Jehovah, a sweet fragrance, one bullock, a son of the herd, one ram, seven lambs, sons of a year, perfect ones they are for you, ");
INSERT INTO engylt_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","and their present, flour mixed with oil, three-tenth deals for the bullock, two-tenth deals for the one ram, ");
INSERT INTO engylt_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","a several tenth deal for the one lamb, for the seven lambs, ");
INSERT INTO engylt_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","one kid of the goats, a sin-offering; apart from the sin-offering of the atonements, and the continual burnt-offering, and its present, and their libations. ");
INSERT INTO engylt_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","'And on the fifteenth day of the seventh month a holy convocation ye have; ye do no servile work; and ye have celebrated a festival to Jehovah seven days, ");
INSERT INTO engylt_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","and have brought near a burnt-offering, a fire-offering, a sweet fragrance, to Jehovah; thirteen bullocks, sons of the herd, two rams, fourteen lambs, sons of a year; perfect ones they are; ");
INSERT INTO engylt_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","and their present, flour mixed with oil, three-tenth deals to the one bullock, for the thirteen bullocks, two-tenth deals to the one ram, for the two rams, ");
INSERT INTO engylt_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and a several tenth deal to the one lamb, for the fourteen lambs, ");
INSERT INTO engylt_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","and one kid of the goats, a sin-offering; apart from the continual burnt-offering, its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","'And on the second day twelve bullocks, sons of the herd, two rams, fourteen lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","and their present, and their libations, for the bullocks, for the rams, and for the sheep, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","and one kid of the goats, a sin-offering; apart from the continual burnt-offering, and its present, and their libations. ");
INSERT INTO engylt_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","'And on the third day eleven bullocks, two rams, fourteen lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","and their present, and their libations, for the bullocks, for the rams, and for the lambs, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","and one goat, a sin-offering; apart from the continual burnt-offering, and its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","'And on the fourth day ten bullocks, two rams, fourteen lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","their present, and their libations, for the bullocks, for the rams, and for the lambs, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","and one kid of the goats, a sin-offering, apart from the continual burnt-offering, its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","'And on the fifth day nine bullocks, two rams, fourteen lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","and their present, and their libations, for the bullocks, for the rams, and for the lambs, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","and one goat, a sin-offering; apart from the continual burnt-offering, and its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","'And on the sixth day eight bullocks, two rams, fourteen lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","and their present, and their libations, for the bullocks, for the rams, and for the lambs, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","and one goat, a sin-offering; apart from the continual burnt-offering, its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","'And on the seventh day seven bullocks, two rams, fourteen lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","and their present, and their libations, for the bullocks, for the rams, and for the lambs, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","and one goat, a sin-offering; apart from the continual burnt-offering, its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","'On the eighth day a restraint ye have, ye do no servile work; ");
INSERT INTO engylt_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","and ye have brought near a burnt-offering, a fire-offering, a sweet fragrance, to Jehovah; one bullock, one ram, seven lambs, sons of a year, perfect ones; ");
INSERT INTO engylt_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","their present, and their libations, for the bullock, for the ram, and for the lambs, in their number, according to the ordinance; ");
INSERT INTO engylt_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","and one goat, a sin-offering; apart from the continual burnt-offering, and its present, and its libation. ");
INSERT INTO engylt_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","'These ye prepare to Jehovah in your appointed seasons, apart from your vows, and your free-will offerings, for your burnt-offerings, and for your presents, and for your libations, and for your peace-offerings.' ");
INSERT INTO engylt_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","And Moses saith unto the sons of Israel according to all that Jehovah hath commanded Moses. ");
INSERT INTO engylt_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","And Moses speaketh unto the heads of the tribes of the sons of Israel, saying, 'This is the thing which Jehovah hath commanded: ");
INSERT INTO engylt_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","'When a man voweth a vow to Jehovah, or hath sworn an oath to bind a bond on his soul, he doth not pollute his word; according to all that is going out from his mouth he doth. ");
INSERT INTO engylt_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","'And when a woman voweth a vow to Jehovah, and hath bound a bond in the house of her father in her youth, ");
INSERT INTO engylt_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","and her father hath heard her vow, and her bond which she hath bound on her soul, and her father hath kept silent at her, then have all her vows been established, and every bond which she hath bound on her soul is established. ");
INSERT INTO engylt_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","'And if her father hath disallowed her in the day of his hearing, none of her vows and her bonds which she hath bound on her soul is established, and Jehovah is propitious to her, for her father hath disallowed her. ");
INSERT INTO engylt_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","'And if she be at all to a husband, and her vows are on her, or a wrongful utterance on her lips, which she hath bound on her soul, ");
INSERT INTO engylt_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","and her husband hath heard, and in the day of his hearing, he hath kept silent at her, then have her vows been established, and her bonds which she hath bound on her soul are established. ");
INSERT INTO engylt_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","'And if in the day of her husband's hearing he disalloweth her, then he hath broken her vow which is on her, and the wrongful utterance of her lips which she hath bound on her soul, and Jehovah is propitious to her. ");
INSERT INTO engylt_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","'As to the vow of a widow or cast-out woman, all that she hath bound on her soul is established on her. ");
INSERT INTO engylt_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","'And if in the house of her husband she hath vowed, or hath bound a bond on her soul with an oath, ");
INSERT INTO engylt_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","and her husband hath heard, and hath kept silent at her — he hath not disallowed her — then have all her vows been established, and every bond which she hath bound on her soul is established. ");
INSERT INTO engylt_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","'And if her husband doth certainly break them in the day of his hearing, none of the outgoing of her lips concerning her vows, or concerning the bond of her soul, is established — her husband hath broken them — and Jehovah is propitious to her. ");
INSERT INTO engylt_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","'Every vow and every oath — a bond to humble a soul — her husband doth establish it, or her husband doth break it; ");
INSERT INTO engylt_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","and if her husband certainly keep silent at her, from day unto day, then he hath established all her vows, or all her bonds which are upon her; he hath established them, for he hath kept silent at her in the day of his hearing; ");
INSERT INTO engylt_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","and if he doth at all break them after his hearing, then he hath borne her iniquity.' ");
INSERT INTO engylt_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the statutes which Jehovah hath commanded Moses between a man and his wife, between a father and his daughter, in her youth, in the house of her father. ");
INSERT INTO engylt_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","And Jehovah speaketh unto Moses, saying, ");
INSERT INTO engylt_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","'Execute the vengeance of the sons of Israel against the Midianites — afterwards thou art gathered unto thy people.' ");
INSERT INTO engylt_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","And Moses speaketh unto the people, saying, 'Be ye armed some of you for the host, and they are against Midian, to put the vengeance of Jehovah on Midian; ");
INSERT INTO engylt_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","a thousand for a tribe — a thousand for a tribe, to all the tribes of Israel — ye do send to the host.' ");
INSERT INTO engylt_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","And there are given out of the thousands of Israel a thousand for a tribe, twelve thousand armed ones of the host; ");
INSERT INTO engylt_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","and Moses sendeth them, a thousand for a tribe, to the host, them and Phinehas son of Eleazar the priest, to the host; and the holy vessels, and the trumpets of the shouting, in his hand. ");
INSERT INTO engylt_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","And they war against Midian, as Jehovah hath commanded Moses, and slay every male; ");
INSERT INTO engylt_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","and the kings of Midian they have slain, besides their pierced ones, Evi, and Rekem, and Zur, and Hur, and Reba, five kings of Midian; and Balaam son of Beor, they have slain with the sword. ");
INSERT INTO engylt_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","And the sons of Israel take captive the women of Midian, and their infants; and all their cattle, and all their substance, and all their wealth they have plundered; ");
INSERT INTO engylt_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","and all their cities, with their habitations, and all their towers, they have burnt with fire. ");
INSERT INTO engylt_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","And they take all the spoil, and all the prey, among man and among beast; ");
INSERT INTO engylt_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","and they bring in, unto Moses, and unto Eleazar the priest, and unto the company of the sons of Israel, the captives, and the prey, and the spoil, unto the camp, unto the plains of Moab, which are by Jordan, near Jericho. ");
INSERT INTO engylt_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","And Moses, and Eleazar the priest, and all the princes of the company, go out to meet them, unto the outside of the camp, ");
INSERT INTO engylt_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","and Moses is wroth against the inspectors of the force, chiefs of the thousands, and chiefs of the hundreds, who are coming in from the host of the battle. ");
INSERT INTO engylt_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","And Moses saith unto them, 'Have ye kept alive every female? ");
INSERT INTO engylt_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","lo, they — they have been to the sons of Israel, through the word of Balaam, to cause 