﻿USE sofia;
DROP TABLE IF EXISTS sofia.engwebpb_vpl;
CREATE TABLE engwebpb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engwebpb_vpl WRITE;
INSERT INTO engwebpb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the beginning, God created the heavens and the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","The earth was formless and empty. Darkness was on the surface of the deep and God’s Spirit was hovering over the surface of the waters. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “Let there be light,” and there was light. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God saw the light, and saw that it was good. God divided the light from the darkness. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God called the light “day”, and the darkness he called “night”. There was evening and there was morning, the first day. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God said, “Let there be an expanse in the middle of the waters, and let it divide the waters from the waters.” ");
INSERT INTO engwebpb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","God made the expanse, and divided the waters which were under the expanse from the waters which were above the expanse; and it was so. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God called the expanse “sky”. There was evening and there was morning, a second day. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","God said, “Let the waters under the sky be gathered together to one place, and let the dry land appear;” and it was so. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God called the dry land “earth”, and the gathering together of the waters he called “seas”. God saw that it was good. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","God said, “Let the earth yield grass, herbs yielding seeds, and fruit trees bearing fruit after their kind, with their seeds in it, on the earth;” and it was so. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","The earth yielded grass, herbs yielding seed after their kind, and trees bearing fruit, with their seeds in it, after their kind; and God saw that it was good. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","There was evening and there was morning, a third day. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God said, “Let there be lights in the expanse of the sky to divide the day from the night; and let them be for signs to mark seasons, days, and years; ");
INSERT INTO engwebpb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","and let them be for lights in the expanse of the sky to give light on the earth;” and it was so. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God made the two great lights: the greater light to rule the day, and the lesser light to rule the night. He also made the stars. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God set them in the expanse of the sky to give light to the earth, ");
INSERT INTO engwebpb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","and to rule over the day and over the night, and to divide the light from the darkness. God saw that it was good. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","There was evening and there was morning, a fourth day. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God said, “Let the waters abound with living creatures, and let birds fly above the earth in the open expanse of the sky.” ");
INSERT INTO engwebpb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","God created the large sea creatures and every living creature that moves, with which the waters swarmed, after their kind, and every winged bird after its kind. God saw that it was good. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God blessed them, saying, “Be fruitful, and multiply, and fill the waters in the seas, and let birds multiply on the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","There was evening and there was morning, a fifth day. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God said, “Let the earth produce living creatures after their kind, livestock, creeping things, and animals of the earth after their kind;” and it was so. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made the animals of the earth after their kind, and the livestock after their kind, and everything that creeps on the ground after its kind. God saw that it was good. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","God said, “Let’s make man in our image, after our likeness. Let them have dominion over the fish of the sea, and over the birds of the sky, and over the livestock, and over all the earth, and over every creeping thing that creeps on the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","God created man in his own image. In God’s image he created him; male and female he created them. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them. God said to them, “Be fruitful, multiply, fill the earth, and subdue it. Have dominion over the fish of the sea, over the birds of the sky, and over every living thing that moves on the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God said, “Behold, I have given you every herb yielding seed, which is on the surface of all the earth, and every tree, which bears fruit yielding seed. It will be your food. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","To every animal of the earth, and to every bird of the sky, and to everything that creeps on the earth, in which there is life, I have given every green herb for food;” and it was so. ");
INSERT INTO engwebpb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God saw everything that he had made, and, behold, it was very good. There was evening and there was morning, a sixth day. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","The heavens, the earth, and all their vast array were finished. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","On the seventh day God finished his work which he had done; and he rested on the seventh day from all his work which he had done. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God blessed the seventh day, and made it holy, because he rested in it from all his work of creation which he had done. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","This is the history of the generations of the heavens and of the earth when they were created, in the day that the LORD God made the earth and the heavens. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","No plant of the field was yet in the earth, and no herb of the field had yet sprung up; for the LORD God had not caused it to rain on the earth. There was not a man to till the ground, ");
INSERT INTO engwebpb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","but a mist went up from the earth, and watered the whole surface of the ground. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","The LORD God formed man from the dust of the ground, and breathed into his nostrils the breath of life; and man became a living soul. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","The LORD God planted a garden eastward, in Eden, and there he put the man whom he had formed. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Out of the ground the LORD God made every tree to grow that is pleasant to the sight, and good for food, including the tree of life in the middle of the garden and the tree of the knowledge of good and evil. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A river went out of Eden to water the garden; and from there it was parted, and became the source of four rivers. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first is Pishon: it flows through the whole land of Havilah, where there is gold; ");
INSERT INTO engwebpb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","and the gold of that land is good. Bdellium and onyx stone are also there. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The name of the second river is Gihon. It is the same river that flows through the whole land of Cush. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The name of the third river is Hiddekel. This is the one which flows in front of Assyria. The fourth river is the Euphrates. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","The LORD God took the man, and put him into the garden of Eden to cultivate and keep it. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","The LORD God commanded the man, saying, “You may freely eat of every tree of the garden; ");
INSERT INTO engwebpb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","but you shall not eat of the tree of the knowledge of good and evil; for in the day that you eat of it, you will surely die.” ");
INSERT INTO engwebpb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","The LORD God said, “It is not good for the man to be alone. I will make him a helper comparable to him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Out of the ground the LORD God formed every animal of the field, and every bird of the sky, and brought them to the man to see what he would call them. Whatever the man called every living creature became its name. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","The man gave names to all livestock, and to the birds of the sky, and to every animal of the field; but for man there was not found a helper comparable to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","The LORD God caused the man to fall into a deep sleep. As the man slept, he took one of his ribs, and closed up the flesh in its place. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","The LORD God made a woman from the rib which he had taken from the man, and brought her to the man. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","The man said, “This is now bone of my bones, and flesh of my flesh. She will be called ‘woman,’ because she was taken out of Man.” ");
INSERT INTO engwebpb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Therefore a man will leave his father and his mother, and will join with his wife, and they will be one flesh. ");
INSERT INTO engwebpb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","The man and his wife were both naked, and they were not ashamed. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Now the serpent was more subtle than any animal of the field which the LORD God had made. He said to the woman, “Has God really said, ‘You shall not eat of any tree of the garden’?” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman said to the serpent, “We may eat fruit from the trees of the garden, ");
INSERT INTO engwebpb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","but not the fruit of the tree which is in the middle of the garden. God has said, ‘You shall not eat of it. You shall not touch it, lest you die.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","The serpent said to the woman, “You won’t really die, ");
INSERT INTO engwebpb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","for God knows that in the day you eat it, your eyes will be opened, and you will be like God, knowing good and evil.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","When the woman saw that the tree was good for food, and that it was a delight to the eyes, and that the tree was to be desired to make one wise, she took some of its fruit, and ate. Then she gave some to her husband with her, and he ate it, too. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Their eyes were opened, and they both knew that they were naked. They sewed fig leaves together, and made coverings for themselves. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","They heard the LORD God’s voice walking in the garden in the cool of the day, and the man and his wife hid themselves from the presence of the LORD God amongst the trees of the garden. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","The LORD God called to the man, and said to him, “Where are you?” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","The man said, “I heard your voice in the garden, and I was afraid, because I was naked; so I hid myself.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God said, “Who told you that you were naked? Have you eaten from the tree that I commanded you not to eat from?” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said, “The woman whom you gave to be with me, she gave me fruit from the tree, and I ate it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","The LORD God said to the woman, “What have you done?” The woman said, “The serpent deceived me, and I ate.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","The LORD God said to the serpent, “Because you have done this, you are cursed above all livestock, and above every animal of the field. You shall go on your belly and you shall eat dust all the days of your life. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I will put hostility between you and the woman, and between your offspring and her offspring. He will bruise your head, and you will bruise his heel.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","To the woman he said, “I will greatly multiply your pain in childbirth. You will bear children in pain. Your desire will be for your husband, and he will rule over you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","To Adam he said, “Because you have listened to your wife’s voice, and have eaten from the tree, about which I commanded you, saying, ‘You shall not eat of it,’ the ground is cursed for your sake. You will eat from it with much labour all the days of your life. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","It will yield thorns and thistles to you; and you will eat the herb of the field. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","You will eat bread by the sweat of your face until you return to the ground, for you were taken out of it. For you are dust, and you shall return to dust.” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","The man called his wife Eve because she would be the mother of all the living. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","The LORD God made garments of animal skins for Adam and for his wife, and clothed them. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","The LORD God said, “Behold, the man has become like one of us, knowing good and evil. Now, lest he reach out his hand, and also take of the tree of life, and eat, and live forever—” ");
INSERT INTO engwebpb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Therefore the LORD God sent him out from the garden of Eden, to till the ground from which he was taken. ");
INSERT INTO engwebpb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","So he drove out the man; and he placed cherubim at the east of the garden of Eden, and a flaming sword which turned every way, to guard the way to the tree of life. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","The man knew Eve his wife. She conceived, and gave birth to Cain, and said, “I have gotten a man with the LORD’s help.” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Again she gave birth, to Cain’s brother Abel. Abel was a keeper of sheep, but Cain was a tiller of the ground. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","As time passed, Cain brought an offering to the LORD from the fruit of the ground. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel also brought some of the firstborn of his flock and of its fat. The LORD respected Abel and his offering, ");
INSERT INTO engwebpb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but he didn’t respect Cain and his offering. Cain was very angry, and the expression on his face fell. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","The LORD said to Cain, “Why are you angry? Why has the expression of your face fallen? ");
INSERT INTO engwebpb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you do well, won’t it be lifted up? If you don’t do well, sin crouches at the door. Its desire is for you, but you are to rule over it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain said to Abel, his brother, “Let’s go into the field.” While they were in the field, Cain rose up against Abel, his brother, and killed him. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","The LORD said to Cain, “Where is Abel, your brother?” He said, “I don’t know. Am I my brother’s keeper?” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","The LORD said, “What have you done? The voice of your brother’s blood cries to me from the ground. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Now you are cursed because of the ground, which has opened its mouth to receive your brother’s blood from your hand. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","From now on, when you till the ground, it won’t yield its strength to you. You will be a fugitive and a wanderer in the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain said to the LORD, “My punishment is greater than I can bear. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Behold, you have driven me out today from the surface of the ground. I will be hidden from your face, and I will be a fugitive and a wanderer in the earth. Whoever finds me will kill me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","The LORD said to him, “Therefore whoever slays Cain, vengeance will be taken on him sevenfold.” The LORD appointed a sign for Cain, so that anyone finding him would not strike him. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Cain left the LORD’s presence, and lived in the land of Nod, east of Eden. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain knew his wife. She conceived, and gave birth to Enoch. He built a city, and named the city after the name of his son, Enoch. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Irad was born to Enoch. Irad became the father of Mehujael. Mehujael became the father of Methushael. Methushael became the father of Lamech. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech took two wives: the name of the first one was Adah, and the name of the second one was Zillah. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah gave birth to Jabal, who was the father of those who dwell in tents and have livestock. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","His brother’s name was Jubal, who was the father of all who handle the harp and pipe. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah also gave birth to Tubal Cain, the forger of every cutting instrument of bronze and iron. Tubal Cain’s sister was Naamah. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech said to his wives, “Adah and Zillah, hear my voice. You wives of Lamech, listen to my speech, for I have slain a man for wounding me, a young man for bruising me. ");
INSERT INTO engwebpb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If Cain will be avenged seven times, truly Lamech seventy-seven times.” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam knew his wife again. She gave birth to a son, and named him Seth, saying, “for God has given me another child instead of Abel, for Cain killed him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","A son was also born to Seth, and he named him Enosh. At that time men began to call on the LORD’s name. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the book of the generations of Adam. In the day that God created man, he made him in God’s likeness. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","He created them male and female, and blessed them. On the day they were created, he named them Adam. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam lived one hundred and thirty years, and became the father of a son in his own likeness, after his image, and named him Seth. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","The days of Adam after he became the father of Seth were eight hundred years, and he became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","All the days that Adam lived were nine hundred and thirty years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth lived one hundred and five years, then became the father of Enosh. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth lived after he became the father of Enosh eight hundred and seven years, and became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","All of the days of Seth were nine hundred and twelve years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh lived ninety years, and became the father of Kenan. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh lived after he became the father of Kenan eight hundred and fifteen years, and became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","All of the days of Enosh were nine hundred and five years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan lived seventy years, then became the father of Mahalalel. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan lived after he became the father of Mahalalel eight hundred and forty years, and became the father of other sons and daughters ");
INSERT INTO engwebpb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","and all of the days of Kenan were nine hundred and ten years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel lived sixty-five years, then became the father of Jared. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel lived after he became the father of Jared eight hundred and thirty years, and became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","All of the days of Mahalalel were eight hundred and ninety-five years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared lived one hundred and sixty-two years, then became the father of Enoch. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared lived after he became the father of Enoch eight hundred years, and became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","All of the days of Jared were nine hundred and sixty-two years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoch lived sixty-five years, then became the father of Methuselah. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","After Methuselah’s birth, Enoch walked with God for three hundred years, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","All the days of Enoch were three hundred and sixty-five years. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoch walked with God, and he was not found, for God took him. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah lived one hundred and eighty-seven years, then became the father of Lamech. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Methuselah lived after he became the father of Lamech seven hundred and eighty-two years, and became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","All the days of Methuselah were nine hundred and sixty-nine years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech lived one hundred and eighty-two years, then became the father of a son. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","He named him Noah, saying, “This one will comfort us in our work and in the toil of our hands, caused by the ground which the LORD has cursed.” ");
INSERT INTO engwebpb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamech lived after he became the father of Noah five hundred and ninety-five years, and became the father of other sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","All the days of Lamech were seven hundred and seventy-seven years, then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah was five hundred years old, then Noah became the father of Shem, Ham, and Japheth. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","When men began to multiply on the surface of the ground, and daughters were born to them, ");
INSERT INTO engwebpb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","God’s sons saw that men’s daughters were beautiful, and they took any that they wanted for themselves as wives. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","The LORD said, “My Spirit will not strive with man forever, because he also is flesh; so his days will be one hundred and twenty years.” ");
INSERT INTO engwebpb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","The Nephilim were in the earth in those days, and also after that, when God’s sons came in to men’s daughters and had children with them. Those were the mighty men who were of old, men of renown. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","The LORD saw that the wickedness of man was great in the earth, and that every imagination of the thoughts of man’s heart was continually only evil. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","The LORD was sorry that he had made man on the earth, and it grieved him in his heart. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","The LORD said, “I will destroy man whom I have created from the surface of the ground—man, along with animals, creeping things, and birds of the sky—for I am sorry that I have made them.” ");
INSERT INTO engwebpb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noah found favour in the LORD’s eyes. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is the history of the generations of Noah: Noah was a righteous man, blameless amongst the people of his time. Noah walked with God. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah became the father of three sons: Shem, Ham, and Japheth. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","The earth was corrupt before God, and the earth was filled with violence. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God saw the earth, and saw that it was corrupt, for all flesh had corrupted their way on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","God said to Noah, “I will bring an end to all flesh, for the earth is filled with violence through them. Behold, I will destroy them and the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make a ship of gopher wood. You shall make rooms in the ship, and shall seal it inside and outside with pitch. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","This is how you shall make it. The length of the ship shall be three hundred cubits, its width fifty cubits, and its height thirty cubits. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","You shall make a roof in the ship, and you shall finish it to a cubit upward. You shall set the door of the ship in its side. You shall make it with lower, second, and third levels. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","I, even I, will bring the flood of waters on this earth, to destroy all flesh having the breath of life from under the sky. Everything that is in the earth will die. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But I will establish my covenant with you. You shall come into the ship, you, your sons, your wife, and your sons’ wives with you. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Of every living thing of all flesh, you shall bring two of every sort into the ship, to keep them alive with you. They shall be male and female. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Of the birds after their kind, of the livestock after their kind, of every creeping thing of the ground after its kind, two of every sort will come to you, to keep them alive. ");
INSERT INTO engwebpb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Take with you some of all food that is eaten, and gather it to yourself; and it will be for food for you, and for them.” ");
INSERT INTO engwebpb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Thus Noah did. He did all that God commanded him. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","The LORD said to Noah, “Come with all of your household into the ship, for I have seen your righteousness before me in this generation. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","You shall take seven pairs of every clean animal with you, the male and his female. Of the animals that are not clean, take two, the male and his female. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Also of the birds of the sky, seven and seven, male and female, to keep seed alive on the surface of all the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","In seven days, I will cause it to rain on the earth for forty days and forty nights. I will destroy every living thing that I have made from the surface of the ground.” ");
INSERT INTO engwebpb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah did everything that the LORD commanded him. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah was six hundred years old when the flood of waters came on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noah went into the ship with his sons, his wife, and his sons’ wives, because of the floodwaters. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Clean animals, unclean animals, birds, and everything that creeps on the ground ");
INSERT INTO engwebpb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","went by pairs to Noah into the ship, male and female, as God commanded Noah. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","After the seven days, the floodwaters came on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of Noah’s life, in the second month, on the seventeenth day of the month, on that day all the fountains of the great deep burst open, and the sky’s windows opened. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","It rained on the earth forty days and forty nights. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","In the same day Noah, and Shem, Ham, and Japheth—the sons of Noah—and Noah’s wife and the three wives of his sons with them, entered into the ship— ");
INSERT INTO engwebpb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","they, and every animal after its kind, all the livestock after their kind, every creeping thing that creeps on the earth after its kind, and every bird after its kind, every bird of every sort. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pairs from all flesh with the breath of life in them went into the ship to Noah. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Those who went in, went in male and female of all flesh, as God commanded him; then the LORD shut him in. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","The flood was forty days on the earth. The waters increased, and lifted up the ship, and it was lifted up above the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","The waters rose, and increased greatly on the earth; and the ship floated on the surface of the waters. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","The waters rose very high on the earth. All the high mountains that were under the whole sky were covered. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The waters rose fifteen cubits higher, and the mountains were covered. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","All flesh died that moved on the earth, including birds, livestock, animals, every creeping thing that creeps on the earth, and every man. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","All on the dry land, in whose nostrils was the breath of the spirit of life, died. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Every living thing was destroyed that was on the surface of the ground, including man, livestock, creeping things, and birds of the sky. They were destroyed from the earth. Only Noah was left, and those who were with him in the ship. ");
INSERT INTO engwebpb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","The waters flooded the earth one hundred and fifty days. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","God remembered Noah, all the animals, and all the livestock that were with him in the ship; and God made a wind to pass over the earth. The waters subsided. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","The deep’s fountains and the sky’s windows were also stopped, and the rain from the sky was restrained. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The waters continually receded from the earth. After the end of one hundred and fifty days the waters receded. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","The ship rested in the seventh month, on the seventeenth day of the month, on Ararat’s mountains. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The waters receded continually until the tenth month. In the tenth month, on the first day of the month, the tops of the mountains were visible. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","At the end of forty days, Noah opened the window of the ship which he had made, ");
INSERT INTO engwebpb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","and he sent out a raven. It went back and forth, until the waters were dried up from the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","He himself sent out a dove to see if the waters were abated from the surface of the ground, ");
INSERT INTO engwebpb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","but the dove found no place to rest her foot, and she returned into the ship to him, for the waters were on the surface of the whole earth. He put out his hand, and took her, and brought her to him into the ship. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","He waited yet another seven days; and again he sent the dove out of the ship. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","The dove came back to him at evening and, behold, in her mouth was a freshly plucked olive leaf. So Noah knew that the waters were abated from the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","He waited yet another seven days, and sent out the dove; and she didn’t return to him any more. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","In the six hundred and first year, in the first month, the first day of the month, the waters were dried up from the earth. Noah removed the covering of the ship, and looked. He saw that the surface of the ground was dry. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","In the second month, on the twenty-seventh day of the month, the earth was dry. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","God spoke to Noah, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Go out of the ship, you, your wife, your sons, and your sons’ wives with you. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bring out with you every living thing that is with you of all flesh, including birds, livestock, and every creeping thing that creeps on the earth, that they may breed abundantly in the earth, and be fruitful, and multiply on the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noah went out, with his sons, his wife, and his sons’ wives with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Every animal, every creeping thing, and every bird, whatever moves on the earth, after their families, went out of the ship. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah built an altar to the LORD, and took of every clean animal, and of every clean bird, and offered burnt offerings on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","The LORD smelled the pleasant aroma. The LORD said in his heart, “I will not again curse the ground any more for man’s sake because the imagination of man’s heart is evil from his youth. I will never again strike every living thing, as I have done. ");
INSERT INTO engwebpb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","While the earth remains, seed time and harvest, and cold and heat, and summer and winter, and day and night will not cease.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God blessed Noah and his sons, and said to them, “Be fruitful, multiply, and replenish the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","The fear of you and the dread of you will be on every animal of the earth, and on every bird of the sky. Everything that moves along the ground, and all the fish of the sea, are delivered into your hand. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every moving thing that lives will be food for you. As I gave you the green herb, I have given everything to you. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But flesh with its life, that is, its blood, you shall not eat. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","I will surely require accounting for your life’s blood. At the hand of every animal I will require it. At the hand of man, even at the hand of every man’s brother, I will require the life of man. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoever sheds man’s blood, his blood will be shed by man, for God made man in his own image. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Be fruitful and multiply. Increase abundantly in the earth, and multiply in it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","God spoke to Noah and to his sons with him, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“As for me, behold, I establish my covenant with you, and with your offspring after you, ");
INSERT INTO engwebpb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with every living creature that is with you: the birds, the livestock, and every animal of the earth with you, of all that go out of the ship, even every animal of the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","I will establish my covenant with you: All flesh will not be cut off any more by the waters of the flood. There will never again be a flood to destroy the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","God said, “This is the token of the covenant which I make between me and you and every living creature that is with you, for perpetual generations: ");
INSERT INTO engwebpb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I set my rainbow in the cloud, and it will be a sign of a covenant between me and the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","When I bring a cloud over the earth, that the rainbow will be seen in the cloud, ");
INSERT INTO engwebpb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","I will remember my covenant, which is between me and you and every living creature of all flesh, and the waters will no more become a flood to destroy all flesh. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","The rainbow will be in the cloud. I will look at it, that I may remember the everlasting covenant between God and every living creature of all flesh that is on the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","God said to Noah, “This is the token of the covenant which I have established between me and all flesh that is on the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","The sons of Noah who went out from the ship were Shem, Ham, and Japheth. Ham is the father of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three were the sons of Noah, and from these the whole earth was populated. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah began to be a farmer, and planted a vineyard. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","He drank of the wine and got drunk. He was uncovered within his tent. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, the father of Canaan, saw the nakedness of his father, and told his two brothers outside. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem and Japheth took a garment, and laid it on both their shoulders, went in backwards, and covered the nakedness of their father. Their faces were backwards, and they didn’t see their father’s nakedness. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noah awoke from his wine, and knew what his youngest son had done to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","He said, “Canaan is cursed. He will be a servant of servants to his brothers.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","He said, “Blessed be the LORD, the God of Shem. Let Canaan be his servant. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God enlarge Japheth. Let him dwell in the tents of Shem. Let Canaan be his servant.” ");
INSERT INTO engwebpb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah lived three hundred and fifty years after the flood. ");
INSERT INTO engwebpb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","All the days of Noah were nine hundred and fifty years, and then he died. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Now this is the history of the generations of the sons of Noah and of Shem, Ham, and Japheth. Sons were born to them after the flood. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth were: Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","The sons of Gomer were: Ashkenaz, Riphath, and Togarmah. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","The sons of Javan were: Elishah, Tarshish, Kittim, and Dodanim. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Of these were the islands of the nations divided in their lands, everyone after his language, after their families, in their nations. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The sons of Ham were: Cush, Mizraim, Put, and Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The sons of Cush were: Seba, Havilah, Sabtah, Raamah, and Sabteca. The sons of Raamah were: Sheba and Dedan. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush became the father of Nimrod. He began to be a mighty one in the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a mighty hunter before the LORD. Therefore it is said, “like Nimrod, a mighty hunter before the LORD”. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","The beginning of his kingdom was Babel, Erech, Accad, and Calneh, in the land of Shinar. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Out of that land he went into Assyria, and built Nineveh, Rehoboth Ir, Calah, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen between Nineveh and the great city Calah. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim became the father of Ludim, Anamim, Lehabim, Naphtuhim, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim, Casluhim (which the Philistines descended from), and Caphtorim. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan became the father of Sidon (his firstborn), Heth, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","the Jebusites, the Amorites, the Girgashites, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","the Hivites, the Arkites, the Sinites, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","the Arvadites, the Zemarites, and the Hamathites. Afterward the families of the Canaanites were spread abroad. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","The border of the Canaanites was from Sidon—as you go towards Gerar—to Gaza—as you go towards Sodom, Gomorrah, Admah, and Zeboiim—to Lasha. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These are the sons of Ham, after their families, according to their languages, in their lands and their nations. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Children were also born to Shem (the elder brother of Japheth), the father of all the children of Eber. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem were: Elam, Asshur, Arpachshad, Lud, and Aram. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The sons of Aram were: Uz, Hul, Gether, and Mash. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpachshad became the father of Shelah. Shelah became the father of Eber. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","To Eber were born two sons. The name of the one was Peleg, for in his days the earth was divided. His brother’s name was Joktan. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan became the father of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO engwebpb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. All these were the sons of Joktan. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Their dwelling extended from Mesha, as you go towards Sephar, the mountain of the east. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are the sons of Shem, by their families, according to their languages, lands, and nations. ");
INSERT INTO engwebpb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These are the families of the sons of Noah, by their generations, according to their nations. The nations divided from these in the earth after the flood. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","The whole earth was of one language and of one speech. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","As they travelled east, they found a plain in the land of Shinar, and they lived there. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","They said to one another, “Come, let’s make bricks, and burn them thoroughly.” They had brick for stone, and they used tar for mortar. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","They said, “Come, let’s build ourselves a city, and a tower whose top reaches to the sky, and let’s make a name for ourselves, lest we be scattered abroad on the surface of the whole earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","The LORD came down to see the city and the tower, which the children of men built. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","The LORD said, “Behold, they are one people, and they all have one language, and this is what they begin to do. Now nothing will be withheld from them, which they intend to do. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, let’s go down, and there confuse their language, that they may not understand one another’s speech.” ");
INSERT INTO engwebpb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So the LORD scattered them abroad from there on the surface of all the earth. They stopped building the city. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Therefore its name was called Babel, because there the LORD confused the language of all the earth. From there, the LORD scattered them abroad on the surface of all the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","This is the history of the generations of Shem: Shem was one hundred years old when he became the father of Arpachshad two years after the flood. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shem lived five hundred years after he became the father of Arpachshad, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpachshad lived thirty-five years and became the father of Shelah. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpachshad lived four hundred and three years after he became the father of Shelah, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah lived thirty years, and became the father of Eber. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelah lived four hundred and three years after he became the father of Eber, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber lived thirty-four years, and became the father of Peleg. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber lived four hundred and thirty years after he became the father of Peleg, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg lived thirty years, and became the father of Reu. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg lived two hundred and nine years after he became the father of Reu, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu lived thirty-two years, and became the father of Serug. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu lived two hundred and seven years after he became the father of Serug, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug lived thirty years, and became the father of Nahor. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug lived two hundred years after he became the father of Nahor, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor lived twenty-nine years, and became the father of Terah. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor lived one hundred and nineteen years after he became the father of Terah, and became the father of more sons and daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah lived seventy years, and became the father of Abram, Nahor, and Haran. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Now this is the history of the generations of Terah. Terah became the father of Abram, Nahor, and Haran. Haran became the father of Lot. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran died in the land of his birth, in Ur of the Chaldees, while his father Terah was still alive. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram and Nahor married wives. The name of Abram’s wife was Sarai, and the name of Nahor’s wife was Milcah, the daughter of Haran, who was also the father of Iscah. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai was barren. She had no child. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah took Abram his son, Lot the son of Haran, his son’s son, and Sarai his daughter-in-law, his son Abram’s wife. They went from Ur of the Chaldees, to go into the land of Canaan. They came to Haran and lived there. ");
INSERT INTO engwebpb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","The days of Terah were two hundred and five years. Terah died in Haran. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Now the LORD said to Abram, “Leave your country, and your relatives, and your father’s house, and go to the land that I will show you. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will make of you a great nation. I will bless you and make your name great. You will be a blessing. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who bless you, and I will curse him who treats you with contempt. All the families of the earth will be blessed through you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram went, as the LORD had told him. Lot went with him. Abram was seventy-five years old when he departed from Haran. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram took Sarai his wife, Lot his brother’s son, all their possessions that they had gathered, and the people whom they had acquired in Haran, and they went to go into the land of Canaan. They entered into the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram passed through the land to the place of Shechem, to the oak of Moreh. At that time, Canaanites were in the land. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","The LORD appeared to Abram and said, “I will give this land to your offspring.” He built an altar there to the LORD, who had appeared to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","He left from there to go to the mountain on the east of Bethel and pitched his tent, having Bethel on the west, and Ai on the east. There he built an altar to the LORD and called on the LORD’s name. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram travelled, still going on towards the South. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","There was a famine in the land. Abram went down into Egypt to live as a foreigner there, for the famine was severe in the land. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","When he had come near to enter Egypt, he said to Sarai his wife, “See now, I know that you are a beautiful woman to look at. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","It will happen that when the Egyptians see you, they will say, ‘This is his wife.’ They will kill me, but they will save you alive. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Please say that you are my sister, that it may be well with me for your sake, and that my soul may live because of you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","When Abram had come into Egypt, some Egyptians saw that the woman was very beautiful. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","The princes of Pharaoh saw her, and praised her to Pharaoh; and the woman was taken into Pharaoh’s house. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","He dealt well with Abram for her sake. He had sheep, cattle, male donkeys, male servants, female servants, female donkeys, and camels. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","The LORD afflicted Pharaoh and his house with great plagues because of Sarai, Abram’s wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pharaoh called Abram and said, “What is this that you have done to me? Why didn’t you tell me that she was your wife? ");
INSERT INTO engwebpb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say, ‘She is my sister,’ so that I took her to be my wife? Now therefore, see your wife, take her, and go your way.” ");
INSERT INTO engwebpb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pharaoh commanded men concerning him, and they escorted him away with his wife and all that he had. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram went up out of Egypt—he, his wife, all that he had, and Lot with him—into the South. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram was very rich in livestock, in silver, and in gold. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","He went on his journeys from the South as far as Bethel, to the place where his tent had been at the beginning, between Bethel and Ai, ");
INSERT INTO engwebpb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","to the place of the altar, which he had made there at the first. There Abram called on the LORD’s name. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot also, who went with Abram, had flocks, herds, and tents. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","The land was not able to bear them, that they might live together; for their possessions were so great that they couldn’t live together. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","There was strife between the herdsmen of Abram’s livestock and the herdsmen of Lot’s livestock. The Canaanites and the Perizzites lived in the land at that time. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram said to Lot, “Please, let there be no strife between you and me, and between your herdsmen and my herdsmen; for we are relatives. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Isn’t the whole land before you? Please separate yourself from me. If you go to the left hand, then I will go to the right. Or if you go to the right hand, then I will go to the left.” ");
INSERT INTO engwebpb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot lifted up his eyes, and saw all the plain of the Jordan, that it was well-watered everywhere, before the LORD destroyed Sodom and Gomorrah, like the garden of the LORD, like the land of Egypt, as you go to Zoar. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot chose the Plain of the Jordan for himself. Lot travelled east, and they separated themselves from one another. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram lived in the land of Canaan, and Lot lived in the cities of the plain, and moved his tent as far as Sodom. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Now the men of Sodom were exceedingly wicked and sinners against the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","The LORD said to Abram, after Lot was separated from him, “Now, lift up your eyes, and look from the place where you are, northward and southward and eastward and westward, ");
INSERT INTO engwebpb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","for I will give all the land which you see to you and to your offspring forever. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I will make your offspring as the dust of the earth, so that if a man can count the dust of the earth, then your offspring may also be counted. ");
INSERT INTO engwebpb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Arise, walk through the land in its length and in its width; for I will give it to you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram moved his tent, and came and lived by the oaks of Mamre, which are in Hebron, and built an altar there to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","In the days of Amraphel, king of Shinar; Arioch, king of Ellasar; Chedorlaomer, king of Elam; and Tidal, king of Goiim, ");
INSERT INTO engwebpb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","they made war with Bera, king of Sodom; Birsha, king of Gomorrah; Shinab, king of Admah; Shemeber, king of Zeboiim; and the king of Bela (also called Zoar). ");
INSERT INTO engwebpb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these joined together in the valley of Siddim (also called the Salt Sea). ");
INSERT INTO engwebpb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","They served Chedorlaomer for twelve years, and in the thirteenth year they rebelled. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","In the fourteenth year Chedorlaomer and the kings who were with him came and struck the Rephaim in Ashteroth Karnaim, the Zuzim in Ham, the Emim in Shaveh Kiriathaim, ");
INSERT INTO engwebpb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horites in their Mount Seir, to El Paran, which is by the wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","They returned, and came to En Mishpat (also called Kadesh), and struck all the country of the Amalekites, and also the Amorites, that lived in Hazazon Tamar. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","The king of Sodom, and the king of Gomorrah, the king of Admah, the king of Zeboiim, and the king of Bela (also called Zoar) went out; and they set the battle in array against them in the valley of Siddim ");
INSERT INTO engwebpb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","against Chedorlaomer king of Elam, Tidal king of Goiim, Amraphel king of Shinar, and Arioch king of Ellasar; four kings against the five. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Now the valley of Siddim was full of tar pits; and the kings of Sodom and Gomorrah fled, and some fell there. Those who remained fled to the hills. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","They took all the goods of Sodom and Gomorrah, and all their food, and went their way. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","They took Lot, Abram’s brother’s son, who lived in Sodom, and his goods, and departed. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","One who had escaped came and told Abram, the Hebrew. At that time, he lived by the oaks of Mamre, the Amorite, brother of Eshcol and brother of Aner. They were allies of Abram. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","When Abram heard that his relative was taken captive, he led out his three hundred and eighteen trained men, born in his house, and pursued as far as Dan. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","He divided himself against them by night, he and his servants, and struck them, and pursued them to Hobah, which is on the left hand of Damascus. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","He brought back all the goods, and also brought back his relative Lot and his goods, and the women also, and the other people. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","The king of Sodom went out to meet him after his return from the slaughter of Chedorlaomer and the kings who were with him, at the valley of Shaveh (that is, the King’s Valley). ");
INSERT INTO engwebpb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchizedek king of Salem brought out bread and wine. He was priest of God Most High. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","He blessed him, and said, “Blessed be Abram of God Most High, possessor of heaven and earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Blessed be God Most High, who has delivered your enemies into your hand.” Abram gave him a tenth of all. ");
INSERT INTO engwebpb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","The king of Sodom said to Abram, “Give me the people, and take the goods for yourself.” ");
INSERT INTO engwebpb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram said to the king of Sodom, “I have lifted up my hand to the LORD, God Most High, possessor of heaven and earth, ");
INSERT INTO engwebpb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","that I will not take a thread nor a sandal strap nor anything that is yours, lest you should say, ‘I have made Abram rich.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","I will accept nothing from you except that which the young men have eaten, and the portion of the men who went with me: Aner, Eshcol, and Mamre. Let them take their portion.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things the LORD’s word came to Abram in a vision, saying, “Don’t be afraid, Abram. I am your shield, your exceedingly great reward.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram said, “Lord GOD, what will you give me, since I go childless, and he who will inherit my estate is Eliezer of Damascus?” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram said, “Behold, you have given no children to me: and, behold, one born in my house is my heir.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Behold, the LORD’s word came to him, saying, “This man will not be your heir, but he who will come out of your own body will be your heir.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","The LORD brought him outside, and said, “Look now towards the sky, and count the stars, if you are able to count them.” He said to Abram, “So your offspring will be.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","He believed in the LORD, who credited it to him for righteousness. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","He said to Abram, “I am the LORD who brought you out of Ur of the Chaldees, to give you this land to inherit it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","He said, “Lord GOD, how will I know that I will inherit it?” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","He said to him, “Bring me a heifer three years old, a female goat three years old, a ram three years old, a turtledove, and a young pigeon.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","He brought him all these, and divided them in the middle, and laid each half opposite the other; but he didn’t divide the birds. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","The birds of prey came down on the carcasses, and Abram drove them away. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","When the sun was going down, a deep sleep fell on Abram. Now terror and great darkness fell on him. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","He said to Abram, “Know for sure that your offspring will live as foreigners in a land that is not theirs, and will serve them. They will afflict them four hundred years. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","I will also judge that nation, whom they will serve. Afterward they will come out with great wealth; ");
INSERT INTO engwebpb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","but you will go to your fathers in peace. You will be buried at a good old age. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","In the fourth generation they will come here again, for the iniquity of the Amorite is not yet full.” ");
INSERT INTO engwebpb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","It came to pass that, when the sun went down, and it was dark, behold, a smoking furnace and a flaming torch passed between these pieces. ");
INSERT INTO engwebpb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In that day the LORD made a covenant with Abram, saying, “I have given this land to your offspring, from the river of Egypt to the great river, the river Euphrates: ");
INSERT INTO engwebpb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","the land of the Kenites, the Kenizzites, the Kadmonites, ");
INSERT INTO engwebpb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","the Hittites, the Perizzites, the Rephaim, ");
INSERT INTO engwebpb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","the Amorites, the Canaanites, the Girgashites, and the Jebusites.” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Now Sarai, Abram’s wife, bore him no children. She had a servant, an Egyptian, whose name was Hagar. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai said to Abram, “See now, the LORD has restrained me from bearing. Please go in to my servant. It may be that I will obtain children by her.” Abram listened to the voice of Sarai. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai, Abram’s wife, took Hagar the Egyptian, her servant, after Abram had lived ten years in the land of Canaan, and gave her to Abram her husband to be his wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","He went in to Hagar, and she conceived. When she saw that she had conceived, her mistress was despised in her eyes. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai said to Abram, “This wrong is your fault. I gave my servant into your bosom, and when she saw that she had conceived, she despised me. May the LORD judge between me and you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","But Abram said to Sarai, “Behold, your maid is in your hand. Do to her whatever is good in your eyes.” Sarai dealt harshly with her, and she fled from her face. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","The LORD’s angel found her by a fountain of water in the wilderness, by the fountain on the way to Shur. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","He said, “Hagar, Sarai’s servant, where did you come from? Where are you going?” She said, “I am fleeing from the face of my mistress Sarai.” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","The LORD’s angel said to her, “Return to your mistress, and submit yourself under her hands.” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","The LORD’s angel said to her, “I will greatly multiply your offspring, that they will not be counted for multitude.” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","The LORD’s angel said to her, “Behold, you are with child, and will bear a son. You shall call his name Ishmael, because the LORD has heard your affliction. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","He will be like a wild donkey amongst men. His hand will be against every man, and every man’s hand against him. He will live opposed to all of his brothers.” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","She called the name of the LORD who spoke to her, “You are a God who sees,” for she said, “Have I even stayed alive after seeing him?” ");
INSERT INTO engwebpb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Therefore the well was called Beer Lahai Roi. Behold, it is between Kadesh and Bered. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar bore a son for Abram. Abram called the name of his son, whom Hagar bore, Ishmael. ");
INSERT INTO engwebpb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was eighty-six years old when Hagar bore Ishmael to Abram. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was ninety-nine years old, the LORD appeared to Abram and said to him, “I am God Almighty. Walk before me and be blameless. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I will make my covenant between me and you, and will multiply you exceedingly.” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram fell on his face. God talked with him, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“As for me, behold, my covenant is with you. You will be the father of a multitude of nations. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Your name will no more be called Abram, but your name will be Abraham; for I have made you the father of a multitude of nations. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will make you exceedingly fruitful, and I will make nations of you. Kings will come out of you. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I will establish my covenant between me and you and your offspring after you throughout their generations for an everlasting covenant, to be a God to you and to your offspring after you. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I will give to you, and to your offspring after you, the land where you are travelling, all the land of Canaan, for an everlasting possession. I will be their God.” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","God said to Abraham, “As for you, you shall keep my covenant, you and your offspring after you throughout their generations. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is my covenant, which you shall keep, between me and you and your offspring after you. Every male amongst you shall be circumcised. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","You shall be circumcised in the flesh of your foreskin. It will be a token of the covenant between me and you. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","He who is eight days old shall be circumcised amongst you, every male throughout your generations, he who is born in the house, or bought with money from any foreigner who is not of your offspring. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","He who is born in your house, and he who is bought with your money, must be circumcised. My covenant shall be in your flesh for an everlasting covenant. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","The uncircumcised male who is not circumcised in the flesh of his foreskin, that soul shall be cut off from his people. He has broken my covenant.” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God said to Abraham, “As for Sarai your wife, you shall not call her name Sarai, but her name shall be Sarah. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will bless her, and moreover I will give you a son by her. Yes, I will bless her, and she will be a mother of nations. Kings of peoples will come from her.” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Then Abraham fell on his face, and laughed, and said in his heart, “Will a child be born to him who is one hundred years old? Will Sarah, who is ninety years old, give birth?” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham said to God, “Oh that Ishmael might live before you!” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God said, “No, but Sarah, your wife, will bear you a son. You shall call his name Isaac. I will establish my covenant with him for an everlasting covenant for his offspring after him. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As for Ishmael, I have heard you. Behold, I have blessed him, and will make him fruitful, and will multiply him exceedingly. He will become the father of twelve princes, and I will make him a great nation. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But I will establish my covenant with Isaac, whom Sarah will bear to you at this set time next year.” ");
INSERT INTO engwebpb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","When he finished talking with him, God went up from Abraham. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham took Ishmael his son, all who were born in his house, and all who were bought with his money: every male amongst the men of Abraham’s house, and circumcised the flesh of their foreskin in the same day, as God had said to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was ninety-nine years old when he was circumcised in the flesh of his foreskin. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmael, his son, was thirteen years old when he was circumcised in the flesh of his foreskin. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","In the same day both Abraham and Ishmael, his son, were circumcised. ");
INSERT INTO engwebpb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","All the men of his house, those born in the house, and those bought with money from a foreigner, were circumcised with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","The LORD appeared to him by the oaks of Mamre, as he sat in the tent door in the heat of the day. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","He lifted up his eyes and looked, and saw that three men stood near him. When he saw them, he ran to meet them from the tent door, and bowed himself to the earth, ");
INSERT INTO engwebpb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","and said, “My lord, if now I have found favour in your sight, please don’t go away from your servant. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Now let a little water be fetched, wash your feet, and rest yourselves under the tree. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","I will get a piece of bread so you can refresh your heart. After that you may go your way, now that you have come to your servant.” They said, “Very well, do as you have said.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham hurried into the tent to Sarah, and said, “Quickly prepare three seahs of fine meal, knead it, and make cakes.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham ran to the herd, and fetched a tender and good calf, and gave it to the servant. He hurried to dress it. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","He took butter, milk, and the calf which he had dressed, and set it before them. He stood by them under the tree, and they ate. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","They asked him, “Where is Sarah, your wife?” He said, “There, in the tent.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","He said, “I will certainly return to you at about this time next year; and behold, Sarah your wife will have a son.” Sarah heard in the tent door, which was behind him. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Now Abraham and Sarah were old, well advanced in age. Sarah had passed the age of childbearing. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah laughed within herself, saying, “After I have grown old will I have pleasure, my lord being old also?” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","The LORD said to Abraham, “Why did Sarah laugh, saying, ‘Will I really bear a child when I am old?’ ");
INSERT INTO engwebpb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is anything too hard for the LORD? At the set time I will return to you, when the season comes around, and Sarah will have a son.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Then Sarah denied it, saying, “I didn’t laugh,” for she was afraid. He said, “No, but you did laugh.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","The men rose up from there, and looked towards Sodom. Abraham went with them to see them on their way. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","The LORD said, “Will I hide from Abraham what I do, ");
INSERT INTO engwebpb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","since Abraham will surely become a great and mighty nation, and all the nations of the earth will be blessed in him? ");
INSERT INTO engwebpb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","For I have known him, to the end that he may command his children and his household after him, that they may keep the way of the LORD, to do righteousness and justice; to the end that the LORD may bring on Abraham that which he has spoken of him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","The LORD said, “Because the cry of Sodom and Gomorrah is great, and because their sin is very grievous, ");
INSERT INTO engwebpb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will go down now, and see whether their deeds are as bad as the reports which have come to me. If not, I will know.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","The men turned from there, and went towards Sodom, but Abraham stood yet before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham came near, and said, “Will you consume the righteous with the wicked? ");
INSERT INTO engwebpb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","What if there are fifty righteous within the city? Will you consume and not spare the place for the fifty righteous who are in it? ");
INSERT INTO engwebpb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","May it be far from you to do things like that, to kill the righteous with the wicked, so that the righteous should be like the wicked. May that be far from you. Shouldn’t the Judge of all the earth do right?” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","The LORD said, “If I find in Sodom fifty righteous within the city, then I will spare the whole place for their sake.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham answered, “See now, I have taken it on myself to speak to the Lord, although I am dust and ashes. ");
INSERT INTO engwebpb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","What if there will lack five of the fifty righteous? Will you destroy all the city for lack of five?” He said, “I will not destroy it if I find forty-five there.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","He spoke to him yet again, and said, “What if there are forty found there?” He said, “I will not do it for the forty’s sake.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","He said, “Oh don’t let the Lord be angry, and I will speak. What if there are thirty found there?” He said, “I will not do it if I find thirty there.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","He said, “See now, I have taken it on myself to speak to the Lord. What if there are twenty found there?” He said, “I will not destroy it for the twenty’s sake.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","He said, “Oh don’t let the Lord be angry, and I will speak just once more. What if ten are found there?” He said, “I will not destroy it for the ten’s sake.” ");
INSERT INTO engwebpb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","The LORD went his way as soon as he had finished communing with Abraham, and Abraham returned to his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","The two angels came to Sodom at evening. Lot sat in the gate of Sodom. Lot saw them, and rose up to meet them. He bowed himself with his face to the earth, ");
INSERT INTO engwebpb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","and he said, “See now, my lords, please come into your servant’s house, stay all night, wash your feet, and you can rise up early, and go on your way.” They said, “No, but we will stay in the street all night.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","He urged them greatly, and they came in with him, and entered into his house. He made them a feast, and baked unleavened bread, and they ate. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","But before they lay down, the men of the city, the men of Sodom, surrounded the house, both young and old, all the people from every quarter. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They called to Lot, and said to him, “Where are the men who came in to you this night? Bring them out to us, that we may have sex with them.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went out to them through the door, and shut the door after himself. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said, “Please, my brothers, don’t act so wickedly. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","See now, I have two virgin daughters. Please let me bring them out to you, and you may do to them what seems good to you. Only don’t do anything to these men, because they have come under the shadow of my roof.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","They said, “Stand back!” Then they said, “This one fellow came in to live as a foreigner, and he appoints himself a judge. Now we will deal worse with you than with them!” They pressed hard on the man Lot, and came near to break the door. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the men reached out their hand, and brought Lot into the house to them, and shut the door. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","They struck the men who were at the door of the house with blindness, both small and great, so that they wearied themselves to find the door. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","The men said to Lot, “Do you have anybody else here? Sons-in-law, your sons, your daughters, and whomever you have in the city, bring them out of the place: ");
INSERT INTO engwebpb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","for we will destroy this place, because the outcry against them has grown so great before the LORD that the LORD has sent us to destroy it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot went out, and spoke to his sons-in-law, who were pledged to marry his daughters, and said, “Get up! Get out of this place, for the LORD will destroy the city!” But he seemed to his sons-in-law to be joking. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","When the morning came, then the angels hurried Lot, saying, “Get up! Take your wife and your two daughters who are here, lest you be consumed in the iniquity of the city.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But he lingered; and the men grabbed his hand, his wife’s hand, and his two daughters’ hands, the LORD being merciful to him; and they took him out, and set him outside of the city. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","It came to pass, when they had taken them out, that he said, “Escape for your life! Don’t look behind you, and don’t stay anywhere in the plain. Escape to the mountains, lest you be consumed!” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot said to them, “Oh, not so, my lord. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","See now, your servant has found favour in your sight, and you have magnified your loving kindness, which you have shown to me in saving my life. I can’t escape to the mountain, lest evil overtake me, and I die. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","See now, this city is near to flee to, and it is a little one. Oh let me escape there (isn’t it a little one?), and my soul will live.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","He said to him, “Behold, I have granted your request concerning this thing also, that I will not overthrow the city of which you have spoken. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hurry, escape there, for I can’t do anything until you get there.” Therefore the name of the city was called Zoar. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun had risen on the earth when Lot came to Zoar. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then the LORD rained on Sodom and on Gomorrah sulphur and fire from the LORD out of the sky. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","He overthrew those cities, all the plain, all the inhabitants of the cities, and that which grew on the ground. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot’s wife looked back from behind him, and she became a pillar of salt. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham went up early in the morning to the place where he had stood before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked towards Sodom and Gomorrah, and towards all the land of the plain, and saw that the smoke of the land went up as the smoke of a furnace. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","When God destroyed the cities of the plain, God remembered Abraham, and sent Lot out of the middle of the overthrow, when he overthrew the cities in which Lot lived. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot went up out of Zoar, and lived in the mountain, and his two daughters with him; for he was afraid to live in Zoar. He lived in a cave with his two daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","The firstborn said to the younger, “Our father is old, and there is not a man in the earth to come in to us in the way of all the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, let’s make our father drink wine, and we will lie with him, that we may preserve our father’s family line.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","They made their father drink wine that night: and the firstborn went in, and lay with her father. He didn’t know when she lay down, nor when she arose. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","It came to pass on the next day, that the firstborn said to the younger, “Behold, I lay last night with my father. Let’s make him drink wine again tonight. You go in, and lie with him, that we may preserve our father’s family line.” ");
INSERT INTO engwebpb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","They made their father drink wine that night also. The younger went and lay with him. He didn’t know when she lay down, nor when she got up. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Thus both of Lot’s daughters were with child by their father. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The firstborn bore a son, and named him Moab. He is the father of the Moabites to this day. ");
INSERT INTO engwebpb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The younger also bore a son, and called his name Ben Ammi. He is the father of the children of Ammon to this day. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham travelled from there towards the land of the South, and lived between Kadesh and Shur. He lived as a foreigner in Gerar. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham said about Sarah his wife, “She is my sister.” Abimelech king of Gerar sent, and took Sarah. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But God came to Abimelech in a dream of the night, and said to him, “Behold, you are a dead man, because of the woman whom you have taken; for she is a man’s wife.” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Now Abimelech had not come near her. He said, “Lord, will you kill even a righteous nation? ");
INSERT INTO engwebpb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Didn’t he tell me, ‘She is my sister’? She, even she herself, said, ‘He is my brother.’ I have done this in the integrity of my heart and the innocence of my hands.” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God said to him in the dream, “Yes, I know that in the integrity of your heart you have done this, and I also withheld you from sinning against me. Therefore I didn’t allow you to touch her. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Now therefore, restore the man’s wife. For he is a prophet, and he will pray for you, and you will live. If you don’t restore her, know for sure that you will die, you, and all who are yours.” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelech rose early in the morning, and called all his servants, and told all these things in their ear. The men were very scared. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelech called Abraham, and said to him, “What have you done to us? How have I sinned against you, that you have brought on me and on my kingdom a great sin? You have done deeds to me that ought not to be done!” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelech said to Abraham, “What did you see, that you have done this thing?” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham said, “Because I thought, ‘Surely the fear of God is not in this place. They will kill me for my wife’s sake.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Besides, she is indeed my sister, the daughter of my father, but not the daughter of my mother; and she became my wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","When God caused me to wander from my father’s house, I said to her, ‘This is your kindness which you shall show to me. Everywhere that we go, say of me, “He is my brother.”’” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelech took sheep and cattle, male servants and female servants, and gave them to Abraham, and restored Sarah, his wife, to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelech said, “Behold, my land is before you. Dwell where it pleases you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","To Sarah he said, “Behold, I have given your brother a thousand pieces of silver. Behold, it is for you a covering of the eyes to all that are with you. In front of all you are vindicated.” ");
INSERT INTO engwebpb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham prayed to God. So God healed Abimelech, his wife, and his female servants, and they bore children. ");
INSERT INTO engwebpb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For the LORD had closed up tight all the wombs of the house of Abimelech, because of Sarah, Abraham’s wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","The LORD visited Sarah as he had said, and the LORD did to Sarah as he had spoken. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah conceived, and bore Abraham a son in his old age, at the set time of which God had spoken to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham called his son who was born to him, whom Sarah bore to him, Isaac. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circumcised his son, Isaac, when he was eight days old, as God had commanded him. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was one hundred years old when his son, Isaac, was born to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah said, “God has made me laugh. Everyone who hears will laugh with me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She said, “Who would have said to Abraham that Sarah would nurse children? For I have borne him a son in his old age.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","The child grew and was weaned. Abraham made a great feast on the day that Isaac was weaned. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sarah saw the son of Hagar the Egyptian, whom she had borne to Abraham, mocking. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Therefore she said to Abraham, “Cast out this servant and her son! For the son of this servant will not be heir with my son, Isaac.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","The thing was very grievous in Abraham’s sight on account of his son. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","God said to Abraham, “Don’t let it be grievous in your sight because of the boy, and because of your servant. In all that Sarah says to you, listen to her voice. For your offspring will be named through Isaac. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","I will also make a nation of the son of the servant, because he is your child.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham rose up early in the morning, and took bread and a container of water, and gave it to Hagar, putting it on her shoulder; and gave her the child, and sent her away. She departed, and wandered in the wilderness of Beersheba. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","The water in the container was spent, and she put the child under one of the shrubs. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","She went and sat down opposite him, a good way off, about a bow shot away. For she said, “Don’t let me see the death of the child.” She sat opposite him, and lifted up her voice, and wept. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God heard the voice of the boy. The angel of God called to Hagar out of the sky, and said to her, “What troubles you, Hagar? Don’t be afraid. For God has heard the voice of the boy where he is. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Get up, lift up the boy, and hold him with your hand. For I will make him a great nation.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","God opened her eyes, and she saw a well of water. She went, filled the container with water, and gave the boy a drink. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God was with the boy, and he grew. He lived in the wilderness, and as he grew up, he became an archer. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He lived in the wilderness of Paran. His mother got a wife for him out of the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","At that time, Abimelech and Phicol the captain of his army spoke to Abraham, saying, “God is with you in all that you do. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Now, therefore, swear to me here by God that you will not deal falsely with me, nor with my son, nor with my son’s son. But according to the kindness that I have done to you, you shall do to me, and to the land in which you have lived as a foreigner.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham said, “I will swear.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham complained to Abimelech because of a water well, which Abimelech’s servants had violently taken away. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelech said, “I don’t know who has done this thing. You didn’t tell me, and I didn’t hear of it until today.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham took sheep and cattle, and gave them to Abimelech. Those two made a covenant. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham set seven ewe lambs of the flock by themselves. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech said to Abraham, “What do these seven ewe lambs, which you have set by themselves, mean?” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","He said, “You shall take these seven ewe lambs from my hand, that it may be a witness to me, that I have dug this well.” ");
INSERT INTO engwebpb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Therefore he called that place Beersheba, because they both swore an oath there. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","So they made a covenant at Beersheba. Abimelech rose up with Phicol, the captain of his army, and they returned into the land of the Philistines. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planted a tamarisk tree in Beersheba, and there he called on the name of the LORD, the Everlasting God. ");
INSERT INTO engwebpb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham lived as a foreigner in the land of the Philistines many days. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","After these things, God tested Abraham, and said to him, “Abraham!” He said, “Here I am.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","He said, “Now take your son, your only son, Isaac, whom you love, and go into the land of Moriah. Offer him there as a burnt offering on one of the mountains which I will tell you of.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham rose early in the morning, and saddled his donkey; and took two of his young men with him, and Isaac his son. He split the wood for the burnt offering, and rose up, and went to the place of which God had told him. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","On the third day Abraham lifted up his eyes, and saw the place far off. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham said to his young men, “Stay here with the donkey. The boy and I will go over there. We will worship, and come back to you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham took the wood of the burnt offering and laid it on Isaac his son. He took in his hand the fire and the knife. They both went together. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac spoke to Abraham his father, and said, “My father?” He said, “Here I am, my son.” He said, “Here is the fire and the wood, but where is the lamb for a burnt offering?” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham said, “God will provide himself the lamb for a burnt offering, my son.” So they both went together. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","They came to the place which God had told him of. Abraham built the altar there, and laid the wood in order, bound Isaac his son, and laid him on the altar, on the wood. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham stretched out his hand, and took the knife to kill his son. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","The LORD’s angel called to him out of the sky, and said, “Abraham, Abraham!” He said, “Here I am.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","He said, “Don’t lay your hand on the boy or do anything to him. For now I know that you fear God, since you have not withheld your son, your only son, from me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham lifted up his eyes, and looked, and saw that behind him was a ram caught in the thicket by his horns. Abraham went and took the ram, and offered him up for a burnt offering instead of his son. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham called the name of that place “The LORD Will Provide”. As it is said to this day, “On the LORD’s mountain, it will be provided.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","The LORD’s angel called to Abraham a second time out of the sky, ");
INSERT INTO engwebpb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","and said, “‘I have sworn by myself,’ says the LORD, ‘because you have done this thing, and have not withheld your son, your only son, ");
INSERT INTO engwebpb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","that I will bless you greatly, and I will multiply your offspring greatly like the stars of the heavens, and like the sand which is on the seashore. Your offspring will possess the gate of his enemies. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","All the nations of the earth will be blessed by your offspring, because you have obeyed my voice.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","So Abraham returned to his young men, and they rose up and went together to Beersheba. Abraham lived at Beersheba. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","After these things, Abraham was told, “Behold, Milcah, she also has borne children to your brother Nahor: ");
INSERT INTO engwebpb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz his firstborn, Buz his brother, Kemuel the father of Aram, ");
INSERT INTO engwebpb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, and Bethuel.” ");
INSERT INTO engwebpb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel became the father of Rebekah. These eight Milcah bore to Nahor, Abraham’s brother. ");
INSERT INTO engwebpb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","His concubine, whose name was Reumah, also bore Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah lived one hundred and twenty-seven years. This was the length of Sarah’s life. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah died in Kiriath Arba (also called Hebron), in the land of Canaan. Abraham came to mourn for Sarah, and to weep for her. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham rose up from before his dead and spoke to the children of Heth, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am a stranger and a foreigner living with you. Give me a possession of a burying-place with you, that I may bury my dead out of my sight.” ");
INSERT INTO engwebpb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The children of Heth answered Abraham, saying to him, ");
INSERT INTO engwebpb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Hear us, my lord. You are a prince of God amongst us. Bury your dead in the best of our tombs. None of us will withhold from you his tomb. Bury your dead.” ");
INSERT INTO engwebpb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham rose up, and bowed himself to the people of the land, to the children of Heth. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","He talked with them, saying, “If you agree that I should bury my dead out of my sight, hear me, and entreat for me to Ephron the son of Zohar, ");
INSERT INTO engwebpb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","that he may sell me the cave of Machpelah, which he has, which is in the end of his field. For the full price let him sell it to me amongst you as a possession for a burial place.” ");
INSERT INTO engwebpb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Now Ephron was sitting in the middle of the children of Heth. Ephron the Hittite answered Abraham in the hearing of the children of Heth, even of all who went in at the gate of his city, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, my lord, hear me. I give you the field, and I give you the cave that is in it. In the presence of the children of my people I give it to you. Bury your dead.” ");
INSERT INTO engwebpb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham bowed himself down before the people of the land. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","He spoke to Ephron in the audience of the people of the land, saying, “But if you will, please hear me. I will give the price of the field. Take it from me, and I will bury my dead there.” ");
INSERT INTO engwebpb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron answered Abraham, saying to him, ");
INSERT INTO engwebpb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“My lord, listen to me. What is a piece of land worth four hundred shekels of silver between me and you? Therefore bury your dead.” ");
INSERT INTO engwebpb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham listened to Ephron. Abraham weighed to Ephron the silver which he had named in the hearing of the children of Heth, four hundred shekels of silver, according to the current merchants’ standard. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So the field of Ephron, which was in Machpelah, which was before Mamre, the field, the cave which was in it, and all the trees that were in the field, that were in all of its borders, were deeded ");
INSERT INTO engwebpb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","to Abraham for a possession in the presence of the children of Heth, before all who went in at the gate of his city. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After this, Abraham buried Sarah his wife in the cave of the field of Machpelah before Mamre (that is, Hebron), in the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","The field, and the cave that is in it, were deeded to Abraham by the children of Heth as a possession for a burial place. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham was old, and well advanced in age. The LORD had blessed Abraham in all things. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham said to his servant, the elder of his house, who ruled over all that he had, “Please put your hand under my thigh. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","I will make you swear by the LORD, the God of heaven and the God of the earth, that you shall not take a wife for my son of the daughters of the Canaanites, amongst whom I live. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","But you shall go to my country, and to my relatives, and take a wife for my son Isaac.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","The servant said to him, “What if the woman isn’t willing to follow me to this land? Must I bring your son again to the land you came from?” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham said to him, “Beware that you don’t bring my son there again. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","The LORD, the God of heaven—who took me from my father’s house, and from the land of my birth, who spoke to me, and who swore to me, saying, ‘I will give this land to your offspring—he will send his angel before you, and you shall take a wife for my son from there. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","If the woman isn’t willing to follow you, then you shall be clear from this oath to me. Only you shall not bring my son there again.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","The servant put his hand under the thigh of Abraham his master, and swore to him concerning this matter. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","The servant took ten of his master’s camels, and departed, having a variety of good things of his master’s with him. He arose, and went to Mesopotamia, to the city of Nahor. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","He made the camels kneel down outside the city by the well of water at the time of evening, the time that women go out to draw water. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","He said, “LORD, the God of my master Abraham, please give me success today, and show kindness to my master Abraham. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Behold, I am standing by the spring of water. The daughters of the men of the city are coming out to draw water. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Let it happen, that the young lady to whom I will say, ‘Please let down your pitcher, that I may drink,’ then she says, ‘Drink, and I will also give your camels a drink,’—let her be the one you have appointed for your servant Isaac. By this I will know that you have shown kindness to my master.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Before he had finished speaking, behold, Rebekah came out, who was born to Bethuel the son of Milcah, the wife of Nahor, Abraham’s brother, with her pitcher on her shoulder. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","The young lady was very beautiful to look at, a virgin. No man had known her. She went down to the spring, filled her pitcher, and came up. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","The servant ran to meet her, and said, “Please give me a drink, a little water from your pitcher.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","She said, “Drink, my lord.” She hurried, and let down her pitcher on her hand, and gave him a drink. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","When she had finished giving him a drink, she said, “I will also draw for your camels, until they have finished drinking.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","She hurried, and emptied her pitcher into the trough, and ran again to the well to draw, and drew for all his camels. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","The man looked steadfastly at her, remaining silent, to know whether the LORD had made his journey prosperous or not. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","As the camels had finished drinking, the man took a golden ring of half a shekel weight, and two bracelets for her hands of ten shekels weight of gold, ");
INSERT INTO engwebpb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","and said, “Whose daughter are you? Please tell me. Is there room in your father’s house for us to stay?” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She said to him, “I am the daughter of Bethuel the son of Milcah, whom she bore to Nahor.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","She said moreover to him, “We have both straw and feed enough, and room to lodge in.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","The man bowed his head, and worshipped the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","He said, “Blessed be the LORD, the God of my master Abraham, who has not forsaken his loving kindness and his truth towards my master. As for me, the LORD has led me on the way to the house of my master’s relatives.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","The young lady ran, and told her mother’s house about these words. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah had a brother, and his name was Laban. Laban ran out to the man, to the spring. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","When he saw the ring, and the bracelets on his sister’s hands, and when he heard the words of Rebekah his sister, saying, “This is what the man said to me,” he came to the man. Behold, he was standing by the camels at the spring. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","He said, “Come in, you blessed of the LORD. Why do you stand outside? For I have prepared the house, and room for the camels.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","The man came into the house, and he unloaded the camels. He gave straw and feed for the camels, and water to wash his feet and the feet of the men who were with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Food was set before him to eat, but he said, “I will not eat until I have told my message.” Laban said, “Speak on.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","He said, “I am Abraham’s servant. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","The LORD has blessed my master greatly. He has become great. The LORD has given him flocks and herds, silver and gold, male servants and female servants, and camels and donkeys. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah, my master’s wife, bore a son to my master when she was old. He has given all that he has to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master made me swear, saying, ‘You shall not take a wife for my son from the daughters of the Canaanites, in whose land I live, ");
INSERT INTO engwebpb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","but you shall go to my father’s house, and to my relatives, and take a wife for my son.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I asked my master, ‘What if the woman will not follow me?’ ");
INSERT INTO engwebpb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","He said to me, ‘The LORD, before whom I walk, will send his angel with you, and prosper your way. You shall take a wife for my son from my relatives, and of my father’s house. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Then you will be clear from my oath, when you come to my relatives. If they don’t give her to you, you shall be clear from my oath.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","I came today to the spring, and said, ‘The LORD, the God of my master Abraham, if now you do prosper my way which I go— ");
INSERT INTO engwebpb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","behold, I am standing by this spring of water. Let it happen, that the maiden who comes out to draw, to whom I will say, “Please give me a little water from your pitcher to drink,” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","then she tells me, “Drink, and I will also draw for your camels,”—let her be the woman whom the LORD has appointed for my master’s son.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Before I had finished speaking in my heart, behold, Rebekah came out with her pitcher on her shoulder. She went down to the spring, and drew. I said to her, ‘Please let me drink.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She hurried and let down her pitcher from her shoulder, and said, ‘Drink, and I will also give your camels a drink.’ So I drank, and she also gave the camels a drink. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I asked her, and said, ‘Whose daughter are you?’ She said, ‘The daughter of Bethuel, Nahor’s son, whom Milcah bore to him.’ I put the ring on her nose, and the bracelets on her hands. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","I bowed my head, and worshipped the LORD, and blessed the LORD, the God of my master Abraham, who had led me in the right way to take my master’s brother’s daughter for his son. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Now if you will deal kindly and truly with my master, tell me. If not, tell me, that I may turn to the right hand, or to the left.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Laban and Bethuel answered, “The thing proceeds from the LORD. We can’t speak to you bad or good. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Behold, Rebekah is before you. Take her, and go, and let her be your master’s son’s wife, as the LORD has spoken.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When Abraham’s servant heard their words, he bowed himself down to the earth to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","The servant brought out jewels of silver, and jewels of gold, and clothing, and gave them to Rebekah. He also gave precious things to her brother and her mother. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","They ate and drank, he and the men who were with him, and stayed all night. They rose up in the morning, and he said, “Send me away to my master.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Her brother and her mother said, “Let the young lady stay with us a few days, at least ten. After that she will go.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","He said to them, “Don’t hinder me, since the LORD has prospered my way. Send me away that I may go to my master.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","They said, “We will call the young lady, and ask her.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","They called Rebekah, and said to her, “Will you go with this man?” She said, “I will go.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","They sent away Rebekah, their sister, with her nurse, Abraham’s servant, and his men. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","They blessed Rebekah, and said to her, “Our sister, may you be the mother of thousands of ten thousands, and let your offspring possess the gate of those who hate them.” ");
INSERT INTO engwebpb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekah arose with her ladies. They rode on the camels, and followed the man. The servant took Rebekah, and went his way. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac came from the way of Beer Lahai Roi, for he lived in the land of the South. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaac went out to meditate in the field at the evening. He lifted up his eyes and looked. Behold, there were camels coming. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah lifted up her eyes, and when she saw Isaac, she got off the camel. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","She said to the servant, “Who is the man who is walking in the field to meet us?” The servant said, “It is my master.” She took her veil, and covered herself. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","The servant told Isaac all the things that he had done. ");
INSERT INTO engwebpb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac brought her into his mother Sarah’s tent, and took Rebekah, and she became his wife. He loved her. So Isaac was comforted after his mother’s death. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham took another wife, and her name was Keturah. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She bore him Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan became the father of Sheba, and Dedan. The sons of Dedan were Asshurim, Letushim, and Leummim. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","The sons of Midian were Ephah, Epher, Hanoch, Abida, and Eldaah. All these were the children of Keturah. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham gave all that he had to Isaac, ");
INSERT INTO engwebpb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","but Abraham gave gifts to the sons of Abraham’s concubines. While he still lived, he sent them away from Isaac his son, eastward, to the east country. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","These are the days of the years of Abraham’s life which he lived: one hundred and seventy-five years. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham gave up his spirit, and died at a good old age, an old man, and full of years, and was gathered to his people. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac and Ishmael, his sons, buried him in the cave of Machpelah, in the field of Ephron, the son of Zohar the Hittite, which is near Mamre, ");
INSERT INTO engwebpb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","the field which Abraham purchased from the children of Heth. Abraham was buried there with Sarah, his wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After the death of Abraham, God blessed Isaac, his son. Isaac lived by Beer Lahai Roi. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Now this is the history of the generations of Ishmael, Abraham’s son, whom Hagar the Egyptian, Sarah’s servant, bore to Abraham. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These are the names of the sons of Ishmael, by their names, according to the order of their birth: the firstborn of Ishmael, Nebaioth, then Kedar, Adbeel, Mibsam, ");
INSERT INTO engwebpb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engwebpb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These are the sons of Ishmael, and these are their names, by their villages, and by their encampments: twelve princes, according to their nations. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","These are the years of the life of Ishmael: one hundred and thirty-seven years. He gave up his spirit and died, and was gathered to his people. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","They lived from Havilah to Shur that is before Egypt, as you go towards Assyria. He lived opposite all his relatives. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","This is the history of the generations of Isaac, Abraham’s son. Abraham became the father of Isaac. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac was forty years old when he took Rebekah, the daughter of Bethuel the Syrian of Paddan Aram, the sister of Laban the Syrian, to be his wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac entreated the LORD for his wife, because she was barren. The LORD was entreated by him, and Rebekah his wife conceived. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","The children struggled together within her. She said, “If it is like this, why do I live?” She went to enquire of the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","The LORD said to her, “Two nations are in your womb. Two peoples will be separated from your body. The one people will be stronger than the other people. The elder will serve the younger.” ");
INSERT INTO engwebpb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When her days to be delivered were fulfilled, behold, there were twins in her womb. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first came out red all over, like a hairy garment. They named him Esau. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","After that, his brother came out, and his hand had hold on Esau’s heel. He was named Jacob. Isaac was sixty years old when she bore them. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","The boys grew. Esau was a skilful hunter, a man of the field. Jacob was a quiet man, living in tents. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Now Isaac loved Esau, because he ate his venison. Rebekah loved Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jacob boiled stew. Esau came in from the field, and he was famished. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau said to Jacob, “Please feed me with some of that red stew, for I am famished.” Therefore his name was called Edom. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob said, “First, sell me your birthright.” ");
INSERT INTO engwebpb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau said, “Behold, I am about to die. What good is the birthright to me?” ");
INSERT INTO engwebpb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob said, “Swear to me first.” He swore to him. He sold his birthright to Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob gave Esau bread and lentil stew. He ate and drank, rose up, and went his way. So Esau despised his birthright. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","There was a famine in the land, in addition to the first famine that was in the days of Abraham. Isaac went to Abimelech king of the Philistines, to Gerar. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","The LORD appeared to him, and said, “Don’t go down into Egypt. Live in the land I will tell you about. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Live in this land, and I will be with you, and will bless you. For I will give to you, and to your offspring, all these lands, and I will establish the oath which I swore to Abraham your father. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will multiply your offspring as the stars of the sky, and will give all these lands to your offspring. In your offspring all the nations of the earth will be blessed, ");
INSERT INTO engwebpb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","because Abraham obeyed my voice, and kept my requirements, my commandments, my statutes, and my laws.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac lived in Gerar. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","The men of the place asked him about his wife. He said, “She is my sister,” for he was afraid to say, “My wife”, lest, he thought, “the men of the place might kill me for Rebekah, because she is beautiful to look at.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","When he had been there a long time, Abimelech king of the Philistines looked out at a window, and saw, and, behold, Isaac was caressing Rebekah, his wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech called Isaac, and said, “Behold, surely she is your wife. Why did you say, ‘She is my sister’?” Isaac said to him, “Because I said, ‘Lest I die because of her.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech said, “What is this you have done to us? One of the people might easily have lain with your wife, and you would have brought guilt on us!” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelech commanded all the people, saying, “He who touches this man or his wife will surely be put to death.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac sowed in that land, and reaped in the same year one hundred times what he planted. The LORD blessed him. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","The man grew great, and grew more and more until he became very great. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He had possessions of flocks, possessions of herds, and a great household. The Philistines envied him. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Now all the wells which his father’s servants had dug in the days of Abraham his father, the Philistines had stopped, and filled with earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelech said to Isaac, “Go away from us, for you are much mightier than we.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac departed from there, encamped in the valley of Gerar, and lived there. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac dug again the wells of water, which they had dug in the days of Abraham his father, for the Philistines had stopped them after the death of Abraham. He called their names after the names by which his father had called them. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaac’s servants dug in the valley, and found there a well of flowing water. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","The herdsmen of Gerar argued with Isaac’s herdsmen, saying, “The water is ours.” So he called the name of the well Esek, because they contended with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","They dug another well, and they argued over that, also. So he called its name Sitnah. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","He left that place, and dug another well. They didn’t argue over that one. So he called it Rehoboth. He said, “For now the LORD has made room for us, and we will be fruitful in the land.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","He went up from there to Beersheba. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","The LORD appeared to him the same night, and said, “I am the God of Abraham your father. Don’t be afraid, for I am with you, and will bless you, and multiply your offspring for my servant Abraham’s sake.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","He built an altar there, and called on the LORD’s name, and pitched his tent there. There Isaac’s servants dug a well. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Then Abimelech went to him from Gerar with Ahuzzath his friend, and Phicol the captain of his army. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac said to them, “Why have you come to me, since you hate me, and have sent me away from you?” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","They said, “We saw plainly that the LORD was with you. We said, ‘Let there now be an oath between us, even between us and you, and let’s make a covenant with you, ");
INSERT INTO engwebpb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","that you will do us no harm, as we have not touched you, and as we have done to you nothing but good, and have sent you away in peace.’ You are now the blessed of the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","He made them a feast, and they ate and drank. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","They rose up some time in the morning, and swore an oath to one another. Isaac sent them away, and they departed from him in peace. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","The same day, Isaac’s servants came, and told him concerning the well which they had dug, and said to him, “We have found water.” ");
INSERT INTO engwebpb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","He called it “Shibah”. Therefore the name of the city is “Beersheba” to this day. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was forty years old, he took as wife Judith, the daughter of Beeri the Hittite, and Basemath, the daughter of Elon the Hittite. ");
INSERT INTO engwebpb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","They grieved Isaac’s and Rebekah’s spirits. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","When Isaac was old, and his eyes were dim, so that he could not see, he called Esau his elder son, and said to him, “My son?” He said to him, “Here I am.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","He said, “See now, I am old. I don’t know the day of my death. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Now therefore, please take your weapons, your quiver and your bow, and go out to the field, and get me venison. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Make me savoury food, such as I love, and bring it to me, that I may eat, and that my soul may bless you before I die.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah heard when Isaac spoke to Esau his son. Esau went to the field to hunt for venison, and to bring it. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah spoke to Jacob her son, saying, “Behold, I heard your father speak to Esau your brother, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bring me venison, and make me savoury food, that I may eat, and bless you before the LORD before my death.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now therefore, my son, obey my voice according to that which I command you. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go now to the flock and get me two good young goats from there. I will make them savoury food for your father, such as he loves. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","You shall bring it to your father, that he may eat, so that he may bless you before his death.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob said to Rebekah his mother, “Behold, Esau my brother is a hairy man, and I am a smooth man. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","What if my father touches me? I will seem to him as a deceiver, and I would bring a curse on myself, and not a blessing.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","His mother said to him, “Let your curse be on me, my son. Only obey my voice, and go get them for me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","He went, and got them, and brought them to his mother. His mother made savoury food, such as his father loved. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekah took the good clothes of Esau, her elder son, which were with her in the house, and put them on Jacob, her younger son. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She put the skins of the young goats on his hands, and on the smooth of his neck. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","She gave the savoury food and the bread, which she had prepared, into the hand of her son Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","He came to his father, and said, “My father?” He said, “Here I am. Who are you, my son?” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob said to his father, “I am Esau your firstborn. I have done what you asked me to do. Please arise, sit and eat of my venison, that your soul may bless me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac said to his son, “How is it that you have found it so quickly, my son?” He said, “Because the LORD your God gave me success.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac said to Jacob, “Please come near, that I may feel you, my son, whether you are really my son Esau or not.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob went near to Isaac his father. He felt him, and said, “The voice is Jacob’s voice, but the hands are the hands of Esau.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","He didn’t recognise him, because his hands were hairy, like his brother Esau’s hands. So he blessed him. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","He said, “Are you really my son Esau?” He said, “I am.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","He said, “Bring it near to me, and I will eat of my son’s venison, that my soul may bless you.” He brought it near to him, and he ate. He brought him wine, and he drank. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","His father Isaac said to him, “Come near now, and kiss me, my son.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","He came near, and kissed him. He smelled the smell of his clothing, and blessed him, and said, “Behold, the smell of my son is as the smell of a field which the LORD has blessed. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","God give you of the dew of the sky, of the fatness of the earth, and plenty of grain and new wine. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Let peoples serve you, and nations bow down to you. Be lord over your brothers. Let your mother’s sons bow down to you. Cursed be everyone who curses you. Blessed be everyone who blesses you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","As soon as Isaac had finished blessing Jacob, and Jacob had just gone out from the presence of Isaac his father, Esau his brother came in from his hunting. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","He also made savoury food, and brought it to his father. He said to his father, “Let my father arise, and eat of his son’s venison, that your soul may bless me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac his father said to him, “Who are you?” He said, “I am your son, your firstborn, Esau.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac trembled violently, and said, “Who, then, is he who has taken venison, and brought it to me, and I have eaten of all before you came, and have blessed him? Yes, he will be blessed.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard the words of his father, he cried with an exceedingly great and bitter cry, and said to his father, “Bless me, even me also, my father.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","He said, “Your brother came with deceit, and has taken away your blessing.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","He said, “Isn’t he rightly named Jacob? For he has supplanted me these two times. He took away my birthright. See, now he has taken away my blessing.” He said, “Haven’t you reserved a blessing for me?” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac answered Esau, “Behold, I have made him your lord, and all his brothers I have given to him for servants. I have sustained him with grain and new wine. What then will I do for you, my son?” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau said to his father, “Do you have just one blessing, my father? Bless me, even me also, my father.” Esau lifted up his voice, and wept. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac his father answered him, “Behold, your dwelling will be of the fatness of the earth, and of the dew of the sky from above. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You will live by your sword, and you will serve your brother. It will happen, when you will break loose, that you will shake his yoke from off your neck.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau hated Jacob because of the blessing with which his father blessed him. Esau said in his heart, “The days of mourning for my father are at hand. Then I will kill my brother Jacob.” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","The words of Esau, her elder son, were told to Rebekah. She sent and called Jacob, her younger son, and said to him, “Behold, your brother Esau comforts himself about you by planning to kill you. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Now therefore, my son, obey my voice. Arise, flee to Laban, my brother, in Haran. ");
INSERT INTO engwebpb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with him a few days, until your brother’s fury turns away— ");
INSERT INTO engwebpb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","until your brother’s anger turns away from you, and he forgets what you have done to him. Then I will send, and get you from there. Why should I be bereaved of you both in one day?” ");
INSERT INTO engwebpb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah said to Isaac, “I am weary of my life because of the daughters of Heth. If Jacob takes a wife of the daughters of Heth, such as these, of the daughters of the land, what good will my life do me?” ");
INSERT INTO engwebpb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac called Jacob, blessed him, and commanded him, “You shall not take a wife of the daughters of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Arise, go to Paddan Aram, to the house of Bethuel your mother’s father. Take a wife from there from the daughters of Laban, your mother’s brother. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","May God Almighty bless you, and make you fruitful, and multiply you, that you may be a company of peoples, ");
INSERT INTO engwebpb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","and give you the blessing of Abraham, to you and to your offspring with you, that you may inherit the land where you travel, which God gave to Abraham.” ");
INSERT INTO engwebpb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaac sent Jacob away. He went to Paddan Aram to Laban, son of Bethuel the Syrian, the brother of Rebekah, Jacob’s and Esau’s mother. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Now Esau saw that Isaac had blessed Jacob and sent him away to Paddan Aram, to take him a wife from there, and that as he blessed him he gave him a command, saying, “You shall not take a wife of the daughters of Canaan;” ");
INSERT INTO engwebpb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","and that Jacob obeyed his father and his mother, and was gone to Paddan Aram. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau saw that the daughters of Canaan didn’t please Isaac, his father. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","So Esau went to Ishmael, and took, in addition to the wives that he had, Mahalath the daughter of Ishmael, Abraham’s son, the sister of Nebaioth, to be his wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob went out from Beersheba, and went towards Haran. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","He came to a certain place, and stayed there all night, because the sun had set. He took one of the stones of the place, and put it under his head, and lay down in that place to sleep. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","He dreamt and saw a stairway set upon the earth, and its top reached to heaven. Behold, the angels of God were ascending and descending on it. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Behold, the LORD stood above it, and said, “I am the LORD, the God of Abraham your father, and the God of Isaac. I will give the land you lie on to you and to your offspring. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your offspring will be as the dust of the earth, and you will spread abroad to the west, and to the east, and to the north, and to the south. In you and in your offspring, all the families of the earth will be blessed. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Behold, I am with you, and will keep you, wherever you go, and will bring you again into this land. For I will not leave you until I have done that which I have spoken of to you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob awakened out of his sleep, and he said, “Surely the LORD is in this place, and I didn’t know it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","He was afraid, and said, “How awesome this place is! This is none other than God’s house, and this is the gate of heaven.” ");
INSERT INTO engwebpb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob rose up early in the morning, and took the stone that he had put under his head, and set it up for a pillar, and poured oil on its top. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","He called the name of that place Bethel, but the name of the city was Luz at the first. ");
INSERT INTO engwebpb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob vowed a vow, saying, “If God will be with me, and will keep me in this way that I go, and will give me bread to eat, and clothing to put on, ");
INSERT INTO engwebpb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","so that I come again to my father’s house in peace, and the LORD will be my God, ");
INSERT INTO engwebpb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","then this stone, which I have set up for a pillar, will be God’s house. Of all that you will give me I will surely give a tenth to you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Then Jacob went on his journey, and came to the land of the children of the east. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","He looked, and saw a well in the field, and saw three flocks of sheep lying there by it. For out of that well they watered the flocks. The stone on the well’s mouth was large. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","There all the flocks were gathered. They rolled the stone from the well’s mouth, and watered the sheep, and put the stone back on the well’s mouth in its place. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob said to them, “My relatives, where are you from?” They said, “We are from Haran.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","He said to them, “Do you know Laban, the son of Nahor?” They said, “We know him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","He said to them, “Is it well with him?” They said, “It is well. See, Rachel, his daughter, is coming with the sheep.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","He said, “Behold, it is still the middle of the day, not time to gather the livestock together. Water the sheep, and go and feed them.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","They said, “We can’t, until all the flocks are gathered together, and they roll the stone from the well’s mouth. Then we will water the sheep.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he was yet speaking with them, Rachel came with her father’s sheep, for she kept them. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","When Jacob saw Rachel the daughter of Laban, his mother’s brother, and the sheep of Laban, his mother’s brother, Jacob went near, and rolled the stone from the well’s mouth, and watered the flock of Laban his mother’s brother. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacob kissed Rachel, and lifted up his voice, and wept. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob told Rachel that he was her father’s relative, and that he was Rebekah’s son. She ran and told her father. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","When Laban heard the news of Jacob, his sister’s son, he ran to meet Jacob, and embraced him, and kissed him, and brought him to his house. Jacob told Laban all these things. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban said to him, “Surely you are my bone and my flesh.” Jacob stayed with him for a month. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban said to Jacob, “Because you are my relative, should you therefore serve me for nothing? Tell me, what will your wages be?” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban had two daughters. The name of the elder was Leah, and the name of the younger was Rachel. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah’s eyes were weak, but Rachel was beautiful in form and attractive. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob loved Rachel. He said, “I will serve you seven years for Rachel, your younger daughter.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban said, “It is better that I give her to you, than that I should give her to another man. Stay with me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob served seven years for Rachel. They seemed to him but a few days, for the love he had for her. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jacob said to Laban, “Give me my wife, for my days are fulfilled, that I may go in to her.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban gathered together all the men of the place, and made a feast. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","In the evening, he took Leah his daughter, and brought her to Jacob. He went in to her. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban gave Zilpah his servant to his daughter Leah for a servant. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","In the morning, behold, it was Leah! He said to Laban, “What is this you have done to me? Didn’t I serve with you for Rachel? Why then have you deceived me?” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban said, “It is not done so in our place, to give the younger before the firstborn. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Fulfil the week of this one, and we will give you the other also for the service which you will serve with me for seven more years.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob did so, and fulfilled her week. He gave him Rachel his daughter as wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban gave Bilhah, his servant, to his daughter Rachel to be her servant. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","He went in also to Rachel, and he loved also Rachel more than Leah, and served with him seven more years. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","The LORD saw that Leah was hated, and he opened her womb, but Rachel was barren. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah conceived, and bore a son, and she named him Reuben. For she said, “Because the LORD has looked at my affliction; for now my husband will love me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","She conceived again, and bore a son, and said, “Because the LORD has heard that I am hated, he has therefore given me this son also.” She named him Simeon. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","She conceived again, and bore a son. She said, “Now this time my husband will be joined to me, because I have borne him three sons.” Therefore his name was called Levi. ");
INSERT INTO engwebpb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","She conceived again, and bore a son. She said, “This time I will praise the LORD.” Therefore she named him Judah. Then she stopped bearing. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","When Rachel saw that she bore Jacob no children, Rachel envied her sister. She said to Jacob, “Give me children, or else I will die.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob’s anger burnt against Rachel, and he said, “Am I in God’s place, who has withheld from you the fruit of the womb?” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","She said, “Behold, my maid Bilhah. Go in to her, that she may bear on my knees, and I also may obtain children by her.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","She gave him Bilhah her servant as wife, and Jacob went in to her. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah conceived, and bore Jacob a son. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel said, “God has judged me, and has also heard my voice, and has given me a son.” Therefore she called his name Dan. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah, Rachel’s servant, conceived again, and bore Jacob a second son. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel said, “I have wrestled with my sister with mighty wrestlings, and have prevailed.” She named him Naphtali. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When Leah saw that she had finished bearing, she took Zilpah, her servant, and gave her to Jacob as a wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpah, Leah’s servant, bore Jacob a son. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “How fortunate!” She named him Gad. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpah, Leah’s servant, bore Jacob a second son. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “Happy am I, for the daughters will call me happy.” She named him Asher. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Reuben went in the days of wheat harvest, and found mandrakes in the field, and brought them to his mother, Leah. Then Rachel said to Leah, “Please give me some of your son’s mandrakes.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah said to her, “Is it a small matter that you have taken away my husband? Would you take away my son’s mandrakes, also?” Rachel said, “Therefore he will lie with you tonight for your son’s mandrakes.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jacob came from the field in the evening, and Leah went out to meet him, and said, “You must come in to me; for I have surely hired you with my son’s mandrakes.” He lay with her that night. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God listened to Leah, and she conceived, and bore Jacob a fifth son. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah said, “God has given me my hire, because I gave my servant to my husband.” She named him Issachar. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah conceived again, and bore a sixth son to Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah said, “God has endowed me with a good dowry. Now my husband will live with me, because I have borne him six sons.” She named him Zebulun. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Afterwards, she bore a daughter, and named her Dinah. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","God remembered Rachel, and God listened to her, and opened her womb. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She conceived, bore a son, and said, “God has taken away my reproach.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She named him Joseph, saying, “May the LORD add another son to me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","When Rachel had borne Joseph, Jacob said to Laban, “Send me away, that I may go to my own place, and to my country. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and my children for whom I have served you, and let me go; for you know my service with which I have served you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban said to him, “If now I have found favour in your eyes, stay here, for I have divined that the LORD has blessed me for your sake.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","He said, “Appoint me your wages, and I will give it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob said to him, “You know how I have served you, and how your livestock have fared with me. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","For it was little which you had before I came, and it has increased to a multitude. The LORD has blessed you wherever I turned. Now when will I provide for my own house also?” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban said, “What shall I give you?” Jacob said, “You shall not give me anything. If you will do this thing for me, I will again feed your flock and keep it. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I will pass through all your flock today, removing from there every speckled and spotted one, and every black one amongst the sheep, and the spotted and speckled amongst the goats. This will be my hire. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","So my righteousness will answer for me hereafter, when you come concerning my hire that is before you. Every one that is not speckled and spotted amongst the goats, and black amongst the sheep, that might be with me, will be considered stolen.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban said, “Behold, let it be according to your word.” ");
INSERT INTO engwebpb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","That day, he removed the male goats that were streaked and spotted, and all the female goats that were speckled and spotted, every one that had white in it, and all the black ones amongst the sheep, and gave them into the hand of his sons. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","He set three days’ journey between himself and Jacob, and Jacob fed the rest of Laban’s flocks. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob took to himself rods of fresh poplar, almond, and plane tree, peeled white streaks in them, and made the white appear which was in the rods. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","He set the rods which he had peeled opposite the flocks in the watering troughs where the flocks came to drink. They conceived when they came to drink. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","The flocks conceived before the rods, and the flocks produced streaked, speckled, and spotted. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob separated the lambs, and set the faces of the flocks towards the streaked and all the black in Laban’s flock. He put his own droves apart, and didn’t put them into Laban’s flock. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Whenever the stronger of the flock conceived, Jacob laid the rods in front of the eyes of the flock in the watering troughs, that they might conceive amongst the rods; ");
INSERT INTO engwebpb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","but when the flock were feeble, he didn’t put them in. So the feebler were Laban’s, and the stronger Jacob’s. ");
INSERT INTO engwebpb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","The man increased exceedingly, and had large flocks, female servants and male servants, and camels and donkeys. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob heard Laban’s sons’ words, saying, “Jacob has taken away all that was our father’s. He has obtained all this wealth from that which was our father’s.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob saw the expression on Laban’s face, and, behold, it was not towards him as before. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","The LORD said to Jacob, “Return to the land of your fathers, and to your relatives, and I will be with you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob sent and called Rachel and Leah to the field to his flock, ");
INSERT INTO engwebpb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","and said to them, “I see the expression on your father’s face, that it is not towards me as before; but the God of my father has been with me. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You know that I have served your father with all of my strength. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Your father has deceived me, and changed my wages ten times, but God didn’t allow him to hurt me. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said, ‘The speckled will be your wages,’ then all the flock bore speckled. If he said, ‘The streaked will be your wages,’ then all the flock bore streaked. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Thus God has taken away your father’s livestock, and given them to me. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","During mating season, I lifted up my eyes, and saw in a dream, and behold, the male goats which leapt on the flock were streaked, speckled, and grizzled. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","The angel of God said to me in the dream, ‘Jacob,’ and I said, ‘Here I am.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","He said, ‘Now lift up your eyes, and behold, all the male goats which leap on the flock are streaked, speckled, and grizzled, for I have seen all that Laban does to you. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Bethel, where you anointed a pillar, where you vowed a vow to me. Now arise, get out from this land, and return to the land of your birth.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel and Leah answered him, “Is there yet any portion or inheritance for us in our father’s house? ");
INSERT INTO engwebpb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aren’t we considered as foreigners by him? For he has sold us, and has also used up our money. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","For all the riches which God has taken away from our father are ours and our children’s. Now then, whatever God has said to you, do.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Then Jacob rose up, and set his sons and his wives on the camels, ");
INSERT INTO engwebpb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","and he took away all his livestock, and all his possessions which he had gathered, including the livestock which he had gained in Paddan Aram, to go to Isaac his father, to the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Now Laban had gone to shear his sheep; and Rachel stole the teraphim that were her father’s. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob deceived Laban the Syrian, in that he didn’t tell him that he was running away. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So he fled with all that he had. He rose up, passed over the River, and set his face towards the mountain of Gilead. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Laban was told on the third day that Jacob had fled. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","He took his relatives with him, and pursued him seven days’ journey. He overtook him in the mountain of Gilead. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","God came to Laban the Syrian in a dream of the night, and said to him, “Be careful that you don’t speak to Jacob either good or bad.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban caught up with Jacob. Now Jacob had pitched his tent in the mountain, and Laban with his relatives encamped in the mountain of Gilead. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban said to Jacob, “What have you done, that you have deceived me, and carried away my daughters like captives of the sword? ");
INSERT INTO engwebpb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you flee secretly, and deceive me, and didn’t tell me, that I might have sent you away with mirth and with songs, with tambourine and with harp; ");
INSERT INTO engwebpb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","and didn’t allow me to kiss my sons and my daughters? Now you have done foolishly. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","It is in the power of my hand to hurt you, but the God of your father spoke to me last night, saying, ‘Be careful that you don’t speak to Jacob either good or bad.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Now, you want to be gone, because you greatly longed for your father’s house, but why have you stolen my gods?” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob answered Laban, “Because I was afraid, for I said, ‘Lest you should take your daughters from me by force.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Anyone you find your gods with shall not live. Before our relatives, discern what is yours with me, and take it.” For Jacob didn’t know that Rachel had stolen them. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban went into Jacob’s tent, into Leah’s tent, and into the tent of the two female servants; but he didn’t find them. He went out of Leah’s tent, and entered into Rachel’s tent. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Now Rachel had taken the teraphim, put them in the camel’s saddle, and sat on them. Laban felt around all the tent, but didn’t find them. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","She said to her father, “Don’t let my lord be angry that I can’t rise up before you; for I’m having my period.” He searched, but didn’t find the teraphim. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob was angry, and argued with Laban. Jacob answered Laban, “What is my trespass? What is my sin, that you have hotly pursued me? ");
INSERT INTO engwebpb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Now that you have felt around in all my stuff, what have you found of all your household stuff? Set it here before my relatives and your relatives, that they may judge between us two. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“These twenty years I have been with you. Your ewes and your female goats have not cast their young, and I haven’t eaten the rams of your flocks. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","That which was torn of animals, I didn’t bring to you. I bore its loss. Of my hand you required it, whether stolen by day or stolen by night. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","This was my situation: in the day the drought consumed me, and the frost by night; and my sleep fled from my eyes. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","These twenty years I have been in your house. I served you fourteen years for your two daughters, and six years for your flock, and you have changed my wages ten times. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Unless the God of my father, the God of Abraham, and the fear of Isaac, had been with me, surely now you would have sent me away empty. God has seen my affliction and the labour of my hands, and rebuked you last night.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban answered Jacob, “The daughters are my daughters, the children are my children, the flocks are my flocks, and all that you see is mine! What can I do today to these my daughters, or to their children whom they have borne? ");
INSERT INTO engwebpb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Now come, let’s make a covenant, you and I. Let it be for a witness between me and you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob took a stone, and set it up for a pillar. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob said to his relatives, “Gather stones.” They took stones, and made a heap. They ate there by the heap. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban called it Jegar Sahadutha, but Jacob called it Galeed. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban said, “This heap is witness between me and you today.” Therefore it was named Galeed ");
INSERT INTO engwebpb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","and Mizpah, for he said, “The LORD watch between me and you, when we are absent one from another. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you afflict my daughters, or if you take wives in addition to my daughters, no man is with us; behold, God is witness between me and you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban said to Jacob, “See this heap, and see the pillar, which I have set between me and you. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","May this heap be a witness, and the pillar be a witness, that I will not pass over this heap to you, and that you will not pass over this heap and this pillar to me, for harm. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","The God of Abraham, and the God of Nahor, the God of their father, judge between us.” Then Jacob swore by the fear of his father, Isaac. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jacob offered a sacrifice in the mountain, and called his relatives to eat bread. They ate bread, and stayed all night in the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early in the morning, Laban rose up, and kissed his sons and his daughters, and blessed them. Laban departed and returned to his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob went on his way, and the angels of God met him. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When he saw them, Jacob said, “This is God’s army.” He called the name of that place Mahanaim. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob sent messengers in front of him to Esau, his brother, to the land of Seir, the field of Edom. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He commanded them, saying, “This is what you shall tell my lord, Esau: ‘This is what your servant, Jacob, says. I have lived as a foreigner with Laban, and stayed until now. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I have cattle, donkeys, flocks, male servants, and female servants. I have sent to tell my lord, that I may find favour in your sight.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The messengers returned to Jacob, saying, “We came to your brother Esau. He is coming to meet you, and four hundred men are with him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Then Jacob was greatly afraid and was distressed. He divided the people who were with him, along with the flocks, the herds, and the camels, into two companies. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","He said, “If Esau comes to the one company, and strikes it, then the company which is left will escape.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob said, “God of my father Abraham, and God of my father Isaac, the LORD, who said to me, ‘Return to your country, and to your relatives, and I will do you good,’ ");
INSERT INTO engwebpb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I am not worthy of the least of all the loving kindnesses, and of all the truth, which you have shown to your servant; for with just my staff I crossed over this Jordan; and now I have become two companies. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Please deliver me from the hand of my brother, from the hand of Esau; for I fear him, lest he come and strike me and the mothers with the children. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","You said, ‘I will surely do you good, and make your offspring as the sand of the sea, which can’t be counted because there are so many.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","He stayed there that night, and took from that which he had with him a present for Esau, his brother: ");
INSERT INTO engwebpb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","two hundred female goats and twenty male goats, two hundred ewes and twenty rams, ");
INSERT INTO engwebpb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","thirty milk camels and their colts, forty cows, ten bulls, twenty female donkeys and ten foals. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He delivered them into the hands of his servants, every herd by itself, and said to his servants, “Pass over before me, and put a space between herd and herd.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He commanded the foremost, saying, “When Esau, my brother, meets you, and asks you, saying, ‘Whose are you? Where are you going? Whose are these before you?’ ");
INSERT INTO engwebpb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Then you shall say, ‘They are your servant, Jacob’s. It is a present sent to my lord, Esau. Behold, he also is behind us.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He commanded also the second, and the third, and all that followed the herds, saying, “This is how you shall speak to Esau, when you find him. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You shall say, ‘Not only that, but behold, your servant, Jacob, is behind us.’” For, he said, “I will appease him with the present that goes before me, and afterward I will see his face. Perhaps he will accept me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So the present passed over before him, and he himself stayed that night in the camp. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","He rose up that night, and took his two wives, and his two servants, and his eleven sons, and crossed over the ford of the Jabbok. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","He took them, and sent them over the stream, and sent over that which he had. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob was left alone, and wrestled with a man there until the breaking of the day. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When he saw that he didn’t prevail against him, the man touched the hollow of his thigh, and the hollow of Jacob’s thigh was strained as he wrestled. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","The man said, “Let me go, for the day breaks.” Jacob said, “I won’t let you go unless you bless me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","He said to him, “What is your name?” He said, “Jacob”. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","He said, “Your name will no longer be called Jacob, but Israel; for you have fought with God and with men, and have prevailed.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob asked him, “Please tell me your name.” He said, “Why is it that you ask what my name is?” So he blessed him there. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob called the name of the place Peniel; for he said, “I have seen God face to face, and my life is preserved.” ");
INSERT INTO engwebpb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","The sun rose on him as he passed over Peniel, and he limped because of his thigh. ");
INSERT INTO engwebpb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Therefore the children of Israel don’t eat the sinew of the hip, which is on the hollow of the thigh, to this day, because he touched the hollow of Jacob’s thigh in the sinew of the hip. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob lifted up his eyes, and looked, and, behold, Esau was coming, and with him four hundred men. He divided the children between Leah, Rachel, and the two servants. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He put the servants and their children in front, Leah and her children after, and Rachel and Joseph at the rear. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","He himself passed over in front of them, and bowed himself to the ground seven times, until he came near to his brother. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau ran to meet him, embraced him, fell on his neck, kissed him, and they wept. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","He lifted up his eyes, and saw the women and the children; and said, “Who are these with you?” He said, “The children whom God has graciously given your servant.” ");
INSERT INTO engwebpb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the servants came near with their children, and they bowed themselves. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leah also and her children came near, and bowed themselves. After them, Joseph came near with Rachel, and they bowed themselves. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau said, “What do you mean by all this company which I met?” Jacob said, “To find favour in the sight of my lord.” ");
INSERT INTO engwebpb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau said, “I have enough, my brother; let that which you have be yours.” ");
INSERT INTO engwebpb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob said, “Please, no, if I have now found favour in your sight, then receive my present at my hand, because I have seen your face, as one sees the face of God, and you were pleased with me. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Please take the gift that I brought to you, because God has dealt graciously with me, and because I have enough.” He urged him, and he took it. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau said, “Let’s take our journey, and let’s go, and I will go before you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob said to him, “My lord knows that the children are tender, and that the flocks and herds with me have their young, and if they overdrive them one day, all the flocks will die. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Please let my lord pass over before his servant, and I will lead on gently, according to the pace of the livestock that are before me and according to the pace of the children, until I come to my lord to Seir.” ");
INSERT INTO engwebpb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau said, “Let me now leave with you some of the people who are with me.” He said, “Why? Let me find favour in the sight of my lord.” ");
INSERT INTO engwebpb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So Esau returned that day on his way to Seir. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob travelled to Succoth, built himself a house, and made shelters for his livestock. Therefore the name of the place is called Succoth. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob came in peace to the city of Shechem, which is in the land of Canaan, when he came from Paddan Aram; and encamped before the city. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","He bought the parcel of ground where he had spread his tent, at the hand of the children of Hamor, Shechem’s father, for one hundred pieces of money. ");
INSERT INTO engwebpb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","He erected an altar there, and called it El Elohe Israel. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dinah, the daughter of Leah, whom she bore to Jacob, went out to see the daughters of the land. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shechem the son of Hamor the Hivite, the prince of the land, saw her. He took her, lay with her, and humbled her. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","His soul joined to Dinah, the daughter of Jacob, and he loved the young lady, and spoke kindly to the young lady. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shechem spoke to his father, Hamor, saying, “Get me this young lady as a wife.” ");
INSERT INTO engwebpb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Now Jacob heard that he had defiled Dinah, his daughter; and his sons were with his livestock in the field. Jacob held his peace until they came. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor the father of Shechem went out to Jacob to talk with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","The sons of Jacob came in from the field when they heard it. The men were grieved, and they were very angry, because he had done folly in Israel in lying with Jacob’s daughter, a thing that ought not to be done. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor talked with them, saying, “The soul of my son, Shechem, longs for your daughter. Please give her to him as a wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Make marriages with us. Give your daughters to us, and take our daughters for yourselves. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You shall dwell with us, and the land will be before you. Live and trade in it, and get possessions in it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shechem said to her father and to her brothers, “Let me find favour in your eyes, and whatever you will tell me I will give. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ask me a great amount for a dowry, and I will give whatever you ask of me, but give me the young lady as a wife.” ");
INSERT INTO engwebpb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","The sons of Jacob answered Shechem and Hamor his father with deceit when they spoke, because he had defiled Dinah their sister, ");
INSERT INTO engwebpb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","and said to them, “We can’t do this thing, to give our sister to one who is uncircumcised; for that is a reproach to us. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Only on this condition will we consent to you. If you will be as we are, that every male of you be circumcised, ");
INSERT INTO engwebpb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","then will we give our daughters to you; and we will take your daughters to us, and we will dwell with you, and we will become one people. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you will not listen to us and be circumcised, then we will take our sister, and we will be gone.” ");
INSERT INTO engwebpb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Their words pleased Hamor and Shechem, Hamor’s son. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","The young man didn’t wait to do this thing, because he had delight in Jacob’s daughter, and he was honoured above all the house of his father. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor and Shechem, his son, came to the gate of their city, and talked with the men of their city, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These men are peaceful with us. Therefore let them live in the land and trade in it. For behold, the land is large enough for them. Let’s take their daughters to us for wives, and let’s give them our daughters. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Only on this condition will the men consent to us to live with us, to become one people, if every male amongst us is circumcised, as they are circumcised. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Won’t their livestock and their possessions and all their animals be ours? Only let’s give our consent to them, and they will dwell with us.” ");
INSERT INTO engwebpb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","All who went out of the gate of his city listened to Hamor, and to Shechem his son; and every male was circumcised, all who went out of the gate of his city. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","On the third day, when they were sore, two of Jacob’s sons, Simeon and Levi, Dinah’s brothers, each took his sword, came upon the unsuspecting city, and killed all the males. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They killed Hamor and Shechem, his son, with the edge of the sword, and took Dinah out of Shechem’s house, and went away. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob’s sons came on the dead, and plundered the city, because they had defiled their sister. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took their flocks, their herds, their donkeys, that which was in the city, that which was in the field, ");
INSERT INTO engwebpb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","and all their wealth. They took captive all their little ones and their wives, and took as plunder everything that was in the house. ");
INSERT INTO engwebpb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob said to Simeon and Levi, “You have troubled me, to make me odious to the inhabitants of the land, amongst the Canaanites and the Perizzites. I am few in number. They will gather themselves together against me and strike me, and I will be destroyed, I and my house.” ");
INSERT INTO engwebpb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","They said, “Should he deal with our sister as with a prostitute?” ");
INSERT INTO engwebpb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","God said to Jacob, “Arise, go up to Bethel, and live there. Make there an altar to God, who appeared to you when you fled from the face of Esau your brother.” ");
INSERT INTO engwebpb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Then Jacob said to his household, and to all who were with him, “Put away the foreign gods that are amongst you, purify yourselves, and change your garments. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Let’s arise, and go up to Bethel. I will make there an altar to God, who answered me in the day of my distress, and was with me on the way which I went.” ");
INSERT INTO engwebpb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","They gave to Jacob all the foreign gods which were in their hands, and the rings which were in their ears; and Jacob hid them under the oak which was by Shechem. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","They travelled, and a terror of God was on the cities that were around them, and they didn’t pursue the sons of Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","So Jacob came to Luz (that is, Bethel), which is in the land of Canaan, he and all the people who were with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","He built an altar there, and called the place El Beth El; because there God was revealed to him, when he fled from the face of his brother. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, Rebekah’s nurse, died, and she was buried below Bethel under the oak; and its name was called Allon Bacuth. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","God appeared to Jacob again, when he came from Paddan Aram, and blessed him. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God said to him, “Your name is Jacob. Your name shall not be Jacob any more, but your name will be Israel.” He named him Israel. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","God said to him, “I am God Almighty. Be fruitful and multiply. A nation and a company of nations will be from you, and kings will come out of your body. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","The land which I gave to Abraham and Isaac, I will give it to you, and to your offspring after you I will give the land.” ");
INSERT INTO engwebpb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","God went up from him in the place where he spoke with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob set up a pillar in the place where he spoke with him, a pillar of stone. He poured out a drink offering on it, and poured oil on it. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob called the name of the place where God spoke with him “Bethel”. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","They travelled from Bethel. There was still some distance to come to Ephrath, and Rachel travailed. She had hard labour. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","When she was in hard labour, the midwife said to her, “Don’t be afraid, for now you will have another son.” ");
INSERT INTO engwebpb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","As her soul was departing (for she died), she named him Benoni, but his father named him Benjamin. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel died, and was buried on the way to Ephrath (also called Bethlehem). ");
INSERT INTO engwebpb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob set up a pillar on her grave. The same is the Pillar of Rachel’s grave to this day. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel travelled, and spread his tent beyond the tower of Eder. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","While Israel lived in that land, Reuben went and lay with Bilhah, his father’s concubine, and Israel heard of it. Now the sons of Jacob were twelve. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The sons of Leah: Reuben (Jacob’s firstborn), Simeon, Levi, Judah, Issachar, and Zebulun. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rachel: Joseph and Benjamin. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Bilhah (Rachel’s servant): Dan and Naphtali. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","The sons of Zilpah (Leah’s servant): Gad and Asher. These are the sons of Jacob, who were born to him in Paddan Aram. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob came to Isaac his father, to Mamre, to Kiriath Arba (which is Hebron), where Abraham and Isaac lived as foreigners. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","The days of Isaac were one hundred and eighty years. ");
INSERT INTO engwebpb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac gave up the spirit and died, and was gathered to his people, old and full of days. Esau and Jacob, his sons, buried him. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Now this is the history of the generations of Esau (that is, Edom). ");
INSERT INTO engwebpb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau took his wives from the daughters of Canaan: Adah the daughter of Elon, the Hittite; and Oholibamah the daughter of Anah, the daughter of Zibeon, the Hivite; ");
INSERT INTO engwebpb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","and Basemath, Ishmael’s daughter, sister of Nebaioth. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah bore to Esau Eliphaz. Basemath bore Reuel. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah bore Jeush, Jalam, and Korah. These are the sons of Esau, who were born to him in the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau took his wives, his sons, his daughters, and all the members of his household, with his livestock, all his animals, and all his possessions, which he had gathered in the land of Canaan, and went into a land away from his brother Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","For their substance was too great for them to dwell together, and the land of their travels couldn’t bear them because of their livestock. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau lived in the hill country of Seir. Esau is Edom. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","This is the history of the generations of Esau the father of the Edomites in the hill country of Seir: ");
INSERT INTO engwebpb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","these are the names of Esau’s sons: Eliphaz, the son of Adah, the wife of Esau; and Reuel, the son of Basemath, the wife of Esau. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were Teman, Omar, Zepho, and Gatam, and Kenaz. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna was concubine to Eliphaz, Esau’s son; and she bore to Eliphaz Amalek. These are the descendants of Adah, Esau’s wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","These are the sons of Reuel: Nahath, Zerah, Shammah, and Mizzah. These were the descendants of Basemath, Esau’s wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","These were the sons of Oholibamah, the daughter of Anah, the daughter of Zibeon, Esau’s wife: she bore to Esau Jeush, Jalam, and Korah. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These are the chiefs of the sons of Esau: the sons of Eliphaz the firstborn of Esau: chief Teman, chief Omar, chief Zepho, chief Kenaz, ");
INSERT INTO engwebpb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","chief Korah, chief Gatam, chief Amalek. These are the chiefs who came of Eliphaz in the land of Edom. These are the sons of Adah. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","These are the sons of Reuel, Esau’s son: chief Nahath, chief Zerah, chief Shammah, chief Mizzah. These are the chiefs who came of Reuel in the land of Edom. These are the sons of Basemath, Esau’s wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","These are the sons of Oholibamah, Esau’s wife: chief Jeush, chief Jalam, chief Korah. These are the chiefs who came of Oholibamah the daughter of Anah, Esau’s wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These are the sons of Esau (that is, Edom), and these are their chiefs. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These are the sons of Seir the Horite, the inhabitants of the land: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engwebpb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. These are the chiefs who came of the Horites, the children of Seir in the land of Edom. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The children of Lotan were Hori and Heman. Lotan’s sister was Timna. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","These are the children of Shobal: Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","These are the children of Zibeon: Aiah and Anah. This is Anah who found the hot springs in the wilderness, as he fed the donkeys of Zibeon his father. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","These are the children of Anah: Dishon and Oholibamah, the daughter of Anah. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","These are the children of Dishon: Hemdan, Eshban, Ithran, and Cheran. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These are the children of Ezer: Bilhan, Zaavan, and Akan. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These are the children of Dishan: Uz and Aran. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are the chiefs who came of the Horites: chief Lotan, chief Shobal, chief Zibeon, chief Anah, ");
INSERT INTO engwebpb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","chief Dishon, chief Ezer, and chief Dishan. These are the chiefs who came of the Horites, according to their chiefs in the land of Seir. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","These are the kings who reigned in the land of Edom, before any king reigned over the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, the son of Beor, reigned in Edom. The name of his city was Dinhabah. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela died, and Jobab, the son of Zerah of Bozrah, reigned in his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab died, and Husham of the land of the Temanites reigned in his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham died, and Hadad, the son of Bedad, who struck Midian in the field of Moab, reigned in his place. The name of his city was Avith. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad died, and Samlah of Masrekah reigned in his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah died, and Shaul of Rehoboth by the river, reigned in his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaul died, and Baal Hanan the son of Achbor reigned in his place. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Hanan the son of Achbor died, and Hadar reigned in his place. The name of his city was Pau. His wife’s name was Mehetabel, the daughter of Matred, the daughter of Mezahab. ");
INSERT INTO engwebpb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","These are the names of the chiefs who came from Esau, according to their families, after their places, and by their names: chief Timna, chief Alvah, chief Jetheth, ");
INSERT INTO engwebpb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","chief Oholibamah, chief Elah, chief Pinon, ");
INSERT INTO engwebpb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","chief Kenaz, chief Teman, chief Mibzar, ");
INSERT INTO engwebpb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","chief Magdiel, and chief Iram. These are the chiefs of Edom, according to their habitations in the land of their possession. This is Esau, the father of the Edomites. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob lived in the land of his father’s travels, in the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","This is the history of the generations of Jacob. Joseph, being seventeen years old, was feeding the flock with his brothers. He was a boy with the sons of Bilhah and Zilpah, his father’s wives. Joseph brought an evil report of them to their father. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Now Israel loved Joseph more than all his children, because he was the son of his old age, and he made him a tunic of many colours. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","His brothers saw that their father loved him more than all his brothers, and they hated him, and couldn’t speak peaceably to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph dreamt a dream, and he told it to his brothers, and they hated him all the more. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","He said to them, “Please hear this dream which I have dreamt: ");
INSERT INTO engwebpb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","for behold, we were binding sheaves in the field, and behold, my sheaf arose and also stood upright; and behold, your sheaves came around, and bowed down to my sheaf.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","His brothers asked him, “Will you indeed reign over us? Will you indeed have dominion over us?” They hated him all the more for his dreams and for his words. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","He dreamt yet another dream, and told it to his brothers, and said, “Behold, I have dreamt yet another dream: and behold, the sun and the moon and eleven stars bowed down to me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","He told it to his father and to his brothers. His father rebuked him, and said to him, “What is this dream that you have dreamt? Will I and your mother and your brothers indeed come to bow ourselves down to the earth before you?” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","His brothers envied him, but his father kept this saying in mind. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","His brothers went to feed their father’s flock in Shechem. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel said to Joseph, “Aren’t your brothers feeding the flock in Shechem? Come, and I will send you to them.” He said to him, “Here I am.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","He said to him, “Go now, see whether it is well with your brothers, and well with the flock; and bring me word again.” So he sent him out of the valley of Hebron, and he came to Shechem. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","A certain man found him, and behold, he was wandering in the field. The man asked him, “What are you looking for?” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","He said, “I am looking for my brothers. Tell me, please, where they are feeding the flock.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","The man said, “They have left here, for I heard them say, ‘Let’s go to Dothan.’” Joseph went after his brothers, and found them in Dothan. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","They saw him afar off, and before he came near to them, they conspired against him to kill him. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","They said to one another, “Behold, this dreamer comes. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Come now therefore, and let’s kill him, and cast him into one of the pits, and we will say, ‘An evil animal has devoured him.’ We will see what will become of his dreams.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben heard it, and delivered him out of their hand, and said, “Let’s not take his life.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben said to them, “Shed no blood. Throw him into this pit that is in the wilderness, but lay no hand on him”—that he might deliver him out of their hand, to restore him to his father. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","When Joseph came to his brothers, they stripped Joseph of his tunic, the tunic of many colours that was on him; ");
INSERT INTO engwebpb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","and they took him, and threw him into the pit. The pit was empty. There was no water in it. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","They sat down to eat bread, and they lifted up their eyes and looked, and saw a caravan of Ishmaelites coming from Gilead, with their camels bearing spices and balm and myrrh, going to carry it down to Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah said to his brothers, “What profit is it if we kill our brother and conceal his blood? ");
INSERT INTO engwebpb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, and let’s sell him to the Ishmaelites, and not let our hand be on him; for he is our brother, our flesh.” His brothers listened to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midianites who were merchants passed by, and they drew and lifted up Joseph out of the pit, and sold Joseph to the Ishmaelites for twenty pieces of silver. The merchants brought Joseph into Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben returned to the pit, and saw that Joseph wasn’t in the pit; and he tore his clothes. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","He returned to his brothers, and said, “The child is no more; and I, where will I go?” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","They took Joseph’s tunic, and killed a male goat, and dipped the tunic in the blood. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","They took the tunic of many colours, and they brought it to their father, and said, “We have found this. Examine it, now, and see if it is your son’s tunic or not.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","He recognised it, and said, “It is my son’s tunic. An evil animal has devoured him. Joseph is without doubt torn in pieces.” ");
INSERT INTO engwebpb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob tore his clothes, and put sackcloth on his waist, and mourned for his son many days. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All his sons and all his daughters rose up to comfort him, but he refused to be comforted. He said, “For I will go down to Sheol to my son, mourning.” His father wept for him. ");
INSERT INTO engwebpb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","The Midianites sold him into Egypt to Potiphar, an officer of Pharaoh’s, the captain of the guard. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","At that time, Judah went down from his brothers, and visited a certain Adullamite, whose name was Hirah. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","There, Judah saw the daughter of a certain Canaanite man named Shua. He took her, and went in to her. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","She conceived, and bore a son; and he named him Er. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","She conceived again, and bore a son; and she named him Onan. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","She yet again bore a son, and named him Shelah. He was at Chezib when she bore him. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah took a wife for Er, his firstborn, and her name was Tamar. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, Judah’s firstborn, was wicked in the LORD’s sight. So the LORD killed him. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judah said to Onan, “Go in to your brother’s wife, and perform the duty of a husband’s brother to her, and raise up offspring for your brother.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan knew that the offspring wouldn’t be his; and when he went in to his brother’s wife, he spilled his semen on the ground, lest he should give offspring to his brother. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","The thing which he did was evil in the LORD’s sight, and he killed him also. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to Tamar, his daughter-in-law, “Remain a widow in your father’s house, until Shelah, my son, is grown up;” for he said, “Lest he also die, like his brothers.” Tamar went and lived in her father’s house. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","After many days, Shua’s daughter, the wife of Judah, died. Judah was comforted, and went up to his sheep shearers to Timnah, he and his friend Hirah, the Adullamite. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar was told, “Behold, your father-in-law is going up to Timnah to shear his sheep.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","She took off the garments of her widowhood, and covered herself with her veil, and wrapped herself, and sat in the gate of Enaim, which is on the way to Timnah; for she saw that Shelah was grown up, and she wasn’t given to him as a wife. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Judah saw her, he thought that she was a prostitute, for she had covered her face. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","He turned to her by the way, and said, “Please come, let me come in to you,” for he didn’t know that she was his daughter-in-law. She said, “What will you give me, that you may come in to me?” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","He said, “I will send you a young goat from the flock.” She said, “Will you give me a pledge, until you send it?” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","He said, “What pledge will I give you?” She said, “Your signet and your cord, and your staff that is in your hand.” He gave them to her, and came in to her, and she conceived by him. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","She arose, and went away, and put off her veil from her, and put on the garments of her widowhood. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah sent the young goat by the hand of his friend, the Adullamite, to receive the pledge from the woman’s hand, but he didn’t find her. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Then he asked the men of her place, saying, “Where is the prostitute, that was at Enaim by the road?” They said, “There has been no prostitute here.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","He returned to Judah, and said, “I haven’t found her; and also the men of the place said, ‘There has been no prostitute here.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah said, “Let her keep it, lest we be shamed. Behold, I sent this young goat, and you haven’t found her.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","About three months later, Judah was told, “Tamar, your daughter-in-law, has played the prostitute. Moreover, behold, she is with child by prostitution.” Judah said, “Bring her out, and let her be burnt.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","When she was brought out, she sent to her father-in-law, saying, “I am with child by the man who owns these.” She also said, “Please discern whose these are—the signet, and the cords, and the staff.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah acknowledged them, and said, “She is more righteous than I, because I didn’t give her to Shelah, my son.” He knew her again no more. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","In the time of her travail, behold, twins were in her womb. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","When she travailed, one put out a hand, and the midwife took and tied a scarlet thread on his hand, saying, “This came out first.” ");
INSERT INTO engwebpb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","As he drew back his hand, behold, his brother came out, and she said, “Why have you made a breach for yourself?” Therefore his name was called Perez. ");
INSERT INTO engwebpb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Afterward his brother came out, who had the scarlet thread on his hand, and his name was called Zerah. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph was brought down to Egypt. Potiphar, an officer of Pharaoh’s, the captain of the guard, an Egyptian, bought him from the hand of the Ishmaelites that had brought him down there. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","The LORD was with Joseph, and he was a prosperous man. He was in the house of his master the Egyptian. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","His master saw that the LORD was with him, and that the LORD made all that he did prosper in his hand. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph found favour in his sight. He ministered to him, and Potiphar made him overseer over his house, and all that he had he put into his hand. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","From the time that he made him overseer in his house, and over all that he had, the LORD blessed the Egyptian’s house for Joseph’s sake. The LORD’s blessing was on all that he had, in the house and in the field. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","He left all that he had in Joseph’s hand. He didn’t concern himself with anything, except for the food which he ate. Joseph was well-built and handsome. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","After these things, his master’s wife set her eyes on Joseph; and she said, “Lie with me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he refused, and said to his master’s wife, “Behold, my master doesn’t know what is with me in the house, and he has put all that he has into my hand. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","No one is greater in this house than I am, and he has not kept back anything from me but you, because you are his wife. How then can I do this great wickedness, and sin against God?” ");
INSERT INTO engwebpb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","As she spoke to Joseph day by day, he didn’t listen to her, to lie by her, or to be with her. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","About this time, he went into the house to do his work, and there were none of the men of the house inside. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","She caught him by his garment, saying, “Lie with me!” He left his garment in her hand, and ran outside. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","When she saw that he had left his garment in her hand, and had run outside, ");
INSERT INTO engwebpb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","she called to the men of her house, and spoke to them, saying, “Behold, he has brought a Hebrew in to us to mock us. He came in to me to lie with me, and I cried with a loud voice. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","When he heard that I lifted up my voice and cried, he left his garment by me, and ran outside.” ");
INSERT INTO engwebpb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","She laid up his garment by her, until his master came home. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","She spoke to him according to these words, saying, “The Hebrew servant, whom you have brought to us, came in to me to mock me, ");
INSERT INTO engwebpb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","and as I lifted up my voice and cried, he left his garment by me, and ran outside.” ");
INSERT INTO engwebpb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","When his master heard the words of his wife, which she spoke to him, saying, “This is what your servant did to me,” his wrath was kindled. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joseph’s master took him, and put him into the prison, the place where the king’s prisoners were bound, and he was there in custody. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But the LORD was with Joseph, and showed kindness to him, and gave him favour in the sight of the keeper of the prison. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","The keeper of the prison committed to Joseph’s hand all the prisoners who were in the prison. Whatever they did there, he was responsible for it. ");
INSERT INTO engwebpb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The keeper of the prison didn’t look after anything that was under his hand, because the LORD was with him; and that which he did, the LORD made it prosper. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","After these things, the butler of the king of Egypt and his baker offended their lord, the king of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh was angry with his two officers, the chief cup bearer and the chief baker. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","He put them in custody in the house of the captain of the guard, into the prison, the place where Joseph was bound. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The captain of the guard assigned them to Joseph, and he took care of them. They stayed in prison many days. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","They both dreamt a dream, each man his dream, in one night, each man according to the interpretation of his dream, the cup bearer and the baker of the king of Egypt, who were bound in the prison. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Joseph came in to them in the morning, and saw them, and saw that they were sad. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","He asked Pharaoh’s officers who were with him in custody in his master’s house, saying, “Why do you look so sad today?” ");
INSERT INTO engwebpb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","They said to him, “We have dreamt a dream, and there is no one who can interpret it.” Joseph said to them, “Don’t interpretations belong to God? Please tell it to me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","The chief cup bearer told his dream to Joseph, and said to him, “In my dream, behold, a vine was in front of me, ");
INSERT INTO engwebpb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","and in the vine were three branches. It was as though it budded, it blossomed, and its clusters produced ripe grapes. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh’s cup was in my hand; and I took the grapes, and pressed them into Pharaoh’s cup, and I gave the cup into Pharaoh’s hand.” ");
INSERT INTO engwebpb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph said to him, “This is its interpretation: the three branches are three days. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Within three more days, Pharaoh will lift up your head, and restore you to your office. You will give Pharaoh’s cup into his hand, the way you did when you were his cup bearer. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But remember me when it is well with you. Please show kindness to me, and make mention of me to Pharaoh, and bring me out of this house. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","For indeed, I was stolen away out of the land of the Hebrews, and here also I have done nothing that they should put me into the dungeon.” ");
INSERT INTO engwebpb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the chief baker saw that the interpretation was good, he said to Joseph, “I also was in my dream, and behold, three baskets of white bread were on my head. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the uppermost basket there were all kinds of baked food for Pharaoh, and the birds ate them out of the basket on my head.” ");
INSERT INTO engwebpb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph answered, “This is its interpretation. The three baskets are three days. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Within three more days, Pharaoh will lift up your head from off you, and will hang you on a tree; and the birds will eat your flesh from off you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","On the third day, which was Pharaoh’s birthday, he made a feast for all his servants, and he lifted up the head of the chief cup bearer and the head of the chief baker amongst his servants. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He restored the chief cup bearer to his position again, and he gave the cup into Pharaoh’s hand; ");
INSERT INTO engwebpb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","but he hanged the chief baker, as Joseph had interpreted to them. ");
INSERT INTO engwebpb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yet the chief cup bearer didn’t remember Joseph, but forgot him. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","At the end of two full years, Pharaoh dreamt, and behold, he stood by the river. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Behold, seven cattle came up out of the river. They were sleek and fat, and they fed in the marsh grass. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Behold, seven other cattle came up after them out of the river, ugly and thin, and stood by the other cattle on the brink of the river. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","The ugly and thin cattle ate up the seven sleek and fat cattle. So Pharaoh awoke. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","He slept and dreamt a second time; and behold, seven heads of grain came up on one stalk, healthy and good. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Behold, seven heads of grain, thin and blasted with the east wind, sprung up after them. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","The thin heads of grain swallowed up the seven healthy and full ears. Pharaoh awoke, and behold, it was a dream. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","In the morning, his spirit was troubled, and he sent and called for all of Egypt’s magicians and wise men. Pharaoh told them his dreams, but there was no one who could interpret them to Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the chief cup bearer spoke to Pharaoh, saying, “I remember my faults today. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh was angry with his servants, and put me in custody in the house of the captain of the guard, with the chief baker. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","We dreamt a dream in one night, he and I. Each man dreamt according to the interpretation of his dream. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","There was with us there a young man, a Hebrew, servant to the captain of the guard, and we told him, and he interpreted to us our dreams. He interpreted to each man according to his dream. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","As he interpreted to us, so it was. He restored me to my office, and he hanged him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Then Pharaoh sent and called Joseph, and they brought him hastily out of the dungeon. He shaved himself, changed his clothing, and came in to Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I have dreamt a dream, and there is no one who can interpret it. I have heard it said of you, that when you hear a dream you can interpret it.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph answered Pharaoh, saying, “It isn’t in me. God will give Pharaoh an answer of peace.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharaoh spoke to Joseph, “In my dream, behold, I stood on the brink of the river; ");
INSERT INTO engwebpb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","and behold, seven fat and sleek cattle came up out of the river. They fed in the marsh grass; ");
INSERT INTO engwebpb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","and behold, seven other cattle came up after them, poor and very ugly and thin, such as I never saw in all the land of Egypt for ugliness. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","The thin and ugly cattle ate up the first seven fat cattle; ");
INSERT INTO engwebpb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","and when they had eaten them up, it couldn’t be known that they had eaten them, but they were still ugly, as at the beginning. So I awoke. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I saw in my dream, and behold, seven heads of grain came up on one stalk, full and good; ");
INSERT INTO engwebpb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","and behold, seven heads of grain, withered, thin, and blasted with the east wind, sprung up after them. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","The thin heads of grain swallowed up the seven good heads of grain. I told it to the magicians, but there was no one who could explain it to me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph said to Pharaoh, “The dream of Pharaoh is one. What God is about to do he has declared to Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cattle are seven years; and the seven good heads of grain are seven years. The dream is one. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","The seven thin and ugly cattle that came up after them are seven years, and also the seven empty heads of grain blasted with the east wind; they will be seven years of famine. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","That is the thing which I have spoken to Pharaoh. God has shown Pharaoh what he is about to do. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Behold, seven years of great plenty throughout all the land of Egypt are coming. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Seven years of famine will arise after them, and all the plenty will be forgotten in the land of Egypt. The famine will consume the land, ");
INSERT INTO engwebpb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","and the plenty will not be known in the land by reason of that famine which follows; for it will be very grievous. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","The dream was doubled to Pharaoh, because the thing is established by God, and God will shortly bring it to pass. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Now therefore let Pharaoh look for a discreet and wise man, and set him over the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Let Pharaoh do this, and let him appoint overseers over the land, and take up the fifth part of the land of Egypt’s produce in the seven plenteous years. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Let them gather all the food of these good years that come, and store grain under the hand of Pharaoh for food in the cities, and let them keep it. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","The food will be to supply the land against the seven years of famine, which will be in the land of Egypt; so that the land will not perish through the famine.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","The thing was good in the eyes of Pharaoh, and in the eyes of all his servants. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pharaoh said to his servants, “Can we find such a one as this, a man in whom is the Spirit of God?” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pharaoh said to Joseph, “Because God has shown you all of this, there is no one so discreet and wise as you. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","You shall be over my house. All my people will be ruled according to your word. Only in the throne I will be greater than you.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaoh said to Joseph, “Behold, I have set you over all the land of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaoh took off his signet ring from his hand, and put it on Joseph’s hand, and arrayed him in robes of fine linen, and put a gold chain about his neck. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","He made him ride in the second chariot which he had. They cried before him, “Bow the knee!” He set him over all the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaoh said to Joseph, “I am Pharaoh. Without you, no man shall lift up his hand or his foot in all the land of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaoh called Joseph’s name Zaphenath-Paneah. He gave him Asenath, the daughter of Potiphera priest of On as a wife. Joseph went out over the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph was thirty years old when he stood before Pharaoh king of Egypt. Joseph went out from the presence of Pharaoh, and went throughout all the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","In the seven plenteous years the earth produced abundantly. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","He gathered up all the food of the seven years which were in the land of Egypt, and laid up the food in the cities. He stored food in each city from the fields around that city. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph laid up grain as the sand of the sea, very much, until he stopped counting, for it was without number. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","To Joseph were born two sons before the year of famine came, whom Asenath, the daughter of Potiphera priest of On, bore to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph called the name of the firstborn Manasseh, “For”, he said, “God has made me forget all my toil, and all my father’s house.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","The name of the second, he called Ephraim: “For God has made me fruitful in the land of my affliction.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","The seven years of plenty, that were in the land of Egypt, came to an end. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","The seven years of famine began to come, just as Joseph had said. There was famine in all lands, but in all the land of Egypt there was bread. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","When all the land of Egypt was famished, the people cried to Pharaoh for bread, and Pharaoh said to all the Egyptians, “Go to Joseph. What he says to you, do.” ");
INSERT INTO engwebpb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","The famine was over all the surface of the earth. Joseph opened all the store houses, and sold to the Egyptians. The famine was severe in the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","All countries came into Egypt, to Joseph, to buy grain, because the famine was severe in all the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Now Jacob saw that there was grain in Egypt, and Jacob said to his sons, “Why do you look at one another?” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","He said, “Behold, I have heard that there is grain in Egypt. Go down there, and buy for us from there, so that we may live, and not die.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Joseph’s ten brothers went down to buy grain from Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Jacob didn’t send Benjamin, Joseph’s brother, with his brothers; for he said, “Lest perhaps harm happen to him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","The sons of Israel came to buy amongst those who came, for the famine was in the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph was the governor over the land. It was he who sold to all the people of the land. Joseph’s brothers came, and bowed themselves down to him with their faces to the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph saw his brothers, and he recognised them, but acted like a stranger to them, and spoke roughly with them. He said to them, “Where did you come from?” They said, “From the land of Canaan, to buy food.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph recognised his brothers, but they didn’t recognise him. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph remembered the dreams which he dreamt about them, and said to them, “You are spies! You have come to see the nakedness of the land.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","They said to him, “No, my lord, but your servants have come to buy food. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all one man’s sons; we are honest men. Your servants are not spies.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","He said to them, “No, but you have come to see the nakedness of the land!” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","They said, “We, your servants, are twelve brothers, the sons of one man in the land of Canaan; and behold, the youngest is today with our father, and one is no more.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph said to them, “It is like I told you, saying, ‘You are spies!’ ");
INSERT INTO engwebpb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","By this you shall be tested. By the life of Pharaoh, you shall not go out from here, unless your youngest brother comes here. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of you, and let him get your brother, and you shall be bound, that your words may be tested, whether there is truth in you, or else by the life of Pharaoh surely you are spies.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","He put them all together into custody for three days. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Joseph said to them the third day, “Do this, and live, for I fear God. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are honest men, then let one of your brothers be bound in your prison; but you go, carry grain for the famine of your houses. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bring your youngest brother to me; so will your words be verified, and you won’t die.” They did so. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","They said to one another, “We are certainly guilty concerning our brother, in that we saw the distress of his soul, when he begged us, and we wouldn’t listen. Therefore this distress has come upon us.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben answered them, saying, “Didn’t I tell you, saying, ‘Don’t sin against the child,’ and you wouldn’t listen? Therefore also, behold, his blood is required.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","They didn’t know that Joseph understood them; for there was an interpreter between them. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","He turned himself away from them, and wept. Then he returned to them, and spoke to them, and took Simeon from amongst them, and bound him before their eyes. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Joseph gave a command to fill their bags with grain, and to restore each man’s money into his sack, and to give them food for the way. So it was done to them. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","They loaded their donkeys with their grain, and departed from there. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","As one of them opened his sack to give his donkey food in the lodging place, he saw his money. Behold, it was in the mouth of his sack. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He said to his brothers, “My money is restored! Behold, it is in my sack!” Their hearts failed them, and they turned trembling to one another, saying, “What is this that God has done to us?” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","They came to Jacob their father, to the land of Canaan, and told him all that had happened to them, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“The man, the lord of the land, spoke roughly with us, and took us for spies of the country. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","We said to him, ‘We are honest men. We are no spies. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are twelve brothers, sons of our father; one is no more, and the youngest is today with our father in the land of Canaan.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","The man, the lord of the land, said to us, ‘By this I will know that you are honest men: leave one of your brothers with me, and take grain for the famine of your houses, and go your way. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bring your youngest brother to me. Then I will know that you are not spies, but that you are honest men. So I will deliver your brother to you, and you shall trade in the land.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","As they emptied their sacks, behold, each man’s bundle of money was in his sack. When they and their father saw their bundles of money, they were afraid. ");
INSERT INTO engwebpb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, their father, said to them, “You have bereaved me of my children! Joseph is no more, Simeon is no more, and you want to take Benjamin away. All these things are against me.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben spoke to his father, saying, “Kill my two sons, if I don’t bring him to you. Entrust him to my care, and I will bring him to you again.” ");
INSERT INTO engwebpb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","He said, “My son shall not go down with you; for his brother is dead, and he only is left. If harm happens to him along the way in which you go, then you will bring down my grey hairs with sorrow to Sheol.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","The famine was severe in the land. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","When they had eaten up the grain which they had brought out of Egypt, their father said to them, “Go again, buy us a little more food.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Judah spoke to him, saying, “The man solemnly warned us, saying, ‘You shall not see my face, unless your brother is with you.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you’ll send our brother with us, we’ll go down and buy you food; ");
INSERT INTO engwebpb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","but if you don’t send him, we won’t go down, for the man said to us, ‘You shall not see my face, unless your brother is with you.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel said, “Why did you treat me so badly, telling the man that you had another brother?” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","They said, “The man asked directly concerning ourselves, and concerning our relatives, saying, ‘Is your father still alive? Have you another brother?’ We just answered his questions. Is there any way we could know that he would say, ‘Bring your brother down’?” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah said to Israel, his father, “Send the boy with me, and we’ll get up and go, so that we may live, and not die, both we, and you, and also our little ones. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I’ll be collateral for him. From my hand will you require him. If I don’t bring him to you, and set him before you, then let me bear the blame forever; ");
INSERT INTO engwebpb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","for if we hadn’t delayed, surely we would have returned a second time by now.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Their father, Israel, said to them, “If it must be so, then do this: Take from the choice fruits of the land in your bags, and carry down a present for the man, a little balm, a little honey, spices and myrrh, nuts, and almonds; ");
INSERT INTO engwebpb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","and take double money in your hand, and take back the money that was returned in the mouth of your sacks. Perhaps it was an oversight. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take your brother also, get up, and return to the man. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","May God Almighty give you mercy before the man, that he may release to you your other brother and Benjamin. If I am bereaved of my children, I am bereaved.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","The men took that present, and they took double money in their hand, and Benjamin; and got up, went down to Egypt, and stood before Joseph. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin with them, he said to the steward of his house, “Bring the men into the house, and butcher an animal, and prepare; for the men will dine with me at noon.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The man did as Joseph commanded, and the man brought the men to Joseph’s house. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","The men were afraid, because they were brought to Joseph’s house; and they said, “Because of the money that was returned in our sacks the first time, we’re brought in; that he may seek occasion against us, attack us, and seize us as slaves, along with our donkeys.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","They came near to the steward of Joseph’s house, and they spoke to him at the door of the house, ");
INSERT INTO engwebpb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","and said, “Oh, my lord, we indeed came down the first time to buy food. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","When we came to the lodging place, we opened our sacks, and behold, each man’s money was in the mouth of his sack, our money in full weight. We have brought it back in our hand. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","We have brought down other money in our hand to buy food. We don’t know who put our money in our sacks.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","He said, “Peace be to you. Don’t be afraid. Your God, and the God of your father, has given you treasure in your sacks. I received your money.” He brought Simeon out to them. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","The man brought the men into Joseph’s house, and gave them water, and they washed their feet. He gave their donkeys fodder. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","They prepared the present for Joseph’s coming at noon, for they heard that they should eat bread there. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph came home, they brought him the present which was in their hand into the house, and bowed themselves down to the earth before him. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","He asked them of their welfare, and said, “Is your father well, the old man of whom you spoke? Is he yet alive?” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","They said, “Your servant, our father, is well. He is still alive.” They bowed down humbly. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","He lifted up his eyes, and saw Benjamin, his brother, his mother’s son, and said, “Is this your youngest brother, of whom you spoke to me?” He said, “God be gracious to you, my son.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph hurried, for his heart yearned over his brother; and he sought a place to weep. He entered into his room, and wept there. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","He washed his face, and came out. He controlled himself, and said, “Serve the meal.” ");
INSERT INTO engwebpb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","They served him by himself, and them by themselves, and the Egyptians who ate with him by themselves, because the Egyptians don’t eat with the Hebrews, for that is an abomination to the Egyptians. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","They sat before him, the firstborn according to his birthright, and the youngest according to his youth, and the men marvelled with one another. ");
INSERT INTO engwebpb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","He sent portions to them from before him, but Benjamin’s portion was five times as much as any of theirs. They drank, and were merry with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","He commanded the steward of his house, saying, “Fill the men’s sacks with food, as much as they can carry, and put each man’s money in his sack’s mouth. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Put my cup, the silver cup, in the sack’s mouth of the youngest, with his grain money.” He did according to the word that Joseph had spoken. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","As soon as the morning was light, the men were sent away, they and their donkeys. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","When they had gone out of the city, and were not yet far off, Joseph said to his steward, “Up, follow after the men. When you overtake them, ask them, ‘Why have you rewarded evil for good? ");
INSERT INTO engwebpb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Isn’t this that from which my lord drinks, and by which he indeed divines? You have done evil in so doing.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","He overtook them, and he spoke these words to them. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","They said to him, “Why does my lord speak such words as these? Far be it from your servants that they should do such a thing! ");
INSERT INTO engwebpb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Behold, the money, which we found in our sacks’ mouths, we brought again to you out of the land of Canaan. How then should we steal silver or gold out of your lord’s house? ");
INSERT INTO engwebpb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","With whomever of your servants it is found, let him die, and we also will be my lord’s slaves.” ");
INSERT INTO engwebpb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","He said, “Now also let it be according to your words. He with whom it is found will be my slave; and you will be blameless.” ");
INSERT INTO engwebpb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Then they hurried, and each man took his sack down to the ground, and each man opened his sack. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","He searched, beginning with the oldest, and ending at the youngest. The cup was found in Benjamin’s sack. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Then they tore their clothes, and each man loaded his donkey, and returned to the city. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah and his brothers came to Joseph’s house, and he was still there. They fell on the ground before him. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph said to them, “What deed is this that you have done? Don’t you know that such a man as I can indeed do divination?” ");
INSERT INTO engwebpb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah said, “What will we tell my lord? What will we speak? How will we clear ourselves? God has found out the iniquity of your servants. Behold, we are my lord’s slaves, both we and he also in whose hand the cup is found.” ");
INSERT INTO engwebpb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","He said, “Far be it from me that I should do so. The man in whose hand the cup is found, he will be my slave; but as for you, go up in peace to your father.” ");
INSERT INTO engwebpb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah came near to him, and said, “Oh, my lord, please let your servant speak a word in my lord’s ears, and don’t let your anger burn against your servant; for you are even as Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord asked his servants, saying, ‘Have you a father, or a brother?’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","We said to my lord, ‘We have a father, an old man, and a child of his old age, a little one; and his brother is dead, and he alone is left of his mother; and his father loves him.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","You said to your servants, ‘Bring him down to me, that I may set my eyes on him.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","We said to my lord, ‘The boy can’t leave his father, for if he should leave his father, his father would die.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","You said to your servants, ‘Unless your youngest brother comes down with you, you will see my face no more.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","When we came up to your servant my father, we told him the words of my lord. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Our father said, ‘Go again and buy us a little food.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","We said, ‘We can’t go down. If our youngest brother is with us, then we will go down: for we may not see the man’s face, unless our youngest brother is with us.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Your servant, my father, said to us, ‘You know that my wife bore me two sons. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","One went out from me, and I said, “Surely he is torn in pieces;” and I haven’t seen him since. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","If you take this one also from me, and harm happens to him, you will bring down my grey hairs with sorrow to Sheol.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Now therefore when I come to your servant my father, and the boy is not with us; since his life is bound up in the boy’s life; ");
INSERT INTO engwebpb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","it will happen, when he sees that the boy is no more, that he will die. Your servants will bring down the grey hairs of your servant, our father, with sorrow to Sheol. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","For your servant became collateral for the boy to my father, saying, ‘If I don’t bring him to you, then I will bear the blame to my father forever.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Now therefore, please let your servant stay instead of the boy, my lord’s slave; and let the boy go up with his brothers. ");
INSERT INTO engwebpb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how will I go up to my father, if the boy isn’t with me?—lest I see the evil that will come on my father.” ");
INSERT INTO engwebpb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Then Joseph couldn’t control himself before all those who stood before him, and he called out, “Cause everyone to go out from me!” No one else stood with him, while Joseph made himself known to his brothers. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","He wept aloud. The Egyptians heard, and the house of Pharaoh heard. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph said to his brothers, “I am Joseph! Does my father still live?” His brothers couldn’t answer him; for they were terrified at his presence. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph said to his brothers, “Come near to me, please.” They came near. He said, “I am Joseph, your brother, whom you sold into Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Now don’t be grieved, nor angry with yourselves, that you sold me here, for God sent me before you to preserve life. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For these two years the famine has been in the land, and there are yet five years, in which there will be no ploughing and no harvest. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God sent me before you to preserve for you a remnant in the earth, and to save you alive by a great deliverance. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So now it wasn’t you who sent me here, but God, and he has made me a father to Pharaoh, lord of all his house, and ruler over all the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hurry, and go up to my father, and tell him, ‘This is what your son Joseph says, “God has made me lord of all Egypt. Come down to me. Don’t wait. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You shall dwell in the land of Goshen, and you will be near to me, you, your children, your children’s children, your flocks, your herds, and all that you have. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","There I will provide for you; for there are yet five years of famine; lest you come to poverty, you, and your household, and all that you have.”’ ");
INSERT INTO engwebpb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Behold, your eyes see, and the eyes of my brother Benjamin, that it is my mouth that speaks to you. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","You shall tell my father of all my glory in Egypt, and of all that you have seen. You shall hurry and bring my father down here.” ");
INSERT INTO engwebpb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","He fell on his brother Benjamin’s neck and wept, and Benjamin wept on his neck. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","He kissed all his brothers, and wept on them. After that his brothers talked with him. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","The report of it was heard in Pharaoh’s house, saying, “Joseph’s brothers have come.” It pleased Pharaoh well, and his servants. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh said to Joseph, “Tell your brothers, ‘Do this: Load your animals, and go, travel to the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Take your father and your households, and come to me, and I will give you the good of the land of Egypt, and you will eat the fat of the land.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Now you are commanded to do this: Take wagons out of the land of Egypt for your little ones, and for your wives, and bring your father, and come. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Also, don’t concern yourselves about your belongings, for the good of all the land of Egypt is yours.” ");
INSERT INTO engwebpb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","The sons of Israel did so. Joseph gave them wagons, according to the commandment of Pharaoh, and gave them provision for the way. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","He gave each one of them changes of clothing, but to Benjamin he gave three hundred pieces of silver and five changes of clothing. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","He sent the following to his father: ten donkeys loaded with the good things of Egypt, and ten female donkeys loaded with grain and bread and provision for his father by the way. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","So he sent his brothers away, and they departed. He said to them, “See that you don’t quarrel on the way.” ");
INSERT INTO engwebpb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","They went up out of Egypt, and came into the land of Canaan, to Jacob their father. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","They told him, saying, “Joseph is still alive, and he is ruler over all the land of Egypt.” His heart fainted, for he didn’t believe them. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","They told him all the words of Joseph, which he had said to them. When he saw the wagons which Joseph had sent to carry him, the spirit of Jacob, their father, revived. ");
INSERT INTO engwebpb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel said, “It is enough. Joseph my son is still alive. I will go and see him before I die.” ");
INSERT INTO engwebpb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel travelled with all that he had, and came to Beersheba, and offered sacrifices to the God of his father, Isaac. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","God spoke to Israel in the visions of the night, and said, “Jacob, Jacob!” He said, “Here I am.” ");
INSERT INTO engwebpb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","He said, “I am God, the God of your father. Don’t be afraid to go down into Egypt, for there I will make of you a great nation. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with you into Egypt. I will also surely bring you up again. Joseph’s hand will close your eyes.” ");
INSERT INTO engwebpb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob rose up from Beersheba, and the sons of Israel carried Jacob, their father, their little ones, and their wives, in the wagons which Pharaoh had sent to carry him. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","They took their livestock, and their goods, which they had gotten in the land of Canaan, and came into Egypt—Jacob, and all his offspring with him, ");
INSERT INTO engwebpb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","his sons, and his sons’ sons with him, his daughters, and his sons’ daughters, and he brought all his offspring with him into Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","These are the names of the children of Israel, who came into Egypt, Jacob and his sons: Reuben, Jacob’s firstborn. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","The sons of Reuben: Hanoch, Pallu, Hezron, and Carmi. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","The sons of Simeon: Jemuel, Jamin, Ohad, Jachin, Zohar, and Shaul the son of a Canaanite woman. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","The sons of Levi: Gershon, Kohath, and Merari. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","The sons of Judah: Er, Onan, Shelah, Perez, and Zerah; but Er and Onan died in the land of Canaan. The sons of Perez were Hezron and Hamul. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","The sons of Issachar: Tola, Puvah, Iob, and Shimron. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","The sons of Zebulun: Sered, Elon, and Jahleel. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These are the sons of Leah, whom she bore to Jacob in Paddan Aram, with his daughter Dinah. All the souls of his sons and his daughters were thirty-three. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","The sons of Gad: Ziphion, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","The sons of Asher: Imnah, Ishvah, Ishvi, Beriah, and Serah their sister. The sons of Beriah: Heber and Malchiel. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are the sons of Zilpah, whom Laban gave to Leah, his daughter, and these she bore to Jacob, even sixteen souls. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Rachel, Jacob’s wife: Joseph and Benjamin. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","To Joseph in the land of Egypt were born Manasseh and Ephraim, whom Asenath, the daughter of Potiphera, priest of On, bore to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","The sons of Benjamin: Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, and Ard. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These are the sons of Rachel, who were born to Jacob: all the souls were fourteen. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","The son of Dan: Hushim. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","The sons of Naphtali: Jahzeel, Guni, Jezer, and Shillem. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These are the sons of Bilhah, whom Laban gave to Rachel, his daughter, and these she bore to Jacob: all the souls were seven. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All the souls who came with Jacob into Egypt, who were his direct offspring, in addition to Jacob’s sons’ wives, all the souls were sixty-six. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","The sons of Joseph, who were born to him in Egypt, were two souls. All the souls of the house of Jacob, who came into Egypt, were seventy. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob sent Judah before him to Joseph, to show the way before him to Goshen, and they came into the land of Goshen. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph prepared his chariot, and went up to meet Israel, his father, in Goshen. He presented himself to him, and fell on his neck, and wept on his neck a good while. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel said to Joseph, “Now let me die, since I have seen your face, that you are still alive.” ");
INSERT INTO engwebpb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph said to his brothers, and to his father’s house, “I will go up, and speak with Pharaoh, and will tell him, ‘My brothers, and my father’s house, who were in the land of Canaan, have come to me. ");
INSERT INTO engwebpb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","These men are shepherds, for they have been keepers of livestock, and they have brought their flocks, and their herds, and all that they have.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","It will happen, when Pharaoh summons you, and will say, ‘What is your occupation?’ ");
INSERT INTO engwebpb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","that you shall say, ‘Your servants have been keepers of livestock from our youth even until now, both we, and our fathers:’ that you may dwell in the land of Goshen; for every shepherd is an abomination to the Egyptians.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Then Joseph went in and told Pharaoh, and said, “My father and my brothers, with their flocks, their herds, and all that they own, have come out of the land of Canaan; and behold, they are in the land of Goshen.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","From amongst his brothers he took five men, and presented them to Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh said to his brothers, “What is your occupation?” They said to Pharaoh, “Your servants are shepherds, both we, and our fathers.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","They also said to Pharaoh, “We have come to live as foreigners in the land, for there is no pasture for your servants’ flocks. For the famine is severe in the land of Canaan. Now therefore, please let your servants dwell in the land of Goshen.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaoh spoke to Joseph, saying, “Your father and your brothers have come to you. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","The land of Egypt is before you. Make your father and your brothers dwell in the best of the land. Let them dwell in the land of Goshen. If you know any able men amongst them, then put them in charge of my livestock.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph brought in Jacob, his father, and set him before Pharaoh; and Jacob blessed Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaoh said to Jacob, “How old are you?” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob said to Pharaoh, “The years of my pilgrimage are one hundred and thirty years. The days of the years of my life have been few and evil. They have not attained to the days of the years of the life of my fathers in the days of their pilgrimage.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob blessed Pharaoh, and went out from the presence of Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph placed his father and his brothers, and gave them a possession in the land of Egypt, in the best of the land, in the land of Rameses, as Pharaoh had commanded. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph provided his father, his brothers, and all of his father’s household with bread, according to the sizes of their families. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","There was no bread in all the land; for the famine was very severe, so that the land of Egypt and the land of Canaan fainted by reason of the famine. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph gathered up all the money that was found in the land of Egypt, and in the land of Canaan, for the grain which they bought: and Joseph brought the money into Pharaoh’s house. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","When the money was all spent in the land of Egypt, and in the land of Canaan, all the Egyptians came to Joseph, and said, “Give us bread, for why should we die in your presence? For our money fails.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph said, “Give me your livestock; and I will give you food for your livestock, if your money is gone.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","They brought their livestock to Joseph, and Joseph gave them bread in exchange for the horses, and for the flocks, and for the herds, and for the donkeys: and he fed them with bread in exchange for all their livestock for that year. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","When that year was ended, they came to him the second year, and said to him, “We will not hide from my lord how our money is all spent, and the herds of livestock are my lord’s. There is nothing left in the sight of my lord, but our bodies, and our lands. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Why should we die before your eyes, both we and our land? Buy us and our land for bread, and we and our land will be servants to Pharaoh. Give us seed, that we may live, and not die, and that the land won’t be desolate.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph bought all the land of Egypt for Pharaoh, for every man of the Egyptians sold his field, because the famine was severe on them, and the land became Pharaoh’s. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","As for the people, he moved them to the cities from one end of the border of Egypt even to the other end of it. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Only he didn’t buy the land of the priests, for the priests had a portion from Pharaoh, and ate their portion which Pharaoh gave them. That is why they didn’t sell their land. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Then Joseph said to the people, “Behold, I have bought you and your land today for Pharaoh. Behold, here is seed for you, and you shall sow the land. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","It will happen at the harvests, that you shall give a fifth to Pharaoh, and four parts will be your own, for seed of the field, for your food, for them of your households, and for food for your little ones.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","They said, “You have saved our lives! Let us find favour in the sight of my lord, and we will be Pharaoh’s servants.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph made it a statute concerning the land of Egypt to this day, that Pharaoh should have the fifth. Only the land of the priests alone didn’t become Pharaoh’s. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel lived in the land of Egypt, in the land of Goshen; and they got themselves possessions therein, and were fruitful, and multiplied exceedingly. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in the land of Egypt seventeen years. So the days of Jacob, the years of his life, were one hundred and forty-seven years. ");
INSERT INTO engwebpb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","The time came near that Israel must die, and he called his son Joseph, and said to him, “If now I have found favour in your sight, please put your hand under my thigh, and deal kindly and truly with me. Please don’t bury me in Egypt, ");
INSERT INTO engwebpb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","but when I sleep with my fathers, you shall carry me out of Egypt, and bury me in their burying place.” Joseph said, “I will do as you have said.” ");
INSERT INTO engwebpb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israel said, “Swear to me,” and he swore to him. Then Israel bowed himself on the bed’s head. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","After these things, someone said to Joseph, “Behold, your father is sick.” He took with him his two sons, Manasseh and Ephraim. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Someone told Jacob, and said, “Behold, your son Joseph comes to you,” and Israel strengthened himself, and sat on the bed. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob said to Joseph, “God Almighty appeared to me at Luz in the land of Canaan, and blessed me, ");
INSERT INTO engwebpb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","and said to me, ‘Behold, I will make you fruitful, and multiply you, and I will make of you a company of peoples, and will give this land to your offspring after you for an everlasting possession.’ ");
INSERT INTO engwebpb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Now your two sons, who were born to you in the land of Egypt before I came to you into Egypt, are mine; Ephraim and Manasseh, even as Reuben and Simeon, will be mine. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Your offspring, whom you become the father of after them, will be yours. They will be called after the name of their brothers in their inheritance. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","As for me, when I came from Paddan, Rachel died beside me in the land of Canaan on the way, when there was still some distance to come to Ephrath, and I buried her there on the way to Ephrath (also called Bethlehem).” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel saw Joseph’s sons, and said, “Who are these?” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph said to his father, “They are my sons, whom God has given me here.” He said, “Please bring them to me, and I will bless them.” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now the eyes of Israel were dim for age, so that he couldn’t see well. Joseph brought them near to him; and he kissed them, and embraced them. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel said to Joseph, “I didn’t think I would see your face, and behold, God has let me see your offspring also.” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph brought them out from between his knees, and he bowed himself with his face to the earth. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph took them both, Ephraim in his right hand towards Israel’s left hand, and Manasseh in his left hand towards Israel’s right hand, and brought them near to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel stretched out his right hand, and laid it on Ephraim’s head, who was the younger, and his left hand on Manasseh’s head, guiding his hands knowingly, for Manasseh was the firstborn. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","He blessed Joseph, and said, “The God before whom my fathers Abraham and Isaac walked, the God who has fed me all my life long to this day, ");
INSERT INTO engwebpb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","the angel who has redeemed me from all evil, bless the lads, and let my name be named on them, and the name of my fathers Abraham and Isaac. Let them grow into a multitude upon the earth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","When Joseph saw that his father laid his right hand on the head of Ephraim, it displeased him. He held up his father’s hand, to remove it from Ephraim’s head to Manasseh’s head. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph said to his father, “Not so, my father, for this is the firstborn. Put your right hand on his head.” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","His father refused, and said, “I know, my son, I know. He also will become a people, and he also will be great. However, his younger brother will be greater than he, and his offspring will become a multitude of nations.” ");
INSERT INTO engwebpb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","He blessed them that day, saying, “Israel will bless in your name, saying, ‘God make you as Ephraim and as Manasseh’” He set Ephraim before Manasseh. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel said to Joseph, “Behold, I am dying, but God will be with you, and bring you again to the land of your fathers. ");
INSERT INTO engwebpb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Moreover I have given to you one portion above your brothers, which I took out of the hand of the Amorite with my sword and with my bow.” ");
INSERT INTO engwebpb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob called to his sons, and said: “Gather yourselves together, that I may tell you that which will happen to you in the days to come. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Assemble yourselves, and hear, you sons of Jacob. Listen to Israel, your father. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, you are my firstborn, my might, and the beginning of my strength, excelling in dignity, and excelling in power. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Boiling over like water, you shall not excel, because you went up to your father’s bed, then defiled it. He went up to my couch. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon and Levi are brothers. Their swords are weapons of violence. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","My soul, don’t come into their council. My glory, don’t be united to their assembly; for in their anger they killed men. In their self-will they hamstrung cattle. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cursed be their anger, for it was fierce; and their wrath, for it was cruel. I will divide them in Jacob, and scatter them in Israel. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, your brothers will praise you. Your hand will be on the neck of your enemies. Your father’s sons will bow down before you. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah is a lion’s cub. From the prey, my son, you have gone up. He stooped down, he crouched as a lion, as a lioness. Who will rouse him up? ");
INSERT INTO engwebpb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The sceptre will not depart from Judah, nor the ruler’s staff from between his feet, until he comes to whom it belongs. The obedience of the peoples will be to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Binding his foal to the vine, his donkey’s colt to the choice vine, he has washed his garments in wine, his robes in the blood of grapes. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes will be red with wine, his teeth white with milk. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun will dwell at the haven of the sea. He will be for a haven of ships. His border will be on Sidon. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Issachar is a strong donkey, lying down between the saddlebags. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","He saw a resting place, that it was good, the land, that it was pleasant. He bows his shoulder to the burden, and becomes a servant doing forced labour. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan will judge his people, as one of the tribes of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan will be a serpent on the trail, an adder in the path, that bites the horse’s heels, so that his rider falls backward. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I have waited for your salvation, LORD. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“A troop will press on Gad, but he will press on their heel. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asher’s food will be rich. He will produce royal dainties. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naphtali is a doe set free, who bears beautiful fawns. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joseph is a fruitful vine, a fruitful vine by a spring. His branches run over the wall. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The archers have severely grieved him, shot at him, and persecuted him: ");
INSERT INTO engwebpb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But his bow remained strong. The arms of his hands were made strong, by the hands of the Mighty One of Jacob, (from there is the shepherd, the stone of Israel), ");
INSERT INTO engwebpb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","even by the God of your father, who will help you, by the Almighty, who will bless you, with blessings of heaven above, blessings of the deep that lies below, blessings of the breasts, and of the womb. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessings of your father have prevailed above the blessings of my ancestors, above the boundaries of the ancient hills. They will be on the head of Joseph, on the crown of the head of him who is separated from his brothers. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin is a ravenous wolf. In the morning he will devour the prey. At evening he will divide the plunder.” ");
INSERT INTO engwebpb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","All these are the twelve tribes of Israel, and this is what their father spoke to them, and blessed them. He blessed everyone according to his own blessing. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","He instructed them, and said to them, “I am to be gathered to my people. Bury me with my fathers in the cave that is in the field of Ephron the Hittite, ");
INSERT INTO engwebpb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","in the cave that is in the field of Machpelah, which is before Mamre, in the land of Canaan, which Abraham bought with the field from Ephron the Hittite as a burial place. ");
INSERT INTO engwebpb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There they buried Abraham and Sarah, his wife. There they buried Isaac and Rebekah, his wife, and there I buried Leah: ");
INSERT INTO engwebpb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","the field and the cave that is therein, which was purchased from the children of Heth.” ");
INSERT INTO engwebpb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","When Jacob finished charging his sons, he gathered up his feet into the bed, breathed his last breath, and was gathered to his people. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph fell on his father’s face, wept on him, and kissed him. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph commanded his servants, the physicians, to embalm his father; and the physicians embalmed Israel. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Forty days were used for him, for that is how many days it takes to embalm. The Egyptians wept for Israel for seventy days. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","When the days of weeping for him were past, Joseph spoke to Pharaoh’s staff, saying, “If now I have found favour in your eyes, please speak in the ears of Pharaoh, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘My father made me swear, saying, “Behold, I am dying. Bury me in my grave which I have dug for myself in the land of Canaan.” Now therefore, please let me go up and bury my father, and I will come again.’” ");
INSERT INTO engwebpb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh said, “Go up, and bury your father, just like he made you swear.” ");
INSERT INTO engwebpb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph went up to bury his father; and with him went up all the servants of Pharaoh, the elders of his house, all the elders of the land of Egypt, ");
INSERT INTO engwebpb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","all the house of Joseph, his brothers, and his father’s house. Only their little ones, their flocks, and their herds, they left in the land of Goshen. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Both chariots and horsemen went up with him. It was a very great company. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","They came to the threshing floor of Atad, which is beyond the Jordan, and there they lamented with a very great and severe lamentation. He mourned for his father seven days. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","When the inhabitants of the land, the Canaanites, saw the mourning in the floor of Atad, they said, “This is a grievous mourning by the Egyptians.” Therefore its name was called Abel Mizraim, which is beyond the Jordan. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","His sons did to him just as he commanded them, ");
INSERT INTO engwebpb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","for his sons carried him into the land of Canaan, and buried him in the cave of the field of Machpelah, which Abraham bought with the field, as a possession for a burial site, from Ephron the Hittite, near Mamre. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joseph returned into Egypt—he, and his brothers, and all that went up with him to bury his father, after he had buried his father. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","When Joseph’s brothers saw that their father was dead, they said, “It may be that Joseph will hate us, and will fully pay us back for all the evil which we did to him.” ");
INSERT INTO engwebpb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","They sent a message to Joseph, saying, “Your father commanded before he died, saying, ");
INSERT INTO engwebpb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘You shall tell Joseph, “Now please forgive the disobedience of your brothers, and their sin, because they did evil to you.”’ Now, please forgive the disobedience of the servants of the God of your father.” Joseph wept when they spoke to him. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","His brothers also went and fell down before his face; and they said, “Behold, we are your servants.” ");
INSERT INTO engwebpb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph said to them, “Don’t be afraid, for am I in the place of God? ");
INSERT INTO engwebpb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, you meant evil against me, but God meant it for good, to save many people alive, as is happening today. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Now therefore don’t be afraid. I will provide for you and your little ones.” He comforted them, and spoke kindly to them. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph lived in Egypt, he, and his father’s house. Joseph lived one hundred and ten years. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph saw Ephraim’s children to the third generation. The children also of Machir, the son of Manasseh, were born on Joseph’s knees. ");
INSERT INTO engwebpb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph said to his brothers, “I am dying, but God will surely visit you, and bring you up out of this land to the land which he swore to Abraham, to Isaac, and to Jacob.” ");
INSERT INTO engwebpb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph took an oath from the children of Israel, saying, “God will surely visit you, and you shall carry up my bones from here.” ");
INSERT INTO engwebpb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Joseph died, being one hundred and ten years old, and they embalmed him, and he was put in a coffin in Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Now these are the names of the sons of Israel, who came into Egypt (every man and his household came with Jacob): ");
INSERT INTO engwebpb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah, ");
INSERT INTO engwebpb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin, ");
INSERT INTO engwebpb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan and Naphtali, Gad and Asher. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","All the souls who came out of Jacob’s body were seventy souls, and Joseph was in Egypt already. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph died, as did all his brothers, and all that generation. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","The children of Israel were fruitful, and increased abundantly, and multiplied, and grew exceedingly mighty; and the land was filled with them. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Now there arose a new king over Egypt, who didn’t know Joseph. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","He said to his people, “Behold, the people of the children of Israel are more and mightier than we. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Come, let’s deal wisely with them, lest they multiply, and it happen that when any war breaks out, they also join themselves to our enemies and fight against us, and escape out of the land.” ");
INSERT INTO engwebpb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Therefore they set taskmasters over them to afflict them with their burdens. They built storage cities for Pharaoh: Pithom and Raamses. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more they afflicted them, the more they multiplied and the more they spread out. They started to dread the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","The Egyptians ruthlessly made the children of Israel serve, ");
INSERT INTO engwebpb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","and they made their lives bitter with hard service in mortar and in brick, and in all kinds of service in the field, all their service, in which they ruthlessly made them serve. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","The king of Egypt spoke to the Hebrew midwives, of whom the name of the one was Shiphrah, and the name of the other Puah, ");
INSERT INTO engwebpb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","and he said, “When you perform the duty of a midwife to the Hebrew women, and see them on the birth stool, if it is a son, then you shall kill him; but if it is a daughter, then she shall live.” ");
INSERT INTO engwebpb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the midwives feared God, and didn’t do what the king of Egypt commanded them, but saved the baby boys alive. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","The king of Egypt called for the midwives, and said to them, “Why have you done this thing and saved the boys alive?” ");
INSERT INTO engwebpb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","The midwives said to Pharaoh, “Because the Hebrew women aren’t like the Egyptian women; for they are vigorous and give birth before the midwife comes to them.” ");
INSERT INTO engwebpb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","God dealt well with the midwives, and the people multiplied, and grew very mighty. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Because the midwives feared God, he gave them families. ");
INSERT INTO engwebpb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pharaoh commanded all his people, saying, “You shall cast every son who is born into the river, and every daughter you shall save alive.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","A man of the house of Levi went and took a daughter of Levi as his wife. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","The woman conceived and bore a son. When she saw that he was a fine child, she hid him three months. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","When she could no longer hide him, she took a papyrus basket for him, and coated it with tar and with pitch. She put the child in it, and laid it in the reeds by the river’s bank. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","His sister stood far off, to see what would be done to him. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Pharaoh’s daughter came down to bathe at the river. Her maidens walked along by the riverside. She saw the basket amongst the reeds, and sent her servant to get it. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","She opened it, and saw the child, and behold, the baby cried. She had compassion on him, and said, “This is one of the Hebrews’ children.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then his sister said to Pharaoh’s daughter, “Should I go and call a nurse for you from the Hebrew women, that she may nurse the child for you?” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Pharaoh’s daughter said to her, “Go.” The young woman went and called the child’s mother. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pharaoh’s daughter said to her, “Take this child away, and nurse him for me, and I will give you your wages.” The woman took the child, and nursed it. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","The child grew, and she brought him to Pharaoh’s daughter, and he became her son. She named him Moses, and said, “Because I drew him out of the water.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","In those days, when Moses had grown up, he went out to his brothers and saw their burdens. He saw an Egyptian striking a Hebrew, one of his brothers. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","He looked this way and that way, and when he saw that there was no one, he killed the Egyptian, and hid him in the sand. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","He went out the second day, and behold, two men of the Hebrews were fighting with each other. He said to him who did the wrong, “Why do you strike your fellow?” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","He said, “Who made you a prince and a judge over us? Do you plan to kill me, as you killed the Egyptian?” Moses was afraid, and said, “Surely this thing is known.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Now when Pharaoh heard this thing, he sought to kill Moses. But Moses fled from the face of Pharaoh, and lived in the land of Midian, and he sat down by a well. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Now the priest of Midian had seven daughters. They came and drew water, and filled the troughs to water their father’s flock. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","The shepherds came and drove them away; but Moses stood up and helped them, and watered their flock. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","When they came to Reuel, their father, he said, “How is it that you have returned so early today?” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","They said, “An Egyptian delivered us out of the hand of the shepherds, and moreover he drew water for us, and watered the flock.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","He said to his daughters, “Where is he? Why is it that you have left the man? Call him, that he may eat bread.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses was content to dwell with the man. He gave Moses Zipporah, his daughter. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","She bore a son, and he named him Gershom, for he said, “I have lived as a foreigner in a foreign land.” ");
INSERT INTO engwebpb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","In the course of those many days, the king of Egypt died, and the children of Israel sighed because of the bondage, and they cried, and their cry came up to God because of the bondage. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","God heard their groaning, and God remembered his covenant with Abraham, with Isaac, and with Jacob. ");
INSERT INTO engwebpb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God saw the children of Israel, and God understood. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Now Moses was keeping the flock of Jethro, his father-in-law, the priest of Midian, and he led the flock to the back of the wilderness, and came to God’s mountain, to Horeb. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","The LORD’s angel appeared to him in a flame of fire out of the middle of a bush. He looked, and behold, the bush burnt with fire, and the bush was not consumed. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses said, “I will go now, and see this great sight, why the bush is not burnt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","When the LORD saw that he came over to see, God called to him out of the middle of the bush, and said, “Moses! Moses!” He said, “Here I am.” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","He said, “Don’t come close. Take off your sandals, for the place you are standing on is holy ground.” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Moreover he said, “I am the God of your father, the God of Abraham, the God of Isaac, and the God of Jacob.” Moses hid his face because he was afraid to look at God. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","The LORD said, “I have surely seen the affliction of my people who are in Egypt, and have heard their cry because of their taskmasters, for I know their sorrows. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I have come down to deliver them out of the hand of the Egyptians, and to bring them up out of that land to a good and large land, to a land flowing with milk and honey; to the place of the Canaanite, the Hittite, the Amorite, the Perizzite, the Hivite, and the Jebusite. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Now, behold, the cry of the children of Israel has come to me. Moreover I have seen the oppression with which the Egyptians oppress them. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Come now therefore, and I will send you to Pharaoh, that you may bring my people, the children of Israel, out of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moses said to God, “Who am I, that I should go to Pharaoh, and that I should bring the children of Israel out of Egypt?” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","He said, “Certainly I will be with you. This will be the token to you, that I have sent you: when you have brought the people out of Egypt, you shall serve God on this mountain.” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses said to God, “Behold, when I come to the children of Israel, and tell them, ‘The God of your fathers has sent me to you,’ and they ask me, ‘What is his name?’ what should I tell them?” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God said to Moses, “I AM WHO I AM,” and he said, “You shall tell the children of Israel this: ‘I AM has sent me to you.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","God said moreover to Moses, “You shall tell the children of Israel this, ‘The LORD, the God of your fathers, the God of Abraham, the God of Isaac, and the God of Jacob, has sent me to you.’ This is my name forever, and this is my memorial to all generations. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go and gather the elders of Israel together, and tell them, ‘The LORD, the God of your fathers, the God of Abraham, of Isaac, and of Jacob, has appeared to me, saying, “I have surely visited you, and seen that which is done to you in Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","I have said, I will bring you up out of the affliction of Egypt to the land of the Canaanite, the Hittite, the Amorite, the Perizzite, the Hivite, and the Jebusite, to a land flowing with milk and honey.”’ ");
INSERT INTO engwebpb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","They will listen to your voice. You shall come, you and the elders of Israel, to the king of Egypt, and you shall tell him, ‘The LORD, the God of the Hebrews, has met with us. Now please let us go three days’ journey into the wilderness, that we may sacrifice to the LORD, our God.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","I know that the king of Egypt won’t give you permission to go, no, not by a mighty hand. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","I will reach out my hand and strike Egypt with all my wonders which I will do amongst them, and after that he will let you go. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","I will give this people favour in the sight of the Egyptians, and it will happen that when you go, you shall not go empty-handed. ");
INSERT INTO engwebpb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","But every woman shall ask of her neighbour, and of her who visits her house, jewels of silver, jewels of gold, and clothing. You shall put them on your sons, and on your daughters. You shall plunder the Egyptians.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses answered, “But, behold, they will not believe me, nor listen to my voice; for they will say, ‘The LORD has not appeared to you.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","The LORD said to him, “What is that in your hand?” He said, “A rod.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","He said, “Throw it on the ground.” He threw it on the ground, and it became a snake; and Moses ran away from it. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","The LORD said to Moses, “Stretch out your hand, and take it by the tail.” He stretched out his hand, and took hold of it, and it became a rod in his hand. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“This is so that they may believe that the LORD, the God of their fathers, the God of Abraham, the God of Isaac, and the God of Jacob, has appeared to you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","The LORD said furthermore to him, “Now put your hand inside your cloak.” He put his hand inside his cloak, and when he took it out, behold, his hand was leprous, as white as snow. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","He said, “Put your hand inside your cloak again.” He put his hand inside his cloak again, and when he took it out of his cloak, behold, it had turned again as his other flesh. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“It will happen, if they will not believe you or listen to the voice of the first sign, that they will believe the voice of the latter sign. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","It will happen, if they will not believe even these two signs or listen to your voice, that you shall take of the water of the river, and pour it on the dry land. The water which you take out of the river will become blood on the dry land.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moses said to the LORD, “O Lord, I am not eloquent, neither before now, nor since you have spoken to your servant; for I am slow of speech, and of a slow tongue.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","The LORD said to him, “Who made man’s mouth? Or who makes one mute, or deaf, or seeing, or blind? Isn’t it I, the LORD? ");
INSERT INTO engwebpb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Now therefore go, and I will be with your mouth, and teach you what you shall speak.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moses said, “Oh, Lord, please send someone else.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","The LORD’s anger burnt against Moses, and he said, “What about Aaron, your brother, the Levite? I know that he can speak well. Also, behold, he is coming out to meet you. When he sees you, he will be glad in his heart. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","You shall speak to him, and put the words in his mouth. I will be with your mouth, and with his mouth, and will teach you what you shall do. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","He will be your spokesman to the people. It will happen that he will be to you a mouth, and you will be to him as God. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","You shall take this rod in your hand, with which you shall do the signs.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moses went and returned to Jethro his father-in-law, and said to him, “Please let me go and return to my brothers who are in Egypt, and see whether they are still alive.” Jethro said to Moses, “Go in peace.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","The LORD said to Moses in Midian, “Go, return into Egypt; for all the men who sought your life are dead.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moses took his wife and his sons, and set them on a donkey, and he returned to the land of Egypt. Moses took God’s rod in his hand. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","The LORD said to Moses, “When you go back into Egypt, see that you do before Pharaoh all the wonders which I have put in your hand, but I will harden his heart and he will not let the people go. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","You shall tell Pharaoh, ‘The LORD says, Israel is my son, my firstborn, ");
INSERT INTO engwebpb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","and I have said to you, “Let my son go, that he may serve me;” and you have refused to let him go. Behold, I will kill your firstborn son.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","On the way at a lodging place, the LORD met Moses and wanted to kill him. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Then Zipporah took a flint, and cut off the foreskin of her son, and cast it at his feet; and she said, “Surely you are a bridegroom of blood to me.” ");
INSERT INTO engwebpb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","So he let him alone. Then she said, “You are a bridegroom of blood,” because of the circumcision. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","The LORD said to Aaron, “Go into the wilderness to meet Moses.” He went, and met him on God’s mountain, and kissed him. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses told Aaron all the LORD’s words with which he had sent him, and all the signs with which he had instructed him. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moses and Aaron went and gathered together all the elders of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron spoke all the words which the LORD had spoken to Moses, and did the signs in the sight of the people. ");
INSERT INTO engwebpb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","The people believed, and when they heard that the LORD had visited the children of Israel, and that he had seen their affliction, then they bowed their heads and worshipped. ");
INSERT INTO engwebpb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Afterward Moses and Aaron came, and said to Pharaoh, “This is what the LORD, the God of Israel, says, ‘Let my people go, that they may hold a feast to me in the wilderness.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaoh said, “Who is the LORD, that I should listen to his voice to let Israel go? I don’t know the LORD, and moreover I will not let Israel go.” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","They said, “The God of the Hebrews has met with us. Please let us go three days’ journey into the wilderness, and sacrifice to the LORD, our God, lest he fall on us with pestilence, or with the sword.” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","The king of Egypt said to them, “Why do you, Moses and Aaron, take the people from their work? Get back to your burdens!” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaoh said, “Behold, the people of the land are now many, and you make them rest from their burdens.” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","The same day Pharaoh commanded the taskmasters of the people and their officers, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“You shall no longer give the people straw to make brick, as before. Let them go and gather straw for themselves. ");
INSERT INTO engwebpb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","You shall require from them the number of the bricks which they made before. You shall not diminish anything of it, for they are idle. Therefore they cry, saying, ‘Let’s go and sacrifice to our God.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Let heavier work be laid on the men, that they may labour in it. Don’t let them pay any attention to lying words.” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","The taskmasters of the people went out with their officers, and they spoke to the people, saying, “This is what Pharaoh says: ‘I will not give you straw. ");
INSERT INTO engwebpb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go yourselves, get straw where you can find it, for nothing of your work shall be diminished.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people were scattered abroad throughout all the land of Egypt to gather stubble for straw. ");
INSERT INTO engwebpb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The taskmasters were urgent saying, “Fulfil your work quota daily, as when there was straw!” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","The officers of the children of Israel, whom Pharaoh’s taskmasters had set over them, were beaten, and were asked, “Why haven’t you fulfilled your quota both yesterday and today, in making brick as before?” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Then the officers of the children of Israel came and cried to Pharaoh, saying, “Why do you deal this way with your servants? ");
INSERT INTO engwebpb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No straw is given to your servants, and they tell us, ‘Make brick!’ and behold, your servants are beaten; but the fault is in your own people.” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But Pharaoh said, “You are idle! You are idle! Therefore you say, ‘Let’s go and sacrifice to the LORD.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Go therefore now, and work; for no straw shall be given to you; yet you shall deliver the same number of bricks!” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The officers of the children of Israel saw that they were in trouble when it was said, “You shall not diminish anything from your daily quota of bricks!” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","They met Moses and Aaron, who stood along the way, as they came out from Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","They said to them, “May the LORD look at you and judge, because you have made us a stench to be abhorred in the eyes of Pharaoh, and in the eyes of his servants, to put a sword in their hand to kill us!” ");
INSERT INTO engwebpb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses returned to the LORD, and said, “Lord, why have you brought trouble on this people? Why is it that you have sent me? ");
INSERT INTO engwebpb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","For since I came to Pharaoh to speak in your name, he has brought trouble on this people. You have not rescued your people at all!” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","The LORD said to Moses, “Now you shall see what I will do to Pharaoh, for by a strong hand he shall let them go, and by a strong hand he shall drive them out of his land.” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God spoke to Moses, and said to him, “I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I appeared to Abraham, to Isaac, and to Jacob, as God Almighty; but by my name the LORD I was not known to them. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I have also established my covenant with them, to give them the land of Canaan, the land of their travels, in which they lived as aliens. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Moreover I have heard the groaning of the children of Israel, whom the Egyptians keep in bondage, and I have remembered my covenant. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Therefore tell the children of Israel, ‘I am the LORD, and I will bring you out from under the burdens of the Egyptians, and I will rid you out of their bondage, and I will redeem you with an outstretched arm, and with great judgements. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I will take you to myself for a people. I will be your God; and you shall know that I am the LORD your God, who brings you out from under the burdens of the Egyptians. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I will bring you into the land which I swore to give to Abraham, to Isaac, and to Jacob; and I will give it to you for a heritage: I am the LORD.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses spoke so to the children of Israel, but they didn’t listen to Moses for anguish of spirit, and for cruel bondage. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go in, speak to Pharaoh king of Egypt, that he let the children of Israel go out of his land.” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moses spoke before the LORD, saying, “Behold, the children of Israel haven’t listened to me. How then shall Pharaoh listen to me, when I have uncircumcised lips?” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","The LORD spoke to Moses and to Aaron, and gave them a command to the children of Israel, and to Pharaoh king of Egypt, to bring the children of Israel out of the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are the heads of their fathers’ houses. The sons of Reuben the firstborn of Israel: Hanoch, and Pallu, Hezron, and Carmi; these are the families of Reuben. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","The sons of Simeon: Jemuel, and Jamin, and Ohad, and Jachin, and Zohar, and Shaul the son of a Canaanite woman; these are the families of Simeon. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","These are the names of the sons of Levi according to their generations: Gershon, and Kohath, and Merari; and the years of the life of Levi were one hundred and thirty-seven years. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon: Libni and Shimei, according to their families. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","The sons of Kohath: Amram, and Izhar, and Hebron, and Uzziel; and the years of the life of Kohath were one hundred and thirty-three years. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","The sons of Merari: Mahli and Mushi. These are the families of the Levites according to their generations. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram took Jochebed his father’s sister to himself as wife; and she bore him Aaron and Moses. The years of the life of Amram were one hundred and thirty-seven years. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","The sons of Izhar: Korah, and Nepheg, and Zichri. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","The sons of Uzziel: Mishael, Elzaphan, and Sithri. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron took Elisheba, the daughter of Amminadab, the sister of Nahshon, as his wife; and she bore him Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah: Assir, Elkanah, and Abiasaph; these are the families of the Korahites. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar Aaron’s son took one of the daughters of Putiel as his wife; and she bore him Phinehas. These are the heads of the fathers’ houses of the Levites according to their families. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","These are that Aaron and Moses to whom the LORD said, “Bring out the children of Israel from the land of Egypt according to their armies.” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","These are those who spoke to Pharaoh king of Egypt, to bring out the children of Israel from Egypt. These are that Moses and Aaron. ");
INSERT INTO engwebpb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","On the day when the LORD spoke to Moses in the land of Egypt, ");
INSERT INTO engwebpb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","The LORD said to Moses, “I am the LORD. Tell Pharaoh king of Egypt all that I tell you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moses said before the LORD, “Behold, I am of uncircumcised lips, and how shall Pharaoh listen to me?” ");
INSERT INTO engwebpb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","The LORD said to Moses, “Behold, I have made you as God to Pharaoh; and Aaron your brother shall be your prophet. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You shall speak all that I command you; and Aaron your brother shall speak to Pharaoh, that he let the children of Israel go out of his land. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","I will harden Pharaoh’s heart, and multiply my signs and my wonders in the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","But Pharaoh will not listen to you, so I will lay my hand on Egypt, and bring out my armies, my people the children of Israel, out of the land of Egypt by great judgements. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","The Egyptians shall know that I am the LORD when I stretch out my hand on Egypt, and bring the children of Israel out from amongst them.” ");
INSERT INTO engwebpb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses and Aaron did so. As the LORD commanded them, so they did. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses was eighty years old, and Aaron eighty-three years old, when they spoke to Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“When Pharaoh speaks to you, saying, ‘Perform a miracle!’ then you shall tell Aaron, ‘Take your rod, and cast it down before Pharaoh, and it will become a serpent.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moses and Aaron went in to Pharaoh, and they did so, as the LORD had commanded. Aaron cast down his rod before Pharaoh and before his servants, and it became a serpent. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Then Pharaoh also called for the wise men and the sorcerers. They also, the magicians of Egypt, did the same thing with their enchantments. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","For they each cast down their rods, and they became serpents; but Aaron’s rod swallowed up their rods. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pharaoh’s heart was hardened, and he didn’t listen to them, as the LORD had spoken. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","The LORD said to Moses, “Pharaoh’s heart is stubborn. He refuses to let the people go. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go to Pharaoh in the morning. Behold, he is going out to the water. You shall stand by the river’s bank to meet him. You shall take the rod which was turned to a serpent in your hand. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","You shall tell him, ‘The LORD, the God of the Hebrews, has sent me to you, saying, “Let my people go, that they may serve me in the wilderness. Behold, until now you haven’t listened.” ");
INSERT INTO engwebpb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","The LORD says, “In this you shall know that I am the LORD. Behold: I will strike with the rod that is in my hand on the waters which are in the river, and they shall be turned to blood. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","The fish that are in the river will die and the river will become foul. The Egyptians will loathe to drink water from the river.”’” ");
INSERT INTO engwebpb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","The LORD said to Moses, “Tell Aaron, ‘Take your rod, and stretch out your hand over the waters of Egypt, over their rivers, over their streams, and over their pools, and over all their ponds of water, that they may become blood. There will be blood throughout all the land of Egypt, both in vessels of wood and in vessels of stone.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses and Aaron did so, as the LORD commanded; and he lifted up the rod, and struck the waters that were in the river, in the sight of Pharaoh, and in the sight of his servants; and all the waters that were in the river were turned to blood. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","The fish that were in the river died. The river became foul. The Egyptians couldn’t drink water from the river. The blood was throughout all the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","The magicians of Egypt did the same thing with their enchantments. So Pharaoh’s heart was hardened, and he didn’t listen to them, as the LORD had spoken. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh turned and went into his house, and he didn’t even take this to heart. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","All the Egyptians dug around the river for water to drink; for they couldn’t drink the river water. ");
INSERT INTO engwebpb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Seven days were fulfilled, after the LORD had struck the river. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","The LORD spoke to Moses, “Go in to Pharaoh, and tell him, ‘This is what the LORD says, “Let my people go, that they may serve me. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","If you refuse to let them go, behold, I will plague all your borders with frogs. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","The river will swarm with frogs, which will go up and come into your house, and into your bedroom, and on your bed, and into the house of your servants, and on your people, and into your ovens, and into your kneading troughs. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","The frogs shall come up both on you, and on your people, and on all your servants.”’” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","The LORD said to Moses, “Tell Aaron, ‘Stretch out your hand with your rod over the rivers, over the streams, and over the pools, and cause frogs to come up on the land of Egypt.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron stretched out his hand over the waters of Egypt; and the frogs came up, and covered the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","The magicians did the same thing with their enchantments, and brought up frogs on the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Then Pharaoh called for Moses and Aaron, and said, “Entreat the LORD, that he take away the frogs from me and from my people; and I will let the people go, that they may sacrifice to the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses said to Pharaoh, “I give you the honour of setting the time that I should pray for you, and for your servants, and for your people, that the frogs be destroyed from you and your houses, and remain in the river only.” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaoh said, “Tomorrow.” Moses said, “Let it be according to your word, that you may know that there is no one like the LORD our God. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs shall depart from you, and from your houses, and from your servants, and from your people. They shall remain in the river only.” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moses and Aaron went out from Pharaoh, and Moses cried to the LORD concerning the frogs which he had brought on Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","The LORD did according to the word of Moses, and the frogs died out of the houses, out of the courts, and out of the fields. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","They gathered them together in heaps, and the land stank. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when Pharaoh saw that there was a respite, he hardened his heart, and didn’t listen to them, as the LORD had spoken. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","The LORD said to Moses, “Tell Aaron, ‘Stretch out your rod, and strike the dust of the earth, that it may become lice throughout all the land of Egypt.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","They did so; and Aaron stretched out his hand with his rod, and struck the dust of the earth, and there were lice on man, and on animal; all the dust of the earth became lice throughout all the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","The magicians tried with their enchantments to produce lice, but they couldn’t. There were lice on man, and on animal. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Then the magicians said to Pharaoh, “This is God’s finger;” but Pharaoh’s heart was hardened, and he didn’t listen to them, as the LORD had spoken. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","The LORD said to Moses, “Rise up early in the morning, and stand before Pharaoh; behold, he comes out to the water; and tell him, ‘This is what the LORD says, “Let my people go, that they may serve me. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Else, if you will not let my people go, behold, I will send swarms of flies on you, and on your servants, and on your people, and into your houses. The houses of the Egyptians shall be full of swarms of flies, and also the ground they are on. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","I will set apart in that day the land of Goshen, in which my people dwell, that no swarms of flies shall be there, to the end you may know that I am the LORD on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I will put a division between my people and your people. This sign shall happen by tomorrow.”’” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","The LORD did so; and there came grievous swarms of flies into the house of Pharaoh, and into his servants’ houses. In all the land of Egypt the land was corrupted by reason of the swarms of flies. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pharaoh called for Moses and for Aaron, and said, “Go, sacrifice to your God in the land!” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moses said, “It isn’t appropriate to do so; for we shall sacrifice the abomination of the Egyptians to the LORD our God. Behold, if we sacrifice the abomination of the Egyptians before their eyes, won’t they stone us? ");
INSERT INTO engwebpb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","We will go three days’ journey into the wilderness, and sacrifice to the LORD our God, as he shall command us.” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaoh said, “I will let you go, that you may sacrifice to the LORD your God in the wilderness, only you shall not go very far away. Pray for me.” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses said, “Behold, I am going out from you. I will pray to the LORD that the swarms of flies may depart from Pharaoh, from his servants, and from his people, tomorrow; only don’t let Pharaoh deal deceitfully any more in not letting the people go to sacrifice to the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses went out from Pharaoh, and prayed to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","The LORD did according to the word of Moses, and he removed the swarms of flies from Pharaoh, from his servants, and from his people. There remained not one. ");
INSERT INTO engwebpb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pharaoh hardened his heart this time also, and he didn’t let the people go. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then the LORD said to Moses, “Go in to Pharaoh, and tell him, ‘This is what the LORD, the God of the Hebrews, says: “Let my people go, that they may serve me. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","For if you refuse to let them go, and hold them still, ");
INSERT INTO engwebpb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","behold, the LORD’s hand is on your livestock which are in the field, on the horses, on the donkeys, on the camels, on the herds, and on the flocks with a very grievous pestilence. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","The LORD will make a distinction between the livestock of Israel and the livestock of Egypt; and nothing shall die of all that belongs to the children of Israel.”’” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","The LORD appointed a set time, saying, “Tomorrow the LORD shall do this thing in the land.” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","The LORD did that thing on the next day; and all the livestock of Egypt died, but of the livestock of the children of Israel, not one died. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh sent, and, behold, there was not so much as one of the livestock of the Israelites dead. But the heart of Pharaoh was stubborn, and he didn’t let the people go. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","The LORD said to Moses and to Aaron, “Take handfuls of ashes of the furnace, and let Moses sprinkle it towards the sky in the sight of Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","It shall become small dust over all the land of Egypt, and shall be boils and blisters breaking out on man and on animal, throughout all the land of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","They took ashes of the furnace, and stood before Pharaoh; and Moses sprinkled it up towards the sky; and it became boils and blisters breaking out on man and on animal. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","The magicians couldn’t stand before Moses because of the boils; for the boils were on the magicians and on all the Egyptians. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","The LORD hardened the heart of Pharaoh, and he didn’t listen to them, as the LORD had spoken to Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","The LORD said to Moses, “Rise up early in the morning, and stand before Pharaoh, and tell him, ‘This is what the LORD, the God of the Hebrews, says: “Let my people go, that they may serve me. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","For this time I will send all my plagues against your heart, against your officials, and against your people; that you may know that there is no one like me in all the earth. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","For now I would have stretched out my hand, and struck you and your people with pestilence, and you would have been cut off from the earth; ");
INSERT INTO engwebpb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","but indeed for this cause I have made you stand: to show you my power, and that my name may be declared throughout all the earth, ");
INSERT INTO engwebpb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","because you still exalt yourself against my people, that you won’t let them go. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Behold, tomorrow about this time I will cause it to rain a very grievous hail, such as has not been in Egypt since the day it was founded even until now. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Now therefore command that all of your livestock and all that you have in the field be brought into shelter. The hail will come down on every man and animal that is found in the field, and isn’t brought home, and they will die.”’” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Those who feared the LORD’s word amongst the servants of Pharaoh made their servants and their livestock flee into the houses. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Whoever didn’t respect the LORD’s word left his servants and his livestock in the field. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","The LORD said to Moses, “Stretch out your hand towards the sky, that there may be hail in all the land of Egypt, on man, and on animal, and on every herb of the field, throughout the land of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moses stretched out his rod towards the heavens, and the LORD sent thunder and hail; and lightning flashed down to the earth. The LORD rained hail on the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","So there was very severe hail, and lightning mixed with the hail, such as had not been in all the land of Egypt since it became a nation. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","The hail struck throughout all the land of Egypt all that was in the field, both man and animal; and the hail struck every herb of the field, and broke every tree of the field. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the land of Goshen, where the children of Israel were, there was no hail. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaoh sent and called for Moses and Aaron, and said to them, “I have sinned this time. The LORD is righteous, and I and my people are wicked. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pray to the LORD; for there has been enough of mighty thunderings and hail. I will let you go, and you shall stay no longer.” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses said to him, “As soon as I have gone out of the city, I will spread out my hands to the LORD. The thunders shall cease, and there will not be any more hail; that you may know that the earth is the LORD’s. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for you and your servants, I know that you don’t yet fear the LORD God.” ");
INSERT INTO engwebpb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","The flax and the barley were struck, for the barley had ripened and the flax was blooming. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But the wheat and the spelt were not struck, for they had not grown up. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses went out of the city from Pharaoh, and spread out his hands to the LORD; and the thunders and hail ceased, and the rain was not poured on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","When Pharaoh saw that the rain and the hail and the thunders had ceased, he sinned yet more, and hardened his heart, he and his servants. ");
INSERT INTO engwebpb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","The heart of Pharaoh was hardened, and he didn’t let the children of Israel go, just as the LORD had spoken through Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","The LORD said to Moses, “Go in to Pharaoh, for I have hardened his heart and the heart of his servants, that I may show these my signs amongst them; ");
INSERT INTO engwebpb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","and that you may tell in the hearing of your son, and of your son’s son, what things I have done to Egypt, and my signs which I have done amongst them; that you may know that I am the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moses and Aaron went in to Pharaoh, and said to him, “This is what the LORD, the God of the Hebrews, says: ‘How long will you refuse to humble yourself before me? Let my people go, that they may serve me. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Or else, if you refuse to let my people go, behold, tomorrow I will bring locusts into your country, ");
INSERT INTO engwebpb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","and they shall cover the surface of the earth, so that one won’t be able to see the earth. They shall eat the residue of that which has escaped, which remains to you from the hail, and shall eat every tree which grows for you out of the field. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Your houses shall be filled, and the houses of all your servants, and the houses of all the Egyptians, as neither your fathers nor your fathers’ fathers have seen, since the day that they were on the earth to this day.’” He turned, and went out from Pharaoh. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pharaoh’s servants said to him, “How long will this man be a snare to us? Let the men go, that they may serve the LORD, their God. Don’t you yet know that Egypt is destroyed?” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moses and Aaron were brought again to Pharaoh, and he said to them, “Go, serve the LORD your God; but who are those who will go?” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses said, “We will go with our young and with our old. We will go with our sons and with our daughters, with our flocks and with our herds; for we must hold a feast to the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","He said to them, “The LORD be with you if I let you go with your little ones! See, evil is clearly before your faces. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Not so! Go now you who are men, and serve the LORD; for that is what you desire!” Then they were driven out from Pharaoh’s presence. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","The LORD said to Moses, “Stretch out your hand over the land of Egypt for the locusts, that they may come up on the land of Egypt, and eat every herb of the land, even all that the hail has left.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moses stretched out his rod over the land of Egypt, and the LORD brought an east wind on the land all that day, and all night; and when it was morning, the east wind brought the locusts. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts went up over all the land of Egypt, and rested in all the borders of Egypt. They were very grievous. Before them there were no such locusts as they, nor will there ever be again. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","For they covered the surface of the whole earth, so that the land was darkened, and they ate every herb of the land, and all the fruit of the trees which the hail had left. There remained nothing green, either tree or herb of the field, through all the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Then Pharaoh called for Moses and Aaron in haste, and he said, “I have sinned against the LORD your God, and against you. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Now therefore please forgive my sin again, and pray to the LORD your God, that he may also take away from me this death.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses went out from Pharaoh, and prayed to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","The LORD sent an exceedingly strong west wind, which took up the locusts, and drove them into the Red Sea. There remained not one locust in all the borders of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But the LORD hardened Pharaoh’s heart, and he didn’t let the children of Israel go. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","The LORD said to Moses, “Stretch out your hand towards the sky, that there may be darkness over the land of Egypt, even darkness which may be felt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moses stretched out his hand towards the sky, and there was a thick darkness in all the land of Egypt for three days. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","They didn’t see one another, and nobody rose from his place for three days; but all the children of Israel had light in their dwellings. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaoh called to Moses, and said, “Go, serve the LORD. Only let your flocks and your herds stay behind. Let your little ones also go with you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moses said, “You must also give into our hand sacrifices and burnt offerings, that we may sacrifice to the LORD our God. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Our livestock also shall go with us. Not a hoof shall be left behind, for of it we must take to serve the LORD our God; and we don’t know with what we must serve the LORD, until we come there.” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But the LORD hardened Pharaoh’s heart, and he wouldn’t let them go. ");
INSERT INTO engwebpb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh said to him, “Get away from me! Be careful to see my face no more; for in the day you see my face you shall die!” ");
INSERT INTO engwebpb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses said, “You have spoken well. I will see your face again no more.” ");
INSERT INTO engwebpb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","The LORD said to Moses, “I will bring yet one more plague on Pharaoh, and on Egypt; afterwards he will let you go. When he lets you go, he will surely thrust you out altogether. ");
INSERT INTO engwebpb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Speak now in the ears of the people, and let every man ask of his neighbour, and every woman of her neighbour, jewels of silver, and jewels of gold.” ");
INSERT INTO engwebpb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","The LORD gave the people favour in the sight of the Egyptians. Moreover, the man Moses was very great in the land of Egypt, in the sight of Pharaoh’s servants, and in the sight of the people. ");
INSERT INTO engwebpb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses said, “This is what the LORD says: ‘About midnight I will go out into the middle of Egypt, ");
INSERT INTO engwebpb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","and all the firstborn in the land of Egypt shall die, from the firstborn of Pharaoh who sits on his throne, even to the firstborn of the female servant who is behind the mill, and all the firstborn of livestock. ");
INSERT INTO engwebpb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","There will be a great cry throughout all the land of Egypt, such as there has not been, nor will be any more. ");
INSERT INTO engwebpb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But against any of the children of Israel a dog won’t even bark or move its tongue, against man or animal, that you may know that the LORD makes a distinction between the Egyptians and Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","All these servants of yours will come down to me, and bow down themselves to me, saying, “Get out, with all the people who follow you;” and after that I will go out.’” He went out from Pharaoh in hot anger. ");
INSERT INTO engwebpb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","The LORD said to Moses, “Pharaoh won’t listen to you, that my wonders may be multiplied in the land of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses and Aaron did all these wonders before Pharaoh, but the LORD hardened Pharaoh’s heart, and he didn’t let the children of Israel go out of his land. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","The LORD spoke to Moses and Aaron in the land of Egypt, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“This month shall be to you the beginning of months. It shall be the first month of the year to you. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Speak to all the congregation of Israel, saying, ‘On the tenth day of this month, they shall take to them every man a lamb, according to their fathers’ houses, a lamb for a household; ");
INSERT INTO engwebpb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","and if the household is too little for a lamb, then he and his neighbour next to his house shall take one according to the number of the souls. You shall make your count for the lamb according to what everyone can eat. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Your lamb shall be without defect, a male a year old. You shall take it from the sheep or from the goats. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","You shall keep it until the fourteenth day of the same month; and the whole assembly of the congregation of Israel shall kill it at evening. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","They shall take some of the blood, and put it on the two door posts and on the lintel, on the houses in which they shall eat it. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","They shall eat the meat in that night, roasted with fire, with unleavened bread. They shall eat it with bitter herbs. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Don’t eat it raw, nor boiled at all with water, but roasted with fire; with its head, its legs and its inner parts. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","You shall let nothing of it remain until the morning; but that which remains of it until the morning you shall burn with fire. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","This is how you shall eat it: with your belt on your waist, your sandals on your feet, and your staff in your hand; and you shall eat it in haste: it is the LORD’s Passover. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","For I will go through the land of Egypt in that night, and will strike all the firstborn in the land of Egypt, both man and animal. I will execute judgements against all the gods of Egypt. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","The blood shall be to you for a token on the houses where you are. When I see the blood, I will pass over you, and no plague will be on you to destroy you when I strike the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","This day shall be a memorial for you. You shall keep it as a feast to the LORD. You shall keep it as a feast throughout your generations by an ordinance forever. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“‘Seven days you shall eat unleavened bread; even the first day you shall put away yeast out of your houses, for whoever eats leavened bread from the first day until the seventh day, that soul shall be cut off from Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","In the first day there shall be to you a holy convocation, and in the seventh day a holy convocation; no kind of work shall be done in them, except that which every man must eat, only that may be done by you. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","You shall observe the feast of unleavened bread; for in this same day I have brought your armies out of the land of Egypt. Therefore you shall observe this day throughout your generations by an ordinance forever. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In the first month, on the fourteenth day of the month at evening, you shall eat unleavened bread, until the twenty first day of the month at evening. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","There shall be no yeast found in your houses for seven days, for whoever eats that which is leavened, that soul shall be cut off from the congregation of Israel, whether he is a foreigner, or one who is born in the land. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","You shall eat nothing leavened. In all your habitations you shall eat unleavened bread.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses called for all the elders of Israel, and said to them, “Draw out, and take lambs according to your families, and kill the Passover. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","You shall take a bunch of hyssop, and dip it in the blood that is in the basin, and strike the lintel and the two door posts with the blood that is in the basin. None of you shall go out of the door of his house until the morning. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","For the LORD will pass through to strike the Egyptians; and when he sees the blood on the lintel, and on the two door posts, the LORD will pass over the door, and will not allow the destroyer to come in to your houses to strike you. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","You shall observe this thing for an ordinance to you and to your sons forever. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","It shall happen when you have come to the land which the LORD will give you, as he has promised, that you shall keep this service. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","It will happen, when your children ask you, ‘What do you mean by this service?’ ");
INSERT INTO engwebpb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","that you shall say, ‘It is the sacrifice of the LORD’s Passover, who passed over the houses of the children of Israel in Egypt, when he struck the Egyptians, and spared our houses.’” The people bowed their heads and worshipped. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","The children of Israel went and did so; as the LORD had commanded Moses and Aaron, so they did. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","At midnight, the LORD struck all the firstborn in the land of Egypt, from the firstborn of Pharaoh who sat on his throne to the firstborn of the captive who was in the dungeon, and all the firstborn of livestock. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaoh rose up in the night, he, and all his servants, and all the Egyptians; and there was a great cry in Egypt, for there was not a house where there was not one dead. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","He called for Moses and Aaron by night, and said, “Rise up, get out from amongst my people, both you and the children of Israel; and go, serve the LORD, as you have said! ");
INSERT INTO engwebpb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Take both your flocks and your herds, as you have said, and be gone; and bless me also!” ");
INSERT INTO engwebpb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","The Egyptians were urgent with the people, to send them out of the land in haste, for they said, “We are all dead men.” ");
INSERT INTO engwebpb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","The people took their dough before it was leavened, their kneading troughs being bound up in their clothes on their shoulders. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","The children of Israel did according to the word of Moses; and they asked of the Egyptians jewels of silver, and jewels of gold, and clothing. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","The LORD gave the people favour in the sight of the Egyptians, so that they let them have what they asked. They plundered the Egyptians. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The children of Israel travelled from Rameses to Succoth, about six hundred thousand on foot who were men, in addition to children. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","A mixed multitude went up also with them, with flocks, herds, and even very much livestock. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","They baked unleavened cakes of the dough which they brought out of Egypt; for it wasn’t leavened, because they were thrust out of Egypt, and couldn’t wait, and they had not prepared any food for themselves. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Now the time that the children of Israel lived in Egypt was four hundred and thirty years. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","At the end of four hundred and thirty years, to the day, all of the LORD’s armies went out from the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","It is a night to be much observed to the LORD for bringing them out from the land of Egypt. This is that night of the LORD, to be much observed by all the children of Israel throughout their generations. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","The LORD said to Moses and Aaron, “This is the ordinance of the Passover. No foreigner shall eat of it, ");
INSERT INTO engwebpb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","but every man’s servant who is bought for money, when you have circumcised him, then shall he eat of it. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A foreigner and a hired servant shall not eat of it. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","It must be eaten in one house. You shall not carry any of the meat outside of the house. Do not break any of its bones. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","All the congregation of Israel shall keep it. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","When a stranger lives as a foreigner with you, and would like to keep the Passover to the LORD, let all his males be circumcised, and then let him come near and keep it. He shall be as one who is born in the land; but no uncircumcised person shall eat of it. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","One law shall be to him who is born at home, and to the stranger who lives as a foreigner amongst you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","All the children of Israel did so. As the LORD commanded Moses and Aaron, so they did. ");
INSERT INTO engwebpb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","That same day, the LORD brought the children of Israel out of the land of Egypt by their armies. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Sanctify to me all the firstborn, whatever opens the womb amongst the children of Israel, both of man and of animal. It is mine.” ");
INSERT INTO engwebpb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses said to the people, “Remember this day, in which you came out of Egypt, out of the house of bondage; for by strength of hand the LORD brought you out from this place. No leavened bread shall be eaten. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Today you go out in the month Abib. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","It shall be, when the LORD brings you into the land of the Canaanite, and the Hittite, and the Amorite, and the Hivite, and the Jebusite, which he swore to your fathers to give you, a land flowing with milk and honey, that you shall keep this service in this month. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Seven days you shall eat unleavened bread, and in the seventh day shall be a feast to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unleavened bread shall be eaten throughout the seven days; and no leavened bread shall be seen with you. No yeast shall be seen with you, within all your borders. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","You shall tell your son in that day, saying, ‘It is because of that which the LORD did for me when I came out of Egypt.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","It shall be for a sign to you on your hand, and for a memorial between your eyes, that the LORD’s law may be in your mouth; for with a strong hand the LORD has brought you out of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","You shall therefore keep this ordinance in its season from year to year. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“It shall be, when the LORD brings you into the land of the Canaanite, as he swore to you and to your fathers, and will give it to you, ");
INSERT INTO engwebpb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","that you shall set apart to the LORD all that opens the womb, and every firstborn that comes from an animal which you have. The males shall be the LORD’s. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Every firstborn of a donkey you shall redeem with a lamb; and if you will not redeem it, then you shall break its neck; and you shall redeem all the firstborn of man amongst your sons. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","It shall be, when your son asks you in time to come, saying, ‘What is this?’ that you shall tell him, ‘By strength of hand the LORD brought us out from Egypt, from the house of bondage. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","When Pharaoh stubbornly refused to let us go, the LORD killed all the firstborn in the land of Egypt, both the firstborn of man, and the firstborn of livestock. Therefore I sacrifice to the LORD all that opens the womb, being males; but all the firstborn of my sons I redeem.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","It shall be for a sign on your hand, and for symbols between your eyes; for by strength of hand the LORD brought us out of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","When Pharaoh had let the people go, God didn’t lead them by the way of the land of the Philistines, although that was near; for God said, “Lest perhaps the people change their minds when they see war, and they return to Egypt”; ");
INSERT INTO engwebpb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","but God led the people around by the way of the wilderness by the Red Sea; and the children of Israel went up armed out of the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses took the bones of Joseph with him, for he had made the children of Israel swear, saying, “God will surely visit you, and you shall carry up my bones away from here with you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","They took their journey from Succoth, and encamped in Etham, in the edge of the wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","The LORD went before them by day in a pillar of cloud, to lead them on their way, and by night in a pillar of fire, to give them light, that they might go by day and by night: ");
INSERT INTO engwebpb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","the pillar of cloud by day, and the pillar of fire by night, didn’t depart from before the people. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Speak to the children of Israel, that they turn back and encamp before Pihahiroth, between Migdol and the sea, before Baal Zephon. You shall encamp opposite it by the sea. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh will say of the children of Israel, ‘They are entangled in the land. The wilderness has shut them in.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I will harden Pharaoh’s heart, and he will follow after them; and I will get honour over Pharaoh, and over all his armies; and the Egyptians shall know that I am the LORD.” They did so. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","The king of Egypt was told that the people had fled; and the heart of Pharaoh and of his servants was changed towards the people, and they said, “What is this we have done, that we have let Israel go from serving us?” ");
INSERT INTO engwebpb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","He prepared his chariot, and took his army with him; ");
INSERT INTO engwebpb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","and he took six hundred chosen chariots, and all the chariots of Egypt, with captains over all of them. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","The LORD hardened the heart of Pharaoh king of Egypt, and he pursued the children of Israel; for the children of Israel went out with a high hand. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","The Egyptians pursued them. All the horses and chariots of Pharaoh, his horsemen, and his army overtook them encamping by the sea, beside Pihahiroth, before Baal Zephon. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","When Pharaoh came near, the children of Israel lifted up their eyes, and behold, the Egyptians were marching after them; and they were very afraid. The children of Israel cried out to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","They said to Moses, “Because there were no graves in Egypt, have you taken us away to die in the wilderness? Why have you treated us this way, to bring us out of Egypt? ");
INSERT INTO engwebpb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Isn’t this the word that we spoke to you in Egypt, saying, ‘Leave us alone, that we may serve the Egyptians’? For it would have been better for us to serve the Egyptians than to die in the wilderness.” ");
INSERT INTO engwebpb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses said to the people, “Don’t be afraid. Stand still, and see the salvation of the LORD, which he will work for you today; for you will never again see the Egyptians whom you have seen today. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","The LORD will fight for you, and you shall be still.” ");
INSERT INTO engwebpb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","The LORD said to Moses, “Why do you cry to me? Speak to the children of Israel, that they go forward. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Lift up your rod, and stretch out your hand over the sea and divide it. Then the children of Israel shall go into the middle of the sea on dry ground. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Behold, I myself will harden the hearts of the Egyptians, and they will go in after them. I will get myself honour over Pharaoh, and over all his armies, over his chariots, and over his horsemen. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","The Egyptians shall know that I am the LORD when I have gotten myself honour over Pharaoh, over his chariots, and over his horsemen.” ");
INSERT INTO engwebpb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","The angel of God, who went before the camp of Israel, moved and went behind them; and the pillar of cloud moved from before them, and stood behind them. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","It came between the camp of Egypt and the camp of Israel. There was the cloud and the darkness, yet it gave light by night. One didn’t come near the other all night. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses stretched out his hand over the sea, and the LORD caused the sea to go back by a strong east wind all night, and made the sea dry land, and the waters were divided. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","The children of Israel went into the middle of the sea on the dry ground; and the waters were a wall to them on their right hand and on their left. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","The Egyptians pursued, and went in after them into the middle of the sea: all of Pharaoh’s horses, his chariots, and his horsemen. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","In the morning watch, the LORD looked out on the Egyptian army through the pillar of fire and of cloud, and confused the Egyptian army. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","He took off their chariot wheels, and they drove them heavily; so that the Egyptians said, “Let’s flee from the face of Israel, for the LORD fights for them against the Egyptians!” ");
INSERT INTO engwebpb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","The LORD said to Moses, “Stretch out your hand over the sea, that the waters may come again on the Egyptians, on their chariots, and on their horsemen.” ");
INSERT INTO engwebpb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moses stretched out his hand over the sea, and the sea returned to its strength when the morning appeared; and the Egyptians fled against it. The LORD overthrew the Egyptians in the middle of the sea. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The waters returned, and covered the chariots and the horsemen, even all Pharaoh’s army that went in after them into the sea. There remained not so much as one of them. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the children of Israel walked on dry land in the middle of the sea, and the waters were a wall to them on their right hand and on their left. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Thus the LORD saved Israel that day out of the hand of the Egyptians; and Israel saw the Egyptians dead on the seashore. ");
INSERT INTO engwebpb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israel saw the great work which the LORD did to the Egyptians, and the people feared the LORD; and they believed in the LORD and in his servant Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the children of Israel sang this song to the LORD, and said, “I will sing to the LORD, for he has triumphed gloriously. He has thrown the horse and his rider into the sea. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","The LORD is my strength and song. He has become my salvation. This is my God, and I will praise him; my father’s God, and I will exalt him. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The LORD is a man of war. The LORD is his name. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","He has cast Pharaoh’s chariots and his army into the sea. His chosen captains are sunk in the Red Sea. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The deeps cover them. They went down into the depths like a stone. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Your right hand, LORD, is glorious in power. Your right hand, LORD, dashes the enemy in pieces. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","In the greatness of your excellency, you overthrow those who rise up against you. You send out your wrath. It consumes them as stubble. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","With the blast of your nostrils, the waters were piled up. The floods stood upright as a heap. The deeps were congealed in the heart of the sea. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The enemy said, ‘I will pursue. I will overtake. I will divide the plunder. My desire will be satisfied on them. I will draw my sword. My hand will destroy them.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","You blew with your wind. The sea covered them. They sank like lead in the mighty waters. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who is like you, LORD, amongst the gods? Who is like you, glorious in holiness, fearful in praises, doing wonders? ");
INSERT INTO engwebpb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","You stretched out your right hand. The earth swallowed them. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“You, in your loving kindness, have led the people that you have redeemed. You have guided them in your strength to your holy habitation. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The peoples have heard. They tremble. Pangs have taken hold of the inhabitants of Philistia. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then the chiefs of Edom were dismayed. Trembling takes hold of the mighty men of Moab. All the inhabitants of Canaan have melted away. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Terror and dread falls on them. By the greatness of your arm they are as still as a stone, until your people pass over, LORD, until the people you have purchased pass over. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will bring them in, and plant them in the mountain of your inheritance, the place, LORD, which you have made for yourself to dwell in: the sanctuary, Lord, which your hands have established. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","The LORD will reign forever and ever.” ");
INSERT INTO engwebpb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For the horses of Pharaoh went in with his chariots and with his horsemen into the sea, and the LORD brought back the waters of the sea on them; but the children of Israel walked on dry land in the middle of the sea. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam the prophetess, the sister of Aaron, took a tambourine in her hand; and all the women went out after her with tambourines and with dances. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam answered them, “Sing to the LORD, for he has triumphed gloriously. He has thrown the horse and his rider into the sea.” ");
INSERT INTO engwebpb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moses led Israel onward from the Red Sea, and they went out into the wilderness of Shur; and they went three days in the wilderness, and found no water. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","When they came to Marah, they couldn’t drink from the waters of Marah, for they were bitter. Therefore its name was called Marah. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","The people murmured against Moses, saying, “What shall we drink?” ");
INSERT INTO engwebpb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Then he cried to the LORD. The LORD showed him a tree, and he threw it into the waters, and the waters were made sweet. There he made a statute and an ordinance for them, and there he tested them. ");
INSERT INTO engwebpb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","He said, “If you will diligently listen to the LORD your God’s voice, and will do that which is right in his eyes, and will pay attention to his commandments, and keep all his statutes, I will put none of the diseases on you which I have put on the Egyptians; for I am the LORD who heals you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","They came to Elim, where there were twelve springs of water and seventy palm trees. They encamped there by the waters. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","They took their journey from Elim, and all the congregation of the children of Israel came to the wilderness of Sin, which is between Elim and Sinai, on the fifteenth day of the second month after their departing out of the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","The whole congregation of the children of Israel murmured against Moses and against Aaron in the wilderness; ");
INSERT INTO engwebpb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","and the children of Israel said to them, “We wish that we had died by the LORD’s hand in the land of Egypt, when we sat by the meat pots, when we ate our fill of bread, for you have brought us out into this wilderness to kill this whole assembly with hunger.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then the LORD said to Moses, “Behold, I will rain bread from the sky for you, and the people shall go out and gather a day’s portion every day, that I may test them, whether they will walk in my law or not. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","It shall come to pass on the sixth day, that they shall prepare that which they bring in, and it shall be twice as much as they gather daily.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moses and Aaron said to all the children of Israel, “At evening, you shall know that the LORD has brought you out from the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","In the morning, you shall see the LORD’s glory; because he hears your murmurings against the LORD. Who are we, that you murmur against us?” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moses said, “Now the LORD will give you meat to eat in the evening, and in the morning bread to satisfy you, because the LORD hears your murmurings which you murmur against him. And who are we? Your murmurings are not against us, but against the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moses said to Aaron, “Tell all the congregation of the children of Israel, ‘Come close to the LORD, for he has heard your murmurings.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","As Aaron spoke to the whole congregation of the children of Israel, they looked towards the wilderness, and behold, the LORD’s glory appeared in the cloud. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard the murmurings of the children of Israel. Speak to them, saying, ‘At evening you shall eat meat, and in the morning you shall be filled with bread. Then you will know that I am the LORD your God.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","In the evening, quail came up and covered the camp; and in the morning the dew lay around the camp. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","When the dew that lay had gone, behold, on the surface of the wilderness was a small round thing, small as the frost on the ground. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the children of Israel saw it, they said to one another, “What is it?” For they didn’t know what it was. Moses said to them, “It is the bread which the LORD has given you to eat. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is the thing which the LORD has commanded: ‘Gather of it everyone according to his eating; an omer a head, according to the number of your persons, you shall take it, every man for those who are in his tent.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","The children of Israel did so, and some gathered more, some less. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","When they measured it with an omer, he who gathered much had nothing over, and he who gathered little had no lack. They each gathered according to his eating. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moses said to them, “Let no one leave of it until the morning.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Notwithstanding they didn’t listen to Moses, but some of them left of it until the morning, so it bred worms and became foul; and Moses was angry with them. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","They gathered it morning by morning, everyone according to his eating. When the sun grew hot, it melted. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","On the sixth day, they gathered twice as much bread, two omers for each one; and all the rulers of the congregation came and told Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","He said to them, “This is that which the LORD has spoken, ‘Tomorrow is a solemn rest, a holy Sabbath to the LORD. Bake that which you want to bake, and boil that which you want to boil; and all that remains over lay up for yourselves to be kept until the morning.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","They laid it up until the morning, as Moses ordered, and it didn’t become foul, and there were no worms in it. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses said, “Eat that today, for today is a Sabbath to the LORD. Today you shall not find it in the field. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Six days you shall gather it, but on the seventh day is the Sabbath. In it there shall be none.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","On the seventh day, some of the people went out to gather, and they found none. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","The LORD said to Moses, “How long do you refuse to keep my commandments and my laws? ");
INSERT INTO engwebpb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Behold, because the LORD has given you the Sabbath, therefore he gives you on the sixth day the bread of two days. Everyone stay in his place. Let no one go out of his place on the seventh day.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people rested on the seventh day. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","The house of Israel called its name “Manna”, and it was like coriander seed, white; and its taste was like wafers with honey. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses said, “This is the thing which the LORD has commanded, ‘Let an omer-full of it be kept throughout your generations, that they may see the bread with which I fed you in the wilderness, when I brought you out of the land of Egypt.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses said to Aaron, “Take a pot, and put an omer-full of manna in it, and lay it up before the LORD, to be kept throughout your generations.” ");
INSERT INTO engwebpb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","As the LORD commanded Moses, so Aaron laid it up before the Testimony, to be kept. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","The children of Israel ate the manna forty years, until they came to an inhabited land. They ate the manna until they came to the borders of the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Now an omer is one tenth of an ephah. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","All the congregation of the children of Israel travelled from the wilderness of Sin, starting according to the LORD’s commandment, and encamped in Rephidim; but there was no water for the people to drink. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Therefore the people quarrelled with Moses, and said, “Give us water to drink.” Moses said to them, “Why do you quarrel with me? Why do you test the LORD?” ");
INSERT INTO engwebpb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","The people were thirsty for water there; so the people murmured against Moses, and said, “Why have you brought us up out of Egypt, to kill us, our children, and our livestock with thirst?” ");
INSERT INTO engwebpb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moses cried to the LORD, saying, “What shall I do with these people? They are almost ready to stone me.” ");
INSERT INTO engwebpb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","The LORD said to Moses, “Walk on before the people, and take the elders of Israel with you, and take the rod in your hand with which you struck the Nile, and go. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Behold, I will stand before you there on the rock in Horeb. You shall strike the rock, and water will come out of it, that the people may drink.” Moses did so in the sight of the elders of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","He called the name of the place Massah, and Meribah, because the children of Israel quarrelled, and because they tested the LORD, saying, “Is the LORD amongst us, or not?” ");
INSERT INTO engwebpb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Then Amalek came and fought with Israel in Rephidim. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses said to Joshua, “Choose men for us, and go out to fight with Amalek. Tomorrow I will stand on the top of the hill with God’s rod in my hand.” ");
INSERT INTO engwebpb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","So Joshua did as Moses had told him, and fought with Amalek; and Moses, Aaron, and Hur went up to the top of the hill. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","When Moses held up his hand, Israel prevailed. When he let down his hand, Amalek prevailed. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","But Moses’ hands were heavy; so they took a stone, and put it under him, and he sat on it. Aaron and Hur held up his hands, the one on the one side, and the other on the other side. His hands were steady until sunset. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Joshua defeated Amalek and his people with the edge of the sword. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","The LORD said to Moses, “Write this for a memorial in a book, and rehearse it in the ears of Joshua: that I will utterly blot out the memory of Amalek from under the sky.” ");
INSERT INTO engwebpb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moses built an altar, and called its name “The LORD our Banner”. ");
INSERT INTO engwebpb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","He said, “The LORD has sworn: ‘The LORD will have war with Amalek from generation to generation.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Now Jethro, the priest of Midian, Moses’ father-in-law, heard of all that God had done for Moses and for Israel his people, how the LORD had brought Israel out of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jethro, Moses’ father-in-law, received Zipporah, Moses’ wife, after he had sent her away, ");
INSERT INTO engwebpb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","and her two sons. The name of one son was Gershom, for Moses said, “I have lived as a foreigner in a foreign land”. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","The name of the other was Eliezer, for he said, “My father’s God was my help and delivered me from Pharaoh’s sword.” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro, Moses’ father-in-law, came with Moses’ sons and his wife to Moses into the wilderness where he was encamped, at the Mountain of God. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","He said to Moses, “I, your father-in-law Jethro, have come to you with your wife, and her two sons with her.” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses went out to meet his father-in-law, and bowed and kissed him. They asked each other of their welfare, and they came into the tent. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses told his father-in-law all that the LORD had done to Pharaoh and to the Egyptians for Israel’s sake, all the hardships that had come on them on the way, and how the LORD delivered them. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro rejoiced for all the goodness which the LORD had done to Israel, in that he had delivered them out of the hand of the Egyptians. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro said, “Blessed be the LORD, who has delivered you out of the hand of the Egyptians, and out of the hand of Pharaoh; who has delivered the people from under the hand of the Egyptians. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I know that the LORD is greater than all gods because of the way that they treated people arrogantly.” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jethro, Moses’ father-in-law, took a burnt offering and sacrifices for God. Aaron came with all the elders of Israel, to eat bread with Moses’ father-in-law before God. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","On the next day, Moses sat to judge the people, and the people stood around Moses from the morning to the evening. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","When Moses’ father-in-law saw all that he did to the people, he said, “What is this thing that you do for the people? Why do you sit alone, and all the people stand around you from morning to evening?” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses said to his father-in-law, “Because the people come to me to enquire of God. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","When they have a matter, they come to me, and I judge between a man and his neighbour, and I make them know the statutes of God, and his laws.” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moses’ father-in-law said to him, “The thing that you do is not good. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","You will surely wear away, both you, and this people that is with you; for the thing is too heavy for you. You are not able to perform it yourself alone. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Listen now to my voice. I will give you counsel, and God be with you. You represent the people before God, and bring the causes to God. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","You shall teach them the statutes and the laws, and shall show them the way in which they must walk, and the work that they must do. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Moreover you shall provide out of all the people able men which fear God: men of truth, hating unjust gain; and place such over them, to be rulers of thousands, rulers of hundreds, rulers of fifties, and rulers of tens. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Let them judge the people at all times. It shall be that every great matter they shall bring to you, but every small matter they shall judge themselves. So shall it be easier for you, and they shall share the load with you. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you will do this thing, and God commands you so, then you will be able to endure, and all these people also will go to their place in peace.” ");
INSERT INTO engwebpb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","So Moses listened to the voice of his father-in-law, and did all that he had said. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses chose able men out of all Israel, and made them heads over the people, rulers of thousands, rulers of hundreds, rulers of fifties, and rulers of tens. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","They judged the people at all times. They brought the hard cases to Moses, but every small matter they judged themselves. ");
INSERT INTO engwebpb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moses let his father-in-law depart, and he went his way into his own land. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month after the children of Israel had gone out of the land of Egypt, on that same day they came into the wilderness of Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","When they had departed from Rephidim, and had come to the wilderness of Sinai, they encamped in the wilderness; and there Israel encamped before the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses went up to God, and the LORD called to him out of the mountain, saying, “This is what you shall tell the house of Jacob, and tell the children of Israel: ");
INSERT INTO engwebpb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘You have seen what I did to the Egyptians, and how I bore you on eagles’ wings, and brought you to myself. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Now therefore, if you will indeed obey my voice and keep my covenant, then you shall be my own possession from amongst all peoples; for all the earth is mine; ");
INSERT INTO engwebpb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","and you shall be to me a kingdom of priests and a holy nation.’ These are the words which you shall speak to the children of Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moses came and called for the elders of the people, and set before them all these words which the LORD commanded him. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","All the people answered together, and said, “All that the LORD has spoken we will do.” Moses reported the words of the people to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","The LORD said to Moses, “Behold, I come to you in a thick cloud, that the people may hear when I speak with you, and may also believe you forever.” Moses told the words of the people to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","The LORD said to Moses, “Go to the people, and sanctify them today and tomorrow, and let them wash their garments, ");
INSERT INTO engwebpb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","and be ready for the third day; for on the third day the LORD will come down in the sight of all the people on Mount Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","You shall set bounds to the people all around, saying, ‘Be careful that you don’t go up onto the mountain, or touch its border. Whoever touches the mountain shall be surely put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","No hand shall touch him, but he shall surely be stoned or shot through; whether it is animal or man, he shall not live.’ When the trumpet sounds long, they shall come up to the mountain.” ");
INSERT INTO engwebpb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moses went down from the mountain to the people, and sanctified the people; and they washed their clothes. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","He said to the people, “Be ready by the third day. Don’t have sexual relations with a woman.” ");
INSERT INTO engwebpb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","On the third day, when it was morning, there were thunders and lightnings, and a thick cloud on the mountain, and the sound of an exceedingly loud trumpet; and all the people who were in the camp trembled. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses led the people out of the camp to meet God; and they stood at the lower part of the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","All of Mount Sinai smoked, because the LORD descended on it in fire; and its smoke ascended like the smoke of a furnace, and the whole mountain quaked greatly. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","When the sound of the trumpet grew louder and louder, Moses spoke, and God answered him by a voice. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","The LORD came down on Mount Sinai, to the top of the mountain. The LORD called Moses to the top of the mountain, and Moses went up. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","The LORD said to Moses, “Go down, warn the people, lest they break through to the LORD to gaze, and many of them perish. ");
INSERT INTO engwebpb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Let the priests also, who come near to the LORD, sanctify themselves, lest the LORD break out on them.” ");
INSERT INTO engwebpb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses said to the LORD, “The people can’t come up to Mount Sinai, for you warned us, saying, ‘Set bounds around the mountain, and sanctify it.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","The LORD said to him, “Go down! You shall bring Aaron up with you, but don’t let the priests and the people break through to come up to the LORD, lest he break out against them.” ");
INSERT INTO engwebpb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down to the people, and told them. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","God spoke all these words, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I am the LORD your God, who brought you out of the land of Egypt, out of the house of bondage. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“You shall have no other gods before me. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“You shall not make for yourselves an idol, nor any image of anything that is in the heavens above, or that is in the earth beneath, or that is in the water under the earth: ");
INSERT INTO engwebpb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","you shall not bow yourself down to them, nor serve them, for I, the LORD your God, am a jealous God, visiting the iniquity of the fathers on the children, on the third and on the fourth generation of those who hate me, ");
INSERT INTO engwebpb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","and showing loving kindness to thousands of those who love me and keep my commandments. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“You shall not misuse the name of the LORD your God, for the LORD will not hold him guiltless who misuses his name. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Remember the Sabbath day, to keep it holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","You shall labour six days, and do all your work, ");
INSERT INTO engwebpb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","but the seventh day is a Sabbath to the LORD your God. You shall not do any work in it, you, nor your son, nor your daughter, your male servant, nor your female servant, nor your livestock, nor your stranger who is within your gates; ");
INSERT INTO engwebpb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","for in six days the LORD made heaven and earth, the sea, and all that is in them, and rested the seventh day; therefore the LORD blessed the Sabbath day, and made it holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Honour your father and your mother, that your days may be long in the land which the LORD your God gives you. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“You shall not murder. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“You shall not commit adultery. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“You shall not steal. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“You shall not give false testimony against your neighbour. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“You shall not covet your neighbour’s house. You shall not covet your neighbour’s wife, nor his male servant, nor his female servant, nor his ox, nor his donkey, nor anything that is your neighbour’s.” ");
INSERT INTO engwebpb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","All the people perceived the thunderings, the lightnings, the sound of the trumpet, and the mountain smoking. When the people saw it, they trembled, and stayed at a distance. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","They said to Moses, “Speak with us yourself, and we will listen; but don’t let God speak with us, lest we die.” ");
INSERT INTO engwebpb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses said to the people, “Don’t be afraid, for God has come to test you, and that his fear may be before you, that you won’t sin.” ");
INSERT INTO engwebpb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","The people stayed at a distance, and Moses came near to the thick darkness where God was. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","The LORD said to Moses, “This is what you shall tell the children of Israel: ‘You yourselves have seen that I have talked with you from heaven. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","You shall most certainly not make gods of silver or gods of gold for yourselves to be alongside me. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","You shall make an altar of earth for me, and shall sacrifice on it your burnt offerings and your peace offerings, your sheep and your cattle. In every place where I record my name I will come to you and I will bless you. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","If you make me an altar of stone, you shall not build it of cut stones; for if you lift up your tool on it, you have polluted it. ");
INSERT INTO engwebpb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","You shall not go up by steps to my altar, that your nakedness may not be exposed to it.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Now these are the ordinances which you shall set before them: ");
INSERT INTO engwebpb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“If you buy a Hebrew servant, he shall serve six years, and in the seventh he shall go out free without paying anything. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he comes in by himself, he shall go out by himself. If he is married, then his wife shall go out with him. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master gives him a wife and she bears him sons or daughters, the wife and her children shall be her master’s, and he shall go out by himself. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But if the servant shall plainly say, ‘I love my master, my wife, and my children. I will not go out free;’ ");
INSERT INTO engwebpb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then his master shall bring him to God, and shall bring him to the door or to the doorpost, and his master shall bore his ear through with an awl, and he shall serve him forever. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“If a man sells his daughter to be a female servant, she shall not go out as the male servants do. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she doesn’t please her master, who has married her to himself, then he shall let her be redeemed. He shall have no right to sell her to a foreign people, since he has dealt deceitfully with her. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","If he marries her to his son, he shall deal with her as a daughter. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If he takes another wife to himself, he shall not diminish her food, her clothing, and her marital rights. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","If he doesn’t do these three things for her, she may go free without paying any money. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“One who strikes a man so that he dies shall surely be put to death, ");
INSERT INTO engwebpb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","but not if it is unintentional, but God allows it to happen; then I will appoint you a place where he shall flee. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","If a man schemes and comes presumptuously on his neighbour to kill him, you shall take him from my altar, that he may die. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Anyone who attacks his father or his mother shall be surely put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Anyone who kidnaps someone and sells him, or if he is found in his hand, he shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Anyone who curses his father or his mother shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“If men quarrel and one strikes the other with a stone, or with his fist, and he doesn’t die, but is confined to bed; ");
INSERT INTO engwebpb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","if he rises again and walks around with his staff, then he who struck him shall be cleared; only he shall pay for the loss of his time, and shall provide for his healing until he is thoroughly healed. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“If a man strikes his servant or his maid with a rod, and he dies under his hand, the man shall surely be punished. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Notwithstanding, if his servant gets up after a day or two, he shall not be punished, for the servant is his property. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“If men fight and hurt a pregnant woman so that she gives birth prematurely, and yet no harm follows, he shall be surely fined as much as the woman’s husband demands and the judges allow. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if any harm follows, then you must take life for life, ");
INSERT INTO engwebpb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eye for eye, tooth for tooth, hand for hand, foot for foot, ");
INSERT INTO engwebpb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","burning for burning, wound for wound, and bruise for bruise. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“If a man strikes his servant’s eye, or his maid’s eye, and destroys it, he shall let him go free for his eye’s sake. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","If he strikes out his male servant’s tooth, or his female servant’s tooth, he shall let the servant go free for his tooth’s sake. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“If a bull gores a man or a woman to death, the bull shall surely be stoned, and its meat shall not be eaten; but the owner of the bull shall not be held responsible. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the bull had a habit of goring in the past, and this has been testified to its owner, and he has not kept it in, but it has killed a man or a woman, the bull shall be stoned, and its owner shall also be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If a ransom is imposed on him, then he shall give for the redemption of his life whatever is imposed. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Whether it has gored a son or has gored a daughter, according to this judgement it shall be done to him. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the bull gores a male servant or a female servant, thirty shekels of silver shall be given to their master, and the ox shall be stoned. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“If a man opens a pit, or if a man digs a pit and doesn’t cover it, and a bull or a donkey falls into it, ");
INSERT INTO engwebpb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","the owner of the pit shall make it good. He shall give money to its owner, and the dead animal shall be his. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“If one man’s bull injures another’s, so that it dies, then they shall sell the live bull, and divide its price; and they shall also divide the dead animal. ");
INSERT INTO engwebpb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Or if it is known that the bull was in the habit of goring in the past, and its owner has not kept it in, he shall surely pay bull for bull, and the dead animal shall be his own. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“If a man steals an ox or a sheep, and kills it or sells it, he shall pay five oxen for an ox, and four sheep for a sheep. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If the thief is found breaking in, and is struck so that he dies, there shall be no guilt of bloodshed for him. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","If the sun has risen on him, he is guilty of bloodshed. He shall make restitution. If he has nothing, then he shall be sold for his theft. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If the stolen property is found in his hand alive, whether it is ox, donkey, or sheep, he shall pay double. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“If a man causes a field or vineyard to be eaten by letting his animal loose, and it grazes in another man’s field, he shall make restitution from the best of his own field, and from the best of his own vineyard. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“If fire breaks out, and catches in thorns so that the shocks of grain, or the standing grain, or the field are consumed; he who kindled the fire shall surely make restitution. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“If a man delivers to his neighbour money or stuff to keep, and it is stolen out of the man’s house, if the thief is found, he shall pay double. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","If the thief isn’t found, then the master of the house shall come near to God, to find out whether or not he has put his hand on his neighbour’s goods. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","For every matter of trespass, whether it is for ox, for donkey, for sheep, for clothing, or for any kind of lost thing, about which one says, ‘This is mine,’ the cause of both parties shall come before God. He whom God condemns shall pay double to his neighbour. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“If a man delivers to his neighbour a donkey, an ox, a sheep, or any animal to keep, and it dies or is injured, or driven away, no man seeing it; ");
INSERT INTO engwebpb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","the oath of the LORD shall be between them both, he has not put his hand on his neighbour’s goods; and its owner shall accept it, and he shall not make restitution. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if it is stolen from him, the one who stole shall make restitution to its owner. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If it is torn in pieces, let him bring it for evidence. He shall not make good that which was torn. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“If a man borrows anything of his neighbour’s, and it is injured, or dies, its owner not being with it, he shall surely make restitution. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","If its owner is with it, he shall not make it good. If it is a leased thing, it came for its lease. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“If a man entices a virgin who isn’t pledged to be married, and lies with her, he shall surely pay a dowry for her to be his wife. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If her father utterly refuses to give her to him, he shall pay money according to the dowry of virgins. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“You shall not allow a sorceress to live. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Whoever has sex with an animal shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“He who sacrifices to any god, except to the LORD only, shall be utterly destroyed. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“You shall not wrong an alien or oppress him, for you were aliens in the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“You shall not take advantage of any widow or fatherless child. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you take advantage of them at all, and they cry at all to me, I will surely hear their cry; ");
INSERT INTO engwebpb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","and my wrath will grow hot, and I will kill you with the sword; and your wives shall be widows, and your children fatherless. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“If you lend money to any of my people with you who is poor, you shall not be to him as a creditor. You shall not charge him interest. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If you take your neighbour’s garment as collateral, you shall restore it to him before the sun goes down, ");
INSERT INTO engwebpb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","for that is his only covering, it is his garment for his skin. What would he sleep in? It will happen, when he cries to me, that I will hear, for I am gracious. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“You shall not blaspheme God, nor curse a ruler of your people. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“You shall not delay to offer from your harvest and from the outflow of your presses. “You shall give the firstborn of your sons to me. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","You shall do likewise with your cattle and with your sheep. It shall be with its mother seven days, then on the eighth day you shall give it to me. ");
INSERT INTO engwebpb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“You shall be holy men to me, therefore you shall not eat any meat that is torn by animals in the field. You shall cast it to the dogs. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“You shall not spread a false report. Don’t join your hand with the wicked to be a malicious witness. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“You shall not follow a crowd to do evil. You shall not testify in court to side with a multitude to pervert justice. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","You shall not favour a poor man in his cause. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“If you meet your enemy’s ox or his donkey going astray, you shall surely bring it back to him again. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see the donkey of him who hates you fallen down under his burden, don’t leave him. You shall surely help him with it. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“You shall not deny justice to your poor people in their lawsuits. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Keep far from a false charge, and don’t kill the innocent and righteous; for I will not justify the wicked. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“You shall take no bribe, for a bribe blinds those who have sight and perverts the words of the righteous. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“You shall not oppress an alien, for you know the heart of an alien, since you were aliens in the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“For six years you shall sow your land, and shall gather in its increase, ");
INSERT INTO engwebpb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","but the seventh year you shall let it rest and lie fallow, that the poor of your people may eat; and what they leave the animal of the field shall eat. In the same way, you shall deal with your vineyard and with your olive grove. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Six days you shall do your work, and on the seventh day you shall rest, that your ox and your donkey may have rest, and the son of your servant, and the alien may be refreshed. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Be careful to do all things that I have said to you; and don’t invoke the name of other gods or even let them be heard out of your mouth. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“You shall observe a feast to me three times a year. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","You shall observe the feast of unleavened bread. Seven days you shall eat unleavened bread, as I commanded you, at the time appointed in the month Abib (for in it you came out of Egypt), and no one shall appear before me empty. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","And the feast of harvest, the first fruits of your labours, which you sow in the field; and the feast of ingathering, at the end of the year, when you gather in your labours out of the field. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Three times in the year all your males shall appear before the Lord GOD. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“You shall not offer the blood of my sacrifice with leavened bread. The fat of my feast shall not remain all night until the morning. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","You shall bring the first of the first fruits of your ground into the house of the LORD your God. “You shall not boil a young goat in its mother’s milk. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Behold, I send an angel before you, to keep you by the way, and to bring you into the place which I have prepared. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pay attention to him, and listen to his voice. Don’t provoke him, for he will not pardon your disobedience, for my name is in him. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","But if you indeed listen to his voice, and do all that I speak, then I will be an enemy to your enemies, and an adversary to your adversaries. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","For my angel shall go before you, and bring you in to the Amorite, the Hittite, the Perizzite, the Canaanite, the Hivite, and the Jebusite; and I will cut them off. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","You shall not bow down to their gods, nor serve them, nor follow their practices, but you shall utterly overthrow them and demolish their pillars. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","You shall serve the LORD your God, and he will bless your bread and your water, and I will take sickness away from amongst you. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No one will miscarry or be barren in your land. I will fulfil the number of your days. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send my terror before you, and will confuse all the people to whom you come, and I will make all your enemies turn their backs to you. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send the hornet before you, which will drive out the Hivite, the Canaanite, and the Hittite, from before you. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not drive them out from before you in one year, lest the land become desolate, and the animals of the field multiply against you. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Little by little I will drive them out from before you, until you have increased and inherit the land. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I will set your border from the Red Sea even to the sea of the Philistines, and from the wilderness to the River; for I will deliver the inhabitants of the land into your hand, and you shall drive them out before you. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","You shall make no covenant with them, nor with their gods. ");
INSERT INTO engwebpb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They shall not dwell in your land, lest they make you sin against me, for if you serve their gods, it will surely be a snare to you.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","He said to Moses, “Come up to the LORD, you, and Aaron, Nadab, and Abihu, and seventy of the elders of Israel; and worship from a distance. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses alone shall come near to the LORD, but they shall not come near. The people shall not go up with him.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses came and told the people all the LORD’s words, and all the ordinances; and all the people answered with one voice, and said, “All the words which the LORD has spoken will we do.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses wrote all the LORD’s words, then rose up early in the morning and built an altar at the base of the mountain, with twelve pillars for the twelve tribes of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","He sent young men of the children of Israel, who offered burnt offerings and sacrificed peace offerings of cattle to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses took half of the blood and put it in basins, and half of the blood he sprinkled on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","He took the book of the covenant and read it in the hearing of the people, and they said, “We will do all that the LORD has said, and be obedient.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moses took the blood, and sprinkled it on the people, and said, “Look, this is the blood of the covenant, which the LORD has made with you concerning all these words.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses, Aaron, Nadab, Abihu, and seventy of the elders of Israel went up. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","They saw the God of Israel. Under his feet was like a paved work of sapphire stone, like the skies for clearness. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","He didn’t lay his hand on the nobles of the children of Israel. They saw God, and ate and drank. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","The LORD said to Moses, “Come up to me on the mountain, and stay here, and I will give you the stone tablets with the law and the commands that I have written, that you may teach them.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moses rose up with Joshua, his servant, and Moses went up onto God’s Mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","He said to the elders, “Wait here for us, until we come again to you. Behold, Aaron and Hur are with you. Whoever is involved in a dispute can go to them.” ");
INSERT INTO engwebpb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moses went up on the mountain, and the cloud covered the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","The LORD’s glory settled on Mount Sinai, and the cloud covered it six days. The seventh day he called to Moses out of the middle of the cloud. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","The appearance of the LORD’s glory was like devouring fire on the top of the mountain in the eyes of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses entered into the middle of the cloud, and went up on the mountain; and Moses was on the mountain forty days and forty nights. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Speak to the children of Israel, that they take an offering for me. From everyone whose heart makes him willing you shall take my offering. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","This is the offering which you shall take from them: gold, silver, bronze, ");
INSERT INTO engwebpb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, scarlet, fine linen, goats’ hair, ");
INSERT INTO engwebpb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","rams’ skins dyed red, sea cow hides, acacia wood, ");
INSERT INTO engwebpb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oil for the light, spices for the anointing oil and for the sweet incense, ");
INSERT INTO engwebpb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onyx stones, and stones to be set for the ephod and for the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Let them make me a sanctuary, that I may dwell amongst them. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","According to all that I show you, the pattern of the tabernacle, and the pattern of all of its furniture, even so you shall make it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“They shall make an ark of acacia wood. Its length shall be two and a half cubits, its width a cubit and a half, and a cubit and a half its height. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","You shall overlay it with pure gold. You shall overlay it inside and outside, and you shall make a gold moulding around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","You shall cast four rings of gold for it, and put them in its four feet. Two rings shall be on the one side of it, and two rings on the other side of it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","You shall make poles of acacia wood, and overlay them with gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","You shall put the poles into the rings on the sides of the ark to carry the ark. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles shall be in the rings of the ark. They shall not be taken from it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","You shall put the covenant which I shall give you into the ark. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","You shall make a mercy seat of pure gold. Two and a half cubits shall be its length, and a cubit and a half its width. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","You shall make two cherubim of hammered gold. You shall make them at the two ends of the mercy seat. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Make one cherub at the one end, and one cherub at the other end. You shall make the cherubim on its two ends of one piece with the mercy seat. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","The cherubim shall spread out their wings upward, covering the mercy seat with their wings, with their faces towards one another. The faces of the cherubim shall be towards the mercy seat. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","You shall put the mercy seat on top of the ark, and in the ark you shall put the covenant that I will give you. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","There I will meet with you, and I will tell you from above the mercy seat, from between the two cherubim which are on the ark of the covenant, all that I command you for the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“You shall make a table of acacia wood. Its length shall be two cubits, and its width a cubit, and its height one and a half cubits. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","You shall overlay it with pure gold, and make a gold moulding around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","You shall make a rim of a hand width around it. You shall make a golden moulding on its rim around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","You shall make four rings of gold for it, and put the rings in the four corners that are on its four feet. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings shall be close to the rim, for places for the poles to carry the table. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","You shall make the poles of acacia wood, and overlay them with gold, that the table may be carried with them. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","You shall make its dishes, its spoons, its ladles, and its bowls with which to pour out offerings. You shall make them of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","You shall set bread of the presence on the table before me always. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“You shall make a lamp stand of pure gold. The lamp stand shall be made of hammered work. Its base, its shaft, its cups, its buds, and its flowers shall be of one piece with it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","There shall be six branches going out of its sides: three branches of the lamp stand out of its one side, and three branches of the lamp stand out of its other side; ");
INSERT INTO engwebpb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","three cups made like almond blossoms in one branch, a bud and a flower; and three cups made like almond blossoms in the other branch, a bud and a flower, so for the six branches going out of the lamp stand; ");
INSERT INTO engwebpb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","and in the lamp stand four cups made like almond blossoms, its buds and its flowers; ");
INSERT INTO engwebpb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","and a bud under two branches of one piece with it, and a bud under two branches of one piece with it, and a bud under two branches of one piece with it, for the six branches going out of the lamp stand. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Their buds and their branches shall be of one piece with it, all of it one beaten work of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","You shall make its lamps seven, and they shall light its lamps to give light to the space in front of it. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Its snuffers and its snuff dishes shall be of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","It shall be made of a talent of pure gold, with all these accessories. ");
INSERT INTO engwebpb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","See that you make them after their pattern, which has been shown to you on the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Moreover you shall make the tabernacle with ten curtains of fine twined linen, and blue, and purple, and scarlet, with cherubim. You shall make them with the work of a skilful workman. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","The length of each curtain shall be twenty-eight cubits, and the width of each curtain four cubits: all the curtains shall have one measure. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Five curtains shall be coupled together to one another, and the other five curtains shall be coupled to one another. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","You shall make loops of blue on the edge of the one curtain from the edge in the coupling, and you shall do likewise on the edge of the curtain that is outermost in the second coupling. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","You shall make fifty loops in the one curtain, and you shall make fifty loops in the edge of the curtain that is in the second coupling. The loops shall be opposite one another. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","You shall make fifty clasps of gold, and couple the curtains to one another with the clasps. The tabernacle shall be a unit. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“You shall make curtains of goats’ hair for a covering over the tabernacle. You shall make eleven curtains. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","The length of each curtain shall be thirty cubits, and the width of each curtain four cubits: the eleven curtains shall have one measure. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","You shall couple five curtains by themselves, and six curtains by themselves, and shall double over the sixth curtain in the forefront of the tent. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","You shall make fifty loops on the edge of the one curtain that is outermost in the coupling, and fifty loops on the edge of the curtain which is outermost in the second coupling. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","You shall make fifty clasps of bronze, and put the clasps into the loops, and couple the tent together, that it may be one. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","The overhanging part that remains of the curtains of the tent—the half curtain that remains—shall hang over the back of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","The cubit on the one side and the cubit on the other side, of that which remains in the length of the curtains of the tent, shall hang over the sides of the tabernacle on this side and on that side, to cover it. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","You shall make a covering for the tent of rams’ skins dyed red, and a covering of sea cow hides above. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“You shall make the boards for the tabernacle of acacia wood, standing upright. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ten cubits shall be the length of a board, and one and a half cubits the width of each board. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","There shall be two tenons in each board, joined to one another: thus you shall make for all the boards of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","You shall make twenty boards for the tabernacle, for the south side southward. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","You shall make forty sockets of silver under the twenty boards; two sockets under one board for its two tenons, and two sockets under another board for its two tenons. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","For the second side of the tabernacle, on the north side, twenty boards, ");
INSERT INTO engwebpb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","and their forty sockets of silver; two sockets under one board, and two sockets under another board. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","For the far side of the tabernacle westward you shall make six boards. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","You shall make two boards for the corners of the tabernacle in the far side. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","They shall be double beneath, and in the same way they shall be whole to its top to one ring: thus shall it be for them both; they shall be for the two corners. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","There shall be eight boards, and their sockets of silver, sixteen sockets; two sockets under one board, and two sockets under another board. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“You shall make bars of acacia wood: five for the boards of the one side of the tabernacle, ");
INSERT INTO engwebpb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","and five bars for the boards of the other side of the tabernacle, and five bars for the boards of the side of the tabernacle, for the far side westward. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","The middle bar in the middle of the boards shall pass through from end to end. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","You shall overlay the boards with gold, and make their rings of gold for places for the bars. You shall overlay the bars with gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","You shall set up the tabernacle according to the way that it was shown to you on the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“You shall make a veil of blue, and purple, and scarlet, and fine twined linen, with cherubim. It shall be the work of a skilful workman. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","You shall hang it on four pillars of acacia overlaid with gold; their hooks shall be of gold, on four sockets of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","You shall hang up the veil under the clasps, and shall bring the ark of the covenant in there within the veil. The veil shall separate the holy place from the most holy for you. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","You shall put the mercy seat on the ark of the covenant in the most holy place. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","You shall set the table outside the veil, and the lamp stand opposite the table on the side of the tabernacle towards the south. You shall put the table on the north side. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“You shall make a screen for the door of the Tent, of blue, and purple, and scarlet, and fine twined linen, the work of the embroiderer. ");
INSERT INTO engwebpb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","You shall make for the screen five pillars of acacia, and overlay them with gold. Their hooks shall be of gold. You shall cast five sockets of bronze for them. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“You shall make the altar of acacia wood, five cubits long, and five cubits wide. The altar shall be square. Its height shall be three cubits. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","You shall make its horns on its four corners. Its horns shall be of one piece with it. You shall overlay it with bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","You shall make its pots to take away its ashes; and its shovels, its basins, its meat hooks, and its fire pans. You shall make all its vessels of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","You shall make a grating for it of network of bronze. On the net you shall make four bronze rings in its four corners. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","You shall put it under the ledge around the altar beneath, that the net may reach halfway up the altar. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","You shall make poles for the altar, poles of acacia wood, and overlay them with bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Its poles shall be put into the rings, and the poles shall be on the two sides of the altar when carrying it. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","You shall make it hollow with planks. They shall make it as it has been shown you on the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“You shall make the court of the tabernacle: for the south side southward there shall be hangings for the court of fine twined linen one hundred cubits long for one side. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Its pillars shall be twenty, and their sockets twenty, of bronze. The hooks of the pillars and their fillets shall be of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Likewise for the length of the north side, there shall be hangings one hundred cubits long, and its pillars twenty, and their sockets twenty, of bronze; the hooks of the pillars, and their fillets, of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","For the width of the court on the west side shall be hangings of fifty cubits; their pillars ten, and their sockets ten. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","The width of the court on the east side eastward shall be fifty cubits. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","The hangings for the one side of the gate shall be fifteen cubits; their pillars three, and their sockets three. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","For the other side shall be hangings of fifteen cubits; their pillars three, and their sockets three. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","For the gate of the court shall be a screen of twenty cubits, of blue, and purple, and scarlet, and fine twined linen, the work of the embroiderer; their pillars four, and their sockets four. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the pillars of the court around shall be filleted with silver; their hooks of silver, and their sockets of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The length of the court shall be one hundred cubits, and the width fifty throughout, and the height five cubits, of fine twined linen, and their sockets of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the instruments of the tabernacle in all its service, and all its pins, and all the pins of the court, shall be of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“You shall command the children of Israel, that they bring to you pure olive oil beaten for the light, to cause a lamp to burn continually. ");
INSERT INTO engwebpb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the Tent of Meeting, outside the veil which is before the covenant, Aaron and his sons shall keep it in order from evening to morning before the LORD: it shall be a statute forever throughout their generations on the behalf of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Bring Aaron your brother, and his sons with him, near to you from amongst the children of Israel, that he may minister to me in the priest’s office: Aaron, with Nadab, Abihu, Eleazar, and Ithamar, Aaron’s sons. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","You shall make holy garments for Aaron your brother, for glory and for beauty. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","You shall speak to all who are wise-hearted, whom I have filled with the spirit of wisdom, that they make Aaron’s garments to sanctify him, that he may minister to me in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","These are the garments which they shall make: a breastplate, an ephod, a robe, a fitted tunic, a turban, and a sash. They shall make holy garments for Aaron your brother and his sons, that he may minister to me in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","They shall use the gold, and the blue, and the purple, and the scarlet, and the fine linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“They shall make the ephod of gold, blue, purple, scarlet, and fine twined linen, the work of the skilful workman. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It shall have two shoulder straps joined to the two ends of it, that it may be joined together. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","The skilfully woven band, which is on it, shall be like its work and of the same piece; of gold, blue, purple, scarlet, and fine twined linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","You shall take two onyx stones, and engrave on them the names of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Six of their names on the one stone, and the names of the six that remain on the other stone, in the order of their birth. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","With the work of an engraver in stone, like the engravings of a signet, you shall engrave the two stones, according to the names of the children of Israel. You shall make them to be enclosed in settings of gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","You shall put the two stones on the shoulder straps of the ephod, to be stones of memorial for the children of Israel. Aaron shall bear their names before the LORD on his two shoulders for a memorial. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","You shall make settings of gold, ");
INSERT INTO engwebpb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","and two chains of pure gold; you shall make them like cords of braided work. You shall put the braided chains on the settings. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“You shall make a breastplate of judgement, the work of the skilful workman; like the work of the ephod you shall make it; of gold, of blue, and purple, and scarlet, and fine twined linen, you shall make it. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It shall be square and folded double; a span shall be its length, and a span its width. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","You shall set in it settings of stones, four rows of stones: a row of ruby, topaz, and beryl shall be the first row; ");
INSERT INTO engwebpb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","and the second row a turquoise, a sapphire, and an emerald; ");
INSERT INTO engwebpb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","and the third row a jacinth, an agate, and an amethyst; ");
INSERT INTO engwebpb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","and the fourth row a chrysolite, an onyx, and a jasper. They shall be enclosed in gold in their settings. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","The stones shall be according to the names of the children of Israel, twelve, according to their names; like the engravings of a signet, everyone according to his name, they shall be for the twelve tribes. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","You shall make on the breastplate chains like cords, of braided work of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","You shall make on the breastplate two rings of gold, and shall put the two rings on the two ends of the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","You shall put the two braided chains of gold in the two rings at the ends of the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","The other two ends of the two braided chains you shall put on the two settings, and put them on the shoulder straps of the ephod in its forepart. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","You shall make two rings of gold, and you shall put them on the two ends of the breastplate, on its edge, which is towards the side of the ephod inward. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","You shall make two rings of gold, and shall put them on the two shoulder straps of the ephod underneath, in its forepart, close by its coupling, above the skilfully woven band of the ephod. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","They shall bind the breastplate by its rings to the rings of the ephod with a lace of blue, that it may be on the skilfully woven band of the ephod, and that the breastplate may not swing out from the ephod. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aaron shall bear the names of the children of Israel in the breastplate of judgement on his heart, when he goes in to the holy place, for a memorial before the LORD continually. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","You shall put in the breastplate of judgement the Urim and the Thummim; and they shall be on Aaron’s heart, when he goes in before the LORD. Aaron shall bear the judgement of the children of Israel on his heart before the LORD continually. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“You shall make the robe of the ephod all of blue. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","It shall have a hole for the head in the middle of it. It shall have a binding of woven work around its hole, as it were the hole of a coat of mail, that it not be torn. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","On its hem you shall make pomegranates of blue, and of purple, and of scarlet, all around its hem; with bells of gold between and around them: ");
INSERT INTO engwebpb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","a golden bell and a pomegranate, a golden bell and a pomegranate, around the hem of the robe. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","It shall be on Aaron to minister: and its sound shall be heard when he goes in to the holy place before the LORD, and when he comes out, that he not die. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“You shall make a plate of pure gold, and engrave on it, like the engravings of a signet, ‘HOLY TO THE LORD.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","You shall put it on a lace of blue, and it shall be on the sash. It shall be on the front of the sash. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","It shall be on Aaron’s forehead, and Aaron shall bear the iniquity of the holy things, which the children of Israel shall make holy in all their holy gifts; and it shall be always on his forehead, that they may be accepted before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","You shall weave the tunic with fine linen. You shall make a turban of fine linen. You shall make a sash, the work of the embroiderer. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“You shall make tunics for Aaron’s sons. You shall make sashes for them. You shall make headbands for them, for glory and for beauty. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","You shall put them on Aaron your brother, and on his sons with him, and shall anoint them, and consecrate them, and sanctify them, that they may minister to me in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","You shall make them linen pants to cover their naked flesh. They shall reach from the waist even to the thighs. ");
INSERT INTO engwebpb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","They shall be on Aaron and on his sons, when they go in to the Tent of Meeting, or when they come near to the altar to minister in the holy place, that they don’t bear iniquity, and die. This shall be a statute forever to him and to his offspring after him. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“This is the thing that you shall do to them to make them holy, to minister to me in the priest’s office: take one young bull and two rams without defect, ");
INSERT INTO engwebpb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","unleavened bread, unleavened cakes mixed with oil, and unleavened wafers anointed with oil. You shall make them of fine wheat flour. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","You shall put them into one basket, and bring them in the basket, with the bull and the two rams. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","You shall bring Aaron and his sons to the door of the Tent of Meeting, and shall wash them with water. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","You shall take the garments, and put on Aaron the tunic, the robe of the ephod, the ephod, and the breastplate, and clothe him with the skilfully woven band of the ephod. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","You shall set the turban on his head, and put the holy crown on the turban. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then you shall take the anointing oil, and pour it on his head, and anoint him. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","You shall bring his sons, and put tunics on them. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","You shall clothe them with belts, Aaron and his sons, and bind headbands on them. They shall have the priesthood by a perpetual statute. You shall consecrate Aaron and his sons. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“You shall bring the bull before the Tent of Meeting; and Aaron and his sons shall lay their hands on the head of the bull. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","You shall kill the bull before the LORD at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","You shall take of the blood of the bull, and put it on the horns of the altar with your finger; and you shall pour out all the blood at the base of the altar. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","You shall take all the fat that covers the innards, the cover of the liver, the two kidneys, and the fat that is on them, and burn them on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But the meat of the bull, and its skin, and its dung, you shall burn with fire outside of the camp. It is a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“You shall also take the one ram, and Aaron and his sons shall lay their hands on the head of the ram. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","You shall kill the ram, and you shall take its blood, and sprinkle it around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","You shall cut the ram into its pieces, and wash its innards, and its legs, and put them with its pieces, and with its head. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","You shall burn the whole ram on the altar: it is a burnt offering to the LORD; it is a pleasant aroma, an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“You shall take the other ram, and Aaron and his sons shall lay their hands on the head of the ram. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Then you shall kill the ram, and take some of its blood, and put it on the tip of the right ear of Aaron, and on the tip of the right ear of his sons, and on the thumb of their right hand, and on the big toe of their right foot; and sprinkle the blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","You shall take of the blood that is on the altar, and of the anointing oil, and sprinkle it on Aaron, and on his garments, and on his sons, and on the garments of his sons with him: and he shall be made holy, and his garments, and his sons, and his sons’ garments with him. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Also you shall take some of the ram’s fat, the fat tail, the fat that covers the innards, the cover of the liver, the two kidneys, the fat that is on them, and the right thigh (for it is a ram of consecration), ");
INSERT INTO engwebpb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","and one loaf of bread, one cake of oiled bread, and one wafer out of the basket of unleavened bread that is before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","You shall put all of this in Aaron’s hands, and in his sons’ hands, and shall wave them for a wave offering before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","You shall take them from their hands, and burn them on the altar on the burnt offering, for a pleasant aroma before the LORD: it is an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“You shall take the breast of Aaron’s ram of consecration, and wave it for a wave offering before the LORD. It shall be your portion. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","You shall sanctify the breast of the wave offering and the thigh of the wave offering, which is waved, and which is raised up, of the ram of consecration, even of that which is for Aaron, and of that which is for his sons. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","It shall be for Aaron and his sons as their portion forever from the children of Israel; for it is a wave offering. It shall be a wave offering from the children of Israel of the sacrifices of their peace offerings, even their wave offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“The holy garments of Aaron shall be for his sons after him, to be anointed in them, and to be consecrated in them. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Seven days shall the son who is priest in his place put them on, when he comes into the Tent of Meeting to minister in the holy place. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“You shall take the ram of consecration and boil its meat in a holy place. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron and his sons shall eat the meat of the ram, and the bread that is in the basket, at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","They shall eat those things with which atonement was made, to consecrate and sanctify them; but a stranger shall not eat of it, because they are holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","If anything of the meat of the consecration, or of the bread, remains to the morning, then you shall burn the remainder with fire. It shall not be eaten, because it is holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“You shall do so to Aaron and to his sons, according to all that I have commanded you. You shall consecrate them seven days. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Every day you shall offer the bull of sin offering for atonement. You shall cleanse the altar when you make atonement for it. You shall anoint it, to sanctify it. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Seven days you shall make atonement for the altar, and sanctify it; and the altar shall be most holy. Whatever touches the altar shall be holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Now this is that which you shall offer on the altar: two lambs a year old day by day continually. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","The one lamb you shall offer in the morning; and the other lamb you shall offer at evening; ");
INSERT INTO engwebpb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","and with the one lamb a tenth part of an ephah of fine flour mixed with the fourth part of a hin of beaten oil, and the fourth part of a hin of wine for a drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","The other lamb you shall offer at evening, and shall do to it according to the meal offering of the morning and according to its drink offering, for a pleasant aroma, an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","It shall be a continual burnt offering throughout your generations at the door of the Tent of Meeting before the LORD, where I will meet with you, to speak there to you. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","There I will meet with the children of Israel; and the place shall be sanctified by my glory. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","I will sanctify the Tent of Meeting and the altar. I will also sanctify Aaron and his sons to minister to me in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I will dwell amongst the children of Israel, and will be their God. ");
INSERT INTO engwebpb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","They shall know that I am the LORD their God, who brought them out of the land of Egypt, that I might dwell amongst them: I am the LORD their God. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“You shall make an altar to burn incense on. You shall make it of acacia wood. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Its length shall be a cubit, and its width a cubit. It shall be square, and its height shall be two cubits. Its horns shall be of one piece with it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","You shall overlay it with pure gold, its top, its sides around it, and its horns; and you shall make a gold moulding around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","You shall make two golden rings for it under its moulding; on its two ribs, on its two sides you shall make them; and they shall be for places for poles with which to bear it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","You shall make the poles of acacia wood, and overlay them with gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","You shall put it before the veil that is by the ark of the covenant, before the mercy seat that is over the covenant, where I will meet with you. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron shall burn incense of sweet spices on it every morning. When he tends the lamps, he shall burn it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","When Aaron lights the lamps at evening, he shall burn it, a perpetual incense before the LORD throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","You shall offer no strange incense on it, nor burnt offering, nor meal offering; and you shall pour no drink offering on it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron shall make atonement on its horns once in the year; with the blood of the sin offering of atonement once in the year he shall make atonement for it throughout your generations. It is most holy to the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“When you take a census of the children of Israel, according to those who are counted amongst them, then each man shall give a ransom for his soul to the LORD when you count them, that there be no plague amongst them when you count them. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","They shall give this, everyone who passes over to those who are counted, half a shekel according to the shekel of the sanctuary (the shekel is twenty gerahs); half a shekel for an offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Everyone who passes over to those who are counted, from twenty years old and upward, shall give the offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","The rich shall not give more, and the poor shall not give less, than the half shekel, when they give the offering of the LORD, to make atonement for your souls. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","You shall take the atonement money from the children of Israel, and shall appoint it for the service of the Tent of Meeting; that it may be a memorial for the children of Israel before the LORD, to make atonement for your souls.” ");
INSERT INTO engwebpb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“You shall also make a basin of bronze, and its base of bronze, in which to wash. You shall put it between the Tent of Meeting and the altar, and you shall put water in it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron and his sons shall wash their hands and their feet in it. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","When they go into the Tent of Meeting, they shall wash with water, that they don’t die; or when they come near to the altar to minister, to burn an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","So they shall wash their hands and their feet, that they not die. This shall be a statute forever to them, even to him and to his descendants throughout their generations.” ");
INSERT INTO engwebpb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Moreover the LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Also take fine spices: of liquid myrrh, five hundred shekels; and of fragrant cinnamon half as much, even two hundred and fifty; and of fragrant cane, two hundred and fifty; ");
INSERT INTO engwebpb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","and of cassia five hundred, according to the shekel of the sanctuary; and a hin of olive oil. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","You shall make it into a holy anointing oil, a perfume compounded after the art of the perfumer: it shall be a holy anointing oil. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","You shall use it to anoint the Tent of Meeting, the ark of the covenant, ");
INSERT INTO engwebpb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","the table and all its articles, the lamp stand and its accessories, the altar of incense, ");
INSERT INTO engwebpb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","the altar of burnt offering with all its utensils, and the basin with its base. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","You shall sanctify them, that they may be most holy. Whatever touches them shall be holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","You shall anoint Aaron and his sons, and sanctify them, that they may minister to me in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","You shall speak to the children of Israel, saying, ‘This shall be a holy anointing oil to me throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","It shall not be poured on man’s flesh, and do not make any like it, according to its composition. It is holy. It shall be holy to you. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Whoever compounds any like it, or whoever puts any of it on a stranger, he shall be cut off from his people.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","The LORD said to Moses, “Take to yourself sweet spices, gum resin, onycha, and galbanum: sweet spices with pure frankincense. There shall be an equal weight of each. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","You shall make incense of it, a perfume after the art of the perfumer, seasoned with salt, pure and holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","You shall beat some of it very small, and put some of it before the covenant in the Tent of Meeting, where I will meet with you. It shall be to you most holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","You shall not make this incense, according to its composition, for yourselves: it shall be to you holy for the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Whoever shall make any like that, to smell of it, he shall be cut off from his people.” ");
INSERT INTO engwebpb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Behold, I have called by name Bezalel the son of Uri, the son of Hur, of the tribe of Judah. ");
INSERT INTO engwebpb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I have filled him with the Spirit of God, in wisdom, and in understanding, and in knowledge, and in all kinds of workmanship, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","to devise skilful works, to work in gold, and in silver, and in bronze, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","and in cutting of stones for setting, and in carving of wood, to work in all kinds of workmanship. ");
INSERT INTO engwebpb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Behold, I myself have appointed with him Oholiab, the son of Ahisamach, of the tribe of Dan; and in the heart of all who are wise-hearted I have put wisdom, that they may make all that I have commanded you: ");
INSERT INTO engwebpb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","the Tent of Meeting, the ark of the covenant, the mercy seat that is on it, all the furniture of the Tent, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table and its vessels, the pure lamp stand with all its vessels, the altar of incense, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar of burnt offering with all its vessels, the basin and its base, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","the finely worked garments—the holy garments for Aaron the priest, the garments of his sons to minister in the priest’s office— ");
INSERT INTO engwebpb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","the anointing oil, and the incense of sweet spices for the holy place: according to all that I have commanded you they shall do.” ");
INSERT INTO engwebpb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Speak also to the children of Israel, saying, ‘Most certainly you shall keep my Sabbaths; for it is a sign between me and you throughout your generations, that you may know that I am the LORD who sanctifies you. ");
INSERT INTO engwebpb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","You shall keep the Sabbath therefore, for it is holy to you. Everyone who profanes it shall surely be put to death; for whoever does any work therein, that soul shall be cut off from amongst his people. ");
INSERT INTO engwebpb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Six days shall work be done, but on the seventh day is a Sabbath of solemn rest, holy to the LORD. Whoever does any work on the Sabbath day shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Therefore the children of Israel shall keep the Sabbath, to observe the Sabbath throughout their generations, for a perpetual covenant. ");
INSERT INTO engwebpb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It is a sign between me and the children of Israel forever; for in six days the LORD made heaven and earth, and on the seventh day he rested, and was refreshed.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","When he finished speaking with him on Mount Sinai, he gave Moses the two tablets of the covenant, stone tablets, written with God’s finger. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","When the people saw that Moses delayed coming down from the mountain, the people gathered themselves together to Aaron, and said to him, “Come, make us gods, which shall go before us; for as for this Moses, the man who brought us up out of the land of Egypt, we don’t know what has become of him.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron said to them, “Take off the golden rings, which are in the ears of your wives, of your sons, and of your daughters, and bring them to me.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","All the people took off the golden rings which were in their ears, and brought them to Aaron. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He received what they handed him, fashioned it with an engraving tool, and made it a moulded calf. Then they said, “These are your gods, Israel, which brought you up out of the land of Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","When Aaron saw this, he built an altar before it; and Aaron made a proclamation, and said, “Tomorrow shall be a feast to the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","They rose up early on the next day, and offered burnt offerings, and brought peace offerings; and the people sat down to eat and to drink, and rose up to play. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","The LORD spoke to Moses, “Go, get down; for your people, whom you brought up out of the land of Egypt, have corrupted themselves! ");
INSERT INTO engwebpb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have turned away quickly out of the way which I commanded them. They have made themselves a moulded calf, and have worshipped it, and have sacrificed to it, and said, ‘These are your gods, Israel, which brought you up out of the land of Egypt.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","The LORD said to Moses, “I have seen these people, and behold, they are a stiff-necked people. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Now therefore leave me alone, that my wrath may burn hot against them, and that I may consume them; and I will make of you a great nation.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moses begged the LORD his God, and said, “LORD, why does your wrath burn hot against your people, that you have brought out of the land of Egypt with great power and with a mighty hand? ");
INSERT INTO engwebpb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why should the Egyptians talk, saying, ‘He brought them out for evil, to kill them in the mountains, and to consume them from the surface of the earth’? Turn from your fierce wrath, and turn away from this evil against your people. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember Abraham, Isaac, and Israel, your servants, to whom you swore by your own self, and said to them, ‘I will multiply your offspring as the stars of the sky, and all this land that I have spoken of I will give to your offspring, and they shall inherit it forever.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","So the LORD turned away from the evil which he said he would do to his people. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moses turned, and went down from the mountain, with the two tablets of the covenant in his hand; tablets that were written on both their sides. They were written on one side and on the other. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","The tablets were the work of God, and the writing was the writing of God, engraved on the tablets. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","When Joshua heard the noise of the people as they shouted, he said to Moses, “There is the noise of war in the camp.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","He said, “It isn’t the voice of those who shout for victory. It is not the voice of those who cry for being overcome; but the noise of those who sing that I hear.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","As soon as he came near to the camp, he saw the calf and the dancing. Then Moses’ anger grew hot, and he threw the tablets out of his hands, and broke them beneath the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","He took the calf which they had made, and burnt it with fire, ground it to powder, and scattered it on the water, and made the children of Israel drink it. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moses said to Aaron, “What did these people do to you, that you have brought a great sin on them?” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron said, “Don’t let the anger of my lord grow hot. You know the people, that they are set on evil. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","For they said to me, ‘Make us gods, which shall go before us. As for this Moses, the man who brought us up out of the land of Egypt, we don’t know what has become of him.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","I said to them, ‘Whoever has any gold, let them take it off.’ So they gave it to me; and I threw it into the fire, and out came this calf.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","When Moses saw that the people were out of control, (for Aaron had let them lose control, causing derision amongst their enemies), ");
INSERT INTO engwebpb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","then Moses stood in the gate of the camp, and said, “Whoever is on the LORD’s side, come to me!” All the sons of Levi gathered themselves together to him. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","He said to them, “The LORD, the God of Israel, says, ‘Every man put his sword on his thigh, and go back and forth from gate to gate throughout the camp, and every man kill his brother, and every man his companion, and every man his neighbour.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The sons of Levi did according to the word of Moses. About three thousand men fell of the people that day. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses said, “Consecrate yourselves today to the LORD, for every man was against his son and against his brother, that he may give you a blessing today.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","On the next day, Moses said to the people, “You have sinned a great sin. Now I will go up to the LORD. Perhaps I shall make atonement for your sin.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moses returned to the LORD, and said, “Oh, this people have sinned a great sin, and have made themselves gods of gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Yet now, if you will, forgive their sin—and if not, please blot me out of your book which you have written.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","The LORD said to Moses, “Whoever has sinned against me, I will blot him out of my book. ");
INSERT INTO engwebpb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Now go, lead the people to the place of which I have spoken to you. Behold, my angel shall go before you. Nevertheless, in the day when I punish, I will punish them for their sin.” ");
INSERT INTO engwebpb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","The LORD struck the people, because of what they did with the calf, which Aaron made. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","The LORD spoke to Moses, “Depart, go up from here, you and the people that you have brought up out of the land of Egypt, to the land of which I swore to Abraham, to Isaac, and to Jacob, saying, ‘I will give it to your offspring.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I will send an angel before you; and I will drive out the Canaanite, the Amorite, and the Hittite, and the Perizzite, the Hivite, and the Jebusite. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Go to a land flowing with milk and honey; but I will not go up amongst you, for you are a stiff-necked people, lest I consume you on the way.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","When the people heard this evil news, they mourned; and no one put on his jewellery. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","The LORD had said to Moses, “Tell the children of Israel, ‘You are a stiff-necked people. If I were to go up amongst you for one moment, I would consume you. Therefore now take off your jewellery from you, that I may know what to do to you.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","The children of Israel stripped themselves of their jewellery from Mount Horeb onward. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Now Moses used to take the tent and pitch it outside the camp, far away from the camp, and he called it “The Tent of Meeting.” Everyone who sought the LORD went out to the Tent of Meeting, which was outside the camp. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","When Moses went out to the Tent, all the people rose up, and stood, everyone at their tent door, and watched Moses, until he had gone into the Tent. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","When Moses entered into the Tent, the pillar of cloud descended, stood at the door of the Tent, and the LORD spoke with Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","All the people saw the pillar of cloud stand at the door of the Tent, and all the people rose up and worshipped, everyone at their tent door. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","The LORD spoke to Moses face to face, as a man speaks to his friend. He turned again into the camp, but his servant Joshua, the son of Nun, a young man, didn’t depart from the Tent. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses said to the LORD, “Behold, you tell me, ‘Bring up this people;’ and you haven’t let me know whom you will send with me. Yet you have said, ‘I know you by name, and you have also found favour in my sight.’ ");
INSERT INTO engwebpb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Now therefore, if I have found favour in your sight, please show me your way, now, that I may know you, so that I may find favour in your sight; and consider that this nation is your people.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","He said, “My presence will go with you, and I will give you rest.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses said to him, “If your presence doesn’t go with me, don’t carry us up from here. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","For how would people know that I have found favour in your sight, I and your people? Isn’t it that you go with us, so that we are separated, I and your people, from all the people who are on the surface of the earth?” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","The LORD said to Moses, “I will do this thing also that you have spoken; for you have found favour in my sight, and I know you by name.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moses said, “Please show me your glory.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","He said, “I will make all my goodness pass before you, and will proclaim the LORD’s name before you. I will be gracious to whom I will be gracious, and will show mercy on whom I will show mercy.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","He said, “You cannot see my face, for man may not see me and live.” ");
INSERT INTO engwebpb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","The LORD also said, “Behold, there is a place by me, and you shall stand on the rock. ");
INSERT INTO engwebpb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","It will happen, while my glory passes by, that I will put you in a cleft of the rock, and will cover you with my hand until I have passed by; ");
INSERT INTO engwebpb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","then I will take away my hand, and you will see my back; but my face shall not be seen.” ");
INSERT INTO engwebpb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","The LORD said to Moses, “Chisel two stone tablets like the first. I will write on the tablets the words that were on the first tablets, which you broke. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Be ready by the morning, and come up in the morning to Mount Sinai, and present yourself there to me on the top of the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","No one shall come up with you or be seen anywhere on the mountain. Do not let the flocks or herds graze in front of that mountain.” ");
INSERT INTO engwebpb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","He chiselled two tablets of stone like the first; then Moses rose up early in the morning, and went up to Mount Sinai, as the LORD had commanded him, and took in his hand two stone tablets. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","The LORD descended in the cloud, and stood with him there, and proclaimed the LORD’s name. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","The LORD passed by before him, and proclaimed, “The LORD! The LORD, a merciful and gracious God, slow to anger, and abundant in loving kindness and truth, ");
INSERT INTO engwebpb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","keeping loving kindness for thousands, forgiving iniquity and disobedience and sin; and who will by no means clear the guilty, visiting the iniquity of the fathers on the children, and on the children’s children, on the third and on the fourth generation.” ");
INSERT INTO engwebpb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses hurried and bowed his head towards the earth, and worshipped. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","He said, “If now I have found favour in your sight, Lord, please let the Lord go amongst us, even though this is a stiff-necked people; pardon our iniquity and our sin, and take us for your inheritance.” ");
INSERT INTO engwebpb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","He said, “Behold, I make a covenant: before all your people I will do marvels, such as have not been worked in all the earth, nor in any nation; and all the people amongst whom you are shall see the work of the LORD; for it is an awesome thing that I do with you. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observe that which I command you today. Behold, I will drive out before you the Amorite, the Canaanite, the Hittite, the Perizzite, the Hivite, and the Jebusite. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be careful, lest you make a covenant with the inhabitants of the land where you are going, lest it be for a snare amongst you; ");
INSERT INTO engwebpb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","but you shall break down their altars, and dash in pieces their pillars, and you shall cut down their Asherah poles; ");
INSERT INTO engwebpb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","for you shall worship no other god; for the LORD, whose name is Jealous, is a jealous God. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Don’t make a covenant with the inhabitants of the land, lest they play the prostitute after their gods, and sacrifice to their gods, and one call you and you eat of his sacrifice; ");
INSERT INTO engwebpb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","and you take of their daughters to your sons, and their daughters play the prostitute after their gods, and make your sons play the prostitute after their gods. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“You shall make no cast idols for yourselves. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“You shall keep the feast of unleavened bread. Seven days you shall eat unleavened bread, as I commanded you, at the time appointed in the month Abib; for in the month Abib you came out of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“All that opens the womb is mine; and all your livestock that is male, the firstborn of cow and sheep. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","You shall redeem the firstborn of a donkey with a lamb. If you will not redeem it, then you shall break its neck. You shall redeem all the firstborn of your sons. No one shall appear before me empty. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Six days you shall work, but on the seventh day you shall rest: in ploughing time and in harvest you shall rest. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“You shall observe the feast of weeks with the first fruits of wheat harvest, and the feast of harvest at the year’s end. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times in the year all your males shall appear before the Lord GOD, the God of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will drive out nations before you and enlarge your borders; neither shall any man desire your land when you go up to appear before the LORD, your God, three times in the year. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“You shall not offer the blood of my sacrifice with leavened bread. The sacrifice of the feast of the Passover shall not be left to the morning. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“You shall bring the first of the first fruits of your ground to the house of the LORD your God. “You shall not boil a young goat in its mother’s milk.” ");
INSERT INTO engwebpb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","The LORD said to Moses, “Write these words; for in accordance with these words I have made a covenant with you and with Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","He was there with the LORD forty days and forty nights; he neither ate bread, nor drank water. He wrote on the tablets the words of the covenant, the ten commandments. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","When Moses came down from Mount Sinai with the two tablets of the covenant in Moses’ hand, when he came down from the mountain, Moses didn’t know that the skin of his face shone by reason of his speaking with him. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","When Aaron and all the children of Israel saw Moses, behold, the skin of his face shone; and they were afraid to come near him. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moses called to them, and Aaron and all the rulers of the congregation returned to him; and Moses spoke to them. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Afterward all the children of Israel came near, and he gave them all the commandments that the LORD had spoken with him on Mount Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moses was done speaking with them, he put a veil on his face. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But when Moses went in before the LORD to speak with him, he took the veil off, until he came out; and he came out, and spoke to the children of Israel that which he was commanded. ");
INSERT INTO engwebpb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","The children of Israel saw Moses’ face, that the skin of Moses’ face shone; so Moses put the veil on his face again, until he went in to speak with him. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses assembled all the congregation of the children of Israel, and said to them, “These are the words which the LORD has commanded, that you should do them. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‘Six days shall work be done, but on the seventh day there shall be a holy day for you, a Sabbath of solemn rest to the LORD: whoever does any work in it shall be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","You shall kindle no fire throughout your habitations on the Sabbath day.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses spoke to all the congregation of the children of Israel, saying, “This is the thing which the LORD commanded, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Take from amongst you an offering to the LORD. Whoever is of a willing heart, let him bring it as the LORD’s offering: gold, silver, bronze, ");
INSERT INTO engwebpb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blue, purple, scarlet, fine linen, goats’ hair, ");
INSERT INTO engwebpb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","rams’ skins dyed red, sea cow hides, acacia wood, ");
INSERT INTO engwebpb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oil for the light, spices for the anointing oil and for the sweet incense, ");
INSERT INTO engwebpb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onyx stones, and stones to be set for the ephod and for the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“‘Let every wise-hearted man amongst you come, and make all that the LORD has commanded: ");
INSERT INTO engwebpb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","the tabernacle, its outer covering, its roof, its clasps, its boards, its bars, its pillars, and its sockets; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","the ark, and its poles, the mercy seat, the veil of the screen; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","the table with its poles and all its vessels, and the show bread; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lamp stand also for the light, with its vessels, its lamps, and the oil for the light; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","and the altar of incense with its poles, the anointing oil, the sweet incense, the screen for the door, at the door of the tabernacle; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar of burnt offering, with its grating of bronze, its poles, and all its vessels, the basin and its base; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","the hangings of the court, its pillars, their sockets, and the screen for the gate of the court; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","the pins of the tabernacle, the pins of the court, and their cords; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","the finely worked garments for ministering in the holy place—the holy garments for Aaron the priest, and the garments of his sons—to minister in the priest’s office.’” ");
INSERT INTO engwebpb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","All the congregation of the children of Israel departed from the presence of Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","They came, everyone whose heart stirred him up, and everyone whom his spirit made willing, and brought the LORD’s offering for the work of the Tent of Meeting, and for all of its service, and for the holy garments. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","They came, both men and women, as many as were willing-hearted, and brought brooches, earrings, signet rings, and armlets, all jewels of gold; even every man who offered an offering of gold to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Everyone with whom was found blue, purple, scarlet, fine linen, goats’ hair, rams’ skins dyed red, and sea cow hides, brought them. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Everyone who offered an offering of silver and bronze brought the LORD’s offering; and everyone with whom was found acacia wood for any work of the service, brought it. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","All the women who were wise-hearted spun with their hands, and brought that which they had spun: the blue, the purple, the scarlet, and the fine linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","All the women whose heart stirred them up in wisdom spun the goats’ hair. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","The rulers brought the onyx stones and the stones to be set for the ephod and for the breastplate; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","with the spice and the oil for the light, for the anointing oil, and for the sweet incense. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","The children of Israel brought a free will offering to the LORD; every man and woman whose heart made them willing to bring for all the work, which the LORD had commanded to be made by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moses said to the children of Israel, “Behold, the LORD has called by name Bezalel the son of Uri, the son of Hur, of the tribe of Judah. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","He has filled him with the Spirit of God, in wisdom, in understanding, in knowledge, and in all kinds of workmanship; ");
INSERT INTO engwebpb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","and to make skilful works, to work in gold, in silver, in bronze, ");
INSERT INTO engwebpb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","in cutting of stones for setting, and in carving of wood, to work in all kinds of skilful workmanship. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","He has put in his heart that he may teach, both he and Oholiab, the son of Ahisamach, of the tribe of Dan. ");
INSERT INTO engwebpb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has filled them with wisdom of heart to work all kinds of workmanship, of the engraver, of the skilful workman, and of the embroiderer, in blue, in purple, in scarlet, and in fine linen, and of the weaver, even of those who do any workmanship, and of those who make skilful works. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezalel and Oholiab shall work with every wise-hearted man, in whom the LORD has put wisdom and understanding to know how to do all the work for the service of the sanctuary, according to all that the LORD has commanded.” ");
INSERT INTO engwebpb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moses called Bezalel and Oholiab, and every wise-hearted man, in whose heart the LORD had put wisdom, even everyone whose heart stirred him up to come to the work to do it. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","They received from Moses all the offering which the children of Israel had brought for the work of the service of the sanctuary, with which to make it. They kept bringing free will offerings to him every morning. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","All the wise men, who performed all the work of the sanctuary, each came from his work which he did. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","They spoke to Moses, saying, “The people have brought much more than enough for the service of the work which the LORD commanded to make.” ");
INSERT INTO engwebpb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moses gave a commandment, and they caused it to be proclaimed throughout the camp, saying, “Let neither man nor woman make anything else for the offering for the sanctuary.” So the people were restrained from bringing. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","For the stuff they had was sufficient to do all the work, and too much. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","All the wise-hearted men amongst those who did the work made the tabernacle with ten curtains of fine twined linen, blue, purple, and scarlet. They made them with cherubim, the work of a skilful workman. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","The length of each curtain was twenty-eight cubits, and the width of each curtain four cubits. All the curtains had one measure. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","He coupled five curtains to one another, and the other five curtains he coupled to one another. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","He made loops of blue on the edge of the one curtain from the edge in the coupling. Likewise he made in the edge of the curtain that was outermost in the second coupling. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","He made fifty loops in the one curtain, and he made fifty loops in the edge of the curtain that was in the second coupling. The loops were opposite to one another. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","He made fifty clasps of gold, and coupled the curtains to one another with the clasps: so the tabernacle was a unit. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","He made curtains of goats’ hair for a covering over the tabernacle. He made them eleven curtains. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","The length of each curtain was thirty cubits, and four cubits the width of each curtain. The eleven curtains had one measure. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","He coupled five curtains by themselves, and six curtains by themselves. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","He made fifty loops on the edge of the curtain that was outermost in the coupling, and he made fifty loops on the edge of the curtain which was outermost in the second coupling. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","He made fifty clasps of bronze to couple the tent together, that it might be a unit. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","He made a covering for the tent of rams’ skins dyed red, and a covering of sea cow hides above. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","He made the boards for the tabernacle of acacia wood, standing up. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ten cubits was the length of a board, and a cubit and a half the width of each board. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Each board had two tenons, joined to one another. He made all the boards of the tabernacle this way. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","He made the boards for the tabernacle, twenty boards for the south side southward. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","He made forty sockets of silver under the twenty boards: two sockets under one board for its two tenons, and two sockets under another board for its two tenons. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","For the second side of the tabernacle, on the north side, he made twenty boards ");
INSERT INTO engwebpb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","and their forty sockets of silver: two sockets under one board, and two sockets under another board. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","For the far part of the tabernacle westward he made six boards. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","He made two boards for the corners of the tabernacle in the far part. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","They were double beneath, and in the same way they were all the way to its top to one ring. He did this to both of them in the two corners. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","There were eight boards and their sockets of silver, sixteen sockets—under every board two sockets. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","He made bars of acacia wood: five for the boards of the one side of the tabernacle, ");
INSERT INTO engwebpb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","and five bars for the boards of the other side of the tabernacle, and five bars for the boards of the tabernacle for the hinder part westward. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","He made the middle bar to pass through in the middle of the boards from the one end to the other. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","He overlaid the boards with gold, and made their rings of gold as places for the bars, and overlaid the bars with gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","He made the veil of blue, purple, scarlet, and fine twined linen, with cherubim. He made it the work of a skilful workman. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","He made four pillars of acacia for it, and overlaid them with gold. Their hooks were of gold. He cast four sockets of silver for them. ");
INSERT INTO engwebpb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","He made a screen for the door of the tent, of blue, purple, scarlet, and fine twined linen, the work of an embroiderer; ");
INSERT INTO engwebpb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","and the five pillars of it with their hooks. He overlaid their capitals and their fillets with gold, and their five sockets were of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel made the ark of acacia wood. Its length was two and a half cubits, and its width a cubit and a half, and a cubit and a half its height. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He overlaid it with pure gold inside and outside, and made a moulding of gold for it around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","He cast four rings of gold for it in its four feet—two rings on its one side, and two rings on its other side. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","He made poles of acacia wood and overlaid them with gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","He put the poles into the rings on the sides of the ark, to bear the ark. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","He made a mercy seat of pure gold. Its length was two and a half cubits, and a cubit and a half its width. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","He made two cherubim of gold. He made them of beaten work, at the two ends of the mercy seat: ");
INSERT INTO engwebpb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","one cherub at the one end, and one cherub at the other end. He made the cherubim of one piece with the mercy seat at its two ends. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","The cherubim spread out their wings above, covering the mercy seat with their wings, with their faces towards one another. The faces of the cherubim were towards the mercy seat. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","He made the table of acacia wood. Its length was two cubits, and its width was a cubit, and its height was a cubit and a half. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He overlaid it with pure gold, and made a gold moulding around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","He made a border of a hand’s width around it, and made a golden moulding on its border around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","He cast four rings of gold for it, and put the rings in the four corners that were on its four feet. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were close by the border, the places for the poles to carry the table. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","He made the poles of acacia wood, and overlaid them with gold, to carry the table. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","He made the vessels which were on the table, its dishes, its spoons, its bowls, and its pitchers with which to pour out, of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","He made the lamp stand of pure gold. He made the lamp stand of beaten work. Its base, its shaft, its cups, its buds, and its flowers were of one piece with it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","There were six branches going out of its sides: three branches of the lamp stand out of its one side, and three branches of the lamp stand out of its other side: ");
INSERT INTO engwebpb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","three cups made like almond blossoms in one branch, a bud and a flower, and three cups made like almond blossoms in the other branch, a bud and a flower; so for the six branches going out of the lamp stand. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","In the lamp stand were four cups made like almond blossoms, its buds and its flowers; ");
INSERT INTO engwebpb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","and a bud under two branches of one piece with it, and a bud under two branches of one piece with it, and a bud under two branches of one piece with it, for the six branches going out of it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Their buds and their branches were of one piece with it. The whole thing was one beaten work of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","He made its seven lamps, and its snuffers, and its snuff dishes, of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","He made it of a talent of pure gold, with all its vessels. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","He made the altar of incense of acacia wood. It was square: its length was a cubit, and its width a cubit. Its height was two cubits. Its horns were of one piece with it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","He overlaid it with pure gold: its top, its sides around it, and its horns. He made a gold moulding around it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He made two golden rings for it under its moulding crown, on its two ribs, on its two sides, for places for poles with which to carry it. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","He made the poles of acacia wood, and overlaid them with gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","He made the holy anointing oil and the pure incense of sweet spices, after the art of the perfumer. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","He made the altar of burnt offering of acacia wood. It was square. Its length was five cubits, its width was five cubits, and its height was three cubits. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","He made its horns on its four corners. Its horns were of one piece with it, and he overlaid it with bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","He made all the vessels of the altar: the pots, the shovels, the basins, the forks, and the fire pans. He made all its vessels of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","He made for the altar a grating of a network of bronze, under the ledge around it beneath, reaching halfway up. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","He cast four rings for the four corners of bronze grating, to be places for the poles. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","He made the poles of acacia wood, and overlaid them with bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","He put the poles into the rings on the sides of the altar, with which to carry it. He made it hollow with planks. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","He made the basin of bronze, and its base of bronze, out of the mirrors of the ministering women who ministered at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","He made the court: for the south side southward the hangings of the court were of fine twined linen, one hundred cubits; ");
INSERT INTO engwebpb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","their pillars were twenty, and their sockets twenty, of bronze; the hooks of the pillars and their fillets were of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","For the north side one hundred cubits, their pillars twenty, and their sockets twenty, of bronze; the hooks of the pillars, and their fillets, of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","For the west side were hangings of fifty cubits, their pillars ten, and their sockets ten; the hooks of the pillars, and their fillets, of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","For the east side eastward fifty cubits, ");
INSERT INTO engwebpb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","the hangings for the one side were fifteen cubits; their pillars three, and their sockets three; ");
INSERT INTO engwebpb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","and so for the other side: on this hand and that hand by the gate of the court were hangings of fifteen cubits; their pillars three, and their sockets three. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the hangings around the court were of fine twined linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","The sockets for the pillars were of bronze. The hooks of the pillars and their fillets were of silver. Their capitals were overlaid with silver. All the pillars of the court had silver bands. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","The screen for the gate of the court was the work of the embroiderer, of blue, purple, scarlet, and fine twined linen. Twenty cubits was the length, and the height along the width was five cubits, like the hangings of the court. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Their pillars were four, and their sockets four, of bronze; their hooks of silver, and the overlaying of their capitals, and their fillets, of silver. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the pins of the tabernacle, and around the court, were of bronze. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","These are the amounts of materials used for the tabernacle, even the Tabernacle of the Testimony, as they were counted, according to the commandment of Moses, for the service of the Levites, by the hand of Ithamar, the son of Aaron the priest. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel the son of Uri, the son of Hur, of the tribe of Judah, made all that the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","With him was Oholiab, the son of Ahisamach, of the tribe of Dan, an engraver, and a skilful workman, and an embroiderer in blue, in purple, in scarlet, and in fine linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the gold that was used for the work in all the work of the sanctuary, even the gold of the offering, was twenty-nine talents and seven hundred and thirty shekels, according to the shekel of the sanctuary. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","The silver of those who were counted of the congregation was one hundred talents and one thousand and seven hundred and seventy-five shekels, according to the shekel of the sanctuary: ");
INSERT INTO engwebpb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","a beka a head, that is, half a shekel, according to the shekel of the sanctuary, for everyone who passed over to those who were counted, from twenty years old and upward, for six hundred and three thousand and five hundred and fifty men. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","The one hundred talents of silver were for casting the sockets of the sanctuary and the sockets of the veil: one hundred sockets for the one hundred talents, one talent per socket. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","From the one thousand and seven hundred and seventy-five shekels he made hooks for the pillars, overlaid their capitals, and made fillets for them. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The bronze of the offering was seventy talents and two thousand and four hundred shekels. ");
INSERT INTO engwebpb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","With this he made the sockets to the door of the Tent of Meeting, the bronze altar, the bronze grating for it, all the vessels of the altar, ");
INSERT INTO engwebpb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","the sockets around the court, the sockets of the gate of the court, all the pins of the tabernacle, and all the pins around the court. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Of the blue, purple, and scarlet, they made finely worked garments for ministering in the holy place, and made the holy garments for Aaron, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","He made the ephod of gold, blue, purple, scarlet, and fine twined linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","They beat the gold into thin plates, and cut it into wires, to work it in with the blue, the purple, the scarlet, and the fine linen, the work of the skilful workman. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","They made shoulder straps for it, joined together. It was joined together at the two ends. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","The skilfully woven band that was on it, with which to fasten it on, was of the same piece, like its work: of gold, of blue, purple, scarlet, and fine twined linen, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","They worked the onyx stones, enclosed in settings of gold, engraved with the engravings of a signet, according to the names of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","He put them on the shoulder straps of the ephod, to be stones of memorial for the children of Israel, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","He made the breastplate, the work of a skilful workman, like the work of the ephod: of gold, of blue, purple, scarlet, and fine twined linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square. They made the breastplate double. Its length was a span, and its width a span, being double. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","They set in it four rows of stones. A row of ruby, topaz, and beryl was the first row; ");
INSERT INTO engwebpb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","and the second row, a turquoise, a sapphire, and an emerald; ");
INSERT INTO engwebpb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","and the third row, a jacinth, an agate, and an amethyst; ");
INSERT INTO engwebpb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","and the fourth row, a chrysolite, an onyx, and a jasper. They were enclosed in gold settings. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","The stones were according to the names of the children of Israel, twelve, according to their names; like the engravings of a signet, everyone according to his name, for the twelve tribes. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","They made on the breastplate chains like cords, of braided work of pure gold. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","They made two settings of gold, and two gold rings, and put the two rings on the two ends of the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","They put the two braided chains of gold in the two rings at the ends of the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","The other two ends of the two braided chains they put on the two settings, and put them on the shoulder straps of the ephod, in its front. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","They made two rings of gold, and put them on the two ends of the breastplate, on its edge, which was towards the side of the ephod inward. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They made two more rings of gold, and put them on the two shoulder straps of the ephod underneath, in its front, close by its coupling, above the skilfully woven band of the ephod. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","They bound the breastplate by its rings to the rings of the ephod with a lace of blue, that it might be on the skilfully woven band of the ephod, and that the breastplate might not come loose from the ephod, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","He made the robe of the ephod of woven work, all of blue. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","The opening of the robe in the middle of it was like the opening of a coat of mail, with a binding around its opening, that it should not be torn. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","They made on the skirts of the robe pomegranates of blue, purple, scarlet, and twined linen. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","They made bells of pure gold, and put the bells between the pomegranates around the skirts of the robe, between the pomegranates; ");
INSERT INTO engwebpb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","a bell and a pomegranate, a bell and a pomegranate, around the skirts of the robe, to minister in, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","They made the tunics of fine linen of woven work for Aaron and for his sons, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","the turban of fine linen, the linen headbands of fine linen, the linen trousers of fine twined linen, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","the sash of fine twined linen, blue, purple, and scarlet, the work of the embroiderer, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","They made the plate of the holy crown of pure gold, and wrote on it an inscription, like the engravings of a signet: “HOLY TO THE LORD”. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","They tied to it a lace of blue, to fasten it on the turban above, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Thus all the work of the tabernacle of the Tent of Meeting was finished. The children of Israel did according to all that the LORD commanded Moses; so they did. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","They brought the tabernacle to Moses: the tent, with all its furniture, its clasps, its boards, its bars, its pillars, its sockets, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","the covering of rams’ skins dyed red, the covering of sea cow hides, the veil of the screen, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the ark of the covenant with its poles, the mercy seat, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","the table, all its vessels, the show bread, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the pure lamp stand, its lamps, even the lamps to be set in order, all its vessels, the oil for the light, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","the golden altar, the anointing oil, the sweet incense, the screen for the door of the Tent, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the bronze altar, its grating of bronze, its poles, all of its vessels, the basin and its base, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","the hangings of the court, its pillars, its sockets, the screen for the gate of the court, its cords, its pins, and all the instruments of the service of the tabernacle, for the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","the finely worked garments for ministering in the holy place, the holy garments for Aaron the priest, and the garments of his sons, to minister in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","According to all that the LORD commanded Moses, so the children of Israel did all the work. ");
INSERT INTO engwebpb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses saw all the work, and behold, they had done it as the LORD had commanded. They had done so; and Moses blessed them. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“On the first day of the first month you shall raise up the tabernacle of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","You shall put the ark of the covenant in it, and you shall screen the ark with the veil. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","You shall bring in the table, and set in order the things that are on it. You shall bring in the lamp stand, and light its lamps. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","You shall set the golden altar for incense before the ark of the covenant, and put the screen of the door to the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“You shall set the altar of burnt offering before the door of the tabernacle of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","You shall set the basin between the Tent of Meeting and the altar, and shall put water therein. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","You shall set up the court around it, and hang up the screen of the gate of the court. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“You shall take the anointing oil, and anoint the tabernacle and all that is in it, and shall make it holy, and all its furniture, and it will be holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","You shall anoint the altar of burnt offering, with all its vessels, and sanctify the altar, and the altar will be most holy. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","You shall anoint the basin and its base, and sanctify it. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“You shall bring Aaron and his sons to the door of the Tent of Meeting, and shall wash them with water. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","You shall put on Aaron the holy garments; and you shall anoint him, and sanctify him, that he may minister to me in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","You shall bring his sons, and put tunics on them. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","You shall anoint them, as you anointed their father, that they may minister to me in the priest’s office. Their anointing shall be to them for an everlasting priesthood throughout their generations.” ");
INSERT INTO engwebpb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses did so. According to all that the LORD commanded him, so he did. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","In the first month in the second year, on the first day of the month, the tabernacle was raised up. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses raised up the tabernacle, and laid its sockets, and set up its boards, and put in its bars, and raised up its pillars. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","He spread the covering over the tent, and put the roof of the tabernacle above on it, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","He took and put the covenant into the ark, and set the poles on the ark, and put the mercy seat above on the ark. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","He brought the ark into the tabernacle, and set up the veil of the screen, and screened the ark of the covenant, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","He put the table in the Tent of Meeting, on the north side of the tabernacle, outside of the veil. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","He set the bread in order on it before the LORD, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","He put the lamp stand in the Tent of Meeting, opposite the table, on the south side of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","He lit the lamps before the LORD, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","He put the golden altar in the Tent of Meeting before the veil; ");
INSERT INTO engwebpb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and he burnt incense of sweet spices on it, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","He put up the screen of the door to the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","He set the altar of burnt offering at the door of the tabernacle of the Tent of Meeting, and offered on it the burnt offering and the meal offering, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","He set the basin between the Tent of Meeting and the altar, and put water therein, with which to wash. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses, Aaron, and his sons washed their hands and their feet there. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","When they went into the Tent of Meeting, and when they came near to the altar, they washed, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","He raised up the court around the tabernacle and the altar, and set up the screen of the gate of the court. So Moses finished the work. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud covered the Tent of Meeting, and the LORD’s glory filled the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses wasn’t able to enter into the Tent of Meeting, because the cloud stayed on it, and the LORD’s glory filled the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","When the cloud was taken up from over the tabernacle, the children of Israel went onward, throughout all their journeys; ");
INSERT INTO engwebpb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","but if the cloud wasn’t taken up, then they didn’t travel until the day that it was taken up. ");
INSERT INTO engwebpb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For the cloud of the LORD was on the tabernacle by day, and there was fire in the cloud by night, in the sight of all the house of Israel, throughout all their journeys. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","The LORD called to Moses, and spoke to him from the Tent of Meeting, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Speak to the children of Israel, and tell them, ‘When anyone of you offers an offering to the LORD, you shall offer your offering of the livestock, from the herd and from the flock. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“‘If his offering is a burnt offering from the herd, he shall offer a male without defect. He shall offer it at the door of the Tent of Meeting, that he may be accepted before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","He shall lay his hand on the head of the burnt offering, and it shall be accepted for him to make atonement for him. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","He shall kill the bull before the LORD. Aaron’s sons, the priests, shall present the blood and sprinkle the blood around on the altar that is at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","He shall skin the burnt offering and cut it into pieces. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","The sons of Aaron the priest shall put fire on the altar, and lay wood in order on the fire; ");
INSERT INTO engwebpb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","and Aaron’s sons, the priests, shall lay the pieces, the head, and the fat in order on the wood that is on the fire which is on the altar; ");
INSERT INTO engwebpb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","but he shall wash its innards and its legs with water. The priest shall burn all of it on the altar, for a burnt offering, an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘If his offering is from the flock, from the sheep or from the goats, for a burnt offering, he shall offer a male without defect. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","He shall kill it on the north side of the altar before the LORD. Aaron’s sons, the priests, shall sprinkle its blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","He shall cut it into its pieces, with its head and its fat. The priest shall lay them in order on the wood that is on the fire which is on the altar, ");
INSERT INTO engwebpb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","but the innards and the legs he shall wash with water. The priest shall offer the whole, and burn it on the altar. It is a burnt offering, an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘If his offering to the LORD is a burnt offering of birds, then he shall offer his offering from turtledoves or of young pigeons. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","The priest shall bring it to the altar, and wring off its head, and burn it on the altar; and its blood shall be drained out on the side of the altar; ");
INSERT INTO engwebpb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","and he shall take away its crop and its feathers, and cast it beside the altar on the east part, in the place of the ashes. ");
INSERT INTO engwebpb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","He shall tear it by its wings, but shall not divide it apart. The priest shall burn it on the altar, on the wood that is on the fire. It is a burnt offering, an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘When anyone offers an offering of a meal offering to the LORD, his offering shall be of fine flour. He shall pour oil on it, and put frankincense on it. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","He shall bring it to Aaron’s sons, the priests. He shall take his handful of its fine flour, and of its oil, with all its frankincense, and the priest shall burn its memorial on the altar, an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","That which is left of the meal offering shall be Aaron’s and his sons’. It is a most holy part of the offerings of the LORD made by fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘When you offer an offering of a meal offering baked in the oven, it shall be unleavened cakes of fine flour mixed with oil, or unleavened wafers anointed with oil. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If your offering is a meal offering made on a griddle, it shall be of unleavened fine flour, mixed with oil. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","You shall cut it in pieces, and pour oil on it. It is a meal offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If your offering is a meal offering of the pan, it shall be made of fine flour with oil. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","You shall bring the meal offering that is made of these things to the LORD. It shall be presented to the priest, and he shall bring it to the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","The priest shall take from the meal offering its memorial, and shall burn it on the altar, an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","That which is left of the meal offering shall be Aaron’s and his sons’. It is a most holy part of the offerings of the LORD made by fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘No meal offering which you shall offer to the LORD shall be made with yeast; for you shall burn no yeast, nor any honey, as an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","As an offering of first fruits you shall offer them to the LORD, but they shall not rise up as a pleasant aroma on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Every offering of your meal offering you shall season with salt. You shall not allow the salt of the covenant of your God to be lacking from your meal offering. With all your offerings you shall offer salt. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“‘If you offer a meal offering of first fruits to the LORD, you shall offer for the meal offering of your first fruits fresh heads of grain parched with fire and crushed. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","You shall put oil on it and lay frankincense on it. It is a meal offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","The priest shall burn as its memorial part of its crushed grain and part of its oil, along with all its frankincense. It is an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘If his offering is a sacrifice of peace offerings, if he offers it from the herd, whether male or female, he shall offer it without defect before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","He shall lay his hand on the head of his offering, and kill it at the door of the Tent of Meeting. Aaron’s sons, the priests, shall sprinkle the blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","He shall offer of the sacrifice of peace offerings an offering made by fire to the LORD. The fat that covers the innards, and all the fat that is on the innards, ");
INSERT INTO engwebpb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","and the two kidneys, and the fat that is on them, which is by the loins, and the cover on the liver, with the kidneys, he shall take away. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aaron’s sons shall burn it on the altar on the burnt offering, which is on the wood that is on the fire: it is an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘If his offering for a sacrifice of peace offerings to the LORD is from the flock, either male or female, he shall offer it without defect. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If he offers a lamb for his offering, then he shall offer it before the LORD; ");
INSERT INTO engwebpb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","and he shall lay his hand on the head of his offering, and kill it before the Tent of Meeting. Aaron’s sons shall sprinkle its blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","He shall offer from the sacrifice of peace offerings an offering made by fire to the LORD; its fat, the entire tail fat, he shall take away close to the backbone; and the fat that covers the entrails, and all the fat that is on the entrails, ");
INSERT INTO engwebpb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","and the two kidneys, and the fat that is on them, which is by the loins, and the cover on the liver, with the kidneys, he shall take away. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","The priest shall burn it on the altar: it is the food of the offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘If his offering is a goat, then he shall offer it before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","He shall lay his hand on its head, and kill it before the Tent of Meeting; and the sons of Aaron shall sprinkle its blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","He shall offer from it as his offering, an offering made by fire to the LORD; the fat that covers the innards, and all the fat that is on the innards, ");
INSERT INTO engwebpb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","and the two kidneys, and the fat that is on them, which is by the loins, and the cover on the liver, with the kidneys, he shall take away. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","The priest shall burn them on the altar: it is the food of the offering made by fire, for a pleasant aroma; all the fat is the LORD’s. ");
INSERT INTO engwebpb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“‘It shall be a perpetual statute throughout your generations in all your dwellings, that you shall eat neither fat nor blood.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Speak to the children of Israel, saying, ‘If anyone sins unintentionally, in any of the things which the LORD has commanded not to be done, and does any one of them, ");
INSERT INTO engwebpb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","if the anointed priest sins so as to bring guilt on the people, then let him offer for his sin which he has sinned a young bull without defect to the LORD for a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He shall bring the bull to the door of the Tent of Meeting before the LORD; and he shall lay his hand on the head of the bull, and kill the bull before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","The anointed priest shall take some of the blood of the bull, and bring it to the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","The priest shall dip his finger in the blood, and sprinkle some of the blood seven times before the LORD, before the veil of the sanctuary. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","The priest shall put some of the blood on the horns of the altar of sweet incense before the LORD, which is in the Tent of Meeting; and he shall pour out the rest of the blood of the bull at the base of the altar of burnt offering, which is at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","He shall take all the fat of the bull of the sin offering from it: the fat that covers the innards, and all the fat that is on the innards, ");
INSERT INTO engwebpb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","and the two kidneys, and the fat that is on them, which is by the loins, and the cover on the liver, with the kidneys, he shall remove, ");
INSERT INTO engwebpb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","as it is removed from the bull of the sacrifice of peace offerings. The priest shall burn them on the altar of burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","He shall carry the bull’s skin, all its meat, with its head, and with its legs, its innards, and its dung ");
INSERT INTO engwebpb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","—all the rest of the bull—outside of the camp to a clean place where the ashes are poured out, and burn it on wood with fire. It shall be burnt where the ashes are poured out. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘If the whole congregation of Israel sins, and the thing is hidden from the eyes of the assembly, and they have done any of the things which the LORD has commanded not to be done, and are guilty; ");
INSERT INTO engwebpb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","when the sin in which they have sinned is known, then the assembly shall offer a young bull for a sin offering, and bring it before the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","The elders of the congregation shall lay their hands on the head of the bull before the LORD; and the bull shall be killed before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","The anointed priest shall bring some of the blood of the bull to the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","The priest shall dip his finger in the blood and sprinkle it seven times before the LORD, before the veil. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","He shall put some of the blood on the horns of the altar which is before the LORD, that is in the Tent of Meeting; and the rest of the blood he shall pour out at the base of the altar of burnt offering, which is at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","All its fat he shall take from it, and burn it on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","He shall do this with the bull; as he did with the bull of the sin offering, so he shall do with this; and the priest shall make atonement for them, and they shall be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","He shall carry the bull outside the camp, and burn it as he burnt the first bull. It is the sin offering for the assembly. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘When a ruler sins, and unwittingly does any one of all the things which the LORD his God has commanded not to be done, and is guilty, ");
INSERT INTO engwebpb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","if his sin in which he has sinned is made known to him, he shall bring as his offering a goat, a male without defect. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He shall lay his hand on the head of the goat, and kill it in the place where they kill the burnt offering before the LORD. It is a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","The priest shall take some of the blood of the sin offering with his finger, and put it on the horns of the altar of burnt offering. He shall pour out the rest of its blood at the base of the altar of burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","All its fat he shall burn on the altar, like the fat of the sacrifice of peace offerings; and the priest shall make atonement for him concerning his sin, and he will be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘If anyone of the common people sins unwittingly, in doing any of the things which the LORD has commanded not to be done, and is guilty, ");
INSERT INTO engwebpb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","if his sin which he has sinned is made known to him, then he shall bring for his offering a goat, a female without defect, for his sin which he has sinned. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","He shall lay his hand on the head of the sin offering, and kill the sin offering in the place of burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","The priest shall take some of its blood with his finger, and put it on the horns of the altar of burnt offering; and the rest of its blood he shall pour out at the base of the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","All its fat he shall take away, like the fat is taken away from the sacrifice of peace offerings; and the priest shall burn it on the altar for a pleasant aroma to the LORD; and the priest shall make atonement for him, and he will be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘If he brings a lamb as his offering for a sin offering, he shall bring a female without defect. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","He shall lay his hand on the head of the sin offering, and kill it for a sin offering in the place where they kill the burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","The priest shall take some of the blood of the sin offering with his finger, and put it on the horns of the altar of burnt offering; and all the rest of its blood he shall pour out at the base of the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","He shall remove all its fat, like the fat of the lamb is removed from the sacrifice of peace offerings. The priest shall burn them on the altar, on the offerings of the LORD made by fire. The priest shall make atonement for him concerning his sin that he has sinned, and he will be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘If anyone sins, in that he hears a public adjuration to testify, he being a witness, whether he has seen or known, if he doesn’t report it, then he shall bear his iniquity. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“‘Or if anyone touches any unclean thing, whether it is the carcass of an unclean animal, or the carcass of unclean livestock, or the carcass of unclean creeping things, and it is hidden from him, and he is unclean, then he shall be guilty. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“‘Or if he touches the uncleanness of man, whatever his uncleanness is with which he is unclean, and it is hidden from him; when he knows of it, then he shall be guilty. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“‘Or if anyone swears rashly with his lips to do evil or to do good—whatever it is that a man might utter rashly with an oath, and it is hidden from him—when he knows of it, then he will be guilty of one of these. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","It shall be, when he is guilty of one of these, he shall confess that in which he has sinned; ");
INSERT INTO engwebpb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","and he shall bring his trespass offering to the LORD for his sin which he has sinned: a female from the flock, a lamb or a goat, for a sin offering; and the priest shall make atonement for him concerning his sin. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘If he can’t afford a lamb, then he shall bring his trespass offering for that in which he has sinned, two turtledoves, or two young pigeons, to the LORD; one for a sin offering, and the other for a burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","He shall bring them to the priest, who shall first offer the one which is for the sin offering. He shall wring off its head from its neck, but shall not sever it completely. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","He shall sprinkle some of the blood of the sin offering on the side of the altar; and the rest of the blood shall be drained out at the base of the altar. It is a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","He shall offer the second for a burnt offering, according to the ordinance; and the priest shall make atonement for him concerning his sin which he has sinned, and he shall be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘But if he can’t afford two turtledoves or two young pigeons, then he shall bring as his offering for that in which he has sinned, one tenth of an ephah of fine flour for a sin offering. He shall put no oil on it, and he shall not put any frankincense on it, for it is a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","He shall bring it to the priest, and the priest shall take his handful of it as the memorial portion, and burn it on the altar, on the offerings of the LORD made by fire. It is a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","The priest shall make atonement for him concerning his sin that he has sinned in any of these things, and he will be forgiven; and the rest shall be the priest’s, as the meal offering.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“If anyone commits a trespass, and sins unwittingly regarding the LORD’s holy things, then he shall bring his trespass offering to the LORD: a ram without defect from the flock, according to your estimation in silver by shekels, according to the shekel of the sanctuary, for a trespass offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","He shall make restitution for that which he has done wrong regarding the holy thing, and shall add a fifth part to it, and give it to the priest; and the priest shall make atonement for him with the ram of the trespass offering, and he will be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“If anyone sins, doing any of the things which the LORD has commanded not to be done, though he didn’t know it, he is still guilty, and shall bear his iniquity. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","He shall bring a ram without defect from of the flock, according to your estimation, for a trespass offering, to the priest; and the priest shall make atonement for him concerning the thing in which he sinned and didn’t know it, and he will be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is a trespass offering. He is certainly guilty before the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“If anyone sins, and commits a trespass against the LORD, and deals falsely with his neighbour in a matter of deposit, or of bargain, or of robbery, or has oppressed his neighbour, ");
INSERT INTO engwebpb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","or has found that which was lost, and lied about it, and swearing to a lie—in any of these things that a man sins in his actions— ");
INSERT INTO engwebpb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","then it shall be, if he has sinned, and is guilty, he shall restore that which he took by robbery, or the thing which he has gotten by oppression, or the deposit which was committed to him, or the lost thing which he found, ");
INSERT INTO engwebpb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","or any thing about which he has sworn falsely: he shall restore it in full, and shall add a fifth part more to it. He shall return it to him to whom it belongs in the day of his being found guilty. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","He shall bring his trespass offering to the LORD: a ram without defect from the flock, according to your estimation, for a trespass offering, to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","The priest shall make atonement for him before the LORD, and he will be forgiven concerning whatever he does to become guilty.” ");
INSERT INTO engwebpb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Command Aaron and his sons, saying, ‘This is the law of the burnt offering: the burnt offering shall be on the hearth on the altar all night until the morning; and the fire of the altar shall be kept burning on it. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","The priest shall put on his linen garment, and he shall put on his linen trousers upon his body; and he shall remove the ashes from where the fire has consumed the burnt offering on the altar, and he shall put them beside the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","He shall take off his garments, and put on other garments, and carry the ashes outside the camp to a clean place. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire on the altar shall be kept burning on it, it shall not go out; and the priest shall burn wood on it every morning. He shall lay the burnt offering in order upon it, and shall burn on it the fat of the peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Fire shall be kept burning on the altar continually; it shall not go out. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘This is the law of the meal offering: the sons of Aaron shall offer it before the LORD, before the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","He shall take from there his handful of the fine flour of the meal offering, and of its oil, and all the frankincense which is on the meal offering, and shall burn it on the altar for a pleasant aroma, as its memorial portion, to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","That which is left of it Aaron and his sons shall eat. It shall be eaten without yeast in a holy place. They shall eat it in the court of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It shall not be baked with yeast. I have given it as their portion of my offerings made by fire. It is most holy, as are the sin offering and the trespass offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Every male amongst the children of Aaron shall eat of it, as their portion forever throughout your generations, from the offerings of the LORD made by fire. Whoever touches them shall be holy.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“This is the offering of Aaron and of his sons, which they shall offer to the LORD in the day when he is anointed: one tenth of an ephah of fine flour for a meal offering perpetually, half of it in the morning, and half of it in the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","It shall be made with oil in a griddle. When it is soaked, you shall bring it in. You shall offer the meal offering in baked pieces for a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","The anointed priest that will be in his place from amongst his sons shall offer it. By a statute forever, it shall be wholly burnt to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every meal offering of a priest shall be wholly burnt. It shall not be eaten.” ");
INSERT INTO engwebpb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Speak to Aaron and to his sons, saying, ‘This is the law of the sin offering: in the place where the burnt offering is killed, the sin offering shall be killed before the LORD. It is most holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest who offers it for sin shall eat it. It shall be eaten in a holy place, in the court of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Whatever shall touch its flesh shall be holy. When there is any of its blood sprinkled on a garment, you shall wash that on which it was sprinkled in a holy place. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","But the earthen vessel in which it is boiled shall be broken; and if it is boiled in a bronze vessel, it shall be scoured, and rinsed in water. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Every male amongst the priests shall eat of it. It is most holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","No sin offering, of which any of the blood is brought into the Tent of Meeting to make atonement in the Holy Place, shall be eaten. It shall be burnt with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘This is the law of the trespass offering: It is most holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","In the place where they kill the burnt offering, he shall kill the trespass offering; and its blood he shall sprinkle around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","He shall offer all of its fat: the fat tail, and the fat that covers the innards, ");
INSERT INTO engwebpb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","and he shall take away the two kidneys, and the fat that is on them, which is by the loins, and the cover on the liver, with the kidneys; ");
INSERT INTO engwebpb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","and the priest shall burn them on the altar for an offering made by fire to the LORD: it is a trespass offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Every male amongst the priests may eat of it. It shall be eaten in a holy place. It is most holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“‘As is the sin offering, so is the trespass offering; there is one law for them. The priest who makes atonement with them shall have it. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","The priest who offers any man’s burnt offering shall have for himself the skin of the burnt offering which he has offered. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Every meal offering that is baked in the oven, and all that is prepared in the pan and on the griddle, shall be the priest’s who offers it. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Every meal offering, mixed with oil or dry, belongs to all the sons of Aaron, one as well as another. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘This is the law of the sacrifice of peace offerings, which one shall offer to the LORD: ");
INSERT INTO engwebpb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If he offers it for a thanksgiving, then he shall offer with the sacrifice of thanksgiving unleavened cakes mixed with oil, and unleavened wafers anointed with oil, and cakes mixed with oil. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","He shall offer his offering with the sacrifice of his peace offerings for thanksgiving with cakes of leavened bread. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Of it he shall offer one out of each offering for a heave offering to the LORD. It shall be the priest’s who sprinkles the blood of the peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The flesh of the sacrifice of his peace offerings for thanksgiving shall be eaten on the day of his offering. He shall not leave any of it until the morning. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘But if the sacrifice of his offering is a vow, or a free will offering, it shall be eaten on the day that he offers his sacrifice. On the next day what remains of it shall be eaten, ");
INSERT INTO engwebpb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","but what remains of the meat of the sacrifice on the third day shall be burnt with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If any of the meat of the sacrifice of his peace offerings is eaten on the third day, it will not be accepted, and it shall not be credited to him who offers it. It will be an abomination, and the soul who eats any of it will bear his iniquity. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“‘The meat that touches any unclean thing shall not be eaten. It shall be burnt with fire. As for the meat, everyone who is clean may eat it; ");
INSERT INTO engwebpb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","but the soul who eats of the meat of the sacrifice of peace offerings that belongs to the LORD, having his uncleanness on him, that soul shall be cut off from his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","When anyone touches any unclean thing, the uncleanness of man, or an unclean animal, or any unclean abomination, and eats some of the meat of the sacrifice of peace offerings which belong to the LORD, that soul shall be cut off from his people.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Speak to the children of Israel, saying, ‘You shall eat no fat, of bull, or sheep, or goat. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","The fat of that which dies of itself, and the fat of that which is torn of animals, may be used for any other service, but you shall in no way eat of it. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","For whoever eats the fat of the animal which men offer as an offering made by fire to the LORD, even the soul who eats it shall be cut off from his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","You shall not eat any blood, whether it is of bird or of animal, in any of your dwellings. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Whoever it is who eats any blood, that soul shall be cut off from his people.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Speak to the children of Israel, saying, ‘He who offers the sacrifice of his peace offerings to the LORD shall bring his offering to the LORD out of the sacrifice of his peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","With his own hands he shall bring the offerings of the LORD made by fire. He shall bring the fat with the breast, that the breast may be waved for a wave offering before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","The priest shall burn the fat on the altar, but the breast shall be Aaron’s and his sons’. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","The right thigh you shall give to the priest for a heave offering out of the sacrifices of your peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","He amongst the sons of Aaron who offers the blood of the peace offerings, and the fat, shall have the right thigh for a portion. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","For the waved breast and the heaved thigh I have taken from the children of Israel out of the sacrifices of their peace offerings, and have given them to Aaron the priest and to his sons as their portion forever from the children of Israel.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the consecrated portion of Aaron, and the consecrated portion of his sons, out of the offerings of the LORD made by fire, in the day when he presented them to minister to the LORD in the priest’s office; ");
INSERT INTO engwebpb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","which the LORD commanded to be given them of the children of Israel, in the day that he anointed them. It is their portion forever throughout their generations. ");
INSERT INTO engwebpb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the law of the burnt offering, the meal offering, the sin offering, the trespass offering, the consecration, and the sacrifice of peace offerings ");
INSERT INTO engwebpb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","which the LORD commanded Moses in Mount Sinai in the day that he commanded the children of Israel to offer their offerings to the LORD, in the wilderness of Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Take Aaron and his sons with him, and the garments, and the anointing oil, and the bull of the sin offering, and the two rams, and the basket of unleavened bread; ");
INSERT INTO engwebpb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","and assemble all the congregation at the door of the Tent of Meeting.” ");
INSERT INTO engwebpb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses did as the LORD commanded him; and the congregation was assembled at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moses said to the congregation, “This is the thing which the LORD has commanded to be done.” ");
INSERT INTO engwebpb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moses brought Aaron and his sons, and washed them with water. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","He put the tunic on him, tied the sash on him, clothed him with the robe, put the ephod on him, and he tied the skilfully woven band of the ephod on him and fastened it to him with it. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","He placed the breastplate on him. He put the Urim and Thummim in the breastplate. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","He set the turban on his head. He set the golden plate, the holy crown, on the front of the turban, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moses took the anointing oil, and anointed the tabernacle and all that was in it, and sanctified them. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He sprinkled it on the altar seven times, and anointed the altar and all its vessels, and the basin and its base, to sanctify them. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He poured some of the anointing oil on Aaron’s head, and anointed him, to sanctify him. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moses brought Aaron’s sons, and clothed them with tunics, and tied sashes on them, and put headbands on them, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","He brought the bull of the sin offering, and Aaron and his sons laid their hands on the head of the bull of the sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","He killed it; and Moses took the blood, and put it around on the horns of the altar with his finger, and purified the altar, and poured out the blood at the base of the altar, and sanctified it, to make atonement for it. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","He took all the fat that was on the innards, and the cover of the liver, and the two kidneys, and their fat; and Moses burnt it on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the bull, and its skin, and its meat, and its dung, he burnt with fire outside the camp, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","He presented the ram of the burnt offering. Aaron and his sons laid their hands on the head of the ram. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","He killed it; and Moses sprinkled the blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","He cut the ram into its pieces; and Moses burnt the head, and the pieces, and the fat. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","He washed the innards and the legs with water; and Moses burnt the whole ram on the altar. It was a burnt offering for a pleasant aroma. It was an offering made by fire to the LORD, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","He presented the other ram, the ram of consecration. Aaron and his sons laid their hands on the head of the ram. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","He killed it; and Moses took some of its blood, and put it on the tip of Aaron’s right ear, and on the thumb of his right hand, and on the great toe of his right foot. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","He brought Aaron’s sons; and Moses put some of the blood on the tip of their right ear, and on the thumb of their right hand, and on the great toe of their right foot; and Moses sprinkled the blood around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","He took the fat, the fat tail, all the fat that was on the innards, the cover of the liver, the two kidneys and their fat, and the right thigh; ");
INSERT INTO engwebpb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","and out of the basket of unleavened bread that was before the LORD, he took one unleavened cake, one cake of oiled bread, and one wafer, and placed them on the fat and on the right thigh. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","He put all these in Aaron’s hands and in his sons’ hands, and waved them for a wave offering before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moses took them from their hands, and burnt them on the altar on the burnt offering. They were a consecration offering for a pleasant aroma. It was an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moses took the breast, and waved it for a wave offering before the LORD. It was Moses’ portion of the ram of consecration, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moses took some of the anointing oil, and some of the blood which was on the altar, and sprinkled it on Aaron, on his garments, and on his sons, and on his sons’ garments with him, and sanctified Aaron, his garments, and his sons, and his sons’ garments with him. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moses said to Aaron and to his sons, “Boil the meat at the door of the Tent of Meeting, and there eat it and the bread that is in the basket of consecration, as I commanded, saying, ‘Aaron and his sons shall eat it.’ ");
INSERT INTO engwebpb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","What remains of the meat and of the bread you shall burn with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","You shall not go out from the door of the Tent of Meeting for seven days, until the days of your consecration are fulfilled: for he shall consecrate you seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What has been done today, so the LORD has commanded to do, to make atonement for you. ");
INSERT INTO engwebpb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You shall stay at the door of the Tent of Meeting day and night seven days, and keep the LORD’s command, that you don’t die: for so I am commanded.” ");
INSERT INTO engwebpb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron and his sons did all the things which the LORD commanded by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","On the eighth day, Moses called Aaron and his sons, and the elders of Israel; ");
INSERT INTO engwebpb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","and he said to Aaron, “Take a calf from the herd for a sin offering, and a ram for a burnt offering, without defect, and offer them before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","You shall speak to the children of Israel, saying, ‘Take a male goat for a sin offering; and a calf and a lamb, both a year old, without defect, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","and a bull and a ram for peace offerings, to sacrifice before the LORD; and a meal offering mixed with oil: for today the LORD appears to you.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","They brought what Moses commanded before the Tent of Meeting. All the congregation came near and stood before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moses said, “This is the thing which the LORD commanded that you should do; and the LORD’s glory shall appear to you.” ");
INSERT INTO engwebpb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moses said to Aaron, “Draw near to the altar, and offer your sin offering, and your burnt offering, and make atonement for yourself, and for the people; and offer the offering of the people, and make atonement for them, as the LORD commanded.” ");
INSERT INTO engwebpb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron came near to the altar, and killed the calf of the sin offering, which was for himself. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","The sons of Aaron presented the blood to him; and he dipped his finger in the blood, and put it on the horns of the altar, and poured out the blood at the base of the altar; ");
INSERT INTO engwebpb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","but the fat, and the kidneys, and the cover from the liver of the sin offering, he burnt upon the altar, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","The meat and the skin he burnt with fire outside the camp. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","He killed the burnt offering; and Aaron’s sons delivered the blood to him, and he sprinkled it around on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","They delivered the burnt offering to him, piece by piece, and the head. He burnt them upon the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","He washed the innards and the legs, and burnt them on the burnt offering on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","He presented the people’s offering, and took the goat of the sin offering which was for the people, and killed it, and offered it for sin, like the first. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","He presented the burnt offering, and offered it according to the ordinance. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","He presented the meal offering, and filled his hand from there, and burnt it upon the altar, in addition to the burnt offering of the morning. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","He also killed the bull and the ram, the sacrifice of peace offerings, which was for the people. Aaron’s sons delivered to him the blood, which he sprinkled around on the altar; ");
INSERT INTO engwebpb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","and the fat of the bull and of the ram, the fat tail, and that which covers the innards, and the kidneys, and the cover of the liver; ");
INSERT INTO engwebpb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","and they put the fat upon the breasts, and he burnt the fat on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aaron waved the breasts and the right thigh for a wave offering before the LORD, as Moses commanded. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aaron lifted up his hands towards the people, and blessed them; and he came down from offering the sin offering, and the burnt offering, and the peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses and Aaron went into the Tent of Meeting, and came out, and blessed the people; and the LORD’s glory appeared to all the people. ");
INSERT INTO engwebpb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Fire came out from before the LORD, and consumed the burnt offering and the fat upon the altar. When all the people saw it, they shouted, and fell on their faces. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab and Abihu, the sons of Aaron, each took his censer, and put fire in it, and laid incense on it, and offered strange fire before the LORD, which he had not commanded them. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Fire came out from before the LORD, and devoured them, and they died before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moses said to Aaron, “This is what the LORD spoke of, saying, ‘I will show myself holy to those who come near me, and before all the people I will be glorified.’” Aaron held his peace. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moses called Mishael and Elzaphan, the sons of Uzziel the uncle of Aaron, and said to them, “Draw near, carry your brothers from before the sanctuary out of the camp.” ");
INSERT INTO engwebpb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they came near, and carried them in their tunics out of the camp, as Moses had said. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moses said to Aaron, and to Eleazar and to Ithamar, his sons, “Don’t let the hair of your heads go loose, and don’t tear your clothes, so that you don’t die, and so that he will not be angry with all the congregation; but let your brothers, the whole house of Israel, bewail the burning which the LORD has kindled. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","You shall not go out from the door of the Tent of Meeting, lest you die; for the anointing oil of the LORD is on you.” They did according to the word of Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Then the LORD said to Aaron, ");
INSERT INTO engwebpb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“You and your sons are not to drink wine or strong drink whenever you go into the Tent of Meeting, or you will die. This shall be a statute forever throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","You are to make a distinction between the holy and the common, and between the unclean and the clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","You are to teach the children of Israel all the statutes which the LORD has spoken to them by Moses.” ");
INSERT INTO engwebpb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moses spoke to Aaron, and to Eleazar and to Ithamar, his sons who were left, “Take the meal offering that remains of the offerings of the LORD made by fire, and eat it without yeast beside the altar; for it is most holy; ");
INSERT INTO engwebpb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","and you shall eat it in a holy place, because it is your portion, and your sons’ portion, of the offerings of the LORD made by fire; for so I am commanded. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","The waved breast and the heaved thigh you shall eat in a clean place, you, and your sons, and your daughters with you: for they are given as your portion, and your sons’ portion, out of the sacrifices of the peace offerings of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","They shall bring the heaved thigh and the waved breast with the offerings made by fire of the fat, to wave it for a wave offering before the LORD. It shall be yours, and your sons’ with you, as a portion forever, as the LORD has commanded.” ");
INSERT INTO engwebpb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moses diligently enquired about the goat of the sin offering, and, behold, it was burnt. He was angry with Eleazar and with Ithamar, the sons of Aaron who were left, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why haven’t you eaten the sin offering in the place of the sanctuary, since it is most holy, and he has given it to you to bear the iniquity of the congregation, to make atonement for them before the LORD? ");
INSERT INTO engwebpb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Behold, its blood was not brought into the inner part of the sanctuary. You certainly should have eaten it in the sanctuary, as I commanded.” ");
INSERT INTO engwebpb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron spoke to Moses, “Behold, today they have offered their sin offering and their burnt offering before the LORD; and such things as these have happened to me. If I had eaten the sin offering today, would it have been pleasing in the LORD’s sight?” ");
INSERT INTO engwebpb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","When Moses heard that, it was pleasing in his sight. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","The LORD spoke to Moses and to Aaron, saying to them, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Speak to the children of Israel, saying, ‘These are the living things which you may eat amongst all the animals that are on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Whatever parts the hoof, and is cloven-footed, and chews the cud amongst the animals, that you may eat. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“‘Nevertheless these you shall not eat of those that chew the cud, or of those who part the hoof: the camel, because it chews the cud but doesn’t have a parted hoof, is unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","The hyrax, because it chews the cud but doesn’t have a parted hoof, is unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","The hare, because it chews the cud but doesn’t have a parted hoof, is unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","The pig, because it has a split hoof, and is cloven-footed, but doesn’t chew the cud, is unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","You shall not eat their meat. You shall not touch their carcasses. They are unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘You may eat of all these that are in the waters: whatever has fins and scales in the waters, in the seas, and in the rivers, that you may eat. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","All that don’t have fins and scales in the seas and rivers, all that move in the waters, and all the living creatures that are in the waters, they are an abomination to you, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","and you shall detest them. You shall not eat of their meat, and you shall detest their carcasses. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Whatever has no fins nor scales in the waters is an abomination to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“‘You shall detest these amongst the birds; they shall not be eaten because they are an abomination: the eagle, the vulture, the black vulture, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","the red kite, any kind of black kite, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","any kind of raven, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","the horned owl, the screech owl, the gull, any kind of hawk, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","the little owl, the cormorant, the great owl, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","the white owl, the desert owl, the osprey, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","the stork, any kind of heron, the hoopoe, and the bat. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘All flying insects that walk on all fours are an abomination to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yet you may eat these: of all winged creeping things that go on all fours, which have long, jointed legs for hopping on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Even of these you may eat: any kind of locust, any kind of katydid, any kind of cricket, and any kind of grasshopper. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But all winged creeping things which have four feet are an abomination to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘By these you will become unclean: whoever touches their carcass shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Whoever carries any part of their carcass shall wash his clothes, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“‘Every animal which has a split hoof that isn’t completely divided, or doesn’t chew the cud, is unclean to you. Everyone who touches them shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Whatever goes on its paws, amongst all animals that go on all fours, they are unclean to you. Whoever touches their carcass shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","He who carries their carcass shall wash his clothes, and be unclean until the evening. They are unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“‘These are they which are unclean to you amongst the creeping things that creep on the earth: the weasel, the rat, any kind of great lizard, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","the gecko, and the monitor lizard, the wall lizard, the skink, and the chameleon. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","These are they which are unclean to you amongst all that creep. Whoever touches them when they are dead shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Anything they fall on when they are dead shall be unclean; whether it is any vessel of wood, or clothing, or skin, or sack, whatever vessel it is, with which any work is done, it must be put into water, and it shall be unclean until the evening. Then it will be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Every earthen vessel into which any of them falls and all that is in it shall be unclean. You shall break it. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","All food which may be eaten which is soaked in water shall be unclean. All drink that may be drunk in every such vessel shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Everything whereupon part of their carcass falls shall be unclean; whether oven, or range for pots, it shall be broken in pieces. They are unclean, and shall be unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nevertheless a spring or a cistern in which water is gathered shall be clean, but that which touches their carcass shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","If part of their carcass falls on any sowing seed which is to be sown, it is clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if water is put on the seed, and part of their carcass falls on it, it is unclean to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘If any animal of which you may eat dies, he who touches its carcass shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","He who eats of its carcass shall wash his clothes, and be unclean until the evening. He also who carries its carcass shall wash his clothes, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“‘Every creeping thing that creeps on the earth is an abomination. It shall not be eaten. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Whatever goes on its belly, and whatever goes on all fours, or whatever has many feet, even all creeping things that creep on the earth, them you shall not eat; for they are an abomination. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","You shall not make yourselves abominable with any creeping thing that creeps. You shall not make yourselves unclean with them, that you should be defiled by them. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","For I am the LORD your God. Sanctify yourselves therefore, and be holy; for I am holy. You shall not defile yourselves with any kind of creeping thing that moves on the earth. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","For I am the LORD who brought you up out of the land of Egypt, to be your God. You shall therefore be holy, for I am holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“‘This is the law of the animal, and of the bird, and of every living creature that moves in the waters, and of every creature that creeps on the earth, ");
INSERT INTO engwebpb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","to make a distinction between the unclean and the clean, and between the living thing that may be eaten and the living thing that may not be eaten.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Speak to the children of Israel, saying, ‘If a woman conceives, and bears a male child, then she shall be unclean seven days; as in the days of her monthly period she shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","In the eighth day the flesh of his foreskin shall be circumcised. ");
INSERT INTO engwebpb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","She shall continue in the blood of purification thirty-three days. She shall not touch any holy thing, nor come into the sanctuary, until the days of her purifying are completed. ");
INSERT INTO engwebpb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","But if she bears a female child, then she shall be unclean two weeks, as in her period; and she shall continue in the blood of purification sixty-six days. ");
INSERT INTO engwebpb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘When the days of her purification are completed for a son or for a daughter, she shall bring to the priest at the door of the Tent of Meeting, a year old lamb for a burnt offering, and a young pigeon or a turtledove, for a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","He shall offer it before the LORD, and make atonement for her; then she shall be cleansed from the fountain of her blood. “‘This is the law for her who bears, whether a male or a female. ");
INSERT INTO engwebpb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","If she cannot afford a lamb, then she shall take two turtledoves or two young pigeons: the one for a burnt offering, and the other for a sin offering. The priest shall make atonement for her, and she shall be clean.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“When a man shall have a swelling in his body’s skin, or a scab, or a bright spot, and it becomes in the skin of his body the plague of leprosy, then he shall be brought to Aaron the priest or to one of his sons, the priests. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","The priest shall examine the plague in the skin of the body. If the hair in the plague has turned white, and the appearance of the plague is deeper than the body’s skin, it is the plague of leprosy; so the priest shall examine him and pronounce him unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","If the bright spot is white in the skin of his body, and its appearance isn’t deeper than the skin, and its hair hasn’t turned white, then the priest shall isolate the infected person for seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","The priest shall examine him on the seventh day. Behold, if in his eyes the plague is arrested and the plague hasn’t spread in the skin, then the priest shall isolate him for seven more days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","The priest shall examine him again on the seventh day. Behold, if the plague has faded and the plague hasn’t spread in the skin, then the priest shall pronounce him clean. It is a scab. He shall wash his clothes, and be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the scab spreads on the skin after he has shown himself to the priest for his cleansing, he shall show himself to the priest again. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","The priest shall examine him; and behold, if the scab has spread on the skin, then the priest shall pronounce him unclean. It is leprosy. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“When the plague of leprosy is in a man, then he shall be brought to the priest; ");
INSERT INTO engwebpb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","and the priest shall examine him. Behold, if there is a white swelling in the skin, and it has turned the hair white, and there is raw flesh in the swelling, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","it is a chronic leprosy in the skin of his body, and the priest shall pronounce him unclean. He shall not isolate him, for he is already unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“If the leprosy breaks out all over the skin, and the leprosy covers all the skin of the infected person from his head even to his feet, as far as it appears to the priest, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","then the priest shall examine him. Behold, if the leprosy has covered all his flesh, he shall pronounce him clean of the plague. It has all turned white: he is clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But whenever raw flesh appears in him, he shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","The priest shall examine the raw flesh, and pronounce him unclean: the raw flesh is unclean. It is leprosy. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Or if the raw flesh turns again, and is changed to white, then he shall come to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest shall examine him. Behold, if the plague has turned white, then the priest shall pronounce him clean of the plague. He is clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“When the body has a boil on its skin, and it has healed, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","and in the place of the boil there is a white swelling, or a bright spot, reddish-white, then it shall be shown to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest shall examine it. Behold, if its appearance is deeper than the skin, and its hair has turned white, then the priest shall pronounce him unclean. It is the plague of leprosy. It has broken out in the boil. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But if the priest examines it, and behold, there are no white hairs in it, and it isn’t deeper than the skin, but is dim, then the priest shall isolate him seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","If it spreads in the skin, then the priest shall pronounce him unclean. It is a plague. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the bright spot stays in its place, and hasn’t spread, it is the scar from the boil; and the priest shall pronounce him clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Or when the body has a burn from fire on its skin, and the raw flesh of the burn becomes a bright spot, reddish-white, or white, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","then the priest shall examine it; and behold, if the hair in the bright spot has turned white, and its appearance is deeper than the skin, it is leprosy. It has broken out in the burning, and the priest shall pronounce him unclean. It is the plague of leprosy. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if the priest examines it, and behold, there is no white hair in the bright spot, and it isn’t deeper than the skin, but has faded, then the priest shall isolate him seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","The priest shall examine him on the seventh day. If it has spread in the skin, then the priest shall pronounce him unclean. It is the plague of leprosy. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","If the bright spot stays in its place, and hasn’t spread in the skin, but is faded, it is the swelling from the burn, and the priest shall pronounce him clean, for it is the scar from the burn. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“When a man or woman has a plague on the head or on the beard, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","then the priest shall examine the plague; and behold, if its appearance is deeper than the skin, and the hair in it is yellow and thin, then the priest shall pronounce him unclean. It is an itch. It is leprosy of the head or of the beard. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","If the priest examines the plague of itching, and behold, its appearance isn’t deeper than the skin, and there is no black hair in it, then the priest shall isolate the person infected with itching seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","On the seventh day the priest shall examine the plague; and behold, if the itch hasn’t spread, and there is no yellow hair in it, and the appearance of the itch isn’t deeper than the skin, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","then he shall be shaved, but he shall not shave the itch. Then the priest shall isolate the one who has the itch seven more days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","On the seventh day, the priest shall examine the itch; and behold, if the itch hasn’t spread in the skin, and its appearance isn’t deeper than the skin, then the priest shall pronounce him clean. He shall wash his clothes and be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the itch spreads in the skin after his cleansing, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","then the priest shall examine him; and behold, if the itch has spread in the skin, the priest shall not look for the yellow hair; he is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if in his eyes the itch is arrested and black hair has grown in it, then the itch is healed. He is clean. The priest shall pronounce him clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“When a man or a woman has bright spots in the skin of the body, even white bright spots, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","then the priest shall examine them. Behold, if the bright spots on the skin of their body are a dull white, it is a harmless rash. It has broken out in the skin. He is clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“If a man’s hair has fallen from his head, he is bald. He is clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","If his hair has fallen off from the front part of his head, his forehead is bald. He is clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if a reddish-white plague is in the bald head or the bald forehead, it is leprosy breaking out in his bald head or his bald forehead. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Then the priest shall examine him. Behold, if the swelling of the plague is reddish-white in his bald head, or in his bald forehead, like the appearance of leprosy in the skin of the body, ");
INSERT INTO engwebpb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he is a leprous man. He is unclean. The priest shall surely pronounce him unclean. His plague is on his head. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“The leper in whom the plague is shall wear torn clothes, and the hair of his head shall hang loose. He shall cover his upper lip, and shall cry, ‘Unclean! Unclean!’ ");
INSERT INTO engwebpb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","All the days in which the plague is in him he shall be unclean. He is unclean. He shall dwell alone. His dwelling shall be outside of the camp. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“The garment also that the plague of leprosy is in, whether it is a woollen garment, or a linen garment; ");
INSERT INTO engwebpb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","whether it is in warp or woof; of linen or of wool; whether in leather, or in anything made of leather; ");
INSERT INTO engwebpb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","if the plague is greenish or reddish in the garment, or in the leather, or in the warp, or in the woof, or in anything made of leather; it is the plague of leprosy, and shall be shown to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","The priest shall examine the plague, and isolate the plague seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","He shall examine the plague on the seventh day. If the plague has spread in the garment, either in the warp, or in the woof, or in the skin, whatever use the skin is used for, the plague is a destructive mildew. It is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","He shall burn the garment, whether the warp or the woof, in wool or in linen, or anything of leather, in which the plague is, for it is a destructive mildew. It shall be burnt in the fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“If the priest examines it, and behold, the plague hasn’t spread in the garment, either in the warp, or in the woof, or in anything of skin; ");
INSERT INTO engwebpb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","then the priest shall command that they wash the thing that the plague is in, and he shall isolate it seven more days. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Then the priest shall examine it, after the plague is washed; and behold, if the plague hasn’t changed its colour, and the plague hasn’t spread, it is unclean; you shall burn it in the fire. It is a mildewed spot, whether the bareness is inside or outside. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","If the priest looks, and behold, the plague has faded after it is washed, then he shall tear it out of the garment, or out of the skin, or out of the warp, or out of the woof; ");
INSERT INTO engwebpb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","and if it appears again in the garment, either in the warp, or in the woof, or in anything of skin, it is spreading. You shall burn what the plague is in with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","The garment, either the warp, or the woof, or whatever thing of skin it is, which you shall wash, if the plague has departed from them, then it shall be washed the second time, and it will be clean.” ");
INSERT INTO engwebpb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the law of the plague of mildew in a garment of wool or linen, either in the warp, or the woof, or in anything of skin, to pronounce it clean, or to pronounce it unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“This shall be the law of the leper in the day of his cleansing: He shall be brought to the priest, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","and the priest shall go out of the camp. The priest shall examine him. Behold, if the plague of leprosy is healed in the leper, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","then the priest shall command them to take for him who is to be cleansed two living clean birds, cedar wood, scarlet, and hyssop. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","The priest shall command them to kill one of the birds in an earthen vessel over running water. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","As for the living bird, he shall take it, the cedar wood, the scarlet, and the hyssop, and shall dip them and the living bird in the blood of the bird that was killed over the running water. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","He shall sprinkle on him who is to be cleansed from the leprosy seven times, and shall pronounce him clean, and shall let the living bird go into the open field. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“He who is to be cleansed shall wash his clothes, and shave off all his hair, and bathe himself in water; and he shall be clean. After that he shall come into the camp, but shall dwell outside his tent seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","It shall be on the seventh day, that he shall shave all his hair off his head and his beard and his eyebrows. He shall shave off all his hair. He shall wash his clothes, and he shall bathe his body in water. Then he shall be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“On the eighth day he shall take two male lambs without defect, one ewe lamb a year old without defect, three tenths of an ephah of fine flour for a meal offering, mixed with oil, and one log of oil. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","The priest who cleanses him shall set the man who is to be cleansed, and those things, before the LORD, at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“The priest shall take one of the male lambs, and offer him for a trespass offering, with the log of oil, and wave them for a wave offering before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","He shall kill the male lamb in the place where they kill the sin offering and the burnt offering, in the place of the sanctuary; for as the sin offering is the priest’s, so is the trespass offering. It is most holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","The priest shall take some of the blood of the trespass offering, and the priest shall put it on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","The priest shall take some of the log of oil, and pour it into the palm of his own left hand. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","The priest shall dip his right finger in the oil that is in his left hand, and shall sprinkle some of the oil with his finger seven times before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","The priest shall put some of the rest of the oil that is in his hand on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the big toe of his right foot, upon the blood of the trespass offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","The rest of the oil that is in the priest’s hand he shall put on the head of him who is to be cleansed, and the priest shall make atonement for him before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“The priest shall offer the sin offering, and make atonement for him who is to be cleansed because of his uncleanness. Afterward he shall kill the burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","then the priest shall offer the burnt offering and the meal offering on the altar. The priest shall make atonement for him, and he shall be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“If he is poor, and can’t afford so much, then he shall take one male lamb for a trespass offering to be waved, to make atonement for him, and one tenth of an ephah of fine flour mixed with oil for a meal offering, and a log of oil; ");
INSERT INTO engwebpb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two turtledoves, or two young pigeons, such as he is able to afford; and the one shall be a sin offering, and the other a burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“On the eighth day he shall bring them for his cleansing to the priest, to the door of the Tent of Meeting, before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","The priest shall take the lamb of the trespass offering, and the log of oil, and the priest shall wave them for a wave offering before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","He shall kill the lamb of the trespass offering. The priest shall take some of the blood of the trespass offering and put it on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","The priest shall pour some of the oil into the palm of his own left hand; ");
INSERT INTO engwebpb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and the priest shall sprinkle with his right finger some of the oil that is in his left hand seven times before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Then the priest shall put some of the oil that is in his hand on the tip of the right ear of him who is to be cleansed, and on the thumb of his right hand, and on the big toe of his right foot, on the place of the blood of the trespass offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","The rest of the oil that is in the priest’s hand he shall put on the head of him who is to be cleansed, to make atonement for him before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","He shall offer one of the turtledoves, or of the young pigeons, which ever he is able to afford, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","of the kind he is able to afford, the one for a sin offering, and the other for a burnt offering, with the meal offering. The priest shall make atonement for him who is to be cleansed before the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the law for him in whom is the plague of leprosy, who is not able to afford the sacrifice for his cleansing. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“When you have come into the land of Canaan, which I give to you for a possession, and I put a spreading mildew in a house in the land of your possession, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","then he who owns the house shall come and tell the priest, saying, ‘There seems to me to be some sort of plague in the house.’ ");
INSERT INTO engwebpb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","The priest shall command that they empty the house, before the priest goes in to examine the plague, that all that is in the house not be made unclean. Afterward the priest shall go in to inspect the house. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","He shall examine the plague; and behold, if the plague is in the walls of the house with hollow streaks, greenish or reddish, and it appears to be deeper than the wall, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","then the priest shall go out of the house to the door of the house, and shut up the house seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","The priest shall come again on the seventh day, and look. If the plague has spread in the walls of the house, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","then the priest shall command that they take out the stones in which is the plague, and cast them into an unclean place outside of the city. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","He shall cause the inside of the house to be scraped all over. They shall pour out the mortar that they scraped off outside of the city into an unclean place. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","They shall take other stones, and put them in the place of those stones; and he shall take other mortar, and shall plaster the house. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“If the plague comes again, and breaks out in the house after he has taken out the stones, and after he has scraped the house, and after it was plastered, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","then the priest shall come in and look; and behold, if the plague has spread in the house, it is a destructive mildew in the house. It is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","He shall break down the house, its stones, and its timber, and all the house’s mortar. He shall carry them out of the city into an unclean place. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Moreover he who goes into the house while it is shut up shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","He who lies down in the house shall wash his clothes; and he who eats in the house shall wash his clothes. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“If the priest shall come in, and examine it, and behold, the plague hasn’t spread in the house, after the house was plastered, then the priest shall pronounce the house clean, because the plague is healed. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","To cleanse the house he shall take two birds, cedar wood, scarlet, and hyssop. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","He shall kill one of the birds in an earthen vessel over running water. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","He shall take the cedar wood, the hyssop, the scarlet, and the living bird, and dip them in the blood of the slain bird, and in the running water, and sprinkle the house seven times. ");
INSERT INTO engwebpb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","He shall cleanse the house with the blood of the bird, and with the running water, with the living bird, with the cedar wood, with the hyssop, and with the scarlet; ");
INSERT INTO engwebpb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","but he shall let the living bird go out of the city into the open field. So shall he make atonement for the house; and it shall be clean.” ");
INSERT INTO engwebpb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","This is the law for any plague of leprosy, and for an itch, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","and for the destructive mildew of a garment, and for a house, ");
INSERT INTO engwebpb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","and for a swelling, and for a scab, and for a bright spot; ");
INSERT INTO engwebpb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","to teach when it is unclean, and when it is clean. This is the law of leprosy. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Speak to the children of Israel, and tell them, ‘When any man has a discharge from his body, because of his discharge he is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","This shall be his uncleanness in his discharge: whether his body runs with his discharge, or his body has stopped from his discharge, it is his uncleanness. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“‘Every bed on which he who has the discharge lies shall be unclean; and everything he sits on shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Whoever touches his bed shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","He who sits on anything on which the man who has the discharge sat shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“‘He who touches the body of him who has the discharge shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“‘If he who has the discharge spits on him who is clean, then he shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“‘Whatever saddle he who has the discharge rides on shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Whoever touches anything that was under him shall be unclean until the evening. He who carries those things shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“‘Whomever he who has the discharge touches, without having rinsed his hands in water, he shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“‘The earthen vessel, which he who has the discharge touches, shall be broken; and every vessel of wood shall be rinsed in water. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“‘When he who has a discharge is cleansed of his discharge, then he shall count to himself seven days for his cleansing, and wash his clothes; and he shall bathe his flesh in running water, and shall be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","“‘On the eighth day he shall take two turtledoves, or two young pigeons, and come before the LORD to the door of the Tent of Meeting, and give them to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","The priest shall offer them, the one for a sin offering, and the other for a burnt offering. The priest shall make atonement for him before the LORD for his discharge. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘If any man has an emission of semen, then he shall bathe all his flesh in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Every garment and every skin which the semen is on shall be washed with water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","If a man lies with a woman and there is an emission of semen, they shall both bathe themselves in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘If a woman has a discharge, and her discharge in her flesh is blood, she shall be in her impurity seven days. Whoever touches her shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“‘Everything that she lies on in her impurity shall be unclean. Everything also that she sits on shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Whoever touches her bed shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Whoever touches anything that she sits on shall wash his clothes, and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","If it is on the bed, or on anything she sits on, when he touches it, he shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“‘If any man lies with her, and her monthly flow is on him, he shall be unclean seven days; and every bed he lies on shall be unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘If a woman has a discharge of her blood many days not in the time of her period, or if she has a discharge beyond the time of her period, all the days of the discharge of her uncleanness shall be as in the days of her period. She is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Every bed she lies on all the days of her discharge shall be to her as the bed of her period. Everything she sits on shall be unclean, as the uncleanness of her period. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Whoever touches these things shall be unclean, and shall wash his clothes and bathe himself in water, and be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“‘But if she is cleansed of her discharge, then she shall count to herself seven days, and after that she shall be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","On the eighth day she shall take two turtledoves, or two young pigeons, and bring them to the priest, to the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","The priest shall offer the one for a sin offering, and the other for a burnt offering; and the priest shall make atonement for her before the LORD for the uncleanness of her discharge. ");
INSERT INTO engwebpb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘Thus you shall separate the children of Israel from their uncleanness, so they will not die in their uncleanness when they defile my tabernacle that is amongst them.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","This is the law of him who has a discharge, and of him who has an emission of semen, so that he is unclean by it; ");
INSERT INTO engwebpb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","and of her who has her period, and of a man or woman who has a discharge, and of him who lies with her who is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","The LORD spoke to Moses after the death of the two sons of Aaron, when they came near before the LORD, and died; ");
INSERT INTO engwebpb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","and the LORD said to Moses, “Tell Aaron your brother not to come at just any time into the Most Holy Place within the veil, before the mercy seat which is on the ark; lest he die; for I will appear in the cloud on the mercy seat. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aaron shall come into the sanctuary with a young bull for a sin offering, and a ram for a burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","He shall put on the holy linen tunic. He shall have the linen trousers on his body, and shall put on the linen sash, and he shall be clothed with the linen turban. They are the holy garments. He shall bathe his body in water, and put them on. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","He shall take from the congregation of the children of Israel two male goats for a sin offering, and one ram for a burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aaron shall offer the bull of the sin offering, which is for himself, and make atonement for himself and for his house. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","He shall take the two goats, and set them before the LORD at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron shall cast lots for the two goats: one lot for the LORD, and the other lot for the scapegoat. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron shall present the goat on which the lot fell for the LORD, and offer him for a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","But the goat on which the lot fell for the scapegoat shall be presented alive before the LORD, to make atonement for him, to send him away as the scapegoat into the wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aaron shall present the bull of the sin offering, which is for himself, and shall make atonement for himself and for his house, and shall kill the bull of the sin offering which is for himself. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","He shall take a censer full of coals of fire from off the altar before the LORD, and two handfuls of sweet incense beaten small, and bring it within the veil. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","He shall put the incense on the fire before the LORD, that the cloud of the incense may cover the mercy seat that is on the covenant, so that he will not die. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","He shall take some of the blood of the bull, and sprinkle it with his finger on the mercy seat on the east; and before the mercy seat he shall sprinkle some of the blood with his finger seven times. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Then he shall kill the goat of the sin offering that is for the people, and bring his blood within the veil, and do with his blood as he did with the blood of the bull, and sprinkle it on the mercy seat and before the mercy seat. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","He shall make atonement for the Holy Place, because of the uncleanness of the children of Israel, and because of their transgressions, even all their sins; and so he shall do for the Tent of Meeting that dwells with them in the middle of their uncleanness. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","No one shall be in the Tent of Meeting when he enters to make atonement in the Holy Place, until he comes out, and has made atonement for himself and for his household, and for all the assembly of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“He shall go out to the altar that is before the LORD and make atonement for it, and shall take some of the bull’s blood, and some of the goat’s blood, and put it around on the horns of the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","He shall sprinkle some of the blood on it with his finger seven times, and cleanse it, and make it holy from the uncleanness of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“When he has finished atoning for the Holy Place, the Tent of Meeting, and the altar, he shall present the live goat. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron shall lay both his hands on the head of the live goat, and confess over him all the iniquities of the children of Israel, and all their transgressions, even all their sins; and he shall put them on the head of the goat, and shall send him away into the wilderness by the hand of a man who is ready. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","The goat shall carry all their iniquities on himself to a solitary land, and he shall release the goat in the wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aaron shall come into the Tent of Meeting, and shall take off the linen garments which he put on when he went into the Holy Place, and shall leave them there. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Then he shall bathe himself in water in a holy place, put on his garments, and come out and offer his burnt offering and the burnt offering of the people, and make atonement for himself and for the people. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","The fat of the sin offering he shall burn on the altar. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“He who lets the goat go as the scapegoat shall wash his clothes, and bathe his flesh in water, and afterward he shall come into the camp. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","The bull for the sin offering, and the goat for the sin offering, whose blood was brought in to make atonement in the Holy Place, shall be carried outside the camp; and they shall burn their skins, their flesh, and their dung with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","He who burns them shall wash his clothes, and bathe his flesh in water, and afterward he shall come into the camp. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“It shall be a statute to you forever: in the seventh month, on the tenth day of the month, you shall afflict your souls, and shall do no kind of work, whether native-born or a stranger who lives as a foreigner amongst you; ");
INSERT INTO engwebpb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","for on this day shall atonement be made for you, to cleanse you. You shall be clean from all your sins before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It is a Sabbath of solemn rest to you, and you shall afflict your souls. It is a statute forever. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","The priest, who is anointed and who is consecrated to be priest in his father’s place, shall make the atonement, and shall put on the linen garments, even the holy garments. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Then he shall make atonement for the Holy Sanctuary; and he shall make atonement for the Tent of Meeting and for the altar; and he shall make atonement for the priests and for all the people of the assembly. ");
INSERT INTO engwebpb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“This shall be an everlasting statute for you, to make atonement for the children of Israel once in the year because of all their sins.” It was done as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Speak to Aaron, and to his sons, and to all the children of Israel, and say to them, ‘This is the thing which the LORD has commanded: ");
INSERT INTO engwebpb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Whatever man there is of the house of Israel who kills a bull, or lamb, or goat in the camp, or who kills it outside the camp, ");
INSERT INTO engwebpb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","and hasn’t brought it to the door of the Tent of Meeting to offer it as an offering to the LORD before the LORD’s tabernacle: blood shall be imputed to that man. He has shed blood. That man shall be cut off from amongst his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","This is to the end that the children of Israel may bring their sacrifices, which they sacrifice in the open field, that they may bring them to the LORD, to the door of the Tent of Meeting, to the priest, and sacrifice them for sacrifices of peace offerings to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","The priest shall sprinkle the blood on the LORD’s altar at the door of the Tent of Meeting, and burn the fat for a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","They shall no more sacrifice their sacrifices to the goat idols, after which they play the prostitute. This shall be a statute forever to them throughout their generations.’ ");
INSERT INTO engwebpb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“You shall say to them, ‘Any man there is of the house of Israel, or of the strangers who live as foreigners amongst them, who offers a burnt offering or sacrifice, ");
INSERT INTO engwebpb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","and doesn’t bring it to the door of the Tent of Meeting to sacrifice it to the LORD, that man shall be cut off from his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘Any man of the house of Israel, or of the strangers who live as foreigners amongst them, who eats any kind of blood, I will set my face against that soul who eats blood, and will cut him off from amongst his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","For the life of the flesh is in the blood. I have given it to you on the altar to make atonement for your souls; for it is the blood that makes atonement by reason of the life. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Therefore I have said to the children of Israel, “No person amongst you may eat blood, nor may any stranger who lives as a foreigner amongst you eat blood.” ");
INSERT INTO engwebpb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“‘Whatever man there is of the children of Israel, or of the strangers who live as foreigners amongst them, who takes in hunting any animal or bird that may be eaten, he shall pour out its blood, and cover it with dust. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","For as to the life of all flesh, its blood is with its life. Therefore I said to the children of Israel, “You shall not eat the blood of any kind of flesh; for the life of all flesh is its blood. Whoever eats it shall be cut off.” ");
INSERT INTO engwebpb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“‘Every person that eats what dies of itself, or that which is torn by animals, whether he is native-born or a foreigner, shall wash his clothes, and bathe himself in water, and be unclean until the evening. Then he shall be clean. ");
INSERT INTO engwebpb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if he doesn’t wash them, or bathe his flesh, then he shall bear his iniquity.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","The LORD said to Moses, ");
INSERT INTO engwebpb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Speak to the children of Israel, and say to them, ‘I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You shall not do as they do in the land of Egypt, where you lived. You shall not do as they do in the land of Canaan, where I am bringing you. You shall not follow their statutes. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","You shall do my ordinances. You shall keep my statutes and walk in them. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","You shall therefore keep my statutes and my ordinances, which if a man does, he shall live in them. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘None of you shall approach any close relatives, to uncover their nakedness: I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“‘You shall not uncover the nakedness of your father, nor the nakedness of your mother: she is your mother. You shall not uncover her nakedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“‘You shall not uncover the nakedness of your father’s wife. It is your father’s nakedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“‘You shall not uncover the nakedness of your sister, the daughter of your father, or the daughter of your mother, whether born at home or born abroad. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“‘You shall not uncover the nakedness of your son’s daughter, or of your daughter’s daughter, even their nakedness; for theirs is your own nakedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“‘You shall not uncover the nakedness of your father’s wife’s daughter, conceived by your father, since she is your sister. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“‘You shall not uncover the nakedness of your father’s sister. She is your father’s near kinswoman. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“‘You shall not uncover the nakedness of your mother’s sister, for she is your mother’s near kinswoman. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“‘You shall not uncover the nakedness of your father’s brother. You shall not approach his wife. She is your aunt. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“‘You shall not uncover the nakedness of your daughter-in-law. She is your son’s wife. You shall not uncover her nakedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“‘You shall not uncover the nakedness of your brother’s wife. It is your brother’s nakedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“‘You shall not uncover the nakedness of a woman and her daughter. You shall not take her son’s daughter, or her daughter’s daughter, to uncover her nakedness. They are near kinswomen. It is wickedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“‘You shall not take a wife in addition to her sister, to be a rival, to uncover her nakedness, while her sister is still alive. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘You shall not approach a woman to uncover her nakedness, as long as she is impure by her uncleanness. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“‘You shall not lie carnally with your neighbour’s wife, and defile yourself with her. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“‘You shall not give any of your children as a sacrifice to Molech. You shall not profane the name of your God. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“‘You shall not lie with a man as with a woman. That is detestable. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“‘You shall not lie with any animal to defile yourself with it. No woman may give herself to an animal, to lie down with it: it is a perversion. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘Don’t defile yourselves in any of these things; for in all these the nations which I am casting out before you were defiled. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","The land was defiled. Therefore I punished its iniquity, and the land vomited out her inhabitants. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","You therefore shall keep my statutes and my ordinances, and shall not do any of these abominations; neither the native-born, nor the stranger who lives as a foreigner amongst you ");
INSERT INTO engwebpb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(for the men of the land that were before you had done all these abominations, and the land became defiled), ");
INSERT INTO engwebpb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","that the land not vomit you out also, when you defile it, as it vomited out the nation that was before you. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“‘For whoever shall do any of these abominations, even the souls that do them shall be cut off from amongst their people. ");
INSERT INTO engwebpb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Therefore you shall keep my requirements, that you do not practise any of these abominable customs which were practised before you, and that you do not defile yourselves with them. I am the LORD your God.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Speak to all the congregation of the children of Israel, and tell them, ‘You shall be holy; for I, the LORD your God, am holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘Each one of you shall respect his mother and his father. You shall keep my Sabbaths. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“‘Don’t turn to idols, nor make molten gods for yourselves. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘When you offer a sacrifice of peace offerings to the LORD, you shall offer it so that you may be accepted. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","It shall be eaten the same day you offer it, and on the next day. If anything remains until the third day, it shall be burnt with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If it is eaten at all on the third day, it is an abomination. It will not be accepted; ");
INSERT INTO engwebpb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","but everyone who eats it shall bear his iniquity, because he has profaned the holy thing of the LORD, and that soul shall be cut off from his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘When you reap the harvest of your land, you shall not wholly reap the corners of your field, neither shall you gather the gleanings of your harvest. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","You shall not glean your vineyard, neither shall you gather the fallen grapes of your vineyard. You shall leave them for the poor and for the foreigner. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘You shall not steal. “‘You shall not lie. “‘You shall not deceive one another. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“‘You shall not swear by my name falsely, and profane the name of your God. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘You shall not oppress your neighbour, nor rob him. “‘The wages of a hired servant shall not remain with you all night until the morning. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“‘You shall not curse the deaf, nor put a stumbling block before the blind; but you shall fear your God. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘You shall do no injustice in judgement. You shall not be partial to the poor, nor show favouritism to the great; but you shall judge your neighbour in righteousness. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“‘You shall not go around as a slanderer amongst your people. “‘You shall not endanger the life of your neighbour. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘You shall not hate your brother in your heart. You shall surely rebuke your neighbour, and not bear sin because of him. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“‘You shall not take vengeance, nor bear any grudge against the children of your people; but you shall love your neighbour as yourself. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘You shall keep my statutes. “‘You shall not cross-breed different kinds of animals. “‘You shall not sow your field with two kinds of seed; “‘Don’t wear a garment made of two kinds of material. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘If a man lies carnally with a woman who is a slave girl, pledged to be married to another man, and not ransomed or given her freedom; they shall be punished. They shall not be put to death, because she was not free. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","He shall bring his trespass offering to the LORD, to the door of the Tent of Meeting, even a ram for a trespass offering. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","The priest shall make atonement for him with the ram of the trespass offering before the LORD for his sin which he has committed; and the sin which he has committed shall be forgiven him. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘When you come into the land, and have planted all kinds of trees for food, then you shall count their fruit as forbidden. For three years it shall be forbidden to you. It shall not be eaten. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","But in the fourth year all its fruit shall be holy, for giving praise to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","In the fifth year you shall eat its fruit, that it may yield its increase to you. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘You shall not eat any meat with the blood still in it. You shall not use enchantments, nor practise sorcery. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“‘You shall not cut the hair on the sides of your head or clip off the edge of your beard. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“‘You shall not make any cuttings in your flesh for the dead, nor tattoo any marks on you. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“‘Don’t profane your daughter, to make her a prostitute; lest the land fall to prostitution, and the land become full of wickedness. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘You shall keep my Sabbaths, and reverence my sanctuary; I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘Don’t turn to those who are mediums, nor to the wizards. Don’t seek them out, to be defiled by them. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘You shall rise up before the grey head and honour the face of the elderly; and you shall fear your God. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘If a stranger lives as a foreigner with you in your land, you shall not do him wrong. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","The stranger who lives as a foreigner with you shall be to you as the native-born amongst you, and you shall love him as yourself; for you lived as foreigners in the land of Egypt. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“‘You shall do no unrighteousness in judgement, in measures of length, of weight, or of quantity. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","You shall have just balances, just weights, a just ephah, and a just hin. I am the LORD your God, who brought you out of the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“‘You shall observe all my statutes and all my ordinances, and do them. I am the LORD.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Moreover, you shall tell the children of Israel, ‘Anyone of the children of Israel, or of the strangers who live as foreigners in Israel, who gives any of his offspring to Molech shall surely be put to death. The people of the land shall stone that person with stones. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I also will set my face against that person, and will cut him off from amongst his people, because he has given of his offspring to Molech, to defile my sanctuary, and to profane my holy name. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","If the people of the land all hide their eyes from that person when he gives of his offspring to Molech, and don’t put him to death, ");
INSERT INTO engwebpb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","then I will set my face against that man and against his family, and will cut him off, and all who play the prostitute after him to play the prostitute with Molech, from amongst their people. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘The person that turns to those who are mediums and wizards, to play the prostitute after them, I will even set my face against that person, and will cut him off from amongst his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“‘Sanctify yourselves therefore, and be holy; for I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","You shall keep my statutes, and do them. I am the LORD who sanctifies you. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘For everyone who curses his father or his mother shall surely be put to death. He has cursed his father or his mother. His blood shall be upon himself. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“‘The man who commits adultery with another man’s wife, even he who commits adultery with his neighbour’s wife, the adulterer and the adulteress shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“‘The man who lies with his father’s wife has uncovered his father’s nakedness. Both of them shall surely be put to death. Their blood shall be upon themselves. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“‘If a man lies with his daughter-in-law, both of them shall surely be put to death. They have committed a perversion. Their blood shall be upon themselves. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“‘If a man lies with a male, as with a woman, both of them have committed an abomination. They shall surely be put to death. Their blood shall be upon themselves. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“‘If a man takes a wife and her mother, it is wickedness. They shall be burnt with fire, both he and they, that there may be no wickedness amongst you. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“‘If a man lies with an animal, he shall surely be put to death; and you shall kill the animal. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“‘If a woman approaches any animal and lies with it, you shall kill the woman and the animal. They shall surely be put to death. Their blood shall be upon them. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“‘If a man takes his sister—his father’s daughter, or his mother’s daughter—and sees her nakedness, and she sees his nakedness, it is a shameful thing. They shall be cut off in the sight of the children of their people. He has uncovered his sister’s nakedness. He shall bear his iniquity. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“‘If a man lies with a woman having her monthly period, and uncovers her nakedness, he has made her fountain naked, and she has uncovered the fountain of her blood. Both of them shall be cut off from amongst their people. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“‘You shall not uncover the nakedness of your mother’s sister, nor of your father’s sister, for he has made his close relative naked. They shall bear their iniquity. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","If a man lies with his uncle’s wife, he has uncovered his uncle’s nakedness. They shall bear their sin. They shall die childless. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“‘If a man takes his brother’s wife, it is an impurity. He has uncovered his brother’s nakedness. They shall be childless. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘You shall therefore keep all my statutes and all my ordinances, and do them, that the land where I am bringing you to dwell may not vomit you out. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","You shall not walk in the customs of the nation which I am casting out before you; for they did all these things, and therefore I abhorred them. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have said to you, “You shall inherit their land, and I will give it to you to possess it, a land flowing with milk and honey.” I am the LORD your God, who has separated you from the peoples. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“‘You shall therefore make a distinction between the clean animal and the unclean, and between the unclean fowl and the clean. You shall not make yourselves abominable by animal, or by bird, or by anything with which the ground teems, which I have separated from you as unclean for you. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","You shall be holy to me, for I, the LORD, am holy, and have set you apart from the peoples, that you should be mine. ");
INSERT INTO engwebpb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘A man or a woman that is a medium or is a wizard shall surely be put to death. They shall be stoned with stones. Their blood shall be upon themselves.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","The LORD said to Moses, “Speak to the priests, the sons of Aaron, and say to them, ‘A priest shall not defile himself for the dead amongst his people, ");
INSERT INTO engwebpb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","except for his relatives that are near to him: for his mother, for his father, for his son, for his daughter, for his brother, ");
INSERT INTO engwebpb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","and for his virgin sister who is near to him, who has had no husband; for her he may defile himself. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","He shall not defile himself, being a chief man amongst his people, to profane himself. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“‘They shall not shave their heads or shave off the corners of their beards or make any cuttings in their flesh. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","They shall be holy to their God, and not profane the name of their God, for they offer the offerings of the LORD made by fire, the bread of their God. Therefore they shall be holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘They shall not marry a woman who is a prostitute, or profane. A priest shall not marry a woman divorced from her husband; for he is holy to his God. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Therefore you shall sanctify him, for he offers the bread of your God. He shall be holy to you, for I the LORD, who sanctify you, am holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“‘The daughter of any priest, if she profanes herself by playing the prostitute, she profanes her father. She shall be burnt with fire. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘He who is the high priest amongst his brothers, upon whose head the anointing oil is poured, and who is consecrated to put on the garments, shall not let the hair of his head hang loose, or tear his clothes. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He must not go in to any dead body, or defile himself for his father or for his mother. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","He shall not go out of the sanctuary, nor profane the sanctuary of his God; for the crown of the anointing oil of his God is upon him. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“‘He shall take a wife in her virginity. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He shall not marry a widow, or one divorced, or a woman who has been defiled, or a prostitute. He shall take a virgin of his own people as a wife. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","He shall not profane his offspring amongst his people, for I am the LORD who sanctifies him.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Say to Aaron, ‘None of your offspring throughout their generations who has a defect may approach to offer the bread of his God. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","For whatever man he is that has a defect, he shall not draw near: a blind man, or a lame, or he who has a flat nose, or any deformity, ");
INSERT INTO engwebpb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","or a man who has an injured foot, or an injured hand, ");
INSERT INTO engwebpb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","or hunchbacked, or a dwarf, or one who has a defect in his eye, or an itching disease, or scabs, or who has damaged testicles. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No man of the offspring of Aaron the priest who has a defect shall come near to offer the offerings of the LORD made by fire. Since he has a defect, he shall not come near to offer the bread of his God. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He shall eat the bread of his God, both of the most holy, and of the holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","He shall not come near to the veil, nor come near to the altar, because he has a defect; that he may not profane my sanctuaries, for I am the LORD who sanctifies them.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","So Moses spoke to Aaron, and to his sons, and to all the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tell Aaron and his sons to separate themselves from the holy things of the children of Israel, which they make holy to me, and that they not profane my holy name. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Tell them, ‘If anyone of all your offspring throughout your generations approaches the holy things which the children of Israel make holy to the LORD, having his uncleanness on him, that soul shall be cut off from before me. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“‘Whoever of the offspring of Aaron is a leper or has a discharge shall not eat of the holy things until he is clean. Whoever touches anything that is unclean by the dead, or a man who has a seminal emission, ");
INSERT INTO engwebpb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or whoever touches any creeping thing by which he may be made unclean, or a man from whom he may become unclean, whatever uncleanness he has— ");
INSERT INTO engwebpb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","the person that touches any such shall be unclean until the evening, and shall not eat of the holy things unless he bathes his body in water. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","When the sun is down, he shall be clean; and afterward he shall eat of the holy things, because it is his bread. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He shall not eat that which dies of itself or is torn by animals, defiling himself by it. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“‘They shall therefore follow my commandment, lest they bear sin for it and die in it, if they profane it. I am the LORD who sanctifies them. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘No stranger shall eat of the holy thing: a foreigner living with the priests, or a hired servant, shall not eat of the holy thing. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if a priest buys a slave, purchased by his money, he shall eat of it; and those who are born in his house shall eat of his bread. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If a priest’s daughter is married to an outsider, she shall not eat of the heave offering of the holy things. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if a priest’s daughter is a widow, or divorced, and has no child, and has returned to her father’s house as in her youth, she may eat of her father’s bread; but no stranger shall eat any of it. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“‘If a man eats something holy unwittingly, then he shall add the fifth part of its value to it, and shall give the holy thing to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","The priests shall not profane the holy things of the children of Israel, which they offer to the LORD, ");
INSERT INTO engwebpb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","and so cause them to bear the iniquity that brings guilt when they eat their holy things; for I am the LORD who sanctifies them.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Speak to Aaron, and to his sons, and to all the children of Israel, and say to them, ‘Whoever is of the house of Israel, or of the foreigners in Israel, who offers his offering, whether it is any of their vows or any of their free will offerings, which they offer to the LORD for a burnt offering: ");
INSERT INTO engwebpb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","that you may be accepted, you shall offer a male without defect, of the bulls, of the sheep, or of the goats. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","But you shall not offer whatever has a defect, for it shall not be acceptable for you. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Whoever offers a sacrifice of peace offerings to the LORD to accomplish a vow, or for a free will offering of the herd or of the flock, it shall be perfect to be accepted. It shall have no defect. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","You shall not offer what is blind, is injured, is maimed, has a wart, is festering, or has a running sore to the LORD, nor make an offering by fire of them on the altar to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Either a bull or a lamb that has any deformity or lacking in his parts, that you may offer for a free will offering; but for a vow it shall not be accepted. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","You must not offer to the LORD that which has its testicles bruised, crushed, broken, or cut. You must not do this in your land. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","You must not offer any of these as the bread of your God from the hand of a foreigner, because their corruption is in them. There is a defect in them. They shall not be accepted for you.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When a bull, a sheep, or a goat is born, it shall remain seven days with its mother. From the eighth day on it shall be accepted for the offering of an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Whether it is a cow or ewe, you shall not kill it and its young both in one day. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“When you sacrifice a sacrifice of thanksgiving to the LORD, you shall sacrifice it so that you may be accepted. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","It shall be eaten on the same day; you shall leave none of it until the morning. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Therefore you shall keep my commandments, and do them. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","You shall not profane my holy name, but I will be made holy amongst the children of Israel. I am the LORD who makes you holy, ");
INSERT INTO engwebpb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","who brought you out of the land of Egypt, to be your God. I am the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Speak to the children of Israel, and tell them, ‘The set feasts of the LORD, which you shall proclaim to be holy convocations, even these are my set feasts. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘Six days shall work be done, but on the seventh day is a Sabbath of solemn rest, a holy convocation; you shall do no kind of work. It is a Sabbath to the LORD in all your dwellings. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘These are the set feasts of the LORD, even holy convocations, which you shall proclaim in their appointed season. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In the first month, on the fourteenth day of the month in the evening, is the LORD’s Passover. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","On the fifteenth day of the same month is the feast of unleavened bread to the LORD. Seven days you shall eat unleavened bread. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","In the first day you shall have a holy convocation. You shall do no regular work. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","But you shall offer an offering made by fire to the LORD seven days. In the seventh day is a holy convocation. You shall do no regular work.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Speak to the children of Israel, and tell them, ‘When you have come into the land which I give to you, and shall reap its harvest, then you shall bring the sheaf of the first fruits of your harvest to the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","He shall wave the sheaf before the LORD, to be accepted for you. On the next day after the Sabbath the priest shall wave it. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","On the day when you wave the sheaf, you shall offer a male lamb without defect a year old for a burnt offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","The meal offering with it shall be two tenths of an ephah of fine flour mixed with oil, an offering made by fire to the LORD for a pleasant aroma; and the drink offering with it shall be of wine, the fourth part of a hin. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","You must not eat bread, or roasted grain, or fresh grain, until this same day, until you have brought the offering of your God. This is a statute forever throughout your generations in all your dwellings. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘You shall count from the next day after the Sabbath, from the day that you brought the sheaf of the wave offering: seven Sabbaths shall be completed. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","The next day after the seventh Sabbath you shall count fifty days; and you shall offer a new meal offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","You shall bring out of your habitations two loaves of bread for a wave offering made of two tenths of an ephah of fine flour. They shall be baked with yeast, for first fruits to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","You shall present with the bread seven lambs without defect a year old, one young bull, and two rams. They shall be a burnt offering to the LORD, with their meal offering and their drink offerings, even an offering made by fire, of a sweet aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","You shall offer one male goat for a sin offering, and two male lambs a year old for a sacrifice of peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","The priest shall wave them with the bread of the first fruits for a wave offering before the LORD, with the two lambs. They shall be holy to the LORD for the priest. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","You shall make proclamation on the same day that there shall be a holy convocation to you. You shall do no regular work. This is a statute forever in all your dwellings throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘When you reap the harvest of your land, you must not wholly reap into the corners of your field. You must not gather the gleanings of your harvest. You must leave them for the poor and for the foreigner. I am the LORD your God.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Speak to the children of Israel, saying, ‘In the seventh month, on the first day of the month, there shall be a solemn rest for you, a memorial of blowing of trumpets, a holy convocation. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","You shall do no regular work. You shall offer an offering made by fire to the LORD.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“However on the tenth day of this seventh month is the day of atonement. It shall be a holy convocation to you. You shall afflict yourselves and you shall offer an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","You shall do no kind of work in that same day, for it is a day of atonement, to make atonement for you before the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","For whoever it is who shall not deny himself in that same day shall be cut off from his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Whoever does any kind of work in that same day, I will destroy that person from amongst his people. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You shall do no kind of work: it is a statute forever throughout your generations in all your dwellings. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It shall be a Sabbath of solemn rest for you, and you shall deny yourselves. In the ninth day of the month at evening, from evening to evening, you shall keep your Sabbath.” ");
INSERT INTO engwebpb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Speak to the children of Israel, and say, ‘On the fifteenth day of this seventh month is the feast of booths for seven days to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day shall be a holy convocation. You shall do no regular work. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Seven days you shall offer an offering made by fire to the LORD. On the eighth day shall be a holy convocation to you. You shall offer an offering made by fire to the LORD. It is a solemn assembly; you shall do no regular work. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘These are the appointed feasts of the LORD which you shall proclaim to be holy convocations, to offer an offering made by fire to the LORD, a burnt offering, a meal offering, a sacrifice, and drink offerings, each on its own day— ");
INSERT INTO engwebpb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","in addition to the Sabbaths of the LORD, and in addition to your gifts, and in addition to all your vows, and in addition to all your free will offerings, which you give to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘So on the fifteenth day of the seventh month, when you have gathered in the fruits of the land, you shall keep the feast of the LORD seven days. On the first day shall be a solemn rest, and on the eighth day shall be a solemn rest. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","You shall take on the first day the fruit of majestic trees, branches of palm trees, and boughs of thick trees, and willows of the brook; and you shall rejoice before the LORD your God seven days. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","You shall keep it as a feast to the LORD seven days in the year. It is a statute forever throughout your generations. You shall keep it in the seventh month. ");
INSERT INTO engwebpb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","You shall dwell in temporary shelters for seven days. All who are native-born in Israel shall dwell in temporary shelters, ");
INSERT INTO engwebpb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","that your generations may know that I made the children of Israel to dwell in temporary shelters when I brought them out of the land of Egypt. I am the LORD your God.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","So Moses declared to the children of Israel the appointed feasts of the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Command the children of Israel, that they bring to you pure olive oil beaten for the light, to cause a lamp to burn continually. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside of the veil of the Testimony, in the Tent of Meeting, Aaron shall keep it in order from evening to morning before the LORD continually. It shall be a statute forever throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","He shall keep in order the lamps on the pure gold lamp stand before the LORD continually. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“You shall take fine flour, and bake twelve cakes of it: two tenths of an ephah shall be in one cake. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","You shall set them in two rows, six on a row, on the pure gold table before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","You shall put pure frankincense on each row, that it may be to the bread for a memorial, even an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Every Sabbath day he shall set it in order before the LORD continually. It is an everlasting covenant on the behalf of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","It shall be for Aaron and his sons. They shall eat it in a holy place; for it is most holy to him of the offerings of the LORD made by fire by a perpetual statute.” ");
INSERT INTO engwebpb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","The son of an Israelite woman, whose father was an Egyptian, went out amongst the children of Israel; and the son of the Israelite woman and a man of Israel strove together in the camp. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","The son of the Israelite woman blasphemed the Name, and cursed; and they brought him to Moses. His mother’s name was Shelomith, the daughter of Dibri, of the tribe of Dan. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","They put him in custody until the LORD’s will should be declared to them. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Bring him who cursed out of the camp; and let all who heard him lay their hands on his head, and let all the congregation stone him. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","You shall speak to the children of Israel, saying, ‘Whoever curses his God shall bear his sin. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","He who blasphemes the LORD’s name, he shall surely be put to death. All the congregation shall certainly stone him. The foreigner as well as the native-born shall be put to death when he blasphemes the Name. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘He who strikes any man mortally shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","He who strikes an animal mortally shall make it good, life for life. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","If anyone injures his neighbour, it shall be done to him as he has done: ");
INSERT INTO engwebpb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture for fracture, eye for eye, tooth for tooth. It shall be done to him as he has injured someone. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","He who kills an animal shall make it good; and he who kills a man shall be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","You shall have one kind of law for the foreigner as well as the native-born; for I am the LORD your God.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moses spoke to the children of Israel; and they brought him who had cursed out of the camp, and stoned him with stones. The children of Israel did as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","The LORD said to Moses on Mount Sinai, ");
INSERT INTO engwebpb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Speak to the children of Israel, and tell them, ‘When you come into the land which I give you, then the land shall keep a Sabbath to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","You shall sow your field six years, and you shall prune your vineyard six years, and gather in its fruits; ");
INSERT INTO engwebpb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","but in the seventh year there shall be a Sabbath of solemn rest for the land, a Sabbath to the LORD. You shall not sow your field or prune your vineyard. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","What grows of itself in your harvest you shall not reap, and you shall not gather the grapes of your undressed vine. It shall be a year of solemn rest for the land. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","The Sabbath of the land shall be for food for you; for yourself, for your servant, for your maid, for your hired servant, and for your stranger, who lives as a foreigner with you. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","For your livestock also, and for the animals that are in your land, shall all its increase be for food. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘You shall count off seven Sabbaths of years, seven times seven years; and there shall be to you the days of seven Sabbaths of years, even forty-nine years. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Then you shall sound the loud trumpet on the tenth day of the seventh month. On the Day of Atonement you shall sound the trumpet throughout all your land. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","You shall make the fiftieth year holy, and proclaim liberty throughout the land to all its inhabitants. It shall be a jubilee to you; and each of you shall return to his own property, and each of you shall return to his family. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","That fiftieth year shall be a jubilee to you. In it you shall not sow, neither reap that which grows of itself, nor gather from the undressed vines. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","For it is a jubilee; it shall be holy to you. You shall eat of its increase out of the field. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘In this Year of Jubilee each of you shall return to his property. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“‘If you sell anything to your neighbour, or buy from your neighbour, you shall not wrong one another. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","According to the number of years after the Jubilee you shall buy from your neighbour. According to the number of years of the crops he shall sell to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","According to the length of the years you shall increase its price, and according to the shortness of the years you shall diminish its price; for he is selling the number of the crops to you. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","You shall not wrong one another, but you shall fear your God; for I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“‘Therefore you shall do my statutes, and keep my ordinances and do them; and you shall dwell in the land in safety. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","The land shall yield its fruit, and you shall eat your fill, and dwell therein in safety. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","If you said, “What shall we eat the seventh year? Behold, we shall not sow, nor gather in our increase;” ");
INSERT INTO engwebpb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","then I will command my blessing on you in the sixth year, and it shall bear fruit for the three years. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","You shall sow the eighth year, and eat of the fruits from the old store until the ninth year. Until its fruits come in, you shall eat the old store. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“‘The land shall not be sold in perpetuity, for the land is mine; for you are strangers and live as foreigners with me. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","In all the land of your possession you shall grant a redemption for the land. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“‘If your brother becomes poor, and sells some of his possessions, then his kinsman who is next to him shall come, and redeem that which his brother has sold. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","If a man has no one to redeem it, and he becomes prosperous and finds sufficient means to redeem it, ");
INSERT INTO engwebpb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","then let him reckon the years since its sale, and restore the surplus to the man to whom he sold it; and he shall return to his property. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if he isn’t able to get it back for himself, then what he has sold shall remain in the hand of him who has bought it until the Year of Jubilee. In the Jubilee it shall be released, and he shall return to his property. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“‘If a man sells a dwelling house in a walled city, then he may redeem it within a whole year after it has been sold. For a full year he shall have the right of redemption. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","If it isn’t redeemed within the space of a full year, then the house that is in the walled city shall be made sure in perpetuity to him who bought it, throughout his generations. It shall not be released in the Jubilee. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But the houses of the villages which have no wall around them shall be accounted for with the fields of the country: they may be redeemed, and they shall be released in the Jubilee. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“‘Nevertheless, in the cities of the Levites, the Levites may redeem the houses in the cities of their possession at any time. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","The Levites may redeem the house that was sold, and the city of his possession, and it shall be released in the Jubilee; for the houses of the cities of the Levites are their possession amongst the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But the field of the pasture lands of their cities may not be sold, for it is their perpetual possession. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“‘If your brother has become poor, and his hand can’t support himself amongst you, then you shall uphold him. He shall live with you like an alien and a temporary resident. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Take no interest from him or profit; but fear your God, that your brother may live amongst you. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","You shall not lend him your money at interest, nor give him your food for profit. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am the LORD your God, who brought you out of the land of Egypt, to give you the land of Canaan, and to be your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“‘If your brother has grown poor amongst you, and sells himself to you, you shall not make him to serve as a slave. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","As a hired servant, and as a temporary resident, he shall be with you; he shall serve with you until the Year of Jubilee. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then he shall go out from you, he and his children with him, and shall return to his own family, and to the possession of his fathers. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","For they are my servants, whom I brought out of the land of Egypt. They shall not be sold as slaves. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","You shall not rule over him with harshness, but shall fear your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“‘As for your male and your female slaves, whom you may have from the nations that are around you, from them you may buy male and female slaves. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Moreover, of the children of the aliens who live amongst you, of them you may buy, and of their families who are with you, which they have conceived in your land; and they will be your property. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","You may make them an inheritance for your children after you, to hold for a possession. Of them you may take your slaves forever, but over your brothers the children of Israel you shall not rule, one over another, with harshness. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“‘If an alien or temporary resident with you becomes rich, and your brother beside him has grown poor, and sells himself to the stranger or foreigner living amongst you, or to a member of the stranger’s family, ");
INSERT INTO engwebpb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","after he is sold he may be redeemed. One of his brothers may redeem him; ");
INSERT INTO engwebpb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","or his uncle, or his uncle’s son, may redeem him, or any who is a close relative to him of his family may redeem him; or if he has grown rich, he may redeem himself. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","He shall reckon with him who bought him from the year that he sold himself to him to the Year of Jubilee. The price of his sale shall be according to the number of years; he shall be with him according to the time of a hired servant. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there are yet many years, according to them he shall give back the price of his redemption out of the money that he was bought for. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","If there remain but a few years to the year of jubilee, then he shall reckon with him; according to his years of service he shall give back the price of his redemption. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","As a servant hired year by year shall he be with him. He shall not rule with harshness over him in your sight. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","If he isn’t redeemed by these means, then he shall be released in the Year of Jubilee: he and his children with him. ");
INSERT INTO engwebpb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For to me the children of Israel are servants; they are my servants whom I brought out of the land of Egypt. I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“‘You shall make for yourselves no idols, and you shall not raise up a carved image or a pillar, and you shall not place any figured stone in your land, to bow down to it; for I am the LORD your God. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“‘You shall keep my Sabbaths, and have reverence for my sanctuary. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“‘If you walk in my statutes and keep my commandments, and do them, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","then I will give you your rains in their season, and the land shall yield its increase, and the trees of the field shall yield their fruit. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Your threshing shall continue until the vintage, and the vintage shall continue until the sowing time. You shall eat your bread to the full, and dwell in your land safely. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“‘I will give peace in the land, and you shall lie down, and no one will make you afraid. I will remove evil animals out of the land, neither shall the sword go through your land. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","You shall chase your enemies, and they shall fall before you by the sword. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you shall chase a hundred, and a hundred of you shall chase ten thousand; and your enemies shall fall before you by the sword. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“‘I will have respect for you, make you fruitful, multiply you, and will establish my covenant with you. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","You shall eat old supplies long kept, and you shall move out the old because of the new. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","I will set my tent amongst you, and my soul won’t abhor you. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I will walk amongst you, and will be your God, and you will be my people. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the LORD your God, who brought you out of the land of Egypt, that you should not be their slaves. I have broken the bars of your yoke, and made you walk upright. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“‘But if you will not listen to me, and will not do all these commandments, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","and if you shall reject my statutes, and if your soul abhors my ordinances, so that you will not do all my commandments, but break my covenant, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","I also will do this to you: I will appoint terror over you, even consumption and fever, that shall consume the eyes, and make the soul to pine away. You will sow your seed in vain, for your enemies will eat it. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I will set my face against you, and you will be struck before your enemies. Those who hate you will rule over you; and you will flee when no one pursues you. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“‘If you in spite of these things will not listen to me, then I will chastise you seven times more for your sins. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I will break the pride of your power, and I will make your sky like iron, and your soil like bronze. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Your strength will be spent in vain; for your land won’t yield its increase, neither will the trees of the land yield their fruit. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“‘If you walk contrary to me, and won’t listen to me, then I will bring seven times more plagues on you according to your sins. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send the wild animals amongst you, which will rob you of your children, destroy your livestock, and make you few in number. Your roads will become desolate. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“‘If by these things you won’t be turned back to me, but will walk contrary to me, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","then I will also walk contrary to you; and I will strike you, even I, seven times for your sins. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I will bring a sword upon you that will execute the vengeance of the covenant. You will be gathered together within your cities, and I will send the pestilence amongst you. You will be delivered into the hand of the enemy. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I break your staff of bread, ten women shall bake your bread in one oven, and they shall deliver your bread again by weight. You shall eat, and not be satisfied. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“‘If you in spite of this won’t listen to me, but walk contrary to me, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","then I will walk contrary to you in wrath. I will also chastise you seven times for your sins. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will eat the flesh of your sons, and you will eat the flesh of your daughters. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will destroy your high places, and cut down your incense altars, and cast your dead bodies upon the bodies of your idols; and my soul will abhor you. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will lay your cities waste, and will bring your sanctuaries to desolation. I will not take delight in the sweet fragrance of your offerings. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I will bring the land into desolation, and your enemies who dwell in it will be astonished at it. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I will scatter you amongst the nations, and I will draw out the sword after you. Your land will be a desolation, and your cities shall be a waste. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Then the land will enjoy its Sabbaths as long as it lies desolate and you are in your enemies’ land. Even then the land will rest and enjoy its Sabbaths. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","As long as it lies desolate it shall have rest, even the rest which it didn’t have in your Sabbaths when you lived on it. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“‘As for those of you who are left, I will send a faintness into their hearts in the lands of their enemies. The sound of a driven leaf will put them to flight; and they shall flee, as one flees from the sword. They will fall when no one pursues. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","They will stumble over one another, as it were before the sword, when no one pursues. You will have no power to stand before your enemies. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","You will perish amongst the nations. The land of your enemies will eat you up. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Those of you who are left will pine away in their iniquity in your enemies’ lands; and also in the iniquities of their fathers they shall pine away with them. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“‘If they confess their iniquity and the iniquity of their fathers, in their trespass which they trespassed against me; and also that because they walked contrary to me, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","I also walked contrary to them, and brought them into the land of their enemies; if then their uncircumcised heart is humbled, and they then accept the punishment of their iniquity, ");
INSERT INTO engwebpb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","then I will remember my covenant with Jacob, my covenant with Isaac, and also my covenant with Abraham; and I will remember the land. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","The land also will be left by them, and will enjoy its Sabbaths while it lies desolate without them; and they will accept the punishment of their iniquity because they rejected my ordinances, and their soul abhorred my statutes. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Yet for all that, when they are in the land of their enemies, I will not reject them, neither will I abhor them, to destroy them utterly and to break my covenant with them; for I am the LORD their God. ");
INSERT INTO engwebpb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","But I will for their sake remember the covenant of their ancestors, whom I brought out of the land of Egypt in the sight of the nations, that I might be their God. I am the LORD.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the statutes, ordinances, and laws, which the LORD made between him and the children of Israel in Mount Sinai by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Speak to the children of Israel, and say to them, ‘When a man consecrates a person to the LORD in a vow, according to your valuation, ");
INSERT INTO engwebpb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","your valuation of a male from twenty years old to sixty years old shall be fifty shekels of silver, according to the shekel of the sanctuary. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","If she is a female, then your valuation shall be thirty shekels. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","If the person is from five years old to twenty years old, then your valuation shall be for a male twenty shekels, and for a female ten shekels. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","If the person is from a month old to five years old, then your valuation shall be for a male five shekels of silver, and for a female your valuation shall be three shekels of silver. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","If the person is from sixty years old and upward; if he is a male, then your valuation shall be fifteen shekels, and for a female ten shekels. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","But if he is poorer than your valuation, then he shall be set before the priest, and the priest shall assign a value to him. The priest shall assign a value according to his ability to pay. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘If it is an animal of which men offer an offering to the LORD, all that any man gives of such to the LORD becomes holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","He shall not alter it, nor exchange it, a good for a bad, or a bad for a good. If he shall at all exchange animal for animal, then both it and that for which it is exchanged shall be holy. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","If it is any unclean animal, of which they do not offer as an offering to the LORD, then he shall set the animal before the priest; ");
INSERT INTO engwebpb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","and the priest shall evaluate it, whether it is good or bad. As the priest evaluates it, so it shall be. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","But if he will indeed redeem it, then he shall add the fifth part of it to its valuation. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘When a man dedicates his house to be holy to the LORD, then the priest shall evaluate it, whether it is good or bad. As the priest evaluates it, so it shall stand. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","If he who dedicates it will redeem his house, then he shall add the fifth part of the money of your valuation to it, and it shall be his. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘If a man dedicates to the LORD part of the field of his possession, then your valuation shall be according to the seed for it. The sowing of a homer of barley shall be valued at fifty shekels of silver. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he dedicates his field from the Year of Jubilee, according to your valuation it shall stand. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he dedicates his field after the Jubilee, then the priest shall reckon to him the money according to the years that remain to the Year of Jubilee; and an abatement shall be made from your valuation. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","If he who dedicated the field will indeed redeem it, then he shall add the fifth part of the money of your valuation to it, and it shall remain his. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","If he will not redeem the field, or if he has sold the field to another man, it shall not be redeemed any more; ");
INSERT INTO engwebpb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","but the field, when it goes out in the Jubilee, shall be holy to the LORD, as a devoted field. It shall be owned by the priests. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘If he dedicates a field to the LORD which he has bought, which is not of the field of his possession, ");
INSERT INTO engwebpb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","then the priest shall reckon to him the worth of your valuation up to the Year of Jubilee; and he shall give your valuation on that day, as a holy thing to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the Year of Jubilee the field shall return to him from whom it was bought, even to him to whom the possession of the land belongs. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","All your valuations shall be according to the shekel of the sanctuary: twenty gerahs to the shekel. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘However the firstborn amongst animals, which belongs to the LORD as a firstborn, no man may dedicate, whether an ox or a sheep. It is the LORD’s. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","If it is an unclean animal, then he shall buy it back according to your valuation, and shall add to it the fifth part of it; or if it isn’t redeemed, then it shall be sold according to your valuation. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘Notwithstanding, no devoted thing that a man devotes to the LORD of all that he has, whether of man or animal, or of the field of his possession, shall be sold or redeemed. Everything that is permanently devoted is most holy to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“‘No one devoted to destruction, who shall be devoted from amongst men, shall be ransomed. He shall surely be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘All the tithe of the land, whether of the seed of the land or of the fruit of the trees, is the LORD’s. It is holy to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","If a man redeems anything of his tithe, he shall add a fifth part to it. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","All the tithe of the herds or the flocks, whatever passes under the rod, the tenth shall be holy to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","He shall not examine whether it is good or bad, neither shall he exchange it. If he exchanges it at all, then both it and that for which it is exchanged shall be holy. It shall not be redeemed.’” ");
INSERT INTO engwebpb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commandments which the LORD commanded Moses for the children of Israel on Mount Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","The LORD spoke to Moses in the wilderness of Sinai, in the Tent of Meeting, on the first day of the second month, in the second year after they had come out of the land of Egypt, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Take a census of all the congregation of the children of Israel, by their families, by their fathers’ houses, according to the number of the names, every male, one by one, ");
INSERT INTO engwebpb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","from twenty years old and upward, all who are able to go out to war in Israel. You and Aaron shall count them by their divisions. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","With you there shall be a man of every tribe, each one head of his fathers’ house. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","These are the names of the men who shall stand with you: Of Reuben: Elizur the son of Shedeur. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Of Simeon: Shelumiel the son of Zurishaddai. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Of Judah: Nahshon the son of Amminadab. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Of Issachar: Nethanel the son of Zuar. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Of Zebulun: Eliab the son of Helon. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Of the children of Joseph: of Ephraim: Elishama the son of Ammihud; of Manasseh: Gamaliel the son of Pedahzur. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Of Benjamin: Abidan the son of Gideoni. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Of Dan: Ahiezer the son of Ammishaddai. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Of Asher: Pagiel the son of Ochran. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Of Gad: Eliasaph the son of Deuel. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Of Naphtali: Ahira the son of Enan.” ");
INSERT INTO engwebpb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These are those who were called of the congregation, the princes of the tribes of their fathers; they were the heads of the thousands of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moses and Aaron took these men who are mentioned by name. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","They assembled all the congregation together on the first day of the second month; and they declared their ancestry by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, one by one. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","As the LORD commanded Moses, so he counted them in the wilderness of Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","The children of Reuben, Israel’s firstborn, their generations, by their families, by their fathers’ houses, according to the number of the names, one by one, every male from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","those who were counted of them, of the tribe of Reuben, were forty-six thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Of the children of Simeon, their generations, by their families, by their fathers’ houses, those who were counted of it, according to the number of the names, one by one, every male from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","those who were counted of them, of the tribe of Simeon, were fifty-nine thousand and three hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Of the children of Gad, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","those who were counted of them, of the tribe of Gad, were forty-five thousand and six hundred and fifty. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Of the children of Judah, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","those who were counted of them, of the tribe of Judah, were seventy-four thousand and six hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Of the children of Issachar, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","those who were counted of them, of the tribe of Issachar, were fifty-four thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Of the children of Zebulun, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","those who were counted of them, of the tribe of Zebulun, were fifty-seven thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Of the children of Joseph: of the children of Ephraim, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","those who were counted of them, of the tribe of Ephraim, were forty thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Of the children of Manasseh, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","those who were counted of them, of the tribe of Manasseh, were thirty-two thousand and two hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Of the children of Benjamin, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","those who were counted of them, of the tribe of Benjamin, were thirty-five thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Of the children of Dan, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","those who were counted of them, of the tribe of Dan, were sixty-two thousand and seven hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Of the children of Asher, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","those who were counted of them, of the tribe of Asher, were forty-one thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Of the children of Naphtali, their generations, by their families, by their fathers’ houses, according to the number of the names, from twenty years old and upward, all who were able to go out to war: ");
INSERT INTO engwebpb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","those who were counted of them, of the tribe of Naphtali, were fifty-three thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These are those who were counted, whom Moses and Aaron counted, and the twelve men who were princes of Israel, each one for his fathers’ house. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","So all those who were counted of the children of Israel by their fathers’ houses, from twenty years old and upward, all who were able to go out to war in Israel— ");
INSERT INTO engwebpb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","all those who were counted were six hundred and three thousand and five hundred and fifty. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But the Levites after the tribe of their fathers were not counted amongst them. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","For the LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Only the tribe of Levi you shall not count, neither shall you take a census of them amongst the children of Israel; ");
INSERT INTO engwebpb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","but appoint the Levites over the Tabernacle of the Testimony, and over all its furnishings, and over all that belongs to it. They shall carry the tabernacle and all its furnishings; and they shall take care of it, and shall encamp around it. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","When the tabernacle is to move, the Levites shall take it down; and when the tabernacle is to be set up, the Levites shall set it up. The stranger who comes near shall be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","The children of Israel shall pitch their tents, every man by his own camp, and every man by his own standard, according to their divisions. ");
INSERT INTO engwebpb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the Levites shall encamp around the Tabernacle of the Testimony, that there may be no wrath on the congregation of the children of Israel. The Levites shall be responsible for the Tabernacle of the Testimony.” ");
INSERT INTO engwebpb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Thus the children of Israel did. According to all that the LORD commanded Moses, so they did. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“The children of Israel shall encamp every man by his own standard, with the banners of their fathers’ houses. They shall encamp around the Tent of Meeting at a distance from it. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Those who encamp on the east side towards the sunrise shall be of the standard of the camp of Judah, according to their divisions. The prince of the children of Judah shall be Nahshon the son of Amminadab. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","His division, and those who were counted of them, were seventy-four thousand and six hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“Those who encamp next to him shall be the tribe of Issachar. The prince of the children of Issachar shall be Nethanel the son of Zuar. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","His division, and those who were counted of it, were fifty-four thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“The tribe of Zebulun: the prince of the children of Zebulun shall be Eliab the son of Helon. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","His division, and those who were counted of it, were fifty-seven thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“All who were counted of the camp of Judah were one hundred and eighty-six thousand and four hundred, according to their divisions. They shall set out first. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“On the south side shall be the standard of the camp of Reuben according to their divisions. The prince of the children of Reuben shall be Elizur the son of Shedeur. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","His division, and those who were counted of it, were forty-six thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“Those who encamp next to him shall be the tribe of Simeon. The prince of the children of Simeon shall be Shelumiel the son of Zurishaddai. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","His division, and those who were counted of them, were fifty-nine thousand and three hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“The tribe of Gad: the prince of the children of Gad shall be Eliasaph the son of Reuel. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","His division, and those who were counted of them, were forty-five thousand and six hundred and fifty. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“All who were counted of the camp of Reuben were one hundred and fifty-one thousand and four hundred and fifty, according to their armies. They shall set out second. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Then the Tent of Meeting shall set out, with the camp of the Levites in the middle of the camps. As they encamp, so shall they set out, every man in his place, by their standards. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“On the west side shall be the standard of the camp of Ephraim according to their divisions. The prince of the children of Ephraim shall be Elishama the son of Ammihud. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","His division, and those who were counted of them, were forty thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“Next to him shall be the tribe of Manasseh. The prince of the children of Manasseh shall be Gamaliel the son of Pedahzur. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","His division, and those who were counted of them, were thirty-two thousand and two hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“The tribe of Benjamin: the prince of the children of Benjamin shall be Abidan the son of Gideoni. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","His army, and those who were counted of them, were thirty-five thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“All who were counted of the camp of Ephraim were one hundred and eight thousand and one hundred, according to their divisions. They shall set out third. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“On the north side shall be the standard of the camp of Dan according to their divisions. The prince of the children of Dan shall be Ahiezer the son of Ammishaddai. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","His division, and those who were counted of them, were sixty-two thousand and seven hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“Those who encamp next to him shall be the tribe of Asher. The prince of the children of Asher shall be Pagiel the son of Ochran. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","His division, and those who were counted of them, were forty-one thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“The tribe of Naphtali: the prince of the children of Naphtali shall be Ahira the son of Enan. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","His division, and those who were counted of them, were fifty-three thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“All who were counted of the camp of Dan were one hundred and fifty-seven thousand and six hundred. They shall set out last by their standards.” ");
INSERT INTO engwebpb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are those who were counted of the children of Israel by their fathers’ houses. All who were counted of the camps according to their armies were six hundred and three thousand and five hundred and fifty. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But the Levites were not counted amongst the children of Israel, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Thus the children of Israel did. According to all that the LORD commanded Moses, so they encamped by their standards, and so they set out, everyone by their families, according to their fathers’ houses. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Now this is the history of the generations of Aaron and Moses in the day that the LORD spoke with Moses in Mount Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","These are the names of the sons of Aaron: Nadab the firstborn, and Abihu, Eleazar, and Ithamar. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These are the names of the sons of Aaron, the priests who were anointed, whom he consecrated to minister in the priest’s office. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab and Abihu died before the LORD when they offered strange fire before the LORD in the wilderness of Sinai, and they had no children. Eleazar and Ithamar ministered in the priest’s office in the presence of Aaron their father. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bring the tribe of Levi near, and set them before Aaron the priest, that they may minister to him. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","They shall keep his requirements, and the requirements of the whole congregation before the Tent of Meeting, to do the service of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","They shall keep all the furnishings of the Tent of Meeting, and the obligations of the children of Israel, to do the service of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","You shall give the Levites to Aaron and to his sons. They are wholly given to him on the behalf of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","You shall appoint Aaron and his sons, and they shall keep their priesthood, but the stranger who comes near shall be put to death.” ");
INSERT INTO engwebpb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Behold, I have taken the Levites from amongst the children of Israel instead of all the firstborn who open the womb amongst the children of Israel; and the Levites shall be mine, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","for all the firstborn are mine. On the day that I struck down all the firstborn in the land of Egypt I made holy to me all the firstborn in Israel, both man and animal. They shall be mine. I am the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","The LORD spoke to Moses in the wilderness of Sinai, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Count the children of Levi by their fathers’ houses, by their families. You shall count every male from a month old and upward.” ");
INSERT INTO engwebpb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moses counted them according to the LORD’s word, as he was commanded. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","These were the sons of Levi by their names: Gershon, Kohath, and Merari. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","These are the names of the sons of Gershon by their families: Libni and Shimei. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","The sons of Kohath by their families: Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","The sons of Merari by their families: Mahli and Mushi. These are the families of the Levites according to their fathers’ houses. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Of Gershon was the family of the Libnites, and the family of the Shimeites. These are the families of the Gershonites. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Those who were counted of them, according to the number of all the males from a month old and upward, even those who were counted of them were seven thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The families of the Gershonites shall encamp behind the tabernacle westward. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eliasaph the son of Lael shall be the prince of the fathers’ house of the Gershonites. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","The duty of the sons of Gershon in the Tent of Meeting shall be the tabernacle, the tent, its covering, the screen for the door of the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","the hangings of the court, the screen for the door of the court which is by the tabernacle and around the altar, and its cords for all of its service. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Of Kohath was the family of the Amramites, the family of the Izharites, the family of the Hebronites, and the family of the Uzzielites. These are the families of the Kohathites. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","According to the number of all the males from a month old and upward, there were eight thousand and six hundred keeping the requirements of the sanctuary. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The families of the sons of Kohath shall encamp on the south side of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","The prince of the fathers’ house of the families of the Kohathites shall be Elizaphan the son of Uzziel. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Their duty shall be the ark, the table, the lamp stand, the altars, the vessels of the sanctuary with which they minister, the screen, and all its service. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazar the son of Aaron the priest shall be prince of the princes of the Levites, with the oversight of those who keep the requirements of the sanctuary. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Of Merari was the family of the Mahlites and the family of the Mushites. These are the families of Merari. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Those who were counted of them, according to the number of all the males from a month old and upward, were six thousand and two hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","The prince of the fathers’ house of the families of Merari was Zuriel the son of Abihail. They shall encamp on the north side of the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","The appointed duty of the sons of Merari shall be the tabernacle’s boards, its bars, its pillars, its sockets, all its instruments, all its service, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","the pillars of the court around it, their sockets, their pins, and their cords. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Those who encamp before the tabernacle eastward, in front of the Tent of Meeting towards the sunrise, shall be Moses, with Aaron and his sons, keeping the requirements of the sanctuary for the duty of the children of Israel. The outsider who comes near shall be put to death. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","All who were counted of the Levites, whom Moses and Aaron counted at the commandment of the LORD, by their families, all the males from a month old and upward, were twenty-two thousand. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","The LORD said to Moses, “Count all the firstborn males of the children of Israel from a month old and upward, and take the number of their names. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","You shall take the Levites for me—I am the LORD—instead of all the firstborn amongst the children of Israel; and the livestock of the Levites instead of all the firstborn amongst the livestock of the children of Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moses counted, as the LORD commanded him, all the firstborn amongst the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","All the firstborn males according to the number of names from a month old and upward, of those who were counted of them, were twenty-two thousand and two hundred and seventy-three. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Take the Levites instead of all the firstborn amongst the children of Israel, and the livestock of the Levites instead of their livestock; and the Levites shall be mine. I am the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","For the redemption of the two hundred and seventy-three of the firstborn of the children of Israel who exceed the number of the Levites, ");
INSERT INTO engwebpb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","you shall take five shekels apiece for each one; according to the shekel of the sanctuary you shall take them (the shekel is twenty gerahs); ");
INSERT INTO engwebpb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","and you shall give the money, with which their remainder is redeemed, to Aaron and to his sons.” ");
INSERT INTO engwebpb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moses took the redemption money from those who exceeded the number of those who were redeemed by the Levites; ");
INSERT INTO engwebpb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","from the firstborn of the children of Israel he took the money, one thousand and three hundred and sixty-five shekels, according to the shekel of the sanctuary; ");
INSERT INTO engwebpb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","and Moses gave the redemption money to Aaron and to his sons, according to the LORD’s word, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Take a census of the sons of Kohath from amongst the sons of Levi, by their families, by their fathers’ houses, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","from thirty years old and upward even until fifty years old, all who enter into the service to do the work in the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“This is the service of the sons of Kohath in the Tent of Meeting, regarding the most holy things. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","When the camp moves forward, Aaron shall go in with his sons; and they shall take down the veil of the screen, cover the ark of the Testimony with it, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","put a covering of sealskin on it, spread a blue cloth over it, and put in its poles. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“On the table of show bread they shall spread a blue cloth, and put on it the dishes, the spoons, the bowls, and the cups with which to pour out; and the continual bread shall be on it. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","They shall spread on them a scarlet cloth, and cover it with a covering of sealskin, and shall put in its poles. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“They shall take a blue cloth and cover the lamp stand of the light, its lamps, its snuffers, its snuff dishes, and all its oil vessels, with which they minister to it. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","They shall put it and all its vessels within a covering of sealskin, and shall put it on the frame. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“On the golden altar they shall spread a blue cloth, and cover it with a covering of sealskin, and shall put in its poles. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“They shall take all the vessels of ministry with which they minister in the sanctuary, and put them in a blue cloth, cover them with a covering of sealskin, and shall put them on the frame. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“They shall take away the ashes from the altar, and spread a purple cloth on it. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","They shall put on it all its vessels with which they minister about it, the fire pans, the meat hooks, the shovels, and the basins—all the vessels of the altar; and they shall spread on it a covering of sealskin, and put in its poles. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“When Aaron and his sons have finished covering the sanctuary and all the furniture of the sanctuary, as the camp moves forward; after that, the sons of Kohath shall come to carry it; but they shall not touch the sanctuary, lest they die. The sons of Kohath shall carry these things belonging to the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“The duty of Eleazar the son of Aaron the priest shall be the oil for the light, the sweet incense, the continual meal offering, and the anointing oil, the requirements of all the tabernacle, and of all that is in it, the sanctuary, and its furnishings.” ");
INSERT INTO engwebpb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Don’t cut off the tribe of the families of the Kohathites from amongst the Levites; ");
INSERT INTO engwebpb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","but do this to them, that they may live, and not die, when they approach the most holy things: Aaron and his sons shall go in and appoint everyone to his service and to his burden; ");
INSERT INTO engwebpb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","but they shall not go in to see the sanctuary even for a moment, lest they die.” ");
INSERT INTO engwebpb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Take a census of the sons of Gershon also, by their fathers’ houses, by their families; ");
INSERT INTO engwebpb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","you shall count them from thirty years old and upward until fifty years old: all who enter in to wait on the service, to do the work in the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“This is the service of the families of the Gershonites, in serving and in bearing burdens: ");
INSERT INTO engwebpb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","they shall carry the curtains of the tabernacle and the Tent of Meeting, its covering, the covering of sealskin that is on it, the screen for the door of the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","the hangings of the court, the screen for the door of the gate of the court which is by the tabernacle and around the altar, their cords, and all the instruments of their service, and whatever shall be done with them. They shall serve in there. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","At the commandment of Aaron and his sons shall be all the service of the sons of the Gershonites, in all their burden and in all their service; and you shall appoint their duty to them in all their responsibilities. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the service of the families of the sons of the Gershonites in the Tent of Meeting. Their duty shall be under the hand of Ithamar the son of Aaron the priest. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“As for the sons of Merari, you shall count them by their families, by their fathers’ houses; ");
INSERT INTO engwebpb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","you shall count them from thirty years old and upward even to fifty years old—everyone who enters on the service, to do the work of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","This is the duty of their burden, according to all their service in the Tent of Meeting: the tabernacle’s boards, its bars, its pillars, its sockets, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","the pillars of the court around it, their sockets, their pins, their cords, with all their instruments, and with all their service. You shall appoint the instruments of the duty of their burden to them by name. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the service of the families of the sons of Merari, according to all their service in the Tent of Meeting, under the hand of Ithamar the son of Aaron the priest.” ");
INSERT INTO engwebpb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moses and Aaron and the princes of the congregation counted the sons of the Kohathites by their families, and by their fathers’ houses, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","from thirty years old and upward even to fifty years old, everyone who entered into the service for work in the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Those who were counted of them by their families were two thousand and seven hundred and fifty. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","These are those who were counted of the families of the Kohathites, all who served in the Tent of Meeting, whom Moses and Aaron counted according to the commandment of the LORD by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Those who were counted of the sons of Gershon, by their families, and by their fathers’ houses, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","from thirty years old and upward even to fifty years old—everyone who entered into the service for work in the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","even those who were counted of them, by their families, by their fathers’ houses, were two thousand and six hundred and thirty. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","These are those who were counted of the families of the sons of Gershon, all who served in the Tent of Meeting, whom Moses and Aaron counted according to the commandment of the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Those who were counted of the families of the sons of Merari, by their families, by their fathers’ houses, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","from thirty years old and upward even to fifty years old—everyone who entered into the service for work in the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","even those who were counted of them by their families, were three thousand and two hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","These are those who were counted of the families of the sons of Merari, whom Moses and Aaron counted according to the commandment of the LORD by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","All those who were counted of the Levites whom Moses and Aaron and the princes of Israel counted, by their families and by their fathers’ houses, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","from thirty years old and upward even to fifty years old, everyone who entered in to do the work of service and the work of bearing burdens in the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","even those who were counted of them, were eight thousand and five hundred and eighty. ");
INSERT INTO engwebpb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","According to the commandment of the LORD they were counted by Moses, everyone according to his service and according to his burden. Thus they were counted by him, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Command the children of Israel that they put out of the camp every leper, everyone who has a discharge, and whoever is unclean by a corpse. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","You shall put both male and female outside of the camp so that they don’t defile their camp, in the midst of which I dwell.” ");
INSERT INTO engwebpb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","The children of Israel did so, and put them outside of the camp; as the LORD spoke to Moses, so the children of Israel did. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Speak to the children of Israel: ‘When a man or woman commits any sin that men commit, so as to trespass against the LORD, and that soul is guilty, ");
INSERT INTO engwebpb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","then he shall confess his sin which he has done; and he shall make restitution for his guilt in full, add to it the fifth part of it, and give it to him in respect of whom he has been guilty. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the man has no kinsman to whom restitution may be made for the guilt, the restitution for guilt which is made to the LORD shall be the priest’s, in addition to the ram of the atonement, by which atonement shall be made for him. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Every heave offering of all the holy things of the children of Israel, which they present to the priest, shall be his. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Every man’s holy things shall be his; whatever any man gives the priest, it shall be his.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Speak to the children of Israel, and tell them: ‘If any man’s wife goes astray and is unfaithful to him, ");
INSERT INTO engwebpb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","and a man lies with her carnally, and it is hidden from the eyes of her husband and this is kept concealed, and she is defiled, there is no witness against her, and she isn’t taken in the act; ");
INSERT INTO engwebpb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","and the spirit of jealousy comes on him, and he is jealous of his wife and she is defiled; or if the spirit of jealousy comes on him, and he is jealous of his wife and she isn’t defiled; ");
INSERT INTO engwebpb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","then the man shall bring his wife to the priest, and shall bring her offering for her: one tenth of an ephah of barley meal. He shall pour no oil on it, nor put frankincense on it, for it is a meal offering of jealousy, a meal offering of memorial, bringing iniquity to memory. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","The priest shall bring her near, and set her before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","The priest shall take holy water in an earthen vessel; and the priest shall take some of the dust that is on the floor of the tabernacle and put it into the water. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","The priest shall set the woman before the LORD, and let the hair of the woman’s head go loose, and put the meal offering of memorial in her hands, which is the meal offering of jealousy. The priest shall have in his hand the water of bitterness that brings a curse. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","The priest shall cause her to take an oath and shall tell the woman, “If no man has lain with you, and if you haven’t gone aside to uncleanness, being under your husband’s authority, be free from this water of bitterness that brings a curse. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have gone astray, being under your husband’s authority, and if you are defiled, and some man has lain with you besides your husband—” ");
INSERT INTO engwebpb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","then the priest shall cause the woman to swear with the oath of cursing, and the priest shall tell the woman, “May the LORD make you a curse and an oath amongst your people, when the LORD allows your thigh to fall away, and your body to swell; ");
INSERT INTO engwebpb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","and this water that brings a curse will go into your bowels, and make your body swell, and your thigh fall away.” The woman shall say, “Amen, Amen.” ");
INSERT INTO engwebpb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“‘The priest shall write these curses in a book, and he shall wipe them into the water of bitterness. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","He shall make the woman drink the water of bitterness that causes the curse; and the water that causes the curse shall enter into her and become bitter. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","The priest shall take the meal offering of jealousy out of the woman’s hand, and shall wave the meal offering before the LORD, and bring it to the altar. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","The priest shall take a handful of the meal offering, as its memorial portion, and burn it on the altar, and afterward shall make the woman drink the water. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","When he has made her drink the water, then it shall happen, if she is defiled and has committed a trespass against her husband, that the water that causes the curse will enter into her and become bitter, and her body will swell, and her thigh will fall away; and the woman will be a curse amongst her people. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","If the woman isn’t defiled, but is clean; then she shall be free, and shall conceive offspring. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“‘This is the law of jealousy, when a wife, being under her husband, goes astray, and is defiled, ");
INSERT INTO engwebpb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when the spirit of jealousy comes on a man, and he is jealous of his wife; then he shall set the woman before the LORD, and the priest shall execute on her all this law. ");
INSERT INTO engwebpb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","The man shall be free from iniquity, and that woman shall bear her iniquity.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Speak to the children of Israel, and tell them: ‘When either man or woman shall make a special vow, the vow of a Nazirite, to separate himself to the LORD, ");
INSERT INTO engwebpb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","he shall separate himself from wine and strong drink. He shall drink no vinegar of wine, or vinegar of fermented drink, neither shall he drink any juice of grapes, nor eat fresh grapes or dried. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","All the days of his separation he shall eat nothing that is made of the grapevine, from the seeds even to the skins. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘All the days of his vow of separation no razor shall come on his head, until the days are fulfilled in which he separates himself to the LORD. He shall be holy. He shall let the locks of the hair of his head grow long. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘All the days that he separates himself to the LORD he shall not go near a dead body. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","He shall not make himself unclean for his father, or for his mother, for his brother, or for his sister, when they die, because his separation to God is on his head. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","All the days of his separation he is holy to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘If any man dies very suddenly beside him, and he defiles the head of his separation, then he shall shave his head in the day of his cleansing. On the seventh day he shall shave it. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","On the eighth day he shall bring two turtledoves or two young pigeons to the priest, to the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","The priest shall offer one for a sin offering, and the other for a burnt offering, and make atonement for him, because he sinned by reason of the dead, and shall make his head holy that same day. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","He shall separate to the LORD the days of his separation, and shall bring a male lamb a year old for a trespass offering; but the former days shall be void, because his separation was defiled. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘This is the law of the Nazirite: when the days of his separation are fulfilled, he shall be brought to the door of the Tent of Meeting, ");
INSERT INTO engwebpb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","and he shall offer his offering to the LORD: one male lamb a year old without defect for a burnt offering, one ewe lamb a year old without defect for a sin offering, one ram without defect for peace offerings, ");
INSERT INTO engwebpb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","a basket of unleavened bread, cakes of fine flour mixed with oil, and unleavened wafers anointed with oil with their meal offering and their drink offerings. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","The priest shall present them before the LORD, and shall offer his sin offering and his burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","He shall offer the ram for a sacrifice of peace offerings to the LORD, with the basket of unleavened bread. The priest shall offer also its meal offering and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","The Nazirite shall shave the head of his separation at the door of the Tent of Meeting, take the hair of the head of his separation, and put it on the fire which is under the sacrifice of peace offerings. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","The priest shall take the boiled shoulder of the ram, one unleavened cake out of the basket, and one unleavened wafer, and shall put them on the hands of the Nazirite after he has shaved the head of his separation; ");
INSERT INTO engwebpb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","and the priest shall wave them for a wave offering before the LORD. They are holy for the priest, together with the breast that is waved and the thigh that is offered. After that the Nazirite may drink wine. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘This is the law of the Nazirite who vows and of his offering to the LORD for his separation, in addition to that which he is able to afford. According to his vow which he vows, so he must do after the law of his separation.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Speak to Aaron and to his sons, saying, ‘This is how you shall bless the children of Israel.’ You shall tell them, ");
INSERT INTO engwebpb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘The LORD bless you, and keep you. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","The LORD make his face to shine on you, and be gracious to you. ");
INSERT INTO engwebpb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","The LORD lift up his face towards you, and give you peace.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“So they shall put my name on the children of Israel; and I will bless them.” ");
INSERT INTO engwebpb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","On the day that Moses had finished setting up the tabernacle, and had anointed it and sanctified it with all its furniture, and the altar with all its vessels, and had anointed and sanctified them; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","the princes of Israel, the heads of their fathers’ houses, gave offerings. These were the princes of the tribes. These are they who were over those who were counted; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","and they brought their offering before the LORD, six covered wagons and twelve oxen; a wagon for every two of the princes, and for each one an ox. They presented them before the tabernacle. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Accept these from them, that they may be used in doing the service of the Tent of Meeting; and you shall give them to the Levites, to every man according to his service.” ");
INSERT INTO engwebpb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moses took the wagons and the oxen, and gave them to the Levites. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He gave two wagons and four oxen to the sons of Gershon, according to their service. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","He gave four wagons and eight oxen to the sons of Merari, according to their service, under the direction of Ithamar the son of Aaron the priest. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But to the sons of Kohath he gave none, because the service of the sanctuary belonged to them; they carried it on their shoulders. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","The princes gave offerings for the dedication of the altar in the day that it was anointed. The princes gave their offerings before the altar. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","The LORD said to Moses, “They shall offer their offering, each prince on his day, for the dedication of the altar.” ");
INSERT INTO engwebpb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","He who offered his offering the first day was Nahshon the son of Amminadab, of the tribe of Judah, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","and his offering was: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Nahshon the son of Amminadab. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day Nethanel the son of Zuar, prince of Issachar, gave his offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He offered for his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, five male lambs a year old. This was the offering of Nethanel the son of Zuar. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day Eliab the son of Helon, prince of the children of Zebulun, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","gave his offering: one silver platter, the weight of which was a hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Eliab the son of Helon. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day Elizur the son of Shedeur, prince of the children of Reuben, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Elizur the son of Shedeur. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day Shelumiel the son of Zurishaddai, prince of the children of Simeon, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old: this was the offering of Shelumiel the son of Zurishaddai. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day, Eliasaph the son of Deuel, prince of the children of Gad, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Eliasaph the son of Deuel. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day Elishama the son of Ammihud, prince of the children of Ephraim, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Elishama the son of Ammihud. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day Gamaliel the son of Pedahzur, prince of the children of Manasseh, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Gamaliel the son of Pedahzur. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day Abidan the son of Gideoni, prince of the children of Benjamin, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Abidan the son of Gideoni. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day Ahiezer the son of Ammishaddai, prince of the children of Dan, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Ahiezer the son of Ammishaddai. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day Pagiel the son of Ochran, prince of the children of Asher, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Pagiel the son of Ochran. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day Ahira the son of Enan, prince of the children of Naphtali, ");
INSERT INTO engwebpb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","gave his offering: one silver platter, the weight of which was one hundred and thirty shekels, one silver bowl of seventy shekels, according to the shekel of the sanctuary, both of them full of fine flour mixed with oil for a meal offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","one golden ladle of ten shekels, full of incense; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","one young bull, one ram, one male lamb a year old, for a burnt offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","one male goat for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","and for the sacrifice of peace offerings, two head of cattle, five rams, five male goats, and five male lambs a year old. This was the offering of Ahira the son of Enan. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","This was the dedication offering of the altar, on the day when it was anointed, by the princes of Israel: twelve silver platters, twelve silver bowls, twelve golden ladles; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","each silver platter weighing one hundred and thirty shekels, and each bowl seventy; all the silver of the vessels two thousand and four hundred shekels, according to the shekel of the sanctuary; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","the twelve golden ladles, full of incense, weighing ten shekels apiece, according to the shekel of the sanctuary; all the gold of the ladles weighed one hundred and twenty shekels; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","all the cattle for the burnt offering twelve bulls, the rams twelve, the male lambs a year old twelve, and their meal offering; and twelve male goats for a sin offering; ");
INSERT INTO engwebpb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","and all the cattle for the sacrifice of peace offerings: twenty-four bulls, sixty rams, sixty male goats, and sixty male lambs a year old. This was the dedication offering of the altar, after it was anointed. ");
INSERT INTO engwebpb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","When Moses went into the Tent of Meeting to speak with the LORD, he heard his voice speaking to him from above the mercy seat that was on the ark of the Testimony, from between the two cherubim; and he spoke to him. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Speak to Aaron, and tell him, ‘When you light the lamps, the seven lamps shall give light in front of the lamp stand.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron did so. He lit its lamps to light the area in front of the lamp stand, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","This was the workmanship of the lamp stand, beaten work of gold. From its base to its flowers, it was beaten work. He made the lamp stand according to the pattern which the LORD had shown Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Take the Levites from amongst the children of Israel, and cleanse them. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","You shall do this to them to cleanse them: sprinkle the water of cleansing on them, let them shave their whole bodies with a razor, let them wash their clothes, and cleanse themselves. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then let them take a young bull and its meal offering, fine flour mixed with oil; and another young bull you shall take for a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","You shall present the Levites before the Tent of Meeting. You shall assemble the whole congregation of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","You shall present the Levites before the LORD. The children of Israel shall lay their hands on the Levites, ");
INSERT INTO engwebpb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","and Aaron shall offer the Levites before the LORD for a wave offering on the behalf of the children of Israel, that it may be theirs to do the service of the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“The Levites shall lay their hands on the heads of the bulls, and you shall offer the one for a sin offering and the other for a burnt offering to the LORD, to make atonement for the Levites. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","You shall set the Levites before Aaron and before his sons, and offer them as a wave offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Thus you shall separate the Levites from amongst the children of Israel, and the Levites shall be mine. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“After that, the Levites shall go in to do the service of the Tent of Meeting. You shall cleanse them, and offer them as a wave offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","For they are wholly given to me from amongst the children of Israel; instead of all who open the womb, even the firstborn of all the children of Israel, I have taken them to me. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","For all the firstborn amongst the children of Israel are mine, both man and animal. On the day that I struck all the firstborn in the land of Egypt, I sanctified them for myself. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","I have taken the Levites instead of all the firstborn amongst the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I have given the Levites as a gift to Aaron and to his sons from amongst the children of Israel, to do the service of the children of Israel in the Tent of Meeting, and to make atonement for the children of Israel, so that there will be no plague amongst the children of Israel when the children of Israel come near to the sanctuary.” ");
INSERT INTO engwebpb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moses, and Aaron, and all the congregation of the children of Israel did so to the Levites. According to all that the LORD commanded Moses concerning the Levites, so the children of Israel did to them. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The Levites purified themselves from sin, and they washed their clothes; and Aaron offered them for a wave offering before the LORD and Aaron made atonement for them to cleanse them. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","After that, the Levites went in to do their service in the Tent of Meeting before Aaron and before his sons: as the LORD had commanded Moses concerning the Levites, so they did to them. ");
INSERT INTO engwebpb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“This is what is assigned to the Levites: from twenty-five years old and upward they shall go in to wait on the service in the work of the Tent of Meeting; ");
INSERT INTO engwebpb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","and from the age of fifty years they shall retire from doing the work, and shall serve no more, ");
INSERT INTO engwebpb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","but shall assist their brothers in the Tent of Meeting, to perform the duty, and shall perform no service. This is how you shall have the Levites do their duties.” ");
INSERT INTO engwebpb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","The LORD spoke to Moses in the wilderness of Sinai, in the first month of the second year after they had come out of the land of Egypt, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Let the children of Israel keep the Passover in its appointed season. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","On the fourteenth day of this month, at evening, you shall keep it in its appointed season. You shall keep it according to all its statutes and according to all its ordinances.” ");
INSERT INTO engwebpb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moses told the children of Israel that they should keep the Passover. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","They kept the Passover in the first month, on the fourteenth day of the month at evening, in the wilderness of Sinai. According to all that the LORD commanded Moses, so the children of Israel did. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","There were certain men who were unclean because of the dead body of a man, so that they could not keep the Passover on that day, and they came before Moses and Aaron on that day. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Those men said to him, “We are unclean because of the dead body of a man. Why are we kept back, that we may not offer the offering of the LORD in its appointed season amongst the children of Israel?” ");
INSERT INTO engwebpb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses answered them, “Wait, that I may hear what the LORD will command concerning you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Say to the children of Israel, ‘If any man of you or of your generations is unclean by reason of a dead body, or is on a journey far away, he shall still keep the Passover to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","In the second month, on the fourteenth day at evening they shall keep it; they shall eat it with unleavened bread and bitter herbs. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","They shall leave none of it until the morning, nor break a bone of it. According to all the statute of the Passover they shall keep it. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But the man who is clean, and is not on a journey, and fails to keep the Passover, that soul shall be cut off from his people. Because he didn’t offer the offering of the LORD in its appointed season, that man shall bear his sin. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“‘If a foreigner lives amongst you and desires to keep the Passover to the LORD, then he shall do so according to the statute of the Passover, and according to its ordinance. You shall have one statute, both for the foreigner and for him who is born in the land.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","On the day that the tabernacle was raised up, the cloud covered the tabernacle, even the Tent of the Testimony. At evening it was over the tabernacle, as it were the appearance of fire, until morning. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","So it was continually. The cloud covered it, and the appearance of fire by night. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Whenever the cloud was taken up from over the Tent, then after that the children of Israel travelled; and in the place where the cloud remained, there the children of Israel encamped. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","At the commandment of the LORD, the children of Israel travelled, and at the commandment of the LORD they encamped. As long as the cloud remained on the tabernacle they remained encamped. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","When the cloud stayed on the tabernacle many days, then the children of Israel kept the LORD’s command, and didn’t travel. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud was a few days on the tabernacle; then according to the commandment of the LORD they remained encamped, and according to the commandment of the LORD they travelled. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sometimes the cloud was from evening until morning; and when the cloud was taken up in the morning, they travelled; or by day and by night, when the cloud was taken up, they travelled. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Whether it was two days, or a month, or a year that the cloud stayed on the tabernacle, remaining on it, the children of Israel remained encamped, and didn’t travel; but when it was taken up, they travelled. ");
INSERT INTO engwebpb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","At the commandment of the LORD they encamped, and at the commandment of the LORD they travelled. They kept the LORD’s command, at the commandment of the LORD by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Make two trumpets of silver. You shall make them of beaten work. You shall use them for the calling of the congregation and for the journeying of the camps. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","When they blow them, all the congregation shall gather themselves to you at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","If they blow just one, then the princes, the heads of the thousands of Israel, shall gather themselves to you. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When you blow an alarm, the camps that lie on the east side shall go forward. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","When you blow an alarm the second time, the camps that lie on the south side shall go forward. They shall blow an alarm for their journeys. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","But when the assembly is to be gathered together, you shall blow, but you shall not sound an alarm. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“The sons of Aaron, the priests, shall blow the trumpets. This shall be to you for a statute forever throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","When you go to war in your land against the adversary who oppresses you, then you shall sound an alarm with the trumpets. Then you will be remembered before the LORD your God, and you will be saved from your enemies. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Also in the day of your gladness, and in your set feasts, and in the beginnings of your months, you shall blow the trumpets over your burnt offerings, and over the sacrifices of your peace offerings; and they shall be to you for a memorial before your God. I am the LORD your God.” ");
INSERT INTO engwebpb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","In the second year, in the second month, on the twentieth day of the month, the cloud was taken up from over the tabernacle of the covenant. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","The children of Israel went forward on their journeys out of the wilderness of Sinai; and the cloud stayed in the wilderness of Paran. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","They first went forward according to the commandment of the LORD by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","First, the standard of the camp of the children of Judah went forward according to their armies. Nahshon the son of Amminadab was over his army. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethanel the son of Zuar was over the army of the tribe of the children of Issachar. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab the son of Helon was over the army of the tribe of the children of Zebulun. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","The tabernacle was taken down; and the sons of Gershon and the sons of Merari, who bore the tabernacle, went forward. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","The standard of the camp of Reuben went forward according to their armies. Elizur the son of Shedeur was over his army. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel the son of Zurishaddai was over the army of the tribe of the children of Simeon. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasaph the son of Deuel was over the army of the tribe of the children of Gad. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","The Kohathites set forward, bearing the sanctuary. The others set up the tabernacle before they arrived. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","The standard of the camp of the children of Ephraim set forward according to their armies. Elishama the son of Ammihud was over his army. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel the son of Pedahzur was over the army of the tribe of the children of Manasseh. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan the son of Gideoni was over the army of the tribe of the children of Benjamin. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","The standard of the camp of the children of Dan, which was the rear guard of all the camps, set forward according to their armies. Ahiezer the son of Ammishaddai was over his army. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel the son of Ochran was over the army of the tribe of the children of Asher. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira the son of Enan was over the army of the tribe of the children of Naphtali. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Thus were the travels of the children of Israel according to their armies; and they went forward. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moses said to Hobab, the son of Reuel the Midianite, Moses’ father-in-law, “We are journeying to the place of which the LORD said, ‘I will give it to you.’ Come with us, and we will treat you well; for the LORD has spoken good concerning Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","He said to him, “I will not go; but I will depart to my own land, and to my relatives.” ");
INSERT INTO engwebpb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moses said, “Don’t leave us, please; because you know how we are to encamp in the wilderness, and you can be our eyes. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","It shall be, if you go with us—yes, it shall be—that whatever good the LORD does to us, we will do the same to you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","They set forward from the Mount of the LORD three days’ journey. The ark of the LORD’s covenant went before them three days’ journey, to seek out a resting place for them. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","The cloud of the LORD was over them by day, when they set forward from the camp. ");
INSERT INTO engwebpb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","When the ark went forward, Moses said, “Rise up, LORD, and let your enemies be scattered! Let those who hate you flee before you!” ");
INSERT INTO engwebpb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","When it rested, he said, “Return, LORD, to the ten thousands of the thousands of Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","The people were complaining in the ears of the LORD. When the LORD heard it, his anger burnt; and the LORD’s fire burnt amongst them, and consumed some of the outskirts of the camp. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","The people cried to Moses; and Moses prayed to the LORD, and the fire abated. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","The name of that place was called Taberah, because the LORD’s fire burnt amongst them. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","The mixed multitude that was amongst them lusted exceedingly; and the children of Israel also wept again, and said, “Who will give us meat to eat? ");
INSERT INTO engwebpb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish, which we ate in Egypt for nothing; the cucumbers, and the melons, and the leeks, and the onions, and the garlic; ");
INSERT INTO engwebpb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","but now we have lost our appetite. There is nothing at all except this manna to look at.” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","The manna was like coriander seed, and it looked like bdellium. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","The people went around, gathered it, and ground it in mills, or beat it in mortars, and boiled it in pots, and made cakes of it. Its taste was like the taste of fresh oil. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","When the dew fell on the camp in the night, the manna fell on it. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses heard the people weeping throughout their families, every man at the door of his tent; and the LORD’s anger burnt greatly; and Moses was displeased. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moses said to the LORD, “Why have you treated your servant so badly? Why haven’t I found favour in your sight, that you lay the burden of all this people on me? ");
INSERT INTO engwebpb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Have I conceived all this people? Have I brought them out, that you should tell me, ‘Carry them in your bosom, as a nurse carries a nursing infant, to the land which you swore to their fathers’? ");
INSERT INTO engwebpb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where could I get meat to give all these people? For they weep before me, saying, ‘Give us meat, that we may eat.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I am not able to bear all this people alone, because it is too heavy for me. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","If you treat me this way, please kill me right now, if I have found favour in your sight; and don’t let me see my wretchedness.” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","The LORD said to Moses, “Gather to me seventy men of the elders of Israel, whom you know to be the elders of the people and officers over them; and bring them to the Tent of Meeting, that they may stand there with you. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","I will come down and talk with you there. I will take of the Spirit which is on you, and will put it on them; and they shall bear the burden of the people with you, that you don’t bear it yourself alone. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Say to the people, ‘Sanctify yourselves in preparation for tomorrow, and you will eat meat; for you have wept in the ears of the LORD, saying, “Who will give us meat to eat? For it was well with us in Egypt.” Therefore the LORD will give you meat, and you will eat. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You will not eat just one day, or two days, or five days, or ten days, or twenty days, ");
INSERT INTO engwebpb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","but a whole month, until it comes out at your nostrils, and it is loathsome to you; because you have rejected the LORD who is amongst you, and have wept before him, saying, “Why did we come out of Egypt?”’” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moses said, “The people, amongst whom I am, are six hundred thousand men on foot; and you have said, ‘I will give them meat, that they may eat a whole month.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Shall flocks and herds be slaughtered for them, to be sufficient for them? Shall all the fish of the sea be gathered together for them, to be sufficient for them?” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","The LORD said to Moses, “Has the LORD’s hand grown short? Now you will see whether my word will happen to you or not.” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moses went out, and told the people the LORD’s words; and he gathered seventy men of the elders of the people, and set them around the Tent. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","The LORD came down in the cloud, and spoke to him, and took of the Spirit that was on him, and put it on the seventy elders. When the Spirit rested on them, they prophesied, but they did so no more. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","But two men remained in the camp. The name of one was Eldad, and the name of the other Medad; and the Spirit rested on them. They were of those who were written, but had not gone out to the Tent; and they prophesied in the camp. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A young man ran, and told Moses, and said, “Eldad and Medad are prophesying in the camp!” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua the son of Nun, the servant of Moses, one of his chosen men, answered, “My lord Moses, forbid them!” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moses said to him, “Are you jealous for my sake? I wish that all the LORD’s people were prophets, that the LORD would put his Spirit on them!” ");
INSERT INTO engwebpb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moses went into the camp, he and the elders of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","A wind from the LORD went out and brought quails from the sea, and let them fall by the camp, about a day’s journey on this side, and a day’s journey on the other side, around the camp, and about two cubits above the surface of the earth. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","The people rose up all that day, and all of that night, and all the next day, and gathered the quails. He who gathered least gathered ten homers; and they spread them all out for themselves around the camp. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","While the meat was still between their teeth, before it was chewed, the LORD’s anger burnt against the people, and the LORD struck the people with a very great plague. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","The name of that place was called Kibroth Hattaavah, because there they buried the people who lusted. ");
INSERT INTO engwebpb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From Kibroth Hattaavah the people travelled to Hazeroth; and they stayed at Hazeroth. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam and Aaron spoke against Moses because of the Cushite woman whom he had married; for he had married a Cushite woman. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","They said, “Has the LORD indeed spoken only with Moses? Hasn’t he spoken also with us?” And the LORD heard it. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Now the man Moses was very humble, more than all the men who were on the surface of the earth. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","The LORD spoke suddenly to Moses, to Aaron, and to Miriam, “You three come out to the Tent of Meeting!” The three of them came out. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","The LORD came down in a pillar of cloud, and stood at the door of the Tent, and called Aaron and Miriam; and they both came forward. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","He said, “Now hear my words. If there is a prophet amongst you, I, the LORD, will make myself known to him in a vision. I will speak with him in a dream. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","My servant Moses is not so. He is faithful in all my house. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","With him, I will speak mouth to mouth, even plainly, and not in riddles; and he shall see the LORD’s form. Why then were you not afraid to speak against my servant, against Moses?” ");
INSERT INTO engwebpb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","The LORD’s anger burnt against them; and he departed. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","The cloud departed from over the Tent; and behold, Miriam was leprous, as white as snow. Aaron looked at Miriam, and behold, she was leprous. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaron said to Moses, “Oh, my lord, please don’t count this sin against us, in which we have done foolishly, and in which we have sinned. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Let her not, I pray, be as one dead, of whom the flesh is half consumed when he comes out of his mother’s womb.” ");
INSERT INTO engwebpb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moses cried to the LORD, saying, “Heal her, God, I beg you!” ");
INSERT INTO engwebpb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","The LORD said to Moses, “If her father had but spit in her face, shouldn’t she be ashamed seven days? Let her be shut up outside of the camp seven days, and after that she shall be brought in again.” ");
INSERT INTO engwebpb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam was shut up outside of the camp seven days, and the people didn’t travel until Miriam was brought in again. ");
INSERT INTO engwebpb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Afterward the people travelled from Hazeroth, and encamped in the wilderness of Paran. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send men, that they may spy out the land of Canaan, which I give to the children of Israel. Of every tribe of their fathers, you shall send a man, every one a prince amongst them.” ");
INSERT INTO engwebpb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moses sent them from the wilderness of Paran according to the commandment of the LORD. All of them were men who were heads of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","These were their names: Of the tribe of Reuben, Shammua the son of Zaccur. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Of the tribe of Simeon, Shaphat the son of Hori. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Of the tribe of Judah, Caleb the son of Jephunneh. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Of the tribe of Issachar, Igal the son of Joseph. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Of the tribe of Ephraim, Hoshea the son of Nun. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Of the tribe of Benjamin, Palti the son of Raphu. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Of the tribe of Zebulun, Gaddiel the son of Sodi. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Of the tribe of Joseph, of the tribe of Manasseh, Gaddi the son of Susi. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Of the tribe of Dan, Ammiel the son of Gemalli. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Of the tribe of Asher, Sethur the son of Michael. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Of the tribe of Naphtali, Nahbi the son of Vophsi. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Of the tribe of Gad, Geuel the son of Machi. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the names of the men who Moses sent to spy out the land. Moses called Hoshea the son of Nun Joshua. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses sent them to spy out the land of Canaan, and said to them, “Go up this way by the South, and go up into the hill country. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","See the land, what it is; and the people who dwell therein, whether they are strong or weak, whether they are few or many; ");
INSERT INTO engwebpb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","and what the land is that they dwell in, whether it is good or bad; and what cities they are that they dwell in, whether in camps, or in strongholds; ");
INSERT INTO engwebpb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","and what the land is, whether it is fertile or poor, whether there is wood therein, or not. Be courageous, and bring some of the fruit of the land.” Now the time was the time of the first-ripe grapes. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So they went up, and spied out the land from the wilderness of Zin to Rehob, to the entrance of Hamath. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","They went up by the South, and came to Hebron; and Ahiman, Sheshai, and Talmai, the children of Anak, were there. (Now Hebron was built seven years before Zoan in Egypt.) ");
INSERT INTO engwebpb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","They came to the valley of Eshcol, and cut down from there a branch with one cluster of grapes, and they bore it on a staff between two. They also brought some of the pomegranates and figs. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place was called the valley of Eshcol, because of the cluster which the children of Israel cut down from there. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","They returned from spying out the land at the end of forty days. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","They went and came to Moses, to Aaron, and to all the congregation of the children of Israel, to the wilderness of Paran, to Kadesh; and brought back word to them and to all the congregation. They showed them the fruit of the land. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","They told him, and said, “We came to the land where you sent us. Surely it flows with milk and honey, and this is its fruit. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","However, the people who dwell in the land are strong, and the cities are fortified and very large. Moreover, we saw the children of Anak there. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek dwells in the land of the South. The Hittite, the Jebusite, and the Amorite dwell in the hill country. The Canaanite dwells by the sea, and along the side of the Jordan.” ");
INSERT INTO engwebpb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb stilled the people before Moses, and said, “Let’s go up at once, and possess it; for we are well able to overcome it!” ");
INSERT INTO engwebpb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who went up with him said, “We aren’t able to go up against the people; for they are stronger than we.” ");
INSERT INTO engwebpb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","They brought up an evil report of the land which they had spied out to the children of Israel, saying, “The land, through which we have gone to spy it out, is a land that eats up its inhabitants; and all the people who we saw in it are men of great stature. ");
INSERT INTO engwebpb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","There we saw the Nephilim, the sons of Anak, who come from the Nephilim. We were in our own sight as grasshoppers, and so we were in their sight.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","All the congregation lifted up their voice, and cried; and the people wept that night. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","All the children of Israel murmured against Moses and against Aaron. The whole congregation said to them, “We wish that we had died in the land of Egypt, or that we had died in this wilderness! ");
INSERT INTO engwebpb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why does the LORD bring us to this land, to fall by the sword? Our wives and our little ones will be captured or killed! Wouldn’t it be better for us to return into Egypt?” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","They said to one another, “Let’s choose a leader, and let’s return into Egypt.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Moses and Aaron fell on their faces before all the assembly of the congregation of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua the son of Nun and Caleb the son of Jephunneh, who were of those who spied out the land, tore their clothes. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","They spoke to all the congregation of the children of Israel, saying, “The land, which we passed through to spy it out, is an exceedingly good land. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If the LORD delights in us, then he will bring us into this land, and give it to us: a land which flows with milk and honey. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Only don’t rebel against the LORD, neither fear the people of the land; for they are bread for us. Their defence is removed from over them, and the LORD is with us. Don’t fear them.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","But all the congregation threatened to stone them with stones. The LORD’s glory appeared in the Tent of Meeting to all the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","The LORD said to Moses, “How long will this people despise me? How long will they not believe in me, for all the signs which I have worked amongst them? ");
INSERT INTO engwebpb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will strike them with the pestilence, and disinherit them, and will make of you a nation greater and mightier than they.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moses said to the LORD, “Then the Egyptians will hear it; for you brought up this people in your might from amongst them. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","They will tell it to the inhabitants of this land. They have heard that you LORD are amongst this people; for you LORD are seen face to face, and your cloud stands over them, and you go before them, in a pillar of cloud by day, and in a pillar of fire by night. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Now if you killed this people as one man, then the nations which have heard the fame of you will speak, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Because the LORD was not able to bring this people into the land which he swore to them, therefore he has slain them in the wilderness.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Now please let the power of the Lord be great, according as you have spoken, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘The LORD is slow to anger, and abundant in loving kindness, forgiving iniquity and disobedience; and he will by no means clear the guilty, visiting the iniquity of the fathers on the children, on the third and on the fourth generation.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Please pardon the iniquity of this people according to the greatness of your loving kindness, and just as you have forgiven this people, from Egypt even until now.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","The LORD said, “I have pardoned according to your word; ");
INSERT INTO engwebpb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","but in very deed—as I live, and as all the earth shall be filled with the LORD’s glory— ");
INSERT INTO engwebpb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","because all those men who have seen my glory and my signs, which I worked in Egypt and in the wilderness, yet have tempted me these ten times, and have not listened to my voice; ");
INSERT INTO engwebpb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","surely they shall not see the land which I swore to their fathers, neither shall any of those who despised me see it. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But my servant Caleb, because he had another spirit with him, and has followed me fully, him I will bring into the land into which he went. His offspring shall possess it. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Since the Amalekite and the Canaanite dwell in the valley, tomorrow turn and go into the wilderness by the way to the Red Sea.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How long shall I bear with this evil congregation that complain against me? I have heard the complaints of the children of Israel, which they complain against me. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Tell them, ‘As I live, says the LORD, surely as you have spoken in my ears, so I will do to you. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Your dead bodies shall fall in this wilderness; and all who were counted of you, according to your whole number, from twenty years old and upward, who have complained against me, ");
INSERT INTO engwebpb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","surely you shall not come into the land concerning which I swore that I would make you dwell therein, except Caleb the son of Jephunneh, and Joshua the son of Nun. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","But I will bring in your little ones that you said should be captured or killed, and they shall know the land which you have rejected. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But as for you, your dead bodies shall fall in this wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Your children shall be wanderers in the wilderness forty years, and shall bear your prostitution, until your dead bodies are consumed in the wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","After the number of the days in which you spied out the land, even forty days, for every day a year, you will bear your iniquities, even forty years, and you will know my alienation.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, the LORD, have spoken. I will surely do this to all this evil congregation who are gathered together against me. In this wilderness they shall be consumed, and there they shall die.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","The men whom Moses sent to spy out the land, who returned and made all the congregation to murmur against him by bringing up an evil report against the land, ");
INSERT INTO engwebpb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","even those men who brought up an evil report of the land, died by the plague before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","But Joshua the son of Nun and Caleb the son of Jephunneh remained alive of those men who went to spy out the land. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moses told these words to all the children of Israel, and the people mourned greatly. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","They rose up early in the morning and went up to the top of the mountain, saying, “Behold, we are here, and will go up to the place which the LORD has promised; for we have sinned.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moses said, “Why now do you disobey the commandment of the LORD, since it shall not prosper? ");
INSERT INTO engwebpb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Don’t go up, for the LORD isn’t amongst you; that way you won’t be struck down before your enemies. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","For there the Amalekite and the Canaanite are before you, and you will fall by the sword because you turned back from following the LORD; therefore the LORD will not be with you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they presumed to go up to the top of the mountain. Nevertheless, the ark of the LORD’s covenant and Moses didn’t depart out of the camp. ");
INSERT INTO engwebpb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Then the Amalekites came down, and the Canaanites who lived in that mountain, and struck them and beat them down even to Hormah. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Speak to the children of Israel, and tell them, ‘When you have come into the land of your habitations, which I give to you, ");
INSERT INTO engwebpb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","and will make an offering by fire to the LORD—a burnt offering, or a sacrifice, to accomplish a vow, or as a free will offering, or in your set feasts, to make a pleasant aroma to the LORD, of the herd, or of the flock— ");
INSERT INTO engwebpb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","then he who offers his offering shall offer to the LORD a meal offering of one tenth of an ephah of fine flour mixed with one fourth of a hin of oil. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","You shall prepare wine for the drink offering, one fourth of a hin, with the burnt offering or for the sacrifice, for each lamb. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘For a ram, you shall prepare for a meal offering two tenths of an ephah of fine flour mixed with the third part of a hin of oil; ");
INSERT INTO engwebpb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","and for the drink offering you shall offer the third part of a hin of wine, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","When you prepare a bull for a burnt offering or for a sacrifice, to accomplish a vow, or for peace offerings to the LORD, ");
INSERT INTO engwebpb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","then he shall offer with the bull a meal offering of three tenths of an ephah of fine flour mixed with half a hin of oil; ");
INSERT INTO engwebpb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","and you shall offer for the drink offering half a hin of wine, for an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Thus it shall be done for each bull, for each ram, for each of the male lambs, or of the young goats. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","According to the number that you shall prepare, so you shall do to everyone according to their number. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“‘All who are native-born shall do these things in this way, in offering an offering made by fire, of a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","If a stranger lives as a foreigner with you, or whoever may be amongst you throughout your generations, and will offer an offering made by fire, of a pleasant aroma to the LORD, as you do, so he shall do. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","For the assembly, there shall be one statute for you and for the stranger who lives as a foreigner, a statute forever throughout your generations. As you are, so the foreigner shall be before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","One law and one ordinance shall be for you and for the stranger who lives as a foreigner with you.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Speak to the children of Israel, and tell them, ‘When you come into the land where I bring you, ");
INSERT INTO engwebpb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","then it shall be that when you eat of the bread of the land, you shall offer up a wave offering to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Of the first of your dough you shall offer up a cake for a wave offering. As the wave offering of the threshing floor, so you shall heave it. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Of the first of your dough, you shall give to the LORD a wave offering throughout your generations. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“‘When you err, and don’t observe all these commandments which the LORD has spoken to Moses— ");
INSERT INTO engwebpb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","even all that the LORD has commanded you by Moses, from the day that the LORD gave commandment and onward throughout your generations— ");
INSERT INTO engwebpb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","then it shall be, if it was done unwittingly, without the knowledge of the congregation, that all the congregation shall offer one young bull for a burnt offering, for a pleasant aroma to the LORD, with its meal offering and its drink offering, according to the ordinance, and one male goat for a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","The priest shall make atonement for all the congregation of the children of Israel, and they shall be forgiven; for it was an error, and they have brought their offering, an offering made by fire to the LORD, and their sin offering before the LORD, for their error. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","All the congregation of the children of Israel shall be forgiven, as well as the stranger who lives as a foreigner amongst them; for with regard to all the people, it was done unwittingly. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘If a person sins unwittingly, then he shall offer a female goat a year old for a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","The priest shall make atonement for the soul who errs when he sins unwittingly before the LORD. He shall make atonement for him; and he shall be forgiven. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","You shall have one law for him who does anything unwittingly, for him who is native-born amongst the children of Israel, and for the stranger who lives as a foreigner amongst them. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“‘But the soul who does anything with a high hand, whether he is native-born or a foreigner, blasphemes the LORD. That soul shall be cut off from amongst his people. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Because he has despised the LORD’s word, and has broken his commandment, that soul shall be utterly cut off. His iniquity shall be on him.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","While the children of Israel were in the wilderness, they found a man gathering sticks on the Sabbath day. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Those who found him gathering sticks brought him to Moses and Aaron, and to all the congregation. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","They put him in custody, because it had not been declared what should be done to him. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","The LORD said to Moses, “The man shall surely be put to death. All the congregation shall stone him with stones outside of the camp.” ");
INSERT INTO engwebpb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","All the congregation brought him outside of the camp, and stoned him to death with stones, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Speak to the children of Israel, and tell them that they should make themselves fringes on the borders of their garments throughout their generations, and that they put on the fringe of each border a cord of blue. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","It shall be to you for a fringe, that you may see it, and remember all the LORD’s commandments, and do them; and that you don’t follow your own heart and your own eyes, after which you used to play the prostitute; ");
INSERT INTO engwebpb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","so that you may remember and do all my commandments, and be holy to your God. ");
INSERT INTO engwebpb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the LORD your God, who brought you out of the land of Egypt, to be your God: I am the LORD your God.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korah, the son of Izhar, the son of Kohath, the son of Levi, with Dathan and Abiram, the sons of Eliab, and On, the son of Peleth, sons of Reuben, took some men. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","They rose up before Moses, with some of the children of Israel, two hundred and fifty princes of the congregation, called to the assembly, men of renown. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They assembled themselves together against Moses and against Aaron, and said to them, “You take too much on yourself, since all the congregation are holy, everyone of them, and the LORD is amongst them! Why do you lift yourselves up above the LORD’s assembly?” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses heard it, he fell on his face. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","He said to Korah and to all his company, “In the morning, the LORD will show who are his, and who is holy, and will cause him to come near to him. Even him whom he shall choose, he will cause to come near to him. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Do this: have Korah and all his company take censers, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","put fire in them, and put incense on them before the LORD tomorrow. It shall be that the man whom the LORD chooses, he shall be holy. You have gone too far, you sons of Levi!” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses said to Korah, “Hear now, you sons of Levi! ");
INSERT INTO engwebpb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Is it a small thing to you that the God of Israel has separated you from the congregation of Israel, to bring you near to himself, to do the service of the LORD’s tabernacle, and to stand before the congregation to minister to them; ");
INSERT INTO engwebpb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","and that he has brought you near, and all your brothers the sons of Levi with you? Do you seek the priesthood also? ");
INSERT INTO engwebpb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Therefore you and all your company have gathered together against the LORD! What is Aaron that you complain against him?” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moses sent to call Dathan and Abiram, the sons of Eliab; and they said, “We won’t come up! ");
INSERT INTO engwebpb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it a small thing that you have brought us up out of a land flowing with milk and honey, to kill us in the wilderness, but you must also make yourself a prince over us? ");
INSERT INTO engwebpb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Moreover you haven’t brought us into a land flowing with milk and honey, nor given us inheritance of fields and vineyards. Will you put out the eyes of these men? We won’t come up.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moses was very angry, and said to the LORD, “Don’t respect their offering. I have not taken one donkey from them, neither have I hurt one of them.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moses said to Korah, “You and all your company go before the LORD, you, and they, and Aaron, tomorrow. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Each man take his censer and put incense on it, and each man bring before the LORD his censer, two hundred and fifty censers; you also, and Aaron, each with his censer.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","They each took his censer, and put fire in it, and laid incense on it, and stood at the door of the Tent of Meeting with Moses and Aaron. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah assembled all the congregation opposite them to the door of the Tent of Meeting. The LORD’s glory appeared to all the congregation. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separate yourselves from amongst this congregation, that I may consume them in a moment!” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","They fell on their faces, and said, “God, the God of the spirits of all flesh, shall one man sin, and will you be angry with all the congregation?” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Speak to the congregation, saying, ‘Get away from around the tent of Korah, Dathan, and Abiram!’” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moses rose up and went to Dathan and Abiram; and the elders of Israel followed him. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","He spoke to the congregation, saying, “Depart, please, from the tents of these wicked men, and touch nothing of theirs, lest you be consumed in all their sins!” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So they went away from the tent of Korah, Dathan, and Abiram, on every side. Dathan and Abiram came out, and stood at the door of their tents with their wives, their sons, and their little ones. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moses said, “Hereby you shall know that the LORD has sent me to do all these works; for they are not from my own mind. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die the common death of all men, or if they experience what all men experience, then the LORD hasn’t sent me. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the LORD makes a new thing, and the ground opens its mouth, and swallows them up with all that belong to them, and they go down alive into Sheol, then you shall understand that these men have despised the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","As he finished speaking all these words, the ground that was under them split apart. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","The earth opened its mouth and swallowed them up with their households, all of Korah’s men, and all their goods. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","So they, and all that belonged to them went down alive into Sheol. The earth closed on them, and they perished from amongst the assembly. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","All Israel that were around them fled at their cry; for they said, “Lest the earth swallow us up!” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Fire came out from the LORD, and devoured the two hundred and fifty men who offered the incense. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Speak to Eleazar the son of Aaron the priest, that he take up the censers out of the burning, and scatter the fire away from the camp; for they are holy, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","even the censers of those who sinned against their own lives. Let them be beaten into plates for a covering of the altar, for they offered them before the LORD. Therefore they are holy. They shall be a sign to the children of Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eleazar the priest took the bronze censers which those who were burnt had offered; and they beat them out for a covering of the altar, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","to be a memorial to the children of Israel, to the end that no stranger who isn’t of the offspring of Aaron, would come near to burn incense before the LORD, that he not be as Korah and as his company; as the LORD spoke to him by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","But on the next day all the congregation of the children of Israel complained against Moses and against Aaron, saying, “You have killed the LORD’s people!” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","When the congregation was assembled against Moses and against Aaron, they looked towards the Tent of Meeting. Behold, the cloud covered it, and the LORD’s glory appeared. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moses and Aaron came to the front of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Get away from amongst this congregation, that I may consume them in a moment!” They fell on their faces. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses said to Aaron, “Take your censer, put fire from the altar in it, lay incense on it, carry it quickly to the congregation, and make atonement for them; for wrath has gone out from the LORD! The plague has begun.” ");
INSERT INTO engwebpb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron did as Moses said, and ran into the middle of the assembly. The plague had already begun amongst the people. He put on the incense, and made atonement for the people. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","He stood between the dead and the living; and the plague was stayed. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Now those who died by the plague were fourteen thousand and seven hundred, in addition to those who died about the matter of Korah. ");
INSERT INTO engwebpb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaron returned to Moses to the door of the Tent of Meeting, and the plague was stopped. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Speak to the children of Israel, and take rods from them, one for each fathers’ house, of all their princes according to their fathers’ houses, twelve rods. Write each man’s name on his rod. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","You shall write Aaron’s name on Levi’s rod. There shall be one rod for each head of their fathers’ houses. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","You shall lay them up in the Tent of Meeting before the covenant, where I meet with you. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","It shall happen that the rod of the man whom I shall choose shall bud. I will make the murmurings of the children of Israel, which they murmur against you, cease from me.” ");
INSERT INTO engwebpb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moses spoke to the children of Israel; and all their princes gave him rods, for each prince one, according to their fathers’ houses, a total of twelve rods. Aaron’s rod was amongst their rods. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses laid up the rods before the LORD in the Tent of the Testimony. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","On the next day, Moses went into the Tent of the Testimony; and behold, Aaron’s rod for the house of Levi had sprouted, budded, produced blossoms, and bore ripe almonds. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses brought out all the rods from before the LORD to all the children of Israel. They looked, and each man took his rod. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","The LORD said to Moses, “Put back the rod of Aaron before the covenant, to be kept for a token against the children of rebellion; that you may make an end of their complaining against me, that they not die.” ");
INSERT INTO engwebpb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moses did so. As the LORD commanded him, so he did. ");
INSERT INTO engwebpb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","The children of Israel spoke to Moses, saying, “Behold, we perish! We are undone! We are all undone! ");
INSERT INTO engwebpb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Everyone who keeps approaching the LORD’s tabernacle, dies! Will we all perish?” ");
INSERT INTO engwebpb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","The LORD said to Aaron, “You and your sons and your fathers’ house with you shall bear the iniquity of the sanctuary; and you and your sons with you shall bear the iniquity of your priesthood. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Bring your brothers also, the tribe of Levi, the tribe of your father, near with you, that they may be joined to you, and minister to you; but you and your sons with you shall be before the Tent of the Testimony. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","They shall keep your commands and the duty of the whole Tent; only they shall not come near to the vessels of the sanctuary and to the altar, that they not die, neither they nor you. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They shall be joined to you and keep the responsibility of the Tent of Meeting, for all the service of the Tent. A stranger shall not come near to you. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“You shall perform the duty of the sanctuary and the duty of the altar, that there be no more wrath on the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Behold, I myself have taken your brothers the Levites from amongst the children of Israel. They are a gift to you, dedicated to the LORD, to do the service of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","You and your sons with you shall keep your priesthood for everything of the altar, and for that within the veil. You shall serve. I give you the service of the priesthood as a gift. The stranger who comes near shall be put to death.” ");
INSERT INTO engwebpb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","The LORD spoke to Aaron, “Behold, I myself have given you the command of my wave offerings, even all the holy things of the children of Israel. I have given them to you by reason of the anointing, and to your sons, as a portion forever. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","This shall be yours of the most holy things from the fire: every offering of theirs, even every meal offering of theirs, and every sin offering of theirs, and every trespass offering of theirs, which they shall give to me, shall be most holy for you and for your sons. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","You shall eat of it like the most holy things. Every male shall eat of it. It shall be holy to you. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“This is yours, too: the wave offering of their gift, even all the wave offerings of the children of Israel. I have given them to you, and to your sons and to your daughters with you, as a portion forever. Everyone who is clean in your house shall eat of it. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“I have given to you all the best of the oil, all the best of the vintage, and of the grain, the first fruits of them which they give to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","The first-ripe fruits of all that is in their land, which they bring to the LORD, shall be yours. Everyone who is clean in your house shall eat of it. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Everything devoted in Israel shall be yours. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Everything that opens the womb, of all flesh which they offer to the LORD, both of man and animal, shall be yours. Nevertheless, you shall surely redeem the firstborn of man, and you shall redeem the firstborn of unclean animals. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","You shall redeem those who are to be redeemed of them from a month old, according to your estimation, for five shekels of money, according to the shekel of the sanctuary, which weighs twenty gerahs. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“But you shall not redeem the firstborn of a cow, or the firstborn of a sheep, or the firstborn of a goat. They are holy. You shall sprinkle their blood on the altar, and shall burn their fat for an offering made by fire, for a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Their meat shall be yours, as the wave offering breast and as the right thigh, it shall be yours. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the wave offerings of the holy things which the children of Israel offer to the LORD, I have given you and your sons and your daughters with you, as a portion forever. It is a covenant of salt forever before the LORD to you and to your offspring with you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","The LORD said to Aaron, “You shall have no inheritance in their land, neither shall you have any portion amongst them. I am your portion and your inheritance amongst the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“To the children of Levi, behold, I have given all the tithe in Israel for an inheritance, in return for their service which they serve, even the service of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Henceforth the children of Israel shall not come near the Tent of Meeting, lest they bear sin, and die. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","But the Levites shall do the service of the Tent of Meeting, and they shall bear their iniquity. It shall be a statute forever throughout your generations. Amongst the children of Israel, they shall have no inheritance. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","For the tithe of the children of Israel, which they offer as a wave offering to the LORD, I have given to the Levites for an inheritance. Therefore I have said to them, ‘Amongst the children of Israel they shall have no inheritance.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Moreover you shall speak to the Levites, and tell them, ‘When you take of the children of Israel the tithe which I have given you from them for your inheritance, then you shall offer up a wave offering of it for the LORD, a tithe of the tithe. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Your wave offering shall be credited to you, as though it were the grain of the threshing floor, and as the fullness of the wine press. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Thus you also shall offer a wave offering to the LORD of all your tithes, which you receive of the children of Israel; and of it you shall give the LORD’s wave offering to Aaron the priest. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Out of all your gifts, you shall offer every wave offering to the LORD, of all its best parts, even the holy part of it.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Therefore you shall tell them, ‘When you heave its best from it, then it shall be credited to the Levites as the increase of the threshing floor, and as the increase of the wine press. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","You may eat it anywhere, you and your households, for it is your reward in return for your service in the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","You shall bear no sin by reason of it, when you have heaved from it its best. You shall not profane the holy things of the children of Israel, that you not die.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","The LORD spoke to Moses and to Aaron, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“This is the statute of the law which the LORD has commanded. Tell the children of Israel to bring you a red heifer without spot, in which is no defect, and which was never yoked. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","You shall give her to Eleazar the priest, and he shall bring her outside of the camp, and one shall kill her before his face. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar the priest shall take some of her blood with his finger, and sprinkle her blood towards the front of the Tent of Meeting seven times. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","One shall burn the heifer in his sight; her skin, and her meat, and her blood, with her dung, shall he burn. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","The priest shall take cedar wood, hyssop, and scarlet, and cast it into the middle of the burning of the heifer. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then the priest shall wash his clothes, and he shall bathe his flesh in water, and afterward he shall come into the camp, and the priest shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","He who burns her shall wash his clothes in water, and bathe his flesh in water, and shall be unclean until the evening. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“A man who is clean shall gather up the ashes of the heifer, and lay them up outside of the camp in a clean place; and it shall be kept for the congregation of the children of Israel for use in water for cleansing impurity. It is a sin offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","He who gathers the ashes of the heifer shall wash his clothes, and be unclean until the evening. It shall be to the children of Israel, and to the stranger who lives as a foreigner amongst them, for a statute forever. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“He who touches the dead body of any man shall be unclean seven days. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He shall purify himself with water on the third day, and on the seventh day he shall be clean; but if he doesn’t purify himself the third day, then the seventh day he shall not be clean. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Whoever touches a dead person, the body of a man who has died, and doesn’t purify himself, defiles the LORD’s tabernacle; and that soul shall be cut off from Israel; because the water for impurity was not sprinkled on him, he shall be unclean. His uncleanness is yet on him. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“This is the law when a man dies in a tent: everyone who comes into the tent, and everyone who is in the tent, shall be unclean seven days. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Every open vessel, which has no covering bound on it, is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Whoever in the open field touches one who is slain with a sword, or a dead body, or a bone of a man, or a grave, shall be unclean seven days. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“For the unclean, they shall take of the ashes of the burning of the sin offering; and running water shall be poured on them in a vessel. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","A clean person shall take hyssop, dip it in the water, and sprinkle it on the tent, on all the vessels, on the persons who were there, and on him who touched the bone, or the slain, or the dead, or the grave. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","The clean person shall sprinkle on the unclean on the third day, and on the seventh day. On the seventh day, he shall purify him. He shall wash his clothes and bathe himself in water, and shall be clean at evening. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But the man who shall be unclean, and shall not purify himself, that soul shall be cut off from amongst the assembly, because he has defiled the sanctuary of the LORD. The water for impurity has not been sprinkled on him. He is unclean. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","It shall be a perpetual statute to them. He who sprinkles the water for impurity shall wash his clothes, and he who touches the water for impurity shall be unclean until evening. ");
INSERT INTO engwebpb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","“Whatever the unclean person touches shall be unclean; and the soul that touches it shall be unclean until evening.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","The children of Israel, even the whole congregation, came into the wilderness of Zin in the first month. The people stayed in Kadesh. Miriam died there, and was buried there. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","There was no water for the congregation; and they assembled themselves together against Moses and against Aaron. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","The people quarrelled with Moses, and spoke, saying, “We wish that we had died when our brothers died before the LORD! ");
INSERT INTO engwebpb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why have you brought the LORD’s assembly into this wilderness, that we should die there, we and our animals? ");
INSERT INTO engwebpb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why have you made us to come up out of Egypt, to bring us in to this evil place? It is no place of seed, or of figs, or of vines, or of pomegranates; neither is there any water to drink.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moses and Aaron went from the presence of the assembly to the door of the Tent of Meeting, and fell on their faces. The LORD’s glory appeared to them. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Take the rod, and assemble the congregation, you, and Aaron your brother, and speak to the rock before their eyes, that it pour out its water. You shall bring water to them out of the rock; so you shall give the congregation and their livestock drink.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moses took the rod from before the LORD, as he commanded him. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moses and Aaron gathered the assembly together before the rock, and he said to them, “Hear now, you rebels! Shall we bring water out of this rock for you?” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moses lifted up his hand, and struck the rock with his rod twice, and water came out abundantly. The congregation and their livestock drank. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","The LORD said to Moses and Aaron, “Because you didn’t believe in me, to sanctify me in the eyes of the children of Israel, therefore you shall not bring this assembly into the land which I have given them.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These are the waters of Meribah; because the children of Israel strove with the LORD, and he was sanctified in them. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moses sent messengers from Kadesh to the king of Edom, saying: “Your brother Israel says: You know all the travail that has happened to us; ");
INSERT INTO engwebpb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","how our fathers went down into Egypt, and we lived in Egypt a long time. The Egyptians mistreated us and our fathers. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","When we cried to the LORD, he heard our voice, sent an angel, and brought us out of Egypt. Behold, we are in Kadesh, a city in the edge of your border. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Please let us pass through your land. We will not pass through field or through vineyard, neither will we drink from the water of the wells. We will go along the king’s highway. We will not turn away to the right hand nor to the left, until we have passed your border.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom said to him, “You shall not pass through me, lest I come out with the sword against you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","The children of Israel said to him, “We will go up by the highway; and if we drink your water, I and my livestock, then I will give its price. Only let me, without doing anything else, pass through on my feet.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","He said, “You shall not pass through.” Edom came out against him with many people, and with a strong hand. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Thus Edom refused to give Israel passage through his border, so Israel turned away from him. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","They travelled from Kadesh, and the children of Israel, even the whole congregation, came to Mount Hor. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","The LORD spoke to Moses and Aaron in Mount Hor, by the border of the land of Edom, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron shall be gathered to his people; for he shall not enter into the land which I have given to the children of Israel, because you rebelled against my word at the waters of Meribah. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Take Aaron and Eleazar his son, and bring them up to Mount Hor; ");
INSERT INTO engwebpb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","and strip Aaron of his garments, and put them on Eleazar his son. Aaron shall be gathered, and shall die there.” ");
INSERT INTO engwebpb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses did as the LORD commanded. They went up onto Mount Hor in the sight of all the congregation. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses stripped Aaron of his garments, and put them on Eleazar his son. Aaron died there on the top of the mountain, and Moses and Eleazar came down from the mountain. ");
INSERT INTO engwebpb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","When all the congregation saw that Aaron was dead, they wept for Aaron thirty days, even all the house of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","The Canaanite, the king of Arad, who lived in the South, heard that Israel came by the way of Atharim. He fought against Israel, and took some of them captive. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israel vowed a vow to the LORD, and said, “If you will indeed deliver this people into my hand, then I will utterly destroy their cities.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","The LORD listened to the voice of Israel, and delivered up the Canaanites; and they utterly destroyed them and their cities. The name of the place was called Hormah. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","They travelled from Mount Hor by the way to the Red Sea, to go around the land of Edom. The soul of the people was very discouraged because of the journey. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","The people spoke against God and against Moses: “Why have you brought us up out of Egypt to die in the wilderness? For there is no bread, there is no water, and our soul loathes this disgusting food!” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","The LORD sent venomous snakes amongst the people, and they bit the people. Many people of Israel died. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","The people came to Moses, and said, “We have sinned, because we have spoken against the LORD and against you. Pray to the LORD, that he take away the serpents from us.” Moses prayed for the people. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","The LORD said to Moses, “Make a venomous snake, and set it on a pole. It shall happen that everyone who is bitten, when he sees it, shall live.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moses made a serpent of bronze, and set it on the pole. If a serpent had bitten any man, when he looked at the serpent of bronze, he lived. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","The children of Israel travelled, and encamped in Oboth. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","They travelled from Oboth, and encamped at Iyeabarim, in the wilderness which is before Moab, towards the sunrise. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","From there they travelled, and encamped in the valley of Zered. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From there they travelled, and encamped on the other side of the Arnon, which is in the wilderness that comes out of the border of the Amorites; for the Arnon is the border of Moab, between Moab and the Amorites. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Therefore it is said in The Book of the Wars of the LORD, “Vaheb in Suphah, the valleys of the Arnon, ");
INSERT INTO engwebpb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","the slope of the valleys that incline towards the dwelling of Ar, leans on the border of Moab.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","From there they travelled to Beer; that is the well of which the LORD said to Moses, “Gather the people together, and I will give them water.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then Israel sang this song: “Spring up, well! Sing to it, ");
INSERT INTO engwebpb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","the well, which the princes dug, which the nobles of the people dug, with the sceptre, and with their poles.” From the wilderness they travelled to Mattanah; ");
INSERT INTO engwebpb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","and from Mattanah to Nahaliel; and from Nahaliel to Bamoth; ");
INSERT INTO engwebpb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","and from Bamoth to the valley that is in the field of Moab, to the top of Pisgah, which looks down on the desert. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel sent messengers to Sihon king of the Amorites, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Let me pass through your land. We will not turn away into field or vineyard. We will not drink of the water of the wells. We will go by the king’s highway, until we have passed your border.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon would not allow Israel to pass through his border, but Sihon gathered all his people together, and went out against Israel into the wilderness, and came to Jahaz. He fought against Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israel struck him with the edge of the sword, and possessed his land from the Arnon to the Jabbok, even to the children of Ammon; for the border of the children of Ammon was fortified. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel took all these cities. Israel lived in all the cities of the Amorites, in Heshbon, and in all its villages. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","For Heshbon was the city of Sihon the king of the Amorites, who had fought against the former king of Moab, and taken all his land out of his hand, even to the Arnon. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Therefore those who speak in proverbs say, “Come to Heshbon. Let the city of Sihon be built and established; ");
INSERT INTO engwebpb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","for a fire has gone out of Heshbon, a flame from the city of Sihon. It has devoured Ar of Moab, The lords of the high places of the Arnon. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to you, Moab! You are undone, people of Chemosh! He has given his sons as fugitives, and his daughters into captivity, to Sihon king of the Amorites. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","We have shot at them. Heshbon has perished even to Dibon. We have laid waste even to Nophah, Which reaches to Medeba.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Thus Israel lived in the land of the Amorites. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moses sent to spy out Jazer. They took its villages, and drove out the Amorites who were there. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","They turned and went up by the way of Bashan. Og the king of Bashan went out against them, he and all his people, to battle at Edrei. ");
INSERT INTO engwebpb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","The LORD said to Moses, “Don’t fear him, for I have delivered him into your hand, with all his people, and his land. You shall do to him as you did to Sihon king of the Amorites, who lived at Heshbon.” ");
INSERT INTO engwebpb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they struck him, with his sons and all his people, until there were no survivors; and they possessed his land. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","The children of Israel travelled, and encamped in the plains of Moab beyond the Jordan at Jericho. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak the son of Zippor saw all that Israel had done to the Amorites. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab was very afraid of the people, because they were many. Moab was distressed because of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab said to the elders of Midian, “Now this multitude will lick up all that is around us, as the ox licks up the grass of the field.” Balak the son of Zippor was king of Moab at that time. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","He sent messengers to Balaam the son of Beor, to Pethor, which is by the River, to the land of the children of his people, to call him, saying, “Behold, there is a people who came out of Egypt. Behold, they cover the surface of the earth, and they are staying opposite me. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Please come now therefore, and curse this people for me; for they are too mighty for me. Perhaps I shall prevail, that we may strike them, and that I may drive them out of the land; for I know that he whom you bless is blessed, and he whom you curse is cursed.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","The elders of Moab and the elders of Midian departed with the rewards of divination in their hand. They came to Balaam, and spoke to him the words of Balak. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","He said to them, “Lodge here this night, and I will bring you word again, as the LORD shall speak to me.” The princes of Moab stayed with Balaam. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God came to Balaam, and said, “Who are these men with you?” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam said to God, “Balak the son of Zippor, king of Moab, has said to me, ");
INSERT INTO engwebpb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Behold, the people that has come out of Egypt covers the surface of the earth. Now, come curse them for me. Perhaps I shall be able to fight against them, and shall drive them out.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","God said to Balaam, “You shall not go with them. You shall not curse the people, for they are blessed.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam rose up in the morning, and said to the princes of Balak, “Go to your land; for the LORD refuses to permit me to go with you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","The princes of Moab rose up, and they went to Balak, and said, “Balaam refuses to come with us.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak again sent princes, more, and more honourable than they. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","They came to Balaam, and said to him, “Balak the son of Zippor says, ‘Please let nothing hinder you from coming to me, ");
INSERT INTO engwebpb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","for I will promote you to very great honour, and whatever you say to me I will do. Please come therefore, and curse this people for me.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam answered the servants of Balak, “If Balak would give me his house full of silver and gold, I can’t go beyond the word of the LORD my God, to do less or more. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Now therefore please stay here tonight as well, that I may know what else the LORD will speak to me.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","God came to Balaam at night, and said to him, “If the men have come to call you, rise up, go with them; but only the word which I speak to you, that you shall do.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam rose up in the morning, and saddled his donkey, and went with the princes of Moab. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","God’s anger burnt because he went; and the LORD’s angel placed himself in the way as an adversary against him. Now he was riding on his donkey, and his two servants were with him. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","The donkey saw the LORD’s angel standing in the way, with his sword drawn in his hand; and the donkey turned out of the path, and went into the field. Balaam struck the donkey, to turn her into the path. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Then the LORD’s angel stood in a narrow path between the vineyards, a wall being on this side, and a wall on that side. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","The donkey saw the LORD’s angel, and she thrust herself to the wall, and crushed Balaam’s foot against the wall. He struck her again. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","The LORD’s angel went further, and stood in a narrow place, where there was no way to turn either to the right hand or to the left. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","The donkey saw the LORD’s angel, and she lay down under Balaam. Balaam’s anger burnt, and he struck the donkey with his staff. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","The LORD opened the mouth of the donkey, and she said to Balaam, “What have I done to you, that you have struck me these three times?” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam said to the donkey, “Because you have mocked me, I wish there were a sword in my hand, for now I would have killed you.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","The donkey said to Balaam, “Am I not your donkey, on which you have ridden all your life long until today? Was I ever in the habit of doing so to you?” He said, “No.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then the LORD opened the eyes of Balaam, and he saw the LORD’s angel standing in the way, with his sword drawn in his hand; and he bowed his head, and fell on his face. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","The LORD’s angel said to him, “Why have you struck your donkey these three times? Behold, I have come out as an adversary, because your way is perverse before me. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","The donkey saw me, and turned away before me these three times. Unless she had turned away from me, surely now I would have killed you, and saved her alive.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam said to the LORD’s angel, “I have sinned; for I didn’t know that you stood in the way against me. Now therefore, if it displeases you, I will go back again.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","The LORD’s angel said to Balaam, “Go with the men; but you shall only speak the word that I shall speak to you.” So Balaam went with the princes of Balak. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","When Balak heard that Balaam had come, he went out to meet him to the City of Moab, which is on the border of the Arnon, which is in the utmost part of the border. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak said to Balaam, “Didn’t I earnestly send for you to summon you? Why didn’t you come to me? Am I not able indeed to promote you to honour?” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam said to Balak, “Behold, I have come to you. Have I now any power at all to speak anything? I will speak the word that God puts in my mouth.” ");
INSERT INTO engwebpb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam went with Balak, and they came to Kiriath Huzoth. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sacrificed cattle and sheep, and sent to Balaam, and to the princes who were with him. ");
INSERT INTO engwebpb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","In the morning, Balak took Balaam, and brought him up into the high places of Baal; and he saw from there part of the people. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam said to Balak, “Build here seven altars for me, and prepare here seven bulls and seven rams for me.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak did as Balaam had spoken; and Balak and Balaam offered on every altar a bull and a ram. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam said to Balak, “Stand by your burnt offering, and I will go. Perhaps the LORD will come to meet me. Whatever he shows me I will tell you.” He went to a bare height. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","God met Balaam, and he said to him, “I have prepared the seven altars, and I have offered up a bull and a ram on every altar.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","The LORD put a word in Balaam’s mouth, and said, “Return to Balak, and thus you shall speak.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","He returned to him, and behold, he was standing by his burnt offering, he, and all the princes of Moab. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","He took up his parable, and said, “From Aram has Balak brought me, the king of Moab from the mountains of the East. Come, curse Jacob for me. Come, defy Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How shall I curse whom God has not cursed? How shall I defy whom the LORD has not defied? ");
INSERT INTO engwebpb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For from the top of the rocks I see him. From the hills I see him. Behold, it is a people that dwells alone, and shall not be listed amongst the nations. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count the dust of Jacob, or count the fourth part of Israel? Let me die the death of the righteous! Let my last end be like his!” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak said to Balaam, “What have you done to me? I took you to curse my enemies, and behold, you have blessed them altogether.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","He answered and said, “Must I not take heed to speak that which the LORD puts in my mouth?” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak said to him, “Please come with me to another place, where you may see them. You shall see just part of them, and shall not see them all. Curse them from there for me.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","He took him into the field of Zophim, to the top of Pisgah, and built seven altars, and offered up a bull and a ram on every altar. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","He said to Balak, “Stand here by your burnt offering, while I meet God over there.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","The LORD met Balaam, and put a word in his mouth, and said, “Return to Balak, and say this.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","He came to him, and behold, he was standing by his burnt offering, and the princes of Moab with him. Balak said to him, “What has the LORD spoken?” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","He took up his parable, and said, “Rise up, Balak, and hear! Listen to me, you son of Zippor. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man, that he should lie, nor a son of man, that he should repent. Has he said, and he won’t do it? Or has he spoken, and he won’t make it good? ");
INSERT INTO engwebpb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Behold, I have received a command to bless. He has blessed, and I can’t reverse it. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He has not seen iniquity in Jacob. Neither has he seen perverseness in Israel. The LORD his God is with him. The shout of a king is amongst them. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God brings them out of Egypt. He has as it were the strength of the wild ox. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Surely there is no enchantment with Jacob; neither is there any divination with Israel. Now it shall be said of Jacob and of Israel, ‘What has God done!’ ");
INSERT INTO engwebpb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Behold, a people rises up as a lioness. As a lion he lifts himself up. He shall not lie down until he eats of the prey, and drinks the blood of the slain.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak said to Balaam, “Neither curse them at all, nor bless them at all.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam answered Balak, “Didn’t I tell you, saying, ‘All that the LORD speaks, that I must do’?” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak said to Balaam, “Come now, I will take you to another place; perhaps it will please God that you may curse them for me from there.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak took Balaam to the top of Peor, that looks down on the desert. ");
INSERT INTO engwebpb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam said to Balak, “Build seven altars for me here, and prepare seven bulls and seven rams for me here.” ");
INSERT INTO engwebpb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak did as Balaam had said, and offered up a bull and a ram on every altar. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","When Balaam saw that it pleased the LORD to bless Israel, he didn’t go, as at the other times, to use divination, but he set his face towards the wilderness. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam lifted up his eyes, and he saw Israel dwelling according to their tribes; and the Spirit of God came on him. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","He took up his parable, and said, “Balaam the son of Beor says, the man whose eyes are open says; ");
INSERT INTO engwebpb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","he says, who hears the words of God, who sees the vision of the Almighty, falling down, and having his eyes open: ");
INSERT INTO engwebpb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How goodly are your tents, Jacob, and your dwellings, Israel! ");
INSERT INTO engwebpb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","As valleys they are spread out, as gardens by the riverside, as aloes which the LORD has planted, as cedar trees beside the waters. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Water shall flow from his buckets. His seed shall be in many waters. His king shall be higher than Agag. His kingdom shall be exalted. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God brings him out of Egypt. He has as it were the strength of the wild ox. He shall consume the nations his adversaries, shall break their bones in pieces, and pierce them with his arrows. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He couched, he lay down as a lion, as a lioness; who shall rouse him up? Everyone who blesses you is blessed. Everyone who curses you is cursed.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak’s anger burnt against Balaam, and he struck his hands together. Balak said to Balaam, “I called you to curse my enemies, and, behold, you have altogether blessed them these three times. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Therefore, flee to your place, now! I thought to promote you to great honour; but, behold, the LORD has kept you back from honour.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam said to Balak, “Didn’t I also tell your messengers whom you sent to me, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘If Balak would give me his house full of silver and gold, I can’t go beyond the LORD’s word, to do either good or bad from my own mind. I will say what the LORD says’? ");
INSERT INTO engwebpb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Now, behold, I go to my people. Come, I will inform you what this people shall do to your people in the latter days.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","He took up his parable, and said, “Balaam the son of Beor says, the man whose eyes are open says; ");
INSERT INTO engwebpb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","he says, who hears the words of God, knows the knowledge of the Most High, and who sees the vision of the Almighty, falling down, and having his eyes open: ");
INSERT INTO engwebpb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but not now. I see him, but not near. A star will come out of Jacob. A sceptre will rise out of Israel, and shall strike through the corners of Moab, and crush all the sons of Sheth. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom shall be a possession. Seir, his enemy, also shall be a possession, while Israel does valiantly. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Out of Jacob shall one have dominion, and shall destroy the remnant from the city.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","He looked at Amalek, and took up his parable, and said, “Amalek was the first of the nations, but his latter end shall come to destruction.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","He looked at the Kenite, and took up his parable, and said, “Your dwelling place is strong. Your nest is set in the rock. ");
INSERT INTO engwebpb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nevertheless Kain shall be wasted, until Asshur carries you away captive.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","He took up his parable, and said, “Alas, who shall live when God does this? ");
INSERT INTO engwebpb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","But ships shall come from the coast of Kittim. They shall afflict Asshur, and shall afflict Eber. He also shall come to destruction.” ");
INSERT INTO engwebpb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam rose up, and went and returned to his place; and Balak also went his way. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel stayed in Shittim; and the people began to play the prostitute with the daughters of Moab; ");
INSERT INTO engwebpb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","for they called the people to the sacrifices of their gods. The people ate and bowed down to their gods. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israel joined himself to Baal Peor, and the LORD’s anger burnt against Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","The LORD said to Moses, “Take all the chiefs of the people, and hang them up to the LORD before the sun, that the fierce anger of the LORD may turn away from Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moses said to the judges of Israel, “Everyone kill his men who have joined themselves to Baal Peor.” ");
INSERT INTO engwebpb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Behold, one of the children of Israel came and brought to his brothers a Midianite woman in the sight of Moses, and in the sight of all the congregation of the children of Israel, while they were weeping at the door of the Tent of Meeting. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","When Phinehas, the son of Eleazar, the son of Aaron the priest, saw it, he rose up from the middle of the congregation, and took a spear in his hand. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","He went after the man of Israel into the pavilion, and thrust both of them through, the man of Israel, and the woman through her body. So the plague was stopped amongst the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Those who died by the plague were twenty-four thousand. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinehas, the son of Eleazar, the son of Aaron the priest, has turned my wrath away from the children of Israel, in that he was jealous with my jealousy amongst them, so that I didn’t consume the children of Israel in my jealousy. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Therefore say, ‘Behold, I give to him my covenant of peace. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","It shall be to him, and to his offspring after him, the covenant of an everlasting priesthood, because he was jealous for his God, and made atonement for the children of Israel.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Now the name of the man of Israel that was slain, who was slain with the Midianite woman, was Zimri, the son of Salu, a prince of a fathers’ house amongst the Simeonites. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","The name of the Midianite woman who was slain was Cozbi, the daughter of Zur. He was head of the people of a fathers’ house in Midian. ");
INSERT INTO engwebpb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Harass the Midianites, and strike them; ");
INSERT INTO engwebpb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","for they harassed you with their wiles, wherein they have deceived you in the matter of Peor, and in the incident regarding Cozbi, the daughter of the prince of Midian, their sister, who was slain on the day of the plague in the matter of Peor.” ");
INSERT INTO engwebpb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","After the plague, the LORD spoke to Moses and to Eleazar the son of Aaron the priest, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Take a census of all the congregation of the children of Israel, from twenty years old and upward, by their fathers’ houses, all who are able to go out to war in Israel.” ");
INSERT INTO engwebpb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moses and Eleazar the priest spoke with them in the plains of Moab by the Jordan at Jericho, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Take a census, from twenty years old and upward, as the LORD commanded Moses and the children of Israel.” These are those who came out of the land of Egypt. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben, the firstborn of Israel; the sons of Reuben: of Hanoch, the family of the Hanochites; of Pallu, the family of the Palluites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","of Hezron, the family of the Hezronites; of Carmi, the family of the Carmites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These are the families of the Reubenites; and those who were counted of them were forty-three thousand and seven hundred and thirty. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","The son of Pallu: Eliab. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","The sons of Eliab: Nemuel, Dathan, and Abiram. These are that Dathan and Abiram who were called by the congregation, who rebelled against Moses and against Aaron in the company of Korah when they rebelled against the LORD; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","and the earth opened its mouth, and swallowed them up together with Korah when that company died; at the time the fire devoured two hundred and fifty men, and they became a sign. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Notwithstanding, the sons of Korah didn’t die. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","The sons of Simeon after their families: of Nemuel, the family of the Nemuelites; of Jamin, the family of the Jaminites; of Jachin, the family of the Jachinites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","of Zerah, the family of the Zerahites; of Shaul, the family of the Shaulites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These are the families of the Simeonites, twenty-two thousand and two hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","The sons of Gad after their families: of Zephon, the family of the Zephonites; of Haggi, the family of the Haggites; of Shuni, the family of the Shunites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","of Ozni, the family of the Oznites; of Eri, the family of the Erites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","of Arod, the family of the Arodites; of Areli, the family of the Arelites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These are the families of the sons of Gad according to those who were counted of them, forty thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","The sons of Judah: Er and Onan. Er and Onan died in the land of Canaan. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","The sons of Judah after their families were: of Shelah, the family of the Shelanites; of Perez, the family of the Perezites; of Zerah, the family of the Zerahites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","The sons of Perez were: of Hezron, the family of the Hezronites; of Hamul, the family of the Hamulites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These are the families of Judah according to those who were counted of them, seventy-six thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","The sons of Issachar after their families: of Tola, the family of the Tolaites; of Puvah, the family of the Punites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","of Jashub, the family of the Jashubites; of Shimron, the family of the Shimronites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These are the families of Issachar according to those who were counted of them, sixty-four thousand and three hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","The sons of Zebulun after their families: of Sered, the family of the Seredites; of Elon, the family of the Elonites; of Jahleel, the family of the Jahleelites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These are the families of the Zebulunites according to those who were counted of them, sixty thousand and five hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The sons of Joseph after their families: Manasseh and Ephraim. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","The sons of Manasseh: of Machir, the family of the Machirites; and Machir became the father of Gilead; of Gilead, the family of the Gileadites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These are the sons of Gilead: of Iezer, the family of the Iezerites; of Helek, the family of the Helekites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","and Asriel, the family of the Asrielites; and Shechem, the family of the Shechemites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","and Shemida, the family of the Shemidaites; and Hepher, the family of the Hepherites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad the son of Hepher had no sons, but daughters: and the names of the daughters of Zelophehad were Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These are the families of Manasseh. Those who were counted of them were fifty-two thousand and seven hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These are the sons of Ephraim after their families: of Shuthelah, the family of the Shuthelahites; of Becher, the family of the Becherites; of Tahan, the family of the Tahanites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","These are the sons of Shuthelah: of Eran, the family of the Eranites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These are the families of the sons of Ephraim according to those who were counted of them, thirty-two thousand and five hundred. These are the sons of Joseph after their families. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The sons of Benjamin after their families: of Bela, the family of the Belaites; of Ashbel, the family of the Ashbelites; of Ahiram, the family of the Ahiramites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","of Shephupham, the family of the Shuphamites; of Hupham, the family of the Huphamites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","The sons of Bela were Ard and Naaman: the family of the Ardites; and of Naaman, the family of the Naamites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These are the sons of Benjamin after their families; and those who were counted of them were forty-five thousand and six hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These are the sons of Dan after their families: of Shuham, the family of the Shuhamites. These are the families of Dan after their families. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","All the families of the Shuhamites, according to those who were counted of them, were sixty-four thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","The sons of Asher after their families: of Imnah, the family of the Imnites; of Ishvi, the family of the Ishvites; of Beriah, the family of the Berites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Of the sons of Beriah: of Heber, the family of the Heberites; of Malchiel, the family of the Malchielites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","The name of the daughter of Asher was Serah. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These are the families of the sons of Asher according to those who were counted of them, fifty-three thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","The sons of Naphtali after their families: of Jahzeel, the family of the Jahzeelites; of Guni, the family of the Gunites; ");
INSERT INTO engwebpb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","of Jezer, the family of the Jezerites; of Shillem, the family of the Shillemites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These are the families of Naphtali according to their families; and those who were counted of them were forty-five thousand and four hundred. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","These are those who were counted of the children of Israel, six hundred and one thousand and seven hundred and thirty. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“To these the land shall be divided for an inheritance according to the number of names. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To the more you shall give the more inheritance, and to the fewer you shall give the less inheritance. To everyone according to those who were counted of him shall his inheritance be given. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Notwithstanding, the land shall be divided by lot. According to the names of the tribes of their fathers they shall inherit. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","According to the lot shall their inheritance be divided between the more and the fewer.” ");
INSERT INTO engwebpb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","These are those who were counted of the Levites after their families: of Gershon, the family of the Gershonites; of Kohath, the family of the Kohathites; of Merari, the family of the Merarites. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are the families of Levi: the family of the Libnites, the family of the Hebronites, the family of the Mahlites, the family of the Mushites, and the family of the Korahites. Kohath became the father of Amram. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","The name of Amram’s wife was Jochebed, the daughter of Levi, who was born to Levi in Egypt. She bore to Amram Aaron and Moses, and Miriam their sister. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","To Aaron were born Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab and Abihu died when they offered strange fire before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Those who were counted of them were twenty-three thousand, every male from a month old and upward; for they were not counted amongst the children of Israel, because there was no inheritance given them amongst the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These are those who were counted by Moses and Eleazar the priest, who counted the children of Israel in the plains of Moab by the Jordan at Jericho. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","But amongst these there was not a man of them who were counted by Moses and Aaron the priest, who counted the children of Israel in the wilderness of Sinai. ");
INSERT INTO engwebpb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For the LORD had said of them, “They shall surely die in the wilderness.” There was not a man left of them, except Caleb the son of Jephunneh, and Joshua the son of Nun. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Then the daughters of Zelophehad, the son of Hepher, the son of Gilead, the son of Machir, the son of Manasseh, of the families of Manasseh the son of Joseph came near. These are the names of his daughters: Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","They stood before Moses, before Eleazar the priest, and before the princes and all the congregation, at the door of the Tent of Meeting, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Our father died in the wilderness. He was not amongst the company of those who gathered themselves together against the LORD in the company of Korah, but he died in his own sin. He had no sons. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should the name of our father be taken away from amongst his family, because he had no son? Give to us a possession amongst the brothers of our father.” ");
INSERT INTO engwebpb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moses brought their cause before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“The daughters of Zelophehad speak right. You shall surely give them a possession of an inheritance amongst their father’s brothers. You shall cause the inheritance of their father to pass to them. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","You shall speak to the children of Israel, saying, ‘If a man dies, and has no son, then you shall cause his inheritance to pass to his daughter. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","If he has no daughter, then you shall give his inheritance to his brothers. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","If he has no brothers, then you shall give his inheritance to his father’s brothers. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","If his father has no brothers, then you shall give his inheritance to his kinsman who is next to him of his family, and he shall possess it. This shall be a statute and ordinance for the children of Israel, as the LORD commanded Moses.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","The LORD said to Moses, “Go up into this mountain of Abarim, and see the land which I have given to the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","When you have seen it, you also shall be gathered to your people, as Aaron your brother was gathered; ");
INSERT INTO engwebpb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","because in the strife of the congregation, you rebelled against my word in the wilderness of Zin, to honour me as holy at the waters before their eyes.” (These are the waters of Meribah of Kadesh in the wilderness of Zin.) ");
INSERT INTO engwebpb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moses spoke to the LORD, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Let the LORD, the God of the spirits of all flesh, appoint a man over the congregation, ");
INSERT INTO engwebpb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","who may go out before them, and who may come in before them, and who may lead them out, and who may bring them in, that the congregation of the LORD may not be as sheep which have no shepherd.” ");
INSERT INTO engwebpb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","The LORD said to Moses, “Take Joshua the son of Nun, a man in whom is the Spirit, and lay your hand on him. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Set him before Eleazar the priest, and before all the congregation; and commission him in their sight. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","You shall give authority to him, that all the congregation of the children of Israel may obey. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","He shall stand before Eleazar the priest, who shall enquire for him by the judgement of the Urim before the LORD. At his word they shall go out, and at his word they shall come in, both he and all the children of Israel with him, even all the congregation.” ");
INSERT INTO engwebpb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses did as the LORD commanded him. He took Joshua, and set him before Eleazar the priest and before all the congregation. ");
INSERT INTO engwebpb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","He laid his hands on him and commissioned him, as the LORD spoke by Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Command the children of Israel, and tell them, ‘See that you present my offering, my food for my offerings made by fire, as a pleasant aroma to me, in their due season.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","You shall tell them, ‘This is the offering made by fire which you shall offer to the LORD: male lambs a year old without defect, two day by day, for a continual burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","You shall offer the one lamb in the morning, and you shall offer the other lamb at evening, ");
INSERT INTO engwebpb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","with one tenth of an ephah of fine flour for a meal offering, mixed with the fourth part of a hin of beaten oil. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","It is a continual burnt offering which was ordained in Mount Sinai for a pleasant aroma, an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Its drink offering shall be the fourth part of a hin for each lamb. You shall pour out a drink offering of strong drink to the LORD in the holy place. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","The other lamb you shall offer at evening. As the meal offering of the morning, and as its drink offering, you shall offer it, an offering made by fire, for a pleasant aroma to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘On the Sabbath day, you shall offer two male lambs a year old without defect, and two tenths of an ephah of fine flour for a meal offering mixed with oil, and its drink offering: ");
INSERT INTO engwebpb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","this is the burnt offering of every Sabbath, in addition to the continual burnt offering and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘In the beginnings of your months, you shall offer a burnt offering to the LORD: two young bulls, one ram, seven male lambs a year old without defect, ");
INSERT INTO engwebpb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","and three tenths of an ephah of fine flour for a meal offering mixed with oil, for each bull; and two tenth parts of fine flour for a meal offering mixed with oil, for the one ram; ");
INSERT INTO engwebpb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","and one tenth part of fine flour mixed with oil for a meal offering to every lamb, as a burnt offering of a pleasant aroma, an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Their drink offerings shall be half a hin of wine for a bull, the third part of a hin for the ram, and the fourth part of a hin for a lamb. This is the burnt offering of every month throughout the months of the year. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Also, one male goat for a sin offering to the LORD shall be offered in addition to the continual burnt offering and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘In the first month, on the fourteenth day of the month, is the LORD’s Passover. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","On the fifteenth day of this month shall be a feast. Unleavened bread shall be eaten for seven days. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","In the first day shall be a holy convocation. You shall do no regular work, ");
INSERT INTO engwebpb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","but you shall offer an offering made by fire, a burnt offering to the LORD: two young bulls, one ram, and seven male lambs a year old. They shall be without defect, ");
INSERT INTO engwebpb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","with their meal offering, fine flour mixed with oil. You shall offer three tenths for a bull, and two tenths for the ram. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","You shall offer one tenth for every lamb of the seven lambs; ");
INSERT INTO engwebpb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","and one male goat for a sin offering, to make atonement for you. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","You shall offer these in addition to the burnt offering of the morning, which is for a continual burnt offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","In this way you shall offer daily, for seven days, the food of the offering made by fire, of a pleasant aroma to the LORD. It shall be offered in addition to the continual burnt offering and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","On the seventh day you shall have a holy convocation. You shall do no regular work. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘Also in the day of the first fruits, when you offer a new meal offering to the LORD in your feast of weeks, you shall have a holy convocation. You shall do no regular work; ");
INSERT INTO engwebpb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","but you shall offer a burnt offering for a pleasant aroma to the LORD: two young bulls, one ram, seven male lambs a year old; ");
INSERT INTO engwebpb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","and their meal offering, fine flour mixed with oil, three tenths for each bull, two tenths for the one ram, ");
INSERT INTO engwebpb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","one tenth for every lamb of the seven lambs; ");
INSERT INTO engwebpb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","and one male goat, to make atonement for you. ");
INSERT INTO engwebpb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Besides the continual burnt offering and its meal offering, you shall offer them and their drink offerings. See that they are without defect. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘In the seventh month, on the first day of the month, you shall have a holy convocation; you shall do no regular work. It is a day of blowing of trumpets to you. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","You shall offer a burnt offering for a pleasant aroma to the LORD: one young bull, one ram, seven male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","and their meal offering, fine flour mixed with oil: three tenths for the bull, two tenths for the ram, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and one tenth for every lamb of the seven lambs; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","and one male goat for a sin offering, to make atonement for you; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","in addition to the burnt offering of the new moon with its meal offering, and the continual burnt offering with its meal offering, and their drink offerings, according to their ordinance, for a pleasant aroma, an offering made by fire to the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘On the tenth day of this seventh month you shall have a holy convocation. You shall afflict your souls. You shall do no kind of work; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","but you shall offer a burnt offering to the LORD for a pleasant aroma: one young bull, one ram, seven male lambs a year old, all without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","and their meal offering, fine flour mixed with oil: three tenths for the bull, two tenths for the one ram, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","one tenth for every lamb of the seven lambs; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","one male goat for a sin offering, in addition to the sin offering of atonement, and the continual burnt offering, and its meal offering, and their drink offerings. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘On the fifteenth day of the seventh month you shall have a holy convocation. You shall do no regular work. You shall keep a feast to the LORD seven days. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","You shall offer a burnt offering, an offering made by fire, of a pleasant aroma to the LORD: thirteen young bulls, two rams, fourteen male lambs a year old, all without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","and their meal offering, fine flour mixed with oil: three tenths for every bull of the thirteen bulls, two tenths for each ram of the two rams, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and one tenth for every lamb of the fourteen lambs; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","and one male goat for a sin offering, in addition to the continual burnt offering, its meal offering, and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘On the second day you shall offer twelve young bulls, two rams, and fourteen male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","and their meal offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number, after the ordinance; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","and one male goat for a sin offering, in addition to the continual burnt offering, with its meal offering and their drink offerings. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘On the third day: eleven bulls, two rams, fourteen male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","and their meal offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number, after the ordinance; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","and one male goat for a sin offering, in addition to the continual burnt offering, and its meal offering, and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘On the fourth day ten bulls, two rams, fourteen male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","their meal offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number, after the ordinance; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","and one male goat for a sin offering; in addition to the continual burnt offering, its meal offering, and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘On the fifth day: nine bulls, two rams, fourteen male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","and their meal offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number, after the ordinance, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","and one male goat for a sin offering, in addition to the continual burnt offering, and its meal offering, and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘On the sixth day: eight bulls, two rams, fourteen male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","and their meal offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number, after the ordinance, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","and one male goat for a sin offering; in addition to the continual burnt offering, its meal offering, and the drink offerings of it. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘On the seventh day: seven bulls, two rams, fourteen male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","and their meal offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number, after the ordinance, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","and one male goat for a sin offering; in addition to the continual burnt offering, its meal offering, and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘On the eighth day you shall have a solemn assembly. You shall do no regular work; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","but you shall offer a burnt offering, an offering made by fire, a pleasant aroma to the LORD: one bull, one ram, seven male lambs a year old without defect; ");
INSERT INTO engwebpb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","their meal offering and their drink offerings for the bull, for the ram, and for the lambs, shall be according to their number, after the ordinance, ");
INSERT INTO engwebpb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","and one male goat for a sin offering, in addition to the continual burnt offering, with its meal offering, and its drink offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘You shall offer these to the LORD in your set feasts—in addition to your vows and your free will offerings—for your burnt offerings, your meal offerings, your drink offerings, and your peace offerings.’” ");
INSERT INTO engwebpb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moses told the children of Israel according to all that the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses spoke to the heads of the tribes of the children of Israel, saying, “This is the thing which the LORD has commanded. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","When a man vows a vow to the LORD, or swears an oath to bind his soul with a bond, he shall not break his word. He shall do according to all that proceeds out of his mouth. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Also, when a woman vows a vow to the LORD and binds herself by a pledge, being in her father’s house, in her youth, ");
INSERT INTO engwebpb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","and her father hears her vow and her pledge with which she has bound her soul, and her father says nothing to her, then all her vows shall stand, and every pledge with which she has bound her soul shall stand. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father forbids her in the day that he hears, none of her vows or of her pledges with which she has bound her soul, shall stand. The LORD will forgive her, because her father has forbidden her. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“If she has a husband, while her vows are on her, or the rash utterance of her lips with which she has bound her soul, ");
INSERT INTO engwebpb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","and her husband hears it, and says nothing to her in the day that he hears it; then her vows shall stand, and her pledges with which she has bound her soul shall stand. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if her husband forbids her in the day that he hears it, then he makes void her vow which is on her and the rash utterance of her lips, with which she has bound her soul. The LORD will forgive her. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“But the vow of a widow, or of her who is divorced, everything with which she has bound her soul shall stand against her. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“If she vowed in her husband’s house or bound her soul by a bond with an oath, ");
INSERT INTO engwebpb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","and her husband heard it, and held his peace at her and didn’t disallow her, then all her vows shall stand, and every pledge with which she bound her soul shall stand. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband made them null and void in the day that he heard them, then whatever proceeded out of her lips concerning her vows, or concerning the bond of her soul, shall not stand. Her husband has made them void. The LORD will forgive her. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Every vow, and every binding oath to afflict the soul, her husband may establish it, or her husband may make it void. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","But if her husband says nothing to her from day to day, then he establishes all her vows or all her pledges which are on her. He has established them, because he said nothing to her in the day that he heard them. ");
INSERT INTO engwebpb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","But if he makes them null and void after he has heard them, then he shall bear her iniquity.” ");
INSERT INTO engwebpb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the statutes which the LORD commanded Moses, between a man and his wife, between a father and his daughter, being in her youth, in her father’s house. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Avenge the children of Israel on the Midianites. Afterward you shall be gathered to your people.” ");
INSERT INTO engwebpb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moses spoke to the people, saying, “Arm men from amongst you for war, that they may go against Midian, to execute the LORD’s vengeance on Midian. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","You shall send one thousand out of every tribe, throughout all the tribes of Israel, to the war.” ");
INSERT INTO engwebpb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So there were delivered, out of the thousands of Israel, a thousand from every tribe, twelve thousand armed for war. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moses sent them, one thousand of every tribe, to the war with Phinehas the son of Eleazar the priest, to the war, with the vessels of the sanctuary and the trumpets for the alarm in his hand. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","They fought against Midian, as the LORD commanded Moses. They killed every male. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","They killed the kings of Midian with the rest of their slain: Evi, Rekem, Zur, Hur, and Reba, the five kings of Midian. They also killed Balaam the son of Beor with the sword. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The children of Israel took the women of Midian captive with their little ones; and all their livestock, all their flocks, and all their goods, they took as plunder. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","All their cities in the places in which they lived, and all their encampments, they burnt with fire. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","They took all the captives, and all the plunder, both of man and of animal. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","They brought the captives with the prey and the plunder, to Moses, and to Eleazar the priest, and to the congregation of the children of Israel, to the camp at the plains of Moab, which are by the Jordan at Jericho. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses and Eleazar the priest, with all the princes of the congregation, went out to meet them outside of the camp. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moses was angry with the officers of the army, the captains of thousands and the captains of hundreds, who came from the service of the war. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moses said to them, “Have you saved all the women alive? ");
INSERT INTO engwebpb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Behold, these caused the children of Israel, through the counsel of Balaam, to commit trespass against the LORD in the matter of Peor, and so the plague was amongst the congregation of the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Now therefore kill every male amongst the little ones, and kill every woman who has known man by lying with him. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","But all the girls, who have not known man by lying with him, keep alive for yourselves. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Encamp outside of the camp for seven days. Whoever has killed any person, and whoever has touched any slain, purify yourselves on the third day and on the seventh day, you and your captives. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","You shall purify every garment, and all that is made of skin, and all work of goats’ hair, and all things made of wood.” ");
INSERT INTO engwebpb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleazar the priest said to the men of war who went to the battle, “This is the statute of the law which the LORD has commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","However the gold, and the silver, the bronze, the iron, the tin, and the lead, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","everything that may withstand the fire, you shall make to go through the fire, and it shall be clean; nevertheless it shall be purified with the water for impurity. All that doesn’t withstand the fire you shall make to go through the water. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","You shall wash your clothes on the seventh day, and you shall be clean. Afterward you shall come into the camp.” ");
INSERT INTO engwebpb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","The LORD spoke to Moses, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Count the plunder that was taken, both of man and of animal, you, and Eleazar the priest, and the heads of the fathers’ households of the congregation; ");
INSERT INTO engwebpb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","and divide the plunder into two parts: between the men skilled in war, who went out to battle, and all the congregation. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Levy a tribute to the LORD of the men of war who went out to battle: one soul of five hundred; of the persons, of the cattle, of the donkeys, and of the flocks. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Take it from their half, and give it to Eleazar the priest, for the LORD’s wave offering. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Of the children of Israel’s half, you shall take one drawn out of every fifty, of the persons, of the cattle, of the donkeys, and of the flocks, of all the livestock, and give them to the Levites, who perform the duty of the LORD’s tabernacle.” ");
INSERT INTO engwebpb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moses and Eleazar the priest did as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Now the plunder, over and above the booty which the men of war took, was six hundred and seventy-five thousand sheep, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","seventy-two thousand head of cattle, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sixty-one thousand donkeys, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","and thirty-two thousand persons in all, of the women who had not known man by lying with him. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","The half, which was the portion of those who went out to war, was in number three hundred and thirty-seven thousand and five hundred sheep; ");
INSERT INTO engwebpb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","and the LORD’s tribute of the sheep was six hundred and seventy-five. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","The cattle were thirty-six thousand, of which the LORD’s tribute was seventy-two. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","The donkeys were thirty thousand and five hundred, of which the LORD’s tribute was sixty-one. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","The persons were sixteen thousand, of whom the LORD’s tribute was thirty-two persons. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses gave the tribute, which was the LORD’s wave offering, to Eleazar the priest, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Of the children of Israel’s half, which Moses divided off from the men who fought ");
INSERT INTO engwebpb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(now the congregation’s half was three hundred and thirty-seven thousand and five hundred sheep, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","thirty-six thousand head of cattle, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","thirty thousand and five hundred donkeys, ");
INSERT INTO engwebpb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","and sixteen thousand persons), ");
INSERT INTO engwebpb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","even of the children of Israel’s half, Moses took one drawn out of every fifty, both of man and of animal, and gave them to the Levites, who performed the duty of the LORD’s tabernacle, as the LORD commanded Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","The officers who were over the thousands of the army, the captains of thousands, and the captains of hundreds, came near to Moses. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","They said to Moses, “Your servants have taken the sum of the men of war who are under our command, and there lacks not one man of us. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","We have brought the LORD’s offering, what every man found: gold ornaments, armlets, bracelets, signet rings, earrings, and necklaces, to make atonement for our souls before the LORD.” ");
INSERT INTO engwebpb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses and Eleazar the priest took their gold, even all worked jewels. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","All the gold of the wave offering that they offered up to the LORD, of the captains of thousands, and of the captains of hundreds, was sixteen thousand and seven hundred and fifty shekels. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","The men of war had taken booty, every man for himself. ");
INSERT INTO engwebpb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moses and Eleazar the priest took the gold of the captains of thousands and of hundreds, and brought it into the Tent of Meeting for a memorial for the children of Israel before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Now the children of Reuben and the children of Gad had a very great multitude of livestock. They saw the land of Jazer, and the land of Gilead. Behold, the place was a place for livestock. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Then the children of Gad and the children of Reuben came and spoke to Moses, and to Eleazar the priest, and to the princes of the congregation, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo, and Beon, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","the land which the LORD struck before the congregation of Israel, is a land for livestock; and your servants have livestock.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","They said, “If we have found favour in your sight, let this land be given to your servants for a possession. Don’t bring us over the Jordan.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moses said to the children of Gad, and to the children of Reuben, “Shall your brothers go to war while you sit here? ");
INSERT INTO engwebpb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why do you discourage the heart of the children of Israel from going over into the land which the LORD has given them? ");
INSERT INTO engwebpb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Your fathers did so when I sent them from Kadesh Barnea to see the land. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","For when they went up to the valley of Eshcol, and saw the land, they discouraged the heart of the children of Israel, that they should not go into the land which the LORD had given them. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","The LORD’s anger burnt in that day, and he swore, saying, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Surely none of the men who came up out of Egypt, from twenty years old and upward, shall see the land which I swore to Abraham, to Isaac, and to Jacob; because they have not wholly followed me, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","except Caleb the son of Jephunneh the Kenizzite, and Joshua the son of Nun, because they have followed the LORD completely.’ ");
INSERT INTO engwebpb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","The LORD’s anger burnt against Israel, and he made them wander back and forth in the wilderness forty years, until all the generation who had done evil in the LORD’s sight was consumed. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Behold, you have risen up in your fathers’ place, an increase of sinful men, to increase the fierce anger of the LORD towards Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","For if you turn away from after him, he will yet again leave them in the wilderness; and you will destroy all these people.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","They came near to him, and said, “We will build sheepfolds here for our livestock, and cities for our little ones; ");
INSERT INTO engwebpb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","but we ourselves will be ready armed to go before the children of Israel, until we have brought them to their place. Our little ones shall dwell in the fortified cities because of the inhabitants of the land. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We will not return to our houses until the children of Israel have all received their inheritance. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","For we will not inherit with them on the other side of the Jordan and beyond, because our inheritance has come to us on this side of the Jordan eastward.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moses said to them: “If you will do this thing, if you will arm yourselves to go before the LORD to the war, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","and every one of your armed men will pass over the Jordan before the LORD until he has driven out his enemies from before him, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","and the land is subdued before the LORD; then afterward you shall return, and be clear of obligation to the LORD and to Israel. Then this land shall be your possession before the LORD. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“But if you will not do so, behold, you have sinned against the LORD; and be sure your sin will find you out. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Build cities for your little ones, and folds for your sheep; and do that which has proceeded out of your mouth.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","The children of Gad and the children of Reuben spoke to Moses, saying, “Your servants will do as my lord commands. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our little ones, our wives, our flocks, and all our livestock shall be there in the cities of Gilead; ");
INSERT INTO engwebpb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","but your servants will pass over, every man who is armed for war, before the LORD to battle, as my lord says.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","So Moses commanded concerning them to Eleazar the priest, and to Joshua the son of Nun, and to the heads of the fathers’ households of the tribes of the children of Israel. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moses said to them, “If the children of Gad and the children of Reuben will pass with you over the Jordan, every man who is armed to battle before the LORD, and the land is subdued before you, then you shall give them the land of Gilead for a possession; ");
INSERT INTO engwebpb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","but if they will not pass over with you armed, they shall have possessions amongst you in the land of Canaan.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","The children of Gad and the children of Reuben answered, saying, “As the LORD has said to your servants, so will we do. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will pass over armed before the LORD into the land of Canaan, and the possession of our inheritance shall remain with us beyond the Jordan.” ");
INSERT INTO engwebpb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moses gave to them, even to the children of Gad, and to the children of Reuben, and to the half-tribe of Manasseh the son of Joseph, the kingdom of Sihon king of the Amorites, and the kingdom of Og king of Bashan; the land, according to its cities and borders, even the cities of the surrounding land. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","The children of Gad built Dibon, Ataroth, Aroer, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-shophan, Jazer, Jogbehah, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah, and Beth Haran: fortified cities and folds for sheep. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","The children of Reuben built Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO engwebpb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, and Baal Meon, (their names being changed), and Sibmah. They gave other names to the cities which they built. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","The children of Machir the son of Manasseh went to Gilead, took it, and dispossessed the Amorites who were therein. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moses gave Gilead to Machir the son of Manasseh; and he lived therein. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair the son of Manasseh went and took its villages, and called them Havvoth Jair. ");
INSERT INTO engwebpb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah went and took Kenath and its villages, and called it Nobah, after his own name. ");
INSERT INTO engwebpb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","These are the journeys of the children of Israel, when they went out of the land of Egypt by their armies under the hand of Moses and Aaron. ");
INSERT INTO engwebpb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses wrote the starting points of their journeys by the commandment of the LORD. These are their journeys according to their starting points. ");
INSERT INTO engwebpb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","They travelled from Rameses in the first month, on the fifteenth day of the first month; on the next day after the Passover, the children of Israel went out with a high hand in the sight of all the Egyptians, ");
INSERT INTO engwebpb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","while the Egyptians were burying all their firstborn, whom the LORD had struck amongst them. The LORD also executed judgements on their gods. ");
INSERT INTO engwebpb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","The children of Israel travelled from Rameses, and encamped in Succoth. ");
INSERT INTO engwebpb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","