﻿USE sofia;
DROP TABLE IF EXISTS sofia.engtcent_vpl;
CREATE TABLE engtcent_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engtcent_vpl WRITE;
INSERT INTO engtcent_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","The book of the genealogy of Jesus Christ, the son of David, the son of Abraham. ");
INSERT INTO engtcent_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham was the father of Isaac, Isaac was the father of Jacob, Jacob was the father of Judah and his brothers, ");
INSERT INTO engtcent_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah was the father of Perez and Zerah by Tamar, Perez was the father of Hezron, Hezron was the father of Ram, ");
INSERT INTO engtcent_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram was the father of Amminadab, Amminadab was the father of Nahshon, Nahshon was the father of Salmon, ");
INSERT INTO engtcent_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon was the father of Boaz by Rahab, Boaz was the father of Obed by Ruth, Obed was the father of Jesse, ");
INSERT INTO engtcent_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","and Jesse was the father of David the king. David the king was the father of Solomon by the wife of Uriah, ");
INSERT INTO engtcent_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon was the father of Rehoboam, Rehoboam was the father of Abijah, Abijah was the father of Asa, ");
INSERT INTO engtcent_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa was the father of Jehoshaphat, Jehoshaphat was the father of Joram, Joram was the father of Uzziah, ");
INSERT INTO engtcent_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah was the father of Jotham, Jotham was the father of Ahaz, Ahaz was the father of Hezekiah, ");
INSERT INTO engtcent_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah was the father of Manasseh, Manasseh was the father of Amon, Amon was the father of Josiah, ");
INSERT INTO engtcent_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","and Josiah was the father of Jechoniah and his brothers, at the time of the Babylonian resettlement. ");
INSERT INTO engtcent_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","After the Babylonian resettlement, Jechoniah was the father of Shealtiel, Shealtiel was the father of Zerubbabel, ");
INSERT INTO engtcent_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel was the father of Abiud, Abiud was the father of Eliakim, Eliakim was the father of Azor, ");
INSERT INTO engtcent_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor was the father of Zadok, Zadok was the father of Achim, Achim was the father of Eliud, ");
INSERT INTO engtcent_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud was the father of Eleazar, Eleazar was the father of Matthan, Matthan was the father of Jacob, ");
INSERT INTO engtcent_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","and Jacob was the father of Joseph the husband of Mary, of whom was born Jesus, who is called Christ. ");
INSERT INTO engtcent_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","So in all there were fourteen generations from Abraham to David, fourteen generations from David to the Babylonian resettlement, and fourteen generations from the Babylonian resettlement to the Christ. ");
INSERT INTO engtcent_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Now the birth of Jesus Christ took place in this way. When his mother Mary had been betrothed to Joseph, before they came together, she was found to be with child from the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Because her husband Joseph was a righteous man and did not want to shame her publicly, he intended to send her away privately. ");
INSERT INTO engtcent_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","But as he thought about these things, behold, an angel of the Lord appeared to him in a dream and said, “Joseph, Son of David, do not be afraid to receive Mary as yoʋr wife, for the child that is conceived in her is from the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","She will give birth to a son, and yoʋ shall name him Jesus, for he will save his people from their sins.” ");
INSERT INTO engtcent_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","All this took place to fulfill what the Lord had spoken through the prophet: ");
INSERT INTO engtcent_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Behold, the virgin will conceive and give birth to a son, and they will name him Immanuel” (which means, “God with us”). ");
INSERT INTO engtcent_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","When Joseph woke from his sleep, he did as the angel of the Lord had commanded him. He took his wife ");
INSERT INTO engtcent_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","but had no marital relations with her until she had given birth to her firstborn son. And he named him Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","After Jesus was born in Bethlehem of Judea, in the days of Herod the king, behold, wise men from the east arrived in Jerusalem, ");
INSERT INTO engtcent_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","saying, “Where is the child who has been born king of the Jews? For we saw his star in the east and have come to worship him.” ");
INSERT INTO engtcent_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","When Herod the king heard this, he was troubled, and all Jerusalem with him. ");
INSERT INTO engtcent_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","So he assembled all the chief priests and scribes of the people, and inquired of them where the Christ was to be born. ");
INSERT INTO engtcent_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","They told him, “In Bethlehem of Judea, for so it is written by the prophet, ");
INSERT INTO engtcent_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘But yoʋ Bethlehem, in the land of Judah, are by no means least among the rulers of Judah; for from yoʋ will come a ruler who will shepherd my people Israel.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Then Herod secretly called the wise men and ascertained from them what time the star had appeared. ");
INSERT INTO engtcent_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","He sent them to Bethlehem and said, “Go search diligently for the child, and when you have found him, bring me word so that I too may go and worship him.” ");
INSERT INTO engtcent_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","They listened to the king and went on their way, and behold, the star they had seen in the east went before them until it came and stopped over the place where the child was. ");
INSERT INTO engtcent_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","When they saw the star, they rejoiced with exceedingly great joy. ");
INSERT INTO engtcent_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","As they came into the house and saw the child with his mother Mary, they fell down and worshiped him. Then they opened their treasures and offered him gifts: gold, frankincense, and myrrh. ");
INSERT INTO engtcent_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","And being warned in a dream not to return to Herod, they departed for their own country by another way. ");
INSERT INTO engtcent_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","After they were gone, behold, an angel of the Lord appeared to Joseph in a dream, saying, “Rise, take the child and his mother and flee to Egypt, and stay there until I tell yoʋ, for Herod is about to seek the child, to destroy him.” ");
INSERT INTO engtcent_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","So Joseph rose, took the child and his mother by night, and departed for Egypt, ");
INSERT INTO engtcent_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","where he stayed until the death of Herod. This was to fulfill what the Lord had said through the prophet: “Out of Egypt I called my son.” ");
INSERT INTO engtcent_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","When Herod saw that he had been fooled by the wise men, he was greatly enraged and sent men to kill all the boys in Bethlehem and in its vicinity who were two years old and under, according to the time that he had ascertained from the wise men. ");
INSERT INTO engtcent_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Then what had been spoken by the prophet Jeremiah was fulfilled: ");
INSERT INTO engtcent_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A voice was heard in Ramah, wailing, weeping, and great lamentation, Rachel weeping for her children, and she refused to be comforted, because they are no more.” ");
INSERT INTO engtcent_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","After Herod died, behold, an angel of the Lord appeared in a dream to Joseph in Egypt, ");
INSERT INTO engtcent_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","saying, “Rise, take the child and his mother, and go to the land of Israel, for those who were seeking the child's life are dead.” ");
INSERT INTO engtcent_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","So Joseph rose, took the child and his mother, and went to the land of Israel. ");
INSERT INTO engtcent_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","But when he heard that Archelaus was reigning over Judea in place of his father Herod, he was afraid to go there. And being warned in a dream, he withdrew to the district of Galilee ");
INSERT INTO engtcent_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","and came and dwelt in a town called Nazareth, so that what had been spoken by the prophets might be fulfilled: “He will be called a Nazarene.” ");
INSERT INTO engtcent_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","In those days John the Baptist came preaching in the wilderness of Judea, saying, ");
INSERT INTO engtcent_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Repent, for the kingdom of heaven has drawn near.” ");
INSERT INTO engtcent_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","This is the one who was spoken of by the prophet Isaiah, who said, “The voice of one crying out in the wilderness, ‘Prepare the way for the Lord; make his paths straight.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Now John wore a garment of camel's hair and a leather belt around his waist, and his food was locusts and wild honey. ");
INSERT INTO engtcent_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Then Jerusalem was going out to him, and so were all Judea and all the region around the Jordan. ");
INSERT INTO engtcent_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","They were being baptized by him in the Jordan, confessing their sins. ");
INSERT INTO engtcent_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","But when John saw many of the Pharisees and Sadducees coming to his baptism, he said to them, “You brood of vipers, who warned you to flee from the coming wrath? ");
INSERT INTO engtcent_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Produce fruit consistent with repentance. ");
INSERT INTO engtcent_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","And do not think that you can say to yourselves, ‘We have Abraham as our father,’ for I tell you that God is able from these stones to raise up children for Abraham. ");
INSERT INTO engtcent_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Even now the axe is laid to the root of the trees. Every tree therefore that does not produce good fruit is cut down and thrown into the fire. ");
INSERT INTO engtcent_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“I baptize you with water for repentance, but he who is coming after me is mightier than I, whose sandals I am not worthy to carry. He will baptize you with the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","His winnowing fork is in his hand, and he will thoroughly clean out his threshing floor and gather his wheat into the barn, but the chaff he will burn up with unquenchable fire.” ");
INSERT INTO engtcent_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Then Jesus came from Galilee to the Jordan to be baptized by John. ");
INSERT INTO engtcent_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","But John tried to prevent him, saying, “I need to be baptized by yoʋ, and yet yoʋ are coming to me?” ");
INSERT INTO engtcent_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","But Jesus answered him, “Permit it for now, for thus it is fitting for us to fulfill all righteousness.” Then John permitted him. ");
INSERT INTO engtcent_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","After being baptized, Jesus immediately went up from the water. And behold, the heavens were opened to him, and he saw the Spirit of God descending like a dove and alighting on him. ");
INSERT INTO engtcent_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","And behold, a voice from heaven said, “This is my beloved Son, in whom I am well pleased.” ");
INSERT INTO engtcent_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Then Jesus was led up into the wilderness by the Spirit to be tempted by the devil. ");
INSERT INTO engtcent_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","After fasting for forty days and forty nights, he was hungry. ");
INSERT INTO engtcent_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Then the tempter came up to him and said, “If yoʋ are the Son of God, command these stones to become bread.” ");
INSERT INTO engtcent_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","But Jesus answered, “It is written, ‘Man shall not live by bread alone, but by every word that comes from the mouth of God.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Then the devil took him to the holy city, set him on the pinnacle of the temple, ");
INSERT INTO engtcent_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","and said to him, “If yoʋ are the Son of God, throw yoʋrself down, for it is written, ‘He will command his angels concerning yoʋ,’ and, ‘In their hands they will lift yoʋ up, so that yoʋ do not strike yoʋr foot against a stone.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus said to him, “Again it is written, ‘Yoʋ shall not put the Lord yoʋr God to the test.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Again, the devil took him to a very high mountain and showed him all the kingdoms of the world and their glory. ");
INSERT INTO engtcent_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","And he said to him, “All these things I will give yoʋ, if yoʋ will fall down and worship me.” ");
INSERT INTO engtcent_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Then Jesus said to him, “Get behind me, Satan! For it is written, ‘Yoʋ shall worship the Lord yoʋr God, and him only shall yoʋ serve.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Then the devil left him, and behold, angels came and ministered to him. ");
INSERT INTO engtcent_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Now when Jesus heard that John had been put in prison, he withdrew to Galilee. ");
INSERT INTO engtcent_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","And leaving Nazareth, he went and dwelt at Capernaum by the sea, in the region of Zebulun and Naphtali, ");
INSERT INTO engtcent_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","so that what had been spoken by the prophet Isaiah might be fulfilled: ");
INSERT INTO engtcent_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Land of Zebulun and land of Naphtali, way of the sea, beyond the Jordan, Galilee of the Gentiles, ");
INSERT INTO engtcent_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","the people sitting in darkness have seen a great light, and on those sitting in the region and shadow of death light has dawned.” ");
INSERT INTO engtcent_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","From that time Jesus began to preach, “Repent, for the kingdom of heaven has drawn near.” ");
INSERT INTO engtcent_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","As Jesus was walking by the Sea of Galilee, he saw two brothers, Simon (who is called Peter) and Andrew his brother, casting a net into the sea, for they were fishermen. ");
INSERT INTO engtcent_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus said to them, “Follow me, and I will make you fishers of men.” ");
INSERT INTO engtcent_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","So they immediately left their nets and followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Going on from there, he saw two other brothers, James the son of Zebedee and John his brother, in the boat with their father Zebedee, mending their nets, and he called them. ");
INSERT INTO engtcent_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","So they immediately left the boat and their father and followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Then Jesus went throughout all of Galilee, teaching in their synagogues, preaching the gospel of the kingdom, and healing every disease and every sickness among the people. ");
INSERT INTO engtcent_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","So the news about him went out into all of Syria, and the people brought to him all who were sick with various diseases, those suffering severe pain, the demon-possessed, epileptics, and paralytics. And he healed them. ");
INSERT INTO engtcent_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","And large crowds followed him from Galilee, the Decapolis, Jerusalem, Judea, and from beyond the Jordan. ");
INSERT INTO engtcent_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","When Jesus saw the crowds, he went up on the mountain. And when he sat down, his disciples came to him. ");
INSERT INTO engtcent_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Then he opened his mouth and taught them, saying, ");
INSERT INTO engtcent_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blessed are the poor in spirit, for theirs is the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blessed are those who mourn, for they will be comforted. ");
INSERT INTO engtcent_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blessed are the meek, for they will inherit the earth. ");
INSERT INTO engtcent_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blessed are those who hunger and thirst for righteousness, for they will be filled. ");
INSERT INTO engtcent_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blessed are the merciful, for they will receive mercy. ");
INSERT INTO engtcent_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blessed are the pure in heart, for they will see God. ");
INSERT INTO engtcent_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blessed are the peacemakers, for they will be called sons of God. ");
INSERT INTO engtcent_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blessed are those who are persecuted for righteousness' sake, for theirs is the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Blessed are you when others reproach you, persecute you, and say all kinds of evil against you falsely on my account. ");
INSERT INTO engtcent_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rejoice and be glad, for great is your reward in heaven; for in the same way they persecuted the prophets who were before you. ");
INSERT INTO engtcent_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“You are the salt of the earth, but if salt loses its flavor, with what shall it be seasoned? It is no longer fit for anything but to be thrown out and trampled under people's feet. ");
INSERT INTO engtcent_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“You are the light of the world. A city set on a hill cannot be hidden, ");
INSERT INTO engtcent_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","nor do people light a lamp and put it under a basket, but on a lampstand, and it shines for all who are in the house. ");
INSERT INTO engtcent_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Let your light shine before others in such a way that they may see your good works and glorify your Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Do not think that I have come to abolish the Law or the Prophets. I have not come to abolish them, but to fulfill them. ");
INSERT INTO engtcent_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","For truly I say to you, until heaven and earth pass away, not one letter or stroke of a letter will by any means pass from the law until all is accomplished. ");
INSERT INTO engtcent_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Therefore whoever does away with one of the least of these commandments and teaches others to do likewise will be called least in the kingdom of heaven, but whoever practices them and teaches them will be called great in the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","For I tell you, unless your righteousness surpasses that of the scribes and Pharisees, you will certainly not enter the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“You have heard that it was said to those of old, ‘Yoʋ shall not murder,’ and, ‘Whoever murders will be subject to judgment.’ ");
INSERT INTO engtcent_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","But I say to you that everyone who is rashly angry with his brother will be subject to judgment. Whoever says to his brother, ‘Yoʋ idiot,’ will be subject to the Sanhedrin. And whoever says, ‘Yoʋ fool,’ will be subject to the fires of hell. ");
INSERT INTO engtcent_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","So if yoʋ are offering yoʋr gift at the altar and there remember that yoʋr brother has something against yoʋ, ");
INSERT INTO engtcent_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","leave yoʋr gift there before the altar and go. First be reconciled to yoʋr brother, and then come and offer yoʋr gift. ");
INSERT INTO engtcent_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Make friends with yoʋr adversary quickly while yoʋ are on the way with him, lest yoʋr adversary hand yoʋ over to the judge, and the judge hand yoʋ over to the guard, and yoʋ be thrown into prison. ");
INSERT INTO engtcent_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Truly I say to yoʋ, yoʋ will certainly not come out of there until yoʋ have paid the last penny. ");
INSERT INTO engtcent_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“You have heard that it was said, ‘Yoʋ shall not commit adultery.’ ");
INSERT INTO engtcent_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","But I say to you that anyone who looks at a woman to lust after her has already committed adultery with her in his heart. ");
INSERT INTO engtcent_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","So if yoʋr right eye causes yoʋ to stumble, pluck it out and throw it away from yoʋ. For it is better for yoʋ to have one of yoʋr members perish, than for yoʋr whole body to be thrown into hell. ");
INSERT INTO engtcent_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","And if yoʋr right hand causes yoʋ to stumble, cut it off and throw it away from yoʋ. For it is better for yoʋ to have one of yoʋr members perish, than for yoʋr whole body to be thrown into hell. ");
INSERT INTO engtcent_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“It was also said, ‘Whoever divorces his wife must give her a certificate of divorce.’ ");
INSERT INTO engtcent_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","But I say to you that whoever divorces his wife, apart from a matter of fornication, makes her commit adultery. And whoever marries a divorced woman commits adultery. ");
INSERT INTO engtcent_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Again, you have heard that it was said to those of old, ‘Yoʋ shall not break an oath, but shall keep yoʋr oaths to the Lord.’ ");
INSERT INTO engtcent_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","But I say to you, do not swear at all, neither by heaven, for it is the throne of God; ");
INSERT INTO engtcent_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nor by the earth, for it is the footstool of his feet; nor by Jerusalem, for it is the city of the great King. ");
INSERT INTO engtcent_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neither shall yoʋ swear by yoʋr head, for yoʋ cannot make one hair white or black. ");
INSERT INTO engtcent_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","But let your ‘Yes’ be ‘Yes’ and your ‘No’ be ‘No’; for whatever is more than these is from the evil one. ");
INSERT INTO engtcent_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“You have heard that it was said, ‘An eye for an eye and a tooth for a tooth.’ ");
INSERT INTO engtcent_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","But I say to you, do not resist one who is evil. Rather, if anyone slaps yoʋ on yoʋr right cheek, turn to him the other also. ");
INSERT INTO engtcent_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","If anyone wants to sue yoʋ and take away yoʋr tunic, let him have yoʋr cloak also. ");
INSERT INTO engtcent_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","And if anyone presses yoʋ into service for one mile, go with him two. ");
INSERT INTO engtcent_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Give to everyone who asks of yoʋ, and do not turn away from anyone who wants to borrow from yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“You have heard that it was said, ‘Yoʋ shall love yoʋr neighbor and hate yoʋr enemy.’ ");
INSERT INTO engtcent_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","But I say to you, love your enemies, bless those who curse you, do good to those who hate you, and pray for those who mistreat you and persecute you, ");
INSERT INTO engtcent_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","so that you may be sons of your Father in heaven. For he makes his sun rise on the evil and the good, and sends rain on the righteous and the unrighteous. ");
INSERT INTO engtcent_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","For if you love those who love you, what reward do you have? Do not even the tax collectors do the same? ");
INSERT INTO engtcent_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","And if you greet only your friends, what are you doing that is out of the ordinary? Do not even the tax collectors do that? ");
INSERT INTO engtcent_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","You therefore shall be perfect, just as your Father in heaven is perfect. ");
INSERT INTO engtcent_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Be careful not to give to the needy in front of others to be seen by them, otherwise you have no reward from your Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","So when yoʋ give to the needy, do not sound a trumpet before yoʋ, as the hypocrites do in the synagogues and in the streets, so that they may be praised by others. Truly I say to you, they have received their reward. ");
INSERT INTO engtcent_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","But when yoʋ give to the needy, do not let yoʋr left hand know what yoʋr right hand is doing, ");
INSERT INTO engtcent_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","so that yoʋr giving may be in secret. Then yoʋr Father who sees in secret will himself reward yoʋ openly. ");
INSERT INTO engtcent_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“When yoʋ pray, do not be like the hypocrites. For they love to pray standing in the synagogues and at the street corners so that they may be seen by others. Truly I say to you, they have received their reward. ");
INSERT INTO engtcent_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","But when yoʋ pray, go into yoʋr inner room, shut yoʋr door, and pray to yoʋr Father who is in secret. Then yoʋr Father who sees in secret will reward yoʋ openly. ");
INSERT INTO engtcent_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“And when you pray, do not babble on repetitiously like the Gentiles do, for they think they will be heard because of their use of many words. ");
INSERT INTO engtcent_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Do not be like them, for your Father knows what you need before you ask him. ");
INSERT INTO engtcent_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pray then like this: Our Father in heaven, hallowed be yoʋr name. ");
INSERT INTO engtcent_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yoʋr kingdom come. Yoʋr will be done, on earth as it is in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Give us this day our daily bread. ");
INSERT INTO engtcent_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","And forgive us our debts, as we forgive our debtors. ");
INSERT INTO engtcent_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","And lead us not into temptation, but deliver us from evil. For yoʋrs is the kingdom and the power and the glory forever. Amen. ");
INSERT INTO engtcent_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","For if you forgive others their trespasses, your heavenly Father will also forgive you. ");
INSERT INTO engtcent_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","But if you do not forgive others their trespasses, neither will your Father forgive your trespasses. ");
INSERT INTO engtcent_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“When you fast, do not be gloomy like the hypocrites, for they disfigure their faces so that others will see that they are fasting. Truly I say to you, they have received their reward. ");
INSERT INTO engtcent_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","But when yoʋ fast, anoint yoʋr head and wash yoʋr face, ");
INSERT INTO engtcent_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","so that no one will see that yoʋ are fasting except yoʋr Father who is in secret. Then yoʋr Father who sees in secret will reward yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Do not store up treasures on earth, where moth and rust destroy, and where thieves break in and steal. ");
INSERT INTO engtcent_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","But store up treasures in heaven, where neither moth nor rust destroys, and where thieves do not break in and steal. ");
INSERT INTO engtcent_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","For where your treasure is, there will your heart be also. ");
INSERT INTO engtcent_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“The lamp of the body is the eye. If then yoʋr eye is clear, yoʋr whole body will be full of light. ");
INSERT INTO engtcent_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","But if yoʋr eye is bad, yoʋr whole body will be full of darkness. If then the light within yoʋ is darkness, how great is the darkness! ");
INSERT INTO engtcent_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“No one can serve two masters, for either he will hate one and love the other, or he will be devoted to one and despise the other. You cannot serve God and money. ");
INSERT INTO engtcent_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Therefore I tell you, do not be anxious about your life, what you will eat and what you will drink, or about your body, what you will wear. Is not life more than food and the body more than clothing? ");
INSERT INTO engtcent_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Look at the birds of the sky: They do not sow or reap or gather into barns, yet your heavenly Father feeds them. Are you not of more value than they? ");
INSERT INTO engtcent_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Which of you by being anxious can add a single moment to yoʋr span of life? ");
INSERT INTO engtcent_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","And why are you anxious about clothing? Consider the lilies of the field, how they grow: They do not toil or spin, ");
INSERT INTO engtcent_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","yet I tell you that not even Solomon in all his glory was clothed like one of these. ");
INSERT INTO engtcent_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Now if God so clothes the grass of the field, which is alive today and tomorrow is thrown into the oven, will he not much more clothe you, O you of little faith? ");
INSERT INTO engtcent_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Therefore do not be anxious, saying, ‘What will we eat?’ or, ‘What will we drink?’ or, ‘What will we wear?’ ");
INSERT INTO engtcent_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","For the Gentiles seek after all these things, and your heavenly Father knows that you need them all. ");
INSERT INTO engtcent_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","But seek first the kingdom of God and his righteousness, and all these things will be added to you. ");
INSERT INTO engtcent_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Therefore do not be anxious about tomorrow, for tomorrow will be anxious about its own matters. Sufficient for the day is its own trouble. ");
INSERT INTO engtcent_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Do not judge, so that you will not be judged. ");
INSERT INTO engtcent_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","For with the judgment you pronounce you will be judged, and with the measure you use it will be measured to you. ");
INSERT INTO engtcent_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Why do yoʋ see the speck in yoʋr brother's eye, but do not consider the beam in yoʋr own eye? ");
INSERT INTO engtcent_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Or how will yoʋ say to yoʋr brother, ‘Let me take the speck out of yoʋr eye,’ when there is a beam in yoʋr own eye? ");
INSERT INTO engtcent_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hypocrite! First take the beam out of yoʋr own eye, and then yoʋ will see clearly to take the speck out of yoʋr brother's eye. ");
INSERT INTO engtcent_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Do not give what is holy to dogs, and do not throw your pearls before pigs, lest they trample them with their feet, and then turn and tear you to pieces. ");
INSERT INTO engtcent_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ask, and it will be given to you; seek, and you will find; knock, and the door will be opened for you. ");
INSERT INTO engtcent_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","For everyone who asks receives; and he who seeks finds; and for him who knocks, the door will be opened. ");
INSERT INTO engtcent_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Or what man is there among you, who, if his son asks him for bread, will give him a stone; ");
INSERT INTO engtcent_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","and if he asks for a fish, will give him a serpent? ");
INSERT INTO engtcent_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","If you then, being evil, know how to give good gifts to your children, how much more will your Father in heaven give good things to those who ask him! ");
INSERT INTO engtcent_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Therefore whatever you wish that others would do to you, do the same also to them, for this is the Law and the Prophets. ");
INSERT INTO engtcent_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Enter through the narrow gate, for wide is the gate, and broad is the way that leads to destruction, and there are many who enter through it. ");
INSERT INTO engtcent_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","How narrow is the gate, and restricted the way that leads to life, and there are few who find it! ");
INSERT INTO engtcent_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Beware of false prophets, who come to you in sheep's clothing but inwardly are ravenous wolves. ");
INSERT INTO engtcent_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","By their fruits you will know them. Do people gather grapes from thorns, or figs from thistles? ");
INSERT INTO engtcent_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","In the same way, every good tree produces good fruit, but a bad tree produces bad fruit. ");
INSERT INTO engtcent_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A good tree cannot produce bad fruit, neither can a bad tree produce good fruit. ");
INSERT INTO engtcent_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Every tree that does not produce good fruit is cut down and thrown into the fire. ");
INSERT INTO engtcent_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Therefore by their fruits you will know them. ");
INSERT INTO engtcent_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Not everyone who says to me, ‘Lord, Lord,’ will enter the kingdom of heaven, but only he who does the will of my Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Many will say to me on that day, ‘Lord, Lord, did we not prophesy in yoʋr name, and in yoʋr name cast out demons, and in yoʋr name do many miracles?’ ");
INSERT INTO engtcent_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Then I will declare to them, ‘I never knew you; depart from me, you who practice lawlessness.’ ");
INSERT INTO engtcent_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Everyone then who hears these words of mine and does them I will compare to a wise man who built his house on the rock. ");
INSERT INTO engtcent_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","The rain fell, the floods came, and the winds blew and beat on that house, but it did not fall, for it was founded on the rock. ");
INSERT INTO engtcent_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","But everyone who hears these words of mine and does not do them will be compared to a foolish man who built his house on the sand. ");
INSERT INTO engtcent_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","The rain fell, the floods came, and the winds blew and beat against that house, and it fell, and great was its fall.” ");
INSERT INTO engtcent_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","When Jesus finished saying these things, the crowds were astonished at his teaching, ");
INSERT INTO engtcent_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","because he was teaching them as one who had authority, and not as the scribes. ");
INSERT INTO engtcent_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","When Jesus came down from the mountain, large crowds followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","And behold, a leper came and bowed down before him, saying, “Lord, if yoʋ are willing, yoʋ can make me clean.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","So Jesus stretched out his hand and touched him, saying, “I am willing; be made clean.” Immediately his leprosy was cleansed. ");
INSERT INTO engtcent_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Then Jesus said to him, “Be sure not to tell anyone about this, but go show yoʋrself to the priest, and offer the gift that Moses commanded, as a testimony to them.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","When Jesus entered Capernaum, a centurion came to him and pleaded with him, ");
INSERT INTO engtcent_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","saying, “Lord, my servant is lying paralyzed at home, suffering terribly.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus said to him, “I will come and heal him.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","But the centurion replied, “Lord, I am not worthy to have yoʋ enter under my roof, but just say the word, and my servant will be healed. ");
INSERT INTO engtcent_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","For I too am a man under authority, with soldiers under me. I say to this one, ‘Go,’ and he goes; and to another, ‘Come,’ and he comes; and to my servant, ‘Do this,’ and he does it.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","When Jesus heard this, he was amazed and said to those who were following him, “Truly I say to you, not even in Israel have I found such great faith. ");
INSERT INTO engtcent_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","I tell you that many will come from east and west, and recline with Abraham, Isaac, and Jacob at the banquet table in the kingdom of heaven, ");
INSERT INTO engtcent_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","but the sons of the kingdom will be cast into the outer darkness; in that place there will be weeping and gnashing of teeth.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Then Jesus said to the centurion, “Go; it will be done for you just as yoʋ have believed.” And his servant was healed in that hour. ");
INSERT INTO engtcent_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","When Jesus came into Peter's house, he saw Peter's mother-in-law lying in bed with a fever. ");
INSERT INTO engtcent_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","So he touched her hand, and the fever left her. Then she rose and began to serve him. ");
INSERT INTO engtcent_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","When evening came, many who were possessed by demons were brought to him, and he cast out the spirits with a word and healed all who were sick. ");
INSERT INTO engtcent_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","This was to fulfill what had been spoken by the prophet Isaiah: “He took our infirmities and bore our diseases.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","When Jesus saw the large crowds around him, he gave orders to depart to the other side of the sea. ");
INSERT INTO engtcent_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Then a scribe came up and said to him, “Teacher, I will follow yoʋ wherever yoʋ go.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus said to him, “Foxes have holes, and the birds of the sky have nests, but the Son of Man has nowhere to lay his head.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Then another of his disciples said to him, “Lord, let me first go and bury my father.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","But Jesus said to him, “Follow me, and let the dead bury their own dead.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Then he got into the boat, and his disciples followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","And behold, a great storm arose on the sea, so that the boat was being swamped by the waves. But Jesus was asleep. ");
INSERT INTO engtcent_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","So the disciples came to him and woke him, saying, “Lord, save us! We are perishing!” ");
INSERT INTO engtcent_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","But he said to them, “Why are you afraid, O you of little faith?” Then he rose and rebuked the winds and the sea, and there was a great calm. ");
INSERT INTO engtcent_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","And the men were amazed, saying, “What kind of man is this, that even the winds and the sea obey him?” ");
INSERT INTO engtcent_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","When Jesus came to the other side of the sea, to the region of the Gergesenes, he was met by two demon-possessed men who had come out of the tombs. They were so fierce that no one could pass by that way. ");
INSERT INTO engtcent_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","And behold, they cried out, “What do yoʋ have to do with us, Jesus, Son of God? Have yoʋ come here to torment us before the appointed time?” ");
INSERT INTO engtcent_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Now at a distance from them there was a herd of many pigs feeding. ");
INSERT INTO engtcent_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","So the demons begged Jesus, “If yoʋ cast us out, let us go into the herd of pigs.” ");
INSERT INTO engtcent_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","He said to them, “Go.” So they came out and went into the herd of pigs, and behold, the whole herd of pigs rushed down the steep bank into the sea and died in the water. ");
INSERT INTO engtcent_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Those who had been feeding the pigs then ran off, went into the city, and reported everything, including what had happened to the demon-possessed men. ");
INSERT INTO engtcent_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","And behold, the whole city went out to meet Jesus. And when they saw him, they begged him to depart from their region. ");
INSERT INTO engtcent_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","After getting into the boat, Jesus went back across the sea and came to his own city. ");
INSERT INTO engtcent_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","And behold, some men brought to him a paralytic lying on a bed. When Jesus saw their faith, he said to the paralytic, “Take courage, son; yoʋr sins are forgiven yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","And behold, some of the scribes said to themselves, “This man is blaspheming.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Perceiving their thoughts, Jesus said, “Why are you thinking evil things in your hearts? ");
INSERT INTO engtcent_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Which is easier, to say, ‘Yoʋr sins are forgiven,’ or to say, ‘Rise and walk’? ");
INSERT INTO engtcent_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","But so that you may know that the Son of Man has authority on earth to forgive sins”—then he said to the paralytic—“Rise, pick up yoʋr bed, and go to yoʋr house.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","So he rose and went to his house. ");
INSERT INTO engtcent_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","When the crowds saw it, they were amazed and glorified God, who had given such authority to men. ");
INSERT INTO engtcent_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","As Jesus went on from there, he saw a man named Matthew sitting at the tax booth. Jesus said to him, “Follow me,” so Matthew rose and followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Later, as Jesus reclined at the table in Matthew's house, behold, many tax collectors and sinners came and reclined with him and his disciples. ");
INSERT INTO engtcent_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","When the Pharisees saw this, they said to his disciples, “Why is your teacher eating with tax collectors and sinners?” ");
INSERT INTO engtcent_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","When Jesus heard this, he said to them, “It is not the healthy who need a physician, but the sick. ");
INSERT INTO engtcent_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Go and learn what this means: ‘I desire mercy and not sacrifice,’ for I did not come to call the righteous, but sinners to repentance.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Then the disciples of John came to Jesus and said, “Why is it that we and the Pharisees fast often, but yoʋr disciples do not fast?” ");
INSERT INTO engtcent_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus said to them, “Can the bridegroom's attendants mourn as long as the bridegroom is with them? But the days are coming when the bridegroom will be taken away from them, and then they will fast. ");
INSERT INTO engtcent_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","No one puts a piece of unshrunk cloth on an old garment, for the patch would pull away from the garment, and a worse tear would be made. ");
INSERT INTO engtcent_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Neither do people put new wine into old wineskins. For the wineskins would burst, spilling the wine and ruining the wineskins. But new wine is put into new wineskins, and both are preserved.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","As he said these things to them, behold, a ruler came and bowed down before him, saying, “My daughter has just now died, but come and lay yoʋr hand on her, and she will live.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","So Jesus rose and followed him, and so did his disciples. ");
INSERT INTO engtcent_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","And behold, a woman who had suffered from a flow of blood for twelve years came up behind him and touched the fringe of his garment. ");
INSERT INTO engtcent_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","For she said to herself, “If only I touch his garment, I will be healed.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","But when Jesus turned around and saw her, he said, “Take courage, daughter; yoʋr faith has healed yoʋ.” And the woman was healed from that hour. ");
INSERT INTO engtcent_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","When Jesus came to the house of the ruler and saw the flute players and the crowd making a commotion, ");
INSERT INTO engtcent_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","he said to them, “Go away, for the girl is not dead but sleeping.” And they began laughing at him. ");
INSERT INTO engtcent_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","But when the crowd had been put outside, he went in and took hold of the girl's hand, and she arose. ");
INSERT INTO engtcent_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","And news of this spread throughout that entire region. ");
INSERT INTO engtcent_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","As Jesus went on from there, two blind men followed him, crying out, “Have mercy on us, Son of David!” ");
INSERT INTO engtcent_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","When he went into the house, the blind men came to him, and Jesus said to them, “Do you believe that I am able to do this?” They said to him, “Yes, Lord.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Then he touched their eyes, saying, “Let it be done for yoʋ according to your faith.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","And their eyes were opened. Then Jesus sternly warned them, “Make sure no one finds out about this.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","But they went out and spread the news about him throughout that entire region. ");
INSERT INTO engtcent_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","As they were going away, behold, a mute man possessed by a demon was brought to Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","When the demon had been cast out, the mute man spoke, and the crowds were amazed, saying, “Such a thing has never been seen in Israel.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","But the Pharisees said, “By the ruler of demons he casts out demons.” ");
INSERT INTO engtcent_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Then Jesus went throughout all the cities and villages, teaching in their synagogues, preaching the gospel of the kingdom, and healing every disease and every sickness among the people. ");
INSERT INTO engtcent_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","When he saw the crowds, he was moved with compassion for them, because they were harassed and helpless, like sheep without a shepherd. ");
INSERT INTO engtcent_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Then he said to his disciples, “The harvest is plentiful, but the workers are few. ");
INSERT INTO engtcent_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Therefore ask the Lord of the harvest to send out workers into his harvest.” ");
INSERT INTO engtcent_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Then Jesus summoned his twelve disciples and gave them authority to cast out unclean spirits and to heal every disease and every sickness. ");
INSERT INTO engtcent_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Now these are the names of the twelve apostles: first, Simon, who is called Peter, and Andrew his brother; James the son of Zebedee, and John his brother; ");
INSERT INTO engtcent_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip and Bartholomew; Thomas and Matthew the tax collector; James the son of Alphaeus, and Lebbaeus, who was given the name Thaddaeus; ");
INSERT INTO engtcent_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon the Cananite, and Judas Iscariot, who betrayed him. ");
INSERT INTO engtcent_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","These twelve Jesus sent out, instructing them, “Do not go anywhere among the Gentiles, and do not enter any town of the Samaritans, ");
INSERT INTO engtcent_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","but go rather to the lost sheep of the house of Israel. ");
INSERT INTO engtcent_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","As you go, preach that the kingdom of heaven has drawn near. ");
INSERT INTO engtcent_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Heal the sick, cleanse lepers, and cast out demons. Freely you have received; freely give. ");
INSERT INTO engtcent_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Take no gold, silver, or copper in your belts. ");
INSERT INTO engtcent_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Take no knapsack for your journey, no extra tunic, sandals, or staffs, for the worker is worthy of his food. ");
INSERT INTO engtcent_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Whenever you enter a town or village, inquire who in it is worthy, and stay there until you leave that place. ");
INSERT INTO engtcent_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","As you enter the house, greet the people who live there. ");
INSERT INTO engtcent_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","If the household is worthy, let your peace come upon it; but if it is not worthy, let your peace return to you. ");
INSERT INTO engtcent_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","If anyone will not receive you or listen to your words, shake off the dust from your feet as you go out from that house or town. ");
INSERT INTO engtcent_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Truly I say to you, it will be more tolerable on the day of judgment for the land of Sodom and Gomorrah than for that town. ");
INSERT INTO engtcent_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Behold, I am sending you out like sheep in the midst of wolves, so be as wise as serpents and as innocent as doves. ");
INSERT INTO engtcent_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","But beware of men, for they will deliver you up to councils and flog you in their synagogues. ");
INSERT INTO engtcent_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","For my sake you will even be brought before governors and kings as witnesses to them and to the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","When they hand you over, do not be anxious about how to speak or what to say, for what you are to say will be given to you in that hour. ");
INSERT INTO engtcent_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","For it will not be you speaking, but the Spirit of your Father speaking through you. ");
INSERT INTO engtcent_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Brother will deliver up brother to death, and a father his child, and children will rise up against their parents and have them put to death. ");
INSERT INTO engtcent_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","You will be hated by all because of my name, but he who endures to the end will be saved. ");
INSERT INTO engtcent_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","When they persecute you in one town, flee to another, for truly I say to you, you will certainly not finish going through the towns of Israel before the Son of Man comes. ");
INSERT INTO engtcent_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A disciple is not above his teacher, nor is a servant above his master. ");
INSERT INTO engtcent_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","It is sufficient for a disciple to be like his teacher and for a servant to be like his master. If they have called the master of the house Beelzebul, how much more will they malign the members of his household! ");
INSERT INTO engtcent_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“So do not be afraid of them, for there is nothing covered that will not be revealed, and nothing hidden that will not be made known. ");
INSERT INTO engtcent_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","What I tell you in the darkness, speak in the light; and what you hear whispered in your ear, proclaim on the housetops. ");
INSERT INTO engtcent_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Do not be afraid of those who kill the body but cannot kill the soul, but rather fear him who can destroy both the soul and the body in hell. ");
INSERT INTO engtcent_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Are not two sparrows sold for a penny? Yet not one of them will fall to the ground without your Father's consent. ");
INSERT INTO engtcent_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","And even the hairs of your head are all numbered. ");
INSERT INTO engtcent_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","So do not be afraid; you are of more value than many sparrows. ");
INSERT INTO engtcent_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Therefore everyone who acknowledges me before men, I will also acknowledge before my Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","But whoever denies me before men, I will also deny before my Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Do not think that I have come to bring peace to the earth. I have not come to bring peace, but a sword. ");
INSERT INTO engtcent_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","For I have come to set a man against his father, a daughter against her mother, and a daughter-in-law against her mother-in-law. ");
INSERT INTO engtcent_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","And a man's enemies will be the members of his own household. ");
INSERT INTO engtcent_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Whoever loves his father or mother more than me is not worthy of me; whoever loves his son or daughter more than me is not worthy of me. ");
INSERT INTO engtcent_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","And whoever does not take up his cross and follow me is not worthy of me. ");
INSERT INTO engtcent_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Whoever finds his life will lose it, but whoever loses his life for my sake will find it. ");
INSERT INTO engtcent_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Whoever receives you receives me, and whoever receives me receives him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Whoever receives a prophet in the name of a prophet will receive a prophet's reward; whoever receives a righteous person in the name of a righteous person will receive a righteous person's reward. ");
INSERT INTO engtcent_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","And whoever gives one of these little ones even a cup of cold water to drink in the name of a disciple, truly I say to you, he will certainly not lose his reward.” ");
INSERT INTO engtcent_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","When Jesus had finished instructing his twelve disciples, he departed from there to teach and preach in the cities of Galilee. ");
INSERT INTO engtcent_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Now when John heard in prison about the works Christ had done, he sent two of his disciples ");
INSERT INTO engtcent_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","to ask him, “Are yoʋ the one who is to come, or should we wait for another?” ");
INSERT INTO engtcent_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus answered them, “Go tell John what you hear and see: ");
INSERT INTO engtcent_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","The blind receive their sight and the lame walk, lepers are made clean and the deaf hear, the dead are raised and the poor have good news preached to them. ");
INSERT INTO engtcent_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","And blessed is anyone who does not take offense at me.” ");
INSERT INTO engtcent_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","As these men went away, Jesus began to speak to the crowds about John: “What did you go out into the wilderness to see? A reed shaken by the wind? ");
INSERT INTO engtcent_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","What then did you go out to see? A man clothed in soft garments? Behold, those who wear soft garments are in the palaces of kings. ");
INSERT INTO engtcent_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","But what did you go out to see? A prophet? Yes, I tell you, and more than a prophet. ");
INSERT INTO engtcent_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","For this is the one of whom it is written, ‘Behold, I am sending my messenger ahead of yoʋ, who will prepare yoʋr way before yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Truly I say to you, among those born of women there has arisen no one greater than John the Baptist, but whoever is least in the kingdom of heaven is greater than he. ");
INSERT INTO engtcent_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","From the days of John the Baptist until now the kingdom of heaven has been suffering violence, and the violent try to take it by force. ");
INSERT INTO engtcent_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","For all the prophets and the law prophesied until John. ");
INSERT INTO engtcent_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","And if you are willing to accept it, he is Elijah who is to come. ");
INSERT INTO engtcent_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","He who has ears to hear, let him hear. ");
INSERT INTO engtcent_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“But to what should I compare this generation? It is like children sitting in the marketplaces and calling out to their companions, ");
INSERT INTO engtcent_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘We played the flute for you, but you did not dance; we sang a lament for you, but you did not mourn.’ ");
INSERT INTO engtcent_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","For John came neither eating nor drinking, and they say, ‘He has a demon.’ ");
INSERT INTO engtcent_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","The Son of Man came eating and drinking, and they say, ‘Behold, a glutton and a drunkard, a friend of tax collectors and sinners!’ Yet wisdom is vindicated by her children.” ");
INSERT INTO engtcent_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Then Jesus began to reproach the cities in which most of his miracles had been done, because they did not repent: ");
INSERT INTO engtcent_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Woe to yoʋ, Chorazin! Woe to yoʋ, Bethsaida! For if the miracles that were done in you had been done in Tyre and Sidon, they would have repented long ago in sackcloth and ashes. ");
INSERT INTO engtcent_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","But I tell you, it will be more tolerable on the day of judgment for Tyre and Sidon than for you. ");
INSERT INTO engtcent_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","And yoʋ, Capernaum, who have been exalted to heaven, will be brought down to Hades. For if the miracles that were done in yoʋ had been done in Sodom, it would have remained until this day. ");
INSERT INTO engtcent_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","But I tell you, it will be more tolerable on the day of judgment for the land of Sodom than for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","At that time Jesus said, “I praise yoʋ, Father, Lord of heaven and earth, because yoʋ have hidden these things from the wise and intelligent, and revealed them to infants. ");
INSERT INTO engtcent_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yes, Father, for so it was well-pleasing in yoʋr sight. ");
INSERT INTO engtcent_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","All things have been delivered to me by my Father. No one knows the Son except the Father, and no one knows the Father except the Son, and anyone to whom the Son chooses to reveal him. ");
INSERT INTO engtcent_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Come to me, all of you who labor and are burdened, and I will give you rest. ");
INSERT INTO engtcent_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Take my yoke upon you and learn from me, for I am gentle and lowly in heart, and you will find rest for your souls. ");
INSERT INTO engtcent_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","For my yoke is easy, and my burden is light.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","At that time Jesus went through the grainfields on the Sabbath. His disciples were hungry and began to pluck heads of grain and eat them. ");
INSERT INTO engtcent_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","When the Pharisees saw this, they said to him, “Behold, yoʋr disciples are doing what is not lawful to do on the Sabbath.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","He said to them, “Have you not read what David did when he was hungry, he and those who were with him, ");
INSERT INTO engtcent_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","how he entered the house of God and ate the bread of the Presence, which was not lawful for him or those who were with him to eat, but only for the priests? ");
INSERT INTO engtcent_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Or have you not read in the law that on the Sabbath the priests in the temple profane the Sabbath and yet are guiltless? ");
INSERT INTO engtcent_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","But I tell you that something greater than the temple is here. ");
INSERT INTO engtcent_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","But if you had known what this means: ‘I desire mercy and not sacrifice,’ you would not have condemned the guiltless. ");
INSERT INTO engtcent_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","For the Son of Man is Lord of the Sabbath.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Then he departed from there and went into their synagogue. ");
INSERT INTO engtcent_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","And behold, there was a man who had a withered hand. In order to accuse Jesus, the Pharisees asked him, “Is it lawful to heal on the Sabbath?” ");
INSERT INTO engtcent_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","He said to them, “What man among you who has a sheep that falls into a pit on the Sabbath will not take hold of it and lift it out? ");
INSERT INTO engtcent_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Of how much more value is a person than a sheep! So then, it is lawful to do good on the Sabbath.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Then he said to the man, “Stretch out yoʋr hand.” So he stretched it out, and it was restored, becoming as sound as the other. ");
INSERT INTO engtcent_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","But the Pharisees went out and took counsel against Jesus as to how they might destroy him. ");
INSERT INTO engtcent_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aware of this, Jesus withdrew from there. Large crowds followed him, and he healed them all ");
INSERT INTO engtcent_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","and warned them not to make him known. ");
INSERT INTO engtcent_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","This was to fulfill what had been spoken through the prophet Isaiah: ");
INSERT INTO engtcent_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Behold, my servant whom I have chosen, my beloved, in whom my soul is well pleased. I will put my Spirit upon him, and he will declare justice to the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","He will not quarrel or cry out, nor will anyone hear his voice in the streets. ");
INSERT INTO engtcent_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A bruised reed he will not break, and a smoldering wick he will not extinguish, until he brings justice to victory. ");
INSERT INTO engtcent_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","And in his name the Gentiles will hope.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Then a demon-possessed man who was blind and mute was brought to him, and Jesus healed him, so that the man who was blind and mute could speak and see. ");
INSERT INTO engtcent_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","All the crowds were amazed and said, “Can this be the Son of David?” ");
INSERT INTO engtcent_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","But when the Pharisees heard this, they said, “It is only by Beelzebul, the ruler of demons, that this man casts out demons.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Knowing their thoughts, Jesus said to them, “Every kingdom divided against itself is laid waste, and no city or house divided against itself will stand. ");
INSERT INTO engtcent_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","So if Satan casts out Satan, he is divided against himself. How then will his kingdom stand? ");
INSERT INTO engtcent_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","And if I cast out demons by Beelzebul, by whom do your followers cast them out? Therefore they will be your judges. ");
INSERT INTO engtcent_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","But if I cast out demons by the Spirit of God, then the kingdom of God has come upon you. ");
INSERT INTO engtcent_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Or how can anyone enter the house of a strong man and plunder his goods unless he first binds the strong man? Then he can plunder his house. ");
INSERT INTO engtcent_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Whoever is not with me is against me, and whoever does not gather with me scatters. ");
INSERT INTO engtcent_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Therefore I tell you, people will be forgiven for every sin and blasphemy, but they will not be forgiven for blasphemy against the Spirit. ");
INSERT INTO engtcent_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Whoever speaks a word against the Son of Man will be forgiven, but whoever speaks against the Holy Spirit will not be forgiven, neither in the present age nor in the age to come. ");
INSERT INTO engtcent_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“A tree is known by its fruit. If a tree is good, its fruit will also be good. If a tree is bad, its fruit will also be bad. ");
INSERT INTO engtcent_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","You brood of vipers, how can you speak good things, when you are evil? For out of the abundance of the heart the mouth speaks. ");
INSERT INTO engtcent_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","The good person brings good things out of his good treasure, and the evil person brings evil things out of his evil treasure. ");
INSERT INTO engtcent_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","But I tell you, on the day of judgment people will give an account for every idle word they speak. ");
INSERT INTO engtcent_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","For by yoʋr words yoʋ will be justified, and by yoʋr words yoʋ will be condemned.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Then some of the scribes and Pharisees responded, “Teacher, we want to see a sign from yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","But Jesus answered them, “An evil and adulterous generation asks for a sign, but no sign will be given to it except the sign of the prophet Jonah. ");
INSERT INTO engtcent_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","For just as Jonah was in the belly of the great sea creature for three days and three nights, so will the Son of Man be in the heart of the earth for three days and three nights. ");
INSERT INTO engtcent_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","The men of Nineveh will rise up at the judgment with this generation and condemn it, for they repented at the preaching of Jonah, and behold, something greater than Jonah is here. ");
INSERT INTO engtcent_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","The queen of the South will rise up at the judgment with this generation and condemn it, for she came from the ends of the earth to hear the wisdom of Solomon, and behold, something greater than Solomon is here. ");
INSERT INTO engtcent_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“When an unclean spirit has gone out of a person, it goes through waterless places seeking rest, but does not find any. ");
INSERT INTO engtcent_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Then it says, ‘I will return to the house I left.’ When it arrives, it finds the house unoccupied, swept, and put in order. ");
INSERT INTO engtcent_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Then it goes and takes with it seven other spirits more evil than itself, and they go in and dwell there, and the last state of that person becomes worse than the first. So will it be with this evil generation also.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","While Jesus was still speaking to the crowds, behold, his mother and his brothers stood outside, asking to speak to him. ");
INSERT INTO engtcent_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Then someone said to him, “Behold, yoʋr mother and yoʋr brothers are standing outside, asking to speak to yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","But he replied to the one who spoke to him, “Who is my mother, and who are my brothers?” ");
INSERT INTO engtcent_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","And stretching out his hand toward his disciples, he said, “Behold, my mother and my brothers! ");
INSERT INTO engtcent_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","For whoever does the will of my Father in heaven is my brother and sister and mother.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","On that day Jesus went out of the house and sat by the sea, ");
INSERT INTO engtcent_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","and large crowds gathered around him. So he got into the boat and sat down, while the entire crowd stood on the shore. ");
INSERT INTO engtcent_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Then he told them many things in parables, saying, “Behold, a sower went out to sow. ");
INSERT INTO engtcent_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","As he sowed, some seeds fell along the path, and the birds came and devoured them. ");
INSERT INTO engtcent_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Other seeds fell on rocky ground, where they did not have much soil, and they sprang up immediately because they had no depth of soil. ");
INSERT INTO engtcent_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","But when the sun rose, they were scorched. And because they had no root, they withered away. ");
INSERT INTO engtcent_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Other seeds fell among the thorns, and the thorns grew up and choked them. ");
INSERT INTO engtcent_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","But other seeds fell on good soil and produced fruit, some a hundred, some sixty, and some thirty times more than what was sown. ");
INSERT INTO engtcent_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","He who has ears to hear, let him hear.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Then the disciples came and said to him, “Why do yoʋ speak to the people in parables?” ");
INSERT INTO engtcent_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus answered them, “To you it has been given to know the mysteries of the kingdom of heaven, but to them it has not been given. ");
INSERT INTO engtcent_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","For whoever has will be given more, and he will have an abundance. But whoever does not have, even what he has will be taken away from him. ");
INSERT INTO engtcent_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","That is why I speak to them in parables, because ‘they see but do not perceive, and they hear but do not listen or understand.’ ");
INSERT INTO engtcent_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","In them is fulfilled the prophecy of Isaiah, which says, ‘Yoʋ will hear but never understand, and you will see but never perceive. ");
INSERT INTO engtcent_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","For the heart of this people has become calloused; with their ears they have barely heard, and their eyes they have closed, lest they should see with their eyes, hear with their ears, and understand with their hearts and turn back, and I would heal them.’ ");
INSERT INTO engtcent_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","But blessed are your eyes because they see, and your ears because they hear. ");
INSERT INTO engtcent_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","For truly I say to you, many prophets and righteous people desired to see the things you see but did not see them, and to hear the things you hear but did not hear them. ");
INSERT INTO engtcent_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“So hear what the parable of the sower means: ");
INSERT INTO engtcent_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","When anyone hears the word of the kingdom and does not understand it, the evil one comes and snatches away what was sown in his heart. This is the seed sown along the path. ");
INSERT INTO engtcent_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","The seed sown on rocky ground is he who hears the word and immediately receives it with joy. ");
INSERT INTO engtcent_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yet he has no root in himself, but is only temporary. When tribulation or persecution arises on account of the word, he immediately falls away. ");
INSERT INTO engtcent_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","The seed sown among the thorns is he who hears the word, but the cares of this world and the deceitfulness of riches choke the word, and it becomes unfruitful. ");
INSERT INTO engtcent_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","But the seed sown on the good soil is he who hears the word and understands it, who bears fruit and produces a hundred, sixty, or thirty times more than what was sown.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus presented another parable to them, saying, “The kingdom of heaven can be compared to a person who sowed good seed in his field, ");
INSERT INTO engtcent_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","but while people were sleeping, his enemy came and sowed tares among the wheat, and then went away. ");
INSERT INTO engtcent_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","When the plants sprouted and produced grain, the tares also appeared. ");
INSERT INTO engtcent_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","So the servants of the master of the house came and said to him, ‘Master, did yoʋ not sow good seed in yoʋr field? How then does it have tares?’ ");
INSERT INTO engtcent_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","He said to them, ‘An enemy has done this.’ So the servants said to him, ‘Do yoʋ want us to go and gather them up?’ ");
INSERT INTO engtcent_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","He said, ‘No, lest in gathering the tares you uproot the wheat with them. ");
INSERT INTO engtcent_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Let them both grow together until the harvest, and at the time of the harvest I will say to the reapers, “Gather the tares first and bind them into bundles to burn them up, but gather the wheat into my barn.” ’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","He presented another parable to them, saying, “The kingdom of heaven is like a grain of mustard seed that a man took and sowed in his field. ");
INSERT INTO engtcent_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Although it is the smallest of all seeds, it grows larger than the other garden plants and becomes a tree, and the birds of the sky come and nest in its branches.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","He spoke to them another parable: “The kingdom of heaven is like leaven that a woman took and mixed into three measures of flour until it had all been leavened.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","All these things Jesus spoke to the crowds in parables; he did not speak to them without using a parable. ");
INSERT INTO engtcent_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","This was to fulfill what had been spoken through the prophet: “I will open my mouth in parables; I will declare things hidden from the foundation of the world.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Then Jesus left the crowds and went into the house, and his disciples came to him and said, “Explain to us the parable of the tares of the field.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","So he said to them in response, “He who sows the good seed is the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","The field is the world, and the good seeds are the sons of the kingdom. The tares are the sons of the evil one, ");
INSERT INTO engtcent_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","and the enemy who sowed them is the devil. The harvest is the end of the age, and the reapers are angels. ");
INSERT INTO engtcent_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Therefore, just as the tares are gathered and burned with fire, so it will be at the end of this age. ");
INSERT INTO engtcent_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","The Son of Man will send his angels, and they will gather out of his kingdom all stumbling blocks and those who practice lawlessness. ");
INSERT INTO engtcent_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","They will throw them into the fiery furnace. In that place there will be weeping and gnashing of teeth. ");
INSERT INTO engtcent_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Then the righteous will shine like the sun in the kingdom of their Father. He who has ears to hear, let him hear. ");
INSERT INTO engtcent_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Again, the kingdom of heaven is like a treasure hidden in a field, which a man found and hid again, and in his joy he went and sold all that he had and bought the field. ");
INSERT INTO engtcent_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Again, the kingdom of heaven is like a merchant seeking fine pearls. ");
INSERT INTO engtcent_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","When he found one pearl of great price, he went and sold all that he had and bought it. ");
INSERT INTO engtcent_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Again, the kingdom of heaven is like a dragnet that was cast into the sea, catching all kinds of fish. ");
INSERT INTO engtcent_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","When it was full, the fishermen drew it to shore. Then they sat down and put the good fish into containers, but the bad ones they threw away. ");
INSERT INTO engtcent_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","So it will be at the end of the age. The angels will come and separate the evil from the righteous ");
INSERT INTO engtcent_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","and throw them into the fiery furnace. In that place there will be weeping and gnashing of teeth.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus said to them, “Do you understand all these things?” They said to him, “Yes, Lord.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Then he said to them, “Every scribe that has been trained as a disciple for the kingdom of heaven is like a master of a house who brings out of his treasure things new and old.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","When Jesus had finished these parables, he departed from there. ");
INSERT INTO engtcent_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Then he went to his hometown and taught the people in their synagogue. They were astonished and said, “Where did this man get this wisdom and these miraculous powers? ");
INSERT INTO engtcent_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Is this not the carpenter's son? Is not his mother's name Mary, and are not his brothers James, Joses, Simon, and Judas? ");
INSERT INTO engtcent_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Are not all his sisters with us? Where then did this man get all these things?” ");
INSERT INTO engtcent_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","And they took offense at him. Then Jesus said to them, “A prophet is not without honor except in his hometown and in his own household.” ");
INSERT INTO engtcent_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","And he did not do many miracles there because of their unbelief. ");
INSERT INTO engtcent_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","At that time Herod the tetrarch heard the report about Jesus ");
INSERT INTO engtcent_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","and said to his servants, “This man is John the Baptist; he has been raised from the dead, and that is why these mighty powers are at work in him.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","For Herod had arrested John, bound him, and put him in prison on account of Herodias, his brother Philip's wife. ");
INSERT INTO engtcent_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","For John had been saying to him, “It is not lawful for yoʋ to have her.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Although Herod wanted to kill John, he was afraid of the crowd, because they regarded John as a prophet. ");
INSERT INTO engtcent_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","But when Herod's birthday was celebrated, the daughter of Herodias danced before the guests and pleased Herod. ");
INSERT INTO engtcent_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","So he promised with an oath to give her whatever she might ask. ");
INSERT INTO engtcent_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Prompted by her mother, she said, “Give me here on a platter the head of John the Baptist.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","The king was grieved, but because of his oaths and his guests, he commanded it to be given ");
INSERT INTO engtcent_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","and sent orders to have John beheaded in prison. ");
INSERT INTO engtcent_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","John's head was then brought on a platter and given to the girl, and she brought it to her mother. ");
INSERT INTO engtcent_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Later, John's disciples came and took his body and buried it. Then they went and brought word to Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","When Jesus heard this, he withdrew from there in a boat to a desolate place by himself. But the crowds heard about it and followed him on foot from the towns. ");
INSERT INTO engtcent_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","And when Jesus went ashore and saw a large crowd, he was moved with compassion for them and healed their sick. ");
INSERT INTO engtcent_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","As evening approached, his disciples came to him and said, “This place is desolate, and the hour is now late. Send the crowds away so that they can go into the villages and buy themselves some food.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","But Jesus said to them, “They have no need to go away; you give them something to eat.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","They said to him, “We have here only five loaves and two fish.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","He said, “Bring them here to me.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Then he commanded the crowds to sit down on the grass, and taking the five loaves and the two fish, he looked up to heaven and said the blessing. Then he broke the loaves and gave them to the disciples, and the disciples gave them to the crowds. ");
INSERT INTO engtcent_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","They all ate and were filled, and the disciples picked up what was left over of the broken pieces, twelve baskets full. ");
INSERT INTO engtcent_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Now those who had eaten were about five thousand men, besides women and children. ");
INSERT INTO engtcent_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Immediately Jesus compelled the disciples to get into the boat and go ahead of him to the other side of the sea, while he sent the crowds away. ");
INSERT INTO engtcent_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","After sending the crowds away, he went up on the mountain by himself to pray. When evening came, he was there alone. ");
INSERT INTO engtcent_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Meanwhile, the boat was already in the middle of the sea, being tossed by the waves, for the wind was against them. ");
INSERT INTO engtcent_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","And in the fourth watch of the night Jesus went to them, walking on the sea. ");
INSERT INTO engtcent_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","When the disciples saw him walking on the sea, they were terrified and said, “It is a ghost!” And they cried out in fear. ");
INSERT INTO engtcent_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","But Jesus immediately said to them, “Take courage! It is I; do not be afraid.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","In response Peter said to him, “Lord, if it is yoʋ, command me to come to yoʋ on the water.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","So he said, “Come.” Then Peter got down from the boat and walked on the water to go to Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","But when he saw the strong wind, he became frightened, and beginning to sink, he cried out, “Lord, save me!” ");
INSERT INTO engtcent_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Immediately Jesus reached out his hand, took hold of him, and said to him, “O yoʋ of little faith, why did yoʋ doubt?” ");
INSERT INTO engtcent_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","And when they had gotten into the boat, the wind ceased. ");
INSERT INTO engtcent_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Then those who were in the boat came and worshiped him, saying, “Truly yoʋ are the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","When they had crossed the sea, they came to the land of Gennesaret. ");
INSERT INTO engtcent_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","And when the men of that place recognized Jesus, they sent word into the entire surrounding region, and people brought to him all who were sick. ");
INSERT INTO engtcent_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","They begged him to let the sick touch even the fringe of his garment, and all who touched it were completely healed. ");
INSERT INTO engtcent_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Then the scribes and Pharisees from Jerusalem came to Jesus and said, ");
INSERT INTO engtcent_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Why do yoʋr disciples break the tradition of the elders? For they do not wash their hands when they eat bread.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","He answered them, “And why do you break the commandment of God for the sake of your tradition? ");
INSERT INTO engtcent_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","For God commanded, ‘Honor yoʋr father and yoʋr mother,’ and, ‘Whoever speaks evil of his father or mother must surely die.’ ");
INSERT INTO engtcent_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","But you say, ‘If anyone says to his father or mother, “Whatever benefit yoʋ might have received from me is now a gift devoted to God,” then he certainly need not honor his father or his mother.’ ");
INSERT INTO engtcent_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","You have nullified the commandment of God for the sake of your tradition. ");
INSERT INTO engtcent_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hypocrites! Isaiah prophesied rightly about you when he said, ");
INSERT INTO engtcent_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘This people draws near to me with their mouth and honors me with their lips, but their heart is far from me. ");
INSERT INTO engtcent_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","They worship me in vain, teaching as doctrines the commandments of men.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Then Jesus called the crowd over and said to them, “Listen and understand: ");
INSERT INTO engtcent_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","It is not what goes into the mouth that defiles a person; it is what comes out of the mouth that defiles a person.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Then his disciples came and said to him, “Do yoʋ know that the Pharisees were offended when they heard what yoʋ said?” ");
INSERT INTO engtcent_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus answered, “Every plant that my heavenly Father has not planted will be uprooted. ");
INSERT INTO engtcent_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Leave them be; they are blind guides of the blind. And if one blind person guides another, both will fall into a pit.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Then Peter said to him in response, “Explain this parable to us.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus said, “Are you also still without understanding? ");
INSERT INTO engtcent_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Do you not yet understand that everything that goes into the mouth passes into the stomach and is expelled into the latrine? ");
INSERT INTO engtcent_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","But the things that come out of the mouth come from the heart, and these defile a person. ");
INSERT INTO engtcent_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","For from the heart come evil thoughts, murder, adultery, fornication, theft, false testimony, and slander. ");
INSERT INTO engtcent_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","These are what defile a person, but to eat with unwashed hands does not defile a person.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Then Jesus went away from there and withdrew to the district of Tyre and Sidon. ");
INSERT INTO engtcent_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","And behold, a Canaanite woman from that region came and cried out to him, “Have mercy on me, Lord, Son of David! My daughter is severely demon-possessed.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","But he did not respond to her at all. So his disciples came to him and urged him, “Send her away, for she is crying out after us.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","In response Jesus said, “I was sent only to the lost sheep of the house of Israel.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","But she came and bowed down before him, saying, “Lord, help me.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","He replied, “It is not good to take the children's bread and throw it to the dogs.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","She said, “Yes, Lord, yet even the dogs eat the crumbs that fall from the table of their masters.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Then Jesus answered her, “O woman, great is yoʋr faith; it will be done for yoʋ as yoʋ wish.” And her daughter was healed from that hour. ");
INSERT INTO engtcent_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Departing from there, Jesus went along the Sea of Galilee. Then he went up on the mountain and sat down. ");
INSERT INTO engtcent_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Large crowds came to him, having with them the lame, blind, mute, crippled, and many others. They put them at the feet of Jesus, and he healed them. ");
INSERT INTO engtcent_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","So the crowds were amazed when they saw the mute speaking, the crippled made well, the lame walking, and the blind seeing. And they glorified the God of Israel. ");
INSERT INTO engtcent_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Then Jesus called his disciples over and said, “I have compassion on the crowd because they have stayed with me now for three days and have nothing to eat. I do not want to send them away without having eaten, lest they faint on the way.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","His disciples said to him, “Where can we get so many loaves in such a desolate place to fill such a large crowd?” ");
INSERT INTO engtcent_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus said to them, “How many loaves do you have?” They said, “Seven, and a few small fish.” ");
INSERT INTO engtcent_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","So he commanded the crowds to sit down on the ground, ");
INSERT INTO engtcent_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","and taking the seven loaves and the fish, he gave thanks, broke them, and gave them to his disciples, and the disciples gave them to the crowd. ");
INSERT INTO engtcent_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","They all ate and were filled, and the disciples picked up what was left over of the broken pieces, seven baskets full. ");
INSERT INTO engtcent_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Besides women and children, there were four thousand men who had eaten. ");
INSERT INTO engtcent_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","After sending the crowds away, Jesus got into the boat and went to the region of Magdala. ");
INSERT INTO engtcent_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Now the Pharisees and Sadducees came and tested Jesus, asking him to show them a sign from heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","But he answered them, “When evening comes you say, ‘It will be fair weather, for the sky is red.’ ");
INSERT INTO engtcent_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","And in the morning you say, ‘There will be a storm today, for the sky is red and threatening.’ Hypocrites! You know how to discern the appearance of the sky, but you cannot discern the signs of the times? ");
INSERT INTO engtcent_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","An evil and adulterous generation asks for a sign, but no sign will be given to it except the sign of the prophet Jonah.” Then he left them and went away. ");
INSERT INTO engtcent_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","When his disciples reached the other side of the sea, they realized that they had forgotten to bring bread. ");
INSERT INTO engtcent_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Then Jesus said to them, “Watch out and beware of the leaven of the Pharisees and Sadducees.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","So they discussed this among themselves, saying, “He must have said this because we brought no bread.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aware of this, Jesus said to them, “Why are you discussing among yourselves, O you of little faith, the fact that you brought no bread? ");
INSERT INTO engtcent_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Do you not yet understand? Do you not remember the five loaves for the five thousand, and how many baskets you collected? ");
INSERT INTO engtcent_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Or the seven loaves for the four thousand, and how many baskets you collected? ");
INSERT INTO engtcent_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","How could you not understand that I was not talking about bread when I told you to beware of the leaven of the Pharisees and Sadducees?” ");
INSERT INTO engtcent_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Then they understood that he had not told them to beware of the leaven of bread, but of the teaching of the Pharisees and Sadducees. ");
INSERT INTO engtcent_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Now when Jesus came into the district of Caesarea Philippi, he asked his disciples, “Who do people say that I, the Son of Man, am?” ");
INSERT INTO engtcent_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","They said, “Some say John the Baptist, others say Elijah, and others say that yoʋ are Jeremiah or one of the prophets.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","He said to them, “But who do you say that I am?” ");
INSERT INTO engtcent_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter answered, “Yoʋ are the Christ, the Son of the living God.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","And Jesus answered him, “Blessed are yoʋ, Simon Bar-Jonah, for flesh and blood has not revealed this to yoʋ, but my Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","And I tell yoʋ that yoʋ are Peter, and on this rock I will build my church, and the gates of Hades shall not prevail against it. ");
INSERT INTO engtcent_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","I will give yoʋ the keys of the kingdom of heaven, and whatever yoʋ bind on earth will be bound in heaven, and whatever yoʋ loose on earth will be loosed in heaven.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Then he commanded his disciples to tell no one that he was Jesus the Christ. ");
INSERT INTO engtcent_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","From that time Jesus began to show his disciples that he must go to Jerusalem and suffer many things at the hands of the elders, chief priests, and scribes, and that he must be killed and on the third day be raised up. ");
INSERT INTO engtcent_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","So Peter took him aside and began to rebuke him, saying, “God forbid, Lord! This shall certainly not happen to yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","But he turned around and said to Peter, “Get behind me, Satan! Yoʋ are a stumbling block to me, for yoʋ are not thinking about the things of God, but the things of men.” ");
INSERT INTO engtcent_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Then Jesus said to his disciples, “If anyone wants to be one of my disciples, he must deny himself, take up his cross, and follow me. ");
INSERT INTO engtcent_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","For whoever wants to save his life will lose it, but whoever loses his life for my sake will find it. ");
INSERT INTO engtcent_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","For what does it benefit a person if he gains the whole world but forfeits his soul? Or what can a person give in exchange for his soul? ");
INSERT INTO engtcent_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","For the Son of Man will come with his angels in the glory of his Father, and then he will repay each person according to what he has done. ");
INSERT INTO engtcent_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Truly I say to you, there are some standing here who will certainly not taste death until they see the Son of Man coming in his kingdom.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","After six days Jesus took Peter, James, and John the brother of James, and led them up on a high mountain by themselves. ");
INSERT INTO engtcent_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","There he was transfigured before them; his face shone like the sun, and his garments became as white as light. ");
INSERT INTO engtcent_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","And behold, Moses and Elijah appeared to them, talking with him. ");
INSERT INTO engtcent_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","So Peter said to Jesus, “Lord, it is good for us to be here. If yoʋ want, we will make three shelters here, one for yoʋ, one for Moses, and one for Elijah.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","While he was still speaking, behold, a bright cloud overshadowed them, and a voice from the cloud said, “This is my beloved Son, in whom I am well pleased; listen to him!” ");
INSERT INTO engtcent_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","When the disciples heard this, they fell on their faces and were utterly afraid. ");
INSERT INTO engtcent_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","But Jesus came over and touched them, saying, “Rise; do not be afraid.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","And lifting up their eyes, they saw no one but Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","As they were coming down from the mountain, Jesus commanded them, “Do not tell anyone about the vision you saw until the Son of Man has risen from the dead.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Then his disciples asked him, “Why do the scribes say that Elijah must come first?” ");
INSERT INTO engtcent_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus answered them, “Elijah does indeed come first, and he will restore all things. ");
INSERT INTO engtcent_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","But I tell you that Elijah has already come, and they did not recognize him, but did to him whatever they wanted. Even so the Son of Man is about to suffer at their hands.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Then the disciples understood that he was speaking to them about John the Baptist. ");
INSERT INTO engtcent_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","When they came to the crowd, a man approached Jesus, kneeling before him ");
INSERT INTO engtcent_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","and saying, “Lord, have mercy on my son, for he is an epileptic and suffers terribly. For often he falls into the fire, and often into the water. ");
INSERT INTO engtcent_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","I brought him to yoʋr disciples, but they could not heal him.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus answered, “O faithless and perverse generation, how long shall I be with you? How long shall I bear with you? Bring him here to me.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Then Jesus rebuked the demon, and it came out of the boy, and he was healed from that hour. ");
INSERT INTO engtcent_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Afterward the disciples came to Jesus privately and said, “Why could we not cast it out?” ");
INSERT INTO engtcent_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus said to them, “Because of your unbelief. For truly I say to you, if you have faith like a grain of mustard seed, you will say to this mountain, ‘Move from here to there,’ and it will move. Nothing will be impossible for you. ");
INSERT INTO engtcent_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","But this kind does not go out except by prayer and fasting.” ");
INSERT INTO engtcent_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","While they were staying in Galilee, Jesus said to them, “The Son of Man is about to be delivered up into the hands of men. ");
INSERT INTO engtcent_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","They will kill him, and on the third day he will be raised up.” And the disciples were greatly distressed. ");
INSERT INTO engtcent_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","When they came to Capernaum, the collectors of the two-drachma tax came to Peter and said, “Your teacher pays the two-drachma tax, doesn't he?” ");
INSERT INTO engtcent_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","He said, “Yes.” And when Peter came into the house, Jesus spoke to him first, saying, “What do yoʋ think, Simon? From whom do the kings of the earth receive toll or tax? From their own sons or from strangers?” ");
INSERT INTO engtcent_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter said to him, “From strangers.” And Jesus said to him, “Then the sons are free. ");
INSERT INTO engtcent_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","But so that we may not offend them, go to the sea, cast a hook, and take the first fish yoʋ catch. When yoʋ open its mouth, yoʋ will find a stater coin. Take it and give it to them for yoʋ and me.” ");
INSERT INTO engtcent_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","In that hour the disciples came to Jesus and said, “Who is greater in the kingdom of heaven?” ");
INSERT INTO engtcent_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","So Jesus called over a little child, placed him among them, ");
INSERT INTO engtcent_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","and said, “Truly I say to you, unless you change and become like little children, you will certainly not enter the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Therefore, whoever humbles himself like this little child is greater in the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","And whoever receives one little child such as this in my name receives me. ");
INSERT INTO engtcent_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","But if anyone causes one of these little ones who believe in me to stumble, it would be better for him to have a heavy millstone hung around his neck and to be drowned in the depths of the sea. ");
INSERT INTO engtcent_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Woe to the world because of stumbling blocks! It is necessary that stumbling blocks come, yet woe to that man through whom the stumbling block comes! ");
INSERT INTO engtcent_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","If yoʋr hand or yoʋr foot causes yoʋ to stumble, cut them off and throw them away from yoʋ. It is better for yoʋ to enter life lame or crippled than to have two hands or two feet and be thrown into the eternal fire. ");
INSERT INTO engtcent_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","And if yoʋr eye causes yoʋ to stumble, pluck it out and throw it away from yoʋ. It is better for yoʋ to enter life with one eye than to have two eyes and be thrown into the fires of hell. ");
INSERT INTO engtcent_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Be careful not to despise one of these little ones, for I tell you that their angels in heaven continually see the face of my Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","For the Son of Man came to save the lost. ");
INSERT INTO engtcent_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","What do you think? If a man has a hundred sheep, and one of them goes astray, does he not leave the other ninety-nine and go seek on the mountains the one that has gone astray? ");
INSERT INTO engtcent_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","And if he happens to find it, truly I say to you, he rejoices more over it than over the ninety-nine that have not gone astray. ");
INSERT INTO engtcent_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","In the same way, it is not the will of your Father in heaven that one of these little ones should perish. ");
INSERT INTO engtcent_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“If yoʋr brother sins against yoʋ, go show him his fault between yoʋ and him alone. If he listens to yoʋ, yoʋ have gained yoʋr brother. ");
INSERT INTO engtcent_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","But if he does not listen, take one or two others with yoʋ, so that every matter may be established by the mouth of two or three witnesses. ");
INSERT INTO engtcent_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","If he refuses to listen to them, tell it to the church. And if he refuses to listen even to the church, treat him as you would a pagan or a tax collector. ");
INSERT INTO engtcent_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Truly I say to you, whatever you bind on earth will be bound in heaven, and whatever you loose on earth will be loosed in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Again, truly I say to you, if two of you agree on earth about anything you ask, it will be done for you by my Father in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","For where two or three are gathered together in my name, I am there among them.” ");
INSERT INTO engtcent_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Then Peter came to Jesus and said, “Lord, how many times must I forgive my brother when he keeps sinning against me? Up to seven times?” ");
INSERT INTO engtcent_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus said to him, “Not, I tell yoʋ, up to seven times, but up to seventy times seven. ");
INSERT INTO engtcent_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“For this reason the kingdom of heaven may be compared to a king who wished to settle accounts with his servants. ");
INSERT INTO engtcent_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","As he began to settle accounts, one servant who had a debt of ten thousand talents was brought to him. ");
INSERT INTO engtcent_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","But since he did not have anything with which to repay the debt, his master commanded him to be sold along with his wife, his children, and all that he had, so that the debt could be repaid. ");
INSERT INTO engtcent_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","So the servant fell down and bowed before him, saying, ‘Master, be patient with me, and I will repay yoʋ all that I owe.’ ");
INSERT INTO engtcent_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Moved with compassion, the master of that servant released him and forgave him the debt. ");
INSERT INTO engtcent_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","But that servant went out and found one of his fellow servants who owed him a hundred denarii. He grabbed him and began to choke him, saying, ‘Repay me what yoʋ owe.’ ");
INSERT INTO engtcent_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","So his fellow servant fell down at his feet and begged him, ‘Be patient with me, and I will repay yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","But he was not willing to do so. Instead, he went and threw him into prison until he should repay what was owed. ");
INSERT INTO engtcent_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","When his fellow servants saw what had taken place, they were greatly distressed and went and reported to their master all that had happened. ");
INSERT INTO engtcent_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Then the master summoned the servant and said to him, ‘Yoʋ evil servant! I forgave yoʋ all that debt because yoʋ begged me to do so. ");
INSERT INTO engtcent_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Should yoʋ not also have had mercy on yoʋr fellow servant, even as I had mercy on yoʋ?’ ");
INSERT INTO engtcent_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","And in anger his master handed him over to the jailers to be tortured until he should repay all that was owed him. ");
INSERT INTO engtcent_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","My heavenly Father will also do the same to you if each one of you, from your hearts, does not forgive his brother for his trespasses.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","When Jesus had finished saying these things, he departed from Galilee and came into the region of Judea beyond the Jordan. ");
INSERT INTO engtcent_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Large crowds followed him, and he healed them there. ");
INSERT INTO engtcent_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Then the Pharisees came up to Jesus and tested him by asking him, “Is it lawful for a man to divorce his wife for any reason?” ");
INSERT INTO engtcent_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","He answered them, “Have you not read that he who made them from the beginning ‘made them male and female,’ ");
INSERT INTO engtcent_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","and said, ‘For this reason a man will leave his father and mother and be joined to his wife, and the two will become one flesh’? ");
INSERT INTO engtcent_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","So then, they are no longer two, but one flesh. Therefore what God has joined together, let no one separate.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","They said to him, “Why then did Moses command us to give her a certificate of divorce and send her away?” ");
INSERT INTO engtcent_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","He said to them, “Because of your hardness of heart Moses allowed you to divorce your wives, but from the beginning it was not so. ");
INSERT INTO engtcent_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","I tell you that whoever divorces his wife, except for fornication, and marries another, commits adultery. And whoever marries a divorced woman commits adultery.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","His disciples said to him, “If such is the case of a man with his wife, it is better not to marry.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","But Jesus said to them, “Not all men can accept this statement, but only those to whom it is given. ");
INSERT INTO engtcent_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","For there are eunuchs who were born that way from their mother's womb, and there are eunuchs who have been made eunuchs by men, and there are eunuchs who have made themselves eunuchs for the sake of the kingdom of heaven. Whoever is able to accept this should accept it.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Then little children were brought to Jesus so that he might lay his hands on them and pray, but the disciples rebuked those who brought them. ");
INSERT INTO engtcent_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yet Jesus said, “Let the little children come to me and do not hinder them, for the kingdom of heaven belongs to such as these.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","And after laying his hands on them, he departed from there. ");
INSERT INTO engtcent_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","And behold, a man came and said to him, “Good Teacher, what good thing must I do to have eternal life?” ");
INSERT INTO engtcent_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus said to him, “Why do yoʋ call me good? No one is good except God alone. But if yoʋ wish to enter life, keep the commandments.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","The man said to him, “Which ones?” Jesus said, “Yoʋ shall not murder, Yoʋ shall not commit adultery, Yoʋ shall not steal, Yoʋ shall not give false testimony, ");
INSERT INTO engtcent_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Honor yoʋr father and yoʋr mother, and, Yoʋ shall love yoʋr neighbor as yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","The young man said to him, “I have kept all these commandments from the time I was a young boy; what do I still lack?” ");
INSERT INTO engtcent_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus said to him, “If yoʋ wish to be perfect, go sell what yoʋ have and give to the poor, and yoʋ will have treasure in heaven; then come follow me.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","But when the young man heard this, he went away sorrowful, for he had many possessions. ");
INSERT INTO engtcent_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Then Jesus said to his disciples, “Truly I say to you, only with difficulty will a rich person enter the kingdom of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Again I say to you, it is easier for a camel to go through the eye of a needle than for a rich person to enter the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","When his disciples heard this, they were greatly astonished and said, “Who then can be saved?” ");
INSERT INTO engtcent_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus looked at them and said to them, “With men it is impossible, but with God all things are possible.” ");
INSERT INTO engtcent_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Then Peter said to him in response, “Behold, we have left everything and followed yoʋ; what then will there be for us?” ");
INSERT INTO engtcent_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus said to them, “Truly I say to you, when all things are made new and the Son of Man sits on his throne of glory, you who have followed me will also sit on twelve thrones, judging the twelve tribes of Israel. ");
INSERT INTO engtcent_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","And everyone who has left houses, brothers, sisters, father, mother, wife, children, or fields for my name's sake, will receive a hundred times more and will inherit eternal life. ");
INSERT INTO engtcent_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","But many who are first will be last, and many who are last will be first. ");
INSERT INTO engtcent_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“For the kingdom of heaven is like a master of a house who went out early in the morning to hire workers for his vineyard. ");
INSERT INTO engtcent_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","After agreeing with the workers that they would each receive a denarius for the day, he sent them into his vineyard. ");
INSERT INTO engtcent_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","About the third hour he went out and saw others standing idle in the marketplace. ");
INSERT INTO engtcent_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","He said to them, ‘You go into my vineyard as well, and I will give you whatever is right.’ ");
INSERT INTO engtcent_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","So they went. He went out again about the sixth hour and the ninth hour and did likewise. ");
INSERT INTO engtcent_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","About the eleventh hour he went out and found others standing idle and said to them, ‘Why have you been standing here idle all day?’ ");
INSERT INTO engtcent_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","They said to him, ‘Because no one has hired us.’ He said to them, ‘You go into my vineyard as well, and you will receive whatever is right.’ ");
INSERT INTO engtcent_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“When evening came, the owner of the vineyard said to his foreman, ‘Call the workers and pay them their wages, beginning with the last and going on to the first.’ ");
INSERT INTO engtcent_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","When those who had been hired about the eleventh hour came, they each received a denarius. ");
INSERT INTO engtcent_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","So when those who had been hired first came, they thought they would receive more, but they also received a denarius each. ");
INSERT INTO engtcent_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","When they received it, they grumbled against the master of the house, ");
INSERT INTO engtcent_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","saying, ‘These last men worked for one hour, and yoʋ have made them equal to us, who have borne the burden of the day and the scorching heat.’ ");
INSERT INTO engtcent_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","But he replied to one of them, ‘Friend, I am doing yoʋ no wrong. Did yoʋ not agree with me to work for a denarius? ");
INSERT INTO engtcent_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Take what is yoʋrs and go. I wish to give to this last man just as I gave to yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Or is it not lawful for me to do what I wish with what is mine? Are yoʋ envious because I am good?’ ");
INSERT INTO engtcent_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","So the last will be first, and the first will be last. For many are called, but few are chosen.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","As Jesus was going up to Jerusalem, he took the twelve disciples aside privately on the way and said to them, ");
INSERT INTO engtcent_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Behold, we are going up to Jerusalem, and the Son of Man will be delivered up to the chief priests and scribes. They will condemn him to death ");
INSERT INTO engtcent_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","and hand him over to the Gentiles to be mocked, flogged, and crucified. But on the third day he will rise again.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Then the mother of the sons of Zebedee came with her sons to Jesus, and bowing down she asked him for a favor. ");
INSERT INTO engtcent_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","So he said to her, “What do yoʋ want?” She said to him, “Declare that one of these two sons of mine may sit on yoʋr right and the other on yoʋr left in yoʋr kingdom.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus answered, “You do not know what you are asking. Are you able to drink the cup that I am about to drink, or to be baptized with the baptism that I am baptized with?” The two brothers said to him, “We are able.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","So he said to them, “You will indeed drink my cup and be baptized with the baptism that I am baptized with, but to sit on my right and on my left is not mine to give, but is for those for whom it has been prepared by my Father.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","When the ten heard this, they were indignant with the two brothers. ");
INSERT INTO engtcent_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","So Jesus called them over and said, “You know that the rulers of the Gentiles lord it over them, and their great men exercise authority over them. ");
INSERT INTO engtcent_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","But it shall not be so among you. Instead, whoever wants to be great among you must be your servant, ");
INSERT INTO engtcent_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","and whoever wants to be first among you must be your slave, ");
INSERT INTO engtcent_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","just as the Son of Man came not to be served but to serve, and to give his life as a ransom for many.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","As they were leaving Jericho, a large crowd followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","And behold, there were two blind men sitting by the road. When they heard that Jesus was passing by, they cried out, “Have mercy on us, Lord, Son of David!” ");
INSERT INTO engtcent_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","But the crowd rebuked them, telling them to be silent. Yet they cried out even more loudly, “Have mercy on us, Lord, Son of David!” ");
INSERT INTO engtcent_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","So Jesus stopped, called them over, and said, “What do you want me to do for you?” ");
INSERT INTO engtcent_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","They said to him, “Lord, let our eyes be opened.” ");
INSERT INTO engtcent_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Moved with compassion, Jesus touched their eyes, and immediately their eyes received sight, and they followed him. ");
INSERT INTO engtcent_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","When they drew near to Jerusalem and came to Bethsphage, at the Mount of Olives, Jesus sent two disciples ahead, ");
INSERT INTO engtcent_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","telling them, “Go into the village ahead of you, and immediately you will find a donkey tied there and a colt with it. Untie them and bring them to me. ");
INSERT INTO engtcent_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","If anyone says anything to you, say, ‘The Lord has need of them.’ And immediately he will send them.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Now all this took place to fulfill what the Lord had spoken through the prophet: ");
INSERT INTO engtcent_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Say to the daughter of Zion, ‘Behold, yoʋr king is coming to yoʋ, humble and mounted on a donkey, and a colt, the foal of a beast of burden.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","So the disciples went and did just as Jesus had directed them. ");
INSERT INTO engtcent_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","They brought the donkey and the colt and laid on them their garments, and Jesus sat on them. ");
INSERT INTO engtcent_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A very large crowd spread their garments on the road, and others cut down branches from the trees and also spread them on the road. ");
INSERT INTO engtcent_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","The crowds that went ahead of him and those that followed were crying out, “Hosanna to the Son of David! Blessed is he who comes in the name of the Lord! Hosanna in the highest!” ");
INSERT INTO engtcent_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","As he came into Jerusalem, the whole city was stirred up, saying, “Who is this?” ");
INSERT INTO engtcent_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","So the crowds were saying, “This is the prophet Jesus, who is from Nazareth of Galilee.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Then Jesus entered the courts of God's temple and drove out all who were selling and buying there. He overturned the tables of the money changers and the seats of those who were selling doves. ");
INSERT INTO engtcent_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","And he said to them, “It is written, ‘My house shall be called a house of prayer,’ but you have made it a den of robbers.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Then the lame and the blind came to him in the temple courts, and he healed them. ");
INSERT INTO engtcent_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","But when the chief priests and the scribes saw the wonderful things that he did and the children crying out in the temple courts, “Hosanna to the Son of David,” they were indignant ");
INSERT INTO engtcent_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","and said to him, “Do yoʋ hear what these children are saying?” Jesus said to them, “Yes, have you never read, ‘Out of the mouths of babies and nursing infants yoʋ have prepared praise’?” ");
INSERT INTO engtcent_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","And leaving them, he went out of the city to Bethany and spent the night there. ");
INSERT INTO engtcent_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Early in the morning, as Jesus was returning to the city, he was hungry. ");
INSERT INTO engtcent_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Seeing a lone fig tree by the road, he came to it and found nothing on it but leaves. Then he said to it, “May there never be any fruit from yoʋ again!” And at once the fig tree withered. ");
INSERT INTO engtcent_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","When the disciples saw it, they were amazed, saying, “How did the fig tree wither all at once?” ");
INSERT INTO engtcent_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus answered them, “Truly I say to you, if you have faith and do not doubt, not only will you do what has been done to the fig tree, but even if you say to this mountain, ‘Be taken up and thrown into the sea,’ it will happen. ");
INSERT INTO engtcent_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","And if you have faith, you will receive whatever you ask for in prayer.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","When he entered the temple courts, the chief priests and the elders of the people came up to him as he was teaching and said, “By what authority are yoʋ doing these things? And who gave yoʋ this authority?” ");
INSERT INTO engtcent_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus answered them, “I will also ask you one question. If you tell me the answer, I will also tell you by what authority I am doing these things. ");
INSERT INTO engtcent_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Where did John's authority to baptize come from? From heaven or from men?” So they discussed it among themselves, saying, “If we say, ‘From heaven,’ he will say to us, ‘Why then did you not believe him?’ ");
INSERT INTO engtcent_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","But we are afraid of what the crowd might do if we say, ‘From men,’ for everyone regards John as a prophet.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","So they answered Jesus, “We do not know.” Then he said to them, “Neither will I tell you by what authority I am doing these things. ");
INSERT INTO engtcent_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“But what do you think? A man had two sons. He went to his first son and said, ‘Son, go work today in my vineyard.’ ");
INSERT INTO engtcent_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","His son answered, ‘I will not,’ but afterward he changed his mind and went. ");
INSERT INTO engtcent_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Then the man went to his other son and said the same thing. His other son answered, ‘I will go, sir,’ but he did not go. ");
INSERT INTO engtcent_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Which of the two did the will of his father?” They said to him, “The first.” Jesus said to them, “Truly I say to you, tax collectors and prostitutes are entering the kingdom of God ahead of you. ");
INSERT INTO engtcent_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","For John came to you in the way of righteousness, and you did not believe him, but tax collectors and prostitutes believed him. Yet even after you saw it, you did not change your minds and believe him. ");
INSERT INTO engtcent_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Listen to another parable: There was a master of a house who planted a vineyard, put a fence around it, dug a winepress in it, built a tower, leased it to farmers, and left the country. ");
INSERT INTO engtcent_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","When the season for fruit drew near, he sent his servants to the farmers to receive his fruit. ");
INSERT INTO engtcent_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","But the farmers seized his servants; they beat one, killed another, and stoned yet another. ");
INSERT INTO engtcent_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Again he sent other servants, more than the first group. But the farmers treated them in the same way. ");
INSERT INTO engtcent_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Last of all, he sent them his son, saying, ‘They will have respect for my son.’ ");
INSERT INTO engtcent_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","But when the farmers saw the son, they said among themselves, ‘This is the heir. Come, let us kill him and take possession of his inheritance.’ ");
INSERT INTO engtcent_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","So they took him, threw him out of the vineyard, and killed him. ");
INSERT INTO engtcent_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Now when the owner of the vineyard comes, what will he do to those farmers?” ");
INSERT INTO engtcent_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","They said to him, “He will bring those wretches to a wretched end and lease the vineyard to other farmers who will give him the fruits in their seasons.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus said to them, “Have you never read in the Scriptures, ‘The stone the builders rejected has become the cornerstone; this was the Lord's doing, and it is amazing in our eyes’? ");
INSERT INTO engtcent_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Therefore I tell you that the kingdom of God will be taken away from you and given to a people who will produce its fruit. ");
INSERT INTO engtcent_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","He who falls on this stone will be broken to pieces, but anyone on whom it falls will be crushed.” ");
INSERT INTO engtcent_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","When the chief priests and the Pharisees heard Jesus' parables, they knew he was speaking about them. ");
INSERT INTO engtcent_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Although they were looking for a way to arrest him, they were afraid of the crowds, because the people regarded him as a prophet. ");
INSERT INTO engtcent_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Once again Jesus spoke to them in parables, saying, ");
INSERT INTO engtcent_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“The kingdom of heaven can be compared to a king who prepared a wedding feast for his son. ");
INSERT INTO engtcent_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","He sent his servants to call those who had been invited to the wedding feast, but they would not come. ");
INSERT INTO engtcent_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Again he sent other servants, saying, ‘Tell those who are invited, “Behold, I have prepared my dinner, my oxen and the fattened cattle have been slaughtered, and everything is ready. Come to the wedding feast.” ’ ");
INSERT INTO engtcent_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","But they paid no attention and went away, one to his own field and another to his business. ");
INSERT INTO engtcent_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","The rest seized his servants, mistreated them, and killed them. ");
INSERT INTO engtcent_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","When the king heard about it, he was furious. So he sent his armies, who destroyed those murderers and burned down their city. ");
INSERT INTO engtcent_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Then he said to his servants, ‘The wedding feast is ready, but those who were invited were not worthy. ");
INSERT INTO engtcent_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Go therefore to where the roads exit the city and invite to the wedding feast anyone you find.’ ");
INSERT INTO engtcent_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","So the servants went out to the roads and gathered together all whom they found, both evil and good, and the wedding feast was filled with guests. ");
INSERT INTO engtcent_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“But when the king came in to see the guests, he saw a man there who was not clothed with a wedding garment. ");
INSERT INTO engtcent_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","So he said to him, ‘Friend, how did yoʋ get in here without a wedding garment?’ But the man was speechless. ");
INSERT INTO engtcent_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Then the king said to the servants, ‘Bind his feet and hands, take him away, and throw him into the outer darkness. In that place there will be weeping and gnashing of teeth.’ ");
INSERT INTO engtcent_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","For many are called, but few are chosen.” ");
INSERT INTO engtcent_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Then the Pharisees went and took counsel as to how they might ensnare Jesus in what he said. ");
INSERT INTO engtcent_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","They sent their disciples to him, along with the Herodians, who said to him, “Teacher, we know that yoʋ are true and teach the way of God in truth and defer to no one, for yoʋ do not show partiality. ");
INSERT INTO engtcent_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tell us then, what do yoʋ think? Is it lawful to pay taxes to Caesar or not?” ");
INSERT INTO engtcent_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","But Jesus knew their evil intent and said, “Why are you testing me, you hypocrites? ");
INSERT INTO engtcent_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Show me the coin for the tax.” So they brought him a denarius. ");
INSERT INTO engtcent_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Then he said to them, “Whose image and inscription is this?” ");
INSERT INTO engtcent_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","They said to him, “Caesar's.” So he said to them, “Then render to Caesar the things that are Caesar's, and to God the things that are God's.” ");
INSERT INTO engtcent_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","When they heard this, they were amazed. Then they left him and went away. ");
INSERT INTO engtcent_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","On that day some Sadducees (who say there is no resurrection) came to Jesus and asked him, ");
INSERT INTO engtcent_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Teacher, Moses said, ‘If a man dies without having children, his brother must marry the widow and raise up offspring for him.’ ");
INSERT INTO engtcent_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Now there were seven brothers among us. The first married and died, and having no offspring, he left his wife to his brother. ");
INSERT INTO engtcent_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","The same thing happened to the second and to the third, down to the seventh. ");
INSERT INTO engtcent_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Last of all, the woman also died. ");
INSERT INTO engtcent_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","In the resurrection, therefore, which of the seven will she be the wife of? For they all had her.” ");
INSERT INTO engtcent_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus answered them, “You are in error because you know neither the Scriptures nor the power of God. ");
INSERT INTO engtcent_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","For in the resurrection people neither marry nor are they given in marriage. Instead, they are like angels of God in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","But as for the resurrection of the dead, have you not read what God said to you: ");
INSERT INTO engtcent_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘I am the God of Abraham, the God of Isaac, and the God of Jacob’? He is not the God of the dead, but of the living.” ");
INSERT INTO engtcent_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","And when the crowds heard this, they were astonished at his teaching. ");
INSERT INTO engtcent_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Now when the Pharisees heard that Jesus had silenced the Sadducees, they gathered together. ");
INSERT INTO engtcent_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","And one of them, a lawyer, asked Jesus a question to test him: ");
INSERT INTO engtcent_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Teacher, which is the greatest commandment in the law?” ");
INSERT INTO engtcent_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus said to him, “ ‘Yoʋ shall love the Lord yoʋr God with all yoʋr heart, with all yoʋr soul, and with all yoʋr mind.’ ");
INSERT INTO engtcent_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","This is the most important and greatest commandment. ");
INSERT INTO engtcent_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","And a second like it is this: ‘Yoʋ shall love yoʋr neighbor as yoʋrself.’ ");
INSERT INTO engtcent_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","All the Law and the Prophets hang on these two commandments.” ");
INSERT INTO engtcent_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","While the Pharisees were gathered together, Jesus asked them, ");
INSERT INTO engtcent_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“What do you think about the Christ? Whose son is he?” They said to him, “David's.” ");
INSERT INTO engtcent_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","He said to them, “How is it then that David, in the Spirit, calls him ‘Lord,’ saying, ");
INSERT INTO engtcent_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘The Lord said to my Lord, “Sit at my right hand until I make yoʋr enemies a footstool for yoʋr feet” ’? ");
INSERT INTO engtcent_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","If David calls him ‘Lord,’ how is he his son?” ");
INSERT INTO engtcent_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","No one was able to say anything in reply, nor did anyone dare to ask him questions anymore from that day forward. ");
INSERT INTO engtcent_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Then Jesus said to the crowds and to his disciples, ");
INSERT INTO engtcent_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“The scribes and the Pharisees sit on Moses' seat. ");
INSERT INTO engtcent_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Therefore observe and do all that they tell you to observe. But do not do what they do, for they say things and do not do them. ");
INSERT INTO engtcent_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","They bind burdens that are heavy and hard to bear and lay them on people's shoulders, but they themselves are not willing to lift a finger to move them. ");
INSERT INTO engtcent_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","They do all their works to be seen by others. They make their phylacteries wide and the fringes of their garments long. ");
INSERT INTO engtcent_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","They love the place of honor at banquets, the best seats in the synagogues, ");
INSERT INTO engtcent_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","greetings in the marketplaces, and when others call them ‘Rabbi, Rabbi.’ ");
INSERT INTO engtcent_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","But you are not to be called ‘Rabbi,’ for there is one who is your instructor, the Christ, and you are all brothers. ");
INSERT INTO engtcent_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","And do not call anyone on earth your father, for there is one who is your Father, he who is in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Neither are you to be called instructors, for there is one who is your instructor, the Christ. ");
INSERT INTO engtcent_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","But he who is greater among you must be your servant. ");
INSERT INTO engtcent_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","For whoever exalts himself will be humbled, and whoever humbles himself will be exalted. ");
INSERT INTO engtcent_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“But woe to you, scribes and Pharisees, hypocrites! For you devour widows' houses and for a pretense make long prayers. Therefore you will receive a more severe judgment. ");
INSERT INTO engtcent_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Woe to you, scribes and Pharisees, hypocrites! For you shut people out of the kingdom of heaven. You yourselves do not enter, nor do you let in those who are trying to enter. ");
INSERT INTO engtcent_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Woe to you, scribes and Pharisees, hypocrites! For you cross sea and land to make a single convert, and when he has become one, you make him twice as much a son of hell as yourselves. ");
INSERT INTO engtcent_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Woe to you, blind guides, who say, ‘If anyone swears by the temple, it is nothing; but if anyone swears by the gold of the temple, he is bound by his oath.’ ");
INSERT INTO engtcent_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","You fools and blind men! Which is greater, the gold or the temple that makes the gold sacred? ");
INSERT INTO engtcent_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","You also say, ‘If anyone swears by the altar, it is nothing; but if anyone swears by the gift on the altar, he is bound by his oath.’ ");
INSERT INTO engtcent_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","You fools and blind men! Which is greater, the gift or the altar that makes the gift sacred? ");
INSERT INTO engtcent_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Therefore, whoever swears by the altar swears by it and by everything on it. ");
INSERT INTO engtcent_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","And whoever swears by the temple swears by it and by him who dwells in it. ");
INSERT INTO engtcent_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","And whoever swears by heaven swears by the throne of God and by him who sits upon it. ");
INSERT INTO engtcent_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Woe to you, scribes and Pharisees, hypocrites! For you tithe mint, dill, and cumin, yet you have neglected the weightier matters of the law: justice, mercy, and faith. These you ought to have practiced without neglecting the other things. ");
INSERT INTO engtcent_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","You blind guides, who strain out a gnat but swallow a camel! ");
INSERT INTO engtcent_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Woe to you, scribes and Pharisees, hypocrites! For you cleanse the outside of the cup and the dish, but the inside is filled with the fruits of your robbery and unrighteousness. ");
INSERT INTO engtcent_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yoʋ blind Pharisee! First clean the inside of the cup and the dish, and then the outside of them will also be clean. ");
INSERT INTO engtcent_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Woe to you, scribes and Pharisees, hypocrites! For you are like whitewashed tombs, which appear beautiful on the outside, but inside they are full of the bones of the dead and all uncleanness. ");
INSERT INTO engtcent_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","In the same way, you also appear righteous to others on the outside, but inside you are full of hypocrisy and lawlessness. ");
INSERT INTO engtcent_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Woe to you, scribes and Pharisees, hypocrites! For you build the tombs of the prophets and adorn the graves of the righteous, ");
INSERT INTO engtcent_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","and you say, ‘If we had been alive in the days of our fathers, we would not have been participants with them in shedding the blood of the prophets.’ ");
INSERT INTO engtcent_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Therefore you bear witness against yourselves that you are the sons of those who murdered the prophets. ");
INSERT INTO engtcent_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Fill up, then, the measure of your fathers. ");
INSERT INTO engtcent_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","You serpents, you brood of vipers! How will you escape being sentenced to hell? ");
INSERT INTO engtcent_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Therefore, behold, I am sending you prophets, sages, and scribes. Some of them you will kill and crucify, and some of them you will flog in your synagogues and persecute from town to town. ");
INSERT INTO engtcent_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","As a result, all the righteous blood that has been shed on earth will come upon you, from the blood of righteous Abel to the blood of Zechariah son of Barachiah, whom you murdered between the temple and the altar. ");
INSERT INTO engtcent_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Truly I say to you, all these things will come upon this generation. ");
INSERT INTO engtcent_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem, the city that kills the prophets and stones those who are sent to yoʋ! How often I have wanted to gather yoʋr children together as a hen gathers her chicks under her wings, but you were not willing! ");
INSERT INTO engtcent_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Behold, your house is left to you desolate. ");
INSERT INTO engtcent_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","For I tell you, from now on you will certainly not see me until you say, ‘Blessed is he who comes in the name of the Lord!’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","As Jesus came out from the temple courts and was walking away, his disciples came to him to show him the buildings of the temple. ");
INSERT INTO engtcent_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","But Jesus said to them, “You see all these buildings? Truly I say to you, not one stone will be left here upon another; all of them will be torn down.” ");
INSERT INTO engtcent_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Later, as Jesus was sitting on the Mount of Olives, the disciples came to him privately and said, “Tell us, when will these things happen? And what will be the sign of yoʋr coming and of the end of the age?” ");
INSERT INTO engtcent_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus answered them, “Make sure no one leads you astray. ");
INSERT INTO engtcent_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","For many will come in my name, saying, ‘I am the Christ,’ and they will lead many astray. ");
INSERT INTO engtcent_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","You will hear of wars and rumors of wars. Do not be alarmed, for all these things must take place, but the end is not yet. ");
INSERT INTO engtcent_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","For nation will rise up against nation, and kingdom against kingdom. There will be famines, plagues, and earthquakes in various places. ");
INSERT INTO engtcent_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","But all these things are the beginning of the labor pains. ");
INSERT INTO engtcent_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Then they will hand you over to be tortured and will put you to death, and you will be hated by all nations because of my name. ");
INSERT INTO engtcent_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Many will fall away and will betray one another and hate one another. ");
INSERT INTO engtcent_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Many false prophets will rise up and lead many astray. ");
INSERT INTO engtcent_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Because lawlessness will be increased, the love of many will grow cold, ");
INSERT INTO engtcent_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","but he who endures to the end will be saved. ");
INSERT INTO engtcent_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","And this gospel of the kingdom will be proclaimed in the whole world as a testimony to all nations, and then the end will come. ");
INSERT INTO engtcent_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“So when you see the abomination of desolation, which was spoken of by the prophet Daniel, standing in the holy place” (let the reader understand), ");
INSERT INTO engtcent_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“then those who are in Judea must flee to the mountains. ");
INSERT INTO engtcent_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","He who is on the housetop must not come down to get anything out of his house. ");
INSERT INTO engtcent_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","And he who is in the field must not turn back to get his garments. ");
INSERT INTO engtcent_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Woe to those who are with child and to those who are nursing infants in those days! ");
INSERT INTO engtcent_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pray that your flight will not happen in winter or on a Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","For at that time there will be a great tribulation unlike any other from the beginning of the world until now, and it will never be equaled again. ");
INSERT INTO engtcent_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","If those days had not been cut short, no flesh would be saved. But for the sake of the chosen those days will be cut short. ");
INSERT INTO engtcent_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","If anyone says to you at that time, ‘Behold, here is the Christ!’ or, ‘Here he is!’ do not believe him. ");
INSERT INTO engtcent_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","For false christs and false prophets will rise up and perform great signs and wonders so as to lead astray, if possible, even the chosen. ");
INSERT INTO engtcent_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Behold, I have told you in advance. ");
INSERT INTO engtcent_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","So if they say to you, ‘Behold, he is in the wilderness,’ do not go out, or, ‘Behold, he is in the inner rooms,’ do not believe it. ");
INSERT INTO engtcent_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","For just as lightning comes from the east and shines to the west, so will be the coming of the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","For where the carcass is, there the vultures will be gathered together. ");
INSERT INTO engtcent_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“But immediately after the tribulation of those days, the sun will be darkened, and the moon will not give its light. The stars will fall from heaven, and the powers of the heavens will be shaken. ");
INSERT INTO engtcent_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Then the sign of the Son of Man will appear in the heavens, and all the tribes of the earth will mourn when they see the Son of Man coming on the clouds of heaven with power and great glory. ");
INSERT INTO engtcent_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","And he will send his angels with a loud trumpet call, and they will gather together his chosen from the four winds, from one end of the heavens to the other. ");
INSERT INTO engtcent_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Now learn this lesson from the fig tree: As soon as its branches become tender and put out leaves, you know that summer is near. ");
INSERT INTO engtcent_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","So also, when you see all these things, know that he is near, at the very gates. ");
INSERT INTO engtcent_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Truly I say to you, this generation will certainly not pass away until all these things have taken place. ");
INSERT INTO engtcent_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Heaven and earth will pass away, but my words will certainly not pass away. ");
INSERT INTO engtcent_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“No one knows about that day or hour, not even the angels of heaven, but only my Father. ");
INSERT INTO engtcent_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","As were the days of Noah, so will be the coming of the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","For in the days before the flood, people were eating and drinking, marrying and giving in marriage, until the day when Noah went into the ark. ");
INSERT INTO engtcent_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","They knew nothing about what would happen until the flood came and took them all away. So will it be at the coming of the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Two men will be in the field; one will be taken and one will be left. ");
INSERT INTO engtcent_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Two women will be grinding grain at the mill; one will be taken and one will be left. ");
INSERT INTO engtcent_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Therefore keep watch, for you do not know in what hour your Lord is coming. ");
INSERT INTO engtcent_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","But know this: If the master of the house had known at what time of night the thief was coming, he would have kept watch and not allowed his house to be broken into. ");
INSERT INTO engtcent_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Therefore you also must be ready, for the Son of Man is coming at an hour when you do not expect him. ");
INSERT INTO engtcent_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Who then is the faithful and wise servant, whom his master has set over his household, to give them their food at the proper time? ");
INSERT INTO engtcent_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blessed is that servant whom his master finds doing so when he comes. ");
INSERT INTO engtcent_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Truly I say to you, he will set him over all his possessions. ");
INSERT INTO engtcent_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","But if that evil servant says in his heart, ‘My master is delayed in coming,’ ");
INSERT INTO engtcent_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","and begins to beat his fellow servants and to eat and drink with the drunkards, ");
INSERT INTO engtcent_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","the master of that servant will come on a day when he does not expect him and at an hour he does not foresee, ");
INSERT INTO engtcent_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","and will cut him in two and assign his portion to be with the hypocrites. In that place there will be weeping and gnashing of teeth. ");
INSERT INTO engtcent_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“At that time the kingdom of heaven will be like ten virgins who took their lamps and went out to meet the bridegroom. ");
INSERT INTO engtcent_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Five of them were wise, and five were foolish. ");
INSERT INTO engtcent_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","When those who were foolish took their lamps, they did not take oil with them, ");
INSERT INTO engtcent_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","but the wise took oil in their flasks along with their lamps. ");
INSERT INTO engtcent_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","When the bridegroom was delayed, they all became drowsy and slept. ");
INSERT INTO engtcent_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","But in the middle of the night there was a shout: ‘Behold, the bridegroom is coming! Come out to meet him.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Then all the virgins rose and trimmed their lamps. ");
INSERT INTO engtcent_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","And the foolish ones said to the wise, ‘Give us some of your oil, for our lamps are going out.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","But the wise replied, ‘No, there will not be enough for us and for you. Instead, go to those who sell oil and buy some for yourselves.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","But while they were on their way to buy it, the bridegroom came, and those who were ready went in with him to the wedding feast. Then the door was shut. ");
INSERT INTO engtcent_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Afterward the other virgins also came, saying, ‘Lord, Lord, open the door for us.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","But he answered, ‘Truly I say to you, I do not know you.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Therefore keep watch, for you do not know the day or the hour in which the Son of Man is coming. ");
INSERT INTO engtcent_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“For it is just like a man about to go on a journey, who called his servants and entrusted his possessions to them. ");
INSERT INTO engtcent_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","To one he gave five talents, to another two talents, and to another one talent, each according to his ability. And he immediately went on his journey. ");
INSERT INTO engtcent_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","The man who had received the five talents went and traded with them, and made five more talents. ");
INSERT INTO engtcent_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","In the same way, the man who had received the two talents also earned two more. ");
INSERT INTO engtcent_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","But the man who had received the one talent went and dug a hole in the ground and hid his master's money. ");
INSERT INTO engtcent_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“After a long time the master of those servants came and settled accounts with them. ");
INSERT INTO engtcent_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","The man who had received the five talents came to him and brought the other five talents, saying, ‘Master, yoʋ entrusted me with five talents; behold, I have earned five more talents besides them.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","His master said to him, ‘Well done, good and faithful servant! Yoʋ have been faithful over a few things; I will set yoʋ over many things. Enter into the joy of yoʋr master.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","The man who had received the two talents also came to him and said, ‘Master, yoʋ entrusted me with two talents; behold, I have earned two more talents besides them.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","His master said to him, ‘Well done, good and faithful servant! Yoʋ have been faithful over a few things; I will set yoʋ over many things. Enter into the joy of yoʋr master.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Then the man who had received the one talent came to him and said, ‘Master, I knew that yoʋ were a hard man, reaping where yoʋ did not sow and gathering where yoʋ scattered no seed. ");
INSERT INTO engtcent_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","So I was afraid and went and hid yoʋr talent in the ground. Behold, yoʋ have what is yoʋrs.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","But his master answered him, ‘Yoʋ evil and lazy servant! Yoʋ knew, did yoʋ, that I reap where I have not sown and gather where I have scattered no seed? ");
INSERT INTO engtcent_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Then yoʋ should have deposited my money with the bankers, and when I came I would have received what is mine with interest. ");
INSERT INTO engtcent_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Therefore take the talent from him and give it to the one who has ten talents. ");
INSERT INTO engtcent_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","For everyone who has will be given more, and he will have an abundance. But the one who does not have, even what he has will be taken away from him. ");
INSERT INTO engtcent_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","And throw that worthless servant into the outer darkness. In that place there will be weeping and gnashing of teeth.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“When the Son of Man comes in his glory, and all the holy angels with him, he will sit down on his throne of glory. ");
INSERT INTO engtcent_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","All the nations will be gathered before him, and he will separate them from one another as a shepherd separates the sheep from the goats. ");
INSERT INTO engtcent_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","He will set the sheep on his right and the goats on his left. ");
INSERT INTO engtcent_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Then the King will say to those on his right, ‘Come, you who are blessed by my Father, inherit the kingdom prepared for you from the foundation of the world. ");
INSERT INTO engtcent_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","For I was hungry, and you gave me something to eat; I was thirsty, and you gave me something to drink; I was a stranger, and you took me in; ");
INSERT INTO engtcent_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I was naked, and you clothed me; I was sick, and you looked after me; I was in prison, and you came to visit me.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Then the righteous will answer him, ‘Lord, when did we see yoʋ hungry and feed yoʋ, or thirsty and give yoʋ something to drink? ");
INSERT INTO engtcent_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","When did we see yoʋ as a stranger and take yoʋ in, or naked and clothe yoʋ? ");
INSERT INTO engtcent_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","When did we see yoʋ sick or in prison and come to visit yoʋ?’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","The King will answer them, ‘Truly I say to you, inasmuch as you did it to one of the least of these my brothers, you did it to me.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Then he will say to those on his left, ‘Depart from me, you who are accursed, into the eternal fire prepared for the devil and his angels. ");
INSERT INTO engtcent_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","For I was hungry, and you did not give me anything to eat; I was thirsty, and you did not give me anything to drink; ");
INSERT INTO engtcent_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I was a stranger, and you did not take me in; I was naked, and you did not clothe me; I was sick and in prison, and you did not look after me.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Then they too will answer, ‘Lord, when did we see yoʋ hungry or thirsty or as a stranger or naked or sick or in prison, and not take care of yoʋ?’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","He will answer them, ‘Truly I say to you, inasmuch as you did not do it to one of the least of these, neither did you do it to me.’ ");
INSERT INTO engtcent_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","And these will go away into eternal punishment, but the righteous into eternal life.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","When Jesus had finished saying all these things, he said to his disciples, ");
INSERT INTO engtcent_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“You know that after two days the Passover is coming, and the Son of Man will be delivered up to be crucified.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Then the chief priests, the scribes, and the elders of the people were gathered together in the courtyard of the high priest, whose name was Caiaphas, ");
INSERT INTO engtcent_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","and they plotted together to arrest Jesus secretly and kill him. ");
INSERT INTO engtcent_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","But they said, “Not during the feast, lest there be a riot among the people.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Now when Jesus was in Bethany, in the house of Simon the leper, ");
INSERT INTO engtcent_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a woman came to him with an alabaster jar of very expensive ointment, and she poured it on his head as he reclined at the table. ");
INSERT INTO engtcent_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","When his disciples saw it, they were indignant and said, “Why this waste? ");
INSERT INTO engtcent_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","This ointment could have been sold for a large sum, and the money could have been given to the poor.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aware of this, Jesus said to them, “Why are you causing trouble for this woman? She has done a good deed to me. ");
INSERT INTO engtcent_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","You always have the poor with you, but you will not always have me. ");
INSERT INTO engtcent_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","She has put this ointment on my body to prepare me for burial. ");
INSERT INTO engtcent_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Truly I say to you, wherever this gospel is preached in the whole world, what this woman has done will also be spoken of as a memorial to her.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Then one of the twelve, the one called Judas Iscariot, went to the chief priests ");
INSERT INTO engtcent_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","and said, “What are you willing to give me if I deliver him up to you?” So they set out for him thirty pieces of silver. ");
INSERT INTO engtcent_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","And from then on he was looking for an opportunity to betray Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","On the first day of the Feast of Unleavened Bread, the disciples came to Jesus and said to him, “Where do yoʋ want us to make preparations for yoʋ to eat the Passover?” ");
INSERT INTO engtcent_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","He said, “Go into the city to a certain man and say to him, ‘The Teacher says, “My time is near. I am going to keep the Passover with yoʋ, along with my disciples.” ’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","So the disciples did as Jesus had directed them and prepared the Passover. ");
INSERT INTO engtcent_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","When evening came, Jesus was reclining at the table with the twelve. ");
INSERT INTO engtcent_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","As they were eating, he said, “Truly I say to you, one of you will betray me.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Greatly distressed, they began to say to him one after another, “Surely not I, Lord?” ");
INSERT INTO engtcent_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus answered, “The one who has dipped his hand with me into the dish will betray me. ");
INSERT INTO engtcent_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","The Son of Man indeed goes just as it is written of him, but woe to that man by whom the Son of Man is betrayed! It would have been better for that man if he had not been born.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Then Judas, who betrayed him, replied, “Surely not I, Rabbi?” Jesus said to him, “Yoʋ have said it yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","As they were eating, Jesus took the bread, and when he had given thanks, he broke it, gave it to the disciples, and said, “Take and eat this bread; this is my body.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Then he took the cup, and when he had given thanks, he gave it to them, saying, “Drink from it, all of you, ");
INSERT INTO engtcent_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","for this is my blood of the new covenant, which is poured out for many for the remission of sins. ");
INSERT INTO engtcent_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","But I tell you, from this point forward I will certainly not drink again from this fruit of the vine until that day when I drink it with you anew in the kingdom of my Father.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","And after singing a hymn, they went out to the Mount of Olives. ");
INSERT INTO engtcent_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Then Jesus said to them, “All of you will fall away because of me this night. For it is written, ‘I will strike the shepherd, and the sheep of the flock will be scattered.’ ");
INSERT INTO engtcent_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","But after I have been raised up, I will go ahead of you to Galilee.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter answered him, “Even if everyone else falls away because of yoʋ, I will never fall away.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus said to him, “Truly I say to yoʋ that on this night, before a rooster crows, yoʋ will deny me three times.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","But Peter said to him, “Even if I must die with yoʋ, I will certainly not deny yoʋ.” And all the disciples said the same thing. ");
INSERT INTO engtcent_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Then Jesus went with them to a place called Gethsemane, and he said to the disciples, “Sit here while I go over there and pray.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","And taking with him Peter and the two sons of Zebedee, he began to be sorrowful and distressed. ");
INSERT INTO engtcent_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Then Jesus said to them, “My soul is very sorrowful, even to the point of death; stay here and keep watch with me.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","And going a little farther, he fell on his face and prayed, “My Father, if possible, let this cup pass from me; nevertheless, not as I will, but as yoʋ will.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Then he came to the disciples and found them sleeping, and said to Peter, “So you could not keep watch with me for one hour? ");
INSERT INTO engtcent_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Keep watch and pray, lest you enter into temptation. The spirit indeed is willing, but the flesh is weak.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Again, he went away for a second time and prayed, “My Father, if this cup cannot pass from me unless I drink it, may yoʋr will be done.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Then he came and found them sleeping again, for their eyes were heavy. ");
INSERT INTO engtcent_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","So he left them and went away again and prayed for a third time, saying the same thing. ");
INSERT INTO engtcent_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Then he came to his disciples and said to them, “Sleep on now and take your rest! Behold, the hour has drawn near, and the Son of Man is delivered up into the hands of sinners. ");
INSERT INTO engtcent_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Rise, let us go. Behold, my betrayer has drawn near.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","While he was still speaking, behold, Judas, one of the twelve, came. With him was a large crowd with swords and clubs, sent from the chief priests and elders of the people. ");
INSERT INTO engtcent_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Now his betrayer had given them a sign, saying, “Whomever I kiss, he is the one; arrest him.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Immediately he went up to Jesus and said, “Greetings, Rabbi!” And he kissed him. ");
INSERT INTO engtcent_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus said to him, “Friend, why have yoʋ come?” Then they came forward, took hold of Jesus, and arrested him. ");
INSERT INTO engtcent_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","And behold, one of the men with Jesus stretched out his hand, drew his sword, and struck the servant of the high priest, cutting off his ear. ");
INSERT INTO engtcent_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Then Jesus said to him, “Put yoʋr sword back in its place, for all who take the sword will die by the sword. ");
INSERT INTO engtcent_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Or do yoʋ think that I cannot call on my Father right now, and he will provide me with more than twelve legions of angels? ");
INSERT INTO engtcent_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","How then would the Scriptures be fulfilled that say it must happen this way?” ");
INSERT INTO engtcent_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","In that hour Jesus said to the crowds, “Have you come out to arrest me with swords and clubs as you would against a robber? I sat daily with you, teaching in the temple courts, and you did not arrest me. ");
INSERT INTO engtcent_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","But all this has taken place so that the Scriptures of the prophets would be fulfilled.” Then all the disciples left him and fled. ");
INSERT INTO engtcent_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Now those who had arrested Jesus led him away to Caiaphas the high priest, where the scribes and the elders were assembled. ");
INSERT INTO engtcent_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","But Peter was following him at a distance, coming as far as the courtyard of the high priest. After going inside, he sat with the officers to see the outcome. ");
INSERT INTO engtcent_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Now the chief priests, the elders, and the whole Sanhedrin were seeking false testimony against Jesus, so that they could put him to death, ");
INSERT INTO engtcent_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","but they did not find any. Even though many false witnesses came forward, they did not find any. But at last two false witnesses came forward ");
INSERT INTO engtcent_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","and declared, “This man said, ‘I am able to destroy the temple of God and rebuild it in three days.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","So the high priest stood up and said to him, “Do yoʋ make no answer? What are these men testifying against yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","But Jesus was silent. Then the high priest said to him, “I adjure yoʋ by the living God to tell us if yoʋ are the Christ, the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus said to him, “Yoʋ have said it yoʋrself. Nevertheless I say to you, from now on you will see the Son of Man sitting at the right hand of Power and coming on the clouds of heaven.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Then the high priest tore his garments and said, “He has blasphemed! What further need do we have of witnesses? Behold, you have now heard his blasphemy. ");
INSERT INTO engtcent_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","What do you think?” They answered, “He deserves death.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Then they spit in his face and struck him. Others slapped him, ");
INSERT INTO engtcent_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","saying, “Prophesy to us, yoʋ Christ! Who is it that struck yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Now Peter was sitting outside in the courtyard, and a servant girl came to him and said, “Yoʋ also were with Jesus the Galilean.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","But he denied it before them all, saying, “I do not know what yoʋ are talking about!” ");
INSERT INTO engtcent_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Then he went out to the gateway, and another servant girl saw him and said to the people there, “This man also was with Jesus of Nazareth.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","But again he denied it with an oath: “I do not know the man.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","After a little while, the people standing there came up and said to Peter, “Truly yoʋ also are one of them, for even yoʋr accent gives yoʋ away.” ");
INSERT INTO engtcent_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Then he began to invoke curses and to swear, saying, “I do not know the man.” And immediately a rooster crowed. ");
INSERT INTO engtcent_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Then Peter remembered what Jesus had said to him: “Before a rooster crows, yoʋ will deny me three times.” And he went out and wept bitterly. ");
INSERT INTO engtcent_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Now when morning came, all the chief priests and the elders of the people took counsel against Jesus to put him to death. ");
INSERT INTO engtcent_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","They bound him, led him away, and handed him over to Pontius Pilate, the governor. ");
INSERT INTO engtcent_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","When Judas, who had betrayed him, saw that Jesus had been condemned, he regretted what he had done and returned the thirty pieces of silver to the chief priests and the elders, ");
INSERT INTO engtcent_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","saying, “I have sinned by betraying innocent blood.” But they said, “What is that to us? See to it yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","So he threw the pieces of silver into the temple and departed. Then he went away and hanged himself. ");
INSERT INTO engtcent_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","The chief priests took the pieces of silver and said, “It is not lawful to put them into the temple treasury, since they are a price paid for blood.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","So they took counsel and used the money to buy the potter's field as a burial place for foreigners. ");
INSERT INTO engtcent_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Therefore that field has been called the Field of Blood to this day. ");
INSERT INTO engtcent_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Then what was spoken by the prophet Jeremiah was fulfilled: “They took the thirty pieces of silver, the price of him on whom a price had been set, on whom some of the sons of Israel had set a price, ");
INSERT INTO engtcent_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","and they gave them for the potter's field, as the Lord directed me.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Meanwhile, Jesus stood before the governor, and the governor asked him, “Are yoʋ the king of the Jews?” Jesus said to him, “Yoʋ have said it yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","But when he was accused by the chief priests and the elders, he gave no answer. ");
INSERT INTO engtcent_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Then Pilate said to him, “Do yoʋ not hear all the things they are testifying against yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","But he gave him no answer, not even to a single charge, so the governor was greatly amazed. ");
INSERT INTO engtcent_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Now at the feast the governor was accustomed to release one prisoner for the crowd, whomever they wanted. ");
INSERT INTO engtcent_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","At that time they had a notorious prisoner named Barabbas. ");
INSERT INTO engtcent_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","So when the crowds were gathered together, Pilate said to them, “Whom do you want me to release for you? Barabbas, or Jesus, who is called Christ?” ");
INSERT INTO engtcent_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(For he knew they had handed Jesus over out of envy.) ");
INSERT INTO engtcent_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","While Pilate was sitting on the judgment seat, his wife sent him this message: “Have nothing to do with that righteous man, for I have suffered a great deal today in a dream because of him.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","But the chief priests and the elders persuaded the crowds to ask for Barabbas to be released and for Jesus to be executed. ");
INSERT INTO engtcent_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","In response the governor said to them, “Which of the two do you want me to release for you?” They said, “Barabbas.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","So Pilate said to them, “What then shall I do with Jesus, who is called Christ?” They all said to him, “Let him be crucified!” ");
INSERT INTO engtcent_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Then the governor said, “Why? What evil has he done?” But they cried out all the more, “Let him be crucified!” ");
INSERT INTO engtcent_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","When Pilate saw that he was achieving nothing and that a riot was breaking out, he took water and washed his hands before the crowd, saying, “I am innocent of the blood of this righteous man. See to it yourselves.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","All the people answered, “His blood be on us and on our children!” ");
INSERT INTO engtcent_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Then he released for them Barabbas, but he scourged Jesus and handed him over to be crucified. ");
INSERT INTO engtcent_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Then the governor's soldiers took Jesus with them into the governor's headquarters and gathered against him the entire cohort of soldiers. ");
INSERT INTO engtcent_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","They stripped him and put a scarlet robe on him, ");
INSERT INTO engtcent_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","and then twisted together a crown of thorns and put it on his head. They put a reed in his right hand, and kneeling before him, they mocked him, saying, “Hail, King of the Jews!” ");
INSERT INTO engtcent_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Then they spit on him, took the reed, and beat him repeatedly on his head. ");
INSERT INTO engtcent_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","When they had finished mocking him, they stripped him of the robe and put his own garments back on him. Then they led him away to crucify him. ");
INSERT INTO engtcent_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","As they went out, they found a Cyrenian man named Simon. They pressed him into service, forcing him to carry Jesus' cross. ");
INSERT INTO engtcent_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","When they came to a place called Golgotha (which means, “Place of the Skull”), ");
INSERT INTO engtcent_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","they gave Jesus sour wine to drink, mixed with gall. But when he tasted it, he refused to drink it. ");
INSERT INTO engtcent_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","After crucifying him, they divided his garments among themselves by casting lots. ");
INSERT INTO engtcent_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Then they sat down and kept watch over him there. ");
INSERT INTO engtcent_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Over his head they placed the written charge against him, which read, “This is Jesus, the King of the Jews.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Then two robbers were crucified with him, one on his right and one on his left. ");
INSERT INTO engtcent_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Those who passed by reviled him, shaking their heads ");
INSERT INTO engtcent_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","and saying, “Yoʋ who would destroy the temple and build it in three days, save yoʋrself. If yoʋ are the Son of God, come down from the cross!” ");
INSERT INTO engtcent_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","In the same way the chief priests also, along with the scribes, elders, and Pharisees, were mocking him, saying, ");
INSERT INTO engtcent_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“He saved others, but he cannot save himself. If he is the king of Israel, let him come down now from the cross, and we will believe in him. ");
INSERT INTO engtcent_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","He has put his trust in God; let God deliver him now if he wants him, for he said, ‘I am the Son of God.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","The robbers who were crucified with him were also reviling him in the same way. ");
INSERT INTO engtcent_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","From the sixth hour until the ninth hour, there was darkness over the whole land. ");
INSERT INTO engtcent_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","And about the ninth hour Jesus cried out with a loud voice, “Eli, Eli, lima sabachthani?” that is, “My God, my God, why have yoʋ forsaken me?” ");
INSERT INTO engtcent_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","When some of those standing there heard this, they said, “This man is calling for Elijah.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Immediately one of them ran, got a sponge, filled it with sour wine, put it on a reed, and gave it to him to drink. ");
INSERT INTO engtcent_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","But the rest said, “Leave him alone. Let us see if Elijah comes to save him.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Then Jesus cried out again with a loud voice and gave up his spirit. ");
INSERT INTO engtcent_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","And behold, the veil of the temple was torn in two from top to bottom. The earth was shaken, and the rocks were split. ");
INSERT INTO engtcent_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","The tombs were opened, and the bodies of many saints who had fallen asleep were raised. ");
INSERT INTO engtcent_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(They came out of the tombs, and after his resurrection they went into the holy city and appeared to many.) ");
INSERT INTO engtcent_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Now when the centurion and those who were keeping watch with him over Jesus saw the earthquake and the things that had happened, they became very frightened and said, “Truly this man was the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Many women who had followed Jesus from Galilee and provided for him were there looking on from a distance, ");
INSERT INTO engtcent_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","among whom were Mary Magdalene, Mary the mother of James and Joses, and the mother of the sons of Zebedee. ");
INSERT INTO engtcent_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","When it was evening, there came a rich man from Arimathea named Joseph, who was himself also a disciple of Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","He went to Pilate and asked for Jesus' body. So Pilate commanded that the body be given to him. ");
INSERT INTO engtcent_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joseph took the body, wrapped it in a clean linen cloth, ");
INSERT INTO engtcent_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","and laid it in his own new tomb, which he had hewn in a rock. Then he rolled a large stone against the entrance of the tomb and went away. ");
INSERT INTO engtcent_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene was there, and so was the other Mary, sitting across from the tomb. ");
INSERT INTO engtcent_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","The next day (that is, after the day of Preparation), the chief priests and the Pharisees gathered together before Pilate ");
INSERT INTO engtcent_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","and said, “Sir, we remember that while he was still alive that deceiver said, ‘After three days I will rise again.’ ");
INSERT INTO engtcent_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Therefore command that the tomb be secured until the third day, lest his disciples come by night, steal him away, and say to the people, ‘He has been raised from the dead.’ This last deception would be worse than the first.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate said to them, “You have a guard of soldiers. Go and make it as secure as you know how.” ");
INSERT INTO engtcent_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","So they went and secured the tomb by sealing the stone and posting the guard of soldiers. ");
INSERT INTO engtcent_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","After the Sabbath, at dawn on the first day of the week, Mary Magdalene came to see the tomb along with the other Mary. ");
INSERT INTO engtcent_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","And behold, there was a great earthquake, for an angel of the Lord descended from heaven and came and rolled away the stone from the entrance and sat on it. ");
INSERT INTO engtcent_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","His appearance was like lightning, and his clothing was as white as snow. ");
INSERT INTO engtcent_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","The guards were so afraid of him that they trembled and became like dead men. ");
INSERT INTO engtcent_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Then the angel said to the women, “Do not be afraid, for I know that you are looking for Jesus, who has been crucified. ");
INSERT INTO engtcent_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","He is not here, for he is risen, just as he said. Come see the place where the Lord lay. ");
INSERT INTO engtcent_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Now go quickly and tell his disciples that he is risen from the dead. And behold, he is going ahead of you to Galilee; there you will see him. Listen to what I have told you.” ");
INSERT INTO engtcent_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","So they went out quickly from the tomb with fear and great joy, and ran to tell his disciples. ");
INSERT INTO engtcent_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","As they went on their way to tell his disciples, behold, Jesus met them and said, “Greetings!” So they came to him, took hold of his feet, and worshiped him. ");
INSERT INTO engtcent_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Then Jesus said to them, “Do not be afraid; go tell my brothers to go to Galilee, and there they will see me.” ");
INSERT INTO engtcent_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","As they went, behold, some of the guards went into the city and brought word to the chief priests of all that had taken place. ");
INSERT INTO engtcent_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","After the chief priests had assembled with the elders and taken counsel, they gave a large sum of money to the soldiers ");
INSERT INTO engtcent_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","and said, “Tell people, ‘His disciples came by night and stole him away while we were sleeping.’ ");
INSERT INTO engtcent_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","If this matter is heard before the governor, we will persuade him and keep you free from concern.” ");
INSERT INTO engtcent_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","So they took the money and did as they had been instructed. And this story is still being spread among the Jews today. ");
INSERT INTO engtcent_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Meanwhile, the eleven disciples went to Galilee, to the mountain where Jesus had directed them to go. ");
INSERT INTO engtcent_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","When they saw him, they worshiped him, but some doubted. ");
INSERT INTO engtcent_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Then Jesus came and said to them, “All authority in heaven and on earth has been given to me. ");
INSERT INTO engtcent_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Go and make disciples of all nations, baptizing them in the name of the Father and of the Son and of the Holy Spirit, ");
INSERT INTO engtcent_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","and teaching them to obey everything I have commanded you. And behold, I am with you always, even to the end of the age.” Amen. ");
INSERT INTO engtcent_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","The beginning of the gospel of Jesus Christ, the Son of God. ");
INSERT INTO engtcent_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","As it is written in the Prophets, “Behold, I am sending my messenger ahead of yoʋ, who will prepare yoʋr way before yoʋ, ");
INSERT INTO engtcent_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","the voice of one crying out in the wilderness, ‘Prepare the way for the Lord; make his paths straight,’ ” ");
INSERT INTO engtcent_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John came baptizing in the wilderness and preaching a baptism of repentance for the remission of sins. ");
INSERT INTO engtcent_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","The whole Judean countryside was going out to him, and so were the people of Jerusalem. They were all being baptized by him in the Jordan River, confessing their sins. ");
INSERT INTO engtcent_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Now John was clothed with camel's hair and wore a leather belt around his waist; he ate locusts and wild honey. ");
INSERT INTO engtcent_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","He proclaimed, “After me comes one who is mightier than I, the strap of whose sandals I am not worthy to stoop down and untie. ");
INSERT INTO engtcent_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","I have baptized you with water, but he will baptize you with the Holy Spirit.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","In those days Jesus came from Nazareth of Galilee and was baptized by John in the Jordan. ");
INSERT INTO engtcent_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Immediately as he was coming up from the water, he saw the heavens being split apart and the Spirit descending on him like a dove. ");
INSERT INTO engtcent_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Then a voice came from heaven: “Yoʋ are my beloved Son, in whom I am well pleased.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Immediately the Spirit drove him out into the wilderness, ");
INSERT INTO engtcent_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","and he was there in the wilderness for forty days, being tempted by Satan. He was with the wild beasts, and the angels ministered to him. ");
INSERT INTO engtcent_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","After John was put in prison, Jesus went to Galilee, preaching the gospel of the kingdom of God ");
INSERT INTO engtcent_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","and saying, “The time is fulfilled, and the kingdom of God has drawn near. Repent and believe in the gospel.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","As Jesus was walking by the Sea of Galilee, he saw Simon and Andrew his brother (that is, Simon's brother) casting a net in the sea, for they were fishermen. ");
INSERT INTO engtcent_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus said to them, “Follow me, and I will make you fishers of men.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","So they immediately left their nets and followed him. ");
INSERT INTO engtcent_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Going on a little farther from there, he saw James the son of Zebedee and John his brother as they were in the boat mending their nets. ");
INSERT INTO engtcent_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Immediately he called them, and they left their father Zebedee in the boat with the hired men and followed him. ");
INSERT INTO engtcent_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","They went to Capernaum, and immediately on the Sabbath Jesus went into the synagogue and began teaching. ");
INSERT INTO engtcent_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","The people were astonished at his teaching, because he was teaching them as one who had authority, and not as the scribes. ");
INSERT INTO engtcent_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Now in their synagogue there was a man possessed by an unclean spirit. He cried out, ");
INSERT INTO engtcent_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Leave us alone! What do yoʋ have to do with us, Jesus of Nazareth? Have yoʋ come to destroy us? I know who yoʋ are—the Holy One of God.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","But Jesus rebuked him, saying, “Be silent, and come out of him!” ");
INSERT INTO engtcent_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","So the unclean spirit convulsed the man and came out of him, crying out with a loud voice. ");
INSERT INTO engtcent_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","All the people were amazed so that they questioned among themselves, saying, “What is this? What new teaching is this that with authority he commands even the unclean spirits, and they obey him?” ");
INSERT INTO engtcent_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","And the news about him immediately spread throughout all the surrounding region of Galilee. ");
INSERT INTO engtcent_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","After leaving the synagogue, they immediately went with James and John to the house of Simon and Andrew. ");
INSERT INTO engtcent_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Now Simon's mother-in-law lay sick with a fever, and they immediately told Jesus about her. ");
INSERT INTO engtcent_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","So he went over to her and raised her up, taking hold of her hand. Immediately the fever left her, and she began to serve them. ");
INSERT INTO engtcent_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","When evening came, after the sun had set, they brought to Jesus all who were sick and those who were possessed by demons. ");
INSERT INTO engtcent_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","The whole city was gathered together at the door, ");
INSERT INTO engtcent_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","and he healed many who were sick with various diseases. He also cast out many demons, but he would not allow the demons to speak, because they knew who he was. ");
INSERT INTO engtcent_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Early the next morning, while it was still very dark, Jesus rose and departed. He went off to a desolate place and prayed there. ");
INSERT INTO engtcent_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon and his companions searched diligently for him, ");
INSERT INTO engtcent_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","and when they found him, they said to him, “Everyone is looking for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus said to them, “Let us go into the neighboring towns so that I may preach there also, for that is why I have come.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","So he was preaching in their synagogues in all of Galilee and casting out demons. ");
INSERT INTO engtcent_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Then a leper came up and knelt before him, begging him, “If yoʋ are willing, yoʋ can make me clean.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Moved with compassion, Jesus stretched out his hand, touched the man, and said to him, “I am willing; be made clean.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","When he said this, the leprosy immediately departed from the man, and he was made clean. ");
INSERT INTO engtcent_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Then Jesus sternly warned him and immediately sent him away, ");
INSERT INTO engtcent_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","saying to him, “Be sure not to say anything to anyone, but go show yoʋrself to the priest and offer for yoʋr cleansing what Moses commanded, as a testimony to them.” ");
INSERT INTO engtcent_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","But the man went out and began to proclaim it widely and to spread the news, so that Jesus could no longer openly enter a town, but was out in desolate places. Yet people were coming to him from everywhere. ");
INSERT INTO engtcent_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A few days later Jesus went to Capernaum again, and the people heard that he was at home. ");
INSERT INTO engtcent_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Immediately many were gathered together, so that there was no longer any room, not even at the door, and he was speaking the word to them. ");
INSERT INTO engtcent_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Then some people came to him, bringing a paralytic carried by four men. ");
INSERT INTO engtcent_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Since they were not able to come near Jesus because of the crowd, they uncovered the roof where he was. After digging through it, they let down the mat on which the paralytic was lying. ");
INSERT INTO engtcent_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","When Jesus saw their faith, he said to the paralytic, “Son, yoʋr sins are forgiven yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Now some of the scribes were sitting there and questioning in their hearts: ");
INSERT INTO engtcent_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Why does this man speak such blasphemies? Who can forgive sins but God alone?” ");
INSERT INTO engtcent_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Immediately Jesus knew in his spirit that they were discussing these questions among themselves, so he said to them, “Why are you questioning these things in your hearts? ");
INSERT INTO engtcent_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Which is easier, to say to the paralytic, ‘Yoʋr sins are forgiven,’ or to say, ‘Rise, take up yoʋr mat, and walk’? ");
INSERT INTO engtcent_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","But so that you may know that the Son of Man has authority on earth to forgive sins”—he said to the paralytic— ");
INSERT INTO engtcent_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“I say to yoʋ, rise, pick up yoʋr mat, and go to yoʋr house.” ");
INSERT INTO engtcent_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","So the man immediately rose, picked up his mat, and went out in front of them all, so that they were all amazed and began glorifying God, saying, “We have never seen anything like this!” ");
INSERT INTO engtcent_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Once again Jesus went out by the sea. The entire crowd came to him, and he taught them. ");
INSERT INTO engtcent_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","As he was walking along, he saw Levi the son of Alphaeus sitting at the tax booth. Jesus said to him, “Follow me,” so Levi rose and followed him. ");
INSERT INTO engtcent_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Later, as Jesus was reclining at the table in Levi's house, many tax collectors and sinners reclined with him and his disciples, for there were many who followed him. ");
INSERT INTO engtcent_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","When the scribes and the Pharisees saw Jesus eating with tax collectors and sinners, they said to his disciples, “Why is he eating and drinking with tax collectors and sinners?” ");
INSERT INTO engtcent_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","When Jesus heard this, he said to them, “It is not the healthy who need a physician, but the sick. I did not come to call the righteous, but sinners to repentance.” ");
INSERT INTO engtcent_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Now the disciples of John and the disciples of the Pharisees were fasting. So some people came and said to Jesus, “Why is it that the disciples of John and the disciples of the Pharisees fast, but yoʋr disciples do not fast?” ");
INSERT INTO engtcent_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus said to them, “Can the bridegroom's attendants fast while the bridegroom is with them? As long as they have the bridegroom with them they cannot fast. ");
INSERT INTO engtcent_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","But the days are coming when the bridegroom will be taken away from them, and then they will fast in those days. ");
INSERT INTO engtcent_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“No one sews a piece of unshrunk cloth on an old garment. For the garment's new patch would pull away from the old cloth, and a worse tear would be made. ");
INSERT INTO engtcent_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","And no one puts new wine into old wineskins. For the new wine would burst the wineskins; the wine would be spilled, and the wineskins would be ruined. But new wine must be put into new wineskins.” ");
INSERT INTO engtcent_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","On the Sabbath Jesus was going through the grainfields, and his disciples began to make their way, plucking heads of grain. ");
INSERT INTO engtcent_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","So the Pharisees said to him, “Behold, why are they doing what is not lawful to do on the Sabbath?” ");
INSERT INTO engtcent_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","He said to them, “Have you never read what David did when he had need and was hungry, he and those who were with him, ");
INSERT INTO engtcent_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","how he entered the house of God in the time of Abiathar the high priest and ate the bread of the Presence, which is not lawful for anyone to eat except for the priests, and how he also gave it to those who were with him?” ");
INSERT INTO engtcent_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Then he said to them, “The Sabbath was made for man, not man for the Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","So the Son of Man is Lord even of the Sabbath.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Once again Jesus went into the synagogue, and a man was there who had a withered hand. ");
INSERT INTO engtcent_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Now the Pharisees were watching Jesus closely to see if he would heal the man on the Sabbath, so that they could accuse him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","And he said to the man with the withered hand, “Rise and come forward.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Then Jesus said to them, “Is it lawful on the Sabbath to do good or to do evil, to save life or to kill?” But they were silent. ");
INSERT INTO engtcent_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","After looking around at them with anger, grieved by the hardness of their hearts, he said to the man, “Stretch out yoʋr hand.” So he stretched it out, and his hand was restored, becoming as sound as the other. ");
INSERT INTO engtcent_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Then the Pharisees went out and immediately took counsel with the Herodians against Jesus as to how they might destroy him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","But Jesus withdrew with his disciples to the sea, and a great multitude from Galilee followed him, and also from Judea, ");
INSERT INTO engtcent_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea, and beyond the Jordan. A great multitude of people from around Tyre and Sidon also came to him when they heard about everything he was doing. ");
INSERT INTO engtcent_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Then he told his disciples to have a small boat ready for him, so that the crowd would not crush him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","For he had healed many, so that all who had afflictions were pressing toward him to touch him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Whenever the unclean spirits saw him, they would fall down before him and cry out, “Yoʋ are the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","But he would strictly warn them not to make him known. ");
INSERT INTO engtcent_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Afterward Jesus went up on the mountain and called for those whom he wanted, and they came to him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","He appointed twelve so that they might be with him and so that he might send them out to preach ");
INSERT INTO engtcent_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","and to have authority to heal diseases and cast out demons. ");
INSERT INTO engtcent_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","He appointed Simon (whom he gave the name Peter); ");
INSERT INTO engtcent_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James the son of Zebedee and John the brother of James (whom he gave the name Boanerges, which means, Sons of Thunder); ");
INSERT INTO engtcent_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James the son of Alphaeus, Thaddaeus, Simon the Cananite, ");
INSERT INTO engtcent_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","and Judas Iscariot, who betrayed him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Then they entered a house, and a crowd came together again, so that Jesus and his disciples could not even eat bread. ");
INSERT INTO engtcent_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","When his family heard about it, they went out to restrain him, for they said, “He is out of his mind.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","But the scribes who had come down from Jerusalem said, “He is possessed by Beelzebul,” and, “By the ruler of demons he casts out demons.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","So Jesus called them over and said to them in parables, “How can Satan cast out Satan? ");
INSERT INTO engtcent_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","If a kingdom is divided against itself, that kingdom cannot stand. ");
INSERT INTO engtcent_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","And if a house is divided against itself, that house cannot stand. ");
INSERT INTO engtcent_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","And if Satan has risen up against himself and is divided, he cannot stand, but has come to an end. ");
INSERT INTO engtcent_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","No one can enter the house of a strong man and plunder his goods unless he first binds the strong man. Then he can plunder his house. ");
INSERT INTO engtcent_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Truly I say to you, all sins will be forgiven the sons of men, and whatever blasphemies they utter. ");
INSERT INTO engtcent_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","But whoever blasphemes against the Holy Spirit never has forgiveness, but is subject to eternal judgment.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","He said this because they were saying, “He has an unclean spirit.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Then Jesus' brothers and mother came, and standing outside, they sent word to him and called for him. ");
INSERT INTO engtcent_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","There was a crowd sitting around Jesus, and they said to him, “Behold, yoʋr mother, yoʋr brothers, and yoʋr sisters are outside looking for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","But he answered them, “Who is my mother, or my brothers?” ");
INSERT INTO engtcent_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","And looking around in a circle at the people sitting there, he said, “Behold, these are my mother and my brothers! ");
INSERT INTO engtcent_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","For whoever does the will of God is my brother and my sister and mother.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Once again Jesus began to teach by the sea, and a large crowd was gathered around him. So he got into the boat and sat in it on the sea, while the entire crowd was beside the sea on the shore. ");
INSERT INTO engtcent_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Then he taught them many things in parables, and in his teaching he said to them, ");
INSERT INTO engtcent_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Listen! A sower went out to sow. ");
INSERT INTO engtcent_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","As he sowed, some seed fell along the path, and the birds came and devoured it. ");
INSERT INTO engtcent_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Other seed fell on rocky ground, where it did not have much soil, and it sprang up immediately because it had no depth of soil. ");
INSERT INTO engtcent_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","But when the sun rose, it was scorched; and because it had no root, it withered away. ");
INSERT INTO engtcent_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Other seed fell among the thorns, and the thorns grew up and choked it, and it produced no fruit. ");
INSERT INTO engtcent_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","But other seed fell into good soil, and as the seeds grew and increased, they produced fruit and bore thirty, sixty, or even a hundred times more than what was sown.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Then he said, “He who has ears to hear, let him hear.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","When he was alone with the twelve and the others who were around him, they asked him about the parable. ");
INSERT INTO engtcent_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","So he said to them, “To you it has been given to know the mystery of the kingdom of God, but to those who are outside everything is spoken in parables, ");
INSERT INTO engtcent_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","so that ‘they may see but not perceive, and hear but not understand, lest they should turn back and be forgiven of their sins.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Then he said to them, “Do you not understand this parable? How then will you understand all the other parables? ");
INSERT INTO engtcent_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","The sower sows the word. ");
INSERT INTO engtcent_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Now some people are like the seed along the path, where the word is sown. When they hear, Satan immediately comes and takes away the word that is sown in their hearts. ");
INSERT INTO engtcent_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Likewise, some people are like the seed sown on rocky ground. When they hear the word, they immediately receive it with joy. ");
INSERT INTO engtcent_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yet they have no root in themselves, but are only temporary. When tribulation or persecution arises on account of the word, they immediately fall away. ");
INSERT INTO engtcent_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Others are like the seed sown among the thorns. They hear the word, ");
INSERT INTO engtcent_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","but the cares of this world, the deceitfulness of riches, and the desire for other things enter in and choke the word, and it becomes unfruitful. ");
INSERT INTO engtcent_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","But others are like the seed sown on the good soil. They hear the word, receive it, and bear thirty, sixty, or even a hundred times more fruit than was sown.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","He also said to them, “Is a lamp brought in to be put under a basket, or under a bed? Is it not brought in to be set on a lampstand? ");
INSERT INTO engtcent_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","For there is nothing hidden that will not be made manifest, nor has anything been made secret except to come to light. ");
INSERT INTO engtcent_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","If anyone has ears to hear, let him hear.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Then he said to them, “Consider what you hear. With the measure you use it will be measured to you, and more will be added to you who hear. ");
INSERT INTO engtcent_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","For whoever has will be given more, but whoever does not have, even what he has will be taken away from him.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","He also said, “The kingdom of God is like a man who scatters seed on the ground. ");
INSERT INTO engtcent_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","He sleeps and rises night and day, and the seed sprouts and grows; he does not know how. ");
INSERT INTO engtcent_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","For the earth produces a crop by itself: first the stalk, then the head, then the full grain in the head. ");
INSERT INTO engtcent_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","When the crop is ready, the man immediately sends in the sickle, for the harvest has come.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Then Jesus said, “To what shall we compare the kingdom of God, or what parable can we use to describe it? ");
INSERT INTO engtcent_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","It is like a grain of mustard seed, which, when it is sown on the ground, is smaller than all the seeds on earth. ");
INSERT INTO engtcent_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yet when it is sown, it grows and becomes larger than all the garden plants and produces large branches, so that the birds of the sky can nest in its shade.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","With many similar parables he spoke the word to them, to the extent that they were able to understand it. ");
INSERT INTO engtcent_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","He did not speak to them without using a parable, but privately he explained everything to his disciples. ");
INSERT INTO engtcent_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","On that day, when evening came, Jesus said to his disciples, “Let us cross over to the other side of the sea.” ");
INSERT INTO engtcent_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","So they left the crowd and took him with them in the boat, just as he was. Other little boats were also with him. ");
INSERT INTO engtcent_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Now a great windstorm arose, and the waves were beating against the boat, so that it was nearly swamped. ");
INSERT INTO engtcent_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","But Jesus was in the stern, asleep on a cushion. So they woke him up and said to him, “Teacher, do yoʋ not care that we are perishing?” ");
INSERT INTO engtcent_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Then he woke up and rebuked the wind and said to the sea, “Peace! Be still!” So the wind ceased, and there was a great calm. ");
INSERT INTO engtcent_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Then he said to them, “Why are you so afraid? How is it that you have no faith?” ");
INSERT INTO engtcent_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","And they were filled with great fear and said to one another, “Who then is this, that even the wind and the sea obey him?” ");
INSERT INTO engtcent_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Then they came to the other side of the sea, to the region of the Gadarenes. ");
INSERT INTO engtcent_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","As Jesus got out of the boat, he was immediately met by a man from the tombs who had an unclean spirit. ");
INSERT INTO engtcent_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","This man lived among the tombs, and no one could bind him, not even with chains. ");
INSERT INTO engtcent_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","For he had often been bound with shackles and chains, but he tore the chains apart and broke the shackles in pieces. No one was strong enough to subdue him. ");
INSERT INTO engtcent_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Night and day, on the mountains and among the tombs, he would continually cry out and cut himself with stones. ");
INSERT INTO engtcent_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","When he saw Jesus from a distance, he ran and bowed down before him. ");
INSERT INTO engtcent_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Then he cried out with a loud voice and said, “What do yoʋ have to do with me, Jesus, Son of the Most High God? I adjure yoʋ by God, do not torment me.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","For Jesus had said to him, “Come out of the man, yoʋ unclean spirit!” ");
INSERT INTO engtcent_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Then Jesus asked him, “What is yoʋr name?” He answered, “My name is Legion, for we are many.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","And he earnestly begged Jesus not to send them out of that region. ");
INSERT INTO engtcent_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Now there was a large herd of pigs feeding there near the mountain. ");
INSERT INTO engtcent_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","All the demons begged Jesus, “Send us into the pigs, so that we may go into them.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","So he immediately gave them permission, and the unclean spirits came out and went into the pigs. Then the herd, about two thousand in number, rushed down the steep bank into the sea and drowned in the sea. ");
INSERT INTO engtcent_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Those who had been feeding the pigs then ran off and reported it in the city and in the countryside. So the people went out to see what had happened. ");
INSERT INTO engtcent_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","They came to Jesus and saw the man who had been possessed by demons sitting there, clothed and in his right mind—the man who had been possessed by the “Legion”—and they were afraid. ");
INSERT INTO engtcent_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Those who had seen it told them what had happened to the man who had been possessed by demons, and they also told them about the pigs. ");
INSERT INTO engtcent_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Then the people began begging Jesus to depart from their region. ");
INSERT INTO engtcent_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","When Jesus got into the boat, the man who had been possessed by demons begged to go with him. ");
INSERT INTO engtcent_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","But Jesus did not permit him to do so. Instead, he said to him, “Go to yoʋr house and to yoʋr people, and report to them all that the Lord has done for yoʋ and how he has had mercy on yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","So the man went away and began to proclaim in the Decapolis all that Jesus had done for him, and all the people were amazed. ");
INSERT INTO engtcent_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","When Jesus had again crossed over in the boat to the other side of the sea, a large crowd was gathered around him, and he was by the sea. ");
INSERT INTO engtcent_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","And behold, one of the rulers of the synagogue came, whose name was Jairus. When he saw Jesus, he fell down at his feet ");
INSERT INTO engtcent_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","and begged him earnestly, “My little daughter is at the point of death. Please come and lay yoʋr hands on her so that she may be healed. Then she will live.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","So Jesus went with him, and a large crowd followed him and pressed in on him. ");
INSERT INTO engtcent_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Now there was a woman who had suffered from a flow of blood for twelve years. ");
INSERT INTO engtcent_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","She had suffered a great deal under many physicians and had spent all she had, yet received no benefit from it, but had only grown worse. ");
INSERT INTO engtcent_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","When she heard about Jesus, she came up behind him in the crowd and touched his garment. ");
INSERT INTO engtcent_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","For she said, “If I touch even his garments, I will be healed.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Immediately her flow of blood was dried up, and she knew in her body that she had been healed from her affliction. ");
INSERT INTO engtcent_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus immediately perceived in himself that power had gone out from him, so he turned around in the crowd and said, “Who touched my garments?” ");
INSERT INTO engtcent_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","His disciples said to him, “Yoʋ see the crowd pressing in on yoʋ, and yet yoʋ say, ‘Who touched me?’ ” ");
INSERT INTO engtcent_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","But he kept looking around to see who had done it. ");
INSERT INTO engtcent_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Now the woman was frightened and trembling, knowing what had happened to her, so she came and fell down before him and told him the whole truth. ");
INSERT INTO engtcent_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Then Jesus said to her, “Daughter, yoʋr faith has healed yoʋ. Go in peace, and be healed of yoʋr affliction.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","While he was still speaking, some people came from the ruler of the synagogue's house and said, “Yoʋr daughter has died; why trouble the teacher any further?” ");
INSERT INTO engtcent_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","But when Jesus heard what they said, he immediately said to the ruler of the synagogue, “Do not be afraid; just believe.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","From that point he did not allow anyone to accompany him except Peter, James, and John the brother of James. ");
INSERT INTO engtcent_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","When he came to the ruler of the synagogue's house, he saw a commotion, with people weeping and wailing loudly. ");
INSERT INTO engtcent_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Then he went in and said to them, “Why are you making a commotion and weeping? The child is not dead but sleeping.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","And they began laughing at him. But he put them all outside, took the child's father and mother and those who were with him, and went in to where the child was lying. ");
INSERT INTO engtcent_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Then he took hold of the child's hand and said to her, “Talitha, koumi,” which means, “Little girl, I say to yoʋ, arise.” ");
INSERT INTO engtcent_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Immediately the girl got up and began to walk (for she was twelve years old), and they were overcome with great amazement. ");
INSERT INTO engtcent_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Then he gave them strict orders not to let anyone know about it, and he told them to give her something to eat. ");
INSERT INTO engtcent_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Then Jesus left that place and went to his hometown, and his disciples followed him. ");
INSERT INTO engtcent_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","When the Sabbath came, he began to teach in the synagogue, and many who heard him were astonished, saying, “Where did this man get these things?” and, “What is this wisdom that has been given to him?” and, “Such miracles as these are being done by his hands! ");
INSERT INTO engtcent_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Is this not the carpenter, the son of Mary, and the brother of James, Joses, Judas, and Simon? Are not his sisters here with us?” And they took offense at him. ");
INSERT INTO engtcent_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Then Jesus said to them, “A prophet is not without honor except in his hometown, among his relatives, and in his own household.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","So he could do no miracles there, except that he laid his hands on a few sick people and healed them. ");
INSERT INTO engtcent_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","And he was amazed at their unbelief. Then Jesus went around among the villages teaching. ");
INSERT INTO engtcent_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","He summoned the twelve and began to send them out two by two, giving them authority over unclean spirits. ");
INSERT INTO engtcent_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","He instructed them to take nothing for their journey except a staff—no knapsack, no bread, and no copper money in their belts. ");
INSERT INTO engtcent_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","He told them to wear sandals but not an extra tunic. ");
INSERT INTO engtcent_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","He also said to them, “Whenever you enter a house, stay there until you leave that place. ");
INSERT INTO engtcent_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","If anyone will not receive you or listen to you, shake the dust off your feet as you leave that place as a testimony against them. Truly I say to you, it will be more tolerable for Sodom and Gomorrah on the day of judgment than for that city.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","So they went out and preached that people should repent. ");
INSERT INTO engtcent_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","They also cast out many demons and anointed with oil many who were sick and healed them. ");
INSERT INTO engtcent_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Now King Herod heard about this, for Jesus' name had become known, and he said, “John the Baptist has been raised from the dead, and that is why these mighty powers are at work in him.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Others said, “He is Elijah.” And others said, “He is a prophet, like one of the prophets of old.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","But when Herod heard this, he said, “This is John, whom I beheaded; he has been raised from the dead.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","For Herod himself had sent men to arrest John and chain him in prison on account of Herodias, his brother Philip's wife, whom Herod had married. ");
INSERT INTO engtcent_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","For John had been saying to Herod, “It is not lawful for yoʋ to have yoʋr brother's wife.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","So Herodias held a grudge against John and wanted to kill him, but she was not able to do so. ");
INSERT INTO engtcent_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","For Herod feared John, knowing that he was a righteous and holy man, and he protected him. When Herod listened to John, he would listen to him gladly and do many things. ");
INSERT INTO engtcent_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","But an opportune day came. On his birthday Herod prepared a banquet for his nobles, military commanders, and the prominent men of Galilee. ");
INSERT INTO engtcent_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","When the daughter of Herodias came in and danced, she pleased Herod and his guests. So the king said to the girl, “Ask me for whatever yoʋ wish, and I will give it to yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","He swore to her, “Whatever yoʋ ask me, I will give to yoʋ, up to half my kingdom.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","So she went out and said to her mother, “What should I ask for?” Her mother said, “The head of John the Baptist.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Immediately the girl came in with haste to the king and made her request, saying, “I want yoʋ to give me at once the head of John the Baptist on a platter.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","The king was very sad, but because of his oaths and his guests he did not want to reject her. ");
INSERT INTO engtcent_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","So the king immediately sent an executioner and commanded that John's head be brought back. ");
INSERT INTO engtcent_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","The executioner then went and beheaded John in the prison, brought his head on a platter, and gave it to the girl. And the girl gave it to her mother. ");
INSERT INTO engtcent_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","When John's disciples heard about it, they came and took his body and laid it in a tomb. ");
INSERT INTO engtcent_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Meanwhile, the apostles gathered around Jesus and told him about all they had done and taught. ");
INSERT INTO engtcent_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Then he said to them, “Come away by yourselves to a desolate place and rest for a little while.” For many people were coming and going, and Jesus and his apostles did not even have an opportunity to eat. ");
INSERT INTO engtcent_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","So they went away to a desolate place in the boat by themselves. ");
INSERT INTO engtcent_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Now many saw them going away and recognized Jesus. They ran together on foot from all the towns, got there ahead of them, and then gathered around him. ");
INSERT INTO engtcent_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","When Jesus went ashore and saw a large crowd, he was moved with compassion for them, because they were like sheep without a shepherd. So he began to teach them many things. ");
INSERT INTO engtcent_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","When the hour was already quite late, his disciples came to him and said, “This place is desolate, and the hour is now late. ");
INSERT INTO engtcent_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Send the people away so that they can go into the surrounding countryside and villages and buy themselves some bread, for they have nothing to eat.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","But Jesus answered them, “You give them something to eat.” They said to him, “Are we to go and buy two hundred denarii worth of bread and give it to them to eat?” ");
INSERT INTO engtcent_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","He said to them, “How many loaves do you have? Go and see.” When they found out, they said, “Five, and two fish.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Then he directed them to have all the people sit down in groups on the green grass. ");
INSERT INTO engtcent_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","So they sat down in groups of hundreds and fifties. ");
INSERT INTO engtcent_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Then he took the five loaves and the two fish, and looking up to heaven, he said the blessing. He broke the loaves and gave them to his disciples to set before the people, and he divided the two fish among them all. ");
INSERT INTO engtcent_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","They all ate and were filled, ");
INSERT INTO engtcent_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","and the disciples picked up twelve baskets full of the broken pieces and of the fish. ");
INSERT INTO engtcent_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Now those who had eaten the loaves were five thousand men. ");
INSERT INTO engtcent_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Immediately Jesus compelled his disciples to get into the boat and go ahead of him to the other side of the sea, to Bethsaida, while he sent the crowd away. ");
INSERT INTO engtcent_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","After taking leave of them, he went to the mountain to pray. ");
INSERT INTO engtcent_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","When evening came, the boat was in the middle of the sea, and he was alone on the land. ");
INSERT INTO engtcent_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","He saw the disciples straining as they rowed, for the wind was against them. About the fourth watch of the night he came to them, walking on the sea, and intended to pass them by. ");
INSERT INTO engtcent_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","But when they saw him walking on the sea, they thought it was a ghost and cried out. ");
INSERT INTO engtcent_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","For they all saw him and were terrified. But Jesus immediately said to them, “Take courage! It is I; do not be afraid.” ");
INSERT INTO engtcent_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Then he got into the boat with them, and the wind ceased. And they were utterly and completely amazed and in awe; ");
INSERT INTO engtcent_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","for they did not understand the significance of what had happened with the loaves, because their hearts were hardened. ");
INSERT INTO engtcent_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","When they had crossed the sea, they came to the land of Gennesaret and moored the boat. ");
INSERT INTO engtcent_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","When they got out of the boat, people immediately recognized Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","So the people ran around throughout the entire surrounding region and began to carry the sick on mats to wherever they heard he was. ");
INSERT INTO engtcent_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","And wherever he went, to villages, cities, or the countryside, they would lay the sick in the marketplaces and beg him to let the sick touch even the fringe of his garment. And all who touched it were healed. ");
INSERT INTO engtcent_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Now the Pharisees and some of the scribes who had come from Jerusalem were gathered around Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","When they saw some of his disciples eating bread with hands that were defiled (that is, unwashed), they criticized them. ");
INSERT INTO engtcent_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(For none of the Pharisees or Jews eat unless they wash their hands properly, holding to the tradition of the elders. ");
INSERT INTO engtcent_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","And when they come from the marketplace they do not eat unless they have washed. There are also many other traditions they observe, such as the washing of cups, pots, copper vessels, and dining couches.) ");
INSERT INTO engtcent_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Now the Pharisees and the scribes asked Jesus, “Why do yoʋr disciples not walk according to the tradition of the elders, but eat bread with unwashed hands?” ");
INSERT INTO engtcent_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","He answered them, “Isaiah prophesied rightly about you hypocrites, as it is written, ‘This people honors me with their lips, but their heart is far from me. ");
INSERT INTO engtcent_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","They worship me in vain, teaching as doctrines the commandments of men.’ ");
INSERT INTO engtcent_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","For you have neglected the commandment of God and are holding to the tradition of men, such as various washings of pots and cups. And you do many other similar things such as these.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Then he said to them, “You have a fine way of setting aside the commandment of God so that you may keep your tradition! ");
INSERT INTO engtcent_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","For Moses said, ‘Honor yoʋr father and yoʋr mother,’ and, ‘Whoever speaks evil of his father or mother must surely die.’ ");
INSERT INTO engtcent_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","But you teach that it is acceptable for a man to say to his father or mother, ‘Whatever benefit yoʋ might have received from me is Corban’ ” (that is, a gift devoted to God). ");
INSERT INTO engtcent_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“In this way you no longer permit him to do anything for his father or his mother, ");
INSERT INTO engtcent_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","thus nullifying the word of God by your tradition that you have handed down. And you do many similar things such as these.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Then Jesus called over the entire crowd and said to them, “Listen to me, all of you, and understand: ");
INSERT INTO engtcent_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","There is nothing outside of a person that can defile him by going into him, but the things that come out of a person are what defile him. ");
INSERT INTO engtcent_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","If anyone has ears to hear, let him hear.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","After Jesus had left the crowd and gone into a house, his disciples asked him about the parable. ");
INSERT INTO engtcent_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","He said to them, “So are you also without understanding? Do you not understand that whatever goes into a person from the outside cannot defile him? ");
INSERT INTO engtcent_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","For it does not go into his heart but into his stomach; then it goes out into the latrine, thus purifying all foods.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","He also said, “It is what comes out of a person that defiles a person. ");
INSERT INTO engtcent_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","For from within, from the hearts of men, come evil thoughts, adultery, fornication, murder, ");
INSERT INTO engtcent_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","theft, covetousness, wickedness, deceit, sensuality, envy, slander, pride, and foolishness. ");
INSERT INTO engtcent_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","All these evil things come from within and defile a person.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Then Jesus rose from there and went away to the region of Tyre and Sidon. He went into a house and did not want anyone to know it, yet he could not escape notice. ");
INSERT INTO engtcent_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","For a woman whose little daughter had an unclean spirit heard about him and came and fell at his feet. ");
INSERT INTO engtcent_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","(This woman was a Greek, a Syrophoenician by birth.) She asked Jesus to cast the demon out of her daughter. ");
INSERT INTO engtcent_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","But Jesus said to her, “Let the children first be filled, for it is not good to take the children's bread and throw it to the dogs.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","She answered him, “Yes, Lord, yet even the dogs under the table eat the children's crumbs.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Then he said to her, “Because of this reply, yoʋ may go; the demon has come out of yoʋr daughter.” ");
INSERT INTO engtcent_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","And when she went to her house, she found the demon gone and her daughter lying in bed. ");
INSERT INTO engtcent_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Then Jesus came back from the region of Tyre and Sidon and went to the Sea of Galilee, within the region of the Decapolis. ");
INSERT INTO engtcent_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Some people brought to him a deaf man who had a speech impediment, and they begged him to lay his hand on the man. ");
INSERT INTO engtcent_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","So Jesus took him aside privately, away from the crowd. Then he put his fingers into the man's ears, spit, and touched the man's tongue. ");
INSERT INTO engtcent_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","And looking up to heaven, he sighed and said to him, “Ephphatha” (that is, “Be opened”). ");
INSERT INTO engtcent_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Immediately the man's ears were opened, the impediment of his tongue was removed, and he began speaking clearly. ");
INSERT INTO engtcent_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Then Jesus ordered them not to tell anyone. But as much as he ordered them not to do so, they proclaimed it all the more. ");
INSERT INTO engtcent_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","And they were completely astonished, saying, “He has done all things well. He even makes the deaf hear and the mute speak.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","In those days, when there was a very large crowd that had nothing to eat, Jesus called his disciples over and said to them, ");
INSERT INTO engtcent_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“I have compassion on the crowd because they have stayed with me now for three days and have nothing to eat. ");
INSERT INTO engtcent_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","If I send them away to their homes without having eaten, they will faint on the way, for some of them have come from far away.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","His disciples answered him, “How can anyone feed these people with bread here in the wilderness?” ");
INSERT INTO engtcent_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","He asked them, “How many loaves do you have?” They said, “Seven.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","So he commanded the crowd to sit down on the ground, and taking the seven loaves, he gave thanks, broke them, and gave them to his disciples to distribute, and they set them before the crowd. ");
INSERT INTO engtcent_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","They also had a few small fish. After blessing the fish, Jesus told the disciples to set them before the crowd as well. ");
INSERT INTO engtcent_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","The people ate and were filled, and the disciples picked up what was left over of the broken pieces, seven baskets full. ");
INSERT INTO engtcent_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","There were about four thousand men who had eaten. After sending them away, ");
INSERT INTO engtcent_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesus immediately got into the boat with his disciples and went to the district of Dalmanutha. ");
INSERT INTO engtcent_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Then the Pharisees came and began to argue with Jesus, asking him for a sign from heaven, to test him. ");
INSERT INTO engtcent_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sighing deeply in his spirit, he said, “Why does this generation ask for a sign? Truly I say to you, no sign will be given to this generation.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Then he left them, got into the boat again, and went away to the other side of the sea. ");
INSERT INTO engtcent_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Now the disciples had forgotten to bring bread, and they had nothing with them in the boat except for one loaf. ");
INSERT INTO engtcent_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Then Jesus gave them strict orders, saying, “Watch out! Beware of the leaven of the Pharisees and the leaven of Herod.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","So they discussed this with one another, saying, “He must have said this because we have no bread.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aware of this, Jesus said to them, “Why are you discussing the fact that you have no bread? Do you not yet perceive or understand? Are your hearts still hardened? ");
INSERT INTO engtcent_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Having eyes do you not see, and having ears do you not hear? Do you not remember? ");
INSERT INTO engtcent_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","When I broke the five loaves for the five thousand, how many baskets full of broken pieces did you pick up?” They said to him, “Twelve.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“And when I broke the seven loaves for the four thousand, how many baskets full of broken pieces did you pick up?” They said, “Seven.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Then he said to them, “How is it that you do not understand?” ");
INSERT INTO engtcent_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","When Jesus came to Bethsaida, some people brought to him a blind man and begged Jesus to touch him. ");
INSERT INTO engtcent_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","So he took the blind man by the hand and led him out of the village. Then he spit on the man's eyes, laid his hands on him, and asked him if he saw anything. ");
INSERT INTO engtcent_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","The man looked up and said, “I can see people, but they look like trees walking around.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","So Jesus put his hands on the man's eyes again and had him look up. Then the man's sight was restored, and he saw everyone clearly. ");
INSERT INTO engtcent_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","And Jesus sent him away to his house, saying, “Do not go into the village or tell anyone in the village what has happened.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Then Jesus went on to the villages of Caesarea Philippi along with his disciples. On the way he asked his disciples, “Who do people say that I am?” ");
INSERT INTO engtcent_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","They answered, “Some say John the Baptist, others say Elijah, and others say that yoʋ are one of the prophets.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","He said to them, “But who do you say that I am?” Peter answered him, “Yoʋ are the Christ.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","And Jesus warned them not to tell anyone about him. ");
INSERT INTO engtcent_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Then he began to teach them that the Son of Man must suffer many things and be rejected by the elders, the chief priests, and the scribes, and that he must be killed and after three days rise again. ");
INSERT INTO engtcent_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","He was stating the matter plainly, so Peter took him aside and began to rebuke him. ");
INSERT INTO engtcent_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","But turning around and looking at his disciples, he rebuked Peter, saying, “Get behind me, Satan! For yoʋ are not thinking about the things of God, but the things of men.” ");
INSERT INTO engtcent_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Then he called the crowd over, along with his disciples, and said to them, “Whoever wants to be one of my disciples must deny himself, take up his cross, and follow me. ");
INSERT INTO engtcent_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","For whoever wants to save his life will lose it, but whoever loses his life for my sake and for the sake of the gospel will save it. ");
INSERT INTO engtcent_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","For what will it benefit a person if he gains the whole world but forfeits his soul? ");
INSERT INTO engtcent_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Or what can a person give in exchange for his soul? ");
INSERT INTO engtcent_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","If anyone is ashamed of me and my words in this adulterous and sinful generation, the Son of Man will also be ashamed of him when he comes in the glory of his Father with the holy angels.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","And he said to them, “Truly I say to you, there are some standing here who will certainly not taste death until they see the kingdom of God come with power.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","After six days Jesus took Peter, James, and John, and led them up on a high mountain by themselves. There he was transfigured before them. ");
INSERT INTO engtcent_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","His garments became radiant and extremely white, like snow, such as no launderer on earth could whiten them. ");
INSERT INTO engtcent_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Then Elijah appeared to them with Moses, and they were talking with Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","So Peter said to Jesus, “Rabbi, it is good for us to be here. Let us make three shelters, one for yoʋ, one for Moses, and one for Elijah.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(For they were terrified, and he did not know what to say.) ");
INSERT INTO engtcent_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Then a cloud came and overshadowed them, and a voice came from the cloud: “This is my beloved Son; listen to him!” ");
INSERT INTO engtcent_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","And suddenly, when they looked around, they no longer saw anyone with them but Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","As they were coming down from the mountain, Jesus ordered them to tell no one what they had seen until the Son of Man had risen from the dead. ");
INSERT INTO engtcent_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","So they kept the matter to themselves, discussing what this “rising from the dead” could mean. ");
INSERT INTO engtcent_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Then they asked him, “Why do the scribes say that Elijah must come first?” ");
INSERT INTO engtcent_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","He answered them, “Elijah does indeed come first to restore all things. How then is it written that the Son of Man must suffer many things and be treated with contempt? ");
INSERT INTO engtcent_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","But I tell you that Elijah has indeed come, and they did to him whatever they wanted, just as it is written about him.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","When Jesus came back to the other disciples, he saw a large crowd around them, and some scribes arguing with them. ");
INSERT INTO engtcent_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","When the whole crowd saw him, they were greatly amazed and immediately ran up and greeted him. ");
INSERT INTO engtcent_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Then he asked the scribes, “What are you arguing with them about?” ");
INSERT INTO engtcent_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","One man from among the crowd answered, “Teacher, I brought yoʋ my son, who has a spirit that makes him mute. ");
INSERT INTO engtcent_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Whenever it seizes him, it throws him down, and he foams at the mouth, grinds his teeth, and becomes rigid. I asked yoʋr disciples to cast it out, but they were not able to do so.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus answered him, “O faithless generation, how long shall I be with you? How long shall I bear with you? Bring him to me.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","So they brought the boy to him. When the spirit saw Jesus, it immediately threw the boy into convulsions, and he fell on the ground and rolled around, foaming at the mouth. ");
INSERT INTO engtcent_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Then Jesus asked the boy's father, “How long has this been happening to him?” The father said, “From childhood. ");
INSERT INTO engtcent_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","It often throws him into the fire and into the water to destroy him. But if yoʋ are able to do anything, help us and have compassion on us.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus said to him, “The question is whether yoʋ are able to believe; all things are possible for the one who believes.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Immediately the child's father cried out and said with tears, “I believe, Lord; help my unbelief!” ");
INSERT INTO engtcent_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","When Jesus saw that a crowd came running together, he rebuked the unclean spirit and said to it, “Yoʋ spirit that makes this boy mute and deaf, I command yoʋ, come out of him and never enter him again!” ");
INSERT INTO engtcent_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","After crying out, the spirit convulsed the boy greatly and came out, and the boy became as though he were dead, so that many said, “He is dead!” ");
INSERT INTO engtcent_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","But Jesus took him by the hand and raised him up, and the boy arose. ");
INSERT INTO engtcent_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Now when Jesus came into the house, his disciples asked him privately, “Why could we not cast it out?” ");
INSERT INTO engtcent_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","He said to them, “This kind cannot come out by anything except prayer and fasting.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Then they went away from there and passed through Galilee, but Jesus did not want anyone to know it. ");
INSERT INTO engtcent_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","For he was teaching his disciples and telling them, “The Son of Man is going to be delivered up into the hands of men, and they will kill him. Yet after he has been killed, he will rise on the third day.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","But they did not understand what this meant, and they were afraid to ask him about it. ");
INSERT INTO engtcent_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Then Jesus came to Capernaum, and when he was in the house, he asked the disciples, “What were you discussing among yourselves on the way?” ");
INSERT INTO engtcent_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","But they were silent, because on the way they had been arguing with one another about who was greater. ");
INSERT INTO engtcent_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","So Jesus sat down, called the twelve over, and said to them, “If anyone wants to be first, he must be last of all and a servant to all.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Then he took a child and placed him before them. And taking the child in his arms, he said to them, ");
INSERT INTO engtcent_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Whoever receives one child such as this in my name receives me; and whoever receives me, receives not me, but him who sent me.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John said to him in response, “Teacher, we saw someone who does not follow us casting out demons in yoʋr name, and we told him to stop because he does not follow us.” ");
INSERT INTO engtcent_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","But Jesus said, “Do not stop him, for no one who does a miracle in my name will be able to speak evil of me soon afterward. ");
INSERT INTO engtcent_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","For whoever is not against you is for you. ");
INSERT INTO engtcent_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Truly I say to you, whoever gives you a cup of water to drink in my name, because you belong to Christ, will certainly not lose his reward. ");
INSERT INTO engtcent_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“If anyone causes one of the little ones who believe in me to stumble, it would be better for him if a millstone were hung around his neck and he were thrown into the sea. ");
INSERT INTO engtcent_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","If yoʋr hand causes yoʋ to stumble, cut it off. It is better for yoʋ to enter life crippled than to have two hands and go into hell, into the unquenchable fire, ");
INSERT INTO engtcent_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘where their worm does not die and the fire is not quenched.’ ");
INSERT INTO engtcent_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","And if yoʋr foot causes yoʋ to stumble, cut it off. It is better for yoʋ to enter life lame than to have two feet and be thrown into hell, into the unquenchable fire, ");
INSERT INTO engtcent_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘where their worm does not die and the fire is not quenched.’ ");
INSERT INTO engtcent_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","And if yoʋr eye causes yoʋ to stumble, tear it out. It is better for yoʋ to enter the kingdom of God with one eye than to have two eyes and be thrown into the fires of hell, ");
INSERT INTO engtcent_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘where their worm does not die and the fire is not quenched.’ ");
INSERT INTO engtcent_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","For everyone will be salted with fire, and every sacrifice will be seasoned with salt. ");
INSERT INTO engtcent_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Salt is good, but if it becomes unsalty, with what shall you season it? Have salt in yourselves, and be at peace with one another.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus then rose from there and went to the region of Judea, traveling through the region beyond the Jordan, and crowds gathered around him again. And again he taught them, as he was accustomed to do. ");
INSERT INTO engtcent_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Then some Pharisees came up to Jesus and tested him by asking, “Is it lawful for a man to divorce his wife?” ");
INSERT INTO engtcent_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","He answered them, “What did Moses command you?” ");
INSERT INTO engtcent_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","They said, “Moses allowed a man to write a certificate of divorce and send her away.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","But Jesus answered them, “Because of your hardness of heart he wrote you this commandment. ");
INSERT INTO engtcent_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","But from the beginning of creation, God ‘made them male and female.’ ");
INSERT INTO engtcent_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘For this reason a man will leave his father and mother and be joined to his wife, ");
INSERT INTO engtcent_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","and the two will become one flesh.’ So then, they are no longer two, but one flesh. ");
INSERT INTO engtcent_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Therefore what God has joined together, let no one separate.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","When they were back in the house, Jesus' disciples asked him about the same subject. ");
INSERT INTO engtcent_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","So he said to them, “Whoever divorces his wife and marries another commits adultery against her. ");
INSERT INTO engtcent_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","And if a woman divorces her husband and gets married to another, she commits adultery.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Now people were bringing children to Jesus so that he might touch them, but the disciples rebuked those who were bringing them. ");
INSERT INTO engtcent_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","When Jesus saw this, he was indignant and said to them, “Let the little children come to me; do not hinder them, for the kingdom of God belongs to such as these. ");
INSERT INTO engtcent_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Truly I say to you, whoever does not receive the kingdom of God like a little child will certainly not enter it.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","And taking the children in his arms, he laid his hands on them and blessed them. ");
INSERT INTO engtcent_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","As he was setting out on the road, a man ran up, knelt before him, and asked him, “Good Teacher, what must I do to inherit eternal life?” ");
INSERT INTO engtcent_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus said to him, “Why do yoʋ call me good? No one is good except God alone. ");
INSERT INTO engtcent_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yoʋ know the commandments: ‘Do not commit adultery, Do not murder, Do not steal, Do not give false testimony, Do not defraud, Honor yoʋr father and mother.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","The man answered him, “Teacher, I have kept all these commandments from the time I was a young boy.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","As Jesus looked at him, he felt love for the man and said to him, “One thing yoʋ lack: Go and sell all that yoʋ have and give to the poor, and yoʋ will have treasure in heaven. Then take up yoʋr cross and come follow me.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","But the man was dejected by what Jesus said and went away sorrowful, for he had many possessions. ");
INSERT INTO engtcent_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Then Jesus looked around and said to his disciples, “How difficult it will be for those who have riches to enter the kingdom of God!” ");
INSERT INTO engtcent_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","The disciples were amazed at his words. But Jesus said to them again, “Children, how difficult it is for those who trust in riches to enter the kingdom of God! ");
INSERT INTO engtcent_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","It is easier for a camel to go through the eye of a needle than for a rich person to enter the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","They were completely astonished at this and said to one another, “Who then can be saved?” ");
INSERT INTO engtcent_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus looked at them and said, “With men it is impossible, but not with God. For all things are possible with God.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter began to say to him, “Behold, we have left everything and followed yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus answered, “Truly I say to you, there is no one who has left house, brothers, sisters, father, mother, wife, children, or fields, for my sake and for the sake of the gospel, ");
INSERT INTO engtcent_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","who will not receive now in this age a hundred times as many houses, brothers, sisters, mothers, children, and fields—along with persecutions—and in the age to come, eternal life. ");
INSERT INTO engtcent_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","But many who are first will be last, and many who are last will be first.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Now they were on the road going up to Jerusalem. Jesus was walking ahead of them, and they were amazed. But as they followed they became afraid. Again he took the twelve aside and began to tell them what was going to happen to him: ");
INSERT INTO engtcent_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Behold, we are going up to Jerusalem, and the Son of Man will be delivered up to the chief priests and scribes. They will condemn him to death and hand him over to the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","They will mock him, flog him, spit on him, and kill him. But on the third day he will rise again.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Then James and John, the sons of Zebedee, came to him and said, “Teacher, we want yoʋ to do for us whatever we ask.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","So he said to them, “What do you want me to do for you?” ");
INSERT INTO engtcent_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","They said to him, “Grant that one of us may sit on yoʋr right and the other on yoʋr left in yoʋr glory.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","But Jesus said to them, “You do not know what you are asking. Are you able to drink the cup that I drink, and to be baptized with the baptism that I am baptized with?” ");
INSERT INTO engtcent_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","They said to him, “We are able.” Then Jesus said to them, “You will indeed drink the cup that I drink, and be baptized with the baptism that I am baptized with, ");
INSERT INTO engtcent_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","but to sit on my right and on my left is not mine to give, but is for those for whom it has been prepared.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","When the ten heard this, they started becoming indignant with James and John. ");
INSERT INTO engtcent_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","So Jesus called them over and said to them, “You know that those who are recognized as rulers of the Gentiles lord it over them, and their great men exercise authority over them. ");
INSERT INTO engtcent_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","But it shall not be so among you. Instead, whoever wants to be great among you must be your servant, ");
INSERT INTO engtcent_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","and whoever wants to be first among you must be a slave to all. ");
INSERT INTO engtcent_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","For even the Son of Man came not to be served but to serve, and to give his life as a ransom for many.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Then they came to Jericho. Now as Jesus was leaving Jericho, along with his disciples and a large crowd, the blind man Bartimaeus, son of Timaeus, was sitting by the road begging. ");
INSERT INTO engtcent_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","When he heard that it was Jesus of Nazareth, he began to cry out, “Son of David, Jesus, have mercy on me!” ");
INSERT INTO engtcent_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Many people began rebuking him, telling him to be silent, but he cried out all the more, “Son of David, have mercy on me!” ");
INSERT INTO engtcent_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Then Jesus stopped and asked for him to be called over. So they called out to the blind man and said to him, “Take courage and get up; he is calling for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Throwing off his cloak, he rose and came to Jesus. ");
INSERT INTO engtcent_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Then Jesus said to him, “What do yoʋ want me to do for yoʋ?” The blind man said to him, “Rabboni, I want to receive my sight.” ");
INSERT INTO engtcent_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus said to him, “Go; yoʋr faith has healed yoʋ.” Immediately he received his sight and began following Jesus on the road. ");
INSERT INTO engtcent_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","When they drew near to Jerusalem and came to Bethsphage and Bethany, at the Mount of Olives, Jesus sent two of his disciples ahead ");
INSERT INTO engtcent_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","and said to them, “Go into the village ahead of you, and immediately as you enter it you will find a colt tied there, on which no one has sat. Untie it and bring it here. ");
INSERT INTO engtcent_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","If anyone says to you, ‘Why are you doing this?’ say, ‘The Lord has need of it.’ Then he will immediately send it here.” ");
INSERT INTO engtcent_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","So they went and found a colt outside in the street, tied at a door, and they untied it. ");
INSERT INTO engtcent_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","But some of the people who were standing there said to them, “What are you doing, untying the colt?” ");
INSERT INTO engtcent_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","They answered them just as Jesus had instructed, and the people let them go. ");
INSERT INTO engtcent_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Then they brought the colt to Jesus and put their garments on it, and he sat on it. ");
INSERT INTO engtcent_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Many people spread their garments on the road, and others cut down leafy branches from the trees and also spread them on the road. ");
INSERT INTO engtcent_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Those who went ahead of him and those who followed were crying out, “Hosanna! Blessed is he who comes in the name of the Lord! ");
INSERT INTO engtcent_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blessed is the kingdom of our father David that is coming in the name of the Lord! Hosanna in the highest!” ");
INSERT INTO engtcent_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Then Jesus entered Jerusalem and went into the temple courts. When he had looked around at everything, he went out to Bethany with the twelve, since the hour was already late. ");
INSERT INTO engtcent_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","On the next day, as they went out from Bethany, Jesus was hungry. ");
INSERT INTO engtcent_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Seeing in the distance a fig tree that had leaves, he went to find out if it had any fruit. When he came to it, he found nothing but leaves, because it was not the season for figs. ");
INSERT INTO engtcent_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","In response Jesus said to the fig tree, “May no one ever eat fruit from yoʋ again!” And his disciples heard it. ");
INSERT INTO engtcent_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Then they came to Jerusalem, and Jesus entered the temple courts and began driving out those who were selling and buying there. He overturned the tables of the money changers and the seats of those who were selling doves, ");
INSERT INTO engtcent_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","and he would not allow anyone to carry anything through the temple courts. ");
INSERT INTO engtcent_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Then he began to teach the people, saying, “Is it not written, ‘My house shall be called a house of prayer for all nations’? But you have made it a den of robbers.” ");
INSERT INTO engtcent_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","When the scribes and the chief priests heard this, they began looking for a way to destroy him, for they were afraid of him, because the entire crowd was astonished at his teaching. ");
INSERT INTO engtcent_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","And when evening came, he went out of the city. ");
INSERT INTO engtcent_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","In the morning, as they went along, they saw that the fig tree had withered from its roots. ");
INSERT INTO engtcent_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Then Peter remembered what had happened and said to Jesus, “Rabbi, behold, the fig tree that yoʋ cursed has withered!” ");
INSERT INTO engtcent_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","In response Jesus said to them, “Have faith in God. ");
INSERT INTO engtcent_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","For truly I say to you, if anyone says to this mountain, ‘Be taken up and thrown into the sea,’ and does not doubt in his heart but believes that what he says is going to happen, whatever he says will be granted to him. ");
INSERT INTO engtcent_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Therefore I tell you, whatever you ask for in prayer, believe that you are receiving it, and it will be yours. ");
INSERT INTO engtcent_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","And whenever you stand praying, if you have anything against anyone, forgive him, so that your Father in heaven will also forgive you your trespasses. ");
INSERT INTO engtcent_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","But if you do not forgive, neither will your Father in heaven forgive your trespasses.” ");
INSERT INTO engtcent_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Again they came to Jerusalem, and as Jesus was walking in the temple courts, the chief priests, the scribes, and the elders came up to him ");
INSERT INTO engtcent_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","and said to him, “By what authority are yoʋ doing these things? And who gave yoʋ this authority to do them?” ");
INSERT INTO engtcent_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus answered them, “I will also ask you one question; answer me, and I will tell you by what authority I am doing these things: ");
INSERT INTO engtcent_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Did John's authority to baptize come from heaven or from men? Answer me.” ");
INSERT INTO engtcent_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","So they considered it among themselves, saying, “If we say, ‘From heaven,’ he will say, ‘Why then did you not believe him?’ ");
INSERT INTO engtcent_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","But shall we say, ‘From men’?”—they were afraid of the people, for everyone thought that John was truly a prophet. ");
INSERT INTO engtcent_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","So they answered Jesus, “We do not know.” In response Jesus said to them, “Neither will I tell you by what authority I am doing these things.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Then Jesus began to speak to them in parables: “A man planted a vineyard, put a fence around it, dug a pit for the winepress, built a tower, leased it to farmers, and left the country. ");
INSERT INTO engtcent_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","At harvest time he sent a servant to the farmers to receive from them some of the fruit of the vineyard. ");
INSERT INTO engtcent_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","But they seized that servant, beat him, and sent him away empty-handed. ");
INSERT INTO engtcent_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Again he sent to them another servant, and they threw stones at him, struck him on the head, and sent him away after dishonoring him. ");
INSERT INTO engtcent_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Again he sent another, and that one they killed. He also sent many others, some of whom they beat, and some of whom they killed. ");
INSERT INTO engtcent_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Now he still had his one beloved son. He sent him to them as well, last of all, saying, ‘They will have respect for my son.’ ");
INSERT INTO engtcent_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","But the farmers said to one another, ‘This is the heir. Come, let us kill him, and the inheritance will be ours.’ ");
INSERT INTO engtcent_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","So they took him, killed him, and threw him out of the vineyard. ");
INSERT INTO engtcent_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","What then will the owner of the vineyard do? He will come and destroy those farmers and give the vineyard to others. ");
INSERT INTO engtcent_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Have you not read this Scripture: ‘The stone the builders rejected has become the cornerstone; ");
INSERT INTO engtcent_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","this was the Lord's doing, and it is amazing in our eyes’?” ");
INSERT INTO engtcent_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Then the chief priests, the scribes, and the elders were looking for a way to arrest Jesus because they knew he had spoken the parable against them. But they were afraid of the crowd, so they left him and went away. ");
INSERT INTO engtcent_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Later they sent some of the Pharisees and the Herodians to Jesus to trap him in what he said. ");
INSERT INTO engtcent_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","They came and said to him, “Teacher, we know that yoʋ are true and defer to no one, for yoʋ do not show partiality but teach the way of God in truth. Is it lawful to pay taxes to Caesar or not? Should we give or should we not give?” ");
INSERT INTO engtcent_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","But knowing their hypocrisy, Jesus said to them, “Why are you testing me? Bring me a denarius and let me look at it.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","So they brought one. Then he said to them, “Whose image and inscription is this?” They said to him, “Caesar's.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","In response Jesus said to them, “Render to Caesar the things that are Caesar's, and to God the things that are God's.” And they were amazed at him. ");
INSERT INTO engtcent_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Then some Sadducees (who say there is no resurrection) came to Jesus and asked him, ");
INSERT INTO engtcent_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Teacher, Moses wrote for us: ‘If a man's brother dies, leaving a wife but no children, that man must marry the widow and raise up offspring for his brother.’ ");
INSERT INTO engtcent_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Now there were seven brothers. The first married a woman and died, leaving no offspring. ");
INSERT INTO engtcent_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","The second married her and died, and he also left no offspring; the third did likewise. ");
INSERT INTO engtcent_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","In fact, the seven all married her and left no offspring. Last of all, the woman also died. ");
INSERT INTO engtcent_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","In the resurrection, when they rise again, which of them will she be the wife of? For the seven all had her as a wife.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus answered them, “Is this not why you are in error, because you know neither the Scriptures nor the power of God? ");
INSERT INTO engtcent_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","For when people rise from the dead, they neither marry nor are they given in marriage. Instead, they are like the angels in heaven. ");
INSERT INTO engtcent_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","But as for the dead being raised, have you not read in the Book of Moses, in the passage about the burning bush, how God said to Moses, ‘I am the God of Abraham, the God of Isaac, and the God of Jacob’? ");
INSERT INTO engtcent_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","He is not the God of the dead, but the God of the living. You have therefore made a serious error.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Now one of the scribes came up and heard them debating, and when he realized that Jesus had answered them well, he asked him, “Which is the most important commandment of all?” ");
INSERT INTO engtcent_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus answered him, “The most important of all the commandments is this: ‘Hear, O Israel: The Lord our God, the Lord is one. ");
INSERT INTO engtcent_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","And yoʋ shall love the Lord yoʋr God with all yoʋr heart, with all yoʋr soul, with all yoʋr mind, and with all yoʋr strength.’ This is the most important commandment. ");
INSERT INTO engtcent_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","And a second like it is this: ‘Yoʋ shall love yoʋr neighbor as yoʋrself.’ There is no other commandment greater than these.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Then the scribe said to him, “Yoʋ are right, Teacher. In truth yoʋ have said that God is one, and that there is no other besides him, ");
INSERT INTO engtcent_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","and that to love him with all yoʋr heart, with all yoʋr understanding, with all yoʋr soul, and with all yoʋr strength, and to love yoʋr neighbor as yoʋrself is greater than every whole burnt offering and sacrifice.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","When Jesus saw that the man had answered wisely, he said to him, “Yoʋ are not far from the kingdom of God.” And no one dared to ask him questions anymore. ");
INSERT INTO engtcent_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","As Jesus taught in the temple courts, he said, “How can the scribes say that the Christ is the Son of David? ");
INSERT INTO engtcent_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","For David himself said in the Holy Spirit, ‘The Lord said to my Lord, “Sit at my right hand until I make yoʋr enemies a footstool for yoʋr feet.” ’ ");
INSERT INTO engtcent_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David himself calls him ‘Lord,’ so how is he his son?” And the large crowd was listening to him gladly. ");
INSERT INTO engtcent_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus also said to them in his teaching, “Beware of the scribes who like to walk around in long robes and to receive greetings in the marketplaces ");
INSERT INTO engtcent_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","and to have the best seats in the synagogues and the places of honor at banquets, ");
INSERT INTO engtcent_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","who devour widows' houses and for a pretense make long prayers. They will receive a more severe judgment.” ");
INSERT INTO engtcent_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Later Jesus sat down across from the treasury and watched how the crowd was putting money into the treasury. Many rich people put in large amounts. ");
INSERT INTO engtcent_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Then a poor widow came and put in two small copper coins, which are worth a penny. ");
INSERT INTO engtcent_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","So Jesus called his disciples over and said to them, “Truly I say to you, this poor widow has put more money into the treasury than all the others. ");
INSERT INTO engtcent_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","For they have all put in money out of their abundance, but she, out of her poverty, has put in all that she had, her entire livelihood.” ");
INSERT INTO engtcent_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","As Jesus was coming out from the temple courts, one of his disciples said to him, “Teacher, look! What wonderful stones and what wonderful buildings!” ");
INSERT INTO engtcent_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus answered him, “Do yoʋ see these great buildings? Not one stone will be left upon another; all of them will be torn down.” ");
INSERT INTO engtcent_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Later, as Jesus was sitting on the Mount of Olives, across from the temple, Peter, James, John, and Andrew asked him privately, ");
INSERT INTO engtcent_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tell us, when will these things happen? And what will be the sign that all these things are about to be fulfilled?” ");
INSERT INTO engtcent_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus began to say to them in response, “Make sure no one leads you astray. ");
INSERT INTO engtcent_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","For many will come in my name, saying, ‘I am he,’ and will lead many astray. ");
INSERT INTO engtcent_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","When you hear of wars and rumors of wars, do not be alarmed, for these things must take place, but the end is not yet. ");
INSERT INTO engtcent_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","For nation will rise up against nation, and kingdom against kingdom. There will be earthquakes in various places, along with famines and riots. These are the beginnings of the labor pains. ");
INSERT INTO engtcent_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“You must watch out for yourselves, for they will deliver you up to councils, and you will be beaten in synagogues. For my sake you will even be set before governors and kings as witnesses to them. ");
INSERT INTO engtcent_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","And the gospel must first be proclaimed to all nations. ");
INSERT INTO engtcent_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","When they lead you away and hand you over, do not be anxious beforehand about what you should say. Do not give it much thought, but say whatever is given to you in that hour, for it will not be you speaking, but the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Brother will deliver up brother to death, and a father his child, and children will rise up against their parents and have them put to death. ");
INSERT INTO engtcent_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","You will be hated by all because of my name, but he who endures to the end will be saved. ");
INSERT INTO engtcent_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“When you see the abomination of desolation, which was spoken of by the prophet Daniel, standing where it should not be” (let the reader understand), “then those who are in Judea must flee to the mountains. ");
INSERT INTO engtcent_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","He who is on the housetop must not come down into his house or go inside to get anything out of his house. ");
INSERT INTO engtcent_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","And he who is in the field must not turn back to get his cloak. ");
INSERT INTO engtcent_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Woe to those who are with child and to those who are nursing infants in those days! ");
INSERT INTO engtcent_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pray that your flight will not happen in winter. ");
INSERT INTO engtcent_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","For those days will be a time of tribulation unlike any other from the beginning of God's creation until now, and it will never be equaled again. ");
INSERT INTO engtcent_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","If the Lord had not cut those days short, no flesh would be saved. But for the sake of the chosen, whom he has selected, he has cut those days short. ");
INSERT INTO engtcent_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","If anyone says to you at that time, ‘Behold, here is the Christ!’ or, ‘Behold, there he is!’ do not believe him. ");
INSERT INTO engtcent_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","For false christs and false prophets will rise up and perform signs and wonders to lead astray, if possible, even the chosen. ");
INSERT INTO engtcent_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","So you must watch out! Behold, I have told you everything in advance. ");
INSERT INTO engtcent_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“But in those days, after that time of tribulation, the sun will be darkened, and the moon will not give its light. ");
INSERT INTO engtcent_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","The stars of heaven will be falling, and the powers that are in the heavens will be shaken. ");
INSERT INTO engtcent_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Then people will see the Son of Man coming in the clouds with great power and glory. ");
INSERT INTO engtcent_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","And he will send his angels and gather together his chosen from the four winds, from the ends of the earth to the ends of heaven. ");
INSERT INTO engtcent_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Now learn this lesson from the fig tree: As soon as its branches become tender and put out leaves, you know that summer is near. ");
INSERT INTO engtcent_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","So also, when you see these things taking place, know that he is near, at the very gates. ");
INSERT INTO engtcent_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Truly I say to you, this generation will certainly not pass away until all these things have taken place. ");
INSERT INTO engtcent_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Heaven and earth will pass away, but my words will certainly not pass away. ");
INSERT INTO engtcent_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“No one knows about that day or hour, not even the angels in heaven or the Son, but only the Father. ");
INSERT INTO engtcent_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Be on guard; stay alert and pray! For you do not know when the time is coming. ");
INSERT INTO engtcent_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","It is like a man away on a journey: When he leaves his house and gives authority to his servants, assigning to each one his task, he also commands the doorkeeper to keep watch. ");
INSERT INTO engtcent_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Therefore keep watch, for you do not know when the master of the house is coming—in the evening, at midnight, when the rooster crows, or in the morning. ");
INSERT INTO engtcent_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Otherwise, he may come suddenly and find you sleeping. ");
INSERT INTO engtcent_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","What I say to you, I say to everyone: Keep watch!” ");
INSERT INTO engtcent_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Now the Passover and the Feast of Unleavened Bread were two days away, and the chief priests and the scribes were looking for a way to arrest Jesus secretly and kill him. ");
INSERT INTO engtcent_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","But they said, “Not during the feast, otherwise there will be a riot among the people.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Meanwhile Jesus was in Bethany, reclining at the table in the house of Simon the leper, and a woman came with an alabaster jar of very expensive ointment made of pure nard. She broke the alabaster jar and poured the ointment on his head. ");
INSERT INTO engtcent_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","But some were expressing indignation to one another, saying, “Why has this ointment been wasted? ");
INSERT INTO engtcent_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","It could have been sold for more than three hundred denarii, and the money could have been given to the poor.” So they began scolding her. ");
INSERT INTO engtcent_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","But Jesus said, “Leave her alone. Why are you causing trouble for her? She has done a good deed to me. ");
INSERT INTO engtcent_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","For you always have the poor with you, and you can do good to them whenever you want, but you will not always have me. ");
INSERT INTO engtcent_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","She has done what she could; she has anointed my body beforehand to prepare me for burial. ");
INSERT INTO engtcent_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Truly I say to you, wherever this gospel is preached in the whole world, what this woman has done will also be spoken of as a memorial to her.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Then Judas Iscariot, one of the twelve, went to the chief priests to deliver Jesus up to them. ");
INSERT INTO engtcent_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","When they heard why he had come, they were glad and promised to give him money. So he began looking for a way to betray Jesus at an opportune time. ");
INSERT INTO engtcent_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","On the first day of the Feast of Unleavened Bread, when the Passover lamb is sacrificed, Jesus' disciples said to him, “Where do yoʋ want us to go and make preparations for yoʋ to eat the Passover?” ");
INSERT INTO engtcent_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","So he sent two of his disciples and said to them, “Go into the city, and a man carrying a jug of water will meet you. Follow him. ");
INSERT INTO engtcent_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wherever he enters, tell the master of the house, ‘The Teacher asks, “Where is the guest room where I can eat the Passover with my disciples?” ’ ");
INSERT INTO engtcent_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","He will then show you a large upper room, furnished and prepared; make preparations for us there.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","So his disciples left, went into the city, and found it just as Jesus had told them, and they prepared the Passover. ");
INSERT INTO engtcent_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","When it was evening, Jesus came with the twelve. ");
INSERT INTO engtcent_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","As they were reclining at the table and eating, Jesus said, “Truly I say to you, one of you who is eating with me will betray me.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","So they began to be sorrowful and to say one after another, “Surely not I?” and, “Surely not I?” ");
INSERT INTO engtcent_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus answered them, “It is one of the twelve, one who is dipping bread with me into the dish. ");
INSERT INTO engtcent_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","The Son of Man indeed goes just as it is written of him, but woe to that man by whom the Son of Man is betrayed. It would have been better for that man if he had not been born.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","As they were eating, Jesus took bread, and when he had blessed it, he broke it, gave it to them, and said, “Take and eat this bread; this is my body.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Then he took the cup, and when he had given thanks, he gave it to them, and they all drank from it. ");
INSERT INTO engtcent_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","He said to them, “This is my blood of the new covenant, which is poured out for many. ");
INSERT INTO engtcent_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Truly I say to you, I will certainly not drink again from the fruit of the vine until that day when I drink it anew in the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","And after singing a hymn, they went out to the Mount of Olives. ");
INSERT INTO engtcent_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Then Jesus said to them, “All of you will fall away because of me this night. For it is written, ‘I will strike the shepherd, and the sheep will be scattered.’ ");
INSERT INTO engtcent_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","However, after I have been raised up, I will go ahead of you to Galilee.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","But Peter said to him, “Even if everyone else falls away, I will not.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus said to him, “Truly I say to yoʋ that today, on this night, before a rooster crows twice, yoʋ will deny me three times.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","But Peter said all the more vehemently, “Even if I must die with yoʋ, I will certainly not deny yoʋ.” And they all said the same thing. ");
INSERT INTO engtcent_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Then they went to a place called Gethsemane, and Jesus said to his disciples, “Sit here while I go and pray.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","He took with him Peter, James, and John, and began to be greatly disturbed and distressed. ");
INSERT INTO engtcent_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","He said to them, “My soul is very sorrowful, even to the point of death; stay here and keep watch.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Going a little farther, he fell on the ground and prayed that, if it were possible, the hour might pass from him. ");
INSERT INTO engtcent_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","He said, “Abba, Father, all things are possible for yoʋ. Take this cup away from me; nevertheless, not what I will, but what yoʋ will.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Then he came and found them sleeping, and he said to Peter, “Simon, are yoʋ sleeping? Could yoʋ not keep watch for one hour? ");
INSERT INTO engtcent_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Keep watch and pray, lest you enter into temptation. The spirit indeed is willing, but the flesh is weak.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Once again he went away and prayed the same prayer. ");
INSERT INTO engtcent_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","When he returned, he found them sleeping again, for their eyes were heavy, and they did not know what to say in response. ");
INSERT INTO engtcent_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Then he came a third time and said to them, “Sleep on now and take your rest! That is enough; the hour has come. Behold, the Son of Man is delivered up into the hands of sinners. ");
INSERT INTO engtcent_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Rise, let us go! Behold, my betrayer has drawn near.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Immediately, as he was still speaking, Judas arrived, who was one of the twelve. With him was a large crowd with swords and clubs, sent by the chief priests, the scribes, and the elders. ");
INSERT INTO engtcent_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Now his betrayer had given them a signal, saying, “Whomever I kiss, he is the one; arrest him and lead him away under guard.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","When Judas came, he immediately went up to Jesus and said to him, “Rabbi! Rabbi!” And he kissed him. ");
INSERT INTO engtcent_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Then they took hold of Jesus and arrested him. ");
INSERT INTO engtcent_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","But one of the bystanders drew his sword and struck the servant of the high priest, cutting off his ear. ");
INSERT INTO engtcent_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Then Jesus said to them, “Have you come out to arrest me with swords and clubs as you would against a robber? ");
INSERT INTO engtcent_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","I was with you daily, teaching in the temple courts, and you did not arrest me. But these things are happening so that the Scriptures may be fulfilled.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Then they all the disciples left him and fled. ");
INSERT INTO engtcent_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Now a certain young man was following Jesus, wearing nothing but a linen cloth. The young men tried to seize him, ");
INSERT INTO engtcent_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","but he left the linen cloth behind and ran away from them naked. ");
INSERT INTO engtcent_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Then they led Jesus away to the high priest, and all the chief priests, the elders, and the scribes were assembled together with him. ");
INSERT INTO engtcent_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter had followed Jesus at a distance, right into the courtyard of the high priest. There he sat with the officers, warming himself in the light of the fire. ");
INSERT INTO engtcent_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Now the chief priests and the whole Sanhedrin were seeking testimony against Jesus so that they could put him to death, but they did not find any. ");
INSERT INTO engtcent_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","For many were giving false testimony against him, but their testimonies did not agree. ");
INSERT INTO engtcent_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Then some stood up and gave false testimony against him, declaring, ");
INSERT INTO engtcent_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“We heard him say, ‘I will destroy this man-made temple, and in three days I will build another not made by man.’ ” ");
INSERT INTO engtcent_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yet even then their testimony did not agree. ");
INSERT INTO engtcent_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Then the high priest stood up before them and asked Jesus, “Do yoʋ make no answer? What are these men testifying against yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","But he was silent and made no answer. Again the high priest asked him, “Are yoʋ the Christ, the Son of the Blessed One?” ");
INSERT INTO engtcent_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus said, “I am. And you will see the Son of Man sitting at the right hand of Power and coming with the clouds of heaven.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Then the high priest tore his garments and said, “What further need do we have of witnesses? ");
INSERT INTO engtcent_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","You have heard his blasphemy. What seems right to you?” And they all condemned him as deserving death. ");
INSERT INTO engtcent_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Then some began to spit on him, to blindfold him, and to beat him, saying to him, “Prophesy!” And the officers kept striking him with the palms of their hands. ");
INSERT INTO engtcent_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Now as Peter was in the courtyard below, one of the servant girls of the high priest came. ");
INSERT INTO engtcent_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","When she saw Peter warming himself, she looked at him and said, “Yoʋ also were with Jesus of Nazareth.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","But he denied it, saying, “I neither know nor understand what yoʋ are talking about!” Then he went outside to the gateway, and a rooster crowed. ");
INSERT INTO engtcent_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","When the servant girl saw him again, she began saying to the people standing nearby, “This man is one of them.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","But again he denied it. After a little while, the people standing nearby said to Peter once again, “Truly yoʋ are one of them, for yoʋ also are a Galilean, and yoʋr accent is like theirs.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","But he began to invoke curses and to swear, saying, “I do not know this man of whom you speak.” ");
INSERT INTO engtcent_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Then a rooster crowed a second time, and Peter remembered what Jesus had said to him: “Before a rooster crows twice, yoʋ will deny me three times.” And he broke down and wept. ");
INSERT INTO engtcent_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","As soon as it was morning, the chief priests took counsel with the elders, scribes, and the whole Sanhedrin. They bound Jesus, led him away, and handed him over to Pilate. ");
INSERT INTO engtcent_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","So Pilate asked him, “Are yoʋ the king of the Jews?” Jesus answered him, “Yoʋ have said it yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Then the chief priests accused him of many things. ");
INSERT INTO engtcent_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","So Pilate asked him again, “Do yoʋ make no answer? See how many things they are testifying against yoʋ!” ");
INSERT INTO engtcent_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","But Jesus made no further answer, so Pilate was amazed. ");
INSERT INTO engtcent_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Now at the feast Pilate would release one prisoner for the people, whomever they requested. ");
INSERT INTO engtcent_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","And there was a man named Barabbas who was in prison with his fellow insurrectionists who had committed murder in the insurrection. ");
INSERT INTO engtcent_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","So the crowd cried out and began to ask Pilate to do what he had always done for them. ");
INSERT INTO engtcent_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate answered them, “Do you want me to release for you the king of the Jews?” ");
INSERT INTO engtcent_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(For he knew that the chief priests had handed Jesus over out of envy.) ");
INSERT INTO engtcent_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","But the chief priests stirred up the crowd to have Pilate release for them Barabbas instead. ");
INSERT INTO engtcent_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","In response Pilate said to them again, “What then do you want me to do with the man you call King of the Jews?” ");
INSERT INTO engtcent_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","They cried out again, “Crucify him!” ");
INSERT INTO engtcent_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate said to them, “Why? What evil has he done?” But they cried out all the more, “Crucify him!” ");
INSERT INTO engtcent_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Then Pilate, wishing to satisfy the crowd, released for them Barabbas. But he scourged Jesus and handed him over to be crucified. ");
INSERT INTO engtcent_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","So the soldiers led him away into the palace (that is, the governor's headquarters) and called together the entire cohort of soldiers. ");
INSERT INTO engtcent_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","They clothed him with a purple robe, and they twisted together a crown of thorns and put it on him. ");
INSERT INTO engtcent_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Then they began to salute him: “Hail, King of the Jews!” ");
INSERT INTO engtcent_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","They kept beating him on the head with a reed, spitting on him, and bending down on their knees to pay homage to him. ");
INSERT INTO engtcent_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","When they had finished mocking him, they stripped him of the purple robe and put his own garments back on him. Then they led him out to crucify him. ");
INSERT INTO engtcent_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Now a certain man from Cyrene, Simon, the father of Alexander and Rufus, was passing by on his way in from the countryside. The soldiers pressed him into service, forcing him to carry Jesus' cross, ");
INSERT INTO engtcent_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","and they brought Jesus to the place called Golgotha (which means, “Place of the Skull”). ");
INSERT INTO engtcent_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Then they gave him wine to drink, mixed with myrrh, but he did not take it. ");
INSERT INTO engtcent_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","And they crucified him. Then they divided his garments, casting lots for them to see who would take what. ");
INSERT INTO engtcent_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","It was the third hour when they crucified him. ");
INSERT INTO engtcent_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","The inscription of the charge against him was written as follows: “The King of the Jews.” ");
INSERT INTO engtcent_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","With him they crucified two robbers, one on his right and one on his left. ");
INSERT INTO engtcent_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","So the Scripture was fulfilled that says, “He was numbered with the lawless.” ");
INSERT INTO engtcent_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Those who passed by reviled him, shaking their heads and saying, “Ha! Yoʋ who would destroy the temple and build it in three days, ");
INSERT INTO engtcent_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","save yoʋrself and come down from the cross!” ");
INSERT INTO engtcent_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","In the same way the chief priests also, along with the scribes, were mocking him among themselves, saying, “He saved others, but he cannot save himself. ");
INSERT INTO engtcent_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Let the Christ, the king of Israel, come down now from the cross, so that we may see it and believe.” The men who were crucified with him were also insulting him. ");
INSERT INTO engtcent_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","From the sixth hour until the ninth hour, there was darkness over the whole land. ");
INSERT INTO engtcent_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","And at the ninth hour Jesus cried out with a loud voice, “Eloi, Eloi, lima sabachthani?” which means, “My God, my God, why have yoʋ forsaken me?” ");
INSERT INTO engtcent_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","When some of those standing nearby heard this, they said, “Behold, he is calling for Elijah.” ");
INSERT INTO engtcent_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Then a man ran and filled a sponge with sour wine, put it on a reed, and gave it to him to drink, saying, “Leave him alone. Let us see if Elijah comes to take him down.” ");
INSERT INTO engtcent_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","But Jesus let out a loud cry and breathed his last breath. ");
INSERT INTO engtcent_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Then the veil of the temple was torn in two from top to bottom. ");
INSERT INTO engtcent_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Now when the centurion who was standing in front of Jesus saw how he cried out and breathed his last breath, he said, “Truly this man was the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","There were also some women looking on from a distance, among whom were Mary Magdalene, Mary the mother of James the younger and of Joses, and Salome. ");
INSERT INTO engtcent_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","These women had followed Jesus and provided for him when he was in Galilee. There were also many other women who had come up with him to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","When evening had come, since it was the day of Preparation (that is, the day before the Sabbath), ");
INSERT INTO engtcent_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph of Arimathea, a respected council member, who was himself also waiting for the kingdom of God, came and boldly went in before Pilate to ask for Jesus' body. ");
INSERT INTO engtcent_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate was surprised that Jesus was already dead, so he called the centurion over and asked him if Jesus had been dead for some time. ");
INSERT INTO engtcent_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","When he found out from the centurion that it was so, he granted the body to Joseph. ");
INSERT INTO engtcent_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","After buying a linen cloth and taking him down, Joseph wrapped him in the linen cloth and laid him in a tomb that had been hewn in a rock. Then he rolled a stone against the entrance of the tomb. ");
INSERT INTO engtcent_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","And Mary Magdalene and Mary the mother of Joses saw where he was laid. ");
INSERT INTO engtcent_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","When the Sabbath was over, Mary Magdalene, Mary the mother of James, and Salome bought spices, so that they might go and anoint Jesus' body. ");
INSERT INTO engtcent_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Very early in the morning of the first day of the week, when the sun had risen, they went to the tomb. ");
INSERT INTO engtcent_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","On the way, they were saying to one another, “Who will roll the stone away from the entrance of the tomb for us?” ");
INSERT INTO engtcent_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","But when they arrived, they looked up and saw that the stone, which was very large, had already been rolled away. ");
INSERT INTO engtcent_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","As they went into the tomb, they saw a young man sitting on the right side, clothed in a long white robe, and they were alarmed. ");
INSERT INTO engtcent_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","But he said to them, “Do not be alarmed; you seek Jesus of Nazareth, who was crucified. He is risen; he is not here. Behold, this is the place where they laid him. ");
INSERT INTO engtcent_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Now go tell his disciples and Peter that he is going ahead of you to Galilee. There you will see him, just as he told you.” ");
INSERT INTO engtcent_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","So they went out and fled from the tomb, and trembling and amazement seized them. But they did not say anything to anyone, for they were afraid. ");
INSERT INTO engtcent_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","In the morning on the first day of the week, after Jesus had risen, he appeared first to Mary Magdalene, from whom he had cast out seven demons. ");
INSERT INTO engtcent_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","She then went and told those who had been with him, while they were mourning and weeping. ");
INSERT INTO engtcent_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","But when they heard that he was alive and that she had seen him, they did not believe it. ");
INSERT INTO engtcent_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","After this, Jesus appeared in a different form to two of his followers as they were walking along in the countryside. ");
INSERT INTO engtcent_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","They went back and told the others, but they did not believe them either. ");
INSERT INTO engtcent_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Later Jesus appeared to the eleven as they were reclining at the table, and he rebuked them for their unbelief and hardness of heart, because they had not believed those who had seen him after he had risen. ");
INSERT INTO engtcent_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","He said to them, “Go into all the world and preach the gospel to all creation. ");
INSERT INTO engtcent_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Whoever believes and is baptized will be saved, but whoever does not believe will be condemned. ");
INSERT INTO engtcent_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","And these signs will accompany those who believe: They will cast out demons in my name, they will speak in new tongues, ");
INSERT INTO engtcent_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","they will pick up serpents, and if they drink any deadly poison, it will certainly not harm them; they will lay hands on the sick, and they will get well.” ");
INSERT INTO engtcent_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","After the Lord had spoken to them, he was taken up into heaven, and he sat down at the right hand of God. ");
INSERT INTO engtcent_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Then the disciples went out and preached everywhere, while the Lord worked through them and confirmed the message by the signs that accompanied it. Amen. ");
INSERT INTO engtcent_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Since many have undertaken to compile an account of the events that have been fulfilled among us, ");
INSERT INTO engtcent_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","just as those who from the beginning were eyewitnesses and ministers of the word have delivered them to us, ");
INSERT INTO engtcent_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","it seemed good to me also, having carefully investigated all things from the beginning, to write an orderly account for yoʋ, most excellent Theophilus, ");
INSERT INTO engtcent_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","so that yoʋ may know the certainty of the things about which yoʋ have been instructed. ");
INSERT INTO engtcent_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","In the days of Herod, the king of Judea, there was a priest named Zechariah who belonged to the division of Abijah. His wife was of the daughters of Aaron, and her name was Elizabeth. ");
INSERT INTO engtcent_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","They were both righteous before God, walking blamelessly in all the commandments and regulations of the Lord. ");
INSERT INTO engtcent_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","But they had no children because Elizabeth was barren, and they were both advanced in their days. ");
INSERT INTO engtcent_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","While Zechariah was serving as a priest before God when his division was on duty, ");
INSERT INTO engtcent_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","he was chosen by lot, according to the custom of the priesthood, to enter the temple of the Lord and burn incense. ");
INSERT INTO engtcent_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","At the hour of incense a great crowd was assembled outside, praying. ");
INSERT INTO engtcent_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Then an angel of the Lord appeared to Zechariah, standing at the right side of the altar of incense. ");
INSERT INTO engtcent_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","When Zechariah saw him, he was startled, and fear fell upon him. ");
INSERT INTO engtcent_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","But the angel said to him, “Do not be afraid, Zechariah, for yoʋr prayer has been heard. Yoʋr wife Elizabeth will bear yoʋ a son, and yoʋ shall name him John. ");
INSERT INTO engtcent_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yoʋ will have joy and gladness, and many will rejoice at his birth, ");
INSERT INTO engtcent_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","for he will be great in the sight of the Lord. He must never drink any wine or strong drink, and he will be filled with the Holy Spirit, even from his mother's womb. ");
INSERT INTO engtcent_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","He will turn many of the sons of Israel to the Lord their God. ");
INSERT INTO engtcent_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","And he will go before the Lord in the spirit and power of Elijah, to turn the hearts of fathers back to their children, and the disobedient to the wisdom of the righteous, to make ready a people prepared for the Lord.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah said to the angel, “How can I know this for certain? For I am an old man, and my wife is advanced in her days.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","The angel answered him, “I am Gabriel. I stand in the presence of God and was sent to speak to yoʋ and bring yoʋ this good news. ");
INSERT INTO engtcent_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","But behold, yoʋ will be silent and unable to speak until the day these things take place, because yoʋ did not believe my words, which will be fulfilled at their appointed time.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Meanwhile, the people were waiting for Zechariah and wondering about his delay in the temple. ");
INSERT INTO engtcent_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","When he came out, he was unable to speak to them, and they perceived that he had seen a vision in the temple, because he kept making signs to them and remained unable to speak. ");
INSERT INTO engtcent_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","And when the days of his service had come to an end, he returned to his home. ");
INSERT INTO engtcent_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","After those days his wife Elizabeth conceived and kept herself in seclusion for five months, saying, ");
INSERT INTO engtcent_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“The Lord has done this for me. In these days he has looked upon me with favor and taken away my reproach among the people.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","In the sixth month the angel Gabriel was sent by God to a town of Galilee called Nazareth, ");
INSERT INTO engtcent_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","to a virgin betrothed to a man named Joseph, of the house of David. The virgin's name was Mary. ");
INSERT INTO engtcent_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","The angel came to her and said, “Greetings, O favored one, the Lord is with yoʋ! Blessed are yoʋ among women!” ");
INSERT INTO engtcent_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","But when Mary saw him, she was greatly perplexed by his statement and began wondering what sort of greeting this could be. ");
INSERT INTO engtcent_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Then the angel said to her, “Do not be afraid, Mary, for yoʋ have found favor with God. ");
INSERT INTO engtcent_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","And behold, yoʋ will conceive in yoʋr womb and give birth to a son, and yoʋ shall name him Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","He will be great and will be called the Son of the Most High, and the Lord God will give him the throne of his father David. ");
INSERT INTO engtcent_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","He will reign over the house of Jacob forever, and of his kingdom there will be no end.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary said to the angel, “How will this be, since I am a virgin?” ");
INSERT INTO engtcent_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","The angel answered her, “The Holy Spirit will come upon yoʋ, and the power of the Most High will overshadow yoʋ; therefore the holy child that is to be born will be called the Son of God. ");
INSERT INTO engtcent_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","And behold, yoʋr relative Elizabeth has also conceived a son in her old age, and this is the sixth month for her who was called barren. ");
INSERT INTO engtcent_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","For nothing is impossible with God.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Then Mary said, “Behold, I am the servant of the Lord; may it happen to me according to yoʋr word.” And the angel left her. ");
INSERT INTO engtcent_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","In those days Mary arose and went with haste to the hill country, to a town of Judah, ");
INSERT INTO engtcent_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","where she entered the house of Zechariah and greeted Elizabeth. ");
INSERT INTO engtcent_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","When Elizabeth heard Mary's greeting, the baby leaped in her womb, and Elizabeth was filled with the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Then she exclaimed with a loud voice, “Blessed are yoʋ among women, and blessed is the fruit of yoʋr womb! ");
INSERT INTO engtcent_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","How has this happened to me that the mother of my Lord should come to me? ");
INSERT INTO engtcent_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","For behold, when the sound of yoʋr greeting came into my ears, the baby in my womb leaped for joy. ");
INSERT INTO engtcent_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blessed is she who has believed, for what the Lord has spoken to her will be fulfilled.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Then Mary said, “My soul magnifies the Lord, ");
INSERT INTO engtcent_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","and my spirit rejoices in God my Savior, ");
INSERT INTO engtcent_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","because he has looked favorably on the humble state of his servant. For behold, from now on all generations will call me blessed, ");
INSERT INTO engtcent_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","because the Mighty One has done great things for me; holy is his name. ");
INSERT INTO engtcent_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","From generation to generation his mercy is upon those who fear him. ");
INSERT INTO engtcent_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","He has done a mighty deed with his arm; he has scattered the proud in the thoughts of their hearts. ");
INSERT INTO engtcent_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","He has brought down rulers from their thrones and exalted the lowly. ");
INSERT INTO engtcent_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","He has filled the hungry with good things, but the rich he has sent away empty. ");
INSERT INTO engtcent_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","He has helped his servant Israel, remembering his mercy, ");
INSERT INTO engtcent_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","just as he spoke to our fathers, to Abraham and to his offspring forever.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","And Mary remained with Elizabeth for about three months and then returned to her house. ");
INSERT INTO engtcent_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Now the time was fulfilled for Elizabeth to give birth, and she bore a son. ");
INSERT INTO engtcent_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Then her neighbors and her relatives heard that the Lord had magnified his mercy with her, and they rejoiced with her. ");
INSERT INTO engtcent_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","On the eighth day they came to circumcise the child, and they were going to name him Zechariah, after his father. ");
INSERT INTO engtcent_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","But the child's mother responded, “No! He is to be called John.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","But they said to her, “There is no one among yoʋr relatives who has that name.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Then they began making signs to the child's father to find out what he wanted to name him. ");
INSERT INTO engtcent_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","So he asked for a tablet and wrote, “His name is John.” And they were all amazed. ");
INSERT INTO engtcent_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","At once Zechariah's mouth was opened and his tongue was released, and he began to speak, blessing God. ");
INSERT INTO engtcent_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Then fear came upon all who dwelt around them, and in the entire hill country of Judea all these things were being discussed. ");
INSERT INTO engtcent_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","All who heard about this laid it up in their hearts, saying, “What then will this child become?” And the hand of the Lord was with him. ");
INSERT INTO engtcent_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Then Zechariah, the child's father, was filled with the Holy Spirit and prophesied: ");
INSERT INTO engtcent_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Blessed be the Lord, the God of Israel, for he has visited his people and brought them redemption. ");
INSERT INTO engtcent_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","He has raised up for us a horn of salvation in the house of his servant David ");
INSERT INTO engtcent_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(just as he spoke through the mouth of his holy prophets long ago), ");
INSERT INTO engtcent_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","salvation from our enemies and from the hand of all who hate us— ");
INSERT INTO engtcent_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","to deal mercifully with our fathers and to remember his holy covenant, ");
INSERT INTO engtcent_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","the oath he swore to Abraham our father, to grant us ");
INSERT INTO engtcent_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","that we, having been rescued from the hands of our enemies, might serve him without fear, ");
INSERT INTO engtcent_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","in holiness and righteousness before him all the days of our lives. ");
INSERT INTO engtcent_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","And yoʋ, child, will be called a prophet of the Most High, for yoʋ will go before the presence of the Lord to prepare his ways, ");
INSERT INTO engtcent_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","to give his people knowledge of salvation through the remission of their sins, ");
INSERT INTO engtcent_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","through the tender mercy of our God, by which the sunrise has visited us from on high, ");
INSERT INTO engtcent_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","to give light to those who sit in darkness and in the shadow of death, to guide our feet into the way of peace.” ");
INSERT INTO engtcent_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","And the child grew and became strong in spirit, and he was in the wilderness until the day of his public appearance to Israel. ");
INSERT INTO engtcent_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","In those days a decree went out from Caesar Augustus that all the world should be registered in a census. ");
INSERT INTO engtcent_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","This was the first census, and it took place when Quirinius was governor of Syria. ");
INSERT INTO engtcent_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","So everyone went to be registered, each to his own town. ");
INSERT INTO engtcent_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph also went up from Galilee, from the town of Nazareth, to Judea, to the city of David, which is called Bethlehem, because he was of the house and family of David, ");
INSERT INTO engtcent_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","to register himself along with Mary, his betrothed wife, who was with child. ");
INSERT INTO engtcent_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","While they were there, the days were fulfilled for her to give birth, ");
INSERT INTO engtcent_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","and she gave birth to her firstborn son. Then she wrapped him in swaddling cloths and laid him in the manger, because there was no room for them in the inn. ");
INSERT INTO engtcent_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","In the same region there were shepherds living out in the fields, keeping watch over their flock by night. ");
INSERT INTO engtcent_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","And behold, an angel of the Lord stood before them, and the glory of the Lord shone around them, and they were filled with great fear. ");
INSERT INTO engtcent_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","But the angel said to them, “Do not be afraid, for behold, I bring you good news of great joy, which will be for all the people. ");
INSERT INTO engtcent_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","For to you is born this day in the city of David a Savior, who is Christ the Lord. ");
INSERT INTO engtcent_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","This will be the sign for you: You will find a baby wrapped in swaddling cloths and lying in a manger.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Suddenly there was with the angel a multitude of the heavenly host, praising God and saying, ");
INSERT INTO engtcent_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Glory to God in the highest, and peace on earth, good will among men.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","When the angels had gone away from them into heaven, the shepherds said to one another, “Let us go over to Bethlehem and see this thing that has happened, which the Lord has made known to us.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","So they went with haste and found Mary and Joseph, and the baby lying in the manger. ");
INSERT INTO engtcent_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","After seeing him, they made widely known what they had been told about the child, ");
INSERT INTO engtcent_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","and all who heard it were amazed at what the shepherds told them. ");
INSERT INTO engtcent_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","But Mary treasured up all these things, pondering them in her heart. ");
INSERT INTO engtcent_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Then the shepherds returned, glorifying and praising God for all the things they had heard and seen, which were just as they had been told. ");
INSERT INTO engtcent_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","When the eight days were completed for his circumcision, he was called Jesus, the name given by the angel before he was conceived in the womb. ");
INSERT INTO engtcent_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","When the days of their purification were completed according to the law of Moses, Joseph and Mary brought Jesus up to Jerusalem to present him to the Lord ");
INSERT INTO engtcent_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(just as it is written in the law of the Lord, “Every male who opens the womb shall be called holy to the Lord”). ");
INSERT INTO engtcent_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","They also went up to offer a sacrifice according to what is said in the law of the Lord: “a pair of turtledoves or two young pigeons.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","And behold, there was a man in Jerusalem named Simeon who was righteous and devout. He was waiting for the consolation of Israel, and the Holy Spirit was upon him. ");
INSERT INTO engtcent_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","It had been revealed to him by the Holy Spirit that he would not see death before he had seen the Lord's Christ. ");
INSERT INTO engtcent_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","So he came in the Spirit into the temple courts, and when the parents brought in the child Jesus to do for him what was customary under the law, ");
INSERT INTO engtcent_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon took him in his arms and blessed God, saying, ");
INSERT INTO engtcent_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Now, Master, yoʋ are releasing yoʋr servant in peace according to yoʋr word, ");
INSERT INTO engtcent_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","for my eyes have seen yoʋr salvation, ");
INSERT INTO engtcent_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","which yoʋ have prepared in the presence of all peoples, ");
INSERT INTO engtcent_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","a light for revelation to the Gentiles and for the glory of yoʋr people Israel.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Joseph and the child's mother were amazed at what was being said about him. ");
INSERT INTO engtcent_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Then Simeon blessed them and said to Mary, the child's mother, “Behold, this child is appointed to bring about the falling and rising of many in Israel and to be a sign that will be spoken against, ");
INSERT INTO engtcent_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","so that the thoughts of many hearts will be revealed. And a sword will pierce yoʋr own soul as well.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","There was also a prophetess, Anna the daughter of Phanuel, of the tribe of Asher. She was far advanced in days. Her husband had died seven years after they were married, ");
INSERT INTO engtcent_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","and she was a widow of about eighty-four years of age. She did not depart from the temple, but served night and day with fasting and prayer. ");
INSERT INTO engtcent_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","She came at that very hour and began giving praise to the Lord and speaking about the child to all who were waiting for redemption in Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","When Joseph and Mary had finished everything that was required by the law of the Lord, they returned to Galilee, to their own town of Nazareth. ");
INSERT INTO engtcent_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","And the child grew and became strong in spirit; he was filled with wisdom, and the favor of God was upon him. ");
INSERT INTO engtcent_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Now Jesus' parents went to Jerusalem every year at the feast of the Passover. ");
INSERT INTO engtcent_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","When he was twelve years old, they went up to Jerusalem according to the custom of the feast. ");
INSERT INTO engtcent_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","And when they had completed their days there and started returning home, the boy Jesus stayed behind in Jerusalem. But Joseph did not know it, and neither did Jesus' mother. ");
INSERT INTO engtcent_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","They assumed that he was in the company of travelers, so they went a day's journey before they began looking for him among their relatives and acquaintances. ");
INSERT INTO engtcent_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","When they did not find him, they returned to Jerusalem, looking for him. ");
INSERT INTO engtcent_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","After three days, they found him in the temple courts, sitting among the teachers, listening to them and asking them questions. ");
INSERT INTO engtcent_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","And all who heard him were amazed at his understanding and his answers. ");
INSERT INTO engtcent_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","When his parents saw him, they were astonished. His mother said to him, “Child, why have yoʋ treated us like this? Behold, yoʋr father and I have been looking for yoʋ in great distress.” ");
INSERT INTO engtcent_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","He said to them, “Why were you looking for me? Did you not know that I must be in my Father's house?” ");
INSERT INTO engtcent_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","But they did not understand what he said to them. ");
INSERT INTO engtcent_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Then he went down with them and came to Nazareth and was obedient to them. And his mother kept all these things in her heart. ");
INSERT INTO engtcent_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","And Jesus advanced in wisdom and in stature, and in favor with God and men. ");
INSERT INTO engtcent_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","In the fifteenth year of the reign of Tiberius Caesar, when Pontius Pilate was governor of Judea, and Herod was tetrarch of Galilee, and Philip his brother was tetrarch of the region of Ituraea and Trachonitis, and Lysanias was tetrarch of Abilene, ");
INSERT INTO engtcent_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","during the high priesthood of Annas and Caiaphas, the word of God came to John the son of Zechariah in the wilderness. ");
INSERT INTO engtcent_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","He went into all the region around the Jordan, preaching a baptism of repentance for the remission of sins, ");
INSERT INTO engtcent_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","as it is written in the book of the words of the prophet Isaiah, “The voice of one crying out in the wilderness, ‘Prepare the way for the Lord; make his paths straight. ");
INSERT INTO engtcent_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Every valley will be filled, and every mountain and hill will be brought low. The crooked roads will be made straight, and the rough ways will be made smooth. ");
INSERT INTO engtcent_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","And all flesh will see the salvation of God.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","John said to the crowds that were coming out to be baptized by him, “You brood of vipers, who warned you to flee from the coming wrath? ");
INSERT INTO engtcent_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Produce fruit consistent with repentance, and do not begin to say to yourselves, ‘We have Abraham as our father,’ for I tell you that God is able from these stones to raise up children for Abraham. ");
INSERT INTO engtcent_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Even now the axe is laid to the root of the trees. Every tree therefore that does not produce good fruit is cut down and thrown into the fire.” ");
INSERT INTO engtcent_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","So the crowds asked him, “What then should we do?” ");
INSERT INTO engtcent_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John answered them, “Whoever has two tunics must share with him who has none, and whoever has food must do likewise.” ");
INSERT INTO engtcent_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Some tax collectors also came to be baptized, and they said to him, “Teacher, what should we do?” ");
INSERT INTO engtcent_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","He said to them, “Collect no more than what you have been authorized to collect.” ");
INSERT INTO engtcent_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Then some soldiers asked him, “And what should we do?” He said to them, “Do not extort money from anyone by threats or false accusations, and be content with your wages.” ");
INSERT INTO engtcent_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Now as the people were waiting in expectation and were all questioning in their hearts whether John might be the Christ, ");
INSERT INTO engtcent_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John answered them all, “I baptize you with water, but one is coming who is mightier than I, the strap of whose sandals I am not worthy to untie; he will baptize you with the Holy Spirit and fire. ");
INSERT INTO engtcent_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","His winnowing fork is in his hand, and he will thoroughly clean out his threshing floor and gather the wheat into his barn, but the chaff he will burn up with unquenchable fire.” ");
INSERT INTO engtcent_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","With these and many other exhortations John preached good news to the people. ");
INSERT INTO engtcent_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","But when John rebuked Herod the tetrarch because of his marriage to Herodias, his brother's wife, and because of all the evils he had done, ");
INSERT INTO engtcent_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod added this to everything else: He locked John up in prison. ");
INSERT INTO engtcent_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Now when all the people were baptized, and when Jesus had also been baptized and was praying, the heavens were opened, ");
INSERT INTO engtcent_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","and the Holy Spirit descended on him in bodily form like a dove. Then a voice came from heaven, saying, “Yoʋ are my beloved Son; in yoʋ I am well pleased.” ");
INSERT INTO engtcent_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus was about thirty years of age when he began his ministry, being the son (so it was thought) of Joseph, the son of Heli, ");
INSERT INTO engtcent_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","the son of Matthat, the son of Levi, the son of Melchi, the son of Janna, the son of Joseph, ");
INSERT INTO engtcent_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","the son of Mattathias, the son of Amos, the son of Nahum, the son of Esli, the son of Naggai, ");
INSERT INTO engtcent_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","the son of Maath, the son of Mattathias, the son of Semei, the son of Joseph, the son of Judah, ");
INSERT INTO engtcent_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","the son of Joanan, the son of Rhesa, the son of Zerubbabel, the son of Shealtiel, the son of Neri, ");
INSERT INTO engtcent_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","the son of Melchi, the son of Addi, the son of Cosam, the son of Elmodam, the son of Er, ");
INSERT INTO engtcent_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","the son of Jose, the son of Eliezer, the son of Jorim, the son of Matthat, the son of Levi, ");
INSERT INTO engtcent_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","the son of Simeon, the son of Judah, the son of Joseph, the son of Jonan, the son of Eliakim, ");
INSERT INTO engtcent_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","the son of Melea, the son of Mainan, the son of Mattatha, the son of Nathan, the son of David, ");
INSERT INTO engtcent_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","the son of Jesse, the son of Obed, the son of Boaz, the son of Salmon, the son of Nahshon, ");
INSERT INTO engtcent_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","the son of Amminadab, the son of Ram, the son of Joram, the son of Hezron, the son of Perez, the son of Judah, ");
INSERT INTO engtcent_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","the son of Jacob, the son of Isaac, the son of Abraham, the son of Terah, the son of Nahor, ");
INSERT INTO engtcent_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","the son of Serug, the son of Reu, the son of Peleg, the son of Eber, the son of Shelah, ");
INSERT INTO engtcent_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","the son of Cainan, the son of Arphaxad, the son of Shem, the son of Noah, the son of Lamech, ");
INSERT INTO engtcent_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","the son of Methuselah, the son of Enoch, the son of Jared, the son of Mahalaleel, the son of Cainan, ");
INSERT INTO engtcent_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","the son of Enosh, the son of Seth, the son of Adam, the son of God. ");
INSERT INTO engtcent_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Then Jesus, full of the Holy Spirit, returned from the Jordan and was led by the Spirit into the wilderness, ");
INSERT INTO engtcent_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","where he was tempted by the devil for forty days. He ate nothing in those days, and afterward, when they had ended, he was hungry. ");
INSERT INTO engtcent_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Then the devil said to him, “If yoʋ are the Son of God, command this stone to become bread.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","But Jesus answered him, “It is written, ‘Man shall not live by bread alone, but by every word of God.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","So the devil brought him up to a high mountain and showed him all the kingdoms of the world in a moment of time. ");
INSERT INTO engtcent_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Then the devil said to him, “To yoʋ I will give all this authority and glory, for it has been delivered to me, and I can give it to anyone I want. ");
INSERT INTO engtcent_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","If yoʋ, then, will worship me, it will all be yoʋrs.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus answered him, “Get behind me, Satan! It is written, ‘Yoʋ shall worship the Lord yoʋr God, and him only shall yoʋ serve.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Then the devil brought him to Jerusalem, set him on the pinnacle of the temple, and said to him, “If yoʋ are the Son of God, throw yoʋrself down from here, ");
INSERT INTO engtcent_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","for it is written, ‘He will command his angels concerning yoʋ, to guard yoʋ,’ ");
INSERT INTO engtcent_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","and, ‘In their hands they will lift yoʋ up, so that yoʋ do not strike yoʋr foot against a stone.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus answered him, “It is said, ‘Yoʋ shall not put the Lord yoʋr God to the test.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","And when the devil had finished all these temptations, he left him until an opportune time. ");
INSERT INTO engtcent_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Then Jesus returned to Galilee in the power of the Spirit, and news about him spread throughout the entire surrounding region. ");
INSERT INTO engtcent_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","And he was teaching in their synagogues, being praised by all. ");
INSERT INTO engtcent_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","When he came to Nazareth, where he had been brought up, he went into the synagogue on the Sabbath day, as was his custom, and stood up to read. ");
INSERT INTO engtcent_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","The scroll of the prophet Isaiah was handed to him, so he unrolled the scroll and found the place where it is written, ");
INSERT INTO engtcent_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“The Spirit of the Lord is upon me, because he has anointed me to preach good news to the poor. He has sent me to heal the brokenhearted, to proclaim release to the captives and recovery of sight to the blind, to set free the oppressed, ");
INSERT INTO engtcent_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","and to proclaim the year of the Lord's favor.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Then he rolled up the scroll, gave it back to the attendant, and sat down. The eyes of everyone in the synagogue were fixed upon him, ");
INSERT INTO engtcent_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","and he began speaking to them, saying, “Today this Scripture has been fulfilled in your hearing.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","They were all speaking well of him and were amazed at the gracious words coming out of his mouth. They said, “Is this not Joseph's son?” ");
INSERT INTO engtcent_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Then Jesus said to them, “Doubtless you will quote to me this proverb: ‘Physician, heal yoʋrself.’ Do here in yoʋr hometown what we have heard that yoʋ did in Capernaum.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","He also said, “Truly I say to you, no prophet is accepted in his hometown. ");
INSERT INTO engtcent_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","But in truth I tell you, there were many widows in Israel in the days of Elijah, when the sky was shut for three years and six months and a severe famine came over all the land, ");
INSERT INTO engtcent_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","yet Elijah was sent to none of them except a widow in Zarephath in the region of Sidon. ");
INSERT INTO engtcent_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","There were also many lepers in Israel in the time of the prophet Elisha, yet not one of them was cleansed except Naaman the Syrian.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","When they heard this, all the people in the synagogue were filled with rage. ");
INSERT INTO engtcent_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","They rose up, drove him out of town, and brought him to the brow of the hill on which their town was built, to throw him down from the cliff. ");
INSERT INTO engtcent_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","But Jesus passed through the crowd and went away. ");
INSERT INTO engtcent_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Then he went down to Capernaum, a city of Galilee, and on the Sabbath he began teaching the people. ");
INSERT INTO engtcent_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","They were astonished at his teaching, because his message was spoken with authority. ");
INSERT INTO engtcent_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Now in the synagogue there was a man who had an unclean demonic spirit, and he cried out with a loud voice, ");
INSERT INTO engtcent_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Leave us alone! What do yoʋ have to do with us, Jesus of Nazareth? Have yoʋ come to destroy us? I know who yoʋ are—the Holy One of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","But Jesus rebuked him, saying, “Be silent and come out of him!” Then the demon threw the man down before them all and came out of him, having done him no harm. ");
INSERT INTO engtcent_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amazement came over all the people, and they said to one another, “What kind of message is this? For with authority and power he commands the unclean spirits and they come out!” ");
INSERT INTO engtcent_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","And news about him went out to every place in the surrounding region. ");
INSERT INTO engtcent_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Then Jesus arose, left the synagogue, and entered Simon's house. Now Simon's mother-in-law was suffering from a high fever, and they asked Jesus to help her. ");
INSERT INTO engtcent_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","So he stood over her and rebuked the fever, and it left her. At once she rose and began to serve them. ");
INSERT INTO engtcent_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","When the sun was setting, people brought to Jesus those who were sick with various diseases, and he laid his hands on each one of them and healed them. ");
INSERT INTO engtcent_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Demons also came out of many, crying out, “Yoʋ are the Christ, the Son of God.” But he rebuked them and would not allow them to speak, because they knew that he was the Christ. ");
INSERT INTO engtcent_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","When daybreak came, Jesus departed and went to a desolate place. The crowds were seeking him, and they came to him and tried to keep him from leaving them. ");
INSERT INTO engtcent_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","But Jesus said to them, “I must preach the good news of the kingdom of God to the other towns as well, for that is why I was sent.” ");
INSERT INTO engtcent_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","So he continued preaching in the synagogues of Galilee. ");
INSERT INTO engtcent_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","On one occasion, Jesus was standing beside the lake of Gennesaret, and the crowd was pressing in on him to listen to the word of God. ");
INSERT INTO engtcent_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","He saw two boats moored beside the lake, but the fishermen had gotten out of them and were washing their nets. ");
INSERT INTO engtcent_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","He got into one of the boats, the one that was Simon's, and asked him to put out a little way from the shore. Then he sat down and began teaching the crowds from the boat. ");
INSERT INTO engtcent_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","When he finished speaking, he said to Simon, “Put out into the deep water and let down your nets for a catch.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon answered him, “Master, we have worked hard throughout the entire night and have caught nothing, but at yoʋr word I will let down the net.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","When he and the men with him did so, they enclosed such a large number of fish that their net began to break. ");
INSERT INTO engtcent_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","So they signaled to their partners in the other boat to come and assist them, and they came and filled both the boats, so that they began to sink. ");
INSERT INTO engtcent_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","When Simon Peter saw this, he fell down at Jesus' knees and said, “Depart from me, Lord, for I am a sinful man.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","For he and all who were with him were gripped with astonishment at the catch of fish they had taken, ");
INSERT INTO engtcent_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","including James and John, the sons of Zebedee, who were Simon's business partners. Then Jesus said to Simon, “Do not be afraid; from now on yoʋ will be catching people.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","So they brought their boats to shore, left everything, and followed Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","While Jesus was in one of the towns, behold, there was a man full of leprosy. When the man saw Jesus, he fell on his face and begged him, “Lord, if yoʋ are willing, yoʋ can make me clean.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","So Jesus stretched out his hand and touched him, saying, “I am willing; be made clean.” Immediately the leprosy left him. ");
INSERT INTO engtcent_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Then Jesus ordered him to tell no one, but said, “Go show yoʋrself to the priest, and make an offering for yoʋr cleansing, just as Moses commanded, as a testimony to them.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","But the news about Jesus spread even more, and large crowds would gather together to hear him and to be healed by him of their infirmities. ");
INSERT INTO engtcent_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","But he would often withdraw to desolate places and pray. ");
INSERT INTO engtcent_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","On one of those days, as he was teaching, some Pharisees and teachers of the law were sitting there. They had come from every village of Galilee, Judea, and Jerusalem, and the power of the Lord was present to heal the people. ");
INSERT INTO engtcent_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","And behold, some men brought on a bed a man who was paralyzed. They were trying to bring him in and place him before Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","But when they could not find a way to bring him in because of the crowd, they went up on the housetop and let him down through the tiles, together with his mat, into the middle of the crowd in front of Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","When Jesus saw their faith, he said to the man, “Man, yoʋr sins are forgiven yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","But the scribes and the Pharisees began to question what Jesus said: “Who is this that speaks blasphemies? Who can forgive sins but God alone?” ");
INSERT INTO engtcent_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aware of their thoughts, Jesus answered them, “Why are you questioning in your hearts? ");
INSERT INTO engtcent_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Which is easier, to say, ‘Yoʋr sins are forgiven yoʋ,’ or to say, ‘Rise and walk’? ");
INSERT INTO engtcent_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","But so that you may know that the Son of Man has authority on earth to forgive sins”—he said to the paralyzed man—“I say to yoʋ, rise, pick up yoʋr mat, and go to yoʋr house.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Immediately the man rose up before them, picked up what he had been lying on, and went to his house, glorifying God. ");
INSERT INTO engtcent_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amazement seized them all, and they too began glorifying God. Filled with awe, they said, “We have seen extraordinary things today.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","After this Jesus went out and saw a tax collector named Levi sitting at the tax booth. Jesus said to him, “Follow me,” ");
INSERT INTO engtcent_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","and leaving everything behind, Levi rose and followed him. ");
INSERT INTO engtcent_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Then Levi gave a great banquet for Jesus in his house, and there was a large crowd of tax collectors and others reclining at the table with them. ");
INSERT INTO engtcent_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","But the scribes of the people and the Pharisees were grumbling at his disciples, saying, “Why are you eating and drinking with tax collectors and sinners?” ");
INSERT INTO engtcent_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus answered them, “It is not those who are well who need a physician, but those who are sick. ");
INSERT INTO engtcent_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","I did not come to call the righteous, but sinners to repentance.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Then they said to him, “Why is it that the disciples of John often fast and offer prayers, and likewise the disciples of the Pharisees, but yoʋrs eat and drink?” ");
INSERT INTO engtcent_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus said to them, “Can you make the bridegroom's attendants fast while the bridegroom is with them? ");
INSERT INTO engtcent_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","But those days are coming, and when the bridegroom is taken away from them, they will fast in those days.” ");
INSERT INTO engtcent_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","He also told them a parable: “No one puts a patch from a new garment on an old garment. For not only would he tear the new garment, but the patch from the new garment would not match the old garment. ");
INSERT INTO engtcent_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","And no one puts new wine into old wineskins. For the new wine would burst the wineskins and would itself be spilled, and the wineskins would be ruined. ");
INSERT INTO engtcent_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","But new wine must be put into new wineskins, and then both are preserved. ");
INSERT INTO engtcent_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","And no one after drinking old wine immediately desires new wine, for he says, ‘The old is better.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","On the second major Sabbath, Jesus was going through the grainfields, and his disciples were plucking heads of grain, rubbing off the husks in their hands, and eating them. ");
INSERT INTO engtcent_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","But some of the Pharisees said to them, “Why are you doing what is not lawful to do on the Sabbath?” ");
INSERT INTO engtcent_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus answered them, “Have you not read what David did when he was hungry, he and those who were with him, ");
INSERT INTO engtcent_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","how he entered the house of God and took and ate the bread of the Presence, which is not lawful for anyone to eat except for the priests, and how he also gave it to those who were with him?” ");
INSERT INTO engtcent_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Then he said to them, “The Son of Man is Lord even of the Sabbath.” ");
INSERT INTO engtcent_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","On another Sabbath, Jesus went into the synagogue and was teaching, and a man was there whose right hand was withered. ");
INSERT INTO engtcent_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Now the scribes and the Pharisees were watching Jesus closely to see if he would heal on the Sabbath, so that they could find an accusation against him. ");
INSERT INTO engtcent_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","But he knew their thoughts and said to the man with the withered hand, “Rise and stand here.” So he rose and stood there. ");
INSERT INTO engtcent_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Then Jesus said to them, “Let me ask you something: Is it lawful on the Sabbath to do good or to do evil, to save life or to kill?” ");
INSERT INTO engtcent_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","And after looking around at them all, he said to the man, “Stretch out yoʋr hand.” The man did so, and his hand was restored, becoming as sound as the other. ");
INSERT INTO engtcent_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","But the scribes and Pharisees were filled with mindless rage and discussed with one another what they might do to Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","One day soon afterward Jesus went out to the mountain to pray, and spent the whole night in prayer to God. ");
INSERT INTO engtcent_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","When daybreak came, he called his disciples and chose twelve from among them, whom he also named apostles: ");
INSERT INTO engtcent_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (whom he also named Peter) and Andrew his brother, James and John, Philip and Bartholomew, ");
INSERT INTO engtcent_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew and Thomas, James the son of Alphaeus, and Simon (who was called the Zealot), ");
INSERT INTO engtcent_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas the son of James, and Judas Iscariot (who became a traitor). ");
INSERT INTO engtcent_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Then Jesus came down with them and stood on a level place. A crowd of his disciples was there along with a great multitude of people from all Judea, Jerusalem, and the coastal region of Tyre and Sidon (who had come to hear him and to be healed of their diseases), ");
INSERT INTO engtcent_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","as well as people who were harassed by unclean spirits. And they were healed. ");
INSERT INTO engtcent_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","The entire crowd was trying to touch him, because power was coming out from him and healing them all. ");
INSERT INTO engtcent_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Then he looked up at his disciples and said, “Blessed are you who are poor, for yours is the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blessed are you who hunger now, for you will be filled. Blessed are you who weep now, for you will laugh. ");
INSERT INTO engtcent_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blessed are you when others hate you, when they exclude you, reproach you, and spurn your name as evil on account of the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rejoice in that day and leap for joy, for behold, great is your reward in heaven, for their fathers treated the prophets in the same way. ");
INSERT INTO engtcent_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","But woe to you who are rich, for you have received your comfort. ");
INSERT INTO engtcent_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Woe to you who are filled, for you will hunger. Woe to you who laugh now, for you will mourn and weep. ");
INSERT INTO engtcent_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Woe to you when others speak well of you, for their fathers treated the false prophets in the same way. ");
INSERT INTO engtcent_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“But I say to you who are listening, love your enemies, do good to those who hate you, ");
INSERT INTO engtcent_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bless those who curse you, and pray for those who mistreat you. ");
INSERT INTO engtcent_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","If anyone strikes yoʋ on one cheek, offer him the other also. If anyone takes away yoʋr cloak, do not withhold yoʋr tunic from him either. ");
INSERT INTO engtcent_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Give to everyone who asks of yoʋ, and if anyone takes away yoʋr belongings, do not demand them back. ");
INSERT INTO engtcent_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","As you wish that others would do to you, do the same also to them. ");
INSERT INTO engtcent_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","If you love those who love you, what benefit is that to you? For even sinners love those who love them. ");
INSERT INTO engtcent_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","And if you do good to those who do good to you, what benefit is that to you? For even sinners do the same. ");
INSERT INTO engtcent_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","And if you lend to those from whom you expect to receive something back, what benefit is that to you? For even sinners lend to other sinners in order to receive back the same amount. ");
INSERT INTO engtcent_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","But love your enemies, do good to them, and lend to them without expecting anything in return. Then your reward will be great, and you will be sons of the Most High, for he is kind to the ungrateful and the evil. ");
INSERT INTO engtcent_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Therefore be merciful, just as your Father is merciful. ");
INSERT INTO engtcent_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Do not judge, and you will certainly not be judged. Do not condemn, and you will certainly not be condemned. Forgive, and you will be forgiven. ");
INSERT INTO engtcent_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Give, and it will be given to you. A good measure, pressed down, shaken together, and running over, will be put into your lap. For with the same measure you use it will be measured to you in return.” ");
INSERT INTO engtcent_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","He also told them a parable: “Can one blind person guide another? Will they not both fall into a pit? ");
INSERT INTO engtcent_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A disciple is not above his teacher, but everyone who is fully trained will be like his teacher. ");
INSERT INTO engtcent_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Why do yoʋ see the speck in yoʋr brother's eye, but do not consider the beam in yoʋr own eye? ");
INSERT INTO engtcent_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Or how can yoʋ say to yoʋr brother, ‘Brother, let me take the speck out of yoʋr eye,’ when yoʋ yoʋrself do not see the beam in yoʋr own eye? Hypocrite! First take the beam out of yoʋr own eye, and then yoʋ will see clearly to take the speck out of yoʋr brother's eye. ");
INSERT INTO engtcent_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“No good tree produces bad fruit, nor does a bad tree produce good fruit. ");
INSERT INTO engtcent_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Each tree is known by its own fruit. People do not gather figs from thorns, nor do they pick grapes from a bramble bush. ");
INSERT INTO engtcent_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","The good person brings good things out of the good treasure of his heart, and the evil person brings evil things out of the evil treasure of his heart, for out of the abundance of his heart his mouth speaks. ");
INSERT INTO engtcent_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Why do you call me, ‘Lord, Lord,’ and not do what I say? ");
INSERT INTO engtcent_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","I will show you what someone is like who comes to me, hears my words, and acts on them. ");
INSERT INTO engtcent_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","He is like a man building a house, who dug deep and laid a foundation on the rock. When a flood came, the river burst against that house but could not shake it, for it was founded on the rock. ");
INSERT INTO engtcent_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","But he who hears my words and does not act accordingly is like a man who built a house on the ground without a foundation. As soon as the river burst against that house, it fell and was utterly destroyed.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","When Jesus had finished saying all this in the hearing of the people, he entered Capernaum. ");
INSERT INTO engtcent_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","There a centurion's servant, who was highly regarded by his master, was sick and about to die. ");
INSERT INTO engtcent_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","The centurion heard about Jesus and sent some Jewish elders to him, asking him to come and heal his servant. ");
INSERT INTO engtcent_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","When they came to Jesus, they earnestly pleaded with him, saying, “This man is worthy to have yoʋ do this for him, ");
INSERT INTO engtcent_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","for he loves our nation and built our synagogue for us.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","So Jesus went with them. When he was not far from the house, the centurion sent friends to say to him, “Lord, do not trouble yoʋrself, for I am not worthy to have yoʋ enter under my roof; ");
INSERT INTO engtcent_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","therefore I did not even consider myself worthy to come to yoʋ. But just say the word, and my servant will be healed. ");
INSERT INTO engtcent_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","For I too am a man set under authority, with soldiers under me. I say to this one, ‘Go,’ and he goes; and to another, ‘Come,’ and he comes; and to my servant, ‘Do this,’ and he does it.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","When Jesus heard this, he was amazed at the centurion. And turning to the crowd that was following him, he said, “I tell you, not even in Israel have I found such great faith.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Then the men the centurion had sent returned to the house and found that the servant who had been sick was well. ");
INSERT INTO engtcent_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Soon afterward Jesus went to a town called Nain, and many of his disciples went with him, along with a large crowd. ");
INSERT INTO engtcent_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","As he drew near to the gate of the town, behold, a man who had died was being carried out, the one and only son of his mother (who was a widow). And a large crowd from the town was with her. ");
INSERT INTO engtcent_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","When the Lord saw her, he was moved with compassion for her and said to her, “Do not weep.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Then he came up and touched the bier, and those who were carrying it stood still. He said, “Young man, I say to yoʋ, arise!” ");
INSERT INTO engtcent_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","So the dead man sat up and began to speak, and Jesus gave him back to his mother. ");
INSERT INTO engtcent_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Then all the people were filled with awe and began glorifying God, saying, “A great prophet has arisen among us,” and, “God has visited his people.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","This news about Jesus then spread throughout Judea and all the surrounding region. ");
INSERT INTO engtcent_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John's disciples told him about all these things. ");
INSERT INTO engtcent_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","So John called two of his disciples and sent them to ask Jesus, “Are yoʋ the one who is to come, or should we wait for another?” ");
INSERT INTO engtcent_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","When the men came to him, they said, “John the Baptist has sent us to yoʋ to ask, ‘Are yoʋ the one who is to come, or should we wait for another?’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Now in that very hour Jesus had healed many people of diseases, afflictions, and evil spirits, and had given sight to many who were blind. ");
INSERT INTO engtcent_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","So Jesus replied to John's disciples, “Go tell John what you have seen and heard: The blind receive their sight, the lame walk, lepers are made clean, the deaf hear, the dead are raised, and the poor have good news preached to them. ");
INSERT INTO engtcent_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","And blessed is anyone who does not take offense at me.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","When John's messengers had gone away, Jesus began to speak to the crowds about John: “What did you go out into the wilderness to see? A reed shaken by the wind? ");
INSERT INTO engtcent_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","What then did you go out to see? A man clothed in soft garments? Behold, those who are dressed in splendid clothing and who live in luxury are in royal palaces. ");
INSERT INTO engtcent_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","But what did you go out to see? A prophet? Yes, I tell you, and more than a prophet. ");
INSERT INTO engtcent_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","This is the one of whom it is written, ‘Behold, I am sending my messenger ahead of yoʋ, who will prepare yoʋr way before yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","For I tell you, among those born of women there is no prophet greater than John the Baptist, but whoever is least in the kingdom of God is greater than he.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(When all the people heard this, including the tax collectors, they affirmed that God's way was right, because they had been baptized with the baptism of John. ");
INSERT INTO engtcent_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","But the Pharisees and the lawyers rejected the will of God for themselves, because they had not been baptized by John.) ");
INSERT INTO engtcent_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus went on to say, “To what then should I compare the people of this generation, and what are they like? ");
INSERT INTO engtcent_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","They are like children who sit in the marketplace and call out to one another, ‘We played the flute for you, but you did not dance; we sang a lament for you, but you did not weep.’ ");
INSERT INTO engtcent_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","For John the Baptist came neither eating bread nor drinking wine, and you say, ‘He has a demon.’ ");
INSERT INTO engtcent_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","The Son of Man came eating and drinking, and you say, ‘Behold, a glutton and a drunkard, a friend of tax collectors and sinners!’ ");
INSERT INTO engtcent_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yet wisdom is vindicated by all her children.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","One of the Pharisees asked Jesus to eat with him, so he went into the Pharisee's house and reclined at the table. ");
INSERT INTO engtcent_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","And behold, when a woman in that city who was a sinner found out that Jesus was reclining at the table in the Pharisee's house, she brought an alabaster jar of ointment. ");
INSERT INTO engtcent_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","As she stood behind him at his feet, weeping, she began to wet his feet with her tears. Then she wiped them with the hair of her head, kissed his feet, and anointed them with the ointment. ");
INSERT INTO engtcent_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","When the Pharisee who had invited him saw it, he said to himself, “If this man were a prophet, he would know who is touching him and what kind of woman she is—that she is a sinner.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus said to him in response, “Simon, I have something to say to yoʋ.” So he said, “Say it, Teacher.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“A certain moneylender had two debtors. The one owed him five hundred denarii, and the other owed him fifty. ");
INSERT INTO engtcent_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","When they did not have the means to repay, he forgave the debts of them both. So tell me, which of them will love him more?” ");
INSERT INTO engtcent_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon answered, “I suppose that it would be the one for whom he forgave the larger debt.” Jesus said to him, “Yoʋ have judged correctly.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Then he turned toward the woman and said to Simon, “Do yoʋ see this woman? When I came into yoʋr house, yoʋ did not give me water for my feet, but this woman has wet my feet with her tears and wiped them with the hair of her head. ");
INSERT INTO engtcent_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yoʋ did not give me a kiss, but from the time I came in, this woman has not stopped kissing my feet. ");
INSERT INTO engtcent_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yoʋ did not anoint my head with oil, but this woman has anointed my feet with ointment. ");
INSERT INTO engtcent_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Therefore I tell yoʋ, her many sins are forgiven; that is why she has shown great love. But he to whom little is forgiven shows little love.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Then Jesus said to her, “Yoʋr sins are forgiven.” ");
INSERT INTO engtcent_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Those who were reclining at the table with him began to say among themselves, “Who is this man that even forgives sins?” ");
INSERT INTO engtcent_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","And Jesus said to the woman, “Yoʋr faith has saved yoʋ; go in peace.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Soon afterward Jesus was going through every city and village, preaching and proclaiming the good news of the kingdom of God. The twelve were with him, ");
INSERT INTO engtcent_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","as well as some women who had been healed of evil spirits and infirmities: Mary (called Magdalene) from whom seven demons had gone out, ");
INSERT INTO engtcent_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna the wife of Chuza (Herod's steward), Susanna, and many others. These women provided for Jesus and his disciples out of their own resources. ");
INSERT INTO engtcent_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","As a large crowd was gathering and people were coming to Jesus from town after town, he said in a parable: ");
INSERT INTO engtcent_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A sower went out to sow his seed. As he sowed, some seed fell along the path and was trampled underfoot, and the birds of the sky devoured it. ");
INSERT INTO engtcent_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Other seed fell on rock, and as it grew up, it withered away because it had no moisture. ");
INSERT INTO engtcent_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Other seed fell among the thorns, and the thorns grew up with it and choked it. ");
INSERT INTO engtcent_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","But other seed fell into good soil, and when it grew, it produced a hundred times more than what was sown.” As he said this, he called out, “He who has ears to hear, let him hear.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Then his disciples asked him, “What does this parable mean?” ");
INSERT INTO engtcent_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","He said, “To you it has been given to know the mysteries of the kingdom of God, but to the rest I speak in parables, so that ‘they may see but not perceive, and hear but not understand.’ ");
INSERT INTO engtcent_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Now this is the meaning of the parable: The seed is the word of God. ");
INSERT INTO engtcent_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","The ones along the path are those who hear; then the devil comes and takes away the word from their heart, so that they may not believe and be saved. ");
INSERT INTO engtcent_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","The ones on the rock are those who, when they hear the word, receive it with joy. Yet they have no root; they believe for a while, but in a time of testing they fall away. ");
INSERT INTO engtcent_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","The seed that fell among the thorns are those who have heard, but as they go on their way they are choked by the cares, riches, and pleasures of this life, and their fruit does not mature. ");
INSERT INTO engtcent_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","But the seed in the good soil are those who hear the word, hold fast to it with an honest and good heart, and bear fruit with patient endurance. ");
INSERT INTO engtcent_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“No one lights a lamp and covers it with a container or puts it under a bed. Instead, it is put on a lampstand, so that those who come in can see its light. ");
INSERT INTO engtcent_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","For nothing is hidden that will not be made manifest, nor is anything hidden away that will not be made known and come to light. ");
INSERT INTO engtcent_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Therefore consider how you hear, for whoever has will be given more, but whoever does not have, even what he thinks he has will be taken away from him.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Then Jesus' mother and brothers came to him, but they were not able to reach him because of the crowd. ");
INSERT INTO engtcent_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","So some people told him, “Yoʋr mother and yoʋr brothers are standing outside, wanting to see yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","But he answered them, “My mother and my brothers are those who hear the word of God and obey it.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","One day Jesus got into a boat with his disciples and said to them, “Let us cross over to the other side of the lake.” So they set out, ");
INSERT INTO engtcent_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","and as they were sailing along, he fell asleep. Then a windstorm came down on the lake, and they were in danger as the boat was being swamped by the waves. ");
INSERT INTO engtcent_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","So they came to Jesus and woke him up, saying, “Master, Master, we are perishing!” Then he rose and rebuked the wind and the raging water. They ceased, and all was calm. ");
INSERT INTO engtcent_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Then he said to his disciples, “Where is your faith?” But they were afraid and amazed, saying to one another, “Who then is this, that he commands even the winds and the water, and they obey him?” ");
INSERT INTO engtcent_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Then they sailed to the region of the Gadarenes, which is across the lake from Galilee. ");
INSERT INTO engtcent_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","When Jesus stepped ashore, he was met by a man from the city who had been possessed by demons for a long time. This man did not wear clothes or live in a house but among the tombs. ");
INSERT INTO engtcent_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","When he saw Jesus, he cried out, fell down before him, and said with a loud voice, “What do yoʋ have to do with me, Jesus, Son of the Most High God? I beg yoʋ, do not torment me.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","For Jesus had commanded the unclean spirit to come out of the man. Many times it had seized him, and he would be bound with chains and shackles and kept under guard, but he would break the chains and be driven by the demon into desolate places. ");
INSERT INTO engtcent_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus then asked him, “What is yoʋr name?” He said, “Legion,” for many demons had entered him. ");
INSERT INTO engtcent_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","And he begged Jesus not to command them to go away into the abyss. ");
INSERT INTO engtcent_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Now there was a herd of many pigs feeding there on the mountain. The demons begged Jesus to permit them to enter the pigs. So he gave them permission. ");
INSERT INTO engtcent_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Then the demons came out of the man and went into the pigs, and the herd rushed down the steep bank into the lake and were drowned. ");
INSERT INTO engtcent_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","When those who had been feeding the pigs saw what happened, they ran off and reported it in the city and in the countryside. ");
INSERT INTO engtcent_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","So the people came out to see what had happened. When they came to Jesus, they found the man from whom the demons had gone out sitting at Jesus' feet, clothed and in his right mind, and they were afraid. ");
INSERT INTO engtcent_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Those who had seen it told them how the demon-possessed man had been delivered. ");
INSERT INTO engtcent_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Then the entire multitude from the surrounding region of the Gadarenes asked Jesus to depart from them, for they were seized with great fear. So he got into the boat and left. ");
INSERT INTO engtcent_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Now the man from whom the demons had gone out begged to go with him. But Jesus sent him away, saying, ");
INSERT INTO engtcent_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Return to yoʋr house, and declare all that God has done for yoʋ.” So the man went away, proclaiming throughout the entire city all that Jesus had done for him. ");
INSERT INTO engtcent_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Now when Jesus returned, the crowd welcomed him, for they had all been waiting for him. ");
INSERT INTO engtcent_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","And behold, there came a man named Jairus, who was a ruler of the synagogue. He fell down at Jesus' feet and begged him to come to his house, ");
INSERT INTO engtcent_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","because he had an only daughter, about twelve years old, and she was dying. As Jesus went on his way, the crowds were pressing in on him. ");
INSERT INTO engtcent_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Now there was a woman who had suffered from a flow of blood for twelve years, and even though she had spent her entire livelihood on physicians, she could not be healed by anyone. ");
INSERT INTO engtcent_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","She came up behind Jesus and touched the fringe of his garment, and the flow of her blood stopped at once. ");
INSERT INTO engtcent_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Then Jesus said, “Who touched me?” When everyone denied it, Peter and those who were with him said, “Master, the crowds are surrounding yoʋ and pressing against yoʋ, and yet yoʋ say, ‘Who touched me?’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","But Jesus said, “Someone touched me, for I know that power has gone out from me.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","When the woman saw that she could not escape notice, she came trembling and fell down before him, and in the presence of all the people she told him the reason why she had touched him, and how she had been healed at once. ");
INSERT INTO engtcent_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Then Jesus said to her, “Take courage, daughter; yoʋr faith has healed yoʋ. Go in peace.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","While he was still speaking, someone came from the ruler of the synagogue's house and said to him, “Yoʋr daughter has died; do not trouble the teacher.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","But when Jesus heard this, he said to him in response, “Do not be afraid; just believe, and she will be healed.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","When he came to the house, Jesus allowed no one to go in, except Peter, John, James, and the child's father and mother. ");
INSERT INTO engtcent_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Meanwhile, all the people were weeping and mourning for her, but Jesus said, “Do not weep; she is not dead but sleeping.” ");
INSERT INTO engtcent_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","And they began laughing at him, knowing that she was dead. ");
INSERT INTO engtcent_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","But Jesus put them all outside, took hold of the girl's hand, and called out, “Child, arise!” ");
INSERT INTO engtcent_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Her spirit returned, and she got up at once. Then he told them to give her something to eat. ");
INSERT INTO engtcent_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Her parents were amazed, but he ordered them not to tell anyone what had happened. ");
INSERT INTO engtcent_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Then Jesus called the twelve together and gave them power and authority over all demons and to heal diseases, ");
INSERT INTO engtcent_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","and he sent them to proclaim the kingdom of God and to heal the sick. ");
INSERT INTO engtcent_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","He said to them, “Take nothing for your journey—no staffs, no knapsack, no bread, no money—and bring only one tunic each. ");
INSERT INTO engtcent_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Whatever house you enter, stay there until you leave that place. ");
INSERT INTO engtcent_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","If any will not receive you, shake off the very dust from your feet as you leave that town, as a testimony against them.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","So they set out and went throughout the villages, preaching the gospel and healing people everywhere. ");
INSERT INTO engtcent_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Now Herod the tetrarch heard about everything that Jesus was doing, and he was greatly perplexed, because some were saying that John had been raised from the dead, ");
INSERT INTO engtcent_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","others were saying that Elijah had appeared, and others were saying that one of the ancient prophets had risen. ");
INSERT INTO engtcent_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","But Herod said, “John I beheaded; who then is this man about whom I hear such things?” So he was looking for an opportunity to see him. ");
INSERT INTO engtcent_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","When the apostles returned, they told Jesus about all they had done. Then he took them and withdrew privately to a desolate place belonging to a town called Bethsaida. ");
INSERT INTO engtcent_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","But when the crowds found out about it, they followed him. So he welcomed them and spoke to them about the kingdom of God, and cured those who had need of healing. ");
INSERT INTO engtcent_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","As the day began to draw to a close, the twelve came up and said to Jesus, “Send the crowd away so that they can go into the surrounding villages and countryside and find lodging and provisions, for we are in a desolate place here.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","But he said to them, “You give them something to eat.” They said, “We have only five loaves and two fish—unless we are to go and buy food for this entire group of people.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(For there were about five thousand men.) Then he said to his disciples, “Have them sit down in groups of fifty each.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","The disciples did so, and had everyone sit down. ");
INSERT INTO engtcent_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Then Jesus took the five loaves and the two fish, and looking up to heaven, he said a blessing over them. Then he broke the loaves and fish into pieces and gave them to the disciples to set before the crowd. ");
INSERT INTO engtcent_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","They all ate and were filled, and what was left over was picked up, twelve baskets of broken pieces. ");
INSERT INTO engtcent_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Once when Jesus was praying in private and the disciples were with him, he asked them, “Who do the crowds say that I am?” ");
INSERT INTO engtcent_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","They answered, “Some say John the Baptist, others say Elijah, and others say that one of the ancient prophets has risen.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Then he said to them, “But who do you say that I am?” Peter answered, “The Christ of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesus then warned them and instructed them to tell this to no one, ");
INSERT INTO engtcent_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","saying, “The Son of Man must suffer many things and be rejected by the elders, chief priests, and scribes, and he must be killed and on the third day be raised up.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Then he said to them all, “If anyone wants to be one of my disciples, he must deny himself, take up his cross, and follow me. ");
INSERT INTO engtcent_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","For whoever wants to save his life will lose it, but whoever loses his life for my sake will save it. ");
INSERT INTO engtcent_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","For what does it benefit a person if he gains the whole world but loses or forfeits himself? ");
INSERT INTO engtcent_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","If anyone is ashamed of me and my words, the Son of Man will be ashamed of him when he comes in his glory and the glory of the Father and the holy angels. ");
INSERT INTO engtcent_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","But truly I say to you, there are some standing here who will certainly not taste death until they see the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","About eight days after he had spoken these words, he took Peter, John, and James, and went up on a mountain to pray. ");
INSERT INTO engtcent_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","As he was praying, the appearance of his face was altered, and his clothing became dazzling white. ");
INSERT INTO engtcent_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","And behold, two men were talking with him; they were Moses and Elijah, ");
INSERT INTO engtcent_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","who appeared in glory and were speaking about his departure, which he was about to bring to fulfillment in Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Now Peter and those who were with him were heavy with sleep, but when they became fully awake, they saw his glory and the two men standing with him. ");
INSERT INTO engtcent_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","As the men were parting from Jesus, Peter said to him, “Master, it is good for us to be here. Let us make three shelters, one for yoʋ, one for Moses, and one for Elijah,” not knowing what he was saying. ");
INSERT INTO engtcent_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","But as he was saying this, a cloud came and overshadowed them, and they were afraid as they entered the cloud. ");
INSERT INTO engtcent_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Then a voice came from the cloud, saying, “This is my beloved Son; listen to him!” ");
INSERT INTO engtcent_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","When the voice finished speaking, they found that Jesus was alone. And the disciples kept silent, not telling anyone in those days about any of the things they had seen. ");
INSERT INTO engtcent_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","On the next day, when they came down from the mountain, Jesus was met by a large crowd. ");
INSERT INTO engtcent_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","And behold, a man from among the crowd cried out, “Teacher, I beg yoʋ to look at my son, for he is my one and only child. ");
INSERT INTO engtcent_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A spirit seizes him, and he suddenly cries out; it convulses him so that he foams at the mouth. It hardly ever leaves him alone, bruising him severely. ");
INSERT INTO engtcent_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","I begged yoʋr disciples to cast it out, but they could not.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus answered, “O faithless and perverse generation, how long shall I be with you and bear with you? Bring yoʋr son here.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Now as the boy was approaching, the demon threw him down and shook him with convulsions. But Jesus rebuked the unclean spirit, healed the boy, and gave him back to his father. ");
INSERT INTO engtcent_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","And they were all astonished at the majesty of God. But while everyone was marveling at all that Jesus had done, he said to his disciples, ");
INSERT INTO engtcent_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Let these words sink into your ears: The Son of Man is about to be delivered up into the hands of men.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","But they did not understand what this meant. It was concealed from them, so that they could not grasp it, and they were afraid to ask him about it. ");
INSERT INTO engtcent_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Now an argument arose among the disciples as to which of them was greater. ");
INSERT INTO engtcent_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","But Jesus, perceiving the thoughts of their hearts, took a child and placed him by his side. ");
INSERT INTO engtcent_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Then he said to them, “Whoever receives this child in my name receives me, and whoever receives me receives him who sent me. For he who is least among you all is the one who will be great.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John responded, “Master, we saw someone casting out demons in yoʋr name, and we told him to stop because he does not follow us.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","But Jesus said to him, “Do not stop him, for whoever is not against us is for us.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Now when the days were approaching for Jesus' ascension, he set his face to go to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","He sent messengers on ahead, who went and entered a village of the Samaritans to make preparations for him. ");
INSERT INTO engtcent_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","But the people there refused to welcome him, because his face was set to go to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","When his disciples James and John saw this, they said, “Lord, do yoʋ want us to command fire to come down from heaven and consume them, just like Elijah did?” ");
INSERT INTO engtcent_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","But he turned and rebuked them, saying, “You do not know what kind of spirit you belong to. ");
INSERT INTO engtcent_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","For the Son of Man did not come to destroy people's lives but to save them.” And they went on to another village. ");
INSERT INTO engtcent_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","As they were going along the road, someone said to him, “I will follow yoʋ wherever yoʋ go, Lord.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus said to him, “Foxes have holes, and the birds of the sky have nests, but the Son of Man has nowhere to lay his head.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Then Jesus said to another man, “Follow me.” But the man said, “Lord, let me first go and bury my father.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus said to him, “Let the dead bury their own dead. But yoʋ go and proclaim the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Still another said, “I will follow yoʋ, Lord, but first let me say goodbye to my family.” ");
INSERT INTO engtcent_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","But Jesus said to him, “No one who puts his hand to the plow and looks back is fit for the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","After this, the Lord appointed seventy others and sent them on ahead, two by two, to every town and place where he himself was about to go. ");
INSERT INTO engtcent_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","He said to them, “The harvest is plentiful, but the workers are few. Therefore ask the Lord of the harvest to send out workers into his harvest. ");
INSERT INTO engtcent_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Now go on your way. Behold, I am sending you out like lambs in the midst of wolves. ");
INSERT INTO engtcent_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Carry no moneybag, no knapsack, and no sandals; and do not greet anyone on the road. ");
INSERT INTO engtcent_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Whenever you enter a house, first say, ‘May peace be upon this house!’ ");
INSERT INTO engtcent_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","If there is a man of peace there, your peace will rest upon him. But if not, it will return to you. ");
INSERT INTO engtcent_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Remain in the same house, eating and drinking whatever they provide, for the worker is worthy of his wages. Do not go from house to house. ");
INSERT INTO engtcent_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Whenever you enter a town and they receive you, eat what is set before you. ");
INSERT INTO engtcent_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Heal the sick in that city and say to them, ‘The kingdom of God has drawn near to you.’ ");
INSERT INTO engtcent_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","But whenever you enter a town and they do not receive you, go out into its streets and say, ");
INSERT INTO engtcent_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Even the dust that clings to us from your town we wipe off against you. Yet know this: The kingdom of God has drawn near to you.’ ");
INSERT INTO engtcent_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","I tell you, on that day it will be more tolerable for Sodom than for that town. ");
INSERT INTO engtcent_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Woe to yoʋ, Chorazin! Woe to yoʋ, Bethsaida! For if the miracles that were done in you had been done in Tyre and Sidon, they would have repented long ago, sitting in sackcloth and ashes. ");
INSERT INTO engtcent_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","But it will be more tolerable at the judgment for Tyre and Sidon than for you. ");
INSERT INTO engtcent_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","And yoʋ, Capernaum, who have been exalted to heaven, will be brought down to Hades. ");
INSERT INTO engtcent_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“He who listens to you listens to me; he who rejects you rejects me, and he who rejects me rejects him who sent me.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","When the seventy returned, they were joyful and said, “Lord, even the demons submit to us in yoʋr name.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","He said to them, “I watched Satan fall from heaven like lightning. ");
INSERT INTO engtcent_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Behold, I am giving you authority to tread on serpents and scorpions, and to overcome all the power of the enemy, and nothing at all will harm you. ");
INSERT INTO engtcent_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nevertheless, do not rejoice that the spirits submit to you, but rejoice that your names are written in heaven.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","At that same hour Jesus rejoiced in the Spirit and said, “I praise yoʋ, Father, Lord of heaven and earth, because yoʋ have hidden these things from the wise and intelligent, and revealed them to infants. Yes, Father, for so it was well-pleasing in yoʋr sight.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Then he turned to the disciples and said, “All things have been delivered to me by my Father. No one knows who the Son is except the Father, and no one knows who the Father is except the Son, and anyone to whom the Son chooses to reveal him.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Then he turned to the disciples and said privately, “Blessed are the eyes that see what you see! ");
INSERT INTO engtcent_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","For I tell you that many prophets and kings wished to see the things you see but did not see them, and to hear the things you hear but did not hear them.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","And behold, a lawyer stood up to test Jesus, saying, “Teacher, what must I do to inherit eternal life?” ");
INSERT INTO engtcent_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus said to him, “What is written in the law? How do yoʋ read it?” ");
INSERT INTO engtcent_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","He answered, “Yoʋ shall love the Lord yoʋr God with all yoʋr heart, with all yoʋr soul, with all yoʋr strength, and with all yoʋr mind; and yoʋ shall love yoʋr neighbor as yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus said to him, “Yoʋ have answered correctly; do this and yoʋ will live.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","But wishing to justify himself, he said to Jesus, “And who is my neighbor?” ");
INSERT INTO engtcent_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus replied, “A man was going down to Jericho from Jerusalem and fell into the hands of robbers. They stripped him, beat him, and went away, leaving him as he was, half dead. ");
INSERT INTO engtcent_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Now a priest happened to be going down that road, but when he saw the man, he passed by on the other side. ");
INSERT INTO engtcent_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","In the same way, a Levite, when he came to that place and saw him, passed by on the other side. ");
INSERT INTO engtcent_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","But a Samaritan, who was on a journey, came to where the man was, and when he saw him, he was moved with compassion. ");
INSERT INTO engtcent_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","He went over to him and bandaged his wounds, pouring oil and wine on them. Then he put him on his own animal, brought him to an inn, and took care of him. ");
INSERT INTO engtcent_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","On the next day, when he was departing, he took out two denarii, gave them to the innkeeper, and said to him, ‘Take care of him, and whatever more yoʋ spend I will repay to yoʋ when I return.’ ");
INSERT INTO engtcent_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Now which of these three do yoʋ think was a neighbor to the man who fell into the hands of robbers?” ");
INSERT INTO engtcent_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","The lawyer said, “The one who showed him mercy.” Jesus said to him, “Go and do likewise.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","As Jesus and his disciples went along, he entered a village, and a woman named Martha welcomed him into her home. ");
INSERT INTO engtcent_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","She had a sister named Mary, who sat at Jesus' feet and listened to what he was saying. ");
INSERT INTO engtcent_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","But Martha was distracted by the many preparations that had to be made. So she came up to Jesus and said, “Lord, do yoʋ not care that my sister has left me to make all the preparations by myself? Tell her then to assist me.” ");
INSERT INTO engtcent_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","But Jesus answered her, “Martha, Martha, yoʋ are anxious and troubled about many things, ");
INSERT INTO engtcent_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","but only one thing is necessary. Mary has chosen the good portion, and it will not be taken away from her.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","One day Jesus was praying in a certain place, and when he finished, one of his disciples said to him, “Lord, teach us to pray, just as John taught his disciples.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","So he said to them, “When you pray, say, ‘Our Father in heaven, hallowed be yoʋr name. Yoʋr kingdom come. Yoʋr will be done, on earth as it is in heaven. ");
INSERT INTO engtcent_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Give us each day our daily bread. ");
INSERT INTO engtcent_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","And forgive us our sins, for we also forgive everyone who is indebted to us. And lead us not into temptation, but deliver us from evil.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Then he said to them, “Suppose one of you has a friend, and yoʋ go to him at midnight and say to him, ‘Friend, lend me three loaves, ");
INSERT INTO engtcent_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","for a friend on a journey has come to me, and I have nothing to set before him,’ ");
INSERT INTO engtcent_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","and he answers from inside and says, ‘Do not bother me! The door is already shut, and my children are with me in bed. I cannot get up to give yoʋ anything.’ ");
INSERT INTO engtcent_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","I tell you, even if he will not get up and give yoʋ anything because yoʋ are his friend, yet because of yoʋr shameless persistence, he will get up and give yoʋ as much as yoʋ need. ");
INSERT INTO engtcent_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","So I tell you: Ask, and it will be given to you; seek, and you will find; knock, and the door will be opened for you. ");
INSERT INTO engtcent_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","For everyone who asks receives; and he who seeks finds; and for him who knocks, the door will be opened. ");
INSERT INTO engtcent_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Now what father among you, when his son asks for bread, will give him a stone; or again, when he asks for a fish, will give him a serpent instead of a fish; ");
INSERT INTO engtcent_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","or again, if he asks for an egg, will give him a scorpion? ");
INSERT INTO engtcent_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","If you then, being evil, know how to give good gifts to your children, how much more will your heavenly Father give the Holy Spirit to those who ask him!” ");
INSERT INTO engtcent_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Now Jesus was casting out a demon that made a certain man mute. When the demon came out, the mute man began to speak, and the crowds were amazed. ");
INSERT INTO engtcent_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","But some of them said, “By Beelzebul, the ruler of demons, he casts out demons.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Others were asking him for a sign from heaven, to test him. ");
INSERT INTO engtcent_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Knowing their thoughts, Jesus said to them, “Every kingdom divided against itself is laid waste, and a house divided against itself falls. ");
INSERT INTO engtcent_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","So if Satan is also divided against himself, how will his kingdom stand? For you say that I cast out demons by Beelzebul. ");
INSERT INTO engtcent_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Now if I cast out demons by Beelzebul, by whom do your followers cast them out? Therefore they will be your judges. ");
INSERT INTO engtcent_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","But if I cast out demons by the finger of God, then the kingdom of God has come upon you. ");
INSERT INTO engtcent_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","When a strong man, fully armed, guards his own palace, his possessions are secure. ");
INSERT INTO engtcent_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","But when a stronger man attacks and overpowers him, he takes away all the armor in which the man trusted and then distributes the plunder. ");
INSERT INTO engtcent_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Whoever is not with me is against me, and whoever does not gather with me scatters. ");
INSERT INTO engtcent_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“When an unclean spirit has gone out of a person, it goes through waterless places seeking rest. But when it does not find any, it says, ‘I will return to the house I left.’ ");
INSERT INTO engtcent_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","When it arrives, it finds the house swept and put in order. ");
INSERT INTO engtcent_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Then it goes and takes along seven other spirits more evil than itself, and they go and dwell there, and the last state of that person becomes worse than the first.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","As Jesus was saying these things, a woman from among the crowd lifted up her voice and said to him, “Blessed is the womb that bore yoʋ, and the breasts at which yoʋ nursed.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","But he said, “Blessed rather are those who hear the word of God and obey it.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Now as the crowds were increasing, Jesus began to say, “This generation is evil. It asks for a sign, but no sign will be given to it except the sign of the prophet Jonah. ");
INSERT INTO engtcent_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","For just as Jonah became a sign to the people of Nineveh, so also will the Son of Man be to this generation. ");
INSERT INTO engtcent_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","The queen of the South will rise up at the judgment with the men of this generation and condemn them, for she came from the ends of the earth to hear the wisdom of Solomon, and behold, something greater than Solomon is here. ");
INSERT INTO engtcent_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","The men of Nineveh will rise up at the judgment with this generation and condemn it, for they repented at the preaching of Jonah, and behold, something greater than Jonah is here. ");
INSERT INTO engtcent_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“No one lights a lamp and puts it in a hidden place or under a basket. Instead, it is put on a lampstand, so that those who come in can see its light. ");
INSERT INTO engtcent_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","The lamp of the body is the eye. So when yoʋr eye is clear, yoʋr whole body is full of light. But when yoʋr eye is bad, yoʋr body is full of darkness. ");
INSERT INTO engtcent_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Therefore make sure that the light within yoʋ is not darkness. ");
INSERT INTO engtcent_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","If then yoʋr whole body is full of light, having no part dark, it will be entirely light, like when a lamp gives yoʋ light with its rays.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","As Jesus was speaking, a Pharisee invited him to have a meal with him, so Jesus went in and reclined at the table. ");
INSERT INTO engtcent_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","The Pharisee was amazed when he saw that Jesus did not first perform the ritual washing before the meal. ");
INSERT INTO engtcent_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","So the Lord said to him, “You Pharisees clean the outside of the cup and the platter, but inside you are filled with thoughts of robbery and wickedness. ");
INSERT INTO engtcent_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","You fools! Did not he who made the outside also make the inside? ");
INSERT INTO engtcent_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","But give as alms the things that are on the inside, and behold, everything will be clean for you. ");
INSERT INTO engtcent_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“But woe to you, Pharisees! For you tithe mint, rue, and every herb, yet you ignore justice and the love of God. These you ought to have practiced without neglecting the other things. ");
INSERT INTO engtcent_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Woe to you, Pharisees! For you love the best seats in the synagogues and greetings in the marketplaces. ");
INSERT INTO engtcent_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Woe to you, scribes and Pharisees, hypocrites! For you are like unmarked graves, which people walk over without realizing it.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","In response one of the lawyers said to him, “Teacher, by saying these things, yoʋ insult us as well.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","But Jesus said, “Woe also to you lawyers! For you burden people with burdens that are hard to bear, but you yourselves do not touch the burdens with even one of your fingers. ");
INSERT INTO engtcent_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Woe to you! For you build the tombs of the prophets, but it was your fathers who killed them. ");
INSERT INTO engtcent_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","So you bear witness to and approve of the works of your fathers; for they killed the prophets, and you build their tombs. ");
INSERT INTO engtcent_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","That is why the wisdom of God said, ‘I will send them prophets and apostles, some of whom they will kill and some of whom they will persecute.’ ");
INSERT INTO engtcent_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","As a result, this generation will be held accountable for the blood of all the prophets that has been shed from the foundation of the world, ");
INSERT INTO engtcent_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","from the blood of Abel to the blood of Zechariah, who perished between the altar and the house of God. Yes, I tell you, this generation will be held accountable. ");
INSERT INTO engtcent_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Woe to you lawyers! For you have taken away the key of knowledge. You yourselves have not entered, and you have hindered those who were trying to enter.” ");
INSERT INTO engtcent_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","As he was saying these things to them, the scribes and the Pharisees began to oppose him fiercely and to question him closely about many things, ");
INSERT INTO engtcent_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","lying in wait for him and seeking to catch him in some word coming out of his mouth, so that they might accuse him. ");
INSERT INTO engtcent_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Meanwhile, when the crowd had gathered together by the thousands, so that they were trampling on one another, Jesus began to speak first to his disciples: “Beware of the leaven of the Pharisees, which is hypocrisy. ");
INSERT INTO engtcent_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","There is nothing covered up that will not be revealed, and nothing hidden that will not be made known. ");
INSERT INTO engtcent_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Therefore whatever you have said in the darkness will be heard in the light, and what you have whispered in anyone's ear in private rooms will be proclaimed on the housetops. ");
INSERT INTO engtcent_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“I tell you, my friends, do not be afraid of those who kill the body, and after that have nothing more they can do. ");
INSERT INTO engtcent_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","But I will tell you whom you should fear: Fear him who has authority to throw you into hell after your body has been killed. Yes, I tell you, fear him! ");
INSERT INTO engtcent_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Are not five sparrows sold for two pennies? Yet not one of them is forgotten in the sight of God. ");
INSERT INTO engtcent_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Indeed, even the hairs of your head are all numbered. So do not be afraid; you are of more value than many sparrows. ");
INSERT INTO engtcent_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“I tell you, everyone who acknowledges me before men, the Son of Man will also acknowledge before the angels of God, ");
INSERT INTO engtcent_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","but whoever denies me before men will be denied before the angels of God. ");
INSERT INTO engtcent_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","And everyone who speaks a word against the Son of Man will be forgiven, but whoever blasphemes against the Holy Spirit will not be forgiven. ");
INSERT INTO engtcent_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","When you are brought before synagogues, rulers, and authorities, do not be anxious about how or what you should speak in your own defense, or what you should say, ");
INSERT INTO engtcent_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","for the Holy Spirit will teach you in that very hour what you should say.” ");
INSERT INTO engtcent_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Then someone from among the crowd said to him, “Teacher, tell my brother to divide the family inheritance with me.” ");
INSERT INTO engtcent_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","But Jesus said to him, “Man, who appointed me as a judge or arbitrator over you?” ");
INSERT INTO engtcent_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Then he said to them, “Watch out and be on your guard against covetousness, for one's life does not consist in the abundance of his possessions.” ");
INSERT INTO engtcent_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","And he told them a parable: “The land of a certain rich man produced abundantly. ");
INSERT INTO engtcent_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","So he thought to himself, ‘What should I do, for I do not have anywhere to store my crops?’ ");
INSERT INTO engtcent_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Then he said, ‘This is what I will do: I will tear down my barns and build larger ones, and there I will store all my produce and my goods. ");
INSERT INTO engtcent_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","And I will say to my soul, “Soul, yoʋ have many goods laid up for many years; relax, eat, drink, and be merry.” ’ ");
INSERT INTO engtcent_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","But God said to him, ‘Yoʋ fool! This very night yoʋr life will be demanded back from yoʋ, and the things yoʋ have prepared, whose will they be?’ ");
INSERT INTO engtcent_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","This is how it will be with anyone who lays up treasure for himself and is not rich toward God.” ");
INSERT INTO engtcent_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Then Jesus said to his disciples, “Therefore I tell you, do not be anxious about your life, what you will eat, or about your body, what you will wear. ");
INSERT INTO engtcent_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Life is more than food, and the body is more than clothing. ");
INSERT INTO engtcent_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Consider the ravens: They do not sow or reap; they have no storehouse or barn, yet God feeds them. Of how much more value are you than birds? ");
INSERT INTO engtcent_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Which of you by being anxious can add a single moment to yoʋr span of life? ");
INSERT INTO engtcent_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","If then you cannot even do a very little thing like that, why are you anxious about the rest? ");
INSERT INTO engtcent_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Consider the lilies, how they grow: They do not toil or spin, yet I tell you, not even Solomon in all his glory was clothed like one of these. ");
INSERT INTO engtcent_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Now if God so clothes the grass in the field, which is alive today and tomorrow is thrown into the oven, how much more will he clothe you, O you of little faith? ");
INSERT INTO engtcent_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","And do not be concerned about what you will eat or what you will drink; do not be anxious about such things. ");
INSERT INTO engtcent_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","For the nations of the world seek after all these things, and your Father knows that you need them. ");
INSERT INTO engtcent_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Rather, seek the kingdom of God, and all these things will be added to you. ");
INSERT INTO engtcent_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Do not be afraid, little flock, for your Father is pleased to give you the kingdom. ");
INSERT INTO engtcent_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sell your possessions and give to the needy. Make yourselves moneybags that do not wear out, an inexhaustible treasure in heaven, where no thief comes near and no moth destroys. ");
INSERT INTO engtcent_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","For where your treasure is, there will your heart be also. ");
INSERT INTO engtcent_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Be dressed for service and keep your lamps burning, ");
INSERT INTO engtcent_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","like men who are waiting for their master to return from a wedding feast, so that they can immediately open the door for him when he comes and knocks. ");
INSERT INTO engtcent_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blessed are those servants whom their master finds keeping watch when he comes. Truly I say to you, he will dress himself for service and have them recline at the table, and he will come and serve them. ");
INSERT INTO engtcent_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","If he comes in the second watch or the third watch and finds them doing so, blessed are those servants. ");
INSERT INTO engtcent_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","But know this: If the master of the house had known at what hour the thief was coming, he would have kept watch and would not have let his house be broken into. ");
INSERT INTO engtcent_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Therefore you also must be ready, for the Son of Man is coming at an hour when you do not expect him.” ");
INSERT INTO engtcent_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Then Peter said to him, “Lord, are yoʋ telling this parable only for us, or for everyone else as well?” ");
INSERT INTO engtcent_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","The Lord said, “Who then is the faithful and wise steward, whom his master will set over his household, to give them their portion of food at the proper time? ");
INSERT INTO engtcent_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blessed is that servant whom his master finds doing so when he comes. ");
INSERT INTO engtcent_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Truly I say to you, he will set him over all his possessions. ");
INSERT INTO engtcent_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","But if that servant says in his heart, ‘My master is delayed in coming,’ and he begins to beat the male and female servants, and to eat and drink and get drunk, ");
INSERT INTO engtcent_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","the master of that servant will come on a day when he does not expect him and at an hour he does not foresee, and will cut him in two and assign his portion to be with the unfaithful. ");
INSERT INTO engtcent_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","That servant who knew his master's will, but did not prepare himself or act according to his will, will be beaten with many lashes. ");
INSERT INTO engtcent_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","But the one who did not know his master's will, yet did what deserved a beating, will be beaten with few lashes. From everyone to whom much has been given, much will be required; and from him to whom much has been entrusted, even more will be demanded. ");
INSERT INTO engtcent_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“I have come to bring fire to the earth, and how I wish it were already kindled! ");
INSERT INTO engtcent_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","But I have a baptism to be baptized with, and how consumed I am with it until it is completed! ");
INSERT INTO engtcent_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Do you think I have come to grant peace on earth? No, I tell you, but division. ");
INSERT INTO engtcent_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","For from now on five in one household will be divided, three against two and two against three. ");
INSERT INTO engtcent_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Father will be divided against son and son against father, mother against daughter and daughter against mother, mother-in-law against her daughter-in-law and daughter-in-law against her mother-in-law.” ");
INSERT INTO engtcent_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus also said to the crowds, “When you see a cloud rising from the west, you immediately say, ‘A rainstorm is coming,’ and that is what happens. ");
INSERT INTO engtcent_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","And when you see the south wind blowing, you say, ‘There will be scorching heat,’ and it happens. ");
INSERT INTO engtcent_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hypocrites! You know how to interpret the appearance of the earth and the sky, so why can you not interpret this present time? ");
INSERT INTO engtcent_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Why do you not judge for yourselves what is right? ");
INSERT INTO engtcent_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","As yoʋ are going with yoʋr adversary before the magistrate, make an effort to settle with him on the way, lest he drag yoʋ to the judge, and the judge hand yoʋ over to the officer, and the officer throw yoʋ into prison. ");
INSERT INTO engtcent_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","I tell yoʋ, yoʋ will certainly not come out of there until yoʋ have paid the very last cent.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Now there were some present at that very time who told Jesus about the Galileans whose blood Pilate had mixed with their sacrifices. ");
INSERT INTO engtcent_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus responded to them, “Do you think that those Galileans were worse sinners than all the other Galileans because they suffered such things? ");
INSERT INTO engtcent_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","No, I tell you, but if you do not repent, you will all likewise perish. ");
INSERT INTO engtcent_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Or those eighteen who were killed when the tower in Siloam fell on them, do you think they were worse offenders than all the other people who dwell in Jerusalem? ");
INSERT INTO engtcent_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","No, I tell you, but if you do not repent, you will all likewise perish.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Then he told this parable: “A man had a fig tree planted in his vineyard, and he came looking for fruit on it but did not find any. ");
INSERT INTO engtcent_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","So he said to the vinedresser, ‘Behold, for three years I have come looking for fruit on this fig tree and have not found any. Cut it down! Why should it use up the soil?’ ");
INSERT INTO engtcent_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","But the vinedresser said to him in response, ‘Sir, allow it to remain for this year also, and I will dig around it and put manure on it. ");
INSERT INTO engtcent_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","If it bears fruit, fine; but if not, yoʋ can cut it down in the coming year.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","One Sabbath Jesus was teaching in one of the synagogues. ");
INSERT INTO engtcent_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","And behold, there was a woman who had suffered from a spirit of disability for eighteen years. She was bent over and could not stand up completely straight. ");
INSERT INTO engtcent_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","When Jesus saw her, he called her over and said to her, “Woman, yoʋ are set free from yoʋr disability.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Then he laid his hands on her, and at once her back was made straight, and she began glorifying God. ");
INSERT INTO engtcent_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","But the ruler of the synagogue, indignant because Jesus had healed on the Sabbath, said to the crowd in response, “There are six days in which work should be done; so come and be healed on those days and not on the Sabbath day.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Then the Lord said to him in response, “Hypocrites! Do not each of you on the Sabbath untie yoʋr ox or donkey from the manger, lead it away, and give it water? ");
INSERT INTO engtcent_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Then should not this woman, a daughter of Abraham whom Satan has bound for eighteen long years, be released from this bondage on the Sabbath day?” ");
INSERT INTO engtcent_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","When he said this, all his adversaries were put to shame, and the entire crowd was rejoicing over all the glorious things he was doing. ");
INSERT INTO engtcent_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Then Jesus said, “What is the kingdom of God like? To what should I compare it? ");
INSERT INTO engtcent_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","It is like a grain of mustard seed that a man took and sowed in his garden. It grew and became a large tree, and the birds of the sky nested in its branches.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Again he said, “To what should I compare the kingdom of God? ");
INSERT INTO engtcent_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","It is like leaven that a woman took and mixed into three measures of flour until it had all been leavened.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Then Jesus traveled through towns and villages, teaching and making his way to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Someone said to him, “Lord, will only a few be saved?” Jesus said to them, ");
INSERT INTO engtcent_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Strive to enter through the narrow gate. For many, I tell you, will seek to enter and will not be able to. ");
INSERT INTO engtcent_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Once the master of the house gets up and shuts the door, you will begin to stand outside and knock at the door, saying, ‘Lord, Lord, open the door for us.’ But he will answer you, ‘I do not know you or where you are from.’ ");
INSERT INTO engtcent_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Then you will begin to say, ‘We ate and drank in yoʋr presence, and yoʋ taught in our streets.’ ");
INSERT INTO engtcent_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","But he will say, ‘I tell you, I do not know you or where you are from. Depart from me, all you workers of unrighteousness.’ ");
INSERT INTO engtcent_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","In that place there will be weeping and gnashing of teeth, when you see Abraham, Isaac, Jacob, and all the prophets in the kingdom of God, but you yourselves cast out. ");
INSERT INTO engtcent_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","People will come from east and west, and from north and south, and recline at the banquet table in the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","And behold, some are last who will be first, and some are first who will be last.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","On that same day some Pharisees came up and said to Jesus, “Leave this place and go somewhere else, for Herod wants to kill yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","But he said to them, “Go tell that fox, ‘Behold, I will continue casting out demons and performing healings today and tomorrow, and on the third day I will finish my work.’ ");
INSERT INTO engtcent_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nevertheless, I must go on my way today, tomorrow, and the following day; for it is unthinkable that a prophet should perish outside of Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalem, Jerusalem, the city that kills the prophets and stones those who are sent to yoʋ! How often I have wanted to gather yoʋr children together as a hen gathers her brood under her wings, but you were not willing! ");
INSERT INTO engtcent_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Behold, your house is left to you desolate. I tell you, you will certainly not see me again until the time comes when you say, ‘Blessed is he who comes in the name of the Lord!’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","One Sabbath, when Jesus went to eat at the house of one of the rulers of the Pharisees, the people there were watching him closely. ");
INSERT INTO engtcent_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","And behold, there in front of him was a man suffering from dropsy. ");
INSERT INTO engtcent_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","In response Jesus said to the lawyers and Pharisees, “Is it lawful to heal on the Sabbath?” ");
INSERT INTO engtcent_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","But they remained silent. So Jesus took hold of the man, healed him, and sent him away. ");
INSERT INTO engtcent_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Then he said to them, “Which of you whose son or ox falls into a pit on the Sabbath will not immediately pull him out?” ");
INSERT INTO engtcent_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","But they could give him no answer about these things. ");
INSERT INTO engtcent_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","When Jesus noticed how the guests were choosing the places of honor for themselves, he told them a parable: ");
INSERT INTO engtcent_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“When yoʋ are invited by someone to a wedding feast, do not recline in the place of honor, in case someone more honorable than yoʋ has been invited by yoʋr host. ");
INSERT INTO engtcent_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Then the host, who invited you both, will come and say to yoʋ, ‘Give yoʋr place to this person.’ And with shame yoʋ will begin moving to the least important place. ");
INSERT INTO engtcent_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","But when yoʋ are invited, go recline in the least important place, so that, when yoʋr host comes, he will say to yoʋ, ‘Friend, move up to a better place.’ Then yoʋ will be honored in the presence of those who are reclining at the table with yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","For everyone who exalts himself will be humbled, and he who humbles himself will be exalted.” ");
INSERT INTO engtcent_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus also said to the man who had invited him, “When yoʋ prepare a luncheon or a dinner, do not invite yoʋr friends, yoʋr brothers, yoʋr relatives, or yoʋr rich neighbors. If yoʋ do, they may invite yoʋ in return, and yoʋ will be repaid. ");
INSERT INTO engtcent_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","But when yoʋ prepare a banquet, invite the poor, the maimed, the lame, and the blind. ");
INSERT INTO engtcent_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Then yoʋ will be blessed. Since they do not have the means to repay yoʋ, yoʋ will be repaid at the resurrection of the righteous.” ");
INSERT INTO engtcent_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","When one of the men reclining at the table with Jesus heard these things, he said to him, “Blessed is he who will eat at the feast in the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus said to him, “A man prepared a great banquet and invited many guests. ");
INSERT INTO engtcent_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","At the time for the banquet he sent his servant to tell those who had been invited, ‘Come, for everything is now ready.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","But they all alike began to make excuses. The first one said to him, ‘I have bought a field, and I need to go out and see it. I ask yoʋ to have me excused.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Another said, ‘I have bought five yoke of oxen, and I am on my way to try them out. I ask yoʋ to have me excused.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Still another said, ‘I have married a woman, and for that reason I cannot come.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","So the servant came back and told these things to his master. Then the master of the house became angry and said to his servant, ‘Go out quickly into the streets and lanes of the city, and bring in the poor, the maimed, the lame, and the blind.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","After the servant had done so, he said, ‘Master, it has been done as yoʋ commanded, and there is still room.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","So the master said to the servant, ‘Go out to the highways and hedges and compel people to come in, so that my house may be filled. ");
INSERT INTO engtcent_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","For I tell you that none of those men who were invited will get a taste of my banquet.’ For many are called, but few are chosen.” ");
INSERT INTO engtcent_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Now large crowds were traveling with Jesus, and he turned and said to them, ");
INSERT INTO engtcent_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“If anyone comes to me and does not hate his father and mother, wife and children, brothers and sisters, and even his own life, he cannot be my disciple. ");
INSERT INTO engtcent_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","And whoever does not bear his own cross and follow me cannot be my disciple. ");
INSERT INTO engtcent_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","For which of you who wants to build a tower does not first sit down and estimate the cost, to see if he has what he needs to complete it? ");
INSERT INTO engtcent_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","For if he lays the foundation and is not able to finish it, all who are looking on will begin to mock him, ");
INSERT INTO engtcent_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","saying, ‘This man began to build and was not able to finish.’ ");
INSERT INTO engtcent_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Or what king, when he is going out to confront another king in battle, does not first sit down and consider whether he is able with ten thousand men to face the king who is coming against him with twenty thousand men? ");
INSERT INTO engtcent_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","If he is not able to do so, he sends a delegation while the other is still far away and asks for terms of peace. ");
INSERT INTO engtcent_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","So then, any one of you who does not give up all his possessions cannot be my disciple. ");
INSERT INTO engtcent_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Salt is good, but if salt loses its flavor, with what shall it be seasoned? ");
INSERT INTO engtcent_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","It is fit neither for the soil nor for the manure pile, so it is thrown out. He who has ears to hear, let him hear.” ");
INSERT INTO engtcent_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Now all the tax collectors and sinners were drawing near to Jesus to listen to him. ");
INSERT INTO engtcent_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","But the Pharisees and the scribes grumbled, saying, “This man receives sinners and eats with them.” ");
INSERT INTO engtcent_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","So Jesus told them this parable: ");
INSERT INTO engtcent_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“What man among you, who has a hundred sheep and loses one of them, does not leave the other ninety-nine in the wilderness and go after the one that is lost until he finds it? ");
INSERT INTO engtcent_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","And when he does find it, he rejoices as he lays it on his shoulders. ");
INSERT INTO engtcent_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Then he returns home and calls together his friends and neighbors, saying to them, ‘Rejoice with me, for I have found my lost sheep.’ ");
INSERT INTO engtcent_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","I tell you, in the same way there will be more joy in heaven over one sinner who repents, than over ninety-nine righteous people who have no need of repentance. ");
INSERT INTO engtcent_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Or suppose a woman has ten silver coins and loses one of them. Does she not light a lamp, sweep the house, and search carefully until she finds it? ");
INSERT INTO engtcent_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","And when she does find it, she calls together her friends and neighbors, saying, ‘Rejoice with me, for I have found my lost coin.’ ");
INSERT INTO engtcent_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","In the same way, I tell you, there is joy in the presence of God's angels over one sinner who repents.” ");
INSERT INTO engtcent_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Then he said, “There was a man who had two sons. ");
INSERT INTO engtcent_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","The younger of the two said to his father, ‘Father, give me the share of property that will belong to me.’ So the father divided his assets between his two sons. ");
INSERT INTO engtcent_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A few days later, the younger son gathered together all that he had and went on a journey to a distant country, and there he squandered his property by living recklessly. ");
INSERT INTO engtcent_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","When he had spent all that he had, a severe famine arose throughout that country, and he began to be in need. ");
INSERT INTO engtcent_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","So he went and hired himself out to one of the citizens of that country, who sent him to his fields to feed pigs. ");
INSERT INTO engtcent_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","The young man longed to fill his belly with the carob pods the pigs were eating, but no one gave him anything. ");
INSERT INTO engtcent_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","When he came to his senses, he said, ‘How many of my father's hired workers have an abundance of bread, while I perish with hunger! ");
INSERT INTO engtcent_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","I will arise, go to my father, and say to him, “Father, I have sinned against heaven and before yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","I am no longer worthy to be called yoʋr son; make me like one of yoʋr hired workers.” ’ ");
INSERT INTO engtcent_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","So he arose and went to his father. But while he was still far away, his father saw him and was moved with compassion. So he ran to his son, threw his arms around his neck, and kissed him. ");
INSERT INTO engtcent_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Then the son said to him, ‘Father, I have sinned against heaven and before yoʋ. I am no longer worthy to be called yoʋr son.’ ");
INSERT INTO engtcent_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","But the father said to his servants, ‘Bring out the best robe and put it on him. Put a ring on his finger and sandals on his feet. ");
INSERT INTO engtcent_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bring the fattened calf and kill it. Let us eat and celebrate. ");
INSERT INTO engtcent_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","For this son of mine was dead but is now alive again; he was lost but has now been found.’ And they began to celebrate. ");
INSERT INTO engtcent_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Now his older son was in the field, and as he came and drew near to the house, he heard music and dancing. ");
INSERT INTO engtcent_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","So he called one of the servants over and asked him what was happening. ");
INSERT INTO engtcent_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","The servant said to him, ‘Yoʋr brother has come, and yoʋr father has killed the fattened calf, because he has received yoʋr brother back safe and sound.’ ");
INSERT INTO engtcent_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","But the older son was angry and would not go in. So his father came out and began pleading with him. ");
INSERT INTO engtcent_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","But he said to his father in response, ‘Behold, all these years I have served yoʋ and have never disobeyed yoʋr command, yet yoʋ have never given me even a young goat so that I could celebrate with my friends. ");
INSERT INTO engtcent_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","But when this son of yoʋrs came, who has devoured yoʋr assets with prostitutes, yoʋ killed the fattened calf for him.’ ");
INSERT INTO engtcent_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","The father said to him, ‘Son, yoʋ are always with me, and everything I have is yoʋrs. ");
INSERT INTO engtcent_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","But it was proper to celebrate and rejoice, for yoʋr brother was dead but is now alive again; he was lost but has now been found.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Then Jesus said to his disciples, “There was a rich man whose steward was accused of squandering his possessions. ");
INSERT INTO engtcent_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","So he called the steward in and said to him, ‘What is this I hear about yoʋ? Give an account of yoʋr stewardship, for yoʋ can no longer be steward.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","The steward said to himself, ‘What should I do, now that my master is taking my stewardship away from me? I am not strong enough to dig, and I am ashamed to beg. ");
INSERT INTO engtcent_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","I know what I will do so that, when I am removed from my stewardship, people will receive me into their homes.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","So he summoned each one of his master's debtors. He said to the first, ‘How much do yoʋ owe my master?’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","The man said, ‘A hundred measures of oil.’ The steward said to him, ‘Take yoʋr bill, sit down quickly, and write fifty.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Then he said to another, ‘And how much do yoʋ owe?’ The man said, ‘A hundred measures of wheat.’ The steward said to him, ‘Take yoʋr bill and write eighty.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","So the master commended the unrighteous steward because he had acted shrewdly. For the people of this world are more shrewd in dealing with their own generation than are the people of the light. ");
INSERT INTO engtcent_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","And I tell you, make friends for yourselves by means of unrighteous wealth so that when you die, those friends will receive you into eternal dwellings. ");
INSERT INTO engtcent_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“He who is faithful with very little is also faithful with much, and he who is dishonest with very little is also dishonest with much. ");
INSERT INTO engtcent_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","If then you have not been faithful with unrighteous wealth, who will entrust you with true riches? ");
INSERT INTO engtcent_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","And if you have not been faithful with the property of another, who will give you property of your own? ");
INSERT INTO engtcent_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","No servant can serve two masters, for either he will hate one and love the other, or he will be devoted to one and despise the other. You cannot serve God and money.” ");
INSERT INTO engtcent_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Now the Pharisees, who were lovers of money, heard all these things and began ridiculing Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","So he said to them, “You present yourselves as righteous in the sight of men, but God knows your hearts. For what is highly esteemed among men is an abomination in the sight of God. ");
INSERT INTO engtcent_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“The Law and the Prophets were proclaimed until John; since then the good news of the kingdom of God has been preached, and everyone tries to force their way into it. ");
INSERT INTO engtcent_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","But it is easier for heaven and earth to pass away than for one stroke of a letter to be dropped from the law. ");
INSERT INTO engtcent_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“For example, any man who divorces his wife and marries another commits adultery, and any man who marries a woman divorced from her husband commits adultery. ");
INSERT INTO engtcent_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Now there was a certain rich man who would dress in purple and fine linen, enjoying himself each day as he lived lavishly. ");
INSERT INTO engtcent_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","There was also a poor man named Lazarus, who was laid at the rich man's gate, covered with sores. ");
INSERT INTO engtcent_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","He longed to be filled with the crumbs that fell from the rich man's table, but instead the dogs would come and lick his sores. ");
INSERT INTO engtcent_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Now the poor man died and was carried away by the angels to Abraham's side, and the rich man also died and was buried. ");
INSERT INTO engtcent_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","As he was in torment in Hades, he lifted up his eyes and saw Abraham far off, and Lazarus at his side. ");
INSERT INTO engtcent_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","So he called out and said, ‘Father Abraham, have mercy on me and send Lazarus to dip the tip of his finger in water and cool my tongue, for I am in agony in these flames.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","But Abraham said, ‘Son, remember that in yoʋr lifetime yoʋ received yoʋr good things, and in the same way Lazarus received bad things, but now he is here being comforted, while yoʋ are in agony. ");
INSERT INTO engtcent_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","And besides all this, a great chasm has been set in place between you and us, so that those who want to cross over to you from here cannot do so, nor can anyone cross over to us from there.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","The rich man said, ‘Then I beg yoʋ, father, to send Lazarus to my father's house, ");
INSERT INTO engtcent_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","for I have five brothers. Let him warn them, so that they will not also come to this place of torment.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham said to him, ‘They have Moses and the Prophets; they can listen to them.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","He said, ‘No, father Abraham, but if someone goes to them from the dead, they will repent.’ ");
INSERT INTO engtcent_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","But Abraham said to him, ‘If they do not listen to Moses and the Prophets, neither will they be persuaded even if someone rises from the dead.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Then Jesus said to the disciples, “It is inevitable that stumbling blocks come, but woe to the one through whom they come! ");
INSERT INTO engtcent_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","It would be better for him if a heavy millstone were hung around his neck and he were cast into the sea than for him to cause one of these little ones to stumble. ");
INSERT INTO engtcent_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Watch yourselves. If yoʋr brother sins against yoʋ, rebuke him. If he repents, forgive him. ");
INSERT INTO engtcent_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Even if he sins against yoʋ seven times in a day, and seven times in that day he comes back and says, ‘I repent,’ yoʋ must forgive him.” ");
INSERT INTO engtcent_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","The apostles said to the Lord, “Increase our faith.” ");
INSERT INTO engtcent_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","The Lord said, “If you had faith like a grain of mustard seed, you could say to this mulberry tree, ‘Be uprooted and planted in the sea,’ and it would obey you. ");
INSERT INTO engtcent_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Suppose one of you has a servant plowing the field or tending the sheep. As soon as he comes in from the field would you say, ‘Come and recline at the table’? ");
INSERT INTO engtcent_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Instead, would yoʋ not say to him, ‘Prepare my supper. Put on yoʋr apron and serve me while I eat and drink; after that yoʋ may eat and drink’? ");
INSERT INTO engtcent_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Do yoʋ thank that servant because he did what he was commanded? I think not. ");
INSERT INTO engtcent_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","So you also, when you have done everything you were commanded to do, should say, ‘We are unworthy servants; we have only done what we were obligated to do.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Now on his way to Jerusalem, Jesus traveled along the border of Samaria and Galilee. ");
INSERT INTO engtcent_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","As he entered a village, he was met by ten lepers who stood at a distance. ");
INSERT INTO engtcent_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","They lifted up their voices, saying, “Jesus, Master, have mercy on us!” ");
INSERT INTO engtcent_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","When he saw them, he said to them, “Go show yourselves to the priests.” As they went along, they were cleansed. ");
INSERT INTO engtcent_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","When one of them saw that he had been healed, he came back, glorifying God with a loud voice. ");
INSERT INTO engtcent_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","He then fell on his face at Jesus' feet, giving him thanks. (Now he was a Samaritan.) ");
INSERT INTO engtcent_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","In response Jesus said, “Were not ten cleansed? Where then are the other nine? ");
INSERT INTO engtcent_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Were there none found who came back to give glory to God except this foreigner?” ");
INSERT INTO engtcent_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Then he said to the man, “Rise and go on yoʋr way; yoʋr faith has healed yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","At one point Jesus was asked by the Pharisees when the kingdom of God was coming, so he answered them, “The kingdom of God does not come with observable signs, ");
INSERT INTO engtcent_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","nor will people say, ‘Behold, here it is!’ or, ‘Behold, there it is!’ For behold, the kingdom of God is within you.” ");
INSERT INTO engtcent_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Then he said to the disciples, “The days will come when you will long to see one of the days of the Son of Man, but you will not see it. ");
INSERT INTO engtcent_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","People will say to you, ‘Behold, here he is!’ or, ‘Behold, there he is!’ Do not go off with them or run after them, ");
INSERT INTO engtcent_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","for just as lightning flashes from one part of the sky and shines to the other, so will the Son of Man be in his day. ");
INSERT INTO engtcent_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","But first he must suffer many things and be rejected by this generation. ");
INSERT INTO engtcent_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Just as it was in the days of Noah, so will it be in the days of the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","People were eating and drinking, marrying and being given in marriage, until the day when Noah went into the ark, and the flood came and destroyed them all. ");
INSERT INTO engtcent_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","It will be the same as it was in the days of Lot. People were eating and drinking, buying and selling, planting and building. ");
INSERT INTO engtcent_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","But on the day when Lot went out from Sodom, fire and sulfur rained down from heaven and destroyed them all. ");
INSERT INTO engtcent_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","So will it be on the day when the Son of Man is revealed. ");
INSERT INTO engtcent_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","On that day, he who is on the housetop and whose goods are in the house must not come down to get them. Likewise, he who is in the field must not turn back. ");
INSERT INTO engtcent_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Remember Lot's wife. ");
INSERT INTO engtcent_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Whoever seeks to save his life will lose it, but whoever loses his life will preserve it. ");
INSERT INTO engtcent_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","I tell you, on that night two people will be in one bed; one will be taken and the other will be left. ");
INSERT INTO engtcent_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Two women will be grinding grain together; one will be taken and the other will be left.” ");
INSERT INTO engtcent_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Then the disciples said to him in response, “Where, Lord?” He said to them, “Where the body is, there the vultures will be gathered together.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Then Jesus told them a parable about the need for them to pray at all times and not lose heart. ");
INSERT INTO engtcent_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","He said, “In a certain city there was a judge who neither feared God nor respected man. ");
INSERT INTO engtcent_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","There was also a widow in that city who kept coming to him and saying, ‘Give me justice against my adversary.’ ");
INSERT INTO engtcent_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","For a while he would not do so, but afterward he said to himself, ‘Though I neither fear God nor respect man, ");
INSERT INTO engtcent_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yet because this widow keeps bothering me, I will give her justice, so that she will not wear me out by continually coming to me.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Then the Lord said, “Consider what this unrighteous judge said. ");
INSERT INTO engtcent_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","If even he ultimately rendered a just decision, will not God patiently listen to his chosen ones, who cry out to him day and night, and give them justice? ");
INSERT INTO engtcent_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","I tell you that he will bring about justice for them quickly. Nevertheless, when the Son of Man comes, will he find faith on the earth?” ");
INSERT INTO engtcent_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","He also told this parable to some who were confident in their own righteous and regarded others with contempt: ");
INSERT INTO engtcent_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Two men went up to the temple to pray. One was a Pharisee and the other was a tax collector. ");
INSERT INTO engtcent_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","The Pharisee stood by himself and prayed like this: ‘God, I thank yoʋ that I am not like other people: swindlers, unrighteous, adulterers, or even like this tax collector. ");
INSERT INTO engtcent_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","I fast twice a week, and I give tithes of all that I get.’ ");
INSERT INTO engtcent_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","But the tax collector stood at a distance and would not even lift up his eyes to heaven, but beat his breast, saying, ‘God, be merciful to me, a sinner!’ ");
INSERT INTO engtcent_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","I tell you, this man went down to his home justified rather than the other one. For everyone who exalts himself will be humbled, but he who humbles himself will be exalted.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Now people were even bringing their babies to Jesus so that he might touch them. When the disciples saw this, they rebuked those who were bringing them, ");
INSERT INTO engtcent_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","but Jesus called for them and said, “Let the little children come to me and do not hinder them, for the kingdom of God belongs to such as these. ");
INSERT INTO engtcent_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Truly I say to you, whoever does not receive the kingdom of God like a little child will certainly not enter it.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Then a certain ruler asked him, “Good Teacher, what must I do to inherit eternal life?” ");
INSERT INTO engtcent_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus said to him, “Why do yoʋ call me good? No one is good except God alone. ");
INSERT INTO engtcent_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yoʋ know the commandments: ‘Do not commit adultery, Do not murder, Do not steal, Do not give false testimony, Honor yoʋr father and yoʋr mother.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","The man said, “I have kept all these commandments from the time I was a young boy.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","When Jesus heard this, he said to him, “One thing yoʋ still lack: Sell everything yoʋ have and distribute the money to the poor, and yoʋ will have treasure in heaven; then come follow me.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","But when the man heard this, he became very sorrowful, for he was extremely rich. ");
INSERT INTO engtcent_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","When Jesus saw that the man had become very sorrowful, he said, “How difficult it will be for those who have riches to enter the kingdom of God! ");
INSERT INTO engtcent_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","For it is easier for a camel to go through the eye of a needle than for a rich person to enter the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Those who heard this said, “Who then can be saved?” ");
INSERT INTO engtcent_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus said, “What is impossible with men is possible with God.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Then Peter said, “Behold, we have left everything and followed yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus said to them, “Truly I say to you, there is no one who has left house, parents, brothers, wife, or children, for the sake of the kingdom of God, ");
INSERT INTO engtcent_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","who will not surely receive many times more in this present age—and in the age to come, eternal life.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Then Jesus took the twelve aside and said to them, “Behold, we are going up to Jerusalem, and everything written by the prophets about the Son of Man will be fulfilled. ");
INSERT INTO engtcent_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","For he will be delivered up to the Gentiles, and he will be mocked, insulted, and spit upon. ");
INSERT INTO engtcent_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","After flogging him, they will kill him, and on the third day he will rise again.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","But the disciples did not understand any of these things; this statement was hidden from them, and they did not comprehend what was being said. ");
INSERT INTO engtcent_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","As Jesus drew near to Jericho, a blind man was sitting by the road begging. ");
INSERT INTO engtcent_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","When he heard a crowd going by, he asked what was happening. ");
INSERT INTO engtcent_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","They told him that Jesus of Nazareth was passing by. ");
INSERT INTO engtcent_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","So he cried out, “Jesus, Son of David, have mercy on me!” ");
INSERT INTO engtcent_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Then those who were out in front rebuked him, telling him to be silent. But he cried out all the more, “Son of David, have mercy on me!” ");
INSERT INTO engtcent_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","So Jesus stopped and ordered the man to be brought to him. When the man drew near, Jesus asked him, ");
INSERT INTO engtcent_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“What do yoʋ want me to do for yoʋ?” He said, “Lord, I want to receive my sight.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","So Jesus said to him, “Receive yoʋr sight; yoʋr faith has healed yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Immediately he received his sight and began following Jesus, glorifying God. And when all the people saw it, they gave praise to God. ");
INSERT INTO engtcent_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Then Jesus entered Jericho and was passing through. ");
INSERT INTO engtcent_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","And behold, there was a man named Zacchaeus. He was a chief tax collector and was rich. ");
INSERT INTO engtcent_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","He was trying to see who Jesus was, but he could not do so because of the crowd, for he was a short man. ");
INSERT INTO engtcent_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","So he ran on ahead and climbed a sycamore tree so that he could see him, because Jesus was about to pass by that way. ");
INSERT INTO engtcent_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","When Jesus came to that place, he looked up and saw him. Then he said to him, “Zacchaeus, hurry and come down, for I must stay at yoʋr house today.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","So he hurried down and received Jesus with joy. ");
INSERT INTO engtcent_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","When all the people saw it, they grumbled, saying, “He has gone to be the guest of a sinful man.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","But Zacchaeus stood there and said to the Lord, “Behold, half of my goods, Lord, I give to the poor, and if I have extorted anything from anyone, I will pay back four times the amount.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus said to him, “Today salvation has come to this house, because this man has shown that he too is a son of Abraham. ");
INSERT INTO engtcent_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","For the Son of Man came to seek and save the lost.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Now as the people were listening to this, Jesus went on to tell a parable, because he was near Jerusalem, and because they thought that the kingdom of God was going to appear at once. ");
INSERT INTO engtcent_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","So he said, “A man of noble birth went to a distant country to receive a kingdom for himself and then return. ");
INSERT INTO engtcent_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Calling ten of his servants, he gave them ten minas and said to them, ‘Engage in business until I return.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","But his subjects hated him and sent a delegation after him, saying, ‘We do not want this man to reign over us.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","When he returned after receiving the kingdom, he summoned the servants to whom he had given the money, to find out who had gained what by engaging in business. ");
INSERT INTO engtcent_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","The first came before him and said, ‘Master, yoʋr mina has made ten minas more.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","The king said to him, ‘Well done, good servant! Because yoʋ have been faithful in a very small matter, take authority over ten cities.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","The second came and said, ‘Master, yoʋr mina has made five minas.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","The king said to him, ‘Yoʋ are to be over five cities.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Another came and said, ‘Master, behold, here is yoʋr mina, which I kept put away in a piece of cloth. ");
INSERT INTO engtcent_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","For I was afraid of yoʋ, because yoʋ are a stern man. Yoʋ take out what yoʋ did not put in, and yoʋ reap what yoʋ did not sow.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","The king said to him, ‘I will condemn yoʋ by the words coming out of yoʋr own mouth, yoʋ evil servant. Yoʋ knew, did yoʋ, that I was a stern man, taking out what I did not put in, and reaping what I did not sow? ");
INSERT INTO engtcent_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Why then did yoʋ not deposit my money in the bank, and when I came I would have collected it with interest?’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Then he said to those standing nearby, ‘Take the mina from him and give it to the one who has ten minas.’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","But they said to him, ‘Master, he has ten minas!’ ");
INSERT INTO engtcent_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","The king said, ‘I tell you that everyone who has will be given more, but the one who does not have, even what he has will be taken away from him. ");
INSERT INTO engtcent_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","But as for those enemies of mine who did not want me to reign over them, bring them here and slay them in front of me.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","After saying these things, Jesus continued on his way up to Jerusalem, walking ahead of his disciples. ");
INSERT INTO engtcent_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","As he drew near to Bethsphage and Bethany, at the mount called Olivet, he sent two of his disciples ahead, ");
INSERT INTO engtcent_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","saying, “Go into the village ahead of you. As you enter it, you will find a colt tied, on which no one has ever sat. Untie it and bring it here. ");
INSERT INTO engtcent_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","If anyone asks you, ‘Why are you untying it?’ tell him this: ‘The Lord has need of it.’ ” ");
INSERT INTO engtcent_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","So those who were sent went off and found it just as he had told them. ");
INSERT INTO engtcent_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","As they were untying the colt, its owners said to them, “Why are you untying the colt?” ");
INSERT INTO engtcent_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","They said, “The Lord has need of it.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Then they brought the colt to Jesus, threw their garments over it, and set Jesus on it. ");
INSERT INTO engtcent_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","As he went along, people were spreading their garments on the road. ");
INSERT INTO engtcent_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","And as he drew near to the descent of the Mount of Olives, the whole multitude of the disciples began to praise God joyfully with a loud voice for all the miracles they had seen, ");
INSERT INTO engtcent_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","saying, “Blessed is the king who comes in the name of the Lord! Peace in heaven, and glory in the highest!” ");
INSERT INTO engtcent_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","But some of the Pharisees from among the crowd said to Jesus, “Teacher, rebuke yoʋr disciples.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","In response he said to them, “I tell you, if they keep silent, the stones will cry out.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","As he drew near to Jerusalem and saw the city, he wept over it, ");
INSERT INTO engtcent_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","saying, “If only yoʋ had known, especially on this day of yoʋrs what would bring yoʋ peace! But now it is hidden from yoʋr eyes. ");
INSERT INTO engtcent_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","For the days will come upon yoʋ when yoʋr enemies build a barricade around yoʋ and encircle yoʋ, hemming yoʋ in on every side. ");
INSERT INTO engtcent_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","They will raze yoʋ to the ground, and yoʋr children within yoʋ. They will not leave in yoʋ one stone upon another, because yoʋ did not recognize the time of yoʋr visitation.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Then Jesus entered the temple courts and began driving out those who were selling and buying there. ");
INSERT INTO engtcent_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","He said to them, “It is written, ‘My house is a house of prayer,’ but you have made it a den of robbers.” ");
INSERT INTO engtcent_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Every day Jesus was teaching in the temple courts, but the chief priests and the scribes were seeking to destroy him, and so were the prominent leaders among the people. ");
INSERT INTO engtcent_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","But they could not figure out what to do, for all the people were hanging on his every word as they listened to him. ");
INSERT INTO engtcent_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","One day, as Jesus was teaching the people in the temple courts and preaching the gospel, the priests and the scribes came with the elders ");
INSERT INTO engtcent_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","and said to him, “Tell us, by what authority are yoʋ doing these things, or who is it that gave yoʋ this authority?” ");
INSERT INTO engtcent_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","He answered them, “I will also ask you one question. Tell me: ");
INSERT INTO engtcent_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Did John's authority to baptize come from heaven or from men?” ");
INSERT INTO engtcent_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","So they discussed it among themselves, saying, “If we say, ‘From heaven,’ he will say, ‘Why did you not believe him?’ ");
INSERT INTO engtcent_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","But if we say, ‘From men,’ all the people will stone us, for they are persuaded that John was a prophet.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","So they answered that they did not know where it came from. ");
INSERT INTO engtcent_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Then Jesus said to them, “Neither will I tell you by what authority I am doing these things.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Then he began to tell the people this parable: “A man planted a vineyard, leased it to farmers, and left the country for a long time. ");
INSERT INTO engtcent_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","At harvest time he sent a servant to the farmers so that they would give him some of the fruit of the vineyard. But the farmers beat that servant and sent him away empty-handed. ");
INSERT INTO engtcent_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","So he proceeded to send another servant, but they beat him also, treated him shamefully, and sent him away empty-handed. ");
INSERT INTO engtcent_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Then he proceeded to send a third, but they wounded him as well and threw him out. ");
INSERT INTO engtcent_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","So the owner of the vineyard said, ‘What should I do? I will send my beloved son; perhaps when they see him they will have respect for him.’ ");
INSERT INTO engtcent_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","But when they saw him, the farmers discussed it among themselves, saying, ‘This is the heir. Come, let us kill him so that the inheritance will be ours.’ ");
INSERT INTO engtcent_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","So they threw him out of the vineyard and killed him. What then will the owner of the vineyard do to them? ");
INSERT INTO engtcent_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","He will come and destroy those farmers and give the vineyard to others.” When the people heard this, they said, “Certainly not!” ");
INSERT INTO engtcent_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","But Jesus looked at them and said, “What then is the meaning of this Scripture: ‘The stone the builders rejected has become the cornerstone’? ");
INSERT INTO engtcent_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Everyone who falls on that stone will be broken to pieces, but anyone on whom it falls will be crushed.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Then the chief priests and the scribes wanted to arrest him at that very hour, for they knew he had spoken this parable against them, but they were afraid. ");
INSERT INTO engtcent_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","So they watched him and sent spies who pretended to be sincere in order to catch him in something he said, so that they could deliver him up to the jurisdiction and authority of the governor. ");
INSERT INTO engtcent_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","The spies asked him, “Teacher, we know that yoʋ speak and teach correctly, and that yoʋ do not show partiality but teach the way of God in truth. ");
INSERT INTO engtcent_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Is it lawful for us to pay taxes to Caesar, or not?” ");
INSERT INTO engtcent_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","But perceiving their craftiness, Jesus said to them, “Why are you testing me? ");
INSERT INTO engtcent_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Show me a denarius. Whose image and inscription does it have?” They answered, “Caesar's.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","He said to them, “Then render to Caesar the things that are Caesar's, and to God the things that are God's.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","So they were not able to catch him in what he said in the presence of the people. And being amazed at his answer, they fell silent. ");
INSERT INTO engtcent_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Now some of the Sadducees, who deny that there is a resurrection, came up and asked Jesus, ");
INSERT INTO engtcent_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Teacher, Moses wrote for us: ‘If a man's brother dies, leaving a wife but no children, that man must marry the widow and raise up offspring for his brother.’ ");
INSERT INTO engtcent_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Now there were seven brothers. The first married a woman and died childless. ");
INSERT INTO engtcent_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","The second married the widow, and he also died childless. ");
INSERT INTO engtcent_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Likewise, the third also married her. In the same way all seven died, leaving no children. ");
INSERT INTO engtcent_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Last of all, the woman also died. ");
INSERT INTO engtcent_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","In the resurrection, therefore, which of them will she be the wife of? For the seven all had her as a wife.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus answered them, “The people of this age marry and are given in marriage, ");
INSERT INTO engtcent_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","but those who are considered worthy to attain to that age and the resurrection from the dead neither marry nor are they given in marriage. ");
INSERT INTO engtcent_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Indeed they can no longer die, for they are like angels. They are sons of God, since they are sons of the resurrection. ");
INSERT INTO engtcent_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","But even Moses indicated that the dead are raised, when he said in the passage about the burning bush, ‘The Lord, the God of Abraham, the God of Isaac, and the God of Jacob.’ ");
INSERT INTO engtcent_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","He is not the God of the dead, but of the living, for to him all are alive.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Then some of the scribes responded, “Teacher, yoʋ have spoken well.” ");
INSERT INTO engtcent_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","And they no longer dared to ask him anything. ");
INSERT INTO engtcent_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Then Jesus said to them, “How can it be said that the Christ is the Son of David? ");
INSERT INTO engtcent_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Even David himself says in the Book of Psalms, ‘The Lord said to my Lord, “Sit at my right hand ");
INSERT INTO engtcent_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","until I make yoʋr enemies a footstool for yoʋr feet.” ’ ");
INSERT INTO engtcent_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David calls him ‘Lord,’ so how is he his son?” ");
INSERT INTO engtcent_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","As all the people were listening, Jesus said to his disciples, ");
INSERT INTO engtcent_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Beware of the scribes who like to walk around in long robes and who love to be greeted in the marketplaces and to have the best seats in the synagogues and the places of honor at banquets. ");
INSERT INTO engtcent_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","They devour widows' houses and for a pretense make long prayers. They will receive a more severe judgment.” ");
INSERT INTO engtcent_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Then Jesus looked up and saw the rich putting their gifts into the treasury. ");
INSERT INTO engtcent_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","He also saw a poor widow there putting in two small copper coins. ");
INSERT INTO engtcent_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","So he said, “Truly I say to you, this poor widow has put in more than all the others. ");
INSERT INTO engtcent_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","For they have all put in gifts for God out of their abundance, but she, out of her poverty, has put in all that she had to live on.” ");
INSERT INTO engtcent_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Then, as some were talking about how the temple was adorned with beautiful stones and gifts consecrated to God, Jesus said, ");
INSERT INTO engtcent_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“As for these things that you see, the days will come when not one stone will be left upon another; all of them will be torn down.” ");
INSERT INTO engtcent_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","So they asked him, “Teacher, when will these things happen? And what will be the sign that these things are about to take place?” ");
INSERT INTO engtcent_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","He said, “Make sure you are not led astray. For many will come in my name, saying, ‘I am he,’ and, ‘The time has drawn near.’ Do not go after them. ");
INSERT INTO engtcent_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","When you hear of wars and uprisings, do not be terrified, for these things must first take place, but the end will not immediately follow.” ");
INSERT INTO engtcent_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Then he said to them, “Nation will rise up against nation, and kingdom against kingdom. ");
INSERT INTO engtcent_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","There will be great earthquakes in various places, along with famines and plagues. There will also be terrifying sights and great signs from heaven. ");
INSERT INTO engtcent_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","But before all these things take place, they will arrest you and persecute you. They will deliver you up to synagogues and prisons, and you will be brought before kings and governors for my name's sake. ");
INSERT INTO engtcent_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","This will lead to opportunities for you to bear witness. ");
INSERT INTO engtcent_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Therefore settle it in your hearts not to prepare your defense in advance. ");
INSERT INTO engtcent_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","For I will give you a mouth to speak and wisdom that none of your adversaries will be able to refute or resist. ");
INSERT INTO engtcent_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","You will even be betrayed by parents, relatives, friends, and brothers, and they will have some of you put to death. ");
INSERT INTO engtcent_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","You will be hated by all because of my name. ");
INSERT INTO engtcent_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yet not a hair of your head will by any means perish. ");
INSERT INTO engtcent_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","You must gain your lives by your patient endurance. ");
INSERT INTO engtcent_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“When you see Jerusalem surrounded by armies, know that its desolation is near. ");
INSERT INTO engtcent_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Then those who are in Judea must flee to the mountains, those who are in the city must get out, and those who are in the countryside must not enter the city. ");
INSERT INTO engtcent_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","For those will be days of vengeance, to fulfill all that is written. ");
INSERT INTO engtcent_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Woe to those who are with child and to those who are nursing infants in those days! For there will be great distress in the land and wrath against this people. ");
INSERT INTO engtcent_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","They will fall by the edge of the sword and be led captive into all the nations, and Jerusalem will be trampled by the Gentiles until the times of the Gentiles are fulfilled. ");
INSERT INTO engtcent_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“There will be signs in the sun, moon, and stars, and on the earth there will be distress among the nations as they are perplexed by the roaring sea and the surging waves. ");
INSERT INTO engtcent_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","People will faint from fear and foreboding of what is coming upon the world, for the powers of the heavens will be shaken. ");
INSERT INTO engtcent_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Then they will see the Son of Man coming in a cloud with power and great glory. ");
INSERT INTO engtcent_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","So when these things begin to take place, stand tall and lift up your heads, for your redemption is near.” ");
INSERT INTO engtcent_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Then he told them a parable: “Consider the fig tree and all the other trees. ");
INSERT INTO engtcent_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","As soon as they sprout leaves, you can see for yourselves and know that summer is near. ");
INSERT INTO engtcent_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","So also, when you see these things taking place, know that the kingdom of God is near. ");
INSERT INTO engtcent_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Truly I say to you, this generation will certainly not pass away until all things have taken place. ");
INSERT INTO engtcent_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Heaven and earth will pass away, but my words will certainly not pass away. ");
INSERT INTO engtcent_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Watch yourselves, lest your hearts be weighed down with carousing, drunkenness, and the cares of this life, and that day come upon you suddenly. ");
INSERT INTO engtcent_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","For it will come like a trap upon all who dwell on the face of the whole earth. ");
INSERT INTO engtcent_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Therefore stay alert at all times, praying that you may be considered worthy to escape everything that will take place, and to stand before the Son of Man.” ");
INSERT INTO engtcent_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Each day Jesus taught in the temple courts, but at night he would go out and stay at the mount called Olivet. ");
INSERT INTO engtcent_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","And all the people would come to him early in the morning to listen to him in the temple courts. ");
INSERT INTO engtcent_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Now the Feast of Unleavened Bread was drawing near, which is called the Passover, ");
INSERT INTO engtcent_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","and the chief priests and the scribes were looking for a way to get rid of Jesus quietly, for they were afraid of the people. ");
INSERT INTO engtcent_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Then Satan entered into Judas, the one called Iscariot, who was numbered among the twelve. ");
INSERT INTO engtcent_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","He went away and discussed with the chief priests and officers how he might deliver Jesus up to them. ");
INSERT INTO engtcent_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","They were glad and agreed to give him money. ");
INSERT INTO engtcent_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","So he accepted the offer and began looking for an opportunity to deliver Jesus up to them in the absence of a crowd. ");
INSERT INTO engtcent_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Then came the day for the Feast of Unleavened Bread, when the Passover lamb had to be sacrificed. ");
INSERT INTO engtcent_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus sent Peter and John, saying, “Go make preparations for us to eat the Passover.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","They said to him, “Where do yoʋ want us to prepare it?” ");
INSERT INTO engtcent_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","He said to them, “Behold, when you enter the city, a man carrying a jug of water will meet you. Follow him into the house he enters ");
INSERT INTO engtcent_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","and say to the master of the house, ‘The Teacher asks yoʋ, “Where is the guest room where I can eat the Passover with my disciples?” ’ ");
INSERT INTO engtcent_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","He will then show you a large upper room that is furnished; prepare it there.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","So they went and found it just as Jesus had told them, and they prepared the Passover. ");
INSERT INTO engtcent_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","When the hour came, Jesus reclined at the table, and the twelve apostles were with him. ");
INSERT INTO engtcent_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","He said to them, “I have earnestly desired to eat this Passover with you before I suffer. ");
INSERT INTO engtcent_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","For I tell you that I will certainly not eat it again until it is fulfilled in the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Then he took a cup, and after giving thanks he said, “Take this and divide it among yourselves. ");
INSERT INTO engtcent_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","For I tell you, I will certainly not drink again from the fruit of the vine until the kingdom of God comes.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Then he took bread, and when he had given thanks, he broke it and gave it to them, saying, “This is my body, which is given for you. Do this in remembrance of me.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","In the same way, he also took the cup after they had eaten supper, saying, “This cup is the new covenant in my blood, which is poured out for you. ");
INSERT INTO engtcent_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","But behold, the hand of the one who is going to betray me is with mine on the table. ");
INSERT INTO engtcent_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","The Son of Man indeed goes as it has been determined, but woe to that man by whom he is betrayed.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Then they began to discuss with one another which one of them could ever do such a thing. ");
INSERT INTO engtcent_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A dispute also arose among them as to which of them was considered to be greater. ");
INSERT INTO engtcent_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","So Jesus said to them, “The kings of the Gentiles exercise lordship over them, and those who have authority over them are called benefactors. ");
INSERT INTO engtcent_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","But it must not be so with you; rather the greatest among you must become like the youngest, and the leader must become like one who serves. ");
INSERT INTO engtcent_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","For who is greater? The one who reclines at the table or the one who serves? Is it not the one who reclines at the table? But I am among you as one who serves. ");
INSERT INTO engtcent_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“You have stayed with me in my trials. ");
INSERT INTO engtcent_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","And I bestow on you a kingdom, just as my Father bestowed one on me, ");
INSERT INTO engtcent_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","so that you may eat and drink at my table. And you will sit on thrones judging the twelve tribes of Israel.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Then the Lord said, “Simon, Simon, behold, Satan has demanded to have you, so that he might sift you like wheat. ");
INSERT INTO engtcent_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","But I have prayed for yoʋ that yoʋr faith may not fail. Once yoʋ have turned back, strengthen yoʋr brothers.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter said to him, “Lord, I am ready to go with yoʋ both to prison and to death.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus said, “I tell yoʋ, Peter, a rooster will certainly not crow today before yoʋ have denied three times that yoʋ know me.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Then Jesus said to them, “When I sent you without a moneybag, knapsack, or sandals, did you lack anything?” They said, “Nothing.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Then he said to them, “But now he who has a moneybag must take it, and likewise a knapsack. And he who does not have a sword must sell his garment and buy one. ");
INSERT INTO engtcent_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","For I tell you that this Scripture must still be fulfilled in me: ‘He was numbered with the lawless.’ For what is written about me is reaching its fulfillment.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","So they said, “Lord, behold, here are two swords.” He said to them, “That is enough!” ");
INSERT INTO engtcent_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Then Jesus went out and made his way to the Mount of Olives, as was his custom, and his disciples followed him. ");
INSERT INTO engtcent_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","When he came to the place, he said to them, “Pray that you will not enter into temptation.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Then he withdrew from them about a stone's throw away and knelt down and prayed, ");
INSERT INTO engtcent_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Father, if yoʋ are willing to take this cup away from me, do so; nevertheless, not my will, but yoʋrs be done.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Then an angel from heaven appeared to him and strengthened him. ");
INSERT INTO engtcent_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Being in agony, he prayed more earnestly, and his sweat became like drops of blood falling to the ground. ");
INSERT INTO engtcent_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","When he rose from prayer and came to the disciples, he found them sleeping because of their sorrow. ");
INSERT INTO engtcent_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","So he said to them, “Why are you sleeping? Rise and pray, lest you enter into temptation.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","While he was still speaking, behold, a crowd approached, and the man called Judas, one of the twelve, was leading them. He drew near to Jesus to kiss him, ");
INSERT INTO engtcent_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","and Jesus said to him, “Judas, are you betraying the Son of Man with a kiss?” ");
INSERT INTO engtcent_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","When those who were around him saw what was about to happen, they said to him, “Lord, shall we strike with the sword?” ");
INSERT INTO engtcent_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Then one of them struck the servant of the high priest, cutting off his right ear. ");
INSERT INTO engtcent_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","But Jesus responded, “No more of this!” And he touched the man's ear and healed him. ");
INSERT INTO engtcent_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Then Jesus said to the chief priests, the officers of the temple, and the elders who had come out against him, “Have you come out with swords and clubs as you would against a robber? ");
INSERT INTO engtcent_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","I was with you daily in the temple courts, and you did not lay a hand on me. But this is your hour, when the power of darkness reigns.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Then they arrested him, led him away, and brought him to the house of the high priest, and Peter was following at a distance. ");
INSERT INTO engtcent_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Some had kindled a fire there in the middle of the courtyard and sat down together, and Peter sat down among them. ");
INSERT INTO engtcent_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","When a servant girl saw him sitting in the light of the fire, she looked at him intently and said, “This man also was with him.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","But Peter denied him, saying, “Woman, I do not know him.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","After a little while, someone else saw him and said, “Yoʋ also are one of them.” But Peter said, “Man, I am not.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","After about an hour had gone by, another man kept insisting, “Truly this man also was with him, for he too is a Galilean.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","But Peter said, “Man, I do not know what yoʋ are talking about!” And immediately, while he was still speaking, a rooster crowed. ");
INSERT INTO engtcent_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Then the Lord turned and looked at Peter, and Peter remembered what the Lord had said to him, “Before a rooster crows, yoʋ will deny me three times.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","And Peter went out and wept bitterly. ");
INSERT INTO engtcent_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Now the men who were holding Jesus in custody began mocking him and beating him. ");
INSERT INTO engtcent_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","They also blindfolded him and kept striking his face, saying to him, “Prophesy! Who is it that struck yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","And they said many other things against him, reviling him. ");
INSERT INTO engtcent_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","When daybreak came, the elders of the people gathered together, both chief priests and scribes, and they led Jesus up to their Sanhedrin and said, ");
INSERT INTO engtcent_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“If yoʋ are the Christ, tell us.” But he said to them, “If I tell you, you will surely not believe. ");
INSERT INTO engtcent_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","And if I ask you a question, you will surely not answer me or release me. ");
INSERT INTO engtcent_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","But from now on the Son of Man will be seated at the right hand of the power of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","So they all said, “Are yoʋ then the Son of God?” He said to them, “You yourselves say that I am.” ");
INSERT INTO engtcent_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Then they said, “What further testimony do we need? For we ourselves have heard it from his own mouth.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Then the whole assembly arose and led Jesus to Pilate. ");
INSERT INTO engtcent_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","They began to accuse him, saying, “We found this man perverting the nation and forbidding us to pay taxes to Caesar, declaring himself to be Christ, a king.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","So Pilate asked Jesus, “Are yoʋ the king of the Jews?” Jesus answered him, “Yoʋ have said it yoʋrself.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Then Pilate said to the chief priests and the crowd, “I find no fault in this man.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","But they kept insisting, “He stirs up the people, teaching throughout all Judea. He started in Galilee and has come all the way here.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","When Pilate heard mention of Galilee, he asked whether the man was a Galilean. ");
INSERT INTO engtcent_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","And when he found out that Jesus was under Herod's jurisdiction, he sent him over to Herod, who was also in Jerusalem in those days. ");
INSERT INTO engtcent_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","When Herod saw Jesus he was very glad, for he had long desired to see him, because he had heard many things about him and was hoping to see him perform some sign. ");
INSERT INTO engtcent_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","So he questioned him at great length, but Jesus gave him no answer. ");
INSERT INTO engtcent_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Meanwhile, the chief priests and the scribes stood there, vehemently accusing him. ");
INSERT INTO engtcent_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod also treated him with contempt and mocked him, as did his soldiers. Then, after dressing Jesus in fine clothing, Herod sent him back to Pilate. ");
INSERT INTO engtcent_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","That very day Pilate and Herod became friends with one another; previously they had been enemies. ");
INSERT INTO engtcent_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Then Pilate called together the chief priests, the rulers, and the people, ");
INSERT INTO engtcent_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","and said to them, “You brought me this man as one who was misleading the people. And behold, after examining him before you, I have found no fault in this man with respect to the accusations you are making against him, ");
INSERT INTO engtcent_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","and neither has Herod, for I sent you to him. Clearly he has done nothing that deserves death. ");
INSERT INTO engtcent_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Therefore I will have him flogged and then release him.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Now each year at the feast Pilate was obligated to release one prisoner for the people. ");
INSERT INTO engtcent_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","So they all cried out together, “Away with this man, and release for us Barabbas!” ");
INSERT INTO engtcent_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(This was a man who had been thrown into prison for an insurrection that had taken place in the city, and for murder.) ");
INSERT INTO engtcent_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wishing to release Jesus, Pilate addressed them again, ");
INSERT INTO engtcent_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","but they kept on shouting, “Crucify, crucify him!” ");
INSERT INTO engtcent_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A third time he said to them, “Why? What evil has he done? I have found in him no grounds for death. So I will have him flogged and then release him.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","But they continued insistently with loud voices, demanding that he be crucified, and their voices prevailed, along with those of the chief priests. ");
INSERT INTO engtcent_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","So Pilate rendered his decision that their demand be granted. ");
INSERT INTO engtcent_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","He released the man they had been asking for, who had been thrown into prison for insurrection and murder, but he handed Jesus over to their will. ");
INSERT INTO engtcent_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","As the soldiers led him away, they took hold of Simon, a Cyrenian man who was coming in from the countryside, and they laid on him the cross, forcing him to carry it behind Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A great multitude of people followed along behind, including women who were mourning and lamenting for Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","But Jesus turned to them and said, “Daughters of Jerusalem, do not weep for me, but weep for yourselves and for your children. ");
INSERT INTO engtcent_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","For behold, the days are coming when people will say, ‘Blessed are the barren, the wombs that have not given birth, and the breasts that have not nursed!’ ");
INSERT INTO engtcent_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Then they will begin to say to the mountains, ‘Fall on us!’ and to the hills, ‘Cover us!’ ");
INSERT INTO engtcent_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","For if they do these things when the wood is green, what will happen when it is dry?” ");
INSERT INTO engtcent_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Now two others, who were criminals, were also being led away to be put to death with Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","When they came to the place called the Skull, the soldiers crucified him there along with the criminals, one on his right and one on his left. ");
INSERT INTO engtcent_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","But Jesus said, “Father, forgive them, for they do not know what they are doing.” Then they cast lots to divide his garments. ");
INSERT INTO engtcent_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","The people stood there looking on, and the rulers who were with them ridiculed him, saying, “He saved others; let him save himself if he is the Christ, the Chosen One of God.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","The soldiers also mocked him, coming up to him and offering him sour wine, ");
INSERT INTO engtcent_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","saying, “If yoʋ are the king of the Jews, save yoʋrself!” ");
INSERT INTO engtcent_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","There was also an inscription over him written in Greek, Latin, and Hebrew, which read: “This is the King of the Jews.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","One of the criminals who was hanging there reviled him, saying, “If yoʋ are the Christ, save yoʋrself and us!” ");
INSERT INTO engtcent_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","But the other rebuked him, saying, “Do yoʋ not even fear God, seeing that yoʋ are under the same condemnation? ");
INSERT INTO engtcent_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","The two of us are justly condemned, for we are receiving the appropriate punishment for the things we have done, but this man has done nothing wrong.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Then he said to Jesus, “Remember me, Lord, when yoʋ come in yoʋr kingdom.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus said to him, “Truly I say to yoʋ, today yoʋ will be with me in Paradise.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Now it was about the sixth hour, and there was darkness over the whole land until the ninth hour. ");
INSERT INTO engtcent_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","The sun was darkened, and the veil of the temple was torn down the middle. ");
INSERT INTO engtcent_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Then Jesus cried out with a loud voice, “Father, into yoʋr hands I commit my spirit.” After saying this, he breathed his last breath. ");
INSERT INTO engtcent_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Now when the centurion saw what had happened, he glorified God and said, “Surely this man was righteous.” ");
INSERT INTO engtcent_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","And when all the crowds who had gathered together for this spectacle saw what had happened, they returned home beating their breasts. ");
INSERT INTO engtcent_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","But all those who knew Jesus stood at a distance watching these things, including the women who had followed him from Galilee. ");
INSERT INTO engtcent_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Now there was a good and righteous man named Joseph, who was a member of the council ");
INSERT INTO engtcent_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","but had not consented to their decision and action. He was from Arimathea, a town of the Jews, and was himself also waiting for the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","He went to Pilate and asked for Jesus' body. ");
INSERT INTO engtcent_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Then he took it down, wrapped it in a linen cloth, and laid it in a tomb hewn in a rock, where no one had ever been laid. ");
INSERT INTO engtcent_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","It was the day of Preparation, and the Sabbath was approaching. ");
INSERT INTO engtcent_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","The women who had come with Jesus from Galilee followed along behind and saw the tomb and how his body was laid in it. ");
INSERT INTO engtcent_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Then they returned and prepared spices and ointments. But they rested on the Sabbath according to the commandment. ");
INSERT INTO engtcent_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","On the first day of the week, at early dawn, the women came to the tomb, bringing the spices they had prepared, and some other women were with them. ");
INSERT INTO engtcent_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","They found the stone rolled away from the tomb, ");
INSERT INTO engtcent_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","but when they went in, they did not find the body of the Lord Jesus. ");
INSERT INTO engtcent_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","While they were greatly perplexed about this, behold, two men stood by them in dazzling clothes. ");
INSERT INTO engtcent_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","The women were terrified and bowed their faces to the ground, but the men said to them, “Why do you seek the living among the dead? ");
INSERT INTO engtcent_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","He is not here, but is risen. Remember how he told you, while he was still in Galilee, ");
INSERT INTO engtcent_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","that the Son of Man must be delivered up into the hands of sinful men, be crucified, and on the third day rise again.” ");
INSERT INTO engtcent_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Then they remembered his words. ");
INSERT INTO engtcent_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","When they returned from the tomb, they told all these things to the eleven and to all the others. ");
INSERT INTO engtcent_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","It was Mary Magdalene, Joanna, Mary the mother of James, and the other women with them, who told these things to the apostles. ");
INSERT INTO engtcent_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","But their words came across to the apostles as nonsense, and they did not believe them. ");
INSERT INTO engtcent_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peter, however, got up and ran to the tomb. When he stooped down to look in, he saw the linen cloths lying there by themselves. So he went away, wondering to himself what had happened. ");
INSERT INTO engtcent_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","That same day two of Jesus' disciples were going to a village called Emmaus, which was about seven miles from Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","They were talking with each other about everything that had happened. ");
INSERT INTO engtcent_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","As they were talking and discussing these things, Jesus himself drew near and went along with them, ");
INSERT INTO engtcent_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","but their eyes were kept from recognizing him. ");
INSERT INTO engtcent_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","He said to them, “What are you discussing with each other as you walk along, looking downcast?” ");
INSERT INTO engtcent_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Then the one whose name was Cleopas answered him, “Are yoʋ the only visitor in Jerusalem who does not know the things that have happened there in these last few days?” ");
INSERT INTO engtcent_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","He said to them, “What things?” So they said to him, “The things concerning Jesus of Nazareth, who was a prophet mighty in deed and word before God and all the people, ");
INSERT INTO engtcent_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","and how the chief priests and our rulers handed him over to a sentence of death and crucified him. ");
INSERT INTO engtcent_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","But we had hoped that he was the one who would redeem Israel. And besides all this, today is now the third day since these things happened. ");
INSERT INTO engtcent_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Moreover, some women from our group amazed us. They were at the tomb early this morning, ");
INSERT INTO engtcent_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","and when they did not find his body, they came back saying that they had seen a vision of angels, who said that he was alive. ");
INSERT INTO engtcent_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Then some of our companions went to the tomb and found it to be so, just as the women had said, but they did not see him.” ");
INSERT INTO engtcent_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Then Jesus said to them, “O foolish men, how slow of heart you are to believe all that the prophets have spoken! ");
INSERT INTO engtcent_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Was it not necessary for the Christ to suffer these things and enter into his glory?” ");
INSERT INTO engtcent_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","And beginning from Moses and all the Prophets, he explained to them the things written about himself in all the Scriptures. ");
INSERT INTO engtcent_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","As they drew near to the village where they were headed, Jesus acted as if he were going farther. ");
INSERT INTO engtcent_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","But they urged him not to do so, saying, “Stay with us, for it is nearly evening, and the day is drawing to a close.” So he went in to stay with them. ");
INSERT INTO engtcent_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","As he was reclining at the table with them, he took the bread, blessed and broke it, and gave it to them. ");
INSERT INTO engtcent_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Then their eyes were opened, and they recognized him, but he disappeared from their sight. ");
INSERT INTO engtcent_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","They said to each other, “Were not our hearts burning within us as he spoke to us on the road and explained the Scriptures to us?” ");
INSERT INTO engtcent_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","So they rose that very hour and returned to Jerusalem, where they found the eleven gathered together with their companions, ");
INSERT INTO engtcent_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","saying, “The Lord is risen indeed and has appeared to Simon!” ");
INSERT INTO engtcent_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Then they began describing what had happened on the road, and how Jesus had been made known to them when he broke the bread. ");
INSERT INTO engtcent_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","As they were saying these things, Jesus himself stood among them and said to them, “Peace be with you.” ");
INSERT INTO engtcent_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","But they were startled and terrified, thinking they had seen a spirit. ");
INSERT INTO engtcent_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Then he said to them, “Why are you troubled, and why are doubts arising in your hearts? ");
INSERT INTO engtcent_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Look at my hands and my feet and see that it is I myself. Touch me and look at me, for a spirit does not have flesh and bones as you see that I have.” ");
INSERT INTO engtcent_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","After saying this, he showed them his hands and his feet. ");
INSERT INTO engtcent_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","And while they were still amazed and in disbelief because of their joy, he said to them, “Do you have anything here to eat?” ");
INSERT INTO engtcent_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","So they gave him a piece of broiled fish and some honeycomb. ");
INSERT INTO engtcent_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","And he took them and ate in their presence. ");
INSERT INTO engtcent_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Then he said to them, “These are the words I spoke to you while I was still with you, that everything written about me in the Law of Moses, the Prophets, and the Psalms must be fulfilled.” ");
INSERT INTO engtcent_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Then he opened their minds to understand the Scriptures ");
INSERT INTO engtcent_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","and said to them, “Thus it is written, and thus it was necessary for the Christ to suffer and to rise from the dead on the third day, ");
INSERT INTO engtcent_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","and for repentance and remission of sins to be preached in his name to all nations, beginning from Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","You are witnesses of these things. ");
INSERT INTO engtcent_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","And behold, I am sending the promise of my Father upon you, but stay in the city of Jerusalem until you are clothed with power from on high.” ");
INSERT INTO engtcent_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Then he led them out as far as Bethany, and lifting up his hands he blessed them. ");
INSERT INTO engtcent_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","While he was blessing them, he parted from them and was carried up into heaven. ");
INSERT INTO engtcent_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","So they worshiped him and returned to Jerusalem with great joy. ");
INSERT INTO engtcent_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","And they were continually in the temple courts, praising and blessing God. Amen. ");
INSERT INTO engtcent_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","In the beginning was the Word, and the Word was with God, and the Word was God. ");
INSERT INTO engtcent_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","He was in the beginning with God. ");
INSERT INTO engtcent_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","All things were made through him, and nothing that was made was made without him. ");
INSERT INTO engtcent_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","In him was life, and the life was the light of men. ");
INSERT INTO engtcent_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","The light shines in the darkness, and the darkness has not overcome it. ");
INSERT INTO engtcent_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","There came a man sent from God, whose name was John. ");
INSERT INTO engtcent_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","He came as a witness to testify about the light, so that all might believe through him. ");
INSERT INTO engtcent_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","He himself was not the light, but he came to testify about the light. ");
INSERT INTO engtcent_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","The true light, which gives light to everyone, was coming into the world. ");
INSERT INTO engtcent_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","He was in the world, and the world was made through him, but the world did not know him. ");
INSERT INTO engtcent_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","He came to his own, but his own people did not receive him. ");
INSERT INTO engtcent_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","But to all who did receive him, who believed in his name, he gave the right to become children of God, ");
INSERT INTO engtcent_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","who were born not of blood, nor of the will of the flesh, nor of the will of man, but of God. ");
INSERT INTO engtcent_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","The Word became flesh and dwelt among us, and we have seen his glory, the glory of the one and only Son, who came from the Father, full of grace and truth. ");
INSERT INTO engtcent_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John testified about him and cried out, “This is he of whom I said, ‘He who comes after me ranks ahead of me, because he existed before me.’ ” ");
INSERT INTO engtcent_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Of his fullness we have all received, even grace upon grace. ");
INSERT INTO engtcent_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","For the law was given through Moses, but grace and truth came through Jesus Christ. ");
INSERT INTO engtcent_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","No one has ever seen God, but the one and only Son, who is at the Father's side, has made him known. ");
INSERT INTO engtcent_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","This was the testimony of John when the Jews sent priests and Levites from Jerusalem to ask him, “Who are yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","He did not refuse to answer, but openly declared, “I am not the Christ.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","So they asked him, “What then? Are yoʋ Elijah?” He said, “I am not.” “Are yoʋ the Prophet?” He answered, “No.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","So they said to him, “Who are yoʋ? Tell us so that we may give an answer to those who sent us. What do yoʋ say about yoʋrself?” ");
INSERT INTO engtcent_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","He said, “I am the voice of one crying out in the wilderness, ‘Make straight the way for the Lord,’ as the prophet Isaiah said.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","(Now those who had been sent were from the Pharisees.) ");
INSERT INTO engtcent_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Then they asked him, “Why then do yoʋ baptize if yoʋ are not the Christ, nor Elijah, nor the Prophet?” ");
INSERT INTO engtcent_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John answered them, “I baptize with water, but among you stands someone you do not know. ");
INSERT INTO engtcent_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","He is the one who comes after me, who ranks ahead of me, the strap of whose sandals I am not worthy to untie.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","These things took place in Bethany beyond the Jordan, where John was baptizing. ");
INSERT INTO engtcent_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","On the next day John saw Jesus coming to him and said, “Behold, the Lamb of God, who takes away the sin of the world! ");
INSERT INTO engtcent_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","This is he of whom I said, ‘After me comes a man who ranks ahead of me, because he existed before me.’ ");
INSERT INTO engtcent_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I myself did not know him, but I came baptizing with water so that he might be revealed to Israel.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Then John testified, “I saw the Spirit descending from heaven like a dove, and it remained upon him. ");
INSERT INTO engtcent_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","I myself did not recognize him, but he who sent me to baptize with water said to me, ‘He upon whom yoʋ see the Spirit descend and remain is the one who baptizes with the Holy Spirit.’ ");
INSERT INTO engtcent_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","And I have seen it and can testify that this is the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","On the next day John was again standing with two of his disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","As Jesus walked by, John looked at him and said, “Behold, the Lamb of God.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","When the two disciples heard him say this, they followed Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Turning around, Jesus saw them following him and said to them, “What are you seeking?” They said to him, “Rabbi” (which means “Teacher”), “where are yoʋ staying?” ");
INSERT INTO engtcent_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","He said to them, “Come and see.” So they went and saw where he was staying, and stayed with him that day; it was about the tenth hour. ");
INSERT INTO engtcent_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrew, the brother of Simon Peter, was one of the two who heard this from John and followed Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew first found his own brother Simon and said to him, “We have found the Messiah” (which means “Christ”), ");
INSERT INTO engtcent_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","and he brought Simon to Jesus. Jesus looked at him and said, “Yoʋ are Simon the son of Jonah; yoʋ shall be called Cephas” (which means “Peter”). ");
INSERT INTO engtcent_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","On the next day Jesus decided to go to Galilee. Finding Philip, he said to him, “Follow me.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Now Philip was from Bethsaida, the city of Andrew and Peter.) ");
INSERT INTO engtcent_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip then found Nathanael and said to him, “We have found him of whom Moses wrote in the law, and of whom the prophets also wrote—Jesus of Nazareth, the son of Joseph.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael said to him, “Can anything good come from Nazareth?” Philip said to him, “Come and see.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","When Jesus saw Nathanael coming toward him, he said of him, “Behold, an Israelite indeed, in whom there is no deceit.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael said to him, “How do yoʋ know me?” Jesus answered him, “Before Philip called yoʋ, when yoʋ were under the fig tree, I saw yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael answered him, “Rabbi, yoʋ are the Son of God! Yoʋ are the king of Israel!” ");
INSERT INTO engtcent_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus answered him, “Do yoʋ believe because I said to yoʋ, ‘I saw yoʋ under the fig tree’? Yoʋ will see greater things than these.” ");
INSERT INTO engtcent_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Then he said to him, “Truly, truly, I say to you, before long you will see heaven opened and the angels of God ascending and descending on the Son of Man.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","On the third day there was a wedding in Cana of Galilee, and Jesus' mother was there. ");
INSERT INTO engtcent_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus was also invited to the wedding, and so were his disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","When the wine ran out, Jesus' mother said to him, “They have no wine.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus said to her, “Woman, what concern is that to yoʋ or to me? My hour has not yet come.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","But his mother said to the servants, “Do whatever he tells you.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Now six stone water jars had been set there for the Jewish rites of purification, each holding twenty to thirty gallons. ");
INSERT INTO engtcent_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus said to the servants, “Fill the jars with water.” So they filled them up to the brim. ");
INSERT INTO engtcent_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Then he said to them, “Now draw some out and take it to the master of the feast.” So they took it, ");
INSERT INTO engtcent_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","and the master of the feast tasted the water, which had been turned into wine. He did not know where it had come from, but the servants who had drawn the water knew. Then the master of the feast called the bridegroom aside ");
INSERT INTO engtcent_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","and said to him, “Everyone else serves the good wine first, and then the inferior wine after the guests have drunk freely; but yoʋ have kept the good wine until now.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus did this in Cana of Galilee as the first of his signs. He revealed his glory, and his disciples believed in him. ");
INSERT INTO engtcent_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","After this he went down to Capernaum with his mother, his brothers, and his disciples, and they stayed there for a few days. ");
INSERT INTO engtcent_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Now the Passover of the Jews was near, so Jesus went up to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","In the temple courts he found those who were selling oxen, sheep, and doves, and he also found the money changers sitting at their tables. ");
INSERT INTO engtcent_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","So he made a whip of cords and drove them all out of the temple courts, along with their sheep and oxen. He also poured out the coins of the money changers and overturned their tables. ");
INSERT INTO engtcent_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Then he said to those who were selling doves, “Take these things away from here; stop making my Father's house a marketplace.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","And his disciples remembered that it is written, “Zeal for yoʋr house will consume me.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","In response the Jews said to him, “What sign can yoʋ show us to prove yoʋr authority to do these things?” ");
INSERT INTO engtcent_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus answered them, “Destroy this temple, and in three days I will raise it up.” ");
INSERT INTO engtcent_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","The Jews said, “It has taken forty-six years to build this temple, and will yoʋ raise it up in three days?” ");
INSERT INTO engtcent_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","But he was speaking about the temple of his body. ");
INSERT INTO engtcent_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","So when he was raised from the dead, his disciples remembered that he had said this, and they believed the Scripture and the word that Jesus had spoken. ");
INSERT INTO engtcent_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","While Jesus was in Jerusalem during the feast of the Passover, many believed in his name because they saw the signs he was doing. ");
INSERT INTO engtcent_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","But Jesus did not entrust himself to them, for he knew all men. ");
INSERT INTO engtcent_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","He did not need anyone to testify about man, for he himself knew what was in man. ");
INSERT INTO engtcent_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Now there was a Pharisee named Nicodemus, who was a ruler of the Jews. ");
INSERT INTO engtcent_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","He came to Jesus by night and said to him, “Rabbi, we know that yoʋ are a teacher who has come from God, for no one can do these signs yoʋ are doing unless God is with him.” ");
INSERT INTO engtcent_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus answered him, “Truly, truly, I say to yoʋ, unless someone is born again, he cannot see the kingdom of God.” ");
INSERT INTO engtcent_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus said to him, “How can a person be born when he is old? Can he enter the womb of his mother a second time and be born?” ");
INSERT INTO engtcent_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus answered, “Truly, truly, I say to yoʋ, unless one is born of water and the Spirit, he cannot enter the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","That which is born of the flesh is flesh, and that which is born of the Spirit is spirit. ");
INSERT INTO engtcent_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Do not be amazed that I said to yoʋ, ‘You must be born again.’ ");
INSERT INTO engtcent_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","The wind blows where it wishes. Yoʋ hear the sound of it, but yoʋ do not know where it is coming from or where it is going; so it is with everyone born of the Spirit.” ");
INSERT INTO engtcent_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","In response Nicodemus said to him, “How can these things be?” ");
INSERT INTO engtcent_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus answered him, “Yoʋ are the teacher of Israel, and yoʋ do not understand these things? ");
INSERT INTO engtcent_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Truly, truly, I say to yoʋ, we speak of what we know, and we testify about what we have seen, but you do not receive our testimony. ");
INSERT INTO engtcent_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","If I have spoken to you about earthly things and you do not believe, how will you believe if I speak to you about heavenly things? ");
INSERT INTO engtcent_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","No one has ascended into heaven, except he who descended from heaven, the Son of Man, who is in heaven. ");
INSERT INTO engtcent_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Just as Moses lifted up the serpent in the wilderness, so must the Son of Man be lifted up, ");
INSERT INTO engtcent_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","so that everyone who believes in him should not perish but have eternal life. ");
INSERT INTO engtcent_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“For God loved the world in this way: He gave his one and only Son, so that whoever believes in him should not perish but have eternal life. ");
INSERT INTO engtcent_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","For God did not send his Son into the world to condemn the world, but so that the world might be saved through him. ");
INSERT INTO engtcent_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Whoever believes in him is not condemned, but whoever does not believe has been condemned already, because he has not believed in the name of the one and only Son of God. ");
INSERT INTO engtcent_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","This is the judgment: The light has come into the world, but people loved the darkness rather than the light because their works were evil. ");
INSERT INTO engtcent_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","For whoever does evil hates the light and does not come to the light, so that his works may not be exposed. ");
INSERT INTO engtcent_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","But whoever lives by the truth comes to the light, so that it may be evident that his works have been done in obedience to God.” ");
INSERT INTO engtcent_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","After this Jesus went into the Judean countryside along with his disciples, and he spent some time there with them, baptizing people. ");
INSERT INTO engtcent_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Now John was also baptizing people in Aenon near Salem, because there was plenty of water there, and people were coming to him and being baptized. ");
INSERT INTO engtcent_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(For John had not yet been thrown into prison.) ");
INSERT INTO engtcent_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Now a discussion arose between the disciples of John and a Jew about purification. ");
INSERT INTO engtcent_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","So John's disciples came and said to him, “Rabbi, he who was with yoʋ beyond the Jordan, about whom yoʋ have testified, behold, he is baptizing people, and everyone is going to him.” ");
INSERT INTO engtcent_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John replied, “A person cannot receive anything unless it is given to him from heaven. ");
INSERT INTO engtcent_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","You yourselves can testify that I said, ‘I am not the Christ,’ but rather, ‘I have been sent ahead of him.’ ");
INSERT INTO engtcent_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","He who has the bride is the bridegroom. But the friend of the bridegroom, who stands and listens for him, rejoices greatly at the bridegroom's voice. So this joy of mine has been made full. ");
INSERT INTO engtcent_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","He must increase, but I must decrease.” ");
INSERT INTO engtcent_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","He who comes from above is above all. He who is from the earth belongs to the earth and speaks about earthly things. But he who comes from heaven is above all. ");
INSERT INTO engtcent_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","He testifies to what he has seen and heard, yet no one receives his testimony. ");
INSERT INTO engtcent_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Whoever does receive his testimony has certified that God is true. ");
INSERT INTO engtcent_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","For he whom God sent speaks the words of God, for God gives the Spirit without measure. ");
INSERT INTO engtcent_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","The Father loves the Son and has put all things in his hand. ");
INSERT INTO engtcent_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Whoever believes in the Son has eternal life, but whoever disobeys the Son will not see life; rather, the wrath of God remains upon him. ");
INSERT INTO engtcent_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Now when the Lord learned that the Pharisees heard he was making and baptizing more disciples than John ");
INSERT INTO engtcent_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(although it was not Jesus himself who baptized them, but his disciples), ");
INSERT INTO engtcent_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","he left Judea and went away to Galilee. ");
INSERT INTO engtcent_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","But he had to pass through Samaria. ");
INSERT INTO engtcent_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","So he came to a town of Samaria called Sychar, near the plot of land that Jacob had given to his son Joseph. ");
INSERT INTO engtcent_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob's well was there, so Jesus, wearied as he was from the journey, sat by the well. It was about the sixth hour. ");
INSERT INTO engtcent_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","When a woman from Samaria came to draw water, Jesus said to her, “Give me some water to drink.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(For his disciples had gone into the city to buy food.) ");
INSERT INTO engtcent_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","So the Samaritan woman said to him, “How is it that yoʋ, a Jew, ask for water to drink from me, a Samaritan woman?” (For Jews have no dealings with Samaritans.) ");
INSERT INTO engtcent_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus answered her, “If yoʋ knew the gift of God and who it is that is saying to yoʋ, ‘Give me some water to drink,’ yoʋ would have asked him, and he would have given yoʋ living water.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","The woman said to him, “Sir, yoʋ do not even have a bucket to draw with, and the well is deep. Where then can yoʋ get this living water? ");
INSERT INTO engtcent_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Are yoʋ greater than our father Jacob, who gave us this well and drank from it himself, as did his sons and livestock?” ");
INSERT INTO engtcent_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus answered her, “Everyone who drinks this water will thirst again, ");
INSERT INTO engtcent_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","but whoever drinks the water I give him will certainly never thirst again. On the contrary, the water I give him will become in him a spring of water welling up to eternal life.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","The woman said to him, “Sir, give me this water so that I will not get thirsty again and have to come here to draw water.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus said to her, “Go call yoʋr husband and come back here.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","The woman said in response, “I have no husband.” Jesus said to her, “Yoʋ have rightly said, ‘I have no husband,’ ");
INSERT INTO engtcent_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","for yoʋ have had five husbands, and the man yoʋ now have is not yoʋr husband; what yoʋ have said is true.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","The woman said to him, “Sir, I see that yoʋ are a prophet. ");
INSERT INTO engtcent_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Our fathers worshiped on this mountain, but you say that the place where people must worship is in Jerusalem.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus said to her, “Woman, believe me, an hour is coming when neither on this mountain nor in Jerusalem will you worship the Father. ");
INSERT INTO engtcent_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","You worship what you do not know; we worship what we know, because salvation is from the Jews. ");
INSERT INTO engtcent_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","But an hour is coming, and is now here, when the true worshipers will worship the Father in spirit and truth, for the Father seeks such people to worship him. ");
INSERT INTO engtcent_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God is spirit, and those who worship him must worship in spirit and truth.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","The woman said to him, “I know that Messiah is coming” (who is called Christ). “When he comes, he will explain everything to us.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus said to her, “I who speak to yoʋ am he.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Just then his disciples came back, and they were amazed that he was speaking with a woman. However, no one said, “What do yoʋ want?” or, “Why are yoʋ speaking with her?” ");
INSERT INTO engtcent_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Then the woman left her water jar, went into the town, and said to the people, ");
INSERT INTO engtcent_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Come see a man who told me everything I have ever done. Could this be the Christ?” ");
INSERT INTO engtcent_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","So they left the town and began coming to him. ");
INSERT INTO engtcent_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","In the meantime the disciples were urging him, “Rabbi, eat.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","But he said to them, “I have food to eat that you do not know about.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","So the disciples said to one another, “Could someone have brought him something to eat?” ");
INSERT INTO engtcent_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus said to them, “My food is to do the will of him who sent me and to complete his work. ");
INSERT INTO engtcent_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Do you not say, ‘There are still four months and then comes the harvest’? I tell you, lift up your eyes and see that the fields are already ripe for harvest. ");
INSERT INTO engtcent_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","He who reaps receives wages and gathers fruit for eternal life, so that both he who sows and he who reaps may rejoice together. ");
INSERT INTO engtcent_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","For in this the true saying is verified: ‘One sows and another reaps.’ ");
INSERT INTO engtcent_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I sent you to reap what you have not labored for; others have labored, and you have entered into their labor.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Many of the Samaritans from that town believed in Jesus because of the woman's testimony: “He told me everything I have ever done.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","So when the Samaritans came to him, they asked him to stay with them, and he stayed there for two days. ");
INSERT INTO engtcent_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","And many more believed because of his word. ");
INSERT INTO engtcent_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","So they said to the woman, “It is no longer because of yoʋr report that we believe, for we ourselves have heard, and we know that this is truly the Christ, the Savior of the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","After two days, he departed from there and went to Galilee. ");
INSERT INTO engtcent_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(For Jesus himself had testified that a prophet has no honor in his own hometown.) ");
INSERT INTO engtcent_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","When he came to Galilee, the Galileans received him because they had seen all that he had done in Jerusalem at the feast, for they also had gone to the feast. ");
INSERT INTO engtcent_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Once more Jesus went to Cana of Galilee, where he had turned the water into wine. Now there was a certain royal official whose son was sick in Capernaum. ");
INSERT INTO engtcent_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","When he heard that Jesus had come from Judea to Galilee, he went to him and asked him to come down and heal his son, for his son was about to die. ");
INSERT INTO engtcent_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Then Jesus said to him, “Unless you see signs and wonders, you will certainly not believe.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","The royal official said to him, “Sir, come down before my boy dies.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus said to him, “Go; yoʋr son will live.” And the man believed what Jesus said to him and went on his way. ");
INSERT INTO engtcent_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","As he was going back down to his house, his servants met him and told him, “Yoʋr son is alive.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","So he asked them the hour when he began to get better. They said to him, “Yesterday at the seventh hour the fever left him.” ");
INSERT INTO engtcent_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Then the father realized that this was the hour when Jesus had said to him, “Yoʋr son will live.” So he believed, along with his entire household. ");
INSERT INTO engtcent_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","This was the second sign that Jesus did after coming from Judea to Galilee. ");
INSERT INTO engtcent_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","After this came the feast of the Jews, so Jesus went up to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Now in Jerusalem by the Sheep Gate there is a pool, called Bethesda in Hebrew, which has five porticoes. ");
INSERT INTO engtcent_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","In the porticoes were lying a great multitude of disabled people, including the blind, the lame, and the paralyzed, who were waiting for the moving of the water. ");
INSERT INTO engtcent_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","For at times an angel would go down into the pool and stir up the water. The first person who stepped in after the water was stirred up was healed of whatever disease he had. ");
INSERT INTO engtcent_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","One man was there who had been suffering in his disability for thirty-eight years. ");
INSERT INTO engtcent_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","When Jesus saw him lying there, knowing that he had been in that condition for a long time already, he said to him, “Do yoʋ want to be made well?” ");
INSERT INTO engtcent_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","The disabled man answered him, “Sir, I have no one to put me into the pool when the water is stirred up, but while I am going, another goes down before me.” ");
INSERT INTO engtcent_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus said to him, “Rise, pick up yoʋr mat, and walk.” ");
INSERT INTO engtcent_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Immediately the man was made well, so he picked up his mat and began to walk. Now that day was a Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","So the Jews said to the man who had been healed, “It is the Sabbath; it is not lawful for yoʋ to pick up yoʋr mat.” ");
INSERT INTO engtcent_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","He answered them, “The man who made me well said to me, ‘Pick up yoʋr mat and walk.’ ” ");
INSERT INTO engtcent_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","So they asked him, “Who is the man who said to yoʋ, ‘Pick up yoʋr mat and walk’?” ");
INSERT INTO engtcent_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","But the man who had been healed did not know who it was, for Jesus had slipped away, since there was a crowd in that place. ");
INSERT INTO engtcent_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","After this Jesus found the man in the temple courts and said to him, “Behold, yoʋ have been made well; do not sin anymore, lest something worse happen to yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Then the man went and told the Jews that it was Jesus who had made him well. ");
INSERT INTO engtcent_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","So the Jews began persecuting Jesus and seeking to kill him, because he was doing these things on the Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","But Jesus responded to them, “My Father is still working even now, and I too am working.” ");
INSERT INTO engtcent_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","So the Jews were seeking all the more to kill him, because not only was he breaking the Sabbath, but he was even calling God his own Father, making himself equal with God. ");
INSERT INTO engtcent_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","So Jesus responded to them, “Truly, truly, I say to you, the Son can do nothing on his own, but only what he sees the Father doing. For whatever the Father does, the Son also does in the same way. ");
INSERT INTO engtcent_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","For the Father loves the Son and shows him all that he himself does. And he will show him greater works than these, so that you will be amazed. ");
INSERT INTO engtcent_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","For just as the Father raises the dead and gives them life, so also the Son gives life to whomever he wishes. ");
INSERT INTO engtcent_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","The Father judges no one, but has given all judgment to the Son, ");
INSERT INTO engtcent_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","so that all may honor the Son just as they honor the Father. Anyone who does not honor the Son does not honor the Father who sent him. ");
INSERT INTO engtcent_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Truly, truly, I say to you, whoever hears my word and believes him who sent me has eternal life. He does not come into judgment, but has passed from death to life. ");
INSERT INTO engtcent_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Truly, truly, I say to you, an hour is coming, and is now here, when the dead will hear the voice of the Son of God, and those who hear it will live. ");
INSERT INTO engtcent_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","For as the Father has life in himself, so he has granted the Son to have life in himself. ");
INSERT INTO engtcent_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","And he has given the Son authority to execute judgment, because he is the Son of Man. ");
INSERT INTO engtcent_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Do not be amazed at this, because an hour is coming in which all who are in the tombs will hear his voice ");
INSERT INTO engtcent_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","and come out, those who have done good to a resurrection of life, and those who have done evil to a resurrection of judgment. ");
INSERT INTO engtcent_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“I can do nothing on my own. As I hear, I judge, and my judgment is just, because I seek not my own will, but the will of the Father who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“If I testify about myself, my testimony is not valid. ");
INSERT INTO engtcent_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","There is another who testifies about me, and I know that the testimony he gives about me is true. ");
INSERT INTO engtcent_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","You have sent to John, and he has testified to the truth. ");
INSERT INTO engtcent_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Now I do not receive testimony from man, but I say these things so that you may be saved. ");
INSERT INTO engtcent_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John was a burning and shining lamp, and you were willing to rejoice for an hour in his light. ");
INSERT INTO engtcent_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","But I have testimony greater than John's. For the works that the Father has given me to accomplish, the very works that I am doing, testify that the Father has sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","And the Father who sent me has himself testified about me. You have neither heard his voice at any time nor seen his form. ");
INSERT INTO engtcent_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","And you do not have his word abiding in you, for you do not believe him whom he sent. ");
INSERT INTO engtcent_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","You search the Scriptures because you think that in them you have eternal life, and it is these that testify about me, ");
INSERT INTO engtcent_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","yet you are not willing to come to me so that you may have life. ");
INSERT INTO engtcent_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","I do not receive glory from men. ");
INSERT INTO engtcent_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","But I know that you do not have the love of God within you. ");
INSERT INTO engtcent_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","I have come in the name of my Father, and yet you do not receive me. If another comes in his own name, you will receive him. ");
INSERT INTO engtcent_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","How can you believe when you receive glory from one another but do not seek the glory that comes from the one and only God? ");
INSERT INTO engtcent_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Do not think that I will accuse you before the Father. The one who accuses you is Moses, in whom you have set your hope. ");
INSERT INTO engtcent_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","If you had believed Moses, you would believe me, for he wrote about me. ");
INSERT INTO engtcent_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","But if you do not believe his writings, how will you believe my words?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","After this Jesus went away to the other side of the Sea of Galilee (that is, the Sea of Tiberias). ");
INSERT INTO engtcent_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A large crowd was following him because they saw the miraculous signs he was performing on the sick. ");
INSERT INTO engtcent_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","So Jesus went up on the mountain and sat there with his disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Now the Jewish feast of the Passover was near.) ");
INSERT INTO engtcent_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","When Jesus lifted up his eyes and saw that a large crowd was coming to him, he said to Philip, “Where shall we buy bread so that these people may eat?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(He said this to test him, for he himself knew what he was about to do.) ");
INSERT INTO engtcent_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip answered him, “Two hundred denarii worth of bread would not be sufficient for each of them to receive a little portion.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Then one of his disciples, Andrew, the brother of Simon Peter, said to him, ");
INSERT INTO engtcent_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“There is a little boy here who has five barley loaves and two fish, but what good are they for so many people?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus said, “Have the people sit down.” (Now there was a lot of grass in that place.) So the men sat down, about five thousand in number. ");
INSERT INTO engtcent_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Then Jesus took the loaves, and after giving thanks, he distributed them to the disciples, and the disciples distributed them to those who were seated. He did the same with the fish, and the people ate as much as they wanted. ");
INSERT INTO engtcent_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","When they were full, Jesus said to his disciples, “Gather together the pieces that are left over so that nothing is wasted.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","So they gathered them together and filled twelve baskets with the broken pieces from the five barley loaves that were left over by those who had eaten. ");
INSERT INTO engtcent_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","When the people saw the sign that Jesus had done, they said, “This is truly the Prophet who is to come into the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","So Jesus, knowing that they were about to come and take him by force to make him king, withdrew to the mountain by himself. ");
INSERT INTO engtcent_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","When evening came, his disciples went down to the sea, ");
INSERT INTO engtcent_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","and after getting into the boat, they started going across the sea to Capernaum. Darkness had already set in, but Jesus had not come to them. ");
INSERT INTO engtcent_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Then the sea became rough because a strong wind was blowing. ");
INSERT INTO engtcent_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","When they had rowed about three or four miles, they saw Jesus approaching the boat, walking on the sea, and they were afraid. ");
INSERT INTO engtcent_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","But he said to them, “It is I; do not be afraid.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Then they were willing to receive him into the boat, and immediately the boat reached the land where they were heading. ");
INSERT INTO engtcent_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","On the next day the crowd that had stayed on the other side of the sea realized that there had been no other boat there except the one Jesus' disciples had gotten into, and that Jesus himself had not gotten into the boat with his disciples, but that his disciples had gone away alone. ");
INSERT INTO engtcent_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Then other boats from Tiberias came near the place where they had eaten the bread after the Lord had given thanks. ");
INSERT INTO engtcent_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","So when the crowd saw that neither Jesus nor his disciples were there, they themselves got into the boats and went to Capernaum, seeking Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","When they found him on the other side of the sea, they said to him, “Rabbi, when did yoʋ get here?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus answered them, “Truly, truly, I say to you, you are seeking me not because you saw signs, but because you ate the loaves and were filled. ");
INSERT INTO engtcent_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Do not work for food that perishes, but for food that endures to eternal life, which the Son of Man will give you. For on him God the Father has set his seal.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Then they said to him, “What must we do to do the works of God?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus answered them, “This is the work of God, that you believe in the one he has sent.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","So they said to him, “What sign then are yoʋ going to perform so that we may see it and believe yoʋ? What will yoʋ do? ");
INSERT INTO engtcent_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Our fathers ate the manna in the wilderness, just as it is written, ‘He gave them bread from heaven to eat.’ ” ");
INSERT INTO engtcent_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus said to them, “Truly, truly, I say to you, it was not Moses who gave you the bread from heaven, but my Father gives you the true bread from heaven. ");
INSERT INTO engtcent_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","For the bread of God is that which comes down from heaven and gives life to the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","So they said to him, “Sir, give us this bread always.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus said to them, “I am the bread of life; he who comes to me will never hunger, and he who believes in me will never thirst. ");
INSERT INTO engtcent_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","But as I told you, you have seen me and still you do not believe. ");
INSERT INTO engtcent_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Everyone the Father gives me will come to me, and I will never cast out anyone who comes to me. ");
INSERT INTO engtcent_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","For I have come down from heaven not to do my own will, but the will of him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","And this is the will of the Father who sent me, that I should lose none of those he has given me, but should raise them up on the last day. ");
INSERT INTO engtcent_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","And this is the will of him who sent me, that anyone who looks to the Son and believes in him should have eternal life, and I will raise him up on the last day.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Then the Jews began to grumble about him because he said, “I am the bread that came down from heaven.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","They said, “Is this not Jesus, the son of Joseph, whose father and mother we know? How then can he say, ‘I have come down from heaven’?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus answered them, “Do not grumble among yourselves. ");
INSERT INTO engtcent_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","No one can come to me unless the Father who sent me draws him, and I will raise him up on the last day. ");
INSERT INTO engtcent_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","It is written in the Prophets, ‘They will all be taught by God.’ Everyone therefore who has heard and learned from the Father comes to me— ");
INSERT INTO engtcent_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","not that anyone has seen the Father, except he who is from God; he has seen the Father. ");
INSERT INTO engtcent_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Truly, truly, I say to you, whoever believes in me has eternal life. ");
INSERT INTO engtcent_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","I am the bread of life. ");
INSERT INTO engtcent_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Your fathers ate the manna in the wilderness, and died. ");
INSERT INTO engtcent_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","This is the bread that comes down from heaven, so that anyone may eat of it and not die. ");
INSERT INTO engtcent_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","I am the living bread that has come down from heaven. If anyone eats of this bread, he will live forever. And the bread that I will give for the life of the world is my flesh.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Then the Jews began to quarrel with one another, saying, “How can this man give us his flesh to eat?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","So Jesus said to them, “Truly, truly, I say to you, if you do not eat the flesh of the Son of Man and drink his blood, you have no life in yourselves. ");
INSERT INTO engtcent_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Anyone who eats my flesh and drinks my blood has eternal life, and I will raise him up on the last day. ");
INSERT INTO engtcent_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","For my flesh is true food, and my blood is true drink. ");
INSERT INTO engtcent_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Whoever eats my flesh and drinks my blood abides in me, and I in him. ");
INSERT INTO engtcent_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Just as the living Father sent me, and I live because of the Father, so whoever feeds on me will also live because of me. ");
INSERT INTO engtcent_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","This is the bread that came down from heaven, not as your fathers ate the manna, and died. Whoever eats this bread will live forever.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","He said these things in a synagogue while teaching in Capernaum. ");
INSERT INTO engtcent_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","After hearing this, many of his disciples said, “This teaching is difficult; who can accept it?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","But Jesus, aware that his disciples were grumbling about this, said to them, “Does this offend you? ");
INSERT INTO engtcent_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Then what if you see the Son of Man ascending to where he was before? ");
INSERT INTO engtcent_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","It is the Spirit who gives life; the flesh is of no benefit. The words I speak to you are spirit and life. ");
INSERT INTO engtcent_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","But there are some among you who do not believe.” (For Jesus knew from the beginning which of them did not believe and who it was that would betray him.) ");
INSERT INTO engtcent_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Then he said, “That is why I told you that no one can come to me unless it has been granted to him by my Father.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","At that point many of his disciples went back and no longer walked with him. ");
INSERT INTO engtcent_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","So Jesus said to the twelve, “Do you also want to go away?” ");
INSERT INTO engtcent_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter answered him, “Lord, to whom shall we go? Yoʋ have the words of eternal life. ");
INSERT INTO engtcent_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","And we have come to believe and to know that yoʋ are the Christ, the Son of the living God.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus answered them, “Did I not choose you, the twelve? And yet one of you is a devil.” ");
INSERT INTO engtcent_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Now he was speaking about Judas Iscariot, the son of Simon, who was one of the twelve and would later betray him.) ");
INSERT INTO engtcent_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","After this Jesus went from place to place in Galilee, for he did not want to travel around in Judea because the Jews were seeking to kill him. ");
INSERT INTO engtcent_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Now the Jewish Feast of Tabernacles was near. ");
INSERT INTO engtcent_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","So Jesus' brothers said to him, “Leave here and go to Judea so that yoʋr disciples may see the works yoʋ are doing. ");
INSERT INTO engtcent_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","For no one does anything in secret while seeking to be known publicly. If yoʋ are going to do these things, show yoʋrself to the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(For not even his brothers believed in him.) ");
INSERT INTO engtcent_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","So Jesus said to them, “My time has not yet come, but your time is always at hand. ");
INSERT INTO engtcent_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","The world cannot hate you, but it does hate me because I testify that its works are evil. ");
INSERT INTO engtcent_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","You go up to this feast; I am not yet going up to this feast, for my time has not yet been fulfilled.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","After saying this to them, he remained in Galilee. ");
INSERT INTO engtcent_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","However, after his brothers had gone up to the feast, Jesus also went up, not openly but in secret. ");
INSERT INTO engtcent_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Now the Jews were looking for him at the feast, saying, “Where is that man?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","And there was much murmuring about him among the crowds. Some were saying, “He is a good man.” Others were saying, “No, he is deceiving the people.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","No one, however, was speaking openly about him for fear of the Jews. ");
INSERT INTO engtcent_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Midway through the feast, Jesus went up to the temple courts and began to teach. ");
INSERT INTO engtcent_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","The Jews were amazed, saying, “How does this man know so much, when he has never had any formal instruction?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus answered them, “My teaching is not my own; it comes from him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","If anyone wants to do God's will, he will know whether my teaching comes from God or whether I am speaking on my own authority. ");
INSERT INTO engtcent_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","He who speaks on his own authority seeks his own glory, but he who seeks the glory of the one who sent him is true, and there is no unrighteousness in him. ");
INSERT INTO engtcent_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Did not Moses give you the law? Yet none of you keeps the law. Why are you seeking to kill me?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","The crowd answered, “Yoʋ have a demon! Who is seeking to kill yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus answered them, “I performed one miracle, and you are all amazed. ");
INSERT INTO engtcent_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses gave you circumcision (not that it came from Moses, but from the fathers), and that is why you circumcise a boy even on the Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","If a boy can receive circumcision on the Sabbath so that the law of Moses will not be broken, why are you angry with me because I made a man entirely well on the Sabbath? ");
INSERT INTO engtcent_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Do not judge according to appearance, but judge with right judgment.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Now some of the people of Jerusalem were saying, “Is this not the man whom they are seeking to kill? ");
INSERT INTO engtcent_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","And behold, he is speaking openly, and they are saying nothing to him. Could it be that the rulers indeed know that he is truly the Christ? ");
INSERT INTO engtcent_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yet we know where this man is from, but when the Christ comes, no one will know where he is from.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Then Jesus cried out as he taught in the temple courts, “You know me and you know where I am from. Yet I have not come on my own authority, but he who sent me is true. You do not know him, ");
INSERT INTO engtcent_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","but I know him, because I have come from him, and he is the one who sent me.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","So they were trying to arrest him, but no one laid a hand on him, because his hour had not yet come. ");
INSERT INTO engtcent_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Still, many from among the crowd believed in him and said, “When the Christ comes, will he do more signs than this man has done?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","The Pharisees heard the crowd murmuring these things about Jesus, so the Pharisees and the chief priests sent officers to arrest him. ");
INSERT INTO engtcent_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Then Jesus said, “I will be with you for only a little while longer, and then I am going to him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","You will seek me, but you will not find me; and where I am going, you cannot come.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Then the Jews said to one another, “Where is this man about to go that we will not find him? Is he about to go to the Jews who are scattered among the Greeks and teach the Greeks? ");
INSERT INTO engtcent_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","What does he mean by saying, ‘You will seek me, but you will not find me; and where I am going, you cannot come’?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","On the last day, the great day of the feast, Jesus stood up and cried out, “If anyone is thirsty, let him come to me and drink. ");
INSERT INTO engtcent_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Whoever believes in me, just as the Scripture has said, ‘From his innermost being will flow rivers of living water.’ ” ");
INSERT INTO engtcent_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(He said this about the Spirit, whom those who believed in him were going to receive, for the Holy Spirit had not yet been given, because Jesus had not yet been glorified.) ");
INSERT INTO engtcent_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","When they heard this, many from among the crowd were saying, “Surely this man is the Prophet.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Others were saying, “He is the Christ.” But others were saying, “No, for the Christ does not come from Galilee, does he? ");
INSERT INTO engtcent_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Does not the Scripture say that the Christ will come from David's descendants and from Bethlehem, the town where David lived?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","So a division arose among the crowd because of Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Some of them wanted to arrest him, but no one laid a hand on him. ");
INSERT INTO engtcent_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Then the officers came to the chief priests and Pharisees, who said to them, “Why did you not bring him in?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","The officers answered, “Never has anyone spoken like this man.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","The Pharisees answered them, “Have you also been deceived? ");
INSERT INTO engtcent_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Have any of the rulers or the Pharisees believed in him? ");
INSERT INTO engtcent_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","No! But this crowd that is following him does not know the law; they are accursed.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Then Nicodemus, who had gone to Jesus by night and who was one of the rulers, said, ");
INSERT INTO engtcent_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Does our law condemn a man without first giving him a hearing and finding out what he is doing?” ");
INSERT INTO engtcent_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","They answered him, “Are yoʋ also from Galilee? Search and see that no prophet has ever arisen from Galilee.” ");
INSERT INTO engtcent_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","And each went to his own house. ");
INSERT INTO engtcent_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","But Jesus went to the Mount of Olives. ");
INSERT INTO engtcent_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Early in the morning he again went to the temple courts. All the people came, and he sat down and taught them. ");
INSERT INTO engtcent_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Then the scribes and the Pharisees brought him a woman who had been caught in adultery. Making her stand before them all, ");
INSERT INTO engtcent_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","they said to Jesus, testing him, “Teacher, this woman was caught in the very act of committing adultery. ");
INSERT INTO engtcent_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","In the law, Moses commanded us that such women should be stoned; what then do yoʋ say?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(They said this to test him, so that they might have something to accuse him of.) But Jesus stooped down and wrote with his finger on the ground, taking no notice. ");
INSERT INTO engtcent_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","When they continued asking him, he stood up and said to them, “Let him among you who is without sin be the first to throw a stone at her.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","And again he stooped down and wrote on the ground. ");
INSERT INTO engtcent_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","When they heard this, they were convicted by their own consciences and began to go away one by one, starting with the older men. So Jesus was left alone, with the woman there before him. ");
INSERT INTO engtcent_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Then Jesus stood up and saw no one but the woman. So he said to her, “Where are yoʋr accusers? Has no one condemned yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","She said, “No one, Lord.” Jesus said, “Neither do I pass judgment on yoʋ; go and sin no more.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Then Jesus spoke to them again, saying, “I am the light of the world. Whoever follows me will certainly not walk in darkness, but will have the light of life.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","So the Pharisees said to him, “Yoʋ are testifying about yoʋrself, so yoʋr testimony is not valid.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus answered them, “Even if I testify about myself, my testimony is valid, for I know where I came from and where I am going, but you do not know where I come from or where I am going. ");
INSERT INTO engtcent_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","You judge according to the flesh, but I judge no one. ");
INSERT INTO engtcent_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yet even if I do judge, my judgment is valid; for I am not alone, but I stand with the Father who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","In your own law it is written that the testimony of two men is valid. ");
INSERT INTO engtcent_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","I testify about myself, and the Father who sent me also testifies about me.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Then they said to him, “Where is yoʋr father?” Jesus answered, “You neither know me nor my Father. If you knew me, you would know my Father as well.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","(Jesus spoke these words in the treasury as he taught in the temple courts. But no one arrested him, because his hour had not yet come.) ");
INSERT INTO engtcent_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Then Jesus said to them again, “I am going away, and you will seek me, but you will die in your sin. Where I am going, you cannot come.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","So the Jews said, “Is he going to kill himself? Is that what he means by saying, ‘Where I am going, you cannot come’?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","He said to them, “You are from below; I am from above. You are of this world; I am not of this world. ");
INSERT INTO engtcent_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Therefore I said to you that you will die in your sins, for if you do not believe that I am he, you will die in your sins.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","They said to him, “Who are yoʋ?” Jesus said to them, “Exactly what I have been saying to you from the beginning. ");
INSERT INTO engtcent_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I have many things to say about you and to judge, but he who sent me is true, and I tell the world what I have heard from him.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","(They did not know that he was speaking to them about the Father.) ");
INSERT INTO engtcent_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","So Jesus said to them, “When you lift up the Son of Man, then you will know that I am he and that I do nothing on my own authority, but I speak these things just as my Father taught me. ");
INSERT INTO engtcent_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","He who sent me is with me. The Father has not left me alone, for I always do what pleases him.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","As he was saying these things, many believed in him. ");
INSERT INTO engtcent_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Then Jesus said to the Jews who had believed in him, “If you abide in my word, you are truly my disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Then you will know the truth, and the truth will set you free.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","They answered him, “We are descendants of Abraham, and we have never been enslaved to anyone. How then can yoʋ say, ‘You will be set free’?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus answered them, “Truly, truly, I say to you, everyone who commits sin is a slave of sin. ");
INSERT INTO engtcent_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","The slave does not abide in the house forever; the son abides forever. ");
INSERT INTO engtcent_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","So if the son sets you free, you will be free indeed. ");
INSERT INTO engtcent_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","I know that you are Abraham's descendants, but you are seeking to kill me because your hearts have no room for my word. ");
INSERT INTO engtcent_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","I speak of what I have seen with my Father; so you also are doing what you have seen with your father.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","They answered him, “Our father is Abraham.” Jesus said to them, “If you were children of Abraham, you would be doing the works of Abraham. ");
INSERT INTO engtcent_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","But now you are seeking to kill me, a man who has spoken to you the truth I heard from God. Abraham did not do such a thing. ");
INSERT INTO engtcent_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","You are doing the works of your father.” They said to him, “We were not born of fornication. We have one Father—God.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus said to them, “If God were your Father, you would love me, for I have come here from God. I have not come of my own accord, but he sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Why do you not understand what I am saying? It is because you cannot bear to accept my word. ");
INSERT INTO engtcent_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","You belong to your father the devil, and you want to carry out your father's desires. He was a murderer from the beginning and does not stand in the truth, because there is no truth in him. When he speaks lies, he speaks from his own character, because he is a liar and the father of lies. ");
INSERT INTO engtcent_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","But because I speak the truth, you do not believe me. ");
INSERT INTO engtcent_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Which one of you can convict me of sin? If I am telling the truth, why do you not believe me? ");
INSERT INTO engtcent_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Whoever belongs to God hears the words of God. The reason you do not hear them is because you do not belong to God.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","The Jews answered him, “Do we not rightly say that yoʋ are a Samaritan and have a demon?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus answered, “I do not have a demon, but I honor my Father, and you dishonor me. ");
INSERT INTO engtcent_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","I do not seek my own glory; there is one who seeks it, and he is the judge. ");
INSERT INTO engtcent_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Truly, truly, I say to you, if anyone keeps my word, he will certainly never see death.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","The Jews said to him, “Now we know that yoʋ have a demon. Abraham died, and so did the prophets, yet yoʋ say, ‘If anyone keeps my word, he will certainly never taste death.’ ");
INSERT INTO engtcent_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Are yoʋ greater than our father Abraham, who died? The prophets also died. Who do yoʋ make yoʋrself out to be?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus answered, “If I glorify myself, my glory is nothing. It is my Father who glorifies me, of whom you say, ‘He is our God.’ ");
INSERT INTO engtcent_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","You do not know him, but I know him. If I were to say that I do not know him, I would be a liar like you. But I do know him, and I keep his word. ");
INSERT INTO engtcent_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Your father Abraham was glad that he would see my day. He saw it and rejoiced.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Then the Jews said to him, “Yoʋ are not yet fifty years old, and yoʋ have seen Abraham?” ");
INSERT INTO engtcent_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","So Jesus said to them, “Truly, truly, I say to you, before Abraham was, I am.” ");
INSERT INTO engtcent_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","So they picked up stones to throw at him, but Jesus hid himself and went out from the temple grounds. And passing through the crowd, he walked away. ");
INSERT INTO engtcent_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","As Jesus walked along, he saw a man who had been blind from birth. ");
INSERT INTO engtcent_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","His disciples asked him, “Rabbi, who sinned, this man or his parents, that he should be born blind?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus answered, “Neither did this man sin nor his parents, but it happened so that the works of God might be revealed in him. ");
INSERT INTO engtcent_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I must do the works of him who sent me while it is day; night is coming, when no one can work. ");
INSERT INTO engtcent_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","As long as I am in the world, I am the light of the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","After saying this, he spit on the ground and made mud with the saliva. Then he rubbed the mud on the blind man's eyes ");
INSERT INTO engtcent_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","and said to him, “Go wash in the pool of Siloam” (which means “Sent”). So he went and washed, and came away seeing. ");
INSERT INTO engtcent_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Then his neighbors and those who had previously seen that he was blind were saying, “Is this not the man who used to sit and beg?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Others were saying, “It is he.” Still others were saying, “He is like him.” But he kept saying, “I am he.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","So they said to him, “How were yoʋr eyes opened?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","He answered, “A man named Jesus made mud, rubbed it on my eyes, and said to me, ‘Go to the pool of Siloam and wash.’ So I went and washed, and received my sight.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","They said to him, “Where is this man?” He said, “I do not know.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","So they brought the man who was once blind to the Pharisees. ");
INSERT INTO engtcent_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Now it was a Sabbath when Jesus made the mud and opened the man's eyes.) ");
INSERT INTO engtcent_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","The Pharisees again asked him how he had received his sight, and he said to them, “He put mud on my eyes, and I washed, and now I see.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Then some of the Pharisees were saying, “This man is not from God, for he does not keep the Sabbath.” But others were saying, “How can a sinful man do such signs?” And a division arose among them. ");
INSERT INTO engtcent_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","So they said to the blind man again, “What do yoʋ say about him, since he opened yoʋr eyes?” The man said, “He is a prophet.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Now the Jews did not believe that the man had been blind and had received his sight until they called in his parents. ");
INSERT INTO engtcent_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","They asked them, “Is this your son, who you say was born blind? How then does he now see?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","His parents answered them, “We know that this is our son and that he was born blind. ");
INSERT INTO engtcent_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","But how he can now see or who opened his eyes, we do not know. He is of age; ask him. He will speak for himself.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(His parents said this because they were afraid of the Jews, for the Jews had already agreed that if anyone should confess that Jesus was the Christ, he would be put out of the synagogue. ");
INSERT INTO engtcent_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","That is why his parents said, “He is of age; ask him.”) ");
INSERT INTO engtcent_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","So for a second time they called in the man who had been blind and said to him, “Give glory to God! We know that this man is a sinner.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","He answered, “Whether he is a sinner or not, I do not know; one thing I know, that though I was blind, now I see.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Again they said to him, “What did he do to yoʋ? How did he open yoʋr eyes?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","He answered them, “I told you already, and you did not listen. Why do you want to hear it again? Do you also want to become his disciples?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Then they reviled him and said, “Yoʋ are a disciple of that man, but we are disciples of Moses. ");
INSERT INTO engtcent_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","We know that God has spoken to Moses, but as for this man, we do not know where he is from.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","The man answered them, “Why, this is an amazing thing, that you do not know where he is from, and yet he opened my eyes! ");
INSERT INTO engtcent_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","We know that God does not listen to sinners, but he does listen to anyone who is devout and does his will. ");
INSERT INTO engtcent_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Never before has anyone heard of someone opening the eyes of a man born blind. ");
INSERT INTO engtcent_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","If this man were not from God, he could do nothing.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","They answered him, “Yoʋ were born entirely in sin, and yet yoʋ are trying to teach us?” And they threw him out. ");
INSERT INTO engtcent_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus heard that they had thrown him out, so he found the man and said to him, “Do yoʋ believe in the Son of God?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","He answered, “Who is he, Lord, that I may believe in him?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus said to him, “Yoʋ have seen him, and the one speaking with yoʋ is he.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","The man said, “I believe, Lord.” And he worshiped him. ");
INSERT INTO engtcent_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Then Jesus said, “For judgment I have come into this world, so that those who do not see may see, and those who see may become blind.” ");
INSERT INTO engtcent_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Some of the Pharisees who were with him heard this and said to him, “We are not also blind, are we?” ");
INSERT INTO engtcent_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus said to them, “If you were blind, you would have no sin, but now you say, ‘We see.’ Therefore your sin remains. ");
INSERT INTO engtcent_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Truly, truly, I say to you, he who does not enter the sheepfold by the gate but climbs in by another way is a thief and a robber. ");
INSERT INTO engtcent_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","But he who enters by the gate is the shepherd of the sheep. ");
INSERT INTO engtcent_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","The gatekeeper opens the gate for him, and the sheep hear his voice. He calls his own sheep by name and leads them out. ");
INSERT INTO engtcent_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","When he has brought out his own sheep, he goes ahead of them, and the sheep follow him because they recognize his voice. ");
INSERT INTO engtcent_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","They will certainly not follow a stranger, but will flee from him because they do not recognize the voice of strangers.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus spoke to them with this figure of speech, but they did not understand what he was saying to them. ");
INSERT INTO engtcent_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","So Jesus said to them again, “Truly, truly, I say to you, I am the gate for the sheep. ");
INSERT INTO engtcent_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","All who came previously are thieves and robbers, but the sheep did not listen to them. ");
INSERT INTO engtcent_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","I am the gate; if anyone enters through me, he will be saved and will come in and go out and find pasture. ");
INSERT INTO engtcent_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","The thief comes only to steal, kill, and destroy. I have come that they may have life, and have it abundantly. ");
INSERT INTO engtcent_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","I am the good shepherd; the good shepherd lays down his life for the sheep. ");
INSERT INTO engtcent_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","But the hired hand is not the shepherd and does not own the sheep. So when he sees the wolf coming, he leaves the sheep and flees, and the wolf snatches the sheep and scatters them. ");
INSERT INTO engtcent_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","The hired hand flees, for he is a hired hand and does not care about the sheep. ");
INSERT INTO engtcent_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","I am the good shepherd. I know my sheep and my sheep know me, ");
INSERT INTO engtcent_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","even as the Father knows me and I know the Father. I lay down my life for the sheep. ");
INSERT INTO engtcent_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","I have other sheep that are not of this fold. I must bring them in as well, and they will hear my voice. And there will be one flock with one shepherd. ");
INSERT INTO engtcent_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","This is why the Father loves me, because I lay down my life so that I may take it up again. ");
INSERT INTO engtcent_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","No one takes it from me, but I lay it down of my own accord. I have authority to lay it down, and I have authority to take it up again. I received this commandment from my Father.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","At these words there was again a division among the Jews. ");
INSERT INTO engtcent_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Many of them were saying, “He has a demon and is out of his mind; why do you listen to him?” ");
INSERT INTO engtcent_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Others were saying, “These are not the words of a man possessed by a demon. Can a demon open the eyes of the blind?” ");
INSERT INTO engtcent_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Now it was the Feast of the Dedication in Jerusalem. It was winter, ");
INSERT INTO engtcent_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","and Jesus was walking in the temple courts, in Solomon's Portico. ");
INSERT INTO engtcent_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","So the Jews gathered around him and said to him, “How long are yoʋ going to keep us in suspense? If yoʋ are the Christ, tell us plainly.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus answered them, “I did tell you, but you do not believe. The works that I do in my Father's name testify about me, ");
INSERT INTO engtcent_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","but you do not believe because you are not among my sheep, just as I told you. ");
INSERT INTO engtcent_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","My sheep hear my voice; I know them, and they follow me. ");
INSERT INTO engtcent_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","I give them eternal life, and they will certainly never perish, and no one will snatch them out of my hand. ");
INSERT INTO engtcent_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","My Father, who has given them to me, is greater than all, and no one is able to snatch them out of my Father's hand. ");
INSERT INTO engtcent_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","The Father and I are one.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Then the Jews picked up stones again to stone him. ");
INSERT INTO engtcent_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","In response Jesus said to them, “I have shown you many good works from my Father; for which of these works are you going to stone me?” ");
INSERT INTO engtcent_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","The Jews answered him, “We are not going to stone yoʋ for any good work, but for blasphemy, because yoʋ, who are just a man, make yoʋrself out to be God.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus answered them, “Is it not written in your law, ‘I said, you are gods’? ");
INSERT INTO engtcent_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","If he called them ‘gods,’ to whom the word of God came (and the Scripture cannot be broken), ");
INSERT INTO engtcent_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","do you say of him whom the Father consecrated and sent into the world, ‘Yoʋ are blaspheming,’ because I said, ‘I am the Son of God’? ");
INSERT INTO engtcent_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","If I do not do the works of my Father, do not believe me. ");
INSERT INTO engtcent_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","But if I do them, even if you do not believe me, believe the works, so that you may know and believe that the Father is in me and I in him.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Once again they tried to arrest him, but he eluded their grasp. ");
INSERT INTO engtcent_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Then Jesus went away again to the other side of the Jordan, to the place where John had been baptizing at first, and he stayed there. ");
INSERT INTO engtcent_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Many came to him and were saying, “John did no sign, but everything that John said about this man was true.” ");
INSERT INTO engtcent_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","And many of the people there believed in Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Now a man named Lazarus was sick. He was from Bethany, the village of Mary and her sister Martha. ");
INSERT INTO engtcent_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mary was the one who anointed the Lord with ointment and wiped his feet with her hair; it was her brother Lazarus who was sick.) ");
INSERT INTO engtcent_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","So the sisters sent word to Jesus, “Lord, behold, the one yoʋ love is sick.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","But when Jesus heard this, he said, “This sickness will not end in death but is for the glory of God, so that the Son of God may be glorified through it.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Now Jesus loved Martha, her sister Mary, and Lazarus. ");
INSERT INTO engtcent_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","But when he heard that Lazarus was sick, he stayed where he was for two more days. ");
INSERT INTO engtcent_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","After that he said to the disciples, “Let us go to Judea again.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","The disciples said to him, “Rabbi, the Jews were just recently seeking to stone yoʋ, and yet you are going there again?” ");
INSERT INTO engtcent_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus answered, “Are there not twelve hours in the day? If anyone walks in the day, he does not stumble, because he sees the light of this world. ");
INSERT INTO engtcent_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","But if anyone walks in the night, he stumbles, because the light is not in him.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","After saying this, he said to them, “Our friend Lazarus has fallen asleep, but I am going there to wake him up.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","His disciples said, “Lord, if he has fallen asleep, he will recover.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","(They thought Jesus was speaking about natural sleep, but he was actually speaking about Lazarus' death.) ");
INSERT INTO engtcent_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Then Jesus told them plainly, “Lazarus has died, ");
INSERT INTO engtcent_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","and I rejoice for your sake that I was not there, so that you may believe. But let us go to him.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Then Thomas (called Didymus) said to his fellow disciples, “Let us go too, so that we may die with him.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","When Jesus arrived, he found that Lazarus had been in the tomb for four days already. ");
INSERT INTO engtcent_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Now Bethany was less than two miles from Jerusalem, ");
INSERT INTO engtcent_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","and many of the Jews had joined the women who were with Martha and Mary, to console them about their brother. ");
INSERT INTO engtcent_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","When Martha heard that Jesus was coming, she went to meet him, but Mary remained seated in the house. ");
INSERT INTO engtcent_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Then Martha said to Jesus, “Lord, if yoʋ had been here, my brother would not have died. ");
INSERT INTO engtcent_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","But even now I know that God will give yoʋ whatever yoʋ ask of him.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus said to her, “Yoʋr brother will rise again.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha said to him, “I know that he will rise again in the resurrection on the last day.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus said to her, “I am the resurrection and the life. He who believes in me, though he may die, yet shall he live. ");
INSERT INTO engtcent_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","No one who lives and believes in me will ever die. Do yoʋ believe this?” ");
INSERT INTO engtcent_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","She said to him, “Yes, Lord, I have come to believe that yoʋ are the Christ, the Son of God, who is to come into the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","After saying this, she went and called her sister Mary, saying in private, “The Teacher is here and is calling for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","When Mary heard this, she rose quickly and went to him. ");
INSERT INTO engtcent_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Now Jesus had not yet come into the village, but was in the place where Martha had met him.) ");
INSERT INTO engtcent_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","When the Jews who were in the house with Mary, consoling her, saw her rise quickly and go out, they followed her, saying, “She is going to the tomb to weep there.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","When Mary came to where Jesus was and saw him, she fell at his feet and said to him, “Lord, if yoʋ had been here, my brother would not have died.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","When Jesus saw her weeping, and the Jews who had come with her also weeping, he was deeply moved in his spirit and troubled. ");
INSERT INTO engtcent_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","He said, “Where have you laid him?” They said to him, “Lord, come and see.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus wept. ");
INSERT INTO engtcent_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","So the Jews said, “See how he loved him!” ");
INSERT INTO engtcent_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","But some of them said, “Could not he who opened the eyes of the blind man have also kept this man from dying?” ");
INSERT INTO engtcent_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Deeply moved once more, Jesus came to the tomb. (It was a cave, and a stone was lying against it.) ");
INSERT INTO engtcent_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus said, “Take away the stone.” Martha, the sister of the man who had died, said to him, “Lord, there is already a stench, for it is the fourth day.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus said to her, “Did I not tell yoʋ that if yoʋ believed yoʋ would see the glory of God?” ");
INSERT INTO engtcent_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","So they took away the stone from where the dead man was lying. Then Jesus lifted up his eyes and said, “Father, I thank yoʋ that yoʋ have heard me. ");
INSERT INTO engtcent_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","I know that yoʋ always hear me, but I say this for the benefit of the crowd that is standing here, so that they may believe that yoʋ sent me.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","After saying this, he cried out with a loud voice, “Lazarus, come out!” ");
INSERT INTO engtcent_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Then the man who had died came out, his feet and his hands bound with strips of cloth, and his face wrapped in a cloth. Jesus said to them, “Unbind him, and let him go.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Therefore many of the Jews who had come to Mary, and had seen what Jesus did, believed in him. ");
INSERT INTO engtcent_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","But some of them went to the Pharisees and told them what Jesus had done. ");
INSERT INTO engtcent_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","So the chief priests and the Pharisees convened a meeting of the Sanhedrin and said, “What are we going to do? For this man is doing many signs. ");
INSERT INTO engtcent_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","If we allow him to continue like this, everyone will believe in him, and the Romans will come and take away our holy place and our nation.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","But one of them, Caiaphas, who was high priest that year, said to them, “You do not know anything, ");
INSERT INTO engtcent_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nor do you consider that it is better for us to have one man die for the people than to have the whole nation perish.” ");
INSERT INTO engtcent_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(He said this not of his own accord, but as high priest that year he prophesied that Jesus was going to die for the nation, ");
INSERT INTO engtcent_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","and not only for the nation, but also to gather together and unite the children of God scattered abroad.) ");
INSERT INTO engtcent_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","So from that day they plotted together to kill him. ");
INSERT INTO engtcent_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Therefore Jesus no longer went around openly among the Jews. Instead, he departed from there to the region near the wilderness, to a town called Ephraim, where he spent time with his disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Now the Passover of the Jews was near, and many people went up to Jerusalem from the countryside to purify themselves before the Passover. ");
INSERT INTO engtcent_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","They were looking for Jesus and saying to one another as they stood in the temple courts, “What do you think? That he will not come to the feast at all?” ");
INSERT INTO engtcent_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","(Now the chief priests and the Pharisees had given an order that if anyone knew where Jesus was, he should report it, so that they could arrest him.) ");
INSERT INTO engtcent_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Six days before the Passover, Jesus came to Bethany, where Lazarus was, the man who had died and whom Jesus had raised from the dead. ");
INSERT INTO engtcent_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","They prepared a supper for Jesus there. Martha was serving, and Lazarus was one of the people reclining at the table with him. ");
INSERT INTO engtcent_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Then Mary took a pound of expensive ointment made of pure nard, anointed Jesus' feet, and wiped his feet with her hair. The house was filled with the fragrance of the ointment. ");
INSERT INTO engtcent_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Then one of his disciples, Judas Iscariot, Simon's son, who was about to betray him, said, ");
INSERT INTO engtcent_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Why was this ointment not sold for three hundred denarii and the money given to the poor?” ");
INSERT INTO engtcent_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(He said this not because he cared about the poor, but because he was a thief; he was the keeper of the moneybag and would pilfer what was put into it.) ");
INSERT INTO engtcent_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","So Jesus said, “Leave her alone; she has kept this ointment for the day of my burial. ");
INSERT INTO engtcent_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","For you always have the poor with you, but you will not always have me.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Meanwhile a large crowd of the Jews found out that Jesus was there, so they came not only because of Jesus but also to see Lazarus, whom he had raised from the dead. ");
INSERT INTO engtcent_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","So the chief priests plotted to kill Lazarus also, ");
INSERT INTO engtcent_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","because on account of him many of the Jews were going over to Jesus and believing in him. ");
INSERT INTO engtcent_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","On the next day, when a large crowd that had come to the feast heard that Jesus was coming to Jerusalem, ");
INSERT INTO engtcent_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","they took palm branches and went out to meet him. They were crying out, “Hosanna! Blessed is he who comes in the name of the Lord, the King of Israel!” ");
INSERT INTO engtcent_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Finding a young donkey, Jesus sat on it, just as it is written, ");
INSERT INTO engtcent_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Do not be afraid, daughter of Zion. Behold, yoʋr king is coming, sitting on a donkey's colt.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(His disciples did not understand these things at first, but when Jesus was glorified, they remembered that these things were written about him, and that these things had been done to him.) ");
INSERT INTO engtcent_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Now the crowd that had been with him when he called Lazarus out of the tomb and raised him from the dead was testifying about it. ");
INSERT INTO engtcent_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","That is why a crowd went out to meet him, because they heard he had done this sign. ");
INSERT INTO engtcent_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","So the Pharisees said to one another, “You see that you are achieving nothing. Behold, the world has gone after him.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Now there were some Greeks among those who went up to worship at the feast. ");
INSERT INTO engtcent_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","They came to Philip, who was from Bethsaida of Galilee, and requested of him, “Sir, we would like to see Jesus.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip went and told Andrew, and in turn Andrew and Philip told Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus replied to them, “The hour has come for the Son of Man to be glorified. ");
INSERT INTO engtcent_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Truly, truly, I say to you, unless a grain of wheat falls to the ground and dies, it remains alone; but if it dies, it bears much fruit. ");
INSERT INTO engtcent_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Whoever loves his life will lose it, but whoever hates his life in this world will keep it for eternal life. ");
INSERT INTO engtcent_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","If anyone wants to serve me, he must follow me; and where I am, there will my servant be also. If anyone serves me, the Father will honor him.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“My soul is now troubled. And what shall I say? ‘Father, save me from this hour’? No, it is for this reason that I have come to this hour. ");
INSERT INTO engtcent_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Father, glorify yoʋr name.” Then a voice came from heaven: “I have glorified it, and will glorify it again.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","When the crowd standing there heard the voice, they said it was thunder. Others said, “An angel has spoken to him.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus responded, “This voice has come not for my sake, but for your sake. ");
INSERT INTO engtcent_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Now is the judgment of this world. Now the ruler of this world will be cast out. ");
INSERT INTO engtcent_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","And when I am lifted up from the earth, I will draw all people to myself.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(He said this to indicate the kind of death he was going to die.) ");
INSERT INTO engtcent_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","The crowd responded to him, “We have heard from the law that the Christ remains forever, so how can yoʋ say, ‘The Son of Man must be lifted up’? Who is this ‘Son of Man’?” ");
INSERT INTO engtcent_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus said to them, “The light is with you for a little while longer. Walk while you have the light, so that the darkness will not overtake you. He who walks in the darkness does not know where he is going. ");
INSERT INTO engtcent_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","While you have the light, believe in the light, so that you will become sons of light.” After saying these things, Jesus went away and was hidden from them. ");
INSERT INTO engtcent_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Although he had done so many signs in their presence, they did not believe in him. ");
INSERT INTO engtcent_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","This was to fulfill what had been spoken by the prophet Isaiah: “Lord, who has believed our report? And to whom has the arm of the Lord been revealed?” ");
INSERT INTO engtcent_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","For this reason they could not believe, for again Isaiah said, ");
INSERT INTO engtcent_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“He has blinded their eyes and hardened their hearts, lest they should see with their eyes and understand with their hearts and turn back, and I would heal them.” ");
INSERT INTO engtcent_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah said these things when he saw the Lord's glory and spoke about him. ");
INSERT INTO engtcent_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nevertheless, many even among the rulers believed in him, but because of the Pharisees they would not declare it openly, so that they would not be put out of the synagogue. ");
INSERT INTO engtcent_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","For they loved the glory that comes from men more than the glory that comes from God. ");
INSERT INTO engtcent_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Then Jesus cried out, “Whoever believes in me, believes not in me but in him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","And whoever sees me sees him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","I have come into the world as light, so that no one who believes in me will remain in darkness. ");
INSERT INTO engtcent_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","If anyone hears my words and does not believe, I do not judge him; for I did not come to judge the world, but to save the world. ");
INSERT INTO engtcent_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","He who rejects me and does not receive my words has a judge; the word I have spoken will judge him on the last day. ");
INSERT INTO engtcent_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","For I have not spoken on my own authority, but the Father who sent me gave me a commandment as to what I should say and what I should speak. ");
INSERT INTO engtcent_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","And I know that his commandment leads to eternal life. What I speak, therefore, I speak just as the Father has told me.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Now before the feast of the Passover, Jesus knew that his hour had come to depart from this world and go to the Father. Having loved his own who were in the world, he loved them to the end. ");
INSERT INTO engtcent_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","By the time supper ended, the devil had put it into the heart of Judas Iscariot, the son of Simon, to betray Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus knew that the Father had put all things into his hands, and that he had come from God and was going back to God, ");
INSERT INTO engtcent_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","so he rose from supper, laid aside his outer garments, took a towel, and wrapped it around his waist. ");
INSERT INTO engtcent_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","After that, he put water into the washbasin and began to wash his disciples' feet and to wipe them with the towel that was wrapped around his waist. ");
INSERT INTO engtcent_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","When he came to Simon Peter, Peter said to him, “Lord, are yoʋ going to wash my feet?” ");
INSERT INTO engtcent_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus answered him, “What I am doing yoʋ do not now understand, but afterward yoʋ will understand.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter said to him, “Yoʋ shall never wash my feet.” Jesus answered him, “If I do not wash yoʋ, yoʋ have no part with me.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter said to him, “Lord, then wash not only my feet, but also my hands and my head.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus said to him, “He who has bathed has no need to wash, except for his feet, but is completely clean. And you are clean, but not all of you.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(For he knew who would betray him; that is why he said, “You are not all clean.”) ");
INSERT INTO engtcent_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","When Jesus had washed their feet and collected his outer garments, he reclined again at the table and said to them, “Do you know what I have done for you? ");
INSERT INTO engtcent_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","You call me Teacher and Lord, and rightly so, for that is what I am. ");
INSERT INTO engtcent_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","So if I, your Lord and Teacher, have washed your feet, you also ought to wash one another's feet. ");
INSERT INTO engtcent_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","For I have given you an example so that you should do as I have done for you. ");
INSERT INTO engtcent_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Truly, truly, I say to you, a servant is not greater than his master, nor is a messenger greater than the one who sent him. ");
INSERT INTO engtcent_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Now that you know these things, you are blessed if you do them. ");
INSERT INTO engtcent_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","I am not speaking about all of you; I know whom I have chosen. But this Scripture must be fulfilled: ‘He who eats bread with me has lifted up his heel against me.’ ");
INSERT INTO engtcent_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","I am telling you now before it happens, so that when it does happen, you will believe that I am he. ");
INSERT INTO engtcent_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Truly, truly, I say to you, whoever receives the one I send receives me, and whoever receives me receives him who sent me.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","After saying these things, Jesus was troubled in his spirit and declared, “Truly, truly, I say to you, one of you will betray me.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","So the disciples began looking at one another, perplexed as to whom he was speaking about. ");
INSERT INTO engtcent_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","One of his disciples, the one whom Jesus loved, was reclining on Jesus' chest. ");
INSERT INTO engtcent_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","So Simon Peter motioned to him to ask Jesus whom he was talking about. ");
INSERT INTO engtcent_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Leaning back on Jesus' chest, he said to him, “Lord, who is it?” ");
INSERT INTO engtcent_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus answered, “It is the one to whom I give this morsel after I have dipped it.” Then he dipped the morsel and gave it to Judas Iscariot, the son of Simon. ");
INSERT INTO engtcent_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","After Judas took the morsel, Satan entered into him. Then Jesus said to him, “What yoʋ are about to do, do quickly.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Now no one at the table knew why he said this to him. ");
INSERT INTO engtcent_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Some were thinking, since Judas had the moneybag, that Jesus was saying to him, “Buy what we need for the feast,” or that he should give something to the poor.) ");
INSERT INTO engtcent_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","As soon as Judas took the morsel, he went out. And it was night. ");
INSERT INTO engtcent_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","When Judas had gone out, Jesus said, “Now the Son of Man is glorified, and God is glorified in him. ");
INSERT INTO engtcent_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","And if God is glorified in him, God will also glorify the Son in himself, and will glorify him immediately. ");
INSERT INTO engtcent_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Little children, I am with you for a little while longer. You will seek me, and just as I said to the Jews, now I say to you also, ‘Where I am going, you cannot come.’ ");
INSERT INTO engtcent_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","I give you a new commandment, that you love one another. Just as I have loved you, so you must love one another. ");
INSERT INTO engtcent_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","By this everyone will know that you are my disciples, if you have love for one another.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter said to him, “Lord, where are yoʋ going?” Jesus answered him, “Yoʋ cannot follow me now to the place where I am going, but afterward yoʋ will follow me.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter said to him, “Lord, why can I not follow yoʋ now? I will lay down my life for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus answered him, “Yoʋ will lay down yoʋr life for me? Truly, truly, I say to yoʋ, a rooster will certainly not crow until yoʋ have denied me three times.” ");
INSERT INTO engtcent_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Let not your hearts be troubled. Believe in God; believe also in me. ");
INSERT INTO engtcent_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In my Father's house there are many rooms. If it were not so, I would have told you. I am going there to prepare a place for you. ");
INSERT INTO engtcent_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","So when I go, it is to prepare a place for you. I will come again and receive you to myself, so that where I am you also may be. ");
INSERT INTO engtcent_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","You know where I am going, and you know the way.” ");
INSERT INTO engtcent_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas said to him, “Lord, we do not know where yoʋ are going, so how can we know the way?” ");
INSERT INTO engtcent_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus said to him, “I am the way, the truth, and the life. No one comes to the Father except through me. ");
INSERT INTO engtcent_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","If you had known me, you would have known my Father also. From now on you do know him and have seen him.” ");
INSERT INTO engtcent_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip said to him, “Lord, show us the Father, and that will be enough for us.” ");
INSERT INTO engtcent_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus said to him, “Have I been with you for so long and still yoʋ do not know me, Philip? Anyone who has seen me has seen the Father, so how can yoʋ say, ‘Show us the Father’? ");
INSERT INTO engtcent_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Do yoʋ not believe that I am in the Father and the Father is in me? The words that I speak to you I do not speak on my own authority, but the Father who abides in me does his works. ");
INSERT INTO engtcent_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Believe me that I am in the Father and the Father is in me; but if not, believe me because of the works themselves. ");
INSERT INTO engtcent_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Truly, truly, I say to you, whoever believes in me will also do the works that I do. He will even do greater works than these, because I am going to my Father. ");
INSERT INTO engtcent_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Whatever you ask in my name I will do, so that the Father may be glorified in the Son. ");
INSERT INTO engtcent_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","If you ask me anything in my name, I will do it. ");
INSERT INTO engtcent_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“If you love me, keep my commandments. ");
INSERT INTO engtcent_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","And I will ask the Father, and he will give you another Helper to abide with you forever— ");
INSERT INTO engtcent_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","the Spirit of truth, whom the world cannot receive, because it does not see him or know him. But you know him, because he abides with you and will be in you. ");
INSERT INTO engtcent_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“I will not leave you as orphans; I am coming back to you. ");
INSERT INTO engtcent_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yet a little while and the world will see me no longer, but you will see me. Because I live, you also will live. ");
INSERT INTO engtcent_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","On that day you will know that I am in my Father, and you are in me, and I am in you. ");
INSERT INTO engtcent_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Whoever has my commandments and keeps them is the one who loves me. He who loves me will be loved by my Father, and I will love him and manifest myself to him.” ");
INSERT INTO engtcent_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (not Iscariot) said to him, “Lord, what has happened that yoʋ are about to manifest yoʋrself to us and not to the world?” ");
INSERT INTO engtcent_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus answered him, “If anyone loves me, he will keep my word. My Father will love him, and we will come to him and make our home with him. ");
INSERT INTO engtcent_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Whoever does not love me does not keep my words. The word that you hear is not mine, but the Father's who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“I have said these things to you while abiding with you. ");
INSERT INTO engtcent_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","But the Helper, the Holy Spirit, whom the Father will send in my name, will teach you everything and remind you of everything I have told you. ");
INSERT INTO engtcent_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Peace I leave with you; my peace I give to you. Not as the world gives do I give to you. Let not your hearts be troubled, neither let them be afraid. ");
INSERT INTO engtcent_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","You heard me say to you, ‘I am going away and coming back to you.’ If you loved me, you would have rejoiced that I said, ‘I am going to the Father,’ because my Father is greater than I am. ");
INSERT INTO engtcent_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","I have told you now before it happens, so that when it does happen, you may believe. ");
INSERT INTO engtcent_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","I will not talk with you much longer, for the ruler of the world is coming, but he has no power over me. ");
INSERT INTO engtcent_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Rather, I do just as the Father has commanded me, so that the world may know that I love the Father. Rise, let us go from here. ");
INSERT INTO engtcent_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“I am the true vine, and my Father is the vinedresser. ");
INSERT INTO engtcent_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Every branch in me that does not bear fruit he takes away, and every branch that does bear fruit he prunes so that it will bear more fruit. ");
INSERT INTO engtcent_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","You have already been pruned by the word I have spoken to you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Abide in me, and I will abide in you. As the branch cannot bear fruit by itself unless it abides in the vine, neither can you bear fruit unless you abide in me. ");
INSERT INTO engtcent_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","I am the vine; you are the branches. Whoever abides in me, and I in him, bears much fruit, because apart from me you can do nothing. ");
INSERT INTO engtcent_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","If anyone does not abide in me, he is thrown out like a branch and withers. Such branches are gathered up, thrown into the fire, and burned. ");
INSERT INTO engtcent_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","If you abide in me and my words abide in you, you will ask for whatever you wish, and it will be done for you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","My Father is glorified when you bear much fruit, and by doing so you will be my disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Just as the Father has loved me, so have I loved you; abide in my love. ");
INSERT INTO engtcent_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","If you keep my commandments, you will abide in my love, just as I have kept my Father's commandments and abide in his love. ");
INSERT INTO engtcent_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","I have told you these things so that my joy may abide in you, and so that your joy may be full. ");
INSERT INTO engtcent_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“This is my commandment, that you love one another, just as I have loved you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","No one has greater love than this, that he lay down his life for his friends. ");
INSERT INTO engtcent_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","You are my friends if you do whatever I command you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","No longer do I call you servants, because a servant does not know what his master is doing; but I have called you friends, because I have made known to you everything I heard from my Father. ");
INSERT INTO engtcent_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","You did not choose me, but I chose you and appointed you that you should go and bear fruit, and that your fruit should abide, so that whatever you ask of the Father in my name he will give you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","I am giving you these commands so that you may love one another. ");
INSERT INTO engtcent_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“If the world hates you, know that it hated me before it hated you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","If you were of the world, the world would love you as its own. However, because you are not of the world, but I have chosen you out of the world, the world hates you. ");
INSERT INTO engtcent_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Remember what I told you: ‘A servant is not greater than his master.’ If they persecuted me, they will persecute you also. If they kept my word, they will keep yours also. ");
INSERT INTO engtcent_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","But they will do all these things to you on account of my name, because they do not know him who sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","If I had not come and spoken to them, they would have no sin, but now they have no excuse for their sin. ");
INSERT INTO engtcent_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Whoever hates me hates my Father also. ");
INSERT INTO engtcent_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","If I had not done among them the works that no one else had done, they would have no sin, but now they have seen and hated both me and my Father. ");
INSERT INTO engtcent_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","But this has happened to fulfill what is written in their law: ‘They hated me for no reason.’ ");
INSERT INTO engtcent_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“When the Helper comes, whom I will send you from the Father, the Spirit of truth who proceeds from the Father, he will testify about me. ");
INSERT INTO engtcent_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","You must also testify, because you have been with me from the beginning. ");
INSERT INTO engtcent_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“I have said these things to you so that you will not fall away. ");
INSERT INTO engtcent_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","They will put you out of the synagogues; indeed, an hour is coming when anyone who kills you will think he is offering service to God. ");
INSERT INTO engtcent_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","They will do these things because they have not known the Father or me. ");
INSERT INTO engtcent_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","But I have said these things to you so that when the hour comes you will remember that I said them to you. I did not say these things to you from the beginning, because I was with you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“But now I am going to him who sent me, yet none of you asks me, ‘Where are yoʋ going?’ ");
INSERT INTO engtcent_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Rather, sorrow has filled your hearts because I have said these things to you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","But I tell you the truth, it is to your advantage that I go away, for if I do not go away, the Helper will not come to you. But if I do go, I will send him to you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","And when he comes, he will convict the world concerning sin, righteousness, and judgment: ");
INSERT INTO engtcent_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","concerning sin, because they do not believe in me; ");
INSERT INTO engtcent_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","concerning righteousness, because I am going to my Father, and you will no longer see me; ");
INSERT INTO engtcent_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","and concerning judgment, because the ruler of this world has been condemned. ");
INSERT INTO engtcent_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“I still have many things to say to you, but you cannot bear them now. ");
INSERT INTO engtcent_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","When the Spirit of truth comes, he will guide you into all truth, for he will not speak on his own authority, but whatever he hears he will speak, and he will declare to you what is to come. ");
INSERT INTO engtcent_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","He will glorify me, for he will receive from me what is mine and declare it to you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","All that the Father has is mine. That is why I said that the Spirit will receive from me what is mine and declare it to you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“In a little while you will not see me; and again after a little while, you will see me, for I am going to the Father.” ");
INSERT INTO engtcent_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Then some of his disciples said to one another, “What does he mean by saying to us, ‘In a little while you will not see me; and again after a little while, you will see me,’ and, ‘for I am going to the Father’?” ");
INSERT INTO engtcent_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","So they kept saying, “What does he mean by saying, ‘a little while’? We do not know what he is talking about.” ");
INSERT INTO engtcent_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus knew that they wanted to ask him about this, so he said to them, “Are you asking one another what I meant when I said, ‘In a little while, you will not see me; and again after a little while, you will see me’? ");
INSERT INTO engtcent_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Truly, truly, I say to you, you will weep and lament, but the world will rejoice. You will be sorrowful, but your sorrow will turn to joy. ");
INSERT INTO engtcent_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","When a woman is giving birth, she has pain because her hour has come. But when her baby is born, she no longer remembers the anguish because of her joy that a child has been born into the world. ");
INSERT INTO engtcent_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","So you also have sorrow now, but I will see you again, and your hearts will rejoice, and no one will take your joy away from you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","In that day you will ask nothing of me. Truly, truly, I say to you, whatever you ask of the Father in my name he will give you. ");
INSERT INTO engtcent_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Until now you have not asked for anything in my name. Ask, and you will receive, so that your joy may be full. ");
INSERT INTO engtcent_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“I have told you these things in figures of speech, but an hour is coming when I will no longer use figures of speech but will tell you plainly about the Father. ");
INSERT INTO engtcent_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","In that day you will ask in my name, and I do not say to you that I will ask the Father on your behalf, ");
INSERT INTO engtcent_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","for the Father himself loves you, because you have loved me and have come to believe that I came from God. ");
INSERT INTO engtcent_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","I came from the Father and have come into the world, and now I am leaving the world and going to the Father.” ");
INSERT INTO engtcent_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","His disciples said to him, “Behold, now yoʋ are speaking plainly and not using any figure of speech. ");
INSERT INTO engtcent_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now we know that yoʋ know all things and have no need for anyone to question yoʋ; because of this we believe that yoʋ came from God.” ");
INSERT INTO engtcent_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus answered them, “Now do you believe? ");
INSERT INTO engtcent_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Behold, an hour is coming, and has now come, when you will be scattered, each to yoʋr own home, and will leave me all alone. Yet I am not alone, for the Father is with me. ");
INSERT INTO engtcent_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","I have said these things to you so that in me you may have peace. In the world you will have tribulation, but take heart; I have overcome the world.” ");
INSERT INTO engtcent_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","After saying these things, Jesus lifted up his eyes to heaven and said, “Father, the hour has come; glorify yoʋr Son so that yoʋr Son may also glorify yoʋ, ");
INSERT INTO engtcent_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","just as yoʋ have given him authority over all flesh, to give eternal life to everyone yoʋ have given him. ");
INSERT INTO engtcent_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","This is eternal life, that they may know yoʋ, the only true God, and Jesus Christ whom yoʋ have sent. ");
INSERT INTO engtcent_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I have glorified yoʋ on earth. I have completed the work yoʋ have given me to do. ");
INSERT INTO engtcent_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","And now, Father, glorify me in yoʋr presence with the glory I had with yoʋ before the world existed. ");
INSERT INTO engtcent_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“I have revealed yoʋr name to the people yoʋ have given me out of the world. They were yoʋrs; yoʋ gave them to me, and they have kept yoʋr word. ");
INSERT INTO engtcent_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","They now know that everything yoʋ have given me is from yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","For I have given them the words that yoʋ gave me, and they have received them and truly know that I came from yoʋ. They have also come to believe that yoʋ sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","I ask on their behalf; I do not ask on behalf of the world, but on behalf of those yoʋ have given me, for they are yoʋrs. ");
INSERT INTO engtcent_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","All who are mine are also yoʋrs, and all who are yoʋrs are also mine, and I have been glorified in them. ");
INSERT INTO engtcent_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","I will no longer remain in the world, but they are in the world, and I am coming to yoʋ. Holy Father, keep them in yoʋr name, which yoʋ have given me, so that they may be one, just as we are one. ");
INSERT INTO engtcent_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","While I was with them in the world, I kept them safe by the power of yoʋr name. I have guarded those yoʋ have given me, and not one of them has perished except the son of destruction, so that the Scripture might be fulfilled. ");
INSERT INTO engtcent_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","But now I am coming to yoʋ, and I speak these things in the world so that they may have my joy made full within them. ");
INSERT INTO engtcent_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","I have given them yoʋr word, and the world has hated them because they are not of the world, just as I am not of the world. ");
INSERT INTO engtcent_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I do not ask yoʋ to take them out of the world, but to keep them from the evil one. ");
INSERT INTO engtcent_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","They are not of the world, just as I am not of the world. ");
INSERT INTO engtcent_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sanctify them by yoʋr truth; yoʋr word is truth. ");
INSERT INTO engtcent_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Just as yoʋ have sent me into the world, so I have sent them into the world. ");
INSERT INTO engtcent_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","For their sakes I sanctify myself, so that they too may be sanctified by the truth. ");
INSERT INTO engtcent_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“I do not ask on behalf of them alone, but also on behalf of those who will believe in me through their word, ");
INSERT INTO engtcent_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","that they may all be one, just as yoʋ, Father, are in me, and I am in yoʋ, that they also may be one in us, so that the world may believe that yoʋ sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","I have given them the glory that yoʋ gave me, so that they may be one, just as we are one, ");
INSERT INTO engtcent_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I in them and yoʋ in me, so that they may be perfected into one, and so that the world may know that yoʋ have sent me and have loved them just as yoʋ have loved me. ");
INSERT INTO engtcent_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Father, I want those yoʋ have given me to be with me where I am, so that they may see my glory, which yoʋ gave me because yoʋ loved me before the foundation of the world. ");
INSERT INTO engtcent_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Righteous Father, though the world does not know yoʋ, I know yoʋ, and these men know that yoʋ have sent me. ");
INSERT INTO engtcent_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","I have made yoʋr name known to them, and will continue to make it known, so that the love with which yoʋ have loved me may be in them, and so that I may be in them.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","After saying these things, Jesus went out with his disciples across the Kidron Valley, where there was a garden, which he entered along with his disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Now Judas, who betrayed him, also knew the place, because Jesus had often met there with his disciples. ");
INSERT INTO engtcent_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","So Judas took a cohort of soldiers and officers from the chief priests and Pharisees, and they went there with lanterns, torches, and weapons. ");
INSERT INTO engtcent_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Then Jesus, knowing everything that would happen to him, went out and said to them, “Who are you looking for?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","They answered him, “Jesus of Nazareth.” Jesus said to them, “I am he.” (Judas, who betrayed him, was also standing with them.) ");
INSERT INTO engtcent_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","When Jesus said to them, “I am he,” they drew back and fell to the ground. ");
INSERT INTO engtcent_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","So again he asked them, “Who are you looking for?” They said, “Jesus of Nazareth.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus answered, “I told you that I am he. So if you are looking for me, let these men go.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","He said this to fulfill the word he had spoken: “I have not lost a single one of those yoʋ have given me.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Then Simon Peter, who had a sword, drew it and struck the high priest's servant, cutting off his right ear. (The servant's name was Malchus.) ");
INSERT INTO engtcent_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","But Jesus said to Peter, “Put yoʋr sword back in its sheath; shall I not drink the cup the Father has given me?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Then the cohort of soldiers, along with its commander and the Jewish officers, arrested Jesus, bound him, ");
INSERT INTO engtcent_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","and led him away first to Annas, for he was the father-in-law of Caiaphas, who was high priest that year. ");
INSERT INTO engtcent_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(It was Caiaphas who had advised the Jews that it was better for one man to perish for the people.) ");
INSERT INTO engtcent_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Now Simon Peter was following Jesus, as was the other disciple. That disciple was known to the high priest, so he went with Jesus into the high priest's courtyard, ");
INSERT INTO engtcent_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","but Peter stood outside at the gate. So the other disciple, who was known to the high priest, went out, spoke to the gatekeeper, and brought Peter in. ");
INSERT INTO engtcent_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Then the servant girl who was the gatekeeper said to Peter, “Yoʋ are not also one of this man's disciples, are yoʋ?” He said, “I am not.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","(Now the servants and the officers had made a charcoal fire, because it was cold, and they were standing there warming themselves. Peter was also standing with them, warming himself.) ");
INSERT INTO engtcent_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Meanwhile, the high priest questioned Jesus about his disciples and his teaching. ");
INSERT INTO engtcent_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus answered him, “I have spoken openly to the world. I have always taught in the synagogues and in the temple courts, where the Jews always assemble together. I have said nothing in secret. ");
INSERT INTO engtcent_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Why do yoʋ question me? Question those who heard what I said to them. Behold, they know what I said.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","When Jesus said this, one of the officers standing nearby slapped him and said, “Is that how yoʋ answer the high priest?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus answered him, “If I have spoken wrongly, testify as to what was wrong; but if I have spoken well, why are yoʋ hitting me?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","(Annas had sent him bound to Caiaphas the high priest.) ");
INSERT INTO engtcent_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Meanwhile, Simon Peter was standing and warming himself. So they said to him, “Yoʋ are not also one of his disciples, are yoʋ?” He denied it and said, “I am not.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","But one of the servants of the high priest, who was a relative of the man whose ear Peter had cut off, said, “Did I not see yoʋ with him in the garden?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter denied it again, and immediately a rooster crowed. ");
INSERT INTO engtcent_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Then the Jews led Jesus away from Caiaphas to the governor's headquarters. It was now early in the morning. They themselves did not go into the governor's headquarters so that they would not be defiled, but could eat the Passover. ");
INSERT INTO engtcent_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","So Pilate went out to them and said, “What accusation do you bring against this man?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","They answered him, “If he were not an evildoer, we would not have handed him over to yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate said to them, “You take him and judge him according to your own law.” The Jews said to him, “It is not lawful for us to put anyone to death.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(This happened to fulfill what Jesus had said when he indicated the kind of death he was going to die.) ");
INSERT INTO engtcent_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Then Pilate went into his headquarters again, called Jesus over, and said to him, “Are yoʋ the king of the Jews?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus answered him, “Do yoʋ say this of yoʋr own accord, or have others spoken to yoʋ about me?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate answered, “Am I a Jew? Yoʋr own nation and the chief priests have handed yoʋ over to me. What have yoʋ done?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus answered, “My kingdom is not of this world. If my kingdom were of this world, my servants would be fighting to keep me from being delivered up to the Jews. But as it is, my kingdom is not from here.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate said to him, “So yoʋ are a king?” Jesus answered, “Yoʋ have said yoʋrself that I am a king. The reason I was born and the reason I came into the world is to testify to the truth. Everyone who is of the truth listens to my voice.” ");
INSERT INTO engtcent_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate said to him, “What is truth?” After he said this, he again went out to the Jews and said to them, “I find no fault in him. ");
INSERT INTO engtcent_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","But you have a custom that I release for you one man at the Passover. So do you want me to release for you the king of the Jews?” ");
INSERT INTO engtcent_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","They all cried out again, “Not this man, but Barabbas!” (Now Barabbas was an insurrectionist.) ");
INSERT INTO engtcent_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Then Pilate took Jesus and flogged him. ");
INSERT INTO engtcent_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","The soldiers twisted together a crown of thorns, put it on his head, and then clothed him with a purple garment. ");
INSERT INTO engtcent_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","They kept saying, “Hail, King of the Jews!” and striking him in the face. ");
INSERT INTO engtcent_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Once again Pilate came out and said to the Jews, “Behold, I am bringing him out to you so that you may know that I find no fault in him.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesus then came out wearing the crown of thorns and the purple garment, and Pilate said to them, “Behold, the man!” ");
INSERT INTO engtcent_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","When the chief priests and the officers saw him, they cried out, “Crucify, crucify him!” But Pilate said to them, “You take him and crucify him, for I find no fault in him.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","The Jews answered him, “We have a law, and according to our law he must die, for he made himself out to be the Son of God.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","When Pilate heard this, he was even more afraid. ");
INSERT INTO engtcent_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","He went back into his headquarters and said to Jesus, “Where are yoʋ from?” But Jesus gave him no answer. ");
INSERT INTO engtcent_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","So Pilate said to him, “Yoʋ do not speak to me? Do yoʋ not know that I have authority to crucify yoʋ, and authority to release yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus answered, “Yoʋ would have no authority over me if it had not been given to yoʋ from above. Therefore he who handed me over to yoʋ has greater sin.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","From that point forward Pilate was seeking to release him, but the Jews cried out, “If yoʋ release this man, yoʋ are not a friend of Caesar; everyone who makes himself out to be a king opposes Caesar.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","When Pilate heard this, he brought Jesus out and sat down on the judgment seat at a place called the Stone Pavement (or in Hebrew, Gabbatha). ");
INSERT INTO engtcent_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","It was about the sixth hour on the day of Preparation for the Passover, and he said to the Jews, “Behold, your king!” ");
INSERT INTO engtcent_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","But they cried out, “Away with him, away with him, crucify him!” Pilate said to them, “Shall I crucify your king?” The chief priests answered, “We have no king but Caesar.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Then Pilate handed Jesus over to them to be crucified. So they took Jesus and led him away. ");
INSERT INTO engtcent_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Carrying his own cross, he went out to a location called the Place of the Skull (which in Hebrew is called Golgotha). ");
INSERT INTO engtcent_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","There they crucified him, and with him two others, one on each side, with Jesus in the middle. ");
INSERT INTO engtcent_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate also wrote a notice and put it on the cross. It read, “Jesus of Nazareth, the King of the Jews.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Many of the Jews read this notice, because the place where Jesus was crucified was near the city, and it was written in Hebrew, Greek, and Latin. ");
INSERT INTO engtcent_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Then the chief priests of the Jews said to Pilate, “Do not write, ‘The King of the Jews,’ but rather, ‘This man said, “I am the king of the Jews.” ’ ” ");
INSERT INTO engtcent_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate answered, “What I have written, I have written.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","When the soldiers crucified Jesus, they took his garments and divided them into four parts, a part for each soldier. They also took his tunic, which was seamless. It was woven in one piece from top to bottom, ");
INSERT INTO engtcent_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","so they said to one another, “Let us not tear it apart, but cast lots for it to decide whose it will be.” This happened to fulfill the Scripture that says, “They divided my garments among themselves, and for my clothing they cast lots.” This is what the soldiers did. ");
INSERT INTO engtcent_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Standing by the cross of Jesus were his mother, his mother's sister, Mary the wife of Clopas, and Mary Magdalene. ");
INSERT INTO engtcent_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","When Jesus saw his mother and the disciple whom he loved standing nearby, he said to his mother, “Woman, behold, yoʋr son.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Then he said to the disciple, “Behold, yoʋr mother.” And from that hour the disciple took her into his own home. ");
INSERT INTO engtcent_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","After this, when Jesus saw that everything was now finished, in order to fulfill the Scripture he said, “I am thirsty.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A jar full of sour wine was there, so they filled a sponge with sour wine, put it around a hyssop branch, and brought it up to his mouth. ");
INSERT INTO engtcent_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","When Jesus had received the sour wine, he said, “It is finished.” Then he bowed his head and gave up his spirit. ");
INSERT INTO engtcent_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Since it was the day of Preparation (for that Sabbath was a high day), the Jews asked Pilate to have the men's legs broken and their bodies taken away, so that the bodies would not remain on the cross on the Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","So the soldiers came and broke the legs of the first man and of the other who had been crucified with him. ");
INSERT INTO engtcent_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","But when they came to Jesus, they did not break his legs since they saw that he was already dead. ");
INSERT INTO engtcent_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Instead, one of the soldiers pierced Jesus' side with a spear, and immediately blood and water came out. ");
INSERT INTO engtcent_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","He who saw this has testified, and his testimony is true, and he knows that he speaks what is true, so that you may believe. ");
INSERT INTO engtcent_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","For these things happened so that the Scripture would be fulfilled: “No bone of his will be broken.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","And, as another Scripture says, “They will look on him whom they have pierced.” ");
INSERT INTO engtcent_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","After these things, Joseph of Arimathea, who was a disciple of Jesus (but secretly for fear of the Jews), asked Pilate if he could take away Jesus' body. Pilate gave him permission, so he came and took away the body. ");
INSERT INTO engtcent_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","With him came Nicodemus (who had previously come to Jesus by night). He brought a mixture of myrrh and aloes that weighed about seventy-five pounds. ");
INSERT INTO engtcent_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","So they took Jesus' body and wrapped it in linen cloths with the spices, as is the custom of the Jews in preparing a body for burial. ");
INSERT INTO engtcent_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Near the place where Jesus was crucified there was a garden, and in the garden there was a new tomb in which no one had ever been laid. ");
INSERT INTO engtcent_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Because it was the Jewish day of Preparation and since the tomb was nearby, they laid Jesus there. ");
INSERT INTO engtcent_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","On the first day of the week, Mary Magdalene came to the tomb early, while it was still dark, and she saw that the stone had been moved away from the tomb. ");
INSERT INTO engtcent_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","So she ran and went to Simon Peter and the other disciple, the one whom Jesus loved, and said to them, “They have taken the Lord out of the tomb, and we do not know where they have laid him.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","So Peter went out, along with the other disciple, and they began making their way to the tomb. ");
INSERT INTO engtcent_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","The two were running together, but the other disciple outran Peter and reached the tomb first. ");
INSERT INTO engtcent_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Stooping down to look in, he saw the linen cloths lying there, but he did not go in. ");
INSERT INTO engtcent_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Then Simon Peter, who had been following him, arrived and went into the tomb. He saw the linen cloths lying there ");
INSERT INTO engtcent_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","and the facecloth that had been on Jesus' head. But it was not lying with the linen cloths; it was folded up separately in another place. ");
INSERT INTO engtcent_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Then the other disciple, who had reached the tomb first, also went in. He saw and believed. ");
INSERT INTO engtcent_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(For they did not yet understand the Scripture that Jesus must rise from the dead.) ");
INSERT INTO engtcent_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Then the disciples went back to their homes. ");
INSERT INTO engtcent_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","But Mary stood near the tomb, weeping outside. As she was weeping, she stooped down to look into the tomb ");
INSERT INTO engtcent_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","and saw two angels in white sitting where Jesus' body had been laid, one at the head and one at the feet. ");
INSERT INTO engtcent_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","They said to her, “Woman, why are yoʋ weeping?” She said to them, “They have taken away my Lord, and I do not know where they have laid him.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","After saying this, she turned around and saw Jesus standing there, but she did not know it was Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus said to her, “Woman, why are yoʋ weeping? Who are yoʋ looking for?” Supposing that he was the gardener, she said to him, “Sir, if yoʋ have carried him away, tell me where yoʋ have laid him, and I will take him away.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus said to her, “Mary!” She turned and said to him, “Rabboni!” (which means “Teacher”). ");
INSERT INTO engtcent_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus said to her, “Do not hold on to me, for I have not yet ascended to my Father. But go to my brothers and tell them that I am ascending to my Father and your Father, to my God and your God.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","So Mary Magdalene went and told the disciples that she had seen the Lord and that he had said these things to her. ");
INSERT INTO engtcent_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","In the evening of that day, the first day of the week, when the disciples were gathered together with the doors locked for fear of the Jews, Jesus came and stood among them and said to them, “Peace be with you.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","After saying this, he showed them his hands and his side, and the disciples rejoiced when they saw the Lord. ");
INSERT INTO engtcent_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Again Jesus said to them, “Peace be with you. As the Father has sent me, so I am sending you.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","After saying this, he breathed on them and said to them, “Receive the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","If you remit the sins of any, their sins are remitted; if you retain the sins of any, their sins are retained.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Now Thomas (called Didymus), one of the twelve, was not with them when Jesus came. ");
INSERT INTO engtcent_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","So the other disciples said to him, “We have seen the Lord.” But he said to them, “Unless I see the nail marks in his hands and put my finger where the nails were, and put my hand into his side, I will certainly not believe.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Eight days later, Jesus' disciples were again inside, and Thomas was with them. Although the doors were locked, Jesus came and stood among them and said, “Peace be with you.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Then he said to Thomas, “Put yoʋr finger here and look at my hands. Reach out yoʋr hand and put it into my side. Do not doubt but believe.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","In response Thomas said to him, “My Lord and my God!” ");
INSERT INTO engtcent_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Then Jesus said to him, “Because yoʋ have seen me, have yoʋ come to believe? Blessed are those who have not seen and yet have come to believe.” ");
INSERT INTO engtcent_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus performed many other signs in the presence of his disciples, which are not written in this book. ");
INSERT INTO engtcent_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","But these have been written so that you may believe that Jesus is the Christ, the Son of God, and that by believing you may have life in his name. ");
INSERT INTO engtcent_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","After this Jesus again manifested himself to the disciples, by the Sea of Tiberias. He manifested himself in this way: ");
INSERT INTO engtcent_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas (called Didymus), Nathanael (from Cana of Galilee), the sons of Zebedee, and two of Jesus' other disciples were together. ");
INSERT INTO engtcent_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter said to them, “I am going fishing.” They said to him, “We will go with yoʋ.” So they immediately went out and got into the boat, but that night they caught nothing. ");
INSERT INTO engtcent_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","When daybreak came, Jesus stood on the shore, but the disciples did not know it was Jesus. ");
INSERT INTO engtcent_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus said to them, “Children, have you caught any fish to eat?” They answered him, “No.” ");
INSERT INTO engtcent_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","He said to them, “Cast the net on the right side of the boat, and you will find some.” So they cast it and were unable to draw it in because of the large number of fish. ");
INSERT INTO engtcent_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Then the disciple whom Jesus loved said to Peter, “It is the Lord!” When Simon Peter heard that it was the Lord, he put on his outer garment (for he had taken it off) and plunged into the sea. ");
INSERT INTO engtcent_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","But the other disciples came in the boat, dragging the net full of fish, for they were not far from shore, only about a hundred yards away. ");
INSERT INTO engtcent_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","When they had gone ashore, they saw a charcoal fire there with a fish lying on it, and bread. ");
INSERT INTO engtcent_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus said to them, “Bring some of the fish you have just caught.” ");
INSERT INTO engtcent_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","So Simon Peter went aboard and drew the net ashore, full of large fish, one hundred fifty-three of them. Although there were so many, the net had not torn. ");
INSERT INTO engtcent_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Then Jesus said to them, “Come eat breakfast.” Now none of the disciples dared to ask him, “Who are yoʋ?” because they knew it was the Lord. ");
INSERT INTO engtcent_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Then Jesus came, took the bread, and gave it to them. He did likewise with the fish. ");
INSERT INTO engtcent_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","This was now the third time that Jesus had been revealed to his disciples after he had been raised from the dead. ");
INSERT INTO engtcent_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","When they had eaten breakfast, Jesus said to Simon Peter, “Simon, son of Jonah, do yoʋ love me more than these?” Peter said to him, “Yes, Lord, yoʋ know that I care for yoʋ.” Jesus said to him, “Feed my lambs.” ");
INSERT INTO engtcent_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus said to him a second time, “Simon, son of Jonah, do yoʋ love me?” Peter said to him, “Yes, Lord, yoʋ know that I care for yoʋ.” Jesus said to him, “Tend my sheep.” ");
INSERT INTO engtcent_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Then Jesus said to him the third time, “Simon, son of Jonah, do yoʋ care for me?” Peter was grieved that Jesus said to him the third time, “Do yoʋ care for me?” And he said to him, “Lord, yoʋ know everything; yoʋ know that I care for yoʋ.” Jesus said to him, “Feed my sheep. ");
INSERT INTO engtcent_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Truly, truly, I say to yoʋ, when yoʋ were younger, yoʋ would dress yoʋrself and walk wherever yoʋ wanted to go; but when yoʋ grow old, yoʋ will stretch out yoʋr hands, and another will dress yoʋ and bring yoʋ where yoʋ do not want to go.” ");
INSERT INTO engtcent_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(He said this to indicate the kind of death by which Peter would glorify God.) After saying this, he said to Peter, “Follow me.” ");
INSERT INTO engtcent_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Then Peter turned around and saw the disciple whom Jesus loved following them (the one who had leaned back on Jesus' chest at the supper and said, “Lord, who is it that is going to betray yoʋ?”) ");
INSERT INTO engtcent_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","When Peter saw him, he said to Jesus, “Lord, what about him?” ");
INSERT INTO engtcent_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus said to him, “If I wish for him to remain until I come, what is that to yoʋ? Yoʋ follow me!” ");
INSERT INTO engtcent_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","So the rumor spread among the brothers that this disciple would not die. Yet Jesus did not tell him that he would not die; he only said, “If I wish for him to remain until I come, what is that to yoʋ?” ");
INSERT INTO engtcent_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","This is the disciple who is testifying about these things and who has written these things, and we know that his testimony is true. ");
INSERT INTO engtcent_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","There are also many other things that Jesus did. If every one of them were to be written down, I suppose that not even the world itself would have room for the books that would be written. Amen. ");
INSERT INTO engtcent_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","The first account I compiled, O Theophilus, was about all that Jesus began to do and teach ");
INSERT INTO engtcent_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","until the day he was taken up, after he had given commands through the Holy Spirit to the apostles he had chosen. ");
INSERT INTO engtcent_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","He presented himself alive to them, after his suffering, by many convincing proofs, appearing to them over the course of forty days and speaking about the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","While he was with them, he commanded them not to depart from Jerusalem, but to wait for the promise of the Father, “Which,” he said, “you heard about from me. ");
INSERT INTO engtcent_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","For John baptized with water, but you will be baptized with the Holy Spirit not many days from now.” ");
INSERT INTO engtcent_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","So when they had come together, they asked him, “Lord, are yoʋ going to restore the kingdom to Israel at this time?” ");
INSERT INTO engtcent_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","He said to them, “It is not for you to know the times or seasons that the Father has set by his own authority, ");
INSERT INTO engtcent_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","but you will receive power when the Holy Spirit comes upon you, and you will be witnesses to me in Jerusalem, in all Judea and Samaria, and to the ends of the earth.” ");
INSERT INTO engtcent_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","After he said this, he was lifted up as they looked on, and a cloud took him out of their sight. ");
INSERT INTO engtcent_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","As he went, they were gazing up into the sky, when behold, two men in white clothing stood beside them. ");
INSERT INTO engtcent_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","They said, “Men of Galilee, why are you standing here staring into the sky? This Jesus who was taken up from you into heaven will come back in the same way you have seen him go into heaven.” ");
INSERT INTO engtcent_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Then they returned to Jerusalem from the mount called Olivet, which is near Jerusalem, a Sabbath day's journey away. ");
INSERT INTO engtcent_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","After entering the city, they went up to the upper room where they were staying. Those present were Peter, James, John, Andrew, Philip, Thomas, Bartholomew, Matthew, James the son of Alphaeus, Simon the Zealot, and Judas the son of James. ");
INSERT INTO engtcent_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","With one accord they were all devoting themselves to prayer and supplication, along with Jesus' brothers and several women, including Mary the mother of Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","In those days Peter stood up among the disciples (a crowd of about one hundred twenty people who were gathered together). He said, ");
INSERT INTO engtcent_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Brothers, it was necessary for this Scripture to be fulfilled, which the Holy Spirit foretold by the mouth of David concerning Judas, who became a guide to those who arrested Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","For he was numbered with us and received his share in this ministry.” ");
INSERT INTO engtcent_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Now this man Judas had acquired a field with the wages of unrighteousness, and falling headfirst, his body burst open, and all his intestines gushed out. ");
INSERT INTO engtcent_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","This became known to all who were dwelling in Jerusalem, so that in their language the field was called Akeldama, that is, Field of Blood.) ");
INSERT INTO engtcent_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peter continued, “For it is written in the Book of Psalms: ‘May his homestead become desolate; let there be no one to dwell in it,’ and, ‘May another take his position as overseer.’ ");
INSERT INTO engtcent_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Therefore, one of the men who have accompanied us during the entire time that the Lord Jesus went in and out among us, ");
INSERT INTO engtcent_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","beginning from the baptism of John up to the day when Jesus was taken up from us, must become a witness with us of his resurrection.” ");
INSERT INTO engtcent_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","So they put forward two men, Joseph called Barsabas (who was given the name Justus), and Matthias. ");
INSERT INTO engtcent_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Then they prayed, “Lord, yoʋ know the hearts of all; show us which of these two men yoʋ have chosen ");
INSERT INTO engtcent_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","to receive the share of this ministry and apostleship from which Judas turned away to go to his own place.” ");
INSERT INTO engtcent_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Then they cast lots for them, and the lot fell to Matthias, so he was added to the eleven apostles. ");
INSERT INTO engtcent_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","When the day of Pentecost came, they were all in the same place with one accord. ");
INSERT INTO engtcent_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Suddenly a sound like a mighty rushing wind came from heaven, and it filled the whole house where they were sitting. ");
INSERT INTO engtcent_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Divided tongues that looked like fire appeared to them and rested on each one of them. ");
INSERT INTO engtcent_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Then they were all filled with the Holy Spirit and began speaking in other tongues as the Spirit enabled them. ");
INSERT INTO engtcent_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Now there were devout Jews from every nation under heaven dwelling in Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","When this sound occurred, the multitude came together, and they were bewildered because each one of them heard his own language being spoken. ");
INSERT INTO engtcent_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","They were astonished and amazed, saying to one another, “Behold, are not all these who are speaking Galileans? ");
INSERT INTO engtcent_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","How then do we each hear them in our own native languages? ");
INSERT INTO engtcent_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthians, Medes, Elamites; those who dwell in Mesopotamia, Judea and Cappadocia, Pontus and Asia, ");
INSERT INTO engtcent_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia and Pamphylia, Egypt and the districts of Libya that are near Cyrene; visitors from Rome (both Jews and converts to Judaism), ");
INSERT INTO engtcent_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretans and Arabs—we hear them speaking about the mighty acts of God in our own tongues.” ");
INSERT INTO engtcent_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","And they were all amazed and greatly perplexed, saying to one another, “What could this mean?” ");
INSERT INTO engtcent_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","But others scoffed at the believers, saying, “They are filled with new wine.” ");
INSERT INTO engtcent_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Then Peter stood up with the eleven, lifted up his voice, and declared to them, “Men of Judea and all who dwell in Jerusalem, let this be known to you, and give ear to my words. ");
INSERT INTO engtcent_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","These men are not drunk, as you suppose, for it is only the third hour of the day. ");
INSERT INTO engtcent_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","But this is what was spoken through the prophet Joel: ");
INSERT INTO engtcent_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘In the last days, says God, I will pour out my Spirit upon all flesh. Your sons and your daughters will prophesy, your young men will see visions, and your old men will dream dreams. ");
INSERT INTO engtcent_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Even upon my male and female servants I will pour out my Spirit in those days, and they will prophesy. ");
INSERT INTO engtcent_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","I will perform wonders in the heavens above and signs on the earth below: blood, fire, and mist of smoke. ");
INSERT INTO engtcent_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","The sun will be turned to darkness and the moon to blood, before the coming of the great and glorious day of the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","And everyone who calls upon the name of the Lord will be saved.’ ");
INSERT INTO engtcent_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Men of Israel, listen to these words: Jesus of Nazareth, a man attested to you by God with miracles, wonders, and signs that God did through him in your midst, just as you yourselves well know, ");
INSERT INTO engtcent_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","this man, who was delivered up by the deliberate plan and foreknowledge of God, you took and put to death, having him nailed to the cross by the hands of lawless men. ");
INSERT INTO engtcent_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","But God raised him up, releasing him from the pangs of death, because it was impossible for death to keep its hold on him. ");
INSERT INTO engtcent_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","For David says about him, ‘I saw the Lord always before me, for he is at my right hand so that I will not be shaken. ");
INSERT INTO engtcent_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Therefore my heart was glad and my tongue rejoiced; moreover, my flesh will dwell in hope. ");
INSERT INTO engtcent_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","For yoʋ will not abandon my soul to Hades, nor will yoʋ let yoʋr Holy One see corruption. ");
INSERT INTO engtcent_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yoʋ have made known to me the paths of life; yoʋ will fill me with joy by yoʋr presence.’ ");
INSERT INTO engtcent_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Brothers, I can say to you with confidence concerning our patriarch David that he died and was buried, and his tomb is with us to this day. ");
INSERT INTO engtcent_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","So then, because he was a prophet and knew that God had sworn an oath to him that from among his descendants, according to the flesh, he would raise up the Christ to sit on his throne, ");
INSERT INTO engtcent_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David foresaw what would happen and spoke about the resurrection of the Christ, saying that his soul was not abandoned to Hades and that his flesh did not see corruption. ");
INSERT INTO engtcent_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","This Jesus God has raised up, of which we are all witnesses. ");
INSERT INTO engtcent_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Therefore, having been exalted to the right hand of God and having received from the Father the promise of the Holy Spirit, he has poured out this that you now see and hear. ");
INSERT INTO engtcent_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","For David did not ascend to heaven, but he himself says, ‘The Lord said to my Lord, “Sit at my right hand ");
INSERT INTO engtcent_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","until I make yoʋr enemies a footstool for yoʋr feet.” ’ ");
INSERT INTO engtcent_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Therefore, let all the house of Israel know with certainty that God has made him both Lord and Christ, this Jesus whom you crucified.” ");
INSERT INTO engtcent_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","When they heard this, they were pierced to the heart and said to Peter and the rest of the apostles, “Brothers, what should we do?” ");
INSERT INTO engtcent_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter said to them, “Repent and be baptized, each one of you, in the name of Jesus Christ for the remission of sins, and you will receive the gift of the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","For this promise is for you, for your children, and for all who are far off, as many as the Lord our God calls to himself.” ");
INSERT INTO engtcent_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","With many other words he testified and exhorted them, saying, “Be saved from this crooked generation.” ");
INSERT INTO engtcent_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Then those who gladly received his word were baptized, and about three thousand souls were added on that day. ");
INSERT INTO engtcent_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","And they devoted themselves to the teaching of the apostles and to fellowship, to the breaking of bread and to prayer. ");
INSERT INTO engtcent_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A sense of awe came upon every soul, and many wonders and signs were being done by the apostles. ");
INSERT INTO engtcent_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","All who believed were together and had all things in common. ");
INSERT INTO engtcent_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","They were selling their possessions and belongings, and distributing the proceeds to all, as anyone had need. ");
INSERT INTO engtcent_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Day by day as they continued meeting together with one accord in the temple courts and breaking bread from house to house, they shared food together with gladness and simplicity of heart, ");
INSERT INTO engtcent_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","praising God and enjoying the favor of all the people. And the Lord added to the church daily those who were being saved. ");
INSERT INTO engtcent_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","One day Peter and John were going up together to the temple at the hour of prayer, the ninth hour. ");
INSERT INTO engtcent_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","And a man who was lame from his mother's womb was being carried in. Every day people would lay him at the gate of the temple called the Beautiful Gate so that he could ask for alms from those who were entering the temple courts. ");
INSERT INTO engtcent_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","When he saw Peter and John about to enter the temple courts, he began asking them for alms. ");
INSERT INTO engtcent_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","But Peter, along with John, looked at him intently and said, “Look at us.” ");
INSERT INTO engtcent_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","So the man gave them his attention, expecting to receive something from them. ");
INSERT INTO engtcent_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","But Peter said, “I have no silver or gold, but what I do have I give to yoʋ. In the name of Jesus Christ of Nazareth, rise up and walk.” ");
INSERT INTO engtcent_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Then Peter took hold of him by the right hand and raised him up, and at once his feet and ankles were made strong. ");
INSERT INTO engtcent_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Leaping up, he stood and began walking. Then he entered the temple courts with them, walking and leaping and praising God. ");
INSERT INTO engtcent_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","When all the people saw him walking and praising God, ");
INSERT INTO engtcent_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","they recognized him as the man who used to sit at the Beautiful Gate of the temple asking for alms. And they were filled with wonder and amazement at what had happened to him. ");
INSERT INTO engtcent_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","As the lame man who had been healed clung to Peter and John, all the people ran together to them at the portico called Solomon's, utterly astonished. ");
INSERT INTO engtcent_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","When Peter saw this, he addressed the people: “Men of Israel, why are you amazed at this, or why are you staring at us as though by our own power or godliness we have made this man walk? ");
INSERT INTO engtcent_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","The God of Abraham, Isaac, and Jacob—the God of our fathers—has glorified his servant Jesus, whom you delivered up and denied in the presence of Pilate, even though Pilate had decided to release him. ");
INSERT INTO engtcent_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yes, you denied the Holy and Righteous One and asked for a murderer to be granted to you. ");
INSERT INTO engtcent_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","You put to death the Author of life, whom God raised from the dead, of which we are witnesses. ");
INSERT INTO engtcent_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","By faith in his name, his name has given strength to this man whom you see and know, and the faith that is through Jesus has given him this perfect health in the presence of you all. ");
INSERT INTO engtcent_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Now, brothers, I know that you acted in ignorance, as did your rulers also. ");
INSERT INTO engtcent_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","But in this way God fulfilled what he had foretold through the mouths of all his prophets, that the Christ would suffer. ");
INSERT INTO engtcent_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Therefore repent and turn back so that your sins may be wiped away, that times of refreshing may come from the presence of the Lord, ");
INSERT INTO engtcent_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","and that he may send Jesus, the Christ who has been appointed for you. ");
INSERT INTO engtcent_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Heaven must receive him until the time comes for the restoration of all things, which God declared by the mouths of all his holy prophets long ago. ");
INSERT INTO engtcent_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","For Moses said to our fathers, ‘The Lord your God will raise up for you a prophet like me from among your brothers. You must listen to everything he tells you. ");
INSERT INTO engtcent_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Every soul who does not listen to that prophet will be utterly destroyed from among the people.’ ");
INSERT INTO engtcent_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Indeed, all the prophets who have spoken, beginning with Samuel and continuing with those who came afterward, also proclaimed these days. ");
INSERT INTO engtcent_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","You are the sons of the prophets and of the covenant that God made with our fathers when he said to Abraham, ‘In yoʋr offspring all the families of the earth will be blessed.’ ");
INSERT INTO engtcent_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God raised up his servant Jesus and sent him first to you, to bless you by turning each of you from your evil ways.” ");
INSERT INTO engtcent_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","As Peter and John were speaking to the people, the priests, the captain of the temple guard, and the Sadducees came to them, ");
INSERT INTO engtcent_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","greatly annoyed because they were teaching the people and proclaiming in Jesus the resurrection from the dead. ");
INSERT INTO engtcent_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","So they arrested them and took them into custody until the next day, for it was already evening. ");
INSERT INTO engtcent_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","But many who heard the word believed, and the number of men who believed came to about five thousand. ");
INSERT INTO engtcent_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","On the next day, the rulers, elders, and scribes were gathered together in Jerusalem, ");
INSERT INTO engtcent_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","along with Annas the high priest, Caiaphas, John, Alexander, and all who were members of the high-priestly family. ");
INSERT INTO engtcent_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","After making Peter and John stand before them, they began to question them: “By what power or by what name did you do this?” ");
INSERT INTO engtcent_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Then Peter, filled with the Holy Spirit, said to them, “Rulers of the people and elders of Israel, ");
INSERT INTO engtcent_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","if we are being examined today about a good deed done to a disabled man and by what means he has been healed, ");
INSERT INTO engtcent_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","let it be known to you all, and to all the people of Israel, that this man is standing before you in good health by the name of Jesus Christ of Nazareth, whom you crucified and whom God raised from the dead. ");
INSERT INTO engtcent_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","This Jesus is the stone that was rejected by you, the builders, which has become the cornerstone. ");
INSERT INTO engtcent_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","There is salvation in no other, for there is no other name under heaven given among men by which we must be saved.” ");
INSERT INTO engtcent_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","When they saw the boldness of Peter and John, and when they realized that they were uneducated and untrained men, they were amazed and recognized that they had been with Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","But since they could see the man who had been healed standing there with them, they had nothing to say in opposition. ");
INSERT INTO engtcent_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","So they ordered Peter and John to step out from the Sanhedrin while they conferred with one another, ");
INSERT INTO engtcent_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","saying, “What should we do with these men? For it is evident to all who dwell in Jerusalem that a notable sign has been done through them, and we cannot deny it. ");
INSERT INTO engtcent_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","But so that it may not spread any further among the people, we will strictly warn them to speak no more in this name to any of the people.” ");
INSERT INTO engtcent_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Then they called them in and ordered them not to speak or teach at all in the name of Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","But Peter and John answered them, “Whether it is right in the sight of God to listen to you rather than to God, you must judge. ");
INSERT INTO engtcent_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","For we cannot help but speak about what we have seen and heard.” ");
INSERT INTO engtcent_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","So after threatening Peter and John further, they released them, finding no way to punish them, because all the people were glorifying God for what had happened. ");
INSERT INTO engtcent_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","For the man on whom this sign of healing had been performed was more than forty years old. ");
INSERT INTO engtcent_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","After being released, Peter and John went to their own people and reported all that the chief priests and the elders had said to them. ");
INSERT INTO engtcent_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","When they heard this, they lifted up their voices with one accord to God and said, “Master, yoʋ are God, who made the heavens, the earth, the sea, and all that is in them. ");
INSERT INTO engtcent_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","It is yoʋ who said through the mouth of yoʋr servant David, ‘Why do the nations rage, and the peoples plot foolish things? ");
INSERT INTO engtcent_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","The kings of the earth stand up, and the rulers are gathered together, against the Lord and against his Anointed.’ ");
INSERT INTO engtcent_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","For indeed both Herod and Pontius Pilate, along with the Gentiles and the people of Israel, were gathered together against yoʋr holy servant Jesus, whom yoʋ anointed, ");
INSERT INTO engtcent_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","to do whatever yoʋr hand and yoʋr plan had foreordained to take place. ");
INSERT INTO engtcent_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","And now, Lord, take note of their threats and grant it to yoʋr servants to speak yoʋr word with all boldness, ");
INSERT INTO engtcent_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","as yoʋ stretch out yoʋr hand to heal and to perform signs and wonders through the name of yoʋr holy servant Jesus.” ");
INSERT INTO engtcent_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","After they prayed, the place where they were gathered together was shaken, and they were all filled with the Holy Spirit and began speaking the word of God with boldness. ");
INSERT INTO engtcent_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Now the hearts and souls of the multitude of believers were one, and no one was saying that any of their belongings was his own, but everything they owned was held in common. ");
INSERT INTO engtcent_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","With great power the apostles were giving testimony to the resurrection of the Lord Jesus, and great grace was upon them all. ");
INSERT INTO engtcent_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","There was no one needy among them, for all who owned plots of land or houses sold them and brought the proceeds of what was sold. ");
INSERT INTO engtcent_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","They laid the money at the feet of the apostles, and the proceeds were distributed to anyone who had need. ");
INSERT INTO engtcent_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Joses, whom the apostles called Barnabas (which means “Son of Encouragement”), a Levite and Cypriot by birth, ");
INSERT INTO engtcent_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","also sold a field he owned and then brought the money and laid it at the apostles' feet. ");
INSERT INTO engtcent_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Now a man named Ananias, along with his wife Sapphira, sold a piece of property ");
INSERT INTO engtcent_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","and kept back some of the proceeds, with his wife also being aware of it. He brought a portion of the proceeds and laid it at the apostles' feet. ");
INSERT INTO engtcent_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","But Peter said, “Ananias, why has Satan filled yoʋr heart to lie to the Holy Spirit and keep back some of the proceeds of the plot of land? ");
INSERT INTO engtcent_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","While it remained unsold, did it not remain yoʋrs? And once it was sold, was it not under yoʋr control? How is it that yoʋ have put this thing in yoʋr heart? Yoʋ have not lied to men but to God.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","When Ananias heard these words, he fell down and breathed his last breath. And great fear came upon all who heard about it. ");
INSERT INTO engtcent_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Then the young men rose, wrapped up his body, carried him out, and buried him. ");
INSERT INTO engtcent_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","About three hours later, his wife came in, not knowing what had happened. ");
INSERT INTO engtcent_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter said to her, “Tell me if you sold the plot of land for such and such a price.” She said, “Yes, for such a price.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter said to her, “Why is it that you have agreed to put the Spirit of the Lord to the test? Behold, the feet of those who buried yoʋr husband are at the door, and they will carry yoʋ out.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","At once she fell down at his feet and breathed her last breath. When the young men came in, they found her dead, so they carried her out and buried her beside her husband. ");
INSERT INTO engtcent_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","And great fear came upon the whole church and upon all who heard these things. ");
INSERT INTO engtcent_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Now many signs and wonders were taking place among the people by the hands of the apostles, and all the believers were together with one accord in Solomon's portico. ");
INSERT INTO engtcent_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","No one else dared to join them, but the people held them in high regard. ");
INSERT INTO engtcent_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yet more and more people believed in the Lord and were added to their number, a multitude of both men and women. ");
INSERT INTO engtcent_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","As a result, people carried the sick out into the streets and laid them on beds and mats, so that when Peter came by at least his shadow might fall on one of them. ");
INSERT INTO engtcent_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","A multitude from the towns all around Jerusalem also gathered together, bringing the sick and those harassed by unclean spirits, and they were all healed. ");
INSERT INTO engtcent_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Then the high priest rose up, along with all who were with him (that is, the sect of the Sadducees), and they were filled with jealousy. ");
INSERT INTO engtcent_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","So they arrested the apostles and put them in a public jail. ");
INSERT INTO engtcent_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","But during the night an angel of the Lord opened the doors of the prison, brought them out, and said, ");
INSERT INTO engtcent_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Go stand in the temple courts and tell the people everything about this new life.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","When they heard this, they entered the temple courts at dawn and began teaching. When the high priest came, along with those who were with him, they called together the Sanhedrin—that is, the entire eldership of the people of Israel—and sent officers to the prison to have the apostles brought before them. ");
INSERT INTO engtcent_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","But when the officers arrived, they did not find them in the prison. So they returned and reported, ");
INSERT INTO engtcent_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“We found the prison locked up in complete security and the guards standing in front of the doors, but when we opened the doors, we found no one inside.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","When the high priest, the captain of the temple guard, and the chief priests heard this report, they were greatly perplexed by it, wondering what might come of this. ");
INSERT INTO engtcent_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Then someone came and told them, “Behold, the men you put in prison are standing in the temple courts teaching the people!” ");
INSERT INTO engtcent_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","So the captain went with the officers and brought the apostles without the use of force, for they were afraid the people might stone them. ");
INSERT INTO engtcent_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","After bringing the apostles in, they had them stand before the Sanhedrin, and the high priest asked them, ");
INSERT INTO engtcent_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Did we not strictly command you not to teach in this name? Yet behold, you have filled Jerusalem with your teaching, and you are determined to bring the blood of this man upon us.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","But Peter and the apostles answered, “We must obey God rather than men. ");
INSERT INTO engtcent_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","The God of our fathers raised up Jesus, whom you murdered by hanging him on a cross. ");
INSERT INTO engtcent_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God exalted him to his right hand as Leader and Savior to grant repentance to Israel and remission of sins. ");
INSERT INTO engtcent_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Concerning these things we are his witnesses, and so is the Holy Spirit, whom God has given to those who obey him.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","When they heard this, they were furious and resolved to put them to death, ");
INSERT INTO engtcent_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","but a Pharisee named Gamaliel, a teacher of the law who was held in honor by all the people, stood up in the Sanhedrin and gave orders to put the apostles outside for a little while. ");
INSERT INTO engtcent_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Then he said to the Sanhedrin, “Men of Israel, give careful consideration to what you are about to do to these men. ");
INSERT INTO engtcent_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","For before these days Theudas rose up, declaring himself to be somebody, and a number of men, about four hundred, responded to the call to join him. He was put to death, and all his followers were scattered and came to nothing. ");
INSERT INTO engtcent_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","After this man, Judas the Galilean rose up in the days of the census and drew away many people after him. He also perished, and all his followers were scattered. ");
INSERT INTO engtcent_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","So I say to you now, keep away from these men and leave them alone, for if this plan or this undertaking is of men, it will be stopped; ");
INSERT INTO engtcent_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","but if it is of God, you cannot put a stop to it. You will only find yourselves fighting against God.” ");
INSERT INTO engtcent_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","They were persuaded by him, and after calling in the apostles, they beat them, commanded them not to speak in the name of Jesus, and released them. ");
INSERT INTO engtcent_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","So the apostles went out from the presence of the Sanhedrin, rejoicing that they had been considered worthy to suffer dishonor for the Name. ");
INSERT INTO engtcent_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","And every day, in the temple courts and from house to house, they did not cease teaching and preaching the good news that Jesus is the Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","In those days, as the disciples increased in number, a complaint arose against the Hebrews on the part of the Hellenists that their widows were being overlooked in the daily distribution of food. ");
INSERT INTO engtcent_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","So the twelve called the multitude of the disciples together and said, “It is not proper for us to neglect the word of God to wait on tables. ");
INSERT INTO engtcent_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Therefore, brothers, look for seven men among you who have a good reputation and are full of the Holy Spirit and wisdom, whom we can appoint for this need. ");
INSERT INTO engtcent_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","But we will devote ourselves to prayer and to the ministry of the word.” ");
INSERT INTO engtcent_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","This proposal pleased the whole multitude, so they chose Stephen, a man full of faith and the Holy Spirit, together with Philip, Prochorus, Nicanor, Timon, Parmenas, and Nicolaus, an Antiochean convert to Judaism. ");
INSERT INTO engtcent_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","They set these men before the apostles, who then prayed and laid their hands on them. ");
INSERT INTO engtcent_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","So the word of God continued to increase, and the number of disciples continued to multiply greatly in Jerusalem, and a large number of priests became obedient to the faith. ");
INSERT INTO engtcent_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Now Stephen, a man full of faith and power, was performing great wonders and signs among the people. ");
INSERT INTO engtcent_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","But some men from the synagogue of the Freedmen (as it was called), along with some of the Cyrenians and Alexandrians, and some men from Cilicia and Asia, rose up and began to argue with Stephen. ");
INSERT INTO engtcent_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","But they were not able to resist the wisdom and the Spirit with which he was speaking. ");
INSERT INTO engtcent_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Then they induced some men to say, “We heard Stephen speaking blasphemous words against Moses and against God.” ");
INSERT INTO engtcent_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","They also stirred up the people, the elders, and the scribes. So they came up to Stephen, seized him, and brought him to the Sanhedrin. ");
INSERT INTO engtcent_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Then they put forward false witnesses who said, “This man does not stop speaking blasphemous words against the holy place and against the law. ");
INSERT INTO engtcent_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","For we heard him saying that this Jesus of Nazareth will destroy this place and change the customs that Moses handed down to us.” ");
INSERT INTO engtcent_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","And all who were sitting in the Sanhedrin stared at Stephen intently and saw that his face was like the face of an angel. ");
INSERT INTO engtcent_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Then the high priest said, “Are these accusations true?” ");
INSERT INTO engtcent_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen said, “Brothers and fathers, listen. The God of glory appeared to our father Abraham when he was in Mesopotamia, before he dwelt in Haran, ");
INSERT INTO engtcent_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","and said to him, ‘Leave yoʋr land and yoʋr relatives, and go to a land I will show yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Then he left the land of the Chaldeans and dwelt in Haran. After his father died, God relocated him to this land in which you now dwell. ");
INSERT INTO engtcent_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","He gave him no inheritance in it, not even the length of a footstep, but promised to give it to him for a possession, and to his descendants after him, even though he had no child. ");
INSERT INTO engtcent_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God told him that his descendants would be sojourners in a foreign land, and that the people of that land would enslave them and mistreat them for four hundred years. ");
INSERT INTO engtcent_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘But I will judge the nation whom they serve as slaves,’ God said, ‘and afterward they will come out of that country and serve me in this place.’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Then he gave Abraham the covenant of circumcision, and Abraham became the father of Isaac and circumcised him on the eighth day. Later Isaac became the father of Jacob, and Jacob became the father of the twelve patriarchs. ");
INSERT INTO engtcent_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“The patriarchs became jealous of Joseph and sold him into Egypt. But God was with him ");
INSERT INTO engtcent_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","and delivered him out of all his afflictions. He gave Joseph favor and wisdom before Pharaoh, king of Egypt, so Pharaoh appointed him as ruler over Egypt and over all his household. ");
INSERT INTO engtcent_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Then a famine came upon all the land of Egypt and Canaan, along with great suffering, and our fathers could find no food. ");
INSERT INTO engtcent_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","But when Jacob heard that there was grain in Egypt, he sent our fathers out the first time. ");
INSERT INTO engtcent_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","On their second visit, Joseph made himself known to his brothers again, and Joseph's family became known to Pharaoh. ");
INSERT INTO engtcent_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Then Joseph sent and called for his father Jacob and all his relatives, seventy-five people in all. ");
INSERT INTO engtcent_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","So Jacob went down to Egypt, and there he died, he and our fathers. ");
INSERT INTO engtcent_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Later their bodies were moved to Shechem and laid in the tomb that Abraham had bought for a sum of money from the sons of Hamor, the father of Shechem. ");
INSERT INTO engtcent_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“As the time drew near for God to fulfill the promise he had sworn to Abraham, our people increased and multiplied in Egypt ");
INSERT INTO engtcent_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","until there arose another king who did not know Joseph. ");
INSERT INTO engtcent_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","This king dealt shrewdly with our people and mistreated our fathers, making them abandon their newborn babies so that they would not survive. ");
INSERT INTO engtcent_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","At that time Moses was born, and he was beautiful in God's sight. For three months he was brought up in his father's house, ");
INSERT INTO engtcent_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","and when he was abandoned, Pharaoh's daughter took him in and brought him up as her own son. ");
INSERT INTO engtcent_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","So Moses was trained in all the wisdom of the Egyptians, and he was mighty in words and deeds. ");
INSERT INTO engtcent_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“When Moses reached forty years of age, it came into his heart to visit his brothers, the sons of Israel. ");
INSERT INTO engtcent_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","When he saw one of them being wronged, he came to the aid of the man who was being oppressed and avenged him by striking down the Egyptian who was oppressing him. ");
INSERT INTO engtcent_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses assumed that his brothers would understand that God was granting them deliverance by his hand, but they did not understand. ");
INSERT INTO engtcent_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","The next day Moses came upon two Israelites who were fighting and urged them to make peace, saying, ‘Men, you are brothers; why are you hurting each other?’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","But the one who was hurting his neighbor thrust Moses aside and said, ‘Who appointed yoʋ to be a ruler and judge over us? ");
INSERT INTO engtcent_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Do yoʋ want to kill me as yoʋ killed that Egyptian yesterday?’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","At this remark Moses fled and became a sojourner in the land of Midian, where he became the father of two sons. ");
INSERT INTO engtcent_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“After forty years had passed, an angel of the Lord appeared to him in the wilderness of Mount Sinai, in a flame of fire in a bush. ");
INSERT INTO engtcent_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","When Moses saw it, he was amazed at the sight. As he drew near to look at it, the voice of the Lord came to him: ");
INSERT INTO engtcent_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘I am the God of yoʋr fathers, the God of Abraham, the God of Isaac, and the God of Jacob.’ Moses began to tremble and did not dare to look. ");
INSERT INTO engtcent_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Then the Lord said to him, ‘Remove the sandals from yoʋr feet, for the place where yoʋ are standing is holy ground. ");
INSERT INTO engtcent_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","I have surely seen the mistreatment of my people in Egypt. I have heard their groaning and have come down to deliver them. Now come, I will send yoʋ to Egypt.’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“This is the same Moses they had rejected, saying, ‘Who appointed yoʋ to be a ruler and judge?’ He is the one God sent as a ruler and redeemer by the hand of the angel who appeared to him in the bush. ");
INSERT INTO engtcent_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","He is the one who led them out, performing wonders and signs in the land of Egypt, at the Red Sea, and in the wilderness for forty years. ");
INSERT INTO engtcent_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","This is the same Moses who said to the sons of Israel, ‘The Lord your God will raise up for you a prophet like me from among your brothers.’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","This is the man who was with our fathers in the assembly in the wilderness when the angel spoke to him on Mount Sinai. He received living oracles to give to us. ");
INSERT INTO engtcent_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Our fathers were unwilling to obey him. Instead, they thrust him aside, and in their hearts they turned back to Egypt, ");
INSERT INTO engtcent_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","saying to Aaron, ‘Make us gods who will go before us, for we do not know what has happened to this Moses who led us out of the land of Egypt.’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","In those days they made an idol in the form of a calf, brought a sacrifice to the idol, and rejoiced at the works of their hands. ");
INSERT INTO engtcent_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","But God turned away from them and gave them up to serve the host of heaven, just as it is written in the book of the prophets: ‘Was it to me that you offered slain beasts and sacrifices for forty years in the wilderness, O house of Israel? ");
INSERT INTO engtcent_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","No! You took up the tabernacle of Molech and the star of your god Remphan, the images you made so that you could worship them, so I will send you into exile beyond Babylon.’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Our fathers had the tabernacle of the testimony in the wilderness, just as God had directed when he spoke to Moses and told him to make it according to the pattern he had seen. ");
INSERT INTO engtcent_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Receiving it in turn, our fathers brought it in with Joshua when they dispossessed the nations whom God drove out from their presence. It remained there until the days of David, ");
INSERT INTO engtcent_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","who found favor before God and asked if he could provide a dwelling place for the God of Jacob. ");
INSERT INTO engtcent_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","But it was Solomon who built a house for him. ");
INSERT INTO engtcent_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yet the Most High does not dwell in temples made by human hands, just as the prophet says, ");
INSERT INTO engtcent_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Heaven is my throne, and the earth is my footstool. What house will you build for me, says the Lord, or what place is there for my rest? ");
INSERT INTO engtcent_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Has not my hand made all these things?’ ");
INSERT INTO engtcent_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“You stiff-necked people, uncircumcised in heart and ears, you always resist the Holy Spirit! As your fathers did, so you do also. ");
INSERT INTO engtcent_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Which of the prophets did your fathers not persecute? They even killed those who foretold the coming of the Righteous One, whose betrayers and murderers you have now become, ");
INSERT INTO engtcent_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","you who received the law as ordained by angels yet have not kept it.” ");
INSERT INTO engtcent_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","When the members of the Sanhedrin heard these things, they were cut to the heart and began gnashing their teeth at him. ");
INSERT INTO engtcent_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","But Stephen, full of the Holy Spirit, gazed into heaven and saw the glory of God and Jesus standing at the right hand of God. ");
INSERT INTO engtcent_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","He said, “Behold, I see the heavens opened and the Son of Man standing at the right hand of God.” ");
INSERT INTO engtcent_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","But they cried out with a loud voice, stopped their ears, and rushed at him with one accord. ");
INSERT INTO engtcent_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Then they drove him out of the city and began stoning him. Meanwhile, the witnesses laid their cloaks at the feet of a young man named Saul. ");
INSERT INTO engtcent_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","They continued stoning Stephen while he prayed, “Lord Jesus, receive my spirit!” ");
INSERT INTO engtcent_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Then he fell to his knees and cried out with a loud voice, “Lord, do not hold this sin against them!” After saying this, he fell asleep. ");
INSERT INTO engtcent_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","And Saul approved of his execution. On that day a great persecution arose against the church in Jerusalem, and all the believers except the apostles were scattered throughout the regions of Judea and Samaria. ");
INSERT INTO engtcent_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Devout men carried Stephen away for burial and made great lamentation over him. ");
INSERT INTO engtcent_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","But Saul was ravaging the church. Entering house after house, he dragged off both men and women and put them in prison. ");
INSERT INTO engtcent_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Now those who had been scattered went around preaching the message of good news. ");
INSERT INTO engtcent_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip went down to a city of Samaria and began proclaiming to them the Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","With one accord the crowds paid close attention to what Philip said as they listened to him and saw the signs he was performing. ");
INSERT INTO engtcent_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","For unclean spirits came out of many who had them, crying out with a loud voice, and many who were paralyzed or lame were healed. ");
INSERT INTO engtcent_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","And there was great joy in that city. ");
INSERT INTO engtcent_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Now a man named Simon had previously practiced magic in the city and amazed the people of Samaria, declaring himself to be someone great. ");
INSERT INTO engtcent_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","From the least to the greatest, they paid close attention to him, saying, “This man is the great power of God.” ");
INSERT INTO engtcent_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","They all paid close attention to him because he had amazed them with his magical arts for a long time. ");
INSERT INTO engtcent_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","But when they believed Philip as he preached good news about the kingdom of God and the name of Jesus Christ, they were baptized, both men and women. ");
INSERT INTO engtcent_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Even Simon himself believed. After he was baptized, he kept close company with Philip and was amazed as he saw miracles and signs taking place. ");
INSERT INTO engtcent_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","When the apostles in Jerusalem heard that Samaria had received the word of God, they sent them Peter and John. ");
INSERT INTO engtcent_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","These two went down and prayed for the Samaritan believers to receive the Holy Spirit, ");
INSERT INTO engtcent_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","for the Spirit had not yet fallen upon any of them; they had only been baptized in the name of Christ Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Then Peter and John laid their hands on the Samaritan believers, and they received the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","When Simon saw that the Holy Spirit was given through the laying on of the apostles' hands, he offered them money, ");
INSERT INTO engtcent_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","saying, “Give this power to me as well, so that whomever I lay my hands on may receive the Holy Spirit.” ");
INSERT INTO engtcent_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","But Peter said to him, “May yoʋr silver be destroyed with yoʋ, because yoʋ thought yoʋ could acquire the gift of God with money! ");
INSERT INTO engtcent_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yoʋ have no share or portion in this matter, for yoʋr heart is not right before God. ");
INSERT INTO engtcent_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Therefore repent of this wickedness of yoʋrs, and plead with God in the hope that the intention of yoʋr heart might be forgiven yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","For I see that yoʋ are bitterly envious and in bondage to unrighteousness.” ");
INSERT INTO engtcent_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","In response Simon said, “Pray to the Lord for me so that nothing you have said will happen to me.” ");
INSERT INTO engtcent_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","After Peter and John had testified and spoken the word of the Lord, they returned to Jerusalem, preaching the good news in many villages of the Samaritans as they went. ");
INSERT INTO engtcent_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Now an angel of the Lord said to Philip, “Rise and go toward the south, to the road that goes from Jerusalem down to Gaza.” (This is a desert road.) ");
INSERT INTO engtcent_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","So he rose and went. And behold, there was an Ethiopian eunuch, a court official in charge of the entire treasury of Candace, the queen of the Ethiopians. This man had come to Jerusalem to worship ");
INSERT INTO engtcent_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","and was sitting in his chariot on his way back home, reading the prophet Isaiah. ");
INSERT INTO engtcent_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","The Spirit said to Philip, “Go over and join that chariot.” ");
INSERT INTO engtcent_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","So Philip ran up to it and heard the man reading the prophet Isaiah. He said, “Do yoʋ understand what yoʋ are reading?” ");
INSERT INTO engtcent_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","The man said, “How can I, unless someone guides me?” So he invited Philip to come up and sit with him. ");
INSERT INTO engtcent_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","This is the passage of Scripture that he was reading: “Like a sheep he was led to slaughter, and like a lamb is silent before its shearer, so he did not open his mouth. ");
INSERT INTO engtcent_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","In his humiliation he was denied justice. Who will tell of his posterity? For his life was taken from the earth.” ");
INSERT INTO engtcent_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","The eunuch said to Philip, “I ask yoʋ, who does the prophet say this about? About himself, or about someone else?” ");
INSERT INTO engtcent_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Then Philip opened his mouth to speak, and beginning from this Scripture, he told him the good news about Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","As they were going along the road, they came to some water, and the eunuch said, “Behold, here is water! What prevents me from being baptized?” ");
INSERT INTO engtcent_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","So he ordered the chariot to stop, and the two of them went down into the water, both Philip and the eunuch, and Philip baptized him. ");
INSERT INTO engtcent_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","When they came up out of the water, the Spirit of the Lord caught Philip away, and the eunuch saw him no more, but went on his way rejoicing. ");
INSERT INTO engtcent_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip, however, found himself at Azotus, and as he passed through that region, he preached the gospel in all the towns until he came to Caesarea. ");
INSERT INTO engtcent_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Meanwhile Saul, still breathing out threats and murder against the disciples of the Lord, went to the high priest ");
INSERT INTO engtcent_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","and asked for letters from him to the synagogues in Damascus, so that if he found any who belonged to the Way, whether men or women, he might bring them to Jerusalem as prisoners. ");
INSERT INTO engtcent_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","As he was going along, he drew near to Damascus, and suddenly a light from heaven flashed around him. ");
INSERT INTO engtcent_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Falling to the ground, he heard a voice saying to him, “Saul, Saul, why are yoʋ persecuting me?” ");
INSERT INTO engtcent_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul said, “Who are yoʋ, Lord?” The Lord said, “I am Jesus, whom yoʋ are persecuting. ");
INSERT INTO engtcent_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","But rise and enter the city, and yoʋ will be told what yoʋ must do.” ");
INSERT INTO engtcent_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","The men who were traveling with Saul stood speechless, hearing the voice but seeing no one. ");
INSERT INTO engtcent_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul rose from the ground, and although his eyes were open, he saw no one. So they led him by the hand and brought him to Damascus. ");
INSERT INTO engtcent_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","He went three days without seeing, and neither ate nor drank. ");
INSERT INTO engtcent_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Now there was a disciple in Damascus named Ananias. The Lord said to him in a vision, “Ananias.” He said, “Behold, here I am, Lord.” ");
INSERT INTO engtcent_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Then the Lord said to him, “Get up and go to the street called Straight, and at the house of Judas look for a man of Tarsus named Saul. For behold, he is praying, ");
INSERT INTO engtcent_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","and in a vision he has seen a man named Ananias coming in and laying his hand on him so that he might receive his sight.” ");
INSERT INTO engtcent_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","But Ananias answered, “Lord, I have heard from many about how much evil this man has done to yoʋr saints in Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","And here he has authority from the chief priests to arrest all who call upon yoʋr name.” ");
INSERT INTO engtcent_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","But the Lord said to him, “Go, for he is a vessel chosen by me to bring my name before Gentiles, kings, and the sons of Israel. ");
INSERT INTO engtcent_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","I will show him how much he must suffer for my name's sake.” ");
INSERT INTO engtcent_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","So Ananias went and entered the house. Laying his hands on Saul, he said, “Brother Saul, the Lord, who appeared to yoʋ on the road by which yoʋ came, has sent me so that yoʋ may receive yoʋr sight and be filled with the Holy Spirit.” ");
INSERT INTO engtcent_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Immediately something like scales fell from Saul's eyes, and he received his sight. Then he rose and was baptized, ");
INSERT INTO engtcent_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","and after taking some food, he was strengthened. For several days Saul was with the disciples in Damascus. ");
INSERT INTO engtcent_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Immediately he began preaching in the synagogues that the Christ is the Son of God. ");
INSERT INTO engtcent_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","All who heard it were amazed and said, “Is this not the man who in Jerusalem tried to destroy those who call upon this name, and has he not come here for the purpose of bringing them as prisoners to the chief priests?” ");
INSERT INTO engtcent_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","But Saul grew stronger and kept confounding the Jews who dwelt in Damascus, proving that this man Jesus is the Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","When many days had past, the Jews took counsel together to kill him, ");
INSERT INTO engtcent_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","but their plot became known to Saul. They started watching the gates both day and night so that they might kill him. ");
INSERT INTO engtcent_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","But the disciples took him by night and let him down through a window in the city wall, lowering him in a basket. ");
INSERT INTO engtcent_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","When Saul arrived in Jerusalem, he tried to join the disciples, but they were all afraid of him because they did not believe that he was a disciple. ");
INSERT INTO engtcent_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas, however, took him and brought him to the apostles. He related to them how Saul had seen the Lord on the road and that the Lord had spoken to him, and how he had been preaching boldly in Damascus in the name of Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","So Saul stayed with them and would go into Jerusalem and speak boldly in the name of the Lord Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","He would also speak and debate with the Hellenists, but they were trying to kill him. ");
INSERT INTO engtcent_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","When the brothers found out about it, they brought him down to Caesarea and sent him off to Tarsus. ");
INSERT INTO engtcent_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","So the churches throughout all Judea, Galilee, and Samaria had peace and were being strengthened. Continuing in the fear of the Lord and in the encouragement of the Holy Spirit, they were being multiplied. ");
INSERT INTO engtcent_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Now as Peter was traveling from place to place, he went down to the saints who dwelt in Lydda. ");
INSERT INTO engtcent_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","There he found a man named Aeneas, who was paralyzed and had been confined to a mat for eight years. ");
INSERT INTO engtcent_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter said to him, “Aeneas, Jesus Christ has now healed yoʋ; rise and roll up yoʋr mat.” Immediately he rose, ");
INSERT INTO engtcent_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","and all who dwelt in Lydda and Sharon saw him and turned to the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Now in Joppa there was a disciple named Tabitha (which means “Dorcas”). She was always doing good works and charitable acts. ");
INSERT INTO engtcent_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","In those days she became sick and died, so they washed her body and laid it in an upper room. ");
INSERT INTO engtcent_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lydda was near Joppa, so when the disciples heard that Peter was there, they sent for him, urging him not to delay in coming to them. ");
INSERT INTO engtcent_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","So Peter rose and went with them. When he arrived, they brought him to the upper room, and all the widows stood before him, weeping and showing him all the tunics and cloaks that Dorcas had made while she was still with them. ");
INSERT INTO engtcent_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","But Peter sent them all outside, knelt down, and prayed. Turning toward the body, he said, “Tabitha, arise.” Then she opened her eyes, and seeing Peter, she sat up. ");
INSERT INTO engtcent_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","He gave her his hand and raised her up. Then he called in the saints and the widows and presented her alive. ");
INSERT INTO engtcent_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","This became known throughout all Joppa, and many believed in the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","And Peter remained in Joppa for many days with a tanner named Simon. ");
INSERT INTO engtcent_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Now there was a man in Caesarea named Cornelius, a centurion of what was called the Italian cohort. ");
INSERT INTO engtcent_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","He was a devout man who feared God along with his entire household; he gave generously to those in need and always prayed to God. ");
INSERT INTO engtcent_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","About the ninth hour of the day he saw clearly in a vision an angel of God, who came in and said to him, “Cornelius!” ");
INSERT INTO engtcent_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Staring at him intently, Cornelius was afraid and said, “What is it, Lord?” The angel said to him, “Yoʋr prayers and charitable acts have ascended as a memorial offering before God. ");
INSERT INTO engtcent_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Now send men to Joppa and have them bring back Simon, who is called Peter. ");
INSERT INTO engtcent_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","He is staying with a tanner named Simon, whose house is by the sea.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","When the angel who spoke to him went away, Cornelius called two of his servants and a devout soldier from among his attendants. ");
INSERT INTO engtcent_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","After explaining everything to them, he sent them to Joppa. ");
INSERT INTO engtcent_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","On the next day, as the men were traveling along and approaching the city, Peter went up on the housetop to pray at about the sixth hour. ");
INSERT INTO engtcent_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","He became hungry and wanted to eat, and as they were preparing a meal, a trance fell upon him. ");
INSERT INTO engtcent_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","He saw heaven opened and an object like a large sheet coming down to him. It was tied at its four corners and was being lowered to the earth. ");
INSERT INTO engtcent_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","In it were all kinds of four-footed animals of the earth, as well as wild beasts, reptiles, and birds of the sky. ");
INSERT INTO engtcent_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Then a voice came to him: “Rise, Peter, kill and eat.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","But Peter said, “Surely not, Lord! For I have never eaten anything that is defiled or unclean.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","The voice came to him again a second time: “Do not regard as defiled what God has made clean.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","This happened three times, and then the object was taken up again into heaven. ");
INSERT INTO engtcent_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","While Peter was greatly perplexed, pondering within himself what the vision he had seen might mean, behold, the men sent by Cornelius had asked for Simon's house and were standing at the gate. ");
INSERT INTO engtcent_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","They called out and asked if Simon, who was called Peter, was staying there. ");
INSERT INTO engtcent_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","As Peter continued pondering the vision, the Spirit said to him, “Behold, some men are looking for yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Now get up, go downstairs, and go with them without any misgivings, for I have sent them.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","So Peter went down to the men and said, “Behold, I am the one you are looking for. For what reason have you come?” ");
INSERT INTO engtcent_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","They said, “Cornelius, a centurion, a righteous and God-fearing man, who is well spoken of by the entire Jewish nation, was directed by a holy angel to send for yoʋ to come to his house and to hear a message from yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","So Peter invited them in and put them up for the night. The next day Peter went with them, and some of the brothers from Joppa accompanied him. ");
INSERT INTO engtcent_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","The following day they entered Caesarea. Cornelius was expecting them and had called together his relatives and close friends. ");
INSERT INTO engtcent_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","When Peter entered the house, Cornelius met him, fell at his feet, and worshiped him. ");
INSERT INTO engtcent_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","But Peter raised him up, saying, “Stand up; I too am just a man.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","As Peter talked with him, he went in and found many people gathered together. ");
INSERT INTO engtcent_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peter said to them, “You know that it is forbidden for a Jewish man to keep company with or associate with a foreigner, but God has shown me that I should call no one defiled or unclean. ");
INSERT INTO engtcent_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","That is why I came without objection when I was sent for. I ask then, what is the reason you have sent for me?” ");
INSERT INTO engtcent_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius said, “Four days ago I was fasting until this hour. At the ninth hour I was praying in my house, and behold, a man stood before me in bright clothing. ");
INSERT INTO engtcent_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","The man said, ‘Cornelius, yoʋr prayer has been heard, and yoʋr charitable acts have been remembered before God. ");
INSERT INTO engtcent_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Therefore send to Joppa and ask for Simon, who is called Peter. He is staying by the sea in the house of a tanner named Simon. When he arrives, he will speak to yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","So I sent for yoʋ at once, and yoʋ have done well by coming. Now then, we are all here in the presence of God to hear all that yoʋ have been commanded by God.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Then Peter opened his mouth and said, “Now I truly understand that God shows no partiality, ");
INSERT INTO engtcent_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","but in every nation anyone who fears him and does what is right is acceptable to him. ");
INSERT INTO engtcent_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","You yourselves know the message he sent to the sons of Israel, preaching the good news of peace through Jesus Christ, who is Lord of all, ");
INSERT INTO engtcent_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","the message that spread throughout all Judea, beginning from Galilee after the baptism that John preached: ");
INSERT INTO engtcent_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","how God anointed Jesus of Nazareth with the Holy Spirit and power, who then went around doing good and healing all who were oppressed by the devil, because God was with him. ");
INSERT INTO engtcent_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","We are witnesses of everything he did both in the country of the Jews and in Jerusalem. They put him to death by hanging him on a cross, ");
INSERT INTO engtcent_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","but God raised him up on the third day and allowed him to be seen, ");
INSERT INTO engtcent_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","not by all the people, but by us, the witnesses who had been chosen beforehand by God, who ate and drank with him after he rose from the dead. ");
INSERT INTO engtcent_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","He commanded us to preach to the people and to testify that he is the one who has been appointed by God as judge of the living and the dead. ");
INSERT INTO engtcent_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","All the prophets testify about him that everyone who believes in him receives remission of sins through his name.” ");
INSERT INTO engtcent_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","While Peter was still speaking these words, the Holy Spirit fell upon all who were listening to the message. ");
INSERT INTO engtcent_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","All the believers from among the circumcised who had come with Peter were astonished, because the gift of the Holy Spirit was being poured out even on the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","For they heard them speaking in tongues and magnifying God. Then Peter responded, ");
INSERT INTO engtcent_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Can anyone withhold water for baptizing these people who have received the Holy Spirit just as we have?” ");
INSERT INTO engtcent_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","So he gave orders to have them baptized in the name of the Lord. Then they asked him to stay on for a few days. ");
INSERT INTO engtcent_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Now the apostles and the brothers who were in Judea heard that the Gentiles had also received the word of God. ");
INSERT INTO engtcent_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","So when Peter came up to Jerusalem, those of the circumcision faction began disputing with him, ");
INSERT INTO engtcent_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","saying, “Yoʋ went into the house of uncircumcised men and ate with them!” ");
INSERT INTO engtcent_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","But Peter began to explain the situation to them, step by step, saying, ");
INSERT INTO engtcent_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“I was praying in the city of Joppa, and in a trance I saw a vision of an object like a large sheet coming down, being lowered from heaven by its four corners, and it came to me. ");
INSERT INTO engtcent_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","As I stared at it, I looked closely and saw four-footed animals of the earth, as well as wild beasts, reptiles, and birds of the sky. ");
INSERT INTO engtcent_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Then I heard a voice saying to me, ‘Rise, Peter, kill and eat.’ ");
INSERT INTO engtcent_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","But I said, ‘Surely not, Lord! For nothing defiled or unclean has ever entered my mouth.’ ");
INSERT INTO engtcent_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","The voice from heaven responded to me a second time: ‘Do not regard as defiled what God has made clean.’ ");
INSERT INTO engtcent_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","This happened three times, and then everything was drawn up again into heaven. ");
INSERT INTO engtcent_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","And behold, at that very moment three men arrived at the house where I was; they had been sent to me from Caesarea. ");
INSERT INTO engtcent_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","The Spirit told me to go with them without any misgivings. These six brothers also went with me, and we went into the man's house. ");
INSERT INTO engtcent_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","He told us how he had seen an angel standing in his house and saying to him, ‘Send men to Joppa and have them bring back Simon, who is called Peter; ");
INSERT INTO engtcent_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","he will speak a message to yoʋ by which yoʋ will be saved, yoʋ and yoʋr entire household.’ ");
INSERT INTO engtcent_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","As I began to speak, the Holy Spirit fell upon them, just as he had fallen upon us at the beginning. ");
INSERT INTO engtcent_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Then I remembered what the Lord had said: ‘John baptized with water, but you will be baptized with the Holy Spirit.’ ");
INSERT INTO engtcent_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","If then God gave them the same gift that he gave us when we believed in the Lord Jesus Christ, how could I stand in God's way?” ");
INSERT INTO engtcent_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","When the apostles and brothers heard this, they ceased their objections and began glorifying God, saying, “Then to the Gentiles also God has granted the repentance that leads to life.” ");
INSERT INTO engtcent_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Now those who had been scattered because of the persecution that arose over Stephen traveled as far as Phoenicia, Cyprus, and Antioch, speaking the word to no one except Jews. ");
INSERT INTO engtcent_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","But there were some Cypriot and Cyrenian men among them who went to Antioch and began speaking to the Hellenists, preaching the good news about the Lord Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","The hand of the Lord was with them, and a large number of people believed and turned to the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","News of this reached the ears of the church in Jerusalem, and they sent Barnabas out to go to Antioch. ");
INSERT INTO engtcent_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","When he arrived and saw the grace of God, he rejoiced and began exhorting all the believers to remain true to the Lord with resolute hearts. ");
INSERT INTO engtcent_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","For he was a good man, full of the Holy Spirit and faith, and a large number of people were added to the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Then Barnabas went to Tarsus to look for Saul. ");
INSERT INTO engtcent_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","When he found him, he brought him to Antioch. So for an entire year they met with the church and taught a large number of people, and it was in Antioch that the disciples were first called Christians. ");
INSERT INTO engtcent_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","In those days some prophets came down to Antioch from Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","One of them, named Agabus, stood up and indicated by the Spirit that a severe famine was about to come upon the entire world (which indeed took place in the time of Claudius Caesar). ");
INSERT INTO engtcent_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","So the disciples, each according to his own ability, determined to send relief to the brothers who dwelt in Judea. ");
INSERT INTO engtcent_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","This they did, sending it to the elders by the hands of Barnabas and Saul. ");
INSERT INTO engtcent_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","About that time King Herod arrested some who belonged to the church in order to harm them. ");
INSERT INTO engtcent_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","He killed James the brother of John with the sword. ");
INSERT INTO engtcent_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","And when he saw that this pleased the Jews, he proceeded to arrest Peter also. (This took place during the Feast of Unleavened Bread.) ");
INSERT INTO engtcent_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","After seizing him, he put him in prison, handing him over to be guarded by four squads of four soldiers each. Herod planned to bring him out to the people after the Passover. ");
INSERT INTO engtcent_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","So Peter was kept in prison, but the church was earnestly praying to God for him. ");
INSERT INTO engtcent_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","The very night before Herod was going to bring him out, Peter was sleeping between two soldiers, bound with two chains, while the guards in front of the door were keeping watch over the prison. ");
INSERT INTO engtcent_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","And behold, an angel of the Lord stood before Peter, and a light shone in the cell. The angel struck Peter on the side and woke him up, saying, “Get up quickly!” And the chains fell off Peter's hands. ");
INSERT INTO engtcent_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Then the angel said to him, “Get dressed and put on yoʋr sandals.” And Peter did so. Then the angel said to him, “Put on yoʋr cloak and follow me.” ");
INSERT INTO engtcent_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","So Peter went out and followed him, but he did not realize that what the angel was doing was really happening; he thought he was seeing a vision. ");
INSERT INTO engtcent_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","After they passed the first and second guard, they came to the iron gate leading into the city. It opened for them on its own, and they went out. When they had gone the length of one street, the angel immediately left him. ");
INSERT INTO engtcent_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","When Peter came to his senses, he said, “Now I truly know that the Lord has sent his angel and rescued me from the hand of Herod and from everything the Jewish people were expecting to happen.” ");
INSERT INTO engtcent_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","When Peter realized this, he went to the house of Mary, the mother of John (who was called Mark), where many had gathered together and were praying. ");
INSERT INTO engtcent_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter knocked at the door of the gate, and a servant girl named Rhoda came to answer. ");
INSERT INTO engtcent_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","When she recognized Peter's voice, she was so overjoyed that she did not open the gate, but ran in and reported that Peter was standing in front of the gate. ");
INSERT INTO engtcent_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","They said to her, “Yoʋ are out of yoʋr mind.” But when she kept insisting that it was so, they said, “It is his angel.” ");
INSERT INTO engtcent_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Meanwhile Peter continued knocking, and when they opened the gate, they saw him and were astonished. ");
INSERT INTO engtcent_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","But motioning to them with his hand to be silent, he told them how the Lord had brought him out of prison. He also said, “Tell these things to James and to the brothers.” Then he left and went to another place. ");
INSERT INTO engtcent_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","When daybreak came, there was a great commotion among the soldiers as to what had become of Peter. ");
INSERT INTO engtcent_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","When Herod searched for him but did not find him, he questioned the guards and ordered them to be led away and executed. Then he went down from Judea to Caesarea and spent time there. ");
INSERT INTO engtcent_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Now Herod was having an angry dispute with the people of Tyre and Sidon. So they came to him with one accord, and having won over Blastus, the king's personal attendant, they asked for peace, because their country was supplied with food from the king's country. ");
INSERT INTO engtcent_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","On an appointed day Herod dressed himself in royal clothing, sat down on the platform, and made a speech to them. ");
INSERT INTO engtcent_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","The people kept shouting, “The voice of a god and not of a man!” ");
INSERT INTO engtcent_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Immediately an angel of the Lord struck Herod down because he did not give glory to God, and he was eaten by worms and breathed his last breath. ");
INSERT INTO engtcent_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","But the word of God increased and multiplied. ");
INSERT INTO engtcent_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","And when Barnabas and Saul completed their ministry, they returned to Jerusalem and brought with them John, who was called Mark. ");
INSERT INTO engtcent_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Now at the church in Antioch there were certain prophets and teachers: Barnabas, Simeon (who was called Niger), Lucius of Cyrene, Manaen (who had been brought up with Herod the tetrarch), and Saul. ");
INSERT INTO engtcent_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","As they were serving the Lord and fasting, the Holy Spirit said, “Set apart for me Barnabas and Saul for the work to which I have called them.” ");
INSERT INTO engtcent_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","So after they had fasted and prayed, they laid their hands on them and sent them off. ");
INSERT INTO engtcent_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Being sent out by the Holy Spirit, the two of them went down to Seleucia, and from there they sailed to Cyprus. ");
INSERT INTO engtcent_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","When they arrived at Salamis, they proclaimed the word of God in the synagogues of the Jews. (They also had John as their assistant.) ");
INSERT INTO engtcent_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","When they had gone across the island to Paphos, they came across a certain magician, a Jewish false prophet named Bar-Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","He was with the proconsul Sergius Paulus, an intelligent man, who summoned Barnabas and Saul, seeking to hear the word of God. ");
INSERT INTO engtcent_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","But the magician Elymas (for that is what his name means) opposed them, seeking to turn the proconsul away from the faith. ");
INSERT INTO engtcent_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","But Saul, also known as Paul, filled with the Holy Spirit, looked intently at Elymas ");
INSERT INTO engtcent_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","and said, “O son of the devil, full of all deceit and all trickery, enemy of all righteousness, will yoʋ not cease perverting the straight paths of the Lord? ");
INSERT INTO engtcent_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","And now, behold, the hand of the Lord is against yoʋ, and yoʋ will be blind, unable to see the sun for a period of time.” Immediately a mist and darkness fell upon him, and he was going around seeking people to lead him by the hand. ");
INSERT INTO engtcent_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","When the proconsul saw what had happened, he believed, for he was astonished at the teaching of the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Then Paul and his companions set sail from Paphos and went to Perga in Pamphylia, but John left them and returned to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Continuing on from Perga, they came to Antioch in Pisidia. On the Sabbath day they went into the synagogue and sat down. ");
INSERT INTO engtcent_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","After the reading of the Law and the Prophets, the rulers of the synagogue sent them a message, saying, “Brothers, if you have any word of exhortation for the people, speak it.” ");
INSERT INTO engtcent_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Standing up, Paul motioned with his hand and said, “Men of Israel, and you who fear God, listen. ");
INSERT INTO engtcent_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","The God of this people chose our fathers and exalted the people during their sojourn in the land of Egypt, and with an uplifted arm he led them out of that country. ");
INSERT INTO engtcent_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","For about forty years, he put up with them in the wilderness, ");
INSERT INTO engtcent_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","and after destroying seven nations in the land of Canaan, he gave his people their land as an inheritance. ");
INSERT INTO engtcent_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","After that he gave them judges for about four hundred and fifty years, up to the time of the prophet Samuel. ");
INSERT INTO engtcent_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Then the people asked for a king, and God gave them Saul the son of Kish, a man of the tribe of Benjamin, who reigned for forty years. ");
INSERT INTO engtcent_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","After removing Saul, God raised up David as their king, about whom he testified, ‘I have found David the son of Jesse to be a man after my own heart; he will do all that I want him to do.’ ");
INSERT INTO engtcent_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","From this man's offspring God brought salvation to Israel, according to his promise, ");
INSERT INTO engtcent_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","after John had first preached a baptism of repentance to Israel in advance of the coming Savior. ");
INSERT INTO engtcent_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Now as John was completing his course, he said, ‘Who do you suppose that I am? I am not he. But behold, one is coming after me, the sandals of whose feet I am not worthy to untie.’ ");
INSERT INTO engtcent_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Brothers, sons of the family of Abraham, and those among you who fear God, to you the message of this salvation has been sent. ");
INSERT INTO engtcent_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Since those who dwell in Jerusalem, along with their rulers, failed to recognize this man and the voices of the prophets that are read every Sabbath, they fulfilled their words by condemning him. ");
INSERT INTO engtcent_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Even though they found no grounds for a death sentence, they asked Pilate to have him killed. ");
INSERT INTO engtcent_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","When they had fulfilled all that was written about him, they took him down from the cross and laid him in a tomb. ");
INSERT INTO engtcent_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","But God raised him from the dead, ");
INSERT INTO engtcent_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","and for many days he was seen by those who had come up with him from Galilee to Jerusalem, who are his witnesses to the people. ");
INSERT INTO engtcent_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","And we preach to you the good news that what God promised to our fathers, he has fulfilled to us, their children, by raising up Jesus, ");
INSERT INTO engtcent_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","just as it is written in the second Psalm, ‘Yoʋ are my son; today I have begotten yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","As for the fact that he raised him from the dead, no longer to return to corruption, God has spoken in this way: ‘I will give you the holy and sure blessings of David.’ ");
INSERT INTO engtcent_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Therefore it also says in another place: ‘Yoʋ will not let yoʋr Holy One see corruption.’ ");
INSERT INTO engtcent_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","For when David had served God's purpose in his own generation, he fell asleep, was added to his fathers, and saw corruption. ");
INSERT INTO engtcent_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","But he whom God raised up did not see corruption. ");
INSERT INTO engtcent_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Therefore let it be known to you, brothers, that through this man remission of sins is proclaimed to you, ");
INSERT INTO engtcent_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","and by this man everyone who believes is acquitted of everything you could not be acquitted of by the law of Moses. ");
INSERT INTO engtcent_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","So beware that what is said in the prophets does not happen to you: ");
INSERT INTO engtcent_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Behold, you scoffers, be amazed and perish, for I am doing a work in your days that you will certainly not believe, even if someone tells you about it.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Now as Paul and Barnabas were going out from the synagogue of the Jews, the Gentiles were urging them to speak about these things on the next Sabbath. ");
INSERT INTO engtcent_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","And when the meeting of the synagogue was dispersed, many of the Jews and the devout converts to Judaism followed Paul and Barnabas, who spoke to them and persuaded them to continue in the grace of God. ");
INSERT INTO engtcent_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","On the following Sabbath, nearly the entire city was gathered together to hear the word of God. ");
INSERT INTO engtcent_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","But when the Jews saw the crowds, they were filled with jealousy and began to contradict what Paul was saying, opposing him and slandering him. ");
INSERT INTO engtcent_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","But Paul and Barnabas spoke boldly, saying, “It was necessary for the word of God to be spoken first to you. But since you are rejecting it and do not judge yourselves to be worthy of eternal life, behold, we are turning to the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","For this is what the Lord has commanded us: ‘I have appointed yoʋ to be a light to the Gentiles, so that yoʋ may bring salvation to the ends of the earth.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","When the Gentiles heard this, they began rejoicing and glorifying the word of the Lord, and all who were appointed to eternal life believed. ");
INSERT INTO engtcent_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","So the word of the Lord spread throughout that entire region. ");
INSERT INTO engtcent_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","But the Jews incited the devout women of high standing and the prominent men of the city. They stirred up persecution against Paul and Barnabas, and drove them out of their region. ");
INSERT INTO engtcent_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","But Paul and Barnabas shook off the dust from their feet in protest against them and went to Iconium. ");
INSERT INTO engtcent_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","And the disciples were filled with joy and with the Holy Spirit. ");
INSERT INTO engtcent_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","At Iconium Paul and Barnabas went together into the synagogue of the Jews and spoke in such a way that a great multitude of both Jews and Greeks believed. ");
INSERT INTO engtcent_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","But the Jews who refused to believe stirred up and corrupted the minds of the Gentiles to be against the brothers. ");
INSERT INTO engtcent_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","So Paul and Barnabas spent a long time there, speaking boldly for the Lord, who was testifying to the message of his grace by granting signs and wonders to be done by their hands. ");
INSERT INTO engtcent_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","But the population of the city was divided; some were with the Jews, and some were with the apostles. ");
INSERT INTO engtcent_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","And when an attempt was made by both the Gentiles and the Jews, together with their rulers, to mistreat them and stone them, ");
INSERT INTO engtcent_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Paul and Barnabas became aware of it and fled for refuge to the Lycaonian cities of Lystra and Derbe and to the surrounding region. ");
INSERT INTO engtcent_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","There they continued to preach the gospel. ");
INSERT INTO engtcent_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Now there was a man sitting in Lystra who could not use his feet. He had been lame from his mother's womb and had never walked. ");
INSERT INTO engtcent_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","This man listened to Paul as he was speaking. Paul looked at him intently, and when he saw that he had faith to be healed, ");
INSERT INTO engtcent_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","he said with a loud voice, “Stand up on yoʋr feet!” So the man leaped up and began to walk. ");
INSERT INTO engtcent_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","When the crowds saw what Paul had done, they lifted up their voices, saying in Lycaonian, “The gods have come down to us in the likeness of men.” ");
INSERT INTO engtcent_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas they called Zeus, and Paul they called Hermes, since he was the one who took the lead in speaking. ");
INSERT INTO engtcent_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Then the priest of the shrine of Zeus that was located in front of their city brought bulls and garlands to the city gates, intending to offer sacrifices together with the crowds. ");
INSERT INTO engtcent_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","But when the apostles Barnabas and Paul heard about it, they tore their clothes and rushed into the crowd, crying out, ");
INSERT INTO engtcent_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Men, why are you doing these things? We also are men with the same nature as you. We are bringing you good news, telling you to turn from these worthless things to the living God, who made the heavens, the earth, the sea, and all that is in them. ");
INSERT INTO engtcent_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","In past generations he allowed all the nations to go their own way, ");
INSERT INTO engtcent_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","although he did not leave himself without a witness in that he did good by giving you rain from heaven and fruitful seasons, filling our hearts with food and gladness.” ");
INSERT INTO engtcent_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yet even by saying these things, they barely restrained the crowds from offering sacrifices to them. ");
INSERT INTO engtcent_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Then some Jews came from Antioch and Iconium and persuaded the crowds. They stoned Paul and dragged him out of the city, supposing that he was dead. ");
INSERT INTO engtcent_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","But when the disciples gathered around him, he rose and entered the city. The next day he went on with Barnabas to Derbe. ");
INSERT INTO engtcent_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","After preaching the gospel in that city and making many disciples, Paul and Barnabas returned to Lystra, Iconium, and Antioch, ");
INSERT INTO engtcent_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","strengthening the souls of the disciples, exhorting them to continue in the faith, and telling them that through many tribulations we must enter the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","And when they had appointed elders for them in every church, with prayer and fasting they entrusted them to the Lord in whom they had come to believe. ");
INSERT INTO engtcent_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","After passing through Pisidia, they came to Pamphylia, ");
INSERT INTO engtcent_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","and when they had spoken the word in Perga, they went down to Attalia. ");
INSERT INTO engtcent_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","From there they sailed to Antioch, where they had been committed to the grace of God for the work they had now completed. ");
INSERT INTO engtcent_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","After they arrived and gathered the church together, they reported all that God had done through them, and how he had opened a door of faith to the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","And they stayed there with the disciples for some time. ");
INSERT INTO engtcent_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Then some men came down from Judea and were teaching the brothers: “If you are not circumcised according to the custom of Moses, you cannot be saved.” ");
INSERT INTO engtcent_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Therefore, when Paul and Barnabas had a great dissension and debate with them, the brothers appointed Paul and Barnabas and some others from among the believers to go up to the apostles and elders in Jerusalem to discuss this issue. ");
INSERT INTO engtcent_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","After being sent on their way by the church, they passed through Phoenicia and Samaria and brought great joy to all the brothers when they described in detail the conversion of the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","When they arrived in Jerusalem, they were welcomed by the church, the apostles, and the elders, and they reported all that God had done through them. ");
INSERT INTO engtcent_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","But some of the believers who belonged to the sect of the Pharisees stood up, saying, “It is necessary to circumcise the Gentiles and command them to keep the law of Moses.” ");
INSERT INTO engtcent_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","So the apostles and the elders gathered together to consider this matter. ");
INSERT INTO engtcent_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","After there had been much debate, Peter stood up and said to them, “Brothers, you know that in the early days God made a choice among us, that by the words of my mouth the Gentiles would hear the message of the gospel and believe. ");
INSERT INTO engtcent_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","And God, who knows the heart, testified to them by giving them the Holy Spirit, just as he did to us. ");
INSERT INTO engtcent_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","He made no distinction between us and them, purifying their hearts by faith. ");
INSERT INTO engtcent_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Now then, why are you putting God to the test by placing a yoke on the neck of the disciples that neither our fathers nor we have been able to bear? ");
INSERT INTO engtcent_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","On the contrary, we believe that we are saved by the grace of the Lord Jesus in the same way they are.” ");
INSERT INTO engtcent_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Then the entire assembly fell silent as they listened to Barnabas and Paul tell of all the signs and wonders God had performed through them among the Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","When they had finished speaking, James replied, “Brothers, listen to me. ");
INSERT INTO engtcent_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon has related how God first visited the Gentiles, to take from among them a people for his name. ");
INSERT INTO engtcent_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","The words of the prophets are in agreement with this, just as it is written: ");
INSERT INTO engtcent_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘After this I will return and rebuild the tabernacle of David that has fallen; I will rebuild its ruins and erect it again, ");
INSERT INTO engtcent_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","so that the rest of mankind may seek the Lord, even all the Gentiles who are called by my name, says the Lord, who does all these things.’ ");
INSERT INTO engtcent_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","All God's works are known to him from long ago. ");
INSERT INTO engtcent_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Therefore my judgment is that we not create difficulties for those among the Gentiles who turn to God, ");
INSERT INTO engtcent_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","but that we write to them, telling them to abstain from things defiled by idols, from fornication, from what has been strangled, and from blood. ");
INSERT INTO engtcent_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","For from generations of old, Moses has had those who preach him in every city, because he is read in the synagogues every Sabbath.” ");
INSERT INTO engtcent_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Then it seemed good to the apostles and to the elders, together with the whole church, to send men chosen from among them to Antioch with Paul and Barnabas, namely, Judas (called Barsabbas) and Silas, leading men among the brothers, ");
INSERT INTO engtcent_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","and to send with them this letter they had written: “The apostles, elders, and brothers, to the Gentile brothers in Antioch, Syria, and Cilicia: Greetings. ");
INSERT INTO engtcent_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Since we have heard that certain men, whom we did not authorize, have gone out from us and troubled you with their words, unsettling your minds by saying that you must be circumcised and keep the law, ");
INSERT INTO engtcent_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","it seemed good to us, having come to one accord, to send you men chosen from among us, along with our beloved Barnabas and Paul, ");
INSERT INTO engtcent_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","who have risked their lives for the name of our Lord Jesus Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Therefore we have sent Judas and Silas, who will tell you the same things in their own words. ");
INSERT INTO engtcent_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","For it seemed good to the Holy Spirit and to us to lay upon you no further burden than these essentials: ");
INSERT INTO engtcent_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","You must abstain from what has been sacrificed to idols, from blood, from what has been strangled, and from fornication. If you keep yourselves from these things, you will do well. Farewell.” ");
INSERT INTO engtcent_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","So when these men had been sent off, they went to Antioch, and after gathering the congregation together, they delivered the letter. ");
INSERT INTO engtcent_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","When the people read it, they rejoiced over its encouragement. ");
INSERT INTO engtcent_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Then Judas and Silas, who were themselves prophets, encouraged and strengthened the brothers with many words. ");
INSERT INTO engtcent_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","After spending some time there, they were sent off to the apostles in peace by the brothers. ");
INSERT INTO engtcent_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","But Paul and Barnabas stayed in Antioch, teaching and preaching, along with many others, the good news of the word of the Lord. ");
INSERT INTO engtcent_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","After some days had gone by, Paul said to Barnabas, “Let us return and visit our brothers in every city where we proclaimed the word of the Lord, to see how they are doing.” ");
INSERT INTO engtcent_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Now Barnabas wanted to bring John, who was called Mark. ");
INSERT INTO engtcent_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","But Paul thought it best not to bring this man who had deserted them in Pamphylia and had not gone on with them in their work. ");
INSERT INTO engtcent_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","So there arose a sharp disagreement, with the result that they parted from one another. Barnabas took Mark and sailed off to Cyprus, ");
INSERT INTO engtcent_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","but Paul chose Silas and departed, once he had been committed by the brothers to the grace of God. ");
INSERT INTO engtcent_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","And he went through Syria and Cilicia, strengthening the churches. ");
INSERT INTO engtcent_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul went on to Derbe and Lystra, and behold, a disciple named Timothy was there. He was the son of a Jewish woman who was a believer, but his father was a Greek. ");
INSERT INTO engtcent_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","He was well spoken of by the brothers in Lystra and Iconium. ");
INSERT INTO engtcent_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul wanted this man to go on with him, so he took him and circumcised him because of the Jews who were in those places, for they all knew that his father was a Greek. ");
INSERT INTO engtcent_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","As they went through the cities, they delivered the decisions that had been reached by the apostles and the elders in Jerusalem for the Gentile believers to obey. ");
INSERT INTO engtcent_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","So the churches were strengthened in the faith and increased in number every day. ");
INSERT INTO engtcent_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Then Paul and his companions went through Phrygia and the region of Galatia, having been forbidden by the Holy Spirit from speaking the word in Asia. ");
INSERT INTO engtcent_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","When they reached Mysia, they tried to go on toward Bithynia, but the Spirit did not allow them. ");
INSERT INTO engtcent_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","So passing by Mysia, they went down to Troas. ");
INSERT INTO engtcent_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","During the night Paul had a vision. A Macedonian man was standing there, urging him, “Come over to Macedonia and help us!” ");
INSERT INTO engtcent_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","After Paul saw the vision, we immediately endeavored to go on to Macedonia, concluding that the Lord had called us to preach the gospel to them. ");
INSERT INTO engtcent_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","So we set sail from Troas and followed a straight course to Samothrace, and on the next day we went to Neapolis. ");
INSERT INTO engtcent_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","From there we went on to Philippi, which is a Roman colony and a leading city of that district of Macedonia. We stayed in that city for several days. ");
INSERT INTO engtcent_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","On the Sabbath day we went outside the city to a riverside, where it was customary for there to be prayer. We sat down and began speaking to the women who had gathered together. ");
INSERT INTO engtcent_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","One of those listening to us was a woman named Lydia. She was a worshiper of God from the city of Thyatira and a seller of purple cloth. The Lord opened her heart to respond to what Paul was saying. ");
INSERT INTO engtcent_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","After she was baptized, along with her household, she urged us, “If you have judged me to be faithful to the Lord, come stay at my house.” And she persuaded us to do so. ");
INSERT INTO engtcent_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","One day, as we were on our way to prayer, we were met by a slave girl who had a spirit of divination. She had brought her masters much profit by fortune-telling. ");
INSERT INTO engtcent_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","She followed along behind Paul and us and kept crying out, “These men are servants of the Most High God, who proclaim to us a way of salvation.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","She kept on doing this for many days, and Paul became so annoyed that he turned and said to the spirit, “I command yoʋ in the name of Jesus Christ to come out of her.” And it came out that very hour. ");
INSERT INTO engtcent_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","When her masters saw that their hope for profit was gone, they seized Paul and Silas, dragged them to the marketplace, and set them before the authorities. ");
INSERT INTO engtcent_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","After bringing them to the magistrates, they said, “These men are seriously disturbing our city. They are Jews, ");
INSERT INTO engtcent_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","and they are proclaiming customs that are not lawful for us as Romans to accept or practice.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","The crowd rose up together against them, and the magistrates tore their garments off them and ordered them to be beaten with rods. ");
INSERT INTO engtcent_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","After inflicting many blows upon them, they threw them into prison, ordering the jailer to keep them under close guard. ");
INSERT INTO engtcent_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","When he received this order, he put them in the inner prison and fastened their feet in the stocks. ");
INSERT INTO engtcent_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","About midnight Paul and Silas were praying and singing hymns to God, and the prisoners were listening to them. ");
INSERT INTO engtcent_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Suddenly there was a great earthquake, so that the foundations of the prison were shaken. Immediately all the doors opened, and all the chains came loose. ");
INSERT INTO engtcent_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Then the jailer was awakened, and when he saw that the doors of the prison were open, he drew his sword and was about to kill himself, assuming that the prisoners had escaped. ");
INSERT INTO engtcent_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","But Paul cried out with a loud voice, “Do yoʋrself no harm, for we are all here.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Calling for lights, the jailer rushed in and fell down trembling before Paul and Silas. ");
INSERT INTO engtcent_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Then he brought them out and said, “Sirs, what must I do to be saved?” ");
INSERT INTO engtcent_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","They said, “Believe in the Lord Jesus Christ, and yoʋ will be saved, yoʋ and yoʋr household.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Then they spoke the word of the Lord to him and to everyone in his household. ");
INSERT INTO engtcent_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","He then took them in that hour of the night and washed their wounds. Then he was baptized at once, along with his entire household. ");
INSERT INTO engtcent_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","After bringing Paul and Silas into his house, he set a meal before them. And he rejoiced, along with his entire household, because he had come to believe in God. ");
INSERT INTO engtcent_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","When daybreak came, the magistrates sent their officers, saying, “Release those men.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","So the jailer reported these words to Paul, saying, “The magistrates have sent orders for you to be released. Therefore come out now and go in peace.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","But Paul said to them, “They beat us in public without a trial, even though we are Roman citizens, and they threw us into prison. And now they are sending us away secretly? Certainly not! Rather, let them come and escort us out themselves.” ");
INSERT INTO engtcent_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","So the officers reported these words to the magistrates, and the magistrates were afraid when they heard that the men were Roman citizens. ");
INSERT INTO engtcent_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","So they came and spoke to them in a conciliatory manner. As they escorted them out, they begged them to leave the city. ");
INSERT INTO engtcent_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","So Paul and Silas came out of the prison and went to Lydia's house. And after seeing the brothers and encouraging them, they departed. ");
INSERT INTO engtcent_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","When Paul and his companions had traveled through Amphipolis and Apollonia, they came to Thessalonica, where there was a synagogue of the Jews. ");
INSERT INTO engtcent_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","As was his custom, Paul went in to them, and for three Sabbaths he reasoned with them from the Scriptures, ");
INSERT INTO engtcent_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","explaining and presenting evidence that it was necessary for the Christ to suffer and to rise from the dead, saying, “This Jesus whom I am proclaiming to you is the Christ.” ");
INSERT INTO engtcent_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Some of the Jews were persuaded and joined Paul and Silas, as did a large number of the devout Greeks and quite a few prominent women. ");
INSERT INTO engtcent_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","But the Jews who refused to believe rounded up some evil men from the marketplace and formed a mob, setting the city in an uproar. They attacked Jason's house, seeking to bring Paul and Silas out to the public assembly. ");
INSERT INTO engtcent_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","But when they could not find them, they dragged Jason and some other brothers to the city officials, shouting, “These men who have turned the world upside down have come here also, ");
INSERT INTO engtcent_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","and Jason has welcomed them. They all act contrary to the decrees of Caesar, saying that there is another king, Jesus.” ");
INSERT INTO engtcent_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","And they stirred up the crowd and the city officials who heard these things. ");
INSERT INTO engtcent_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","But when the city officials had received a security bond from Jason and the others, they released them. ");
INSERT INTO engtcent_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","As soon as it was night the brothers sent Paul and Silas to Berea. When they arrived, they went to the synagogue of the Jews. ");
INSERT INTO engtcent_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Now these Jews were more noble than those in Thessalonica, and they received the word with great eagerness, examining the Scriptures every day to see if what Paul said was true. ");
INSERT INTO engtcent_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","As a result, many of them believed, as did quite a few of the Greek women of high standing and the men. ");
INSERT INTO engtcent_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","But when the Jews of Thessalonica found out that Paul was proclaiming the word of God in Berea also, they went there as well, agitating the crowds. ");
INSERT INTO engtcent_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Then the brothers immediately sent Paul away, as though he were going by sea, but Silas and Timothy remained in Berea. ");
INSERT INTO engtcent_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Those who escorted Paul brought him as far as Athens, and after they had received an order for Silas and Timothy to come to him as soon as possible, they departed. ");
INSERT INTO engtcent_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","While Paul was waiting for them in Athens, his spirit was provoked within him when he saw that the city was full of idols. ");
INSERT INTO engtcent_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","So he reasoned in the synagogue with the Jews and the devout Greeks, and in the marketplace every day with those who happened to be there. ");
INSERT INTO engtcent_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Some of the Epicurean and Stoic philosophers also conversed with him. Some said, “What is this babbler trying to say?” But others said, “He seems to be a proclaimer of foreign deities.” (They said this because he was preaching the good news about Jesus and the resurrection.) ");
INSERT INTO engtcent_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","So they took him and brought him to the Areopagus, saying, “May we know what this new teaching is that yoʋ are presenting? ");
INSERT INTO engtcent_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","For yoʋ are bringing some strange things to our ears, and we would like to know what they mean.” ");
INSERT INTO engtcent_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Now all the Athenians and the foreigners who dwelt there would spend their time in nothing else but talking about and listening to whatever the newest idea might be.) ");
INSERT INTO engtcent_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul then stood before the Areopagus and said, “Men of Athens, I see just how religious you are in every way. ");
INSERT INTO engtcent_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","For as I was going around and closely observing yoʋr objects of worship, I even found an altar that had been inscribed: ‘To an unknown god.’ I proclaim to you therefore the one whom you worship in ignorance. ");
INSERT INTO engtcent_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","The God who made the world and everything in it, who is Lord of heaven and earth, does not dwell in temples made by hands, ");
INSERT INTO engtcent_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","neither is he served by the hands of men, as though he needed anything. Rather, he himself continually gives life and breath to all mankind. ");
INSERT INTO engtcent_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","From one bloodline he created every nation of mankind to dwell on the entire face of the earth. He determined their appointed times and the boundaries of where they would dwell, ");
INSERT INTO engtcent_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","so that they might seek the Lord and perhaps feel their way toward him and find him, though he is not far from any one of us. ");
INSERT INTO engtcent_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","For in him we live and move and have our being, as even some of your own poets have said: ‘For we also are his offspring.’ ");
INSERT INTO engtcent_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Being then the offspring of God, we ought not to think that the divine being is like gold, silver, or stone, an image formed by the skill and imagination of man. ");
INSERT INTO engtcent_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Therefore, having overlooked the times of ignorance, God now commands all people everywhere to repent, ");
INSERT INTO engtcent_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","because he has set a day on which he is going to judge the world in righteousness by a man he has appointed. He has provided assurance of this to everyone by raising this man from the dead.” ");
INSERT INTO engtcent_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Now when they heard about the resurrection of the dead, some began to scoff, but others said, “We wish to hear about this from yoʋ again.” ");
INSERT INTO engtcent_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","So Paul departed from them, ");
INSERT INTO engtcent_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","but some of the people joined him and believed, among whom were Dionysius the Areopagite, a woman named Damaris, and others with them. ");
INSERT INTO engtcent_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","After this, Paul departed from Athens and went to Corinth. ");
INSERT INTO engtcent_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","There he found a Jew named Aquila, of Pontus by birth, who had recently come from Italy along with his wife Priscilla, because Claudius had ordered all the Jews to leave Rome. Paul came to them, ");
INSERT INTO engtcent_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","and because he was of the same trade, he stayed with them and worked, for they were tentmakers by trade. ");
INSERT INTO engtcent_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Every Sabbath he reasoned in the synagogue and tried to persuade both Jews and Greeks. ");
INSERT INTO engtcent_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","When Silas and Timothy came down from Macedonia, Paul was compelled by the Spirit and testified to the Jews that Jesus is the Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","But when the Jews opposed him and reviled him, he shook out his garments and said to them, “Your blood be upon your own heads! I am innocent. From now on I will go to the Gentiles.” ");
INSERT INTO engtcent_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","So he moved on from there and went to the house of a man named Justus, a worshiper of God, whose house was next door to the synagogue. ");
INSERT INTO engtcent_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, the ruler of the synagogue, believed in the Lord together with his whole household. And many of the Corinthians, when they heard, believed and were baptized. ");
INSERT INTO engtcent_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","One night the Lord said to Paul in a vision: “Do not be afraid, but speak and do not be silent. ");
INSERT INTO engtcent_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","For I am with yoʋ, and no one will attack yoʋ to do yoʋ harm, for I have many people in this city.” ");
INSERT INTO engtcent_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","So Paul stayed for a year and six months, teaching the word of God among them. ");
INSERT INTO engtcent_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","But when Gallio was proconsul of Achaia, the Jews rose up with one accord against Paul and brought him before the judgment seat, ");
INSERT INTO engtcent_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","saying, “This man is persuading people to worship God in a manner contrary to the law.” ");
INSERT INTO engtcent_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","But just as Paul was about to open his mouth to speak, Gallio said to the Jews, “If it were a matter of some crime or evil misdeed, O Jews, I would bear with you, as is reasonable. ");
INSERT INTO engtcent_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","But since it is a question about words, names, and your own law, see to it yourselves, for I do not want to be a judge of such things.” ");
INSERT INTO engtcent_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","So he drove them away from the judgment seat. ");
INSERT INTO engtcent_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Then all the Greeks took Sosthenes, the ruler of the synagogue, and began beating him in front of the judgment seat. But none of these things were of any concern to Gallio. ");
INSERT INTO engtcent_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","After staying in Corinth for many more days, Paul took leave of the brothers and set sail for Syria, and Priscilla and Aquila were with him. (Now he had shaved his head in Cenchreae because he was under a vow.) ");
INSERT INTO engtcent_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","When he arrived at Ephesus, he left Priscilla and Aquila there, but he himself went into the synagogue and reasoned with the Jews. ");
INSERT INTO engtcent_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","When they asked him to stay with them for a longer period of time, he declined. ");
INSERT INTO engtcent_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","However, as he took leave of them, he said, “I must by all means keep the coming feast in Jerusalem, but I will return to you again, God willing.” Then he set sail from Ephesus. ");
INSERT INTO engtcent_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","When he arrived at Caesarea, he went up and greeted the church, and then went down to Antioch. ");
INSERT INTO engtcent_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","After spending some time there, he departed and went from place to place throughout the region of Galatia and Phrygia, strengthening all the disciples. ");
INSERT INTO engtcent_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Meanwhile a Jew named Apollos, an Alexandrian by birth, arrived in Ephesus. He was an eloquent man, well-versed in the Scriptures. ");
INSERT INTO engtcent_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","He had been instructed in the way of the Lord. Being fervent in spirit, he spoke and accurately taught the facts about the Lord, though he knew only about the baptism of John. ");
INSERT INTO engtcent_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","He began to speak boldly in the synagogue, but when Aquila and Priscilla heard him, they took him aside and explained to him the way of God in greater detail. ");
INSERT INTO engtcent_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","And when Apollos wanted to cross over to Achaia, the brothers wrote to the disciples, encouraging them to receive him. When he arrived, he was a great help to those who had become believers through grace, ");
INSERT INTO engtcent_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","for he powerfully refuted the Jews in public, showing by the Scriptures that Jesus is the Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","While Apollos was in Corinth, Paul went through the interior regions and came to Ephesus, where he came across some disciples. ");
INSERT INTO engtcent_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","He said to them, “Did you receive the Holy Spirit when you believed?” They said to him, “No, we have not even heard that there is a Holy Spirit.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","So Paul said to them, “Into what then were you baptized?” They said, “Into John's baptism.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Then Paul said, “John baptized with a baptism of repentance, telling the people to believe in the one who was to come after him, that is, in Christ Jesus.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","On hearing this, they were baptized in the name of the Lord Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","And when Paul laid his hands on them, the Holy Spirit came upon them, and they began speaking in tongues and prophesying. ");
INSERT INTO engtcent_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","There were about twelve men in all. ");
INSERT INTO engtcent_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Over a period of three months Paul would go into the synagogue and speak boldly, reasoning and persuading the people about the kingdom of God. ");
INSERT INTO engtcent_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","But some became hardened and refused to believe, speaking evil of the Way in front of the congregation. So Paul left them and took the disciples with him, reasoning daily in the lecture hall of a man named Tyrannus. ");
INSERT INTO engtcent_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","This continued for two years, so that all who dwelt in Asia, both Jews and Greeks, heard the word of the Lord Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Now God was performing extraordinary miracles by the hands of Paul, ");
INSERT INTO engtcent_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","so that even cloths or aprons that had touched his skin were placed upon the sick, and their diseases left them, and evil spirits came out of them. ");
INSERT INTO engtcent_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Then some of the itinerant Jewish exorcists attempted to invoke the name of the Lord Jesus over those who had evil spirits. They would say, “We adjure you by the Jesus whom Paul preaches.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Seven sons of Sceva, a Jewish high priest, were doing this. ");
INSERT INTO engtcent_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","But one day an evil spirit responded, “I know Jesus, and I am acquainted with Paul, but who are you?” ");
INSERT INTO engtcent_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Then the man who had the evil spirit jumped on them, overpowered them, and prevailed against them, so that they fled from the house naked and wounded. ");
INSERT INTO engtcent_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","When this became known to all the Jews and Greeks who dwelt in Ephesus, fear fell upon them all, and the name of the Lord Jesus was being magnified. ");
INSERT INTO engtcent_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Many who had become believers came forward, confessing and disclosing their practices, ");
INSERT INTO engtcent_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","while many who practiced magical arts brought their books together and began burning them in front of everyone. When the value of the books was added up, the total came to fifty thousand silver coins. ");
INSERT INTO engtcent_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","In this way the word of the Lord was increasing and prevailing mightily. ");
INSERT INTO engtcent_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","After these things had taken place, Paul resolved in his spirit to pass through Macedonia and Achaia and go on to Jerusalem, saying, “After I have been there, I must see Rome also.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","So he sent two of his helpers, Timothy and Erastus, to Macedonia, while he himself stayed in Asia for a period of time. ");
INSERT INTO engtcent_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","About that time a great disturbance arose concerning the Way. ");
INSERT INTO engtcent_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","For a man named Demetrius, a silversmith who made silver shrines of Artemis, brought in a great deal of business to the craftsmen. ");
INSERT INTO engtcent_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","He gathered these men together, along with those who worked in similar trades, and said, “Men, you know that our wealth is derived from this business. ");
INSERT INTO engtcent_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","You also see and hear that, not only in Ephesus, but in nearly all of Asia, this man Paul has persuaded and drawn away a considerable crowd, saying that gods made by hands are not gods at all. ");
INSERT INTO engtcent_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Not only is there the danger that this trade of ours might come into disrepute, but also that the temple of the great goddess Artemis might be regarded as nothing, and that her magnificence might be brought down, whom all Asia and the world worship.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","When they heard this, they were filled with rage and began crying out, “Great is Artemis of the Ephesians!” ");
INSERT INTO engtcent_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","So the whole city was filled with confusion, and they rushed with one accord into the amphitheater, seizing Gaius and Aristarchus, Macedonians who were Paul's traveling companions. ");
INSERT INTO engtcent_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Although Paul wanted to go into the public assembly, the disciples would not let him. ");
INSERT INTO engtcent_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Even some of the provincial officials of Asia, who were friends of Paul, sent word to him, begging him not to venture into the amphitheater. ");
INSERT INTO engtcent_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Now some were shouting one thing, and some were shouting another, for the assembly was confused, and the majority did not know for what reason they had come together. ");
INSERT INTO engtcent_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","So the Jews put forward Alexander, who was then brought before the crowd. Alexander motioned with his hand, wishing to make a defense to the public assembly. ");
INSERT INTO engtcent_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","But when they realized he was a Jew, a single outcry arose from them all as they shouted for about two hours, “Great is Artemis of the Ephesians!” ");
INSERT INTO engtcent_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","When the city clerk had quieted the crowd, he said, “Men of Ephesus, who is there that does not know that the city of the Ephesians is the temple keeper of the great goddess Artemis and of the image that fell down from Zeus? ");
INSERT INTO engtcent_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Therefore, since these facts are undeniable, you must keep calm and not do anything rash. ");
INSERT INTO engtcent_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","For you have brought these men here who are neither temple robbers nor blasphemers of your goddess. ");
INSERT INTO engtcent_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","So if Demetrius and his fellow craftsmen have a complaint against anyone, the courts are open, and there are proconsuls; let them bring charges against one another. ");
INSERT INTO engtcent_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","But if you seek anything concerning other matters, it must be settled in the lawful assembly. ");
INSERT INTO engtcent_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","For we are in danger of being charged with rioting in connection with today's events, since there is no reason we can give to account for this disorderly gathering.” ");
INSERT INTO engtcent_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","And after saying this, he dismissed the assembly. ");
INSERT INTO engtcent_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","After the uproar ceased, Paul summoned the disciples, said goodbye, and departed to go to Macedonia. ");
INSERT INTO engtcent_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","After going through those regions and encouraging the believers with many words, he came to Greece, ");
INSERT INTO engtcent_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","where he stayed for three months. As he was about to set sail for Syria, a plot was made against him by the Jews, so the decision was made to return by way of Macedonia. ");
INSERT INTO engtcent_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopater of Berea accompanied him as far as Asia, and so did Aristarchus and Secundus of Thessalonica, Gaius of Derbe, Timothy, and Tychicus and Trophimus of Asia. ");
INSERT INTO engtcent_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","These men went on ahead and waited for us in Troas. ");
INSERT INTO engtcent_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","But we sailed from Philippi after the Feast of Unleavened Bread, and five days later we came to them at Troas, where we stayed for seven days. ");
INSERT INTO engtcent_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","On the first day of the week, as the disciples were gathered together to break bread, Paul addressed them, intending to depart the next day, and he prolonged his message until midnight. ");
INSERT INTO engtcent_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Now there were many lamps in the upper room where we were gathered together, ");
INSERT INTO engtcent_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","and a young man named Eutychus, who was sitting on the window sill, sank into a deep sleep while Paul continued speaking for a long time. Overcome by sleep, he fell down from the third story and was picked up dead. ");
INSERT INTO engtcent_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","But Paul went down and threw himself on the young man. Taking him in his arms, he said, “Do not be alarmed, for his life is in him.” ");
INSERT INTO engtcent_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Then Paul went back upstairs, and after he had broken bread and eaten, he conversed with the disciples for a long time, until dawn; that was how he departed. ");
INSERT INTO engtcent_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","And they brought the boy home alive and were comforted beyond measure. ");
INSERT INTO engtcent_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Then we went to the ship and set sail for Assos, intending to take Paul on board there, for that is what he had arranged, since he himself intended to go by land. ");
INSERT INTO engtcent_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","When he met us in Assos, we took him on board and went to Mitylene. ");
INSERT INTO engtcent_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","We set sail from there and arrived off Chios on the following day. The next day we reached Samos and stayed in Trogyllium, and the day after that we came to Miletus. ");
INSERT INTO engtcent_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","For Paul had decided to sail past Ephesus so as not to spend time in Asia, because he was hurrying to arrive in Jerusalem, if possible, by the day of Pentecost. ");
INSERT INTO engtcent_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","From Miletus Paul sent to Ephesus and called for the elders of the church. ");
INSERT INTO engtcent_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","When they came to him, he said to them, “You yourselves know how I lived the whole time I was with you, from the day I first set foot in Asia, ");
INSERT INTO engtcent_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","serving the Lord with all humility and with many tears and trials, which came upon me because of the plots of the Jews. ");
INSERT INTO engtcent_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","You know that I did not hold back from declaring to you anything that was beneficial, and from teaching you in public and from house to house, ");
INSERT INTO engtcent_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","testifying to both Jews and Greeks about repentance toward God and faith in our Lord Jesus. ");
INSERT INTO engtcent_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","And now, behold, I am going to Jerusalem, compelled by the Spirit, not knowing what will happen to me there, ");
INSERT INTO engtcent_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","except that the Holy Spirit testifies in every city that imprisonment and afflictions await me. ");
INSERT INTO engtcent_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","But I take no account of these things, nor do I regard my life as precious to myself, if only I may complete my course with joy and the ministry that I received from the Lord Jesus, to testify to the gospel of the grace of God. ");
INSERT INTO engtcent_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“And now, behold, I know that none of you among whom I have gone about preaching the kingdom of God will see my face again. ");
INSERT INTO engtcent_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Therefore I testify to you this day that I am innocent of the blood of you all. ");
INSERT INTO engtcent_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","For I have not held back from declaring to you the whole counsel of God. ");
INSERT INTO engtcent_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","So keep watch over yourselves and over the entire flock. The Holy Spirit has appointed you as their overseers, to shepherd the church of our Lord and God, which he obtained with his own blood. ");
INSERT INTO engtcent_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","For I know that after my departure fierce wolves will enter in among you, not sparing the flock. ");
INSERT INTO engtcent_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Even from your own number men will rise up, speaking perverse things to draw the disciples away after them. ");
INSERT INTO engtcent_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Therefore be watchful, remembering that, night and day, for three years I did not stop admonishing each one of you, with tears. ");
INSERT INTO engtcent_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","And now, brothers, I entrust you to God and to the word of his grace, which is able to build you up and give you an inheritance among all who are sanctified. ");
INSERT INTO engtcent_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","I coveted no one's silver, gold, or clothing. ");
INSERT INTO engtcent_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","You yourselves know that these hands of mine ministered to my own needs and to the needs of those who were with me. ");
INSERT INTO engtcent_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","In all things I have shown you that we must labor in this way and help those who are weak, remembering what the Lord Jesus himself said: ‘It is more blessed to give than to receive.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","After saying these things, Paul knelt down and prayed with them all. ");
INSERT INTO engtcent_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","There was much weeping among them all, and they threw their arms around Paul's neck and kissed him, ");
INSERT INTO engtcent_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","being especially grieved over his statement that they would see his face no more. Then they accompanied him to the ship. ");
INSERT INTO engtcent_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","After we parted from them and set sail, we followed a straight course and came to Cos. The next day we reached Rhodes, and from there we went to Patara. ");
INSERT INTO engtcent_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","When we found a ship crossing over to Phoenicia, we went on board and set sail. ");
INSERT INTO engtcent_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","After coming in sight of Cyprus, we passed it on the left, sailed to Syria, and arrived at Tyre, for there the ship was to unload its cargo. ");
INSERT INTO engtcent_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Then we found some disciples and stayed there for seven days. Through the Spirit they kept telling Paul not to go up to Jerusalem, ");
INSERT INTO engtcent_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","but when our days there came to an end, we left and went on our way. All the disciples accompanied us, along with their wives and children, until we were outside of the city. Then we knelt down on the beach and prayed. ");
INSERT INTO engtcent_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","After saying goodbye to one another, we got on board the ship, and they returned to their homes. ");
INSERT INTO engtcent_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","When we completed the voyage from Tyre, we arrived at Ptolemais. After greeting the brothers, we stayed with them for one day. ");
INSERT INTO engtcent_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","The next day Paul and his companions left and went to Caesarea. We entered the house of Philip the evangelist, who was one of the seven, and stayed with him. ");
INSERT INTO engtcent_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","(He had four virgin daughters who prophesied.) ");
INSERT INTO engtcent_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","After we had been there for several days, a prophet named Agabus came down from Judea. ");
INSERT INTO engtcent_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","He came to us and took Paul's belt, and binding his own feet and hands, he said, “Thus says the Holy Spirit, ‘In this way the Jews in Jerusalem will bind the man who owns this belt and deliver him into the hands of the Gentiles.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","When we heard this, we and the local residents urged Paul not to go up to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","But Paul responded, “What are you doing, weeping and breaking my heart? For I am ready not only to be imprisoned, but even to die in Jerusalem for the name of the Lord Jesus.” ");
INSERT INTO engtcent_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Since he would not be persuaded, we said, “The Lord's will be done,” and then we kept silent. ");
INSERT INTO engtcent_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","After those days we packed up our belongings and went up to Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Some of the disciples from Caesarea went with us, bringing us to a Cypriot man named Mnason, an early disciple, with whom we were to stay. ");
INSERT INTO engtcent_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","When we arrived in Jerusalem, the brothers warmly welcomed us. ");
INSERT INTO engtcent_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","The following day Paul went in with us to James, and all the elders were present. ");
INSERT INTO engtcent_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","After greeting them, he reported in detail what God had done among the Gentiles through his ministry. ");
INSERT INTO engtcent_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","When they heard this, they began glorifying the Lord. Then they said to him, “Yoʋ see, brother, how many thousands of Jews there are who have become believers, and they are all zealous for the law. ");
INSERT INTO engtcent_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","They have been informed that yoʋ teach all the Jews who live among the Gentiles to forsake Moses, telling them not to circumcise their children or walk according to our customs. ");
INSERT INTO engtcent_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","What then is to be done? The assembly will surely meet, for they will hear that yoʋ have come. ");
INSERT INTO engtcent_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","So yoʋ must do what we tell yoʋ. There are four men who are under a vow. ");
INSERT INTO engtcent_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Take these men and purify yoʋrself along with them and pay their expenses, so that they may shave their heads. Then everyone will know that there is no truth to what they have been told about yoʋ, but that yoʋ yoʋrself also walk in an orderly manner, keeping the law. ");
INSERT INTO engtcent_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","But as for the Gentiles who have become believers, we have written a letter with our judgment that they should observe no such thing, except that they should keep themselves from what has been sacrificed to idols, from blood, from what has been strangled, and from fornication.” ");
INSERT INTO engtcent_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Then Paul took the men, and on the next day he purified himself with them and went to the temple, giving notice of when the days of their purification would be completed and the offering would be presented for each of them. ");
INSERT INTO engtcent_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","When the seven days were about to be completed, the Jews from Asia saw Paul in the temple courts and began stirring up the entire crowd. They seized him, ");
INSERT INTO engtcent_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","crying out, “Men of Israel, help us! This is the man who teaches everyone everywhere against our people, our law, and this place. Furthermore, he has even brought Greeks into the inner courts of the temple and has defiled this holy place.” ");
INSERT INTO engtcent_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(For they had seen Trophimus the Ephesian in the city with Paul, and they assumed that Paul had brought him into the inner courts of the temple.) ");
INSERT INTO engtcent_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Then the entire city was in an uproar, and the people rushed together. They seized Paul and dragged him out of the temple courts, and the gates were immediately shut. ");
INSERT INTO engtcent_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","But as they were trying to kill him, a report went up to the commander of the Roman cohort that all Jerusalem was in an uproar. ");
INSERT INTO engtcent_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","At once he took soldiers and centurions and ran down to them. When the mob saw the commander and the soldiers, they stopped beating Paul. ");
INSERT INTO engtcent_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Then the commander came up, took him into custody, and commanded him to be bound with two chains. He then asked who he was and what he had done. ");
INSERT INTO engtcent_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","But some in the crowd were shouting one thing, and some were shouting another, and since the commander could not find out any reliable information because of the uproar, he ordered Paul to be taken away to the barracks. ");
INSERT INTO engtcent_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","When Paul reached the steps, he had to be carried by the soldiers because of the violence of the crowd. ");
INSERT INTO engtcent_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","For the mob of people was following behind, crying out, “Away with him.” ");
INSERT INTO engtcent_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","As Paul was about to be brought into the barracks, he said to the commander, “Do I have permission to speak to yoʋ?” The commander said, “Yoʋ know how to speak Greek? ");
INSERT INTO engtcent_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Then yoʋ are not the Egyptian who before these days incited a revolt and led four thousand men of the Assassins out into the wilderness?” ");
INSERT INTO engtcent_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul said, “I am a Jewish man from Tarsus of Cilicia, a citizen of an important city. Now I beg yoʋ, let me speak to the people.” ");
INSERT INTO engtcent_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","When the commander gave him permission, Paul stood on the steps and motioned with his hand to the people. When there was a great hush, he addressed them in the Hebrew language, ");
INSERT INTO engtcent_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Brothers and fathers, listen to the defense I now make to you.” ");
INSERT INTO engtcent_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","When they heard that he was addressing them in the Hebrew language, they became even more quiet. Then he said, ");
INSERT INTO engtcent_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“I am a Jewish man, born in Tarsus of Cilicia, but brought up in this city at the feet of Gamaliel and instructed according to the strict manner of the law of our fathers, being zealous for God, just as all of you are today. ");
INSERT INTO engtcent_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","I persecuted this Way to the death, binding both men and women and putting them in prison, ");
INSERT INTO engtcent_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","as the high priest can testify about me, along with the whole council of elders. From them I received letters to the brothers in Damascus and then made my way there to make arrests and bring the prisoners back to Jerusalem to be punished. ");
INSERT INTO engtcent_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“About noon, as I was going along and drawing near to Damascus, a great light from heaven suddenly flashed around me. ");
INSERT INTO engtcent_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Then I fell to the ground and heard a voice saying to me, ‘Saul, Saul, why are yoʋ persecuting me?’ ");
INSERT INTO engtcent_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","I answered, ‘Who are yoʋ, Lord?’ He said to me, ‘I am Jesus of Nazareth, whom yoʋ are persecuting.’ ");
INSERT INTO engtcent_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Those who were with me saw the light and were afraid, but they did not understand the voice of the one who was speaking to me. ");
INSERT INTO engtcent_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Then I said, ‘What should I do, Lord?’ The Lord said to me, ‘Rise and go to Damascus, and there yoʋ will be told about all that has been appointed for yoʋ to do.’ ");
INSERT INTO engtcent_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","But since I could not see because of the brightness of that light, I was led by the hand by those who were with me, and went into Damascus. ");
INSERT INTO engtcent_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Now a certain Ananias, a devout man according to the law, who was well spoken of by all the Jews dwelling there, ");
INSERT INTO engtcent_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","came and stood beside me. He said to me, ‘Brother Saul, receive yoʋr sight,’ and in that very hour I received my sight and saw him. ");
INSERT INTO engtcent_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Then he said, ‘The God of our fathers has appointed yoʋ to know his will, to see the Righteous One, and to hear the voice coming from his mouth. ");
INSERT INTO engtcent_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","For yoʋ will be his witness to all people of what yoʋ have seen and heard. ");
INSERT INTO engtcent_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","And now why do yoʋ delay? Rise and be baptized, and wash away yoʋr sins, calling upon the name of the Lord.’ ");
INSERT INTO engtcent_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“When I returned to Jerusalem and was praying at the temple, I fell into a trance ");
INSERT INTO engtcent_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","and saw the Lord saying to me, ‘Make haste and get out of Jerusalem quickly, for they will not accept yoʋr testimony about me.’ ");
INSERT INTO engtcent_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","So I said, ‘Lord, they know that in every synagogue I imprisoned and beat those who believe in yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","And when the blood of yoʋr witness Stephen was being shed, I myself stood there approving of his execution as I watched over the cloaks of those who were killing him.’ ");
INSERT INTO engtcent_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Then the Lord said to me, ‘Go, for I will send yoʋ far away to the Gentiles.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","The crowd listened to Paul until he made this statement, but then they lifted up their voices and said, “Away with this man from the earth! For he should not be allowed to live.” ");
INSERT INTO engtcent_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","As they were crying out, throwing off their cloaks and flinging dust into the air, ");
INSERT INTO engtcent_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","the commander ordered Paul to be brought into the barracks, saying that he should be examined by flogging, to find out the reason why they were shouting at him in this way. ");
INSERT INTO engtcent_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","But as one of the soldiers was stretching Paul out with the straps, Paul said to the centurion standing nearby, “Is it lawful for you to whip a Roman citizen without a proper trial?” ");
INSERT INTO engtcent_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","When the centurion heard this, he went and reported it to the commander, saying, “Consider what yoʋ are about to do, for this man is a Roman citizen.” ");
INSERT INTO engtcent_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","So the commander went over and said to Paul, “Tell me, are yoʋ a Roman citizen?” He said, “Yes.” ");
INSERT INTO engtcent_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","The commander responded, “I acquired this citizenship with a large sum of money.” Paul said, “But I am a citizen by birth.” ");
INSERT INTO engtcent_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","So those who were about to examine him immediately drew back, and the commander was afraid when he realized that Paul was a Roman citizen and that he had bound him. ");
INSERT INTO engtcent_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","So the next day, wishing to know for certain why Paul was being accused by the Jews, the commander released him from his bonds and commanded the chief priests and their entire Sanhedrin to come. Then he brought Paul down and had him stand before them. ");
INSERT INTO engtcent_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Looking intently at the Sanhedrin, Paul said, “Brothers, in all good conscience I have lived as a citizen before God to this day.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","At this the high priest Ananias commanded those who were standing beside Paul to strike him on the mouth. ");
INSERT INTO engtcent_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Then Paul said to him, “God is about to strike yoʋ, yoʋ whitewashed wall! Are yoʋ sitting there judging me according to the law, and yet contrary to the law ordering me to be struck?” ");
INSERT INTO engtcent_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Those standing nearby said, “Do yoʋ dare to insult God's high priest?” ");
INSERT INTO engtcent_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul said, “I did not know, brothers, that he was the high priest. For it is written, ‘Yoʋ shall not speak evil of a ruler of yoʋr people.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Now when Paul realized that some were Sadducees and others were Pharisees, he cried out in the Sanhedrin, “Brothers, I am a Pharisee, the son of a Pharisee. It is regarding the hope of the resurrection of the dead that I am on trial.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","When he said this, a dissension arose on the part of the Pharisees, and the assembly was divided. ");
INSERT INTO engtcent_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(For the Sadducees say that there is no resurrection, and that there are neither angels nor spirits, but the Pharisees acknowledge them all.) ");
INSERT INTO engtcent_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Then there arose a great clamor, and the scribes of the Pharisees' party stood up and argued vehemently, “We find no evil in this man. If a spirit has spoken to him, or an angel, let us not fight against God.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","When the dissension grew violent, the commander, exercising caution lest Paul be torn to pieces by them, ordered the troops to go down, take him away from them by force, and bring him into the barracks. ");
INSERT INTO engtcent_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","The following night the Lord stood near Paul and said, “Take courage, Paul, for as yoʋ have testified about me in Jerusalem, so yoʋ must also testify in Rome.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","When daybreak came, some of the Jews formed a conspiracy and bound themselves under a curse, saying that they would neither eat nor drink until they had killed Paul. ");
INSERT INTO engtcent_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","More than forty men had taken an oath to join this conspiracy. ");
INSERT INTO engtcent_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","They went to the chief priests and the elders and said, “We have bound ourselves under a solemn curse to taste nothing until we have killed Paul. ");
INSERT INTO engtcent_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Now then, you and the council must make an official request to the commander to bring him down to you tomorrow, as though you would be investigating the facts about his case in greater detail. And we will be ready to kill him before he draws near to this place.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","But when the son of Paul's sister heard about this ambush, he went into the barracks and told Paul. ");
INSERT INTO engtcent_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Then Paul called one of the centurions over and said, “Take this young man to the commander, for he has something to tell him.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","So he took the young man, brought him to the commander, and said, “The prisoner Paul called for me and asked me to bring this young man to yoʋ because he has something to tell yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","So the commander took the young man by the hand, drew him aside privately, and asked, “What is it that yoʋ have to tell me?” ");
INSERT INTO engtcent_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","The young man said, “The Jews have agreed to ask yoʋ to bring Paul down to the Sanhedrin tomorrow, as though the members of the Sanhedrin would be inquiring about his case in greater detail. ");
INSERT INTO engtcent_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Do not be persuaded by them, for more than forty men are lying in ambush for him. They have bound themselves under a curse not to eat or drink until they have killed him. They are now ready, waiting for yoʋr consent.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","So the commander sent the young man away, ordering him, “Tell no one that yoʋ have reported this to me.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Then he called over two of the centurions and said, “Get two hundred soldiers ready by the third hour of the night to go to Caesarea, along with seventy horsemen and two hundred spearmen. ");
INSERT INTO engtcent_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Provide mounts so that they may set Paul on one and bring him safely to Felix the governor.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Then he wrote the following letter: ");
INSERT INTO engtcent_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Claudius Lysias, to the most excellent governor Felix: Greetings. ");
INSERT INTO engtcent_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","This man was seized by the Jews and was about to be killed by them when I came with the troops and rescued him, having learned that he was a Roman citizen. ");
INSERT INTO engtcent_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Wishing to know the reason why they were accusing him, I brought him down to their Sanhedrin. ");
INSERT INTO engtcent_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","I discovered that he was being accused about questions of their own law, but had no accusation against him that deserved death or imprisonment. ");
INSERT INTO engtcent_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","When I was informed that a plot was about to be executed against this man by the Jews, I sent him to yoʋ at once, also ordering his accusers to state before yoʋ the charges against him. Farewell.” ");
INSERT INTO engtcent_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","So the soldiers took Paul and brought him to Antipatris by night, just as they had been commanded. ");
INSERT INTO engtcent_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","The next day, they let the horsemen go on with him, while they returned to the barracks. ");
INSERT INTO engtcent_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","When the horsemen came to Caesarea and delivered the letter to the governor, they presented Paul to him as well. ");
INSERT INTO engtcent_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","After the governor read the letter, he asked what province Paul was from. When he learned that he was from Cilicia, ");
INSERT INTO engtcent_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","he said, “I will give yoʋ a hearing once yoʋr accusers have arrived.” Then he gave orders for him to be kept at Herod's headquarters. ");
INSERT INTO engtcent_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Five days later the high priest Ananias came down with the elders and an attorney named Tertullus. They presented their case against Paul to the governor. ");
INSERT INTO engtcent_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","When Paul had been summoned, Tertullus began to present his case before Felix, saying, “Since we have experienced much peace because of yoʋ, and prosperity is coming to this nation by yoʋr foresight, ");
INSERT INTO engtcent_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","both in every way and in every place we acknowledge it, most excellent Felix, with the utmost gratitude. ");
INSERT INTO engtcent_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","But so that I may not detain yoʋ any further, I request that, in yoʋr forbearance, yoʋ would hear us briefly. ");
INSERT INTO engtcent_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","For we have found this man to be a pestilent fellow, an instigator of dissension among all the Jews throughout the world, and a ringleader of the sect of the Nazarenes. ");
INSERT INTO engtcent_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","He even tried to desecrate the temple, so we seized him. ");
INSERT INTO engtcent_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","By examining him yoʋrself yoʋ will be able to learn the truth about all these accusations we are making against him.” ");
INSERT INTO engtcent_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","The Jews also joined in the accusation, claiming that these things were so. ");
INSERT INTO engtcent_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","When the governor motioned for him to speak, Paul responded, “Knowing that yoʋ have been a judge over this nation for many years, I all the more cheerfully make my defense concerning these charges against me. ");
INSERT INTO engtcent_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yoʋ can ascertain that it has not been more than twelve days since I went up to worship in Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Neither in the temple courts, nor in the synagogues, nor anywhere in the city did they find me arguing with anyone or stirring up a crowd. ");
INSERT INTO engtcent_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nor can they offer any proof against me concerning the things of which they now accuse me. ");
INSERT INTO engtcent_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","But I confess this to yoʋ, that according to the Way, which they call a sect, I serve the God of our fathers, believing everything that is written throughout the Law and in the Prophets, ");
INSERT INTO engtcent_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","having a hope in God, which these men themselves also accept, that there will be a resurrection of the dead, both of the righteous and the unrighteous. ");
INSERT INTO engtcent_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Because of this I strive the way I do, always having a clear conscience before God and men. ");
INSERT INTO engtcent_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","After being away for many years, I came to bring charitable gifts to my nation along with offerings. ");
INSERT INTO engtcent_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","While I was doing this, some Jews from Asia found me in the temple courts as I was completing the rite of purification, without any crowd or commotion. ");
INSERT INTO engtcent_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","They ought to be here before yoʋ and make an accusation if they have anything against me. ");
INSERT INTO engtcent_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Or these men themselves should state what wrongdoing they found in me when I stood before the Sanhedrin, ");
INSERT INTO engtcent_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","other than this one thing that I cried out while standing among them: ‘It is regarding the resurrection of the dead that I am being tried by you today.’ ” ");
INSERT INTO engtcent_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","After hearing these things, Felix, who knew the facts concerning the Way in great detail, had them adjourn, saying, “When Lysias the commander comes down, I will decide your case.” ");
INSERT INTO engtcent_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Then he ordered the centurion to keep Paul in custody, but to allow him a certain measure of freedom and not to prevent his own people from attending to his needs or visiting him. ");
INSERT INTO engtcent_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","After several days, when Felix came back with his wife Drusilla, who was Jewish, he sent for Paul and listened to him speak about faith in Christ. ");
INSERT INTO engtcent_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","But as Paul was discussing righteousness, self-control, and the coming judgment, Felix became frightened and said in response, “Go away for now, and when I get an opportunity I will call for yoʋ.” ");
INSERT INTO engtcent_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","At the same time he was hoping that Paul would give him money, so that he might release him. So he would send for Paul quite often and converse with him. ");
INSERT INTO engtcent_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","But after two years had passed, Felix was succeeded by Porcius Festus. And wishing to gain favor with the Jews, Felix left Paul in prison. ");
INSERT INTO engtcent_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Three days after arriving in the province, Festus went up to Jerusalem from Caesarea, ");
INSERT INTO engtcent_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","where the high priest and prominent Jewish men presented their case against Paul. ");
INSERT INTO engtcent_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Asking for a favor against Paul, they urged Festus to summon him to Jerusalem, because they were planning an ambush to kill him on the way. ");
INSERT INTO engtcent_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","But Festus replied that Paul was being kept in custody in Caesarea, and that he himself was about to go there shortly. ");
INSERT INTO engtcent_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“So,” he said, “let those among you who are influential go down with me, and if there is any fault in this man, they can bring charges against him.” ");
INSERT INTO engtcent_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","After staying among them for more than ten days, Festus went down to Caesarea. The next day he sat on the judgment seat and ordered Paul to be brought in. ");
INSERT INTO engtcent_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","When Paul arrived, the Jews who had come down from Jerusalem stood around him, bringing many serious charges against him that they could not prove. ");
INSERT INTO engtcent_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Then Paul said in his own defense, “Neither against the law of the Jews, nor against the temple, nor against Caesar have I committed any offense.” ");
INSERT INTO engtcent_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","But Festus, wishing to gain favor with the Jews, responded to Paul, “Are yoʋ willing to go up to Jerusalem and stand trial before me there on these charges?” ");
INSERT INTO engtcent_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul said, “I am standing before the judgment seat of Caesar, where I ought to stand trial. I have done the Jews no wrong, as yoʋ yoʋrself know very well. ");
INSERT INTO engtcent_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","If I am in the wrong and have done something that deserves death, I do not seek to escape death. But if none of the things these men accuse me of is true, no one can hand me over to them. I appeal to Caesar.” ");
INSERT INTO engtcent_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","After conferring with the council, Festus answered, “Yoʋ have appealed to Caesar; to Caesar yoʋ shall go.” ");
INSERT INTO engtcent_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","After several days had passed, King Agrippa and Bernice arrived at Caesarea and greeted Festus. ");
INSERT INTO engtcent_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Since he was staying there for several days, Festus presented Paul's case to him, saying, “There is a man who was left as a prisoner by Felix. ");
INSERT INTO engtcent_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","When I was in Jerusalem, the chief priests and the elders of the Jews presented their case and asked for a judgment against him. ");
INSERT INTO engtcent_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","I answered them that it is not the custom of the Romans to hand anyone over for destruction before the accused faces his accusers and has an opportunity to make his defense concerning the charges. ");
INSERT INTO engtcent_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","So when they had assembled here, I did not postpone the case, but on the next day I sat on the judgment seat and ordered the man to be brought in. ");
INSERT INTO engtcent_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","When his accusers stood up, they brought no charge against him of the sort I was expecting. ");
INSERT INTO engtcent_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Instead they had certain points of disagreement with him about their own religion and about a man named Jesus who was dead, but whom Paul claimed was alive. ");
INSERT INTO engtcent_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Since I was at a loss as to how to investigate this matter, I asked if he might be willing to go to Jerusalem and stand trial there on these charges. ");
INSERT INTO engtcent_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","But Paul appealed to be kept in custody for the decision of His Majesty the Emperor, so I ordered him to be held until I could send him to Caesar.” ");
INSERT INTO engtcent_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Then Agrippa said to Festus, “I would like to hear the man myself.” Festus said, “Tomorrow yoʋ will hear him.” ");
INSERT INTO engtcent_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","So the next day Agrippa and Bernice came with great pomp and entered the auditorium along with the military commanders and the distinguished men of the city. Then Festus gave the command, and Paul was brought in. ");
INSERT INTO engtcent_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus said, “King Agrippa and all you men who are present with us, you see this man, concerning whom the entire Jewish community has appealed to me, both in Jerusalem and here in this place, crying out that he ought not to live any longer. ");
INSERT INTO engtcent_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","But when I found that he had done nothing deserving death, and since he himself appealed to His Majesty the Emperor, I decided to send him. ");
INSERT INTO engtcent_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Yet I have nothing definite to write to my lord about this man. Therefore I have brought him before you all, and especially before yoʋ, King Agrippa, so that after we have had this preliminary hearing, I may have something to write. ");
INSERT INTO engtcent_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","For it seems unreasonable to me to send a prisoner without indicating the charges against him.” ");
INSERT INTO engtcent_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Then Agrippa said to Paul, “Yoʋ have permission to speak for yoʋrself.” So Paul stretched out his hand and began to make his defense: ");
INSERT INTO engtcent_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“I consider myself fortunate that it is before yoʋ, King Agrippa, that I am about to make my defense today concerning all the things of which I am being accused by the Jews, ");
INSERT INTO engtcent_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","especially since yoʋ are acquainted with all the customs and controversies of the Jews. Therefore I beg yoʋ to listen to me patiently. ");
INSERT INTO engtcent_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“All the Jews know about my manner of life from my youth up, which was spent from the beginning among my own nation in Jerusalem. ");
INSERT INTO engtcent_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","They have known about me for a long time, if they are willing to testify, that according to the strictest sect of our religion I lived as a Pharisee. ");
INSERT INTO engtcent_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","And now I am standing trial because of my hope in the promise God made to our fathers, ");
INSERT INTO engtcent_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","a promise that our twelve tribes hope to attain as they earnestly serve him night and day. Regarding this hope, King Agrippa, I am being accused by the Jews. ");
INSERT INTO engtcent_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Why is it deemed unbelievable by you that God raises the dead? ");
INSERT INTO engtcent_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Indeed, I myself was convinced that I ought to do many things against the name of Jesus of Nazareth. ");
INSERT INTO engtcent_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","And that is just what I did in Jerusalem. I locked up many of the saints in prison by the authority I received from the chief priests, and when they were being put to death, I cast my vote against them. ");
INSERT INTO engtcent_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","I also punished them often in all the synagogues and tried to force them to blaspheme. And being furiously enraged against them, I pursued them even to foreign cities. ");
INSERT INTO engtcent_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“While engaged in such things, I was on my way to Damascus with authority and commission from the chief priests, ");
INSERT INTO engtcent_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","when at midday, O king, I saw on the way a light from heaven, brighter than the sun, shining around me and those who were traveling with me. ");
INSERT INTO engtcent_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","When we had all fallen down to the ground, I heard a voice saying to me in the Hebrew language, ‘Saul, Saul, why are yoʋ persecuting me? It is hard for yoʋ to kick against the goads.’ ");
INSERT INTO engtcent_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","I said, ‘Who are yoʋ, Lord?’ He said, ‘I am Jesus, whom yoʋ are persecuting. ");
INSERT INTO engtcent_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","But rise and stand on yoʋr feet, for I have appeared to yoʋ for this purpose, to appoint yoʋ as a servant and witness to the things yoʋ have seen and to the things in which I will appear to yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","I will rescue yoʋ from yoʋr own people and from the Gentiles, to whom I am sending yoʋ ");
INSERT INTO engtcent_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","to open their eyes so that they may turn away from darkness to light, and from the dominion of Satan to God, that they may receive remission of sins and an allotment among those who have been sanctified by faith in me.’ ");
INSERT INTO engtcent_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Consequently, King Agrippa, I was not disobedient to the heavenly vision, ");
INSERT INTO engtcent_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","but first to those in Damascus and then to those in Jerusalem, to all the region of Judea and to the Gentiles, I proclaimed that they should repent and turn to God, doing works consistent with repentance. ");
INSERT INTO engtcent_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","That is why the Jews seized me in the temple courts and were trying to kill me. ");
INSERT INTO engtcent_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","But having obtained help from God, I stand to this day testifying to both small and great, saying nothing except what the Prophets and Moses said would take place: ");
INSERT INTO engtcent_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","that the Christ would suffer and that, as the first to rise from the dead, he would proclaim light to our people and to the Gentiles.” ");
INSERT INTO engtcent_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","As Paul was saying these things in his own defense, Festus said with a loud voice, “Yoʋ are out of yoʋr mind, Paul. Too much learning is driving yoʋ insane!” ");
INSERT INTO engtcent_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","But Paul said, “I am not out of my mind, most excellent Festus, but I am speaking words of truth and good sense. ");
INSERT INTO engtcent_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","For the king knows about these things, to whom I am speaking boldly. I am convinced that none of these things has escaped his notice at all, for this has not been done in a corner. ");
INSERT INTO engtcent_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Do yoʋ believe the Prophets, King Agrippa? I know that yoʋ believe.” ");
INSERT INTO engtcent_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa said to Paul, “Do yoʋ think yoʋ can persuade me to become a Christian so quickly?” ");
INSERT INTO engtcent_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul said, “Whether quickly or not, I pray to God that not only yoʋ but also all who are listening to me today would become as I am, except for these chains.” ");
INSERT INTO engtcent_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","After Paul said these things, the king stood up, along with the governor, Bernice, and those who were sitting with them. ");
INSERT INTO engtcent_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","After leaving the room, they began saying to one another, “This man is doing nothing that deserves death or imprisonment.” ");
INSERT INTO engtcent_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","And Agrippa said to Festus, “This man could have been released if he had not appealed to Caesar.” ");
INSERT INTO engtcent_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","When it was decided that we would sail to Italy, they transferred Paul and some other prisoners to a centurion named Julius, of the Augustan Cohort. ");
INSERT INTO engtcent_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","We got on board a ship of Adramyttium and put out to sea, intending to sail by the ports along the coast of Asia. With us was Aristarchus, a Macedonian of Thessalonica. ");
INSERT INTO engtcent_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","The next day we put in at Sidon, and Julius treated Paul kindly, allowing him to go to his friends and receive care. ");
INSERT INTO engtcent_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","From there we put out to sea and sailed under the lee of Cyprus, because the winds were against us. ");
INSERT INTO engtcent_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","After sailing across the open sea off Cilicia and Pamphylia, we arrived at Myra of Lycia. ");
INSERT INTO engtcent_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","There the centurion found an Alexandrian ship that was sailing to Italy and put us on board. ");
INSERT INTO engtcent_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","We sailed along slowly for many days and arrived with difficulty off Cnidus. When the wind did not allow us to hold our course, we sailed under the lee of Crete off Salmone. ");
INSERT INTO engtcent_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Sailing along the coast with difficulty, we came to a place called Fair Havens, which was near the city of Lasea. ");
INSERT INTO engtcent_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Since much time had been lost and the voyage had now become dangerous because the Fast was already over, Paul advised the ship's officers, ");
INSERT INTO engtcent_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Men, I perceive that this voyage is going to result in damage and great loss, not only of the cargo and of the ship, but also of our lives.” ");
INSERT INTO engtcent_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","But the centurion was persuaded by the ship's captain and the shipowner rather than by what Paul said. ");
INSERT INTO engtcent_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Because the harbor was not a suitable place for spending the winter, the majority made a decision to set sail from there also, hoping to somehow reach Phoenix, a harbor of Crete facing southwest and northwest, so that we could spend the winter there. ");
INSERT INTO engtcent_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","When a south wind started blowing gently, they thought that the opportunity had come for them to carry out their plan. So they weighed anchor and sailed closely along the shore of Crete. ");
INSERT INTO engtcent_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","But before long, a hurricane-force wind called Euroclydon swept down from the island. ");
INSERT INTO engtcent_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","When the ship was caught by the storm and could not head into the wind, we gave way to it and were driven along. ");
INSERT INTO engtcent_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Running under the lee of a small island called Clauda, we were able with difficulty to secure the skiff. ");
INSERT INTO engtcent_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","After hoisting it up, the sailors used supports to undergird the ship. Then, fearing they might run aground on the Syrtis, they lowered the gear, and in this manner the ship was driven along. ");
INSERT INTO engtcent_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","The next day, because we were being severely battered by the storm, the sailors began throwing the cargo overboard. ");
INSERT INTO engtcent_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","On the third day we threw the ship's tackle overboard with our own hands. ");
INSERT INTO engtcent_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","When neither sun nor stars appeared for many days, and the violent storm continued to rage, all hope that we might be saved was lost. ");
INSERT INTO engtcent_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Since there had been little desire to eat, Paul stood up among them and said, “Men, you should have listened to my advice not to set sail from Crete; then you would have spared yourselves this damage and loss. ");
INSERT INTO engtcent_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","But now I advise you to be of good cheer, for there will be no loss of life among you, but only of the ship. ");
INSERT INTO engtcent_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","For this very night an angel of the God to whom I belong and whom I serve stood beside me ");
INSERT INTO engtcent_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","and said, ‘Do not be afraid, Paul; yoʋ must stand before Caesar. And behold, God has granted yoʋ the safety of all who are sailing with yoʋ.’ ");
INSERT INTO engtcent_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Therefore be of good cheer, men, for I have faith in God that it will happen just as I have been told. ");
INSERT INTO engtcent_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","But we must run aground on some island.” ");
INSERT INTO engtcent_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","When the fourteenth night had come, as we were being driven across the Adriatic Sea, about midnight the sailors suspected that they were approaching some land. ");
INSERT INTO engtcent_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","So they took a sounding and found it to be twenty fathoms. After going a little farther, they took another sounding and found it to be fifteen fathoms. ");
INSERT INTO engtcent_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Fearing that we might run aground on the rocks, they let down four anchors from the stern and prayed for daybreak to come. ");
INSERT INTO engtcent_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Then the sailors tried to escape from the ship by lowering the skiff into the sea under the pretense that they were going to lay out anchors from the bow. ");
INSERT INTO engtcent_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","So Paul said to the centurion and the soldiers, “If these men do not remain in the ship you cannot be saved.” ");
INSERT INTO engtcent_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Then the soldiers cut away the ropes of the skiff and let it drift away. ");
INSERT INTO engtcent_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","When daybreak was about to come, Paul encouraged them all to take some food, saying, “Today is the fourteenth day that you have continued in suspense without eating, having taken nothing. ");
INSERT INTO engtcent_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Therefore I urge you to take some food, for this is important for your survival, since not a hair will fall from the head of any one of you.” ");
INSERT INTO engtcent_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","After saying this, Paul took some bread and gave thanks to God in the presence of them all. Then he broke it and began to eat. ");
INSERT INTO engtcent_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","They were all encouraged and took food themselves. ");
INSERT INTO engtcent_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(Altogether there were two hundred seventy-six of us on the ship.) ");
INSERT INTO engtcent_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","When they had eaten their fill of food, they began to lighten the ship by throwing the wheat out into the sea. ");
INSERT INTO engtcent_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","When daybreak came, the sailors did not recognize the land. But they noticed a bay with a beach and decided that, if possible, they would run the ship ashore there. ");
INSERT INTO engtcent_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","So they cut away the anchors and left them in the sea, at the same time loosening the bands of the rudders. Then they hoisted the foresail up into the blowing wind and made for the beach. ");
INSERT INTO engtcent_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","But they struck a sandbar and ran the ship aground. The bow stuck fast and remained immovable, and the stern was being broken apart by the force of the waves. ");
INSERT INTO engtcent_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","The soldiers' plan was to kill the prisoners, so that none of them would swim away and escape. ");
INSERT INTO engtcent_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","But the centurion, wishing to save Paul's life, kept them from carrying out their plan. So he ordered those who could swim to jump overboard first and get to land, ");
INSERT INTO engtcent_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","and the rest were to follow, some on planks and some on pieces of the ship. And so it was that they were all brought safely to land. ");
INSERT INTO engtcent_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Once they had safely reached shore, they found out that the island was called Malta. ");
INSERT INTO engtcent_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","The native people showed us extraordinary kindness. For they welcomed us all and kindled a fire because of the rain that had set in and because of the cold. ");
INSERT INTO engtcent_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul gathered a bundle of sticks, and when he was putting them on the fire, a viper came out because of the heat and fastened on his hand. ");
INSERT INTO engtcent_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","When the native people saw the creature hanging from his hand, they said to one another, “This man is undoubtedly a murderer. Although he has been saved from the sea, the goddess Justice has not allowed him to live.” ");
INSERT INTO engtcent_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","But Paul shook the creature off into the fire and suffered no harm. ");
INSERT INTO engtcent_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","The people were expecting that he would soon swell up or suddenly fall down dead. But after waiting expectantly for a long time and seeing nothing unusual happen to him, they changed their minds and said that he was a god. ");
INSERT INTO engtcent_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Now in the region around that place were lands that belonged to the chief man of the island, named Publius, who welcomed us and hospitably took care of us as his guests for three days. ");
INSERT INTO engtcent_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Now it so happened that the father of Publius lay sick in bed, suffering from fevers and dysentery. So Paul went in to see him and healed him by praying and laying his hands on him. ");
INSERT INTO engtcent_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","After this happened, the rest of the people on the island who were sick also came and were healed. ");
INSERT INTO engtcent_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","So the people bestowed many honors on us, and when we were about to set sail, they provided us with the things we needed. ");
INSERT INTO engtcent_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","After three months, we set sail in an Alexandrian ship that had wintered at the island and that had the twin sons of Zeus as its figurehead. ");
INSERT INTO engtcent_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Putting in at Syracuse, we stayed there for three days. ");
INSERT INTO engtcent_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","From there we took a circuitous course and arrived at Rhegium. After one day a south wind sprang up, and on the second day we came to Puteoli. ");
INSERT INTO engtcent_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","There we found some brothers and were invited to stay with them for seven days. And so we came to Rome. ");
INSERT INTO engtcent_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","When the brothers from Rome heard the news about us, they came out as far as the Forum of Appius and the Three Taverns to meet us. When Paul saw them, he gave thanks to God and took courage. ");
INSERT INTO engtcent_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","When we came into Rome, the centurion transferred the prisoners to the captain of the guard, but Paul was allowed to stay by himself, with the soldier who was guarding him. ");
INSERT INTO engtcent_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","After three days, Paul called together those who were prominent among the Jews. When they had gathered together, he said to them, “Brothers, though I had done nothing against our people or the customs of our fathers, I was delivered as a prisoner from Jerusalem into the hands of the Romans. ");
INSERT INTO engtcent_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","When they examined me, they were willing to release me because there were no grounds for death in my case. ");
INSERT INTO engtcent_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","But when the Jews objected, I was forced to appeal to Caesar, not that I had any accusation to make against my own nation. ");
INSERT INTO engtcent_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","That is why I have asked to see you and speak with you, for it is on account of the hope of Israel that I am bound with this chain.” ");
INSERT INTO engtcent_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","They said to him, “We have received no letters from Judea about yoʋ, and none of the brothers who have come here have reported or spoken anything bad about yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","But we think it would be best to hear what yoʋr views are, for concerning this sect, we know that everywhere it is spoken against.” ");
INSERT INTO engtcent_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","When they had arranged a day to meet with Paul, many more came to him at his lodging. From morning until evening he explained the matter to them, testifying about the kingdom of God and trying to convince them about Jesus both from the Law of Moses and from the Prophets. ");
INSERT INTO engtcent_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Some were convinced by what he said, but others refused to believe. ");
INSERT INTO engtcent_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","So they were in disagreement with one another and began to leave after Paul made this one final statement: “The Holy Spirit was right in saying to our fathers through the prophet Isaiah: ");
INSERT INTO engtcent_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Go to this people and say, “Although you will hear, you will never understand, and although you will see, you will never perceive.” ");
INSERT INTO engtcent_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","For the heart of this people has become calloused; with their ears they have barely heard, and their eyes they have closed, lest they should see with their eyes, hear with their ears, and understand with their heart and turn back, and I would heal them.’ ");
INSERT INTO engtcent_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Therefore let it be known to you that the salvation of God has been sent to the Gentiles; they will listen.” ");
INSERT INTO engtcent_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","After Paul said these things, the Jews went away and had a great dispute among themselves. ");
INSERT INTO engtcent_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","For two whole years Paul stayed in his own rented house and welcomed all who came to him, ");
INSERT INTO engtcent_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","preaching the kingdom of God and teaching about the Lord Jesus Christ with all boldness and without hindrance. ");
INSERT INTO engtcent_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul, a servant of Jesus Christ, called to be an apostle, set apart for the gospel of God, ");
INSERT INTO engtcent_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","which he promised beforehand through his prophets in the holy Scriptures, ");
INSERT INTO engtcent_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","concerning his Son, who was descended from David according to the flesh ");
INSERT INTO engtcent_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","and who was declared to be the Son of God in power according to the Spirit of holiness by the resurrection from the dead, Jesus Christ our Lord, ");
INSERT INTO engtcent_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","through whom we have received grace and apostleship to bring about the obedience of faith for the sake of his name among all the Gentiles, ");
INSERT INTO engtcent_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","including you who are also called to belong to Jesus Christ; ");
INSERT INTO engtcent_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","to all who are in Rome, beloved by God and called to be saints: Grace to you and peace from God our Father and the Lord Jesus Christ. ");
INSERT INTO engtcent_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","First, I give thanks to my God through Jesus Christ for you all, because your faith is proclaimed in all the world. ");
INSERT INTO engtcent_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","For God is my witness, whom I serve with my spirit in the gospel of his Son, that I continually remember you, ");
INSERT INTO engtcent_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","always pleading in my prayers that somehow by God's will I may now at last succeed in coming to you. ");
INSERT INTO engtcent_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","For I long to see you so that I may impart to you some spiritual gift, that you may be established, ");
INSERT INTO engtcent_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","that is, that while I am among you we may be mutually encouraged by each other's faith, both yours and mine. ");
INSERT INTO engtcent_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","I do not want you to be unaware, brothers, that I have often intended to come to you (but have been hindered until the present time) so that I might have some fruit among you as well, just as I have had among the other Gentiles. ");
INSERT INTO engtcent_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","I am under obligation both to Greeks and to barbarians, both to the wise and to the foolish; ");
INSERT INTO engtcent_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","thus the eagerness on my part to preach the gospel to you also who are in Rome. ");
INSERT INTO engtcent_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","For I am not ashamed of the gospel of Christ, because it is the power of God for salvation to everyone who believes, both to the Jew first and also to the Greek. ");
INSERT INTO engtcent_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","For in it the righteousness of God is revealed from faith to faith, just as it is written, “The righteous will live by faith.” ");
INSERT INTO engtcent_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","For the wrath of God is revealed from heaven against all ungodliness and unrighteousness of men, who suppress the truth by their unrighteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Because what is known about God is evident among them, for God has made it evident to them. ");
INSERT INTO engtcent_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","For his invisible qualities, both his everlasting power and his divinity, have been plainly seen from the creation of the world, being perceived through what has been made, so that they are without excuse. ");
INSERT INTO engtcent_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","For although they knew God, they did not glorify him as God or give thanks, but they became futile in their thoughts, and their senseless hearts were darkened. ");
INSERT INTO engtcent_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Claiming to be wise, they became fools ");
INSERT INTO engtcent_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","and exchanged the glory of the immortal God for images resembling mortal man, birds, four-footed animals, and reptiles. ");
INSERT INTO engtcent_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Therefore God gave them up in the lusts of their hearts to impurity, to dishonor their bodies among themselves, ");
INSERT INTO engtcent_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","because they exchanged the truth of God for falsehood and worshiped and served the creature rather than the Creator, who is blessed forever. Amen. ");
INSERT INTO engtcent_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","For this reason God gave them up to dishonorable passions, for their women exchanged the natural function for that which is contrary to nature. ");
INSERT INTO engtcent_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","In the same way the men also, having abandoned the natural function of the female, were inflamed in their lust for one another, men committing shameful acts with men and receiving in themselves the due penalty for their error. ");
INSERT INTO engtcent_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","And just as they considered it worthless to have God in their knowledge, God gave them up to a worthless mind, to do what is not proper. ");
INSERT INTO engtcent_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","They are filled with all unrighteousness, fornication, evil, covetousness, and malice. They are full of envy, murder, strife, deceit, and maliciousness. They are gossips, ");
INSERT INTO engtcent_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","slanderers, haters of God, insolent, proud, boasters, inventors of evil, disobedient to parents, ");
INSERT INTO engtcent_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","senseless, untrustworthy, without natural affection, irreconcilable, and unmerciful. ");
INSERT INTO engtcent_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Though they know the ordinance of God, that those who practice such things deserve death, they not only do them but also approve of those who practice them. ");
INSERT INTO engtcent_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Therefore yoʋ are without excuse, O man, every one of you who judges. For on whatever grounds yoʋ judge another, yoʋ condemn yoʋrself, for yoʋ who judge do the same things. ");
INSERT INTO engtcent_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Now we know that the judgment of God against those who do such things is in accordance with truth. ");
INSERT INTO engtcent_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Do yoʋ suppose, O man—yoʋ who judge those who do such things and yet do them yoʋrself—that yoʋ will escape the judgment of God? ");
INSERT INTO engtcent_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Or do yoʋ despise the riches of his kindness, forbearance, and patience, not knowing that the kindness of God leads yoʋ to repentance? ");
INSERT INTO engtcent_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","But according to yoʋr stubbornness and yoʋr unrepentant heart, yoʋ are storing up wrath for yoʋrself on the day of wrath, revelation, and the righteous judgment of God, ");
INSERT INTO engtcent_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","who will repay each person according to his works. ");
INSERT INTO engtcent_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","To those who by patient endurance in good works seek glory, honor, and immortality, he will give eternal life; ");
INSERT INTO engtcent_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","but for those who are self-seeking and obey unrighteousness instead of the truth, there will be anger and wrath. ");
INSERT INTO engtcent_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","There will be tribulation and distress for everyone who does evil, the Jew first and also the Greek; ");
INSERT INTO engtcent_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","but there will be glory, honor, and peace for everyone who does good, the Jew first and also the Greek. ");
INSERT INTO engtcent_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","For there is no partiality with God. ");
INSERT INTO engtcent_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","For all who have sinned without the law will also perish without the law, and all who have sinned under the law will be judged by the law. ");
INSERT INTO engtcent_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","For it is not the hearers of the law who are righteous before God, but the doers of the law will be justified. ");
INSERT INTO engtcent_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","For when Gentiles, who do not have the law, by nature do what is required by the law, they are a law to themselves, even though they do not have the law. ");
INSERT INTO engtcent_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","They show that what the law requires is written in their hearts, as their conscience bears witness with them and their conflicting thoughts accuse or even defend them ");
INSERT INTO engtcent_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","on the day when, according to my gospel, God will judge the secret thoughts of men through Jesus Christ. ");
INSERT INTO engtcent_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Behold, yoʋ call yoʋrself a Jew and rely on the law and boast in God. ");
INSERT INTO engtcent_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Yoʋ know his will and approve what is excellent, because yoʋ are instructed from the law. ");
INSERT INTO engtcent_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","And yoʋ have confidence that yoʋ yoʋrself are a guide for the blind, a light for those who are in darkness, ");
INSERT INTO engtcent_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","an instructor of the foolish, and a teacher of children, because yoʋ have in the law the embodiment of knowledge and truth. ");
INSERT INTO engtcent_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yoʋ then who teach others, do yoʋ not teach yoʋrself? Yoʋ who preach against stealing, do yoʋ steal? ");
INSERT INTO engtcent_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Yoʋ who tell others not to commit adultery, do yoʋ commit adultery? Yoʋ who abhor idols, do yoʋ rob temples? ");
INSERT INTO engtcent_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Yoʋ who boast in the law, do yoʋ dishonor God by transgressing the law? ");
INSERT INTO engtcent_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","As it is written, “The name of God is blasphemed among the Gentiles because of you.” ");
INSERT INTO engtcent_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Circumcision does indeed benefit yoʋ if yoʋ observe the law, but if yoʋ transgress the law, yoʋr circumcision has become uncircumcision. ");
INSERT INTO engtcent_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","If then an uncircumcised man keeps the ordinances of the law, will not his uncircumcision be regarded as circumcision? ");
INSERT INTO engtcent_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Then he who is physically uncircumcised and carries out the law will judge yoʋ who, despite having the letter of the law and circumcision, transgress the law. ");
INSERT INTO engtcent_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","For he is not a Jew who is one outwardly, neither is circumcision something outward in the flesh; ");
INSERT INTO engtcent_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","but he is a Jew who is one inwardly, and circumcision is a matter of the heart, by the Spirit, not by the letter. Such a man's praise comes not from men but from God. ");
INSERT INTO engtcent_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","What then is the advantage of the Jew? Or what is the benefit of circumcision? ");
INSERT INTO engtcent_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Much in every way. First of all, the Jews were entrusted with the oracles of God. ");
INSERT INTO engtcent_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Now what if some of them were unfaithful? Will their unfaithfulness nullify the faithfulness of God? ");
INSERT INTO engtcent_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Certainly not! Rather, let God be true even if every man is a liar, just as it is written, “So that yoʋ may be justified in yoʋr words, and prevail when yoʋ are judged.” ");
INSERT INTO engtcent_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","But if our unrighteousness demonstrates the righteousness of God, what shall we say? Is God, who inflicts wrath, unrighteous? (I speak in a human way.) ");
INSERT INTO engtcent_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Certainly not! Otherwise, how could God judge the world? ");
INSERT INTO engtcent_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","For if through my lie the truth of God abounds to his glory, why am I still being judged as a sinner? ");
INSERT INTO engtcent_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","And why not say (just as some slanderously claim that we say), “Let us do evil that good may come”? Their condemnation is just. ");
INSERT INTO engtcent_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","What then? Are we Jews any better off? Not at all! For we have previously charged that both Jews and Greeks are all under sin, ");
INSERT INTO engtcent_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","just as it is written, “There is none righteous, not even one; ");
INSERT INTO engtcent_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","there is none who understands; there is none who seeks after God. ");
INSERT INTO engtcent_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","All have turned aside; together they have become useless; there is none who shows kindness, not even one.” ");
INSERT INTO engtcent_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Their throat is an open grave; with their tongues they deceive.” “The venom of asps is under their lips.” ");
INSERT INTO engtcent_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Their mouth is full of cursing and bitterness.” ");
INSERT INTO engtcent_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Their feet are swift to shed blood. ");
INSERT INTO engtcent_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ruin and misery are in their paths, ");
INSERT INTO engtcent_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","and the way of peace they have not known.” ");
INSERT INTO engtcent_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“There is no fear of God before their eyes.” ");
INSERT INTO engtcent_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Now we know that whatever the law says, it says to those who are under the law, so that every mouth may be stopped and all the world may be brought under the judgment of God. ");
INSERT INTO engtcent_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","For by the works of the law no flesh will be justified in his sight, for through the law comes knowledge of sin. ");
INSERT INTO engtcent_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","But now the righteousness of God has been revealed apart from the law, attested by the Law and the Prophets, ");
INSERT INTO engtcent_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","that is, the righteousness of God through faith in Jesus Christ for all and upon all who believe; for there is no distinction. ");
INSERT INTO engtcent_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","For all have sinned and fall short of the glory of God, ");
INSERT INTO engtcent_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","being freely justified by his grace through the redemption that is in Christ Jesus, ");
INSERT INTO engtcent_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","whom God put forward as a sacrifice of atonement, through faith, by his blood. He did this to demonstrate his righteousness, because in his divine forbearance he had passed over the sins that had previously been committed. ");
INSERT INTO engtcent_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","He did so to prove in the present time that he is righteous and that he justifies the one who has faith in Jesus. ");
INSERT INTO engtcent_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Where then is boasting? It is excluded. By what kind of law? By a law of works? No, but by the law of faith. ");
INSERT INTO engtcent_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","We conclude therefore that a person is justified by faith apart from the works of the law. ");
INSERT INTO engtcent_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Or is God the God of the Jews only? Is he not the God of the Gentiles also? Yes, of the Gentiles also, ");
INSERT INTO engtcent_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","since God is one, who will justify the circumcised by faith and the uncircumcised through faith. ");
INSERT INTO engtcent_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Do we then nullify the law through faith? Certainly not! On the contrary, we uphold the law. ");
INSERT INTO engtcent_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","What then shall we say that Abraham our father has discovered according to the flesh? ");
INSERT INTO engtcent_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","If Abraham was justified by works, he has something to boast about, but not before God. ");
INSERT INTO engtcent_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","For what does the Scripture say? “Abraham believed God, and it was counted to him as righteousness.” ");
INSERT INTO engtcent_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Now to the one who works, his wages are not counted as a gift, but as something owed to him. ");
INSERT INTO engtcent_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","However, to the one who does not work but believes in him who justifies the ungodly, his faith is counted as righteousness, ");
INSERT INTO engtcent_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","just as David also speaks of the blessedness of the one to whom God counts righteousness apart from works: ");
INSERT INTO engtcent_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blessed are those whose lawless deeds are forgiven, and whose sins are covered. ");
INSERT INTO engtcent_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blessed is the man against whom the Lord will never count sin.” ");
INSERT INTO engtcent_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Is this blessedness then only for the circumcised, or is it also for the uncircumcised? For we say, “Faith was counted to Abraham as righteousness.” ");
INSERT INTO engtcent_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","How then was it counted? When he was circumcised, or uncircumcised? Not when he was circumcised, but when he was uncircumcised. ");
INSERT INTO engtcent_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","He received the sign of circumcision as a seal of the righteousness that he had by faith while he was still uncircumcised, so that he might be the father of all who believe when they are uncircumcised, so that righteousness might be counted to them as well, ");
INSERT INTO engtcent_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","and so that he might be the father of those who are not only circumcised in the flesh, but who also walk in the footsteps of the faith that our father Abraham had when he was uncircumcised. ");
INSERT INTO engtcent_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","For the promise to Abraham, or to his offspring, that he would be the heir of the world was not through the law, but through the righteousness of faith. ");
INSERT INTO engtcent_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","For if those who are of the law are heirs, faith has been made void and the promise has been invalidated, ");
INSERT INTO engtcent_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","because the law brings wrath; for where there is no law, there is no transgression. ");
INSERT INTO engtcent_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","For this reason the promise comes by faith, so that it may be according to grace and be guaranteed to all Abraham's offspring, not only to the one who is of the law, but also to the one who is of the faith of Abraham, who is the father of us all ");
INSERT INTO engtcent_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(just as it is written, “I have made yoʋ the father of many nations”). He is our father in the presence of the God in whom he believed, who gives life to the dead and calls into being what does not yet exist. ");
INSERT INTO engtcent_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Against all hope Abraham believed in hope that he would become the father of many nations according to what had been spoken: “So shall yoʋr offspring be.” ");
INSERT INTO engtcent_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Because he was not weak in faith, he did not consider his own body, now as good as dead (since he was somewhere around a hundred years old), or the deadness of Sarah's womb. ");
INSERT INTO engtcent_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","And he did not waver in unbelief at the promise of God but was strengthened in faith, giving glory to God ");
INSERT INTO engtcent_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","and being fully assured that God was able to do what he had promised. ");
INSERT INTO engtcent_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Therefore, “it was counted to him as righteousness.” ");
INSERT INTO engtcent_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Now the statement “it was counted to him” was not written only for Abraham's sake, ");
INSERT INTO engtcent_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","but for ours also. It will be counted to us who believe in him who raised Jesus our Lord from the dead, ");
INSERT INTO engtcent_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","who was delivered up for our trespasses and raised for our justification. ");
INSERT INTO engtcent_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Therefore, since we have been justified by faith, we have peace with God through our Lord Jesus Christ, ");
INSERT INTO engtcent_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","through whom we have access by faith into this grace in which we stand, and we boast in the hope of the glory of God. ");
INSERT INTO engtcent_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Not only that, but we also boast in our tribulations, knowing that tribulation produces endurance, ");
INSERT INTO engtcent_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","endurance produces proven character, proven character produces hope, ");
INSERT INTO engtcent_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","and hope does not put to shame, because the love of God has been poured out into our hearts through the Holy Spirit who has been given to us. ");
INSERT INTO engtcent_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","For when we were still weak, at the right time Christ died for the ungodly. ");
INSERT INTO engtcent_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Rarely will anyone die for a righteous person, though perhaps for a good person someone might even dare to die. ");
INSERT INTO engtcent_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","But God demonstrated his own love for us in that, while we were still sinners, Christ died for us. ");
INSERT INTO engtcent_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","How much more then, since we have now been justified by his blood, will we be saved from wrath through him! ");
INSERT INTO engtcent_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","For if, while we were God's enemies, we were reconciled to him through the death of his Son, how much more will we be saved by his life now that we have been reconciled! ");
INSERT INTO engtcent_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Not only that, but we also boast in God through our Lord Jesus Christ, through whom we have now received reconciliation. ");
INSERT INTO engtcent_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Therefore, just as sin came into the world through one man, and death came through sin, in this way death has come to all men, because all have sinned. ");
INSERT INTO engtcent_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","For until the law sin was in the world, but sin is not charged to anyone's account when there is no law. ");
INSERT INTO engtcent_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nevertheless, death reigned from Adam until Moses, even over those whose sins were not like the transgression of Adam, who was a type of the one to come. ");
INSERT INTO engtcent_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","But the gift is not like the trespass. For if many died through the trespass of the one man, how much more have the grace of God and the gift by the grace of the one man Jesus Christ abounded to many! ");
INSERT INTO engtcent_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","And the gift cannot be compared to the result of the one man's sin; for the judgment that arose from one trespass brought condemnation, but the gift that arose from many trespasses brought justification. ");
INSERT INTO engtcent_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","For if, by the trespass of the one man, death reigned through the one man, how much more will those who receive the abundance of grace and the gift of righteousness reign in life through the one man Jesus Christ! ");
INSERT INTO engtcent_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","So then, just as one trespass led to condemnation for all men, so one act of righteousness leads to justification and life for all men. ");
INSERT INTO engtcent_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","For just as many were made sinners through the disobedience of one man, so also many will be made righteous through the obedience of one man. ");
INSERT INTO engtcent_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Now the law came in so that the trespass might abound. But where sin abounded, grace abounded all the more, ");
INSERT INTO engtcent_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","so that just as sin reigned in death, so also grace might reign through righteousness leading to eternal life through Jesus Christ our Lord. ");
INSERT INTO engtcent_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","What then shall we say? Should we continue in sin so that grace may abound? ");
INSERT INTO engtcent_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Certainly not! How can we who have died to sin still live in it? ");
INSERT INTO engtcent_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Or do you not know that all of us who have been baptized into Christ Jesus have been baptized into his death? ");
INSERT INTO engtcent_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Therefore we were buried with him through baptism into death, so that just as Christ was raised from the dead by the glory of the Father, we too might walk in newness of life. ");
INSERT INTO engtcent_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","For if we have become united with him in the likeness of his death, we will certainly also be united with him in the likeness of his resurrection. ");
INSERT INTO engtcent_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","For we know that our old self has been crucified with him so that the body of sin might be done away with, and we might no longer be enslaved to sin. ");
INSERT INTO engtcent_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","For he who has died has been set free from sin. ");
INSERT INTO engtcent_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Now if we have died with Christ, we believe that we will also live with him. ");
INSERT INTO engtcent_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","For we know that Christ, having been raised from the dead, dies no more; death no longer has dominion over him. ");
INSERT INTO engtcent_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","For the death that he died, he died to sin once for all; but the life that he lives, he lives to God. ");
INSERT INTO engtcent_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","So you also must consider yourselves to be dead to sin but alive to God in Christ Jesus our Lord. ");
INSERT INTO engtcent_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Therefore do not let sin reign in your mortal bodies so that you obey it in the body's sinful desires. ");
INSERT INTO engtcent_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","And do not present your members to sin as instruments of unrighteousness, but present yourselves to God as alive from the dead, and present your members to God as instruments of righteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","For sin will have no dominion over you, for you are not under law but under grace. ");
INSERT INTO engtcent_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","What then? Should we sin because we are not under law but under grace? Certainly not! ");
INSERT INTO engtcent_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Do you not know that when you present yourselves to someone as obedient slaves, you are slaves of the one whom you obey, either of sin leading to death, or of obedience leading to righteousness? ");
INSERT INTO engtcent_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","But thanks be to God that, though you were slaves of sin, you have become obedient from the heart to the pattern of teaching to which you were entrusted, ");
INSERT INTO engtcent_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","and having been set free from sin, you have become slaves to righteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(I am speaking in human terms because of the weakness of your flesh.) For just as you presented your members as slaves to impurity and to lawlessness leading to more lawlessness, so now present your members as slaves to righteousness leading to sanctification. ");
INSERT INTO engtcent_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","For when you were slaves of sin, you were free with regard to righteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","So what fruit did you have at that time from the things of which you are now ashamed? The end result of those things is death. ");
INSERT INTO engtcent_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","But now that you have been set free from sin and become slaves of God, you have fruit that leads to sanctification, and the end result is eternal life. ");
INSERT INTO engtcent_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","For the wages of sin is death, but the gift of God is eternal life in Christ Jesus our Lord. ");
INSERT INTO engtcent_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Do you not know, brothers (for I am speaking to those who know the law), that the law has dominion over a person only as long as he lives? ");
INSERT INTO engtcent_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","For a married woman is bound by the law to her husband as long as he is alive, but if her husband dies, she is released from the law concerning her husband. ");
INSERT INTO engtcent_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","So then, she will be called an adulteress if she is joined to another man while her husband is alive. But if her husband dies, she is free from that law and is not committing adultery if she is joined to another man. ");
INSERT INTO engtcent_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","So then, my brothers, you also were put to death with respect to the law through the body of Christ, so that you might be joined to another, to him who was raised from the dead, so that we might bear fruit for God. ");
INSERT INTO engtcent_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","For when we were in the flesh, our sinful passions, which were aroused by the law, were at work in our members to bear fruit leading to death. ");
INSERT INTO engtcent_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","But now we have been released from the law, having died to that by which we were held, so that we may serve in the new way of the Spirit and not in the old way of the written code. ");
INSERT INTO engtcent_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","What then shall we say? Is the law sin? Certainly not! Yet I would not have known sin except through the law. For I would not have known covetousness if the law had not said, “Yoʋ shall not covet.” ");
INSERT INTO engtcent_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","But sin, seizing an opportunity through the commandment, produced in me every kind of covetousness. For apart from the law sin is dead. ");
INSERT INTO engtcent_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Once I was alive apart from the law, but when the commandment came, sin came to life and I died. ");
INSERT INTO engtcent_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","So I found that the very commandment that was intended to bring life actually brought death. ");
INSERT INTO engtcent_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","For sin, seizing an opportunity through the commandment, deceived me and through it killed me. ");
INSERT INTO engtcent_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","So then, the law is holy, and the commandment is holy, righteous, and good. ");
INSERT INTO engtcent_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Has that then which is good brought death to me? Certainly not! But sin, so that it would be shown to be sin, produced death in me through that which is good, so that through the commandment sin might become utterly sinful. ");
INSERT INTO engtcent_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","For we know that the law is spiritual, but I am of the flesh, sold as a slave to sin. ");
INSERT INTO engtcent_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","I do not understand what I do. Instead of doing what I want to do, I do the very thing I hate. ");
INSERT INTO engtcent_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Now if I do the very thing I do not want to do, I agree that the law is good. ");
INSERT INTO engtcent_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","But now it is no longer I who do it, but sin that dwells in me. ");
INSERT INTO engtcent_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","For I know that nothing good dwells in me, that is, in my flesh. I have the desire to do what is right, but I find that the ability to carry it out is lacking. ");
INSERT INTO engtcent_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","For I do not do the good that I want to do, but I do the very evil that I do not want to do. ");
INSERT INTO engtcent_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Now if I do the very thing I do not want to do, it is no longer I who do it, but sin that dwells in me. ");
INSERT INTO engtcent_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","I find then the law that when I want to do what is right, evil is present with me. ");
INSERT INTO engtcent_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","For I delight in the law of God in my inner being, ");
INSERT INTO engtcent_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","but I see another law at work in my members, warring against the law of my mind and making me a prisoner to the law of sin that is in my members. ");
INSERT INTO engtcent_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Wretched man that I am! Who will rescue me from this body of death? ");
INSERT INTO engtcent_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","I thank God that he will do so through Jesus Christ our Lord! So then, with my mind I serve the law of God, but with my flesh I serve the law of sin. ");
INSERT INTO engtcent_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Therefore, there is now no condemnation for those who are in Christ Jesus, who walk not according to the flesh but according to the Spirit. ");
INSERT INTO engtcent_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","For the law of the Spirit of life in Christ Jesus has set me free from the law of sin and death. ");
INSERT INTO engtcent_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","For what the law was powerless to do since it was weak through the flesh, God has done. By sending his own Son in the likeness of sinful flesh and as an offering for sin, he condemned sin in the flesh, ");
INSERT INTO engtcent_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","so that the requirement of the law might be fulfilled in us, who walk not according to the flesh but according to the Spirit. ");
INSERT INTO engtcent_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","For those who live according to the flesh set their minds on the things of the flesh, but those who live according to the Spirit set their minds on the things of the Spirit. ");
INSERT INTO engtcent_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Now the mindset of the flesh is death, but the mindset of the Spirit is life and peace. ");
INSERT INTO engtcent_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","The mindset of the flesh is hostile to God, for it does not submit to the law of God; indeed, it is unable to do so. ");
INSERT INTO engtcent_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","That is why those who are in the flesh cannot please God. ");
INSERT INTO engtcent_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","You, however, are not in the flesh but in the Spirit, if indeed the Spirit of God dwells in you. Now if anyone does not have the Spirit of Christ, he does not belong to Christ. ");
INSERT INTO engtcent_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","But if Christ is in you, the body is dead because of sin, but the spirit is alive because of righteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","And if the Spirit of him who raised Jesus from the dead dwells in you, he who raised Christ from the dead will also give life to your mortal bodies because of his Spirit who dwells in you. ");
INSERT INTO engtcent_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","So then, brothers, we are under obligation, not to the flesh, to live according to the flesh, ");
INSERT INTO engtcent_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","for if you live according to the flesh, you are going to die; but if by the Spirit you put to death the deeds of the body, you will live. ");
INSERT INTO engtcent_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","For all who are led by the Spirit of God are sons of God. ");
INSERT INTO engtcent_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","For you did not receive a spirit of slavery leading again to fear, but a spirit of adoption as sons, by which we cry out, “Abba! Father!” ");
INSERT INTO engtcent_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","The Spirit himself testifies with our spirit that we are children of God. ");
INSERT INTO engtcent_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Now if we are children, we are also heirs, heirs of God and fellow heirs with Christ, if indeed we suffer with him so that we may also be glorified with him. ");
INSERT INTO engtcent_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","I consider that the sufferings of this present time are not worth comparing to the glory that will be revealed to us. ");
INSERT INTO engtcent_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","The creation waits with eager longing for the sons of God to be revealed. ");
INSERT INTO engtcent_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","For the creation was subjected to futility, not willingly, but because of him who subjected it, in hope ");
INSERT INTO engtcent_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","that the creation itself will also be set free from the slavery of corruption and brought into the freedom of the glory of the children of God. ");
INSERT INTO engtcent_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","For we know that all creation has been groaning together with labor pains until now. ");
INSERT INTO engtcent_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Not only that, but we ourselves, who have the firstfruits of the Spirit, groan inwardly as we eagerly await our adoption as sons, the redemption of our bodies. ");
INSERT INTO engtcent_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","For in this hope we were saved. Now hope that is seen is not hope, for why would someone hope for what he already sees? ");
INSERT INTO engtcent_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","But if we hope for what we do not see, we eagerly wait for it with patient endurance. ");
INSERT INTO engtcent_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","In the same way the Spirit also helps us in our weaknesses. For we do not know what we ought to pray for, but the Spirit himself intercedes for us with inexpressible groanings. ");
INSERT INTO engtcent_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","And he who searches the hearts knows the mind of the Spirit, because the Spirit intercedes for the saints according to the will of God. ");
INSERT INTO engtcent_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","And we know that all things work together for the good of those who love God and are called according to his purpose. ");
INSERT INTO engtcent_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Because those whom he foreknew he also foreordained to be conformed to the image of his Son, so that he might be the firstborn among many brothers. ");
INSERT INTO engtcent_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","And those whom he foreordained, he also called; and those whom he called, he also justified; and those whom he justified, he also glorified. ");
INSERT INTO engtcent_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","What then shall we say in response to these things? If God is for us, who can be against us? ");
INSERT INTO engtcent_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","He who did not spare his own Son but delivered him up for us all, how will he not also, along with him, graciously give us all things? ");
INSERT INTO engtcent_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Who will bring an accusation against those whom God has chosen? It is God who justifies. ");
INSERT INTO engtcent_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Who is to condemn? Christ is the one who died, but more than that, he was raised and is at the right hand of God, interceding for us. ");
INSERT INTO engtcent_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Who can separate us from the love of Christ? Can tribulation, or distress, or persecution, or famine, or nakedness, or danger, or sword? ");
INSERT INTO engtcent_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","As it is written, “For yoʋr sake we face death all day long; we are regarded as sheep for slaughter.” ");
INSERT INTO engtcent_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Yet in all these things we are more than conquerors through him who loved us. ");
INSERT INTO engtcent_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","For I am persuaded that neither death, nor life, nor angels, nor rulers, nor powers, nor things present, nor things to come, ");
INSERT INTO engtcent_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nor height, nor depth, nor any other created thing, will be able to separate us from the love of God that is in Christ Jesus our Lord. ");
INSERT INTO engtcent_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","I am speaking the truth in Christ. My conscience confirms through the Holy Spirit that I am not lying when I say ");
INSERT INTO engtcent_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","that I have great sorrow and unceasing pain in my heart. ");
INSERT INTO engtcent_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","For I could wish that I myself were accursed, cut off from Christ for the sake of my brothers, my kinsmen according to the flesh. ");
INSERT INTO engtcent_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","They are Israelites, and to them belong the adoption as sons, the glory, the covenants, the giving of the law, the temple service, and the promises. ");
INSERT INTO engtcent_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","To them belong the patriarchs, and from them, according to the flesh, came the Christ, who is God over all, blessed forever. Amen. ");
INSERT INTO engtcent_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","It is not as though the word of God has failed. For not all Israelites truly belong to Israel, ");
INSERT INTO engtcent_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","and not all of Abraham's children are his true descendants, but, “Through Isaac yoʋr descendants will be counted.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","That is, it is not the children of the flesh who are the children of God; rather, the children of the promise are counted as descendants. ");
INSERT INTO engtcent_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","For this is what God promised: “About this time next year I will come, and Sarah will have a son.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Not only that, but when Rebecca had conceived by one man, our father Isaac, ");
INSERT INTO engtcent_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","though her sons were not yet born and had done nothing good or evil, in order for the purpose of God's choice to stand (not because of works but because of him who calls), ");
INSERT INTO engtcent_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","she was told, “The older will serve the younger.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","As it is written, “Jacob I loved, but Esau I hated.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","What then shall we say? Is there injustice with God? Certainly not! ");
INSERT INTO engtcent_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","For he says to Moses, “I will have mercy on whom I have mercy, and I will have compassion on whom I have compassion.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","So then, it does not depend on human will or effort, but on God's mercy. ");
INSERT INTO engtcent_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","For the Scripture says to Pharaoh, “I have raised yoʋ up for the very purpose of showing my power in yoʋ, so that my name might be declared in all the earth.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","So then, God has mercy on whom he wants to have mercy, and he hardens whom he wants to harden. ");
INSERT INTO engtcent_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Yoʋ will say to me then, “Why does he still find fault? For who can resist his will?” ");
INSERT INTO engtcent_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","On the contrary, O man, who are yoʋ to answer back to God? Shall the thing formed say to him who formed it, “Why did yoʋ make me like this?” ");
INSERT INTO engtcent_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Does the potter not have a right over the clay, to make out of the same lump one vessel for honorable use and another for dishonorable use? ");
INSERT INTO engtcent_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","What if God, although willing to show his wrath and to make his power known, endured with much patience vessels of wrath fitted for destruction, ");
INSERT INTO engtcent_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","in order to make known the riches of his glory upon vessels of mercy that he has prepared in advance for glory, ");
INSERT INTO engtcent_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","namely us whom he has called, not from the Jews only but also from the Gentiles? ");
INSERT INTO engtcent_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","As he says in Hosea, “Those who were ‘not my people’ I will call ‘my people,’ and those who were ‘not beloved’ I will call ‘beloved.’ ");
INSERT INTO engtcent_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","And in the place where it was said to them, ‘You are not my people,’ there they will be called ‘sons of the living God.’ ” ");
INSERT INTO engtcent_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","And Isaiah cries out concerning Israel, “Though the number of the sons of Israel be as the sand of the sea, only the remnant will be saved. ");
INSERT INTO engtcent_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","For the Lord will settle the matter swiftly and justly; his sentence will be executed upon the earth without delay.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","And just as Isaiah foretold, “If the Lord of hosts had not left us any descendants, we would have been like Sodom and become like Gomorrah.” ");
INSERT INTO engtcent_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","What then shall we say? That Gentiles who were not pursuing righteousness have obtained righteousness, that is, the righteousness that is by faith. ");
INSERT INTO engtcent_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","But Israel, although they pursued a law of righteousness, did not attain a law of righteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Why? Because they did not pursue it by faith, but as though it were by works of the law. They stumbled over the stone of stumbling, ");
INSERT INTO engtcent_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","as it is written, “Behold, I am placing in Zion a stone of stumbling and a rock of offense, yet no one who believes in him will be put to shame.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Brothers, the desire of my heart and my prayer to God is that Israel may be saved. ");
INSERT INTO engtcent_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","I can testify that they have a zeal for God, but not according to knowledge. ");
INSERT INTO engtcent_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","For they do not understand the righteousness of God, and by seeking to establish their own righteousness, they have not submitted to God's righteousness. ");
INSERT INTO engtcent_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","For Christ is the end of the law so that there may be righteousness for everyone who believes. ");
INSERT INTO engtcent_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moses writes about the righteousness that is by the law: “The person who does these things will live by them.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","But the righteousness that is by faith speaks like this: “Do not say in yoʋr heart, ‘Who will go up to heaven?’ ” (that is, to bring Christ down) ");
INSERT INTO engtcent_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“or, ‘Who will go down into the abyss?’ ” (that is, to bring Christ up from the dead). ");
INSERT INTO engtcent_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","But what does it say? “The word is near yoʋ, in yoʋr mouth and in yoʋr heart” (that is, the word of faith that we preach), ");
INSERT INTO engtcent_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","because if yoʋ confess with yoʋr mouth that Jesus is Lord and believe with yoʋr heart that God raised him from the dead, yoʋ will be saved. ");
INSERT INTO engtcent_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","For with the heart belief is exercised, resulting in righteousness; and with the mouth confession is made, resulting in salvation. ");
INSERT INTO engtcent_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","As the Scripture says, “No one who believes in him will be put to shame.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","For there is no distinction between Jew and Greek; the same Lord is Lord of all and richly blesses all who call upon him. ");
INSERT INTO engtcent_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","For “everyone who calls upon the name of the Lord will be saved.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","How then will they call upon him in whom they have not believed? And how will they believe in him whom they have not heard? And how will they hear without someone preaching? ");
INSERT INTO engtcent_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","And how will they preach unless they are sent? As it is written, “How beautiful are the feet of those who preach the gospel of peace, who preach good news of good things!” ");
INSERT INTO engtcent_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","But not all the Israelites have obeyed the gospel. For Isaiah says, “Lord, who has believed our report?” ");
INSERT INTO engtcent_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","So then, faith comes by hearing, and hearing comes through the word of God. ");
INSERT INTO engtcent_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","But I ask, have they not heard? On the contrary, “The message has gone out into all the earth, and the words to the ends of the world.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Again I ask, did Israel not understand? First Moses says, “I will provoke you to jealousy by that which is not a nation; by a nation that has no understanding I will provoke you to anger.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","And Isaiah is even bold enough to say, “I was found by those who were not seeking me; I became known to those who were not asking for me.” ");
INSERT INTO engtcent_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","But to Israel he says, “All day long I have held out my hands to a disobedient and contrary people.” ");
INSERT INTO engtcent_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","I ask then, has God rejected his people? Certainly not! For I too am an Israelite, a descendant of Abraham, of the tribe of Benjamin. ");
INSERT INTO engtcent_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","God has not rejected his people whom he foreknew. Do you not know what the Scripture says in the passage about Elijah, how he pleads with God against Israel, saying, ");
INSERT INTO engtcent_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Lord, they have killed yoʋr prophets and demolished yoʋr altars, and I alone am left, and they are seeking my life”? ");
INSERT INTO engtcent_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","But what does the divine response say to him? “I have reserved for myself seven thousand men who have not bowed down to Baal.” ");
INSERT INTO engtcent_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","So then, in the present time also there is a remnant chosen by grace. ");
INSERT INTO engtcent_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Now if it is by grace, it is no longer by works, otherwise grace would no longer be grace. But if it is by works, it is no longer grace, otherwise work would no longer be work. ");
INSERT INTO engtcent_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","What then? Israel did not obtain what it was seeking. The chosen obtained it, but the rest were hardened, ");
INSERT INTO engtcent_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","as it is written, “God gave them a spirit of stupor, eyes not to see and ears not to hear, down to this very day.” ");
INSERT INTO engtcent_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","And David says, “Let their table become a snare and a trap, a stumbling block and a retribution to them. ");
INSERT INTO engtcent_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Let their eyes be darkened so that they cannot see, and keep their backs forever bent.” ");
INSERT INTO engtcent_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","I ask then, did the Israelites stumble so as to fall? Certainly not! Rather, by their trespass salvation has come to the Gentiles, to provoke Israel to jealousy. ");
INSERT INTO engtcent_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Now if their trespass means riches for the world, and their loss means riches for the Gentiles, how much more will it mean when their full number is included? ");
INSERT INTO engtcent_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Now I am speaking to you who are Gentiles. Inasmuch as I am an apostle to the Gentiles, I glorify my ministry ");
INSERT INTO engtcent_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","if somehow I provoke my own people to jealousy and save some of them. ");
INSERT INTO engtcent_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","For if their rejection means reconciliation for the world, what will their acceptance mean but life from the dead? ");
INSERT INTO engtcent_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","If the dough offered as firstfruits is holy, so is the whole lump; and if the root is holy, so are the branches. ");
INSERT INTO engtcent_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Now if some of the branches have been broken off, and yoʋ, a wild olive branch, have been grafted in among them and have become a fellow partaker of the root and richness of the olive tree, ");
INSERT INTO engtcent_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","do not boast against the branches. But if yoʋ do boast against them, remember that yoʋ do not sustain the root, but the root sustains yoʋ. ");
INSERT INTO engtcent_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Yoʋ will say then, “Branches were broken off so that I could be grafted in.” ");
INSERT INTO engtcent_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Right! They were broken off because of unbelief, but yoʋ stand because of faith. So do not be arrogant, but be afraid. ");
INSERT INTO engtcent_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","For if God did not spare the natural branches, perhaps he will not spare yoʋ either. ");
INSERT INTO engtcent_vpl VALUES ("RM11_22